﻿USE sofia;
DROP TABLE IF EXISTS sofia.mai_vpl;
CREATE TABLE mai_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mai_vpl WRITE;
INSERT INTO mai_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","यीशु मसीहक वंशावली एहि तरहेँ अछि। ओ दाऊदक वंशज छलाह, आ दाऊद अब्राहमक वंशज*। ");
INSERT INTO mai_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहम सँ इसहाकक जन्‍म भेलनि। इसहाक सँ याकूबक, आ याकूब सँ यहूदा और हुनकर भाय सभक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदा सँ पेरस और जेरहक जन्‍म भेलनि, जिनकर सभक मायक नाम तामार छलनि। पेरस सँ हेस्रोनक आ हेस्रोन सँ अरामक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","अराम सँ अमीनादाबक, अमीनादाब सँ नहशोनक आ नहशोन सँ सलमोनक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सलमोन सँ बोअजक जन्‍म भेलनि, जिनकर माय राहाब छलीह। बोअज सँ ओबेदक जन्‍म भेलनि, जिनकर माय रूथ छलीह। ओबेद सँ यिशयक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","यिशय सँ राजा दाऊदक जन्‍म भेलनि। दाऊद सँ सुलेमानक जन्‍म भेलनि। सुलेमानक माय पहिने उरियाहक स्‍त्री भेल छलीह। ");
INSERT INTO mai_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सुलेमान सँ रेहोबामक, रेहोबाम सँ अबियाहक, और अबियाह सँ आसाक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","आसा सँ यहोशाफातक, यहोशाफात सँ योरामक, आ योराम सँ उजियाहक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उजियाह सँ योतामक, योताम सँ आहाजक, और आहाज सँ हिजकियाहक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हिजकियाह सँ मनश्‍शेक, मनश्‍शे सँ आमोनक, और आमोन सँ योशियाहक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","जाहि समय मे इस्राएली सभ बन्‍दीक रूप मे बेबिलोन देश लऽ जायल गेलाह, ताहि समय मे योशियाह सँ यकोन्‍याह आ हुनकर भाय सभक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","इस्राएली सभ केँ बेबिलोन मे लऽ जायल गेलाक बाद यकोन्‍याह सँ शालतिएलक, आ शालतिएल सँ जरुब्‍बाबेलक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","जरुब्‍बाबेल सँ अबीहूदक, अबीहूद सँ एलयाकीमक, और एलयाकीम सँ अजोरक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","अजोर सँ सदोकक, सदोक सँ अखीमक, और अखीम सँ एलिहूदक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","एलिहूद सँ एलिआजरक, एलिआजर सँ मत्तानक, और मत्तान सँ याकूबक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","याकूब सँ यूसुफक जन्‍म भेलनि, जे मरियमक पति भेलाह, आ मरियम सँ यीशुक जन्‍म भेलनि जे “मसीह” कहबैत छथि। ");
INSERT INTO mai_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","एहि तरहेँ गनला सँ अब्राहम सँ दाऊद धरि चौदह पीढ़ी, दाऊद सँ बेबिलोनक बन्‍दी जीवन धरि चौदह पीढ़ी आ बेबिलोनक बन्‍दी जीवन सँ उद्धारकर्ता-मसीह धरि चौदह पीढ़ी होइत अछि। ");
INSERT INTO mai_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","यीशु मसीहक जन्‍मक वृत्तान्‍त एना अछि—हुनकर माय मरियमक विवाह यूसुफ सँ होयब निश्‍चित भेल रहनि। मुदा हुनका सभक वैवाहिक जीवनक सम्‍पर्क होयबा सँ पहिनहि मरियम परमेश्‍वरक पवित्र आत्‍मा द्वारा गर्भवती भऽ गेलीह। ");
INSERT INTO mai_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","हुनकर वर यूसुफ धार्मिक विचारक लोक होयबाक कारणेँ, मरियमक कोनो तरहक बदनामी नहि होनि, से सोचि, हुनका चुप-चाप त्‍यागि देबाक विचार कयलनि। ");
INSERT INTO mai_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ओ ई बात मोने-मोन सोचिए रहल छलाह कि परमेश्‍वरक एकटा स्‍वर्गदूत सपना मे दर्शन दऽ कऽ हुनका कहलथिन जे, “हौ दाऊदक वंशज यूसुफ, तोँ मरियम केँ अपन स्‍त्री मानि अपना लग आनऽ सँ नहि डेराह! कारण, जे हुनका गर्भ मे छनि से परमेश्‍वरक पवित्र आत्‍माक दिस सँ छनि। ");
INSERT INTO mai_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ओ एकटा पुत्र केँ जन्‍म देतीह, आ तोँ हुनकर नाम यीशु रखिहह, किएक तँ ओ अपन लोक सभ केँ ओकरा सभक पाप सँ मुक्‍ति देथिन।” ");
INSERT INTO mai_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ई सभ एहि लेल भेल जे, परमेश्‍वरक बात पूरा होअय जे ओ अपन प्रवक्‍ताक माध्‍यम सँ कहने छलाह— ");
INSERT INTO mai_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“देखह, एक कुमारि कन्‍या गर्भवती होयतीह, ओ एक पुत्र केँ जन्‍म देतीह आ हुनकर नाम ‘इम्‍मानुएल’ राखल जयतनि,” जकर अर्थ अछि, “परमेश्‍वर हमरा सभक संग छथि।” ");
INSERT INTO mai_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","तखन यूसुफ निन्‍द सँ जागि गेलाह आ परमेश्‍वरक स्‍वर्गदूतक आज्ञानुसार मरियम केँ अपना पत्‍नीक रूप मे अपना ओहिठाम लऽ अनलथिन। ");
INSERT INTO mai_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ओ मरियमक संग वैवाहिक जीवनक सम्‍बन्‍ध ताबत धरि स्‍थापित नहि कयलनि जाबत धरि मरियम पुत्र केँ जन्‍म नहि दऽ देलथिन। पुत्रक जन्‍म भेला पर यूसुफ हुनकर नाम यीशु रखलथिन। ");
INSERT INTO mai_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","राजा हेरोदक समय मे जहिया यहूदिया प्रदेशक बेतलेहम गाम मे यीशुक जन्‍म भेलनि, तहिया पूब देशक ज्‍योतिषी सभ यरूशलेम नगर मे अयलाह। ");
INSERT INTO mai_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ओ सभ लोक सभ सँ पुछलथिन जे, “यहूदी सभक नवजन्‍मल राजा कतऽ छथि? कारण, हम सभ पूब मे हुनकर तारा देखलहुँ आ हुनकर दर्शन करबाक लेल आयल छी।” ");
INSERT INTO mai_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","जखन राजा हेरोद ई समाचार सुनलनि तँ ओ अपने, आ यरूशलेमक सभ निवासी सेहो, घबड़ा गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","राजा हेरोद यहूदी सभक मुख्‍यपुरोहित लोकनि आ धर्मशिक्षक सभ केँ जमा कऽ कऽ पुछलथिन जे, “आबऽ वला उद्धारकर्ता-मसीहक जन्‍म कतऽ होयबाक चाहियनि?” ");
INSERT INTO mai_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","एहि पर ओ सभ कहलथिन जे, “यहूदिया प्रदेशक बेतलेहम गाम मे, कारण, धर्मशास्‍त्र मे परमेश्‍वरक प्रवक्‍ता ई लिखने छथि जे, ");
INSERT INTO mai_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘हे बेतलेहम, यहूदिया प्रदेशक गाम! तोँ यहूदिया प्रदेशक मुख्‍य नगर सभ मे सँ ककरो सँ कम नहि छह। कारण, तोरा मे सँ एक शासन करऽ वलाक जन्‍म होयतनि, जे हमर प्रजा इस्राएलक रखबार आ बाट देखौनिहार होयताह।’” ");
INSERT INTO mai_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","तखन राजा हेरोद ज्‍योतिषी सभ केँ बजा कऽ एकान्‍त मे पूछ-ताछ कऽ एहि बातक पता लगा लेलनि जे तारा हुनका सभ केँ ठीक कोन समय मे देखाइ देने छलनि। ");
INSERT INTO mai_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ओ हुनका सभ केँ ई कहि कऽ बेतलेहम पठौलथिन जे, “जाउ आ बालकक सम्‍बन्‍ध मे ठीक-ठीक पता लगाउ, और जखन ओ भेटि जाथि तँ हमरा खबरि करू, जाहि सँ हमहूँ जा कऽ हुनकर दर्शन करियनि।” ");
INSERT INTO mai_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","राजाक बात सुनि ओ सभ विदा भऽ गेलाह। जे तारा हुनका सभ केँ पूब मे देखाइ देने छलनि से हुनका सभक आगाँ-आगाँ बढ़ैत जाइत फेर देखाइ देलक, और जाहि घर मे ओ बालक छलाह ताहि सँ उपर पहुँचि रूकि गेल। ");
INSERT INTO mai_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ओ सभ तारा केँ देखि अति आनन्‍दित भेलाह। ");
INSERT INTO mai_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","घर मे प्रवेश कऽ ओ सभ बालक केँ हुनकर माय मरियमक संग देखलथिन। ओ सभ निहुड़ि कऽ बालक केँ प्रणाम कयलथिन और अपन-अपन बाकस खोलि सोन, धूप आ सुगन्‍धित तेलक चढ़ौना सभ बालक केँ चढ़ौलथिन। ");
INSERT INTO mai_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","तकरबाद सपना मे परमेश्‍वरक ई आदेश पाबि जे, राजा हेरोद लग घूमि कऽ नहि जाउ, ओ सभ दोसर रस्‍ता सँ अपन देश घूमि गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ज्‍योतिषी सभक चल गेलाक बाद परमेश्‍वरक एक स्‍वर्गदूत सपना मे यूसुफ केँ दर्शन देलथिन आ कहलथिन, “उठह, बालक आ हुनकर माय केँ लऽ कऽ एतऽ सँ भागह आ मिस्र देश मे चल जाह। जाबत तक हम घूमि अयबाक लेल नहि कहिअह ताबत ओतहि रहिहह। कारण, हेरोद एहि बालकक हत्‍या करबाक लेल हिनकर खोज कराबऽ वला अछि।” ");
INSERT INTO mai_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","यूसुफ उठलाह और रातिए मे बालक आ हुनकर माय केँ लऽ कऽ मिस्र देशक लेल विदा भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ओ राजा हेरोदक मृत्‍यु तक ओतहि रहलाह। एहि तरहेँ परमेश्‍वर जे बात अपन प्रवक्‍ताक माध्‍यम सँ कहने छलाह से पूरा भेल जे, “हम मिस्र देश सँ अपना पुत्र केँ बजौलहुँ।” ");
INSERT INTO mai_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","जखन राजा हेरोद देखलनि जे ज्‍योतिषी सभ हुनका धोखा दऽ देलकनि तखन ओ क्रोध सँ भरि गेलाह। ओ ज्‍योतिषी सभक देल गेल सूचनाक आधार पर हिसाब लगौलनि जे बालक दू वर्षक वा ओहि सँ छोट होयबाक चाही, तेँ ओ अपना सैनिक सभ केँ पठा कऽ बेतलेहम आ ओकर लग-पास वला गाम सभक ओहि सभ बालक केँ मरबा देलनि जे सभ दू वर्षक और ओहि सँ छोट छल। ");
INSERT INTO mai_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","एहि तरहेँ परमेश्‍वरक प्रवक्‍ता यर्मियाहक माध्‍यम सँ कहल ई बात पूरा भेल जे, ");
INSERT INTO mai_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामाह मे एक चीत्‍कार उठल, कन्‍ना-रोहटि और बड़का विलाप, राहेल अपन बालक सभक लेल कानि रहल अछि। ओ सान्‍त्‍वनाक बोल नहि सुनऽ चाहैत अछि, किएक तँ आब ओकर बेटा सभ जीवित नहि रहलैक।” ");
INSERT INTO mai_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","राजा हेरोदक मृत्‍युक बाद परमेश्‍वरक एकटा स्‍वर्गदूत मिस्र देश मे यूसुफ केँ सपना मे दर्शन दऽ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“उठह, बालक आ हुनकर माय केँ लऽ कऽ इस्राएल देश चल जाह, किएक तँ जे सभ बालक केँ जान सँ मारऽ चाहैत छल से सभ आब मरि गेल अछि।” ");
INSERT INTO mai_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","यूसुफ उठलाह और बालक आ हुनकर माय केँ लऽ कऽ इस्राएल देश चल अयलाह। ");
INSERT INTO mai_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","मुदा जखन ओ सुनलनि जे अरखिलाउस अपन पिता हेरोदक मृत्‍युक बाद यहूदिया प्रदेश मे राज्‍य कऽ रहल छथि तखन ओ ओतऽ जयबा सँ डेरयलाह। ओ फेर सपना मे परमेश्‍वरक आदेश पाबि गलील प्रदेश चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ओतऽ ओ नासरत नामक नगर मे रहऽ लगलाह। एहि तरहेँ परमेश्‍वरक प्रवक्‍ता लोकनिक माध्‍यम सँ कहल ई बात पूरा भेल जे, “ओ नासरी कहौताह।” ");
INSERT INTO mai_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ओहि समय मे बपतिस्‍मा देनिहार यूहन्‍ना यहूदिया प्रदेशक निर्जन क्षेत्र मे आबि प्रचार करऽ लगलाह जे, ");
INSERT INTO mai_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन करू, कारण, स्‍वर्गक राज्‍य लग आबि गेल अछि।” ");
INSERT INTO mai_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","यूहन्‍ना वैह व्‍यक्‍ति छथि जिनका सम्‍बन्‍ध मे परमेश्‍वरक प्रवक्‍ता यशायाह कहने छलाह, “निर्जन क्षेत्र मे केओ जोर सँ आवाज दऽ रहल अछि— ‘प्रभुक लेल मार्ग तैयार करू, हुनका लेल सोझ बाट बनाउ।’ ” ");
INSERT INTO mai_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","यूहन्‍ना ऊँटक रोंइयाँ सँ बनल वस्‍त्र पहिरैत छलाह। ओ डाँड़ मे चमड़ाक पट्टी बन्‍हने रहैत छलाह। फनिगा आ वन वला मधु हुनकर भोजन छलनि। ");
INSERT INTO mai_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","यरूशलेम, सम्‍पूर्ण यहूदिया प्रदेश, आ यरदन नदीक लग-पास मे पड़ऽ वला सम्‍पूर्ण क्षेत्रक लोक सभ हुनका लग आयल, ");
INSERT INTO mai_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","और अपन पाप स्‍वीकार करैत यरदन नदी मे हुनका सँ बपतिस्‍मा लेलक। ");
INSERT INTO mai_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","मुदा जखन यूहन्‍ना बहुतो फरिसी आ सदुकी पंथक लोक सभ केँ बपतिस्‍मा लेबाक लेल अपना लग अबैत देखलनि तँ ओ हुनका सभ केँ कहलथिन, “हे साँपक सन्‍तान सभ, तोरा सभ केँ परमेश्‍वरक आबऽ वला क्रोध सँ बचबाक लेल के सिखौलकह? ");
INSERT INTO mai_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","तोँ सभ जँ अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन कयने छह, तँ तकर प्रमाण अपना व्‍यवहार द्वारा देखाबह। ");
INSERT INTO mai_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","और अपना मोन मे एना सोचि निश्‍चिन्‍त नहि रहह जे, हमर सभक कुल-पिता अब्राहम छथि, कारण, हम तोरा सभ केँ कहि दैत छिअह जे, परमेश्‍वर एहि पाथर सभ मे सँ अब्राहमक लेल सन्‍तान उत्‍पन्‍न कऽ सकैत छथि। ");
INSERT INTO mai_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","गाछक जड़ि पर कुड़हरि रखा गेल अछि। प्रत्‍येक गाछ जे नीक फल नहि दैत अछि से काटल आ आगि मे फेकल जायत। ");
INSERT INTO mai_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“तोँ सभ अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन कयने छह, तकर चिन्‍ह स्‍वरूप हम तोरा सभ केँ पानि सँ बपतिस्‍मा दैत छिअह, मुदा हमरा बाद मे एक गोटे आबि रहल छथि जे हमरा सँ शक्‍तिशाली छथि। हम हुनकर जुत्तो उठाबऽ जोगरक नहि छियनि। ओ तोरा सभ केँ पवित्र आत्‍मा और आगि सँ बपतिस्‍मा देथुन। ");
INSERT INTO mai_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","हुनका हाथ मे सूप छनि। ओ अपन खरिहानक अन्‍न साफ करताह और गहुम केँ बखारी मे जमा करताह, मुदा भुस्‍सा केँ ओ ओहि आगि मे जरौताह जे कहियो नहि मिझायत।” ");
INSERT INTO mai_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","तखन यीशु यूहन्‍ना सँ बपतिस्‍मा लेबाक लेल गलील सँ यरदन नदी लग अयलाह। ");
INSERT INTO mai_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","मुदा यूहन्‍ना ई कहि कऽ हुनका रोकलथिन जे, “हमरा अहीं सँ बपतिस्‍मा लेबाक आवश्‍यकता अछि, और की, अहाँ हमरा सँ लेबाक लेल आयल छी?” ");
INSERT INTO mai_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","यीशु उत्तर देलथिन, “एखन एहिना होमऽ दिअ, कारण, अपना सभक लेल यैह उचित अछि जे एही तरहेँ धार्मिकताक सभ माँग केँ पूरा करी।” तखन यूहन्‍ना हुनकर बात मानि लेलथिन। ");
INSERT INTO mai_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","बपतिस्‍मा लेलाक बाद यीशु तुरत पानि सँ बाहर अयलाह। ओही क्षण मे आकाश खुजल और ओ परमेश्‍वरक आत्‍मा केँ परबाक रूप मे अपना पर उतरैत देखलनि। ");
INSERT INTO mai_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","तखने स्‍वर्ग सँ ई आवाज सुनाइ पड़ल, “ई हमर प्रिय पुत्र छथि, हिनका सँ हम बहुत प्रसन्‍न छी।” ");
INSERT INTO mai_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","तकरबाद पवित्र आत्‍मा यीशु केँ निर्जन क्षेत्र मे लऽ गेलथिन जाहि सँ शैतान द्वारा हुनका सँ पाप करयबाक कोशिश कयल जानि। ");
INSERT INTO mai_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ओहिठाम चालिस दिन आ चालिस राति उपास कयलाक बाद यीशु भुखायल छलाह। ");
INSERT INTO mai_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","जाँचऽ वला शैतान हुनका लग अयलनि आ कहलकनि, “जँ तोँ परमेश्‍वरक पुत्र छह तँ एहि पाथर सभ केँ रोटी बनि जयबाक आज्ञा दहक।” ");
INSERT INTO mai_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","यीशु उत्तर देलथिन, “धर्मशास्‍त्र मे लिखल अछि, ‘मनुष्‍य मात्र रोटी सँ नहि, बल्‍कि परमेश्‍वरक मुँह सँ निकलल प्रत्‍येक वचन सँ जीवित रहत।’” ");
INSERT INTO mai_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","तखन शैतान यीशु केँ पवित्र नगर मे लऽ गेलनि और मन्‍दिरक सभ सँ ऊँ‍च स्‍थान पर ठाढ़ कऽ कऽ कहलकनि, ");
INSERT INTO mai_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“जँ तोँ परमेश्‍वरक पुत्र छह तँ एतऽ सँ नीचाँ कुदि जाह। कारण, धर्मशास्‍त्र मे लिखल अछि जे, ‘परमेश्‍वर तोरा लेल स्‍वर्गदूत सभ केँ आज्ञा देथिन और ओ सभ अपना कोरा मे तोरा लोकि लेथुन, जाहि सँ पयर मे पाथर सँ चोट नहि लगतह।’” ");
INSERT INTO mai_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","यीशु ओकरा कहलथिन, “इहो लिखल अछि जे, ‘अपन प्रभु-परमेश्‍वरक जाँच नहि करहुन।’” ");
INSERT INTO mai_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","तखन शैतान हुनका बहुत ऊँच पहाड़ पर लऽ गेलनि और ओतऽ सँ संसारक सभ राज्‍य आ ओकर वैभव देखबैत ");
INSERT INTO mai_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","हुनका कहलकनि, “जँ तोँ हमरा सामने निहुरबह आ हमर उपासना करबह तँ हम ई सभ तोरा दऽ देबह।” ");
INSERT INTO mai_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","यीशु ओकरा कहलथिन, “हे शैतान, हमरा सोझाँ सँ दूर हो! कारण, धर्मशास्‍त्र मे ई लिखल अछि जे, ‘अपना प्रभु-परमेश्‍वरक उपासना करहुन, और मात्र हुनके सेवा करहुन।’” ");
INSERT INTO mai_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","तकरबाद शैतान यीशु लग सँ चल गेल, और स्‍वर्गदूत सभ आबि कऽ हुनकर सेवा करऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","जखन यीशु सुनलनि जे बपतिस्‍मा देनिहार यूहन्‍ना जहल मे बन्‍दी बना लेल गेल छथि तखन ओ गलील प्रदेश मे घूमि कऽ चल अयलाह। ");
INSERT INTO mai_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ओ नासरत नगर केँ छोड़ि कऽ कफरनहूम नगर मे रहऽ लगलाह। ई नगर जबूलून आ नप्‍ताली कुलक भूमि-क्षेत्र मे झीलक कछेर पर अछि। ");
INSERT INTO mai_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","एहि तरहेँ परमेश्‍वरक प्रवक्‍ता यशायाहक ई वचन पूरा भेल जे, ");
INSERT INTO mai_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“हे जबूलून आ नप्‍ताली कुलक भूमि-क्षेत्र! समुद्र दिस जाय वला रस्‍ता मे पड़ऽ वला यरदन नदीक ओहि पारक क्षेत्र, गैर-यहूदी जाति सभक गलील प्रदेश! ");
INSERT INTO mai_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","जे सभ अन्‍हार मे बसल छल, से सभ पैघ प्रकाश केँ देखलक अछि। जकरा सभ केँ मृत्‍युक अन्‍हार झँपने छलैक, तकरा सभ पर इजोत चमकल अछि।” ");
INSERT INTO mai_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ओही समय सँ यीशु प्रचार करऽ लगलाह जे, “अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन करू, कारण, स्‍वर्गक राज्‍य लग मे आबि गेल अछि।” ");
INSERT INTO mai_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","जखन यीशु गलील झीलक कछेर पर टहलैत छलाह तखन ओ दू भाइ केँ झील मे माछ पकड़बाक लेल जाल फेकैत देखलनि। ओ सभ मछबार छल। एकटाक नाम सिमोन, जकर दोसर नाम पत्रुस छलैक आ ओकर भायक नाम अन्‍द्रेयास छल। ");
INSERT INTO mai_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","यीशु ओकरा सभ केँ कहलथिन, “हमरा पाछाँ आउ। हम अहाँ सभ केँ मनुष्‍य केँ पकड़ऽ वला मछबार बना देब।” ");
INSERT INTO mai_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ओ सभ तुरत अपन जाल छोड़ि कऽ हुनका संग भऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ओतऽ सँ कनेक आगाँ बढ़लाक बाद यीशु अन्‍य दू भाय केँ देखलनि—याकूब आ यूहन्‍ना। ओ सभ जबदी नामक व्‍यक्‍तिक बेटा छल आ अपना बाबूक संग नाव मे जाल सरिअबैत छल। यीशु ओकरा सभ केँ अपना संग अयबाक लेल कहलथिन। ");
INSERT INTO mai_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ओहो सभ तुरत नाव आ अपन बाबू केँ छोड़ि कऽ यीशुक संग भऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","यीशु सम्‍पूर्ण गलील प्रदेश मे घूमि-घूमि कऽ यहूदी सभक सभाघर सभ मे शिक्षा देबऽ लगलाह, परमेश्‍वरक राज्‍यक शुभ समाचार सुनाबऽ लगलाह, आ लोक सभ केँ सभ तरहक बिमारी सँ छुटकारा देबऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","एहि तरहेँ हुनकर यश सम्‍पूर्ण सीरिया प्रदेश मे पसरि गेलनि। लोक बिमार सभ केँ जे विभिन्‍न प्रकारक रोग वा कष्‍ट सँ पीड़ित छल, वा जकरा सभ मे दुष्‍टात्‍मा छलैक, मिर्गी सँ पीड़ित छल वा लकवा मारल छल—सभ केँ यीशु लग अनैत छल, और यीशु ओकरा सभ केँ स्‍वस्‍थ कऽ दैत छलथिन। ");
INSERT INTO mai_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","गलील प्रदेश, “दस नगर” क्षेत्र, यरूशलेम नगर, यहूदिया प्रदेश और यरदन नदीक ओहि पारक क्षेत्र सँ लोकक विशाल भीड़ हुनका पाछाँ चलऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","लोकक भीड़ केँ देखि कऽ यीशु पहाड़ पर चढ़ि गेलाह। ओ जखन बैसलाह तँ शिष्‍य सभ हुनका लग अयलथिन। ");
INSERT INTO mai_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","यीशु एहि तरहेँ हुनका सभ केँ उपदेश देबऽ लगलथिन— ");
INSERT INTO mai_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“धन्‍य अछि ओ सभ जे अपना केँ आत्‍मिक रूप सँ असहाय बुझैत अछि, किएक तँ स्‍वर्गक राज्‍य ओकरे सभक छैक। ");
INSERT INTO mai_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","धन्‍य अछि ओ सभ जे शोक करैत अछि, किएक तँ ओ सभ सान्‍त्‍वना पाओत। ");
INSERT INTO mai_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","धन्‍य अछि ओ सभ जे नम्र अछि, किएक तँ ओ सभ पृथ्‍वीक उत्तराधिकारी होयत। ");
INSERT INTO mai_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","धन्‍य अछि ओ सभ जे धार्मिकताक भूखल-पियासल अछि, किएक तँ ओ सभ तृप्‍त कयल जायत। ");
INSERT INTO mai_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","धन्‍य अछि ओ सभ जे दयावान अछि, किएक तँ ओकरा सभ पर दया कयल जयतैक। ");
INSERT INTO mai_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","धन्‍य अछि ओ सभ जकर हृदय शुद्ध छैक, किएक तँ ओ सभ परमेश्‍वर केँ देखत। ");
INSERT INTO mai_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","धन्‍य अछि ओ सभ जे मेल-मिलाप करबैत अछि, किएक तँ ओ सभ परमेश्‍वरक पुत्र कहाओत। ");
INSERT INTO mai_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","धन्‍य अछि ओ सभ जे धार्मिक रहबाक कारणेँ सताओल जाइत अछि, किएक तँ स्‍वर्गक राज्‍य ओकरे सभक छैक। ");
INSERT INTO mai_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“धन्‍य छी अहाँ सभ, जखन लोक सभ हमरा कारणेँ अहाँ सभ केँ अपमानित करत, सताओत और झूठ बाजि-बाजि कऽ अहाँ सभक विरोध मे लोक केँ सभ तरहक अधलाह बात कहतैक। ");
INSERT INTO mai_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","तखन खुशी होउ और आनन्‍द मनाउ, किएक तँ अहाँ सभक लेल स्‍वर्ग मे बड़का इनाम राखल अछि। एही तरहेँ लोक परमेश्‍वरक ओहि प्रवक्‍ता सभ केँ सेहो सतौने छलनि, जे सभ अहाँ सभ सँ पहिने प्राचीन समय मे छलाह। ");
INSERT INTO mai_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“अहाँ सभ पृथ्‍वीक नून छी। मुदा जँ नून मे नूनक स्‍वाद समाप्‍त भऽ जाइक तँ ओ कोन वस्‍तु सँ फेर नूनगर बनाओल जा सकत? ओकरा फेकि देल जाय, आ लोक ओकरा पयर सँ धाँगय, से छोड़ि ओ दोसर कोन काजक रहि जायत? ");
INSERT INTO mai_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“अहाँ सभ संसारक प्रकाश छी। पहाड़ परक नगर नुकायल नहि रहि सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","लोक डिबिया लेसि कऽ पथिया सँ नहि झँपैत अछि, बल्‍कि लाबनि पर रखैत अछि, और ओ डिबिया घर मे सभक लेल प्रकाश दैत छैक। ");
INSERT INTO mai_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","एहि तरहेँ अहूँ सभ अपन प्रकाश लोकक बीच चमकाउ, जाहि सँ लोक अहाँ सभक नीक काज देखि कऽ, अहाँक पिताक, जे स्‍वर्ग मे छथि, तिनकर स्‍तुति करनि। ");
INSERT INTO mai_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ई नहि सोचू जे हम मूसा द्वारा देल धर्म-नियम अथवा परमेश्‍वरक प्रवक्‍ता सभक लेख सभ केँ रद्द करबाक लेल आयल छी। हम ओहि सभ केँ रद्द नहि, बल्‍कि पूरा करबाक लेल आयल छी। ");
INSERT INTO mai_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","हम अहाँ सभ केँ सत्‍य कहैत छी, जाबत तक आकाश आ पृथ्‍वी समाप्‍त नहि होयत, ताबत तक धर्म-नियम मे लिखल सभ बात बिनु पूरा भेने ओकर एक मात्रा वा एक बिन्‍दुओ नहि मेटायत। ");
INSERT INTO mai_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","जे केओ एहि आज्ञा मे सँ छोटो सँ छोट आज्ञाक उल्‍लंघन करत और दोसरो लोक केँ तहिना करऽ लेल सिखाओत, से स्‍वर्गक राज्‍य मे सभ सँ छोट कहाओत। मुदा जे केओ एहि आज्ञा सभक पालन करत आ दोसरो लोक केँ तहिना करऽ लेल सिखाओत, से स्‍वर्गक राज्‍य मे पैघ कहाओत। ");
INSERT INTO mai_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","हम अहाँ सभ केँ कहैत छी जे, परमेश्‍वरक नजरि मे धार्मिक ठहरबाक लेल जे बात आवश्‍यक अछि, से जँ अहाँ सभ धर्मशिक्षक आ फरिसी सभ सँ बढ़ि कऽ पूरा नहि करब, तँ अहाँ सभ स्‍वर्गक राज्‍य मे किन्‍नहुँ नहि प्रवेश करब। ");
INSERT INTO mai_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“अहाँ सभ सुनने छी जे प्राचीन काल मे पुरखा सभ केँ कहल गेल छलनि, ‘हत्‍या नहि करह, और जे केओ हत्‍या करत तकरा कचहरी मे दण्‍डक योग्‍य ठहराओल जयतैक।’ ");
INSERT INTO mai_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","मुदा हम अहाँ सभ केँ कहैत छी, जे केओ अपना भाय पर क्रोधो करत तकरा कचहरी मे दण्‍डक योग्‍य ठहराओल जयतैक। जे अपन भाय केँ ‘रे मूर्ख’ कहत, तकरा धर्म-महासभा मे ठाढ़ होमऽ पड़तैक, और जे केओ अपना भाय केँ सराप देत, से नरकक आगि मे खसयबा जोगरक अछि। ");
INSERT INTO mai_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“तेँ जँ अहाँ अपन चढ़ौना प्रभुक वेदी पर अर्पण कऽ रहल छी आ ओतहि अहाँ केँ मोन पड़ल जे अहाँक भाय केँ अहाँ सँ कोनो सिकायत छैक, ");
INSERT INTO mai_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","तँ अपन चढ़ौना वेदीक कात मे राखि दिअ आ पहिने जा कऽ अपना भाय सँ मेल करू और तकरबाद आबि कऽ अपन चढ़ौना चढ़ाउ। ");
INSERT INTO mai_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“जखन अहाँक विरोधी अहाँ केँ कचहरी मे लऽ जा रहल अछि, तँ रस्‍ते मे ओकरा संग जल्‍दी सँ मेल-मिलाप कऽ लिअ। एना नहि होअय जे विरोधी अहाँ केँ न्‍यायाधीशक जिम्‍मा मे लगा दय आ न्‍यायाधीश सिपाहीक जिम्‍मा मे, और अहाँ केँ जहल मे राखि देल जाय। ");
INSERT INTO mai_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","हम अहाँ केँ सत्‍य कहैत छी जे, जाबत तक अहाँ पाइ-पाइ कऽ सधा नहि देबैक, ताबत तक अहाँ ओतऽ सँ नहि छुटब। ");
INSERT INTO mai_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“अहाँ सभ सुनने छी जे कहल गेल, ‘परस्‍त्रीगमन नहि करह।’ ");
INSERT INTO mai_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","मुदा हम अहाँ सभ केँ कहैत छी जे, जे कोनो पुरुष कोनो स्‍त्री केँ अधलाह इच्‍छा सँ देखैत अछि, से तखने अपना मोन मे ओकरा संग परस्‍त्रीगमन कऽ लेलक। ");
INSERT INTO mai_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","जँ अहाँक दहिना आँखि अहाँ केँ पाप मे फँसबैत अछि तँ ओकरा निकालि कऽ फेकि दिअ। अहाँक शरीरक एके अंग नष्‍ट भऽ जाओ, से अहाँक लेल एहि सँ नीक होयत जे सम्‍पूर्ण शरीर नरक मे फेकि देल जाय। ");
INSERT INTO mai_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","जँ अहाँक दहिना हाथ अहाँ केँ पाप मे फँसबैत अछि तँ ओकरा काटि कऽ फेकि दिअ। अहाँक शरीरक एके अंग नष्‍ट भऽ जाओ, से अहाँक लेल एहि सँ नीक होयत जे सम्‍पूर्ण शरीर नरक मे फेकि देल जाय। ");
INSERT INTO mai_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“कहल गेल अछि जे, ‘जे पुरुष अपना स्‍त्री केँ तलाक दैत अछि, से तलाकनामा लिखि कऽ दैक।’ ");
INSERT INTO mai_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","मुदा हम अहाँ सभ केँ कहैत छी जे, स्‍त्री केँ दोसराक संग गलत शारीरिक सम्‍बन्‍ध रखबाक कारण केँ छोड़ि कऽ जँ कोनो दोसर कारण सँ कोनो पुरुष अपना स्‍त्री केँ तलाक दैत अछि, तँ ओ अपना स्‍त्री केँ परपुरुषगमन करऽ वाली बनबाक लेल विवश करैत अछि, और जे केओ ओहि तलाक देल स्‍त्री सँ विवाह करैत अछि, सेहो परस्‍त्रीगमन करैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“अहाँ सभ इहो सुनने छी जे प्राचीन समयक पुरखा सभ केँ कहल गेल छलनि जे, ‘सपत खा कऽ जे वचन देलह तकरा नहि तोड़िहह, बल्‍कि प्रभु सँ खायल अपन सपत केँ पूरा करिहह।’ ");
INSERT INTO mai_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","मुदा हम अहाँ सभ केँ कहैत छी जे सपत खयबे नहि करू—ने स्‍वर्गक नाम लऽ कऽ, कारण ओ परमेश्‍वरक सिंहासन छनि, ");
INSERT INTO mai_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ने पृथ्‍वीक नाम लऽ कऽ, कारण ओ परमेश्‍वरक पयर तरक चौकी छनि, ने यरूशलेमक, कारण ओ महान् राजाक नगर छनि, ");
INSERT INTO mai_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","और ने अपन माथक, कारण अहाँ अपन एकोटा केश केँ ने तँ उज्‍जर आ ने कारी कऽ सकैत छी। ");
INSERT INTO mai_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","अहाँ सभ जखन ‘हँ’ कहऽ चाहैत छी, तँ बस, ‘हँ’ए कहू, जखन ‘नहि’ कहऽ चाहैत छी, तँ ‘नहि’ए कहू। एहि सँ बेसी जे किछु बजैत छी से शैतान सँ प्रेरित बात अछि। ");
INSERT INTO mai_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“अहाँ सभ सुनने छी जे एना कहल गेल छल, ‘केओ जँ ककरो आँखि फोड़य तँ ओकरो आँखि फोड़ल जाय, आ केओ जँ ककरो दाँत तोड़य तँ ओकरो दाँत तोड़ल जाय।’ ");
INSERT INTO mai_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","मुदा हम अहाँ सभ केँ कहैत छी, जँ कोनो दुष्‍ट लोक अहाँ केँ किछु करओ, तँ ओकर विरोध नहि करू। केओ जँ अहाँक दहिना गाल पर थप्‍पड़ मारय तँ ओकरा सामने दोसरो गाल कऽ दिऔक। ");
INSERT INTO mai_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","केओ जँ अहाँ पर मोकदमा कऽ अहाँक कुर्ता लेबऽ चाहय तँ ओकरा ओढ़नो लेबऽ दिऔक। ");
INSERT INTO mai_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","जँ केओ अहाँ सँ कोनो वस्‍तु जबरदस्‍ती एक कोस उघबाबय तँ अहाँ दू कोस उघि दिऔक। ");
INSERT INTO mai_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","जे केओ अहाँ सँ किछु मँगैत अछि तकरा दिऔक, आ जे केओ अहाँ सँ पैंच लेबऽ चाहैत अछि तकरा सँ मुँह नहि घुमाउ। ");
INSERT INTO mai_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“अहाँ सभ सुनने छी जे एना कहल गेल छल, ‘अपना पड़ोसी सँ प्रेम करह आ अपन शत्रु सँ दुश्‍मनी राखह।’ ");
INSERT INTO mai_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","मुदा हम अहाँ सभ केँ कहैत छी, अपना शत्रु सभ सँ प्रेम करू आ अहाँ केँ जे सभ सतबैत अछि तकरा सभक लेल प्रभु सँ प्रार्थना करू। ");
INSERT INTO mai_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","तखने अहाँ स्‍वर्ग मे रहऽ वला अपन पिताक सन्‍तान बनब। कारण, ओ दुष्‍ट आ सज्‍जन दूनू पर अपन सूर्यक प्रकाश दैत छथि, आ धर्मी और अधर्मी दूनू पर वर्षा करबैत छथि। ");
INSERT INTO mai_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“जँ अहाँ मात्र ओकरे सभ सँ प्रेम करी जे अहाँ सँ प्रेम करैत अछि तँ अहाँ केँ परमेश्‍वर सँ की इनाम भेटत? की कर असूल कयनिहार ठकहारो सभ एहिना नहि करैत अछि? ");
INSERT INTO mai_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","आ जँ अहाँ मात्र अपने लोक सभक कुशल-मङलक पुछारी करैत छी तँ अहाँ कोन बड़का काज करैत छी? की परमेश्‍वर केँ नहि चिन्‍हऽ वला जातिक लोक सभ सेहो एहिना नहि करैत अछि? ");
INSERT INTO mai_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","तेँ अहाँ सभ सिद्ध बनू जेना स्‍वर्ग मे रहऽ वला अहाँ सभक पिता परमेश्‍वर सिद्ध छथि। ");
INSERT INTO mai_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“होसियार रहू, लोक केँ देखयबाक लेल अपन ‘धर्म-कर्म’ नहि करू, नहि तँ अहाँ केँ अपन पिता सँ, जे स्‍वर्ग मे छथि, कोनो फल नहि भेटत। ");
INSERT INTO mai_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“अहाँ जखन गरीब सभ केँ दान दैत छी तखन तकर ढोल नहि पिटू, जेना पाखण्‍डी लोक सभाघर मे और रस्‍ता सभ मे करैत रहैत अछि, जाहि सँ लोक ओकर प्रशंसा करैक। हम अहाँ सभ केँ सत्‍य कहैत छी, लोकक प्रशंसा पाबि ओ सभ ओहि सँ बेसी कोनो इनामक बाट बेकार ताकत। ");
INSERT INTO mai_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","“मुदा अहाँ जखन दान करी तखन अहाँक ई काज एतेक गुप्‍त होअय जे अहाँक बामा हाथ सेहो नहि जानय जे अहाँक दहिना हाथ की कऽ रहल अछि। तखन अहाँक पिता जे गुप्‍त काज केँ सेहो देखैत छथि, से अहाँ केँ तकर प्रतिफल देताह। ");
INSERT INTO mai_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“जखन परमेश्‍वर सँ प्रार्थना करी, तँ पाखण्‍डी जकाँ नहि बनू, किएक तँ ओ सभ सभाघर सभ मे आ चौक सभ पर ठाढ़ भऽ कऽ प्रार्थना कयनाइ बहुत पसन्‍द करैत अछि, जाहि सँ लोक ओकरा सभ केँ देखैक। हम अहाँ सभ केँ सत्‍य कहैत छी जे, लोक ओकरा सभ केँ देखलक, ओहि सँ बेसी ओ सभ कोनो इनामक बाट बेकार ताकत। ");
INSERT INTO mai_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“मुदा अहाँ जखन प्रार्थना करी, तँ अपना कोठरी मे जाउ, केबाड़ बन्‍द करू आ अपना पिता, जिनका केओ नहि देखि सकैत छनि, तिनका सँ प्रार्थना करू। अहाँक पिता जे गुप्‍त काज सेहो देखैत छथि, से अहाँ केँ तकर प्रतिफल देताह। ");
INSERT INTO mai_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","प्रार्थना करैत अहाँ सभ ओहि जाति सभक लोक जकाँ जे सभ जीवित परमेश्‍वर केँ नहि चिन्‍हैत अछि रट लगा कऽ बात नहि दोहरबैत रहू। ओ सभ तँ सोचैत अछि जे बहुत बजला सँ ओकर प्रार्थना सुनल जयतैक। ");
INSERT INTO mai_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","अहाँ सभ ओकरा सभ जकाँ नहि बनू। अहाँ सभक पिता तँ अहाँ सभक मँगनाइ सँ पहिनहि बुझैत रहैत छथि जे अहाँ सभ केँ कोन वस्‍तुक आवश्‍यकता अछि। ");
INSERT INTO mai_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","तेँ एहि तरहेँ प्रार्थना करू— ‘हे हमर सभक पिता, अहाँ जे स्‍वर्ग मे विराजमान छी, अहाँक नाम पवित्र मानल जाय, ");
INSERT INTO mai_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","अहाँक राज्‍य आबय, अहाँक इच्‍छा जहिना स्‍वर्ग मे पूरा होइत अछि, तहिना पृथ्‍वी पर सेहो पूरा होअय। ");
INSERT INTO mai_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","हमरा सभ केँ आइ भोजन दिअ, जे दिन प्रति दिन हमरा सभक लेल आवश्‍यक अछि। ");
INSERT INTO mai_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","हमर सभक अपराध क्षमा करू, जहिना हमहूँ सभ अपन अपराधी सभ केँ क्षमा कयने छिऐक। ");
INSERT INTO mai_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","हमरा सभ केँ पाप मे फँसाबऽ वला बात सँ दूर राखू, और दुष्‍ट सँ हमरा सभक रक्षा करू। किएक तँ राज्‍य, शक्‍ति आ महिमा युगानुयुग अहींक अछि, आमीन।’ ");
INSERT INTO mai_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","अहाँ सभ जँ लोकक अपराध क्षमा करब तँ अहाँ सभक पिता जे स्‍वर्ग मे छथि सेहो अहूँ सभक अपराध क्षमा करताह। ");
INSERT INTO mai_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","मुदा अहाँ सभ जँ लोकक अपराध क्षमा नहि करबैक, तँ अहाँ सभक पिता सेहो अहाँ सभक अपराध क्षमा नहि करताह। ");
INSERT INTO mai_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“अहाँ सभ जखन उपास करी तखन पाखण्‍डी सभ जकाँ मुँह लटकौने नहि रहू। कारण, ओ सभ अपन मुँह म्‍लान कयने रहैत अछि जाहि सँ लोक सभ बुझैक जे ओ उपास कयने अछि। हम अहाँ सभ केँ सत्‍य कहैत छी, लोक बुझलक, ओहि सँ बेसी ओ सभ कोनो इनामक बाट बेकार ताकत। ");
INSERT INTO mai_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","मुदा अहाँ जखन उपास करी तँ तेल-कुड़ लिअ आ अपन मुँह-हाथ धोउ, ");
INSERT INTO mai_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","जाहि सँ लोक नहि बुझय जे अहाँ उपास कयने छी, बल्‍कि मात्र अहाँक पिता, जिनका केओ नहि देखि सकैत छनि, से बुझथि। एहि सँ अहाँक पिता जे गुप्‍त काज केँ सेहो देखैत छथि, से अहाँ केँ प्रतिफल देताह। ");
INSERT INTO mai_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“पृथ्‍वी पर अपना लेल धन जमा नहि करू जतऽ कीड़ा आ बीझ ओकरा नष्‍ट कऽ दैत अछि, और चोर सेन्‍ह काटि कऽ ओकर चोरी कऽ लैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","बल्‍कि अपना लेल स्‍वर्ग मे धन जमा करू, जतऽ ने कीड़ा आ ने बीझ ओकरा नष्‍ट करैत अछि, आ ने चोर सेन्‍ह काटि कऽ ओकर चोरी करैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","कारण, जतऽ अहाँक धन अछि ततहि अहाँक मोनो लागल रहत। ");
INSERT INTO mai_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“शरीरक डिबिया आँखि अछि! जँ अहाँक आँखि ठीक अछि तँ अहाँक सम्‍पूर्ण शरीर इजोत मे रहत। ");
INSERT INTO mai_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","मुदा जँ अहाँक आँखि खराब भऽ जाय तँ अहाँक सम्‍पूर्ण शरीर अन्‍हार मे भऽ जायत, आ जँ अहाँक भितरी प्रकाश अन्‍हार बनि जाय तँ ई अन्‍हार कतेक भयंकर होयत! ");
INSERT INTO mai_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“कोनो खबास दूटा मालिकक सेवा एक संग नहि कऽ सकैत अछि। कारण, ओ एकटा सँ घृणा करत आ दोसर सँ प्रेम, अथवा पहिल केँ खूब मानत और दोसर केँ तुच्‍छ बुझत। अहाँ सभ परमेश्‍वर आ धन-सम्‍पत्ति दूनूक सेवा नहि कऽ सकैत छी। ");
INSERT INTO mai_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“एहि लेल हम अहाँ सभ केँ कहैत छी, अपना प्राणक लेल चिन्‍ता नहि करू जे हम की खायब वा की पीब, आ ने शरीरक लेल चिन्‍ता करू जे की पहिरब। की भोजन सँ प्राण, आ वस्‍त्र सँ शरीर बेसी मूल्‍यवान नहि अछि? ");
INSERT INTO mai_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","आकाशक चिड़ै सभ केँ देखू—ओ सभ ने बाउग करैत अछि, ने कटनी करैत अछि आ ने कोठी मे अन्‍न रखैत अछि, मुदा तैयो अहाँ सभक पिता जे स्‍वर्ग मे छथि से ओकर सभक पालन करैत छथिन। की अहाँ सभ चिड़ै सभ सँ बहुत मूल्‍यवान नहि छी? ");
INSERT INTO mai_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","चिन्‍ता कऽ कऽ अहाँ सभ मे सँ के अपना उमेर केँ एको घड़ी बढ़ा सकैत छी? ");
INSERT INTO mai_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“वस्‍त्रक लेल अहाँ चिन्‍ता किएक करैत छी? जंगलक फूल सभ केँ देखू जे ओ सभ कोन तरहेँ फुलाइत अछि। ओ सभ ने खटैत अछि, आ ने चर्खा कटैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","हम अहाँ सभ केँ कहैत छी जे, राजा सुलेमान सेहो अपन राजसी वस्‍त्र पहिरि कऽ एहि फूल सन सुन्‍दर नहि लगैत छलाह। ");
INSERT INTO mai_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","जँ परमेश्‍वर मैदानक घास, जे आइ अछि आ काल्‍हि आगि मे जराओल जायत, तकरा एहि तरहेँ हरियरी सँ भरल रखैत छथि, तँ ओ अहाँ सभ केँ आओर किएक नहि पहिरौताह-ओढ़ौताह? अहाँ सभ केँ कतेक कम विश्‍वास अछि! ");
INSERT INTO mai_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“एहि लेल चिन्‍ता नहि करू जे हम सभ की खायब, की पीब वा की पहिरब। ");
INSERT INTO mai_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","कारण, एहि सभ बातक पाछाँ तँ परमेश्‍वर केँ नहि चिन्‍हऽ वला जातिक लोक सभ पड़ल रहैत अछि। अहाँ सभक पिता जे स्‍वर्ग मे छथि से जनैत छथि जे अहाँ सभ केँ एहि बात सभक आवश्‍यकता अछि। ");
INSERT INTO mai_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","बल्‍कि सभ सँ पहिने परमेश्‍वरक राज्‍य पर, आ परमेश्‍वर जाहि प्रकारक धार्मिकता अहाँ सँ चाहैत छथि, ताहि पर मोन लगाउ, तँ ई सभ वस्‍तु सेहो अहाँ केँ देल जायत। ");
INSERT INTO mai_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“तेँ काल्‍हि की होयत तकर चिन्‍ता नहि करू, किएक तँ काल्‍हि अपन चिन्‍ता अपने कऽ लेत। आजुक लेल तँ अजुके दुःख बहुत अछि। ");
INSERT INTO mai_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ककरो दोषी नहि ठहराउ जाहि सँ अहूँ सभ दोषी नहि ठहराओल जाइ। ");
INSERT INTO mai_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","जाहि तरहेँ अहाँ दोषी ठहरायब ताहि तरहेँ अहूँ दोषी ठहराओल जायब, आ जाहि नाप सँ अहाँ नापब, सैह नाप अहूँ पर लागू होयत। ");
INSERT INTO mai_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“अहाँ अपन भायक आँखि मेहक काठक कुन्‍नी किएक देखैत छी? की अपना आँखि मेहक ढेंग नहि सुझाइत अछि? ");
INSERT INTO mai_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","अहाँ अपना भाय केँ कोना कहैत छी जे, ‘आउ, हम अहाँक आँखि मे सँ कुन्‍नी निकालि दैत छी,’ जखन कि अहाँक अपने आँखि मे ढेंग अछि? ");
INSERT INTO mai_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","हे पाखण्‍डी, पहिने अपना आँखि मेहक ढेंग निकालि लिअ, तखने अपन भायक आँखि मेहक कुन्‍नी निकालबाक लेल अहाँ ठीक सँ देखि सकब। ");
INSERT INTO mai_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“पवित्र वस्‍तु कुकुर सभ केँ नहि दिअ, आ ने अपन हीरा-मोती सुगरक आगाँ फेकू, नहि तँ एना नहि होअय जे ओ सभ पयर सँ ओकरा धाँगि दय आ घूमि कऽ अहाँ सभ केँ चीरि-फाड़ि दय। ");
INSERT INTO mai_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“माँगू तँ अहाँ सभ केँ देल जायत। ताकू तँ अहाँ सभ केँ भेटत। ढकढकाउ तँ अहाँ सभक लेल खोलल जायत। ");
INSERT INTO mai_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","कारण, जे केओ मँगैत अछि, से प्राप्‍त करैत अछि; जे केओ तकैत अछि, तकरा भेटैत छैक, और जे केओ ढकढकबैत अछि, तकरा लेल खोलल जाइत छैक। ");
INSERT INTO mai_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“की अहाँ सभ मे सँ केओ एहन लोक छी जे जँ अहाँक बेटा अहाँ सँ रोटी माँगय तँ ओकरा पाथर दिऐक? ");
INSERT INTO mai_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","वा माछ माँगय तँ साँप दिऐक? ");
INSERT INTO mai_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","जखन अहाँ सभ पापी होइतो अपना बच्‍चा सभ केँ नीक वस्‍तु सभ देनाइ जनैत छी, तँ अहाँ सभ सँ बढ़ि कऽ अहाँ सभक पिता जे स्‍वर्ग मे छथि, से मँगनिहार सभ केँ नीक वस्‍तु सभ किएक नहि देथिन? ");
INSERT INTO mai_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“जेहन व्‍यवहार अहाँ चाहैत छी जे लोक अहाँक संग करय, तेहने व्‍यवहार अहूँ लोकक संग करू, किएक तँ धर्म-नियमक आ परमेश्‍वरक प्रवक्‍ता सभक शिक्षाक निचोड़ यैह अछि। ");
INSERT INTO mai_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“छोट द्वारि सँ प्रवेश करू, कारण नमहर अछि ओ द्वारि आ चौरगर अछि ओ बाट जे विनाश मे लऽ जाइत अछि, और बहुतो लोक ओहि द्वारि सँ प्रवेश करैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","मुदा छोट अछि ओ द्वारि आ कम चौड़ा अछि ओ बाट जे जीवन मे लऽ जाइत अछि। और थोड़बे लोक ओहि द्वारि केँ ताकि पबैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ओहन लोक सँ सावधान रहू जे झूठ बाजि कऽ अपना केँ परमेश्‍वरक प्रवक्‍ता कहैत अछि। ओ सभ अहाँ सभक बीच भेँड़ाक वेष मे अबैत अछि, मुदा भीतर मे ओ सभ चीरि-फाड़ि देबऽ वला जंगली जानबर अछि। ");
INSERT INTO mai_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ओकर सभक काज सभ सँ अहाँ सभ ओकरा चिन्‍हि जायब। की काँटक गाछ सँ अंगूर तोड़ल जा सकैत अछि, वा कबछुआक लत्ती सँ अंजीर-फल? ");
INSERT INTO mai_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","एहि तरहेँ प्रत्‍येक नीक गाछ मे नीक फल आ खराब गाछ मे खराब फल फड़ैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ई तँ भइए नहि सकैत अछि जे नीक गाछ मे खराब फल फड़ैक आ खराब गाछ मे नीक फल। ");
INSERT INTO mai_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","जे गाछ नीक फल नहि दैत अछि से काटि कऽ आगि मे फेकल जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","तहिना एहन लोक सभ केँ अहाँ सभ ओकर सभक काज सभ सँ चिन्‍हि जायब। ");
INSERT INTO mai_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ई बात नहि अछि जे, जतेक लोक हमरा ‘हे प्रभु, हे प्रभु’ कहैत अछि, ताहि मे सँ सभ केओ स्‍वर्गक राज्‍य मे प्रवेश करत, बल्‍कि मात्र वैह सभ प्रवेश करत जे सभ हमर पिता जे स्‍वर्ग मे छथि तिनकर इच्‍छानुरूप चलैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","न्‍यायक दिन बहुतो लोक हमरा कहत, ‘हे प्रभु! हे प्रभु! की हम सभ अहाँक नाम लऽ कऽ भविष्‍यवाणी नहि कयलहुँ? की हम सभ अहाँक नाम लऽ कऽ दुष्‍टात्‍मा सभ केँ नहि निकाललहुँ? की हम सभ अहाँक नाम लऽ कऽ अनेको चमत्‍कार नहि कयलहुँ?’ ");
INSERT INTO mai_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","तखन हम ओकरा सभ केँ स्‍पष्‍ट कहबैक, ‘हम तोरा सभ केँ कहियो नहि चिन्‍हलिऔ। है कुकर्मी सभ, भाग हमरा लग सँ!’ ");
INSERT INTO mai_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“जे केओ हमर एहि उपदेश सभ केँ सुनैत अछि आ ओकर पालन करैत अछि, से ओहि बुद्धिमान मनुष्‍य जकाँ अछि जे अपन घर पाथर पर बनौलक। ");
INSERT INTO mai_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","बहुत जोरक वर्षा भेल, बाढ़ि आयल, अन्‍हड़-बिहारि चलल और ओहि घर सँ टकरायल, तैयो ओ घर नहि खसल, कारण ओकर न्‍यो पाथर पर राखल गेल छल। ");
INSERT INTO mai_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","मुदा जे केओ हमर एहि उपदेश सभ केँ सुनैत अछि आ ओकर पालन नहि करैत अछि, से ओहि मूर्ख मनुष्‍य जकाँ अछि, जे अपन घर बालु पर बनौलक। ");
INSERT INTO mai_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","जखन बहुत जोरक वर्षा भेल, बाढ़ि आयल, अन्‍हड़-बिहारि चलल आ ओहि घर सँ टकरायल तँ ओ घर खसि पड़ल आ पूरा नष्‍ट भऽ गेल।” ");
INSERT INTO mai_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","जखन यीशु ई उपदेशक बात सभ कहब समाप्‍त कयलनि तखन लोकक भीड़ हुनकर शिक्षा सँ चकित भेल, ");
INSERT INTO mai_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","कारण ओ धर्मशिक्षक सभ जकाँ नहि, बल्‍कि अधिकारपूर्बक उपदेश दैत छलाह। ");
INSERT INTO mai_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","यीशु जखन पहाड़ पर सँ नीचाँ उतरलाह तँ लोकक बड़का भीड़ हुनका पाछाँ चलऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","एक कुष्‍ठ-रोगी हुनका लग अयलनि आ निंघुड़ि कऽ प्रणाम करैत कहलकनि, “यौ प्रभु, अहाँ जँ चाही तँ हमरा शुद्ध कऽ सकैत छी।” ");
INSERT INTO mai_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","यीशु हाथ बढ़ा कऽ ओकरा छुबैत कहलथिन, “हम अवश्‍य चाहैत छिअह, तोँ शुद्ध भऽ जाह।” और ओ तुरत अपन रोग सँ शुद्ध भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","यीशु ओकरा कहलथिन, “सुनह, ककरो किछु कहिअहक नहि। जाह, अपना केँ पुरोहित केँ देखाबह, आ धर्म-नियम मे लिखल मूसाक आदेश अनुसार जे चढ़ौना चढ़यबाक अछि, से चढ़ाबह। एहि तरहेँ सभक लेल गवाही रहत जे तोँ शुद्ध भऽ गेल छह।” ");
INSERT INTO mai_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","यीशु जखन कफरनहूम नगर मे प्रवेश कयलनि तँ रोमी सेनाक एकटा कप्‍तान आबि हुनका सँ विनती कयलथिन, ");
INSERT INTO mai_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“हे प्रभु, हमर नोकर लकवा सँ पीड़ित भऽ घर मे पड़ल अछि आ महा कष्‍ट मे अछि।” ");
INSERT INTO mai_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","यीशु हुनका कहलथिन, “हम आबि ओकरा स्‍वस्‍थ कऽ देबैक।” ");
INSERT INTO mai_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","सेनाक कप्‍तान उत्तर देलथिन, “यौ प्रभु, हम एहि जोगरक नहि छी जे अपने हमरा घर पर आबी। अपने मात्र कहि देल जाओ आ हमर नोकर स्‍वस्‍थ भऽ जायत। ");
INSERT INTO mai_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","कारण हमहूँ शासनक अधीन मे छी, और हमरा अधीन मे सैनिक सभ अछि। हम एकटा केँ कहैत छिऐक, ‘जाह’ तँ ओ जाइत अछि आ दोसर केँ कहैत छिऐक, ‘आबह’ तँ ओ अबैत अछि। हम अपना नोकर केँ कहैत छिऐक, ‘ई काज करह’ तँ ओ करैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","हुनकर बात सुनि यीशु केँ आश्‍चर्य भेलनि आ ओ अपना पाछाँ चलऽ वला लोक सभ केँ कहलथिन, “हम अहाँ सभ केँ सत्‍य कहैत छी, हम इस्राएली सभ मे एहन विश्‍वास ककरो मे नहि देखलहुँ। ");
INSERT INTO mai_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","हम अहाँ सभ केँ कहैत छी, पूब आ पश्‍चिम सँ बहुत लोक आओत और अब्राहम, इसहाक आ याकूबक संग स्‍वर्गक राज्‍य मे भोज खयबाक लेल बैसत, ");
INSERT INTO mai_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","मुदा जे सभ ⌞अब्राहमक वंशज होयबाक कारणेँ⌟ राज्‍यक उत्तराधिकारी होयबाक चाही, से सभ बाहर अन्‍हार मे भगाओल जायत, जतऽ लोक कानत आ दाँत कटकटाओत।” ");
INSERT INTO mai_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","तकरबाद यीशु सेनाक कप्‍तान केँ कहलथिन, “जाउ, जेहन विश्‍वास अहाँ कयलहुँ अछि, अहाँक लेल ओहिना होयत।” ओही घड़ी हुनकर नोकर स्‍वस्‍थ भऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","यीशु जखन पत्रुसक घर मे अयलाह तँ देखैत छथि जे पत्रुसक सासु बोखार सँ पीड़ित भऽ ओछायन पर पड़ल छथि। ");
INSERT INTO mai_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","यीशु हुनकर हाथ केँ छुबि देलथिन आ हुनकर बोखार उतरि गेलनि। ओ उठि कऽ हिनकर सेवा-सत्‍कार करऽ लगलीह। ");
INSERT INTO mai_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","साँझ पड़ला पर लोक सभ बहुतो लोक केँ जकरा मे दुष्‍टात्‍मा छलैक यीशु लग अनलकनि। यीशु आज्ञा दऽ कऽ ओकरा सभ मे सँ दुष्‍टात्‍मा सभ केँ निकालि देलथिन और सभ रोगी केँ स्‍वस्‍थ कऽ देलथिन, ");
INSERT INTO mai_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","जाहि सँ परमेश्‍वरक प्रवक्‍ता यशायाहक ई वचन पूरा होअय जे, “ओ हमर सभक रोग-बिमारी अपना पर लऽ हमरा सभ सँ दूर हटा देलनि।” ");
INSERT INTO mai_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","जखन यीशु अपना चारू कात लोकक बड़का भीड़ देखलनि तँ अपना शिष्‍य सभ केँ झीलक ओहि पार चलबाक आदेश देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","तखन एकटा धर्मशिक्षक हुनका लग आबि कऽ कहलथिन, “गुरुजी, जतऽ कतौ अपने जायब, ततऽ हमहूँ अपनेक संग चलब।” ");
INSERT INTO mai_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","यीशु हुनका उत्तर देलथिन, “नढ़िया केँ सोन्‍हि छैक और आकाशक चिड़ै केँ खोंता, मुदा मनुष्‍य-पुत्र केँ मूड़िओ नुकयबाक जगह नहि छैक।” ");
INSERT INTO mai_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","केओ दोसर, हुनकर एकटा शिष्‍य, हुनका कहलकनि, “प्रभु, हमरा पहिने जा कऽ अपना बाबूक लास केँ गाड़ि आबऽ दिअ।” ");
INSERT INTO mai_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","यीशु ओकरा कहलथिन, “अहाँ हमरा पाछाँ आउ, आ मुरदा सभ केँ अपन मुरदा गाड़ऽ दिऔक।” ");
INSERT INTO mai_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","यीशु नाव पर चढ़लाह तँ शिष्‍य सभ सेहो हुनका संग विदा भेलथिन। ");
INSERT INTO mai_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","एकाएक झील मे बहुत बड़का अन्‍हड़-बिहारि उठल आ नाव लहरिक पानि सँ भरऽ लागल। मुदा यीशु सुतल छलाह। ");
INSERT INTO mai_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","शिष्‍य सभ आबि कऽ हुनका जगबैत कहलथिन, “प्रभु, हमरा सभ केँ बचाउ! हम सभ डुबऽ-डुबऽ पर छी!” ");
INSERT INTO mai_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","यीशु शिष्‍य सभ केँ कहलथिन, “अहाँ सभक विश्‍वास एतेक कम किएक अछि? अहाँ सभ एतेक डेरायल किएक छी?” तकरबाद यीशु उठि कऽ अन्‍हड़-बिहारि आ लहरि केँ डँटलथिन। अन्‍हड़-बिहारि थम्‍हि गेल आ सभ किछु एकदम शान्‍त भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","शिष्‍य सभ आश्‍चर्यित भऽ कहऽ लगलाह, “ई केहन मनुष्‍य छथि? अन्‍हड़-बिहारि आ लहरिओ हिनकर आदेश मानैत छनि!” ");
INSERT INTO mai_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","जखन यीशु झीलक ओहि पार गदरेनी सभक इलाका मे पहुँचलाह तँ दुष्‍टात्‍मा सँ ग्रसित दू व्‍यक्‍ति कबरिस्‍तान वला क्षेत्र सँ बहरा कऽ हुनका भेटलनि। ओ दूनू व्‍यक्‍ति एतेक उग्र छल जे लोक सभ डरेँ ओहि बाटे चलनाइ छोड़ि देने छल। ");
INSERT INTO mai_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ओ दूनू चिचिया उठल, “यौ परमेश्‍वरक पुत्र, हमरा सभ सँ अपने केँ कोन काज? की समय सँ पहिनहि अपने हमरा सभ केँ सतयबाक लेल एतऽ आयल छी?” ");
INSERT INTO mai_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ओहिठाम सँ कनेक दूर पर सुगरक बड़का झुण्‍ड चरि रहल छल। ");
INSERT INTO mai_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","दुष्‍टात्‍मा सभ यीशु सँ विनती कयलकनि, “जँ अहाँ हमरा सभ केँ भगाइए रहल छी तँ हमरा सभ केँ ओहि सुगरक झुण्‍ड मे पठा दिअ।” ");
INSERT INTO mai_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","यीशु ओकरा सभ केँ कहलथिन, “जो!” दुष्‍टात्‍मा सभ दूनू व्‍यक्‍ति मे सँ निकलि कऽ सुगरक झुण्‍ड मे प्रवेश कऽ गेल। सुगरक पूरा झुण्‍ड दौड़ि कऽ पहाड़ पर सँ झील मे खसल और डुबि कऽ मरि गेल। ");
INSERT INTO mai_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","तखन सुगर चराबऽ वला सभ भागल आ ई सभ समाचार नगर मे जा कऽ सुनाबऽ लागल। ओहि दूनू दुष्‍टात्‍मा लागल व्‍यक्‍ति केँ की भेलैक, सेहो सुनौलकैक। ");
INSERT INTO mai_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","एहि पर नगरक सभ लोक यीशु सँ भेँट करबाक लेल नगर सँ बाहर आबि गेल। यीशु केँ देखि ओ सभ हुनका सँ विनती करऽ लगलनि जे, “अहाँ हमरा सभक इलाका सँ चल जाउ।” ");
INSERT INTO mai_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","तखन यीशु नाव मे चढ़ि कऽ झील पार कयलनि आ फेर अपना नगर मे चल अयलाह। ");
INSERT INTO mai_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","किछु लोक सभ एकटा लकवा मारल आदमी केँ खाट पर लदने यीशु लग अनलकनि। यीशु ओकरा सभक विश्‍वास देखि लकवा मारल आदमी केँ कहलथिन, “हौ बेटा, साहस राखह, तोहर पाप माफ भेलह।” ");
INSERT INTO mai_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ई सुनि किछु धर्मशिक्षक सभ अपना मोन मे सोचऽ लगलाह, “ई व्‍यक्‍ति तँ अपना केँ परमेश्‍वरक तुल्‍य बुझि हुनकर निन्‍दा करैत अछि!” ");
INSERT INTO mai_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","यीशु हुनकर सभक मोनक बात जानि कहलथिन, “अहाँ सभ अपना मोन मे अधलाह बात किएक सोचैत छी? ");
INSERT INTO mai_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","आसान की अछि—ई कहब जे, ‘तोहर पाप क्षमा भेलह’, वा ई कहब जे, ‘उठि कऽ चलह-फिरह’? ");
INSERT INTO mai_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","मुदा जाहि सँ अहाँ सभ ई बात बुझि जाइ जे मनुष्‍य-पुत्र केँ पृथ्‍वी पर पाप माफ करबाक अधिकार छनि, हम एकरा कहैत छी...” तखन ओ लकवाक रोगी केँ कहलथिन, “उठह, अपन खाट उठाबह आ घर चल जाह!” ");
INSERT INTO mai_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ओ उठल आ घर चल गेल। ");
INSERT INTO mai_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","लोक सभ ई देखि भयभीत भेल आ एहि लेल परमेश्‍वरक प्रशंसा करऽ लागल जे ओ मनुष्‍य केँ एहन अधिकार देने छथिन। ");
INSERT INTO mai_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ओहिठाम सँ आगाँ बढ़ला पर यीशु मत्ती नामक एक आदमी केँ कर असूल करऽ वला स्‍थान मे बैसल देखलथिन। यीशु हुनका कहलथिन, “हमरा पाछाँ आउ।” ओ उठि कऽ यीशुक संग चलऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","जखन यीशु मत्तीक घर मे भोजन करबाक लेल बैसलाह तँ बहुतो कर असूल कयनिहार आ “पापी” सभ आबि हुनका और हुनकर शिष्‍य सभक संग भोजन करबाक लेल बैसल। ");
INSERT INTO mai_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ई देखि फरिसी सभ यीशुक शिष्‍य सभ केँ कहलथिन, “अहाँ सभक गुरु कर असूल कयनिहार और पापी सभक संग किएक खाइत-पिबैत छथि?” ");
INSERT INTO mai_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","यीशु हुनकर सभक बात सुनि कहलथिन, “वैद्यक आवश्‍यकता स्‍वस्‍थ लोक केँ नहि होइत छैक, बल्‍कि बिमार सभ केँ! ");
INSERT INTO mai_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","अहाँ सभ जा कऽ प्रभुक कहल एहि वचनक अर्थ सिखू जे, ‘अहाँ सभक द्वारा अर्पित चढ़ौना वा बलि-प्रदान हम नहि चाहैत छी, बल्‍कि अहाँ सभ दयालु बनू, से।’ हम धार्मिक सभ केँ नहि, बल्‍कि पापी सभ केँ बजयबाक लेल आयल छी।” ");
INSERT INTO mai_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","बपतिस्‍मा देनिहार यूहन्‍नाक शिष्‍य सभ यीशु लग आबि कऽ पुछलथिन, “की कारण अछि जे हम सभ आ फरिसी सभ तँ उपास करैत रहैत छी, मुदा अहाँक शिष्‍य सभ उपास नहि करैत छथि?” ");
INSERT INTO mai_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","यीशु हुनका सभ केँ उत्तर देलथिन, “जाबत तक वरियातीक संग वर अछि ताबत तक की वरियाती शोक मनाओत? नहि! मुदा ओ समय आओत जहिया वर ओकरा सभक बीच सँ हटा लेल जायत। ओ सभ तहिये उपास करत। ");
INSERT INTO mai_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","केओ पुरान कपड़ा पर नयाँ कपड़ाक चेफरी नहि लगबैत अछि, कारण, ओ चेफरी घोकचि कऽ पुरान कपड़ा केँ खिचत और ओ कपड़ा पहिनहु सँ बेसी फाटि जायत। ");
INSERT INTO mai_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","एहि तरहेँ लोक नव दारू पुरान चमड़ाक थैली मे नहि रखैत अछि। कारण, एना जँ करत तँ चमड़ाक थैली फाटि जयतैक; दारू बहि जयतैक, आ थैलिओ नष्‍ट भऽ जयतैक। नहि! नव दारू नये थैली मे राखल जाइत अछि। एहि तरहेँ दारू आ थैली दूनू सुरक्षित रहैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","यीशु हुनका सभ केँ ई बात सभ कहिए रहल छलाह कि सभाघरक एक अधिकारी अयलथिन आ हुनका सामने ठेहुन रोपि कऽ कहलथिन, “हमर बेटी एखने तुरत मरि गेलि अछि, मुदा तैयो अपने चलि कऽ अपन हाथ ओकरा पर राखि देल जाओ—तँ ओ जीबि जायत।” ");
INSERT INTO mai_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","यीशु उठि कऽ अपना शिष्‍य सभक संग हुनका पाछाँ विदा भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","तखने एक स्‍त्री जकरा बारह वर्ष सँ खून खसऽ वला बिमारी छलैक, से पाछाँ सँ आयल आ यीशुक कपड़ाक कोर छुबि लेलक। ");
INSERT INTO mai_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ओ अपना मोन मे सोचि रहल छलि जे, “हम जँ हुनकर कपड़ो केँ छुबि लेब तँ स्‍वस्‍थ भऽ जायब।” ");
INSERT INTO mai_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","यीशु पाछाँ घूमि कऽ ओकरा देखलनि आ कहलथिन, “बेटी, साहस राखह, तोहर विश्‍वास तोरा स्‍वस्‍थ कऽ देलकह।” ओ स्‍त्री ओही घड़ी स्‍वस्‍थ भऽ गेलि। ");
INSERT INTO mai_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","यीशु सभाघरक अधिकारीक ओहिठाम पहुँचलाह तँ ओतऽ शोक मे बाँसुरी बजौनिहार सभ आ आरो लोक सभ केँ हल्‍ला-गुल्‍ला करैत देखलथिन। ");
INSERT INTO mai_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ओ कहलथिन, “हटै जाइ जाउ, बच्‍ची मरल नहि अछि; सुतल अछि।” एहि पर लोक सभ हुनका पर हँसऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","लोकक भीड़ जखन बाहर कयल गेल तँ यीशु घरक भीतर गेलाह। ओ बच्‍चीक हाथ पकड़ि कऽ उठौलथिन और बच्‍ची उठि बैसलि। ");
INSERT INTO mai_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ई समाचार ओहि प्रान्‍तक कोना-कोना मे पसरि गेल। ");
INSERT INTO mai_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","यीशु ओतऽ सँ आगाँ बढ़लाह तँ दू आन्‍हर व्‍यक्‍ति एहि तरहेँ सोर पारैत हुनका पाछाँ-पाछाँ चलऽ लगलनि जे, “यौ दाऊदक पुत्र, हमरा सभ पर दया करू!” ");
INSERT INTO mai_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","यीशु जखन घर मे गेलाह तँ ओ आन्‍हर व्‍यक्‍ति सभ हुनका लग अयलनि। यीशु ओकरा सभ सँ पुछलथिन, “की तोरा सभ केँ विश्‍वास छह जे हम ई काज कऽ सकैत छी?” ओ सभ कहलकनि, “हँ, प्रभु।” ");
INSERT INTO mai_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तखन यीशु ओकर सभक आँखि केँ छुबैत कहलथिन, “जेहन तोहर सभक विश्‍वास छह तहिना तोरा सभक लेल होअह।” ");
INSERT INTO mai_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","एतबा कहैत देरी ओकर सभक आँखि ठीक भऽ गेलैक। यीशु ओकरा सभ केँ चेतावनी देलथिन जे, “सुनह, ई बात ककरो नहि कहिअहक।” ");
INSERT INTO mai_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","मुदा ओ सभ घर सँ निकलि कऽ सम्‍पूर्ण जिला मे हुनकर कीर्ति सुना देलकनि। ");
INSERT INTO mai_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ओ दूनू व्‍यक्‍ति केँ घर सँ निकलिते किछु लोक दुष्‍टात्‍मा सँ ग्रसित एक बौक आदमी केँ यीशु लग अनलकनि। ");
INSERT INTO mai_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","दुष्‍टात्‍मा केँ ओकरा मे सँ निकालि देल गेलाक बाद ओ बौक आदमी बाजऽ लागल। ई देखि भीड़क लोक सभ आश्‍चर्यित भऽ कहऽ लागल जे, “इस्राएल मे एहन बात कहियो नहि भेल छल।” ");
INSERT INTO mai_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","मुदा फरिसी सभ कहऽ लगलाह जे, “ई दुष्‍टात्‍मा सभक मुखियाक शक्‍ति सँ दुष्‍टात्‍मा सभ केँ निकालैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","यीशु नगर-नगर, गाम-गाम घुमऽ लगलाह। ओ यहूदी सभक सभाघर सभ मे उपदेश दैत छलाह, परमेश्‍वरक राज्‍यक शुभ समाचार सुनबैत छलाह आ लोक सभ केँ सभ तरहक कष्‍ट-बिमारी सँ मुक्‍त करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","लोकक भीड़ केँ देखि कऽ हुनका दया होइत छलनि, कारण ओ सभ पीड़ित आ असहाय छल—ओहि भेँड़ी सभ जकाँ जकर केओ चरबाह नहि होइक। ");
INSERT INTO mai_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","तखन ओ अपना शिष्‍य सभ केँ कहलथिन, “पाकल फसिल तँ बहुत अछि, मुदा काटऽ वला मजदूर कम अछि। ");
INSERT INTO mai_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","तेँ खेतक मालिक सँ प्रार्थना करिऔन जे ओ अपना खेत मे आरो मजदूर पठबथि।” ");
INSERT INTO mai_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","तखन यीशु अपन बारहो शिष्‍य केँ बजा कऽ दुष्‍टात्‍मा सभ केँ निकालबाक और सभ तरहक रोग-बिमारी केँ ठीक करबाक अधिकार देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","एहि बारह मसीह-दूतक नाम एहि तरहेँ अछि—पहिल सिमोन, जिनकर पत्रुस नाम सेहो छनि, और हुनकर भाय अन्‍द्रेयास; जबदीक बेटा याकूब आ हुनकर भाय यूहन्‍ना; ");
INSERT INTO mai_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","फिलिपुस और बरतुल्‍मै; थोमा आ कर असूल कयनिहार मत्ती; अल्‍फेयासक बेटा याकूब आ तद्दै; ");
INSERT INTO mai_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","“देश-भक्‍त” सिमोन आ यहूदा इस्‍करियोती जे बाद मे यीशुक संग विश्‍वासघात कयलकनि। ");
INSERT INTO mai_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","एहि बारह गोटे केँ यीशु ई आज्ञा दऽ कऽ पठौलथिन जे, “गैर-यहूदी सभक बीच नहि जाउ आ सामरी सभक कोनो नगर मे प्रवेश नहि करू, ");
INSERT INTO mai_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","बल्‍कि इस्राएल वंशक हेरायल भेँड़ा सभ लग जाउ। ");
INSERT INTO mai_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“जाइत-जाइत ई प्रचार करैत जाउ जे, ‘स्‍वर्गक राज्‍य लग आबि गेल अछि।’ ");
INSERT INTO mai_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","रोगी सभ केँ स्‍वस्‍थ करू, मुइल सभ केँ जिआउ, कुष्‍ठ-रोगी सभ केँ शुद्ध करू, लोक सभ मे सँ दुष्‍टात्‍मा सभ केँ निकालू। अहाँ सभ केँ जे किछु भेटल अछि से अहाँ सभ बिना मूल्‍य पौलहुँ, तँ अहूँ सभ बिना मूल्‍य दिअ। ");
INSERT INTO mai_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","अपना बटुआ मे सोन, चानी वा तामक पाइ-कौड़ी किछु नहि राखू। ");
INSERT INTO mai_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","बाटक लेल ने झोरी-झण्‍टा, ने दोसर अंगा, ने चप्‍पल आ ने लाठी, किछु नहि संग लिअ; कारण, मजदूर केँ भोजन पयबाक अधिकार छैक। ");
INSERT INTO mai_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","जाहि कोनो नगर वा गाम मे जायब, तँ एहन लोकक पता लगाउ जे शुभ समाचार सुनबाक लेल तैयार होअय, आ ताबत धरि ओही व्‍यक्‍तिक ओतऽ रहू जाबत धरि ओहि गाम सँ विदा नहि भऽ जायब। ");
INSERT INTO mai_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","घर मे पहुँचि कऽ सभ सँ पहिने शान्‍तिक आशीर्वाद दिअ। ");
INSERT INTO mai_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ओ घर जँ योग्‍य होअय तँ अपन शान्‍ति ओकरा पर रहऽ दिऔक, और जँ योग्‍य नहि होअय तँ अपन शान्‍ति घुमा लिअ। ");
INSERT INTO mai_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","जँ केओ अहाँ सभक स्‍वागत नहि करय आ अहाँ सभ जे कहऽ चाहैत छी, से नहि सुनय, तँ ओहि घर वा ओहि नगर सँ बहरयबा काल मे अपन पयरक गर्दा झाड़ि लेब। ");
INSERT INTO mai_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","हम अहाँ सभ केँ सत्‍य कहैत छी, न्‍यायक दिन ओहि नगरक दशा सँ सदोम आ गमोरा नगरक दशा सहबा जोगरक रहतैक। ");
INSERT INTO mai_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“देखू, हम अहाँ सभ केँ भेँड़ी जकाँ जंगली जानबर सभक बीच मे पठा रहल छी, तेँ अहाँ सभ साँप जकाँ होसियार आ परबा जकाँ निष्‍कपट बनू। ");
INSERT INTO mai_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“लोक सभ सँ सावधान रहू। कारण, ओ सभ अहाँ सभ केँ पकड़ि कऽ पंचायत मे पंच सभक समक्ष लऽ जायत आ अपना सभाघर सभ मे अहाँ सभ केँ कोड़ा सँ पिटबाओत। ");
INSERT INTO mai_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","हमरा कारणेँ राज्‍यपाल आ राजा सभक समक्ष अहाँ सभ केँ ठाढ़ कयल जायत और अहाँ सभ हुनका सभक सामने आ गैर-यहूदी सभक सामने हमरा बारे मे गवाही देब। ");
INSERT INTO mai_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","मुदा जखन ओ सभ अहाँ सभ केँ पकड़बाओत तँ अहाँ सभ चिन्‍ता नहि करू जे हम सभ कोना बाजब वा की बाजब। जे किछु अहाँ सभ केँ बजबाक होयत, से ओही क्षण अहाँ सभ केँ मोन मे दऽ देल जायत; ");
INSERT INTO mai_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","कारण, बाजऽ वला अहाँ सभ नहि, बल्‍कि अहाँ सभक पिता-परमेश्‍वरक आत्‍मा होयताह। ओ अहाँ सभक द्वारा बजताह। ");
INSERT INTO mai_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“भाय भाय केँ, बाबू अपना बेटा केँ मृत्‍युदण्‍डक लेल पकड़बाओत, आ बेटा-बेटी अपन माय-बाबूक विरोध मे ठाढ़ भऽ कऽ मरबाओत। ");
INSERT INTO mai_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","“अहाँ सभ सँ सभ केओ घृणा करत, एहि लेल जे अहाँ सभ हमर लोक छी। मुदा जे व्‍यक्‍ति अन्‍त तक अपना विश्‍वास मे स्‍थिर रहत से उद्धार पाओत। ");
INSERT INTO mai_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“जखन लोक सभ अहाँ सभ केँ कोनो नगर मे सताबऽ लागत तखन अहाँ सभ भागि कऽ दोसर नगर चल जाउ। हम अहाँ सभ केँ सत्‍य कहैत छी, अहाँ सभ इस्राएल देशक सभ नगर मे अपन काज समाप्‍तो नहि कयने रहब, ताबत मनुष्‍य-पुत्र फेर आबि जयताह। ");
INSERT INTO mai_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“चेला अपना गुरु सँ पैघ नहि होइत अछि आ ने दास अपना मालिक सँ। ");
INSERT INTO mai_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","चेला केँ अपन गुरुक बराबरि होयब आ दास केँ अपन मालिकक बराबरि होयब, एतबे बहुत अछि। जँ ओ सभ घरक मालिक केँ ‘दुष्‍टात्‍मा सभक मुखिया’ कहैत अछि तँ मालिकक परिवारक लोक केँ की-की नहि कहतैक! ");
INSERT INTO mai_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“एहि लेल ओकरा सभ सँ डेराउ नहि। एहन किछु नहि अछि जे झाँपल होअय आ उघारल नहि जायत, वा जे नुकाओल होअय आ प्रगट नहि कयल जायत। ");
INSERT INTO mai_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","जे किछु हम अहाँ सभ केँ अन्‍हार मे कहैत छी से अहाँ सभ इजोत मे कहू; जे किछु एकान्‍ती कऽ कऽ सुनने छी तकरा छत पर सँ घोषणा करू। ");
INSERT INTO mai_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ओकरा सभ सँ नहि डेराउ जे शरीर केँ मारि दैत अछि, मुदा आत्‍मा केँ नहि मारि सकैत अछि, बल्‍कि तिनका सँ डेराउ जे आत्‍मा आ शरीर, दूनू केँ नरक मे नष्‍ट कऽ सकैत छथि। ");
INSERT INTO mai_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","बगेड़ी कतेक मे भेटैत अछि?—एक पाइ मे दूटा! तैयो एकोटा बगेड़ी सेहो अहाँ सभक पिताक इच्‍छाक बिना जमीन पर नहि खसैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","अहाँ सभक माथक एक-एकटा केशो गनल अछि। ");
INSERT INTO mai_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","तेँ अहाँ सभ डेराउ नहि। अहाँ सभ बहुतो बगेड़ी सँ मूल्‍यवान छी! ");
INSERT INTO mai_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“जे केओ लोकक समक्ष हमरा अपन प्रभु मानि लेत, तकरा हमहूँ अपन स्‍वर्गीय पिताक समक्ष अपन लोक मानि लेबैक। ");
INSERT INTO mai_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","मुदा जे केओ लोकक समक्ष हमरा अस्‍वीकार करत, तकरा हमहूँ अपन स्‍वर्गीय पिताक समक्ष अस्‍वीकार करबैक। ");
INSERT INTO mai_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ई नहि बुझू जे हम पृथ्‍वी पर मेल-मिलाप करयबाक लेल आयल छी। नहि! मेल करयबाक लेल नहि, बल्‍कि तरुआरि चलबयबाक लेल हम आयल छी। ");
INSERT INTO mai_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","हम तँ एहि लेल आयल छी जे ‘बेटा केँ ओकर बाबूक, बेटी केँ ओकर मायक, आ पुतोहु केँ ओकर सासुक विरोधी बना दिऐक। ");
INSERT INTO mai_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","लोकक दुश्‍मन ओकर अपने घरक लोक होयतैक।’ ");
INSERT INTO mai_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“जे केओ हमरा सँ बेसी अपन माय-बाबू सँ प्रेम करैत अछि, से हमर शिष्‍य बनबाक योग्‍य नहि अछि। जे केओ हमरा सँ बेसी अपन धिआ-पुता सँ प्रेम करैत अछि, से हमर शिष्‍य बनबाक योग्‍य नहि अछि। ");
INSERT INTO mai_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","आ जे केओ हमरा कारणेँ दुःख उठयबाक आ प्राणो देबाक लेल तैयार भऽ हमरा पाछाँ नहि चलैत अछि, से हमर शिष्‍य बनबाक योग्‍य नहि अछि। ");
INSERT INTO mai_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","जे केओ अपन जीवन सुरक्षित रखैत अछि, से ओकरा गमाओत, आ जे अपन जीवन हमरा लेल गमबैत अछि, से ओकरा सुरक्षित राखत। ");
INSERT INTO mai_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“जे केओ अहाँ सभ केँ स्‍वीकार करैत अछि, से हमरा स्‍वीकार करैत अछि, आ जे हमरा स्‍वीकार करैत अछि, से तिनका स्‍वीकार करैत छनि जे हमरा पठौने छथि। ");
INSERT INTO mai_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जे केओ परमेश्‍वरक प्रवक्‍ता केँ एहि लेल स्‍वागत करत जे ओ व्‍यक्‍ति परमेश्‍वरक प्रवक्‍ता छथि, से प्रवक्‍ताक प्रतिफल पाओत; आ जे केओ धार्मिक व्‍यक्‍ति केँ एहि लेल स्‍वागत करत जे ओ धार्मिक व्‍यक्‍ति छथि, से धार्मिकक प्रतिफल पाओत। ");
INSERT INTO mai_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","जे केओ हमरा छोटो सँ छोट शिष्‍य सभ मे सँ ककरो एहि लेल एक लोटा ठण्‍ढा पानिओ पिआओत जे ओ हमर शिष्‍य अछि, हम अहाँ सभ केँ सत्‍ये कहैत छी जे, ओ अपना एहि सेवाक प्रतिफल अवश्‍य पाओत।” ");
INSERT INTO mai_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","यीशु अपन बारहो शिष्‍य केँ एहि तरहेँ आज्ञा सभ दऽ कऽ ओतऽ सँ चल गेलाह आ लग-पासक नगर सभ मे शिक्षा देबऽ लगलाह आ शुभ समाचार सुनाबऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","जखन बपतिस्‍मा देनिहार यूहन्‍ना जहल मे मसीहक काजक चर्चा सुनलनि तँ ओ अपन शिष्‍य सभ केँ यीशु लग ई पुछबाक लेल पठौलथिन जे, ");
INSERT INTO mai_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“ओ जे आबऽ वला छलाह, से की अहीं छी वा हम सभ दोसराक बाट ताकू?” ");
INSERT INTO mai_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","यीशु हुनका सभ केँ उत्तर देलथिन, “जे किछु अहाँ सभ सुनैत छी आ देखैत छी, से सभ बात यूहन्‍ना केँ जा कऽ सुना दिऔन— ");
INSERT INTO mai_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","आन्‍हर सभ देखि रहल अछि, नाङड़ सभ चलि-फिरि रहल अछि, कुष्‍ठ-रोगी सभ स्‍वस्‍थ कयल जा रहल अछि, बहीर सभ सुनि रहल अछि, मुइल सभ जिआओल जा रहल अछि आ असहाय सभ केँ शुभ समाचार सुनाओल जा रहल छैक। ");
INSERT INTO mai_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","धन्‍य अछि ओ जे हमरा कारणेँ अपना विश्‍वास केँ नहि छोड़ैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","यूहन्‍नाक शिष्‍य सभ जखन घूमि कऽ जा रहल छलाह तँ यीशु यूहन्‍नाक बारे मे भीड़क संग बात करैत पुछलथिन, “अहाँ सभ निर्जन क्षेत्र मे की देखबाक लेल गेल छलहुँ? हवा मे हिलैत खड़ही केँ? ");
INSERT INTO mai_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","तखन की देखऽ लेल निकलल छलहुँ? बढ़ियाँ-बढ़ियाँ वस्‍त्र पहिरने कोनो मनुष्‍य केँ? बढ़ियाँ वस्‍त्र पहिरऽ वला सभ तँ राजभवन मे भेटैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","तखन फेर, अहाँ सभ की देखबाक लेल गेल छलहुँ? की परमेश्‍वरक प्रवक्‍ता केँ? हँ, हम अहाँ सभ केँ कहैत छी जे प्रवक्‍तो सँ पैघ व्‍यक्‍ति केँ देखलहुँ। ");
INSERT INTO mai_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“ई वैह दूत छथि जिनका सम्‍बन्‍ध मे धर्मशास्‍त्र मे लिखल अछि, प्रभु कहैत छथि, ‘देखू, अहाँ सँ पहिने हम अपन दूत पठायब, जे अहाँक आगाँ-आगाँ अहाँक बाट तैयार करत।’ ");
INSERT INTO mai_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“हम अहाँ सभ केँ सत्‍ये कहैत छी जे मनुष्‍य सभ मे बपतिस्‍मा देनिहार यूहन्‍ना सँ पैघ केओ कहियो जन्‍म नहि लेने अछि, तैयो स्‍वर्गक राज्‍य मे जे सभ सँ छोट अछि से हुनका सँ पैघ अछि। ");
INSERT INTO mai_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","यूहन्‍नाक समय सँ लऽ कऽ आइ धरि स्‍वर्गक राज्‍य जोर-तोड़ सँ आगाँ बढ़ि रहल अछि; लोक सभ रेड़म-रेड़ा कऽ कऽ स्‍वर्गक राज्‍य पर अधिकार कऽ रहल अछि। ");
INSERT INTO mai_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","किएक तँ परमेश्‍वरक सभ प्रवक्‍ता लोकनिक लेख आ धर्म-नियम सेहो यूहन्‍नाक समय धरि स्‍वर्गक राज्‍यक भविष्‍यवाणी कयने अछि। ");
INSERT INTO mai_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","आ जँ अहाँ सभ ई बात स्‍वीकार करबाक लेल तैयार छी, तँ सुनू, यूहन्‍ना ओ एलियाह छथि, जे फेर आबऽ वला छलाह। ");
INSERT INTO mai_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","जकरा कान छैक, से सुनओ। ");
INSERT INTO mai_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“हम एहि पीढ़ीक लोकक तुलना कोन बात सँ करू? ई सभ तँ चौक-चौराहा पर खेलनिहार बच्‍चा सभ जकाँ अछि, जे एक-दोसर केँ सोर पारि कऽ कहैत अछि जे, ");
INSERT INTO mai_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘हम सभ तँ तोरा सभक लेल बाँसुरी बजौलिऔ, मुदा तोँ सभ नचलें नहि। हम सभ विलाप कयलिऔ, मुदा तोँ सभ छाती पिटलें नहि।’ ");
INSERT INTO mai_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“यूहन्‍ना लोक सभ जकाँ खाइत-पिबैत नहि अयलाह तँ अहाँ सभ कहैत छी जे, ओकरा मे दुष्‍टात्‍मा छैक। ");
INSERT INTO mai_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","मनुष्‍य-पुत्र खाइत-पिबैत आयल तँ अहाँ सभ कहैत छी जे, ‘यैह देखू, पेटू आ पिअक्‍कड़, कर असूल करऽ वला और पापी सभक संगी!’ मुदा परमेश्‍वरक बुद्धि ठीक अछि, से बात ओहि बुद्धिक काजे सभ सँ प्रमाणित होइत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","तकरबाद यीशु ओहि नगर सभ केँ, जाहि मे ओ सभ सँ बेसी चमत्‍कार वला काज सभ कयने छलाह, तकरा सभ केँ धिक्‍कारऽ लगलथिन, कारण, ओहि नगरक निवासी सभ अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन नहि कयने छल। ");
INSERT INTO mai_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“है खुराजीन नगर, तोरा धिक्‍कार छौक! है बेतसैदा नगर, तोरा धिक्‍कार छौक! किएक तँ जे चमत्‍कार सभ तोरा सभक बीच कयल गेल, से जँ सूर आ सीदोन नगर मे कयल गेल रहैत तँ ओ सभ बहुत पहिनहि चट्टी ओढ़ि छाउर पर बैसि कऽ हृदय-परिवर्तन कऽ लेने रहैत। ");
INSERT INTO mai_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","हम तोरा सभ केँ कहैत छिऔक जे, न्‍यायक दिन मे तोरा सभक अपेक्षा सूर आ सीदोन नगरक दशा सहबा जोगरक रहतैक। ");
INSERT INTO mai_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","आ तोँ, है कफरनहूम नगर! की तोँ स्‍वर्ग तक उठाओल जयबेँ? नहि, तोँ तँ पाताल मे खसाओल जयबेँ। कारण, जे चमत्‍कार सभ तोरा सभक बीच कयल गेल, से जँ सदोम नगर मे कयल गेल रहैत तँ ओ आइ धरि कायम रहैत। ");
INSERT INTO mai_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","तैयो हम तोरा कहैत छिऔक जे न्‍यायक दिन मे तोहर दशाक अपेक्षा सदोमक दशा सहबा जोगरक रहतैक।” ");
INSERT INTO mai_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","यीशु ओही समय मे कहलनि, “हे पिता, स्‍वर्ग आ पृथ्‍वीक मालिक, हम अहाँ केँ एहि लेल धन्‍यवाद दैत छी जे अहाँ ई बात सभ बुद्धिमान और विद्वान सभ सँ नुका कऽ रखलहुँ, मुदा बच्‍चा सभ पर प्रगट कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हँ पिता, कारण, अहाँ केँ एही बात सँ प्रसन्‍नता भेल। ");
INSERT INTO mai_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“हमरा पिता द्वारा सभ किछु हमरा हाथ मे सौंपल गेल अछि। पिता केँ छोड़ि पुत्र केँ आओर केओ नहि चिन्‍हैत अछि, आ तहिना पुत्र केँ छोड़ि पिता केँ आओर केओ नहि चिन्‍हैत छनि; हँ, मात्र पुत्र और जकरा सभ पर पुत्र हुनका प्रगट करऽ चाहय, से चिन्‍हैत छनि। ");
INSERT INTO mai_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“हे थाकल आ बोझ सँ पिचायल लोक सभ, हमरा लग आउ। हम अहाँ सभ केँ विश्राम देब। ");
INSERT INTO mai_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","हमर जुआ अपना उपर उठा लिअ आ हमरा सँ सिखू, किएक तँ हम स्‍वभाव सँ नम्र आ दयालु छी। अहाँ सभ अपना आत्‍माक लेल विश्राम पायब। ");
INSERT INTO mai_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","कारण, हमर जुआ आसान अछि आ हमर भार हल्‍लुक।” ");
INSERT INTO mai_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","करीब ओही समय मे यीशु विश्राम-दिन कऽ अपन शिष्‍य सभक संग खेत दऽ कऽ जा रहल छलाह। हुनका शिष्‍य सभ केँ भूख लगलनि तँ ओ सभ अन्‍नक बालि तोड़ि-तोड़ि कऽ खाय लगलाह। ");
INSERT INTO mai_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ई देखि फरिसी सभ यीशु केँ कहलथिन, “देखू, अहाँक शिष्‍य सभ ओ काज कऽ रहल अछि जे विश्राम-दिन मे करब धर्म-नियमक अनुसार मना अछि।” ");
INSERT INTO mai_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","यीशु हुनका सभ केँ उत्तर देलथिन, “की अहाँ सभ नहि पढ़ने छी जे दाऊद आ हुनकर संगी सभ जखन भुखायल छलाह तँ ओ की कयलनि? ");
INSERT INTO mai_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ओ परमेश्‍वरक भवन मे प्रवेश कयलनि आ अपना संगी सभक संग परमेश्‍वर केँ चढ़ाओल रोटी खयलनि, जकरा खायब हुनका सभक लेल मना छल, कारण खयबाक अधिकार मात्र पुरोहिते केँ छलनि। ");
INSERT INTO mai_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","अथवा की अहाँ सभ धर्म-नियम मे नहि पढ़ने छी जे पुरोहित मन्‍दिर मे विश्राम-दिन कऽ मन्‍दिरक काज सभ कऽ कऽ विश्राम-दिनक आज्ञा केँ तोड़ैत छथि आ तैयो निर्दोष रहैत छथि? ");
INSERT INTO mai_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","हम अहाँ सभ केँ कहैत छी जे एतऽ केओ एहन अछि जे मन्‍दिरो सँ पैघ अछि। ");
INSERT INTO mai_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","की अहाँ सभ धर्मशास्‍त्र मे लिखल परमेश्‍वरक बात नहि बुझैत छी जतऽ कहैत छथि जे, ‘हम अहाँ सभक द्वारा अर्पित चढ़ौना वा बलि-प्रदान नहि चाहैत छी, बल्‍कि अहाँ सभ दयालु बनू, से चाहैत छी।’? ई जँ बुझितहुँ तँ निर्दोष केँ दोषी नहि कहने रहितहुँ। ");
INSERT INTO mai_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","किएक तँ मनुष्‍य-पुत्र विश्रामो-दिनक मालिक छथि।” ");
INSERT INTO mai_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ओतऽ सँ आगाँ बढ़ि यीशु हुनका सभक सभाघर मे गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ओहिठाम एक व्‍यक्‍ति छल, जकर एकटा हाथ सुखायल छलैक। फरिसी सभ यीशु पर दोष लगयबाक उद्देश्‍य राखि हुनका सँ प्रश्‍न कयलनि जे, “की विश्राम-दिन मे रोगी केँ स्‍वस्‍थ करब धर्म-नियमक अनुसार उचित अछि?” ");
INSERT INTO mai_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","यीशु हुनका सभ केँ उत्तर देलथिन, “अहाँ सभ मे एहन के छी, जकरा लग एकटा भेँड़ा होइक आ ओ विश्राम-दिन कऽ जँ खधिया मे खसि पड़ैक तँ ओकरा पकड़ि कऽ बाहर नहि निकालब? ");
INSERT INTO mai_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","आ भेँड़ा सँ मनुष्‍य कतेक मूल्‍यवान अछि! तेँ विश्राम-दिन मे भलाइक काज करब उचित अछि।” ");
INSERT INTO mai_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","तकरबाद यीशु ओहि व्‍यक्‍ति केँ कहलथिन, “अपन हाथ बढ़ाबह।” ओ हाथ बढ़ौलक आ ओकर हाथ दोसर हाथ जकाँ एकदम ठीक भऽ गेलैक। ");
INSERT INTO mai_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","एहि पर फरिसी सभ बाहर चल गेलाह आ यीशु केँ कोना मारल जाय, तकर षड्‌यन्‍त्र रचऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","मुदा यीशु से बात बुझि ओतऽ सँ चल गेलाह। बहुतो लोक हुनका पाछाँ भऽ गेलनि आ यीशु सभ रोगी केँ स्‍वस्‍थ कऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ओ ओकरा सभ केँ कड़गर आदेश देलथिन जे, “हमरा बारे मे प्रचार नहि करिहह।” ");
INSERT INTO mai_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ई एहि लेल भेल जे परमेश्‍वरक ई वचन पूर्ण होअय जे ओ अपन प्रवक्‍ता यशायाहक माध्‍यम सँ कहने छलाह— ");
INSERT INTO mai_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“हमर सेवक केँ देखू, जिनका हम चुनने छी, हमरा लेल अति प्रिय, जिनका सँ हमर मोन प्रसन्‍न अछि। हम हुनका अपन आत्‍मा देबनि, आ ओ सभ जातिक लोकक लेल न्‍यायसंगत फैसला सुनौताह। ");
INSERT INTO mai_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ने ओ कोनो तरहक विवाद करताह आ ने चिचिअयताह, आ ने हुनकर जोर सँ बजबाक आवाज रस्‍ता पर ककरो सुनाइ देतैक। ");
INSERT INTO mai_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ओ थुरायल खड़ही केँ नहि तोड़ताह, आ ने झपलाइत दीप केँ मिझौताह, जाबत तक न्‍याय केँ विजयी नहि कऽ देताह। ");
INSERT INTO mai_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","पृथ्‍वीक सभ जातिक लोक हुनके पर आशा राखत।” ");
INSERT INTO mai_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","तखन लोक सभ दुष्‍टात्‍मा सँ ग्रसित एक आदमी केँ, जे आन्‍हर आ बौक छल, तकरा यीशु लग अनलकनि। यीशु ओकरा स्‍वस्‍थ कऽ देलथिन और ओ तखने बाजऽ आ देखऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","एहि पर ओतऽ जमा भेल लोकक भीड़ आश्‍चर्यित भऽ कहऽ लागल जे, “कतौ ई दाऊदक पुत्र तँ नहि छथि?!” ");
INSERT INTO mai_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","मुदा फरिसी सभ जखन लोकक ई बात सुनलनि तँ ओ सभ कहऽ लगलाह, “ओ तँ मात्र दुष्‍टात्‍मा सभक मुखिया बालजबूलक शक्‍ति सँ दुष्‍टात्‍मा सभ केँ निकालैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","यीशु हुनकर सभक मोनक विचार जानि कहलथिन, “जाहि राज्‍य मे फूट पड़ि जाय से नष्‍ट भऽ जायत, आ जाहि नगर वा घर मे फूट भऽ जाय से नहि टिकत। ");
INSERT INTO mai_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","जँ शैताने शैतान केँ निकालऽ लागत तँ मतलब भेल जे ओकरा मे फूट भऽ गेलैक, तखन ओकर राज्‍य कोना टिकल रहतैक? ");
INSERT INTO mai_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ठीक अछि, जँ हम बालजबूलक शक्‍ति सँ दुष्‍टात्‍मा सभ केँ निकालैत छी तँ अहाँ सभक लोक ककरा शक्‍ति सँ निकालैत अछि? वैह सभ अहाँ सभक फैसला करत। ");
INSERT INTO mai_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","मुदा जँ हम परमेश्‍वरक आत्‍माक शक्‍ति सँ दुष्‍टात्‍मा सभ केँ निकालैत छी तँ परमेश्‍वरक राज्‍य अहाँ सभक बीच आबि गेल अछि, से जानि लिअ। ");
INSERT INTO mai_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“वा कोनो डकैत, बलगर आदमीक घर मे पैसि कऽ जाबत तक ओ ओकरा बान्‍हि कऽ काबू मे नहि कऽ लेत, की ताबत तक ओकर सम्‍पत्ति लुटि कऽ लऽ जा सकत? बान्‍हि कऽ काबू मे कयलाक बादे ओकरा लुटि सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“जे केओ हमरा संग नहि अछि, से हमरा विरोध मे अछि। आ जे केओ हमरा संग जमा नहि करैत अछि, से छिड़िअबैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","तेँ हम अहाँ सभ केँ कहि दैत छी जे मनुष्‍यक सभ तरहक पाप आ निन्‍दाक बात क्षमा कयल जयतैक मुदा पवित्र आत्‍माक विरोध मे कयल निन्‍दाक बात क्षमा नहि कयल जयतैक। ");
INSERT INTO mai_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","मनुष्‍य-पुत्रक विरोध मे जँ केओ किछु बाजत, तँ ओकरा क्षमा कयल जयतैक। मुदा जँ केओ पवित्र आत्‍माक विरोध मे बाजत, तँ ओकरा ने एहि युग मे आ ने आबऽ वला युग मे क्षमा भेटतैक। ");
INSERT INTO mai_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“कोनो गाछ केँ नीक बुझैत छी तँ ओकर फल केँ सेहो नीक बुझू, अथवा ओकरा खराब बुझैत छी तँ ओकर फल केँ सेहो खराब बुझू, किएक तँ गाछ अपन फले सँ चिन्‍हल जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“है साँपक सन्‍तान सभ, अहाँ सभ दुष्‍ट भऽ नीक बात बाजि कोना सकैत छी? कारण, जे किछु ककरो हृदय मे भरल अछि, सैह मुँह सँ बहराइत छैक। ");
INSERT INTO mai_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","नीक मनुष्‍यक मोन मे नीके बातक भण्‍डार रहैत छैक आ ओ अपन भण्‍डार मे सँ नीक वस्‍तु सभ बाहर करैत अछि। अधलाह मनुष्‍यक मोन मे अधलाहे बातक भण्‍डार रहैत छैक आ ओ अपन भण्‍डार मे सँ अधलाह वस्‍तु सभ बाहर करैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","हम अहाँ सभ केँ कहैत छी, मनुष्‍य जे कोनो व्‍यर्थक बात बाजत, न्‍यायक दिन मे ओकरा तकर हिसाब देबऽ पड़तैक, ");
INSERT INTO mai_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","किएक तँ अहाँ अपन कहल बातक द्वारा निर्दोष और अपन कहल बातक द्वारा दोषी ठहराओल जायब।” ");
INSERT INTO mai_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","एहि पर किछु धर्मशिक्षक आ फरिसी सभ यीशु केँ कहलथिन, “यौ गुरुजी, हम सभ अहाँ सँ कोनो चमत्‍कार वला चिन्‍ह देखऽ चाहैत छी।” ");
INSERT INTO mai_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","यीशु उत्तर देलथिन, “एहि पीढ़ीक लोक सभ कतेक दुष्‍ट आ विश्‍वासघाती अछि जे चमत्‍कारपूर्ण चिन्‍ह मँगैत अछि! मुदा जे घटना परमेश्‍वरक प्रवक्‍ता योनाक संग भेल छलनि, से चिन्‍ह छोड़ि एकरा सभ केँ आओर कोनो चिन्‍ह नहि देखाओल जयतैक। ");
INSERT INTO mai_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","जाहि तरहेँ योना तीन दिन आ तीन राति विशाल माछक पेट मे रहलाह, तहिना मनुष्‍य-पुत्र तीन दिन आ तीन राति पृथ्‍वीक पेट मे रहत। ");
INSERT INTO mai_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","निनवे नगरक लोक सभ न्‍यायक दिन मे एहि पीढ़ीक लोकक संग ठाढ़ भऽ एकरा सभ केँ दोषी ठहराओत, किएक तँ निनवे नगरक लोक सभ योनाक प्रचारक बात सुनि अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन कयलक, आ देखू, एतऽ एखन केओ एहन अछि जे योनो सँ महान्‌ अछि। ");
INSERT INTO mai_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","न्‍यायक दिन मे दक्षिण देशक रानी एहि पीढ़ीक लोकक संग ठाढ़ भऽ एकरा सभ केँ दोषी ठहरौतीह, किएक तँ ओ सुलेमान राजाक बुद्धिक बात सुनबाक लेल पृथ्‍वीक दोसर कात सँ अयलीह, आ देखू, एतऽ एखन केओ अछि जे सुलेमानो सँ महान्‌ अछि। ");
INSERT INTO mai_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“दुष्‍टात्‍मा जखन कोनो मनुष्‍य मे सँ बहरा जाइत अछि तँ ओ निर्जन-स्‍थान मे आराम करबाक स्‍थानक खोज मे घुमैत रहैत अछि, मुदा ओकरा भेटैत नहि छैक। ");
INSERT INTO mai_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","तखन ओ कहैत अछि जे, ‘हम अपन पहिलुके घर मे, जतऽ सँ बहरा कऽ आयल छलहुँ, ततहि फेर जायब।’ तँ ओ जखन ओहिठाम पहुँचैत अछि तँ देखैत अछि जे ओहि घर मे केओ नहि अछि, घर झाड़ल-बहारल अछि, आ सभ वस्‍तु ढंग सँ राखल अछि। ");
INSERT INTO mai_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","तखन ओ जा कऽ अपनो सँ दुष्‍टाह सातटा आरो दुष्‍टात्‍मा केँ अपना संग लऽ अनैत अछि आ ओहि घर मे अपन डेरा खसा लैत अछि। एहि तरहेँ ओहि मनुष्‍यक ई दशा पहिलुको दशा सँ खराब भऽ जाइत छैक। एहि भ्रष्‍ट पीढ़ीक लोकक संग सेहो तहिना होयतैक।” ");
INSERT INTO mai_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","यीशु लोकक भीड़ सँ बात करिते छलाह कि हुनकर माय आ भाय सभ ओतऽ पहुँचलाह आ हुनका सँ गप्‍प करबाक लेल बाहर ठाढ़ रहलाह। ");
INSERT INTO mai_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","केओ यीशु केँ कहलकनि जे, “देखू, अहाँक माय आ भाय सभ बाहर ठाढ़ छथि आ अहाँ सँ बात करऽ चाहैत छथि।” ");
INSERT INTO mai_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","यीशु ओकरा उत्तर देलथिन, “के छथि हमर माय? के सभ छथि हमर भाय?” ");
INSERT INTO mai_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","तखन अपना शिष्‍य सभक दिस हाथ सँ इसारा करैत कहलनि, “देखू, यैह सभ हमर माय आ हमर भाय सभ छथि। ");
INSERT INTO mai_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","जे केओ हमर पिता, जे स्‍वर्ग मे छथि, तिनकर इच्‍छाक अनुसार चलैत छथि, वैह हमर भाय, हमर बहिन, हमर माय छथि।” ");
INSERT INTO mai_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ओही दिन यीशु घर सँ बहरा कऽ झीलक कछेर पर जा कऽ बैसलाह। ");
INSERT INTO mai_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","हुनका लग लोकक एतेक विशाल भीड़ आबि कऽ जमा भऽ गेल जे ओ नाव पर चढ़ि कऽ बैसलाह आ लोकक भीड़ झीलक कछेर पर ठाढ़ रहल। ");
INSERT INTO mai_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","यीशु विभिन्‍न तरहक दृष्‍टान्‍त सभक द्वारा लोक सभ केँ बहुतो बात सभ कहलथिन। ओ कहलथिन, “एक किसान बीया बाउग करबाक लेल गेल। ");
INSERT INTO mai_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","बीया बाउग करैत काल किछु बीया रस्‍ताक कात मे खसल आ चिड़ै सभ आबि ओकरा खा लेलकैक। ");
INSERT INTO mai_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","किछु बीया पथराह जमीन पर खसल जतऽ बेसी माटि नहि होयबाक कारणेँ ओ जल्‍दी जनमि गेल। ");
INSERT INTO mai_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","मुदा रौद लगिते ओ झरकि गेल आ जड़ि नहि पकड़ि सकबाक कारणेँ सुखा गेल। ");
INSERT INTO mai_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","फेर दोसर बीया काँट-कुशक बीच मे खसल मुदा काँट-कुश बढ़ि कऽ ओकरा दबा देलकैक। ");
INSERT INTO mai_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","किछु बीया नीक जमीन पर पड़ल आ फड़ल-फुलायल, कोनो सय गुना फसिल देलक, कोनो साठि गुना आ कोनो तीस गुना। ");
INSERT INTO mai_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","जकरा कान होइक, से सुनओ।” ");
INSERT INTO mai_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","यीशुक शिष्‍य सभ हुनका लग आबि कऽ पुछलथिन, “अहाँ लोक सभ सँ दृष्‍टान्‍त सभ मे किएक बात करैत छी?” ");
INSERT INTO mai_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","यीशु उत्तर देलथिन, “स्‍वर्गक राज्‍य जे अछि तकर रहस्‍यक ज्ञान तँ अहाँ सभ केँ देल गेल अछि, मुदा एकरा सभ केँ नहि देल गेल छैक। ");
INSERT INTO mai_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","तेँ जकरा छैक तकरा आओर देल जयतैक आ ओकरा लग बहुते भऽ जयतैक। मुदा जकरा नहि छैक तकरा सँ जेहो छैक सेहो लऽ लेल जयतैक। ");
INSERT INTO mai_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","हम एकरा सभ सँ दृष्‍टान्‍त सभ मे एहि लेल बात करैत छी जे, ‘ई सभ तकितो देखैत नहि अछि; आ सुनितो ने सुनैत अछि आ ने बुझैत अछि।’ ");
INSERT INTO mai_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","एकरा सभ मे यशायाहक ई भविष्‍यवाणी पूरा होइत अछि जे, ‘तोँ सभ सुनैत तँ रहबह मुदा बुझबह नहि, तोँ सभ देखैत तँ रहबह मुदा देखाइ देतह नहि।’ ");
INSERT INTO mai_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","‘कारण, एहि लोक सभक मोन मे ठेला पड़ि गेल छैक, ई सभ कान सँ उच्‍च सुनैत अछि, ई सभ अपन आँखि मुनि लेने अछि, जाहि सँ कतौ एना नहि होअय जे आँखि सँ देखय, कान सँ सुनय, मोन सँ बुझय, आ घूमि कऽ हमरा लग आबय, आ हम ओकरा सभ केँ स्‍वस्‍थ कऽ दिऐक।’ ");
INSERT INTO mai_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“मुदा धन्‍य छी अहाँ सभ जे आँखि सँ देखैत छी आ कान सँ सुनैत छी। ");
INSERT INTO mai_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","हम अहाँ सभ केँ सत्‍य कहैत छी जे, अपना समय मे परमेश्‍वरक एहन बहुतो प्रवक्‍ता आ धार्मिक लोक सभ रहथि जे सभ चाहलनि जे, जाहि बात सभ केँ अहाँ सभ देखि रहल छी, तकरा देखी, मुदा नहि देखलनि; और जाहि बात सभ केँ अहाँ सभ सुनि रहल छी, से सुनी, मुदा नहि सुनलनि। ");
INSERT INTO mai_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“आब अहाँ सभ बाउग कयनिहार वला दृष्‍टान्‍तक अर्थ सुनू। ");
INSERT INTO mai_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","जखन केओ परमेश्‍वरक राज्‍यक शुभ समाचार सुनैत अछि मुदा बुझैत नहि अछि, तखन शैतान आबि कऽ जे किछु ओकरा हृदय मे बाउग कयल गेल रहैत अछि से ओकरा सँ छिनि कऽ लऽ लैत अछि। ई वैह बीया भेल जे रस्‍ताक कात मे बाउग कयल गेल छल। ");
INSERT INTO mai_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","पथराह जमीन पर बाउग कयल बीया ओ व्‍यक्‍ति भेल जे परमेश्‍वरक शुभ समाचार सुनि कऽ तुरत आनन्‍दपूर्बक ओकरा ग्रहण कऽ लैत अछि, ");
INSERT INTO mai_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","मुदा ओ वचन ओकरा मे जड़ि नहि पकड़ैत छैक आ ओ कनेके काल स्‍थिर रहैत अछि। जखन शुभ समाचारक कारणेँ ओकरा कष्‍ट सहऽ पड़ैत छैक वा ओकरा संग अत्‍याचार होमऽ लगैत छैक तँ ओ तुरत विश्‍वास केँ छोड़ि दैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","काँट-कुशक बीच खसल बीया ओ मनुष्‍य भेल जे शुभ समाचार केँ सुनैत अछि मुदा सांसारिक चिन्‍ता आ धन-सम्‍पत्तिक मोह-माया ओहि शुभ समाचार केँ दबा दैत छैक और ओ वचन ओकरा जीवन मे कोनो फल नहि दैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","नीक जमीन मे बाउग कयल बीया ओ सभ अछि जे सभ शुभ समाचार सुनैत अछि और बुझैत अछि। ओ फड़ि-फुला कऽ फसिल दैत अछि, केओ सय गुना, केओ साठि गुना आ केओ तीस गुना।” ");
INSERT INTO mai_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","यीशु लोक सभक समक्ष दोसर दृष्‍टान्‍त रखलनि जे, “स्‍वर्गक राज्‍यक तुलना ओहि मनुष्‍य सँ कयल जा सकैत अछि जे अपना खेत मे नीक बीया बाउग कयलनि। ");
INSERT INTO mai_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","मुदा जखन सभ केओ सुति रहल छल तखन हुनकर दुश्‍मन अयलनि आ ओहि बाउग कयल गहुमक खेत मे जंगली बीया बाउग कऽ चल गेल। ");
INSERT INTO mai_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","जखन बाउग कयल गहुमक बीया जनमल आ ओहि मे बालि निकलल तखन जंगलिआ घास सेहो देखाइ देलक। ");
INSERT INTO mai_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ई देखि नोकर सभ मालिक केँ कहलकनि, ‘मालिक, की अपने अपना खेत मे बढ़ियाँ बीया बाउग नहि कयने छलहुँ? तँ एहि मे जंगलिआ घास कतऽ सँ आबि गेल?’ ");
INSERT INTO mai_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","मालिक कहलथिन, ‘ई कोनो दुश्‍मनक काज अछि!’ नोकर सभ कहलकनि, ‘तँ की, ओकरा उखाड़ि दिऐक?’ ");
INSERT INTO mai_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ओ कहलथिन, ‘नहि। कतौ एना नहि भऽ जाओ जे जंगलिआ घास उखाड़ैत काल तोँ सभ गहुमोक गाछ सभ केँ उखाड़ि दहक। ");
INSERT INTO mai_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","गहुम कटयबाक समय तक दूनू केँ संग-संग बढ़ऽ दहक। कटनी करयबाक समय मे हम कटनिहार सभ केँ कहबैक जे, पहिने जंगलिआ घासक गाछ सभ केँ जमा कऽ कऽ जरयबाक लेल बोझ बान्‍हि लैह, तखन गहुम केँ हमरा बखारी मे जमा करह।’ ” ");
INSERT INTO mai_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","यीशु लोक सभ केँ एक आओर दृष्‍टान्‍त दैत कहलथिन, “स्‍वर्गक राज्‍य सरिसोक दाना जकाँ अछि, जकरा केओ लेलक आ अपना खेत मे बाउग कऽ देलक। ");
INSERT INTO mai_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","दाना सभ मे सरिसोक दाना सभ सँ छोट होइत अछि मुदा जनमि कऽ बढ़लाक बाद सभ साग-पात सँ पैघ भऽ तेहन गाछ भऽ जाइत अछि जे आकाशक चिड़ै सभ आबि कऽ ओकरा ठाढ़ि-पात मे अपन खोंता बना लैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","यीशु एकटा आओर दृष्‍टान्‍त ओकरा सभ केँ देलथिन—“स्‍वर्गक राज्‍य रोटी फुलाबऽ वला खमीर जकाँ अछि, जकरा एक स्‍त्री तीन पसेरी आँटा मे मिला कऽ सनलक; बाद मे खमीरक शक्‍ति सँ पूरा आँटा फुलि गेलैक।” ");
INSERT INTO mai_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","यीशु अपना लग जमा भेल लोकक भीड़ केँ ई सभ बात दृष्‍टान्‍त दऽ-दऽ कऽ कहलथिन। बिनु दृष्‍टान्‍त देने ओ ओकरा सभ केँ किछु नहि कहलथिन। ");
INSERT INTO mai_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ओ एहि लेल एना बात कयलनि जे परमेश्‍वरक प्रवक्‍ता द्वारा कहल वचन पूरा होअय— “हम दृष्‍टान्‍त सभ दऽ-दऽ कऽ बाजब, सृष्‍टिक आरम्‍भ सँ जे बात सभ झाँपल छल से हम कहब।” ");
INSERT INTO mai_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","तकरबाद यीशु लोकक भीड़ केँ छोड़ि कऽ घर मे चल अयलाह। शिष्‍य सभ हुनका लग आबि कऽ कहलथिन, “खेत मे बाउग कयल जंगलिआ बीयाक दृष्‍टान्‍त वला बात केँ हमरा सभ केँ बुझा दिअ।” ");
INSERT INTO mai_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ओ हुनका सभ केँ उत्तर देलथिन, “नीक बीया बाउग कयनिहार छथि मनुष्‍य-पुत्र। ");
INSERT INTO mai_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","खेत अछि संसार, आ नीक बीया अछि परमेश्‍वरक राज्‍यक सन्‍तान सभ। जंगलिआ बीया अछि दुष्‍ट शैतानक सन्‍तान सभ। ");
INSERT INTO mai_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","जंगलिआ बीया बाउग करऽ वला दुश्‍मन अछि शैतान। कटनीक समय अछि संसारक अन्‍त आ कटनी कयनिहार सभ छथि स्‍वर्गदूत सभ। ");
INSERT INTO mai_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“जाहि तरहेँ जंगलिआ घास केँ जमा कऽ कऽ आगि मे जराओल जाइत अछि तहिना संसारक अन्‍त मे सेहो कयल जायत। ");
INSERT INTO mai_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","मनुष्‍य-पुत्र अपना स्‍वर्गदूत सभ केँ पठौताह आ ओ सभ हुनका राज्‍य मे सँ सभ प्रकारक पाप मे फँसाबऽ वला बात सभ केँ उखाड़ि कऽ आ कुकर्मी सभ केँ जमा कऽ कऽ ");
INSERT INTO mai_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","आगिक भट्ठी मे फेकि देताह, जतऽ लोक कानत आ दाँत कटकटाओत। ");
INSERT INTO mai_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","तखन धर्मी सभ अपना पिताक राज्‍य मे सूर्य जकाँ चमकताह। जकरा कान होइक, से सुनओ। ");
INSERT INTO mai_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“स्‍वर्गक राज्‍य खेत मे गाड़ल धन जकाँ अछि, जकरा कोनो मनुष्‍य पौलक आ फेर माटि सँ झाँपि देलक। ओ एतेक खुश भेल जे ओ अपन सभ धन-सम्‍पत्ति बेचि कऽ ओहि खेत केँ किनि लेलक। ");
INSERT INTO mai_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“फेर, स्‍वर्गक राज्‍य ओहि व्‍यापारी सन अछि जे नीक मोतीक खोज मे छल। ");
INSERT INTO mai_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","जखन ओकरा एक बहुत बहुमूल्‍य मोती भेटलैक तँ जा कऽ अपन सभ किछु बेचि देलक आ ओहि मोती केँ किनि लेलक। ");
INSERT INTO mai_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“फेर दोसर दृष्‍टिएँ स्‍वर्गक राज्‍य ओहि महाजाल सन अछि जे समुद्र मे खसाओल गेल आ सभ प्रकारक माछ ओहि मे घेरायल। ");
INSERT INTO mai_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","जखन जाल भरि गेल तँ लोक सभ ओकरा कछेर पर अनलक आ बैसि कऽ नीक माछ सभ केँ डाली मे जमा कयलक मुदा खराब माछ सभ केँ फेकि देलक। ");
INSERT INTO mai_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","एहि संसारक अन्‍त मे सेहो एहिना होयतैक। स्‍वर्गदूत सभ आबि कऽ दुष्‍ट सभ केँ धर्मी सभ सँ अलग करताह ");
INSERT INTO mai_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","आ आगिक भट्ठी मे फेकि देताह, जतऽ लोक कानत आ दाँत कटकटाओत।” ");
INSERT INTO mai_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","तखन यीशु शिष्‍य सभ सँ पुछलथिन, “की अहाँ सभ ई बात सभ बुझलहुँ?” ओ सभ उत्तर देलथिन, “हँ।” ");
INSERT INTO mai_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ओ हुनका सभ केँ कहलथिन, “तेँ प्रत्‍येक व्‍यक्‍ति जे धर्मशास्‍त्र केँ बुझैत अछि आ जे स्‍वर्गक राज्‍यक शिष्‍य बनल अछि, से ओहि गृहस्‍थ जकाँ अछि जे अपन भण्‍डार घर मे सँ नव आ पुरान दूनू तरहक किमती वस्‍तु सभ निकालि सकैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","यीशु ई दृष्‍टान्‍त सभ देलाक बाद ओतऽ सँ चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ओ अपना गाम मे आबि कऽ सभाघर मे लोक सभ केँ उपदेश देबऽ लगलाह। लोक सभ हुनकर उपदेशक बात सभ सुनि आश्‍चर्यित भऽ गेल आ बाजल जे, “एकरा एहि तरहक बुद्धि आ चमत्‍कार करबाक सामर्थ्‍य कतऽ सँ भेटलैक? ");
INSERT INTO mai_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","की ई लकड़ी मिस्‍तिरीक बेटा नहि अछि? की एकर मायक नाम मरियम नहि छैक? आ एकर भाय सभ याकूब, यूसुफ, सिमोन, आ यहूदा नहि अछि? ");
INSERT INTO mai_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","की एकर बहिन सभ अपना सभक बीच नहि रहैत अछि? तखन एकरा ई बात सभ भेटलैक कतऽ सँ?” ");
INSERT INTO mai_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","एहि तरहेँ लोक यीशु सँ डाह करऽ लागल। तखन यीशु ओकरा सभ केँ कहलथिन, “मात्र अपने गाम आ अपने घर मे परमेश्‍वरक प्रवक्‍ताक अनादर होइत छैक।” ");
INSERT INTO mai_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","और ओकरा सभक अविश्‍वासक कारणेँ यीशु ओतऽ बहुत कम चमत्‍कार वला काज सभ कयलनि। ");
INSERT INTO mai_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ओहि समय मे ओहि प्रदेशक शासक हेरोद यीशुक काज सभक चर्चा सुनलनि। ");
INSERT INTO mai_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ओ अपन दरबारी सभ केँ कहलनि, “ई तँ बपतिस्‍मा देनिहार यूहन्‍ना अछि! ओ मुइल सभ मे सँ जीबि उठल अछि, आ तेँ चमत्‍कार करबाक एहन सामर्थ्‍य ओकरा मे क्रियाशील अछि।” ");
INSERT INTO mai_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","यूहन्‍ना हेरोद द्वारा कोना मरबाओल गेल छलाह से घटना एहि प्रकारेँ अछि—हेरोद अपन भाय फिलिपुसक स्‍त्री हेरोदियासक कारणेँ यूहन्‍ना केँ पकड़बा कऽ बन्‍हबौने छलथिन आ जहल मे राखि देने छलथिन, ");
INSERT INTO mai_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","किएक तँ यूहन्‍ना हेरोद केँ बेर-बेर कहने छलथिन जे, “अहाँ भायक स्‍त्री केँ राखि कऽ धर्म-नियमक आज्ञाक उल्‍लंघन कऽ रहल छी।” ");
INSERT INTO mai_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","हेरोद यूहन्‍ना केँ मारि देबऽ चाहैत छलाह, मुदा ओ लोक सभ सँ डेराइत छलाह, किएक तँ लोक सभ यूहन्‍ना केँ परमेश्‍वरक प्रवक्‍ता मानैत छलनि। ");
INSERT INTO mai_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","मुदा जखन हेरोदक जन्‍म-दिन अयलनि तँ हेरोदियासक बेटी अतिथि सभक सामने नाँचि कऽ हेरोद केँ ततेक ने प्रसन्‍न कऽ देलकनि ");
INSERT INTO mai_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","जे ओ सपत खाइत ओकरा वचन देलथिन जे, “तोँ जे किछु हमरा सँ मँगबह, से हम तोरा देबह।” ");
INSERT INTO mai_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","बच्‍चीक माय ओकरा सिखा-पढ़ा कऽ कहबौलकैक जे, “हमरा बपतिस्‍मा देनिहार यूहन्‍नाक मूड़ी एखने थारी मे अनबा दिअ।” ");
INSERT INTO mai_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ई सुनि राजा उदास भऽ गेलाह, मुदा तैयो अपन सपत आ उपस्‍थित आमन्‍त्रित सभक कारणेँ ओ आज्ञा देलनि जे ओकर माँग पूरा कयल जाय। ");
INSERT INTO mai_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ओ सिपाही केँ पठा कऽ जहल मे यूहन्‍नाक मूड़ी कटबा देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","यूहन्‍नाक मूड़ी एकटा थारी मे आनल गेल आ बच्‍ची केँ दऽ देल गेलैक। ओ लऽ कऽ चलि गेल और अपना माय केँ दऽ देलकैक। ");
INSERT INTO mai_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","यूहन्‍नाक शिष्‍य सभ अयलाह आ अपन गुरुक लास लऽ जा कऽ कबर मे राखि देलथिन। तकरबाद जा कऽ ई समाचार यीशु केँ सुनौलथिन। ");
INSERT INTO mai_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","यीशु ई समाचार सुनि एकटा नाव पर बैसि कऽ चुप-चाप कोनो एकान्‍त स्‍थानक लेल विदा भऽ गेलाह। लोक सभ जखन ई बात बुझलक तँ नगर-नगर सँ बहुतो लोक पैदले हुनका पाछाँ विदा भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","यीशु जखन नाव सँ उतरलाह आ लोकक बड़का भीड़ केँ जमा देखलनि तँ हुनका ओहि लोक सभ पर दया आबि गेलनि और ओकरा सभ मे जे रोगी-बिमार सभ छलैक तकरा सभ केँ ओ स्‍वस्‍थ कऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","जखन साँझ पड़ऽ लागल तँ यीशुक शिष्‍य सभ हुनका लग आबि कहलथिन, “ई जगह बस्‍ती सँ दूर अछि आ साँझ पड़ऽ वला अछि, तेँ एकरा सभ केँ विदा कऽ दिऔक जाहि सँ ई सभ लग-पासक गाम सभ मे जा कऽ अपना लेल किछु खयबाक वस्‍तु किनि सकत।” ");
INSERT INTO mai_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","मुदा यीशु शिष्‍य सभ केँ उत्तर देलथिन, “एकरा सभ केँ एतऽ सँ पठयबाक कोनो आवश्‍यकता नहि अछि। अहीं सभ एकरा सभ केँ भोजन करबिऔक।” ");
INSERT INTO mai_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","शिष्‍य सभ कहलथिन, “हमरा सभ लग, बस, पाँचेटा रोटी आ दुइएटा माछ अछि।” ");
INSERT INTO mai_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","यीशु कहलथिन, “ओ सभ हमरा लग आनू।” ");
INSERT INTO mai_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","तकरबाद ओ लोक सभ केँ घास पर बैसि जयबाक आज्ञा देलथिन। ओहि पाँचटा रोटी आ दूटा माछ केँ ओ हाथ मे लेलनि और स्‍वर्ग दिस तकैत परमेश्‍वर केँ धन्‍यवाद देलनि। तखन ओ रोटी केँ तोड़ि-तोड़ि कऽ शिष्‍य सभ केँ देलथिन आ शिष्‍य सभ लोक सभ मे परसि देलनि। ");
INSERT INTO mai_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","सभ केओ भरि इच्‍छा भोजन कयलक और शिष्‍य सभ जखन उबरल टुकड़ा सभ बिछलनि तँ ओ बारह पथिया भेल। ");
INSERT INTO mai_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","भोजन करऽ वला मे स्‍त्रीगण आ बच्‍चा सभ केँ छोड़ि पुरुषक संख्‍या लगभग पाँच हजार छल। ");
INSERT INTO mai_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","तकरबाद यीशु अपना शिष्‍य सभ केँ तुरत नाव पर चढ़ि कऽ अपना सँ पहिने झीलक ओहि पार चल जयबाक लेल आज्ञा देलथिन आ अपने ओतहि रहि कऽ भीड़क लोक सभ केँ विदा करऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","लोक सभ केँ विदा कयलाक बाद ओ एकान्‍त मे प्रार्थना करऽ लेल पहाड़ पर चल गेलाह। साँझ पड़ि गेल छल आ ओ ओतऽ एसगरे छलाह। ");
INSERT INTO mai_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","शिष्‍य सभ जाहि नाव पर गेल छलाह से कछेर सँ दूर पहुँचि लहरि मे डगमग कऽ रहल छल, किएक तँ हवा विपरीत दिस सँ बहि रहल छलैक। ");
INSERT INTO mai_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","यीशु रातिक चारिम पहर मे झीलक पानि पर चलैत शिष्‍य सभक दिस गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","मुदा शिष्‍य सभ हुनका पानि पर चलैत देखि घबड़ा गेलाह आ कहलनि जे, “भूत अछि!” और डरक मारे चिचियाय लगलाह। ");
INSERT INTO mai_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","एहि पर यीशु हुनका सभ केँ तुरत कहलथिन, “साहस राखू! हम छी, नहि डेराउ।” ");
INSERT INTO mai_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","तखन पत्रुस हुनका कहलथिन, “यौ प्रभु, जँ अहीं छी तँ हमरा पानि पर चलैत अपना लग अयबाक आज्ञा दिअ।” ");
INSERT INTO mai_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","यीशु कहलथिन, “आउ।” तखन पत्रुस नाव सँ उतरि कऽ पानि पर चलैत यीशुक दिस बढ़लाह। ");
INSERT INTO mai_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","मुदा जखन देखलनि जे हवा कतेक जोर सँ बहि रहल अछि तँ डेरा गेलाह आ डुबऽ लगलाह। ओ चिचियाइत बजलाह जे, “यौ प्रभु, हमरा बचाउ!” ");
INSERT INTO mai_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","यीशु तुरत हाथ बढ़ा कऽ हुनका पकड़ि लेलथिन आ कहलथिन, “अहाँक विश्‍वास एतेक कम किएक भऽ गेल! अहाँ सन्‍देह किएक कयलहुँ?” ");
INSERT INTO mai_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","तकरबाद जखन ओ सभ नाव पर चढ़ि गेलाह तँ हवाक बहनाइ शान्‍त भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","जे सभ नाव पर छलाह, से सभ हुनका पयर पर खसैत कहलथिन, “निश्‍चय अहाँ परमेश्‍वरक पुत्र छी।” ");
INSERT INTO mai_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","झील केँ पार कऽ कऽ ओ सभ गन्‍नेसरत क्षेत्र मे पहुँचलाह। ");
INSERT INTO mai_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ओहिठामक लोक सभ जखन हुनका चिन्‍हि लेलकनि तँ अपना लग-पासक इलाका मे यीशुक पहुँचबाक समाचार पसारि देलक। लोक सभ अपन सभ रोगी-बिमार केँ हुनका लग आनऽ लगलनि ");
INSERT INTO mai_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","और हुनका सँ नेहोरा करऽ लगलनि जे, “एकरा सभ केँ अहाँ अपन कपड़ाक खूटो छुबऽ दिऔक।” जे-जे रोगी-बिमार सभ यीशुक कपड़ा छुबि लेलक से सभ स्‍वस्‍थ भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","तकरबाद यरूशलेम सँ किछु फरिसी आओर धर्मशिक्षक सभ यीशु लग अयलाह आ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“अहाँक शिष्‍य सभ पुरखाक चलन सभ केँ किएक तोड़ैत अछि? ओ सभ भोजन करऽ सँ पहिने विधिवत हाथ नहि धोइत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","यीशु उत्तर देलथिन, “और अहाँ सभ अपन चलन सभक पालन करबाक लेल परमेश्‍वरक आज्ञा केँ किएक तोड़ैत छी? ");
INSERT INTO mai_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","देखू, परमेश्‍वर कहने छथि जे, ‘अपन माय-बाबूक आदर करह,’ आ ‘जे केओ अपन माय-बाबूक निन्‍दा करय तकरा मृत्‍युदण्‍ड देल जाय।’ ");
INSERT INTO mai_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","मुदा अहाँ सभ कहैत छी जे, जँ केओ अपन बाबू वा माय सँ कहत, ‘हम अहाँ सभ केँ जे किछु सहायता कऽ सकैत छलहुँ से हम परमेश्‍वर केँ अर्पण कऽ देने छी,’ ");
INSERT INTO mai_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","तँ ओकरा अपन माय-बाबूक सहायता कऽ कऽ आदर करबाक कोनो आवश्‍यकता नहि छैक। एहि तरहेँ अहाँ सभ अपन चलन केँ चलयबाक लेल परमेश्‍वरक आज्ञा केँ निरर्थक ठहरबैत छी। ");
INSERT INTO mai_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","हे पाखण्‍डी सभ! यशायाह अहाँ सभक सम्‍बन्‍ध मे एकदम ठीक भविष्‍यवाणी कयलनि जे, ");
INSERT INTO mai_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘ई सभ मुँह सँ हमर आदर करैत अछि, मुदा एकर सभक हृदय हमरा सँ दूर छैक। ");
INSERT INTO mai_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ई सभ बेकार हमर उपासना करैत अछि। ई सभ जे शिक्षा दैत अछि, से मात्र मनुष्‍यक बनाओल नियम सभ अछि।’” ");
INSERT INTO mai_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","यीशु भीड़क लोक केँ अपना लग बजा कऽ कहलथिन, “अहाँ सभ सुनू आ बुझू। ");
INSERT INTO mai_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","जे कोनो वस्‍तु मुँह मे जाइत अछि, से मनुष्‍य केँ अशुद्ध नहि करैत अछि, बल्‍कि जे मुँह सँ बहराइत अछि से ओकरा अशुद्ध करैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","एहि पर हुनकर शिष्‍य सभ हुनका लग आबि कहलथिन, “अहाँ जे कहलहुँ से फरिसी सभ केँ बड्ड खराब लगलनि, से अहाँ केँ बुझल अछि?” ");
INSERT INTO mai_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","यीशु हुनका सभ केँ उत्तर देलथिन, “प्रत्‍येक गाछ जे हमर स्‍वर्गीय पिता नहि लगौने छथि, से जड़ि सँ उखाड़ल जायत। ");
INSERT INTO mai_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","छोड़ू ओकर सभक बात! ओ सभ तँ अपने आन्‍हर अछि आ आन्‍हर सभ केँ बाट देखबैत अछि। आन्‍हरे जँ आन्‍हर केँ बाट देखाओत तँ दूनू अवश्‍य खधिया मे खसत।” ");
INSERT INTO mai_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","एहि पर पत्रुस कहलथिन, “एहि दृष्‍टान्‍तक अर्थ हमरा सभ केँ बुझा दिअ।” ");
INSERT INTO mai_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","यीशु कहलथिन, “की अहूँ सभ एखन तक नहि बुझलहुँ? ");
INSERT INTO mai_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","की अहाँ सभ नहि बुझैत छी जे, जे किछु मुँह मे जाइत अछि से पेट मे जा कऽ देह सँ बाहर भऽ जाइत अछि? ");
INSERT INTO mai_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","मुदा जे बात मुँह सँ बहराइत अछि से हृदय सँ निकलि कऽ अबैत अछि आ से मनुष्‍य केँ अशुद्ध बनबैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","कारण, हृदय सँ निकलैत अछि विभिन्‍न तरहक गलत विचार, हत्‍या, परस्‍त्रीगमन, अनैतिक शारीरिक सम्‍बन्‍ध, चोरी, झूठ गवाही, निन्‍दाक बात, ");
INSERT INTO mai_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","आ यैह बात सभ मनुष्‍य केँ अशुद्ध करैत अछि, नहि कि बिनु हाथ धोने भोजन करब, से।” ");
INSERT INTO mai_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ओतऽ सँ आगाँ बढ़ि यीशु सूर आ सीदोन नगरक इलाका मे गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ओहिठामक एक कनानी स्‍त्री हुनका लग आबि चिचियाय लगलनि जे, “हे प्रभु, दाऊदक पुत्र, हमरा पर दया करू! हमरा बेटी केँ दुष्‍टात्‍मा लागल छै। ओ ओकरा बड्ड कष्‍ट दैत छैक।” ");
INSERT INTO mai_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","मुदा यीशु ओकरा कोनो उत्तर नहि देलथिन। तखन हुनकर शिष्‍य सभ हुनका लग आबि कऽ विनती कयलथिन जे, “एकरा विदा कऽ दिऔक, ई तँ चिचियाइत-चिचियाइत अपना सभक पाछाँ लागल अछि।” ");
INSERT INTO mai_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","यीशु कहलथिन, “हम तँ मात्र इस्राएल वंशक हेरायल भेँड़ा सभक लेल पठाओल गेल छी।” ");
INSERT INTO mai_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","मुदा ओ स्‍त्री यीशु लग आबि हुनका पयर पर खसि पड़लनि आ कहलकनि, “प्रभु, हमरा पर दया करू!” ");
INSERT INTO mai_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ओ उत्तर देलथिन, “बच्‍चा सभक लेल जे रोटी अछि तकरा कुकुरक आगाँ फेकि देब से ठीक बात नहि।” ");
INSERT INTO mai_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","एहि पर स्‍त्री बाजल, “ठीक कहैत छी प्रभु, मुदा कुकुरो सभ तँ मालिकक टेबुल सँ खसल चुर-चार खाइते अछि।” ");
INSERT INTO mai_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","तखन यीशु ओकरा कहलथिन, “हे दाइ, तोहर विश्‍वास बड्ड पैघ छह! जहिना तोँ चाहैत छह, तहिना तोरा लेल होअह।” ओकर बच्‍ची तखने स्‍वस्‍थ भऽ गेलैक। ");
INSERT INTO mai_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","यीशु ओतऽ सँ विदा भऽ कऽ गलील झीलक काते-कात चललाह। तखन एक पहाड़ पर चढ़ि कऽ बैसि रहलाह। ");
INSERT INTO mai_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","झुण्‍डक-झुण्‍ड लोक हुनका लग अयलनि। ओ सभ अपना संग लुल्‍ह, आन्‍हर, नाङड़, बौक और बहुतो दोसर तरहक बिमार लोक सभ केँ लऽ कऽ आयल आ यीशुक चरण मे राखि देलकनि। यीशु ओहि सभ बिमार केँ स्‍वस्‍थ कऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","जमा भेल लोक सभ जखन देखलक जे बौक सभ बाजि रहल अछि, लुल्‍ह सभ स्‍वस्‍थ भऽ गेल अछि, नाङड़ सभ चलि रहल अछि आ आन्‍हर सभ देखि रहल अछि तखन ओ सभ आश्‍चर्यित भऽ इस्राएलक परमेश्‍वर केँ स्‍तुति करऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","यीशु अपन शिष्‍य सभ केँ बजा कऽ कहलथिन, “हमरा एहि लोक सभ पर दया अबैत अछि। ई सभ तीन दिन सँ हमरा संग अछि आ एकरा सभ लग भोजन करबाक लेल किछु नहि छैक। हम एकरा सभ केँ भूखले घर नहि पठाबऽ चाहैत छी। कतौ एना नहि भऽ जाइक जे ई सभ रस्‍ते मे भूखक मारे मुर्छित भऽ जाय।” ");
INSERT INTO mai_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","शिष्‍य सभ कहलथिन, “एहि निर्जन स्‍थान मे अपना सभ केँ एतेक भोजनक वस्‍तु कतऽ सँ भेटत जे अपना सभ एतेकटा भीड़ केँ भोजन करा सकबैक?” ");
INSERT INTO mai_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","यीशु हुनका सभ सँ पुछलथिन, “अहाँ सभ लग कयटा रोटी अछि?” ओ सभ कहलथिन, “सातटा, आ किछु छोटकी माछ।” ");
INSERT INTO mai_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","यीशु लोक सभ केँ जमीन पर बैसि जयबाक लेल आदेश देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","तकरबाद यीशु ओ सातो रोटी आ माछ सभ लऽ कऽ परमेश्‍वर केँ धन्‍यवाद देलनि, तखन तोड़ि-तोड़ि कऽ शिष्‍य सभ केँ परसबाक लेल देलथिन। शिष्‍य सभ ओकरा लोक सभ मे बाँटि देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","सभ केओ भरि पेट भोजन कयलक। भोजनक बाद शिष्‍य सभ उबरल टुकड़ा सभ सात टोकरी मे भरि कऽ जमा कयलनि। ");
INSERT INTO mai_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","भोजन करऽ वला लोक मे स्‍त्रीगण आ बच्‍चा सभ केँ छोड़ि पुरुषक संख्‍या चारि हजार छल। ");
INSERT INTO mai_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","भोजन करौलाक बाद लोकक भीड़ केँ विदा कऽ कऽ यीशु नाव पर चढ़ि कऽ मगदन क्षेत्र चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","फरिसी आ सदुकी सभ यीशु लग आबि कऽ आग्रह कयलथिन जे, “हमरा सभ केँ स्‍वर्ग सँ कोनो चमत्‍कार वला चिन्‍ह देखाउ।” ई बात ओ सभ हुनका जाँच करबाक लेल कहलथिन। ");
INSERT INTO mai_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ताहि पर यीशु हुनका सभ केँ उत्तर देलथिन, “साँझ पड़ला पर आकाश केँ लाल देखि अहाँ सभ कहैत छी, ‘काल्‍हिक मौसम नीक रहत,’ ");
INSERT INTO mai_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","और भोरखन कऽ आकाश केँ लाल आ झँपौन सन देखि कहैत छी जे, ‘आइ अन्‍हड़-बिहारि आओत।’ अहाँ सभ आकाश मे मौसमक लक्षण केँ चिन्‍हऽ जनैत छी, मुदा आइ-काल्‍हिक समय मे अहाँ सभक सामने की भऽ रहल अछि, से कोन बातक लक्षण अछि, तकरा नहि चिन्‍हैत छी। ");
INSERT INTO mai_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","एहि पीढ़ीक लोक सभ कतेक दुष्‍ट आ विश्‍वासघाती अछि जे चमत्‍कार वला चिन्‍ह मँगैत अछि! मुदा जे घटना परमेश्‍वरक प्रवक्‍ता योनाक संग भेल छलनि, से चिन्‍ह छोड़ि एकरा सभ केँ आओर कोनो चिन्‍ह नहि देखाओल जयतैक।” एतेक बात कहि यीशु हुनका सभ केँ छोड़ि कऽ आगाँ बढ़ि गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","यीशुक शिष्‍य सभ जखन झील केँ पार कयलनि, तँ ओ सभ रोटी अननाइ बिसरि गेल छलाह। ");
INSERT INTO mai_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","यीशु हुनका सभ केँ कहलथिन, “सावधान, फरिसी आ सदुकी सभक रोटी फुलाबऽ वला खमीर सँ होसियार रहू।” ");
INSERT INTO mai_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","शिष्‍य सभ एक-दोसर सँ बात करऽ लगलाह जे, “अपना सभ रोटी आनब बिसरि गेलहुँ, तेँ एना कहि रहल छथि।” ");
INSERT INTO mai_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","यीशु हुनकर सभक बात बुझि कहलथिन, “अहाँ सभक विश्‍वास एतेक कमजोर किएक अछि? अहाँ सभ आपस मे एहि पर बात किएक कऽ रहल छी जे अपना सभ लग रोटी नहि अछि? ");
INSERT INTO mai_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","की अहाँ सभ एखनो नहि बुझैत छी? की ओ पाँच हजार लोक आ पाँच रोटी वला बात, और ओहि दिन अहाँ सभ उबरल टुकड़ा कतेक पथिया जमा कऽ कऽ उठौने छलहुँ, से अहाँ सभ केँ स्‍मरण नहि अछि? ");
INSERT INTO mai_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","वा चारि हजार लोकक लेल ओ सातटा रोटी, आ कतेक टोकरी जमा कयलहुँ, से? ");
INSERT INTO mai_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","अहाँ सभ हमर एहि बात केँ बुझि किएक नहि रहल छी जे, ‘फरिसी आ सदुकी सभक रोटी फुलाबऽ वला खमीर सँ होसियार रहू,’ से बात हम रोटीक सम्‍बन्‍ध मे नहि कहने छलहुँ?” ");
INSERT INTO mai_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","तखन शिष्‍य सभ केँ बुझऽ मे अयलनि जे यीशु रोटी फुलयबाक लेल प्रयोग होमऽ वला खमीरक सम्‍बन्‍ध मे नहि, बल्‍कि फरिसी आ सदुकी सभक शिक्षा सँ होसियार रहबाक लेल कहने छलाह। ");
INSERT INTO mai_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","कैसरिया-फिलिप्‍पी क्षेत्र मे आबि कऽ यीशु अपना शिष्‍य सभ केँ पुछलथिन, “मनुष्‍य-पुत्र के अछि, एहि सम्‍बन्‍ध मे लोक सभ की कहैत अछि?” ");
INSERT INTO mai_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ओ सभ उत्तर देलथिन, “किछु लोक कहैत अछि जे अहाँ बपतिस्‍मा देनिहार यूहन्‍ना छी, किछु लोक जे एलियाह छी, दोसर लोक सभ जे यर्मियाह वा प्राचीन कालक परमेश्‍वरक प्रवक्‍ता सभ मे सँ आओर केओ छी, से कहैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","यीशु शिष्‍य सभ सँ पुछलथिन, “आ अहाँ सभ? अहाँ सभ की कहैत छी जे हम के छी?” ");
INSERT INTO mai_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","सिमोन पत्रुस उत्तर देलथिन, “अहाँ उद्धारकर्ता-मसीह छी, जीवित परमेश्‍वरक पुत्र छी।” ");
INSERT INTO mai_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","यीशु हुनका कहलथिन, “हे सिमोन, योनाक पुत्र, अहाँ धन्‍य छी! कारण, एहि बातक ज्ञान अहाँ केँ कोनो मनुष्‍य सँ नहि, बल्‍कि हमर पिता जे स्‍वर्ग मे छथि, तिनका सँ भेटल। ");
INSERT INTO mai_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","हम अहाँ केँ कहैत छी जे, अहाँ ‘पत्रुस’ छी। हम एहि चट्टान पर अपन मण्‍डलीक स्‍थापना करब आ मृत्‍युक सामर्थ्‍य एहि पर विजयी नहि होयत। ");
INSERT INTO mai_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","हम अहाँ केँ स्‍वर्गक राज्‍यक कुंजी देब। जे किछु अहाँ पृथ्‍वी पर बान्‍हब से स्‍वर्ग मे बान्‍हल गेल रहत आ जे किछु अहाँ पृथ्‍वी पर खोलब से स्‍वर्ग मे खोलल गेल रहत।” ");
INSERT INTO mai_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","तकरबाद यीशु अपना शिष्‍य सभ केँ दृढ़तापूर्बक आदेश देलथिन जे, “ई बात ककरो नहि कहिऔक जे हम उद्धारकर्ता-मसीह छी।” ");
INSERT INTO mai_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ओही दिन सँ यीशु अपना शिष्‍य सभ केँ स्‍पष्‍ट जानकारी देबऽ लगलथिन जे, “ई आवश्‍यक अछि जे हम यरूशलेम जाइ, ओतऽ बूढ़-प्रतिष्‍ठित, मुख्‍यपुरोहित आ धर्मशिक्षक सभ सँ हमरा बहुत कष्‍ट देल जाय, हम जान सँ मारल जाइ, आ तेसर दिन हम फेर जिआओल जाइ।” ");
INSERT INTO mai_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ई बात सुनि पत्रुस हुनका अलग बजा कऽ डँटैत कहलथिन, “यौ प्रभु, परमेश्‍वर एना नहि करथि! अहाँक संग एहन बात कहियो नहि होयत!” ");
INSERT INTO mai_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ताहि पर यीशु पत्रुस केँ कहलथिन, “है शैतान, तोँ हमरा सोझाँ सँ दूर होअह! हमरा लेल तोँ ठेस लगबाक कारण छह। तोँ परमेश्‍वरक विचार नहि, बल्‍कि मनुष्‍यक विचार मोन मे रखैत छह।” ");
INSERT INTO mai_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","तकरबाद यीशु अपना शिष्‍य सभ केँ कहलथिन, “जँ केओ हमर शिष्‍य बनऽ चाहैत अछि, तँ ओ अपना केँ त्‍यागि हमरा कारणेँ दुःख उठयबाक आ प्राणो देबाक लेल तैयार रहओ आ हमरा पाछाँ चलओ। ");
INSERT INTO mai_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","कारण, जे केओ अपन जीवन बचाबऽ चाहैत अछि, से ओकरा गमाओत, मुदा जे केओ हमरा लेल अपन जीवन गमबैत अछि, से ओकरा पाओत। ");
INSERT INTO mai_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","जँ कोनो मनुष्‍य सम्‍पूर्ण संसार केँ पाबि लय और अपन आत्‍मा गमा लय, तँ ओकरा की लाभ भेलैक? अथवा मनुष्‍य अपन आत्‍माक बदला मे की दऽ सकत? ");
INSERT INTO mai_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","किएक तँ मनुष्‍य-पुत्र अपन स्‍वर्गदूत सभक संग अपना पिताक महिमा मे आओत, तखन ओ प्रत्‍येक मनुष्‍य केँ ओकर काजक अनुसार प्रतिफल देतैक। ");
INSERT INTO mai_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","हम अहाँ सभ केँ सत्‍य कहैत छी जे, एतऽ किछु एहनो लोक सभ ठाढ़ अछि जे जाबत तक मनुष्‍य-पुत्र केँ अपना राज्‍य मे अबैत नहि देखि लेत ताबत तक नहि मरत।” ");
INSERT INTO mai_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","छओ दिनक बाद यीशु अपना संग पत्रुस, याकूब आ हुनकर भाय यूहन्‍ना केँ लऽ कऽ एक ऊँच पहाड़ पर एकान्‍त मे गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","हुनका सभक सामने मे यीशुक रूप बदलि गेलनि। हुनकर मुँह सूर्य जकाँ चमकऽ लगलनि आ हुनकर वस्‍त्र इजोत सन उज्‍जर भऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","एकाएक शिष्‍य सभ केँ मूसा आ एलियाह यीशु सँ बात-चीत करैत देखाइ देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","एहि पर पत्रुस यीशु केँ कहलथिन, “यौ प्रभु, हमरा सभक लेल ई कतेक नीक बात अछि जे हम सभ एतऽ छी! जँ अपनेक आज्ञा होअय तँ हम एहिठाम तीनटा मण्‍डप बनायब—एकटा अपनेक लेल, एकटा मूसाक लेल आ एकटा एलियाहक लेल।” ");
INSERT INTO mai_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","पत्रुस ई सभ बाजिए रहल छलाह, तखने एकटा चमकैत मेघ आबि हुनका सभ केँ झाँपि देलकनि आ मेघ मे सँ ई आवाज आयल जे, “ई हमर प्रिय पुत्र छथि। हिनका सँ हम अति प्रसन्‍न छी, हिनका बात पर ध्‍यान दिअ!” ");
INSERT INTO mai_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ई सुनि शिष्‍य सभ अति भयभीत भऽ कऽ मुँहे भरेँ खसलाह। ");
INSERT INTO mai_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","तखन लग आबि यीशु हुनका सभ केँ छुबि कऽ कहलथिन, “उठू, नहि डेराउ।” ");
INSERT INTO mai_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ओ सभ जखन अपन नजरि ऊपर उठौलनि तँ ओतऽ यीशु केँ छोड़ि आओर किनको नहि देखलनि। ");
INSERT INTO mai_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","पहाड़ पर सँ नीचाँ उतरैत समय मे यीशु शिष्‍य सभ केँ आज्ञा देलथिन जे, “जाबत तक मनुष्‍य-पुत्र मृत्‍यु सँ फेर जीबि कऽ नहि उठत ताबत तक जे बात अहाँ सभ देखलहुँ से ककरो नहि कहिऔक।” ");
INSERT INTO mai_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","एहि पर हुनकर शिष्‍य सभ हुनका सँ पुछलथिन, “धर्मशिक्षक सभ किएक कहैत छथि जे पहिने एलियाह केँ अयनाइ आवश्‍यक अछि?” ");
INSERT INTO mai_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","यीशु उत्तर देलथिन, “ई बात एकदम ठीक अछि। एलियाहक अयनाइ आवश्‍यक अछि, और ओ सभ बातक सुधार करताह। ");
INSERT INTO mai_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","मुदा हम अहाँ सभ केँ कहैत छी जे एलियाह तँ आबि गेल छथि। लोक सभ हुनका चिन्‍हि नहि सकलनि और ओकरा सभ केँ जे मोन भेलैक, से हुनका संग कयलकनि। एहि तरहेँ मनुष्‍य-पुत्र केँ सेहो ओकरा सभक हाथेँ कष्‍ट भोगऽ पड़तनि।” ");
INSERT INTO mai_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","तखन शिष्‍य सभ केँ बुझऽ मे अयलनि जे यीशु हमरा सभ केँ बपतिस्‍मा देनिहार यूहन्‍नाक सम्‍बन्‍ध मे कहि रहल छथि। ");
INSERT INTO mai_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ओ सभ जखन लोकक भीड़ जतऽ जमा छल ततऽ पहुँचलाह तँ एक गोटे यीशु लग आबि ठेहुनिया दऽ कऽ कहऽ लगलनि, ");
INSERT INTO mai_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“यौ प्रभु, हमरा बेटा पर दया कयल जाओ, एकरा मिर्गी अबैत छैक आ बहुत कष्‍ट होइत छैक। ई कखनो आगि मे खसि पड़ैत अछि तँ कखनो पानि मे। ");
INSERT INTO mai_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","हम एकरा अपनेक शिष्‍य सभ लग अनने छलहुँ, लेकिन ओ सभ एकरा ठीक नहि कऽ सकलथिन।” ");
INSERT INTO mai_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","यीशु उत्तर देलथिन, “है अविश्‍वासी आ भ्रष्‍ट पीढ़ीक लोक सभ, हम कहिया तक तोरा सभक संग रहिअह? हम कहिया तक तोरा सभ केँ सहैत रहिअह? आनह लड़का केँ हमरा लग।” ");
INSERT INTO mai_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","जे दुष्‍टात्‍मा ओकरा मे पैसि गेल छल, तकरा यीशु फटकारलथिन। दुष्‍टात्‍मा ओकरा मे सँ निकलि गेलैक, आ ओ तखने ठीक भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","बाद मे शिष्‍य सभ एकान्‍त मे यीशु लग आबि कऽ पुछलथिन, “हम सभ ओहि दुष्‍टात्‍मा केँ किएक नहि निकालि सकलहुँ?” ");
INSERT INTO mai_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ओ उत्तर देलथिन, “अहाँ सभ मे विश्‍वासक कमी अछि, तेँ। हम अहाँ सभ केँ सत्‍य कहैत छी जे, जँ अहाँ सभ मे सरिसोक दानो बराबरि विश्‍वास रहत आ एहि पहाड़ केँ कहब जे, ‘एहिठाम सँ हटि कऽ ओतऽ जो’ तँ हटि जायत। एहन कोनो बात नहि अछि जे अहाँ सभक लेल असम्‍भव होयत। ");
INSERT INTO mai_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","मुदा एहि तरहक दुष्‍टात्‍मा प्रार्थना आ उपास केँ छोड़ि आओर कोनो दोसर उपाय सँ नहि निकालल जा सकैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","एक दिन यीशु आ शिष्‍य सभ जखन गलील मे एक संग छलाह, तखन यीशु हुनका सभ केँ कहलथिन, “मनुष्‍य-पुत्र पकड़बा कऽ लोकक हाथ मे सौंपल जायत। ");
INSERT INTO mai_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ओ सभ ओकरा मारि देतैक, मुदा तेसर दिन ओ जिआओल जायत।” ई बात सुनि शिष्‍य सभ बहुत उदास भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","तकरबाद यीशु आ हुनकर शिष्‍य सभ जखन कफरनहूम नगर मे पहुँचलाह, तखन मन्‍दिरक कर असूल कयनिहार सभ पत्रुस लग आबि कऽ पुछलकनि, “की अहाँ सभक गुरुजी मन्‍दिरक कर नहि चुकबैत छथि?” ");
INSERT INTO mai_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","पत्रुस कहलथिन, “हँ, चुकबैत छथि।” तकरबाद पत्रुस जखन घर मे अयलाह तँ यीशुए हुनका सँ पुछलथिन, “यौ सिमोन, अहाँक की विचार अछि? संसारक राजा सभ सीमा-शुल्‍क वा व्‍यक्‍ति-कर ककरा सभ सँ लैत अछि? अपन पुत्र सभ सँ वा आन लोक सभ सँ?” ");
INSERT INTO mai_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पत्रुस कहलथिन, “आन लोक सँ।” तखन यीशु कहलथिन, “एकर मतलब, पुत्र कर-मुक्‍त अछि। ");
INSERT INTO mai_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","मुदा एक बात, अपना सभ ओकरा सभ केँ सिकायत करबाक अवसर नहि दी, तेँ अहाँ झील पर जा कऽ बंसी थापू। जे माछ पहिने फँसत तकरा निकालू। ओकरा मुँह मे अहाँ केँ एकटा चानीक सिक्‍का भेटत। अहाँ ओ सिक्‍का लऽ कऽ अपना दूनू गोटेक कर ओकरा सभ केँ दऽ कऽ चुका दिऔक।” ");
INSERT INTO mai_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ओही समय मे शिष्‍य सभ आबि कऽ यीशु सँ पुछलथिन, “स्‍वर्गक राज्‍य मे सभ सँ पैघ के अछि?” ");
INSERT INTO mai_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","यीशु एक छोट बच्‍चा केँ अपना लग बजा कऽ हुनका सभक बीच ठाढ़ करैत कहलथिन, ");
INSERT INTO mai_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“हम अहाँ सभ केँ सत्‍य कहैत छी जे, जाबत तक अहाँ सभ बदलि कऽ बच्‍चा सभ जकाँ नहि बनि जायब ताबत तक स्‍वर्गक राज्‍य मे कहियो नहि प्रवेश करब। ");
INSERT INTO mai_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","तेँ, जे केओ नम्र बनि अपना केँ एहि बच्‍चा जकाँ छोट बुझैत अछि, से स्‍वर्गक राज्‍य मे सभ सँ पैघ अछि। ");
INSERT INTO mai_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","जे केओ हमरा नाम सँ एहन छोट बच्‍चा केँ स्‍वीकार करैत अछि से हमरा स्‍वीकार करैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","मुदा ई बच्‍चा सभ जे हमरा पर विश्‍वास करैत अछि, ताहि मे सँ जँ एकोटा केँ केओ पाप मे फँसाओत, तँ ओहि फँसौनिहारक गरदनि मे जाँतक पाट बान्‍हि कऽ अथाह समुद्र मे डुबा देल जाइक, से ओकरा लेल नीक होइत। ");
INSERT INTO mai_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“पाप मे फँसाबऽ वला बात सभक कारणेँ संसार पर कतेक कष्‍ट औतैक! पाप मे फँसाबऽ वला बात सभ तँ रहबे करत, मुदा धिक्‍कार ताहि मनुष्‍य केँ जकरा द्वारा ओ बात सभ अबैत अछि! ");
INSERT INTO mai_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“जँ अहाँक हाथ वा पयर अहाँ केँ पाप मे फँसबैत अछि तँ ओकरा काटि कऽ फेकि दिअ। दूनू हाथ-पयरक संग अनन्‍त समय तक जरैत रहऽ वला आगिक कुण्‍ड मे फेकि देल जायब, अहाँक लेल ताहि सँ नीक ई जे लुल्‍ह-नाङड़ भऽ कऽ जीवन मे प्रवेश करू। ");
INSERT INTO mai_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","आ जँ अहाँक आँखि अहाँ केँ पाप मे फँसबैत अछि तँ ओकरा निकालि कऽ फेकि दिअ। दूनू आँखिक संग नरकक आगि मे फेकि देल जायब, अहाँक लेल ताहि सँ नीक ई जे कनाह भऽ कऽ जीवन मे प्रवेश करू। ");
INSERT INTO mai_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“अहाँ सभ एहि पर ध्‍यान राखू जे एहि बच्‍चा सभ मे सँ एकोटा केँ तुच्‍छ नहि बुझब। हम अहाँ सभ केँ कहैत छी जे, स्‍वर्ग मे एकर सभक रक्षा कयनिहार दूत सभ सदिखन हमर स्‍वर्गीय पिताक मुँह दिस तकैत रहैत छथि। ");
INSERT INTO mai_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","मनुष्‍य-पुत्र हेरायल सभ केँ बचयबाक लेल आयल छथि। ");
INSERT INTO mai_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“अहाँ सभ की सोचैत छी? जँ ककरो लग एक सय भेँड़ा छैक आ ओहि मे सँ एकटा भेँड़ा भटकि जाइक, तँ की ओ अपन निनान्‍नबे भेँड़ा केँ पहाड़ पर छोड़ि कऽ ओहि भटकल भेँड़ा केँ खोजबाक लेल नहि जायत? ");
INSERT INTO mai_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","हम अहाँ सभ केँ सत्‍य कहैत छी जे, जँ ओ ओकरा भेटि जयतैक, तँ ओहि निनान्‍नबे भेँड़ाक कारणेँ, जे नहि भटकल छलैक, ताहि सँ बेसी आनन्‍द ओकरा एही भेँड़ाक कारणेँ होयतैक। ");
INSERT INTO mai_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","एही तरहेँ स्‍वर्ग मे रहऽ वला अहाँ सभक पिताक इच्‍छा ई छनि जे एहि बच्‍चा सभ मे सँ एकोटा नष्‍ट नहि होनि। ");
INSERT INTO mai_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“अहाँक भाय जँ अहाँक संग अपराध करय तँ असगरे ओकरा लग जाउ आ एकान्‍त मे ओकर दोष ओकरा बुझा दिऔक। ओ जँ अहाँक बात सुनलक, तँ एकटा भाय अहाँ केँ फेर भेटि गेल से बुझू। ");
INSERT INTO mai_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","मुदा जँ ओ अहाँक बात नहि सुनैत अछि तँ अपना संग एक-दू आदमी केँ लऽ कऽ जाउ आ ओकरा बुझबिऔक, जाहि सँ, जहिना धर्मशास्‍त्र मे लिखल अछि, ‘हर बात दू वा तीन साक्षीक गवाही पर आधारित रहय’। ");
INSERT INTO mai_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","मुदा ओ जँ ओकरो सभक बात सुनबाक लेल तैयार नहि भेल, तँ तकर जानकारी विश्‍वासी मण्‍डली केँ दिऔक। आ जँ ओ विश्‍वासी मण्‍डलीक बात सेहो नहि सुनत, तँ ओकरा संग एहन व्‍यवहार करू जेना ओ अविश्‍वासी वा कर असूल कयनिहार ठकहारा होअय। ");
INSERT INTO mai_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","हम अहाँ सभ केँ कहैत छी जे, अहाँ सभ जे किछु पृथ्‍वी पर बान्‍हब, से स्‍वर्ग मे बान्‍हल गेल रहत, आ जे किछु अहाँ सभ पृथ्‍वी पर खोलब से स्‍वर्ग मे खोलल गेल रहत। ");
INSERT INTO mai_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“हम अहाँ सभ केँ एकटा इहो बात कहैत छी जे, एहि पृथ्‍वी पर जँ अहाँ सभ मे सँ केओ दू गोटे कोनो बातक लेल एक विचारक भऽ कऽ विनती करब, तँ हमर पिता जे स्‍वर्ग मे छथि, तिनका द्वारा ओ बात अहाँ सभक लेल पूरा कयल जायत। ");
INSERT INTO mai_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","किएक तँ जतऽ दू वा तीन व्‍यक्‍ति हमरा नाम सँ एक ठाम जमा होइत अछि, ततऽ हम ओकरा सभक बीच उपस्‍थित छी।” ");
INSERT INTO mai_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","तकरबाद पत्रुस यीशु लग आबि कऽ पुछलथिन, “यौ प्रभु, हमर भाय जँ हमरा संग अपराध करय तँ कतेक बेर हम ओकरा क्षमा करैत रहिऐक? की सात बेर तक?” ");
INSERT INTO mai_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","यीशु कहलथिन, “हम तँ कहैत छी, सात बेर नहि, बल्‍कि सात सँ सत्तरिक जे गुणनफल होयत ततेक बेर। ");
INSERT INTO mai_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“कारण, स्‍वर्गक राज्‍यक तुलना एहन राजा सँ कयल जा सकैत अछि जे अपन राज्‍यक कर्मचारी सभ सँ हिसाब-किताब लेबऽ चाहलनि। ");
INSERT INTO mai_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","जखन ओ हिसाब-किताब लेबऽ लगलाह तँ हुनका लग एक कर्मचारी केँ लाओल गेल, जकरा पर दस हजार सोनक रुपैया ऋण छलनि। ");
INSERT INTO mai_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ओहि कर्मचारी लग ऋण सधयबाक लेल किछु नहि छलैक तेँ ओकर मालिक आज्ञा दऽ देलथिन जे, एकरा, एकर स्‍त्री आ बाल-बच्‍चा केँ और एकर सभ सामान बेचि कऽ एकरा सँ ऋण असूल कयल जाय। ");
INSERT INTO mai_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ई सुनि ओ कर्मचारी अपना मालिकक पयर पर खसि कऽ विनती करऽ लागल जे, ‘यौ सरकार, धैर्य राखल जाओ, हम अपनेक सम्‍पूर्ण ऋण सधा देब।’ ");
INSERT INTO mai_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","मालिक ओकरा पर दया कऽ कऽ ओकरा छोड़ि देलथिन आ ओकर सम्‍पूर्ण ऋण माफ कऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","मुदा ओ कर्मचारी जखन ओतऽ सँ बाहर भेल तँ ओकरा संग काज करऽ वला एक दोसर कर्मचारी भेटलैक जे ओकरा सँ एक सय तामक रुपैया ऋण लेने छलैक। ओ ओकरा पकड़ि कऽ गरदनि चभैत कहलकैक, ‘जे किछु तोरा पर हमर ऋण अछि, से तुरत ला!’ ");
INSERT INTO mai_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ओ कर्मचारी ओकरा पयर पर खसि कऽ विनती करऽ लागल, ‘धैर्य राखू, हम अहाँक ऋण सधा देब।’ ");
INSERT INTO mai_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","मुदा ओ नहि मानलक आ जा कऽ ओकरा जहल मे रखबा देलकैक जे जाबत तक ऋण नहि सधाओत ताबत तक जहल मे रहओ। ");
INSERT INTO mai_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ई देखि दोसर कर्मचारी सभ केँ बहुत दुःख भेलैक आ ओ सभ जा कऽ सम्‍पूर्ण घटना मालिक केँ कहि सुनौलकनि। ");
INSERT INTO mai_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","तकरबाद मालिक ओहि कर्मचारी केँ बजबा कऽ कहलथिन, ‘है दुष्‍ट नोकर, तोँ हमरा सँ विनती कयलेँ तँ हम तोहर सम्‍पूर्ण ऋण माफ कऽ देलिऔक। ");
INSERT INTO mai_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","तँ की ई उचित नहि छल जे जहिना हम तोरा संग दया कयलिऔ, तहिना तोहूँ अपन संगी-कर्मचारीक संग दया करिते?’ ");
INSERT INTO mai_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","मालिक केँ ओहि कर्मचारी पर बहुत क्रोध भऽ गेलनि आ ओ ओकरा दण्‍ड देबाक लेल जहल मे पठबा देलथिन जे जाबत तक ओ पूरा ऋण सधा नहि दय ताबत तक जहल मे रहओ। ");
INSERT INTO mai_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","तेँ जँ अहूँ सभ अपना भाय केँ हृदय सँ क्षमा नहि करबैक तँ हमर स्‍वर्गीय पिता अहूँ सभक संग ओहने व्‍यवहार करताह।” ");
INSERT INTO mai_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ई सभ बात जखन कहल भऽ गेलनि तँ यीशु गलील प्रदेश सँ विदा भऽ कऽ यरदन नदीक दोसर कात यहूदिया प्रदेश मे गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","लोकक बड़का भीड़ हुनका पाछाँ आबि गेलनि। यीशु ओहिठाम ओकरा सभक रोग-बिमारी सभ केँ ठीक कऽ देलनि। ");
INSERT INTO mai_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ओहिठाम किछु फरिसी सभ यीशु लग अयलाह आ हुनका जँचबाक लेल पुछलथिन, “की धर्म-नियमक अनुसार पुरुष केँ केहनो कारण सँ अपना स्‍त्री केँ तलाक देनाइ उचित अछि?” ");
INSERT INTO mai_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","यीशु उत्तर देलथिन, “की अहाँ सभ नहि पढ़ने छी जे, सृष्‍टि कयनिहार शुरुए सँ मनुष्‍य केँ ‘पुरुष आ स्‍त्री बनौलनि’, ");
INSERT INTO mai_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","और कहलनि, ‘एहि कारणेँ पुरुष अपन माय-बाबू केँ छोड़ि अपन स्‍त्रीक संग रहत, आ दूनू एक शरीर भऽ जायत।’? ");
INSERT INTO mai_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","एहि तरहेँ ओ सभ आब दू नहि अछि, एके भऽ गेल। तेँ जकरा परमेश्‍वर जोड़ि देलथिन, तकरा मनुष्‍य अलग नहि करओ।” ");
INSERT INTO mai_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","फरिसी सभ पुछलथिन, “तखन तलाकनामा दऽ कऽ तलाक देबाक आज्ञा मूसा किएक देलनि?” ");
INSERT INTO mai_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","यीशु कहलथिन, “अहाँ सभक मोनक कठोरताक कारणेँ मूसा अहाँ सभ केँ स्‍त्री केँ तलाक देबाक अनुमति देलनि, मुदा शुरू सँ एहन नहि छल। ");
INSERT INTO mai_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","हम अहाँ सभ केँ कहैत छी, जे केओ एहि कारण केँ छोड़ि जे ओकर स्‍त्री दोसराक संग गलत शारीरिक सम्‍बन्‍ध रखने अछि, कोनो आन कारण सँ अपना स्‍त्री केँ तलाक दऽ कऽ दोसर सँ विवाह करैत अछि, से परस्‍त्रीगमन करैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","यीशुक शिष्‍य सभ हुनका कहलथिन, “जँ स्‍त्री-पुरुषक सम्‍बन्‍ध एहन अछि, तँ विवाह नहिए कयनाइ नीक बात।” ");
INSERT INTO mai_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","यीशु हुनका सभ केँ कहलथिन, “सभ केओ एहि बात केँ स्‍वीकार नहि कऽ सकैत अछि, मात्र ओ सभ जकरा एहि बातक लेल वरदान भेटल छैक। ");
INSERT INTO mai_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","किएक तँ किछु लोक मे जन्‍मे सँ विवाह करबाक योग्‍यता नहि अछि, किछु लोक केँ दोसर मनुष्‍य अयोग्‍य बनबैत अछि, और किछु लोक एहनो अछि जे स्‍वर्गक राज्‍यक लेल विवाह कयनाइ त्‍यागि देने अछि। जे केओ एहि बात केँ स्‍वीकार कऽ सकैत अछि से एकरा स्‍वीकार करओ।” ");
INSERT INTO mai_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","तकरबाद किछु गोटे बच्‍चा सभ केँ यीशु लग अनलकनि जाहि सँ ओ ओकरा सभ पर हाथ राखि कऽ ओकरा सभक लेल प्रार्थना कऽ देथिन, मुदा हुनकर शिष्‍य सभ ओकरा सभ केँ डाँटि देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","यीशु कहलथिन, “बच्‍चा सभ केँ हमरा लग आबऽ दिऔक, ओकरा सभ केँ नहि रोकिऔक, किएक तँ स्‍वर्गक राज्‍य एहने सभक अछि।” ");
INSERT INTO mai_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","यीशु ओहि बच्‍चा सभक माथ पर हाथ राखि कऽ आशीर्वाद देलथिन आ ओतऽ सँ विदा भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","यीशु लग एक युवक अयलनि आ कहलकनि, “यौ गुरुजी, हम कोन उत्तम काज करू, जाहि सँ हमरा अनन्‍त जीवन भेटत?” ");
INSERT INTO mai_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","यीशु कहलथिन, “अहाँ हमरा सँ उत्तमक विषय मे किएक पुछैत छी? उत्तम तँ मात्र एकेटा छथि। जँ अहाँ अनन्‍त जीवन मे प्रवेश करऽ चाहैत छी तँ परमेश्‍वरक आज्ञा सभक पालन करू।” ");
INSERT INTO mai_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ओ पुछलकनि, “कोन आज्ञा सभ?” एहि पर यीशु कहलथिन, “ ‘हत्‍या नहि करह, परस्‍त्रीगमन नहि करह, चोरी नहि करह, झूठ गवाही नहि दैह, ");
INSERT INTO mai_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","अपन माय-बाबूक आदर करह’ आ ‘अपना पड़ोसी सँ अपने जकाँ प्रेम करह।’” ");
INSERT INTO mai_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ओ युवक उत्तर देलकनि, “एहि सभ आज्ञाक पालन तँ हम कऽ रहल छी, तखन फेर हमरा मे कोन बातक कमी रहि गेल?” ");
INSERT INTO mai_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","यीशु ओकरा कहलथिन, “अहाँ जँ पूर्ण सिद्ध बनऽ चाहैत छी, तँ अपन धन-सम्‍पत्ति बेचि कऽ ओकरा गरीब सभ मे बाँटि दिअ; अहाँ केँ स्‍वर्ग मे धन भेटत। तकरबाद आउ आ हमरा पाछाँ चलू।” ");
INSERT INTO mai_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ई बात सुनि युवक उदास भऽ ओतऽ सँ चल गेल, कारण, ओकरा बहुत धन-सम्‍पत्ति छलैक। ");
INSERT INTO mai_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","एहि पर यीशु अपना शिष्‍य सभ केँ कहलथिन, “हम अहाँ सभ केँ सत्‍य कहैत छी, धनिक सभक लेल स्‍वर्गक राज्‍य मे प्रवेश कयनाइ कठिन अछि। ");
INSERT INTO mai_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","हम अहाँ सभ केँ फेर कहैत छी जे, धनिक केँ परमेश्‍वरक राज्‍य मे प्रवेश कयनाइ सँ ऊँट केँ सुइक भूर दऽ कऽ निकलनाइ आसान अछि।” ");
INSERT INTO mai_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ई सुनि हुनकर शिष्‍य सभ अवाक भऽ कऽ कहलथिन, “तखन उद्धार ककर भऽ सकैत छैक?!” ");
INSERT INTO mai_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","यीशु हुनका सभक दिस एकटक देखैत कहलथिन, “मनुष्‍यक लेल तँ ई असम्‍भव अछि, मुदा परमेश्‍वरक लेल सभ किछु सम्‍भव अछि।” ");
INSERT INTO mai_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","एहि पर पत्रुस कहलथिन, “देखू, हम सभ तँ सभ किछु त्‍यागि कऽ अहाँक पाछाँ आयल छी। हमरा सभ केँ की भेटत?” ");
INSERT INTO mai_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","यीशु हुनका सभ केँ कहलथिन, “हम अहाँ सभ केँ सत्‍य कहैत छी, नव सृष्‍टि मे, जहिया मनुष्‍य-पुत्र अपन महिमामय सिंहासन पर विराजमान होयत, तहिया अहूँ सभ, जे सभ हमरा पाछाँ आयल छी, बारहटा सिंहासन पर बैसब आ इस्राएलक बारहो कुलक न्‍याय करब। ");
INSERT INTO mai_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","जे केओ हमरा कारणेँ अपन घर, भाय, बहिन, माय-बाबू, बाल-बच्‍चा वा जमीन-जालक त्‍याग कयने अछि, से तकर सय गुना पाओत और अनन्‍त जीवनक अधिकारी होयत। ");
INSERT INTO mai_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","मुदा बहुतो लोक जे एखन आगाँ अछि से पाछाँ भऽ जायत, आ जे एखन पाछाँ अछि से आगाँ भऽ जायत। ");
INSERT INTO mai_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“स्‍वर्गक राज्‍य एहन एक गृहस्‍थ जकाँ अछि जे अपन अंगूरक बगान मे काज करयबाक लेल भोरे-भोर मजदूर तकबाक लेल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ओ मजदूर सभक संग एक दिनक चानीक एक रुपैया मजदूरी देबाक व्‍यवस्‍था कऽ ओकरा सभ केँ अपन अंगूरक बगान मे काज करबाक लेल पठौलनि। ");
INSERT INTO mai_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ओ फेर नौ बजे बाहर गेलाह तँ आरो मजदूर सभ केँ बजार मे निरर्थक ठाढ़ देखलनि। ");
INSERT INTO mai_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ओ ओकरा सभ केँ कहलथिन, ‘तोहूँ सभ हमर अंगूरक बगान मे जा कऽ काज करह। जे उचित होयतह से हम तोरो सभ केँ देबह।’ ");
INSERT INTO mai_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","मजदूर सभ जा कऽ काज करऽ लागल। मालिक फेर बारह बजे आ तीन बजे बाहर जा-जा कऽ ओहिना कयलनि। ");
INSERT INTO mai_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","साँझ पाँच बजे फेर ओ बहरयलाह। ओ किछु आओर मजदूर सभ केँ ओहिना ठाढ़ देखि पुछलथिन, ‘तोँ सभ एतऽ दिन भरि किएक निरर्थक ठाढ़ रहलह?’ ");
INSERT INTO mai_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ओ सभ कहलकनि, ‘हमरा सभ केँ केओ नहि काजक लेल अढ़ौलक।’ मालिक ओकरा सभ केँ कहलथिन, ‘तोहूँ सभ हमर बगान मे जा कऽ काज करह।’ ");
INSERT INTO mai_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“साँझ भऽ गेला पर अंगूर-बगानक मालिक अपन मुख्‍य नोकर केँ बजा कऽ कहलथिन, ‘मजदूर सभ केँ बजाबह आ सभ सँ अन्‍तिम पहर मे जे सभ आयल तकरा सभ सँ शुरू कऽ कऽ सभ सँ पहिल पहर मे आबऽ वला धरि, सभ केँ मजदूरी दऽ दहक।’ ");
INSERT INTO mai_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","जखन ओ सभ, जे साँझ लगभग पाँच बजे सँ काज शुरू कयने छल, से सभ आयल तँ ओकरा सभ केँ चानीक एक-एक रुपैया देल गेलैक। ");
INSERT INTO mai_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","जे मजदूर सभ भोरे सँ काज कयने छल जखन ई बात देखलक, तँ ओ सभ बुझलक जे हमरा सभ केँ बेसी मजदूरी भेटत। मुदा ओकरो सभ केँ चानीक एक-एक रुपैया मजदूरी भेटलैक। ");
INSERT INTO mai_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ओ सभ अपन मजदूरी पाबि मालिक पर कुड़बुड़ाय लागल। ");
INSERT INTO mai_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ओ सभ बाजल, ‘सभ सँ पाछाँ आबऽ वला ई मजदूर सभ, जे सभ एके घण्‍टा काज कयलक, तकरो अहाँ हमरा सभक बराबरि बुझलहुँ। हम सभ तँ घाम-पसिना सहि दिन भरि खटलहुँ!’ ");
INSERT INTO mai_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“मालिक ओहि मे सँ एक गोटे केँ उत्तर देलथिन, ‘हौ मित्र, हम तोरा संग कोनो तरहक अन्‍याय तँ नहि कऽ रहल छिअह। की तोँ हमरा संग चानीक एक रुपैया मजदूरी लेबाक व्‍यवस्‍था नहि कयने छलह? ");
INSERT INTO mai_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","अपन पाइ लैह आ जाह। ई तँ हमर इच्‍छाक बात अछि जे जतबा तोरा देलिअह ततेक पछो सँ आबऽ वला मजदूर सभ केँ सेहो दिऐक। ");
INSERT INTO mai_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","की हमर ई अधिकार नहि अछि जे, जे हमर वस्‍तु अछि तकरा हम जेना चाही, तेना प्रयोग कऽ सकी? हम जँ अपना खुशी सँ ककरो बेसिओ दैत छी तँ की से तोरा अखड़ैत छह?’ ” ");
INSERT INTO mai_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","तखन यीशु आगाँ कहलनि, “एहि तरहेँ जे अन्‍तिम अछि से पहिल होयत, आ जे पहिल अछि से अन्‍तिम।” ");
INSERT INTO mai_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","यीशु यरूशलेम नगर दिस आगाँ बढ़ि रहल छलाह। ओ अपन बारहो शिष्‍य केँ एक कात लऽ जा कऽ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“सुनू, अपना सभ यरूशलेम जा रहल छी। ओतऽ मनुष्‍य-पुत्र मुख्‍यपुरोहित आ धर्मशिक्षक सभक हाथ मे पकड़ाओल जायत। ओ सभ ओकरा मृत्‍युदण्‍डक जोगरक ठहरा देतैक ");
INSERT INTO mai_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","आ ओकरा गैर-यहूदी सभक हाथ मे सौंपि देतैक जाहि सँ ओ सभ ओकर हँसी उड़बैक, कोड़ा सँ पिटैक आ क्रूस पर टाँगि कऽ मारि दैक। मुदा तेसर दिन ओ फेर जिआओल जायत।” ");
INSERT INTO mai_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","तकरबाद जबदीक स्‍त्री, याकूब आ यूहन्‍नाक माय, अपन पुत्र सभक संग यीशु लग अयलनि आ हुनका आगाँ ठेहुनिया दऽ कऽ किछु माँगऽ चाहलकनि। ");
INSERT INTO mai_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","यीशु पुछलथिन, “अहाँ की चाहैत छी?” ओ कहलकनि, “अहाँ एहि बातक आज्ञा दिअ जे अहाँक राज्‍य मे हमर ई दूनू बेटा, एक अहाँक दहिना कात आ दोसर अहाँक बामा कात बैसत।” ");
INSERT INTO mai_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","यीशु हुनका सभ केँ उत्तर देलथिन, “अहाँ सभ की माँगि रहल छी, से अहाँ सभ नहि बुझैत छी। की दुःखक बाटी सँ जे हमरा पिबाक अछि से अहाँ सभ पिबि सकैत छी?” ओ सभ कहलकनि, “हँ, पिबि सकैत छी।” ");
INSERT INTO mai_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","यीशु कहलथिन, “हमर बाटी तँ अहाँ सभ पीब, मुदा किनको अपना दहिना कात वा बामा कात बैसायब, तकर अधिकार हमर नहि अछि। ई स्‍थान सभ तिनका सभक लेल छनि, जिनका सभक लेल हमर पिता तैयार कयने छथि।” ");
INSERT INTO mai_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","जखन बाँकी दस शिष्‍य एहि बातक बारे मे सुनलनि तँ ओ सभ ओहि दूनू भाइ पर खिसिआय लगलाह। ");
INSERT INTO mai_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","एहि पर यीशु शिष्‍य सभ केँ अपना लग बजा कऽ कहलथिन, “अहाँ सभ जनैत छी जे एहि संसारक शासक सभ जनता पर हुकुम चलबैत रहैत छथि और जनता मे जे पैघ लोक सभ छथि से जनता पर अधिकार जमबैत छथि। ");
INSERT INTO mai_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","मुदा अहाँ सभ मे एना नहि होअय। बल्‍कि, अहाँ सभ मे जे पैघ होमऽ चाहय, से अहाँ सभक सेवक बनय, ");
INSERT INTO mai_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","आ जे केओ अहाँ सभ मे प्रमुख व्‍यक्‍ति बनऽ चाहय, से टहलू बनय। ");
INSERT INTO mai_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","तहिना मनुष्‍य-पुत्र सेहो एहि लेल नहि आयल अछि जे ओ अपन सेवा कराबय, बल्‍कि एहि लेल जे ओ सेवा करय और बहुतो लोकक छुटकाराक मूल्‍य मे अपन प्राण देअय।” ");
INSERT INTO mai_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","यीशु आ हुनकर शिष्‍य सभ जखन यरीहो नगर सँ बहरयलाह तँ लोकक बड़का भीड़ हुनका पाछाँ आबि रहल छलनि। ");
INSERT INTO mai_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","रस्‍ताक कात मे बैसल दू आन्‍हर व्‍यक्‍ति जखन सुनलक जे एहि बाटे यीशु जा रहल छथि, तँ ओ सभ सोर पारि कऽ कहऽ लागल जे, “हे प्रभु, दाऊदक पुत्र, हमरा सभ पर दया करू!” ");
INSERT INTO mai_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","भीड़क लोक सभ ओकरा दूनू केँ डाँटि देलकैक जे, “चुप होइ जाइ जो,” मुदा ओ सभ आओर जोर सँ हल्‍ला कऽ कऽ कहऽ लागल, “यौ प्रभु, दाऊदक पुत्र, हमरा सभ पर दया करू!” ");
INSERT INTO mai_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","यीशु ठाढ़ भऽ गेलाह आ ओकरा सभ केँ बजा कऽ पुछलथिन, “तोँ सभ की चाहैत छह, हम तोरा सभक लेल की करिअह?” ");
INSERT INTO mai_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ओ सभ बाजल, “हे प्रभु, हम सभ देखऽ चाहैत छी।” ");
INSERT INTO mai_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","यीशु केँ ओकरा सभ पर दया आबि गेलनि, आ ओकरा सभक आँखि केँ छुबि देलथिन। तखने सँ ओकरा सभ केँ देखाइ देबऽ लगलैक और ओ सभ हुनका पाछाँ चलऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","यीशु आ हुनकर शिष्‍य सभ जखन यरूशलेम नगरक लग मे जैतून पहाड़ पर बेतफगे गाम मे पहुँचलाह तखन यीशु दूटा शिष्‍य केँ ई कहि कऽ पठौलथिन जे, ");
INSERT INTO mai_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“सामने मे जे गाम अछि, ताहि मे जाउ। ओतऽ पहुँचिते एक गदही अपन बच्‍चाक संग बान्‍हल भेटत। ओकरा सभ केँ खोलि कऽ हमरा लग नेने आउ। ");
INSERT INTO mai_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","जँ केओ अहाँ सभ केँ किछु कहय तँ कहबैक जे, ‘प्रभु केँ एकर आवश्‍यकता छनि।’ ई सुनैत देरी ओ अहाँ सभ केँ आनऽ देत।” ");
INSERT INTO mai_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ई एहि लेल भेल जे परमेश्‍वरक प्रवक्‍ताक कहल ई वचन पूरा होअय जे, ");
INSERT INTO mai_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सियोन नगर केँ कहक, ‘देखह, तोहर राजा तोरा लग आबि रहल छथुन, ओ विनम्र छथि, ओ गदहा पर, गदहीक बच्‍चा पर बैसल आबि रहल छथुन।’ ” ");
INSERT INTO mai_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","शिष्‍य सभ जा कऽ यीशुक कहल अनुसार कयलनि। ");
INSERT INTO mai_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ओ सभ गदही आ ओकर बच्‍चा केँ लऽ आनि ओकरा पीठ पर अपन कपड़ा सभ राखि देलनि। यीशु ओहि पर बैसि गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","भीड़ मे सँ बहुतो लोक सभ सेहो अपन-अपन वस्‍त्र आ ओढ़नी सभ बाट पर ओछौलक। दोसर लोक सभ गाछ-वृक्षक ठाढ़ि-पात काटि-काटि कऽ ओछौलक। ");
INSERT INTO mai_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","यीशुक आगाँ-पाछाँ चलऽ वला लोकक भीड़ एहि तरहेँ जयजयकार करऽ लागल जे, “दाऊदक पुत्र केँ जय! धन्‍य छथि ओ जे प्रभुक नाम सँ अबैत छथि! सर्वोच्‍च स्‍वर्ग मे प्रभुक जयजयकार!” ");
INSERT INTO mai_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","जखन यीशु यरूशलेम मे प्रवेश कयलनि तँ सम्‍पूर्ण नगर मे हलचल सन होमऽ लागल। सभ पुछैत छल, “ई के छथि?” ");
INSERT INTO mai_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","आगाँ-पाछाँ चलऽ वला भीड़क लोक सभ ओकरा सभ केँ कहलकैक, “ई गलील प्रदेशक नासरत-निवासी परमेश्‍वरक प्रवक्‍ता यीशु छथि।” ");
INSERT INTO mai_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","यीशु मन्‍दिरक आङन मे अयलाह आ बेचऽ वला और किनऽ वला सभ केँ ओतऽ सँ बाहर भगाबऽ लगलाह। ओ पाइ भजौनिहार सभक टेबुल आ परबा-पेउरकी बेचनिहार सभक पीढ़ी-बैसकी सभ केँ उनटा-पुनटा देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ओ ओकरा सभ केँ कहलथिन, “धर्मशास्‍त्र मे लिखल अछि जे, ‘हमर घर प्रार्थनाक घर कहाओत’ मुदा तोँ सभ एकरा ‘चोर-डाकूक अड्डा’ बना देने छह।” ");
INSERT INTO mai_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","मन्‍दिर मे यीशु लग आन्‍हर आ नाङड़ व्‍यक्‍ति सभ अयलनि आ यीशु ओकरा सभ केँ स्‍वस्‍थ कऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","यीशुक चमत्‍कार वला काज सभ देखि आ मन्‍दिर मे बच्‍चा सभक द्वारा जे “दाऊदक पुत्र”क जयजयकार भऽ रहल छल, तकरा सुनि मुख्‍यपुरोहित आ धर्मशिक्षक सभ बहुत खिसिआ गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ओ सभ यीशु केँ कहलथिन, “की अहाँ नहि सुनैत छी जे ई सभ की कहि रहल अछि?” यीशु हुनका सभ केँ कहलथिन, “हँ, और की अहाँ सभ नहि पढ़ने छी जे, ‘हे प्रभु, अहाँ धिआ-पुता आ कोरा मेहक बच्‍चा सभक मुँह सँ अपन स्‍तुति करबौलहुँ’?” ");
INSERT INTO mai_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","एतेक कहि यीशु हुनका सभ केँ ओतहि छोड़ि नगर सँ बहरा गेलाह आ बेतनिया गाम मे जा कऽ राति भरि ओतऽ रहलाह। ");
INSERT INTO mai_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","भोर मे फेर नगर दिस अबैत समय मे यीशु केँ भूख लगलनि। ");
INSERT INTO mai_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","रस्‍ताक कात मे एक अंजीरक गाछ देखि ओ गाछ लग गेलाह। मुदा ओहि पर पात छोड़ि आओर किछु नहि भेटलनि। यीशु ओहि गाछ केँ कहलथिन, “जो, आब कहियो तोरा पर फल नहि लटकतौ!” गाछ ओही क्षण सुखा गेल। ");
INSERT INTO mai_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ई देखि शिष्‍य सभ आश्‍चर्यित भऽ कहलथिन, “ई अंजीरक गाछ तुरत कोना सुखा गेल?” ");
INSERT INTO mai_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","एहि पर यीशु उत्तर देलथिन, “हम अहाँ सभ केँ सत्‍य कहैत छी जे, जँ अहाँ सभ बिनु सन्‍देह कऽ विश्‍वास करब, तँ अहाँ सभ मात्र एतबे नहि करब जे एहि अंजीरक गाछक संग भेल, बल्‍कि जँ अहाँ सभ एहि पहाड़ केँ आज्ञा देबैक जे, ‘एतऽ सँ हट आ समुद्र मे जो,’ तँ सेहो भऽ जायत। ");
INSERT INTO mai_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","अहाँ सभ जे किछु प्रार्थना मे विश्‍वासक संग माँगब, से अहाँ सभ केँ प्राप्‍त होयत।” ");
INSERT INTO mai_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","यीशु जखन मन्‍दिर मे जा कऽ उपदेश दऽ रहल छलाह तखन मुख्‍यपुरोहित आ समाजक बूढ़-प्रतिष्‍ठित सभ यीशु लग आबि कऽ कहलथिन, “अहाँ कोन अधिकार सँ ई सभ बात कऽ रहल छी? अहाँ केँ ई अधिकार के देलनि?” ");
INSERT INTO mai_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","यीशु हुनका सभ केँ उत्तर देलथिन, “हमहूँ अहाँ सभ सँ एकटा बात पुछैत छी। जँ अहाँ सभ हमरा तकर जबाब देब तँ हमहूँ अहाँ सभ केँ कहब जे कोन अधिकार सँ हम ई सभ बात कऽ रहल छी। ");
INSERT INTO mai_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","यूहन्‍ना केँ बपतिस्‍मा देबाक अधिकार कतऽ सँ भेटल छलनि? परमेश्‍वर सँ वा मनुष्‍य सँ?” ई सुनि ओ सभ अपना मे तर्क-वितर्क करऽ लगलाह जे, “जँ अपना सभ कहबैक जे ‘परमेश्‍वर सँ’, तँ ओ पुछत जे, तखन अहाँ सभ हुनकर बातक विश्‍वास किएक नहि कयलहुँ? ");
INSERT INTO mai_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","मुदा जँ कहबैक जे, ‘मनुष्‍य सँ’ तँ अपना सभ केँ जनता सँ डर अछि, कारण सभ लोक यूहन्‍ना केँ परमेश्‍वरक प्रवक्‍ता मानैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","तेँ ओ सभ यीशु केँ उत्तर देलथिन जे, “हम सभ नहि जनैत छी।” एहि पर यीशु हुनका सभ केँ कहलथिन, “तखन हमहूँ अहाँ सभ केँ नहि कहब जे कोन अधिकार सँ हम ई काज कऽ रहल छी। ");
INSERT INTO mai_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“अच्‍छा, अहाँ सभक की विचार अछि? एक गोटे केँ दूटा बेटा छलनि। ओ जेठका केँ कहलथिन, ‘बौआ, आइ अंगूरक बाड़ी मे काज करऽ जाह।’ ");
INSERT INTO mai_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","बेटा कहलकनि, ‘हम नहि जायब,’ मुदा बाद मे ओकरा पछतावा भेलैक आ ओ काज करबाक लेल गेल। ");
INSERT INTO mai_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","तखन बाबू दोसरो बेटा लग जा कऽ यैह बात कहलथिन। ओ उत्तर देलकनि, ‘ठीक अछि, बाबूजी, हम जाइत छी।’ मुदा ओ नहि गेल। ");
INSERT INTO mai_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","आब कहू, एकरा सभ मे सँ के अपन बाबूक इच्‍छानुरूप कयलक?” ओ सभ कहलथिन, “पहिल वला।” यीशु हुनका सभ केँ कहलथिन, “हम अहाँ सभ केँ सत्‍य कहैत छी, कर असूल कयनिहार आ वेश्‍या सभ परमेश्‍वरक राज्‍य मे अहाँ सभ सँ आगाँ प्रवेश कऽ रहल अछि। ");
INSERT INTO mai_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","यूहन्‍ना धार्मिकताक बाट देखबैत अहाँ सभ लग अयलाह और अहाँ सभ हुनकर बातक विश्‍वास नहि कयलहुँ, मुदा कर असूल कयनिहार आ वेश्‍या सभ विश्‍वास कयलक। अहाँ सभ ई बात देखलाक बादो अपना पापक लेल पश्‍चात्ताप और हृदय-परिवर्तन कऽ कऽ हुनकर बातक विश्‍वास नहि कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“एक आओर दृष्‍टान्‍त सुनू। एक गृहस्‍थ लोक छलाह। ओ एक अंगूरक बगान लगौलनि आ चारू कात सँ ओकरा घेरि देलनि। अंगूरक रस जमा करबाक लेल ओ एक रसकुण्‍ड बनौलनि आ रखबारीक लेल मचान बनौलनि। तकरबाद किसान सभ केँ बटाइ पर दऽ कऽ परदेश चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","फलक समय अयला पर ओ अपन हिस्‍सा लेबाक लेल नोकर सभ केँ बटाइदार सभ लग पठौलथिन। ");
INSERT INTO mai_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","मुदा बटाइदार सभ हुनकर नोकर सभ केँ पकड़ि, एकटा केँ पिटलक, एकटाक हत्‍या कऽ देलक और एकटा केँ पथरबाहि कयलक। ");
INSERT INTO mai_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","तखन मालिक पहिल बेर सँ बेसी, आरो नोकर सभ केँ पठौलथिन। मुदा बटाइदार सभ ओकरो सभक संग वैह व्‍यवहार कयलक। ");
INSERT INTO mai_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","अन्‍त मे मालिक अपना बेटा केँ ओकरा सभ लग पठौलथिन, ई सोचि जे, ओ सभ हमरा बेटाक आदर करत। ");
INSERT INTO mai_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“मुदा बटाइदार सभ जखन मालिकक बेटा केँ देखलक तँ ओ सभ अपना मे कहऽ लागल जे, ‘ई अपन बापक उत्तराधिकारी अछि। चलू एकरा मारि कऽ समाप्‍त कऽ दी, और ई सम्‍पत्ति जे एकरा भेटऽ वला छैक ताहि पर अधिकार कऽ ली।’ ");
INSERT INTO mai_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","एना सोचि ओ सभ हुनका पकड़ि लेलकनि आ बगान सँ बाहर लऽ जा कऽ जान सँ मारि देलकनि। ");
INSERT INTO mai_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“आब कहू, बगानक मालिक जहिया औताह तँ ओ एहि बटाइदार सभ केँ की करथिन?” ");
INSERT INTO mai_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ओ सभ उत्तर देलथिन, “ओ ओहि दुष्‍ट बटाइदार सभक सर्वनाश करताह आ अंगूरक बगान ओहन बटाइदार सभ केँ दऽ देथिन जे फलक समय अयला पर हुनकर हिस्‍सा देतनि।” ");
INSERT INTO mai_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","यीशु हुनका सभ केँ कहलथिन, “की अहाँ सभ धर्मशास्‍त्र मे ई कहियो नहि पढ़ने छी?— ‘जाहि पाथर केँ राजमिस्‍तिरी सभ बेकार बुझि कऽ फेकि देलक, वैह पाथर मकानक प्रमुख पाथर भऽ गेल। ई काज प्रभु-परमेश्‍वर कयलनि, और ई हमरा सभक नजरि मे अद्‌भुत बात अछि!’ ");
INSERT INTO mai_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","एहि लेल हम अहाँ सभ केँ कहैत छी, परमेश्‍वरक राज्‍यक अधिकार अहाँ सभ सँ छिनि लेल जायत आ ताहि समूहक लोक सभक जिम्‍मा मे देल जयतैक जे एकर उचित फल लाओत। ");
INSERT INTO mai_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","जे केओ एहि पाथर पर खसत से चकना-चूर भऽ जायत, और जकरा पर ई पाथर खसतैक से थकुचा-थकुचा भऽ जायत।” ");
INSERT INTO mai_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","मुख्‍यपुरोहित आ फरिसी सभ हुनकर दृष्‍टान्‍त सभ सुनि कऽ बुझि गेलाह जे, ई हमरे सभक सम्‍बन्‍ध मे ई सभ बात कहि रहल अछि। ");
INSERT INTO mai_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ओ सभ यीशु केँ बन्‍दी कोना बनाओल जाय तकर उपाय सोचऽ लगलाह। मुदा हुनका सभ केँ डर होइत छलनि, कारण जनता यीशु केँ परमेश्‍वरक प्रवक्‍ता मानैत छलनि। ");
INSERT INTO mai_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","यीशु फेर दृष्‍टान्‍त दऽ कऽ हुनका सभ केँ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“स्‍वर्गक राज्‍यक तुलना एक एहन राजा सँ कयल जा सकैत अछि जे अपन पुत्रक विवाहक उत्‍सव पर भोजक आयोजन कयलनि। ");
INSERT INTO mai_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ओ अपन नोकर सभ केँ पठौलनि जे उत्‍सव मे निमन्‍त्रित लोक सभ केँ बिझो करा लाबय। मुदा निमन्‍त्रित लोक सभ नहि आबऽ चाहलक। ");
INSERT INTO mai_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","राजा फेर दोसरो नोकर सभ केँ ई कहि कऽ पठौलनि जे, ‘आमन्‍त्रित लोक सभ केँ ई कहि दिऔन जे, देखू, भोजक लेल सभ वस्‍तु तैयार भऽ गेल अछि, हमर पालल-मोटायल पशु सभक वध कऽ सभ किछु बना लेल गेल अछि, तेँ भोज खयबाक लेल चलै जाइ जाउ।’ ");
INSERT INTO mai_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","मुदा नोतल लोक सभ राजाक आग्रह पर कोनो ध्‍यान नहि देलक। ओकरा सभ मे सँ केओ अपन खेतक काजक लेल तँ केओ अपन व्‍यापारक काजक लेल चल गेल। ");
INSERT INTO mai_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","बाँकी लोक राजाक नोकर सभ केँ पकड़ि कऽ ओकरा सभक संग दुर्व्‍यवहार कयलक आ जान सँ मारि देलक। ");
INSERT INTO mai_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“एहि पर राजा क्रोधित भऽ अपन सैनिक सभ केँ पठा कऽ ओहि हत्‍यारा सभ केँ मरबा देलथिन आ ओकरा सभक नगर केँ जरबा देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","तकरबाद ओ अपन नोकर सभ केँ कहलथिन, ‘विवाहक भोज तँ तैयार अछि, मुदा निमन्‍त्रित लोक सभ एहि भोज मे खाय ताहि जोगरक नहि छल। ");
INSERT INTO mai_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","तेँ तोँ सभ चौबट्टिआ सभ पर जाह आ जे केओ भेटह, तकरा सभ केँ भोज मे बजा आनह।’ ");
INSERT INTO mai_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","नोकर सभ चौबट्टिआ आ सड़क सभ पर गेल आ नीक-अधलाह जे केओ भेटलैक, सभ केँ बजा अनलक। एतेक लोक आयल जे विवाह-भोजक घर ओकरा सभ सँ भरि गेलैक। ");
INSERT INTO mai_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“राजा उपस्‍थित लोक सभ केँ देखबाक लेल भीतर अयलाह तँ हुनकर नजरि एक एहन व्‍यक्‍ति पर पड़लनि जे विवाह-उत्‍सवक लेल अनुकूल वस्‍त्र नहि पहिरने छल। ");
INSERT INTO mai_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","राजा ओकरा पुछलथिन, ‘यौ मित्र, अहाँ बिनु विवाह-उत्‍सवक वस्‍त्र पहिरने भीतर कोना आबि गेलहुँ?’ ओ व्‍यक्‍ति राजा केँ कोनो उत्तर नहि दऽ सकलनि। ");
INSERT INTO mai_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","एहि पर राजा अपन सेवक सभ केँ कहलथिन, ‘एकरा हाथ-पयर बान्‍हि कऽ बाहर अन्‍हार मे फेकि दैह जतऽ लोक कनैत आ दाँत कटकटबैत रहैत अछि।’ ” ");
INSERT INTO mai_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","तकरबाद यीशु कहलथिन, “बजाओल लोक तँ बहुत अछि, मुदा ओहि मे चुनल लोक किछुए अछि।” ");
INSERT INTO mai_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","तखन फरिसी सभ जा कऽ विचार-विमर्श करऽ लगलाह जे कोन तरहेँ यीशु केँ अपन कहल बातक जाल मे फँसाओल जाय। ");
INSERT INTO mai_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ओ सभ यीशु लग हेरोद-दलक सदस्‍य सभ और अपन किछु चेला सभ केँ पठौलथिन। ओ सभ आबि कऽ यीशु केँ कहलकनि, “गुरुजी, हम सभ जनैत छी जे अपने सत्‍यवादी छी, सत्‍यक अनुसार परमेश्‍वरक बाटक शिक्षा दैत छी आ केओ की सोचैत अछि, तकर अपने केँ कोनो चिन्‍ता नहि। कारण, अपने मुँह-देखी बात नहि करैत छी। ");
INSERT INTO mai_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","आब हमरा सभ केँ एकटा बात कहल जाओ—एहि बातक सम्‍बन्‍ध मे अपनेक की विचार अछि? रोमी सम्राट-कैसर केँ कर देब धर्म-नियमक अनुसार उचित अछि वा नहि?” ");
INSERT INTO mai_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","यीशु ओकरा सभक दुष्‍ट उद्देश्‍य बुझि कहलथिन, “हे पाखण्‍डी सभ, अहाँ सभ हमरा किएक फँसाबऽ चाहैत छी? ");
INSERT INTO mai_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","अहाँ सभ कोन सिक्‍का लऽ कऽ कर चुकबैत छी?—देखाउ!” ओ सभ यीशु केँ एक दिनारक सिक्‍का देलकनि। ");
INSERT INTO mai_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","यीशु सिक्‍का लऽ प्रश्‍न कयलथिन, “ई किनकर चित्र छनि? आ एहि पर किनकर नाम लिखल छनि?” ");
INSERT INTO mai_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ओ सभ उत्तर देलकनि, “सम्राट-कैसरक।” तखन यीशु ओकरा सभ केँ कहलथिन, “जे सम्राटक छनि से सम्राट केँ दिऔन, आ जे परमेश्‍वरक छनि से परमेश्‍वर केँ दिऔन।” ");
INSERT INTO mai_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","यीशुक जबाब सुनि ओ सभ गुम्‍म भऽ गेल आ हुनका लग सँ चल गेल। ");
INSERT INTO mai_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ओही दिन सदुकी पंथक लोक, जे सभ एहि बात केँ नहि मानैत अछि जे मृत्‍यु मे सँ मनुष्‍य फेर जिआओल जायत, से सभ एकटा प्रश्‍न लऽ कऽ यीशु लग आयल। ");
INSERT INTO mai_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ओ सभ कहलकनि, “गुरुजी, धर्मशास्‍त्र मे मूसा कहने छथि जे, जँ कोनो पुरुष निःसन्‍तान मरि जाय तँ ओकरा भाय केँ ओकर विधवा स्‍त्री सँ विवाह कऽ अपना भायक लेल सन्‍तान केँ उत्‍पन्‍न करबाक चाही। ");
INSERT INTO mai_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","हमरा सभक ओहिठाम सात भाय छल। जेठ भाय विवाह कयलक आ मरि गेल। ओकरा कोनो सन्‍तान नहि होयबाक कारणेँ ओकर भाय ओकर स्‍त्री सँ विवाह कयलक। ");
INSERT INTO mai_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","एही तरहेँ दोसर आ तेसरो भायक संग, आ होइत-होइत सातो भायक संग यैह बात भेल। ");
INSERT INTO mai_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","अन्‍त मे जा कऽ ओ स्‍त्री सेहो मरि गेलि। ");
INSERT INTO mai_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","आब कहल जाओ, ओहि समय मे जहिया मुइल सभ केँ जिआओल जयतैक, तँ ओ स्‍त्री एहि सातो भाय मे सँ ककर स्‍त्री होयतैक? किएक तँ ओ सभक स्‍त्री बनल छलि।” ");
INSERT INTO mai_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","यीशु उत्तर देलथिन, “अहाँ सभ ने धर्मशास्‍त्र आ ने परमेश्‍वरक सामर्थ्‍य केँ जनैत छी, तेँ अहाँ सभ केँ एहि तरहेँ धोखा भऽ रहल अछि। ");
INSERT INTO mai_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","जीबि उठाओल गेला पर लोक सभ ने विवाह करत आ ने विवाह मे देल जायत, बल्‍कि ओ सभ स्‍वर्गदूत सभ जकाँ होयत। ");
INSERT INTO mai_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","तखन मुइल सभ केँ जिआओल जयबाक जे बात अछि, ताहि सम्‍बन्‍ध मे की अहाँ सभ ई वचन नहि पढ़ने छी जे परमेश्‍वर ⌞एहि पूर्वज सभक मृत्‍युक बादो⌟ अहाँ सभ केँ कहने छलाह जे, ");
INSERT INTO mai_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘हम अब्राहमक परमेश्‍वर, इसहाकक परमेश्‍वर आ याकूबक परमेश्‍वर छी।’? ओ मरल सभक नहि, बल्‍कि जीवित सभक परमेश्‍वर छथि।” ");
INSERT INTO mai_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ई उत्तर सुनि भीड़क लोक सभ हुनकर उपदेश सँ चकित रहि गेल। ");
INSERT INTO mai_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","फरिसी सभ जखन सुनलनि जे यीशु सदुकी पंथक लोक सभ केँ निरुत्तर कऽ देलथिन तँ ओ सभ जमा भऽ कऽ एक संग यीशु लग अयलाह। ");
INSERT INTO mai_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","हुनका सभ मे सँ एक गोटे जे धर्म-नियमक पंडित छलाह से हुनका जँचबाक लेल पुछलथिन, ");
INSERT INTO mai_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“यौ गुरुजी, धर्म-नियमक सभ सँ पैघ आज्ञा कोन अछि?” ");
INSERT INTO mai_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","यीशु उत्तर देलथिन, “ ‘तोँ अपन प्रभु-परमेश्‍वर केँ अपन सम्‍पूर्ण मोन सँ, अपन सम्‍पूर्ण आत्‍मा सँ आ अपन सम्‍पूर्ण बुद्धि सँ प्रेम करह।’ ");
INSERT INTO mai_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","यैह पहिल आ सभ सँ पैघ आज्ञा अछि। ");
INSERT INTO mai_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","आ दोसर सेहो ओही जकाँ अछि जे, ‘तोँ अपना पड़ोसी केँ अपने जकाँ प्रेम करह।’ ");
INSERT INTO mai_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","सम्‍पूर्ण धर्म-नियम आ परमेश्‍वरक प्रवक्‍ता सभक लेख एही दू आज्ञा पर केन्‍द्रित अछि।” ");
INSERT INTO mai_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ओतऽ जमा भेल फरिसी सभ सँ यीशु पुछलथिन, ");
INSERT INTO mai_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“ ‘उद्धारकर्ता-मसीह’क विषय मे अहाँ सभक की विचार अछि? ओ किनकर वंशज छथि?” ओ सभ उत्तर देलथिन, “दाऊदक।” ");
INSERT INTO mai_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","एहि पर यीशु पुछि देलथिन, “तखन पवित्र आत्‍माक प्रेरणा सँ दाऊद किएक हुनका ‘प्रभु’ कहने छथिन? कारण, दाऊद धर्मशास्‍त्र मे एहि तरहेँ लिखने छथि, ");
INSERT INTO mai_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘प्रभु-परमेश्‍वर हमरा प्रभु केँ कहलथिन, अहाँ हमर दहिना कात बैसू और हम अहाँक शत्रु सभ केँ अहाँक पयरक तर मे कऽ देब।’ ");
INSERT INTO mai_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","जखन दाऊद उद्धारकर्ता-मसीह केँ ‘प्रभु’ कहैत छथिन तँ ओ फेर हुनकर वंशज कोना भेलाह?” ");
INSERT INTO mai_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","एहि बातक उत्तर मे केओ यीशु केँ एको शब्‍द नहि कहि सकल आ ने ओहि दिन सँ ककरो हुनका सँ आरो कोनो प्रश्‍न पुछबाक साहस भेलैक। ");
INSERT INTO mai_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","तकरबाद यीशु जमा भेल लोकक भीड़ केँ आ अपना शिष्‍य सभ केँ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“मूसाक धर्म-नियमक बात सिखयबाक अधिकार धर्मशिक्षक आ फरिसी सभक हाथ मे छनि। ");
INSERT INTO mai_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","तेँ ओ सभ जे किछु कहैत छथि, तकरा मानू आ करू, मुदा जे ओ सभ करैत छथि से नहि करू, कारण ओ सभ लोक सभ केँ जे सिखबैत छथि से अपने नहि करैत छथि। ");
INSERT INTO mai_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ओ सभ भारी बोझ बान्‍हि कऽ लोकक कान्‍ह पर लादि दैत छथि मुदा तकरा उठयबाक लेल ओ सभ स्‍वयं अपन आङुरो नहि भिड़बऽ चाहैत छथि। ");
INSERT INTO mai_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ओ लोकनि सभ काज मात्र लोकक ध्‍यान आकर्षित करबाक लेल करैत छथि। अपन तावीज सभ नमहर आकारक बनबबैत छथि आ पहिरऽ वला वस्‍त्र सभ मे लम्‍बा-लम्‍बा झालैर सभ लगबबैत छथि। ");
INSERT INTO mai_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","भोज-काज मे सम्‍मानित स्‍थान आ सभाघर सभ मे प्रमुख आसन पसन्‍द करैत छथि। ");
INSERT INTO mai_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","हाट-बजार मे लोक सभ हुनका सभ केँ प्रणाम-पात करैत रहनि आ ‘गुरुजी’ कहि कऽ सम्‍बोधन करैत रहनि, से बात सभ हुनका सभ केँ बहुत नीक लगैत छनि। ");
INSERT INTO mai_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“मुदा अहाँ सभ ‘गुरु’ नहि कहाउ, कारण अहाँ सभक गुरु एकेटा छथि आ अहाँ सभ आपस मे भाइ-भाइ छी। ");
INSERT INTO mai_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","पृथ्‍वी पर किनको अपन धर्म-पिता नहि मानू, कारण अहाँ सभक एकेटा पिता छथि जे स्‍वर्ग मे रहैत छथि। ");
INSERT INTO mai_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","आ अहाँ सभ ‘आचार्य’ नहि कहाउ, कारण अहाँ सभक आचार्य सेहो एके गोटे छथि, अर्थात् उद्धारकर्ता-मसीह। ");
INSERT INTO mai_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","अहाँ सभ मे जे सभ सँ पैघ होइ से सभक सेवक बनू। ");
INSERT INTO mai_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","कारण, जे केओ अपना केँ पैघ बुझत से छोट बनाओल जायत, मुदा जे केओ अपना केँ छोट बुझत से पैघ बनाओल जायत। ");
INSERT INTO mai_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“यौ धर्मशिक्षक आ फरिसी सभ, धिक्‍कार अछि अहाँ सभ केँ! अहाँ सभ पाखण्‍डी छी। अहाँ सभ स्‍वर्गक राज्‍यक द्वारि लोक सभक लेल बन्‍द कऽ दैत छी। ने अपने ओहि मे प्रवेश करैत छी आ ने तकरा सभ केँ प्रवेश करऽ दैत छिऐक जे सभ प्रवेश करऽ चाहैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“यौ धर्मशिक्षक आ फरिसी सभ, धिक्‍कार अछि अहाँ सभ केँ! अहाँ सभ पाखण्‍डी छी। अहाँ सभ विधवा सभक घर-द्वारि सभ हड़पि लैत छिऐक। लोक सभ केँ देखयबाक लेल लम्‍बा-लम्‍बा प्रार्थना करैत छी। तेँ अहाँ सभ केँ बेसी दण्‍ड भेटत। ");
INSERT INTO mai_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“यौ धर्मशिक्षक आ फरिसी सभ, धिक्‍कार अछि अहाँ सभ केँ! अहाँ सभ पाखण्‍डी छी। अहाँ सभ एक गोटे केँ अपना धर्म मे अनबाक लेल पृथ्‍वी आ आकाश एकटार कऽ दैत छी, मुदा जखन ओ आबि जाइत अछि तँ ओकरा अपनो सँ दोबर नरक जयबाक जोगरक बना दैत छिऐक। ");
INSERT INTO mai_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“यौ आन्‍हर पथ-प्रदर्शक सभ, धिक्‍कार अछि अहाँ सभ केँ! अहाँ सभ लोक सभ केँ सिखबैत छी जे, ‘जँ केओ मन्‍दिरक नाम लऽ कऽ सपत खायत, तँ तकर कोनो महत्‍व नहि अछि, मुदा जँ मन्‍दिर मे लगाओल सोनक नाम लऽ कऽ सपत खायत, तँ ओकरा अपन सपत केँ पूरा करऽ पड़तैक।’ ");
INSERT INTO mai_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","अहाँ सभ आन्‍हर छी! मूर्ख छी! कोन बात पैघ अछि, लगाओल सोन वा ओ मन्‍दिर, जकरा सँ ओ सोन पवित्र भेल अछि? ");
INSERT INTO mai_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","अहाँ सभ सिखबैत छी जे, ‘जँ केओ बलि-वेदीक नाम लऽ कऽ सपत खयलक तँ से कोनो बात नहि, मुदा वेदी पर चढ़ाओल चढ़ौनाक नाम लऽ कऽ सपत खयलक तँ से पकिया बात भेल।’ ");
INSERT INTO mai_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","यौ आन्‍हर सभ! कोन बात पैघ अछि, चढ़ौना वा ओ वेदी, जाहि पर अर्पण कयला सँ ओ चढ़ौना पवित्र भेल अछि? ");
INSERT INTO mai_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","तेँ, जे केओ वेदीक सपत खाइत अछि से ओहि वेदी आ ओहि पर जे किछु अछि, सभक सपत खाइत अछि। ");
INSERT INTO mai_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","तहिना, जे केओ मन्‍दिरक सपत खाइत अछि से मन्‍दिर आ ओहि मे जे वास करैत छथि, दूनूक सपत खाइत अछि, ");
INSERT INTO mai_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","और जे केओ स्‍वर्गक सपत खाइत अछि, से परमेश्‍वरक सिंहासन आ ओहि पर जे विराजमान छथि तिनको सपत खाइत अछि। ");
INSERT INTO mai_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“यौ धर्मशिक्षक आ फरिसी सभ, धिक्‍कार अछि अहाँ सभ केँ! अहाँ सभ पाखण्‍डी छी! अहाँ सभ पुदीना, सोंफ आ जीरक दसम भाग तँ परमेश्‍वर केँ अर्पण करैत छी, मुदा धर्म-नियमक मुख्‍य बात सभ, जेना न्‍याय, करुणा आ विश्‍वसनियता सँ कोनो मतलब नहि रखैत छी। होयबाक तँ ई चाहैत छल जे अहाँ सभ बिनु ओ बात सभ छोड़ने इहो बात सभ करितहुँ। ");
INSERT INTO mai_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","यौ आन्‍हर पथ-प्रदर्शक सभ, अहाँ सभ तँ मच्‍छर केँ छानि कऽ फेकि दैत छी, मुदा ऊँट केँ घोँटि लैत छी। ");
INSERT INTO mai_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“यौ धर्मशिक्षक आ फरिसी सभ, धिक्‍कार अछि अहाँ सभ केँ! अहाँ सभ पाखण्‍डी छी। अहाँ सभ थारी-बाटी सभ केँ बाहर सँ तँ मँजैत छी, मुदा ओहि मे लूट-पाट आ स्‍वार्थ द्वारा प्राप्‍त कयल वस्‍तु सभ रखैत छी। ");
INSERT INTO mai_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","यौ आन्‍हर फरिसी, थारी-बाटी केँ पहिने भीतर सँ साफ करू, तखन ओ बाहर सँ सेहो साफ रहत। ");
INSERT INTO mai_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“यौ धर्मशिक्षक आ फरिसी सभ, धिक्‍कार अछि अहाँ सभ केँ! अहाँ सभ पाखण्‍डी छी। अहाँ सभ चून सँ पोतल कबरक चबुतरा जकाँ छी, जे बाहर सँ तँ सुन्‍दर देखाइ दैत रहैत अछि, मुदा ओकरा भीतर मे लासक हाड़ आ सभ तरहक सड़ल वस्‍तु भरल रहैत छैक। ");
INSERT INTO mai_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","तहिना अहूँ सभ बाहर सँ लोक सभ केँ धार्मिक बुझाइत छिऐक, मुदा भीतर मे पाखण्‍ड आ अधर्म सँ भरल छी। ");
INSERT INTO mai_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“यौ धर्मशिक्षक आ फरिसी सभ, धिक्‍कार अछि अहाँ सभ केँ! अहाँ सभ पाखण्‍डी छी। अहाँ सभ परमेश्‍वरक प्रवक्‍ता सभक कबर पर चबुतराक निर्माण करैत छी, धर्मी लोकक स्‍मारक केँ सजबैत छी, ");
INSERT INTO mai_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","और कहैत छी जे, ‘हम सभ जँ अपना पुरखा सभक समय मे रहल रहितहुँ तँ हम सभ परमेश्‍वरक प्रवक्‍ता सभक हत्‍या मे ओकरा सभ केँ साथ नहि देने रहितहुँ।’ ");
INSERT INTO mai_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","एहि तरहेँ अहाँ सभ अपने साक्षी दऽ रहल छी जे अहाँ सभ परमेश्‍वरक प्रवक्‍ता सभक हत्‍या कयनिहारक सन्‍तान छी। ");
INSERT INTO mai_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","तँ पूरा करू अपन पुरखाक काज! पापक घैल केँ भरि दिअ! ");
INSERT INTO mai_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“है साँप सभ! है बिषधर साँपक सन्‍तान सभ! अहाँ सभ नरकक दण्‍ड सँ कोना बाँचब? ");
INSERT INTO mai_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","एहि कारणेँ, सुनू अहाँ सभ, हम अहाँ सभ लग अपन प्रवक्‍ता, बुद्धिमान लोकनि आ शिक्षक सभ केँ पठा रहल छी। अहाँ सभ ओहि मे सँ कतेक गोटे केँ जान सँ मारि देबनि, क्रूस पर लटका देबनि, कतेक गोटे केँ अपन सभाघर सभ मे कोड़ा सँ मारबनि आ एक नगर सँ दोसर नगर तक खिहारैत रहबनि। ");
INSERT INTO mai_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","एहि तरहेँ पृथ्‍वी पर धर्मी लोकक जतेक खून बहाओल गेल—धर्मी हाबिलक खून सँ लऽ कऽ बिरिकयाहक पुत्र जकरयाहक खून धरि, जिनका अहाँ सभ मन्‍दिरक ‘पवित्र स्‍थान’ आ बलि-वेदीक बीच हत्‍या कऽ देलियनि, तकर भार अहाँ सभक मूड़ी पर पड़त। ");
INSERT INTO mai_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","हम अहाँ सभ केँ सत्‍य कहैत छी, ई सभ बातक लेखा-जोखा एही पीढ़ीक लोक सभ सँ लेल जायत। ");
INSERT INTO mai_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“हे यरूशलेम! हे यरूशलेम! तोँ परमेश्‍वरक प्रवक्‍ता सभक हत्‍या करैत छह आ जिनका परमेश्‍वर तोरा लग पठबैत छथुन, तिनका सभ केँ तोँ पथरबाहि कऽ कऽ मारि दैत छहुन। हम कतेको बेर चाहलिअह जे जहिना मुर्गी अपना बच्‍चा सभ केँ अपन पाँखिक तर मे नुकबैत अछि, तहिना हमहूँ तोहर सन्‍तान सभ केँ जमा कऽ लिअह। मुदा तोँ ई नहि चाहलह! ");
INSERT INTO mai_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","देखह, आब तोहर घर उजड़ल पड़ल छह। ");
INSERT INTO mai_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","हम तोरा कहैत छिअह, तोँ हमरा फेर ताबत तक नहि देखबह जाबत तक ओ समय नहि आओत जहिया तोँ ई कहबह जे, ‘धन्‍य छथि ओ जे प्रभुक नाम सँ अबैत छथि!’” ");
INSERT INTO mai_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","यीशु जखन मन्‍दिर सँ निकलि कऽ चल जा रहल छलाह तँ हुनकर शिष्‍य सभ हुनका लग आबि कऽ मन्‍दिरक मकान सभ देखाबऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","यीशु हुनका सभ केँ कहलथिन, “ई सभ चीज देखैत छी? हम अहाँ सभ केँ सत्‍य कहैत छी जे एतऽ एकोटा पाथर एक-दोसर पर नहि रहत। सभ ढाहल जायत।” ");
INSERT INTO mai_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","जैतून पहाड़ पर यीशु जखन बैसल छलाह तँ शिष्‍य सभ हुनका लग आबि कऽ एकान्‍त मे हुनका सँ पुछलथिन, “हमरा सभ केँ कहू जे ई घटना कहिया होयत? अहाँ आब फेर आबऽ पर छी आ संसारक अन्‍त होमऽ पर अछि, ताहि समय केँ हम सभ कोन बात सँ चिन्‍हब?” ");
INSERT INTO mai_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","यीशु हुनका सभ केँ उत्तर देलथिन, “होसियार रहू जे अहाँ सभ केँ केओ बहकाबऽ नहि पाबय। ");
INSERT INTO mai_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","बहुतो लोक हमर नाम लऽ कऽ आओत आ कहत जे, ‘हमहीं उद्धारकर्ता-मसीह छी,’ आ बहुतो लोक केँ बहका देत। ");
INSERT INTO mai_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","अहाँ सभ लड़ाइक समाचार आ लड़ाइक हल्‍ला सभ सुनब। मुदा देखू, ताहि सँ घबड़ायब नहि। ई सभ होयब आवश्‍यक अछि, मुदा संसारक अन्‍त तहियो नहि होयत। ");
INSERT INTO mai_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","एक देश दोसर देश सँ लड़ाइ करत, और एक राज्‍य दोसर राज्‍य सँ। बहुतो ठाम मे अकाल पड़त आ भूकम्‍‍प होयत। ");
INSERT INTO mai_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ई सभ बात तँ कष्‍टक शुरुआते होयत। ");
INSERT INTO mai_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ओहि समय मे लोक सभ अहाँ सभ पर अत्‍याचार करयबाक लेल अहाँ सभ केँ अधिकारी सभक जिम्‍मा मे लगा देत आ मरबा देत। अहाँ सभ सँ सभ देशक लोक सभ एहि लेल घृणा करत जे अहाँ सभ हमर लोक छी। ");
INSERT INTO mai_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ओहि समय मे बहुतो लोक अपन विश्‍वास छोड़ि देत। ओ सभ एक-दोसर केँ पकड़बाओत आ एक-दोसर सँ घृणा करत। ");
INSERT INTO mai_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","एहन बहुतो लोक सभ प्रगट भऽ जायत जे झूठ बाजि कऽ अपना केँ परमेश्‍वरक प्रवक्‍ता कहत आ बहुतो लोक केँ बहका देत। ");
INSERT INTO mai_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","अधर्मक वृद्धि भेला सँ अनेक लोकक आपसी प्रेम मन्‍द पड़ि जायत। ");
INSERT INTO mai_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","मुदा जे केओ अन्‍त धरि स्‍थिर रहत से उद्धार पाओत। ");
INSERT INTO mai_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","परमेश्‍वरक राज्‍यक ई शुभ समाचारक प्रचार सम्‍पूर्ण संसार मे कयल जायत जाहि सँ एकरा सम्‍बन्‍ध मे सभ जातिक लोक गवाही सुनय; तखन अन्‍तक समय आबि जायत। ");
INSERT INTO mai_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“तेँ जखन अहाँ सभ ‘विनाश करऽ वला घृणित वस्‍तु’ केँ पवित्र स्‍थान मे ठाढ़ देखब, जकरा विषय मे परमेश्‍वरक प्रवक्‍ता दानिएल कहने छथि—पढ़ऽ वला ई बात ध्‍यान दऽ कऽ बुझू!— ");
INSERT INTO mai_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","तखन जे सभ यहूदिया प्रदेश मे होअय से सभ पहाड़ पर भागि जाय। ");
INSERT INTO mai_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","जे घरक छत पर होअय से उतरि कऽ घर मे सँ कोनो वस्‍तु लेबऽ नहि लागओ। ");
INSERT INTO mai_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","आ जे खेत मे होअय से घर मे सँ अपन ओढ़ना लेबाक लेल घूमि कऽ नहि आबओ। ");
INSERT INTO mai_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ओहि समय मे जे स्‍त्रीगण सभ गर्भवती होयत वा जकरा दूधपीबा बच्‍चा होयतैक, तकरा सभ केँ कतेक कष्‍ट होयतैक! ");
INSERT INTO mai_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","प्रार्थना करू जे जाड़क समय वा विश्राम-दिन कऽ अहाँ सभ केँ भागऽ-पड़ाय नहि पड़य। ");
INSERT INTO mai_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ओहि समय मे एहन कष्‍ट होयत जे सृष्‍टिक आरम्‍भ सँ आइ तक कहियो नहि भेल अछि आ ने फेर कहियो होयत। ");
INSERT INTO mai_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","जँ ओहि समय केँ घटा नहि देल जाइत तँ कोनो मनुष्‍य नहि बचैत, मुदा परमेश्‍वर अपन चुनल लोक सभक कारणेँ ओहि समय केँ घटा देताह। ");
INSERT INTO mai_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ओहि समय मे जँ केओ अहाँ सभ केँ कहत जे, ‘देखू, मसीह एतऽ छथि!’ वा ‘ओतऽ छथि!’ तँ ओहि बात पर विश्‍वास नहि करू। ");
INSERT INTO mai_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","कारण, ओहि समय मे झुट्ठा मसीह आ झूठ बाजि कऽ अपना केँ परमेश्‍वरक प्रवक्‍ता कहऽ वला सभ प्रगट होयत, और एहन अजगूत बात आ चमत्‍कार सभ देखाओत जे, जँ सम्‍भव रहैत, तँ परमेश्‍वरक चुनल लोक सभ केँ सेहो बहका दैत। ");
INSERT INTO mai_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","देखू, हम अहाँ सभ केँ पहिनहि कहि देलहुँ। ");
INSERT INTO mai_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“तेँ जँ केओ अहाँ सभ केँ कहत जे, ‘चलू, देखू, ओ निर्जन स्‍थान मे छथि,’ तँ ओकरा संग बाहर नहि जाउ। अथवा जँ कहत जे, ‘देखू, ओ एतऽ कोठरी मे छथि,’ तँ विश्‍वास नहि करू। ");
INSERT INTO mai_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","किएक तँ जहिना बिजलोकाक चमक पूब सँ निकलि कऽ पश्‍चिम तक देखाइ दैत अछि, तहिना जखन मनुष्‍य-पुत्र फेर औताह तँ एहने होयत। ");
INSERT INTO mai_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","जतऽ कतौ लास रहैत अछि ततऽ गिद्ध सभ जुटैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ओहि समयक कष्‍टक ठीक बाद, ‘सूर्य अन्‍हार भऽ जायत, चन्‍द्रमा इजोत नहि देत, आकाश सँ तारा सभ खसत, और आकाशक शक्‍ति सभ हिलि जायत।’ ");
INSERT INTO mai_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","तकरबाद मनुष्‍य-पुत्रक अयबाक चिन्‍ह आकाश मे देखाइ देत। पृथ्‍वी परक सभ जातिक लोक सभ कन्‍ना-रोहटि करत और मनुष्‍य-पुत्र केँ सामर्थ्‍य आ अपार महिमाक संग आकाशक मेघ मे अबैत देखत। ");
INSERT INTO mai_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","धुतहूक पैघ आवाजक संग ओ अपन स्‍वर्गदूत सभ केँ चारू दिस पठौताह आ ओ सभ आकाश आ पृथ्‍वीक अन्‍तिम सीमा तक जा कऽ हुनकर चुनल लोक सभ केँ जमा करताह। ");
INSERT INTO mai_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“आब अंजीरक गाछ सँ एकटा बात सिखू। जखन ओकर ठाढ़ि कोमल होमऽ लगैत छैक आ ओहि मे नव पात निकलऽ लगैत छैक तँ अहाँ सभ बुझि जाइत छी जे गर्मीक समय आबि रहल अछि। ");
INSERT INTO mai_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","तहिना जखन अहाँ सभ ई सभ बात होइत देखब तँ बुझि लिअ जे समय लगचिआ गेल, हँ, ई बुझू जे ओ घरक मुँह पर आबि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","हम अहाँ सभ केँ सत्‍य कहैत छी जे एहि पीढ़ी केँ समाप्‍त होमऽ सँ पहिने ई सभ घटना निश्‍चित घटत। ");
INSERT INTO mai_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","आकाश और पृथ्‍वी समाप्‍त भऽ जायत, मुदा हमर वचन अनन्‍त काल तक रहत। ");
INSERT INTO mai_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“मुदा एहि घटना सभक दिन वा समय केओ नहि जनैत अछि, स्‍वर्गदूतो सभ नहि आ पुत्रो नहि—मात्र पिता जनैत छथि। ");
INSERT INTO mai_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","जहिना नूहक समय मे भेल तहिना ओहि समय मे होयत जहिया मनुष्‍य-पुत्र फेर औताह। ");
INSERT INTO mai_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","जल-प्रलय होमऽ सँ पहिने लोक सभ खाय-पिबऽ मे आ विवाह करऽ-कराबऽ मे लागल छल। नूह जाहि दिन जहाज मे चढ़ि गेलाह ताहि दिन तक लोक सभ एहि सभ काज मे मस्‍त रहल। ");
INSERT INTO mai_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ओकरा सभ केँ किछु बुझऽ मे नहि अयलैक जे कोन बात सभ होमऽ वला अछि, ताबत जल-प्रलयक बाढ़ि आबि कऽ ओकरा सभ केँ बहा कऽ लऽ गेलैक। मनुष्‍य-पुत्र जहिया फेर औताह, तहिया ओहिना होयत। ");
INSERT INTO mai_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ओहि समय मे दू गोटे खेत मे रहत; ओहि मे सँ एकटा लऽ लेल जायत आ दोसर ओतहि छोड़ि देल जायत। ");
INSERT INTO mai_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","दूटा स्‍त्रीगण जाँत पिसैत रहत, एकटा लऽ लेल जायत आ दोसर छोड़ि देल जायत। ");
INSERT INTO mai_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“तेँ अहाँ सभ चौकस रहू, कारण अहाँ सभ नहि जनैत छी जे अहाँ सभक प्रभु कोन दिन आबि जयताह। ");
INSERT INTO mai_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","मुदा ई बात ठीक सँ बुझि लिअ जे, जँ घरक मालिक केँ बुझल रहितैक जे चोर रातिक कोन पहर मे आओत तँ ओ जागल रहैत आ अपना घर मे सेन्‍ह नहि काटऽ दैत। ");
INSERT INTO mai_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","तेँ अहूँ सभ सदिखन तैयार रहू, कारण मनुष्‍य-पुत्र एहने समय मे आबि जयताह जाहि समयक लेल अहाँ सभ सोचबो नहि करब जे ओ एखन औताह। ");
INSERT INTO mai_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“के अछि ओहन विश्‍वासपात्र आ बुद्धिमान सेवक जकरा मालिक अपन घरक आरो सेवक सभक मुखिया बनौथिन जे ओ ठीक सँ ओकरा सभक देख-रेख करैक आ समय पर भोजन-भातक व्‍यवस्‍था करैक? ");
INSERT INTO mai_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ओहि सेवकक लेल कतेक नीक होयत, जकरा मालिक आबि कऽ ओहिना करैत पौताह। ");
INSERT INTO mai_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","हम अहाँ सभ केँ सत्‍य कहैत छी जे, मालिक अपन सम्‍पूर्ण सम्‍पत्तिक जबाबदेही ओकरा जिम्‍मा मे दऽ देथिन। ");
INSERT INTO mai_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","मुदा ओ सेवक जँ दुष्‍ट अछि आ एना सोचय जे, ‘हमर मालिक आबऽ मे बहुत देरी कऽ रहल अछि,’ ");
INSERT INTO mai_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","आ ई सोचि ओ मालिकक आरो सेवक सभ केँ मारय-पिटय आ स्‍वयं पिअक्‍कड़ सभक संग खाय-पिबऽ लागय, ");
INSERT INTO mai_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","तँ ओहि सेवकक मालिक एहन दिन मे घूमि औताह जहिया ओ अपन मालिकक बाट नहि तकैत रहत आ एहन समय मे औताह जकरा ओ नहि जानत। ");
INSERT INTO mai_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","मालिक आबि कऽ ओकरा खण्‍ड-खण्‍ड कटबा देथिन आ ओकरा ताहि ठाम राखि देथिन जतऽ पाखण्‍डी लोक अपन दण्‍ड भोगैत अछि। ओतऽ लोक कनैत आ दाँत कटकटबैत रहैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ओहि समय मे स्‍वर्गक राज्‍य ओहि दस कुमारि कन्‍याक घटना वला बात जकाँ होयत जे सभ अपन-अपन दीप लऽ कऽ वरक स्‍वागत करबाक लेल निकलल। ");
INSERT INTO mai_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ओहि मे पाँचटा मूर्ख आ पाँचटा बुद्धिआरि छलि। ");
INSERT INTO mai_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","मूर्ख कन्‍या सभ दीप तँ लेलक मुदा फाजिल तेल अपना संग नहि रखलक। ");
INSERT INTO mai_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","मुदा बुद्धिआरि कन्‍या सभ अपन दीप आ अलग बर्तन मे तेल सेहो लऽ गेलि। ");
INSERT INTO mai_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","वर केँ आबऽ मे जखन देरी भेलनि तँ सभ औँघाय लागलि आ सुति रहलि। ");
INSERT INTO mai_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“आधा राति बितला पर हो-हल्‍ला होमऽ लागल जे, ‘चलू, चलू, वर आबि गेलाह! हुनका सँ भेँट करऽ चलू!’ ");
INSERT INTO mai_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ई सुनि सभ कुमारि कन्‍या उठलि आ अपन-अपन दीप सभ ठीक करऽ लागलि। ");
INSERT INTO mai_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","मूर्ख कन्‍या सभ बुद्धिआरि कन्‍या सभ केँ कहलकैक, ‘देखह, हमर सभक दीप मिझाय लागल। तोँ सभ अपना मे सँ कनेक तेल हमरा सभ केँ दैह।’ ");
INSERT INTO mai_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","मुदा ओ बुद्धिआरि कन्‍या सभ उत्तर देलकैक जे, ‘नहि, कहीं ई तेल अपना सभ गोटेक लेल पूरा नहि ने होअय। तेँ नीक ई जे तोँ सभ तेल बेचऽ वला सँ किनि कऽ लऽ आनह।’ ");
INSERT INTO mai_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“ओ सभ जखन तेल किनबाक लेल गेलि तखने वर आबि गेलाह। जे सभ तैयार छलि, से सभ वरक संग विवाह-भोज मे भीतर गेलि आ केबाड़ बन्‍द कयल गेल। ");
INSERT INTO mai_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","बाद मे ओ तेल किनऽ वाली मूर्ख कन्‍या सभ आयल आ कहऽ लागलि, ‘यौ प्रभु, यौ प्रभु! हमरा सभक लेल केबाड़ खोलि दिअ!’ ");
INSERT INTO mai_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","मुदा वर उत्तर देलथिन, ‘हम अहाँ सभ केँ सत्‍य कहैत छी, हम अहाँ सभ केँ नहि चिन्‍हैत छी।’ ” ");
INSERT INTO mai_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","तखन यीशु कहलनि, “तेँ अहाँ सभ होसियार रहू, कारण अहाँ सभ ओहि दिन आ ओहि समय केँ नहि जनैत छी। ");
INSERT INTO mai_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“स्‍वर्गक राज्‍य परदेश जाय लागल एक गोटेक यात्रा वला बात जकाँ अछि। परदेश जाय सँ पहिने ओ अपन सेवक सभ केँ बजौलनि आ अपन सम्‍पत्तिक देख-रेख करबाक भार ओकरा सभक जिम्‍मा देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ओ अपन सेवक सभक गुणक अनुसार एकटा केँ पाँच हजार, दोसर केँ दू हजार आ तेसर केँ एक हजार सोनक रुपैया जिम्‍मा दऽ परदेश चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","जकरा पाँच हजार भेटल छलैक, से ओकरा तुरत व्‍यापार मे लगौलक आ ओहि सँ पाँच हजार आओर कमायल। ");
INSERT INTO mai_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","एहि तरहेँ जकरा दू हजार भेटल छलैक से दू हजार आओर कमायल। ");
INSERT INTO mai_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","मुदा जकरा एक हजार भेटल छलैक से खधिया खुनि कऽ अपन मालिकक रुपैया ओहि मे नुका कऽ धयलक। ");
INSERT INTO mai_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“बहुत समय बितला पर मालिक परदेश सँ घूमि अयलाह आ अपन सेवक सभ सँ हिसाब-किताब लेबऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","जकरा पाँच हजार भेटल छलैक से दस हजार रुपैया आनि कऽ अपना मालिक केँ कहलकनि, ‘मालिक, अपने हमरा पाँच हजार देने छलहुँ, देखल जाओ, हम एहि सँ पाँच हजार आरो कमयलहुँ।’ ");
INSERT INTO mai_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","मालिक ओहि सेवक केँ कहलथिन, ‘चाबस! तोँ नीक आ भरोसमन्‍द सेवक छह! थोड़बो वस्‍तु मे तोँ विश्‍वसनीय रहलह। हम आब तोरा बहुत वस्‍तु पर अधिकार देबह। अपन मालिकक आनन्‍द मे सहभागी बनह!’ ");
INSERT INTO mai_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“जकरा दू हजार भेटल छलैक सेहो आबि कऽ कहलकनि, ‘मालिक, अपने हमरा दू हजार देने छलहुँ, देखल जाओ, हम एहि सँ दू हजार आरो कमयलहुँ।’ ");
INSERT INTO mai_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","मालिक ओहू सेवक केँ कहलथिन, ‘चाबस! तोँ नीक आ भरोसमन्‍द सेवक छह! थोड़बो वस्‍तु मे तोँ विश्‍वसनीय रहलह। हम आब तोरा बहुत वस्‍तु पर अधिकार देबह। अपन मालिकक आनन्‍द मे सहभागी होअह!’ ");
INSERT INTO mai_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“तकरबाद जकरा एक हजार भेटल छलैक से आयल आ कहलक, ‘मालिक, हम अपने केँ जनैत छी जे अपने कठोर आदमी छी। जाहि खेत मे रोपने नहि छी, ताहि मे कटनी करबैत छी। जतऽ अपनेक वस्‍तु छिटायल नहि रहैत अछि, ततऽ समटबैत छी। ");
INSERT INTO mai_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","तेँ हमरा डर भेल आ अपनेक देल एक हजार रुपैया हम जमीन मे गाड़ि कऽ रखने छलहुँ। लेल जाओ अपन ओ रुपैया।’ ");
INSERT INTO mai_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","मालिक ओहि सेवक केँ कहलथिन, ‘है दुष्‍ट आ आलसी सेवक! जखन तोँ जनैत छलेँ जे हम जाहि मे रोपने नहि छी ताहि मे कटनी करैत छी आ जतऽ हमर छिटायल नहि अछि ततऽ हम समटैत छी, ");
INSERT INTO mai_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","तँ तोँ हमर पाइ कोनो महाजनक जिम्‍मा लगा दिते, जाहि सँ हम आबि कऽ अपन पाइ कम सँ कम व्‍याजक संग पबितहुँ। ");
INSERT INTO mai_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","हौ, एकरा सँ इहो पाइ लऽ लैह आ जकरा लग दस हजार छैक तकरा दऽ दहक। ");
INSERT INTO mai_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","किएक तँ जकरा लग छैक तकरा आरो देल जयतैक, जाहि सँ ओकरा बहुते भऽ जायत। मुदा जकरा लग नहि छैक, तकरा सँ जेहो छैक सेहो लऽ लेल जयतैक। ");
INSERT INTO mai_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","और एहि निकम्‍मा सेवक केँ बाहर अन्‍हार मे फेकि दैह जतऽ लोक कनैत आ दाँत कटकटबैत रहैत अछि।’ ");
INSERT INTO mai_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“मनुष्‍य-पुत्र अपन सभ स्‍वर्गदूतक संग जहिया अपना महिमा मे औताह, तहिया ओ अपन महिमामय सिंहासन पर बैसताह। ");
INSERT INTO mai_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","पृथ्‍वी परक सभ जातिक लोक हुनका समक्ष जमा कयल जायत, आ जहिना चरबाह भेँड़ा सभ केँ बकरी सभ सँ छुटिअबैत अछि, तहिना ओ लोक सभ केँ एक-दोसर सँ अलग करताह। ");
INSERT INTO mai_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ओ ‘भेँड़ा’ सभ केँ अपन दहिना कात आ ‘बकरी’ सभ केँ अपन बामा कात ठाढ़ करताह। ");
INSERT INTO mai_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“तकरबाद राजा अपन दहिना कात ठाढ़ भेल लोक सभ केँ कहथिन, ‘हे हमर पिताक कृपापात्र सभ! आउ, ओहि राज्‍यक अधिकारी बनू, जकरा सृष्‍टिक आरम्‍भ सँ अहाँ सभक लेल तैयार कयल गेल अछि। ");
INSERT INTO mai_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","कारण, हम भूखल छलहुँ आ अहाँ सभ हमरा भोजन करौलहुँ। हम पियासल छलहुँ आ अहाँ सभ हमरा पानि पिऔलहुँ। हम परदेशी छलहुँ आ अहाँ सभ अपना घर मे हमर सेवा-सत्‍कार कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","हम नाङट छलहुँ आ अहाँ सभ हमरा वस्‍त्र पहिरौलहुँ। हम बिमार छलहुँ आ अहाँ सभ हमर रेख-देख कयलहुँ। हम जहल मे छलहुँ आ अहाँ सभ हमरा सँ भेँट करबाक लेल अयलहुँ।’ ");
INSERT INTO mai_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“ताहि पर ओ धर्मी लोक सभ हुनका कहथिन, ‘यौ प्रभु, हम सभ अहाँ केँ कहिया भूखल देखलहुँ आ भोजन करौलहुँ, पियासल देखलहुँ आ पानि पिऔलहुँ? ");
INSERT INTO mai_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","हम सभ अहाँ केँ कहिया परदेशी देखलहुँ आ अपना घर मे सेवा-सत्‍कार कयलहुँ, नाङट देखलहुँ आ वस्‍त्र पहिरौलहुँ? ");
INSERT INTO mai_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","कहिया हम सभ अहाँ केँ बिमार वा जहल मे देखलहुँ आ अहाँ सँ भेँट करबाक लेल गेलहुँ?’ ");
INSERT INTO mai_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","एहि पर राजा हुनका सभ केँ उत्तर देथिन, ‘हम अहाँ सभ केँ सत्‍य कहैत छी जे, जे किछु अहाँ सभ हमर एहि भाय सभ मे सँ ककरो लेल, छोटो सँ छोटक लेल कयलहुँ, से हमरा लेल कयलहुँ।’ ");
INSERT INTO mai_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“तकरबाद राजा अपन बामा कात ठाढ़ लोक सभ केँ कहथिन, ‘हे सरापित लोक सभ! तोँ सभ हमरा लग सँ दूर हटि जाह और कहियो नहि मिझाय वला ओहि आगिक कुण्‍ड मे पड़ल रहह, जे शैतान आ ओकर दूत सभक लेल तैयार कयल गेल अछि। ");
INSERT INTO mai_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","कारण, हम भूखल छलहुँ आ तोँ सभ हमरा खयबाक लेल किछु नहि देलह, पियासल छलहुँ आ तोँ सभ पानि नहि पिऔलह। ");
INSERT INTO mai_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","हम परदेशी छलहुँ आ तोँ सभ अपना ओतऽ हमर स्‍वागत नहि कयलह, नाङट छलहुँ आ वस्‍त्र नहि पहिरौलह। हम बिमार छलहुँ, जहल मे छलहुँ, मुदा तोँ सभ हमरा देखबाक लेल नहि अयलह।’ ");
INSERT INTO mai_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“एहि पर ओहो सभ पुछतनि जे, ‘यौ प्रभु, हम सभ अहाँ केँ कहिया भूखल, पियासल, परदेशी, नाङट, बिमार वा जहल मे बन्‍द देखलहुँ आ अहाँक सेवा नहि कयलहुँ?’ ");
INSERT INTO mai_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ताहि पर राजा ओकरा सभ केँ उत्तर देथिन, ‘हम तोरा सभ केँ सत्‍य कहैत छिअह जे, जे किछु तोँ सभ हमर एहि भाय सभ मे सँ ककरो लेल, छोटो सँ छोटक लेल नहि कयलह से हमरो लेल नहि कयलह।’ ” ");
INSERT INTO mai_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","तखन यीशु कहलनि, “ई सभ अनन्‍त दण्‍ड भोगबाक लेल चल जायत, मुदा धर्मी सभ अनन्‍त जीवन मे प्रवेश करत।” ");
INSERT INTO mai_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ई सभ बात जखन कहल भऽ गेलनि तँ यीशु अपना शिष्‍य सभ केँ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“अहाँ सभ जनैत छी जे दू दिनक बाद फसह-पाबनि अछि। ओहि समय मे मनुष्‍य-पुत्र क्रूस पर लटका कऽ मारबाक लेल पकड़बाओल जायत।” ");
INSERT INTO mai_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ओम्‍हर काइफा नामक महापुरोहित जे छलाह तिनका आङन मे मुख्‍यपुरोहित आ समाजक बूढ़-प्रतिष्‍ठित सभ जमा भऽ कऽ ");
INSERT INTO mai_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","अपना मे विचार-विमर्श करऽ लगलाह जे कोन तरहेँ छल सँ यीशु केँ पकड़ि कऽ मारल जाय। ");
INSERT INTO mai_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ओ सभ कहैत छलाह जे, “मुदा पाबनिक समय मे नहि। एना नहि होअय जे जनता उपद्रव करय।” ");
INSERT INTO mai_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","यीशु जखन बेतनिया गाम मे सिमोन नामक एक आदमी, जिनका पहिने कुष्‍ठ-रोग भेल छलनि, तिनका ओहिठाम छलाह, ");
INSERT INTO mai_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","तँ एक स्‍त्री बेसकिमती सुगन्‍धित तेल एकटा संगमरमरक बर्तन मे लऽ कऽ अयलीह। यीशु भोजन करैत छलाह तखने ओ स्‍त्री ओहि सुगन्‍धित तेल केँ यीशुक माथ पर ढारि देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ई देखि हुनकर शिष्‍य सभ खिसिआइत बजलाह, “एहन नीक वस्‍तु किएक एना बरबाद कयल गेल? ");
INSERT INTO mai_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","एहि तेल केँ बढ़ियाँ दाम मे बेचि कऽ बहुतो गरीबक सहायता कयल जा सकैत छल।” ");
INSERT INTO mai_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","शिष्‍य सभक बात बुझि यीशु हुनका सभ केँ कहलथिन, “एहि स्‍त्री केँ अहाँ सभ किएक डाँटि रहल छी? ई तँ हमरा लेल बहुत बढ़ियाँ काज कयलनि। ");
INSERT INTO mai_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","गरीब सभ तँ अहाँ सभक संग सभ दिन रहत, मुदा हम अहाँ सभक संग सभ दिन नहि रहब। ");
INSERT INTO mai_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ई सुगन्‍धित तेल हमरा मूड़ी पर ढारि कऽ ई स्‍त्रीगण हम जे कबर मे राखल जायब, तकर तैयारी कयलनि। ");
INSERT INTO mai_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","हम अहाँ सभ केँ सत्‍य कहैत छी जे, संसार भरि मे जतऽ कतौ हमर शुभ समाचारक प्रचार कयल जायत, ततऽ एहि स्‍त्रीगणक स्‍मरण मे हिनकर एहि काजक चर्चा सेहो कयल जायत।” ");
INSERT INTO mai_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","तकरबाद यीशुक बारह शिष्‍य मे सँ एक जकर नाम यहूदा इस्‍करियोती छलैक से मुख्‍यपुरोहित सभ लग जा कऽ कहलकनि, ");
INSERT INTO mai_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“हम जँ यीशु केँ अहाँ सभक हाथ मे पकड़बा देब तँ अहाँ सभ हमरा की देब?” एहि पर ओ सभ तीसटा चानीक सिक्‍का ओकरा देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ओहि समय सँ यहूदा यीशु केँ पकड़बयबाक अनुकूल अवसरक ताक मे रहऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","“बिनु खमीरक रोटी वला पाबनि”क पहिल दिन यीशुक शिष्‍य सभ हुनका लग आबि पुछलथिन, “फसह-पाबनिक भोजक व्‍यवस्‍था अहाँक लेल हम सभ कतऽ ठीक करू?” ");
INSERT INTO mai_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","यीशु कहलथिन, “शहर मे फलानाक ओतऽ जाउ आ कहू, ‘गुरुजी कहलनि अछि जे हमर समय आब लगचिआ गेल अछि। हम अपन शिष्‍य सभक संग अहाँक ओतऽ फसह-भोज खायब।’ ” ");
INSERT INTO mai_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","शिष्‍य सभ यीशुक कथनानुसार सभ बात कऽ कऽ फसह-पाबनिक भोजक व्‍यवस्‍था ओतहि कयलनि। ");
INSERT INTO mai_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","साँझ पड़ला पर यीशु अपन बारहो शिष्‍यक संग भोजन करबाक लेल बैसलाह। ");
INSERT INTO mai_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","भोजन करैत समय यीशु अपना शिष्‍य सभ केँ कहलथिन, “हम अहाँ सभ केँ सत्‍य कहैत छी, अहाँ सभ मे सँ एक गोटे हमरा पकड़बा देब।” ");
INSERT INTO mai_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ई सुनि शिष्‍य सभ बहुत उदास भऽ गेलाह। ओ सभ बेरा-बारी हुनका सँ पुछऽ लगलनि जे, “हे प्रभु, ओ हम तँ नहि छी?” ");
INSERT INTO mai_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","यीशु उत्तर देलथिन, “हमरा संग जे बट्टा मे हाथ रखने अछि सैह हमरा पकड़बाओत। ");
INSERT INTO mai_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","मनुष्‍य-पुत्रक सम्‍बन्‍ध मे जहिना धर्मशास्‍त्र मे लिखल गेल अछि तहिना तँ ओ चलिए जायत, मुदा धिक्‍कार अछि ओहि मनुष्‍य केँ जे मनुष्‍य-पुत्र केँ पकड़बा रहल अछि। ओकरा लेल तँ नीक ई रहितैक जे ओ जन्‍मे नहि लेने रहैत।” ");
INSERT INTO mai_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","एहि पर हुनका पकड़बाबऽ वला यहूदा कहलकनि, “गुरुजी, की अहाँ हमरा बारे मे तँ नहि कहि रहल छी?” यीशु उत्तर देलथिन, “अहाँ स्‍वयं कहि देलहुँ।” ");
INSERT INTO mai_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ओ सभ जखन भोजन कऽ रहल छलाह तँ यीशु रोटी लेलनि आ परमेश्‍वर केँ धन्‍यवाद देलनि। ओ रोटी केँ तोड़ि कऽ शिष्‍य सभ केँ देलथिन आ कहलथिन, “लिअ, खाउ, ई हमर देह अछि।” ");
INSERT INTO mai_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","तकरबाद ओ बाटी लेलनि आ परमेश्‍वर केँ धन्‍यवाद दऽ कऽ शिष्‍य सभ केँ दैत कहलथिन, “अहाँ सभ केओ एहि मे सँ पिबू। ");
INSERT INTO mai_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ई परमेश्‍वर आ मनुष्‍यक बीच विशेष सम्‍बन्‍ध स्‍थापित करऽ वला हमर खून अछि, जे बहुत लोकक पापक क्षमादानक लेल बहाओल जा रहल अछि। ");
INSERT INTO mai_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","हम अहाँ सभ केँ कहैत छी जे, ई अंगूरक रस हम आजुक बाद ताबत तक फेर नहि पीब जाबत तक हम अपन पिताक राज्‍य मे अहाँ सभक संग नवका अंगूरक रस नहि पीब।” ");
INSERT INTO mai_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","तकरबाद एक भजन गाबि कऽ ओ सभ जैतून पहाड़ पर चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","तखन यीशु अपना शिष्‍य सभ केँ कहलथिन, “आइए राति अहाँ सभ गोटे हमरा कारणेँ अपना विश्‍वास मे डगमगायब, किएक तँ धर्मशास्‍त्र मे लिखल अछि जे परमेश्‍वर कहने छथि, ‘हम चरबाह केँ मारि देबैक, आ झुण्‍डक भेँड़ा सभ छिड़िया जायत।’ ");
INSERT INTO mai_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","मुदा मृत्‍यु सँ फेर जीवित भऽ गेलाक बाद हम अहाँ सभ सँ पहिने गलील प्रदेश जायब।” ");
INSERT INTO mai_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","एहि पर पत्रुस कहलथिन, “चाहे सभ केओ अहाँक कारणेँ विश्‍वास मे डगमगायत, मुदा हम कहियो नहि डगमगायब!” ");
INSERT INTO mai_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","यीशु पत्रुस केँ कहलथिन, “हम अहाँ केँ सत्‍य कहैत छी जे, आइए राति मे मुर्गा केँ बाजऽ सँ पहिने अहाँ तीन बेर हमरा अस्‍वीकार कऽ कऽ लोक केँ कहबैक जे, हम ओकरा चिन्‍हबो नहि करैत छिऐक।” ");
INSERT INTO mai_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","मुदा पत्रुस कहलथिन, “हमरा जँ अहाँक संग मरहो पड़त तैयो हम किन्‍नहुँ नहि अहाँ केँ अस्‍वीकार करब।” आरो सभ शिष्‍य सेहो यैह बात कहलथिन। ");
INSERT INTO mai_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ओहिठाम सँ यीशु अपन शिष्‍य सभक संग गतसमनी नामक एक जगह पर गेलाह। ओ हुनका सभ केँ कहलथिन, “हम किछु आगाँ जा कऽ जाबत प्रार्थना करैत छी ताबत अहाँ सभ एतऽ बैसल रहू।” ");
INSERT INTO mai_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ओ पत्रुस आ जबदीक दूनू पुत्र केँ अपना संग लऽ गेलाह। ओ बहुत व्‍यथित आ व्‍याकुल होमऽ लगलाह, ");
INSERT INTO mai_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","और हुनका सभ केँ कहलथिन, “हमर मोन व्‍यथा सँ एतेक व्‍याकुल अछि—मानू जे हम दुःख सँ मरऽ पर छी। अहाँ सभ एहिठाम रहि कऽ हमरा संग जागल रहू।” ");
INSERT INTO mai_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","एतेक कहि ओ कनेक आगाँ बढ़लाह आ मुँह भरे खसि कऽ प्रार्थना करऽ लगलाह, “हे हमर पिता, जँ भऽ सकैत अछि तँ ई दुःखक बाटी हमरा लग सँ हटा लिअ, मुदा तैयो जेना हम चाहैत छी तेना नहि, बल्‍कि जेना अहाँ चाहैत छी तेना होअय।” ");
INSERT INTO mai_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","तकरबाद यीशु अपन तीनू शिष्‍य लग अयलाह। ओ हुनका सभ केँ सुतल देखि पत्रुस केँ पुछलथिन, “की हमरा संग एको घण्‍टा जागल रहितहुँ से अहाँ सभ केँ पार नहि लागल? ");
INSERT INTO mai_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","परीक्षा मे नहि पड़ि जाउ ताहि लेल अहाँ सभ जागल रहू आ प्रार्थना करैत रहू। आत्‍मा तँ तत्‍पर अछि मुदा शरीर कमजोर।” ");
INSERT INTO mai_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","यीशु फेर जा कऽ प्रार्थना करऽ लगलाह, “हे पिता, जँ ई बाटी बिनु पिने हमरा लग सँ नहि हटाओल जा सकैत अछि, तँ अहाँक जे इच्‍छा अछि से पूरा होअय।” ");
INSERT INTO mai_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ओ जखन प्रार्थना कऽ कऽ शिष्‍य सभ लग अयलाह तँ ओ सभ फेर सुतल छलाह। हुनकर सभक आँखि नीन सँ भारी भऽ गेल छलनि। ");
INSERT INTO mai_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","यीशु हुनका सभ केँ सुतले छोड़ि कऽ फेर गेलाह आ तेसरो बेर ओही तरहेँ प्रार्थना कयलनि। ");
INSERT INTO mai_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","तकरबाद ओ शिष्‍य सभ लग अयलाह आ कहलथिन, “की अहाँ सभ एखनो तक सुतिए रहल छी आ आरामे कऽ रहल छी? देखू, ओ समय आब आबि गेल, मनुष्‍य-पुत्र पापी सभक हाथ मे पकड़बाओल जा रहल अछि। ");
INSERT INTO mai_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","उठू-उठू! चलू! देखू, हमरा पकड़बाबऽ वला आबि गेल अछि!” ");
INSERT INTO mai_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","यीशु ई बात कहिए रहल छलाह कि यहूदा, जे बारह शिष्‍य मे सँ एक छल, ओतऽ पहुँचि गेल। ओकरा संग लोकक बड़का भीड़ छलैक, और सभक हाथ मे तरुआरि आ लाठी छल। ओकरा सभ केँ मुख्‍यपुरोहित सभ आ समाजक बूढ़-प्रतिष्‍ठित लोकनि पठौने छलाह। ");
INSERT INTO mai_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","यीशु केँ पकड़बाबऽ वला ओकरा सभ केँ ई संकेत देने छलैक जे, “हम जकरा चुम्‍मा लेब, वैह होयत। अहाँ सभ ओकरे पकड़ि लेब।” ");
INSERT INTO mai_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","यहूदा तुरत यीशुक लग मे जा कऽ कहलकनि, “गुरुजी, प्रणाम!” आ हुनका चुम्‍मा लेलकनि। ");
INSERT INTO mai_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","यीशु कहलथिन, “हौ मित्र, तोँ जाहि काजक लेल आयल छह, से कऽ लैह।” तखन लोक सभ आगाँ बढ़ि कऽ यीशु केँ पकड़ि लेलकनि आ बन्‍दी बना लेलकनि। ");
INSERT INTO mai_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ई देखि यीशुक एक शिष्‍य अपन तरुआरि निकालि कऽ महापुरोहितक टहलू पर चला देलनि जाहि सँ ओकर एकटा कान छपटा गेलैक। ");
INSERT INTO mai_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","यीशु अपना शिष्‍य केँ कहलथिन, “अपन तरुआरि म्‍यान मे राखि लिअ। जे केओ तरुआरि चलबैत अछि से तरुआरि सँ मारल जायत। ");
INSERT INTO mai_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","की अहाँ ई सोचैत छी, जे हम अपन पिता सँ एहि बातक लेल निवेदन नहि कऽ सकैत छी जे ओ एही क्षण हमरा सहायताक लेल स्‍वर्गदूतक बारह सेना सँ बेसिओ पठबथि? ");
INSERT INTO mai_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","मुदा तखन धर्मशास्‍त्रक जे लेख अछि, जे ई सभ भेनाइ जरूरी अछि, से कोना पूरा होइत?” ");
INSERT INTO mai_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","तकरबाद यीशु अपना चारू भागक भीड़क लोक केँ कहलथिन, “की अहाँ सभ हमरा विद्रोह मचाबऽ वला बुझि कऽ लाठी और तरुआरि लऽ कऽ पकड़ऽ अयलहुँ? हम तँ सभ दिन मन्‍दिर मे बैसि कऽ लोक केँ उपदेश दैत छलिऐक, ततऽ अहाँ सभ हमरा नहि पकड़लहुँ। ");
INSERT INTO mai_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","मुदा ई सभ एना एहि लेल भेल जे परमेश्‍वरक प्रवक्‍ता लोकनिक लिखल बात सभ पूरा होअय।” तकरबाद हुनकर सभ शिष्‍य हुनका छोड़ि कऽ पड़ा गेलनि। ");
INSERT INTO mai_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","यीशु केँ पकड़ऽ वला सभ हुनका महापुरोहित काइफाक ओतऽ लऽ गेलनि। ओहिठाम धर्मशिक्षक आ समाजक बूढ़-प्रतिष्‍ठित लोक सभ जमा भेल छलाह। ");
INSERT INTO mai_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","पत्रुस सेहो कनेक दूरे रहि कऽ यीशुक पाछाँ लागल महापुरोहितक आङन तक गेलाह। ओ एहि घटनाक अन्‍त देखबाक उद्देश्‍य सँ नोकर सभक संग भीतर जा कऽ बैसि रहलाह। ");
INSERT INTO mai_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ओम्‍हर मुख्‍यपुरोहित सभ आ सम्‍पूर्ण धर्म-महासभाक सदस्‍य सभ यीशु केँ मृत्‍युदण्‍डक योग्‍य बनयबाक लेल हुनका विरोध मे झूठ-फूसक प्रमाण सभ जमा करबाक कोशिश मे लागल छलाह। ");
INSERT INTO mai_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","मुदा बहुतो झुट्ठा गवाह सभक वयान लेलाक बादो कोनो पकिया प्रमाण हुनका सभ केँ नहि भेटलनि। अन्‍त मे दू गोटे आगाँ आबि कऽ बाजल, ");
INSERT INTO mai_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ई आदमी कहने छल जे, ‘हम परमेश्‍वरक मन्‍दिर केँ तोड़ि कऽ तीन दिन मे फेर ओकर निर्माण कऽ सकैत छी’।” ");
INSERT INTO mai_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","एहि पर महापुरोहित ठाढ़ होइत यीशु केँ पुछलथिन, “की अहाँ कोनो उत्तर नहि देब? ई गवाह सभ अहाँक विरोध मे केहन बात सभ कहि रहल अछि?” ");
INSERT INTO mai_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","मुदा यीशु चुपे रहलाह। महापुरोहित फेर कहलथिन, “अहाँ जीवित परमेश्‍वरक सपत खा कऽ कहू जे, की अहाँ उद्धारकर्ता-मसीह, परमेश्‍वरक पुत्र छी?” ");
INSERT INTO mai_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","यीशु उत्तर देलथिन, “अहाँ अपने कहि देलहुँ। और हम अहाँ सभ केँ इहो बात कहैत छी जे, भविष्‍य मे अहाँ सभ मनुष्‍य-पुत्र केँ सर्वशक्‍तिमान परमेश्‍वरक दहिना कात बैसल आ आकाशक मेघ मे अबैत देखब।” ");
INSERT INTO mai_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ई बात सुनिते महापुरोहित अपन वस्‍त्र फाड़ैत बजलाह, “ई आदमी अपना केँ परमेश्‍वरक बराबरि बुझैत अछि! की अपना सभ केँ एखनो गवाह सभक आवश्‍यकता अछि? अहाँ सभ स्‍वयं अपन कान सँ सुनलहुँ जे ई परमेश्‍वरक निन्‍दा कयलक। ");
INSERT INTO mai_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","आब अहाँ सभक की विचार अछि?” ओ सभ उत्तर देलथिन, “ई मृत्‍युदण्‍डक जोगरक अछि।” ");
INSERT INTO mai_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","तकरबाद ओहिठाम उपस्‍थित लोक सभ यीशु केँ मुँह पर थूक फेकऽ लगलनि, हुनका मुक्‍का मारलकनि। किछु लोक हुनका थप्‍पड़ मारैत कहलकनि, ");
INSERT INTO mai_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“यौ अन्‍तर्यामी मसीह! कहल जाओ, अपने केँ के मारलक?” ");
INSERT INTO mai_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","पत्रुस ओहि समय धरि बाहर आङन मे बैसल छलाह। तखन एक टहलनी हुनका लग आबि कऽ कहलकनि, “अहूँ तँ गलील निवासी यीशुक संग छलहुँ।” ");
INSERT INTO mai_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","मुदा पत्रुस सभक सामने मे अस्‍वीकार करैत ओकरा कहलथिन, “तोँ की बाजि रहल छेँ से हमरा बुझहे मे नहि अबैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ई बात कहि पत्रुस ओहिठाम सँ हटि कऽ आङनक मुँह पर चल गेलाह। तखन एक दोसर टहलनी हुनका देखि ओतऽ ठाढ़ लोक सभ केँ कहलक, “ई आदमी नासरत नगरक यीशुक संग छल।” ");
INSERT INTO mai_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","पत्रुस सपत खाइत फेर अस्‍वीकार कयलनि जे, “हम ओहि आदमी केँ नहि चिन्‍हैत छी!” ");
INSERT INTO mai_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","किछु कालक बाद ओहिठाम ठाढ़ लोक सभ पत्रुस लग आबि कऽ कहलकनि, “निश्‍चय तोँ ओकरे सभ मे सँ छह। तोहर बोलिए एहि बात केँ स्‍पष्‍ट कऽ रहल छह।” ");
INSERT INTO mai_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","तखन पत्रुस सपत खा कऽ अपना केँ सरापऽ लगलाह आ कहलथिन जे, “हम ओहि आदमी केँ चिन्‍हिते नहि छी!” ठीक ओही क्षण मे मुर्गा बाजि उठल। ");
INSERT INTO mai_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","तखन पत्रुस केँ यीशुक कहल ओ बात मोन पड़ि गेलनि जे, “मुर्गा केँ बाजऽ सँ पहिने अहाँ हमरा तीन बेर अस्‍वीकार करब।” ओ ओहिठाम सँ बाहर भऽ भोकासी पाड़ि कऽ कानऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","प्रात भेने भोरे-भोर सभ मुख्‍यपुरोहित आ समाजक बूढ़-प्रतिष्‍ठित लोक सभ आपस मे विचार-विमर्श कऽ एहि बातक निश्‍चय कयलनि जे यीशु केँ मारि देल जाय। ");
INSERT INTO mai_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ओ सभ यीशु केँ बान्‍हि कऽ लऽ गेलाह आ राज्‍यपाल पिलातुसक जिम्‍मा मे लगा देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","यहूदा इस्‍करियोती जे यीशु केँ पकड़बौने छल, से जखन देखलक जे यीशु केँ मृत्‍युदण्‍डक आज्ञा देल गेलनि, तखन ओ बहुत पछतायल। ओ मुख्‍यपुरोहित आ बूढ़-प्रतिष्‍ठित सभ लग चानीक तीस सिक्‍का लऽ कऽ गेल आ हुनका सभ केँ कहलकनि, ");
INSERT INTO mai_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“हम निर्दोष व्‍यक्‍ति केँ मृत्‍युदण्‍डक लेल पकड़बा कऽ पाप कयलहुँ अछि।” ओ सभ उत्तर देलथिन, “ई बात तोँ जानह, एहि सँ हमरा सभ केँ कोनो मतलब नहि अछि।” ");
INSERT INTO mai_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","एहि पर ओ चानीक सिक्‍का सभ मन्‍दिर मे फेकि कऽ चल गेल आ अपना केँ फँसरी लगा लेलक। ");
INSERT INTO mai_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","मुख्‍यपुरोहित सभ ओ चानीक सिक्‍का उठा कऽ बजलाह, “एकरा मन्‍दिरक खजाना मे राखब उचित नहि होयत, किएक तँ ई खूनक मूल्‍य अछि।” ");
INSERT INTO mai_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ओ सभ आपस मे एहि बातक विचार-विमर्श कऽ परदेशी लोक सभक लास केँ गाड़बाक लेल ओहि पाइ सँ कुम्‍हारक एकटा खेत किनि लेलनि। ");
INSERT INTO mai_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","एहि कारण सँ आइओ धरि ओ खेत “खूनक खेत” कहबैत अछि। ");
INSERT INTO mai_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","एहि तरहेँ परमेश्‍वरक प्रवक्‍ता यर्मियाहक ई वचन पूर्ण भेल जे, “ओ सभ तीस चानीक सिक्‍का लेलक; ई ओ मूल्‍य छल, जे इस्राएली लोक सभ हुनकर दाम लगौने छल। ");
INSERT INTO mai_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","जेना प्रभु सँ हमरा आज्ञा भेटल छल, तेना ओहि पाइ सँ कुम्‍हारक खेत किनल गेल।” ");
INSERT INTO mai_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","एम्‍हर यीशु राज्‍यपाल पिलातुसक सम्‍मुख ठाढ़ छलाह। राज्‍यपाल हुनका सँ पुछलथिन, “की अहाँ यहूदी सभक राजा छी?” यीशु हुनका उत्तर देलथिन, “अहाँ अपने कहि रहल छी।” ");
INSERT INTO mai_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","मुदा मुख्‍यपुरोहित आ बूढ़-प्रतिष्‍ठित लोक सभ जे कोनो दोष यीशु पर लगौलथिन तकर ओ कोनो उत्तर नहि देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","एहि पर पिलातुस कहलथिन, “की अहाँ नहि सुनि रहल छी जे ई सभ अहाँ पर कतेक आरोप लगा रहल छथि?” ");
INSERT INTO mai_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","मुदा यीशु एको बातक कोनो उत्तर नहि देलथिन। ई बात देखि राज्‍यपाल केँ बहुत आश्‍चर्य लगलनि। ");
INSERT INTO mai_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","प्रत्‍येक साल फसह-पाबनिक अवसर पर राज्‍यपाल जनताक इच्‍छाक अनुसार एक कैदी केँ छोड़ि दैत छलाह। ");
INSERT INTO mai_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ओहि समय मे बरब्‍बा नामक एक नामी अपराधी जहल मे बन्‍द छल। ");
INSERT INTO mai_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","भीड़ केँ जमा भेला पर राज्‍यपाल पिलातुस ओकरा सभ केँ पुछलथिन, “अहाँ सभ की चाहैत छी? अहाँ सभक लेल हम ककरा छोड़ि दिअ? बरब्‍बा केँ वा यीशु केँ, जे मसीह कहबैत अछि?” ");
INSERT INTO mai_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","पिलातुस ई बात जानि गेल छलाह जे धर्मगुरु सभ यीशु केँ ईर्ष्‍याक कारणेँ पकड़बौने छथि। ");
INSERT INTO mai_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","पिलातुस न्‍यायासन पर बैसले छलाह कि हुनकर स्‍त्री कहा पठौलथिन जे, “ओहि निर्दोष मनुष्‍य केँ किछु नहि करिऔक! किएक तँ हम आइ राति सपना मे हुनका कारणेँ बहुत दुःख सहलहुँ अछि।” ");
INSERT INTO mai_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","मुदा मुख्‍यपुरोहित सभ आ बूढ़-प्रतिष्‍ठित लोक सभ जमा भेल लोक सभ केँ सिखा देने छलाह जे, “तोँ सभ बरब्‍बा केँ छोड़ि देबाक लेल आ यीशुक मृत्‍युदण्‍डक माँग करिहह।” ");
INSERT INTO mai_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","राज्‍यपाल ओकरा सभ केँ पुछलथिन, “अहाँ सभ की चाहैत छी? एहि दूनू मे सँ अहाँ सभक लेल हम ककरा छोड़ि दिअ?” ओ सभ बाजल, “बरब्‍बा केँ।” ");
INSERT INTO mai_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","पिलातुस कहलथिन, “तखन फेर एहि यीशु केँ, जे मसीह कहबैत अछि तकरा हम की करू?” सभ कहऽ लागल, “ओकरा क्रूस पर चढ़ाउ!” ");
INSERT INTO mai_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ओ पुछलथिन, “किएक? ई कोन अपराध कयने अछि?” एहि पर लोकक भीड़ आरो जोर-जोर सँ चिचियाय लागल, “ओकरा क्रूस पर चढ़ाउ!” ");
INSERT INTO mai_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","जखन पिलातुस देखलनि जे यीशु केँ बचयबाक हुनकर प्रयत्‍न सफल नहि भऽ रहल अछि, बल्‍कि एहि सँ उपद्रव बढ़ि रहल अछि, तखन ओ हाथ मे पानि लऽ कऽ लोक सभक सामने अपन हाथ धोइत कहलथिन, “एहि मनुष्‍यक खूनक दोषी हम नहि छी। अहीं सभ एहि बात केँ जानू!” ");
INSERT INTO mai_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","भीड़क लोक हुनका उत्तर देलकनि, “एकर खूनक दोष हमरा सभ पर आ हमर सभक सन्‍तान सभ पर होअय!” ");
INSERT INTO mai_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","तकरबाद पिलातुस ओकरा सभक इच्‍छाक अनुसार बरब्‍बा केँ छोड़ि देलथिन आ यीशु केँ कोड़ा सँ पिटबा कऽ क्रूस पर चढ़यबाक लेल सैनिक सभक जिम्‍मा लगा देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","राज्‍यपालक सैनिक सभ यीशु केँ राजभवन मे लऽ गेलनि आ अपन पूरा सैनिक-दल केँ हुनका चारू कात जमा कऽ लेलक। ");
INSERT INTO mai_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ओ सभ यीशु जे वस्‍त्र पहिरने छलाह तकरा निकलबा कऽ लाल रंगक राजसी वस्‍त्र पहिरा देलकनि। ");
INSERT INTO mai_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","काँटक मुकुट बना हुनका मूड़ी पर रखलकनि आ हुनका दहिना हाथ मे एक छड़ी पकड़ा देलकनि। तकरबाद हुनका सामने ठेहुनिया दऽ कऽ हुनकर मजाक उड़बैत कहऽ लगलनि, “यहूदी सभक राजा, प्रणाम!” ");
INSERT INTO mai_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ओ सभ हुनका पर थूक फेकलकनि आ हुनका हाथ सँ छड़ी लऽ कऽ बेर-बेर मूड़ी पर मारलकनि। ");
INSERT INTO mai_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ओ सभ एहि तरहेँ यीशुक मजाक उड़ौलाक बाद हुनका देह पर सँ लाल रंग वला वस्‍त्र निकालि लेलकनि आ हुनकर अपन कपड़ा फेर पहिरा देलकनि। तकरबाद ओ सभ हुनका क्रूस पर लटकयबाक लेल लऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","शहर सँ बाहर लऽ जाइत काल सैनिक सभ केँ सिमोन नामक एक आदमी जे कुरेन नगरक रहऽ वला छल, से भेटलैक। ओकरा सैनिक सभ जबरदस्‍ती पकड़ि कऽ यीशुक क्रूस उठा कऽ लऽ चलबाक लेल कहलकैक। ");
INSERT INTO mai_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","यीशु केँ लऽ कऽ ओ सभ गुलगुता, अर्थात् “खप्‍पड़ वला स्‍थान” पर पहुँचल। ");
INSERT INTO mai_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ओहिठाम ओ सभ यीशु केँ तीत दवाइ मिलाओल दारू पिबाक लेल देलकनि, मुदा ओ ओकरा चिखि कऽ नहि पिलनि। ");
INSERT INTO mai_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","सैनिक सभ हुनका हाथ-पयर मे काँटी ठोकि कऽ क्रूस पर टाँगि देलकनि। हुनकर वस्‍त्र पर चिट्ठा खसा कऽ अपना मे बाँटि लेलक, ");
INSERT INTO mai_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","तखन ओतऽ बैसि कऽ पहरा देबऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ओ सभ एक दोष-पत्र हुनका मूड़ीक उपर क्रूस पर टाँगि देलक जाहि पर लिखल छलैक जे, “ई यीशु अछि, यहूदी सभक राजा”। ");
INSERT INTO mai_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","यीशुक संगे दूटा डाकू सेहो क्रूस पर चढ़ाओल गेल, एकटा हुनकर दहिना कात और दोसर बामा कात। ");
INSERT INTO mai_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ओहि बाटे आबऽ-जाय वला लोक सभ मूड़ी डोला-डोला कऽ हुनकर निन्‍दा कऽ रहल छल। ");
INSERT INTO mai_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ओ सभ कहैत छल, “रे मन्‍दिर केँ तोड़ऽ वला और तीन दिन मे ओकरा बनाबऽ वला! तोँ जँ परमेश्‍वरक पुत्र छेँ तँ अपना केँ बचा आ एहि क्रूस पर सँ उतरि आ।” ");
INSERT INTO mai_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","तहिना मुख्‍यपुरोहित लोकनि, धर्मशिक्षक सभ आ बूढ़-प्रतिष्‍ठित लोक सभ सेहो हुनकर मजाक उड़बैत कहलनि, ");
INSERT INTO mai_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ई आन लोक सभ केँ बचबैत रहल मुदा अपना केँ नहि बचा सकैत अछि। ई जँ इस्राएलक राजा अछि तँ एखन क्रूस पर सँ उतरि आबओ, तखन हमहूँ सभ एकरा पर विश्‍वास करबैक। ");
INSERT INTO mai_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ई आदमी परमेश्‍वर पर भरोसा रखैत छल। जँ एकरा सँ परमेश्‍वर प्रसन्‍न छथिन तँ एखन बचबथुन। ई तँ अपना केँ परमेश्‍वरक पुत्र कहैत छल।” ");
INSERT INTO mai_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","एहि तरहेँ ओ डाकू सभ सेहो, जकरा यीशुक संग क्रूस पर चढ़ाओल गेल छलैक, यीशुक निन्‍दा कऽ रहल छल। ");
INSERT INTO mai_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ओहि दिन बारह बजे सँ तीन बजे तक सम्‍पूर्ण देश अन्‍हार-कुप्‍प भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","करीब तीन बजे मे यीशु बहुत जोर सँ बजलाह जे, “एली, एली, लामा सबक्‍तनी”, जकर अर्थ ई अछि, “हे हमर परमेश्‍वर, हे हमर परमेश्‍वर, हमरा अहाँ किएक छोड़ि देलहुँ?” ");
INSERT INTO mai_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ई सुनि ओतऽ ठाढ़ लोक सभ मे सँ किछु लोक बाजल, “ई आदमी एलियाह केँ बजा रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ओकरा सभ मे सँ एक गोटे तुरत दौड़ि कऽ गेल आ रूइ जकाँ एकटा एहन चीज जे पानि सोखैत अछि से लऽ कऽ तिताह दारू मे डुबा लेलक, तखन ओकरा लाठीक हूर पर अटका कऽ हुनका पिबाक लेल देलकनि। ");
INSERT INTO mai_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","मुदा दोसर लोक सभ ओकरा कहलकैक, “थम्‍हह, पहिने देखी जे एलियाह एकरा बचयबाक लेल अबैत छथि कि नहि।” ");
INSERT INTO mai_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","तकरबाद यीशु फेर जोर सँ आवाज दऽ कऽ अपन प्राण त्‍यागि देलनि। ");
INSERT INTO mai_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ओही क्षण मन्‍दिर मे जे परदा छलैक से ऊपर सँ नीचाँ तक चिरा कऽ दू भाग मे फाटि गेल। पृथ्‍वी डोलऽ लागल। चट्टान सभ फाटि गेल। ");
INSERT INTO mai_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","कबरक मुँह खुजि गेल आ परमेश्‍वरक बहुतो भक्‍त सभक लास फेर जिआओल गेल। ");
INSERT INTO mai_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ओ सभ कबर सँ बहरा कऽ यीशु केँ जीबि उठलाक बाद “पवित्र नगर” मे जा कऽ बहुतो लोक सभ केँ देखाइ देलनि। ");
INSERT INTO mai_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","रोमी कप्‍तान आ हुनका संग यीशु पर पहरा देबऽ वला सैनिक सभ, भूकम्‍‍प आ एहि घटना सभ केँ देखि बहुत डेरा गेल, और बाजि उठल, “सत्‍ये ई परमेश्‍वरक पुत्र छलाह!” ");
INSERT INTO mai_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","बहुतो स्‍त्रीगण सभ सेहो ओतऽ छलीह, जे सभ दूरे सँ ई बात सभ देखि रहल छलीह। ओ सभ गलील प्रदेश सँ यीशुक संग हुनकर सेवा-टहल करैत आयल छलीह। ");
INSERT INTO mai_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","हुनका सभ मे मरियम मग्‍दलीनी, याकूब आ यूसुफक माय मरियम, और जबदीक स्‍त्री, अर्थात् याकूब आ यूहन्‍नाक माय, छलीह। ");
INSERT INTO mai_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","साँझ पड़ला पर अरिमतिया नगरक निवासी यूसुफ नामक एक धनिक व्‍यक्‍ति ओतऽ अयलाह। ओहो यीशुक शिष्‍य बनि गेल छलाह। ");
INSERT INTO mai_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ओ राज्‍यपाल पिलातुसक ओतऽ जा कऽ यीशुक लास मँगलथिन। पिलातुस आदेश देलनि जे लास यूसुफ केँ दऽ देल जानि। ");
INSERT INTO mai_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","यूसुफ हुनकर लास लऽ गेलाह आ साफ मलमलक कपड़ा मे ओकरा लपेटि कऽ ");
INSERT INTO mai_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","अपन नव कबर मे रखलनि जे ओ एक चट्टान मे कटबा कऽ बनबौने छलाह। लास केँ रखलाक बाद ओ कबरक मुँह पर एक भारी पाथर गुड़का कऽ लगा देलनि आ चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","मरियम मग्‍दलीनी आ दोसर मरियम कबरक सामने बैसल छलीह। ");
INSERT INTO mai_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","एहि घटनाक प्रात भेने, अर्थात् विश्राम-दिन मे, मुख्‍यपुरोहित लोकनि आ फरिसी सभ एक संग पिलातुसक ओतऽ जा कऽ हुनका कहलथिन, ");
INSERT INTO mai_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“यौ सरकार! हमरा सभ केँ स्‍मरण अछि जे ओ ठग आदमी, जखन ओ जीबैत छल तखन कहने छल जे, ‘हम तीन दिनक बाद फेर जीबि उठब’। ");
INSERT INTO mai_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","तेँ अपने आज्ञा देल जाओ जे तीन दिन धरि ओहि कबर पर पहरा राखल जाय। नहि तँ कतौ एना नहि होअय जे ओकर चेला सभ ओकर लास चोरा कऽ लऽ जाय आ लोक सभ केँ कहऽ लागय जे, ओ मुइल सभ मे सँ जीबि उठलाह। तखन एहि बेरक ई धोखा वला बात पहिलुको धोखा सँ खराब होयत।” ");
INSERT INTO mai_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","पिलातुस हुनका सभ केँ कहलथिन, “अहाँ सभ सैनिक सभ लऽ जाउ आ जेहन सुरक्षा अहाँ सभ कबरक करऽ चाहैत होइ तेहन करू।” ");
INSERT INTO mai_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","तखन ओ सभ गेलाह आ कबरक मुँह पर बन्‍दक छाप लगा देलनि। सैनिक सभ केँ कबरक सुरक्षा करबाक लेल पहरा पर राखि देलथिन। ");
INSERT INTO mai_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","विश्राम-दिनक प्रात भेने, अर्थात् सप्‍ताहक पहिल दिन, भोर सँ भोर मरियम मग्‍दलीनी आ दोसर मरियम कबर देखबाक लेल गेलीह। ");
INSERT INTO mai_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","एकाएक बड़का भूकम्‍‍प भेल, कारण, परमेश्‍वरक एक स्‍वर्गदूत स्‍वर्ग सँ उतरलाह, और कबरक मुँह पर सँ पाथर गुड़का कऽ ओहि पर बैसि रहलाह। ");
INSERT INTO mai_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","हुनकर रूप बिजलोका जकाँ चमकैत छलनि आ हुनकर वस्‍त्र बर्फ सन उज्‍जर छलनि। ");
INSERT INTO mai_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","पहरा पर बैसल सैनिक सभ हुनका देखि एतेक डेरा गेल जे थर-थर काँपऽ लागल आ मरल सन भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","तखन स्‍वर्गदूत ओहि स्‍त्रीगण सभ केँ कहलथिन, “अहाँ सभ नहि डेराउ। हम जनैत छी जे अहाँ सभ यीशु केँ, जिनका क्रूस पर चढ़ाओल गेल छलनि, तिनका तकबाक लेल आयल छी। ");
INSERT INTO mai_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","मुदा ओ एतऽ नहि छथि। ओ जहिना कहने छलाह तहिना जीबि उठल छथि। आउ, ओहि स्‍थान केँ देखू जतऽ हुनका राखल गेल छलनि, ");
INSERT INTO mai_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","आ तखन जल्‍दी जा कऽ हुनकर शिष्‍य सभ केँ ई समाचार सुनाउ जे, ‘ओ मुइल सभ मे सँ जीबि उठलाह! अहाँ सभ सँ पहिने गलील जा रहल छथि आ ओतऽ हुनका सँ भेँट होयत।’ ई बात अहाँ सभ केँ कहि देलहुँ।” ");
INSERT INTO mai_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ओ सभ डर आ तैयो बड़का खुशीक संग ई समाचार शिष्‍य सभ केँ सुनयबाक लेल कबर पर सँ दौड़ पड़लीह। ");
INSERT INTO mai_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","एकाएक यीशु हुनका सभक आगाँ मे प्रगट भऽ देखाइ देलथिन आ नमस्‍कार कयलथिन। स्‍त्रीगण सभ लग मे जा कऽ हुनकर पयर पकड़ि कऽ आराधना कयलनि। ");
INSERT INTO mai_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","यीशु हुनका सभ केँ कहलथिन, “अहाँ सभ डेराउ नहि। जा कऽ हमर भाय सभ केँ गलील मे पहुँचबाक लेल कहिऔक। ओतहि ओ सभ हमरा देखत।” ");
INSERT INTO mai_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","स्‍त्रीगण सभ एखन रस्‍ते मे छलीह। ओम्‍हर कबर पर पहरा देबऽ वला मे सँ किछु सैनिक सभ नगर मे जा कऽ मुख्‍यपुरोहित सभ केँ एहि घटनाक सम्‍पूर्ण विवरण कहि सुनौलक। ");
INSERT INTO mai_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","मुख्‍यपुरोहित सभ यहूदी सभक बूढ़-प्रतिष्‍ठित लोकनि केँ जमा कऽ एहि विषय मे किछु विचार-विमर्श कयलनि। तकरबाद ओ सभ ओहि सैनिक सभ केँ बहुत रुपैया-पैसा दैत कहलथिन, ");
INSERT INTO mai_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“लोक केँ अहाँ सभ ई कहू जे, ‘राति मे हम सभ जखन सुतल छलहुँ तँ ओकर चेला सभ ओकर लास चोरा कऽ लऽ गेल।’ ");
INSERT INTO mai_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","राज्‍यपाल पिलातुस तक जँ कतौ ई खबरि पहुँचत तँ हम सभ हुनका सँ ई बात सभ मिला लेब और अहाँ सभ केँ बचा लेब।” ");
INSERT INTO mai_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","सैनिक सभ हुनका सभ सँ ओ पाइ लऽ लेलक आ जहिना ओ सभ सिखौने छलथिन तहिना लोक सभ केँ कहऽ लागल। ई अफवाह यहूदी सभ मे दूर-दूर पसरि गेल और आइओ तक ओकरा सभ मे प्रचलित अछि। ");
INSERT INTO mai_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","यीशुक एगारह शिष्‍य गलील जा कऽ ओहि पहाड़ पर गेलाह जतऽ यीशु हुनका सभ केँ पहुँचबाक लेल कहने छलथिन। ");
INSERT INTO mai_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","यीशु केँ देखि कऽ ओ सभ हुनकर आराधना कयलथिन। मुदा किछु गोटेक मोन मे हुनका बारे मे शंको छलनि। ");
INSERT INTO mai_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","तखन यीशु हुनका सभक लग आबि कहलथिन, “स्‍वर्ग आ पृथ्‍वीक सम्‍पूर्ण अधिकार हमरा देल गेल अछि। ");
INSERT INTO mai_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","एहि लेल अहाँ सभ आब जा कऽ सभ जातिक लोक केँ हमर शिष्‍य बनाउ और ओकरा सभ केँ पिता, पुत्र आ पवित्र आत्‍माक नाम सँ बपतिस्‍मा दिऔक। ");
INSERT INTO mai_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","हम जतेक आदेश अहाँ सभ केँ देने छी तकर सभक पालन करबाक लेल ओकरा सभ केँ सिखाउ। मोन राखू, संसारक अन्‍त तक हम सदिखन अहाँ सभक संग छी।”");
INSERT INTO mai_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","परमेश्‍वरक पुत्र यीशु मसीहक शुभ समाचार एहि तरहेँ शुरू होइत अछि— ");
INSERT INTO mai_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","परमेश्‍वरक प्रवक्‍ता यशायाह द्वारा लिखल पुस्‍तक मे भविष्‍यवाणी कयल गेल अछि जे, “देखू, अहाँ सँ पहिने हम अपन दूत पठायब, जे अहाँक आगाँ-आगाँ अहाँक बाट तैयार करत।” ");
INSERT INTO mai_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“निर्जन क्षेत्र मे केओ जोर सँ आवाज दऽ रहल अछि जे, ‘प्रभुक लेल मार्ग तैयार करू, हुनका लेल सोझ बाट बनाउ।’ ” ");
INSERT INTO mai_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","तहिना यूहन्‍ना नामक दूत निर्जन क्षेत्र मे अयलाह और लोक केँ बपतिस्‍मा दैत प्रचार करऽ लगलाह जे, “पापक क्षमा पयबाक लेल पश्‍चात्ताप कऽ हृदय-परिवर्तन करू और बपतिस्‍मा लिअ।” ");
INSERT INTO mai_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","यहूदिया प्रदेशक और यरूशलेम शहरक सभ लोक बाहर निकलि कऽ हुनका लग गेल और अपन पाप स्‍वीकार करैत यरदन नदी मे हुनका सँ बपतिस्‍मा लेलक। ");
INSERT INTO mai_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","यूहन्‍ना ऊँटक रोंइयाँ सँ बनल वस्‍त्र पहिरने रहैत छलाह और अपना डाँड़ मे चमड़ाक पट्टी बन्‍हने रहैत छलाह। भोजन मे फनिगा आ वन वला मधु खाइत छलाह। ");
INSERT INTO mai_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ओ एहि तरहेँ प्रचार करैत छलाह, “हमरा बाद मे एक गोटे आबि रहल छथि जे हमरा सँ शक्‍तिशाली छथि। हम झुकि कऽ हुनकर जुत्तो खोलऽ जोगरक नहि छी। ");
INSERT INTO mai_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","हम तँ अहाँ सभ केँ पानि सँ बपतिस्‍मा दैत छी लेकिन ओ अहाँ सभ केँ पवित्र आत्‍मा सँ बपतिस्‍मा देताह।” ");
INSERT INTO mai_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ओहि समय मे यीशु गलील प्रदेशक नासरत नगर सँ अयलाह और यूहन्‍ना सँ यरदन नदी मे बपतिस्‍मा लेलनि। ");
INSERT INTO mai_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","पानि सँ बाहर होइत काल यीशु आकाश केँ फटैत और परबाक रूप मे पवित्र आत्‍मा केँ अपना पर उतरैत देखलनि। ");
INSERT INTO mai_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","स्‍वर्ग सँ आवाज आयल जे, “अहाँ हमर प्रिय पुत्र छी। अहाँ सँ हम बहुत प्रसन्‍न छी।” ");
INSERT INTO mai_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","तखन पवित्र आत्‍मा तुरत यीशु केँ निर्जन क्षेत्र मे पठौलथिन ");
INSERT INTO mai_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","जतऽ चालिस दिन धरि शैतान हुनका सँ पाप करयबाक कोशिश कयलकनि। ओ जंगली जानबर सभक बीच मे रहैत छलाह और स्‍वर्गदूत सभ हुनकर सेवा करैत छलनि। ");
INSERT INTO mai_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","बाद मे, यूहन्‍ना केँ जहल मे राखि देल गेलाक बाद, यीशु गलील प्रदेश गेलाह और परमेश्‍वरक शुभ समाचारक प्रचार कयलनि जे, ");
INSERT INTO mai_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“समय आबि गेल अछि, परमेश्‍वरक राज्‍य लग मे अछि! अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन करू आ शुभ समाचार पर विश्‍वास करू।” ");
INSERT INTO mai_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","एक दिन यीशु गलील झीलक कात चलैत काल मे सिमोन और हुनकर भाय अन्‍द्रेयास केँ झील मे जाल फेकैत देखलनि। ओ सभ मछबार छलाह। ");
INSERT INTO mai_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","यीशु हुनका सभ केँ बजौलथिन और कहलथिन, “यौ! हमरा पाछाँ आउ। हम अहाँ सभ केँ मनुष्‍य केँ पकड़ऽ वला मछबार बना देब।” ");
INSERT INTO mai_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ओ सभ अपन जाल छोड़ि कऽ हुनका पाछाँ लागि गेलनि। ");
INSERT INTO mai_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","किछु आगू बढ़लाक बाद यीशु याकूब और यूहन्‍ना दूनू भाय केँ अपन बाबू जबदीक संग नाव मे जाल तैयार करैत देखलथिन। ");
INSERT INTO mai_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ओ तुरत हुनका सभ केँ बजौलथिन, और ओ सभ अपन बाबू जबदी केँ जऽन-बोनिहारक संग नाव मे छोड़ि हुनका संग भऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ओ सभ कफरनहूम नगर गेलाह। विश्रामक दिन मे यीशु सभाघर मे जा कऽ उपदेश देबऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","हुनकर शिक्षा सुनि लोक सभ चकित भेल किएक तँ ओ धर्मशिक्षक सभ जकाँ नहि, बल्‍कि अधिकारपूर्बक शिक्षा दैत छलाह। ");
INSERT INTO mai_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","एकाएक सभाघर मे एकटा दुष्‍टात्‍मा लागल आदमी हल्‍ला करऽ लागल जे, ");
INSERT INTO mai_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“यौ नासरतक निवासी यीशु! अहाँ केँ हमरा सभ सँ कोन काज? हमरा सभ केँ नष्‍ट करऽ अयलहुँ की? हम अहाँ केँ चिन्‍हैत छी। अहाँ परमेश्‍वरक पवित्र दूत छी।” ");
INSERT INTO mai_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","यीशु दुष्‍टात्‍मा केँ डाँटि कऽ कहलथिन, “चुप रह! तोँ एकरा मे सँ निकल!” ");
INSERT INTO mai_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","दुष्‍टात्‍मा ओहि आदमी केँ झकझोड़ैत आ जोर सँ चिचियाइत ओकरा मे सँ निकलि गेल। ");
INSERT INTO mai_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ई देखि सभ आदमी ततेक आश्‍चर्य-चकित भेल जे एक-दोसर केँ कहऽ लागल जे, “ई की बात? ई कोन प्रकारक नव उपदेश अछि? ई आदमी तँ अधिकारपूर्बक दुष्‍टात्‍मा सभ केँ सेहो आज्ञा दैत छथि और ओ सभ हिनकर बात मानैत छनि!” ");
INSERT INTO mai_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","एहि सभ सँ यीशुक चर्चा बहुत जल्‍दी सम्‍पूर्ण गलील प्रदेश मे चारू कात पसरि गेलनि। ");
INSERT INTO mai_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","यीशु सभाघर सँ बाहर भऽ कऽ तुरत सिमोन और अन्‍द्रेयासक घर गेलाह। हुनका संग यूहन्‍ना और याकूब सेहो छलाह। ");
INSERT INTO mai_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","सिमोनक सासु बोखार सँ पीड़ित ओछायन पर पड़ल छलीह। लोक सभ हुनका विषय मे यीशु केँ कहलकनि। ");
INSERT INTO mai_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","यीशु हुनका लग जा आ हुनकर हाथ पकड़ि कऽ उठौलथिन। हुनकर बोखार तुरत उतरि गेलनि और ओ हिनका सभक सेवा-सत्‍कार मे लागि गेलीह। ");
INSERT INTO mai_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ओही दिनक साँझ मे सूर्यास्‍‍तक बाद लोक सभ रोगी और दुष्‍टात्‍मा लागल आदमी सभ केँ हुनका लग अनलकनि। ");
INSERT INTO mai_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ओहि नगरक सभ लोक घरक सामने जमा भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","यीशु अनेक प्रकारक बिमारी सँ पीड़ित बहुत लोक सभ केँ नीक कयलनि, और बहुत लोक मे सँ दुष्‍टात्‍मा सभ केँ सेहो निकाललनि। मुदा ओ दुष्‍टात्‍मा सभ केँ बाजऽ नहि देलथिन किएक तँ यीशु के छथि से ओकरा सभ केँ बुझल छलैक। ");
INSERT INTO mai_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","दोसर दिन यीशु अन्‍हरोखे उठि बाहर गेलाह और एकान्‍त स्‍थान मे जा कऽ प्रार्थना करऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","सिमोन और हुनकर संगी सभ हुनका ताकऽ लेल गेलनि। ");
INSERT INTO mai_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","भेँट भेला पर हुनका कहलथिन, “सभ केओ अहाँ केँ खोजि रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","तखन ओ उत्तर देलथिन जे, “अपना सभ कोनो दोसर ठाम चलू। लग-पासक आरो गाम-बजार सभ मे सेहो हम परमेश्‍वरक शुभ समाचार सुनायब, किएक तँ हम एही लेल आयल छी।” ");
INSERT INTO mai_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","तेँ ओ पूरा गलील प्रदेश मे घुमलाह और ओकरा सभक सभाघर सभ मे जा कऽ उपदेश देलनि, और लोक सभ मे सँ दुष्‍टात्‍मा सभ केँ निकाललथिन। ");
INSERT INTO mai_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","एक बेर एकटा कुष्‍ठ-रोगी हुनका लग आबि ठेहुनिया रोपि कऽ हुनका सँ निवेदन कयलकनि जे, “अपने जँ चाही तँ हमरा शुद्ध कऽ सकैत छी।” ");
INSERT INTO mai_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","यीशु केँ ओकरा पर दया आबि गेलनि और ओ अपन हाथ बढ़ा कऽ ओकरा छुबि कऽ कहलथिन, “हम अवश्‍य चाहैत छिअह! तोँ शुद्ध भऽ जाह।” ");
INSERT INTO mai_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","तुरत्ते ओकर कुष्‍ठ-रोग ठीक भऽ गेलैक और ओ शुद्ध भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","यीशु ओकरा ई कड़ा आदेश दऽ कऽ विदा कयलथिन जे, ");
INSERT INTO mai_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“ई बात ककरो नहि कहिअहक। पुरोहित लग जा कऽ अपना केँ देखाबह। शुद्ध होयबाक विषय मे मूसाक लिखल नियमक अनुसार, जे बलिदान चढ़यबाक अछि से चढ़ाबह। एहि तरहेँ सभक लेल गवाही रहत जे तोँ शुद्ध भऽ गेल छह।” ");
INSERT INTO mai_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","मुदा ओ एहि घटनाक विषय मे सभ केँ जा कऽ कहि देलकैक, जकर फल ई भेल जे यीशु आब खुलि कऽ कोनो नगर मे नहि जा सकैत छलाह। ओ शहर सँ बाहर एकान्‍त मे रहऽ लगलाह मुदा तैयो लोक सभ चारू दिस सँ हुनका लग अबैत-जाइत छलनि। ");
INSERT INTO mai_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","किछु दिनक बाद यीशु कफरनहूम नगर घूमि अयलाह। लोक सभ केँ पता लगलैक जे ओ घर मे छथि। ");
INSERT INTO mai_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ई सुनि ततेक लोक जमा भऽ गेल जे घरक दुआरियो लग कनेको जगह नहि बाँचल। यीशु ओकरा सभ केँ परमेश्‍वरक शुभ समाचार सुनबैत रहथिन। ");
INSERT INTO mai_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ओही समय मे एकटा लकवा मारल आदमी केँ चारि गोटे सँ खाट पर लदने किछु गोटे आयल। ");
INSERT INTO mai_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","भीड़क कारणेँ ओ सभ यीशु लग नहि पहुँचि सकल। तेँ चार पर चढ़ि चार उजाड़ि कऽ, जाहि ठाम नीचाँ मे यीशु छलाह ताहि ठाम सँ खाट सहित लकवाक रोगी केँ हुनका लग उतारि देलकनि। ");
INSERT INTO mai_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ओकरा सभक विश्‍वास देखि कऽ यीशु लकवाक रोगी केँ कहलथिन, “हौ बेटा, तोहर पाप माफ भेलह।” ");
INSERT INTO mai_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","किछु धर्मशिक्षक जे ओहिठाम बैसल छलाह मोने-मोन विचार करऽ लगलाह जे, ");
INSERT INTO mai_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“अरे! ई आदमी कोना एना परमेश्‍वरक निन्‍दा करैत अछि? परमेश्‍वर केँ छोड़ि आरो के पाप केँ माफ कऽ सकैत अछि?” ");
INSERT INTO mai_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","यीशु तुरत अपना आत्‍मा मे हुनका सभक मोनक बात बुझि गेलाह और हुनका सभ केँ कहलथिन, “अहाँ सभ अपना-अपना मोन मे किएक एना तर्क-वितर्क करैत छी? ");
INSERT INTO mai_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","आसान की अछि—लकवाक रोगी केँ ई कहब जे, ‘तोहर पाप माफ भेलह,’ वा ई कहब जे, ‘उठह! अपन खाट उठा कऽ चलह-फिरह’? ");
INSERT INTO mai_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","मुदा जाहि सँ अहाँ सभ बुझि जाइ जे पृथ्‍वी पर पाप केँ माफ करबाक अधिकार मनुष्‍य-पुत्र केँ छनि, हम एकरा कहैत छी...” तखन ओ लकवाक रोगी केँ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“हम तोरा कहैत छिअह, उठह, अपन खाट उठाबह आ घर चल जाह!” ");
INSERT INTO mai_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ओ उठल और सभक सामने अपन खाट उठा कऽ विदा भऽ गेल। ई देखि सभ लोक अचम्‍भित भऽ गेल और परमेश्‍वरक जयजयकार करैत कहऽ लागल जे, “हम सभ तँ एहन घटना पहिने कहियो नहि देखने छलहुँ!” ");
INSERT INTO mai_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","तखन यीशु ओहिठाम सँ निकलि कऽ फेर झीलक कात गेलाह। बहुत लोक हुनका लग अबैत-जाइत रहलनि और ओ ओकरा सभ केँ उपदेश दैत रहलाह। ");
INSERT INTO mai_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ओहिठाम सँ विदा भेलाक बाद रस्‍ता मे अल्‍फेयासक बेटा लेवी केँ कर असूल करऽ वला स्‍थान मे बैसल देखलथिन। हुनका बजा कऽ कहलथिन, “हमरा पाछाँ आउ।” लेवी उठि कऽ हुनका संग विदा भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","बाद मे यीशु लेवीक घर मे भोजन करऽ बैसलाह। हुनका आ हुनकर शिष्‍य सभक संग, कर असूल करऽ वला और “पापी” सभ सेहो बैसल छल। हुनका संग चलनिहार मे बहुतो एहनो लोक सभ छल। ");
INSERT INTO mai_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","फरिसी पंथक किछु धर्मशिक्षक जखन देखलनि जे यीशु कर असूल करऽ वला आ “पापी” सभक संग भोजन करैत छथि, तखन ओ सभ हुनकर शिष्‍य सभ सँ पुछलनि जे, “ओ कर असूल करऽ वला और पापी सभक संग किएक खाइत-पिबैत छथि?” ");
INSERT INTO mai_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ई बात सुनि यीशु हुनका सभ केँ कहलथिन, “वैद्यक आवश्‍यकता स्‍वस्‍थ लोक केँ नहि होइत छैक, बल्‍कि बिमार सभ केँ! हम धार्मिक सभ केँ नहि, बल्‍कि पापी सभ केँ बजयबाक लेल आयल छी।” ");
INSERT INTO mai_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ओहि समय मे यूहन्‍नाक शिष्‍य सभ और फरिसी सभ उपास करैत छलाह। किछु लोक यीशु लग आबि कऽ पुछलकनि जे, “देखू! यूहन्‍नाक शिष्‍य सभ और फरिसी सभक शिष्‍य उपास कऽ रहल छथि। अहाँक शिष्‍य सभ किएक नहि?” ");
INSERT INTO mai_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","यीशु ओकरा सभ केँ उत्तर देलथिन जे, “जाबत तक वरियातीक संग वर अछि ताबत तक की वरियाती उपास करत? नहि! जाबत धरि वर संगे रहतैक ताबत धरि उपास नहि करत। ");
INSERT INTO mai_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","मुदा ओ समय आओत जहिया वर ओकरा सभक बीच सँ हटा लेल जायत। ओ सभ ताही दिन उपास करत। ");
INSERT INTO mai_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“केओ पुरान कपड़ा मे नयाँ कपड़ाक चेफरी नहि लगबैत अछि। जँ लगाओत तँ नयाँ कपड़ा घोकचि कऽ पुरान कपड़ा केँ खिचत और ओ कपड़ा आरो फाटि जायत। ");
INSERT INTO mai_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","केओ नव दारू पुरान चमड़ाक थैली मे नहि रखैत अछि। कारण, एना जँ करत तँ थैली फाटि जयतैक और दारू आ थैली दूनू नष्‍ट भऽ जयतैक। नहि! नव दारू नये थैली मे राखल जाइत अछि।” ");
INSERT INTO mai_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","कोनो विश्राम-दिन कऽ यीशु और हुनकर शिष्‍य सभ खेत दऽ कऽ जा रहल छलाह। हुनकर शिष्‍य सभ चलैत-चलैत अन्‍नक बालि तोड़ि लैत छलाह। ");
INSERT INTO mai_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ई देखि फरिसी सभ यीशु केँ कहलथिन, “देखू! जे काज विश्राम-दिन मे करब धर्म-नियमक अनुसार मना अछि, से ई सभ किएक करैत छथि?!” ");
INSERT INTO mai_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","यीशु हुनका सभ केँ जबाब देलथिन जे, “की अहाँ सभ ई नहि पढ़ने छी जे दाऊद आ हुनकर संगी सभ जखन भुखायल छलाह और हुनका सभक संग मे खयबाक लेल किछु नहि छलनि तखन ओ की कयलनि? ");
INSERT INTO mai_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ओ अपना संगी सभक संग परमेश्‍वरक भवन मे गेलाह और परमेश्‍वर केँ चढ़ाओल रोटी खयलनि। ओहि समय मे अबियातर महापुरोहित छलाह। चढ़ाओल रोटी जे पुरोहित केँ मात्र खयबाक अधिकार छलनि से दाऊद अपनो खयलनि आ अपन संगिओ सभ केँ देलथिन।” ");
INSERT INTO mai_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","तखन ओकरा सभ केँ इहो कहलथिन जे, “विश्राम-दिन मनुष्‍यक लेल बनाओल गेल छैक, मनुष्‍य विश्राम-दिनक लेल नहि। ");
INSERT INTO mai_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","तेँ मनुष्‍य-पुत्र विश्रामो-दिनक मालिक छथि।” ");
INSERT INTO mai_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","दोसर बेर यीशु सभाघर गेलाह। एक गोटे जकर हाथ सुखायल छलैक सेहो ओहिठाम छल। ");
INSERT INTO mai_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","किछु लोक सभ यीशु पर दोष लगयबाक आधारक लेल हुनका पर नजरि गड़ौने छल जे, देखी ओ विश्राम-दिन मे एकरा स्‍वस्‍थ करताह वा नहि। ");
INSERT INTO mai_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","यीशु सुखल हाथ वला आदमी केँ कहलथिन, “उठह! सभक आगाँ मे ठाढ़ होअह।” ");
INSERT INTO mai_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","तखन लोक सभ दिस घूमि कऽ पुछलथिन जे, “विश्राम-दिन मे की उचित? नीक काज करब अथवा अधलाह? ककरो जीवनक रक्षा करब अथवा नष्‍ट करब?” केओ किछु नहि बाजल। ");
INSERT INTO mai_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","यीशु तमसा कऽ चारू दिस लोक सभ पर नजरि दौड़ौलनि। ओ लोक सभक जिद्दीपनक कारणेँ उदास भऽ गेलाह और ओहि आदमी केँ कहलथिन जे, “अपन हाथ बढ़ाबह।” ओ हाथ बढ़ौलक और ओकर हाथ एकदम ठीक भऽ गेलैक। ");
INSERT INTO mai_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","फरिसी सभ तुरत निकलि कऽ हेरोद-दलक संग मिलि कऽ यीशु केँ कोना मारल जाय, तकर षड्‌यन्‍त्र रचऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","यीशु अपन शिष्‍य सभक संग झीलक कात मे चल गेलाह, और गलील प्रदेशक लोक सभक बड़का भीड़ हुनका सभक पाछाँ-पाछाँ गेलनि। ");
INSERT INTO mai_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","यीशु द्वारा कयल गेल काजक विषय मे सुनि कऽ यहूदिया प्रदेश, यरूशलेम, इदूमिया, यरदन नदीक ओहि पारक क्षेत्र, सूर और सीदोन नगरक क्षेत्र सँ बहुत लोक हुनका ओहिठाम आयल। ");
INSERT INTO mai_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","यीशु अपन शिष्‍य सभ केँ कछेर पर एकटा नाव तैयार राखऽ लेल कहलथिन जाहि सँ लोकक भीड़ हुनका दबा नहि देनि। ");
INSERT INTO mai_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ओ ततेक लोक केँ नीक कयने रहथिन जे विभिन्‍न प्रकारक रोगी सभ हुनका शरीर मे भिड़बाक लेल ठेलम-ठेल कऽ रहल छल। ");
INSERT INTO mai_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","जखन दुष्‍टात्‍मा सभ हुनका देखैत छल तँ हुनका समक्ष खसि कऽ चिचिया लगैत छल जे, “अहाँ परमेश्‍वरक पुत्र छी।” ");
INSERT INTO mai_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","मुदा यीशु ओकरा सभ केँ मना कयलथिन जे, “लोक केँ ई नहि कहिअहक जे हम के छी।” ");
INSERT INTO mai_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","तकर बाद यीशु पहाड़ पर चल गेलाह और जिनका सभ केँ ओ चुनलथिन तिनका सभ केँ अपना लग बजौलथिन। ओ सभ हुनका लग अयलनि। ");
INSERT INTO mai_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","यीशु बारह आदमी केँ “दूत” कहि कऽ नियुक्‍त कयलथिन जाहि सँ ओ सभ हुनका संग रहथि, आ जिनका ओ शुभ समाचारक प्रचार करबाक लेल आ दुष्‍टात्‍मा सभ केँ निकालबाक लेल पठा सकथि। ");
INSERT INTO mai_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","बारह शिष्‍य जिनका सभ केँ ओ चुनलनि से यैह सभ छथि—सिमोन, जिनका ओ “पत्रुस” नाम देलथिन, ");
INSERT INTO mai_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","जबदीक बेटा याकूब और हुनकर भाय यूहन्‍ना, जिनका सभ केँ ओ बुअनेरगिस, अर्थात्‌ “ठनकाक पुत्र सभ” नाम देलथिन, ");
INSERT INTO mai_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","अन्‍द्रेयास, फिलिपुस, बरतुल्‍मै, मत्ती, थोमा, अल्‍फेयासक बेटा याकूब, तद्दै, सिमोन “देश-भक्‍त”, ");
INSERT INTO mai_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","और यहूदा इस्‍करियोती जे बाद मे यीशुक संग विश्‍वासघात कयलकनि। ");
INSERT INTO mai_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","तखन यीशु और हुनकर शिष्‍य सभ एकटा घर मे गेलाह। ओहिठाम ततेक लोक फेर जमा भऽ गेल जे हुनका सभ केँ भोजनो करबाक समय नहि भेटलनि। ");
INSERT INTO mai_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","हुनकर घरक लोक जखन ई बात सुनलनि तँ हुनका जबरदस्‍ती लऽ अयबाक लेल विदा भेलाह, ई सोचि जे यीशु पागल भऽ गेल छथि। ");
INSERT INTO mai_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","यरूशलेम सँ आयल धर्मशिक्षक सभ कहऽ लगलाह जे, “यीशु मे दुष्‍टात्‍मा सभक मुखिया बालजबूल छैक। तकरे शक्‍ति सँ ओ दुष्‍टात्‍मा सभ केँ निकालैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","हुनका सभ केँ अपना लग बजा कऽ यीशु उदाहरण द्वारा उत्तर देलथिन जे, “शैतान कोना शैतान केँ भगा सकत? ");
INSERT INTO mai_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","जँ कोनो राज्‍य मे फूट पड़ि जाय तँ ओ नहि टिकि सकत। ");
INSERT INTO mai_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","तहिना जँ कोनो परिवार मे फूट भऽ गेल अछि तँ ओ नहि टिकि सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","जँ शैतान अपने केँ विरोध करय और ओकरा अपने मे फूट भऽ जाइक तँ ओ टिकि नहि सकैत अछि। ओकर विनाश निश्‍चित छैक। ");
INSERT INTO mai_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","केओ कोनो बलगर आदमीक घर मे ढुकि कऽ ओकर चीज-वस्‍तु ताबत तक नहि लुटि सकैत छैक, जाबत तक पहिने ओहि बलगर आदमी केँ बान्‍हि कऽ काबू मे नहि कऽ लैत अछि। ओकरा बान्‍हि लेलाक बादे ओकर वस्‍तु लुटि सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","अहाँ सभ केँ हम विश्‍वास दिअबैत छी जे, मनुष्‍य केँ सभ तरहक पाप आ निन्‍दाक बातक क्षमा भेटि सकैत छैक, ");
INSERT INTO mai_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","मुदा जँ केओ पवित्र आत्‍माक निन्‍दा करैत अछि तँ ओकरा कहियो क्षमा नहि भेटतैक। ओ अनन्‍त पापक दोषी होयत।” ");
INSERT INTO mai_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","यीशु ई बात एहि लेल कहलथिन जे ओ सभ कहैत छलाह जे हुनका मे दुष्‍टात्‍मा छनि। ");
INSERT INTO mai_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ओहि समय मे यीशुक माय आ भाय लोकनि ओतऽ पहुँचलाह। सभ गोटे बाहर रहि कऽ, यीशु केँ बाहर अयबाक लेल खबरि पठौलनि। ");
INSERT INTO mai_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","यीशुक चारू कात लोक सभ बैसल छल। एक गोटे आबि कऽ हुनका कहलकनि जे, “सुनू! अहाँक माय और भाय लोकनि बाहर ठाढ़ छथि आ अहाँ केँ बजबैत छथि।” ");
INSERT INTO mai_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ओ कहलथिन, “के छथि हमर माय? के सभ छथि हमर भाय?” ");
INSERT INTO mai_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ओ चारू कात बैसल लोकक दिस ताकि कहलनि जे, “देखू! यैह सभ हमर माय और भाय लोकनि छथि! ");
INSERT INTO mai_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","जे केओ परमेश्‍वरक इच्‍छाक अनुसार चलैत छथि वैह हमर भाय, हमर बहिन, हमर माय छथि।” ");
INSERT INTO mai_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","दोसर बेर यीशु फेरो झीलक कात मे लोक सभ केँ शिक्षा देबऽ लगलाह। हुनका लग ततेक लोक जमा भऽ गेल जे ओ झील मे नाव पर चढ़ि कऽ किनार सँ कनेक हटि कऽ बैसि गेलाह। लोक सभ किनार पर सँ हुनकर शिक्षा सुनैत छल। ");
INSERT INTO mai_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ओकरा सभ केँ ओ बहुत बात दृष्‍टान्‍त सभक द्वारा सिखबैत छलथिन। ");
INSERT INTO mai_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","एहि बेर उपदेश दैत ओ कहलथिन, “सुनू! एक किसान बीया बाउग करबाक लेल गेल। ");
INSERT INTO mai_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","बीया बाउग करैत काल किछु बीया रस्‍ताक कात मे खसल आ चिड़ै सभ आबि ओकरा खा लेलकैक। ");
INSERT INTO mai_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","किछु बीया पथराह जमीन पर खसल जतऽ बेसी माटि नहि होयबाक कारणेँ ओ जल्‍दी जनमि गेल। ");
INSERT INTO mai_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","मुदा रौद लगिते ओ झरकि गेल आ जड़ि नहि पकड़ि सकबाक कारणेँ सुखा गेल। ");
INSERT INTO mai_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","फेर दोसर बीया काँट-कुशक बीच मे खसल मुदा काँट-कुश बढ़ि कऽ ओकरा दबा देलकैक। तेँ ओहि बीया सँ कोनो फसिल नहि भेलैक। ");
INSERT INTO mai_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","किछु बीया नीक जमीन पर पड़ल। ओ जनमि कऽ फड़ल-फुलायल और फसिल देलक—कोनो तीस गुना, कोनो साठि गुना, कोनो सय गुना।” ");
INSERT INTO mai_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","तखन यीशु कहलथिन, “जकरा सुनबाक कान छैक, से सुनओ।” ");
INSERT INTO mai_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","बाद मे जखन यीशु अपन बारह शिष्‍य आ आरो संगी सभक संग एकान्‍त मे छलाह तखन ओ सभ एहि दृष्‍टान्‍तक बारे मे हुनका सँ पुछलथिन। ");
INSERT INTO mai_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","यीशु कहलथिन, “परमेश्‍वरक राज्‍यक रहस्‍यक ज्ञान अहाँ सभ केँ देल गेल अछि, मुदा जे बाहरक लोक अछि तकरा सभक लेल सभ बात दृष्‍टान्‍तक रूप मे रहैत छैक, ");
INSERT INTO mai_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","जाहि सँ, जहिना लिखल अछि, ‘तकितो ओ सभ देखय नहि, सुनितो ओ सभ बुझय नहि। एना जँ नहि रहैत तँ ओ सभ घुमि कऽ परमेश्‍वर लग अबैत और क्षमा पबैत।’ ” ");
INSERT INTO mai_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","तखन यीशु हुनका सभ केँ कहलथिन, “जँ अहाँ सभ एहि दृष्‍टान्‍तक अर्थ नहि बुझैत छिऐक तँ आरो दृष्‍टान्‍तक अर्थ कोना बुझबैक? ");
INSERT INTO mai_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","बाउग करऽ वला परमेश्‍वरक वचन केँ बाउग करैत अछि। ");
INSERT INTO mai_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","रस्‍ताक कात मे खसल बीया जकाँ ओ व्‍यक्‍ति अछि जकरा मे परमेश्‍वरक वचन बाउग कएल गेल छैक, और जखने ओ वचन सुनैत अछि तखने शैतान आबि कऽ ओकरा मे सँ बाउग कएल गेल वचन निकालि कऽ लऽ जाइत छैक। ");
INSERT INTO mai_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","तहिना दोसर आदमी ओहि बीया जकाँ अछि जे पथराह जमीन पर बाउग कएल गेल अछि। ई सभ परमेश्‍वरक वचन सुनि कऽ अपार आनन्‍दक संग तुरत ओकरा स्‍वीकार करैत अछि, ");
INSERT INTO mai_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","मुदा ओ वचन ओकरा मे जड़ि नहि पकड़ैत छैक और तेँ कनेके काल तक स्‍थिर रहैत अछि। जखन वचनक कारणेँ ओकरा कष्‍ट और अत्‍याचार सहबाक स्‍थिति अबैत छैक तखन ओ सभ तुरत विश्‍वास केँ छोड़ि दैत अछि। ");
INSERT INTO mai_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","फेर दोसर आदमी ओहि बीया जकाँ अछि जे काँट-कुशक बीच खसल। ई सभ वचन तँ सुनैत अछि ");
INSERT INTO mai_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","मुदा एहि संसारक चिन्‍ता, धनक मोह-माया आ आरो चीजक लालसा हृदय मे आबि कऽ वचन केँ दबा दैत छैक और ओ वचन ओकरा जीवन मे कोनो फल नहि दैत अछि। ");
INSERT INTO mai_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","नीक जमीन मे बाउग कयल गेल बीया जकाँ ओ सभ अछि जे वचन केँ सुनि कऽ ओकरा स्‍वीकार करैत अछि और फड़ि-फुला कऽ फसिल दैत अछि—केओ तीस गुना, केओ साठि गुना, केओ सय गुना।” ");
INSERT INTO mai_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","यीशु हुनका सभ केँ पुछलथिन जे, “की केओ डिबिया लेसि कऽ बासन सँ झँपैत अथवा चौकीक नीचाँ रखैत अछि? डिबिया तँ की लाबनि पर नहि रखैत अछि? ");
INSERT INTO mai_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","जँ किछु झाँपल अछि तँ एहि लेल जे उघारल जाय। जँ कोनो बात गुप्‍त अछि तँ एहि लेल जे एक दिन प्रगट कयल जाय। ");
INSERT INTO mai_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","जे सुनि सकैत अछि से सुनए!” ");
INSERT INTO mai_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","तखन ओ हुनका सभ केँ फेर कहलथिन, “जे बात सुनैत छी तकरा पर ध्‍यान दिअ! जाहि नाप सँ अहाँ देब, ओही नाप सँ अहाँ केँ देल जायत, और ओहि सँ बेसिओ। ");
INSERT INTO mai_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","किएक तँ जकरा छैक, तकरा आरो देल जयतैक और जकरा नहि छैक, तकरा सँ जेहो छैक सेहो लऽ लेल जयतैक।” ");
INSERT INTO mai_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","तखन ओ इहो कहलथिन, “परमेश्‍वरक राज्‍य एना छैक—एक आदमी खेत मे बीया बाउग कऽ कऽ ");
INSERT INTO mai_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","अपन दिन-चर्या मे लागि जाइत अछि। ओ बीया अँकुरित होइत छैक और बढ़ैत छैक, ओना तँ ओ आदमी ई नहि बुझैत अछि जे कोना ई सभ होइत छैक। ");
INSERT INTO mai_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","भूमि अपने सँ फल लबैत छैक—पहिने अँकुर, तखन बालि, और अन्‍त मे बालि मे पाकल दाना। ");
INSERT INTO mai_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","जखन अन्‍न पाकि जाइत छैक तखन ओ आदमी तुरत हाँसू चलबैत अछि किएक तँ कटबाक समय आबि गेल छैक।” ");
INSERT INTO mai_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","तखन यीशु कहलथिन, “परमेश्‍वरक राज्‍यक तुलना कोन वस्‍तु सँ कयल जाय? कोन दृष्‍टान्‍त द्वारा ओकर वर्णन कयल जाय? ");
INSERT INTO mai_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ओ सरिसोक दाना जकाँ अछि। बाउग होमऽ वला बीया सभ मे सरिसोक दाना सभ सँ छोट होइत अछि। ");
INSERT INTO mai_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","मुदा जखन ओ बाउग होइत अछि और बढ़ैत अछि तखन सभ साग-पात सँ पैघ भऽ जाइत अछि। ओकर ठाढ़ि एतेक पैघ भऽ जाइत छैक जे ओकर छाँह मे आकाशक चिड़ै सभ सेहो अपन वास स्‍थान बना सकैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","एहन आओर बहुत दृष्‍टान्‍त सभक द्वारा यीशु लोक सभ केँ परमेश्‍वरक वचन सुनौलथिन। ");
INSERT INTO mai_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","जहिना लोक केँ बुझऽ मे आबि सकल तहिना शिक्षा देलथिन। बिनु दृष्‍टान्‍त देने ओ ओकरा सभ केँ कोनो बात नहि कहैत छलथिन। मुदा जखन अपन शिष्‍य सभक संग असगरे रहैत छलाह तखन ओ हुनका सभ केँ सभ बातक अर्थ बुझा दैत छलथिन। ");
INSERT INTO mai_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ओहि दिनक साँझ मे यीशु अपन शिष्‍य सभ केँ कहलथिन, “चलू! झीलक ओहि पार चलू!” ");
INSERT INTO mai_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","शिष्‍य सभ भीड़ केँ छोड़ि, जाहि नाव मे ओ बैसल छलाह ओहि नाव मे हुनका अपना संग लऽ कऽ चललाह। हुनका सभक संग आरो नाव सभ सेहो छल। ");
INSERT INTO mai_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","एकाएक बहुत जोर सँ अन्‍हड़-बिहारि आयल। झील मे बड़का लहरि उठऽ लागल और नाव सँ टकराय लागल। नाव पानि सँ भरऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","यीशु नावक पछिलका भाग मे गेड़ुआ लगा कऽ सुतल छलाह। शिष्‍य सभ हुनका उठबैत कहलथिन, “यौ गुरुजी! अपना सभ डुबि रहल छी, तकर अहाँ केँ कोनो चिन्‍ता नहि अछि की?!” ");
INSERT INTO mai_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ओ उठि कऽ अन्‍हड़ केँ डाँटि कऽ झील केँ कहलथिन, “शान्‍त भऽ जो! थम्‍हि जो!” अन्‍हड़-बिहारि रूकि गेल और सभ शान्‍त भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","तखन ओ शिष्‍य सभ केँ कहलथिन, “अहाँ सभ किएक एहन डेरबुक छी! की अहाँ सभ केँ एखनो तक विश्‍वास नहि होइत अछि?” ");
INSERT INTO mai_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ओ सभ अति भयभीत भऽ एक-दोसर केँ कहऽ लगलाह जे, “ई के छथि?! अन्‍हड़-बिहारि और लहरि केँ सेहो आज्ञा दैत छथिन तँ ओ सभ मानैत छनि!” ");
INSERT INTO mai_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","यीशु और हुनकर शिष्‍य सभ झीलक ओहि पार गिरासेनी सभक क्षेत्र मे पहुँचलाह। ");
INSERT INTO mai_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","नाव पर सँ उतरैत काल एक दुष्‍टात्‍मा लागल आदमी कबरिस्‍तान दिस सँ हुनका भेँट करऽ लेल अयलनि। ");
INSERT INTO mai_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ओ आदमी कबरिस्‍तान मे रहैत छल। केओ आब ओकरा जंजीरो लऽ कऽ बान्‍हि नहि सकैत छल। ");
INSERT INTO mai_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","कतेको बेर लोक ओकरा जंजीर सँ हाथ-पयर बान्‍हि देने रहैक मुदा ओ सभ जंजीर केँ तोड़ि देने रहय। ककरो एतेक शक्‍ति नहि छल जे ओकरा सम्‍हारि कऽ राखि सकय। ");
INSERT INTO mai_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","दिन-राति कबरिस्‍तान और पहाड़ मे ओ सदिखन चिचियाइत रहैत छल और पाथर सँ अपना देह केँ कटैत रहैत छल। ");
INSERT INTO mai_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","यीशु केँ दूर सँ देखि ओ दौड़ैत आयल और हुनका पयर पर खसि कऽ ");
INSERT INTO mai_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","जोर सँ चिचिया लागल जे, “यौ परम परमेश्‍वरक पुत्र यीशु! अपने केँ हमरा सँ कोन काज? अपने केँ परमेश्‍वरक सपत अछि—हमरा दुःख नहि दिअ।” ");
INSERT INTO mai_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ई बात ओ एहि द्वारे कहलक कि यीशु ओहि दुष्‍टात्‍मा केँ कहैत छलाह जे, “हे दुष्‍टात्‍मा! एहि आदमी मे सँ निकल!” ");
INSERT INTO mai_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","तखन यीशु ओकरा सँ पुछलथिन जे, “तोहर नाम की छह?” ओ कहलक जे, “हमर नाम अछि ‘सेना’, किएक तँ हम सभ बहुत गोटे छी।” ");
INSERT INTO mai_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","तखन ओ हुनका सँ विनती करऽ लागल जे, “हमरा सभ केँ एहि इलाका सँ बाहर नहि निकालू।” ");
INSERT INTO mai_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ओहीठाम लग मे पहाड़ पर सुगरक बड़का झुण्‍ड चरि रहल छल। ");
INSERT INTO mai_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","दुष्‍टात्‍मा सभ यीशु सँ विनती कयलकनि जे, “हमरा सभ केँ ओहि सुगर सभ मे पठा दिअ, ओकरा सभ मे हमरा सभ केँ पैसऽ दिअ।” ");
INSERT INTO mai_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","यीशु ओकरा सभ केँ अनुमति दऽ देलथिन। ओ सभ ओहि आदमी मे सँ निकलि आयल और सुगर सभ मे प्रवेश कऽ गेल। पूरा झुण्‍ड—लगभग दू हजार सुगर—बताह भऽ पहाड़ पर सँ धरफरा कऽ झील मे खसल और सभ पानि मे डुबि कऽ मरि गेल। ");
INSERT INTO mai_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","सुगर चराबऽ वला तुरत भागि एहि घटनाक बारे मे नगर आ देहातो मे सुनौलक। एहि घटना केँ देखऽ लेल बहुतो लोक आयल। ");
INSERT INTO mai_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","यीशु लग पहुँचि कऽ ओहि आदमी केँ जकरा मे दुष्‍टात्‍मा पहिने रहैत छलैक कपड़ा पहिरने आ स्‍वस्‍थ मोने यीशु लग बैसल देखलक। ई देखि लोक सभ भयभीत भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","जे सभ ई घटना देखने छल से सभ विस्‍तारपूर्बक लोक सभ केँ कहि देलक जे कोना दुष्‍टात्‍मा लागल आदमी नीक भेल और सुगर सभ केँ की भेलैक। ");
INSERT INTO mai_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","तखन लोक सभ यीशु सँ ओहि इलाका सँ चल जयबाक लेल विनती करऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","यीशु जखन नाव पर चढ़ऽ लगलाह तखन ओ आदमी जकरा मे पहिने दुष्‍टात्‍मा सभ रहैत छलैक से हुनका सँ विनती कयलकनि जे, “अपना संग हमरो चलऽ देल जाओ।” ");
INSERT INTO mai_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","मुदा यीशु ओकरा मना करैत कहलथिन, “तोँ अपना घर जाह, और प्रभु तोरा पर कतेक पैघ दया कयलथुन अछि से अपना आदमी सभ केँ सुनबहक।” ");
INSERT INTO mai_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ओ आदमी “दस नगर” क्षेत्र मे जा कऽ, यीशु ओकरा लेल जे-जतेक कयने रहथिन से सुनाबऽ लागल। जे सभ ई बात सुनलक से सभ बहुत आश्‍चर्य-चकित भेल। ");
INSERT INTO mai_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","यीशु नाव मे झीलक एहि पार अयलाह। हुनकर चारू कात बड़का भीड़ जमा भऽ गेल। जखन यीशु झीलक कात मे ठाढ़ छलाह, ");
INSERT INTO mai_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ओही समय मे सभाघरक याइरस नामक एक अधिकारी ओहिठाम अयलाह। यीशु केँ देखि कऽ हुनकर पयर पर खसैत ");
INSERT INTO mai_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","निवेदन कयलथिन जे, “हमर बेटी मरि रहल अछि। हमरा घर चलि कऽ ओकरा पर हाथ राखि कऽ ठीक कऽ देल जाओ, जाहि सँ ओ जीबय।” यीशु हुनका संग विदा भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","हुनका संग बड़का भीड़ चलल। चारू कात सँ लोक सभ यीशु केँ पिचऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","भीड़ मे एक स्‍त्री छलि जकरा बारह वर्ष सँ खून खसऽ वला बिमारी छलैक। ");
INSERT INTO mai_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ओ बहुतो वैद्य सँ इलाज कराबऽ मे बड्ड कष्‍ट सहल छलि और अपन सभ सम्‍पत्ति खर्च कऽ देने छलि। मुदा तैयो ओकरा कनेको गुण नहि कयलकैक। बल्‍कि ओकर अवस्‍था आओर अधलाहे होइत गेलैक। ");
INSERT INTO mai_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","यीशुक बारे मे ओ सुनने छलि। ओ हुनका पाछू आबि, हुनकर वस्‍त्रक कोर छुबि ");
INSERT INTO mai_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","मोन मे सोचलक जे, “जँ हम हुनकर वस्‍त्रो केँ छुबि लेब तँ हम ठीक भऽ जायब।” ");
INSERT INTO mai_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","हुनकर वस्‍त्र छुबिते ओकर खून बहनाइ बन्‍द भऽ गेलैक। ओकरा अपनो अनुभव भेलैक जे हम रोग सँ मुक्‍त भऽ गेल छी। ");
INSERT INTO mai_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","यीशु केँ सेहो तुरत अनुभव भेलनि जे हमरा मे सँ सामर्थ्‍य निकलि गेल अछि। ओ भीड़ दिस घूमि कऽ पुछलथिन जे, “हमरा वस्‍त्र केँ के छुलक?” ");
INSERT INTO mai_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","हुनकर शिष्‍य सभ हुनका कहलकनि जे, “अहाँ देखिते छी जे कतेक लोक अहाँ केँ दबा रहल अछि, तँ कोना पुछैत छी जे हमरा के छुलक?” ");
INSERT INTO mai_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","मुदा यीशु ई बुझबाक लेल जे ई के कयलक, चारू दिस अपन नजरि खिरौलनि। ");
INSERT INTO mai_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","तखन ओ स्‍त्री ई बुझि जे हमरा संग की भेल, डर सँ कँपैत आगू आयल आ यीशुक पयर पर खसैत हुनका सभ बात सत्‍य-सत्‍य कहि देलकनि। ");
INSERT INTO mai_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","यीशु ओकरा कहलथिन, “बेटी! तोहर विश्‍वास तोरा स्‍वस्‍थ कऽ देलकह। शान्‍तिपूर्बक जाह और अपन रोग सँ मुक्‍त रहह!” ");
INSERT INTO mai_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","यीशु ई बात कहिए रहल छलथिन कि अधिकारी याइरसक घर सँ किछु गोटे आबि कऽ याइरस केँ कहलकनि जे, “अहाँक बेटी मरि गेल। आब गुरुजी केँ आरो कष्‍ट देला सँ कोन लाभ?” ");
INSERT INTO mai_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","यीशु ई बात सुनि लेलथिन और सभाघरक अधिकारी केँ कहलथिन, “अहाँ डेराउ नहि! मात्र विश्‍वास राखू!” ");
INSERT INTO mai_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ओ अपना संग पत्रुस, याकूब और याकूबक भाय यूहन्‍ना केँ छोड़ि आरो ककरो नहि आबऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","सभाघरक अधिकारीक घर पहुँचि कऽ ओ लोक सभ केँ बहुत कनैत आ जोर सँ विलाप करैत देखलनि। ");
INSERT INTO mai_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","घर मे अबिते यीशु ओकरा सभ केँ कहलथिन, “अहाँ सभ हल्‍ला किएक करैत छी और कनैत किएक छी? बच्‍ची मरल नहि अछि—ओ सुतल अछि।” मुदा लोक सभ हुनका पर हँसऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","तखन यीशु सभ लोक केँ बाहर हटा कऽ बच्‍चीक माय-बाबू केँ और अपन शिष्‍य सभ केँ अपना संग लऽ कऽ ओहि घर मे गेलाह जाहिठाम ओ बच्‍ची छल। ");
INSERT INTO mai_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","यीशु ओकर हाथ पकड़ि ओकरा कहलथिन, “तलीथा कूम!” जकर अर्थ अछि, “हे बच्‍ची! हम तोरा कहैत छिऔक, तोँ उठ!” ");
INSERT INTO mai_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","बच्‍ची तुरत उठि गेल और बुलऽ लागल—ओ तँ बारह वर्षक छल। ओ सभ बहुत आश्‍चर्य-चकित भेलाह। ");
INSERT INTO mai_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","यीशु एहि घटना केँ केओ नहि बुझय ताहि लेल दृढ़तापूर्बक आदेश देलथिन, आ कहलथिन जे बच्‍ची केँ किछु खयबाक लेल देल जाय। ");
INSERT INTO mai_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","यीशु ओहिठाम सँ अपन गाम अयलाह। हुनकर शिष्‍यो सभ हुनका संग छलनि। ");
INSERT INTO mai_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","विश्राम-दिन अयला पर ओ सभाघर मे उपदेश देबऽ लगलाह। हुनकर शिक्षा सुनि कऽ सभाक लोक आश्‍चर्य-चकित भऽ गेल और कहऽ लागल जे, “अरे! एकरा ई सभ बात कतऽ सँ भेटि गेलैक? ई कोन ज्ञान अछि जे एकरा देल गेल छैक? ई एहन चमत्‍कार सभ कोना करैत अछि! ");
INSERT INTO mai_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","की ई लकड़ी मिस्‍तिरी नहि अछि? की ई मरियमक बेटा और याकूब, योसेस, यहूदा और सिमोनक भाय नहि अछि? की एकर बहिन सभ अपना सभक बीच नहि रहैत अछि?” ओ सभ यीशु सँ डाह करऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","यीशु ओकरा सभ केँ कहलथिन, “मात्र अपने गाम, कुटुम्‍ब-परिवार, आ अपने घर मे परमेश्‍वरक प्रवक्‍ताक अनादर होइत छैक।” ");
INSERT INTO mai_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ओ ओहिठाम कोनो चमत्‍कार नहि कऽ सकलाह, मात्र किछु रोगी पर हाथ राखि कऽ ओकरा सभ केँ स्‍वस्‍थ कयलथिन। ");
INSERT INTO mai_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","लोकक अविश्‍वास पर ओ चकित छलाह। यीशु उपदेश दैत गाम-गाम घुमऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ओ अपन बारहो शिष्‍य केँ बजा कऽ, हुनका सभ केँ दुष्‍टात्‍मा सभ केँ निकालबाक अधिकार दऽ कऽ, दू-दू गोटेक समूह मे बाहर पठौलथिन। ");
INSERT INTO mai_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ओ हुनका सभ केँ ई आज्ञा देलथिन जे, “बाटक लेल लाठी छोड़ि आरो किछु नहि लऽ जाउ—ने रोटी, ने झोरा और ने जेबी मे पैसा। ");
INSERT INTO mai_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","चप्‍पल पहिरि लिअ और एकेटा अंगा लिअ।” ");
INSERT INTO mai_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","तखन हुनका सभ केँ कहलथिन, “जाहि घर मे अहाँ सभ ठहरी, जाबत धरि ओहि गाम सँ विदा नहि होइ ताबत धरि ओही घर मे रूकू। ");
INSERT INTO mai_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","जतऽ कतौ लोक सभ अहाँ सभक स्‍वागत नहि करय और अहाँ सभ जे कहऽ चाहैत छी, से नहि सुनय, ताहि गाम सँ विदा होइत काल अपन पयरक गर्दा झाड़ि लेब। ई ओकरा सभक विरोधक गवाही रहत।” ");
INSERT INTO mai_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ओ सभ विदा भेलाह और लोकक बीच प्रचार करऽ लगलाह जे अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन करू। ");
INSERT INTO mai_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","बहुत लोक मे सँ दुष्‍टात्‍मा निकाललनि और बहुत रोगी पर तेल लगा कऽ ओकरा सभ केँ स्‍वस्‍थ कयलनि। ");
INSERT INTO mai_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","राजा हेरोद एहि घटना सभक विषय मे सुनलनि किएक तँ यीशुक यश खूब पसरि गेल छल। किछु लोक कहैत छल जे, “बपतिस्‍मा देबऽ वला यूहन्‍ना मुइल सभ मे सँ जिआओल गेल छथि, तेँ चमत्‍कार करबाक एहन सामर्थ्‍य हुनका मे क्रियाशील अछि।” ");
INSERT INTO mai_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","दोसर लोक सभ कहैत छल जे, “ओ तँ एलियाह छथि।” आरो सभ कहैत छल जे, “ओ प्राचीन कालक परमेश्‍वरक प्रवक्‍ता सभ मे सँ केओ छथि।” ");
INSERT INTO mai_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","मुदा हेरोद यीशुक बारे मे सुनि कऽ कहलनि जे, “ई अवश्‍य यूहन्‍ना अछि जकर मूड़ी हम कटबा देने छलिऐक—ओ फेर जीबि उठल अछि!” यूहन्‍ना हेरोद द्वारा कोना मरबाओल गेल छलाह से एहि प्रकारेँ अछि— ");
INSERT INTO mai_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","राजा हेरोद यूहन्‍ना केँ पकड़बा कऽ बन्‍हबौने आ जहल मे राखि देने छलथिन। ओ अपन स्‍त्री हेरोदियासक कारणेँ एना कयलनि। हेरोदियास, हेरोदक भाय फिलिपुसक स्‍त्री छलीह, मुदा हेरोद अपन भायक स्‍त्री केँ रखने छलाह, ");
INSERT INTO mai_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","और यूहन्‍ना हेरोद केँ कहने छलाह जे, “धर्म-नियमक अनुसार अपन भायक स्‍त्री केँ राखब उचित नहि।” ");
INSERT INTO mai_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","एहि कारणेँ हेरोदियास यूहन्‍ना सँ दुश्‍मनी रखने छलीह और हुनका मरबा देबऽ चाहैत छलीह। मुदा ओ ई काज नहि करबा सकलीह ");
INSERT INTO mai_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","किएक तँ राजा हेरोद यूहन्‍ना केँ धार्मिक और नीक व्‍यक्‍ति बुझि कऽ हुनकर डर मानैत छलथिन और तेँ जहल मे राखि कऽ सुरक्षित रखलथिन। जखन कखनो हुनकर बात सुनैत छलाह तखन ओ घबड़ा जाइत छलाह, मुदा तैयो हुनकर बात सुनब ओ बहुत पसन्‍द करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","तखन एक दिन हेरोदियास केँ मौका भेटिए गेलनि। राजा हेरोद अपन जन्‍म दिनक अवसर पर मन्‍त्री सभ, सेनापति सभ और गलील प्रदेशक प्रतिष्‍ठित व्‍यक्‍ति सभ केँ भोजक निमन्‍त्रण देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ओहि भोज मे हेरोदियासक बेटी भीतर आबि नचलनि जाहि सँ हेरोद और हुनकर आमन्‍त्रित लोक सभ बहुत प्रसन्‍न भेलाह। राजा लड़की केँ कहलथिन, “तोँ जे किछु चाहैत छह से हमरा सँ माँगह, हम तोरा देबह।” ");
INSERT INTO mai_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ओ लड़की केँ सपत खा कऽ वचन देलथिन जे, “जे किछु तोँ मँगबह से तोरा हम देबह, जँ तोँ हमर आधा राज्‍यो मँगबह तँ हम तोरा देबह।” ");
INSERT INTO mai_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","लड़की निकलि कऽ अपन माय सँ पुछलक जे, “कहू! हम की माँगू?” ओकर माय कहलथिन जे, “बपतिस्‍मा देबऽ वला यूहन्‍नाक मूड़ी माँग!” ");
INSERT INTO mai_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ओ तुरत भीतर राजा लग झटकारि कऽ आयल और हुनका अपन माँग सुनौलकनि, “हम चाहैत छी जे अहाँ हमरा बपतिस्‍मा देनिहार यूहन्‍नाक मूड़ी एखने थारी मे अनबा दिअ!” ");
INSERT INTO mai_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","राजा बहुत दुखी भेलाह। मुदा अपन सपतक कारणेँ और उपस्‍थित आमन्‍त्रित सभक कारणेँ ओ ओकर माँग अस्‍वीकार नहि करऽ चाहैत छलाह। ");
INSERT INTO mai_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ओ तुरत एकटा जल्‍लाद सिपाही केँ बजा कऽ आज्ञा दऽ कऽ पठौलथिन जे, “यूहन्‍नाक मूड़ी काटि कऽ आनि दैह।” सिपाही जहल मे जा कऽ यूहन्‍नाक मूड़ी काटि ");
INSERT INTO mai_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","थारी मे नेने आयल आ लड़की केँ देलक और लड़की अपन माय केँ देलकैक। ");
INSERT INTO mai_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","जखन यूहन्‍नाक शिष्‍य सभ ई सुनलनि तखन ओ सभ आबि हुनकर लास लऽ गेलनि और कबर मे राखि देलनि। ");
INSERT INTO mai_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","पठाओल गेल दूत सभ यीशु लग फिरि कऽ अयला पर, जे काज ओ सभ कयने छलाह और जे शिक्षा देने छलाह, से सभ बात यीशु केँ कहि सुनौलथिन। ");
INSERT INTO mai_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","हुनका सभ लग ततेक लोक अबैत-जाइत छल जे हुनका सभ केँ भोजनो करबाक फुरसति नहि भेटैत छलनि। तखन यीशु अपना शिष्‍य सभ केँ कहलथिन, “आउ! अपना सभ कोनो एकान्‍त स्‍थान मे जा कऽ भीड़ सँ अलग किछु आराम करी।” ");
INSERT INTO mai_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ओ सभ नाव मे बैसि कऽ एकान्‍त स्‍थानक लेल विदा भऽ गेलाह ");
INSERT INTO mai_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","मुदा बहुत लोक हुनका सभ केँ जाइत देखलकनि और चिन्‍हि गेलनि। लोक सभ, नगर-नगर सँ निकलि हुनका सभक पाछू झीलक कछेरे-कछेर दौड़ल आ हुनका सभ सँ पहिने ओतऽ पहुँचि गेल। ");
INSERT INTO mai_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","यीशु जखन नाव सँ उतरलाह आ लोकक बड़का भीड़ केँ जमा देखलनि तँ हुनका ओहि लोक सभ पर दया आबि गेलनि किएक तँ ओ सभ एहन भेँड़ी जकाँ छल जकर केओ चरबाह नहि होइक। यीशु ओकरा सभ केँ बहुत बात सिखाबऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","जखन साँझ पड़ऽ लागल तँ हुनकर शिष्‍य सभ हुनका लग आबि कहलथिन, “ई स्‍थान बस्‍ती सँ दूर अछि और साँझ पड़ऽ वला छैक। ");
INSERT INTO mai_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","लोक सभ केँ एखन जाय दिऔक जाहि सँ लगक गाम-बजार सँ अपना लेल किछु खयबाक वस्‍तु किनि सकत।” ");
INSERT INTO mai_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","मुदा यीशु हुनका सभ केँ कहलथिन, “अहीं सभ एकरा सभ केँ भोजन करबिऔक।” शिष्‍य सभ हुनका कहलथिन जे, “तकरा लेल तँ दू सय दिनार लगैत। की हम सभ ओतेक खर्च कऽ कऽ रोटी आनि कऽ एकरा सभ केँ खुअबिऔक?” ");
INSERT INTO mai_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","यीशु हुनका सभ केँ जबाब देलथिन जे, “अहाँ सभ जा कऽ देखू जे अहाँ सभ लग कयटा रोटी अछि।” ओ सभ देखि कऽ हुनका कहलथिन जे, “पाँचटा रोटी आ दूटा माछ।” ");
INSERT INTO mai_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","तखन यीशु सभ लोक केँ हरियर घास पर पाँति-पाँति मे बैसयबाक आज्ञा शिष्‍य सभ केँ देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","लोक सभ सय-सय आ पचास-पचासक पाँति मे बैसैत गेल। ");
INSERT INTO mai_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","यीशु ओहि पाँचटा रोटी और दूटा माछ केँ हाथ मे लऽ कऽ, स्‍वर्ग दिस तकैत परमेश्‍वर केँ धन्‍यवाद देलनि। ओ रोटी केँ तोड़ि-तोड़ि, लोक सभ मे परसबाक लेल शिष्‍य सभ केँ देलथिन। तखन ओहि दूटा माछो केँ हुनका सभ केँ लोक सभ मे परसबाक लेल देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","सभ केओ भरि इच्‍छा भोजन कयलक। ");
INSERT INTO mai_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","शिष्‍य सभ जखन रोटी आ माछक उबरल टुकड़ी सभ बिछलनि तँ बारह छिट्टा भेल। ");
INSERT INTO mai_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","भोजन करऽ वला मे मात्र पुरुषक संख्‍या पाँच हजार छल। ");
INSERT INTO mai_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","तकरबाद यीशु अपना शिष्‍य सभ केँ तुरत नाव पर चढ़ि कऽ अपना सँ पहिने झीलक ओहि पार बेतसैदा नगर चल जयबाक लेल आज्ञा देलथिन आ अपने ओतहि रहि कऽ भीड़क लोक सभ केँ विदा करऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ओकरा सभ केँ विदा करा कऽ ओ प्रार्थना करऽ लेल पहाड़ पर चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","साँझ बितला पर नाव झीलक बीच मे छलैक और यीशु किनार पर असगरे छलाह। ");
INSERT INTO mai_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ओ देखलनि जे शिष्‍य सभ केँ नाव खेबऽ मे बहुत परिश्रम भऽ रहल छनि, किएक तँ हवा विपरीत दिस सँ बहि रहल छलैक। लगभग रातिक चारिम पहर मे ओ झीलक पानि पर चलैत हुनका सभक दिस गेलाह। यीशु हुनका सभ सँ आगू बढ़ि जाय चाहैत छलाह। ");
INSERT INTO mai_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","शिष्‍य सभ हुनका पानि पर चलैत देखि, हुनका भूत बुझि चिचियाय लगलाह। ");
INSERT INTO mai_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","सभ गोटे हुनका देखि भयभीत भऽ गेलाह। मुदा यीशु हुनका सभ केँ तुरत कहलथिन, “साहस राखू! हम छी! नहि डेराउ!” ");
INSERT INTO mai_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ओ हुनका सभक संग नाव मे चढ़ि गेलाह और हुनका चढ़िते अन्‍हड़-बिहारि थम्‍हि गेल। शिष्‍य सभ एकदम अवाक भऽ गेलाह ");
INSERT INTO mai_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","किएक तँ ओ सभ रोटी वला घटना सेहो नहि बुझि सकल छलाह—हुनका सभक बुद्धि बन्‍द छलनि। ");
INSERT INTO mai_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ओ सभ झील केँ पार कऽ कऽ गन्‍नेसरत क्षेत्र मे पहुँचलाह और नाव केँ किनार लगा देलनि। ");
INSERT INTO mai_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","जखन यीशु नाव पर सँ उतरलाह तखन लोक सभ हुनका चिन्‍हि लेलकनि। ");
INSERT INTO mai_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","लोक सभ पूरा क्षेत्र मे जा कऽ रोगी सभ केँ खाट पर लादि जाहि ठाम लोक कहैत छल जे यीशु छथि ओहि ठाम रोगी सभ केँ पहुँचाबऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","जाहि गाम, शहर, अथवा बस्‍ती मे ओ जाइत छलाह ताहि ठामक लोक रोगी सभ केँ हाट-बजार मे सुता दैत छल। ओ सभ यीशु सँ प्रार्थना करैत छल जे, “अहाँ अपन कपड़ाक खूटो रोगी सभ केँ छुबऽ दिऔक।” जे सभ हुनकर कपड़ा छुलक से सभ स्‍वस्‍थ भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","किछु फरिसी आ धर्मशिक्षक लोकनि जे यरूशलेम सँ आयल छलाह यीशु सँ भेँट करऽ लेल अयलाह। ");
INSERT INTO mai_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ओ लोकनि देखलनि जे हुनकर किछु शिष्‍य सभ बिना हाथ धोने भोजन करैत छथि, जे हुनका लोकनिक अनुसार धर्म-विरोध वला बात छल। ");
INSERT INTO mai_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","सभ यहूदी, ओहू मे खास कऽ फरिसी लोकनि, पुरखा सँ आबि रहल चलन केँ पालन करैत छथि—जाबत तक ओ लोकनि अपन हाथ केँ रीतिक अनुसार धोइत नहि छथि ताबत तक भोजन नहि करैत छथि। ");
INSERT INTO mai_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","जखन बजार सँ अबैत छथि तँ रीतिक अनुसार बिना स्‍नान कयने किछु नहि खाइत छथि। ओहिना पुरखाक आओर बहुत चलन केँ मानैत छथि, जेना बाटी, लोटा और कठौत केँ विशेष प्रकार सँ शुद्ध कयनाइ। ");
INSERT INTO mai_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","तँ फरिसी और धर्मशिक्षक लोकनि यीशु सँ पुछलनि जे, “अहाँक शिष्‍य सभ पुरखाक चलन सभ किएक नहि मानैत अछि? ओ सभ अशुद्ध हाथ सँ किएक भोजन करैत अछि?” ");
INSERT INTO mai_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ओ उत्तर देलथिन जे, “हे पाखण्‍डी सभ! यशायाह अहाँ सभक बारे मे एकदम ठीक भविष्‍यवाणी कयलनि, जेना धर्मशास्‍त्र मे लिखल अछि जे, ‘ई सभ मुँह सँ हमर आदर करैत अछि, मुदा एकर सभक हृदय हमरा सँ दूर छैक। ");
INSERT INTO mai_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ई सभ बेकार हमर उपासना करैत अछि। ई सभ जे शिक्षा दैत अछि, से मात्र मनुष्‍यक बनाओल नियम सभ अछि।’ ");
INSERT INTO mai_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","अहाँ लोकनि परमेश्‍वरक आज्ञा केँ अवहेलना करैत छी लेकिन मनुष्‍यक बनाओल रीति-रिवाज केँ पकड़ने रहैत छी।” ");
INSERT INTO mai_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","यीशु आगाँ कहऽ लगलाह जे, “अहाँ सभ अपन चलन चलयबाक लेल कतेक चलाकी सँ परमेश्‍वरक आज्ञा सभक उल्‍लंघन करैत छी! ");
INSERT INTO mai_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","मूसा तँ कहने छलाह जे, ‘अपन माय-बाबूक आदर करह,’ और ‘जे केओ अपन माय-बाबूक निन्‍दा करय तकरा मृत्‍युदण्‍ड देल जाय।’ ");
INSERT INTO mai_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","मुदा अहाँ सभ कहैत छी जे, जँ केओ अपना बाबू वा माय सँ कहैत अछि, ‘जे किछु अहाँ सभ हमरा सँ सहायता प्राप्‍त करितहुँ से आब “कुर्बान” अछि’, अर्थात्‌, परमेश्‍वर केँ अर्पित, ");
INSERT INTO mai_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","आ जँ ओ किछु करहो चाहैत अछि तँ अहाँ सभ ओकरा अपन माय-बाबूक लेल कोनो कर्तव्‍य पूरा नहि करऽ दैत छिऐक। ");
INSERT INTO mai_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","जे चलन अहाँ केँ पुरखा सँ भेटल अछि, तकरा द्वारा अहाँ परमेश्‍वरक वचन केँ निरर्थक ठहरबैत छी। और एतबे नहि—आरो एहन-एहन बहुत काज करैत छी।” ");
INSERT INTO mai_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","तखन यीशु भीड़क लोक केँ अपना लग बजा कऽ कहलथिन, “अहाँ सभ गोटे हमर बात सुनू और बुझू! ");
INSERT INTO mai_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","कोनो एहन वस्‍तु नहि होइत छैक जे बाहर सँ मनुष्‍य मे प्रवेश कऽ कऽ ओकरा अशुद्ध बना सकय, बल्‍कि जे मनुष्‍यक मोनक भीतर सँ बहराइत छैक से ओकरा अशुद्ध बनबैत छैक। ");
INSERT INTO mai_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","जे सुनि सकैत अछि से सुनए!” ");
INSERT INTO mai_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","बाद मे भीड़ केँ छोड़ि यीशु घर गेलाह। हुनकर शिष्‍य सभ एहि उदाहरणक बारे मे हुनका सँ पुछलथिन। ");
INSERT INTO mai_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","यीशु हुनका सभ केँ कहलथिन, “की, अहूँ सभ नहि बुझैत छी? की ई बुझऽ मे नहि अबैत अछि जे, जे किछु खाइत काल मनुष्‍य मे प्रवेश करैत अछि से ओकरा अशुद्ध नहि कऽ सकैत अछि? ");
INSERT INTO mai_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","किएक तँ ओ मोन मे नहि प्रवेश करैत अछि, ओ पेट मे जाइत अछि और फेर देह सँ बहरा जाइत अछि।” (ओ ई कहि कऽ सभ भोजन-वस्‍तु केँ शुद्ध ठहरा देलथिन।) ");
INSERT INTO mai_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ओ आगाँ कहऽ लगलाह, “जे मनुष्‍य मे सँ निकलैत छैक से ओकरा अशुद्ध करैत छैक। ");
INSERT INTO mai_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","किएक तँ मनुष्‍यक भीतर मे सँ, अर्थात्‌ हृदय मे सँ सभ प्रकारक अधलाह बात सभ निकलैत छैक, जेना गलत विचार सभ, गलत शारीरिक सम्‍बन्‍ध, चोरी, हत्‍या, परस्‍त्रीगमन, ");
INSERT INTO mai_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","लोभ, दुष्‍कर्म, धोखा, निर्लज्‍जता, ईर्ष्‍या, निन्‍दा, घमण्‍ड, और मूर्खता। ");
INSERT INTO mai_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ई सभ बात मनुष्‍यक भीतर मे सँ निकलैत अछि और ओकरा अशुद्ध करैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ओतऽ सँ यीशु सूर आ सीदोन नगरक इलाका मे चल गेलाह। एकटा घर मे जा कऽ ओहिठाम डेरा रखलनि। ओ चाहैत छलाह जे लोक ई नहि बुझए जे ओ कतऽ छथि, लेकिन लोक जल्‍दी सँ बुझि गेलनि जे ओ एहि घर मे छथि। ");
INSERT INTO mai_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","एकटा स्‍त्री जकर छोट बेटी दुष्‍टात्‍मा सँ ग्रसित छल हुनका विषय मे सुनिते हुनका ओहिठाम जा कऽ हुनका समक्ष मे खसल। ");
INSERT INTO mai_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ओ स्‍त्री यहूदी जातिक नहि, यूनानी छल। ओकर जन्‍म सीरिया प्रदेशक फीनिकी क्षेत्र मे भेल छलैक। ओ यीशु सँ विनती कयलकनि जे, हमर बेटी मे सँ दुष्‍टात्‍मा केँ निकालू। ");
INSERT INTO mai_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","यीशु ओकरा कहलथिन, “सभ सँ पहिने बच्‍चे सभ केँ इच्‍छापूर्बक खाय दिऔक, किएक तँ बच्‍चा सभक लेल जे रोटी अछि तकरा कुकुरक आगाँ फेकि देब से ठीक बात नहि।” ");
INSERT INTO mai_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ओ लेकिन उत्तर देलकनि जे, “ठीके कहैत छी, प्रभु, मुदा कुकुरो सभ तँ बच्‍चा सभक टेबुल सँ खसल चुर-चार खाइते अछि।” ");
INSERT INTO mai_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","यीशु ओकरा कहलथिन, “एहन उत्तर दैत छह तँ जा सकैत छह!—दुष्‍टात्‍मा तोरा बेटी मे सँ निकलि गेल छह!” ");
INSERT INTO mai_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ओ घर जा कऽ अपना बेटी केँ ओछायन पर पड़ल देखलक। दुष्‍टात्‍मा ओकरा मे सँ निकलि गेल छल। ");
INSERT INTO mai_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","तकरबाद यीशु सूर क्षेत्र सँ घूरला पर सीदोन नगर और “दस नगर” क्षेत्र दऽ कऽ गलील झील तक अयलाह। ");
INSERT INTO mai_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","लोक सभ कोनो एक आदमी केँ यीशु लग अनलनि जे बहीर छल और ठीक सँ बाजिओ नहि सकैत छल। ओ सभ यीशु सँ प्रार्थना कयलनि जे ओकरा पर हाथ राखि कऽ ओकरा नीक कऽ देल जाओ। ");
INSERT INTO mai_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","यीशु ओकरा भीड़ सँ अलग लऽ कऽ ओकर कान मे अपन आङुर राखि देलथिन और अपन थूक ओकरा जीह पर लगा देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","स्‍वर्ग दिस ताकि आ जोर सँ साँस लैत ओहि आदमी केँ कहलथिन, “एफफाता,” जकर अर्थ छैक, “खुजि जो!” ");
INSERT INTO mai_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ओकर कान तुरत खुजि गेलैक। ओकर जीह सेहो ठीक भऽ गेलैक और स्‍पष्‍ट बाजऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","यीशु एहि घटनाक बारे मे लोक सभ केँ कहबाक लेल ओकरा मना कयलथिन, लेकिन जतेक बेसी ओ मना करैत छलाह, ततेक बेसी एहि घटनाक प्रचार भेलैक। ");
INSERT INTO mai_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","सभ लोक एकदम आश्‍चर्य-चकित भऽ कऽ कहऽ लागल जे, “देखू! सभ काज ओ नीक जकाँ करैत छथि। बहीरो सभ केँ सुनबाक और बौको सभ केँ बजबाक शक्‍ति दैत छथिन!” ");
INSERT INTO mai_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ओहि काल मे फेर यीशु लग बहुत लोक सभ जमा भेल। ओकरा सभ केँ खयबाक लेल किछु नहि छलैक। तेँ यीशु अपना शिष्‍य सभ केँ बजा कऽ कहलथिन जे, ");
INSERT INTO mai_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“एहि लोक सभ पर हमरा दया अबैत अछि, किएक तँ ई सभ तीन दिन सँ हमरा संग अछि आ संग मे खयबाक लेल किछु नहि छैक। ");
INSERT INTO mai_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","हम एकरा सभ केँ भूखल विदा कऽ देबैक तँ रस्‍ता मे ई सभ मुर्छित भऽ जायत किएक तँ एहि मे सँ किछु लोक बहुत दूरो सँ आयल अछि।” ");
INSERT INTO mai_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","शिष्‍य सभ यीशु केँ कहलथिन, “एहन निर्जन क्षेत्र मे एतेक लोकक भोजन कतऽ सँ भेटत?” ");
INSERT INTO mai_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","यीशु हुनका सभ सँ पुछलथिन जे, “अहाँ सभ लग कयटा रोटी अछि?” शिष्‍य सभ उत्तर देलथिन जे, “सातटा।” ");
INSERT INTO mai_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","यीशु लोक सभ केँ जमीन पर बैसबाक लेल आदेश देलनि, और ओ सातो रोटी लऽ कऽ परमेश्‍वर केँ धन्‍यवाद देलथिन। रोटी सभ केँ तोड़ि-तोड़ि कऽ लोक सभ मे बाँटऽ लेल शिष्‍य सभ केँ देलथिन और ओ सभ रोटी बाँटि देलनि। ");
INSERT INTO mai_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","किछु छोटका माछो रहैक। यीशु माछोक लेल धन्‍यवाद दऽ कऽ लोक सभ मे बाँटि देबऽ लेल शिष्‍य सभ केँ देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","सभ केओ भरि पेट भोजन कयलक। भोजनक बाद शिष्‍य सभ उबरल टुकड़ा सभ सात टोकरी मे भरि कऽ जमा कयलनि। ");
INSERT INTO mai_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ओहि मे भोजन करऽ वलाक संख्‍या करीब चारि हजार लोक छल। ");
INSERT INTO mai_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ओकरा सभ केँ विदा कऽ कऽ यीशु तुरत शिष्‍य सभक संग नाव मे चढ़ि दलमनूथा क्षेत्र चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","हुनका सभ केँ पहुँचला पर फरिसी सभ आबि कऽ यीशु सँ वाद-विवाद करऽ लगलाह, आ हुनका जाँच करबाक लेल स्‍वर्ग सँ एकटा चमत्‍कार वला चिन्‍ह मँगलथिन। ");
INSERT INTO mai_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","यीशु भीतर सँ कुहरि कऽ कहलनि जे, “एहि पीढ़ीक लोक एकटा चिन्‍ह किएक मँगैत अछि! हम अहाँ सभ केँ सत्‍ये कहैत छी जे एकरा सभ केँ कोनो चिन्‍ह नहि देखाओल जयतैक!” ");
INSERT INTO mai_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","हुनका सभ केँ छोड़ि कऽ यीशु फेर नाव मे चढ़ि कऽ झीलक ओहि पार चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","शिष्‍य सभ रोटी अननाइ बिसरि गेल छलाह; एकेटा रोटी नाव पर संग मे छलनि। ");
INSERT INTO mai_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","यीशु हुनका सभ केँ चेतबैत कहलथिन, “फरिसी सभक और हेरोदक रोटी फुलाबऽ वला खमीर सँ सावधान रहू!” ");
INSERT INTO mai_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ओ सभ आपस मे विचार करैत बजलाह जे, “अपना सभ रोटी आनब बिसरि गेलहुँ, एही कारणेँ ओ ई बात कहि रहल छथि।” ");
INSERT INTO mai_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","यीशु बुझि गेलथिन जे ओ सभ एना एक-दोसर सँ बात-चीत करैत छथि और हुनका सभ सँ पुछलथिन जे, “अहाँ सभ आपस मे एहि पर बात किएक कऽ रहल छी जे अपना सभ लग रोटी नहि अछि? की एखनो तक नहि देखैत छी? एखनो तक नहि बुझैत छी? बुद्धि मन्‍द भऽ गेल अछि की? ");
INSERT INTO mai_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","की आँखि रहितो नहि देखैत छी, आ कान रहितो नहि सुनैत छी? की मोन नहि अछि?— ");
INSERT INTO mai_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","जखन ओ पाँचटा रोटी हम पाँच हजार लोकक लेल तोड़लहुँ तँ उबरल रोटीक टुकड़ीक कतेक छिट्टा भेल?” ओ सभ जबाब देलथिन जे, “बारहटा।” ");
INSERT INTO mai_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“और जखन ओहि सातटा रोटी सँ हम चारि हजार आदमी केँ खुऔलहुँ तँ रोटीक टुकड़ी कतेक ढाकी बिछलहुँ?” ओ सभ उत्तर देलथिन जे, “सातटा।” ");
INSERT INTO mai_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","तखन ओ हुनका सभ केँ कहलथिन, “की एखनो तक नहि बुझैत छी?” ");
INSERT INTO mai_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ओ सभ बेतसैदा नगर अयलाह। लोक सभ यीशु लग एकटा आन्‍हर आदमी केँ आनि कऽ हुनका सँ विनती कयलकनि जे, एकरा छुबि दिऔक। ");
INSERT INTO mai_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","यीशु ओहि आन्‍हर आदमी केँ हाथ पकड़ि कऽ नगर सँ बाहर लऽ गेलथिन। ओकरा आँखि पर थूक लगा देलथिन, और ओकरा पर हाथ राखि कऽ पुछलथिन जे, “की, किछु देखि रहल छह?” ");
INSERT INTO mai_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ओ आँखि उठा कऽ जबाब देलकनि जे, “हँ! मनुष्‍य सभ केँ देखैत छी—गाछ जकाँ लगैत छैक लेकिन चलि रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","तखन यीशु ओकरा आँखि पर फेर हाथ रखलथिन। ओकरा आँखि मे तुरत पूरा इजोत आबि गेलैक और ओ सभ किछु साफ-साफ देखऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","यीशु ओकरा अपन घर पठा देलथिन और ई आदेश देलथिन जे, “शहर मे नहि जाह।” ");
INSERT INTO mai_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","यीशु और हुनकर शिष्‍य सभ कैसरिया-फिलिप्‍पीक लग-पासक गाम सभ मे गेलाह। चलिते-चलिते यीशु हुनका सभ सँ पुछलनि जे, “हम के छी, ताहि सम्‍बन्‍ध मे लोक की कहि रहल अछि?” ");
INSERT INTO mai_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ओ सभ हुनका जबाब देलथिन जे, “केओ-केओ कहैत अछि जे अहाँ बपतिस्‍मा देनिहार यूहन्‍ना छी। केओ कहैत अछि जे एलियाह छी, और किछु लोक कहैत अछि जे परमेश्‍वरक प्रवक्‍ता सभ मे सँ एक छी।” ");
INSERT INTO mai_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","तखन यीशु हुनका सभ केँ पुछलनि जे, “और अहाँ सभ? अहाँ सभ की कहैत छी जे हम के छी?” पत्रुस उत्तर देलथिन जे, “अहाँ उद्धारकर्ता-मसीह छी।” ");
INSERT INTO mai_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","यीशु हुनका सभ केँ दृढ़तापूर्बक आदेश देलथिन जे हमरा बारे मे ई बात ककरो नहि कहिऔक। ");
INSERT INTO mai_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","तखन यीशु अपना शिष्‍य सभ केँ सिखाबऽ लगलथिन जे, “मनुष्‍य-पुत्र केँ बहुत दुःख भोगऽ पड़तैक। ई आवश्‍यक अछि जे बूढ़-प्रतिष्‍ठित, मुख्‍यपुरोहित और धर्मशिक्षक सभ द्वारा तुच्‍छ ठहराओल जाय, जान सँ मारल जाय, आ तीन दिनक बाद ओ फेर जीबि उठय।” ");
INSERT INTO mai_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ई बात एकदम स्‍पष्‍ट कहलथिन। एहि पर पत्रुस हुनका कात मे लऽ जा कऽ डाँटऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","मुदा यीशु शिष्‍य सभक दिस घूमि कऽ पत्रुस केँ डाँटि कऽ कहलथिन, “है शैतान! तोँ हमरा सोझाँ सँ दूर होअह! तोँ परमेश्‍वरक विचार नहि, बल्‍कि मनुष्‍यक विचार मोन मे रखैत छह।” ");
INSERT INTO mai_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","तखन यीशु लोक सभ केँ और शिष्‍य सभ केँ अपना लग बजौलनि और कहलथिन, “जँ केओ हमर शिष्‍य बनऽ चाहैत अछि तँ ओ अपना केँ त्‍यागि, हमरा कारणेँ दुःख उठयबाक आ प्राणो देबाक लेल तैयार रहओ, और हमरा पाछाँ चलओ। ");
INSERT INTO mai_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","कारण, जे केओ अपन जीवन बचाबऽ चाहैत अछि से ओकरा गमाओत। मुदा जे केओ हमरा लेल और शुभ समाचारक लेल अपन जीवन गमबैत अछि से ओकरा बचाओत। ");
INSERT INTO mai_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","जँ कोनो मनुष्‍य सम्‍पूर्ण संसार केँ पाबि लय और अपन आत्‍मा गमा लय तँ ओहि सँ ओकरा की लाभ भेलैक? ");
INSERT INTO mai_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","अथवा मनुष्‍य अपन आत्‍माक बदला मे की दऽ सकत? ");
INSERT INTO mai_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","जँ केओ एहि पापी और विश्‍वासघाती युग मे हमरा और हमर शिक्षा सँ लजाइत अछि तँ ओकरो सँ मनुष्‍य-पुत्र लजायत जखन पिताक महिमा मे स्‍वर्गदूत सभक संग आओत।” ");
INSERT INTO mai_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","यीशु इहो कहलथिन, “हम अहाँ सभ केँ सत्‍य कहैत छी जे एतऽ किछु एहनो लोक सभ ठाढ़ अछि जे जाबत तक परमेश्‍वरक राज्‍य शक्‍तिक संग अबैत नहि देखि लेत ताबत तक नहि मरत।” ");
INSERT INTO mai_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","छओ दिनक बाद यीशु अपना संग पत्रुस, याकूब और यूहन्‍ना केँ लेलनि और एक ऊँच पहाड़ पर एकान्‍त मे गेलाह। हुनका सभक सामने मे यीशुक रूप बदलि गेलनि। ");
INSERT INTO mai_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","हुनकर वस्‍त्र एकदम उज्‍जर भऽ कऽ चमकऽ लगलनि। हुनकर वस्‍त्र एतेक उज्‍जर भऽ गेलनि जे पृथ्‍वीक कोनो धोबिओ ओतेक उज्‍जर नहि कऽ सकैत। ");
INSERT INTO mai_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","तखन शिष्‍य सभक समक्ष मे एलियाह और मूसा प्रगट भेलाह जे यीशु सँ बात करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ई देखि पत्रुस बाजऽ लगलाह जे, “यौ गुरुजी! हमरा सभक लेल ई कतेक नीक बात अछि जे हम सभ एतऽ छी। हम सभ तीनटा मण्‍डप बनायब, एकटा अहाँक लेल, एकटा मूसाक लेल और एकटा एलियाहक लेल।” ");
INSERT INTO mai_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","पत्रुस केँ बुझऽ मे एकदम नहि अयलनि जे हम की बाजू, की नहि बाजू, किएक तँ ओ सभ केओ अति भयभीत भऽ गेल छलाह। ");
INSERT INTO mai_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","तखन एकटा मेघ आबि कऽ हुनका सभ केँ झाँपि देलकनि और मेघ मे सँ आवाज आयल जे, “ई हमर प्रिय पुत्र छथि—हिनका बात पर ध्‍यान दिअ!” ");
INSERT INTO mai_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","एकाएक शिष्‍य सभ चारू कात ताकऽ लगलाह तँ ओ सभ अपना संग यीशु केँ छोड़ि आरो किनको नहि देखलनि। ");
INSERT INTO mai_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","पहाड़ पर सँ उतरैत काल यीशु हुनका सभ केँ आदेश देलथिन जे, “जाबत तक मनुष्‍य-पुत्र मृत्‍यु सँ फेर जीबि कऽ नहि उठत ताबत तक जे बात अहाँ सभ देखलहुँ से ककरो नहि कहिऔक।” ");
INSERT INTO mai_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ई आदेश ओ सभ मानलनि मुदा आपस मे गप्‍प करैत छलाह जे “मनुष्‍य-पुत्र मृत्‍यु सँ फेर जीबि कऽ उठत”, एहि बातक अर्थ की छलनि। ");
INSERT INTO mai_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","तखन ओ सभ यीशु सँ पुछलथिन जे, “धर्मशिक्षक लोकनि किएक कहैत छथि जे पहिने एलियाह केँ अयनाइ आवश्‍यक अछि?” ");
INSERT INTO mai_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","यीशु उत्तर देलथिन जे, “ई बात एकदम ठीक अछि—पहिने एलियाह अबैत छथि आ सभ चीजक सुधार करैत छथि। लेकिन मनुष्‍य-पुत्रक बारे मे ई किएक लिखल गेल अछि जे हुनका बहुत दुःख उठाबऽ पड़तनि और तुच्‍छ बुझल जयताह? ");
INSERT INTO mai_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","हम अहाँ सभ केँ कहैत छी जे एलियाह आबिओ गेलाह आ जहिना हुनका बारे मे धर्मशास्‍त्र मे लिखल अछि तहिना लोक सभ केँ जे मोन भेलैक, से हुनका संग कयलकनि।” ");
INSERT INTO mai_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ओ सभ जखन आरो शिष्‍य सभ लग पहुँचलाह तखन देखलनि जे हुनका सभक चारू कात बड़का भीड़ अछि और हुनका सभ सँ धर्मशिक्षक सभ वाद-विवाद कऽ रहल छनि। ");
INSERT INTO mai_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","यीशु केँ देखिते सभ लोक चकित भऽ कऽ हुनका लग दौड़ल और प्रणाम करऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ओ हुनका सभ सँ पुछलथिन जे, “हुनका सभ सँ की वाद-विवाद कऽ रहल छी?” ");
INSERT INTO mai_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","भीड़ मे सँ एक आदमी हुनका जबाब देलकनि जे, “गुरुजी, हम अपने लग अपना बेटा केँ अनने छी जकरा मे एक दुष्‍टात्‍मा पैसि गेल छैक जे एकरा बौक बना देने छैक। ");
INSERT INTO mai_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","जखने ओ एकरा लागि जाइत छैक तँ एकरा तोड़ि-मड़ोड़ि कऽ खसा दैत छैक, और मुँह सँ गाउज बहराय लगैत छैक। दाँत पिसऽ लगैत अछि और देह टाँट भऽ जाइत छैक। एहि दुष्‍टात्‍मा केँ निकालबाक लेल हम अपनेक शिष्‍य सभ सँ विनती कयलहुँ लेकिन ओ सभ नहि निकालि सकलाह।” ");
INSERT INTO mai_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","यीशु ओकरा सभ केँ उत्तर देलथिन जे, “हे अविश्‍वासी पीढ़ीक लोक सभ! हम तोरा सभक संग कहिया तक रहिअह? कहिया तक तोरा सभ केँ सहैत रहिअह?—लड़का केँ आनह हमरा लग।” ");
INSERT INTO mai_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","लोक सभ ओहि नेना केँ यीशु लग अनलकनि। दुष्‍टात्‍मा यीशु केँ देखिते नेना केँ ममोड़ि देलकैक। लड़का नीचाँ खसि पड़लैक। ओकरा मुँह सँ गाउज निकलऽ लगलैक और ओ ओँघराय लागल। ");
INSERT INTO mai_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","यीशु ओकरा बाबू सँ पुछलथिन जे, “एकरा ई दशा कहिया सँ छैक?” ओ उत्तर देलकनि जे, “बचपने सँ। ");
INSERT INTO mai_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","एकरा नष्‍ट करबाक लेल दुष्‍टात्‍मा कतेक बेर आगि और पानि मे खसौने अछि। मुदा अपने जँ किछु कऽ सकैत छी तँ हमरा सभ पर दया कऽ सहायता करू।” ");
INSERT INTO mai_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","यीशु ओकरा कहलथिन, “कोना कहैत छह जे, ‘अपने जँ कऽ सकैत छी तँ...’? विश्‍वास करऽ वलाक लेल सभ किछु सम्‍भव छैक!” ");
INSERT INTO mai_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","एहि पर लड़काक बाबू तुरत जोर सँ बाजल जे, “हम विश्‍वास करैत छी, हमर अविश्‍वास केँ दूर कऽ दिअ।” ");
INSERT INTO mai_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","जखन यीशु देखलनि जे भीड़ हमरा सभ केँ आब दबा देत तँ ओ दुष्‍टात्‍मा केँ डाँटि कऽ कहलथिन, “है बौक और बहीर वला आत्‍मा! हम तोरा आज्ञा दैत छिऔ जे एकरा मे सँ निकलि जो और एकरा मे फेर कहियो प्रवेश नहि कर!” ");
INSERT INTO mai_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","दुष्‍टात्‍मा चिचियाइत और लड़का केँ बहुत जोर सँ मड़ोड़ि कऽ ओकरा मे सँ निकलि गेल। लड़का मुरदा जकाँ भऽ गेल। से देखि बहुत लोक कहऽ लागल जे ओ मरि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","मुदा यीशु ओकरा हाथ पकड़ि कऽ उठौलथिन और ओ ठाढ़ भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","जखन यीशु घर मे असगरे छलाह तखन शिष्‍य सभ हुनका सँ पुछलथिन जे, “हम सभ ओहि दुष्‍टात्‍मा केँ किएक नहि निकालि सकलहुँ?” ");
INSERT INTO mai_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ओ उत्तर देलनि जे, “एहि प्रकारक दुष्‍टात्‍मा प्रार्थना केँ छोड़ि आरो कोनो दोसर उपाय सँ नहि निकालल जा सकैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ओहि ठाम सँ विदा भऽ कऽ ओ सभ गलील प्रदेश होइत आगाँ बढ़लाह। यीशु ई बात गुप्‍त राखऽ चाहैत छलाह ");
INSERT INTO mai_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","कारण ओ अपन शिष्‍य सभ केँ सिखबैत छलाह जे, “मनुष्‍य-पुत्र पकड़बा कऽ लोकक हाथ मे सौंपल जायत, आ ओ सभ ओकरा मारि देतैक। मरलाक तीन दिनक बाद ओ फेर जीबि उठत।” ");
INSERT INTO mai_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","मुदा शिष्‍य सभ ई बात नहि बुझि सकलाह और हुनका सँ एहि सम्‍बन्‍ध मे पुछऽ सँ डेराइत छलाह। ");
INSERT INTO mai_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ओ सभ कफरनहूम नगर पहुँचलाह। घर मे आबि कऽ यीशु शिष्‍य सभ सँ पुछलथिन जे, “बाट मे अहाँ सभ की तर्क-वितर्क करैत छलहुँ?” ");
INSERT INTO mai_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ओ सभ चुप रहलाह किएक तँ बाट मे ओ सभ एहि विषय मे वाद-विवाद करैत छलाह जे हमरा सभ मे सभ सँ पैघ के अछि? ");
INSERT INTO mai_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","यीशु बैसि कऽ बारहो शिष्‍य केँ अपना लग बजौलनि आ कहलथिन, “जे केओ पैघ बनऽ चाहैत अछि से अपना केँ छोट बनाबओ और सभक सेवक बनओ।” ");
INSERT INTO mai_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","तखन ओ एक छोट बच्‍चा केँ लऽ कऽ हुनका सभक बीच मे ठाढ़ कऽ देलथिन, और कोरा मे लऽ कऽ शिष्‍य सभ केँ कहलथिन जे, ");
INSERT INTO mai_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“जे केओ हमरा नाम सँ एहन छोट बच्‍चा केँ स्‍वीकार करैत अछि से हमरे स्‍वीकार करैत अछि, और जे हमरा स्‍वीकार करैत अछि से हमरे नहि, बल्‍कि हुनको स्‍वीकार करैत छनि जे हमरा पठौने छथि।” ");
INSERT INTO mai_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","तखन यूहन्‍ना यीशु केँ कहलथिन, “गुरुजी, हम सभ एक आदमी केँ अहाँक नाम लऽ कऽ दुष्‍टात्‍मा निकालैत देखलहुँ और ओकरा मना कयलिऐक किएक तँ ओ हमरा सभक संग अहाँक शिष्‍य नहि अछि।” ");
INSERT INTO mai_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","लेकिन यीशु कहलथिन, “हुनका मना नहि करिऔन कारण, जे हमरा नाम सँ कोनो पैघ काज करताह से जल्‍दी हमरा विरोध मे नहि बजताह। ");
INSERT INTO mai_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","जे अपना सभक विरोध मे नहि अछि से अपना सभक पक्षे मे अछि। ");
INSERT INTO mai_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","हम अहाँ सभ केँ सत्‍ये कहैत छी जे, जे केओ अहाँ केँ एक लोटा पानि एहि लेल पिया दैत अछि जे अहाँ मसीहक आदमी छी, तकरा एकर प्रतिफल अवश्‍य भेटतैक।” ");
INSERT INTO mai_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“ई बच्‍चा सभ जे हमरा पर विश्‍वास करैत अछि, ताहि मे सँ जँ एकोटा केँ केओ पाप मे फँसाओत, तँ ओहि फँसौनिहारक गरदनि मे जाँतक पाट बान्‍हि कऽ समुद्र मे डुबा देल जाइक, से ओकरा लेल नीक होइत। ");
INSERT INTO mai_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“अहाँक हाथ जँ अहाँ केँ पाप मे फँसबैत अछि तँ ओकरा काटि कऽ फेकि दिअ। दूनू हाथक संग नरक मे जायब जतऽ आगि कहियो नहि मिझायत, अहाँक लेल ताहि सँ नीक ई जे लुल्‍ह भऽ कऽ अनन्‍त जीवन मे प्रवेश करब। ");
INSERT INTO mai_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","अहाँक पयर जँ अहाँ केँ पाप मे फँसबैत अछि तँ ओकरा काटि कऽ फेकि दिअ। दूनू पयरक संग नरक मे फेकि देल जायब*, ताहि सँ नीक ई जे नाङड़ भऽ कऽ जीवन मे प्रवेश करब। ");
INSERT INTO mai_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","और अहाँक आँखि जँ अहाँ केँ पाप मे फँसबैत अछि तँ ओकरा निकालि दिअ। कनाह भऽ कऽ परमेश्‍वरक राज्‍य मे प्रवेश करब से अहाँक लेल एहि सँ नीक होयत जे दूनू आँखिक संग नरक मे फेकि देल जायब, ");
INSERT INTO mai_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","जतऽ मनुष्‍य मे फड़ि गेल कीड़ा नहि मरैत अछि आ अनन्‍त आगि जरैत रहैत अछि। ");
INSERT INTO mai_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“प्रत्‍येक व्‍यक्‍ति अग्‍नि-परीक्षा द्वारा सिद्ध बनाओल जायत। ");
INSERT INTO mai_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","नून नीक वस्‍तु अछि, मुदा जँ ओकर स्‍वाद समाप्‍त भऽ जाइक तँ अहाँ कोन वस्‍तु सँ ओकरा फेर नूनगर बना सकब? अहाँ सभ अपना मे नूनक गुण राखू और एक-दोसराक संग मेल-मिलाप सँ रहू!” ");
INSERT INTO mai_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","यीशु तखन ओहि ठाम सँ विदा भऽ कऽ यहूदिया प्रदेश मे और यरदन नदीक ओहि पार गेलाह। बहुत बड़का भीड़ फेर हुनका लग अयलनि, तँ ओ अपन आदतक अनुसार ओकरा सभ केँ शिक्षा देबऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","किछु फरिसी सभ आबि कऽ हुनका जँचबाक लेल पुछलथिन जे, “की धर्म-नियमक अनुसार पुरुष केँ अपना स्‍त्री केँ तलाक देनाइ ठीक अछि?” ");
INSERT INTO mai_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","यीशु हुनका सभ केँ पुछलथिन जे, “एहि सम्‍बन्‍ध मे मूसा की आज्ञा देने छथि?” ");
INSERT INTO mai_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ओ सभ उत्तर देलथिन, “मूसा तलाकनामा लिखि कऽ तलाकक अनुमति देने छथि।” ");
INSERT INTO mai_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","एहि पर यीशु हुनका सभ केँ जबाब देलथिन जे, “अहाँ सभक मोनक कठोरताक कारणेँ मूसा अहाँ सभक लेल ई आज्ञा देने छथि। ");
INSERT INTO mai_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","लेकिन सृष्‍टिक शुरुए सँ परमेश्‍वर मनुष्‍य केँ ‘पुरुष आ स्‍त्री बनौलनि।’ ");
INSERT INTO mai_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘एहि कारणेँ पुरुष अपन माय-बाबू केँ छोड़ि अपन स्‍त्रीक संग रहत और दूनू एक शरीर भऽ जायत।’ ");
INSERT INTO mai_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","आब ओ सभ दू नहि अछि—एके भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","तेँ जकरा परमेश्‍वर जोड़ि देलथिन तकरा मनुष्‍य अलग नहि करओ।” ");
INSERT INTO mai_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","बाद मे जखन घर मे छलाह तखन शिष्‍य सभ एहि विषय मे यीशु सँ फेर पुछलथिन। ");
INSERT INTO mai_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ओ उत्तर देलथिन जे, “जे केओ अपना स्‍त्री केँ तलाक दऽ कऽ दोसर सँ विवाह करैत अछि, से ओहि स्‍त्रीक संग परस्‍त्रीगमन करैत अछि। ");
INSERT INTO mai_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","और जे स्‍त्री अपना पति केँ तलाक दऽ कऽ दोसर पुरुष सँ विवाह करैत अछि, सेहो परपुरुषगमन करैत अछि।” ");
INSERT INTO mai_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","तखन लोक सभ यीशु लग अपन बच्‍चा सभ केँ आनऽ लगलनि जे ओ ओकरा सभ पर हाथ राखि आशीर्वाद देथिन। मुदा शिष्‍य सभ ओकरा सभ केँ डँटलनि। ");
INSERT INTO mai_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ई देखि यीशु बहुत अप्रसन्‍न भऽ गेलाह और शिष्‍य सभ केँ कहलथिन, “बच्‍चा सभ केँ हमरा लग आबऽ दिऔक, ओकरा सभ केँ नहि रोकिऔक, किएक तँ परमेश्‍वरक राज्‍य एहने सभक अछि। ");
INSERT INTO mai_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","हम अहाँ सभ केँ सत्‍य कहैत छी जे, जे बच्‍चा जकाँ परमेश्‍वरक राज्‍य ग्रहण नहि करत से ओहि मे कहियो नहि प्रवेश करत।” ");
INSERT INTO mai_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","तखन बच्‍चा सभ केँ कोरा मे उठा लेलथिन और ओकरा सभ पर हाथ राखि कऽ आशीर्वाद देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","यीशु जखन ओहिठाम सँ विदा भऽ रस्‍ता मे जा रहल छलाह तँ एक आदमी दौड़ि कऽ अयलाह, और हुनका आगाँ मे ठेहुनिया रोपि कऽ यीशु सँ पुछलथिन जे, “यौ उत्तम गुरुजी! अनन्‍त जीवन प्राप्‍त करबाक लेल हम की करू?” ");
INSERT INTO mai_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","यीशु हुनका कहलथिन, “अहाँ हमरा ‘उत्तम’ किएक कहैत छी? परमेश्‍वर केँ छोड़ि आरो केओ उत्तम नहि अछि। ");
INSERT INTO mai_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","मुदा अहाँ धर्म-नियमक आज्ञा सभ तँ जनिते छी—‘हत्‍या नहि करह, परस्‍त्रीगमन नहि करह, चोरी नहि करह, झूठ गवाही नहि दैह, ककरो नहि ठकह, अपन माय-बाबूक आदर करह।’ ” ");
INSERT INTO mai_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ओ उत्तर देलथिन जे, “गुरुजी, एहि सभ आज्ञाक पालन हम बचपने सँ करैत छी।” ");
INSERT INTO mai_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","यीशु हुनका देखि कऽ प्रेम कयलथिन और कहलथिन, “अहाँ मे एकटा बातक कमी अछि—अहाँ जाउ, अपन पूरा सम्‍पत्ति बेचि कऽ ओकरा गरीब सभ मे बाँटि दिअ, अहाँ केँ स्‍वर्ग मे धन भेटत। तकरबाद आउ आ हमरा पाछाँ चलू।” ");
INSERT INTO mai_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ई बात सुनि कऽ ओहि आदमीक मुँह उतरि गेलनि, आ ओ उदास भऽ कऽ चल गेलाह किएक तँ हुनका बहुत धन-सम्‍पत्ति छलनि। ");
INSERT INTO mai_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","तखन यीशु चारू कात देखि कऽ अपना शिष्‍य सभ केँ कहलथिन, “धनिक सभक लेल परमेश्‍वरक राज्‍य मे प्रवेश कयनाइ कतेक कठिन अछि!” ");
INSERT INTO mai_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","शिष्‍य सभ एहि बात सँ अचम्‍भित भऽ गेलाह। यीशु हुनका सभ केँ फेर कहलथिन, “हे हमर बेटा सभ! परमेश्‍वरक राज्‍य मे प्रवेश कयनाइ कतेक कठिन अछि! ");
INSERT INTO mai_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","धनिक केँ परमेश्‍वरक राज्‍य मे प्रवेश कयनाइ सँ ऊँट केँ सुइक भूर दऽ कऽ निकलनाइ आसान अछि।” ");
INSERT INTO mai_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ओ सभ आरो चकित भऽ कऽ एक-दोसर केँ कहऽ लगलाह जे, “तखन उद्धार ककर भऽ सकैत छैक?!” ");
INSERT INTO mai_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","यीशु हुनका सभ केँ एकटक देखैत कहलथिन, “मनुष्‍यक लेल तँ ई असम्‍भव अछि, लेकिन परमेश्‍वरक लेल नहि। परमेश्‍वरक लेल सभ किछु सम्‍भव अछि।” ");
INSERT INTO mai_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","पत्रुस हुनका कहलथिन, “देखू! हम सभ तँ सभ किछु त्‍यागि कऽ अहाँक पाछाँ आयल छी।” ");
INSERT INTO mai_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","यीशु उत्तर देलथिन, “हम अहाँ सभ केँ सत्‍ये कहैत छी, प्रत्‍येक व्‍यक्‍ति जे हमरा लेल और शुभ समाचारक लेल घर, भाय, बहिन, माय-बाबू, सन्‍तान वा जमीन-जालक त्‍याग करत ");
INSERT INTO mai_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","तकरा एहि युग मे सय गुना भेटतैक—घर, भाय, बहिन, माय, सन्‍तान, जमीन, मुदा संगे-संगे सहऽ पड़तैक अत्‍याचार, और आबऽ वला युग मे भेटतैक अनन्‍त जीवन। ");
INSERT INTO mai_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","मुदा बहुतो लोक जे एखन आगाँ अछि से पाछाँ भऽ जायत, आ जे एखन पाछाँ अछि से आगाँ भऽ जायत।” ");
INSERT INTO mai_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","यीशु और हुनकर शिष्‍य सभ यरूशलेम जाय वला रस्‍ता पर बढ़ैत छलाह। यीशु आगू-आगू चलि रहल छलाह। शिष्‍य सभ आश्‍चर्य-चकित छलाह और जे सभ संग मे पाछू-पाछू अबैत छल से सभ भयभीत छल। बारहो शिष्‍य केँ यीशु फेर अलग लऽ जा कऽ हुनका सभ केँ बुझा देलथिन जे हुनका संग केहन घटना सभ होयतनि। ओ हुनका सभ केँ कहलथिन जे, ");
INSERT INTO mai_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“सुनू, अपना सभ यरूशलेम जा रहल छी। ओहिठाम मनुष्‍य-पुत्र मुख्‍यपुरोहित और धर्मशिक्षक सभक हाथ मे पकड़ाओल जायत। ओ सभ ओकरा मृत्‍युदण्‍डक जोगरक ठहरा देतैक और गैर-यहूदी सभक हाथ मे सौंपि देतैक। ");
INSERT INTO mai_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ओ सभ ओकर हँसी उड़ौतैक और ओकरा पर थुकतैक, ओकरा कोड़ा सँ मारतैक और मारि देतैक। मुदा तीन दिनक बाद ओ फेर जीबि उठत।” ");
INSERT INTO mai_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","जबदीक दूनू पुत्र याकूब और यूहन्‍ना यीशु लग आबि कऽ कहलथिन, “गुरुजी, हम सभ चाहैत छी जे, हम सभ जे किछु माँगी से अहाँ हमरा सभक लेल कऽ दिअ।” ");
INSERT INTO mai_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","यीशु पुछलथिन जे, “अहाँ सभ की चाहैत छी जे हम कऽ दिअ?” ");
INSERT INTO mai_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ओ सभ जबाब देलथिन जे, “अहाँ अपन महिमामय राज्‍य मे हमरा सभ मे सँ एक केँ अपना दहिना कात मे और दोसर केँ अपना बामा कात मे बैसबाक अधिकार दिअ।” ");
INSERT INTO mai_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","यीशु हुनका सभ केँ कहलथिन, “अहाँ सभ की माँगि रहल छी से अहाँ सभ नहि बुझैत छी। की दुःखक बाटी सँ जे हमरा पिबाक अछि से अहाँ सभ पिबि सकैत छी? वा कष्‍टक बपतिस्‍मा लऽ सकैत छी जे हमरा लेबाक अछि?” ");
INSERT INTO mai_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ओ सभ उत्तर देलथिन जे, “हँ, कऽ सकैत छी।” तखन यीशु हुनका सभ केँ कहलथिन, “जे बाटी हमरा पिबाक अछि से तँ अहाँ सभ पीब, और जे बपतिस्‍मा हमरा लेबाक अछि से अहाँ सभ लेब, ");
INSERT INTO mai_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","मुदा किनको अपना दहिना कात वा बामा कात बैसायब, तकर अधिकार हमरा नहि अछि—ई स्‍थान सभ तिनका सभक लेल छनि, जिनका सभक लेल तैयार कयल गेल अछि।” ");
INSERT INTO mai_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","जखन बाँकी दस शिष्‍य एहि बातक बारे मे सुनलनि तखन ओ सभ याकूब और यूहन्‍ना पर खिसिआय लगलाह। ");
INSERT INTO mai_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","एहि पर यीशु शिष्‍य सभ केँ अपना लग बजा कऽ कहलथिन, “अहाँ सभ जनैत छी जे एहि संसार मे जे सभ शासन करऽ वला बुझल जाइत छथि से सभ जनता पर हुकुम चलबैत रहैत छथि, और जनता मे जे पैघ लोक सभ छथि से जनता पर अधिकार जमबैत छथि। ");
INSERT INTO mai_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","मुदा अहाँ सभ मे एना नहि होअय। बल्‍कि, जे अहाँ सभ मे पैघ होमऽ चाहय से अहाँ सभक सेवक बनय। ");
INSERT INTO mai_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","और जे केओ अहाँ सभ मे प्रमुख व्‍यक्‍ति होमऽ चाहय से सभक टहलू बनय! ");
INSERT INTO mai_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","किएक तँ मनुष्‍य-पुत्र सेहो एहि लेल नहि आयल अछि जे अपन सेवा कराबय बल्‍कि एहि लेल जे ओ सेवा करय और बहुतो लोकक छुटकाराक मूल्‍य मे अपन प्राण देअय।” ");
INSERT INTO mai_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","तखन ओ सभ यरीहो नगर पहुँचलाह। जखन यीशु और शिष्‍य सभ बड़का भीड़क संग यरीहो सँ निकलैत छलाह तखन रस्‍ताक कात मे तिमाईक पुत्र, बरतिमाई, जे आन्‍हर छल, से भीख मँगैत बैसल छल। ");
INSERT INTO mai_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","जखन ओ सुनलक जे नासरत-निवासी यीशु जा रहल छथि तँ ओ सोर पारि कऽ कहऽ लागल जे, “यौ दाऊदक पुत्र यीशु! हमरा पर दया करू!” ");
INSERT INTO mai_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ओकरा बहुत लोक डाँटि कऽ चुप रहऽ लेल कहलकैक, मुदा ओ आरो जोर सँ हल्‍ला कऽ कऽ कहऽ लागल जे, “यौ दाऊदक पुत्र! हमरा पर दया करू!” ");
INSERT INTO mai_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","यीशु ठाढ़ भऽ गेलाह आ कहलनि जे, “ओकरा बजाउ!” तखन ओहि आन्‍हर केँ बजा कऽ लोक सभ कहलकैक जे, “निराश नहि हो! उठ! तोरा बजबैत छथुन!” ");
INSERT INTO mai_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","अपन ओढ़ना फेकि कऽ ओ छरपि उठल और यीशु लग आयल। ");
INSERT INTO mai_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","यीशु ओकरा पुछलथिन जे, “तोँ की चाहैत छह, हम तोरा लेल की करिअह?” आन्‍हर बाजल, “गुरुजी, हम देखऽ चाहैत छी!” ");
INSERT INTO mai_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","यीशु ओकरा कहलथिन, “जाह—तोहर विश्‍वास तोरा नीक कऽ देलकह।” ओ तुरत देखऽ लागल और रस्‍ता मे यीशुक पाछाँ चलऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","यीशु आ हुनकर शिष्‍य सभ जखन यरूशलेम लग पहुँचलाह, अर्थात्‌ जैतून पहाड़ पर बेतफगे और बेतनिया गाम सभ लग, तखन यीशु दूटा शिष्‍य केँ ई कहि कऽ पठौलथिन जे, ");
INSERT INTO mai_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“सामने मे जे गाम अछि, ताहि मे जाउ। जखने अहाँ सभ गाम मे प्रवेश करब तखन गदहीक एक बच्‍चा बान्‍हल भेटत जाहि पर केओ कहियो नहि चढ़ल अछि। ओकरा खोलि कऽ आनू। ");
INSERT INTO mai_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","जँ केओ पुछत जे ‘एकरा किएक खोलैत छी?’ तँ कहबैक जे, ‘प्रभु केँ एकर आवश्‍यकता छनि और एकरा तुरत फेर लौटा देताह।’ ” ");
INSERT INTO mai_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","दूनू चल गेलाह, और हुनका सभ केँ सड़कक कात मे एक घरक द्वारि लग बान्‍हल एक गदहीक बच्‍चा भेटलनि। जखने ओ सभ ओकरा खोलऽ लगलाह ");
INSERT INTO mai_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","तँ ओहिठाम ठाढ़ भेल किछु लोक सभ हुनका सभ केँ पुछलकनि जे, “अहाँ सभ की करैत छी? ई गदहा किएक खोलि रहल छी?” ");
INSERT INTO mai_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ओ सभ वैह उत्तर देलनि जे यीशु कहने छलथिन, और लोक सभ हुनका सभ केँ जाय देलकनि। ");
INSERT INTO mai_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","गदहीक बच्‍चा केँ ओ सभ यीशु लग अनलनि और ओकरा पीठ पर अपन कपड़ा राखि देलनि। यीशु ओहि पर बैसि गेलाह। ");
INSERT INTO mai_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","बहुत लोक रस्‍ता मे अपन चादर ओछा देलक, दोसर लोक खेत मे सँ पात वला ठाढ़ि तोड़ि कऽ सड़क पर ओछौलक। ");
INSERT INTO mai_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","यीशुक आगाँ-पाछाँ चलऽ वला लोकक भीड़ एहि तरहेँ जयजयकार करऽ लागल जे, “जय! जय! धन्‍य छथि ओ जे प्रभुक नाम सँ अबैत छथि! ");
INSERT INTO mai_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","हमरा सभक पुरखा दाऊदक आबऽ वला राज्‍य केँ जय! सर्वोच्‍च स्‍वर्ग मे प्रभुक जयजयकार!” ");
INSERT INTO mai_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","यीशु यरूशलेम पहुँचि कऽ मन्‍दिर मे गेलाह। ओहिठाम चारू दिस नजरि दौड़ा कऽ सभ किछु देखलनि मुदा साँझ पड़ि जयबाक कारणेँ ओतऽ सँ बाहर गेलाह आ बारहो शिष्‍यक संग बेतनिया चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","दोसर दिन जखन ओ सभ बेतनिया सँ अबैत छलाह तखन यीशु केँ भूख लागल छलनि। ");
INSERT INTO mai_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","दूर सँ ओ हरियर पात सँ भरल एक अंजीरक गाछ देखि कऽ गाछ लग गेलाह जे शायद ओहि पर किछु फल भेटय। मुदा ओतऽ पहुँचला पर पात छोड़ि आरो किछु नहि भेटलनि, किएक तँ अंजीरक फलक समय नहि छल। ");
INSERT INTO mai_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","यीशु ओहि गाछ केँ कहलथिन, “आइ सँ तोहर फल केओ कहियो नहि खयतौ!” शिष्‍य सभ हुनका ई कहैत सुनलनि। ");
INSERT INTO mai_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","तखन ओ सभ यरूशलेम पहुँचलाह। मन्‍दिर मे जा कऽ यीशु बेचऽ वला और किनऽ वला सभ केँ ओतऽ सँ बाहर भगाबऽ लगलाह। ओ पाइ भजौनिहार सभक टेबुल आ परबा-पेउरकी बेचनिहार सभक पीढ़ी-बैसकी सभ केँ उनटा-पुनटा देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ककरो मन्‍दिर दऽ कऽ कोनो सामान लऽ कऽ नहि जाय देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","लोक केँ शिक्षा देबऽ लगलथिन जे, “की धर्मशास्‍त्र मे नहि लिखल अछि जे, ‘हमर घर सभ जातिक लेल प्रार्थनाक घर कहाओत’? मुदा तोँ सभ एकरा ‘चोर-डाकूक अड्डा’ बना देने छह।” ");
INSERT INTO mai_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","मुख्‍यपुरोहित और धर्मशिक्षक सभ ई बात सुनि कऽ यीशु केँ कोना मारल जाय तकर उपाय सोचऽ लगलाह, एहि द्वारे जे हुनका सँ डेराइत छलाह किएक तँ पूरा जनता हुनकर शिक्षाक कारणेँ आश्‍चर्यित छल। ");
INSERT INTO mai_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","सूर्यास्‍‍तक बाद यीशु और शिष्‍य सभ शहर सँ बाहर चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","प्रात भेने रस्‍ता मे जाइत-जाइत ओ सभ देखलनि जे अंजीरक गाछ जड़ि सँ सुखि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पत्रुस पछिला दिनक घटनाक स्‍मरण करैत यीशु केँ कहलथिन, “गुरुजी, देखू! ओहि अंजीरक गाछ जकरा सराप देने छलहुँ से सुखि गेल अछि!” ");
INSERT INTO mai_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ओ हुनका सभ केँ उत्तर देलथिन जे, “परमेश्‍वर पर विश्‍वास राखू! ");
INSERT INTO mai_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","हम अहाँ सभ केँ सत्‍ये कहैत छी जे, जँ केओ एहि पहाड़ केँ कहत जे ‘एतऽ सँ हट आ समुद्र मे जो,’ और मोन मे सन्‍देह नहि करत, बल्‍कि एकर विश्‍वास करत जे हम जे कहि रहल छी से भऽ जायत, तँ ओकरा लेल से भइए जायत। ");
INSERT INTO mai_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","एहि लेल हम अहाँ सभ केँ कहैत छी जे, अहाँ प्रार्थना मे जे किछु माँगब, विश्‍वास करू जे ओ भेटि गेल, और अहाँ केँ भेटिए जायत। ");
INSERT INTO mai_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","और जखन अहाँ प्रार्थनाक लेल ठाढ़ होयब, अहाँक हृदय मे जँ ककरो प्रति विरोध होअय तँ ओकरा क्षमा करू जाहि सँ अहाँक पिता जे स्‍वर्ग मे छथि सेहो अहाँक अपराध क्षमा करताह।” ");
INSERT INTO mai_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ओ सभ फेर यरूशलेम पहुँचलाह। यीशु केँ मन्‍दिर मे टहलैत काल मुख्‍यपुरोहित, धर्मशिक्षक लोकनि और बूढ़-प्रतिष्‍ठित सभ हुनका लग अयलनि। ");
INSERT INTO mai_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ई सभ यीशु सँ पुछलथिन जे, “अहाँ कोन अधिकार सँ ई सभ बात कऽ रहल छी? अहाँ केँ ई काज करबाक के अधिकार देलनि?” ");
INSERT INTO mai_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","यीशु हुनका सभ केँ कहलथिन जे, “हमहूँ अहाँ सभ सँ एकटा बात पुछैत छी। अहाँ सभ उत्तर देब तँ हमहूँ अहाँ सभ केँ कहब जे हम कोन अधिकार सँ ई सभ काज कऽ रहल छी। ");
INSERT INTO mai_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","यूहन्‍ना केँ बपतिस्‍मा देबाक अधिकार परमेश्‍वर सँ भेटल छलनि वा मनुष्‍य सँ? बाजू!” ");
INSERT INTO mai_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ई सुनि ओ सभ अपना मे तर्क-वितर्क करऽ लगलाह जे, “जँ अपना सभ कहबैक जे, परमेश्‍वर सँ, तँ ओ पुछत जे, ‘तखन हुनकर बातक विश्‍वास किएक नहि कयलहुँ?’ ");
INSERT INTO mai_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","मुदा जँ कहबैक जे, ‘मनुष्‍य सँ, तँ...’ ” ओ सभ जनता सँ डेराइत छलाह किएक तँ सभ लोक यूहन्‍ना केँ परमेश्‍वरक प्रवक्‍ता मानैत छल। ");
INSERT INTO mai_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","तेँ ओ सभ यीशु केँ उत्तर देलथिन जे, “हम सभ नहि जनैत छी।” एहि पर यीशु कहलथिन, “तँ हमहूँ अहाँ सभ केँ नहि कहब जे, हम कोन अधिकार सँ ई काज करैत छी!” ");
INSERT INTO mai_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","तखन ओ हुनका सभ केँ दृष्‍टान्‍त द्वारा शिक्षा देबऽ लगलाह, “एक आदमी एक अंगूरक बगान लगौलनि और चारू कात सँ ओकरा घेरि देलनि। अंगूरक रस जमा करबाक लेल ओ एक रसकुण्‍ड बनौलनि आ रखबारीक लेल मचान बनौलनि। तकरबाद किसान सभ केँ बटाइ पर दऽ कऽ परदेश चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","फलक समय अयला पर ओ अपन हिस्‍सा लेबाक लेल एक नोकर केँ बटाइदार सभक ओहिठाम पठौलथिन। ");
INSERT INTO mai_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","मुदा ओ सभ ओकरा पकड़ि कऽ मारि-पिटि कऽ खाली हाथ लौटा देलकैक। ");
INSERT INTO mai_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","तखन मालिक फेर दोसर नोकर केँ ओकरा सभक ओहिठाम पठौलथिन, मुदा ओ सभ ओकर कपार फोड़ि देलकैक और ओकर अपमान कयलकैक। ");
INSERT INTO mai_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","मालिक तेसरो केँ पठौलथिन और ओकरा ओ सभ मारि देलकैक। तहिना आरो बहुत नोकर केँ ओ सभ पिटलकैक वा मारि देलकैक। ");
INSERT INTO mai_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","आब मालिक केँ एकेटा आदमी रहि गेलनि—हुनकर अपन प्रिय बेटा। अन्‍त मे ओ ओकरो, ई सोचि कऽ पठौलथिन जे, ‘हमरा बेटा केँ ओ सभ अवश्‍य आदर करत।’ ");
INSERT INTO mai_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","मुदा बटाइदार सभ एक-दोसर केँ कहलक जे, ‘ई अपन बापक उत्तराधिकारी अछि। चलू एकरा मारि दिऐक, तखन ई सम्‍पत्ति अपने सभक भऽ जायत!’ ");
INSERT INTO mai_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","एना सोचि ओ सभ हुनका पकड़ि कऽ मारि देलकनि और हुनकर लास बगान सँ बाहर फेकि देलकनि।” ");
INSERT INTO mai_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","यीशु आगाँ कहलथिन, “बगानक मालिक आब की करताह? ओ आबि कऽ ओहि बटाइदार सभक सर्वनाश करथिन और बगान दोसर बटाइदार सभ केँ दऽ देथिन। ");
INSERT INTO mai_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","की अहाँ सभ धर्मशास्‍त्र मे ई नहि पढ़ने छी?— ‘जाहि पाथर केँ राजमिस्‍तिरी सभ बेकार बुझि कऽ फेकि देलक, वैह पाथर मकानक प्रमुख पाथर भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ई काज प्रभु-परमेश्‍वर कयलनि, और ई हमरा सभक नजरि मे अद्‌भुत बात अछि!’” ");
INSERT INTO mai_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","एहि पर ओ सभ हुनका पकड़ऽ चाहैत छलाह किएक तँ ओ सभ बुझि गेलाह जे ई हमरे सभक बारे मे ई कथा कहलक अछि। मुदा जनता सँ डेरयबाक कारणेँ ओ सभ हुनका छोड़ि कऽ चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","बाद मे ओ सभ किछु फरिसी और हेरोद-दलक किछु लोक केँ यीशु लग पठा देलनि जे हुनका अपन कहल बातक जाल मे फँसाबय। ");
INSERT INTO mai_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ओ सभ आबि कऽ हुनका कहलकनि जे, “गुरुजी, हम सभ जनैत छी जे अपने सत्‍यवादी छी, आ केओ की सोचैत अछि, तकर अपने केँ कोनो चिन्‍ता नहि, कारण, अपने मुँह-देखी बात नहि करैत छी। अपने सत्‍यक अनुसार परमेश्‍वरक बाटक शिक्षा दैत छी। आब हमरा सभ केँ एकटा बात कहल जाओ—रोमी सम्राट-कैसर केँ कर देब धर्म-नियमक अनुसार उचित अछि वा नहि? अपना सभ केँ कर देबाक चाही वा नहि देबाक चाही?” ");
INSERT INTO mai_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","यीशु ओकरा सभक कपट बुझि कऽ ओकरा सभ केँ कहलथिन, “अहाँ सभ हमरा किएक फँसाबऽ चाहैत छी? हमरा एकटा सिक्‍का दिअ, हम देखब।” ");
INSERT INTO mai_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ओ सभ एक दिनारक सिक्‍का लऽ आयल। तखन यीशु ओकरा सभ केँ कहलथिन, “ई किनकर चित्र छनि? आ एहि पर किनकर नाम लिखल छनि?” ओ सभ उत्तर देलकनि, “सम्राट-कैसरक।” ");
INSERT INTO mai_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","तखन यीशु ओकरा सभ केँ कहलथिन, “जे सम्राटक छनि से सम्राट केँ दिऔन, आ जे परमेश्‍वरक छनि से परमेश्‍वर केँ दिऔन।” एहि पर ओ सभ एकदम अवाक रहि गेल। ");
INSERT INTO mai_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","तखन किछु सदुकी पंथक लोक, जे सभ एहि बात केँ नहि मानैत अछि जे मृत्‍यु मे सँ मनुष्‍य फेर जिआओल जायत, से सभ एकटा प्रश्‍न लऽ कऽ यीशु लग आयल। ");
INSERT INTO mai_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ओ सभ कहलकनि, “गुरुजी, मूसा हमरा सभक लेल लिखलनि जे, जँ ककरो भाय निःसन्‍तान मरि जाइक आ ओकर स्‍त्री जीविते होइक तँ ओकरा ओहि स्‍त्री सँ विवाह कऽ अपना भायक लेल सन्‍तान उत्‍पन्‍न करबाक चाही। ");
INSERT INTO mai_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","एक परिवार मे सात भाय छल। जेठ भाय विवाह कयलक और निःसन्‍तान मरि गेल। ");
INSERT INTO mai_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","तँ दोसर भाय ओहि स्‍त्री सँ विवाह कयलक लेकिन ओहो निःसन्‍तान मरि गेल। तेसरो भाय केँ एहिना भेलैक। ");
INSERT INTO mai_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","तहिना सातो भाय ओहि स्‍त्री सँ विवाह कऽ कऽ निःसन्‍तान मरि गेल, और अन्‍त मे स्‍त्रिओ मरि गेल। ");
INSERT INTO mai_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","आब कहल जाओ, ओहि समय मे जहिया मुइल सभ केँ जिआओल जयतैक, तँ ओ स्‍त्री एहि भाय सभ मे सँ ककर स्‍त्री होयतैक? ओकरा सँ तँ सातो विवाह कयने छलैक।” ");
INSERT INTO mai_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","यीशु उत्तर देलथिन, “अहाँ सभ ने धर्मशास्‍त्र आ ने परमेश्‍वरक सामर्थ्‍य केँ जनैत छी। तेँ अहाँ सभ केँ एहि तरहेँ धोखा भऽ रहल अछि। ");
INSERT INTO mai_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","किएक तँ, जखन लोक सभ मृत्‍यु सँ जीबि जायत तखन ने ओ सभ विवाह करत आ ने विवाह मे देल जायत, बल्‍कि ओ सभ स्‍वर्गदूत सभ जकाँ होयत। ");
INSERT INTO mai_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","तखन मुइल सभ केँ जिआओल जयबाक जे बात अछि, ताहि सम्‍बन्‍ध मे की अहाँ सभ कहियो मूसाक पुस्‍तक मे नहि पढ़ने छी—जाहि ठाम जरैत झाड़ीक वर्णन अछि, कोना परमेश्‍वर ⌞एहि पूर्वज लोकनिक मृत्‍युक बादो⌟ मूसा केँ कहलथिन जे, ‘हम अब्राहमक परमेश्‍वर, इसहाकक परमेश्‍वर और याकूबक परमेश्‍वर छी।’? ");
INSERT INTO mai_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ओ मुइल सभक नहि, जीवित सभक परमेश्‍वर छथि! अहाँ सभ एकदम गलत बुझैत छी!” ");
INSERT INTO mai_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","एक धर्मशिक्षक ई वाद-विवाद सुनि कऽ देखलनि जे यीशु सदूकी सभ केँ बहुत नीक जबाब देने छथिन, तँ ओ यीशु लग आबि कऽ पुछलथिन जे, “सभ सँ पैघ आज्ञा कोन अछि?” ");
INSERT INTO mai_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","यीशु उत्तर देलथिन जे, “सभ सँ पैघ आज्ञा यैह अछि—‘हे इस्राएल, सुनह, प्रभु, अपना सभक परमेश्‍वर, सैह एकमात्र प्रभु छथि। ");
INSERT INTO mai_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","तोँ अपन प्रभु-परमेश्‍वर केँ अपन सम्‍पूर्ण मोन सँ, अपन सम्‍पूर्ण आत्‍मा सँ, अपन सम्‍पूर्ण बुद्धि सँ और अपन सम्‍पूर्ण शक्‍ति सँ प्रेम करह।’ ");
INSERT INTO mai_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","और दोसर पैघ आज्ञा यैह अछि जे, ‘तोँ अपना पड़ोसी केँ अपने जकाँ प्रेम करह।’ एहि सँ पैघ आरो कोनो आज्ञा नहि अछि।” ");
INSERT INTO mai_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","धर्मशिक्षक हुनका कहलथिन, “गुरुजी, कतेक नीक जबाब देलहुँ! अहाँ ठीके कहलहुँ जे एकेटा परमेश्‍वर छथि और हुनका छोड़ि आरो केओ नहि छथि। ");
INSERT INTO mai_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","हुनका अपन सम्‍पूर्ण मोन सँ, अपन सम्‍पूर्ण बुद्धि सँ और अपन सम्‍पूर्ण शक्‍ति सँ प्रेम कयनाइ, और अपना पड़ोसी केँ अपने जकाँ प्रेम कयनाइ सभ प्रकारक पशु-बलिदान, अग्‍नि-बलिदान और चढ़ौना सँ पैघ अछि।” ");
INSERT INTO mai_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","यीशु ई देखि कऽ जे ओ बहुत बुद्धिपूर्बक उत्तर देलनि ताहि पर हुनका कहलथिन, “अहाँ परमेश्‍वरक राज्‍य सँ दूर नहि छी।” तकरबाद ककरो हुनका आरो प्रश्‍न पुछबाक साहस नहि भेलैक। ");
INSERT INTO mai_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","बाद मे यीशु मन्‍दिर मे शिक्षा दैत पुछलथिन जे, “धर्मशिक्षक सभक कहबाक अर्थ की अछि जखन ओ सभ कहैत छथि जे ‘उद्धारकर्ता-मसीह’ दाऊदक पुत्र छथि? ");
INSERT INTO mai_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","दाऊद अपने, पवित्र आत्‍माक प्रेरणा सँ बजलाह, ‘प्रभु-परमेश्‍वर हमरा प्रभु केँ कहलथिन, अहाँ हमर दहिना कात बैसू और हम अहाँक शत्रु सभ केँ अहाँक पयरक तर मे कऽ देब।’ ");
INSERT INTO mai_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","दाऊद अपने, ‘उद्धारकर्ता-मसीह’ केँ ‘प्रभु’ कहैत छथिन, तँ ओ फेर हुनकर पुत्र कोना भेलाह?” भीड़क लोक सभ बहुत आनन्‍दक संग हुनकर बात सुनि रहल छलनि। ");
INSERT INTO mai_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","यीशु आगाँ शिक्षा देबऽ लगलाह जे, “धर्मशिक्षक सभ सँ सावधान रहू। धर्मगुरु वला लम्‍बा-लम्‍बा कपड़ा पहिरि कऽ घुमब, और बजार मे लोक सभ हुनका सभ केँ प्रणाम-पात करनि से बहुत नीक लगैत छनि। ");
INSERT INTO mai_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ओ सभ सभाघर सभ मे प्रमुख आसन पर बैसब और भोज-काज मे सम्‍मानित स्‍थान भेटय से पसन्‍द करैत छथि। ");
INSERT INTO mai_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","विधवा सभक घर-आङन हड़पि लैत छथि, और लोक सभ केँ देखयबाक लेल लम्‍बा-लम्‍बा प्रार्थना करैत छथि। हुनका सभ केँ बेसी दण्‍ड देल जयतनि।” ");
INSERT INTO mai_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","तखन यीशु मन्‍दिर मे दान-पात्र लग बैसि कऽ लोक सभ केँ ओहि मे दान दैत देखलनि। बहुत लोक जे सभ धनिक छल से सभ ओहि मे बहुत किछु रखैत छल। ");
INSERT INTO mai_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","तखन एकटा गरीब विधवा आबि कऽ तामक दूटा पाइ, जकर मूल्‍य एको पैसा सँ कम छलैक, से दान-पात्र मे देलक। ");
INSERT INTO mai_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","यीशु शिष्‍य सभ केँ अपना लग बजा कऽ कहलथिन, “हम अहाँ सभ केँ सत्‍य कहैत छी जे, ई गरीब विधवा ओहि सभ लोक सँ बेसी दान चढ़ौलक, ");
INSERT INTO mai_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","किएक तँ ओ सभ धनिक भऽ कऽ अपन फाजिल धन मे सँ दान चढ़ौलक मुदा ई गरीब भऽ कऽ अपना लेल किछु नहि राखि अपन पूरा जीविके चढ़ा देलक।” ");
INSERT INTO mai_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","मन्‍दिर सँ बहराइत काल यीशु केँ हुनकर एकटा शिष्‍य कहलथिन, “गुरुजी, देखू! एहि मन्‍दिरक मकान सभ कतेकटा अछि! और एहि मे कतेक सुन्‍दर-सुन्‍दर पाथर लागल अछि!” ");
INSERT INTO mai_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","यीशु हुनका कहलथिन, “ई जे बड़का मकान सभ देखैत छिऐक—एतऽ एकोटा पाथर एक-दोसर पर नहि रहत, सभ ढाहल जायत।” ");
INSERT INTO mai_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","तखन मन्‍दिरक सामने मे जैतून पहाड़ पर यीशु जखन बैसल छलाह, तँ पत्रुस, याकूब, यूहन्‍ना और अन्‍द्रेयास एकान्‍त मे हुनका सँ पुछलथिन जे, ");
INSERT INTO mai_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“हमरा सभ केँ कहू—ई बात सभ कहिया होयत? और कोन चिन्‍ह होयतैक जाहि सँ बुझि सकी जे ई बात सभ आब होयत?” ");
INSERT INTO mai_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","यीशु हुनका सभ केँ कहलथिन, “होसियार रहू जे अहाँ सभ केँ केओ बहकाबऽ नहि पाबय। ");
INSERT INTO mai_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","बहुतो लोक हमर नाम लऽ कऽ आओत और कहत जे ‘हम वैह छी!’, और बहुतो लोक केँ बहका देत। ");
INSERT INTO mai_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","जखन अहाँ सभ लड़ाइक समाचार और लड़ाइक हल्‍ला सभ सुनब तखन घबड़ायब नहि, ई सभ होयब आवश्‍यक अछि, मुदा संसारक अन्‍त तहिओ नहि होयत। ");
INSERT INTO mai_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","एक देश दोसर देश सँ लड़ाइ करत, और एक राज्‍य दोसर राज्‍य सँ। बहुतो ठाम मे अकाल पड़त आ भूकम्‍‍प होयत। ई सभ बात तँ कष्‍टक शुरुआते होयत! ");
INSERT INTO mai_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“मुदा अहाँ सभ सावधान रहू! किएक तँ लोक सभ अहाँ सभ केँ पकड़ि कऽ दण्‍ड लगबयबाक लेल पंच सभक समक्ष लऽ जायत आ सभाघर सभ मे अहाँ सभ केँ कोड़ा सँ पिटबाओत। हमरा कारणेँ अहाँ सभ राज्‍यपाल सभ और राजा सभक समक्ष ठाढ़ कयल जायब, और हुनका सभ केँ अहाँ सभ हमरा बारे मे गवाही देब। ");
INSERT INTO mai_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","अन्‍तिम समय सँ पहिने परमेश्‍वरक शुभ समाचारक प्रचार सभ जाति मे होयब आवश्‍यक अछि। ");
INSERT INTO mai_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","और जखन लोक अहाँ सभ केँ पकड़ि कऽ दण्‍ड लगबयबाक लेल कचहरी मे लऽ जायत तँ ओहि सँ पहिने एकर चिन्‍ता नहि करब जे हम की कहब। बाजऽ वला अहाँ अपने नहि होयब, पवित्र आत्‍मा होयताह, तेँ ओहि समय मे अहाँ केँ मोन मे जे बात देल जाय वैह बात बाजब। ");
INSERT INTO mai_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“भाय भाय केँ, और बाबू अपना बेटा केँ मृत्‍युदण्‍डक लेल पकड़बाओत, और बेटा-बेटी अपन माय-बाबूक विरोधी भऽ कऽ मरबा देत। ");
INSERT INTO mai_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","अहाँ सभ सँ सभ केओ एहि लेल घृणा करत जे अहाँ सभ हमर लोक छी। मुदा जे व्‍यक्‍ति अन्‍त तक स्‍थिर रहत से उद्धार पाओत। ");
INSERT INTO mai_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“मुदा जखन अहाँ सभ ‘विनाश करऽ वला घृणित वस्‍तु’ केँ ओहिठाम ठाढ़ देखब जाहि ठाम नहि होयबाक चाही—पढ़ऽ वला ई बात ध्‍यान दऽ कऽ बुझू!—तखन जे सभ यहूदिया प्रदेश मे होअय से सभ पहाड़ पर भागि जाय। ");
INSERT INTO mai_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","जे छत पर होअय से उतरि कऽ कोनो सामान लेबाक लेल घर मे नहि जाओ—ओहो भागि जाओ। ");
INSERT INTO mai_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","और जे खेत मे होअय से अपन ओढ़ना लेबाक लेल घूमि कऽ नहि आबओ। ");
INSERT INTO mai_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ओहि समय मे जे स्‍त्रीगण सभ गर्भवती होयत वा जकरा दूधपीबा बच्‍चा होयतैक, तकरा सभ केँ कतेक कष्‍ट होयतैक! ");
INSERT INTO mai_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","प्रार्थना करू जे ई सभ बात जाड़क समय मे नहि होअय! ");
INSERT INTO mai_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","कारण ओहि समय मे एहन कष्‍ट होयत जे शुरू सँ, जखन परमेश्‍वर पृथ्‍वीक सृष्‍टि कयलनि, आइ तक कहियो नहि भेल अछि, आ ने फेर कहियो होयत। ");
INSERT INTO mai_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","परमेश्‍वर ओहि समय केँ जँ घटा नहि देने रहितथि, तँ केओ नहि बँचैत। मुदा परमेश्‍वर अपन चुनल लोकक कारणेँ ओहि समय केँ घटा देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“ओहि समय मे जँ केओ अहाँ सभ केँ कहत जे, ‘देखू! मसीह एतऽ छथि’, वा ‘ओतऽ छथि’ तँ ओहि बात पर विश्‍वास नहि करब। ");
INSERT INTO mai_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","कारण, ओहि समय मे झुट्ठा मसीह आ झूठ बाजि कऽ अपना केँ परमेश्‍वरक प्रवक्‍ता कहऽ वला सभ प्रगट होयत, और एहन आश्‍चर्यजनक बात आ चमत्‍कार सभ देखाओत जे, जँ सम्‍भव रहैत, तँ परमेश्‍वरक चुनल लोक सभ केँ सेहो बहका दैत। ");
INSERT INTO mai_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","मुदा अहाँ सभ होसियार रहू! हम अहाँ सभ केँ सभ बात पहिनहि कहि देलहुँ। ");
INSERT INTO mai_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“मुदा ओहि दिन सभ मे, एहि संकटक बाद, ‘सूर्य अन्‍हार भऽ जायत, चन्‍द्रमा इजोत नहि देत। ");
INSERT INTO mai_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","आकाश सँ तारा सभ खसत, और आकाशक शक्‍ति सभ हिलाओल जायत।’ ");
INSERT INTO mai_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","तखन लोक सभ मनुष्‍य-पुत्र केँ अपार शक्‍ति और महिमाक संग मेघ मे अबैत देखत। ");
INSERT INTO mai_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","तखन पृथ्‍वी सँ आकाश तक चारू दिस सँ ओ अपन चुनल लोक सभ केँ जमा करबाक लेल अपन स्‍वर्गदूत सभ केँ पठौताह। ");
INSERT INTO mai_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“आब अंजीरक गाछ सँ एकटा बात सिखू—जखन ओकर ठाढ़ि कोमल होमऽ लगैत छैक और ओहि मे नव पात निकलऽ लगैत छैक तखन अहाँ सभ बुझि जाइत छी जे गर्मीक समय आबि रहल अछि। ");
INSERT INTO mai_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","तहिना जखन अहाँ सभ ई बात सभ होइत देखब तखन बुझि लिअ जे समय लगचिआ गेल, हँ, ई बुझू जे ओ घरक मुँह पर आबि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","हम अहाँ सभ केँ सत्‍य कहैत छी जे एहि पीढ़ी केँ समाप्‍त होमऽ सँ पहिने ई सभ घटना निश्‍चित घटत। ");
INSERT INTO mai_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","आकाश और पृथ्‍वी समाप्‍त भऽ जायत, मुदा हमर वचन अनन्‍त काल तक रहत। ");
INSERT INTO mai_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“मुदा एहि घटना सभक दिन वा समय केओ नहि जनैत अछि, स्‍वर्गदूतो सभ नहि आ पुत्रो नहि—मात्र पिता जनैत छथि। ");
INSERT INTO mai_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","होसियार रहू! बाट तकैत रहू आ प्रार्थना करैत रहू! अहाँ सभ तँ नहि जनैत छी जे ओ समय कहिया होयत। ");
INSERT INTO mai_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ई बात एहन अछि जेना एक आदमी यात्रा पर परदेश जाय लगलाह। जाय सँ पहिने ओ अपन घरक लेल नोकर सभ केँ अपन-अपन जबाबदेही देलनि, और चौकीदार केँ पहरा देबाक लेल आज्ञा देलनि। ");
INSERT INTO mai_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","तहिना अहाँ सभ बाट तकैत रहू, किएक तँ अहाँ नहि जनैत छी जे घरक मालिक कखन फिरि औताह—साँझ, आधा राति, भोरहरिया, वा भिनसर मे। ");
INSERT INTO mai_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","एना नहि होअय जे ओ अचानक आबि कऽ अहाँ सभ केँ सुतल पौताह। ");
INSERT INTO mai_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","अहाँ सभ केँ हम जे कहैत छी से सभ केँ कहैत छी—होसियार रहू!” ");
INSERT INTO mai_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","फसह-पाबनि और “बिनु खमीरक रोटी वला पाबनि” होमऽ मे दू दिन बाँकी छल। मुख्‍यपुरोहित और धर्मशिक्षक सभ यीशु केँ कोन तरहेँ छल सँ पकड़ब और मारि देब, तकर उपाय तकैत छलाह। ");
INSERT INTO mai_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","मुदा ओ सभ कहलनि जे, “पाबनिक समय मे नहि। एना नहि होअय जे जनता उपद्रव करय।” ");
INSERT INTO mai_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","यीशु बेतनिया गाम मे सिमोन नामक एक आदमी, जिनका पहिने कुष्‍ठ-रोग भेल छलनि, तिनका घर मे भोजन करैत छलाह। तखने एकटा स्‍त्रीगण संगमरमरक बर्तन मे जटामासी नामक बहुत दामी तेल अनलनि। बर्तन फोड़ि कऽ तेल हुनका माथ पर ढारि देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","लेकिन ओहिठाम बैसल किछु लोक खिसिआ कऽ एक-दोसर केँ कहऽ लागल जे, “ई दामी तेल किएक बरबाद कयल गेल? ");
INSERT INTO mai_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ई तँ एक वर्षक मजदूरी सँ बेसी मे बेचि कऽ गरीब सभ मे बाँटल जा सकैत छल!” और ओहि स्‍त्री केँ डाँटऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","मुदा यीशु कहलथिन, “हिनका छोड़ि दिऔन! हिनका किएक तंग करैत छिऐन? हमरा लेल बहुत बढ़ियाँ काज कयलनि। ");
INSERT INTO mai_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","गरीब सभ तँ अहाँ सभक संग सभ दिन रहत, और अहाँ सभ केँ जहिया मोन होयत तहिया ओकरा सभक सहायता कऽ सकब। मुदा हम अहाँ सभक संग सभ दिन नहि रहब। ");
INSERT INTO mai_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ई जे किछु कऽ सकैत छलीह से कयलनि। ई पहिनहि सँ हमरा देह मे तेल लगा कऽ हम जे कबर मे राखल जायब तकर तैयारी कयलनि। ");
INSERT INTO mai_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","हम अहाँ सभ केँ सत्‍य कहैत छी जे, संसार भरि मे जतऽ कतौ हमर शुभ समाचारक प्रचार कयल जायत, ततऽ एहि स्‍त्रीगणक स्‍मरण मे हिनकर एहि काजक चर्चा सेहो कयल जायत।” ");
INSERT INTO mai_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","तखन यहूदा इस्‍करियोती, जे बारह शिष्‍य मे सँ एक छल, यीशु केँ मुख्‍यपुरोहित सभक हाथ मे पकड़यबाक योजना बनयबाक लेल हुनका सभक ओहिठाम गेल। ");
INSERT INTO mai_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","यहूदाक बात सुनि कऽ मुख्‍यपुरोहित सभ बहुत खुश भऽ गेलाह और ओकरा ई काज करबाक लेल पैसा देबाक वचन देलथिन। तेँ ओ यीशु केँ पकड़बयबाक अनुकूल अवसरक ताक मे रहऽ लागल। ");
INSERT INTO mai_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","बिनु खमीरक रोटी वला पाबनिक पहिल दिन, जाहि दिन मे फसह-भोजक भेँड़ा बलिदान करबाक प्रथा छल, शिष्‍य सभ यीशु सँ पुछलथिन जे, “फसह-पाबनिक भोजक व्‍यवस्‍था अहाँक लेल हम सभ कतऽ ठीक करू?” ");
INSERT INTO mai_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","यीशु दूटा शिष्‍य सभ केँ ई कहि कऽ पठौलनि जे, “शहर मे जाउ। ओतऽ घैल मे पानि लऽ जाइत एक पुरुष अहाँ सभ केँ भेटत, ओकरा पाछाँ-पाछाँ जाउ। ");
INSERT INTO mai_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","जाहि घर मे ओ प्रवेश करत ओहि घरक मालिक केँ कहबनि जे, ‘गुरुजी पुछैत छथि जे हमर अतिथि-घर कतऽ अछि जतऽ हम अपना शिष्‍य सभक संग फसह-भोज खायब?’ ");
INSERT INTO mai_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ओ अहाँ सभ केँ उपरका तल्‍ला पर एक नमहर कोठली देखौताह जाहि मे सभ किछु तैयार रहत। ओतहि अहाँ सभ अपना सभक भोजक तैयारी करू।” ");
INSERT INTO mai_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","दूनू शिष्‍य विदा भऽ कऽ शहर मे पहुँचलाह, और जहिना यीशु हुनका सभ केँ कहने छलथिन, ठीक ओहिना सभ किछु भेटलनि, और ओ सभ ओतऽ फसह-भोजक तैयारी कयलनि। ");
INSERT INTO mai_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ओहि साँझ मे यीशु अपन बारहो शिष्‍यक संग ओतऽ पहुँचलाह। ");
INSERT INTO mai_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","भोजन करैत काल यीशु कहऽ लगलाह जे, “हम अहाँ सभ केँ सत्‍य कहैत छी जे, अहाँ सभ मे सँ एक गोटे हमरा पकड़बा देत, एक गोटे जे हमरा संग भोजन सेहो कऽ रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","शिष्‍य सभ दुखी भऽ कऽ एक-एक कऽ हुनका सँ पुछऽ लगलनि जे, “ओ हम तँ नहि छी?!” ");
INSERT INTO mai_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","यीशु हुनका सभ केँ कहलथिन, “ओ अहाँ बारहो मे सँ एक अछि जे हमरा संग बट्टा मे रोटी केँ बोड़ैत अछि। ");
INSERT INTO mai_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","मनुष्‍य-पुत्रक सम्‍बन्‍ध मे जहिना धर्मशास्‍त्र मे लिखल गेल अछि तहिना तँ ओ चलिए जायत, मुदा धिक्‍कार अछि ओहि मनुष्‍य केँ जे मनुष्‍य-पुत्र केँ पकड़बा रहल अछि। ओकरा लेल तँ नीक ई रहितैक जे ओ जन्‍मे नहि लेने रहैत।” ");
INSERT INTO mai_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ओ सभ जखन भोजन कऽ रहल छलाह तँ यीशु रोटी लेलनि आ परमेश्‍वर केँ धन्‍यवाद देलनि। ओ रोटी केँ तोड़ि कऽ शिष्‍य सभ केँ देलथिन आ कहलथिन, “लिअ, ई हमर देह अछि।” ");
INSERT INTO mai_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","तखन बाटी हाथ मे लेलनि, और परमेश्‍वर केँ धन्‍यवाद दऽ कऽ हुनका सभ केँ देलथिन। ओ सभ गोटे ओहि मे सँ पिलनि। ");
INSERT INTO mai_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ओ हुनका सभ केँ कहलथिन, “ई परमेश्‍वर आ मनुष्‍यक बीच विशेष सम्‍बन्‍ध स्‍थापित करऽ वला हमर खून अछि, जे बहुत लोकक लेल बहाओल जा रहल अछि। ");
INSERT INTO mai_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","हम अहाँ सभ केँ सत्‍य कहैत छी जे, जाबत तक परमेश्‍वरक राज्‍य मे हम नवका अंगूरक रस नहि पीब, ताबत तक अंगूरक रस फेर नहि पीब।” ");
INSERT INTO mai_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","तकरबाद एक भजन गाबि कऽ ओ सभ जैतून पहाड़ पर चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","तखन यीशु हुनका सभ केँ कहलथिन, “अहाँ सभ गोटे अपना विश्‍वास मे डगमगायब, किएक तँ धर्मशास्‍त्र मे लिखल अछि जे परमेश्‍वर कहने छथि, ‘हम चरबाह केँ मारि देबैक, और भेँड़ा सभ छिड़िया जायत।’ ");
INSERT INTO mai_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","मुदा मृत्‍यु सँ फेर जीवित भऽ गेलाक बाद हम अहाँ सभ सँ पहिने गलील प्रदेश जायब।” ");
INSERT INTO mai_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","एहि पर पत्रुस हुनका कहलथिन, “चाहे सभ केओ विश्‍वास मे डगमगायत, मुदा हम नहि डगमगायब!” ");
INSERT INTO mai_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","यीशु हुनका कहलथिन, “हम अहाँ केँ सत्‍य कहैत छी जे, आइए राति मे, अहाँ हमरा अस्‍वीकार करब। मुर्गा केँ दू बेर बाजऽ सँ पहिने अहाँ तीन बेर लोक केँ कहबैक जे, हम ओकरा चिन्‍हबो नहि करैत छिऐक।” ");
INSERT INTO mai_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","मुदा पत्रुस आरो जोर सँ कहलथिन जे, “हमरा जँ अहाँक संग मरहो पड़त तैयो हम किन्‍नहुँ नहि अहाँ केँ अस्‍वीकार करब।” आरो सभ शिष्‍य सेहो यैह बात कहलथिन। ");
INSERT INTO mai_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ओ सभ गतसमनी नामक एक जगह पर गेलाह। यीशु अपना शिष्‍य सभ केँ कहलथिन, “जाबत हम प्रार्थना करैत छी, ताबत अहाँ सभ एहिठाम बैसल रहू।” ");
INSERT INTO mai_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ओ पत्रुस, याकूब और यूहन्‍ना केँ अपना संग लऽ गेलाह। ओ मानसिक वेदना सँ व्‍याकुल होमऽ लगलाह, ");
INSERT INTO mai_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","आ हुनका सभ केँ कहलथिन, “हमर मोन व्‍यथा सँ एतेक व्‍याकुल अछि—मानू जे हम दुःख सँ मरऽ पर छी। अहाँ सभ एहिठाम रहि कऽ जागल रहू।” ");
INSERT INTO mai_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","एतेक कहि ओ कनेक आगाँ जा मुँह भरे खसि कऽ प्रार्थना कयलनि जे, सम्‍भव होअय तँ ई दुःखक समय हमरा लग सँ दूर भऽ जाय। ");
INSERT INTO mai_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ओ प्रार्थना करैत कहलनि जे, “हे बाबूजी! हे पिता! अहाँ तँ सभ किछु कऽ सकैत छी—ई दुःखक बाटी हमरा सँ हटा लिअ, मुदा तैयो हमर इच्‍छा नहि, अहींक इच्‍छा पूरा होअय।” ");
INSERT INTO mai_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","तकरबाद अपन शिष्‍य सभ लग आबि कऽ हुनका सभ केँ सुतल देखलथिन। ओ पत्रुस केँ कहलथिन, “सिमोन! सुतल छी की? की एको घण्‍टा जागल रहितहुँ से अहाँ केँ पार नहि लागल? ");
INSERT INTO mai_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","परीक्षा मे नहि पड़ि जाउ ताहि लेल अहाँ सभ जागल रहू आ प्रार्थना करैत रहू। आत्‍मा तँ तैयार अछि मुदा शरीर कमजोर।” ");
INSERT INTO mai_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","यीशु फेर जा कऽ पहिने जकाँ प्रार्थना कयलनि। ");
INSERT INTO mai_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ओ जखन प्रार्थना कऽ कऽ शिष्‍य सभ लग अयलाह तँ ओ सभ फेर सुतल छलाह। हुनकर सभक आँखि नीन सँ भारी भऽ गेल छलनि। आब यीशु केँ की जबाब दिऔन से हिनका सभ केँ किछु नहि फुरयलनि। ");
INSERT INTO mai_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","यीशु फेर तेसर बेर हुनका सभ लग अयलाह और कहलथिन, “एखनो तक सुतिए रहल छी आ आरामे कऽ रहल छी? आब भऽ गेल! समय आबि गेल—देखू आब मनुष्‍य-पुत्र पापी सभक हाथ मे पकड़बाओल जा रहल अछि। ");
INSERT INTO mai_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","उठू-उठू! चलू! देखू, हमरा पकड़बाबऽ वला आबि गेल अछि!” ");
INSERT INTO mai_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","यीशु ई कहिए रहल छलाह कि यहूदा, जे बारह शिष्‍य मे सँ एक छल, पहुँचि गेल। ओकरा संग लोकक भीड़ छलैक, और सभक हाथ मे तरुआरि और लाठी छल। ओकरा सभ केँ मुख्‍यपुरोहित, धर्मशिक्षक, और बूढ़-प्रतिष्‍ठित लोकनि पठौने छलाह। ");
INSERT INTO mai_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","यीशु केँ पकड़बाबऽ वला ओकरा सभ केँ ई संकेत देने छलैक जे, “हम जकरा चुम्‍मा लेब, वैह होयत—अहाँ सभ ओकरे पकड़ू आ घेरि कऽ पहरा मे लऽ जायब।” ");
INSERT INTO mai_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","यहूदा तुरत यीशुक लग मे जा कऽ कहलकनि, “गुरुजी!” आ हुनका चुम्‍मा लेलकनि। ");
INSERT INTO mai_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ओ सभ हुनका तुरत पकड़ि कऽ बन्‍दी बना लेलकनि। ");
INSERT INTO mai_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ओहि ठाम ठाढ़ एक आदमी तरुआरि निकालि कऽ महापुरोहितक टहलू पर चला कऽ ओकर एकटा कान उड़ा देलनि। ");
INSERT INTO mai_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","यीशु ओकरा सभ केँ कहलथिन, “की अहाँ सभ हमरा विद्रोह मचाबऽ वला बुझि कऽ, लाठी और तरुआरि लऽ कऽ पकड़ऽ अयलहुँ? ");
INSERT INTO mai_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","सभ दिन हम मन्‍दिर मे शिक्षा दैत अहाँ सभक संग छलहुँ, ततऽ अहाँ सभ हमरा नहि पकड़लहुँ। मुदा ई सभ एना एहि लेल भेल जे धर्मशास्‍त्र मे लिखल बात पूरा होअय।” ");
INSERT INTO mai_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","तखन सभ शिष्‍य हुनका छोड़ि कऽ भागि गेलनि। ");
INSERT INTO mai_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ओहिठाम एक नवयुवक सेहो छल जे यीशुक पाछाँ-पाछाँ चलैत छल। ओ अपना देह पर मात्र चद्दरि लपेटने रहय। लोक सभ ओकरो पकड़ऽ लागल ");
INSERT INTO mai_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","लेकिन ओ चद्दरि ओकरा सभक हाथ मे छोड़ि कऽ नंगटे दौड़ैत भागल। ");
INSERT INTO mai_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","तखन यीशु केँ महापुरोहितक ओहिठाम लऽ गेलनि, जाहिठाम सभ मुख्‍यपुरोहित, बूढ़-प्रतिष्‍ठित लोक और धर्मशिक्षक सभ जमा भेल छलाह। ");
INSERT INTO mai_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पत्रुस सेहो किछु दूरे रहि कऽ यीशुक पाछाँ-पाछाँ महापुरोहितक अङने मे पैसि गेलाह। ओ सिपाही सभक संग घूर लग बैसि कऽ आगि तापऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","मुख्‍यपुरोहित सभ और पूरा धर्म-महासभाक सदस्‍य सभ यीशु केँ मृत्‍युदण्‍डक जोगरक बनयबाक लेल हुनका विरोध मे प्रमाण सभ तकैत छलाह, मुदा किछु नहि भेटलनि। ");
INSERT INTO mai_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","कारण बहुत लोक हुनका विरोध मे झूठ गवाही देलक लेकिन ओकरा सभक बात एक-दोसर सँ नहि मिललैक। ");
INSERT INTO mai_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","तखन किछु लोक उठि कऽ हुनका विरोध मे झूठ गवाही दैत कहलक जे, ");
INSERT INTO mai_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“हम सभ ओकरा ई कहैत सुनलहुँ अछि जे, ‘ई हाथ सँ बनाओल मन्‍दिर केँ हम तोड़ि देब और तीन दिनक बाद हम दोसर बनायब जे मनुष्‍यक हाथ सँ बनाओल नहि होयत।’ ” ");
INSERT INTO mai_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","मुदा तैयो ओकरा सभक बात एक-दोसर सँ नहि मिलैत छल। ");
INSERT INTO mai_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","तखन महापुरोहित सभाक बीच मे ठाढ़ भऽ कऽ यीशु सँ पुछलथिन जे, “की अहाँ कोनो उत्तर नहि देब? ई गवाह सभ अहाँक विरोध मे केहन बात सभ कहि रहल अछि?” ");
INSERT INTO mai_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","मुदा यीशु चुप रहि कऽ कोनो उत्तर नहि देलथिन। फेर महापुरोहित हुनका पुछलथिन जे, “की अहाँ उद्धारकर्ता-मसीह छी? परमधन्‍य परमेश्‍वरक पुत्र छी?” ");
INSERT INTO mai_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","यीशु कहलथिन, “हँ, हम छी। और अहाँ सभ मनुष्‍य-पुत्र केँ सर्वशक्‍तिमान परमेश्‍वरक दहिना कात बैसल और आकाशक मेघ मे अबैत देखब।” ");
INSERT INTO mai_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ई सुनि महापुरोहित अपन वस्‍त्र फाड़ि कऽ कहलथिन, “आब आरो गवाह सभक की आवश्‍यकता? ");
INSERT INTO mai_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","अहाँ सभ एकरा परमेश्‍वरक निन्‍दा करैत सुनबे कयलहुँ—आब अहाँ सभक की विचार?” सभ हुनका मृत्‍युदण्‍डक जोगरक ठहरौलकनि। ");
INSERT INTO mai_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","किछु लोक हुनका पर थूक फेकऽ लगलनि, हुनका आँखि पर पट्टी बान्‍हि कऽ हुनका मुक्‍का मारऽ लगलनि और कहलकनि जे, “यौ अन्‍तर्यामी, कहल जाओ! अपने केँ के मारलक?” सिपाही सभ सेहो हुनका थप्‍पड़ मारलकनि। ");
INSERT INTO mai_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","एहि समय मे पत्रुस नीचाँ आङन मे छलाह। महापुरोहितक एक टहलनी आबि कऽ ");
INSERT INTO mai_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","पत्रुस केँ आगि तपैत देखि हुनकर मुँह ठिकिअबैत कहलकनि जे, “अहूँ एहि नासरत-निवासी यीशुक संग छलहुँ!” ");
INSERT INTO mai_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","मुदा पत्रुस अस्‍वीकार करैत कहलथिन, “तोँ की बाजि रहल छेँ से हमरा बुझहो मे नहि अबैत अछि आ ने ओहि बात केँ हम जनैत छी।” और ओहिठाम सँ हटि कऽ आङनक मुँह पर चल गेलाह, आ मुर्गा बाजल। ");
INSERT INTO mai_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","फेर ओ टहलनी हुनका देखि कऽ ओहिठाम ठाढ़ लोक सभ केँ कहलकैक जे, “ई आदमी ओकरे सभ मे सँ केओ अछि!” ");
INSERT INTO mai_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","मुदा पत्रुस फेर अस्‍वीकार कयलनि। किछु कालक बाद ओहिठाम ठाढ़ लोक सभ पत्रुस केँ कहलकनि जे, “निश्‍चय तोँ ओकरे सभ मे सँ छह! तोँहूँ तँ गलीले प्रदेशक छह!” ");
INSERT INTO mai_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","एहि पर ओ सपत खा कऽ अपना केँ सरापऽ लगलाह और कहलथिन, “जाहि व्‍यक्‍तिक बारे मे अहाँ सभ बाजि रहल छी, तकरा हम नहि चिन्‍हैत छी!” ");
INSERT INTO mai_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","तखने मुर्गा दोसर बेर बाजि उठल। तखन पत्रुस केँ ओ बात मोन पड़ि गेलनि जे यीशु हुनका कहने छलथिन जे, “मुर्गा केँ दू बेर बाजऽ सँ पहिने अहाँ हमरा तीन बेर अस्‍वीकार करब।” और ओ भोकासी पाड़ि कऽ कानऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","प्रात भेने भोरे-भोर मुख्‍यपुरोहित, बूढ़-प्रतिष्‍ठित सभ, धर्मशिक्षक सभ, और धर्म-महासभाक आरो सभ सदस्‍य निर्णय कऽ कऽ, यीशु केँ बान्‍हि देलथिन, और हुनका लऽ जा कऽ राज्‍यपाल पिलातुसक जिम्‍मा मे लगा देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पिलातुस हुनका सँ पुछलथिन जे, “की अहाँ यहूदी सभक राजा छी?” यीशु उत्तर देलथिन, “अहाँ अपने कहि रहल छी।” ");
INSERT INTO mai_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","तखन मुख्‍यपुरोहित सभ हुनका पर बहुत बातक दोष लगाबऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","पिलातुस हुनका सँ फेर पुछलथिन जे, “की अहाँ कोनो उत्तर नहि देब? देखू, ई सभ अहाँ पर कतेक आरोप लगा रहल छथि!” ");
INSERT INTO mai_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","मुदा यीशु तैयो कोनो उत्तर नहि देलथिन। एहि सँ पिलातुस केँ बहुत आश्‍चर्य लगलनि। ");
INSERT INTO mai_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","प्रत्‍येक साल फसह-पाबनिक अवसर पर राज्‍यपाल जनताक माँगक अनुसार एक कैदी केँ छोड़ि दैत छलाह। ");
INSERT INTO mai_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","एहि बेर आरो क्रान्‍तिकारी सभक संग जहल मे एक बरब्‍बा नामक कैदी छल जे आन्‍दोलन मे हत्‍या कयने छल। ");
INSERT INTO mai_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","भीड़ पिलातुसक लग मे आबि कऽ हुनका सँ माँग कयलकनि जे ओ अपन प्रथाक अनुसार ओकरा सभक लेल एक कैदी केँ छोड़ि देथि। ");
INSERT INTO mai_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ओ ओकरा सभ केँ उत्तर देलथिन जे, “की अहाँ सभ चाहैत छी जे हम अहाँ सभक लेल ‘यहूदी सभक राजा’ केँ छोड़ि दी?” ");
INSERT INTO mai_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ओ जनैत छलाह जे मुख्‍यपुरोहित सभ यीशु केँ ईर्ष्‍याक कारणेँ पकड़बौने छथि। ");
INSERT INTO mai_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","मुदा मुख्‍यपुरोहित सभ भीड़क लोक केँ एहि बातक लेल भड़कौलनि जे ओ सभ यीशु केँ नहि, बल्‍कि बरब्‍बा केँ छोड़ि देबाक लेल पिलातुस सँ माँग करय। ");
INSERT INTO mai_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","पिलातुस ओकरा सभ केँ फेर कहलथिन, “तखन एकरा लऽ कऽ हम की करिऔक जकरा अहाँ सभ ‘यहूदी सभक राजा’ कहैत छी?” ");
INSERT INTO mai_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","एहि पर ओ सभ बहुत जोर-जोर सँ हल्‍ला करऽ लागल जे, “ओकरा क्रूस पर चढ़ाउ!” ");
INSERT INTO mai_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","मुदा पिलातुस ओकरा सभ केँ कहलथिन, “किएक? ओ कोन अपराध कयने अछि?” लेकिन ओ सभ आरो जोर-जोर सँ चिचियाय लागल जे, “ओकरा क्रूस पर चढ़ाउ!” ");
INSERT INTO mai_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","तखन पिलातुस लोक सभ केँ खुश करबाक उद्देश्‍य सँ ओकरा सभक लेल बरब्‍बा केँ छोड़ि देलथिन और यीशु केँ कोड़ा सँ पिटबा कऽ क्रूस पर चढ़यबाक लेल सैनिक सभक जिम्‍मा लगा देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","तखन सैनिक सभ हुनका राजभवनक आङन मे, जकरा “प्राईटोरियम” कहल जाइत छैक, लऽ गेलनि। ओहिठाम पूरा सैनिक-दल बजाओल गेल। ");
INSERT INTO mai_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ओ सभ हुनका बैगनी रंगक राजसी वस्‍त्र पहिरा देलकनि, और काँटक मुकुट बना कऽ हुनका माथ पर रखलकनि। ");
INSERT INTO mai_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ओ सभ हुनका कहऽ लगलनि जे, “यहूदी सभक राजा, प्रणाम!” ");
INSERT INTO mai_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ओ सभ छड़ी लऽ कऽ बेर-बेर हुनका मूड़ी पर मारलकनि, हुनका पर थूक फेकलकनि, और ठेहुनिया दऽ कऽ गोड़ लगलकनि। ");
INSERT INTO mai_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ओ सभ एहि तरहेँ यीशुक मजाक उड़ौलाक बाद हुनका देह पर सँ बैगनी रंग वला वस्‍त्र निकालि लेलकनि आ हुनकर अपन कपड़ा फेर पहिरा देलकनि। तकरबाद ओ सभ हुनका क्रूस पर लटकयबाक लेल शहर सँ बाहर लऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","रस्‍ता मे कुरेन नगरक रहऽ वला सिमोन नामक एक आदमी, जे सिकन्‍दर और रूफुसक पिता छल, गाम सँ शहर दिस आबि रहल छल। ओकरा सिपाही सभ बलजोरी पकड़लक जे ओ यीशुक क्रूस उठा कऽ लऽ चलय। ");
INSERT INTO mai_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","यीशु केँ ओ सभ गुलगुता नामक जगह, जकर अर्थ अछि “खप्‍पड़ वला स्‍थान”, पर लऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ओतऽ केओ मूर्र नामक तीत दवाइ दारू मे मिला कऽ हुनका पिबाक लेल देबऽ लगलनि मुदा ओ नहि लेलनि। ");
INSERT INTO mai_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","तखन यीशु केँ हाथ-पयर मे काँटी ठोकि कऽ क्रूस पर टाँगि देलकनि। सिपाही सभ ककरा कोन कपड़ा भेटतैक ताहि लेल यीशुक कपड़ा पर चिट्ठा खसौलक। एहि तरहेँ ओ सभ हुनकर कपड़ा अपना मे बाँटि लेलक। ");
INSERT INTO mai_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","जखन ओ सभ यीशु केँ क्रूस पर चढ़ौलकनि तखन नौ बजे दिन छल। ");
INSERT INTO mai_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","हुनका विरोध मे जे दोष-पत्र लिखि कऽ टाँगल गेल ताहि पर ई लिखल छल, “यहूदी सभक राजा”। ");
INSERT INTO mai_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","हुनका संगे दूटा डाकू केँ सेहो क्रूस पर चढ़ाओल गेल, एकटा हुनकर दहिना कात और दोसर बामा कात। ");
INSERT INTO mai_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","तहिना धर्मशास्‍त्रक वचन पूरा भऽ गेल जाहि मे लिखल अछि जे, “ओ अपराधी सभ मे सँ बुझल गेलाह।” ");
INSERT INTO mai_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ओहि बाटे आबऽ-जाय वला लोक सभ माथ हिला-हिला कऽ हुनकर निन्‍दा करैत छलनि जे, “रे मन्‍दिर केँ तोड़ऽ वला और तीन दिन मे ओकरा बनाबऽ वला— ");
INSERT INTO mai_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","आब क्रूस पर सँ उतरि कऽ अपना केँ बचा!” ");
INSERT INTO mai_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","तहिना मुख्‍यपुरोहित लोकनि और धर्मशिक्षक सभ सेहो अपना मे यीशुक हँसी उड़बैत कहलनि, “ई आन लोक सभ केँ बचबैत रहल मुदा अपना केँ नहि बचा सकैत अछि! ");
INSERT INTO mai_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ई उद्धारकर्ता-मसीह, इस्राएलक राजा, एखन क्रूस पर सँ उतरि आबओ जाहि सँ हम सभ देखिऐक और विश्‍वास करिऐक!” यीशुक संग जे सभ क्रूस पर चढ़ाओल गेल छल, सेहो सभ हुनकर निन्‍दा करऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","बारह बजे दिन मे पूरा देश अन्‍हार-कुप्‍प भऽ गेल, और तीन बजे तक ओहिना रहल। ");
INSERT INTO mai_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","लगभग तीन बजे मे यीशु बहुत जोर सँ बजलाह जे, “एली, एली, लामा सबक्‍तनी?” जकर अर्थ ई अछि, “हे हमर परमेश्‍वर, हे हमर परमेश्‍वर, हमरा अहाँ किएक छोड़ि देलहुँ?” ");
INSERT INTO mai_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","लग मे ठाढ़ किछु लोक ई सुनि कहलक जे, “सुनू!—ओ एलियाह केँ बजा रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","एक आदमी दौड़ि कऽ गेल आ रूइ जकाँ एकटा एहन चीज जे पानि सोखैत अछि से लऽ कऽ तिताह दारू मे डुबा लेलक, तखन ओकरा लाठीक हूर पर अटका कऽ ऊपर हुनका मुँह लग पिबाक लेल देलकनि आ बाजल, “आब अपना सभ देखी जे एलियाह एकरा क्रूस पर सँ उतारबाक लेल अबैत छथि कि नहि।” ");
INSERT INTO mai_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","तकरबाद यीशु बहुत जोर सँ आवाज दैत अपन प्राण त्‍यागि देलनि। ");
INSERT INTO mai_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","मन्‍दिर मे जे परदा छलैक से ऊपर सँ नीचाँ तक चिरा कऽ दू भाग मे फाटि गेल। ");
INSERT INTO mai_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","रोमी कप्‍तान जे यीशुक सामने मे ठाढ़ छल, ई देखि जे यीशु कोना मरलाह बाजल, “सत्‍ये ई आदमी परमेश्‍वरक पुत्र छलाह!” ");
INSERT INTO mai_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","किछु स्‍त्रीगण सभ छलीह जे दूरे सँ देखि रहल छलीह। हुनका सभ मे मरियम मग्‍दलीनी, छोटका याकूब और योसेसक माय मरियम, और सलोमी सेहो छलीह। ");
INSERT INTO mai_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ई सभ गलील प्रदेश मे यीशुक संगे-संग घूमि कऽ हुनकर सेवा कयने छलीह। ओहिठाम आरो बहुत स्‍त्रीगण सेहो छलि जे हुनका संग यरूशलेम आयल छलि। ");
INSERT INTO mai_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ई सभ घटना विश्रामक दिन सँ एक दिन पहिने भेल छल, जाहि दिन विश्राम-दिनक लेल तैयारी कयल जाइत अछि। तेँ साँझ भेला पर ");
INSERT INTO mai_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","अरिमतिया नगरक यूसुफ नामक महासभाक एक प्रतिष्‍ठित सदस्‍य, जे परमेश्‍वरक राज्‍यक बाट सेहो तकैत छलाह, से साहसक संग पिलातुसक ओहिठाम जा कऽ यीशुक लास मँगलनि। ");
INSERT INTO mai_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","पिलातुस केँ आश्‍चर्य लगलनि जे यीशु एतेक जल्‍दी कोना मरि गेलाह, तेँ सेनाक कप्‍तान केँ बजबा कऽ ओकरा सँ पुछलथिन जे, “की यीशु एखने मरि गेल अछि?” ");
INSERT INTO mai_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","कप्‍तान सँ एहि बातक पता लगा कऽ पिलातुस यूसुफ केँ यीशुक लास लऽ जयबाक अनुमति दऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","यूसुफ मलमलक कपड़ा किनि कऽ यीशुक लास क्रूस पर सँ उतारि लेलनि और ओहि कपड़ा मे लपेटि देलथिन। तखन पाथर मे काटि कऽ बनाओल कबर मे लास केँ राखि देलथिन, और कबरक मुँह पर एक पाथर गुड़का कऽ लगा देलनि। ");
INSERT INTO mai_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मरियम मग्‍दलीनी आ योसेसक माय मरियम देखलनि जे यीशु कतऽ राखल गेलाह। ");
INSERT INTO mai_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","विश्रामक दिन बितला पर मरियम मग्‍दलीनी, याकूबक माय मरियम, और सलोमी जा कऽ सुगन्‍धित तेल किनलनि, जाहि सँ यीशुक लास पर लगबथि। ");
INSERT INTO mai_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","तखन प्रात भेने जे कि सप्‍ताहक पहिल दिन छल, भोरगरे सुर्योदय काल मे ओ सभ कबर पर गेलीह। ");
INSERT INTO mai_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","रस्‍ता मे एक-दोसर केँ कहैत छलीह जे, “अपना सभक लेल कबरक मुँह पर सँ पाथर केँ के हटा देत?” ");
INSERT INTO mai_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ओ पाथर तँ बहुत बड़का छल। तखन कबर दिस तकैत ओ सभ देखलनि जे पाथर हटाओल गेल अछि। ");
INSERT INTO mai_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ओ सभ कबर मे पैसि कऽ दहिना कात मे एक युवक केँ बैसल देखलनि, जे लम्‍बा उज्‍जर वस्‍त्र पहिरने छलाह। ओ सभ एकदम आश्‍चर्य-चकित भऽ गेलीह। ");
INSERT INTO mai_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","युवक हुनका सभ केँ कहलथिन जे “चकित नहि होउ! अहाँ सभ नासरतक निवासी यीशु केँ खोजैत छिऐन, जिनका क्रूस पर चढ़ाओल गेल छलनि। ओ जीबि उठलाह! एतऽ नहि छथि! देखू, एही जगह पर हुनका राखल गेल छलनि। ");
INSERT INTO mai_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","मुदा अहाँ सभ जाउ, और शिष्‍य सभ केँ—पत्रुस केँ सेहो—ई कहि देबनि जे, ‘ओ अहाँ सभ सँ पहिने, जहिना अहाँ सभ केँ कहने छलाह, गलील जा रहल छथि, ओतऽ हुनका सँ भेँट होयत।’ ” ");
INSERT INTO mai_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ओ स्‍त्रीगण सभ आश्‍चर्य सँ कँपैत कबर मे सँ निकलि कऽ भगलीह। ओ सभ डर सँ ककरो किछु नहि कहलथिन। ");
INSERT INTO mai_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","यीशु सप्‍ताहक पहिल दिन भोरे मृत्‍यु सँ जीबि उठि कऽ सभ सँ पहिने मरियम मग्‍दलीनी केँ देखाइ देलथिन, जकरा मे सँ ओ सातटा दुष्‍टात्‍मा निकालने रहथिन। ");
INSERT INTO mai_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ओ जा कऽ, यीशुक संगी सभ केँ, जे शोक सँ कनैत छलाह, ई समाचार कहलथिन। ");
INSERT INTO mai_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","मुदा मरियमक बात सुनि कऽ जे यीशु फेर जीबि उठलाह और ओ हमरा भेँट भेलाह, से बात ओ सभ नहि पतिअयलाह। ");
INSERT INTO mai_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","एकरा बाद जखन हुनका सभ मे सँ दू व्‍यक्‍ति गाम दिस जा रहल छलाह, तखन यीशु हुनका सभ केँ दोसर रूप मे दर्शन देलथिन। ");
INSERT INTO mai_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ई सभ घूमि आबि कऽ आरो शिष्‍य सभ केँ एहि घटनाक बारे मे सुनौलनि, लेकिन हुनको सभक बात ओ सभ नहि पतिअयलाह। ");
INSERT INTO mai_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","बाद मे एगारहो शिष्‍य सभ केँ भोजन करैत काल यीशु हुनका सभ केँ दर्शन देलथिन। ओ हुनका सभक अविश्‍वास और मोनक कठोरताक कारणेँ हुनका सभ केँ डँटलथिन, किएक तँ ओ सभ ओहि व्‍यक्‍ति सभक बात केँ नहि पतिआयल छलाह जे व्‍यक्‍ति सभ यीशु केँ मृत्‍युक बाद जीवित देखने छलाह। ");
INSERT INTO mai_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ओ हुनका सभ केँ कहलथिन, “पूरा संसार मे जा कऽ सभ मनुष्‍य केँ शुभ समाचार सुनबिऔक। ");
INSERT INTO mai_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","जे व्‍यक्‍ति विश्‍वास करत और बपतिस्‍मा लेत तकरा उद्धार होयतैक, मुदा जे व्‍यक्‍ति विश्‍वास नहि करत से दोषी ठहराओल जायत। ");
INSERT INTO mai_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","जे सभ विश्‍वास करत से सभ ई चिन्‍ह सभ देखाओत—हमरा नाम सँ दुष्‍टात्‍मा केँ निकालत, अनजान भाषा मे बाजत, ");
INSERT INTO mai_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","जँ साँप उठा लेत वा विष पी लेत तँ ओकरा सभ केँ कोनो हानि नहि होयतैक। बिमार आदमी सभ पर हाथ राखत तँ ओ स्‍वस्‍थ भऽ जायत।” ");
INSERT INTO mai_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","तखन प्रभु यीशु शिष्‍य सभ सँ बात कयलाक बाद स्‍वर्ग मे उठा लेल गेलाह, और परमेश्‍वरक दहिना कात बैसलाह। ");
INSERT INTO mai_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","शिष्‍य सभ बाहर जा कऽ सभ जगह मे शुभ समाचारक प्रचार कयलनि। प्रभु हुनका सभक सहायता करैत रहलथिन, और प्रचारक संगे-संग जे चमत्‍कार देखाओल गेल तकरा द्वारा ओ अपन शुभ समाचारक सत्‍यता प्रमाणित कयलथिन।");
INSERT INTO mai_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","आदरणीय थियुफिलुस, बहुतो लोक हमरा सभक मध्‍य घटल घटनाक विवरण लिखने छथि। ");
INSERT INTO mai_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ओ सभ अपन विवरण तिनका सभक बातक आधार पर लिखलनि, जे शुरुए सँ एहि घटना सभक प्रत्‍यक्षदर्शी छलाह आ शुभ समाचारक प्रचारक सेवा मे लागल छलाह, जिनका सभक द्वारा हमरा सभ केँ एहि बात सभक जानकारी भेटल। ");
INSERT INTO mai_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","तेँ शुरुए सँ सभ बातक सावधानीपूर्बक अध्‍ययन कऽ कऽ हमरा उचित बुझायल जे हमहूँ अहाँक लेल क्रमानुसार तकर सम्‍पूर्ण विवरण लिखी, ");
INSERT INTO mai_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","जाहि सँ अहाँ जानि सकी जे जाहि बातक शिक्षा अहाँ केँ भेटल अछि से एकदम सत्‍य अछि। ");
INSERT INTO mai_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहूदिया प्रदेशक राजा हेरोदक समय मे जकरयाह नामक एक पुरोहित छलाह। ओ पुरोहित सभक ताहि समूहक छलाह जे अबियाहक समूह कहबैत छल। हुनकर स्‍त्री इलीशिबा सेहो पुरोहित हारूनक वंशक छलीह। ");
INSERT INTO mai_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ओ दूनू गोटे परमेश्‍वरक नजरि मे धर्मी छलाह। हुनका सभक जीवन परमेश्‍वरक सभ आज्ञा और विधि-विधानक अनुसार निर्दोष छलनि। ");
INSERT INTO mai_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","मुदा हुनका सभ केँ कोनो सन्‍तान नहि छलनि, कारण इलीशिबा बाँझ छलीह, आ हुनका दूनू गोटेक अवस्‍था ढरि गेल छलनि। ");
INSERT INTO mai_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","एक दिन मन्‍दिर मे सेवा करबाक पार जखन जकरयाहक समूह केँ भेल आ जकरयाह परमेश्‍वरक सामने पुरोहितक काज कऽ रहल छलाह, ");
INSERT INTO mai_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","तँ पुरोहित सभक प्रथाक अनुसार हुनका नामक एक चिट्ठा निकलल जे ओ मन्‍दिर मे जा कऽ धूप जरबथि। ");
INSERT INTO mai_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","धूप जरयबाक समय मे लोकक भीड़ बाहर प्रार्थना कऽ रहल छल। ");
INSERT INTO mai_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","तखन परमेश्‍वरक एक स्‍वर्गदूत धूप-वेदीक दहिना कात ठाढ़ भऽ जकरयाह केँ दर्शन देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","हुनका देखि जकरयाह घबड़ा गेलाह आ भयभीत भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","मुदा स्‍वर्गदूत हुनका कहलथिन, “यौ जकरयाह, नहि डेराउ, कारण परमेश्‍वर लग अहाँक प्रार्थना सुनल गेल अछि। अहाँक स्‍त्री इलीशिबा एक पुत्र केँ जन्‍म देतीह। अहाँ ओकर नाम यूहन्‍ना राखब। ");
INSERT INTO mai_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","अहाँ केँ खुशी आ आनन्‍द होयत। ओकर जन्‍म सँ बहुत लोक आनन्‍द मनाओत, ");
INSERT INTO mai_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","कारण, ओ प्रभुक नजरि मे महान् होयत। ओ मदिरा वा आरो कोनो तरहक निसा लागऽ वला वस्‍तु कहियो नहि पीत। ओ मायक पेटे सँ पवित्र आत्‍मा सँ परिपूर्ण होयत। ");
INSERT INTO mai_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ओ इस्राएलक बहुतो लोक केँ अपना प्रभु-परमेश्‍वर दिस घुमाओत। ");
INSERT INTO mai_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","आत्‍मा आ सामर्थ्‍य मे ओ एलियाह सन भऽ कऽ प्रभुक आगाँ चलत। ओ पिता-सन्‍तान सभक बीच मेल-मिलाप कराओत, आज्ञा उल्‍लंघन करऽ वला सभ केँ ओहन बुद्धि दियाओत जाहि सँ ओ सभ धार्मिकताक अनुसार चलत, आ एहि तरहेँ प्रभुक लेल एक योग्‍य प्रजा तैयार करतनि।” ");
INSERT INTO mai_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","एहि पर जकरयाह स्‍वर्गदूत केँ कहलथिन, “ई बात हम निश्‍चित रूप सँ कोना जानि सकैत छी? हम अपनो बूढ़ छी आ हमर घरवाली सेहो बुढ़ि छथि।” ");
INSERT INTO mai_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","स्‍वर्गदूत हुनका उत्तर देलथिन, “हम जिब्राएल छी। हम परमेश्‍वरक सामने उपस्‍थित रहैत छी। हम अहाँ सँ बात करबाक लेल आ ई खुशीक सम्‍बाद सुनयबाक लेल पठाओल गेल छी। ");
INSERT INTO mai_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","आब सुनू, जाहि दिन धरि ई बात पूरा नहि भऽ जायत, ताहि दिन धरि अहाँ बौक रहब, बाजि नहि सकब। कारण, हमर बात जे ठीक समय अयला पर पूरा होयत, ताहि पर अहाँ विश्‍वास नहि कयलहुँ।” ");
INSERT INTO mai_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","एम्‍हर लोक सभ जकरयाहक प्रतीक्षा कऽ रहल छल आ आश्‍चर्यित छल जे हुनका मन्‍दिर मे एतेक देरी किएक भऽ रहल छनि। ");
INSERT INTO mai_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ओ जखन बाहर अयलाह तँ ओकरा सभ सँ बाजि नहि सकलाह। ओ सभ बुझि गेल जे हिनका मन्‍दिर मे दर्शन भेटलनि अछि। ओ लोक सभ सँ इसारा सँ गप्‍प करैत छलाह कारण ओ बौक भऽ गेल छलाह। ");
INSERT INTO mai_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","अपन पुरहिताइक समयक पार समाप्‍त भेला पर ओ घर चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","किछु दिनक बाद जकरयाहक स्‍त्री इलीशिबा गर्भवती भेलीह। ओ पाँच महिना धरि कतौ नहि बहरयलीह। ");
INSERT INTO mai_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ओ कहैत छलीह, “प्रभु कतेक दयालु छथि! आब ओ हमरा पर कृपा कऽ कऽ समाज मे हमर कलंक केँ धो देलनि।” ");
INSERT INTO mai_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","इलीशिबाक गर्भक छठम मास मे परमेश्‍वर जिब्राएल स्‍वर्गदूत केँ गलील प्रदेशक नासरत नगर मे ");
INSERT INTO mai_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","एक कुमारि कन्‍या लग सम्‍बाद दऽ कऽ पठौलथिन। हुनकर विवाहक निश्‍चय दाऊदक वंशज यूसुफ नामक पुरुष सँ भेल छलनि। ओहि कुमारि कन्‍याक नाम मरियम छलनि। ");
INSERT INTO mai_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","स्‍वर्गदूत मरियम लग आबि कऽ कहलथिन, “मरियम, आनन्‍द मनाउ, परमेश्‍वर अहाँ पर कृपा कयलनि अछि। प्रभु अहाँक संग छथि।” ");
INSERT INTO mai_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","हुनकर एहि कथन सँ ओ बहुत घबड़ा गेलीह आ सोचऽ लगलीह जे, ई केहन बात कहि रहल छथि! ");
INSERT INTO mai_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","तखन स्‍वर्गदूत कहलथिन, “मरियम, भयभीत नहि होउ, परमेश्‍वर अहाँ सँ प्रसन्‍न छथि। ");
INSERT INTO mai_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","सुनू, अहाँ गर्भवती होयब आ पुत्र केँ जन्‍म देब। अहाँ हुनकर नाम यीशु राखि देबनि। ");
INSERT INTO mai_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ओ महान् होयताह आ परम-परमेश्‍वरक पुत्र कहौताह। प्रभु-परमेश्‍वर हुनकर पूर्वज दाऊदक सिंहासन हुनका देथिन। ");
INSERT INTO mai_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ओ याकूबक वंश पर अनन्‍त काल तक राज्‍य करताह और हुनकर राज्‍यक अन्‍त कहियो नहि होयतनि।” ");
INSERT INTO mai_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","मरियम स्‍वर्गदूत केँ कहलथिन, “ई होयत कोना? कारण हम तँ कुमारिए छी।” ");
INSERT INTO mai_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","स्‍वर्गदूत उत्तर देलथिन, “पवित्र आत्‍मा अहाँ पर उतरताह, और परम-परमेश्‍वरक सामर्थ्‍यक छाँह अहाँ पर रहत। तेँ जन्‍म लेनिहार पवित्र बालक परमेश्‍वरक पुत्र कहौताह। ");
INSERT INTO mai_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","एतबे नहि! अहाँक सम्‍बन्‍धी इलीशिबा केँ सेहो, बुढ़ारी अवस्‍था मे बच्‍चा होयतनि! ओ जे बाँझ कहबैत छलीह, तिनका आब छठम मासक गर्भ छनि। ");
INSERT INTO mai_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","परमेश्‍वरक लेल कोनो बात असम्‍भव नहि छनि।” ");
INSERT INTO mai_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","एहि पर मरियम कहलथिन, “हम परमेश्‍वरक दासी छियनि। अहाँ जहिना कहलहुँ तहिना हमरा संग होअय।” तकरबाद स्‍वर्गदूत हुनका ओतऽ सँ विदा भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","तखन मरियम यात्राक तैयारी कऽ कऽ विदा भेलीह और यहूदिया प्रदेशक ओहि पहाड़ी नगर मे जल्‍दी सँ गेलीह जतऽ जकरयाह आ इलीशिबा रहैत छलाह। ");
INSERT INTO mai_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ओ हुनका सभक घर मे प्रवेश कऽ कऽ इलीशिबा केँ नमस्‍कार कयलथिन। ");
INSERT INTO mai_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","जखन इलीशिबा मरियमक नमस्‍कार सुनलनि तँ हुनकर पेटक बच्‍चा कुदि उठलनि आ इलीशिबा पवित्र आत्‍मा सँ परिपूर्ण भऽ जोर सँ बाजि उठलीह, ");
INSERT INTO mai_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","“स्‍त्रीगण मे अहाँ धन्‍य छी, आ धन्‍य छथि ओ जिनका अहाँ जन्‍म देबनि। ");
INSERT INTO mai_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","मुदा हम कोन जोगरक छी जे हमर प्रभुक माय हमरा ओतऽ अयलीह? ");
INSERT INTO mai_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","अहाँक कहल नमस्‍कार शब्‍द जखने हमरा कान मे पड़ल, तखने हमर पेटक बच्‍चा खुशी सँ कुदि उठल। ");
INSERT INTO mai_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","धन्‍य छी अहाँ, कारण, अहाँ विश्‍वास कयलहुँ जे, प्रभु अहाँ केँ जे बात कहलनि, से पूरा होयत।” ");
INSERT INTO mai_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","तखन मरियम कहलनि, “हमर मोन प्रभुक स्‍तुति करैत अछि, ");
INSERT INTO mai_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","और हमर आत्‍मा हमर उद्धारकर्ता-परमेश्‍वरक कारणेँ अति आनन्‍दित अछि, ");
INSERT INTO mai_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","किएक तँ ओ अपना एहि तुच्‍छ दासी पर दया कयलनि। आब पुस्‍त-पुस्‍तानिक लोक हमरा धन्‍य कहत, ");
INSERT INTO mai_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","कारण, सर्वशक्‍तिमान प्रभु हमरा लेल महान् काज कयलनि अछि, हुनकर नाम पवित्र छनि! ");
INSERT INTO mai_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","हुनकर भय माननिहार लोक पर हुनकर कृपा पुस्‍त-पुस्‍तानि रहैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ओ अपन बाहुबल प्रगट कयने छथि। तकरा सभ केँ ओ छिन्‍न-भिन्‍न कऽ देने छथिन, जकर सभक मोन अहंकार सँ भरल छल। ");
INSERT INTO mai_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ओ शासक सभ केँ अपना सिंहासन सँ उतारि देने छथिन, आ नम्र सभ केँ पैघ बना देने छथिन। ");
INSERT INTO mai_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ओ भूखल सभ केँ नीक-नीक वस्‍तु सँ तृप्‍त कयने छथिन, आ धनवान सभ केँ खाली हाथ घुमा देने छथिन। ");
INSERT INTO mai_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ओ हमरा सभक पूर्वज लोकनि केँ देल अपन वचन अनुसार अपन सेवक इस्राएलक मदति कयलनि। ");
INSERT INTO mai_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","अब्राहम और हुनकर वंशज पर सदा दया करबाक अपना वचन केँ स्‍मरण रखलनि।” ");
INSERT INTO mai_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरियम करीब तीन मास तक इलीशिबाक संग रहि कऽ अपना घर चलि अयलीह। ");
INSERT INTO mai_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","जखन इलीशिबाक पूर मास भेलनि तँ हुनका बेटा भेलनि। ");
INSERT INTO mai_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","हुनकर पड़ोसी आ सम्‍बन्‍धी सभ ई बात सुनि जे प्रभु हुनका पर कतेकटा दया कयलथिन, हुनका संग खुशी मनौलनि। ");
INSERT INTO mai_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","आठम दिन ओ सभ बच्‍चा केँ खतनाक विधि करबाक लेल अयलाह, आ पिताक नाम पर बच्‍चाक नाम “जकरयाह” राखऽ लगलथिन, ");
INSERT INTO mai_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","मुदा हुनकर माय कहलथिन, “नहि! एकर नाम यूहन्‍ना रखबाक अछि।” ");
INSERT INTO mai_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","एहि पर ओ सभ कहलथिन, “अहाँक कुटुम्‍ब-परिवार मे ई नाम कहाँ किनको छनि!” ");
INSERT INTO mai_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","तखन ओ सभ बच्‍चाक पिता सँ इसारा कऽ कऽ पुछलथिन जे, अहाँ एकर की नाम राखऽ चाहैत छी? ");
INSERT INTO mai_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ओ पाटी मँगा कऽ लिखलनि, “एकर नाम यूहन्‍ना छैक।” एहि पर सभ चकित रहि गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","तखने हुनकर आवाज फुजि गेलनि आ परमेश्‍वरक स्‍तुति करैत बाजऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","एहि सँ लग-पास मे रहऽ वला सभ लोक मे डर सन्‍हिया गेलैक और यहूदिया प्रदेशक पहाड़ सभ मे सभतरि एहि सभ बातक चर्चा पसरि गेल। ");
INSERT INTO mai_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","एहि बातक विषय मे जे सभ सुनलक, से सभ अपना-अपना मोन मे एहि सभक बारे मे विचार करऽ लागल आ बाजल, “ई बालक की बनताह?” कारण, स्‍पष्‍ट छल जे प्रभुक आशिष हुनका पर छलनि। ");
INSERT INTO mai_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","यूहन्‍नाक पिता जकरयाह पवित्र आत्‍मा सँ परिपूर्ण भऽ भविष्‍यवाणी कयलनि जे, ");
INSERT INTO mai_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“इस्राएलक परमेश्‍वर, प्रभुक स्‍तुति होनि, कारण ओ अपन प्रजा लग आबि कऽ ओकरा मुक्‍ति देलनि। ");
INSERT INTO mai_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ओ अपन सेवक दाऊदक वंश मे हमरा सभक लेल एक सामर्थ्‍यवान उद्धारकर्ता उत्‍पन्‍न कयलनि अछि, ");
INSERT INTO mai_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","जेना कि ओ अपन चुनल प्रवक्‍ता सभक माध्‍यम सँ प्राचीन काल सँ कहने छलाह। ");
INSERT INTO mai_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ओ हमरा सभ केँ दुश्‍मन सभ सँ बचयबाक प्रतिज्ञा कयने रहथि, आ हमरा सभ केँ घृणा कयनिहार सभक हाथ सँ सुरक्षित रखबाक वचन देने रहथि। ");
INSERT INTO mai_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","ओ अपन ओहि वचन केँ पूरा कऽ कऽ हमरा पूर्वज लोकनि पर दया कयलनि अछि। ओ अपन ओहि पवित्र वचन केँ स्‍मरण रखने छलाह जे वचन ओ सपत खा कऽ हमरा सभक पुरखा अब्राहम केँ देने रहथिन जे, ");
INSERT INTO mai_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","हम तोरा सभ केँ शत्रु सभक हाथ सँ बचयबह; तोँ सभ निर्भयतापूर्बक जीवन भरि पवित्रता आ धार्मिकताक संग हमरा समक्ष हमर सेवा करबह। ");
INSERT INTO mai_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","आ हौ बौआ, तोँ परम-परमेश्‍वरक प्रवक्‍ता कहयबह, किएक तँ तोँ प्रभुक लेल बाट तैयार करबाक हेतु हुनका आगाँ-आगाँ चलबह। ");
INSERT INTO mai_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","तोँ हुनकर प्रजा केँ उद्धारक ज्ञान प्रदान करबहुन, जे उद्धार पापक क्षमा द्वारा भेटैत अछि, ");
INSERT INTO mai_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","आ से हमर सभक दयालु परमेश्‍वरक करुणाक कारणेँ अछि। एही करुणाक कारणेँ हमरा सभक लेल ऊपर सँ प्रकाश उगत, ");
INSERT INTO mai_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","जे अन्‍हार आ मृत्‍युक छाँह मे बैसल लोक सभ पर इजोत करत, और हमरा सभ केँ शान्‍तिक बाट पर आगाँ बढ़ाओत।” ");
INSERT INTO mai_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","बालक यूहन्‍ना बढ़ैत गेलाह आ आत्‍मिक रूप सँ सबल होइत गेलाह। ओ जा धरि इस्राएली सभक बीच अपन काज शुरू नहि कयलनि, ता धरि निर्जन क्षेत्र मे वास कयलनि। ");
INSERT INTO mai_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ओहि समय मे कैसर औगुस्‍तुस आदेश देलनि जे सम्‍पूर्ण रोम साम्राज्‍‍यक जनगणना कयल जाय। ");
INSERT INTO mai_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","एहि तरहक ई पहिल जनगणना छल, आ ई ताहि समय मे भेल जखन क्‍विरीनियुस सीरिया प्रदेशक राज्‍यपाल छलाह। ");
INSERT INTO mai_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","सभ केओ नाम लिखयबाक लेल अपन-अपन पैतृक नगर जाय लागल। ");
INSERT INTO mai_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","यूसुफ राजा दाऊदक खानदान आ वंशक छलाह, तेँ ओ अपन नाम लिखयबाक लेल गलील प्रदेशक नासरत नगर सँ यहूदिया प्रदेशक बेतलेहम गाम गेलाह, जे दाऊदक गाम छल। ");
INSERT INTO mai_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ओ संग मे मरियम केँ सेहो लऽ गेलाह, जिनका संग हुनकर विवाहक निश्‍चय कयल गेल छलनि और जे गर्भवती छलीह। ");
INSERT INTO mai_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ओतहि रहैत मरियम केँ बच्‍चाक जन्‍म देबाक समय आबि गेलनि, ");
INSERT INTO mai_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","आ ओ अपन पहिल पुत्र केँ जन्‍म देलनि। ओ बच्‍चा केँ कपड़ाक टुकड़ा मे लपेटि कऽ नादि मे राखि देलथिन, कारण हुनका सभ केँ रहबाक लेल सराय मे कोनो स्‍थान नहि भेटल छलनि। ");
INSERT INTO mai_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ओहि इलाका मे चरबाह सभ छल जे बाध मे रहि कऽ राति मे अपन भेँड़ाक रखबारी कऽ रहल छल। ");
INSERT INTO mai_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","एकाएक परमेश्‍वरक एक स्‍वर्गदूत ओकरा सभक सामने मे ठाढ़ भऽ गेलाह आ प्रभुक तेज प्रकाश सँ ओकरा सभक चारू कात इजोत भऽ गेलैक। एहि सँ ओ सभ बहुत डेरा गेल। ");
INSERT INTO mai_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","मुदा स्‍वर्गदूत कहलथिन, “डेराह नहि! हम तोरा सभ केँ बड़का आनन्‍दक खुस खबरी सुनबैत छिअह, जे सभ लोकक लेल होयत। ");
INSERT INTO mai_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","आइ दाऊदक नगर मे तोरा सभक लेल एक उद्धारकर्ता जन्‍म लेलथुन अछि। ओ छथि प्रभु, परमेश्‍वरक पठाओल मसीह। ");
INSERT INTO mai_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","तोरा सभक लेल एकटा ई चेन्‍ह रहतह—तोँ सभ बच्‍चा केँ कपड़ाक टुकड़ा सँ लपेटल आ नादि मे राखल पयबह।” ");
INSERT INTO mai_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","तखन एकाएक ओहि स्‍वर्गदूतक संग असंख्‍य स्‍वर्गदूतक एक झुण्‍ड देखाइ पड़ल, जे परमेश्‍वरक स्‍तुति-प्रशंसा कऽ रहल छलाह जे, ");
INSERT INTO mai_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“सर्वोच्‍च स्‍वर्ग मे परमेश्‍वरक स्‍तुति-गान होनि, और पृथ्‍वी पर ताहि मनुष्‍य सभ केँ शान्‍ति भेटैक जकरा सँ ओ प्रसन्‍न छथिन।” ");
INSERT INTO mai_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","जखन स्‍वर्गदूत सभ ओकरा सभक लग सँ चल गेलाह, तखन चरबाह सभ एक-दोसर केँ कहलक, “अपना सभ चल! बेतलेहम जा कऽ एहि घटना केँ देखि ली जाहि दऽ प्रभु अपना सभ केँ कहबौलनि अछि।” ");
INSERT INTO mai_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ओ सभ जल्‍दी सँ गेल, आ ओतऽ पहुँचि कऽ मरियम आ यूसुफ केँ और नादि मे राखल बच्‍चा केँ पौलक। ");
INSERT INTO mai_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","बच्‍चा केँ देखि कऽ ओ सभ ओहि बातक विषय मे सभ केँ कहऽ लागल जे बात बच्‍चाक सम्‍बन्‍ध मे स्‍वर्गदूत ओकरा सभ केँ कहने छलथिन। ");
INSERT INTO mai_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","एकरा सभक बात जे सभ सुनलक, से सभ ओहि पर आश्‍चर्य कयलक। ");
INSERT INTO mai_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","मुदा मरियम ई सभ बात अपना मोन मे राखि कऽ ओहि पर विचार करैत रहलीह। ");
INSERT INTO mai_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","चरबाह सभ जे किछु देखने आ सुनने छल, ताहि सभ बातक लेल परमेश्‍वरक स्‍तुति-प्रशंसा गबैत घूमि गेल। जहिना स्‍वर्गदूत ओकरा सभ केँ कहने छलथिन, ठीक ओहिना सभ बात ओकरा सभ केँ भेटलो छलैक। ");
INSERT INTO mai_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","आठम दिन बालक केँ खतनाक विधि करबाक समय मे हुनकर नाम यीशु राखल गेलनि, जे नाम मायक गर्भ मे अयबा सँ पहिने स्‍वर्गदूत द्वारा राखल गेल छलनि। ");
INSERT INTO mai_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","मूसाक धर्म-नियमक अनुसार हुनका सभक शुद्धीकरणक दिन जखन आबि गेलनि, तँ मरियम आ यूसुफ बच्‍चा केँ प्रभु केँ अर्पित करबाक लेल यरूशलेम लऽ गेलथिन, ");
INSERT INTO mai_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","जेना कि प्रभुक नियम मे लिखल अछि जे, “प्रत्‍येक जेठ पुत्र प्रभुक मानल जायत।” ");
INSERT INTO mai_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","प्रभुक नियमक अनुसार शुद्धीकरणक वास्‍ते बलि चढ़यबाक लेल सेहो गेलाह, जेना कि लिखल अछि, “एक जोड़ा पउड़की वा परवाक दू बच्‍चा।” ");
INSERT INTO mai_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","यरूशलेम मे सिमियोन नामक एक आदमी छलाह, जे परमेश्‍वरक भय मानऽ वला एक धर्मी लोक छलाह। ओ “इस्राएल केँ शान्‍ति देनिहारक” बाट तकैत छलाह, आ पवित्र आत्‍मा हुनका संग छलथिन। ");
INSERT INTO mai_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","पवित्र आत्‍मा द्वारा हुनका ई कहल गेल छलनि जे, जा धरि अहाँ प्रभुक पठाओल उद्धारकर्ता-मसीह केँ नहि देखि लेबनि, ता धरि अहाँ नहि मरब। ");
INSERT INTO mai_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","पवित्र आत्‍माक प्रेरणा सँ ओ मन्‍दिर मे गेलाह। मरियम-यूसुफ जखन बेटाक लेल धर्म-नियमक विधि सभ पूरा करबाक हेतु बालक यीशु केँ मन्‍दिरक भीतर अनलथिन, ");
INSERT INTO mai_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","तँ सिमियोन हुनका कोरा मे लेलथिन, आ परमेश्‍वरक स्‍तुति कऽ कऽ बजलाह, ");
INSERT INTO mai_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“हे परम प्रभु, अहाँ जहिना वचन देलहुँ तहिना आब अपना एहि दास केँ शान्‍ति सँ विदा करू, ");
INSERT INTO mai_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","किएक तँ हम अपना आँखि सँ अहाँक उद्धार केँ देखि लेलहुँ, ");
INSERT INTO mai_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","जाहि उद्धार केँ अहाँ सभ जातिक लोकक सम्‍मुख प्रस्‍तुत कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","हँ, ई उद्धार आन जाति सभ केँ बाट देखौनिहार आ अहाँक निज जाति इस्राएल केँ गौरव देनिहार एक इजोत होयताह।” ");
INSERT INTO mai_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","बच्‍चाक माय-बाबू सिमियोनक एहि कथन सँ चकित भेलाह। ");
INSERT INTO mai_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","तखन सिमियोन हुनका सभ केँ आशीर्वाद देलथिन आ बच्‍चाक माय मरियम केँ कहलथिन, “ई बच्‍चा परमेश्‍वरक दिस संकेत करऽ वला चिन्‍ह होयबाक लेल चुनल गेल छथि। बहुत लोक हिनकर विरोध करत। अहूँक हृदय तरुआरि सँ बेधल जायत। हिनका कारणेँ इस्राएलक बहुत गोटेक पतन आ उत्‍थान होयतैक, और एहि तरहेँ बहुत लोकक असली मनोभावना प्रगट कयल जयतैक।” ");
INSERT INTO mai_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ओतऽ हन्‍नाह नामक परमेश्‍वरक एक बड्ड बुढ़ि प्रवक्‍तिनि सेहो छलीह, जे आशेर-कुलक फनुएलक बेटी छलीह। विवाहक बाद ओ सात वर्ष धरि सुहागिन रहलीह, ");
INSERT INTO mai_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","तकरा बाद विधवा भऽ गेलीह, और आब ओ चौरासी वर्षक छलीह। ओ मन्‍दिर केँ नहि छोड़ि कऽ दिन-राति उपास आ प्रार्थनाक संग परमेश्‍वरक सेवा मे लागल रहैत छलीह। ");
INSERT INTO mai_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ठीक ओही क्षण मरियम और यूसुफ लग आबि कऽ ओ परमेश्‍वरक धन्‍यवाद देबऽ लगलीह आ जे लोक सभ यरूशलेमक छुटकाराक बाट ताकि रहल छल, तकरा सभ सँ बच्‍चाक विषय मे बात करऽ लगलीह। ");
INSERT INTO mai_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","मरियम आ यूसुफ प्रभुक धर्म-नियमक अनुसार जे करबाक छलनि से सभ पूरा कऽ कऽ गलील प्रदेश मे अपन नगर नासरत घूमि अयलाह। ");
INSERT INTO mai_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","बच्‍चा बढ़ि कऽ बलिष्‍ठ आ नीक बुद्धि सँ परिपूर्ण होइत गेलाह, और हुनका पर परमेश्‍वरक आशीर्वाद छलनि। ");
INSERT INTO mai_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","यीशुक माय-बाबू प्रत्‍येक साल फसह-पाबनिक समय मे यरूशलेम जाइत छलाह। ");
INSERT INTO mai_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","यीशु जखन बारह वर्षक छलाह तँ ओ सभ आने बेर जकाँ पाबनि मनयबाक लेल यरूशलेम गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","पूरा पाबनि बिति गेला पर जखन ओ सभ विदा भेलाह तँ बालक यीशु यरूशलेमे मे रहि गेलाह, मुदा ई बात हुनकर माय-बाबू केँ नहि बुझल छलनि। ");
INSERT INTO mai_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ओ सभ ई बुझि जे यीशु यात्री सभ मे कतौ होयताह एक दिनक रस्‍ता आगाँ बढ़ि गेलाह। तखन ओ सभ अपना सम्‍बन्‍धी आ संगी-साथी सभ मे हुनकर खोजबीन करऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","मुदा ओ जखन नहि भेटलथिन तँ ओ सभ हुनका तकबाक लेल फेर यरूशलेम गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","तेसर दिन यीशु हुनका सभ केँ मन्‍दिर मे धर्मगुरु सभक बीच बैसल, हुनका सभक बात सुनैत आ हुनका सभ सँ प्रश्‍न करैत, भेटलथिन। ");
INSERT INTO mai_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","जे सभ यीशुक बात सुनलथिन, से सभ हुनकर बुद्धि और उत्तर सभ सँ चकित छलाह। ");
INSERT INTO mai_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","यीशु केँ ओतऽ देखि कऽ हुनकर माय-बाबू आश्‍चर्यित भेलाह। हुनकर माय कहलथिन, “बौआ, हमरा सभक संग एना किएक कयलह? देखह, तोहर बाबूजी आ हम तोरा तकैत-तकैत परेसान भऽ गेल छलहुँ।” ");
INSERT INTO mai_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ओ उत्तर देलथिन, “अहाँ सभ हमरा तकैत किएक छलहुँ? अहाँ सभ केँ नहि बुझल छल जे हमरा अपना पिताक घर मे होयब आवश्‍यक अछि?” ");
INSERT INTO mai_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","मुदा ओ सभ हुनकर कहबाक अर्थ नहि बुझि सकलाह। ");
INSERT INTO mai_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","तखन ओ हुनका सभक संग नासरत घूमि अयलाह, आ हुनकर सभक कहल मे रहलाह। हुनकर माय ई सभ बात अपना मोन मे राखि लेलनि। ");
INSERT INTO mai_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","यीशु बुद्धि आ शरीर मे बढ़ैत गेलाह, और परमेश्‍वर आ लोक दूनू हुनका सँ प्रसन्‍न रहलथिन। ");
INSERT INTO mai_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","कैसर तिबिरियुसक शासन-कालक पन्‍द्रहम वर्ष मे जकरयाहक पुत्र यूहन्‍ना लग निर्जन क्षेत्र मे परमेश्‍वरक दिस सँ सम्‍बाद अयलनि। ओहि समय मे पुन्‍तियुस पिलातुस यहूदिया प्रदेशक राज्‍यपाल छलाह, गलील प्रदेशक शासक हेरोद छलाह, इतूरिया आ त्रखोनीतिस क्षेत्रक शासक हुनकर भाय फिलिपुस और अबिलेन क्षेत्रक शासक लुसानियास छलाह। महापुरोहितक पद पर छलाह हन्‍ना और काइफा। यूहन्‍ना लग परमेश्‍वरक सम्‍बाद एही समय मे अयलनि। ");
INSERT INTO mai_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ओ यरदन नदीक लग-पासक पूरा इलाका मे घूमि-घूमि कऽ प्रचार करऽ लगलाह जे, “पापक क्षमा पयबाक लेल पश्‍चात्ताप कऽ हृदय-परिवर्तन करू और बपतिस्‍मा लिअ,” ");
INSERT INTO mai_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","जेना परमेश्‍वरक प्रवक्‍ता यशायाहक पुस्‍तक मे लिखल अछि जे, “निर्जन क्षेत्र मे केओ जोर सँ आवाज दऽ रहल अछि— ‘प्रभुक लेल मार्ग तैयार करू, हुनका लेल सोझ बाट बनाउ। ");
INSERT INTO mai_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","प्रत्‍येक गहींर भाग भरि देल जायत, प्रत्‍येक ऊँच भाग आ पहाड़ नीच कयल जायत, घुमान बाट सोझ, और उबर-खाबड़ बाट समतल कयल जायत। ");
INSERT INTO mai_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","सभ मनुष्‍य परमेश्‍वर द्वारा प्रदान कयल उद्धार केँ देखत।’ ” ");
INSERT INTO mai_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","लोकक भीड़ सभ यूहन्‍ना सँ बपतिस्‍मा लेबऽ अबैत रहैत छल आ ओ ओकरा सभ केँ कहैत छलथिन, “है साँपक सन्‍तान सभ! परमेश्‍वरक आबऽ वला क्रोध सँ बचबाक लेल तोरा सभ केँ के सिखौलकह? ");
INSERT INTO mai_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","तोँ सभ जँ अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन कयने छह, तँ तकर प्रमाण अपना व्‍यवहार द्वारा देखाबह। और अपना मोन मे एना सोचि निश्‍चिन्‍त नहि रहह जे, हमर सभक कुल-पिता अब्राहम छथि, कारण, हम तोरा सभ केँ कहैत छिअह जे परमेश्‍वर एहि पाथर सभ सँ अब्राहमक लेल सन्‍तान उत्‍पन्‍न कऽ सकैत छथि। ");
INSERT INTO mai_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","गाछक जड़ि मे कुड़हरि रखा गेल अछि। जे गाछ नीक फल नहि दैत अछि से काटल आ आगि मे फेकल जायत।” ");
INSERT INTO mai_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","एहि पर लोक सभ यूहन्‍ना सँ पुछऽ लागल, “तँ हम सभ की करू?” ");
INSERT INTO mai_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ओ उत्तर देलथिन, “जकरा दूटा कुर्ता होइक से एकटा तकरा देअओ जकरा नहि छैक, और जकरा लग भोजनक वस्‍तु होइक सेहो एहिना करओ।” ");
INSERT INTO mai_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","कर असूल करऽ वला सभ सेहो बपतिस्‍मा लेबऽ आयल आ यूहन्‍ना सँ पुछलकनि, “यौ गुरुजी, हम सभ की करू?” ");
INSERT INTO mai_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ओ उत्तर देलथिन, “जतबा कर निश्‍चित कयल गेल अछि ताहि सँ बेसी नहि लैह।” ");
INSERT INTO mai_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","एहि पर सैनिक सभ पुछलकनि, “आ हम सभ की करू?” ओ कहलथिन, “ककरो सँ बलजोरी पाइ नहि लैह, आ ने ककरो पर झुट्ठे दोष लगाबह। अपना दरमाहा सँ सन्‍तुष्‍ट रहह।” ");
INSERT INTO mai_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","जनता मे एकटा बड़का उत्‍सुकता आबि गेल छलैक, आ सभ मोने-मोन यूहन्‍नाक बारे मे सोचि रहल छल जे, कहीं ई उद्धारकर्ता-मसीह तँ नहि छथि? ");
INSERT INTO mai_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","यूहन्‍ना सभ केँ उत्तर दैत छलथिन, “हम तोरा सभ केँ पानि सँ बपतिस्‍मा दैत छिअह। मुदा हमरा सँ शक्‍तिशाली एक गोटे आबि रहल छथि, जिनकर जुत्तो खोलऽ जोगरक हम नहि छी। ओ तोरा सभ केँ पवित्र आत्‍मा और आगि सँ बपतिस्‍मा देथुन। ");
INSERT INTO mai_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ओ अपन खरिहानक अन्‍न साफ करबाक लेल हाथ मे सूप लेने छथि। ओ गहुम केँ बखारी मे राखि लेताह, मुदा भुस्‍सा केँ ओहि आगि मे जरौताह जे कहियो नहि मिझायत।” ");
INSERT INTO mai_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ई बात और आरो अन्‍य तरहक बहुत बातक द्वारा यूहन्‍ना लोक सभ केँ बुझा-सुझा कऽ शुभ समाचार सुनबैत रहलथिन। ");
INSERT INTO mai_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","मुदा जखन यूहन्‍ना शासक हेरोद पर भायक घरवाली हेरोदियासक कारणेँ, तथा आरो कुकर्म सभक कारणेँ जे ओ कयने छलाह, दोष लगौलथिन, ");
INSERT INTO mai_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","तँ हेरोद अपना कुकर्म मे एकटा इहो कुकर्म जोड़ि लेलनि जे, ओ यूहन्‍ना केँ जहल मे बन्‍द करबा देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","सभ लोक केँ बपतिस्‍मा लेलाक बाद यीशुओ बपतिस्‍मा लेलनि। बपतिस्‍माक बाद जखन ओ प्रार्थना कऽ रहल छलाह तँ स्‍वर्ग खुजल ");
INSERT INTO mai_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","आ पवित्र आत्‍मा परबाक रूप मे हुनका ऊपर उतरि अयलाह, और स्‍वर्ग सँ आवाज आयल जे, “अहाँ हमर प्रिय पुत्र छी। अहाँ सँ हम बहुत प्रसन्‍न छी।” ");
INSERT INTO mai_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","यीशु जखन अपन काज शुरू कयलनि तँ लगभग तीस वर्षक छलाह। एना मानल जाइत छल जे ओ यूसुफक पुत्र छलाह। यूसुफ एलीक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","एली मतातक पुत्र छलाह, मतात लेवीक पुत्र छलाह, लेवी मलकीक पुत्र छलाह, मलकी यन्‍नाक पुत्र छलाह, यन्‍ना यूसुफक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","यूसुफ मततियाक पुत्र छलाह, मततिया आमोसक पुत्र छलाह, आमोस नहूमक पुत्र छलाह, नहूम एसलीक पुत्र छलाह, एसली नागैक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","नागै मातक पुत्र छलाह, मात मततियाक पुत्र छलाह, मततिया शिमीक पुत्र छलाह, शिमी योसेखक पुत्र छलाह, योसेख योदाहक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","योदाह योहनानक पुत्र छलाह, योहनान रेसाक पुत्र छलाह, रेसा जरुब्‍बाबेलक पुत्र छलाह, जरुब्‍बाबेल शालतिएलक पुत्र छलाह, शालतिएल नेरीक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","नेरी मलकीक पुत्र छलाह, मलकी अद्दीक पुत्र छलाह, अद्दी कोसामक पुत्र छलाह, कोसाम इलमोदामक पुत्र छलाह, इलमोदाम एरक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","एर यहोशूक पुत्र छलाह, यहोशू एलिएजरक पुत्र छलाह, एलिएजर योरीमक पुत्र छलाह, योरीम मतातक पुत्र छलाह, मतात लेवीक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","लेवी सिमियोनक पुत्र छलाह, सिमियोन यहूदाक पुत्र छलाह, यहूदा यूसुफक पुत्र छलाह, यूसुफ योनामक पुत्र छलाह, योनाम एलयाकीमक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","एलयाकीम मलेआहक पुत्र छलाह, मलेआह मिन्‍नाहक पुत्र छलाह, मिन्‍नाह मताताक पुत्र छलाह, मताता नातानक पुत्र छलाह, नातान दाऊदक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","दाऊद यिशयक पुत्र छलाह, यिशय ओबेदक पुत्र छलाह, ओबेद बोअजक पुत्र छलाह, बोअज सलमोनक पुत्र छलाह, सलमोन नाशोनक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","नाशोन अमीनादाबक पुत्र छलाह, अमीनादाब अदमीनक पुत्र छलाह, अदमीन अरनीक पुत्र छलाह, अरनी हेस्रोनक पुत्र छलाह, हेस्रोन पेरसक पुत्र छलाह, पेरस यहूदाक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","यहूदा याकूबक पुत्र छलाह, याकूब इसहाकक पुत्र छलाह, इसहाक अब्राहमक पुत्र छलाह, अब्राहम तेरहक पुत्र छलाह, तेरह नाहोरक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","नाहोर सरूगक पुत्र छलाह, सरूग रऊक पुत्र छलाह, रऊ पेलेगक पुत्र छलाह, पेलेग एबेरक पुत्र छलाह, एबेर शेलहक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","शेलह केनानक पुत्र छलाह, केनान अर्पक्षदक पुत्र छलाह, अर्पक्षद शेमक पुत्र छलाह, शेम नूहक पुत्र छलाह, नूह लामेकक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","लामेक मथूशेलहक पुत्र छलाह, मथूशेलह हनोकक पुत्र छलाह, हनोक यारेदक पुत्र छलाह, यारेद महलालेलक पुत्र छलाह, महलालेल केनानक पुत्र छलाह, ");
INSERT INTO mai_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","केनान एनोशक पुत्र छलाह, एनोश शेतक पुत्र छलाह, शेत आदमक पुत्र छलाह, और आदम परमेश्‍वरक पुत्र छलाह। ");
INSERT INTO mai_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","यीशु पवित्र आत्‍मा सँ परिपूर्ण भऽ यरदन नदी सँ घुमलाह। तखन पवित्र आत्‍मा हुनका निर्जन क्षेत्र मे लऽ गेलथिन, ");
INSERT INTO mai_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","जतऽ चालिस दिन धरि शैतान हुनका सँ पाप करयबाक प्रयत्‍न कयलकनि। एहि चालिस दिन मे ओ किछु नहि खयलनि, और एतेक दिन बितला पर हुनका बहुत भूख लागल छलनि। ");
INSERT INTO mai_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","तँ शैतान हुनका कहलकनि, “तोँ जँ परमेश्‍वरक पुत्र छह तँ एहि पाथर केँ रोटी बनि जयबाक आज्ञा दहक।” ");
INSERT INTO mai_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","यीशु उत्तर देलथिन, “धर्मशास्‍त्र मे लिखल अछि जे, मनुष्‍य मात्र रोटिए सँ नहि जीवित रहत।” ");
INSERT INTO mai_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","तखन शैतान हुनका ऊँच स्‍थान मे लऽ जा कऽ एके क्षण मे संसारक सभ राज्‍य देखा देलकनि ");
INSERT INTO mai_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","आ कहलकनि, “हम तोरा एहि सभ राज्‍यक अधिकार आ वैभव दऽ देबह, कारण ई सभ हमरे जिम्‍मा मे दऽ देल गेल अछि, आ हम जकरा ककरो चाहबैक तकरा दऽ सकैत छिऐक। ");
INSERT INTO mai_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","तेँ तोँ जँ हमर उपासना करबह तँ ई सभ तोहर भऽ गेलह।” ");
INSERT INTO mai_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","यीशु उत्तर देलथिन, “धर्मशास्‍त्र मे लिखल अछि, ‘तोँ अपना प्रभु-परमेश्‍वरेक उपासना करहुन और मात्र हुनके सेवा करहुन।’” ");
INSERT INTO mai_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","शैतान हुनका यरूशलेम लऽ जा कऽ मन्‍दिरक सभ सँ ऊँच स्‍थान पर ठाढ़ कऽ कऽ कहलकनि, “तोँ जँ परमेश्‍वरक पुत्र छह, तँ एतऽ सँ नीचाँ कुदि जाह, ");
INSERT INTO mai_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","कारण धर्मशास्‍त्र मे लिखल अछि जे, ‘परमेश्‍वर तोहर रक्षा करबाक लेल स्‍वर्गदूत सभ केँ आज्ञा देथिन, ");
INSERT INTO mai_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","और ओ सभ अपना कोरा मे तोरा लोकि लेथुन, जाहि सँ पयर मे पाथर सँ चोट नहि लगतह।’” ");
INSERT INTO mai_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","यीशु उत्तर देलथिन, “धर्मशास्‍त्रक कथन इहो अछि, ‘अपन प्रभु-परमेश्‍वरक जाँच नहि करहुन।’” ");
INSERT INTO mai_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","शैतान जखन हुनका सँ सभ ढंग सँ पाप करयबाक प्रयत्‍न कऽ चुकल तँ ओ ओतऽ सँ चल गेल आ दोसर उपयुक्‍त अवसरक ताक मे रहऽ लागल। ");
INSERT INTO mai_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","यीशु गलील प्रदेश मे घूमि कऽ चल अयलाह, और पवित्र आत्‍माक सामर्थ्‍य हुनका संग छलनि। ओहि क्षेत्रक सभ ठाम हुनकर चर्चा पसरि गेलनि। ");
INSERT INTO mai_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ओ सभाघर सभ मे शिक्षा दैत छलथिन, आ सभ लोक हुनकर प्रशंसा करैत छलनि। ");
INSERT INTO mai_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","एक दिन यीशु नासरत नगर अयलाह, जतऽ हुनकर पालन-पोषण भेल छलनि। ओ अपना आदतक अनुसार विश्राम-दिन सभाघर मे गेलाह। ओ धर्मशास्‍त्रक पाठ पढ़बाक लेल ठाढ़ भेलाह, ");
INSERT INTO mai_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","तँ हुनका परमेश्‍वरक प्रवक्‍ता यशायाहक पुस्‍तक देल गेलनि। ओ पुस्‍तक खोलि कऽ ओहि ठाम सँ पढ़ऽ लगलाह जतऽ लिखल अछि जे, ");
INSERT INTO mai_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“प्रभुक आत्‍मा हमरा पर छथि; किएक तँ ओ गरीब सभ केँ शुभ समाचार सुनयबाक लेल हमर अभिषेक कयने छथि। ओ हमरा पठौलनि अछि जे हम कैदी सभक लेल मुक्‍तिक घोषणा करी, आन्‍हर सभ केँ कहिऐक जे, ‘तोँ सभ आब देखि सकैत छह,’ सताओल लोक सभ केँ छुटकारा दिआबी ");
INSERT INTO mai_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","और एहि बातक घोषणा करी जे, प्रभुक ओ युग आबि गेल अछि जाहि मे ओ अपन करुणा प्रगट करताह।” ");
INSERT INTO mai_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ई पाठ पढ़लाक बाद यीशु पुस्‍तक बन्‍द कऽ कऽ सभाघरक सेवक केँ दऽ देलथिन आ बैसि गेलाह। सभ केओ एकटक लगा कऽ हुनका दिस ताकि रहल छल। ");
INSERT INTO mai_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","तखन ओ बजलाह, “आइ धर्मशास्‍त्रक ई लेख अहाँ सभक समक्ष मे पूरा भऽ गेल।” ");
INSERT INTO mai_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","सभ केओ हुनकर प्रशंसा कयलकनि और आश्‍चर्यित भेल जे ओ एतेक नीक-नीक बात सभ कहैत छथि। सभ कहैत छल, “की ई यूसुफेक बेटा नहि छथि?” ");
INSERT INTO mai_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","यीशु ओकरा सभ केँ कहलथिन, “अहाँ सभ अवश्‍य हमरा ई कहबी सुनायब जे, ‘यौ वैद्यजी, पहिने अपना केँ नीक करू!’ आ ई कहब जे ‘एतौ अपना गाम मे ओ काज सभ करू जकरा बारे मे सुनैत छी जे अहाँ कफरनहूम मे कयलहुँ।’ ");
INSERT INTO mai_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","हम अहाँ सभ केँ सत्‍ये कहैत छी जे, परमेश्‍वरक कोनो प्रवक्‍ता केँ अपना गाम मे स्‍वीकार नहि कयल जाइत छैक। ");
INSERT INTO mai_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","हमर बात सुनू! अहूँ सभ तँ जनिते छी जे एलियाहक समय मे जखन साढ़े तीन वर्ष धरि वर्षा नहि भेल आ सौंसे देश मे भयंकर अकाल पड़ि गेल, तँ ओहि समय मे इस्राएल मे बहुते विधवा रहय, ");
INSERT INTO mai_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","मुदा परमेश्‍वर एलियाह केँ ओकरा सभ मे सँ ककरो लग मदति देबाक लेल वा लेबाक लेल नहि पठौलथिन—ओ हुनका सीदोन क्षेत्रक सारफत गाम मे रहऽ वाली एकटा विधवाक ओहिठाम पठौलथिन। ");
INSERT INTO mai_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","फेर परमेश्‍वरक प्रवक्‍ता एलीशाक समय मे इस्राएल मे बहुते कुष्‍ठ-रोगी छल, मुदा ओकरा सभ मे सँ ककरो नीक नहि कयल गेलैक—मात्र सीरिया प्रदेशक निवासी नामान केँ।” ");
INSERT INTO mai_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ई बात सुनि सभाघरक लोक सभ तिलमिला उठल। ");
INSERT INTO mai_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ओ सभ उठि कऽ यीशु केँ नगर सँ बाहर अनलकनि, और जाहि पहाड़ पर ओ नगर बसल छल, तकर कनगी पर लऽ गेलनि जे एहि ठाम सँ एकरा नीचाँ धकेलि दी। ");
INSERT INTO mai_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","मुदा ओ ओहि भीड़ मे सँ बहरा कऽ चल जाइत रहलाह। ");
INSERT INTO mai_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","तखन यीशु कफरनहूम गेलाह, जे गलील प्रदेशक एक नगर अछि, और विश्राम-दिन मे लोक सभ केँ उपदेश देबऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","हुनकर शिक्षा सँ लोक सभ चकित भेल, कारण, ओ अधिकारक संग शिक्षा दैत छलाह। ");
INSERT INTO mai_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","सभाघर मे एक आदमी छल जे दुष्‍टात्‍मा, अर्थात्‌ अशुद्ध आत्‍मा, सँ ग्रसित छल। ओ जोर सँ चिकरि कऽ बाजल, ");
INSERT INTO mai_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“यौ! नासरतक निवासी यीशु! अहाँ केँ हमरा सभ सँ कोन काज? हमरा सभ केँ नष्‍ट करऽ अयलहुँ की? हम अहाँ केँ चिन्‍हैत छी। अहाँ परमेश्‍वरक पवित्र दूत छी।” ");
INSERT INTO mai_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","यीशु दुष्‍टात्‍मा केँ डाँटि कऽ कहलथिन, “चुप रह! तोँ एकरा मे सँ निकल!” तखन ओ दुष्‍टात्‍मा ओहि आदमी केँ सभक सामने मे पटकि देलकैक आ बिनु हानि पहुँचौने ओकरा मे सँ निकलि गेल। ");
INSERT INTO mai_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","एहि पर सभ लोक चकित होइत एक-दोसर केँ कहऽ लागल जे, “ई केहन उपदेश अछि? ई आदमी शक्‍ति आ अधिकारक संग दुष्‍टात्‍मा सभ केँ आज्ञा दैत छथि और ओ सभ निकलि जाइत अछि!” ");
INSERT INTO mai_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","एहि सभ सँ हुनकर चर्चा ओहि क्षेत्रक चारू कात पसरि गेलनि। ");
INSERT INTO mai_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","यीशु सभाघर सँ बाहर भऽ कऽ सिमोनक ओहिठाम गेलाह। सिमोनक सासु केँ बहुत जोर बोखार छलनि। लोक सभ हुनका मदति करबाक लेल यीशु सँ विनती कयलकनि। ");
INSERT INTO mai_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","सिमोनक सासुक लग मे जा कऽ यीशु बोखार केँ उतरि जयबाक आज्ञा देलथिन, तँ हुनकर बोखार उतरि गेलनि। ओ तुरत उठि कऽ हिनका सभक सेवा-सत्‍कार करऽ मे लागि गेलीह। ");
INSERT INTO mai_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","सूर्यास्‍त भेला पर जकरा-जकरा ओहिठाम विभिन्‍न बिमारी सँ पीड़ित लोक सभ छलैक, से सभ ओकरा सभ केँ यीशु लग आनऽ लागल। प्रत्‍येक पर हाथ राखि कऽ ओ ओकरा सभ केँ स्‍वस्‍थ कऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","बहुत लोक मे सँ दुष्‍टात्‍मा सभ सेहो एना चिकरि कऽ कहैत निकलि आयल जे, “अहाँ परमेश्‍वरक पुत्र छी!” मुदा ओ ओहि दुष्‍टात्‍मा सभ केँ डँटलथिन आ बाजऽ नहि देलथिन, कारण ओ सभ जनैत छल जे ई उद्धारकर्ता-मसीह छथि। ");
INSERT INTO mai_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","भोर भेला पर यीशु कोनो एकान्‍त स्‍थान मे चल गेलाह। लोक सभ तकैत-तकैत हुनका लग पहुँचल आ हुनका रोकलकनि जे, अहाँ हमरा सभ केँ छोड़ि कऽ नहि जाउ। ");
INSERT INTO mai_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","मुदा ओ उत्तर देलथिन, “हमरा तँ परमेश्‍वरक राज्‍यक शुभ समाचार दोसरो-दोसरो नगर मे सुनयबाक अछि, किएक तँ हम एही लेल पठाओल गेल छी।” ");
INSERT INTO mai_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","अतः ओ यहूदिया प्रदेशक सभाघर सभ मे प्रचारक काज करैत रहलाह। ");
INSERT INTO mai_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","एक दिन यीशु जखन गन्‍नेसरत झीलक कछेर पर ठाढ़ छलाह, आ लोक सभक भीड़ परमेश्‍वरक वचन सुनबाक लेल हुनका चारू कात सँ ठेलम-ठेल करैत घेरने छलनि, ");
INSERT INTO mai_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","तँ हुनकर नजरि कछेर पर लागल दूटा नाव पर पड़लनि। मछबार सभ ओतऽ नाव छोड़ि कऽ अपन जाल धोइत छल। ");
INSERT INTO mai_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ओहि मे एकटा नाव जे सिमोनक छलनि, यीशु ताहि पर चढ़ि कऽ सिमोन केँ कहलथिन जे, नाव केँ कछेर सँ हटा कऽ कनेक पानि मे लऽ जा कऽ ठाढ़ करू। तखन नाव पर बैसि कऽ यीशु ओही पर सँ लोक सभ केँ उपदेश देबऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","उपदेश समाप्‍त भेला पर यीशु सिमोन केँ कहलथिन, “नाव केँ गहींर पानि मे लऽ चलू, आ माछ पकड़बाक लेल जाल खसाउ।” ");
INSERT INTO mai_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","सिमोन कहलथिन, “मालिक, हम सभ राति भरि परिश्रम कयलहुँ और एकोटा माछ नहि पकड़ायल। मुदा अहाँ जँ कहैत छी तँ हम फेर जाल खसायब।” ");
INSERT INTO mai_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ओ सभ जाल उतारलनि तँ ततेक माछ पड़लनि जे जाल फाटऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ई देखि ओ सभ अपना संगी सभ, जे दोसर नाव मे छलनि, तिनका सभ केँ संकेत कयलथिन जे, आउ, हमर सभक सहायता करू। ओ सभ आबि कऽ दूनू नाव केँ माछ सँ ततेक भरि लेलनि जे आब नाव डुबऽ लागल। ");
INSERT INTO mai_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","सिमोन पत्रुस ई देखि यीशुक पयर पर खसि कऽ कहलथिन, “यौ प्रभु, हमरा लग सँ चल जाउ, किएक तँ हम पापी आदमी छी।” ");
INSERT INTO mai_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","सिमोन और हुनकर संगी सभ एतेक माछ केँ पकड़यला सँ चकित भऽ गेल छलाह। ");
INSERT INTO mai_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","तहिना जबदीक पुत्र याकूब और यूहन्‍ना, जे सिमोनक हिस्‍सेदार छलथिन, सेहो चकित भेलाह। एहि पर यीशु सिमोन केँ कहलथिन, “डेराउ नहि! आब अहाँ मनुष्‍य सभ केँ पकड़ब।” ");
INSERT INTO mai_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ओ सभ नाव केँ कछेर पर घीचि कऽ अनलनि, और सभ किछु ओतहि छोड़ि कऽ हुनका संग लागि गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","एक बेर जखन यीशु कोनो नगर मे छलाह, तँ ओतऽ एक आदमी छल जकरा सौंसे देह मे कुष्‍ठ-रोगक घाव भऽ गेल छलैक। यीशु केँ देखि कऽ ई आदमी हुनका सामने मे मुँह भरे खसि कऽ विनती करऽ लगलनि जे, “यौ प्रभु! अहाँ जँ चाही तँ हमरा शुद्ध कऽ सकैत छी।” ");
INSERT INTO mai_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","यीशु अपन हाथ बढ़ा ओकरा छुबि कऽ कहलथिन, “हम अवश्‍य चाहैत छिअह! तोँ शुद्ध भऽ जाह!” ओकर कुष्‍ठ-रोग तुरत्ते छुटि गेलैक। ");
INSERT INTO mai_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","यीशु ओकरा आदेश देलथिन, “ई बात ककरो नहि कहिअहक, मुदा जा कऽ अपना केँ पुरोहित केँ देखाबह, और शुद्ध होयबाक विषय मे मूसाक लिखल नियमक अनुसार, जे बलिदान चढ़यबाक अछि से चढ़ाबह। एहि तरहेँ सभक लेल गवाही रहत जे तोँ शुद्ध भऽ गेल छह।” ");
INSERT INTO mai_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","तैयो यीशुक चर्चा आरो बहुत पसरैत गेलनि, और हाँजक-हाँज लोक सभ हुनकर उपदेश सुनबाक लेल आ अपन बिमारी सँ स्‍वस्‍थ होयबाक लेल हुनका लग अबैत रहल। ");
INSERT INTO mai_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","मुदा यीशु एकान्‍त स्‍थान मे प्रार्थना करबाक लेल निकलि जाइत छलाह। ");
INSERT INTO mai_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","एक दिन यीशु जखन उपदेश दऽ रहल छलाह, तँ हुनका लग मे फरिसी आ धर्मशिक्षक सभ बैसल छलनि, जे सभ गलील प्रदेशक सभ गाम सँ, यहूदिया प्रदेश सँ आ यरूशलेम सँ आयल छलाह। रोगी सभ केँ स्‍वस्‍थ करबाक लेल प्रभु-परमेश्‍वरक सामर्थ्‍य हुनका संग छलनि। ");
INSERT INTO mai_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","किछु लोक एकटा लकवा मारल आदमी केँ खाट पर लदने आयल, और ओकरा यीशुक सामने मे रखबाक लेल घरक भीतर लऽ जयबाक कोशिश कयलक। ");
INSERT INTO mai_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","मुदा भीड़क कारणेँ जखन कोनो रस्‍ता नहि भेटलैक, तँ ओ सभ चार पर चढ़ि गेल, आ खपड़ा हटा कऽ ओकरा खाट सहित लोकक बीच मे यीशुक ठीक सामने मे उतारि देलकैक। ");
INSERT INTO mai_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","यीशु ओकर सभक विश्‍वास देखि कऽ कहलथिन, “हौ भाइ, तोहर पाप माफ भेलह।” ");
INSERT INTO mai_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","एहि पर फरिसी आ धर्मशिक्षक सभ अपना मोन मे सोचऽ लगलाह जे, “ई के अछि जे परमेश्‍वरक निन्‍दा कऽ रहल अछि? परमेश्‍वर केँ छोड़ि आओर के पाप केँ माफ कऽ सकैत अछि?” ");
INSERT INTO mai_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","हुनकर सभक मोनक बात बुझि यीशु पुछलथिन, “अहाँ सभ अपना-अपना मोन मे एहन बात किएक सोचैत छी? ");
INSERT INTO mai_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","आसान की अछि—ई कहब जे ‘तोहर पाप माफ भेलह,’ वा ई जे, ‘उठि कऽ चलह-फिरह’? ");
INSERT INTO mai_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","मुदा जाहि सँ अहाँ सभ ई बात बुझि जाइ जे मनुष्‍य-पुत्र केँ पृथ्‍वी पर पाप केँ माफ करबाक अधिकार छनि, हम एकरा कहैत छी...” तखन ओ लकवा मारल आदमी केँ कहलथिन, “हम तोरा कहैत छिअह, उठह, अपन खाट उठाबह आ घर चल जाह!” ");
INSERT INTO mai_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ओ तुरत सभक सामने मे ठाढ़ भऽ गेल, और जाहि खाट पर ओ पड़ल रहैत छल, से उठा लेलक आ परमेश्‍वरक स्‍तुति करैत घर चल गेल। ");
INSERT INTO mai_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","सभ लोक केँ बहुत आश्‍चर्य लगलैक। ओ सभ परमेश्‍वरक प्रशंसा करैत आ हुनकर डर मानैत कहऽ लागल, “आइ तँ हम सभ बहुत अद्‌भुत बात सभ देखलहुँ अछि!” ");
INSERT INTO mai_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","तकरबाद यीशु जखन बाहर गेलाह तँ लेवी नामक एक कर असूल कयनिहार केँ कर असूल करऽ वला स्‍थान मे बैसल देखलनि। यीशु कहलथिन, “हमरा पाछाँ आउ।” ");
INSERT INTO mai_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","लेवी उठलाह और सभ किछु छोड़ि-छाड़ि कऽ हुनका संग विदा भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","लेवी अपना ओहिठाम यीशुक सत्‍कारक लेल बड़का भोज कयलनि। हुनका सभक संग दोसरो कर असूल करऽ वला सभ आ आरो-आरो बहुत लोक सभ भोजन पर बैसल छलाह। ");
INSERT INTO mai_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","तँ फरिसी आ ओहि पंथक धर्मशिक्षक सभ यीशुक शिष्‍य सभ पर दोष लगबैत कहलथिन, “अहाँ सभ कर असूल करऽ वला आ पापी सभक संग किएक खाइत-पिबैत छी?” ");
INSERT INTO mai_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","यीशु उत्तर देलथिन, “स्‍वस्‍थ लोक केँ वैद्यक आवश्‍यकता नहि होइत छैक, बल्‍कि बिमार लोक केँ। ");
INSERT INTO mai_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","हम धार्मिक सभ केँ नहि, बल्‍कि पापी सभ केँ बजयबाक लेल आयल छी जाहि सँ ओ सभ अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन करय।” ");
INSERT INTO mai_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","तखन ओ सभ यीशु केँ कहलथिन, “यूहन्‍नाक शिष्‍य सभ बेर-बेर उपास करैत रहैत छथि आ प्रार्थना मे लागल रहैत छथि, आ तहिना फरिसी सभक शिष्‍य सभ सेहो करैत छथि, मुदा अहाँक शिष्‍य सभ तँ खाइत-पिबैत रहैत अछि।” ");
INSERT INTO mai_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","यीशु उत्तर देलथिन, “जाबत तक वरियातीक संग वर अछि, ताबत तक की वरियाती सँ उपास करा सकैत छी? नहि! ");
INSERT INTO mai_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","मुदा ओ समय आओत जहिया वर ओकरा सभक बीच सँ हटा लेल जायत; ओ सभ तहिये उपास करत।” ");
INSERT INTO mai_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","तखन यीशु हुनका सभ केँ ई दृष्‍टान्‍त दैत कहलथिन, “केओ नयाँ कपड़ा मे सँ फाड़ि कऽ पुरान कपड़ा पर चेफरी नहि लगबैत अछि। एना जँ करत, तँ नयाँ कपड़ा तँ फाटिए गेल, आ पुरान कपड़ा पर नयाँ कपड़ाक चेफरी मिलबो नहि करत। ");
INSERT INTO mai_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","तहिना केओ नव दारू पुरान चमड़ाक थैली मे नहि रखैत अछि। कारण, एना जँ करत, तँ नव दारू ओहि थैली केँ फाड़ि देत, दारू बहि जायत, आ थैलिओ नष्‍ट भऽ जायत। ");
INSERT INTO mai_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","नहि! नव दारू नये थैली मे राखऽ पड़ैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","आ पुरान दारू पिला पर नव दारू पिबाक ककरो इच्‍छा नहि होइत छैक। ओ कहैत अछि जे, पुराने नीक अछि।” ");
INSERT INTO mai_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","कोनो विश्राम-दिन कऽ यीशु खेत दऽ कऽ जा रहल छलाह; हुनकर शिष्‍य सभ अन्‍नक बालि तोड़ि हाथ सँ मीड़ि-मीड़ि कऽ खाय लगलाह। ");
INSERT INTO mai_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","एहि पर किछु फरिसी सभ कहलथिन, “जे काज विश्राम-दिन मे करब धर्म-नियमक अनुसार मना अछि, से अहाँ सभ किएक कऽ रहल छी?” ");
INSERT INTO mai_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","यीशु उत्तर देलथिन, “की अहाँ सभ कहियो नहि पढ़ने छी जे, दाऊद आ हुनकर संगी सभ जखन भुखायल छलाह तँ ओ की कयलनि? ");
INSERT INTO mai_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ओ परमेश्‍वरक भवन मे जा कऽ परमेश्‍वर केँ चढ़ाओल रोटी लऽ लेलनि। जाहि रोटी केँ खयबाक अधिकार पुरोहित केँ छोड़ि आरो ककरो नहि छलैक, तकरा ओ अपनो खयलनि आ संगियो सभ केँ देलथिन।” ");
INSERT INTO mai_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","तकरबाद यीशु इहो कहलथिन, “मनुष्‍य-पुत्र विश्रामो-दिनक मालिक छथि।” ");
INSERT INTO mai_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","एक अन्‍य विश्राम-दिन यीशु सभाघर मे जा कऽ उपदेश देबऽ लगलाह। ओहिठाम एक आदमी छल जकर दहिना हाथ सुखायल छलैक। ");
INSERT INTO mai_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","फरिसी आ धर्मशिक्षक सभ यीशु पर दोष लगयबाक आधारक लेल हुनका पर नजरि गड़ौने छलाह जे, देखी ओ विश्राम-दिन मे ककरो स्‍वस्‍थ करताह वा नहि। ");
INSERT INTO mai_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","यीशु हुनकर सभक विचार बुझि गेलाह। तेँ ओ सुखल हाथ वला आदमी केँ कहलथिन, “उठह! सभक आगाँ मे ठाढ़ होअह।” ओ उठि कऽ ठाढ़ भेल। ");
INSERT INTO mai_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","तखन यीशु लोक सभ केँ कहलथिन, “एकटा बात हम अहाँ सभ सँ पुछैत छी। विश्राम-दिन मे धर्म-नियमक अनुसार की करब उचित होयत—नीक वा अधलाह? ककरो जीवनक रक्षा करब वा नष्‍ट करब?” ");
INSERT INTO mai_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","तखन ओ चारू दिस सभ पर नजरि दऽ कऽ ओहि आदमी केँ कहलथिन, “अपन हाथ बढ़ाबह।” ओ हाथ बढ़ौलक, आ ओकर हाथ एकदम ठीक भऽ गेलैक। ");
INSERT INTO mai_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","मुदा एहि पर फरिसी आ धर्मशिक्षक सभ क्रोध सँ भरि गेलाह और एक-दोसराक संग विचारऽ लगलाह जे अपना सभ यीशु केँ की करी? ");
INSERT INTO mai_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ओहि समय मे एक दिन यीशु प्रार्थना करबाक लेल पहाड़ पर गेलाह, आ भरि राति परमेश्‍वर सँ प्रार्थना कयलनि। ");
INSERT INTO mai_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","भोर भेला पर ओ अपना शिष्‍य सभ केँ अपना लग बजौलनि और ओहि मे सँ बारह गोटे केँ चुनि कऽ हुनका सभ केँ अपन “दूत” कहलथिन। ");
INSERT INTO mai_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ओ लोकनि यैह सभ छलाह—सिमोन, जिनका ओ “पत्रुस” नाम देलथिन, हुनकर भाय अन्‍द्रेयास, याकूब और यूहन्‍ना, फिलिपुस, बरतुल्‍मै, ");
INSERT INTO mai_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","मत्ती, थोमा, अल्‍फेयासक पुत्र याकूब, सिमोन, जे “देश-भक्‍त” कहबैत छलाह, ");
INSERT INTO mai_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","याकूबक पुत्र यहूदा, और यहूदा इस्‍करियोती जे बाद मे विश्‍वासघाती भऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","यीशु हिनका सभक संग पहाड़ पर सँ नीचाँ आबि एक समतल स्‍थान मे ठाढ़ भेलाह। ओतऽ हुनकर शिष्‍यक विशाल समूह और आन-आन ठामक लोक सभक बड़का भीड़ छल। ओ सभ सौंसे यहूदिया प्रदेश सँ, यरूशलेम सँ, और समुद्रक कछेर पर बसल सूर आ सीदोन नगर सँ हुनकर उपदेश सुनबाक लेल और अपना बिमारी सँ स्‍वस्‍थ होयबाक लेल ओतऽ आयल छल। ");
INSERT INTO mai_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","दुष्‍टात्‍मा सँ पीड़ित लोक सभ सेहो ठीक कयल जाइत छल। ");
INSERT INTO mai_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","सभ केओ यीशु केँ छुबाक कोशिश करैत छल, कारण, हुनका मे सँ जे सामर्थ्‍य बहराइत छल, ताहि सँ सभ लोक स्‍वस्‍थ होइत छल। ");
INSERT INTO mai_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","यीशु अपना शिष्‍य सभक दिस तकैत कहऽ लगलथिन, “धन्‍य छी अहाँ सभ, जिनका किछु नहि अछि, किएक तँ परमेश्‍वरक राज्‍य अहाँ सभक अछि। ");
INSERT INTO mai_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","धन्‍य छी अहाँ सभ, जे एखन भूखल छी, किएक तँ अहाँ सभ तृप्‍त कयल जायब। धन्‍य छी अहाँ सभ, जे एखन कनैत छी, किएक तँ अहाँ सभ हँसब। ");
INSERT INTO mai_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“धन्‍य छी अहाँ सभ जखन लोक सभ मनुष्‍य-पुत्रक कारणेँ अहाँ सभ सँ घृणा करत, अपना समाज सँ बारि देत, अहाँ सभ केँ अपमानित करत, और दुष्‍ट मानि कऽ अहाँ सभक नामो नहि लेत। ");
INSERT INTO mai_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","तहिया अहाँ सभ आनन्‍द मनाउ और खुशी सँ कुदू-फानू, किएक तँ स्‍वर्ग मे अहाँ सभक लेल बड़का इनाम राखल अछि। ठीक एहने व्‍यवहार ओकरा सभक पूर्वज सभ परमेश्‍वरक प्रवक्‍ता लोकनिक संग सेहो कयने छलनि। ");
INSERT INTO mai_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","मुदा धिक्‍कार अछि अहाँ सभ केँ, जे सम्‍पत्तिशाली छी, किएक तँ अहाँ सभ अपन सभ सुख भोगि लेने छी। ");
INSERT INTO mai_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","धिक्‍कार अछि अहाँ सभ केँ, जे एखन तृप्‍त छी, किएक तँ अहाँ सभ भूखल रहब। धिक्‍कार अछि अहाँ सभ केँ, जे एखन हँसैत छी, किएक तँ अहाँ सभ शोक मनायब आ कानब। ");
INSERT INTO mai_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“धिक्‍कार अहाँ सभ केँ, जखन सभ लोक अहाँ सभक प्रशंसा करत, किएक तँ ठीक एहने व्‍यवहार ओकर सभक पूर्वज सभ ताहि लोकक संग सेहो कयने छलैक जे सभ झूठ बाजि कऽ अपना केँ परमेश्‍वरक प्रवक्‍ता कहैत छल। ");
INSERT INTO mai_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“मुदा हम अहाँ सभ केँ, जे हमर बात सुनि रहल छी, कहैत छी जे, अपना शत्रु सभ सँ प्रेम करू; जे सभ अहाँ सँ घृणा करैत अछि, तकरा सभक संग भलाइ करू। ");
INSERT INTO mai_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","जे सभ अहाँ केँ सराप दैत अछि, तकरा सभ केँ आशीर्वाद दिऔक। जे सभ अहाँक संग दुर्व्‍यवहार करैत अछि, तकरा सभक लेल प्रभु सँ प्रार्थना करू। ");
INSERT INTO mai_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","जँ केओ अहाँक एक गाल पर थप्‍पड़ मारैत अछि, तँ ओकरा समक्ष दोसरो गाल कऽ दिऔक। जँ केओ अहाँक ओढ़ना छिनैत अछि, तँ अपन कुर्तो ओकरा लेबऽ दिऔक। ");
INSERT INTO mai_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","जे केओ अहाँ सँ किछु माँगय तकरा दिऔक, आ जँ केओ अहाँक कोनो वस्‍तु लऽ लेत तँ ओकरा सँ फेर नहि माँगू। ");
INSERT INTO mai_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","जेहन व्‍यवहार अहाँ चाहैत छी जे लोक अहाँक संग करय, तेहने व्‍यवहार अहूँ लोकक संग करू। ");
INSERT INTO mai_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“जँ तकरे सभ सँ प्रेम करैत छी जे सभ अहाँ सँ प्रेम करैत अछि, तँ ओहि मे अहाँक प्रशंसाक कोन बात भेल? ‘पापिओ’ सभ तकरा सभ सँ प्रेम करैत अछि जे सभ ओकरा सभ सँ प्रेम करैत छैक। ");
INSERT INTO mai_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","आ जँ अहाँ तकरे सभक भलाइ करैत छी जे सभ अहाँक भलाइ करैत अछि, तँ ओहि मे अहाँक कोन बड़प्‍पन? ‘पापिओ’ सभ तँ एहिना करैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","और जँ अहाँ तकरे सभ केँ पैंच-उधार दैत छी जकरा सँ फेर फिरता पयबाक आशा रखैत छी, तँ ओहि मे अहाँक कोन प्रशंसा? ‘पापिओ’ सभ तँ ई आशा राखि कऽ जे हमरा फेर पूरा भेटि जायत ‘पापी’ सभ केँ पैंच-उधार दैत छैक। ");
INSERT INTO mai_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","नहि! अपना दुश्‍मनो सभ सँ प्रेम करू! ओकरा सभक संग भलाइ करू, और फेर फिरता पयबाक आशा नहि राखि कऽ पैंच-उधार दिऔक। अहाँक इनाम पैघ होयत, और परम-परमेश्‍वरक सन्‍तान ठहरब। कारण, जे सभ धन्‍यवाद देबाक भावना नहि रखैत अछि आ दुष्‍ट अछि, तकरो सभ पर ओ कृपा करैत छथिन। ");
INSERT INTO mai_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","दयालु बनू, जहिना अहाँक पिता दयालु छथि। ");
INSERT INTO mai_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“दोसराक न्‍याय नहि करू, तँ अहूँक न्‍याय नहि कयल जायत। दोसर केँ दोषी नहि ठहराउ, तँ अहूँ दोषी नहि ठहराओल जायब। माफ करिऔक, तँ अहूँ केँ माफ कयल जायत। ");
INSERT INTO mai_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","दिऔक, तँ अहूँ केँ देल जायत। पूरा-पूरी नाप, दबा-दबा कऽ, हिला-डोला कऽ आ उमड़ा-उमड़ा कऽ अहाँ केँ देल जायत। किएक तँ जाहि नाप सँ अहाँ नपैत छी, ताहि नाप सँ अहूँ केँ देल जायत।” ");
INSERT INTO mai_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","तकरबाद ओ हुनका सभ केँ ई दृष्‍टान्‍त दैत कहलथिन, “की एक आन्‍हर दोसर आन्‍हर केँ बाट देखा सकैत अछि? की एहि तरहेँ दूनू खधिया मे नहि खसत? ");
INSERT INTO mai_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","चेला अपना गुरु सँ पैघ नहि होइत अछि, मुदा जखन ओ पूर्ण शिक्षा प्राप्‍त करत तखन अपना गुरु जकाँ बनत। ");
INSERT INTO mai_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“अहाँ अपन भायक आँखि मेहक काठक कुन्‍नी किएक देखैत छी? की अपना आँखि मेहक ढेंग नहि सुझाइत अछि? ");
INSERT INTO mai_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","अपना भाय केँ अहाँ कोना कहैत छी जे, ‘हौ भाइ, लाबह, हम तोरा आँखि मे सँ ओ कुन्‍नी निकालि दैत छिअह’, जखन कि अपना आँखि मेहक ढेंग नहि देखैत छी? हे पाखण्‍डी! पहिने अपना आँखि मेहक ढेंग निकालि लिअ, तखने अपन भायक आँखि मेहक कुन्‍नी निकालबाक लेल अहाँ ठीक सँ देखि सकब। ");
INSERT INTO mai_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“नीक गाछ मे खराब फल नहि फड़ैत अछि, आ ने खराब गाछ मे नीक फल। ");
INSERT INTO mai_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","प्रत्‍येक गाछ ओकर अपन फल सँ चिन्‍हल जाइत अछि। लोक काँटक गाछ सँ अंजीर-फल नहि तोड़ैत अछि, आ ने काँटक झाड़ी सँ अंगूर। ");
INSERT INTO mai_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","नीक मनुष्‍य नीक वस्‍तु सँ भरल अपना हृदयक भण्‍डार मे सँ नीक वस्‍तु सभ निकालैत अछि, और अधलाह मनुष्‍य अपन अधलाह वस्‍तु सँ भरल भण्‍डार मे सँ अधलाह वस्‍तु सभ बाहर करैत अछि। कारण, जाहि बात सँ ओकर हृदय भरल छैक, सैह बात सभ ओकरा मुँह सँ बहराइत रहैत छैक। ");
INSERT INTO mai_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“हमरा ‘प्रभु, प्रभु’ किएक कहैत छी, जखन की हमर कहल नहि करैत छी? ");
INSERT INTO mai_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","आब हम अहाँ सभ केँ कहैत छी जे, जे केओ हमरा लग अबैत अछि और हमर बात सुनि कऽ ओकर पालन करैत अछि, से केहन अछि। ");
INSERT INTO mai_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ओ ताहि आदमी सनक अछि जे घर बनयबाक समय मे गहींर तक खुनि कऽ पाथर पर न्‍यो रखलक। जखन बाढ़ि आयल और बाढ़िक रेत ओहि घर सँ टकरायल तँ ओकरा हिला नहि सकल, कारण ओ घर मजगूती सँ बनाओल गेल छल। ");
INSERT INTO mai_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","मुदा जे केओ हमर बात सुनैत अछि और ओकर पालन नहि करैत अछि, से ताहि आदमी जकाँ अछि जे बिनु न्‍यो रखनहि सोझे माटि पर घर बनौलक। ओहि घर सँ बाढ़िक पानि टकराइत देरी ओ घर खसि पड़ल आ पूरा नष्‍ट भऽ गेल।” ");
INSERT INTO mai_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","यीशु ई सभ उपदेश लोक सभ केँ सुनौलाक बाद कफरनहूम नगर मे अयलाह। ");
INSERT INTO mai_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ओतऽ रोमी सेनाक एकटा कप्‍तान छलाह जिनकर अति प्रिय नोकर बिमार भऽ कऽ मरऽ पर छलनि। ");
INSERT INTO mai_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ओ कप्‍तान यीशुक बारे मे सुनि कऽ हुनका लग किछु यहूदी बूढ़-प्रतिष्‍ठित सभ केँ निवेदन करबाक लेल पठौलथिन जे ओ आबि कऽ हुनका नोकर केँ स्‍वस्‍थ कऽ देथि। ");
INSERT INTO mai_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ओ सभ यीशु लग पहुँचि कऽ बहुत आग्रहपूर्बक विनती कयलथिन जे, “ओ आदमी एहि जोगरक छथि जे अहाँ हुनकर ई काज कऽ दियनि। ");
INSERT INTO mai_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ओ अपना सभक जाति सँ प्रेम करैत छथि, और हमरा सभक सभाघर वैह बनबा देने छथि।” ");
INSERT INTO mai_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","यीशु हुनका सभक संग विदा भऽ गेलथिन। ओ जखन कप्‍तानक घरक लग मे पहुँचलाह तँ कप्‍तान अपन किछु संगी सभ केँ हुनका लग ई कहबाक लेल पठौलथिन जे, “यौ प्रभु, अपने आरो कष्‍ट नहि कयल जाओ। हम एहि जोगरक नहि छी जे अपने हमरा घर मे आबी, ");
INSERT INTO mai_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","आ ने हम अपना केँ एहू जोगरक बुझलहुँ जे हम अपने लग जाइ। तेँ मात्र आज्ञा देल जाओ और हमर नोकर स्‍वस्‍थ भऽ जायत। ");
INSERT INTO mai_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","कारण हमहूँ शासनक अधीन मे छी, और हमरा अधीन मे सैनिक सभ अछि। हम एकटा केँ कहैत छिऐक, ‘जाह,’ तँ ओ जाइत अछि; दोसर केँ कहैत छिऐक, ‘आबह,’ तँ ओ अबैत अछि। अपना नोकर केँ कहैत छिऐक, ‘ई काज करह,’ तँ ओ करैत अछि।” ");
INSERT INTO mai_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","कप्‍तानक एहि बात सभ सँ यीशु केँ आश्‍चर्य लगलनि। ओ भीड़क लोक सभ जे हुनका पाछाँ चलि रहल छल तकरा सभक दिस घूमि कऽ कहलथिन, “हम अहाँ सभ केँ कहैत छी जे, एहन विश्‍वास हमरा कतौ नहि भेटल अछि—इस्राएलिओ सभ मे नहि।” ");
INSERT INTO mai_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","कप्‍तानक पठाओल संगी सभ जखन घुरि कऽ अयलाह तँ देखलनि जे नोकर एकदम स्‍वस्‍थ भऽ गेल अछि। ");
INSERT INTO mai_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","किछु दिनक बाद यीशु नाइन नामक नगर गेलाह। हुनका संग हुनकर शिष्‍य सभ और बहुत बड़का भीड़ सेहो छलनि। ");
INSERT INTO mai_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","यीशु जखन नगरक फाटक लग पहुँचलाह तँ देखैत छथि जे लोक सभ एक मुइल आदमी केँ नगर सँ बाहर लऽ जा रहल अछि। ओ मुइल आदमी अपना मायक एकमात्र बेटा छल और ओकर माय विधवा छलैक। विधवाक संग नगरक बहुते लोक सभ छलैक। ");
INSERT INTO mai_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ओकरा देखि कऽ प्रभु केँ बहुत दया लगलनि, और ओ कहलथिन, “नहि कानह।” ");
INSERT INTO mai_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","तकरबाद ओ आगाँ बढ़ि कऽ अर्थी केँ छुलनि। ताहि पर कान्‍ह देनिहार सभ ठाढ़ भऽ गेल। ओ कहलथिन, “हौ युवक, हम तोरा कहैत छिअह, उठह!” ");
INSERT INTO mai_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","मुइल आदमी उठि बैसल, और बाजऽ लागल। यीशु ओकरा मायक जिम्‍मा मे लगा देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ई देखि लोक सभ केँ बड़का डर सन्‍हिया गेलैक। ओ सभ परमेश्‍वरक स्‍तुति करैत कहऽ लागल, “हमरा सभक बीच मे परमेश्‍वरक एक पैघ प्रवक्‍ता आबि गेल छथि! परमेश्‍वर अपना लोक पर दया करबाक लेल उतरि आयल छथि!” ");
INSERT INTO mai_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","यीशुक सम्‍बन्‍ध मे ई खबरि सौंसे यहूदिया प्रदेश मे और लग-पासक सभ क्षेत्र मे पसरि गेल। ");
INSERT INTO mai_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","यूहन्‍नाक शिष्‍य सभ हुनका एहि सभ बातक बारे मे कहि सुनौलथिन। एहि पर यूहन्‍ना अपना शिष्‍य सभ मे सँ दू गोटे केँ बजा कऽ ई बात पुछबाक लेल प्रभु लग पठौलथिन जे, ");
INSERT INTO mai_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“ओ जे आबऽ वला छलाह, से की अहीं छी, वा हम सभ दोसराक बाट ताकू?” ");
INSERT INTO mai_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ओ सभ यीशु लग आबि कऽ कहलथिन, “बपतिस्‍मा देनिहार यूहन्‍ना हमरा सभ केँ अहाँ सँ ई पुछबाक लेल पठौलनि अछि जे, ओ जे आबऽ वला छलाह, से की अहीं छी, वा हम सभ दोसराक बाट ताकू?” ");
INSERT INTO mai_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ओही काल मे यीशु बहुत लोक केँ बिमारी, पीड़ा और दुष्‍टात्‍मा सभ सँ मुक्‍त कऽ देलथिन, और बहुत आन्‍हर सभ केँ देखबाक शक्‍ति देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","तखन ओ यूहन्‍नाक शिष्‍य सभ केँ उत्तर देलथिन, “अहाँ सभ जे किछु देखलहुँ और सुनलहुँ से सभ बात जा कऽ यूहन्‍ना केँ सुना दिऔन—आन्‍हर सभ देखि रहल अछि, नाङड़ सभ चलि-फिरि रहल अछि, कुष्‍ठ-रोगी सभ स्‍वस्‍थ कयल जा रहल अछि, बहीर सभ सुनि रहल अछि, मुइल सभ जिआओल जा रहल अछि, और असहाय सभ केँ शुभ समाचार सुनाओल जा रहल छैक। ");
INSERT INTO mai_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","धन्‍य अछि ओ जे हमरा कारणेँ अपना विश्‍वास केँ नहि छोड़ैत अछि।” ");
INSERT INTO mai_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","यूहन्‍ना द्वारा पठाओल शिष्‍य सभ जखन चल गेलाह तँ यीशु यूहन्‍नाक बारे मे भीड़क संग बात करैत पुछलथिन, “अहाँ सभ निर्जन क्षेत्र मे की देखबाक लेल गेल छलहुँ? हवा सँ हिलैत खड़ही केँ?... ");
INSERT INTO mai_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","तखन की देखऽ लेल निकलल छलहुँ? बढ़ियाँ-बढ़ियाँ वस्‍त्र पहिरने कोनो मनुष्‍य केँ? नहि, कारण जे सभ नीक-नीक वस्‍त्र पहिरैत अछि और सुख-विलासक जीवन बितबैत अछि, से सभ राजभवन मे भेटैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","तँ फेर की देखबाक लेल गेल छलहुँ? परमेश्‍वरक एकटा प्रवक्‍ता केँ? हँ! हम अहाँ सभ केँ कहैत छी, प्रवक्‍तो सँ पैघ व्‍यक्‍ति केँ देखलहुँ! ");
INSERT INTO mai_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ई वैह दूत छथि जिनका सम्‍बन्‍ध मे धर्मशास्‍त्र मे लिखल अछि, प्रभु कहैत छथि, ‘देखू, अहाँ सँ पहिने हम अपन दूत पठायब, जे अहाँक आगाँ-आगाँ अहाँक बाट तैयार करत।’ ");
INSERT INTO mai_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","हम अहाँ सभ केँ कहैत छी जे, मनुष्‍य सभ मे यूहन्‍ना सँ पैघ केओ कहियो जन्‍म नहि लेने अछि। तैयो परमेश्‍वरक राज्‍य मे जे सभ सँ छोट अछि, से हुनका सँ पैघ अछि। ");
INSERT INTO mai_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“सभ लोक—कर असूल करऽ वला सभ सेहो—यूहन्‍नाक बात सुनि कऽ ई मानि लेलक जे परमेश्‍वरक बात ठीक अछि, कारण ओ सभ यूहन्‍ना सँ बपतिस्‍मा लेलक। ");
INSERT INTO mai_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","मुदा फरिसी और धर्म-नियमक पंडित सभ हुनका सँ बपतिस्‍मा नहि लऽ कऽ हुनका सभक लेल जे परमेश्‍वरक योजना छलनि, तकरा ओ सभ व्‍यर्थ कऽ लेलनि।” ");
INSERT INTO mai_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","यीशु आगाँ कहलथिन, “तँ एहि पीढ़ीक लोकक तुलना हम कोन बात सँ करू जे ई सभ केहन अछि? ");
INSERT INTO mai_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ई सभ बजार मे बैसल ओहि बच्‍चा सभ सनक अछि जे, एक-दोसर केँ सोर पारि कऽ कहैत अछि, ‘हम सभ तँ तोरा सभक लेल बाँसुरी बजौलिऔ, मुदा तोँ सभ नचलें नहि। हम सभ कन्‍ना-रोहटि कयलिऔ, मुदा तोँ सभ कनलें नहि।’ ");
INSERT INTO mai_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","कारण, बपतिस्‍मा देनिहार यूहन्‍ना अयलाह, और लोक सभ जकाँ रोटी नहि खाइत छथि, मदिरा नहि पिबैत छथि तँ अहाँ सभ कहैत छी जे, ‘ओकरा मे दुष्‍टात्‍मा छैक।’ ");
INSERT INTO mai_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","मनुष्‍य-पुत्र आयल, और खाइत-पिबैत अछि, तँ अहाँ सभ कहैत छी जे, ‘यैह देखू! केहन पेटू आ पिअक्‍कड़! कर असूल करऽ वला आ पापी सभक संगी!’ ");
INSERT INTO mai_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","मुदा परमेश्‍वरक बुद्धि ठीक अछि, से बात तेहन लोक द्वारा प्रमाणित होइत अछि जे सभ ओहि बुद्धिक अनुसार चलैत अछि।” ");
INSERT INTO mai_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","एक फरिसी यीशु केँ अपना संग भोजन करबाक निमन्‍त्रण देलथिन। यीशु हुनका घर गेलाह, और भोजन करबाक लेल बैसलाह। ");
INSERT INTO mai_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ओहि नगर मे रहऽ वाली एकटा स्‍त्रीगण, जे पापी जीवन बितबैत छलि, जखन सुनलक जे यीशु ओहि फरिसीक घर मे भोजन पर बैसल छथि, तँ ओ संगमरमरक बर्तन मे सुगन्‍धित तेल लऽ कऽ आयल। ");
INSERT INTO mai_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","कनैत-कनैत ओ यीशुक पाछाँ पयर लग ठाढ़ भेलि, और ओकर नोर हुनकर पयर पर खसैत छलैक। ओ हुनकर पयर अपना केश सँ पोछऽ लगलनि, और पयरक चुम्‍मा लैत ओहि पर तेल लगाबऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ओ फरिसी जे हुनका बजौने छलथिन से ई देखि अपना मोन मे सोचलनि, “ई आदमी जँ वास्‍तव मे परमेश्‍वरक प्रवक्‍ता रहैत तँ केहन स्‍त्री ओकरा छुबि रहल छैक, से ओ जनने रहैत—ओ बुझि जाइत जे ई केहन पापिनि अछि!” ");
INSERT INTO mai_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","यीशु जबाब देलथिन, “सिमोन, हमरा अहाँ केँ किछु कहबाक अछि।” ओ कहलथिन, “गुरुजी, बाजू ने।” ");
INSERT INTO mai_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“कोनो महाजन केँ दूटा ऋणी छलनि। ओहि मे सँ एकटा पर पाँच सय ‘दिनार’ ऋण छलनि, आ दोसर पर पचास ‘दिनार’। ");
INSERT INTO mai_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","दूनू लग अपन ऋण चुकयबाक लेल किछु नहि छलैक, तँ महाजन दूनू केँ माफ कऽ देलथिन। आब ओहि दूनू मे सँ कोन हुनका बेसी मानतनि?” ");
INSERT INTO mai_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","सिमोन उत्तर देलथिन, “हमरा होइत अछि जे ओ, जकर बेसी ऋण माफ भेलैक।” यीशु कहलथिन, “अहाँ ठीक कहलहुँ।” ");
INSERT INTO mai_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","तखन ओहि स्‍त्रीगणक दिस घूमि कऽ ओ सिमोन केँ कहलथिन, “एहि स्‍त्री केँ देखैत छिऐक? हम अहाँक घर मे अयलहुँ, तँ अहाँ हमरा पयर धोबाक लेल पानि नहि देलहुँ, मुदा ई हमर पयर अपन नोर सँ धोलक आ केश सँ पोछलक। ");
INSERT INTO mai_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","अहाँ चुम्‍मा लऽ कऽ हमर स्‍वागत नहि कयलहुँ, मुदा जखने हम घर मे अयलहुँ तखने सँ ई हमर पयरक चुम्‍मा लैते अछि। ");
INSERT INTO mai_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","अहाँ हमर माथ मे तेल नहि लगौलहुँ, मुदा ई हमर पयर पर सुगन्‍धित तेल लगौलक। ");
INSERT INTO mai_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","तेँ, हम अहाँ केँ कहैत छी जे, एकर पाप, जे बहुते अछि, से सभ माफ कयल गेल अछि, कारण देखू—कतेक प्रेम कयलक! मुदा जकरा कम माफ भेल छैक, से कम प्रेम करैत अछि।” ");
INSERT INTO mai_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","तखन ओ स्‍त्री केँ कहलथिन, “तोहर पाप माफ भेलह।” ");
INSERT INTO mai_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","जे सभ हुनका संग भोजन पर बैसल छल, से सभ अपना मे कहऽ लागल, “ई के छथि जे पापो माफ करैत छथि?” ");
INSERT INTO mai_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","यीशु स्‍त्री केँ कहलथिन, “तोहर विश्‍वास तोरा उद्धार देलकह। शान्‍ति सँ जाह।” ");
INSERT INTO mai_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","तकरबाद यीशु लोक सभ केँ परमेश्‍वरक राज्‍यक शुभ समाचार सुनबैत नगर-नगर आ गाम-गाम घुमऽ लगलाह। हुनका संग हुनकर बारहो शिष्‍य छलनि, ");
INSERT INTO mai_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","और किछु स्‍त्रीगण सभ सेहो, जिनका सभ केँ विभिन्‍न बिमारी आ दुष्‍टात्‍मा सभ सँ स्‍वस्‍थ कयल गेल छलनि। ओहि मे ई सभ छलीह—मरियम, जे मग्‍दलीनी कहबैत छलीह आ जिनका मे सँ सातटा दुष्‍टात्‍मा निकालल गेल छलनि, ");
INSERT INTO mai_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","हेरोद राजाक हाकिम खुसाक स्‍त्री योअन्‍ना, सुसन्‍ना आ आरो बहुत गोटे। ई स्‍त्रीगण सभ अपन व्‍यक्‍तिगत सम्‍पत्ति सँ हुनका सभक सेवा करैत छलीह। ");
INSERT INTO mai_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","नगर-नगर सँ लोक सभ यीशु लग आबि रहल छल, और एक दिन जखन बड़का भीड़ हुनका लग जमा भेल तँ ओ ई दृष्‍टान्‍त दऽ कऽ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“एक किसान बीया बाउग करबाक लेल गेल। बीया बाउग करैत काल, किछु बीया रस्‍ताक कात मे खसल, लतखुर्दन भऽ गेल और ओकरा चिड़ै सभ खा लेलकैक। ");
INSERT INTO mai_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","किछु बीया पथराह जमीन पर खसल, आ हाल नहि रहबाक कारणेँ जनमिते सुखा गेल। ");
INSERT INTO mai_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","किछु बीया काँट-कुशक बीच मे खसल, मुदा काँट-कुश सभ सेहो संगे-संग बढ़ि कऽ ओकरा दबा देलकैक। ");
INSERT INTO mai_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","किछु बीया नीक जमीन पर पड़ल। ओ बढ़ि कऽ फड़ल-फुलायल आ सय गुना फसिल देलक।” ई कहि कऽ ओ जोर सँ बजलाह, “जकरा सुनबाक कान छैक से सुनओ।” ");
INSERT INTO mai_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","तखन हुनकर शिष्‍य सभ एहि दृष्‍टान्‍तक अर्थ पुछलथिन। ");
INSERT INTO mai_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ओ उत्तर देलथिन, “परमेश्‍वरक राज्‍यक रहस्‍यक ज्ञान अहाँ सभ केँ देल गेल अछि, मुदा दोसर सभक लेल दृष्‍टान्‍ते सभ अछि, जाहि सँ, ‘तकितो ओ देखए नहि, सुनितो ओ बुझए नहि।’ ");
INSERT INTO mai_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“दृष्‍टान्‍तक अर्थ ई अछि—बीया परमेश्‍वरक वचन अछि। ");
INSERT INTO mai_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","रस्‍ताक कात मे खसल बीया ओ लोक सभ अछि जे हुनकर वचन सुनैत अछि मुदा शैतान आबि कऽ ओकरा सभक मोन मे सँ ओहि वचन केँ निकालि कऽ लऽ जाइत छैक, जाहि सँ कतौ ओ सभ विश्‍वास कऽ कऽ उद्धार नहि पाबए। ");
INSERT INTO mai_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","पथराह जमीन मे खसल बीया ओ लोक सभ अछि जे परमेश्‍वरक वचन सुनि खुशी सँ ओकरा स्‍वीकार करैत अछि, मुदा ओ वचन ओकरा सभ मे जड़ि नहि पकड़ैत छैक। ओ सभ किछु काल विश्‍वास तँ करैत अछि, मुदा परीक्षाक समय जखन अबैत छैक तँ विश्‍वास केँ छोड़ि दैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","काँट-कुश मे खसल बीया ओ लोक सभ अछि जे सुनैत तँ अछि, मुदा आगाँ जा कऽ जीवनक चिन्‍ता, धन-सम्‍पत्ति और सुख-विलास सभक द्वारा दबाओल जाइत अछि, और ओ सभ कोनो फसिल नहि दैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","मुदा नीक जमीन मे खसल बीया ओ लोक सभ अछि जे नीक और शुद्ध मोन सँ परमेश्‍वरक वचन सुनि कऽ अपना हृदय मे रखैत अछि, और धैर्यपूर्बक नीक फसिल दैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“केओ डिबिया लेसि कऽ ओकरा तौला सँ नहि झँपैत अछि, आ ने चौकीक तर मे रखैत अछि। ओ ओकरा लाबनि पर रखैत अछि जाहि सँ घरक भीतर आबऽ वला लोक सभ केँ इजोत भेटैक। ");
INSERT INTO mai_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","हँ, कोनो वस्‍तु नुकायल नहि अछि जे प्रगट नहि कयल जायत, आ ने कोनो वस्‍तु गुप्‍त अछि जे जानल नहि जायत और इजोत मे नहि आनल जायत। ");
INSERT INTO mai_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","एहि लेल, अहाँ सभ कोन प्रकारेँ सुनैत छी, ताहि पर नीक जकाँ ध्‍यान दिअ, कारण जकरा किछु छैक, तकरा आरो देल जयतैक, और जकरा नहि छैक, तकरा सँ सेहो लऽ लेल जयतैक जाहि केँ ओ अपन बुझैत अछि।” ");
INSERT INTO mai_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","यीशुक माय और भाय सभ हुनका सँ भेँट करबाक लेल अयलाह, मुदा भीड़क कारणेँ हुनका लग नहि पहुँचि सकलाह। ");
INSERT INTO mai_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","तँ हुनका लग कहा पठाओल गेलनि जे, “अहाँक माय और भाय सभ बाहर ठाढ़ छथि, अहाँ सँ भेँट करऽ चाहैत छथि।” ");
INSERT INTO mai_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","एहि पर यीशु उत्तर देलथिन, “हमर माय और भाय ओ सभ छथि जे सभ परमेश्‍वरक वचन सुनैत छथि और ओहि अनुसार चलैत छथि।” ");
INSERT INTO mai_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","एक दिन यीशु अपना शिष्‍य सभक संग नाव मे चढ़लाह आ कहलथिन, “झीलक ओहि पार चलू।” ओ सभ नाव खोलि देलनि। ");
INSERT INTO mai_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","किछु बढ़लाक बाद यीशु सुति रहलाह। एकाएक झील मे भयंकर अन्‍हड़-बिहारि आयल। नाव मे पानि भरऽ लागल, और ओ सभ बड़का विपत्ति मे पड़ि गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","शिष्‍य सभ यीशु केँ जगा कऽ कहलथिन, “मालिक, यौ मालिक, अपना सभ डुबऽ पर छी!” ओ उठि कऽ अन्‍हड़-बिहारि और लहरि केँ डँटलथिन। अन्‍हड़-बिहारि बन्‍द भऽ गेल, आ सभ किछु शान्‍त भऽ गेलैक। ");
INSERT INTO mai_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","तखन ओ अपना शिष्‍य सभ सँ पुछलथिन, “अहाँ सभक विश्‍वास की भऽ गेल?” ओ सभ भयभीत और आश्‍चर्यित भऽ एक-दोसर केँ कहऽ लगलाह, “ई के छथि? हवा और पानि केँ सेहो आज्ञा दैत छथिन तँ ओ मानैत छनि!” ");
INSERT INTO mai_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","जाइत-जाइत यीशु और हुनकर शिष्‍य सभ गिरासेनी सभक इलाका मे पहुँचलाह, जे गलील प्रदेशक सामने झीलक ओहि पार अछि। ");
INSERT INTO mai_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","यीशु जखने कछेर पर उतरलाह तँ ओहि शहरक एक आदमी भेटलनि जकरा दुष्‍टात्‍मा लागल छलैक। ई आदमी बहुत दिन सँ कपड़ा-लत्ता नहि पहिरैत छल, और घर मे नहि रहि कऽ कबरिस्‍तान मे रहैत छल। ");
INSERT INTO mai_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","यीशु केँ देखिते ओ जोर सँ चिकरल, हुनका पयर पर खसलनि, और जोर-जोर सँ कहलकनि, “यौ परम परमेश्‍वरक पुत्र यीशु! हमरा सँ अपने केँ कोन काज? हम विनती करैत छी जे हमरा दुःख नहि दिअ!” ");
INSERT INTO mai_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ओ ई बात एहि लेल कहलकनि जे यीशु दुष्‍टात्‍मा केँ ओकरा मे सँ बहरयबाक आज्ञा देने छलथिन। ओ दुष्‍टात्‍मा ओकरा बहुत बेर पकड़ने छलैक, और लोक ओकरा जिंजीर सँ हाथ-पयर बान्‍हि कऽ पहरा मे रखैत छल, मुदा ओ जिंजीर सभ केँ तोड़ि-ताड़ि लैत छल, और दुष्‍टात्‍मा ओकरा सुन-सान क्षेत्र सभ मे लऽ जाइत छलैक। ");
INSERT INTO mai_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","यीशु ओकरा सँ पुछलथिन, “तोहर नाम की छह?” ओ उत्तर देलकनि, “सेना” कारण, ओकरा मे बहुते दुष्‍टात्‍मा वास करैत छलैक। ");
INSERT INTO mai_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","दुष्‍टात्‍मा सभ हुनका सँ विनती करऽ लागल जे, हमरा सभ केँ “अथाह कुण्‍ड” मे जयबाक आज्ञा नहि दिअ। ");
INSERT INTO mai_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ओहिठाम पहाड़ पर सुगरक बड़का झुण्‍ड चरि रहल छल। दुष्‍टात्‍मा सभ विनती कयलकनि जे, हमरा सभ केँ ओहि सुगर सभ मे जयबाक अनुमति दऽ दिअ। तँ यीशु अनुमति दऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","तखन दुष्‍टात्‍मा सभ ओहि आदमी मे सँ निकलि कऽ सुगर सभ मे चल गेल। सुगरक पूरा झुण्‍ड दौड़ि कऽ पहाड़ पर सँ झील मे खसल और डुबि कऽ मरि गेल। ");
INSERT INTO mai_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","सुगर चराबऽ वला सभ ई देखि तुरत भागि गेल और नगर आ देहातो मे एहि घटनाक बारे मे सुनौलक। ");
INSERT INTO mai_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","एहि पर लोक सभ देखबाक लेल आयल, और यीशु लग जखन पहुँचल तँ देखैत अछि जे ओ आदमी जकरा मे सँ दुष्‍टात्‍मा निकलि गेल छल, से कपड़ा पहिरने आ स्‍वस्‍थ मोने हुनका पयर लग बैसल अछि। ई देखि ओ सभ भयभीत भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","जे सभ ई घटना देखने छल, से सभ ओहि लोक सभ केँ सुनौलकैक जे दुष्‍टात्‍मा लागल आदमी कोना स्‍वस्‍थ कयल गेल। ");
INSERT INTO mai_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","गिरासेनी सभक क्षेत्रक सम्‍पूर्ण परोपट्टाक लोक सभ केँ तेहन डर भऽ गेलैक जे ओ सभ यीशु सँ विनती करऽ लगलनि जे, अहाँ एतऽ सँ चल जाउ। एहि पर यीशु नाव मे चढ़ि कऽ घूमि गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","जाहि आदमी मे सँ दुष्‍टात्‍मा निकलि गेल छलैक, से यीशु सँ विनती कयलकनि जे, अपना संग हमरो चलऽ देल जाओ। मुदा यीशु ओकरा ई कहि कऽ विदा कयलथिन जे, ");
INSERT INTO mai_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“तोँ घर चल जाह, और परमेश्‍वर तोरा लेल कतेकटा काज कयलथुन से सभ केँ सुनाबह।” तखन ओ आदमी चल गेल, और यीशु ओकरा लेल जे-जतेक कयने रहथिन से सौंसे शहर मे लोक केँ सुनाबऽ लागल। ");
INSERT INTO mai_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","यीशु जखन झीलक एहि पार फेर पहुँचलाह तँ बड़का भीड़ जे एहि पार घूमि अयबाक हुनकर बाट ताकि रहल छलनि, से सभ हुनकर स्‍वागत कयलकनि। ");
INSERT INTO mai_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","तखने याइरस नामक एक आदमी यीशु लग अयलाह, जे सभाघरक अधिकारी छलाह। ओ यीशुक पयर पर खसि कऽ हुनका सँ आग्रह करऽ लगलथिन जे, हमरा ओतऽ चलल जाओ। ");
INSERT INTO mai_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","कारण, हुनकर एकमात्र बेटी, जे बारह वर्षक छलि, मरऽ-मरऽ पर छलि। रस्‍ता मे चलैत काल लोकक रेड़म-रेड़ा सँ यीशु पिचाय लगलाह। ");
INSERT INTO mai_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","भीड़ मे एक स्‍त्री छलि, जे बारह वर्ष सँ खून खसऽ वला रोग सँ पीड़ित छलि आ अपन सभ सम्‍पत्ति इलाजक पाछाँ वैद्य केँ दऽ देने छलि, मुदा ओकरा केओ नहि स्‍वस्‍थ कऽ सकल छल। ");
INSERT INTO mai_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ओ पाछाँ सँ आबि यीशुक वस्‍त्रक कोर छुबि लेलक, और ओकर खून खसनाइ तुरत बन्‍द भऽ गेलैक। ");
INSERT INTO mai_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","यीशु पुछलथिन, “हमरा के छुलक?” जखन सभ केओ अस्‍वीकार कयलक तँ पत्रुस कहलथिन, “यौ मालिक, अहाँ तँ भीड़ सँ घेरल छी आ लोक सभ चारू कात सँ अहाँ केँ पिचि रहल अछि!” ");
INSERT INTO mai_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","मुदा यीशु कहलथिन, “नहि, केओ हमरा छुलक अछि। हम जनैत छी जे हमरा मे सँ सामर्थ्‍य बहरायल अछि।” ");
INSERT INTO mai_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ओ स्‍त्री जखन देखलक जे हम नुकायल नहि रहि सकैत छी तँ कँपैत आबि यीशुक पयर पर खसलि, और सभ लोकक सामने कहि सुनौलकनि जे हुनका किएक छुलकनि आ कोना तुरत्ते स्‍वस्‍थ भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","तखन यीशु ओकरा कहलथिन, “बेटी, तोहर विश्‍वास तोरा स्‍वस्‍थ कऽ देलकह। शान्‍तिपूर्बक जाह।” ");
INSERT INTO mai_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","यीशु ई बात कहिए रहल छलथिन कि सभाघरक अधिकारी याइरसक घर सँ एक गोटे आयल और याइरस केँ कहलकनि, “अहाँक बच्‍ची नहि रहल। आब गुरुजी केँ आरो कष्‍ट नहि दिऔन।” ");
INSERT INTO mai_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ई बात सुनला पर यीशु याइरस केँ कहलथिन, “अहाँ डेराउ नहि, मात्र विश्‍वास राखू—अहाँक बेटी ठीक भऽ जायत।” ");
INSERT INTO mai_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","याइरसक ओहिठाम पहुँचला पर यीशु पत्रुस, यूहन्‍ना, याकूब और बच्‍चीक माय-बाबू केँ छोड़ि आरो ककरो अपना संग घरक भीतर नहि आबऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","सभ केओ बच्‍चीक लेल विलाप कऽ रहल छल, मुदा यीशु ओकरा सभ केँ कहलथिन, “नहि कानू! ओ मुइल नहि, सुतल अछि।” ");
INSERT INTO mai_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","एहि पर लोक सभ हुनका पर हँसऽ लागल, कारण ओ सभ जनैत छल जे बच्‍ची मरि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","मुदा यीशु बच्‍चीक हाथ पकड़ि कऽ कहलथिन, “बौआ! उठ!” ");
INSERT INTO mai_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","बच्‍चीक प्राण घूमि अयलैक और ओ तुरत ठाढ़ भऽ गेल। यीशु आदेश देलथिन जे ओकरा किछु खाय लेल देल जाय। ");
INSERT INTO mai_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ओकर माय-बाबू आश्‍चर्य-चकित भेलाह, मुदा यीशु हुनका सभ केँ आज्ञा देलथिन जे एहि घटनाक विषय मे ककरो संग चर्चा नहि करू। ");
INSERT INTO mai_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","यीशु अपन बारहो शिष्‍य केँ एक संग बजौलथिन, और हुनका सभ केँ सभ तरहक दुष्‍टात्‍मा केँ निकालबाक आ बिमारी सभ केँ ठीक करबाक शक्‍ति और अधिकार देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","तखन ओ हुनका सभ केँ परमेश्‍वरक राज्‍यक प्रचार करबाक लेल और रोगी सभ केँ स्‍वस्‍थ करबाक लेल गाम-गाम पठौलथिन। ");
INSERT INTO mai_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ओ कहलथिन, “बाटक लेल अहाँ सभ किछु नहि लऽ जाउ—ने लाठी ने झोरा, ने रोटी ने पाइ, आ ने दोसर अंगा राखू। ");
INSERT INTO mai_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","जाहि कोनो घर मे ठहरब, जाबत धरि ओहि गाम सँ विदा नहि होयब ताबत धरि ओही घर मे ठहरू। ");
INSERT INTO mai_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","और जतऽ कतौ लोक अहाँ सभक स्‍वागत नहि करय, ताहि गाम सँ विदा होइत काल अपन पयरक गर्दा झाड़ि लेब। ई ओकरा सभक विरोधक गवाही रहत।” ");
INSERT INTO mai_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","तँ ओ सभ विदा भेलाह और गाम-गाम मे शुभ समाचारक प्रचार करैत आ सभ ठाम लोक केँ स्‍वस्‍थ करैत घुमऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","एम्‍हर शासक हेरोद एहि सभ घटनाक विषय मे सुनलनि, और दुबिधा मे पड़ि गेलाह, कारण किछु लोकक कथन छलैक जे, बपतिस्‍मा देबऽ वला यूहन्‍ना मुइल सभ मे सँ जिआओल गेल छथि। ");
INSERT INTO mai_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","दोसर लोक सभ कहैत छल जे, एलियाह फेर आबि गेल छथि। आरो लोकक कथन छलैक जे, प्राचीन समयक परमेश्‍वरक अन्‍य प्रवक्‍ता सभ मे सँ केओ फेर जीबि उठल छथि। ");
INSERT INTO mai_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","मुदा हेरोद कहलनि, “यूहन्‍ना केँ तँ हम मूड़ी कटबा देने छिऐक, तँ फेर ई के अछि जकरा बारे मे एतेक बात सुनैत छी?” और ओ यीशु सँ भेँट करबाक कोशिश करऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","पठाओल गेल दूत सभ जहिया घूमि कऽ अयलाह तँ ओ सभ जे किछु कयने छलाह से सभ बात यीशु केँ कहि सुनौलथिन। तकरबाद यीशु हुनका सभ केँ अपना संग लऽ कऽ बेतसैदा नगर गेलाह, जाहि सँ ओ सभ एकान्‍त स्‍थान मे रहि सकथि। ");
INSERT INTO mai_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","मुदा लोक सभ केँ एहि बातक पता लागि गेलैक, और ओहो सभ हुनका पाछाँ-पाछाँ आबऽ लागल। यीशु ओकरा सभक स्‍वागत कयलथिन, और परमेश्‍वरक राज्‍यक सम्‍बन्‍ध मे ओकरा सभक संग बात-चीत करऽ लगलाह। जकरा ककरो कोनो बिमारी सँ स्‍वस्‍थ होयबाक आवश्‍यकता छलैक, तकरा सभ केँ ओ स्‍वस्‍थ कयलथिन। ");
INSERT INTO mai_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","जखन साँझ पड़ऽ लागल तँ बारहो शिष्‍य सभ यीशु लग आबि कऽ कहलथिन, “आब लोक सभ केँ लग-पासक गाम-बजार सभ मे अपना लेल राति मे रहबाक जगह आ भोजनक प्रबन्‍ध करबाक लेल विदा कऽ दिऔक, कारण अपना सभ एतऽ बस्‍ती सँ दूर मे छी।” ");
INSERT INTO mai_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ओ उत्तर देलथिन, “अहीं सभ एकरा सभ केँ भोजन करबिऔक।” ओ सभ कहलथिन, “हमरा सभ लग खाली पाँचटा रोटी आ दूटा माछ अछि, बस, आओर किछु नहि। वा की—एहि सभ लोकक लेल हम सभ भोजनक वस्‍तु किनि कऽ लाउ?” ");
INSERT INTO mai_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ओतऽ पुरुषक संख्‍या लगभग पाँच हजार छल। यीशु शिष्‍य सभ केँ कहलथिन, “सभ केँ पचास-पचासक समूह मे बैसा दिऔक।” ");
INSERT INTO mai_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","शिष्‍य सभ ओहिना कयलनि आ सभ केओ बैसि रहल। ");
INSERT INTO mai_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","तकरबाद यीशु ओ पाँचटा रोटी आ दूटा माछ लऽ लेलनि आ स्‍वर्ग दिस तकैत ओहि रोटी आ माछक लेल परमेश्‍वर केँ धन्‍यवाद देलनि। तखन रोटी आ माछ केँ तोड़लनि आ लोक सभ मे परसबाक लेल अपना शिष्‍य सभ केँ देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","सभ केओ भरि इच्‍छा भोजन कयलक। शिष्‍य सभ जखन रोटी आ माछक उबरल टुकड़ा सभ बिछलनि तँ ओ बारह छिट्टा भेल। ");
INSERT INTO mai_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","एक बेर यीशु एकान्‍त मे प्रार्थना कऽ रहल छलाह आ हुनकर शिष्‍य सभ हुनका संग छलनि, तँ ओ हुनका सभ सँ पुछलथिन जे, “हम के छी, ताहि सम्‍बन्‍ध मे लोक की कहि रहल अछि?” ");
INSERT INTO mai_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ओ सभ उत्तर देलथिन, “किछु लोक सभ ‘बपतिस्‍मा देनिहार यूहन्‍ना’ कहैत अछि, किछु लोक ‘एलियाह’ आ किछु लोक सभ कहैत अछि जे प्राचीन कालक परमेश्‍वरक प्रवक्‍ता लोकनि मे सँ केओ जीबि उठलाह अछि।” ");
INSERT INTO mai_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ओ पुछलथिन, “और अहाँ सभ?—अहाँ सभ की कहैत छी जे हम के छी?” पत्रुस उत्तर देलथिन, “अहाँ परमेश्‍वरक पठाओल उद्धारकर्ता-मसीह छी।” ");
INSERT INTO mai_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","एहि पर यीशु हुनका सभ केँ दृढ़तापूर्बक आदेश देलथिन जे, “ई बात ककरो नहि कहिऔक।” ");
INSERT INTO mai_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","फेर आगाँ कहऽ लगलथिन, “ई आवश्‍यक अछि जे मनुष्‍य-पुत्र बहुत दुःख सहय, बूढ़-प्रतिष्‍ठित, मुख्‍यपुरोहित आ धर्मशिक्षक सभ द्वारा तुच्‍छ ठहराओल जाय, जान सँ मारल जाय आ तेसर दिन जिआओल जाय।” ");
INSERT INTO mai_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","तखन यीशु सभ केँ कहलथिन, “जँ केओ हमर शिष्‍य बनऽ चाहैत अछि तँ ओ अपना केँ त्‍यागि, प्रतिदिन हमरा कारणेँ दुःख उठयबाक आ प्राणो देबाक लेल तैयार रहओ, और हमरा पाछाँ चलओ। ");
INSERT INTO mai_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","कारण, जे केओ अपन जीवन बचाबऽ चाहैत अछि, से ओकरा गमाओत, और जे केओ हमरा लेल अपन जीवन गमबैत अछि, से ओकरा बचाओत। ");
INSERT INTO mai_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","जँ कोनो मनुष्‍य सम्‍पूर्ण संसार केँ पाबि लय मुदा अपना केँ गमा लय वा नष्‍ट कऽ लय तँ ओकरा की लाभ भेलैक? ");
INSERT INTO mai_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","जँ केओ हमरा और हमर शिक्षा सँ लजाइत अछि, तँ ओकरो सँ मनुष्‍य-पुत्र ओहि समय मे लजायत जखन ओ अपना महिमाक संग आ पिताक और पवित्र स्‍वर्गदूत सभक महिमाक संग आओत। ");
INSERT INTO mai_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","और हम अहाँ सभ केँ सत्‍य कहैत छी जे एतऽ किछु एहनो लोक सभ ठाढ़ अछि जे जाबत तक परमेश्‍वरक राज्‍य नहि देखि लेत ताबत तक नहि मरत।” ");
INSERT INTO mai_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","एहि बात सभक करीब आठ दिनक बाद यीशु अपना संग पत्रुस, यूहन्‍ना और याकूब केँ लऽ कऽ प्रार्थना करबाक लेल पहाड़ पर गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","जखन ओ प्रार्थना कऽ रहल छलाह तँ हुनकर मुँहक रूप बदलि गेलनि, और हुनकर वस्‍त्र बिजलोका जकाँ चमकऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","एकाएक दू पुरुष, मूसा और एलियाह, ");
INSERT INTO mai_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","स्‍वर्गिक इजोत सँ चमकैत और यीशु सँ बात करैत देखाइ देलनि। ओ सभ हुनकर मृत्‍युक सम्‍बन्‍ध मे बात कऽ रहल छलाह, जकरा द्वारा ओ यरूशलेम मे परमेश्‍वरक इच्‍छा पूरा करऽ वला छलाह। ");
INSERT INTO mai_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पत्रुस और हुनकर संगी सभ औँघाय लागल छलाह, मुदा जखन पूर्ण रूप सँ सचेत भेलाह तँ यीशुक स्‍वर्गिक सुन्‍दरता और हुनका संग ठाढ़ ओहि दूनू पुरुष केँ देखलथिन। ");
INSERT INTO mai_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","जखन ओ दूनू पुरुष यीशु लग सँ विदा होमऽ लगलाह तँ पत्रुस यीशु केँ कहलथिन, “गुरुजी! हमरा सभक लेल ई कतेक नीक बात अछि जे हम सभ एतऽ छी! हम सभ एतऽ तीन मण्‍डप बनाबी—एक अहाँक लेल, एक मूसाक लेल, और एक एलियाहक लेल।” ओ अपनो नहि जनैत छलाह जे हम की बाजि रहल छी। ");
INSERT INTO mai_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ओ ई बात बाजिए रहल छलाह कि एकटा मेघ आबि कऽ हुनका सभ केँ झाँपि देलकनि। शिष्‍य सभ मेघ सँ झँपा कऽ डेरा गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","तखन मेघ मे सँ ई आवाज आयल, “ई हमर पुत्र छथि, जिनका हम चुनने छी। हिनका बात पर ध्‍यान दिअ!” ");
INSERT INTO mai_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ई आकाशवाणी भेलाक बाद शिष्‍य सभ देखलनि जे यीशु असगर छथि। एहि घटनाक सम्‍बन्‍ध मे ओ सभ चुप रहलाह और जे किछु देखने छलाह तकर चर्चा ओहि समय मे ककरो सँ नहि कयलनि। ");
INSERT INTO mai_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","प्रात भेने जखन ओ सभ पहाड़ पर सँ उतरलाह तँ यीशु केँ लोकक बड़का भीड़ भेटलनि। ");
INSERT INTO mai_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","भीड़ मेहक एक आदमी जोर सँ सोर पारि कऽ कहलथिन, “गुरुजी, अपने सँ हमर विनती अछि जे हमरा बेटा केँ देखल जाओ। ई हमर एकमात्र सन्‍तान अछि। ");
INSERT INTO mai_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","दुष्‍टात्‍मा एकरा पकड़ि लैत छैक, और ई एकाएक चिकरि उठैत अछि। एकरा नीचाँ पटकि दैत छैक आ एकरा मुँह सँ गाउज आबऽ लगैत छैक। बिनु चोट पहुँचौने एकरा छोड़िते नहि छैक। ");
INSERT INTO mai_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","हम अपनेक शिष्‍य सभ सँ एहि दुष्‍टात्‍मा केँ निकालबाक लेल विनती कयलियनि, मुदा ओ सभ नहि निकालि सकलाह।” ");
INSERT INTO mai_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","यीशु उत्तर देलथिन, “हे अविश्‍वासी आ भ्रष्‍ट पीढ़ीक लोक सभ! हम तोरा सभक संग कहिया तक रहिअह? कहिया तक तोरा सभ केँ सहैत रहिअह? आनह अपना बेटा केँ।” ");
INSERT INTO mai_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ओ लड़का आबि रहल छल कि दुष्‍टात्‍मा ओकरा नीचाँ पटकि देलकैक आ तोड़ऽ-ममोरऽ लगलैक। मुदा यीशु दुष्‍टात्‍मा केँ बहरयबाक आज्ञा दऽ कऽ लड़का केँ ठीक कऽ देलथिन, आ ओकरा अपना बाबू केँ जिम्‍मा मे दऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","परमेश्‍वरक सामर्थ्‍य और महानता केँ देखि कऽ सभ केओ आश्‍चर्य-चकित रहि गेल। लोक सभ यीशुक काज सभ देखि आश्‍चर्य मानैत छल, मुदा यीशु अपना शिष्‍य सभ केँ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“हम जे बात कहऽ जा रहल छी, अहाँ सभ ताहि बात पर ठीक सँ ध्‍यान दिअ—मनुष्‍य-पुत्र पकड़बा कऽ लोकक हाथ मे सौंपल जायत।” ");
INSERT INTO mai_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","मुदा ओ सभ हुनकर कहबाक अर्थ नहि बुझलनि। हुनका सभ सँ एहि बातक अर्थ नुकायल रहलनि, ताहि सँ नहि बुझि सकलाह, और ओ सभ हुनका सँ एहि सम्‍बन्‍ध मे पुछऽ सँ डेराइत छलाह। ");
INSERT INTO mai_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","शिष्‍य सभ मे एहि बातक विवाद होमऽ लगलनि जे, हमरा सभ मे सभ सँ पैघ के अछि? ");
INSERT INTO mai_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","यीशु हुनका सभक विचार बुझि एकटा छोट बच्‍चा केँ अपना लग मे ठाढ़ कयलनि ");
INSERT INTO mai_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","और शिष्‍य सभ केँ कहलथिन, “जे केओ हमरा नाम सँ एहि बच्‍चा केँ स्‍वीकार करैत अछि, से हमरे स्‍वीकार करैत अछि, और जे हमरा स्‍वीकार करैत अछि से हमरे नहि, बल्‍कि तिनको स्‍वीकार करैत छनि जे हमरा पठौने छथि। हँ, अहाँ सभ मे जे सभ सँ छोट होइ, सैह सभ सँ पैघ भेलहुँ।” ");
INSERT INTO mai_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","तखन यूहन्‍ना बजलाह, “मालिक, हम सभ एक आदमी केँ अहाँक नाम लऽ कऽ दुष्‍टात्‍मा निकालैत देखलहुँ, और ओकरा रोकबाक प्रयत्‍न कयलहुँ किएक तँ ओ हमरा सभक संग अहाँक शिष्‍य नहि अछि।” ");
INSERT INTO mai_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","यीशु उत्तर देलथिन, “हुनका नहि रोकिऔन, कारण जे अहाँक विरोध मे नहि अछि से अहाँक पक्ष मे अछि।” ");
INSERT INTO mai_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","जखन यीशु केँ स्‍वर्ग मे उठाओल जयबाक समय लगचिआय लगलनि तँ ओ यरूशलेम जयबाक दृढ़ निश्‍चय कयलनि, ");
INSERT INTO mai_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","और अपना सँ आगाँ किछु आदमी केँ पठौलथिन। ओ सभ विदा भऽ कऽ एक सामरी गाम मे हुनका लेल तैयारी करबाक लेल गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","मुदा ओहिठामक लोक सभ यीशुक स्‍वागत नहि कयलकनि, किएक तँ ओ यरूशलेम जा रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ई बात जखन हुनकर शिष्‍य याकूब और यूहन्‍ना देखलनि तँ बाजि उठलाह, “की प्रभु, हम सभ आज्ञा दऽ कऽ एकरा सभ केँ नष्‍ट करबाक लेल आकाश सँ आगि बरिसाउ?” ");
INSERT INTO mai_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","मुदा ओ हुनका सभक दिस घूमि कऽ डँटलथिन, ");
INSERT INTO mai_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","और ओ सभ दोसर गाम चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","रस्‍ता मे चलैत काल एक आदमी यीशु केँ कहलकनि, “अपने जतऽ कतौ जायब, ततऽ हमहूँ अपनेक संग चलब।” ");
INSERT INTO mai_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","यीशु ओकरा उत्तर देलथिन, “नढ़िया केँ सोन्‍हि छैक और आकाशक चिड़ै केँ खोंता, मुदा मनुष्‍य-पुत्र केँ मूड़िओ नुकयबाक जगह नहि छैक।” ");
INSERT INTO mai_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","दोसर आदमी केँ यीशु कहलथिन, “हमरा पाछाँ आउ।” मुदा ओ उत्तर देलकनि, “प्रभु, हमरा पहिने जा कऽ अपना बाबूक लास केँ गाड़ि आबऽ दिअ।” ");
INSERT INTO mai_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","यीशु कहलथिन, “मुरदे सभ केँ अपन मुरदा गाड़ऽ दिऔक। अहाँ जा कऽ परमेश्‍वरक राज्‍यक प्रचार करू।” ");
INSERT INTO mai_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","फेर दोसर कहलकनि, “प्रभुजी, हम अहाँक संग आयब। मुदा हमरा पहिने अपना परिवार सँ विदा लेबऽ दिअ।” ");
INSERT INTO mai_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","यीशु उत्तर देलथिन, “जे केओ हऽर पर हाथ राखि कऽ पाछाँ देखैत अछि से परमेश्‍वरक राज्‍यक योग्‍य नहि अछि।” ");
INSERT INTO mai_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","एहि सभक बाद प्रभु बहत्तरि आरो व्‍यक्‍ति केँ नियुक्‍त कयलथिन और हुनका सभ केँ दू-दू गोटे कऽ प्रत्‍येक नगर आ गाम मे पठा देलथिन जतऽ-जतऽ ओ अपने जाय वला छलाह। ");
INSERT INTO mai_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ओ हुनका सभ केँ कहलथिन, “पाकल फसिल तँ बहुत अछि, मुदा काटऽ वला मजदूर कम अछि। तेँ खेतक मालिक सँ प्रार्थना करिऔन जे ओ अपना खेत मे आरो मजदूर पठबथि। ");
INSERT INTO mai_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","अहाँ सभ आब जाउ। हम अहाँ सभ केँ जंगली जानबर सभक बीच मे भेँड़ी जकाँ पठा रहल छी। ");
INSERT INTO mai_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","अपना संग ने बटुआ लिअ आ ने झोरा आ ने जुत्ता; रस्‍ता मे ककरो सँ हाल-समाचार पुछबाक लेल नहि रूकू। ");
INSERT INTO mai_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","जखन कोनो घर मे प्रवेश करब, तँ पहिने ई कहिऔक, ‘एहि घर मे शान्‍ति होअय।’ ");
INSERT INTO mai_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","जँ ओतऽ केओ शान्‍तिक पात्र होयत तँ अहाँक आशीर्वाद ओकरा पर बनल रहतैक, अन्‍यथा अहाँ लग घूमि आओत। ");
INSERT INTO mai_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","वासक लेल घर-घर नहि घुमू, और जे किछु ओ सभ अहाँ सभ केँ देत से खाउ-पीबू, कारण मजदूर केँ मजदूरी तँ भेटबाक चाही। ");
INSERT INTO mai_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“हँ, जखन कोनो नगर मे प्रवेश कयलाक बाद स्‍वागत होइत अछि तँ जे किछु अहाँक सामने राखल जाय से खाउ। ");
INSERT INTO mai_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ओतुक्‍का बिमार लोक सभ केँ ठीक करू, और लोक सभ केँ कहिऔक जे, परमेश्‍वरक राज्‍य अहाँ सभक लग मे आबि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","मुदा जखन कोनो नगर मे जायब और ओहि ठामक लोक सभ अहाँ सभक स्‍वागत नहि करय तँ ओहि नगरक सड़क-ग‍ली सभ मे जा कऽ कहिऔक, ");
INSERT INTO mai_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘अहाँ सभक नगरक गर्दो जे हमरा सभक पयर मे लागल अछि से अहाँ सभक विरोध मे झाड़ैत छी। तैयो ई बात जानि लिअ जे परमेश्‍वरक राज्‍य लग मे आबि गेल अछि।’ ");
INSERT INTO mai_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","हम अहाँ सभ केँ कहैत छी जे, न्‍यायक दिन मे ओहि नगर सँ सदोम नगरक दशा सहबा जोगरक रहतैक। ");
INSERT INTO mai_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“है खुराजीन नगर, तोरा धिक्‍कार छौक! हे बेतसैदा नगर, तोरा धिक्‍कार छौक! जे चमत्‍कार सभ तोरा सभक बीच कयल गेल, से जँ सूर और सीदोन नगर सभ मे कयल गेल रहैत तँ ओहिठामक निवासी सभ बहुत पहिनहि चट्टी ओढ़ि और छाउर पर बैसि अपना पापक लेल पश्‍चात्ताप कऽ हृदय-परिवर्तन कऽ लेने रहैत। ");
INSERT INTO mai_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","न्‍यायक दिन मे तोरा सभक अपेक्षा सूर आ सीदोन नगरक दशा सहबा जोगरक रहतैक। ");
INSERT INTO mai_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","और हे कफरनहूम नगर! की तोँ स्‍वर्ग तक उठाओल जयबेँ? नहि! तोँ तँ पाताल मे खसाओल जयबेँ। ");
INSERT INTO mai_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“जे केओ अहाँ सभक बात सुनैत अछि से हमर बात सुनैत अछि। जे केओ अहाँ सभ केँ अस्‍वीकार करैत अछि, से हमरा अस्‍वीकार करैत अछि, और जे केओ हमरा अस्‍वीकार करैत अछि से तिनका अस्‍वीकार करैत छनि जे हमरा पठौलनि।” ");
INSERT INTO mai_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ओ बहत्तरि लोक सभ जखन अपन प्रचारक काज कऽ कऽ अयलाह तँ बहुत खुशीपूर्बक बजलाह, “प्रभुजी, अहाँक नामक शक्‍ति सँ दुष्‍टात्‍मा सभ सेहो हमरा सभक बात मानलक।” ");
INSERT INTO mai_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","यीशु उत्तर देलथिन, “हम शैतान केँ बिजुली जकाँ आकाश सँ खसैत देखलहुँ। ");
INSERT INTO mai_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","हँ, हम अहाँ सभ केँ साँप और बीछ केँ पिचबाक सामर्थ्‍य और शत्रुक समस्‍त शक्‍ति पर अधिकार देने छी। कोनो वस्‍तु अहाँ सभक हानि नहि कऽ सकत। ");
INSERT INTO mai_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","तैयो, एहि लेल आनन्‍द नहि मनाउ जे दुष्‍टात्‍मा सभ अहाँ सभक बात मानैत अछि, बल्‍कि एही लेल आनन्‍दित होउ जे अहाँ सभक नाम स्‍वर्ग मे लिखायल अछि।” ");
INSERT INTO mai_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","तखने यीशु पवित्र आत्‍मा सँ अत्‍यन्‍त आनन्‍दित भऽ कऽ बजलाह, “हे पिता, स्‍वर्ग आ पृथ्‍वीक मालिक, हम अहाँ केँ एहि लेल धन्‍यवाद दैत छी जे अहाँ ई बात सभ बुद्धिमान और विद्वान सभ सँ नुका कऽ रखलहुँ मुदा बच्‍चा सभ पर प्रगट कयलहुँ। हँ पिता, कारण, अहाँ केँ एही बात सँ प्रसन्‍नता भेल। ");
INSERT INTO mai_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“हमरा पिता द्वारा सभ किछु हमरा हाथ मे सौंपल गेल अछि। पुत्र के छथि, से पिता केँ छोड़ि आरो केओ नहि जनैत अछि, और पिता के छथि, सेहो केओ नहि जनैत अछि—मात्र पुत्र और जकरा सभ पर पुत्र हुनका प्रगट करऽ चाहय, से जनैत अछि।” ");
INSERT INTO mai_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","तखन ओ अपना शिष्‍य सभक दिस घूमि कऽ नहुएँ जोर सँ कहलथिन, “अहाँ सभ धन्‍य छी जे, जे बात सभ देखि रहल छी से देखि पौलहुँ। ");
INSERT INTO mai_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","कारण, हम अहाँ सभ केँ कहैत छी जे अपना समय मे एहन बहुत राजा और परमेश्‍वरक प्रवक्‍ता लोकनि रहथि, जे सभ चाहलनि जे, जाहि बात सभ केँ अहाँ सभ देखि रहल छी, तकरा देखी, मुदा नहि देखलनि; और जे बात सभ अहाँ सभ सुनि रहल छी, से सुनी, मुदा नहि सुनलनि।” ");
INSERT INTO mai_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","एक बेर धर्म-नियमक एक पंडित उठि कऽ यीशु केँ जँचबाक लेल पुछलथिन, “गुरुजी, अनन्‍त जीवन प्राप्‍त करबाक लेल हम की करू?” ");
INSERT INTO mai_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","यीशु उत्तर देलथिन, “धर्म-नियम मे की लिखल अछि? ओहि मे की पढ़ैत छी?” ");
INSERT INTO mai_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ओ कहलथिन, “ ‘तोँ अपन प्रभु-परमेश्‍वर केँ अपन सम्‍पूर्ण मोन सँ, अपन सम्‍पूर्ण आत्‍मा सँ, अपन सम्‍पूर्ण शक्‍ति सँ और अपन सम्‍पूर्ण बुद्धि सँ प्रेम करह,’ और ‘तोँ अपना पड़ोसी केँ अपने जकाँ प्रेम करह।’” ");
INSERT INTO mai_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","यीशु कहलथिन, “अहाँ ठीक कहलहुँ। एना करू तँ जीवन पायब।” ");
INSERT INTO mai_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","मुदा ओ अपना केँ ठीक ठहरयबाक उद्देश्‍य सँ यीशु सँ पुछलथिन, “तँ हमर पड़ोसी के अछि?” ");
INSERT INTO mai_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","यीशु उत्तर देलथिन, “एक आदमी यरूशलेम सँ यरीहो नगर जा रहल छल कि डाकू सभ आबि कऽ ओकरा घेरि लेलकैक। ओकरा नाङट कऽ कऽ आ मारैत-मारैत अधमरू बना कऽ छोड़ि देलकैक। ");
INSERT INTO mai_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","संयोग सँ एक पुरोहित ओहि रस्‍ता सँ जा रहल छलाह। ओ जखन ओहि आदमी केँ देखलनि तँ रस्‍ता काटि कऽ आगाँ बढ़ि गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","तहिना मन्‍दिरक एक सेवक जखन ओहि स्‍थान पर अयलाह आ ओकरा देखलनि तँ ओहो रस्‍ता काटि कऽ आगाँ बढ़ि गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","मुदा सामरी जातिक एक आदमी जे ओहि दने जाइत रहय से ओकरा देखि कऽ दया सँ भरि गेल। ");
INSERT INTO mai_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ओ ओकरा लग जा कऽ ओकर घाव सभ पर तेल और दारू लगा कऽ पट्टी बान्‍हि देलकैक। तखन ओकरा अपना गदहा पर बैसा कऽ एकटा सराय मे लऽ गेल और ओहिठाम ओकर सेवा कयलकैक। ");
INSERT INTO mai_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","प्रात भेने ओ दू चानीक रुपैया निकालि कऽ सरायक मालिक केँ दऽ कऽ कहलकनि, ‘हिनकर देखभाल करिऔन। एहि सँ बेसी जे खर्च पड़त से हम घुमती काल मे अहाँ केँ दऽ देब।’ ");
INSERT INTO mai_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","आब अहाँक विचार सँ, एहि तीनू मे सँ डाकू सभक हाथ मे पड़ल आदमीक पड़ोसी अपना केँ के बुझलक?” ");
INSERT INTO mai_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","धर्म-नियमक पंडित उत्तर देलथिन, “जे ओकरा पर दया कयलकैक, से।” यीशु कहलथिन, “अहूँ जा कऽ एहिना करू।” ");
INSERT INTO mai_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","यीशु और हुनकर शिष्‍य सभ आगाँ बढ़ि कऽ एक गाम मे अयलाह जतऽ मार्था नामक एक स्‍त्री अपना ओहिठाम हुनकर अतिथि-सत्‍कार कयलथिन। ");
INSERT INTO mai_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ओहि स्‍त्री केँ मरियम नामक एकटा बहिन छलनि। ओ यीशुक पयर लग बैसि हुनकर बात सुनि रहल छलीह। ");
INSERT INTO mai_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","मुदा मार्था सेवा-सत्‍कारक भार सँ चिन्‍तित छलीह। ओ यीशु लग आबि कऽ कहलथिन, “प्रभु, अहाँ केँ कनेको चिन्‍ता नहि अछि जे हमर बहिन सभटा काज करऽ लेल हमरा असगरे छोड़ि देने अछि? ओकरा हमर मदति करबाक लेल कहिऔक!” ");
INSERT INTO mai_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","प्रभु उत्तर देलथिन, “मार्था, अए मार्था! अहाँ बहुत बातक लेल चिन्‍तित छी, ");
INSERT INTO mai_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","मुदा बात एकेटा जरूरी अछि। मरियम वैह नीक बात चुनि लेने अछि और ओकरा सँ ओ नहि छिनल जयतैक।” ");
INSERT INTO mai_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","एक दिन यीशु कोनो स्‍थान पर प्रार्थना कऽ रहल छलाह। जखन ओ प्रार्थना समाप्‍त कयलनि तखन हुनकर एक शिष्‍य कहलथिन, “प्रभु, जहिना यूहन्‍ना अपना शिष्‍य सभ केँ प्रार्थना कयनाइ सिखौलनि, तहिना अहूँ हमरा सभ केँ सिखाउ।” ");
INSERT INTO mai_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","यीशु हुनका सभ केँ कहलथिन, “जखन अहाँ सभ प्रार्थना करब तँ एना कहू— हे पिता, अहाँक नाम पवित्र मानल जाय। अहाँक राज्‍य आबय। ");
INSERT INTO mai_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","हमरा सभ केँ प्रत्‍येक दिन भोजन दिअ, जे दिन प्रति दिन हमरा सभक लेल आवश्‍यक अछि। ");
INSERT INTO mai_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","हमरा सभक पाप क्षमा करू, किएक तँ हमहूँ सभ तकरा सभ केँ क्षमा करैत छी जे सभ हमरा सभक संग अपराध करैत अछि। और हमरा सभ केँ पाप मे फँसाबऽ वला बात सँ दूर राखू।” ");
INSERT INTO mai_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","तखन यीशु हुनका सभ केँ कहलथिन, “मानि लिअ जे अहाँ सभ मे सँ ककरो कोनो संगी होइक और ओ ओहि संगीक ओहिठाम दुपहरिया राति मे जा कऽ कहैक जे, ‘यौ मित्र, हमरा तीनटा रोटी दिअ। ");
INSERT INTO mai_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","कारण, हमर एक मित्र जे यात्रा पर छथि से हमरा ओतऽ एखने अयलाह अछि और हुनका भोजन करयबाक लेल हमरा लग किछु नहि अछि।’ ");
INSERT INTO mai_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","तँ की भीतर सँ ओकर संगी उत्तर देतैक जे, ‘हमरा तंग नहि करू। केबाड़ लागल अछि और धिआ-पुता सभ हमरा लग सुतल अछि। हम अहाँ केँ किछु देबाक लेल नहि उठि सकैत छी।’? ");
INSERT INTO mai_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","हम अहाँ सभ केँ कहैत छी जे, ओ जँ ओकर संगी रहबाक कारणेँ उठि कऽ रोटी नहि देतैक तैयो ओकरा निःसंकोच भऽ कऽ मँगबाक कारणेँ ओ उठि कऽ ओकरा जतेक आवश्‍यकता छैक ततेक देतैक। ");
INSERT INTO mai_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","हँ, हम अहाँ सभ केँ कहैत छी जे, माँगू तँ अहाँ केँ देल जायत। ताकू तँ अहाँ केँ भेटत। ढकढकाउ तँ अहाँक लेल खोलल जायत। ");
INSERT INTO mai_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","कारण, जे केओ मँगैत अछि, से प्राप्‍त करैत अछि। जे केओ तकैत अछि, तकरा भेटैत छैक। और जे केओ ढकढकबैत अछि, तकरा लेल खोलल जाइत छैक। ");
INSERT INTO mai_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“अहाँ सभ मे सँ के एहन बाबू छी जे, बेटा जँ माछ माँगय तँ तकरा बदला मे साँप दिऐक? ");
INSERT INTO mai_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","वा जँ अण्‍डा माँगय तँ बीछ दिऐक? ");
INSERT INTO mai_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","जखन अहाँ सभ पापी होइतो अपना बच्‍चा सभ केँ नीक वस्‍तु सभ देनाइ जनैत छी, तँ अहाँ सभ सँ बढ़ि कऽ अहाँ सभक पिता जे स्‍वर्ग मे छथि, से मँगनिहार सभ केँ अपन पवित्र आत्‍मा किएक नहि देथिन?” ");
INSERT INTO mai_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","एक बेर यीशु एक बौक दुष्‍टात्‍मा केँ एक आदमी मे सँ निकालि रहल छलाह। दुष्‍टात्‍मा जखन निकलि गेल तँ बौक आदमी बाजऽ लागल। ई देखि लोक सभ चकित भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","मुदा कतेक गोटे कहऽ लागल, “ई तँ दुष्‍टात्‍मा सभक मुखिया बालजबूलक शक्‍ति सँ दुष्‍टात्‍मा सभ केँ निकालैत अछि।” ");
INSERT INTO mai_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","दोसर लोक हुनका जाँच करबाक लेल स्‍वर्ग सँ कोनो चमत्‍कारपूर्ण चिन्‍ह देखयबाक लेल कहलकनि। ");
INSERT INTO mai_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","मुदा यीशु ओकरा सभक विचार बुझि कऽ ओकरा सभ केँ कहलथिन, “जाहि राज्‍य मे फूट पड़ि जाय, से उजड़ि जाइत अछि, और जाहि परिवार मे फूट भऽ जाय से नष्‍ट भऽ जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","शैतान जँ स्‍वयं अपन विरोधी भऽ जाय तँ ओकर राज्‍य कोना टिकल रहतैक? हम ई बात एहि लेल कहैत छी जे अहाँ सभक कथन अछि जे हम दुष्‍टात्‍मा सभ केँ बालजबूलक शक्‍ति सँ निकालैत छी। ");
INSERT INTO mai_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","जँ हम बालजबूलक शक्‍ति सँ दुष्‍टात्‍मा निकालैत छी तँ अहाँ सभक चेला सभ ककरा शक्‍ति सँ निकालैत अछि? वैह सभ अहाँ सभक फैसला करत। ");
INSERT INTO mai_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","मुदा जँ हम परमेश्‍वरक शक्‍ति सँ दुष्‍टात्‍मा निकालैत छी तँ ई जानि लिअ जे परमेश्‍वरक राज्‍य अहाँ सभ लग पहुँचि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“जखन कोनो बलगर आदमी हाथ-हथियार सँ लैस भऽ कऽ अपन घरक रखबारी करैत अछि तँ ओकर धन-सम्‍पत्ति सुरक्षित रहैत छैक। ");
INSERT INTO mai_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","मुदा जखन ओकरो सँ बलगर कोनो दोसर आदमी ओकरा पर आक्रमण कऽ कऽ ओकरा पराजित करैत छैक, तँ ओ ओकर सभ हथियार जाहि पर ओकरा पूरा भरोसा रहैत छैक, से छिनि लैत अछि आ ओकर सम्‍पत्ति लुटि कऽ अपना संगी सभ मे बाँटि दैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“जे हमरा संग नहि अछि से हमरा विरोध मे अछि; जे हमरा संग जमा नहि करैत अछि से छिड़िअबैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“जखन दुष्‍टात्‍मा कोनो आदमी मे सँ बहरा जाइत अछि तँ ओ दुष्‍टात्‍मा मरुभूमि मे आराम करबाक स्‍थानक खोज मे घुमैत रहैत अछि, मुदा ओकरा भेटैत नहि छैक। तखन ओ कहैत अछि, ‘हम अपन पहिलुके घर मे, जतऽ सँ बहरा कऽ आयल छलहुँ ततहि फेर जायब।’ ");
INSERT INTO mai_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ओ जखन ओहिठाम पहुँचैत अछि और देखैत अछि जे ओ घर झाड़ल-बहारल साफ-सुथरा अछि, ");
INSERT INTO mai_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","तँ ओ जा कऽ अपनो सँ दुष्‍टाह सातटा आरो दुष्‍टात्‍मा केँ लऽ अनैत अछि आ ओ सभ ओहि घर मे अपन डेरा खसा लैत अछि। एहि तरहेँ ओहि आदमीक ई दशा पहिलुको दशा सँ खराब भऽ जाइत छैक।” ");
INSERT INTO mai_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","यीशु ई बात सभ कहिए रहल छलाह कि भीड़ मे एक स्‍त्री जोर सँ बाजि उठलि, “धन्‍य छथि ओ स्‍त्री जे अहाँ केँ जन्‍म देलनि और दूध पियौलनि!” ");
INSERT INTO mai_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","यीशु उत्तर देलथिन, “हँ, मुदा ताहू सँ धन्‍य छथि ओ सभ जे परमेश्‍वरक वचन सुनैत छथि और तकर पालन करैत छथि।” ");
INSERT INTO mai_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","जखन यीशुक चारू कात लोकक भीड़ बढ़ि गेल तँ ओ ओकरा सभ केँ कहलथिन, “एहि पीढ़ीक लोक कतेक दुष्‍ट अछि! कारण, ई चमत्‍कार वला चिन्‍ह मँगैत अछि, मुदा जे घटना परमेश्‍वरक प्रवक्‍ता योनाक संग भेल छलनि, से चिन्‍ह छोड़ि कऽ एकरा सभ केँ आरो कोनो चिन्‍ह नहि देखाओल जयतैक। ");
INSERT INTO mai_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","जहिना योना निनवे नगरक निवासी सभक लेल चिन्‍ह बनलाह, तहिना मनुष्‍य-पुत्र एहि पीढ़ीक लेल चिन्‍ह रहत। ");
INSERT INTO mai_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","दक्षिण देशक रानी एहि पीढ़ीक लोकक संग न्‍यायक दिन मे ठाढ़ भऽ कऽ एकरा सभ केँ दोषी ठहरौतीह, किएक तँ ओ सुलेमान राजाक बुद्धिक बात सभ सुनबाक लेल पृथ्‍वीक दोसर कात सँ अयलीह, और हम अहाँ सभ केँ कहैत छी, एतऽ एखन केओ एहन अछि जे सुलेमानो सँ महान् अछि। ");
INSERT INTO mai_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","निनवेक निवासी सभ न्‍यायक दिन मे एहि पीढ़ीक लोकक संग ठाढ़ भऽ कऽ एकरा सभ केँ दोषी ठहराओत, किएक तँ ओ सभ योनाक प्रचार सुनि कऽ अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन कयलक, और हम अहाँ सभ केँ कहैत छी, एतऽ एखन केओ एहन अछि जे योनो सँ महान् अछि। ");
INSERT INTO mai_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“केओ डिबिया लेसि कऽ ओकरा नुका कऽ नहि रखैत अछि, आ ने पथिया सँ झँपैत अछि। ओ ओकरा लाबनि पर रखैत अछि, जाहि सँ भीतर आबऽ वला लोक सभ केँ इजोत भेटैक। ");
INSERT INTO mai_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","शरीरक डिबिया अहाँक आँखि भेल। जखन आँखि ठीक अछि तँ अहाँक सम्‍पूर्ण शरीर इजोत मे रहैत अछि, मुदा जखन अहाँक आँखि खराब अछि तँ सम्‍पूर्ण शरीर अन्‍हार मे अछि। ");
INSERT INTO mai_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","तेँ सावधान रहू जे कतौ अहाँक भितरी इजोत अन्‍हार नहि बनि जाय। ");
INSERT INTO mai_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","एहि लेल जँ अहाँक सौंसे शरीर इजोत मे अछि, कोनो अंग अन्‍हार मे नहि अछि, तँ ओ पूर्ण रूप सँ इजोत सँ चमकत, जहिना डिबिया अपना प्रकाश सँ अहाँ केँ आलोकित करैत अछि।” ");
INSERT INTO mai_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","यीशु जखन ई सभ बात कहब समाप्‍त कयलनि, तँ हुनका एक फरिसी भोजनक लेल निमन्‍त्रण देलथिन। यीशु हुनका ओहिठाम गेलाह आ भोजन करबाक लेल भीतर मे बैसलाह। ");
INSERT INTO mai_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ई देखि जे यीशु भोजन करऽ सँ पहिने रीतिक अनुसार हाथ-पयर नहि धोलनि, फरिसी केँ बड्ड आश्‍चर्य लगलनि। ");
INSERT INTO mai_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","मुदा प्रभु हुनका कहलथिन, “अहाँ फरिसी सभ थारी-बाटी सभ केँ बाहर-बाहर तँ मँजैत छी, मुदा भीतर अहाँ सभ लोभ और दुष्‍टता सँ भरल छी। ");
INSERT INTO mai_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","है मूर्ख सभ! जे बाहरक भाग बनौलनि, की से भीतरको भाग नहि बनौलनि? ");
INSERT INTO mai_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","अहाँ सभक बाटी मे जे किछु अछि से गरीब सभ केँ दान करिऔक, तखन अहाँ सभक लेल सभ किछु शुद्ध होयत। ");
INSERT INTO mai_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“यौ फरिसी सभ, धिक्‍कार अछि अहाँ सभ केँ! कारण, अहाँ सभ पुदीना, मसल्‍ला और छोट सँ छोट साग-पात सभक दसम अंश तँ परमेश्‍वर केँ अर्पण करैत छी, मुदा न्‍याय और परमेश्‍वरक प्रेम सँ कोनो मतलब नहि रखैत छी। होयबाक तँ ई चाहैत छल जे ओ सभ बात करैत परमेश्‍वरक प्रेम और न्‍याय पर ध्‍यान दितहुँ। ");
INSERT INTO mai_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“यौ फरिसी सभ, धिक्‍कार अछि अहाँ सभ केँ! कारण, सभाघर सभ मे प्रमुख आसन पर बैसब और हाट-बजार मे लोकक प्रणाम स्‍वीकार करब अहाँ सभ केँ बहुत नीक लगैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“हँ, धिक्‍कार अछि अहाँ सभ केँ! कारण, अहाँ बिनु चिन्‍हक कबर सनक छी जाहि पर लोक बिनु बुझने चलैत-फिरैत अछि।” ");
INSERT INTO mai_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","एहि पर धर्म-नियमक एक पंडित यीशु केँ उत्तर देलथिन, “गुरुजी, एहन बात सभ कहि कऽ अहाँ हमरो सभक अपमान करैत छी।” ");
INSERT INTO mai_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","यीशु कहलथिन, “हँ, अहूँ सभ जे धर्म-नियमक पंडित छी, धिक्‍कार अछि अहाँ सभ केँ! अहाँ सभ लोक सभ पर तेहन बोझ लादि दैत छिऐक जे ओ सभ सहि नहि सकैत अछि और ओकरा सभ केँ बोझ उठाबऽ मे आङुरो भिड़ा कऽ मदति नहि करैत छिऐक। ");
INSERT INTO mai_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“धिक्‍कार अछि अहाँ सभ केँ! कारण, अहाँ सभ परमेश्‍वरक ओहि प्रवक्‍ता सभक कबर पर चबुतराक निर्माण करैत छी जिनका अहाँ सभक पूर्वज सभ जान सँ मारि देलकनि। ");
INSERT INTO mai_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","एहि तरहेँ अहाँ सभ स्‍पष्‍ट करैत छी जे अपना पूर्वज सभक काज सँ सहमत छी। ओ सभ हुनका सभ केँ मारि देलकनि और अहाँ सभ हुनकर सभक कबर बनबैत छी। ");
INSERT INTO mai_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","एहि कारणेँ सर्वज्ञानी परमेश्‍वर कहलनि, ‘हम ओकरा सभक ओहिठाम अपन प्रवक्‍ता और दूत लोकनि केँ पठयबैक। ओ सभ हिनका सभ मे सँ कतेको गोटे केँ मारि देतनि और कतेको गोटे केँ सतौतनि।’ ");
INSERT INTO mai_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","तेँ सृष्‍टिक आरम्‍भ सँ परमेश्‍वरक जतेक प्रवक्‍ताक खून बहाओल गेल अछि तकर लेखा एहि पीढ़ीक लोक सँ लेल जायत, ");
INSERT INTO mai_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","अर्थात् हाबिलक खून सँ लऽ कऽ, मन्‍दिरक बलि-वेदी और ‘पवित्र स्‍थान’क बीच मे मारल गेल जकरयाहक खून धरिक लेखा। हम अहाँ सभ केँ कहैत छी जे तकर पूरा लेखा एही पीढ़ीक लोक सँ लेल जायत। ");
INSERT INTO mai_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“यौ धर्म-नियमक पंडित सभ, धिक्‍कार अछि अहाँ सभ केँ! कारण, अहाँ सभ ओ कुंजी छिनि कऽ रखने छी जे ज्ञानक द्वारि खोलैत अछि। अहाँ सभ अपनो नहि प्रवेश कयलहुँ, और जे सभ प्रवेश कऽ रहल छल तकरो सभ केँ रोकि देलिऐक।” ");
INSERT INTO mai_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","जखन यीशु ओहिठाम सँ चल गेलाह तँ फरिसी और धर्मशिक्षक सभ हुनकर कड़ा विरोध करऽ लागल। ओ सभ एहि बातक घात लगा कऽ हुनका सँ विभिन्‍न विषय मे प्रश्‍न करऽ लगलनि जे हुनकर कोनो कहल बात द्वारा हुनका फँसाबी। ");
INSERT INTO mai_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","एम्‍हर हजारो-हजार लोकक भीड़ जुटि गेल, एतऽ तक जे लोक सभ एक-दोसर सँ पिचाय लागल। तखन यीशु सभ सँ पहिने अपना शिष्‍य सभ केँ कहलथिन, “फरिसी सभक रोटी फुलाबऽ वला खमीर सँ सावधान रहू—हमर कहबाक अर्थ अछि, हुनका सभक कपटपन सँ। ");
INSERT INTO mai_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","एहन किछु नहि अछि जे झाँपल होअय आ उघारल नहि जायत, वा जे नुकाओल होअय आ प्रगट नहि कयल जायत। ");
INSERT INTO mai_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","अहाँ जे किछु अन्‍हार मे कहने छी से इजोत मे सुनल जायत, और जे किछु बन्‍द कयल कोठली मे कानो-कान फुसफुसा कऽ बाजल छी, से छत पर सँ घोषणा कयल जायत। ");
INSERT INTO mai_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“हे हमर मित्र सभ, हम अहाँ सभ केँ कहैत छी जे, तकरा सभ सँ नहि डेराउ जे सभ शरीर केँ मारि दैत अछि मुदा आओर किछु नहि कऽ सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","किनका सँ डेराइ से हम कहैत छी—तिनका सँ डेराउ, जिनका अहाँक शरीर केँ मारि देलाक बाद अहाँ केँ नरको मे फेकबाक अधिकार छनि। हँ, हुनके सँ डेराउ! ");
INSERT INTO mai_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","की दू पाइ मे पाँचटा बगेड़ी नहि बिकाइत अछि? तैयो परमेश्‍वर ओकरा सभ मे सँ एकोटा केँ नहि बिसरैत छथि। ");
INSERT INTO mai_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","हँ, अहाँ सभक माथक एक-एकटा केशो गनल अछि। नहि डेराउ—अहाँ सभ बहुतो बगेड़ी सँ मूल्‍यवान छी! ");
INSERT INTO mai_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“हम अहाँ सभ केँ कहैत छी जे, जे केओ मनुष्‍यक सामने हमरा अपन प्रभु मानि लेत, तकरो मनुष्‍य-पुत्र परमेश्‍वरक स्‍वर्गदूत सभक सामने अपन लोक मानि लेतैक। ");
INSERT INTO mai_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","मुदा जे केओ मनुष्‍यक सामने हमरा अस्‍वीकार करत, तकरो हम परमेश्‍वरक स्‍वर्गदूत सभक सामने अस्‍वीकार करबैक। ");
INSERT INTO mai_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","और जे केओ मनुष्‍य-पुत्रक विरोध मे कोनो बात कहत, तकरा क्षमा कयल जयतैक, मुदा जे केओ पवित्र आत्‍माक निन्‍दा करत, तकरा क्षमा नहि कयल जयतैक। ");
INSERT INTO mai_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“जखन लोक सभ अहाँ सभ केँ सभाघर, शासक सभ और अधिकारी सभक समक्ष लऽ जायत, तँ एकर चिन्‍ता नहि करू जे हम अपन वयान मे की उत्तर देबैक वा की कहबैक, ");
INSERT INTO mai_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","किएक तँ पवित्र आत्‍मा ओही घड़ी अहाँ सभ केँ सिखा देताह जे की कहबाक चाही।” ");
INSERT INTO mai_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","तखन भीड़ मे सँ केओ यीशु केँ कहलकनि, “यौ गुरुजी, हमरा भैया केँ हमरा संग बाबूक सम्‍पत्तिक बटबारा करबाक लेल कहिऔन।” ");
INSERT INTO mai_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","मुदा ओ उत्तर देलथिन, “हौ भाइ, हमरा तोहर सभक पंच वा बटबारा करऽ वला के बनौलक?” ");
INSERT INTO mai_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","तखन ओ लोक सभ केँ कहलथिन, “सावधान! सभ तरहक लोभ सँ बाँचल रहू! कारण, मनुष्‍यक जीवन ओकर धन-सम्‍पत्ति पर निर्भर नहि रहैत छैक, ओ चाहे कतबो धनिक होअय।” ");
INSERT INTO mai_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","तखन ओ ओकरा सभ केँ ई दृष्‍टान्‍त दऽ कऽ कहलथिन, “कोनो धनी आदमीक खेत मे बहुत उपजा भेलैक। ");
INSERT INTO mai_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ओ मोने-मोन सोचलक जे, ‘आब हम की करू? हमरा लग अपन अन्‍न रखबाक लेल जगहे नहि अछि।’ ");
INSERT INTO mai_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","तखन सोचलक, ‘हम एना करब—ई सभ बखारी तोड़ि कऽ आरो नमहर-नमहर बना लेब, और ओही सभ मे हम अपन सभ अन्‍न और धन-सम्‍पत्ति राखब। ");
INSERT INTO mai_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","तखन हम अपना केँ कहब, ले, तोरा बहुते वर्षक लेल सम्‍पत्ति राखल छौ। आब आराम कर, खो-पी और आनन्‍द कर!’ ");
INSERT INTO mai_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","मुदा परमेश्‍वर ओकरा कहलथिन, ‘है मूर्ख, आइए राति तोहर प्राण तोरा सँ लऽ लेल जयतौ। तखन अपना लेल एतेक जे जमा कऽ लेलें, से ककर होयतैक?’ ” ");
INSERT INTO mai_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","यीशु आगाँ कहलथिन, “एहने दशा तकरा होयतैक जे केओ अपना लेल धन जुटबैत अछि मुदा परमेश्‍वरक नजरि मे धनिक नहि अछि।” ");
INSERT INTO mai_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","तखन यीशु अपना शिष्‍य सभ केँ कहलथिन, “एहि लेल हम अहाँ सभ केँ कहैत छी जे, प्राणक लेल चिन्‍ता नहि करू जे हम की खायब, आ ने शरीरक लेल चिन्‍ता करू जे की पहिरब। ");
INSERT INTO mai_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","कारण, प्राण भोजन सँ महत्‍वपूर्ण अछि आ शरीर वस्‍त्र सँ। ");
INSERT INTO mai_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","कौआ केँ देखू। ओ सभ ने बाउग करैत अछि आ ने कटनी। ओकरा सभ केँ ने कोठी छैक आ ने बखारी। तैयो परमेश्‍वर ओकरा सभ केँ खुअबैत छथिन। और अहाँ सभ तँ चिड़ै सभ सँ कतेक मूल्‍यवान छी! ");
INSERT INTO mai_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","अहाँ सभ मे सँ के चिन्‍ता कऽ कऽ अपन उमेर केँ एको पल बढ़ा सकैत छी? ");
INSERT INTO mai_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","जँ ई छोट सँ छोट बात नहि कऽ सकैत छी, तँ आओर बातक चिन्‍ता किएक करैत छी? ");
INSERT INTO mai_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“मैदानक फूल सभ केँ देखू, जे कोना बढ़ैत अछि। ओ सभ ने खटैत अछि आ ने चर्खा कटैत अछि। तैयो हम अहाँ सभ केँ कहैत छी जे, राजा सुलेमान सेहो अपन राजसी वस्‍त्र पहिरि कऽ एहि फूल सन सुन्‍दर नहि लगैत छलाह। ");
INSERT INTO mai_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","परमेश्‍वर जँ घास केँ, जे आइ मैदान मे अछि और काल्‍हि आगि मे फेकल जायत, एहि प्रकारेँ हरियरी सँ भरल रखैत छथि, तँ ओ अहाँ सभ केँ आओर किएक नहि पहिरौताह-ओढ़ौताह? अहाँ सभ केँ कतेक कम विश्‍वास अछि! ");
INSERT INTO mai_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","तेँ अहाँ सभ अपन मोन एहि सोच मे नहि लगौने रहू जे, हम की खायब और की पीब। एकर चिन्‍ता मे नहि लागल रहू। ");
INSERT INTO mai_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","एहि संसारक लोक सभ, जे परमेश्‍वर केँ नहि चिन्‍हैत छनि, से सभ एहि बात सभक पाछाँ दौड़ैत रहैत अछि। अहाँ सभक पिता तँ जनैत छथि जे अहाँ सभ केँ एहि बात सभक आवश्‍यकता अछि। ");
INSERT INTO mai_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","नहि! परमेश्‍वरक राज्‍य पर मोन लगाउ, और इहो वस्‍तु सभ अहाँ केँ देल जायत। ");
INSERT INTO mai_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“हे हमर भेँड़ाक छोट समूह, नहि डेराउ, किएक तँ अहाँ सभक पिता खुशी सँ अपन राज्‍य अहाँ सभ केँ देबाक निर्णय कऽ लेने छथि। ");
INSERT INTO mai_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","अपन सम्‍पत्ति बेचि कऽ गरीब सभ केँ दिअ। अपना लेल एहन बटुआ बना लिअ जे कहियो नहि पुरान होइत अछि, स्‍वर्ग मे धन जमा करू जे कहियो घटैत नहि अछि, जकरा ने चोर छुबि सकैत अछि आ ने कीड़ा नोकसान कऽ सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","कारण, जतऽ अहाँक धन अछि ततहि अहाँक मोनो लागल रहत। ");
INSERT INTO mai_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“अहाँ सभ अपन डाँड़ कसने रहू, और डिबिया लेसने रहू। ");
INSERT INTO mai_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ओहि नोकर सभ जकाँ रहू जे अपना मालिकक बाट ताकि रहल अछि जे, ओ विवाहक भोज खा कऽ कखन औताह जाहि सँ जखने आबि केबाड़ खटखटौताह तँ तुरत्ते खोलि दियनि। ");
INSERT INTO mai_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","कतेक नीक ओहि नोकर सभक लेल होयतैक, जकरा सभ केँ मालिक अयला पर प्रतीक्षा करैत पौताह। हम अहाँ सभ केँ कहैत छी जे, मालिक अपन फाँड़ बान्‍हि कऽ ओकरा सभ केँ भोजन करबाक लेल बैसौथिन, और अपने सँ ओकरा सभ केँ परसि कऽ खुऔथिन। ");
INSERT INTO mai_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","हँ, ओहि नोकर सभक लेल कतेक नीक होयत, जकरा सभ केँ मालिक रातिक दोसरो वा तेसरो पहर मे आबि कऽ तैयार पौथिन। ");
INSERT INTO mai_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","मुदा ई बात जानि लिअ जे, घरक मालिक जँ बुझने रहैत जे चोर कय बजे आबि रहल अछि, तँ ओ अपना घर मे सेन्‍ह नहि काटऽ दैत। ");
INSERT INTO mai_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","अहूँ सभ सदिखन तैयार रहू, कारण मनुष्‍य-पुत्र एहने समय मे आबि जयताह जाहि समयक लेल अहाँ सभ सोचबो नहि करब जे ओ एखन औताह।” ");
INSERT INTO mai_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","पत्रुस पुछलथिन, “प्रभु, की ई दृष्‍टान्‍त अहाँ हमरे सभक लेल कहि रहल छी, वा सभक लेल?” ");
INSERT INTO mai_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","प्रभु उत्तर देलथिन, “तँ के अछि ओहन विश्‍वासपात्र आ बुद्धिमान भण्‍डारी जकरा मालिक अपना नोकर-चाकर सभक मुखिया बना दैत छथि जे ओ निश्‍चित समय पर ओकरा सभ केँ निर्धारित भोजन दैक? ");
INSERT INTO mai_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ओहि सेवकक लेल कतेक नीक होयत, जकरा मालिक आबि कऽ ओहिना करैत पौताह। ");
INSERT INTO mai_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","हम अहाँ सभ केँ सत्‍य कहैत छी जे, मालिक अपन सम्‍पूर्ण सम्‍पत्तिक जबाबदेही ओकरा जिम्‍मा मे दऽ देथिन। ");
INSERT INTO mai_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","मुदा जँ ओ सेवक अपना मोन मे सोचऽ लागय जे, ‘हमर मालिक आबऽ मे बहुत देरी कऽ रहल अछि,’ और ओ नोकर-नोकरनी सभ केँ मारऽ-पिटऽ लागय आ खाय-पिबऽ मे लागि कऽ मातल रहऽ लागय, ");
INSERT INTO mai_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","तँ ओकर मालिक एहन दिन मे घूमि औताह जहिया ओ हुनकर बाट नहि तकैत रहत आ एहन समय मे औताह जकरा ओ नहि जानत। मालिक ओकरा खण्‍डी-खण्‍डी कऽ देथिन और ओकर अन्‍त ओहन होयतैक जे अविश्‍वासी सभक होइत छैक। ");
INSERT INTO mai_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“ओ सेवक जे अपन मालिकक इच्‍छा तँ जनैत अछि मुदा तकरा पूरा करबाक लेल किछु नहि करैत अछि, से बहुत मारि खायत। ");
INSERT INTO mai_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","मुदा जे नहि जनैत अछि आ तखन मारि खाय जोगरक काज करैत अछि, से कम मारि खायत। जकरा बहुत देल गेल छैक, तकरा सँ बहुत माँगलो जयतैक, आ जतेक आओर बेसी ककरो देल गेल छैक, ततेक आओर फेर ओकरा घुमाबऽ पड़तैक। ");
INSERT INTO mai_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“हम पृथ्‍वी पर आगि लगाबऽ आयल छी, और हमरा बड्ड इच्‍छा अछि जे ओ एखने सुनगि गेल रहैत। ");
INSERT INTO mai_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","मुदा हमरा एकटा बड़का कष्‍ट भोगबाक अछि, और जाबत तक ओ बात पूर्ण नहि होयत, ताबत तक हम कतेक व्‍याकुल छी! ");
INSERT INTO mai_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","की अहाँ सभ सोचैत छी जे हम पृथ्‍वी पर मेल-मिलाप करयबाक लेल आयल छी? नहि! हम अहाँ सभ केँ कहैत छी जे, मेल-मिलाप नहि, बल्‍कि फूट! ");
INSERT INTO mai_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","आब सँ एके परिवार मे पाँच व्‍यक्‍ति एक-दोसराक विरोधी भऽ जायत, तीन गोटेक विरोध मे दू, आ दू गोटेक विरोध मे तीन। ");
INSERT INTO mai_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","अपना मे फूट भऽ जायत—बाबू बेटाक विरोध मे, आ बेटा बाबूक विरोध मे, माय बेटीक विरोधी, आ बेटी मायक, सासु पुतोहुक विरोधी, आ पुतोहु सासुक।” ");
INSERT INTO mai_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","यीशु भीड़क लोक सभ केँ इहो कहलथिन, “पश्‍चिम मे मेघ उठैत देखिते अहाँ सभ कहैत छी जे, वर्षा होयत, और से होइतो अछि। ");
INSERT INTO mai_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","और जखन दछिनाही बहैत देखैत छी तँ कहैत छी जे, बड्ड गर्मी पड़त, और से पड़बो करैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","यौ पाखण्‍डी सभ! पृथ्‍वी और आकाशक लक्षण अहाँ सभ चिन्‍हि लैत छी, तँ एहि वर्तमान समयक लक्षण सभ किएक नहि चिन्‍हैत छी? ");
INSERT INTO mai_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“अहाँ सभ अपने किएक नहि निर्णय करैत छी जे उचित की अछि? ");
INSERT INTO mai_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","केओ अहाँ पर मोकदमा कऽ कऽ कचहरी लऽ जा रहल अछि, तँ बाटे मे ओकरा संग समझौता करबाक प्रयत्‍न करू। एना नहि होअय जे ओ अहाँ केँ न्‍यायाधीशक समक्ष बलजोरी लऽ जाय, न्‍यायाधीश अहाँ केँ सिपाहीक हाथ मे दऽ देअय, आ सिपाही अहाँ केँ जहल मे बन्‍द कऽ देअय। ");
INSERT INTO mai_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","हम अहाँ केँ कहैत छी जे, जाबत धरि अहाँ पाइ-पाइ कऽ सधा नहि देबैक, ताबत धरि ओतऽ सँ नहि छुटब।” ");
INSERT INTO mai_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","तखने किछु लोक यीशु लग आबि कऽ हुनका किछु गलीली सभक बारे मे सुनौलकनि जे, कोना ओ सभ जखन बलि चढ़ा रहल छल तँ राज्‍यपाल पिलातुस ओकर सभक हत्‍या करबा देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","यीशु उत्तर देलथिन, “की अहाँ सभ बुझैत छी जे ई गलील निवासी सभ आओर सभ गलील निवासी सँ अधिक पापी छल जे ओकरा सभ पर ई विपत्ति अयलैक? ");
INSERT INTO mai_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","हम अहाँ सभ केँ कहैत छी जे, नहि! मुदा अहाँ सभ जँ अपना पापक लेल पश्‍चात्ताप कऽ हृदय-परिवर्तन नहि करब, तँ अहूँ सभ एहिना नाश होयब। ");
INSERT INTO mai_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","वा ओ अठारह गोटे जकरा सभ पर शिलोहक मिनार खसि पड़ल आ पिचा कऽ मरि गेल, की अहाँ सभ बुझैत छी जे ओ सभ यरूशलेमक आओर सभ निवासी सँ बेसी दोषी छल? ");
INSERT INTO mai_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","हम अहाँ सभ केँ कहैत छी जे, नहि! मुदा अहाँ सभ जँ अपना पापक लेल पश्‍चात्ताप कऽ हृदय-परिवर्तन नहि करब, तँ अहूँ सभ एहिना नाश होयब।” ");
INSERT INTO mai_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","यीशु ओकरा सभ केँ ई दृष्‍टान्‍त दऽ कऽ कहलथिन, “एक आदमीक अंगूर-उद्यान मे एक अंजीरक गाछ छल। ओ ओहि सँ फल तोड़बाक लेल गेल, मुदा ओकरा किछुओ नहि भेटलैक। ");
INSERT INTO mai_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","तखन ओ माली केँ कहलकैक, ‘देखह! हम तीन वर्ष सँ एहि गाछ सँ अंजीर तोड़ऽ अबैत छी, मुदा ई कोनो फले नहि दैत अछि। एकरा काटि दैह। ई बेकार जगहो छेकने अछि।’ ");
INSERT INTO mai_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","माली उत्तर देलकैक, ‘सरकार, एकरा एक वर्ष आओर रहऽ देल जाओ। हम एकरा चारू कात कोड़ि कऽ गोबर पटा देबैक। ");
INSERT INTO mai_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","तखन अगिला वर्ष जँ फड़त, तँ ठीक, नहि तँ अपने एकरा कटबा देबैक।’ ” ");
INSERT INTO mai_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","एक विश्राम-दिन मे यीशु एकटा सभाघर मे उपदेश दऽ रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ओहिठाम एक स्‍त्री छलि जकरा अठारह वर्ष सँ दुष्‍टात्‍मा लगबाक कारणेँ डाँड़ टुटल छलैक। ओ एकदम झुकल रहैत छलि और कनेको सोझ नहि भऽ सकैत छलि। ");
INSERT INTO mai_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","यीशु ओकरा देखि बजा कऽ कहलथिन, “बहिन, अहाँ अपना कष्‍ट सँ मुक्‍त भऽ गेलहुँ।” ");
INSERT INTO mai_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","तखन ओ ओकरा पर हाथ रखलनि, और ओ तुरत्ते सोझ भऽ गेलि आ परमेश्‍वरक स्‍तुति करऽ लागलि। ");
INSERT INTO mai_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","एहि पर सभाघरक अधिकारी तमसा गेलाह जे यीशु किएक विश्राम-दिन मे ककरो ठीक कयलनि, और ओ लोक सभ केँ कहलथिन, “छओ दिन अछि जाहि मे काज करबाक चाही। ओहि छओ दिन मे आउ और स्‍वस्‍थ कऽ देबाक लेल कहू, नहि कि विश्राम-दिन मे।” ");
INSERT INTO mai_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","प्रभु हुनका उत्तर देलथिन, “हे पाखण्‍डी सभ! की अहाँ सभ मे सँ प्रत्‍येक आदमी विश्राम-दिन मे अपन बड़द वा गदहा केँ थरि सँ खोलि कऽ पानि पिअयबाक लेल नहि लऽ जाइत छी? ");
INSERT INTO mai_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","तँ ई स्‍त्री जे अब्राहमक वंशज अछि, और जे अठारह वर्ष सँ शैतानक बन्‍हन मे छलि, की एकरा विश्राम-दिन मे एहि बन्‍हन सँ मुक्‍त नहि करबाक चाही?” ");
INSERT INTO mai_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","यीशु जखन ई बात कहलनि तँ हुनकर सभ विरोधी लज्‍जित भऽ गेल। मुदा लोक सभ हुनकर नीक-नीक काज सभ देखि अति आनन्‍दित भेल। ");
INSERT INTO mai_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","तखन यीशु कहलनि, “परमेश्‍वरक राज्‍य केहन अछि? ओकर तुलना हम कोन चीज सँ करू? ");
INSERT INTO mai_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ओ सरिसोक दाना जकाँ अछि जकरा किसान अपना बाड़ी मे बाउग कयलक। ओ बढ़ि कऽ नमहर गाछ बनि गेल, और ओकर ठाढ़ि मे आकाशक चिड़ै सभ आबि कऽ अपन खोंता बना लेलक।” ");
INSERT INTO mai_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","यीशु फेर कहलनि, “परमेश्‍वरक राज्‍यक हम कोन चीज सँ तुलना करू? ");
INSERT INTO mai_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ओ ओहि खमीर जकाँ अछि जकरा एक स्‍त्री तीन पसेरी आँटा मे मिला कऽ सनलक। बाद मे खमीरक शक्‍ति सँ पूरा आँटा फुलि गेलैक।” ");
INSERT INTO mai_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","तखन यीशु नगर-नगर और गाम-गाम घूमि कऽ लोक सभ केँ उपदेश दैत यरूशलेम दिस बढ़ऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","केओ हुनका सँ पुछलकनि, “प्रभु, की उद्धार पौनिहार किछुए लोक मात्र होयत?” ");
INSERT INTO mai_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ओ उत्तर देलथिन, “द्वारिक चौराइ कम अछि तेँ पूरा शक्‍ति सँ प्रवेश करबाक कोशिश करू। कारण, हम अहाँ सभ केँ कहैत छी जे, एहन बहुतो लोक होयत जे प्रवेश करऽ चाहत मुदा कऽ नहि सकत। ");
INSERT INTO mai_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","जखन घरक मालिक उठि कऽ केबाड़ बन्‍द कऽ लेताह तँ अहाँ सभ बाहर ठाढ़ भऽ कऽ केबाड़ केँ ढकढका कऽ कहऽ लागब जे, ‘प्रभु, हमरा सभक लेल खोलि दिअ।’ ओ उत्तर देताह, ‘हम तोरा सभ केँ नहि चिन्‍हैत छिअह आ नहि जनैत छिअह जे कतऽ सँ आयल छह।’ ");
INSERT INTO mai_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","तखन अहाँ सभ कहऽ लागब जे, ‘हम सभ तँ अहाँक संग खयलहुँ-पिलहुँ, और अहाँ हमरा सभक गाम-घर मे उपदेश देलहुँ।’ ");
INSERT INTO mai_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","मुदा ओ कहताह, ‘हम तोरा सभ केँ नहि चिन्‍हैत छिअह, आ नहि जनैत छिअह जे कतऽ सँ आयल छह। है कुकर्मी सभ, तोँ सभ गोटे हमरा लग सँ भाग!’ ");
INSERT INTO mai_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","अहाँ सभ जखन अब्राहम, इसहाक, याकूब आ परमेश्‍वरक प्रवक्‍ता सभ केँ परमेश्‍वरक राज्‍य मे देखबनि और अपना केँ बाहर निकालल पायब तखन अहाँ सभ कानब और दाँत कटकटायब। ");
INSERT INTO mai_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","लोक पूब आ पश्‍चिम, उत्तर आ दक्षिण सँ आबि कऽ परमेश्‍वरक राज्‍य मे भोज खयबाक लेल बैसत। ");
INSERT INTO mai_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","हँ, कतेक लोक जे एखन पाछाँ अछि से तखन आगाँ रहत, आ कतेक लोक जे एखन आगाँ अछि से तखन पाछाँ रहत।” ");
INSERT INTO mai_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","तखने किछु फरिसी सभ आबि कऽ यीशु केँ कहलथिन, “अहाँ एहिठाम सँ चल जाउ, कारण हेरोद अहाँ केँ मारि देबऽ चाहैत अछि।” ");
INSERT INTO mai_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ओ उत्तर देलथिन, “जा कऽ ओहि नढ़िया केँ कहि दिऔक जे, हम आइ और काल्‍हि दुष्‍टात्‍मा निकालबाक और बिमार लोक सभ केँ नीक करबाक अपन काज करैत रहब, और परसू हम अपन लक्ष्‍य पूरा करब। ");
INSERT INTO mai_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","हमरा आइ, काल्‍हि और परसू आगाँ बढ़ैत रहबाक अछि, किएक तँ ई कोना होयत जे परमेश्‍वरक कोनो प्रवक्‍ता यरूशलेम छोड़ि कोनो दोसर ठाम मारल जाय? ");
INSERT INTO mai_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“हे यरूशलेम! हे यरूशलेम! तोँ प्रभुक प्रवक्‍ता सभक हत्‍या करैत छह आ जिनका परमेश्‍वर तोरा लग पठबैत छथुन, तिनका सभ केँ तोँ पथरबाहि कऽ कऽ मारि दैत छहुन। हम कतेको बेर चाहलिअह जे जहिना मुर्गी अपना बच्‍चा सभ केँ अपन पाँखिक तर मे नुकबैत अछि, तहिना हमहूँ तोहर सन्‍तान सभ केँ जमा कऽ लिअह। मुदा तोँ ई नहि चाहलह! ");
INSERT INTO mai_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","देखह, आब तोहर घर उजड़ल पड़ल छह। हम तोरा कहैत छिअह, तोँ हमरा फेर ताबत तक नहि देखबह जाबत तक ओ समय नहि आओत जहिया तोँ ई कहबह जे, ‘धन्‍य छथि ओ जे प्रभुक नाम सँ अबैत छथि!’” ");
INSERT INTO mai_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","एक विश्राम-दिन यीशु एक मुख्‍य फरिसीक घर भोजन करबाक लेल गेलाह। फरिसी सभ हुनका पर घात लगौने छलाह। ");
INSERT INTO mai_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","यीशुक ठीक सामने मे एक आदमी छल, जकर देह-हाथ बिमारी सँ फुलि गेल छलैक। ");
INSERT INTO mai_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","यीशु धर्म-नियमक पंडित और फरिसी सभ सँ पुछलथिन, “की विश्राम-दिन मे रोगी केँ स्‍वस्‍थ करब धर्म-नियमक अनुसार उचित होयत वा नहि?” ");
INSERT INTO mai_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","मुदा ओ सभ एकर किछु उत्तर नहि देलथिन। यीशु ओहि आदमी केँ हाथ सँ पकड़ि कऽ नीक कऽ देलथिन और जाय देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","तखन यीशु हुनका सभ केँ कहलथिन, “अहाँ सभ मे एहन के छी, जकर बेटा वा बड़द जँ विश्राम-दिन मे इनार मे खसि पड़य तँ ओकरा तुरत्ते बाहर नहि निकालब?” ");
INSERT INTO mai_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ओ सभ फेर किछु उत्तर नहि दऽ सकलथिन। ");
INSERT INTO mai_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","यीशु जखन निमन्‍त्रित लोक सभ केँ अपना लेल मुख्‍य-मुख्‍य आसन चुनैत देखलनि, तँ हुनका सभ केँ ई दृष्‍टान्‍त दऽ कऽ सिखाबऽ लगलथिन जे, ");
INSERT INTO mai_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“अहाँ सभ केँ जखन केओ विवाह मे निमन्‍त्रित करय तँ मुख्‍य आसन पर नहि बैसू। कतौ एना नहि होअय जे अहूँ सँ प्रतिष्‍ठित व्‍यक्‍ति सेहो आमन्‍त्रित होथि ");
INSERT INTO mai_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","और जे घरबैआ अहाँ दूनू गोटे केँ नोत देने छथि से आबि कऽ अहाँ केँ कहथि जे, ‘एहिठाम हिनका बैसऽ दिऔन।’ तखन अहाँ केँ लाजक अनुभव होयत आ सभ सँ नीच स्‍थान पर बैसऽ पड़त। ");
INSERT INTO mai_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","नहि, अहाँ केँ जखन केओ नोत दिअय, तँ जा कऽ सभ सँ नीच स्‍थान पर बैसू जाहि सँ घरबैआ जखन औताह तँ अहाँ केँ कहथि, ‘यौ संगी, चलू, एम्‍हर नीक आसन पर बैसू।’ एहि तरहेँ अतिथि सभक सामने अहाँक आदर कयल जायत। ");
INSERT INTO mai_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","हँ, जे केओ अपना केँ पैघ बनाबऽ चाहैत अछि, से छोट बनाओल जायत, और जे केओ अपना केँ छोट बुझैत अछि, से पैघ बनाओल जायत।” ");
INSERT INTO mai_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","तखन यीशु घरबैआ केँ कहलथिन, “जखन लोक केँ भोजन करबाक वा भोज खयबाक नोत दैत छी, तँ अपना संगी-साथी, कुटुम्‍ब-परिवारक लोक वा धनी-मनी पड़ोसी सभ केँ नहि बजाउ। ओकरा सभ केँ जँ बजायब तँ बहुत सम्‍भावना अछि जे ओ सभ अहूँ केँ फेर बजाओत, और एहि तरहेँ अहाँ केँ तकर बदला भेटि जायत। ");
INSERT INTO mai_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","नहि, अहाँ जखन भोज करी तँ गरीब, लुल्‍ह-नाङड़ और आन्‍हर सभ केँ बजाउ। ");
INSERT INTO mai_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","अहाँ धन्‍य होयब, कारण ओ सभ अहाँ केँ फेर बजा कऽ तकर बदला नहि दऽ सकत; अहाँ तकर बदला तहिया पायब जहिया धर्मी सभ मृत्‍यु सँ जीबि उठताह।” ");
INSERT INTO mai_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ई सुनि यीशुक संग भोजन पर बैसल एक आदमी कहलकनि, “धन्‍य अछि ओ सभ जे परमेश्‍वरक राज्‍यक भोज खाय पाओत!” ");
INSERT INTO mai_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","यीशु उत्तर देलथिन, “एक बेर एक आदमी बड़का भोज कऽ कऽ बहुत लोक केँ निमन्‍त्रण देलनि। ");
INSERT INTO mai_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","भोजक सामग्री तैयार भेला पर, जकरा सभ केँ ओ नोत देने छलथिन, तकरा सभ लग ई कहबाक लेल अपना नोकर केँ पठौलथिन जे, ‘चलै जाइ जाउ, बिझो भेल, सभ वस्‍तु ठीक भऽ गेल अछि।’ ");
INSERT INTO mai_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","मुदा ओ सभ एक-एक कऽ बहाना करऽ लागल। पहिल आदमी कहलकैक, ‘हम एकटा खेत किनने छी और ओकरा एखन देखऽ जयबाक अछि। कृपा कऽ कऽ हमरा माफ करू।’ ");
INSERT INTO mai_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","दोसर कहलकैक, ‘हम पाँच जोड़ बड़द किनने छी, और ओकरा सभ केँ जोति कऽ जँचबाक लेल हम एखन विदा भऽ गेल छी। कृपा कऽ कऽ हमरा माफ करू।’ ");
INSERT INTO mai_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","फेर तेसर कहलकैक, ‘हम एखने विवाह कयलहुँ, तेँ हम नहि आबि सकैत छी।’ ");
INSERT INTO mai_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","नोकर घूमि कऽ सभटा बात अपना मालिक केँ कहलकनि। तखन घरबैआ तामसे-पित्ते नोकर केँ अढ़ौलनि जे, ‘जल्‍दी-जल्‍दी नगरक बाट और गली सभ मे जाह और गरीब, लुल्‍ह-नाङड़ और आन्‍हर सभ केँ बजा लाबह।’ ");
INSERT INTO mai_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","कनेक काल मे नोकर आबि कऽ कहलकनि, ‘मालिक, अपने जहिना हमरा कहलहुँ तहिना हम कयलहुँ, तैयो बैसबाक जगह बाँकिए अछि।’ ");
INSERT INTO mai_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","तँ मालिक ओकरा उत्तर देलथिन, ‘तखन बाहर देहातोक सड़क और आरि-धुर पर सँ लोक सभ केँ बलजोरी बजा कऽ लाबह, जाहि सँ हमर घर भरि जाय। ");
INSERT INTO mai_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","हम तोरा सभ केँ कहैत छिअह जे, जकरा सभ केँ हम पहिने नोत देने छलिऐक, ताहि मे सँ एको गोटे हमर एहि भोज मे सँ किछु नहि चिखऽ पाओत।’ ” ");
INSERT INTO mai_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","आब बहुत बड़का भीड़ यीशुक संग चलि रहल छलनि। ओ ओकरा सभ दिस घूमि कऽ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“जँ केओ हमरा लग आओत, और अपन माय-बाबू, स्‍त्री, धिआ-पुता और भाय-बहिन केँ, और हँ, अपना प्राणो केँ अप्रिय नहि बुझत, तँ ओ हमर शिष्‍य नहि बनि सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","जे केओ हमरा कारणेँ दुःख उठयबाक आ प्राणो देबाक लेल तैयार भऽ हमरा पाछाँ नहि चलैत अछि, से हमर शिष्‍य नहि बनि सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“तहिना, मानि लिअ जे अहाँ सभ मे सँ केओ बड़का घर बनाबऽ चाहत, तँ की ओ पहिने बैसि कऽ हिसाब नहि करत जे एहि मे कतेक खर्च लागत, पूरा करबाक लेल हमरा लग पाइ अछि वा नहि? ");
INSERT INTO mai_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","किएक तँ ओ जँ शुरू करत आ न्‍यो राखि कऽ घर पूरा नहि कऽ सकत, तँ जतेक लोक देखतैक, से सभ ओकरा हँसी उड़ाबऽ लगतैक जे, ");
INSERT INTO mai_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘ई घर बनाबऽ लागल और बीचहि मे छोड़ऽ पड़लैक!’ ");
INSERT INTO mai_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“वा मानि लिअ जे कोनो राजा दोसर राजा सँ युद्ध करबाक लेल बहरा रहल अछि। तँ की ओ पहिने बैसि कऽ नीक जकाँ विचार नहि कऽ लेत जे, जे राजा बीस हजार सैनिक लऽ कऽ हमरा पर आक्रमण करऽ आबि रहल अछि, की तकर सामना हम दस हजार सैनिक लऽ कऽ कऽ सकब? ");
INSERT INTO mai_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","जँ ओकरा होयतैक जे नहि कऽ सकब, तँ ओहि राजा केँ दूर रहिते ओ दूत सभ केँ पठा कऽ मेल-मिलापक समझौताक लेल आग्रह करतैक। ");
INSERT INTO mai_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","तहिना, अहाँ सभ मे सँ जे केओ अपन सभ किछु केँ त्‍यागि नहि देत, से हमर शिष्‍य नहि बनि सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“नून नीक वस्‍तु अछि, मुदा जँ ओकर स्‍वाद समाप्‍त भऽ जाइक तँ कोन वस्‍तु सँ ओकरा फेर नूनगर बनाओल जा सकत? ");
INSERT INTO mai_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ओ ने जमीनक लेल उपयुक्‍त होयत आ ने खादक लेल। तखन ओ फेकले जायत। जकरा सुनबाक लेल कान होइक, से सुनओ।” ");
INSERT INTO mai_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","कर असूल करऽ वला और “पापी” सभ यीशु लग हुनकर शिक्षा सुनबाक लेल जमा भऽ रहल छल। ");
INSERT INTO mai_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","मुदा फरिसी और धर्मशिक्षक सभ दूसऽ लगलाह जे, “ई तँ पापी सभ केँ स्‍वागत करैत अछि और ओकरा सभक संग खाइतो अछि।” ");
INSERT INTO mai_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","तखन यीशु हुनका सभ केँ ई दृष्‍टान्‍त देलथिन, ");
INSERT INTO mai_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“मानि लिअ जे अहाँ सभ मे सँ ककरो जँ एक सय भेँड़ा होअय और एकटा हेरा जाय, तँ की ओ अपन निनान्‍नबे केँ बाध मे छोड़ि हेरायल भेँड़ा केँ ताबत धरि नहि तकैत रहत जाबत धरि ओ नहि भेटतैक? ");
INSERT INTO mai_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","तकरबाद भेटि गेला पर ओ कतेक प्रसन्‍न होयत! अपना भेँड़ा केँ कान्‍ह पर उठा कऽ घर चल आओत ");
INSERT INTO mai_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","और अपन संगी-साथी, पड़ोसी सभ केँ बजा कऽ कहतैक जे, ‘हमरा संग आनन्‍द मनाउ, किएक तँ हमर हेरायल भेँड़ा भेटि गेल।’ ");
INSERT INTO mai_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","हम अहाँ सभ केँ कहैत छी जे, एहि तरहेँ निनान्‍नबे एहन धर्मी सभ जे ई बुझैत अछि जे हमरा अपना पापक लेल पश्‍चात्ताप कऽ हृदय-परिवर्तन करबाक कोनो आवश्‍यकता नहि अछि, स्‍वर्ग मे ओकरा सभक अपेक्षा ओहि एक पापीक लेल बेसी आनन्‍द मनाओल जायत जे अपना पापक लेल पश्‍चात्ताप कऽ हृदय-परिवर्तन करैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“वा मानि लिअ जे कोनो स्‍त्री केँ दसटा चानीक रुपैया होइक और एकटा हेरा जाइक, तँ की ओ डिबिया लेसि कऽ घर बहारि कऽ ओ रुपैया जा धरि नहि भेटि जयतैक ता धरि बढ़ियाँ जकाँ तकैत नहि रहत? ");
INSERT INTO mai_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","तकरबाद रुपैया भेटला पर ओ अपन सहेली और पड़ोसी सभ केँ बजा कऽ कहतैक जे, ‘हमरा संग आनन्‍द मनाउ, किएक तँ हमर हेरायल रुपैया फेर भेटि गेल।’ ");
INSERT INTO mai_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","हम अहाँ सभ केँ कहैत छी जे, एही तरहेँ एकोटा पापी जे अपना पापक लेल पश्‍चात्ताप कऽ हृदय-परिवर्तन करैत अछि, तकरा लेल परमेश्‍वरक स्‍वर्गदूत सभ आनन्‍द मनबैत छथि।” ");
INSERT INTO mai_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","यीशु आगाँ कहलथिन, “एक आदमी केँ दूटा बेटा रहनि। ");
INSERT INTO mai_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","छोटका अपना बाबू केँ कहलकनि, ‘यौ बाबूजी! हमर अंश-सम्‍पत्ति जे-जतेक होयत, से एखने हमरा बाँटि कऽ दऽ दिअ।’ एहि पर बाबू दूनू बेटा मे अपन धन-सम्‍पत्ति बाँटि देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“किछु दिनक बाद छोटका बेटा अपन सभ धन-सम्‍पत्ति लऽ कऽ दूर परदेश चल गेल। ओतऽ ओ भोग-विलास मे अपन सभ धन उड़ा लेलक। ");
INSERT INTO mai_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ओकर सभ धन खर्च भऽ गेलाक बाद, ओहि देश मे बहुत भारी रौदी पड़लैक, और ओ बड़का विपत्ति मे पड़ि गेल। ");
INSERT INTO mai_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","तखन ओ ओहि देशक एक आदमीक शरण मे गेल, जे ओकरा अपना खेत मे सुगर चरयबाक लेल पठौलकैक। ");
INSERT INTO mai_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ओकरा बड्ड इच्‍छा भेलैक जे, जे खोंइचा सुगर सभ खा रहल अछि ताहि सँ हम अपनो पेट भरितहुँ, मुदा ओकरा केओ किछु नहि दैत छलैक। ");
INSERT INTO mai_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“तखन ओकरा होश अयलैक, और ओ सोचऽ लागल जे, हमर बाबूजीक ओतेक नोकर-चाकर सभ भरि पेट भोजन पबैत अछि, और हम एतऽ भूख सँ मरऽ-मरऽ पर छी। ");
INSERT INTO mai_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","हम अपना बाबूक ओहिठाम जा कऽ ई कहबनि जे, बाबूजी, हम परमेश्‍वरक विरोध मे और अहाँक विरोध मे पाप कयने छी। ");
INSERT INTO mai_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","हम आब अहाँक बालक कहयबा जोगरक नहि छी। अपना नोकर सभ जकाँ हमरो एकटा नोकर मानू। ");
INSERT INTO mai_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“एना विचार कऽ कऽ ओ उठल आ अपना बाबूक ओहिठाम जयबाक लेल विदा भऽ गेल। ओ घर सँ दूरे छल कि ओकर बाबू ओकरा चिन्‍हि गेलथिन और हुनकर हृदय दया सँ भरि गेलनि। ओ दौड़ि कऽ अपना बेटा केँ भरि पाँज पकड़ि ओकरा चुम्‍मा लेबऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","बेटा हुनका कहलकनि, ‘बाबूजी, हम परमेश्‍वरक विरोध मे और अहाँक विरोध मे पाप कयने छी। हम आब अहाँक पुत्र कहयबा जोगरक नहि छी।’ ");
INSERT INTO mai_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","मुदा पिता अपना नोकर सभ केँ कहलथिन, ‘जल्‍दी सँ बढ़ियाँ-बढ़ियाँ कपड़ा आनि कऽ एकरा पहिरा दहक, हाथ मे औँठी लगा दहक, पयर मे जुत्ता सेहो पहिरा दहक, ");
INSERT INTO mai_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","और ओ मोटका पशु जे पोसि कऽ रखने छी, तकरा काटह! हम सभ भोज कऽ कऽ खुशी मनायब, ");
INSERT INTO mai_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","किएक तँ ई हमर बेटा मरि गेल छल आ फेर जीबि गेल! ई हेरायल छल आ फेर भेटि गेल!’ तकरबाद ओ सभ खुशी मनाबऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“ई सभ होइत काल जेठका बेटा खेत मे रहनि। जखन ओ घर लग पहुँचल तँ घर मे नाच-गान सुनलक। ");
INSERT INTO mai_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ओ एकटा नोकर केँ बजा कऽ पुछलक, ‘ई की भऽ रहल अछि?’ ");
INSERT INTO mai_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","नोकर कहलकैक, ‘अहाँक भाय अयलाह अछि, आओर अहाँक बाबूजी एहि खुशी मे जे हमर बेटा हमरा फेर सकुशल भेटि गेल अछि, मोटका पशु जे पोसल छलैक, तकरा कटबौलनि अछि।’ ");
INSERT INTO mai_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“ई सुनि कऽ ओकरा ततेक तामस भेलैक जे ओ भीतरो नहि गेल। बाबूजी ई बात बुझि, बाहर आबि कऽ ओकरा मनाबऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","मुदा ओ अपना बाबू केँ उत्तर देलकनि जे, ‘देखू! एतेक वर्ष सँ हम मरि-मरि कऽ अहाँक सेवा कऽ रहल छी, आ कहियो अहाँक बात नहि टारलहुँ। तैयो आइ धरि हमरा संगी सभक संग खुशी मनयबाक लेल एकोटा पठरू तक काटऽ नहि देलहुँ, ");
INSERT INTO mai_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","मुदा अहाँक ई बेटा वेश्‍या सभ लग अहाँक सभ धन-सम्‍पत्ति उड़ा कऽ जखन घर आयल अछि, तँ अहाँ ओकरा लेल पोसल मोटका पशु कटबबैत छी!’ ");
INSERT INTO mai_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“बाबू कहलथिन, ‘बौआ! अहाँ सभ दिन हमरा संग छी, आ जे-जतेक हमर सम्‍पत्ति अछि, से सभ अहींक अछि। ");
INSERT INTO mai_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","मुदा एहि शुभ अवसर पर खुशी तँ मनाबहि पड़ल, किएक तँ ई अहाँक भाय मरि गेल छल आ फेर जीबि गेल, हेरा गेल छल आ फेर भेटि गेल!’ ” ");
INSERT INTO mai_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","यीशु अपना शिष्‍य सभ केँ कहलथिन, “कोनो धनी आदमी रहथि। हुनका एकटा मुन्‍सी छलनि जे हुनकर पाइ-कौड़ीक हिसाब-किताब रखैत छलनि। मुन्‍सीक बारे मे हुनका लग ई सिकायत अयलनि जे, ओ अपनेक सम्‍पत्ति उड़ा रहल अछि। ");
INSERT INTO mai_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","एहि पर ओ अपना मुन्‍सी केँ बजा कऽ पुछलथिन, ‘ई हम तोरा विषय मे की सुनि रहल छिअह? तोँ अपना काजक हिसाब-किताब हमरा दैह, कारण आब हम तोरा नोकरी सँ हटा रहल छिअह।’ ");
INSERT INTO mai_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“तँ मुन्‍सी मोने-मोन सोचलक जे, आब हम की करू? मालिक हमरा सँ हमर नोकरी छिनि रहल छथि। माटि कोड़बाक लेल देह मे तागति नहि अछि, आ भीख माँगऽ मे लाज होइत अछि। ");
INSERT INTO mai_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","हँ, आब फुरायल एकटा बात जे हम कऽ सकैत छी जाहि सँ नोकरी छुटला पर लोक सभ अपना घर मे हमर स्‍वागत करत। ");
INSERT INTO mai_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“ई विचारि कऽ ओ अपना मालिकक कर्जदार सभ केँ एक-एक कऽ बजबौलक। पहिल वला सँ पुछलकैक, ‘अहाँ पर हमर मालिकक कतेक ऋण अछि?’ ");
INSERT INTO mai_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ओ उत्तर देलकैक जे ‘एक सय मन तेल।’ तँ मुन्‍सी कहलकैक, ‘लिअ अपन लेखत, आ जल्‍दी बैसि कऽ ओकरा पचास मन बना लिअ।’ ");
INSERT INTO mai_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","तखन दोसर सँ पुछलकैक, ‘और अहाँ पर कतेक ऋण अछि?’ ओ कहलकैक, ‘एक सय बोरा गहुम।’ मुन्‍सी कहलकैक, ‘लिअ अपन लेखत और अस्‍सी बोरा लिखि लिअ।’ ");
INSERT INTO mai_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","मालिक एहि बइमान मुन्‍सीक प्रशंसा कयलथिन, जे ओ चतुराइ सँ काज कयलक। एहि संसारक पुत्र सभ इजोतक पुत्र सभक अपेक्षा अपना लोकक संग जे व्‍यवहार छैक, ताहि मे विशेष चतुर रहैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“हम अहाँ सभ केँ कहैत छी जे, सांसारिक धन अपना लेल संगी बनाबऽ मे प्रयोग करू, जाहि सँ धन-सम्‍पत्ति जखन समाप्‍त भऽ जायत तँ स्‍वर्गक भवन मे अहाँक स्‍वागत होयत। ");
INSERT INTO mai_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“जे छोट बात सभ मे विश्‍वासपात्र अछि, से पैघो बात सभ मे विश्‍वासपात्र रहत। जे छोट बात मे बइमान अछि, से पैघो बात मे बइमान रहत। ");
INSERT INTO mai_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","अहाँ सांसारिक धन मे जँ विश्‍वासपात्र नहि भेलहुँ, तँ वास्‍तविक धन दऽ कऽ अहाँ पर के विश्‍वास करत? ");
INSERT INTO mai_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","जँ अनका धन मे अहाँ विश्‍वासपात्र नहि भेलहुँ, तँ अहाँक अपन धन अहाँ केँ के देत? ");
INSERT INTO mai_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“कोनो खबास दूटा मालिकक सेवा नहि कऽ सकैत अछि। कारण, ओ एक सँ घृणा करत आ दोसर सँ प्रेम, अथवा पहिल केँ खूब मानत आ दोसर केँ तुच्‍छ बुझत। अहाँ परमेश्‍वर और धन-सम्‍पत्ति दूनूक सेवा नहि कऽ सकैत छी।” ");
INSERT INTO mai_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","फरिसी सभ, जे धनक लोभी छलाह, से सभ ई सभ बात सुनि रहल छलाह और हुनकर हँसी उड़ाबऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","यीशु हुनका सभ केँ कहलथिन, “अहाँ सभ ठीक ओहन लोक सभ छी जे मनुष्‍यक सामने अपना केँ धर्मी ठहरबैत छी, मुदा परमेश्‍वर अहाँ सभक मोन केँ जनैत छथि। जे मनुष्‍यक नजरि मे सम्‍मानजनक बात अछि, से परमेश्‍वरक दृष्‍टि मे घृणित अछि। ");
INSERT INTO mai_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“यूहन्‍नाक समय धरि मूसाक धर्म-नियम और प्रभुक प्रवक्‍ता सभक लेख छल। तकरा बादक समय सँ परमेश्‍वरक राज्‍यक शुभ समाचारक प्रचार भऽ रहल अछि, और सभ केओ हुनकर राज्‍य मे प्रवेश करबाक पूरा बल सँ प्रयत्‍न कऽ रहल अछि। ");
INSERT INTO mai_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","तैयो धर्म-नियमक एको अक्षरक मात्रा मेटा जयबाक अपेक्षा आकाश और पृथ्‍वी समाप्‍त भेनाइ आसान होयत। ");
INSERT INTO mai_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“जे केओ अपना स्‍त्री केँ तलाक दऽ कऽ दोसर सँ विवाह करैत अछि, से परस्‍त्रीगमन करैत अछि। आ जे कोनो पुरुष पति द्वारा तलाक देल गेल स्‍त्री सँ विवाह करैत अछि, सेहो परस्‍त्रीगमन करैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“एक धनिक आदमी छल जे मलमल आ दामी-दामी वस्‍त्र पहिरैत छल। ओ सभ दिन भोज सनक भोजन करैत छल आ सुख-विलास सँ रहैत छल। ");
INSERT INTO mai_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ओकरा दुआरि पर लाजर नामक गरीब आदमी केँ, जकर सम्‍पूर्ण शरीर घाव सँ भरल छलैक, राखि देल जाइत छलैक। ");
INSERT INTO mai_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ओ गरीब आदमी आशा करैत छल जे धनिकक टेबुल सँ खसल टुकड़ा-टुकड़ी पाबि कऽ पेट भरब। कुकुर सभ आबि कऽ ओहि दुखिताह केँ घाव सेहो चाटि लैत छलैक। ");
INSERT INTO mai_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“एक दिन गरीब लाजर मरि गेल आओर स्‍वर्गदूत सभ ओकरा स्‍वर्ग मे अब्राहम लग पहुँचौलनि। धनिक आदमी सेहो मरल आ माटि मे गाड़ल गेल। ");
INSERT INTO mai_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","नरक मे ओ अत्‍यन्‍त पीड़ा सहैत ऊपर दिस ताकि बहुत दूर अब्राहम केँ आ हुनका लग लाजर केँ देखलकनि। ");
INSERT INTO mai_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ओ सोर पारलकनि जे, ‘यौ पिता अब्राहम! हमरा पर दया कऽ कऽ एहिठाम लाजर केँ पठा दिअ, जे ओ अपन आङुरक नऽह पानि मे डुबा कऽ हमर जीह केँ कनेक शीतल कऽ दिअय, हमरा एहि आगि मे बड्ड पीड़ा भऽ रहल अछि!’ ");
INSERT INTO mai_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“मुदा अब्राहम उत्तर देलथिन, ‘हौ बेटा! मोन पाड़ह जे तोँ अपना जीवन मे नीक-नीक वस्‍तु सभ पौलह, जहिना लाजर खराब वस्‍तु। आब ओ एतऽ आनन्‍द मे अछि आओर तोँ पीड़ा मे। ");
INSERT INTO mai_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","आओर एतबे नहि—हमरा सभक आ तोरा बीच मे बड़का दरारि बनाओल गेल अछि, जाहि सँ जँ केओ एतऽ सँ तोरा ओहिठाम जाय चाहत तँ नहि जा सकत, आ ने तोँ जतऽ छह, ततऽ सँ केओ हमरा सभक ओहिठाम आबि सकत।’ ");
INSERT INTO mai_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“तखन ओ धनिक उत्तर देलकनि, ‘एना अछि तँ, यौ पिता, हम विनती करैत छी जे हमर बाबूक ओहिठाम लाजर केँ पठाउ, ");
INSERT INTO mai_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ओतऽ हमर पाँच भाय अछि। ओकरा सभ केँ ओ चेतावनी दैक जाहि सँ ओ सभ एहि पीड़ाक स्‍थान मे नहि आबय।’ ");
INSERT INTO mai_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“अब्राहम कहलथिन, ‘मूसाक धर्म-नियम और परमेश्‍वरक प्रवक्‍ता सभक लेख ओकरा सभ लग छैक, तोहर भाय सभ ओकरा मानओ।’ ");
INSERT INTO mai_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“ओ उत्तर देलकनि, ‘नहि पिता अब्राहम! ओतबे सँ नहि होयत! मुदा जँ केओ मरल सभ मे सँ ओकरा सभ लग जायत, तखन ओ सभ मानत और अपना पापक लेल पश्‍चात्ताप कऽ ठीक रस्‍ता पर आओत।’ ");
INSERT INTO mai_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“अब्राहम कहलथिन, ‘ओ सभ जँ मूसाक और परमेश्‍वरक प्रवक्‍ता सभक लेख नहि मानत, तँ जँ केओ मरि कऽ जिबिओ जायत तँ ओकरो बात नहि मानतैक।’ ” ");
INSERT INTO mai_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","यीशु अपना शिष्‍य सभ केँ कहलथिन, “ई निश्‍चित अछि जे लोक सभ केँ पाप मे फँसाबऽ वला बात सभ होयत, मुदा धिक्‍कार ताहि मनुष्‍य केँ, जकरा द्वारा ओहन बात सभ अबैत अछि! ");
INSERT INTO mai_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ओकरा लेल एहि सँ नीक जे ओ एहि बच्‍चा सभ मे सँ एकोटा केँ पाप मे फँसाबय ई होइत जे ओकरा घेंट मे जाँतक पाट बान्‍हि समुद्र मे फेकि देल जाय। ");
INSERT INTO mai_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","तेँ अहाँ सभ सावधान रहू! “अहाँक भाय जँ पाप करैत अछि तँ ओकरा मना करू। जँ ओ अपना पापक लेल पश्‍चात्ताप कऽ पाप केँ छोड़ैत अछि तँ ओकरा माफ कऽ दिऔक। ");
INSERT INTO mai_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","आ जँ ओ दिन मे सात बेर अहाँक विरोध मे अपराध करय और सात बेर अहाँ लग घूमि कऽ अपन अपराध मानि कऽ माफी माँगय तँ माफ कऽ दिऔक।” ");
INSERT INTO mai_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","तखन समीह-दूत सभ हुनका कहलथिन, “हमरा सभक विश्‍वास केँ बढ़ाउ!” ");
INSERT INTO mai_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ओ उत्तर देलथिन, “जँ अहाँ सभ केँ सरिसोक दानो बराबरि विश्‍वास अछि, तँ एहि तूँइतक गाछ केँ कहि सकैत छिऐक जे, उखड़ि कऽ समुद्र मे रोपा जो, और ओ अहाँक आज्ञा मानत। ");
INSERT INTO mai_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“अहाँ सभ मे एहन मालिक के छी, जकर नोकर खेत मे सँ हऽर जोति कऽ वा बाध मे सँ भेँड़ा चरा कऽ जखन अबैत अछि, तँ कहैत छिऐक जे, ‘आउ, आउ, बैसू, भोजन कऽ लिअ’? ");
INSERT INTO mai_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","की ई नहि कहबैक जे, ‘हमर भानस करह, तखन जा धरि हम भोजन पर सँ उठब नहि, ता धरि तोँ फाँड़ बान्‍हि कऽ हमर सेवा करह, तकरबाद तोहूँ खाह-पिबह’? ");
INSERT INTO mai_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","जखन नोकर मालिकक कहल करैत छनि, तँ की ओहि लेल मालिक ओकरा धन्‍यवाद दैत छथिन? नहि! ");
INSERT INTO mai_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","तहिना अहूँ सभ, जतेक काज अहाँ सभ केँ अढ़ाओल गेल होअय, से सभ पूरा कऽ कऽ ई कहू जे, ‘हम सभ कोनो प्रशंसा जोगरक नहि छी; हम सभ तँ खाली वैह कयलहुँ जे हमर सभक कर्तव्‍य छल।’ ” ");
INSERT INTO mai_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","यीशु यरूशलेम जाइत काल सामरिया और गलील प्रदेशक सीमा दऽ कऽ जा रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","कोनो गाम मे जखन प्रवेश कयलनि तँ दसटा कुष्‍ठ-रोगी हुनका भेटलनि। ओ सभ फराके सँ ठाढ़ भऽ कऽ ");
INSERT INTO mai_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","जोर सँ सोर पारलकनि जे, “यौ मालिक यीशु! हमरा सभ पर दया करू!” ");
INSERT INTO mai_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","यीशु ओकरा सभ केँ देखि कऽ कहलथिन, “पुरोहित सभक ओहिठाम जाह और अपना केँ हुनका सभ केँ देखा दहुन।” ओ सभ जाइते-जाइत मे नीक भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","तखन ओकरा सभ मे सँ एक गोटे जखन देखलक जे हम नीक भऽ गेलहुँ, तँ ओ जोर-जोर सँ परमेश्‍वरक स्‍तुति-प्रशंसा करैत घूमि आयल, ");
INSERT INTO mai_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","और यीशुक पयर पर खसि कऽ हुनकर धन्‍यवाद करऽ लगलनि। ओ यहूदी नहि, सामरी जातिक छल। ");
INSERT INTO mai_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","तखन यीशु बजलाह, “की दसो गोटे नीक नहि भेल? आरो नौ आदमी कतऽ अछि? ");
INSERT INTO mai_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","की एहि आन जातिक लोक केँ छोड़ि कऽ आओर केओ एहन नहि बहरायल जे घूमि कऽ परमेश्‍वरक धन्‍यवाद करितनि?” ");
INSERT INTO mai_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","तखन ओ ओकरा कहलथिन, “आब उठि कऽ जाह। तोहर विश्‍वास तोरा नीक कऽ देलकह।” ");
INSERT INTO mai_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","फरिसी सभक ई पुछला पर जे परमेश्‍वरक राज्‍य कहिया आओत, यीशु उत्तर देलथिन, “परमेश्‍वरक राज्‍य ओहि तरहेँ नहि अबैत अछि जे आँखि सँ देखल जा सकय। ");
INSERT INTO mai_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","केओ कहऽ वला नहि होयत जे, ‘देखू, एतऽ अछि,’ वा ‘ओतऽ अछि,’ कारण, परमेश्‍वरक राज्‍य अहाँ सभक बीच मे अछि।” ");
INSERT INTO mai_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","तखन ओ अपना शिष्‍य सभ केँ कहलथिन, “ओ समय आबि रहल अछि जखन अहाँ सभ केँ मनुष्‍य-पुत्रक युगक एको दिन देखबाक लेल बड़का इच्‍छा होयत, मुदा देखि नहि सकब। ");
INSERT INTO mai_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","लोक अहाँ सभ केँ कहत जे, ‘ओतऽ छथि!’ वा ‘एतऽ छथि।’ मुदा नहि जाउ! ओकरा सभक पाछाँ नहि दौड़ू! ");
INSERT INTO mai_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","कारण, मनुष्‍य-पुत्रक दिन जखन औतनि, तँ ओ बिजलोका जकाँ होयताह, जे चमकि कऽ आकाश केँ एक कात सँ दोसर कात तक इजोत कऽ दैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","मुदा ओहि सँ पहिने ई आवश्‍यक अछि जे ओ बहुत दुःख भोगथि और एहि पीढ़ीक लोक द्वारा अस्‍वीकार कयल जाथि। ");
INSERT INTO mai_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“जहिना नूहक समय मे भेल, तहिना मनुष्‍य-पुत्रक अयबाक समय मे सेहो होयत। ");
INSERT INTO mai_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","जाहि दिन नूह जहाज मे चढ़ि गेलाह, ताहि दिन धरि लोक सभ खाय-पिबऽ मे और विवाह करऽ-कराबऽ मे मस्‍त रहल आ तखन जल-प्रलय भेल और सभ केओ नष्‍ट भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“तहिना लूतक समय मे सेहो भेल। लोक सभ खाइत-पिबैत रहल, चीज-वस्‍तु बेचैत-किनैत रहल, बीया बाउग करैत रहल आ घर बनबैत रहल। ");
INSERT INTO mai_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","मुदा जाहि दिन लूत सदोम नगर सँ बहरयलाह, ताही दिन आकाश सँ आगि और गन्‍धकक वर्षा भेल और सभ केओ नष्‍ट भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“जाहि दिन मनुष्‍य-पुत्र फेर प्रगट होयताह, ताहू दिन ठीक ओहिना होयत। ");
INSERT INTO mai_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ताहि दिन जँ केओ छत पर होअय और ओकर सामान घर मे, तँ ओ ओकरा लेबाक लेल नहि उतरओ। तहिना जे केओ खेत मे होअय, से घूमि कऽ नहि आबओ। ");
INSERT INTO mai_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लूतक घरवाली केँ मोन राखू। ");
INSERT INTO mai_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","जे केओ अपन प्राण बचयबाक प्रयत्‍न करैत अछि, से ओकरा गमाओत, और जे केओ अपन प्राण गमबैत अछि से ओकरा सुरक्षित राखत। ");
INSERT INTO mai_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","हम अहाँ सभ केँ कहैत छी, ओहि राति दू आदमी एक ओछायन पर सुतल रहत, एक लऽ लेल जायत, आ दोसर छोड़ि देल जायत। ");
INSERT INTO mai_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","दूटा स्‍त्रीगण एक संग जाँत पिसैत रहत, एकटा लऽ लेल जायत, आ दोसर छोड़ि देल जायत। ");
INSERT INTO mai_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","दू आदमी खेत मे रहत, एक लऽ लेल जायत, आ दोसर छोड़ि देल जायत।” ");
INSERT INTO mai_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","शिष्‍य सभ पुछलथिन, “प्रभु, ई कतऽ होयत?” ओ उत्तर देलथिन, “जतऽ लास पड़ल रहत, ततहि गिद्ध सभ जुटत।” ");
INSERT INTO mai_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","तखन यीशु अपना शिष्‍य सभ केँ ई बुझयबाक लेल जे निराश नहि भऽ कऽ प्रार्थना करैत रहबाक अछि, एक दृष्‍टान्‍त देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ओ कहलथिन, “कोनो शहर मे एक न्‍यायाधीश रहैत छल जे ने परमेश्‍वरक डर मानैत छल आ ने कोनो मनुष्‍य केँ मोजर दैत छल। ");
INSERT INTO mai_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ओहि शहर मे एक विधवा सेहो रहैत छलि जे बेर-बेर ओकरा लग आबि कऽ कहैत छलैक जे, ‘हमर उचित न्‍याय कऽ दिअ और हमरा संग जे अपराध कऽ रहल अछि, तकरा सँ हमरा बचाउ।’ ");
INSERT INTO mai_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“किछु दिन धरि ओ नहि मानलक, मुदा बाद मे ओ मोने-मोन सोचऽ लागल जे, ‘ओना तँ हम ने परमेश्‍वरक डर मानैत छी आ ने मनुष्‍य केँ मोजर दैत छी, ");
INSERT INTO mai_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","तैयो ई विधवा हमरा ततेक तंग कऽ देने अछि जे हम एकर उचित न्‍याय अवश्‍य कऽ देबैक। नहि तँ ई बेर-बेर आबि कऽ हमरा अकछ कऽ देत!’ ” ");
INSERT INTO mai_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","तखन प्रभु कहलथिन, “ओ अधर्मी न्‍यायाधीश की कहलक, से सुनलहुँ? ");
INSERT INTO mai_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","तँ की परमेश्‍वर अपन चुनल लोक, जे हुनका सँ दिन-राति विनती करैत छनि, तकरा सभक लेल उचित न्‍याय नहि करथिन? की ओकरा सभक लेल न्‍याय करऽ मे देरी करताह? ");
INSERT INTO mai_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","हम अहाँ सभ केँ कहैत छी, ओ ओकरा सभक लेल उचित न्‍याय करथिन, और शीघ्र करथिन। मुदा मनुष्‍य-पुत्र जहिया औताह, तँ की एहन विश्‍वास हुनका ककरो लग भेटतनि?” ");
INSERT INTO mai_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","तखन यीशु एहन लोक सभक लेल जे अपना केँ धर्मी मानि कऽ अपना धार्मिकता पर भरोसा रखैत छल और आन लोक सभ केँ हेय दृष्‍टि सँ देखैत छल, तकरा सभक लेल ई दृष्‍टान्‍त सुनौलनि, ");
INSERT INTO mai_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“दू आदमी मन्‍दिर मे प्रार्थना करऽ गेल। एक गोटे फरिसी रहय और दोसर कर असूल करऽ वला। ");
INSERT INTO mai_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","फरिसी ठाढ़ भऽ कऽ एहि तरहेँ अपना विषय मे प्रार्थना कऽ कऽ कहऽ लागल, ‘हे परमेश्‍वर, हम अहाँ केँ धन्‍यवाद दैत छी जे हम आन लोक सभ जकाँ ठकहारा, दुष्‍कर्मी, वा परस्‍त्रीगमन करऽ वला नहि छी, आ ने एहि कर असूल करऽ वला सन छी। ");
INSERT INTO mai_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","हम सप्‍ताह मे दू दिन उपास करैत छी, और जे किछु हमरा भेटैत अछि, ताहि मे सँ हम दसम अंश अहाँ केँ चढ़बैत छी।’ ");
INSERT INTO mai_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“मुदा कर असूल करऽ वला फराके सँ ठाढ़ भऽ कऽ स्‍वर्ग दिस अपन आँखि उठयबाक साहसो नहि कयलक, बल्‍कि छाती पिटैत बाजल, ‘हे परमेश्‍वर, हम पापी छी, हमरा पर दया करू।’ ");
INSERT INTO mai_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“हम अहाँ सभ केँ कहैत छी जे, ओ पहिल आदमी नहि, बल्‍कि ई दोसर आदमी परमेश्‍वरक नजरि मे धर्मी ठहरि कऽ अपना घर गेल। कारण, जे केओ अपना केँ पैघ बुझैत अछि, से तुच्‍छ कयल जायत, और जे अपना केँ तुच्‍छ मानैत अछि से पैघ कयल जायत।” ");
INSERT INTO mai_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","लोक सभ यीशु लग अपन छोट-छोट धिआ-पुता सभ केँ सेहो अनैत छलनि जे ओ ओकरा सभ पर हाथ राखि आशीर्वाद देथिन। शिष्‍य सभ ई देखि कऽ लोक सभ केँ डाँटऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","मुदा यीशु धिआ-पुता सभ केँ अपना लग बजौलनि, और शिष्‍य सभ केँ कहलथिन, “बच्‍चा सभ केँ हमरा लग आबऽ दिऔक, ओकरा सभ केँ नहि रोकिऔक। किएक तँ, परमेश्‍वरक राज्‍य एहने सभक अछि। ");
INSERT INTO mai_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","हम अहाँ सभ केँ सत्‍य कहैत छी जे, जे केओ बच्‍चा जकाँ परमेश्‍वरक राज्‍य ग्रहण नहि करत, से ओहि मे कहियो नहि प्रवेश करत।” ");
INSERT INTO mai_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","एकटा ऊँच अधिकारी यीशु सँ पुछलथिन, “यौ उत्तम गुरुजी! अनन्‍त जीवन प्राप्‍त करबाक लेल हम की करू?” ");
INSERT INTO mai_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","यीशु कहलथिन, “अहाँ हमरा ‘उत्तम’ किएक कहैत छी? परमेश्‍वर केँ छोड़ि आरो केओ उत्तम नहि अछि। ");
INSERT INTO mai_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","अहाँ धर्म-नियमक आज्ञा सभ तँ जनैत छी—‘परस्‍त्रीगमन नहि करह, हत्‍या नहि करह, चोरी नहि करह, झूठ गवाही नहि दैह, अपन माय-बाबूक आदर करह।’” ");
INSERT INTO mai_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ओ उत्तर देलथिन, “एहि सभ आज्ञाक पालन हम बचपने सँ करैत छी।” ");
INSERT INTO mai_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","यीशु ई सुनि हुनका कहलथिन, “एक बातक कमी अहाँ मे एखनो अछि। अहाँ अपन सभ किछु बेचि कऽ ओकरा गरीब सभ मे बाँटि दिअ, अहाँ केँ स्‍वर्ग मे धन भेटत। तकरबाद आउ आ हमरा पाछाँ चलू।” ");
INSERT INTO mai_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ई बात सुनि ओ बहुत उदास भेलाह, किएक तँ हुनका बहुत धन-सम्‍पत्ति छलनि। ");
INSERT INTO mai_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","यीशु हुनका दिस तकैत बजलाह, “धनिक सभक लेल परमेश्‍वरक राज्‍य मे प्रवेश कयनाइ कतेक कठिन अछि! ");
INSERT INTO mai_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","धनिक केँ परमेश्‍वरक राज्‍य मे प्रवेश कयनाइ सँ ऊँट केँ सुइक भूर दऽ कऽ निकलनाइ आसान अछि।” ");
INSERT INTO mai_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","एहि पर सुनऽ वला लोक सभ पुछलकनि, “तखन उद्धार ककर भऽ सकैत छैक?!” ");
INSERT INTO mai_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","यीशु उत्तर देलथिन, “जे बात मनुष्‍यक लेल असम्‍भव अछि, से परमेश्‍वरक लेल सम्‍भव अछि।” ");
INSERT INTO mai_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","पत्रुस हुनका कहलथिन, “देखू, हम सभ अपन सभ किछु त्‍यागि कऽ अहाँक पाछाँ आयल छी।” ");
INSERT INTO mai_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","यीशु हुनका सभ केँ कहलथिन, “हम अहाँ सभ केँ सत्‍ये कहैत छी जे, प्रत्‍येक व्‍यक्‍ति जे घर, घरवाली, भाय, माय-बाबू वा धिआ-पुता केँ परमेश्‍वरक राज्‍यक लेल त्‍याग करैत अछि, ");
INSERT INTO mai_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","तकरा एहि युग मे ओकर कतेको गुना भेटतैक, और आबऽ वला युग मे अनन्‍त जीवन।” ");
INSERT INTO mai_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","यीशु बारहो शिष्‍य केँ एक कात लऽ जा कऽ कहलथिन, “सुनू, अपना सभ यरूशलेम जा रहल छी। ओतऽ जा कऽ जे किछु प्रभुक प्रवक्‍ता सभक द्वारा मनुष्‍य-पुत्रक विषय मे लिखल गेल अछि, से सभ बात पूरा होयत। ");
INSERT INTO mai_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ओ गैर-यहूदी सभक हाथ मे सौंपल जायत, लोक ओकर हँसी उड़ौतैक, बेइज्‍जति करतैक, ओकरा पर थुकतैक, कोड़ा लगौतैक, और जान सँ मारि देतैक। ");
INSERT INTO mai_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","मुदा तेसर दिन ओ फेर जीबि उठत।” ");
INSERT INTO mai_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","मुदा शिष्‍य सभ एहि बात सभ सँ किछु नहि बुझि सकलाह। हुनकर सम्‍पूर्ण कथन हुनका सभक लेल रहस्‍ये बनल रहल। बुझऽ मे नहि अयलनि जे हुनकर कहबाक तात्‍पर्य की छनि। ");
INSERT INTO mai_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","यीशु जखन यरीहो नगर लग पहुँचलाह, तँ एकटा आन्‍हर आदमी रस्‍ताक कात मे भीख मँगैत बैसल छल। ");
INSERT INTO mai_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","लोकक भीड़ ओहि दने जाइत सुनि ओ पुछऽ लागल जे, की भऽ रहल अछि? ");
INSERT INTO mai_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","लोक ओकरा कहलकैक, “नासरत-निवासी यीशु एहि दऽ कऽ जा रहल छथि।” ");
INSERT INTO mai_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","तखन ओ सोर पारऽ लागल, “यौ दाऊदक पुत्र यीशु, हमरा पर दया करू!” ");
INSERT INTO mai_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","आगाँ-आगाँ चलऽ वला लोक सभ ओकरा डँटैत चुप रहबाक लेल कहलकैक, मुदा ओ आओर जोर सँ हल्‍ला कऽ कऽ कहऽ लागल, “यौ दाऊदक पुत्र, हमरा पर दया करू!” ");
INSERT INTO mai_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","यीशु ठाढ़ भऽ गेलाह आ अपना लग ओकरा अनबाक आदेश देलथिन। आन्‍हर आदमी जखन हुनका लग आयल तँ ओ पुछलथिन, ");
INSERT INTO mai_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“तोँ की चाहैत छह, हम तोरा लेल की करिअह?” ओ उत्तर देलकनि, “प्रभु, हम देखऽ चाहैत छी।” ");
INSERT INTO mai_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","यीशु ओकरा कहलथिन, “आब तोँ देखि सकैत छह! तोहर विश्‍वास तोरा नीक कऽ देलकह।” ");
INSERT INTO mai_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ओ तुरत देखऽ लागल और परमेश्‍वरक स्‍तुति-प्रशंसा करैत यीशुक पाछाँ चलऽ लागल। ई देखि सभ लोक सेहो परमेश्‍वरक स्‍तुति करऽ लागल। ");
INSERT INTO mai_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","यीशु यरीहो नगर दऽ कऽ जा रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","यरीहो मे एक जक्‍कइ नामक आदमी छलाह जे कर असूल करऽ वला सभक हाकिम छलाह, और ओ धनिक छलाह। ");
INSERT INTO mai_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ओ देखऽ चाहैत छलाह जे यीशु के छथि, मुदा ओ भीड़क कारणेँ नहि देखि पबैत छलाह किएक तँ ओ छोट खुट्टीक लोक छलाह। ");
INSERT INTO mai_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","तेँ ओ ई जानि जे यीशु एहि बाटे जा रहल छथि, आगाँ दौड़ि कऽ एक गुल्‍लड़िक गाछ पर चढ़ि गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","जखन यीशु ओहि स्‍थान पर पहुँचलाह तँ ऊपर ताकि कऽ कहलथिन, “यौ जक्‍कइ, जल्‍दी सँ उतरि आउ। आइ हमरा अहींक ओहिठाम रहबाक अछि।” ");
INSERT INTO mai_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","तँ जक्‍कइ जल्‍दी सँ उतरलाह और यीशु केँ बहुत खुशीपूर्बक अपना ओहिठाम लऽ जा कऽ स्‍वागत कयलथिन। ");
INSERT INTO mai_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","सभ लोक ई देखि कुड़बुड़ाय लागल जे, “ओ पापीक ओहिठाम पाहुन किएक बनऽ गेलाह!” ");
INSERT INTO mai_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","मुदा जक्‍कइ ठाढ़ भऽ कऽ प्रभु केँ कहलथिन, “प्रभु, हम अपन आधा सम्‍पत्ति गरीब सभ केँ दऽ दैत छी, और जँ हम ककरो सँ बइमानी कऽ कऽ किछु लेने छिऐक तँ ओकर चारि गुना फिरता कऽ देबैक।” ");
INSERT INTO mai_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","यीशु कहलथिन, “आइ एहि घर मे उद्धार आयल अछि, किएक तँ इहो मनुष्‍य अब्राहमक सन्‍तान अछि। ");
INSERT INTO mai_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","मनुष्‍य-पुत्र तँ हेरायल सभ केँ तकबाक लेल और ओकरा सभक उद्धार करबाक लेल आयल अछि।” ");
INSERT INTO mai_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","लोक सभ ई बात सुनि रहल छल। तखन यीशु ओकरा सभ केँ एक दृष्‍टान्‍त सुनौलथिन, किएक तँ ओ यरूशलेमक लग मे पहुँचि गेल छलाह, और लोक ई बुझैत छल जे परमेश्‍वरक राज्‍य तुरत्ते प्रगट होमऽ वला अछि। ");
INSERT INTO mai_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ओ कहलथिन, “एक ऊँच घरानाक लोक दूर परदेश गेलाह जतऽ सँ हुनका अपन राज-अधिकार प्राप्‍त कऽ कऽ घूमि अयबाक छलनि। ");
INSERT INTO mai_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","जाय सँ पहिने ओ अपन दसटा नोकर केँ बजबा कऽ ओकरा सभ केँ एक-एकटा सोनक रुपैया देलथिन आ कहलथिन, ‘जाबत तक हम नहि आयब, ताबत तक एहि पाइ सँ व्‍यापार करह।’ ");
INSERT INTO mai_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“मुदा प्रजा हुनका सँ घृणा करैत छलनि, और हुनका पाछाँ अपन आदमी सभ केँ ई सम्‍बाद लऽ कऽ पठौलक जे, ‘हम सभ नहि चाहैत छी जे ई हमरा सभ पर राज्‍य करय।’ ");
INSERT INTO mai_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“मुदा ओ राजा बनलाह, और अपन देश मे घूमि अयलाह। तखन ई बुझबाक लेल जे, हमर नोकर सभ जकरा सभ केँ हम पाइ देने छलिऐक, से सभ हमर पाइ सँ कतेक कमायल, ओकरा सभ केँ बजबौलथिन। ");
INSERT INTO mai_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“पहिल नोकर आबि कऽ कहलकनि, ‘मालिक, अपनेक देल एक सोनक रुपैया दस गुना भऽ गेल।’ ");
INSERT INTO mai_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“मालिक उत्तर देलथिन, ‘चाबस! तोँ नीक नोकर छह! तोँ नान्‍हिटा बात मे विश्‍वासपात्र भेलह, तोरा दसटा नगर पर अधिकार होयतह।’ ");
INSERT INTO mai_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“तखन दोसर नोकर आबि कऽ कहलकनि, ‘मालिक, अपनेक देल एक सोनक रुपैया पाँच गुना भऽ गेल।’ ");
INSERT INTO mai_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“मालिक उत्तर देलथिन, ‘तोँ पाँच नगर पर अधिकारी बनबह।’ ");
INSERT INTO mai_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“एकटा तेसर नोकर आयल और कहऽ लागल, ‘मालिक, लेल जाओ अपन सोनक रुपैया। हम एकरा कपड़ा मे बान्‍हि कऽ रखने छलहुँ। ");
INSERT INTO mai_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","हम अपने सँ डेराइत छलहुँ, कारण, अपने कठोर आदमी छी। जे अहाँ रखलहुँ नहि, से निकालैत छी, आ जे रोपलहुँ नहि, से कटैत छी।’ ");
INSERT INTO mai_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“मालिक उत्तर देलथिन, ‘है दुष्‍ट नोकर! हम तोरे शब्‍द सँ तोरा दोषी ठहरयबौ! तोँ जँ जनैत छलेँ जे हम कठोर आदमी छी, जे रखलहुँ नहि, से निकालैत छी, आ जे रोपलहुँ नहि, से कटैत छी, ");
INSERT INTO mai_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","तँ तोँ हमर पाइ केँ व्‍याज पर किएक नहि लगा देलेँ जाहि सँ हम आबि कऽ ओकरा व्‍याजक संग लऽ लितहुँ?’ ");
INSERT INTO mai_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“तखन मालिक अपना लग मे ठाढ़ भेल लोक केँ कहलथिन, ‘एकरा सँ ओ सोनक रुपैया लऽ लैह, और तकरा दऽ दहक जकरा दसटा छैक।’ ");
INSERT INTO mai_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“ओ सभ कहलकनि, ‘मालिक, ओकरा तँ दसटा छैके!’ ");
INSERT INTO mai_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“मालिक उत्तर देलथिन, ‘हम तोरा सभ केँ कहैत छिअह, जकरा लग छैक, तकरा आरो देल जयतैक, मुदा जकरा लग नहि छैक, तकरा सँ जेहो छैक सेहो लऽ लेल जयतैक। ");
INSERT INTO mai_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","मुदा हमर ओ दुश्‍मन सभ, जे नहि चाहैत छल जे हम ओकरा सभ पर राज्‍य करी, तकरा सभ केँ आनू, और हमरा सामने मे मारि दिऔक।’ ” ");
INSERT INTO mai_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ई सभ बात कहि कऽ यीशु यरूशलेम दिस आगाँ बढ़ैत गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","जखन ओ ओहि पहाड़ पर जे “जैतून पहाड़” कहबैत अछि, ताहि परक बेतफगे और बेतनिया गाम सभ लग पहुँचलाह, तँ ओ दूटा शिष्‍य केँ ई कहि कऽ पठौलथिन जे, ");
INSERT INTO mai_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“सामने मे जे गाम अछि, ताहि मे जाउ। जखने गाम मे प्रवेश करब, तखन गदहीक एक बच्‍चा बान्‍हल भेटत, जाहि पर केओ कहियो नहि चढ़ल अछि। ओकरा खोलि कऽ आनू। ");
INSERT INTO mai_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","केओ जँ पुछत जे, ‘एकरा किएक खोलैत छी?’ तँ कहबैक जे, ‘प्रभु केँ एकर आवश्‍यकता छनि।’ ” ");
INSERT INTO mai_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","शिष्‍य सभ ओतऽ गेलाह, और जहिना यीशु कहने छलथिन, ठीक ओहिना हुनका सभ केँ भेटलनि। ");
INSERT INTO mai_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ओ सभ जखन गदहीक बच्‍चा खोलैत छलाह तँ ओकर मालिक सभ पुछऽ लगलनि जे, “अहाँ सभ ई गदहा किएक खोलि रहल छी?” ");
INSERT INTO mai_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ओ सभ उत्तर देलथिन, “प्रभु केँ एकर आवश्‍यकता छनि।” ");
INSERT INTO mai_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ओ सभ ओकरा यीशु लग अनलनि, और ओकरा पीठ पर अपन कपड़ा राखि कऽ हुनका बैसा देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ओ जहिना-जहिना आगाँ बढ़ैत जाइत छलाह, लोक सभ तहिना-तहिना सड़क पर अपन कपड़ा ओछौने जाइत छलनि। ");
INSERT INTO mai_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","जखन ओ यरूशलेमक लग ताहिठाम पहुँचलाह जतऽ जैतून पहाड़ पर सँ सड़क नीचाँ मुँहें ढलान अछि, तँ शिष्‍यक विशाल भीड़ बहुत आनन्‍दित भऽ कऽ ओहि चमत्‍कार सभक लेल जे ओ सभ देखने छल, तकरा लेल जोर-जोर सँ एहि तरहेँ परमेश्‍वरक स्‍तुति-प्रशंसा करऽ लागल जे, ");
INSERT INTO mai_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“धन्‍य छथि ओ राजा जे प्रभुक नाम सँ अबैत छथि! स्‍वर्ग मे शान्‍ति, सर्वोच्‍च स्‍वर्ग मे प्रभुक जयजयकार!” ");
INSERT INTO mai_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","एहि पर भीड़ मेहक किछु फरिसी यीशु केँ कहलथिन, “गुरुजी, अपना शिष्‍य सभ केँ चुप होयबाक लेल कहिऔक!” ");
INSERT INTO mai_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","यीशु उत्तर देलथिन, “हम अहाँ सभ केँ कहैत छी जे, ई सभ जँ चुप भऽ जायत तँ पाथरे सभ आवाज देबऽ लागत।” ");
INSERT INTO mai_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","यीशु यरूशलेम शहर लग जखन पहुँचलाह तँ शहर केँ देखि कऽ कानऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ओ कनैत-कनैत बजलाह, “तोँ, हँ तोँही, जँ आजुक दिन जनितह जे कोन बात सभ सँ शान्‍ति अबैत अछि...! मुदा से नहि! ई सभ बात तोरा देखाइ नहि दऽ रहल छह। ");
INSERT INTO mai_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","हँ, तोरा पर तेहन समय औतह जहिया तोहर शत्रु सभ तोरा चारू कात मोर्चा बान्‍हि कऽ घेरि लेतह, तोरा पर चारू कात सँ आक्रमण करतह। ");
INSERT INTO mai_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ओ सभ तोरा और तोरा बालक सभ केँ माटि मे मिला देतह, और एको पाथर दोसर पाथर पर टिकल नहि रहतह, कारण, परमेश्‍वर जाहि समय मे तोरा ओहिठाम अयलथुन, ताहि समय केँ तोँ नहि चिन्‍हलह।” ");
INSERT INTO mai_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","यीशु मन्‍दिर मे गेलाह और बेचऽ वला सभ केँ ई कहि कऽ ओतऽ सँ भगाबऽ लगलाह जे, ");
INSERT INTO mai_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“धर्मशास्‍त्रक लेख अछि, ‘हमर घर प्रार्थनाक घर होयत,’ मुदा तोँ सभ एकरा ‘चोर-डाकूक अड्डा’ बना देने छह।” ");
INSERT INTO mai_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","यीशु मन्‍दिर मे सभ दिन उपदेश दैत छलाह। मुख्‍यपुरोहित और धर्मशिक्षक सभ, और यहूदी सभक नेता सभ हुनका जान सँ मारि देबाक प्रयत्‍न कऽ रहल छलाह, ");
INSERT INTO mai_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","मुदा किछु कऽ नहि सकलाह, एहि लेल जे सम्‍पूर्ण जनता हुनकर बात सभ ध्‍यानपूर्बक सुनैत रहैत छल। ");
INSERT INTO mai_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","एक दिन यीशु मन्‍दिर मे लोक सभ केँ शिक्षा दैत छलाह और शुभ समाचार सुनबैत छलाह, तँ मुख्‍यपुरोहित और धर्मशिक्षक सभ बूढ़-प्रतिष्‍ठित लोकनिक संग हुनका लग आबि कऽ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“कहू! अहाँ ई सभ बात जे करैत छी, से कोन अधिकार सँ? ई अधिकार अहाँ केँ के देलनि?” ");
INSERT INTO mai_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ओ उत्तर देलथिन, “हमहूँ अहाँ सभ सँ एकटा बात पुछैत छी— ");
INSERT INTO mai_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","यूहन्‍ना केँ बपतिस्‍मा देबाक अधिकार परमेश्‍वर सँ भेटल छलनि वा मनुष्‍य सँ? कहू!” ");
INSERT INTO mai_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ई सुनि ओ सभ अपना मे तर्क-वितर्क करऽ लगलाह जे, जँ अपना सभ कहबैक जे परमेश्‍वर सँ, तँ ओ कहत जे, तखन हुनकर बातक विश्‍वास किएक नहि कयलहुँ? ");
INSERT INTO mai_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","मुदा जँ ई कहबैक जे, मनुष्‍य सँ, तँ समस्‍त जनता हमरा सभ पर पथरबाहि करत, कारण ओकरा सभ केँ पूरा विश्‍वास छैक जे यूहन्‍ना परमेश्‍वरक एकटा प्रवक्‍ता छलाह। ");
INSERT INTO mai_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","तेँ ओ सभ उत्तर देलथिन जे, “हम सभ नहि जनैत छी जे कतऽ सँ भेटल छलनि।” ");
INSERT INTO mai_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","एहि पर यीशु कहलथिन, “तँ हमहूँ अहाँ सभ केँ नहि कहब जे हम कोन अधिकार सँ ई काज करैत छी।” ");
INSERT INTO mai_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","तखन ओ लोक सभ केँ ई दृष्‍टान्‍त सुनाबऽ लगलथिन, “एक आदमी अंगूरक बगान लगौलनि। तकरबाद किसान सभ केँ बटाइ पर दऽ कऽ बहुत दिनक लेल परदेश चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","फलक समय अयला पर ओ अपन हिस्‍सा लेबाक लेल बटाइदार सभ लग एक नोकर केँ पठौलथिन। मुदा ओ सभ ओकरा पिटलकैक आ खाली हाथ लौटा देलकैक। ");
INSERT INTO mai_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","मालिक फेर दोसर नोकर केँ पठौलथिन, मुदा ओकरो ओ सभ मारि-पिटि कऽ और अपमानित कऽ कऽ खाली हाथ लौटा देलकैक। ");
INSERT INTO mai_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","मालिक तेसरो नोकर केँ पठौलथिन, और ओकरो ओ सभ घायल कऽ कऽ भगा देलकैक। ");
INSERT INTO mai_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","तखन मालिक विचारलनि, ‘हम की करू? हम अपन प्रिय बेटा केँ पठयबैक, एकरा ओ सभ शायद मानतैक।’ ");
INSERT INTO mai_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","मुदा बटाइदार सभ हुनका अबैत देखि एक-दोसराक संग विचारऽ लागल जे, ‘ई तँ अपन बापक उत्तराधिकारी अछि! चलू, एकरा मारि दिऐक, तखन ई सम्‍पत्ति अपने सभक भऽ जायत!’ ");
INSERT INTO mai_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","एना सोचि ओ सभ हुनका बगान सँ बाहर लऽ जा कऽ हुनका जान सँ मारि देलकनि। “आब मालिक ओकरा सभ केँ की करथिन? ");
INSERT INTO mai_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ओ आबि कऽ ओहि बटाइदार सभक सर्वनाश करथिन, और बगान दोसर बटाइदार सभ केँ दऽ देथिन।” ई सुनि लोक सभ बाजि उठल, “एना कहियो नहि होअय!” ");
INSERT INTO mai_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","यीशु ओकरा सभक दिस एकटक लगा कऽ देखैत कहलथिन, “तखन धर्मशास्‍त्र मे लिखल एहि बातक की अर्थ अछि जे, ‘जाहि पाथर केँ राजमिस्‍तिरी सभ बेकार बुझि फेकि देलक, वैह पाथर मकानक प्रमुख पाथर भऽ गेल।’? ");
INSERT INTO mai_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","जे केओ ओहि पाथर पर खसत, से चकना-चूर भऽ जायत, और जकरा पर ई पाथर खसतैक से थकुचा-थकुचा भऽ जायत।” ");
INSERT INTO mai_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","धर्मशिक्षक और मुख्‍यपुरोहित सभ हुनका तुरत पकड़ऽ चाहैत छलाह, कारण ओ सभ बुझि गेलाह जे ई हमरे सभक बारे मे ई कथा कहलक अछि। मुदा जनता सँ डेराइत छलाह। ");
INSERT INTO mai_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","धर्मशिक्षक आ मुख्‍यपुरोहित सभ अवसरक ताक मे छलाह। ओ सभ हुनका लग किछु भेदिया सभ केँ सोझिया आदमीक रूप मे पठा देलनि, एहि आशा मे जे यीशुक कोनो ने कोनो कहल बातक द्वारा हुनका पकड़ि सकी आ राज्‍यपाल-शासनक अधिकार मे रखबा दी। ");
INSERT INTO mai_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","भेदिया सभ हुनका सँ प्रश्‍न कयलकनि, “गुरुजी, हम सभ जनैत छी जे अपने ठीक-ठीक बात सभ बजैत आ सिखबैत छी, अपने ककरो मुँह देखि कऽ किछु नहि कहैत छिऐक, बल्‍कि सत्‍यक अनुसार परमेश्‍वरक बाटक शिक्षा दैत छी। ");
INSERT INTO mai_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","आब हमरा सभ केँ एकटा बात कहल जाओ—धर्म-नियमक अनुसार अपना सभक लेल रोमी सम्राट-कैसर केँ कर देनाइ उचित अछि वा नहि?” ");
INSERT INTO mai_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","मुदा ओ ओकर सभक कपट बुझि गेलथिन आ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“हमरा एकटा सिक्‍का देखाउ। एहि पर किनकर चित्र छनि आ किनकर नाम लिखल छनि?” ");
INSERT INTO mai_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ओ सभ उत्तर देलकनि, “सम्राट-कैसरक।” तखन यीशु ओकरा सभ केँ कहलथिन, “तँ जे सम्राटक छनि से सम्राट केँ दिऔन, और जे परमेश्‍वरक छनि, से परमेश्‍वर केँ दिऔन।” ");
INSERT INTO mai_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","एहि तरहेँ ओ सभ जनताक सामने हुनकर कहल कोनो बात मे हुनका नहि पकड़ि सकल। हुनकर उत्तर सँ चकित भऽ गुम्‍म रहि गेल। ");
INSERT INTO mai_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","सदुकी पंथक लोक, जे सभ एहि बात केँ नहि मानैत अछि जे मृत्‍यु मे सँ मनुष्‍य फेर जिआओल जायत, से सभ एकटा प्रश्‍न लऽ कऽ यीशु लग आयल। ");
INSERT INTO mai_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ओ सभ कहलकनि, “गुरुजी, मूसा हमरा सभक लेल लिखलनि जे, जँ ककरो भाय निःसन्‍तान मरि जाइक आ ओकर स्‍त्री जीविते होइक तँ ओकरा ओहि स्‍त्री सँ विवाह कऽ अपना भायक लेल सन्‍तान उत्‍पन्‍न करबाक चाही। ");
INSERT INTO mai_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","आब, केओ सात भाय रहय। जेठका विवाह कयलक आ निःसन्‍तान मरि गेल। ");
INSERT INTO mai_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","तँ दोसर भाय आ फेर तेसर भाय ओकरा सँ विवाह कयलक, और तहिना सातो भाय निःसन्‍तान मरि गेल। ");
INSERT INTO mai_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","अन्‍त मे स्‍त्रिओ मरि गेलि। ");
INSERT INTO mai_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","आब कहल जाओ, ओहि समय मे जहिया मुइल सभ केँ जिआओल जयतैक, तँ ओ स्‍त्री एहि भाय सभ मे सँ ककर स्‍त्री होयतैक? ओकरा सँ तँ सातो विवाह कयने छलैक।” ");
INSERT INTO mai_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","यीशु उत्तर देलथिन, “एही दुनियाक लोक विवाह करैत अछि आ विवाह मे देल जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","मुदा जे लोक सभ ओहि दुनिया मे जाय जोगरक ठहरि कऽ जीबि उठत, से ओहि दुनिया मे जा कऽ विवाह नहि करत। ");
INSERT INTO mai_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ओ सभ फेर मरि नहि सकैत अछि, ओ सभ तँ एहि विषय मे स्‍वर्गदूत सभ जकाँ अछि, और जीबि उठलाक कारणेँ ओ सभ परमेश्‍वरक सन्‍तान अछि। ");
INSERT INTO mai_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","मुदा मुइल सभ जीबि उठैत अछि वा नहि, ताहि प्रश्‍नक सम्‍बन्‍ध मे मूसा जरैत झाड़ीक विवरण मे स्‍पष्‍ट कयलनि जे अवश्‍य जीबि उठैत अछि, कारण ओ प्रभु केँ ‘अब्राहमक परमेश्‍वर, इसहाकक परमेश्‍वर और याकूबक परमेश्‍वर’ कहने छथि। ");
INSERT INTO mai_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ओ मुइल सभक नहि, बल्‍कि जीवित सभक परमेश्‍वर छथि। परमेश्‍वरक नजरि मे सभ केओ जीवित अछि।” ");
INSERT INTO mai_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","एहि पर धर्मशिक्षक सभ मे सँ किछु गोटे कहलथिन, “गुरुजी, अपने बड्ड नीक उत्तर देलहुँ।” ");
INSERT INTO mai_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","और ककरो हुनका सँ आरो बात पुछबाक साहस नहि भेलैक। ");
INSERT INTO mai_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","तखन यीशु ओकरा सभ केँ कहलथिन, “धर्मशास्‍त्र मे ई कोना कहल जाइत अछि जे उद्धारकर्ता-मसीह दाऊदक पुत्र छथि? ");
INSERT INTO mai_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","जखन कि दाऊद अपने भजन-संग्रहक पुस्‍तक मे कहैत छथि, ‘प्रभु-परमेश्‍वर हमरा प्रभु केँ कहलथिन, अहाँ हमर दहिना कात बैसू ");
INSERT INTO mai_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","और हम अहाँक शत्रु सभ केँ अहाँक पयरक तर मे कऽ देब।’ ");
INSERT INTO mai_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","दाऊद ‘उद्धारकर्ता-मसीह’ केँ ‘प्रभु’ कहैत छथिन। तँ ओ फेर हुनकर पुत्र कोना भेलाह?” ");
INSERT INTO mai_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","सभ लोक हुनकर बात सभ सुनि रहल छलनि तखन ओ अपना शिष्‍य सभ केँ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“धर्मशिक्षक सभ सँ सावधान रहू। धर्मगुरु वला लम्‍बा-लम्‍बा कपड़ा पहिरि कऽ घुमब, हाट-बजार मे लोक हुनका सभ केँ प्रणाम करनि, सभाघर सभ मे प्रमुख आसन पर बैसब और भोज-काज मे सम्‍मानित स्‍थान भेटय हुनका सभ केँ बहुत नीक लगैत छनि। ");
INSERT INTO mai_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","विधवा सभक घर-द्वारि हड़पि लैत छथि, और लोक सभ केँ देखयबाक लेल लम्‍बा-लम्‍बा प्रार्थना करैत छथि। ओहन लोक केँ बेसी दण्‍ड भेटतैक।” ");
INSERT INTO mai_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","यीशु नजरि उठा कऽ देखलनि जे धनिक सभ मन्‍दिरक दान-पात्र मे अपन दान चढ़ा रहल अछि। ");
INSERT INTO mai_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","एकटा गरीब विधवा केँ सेहो तामक दूटा पाइ दान-पात्र मे दैत देखलनि। ");
INSERT INTO mai_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ई देखि ओ बजलाह, “हम अहाँ सभ केँ सत्‍य कहैत छी जे, ई गरीब विधवा ओहि सभ आदमी सँ बेसी चढ़ौलक। ");
INSERT INTO mai_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ओ सभ तँ अपना फाजिल धन मे सँ दान चढ़ौलक, मुदा ई अपन गरीबी मे सँ अपन पूरा जीविके चढ़ा देलक।” ");
INSERT INTO mai_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","किछु शिष्‍य सभ मन्‍दिरक बारे मे बाजि रहल छलाह जे कतेक नीक सँ सुन्‍दर-सुन्‍दर पाथर और परमेश्‍वर केँ अर्पित कयल वस्‍तु सभ सँ बनाओल अछि। एहि पर यीशु कहलथिन, ");
INSERT INTO mai_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“ई सभ वस्‍तु जे एतऽ देखैत छी—तेहन समय आओत जहिया एतऽ एकोटा पाथर एक-दोसर पर नहि रहत। सभ ढाहल जायत।” ");
INSERT INTO mai_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ओ सभ हुनका सँ पुछलथिन, “गुरुजी, ई घटना कहिया होयत? और कोन चिन्‍ह होयतैक जाहि सँ बुझि सकी जे ई बात सभ आब होयत?” ");
INSERT INTO mai_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ओ उत्तर देलथिन, “होसियार रहू जाहि सँ बहकाओल नहि जायब। कारण, बहुतो लोक हमर नाम लऽ कऽ आओत आ कहत जे, ‘हम वैह छी,’ आ ‘समय लगचिआ गेल अछि।’ ओकरा सभक पाछाँ नहि जाउ! ");
INSERT INTO mai_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","जखन अनेक लड़ाइ और अन्‍दोलनक खबरि सुनब, तँ भयभीत नहि होउ। ई सभ तँ पहिने होयब आवश्‍यक अछि, मुदा संसारक अन्‍त तुरत नहि होयत।” ");
INSERT INTO mai_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","आगाँ ओ कहलथिन, “एक देश दोसर देश सँ लड़ाइ करत, और एक राज्‍य दोसर राज्‍य सँ। ");
INSERT INTO mai_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","बड़का-बड़का भूकम्‍‍प होयत, विभिन्‍न ठाम अकाल पड़त और अनेक स्‍थान मे महामारी होयत। आकाश मे भयंकर घटना सभ होयत और आश्‍चर्यजनक चिन्‍ह सभ देखाइ देत। ");
INSERT INTO mai_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“मुदा एहि सभ बात सँ पहिने हमरा कारणेँ लोक सभ अहाँ सभ केँ पकड़ि कऽ अहाँ सभ पर अत्‍याचार करत। अहाँ सभ केँ सभाघर सभ मे सौंपि देत, जहल मे बन्‍द कऽ देत, और राजा आ राज्‍यपाल सभक समक्ष लऽ जायत। ");
INSERT INTO mai_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ई बात सभ अहाँ सभक लेल गवाही देबाक अवसर होयत। ");
INSERT INTO mai_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","मुदा अहाँ सभ अपना मोन मे ई निश्‍चय कऽ लिअ जे हमरा पर लगाओल अभियोगक उत्तर मे हम की बाजू तकर चिन्‍ता पहिने सँ हम नहि करब। ");
INSERT INTO mai_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","कारण, अहाँ सभ केँ बजबाक लेल हम तेहन शब्‍द और बुद्धि देब जे कोनो विरोधी ने तकरा सामने मे टिकि सकत आ ने तकरा काटि सकत। ");
INSERT INTO mai_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","माय-बाबू, भाय, कुटुम्‍ब-परिवार और साथी-संगी सभ अहाँ सभक संग विश्‍वासघात कऽ कऽ पकड़बाओत, और अहाँ सभ मे सँ कतेको केँ मारिओ देत। ");
INSERT INTO mai_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","अहाँ सभ सँ सभ केओ एहि लेल घृणा करत जे अहाँ सभ हमर लोक छी। ");
INSERT INTO mai_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","मुदा अहाँ सभक माथक एकटा केशो नहि टुटत। ");
INSERT INTO mai_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","विश्‍वास मे दृढ़ रहला सँ अहाँ सभ जीवन प्राप्‍त करब। ");
INSERT INTO mai_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“जखन यरूशलेम केँ सेना सभ सँ घेराइत देखब, तँ ई बुझि लिअ जे ओकर विनाश लग आबि गेल। ");
INSERT INTO mai_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ओहि समय मे जे सभ यहूदिया प्रदेश मे होअय, से सभ पहाड़ पर भागि जाय। जे यरूशलेम मे होअय, से बाहर निकलि जाय, और जे लग-पासक देहात मे होअय, से शहर मे नहि जाय। ");
INSERT INTO mai_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","कारण ओ महादण्‍डक समय होयत जाहि समय मे धर्मशास्‍त्र मे लिखल सभ बात पूरा होयत। ");
INSERT INTO mai_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ओहि समय मे जे स्‍त्रीगण सभ गर्भवती होयत वा जकरा दूधपीबा बच्‍चा होयतैक, तकरा सभ केँ कतेक कष्‍ट होयतैक! किएक तँ एहि देश मे भयंकर संकट औतैक, और एहि लोक सभ पर परमेश्‍वरक प्रकोप पड़तैक। ");
INSERT INTO mai_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ओ सभ तरुआरि सँ मारल जायत, और बन्‍दी बनि कऽ विश्‍वक प्रत्‍येक राष्‍ट्र मे लऽ गेल जायत। यरूशलेम गैर-यहूदी सभ द्वारा तहिया धरि लतखुर्दन भऽ पिचाइत रहत जहिया धरि गैर-यहूदी सभ केँ देल गेल समय पूरा बिति नहि जायत। ");
INSERT INTO mai_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“सूर्य, चन्‍द्रमा और तारा सभ मे आश्‍चर्यजनक चिन्‍ह सभ देखाइ देत। पृथ्‍वी पर सभ जातिक लोक समुद्रक लहरि देखि आ ओकर गर्जन सुनि घबड़ा जायत और व्‍याकुल भऽ उठत। ");
INSERT INTO mai_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","पृथ्‍वी पर जे बात सभ घटऽ वला अछि, तकर डर-भय सँ लोक सभ बेहोस भऽ जायत। कारण, आकाशक शक्‍ति सभ हिलाओल जायत। ");
INSERT INTO mai_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","तकरबाद लोक मनुष्‍य-पुत्र केँ सामर्थ्‍य और अपार महिमाक संग मेघ मे अबैत देखत। ");
INSERT INTO mai_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ई सभ बात जखन होमऽ लागत तँ अहाँ सभ ठाढ़ भऽ जाउ और मूड़ी उठाउ, किएक तँ अहाँ सभक छुटकारा लगचिआ गेल रहत।” ");
INSERT INTO mai_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","तखन ओ हुनका सभ केँ ई दृष्‍टान्‍त देलथिन, “अंजीरक गाछ वा कोनो गाछ केँ लिअ। ");
INSERT INTO mai_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","जखने नव पात निकलऽ लगैत छैक तँ अपने सँ जानि लैत छी जे गर्मीक समय आबि रहल अछि। ");
INSERT INTO mai_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","तहिना, जखन अहाँ सभ ई बात सभ होइत देखब तँ बुझू जे परमेश्‍वरक राज्‍य लग आबि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“हम अहाँ सभ केँ सत्‍य कहैत छी जे एहि पीढ़ी केँ समाप्‍त होमऽ सँ पहिने ई सभ घटना निश्‍चित घटत। ");
INSERT INTO mai_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","आकाश और पृथ्‍वी समाप्‍त भऽ जायत, मुदा हमर वचन अनन्‍त काल तक रहत। ");
INSERT INTO mai_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“सावधान रहू! नहि तँ अहाँ सभक मोन भोग-विलास, नशा और जीवनक चिन्‍ता मे ओझरायल रहत, और ओ दिन अहाँ सभ पर अचानक आबि कऽ फन्‍दा जकाँ पकड़ि लेत। ");
INSERT INTO mai_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","कारण ओ दिन सम्‍पूर्ण पृथ्‍वी पर रहऽ वला सभ लोक पर अचानक आबि जायत। ");
INSERT INTO mai_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","एहि लेल सदिखन सचेत रहू, और प्रार्थना करू जे, जे घटना सभ होमऽ वला अछि ताहि मे बाँचि सकी और मनुष्‍य-पुत्रक सम्‍मुख ठाढ़ रहि सकी।” ");
INSERT INTO mai_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","यीशु दिन कऽ मन्‍दिर मे उपदेश दैत छलाह, और जैतून पहाड़ नामक परवत पर जा कऽ राति बितबैत छलाह। ");
INSERT INTO mai_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","लोक सभ हुनकर उपदेश सुनबाक लेल सभ दिन भोरे-भोर मन्‍दिर अबैत छल। ");
INSERT INTO mai_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","“बिनु खमीरक रोटी वला पाबनि”, जे “फसह-पाबनि” कहबैत अछि, लगचिआ गेल छल। ");
INSERT INTO mai_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","मुख्‍यपुरोहित और धर्मशिक्षक सभ यीशु केँ कोन प्रकारेँ मारि देल जाय तकर ठीक उपायक ताक मे लागल छलाह, कारण ओ सभ जनता सँ डेराइत छलाह। ");
INSERT INTO mai_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","तखन यहूदा इस्‍करियोती, जे बारह शिष्‍य मे सँ एक छल, तकरा मोन मे शैतान पैसि गेलैक। ");
INSERT INTO mai_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ओ जा कऽ मुख्‍यपुरोहित सभ और मन्‍दिरक सिपाही सभक कप्‍तान सभक संग बात-चीत कयलक जे ओ यीशु केँ कोना हुनका सभक हाथ मे पकड़बा देत। ");
INSERT INTO mai_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ओ सभ बड्ड प्रसन्‍न भेलाह, और ओकरा एहि काजक लेल पाइ देबाक लेल सहमत भेलाह। ");
INSERT INTO mai_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","यहूदा सेहो मानि लेलक, और जाहि समय मे लोकक भीड़ नहि रहत, ताहि समय मे यीशु केँ पकड़बा कऽ हुनका सभक हाथ मे देबाक अवसरक ताक मे रहऽ लागल। ");
INSERT INTO mai_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","तखन बिनु खमीरक रोटी वला पाबनिक ओ दिन आबि गेल, जाहि दिन फसह-भोजक भेँड़ा बलिदान करबाक छल। ");
INSERT INTO mai_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","पत्रुस और यूहन्‍ना केँ यीशु ई कहि कऽ पठौलथिन जे, “जाउ, अपना सभक लेल फसह-भोजक व्‍यवस्‍था करू।” ");
INSERT INTO mai_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ओ सभ पुछलथिन, “अहाँ कतऽ चाहैत छी जे हम सभ व्‍यवस्‍था करी?” ");
INSERT INTO mai_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ओ कहलथिन, “शहर मे प्रवेश करिते घैल मे पानि लऽ जाइत एक पुरुष अहाँ सभ केँ भेटत। जाहि घर मे ओ प्रवेश करत, ताहि मे अहाँ सभ ओकरा पाछाँ-पाछाँ जायब, ");
INSERT INTO mai_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","और घरक मालिक केँ कहबनि जे, ‘गुरुजी पुछैत छथि जे, ओ अतिथि-घर कतऽ अछि जतऽ हम अपना शिष्‍य सभक संग फसह-भोज खायब?’ ");
INSERT INTO mai_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ओ अहाँ सभ केँ उपरका तल्‍ला पर एक नमहर कोठली देखौताह जाहि मे सभ किछु तैयार रहत। ओतहि अहाँ सभ भोजक व्‍यवस्‍था करू।” ");
INSERT INTO mai_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ओ सभ गेलाह, और जहिना यीशु हुनका सभ केँ कहने छलथिन, ठीक ओहिना सभ किछु भेटलनि, और ओ सभ ओतऽ फसह-भोजक व्‍यवस्‍था कयलनि। ");
INSERT INTO mai_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","जखन भोज खयबाक समय भेल तँ यीशु अपन बारहो दूतक संग भोजन करबाक लेल बैसलाह। ");
INSERT INTO mai_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ओ हुनका सभ केँ कहलथिन, “हमरा बड्ड इच्‍छा छल जे अपन दुःख भोगनाइ सँ पहिने अहाँ सभक संग हम ई फसह-भोज खाइ। ");
INSERT INTO mai_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","कारण, हम अहाँ सभ केँ कहैत छी जे, जा धरि एहि भोजक अभिप्राय परमेश्‍वरक राज्‍य मे पूरा नहि होयत, ता धरि हम एकरा फेर नहि खायब।” ");
INSERT INTO mai_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ओ बाटी लेलनि, आ परमेश्‍वर केँ धन्‍यवाद दऽ कऽ शिष्‍य सभ केँ कहलथिन, “ई लिअ, अपना सभ मे बाँटि लिअ। ");
INSERT INTO mai_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","हम अहाँ सभ केँ कहैत छी जे, जाबत तक परमेश्‍वरक राज्‍य नहि आओत ताबत तक हम अंगूरक रस फेर नहि पीब।” ");
INSERT INTO mai_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ओ रोटी लेलनि आ परमेश्‍वर केँ धन्‍यवाद देलनि। रोटी केँ तोड़ि कऽ शिष्‍य सभ केँ देलथिन आ कहलथिन, “ई हमर देह अछि जे अहाँ सभक लेल देल जा रहल अछि। ई हमर यादगारी मे करू।” ");
INSERT INTO mai_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","तहिना भोजनक बाद ओ बाटी लेलनि आ कहलथिन, “एहि बाटी मे परमेश्‍वर आ मनुष्‍यक बीच नव सम्‍बन्‍ध स्‍थापित करऽ वला हमर खून अछि, जे अहाँ सभक लेल बहाओल जा रहल अछि। ");
INSERT INTO mai_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","मुदा हमरा पकड़बाबऽ वला एतऽ हमरा संग भोजन पर बैसल अछि! ");
INSERT INTO mai_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","मनुष्‍य-पुत्र तँ, जहिना ओकरा लेल निश्‍चित कयल गेल छैक, तहिना चल जायत, मुदा धिक्‍कार अछि ओहि मनुष्‍य केँ जे ओकरा पकड़बा रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","एहि पर शिष्‍य सभ एक-दोसर सँ पुछऽ लागल जे, ओ के भऽ सकैत अछि, जे एहन काज करत? ");
INSERT INTO mai_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","शिष्‍य सभक बीच एहि विषय मे विवाद उठि गेल जे, हमरा सभ मे पैघ के मानल जाय। ");
INSERT INTO mai_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","यीशु कहलथिन, “एहि संसारक राज्‍य सभ मे राजा सभ अपना प्रजा पर हुकुम चलबैत रहैत छथि, और प्रजा पर अधिकार जमाबऽ वला सभ अपना केँ ‘उपकारी’ कहैत अछि। ");
INSERT INTO mai_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","मुदा अहाँ सभ मे एना नहि होअय। बल्‍कि, जे अहाँ सभ मे पैघ होअय, से सभ सँ छोट बनय, और जकरा अधिकार होइक, से दास बनय। ");
INSERT INTO mai_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","पैघ के अछि, ओ जे भोजन करबाक लेल बैसल अछि, वा ओ जे सेवा करैत अछि? की भोजन करऽ वला पैघ नहि अछि? मुदा हम अहाँ सभक बीच सेवकक रूप मे छी। ");
INSERT INTO mai_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“अहीं सभ छी जे हमर बेर-विपत्ति मे हमरा संग दैत रहलहुँ। ");
INSERT INTO mai_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","और जहिना हमर पिता हमरा राज्‍य करबाक अधिकार देने छथि, तहिना हमहूँ अहाँ सभ केँ राज्‍य करबाक अधिकार दैत छी, ");
INSERT INTO mai_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","जाहि सँ अहाँ सभ हमर राज्‍य मे हमरा संग खायब-पीब, और सिंहासन पर बैसि कऽ इस्राएलक बारहो कुलक न्‍याय करब। ");
INSERT INTO mai_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“सिमोन, यौ सिमोन! सुनू! शैतान अहाँ सभक माँग कयने अछि, जे ओ अहाँ सभ केँ गहुम जकाँ फटकय। ");
INSERT INTO mai_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","मुदा हम अहाँक लेल पिता सँ प्रार्थना कयने छी जे अहाँक विश्‍वास टुटय नहि। अहाँ जखन हमरा दिस फेर घूमि आयब, तँ विश्‍वास मे स्‍थिर रहऽ मे अपना भाय सभक मदति करब।” ");
INSERT INTO mai_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","मुदा पत्रुस उत्तर देलथिन, “प्रभु! हम अहाँक संग जहल मे जयबाक लेल आ मरबाक लेल सेहो तैयार छी!” ");
INSERT INTO mai_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","यीशु कहलथिन, “यौ पत्रुस, हम अहाँ केँ कहैत छी जे, आइए मुर्गा केँ बाजऽ सँ पहिने अहाँ तीन बेर हमरा अस्‍वीकार कऽ कऽ लोक केँ कहबैक जे, हम ओकरा चिन्‍हबो नहि करैत छिऐक।” ");
INSERT INTO mai_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","तखन ओ हुनका सभ केँ कहलथिन, “हम अहाँ सभ केँ जखन बटुआ, झोरा और जुत्ताक बिना बाहर पठौने रही, तँ की कोनो वस्‍तुक अभाव भेल?” ओ सभ उत्तर देलथिन, “नहि।” ");
INSERT INTO mai_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","तखन यीशु कहलथिन, “मुदा आब, जकरा बटुआ छैक वा झोरा छैक से लऽ लिअय। आ जकरा तरुआरि नहि छैक, से अपन कोनो वस्‍त्र बेचि कऽ किनि लिअय। ");
INSERT INTO mai_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","किएक तँ हम अहाँ सभ केँ कहैत छी जे, धर्मशास्‍त्र मे लिखल ई बात हमरा मे पूरा होयबाक अछि जे, ‘ओ अपराधी सभ मे गनल गेलाह।’ हँ, जे बात हमरा विषय मे लिखल अछि, से एखनो पूरा भऽ रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","शिष्‍य सभ हुनका कहलथिन, “प्रभु, देखू, एतऽ दूटा तरुआरि अछि।” ओ उत्तर देलथिन, “बस, भऽ गेल।” ");
INSERT INTO mai_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","तखन यीशु शहर सँ बहरा कऽ जैतून पहाड़ पर गेलाह, जतऽ ओ बेसी काल जाइत छलाह। हुनका संग हुनकर शिष्‍य सभ सेहो छलथिन। ");
INSERT INTO mai_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ओतऽ पहुँचि कऽ ओ शिष्‍य सभ केँ कहलथिन, “प्रार्थना करैत रहू जे परीक्षा मे नहि पड़ी।” ");
INSERT INTO mai_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","तखन ओ शिष्‍य सभ सँ किछु दूर हटि ठेहुनिया दऽ कऽ एहि तरहेँ प्रार्थना करऽ लगलाह जे, ");
INSERT INTO mai_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“हे पिता, अहाँ जँ चाहैत छी, तँ ई दुःखक बाटी हमरा लग सँ हटा लिअ। मुदा तैयो हमर इच्‍छा नहि, अहींक इच्‍छा पूरा होअय।” ");
INSERT INTO mai_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","तखन हुनका साहस देबाक लेल एक स्‍वर्गदूत हुनका लग अयलथिन। ");
INSERT INTO mai_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ओ व्‍याकुल भऽ कऽ प्रार्थना मे एतेक लीन भऽ गेलाह जे हुनका शरीर सँ खूनक बुन्‍द सनक पसेना ठोपे-ठोप जमीन पर खसि रहल छलनि। ");
INSERT INTO mai_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","प्रार्थना सँ उठि कऽ ओ शिष्‍य सभ लग अयलाह। शिष्‍य सभ शोकित भऽ थाकि कऽ सुतल छलाह। ");
INSERT INTO mai_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","यीशु कहलथिन, “अहाँ सभ सुतल किएक छी? उठू, आ प्रार्थना करैत रहू जे परीक्षा मे नहि पड़ी।” ");
INSERT INTO mai_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","यीशु बाजिए रहल छलाह कि लोकक भीड़ ओतऽ पहुँचल। हुनकर बारह शिष्‍य मे सँ एक, जकर नाम यहूदा छलैक, से ओकरा सभक आगाँ छल। ओ चुम्‍मा लेबाक लेल यीशुक लग मे अयलनि, ");
INSERT INTO mai_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","मुदा यीशु ओकरा कहलथिन, “हौ यहूदा, की तोँ मनुष्‍य-पुत्र केँ चुम्‍मा लऽ कऽ धोखा दऽ रहल छह?” ");
INSERT INTO mai_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","यीशुक शिष्‍य सभ जखन देखलनि जे आब की होयत तँ पुछलथिन, “प्रभु, की हम सभ तरुआरि चलाउ?” ");
INSERT INTO mai_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","हुनका सभ मे सँ एक गोटे महापुरोहितक टहलू पर तरुआरि चला कऽ ओकर दहिना कान काटि देलनि। ");
INSERT INTO mai_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","मुदा यीशु कहलथिन, “रूकू, रूकू!” और ओहि आदमीक कान छुबि कऽ ठीक कऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","तखन यीशु मुख्‍यपुरोहित, मन्‍दिरक सिपाही और बूढ़-प्रतिष्‍ठित सभ जे हुनका पकड़ऽ आयल छल, तकरा सभ केँ कहलथिन, “की अहाँ सभ हमरा विद्रोह मचाबऽ वला बुझि कऽ लाठी और तरुआरि लऽ कऽ पकड़ऽ अयलहुँ? ");
INSERT INTO mai_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","हम अहाँ सभक संग सभ दिन मन्‍दिर मे छलहुँ तँ हमरा पकड़बाक कोशिश नहि कयलहुँ। मुदा एखन ई अहाँ सभक समय अछि, एखन अन्‍हार केँ अधिकार छैक।” ");
INSERT INTO mai_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","तखन ओ सभ यीशु केँ पकड़ि लेलकनि आ ओहिठाम सँ महापुरोहितक भवन मे लऽ गेलनि। पत्रुस सेहो किछु दूर रहि कऽ पाछाँ-पाछाँ गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","लोक सभ आङनक बीच मे घूर लगा कऽ आगि तापऽ बैसल तँ पत्रुसो आबि कऽ बैसि रहलाह। ");
INSERT INTO mai_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","एक नोकरनी आगिक इजोत मे हुनका बैसल देखलकनि आ हुनकर मुँह ठिकिअबैत बाजल, “इहो ओकरे संग छलैक।” ");
INSERT INTO mai_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","मुदा पत्रुस अस्‍वीकार कऽ कऽ कहलथिन, “गे! हम ओकरा चिन्‍हबो नहि करैत छिऐक।” ");
INSERT INTO mai_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","किछु कालक बाद केओ दोसर गोटे हुनका देखि कहलकनि, “अहूँ तँ ओकरे सभ मे सँ छी।” पत्रुस उत्तर देलथिन, “यौ भाइ, हम नहि छी!” ");
INSERT INTO mai_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","करीब एक घण्‍टाक बाद फेर तेसर गोटे जोर दैत बाजल, “ई आदमी पक्‍का ओकरा संग छलैक, इहो तँ गलीले निवासी अछि।” ");
INSERT INTO mai_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","मुदा पत्रुस उत्तर देलथिन, “भाइ, अहाँ की कहैत छी से हम बुझबे नहि करैत छी!” ओ ई बात कहिए रहल छलाह कि तुरत्ते मुर्गा बाजि उठल। ");
INSERT INTO mai_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","प्रभु घूमि कऽ पत्रुसक दिस तकलथिन। तखने हिनका प्रभुक कहल बात मोन पड़ि गेलनि जे, “आइ मुर्गा केँ बाजऽ सँ पहिने अहाँ तीन बेर हमरा अस्‍वीकार करब।” ");
INSERT INTO mai_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ओ ओहिठाम सँ बाहर भऽ भोकासी पाड़ि कऽ कानऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","जे सिपाही सभ यीशु पर पहरा दऽ रहल छलनि से सभ हुनकर हँसी उड़ाबऽ लगलनि और मारऽ-पिटऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","हुनका आँखि पर पट्टी बान्‍हि कऽ कहलकनि, “यौ अन्‍तर्यामी! कहल जाओ, अपने केँ के मारलक?” ");
INSERT INTO mai_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","एहि तरहक आरो-आरो बहुत बात सभ कहि कऽ हुनकर अपमान कयलकनि। ");
INSERT INTO mai_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","भोर भेला पर यहूदी सभक बूढ़-प्रतिष्‍ठित सभ, मुख्‍यपुरोहित सभ और धर्मशिक्षक सभ महासभा मे जमा भेलाह, और यीशु केँ हुनका सभक सामने आनल गेलनि। ");
INSERT INTO mai_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ओ सभ कहलथिन, “अहाँ जँ उद्धारकर्ता-मसीह छी, तँ हमरा सभ केँ स्‍पष्‍ट कहू।” ओ उत्तर देलथिन, “हम जँ कहब, तँ अहाँ सभ विश्‍वास करब नहि, ");
INSERT INTO mai_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","और हम जँ अहाँ सभ सँ पुछब, तँ अहाँ सभ उत्तर देब नहि। ");
INSERT INTO mai_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","मुदा आब मनुष्‍य-पुत्र सर्वशक्‍तिमान परमेश्‍वरक दहिना कात बैसत।” ");
INSERT INTO mai_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ओ सभ केओ एके संग पुछलथिन, “तखन की अहाँ परमेश्‍वरक पुत्र छी?” ओ उत्तर देलथिन, “अहाँ सभ ठीक कहैत छी। हँ, हम वैह छी।” ");
INSERT INTO mai_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","एहि पर ओ सभ बजलाह, “आब आरो गवाहीक की आवश्‍यकता? अपना सभ स्‍वयं एकरे मुँह सँ सभटा सुनि लेलहुँ।” ");
INSERT INTO mai_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","तखन पूरा सभा उठि कऽ यीशु केँ राज्‍यपाल पिलातुसक सामने लऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ओ सभ हुनका पर अभियोग लगाबऽ लागल जे, “एकरा हम सभ जनता केँ भड़कबैत पौलिऐक। ओ सम्राट-कैसर केँ कर देनाइ मना करैत अछि, और अपना केँ मसीह, अर्थात् राजा, कहैत अछि।” ");
INSERT INTO mai_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","एहि पर पिलातुस हुनका सँ पुछलथिन, “की अहाँ यहूदी सभक राजा छी?” ओ उत्तर देलथिन, “अहाँ अपने कहि रहल छी।” ");
INSERT INTO mai_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","तखन पिलातुस मुख्‍यपुरोहित सभ और लोकक भीड़ केँ कहलथिन, “एहि आदमी मे हम कोनो दोष नहि देखैत छी।” ");
INSERT INTO mai_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","मुदा ओ सभ आओर जोर दऽ कऽ कहलकनि, “ओ अपन सिद्धान्‍तक द्वारा जनता केँ भड़कबैत अछि। गलील प्रदेश सँ शुरू कऽ कऽ एहिठाम तक आबि ओ समस्‍त यहूदिया प्रदेश मे अपन शिक्षा दैत आयल अछि।” ");
INSERT INTO mai_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ई सुनि पिलातुस पुछलथिन, “की ई आदमी गलील प्रदेशक अछि?” ");
INSERT INTO mai_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","और ई बुझि जे यीशु हेरोदक अधिकार-क्षेत्रक छथि, ओ हुनका हेरोदक ओहिठाम पठा देलथिन। हेरोद ओहि समय मे यरूशलेमे मे छलाह। ");
INSERT INTO mai_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","हेरोद यीशु केँ देखि कऽ बहुत प्रसन्‍न भेलाह, किएक तँ ओ हुनका विषय मे बहुत किछु सुनने छलाह, और बहुत दिन सँ हुनका देखबाक इच्‍छा छलनि। ओ आशा रखने छलाह जे यीशु कोनो चमत्‍कार करताह, से हम देखब। ");
INSERT INTO mai_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","तेँ ओ यीशु सँ बहुत काल तक प्रश्‍न करैत रहलाह, मुदा ई हुनका कोनो उत्तर नहि देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","मुख्‍यपुरोहित और धर्मशिक्षक सभ ओतऽ ठाढ़ भऽ कऽ जोर-जोर सँ बाजि कऽ यीशु पर अभियोग लगा रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","तखन राजा हेरोद और हुनकर सैनिक सभ यीशुक अपमान कयलथिन और हँसी उड़ौलथिन। हुनका राजसी वस्‍त्र पहिरा कऽ पिलातुस लग घुमा देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","हेरोद और पिलातुस, जे पहिने एक-दोसराक कट्टर दुश्‍मन छलाह, से ओही दिन सँ मित्र बनि गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","तखन पिलातुस मुख्‍यपुरोहित सभ, नेता सभ और जनता केँ बजा कऽ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“अहाँ सभ एहि आदमी केँ हमरा सामने पेश कऽ कऽ ई अभियोग लगौलिऐक जे, ई आदमी जनता केँ बहका कऽ आन्‍दोलन कराबऽ चाहैत अछि। हम अहाँ सभक सामने एकर जाँच कयलहुँ, और जाहि बातक अभियोग अहाँ सभ एकरा पर लगा रहल छिऐक, ताहि सम्‍बन्‍ध मे हम एकरा दोषी नहि पबैत छी। ");
INSERT INTO mai_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","और हेरोदो दोषी नहि पौलनि, कारण, ओ एकरा हमरा लग फेर घुमा देलनि। स्‍पष्‍ट अछि जे ई तेहन कोनो काज नहि कयने अछि जाहि सँ एकरा मृत्‍युदण्‍ड देल जाइक। ");
INSERT INTO mai_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","तेँ हम आब एकरा दण्‍ड दऽ कऽ छोड़ि दैत छिऐक।” ");
INSERT INTO mai_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","फसह-पाबनिक अवसर पर हुनका कोनो कैदी केँ छोड़ि देबाक छलनि। ");
INSERT INTO mai_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","मुदा ओ सभ एक संग जोर-जोर सँ हल्‍ला करैत कहलक जे, “एकरा खतम करू! हमरा सभक लेल बरब्‍बा केँ छोड़ि दिअ!” ");
INSERT INTO mai_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","बरब्‍बा एक कैदी छल जे नगर मे कोनो विद्रोहक कारणेँ आ हत्‍याक अपराध मे जहल मे राखि देल गेल छल। ");
INSERT INTO mai_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पिलातुस यीशु केँ मुक्‍त करबाक इच्‍छा सँ लोक सभ केँ फेर मनयबाक प्रयत्‍न कयलनि, ");
INSERT INTO mai_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","मुदा ओ सभ नारा लगाबऽ लागल जे, “क्रूस पर चढ़ाउ! ओकरा क्रूस पर चढ़ाउ!” ");
INSERT INTO mai_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","तेसर बेर पिलातुस ओकरा सभ केँ कहलथिन, “किएक? ई कोन अपराध कयने अछि? हम एकरा मे एहन कोनो दोष नहि देखैत छी जाहि कारणेँ एकरा मृत्‍युदण्‍ड देल जाइक। तेँ हम एकरा दण्‍ड दऽ कऽ छोड़ि दैत छिऐक।” ");
INSERT INTO mai_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","मुदा ओ सभ जोर-जोर सँ हल्‍ला कऽ कऽ पिलातुस सँ जिद्द कयलक जे, “ओकरा क्रूसे पर चढ़ाउ।” ओकर सभक हल्‍लाक कारणेँ ओकरा सभक जीत भेलैक। ");
INSERT INTO mai_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","पिलातुस ओकर सभक माँग पूरा करबाक निर्णय कयलनि। ");
INSERT INTO mai_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","विद्रोह और हत्‍याक कारणेँ जहल मे बन्‍द कयल गेल अपराधी, जकरा छोड़ि देबाक माँग ओ सभ कयने छलैक, तकरा ओ छोड़ि देलथिन, आ यीशु केँ ओकरा सभक इच्‍छा पर दऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ओ सभ यीशु केँ जखन लऽ जा रहल छलनि, तँ कुरेन नगरक सिमोन नामक एक आदमी, जे गाम सँ शहर दिस आबि रहल छल, तकरा पकड़ि कऽ ओकरा पर यीशुक क्रूस लादि देलकैक, जाहि सँ ओ यीशुक पाछाँ-पाछाँ क्रूस केँ लऽ चलय। ");
INSERT INTO mai_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","यीशुक पाछाँ बड़का भीड़ जा रहल छल। ओहि मे बहुत स्‍त्रीगणो सभ छलीह, जे हुनका लेल शोक आ विलाप कऽ रहल छलीह। ");
INSERT INTO mai_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","यीशु घूमि कऽ हुनका सभ केँ कहलथिन, “हे यरूशलेमक बेटी सभ! हमरा लेल नहि कानू, बरु अपना लेल और अपना धिआ-पुता सभक लेल कानू। ");
INSERT INTO mai_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","कारण, तेहन समय आओत जहिया अहाँ सभ कहब जे, ‘कतेक धन्‍य ओ स्‍त्रीगण सभ अछि जकरा बाल-बच्‍चा नहि भेलैक, हँ, ओ सभ, जे धिआ-पुता केँ जन्‍म नहि देलक, जे कहियो दूध नहि पिऔलक!’ ");
INSERT INTO mai_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","तखन, ‘लोक पहाड़ सभ केँ कहतैक जे, हमरा सभ पर खसि पड़! हँ, कहतैक जे, हमरा सभ केँ झाँपि ले!’ ");
INSERT INTO mai_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","कारण, जँ हरियर गाछक संग ओ सभ एना करैत अछि, तँ सुखायलक संग की नहि करतैक?” ");
INSERT INTO mai_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","यीशुक संग आरो दू आदमी, जे अपराधी छल, तकरो मृत्‍युदण्‍डक लेल लऽ गेल गेलैक। ");
INSERT INTO mai_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ओहि स्‍थान पर पहुँचि कऽ जे “खप्‍पड़” कहबैत अछि, सिपाही सभ यीशु केँ हाथ-पयर मे काँटी ठोकि कऽ क्रूस पर टाँगि देलकनि, ओहिना ओहि दूनू अपराधी केँ सेहो, एकटा केँ हुनकर दहिना कात आ दोसर केँ बामा कात। ");
INSERT INTO mai_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","क्रूस पर चढ़ाओल गेलाक बाद यीशु बजलाह, “यौ पिता, एकरा सभ केँ क्षमा करिऔक, किएक तँ ई सभ नहि जनैत अछि जे की कऽ रहल अछि।” तखन सैनिक सभ पुरजी खसा कऽ यीशुक वस्‍त्र अपना मे बाँटि लेलक। ");
INSERT INTO mai_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","लोक सभ ओतऽ ठाढ़ भऽ कऽ ई सभ देखि रहल छल। यहूदी अधिकारी सभ यीशुक हँसी उड़बैत कहैत छल, “ई आन लोक सभ केँ बचौलक। ई जँ परमेश्‍वरक पठाओल मसीह अछि, जँ परमेश्‍वरक चुनल व्‍यक्‍ति अछि, तँ अपना केँ बचाबओ!” ");
INSERT INTO mai_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","सैनिक सभ सेहो यीशु लग आबि कऽ हुनकर हँसी उड़ौलकनि। हुनका तिताह दारू पिबाक लेल देलकनि आ कहलकनि, ");
INSERT INTO mai_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“तोँ जँ यहूदी सभक राजा छेँ तँ अपना केँ बचा!” ");
INSERT INTO mai_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","हुनका मूड़ीक उपर एकटा सूचना टाँगल छल, जाहि पर लिखल छलैक, “ई यहूदी सभक राजा अछि।” ");
INSERT INTO mai_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","यीशुक कात मे टाँगल एक अपराधी हुनकर निन्‍दा करैत कहलकनि, “की तोँ उद्धारकर्ता-मसीह नहि छेँ? अपना केँ बचा, आ हमरो सभ केँ बचा ले!” ");
INSERT INTO mai_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","मुदा दोसर अपराधी ओकरा डाँटि कऽ कहलकैक, “रौ! की तोरा परमेश्‍वरक डर नहि छौ? तोहूँ तँ वैह दण्‍ड भोगि रहल छेँ। ");
INSERT INTO mai_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","हमरा-तोरा तँ ठीक दण्‍ड भेटल अछि। किएक तँ अपना सभ अपना काजक फल भोगि रहल छी, मुदा ई तँ कोनो अपराध नहि कयने अछि।” ");
INSERT INTO mai_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","तखन ओ यीशु केँ कहलकनि, “यौ यीशु, अहाँ जखन अपना राज्‍य मे आयब तँ हमरा मोन राखब।” ");
INSERT INTO mai_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","यीशु उत्तर देलथिन, “हम तोरा सत्‍य कहैत छिअह जे, आइए तोँ हमरा संग स्‍वर्गधाम मे होयबह।” ");
INSERT INTO mai_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","लगभग दुपहरक समय छलैक, तखन सौंसे देश अन्‍हार-कुप्‍प भऽ गेल, कारण सूर्यक प्रकाश समाप्‍त भऽ गेल। करीब तीन बजे तक देश मे अन्‍हारे रहल। मन्‍दिर मे जे परदा छलैक, से फाटि कऽ दू भाग मे भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","तखन यीशु बहुत जोर सँ बजलाह, “हे पिता, हम अपन आत्‍मा अहाँक हाथ मे सौंपि रहल छी।” ई कहि कऽ ओ प्राण त्‍यागि देलनि। ");
INSERT INTO mai_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","रोमी कप्‍तान ई सभ बात देखि परमेश्‍वरक स्‍तुति करैत बाजल, “सत्‍ये ई आदमी निर्दोष छल।” ");
INSERT INTO mai_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","जे लोक सभ ई दृश्‍य देखबाक लेल जुटि गेल छल, से सभ जखन देखलक जे की सभ भेल, तँ सभ लोक छाती पिटैत घर जाय लागल। ");
INSERT INTO mai_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","मुदा हुनकर चिन्‍हल-जानल लोक सभ दूरे ठाढ़ भऽ कऽ ई सभ बात देखि रहल छलाह, जाहि मे हुनका संग गलील प्रदेश सँ आयल स्‍त्रीगण सभ सेहो छलीह। ");
INSERT INTO mai_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","यहूदिया प्रदेशक अरिमतिया नगरक निवासी यूसुफ नामक एक आदमी छलाह जे महासभाक सदस्‍य छलाह। ओ सज्‍जन और धार्मिक लोक छलाह आ परमेश्‍वरक राज्‍यक प्रतीक्षा कऽ रहल छलाह। यीशुक सम्‍बन्‍ध मे महासभा जे निर्णय आ काज कयने छल, ताहि सँ ओ सहमत नहि भेल रहथि। ");
INSERT INTO mai_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","तँ ओ आदमी पिलातुस लग जा कऽ यीशुक लास माँगि लेलनि। ");
INSERT INTO mai_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ओ क्रूस सँ लास उतारि कऽ मलमलक कपड़ा मे लपेटलनि, और पाथर काटि कऽ बनाओल कबर मे राखि देलनि। ओहि मे कोनो लास कहियो नहि राखल गेल छल। ");
INSERT INTO mai_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ई शुक्रदिन, विश्राम-दिनक तैयारीक दिन छल, और विश्राम-दिन शुरू भऽ रहल छल। ");
INSERT INTO mai_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","जे स्‍त्रीगण सभ यीशुक संग गलील प्रदेश सँ आयल छलीह, से सभ यूसुफक पाछाँ-पाछाँ जा कऽ कबर देखलनि और इहो देखलनि जे यीशुक लास ओहि मे कोना राखल गेलनि। ");
INSERT INTO mai_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","तखन ओ सभ घर जा कऽ यीशुक लास मे लगयबाक लेल सुगन्‍धित तेल और इत्र तैयार कयलनि। मुदा विश्राम-दिन मे ओ सभ धर्म-नियमक आज्ञा मानि कऽ विश्राम कयलनि। ");
INSERT INTO mai_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","विश्राम-दिनक प्रात भेने, अर्थात् सप्‍ताहक पहिल दिन, भोरे-भोर ओ स्‍त्रीगण सभ अपन तैयार कयल सुगन्‍धित तेल सभ लऽ कऽ कबर पर गेलीह। ");
INSERT INTO mai_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ओतऽ पहुँचला पर ओ सभ देखलनि जे कबरक मुँह पर जे पाथर राखल छलैक, से एक कात हटाओल गेल अछि। ");
INSERT INTO mai_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","मुदा ओ सभ जखन कबरक भीतर गेलीह तँ प्रभु यीशुक लास नहि देखलनि। ");
INSERT INTO mai_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","एहि पर ओ सभ सोच मे पड़ि गेलीह जे, ई की भेल? ताबते मे चमकैत वस्‍त्र पहिरने दू पुरुष हुनका सभ लग आबि ठाढ़ भऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ओ सभ डरेँ मूड़ी झुका कऽ नीचाँ मुँहें देखऽ लगलीह। ओ दूनू पुरुष हुनका सभ केँ कहलथिन, “अहाँ सभ जीवित आदमी केँ मुइल सभ मे किएक ताकि रहल छियनि? ");
INSERT INTO mai_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ओ एतऽ नहि छथि, जीबि उठल छथि! ओ गलील मे रहैत काल अहाँ सभ केँ की कहने रहथि, से मोन पाड़ू। ");
INSERT INTO mai_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ई जे, मनुष्‍य-पुत्र केँ पापी सभक हाथ मे सौंपल जयनाइ, क्रूस पर चढ़ाओल जयनाइ और तेसर दिन जीबि उठनाइ आवश्‍यक छनि।” ");
INSERT INTO mai_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","तखन यीशुक ई कहल बात हुनका सभ केँ मोन पड़लनि। ");
INSERT INTO mai_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","कबर पर सँ घूमि आबि कऽ ओ सभ ई सभ बात एगारहो शिष्‍य केँ और आरो लोक सभ केँ सुनौलथिन। ");
INSERT INTO mai_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","जे स्‍त्रीगण सभ ई बात सभ मसीह-दूत लोकनि केँ सुनौलथिन, से ई सभ छलीह—मरियम मग्‍दलीनी, योअन्‍ना, याकूबक माय मरियम और हुनकर सभक आरो संगी सभ। ");
INSERT INTO mai_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","मुदा मसीह-दूत सभ केँ ई सभ बात बताहे वला बुझयलनि और ओ सभ विश्‍वास नहि कयलथिन। ");
INSERT INTO mai_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","तैयो पत्रुस उठि कऽ कबर पर दौड़ैत गेलाह। ओ निहुड़ि कऽ भीतर तकलनि तँ मात्र मलमल वला पट्टी सभ एक कात पड़ल देखलनि। एहि बात सँ आश्‍चर्यित होइत ओ घूमि अयलाह। ");
INSERT INTO mai_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ओही दिन यीशुक संगी मे सँ दू व्‍यक्‍ति इम्‍माउस नामक गाम जा रहल छलाह, जे यरूशलेम सँ करीब चारि कोस दूर अछि। ");
INSERT INTO mai_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ओ सभ बाट मे एहि बितल घटना सभक बारे मे अपना मे गप्‍प-सप्‍प कऽ रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","गप्‍प-सप्‍प और विचार-विमर्श करैत काल यीशु स्‍वयं हुनका सभक लग आबि संग-संग चलऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","मुदा हुनका सभक नजरि तेना बन्‍द कयल गेल छलनि जे ओ सभ यीशु केँ नहि चिन्‍हि सकलथिन। ");
INSERT INTO mai_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ओ हुनका सभ सँ पुछलथिन, “अहाँ सभ चलैत-चलैत अपना मे की गप्‍प-सप्‍प कऽ रहल छी?” ओ सभ उदास मोन सँ ठाढ़ भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ओहि मेहक एक गोटे जिनकर नाम क्‍लियोपास छलनि, से यीशु केँ कहलथिन, “यरूशलेम मे अहींटा एहन प्रवासी होयब जकरा बुझल नहि छैक जे हाल मे की घटना सभ भेल!” ");
INSERT INTO mai_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","यीशु पुछलथिन, “कोन घटना सभ?” ओ सभ उत्तर देलथिन, “नासरत-निवासी यीशुक सम्‍बन्‍ध मे। ओ परमेश्‍वरक प्रवक्‍ता छलाह, और परमेश्‍वरक आ समस्‍त जनताक नजरि मे हुनकर काज और वचन सामर्थ्‍यपूर्ण छलनि। ");
INSERT INTO mai_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","मुख्‍यपुरोहित सभ और हमरा सभक महासभाक अधिकारी सभ हुनका मृत्‍युदण्‍ड दिअयबाक लेल राज्‍यपालक हाथ मे सौंपि देलथिन, आ क्रूस पर चढ़ा कऽ मरबा देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","हमरा सभ केँ तँ आशा छल जे यैह इस्राएल केँ छुटकारा दिऔताह। और एतबे नहि, एक बात आओर अछि—आइ तीन दिन भेल ई घटना सभ भेला, ");
INSERT INTO mai_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","और आइ हमर सभक किछु स्‍त्रीगण सभ हमरा सभ केँ आश्‍चर्यित कऽ देलनि। ओ सभ आइ भोरे-भोर कबर पर गेलीह ");
INSERT INTO mai_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","मुदा हुनकर लास हुनका सभ केँ नहि भेटलनि। ओ सभ आबि कऽ हमरा सभ केँ कहलनि जे एना-एना स्‍वर्गदूतक दर्शन भेल आ स्‍वर्गदूत कहलनि जे ओ जीविते छथि। ");
INSERT INTO mai_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","एहि पर हमरा सभक किछु संगी सभ कबर पर गेलाह, आ जहिना स्‍त्रीगण सभ कहने छलीह, तहिना हुनका सभ केँ सभ किछु भेटलनि, मुदा यीशु केँ ओ सभ नहि देखलनि।” ");
INSERT INTO mai_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ओ हुनका सभ केँ कहलथिन, “अहाँ सभ कतेक निर्बुद्धि छी! प्रभुक प्रवक्‍ता लोकनिक सभ कथन पर अहाँ सभ विश्‍वास करबाक लेल किएक नहि तैयार भेलहुँ? ");
INSERT INTO mai_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","की मसीह केँ दुःख उठौलाक बादे अपना स्‍वर्गिक महिमा मे प्रवेश नहि करबाक छलनि?” ");
INSERT INTO mai_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","तखन यीशु मूसाक और अन्‍य प्रवक्‍ता सभक लेख सँ शुरू कऽ कऽ सम्‍पूर्ण धर्मशास्‍त्र मे अपना बारे मे लिखल बात सभ हुनका सभ केँ बुझाबऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ताबते मे ओ सभ ओहि गाम लग पहुँचलाह जतऽ जयबाक छलनि, और यीशु एना देखौलथिन जेना ओ आगाँ जाय चाहैत होथि। ");
INSERT INTO mai_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","मुदा ओ सभ हुनका सँ बहुत आग्रह कयलनि जे, “देखू, साँझ पड़ऽ वला अछि, आब अन्‍हार होयत। हमरा सभक संग आइ रहि जाउ।” तखन यीशु हुनका सभक संग रहबाक लेल घरक भीतर गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","यीशु जखन हुनका सभक संग भोजन करबाक लेल बैसलाह तँ रोटी लेलनि, और परमेश्‍वर केँ धन्‍यवाद दऽ कऽ रोटी तोड़ि हुनका सभ केँ देबऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","तखन हुनका सभक नजरि खुलि गेलनि और ओ सभ हुनका चिन्‍हि लेलथिन। तकरबाद तुरत्ते यीशु बिला गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","तखन ओ सभ एक-दोसर केँ कहऽ लगलाह, “बाट मे चलैत काल ओ जखन अपना सभ सँ बात-चीत कयलनि आ धर्मशास्‍त्रक अर्थ बुझा देलनि, तँ अपना सभक हृदय आनन्‍द सँ केहन धक-धक करैत छल!” ");
INSERT INTO mai_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ओ सभ तुरत्ते उठि कऽ यरूशलेम घूमि गेलाह। ओतऽ हुनका सभ केँ एगारहो शिष्‍य और अन्‍य संगी-साथी सभ एक ठाम जमा भेल भेटलथिन। ");
INSERT INTO mai_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","शिष्‍य सभ कहि रहल छलाह जे, “सत्‍ये अछि! प्रभु जीबि उठल छथि! ओ सिमोन केँ दर्शन देलनि अछि।” ");
INSERT INTO mai_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","तखन इहो दूनू गोटे हुनका सभ केँ बाट मे भेल बात सभक विषय मे कहि सुनौलथिन, आ कहलथिन, “ओ जखन रोटी तोड़लनि तखन हम सभ हुनका चिन्‍हि लेलियनि।” ");
INSERT INTO mai_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ओ सभ ई बात सभ सुनबिते छलथिन कि यीशु स्‍वयं हुनका सभक बीच मे प्रगट भेलथिन और कहलथिन, “अहाँ सभ केँ शान्‍ति भेटय।” ");
INSERT INTO mai_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ओ सभ हुनका भूत बुझि अकचका कऽ भयभीत भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","यीशु कहलथिन, “अहाँ सभ किएक घबड़ायल छी? मोन मे शंका किएक उठैत अछि? ");
INSERT INTO mai_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","हमर हाथ-पयर देखू। हमहीं छी! हमरा छुबि कऽ देखू! भूत-प्रेत केँ तँ एना हाड़-माँसु सभ नहि होइत छैक जेना अहाँ सभ हमरा देखि रहल छी।” ");
INSERT INTO mai_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ई कहि ओ हुनका सभ केँ अपन हाथ-पयर देखौलथिन। ");
INSERT INTO mai_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","हुनका सभ केँ ततेक ने आनन्‍द भेलनि जे तखनो विश्‍वास नहि भेलनि, आश्‍चर्य मे डुबल छलाह। तेँ यीशु पुछलथिन, “की अहाँ सभ लग किछु खयबाक वस्‍तु अछि?” ");
INSERT INTO mai_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ओ सभ हुनका पकाओल माछक कुटिआ देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ओ लऽ कऽ हुनका सभक सामने खयलनि। ");
INSERT INTO mai_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","यीशु कहलथिन, “हम जखन अहाँ सभक संग छलहुँ तँ अहाँ सभ केँ ई कहने छलहुँ जे, मूसाक धर्म-नियम, प्रभुक प्रवक्‍ता सभक लेख और भजन-संग्रहक पुस्‍तक मे हमरा विषय मे जे किछु लिखल अछि, से सभ बात पूरा होयब आवश्‍यक अछि।” ");
INSERT INTO mai_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","तखन ओ हुनका सभ केँ धर्मशास्‍त्रक बात बुझबाक लेल बुद्धि देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ओ हुनका सभ केँ कहलथिन, “धर्मशास्‍त्र मे ई लिखल अछि जे, उद्धारकर्ता-मसीह दुःख उठौताह आ तेसर दिन मृत्‍यु सँ जीबि उठताह, ");
INSERT INTO mai_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","और यरूशलेम सँ शुरू कऽ पृथ्‍वीक सभ जातिक लोक मे हुनकर नाम सँ एहि बातक प्रचार कयल जायत जे, अपना पापक लेल पश्‍चात्ताप कऽ हृदय-परिवर्तन करू आ पापक क्षमा प्राप्‍त करू। ");
INSERT INTO mai_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","अहाँ सभ एहि बात सभक गवाह छी। ");
INSERT INTO mai_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","हमर पिता अहाँ सभ केँ जे किछु देबाक वचन देलनि, से हम अहाँ सभ केँ आब पठा देब। मुदा जा धरि अहाँ सभ केँ ऊपर सँ सामर्थ्‍य प्राप्‍त नहि होयत, ता धरि अहाँ सभ एहि शहर मे रूकल रहू।” ");
INSERT INTO mai_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","यीशु हुनका सभ केँ बेतनिया गाम दिस लऽ गेलथिन, और अपन हाथ उठा कऽ हुनका सभ केँ आशीर्वाद देलथिन। ");
INSERT INTO mai_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","आशीर्वाद दैत काल ओ हुनका सभ सँ अलग भऽ गेलाह, और स्‍वर्ग मे उठा लेल गेलाह। ");
INSERT INTO mai_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","शिष्‍य सभ हुनकर आराधना कयलनि और अत्‍यन्‍त आनन्‍दक संग यरूशलेम घूमि अयलाह। ");
INSERT INTO mai_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ओ सभ परमेश्‍वरक स्‍तुति-प्रशंसा करैत अपन सम्‍पूर्ण समय मन्‍दिर मे व्‍यतीत करऽ लगलाह।");
INSERT INTO mai_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","शुरू मे वचन रहथि। वचन परमेश्‍वरक संग छलाह, और अपने परमेश्‍वर छलाह। ");
INSERT INTO mai_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","तँ वैह शुरू मे परमेश्‍वरक संग छलाह। ");
INSERT INTO mai_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","वचने द्वारा सभ वस्‍तु उत्‍पन्‍न कयल गेल, और जे किछु उत्‍पन्‍न भेल ओहि मे सँ एकोटा वस्‍तु हुनका बिना उत्‍पन्‍न नहि भेल। ");
INSERT INTO mai_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","हुनका मे जीवन छल, और ई जीवन मनुष्‍यक लेल इजोत छल। ");
INSERT INTO mai_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","इजोत अन्‍हार मे प्रकाश दैत अछि, और अन्‍हार ओहि पर कहियो विजयी नहि भेल अछि। ");
INSERT INTO mai_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","परमेश्‍वर द्वारा पठाओल गेल एक आदमी अयलाह, जिनकर नाम यूहन्‍ना छलनि। ");
INSERT INTO mai_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ओ गवाहीक लेल अयलाह, ओहि इजोतक विषय मे गवाही देबाक लेल, जाहि सँ हुनका द्वारा सभ लोक विश्‍वास करय। ");
INSERT INTO mai_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ओ अपने ओ इजोत नहि छलाह, बल्‍कि ओहि इजोतक सम्‍बन्‍ध मे गवाही देबाक लेल आयल छलाह। ");
INSERT INTO mai_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ओ इजोत वास्‍तविक इजोत छलाह, जे प्रत्‍येक मनुष्‍य केँ प्रकाशित करैत छथि। और ओ इजोत संसार मे आबि रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ओ संसार मे छलाह, संसार हुनका द्वारा बनाओल गेल छल, तैयो संसार हुनका नहि चिन्‍हलकनि। ");
INSERT INTO mai_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ओ अपना ओहिठाम अयलाह, मुदा हुनकर अपन लोक हुनका स्‍वीकार नहि कयलकनि। ");
INSERT INTO mai_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","तैयो जे सभ हुनका स्‍वीकार कयलक, अर्थात् जे सभ हुनका पर विश्‍वास कयलक, तकरा सभ केँ ओ परमेश्‍वरक सन्‍तान बनबाक अधिकार देलथिन। ");
INSERT INTO mai_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ओ सभ ने मनुष्‍यक वंशज सँ जनमल, ने शारीरिक इच्‍छा सँ, और ने कोनो पुरुषक कल्‍पना सँ, बल्‍कि परमेश्‍वर द्वारा जनमल। ");
INSERT INTO mai_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","वचन मनुष्‍य बनि गेलाह, और कृपा आ सत्‍य सँ परिपूर्ण भऽ, हमरा सभक बीच मे निवास कयलनि। हम सभ हुनकर एहन महिमा देखलहुँ जेना पिताक एकलौता पुत्रक महिमा। ");
INSERT INTO mai_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","यूहन्‍ना हुनका विषय मे ई गवाही दऽ कऽ जोर सँ कहलनि, “यैह छथि जिनका बारे मे हम कहैत छलहुँ जे, ओ जे हमरा बाद अबैत छथि, से हमरा सँ श्रेष्‍ठ छथि, किएक तँ हमर जन्‍मो सँ पहिने ओ छलाह।” ");
INSERT INTO mai_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","हुनकर परिपूर्णता मे सँ हमरा सभ गोटे केँ कृपा भेटल अछि, हँ, आशिष पर आशिष। कारण, ");
INSERT INTO mai_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","धर्म-नियम मूसा द्वारा देल गेल, मुदा कृपा और सत्‍य यीशु मसीह द्वारा आयल। ");
INSERT INTO mai_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","परमेश्‍वर केँ केओ कहियो नहि देखने छनि। मुदा एकलौता पुत्र, जे अपने परमेश्‍वर छथि, और जे पिताक संगति मे रहैत छथि, वैह हुनका प्रगट कयने छथिन। ");
INSERT INTO mai_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","यूहन्‍नाक गवाही ई छनि। यरूशलेम शहर सँ यहूदी लोकनि पुरोहित आ मन्‍दिरक सेवक सभ केँ हुनका लग ई पुछबाक लेल पठा देलनि जे, “अहाँ के छी?” ");
INSERT INTO mai_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","तँ यूहन्‍ना अस्‍वीकार नहि कयलनि, ओ खुलि कऽ मानि लेलनि जे, “हम उद्धारकर्ता-मसीह नहि छी।” ");
INSERT INTO mai_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ओ सभ हुनका सँ पुछलथिन, “तँ की, अहाँ एलियाह छी?” ओ उत्तर देलथिन, “हम से नहि छी।” “की अहाँ परमेश्‍वरक ओ प्रवक्‍ता छी जे आबऽ वला छथि?” ओ जबाब देलथिन, “नहि।” ");
INSERT INTO mai_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","तखन ओ सभ हुनका फेर पुछलथिन, “तखन अहाँ छी के? कहू ने जाहि सँ हमरा सभ केँ जे पठौलनि तिनका सभ केँ किछु उत्तर दऽ सकबनि। अपना विषय मे अहाँ की कहैत छी?” ");
INSERT INTO mai_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ओ उत्तर देलथिन, “जहिना परमेश्‍वरक प्रवक्‍ता यशायाह कहलनि, हम ‘एक स्‍वर’ छी जे ‘निर्जन क्षेत्र मे जोर सँ आवाज दऽ रहल अछि जे, प्रभुक आगमनक लेल बाट सोझ बनाउ।’” ");
INSERT INTO mai_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","तखन फरिसी सभ द्वारा पठाओल गेल लोक सभ मे सँ किछु गोटे ");
INSERT INTO mai_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","हुनका सँ पुछलकनि, “अहाँ जँ उद्धारकर्ता-मसीह नहि छी, आ ने एलियाह आ ने ओ प्रवक्‍ता, तँ अहाँ बपतिस्‍मा किएक दैत छी?” ");
INSERT INTO mai_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","यूहन्‍ना हुनका सभ केँ उत्तर देलथिन, “हम पानि सँ बपतिस्‍मा दैत छी, मुदा अहाँ सभक बीच मे एक व्‍यक्‍ति ठाढ़ छथि जिनका अहाँ सभ नहि चिन्‍हैत छियनि। ");
INSERT INTO mai_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ओ वैह छथि जे हमरा बाद अबैत छथि, और हम हुनकर जुत्तो खोलऽ जोगरक नहि छी।” ");
INSERT INTO mai_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ई सभ बात यरदन नदीक ओहि पार बेतनिया गाम मे भेल, जाहिठाम यूहन्‍ना बपतिस्‍मा दैत रहथि। ");
INSERT INTO mai_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","दोसरे दिन यूहन्‍ना यीशु केँ अपना दिस अबैत देखि बजलाह, “देखू! ई परमेश्‍वरक बलि-भेँड़ा छथि जे संसारक पाप उठा कऽ लऽ जाइत छथि। ");
INSERT INTO mai_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ई वैह छथि जिनका विषय मे हम कहलहुँ जे, हमरा बाद मे एक व्‍यक्‍ति अबैत छथि जे हमरा सँ श्रेष्‍ठ छथि किएक तँ हमर जन्‍मो सँ पहिनहि ओ छलाह। ");
INSERT INTO mai_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","हमहूँ हुनका नहि चिन्‍हैत छलहुँ, मुदा हम पानि सँ बपतिस्‍मा दैत एहि लेल अयलहुँ जे ओ अपन इस्राएली लोक पर प्रगट होथि।” ");
INSERT INTO mai_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","यूहन्‍ना ई गवाही देलनि, “हम परमेश्‍वरक आत्‍मा केँ आकाश सँ परबा जकाँ उतरैत आ हुनका पर टिकैत देखलहुँ। ");
INSERT INTO mai_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","हम अपने तँ हुनका नहिए चिन्‍हितहुँ, मुदा जे हमरा पानि सँ बपतिस्‍मा देबऽ लेल पठौलनि, से हमरा कहने छलाह जे, ‘जिनका पर तोँ आत्‍मा केँ उतरैत और टिकैत देखबह, वैह छथि जे पवित्र आत्‍मा सँ बपतिस्‍मा देताह।’ ");
INSERT INTO mai_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","हम ई बात देखने छी और गवाही दैत छी जे ई परमेश्‍वरक पुत्र छथि।” ");
INSERT INTO mai_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","फेर दोसरे दिन यूहन्‍ना अपन शिष्‍य मे सँ दू गोटेक संग ओहिठाम ठाढ़ छलाह। ");
INSERT INTO mai_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","यीशु केँ ओहि दऽ कऽ जाइत देखि ओ कहलनि, “देखू! परमेश्‍वरक बलि-भेँड़ा!” ");
INSERT INTO mai_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ई बात सुनि दूनू शिष्‍य यीशुक पाछाँ लागि गेलनि। ");
INSERT INTO mai_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","यीशु घूमि कऽ हुनका सभ केँ पाछाँ अबैत देखि कहलथिन, “अहाँ सभ की चाहैत छी?” ओ सभ हुनका कहलथिन, “रब्‍बी,” (जकर अर्थ अछि “गुरुजी”), “अहाँ कतऽ ठहरल छी?” ");
INSERT INTO mai_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ओ हुनका सभ केँ उत्तर देलथिन, “चलू देखि लिअ।” तखन ओ सभ जा कऽ देखि लेलनि जे ओ कतऽ ठहरल छथि, आ ओहि दिन हुनका संग रहलाह। ओ समय लगभग चारि बजे साँझक छल। ");
INSERT INTO mai_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ई दूनू जे यूहन्‍नाक बात सुनि कऽ यीशुक पाछाँ भऽ चलल रहथि, ओहि मे सँ एक अन्‍द्रेयास छलाह, सिमोन पत्रुसक भाय। ");
INSERT INTO mai_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ओ तुरत अपन भाय सिमोन सँ भेँट कऽ हुनका कहलथिन, “हमरा सभ केँ उद्धारकर्ता-मसीह भेटलाह।” (⌞यूनानी भाषा मे⌟ “मसीह” केँ “ख्रिष्‍ट” कहल जाइत अछि।) ");
INSERT INTO mai_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ओ हुनका यीशु लग अनलथिन। यीशु हुनका ध्‍यानपूर्बक देखि कहलथिन, “अहाँ सिमोन, यूहन्‍नाक बालक छी। अहाँक नाम ‘कैफा’ होयत” (अर्थात् “पत्रुस”)। ");
INSERT INTO mai_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","दोसरे दिन यीशु गलील प्रदेश जयबाक निश्‍चय कयलनि। तखन हुनका फिलिपुस भेँट भेलनि। ओ हुनका कहलथिन, “हमरा पाछाँ आउ।” ");
INSERT INTO mai_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","अन्‍द्रेयास और पत्रुस जकाँ, फिलिपुस सेहो बेतसैदा नगरक निवासी छलाह। ");
INSERT INTO mai_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","फिलिपुस नथनेल सँ भेँट कऽ कऽ कहलथिन, “हमरा सभ केँ ओ भेटलाह जिनका विषय मे मूसा धर्म-नियम मे लिखने छथि आ जिनका विषय मे परमेश्‍वरक प्रवक्‍ता सभ सेहो लिखने छथि। ओ छथि यूसुफक बेटा, नासरतक निवासी यीशु।” ");
INSERT INTO mai_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“नासरत?” नथनेल बाजि उठलाह। “की नासरत सँ किछुओ नीक आबि सकैत छैक?” फिलिपुस हुनका कहलथिन, “चलि कऽ देखि लिअ।” ");
INSERT INTO mai_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","यीशु नथनेल केँ अपना लग अबैत देखि कहलथिन, “देखू! ई एक सही इस्राएली छथि, जिनका मे कोनो छल-प्रपंच नहि!” ");
INSERT INTO mai_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नथनेल हुनका कहलथिन, “अहाँ हमरा कोना चिन्‍हैत छी?” यीशु उत्तर देलथिन, “एहि सँ पहिनहि जे फिलिपुस अहाँ केँ बजौलनि, हम अहाँ केँ अंजीरक गाछ तर देखने छलहुँ।” ");
INSERT INTO mai_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","एहि पर नथनेल बजलाह, “गुरुजी! अहाँ परमेश्‍वरक पुत्र छी! अहाँ इस्राएलक राजा छी।” ");
INSERT INTO mai_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","यीशु हुनका कहलथिन, “की अहाँ एहि लेल ई बात विश्‍वास करैत छी जे हम अहाँ केँ कहलहुँ जे अंजीर गाछ तर अहाँ केँ देखने छलहुँ? अहाँ एहू सँ पैघ बात सभ देखब।” ");
INSERT INTO mai_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","तखन हुनका इहो कहलथिन, “हम अहाँ सभ केँ विश्‍वास दिअबैत छी जे अहाँ सभ स्‍वर्ग केँ खुजल आ परमेश्‍वरक स्‍वर्गदूत सभ केँ मनुष्‍य-पुत्र पर ऊपर चढ़ैत आ नीचाँ उतरैत देखब।” ");
INSERT INTO mai_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","एहि बातक तेसरे दिन गलील प्रदेशक काना नामक गाम मे विवाह छल। ओहिठाम यीशुक माय छलीह, ");
INSERT INTO mai_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","और यीशु आ हुनकर शिष्‍य सभ सेहो विवाह मे निमन्‍त्रित छलाह। ");
INSERT INTO mai_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","अंगूरक मदिरा घटला पर माय यीशु केँ कहलथिन, “हिनका सभ केँ आब मदिरा नहि छनि।” ");
INSERT INTO mai_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","यीशु हुनका कहलथिन, “अहाँ हमरा ई किएक कहैत छी? हमर समय एखन नहि आयल अछि।” ");
INSERT INTO mai_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","तखन हुनकर माय बारिक सभ केँ कहलनि, “ई जे किछु तोरा सभ केँ कहथुन से करिहह!” ");
INSERT INTO mai_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","लग मे यहूदी सभक रीतिक अनुसार शुद्ध करबाक लेल छओटा पाथरक घैल राखल छल। प्रत्‍येक मे करीब सौ-सवासौ लीटर अँटैत छल। ");
INSERT INTO mai_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","यीशु बारिक सभ केँ कहलथिन, “घैल सभ मे पानि भरि दहक।” ");
INSERT INTO mai_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ओ सभ घैल केँ कानो-कान भरि देलक। तखन ओकरा सभ केँ कहलथिन, “आब किछु निकालि कऽ भण्‍डारी केँ दऽ अबहुन।” ओ सभ दऽ आयल, ");
INSERT INTO mai_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","और भण्‍डारी ओहि पानि केँ चिखलनि जे आब मदिरा बनि गेल छल। हुनका नहि बुझल छलनि जे ई मदिरा कतऽ सँ आबि गेल (मुदा बारिक सभ जे पानि निकालने छल, तकरा सभ केँ बुझल छलैक), तेँ भण्‍डारी वर केँ बजा कऽ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“सभ आदमी तँ बढ़ियाँ वला मदिरा पहिनहि परसैत अछि, और बाद मे जखन लोक सभ बहुते पिबि लेने रहैत अछि तखने साधारण वला परसैत अछि, मुदा अहाँ बढ़ियाँ वला एखनो धरि रखनहि छलहुँ!” ");
INSERT INTO mai_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","एहि तरहेँ गलीलक काना गाम मे यीशु अपन चमत्‍कारपूर्ण चिन्‍ह सभ शुरू कऽ कऽ अपन महिमा प्रगट कयलनि और हुनकर शिष्‍य सभ हुनका पर विश्‍वास कयलनि। ");
INSERT INTO mai_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","एकरा बाद यीशु अपन माय, भाय और शिष्‍य सभक संग कफरनहूम नगर गेलाह और ओहिठाम किछु दिन रहलाह। ");
INSERT INTO mai_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहूदी सभक फसह-पाबनि लग अयला पर यीशु यरूशलेम चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","मन्‍दिर मे ओ लोक सभ केँ गाय-बड़द, भेँड़ा और परबा बेचैत और टेबुल पर बैसल पैसा भजबऽ वला सभ केँ पैसा भजबैत देखलनि। ");
INSERT INTO mai_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ई देखि यीशु रस्‍साक कोड़ा बना कऽ सभ केँ मन्‍दिर मे सँ बाहर भगा देलथिन, भेँड़ा और माल-जाल केँ सेहो। पाइ भजबऽ वला सभक सिक्‍का छिड़िया कऽ ओकरा सभक टेबुल उनटा देलथिन। ");
INSERT INTO mai_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","परबा बेचऽ वला सभ केँ ओ कहलथिन, “एहि सभ केँ एतऽ सँ तुरत लऽ जाह! हमर पिताक घर केँ बजार नहि बनाबह!” ");
INSERT INTO mai_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","तखन हुनकर शिष्‍य सभ केँ धर्मशास्‍त्रक ई लेख मोन पड़लनि जे, “हे परमेश्‍वर, अहाँक घरक लेल हमर धुनि हमरा खा जायत।” ");
INSERT INTO mai_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","तखन यहूदी सभ हुनका कहलथिन, “ई सभ करबाक अधिकारक प्रमाण देबाक लेल अहाँ हमरा सभ केँ कोन चिन्‍ह देखायब?” ");
INSERT INTO mai_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","यीशु उत्तर देलथिन, “एहि मन्‍दिर केँ ढाहि दिअ और हम एकरा तीन दिन मे फेर ठाढ़ कऽ देब।” ");
INSERT INTO mai_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","एहि पर यहूदी सभ जबाब देलथिन, “एहि मन्‍दिर केँ बनाबऽ मे हमरा सभ केँ छियालिस वर्ष लागल, और की अहाँ एकरा तीन दिन मे फेर ठाढ़ कऽ देब!” ");
INSERT INTO mai_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","मुदा यीशु जाहि मन्‍दिरक बारे मे बाजल छलाह, से हुनकर देह छलनि। ");
INSERT INTO mai_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","तेँ बाद मे जखन ओ मरलाक बाद जीबि उठलाह तँ शिष्‍य सभ हुनकर एहि कथन केँ स्‍मरण कयलनि। तखन ओ सभ धर्मशास्‍त्रक लेख केँ और यीशुक बात केँ विश्‍वास कयलनि। ");
INSERT INTO mai_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","जखन यीशु फसह-भोजक समय मे यरूशलेम मे छलाह, तँ बहुत लोक हुनकर चमत्‍कारपूर्ण चिन्‍ह सभ जे ओ देखबैत छलाह, तकरा देखि कऽ हुनका पर विश्‍वास कयलकनि, ");
INSERT INTO mai_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","मुदा यीशु अपना केँ ओकरा सभक भरोस पर नहि छोड़लनि, कारण सभ मनुष्‍य केँ ओ जनैत छलाह। ");
INSERT INTO mai_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","मनुष्‍यक बारे मे हुनका ककरो द्वारा कोनो साक्षीक आवश्‍यकता नहि छलनि, किएक तँ ओ अपने जनैत छलाह जे मनुष्‍यक मोन मे की बात होइत छैक। ");
INSERT INTO mai_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","फरिसी सभ मे सँ एक निकोदेमुस नामक आदमी छलाह, जे यहूदी सभक धर्मसभाक सदस्‍य छलाह। ");
INSERT INTO mai_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","एक राति ओ यीशु लग आबि कऽ कहलथिन, “गुरुजी, हम सभ जनैत छी जे अपने परमेश्‍वर द्वारा पठाओल गेल गुरु छी, कारण जँ परमेश्‍वर संग नहि रहितथि तँ अपने जे चमत्‍कारपूर्ण चिन्‍ह सभ देखा रहल छी, से केओ नहि देखा सकैत।” ");
INSERT INTO mai_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","यीशु हुनका उत्तर देलथिन, “हम अहाँ केँ सत्‍ये कहैत छी जे, जाबत तक केओ नव जन्‍म नहि लेत ताबत तक ओ परमेश्‍वरक राज्‍य नहि देखि सकत।” ");
INSERT INTO mai_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","निकोदेमुस हुनका कहलथिन, “केओ बूढ़ भऽ कऽ कोना जन्‍म लेत? की ओ मायक गर्भ मे दोसर बेर प्रवेश कऽ फेर जन्‍म लऽ सकत?!” ");
INSERT INTO mai_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","यीशु उत्तर देलथिन, “हम अहाँ केँ विश्‍वास दिअबैत छी जे, जाबत तक केओ जल और आत्‍मा सँ जन्‍म नहि लेत ताबत तक ओ परमेश्‍वरक राज्‍य मे प्रवेश नहि कऽ सकत। ");
INSERT INTO mai_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","मनुष्‍य तँ खाली शारीरिक जन्‍म दैत अछि, मुदा पवित्र आत्‍मा आत्‍मिक जन्‍म दैत छथि। ");
INSERT INTO mai_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","तेँ एहि सँ आश्‍चर्य नहि मानू जे हम अहाँ केँ कहलहुँ जे अहाँ सभ केँ नव जन्‍म लेबऽ पड़त। ");
INSERT INTO mai_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","हवा जतऽ चाहैत अछि ततऽ बहैत अछि। ओकर आवाज सुनैत छी लेकिन कतऽ सँ आबि रहल अछि वा कतऽ जा रहल अछि से नहि जानि सकैत छी। जे आत्‍मा सँ जन्‍म लैत अछि, तकरो एहिना होइत छैक।” ");
INSERT INTO mai_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","निकोदेमुस हुनका कहलथिन, “ई सभ बात कोना भऽ सकैत अछि?” ");
INSERT INTO mai_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","यीशु उत्तर देलथिन, “अहाँ इस्राएलक गुरु छी, आ ई बात नहि बुझैत छी?! ");
INSERT INTO mai_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","हम अहाँ केँ सत्‍ये कहैत छी जे, जे बात हम जनैत छी, वैह बात बजैत छी, मुदा तैयो अहाँ सभ हमरा गवाही केँ स्‍वीकार नहि करैत छी। ");
INSERT INTO mai_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","जखन हम अहाँ केँ पृथ्‍वी परक बात कहैत छी और अहाँ विश्‍वास नहि करैत छी, तँ स्‍वर्गक बात जँ कहब तँ अहाँ केँ कोना विश्‍वास होयत? ");
INSERT INTO mai_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","केओ स्‍वर्ग मे उपर नहि चढ़ल अछि; वैहटा चढ़ल छथि जे स्‍वर्ग सँ उतरल छथि, अर्थात् मनुष्‍य-पुत्र। ");
INSERT INTO mai_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","जहिना मूसा निर्जन क्षेत्र मे पित्तरिक साँप केँ ऊपर लटका देलनि, तहिना मनुष्‍य-पुत्र केँ सेहो अवश्‍य ऊपर लटकाओल जयतनि ");
INSERT INTO mai_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","जाहि सँ जे केओ हुनका पर विश्‍वास करत से अनन्‍त जीवन प्राप्‍त करत। ");
INSERT INTO mai_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“हँ, परमेश्‍वर संसार सँ एहन प्रेम कयलनि जे ओ अपन एकमात्र बेटा केँ दऽ देलनि, जाहि सँ जे केओ हुनका पर विश्‍वास करैत अछि से नाश नहि होअय, बल्‍कि अनन्‍त जीवन पाबय। ");
INSERT INTO mai_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","परमेश्‍वर तँ अपना बेटा केँ संसार मे एहि लेल नहि पठौलनि जे ओ संसार केँ दोषी ठहरबथि, बल्‍कि एहि लेल जे हुनका द्वारा संसारक उद्धार होअय। ");
INSERT INTO mai_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","जे व्‍यक्‍ति हुनका पर विश्‍वास करैत अछि से दोषी नहि ठहराओल जाइत अछि, मुदा जे व्‍यक्‍ति हुनका पर विश्‍वास नहि करैत अछि, से दोषी ठहराओल जा चुकल अछि, किएक तँ ओ परमेश्‍वरक एकलौता बेटा पर विश्‍वास नहि कयने अछि। ");
INSERT INTO mai_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","दोष एहि मे भेल, जे संसार मे इजोत आबि गेल और लोक केँ इजोतक बदला अन्‍हारे नीक लगलैक, कारण ओकर काज अधलाहे होइत छलैक। ");
INSERT INTO mai_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","जे अधलाह काज करैत अछि से इजोत सँ घृणा करैत अछि और इजोत लग नहि अबैत अछि जाहि सँ ओकर काज कतौ प्रगट नहि भऽ जाइक। ");
INSERT INTO mai_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","मुदा जे सत्‍य पर चलैत अछि से इजोत लग अबैत अछि जाहि सँ ई प्रगट भऽ जाय जे ओ जे किछु कयने अछि से परमेश्‍वरक इच्‍छाक अनुसार कयने अछि।” ");
INSERT INTO mai_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","एकरबाद यीशु अपन शिष्‍य सभक संग यहूदियाक देहात जा कऽ हुनका सभक संग रहलाह और लोक केँ बपतिस्‍मा देबऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","यूहन्‍ना सेहो शालीम लग एनोन गाम मे बपतिस्‍मा दैत छलाह, कारण ओतऽ पानि बहुत छल, और लोक सभ हुनका लग आबि कऽ बपतिस्‍मा लैत छल। ");
INSERT INTO mai_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(ओहि समय मे यूहन्‍ना जहल मे नहि राखल गेल छलाह।) ");
INSERT INTO mai_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","तँ यूहन्‍नाक शिष्‍य कोनो एकटा यहूदीक संग शुद्ध करबाक रीतिक विषय मे वाद-विवाद करऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ओ सभ यूहन्‍ना लग आबि कऽ कहलनि, “गुरुजी, ओ जे यरदन नदीक ओहि पार अहाँक संग छलाह, जिनका बारे मे अहाँ गवाही देलहुँ, से आब बपतिस्‍मा दऽ रहल छथि और सभ लोक हुनके लग जा रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","एहि पर यूहन्‍ना उत्तर देलथिन, “मनुष्‍य किछुओ प्राप्‍त नहि कऽ सकैत जँ परमेश्‍वर सँ नहि देल जाइत। ");
INSERT INTO mai_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","अहाँ सभ अपने हमर गवाह छी जे हम कहलहुँ जे, उद्धारकर्ता-मसीह हम नहि छी, बल्‍कि हम हुनका सँ आगाँ पठाओल गेल छी। ");
INSERT INTO mai_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","कनियाँ वरे केँ छनि। वरक मित्र, जे वरक प्रतीक्षा मे ठाढ़ भऽ कऽ सुनैत अछि, से वरक आवाज सुनि बड्ड आनन्‍दित होइत अछि। तेँ हमर ई आनन्‍द आब पूर्ण भऽ गेल अछि। ");
INSERT INTO mai_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ई जरूरी अछि जे ओ बढ़ैत रहथि आ हम घटैत रही। ");
INSERT INTO mai_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“जे ऊपर सँ आयल छथि से आओर सभ सँ पैघ छथि। जे पृथ्‍वी सँ अछि से पृथ्‍विएक अछि और खाली पृथ्‍वी वला बात सभ कहैत अछि। जे स्‍वर्ग सँ अबैत छथि वैह आओर सभ सँ पैघ छथि, ");
INSERT INTO mai_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","और जे बात ओ देखने छथि और सुनने छथि, तकरे गवाही दैत छथि। मुदा केओ हुनका गवाही केँ स्‍वीकार नहि करैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","जे व्‍यक्‍ति हुनका गवाही केँ स्‍वीकार कयने अछि, से एहि बात पर अपन छाप लगा देने अछि जे परमेश्‍वर सत्‍य छथि, ");
INSERT INTO mai_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","कारण जिनका परमेश्‍वर पठौने छथिन, से वैह बात कहैत छथि जे परमेश्‍वर कहैत छथि। हुनका परमेश्‍वर अपन आत्‍मा, बिना नापि-जोखि कऽ दैत छथिन। ");
INSERT INTO mai_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","पिता पुत्र सँ प्रेम करैत छथि और हुनके हाथ मे सभ किछु दऽ देने छथिन। ");
INSERT INTO mai_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","जे पुत्र पर विश्‍वास करैत अछि, तकरा अनन्‍त जीवन छैक। जे पुत्र केँ नहि मानैत अछि, से ओहि जीवन केँ नहि देखत—ओकरा पर परमेश्‍वरक क्रोध रहैत अछि।” ");
INSERT INTO mai_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","जखन प्रभु केँ पता लगलनि जे फरिसी सभ सुनलनि अछि जे यीशु यूहन्‍ना सँ बेसी शिष्‍य केँ बनबैत छथि और बपतिस्‍मा दैत छथि ");
INSERT INTO mai_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(ओना तँ यीशु अपने नहि, बल्‍कि हुनकर शिष्‍य सभ बपतिस्‍मा दैत छलाह), ");
INSERT INTO mai_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","तखन ओ यहूदिया प्रदेश छोड़ि कऽ फेर गलील प्रदेशक लेल विदा भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","रस्‍ता मे हुनका सामरिया प्रदेश भऽ कऽ जाय पड़लनि। ");
INSERT INTO mai_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ओ सामरिया मे सुखार नगर पहुँचलाह। ई नगर ओहि खेत लग अछि जे याकूब अपना बेटा यूसुफ केँ देने छलाह। ");
INSERT INTO mai_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ओतऽ याकूबक इनार छल, और यीशु यात्रा सँ थाकि कऽ इनार पर बैसि रहलाह। ई दुपहरियाक समय छल। ");
INSERT INTO mai_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ताबते मे एक सामरी स्‍त्री पानि भरऽ आयल। यीशु ओकरा कहलथिन, “हमरा पानि पिबऽ लेल दैह।” ");
INSERT INTO mai_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","हुनकर शिष्‍य सभ भोजनक सामान किनबाक लेल नगर मे गेल छलाह। ");
INSERT INTO mai_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","सामरी स्‍त्री कहलकनि, “अपने यहूदी भऽ कऽ हमरा सामरी स्‍त्री सँ कोना पानि मँगैत छी?” (कारण, यहूदी सभ सामरी लोक सँ कोनो सम्‍पर्क नहि रखैत अछि।) ");
INSERT INTO mai_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","यीशु उत्तर देलथिन, “जँ तोँ परमेश्‍वरक वरदान केँ जनितह, और ई जनितह जे ओ के छथि जे तोरा कहैत छथुन जे पिबऽ लेल दैह, तँ तोँही हुनके सँ मँगितह और ओ तोरा जीवनक जल दितथुन।” ");
INSERT INTO mai_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","स्‍त्री बाजल, “मालिक, पानि भरऽ लेल अपने केँ डोलो तक नहि अछि, और इनार गहींर अछि। ई जीवनक जल अपने लग आओत कतऽ सँ? ");
INSERT INTO mai_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","की अपने हमरा सभक पुरखा याकूब सँ पैघ छी? ओ तँ हमरा सभ केँ ई इनार प्रदान कयलनि, जाहि मे सँ ओ अपने और हुनकर बालक सभ पिलनि और माल-जाल सभ सेहो पिलक।” ");
INSERT INTO mai_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","यीशु बजलाह, “जे ई पानि पीत, तकरा फेर पियास लगतैक, ");
INSERT INTO mai_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","मुदा जे ओ जल पीत जे हम देबैक, तकरा कहियो फेर पियास नहि लगतैक। कारण, हम ओकरा पिबाक लेल जे जल देबैक, से ओकरा मे सदिखन उमड़ैत रहतैक और अनन्‍त जीवन तक बहतैक।” ");
INSERT INTO mai_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","स्‍त्री कहलकनि, “यौ मालिक! हमरा ई जल दिअ जाहि सँ हमरा कहियो नहि पियास लागय और एहिठाम पानि भरऽ नहि आबऽ पड़य।” ");
INSERT INTO mai_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ओ कहलथिन, “जा कऽ अपना घरवला केँ बजा लबहुन।” ");
INSERT INTO mai_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","स्‍त्री हुनका जबाब देलकनि, “हमरा घरवला नहि अछि।” यीशु ओकरा कहलथिन, “तोँ ठीके कहैत छह जे हमरा घरवला नहि अछि, ");
INSERT INTO mai_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","कारण तोरा पाँचटा घरवला भेल छलह, और जे तोरा लग एखन छह, सेहो तोहर घरवला नहि छह। ई बात तोँ एकदम सत्‍य कहलह।” ");
INSERT INTO mai_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","स्‍त्री बाजल, “मालिक, हम बुझि गेलहुँ जे अपने परमेश्‍वरक एक प्रवक्‍ता छी! आब कहू। ");
INSERT INTO mai_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","हमरा सभक पुरखा एहि पहाड़ पर आराधना कयलनि, लेकिन अपने यहूदी सभ कहैत छी जे आराधना करबाक स्‍थान मात्र यरूशलेम अछि।” ");
INSERT INTO mai_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","यीशु ओकरा कहलथिन, “हमर विश्‍वास करह। ओ समय आओत जहिया तोँ सभ ने एहि पहाड़ पर पिताक आराधना करबह, ने यरूशलेम मे। ");
INSERT INTO mai_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","तोँ सामरी लोक तकर आराधना करैत छह जकरा जनिते नहि छह। हम सभ जे यहूदी सभ छी तिनकर आराधना करैत छी जिनका जनैत छी, कारण उद्धार यहूदी वंश द्वारा अबैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","मुदा ओ समय आबि रहल अछि, हँ, आबिओ गेल, जे सत्‍य आराधक पिताक आराधना आत्‍मा और सत्‍य सँ करतनि, किएक तँ पिता एहने आराधक चाहैत छथि। ");
INSERT INTO mai_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","परमेश्‍वर आत्‍मा छथि, और ई आवश्‍यक अछि जे हुनकर आराधक आत्‍मा आओर सत्‍य सँ हुनकर आराधना करनि।” ");
INSERT INTO mai_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","स्‍त्री कहलकनि, “हम जनैत छी जे मसीह, जे ख्रिष्‍ट कहबैत छथि, से आबऽ वला छथि। ओ जखन औताह तखन हमरा सभ केँ सभ बात बुझा देताह।” ");
INSERT INTO mai_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","यीशु ओकरा कहलथिन, “हम, जे तोरा सँ बात कऽ रहल छिअह, वैह छी।” ");
INSERT INTO mai_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ओहि क्षण हुनकर शिष्‍य सभ घूमि अयलाह। हुनका सभ केँ बहुत आश्‍चर्य भेलनि जे यीशु एक स्‍त्री सँ बात कऽ रहल छथि, मुदा केओ नहि पुछलथिन जे, अहाँ की चाहैत छी, वा ओकरा सँ किएक बात कऽ रहल छी? ");
INSERT INTO mai_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","तखन स्‍त्री अपन घैल छोड़ि नगर मे जा कऽ लोक सभ केँ कहऽ लागल जे, ");
INSERT INTO mai_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“आउ, एक आदमी केँ देखू! जे किछु हम कहियो कयने छी, से सभ बात ओ हमरा कहलनि। की ई उद्धारकर्ता-मसीह तँ नहि छथि?” ");
INSERT INTO mai_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","लोक सभ नगर सँ बहरायल और यीशु लग आबऽ लागल। ");
INSERT INTO mai_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","एहि बीच मे शिष्‍य सभ यीशु केँ आग्रह कयलथिन जे, “गुरुजी, किछु खा लिअ।” ");
INSERT INTO mai_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","मुदा ओ हुनका सभ केँ कहलथिन, “हमरा लग एहन भोजन अछि जकरा बारे मे अहाँ सभ नहि किछु जनैत छी।” ");
INSERT INTO mai_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","शिष्‍य सभ एक-दोसर केँ कहऽ लगलाह, “केओ हिनका लेल भोजन तँ नहि आनि देने छनि?” ");
INSERT INTO mai_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","यीशु हुनका सभ केँ कहलथिन, “हमर भोजन ई अछि जे हम अपन पठाबऽ वलाक इच्‍छाक अनुसार चली और जे काज हमरा देने छथि तकरा पूरा करी। ");
INSERT INTO mai_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","की अहाँ सभ नहि कहैत छी जे, एखन चारि मास बाँकी अछि तखन फसिलक कटनी करबाक समय आओत? लेकिन हम कहैत छी जे आँखि खोलि कऽ खेत दिस देखू! फसिल एखनो कटनीक लेल पाकि गेल अछि! ");
INSERT INTO mai_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","एखनो काटऽ वला केँ बोनि भेटैत छैक, एखनो ओ फसिल काटि कऽ अनन्‍त जीवनक लेल लबैत अछि, जाहि सँ बाउग करऽ वला और काटऽ वला दूनू एक संग खुशी मनाओत। ");
INSERT INTO mai_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","एहि प्रकारेँ ओ कहबी सिद्ध होइत अछि जे बाउग करत केओ और काटत केओ। ");
INSERT INTO mai_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","हम अहाँ सभ केँ ओकरा काटऽ लेल पठौलहुँ जकरा लेल अहाँ सभ परिश्रम नहि कयने छलहुँ। परिश्रम कयलक दोसर, और अहाँ सभ ओकर परिश्रमक फल मे सहभागी भेलहुँ।” ");
INSERT INTO mai_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ओहि नगरक बहुत सामरी लोक ओहि स्‍त्रीक ई गवाही जे, जे किछु हम कहियो कयने छी से सभ बात ओ हमरा कहलनि, से सुनि यीशु पर विश्‍वास कयलक। ");
INSERT INTO mai_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","तेँ ओ सभ यीशु लग पहुँचि कऽ आग्रह कयलकनि जे, अपने हमरा सभक संग रहल जाओ। और यीशु ओतऽ दू दिन रहलाह। ");
INSERT INTO mai_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","हुनकर बात सुनि आओर बहुत लोक हुनका पर विश्‍वास कयलक। ");
INSERT INTO mai_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ओ सभ ओहि स्‍त्री केँ कहलक, “आब तोरे कहबाक कारणेँ विश्‍वास नहि करैत छी, बल्‍कि हम सभ अपने कान सँ हुनकर बात सुनने छी और जनैत छी जे ई वास्‍तव मे संसारक उद्धारकर्ता छथि।” ");
INSERT INTO mai_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ओहिठाम दू दिन रहलाक बाद यीशु गलीलक लेल विदा भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(यीशु अपने गवाही देने छलाह जे परमेश्‍वरक प्रवक्‍ता केँ अपना क्षेत्र मे आदर नहि होइत छनि।) ");
INSERT INTO mai_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ओ जखन गलील प्रदेश पहुँचलाह तँ गलील निवासी सभ हुनका स्‍वागत कयलकनि, किएक तँ ओ सभ हुनकर सभ काज जे ओ यरूशलेम मे फसह-भोजक अवसर पर कयने रहथि, से देखने छल, कारण ओहो सभ पाबनिक लेल गेल छल। ");
INSERT INTO mai_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","तँ यीशु फेर गलीलक काना गाम मे अयलाह, जाहिठाम ओ पानि केँ अंगूरक मदिरा बना देने रहथि। कफरनहूम नगर मे राजाक एक हाकिम छलाह जिनकर बालक अस्‍वस्‍थ छलनि। ");
INSERT INTO mai_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ओ ई खबरि सुनि जे यीशु यहूदिया प्रदेश सँ गलील मे पहुँचि गेल छथि, तँ जा कऽ हुनका सँ निवेदन कयलथिन जे, “चलि कऽ हमरा बेटा केँ नीक कऽ दिअ।” कारण ओ मरऽ पर छल। ");
INSERT INTO mai_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","यीशु हुनका कहलथिन, “अहाँ सभ जाबत तक चिन्‍ह और चमत्‍कार नहि देखब ताबत विश्‍वास कहियो नहि करब।” ");
INSERT INTO mai_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","हाकिम हुनका कहलथिन, “यौ सरकार, एखन चलू। नहि तँ हमर बौआ मरि जायत।” ");
INSERT INTO mai_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","यीशु उत्तर देलथिन, “जाउ अहाँ, अहाँक बेटा बाँचि गेल।” ओ आदमी यीशुक कथन पर विश्‍वास कयलनि और चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ओ रस्‍ते मे छलाह कि हुनकर नोकर सभ भेँट कऽ हुनका कहलकनि, “अपनेक बच्‍चा ठीक भऽ गेल अछि!” ");
INSERT INTO mai_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ओ ओकरा सभ सँ पुछलथिन जे कतेक बजे सँ बच्‍चा ठीक होमऽ लागल, तँ ओ सभ कहलकनि, “काल्‍हिखन लगभग एक बजे दिन मे ओकर बोखार उतरि गेल।” ");
INSERT INTO mai_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","तखन ओ बुझलनि जे ठीक ओही घड़ी यीशु हुनका कहने छलथिन जे, अहाँक बेटा बाँचि गेल। और ओ अपन पूरा परिवार यीशु पर विश्‍वास कयलनि। ");
INSERT INTO mai_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ई आब दोसर चमत्‍कारपूर्ण चिन्‍ह छल जे यीशु यहूदिया प्रदेश सँ गलील प्रदेश मे आबि कऽ देखौलनि। ");
INSERT INTO mai_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","बाद मे यहूदी सभक एक पाबनिक अवसर पर यीशु फेर यरूशलेम गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरूशलेम मे, भेँड़-द्वारि लग एक कुण्‍ड अछि जे इब्रानी भाषा मे बेतहसदा कहबैत अछि, जकरा चारू कात पाँचटा असोरा छैक। ");
INSERT INTO mai_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","एहि असोरा सभ पर बहुत रोगी पड़ल रहैत छल—आन्‍हर, नाङड़ आ लकवा मारल लोक सभ। ई सभ पानिक हिलबाक समयक प्रतीक्षा मे रहैत छल, ");
INSERT INTO mai_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","कारण समय-समय पर परमेश्‍वरक एक स्‍वर्गदूत उतरि कऽ पानि केँ हिला दैत छलाह, और एहि हिलयनाइक बाद, जे रोगी सभ सँ पहिने पानि मे पैसैत छल से अपन रोग सँ मुक्‍त भऽ जाइत छल, चाहे जे कोनो रोग होइक। ");
INSERT INTO mai_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","एक आदमी ओतऽ छल जे अड़तीस वर्ष सँ रोग सँ पीड़ित छल। ");
INSERT INTO mai_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","यीशु जखन ओकरा देखलथिन, ई बुझि कऽ जे ओ बहुत दिन सँ ओना पड़ल अछि, तँ ओकरा कहलथिन, “की तोँ स्‍वस्‍थ होमऽ चाहैत छह?” ");
INSERT INTO mai_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ओ रोगी हुनका उत्तर देलकनि, “मालिक, पानिक हिलला पर कुण्‍ड मे उतारऽ वला हमरा केओ नहि अछि। हम उतरबाक कोशिशे करैत छी, ततबे मे हमरा सँ पहिने केओ दोसर उतरि जाइत अछि।” ");
INSERT INTO mai_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","तखन यीशु ओकरा कहलथिन, “उठह! अपन पटिया उठा लैह, और चलह-फिरह!” ");
INSERT INTO mai_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ओ आदमी तुरत स्‍वस्‍थ भऽ गेल और अपन पटिया उठा कऽ चलऽ-फिरऽ लागल। जाहि दिन ई बात भेलैक, से विश्राम-दिन छल। ");
INSERT INTO mai_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","तेँ यहूदी सभ ओहि स्‍वस्‍थ कयल गेल आदमी केँ कहऽ लगलाह, “आइ तँ विश्राम-दिन अछि। पटिया उठौनाइ मना छौ!” ");
INSERT INTO mai_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","मुदा ओ उत्तर देलकनि, “जे आदमी हमरा स्‍वस्‍थ कऽ देलनि, वैह हमरा कहलनि जे पटिया उठा कऽ चलह-फिरह।” ");
INSERT INTO mai_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ओ सभ ओकरा पुछलथिन, “ओ के अछि जे तोरा कहलकौ जे उठा कऽ चलह-फिरह?” ");
INSERT INTO mai_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ओ स्‍वस्‍थ भेल आदमी ई नहि जनैत छल जे ओ के छलाह, कारण यीशु ओहिठाम सँ भीड़ मे चल गेल छलाह। ");
INSERT INTO mai_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","किछु कालक बाद यीशु ओहि आदमी केँ मन्‍दिर मे भेँट कऽ कऽ कहलथिन, “देखह, तोँ स्‍वस्‍थ भऽ गेल छह, आब पाप केँ छोड़ह, नहि तँ एहू सँ भारी दशा मे पड़ि जयबह।” ");
INSERT INTO mai_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ओ आदमी जा कऽ यहूदी सभ केँ कहि देलकनि जे, यीशुए छथि जे हमरा स्‍वस्‍थ कयलनि। ");
INSERT INTO mai_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","यीशु केँ विश्राम-दिन मे एहन काज करबाक कारणेँ यहूदी सभ हुनका सताबऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","मुदा ताहि पर यीशु ओकरा सभ केँ ई उत्तर देलथिन, “हमर पिता एखनो तक काज करैत रहैत छथि, और हमहूँ काज करैत रहैत छी।” ");
INSERT INTO mai_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","एहि कारणेँ यहूदी सभ हुनका मारि देबाक आओर कोशिश करऽ लगलाह किएक तँ ओ खाली विश्रामेक दिनक नियम केँ उल्‍लंघन नहि करैत छलाह, बल्‍कि ओ परमेश्‍वर केँ अपन पिता कहि कऽ अपना केँ परमेश्‍वरक समतूल सेहो ठहरबैत छलाह। ");
INSERT INTO mai_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","यीशु हुनका सभ केँ ई उत्तर देलथिन, “हम अहाँ सभ केँ सत्‍ये कहैत छी जे, पुत्र स्‍वतन्‍त्र रूप सँ किछु नहि कऽ सकैत छथि। ओ मात्र वैह करैत छथि जे ओ अपन पिता केँ करैत देखैत छथि, किएक तँ जहिना पिता करैत छथि ठीक ओहिना पुत्रो करैत छथि, ");
INSERT INTO mai_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","कारण पिता पुत्र सँ प्रेम करैत छथिन और पिता जे किछु करैत छथि से सभ हुनका देखा दैत छथिन, और एहू सँ पैघ काज हुनका देखा देथिन, जाहि सँ अहाँ सभ केँ आश्‍चर्य होयत। ");
INSERT INTO mai_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","कारण जहिना पिता मुरदा केँ उठा कऽ ओकरा जीवन दैत छथि, तहिना पुत्रो जकरा चाहैत छथि तकरा जीवन दैत छथि। ");
INSERT INTO mai_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","और पिता ककरो न्‍याय करऽ वला नहि छथि। ओ न्‍याय करबाक सभ अधिकार सेहो पुत्रे केँ देने छथिन, ");
INSERT INTO mai_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","जाहि सँ सभ लोक जेना पिताक आदर करैत छनि तेना पुत्रोक आदर करनि। जे पुत्रक आदर नहि करैत अछि, से पिताक सेहो नहि करैत छनि, जे हुनका पठौने छथिन। ");
INSERT INTO mai_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“हम अहाँ सभ केँ सत्‍ये कहैत छी जे, जे हमर बात सुनैत अछि और हमरा पठाबऽ वला केँ मानैत अछि तकरा अनन्‍त जीवन छैक। ओकरा न्‍यायक सामना नहि करऽ पड़तैक, कारण ओ एखने मृत्‍यु केँ पार भऽ कऽ जीवन मे प्रवेश कऽ लेने अछि। ");
INSERT INTO mai_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","हम अहाँ सभ केँ विश्‍वास दिअबैत छी जे ओ समय आबि रहल अछि, हँ, आबिओ गेल जखन मुइल सभ परमेश्‍वरक पुत्रक आवाज सुनत, और जे सभ सुनत से सभ जीअत, ");
INSERT INTO mai_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","किएक तँ जहिना पिता अपने जीवनक स्रोत छथि तहिना ओ पुत्रो केँ स्‍वयं जीवनक स्रोत होयबाक अधिकार देने छथिन। ");
INSERT INTO mai_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","और ओ पुत्र केँ मनुष्‍य-पुत्र होयबाक कारणेँ न्‍याय करबाक अधिकार सेहो देने छथिन। ");
INSERT INTO mai_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","एहि बात सँ आश्‍चर्यित नहि होउ! कारण, ओ समय आबि रहल अछि जहिया मरलाहा लोक सभ अपन कबर मे सँ हुनकर आवाज सुनि कऽ ");
INSERT INTO mai_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","बाहर निकलि आओत। जे नीक कयने अछि से जीवनक लेल उठत, और जे अधलाह कयने अछि से दण्‍ड पयबाक लेल उठत। ");
INSERT INTO mai_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","हम अपने सँ किछु नहि कऽ सकैत छी। हमरा जहिना न्‍याय करबाक लेल कहल जाइत अछि तहिना हम न्‍याय करैत छी। और हमर न्‍याय उचित होइत अछि, कारण हमर उद्देश्‍य ई अछि जे हम अपन नहि, बल्‍कि हमरा जे पठौलनि, तिनकर इच्‍छा पूरा करियनि। ");
INSERT INTO mai_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“जँ हम अपना बारे मे स्‍वयं गवाही देब तँ हमर गवाही पकिया नहि मानल जायत। ");
INSERT INTO mai_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","मुदा एक गोटे आओर छथि जे हमरा बारे मे गवाही दैत छथि, और हम जनैत छी जे ओ जे गवाही दैत छथि से एकदम सत्‍य अछि। ");
INSERT INTO mai_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“अहाँ सभ अपने यूहन्‍ना केँ पुछबौलहुँ, और ओ सत्‍यक गवाही देलनि। ");
INSERT INTO mai_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ई बात नहि अछि जे हम मनुष्‍यक गवाही पर निर्भर रहैत छी, मुदा हम एकर चर्चा एहि लेल करैत छी जे अहाँ सभक उद्धार होअय। ");
INSERT INTO mai_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","यूहन्‍ना तँ एक जरैत दीप छलाह जे इजोत दैत छलाह, और हुनकर इजोत मे आनन्‍द लेनाइ अहाँ सभ केँ किछु काल धरि नीक लागल। ");
INSERT INTO mai_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","मुदा हमरा एकटा गवाही अछि जे यूहन्‍नोक गवाही सँ पैघ अछि, किएक तँ जे काज हमर पिता हमरा पूर्ण करबाक लेल देने छथि, तथा जे काज हम कऽ सेहो रहल छी, से हमरा बारे मे गवाही दैत अछि जे पिता हमरा पठौने छथि। ");
INSERT INTO mai_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","और पिता, जे हमरा पठौलनि, से अपने हमरा बारे मे गवाही देने छथि। अहाँ सभ हुनकर आवाज कहियो नहि सुनने छी, आ ने हुनकर स्‍वरूप कहियो देखने छी, ");
INSERT INTO mai_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","और ने हुनकर वचन केँ अपना मोन मे रहऽ दैत छी। कारण, जिनका ओ पठौने छथि तिनकर अहाँ सभ विश्‍वास नहि करैत छी। ");
INSERT INTO mai_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","अहाँ सभ धर्मशास्‍त्रक अध्‍ययन करैत छी किएक तँ अहाँ सभ मानैत छी जे ओहि सँ अहाँ सभ केँ अनन्‍त जीवन भेटैत अछि। वैह शास्‍त्र हमरा बारे मे गवाही दैत अछि, ");
INSERT INTO mai_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","और तैयो जीवन प्राप्‍त करबाक लेल अहाँ सभ हमरा लग नहि आबऽ चाहैत छी। ");
INSERT INTO mai_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“हमरा मनुष्‍यक प्रशंसा सँ कोनो मतलब नहि। ");
INSERT INTO mai_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","मुदा अहाँ सभ केँ हम जनैत छी। हम जनैत छी जे अहाँ सभक हृदय मे परमेश्‍वरक प्रेम नहि अछि। ");
INSERT INTO mai_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","हम अपन पिताक नाम पर आयल छी, तैयो हमरा स्‍वीकार नहि करैत छी। मुदा जँ कोनो दोसर व्‍यक्‍ति अपना नाम पर अबैत अछि तँ ओकरा अहाँ सभ स्‍वीकार करैत छिऐक। ");
INSERT INTO mai_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","तँ अहाँ सभ विश्‍वास कोना कऽ सकब जखन कि एक-दोसर सँ प्रशंसा चाहैत छी लेकिन जे प्रशंसा एकमात्र परमेश्‍वर सँ प्राप्‍त होइत अछि से चाहिते नहि छी? ");
INSERT INTO mai_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“मुदा ई नहि सोचू जे हम पिताक समक्ष अहाँ सभ पर दोष लगायब। अहाँ सभ केँ दोष लगाबऽ वला मूसा छथि, जिनका पर अहाँ सभ समस्‍त आशा रखने छी। ");
INSERT INTO mai_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","जँ मूसाक विश्‍वास करितहुँ तँ हमरो विश्‍वास करितहुँ, कारण ओ हमरे बारे मे लिखने छथि। ");
INSERT INTO mai_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","मुदा हुनकर लेख पर जँ विश्‍वास नहि करैत छी तँ हमर कथन पर कोना विश्‍वास करब?” ");
INSERT INTO mai_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","एकरा बाद यीशु गलील झील, अर्थात् तिबिरियास झीलक ओहि पार गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","बड़का भीड़ यीशुक चमत्‍कारपूर्ण चिन्‍ह जे ओ रोगी सभ पर देखबैत छलाह, ताहि सँ प्रभावित भऽ हुनका पाछाँ-पाछाँ अबैत छल। ");
INSERT INTO mai_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","यीशु पहाड़ पर चढ़ि कऽ अपन शिष्‍य सभक संग बैसि रहलाह। ");
INSERT INTO mai_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","यहूदी सभक फसह-भोजक पाबनि लगचिआयल छल। ");
INSERT INTO mai_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","यीशु जखन नजरि उठा कऽ लोकक बड़का भीड़ केँ अपना लग अबैत देखलनि तखन फिलिपुस केँ पुछलथिन, “अपना सभ एकरा सभ केँ खुअयबाक लेल कतऽ सँ रोटी किनू?” ");
INSERT INTO mai_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ई बात ओ फिलिपुस केँ जँचबाक लेल पुछलथिन, कारण ओ अपने तखनो जनैत छलाह जे ओ की करताह। ");
INSERT INTO mai_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिपुस हुनका उत्तर देलथिन, “एकरा सभ गोटेक लेल कनेको-कनेको जे रोटी किनब से दुओ सय दिनार सँ नहि होयत!” ");
INSERT INTO mai_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","हुनकर एक शिष्‍य, अन्‍द्रेयास, सिमोन पत्रुसक भाय, हुनका कहलथिन, ");
INSERT INTO mai_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“एतऽ एक लड़का अछि जकरा संग मे जओक पाँचटा रोटी छैक आ दूटा माछ, लेकिन एतेक लोक मे एतबे सँ की होयतैक?” ");
INSERT INTO mai_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","यीशु आज्ञा देलथिन, “लोक सभ केँ बैसा दिऔक।” ओहि ठाम बहुत घास छल, और ओहि पर लोक सभ बैसैत गेल। पुरुषक संख्‍या लगभग पाँच हजार छल। ");
INSERT INTO mai_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","तखन यीशु रोटी लेलनि, और परमेश्‍वर केँ धन्‍यवाद दऽ कऽ बैसलाहा लोक सभ मे बटबा देलथिन। तहिना माछो लऽ कऽ कयलनि, और सभ केँ ततेक भेटलैक जतेक-जतेक ओ सभ चाहैत छल। ");
INSERT INTO mai_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","सभ लोक केँ भरि इच्‍छा भोजन कऽ लेलाक बाद यीशु शिष्‍य सभ केँ कहलथिन, “आब उबरल टुकड़ा सभ बिछि लिअ, जाहि सँ किछुओ बरबाद नहि होअय।” ");
INSERT INTO mai_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ओ सभ ओहि पाँचटा जओक रोटीक टुकड़ा, जे भोजन करऽ वला लोक सभ सँ बाँचि गेल छल, तकरा बिछि कऽ ओहि सँ बारहटा पथिया भरलनि। ");
INSERT INTO mai_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","लोक सभ यीशु द्वारा कयल गेल ई चमत्‍कारपूर्ण चिन्‍ह देखि कऽ कहऽ लागल, “ई तँ अवश्‍य परमेश्‍वरक ओ प्रवक्‍ता छथि जे संसार मे आबऽ वला छलाह।” ");
INSERT INTO mai_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","यीशु ई बुझलनि जे लोक सभ हुनका जबरदस्‍ती पकड़ि कऽ राजा बनाबऽ चाहैत छल, तेँ ओ फेर पहाड़ पर असगरे चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","साँझ पड़ला पर यीशुक शिष्‍य सभ झीलक किनार पर जा ");
INSERT INTO mai_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","नाव मे चढ़ि कऽ कफरनहूम नगर जयबाक लेल झील केँ पार करऽ लगलाह। ताबत अन्‍हार भऽ गेल छल और यीशु एखन तक हुनका सभ लग नहि आयल छलाह। ");
INSERT INTO mai_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","हवा बहुत जोर सँ बहि रहल छल, और झील मे बड़का लहरि उठि रहल छल। ");
INSERT INTO mai_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","जखन ओ सभ लगभग तीन-चारि मील नाव केँ खेबि लेने छलाह तखन यीशु केँ झीलक पानि पर चलैत और नाव दिस अबैत देखलनि, और भयभीत भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","मुदा ओ हुनका सभ केँ कहलथिन, “हम छी, नहि डेराउ!” ");
INSERT INTO mai_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","तखन ओ सभ खुशी भऽ हुनका नाव मे लऽ लेबाक लेल तैयार भेलाह, और नाव तुरत ओहि स्‍थान पर पहुँचल जाहिठाम ओ सभ जा रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","प्रात भेने झीलक ओहि पार रहि गेल लोक सभ बुझलक जे एतऽ एकेटा नाव छल, और ओ सभ जनैत छल जे यीशु अपन शिष्‍य सभक संग ओहि नाव मे नहि चढ़ल छलाह, मात्र शिष्‍ये सभ विदा भऽ गेल छलाह। ");
INSERT INTO mai_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","तखन तिबिरियास नगर सँ दोसर नाव सभ ओहि जगह लग पहुँचल जाहिठाम प्रभु यीशुक धन्‍यवादक प्रार्थनाक बाद लोक सभ रोटी खयने छल। ");
INSERT INTO mai_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","तँ लोक जखन देखलक जे ने यीशु आ ने हुनकर शिष्‍य सभ एतऽ छथि, तखन ओ सभ नाव सभ मे चढ़ि कऽ यीशुक खोज मे कफरनहूम नगर गेल। ");
INSERT INTO mai_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","झीलक ओहि पार जखन यीशु ओकरा सभ केँ भेटलथिन तखन ओ सभ पुछलकनि, “गुरुजी, अहाँ एतऽ कखन अयलहुँ?” ");
INSERT INTO mai_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","यीशु ओकरा सभ केँ उत्तर देलथिन, “हम अहाँ सभ केँ सत्‍ये कहैत छी जे अहाँ सभ हमरा एहि लेल नहि तकैत छी जे हमर चमत्‍कार वला चिन्‍ह सभ देखि कऽ बुझलहुँ, बल्‍कि एहि लेल जे अहाँ सभ रोटी खा कऽ अघा गेलहुँ। ");
INSERT INTO mai_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","जे भोजन नहि टिकैत अछि, ताहि लेल परिश्रम नहि करू, बल्‍कि ओहि भोजनक लेल परिश्रम करू जे अनन्‍त जीवन तक टिकैत अछि और जे मनुष्‍य-पुत्र अहाँ सभ केँ प्रदान करताह, कारण हुनका पर पिता-परमेश्‍वर अपन छाप लगा देने छथिन।” ");
INSERT INTO mai_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","तखन ओ सभ हुनका पुछलकनि, “परमेश्‍वरक काज करबाक लेल, हम सभ की करू?” ");
INSERT INTO mai_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","यीशु बजलाह, “परमेश्‍वर अहाँ सभ सँ जे काज चाहैत छथि, से ई अछि जे जकरा ओ पठौने छथि तकरा पर विश्‍वास करू।” ");
INSERT INTO mai_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","एहि पर ओ सभ हुनका कहलकनि, “तखन अहाँ कोन चिन्‍ह देखायब, जकरा देखि कऽ हम सभ अहाँ पर विश्‍वास कऽ सकी? अहाँ की काज करैत छी? ");
INSERT INTO mai_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","हमरा सभक पुरखा निर्जन क्षेत्र मे मन्‍ना वला रोटी खयने छल, जेना धर्मशास्‍त्र मे लिखल अछि जे, ‘ओ ओकरा सभ केँ खयबाक लेल स्‍वर्ग सँ रोटी देलथिन।’” ");
INSERT INTO mai_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","एहि पर यीशु ओकरा सभ केँ कहलथिन, “हम अहाँ सभ केँ विश्‍वास दिअबैत छी जे, बात ई नहि जे अहाँ सभ केँ मूसा स्‍वर्ग सँ रोटी देलनि, बल्‍कि ई जे हमर पिता अहाँ सभ केँ स्‍वर्ग सँ वास्‍तविक रोटी दऽ रहल छथि। ");
INSERT INTO mai_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","हँ, परमेश्‍वर जे रोटी दैत छथि, से ओ अछि जे स्‍वर्ग सँ उतरि कऽ संसार केँ जीवन दैत अछि।” ");
INSERT INTO mai_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ओ सभ हुनका कहलकनि, “यौ मालिक, हमरा सभ केँ ई रोटी एखनो आ सभ दिन दैत रहू!” ");
INSERT INTO mai_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","यीशु बजलाह, “जीवनक रोटी हमहीं छी। जे हमरा लग आओत से कहियो भूखल नहि रहत। जे हमरा पर विश्‍वास करत, तकरा कहियो पियास नहि लगतैक। ");
INSERT INTO mai_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","मुदा जेना अहाँ सभ केँ कहने छलहुँ, अहाँ सभ हमरा देखने छी और तैयो विश्‍वास नहि करैत छी। ");
INSERT INTO mai_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","जकरा पिता हमरा दैत छथि, से सभ हमरा लग आओत, और जे केओ हमरा लग आओत, तकरा हम कहियो नहि अस्‍वीकार करब। ");
INSERT INTO mai_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","कारण हम अपन इच्‍छा नहि, बल्‍कि हमरा पठाबऽ वलाक इच्‍छा पूरा करबाक लेल स्‍वर्ग सँ उतरल छी, ");
INSERT INTO mai_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","और हमरा पठाबऽ वलाक इच्‍छा ई छनि जे जकरा सभ केँ ओ हमरा देने छथि, तकरा सभ मे सँ हम एकोटा केँ नहि हेराबी, बल्‍कि अन्‍तिम दिन मे ओकरा सभ केँ जिआबी। ");
INSERT INTO mai_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","हँ, हमर पिताक इच्‍छा ई छनि जे, जे केओ पुत्र दिस ताकत और ओकरा पर विश्‍वास करत, तकरा अनन्‍त जीवन भेटतैक, और हम ओकरा अन्‍तिम दिन मे जिआ देब।” ");
INSERT INTO mai_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","एहि पर यहूदी सभ हुनका पर कुड़बुड़ाय लगलाह, कारण ओ कहने छलाह जे, स्‍वर्ग सँ उतरल रोटी हमहीं छी। ");
INSERT INTO mai_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ओ सभ कहलनि, “ई तँ यूसुफक बेटा यीशुए अछि! और एकर माय-बाप केँ अपना सभ चिन्‍हिते छिऐक! तँ ई आब कोना कहैत अछि जे हम स्‍वर्ग सँ उतरल छी?” ");
INSERT INTO mai_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","यीशु हुनका सभ केँ उत्तर देलथिन, “अहाँ सभ अपना सभ मे एना नहि कुड़बुड़ाउ! ");
INSERT INTO mai_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","केओ हमरा लग ताबत तक नहि आबि सकैत अछि जाबत तक हमर पिता जे हमरा पठौलनि, से ओकरा हमरा लग नहि खीचि दैत छथि। और हम ओकरा अन्‍तिम दिन मे जिआ देब। ");
INSERT INTO mai_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","परमेश्‍वरक प्रवक्‍ता सभक लेख छनि जे, ‘ओ सभ गोटे परमेश्‍वर द्वारा सिखाओल जायत।’ जे केओ पिताक सुनैत छनि और हुनका सँ सिखैत अछि, से हमरा लग अबैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","हमर कहबाक मतलब ई नहि जे, केओ पिता केँ देखने छनि। ओ जे पिताक ओहिठाम सँ आयल अछि, खाली वैहटा हुनका देखने छनि। ");
INSERT INTO mai_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","हम अहाँ सभ केँ सत्‍ये कहैत छी जे, जे विश्‍वास करैत अछि, तकरा अनन्‍त जीवन छैक। ");
INSERT INTO mai_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","जीवनक रोटी हम छी। ");
INSERT INTO mai_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","अहाँ सभक पुरखा लोकनि निर्जन क्षेत्र मे मन्‍ना वला रोटी खयलनि, और तैयो मरलाह। ");
INSERT INTO mai_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","मुदा ई रोटी जकरा बारे मे हम बाजि रहल छी, से ओ अछि जे स्‍वर्ग सँ उतरल अछि, जाहि सँ जँ केओ एहि मे सँ खायत तँ नहि मरत। ");
INSERT INTO mai_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ओ जीबैत रोटी जे स्‍वर्ग सँ उतरल अछि से हमहीं छी। जँ केओ ई रोटी खायत तँ ओ अनन्‍त काल तक जीबैत रहत। और ई रोटी जे हम संसारक जीवनक लेल देब, से हमर माँसु अछि।” ");
INSERT INTO mai_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","तखन यहूदी सभ अपना सभ मे वाद-विवाद करऽ लगलाह जे, “ई व्‍यक्‍ति हमरा सभ केँ खाय लेल अपन माँसु कोना दऽ सकत?” ");
INSERT INTO mai_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","यीशु हुनका सभ केँ कहलथिन, “हम अहाँ सभ केँ विश्‍वास दिअबैत छी जे, जाबत तक अहाँ मनुष्‍य-पुत्रक माँसु नहि खयबैक और ओकर खून नहि पिबैक, ताबत तक अहाँ मे जीवन नहि अछि। ");
INSERT INTO mai_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","जे हमर माँसु खाइत अछि और हमर खून पिबैत अछि, तकरा अनन्‍त जीवन छैक, और हम ओकरा अन्‍तिम दिन मे जिआ देबैक। ");
INSERT INTO mai_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","कारण, हमर माँसु वास्‍तविक भोजन अछि और हमर खून वास्‍तविक पिबाक वस्‍तु अछि। ");
INSERT INTO mai_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","जे केओ हमर माँसु खाइत अछि और हमर खून पिबैत अछि, से हमरा मे बनल रहैत अछि और हम ओकरा मे बनल रहैत छी। ");
INSERT INTO mai_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","जहिना जीवित पिता हमरा पठौलनि आ हम हुनका कारण जीबैत छी, तहिना, जे हमरा मे सँ खायत, सैह हमरा कारण जीबैत रहत। ");
INSERT INTO mai_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ई रोटी स्‍वर्ग सँ उतरल अछि। ई तेहन नहि अछि जेहन अहाँ सभक पुरखा लोकनि खयलनि। ओ सभ खयलनि आ मरलाह। मुदा जे ई रोटी खायत से सर्वदा जीबैत रहत।” ");
INSERT INTO mai_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ई सभ बात यीशु कफरनहूमक सभाघर मे शिक्षा दैत काल बजलाह। ");
INSERT INTO mai_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","यीशुक बात सुनि कऽ हुनकर बहुतो शिष्‍य कहलनि, “ई शिक्षा बहुत कठोर अछि। एकरा के बरदास्‍त कऽ सकत?” ");
INSERT INTO mai_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","मुदा यीशु अपना मोन मे बुझि गेलाह जे हमर शिष्‍य सभ एहि सँ कुड़बुड़ाइत छथि, तेँ हुनका सभ केँ कहलथिन, “की एहि बात सँ अहाँ सभक मोन मे ठेस लागि गेल? ");
INSERT INTO mai_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","और मानि लिअ जे अहाँ सभ मनुष्‍य-पुत्र केँ ओहिठाम ऊपर जाइत देखबनि जाहिठाम ओ पहिने छलाह—तखन की? ");
INSERT INTO mai_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","आत्‍मे जीवन दैत अछि, शरीर सँ किछुओ लाभ नहि। जे किछु हम अहाँ सभ केँ कहलहुँ से आत्‍माक और जीवनक बात अछि। ");
INSERT INTO mai_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","तैयो अहाँ सभ मे अनेक एहन छी जे विश्‍वास नहि करैत छी।” यीशु तँ शुरुए सँ जनैत छलाह जे ओ के सभ अछि जे हमरा पर विश्‍वास नहि करैत अछि, और ओ के अछि जे हमरा पकड़बाओत। ");
INSERT INTO mai_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ओ आगाँ कहऽ लगलाह, “एहि कारणेँ हम अहाँ सभ केँ कहने छलहुँ जे, केओ हमरा लग ताबत तक नहि आबि सकैत अछि जाबत तक पिता ओकरा अयबाक सामर्थ्‍य नहि दैत छथिन।” ");
INSERT INTO mai_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","एहि बात सभ सँ हुनकर बहुतो शिष्‍य ओहिठाम सँ घूमि गेल और फेर हुनका संग नहि चलल। ");
INSERT INTO mai_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","तखन यीशु अपना बारहो शिष्‍य केँ पुछलथिन, “की अहूँ सभ हमरा छोड़ऽ चाहैत छी?” ");
INSERT INTO mai_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","सिमोन पत्रुस हुनका उत्तर देलथिन, “प्रभु, हम सभ ककरा लग जाउ? अहाँ लग तँ अनन्‍त जीवनक वचन अछि। ");
INSERT INTO mai_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","हम सभ विश्‍वास कऽ कऽ जानि गेल छी जे अहाँ परमेश्‍वरक पवित्र दूत छी।” ");
INSERT INTO mai_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","यीशु उत्तर देलथिन, “की अहाँ बारहो गोटे केँ हम नहि चुनलहुँ? और तैयो अहाँ सभ मे सँ एक शैतान अछि।” ");
INSERT INTO mai_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ओ ई बात सिमोन इस्‍करियोतीक पुत्र यहूदाक बारे मे कहलनि, किएक तँ ओ बारह शिष्‍य मे सँ एक होइतो हुनका पकड़बाबऽ वला छलाह। ");
INSERT INTO mai_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","एकरा बाद यीशु गलील प्रदेश मे जगह-जगह पर घुमऽ लगलाह। ओ यहूदिया प्रदेश मे नहि घुमऽ चाहैत छलाह, किएक तँ यहूदी सभक धर्मगुरु सभ हुनका मारि देबाक ताक मे छलनि। ");
INSERT INTO mai_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","मुदा यहूदी सभक झोपड़ीक पाबनि जखन लग आबि गेल, ");
INSERT INTO mai_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","तँ हुनकर भाय सभ हुनका कहलथिन, “ई जगह छोड़ू, और यहूदिया प्रदेश चल जाउ, जाहि सँ अहाँ जे चमत्‍कार कऽ रहल छी से अहाँक चेला सभ देखि सकत। ");
INSERT INTO mai_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","कारण एहन केओ नहि होइत अछि जे नामी होमऽ चाहय आ गुप्‍त रूप सँ काज करय। अहाँ ई सभ काज कऽ रहल छी, तँ अपना केँ दुनियाक सामने मे प्रगट करू।” ");
INSERT INTO mai_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","हुनकर अपन भाय सभ सेहो हुनका पर विश्‍वास नहि करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","तेँ यीशु हुनका सभ केँ कहलथिन, “हमर समय एखन तक नहि आयल अछि, लेकिन अहाँ सभक लेल कोनो समय उपयुक्‍त अछि। ");
INSERT INTO mai_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","अहाँ सभ सँ संसार घृणा नहि कऽ सकैत अछि, मुदा हमरा सँ तँ करैत अछि किएक तँ संसारक बारे मे हम गवाही दैत छी जे ओकर चालि-चलन खराब छैक। ");
INSERT INTO mai_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","अहीं सभ पाबनिक लेल जाउ। हम एखन एहि पाबनिक लेल नहि जायब, कारण हमर समय एखन तक नहि पूरल अछि।” ");
INSERT INTO mai_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ई बात कहि कऽ ओ गलीले मे रहि गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","मुदा जखन हुनकर भाय सभ पाबनिक लेल चल गेलाह तखन ओहो गेलाह, खुलि कऽ नहि, बल्‍कि गुप्‍त रूप सँ। ");
INSERT INTO mai_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","पाबनिक समय यहूदी धर्मगुरु सभ ई कहैत यीशु केँ तकैत छलनि जे, “ओ कतऽ अछि?” ");
INSERT INTO mai_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","हुनका बारे मे लोक सभ बहुत फुसफुसाइत छल। किछु लोक कहैत छल, “ओ नीक आदमी छथि।” और दोसर कहैत छल, “नहि! ओ जनता केँ बहकबैत छैक।” ");
INSERT INTO mai_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","मुदा धर्मगुरु सभक डर सँ केओ हुनका बारे मे किछु खुलि कऽ नहि कहैत छल। ");
INSERT INTO mai_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","पाबनि करीब-करीब आधा समाप्‍त भऽ गेलाक बादे यीशु मन्‍दिर मे जा कऽ शिक्षा देबऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","यहूदी सभ बहुत आश्‍चर्यित भऽ कऽ कहलनि, “एहि आदमी केँ बिनु पढ़नहि एतेक ज्ञान कतऽ सँ प्राप्‍त भेलैक?” ");
INSERT INTO mai_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","यीशु उत्तर देलथिन, “हम जे शिक्षा दैत छी से हमर नहि, बल्‍कि जे हमरा पठौलनि, तिनकर अछि। ");
INSERT INTO mai_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","जँ केओ हुनकर इच्‍छा पूरा करबाक निश्‍चय करत तँ ओ अवश्‍य ई जानि जायत जे हमर शिक्षा परमेश्‍वरक अछि वा हम अपने दिस सँ बाजि रहल छी। ");
INSERT INTO mai_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","जे अपना दिस सँ बजैत अछि, से एहि लेल, जे ओ अपना लेल आदर चाहैत अछि, मुदा जे अपन पठाबऽ वलाक आदर चाहैत अछि से सत्‍य पुरुष अछि और ओकरा मे कोनो छल-प्रपंच नहि छैक। ");
INSERT INTO mai_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","की मूसा अहाँ सभ केँ धर्म-नियम नहि देने छथि? तैयो अहाँ सभ मे सँ एको व्‍यक्‍ति ओहि नियमक पालन नहि करैत छी। अहाँ सभ हमरा किएक मारि देबऽ चाहैत छी?” ");
INSERT INTO mai_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","भीड़क लोक उत्तर देलकनि, “अहाँ मे तँ दुष्‍टात्‍मा अछि! अहाँ केँ के मारऽ चाहैत अछि?” ");
INSERT INTO mai_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","यीशु बजलाह, “हम एकटा काज कयलहुँ और ओहि सँ अहाँ सभ गोटे आश्‍चर्यित भेलहुँ। ");
INSERT INTO mai_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","मूसा अहाँ सभ केँ खतनाक विधि देलनि, ओना तँ ओ विधि वास्‍तव मे मूसा सँ नहि देल गेल, बल्‍कि हुनका सँ पहिने वला पुरखा सभ सँ, और ओहि अनुसार अहाँ सभ विश्राम-दिन मे बच्‍चाक खतना करैत छी। ");
INSERT INTO mai_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","जँ खतना करऽ वला दिन विश्रामोक दिन पड़ला पर अहाँ सभ ओ विधि करैत छी, जाहि सँ मूसाक नियम नहि तोड़ल जाय तँ हमरा पर किएक खिसिआइत छी जखन हम विश्राम-दिन मे ककरो शरीर पूर्ण रूप सँ स्‍वस्‍थ कऽ देलहुँ? ");
INSERT INTO mai_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","मुँह देखि न्‍याय कयनाइ छोड़ू और उचित न्‍याय करू।” ");
INSERT INTO mai_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","तखन यरूशलेमक किछु निवासी कहऽ लागल, “की ई आदमी ओ नहि अछि, जकरा ओ सभ मारि देबाक कोशिश कऽ रहल छैक? ");
INSERT INTO mai_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","मुदा देखू! ई एतऽ खुलि कऽ बाजि रहल अछि और एकरा केओ नहि किछु कहैत छैक! कतौ एहन तँ नहि भऽ गेल जे अपना सभक धर्मगुरु-नेता सभ वास्‍तव मे मानि लेने होथि जे ई परमेश्‍वरक पठाओल उद्धारकर्ता-मसीह अछि? ");
INSERT INTO mai_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","मुदा एकरा तँ अपना सभ जनिते छी जे ई कतऽ सँ आयल अछि। उद्धारकर्ता-मसीह जखन औताह तँ ककरो नहि बुझल होयतैक जे ओ कोन ठामक छथि।” ");
INSERT INTO mai_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","तखन यीशु मन्‍दिर मे शिक्षा दैत जोर सँ कहलनि, “हँ! हमरा चिन्‍हैत छी और जनैत छी जे हम कोन ठामक छी। मुदा हम अपने सँ नहि आयल छी। जे हमरा पठौलनि, वैह सत्‍य छथि। अहाँ सभ हुनका नहि चिन्‍हैत छियनि, ");
INSERT INTO mai_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","मुदा हम हुनका चिन्‍हैत छी, किएक तँ हम हुनका ओहिठाम सँ आयल छी, और वैह हमरा पठौलनि।” ");
INSERT INTO mai_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","एहि पर ओ सभ हुनका पकड़बाक कोशिश करऽ लगलाह, मुदा केओ हुनका हाथ नहि लगा सकलनि, कारण हुनकर समय एखन नहि आयल छल। ");
INSERT INTO mai_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","तैयो जनता मे सँ बहुत लोक हुनका पर विश्‍वास कयलकनि, आ बाजल, “मसीह जखन औताह तँ की एहि व्‍यक्‍ति सँ बेसी चमत्‍कारपूर्ण चिन्‍ह देखौताह?” ");
INSERT INTO mai_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","फरिसी सभ जखन भीड़ केँ यीशुक बारे मे एना फुसफुसाइत सुनलनि, तँ ओ सभ आ मुख्‍यपुरोहित सभ मन्‍दिरक सिपाही केँ हुनका पकड़ऽ लेल पठा देलनि। ");
INSERT INTO mai_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","तखन यीशु बजलाह, “कनेक कालक लेल आओर अहाँ सभक संग छी, तखन तिनका लग जायब जे हमरा पठौलनि। ");
INSERT INTO mai_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","अहाँ सभ हमरा ताकब, मुदा हम नहि भेटब, और हम जतऽ होयब ततऽ अहाँ सभ नहि आबि सकब।” ");
INSERT INTO mai_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","यहूदी सभक धर्मगुरु सभ एक-दोसर केँ कहऽ लगलाह, “ई कतऽ जाय चाहैत अछि जाहि सँ हमरा सभ केँ नहि भेटत? की ओहिठाम जायत जाहिठाम अपना सभक लोक यूनानी सभ मे प्रवासी भऽ कऽ रहैत अछि, और की यूनानी सभ केँ सेहो सिखाओत? ");
INSERT INTO mai_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","एकर की कहबाक मतलब छैक जे, अहाँ सभ हमरा ताकब मुदा हम नहि भेटब, और, हम जतऽ होयब ततऽ अहाँ सभ नहि आबि सकब?” ");
INSERT INTO mai_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","पाबनिक अन्‍तिम दिन, जे पाबनिक सभ सँ पैघ दिन मानल जाइत छल, ओहि दिन यीशु ठाढ़ भऽ गेलाह और जोर सँ कहलनि, “जँ ककरो पियास लागल छैक तँ ओ हमरा लग आबय और पिबय। ");
INSERT INTO mai_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","जे हमरा पर विश्‍वास करैत अछि, जेना धर्मशास्‍त्रक कथन अछि, ओकरा हृदय सँ जीवन-जलक झरना फूटि जायत।” ");
INSERT INTO mai_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ई बात ओ पवित्र आत्‍माक सम्‍बन्‍ध मे कहलनि, जिनका विश्‍वास कयनिहार सभ प्राप्‍त करऽ वला छल। एखन तक पवित्र आत्‍मा तँ प्रदान नहि कयल गेल छलाह, कारण यीशु एखन तक अपन स्‍वर्गक महिमा मे फिरि कऽ नहि गेल छलाह। ");
INSERT INTO mai_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ई बात सुनि बहुत लोक कहऽ लागल, “ई सत्‍ये परमेश्‍वरक ओ प्रवक्‍ता छथि।” ");
INSERT INTO mai_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","दोसर लोक कहलक, “ओ उद्धारकर्ता-मसीह छथि।” मुदा फेर आरो दोसर लोक सभ कहलक, “कोना?! की उद्धारकर्ता-मसीह गलील प्रदेश सँ औताह? ");
INSERT INTO mai_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","की धर्मशास्‍त्रक कथन नहि अछि जे मसीह दाऊद राजाक वंशज होयताह, और दाऊदक गाम, बेतलेहम सँ औताह?” ");
INSERT INTO mai_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","एहि तरहेँ यीशुक विषय मे लोक सभ केँ अपना मे मतभेद भऽ गेलैक। ");
INSERT INTO mai_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","किछु लोक हुनका पकड़ऽ चाहैत छल, मुदा केओ हुनका हाथ नहि लगौलकनि। ");
INSERT INTO mai_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","तखन मन्‍दिरक सिपाही सभ मुख्‍यपुरोहित आ फरिसी सभ लग घूमि कऽ आयल। ई सभ ओकरा सभ केँ पुछलथिन, “अहाँ सभ ओकरा किएक नहि पकड़ि कऽ अनलहुँ?” ");
INSERT INTO mai_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","सिपाही सभ उत्तर देलकनि, “ओ आदमी जेना बजैत छथि, तेना आइ तक केओ कहियो नहि बाजल अछि!” ");
INSERT INTO mai_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","फरिसी सभ ओकरा सभ केँ कहलथिन, “अरे! तोरो सभ केँ ओ ठकि लेलकौ की? ");
INSERT INTO mai_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","धर्मगुरु सभ मे सँ वा फरिसी मे सँ की एको गोटे ओकरा पर विश्‍वास कयने अछि? नहि! ");
INSERT INTO mai_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","मुदा ई भीड़, जे धर्म-नियमक बारे मे किछु नहि जनैत अछि—ओ सभ सरापित अछि!” ");
INSERT INTO mai_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","तखन ओहि फरिसी मे सँ एक आदमी, निकोदेमुस, जे पहिने एक बेर यीशु लग आयल छलाह, से कहलनि, ");
INSERT INTO mai_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“अपना सभक नियमक अनुसार जाबत तक ककरो बात नहि सुनल जायत और पता नहि लगाओल जायत जे ओ की कऽ रहल अछि की ताबत तक दोषी ठहराओल जायत?” ");
INSERT INTO mai_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ओ सभ उत्तर देलथिन, “अहूँ गलीलेक छी की? धर्मशास्‍त्रक अध्‍ययन करू—अहाँ केँ पता लागत जे परमेश्‍वरक कोनो प्रवक्‍ता गलील सँ नहि अबैत छथि!” ");
INSERT INTO mai_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","तखन ओ सभ अपन-अपन घर चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","मुदा यीशु जैतून पहाड़ पर गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","भोरे भोर यीशु फेर मन्‍दिर मे अयलाह। लोक सभ हुनका लग आयल और ओ बैसि कऽ ओकरा सभ केँ शिक्षा देबऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","धर्मशिक्षक और फरिसी सभ एक स्‍त्रीगण केँ अनलनि, जे पुरुषक संग कुकर्म करैत पकड़ा गेल छल, और लोकक बीच मे ओकरा ठाढ़ कऽ कऽ ");
INSERT INTO mai_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","यीशु केँ कहलथिन, “गुरुजी, ई स्‍त्रीगण पुरुषक संग कुकर्म करिते मे पकड़ा गेल। ");
INSERT INTO mai_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","धर्म-नियम मे मूसा हमरा सभ केँ आज्ञा देलनि जे एहन स्‍त्रीगण केँ पाथर मारि कऽ मारि देबाक चाही। आब अहाँ की कहैत छी?” ");
INSERT INTO mai_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ई बात ओ सभ हुनका फँसाबऽ लेल पुछलनि, जाहि सँ हुनका पर दोष लगयबाक आधार भेटनि। यीशु नीचाँ झुकि कऽ अपन आङुर सँ जमीन पर लिखऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ओ सभ जखन हुनका सँ पुछिते रहलाह, तखन ओ मूड़ी उठा कऽ हुनका सभ केँ कहलथिन, “अहाँ सभ मे सँ जे निष्‍पाप होथि, वैह सभ सँ पहिने पाथर मारथि।” ");
INSERT INTO mai_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","और फेर झुकि कऽ जमीन पर लिखऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ई बात जखन ओ सभ सुनलनि तँ पहिने बूढ़ सभ आ तखन एक-एक कऽ सभ केओ चल गेलाह। आब मात्र यीशु रहि गेलाह, और ओ स्‍त्रीगण जे ओहिठाम ठाढ़ छलि। ");
INSERT INTO mai_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","यीशु मूड़ी उठा कऽ ओकरा कहलथिन, “बहिन, ओ सभ कतऽ अछि? की तोरा केओ नहि दण्‍ड देलकह?” ");
INSERT INTO mai_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ओ बाजल, “नहि, मालिक, केओ नहि।” यीशु बजलाह, “हमहूँ तोरा दण्‍ड नहि दैत छिअह। आब जाह, आ फेर पाप नहि करह।” ");
INSERT INTO mai_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","बाद मे यीशु फेर लोक सभ केँ कहलनि, “हम संसारक इजोत छी। जे केओ हमरा पाछाँ आओत, से अन्‍हार मे कहियो नहि चलत, बल्‍कि जीवनक इजोत प्राप्‍त करत।” ");
INSERT INTO mai_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","एहि पर फरिसी सभ हुनका कहलथिन, “आब अहाँ अपना बारे मे अपने गवाही दऽ रहल छी! अहाँक गवाही पकिया नहि मानल जायत।” ");
INSERT INTO mai_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","यीशु उत्तर देलथिन, “जँ हम अपना बारे मे गवाही दैतो छी तँ हमर गवाही पकिया होइत अछि, कारण हम जनैत छी जे हम कतऽ सँ आयल छी और कतऽ जा रहल छी, मुदा अहाँ सभ नहि जनैत छी जे हम कतऽ सँ अयलहुँ वा कतऽ जाय वला छी। ");
INSERT INTO mai_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","अहाँ सभ सांसारिक दृष्‍टि सँ न्‍याय करैत छी। हम ककरो न्‍याय नहि करैत छी। ");
INSERT INTO mai_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","तैयो जँ हम न्‍याय करितो छी तँ हमर न्‍याय उचित होइत अछि कारण निर्णय हम असगरे नहि, बल्‍कि हमर पिता, जे हमरा पठौलनि, से और हम दूनू गोटे करैत छी। ");
INSERT INTO mai_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","अहीं सभक धर्म-नियम मे लिखल अछि जे दू आदमीक गवाही पकिया होइत अछि। ");
INSERT INTO mai_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","हम अपना बारे मे अपने एक गवाह छी और हमर दोसर गवाह ओ छथि जे हमरा पठौलनि—हमर पिता।” ");
INSERT INTO mai_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ओ सभ तखन हुनका कहलथिन, “अहाँक पिता कतऽ छथि?” यीशु बजलाह, “अहाँ सभ ने हमरा चिन्‍हैत छी, आ ने हमरा पिता केँ। जँ हमरा चिन्‍हितहुँ तँ हमरा पितो केँ चिन्‍हितिऐन।” ");
INSERT INTO mai_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ई सभ बात ओ शिक्षा दैत काल मन्‍दिरक ओहि भाग मे कहलनि जाहिठाम दान-पात्र राखल रहैत छल। तैयो हुनका केओ नहि पकड़लकनि, किएक तँ हुनकर समय एखन तक नहि आयल छल। ");
INSERT INTO mai_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","यीशु हुनका सभ केँ फेर कहलथिन, “हम तँ जा रहल छी। अहाँ सभ हमरा ताकब, और अपना पाप मे मरब। हम जतऽ जाइत छी ततऽ अहाँ सभ नहि आबि सकैत छी।” ");
INSERT INTO mai_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","एहि पर यहूदी सभ एक-दोसर केँ कहऽ लागल, “तँ की ओ आत्‍महत्‍या कऽ लेत? की एहि कारणेँ ओ कहैत अछि जे, हम जतऽ जाइत छी ततऽ अहाँ सभ नहि आबि सकैत छी?” ");
INSERT INTO mai_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ओ ओकरा सभ केँ आगाँ कहलथिन, “अहाँ सभ नीचाँक छी, हम ऊपरक छी। अहाँ सभ एही दुनियाक छी, हम एहि दुनियाक नहि छी। ");
INSERT INTO mai_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","एहि लेल हम अहाँ सभ केँ कहलहुँ जे, अहाँ सभ अपना पाप मे मरब। कारण, जँ अहाँ सभ विश्‍वास नहि करब जे हम वैह छी जे छी, तँ अहाँ सभ अपना पाप मे अवश्‍य मरब।” ");
INSERT INTO mai_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ओ सभ हुनका कहलकनि, “तखन अहाँ के छी?” यीशु बजलाह, “वैह, जे हम शुरुए सँ अहाँ सभ केँ कहैत आबि रहल छी। ");
INSERT INTO mai_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","अहाँ सभक सम्‍बन्‍ध मे हमरा बहुत किछु कहबाक और न्‍याय करबाक अछि। मुदा जे हमरा पठौलनि, से सत्‍य छथि, और जे बात हम हुनका सँ सुनने छी, वैह बात हम संसार केँ कहैत छी।” ");
INSERT INTO mai_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ओ सभ नहि बुझलक जे यीशु पिताक बारे मे ओकरा सभ केँ कहैत छथि। ");
INSERT INTO mai_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","तेँ यीशु कहलनि, “जखन अहाँ सभ मनुष्‍य-पुत्र केँ ऊपर लटका देब तखन अहाँ सभ जानि जायब जे हम वैह छी जे छी, और जानब जे हम अपने सँ किछु नहि करैत छी, बल्‍कि वैह करैत आ कहैत छी जे पिता हमरा सिखौने छथि। ");
INSERT INTO mai_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","जे हमरा पठौलनि, से हमरा संग छथि। ओ हमरा असगरे नहि छोड़ने छथि, कारण हम सदिखन वैह काज करैत छी जाहि काज सँ ओ प्रसन्‍न होइत छथि।” ");
INSERT INTO mai_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","जखन ई बात ओ कहि रहल छलाह तखने बहुतो लोक हुनका पर विश्‍वास कयलकनि। ");
INSERT INTO mai_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","जे यहूदी सभ हुनका पर विश्‍वास कयलनि, तिनका सभ केँ यीशु कहलथिन, “जँ अहाँ सभ हमरा सिद्धान्‍तक पालन करब तँ अहाँ सभ वास्‍तव मे हमर शिष्‍य होयब। ");
INSERT INTO mai_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","तखन अहाँ सभ सत्‍य केँ जानब, और सत्‍य अहाँ सभ केँ स्‍वतन्‍त्र कऽ देत।” ");
INSERT INTO mai_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ओ सभ हुनका उत्तर देलथिन, “हम सभ तँ अब्राहमक वंशज छी और कहियो ककरो गुलाम नहि भेलहुँ। अहाँ कोना कहैत छी जे हम सभ स्‍वतन्‍त्र कऽ देल जायब?” ");
INSERT INTO mai_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","यीशु हुनका सभ केँ उत्तर देलथिन, “हम अहाँ सभ केँ सत्‍ये कहैत छी जे, जे केओ पाप करैत अछि, से दास अछि। ");
INSERT INTO mai_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","दास घर मे सभ दिन तक नहि रहैत अछि, मुदा पुत्र सभ दिन तक रहैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","तेँ जँ पुत्र अहाँ केँ स्‍वतन्‍त्र कऽ देताह तँ वास्‍तव मे अहाँ स्‍वतन्‍त्र भऽ जायब। ");
INSERT INTO mai_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","हमरा बुझल अछि जे अहाँ सभ अब्राहमक वंशज छी, तैयो अहाँ सभ हमरा मारि देबऽ चाहैत छी। तकर कारण ई अछि जे, अहाँ सभक मोन मे हमरा वचनक लेल कोनो स्‍थान नहि अछि। ");
INSERT INTO mai_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","हम जे किछु अपना पिताक ओहिठाम देखने छी, वैह कहैत छी, और अहाँ सभ से कहैत छी जे अपने पिता सँ सुनने छी।” ");
INSERT INTO mai_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ओ सभ उत्तर देलथिन, “हमरा सभक पिता अब्राहम छथि।” यीशु हुनका सभ केँ कहलथिन, “अहाँ सभ जँ अब्राहमक सन्‍तान रहितहुँ तँ जे काज अब्राहम कयलनि सैह करितहुँ। ");
INSERT INTO mai_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","मुदा देखू! अहाँ सभ हमरा खून कऽ देबाक कोशिश मे छी, खाली एहि लेल, जे हम परमेश्‍वर सँ सुनल सत्‍य केँ अहाँ सभ केँ कहलहुँ। अब्राहम एहन काज तँ नहि कयलनि! ");
INSERT INTO mai_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","जे अहाँ सभक पिता अछि, तकरे जकाँ अहाँ सभ करैत छी।” ओ सभ उत्तर देलथिन, “हम सभ अनजनुआ-जन्‍मल नहि छी! हमरा सभक एकेटा पिता छथि, अर्थात् परमेश्‍वर।” ");
INSERT INTO mai_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","यीशु बजलाह, “जँ अहाँ सभक पिता परमेश्‍वर रहितथि तँ अहाँ सभ हमरा सँ प्रेम करितहुँ किएक तँ हम हुनके ओहिठाम सँ अयलहुँ और आब एतऽ छी। हम अपना इच्‍छा सँ नहि अयलहुँ, वैह हमरा पठौलनि। ");
INSERT INTO mai_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","हम जे कहैत छी से अहाँ सभ किएक नहि बुझैत छी? एहि लेल जे अहाँ सभ हमर बात नहि सुनि सकैत छी! ");
INSERT INTO mai_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","अहाँ सभ अपन पिता, जे शैतान अछि, तकर छी, और अहाँ सभ अपन पिताक इच्‍छा पूरा करबाक निश्‍चय कयने छी। ओ शुरुए सँ हत्‍यारा अछि और सत्‍य सँ कोनो सम्‍बन्‍ध नहि रखैत अछि, कारण ओकरा मे सत्‍य छैहे नहि। ओ जखन झूठ बजैत अछि तँ अपन स्‍वभावेक अनुसार बजैत अछि, किएक तँ ओ झुट्ठा अछि और झूठक पिता अछि। ");
INSERT INTO mai_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","मुदा हम अहाँ सभ केँ सत्‍य कहैत छी और तेँ अहाँ सभ हमर विश्‍वास नहि करैत छी। ");
INSERT INTO mai_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","की अहाँ सभ मे सँ केओ प्रमाणित कऽ सकैत अछि जे हम पापक दोषी छी? जँ हम सत्‍य बजैत छी तँ हमर विश्‍वास किएक नहि करैत छी? ");
INSERT INTO mai_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","जे परमेश्‍वरक अछि, से परमेश्‍वरक वचन सुनैत अछि। अहाँ सभ एहि द्वारे नहि सुनैत छी जे अहाँ सभ परमेश्‍वरक नहि छी।” ");
INSERT INTO mai_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","यहूदी सभ हुनका उत्तर देलथिन, “की हम सभ ठीके नहि कहैत आबि रहल छिऔ जे तोँ सामरी छैं और तोरा मे दुष्‍टात्‍मा छौ?” ");
INSERT INTO mai_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","यीशु उत्तर देलथिन, “हमरा मे दुष्‍टात्‍मा नहि अछि। हम अपना पिता केँ आदर करैत छी मुदा अहाँ सभ हमर निरादर करैत छी। ");
INSERT INTO mai_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","लेकिन हम अपना सम्‍मानक लेल चिन्‍ता नहि करैत छी। एक दोसर गोटे करैत छथि और वैह न्‍याय करैत छथि। ");
INSERT INTO mai_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","हम अहाँ सभ केँ सत्‍ये कहैत छी जे जँ केओ हमर बात पर चलत तँ ओ कहियो नहि मरत।” ");
INSERT INTO mai_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","तखन यहूदी सभ हुनका कहलकनि, “आब तँ निश्‍चय जानि गेलहुँ जे तोरा मे दुष्‍टात्‍मा छौ! अब्राहम मरि गेलाह और परमेश्‍वरक प्रवक्‍ता सभ सेहो, और तैयो तोँ कहैत छैं जे, कोनो व्‍यक्‍ति जँ तोरा वचन पर चलत तँ मृत्‍यु केँ कहियो नहि चिखत! ");
INSERT INTO mai_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","की तोँ हमरा सभक पुरखा अब्राहम सँ पैघ हयबेँ? ओ तँ मरि गेलाह आ परमेश्‍वरक आरो सभ प्रवक्‍ता सेहो मरलाह। तोँ अपना केँ की बुझैत छैं?” ");
INSERT INTO mai_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","यीशु उत्तर देलथिन, “जँ हमहीं अपन सम्‍मान करितहुँ तँ ओहि सम्‍मानक कोनो महत्‍व नहि होइत। हमर सम्‍मान करऽ वला हमर पिता छथि, वैह जिनका अहाँ सभ अपन परमेश्‍वर कहैत छियनि। ");
INSERT INTO mai_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","अहाँ सभ हुनका चिन्‍हबे नहि करैत छी, मुदा हम हुनका चिन्‍हैत छी। जँ हम कहितहुँ जे हम हुनका नहि चिन्‍हैत छी, तँ हम अहीं सभ जकाँ झुट्ठा होइतहुँ, मुदा हम हुनका चिन्‍हिते छियनि, और हुनका वचन पर चलैत छी। ");
INSERT INTO mai_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","अहाँ सभक पिता अब्राहम हमरा देखबाक आशा मे बहुत आनन्‍दित छलाह। ओ देखबो कयलनि और बड्ड खुश भेलाह।” ");
INSERT INTO mai_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","तखन यहूदी सभ कहलथिन, “तोँ एखन पचासो वर्षक नहि छैं और तोँ अब्राहम केँ देखने छैं!” ");
INSERT INTO mai_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","यीशु उत्तर देलथिन, “हम अहाँ सभ केँ सत्‍ये कहैत छी जे अब्राहमक जन्‍मो सँ पहिने, हम छी!” ");
INSERT INTO mai_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","एहि पर ओ सभ हुनका मारबाक लेल पाथर उठाबऽ लगलाह, मुदा यीशु नुका कऽ मन्‍दिर सँ बाहर भऽ कऽ चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","यीशु चलैत-चलैत एक आदमी केँ देखलनि जे जन्‍म सँ आन्‍हर छल। ");
INSERT INTO mai_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","हुनकर शिष्‍य सभ पुछलथिन, “गुरुजी, ई आदमी अपने पापक कारणेँ आन्‍हर जनमल की माय-बाबूक पापक कारणेँ?” ");
INSERT INTO mai_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","यीशु उत्तर देलथिन, “ने अपना पापक कारणेँ आ ने माय-बाबूक। ई एहि लेल भेल जे ओकरा मे परमेश्‍वरक काज प्रगट भऽ जानि। ");
INSERT INTO mai_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","जे हमरा पठौलनि, तिनकर काज अपना सभ केँ दिने मे करऽ पड़त। राति आबि रहल अछि, जखन केओ नहि काज कऽ सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","जाबत धरि हम संसार मे छी, ताबत धरि हम संसारक इजोत छी।” ");
INSERT INTO mai_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","एतबा कहि ओ जमीन पर थुकलनि, आओर थूक मे माटि सानि कऽ, ओहि आदमीक आँखि पर लगा देलथिन। ");
INSERT INTO mai_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","तखन ओकरा कहलथिन, “जा कऽ शिलोह कुण्‍ड मे धो लैह।” (शिलोहक अर्थ अछि “पठाओल गेल”।) तँ ओ आदमी जा कऽ आँखि धो लेलक आओर देखैत घर चल आयल। ");
INSERT INTO mai_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ओकर पड़ोसी सभ आ जे लोक सभ ओकरा पहिने भीख मँगैत देखने छलैक कहलक, “की ई वैह नहि अछि जे पहिने बैसले-बैसले भीख मँगैत छल?” ");
INSERT INTO mai_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","किछु लोक कहलक, “हँ, वैह अछि।” दोसर लोक कहलक, “नहि, नहि! ओकरा सनक लगैत छैक लेकिन ओ अछि नहि।” मुदा ओ आदमी अपने कहलक, “हम वैह छी।” ");
INSERT INTO mai_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","तँ ओ सभ ओकरा कहलकैक, “तखन तोहर आँखि कोना खुजि गेलौ?” ");
INSERT INTO mai_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ओ बाजल, “ओ यीशु नामक आदमी माटि सानि कऽ हमरा आँखि पर लगा कऽ कहलनि जे, जाह, शिलोह मे धो लैह। हम गेलहुँ, धो लेलहुँ, आओर देखऽ लगलहुँ।” ");
INSERT INTO mai_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ओ सभ ओकरा पुछलकैक, “ओ कतऽ छथि?” ओ उत्तर देलकैक, “हम नहि जनैत छी।” ");
INSERT INTO mai_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ओ आदमी जे पहिने आन्‍हर छल तकरा फरिसी सभ लग आनल गेलैक। ");
INSERT INTO mai_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","जाहि दिन यीशु माटि सानि कऽ ओकर आँखि खोलने छलथिन, से विश्राम-दिन छल। ");
INSERT INTO mai_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","तेँ फरिसी सभ ओहि आदमी केँ फेर पुछलथिन, “ई कोना भेल जे तोँ आब देखि रहल छह?” ओ बाजल, “ओ माटि सानि कऽ हमरा आँखि पर लगा देलनि, हम धो लेलहुँ, आओर आब देखैत छी।” ");
INSERT INTO mai_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","किछु फरिसी कहऽ लगलाह, “ई व्‍यक्‍ति परमेश्‍वरक दिस सँ नहि आयल अछि, कारण ओ विश्राम-दिन केँ नहि मानैत अछि।” मुदा दोसर सभ कहऽ लगलाह, “जे पापी होयत, से एहन चमत्‍कार वला चिन्‍ह सभ कोना देखा सकत?” एहि तरहेँ हुनका सभ मे मतभेद भऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","आखिर मे ओ सभ ओहि आन्‍हर केँ पुछलथिन, “तोँ ओकरा बारे मे की कहैत छह? तोरे ने आँखि खोलि देलकह।” ओ उत्तर देलकनि, “ओ परमेश्‍वरक प्रवक्‍ता छथि।” ");
INSERT INTO mai_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","मुदा यहूदी सभ तखनो तक नहि पतिअयलाह जे ओ पहिने आन्‍हर छल, और आब देखऽ लागल अछि जखन तक ओ सभ ओकर माय-बाबू केँ बजा कऽ पुछि नहि लेलनि। ");
INSERT INTO mai_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ओ सभ ओकरा सभ सँ पुछलथिन, “की ई तोरे सभक बेटा छह? ई वैह अछि जे तोरा सभक कहबाक अनुसार आन्‍हर जनमल? तँ ई एखन कोना देखि रहल अछि?” ");
INSERT INTO mai_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ओकर माय-बाबू उत्तर देलकनि, “हम सभ जनैत छी जे ई हमरा सभक बालक अछि, और इहो जनैत छी जे आन्‍हर जनमल। ");
INSERT INTO mai_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","मुदा ई एखन कोना देखि रहल अछि, वा एकरा के आँखि खोलि देलथिन, से नहि जनैत छी। ओकरे पुछिऔक। ओ तँ बच्‍चा नहि अछि। ओ अपने कहत।” ");
INSERT INTO mai_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ओकर माय-बाबू ई बात एहि लेल कहलक जे ओ सभ यहूदीक धर्मगुरु सभ सँ डेराइत छल, कारण, यहूदी अधिकारी सभ एकमत भऽ गेल रहय जे, जँ केओ कहत जे यीशु उद्धारकर्ता-मसीह अछि तँ ओकरा सभाघर सँ बारि देल जयतैक। ");
INSERT INTO mai_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","एही कारणेँ ओकर माय-बाबू कहने छलैक जे ओ बच्‍चा नहि अछि, ओकरे पुछिऔक। ");
INSERT INTO mai_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ओ सभ फेर दोसर बेर ओहि आदमी केँ बजौलनि जे आन्‍हर छल, आओर ओकरा कहलथिन, “परमेश्‍वरक समक्ष सत्‍ये बाजह! हम सभ जनैत छी जे ई व्‍यक्‍ति पापी अछि।” ");
INSERT INTO mai_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ओ बाजल, “ओ पापी छथि वा नहि, से हम नहि जनैत छी। मुदा एकटा बात हम जनैत छी—हम पहिने आन्‍हर छलहुँ और एखन देखैत छी।” ");
INSERT INTO mai_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ओ सभ ओकरा पुछलथिन, “ओ तोरा की कयलकह? तोहर आँखि ओ कोना खोललकह?” ");
INSERT INTO mai_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ओ उत्तर देलकनि, “हम अहाँ सभ केँ कहि देने छी, मुदा अहाँ सभ सुनिते नहि छी। अहाँ सभ फेर किएक सुनऽ चाहैत छी? की अहूँ सभ हुनकर शिष्‍य बनऽ चाहैत छी?” ");
INSERT INTO mai_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ओ सभ ओकरा गारि पढ़ैत कहलथिन, “तोँही ओकर शिष्‍य छैं। हम सभ तँ मूसाक शिष्‍य छी। ");
INSERT INTO mai_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","हम सभ जनैत छी जे परमेश्‍वर मूसा सँ बाजल छलथिन, मुदा ई व्‍यक्‍ति जे अछि, से कतऽ सँ आयल तकर कोनो पता नहि।” ");
INSERT INTO mai_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","एहि पर ओ आदमी बाजल, “अरे, ई तँ बड्ड अद्‌भुत बात अछि! अहाँ सभ नहि जनैत छी जे ओ कतऽ सँ आयल छथि, और तैयो ओ हमर आँखि खोलि देलनि। ");
INSERT INTO mai_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","अपना सभ जनैत छी जे परमेश्‍वर पापी सभक नहि सुनैत छथिन। जे हुनका मानैत छनि और हुनकर इच्‍छा पूरा करैत छनि, तकर बात परमेश्‍वर सुनैत छथिन। ");
INSERT INTO mai_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","सृष्‍टिक आरम्‍भ सँ आइ तक ई कहियो सुनबा मे नहि आयल अछि जे केओ कोनो जन्‍म सँ आन्‍हर आदमीक आँखि केँ खोलने होअय। ");
INSERT INTO mai_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ई आदमी जँ परमेश्‍वरक दिस सँ नहि आयल रहितथि तँ ओ किछु नहि कऽ सकितथि।” ");
INSERT INTO mai_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","एहि पर ओ सभ उत्तर देलथिन, “तोँ तँ बिलकुल पापे मे जनमल छैं आ तोँ हमरा सभ केँ सिखाबऽ चाहैत छैं?!” ई कहि ओकरा बाहर भगा देलनि। ");
INSERT INTO mai_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","यीशु जखन सुनलनि जे ओ सभ ओकरा भगा देने छैक तँ ओकरा भेँट कऽ कऽ पुछलथिन, “की तोँ मनुष्‍य-पुत्र पर विश्‍वास करैत छह?” ");
INSERT INTO mai_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ओ उत्तर देलकनि, “मालिक, ओ के छथि? हमरा कहल जाओ, जाहि सँ हम हुनका पर विश्‍वास करियनि।” ");
INSERT INTO mai_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","यीशु ओकरा कहलथिन, “तोँ हुनका देखने छहुन और ओ वैह छथि जे एखनो तोरा सँ बात कऽ रहल छथुन।” ");
INSERT INTO mai_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ओ कहलकनि, “प्रभु, हम विश्‍वास करैत छी!” और हुनकर पयर पर खसि कऽ गोड़ लगलकनि। ");
INSERT INTO mai_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","यीशु बजलाह, “हम एहि संसार मे न्‍यायक लेल आयल छी, जाहि सँ जे सभ नहि देखैत अछि, से सभ देखय, और जे सभ देखैत अछि, से सभ आन्‍हर भऽ जाय।” ");
INSERT INTO mai_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","किछु फरिसी जे हुनका लग मे ठाढ़ छलाह, से ई बात सुनि कहलथिन, “तँ हमहूँ सभ आन्‍हर छी की?” ");
INSERT INTO mai_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","यीशु हुनका सभ केँ कहलथिन, “अहाँ सभ जँ आन्‍हर रहितहुँ, तँ दोषी नहि होइतहुँ, मुदा अहाँ सभ कहैत छी जे, हम सभ देखैत छी, आ तेँ अहाँ सभ दोषी रहलहुँ।” ");
INSERT INTO mai_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“हम अहाँ सभ केँ विश्‍वास दिअबैत छी जे, जे द्वारि बाटे भेँड़शाला मे प्रवेश नहि करैत अछि, बल्‍कि देवाल पर चढ़ि कऽ कोनो दोसर बाटे प्रवेश करैत अछि, से चोर और डाकू होइत अछि। ");
INSERT INTO mai_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","जे द्वारि बाटे प्रवेश करैत छथि, से भेँड़ाक चरबाह छथि। ");
INSERT INTO mai_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","हुनका लेल द्वारपाल द्वारिक फट्टक खोलि दैत छनि, और हुनकर आवाज भेँड़ा चिन्‍हैत छनि। ओ अपना भेँड़ा केँ नाम लऽ-लऽ कऽ बजबैत छथि, और ओकरा सभ केँ बाहर लऽ जाइत छथि। ");
INSERT INTO mai_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","अपन सभ भेँड़ा केँ निकालि लेला पर ओ ओकरा सभक आगाँ-आगाँ चलैत छथि और ओ सभ हुनका पाछाँ लागि जाइत छनि किएक तँ ओ सभ हुनकर आवाज केँ चिन्‍हैत छनि। ");
INSERT INTO mai_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ओ सभ कोनो अपरिचित आदमीक पाछाँ कहियो नहि जायत, बल्‍कि ओकरा लग सँ भागत, किएक तँ अपरिचित लोकक आवाज ओ सभ नहि चिन्‍हैत छैक।” ");
INSERT INTO mai_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","यीशु हुनका सभ केँ ई उदाहरण देलनि, मुदा हुनकर की कहबाक अर्थ छलनि, से ओ सभ नहि बुझलनि। ");
INSERT INTO mai_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","तेँ ओ हुनका सभ केँ फेर कहलथिन, “हम अहाँ सभ केँ सत्‍ये कहैत छी जे, भेँड़ा सभक लेल हमहीं द्वारि छी। ");
INSERT INTO mai_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","आरो सभ जे हमरा सँ पहिने आयल, से चोर और डाकू सभ छल, मुदा भेँड़ा ओकरा सभक बात नहि मानलक। ");
INSERT INTO mai_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","द्वारि हम छी। हमरा बाटे जे प्रवेश करत से सुरक्षित राखल जायत। ओ भीतर-बाहर अबैत-जाइत रहत और चारा पाओत। ");
INSERT INTO mai_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","चोर खाली चोरी करबाक, जान मारबाक, और नष्‍ट करबाक उद्देश्‍य सँ अबैत अछि। मुदा हम एहि लेल आयल छी जे मनुष्‍य जीवन प्राप्‍त करय और परिपूर्णता सँ प्राप्‍त करय। ");
INSERT INTO mai_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“नीक चरबाह हम छी। नीक चरबाह भेँड़ाक लेल अपन प्राण दैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","जऽन-बोनिहार, जे ने चरबाह अछि आ ने भेँड़ाक मालिक अछि से चितुआ केँ अबैत देखि कऽ भेँड़ा सभ केँ छोड़ि कऽ भागि जाइत अछि। तखन चितुआ भेँड़ा केँ पकड़ऽ लगैत छैक और ओकरा सभ केँ छिड़िया दैत छैक। ");
INSERT INTO mai_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","जऽन-बोनिहार एहि लेल भागि जाइत अछि जे ओ खाली जऽन अछि और ओकरा भेँड़ाक लेल कोनो चिन्‍ता नहि रहैत छैक। ");
INSERT INTO mai_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“नीक चरबाह हम छी। जहिना पिता हमरा चिन्‍हैत छथि और हम पिता केँ चिन्‍हैत छियनि, ");
INSERT INTO mai_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","तहिना हम अपना भेँड़ा सभ केँ चिन्‍हैत छी और ओ सभ हमरा चिन्‍हैत अछि। और भेँड़ा सभक लेल हम अपन प्राण दैत छी। ");
INSERT INTO mai_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","हमरा आरो भेँड़ा अछि जे एहि भेँड़शालाक नहि अछि। ओकरो सभ केँ हमरा लयबाक अछि। ओहो सभ हमर आवाज सुनत। तखन एके झुण्‍ड और एके चरबाह होयत। ");
INSERT INTO mai_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“पिता हमरा सँ एहि लेल प्रेम करैत छथि जे हम अपन प्राण दैत छी जाहि सँ हम ओकरा फेर लऽ ली। ");
INSERT INTO mai_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","केओ हमर प्राण केँ हमरा सँ नहि छिनि लैत अछि, बल्‍कि हम अपना इच्‍छा सँ दऽ रहल छी। हमरा अपन जान देबाक अधिकार अछि और ओकरा फेर लऽ लेबाक अधिकार सेहो अछि। ई आज्ञा हम अपना पिता सँ प्राप्‍त कयने छी।” ");
INSERT INTO mai_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","एहि बात सभक कारणेँ यहूदी सभ मे फेर मतभेद भऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","बहुत लोक कहैत छलाह, “एकरा मे दुष्‍टात्‍मा छैक। ई बताह अछि! एकर बात किएक सुनबैक?” ");
INSERT INTO mai_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","मुदा दोसर सभ कहैत छलाह, “जकरा मे दुष्‍टात्‍मा छैक, से की एहन बात सभ कहत? की दुष्‍टात्‍मा कतौ आन्‍हरक आँखि खोलि सकैत अछि?” ");
INSERT INTO mai_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","तखन यरूशलेम मे “मन्‍दिरक समर्पण” नामक पाबनि आबि गेल। ");
INSERT INTO mai_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","जाड़क मास छल, और यीशु मन्‍दिर मे ओहि असोरा पर टहलैत छलाह जे “सुलेमानक असोरा” कहबैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","यहूदी सभ हुनका चारू कात सँ घेरि कऽ कहलथिन, “कहिया तक अहाँ हमरा सभ केँ दुबिधा मे रखने रहब? अहाँ जँ परमेश्‍वरक मसीह छी तँ हमरा सभ केँ स्‍पष्‍ट कहि दिअ।” ");
INSERT INTO mai_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","यीशु बजलाह, “हम अहाँ सभ केँ कहिए देने छी, मुदा अहाँ सभ विश्‍वास नहि करैत छी। जे काज हम अपना पिताक नाम सँ करैत छी, से हमर गवाही दैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","मुदा अहाँ सभ विश्‍वास नहि करैत छी किएक तँ अहाँ सभ हमर भेँड़ा नहि छी। ");
INSERT INTO mai_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","हमर भेँड़ा हमर आवाज सुनैत अछि। हम ओकरा सभ केँ चिन्‍हैत छी और ओ सभ हमरा पाछाँ लागि जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","हम ओकरा सभ केँ अनन्‍त जीवन दैत छी और ओ सभ कहियो नाश नहि होयत। हमरा हाथ सँ केओ ओकरा सभ केँ नहि छिनि लेत। ");
INSERT INTO mai_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","हमर पिता, जे ओकरा सभ केँ हमरा देने छथि, से आरो सभ सँ शक्‍तिशाली छथि, तेँ हमरा पिताक हाथ सँ ओकरा सभ केँ केओ नहि छिनि सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","हम और पिता एक छी।” ");
INSERT INTO mai_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","एहि पर यहूदी सभ फेर हुनका मारि देबाक लेल पाथर उठाबऽ लगलाह, ");
INSERT INTO mai_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","मुदा यीशु हुनका सभ केँ कहलथिन, “हम अहाँ सभ केँ पिताक तरफ सँ बहुत नीक-नीक काज कऽ कऽ देखा देलहुँ। एहि सभ मे सँ कोन काजक लेल हमरा मारि देबऽ चाहैत छी?” ");
INSERT INTO mai_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहूदी सभ हुनका उत्तर देलथिन, “कोनो नीक काजक लेल तोरा नहि मारऽ चाहैत छिऔ, बल्‍कि परमेश्‍वरक निन्‍दाक लेल, कारण तोँ मनुष्‍ये भऽ कऽ अपना केँ परमेश्‍वर कहैत छैं।” ");
INSERT INTO mai_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","यीशु बजलाह, “की अहाँ सभक धर्मशास्‍त्र मे नहि लिखल अछि जे, ‘हम कहलहुँ जे तोँ सभ ईश्‍वर छह’? ");
INSERT INTO mai_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","जँ तकरा सभ केँ ओ ‘ईश्‍वर’ कहलथिन जकरा सभ केँ परमेश्‍वरक वचन देल गेल—और धर्मशास्‍त्र कहियो गलत नहि ठहरि सकैत अछि— ");
INSERT INTO mai_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","तँ जकरा पिता अपना पवित्र काजक लेल चुनि कऽ संसार मे पठौलथिन, तकरा पर परमेश्‍वरक निन्‍दा करबाक दोष किएक लगबैत छी जखन ओ कहैत अछि जे, ‘हम परमेश्‍वरक पुत्र छी’? ");
INSERT INTO mai_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","जँ हम अपना पिताक काज नहि कऽ रहल छी, तँ हमरा पर विश्‍वास नहि करू। ");
INSERT INTO mai_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","मुदा जँ हम कऽ रहल छी, तँ हमरा पर जँ नहिओ विश्‍वास करब, तँ हमर काज पर विश्‍वास करू, जाहि सँ अहाँ सभ जानब और बुझब जे पिता हमरा मे छथि और हम पिता मे छी।” ");
INSERT INTO mai_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ओ सभ हुनका फेर पकड़ऽ चाहैत छलनि, मुदा ओ हुनका सभक हाथ सँ बचि कऽ निकलि गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","तखन यीशु फेर यरदन नदीक ओहि पार गेलाह जाहिठाम यूहन्‍ना शुरू मे बपतिस्‍मा दैत छलाह। ओ ओहिठाम रहलाह ");
INSERT INTO mai_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","और बहुत लोक हुनका लग आयल। ओ सभ कहलक, “ओना तँ यूहन्‍ना कोनो चमत्‍कारपूर्ण चिन्‍ह नहि देखौलनि, तैयो जतेक बात ओ एहि व्‍यक्‍तिक बारे मे कहलनि, से सभ सत्‍य छल।” ");
INSERT INTO mai_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","और ओहिठाम बहुत लोक यीशु पर विश्‍वास कयलकनि। ");
INSERT INTO mai_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","एक लाजर नामक आदमी, जे बेतनिया गामक छलाह, बहुत बिमार भऽ गेल छलाह। बेतनिया गाम मरियम आओर हुनकर बहिन मार्थाक गाम छल। ");
INSERT INTO mai_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ई मरियम वैह छथि जे यीशुक पयर पर सुगन्‍धित तेल ढारि कऽ हुनकर पयर अपना केश लऽ कऽ पोछि देलनि। तँ लाजर एहि मरियमक भाय छलाह। ");
INSERT INTO mai_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","दूनू बहिन यीशु केँ खबरि पठा देलनि जे, “प्रभु, अहाँक प्रिय मित्र बिमार अछि।” ");
INSERT INTO mai_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","यीशु ई सुनि कऽ बजलाह, “एहि बिमारीक अन्‍त मृत्‍यु नहि होयत। ई एहि लेल भेल जे परमेश्‍वरक महिमा प्रगट होयतनि, और जाहि सँ एहि द्वारा परमेश्‍वरक पुत्रक महिमा प्रगट होयत।” ");
INSERT INTO mai_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","यीशु मार्था, हुनकर बहिन मरियम, और लाजर सँ बहुत प्रेम करैत छलथिन, ");
INSERT INTO mai_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","मुदा तैयो ई खबरि जखन सुनलनि, जे लाजर बिमार छथि, तखन ओ जाहिठाम छलाह ताहिठाम दू दिन आओर रहि गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","तखन ओ अपन शिष्‍य सभ केँ कहलथिन, “आब फेर यहूदिया प्रदेश चलू।” ");
INSERT INTO mai_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ओ सभ कहलथिन, “गुरुजी, किछुए दिन पहिने यहूदी सभ पाथर मारि कऽ अहाँ केँ मारि देबऽ चाहैत छलाह, आ तैयो अहाँ ओतऽ फेर जाय चाहैत छी?” ");
INSERT INTO mai_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","यीशु बजलाह, “की दिन मे बारह घण्‍टा नहि होइत छैक? जँ केओ दिन मे चलैत अछि तँ ओकरा ठेस नहि लगैत छैक, कारण ओ एहि संसारक इजोत केँ देखैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","मुदा राति मे जँ चलैत अछि तँ ठेस लगैत छैक कारण ओकरा कोनो इजोत नहि छैक।” ");
INSERT INTO mai_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ई कहि यीशु हुनका सभ केँ आगाँ कहलथिन, “अपना सभक मित्र लाजर सुति रहलाह, मुदा हम हुनका जगयबाक लेल जाइत छी।” ");
INSERT INTO mai_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","शिष्‍य सभ हुनका कहलथिन, “प्रभु, जँ ओ सुति रहल छथि तँ ओ नीकैं भऽ जयताह।” ");
INSERT INTO mai_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","यीशु हुनकर मृत्‍युक सम्‍बन्‍ध मे ई कहने छलथिन मुदा शिष्‍य सभ बुझलनि जे ओ स्‍वभाविक निन्‍दक सम्‍बन्‍ध मे कहि रहल छथि। ");
INSERT INTO mai_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","तखन यीशु हुनका सभ केँ स्‍पष्‍ट कहलथिन, “लाजर मरि गेल छथि। ");
INSERT INTO mai_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","और अहाँ सभक कारणेँ हमरा खुशी अछि जे हम ओतऽ नहि छलहुँ, जाहि सँ अहाँ सभ विश्‍वास करी। मुदा आउ, अपना सभ आब हुनका लग चली।” ");
INSERT INTO mai_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","तखन थोमा, जे “जौंआ” कहबैत छथि, से आरो शिष्‍य सभ केँ कहलथिन, “आउ, अपनो सभ हिनका संग मरऽ लेल चली।” ");
INSERT INTO mai_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ओतऽ पहुँचला पर यीशु केँ पता लगलनि जे लाजर केँ कबर मे रखला चारि दिन भऽ गेल अछि। ");
INSERT INTO mai_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बेतनिया यरूशलेम सँ एक कोस सँ कनेक कम दूर छल, ");
INSERT INTO mai_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","और बहुत यहूदी लोक मार्था आओर मरियमक भायक मरला पर सान्‍त्‍वना देबाक लेल हुनका सभक ओहिठाम आयल छलनि। ");
INSERT INTO mai_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","मार्था जखन सुनलनि जे यीशु आबि रहल छथि तँ हुनका भेँट करऽ गेलीह, लेकिन मरियम घर मे बैसल रहलीह। ");
INSERT INTO mai_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मार्था यीशु केँ कहलथिन, “प्रभु, अहाँ जँ एतऽ रहितहुँ तँ हमर भाय नहि मरल रहैत। ");
INSERT INTO mai_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","मुदा हम जनैत छी जे एखनो अहाँ जे किछु परमेश्‍वर सँ मँगबनि, से अहाँ केँ ओ देताह।” ");
INSERT INTO mai_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","यीशु बजलाह, “अहाँक भाय फेर जीबि उठत।” ");
INSERT INTO mai_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मार्था बजलीह, “हम जनैत छी जे अन्‍तिम दिन मे जखन मुइल सभ जीबि उठत तखन ओहो जीबि उठत।” ");
INSERT INTO mai_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","यीशु हुनका कहलथिन, “जीबि उठाबऽ वला और जीवन देबऽ वला हमहीं छी। जे केओ हमरा पर विश्‍वास करैत अछि, से जँ मरिओ जायत, तैयो जीअत। ");
INSERT INTO mai_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","और जे केओ हमरा मे जीबैत अछि और विश्‍वास करैत अछि, से कहियो नहि मरत। की एहि पर विश्‍वास करैत छी?” ");
INSERT INTO mai_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","मार्था हुनका उत्तर देलथिन, “हँ प्रभु, हम विश्‍वास करैत छी जे अहाँ उद्धारकर्ता-मसीह छी, परमेश्‍वरक पुत्र छी, जे संसार मे आबऽ वला छलाह।” ");
INSERT INTO mai_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ई कहि ओ अपन बहिन मरियम केँ बजयबाक लेल गेलीह, और हुनका अलग लऽ जा कऽ कहलथिन, “गुरुजी आबि गेलाह, तोरा बजबैत छथुन।” ");
INSERT INTO mai_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ई बात सुनितहि, मरियम जल्‍दी सँ उठि कऽ हुनका लग गेलीह। ");
INSERT INTO mai_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","यीशु एखन गाम मे नहि आयल छलाह, बल्‍कि ओहि स्‍थान पर छलाह जाहिठाम मार्था हुनका सँ भेँट कयने छलीह। ");
INSERT INTO mai_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","यहूदी सभ, जे मरियम केँ सान्‍त्‍वना दैत हुनका संग घर मे छलनि, से सभ जखन हुनका जल्‍दी उठि बाहर जाइत देखलकनि, तँ हुनका पाछाँ-पाछाँ गेल, ई बुझि कऽ जे ओ कबर पर विलाप करऽ जा रहल छथि। ");
INSERT INTO mai_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","मरियम जखन ओहिठाम पहुँचलीह जाहिठाम यीशु छलाह, तँ हुनका देखि हुनका पयर पर खसि कऽ बजलीह, “प्रभु, अहाँ जँ एतऽ रहितहुँ तँ हमर भाय नहि मरैत।” ");
INSERT INTO mai_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","यीशु जखन हुनका विलाप करैत देखलथिन, और यहूदी सभ, जे हुनका संग आयल छल, तकरो सभ केँ विलाप करैत देखलनि तँ हुनका बहुत दुःख भेलनि और ओ व्‍याकुल भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ओ पुछलथिन, “हुनका कतऽ रखने छिऐन?” ओ सभ उत्तर देलथिन, “प्रभु, चलि कऽ देखि लिअ।” ");
INSERT INTO mai_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","यीशु कानऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","तखन यहूदी सभ कहलक, “देखू, ओकरा सँ कतेक प्रेम करैत छलथिन।” ");
INSERT INTO mai_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","मुदा ओकरा सभ मे सँ किछु लोक कहलक, “ई जे आन्‍हर केँ आँखि खोलि देलथिन, से की एहि आदमीक मरनाइ नहि रोकि सकलाह?” ");
INSERT INTO mai_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","यीशु फेर बहुत दुखी भऽ कऽ कबर लग गेलाह। ओ कबर एक गुफा छल, जकरा दुआरि पर एकटा बड़का पाथर राखल छलैक। ");
INSERT INTO mai_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","यीशु कहलथिन, “पाथर हटा दिअ!” मृतकक बहिन, मार्था, हुनका कहलथिन, “प्रभु, आब बहुत महकैत होयत। ओकरा मरला तँ चारि दिन भऽ गेल छैक।” ");
INSERT INTO mai_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","यीशु बजलाह, “की, हम अहाँ केँ नहि कहलहुँ जे जँ अहाँ विश्‍वास करब तँ परमेश्‍वरक महिमा देखब?” ");
INSERT INTO mai_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","तखन ओ सभ पाथर हटा देलनि, और यीशु ऊपर ताकि कऽ कहलनि, “पिता, हम अहाँ केँ धन्‍यवाद दैत छी जे अहाँ हमर सुनि लेने छी। ");
INSERT INTO mai_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ओना तँ हम जनैत छी जे अहाँ सदिखन हमर सुनि लैत छी, मुदा हम ई बात एहिठाम ठाढ़ भेल लोकक कारणेँ कहलहुँ, जाहि सँ ओ सभ विश्‍वास करय जे अहाँ हमरा पठौने छी।” ");
INSERT INTO mai_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ई बात कहि, यीशु जोर सँ सोर पारलनि, “लाजर! बाहर निकलि आउ!” ");
INSERT INTO mai_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","और ओ मृतक बाहर निकलि अयलाह। हुनकर हाथ-पयर पट्टी सँ बान्‍हल छलनि, और हुनकर मुँह अंगपोछा सँ लेपटल छलनि। यीशु लोक सभ केँ कहलथिन, “हुनका खोलि दिऔन और जाय दिऔन।” ");
INSERT INTO mai_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","एहि कारणेँ यहूदी सभ जे मरियम सँ भेँट करबाक लेल आयल छल, और जे यीशुक ई काज देखने छल, तकरा सभ मे सँ बहुतो हुनका पर विश्‍वास कयलकनि। ");
INSERT INTO mai_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","मुदा किछु यहूदी सभ फरिसी सभक ओहिठाम जा कऽ कहि देलकैक जे यीशु की कयलनि। ");
INSERT INTO mai_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","तेँ मुख्‍यपुरोहित और फरिसी सभ धर्म-महासभाक सदस्‍य सभ केँ बजा लेलनि। ओ सभ आपस मे कहऽ लगलाह, “अपना सभ की कऽ रहल छी? ई तँ बहुत चमत्‍कारपूर्ण चिन्‍ह देखा रहल अछि! ");
INSERT INTO mai_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","एकरा ई सभ करैत छोड़ि देबैक तँ एकरा पर सभ केओ विश्‍वास करतैक, और रोमी सभ आबि कऽ अपना सभक पवित्र स्‍थान और राष्‍ट्र दूनू नष्‍ट कऽ देत।” ");
INSERT INTO mai_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","तखन हुनका सभ मे सँ काइफा नामक एक गोटे, जे ओहि वर्षक महापुरोहित छलाह से बजलाह, “अहाँ सभ किछुओ नहि जनैत छी! ");
INSERT INTO mai_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","अहाँ सभ केँ फुरयबो नहि करैत अछि जे अहाँ सभ केँ की नीक होइत। नीक तँ ई होइत जे एके आदमी जनताक लेल मरैक, और ई नहि जे पूरा राष्‍ट्र नाश भऽ जाय।” ");
INSERT INTO mai_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ई बात ओ अपने सँ नहि, बल्‍कि ओहि वर्षक महापुरोहित होयबाक कारणेँ कहलनि, मुदा हुनको नहि बुझल छलनि जे ई भविष्‍यवाणी भऽ गेल जे यीशु यहूदी राष्‍ट्रक बदला मे मरताह, ");
INSERT INTO mai_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","और मात्र ओहि राष्‍ट्रक लेल नहि, बल्‍कि परमेश्‍वरक एम्‍हर-ओम्‍हर छिड़िआयल सन्‍तानक लेल सेहो, जाहि सँ ओ ओकरा सभ केँ एक ठाम जमा कऽ कऽ एक करथि। ");
INSERT INTO mai_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","तँ ओहि दिन सँ ओ सभ हुनका जान सँ मारि देबाक षड्‌यन्‍त्र करऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","फलस्‍वरूप यीशु आब यहूदी सभक बीच मे खुलि कऽ नहि घुमैत छलाह। ओ निर्जन क्षेत्रक कात मे इफ्राइम नामक गाम मे जा कऽ ओतहि अपना शिष्‍य सभक संग रहऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","जखन यहूदी सभक फसह-पाबनि लग आबि गेल तखन बहुत लोक अपना केँ शुद्ध करबाक विधिक लेल पाबनि सँ पहिनहि देहात सँ यरूशलेम आयल। ");
INSERT INTO mai_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ओ सभ यीशु केँ तकैत छलनि, और मन्‍दिर मे ठाढ़ एक-दोसर सँ पुछैत छल जे, “अहाँ की सोचैत छी? ओ पाबनिक लेल नहिए औताह की?” ");
INSERT INTO mai_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","कारण मुख्‍यपुरोहित और फरिसी सभ आज्ञा देने छलाह जे, जँ ककरो पता लागि जाइक जे यीशु कतऽ छथि तँ ओ हुनका सभ केँ सूचना दऽ दिअय, जाहि सँ ओ सभ हुनका पकड़ि सकथि। ");
INSERT INTO mai_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","फसह-पाबनि सँ छओ दिन पहिने, यीशु बेतनिया गाम अयलाह, जाहिठाम लाजर रहैत छलाह, जिनका मरलाक बाद यीशु जीवित कऽ देने रहथिन। ");
INSERT INTO mai_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ओहिठाम यीशुक अयबाक खुशी मे भोज कयल गेल। मार्था सेवा-सत्‍कारक काज मे लागल छलीह, और यीशुक संग भोजन करऽ वला सभ मे लाजर सेहो बैसल छलाह। ");
INSERT INTO mai_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","तखन मरियम विशुद्ध जटामासीक लगभग आधा सेर बहुत दामी सुगन्‍धित तेल लऽ यीशुक पयर पर ढारि देलनि और हुनकर पयर अपना केश सँ पोछि देलथिन। ओहि तेलक सुगन्‍ध सँ सौंसे घर गमकि उठल। ");
INSERT INTO mai_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","मुदा हुनकर एकटा शिष्‍य, यहूदा इस्‍करियोती, जे बाद मे हुनका संग विश्‍वासघात करऽ वला भेल, से बाजल, ");
INSERT INTO mai_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ई तेल किएक नहि बेचि देल गेल? एहि सँ एक वर्षक मजदूरीक बराबरि मूल्‍य भेटैत, आ गरीब सभ मे बाँटल गेल रहैत!” ");
INSERT INTO mai_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ओ ई बात एहि लेल नहि कहलक जे ओकरा गरीब सभक लेल चिन्‍ता छलैक, बल्‍कि एहि लेल जे ओ चोर छल। ओकरा लग हुनका सभक पाइक बटुआ रहैत छलैक, और ओहि मे जे किछु राखल जाइत छल, ताहि मे सँ ओ चोरा लैत छल। ");
INSERT INTO mai_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","यीशु उत्तर देलथिन, “हिनका छोड़ि दिऔन! हम जे कबर मे राखल जायब तकर तैयारीक लेल हिनका ई तेल रखने रहबाक छलनि। ");
INSERT INTO mai_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","गरीब सभ तँ अहाँ सभक संग सभ दिन रहत, मुदा हम अहाँ सभक संग सभ दिन नहि रहब।” ");
INSERT INTO mai_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","जखन यहूदी सभक बड़का भीड़ केँ पता लगलैक जे यीशु एतऽ छथि, तँ ओ सभ देखबाक लेल आयल, मुदा खाली यीशुए केँ देखबाक लेल नहि, बल्‍कि लाजर केँ सेहो, जिनका मरलाक बाद यीशु जीवित कयने रहथिन। ");
INSERT INTO mai_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","तखन मुख्‍यपुरोहित सभ लाजर केँ सेहो खून कऽ देबाक योजना बनाबऽ लगलाह, ");
INSERT INTO mai_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","किएक तँ हुनके कारण बहुत यहूदी अपना धर्मगुरु सभ केँ छोड़ि कऽ यीशु पर विश्‍वास करैत छलनि। ");
INSERT INTO mai_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","दोसरे दिन बड़का भीड़ जे पाबनिक लेल आयल छल, से सुनलक जे यीशु यरूशलेम आबि रहल छथि। ");
INSERT INTO mai_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ओ सभ खजूरक छज्‍जा लऽ कऽ हुनका सँ भेँट करबाक लेल शहर सँ बहरायल। ओ सभ हुनकर जयजयकार करैत छल, “जय जय! धन्‍य छथि ओ जे प्रभुक नाम सँ अबैत छथि! धन्‍य छथि इस्राएलक राजा!” ");
INSERT INTO mai_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","यीशु एक गदहीक बच्‍चा पर बैसल छलाह, जेना धर्मशास्‍त्रक लेख अछि, ");
INSERT INTO mai_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“हे सियोन नगर! भयभीत नहि होअह! देखह! तोहर राजा गदहीक बच्‍चा पर बैसल आबि रहल छथुन!” ");
INSERT INTO mai_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","एहि समय मे हुनकर शिष्‍य सभ ई सभ बात नहि बुझलनि, मुदा यीशु जखन स्‍वर्गक महिमा मे उठा लेल गेलाह तखन हुनका सभ केँ मोन पड़लनि जे ई सभ बात यीशुएक बारे मे लिखल गेल छल और हुनका संग तहिना कयलो गेलनि। ");
INSERT INTO mai_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","जे लोक सभ ओहि समय मे यीशुक संग छल जखन ओ लाजर केँ कबर मे सँ बहरयबाक लेल कहि कऽ जीवित कऽ देने रहथिन, से सभ एहि बातक बारे मे सभ लोक केँ कहैत छल। ");
INSERT INTO mai_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","एहि कारणेँ एतेक लोक यीशु सँ भेटबाक लेल बहरायल छल। ओ सभ सुनने छल जे यीशु ई चमत्‍कारपूर्ण चिन्‍ह देखौने छथि। ");
INSERT INTO mai_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","तेँ फरिसी सभ एक-दोसर केँ कहऽ लगलाह, “देखैत छी कि नहि! अहाँ सभ जे कऽ रहल छी ताहि सँ कनेको फायदा नहि! देखू! सौंसे संसार ओकरा पाछाँ दौड़ि रहल छैक!” ");
INSERT INTO mai_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","जे लोक पाबनि मे आराधना करबाक लेल आयल छल, ताहि मे किछु लोक यूनानी जातिक छल। ");
INSERT INTO mai_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ओ सभ फिलिपुस लग आयल, जे गलील प्रदेशक बेतसैदा नगरक छलाह। ओ सभ हुनका सँ ई निवेदन कयलकनि, “मालिक, हम सभ यीशु केँ देखितहुँ।” ");
INSERT INTO mai_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","फिलिपुस जा कऽ अन्‍द्रेयास केँ कहि देलनि, और अन्‍द्रेयास फिलिपुसक संग जा कऽ यीशु केँ कहलनि। ");
INSERT INTO mai_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","यीशु बजलाह, “मनुष्‍य-पुत्रक महिमा प्रगट होयबाक घड़ी आबि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","हम अहाँ सभ केँ सत्‍ये कहैत छी जे, जाबत धरि गहुमक दाना जमीन मे खसि कऽ मरि नहि जाइत अछि, ताबत धरि ओ असगर रहैत अछि। मुदा जँ मरि जायत, तँ आओर बहुत दाना केँ उत्‍पादन करत। ");
INSERT INTO mai_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","जे अपना जीवन केँ प्रिय बुझैत अछि, से ओकरा गमबैत अछि, और जे एहि संसार मे अपना जीवन केँ तुच्‍छ बुझैत अछि, से ओकरा अनन्‍त जीवनक लेल सुरक्षित रखैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","जे हमर सेवा करत, से हमरा पाछाँ आबय। और हम जतऽ होयब, ततऽ हमर सेवक सेहो होयत। जे केओ हमर सेवा करत, तकरा हमर पिता आदर करथिन। ");
INSERT INTO mai_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“आब हमर आत्‍मा अति व्‍याकुल भऽ गेल अछि। हम की कहू?—ई जे, ‘यौ पिता, एहि घड़ी सँ हमरा बचाउ!’? नहि! हम तँ एही लेल एहि घड़ी तक आयल छी! ");
INSERT INTO mai_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","यौ पिता, अपन नामक महिमा केँ प्रगट करू!” एहि पर स्‍वर्ग सँ ई आवाज सुनाइ देलक जे, “हम ओकरा प्रगट कयने छी और फेर प्रगट करब।” ");
INSERT INTO mai_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","लग मे ठाढ़ भेल भीड़ ई सुनलक और कहलक, “मेघ बाजल।” दोसर लोक कहलक, “हुनका सँ स्‍वर्गदूत बजलनि।” ");
INSERT INTO mai_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","यीशु बजलाह, “ई आवाज हमरा लेल नहि, अहीं सभक लेल भेल। ");
INSERT INTO mai_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","आब एहि संसारक न्‍यायक समय आबि गेल अछि, आब एहि संसारक शासक केँ पराजित कऽ देल जयतैक। ");
INSERT INTO mai_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","मुदा हम जखन पृथ्‍वीक उपर लटकाओल जायब तँ हम अपना लग सभ लोक केँ खीचि लेब।” ");
INSERT INTO mai_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ओ ई कहि कऽ संकेत कऽ देलथिन जे हुनकर मृत्‍यु कोन तरहक होयतनि। ");
INSERT INTO mai_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","एहि पर भीड़क लोक बाजल, “हम सभ धर्म-नियम सँ सिखने छी जे उद्धारकर्ता-मसीह अनन्‍त काल तक रहताह। तँ अहाँ कोना कहैत छी जे मनुष्‍य-पुत्रक ऊपर लटकाओल जयनाइ आवश्‍यक अछि? की मनुष्‍य-पुत्र आ उद्धारकर्ता-मसीह दूनू एके नहि छथि?” ");
INSERT INTO mai_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","यीशु ओकरा सभ केँ कहलनि, “इजोत कनेके काल आओर अहाँ सभक बीच मे अछि। जा धरि इजोत अछि ता धरि चलिते रहू, नहि तँ अन्‍हार अहाँ सभ केँ लपकि लेत। जे अन्‍हार मे चलैत अछि, से नहि जनैत अछि जे ओ कतऽ जा रहल अछि। ");
INSERT INTO mai_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","जा धरि इजोत अहाँ सभक संग अछि, इजोत पर विश्‍वास राखू, जाहि सँ इजोतक सन्‍तान बनब।” यीशु ई सभ बात कहि कऽ चल गेलाह और ओकरा सभ सँ नुका रहलाह। ");
INSERT INTO mai_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ओकरा सभक समक्ष मे एतेक चमत्‍कारपूर्ण चिन्‍ह देखौलाक बादो, ओ सभ यीशु पर विश्‍वास नहि करैत छल। ");
INSERT INTO mai_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ई एहि लेल भेल जे परमेश्‍वरक प्रवक्‍ता यशायाहक ई कथन पूरा होअय जे, “यौ प्रभु, हमरा सभ द्वारा सुनाओल गेल उपदेशक बात पर के विश्‍वास कयने अछि? और प्रभुक बल ककरा पर प्रगट भेल छैक?” ");
INSERT INTO mai_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","तेँ ओ सभ विश्‍वास नहि कऽ सकल, कारण, जेना यशायाह दोसर ठाम कहैत छथि, ");
INSERT INTO mai_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“प्रभु ओकरा सभक आँखि आन्‍हर कऽ देने छथिन, और ओकरा सभक मोन कठोर कऽ देने छथिन, जाहि सँ ओ सभ ने आँखि सँ देखय, ने मोन सँ बुझय, आ ने हमरा दिस घूमि कऽ आबय कि हम ओकरा सभ केँ स्‍वस्‍थ कऽ दिऐक।” ");
INSERT INTO mai_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यशायाह ई बात कहलनि किएक तँ ओ यीशुक महिमा देखलनि और हुनका बारे मे बजलाह। ");
INSERT INTO mai_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ई बात होइतो यहूदी सभक अधिकारी सभ मे सँ सेहो बहुत गोटे हुनका पर विश्‍वास कयलनि, मुदा फरिसी सभक कारणेँ ओ सभ अपना विश्‍वास केँ खुलि कऽ स्‍वीकार नहि कयलनि, एहि डरेँ जे सभाघर सँ बारि देल जाएब, ");
INSERT INTO mai_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","कारण ओ सभ परमेश्‍वरक प्रशंसा सँ मनुष्‍यक प्रशंसा प्रिय बुझैत छलाह। ");
INSERT INTO mai_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","तखन यीशु जोर सँ कहलनि, “जे केओ हमरा पर विश्‍वास करैत अछि, से हमरे पर नहि, बल्‍कि हमरा जे पठौलनि, तिनको पर विश्‍वास करैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","और जे हमरा देखैत अछि, से तिनका देखैत छनि जे हमरा पठौलनि। ");
INSERT INTO mai_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","हम इजोत भऽ कऽ संसार मे आयल छी जाहि सँ जे केओ हमरा पर विश्‍वास करत से अन्‍हार मे नहि रहय। ");
INSERT INTO mai_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“हमर वचन जँ केओ सुनैत अछि, लेकिन मानैत नहि अछि, तँ हम ओकर न्‍याय नहि करैत छी, कारण हम संसारक न्‍याय करबाक लेल नहि अयलहुँ, बल्‍कि ओकरा बचयबाक लेल। ");
INSERT INTO mai_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","जे हमरा अस्‍वीकार करैत अछि और हमर वचन ग्रहण नहि करैत अछि, तकर न्‍याय करऽ वला एक अछि—जे वचन हम कहने छी, वैह अन्‍तिम दिन मे ओकर न्‍याय करतैक। ");
INSERT INTO mai_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","कारण हम अपना दिस सँ नहि बजलहुँ, बल्‍कि जे पिता हमरा पठौलनि सैह हमरा आदेश देलनि जे हम की कही और कोना बाजी। ");
INSERT INTO mai_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","और हम जनैत छी जे हुनकर आदेश अनन्‍त जीवन अछि। तेँ हम जे किछु बजैत छी, से वैह अछि जे ओ हमरा बजबाक लेल कहने छथि।” ");
INSERT INTO mai_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","फसह-भोज सँ पहिनेक समय छल, और यीशु जनैत छलाह जे आब एहि संसार केँ छोड़ि कऽ पिता लग जयबाक घड़ी आबि गेल अछि। अपन चुनल लोक जे संसार मे छलनि, और जिनका सभ केँ ओ प्रेम करैत आयल छलथिन, तिनका सभ केँ ओ अन्‍तिम सीमा तक प्रेम कयलनि। ");
INSERT INTO mai_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","यीशु और हुनकर शिष्‍य सभ भोजन कऽ रहल छलाह। शैतान पहिनहि सिमोनक बेटा यहूदा इस्‍करियोतीक मोन मे यीशु केँ पकड़बयबाक विचार धऽ देने छलैक। ");
INSERT INTO mai_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","यीशु ई जनैत छलाह जे पिता हमरा हाथ मे सभ किछु दऽ देने छथि और ई, जे हम परमेश्‍वर सँ आयल छी आ परमेश्‍वर लग जा रहल छी। ");
INSERT INTO mai_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","तेँ ओ भोजन सँ उठलाह, और अपन उपरका कपड़ा उतारि कऽ अपना डाँड़ मे गमछा लपेटि लेलनि। ");
INSERT INTO mai_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तखन एक कठौत मे पानि ढारि कऽ ओ शिष्‍य सभक पयर धोबऽ और डाँड़ मे बान्‍हल गमछा लऽ कऽ पोछऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","जखन ओ सिमोन पत्रुस लग अयलाह, तँ पत्रुस हुनका कहलथिन, “प्रभु! की हमर पयर अहाँ धोब?” ");
INSERT INTO mai_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","यीशु बजलाह, “हम की कऽ रहल छी, से अहाँ एखन नहि जनैत छी, मुदा बाद मे अहाँ बुझि जायब।” ");
INSERT INTO mai_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पत्रुस हुनका कहलथिन, “नहि! अहाँ हमर पयर कहियो नहि धोबऽ पायब!” यीशु बजलाह, “जँ अहाँ हमरा नहि धोबऽ देब तँ हमरा संग अहाँ केँ कोनो सम्‍बन्‍ध नहि रहल।” ");
INSERT INTO mai_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","तँ सिमोन पत्रुस हुनका कहलथिन, “तखन प्रभु, हमर पयरेटा नहि, हमर हाथ और माथ सेहो!” ");
INSERT INTO mai_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","यीशु उत्तर देलथिन, “जे नहा लेने अछि, तकरा पयर केँ छोड़ि कऽ आओर किछु धोबाक आवश्‍यकता नहि छैक, ओकर सम्‍पूर्ण देह शुद्ध रहैत छैक। और अहाँ सभ शुद्ध छी, मुदा सभ केओ नहि।” ");
INSERT INTO mai_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","यीशु तँ जनैत छलाह जे हुनका पकड़बाबऽ वला के होयत, और तेँ ओ कहलथिन, अहाँ सभ गोटे शुद्ध नहि छी। ");
INSERT INTO mai_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","जखन यीशु हुनका सभक पयर धो लेलनि, और अपन कपड़ा पहिरि कऽ बैसि गेलाह, तखन ओ हुनका सभ केँ कहलथिन, “हम अहाँ सभक संग की कयलहुँ, से की अहाँ सभ बुझैत छी? ");
INSERT INTO mai_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","अहाँ सभ हमरा ‘गुरुजी’ और ‘प्रभुजी’ कहैत छी, और ठीके कहैत छी, कारण ओ हम छी। ");
INSERT INTO mai_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","तँ जँ हम अहाँ सभक प्रभु और गुरु भऽ कऽ अहाँ सभक पयर धोने छी, तँ अहूँ सभ केँ एक-दोसराक पयर धोबाक चाही। ");
INSERT INTO mai_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","हम अहाँ सभ केँ एक नमूना देखा देलहुँ जाहि सँ जहिना हम अहाँ सभक संग कयलहुँ तहिना अहूँ सभ करू। ");
INSERT INTO mai_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","हम अहाँ सभ केँ विश्‍वास दिअबैत छी जे, दास अपना मालिक सँ पैघ नहि होइत अछि, और ने पठाओल गेल दूत अपना पठाबऽ वला सँ। ");
INSERT INTO mai_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ई सभ बात जानि कऽ, जँ एकरा अनुसार चलब तँ धन्‍य होयब। ");
INSERT INTO mai_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“हम अहाँ सभ गोटेक बारे मे नहि बाजि रहल छी। जिनका सभ केँ हम चुनलियनि तिनका सभ केँ चिन्‍हैत छिऐन। मुदा धर्मशास्‍त्रक ई लेख पूरा होयबाक अछि जे, ‘जे हमर रोटी खाइत अछि से हमरा विरोध मे लात उठौने अछि।’ ");
INSERT INTO mai_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ई घटना घटऽ सँ पहिनहि हम अहाँ सभ केँ ई बात कहि रहल छी, जाहि सँ जखन ई घटत तखन अहाँ सभ केँ पूरा विश्‍वास होयत जे हम वैह छी जे छी। ");
INSERT INTO mai_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","हम अहाँ सभ केँ सत्‍ये कहैत छी जे, जे केओ ओकरा स्‍वीकार करैत अछि जकरा हम पठबैत छी, से हमरा स्‍वीकार करैत अछि, और जे हमरा स्‍वीकार करैत अछि से तिनका स्‍वीकार करैत छनि जे हमरा पठौलनि।” ");
INSERT INTO mai_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ई बात कहि कऽ यीशु अपना आत्‍मा मे बहुत व्‍याकुल होमऽ लगलाह, और ओ खुलि कऽ कहलथिन, “हम अहाँ सभ केँ सत्‍य कहैत छी जे अहाँ सभ मे सँ एक गोटे हमरा पकड़बा देब।” ");
INSERT INTO mai_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","शिष्‍य सभ एकदम नहि बुझि कऽ जे ओ ककरा बारे मे बाजि रहल छथि, एक-दोसराक दिस ताकऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","हुनका सभ मे सँ एकटा, जाहि शिष्‍य सँ यीशु प्रेम करैत छलाह, से हुनका छाती सँ ओंगठि कऽ पड़ल छलनि। ");
INSERT INTO mai_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","सिमोन पत्रुस ओहि शिष्‍य केँ संकेत कऽ कऽ कहलथिन, “हुनका सँ पुछिऔन जे ककरा बारे मे कहि रहल छथि।” ");
INSERT INTO mai_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ओ यीशु पर ओंगठि कऽ पुछलथिन, “प्रभु, ओ के अछि?” ");
INSERT INTO mai_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","यीशु उत्तर देलथिन, “ओ वैह अछि जकरा हम रोटीक टुकड़ा बट्टा मे बोड़ि कऽ देबैक।” तखन ओ रोटीक टुकड़ा बोड़ि कऽ सिमोन इस्‍करियोतीक बेटा यहूदा केँ देलथिन। ");
INSERT INTO mai_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","यहूदा केँ रोटीक टुकड़ा लितहि, शैतान ओकरा मे पैसि गेलैक। तखन यीशु ओकरा कहलथिन, “जे काज तोँ करऽ पर छह, से जल्‍दी करह!” ");
INSERT INTO mai_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","मुदा भोजन पर बैसल व्‍यक्‍ति सभ मे सँ केओ नहि बुझलनि जे यीशु किएक ओकरा ई बात कहलथिन। ");
INSERT INTO mai_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","किछु गोटे सोचलनि जे यहूदा लग पाइक बटुआ रहला सँ हुनकर कहबाक तात्‍पर्य छलनि जे, जे किछु पाबनिक लेल हमरा सभ केँ आवश्‍यक अछि से किनह, वा ई जे गरीब सभ मे किछु बाँटि दहक। ");
INSERT INTO mai_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","यहूदा रोटीक टुकड़ा लेलाक बाद तुरत बाहर चल गेल, ओ रातुक समय छल। ");
INSERT INTO mai_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","जखन यहूदा बाहर चल गेल, तखन यीशु बजलाह, “आब मनुष्‍य-पुत्रक महिमा प्रगट होयतैक, और ओकरा मे परमेश्‍वरक महिमा प्रगट होयतनि। ");
INSERT INTO mai_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","जँ ओकरा मे परमेश्‍वरक महिमा प्रगट होयतनि, तँ परमेश्‍वर सेहो अपना मे ओकर महिमा प्रगट करताह, और बहुत जल्‍दी करताह। ");
INSERT INTO mai_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“यौ हमर बौआ सभ! कनेके काल आओर हम अहाँ सभक संग छी। अहाँ सभ हमरा ताकब, और जेना हम यहूदी सभ केँ कहलियनि, तेना अहूँ सभ केँ कहैत छी जे, जतऽ हम जा रहल छी ततऽ अहाँ सभ नहि आबि सकैत छी। ");
INSERT INTO mai_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","एक नव आज्ञा हम अहाँ सभ केँ दैत छी—एक-दोसर सँ प्रेम करू। जेना हम अहाँ सभ सँ प्रेम कयने छी तेना अहूँ सभ एक-दोसर सँ प्रेम करू। ");
INSERT INTO mai_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","एहि सँ सभ लोक जानत जे अहाँ सभ हमर शिष्‍य छी, अर्थात्‌ अहाँ सभ जँ एक-दोसर सँ प्रेम करब, ताहि सँ।” ");
INSERT INTO mai_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","सिमोन पत्रुस हुनका सँ पुछलथिन, “प्रभु, अहाँ कतऽ जा रहल छी?” यीशु बजलाह, “हम जतऽ जा रहल छी, ततऽ अहाँ एखन हमरा पाछाँ-पाछाँ नहि आबि सकब, लेकिन बाद मे अहाँ हमरा पाछाँ आयब।” ");
INSERT INTO mai_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पत्रुस कहलथिन, “प्रभु, हम अहाँक पाछाँ-पाछाँ एखन किएक नहि आबि सकैत छी? हम अहाँक लेल अपन प्राणो देब!” ");
INSERT INTO mai_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","यीशु बजलाह, “की अहाँ वास्‍तव मे हमरा लेल अपन प्राण देब? हम अहाँ केँ सत्‍य कहैत छी जे, मुर्गा केँ बाजऽ सँ पहिनहि, अहाँ तीन बेर हमरा अस्‍वीकार कऽ कऽ लोक केँ कहबैक जे, हम ओकरा चिन्‍हबो नहि करैत छिऐक।” ");
INSERT INTO mai_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“अहाँ सभ अपना मोन मे घबड़ाउ नहि। परमेश्‍वर पर विश्‍वास करैत रहू और हमरो पर विश्‍वास करैत रहू। ");
INSERT INTO mai_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","हमरा पिताक घर मे बहुते रहऽ वला जगह अछि, और हम अहाँ सभक लेल जगह तैयार करऽ जा रहल छी। ई बात जँ नहि रहैत तँ हम अहाँ सभ केँ कहि दितहुँ। ");
INSERT INTO mai_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","और जँ हम अहाँ सभक लेल जगह तैयार करऽ जा रहल छी, तँ हम फेर आयब, और अहाँ सभ केँ हम अपना लग लऽ जायब, जाहि सँ हम जतऽ छी, ततऽ अहूँ सभ रही। जाहिठाम हम जा रहल छी, ");
INSERT INTO mai_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ताहि ठामक रस्‍ता अहाँ सभ जनैत छी!” ");
INSERT INTO mai_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमा हुनका कहलथिन, “प्रभु, अहाँ कतऽ जा रहल छी, सेहो हम सभ नहि जनैत छी। तँ रस्‍ता कोना जानब?” ");
INSERT INTO mai_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","यीशु बजलाह, “रस्‍ता हमहीं छी, हँ, और सत्‍य और जीवन सेहो छी। हमरा बिनु केओ पिता लग नहि अबैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","जँ अहाँ सभ वास्‍तव मे जनितहुँ जे हम के छी, तँ हमरा पितो केँ जनितहुँ। आब हुनका जनिते छी और देखने छी।” ");
INSERT INTO mai_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिपुस हुनका कहलथिन, “प्रभु, हमरा सभ केँ पिता केँ देखाउ, तखन हम सभ सन्‍तुष्‍ट भऽ जायब।” ");
INSERT INTO mai_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","यीशु उत्तर देलथिन, “फिलिपुस! अहाँ सभक संग हम एतेक दिन सँ छी, आ की एखनो तक अहाँ नहि जनैत छी जे हम के छी? जे हमरा देखने अछि से पिता केँ देखने अछि। तँ अहाँ कोना कहैत छी जे, हमरा सभ केँ पिता केँ देखाउ? ");
INSERT INTO mai_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","की अहाँ केँ विश्‍वास नहि होइत अछि जे हम पिता मे छी और पिता हमरा मे छथि? जे बात हम अहाँ सभ केँ कहैत छी, से हम अपना दिस सँ नहि कहैत छी, बल्‍कि पिता, जे हमरा मे वास करैत छथि, सैह अपन काज कऽ रहल छथि। ");
INSERT INTO mai_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","हमर विश्‍वास करू जे हम पिता मे छी और पिता हमरा मे छथि। आ नहि, तँ हमर काजेक कारण विश्‍वास करू। ");
INSERT INTO mai_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","हम अहाँ सभ केँ सत्‍ये कहैत छी जे, हमरा पर विश्‍वास कयनिहार सेहो वैह काज सभ करत जे हम करैत छी, और एहू सँ पैघ काज करत, कारण हम पिता लग जा रहल छी। ");
INSERT INTO mai_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","और अहाँ सभ हमरा नाम सँ जे किछु माँगब, से हम पूरा करब, जाहि सँ पुत्र द्वारा परमेश्‍वरक महिमा प्रगट होयत। ");
INSERT INTO mai_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","जँ हमरा नाम सँ अहाँ सभ हमरा सँ किछुओ माँगब तँ तकरा हम पूरा करब। ");
INSERT INTO mai_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“जँ हमरा सँ प्रेम करैत छी तँ हमर आज्ञाक पालन करब। ");
INSERT INTO mai_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","हम पिता सँ विनती करबनि, और ओ अहाँ सभक संग अनन्‍त काल तक रहबाक लेल एक आओर सहायक देताह, ");
INSERT INTO mai_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","अर्थात् सत्‍यक आत्‍मा। हुनका संसार ग्रहण नहि कऽ सकैत छनि, किएक तँ ओ हुनका ने देखैत छनि आ ने चिन्‍हैत छनि। मुदा अहाँ सभ हुनका चिन्‍हैत छिऐन, कारण ओ अहाँ सभ लग रहैत छथि और अहाँ मे वास करताह। ");
INSERT INTO mai_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","हम अहाँ सभ केँ अनाथ नहि छोड़ब, हम अहाँ सभ लग आयब। ");
INSERT INTO mai_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","कनेक काल आओर अछि, तकरबाद फेर संसार हमरा नहि देखत, मुदा अहाँ सभ हमरा देखब। हमरा मे वास्‍तविक जीवन रहबाक कारणेँ अहूँ सभ जीब। ");
INSERT INTO mai_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ओहि दिन अहाँ सभ जानि जायब जे हम पिता मे छी और अहाँ सभ हमरा मे छी, और हम अहाँ सभ मे छी। ");
INSERT INTO mai_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","जे हमर आज्ञा स्‍वीकार करैत अछि और मानैत अछि, सैह हमरा सँ प्रेम करैत अछि। और जे हमरा सँ प्रेम करैत अछि, तकरा सँ हमर पिता प्रेम करथिन, और हमहूँ ओकरा सँ प्रेम करब तथा ओकरा हम अपना केँ देखायब।” ");
INSERT INTO mai_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","तखन यहूदा (यहूदा इस्‍करियोती नहि, दोसर) हुनका कहलथिन, “प्रभु, ई की भेल जे अहाँ अपना केँ हमरे सभ केँ देखायब आ संसार केँ नहि?” ");
INSERT INTO mai_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","यीशु बजलाह, “जँ केओ हमरा सँ प्रेम करैत अछि तँ ओ हमर वचनक अनुसार चलत। हमर पिता ओकरा सँ प्रेम करथिन और हम सभ ओकरा लग आबि कऽ ओकरा मे अपन निवास-स्‍थान राखब। ");
INSERT INTO mai_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","जे हमरा सँ प्रेम नहि करैत अछि, से हमर वचनक अनुसार नहि चलत। और ई बात जे अहाँ सभ एखन सुनि रहल छी, से हमर नहि अछि; पिता जे हमरा पठौलनि, तिनकर छनि। ");
INSERT INTO mai_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“ई सभ बात हम अहाँ सभ लग रहितहि कहि देने छी। ");
INSERT INTO mai_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","मुदा ओ सहायक, अर्थात् पवित्र आत्‍मा, जिनका पिता हमरा नाम सँ पठौताह, से अहाँ सभ केँ सभ बात सिखा देताह, और हम जे किछु अहाँ सभ केँ कहने छी, से सभ बात अहाँ सभ केँ मोन पाड़ि देताह। ");
INSERT INTO mai_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“शान्‍ति हम अहाँ सभ केँ दऽ जाइत छी। अपन शान्‍ति हम अहाँ सभ केँ दैत छी। जेना संसार दैत अछि, तेना हम नहि दैत छी। अहाँ सभ अपना मोन मे नहि घबड़ाउ, आ ने भयभीत होउ। ");
INSERT INTO mai_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“अहाँ सभ हमरा कहैत सुनलहुँ जे, हम जा रहल छी आ फेर अहाँ सभ लग आबि रहल छी। जँ अहाँ सभ हमरा सँ प्रेम करितहुँ तँ आनन्‍द मनबितहुँ जे हम पिता लग जा रहल छी, कारण पिता हमरा सँ पैघ छथि। ");
INSERT INTO mai_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ई होमऽ सँ पहिनहि हम एखने ई बात कहि दैत छी, जाहि सँ ई भेला पर अहाँ सभ विश्‍वास राखब। ");
INSERT INTO mai_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","हम आब अहाँ सभ सँ बेसी बात नहि करब, किएक तँ एहि संसारक शासक आबि रहल अछि। हमरा पर ओकरा कोनो अधिकार नहि छैक। ");
INSERT INTO mai_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","मुदा संसार केँ ई जनबाक छैक जे हम पिता सँ प्रेम करैत छी और सभ किछु हुनकर आज्ञाक अनुसार करैत छी। आब उठू, अपना सभ एतऽ सँ चली।” ");
INSERT INTO mai_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“वास्‍तविक अंगूर-लत्ती हमहीं छी, और हमर पिता किसान छथि। ");
INSERT INTO mai_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","प्रत्‍येक ठाढ़ि जे हमरा मे अछि और फड़ैत नहि अछि, तकरा ओ काटि दैत छथिन, और प्रत्‍येक ठाढ़ि जे फड़ैत अछि तकरा ओ छँटैत छथिन, जाहि सँ ओ शुद्ध भऽ कऽ आओर फड़त। ");
INSERT INTO mai_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","अहाँ सभ तँ हमर ओहि वचन द्वारा, जे हम अहाँ सभ केँ कहने छी, शुद्ध छीहे। ");
INSERT INTO mai_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","हमरा मे रहैत रहू, जेना हम अहाँ सभ मे। जहिना ठाढ़ि अपने सँ नहि फड़ि सकैत अछि, बल्‍कि तखने जखन लत्ती मे रहैत अछि, तहिना अहूँ सभ तखने फड़ि सकैत छी जँ हमरा मे रहैत रहब। ");
INSERT INTO mai_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“हम अंगूर-लत्ती छी। अहाँ सभ ठाढ़ि छी। जे हमरा मे रहैत अछि और हम ओकरा मे, सैह बहुत फड़ैत अछि, कारण हमरा बिनु अहाँ सभ किछु नहि कऽ सकैत छी। ");
INSERT INTO mai_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","जँ केओ हमरा मे नहि रहैत अछि, तँ ओ काटल ठाढ़ि जकाँ होइत अछि जे फेकल जाइत अछि और सुखि जाइत अछि। एहन ठाढ़ि जमा कयल जाइत अछि, तखन आगि मे फेकल और जराओल जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","जँ हमरा मे रहब और हमर वचन अहाँ मे रहत तँ, जे किछु चाहैत छी से माँगू, और अहाँक लेल भऽ जायत। ");
INSERT INTO mai_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","हमर पिताक महिमा एहि मे प्रगट होयत जे अहाँ सभ हमर शिष्‍य भऽ कऽ बहुत फड़ैत रहब। अहाँ सभ बहुत फड़ब आ एहि तरहेँ हमर शिष्‍य ठहरब। ");
INSERT INTO mai_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“जहिना पिता हमरा सँ प्रेम कयने छथि, तहिना अहाँ सभ सँ हम प्रेम कयने छी। आब हमरा प्रेम मे रहू। ");
INSERT INTO mai_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","अहाँ सभ जँ हमर आदेश केँ मानब तँ हमरा प्रेम मे रहब, जेना हम पिताक आदेश केँ मानने छी और हुनकर प्रेम मे रहैत छी। ");
INSERT INTO mai_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ई बात हम एहि लेल कहैत छी जे हमर आनन्‍द अहाँ सभ मे रहय और अहाँ सभक आनन्‍द पूर्ण होअय। ");
INSERT INTO mai_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","हमर आदेश ई अछि जे, जेना हम अहाँ सभ सँ प्रेम कयने छी, तेना अहाँ सभ एक-दोसर सँ प्रेम करू। ");
INSERT INTO mai_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","एहि सँ बड़का प्रेम कोनो नहि अछि जे, केओ अपन मित्रक लेल अपन प्राण देअय। ");
INSERT INTO mai_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","जँ अहाँ सभ हमर आदेश केँ पालन करैत छी तँ अहाँ सभ हमर मित्रे छी। ");
INSERT INTO mai_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","आब हम अहाँ सभ केँ ‘दास’ नहि कहब, कारण दास नहि जनैत अछि जे ओकर मालिक की करैत छथि। मुदा अहाँ सभ केँ हम ‘मित्र’ कहने छी, किएक तँ जे किछु हम अपना पिता सँ सुनने छी, से सभ अहाँ सभ केँ कहि देने छी। ");
INSERT INTO mai_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","अहाँ सभ हमरा नहि चुनलहुँ। हमहीं अहाँ सभ केँ चुनलहुँ, और नियुक्‍त कयलहुँ जे अहाँ सभ जा कऽ फड़ैत रही, तथा अहाँ सभक फल स्‍थायी रहय, जाहि सँ जे किछु अहाँ सभ हमरा नाम सँ पिता सँ माँगब, से ओ पूरा करताह। ");
INSERT INTO mai_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","हम अहाँ सभ केँ ई आदेश दैत छी, जे एक-दोसर सँ प्रेम करू। ");
INSERT INTO mai_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“जँ संसार अहाँ सभ सँ घृणा करैत अछि तँ मोन राखू जे अहाँ सभ सँ पहिनहि हमरा सँ घृणा कयने अछि। ");
INSERT INTO mai_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","अहाँ सभ जँ संसारक रहितहुँ तँ ओ अहाँ सभ सँ अपन लोक जकाँ प्रेम करैत। मुदा अहाँ सभ संसारक नहि छी। हम अहाँ सभ केँ संसार मे सँ चुनि लेने छी, और तेँ संसार अहाँ सभ सँ घृणा करैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","जे बात हम अहाँ सभ केँ कहलहुँ, तकरा मोन राखू, जे ‘दास अपना मालिक सँ पैघ नहि होइत अछि।’ जँ ओ सभ हमरा सतौने अछि तँ अहूँ सभ केँ सताओत। जँ हमर बात मानने अछि तँ अहूँ सभक मानत। ");
INSERT INTO mai_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ओ सभ अहाँ सभक संग एहन व्‍यवहार हमरा नामक कारणेँ करत, किएक तँ ओ सभ तिनका नहि चिन्‍हैत छनि जे हमरा पठौलनि। ");
INSERT INTO mai_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","जँ हम ओकरा सभ लग नहि आयल रहितहुँ आ ने बात कयने रहितिऐक तँ ओ सभ पापक दोषी नहि होइत। मुदा आब अपना पाप सँ बचबाक लेल ओकरा सभ केँ कोनो बहाना नहि छैक। ");
INSERT INTO mai_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","जे हमरा सँ घृणा करैत अछि, से हमरा पितो सँ घृणा करैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","जँ ओकरा सभक बीच हम ओ काज नहि कयने रहितहुँ जे आओर केओ नहि कयलक, तँ ओ सभ पापक दोषी नहि होइत, मुदा आब ओ सभ हमरा और हमरा पिता दूनू केँ देखनो अछि आ घृणो कयने अछि। ");
INSERT INTO mai_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","मुदा ई एहि लेल भेल जे ओकरा सभक धर्म-नियम मे लिखल ई कथन पूरा होअय जे, ‘ओ सभ हमरा सँ बिनु कारणेँ घृणा कयलक।’ ");
INSERT INTO mai_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“जखन सहायक औताह, जिनका हम पिताक ओहिठाम सँ अहाँ सभ लग पठा देब, अर्थात् सत्‍यक आत्‍मा, जे पिता मे सँ निकलैत छथि, तखन ओ हमरा बारे मे गवाही देताह, ");
INSERT INTO mai_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","और अहूँ सभ हमरा बारे मे गवाही देब, किएक तँ अहाँ सभ शुरुए सँ हमरा संग छी। ");
INSERT INTO mai_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ई सभ बात हम अहाँ सभ केँ एहि लेल कहि दैत छी जे अहाँ सभ विश्‍वास केँ नहि छोड़ी। ");
INSERT INTO mai_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ओ सभ अहाँ सभ केँ सभाघर सँ बारि देत। हँ, ओ समय आबि रहल अछि जे, जे अहाँ सभ केँ जान सँ मारि देत से बुझत जे ओ परमेश्‍वरक धर्म-कर्म कऽ रहल अछि। ");
INSERT INTO mai_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ई काज ओ सभ एहि लेल करत जे ओ सभ ने हमरा आ ने हमरा पिता केँ कहियो चिन्‍हने अछि। ");
INSERT INTO mai_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","मुदा ई सभ बात हम अहाँ सभ केँ कहि दैत छी जाहि सँ जखन ओ समय आओत तखन अहाँ सभ मोन राखब जे हम एहि विषय मे कहि देने छी। “ई बात सभ हम शुरू सँ नहि कहलहुँ, कारण हम अहाँ सभक संग छलहुँ। ");
INSERT INTO mai_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","मुदा आब हम तिनका लग जा रहल छी जे हमरा पठौलनि, तैयो अहाँ सभ मे सँ केओ नहि हमरा सँ पुछैत छी जे, अहाँ कतऽ जा रहल छी, ");
INSERT INTO mai_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","बल्‍कि हमर एहि कथनक कारणेँ अहाँ सभक मोन शोक सँ भरि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","मुदा हम सत्‍ये कहैत छी जे ई अहाँ सभक हितक लेल अछि जे हम जा रहल छी, किएक तँ जँ हम नहि जायब तँ सहायक नहि औताह, लेकिन जँ हम जायब तँ हम हुनका अहाँ सभ लग पठा देबनि। ");
INSERT INTO mai_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ओ जखन औताह तँ पाप, धार्मिकता आ न्‍यायक विषय मे संसारक दोष सिद्ध करथिन। ");
INSERT INTO mai_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ओकर दोष पापक विषय मे एहि लेल सिद्ध होयतैक, जे ओ सभ हमरा पर विश्‍वास नहि करैत अछि; ");
INSERT INTO mai_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","धार्मिकताक विषय मे एहि लेल जे हम पिता लग जा रहल छी आ अहाँ सभ हमरा फेर नहि देखब; ");
INSERT INTO mai_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","और न्‍यायक विषय मे एहि लेल जे, ओ जे एहि संसारक शासक अछि से दोषी ठहरि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“हमरा अहाँ सभ केँ आओर बहुत किछु कहबाक अछि, मुदा एखन अहाँ सभ ओकरा नहि सहि सकैत छी। ");
INSERT INTO mai_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","सत्‍यक आत्‍मा जखन औताह तखन ओ अहाँ सभ केँ पूर्ण सत्‍य बुझौताह, कारण ओ अपना तरफ सँ नहि बजताह, बल्‍कि जे ओ सुनताह सैह बजताह, और भविष्‍य मे होमऽ वला बात अहाँ सभ केँ कहि देताह। ");
INSERT INTO mai_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ओ हमर महिमा प्रगट करताह कारण जतेक बात ओ अहाँ सभ केँ कहताह, से हमरा सँ लऽ लेने रहताह। ");
INSERT INTO mai_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","जे किछु पिताक छनि, से सभ हमर अछि। एहि कारणेँ हम कहलहुँ जे, आत्‍मा जे किछु अहाँ सभ केँ कहताह से हमरा सँ लऽ लेने रहताह। ");
INSERT INTO mai_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“आब कनेक काल मे अहाँ सभ हमरा नहि देखब, तखन फेर कनेक कालक बाद हमरा देखब।” ");
INSERT INTO mai_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","एहि पर हुनकर किछु शिष्‍य एक-दोसर सँ कहऽ लगलाह, “हुनकर एहि कथनक की अर्थ भेल जे ‘कनेक काल मे अहाँ सभ हमरा नहि देखब’, और, ‘तखन तकरा कनेक कालक बाद हमरा फेर देखब’, और एकर जे, ‘कारण, हम पिता लग जा रहल छी’?” ");
INSERT INTO mai_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ओ सभ कहऽ लगलाह, “हुनकर एहि ‘कनेक काल’क की कहबाक मतलब छनि? हम सभ नहि बुझि पबैत छी जे ओ की कहि रहल छथि।” ");
INSERT INTO mai_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","यीशु जनैत छलाह जे ओ सभ हुनका सँ पुछऽ चाहैत छथि, तेँ ओ हुनका सभ केँ कहलथिन, “की अहाँ सभ एक-दोसर सँ पुछि रहल छी जे हमर की कहबाक अर्थ छल जखन हम कहलहुँ जे, कनेक काल मे अहाँ सभ हमरा नहि देखब, और, तखन तकरा कनेक कालक बाद हमरा फेर देखब? ");
INSERT INTO mai_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","हम अहाँ सभ केँ सत्‍ये कहैत छी जे अहाँ सभ कन्‍ना-रोहटि आ विलाप करब जखन कि संसार आनन्‍द मनाओत। अहाँ सभ शोक मनायब, मुदा अहाँ सभक शोक आनन्‍द मे बदलि जायत। ");
INSERT INTO mai_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","जखन स्‍त्री बच्‍चा केँ जन्‍म दैत अछि तँ ओकरा दर्द होइत छैक, कारण ओकर समय आबि गेल रहैत छैक, मुदा जखन ओ बच्‍चा केँ जन्‍म दऽ दैत अछि तँ ओ एहि खुशी मे जे एक नव बच्‍चा संसार मे जन्‍म लेलक, अपना पीड़ा केँ बिसरि जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","तहिना, अहाँ सभ एखन शोक मनबैत छी, मुदा हम अहाँ सभ केँ फेर देखब आ तखन अहाँ सभक मोन आनन्‍द सँ भरि जायत, और अहाँ सभक आनन्‍द केओ नहि अहाँ सभ सँ छिनत। ");
INSERT INTO mai_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ओहि समय मे अहाँ सभ हमरा सँ कोनो प्रश्‍न नहि पुछब। “हम अहाँ सभ केँ विश्‍वास दिअबैत छी जे, जँ अहाँ सभ पिता सँ किछु माँगब तँ ओ अहाँ सभ केँ हमरा नाम सँ देताह। ");
INSERT INTO mai_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","एखन तक अहाँ सभ हमरा नाम सँ नहि किछु मँगने छी। माँगू और अहाँ सभ प्राप्‍त करब, आ ताहि सँ अहाँ सभक आनन्‍द पूर्ण भऽ जायत। ");
INSERT INTO mai_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ई सभ बात हम अहाँ सभ केँ झाँपल भाषा मे कहि देने छी। मुदा समय आबि रहल अछि जखन हम झाँपल भाषा मे नहि बाजब, बल्‍कि पिताक विषय मे अहाँ सभ केँ स्‍पष्‍ट कहब। ");
INSERT INTO mai_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ओहि समय मे अहाँ सभ हमरा नाम सँ माँगब। हम ई नहि कहैत छी जे हम अहाँ सभक लेल पिता सँ माँगब। ");
INSERT INTO mai_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","नहि, पिता अपने अहाँ सभ सँ प्रेम करैत छथि, कारण अहाँ सभ हमरा सँ प्रेम कयने छी आ विश्‍वास कयने छी जे हम पिता लग सँ अयलहुँ। ");
INSERT INTO mai_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","हम पिता लग सँ संसार मे अयलहुँ, आब फेर संसार केँ छोड़ि कऽ पिता लग जा रहल छी।” ");
INSERT INTO mai_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","तखन हुनकर शिष्‍य सभ कहलथिन, “हँ, आब अहाँ स्‍पष्‍ट बाजि रहल छी, और झाँपल भाषा मे नहि। ");
INSERT INTO mai_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","आब हम सभ जानि गेलहुँ जे अहाँ केँ सभ किछु बुझल अछि और अहाँ केँ इहो आवश्‍यकता नहि अछि जे केओ अहाँ लग अपन प्रश्‍न राखय। एहि कारणेँ हम सभ विश्‍वास करैत छी जे अहाँ परमेश्‍वर लग सँ आयल छी।” ");
INSERT INTO mai_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","यीशु बजलाह, “की आब विश्‍वास करैत छी? ");
INSERT INTO mai_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","देखू! ओ समय आबि रहल अछि, हँ, आबिओ गेल, जखन अहाँ सभ छिड़िया जायब। अहाँ सभ अपन-अपन घर भागि कऽ हमरा असगरे छोड़ि देब। तैयो हम असगर नहि छी, कारण पिता हमरा संग छथि। ");
INSERT INTO mai_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“हम अहाँ सभ केँ ई सभ बात कहि देने छी जाहि सँ हमरा मे अहाँ सभ केँ शान्‍ति भेटय। संसार मे अहाँ सभ पर संकट आओत, मुदा साहस राखू! हम संसार पर विजयी भऽ गेल छी।” ");
INSERT INTO mai_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","यीशु ई सभ बात कहि स्‍वर्ग दिस ताकि कऽ कहलनि, “हे पिता! समय आबि गेल अछि। अपन पुत्रक महिमा प्रगट करू जाहि सँ पुत्र अहाँक महिमा प्रगट करय। ");
INSERT INTO mai_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","किएक तँ अहाँ ओकरा सम्‍पूर्ण मानव जातिक उपर अधिकार देने छी जे, जकरा अहाँ ओकरा देने छी, तकरा सभ केँ ओ अनन्‍त जीवन देअय। ");
INSERT INTO mai_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","अनन्‍त जीवन ई अछि—अहाँ एकमात्र सत्‍य परमेश्‍वर केँ, और यीशु मसीह केँ चिन्‍हनाइ, जकरा अहाँ पठौलहुँ। ");
INSERT INTO mai_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“जे काज अहाँ हमरा करबाक लेल देने छलहुँ, से पूरा कऽ कऽ पृथ्‍वी पर अहाँक महिमा प्रगट कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","आब, हे पिता, अपना ओहिठाम हमरा ओहि महिमा सँ परिपूर्ण करू, जे महिमा संसारक सृष्‍टि सँ पहिनहि अहाँ लग हमर छल। ");
INSERT INTO mai_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“हम ओहि मनुष्‍य सभ केँ, जिनका अहाँ संसार मे सँ हमरा देलहुँ, तिनका सभ केँ हम अहाँ केँ चिन्‍हा देने छिऐन। ई सभ अहींक छलाह, अहाँ हिनका सभ केँ हमरा देलहुँ, और ई सभ अहाँक वचन मानने छथि। ");
INSERT INTO mai_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","आब ई सभ जानि गेल छथि जे, जे किछु अहाँ हमरा देने छी से वास्‍तव मे अहीं सँ भेटल अछि। ");
INSERT INTO mai_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","कारण, जे अहाँ हमरा सिखौलहुँ, से हम हिनका सभ केँ सिखौने छी, और ई सभ ओहि शिक्षा केँ स्‍वीकार कयने छथि, और पूर्ण रूप सँ जानि गेल छथि जे हम अहाँ लग सँ आयल छी। आब हिनका सभ केँ विश्‍वास भऽ गेलनि जे अहाँ हमरा पठौने छी। ");
INSERT INTO mai_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“हम हिनका सभक लेल प्रार्थना कऽ रहल छी। संसारक लेल प्रार्थना नहि कऽ रहल छी, बल्‍कि तिनका सभक लेल जिनका अहाँ हमरा देने छी, किएक तँ ई सभ अहाँक छथि। ");
INSERT INTO mai_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","हमर जे किछु अछि, से अहाँक अछि, और अहाँक जे किछु अछि, से हमर अछि। और हिनका सभ मे हमर महिमा प्रगट भेल अछि। ");
INSERT INTO mai_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","आब हम संसार मे नहि रहब, मुदा ई सभ संसार मे रहताह, और हम अहाँ लग आबि रहल छी। हे पवित्र पिता, अपन नामक शक्‍ति द्वारा, जे नाम अहाँ हमरा देलहुँ, ताहि द्वारा हिनका सभ केँ सुरक्षित राखू जाहि सँ ई सभ एक रहथि, जेना अपना सभ एक छी। ");
INSERT INTO mai_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","जा धरि हम हिनका सभक संग छलहुँ ता धरि हम हिनका सभ केँ सुरक्षित रखलहुँ और ओहि नाम द्वारा, जे अहाँ हमरा देलहुँ, हम हिनका सभक रक्षा कयलहुँ। और ‘विनाशक पुत्र’ केँ छोड़ि हिनका सभ मे सँ केओ नाश नहि भेलाह, जाहि सँ धर्मशास्‍त्रक लेख पूरा होअय। ");
INSERT INTO mai_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“आब हम अहाँ लग आबि रहल छी, मुदा ई बात हम संसार मे रहिते कहैत छिऐन, जाहि सँ हमर आनन्‍द हिनका सभक मोन मे पूर्ण होनि। ");
INSERT INTO mai_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","हम हिनका सभ केँ अहाँक वचन देने छिऐन, और संसार हिनका सभ सँ घृणा करैत छनि, कारण ई सभ संसारक सन्‍तान नहि छथि, जेना हमहूँ नहि छी। ");
INSERT INTO mai_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","हम ई प्रार्थना नहि करैत छी जे अहाँ हिनका सभ केँ संसार मे सँ उठा लिअ, बल्‍कि ई जे हिनका सभ केँ दुष्‍ट सँ बचा कऽ राखू। ");
INSERT INTO mai_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ई सभ संसारक सन्‍तान नहि छथि, जेना हमहूँ नहि छी। ");
INSERT INTO mai_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","हिनका सभ केँ सत्‍य द्वारा अपना लेल पवित्र कऽ लिअ; सत्‍य अहाँक वचन अछि। ");
INSERT INTO mai_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","जहिना अहाँ हमरा संसार मे पठा देलहुँ, तहिना हम हिनका सभ केँ संसार मे पठा देने छी। ");
INSERT INTO mai_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","हिनका सभक लेल हम अपना केँ समर्पित करैत छी जाहि सँ इहो सभ सत्‍य द्वारा समर्पित भऽ जाथि। ");
INSERT INTO mai_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“हम मात्र हिनके सभक लेल प्रार्थना नहि करैत छी, बल्‍कि हुनको सभक लेल जे हिनका सभक गवाही द्वारा हमरा पर विश्‍वास करताह। ");
INSERT INTO mai_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","हमर प्रार्थना ई अछि जे ओ सभ एक होथि। हे पिता, जहिना अहाँ हमरा मे छी और हम अहाँ मे छी तहिना ओहो सभ अपना सभ मे रहथि, जाहि सँ संसार विश्‍वास करत जे अहीं हमरा पठौने छी। ");
INSERT INTO mai_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","जे महिमा अहाँ हमरा देलहुँ से हम हुनका सभ केँ दऽ देने छिऐन, जाहि सँ ओ सभ एक होथि, जेना अपना सभ एक छी— ");
INSERT INTO mai_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","हँ, हम हुनका सभ मे और अहाँ हमरा मे, जाहि सँ ओ सभ पूर्ण एकता मे सिद्ध भऽ जाथि। तखन संसार जानि जायत जे अहाँ हमरा पठौलहुँ और हुनका सभ सँ ओतेक प्रेम रखने छियनि जतेक हमरा सँ रखने छी। ");
INSERT INTO mai_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“हे पिता, हम चाहैत छी जे, जिनका सभ केँ अहाँ हमरा देने छी, से सभ हमरा संग ओतऽ रहथि जतऽ हम रहब और हम चाहैत छी जे ओ सभ हमर ओहि महिमा केँ देखथि जे अहाँ हमरा एहि लेल देने छी जे अहाँ संसारक सृष्‍टि सँ पहिनहि हमरा सँ प्रेम कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“हे धर्ममय न्‍यायी पिता! संसार अहाँ केँ नहि चिन्‍हैत अछि मुदा हम अहाँ केँ चिन्‍हैत छी, और ई सभ आब जनैत छथि जे अहाँ हमरा पठौने छी। ");
INSERT INTO mai_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","हम हिनका सभ केँ अहाँ केँ चिन्‍हा देने छिऐन तथा अहाँ केँ चिन्‍हबैत रहबनि जाहि सँ ओ प्रेम जे अहाँ हमरा सँ करैत छी से हिनका सभ मे रहतनि और हम हिनका सभ मे रहबनि।” ");
INSERT INTO mai_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ई सभ बात कहलाक बाद यीशु अपना शिष्‍य सभक संग विदा भेलाह और किद्रोन नामक बरसाती नदी केँ पार कयलनि। ओहि पार एक गाछी छल, जाहि मे ओ अपना शिष्‍य सभक संग गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","हुनका पकड़बाबऽ वला, यहूदा, ई जगह जनैत छल, किएक तँ यीशु बहुत बेर अपना शिष्‍य सभक संग ओहिठाम जाइत छलाह। ");
INSERT INTO mai_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","तेँ सेनाक एक दल केँ, और मुख्‍यपुरोहित आ फरिसी सभक दिस सँ उपलब्‍ध कराओल गेल सिपाही सभ केँ लऽ कऽ, यहूदा ओहि गाछी मे आयल। संग मे ओ सभ लालटेम, मशाल, और हाथ-हथियार रखने छल। ");
INSERT INTO mai_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","यीशु ई जनैत जे हुनका संग की सभ घटत, आगाँ बढ़ि कऽ ओकरा सभ सँ पुछलथिन, “अहाँ सभ ककरा ताकि रहल छी?” ");
INSERT INTO mai_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ओ सभ उत्तर देलकनि, “नासरत-निवासी यीशु केँ।” यीशु कहलथिन, “ओ हमहीं छी।” (हुनका पकड़बाबऽ वला, यहूदा, ओतऽ ओकरा सभक संग ठाढ़ छल।) ");
INSERT INTO mai_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","जखने यीशु कहलथिन जे, ओ हमहीं छी, ओ सभ पाछाँ हटि कऽ जमीन पर खसि पड़ल। ");
INSERT INTO mai_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","तँ यीशु फेर पुछलथिन, “ककरा ताकि रहल छी?” और ओ सभ कहलकनि, “नासरत-निवासी यीशु केँ।” ");
INSERT INTO mai_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","यीशु बजलाह, “हम अहाँ सभ केँ कहिए देने छी जे, ओ हमहीं छी। हमरा जँ ताकि रहल छी तँ हिनका सभ केँ जाय दिऔन।” ");
INSERT INTO mai_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(ई एहि लेल भेल जे हुनकर ई कहल वचन पूरा होअय जे, अहाँ जिनका सभ केँ हमरा देलहुँ, तिनका सभ मे सँ हम एकोटा केँ नाश नहि होमऽ देलहुँ।) ");
INSERT INTO mai_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","तखन सिमोन पत्रुस, जिनका लग तरुआरि छलनि, से तरुआरि निकालि कऽ महापुरोहितक नोकर पर चला कऽ ओकर दहिना कान उड़ा देलनि। ओहि नोकरक नाम मलखुस छल। ");
INSERT INTO mai_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","यीशु पत्रुस केँ कहलथिन, “अहाँ अपन तरुआरि म्‍यान मे राखि लिअ! की हम ओहि बाटी केँ नहि पिबू जे पिता हमरा देने छथि?” ");
INSERT INTO mai_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","तखन सेनाक दल और ओकर कप्‍तान आ यहूदी सभक सिपाही सभ यीशु केँ पकड़लकनि और हुनका बान्‍हि लेलकनि। ");
INSERT INTO mai_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","पहिने हुनका हन्‍ना लग लऽ गेलनि, जे ओहि वर्षक महापुरोहित काइफाक ससुर छलाह। ");
INSERT INTO mai_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","काइफा वैह छथि जे यहूदी सभ केँ सल्‍लाह देने छलाह, जे जनताक लेल एक व्‍यक्‍तिक मरनाइ नीक होइत। ");
INSERT INTO mai_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","सिमोन पत्रुस आ एक आरो शिष्‍य यीशुक पाछाँ-पाछाँ गेलाह। ई शिष्‍य महापुरोहित सँ परिचित होयबाक कारणेँ यीशुक संग सोझे आङन मे चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","मुदा पत्रुस द्वारिक बाहरे ठाढ़ रहलाह। तखन ओ शिष्‍य जे महापुरोहित सँ परिचित छलाह, से फेर आबि द्वारिक चौकीदारी करऽ वाली टहलनी सँ बात कऽ कऽ पत्रुस केँ भीतर लऽ अयलाह। ");
INSERT INTO mai_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ओ टहलनी पत्रुस केँ पुछलकनि, “कहीं अहूँ एहि आदमीक शिष्‍य तँ नहि छी?” ओ कहलथिन, “हम नहि छी।” ");
INSERT INTO mai_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","जाड़क मास छल, और नोकर आ सिपाही सभ कोइलाक घूर लगा चारू कात ठाढ़ भऽ कऽ आगि तपैत छल। पत्रुसो ओकरा सभक संग आगि तपैत ठाढ़ छलाह। ");
INSERT INTO mai_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","एहि बीच महापुरोहित यीशु सँ हुनकर शिष्‍य सभक बारे मे और सिद्धान्‍तक विषय मे पूछ-ताछ कयलथिन। ");
INSERT INTO mai_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","यीशु हुनका उत्तर देलथिन, “हम तँ खुलल रूपेँ सभ सँ बात कयने छी। हम सदिखन सभाघर सभ मे और मन्‍दिर मे जाहिठाम सभ यहूदी जुटि जाइत अछि शिक्षा दैत रहलहुँ। हम गुप्‍त रूप सँ किछु नहि कहलहुँ। ");
INSERT INTO mai_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","हमरा किएक पुछैत छी? जे हमर बात सुनने अछि, तकरा सभ सँ पुछि लिऔक जे हम की शिक्षा देलहुँ। ओ सभ जनैत अछि जे हम की कहलहुँ।” ");
INSERT INTO mai_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","हुनकर ई कहला पर, लग मे ठाढ़ एक सिपाही हुनका एक चमेटा मारलकनि और कहलकनि, “महापुरोहित केँ तोँ एहि प्रकारेँ उत्तर दैत छहुन?” ");
INSERT INTO mai_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","यीशु बजलाह, “जँ हम अनुचित बाजल छी, तँ तकर प्रमाण दिअ। मुदा जँ हम ठीक कहने छी तँ हमरा किएक मारैत छी?” ");
INSERT INTO mai_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","तखन हन्‍ना यीशु केँ बान्‍हले महापुरोहित काइफा लग पठा देलथिन। ");
INSERT INTO mai_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","एम्‍हर सिमोन पत्रुस आगि तपैत ठाढ़ छलाह। तँ लोक सभ हुनका पुछलकनि, “की अहूँ ओकरे चेला सभ मे सँ नहि छी?” ओ अस्‍वीकार करैत बजलाह, “हम नहि छी।” ");
INSERT INTO mai_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","महापुरोहितक एकटा नोकर, जे ओहि आदमीक सम्‍बन्‍धी छल जकरा पत्रुस कान छपटि देने छलाह, से हुनका सँ पुछलकनि, “की हम अहाँ केँ ओकरा संग गाछी मे नहि देखने छलहुँ?” ");
INSERT INTO mai_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पत्रुस फेर अस्‍वीकार कयलनि, और तुरत मुर्गा बाजि उठल। ");
INSERT INTO mai_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","तखन यीशु केँ काइफाक ओहिठाम सँ रोमी राज्‍यपालक भवन मे लऽ गेलनि। आब भोर भऽ गेल छल, और एहि डरेँ जे छुआ जायब आ फसह-भोज नहि खा सकब, यहूदी सभ अपने राजभवन मे नहि पैसल। ");
INSERT INTO mai_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","तेँ पिलातुस ओकरा सभ लग बाहर अयलाह और पुछलथिन, “एहि व्‍यक्‍ति पर की दोष लगबैत छी?” ");
INSERT INTO mai_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ओ सभ उत्तर देलक, “ओ जँ अपराधी नहि रहैत तँ हम सभ ओकरा अहाँ केँ नहि सौंपितहुँ!” ");
INSERT INTO mai_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पिलातुस कहलथिन, “अहीं सभ ओकरा लऽ जा कऽ अपन धर्म-नियमक अनुसार ओकर न्‍याय करिऔक।” यहूदी सभ उत्तर देलक, “ककरो मृत्‍युदण्‍ड देनाइ हमरा सभक अधिकार मे नहि अछि।” ");
INSERT INTO mai_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ई एहि लेल भेल जे यीशुक कहल बात पूरा होअय जाहि द्वारा ओ संकेत देने रहथि जे हुनकर मृत्‍यु कोन तरहेँ होयतनि। ");
INSERT INTO mai_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","तखन पिलातुस राजभवन मे फेर गेलाह और यीशु केँ अपना सामने मे बजा कऽ पुछलथिन, “की अहाँ यहूदी सभक राजा छी?” ");
INSERT INTO mai_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","यीशु उत्तर देलथिन, “की ई बात अहाँ अपना दिस सँ पुछि रहल छी, वा दोसर लोक हमरा बारे मे कहने अछि?” ");
INSERT INTO mai_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातुस बजलाह, “की हम यहूदी छी? अहींक लोक और अहींक मुख्‍यपुरोहित सभ अहाँ केँ हमरा हाथ मे सौंपि देने अछि। अहाँ की कयने छी?” ");
INSERT INTO mai_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","यीशु कहलथिन, “हमर राज्‍य एहि संसारक नहि अछि। जँ हमर राज्‍य एहि संसारक रहैत तँ हमर सेवक सभ लड़ैत जाहि सँ हम यहूदी सभक हाथ नहि पड़ितहुँ। मुदा नहि! हमर राज्‍य एहि संसारक नहि अछि!” ");
INSERT INTO mai_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","तखन पिलातुस बजलाह, “तखन राजा तँ छी?” यीशु उत्तर देलथिन, “से अहीं कहि रहल छी। हम एहि लेल जन्‍म लेलहुँ और संसार मे अयलहुँ जे हम सत्‍यक गवाही दी, और जे सभ सत्‍यक पक्ष मे छथि से सभ हमर बात सुनैत छथि।” ");
INSERT INTO mai_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातुस बजलाह, “सत्‍य अछि की?” आ फेर यहूदी सभ लग बाहर अयलाह और ओकरा सभ केँ कहलथिन, “ओकरा मे हम दोष लगयबाक कोनो आधार नहि पबैत छी। ");
INSERT INTO mai_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","लेकिन अहाँ सभक एक प्रथा अछि जे फसह-पाबनिक अवसर पर हम अहाँ सभक लेल एक कैदी केँ छोड़ैत छी। तँ की अहाँ सभ चाहैत छी जे हम अहाँ सभक लेल ‘यहूदी सभक राजा’ केँ छोड़ि दी?” ");
INSERT INTO mai_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","एहि पर ओ सभ जोर-जोर सँ हल्‍ला कऽ कऽ कहऽ लागल, “नहि! एकरा नहि! बरब्‍बा केँ!” बरब्‍बा एक क्रान्‍तिकारी अपराधी छल। ");
INSERT INTO mai_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","तखन पिलातुस यीशु केँ लऽ जा कऽ हुनका कोड़ा लगबौलनि। ");
INSERT INTO mai_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","सैनिक सभ काँटक मुकुट बना कऽ यीशुक माथ पर रखलकनि, और हुनका बैगनी रंगक राजसी वस्‍त्र पहिरा कऽ ");
INSERT INTO mai_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ई कहैत हुनका लग अबैत रहल जे, “यहूदी सभक राजा, प्रणाम!” और हुनका चमेटा मारैत छलनि। ");
INSERT INTO mai_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","पिलातुस फेर बाहर आबि कऽ यहूदी सभ केँ कहलथिन, “देखू! हम एकरा अहाँ सभ लग बाहर आनि रहल छिऐक जाहि सँ अहाँ सभ जानि लेब जे हम एकरा मे दोष लगयबाक कोनो आधार नहि पबैत छी!” ");
INSERT INTO mai_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","तखन यीशु ओ बैगनी वस्‍त्र और काँटक मुकुट पहिरने बाहर अयलाह। पिलातुस ओकरा सभ केँ कहलथिन, “देखू, यैह मनुष्‍य अछि!” ");
INSERT INTO mai_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","मुदा हुनका देखितहि मुख्‍यपुरोहित सभ और हुनकर सभक सिपाही सभ जोर-जोर सँ हल्‍ला कयलक, “क्रूस पर चढ़ाउ! क्रूस पर चढ़ाउ!” पिलातुस ओकरा सभ केँ कहलथिन, “अहीं सभ एकरा लऽ जाउ और क्रूस पर चढ़ाउ! कारण हम एकरा मे दोष लगयबाक कोनो आधार नहि पबैत छी।” ");
INSERT INTO mai_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहूदी सभ हुनका उत्तर देलकनि, “हमरा सभक एक नियम अछि, और ओहि अनुसार ओकरा मृत्‍युदण्‍ड भेटबाक चाही, कारण ओ अपना केँ परमेश्‍वरक पुत्र कहने अछि।” ");
INSERT INTO mai_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","पिलातुस जखन ई शब्‍द सुनलनि तखन आओर डेरा गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ओ राजभवन मे फेर जा कऽ यीशु सँ पुछलथिन, “अहाँ कोन ठाम सँ आयल छी?” मुदा यीशु कोनो उत्तर नहि देलथिन। ");
INSERT INTO mai_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","तँ पिलातुस कहलथिन, “की अहाँ हमरा सँ नहि बाजब? की अहाँ नहि जनैत छी जे अहाँ केँ छोड़ि देबाक और क्रूस पर चढ़यबाक सेहो हमर अधिकार अछि?” ");
INSERT INTO mai_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","यीशु बजलाह, “अहाँ केँ हमरा पर कोनो अधिकार नहि रहैत जँ अहाँ केँ ऊपर सँ नहि देल गेल रहैत। एहि कारणेँ, जे अहाँक हाथ मे हमरा सौंपि देलक, से आओर दोषी अछि।” ");
INSERT INTO mai_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ई सुनला पर, पिलातुस हुनका छोड़ि देबाक कोशिश कयलनि, मुदा यहूदी सभ हल्‍ला करैत छल जे, “जँ ओकरा छोड़ब तँ अहाँ सम्राट-कैसरक मित्र नहि भेलहुँ! जे केओ अपना केँ राजा कहैत अछि से कैसरक विरोधी अछि!” ");
INSERT INTO mai_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","पिलातुस ई बात सुनि कऽ, यीशु केँ बाहर अनबौलथिन और ओहि स्‍थान पर, जे “पाथरक चबुतरा” आ इब्रानी भाषा मे “गबथा” कहबैत अछि, न्‍याय-आसन पर बैसि गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ई फसह-पाबनिक तैयारीक दिन छल, और दुपहरियाक समय भऽ रहल छल। पिलातुस यहूदी सभ केँ कहलथिन, “लिअ! देखू, अहाँ सभक राजा!” ");
INSERT INTO mai_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","मुदा ओ सभ जोर-जोर सँ हल्‍ला कयलक, “ओकरा लऽ जाउ! लऽ जाउ! ओकरा क्रूस पर चढ़ाउ!” पिलातुस ओकरा सभ केँ कहलथिन, “की हम अहाँ सभक राजा केँ क्रूस पर चढ़ाउ?” मुख्‍यपुरोहित सभ उत्तर देलथिन, “कैसर केँ छोड़ि हमरा सभक आओर केओ राजा नहि अछि!” ");
INSERT INTO mai_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","तेँ अन्‍त मे पिलातुस हुनका क्रूस पर चढ़यबाक लेल सैनिक सभक जिम्‍मा लगा देलथिन। ");
INSERT INTO mai_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","तँ ओ सभ यीशु केँ लऽ गेलनि। क्रूस केँ अपने सँ ढो कऽ यीशु बाहर ओहि जगह पर गेलाह जे “खप्‍पड़ वला स्‍थान” (और इब्रानी भाषा मे “गुलगुता”) कहबैत अछि। ");
INSERT INTO mai_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ओहिठाम ओ सभ हुनका हाथ-पयर मे काँटी ठोकि कऽ क्रूस पर टाँगि देलकनि आ हुनका संगे दूटा आरो केँ सेहो, एकटा केँ एहि कातक क्रूस पर आ दोसर केँ ओहि कातक क्रूस पर, आ बीचला पर यीशु केँ। ");
INSERT INTO mai_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पिलातुस एक दोष-पत्र क्रूस पर लगबा देलनि, जाहि पर लिखल छलैक, “नासरत-निवासी यीशु, यहूदी सभक राजा”। ");
INSERT INTO mai_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","एहि सूचना केँ बहुत यहूदी पढ़लक, किएक तँ जाहि स्‍थान पर यीशु क्रूस पर चढ़ाओल गेलाह से शहरक नजदीक छल, और सूचना इब्रानी, लतीनी, और यूनानी भाषा मे लिखल छल। ");
INSERT INTO mai_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","तखन यहूदी सभक मुख्‍यपुरोहित सभ पिलातुस केँ कहलथिन, “ ‘यहूदी सभक राजा’ नहि लिखू! ई लिखू जे, ‘एकर कथन छल जे हम यहूदी सभक राजा छी’।” ");
INSERT INTO mai_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातुस उत्तर देलथिन, “हम जे लिखि देलहुँ से लिखि देलहुँ।” ");
INSERT INTO mai_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","सैनिक सभ यीशु केँ क्रूस पर चढ़ौलाक बाद हुनकर कपड़ा लऽ चारि भाग मे बाँटि लेलक, प्रत्‍येक सैनिकक लेल एक भाग। हुनकर कुर्तो लेलक, लेकिन कुर्ता बिना सिअनक ऊपर सँ नीचाँ तक बुनल छल। ");
INSERT INTO mai_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","तेँ ओ सभ एक-दोसर केँ कहलक, “एहि केँ नहि फाड़ी। पुरजा खसा कऽ देखी जे ई ककर होयतैक।” ई एहि लेल भेल जे धर्मशास्‍त्रक लेख पूरा होअय जे, “ओ सभ हमर कपड़ा अपना मे बाँटि लेलक और हमर वस्‍त्रक लेल पुरजा खसौलक।” और एहिना सैनिक सभ करबो कयलक। ");
INSERT INTO mai_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","यीशुक क्रूस लग हुनकर माय, मौसी, क्‍लोपासक स्‍त्री मरियम, और मरियम मग्‍दलीनी ठाढ़ छलीह। ");
INSERT INTO mai_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","यीशु जखन अपना माय केँ और ओहि शिष्‍य केँ, जिनका सँ ओ प्रेम करैत छलाह, लग मे ठाढ़ देखलथिन तखन अपना माय केँ कहलथिन, “ई अहाँक पुत्र अछि,” ");
INSERT INTO mai_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","और शिष्‍य केँ कहलथिन, “ई अहाँक माय छथि।” ओही समय सँ ओ शिष्‍य हुनका अपना घर लऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","बाद मे यीशु ई जानि जे आब सभ किछु पूर्ण भऽ गेल, धर्मशास्‍त्रक लेख पूरा करैत कहलनि, “हमरा पियास लागल अछि।” ");
INSERT INTO mai_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ओहिठाम तिताह दारू सँ भरल एक बर्तन राखल छल, तेँ ओ सभ रूइ जकाँ एकटा एहन चीज जे पानि सोखैत अछि से ओहि मे डुबा कऽ जूफाक ठाढ़ि मे अटका कऽ हुनका मुँह लग देलकनि। ");
INSERT INTO mai_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","यीशु ओ लऽ लेलनि आ कहलनि, “पूरा भेल,” और मूड़ी झुका कऽ प्राण त्‍यागि देलनि। ");
INSERT INTO mai_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ई फसह-पाबनिक तैयारीक दिन छल, आ दोसरे दिन महा विश्राम-दिन होमऽ वला छल, और तेँ, जाहि सँ विश्राम-दिन मे लास क्रूस पर टाँगल नहि रहय, यहूदी सभ पिलातुस सँ विनती कयलनि जे अपराधी सभ केँ टाँग तोड़ि कऽ मारि देल जाय, आ लास क्रूस पर सँ उतारि लेल जाय। ");
INSERT INTO mai_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","तेँ सैनिक सभ आबि कऽ यीशुक संग क्रूस पर चढ़ाओल पहिल आदमीक टाँग तोड़ि देलकैक, तखन दोसरो केँ। ");
INSERT INTO mai_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","मुदा जखन यीशु लग आबि कऽ देखलक जे ओ मरिए गेल छथि, तँ हुनकर टाँग नहि तोड़लकनि। ");
INSERT INTO mai_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","मुदा एक सैनिक हुनका पाँजर मे भाला भोंकलकनि, और तुरत खून आ पानि बहऽ लागल। ");
INSERT INTO mai_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","जे ई घटना देखलनि, से एकर गवाही देने छथि, और हुनकर गवाही पकिया अछि। ओ जनैत छथि जे ओ सत्‍य बाजि रहल छथि, और ओ गवाही दैत छथि जाहि सँ अहूँ सभ विश्‍वास करब। ");
INSERT INTO mai_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","कारण ई सभ बात एहि लेल भेल जाहि सँ धर्मशास्‍त्रक लेख पूरा होअय जे, “हुनकर एकोटा हड्डी नहि तोड़ल जयतनि,” ");
INSERT INTO mai_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","और जेना धर्मशास्‍त्रक दोसर कथन अछि, “ओ सभ तिनका दिस तकतनि, जिनका भोंकने अछि।” ");
INSERT INTO mai_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","एहि सभक बाद, अरिमतिया नगरक यूसुफ पिलातुस सँ यीशुक लास मँगलनि। यूसुफ यीशुक एक शिष्‍य छलाह, मुदा गुप्‍त रूप सँ, कारण ओ यहूदी सभ सँ डेराइत छलाह। ओ पिलातुस सँ आज्ञा माँगि, आबि कऽ यीशुक लास उतारि कऽ लऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","संग मे निकोदेमुस सेहो, जे शुरू मे रातुक समय यीशु लग आयल छलाह, लगभग पैंतीस सेर गन्‍धरस और मुसब्‍बरक मिश्रण लऽ कऽ अयलाह। ");
INSERT INTO mai_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ओ सभ यीशुक लास लऽ जा कऽ, यहूदी सभक गाड़बाक प्रथाक अनुसार, ओहि सुगन्‍धित द्रव्‍य सहित मलमलक पट्टी सँ लपेटलनि। ");
INSERT INTO mai_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","जाहिठाम यीशु केँ क्रूस पर चढ़ाओल गेल छलनि, ताहिठाम लग मे एक बगीचा छल। ओहि मे एक नव कबर बनाओल छल जाहि मे कहियो कोनो लास नहि राखल गेल छल। ");
INSERT INTO mai_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","तँ यहूदी सभक तैयारीक दिन होयबाक कारणेँ, और कबर लग मे रहबाक कारणेँ, ओ सभ यीशु केँ ओहि मे राखि देलथिन। ");
INSERT INTO mai_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","सप्‍ताहक पहिल दिन भोरे अन्‍हरोखे मरियम मग्‍दलीनी कबर पर गेलीह और देखलनि जे कबरक मुँह पर सँ पाथर हटाओल गेल अछि। ");
INSERT INTO mai_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ई देखि ओ दौड़ैत-दौड़ैत सिमोन पत्रुस और ओहि दोसर शिष्‍य लग जिनका सँ यीशु प्रेम करैत छलाह, गेलीह और कहलनि, “ओ सभ कबर मे सँ प्रभु केँ उठा कऽ लऽ गेल छनि, और हम सभ नहि जनैत छी जे हुनका कतऽ रखने छनि!” ");
INSERT INTO mai_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","एहि पर पत्रुस और दोसर शिष्‍य कबर दिस विदा भेलाह। ");
INSERT INTO mai_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","दूनू संग-संग दौड़लाह, मुदा दोसर शिष्‍य पत्रुस सँ आगाँ बढ़ि कऽ कबर पर पहिने पहुँचलाह। ");
INSERT INTO mai_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ओ निहुड़ि कऽ भीतर तकलनि और ओतऽ पड़ल मलमल वला पट्टी सभ देखलनि, मुदा भीतर नहि गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","तखन सिमोन पत्रुस हुनका पाछाँ-पाछाँ पहुँचलाह, और कबर मे पैसलाह। ");
INSERT INTO mai_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ओ पट्टी सभ केँ ओतऽ पड़ल देखलनि, और ओहि गमछा केँ सेहो, जाहि सँ यीशुक मूड़ी लपेटल छल। गमछा पट्टी सभक संग नहि, बल्‍कि हटले एक जगह चौपेतल राखल छल। ");
INSERT INTO mai_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","तखन ओ दोसर शिष्‍य जे कबर पर पहिने पहुँचल छलाह, सेहो भीतर गेलाह। ओ देखलनि और विश्‍वास कयलनि। ");
INSERT INTO mai_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(एखनो तक ओ सभ तँ नहि बुझैत छलाह जे धर्मशास्‍त्रक कथनानुसार हुनकर मृत्‍यु मे सँ जीबि उठनाइ आवश्‍यक छल।) ");
INSERT INTO mai_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","तखन ओ शिष्‍य सभ अपन-अपन घर चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","मुदा मरियम कबरक बाहर कनिते ठाढ़ रहलीह। कनैत-कनैत ओ निहुड़ि कऽ कबर मे तकलनि। ");
INSERT INTO mai_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ओ उज्‍जर वस्‍त्र पहिरने दू स्‍वर्गदूत केँ ओहिठाम बैसल देखलनि जाहिठाम यीशुक लास राखल गेल छल, एक सीरहान लग और दोसर पौथान लग। ");
INSERT INTO mai_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ओ सभ हुनका सँ पुछलथिन, “बहिन, अहाँ किएक कनैत छी?” ओ उत्तर देलथिन, “ओ सभ हमरा प्रभु केँ उठा कऽ लऽ गेल अछि, और हम नहि जनैत छी जे हुनका कतऽ रखने छनि।” ");
INSERT INTO mai_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ई कहि, ओ घुमलीह और लग मे ठाढ़ यीशु केँ देखलनि, मुदा ओ नहि चिन्‍हलनि जे ई यीशु छथि। ");
INSERT INTO mai_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","यीशु हुनका कहलथिन, “बहिन, अहाँ कनैत किएक छी? किनका खोजि रहल छिऐन?” ओ हुनका माली बुझि कऽ कहलथिन, “यौ मालीजी, अहीं जँ हुनका उठा कऽ लऽ गेल छिऐन तँ हमरा कहू जे कतऽ रखने छिऐन। हम जा कऽ हुनका लऽ अनबनि।” ");
INSERT INTO mai_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","यीशु बजलाह, “मरियम!” ओ हुनका दिस घुरि कऽ इब्रानी भाषा मे कहलथिन, “रब्‍बुनी!” (जकर अर्थ अछि “गुरुजी!”) ");
INSERT INTO mai_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","यीशु कहलथिन, “हमरा नहि पकड़ू! कारण हम एखन पिता लग ऊपर नहि गेल छी। आब हमर भाय सभक ओहिठाम जा कऽ कहि दिऔन जे, हम अपना पिता और अहाँ सभक पिता, अपना परमेश्‍वर और अहाँ सभक परमेश्‍वर लग ऊपर जा रहल छी।” ");
INSERT INTO mai_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","मरियम मग्‍दलीनी जा कऽ शिष्‍य सभ केँ कहलनि, “हम प्रभु केँ देखने छी!” और ओ हुनका सभ केँ हुनकर कहल बात सुनौलथिन। ");
INSERT INTO mai_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ओहि दिनक साँझ, अर्थात् सप्‍ताहक पहिल दिन, जखन शिष्‍य सभ यहूदी सभक डरेँ घरक केबाड़ सभ बन्‍द कऽ कऽ एक संग बैसल छलाह, तखन यीशु आबि कऽ हुनका सभक बीच ठाढ़ भऽ गेलाह और कहलथिन, “अहाँ सभ केँ शान्‍ति भेटय।” ");
INSERT INTO mai_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ई कहि ओ हुनका सभ केँ अपन हाथ और पाँजर देखौलथिन। प्रभु केँ देखि शिष्‍य सभक आनन्‍दक कोनो सीमा नहि रहलनि। ");
INSERT INTO mai_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ओ हुनका सभ केँ फेर कहलथिन, “अहाँ सभ केँ शान्‍ति भेटय। जेना हमरा पिता पठौने छथि, तहिना हमहूँ अहाँ सभ केँ पठबैत छी।” ");
INSERT INTO mai_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ई कहि ओ हुनका सभ पर फुकलथिन और कहलथिन, “पवित्र आत्‍मा केँ लिअ। ");
INSERT INTO mai_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","जँ ककरो पाप माफ कऽ देबैक, तँ ओकर पाप माफ भेलैक। जँ ककरो पाप माफ नहि कऽ देबैक तँ ओकर पाप माफ नहि भेलैक।” ");
INSERT INTO mai_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","मुदा बारह शिष्‍य मे सँ एक, थोमा, जे “जौंआ” कहबैत छथि, से आरो शिष्‍य सभक संग ओहि समय मे नहि छलाह जखन यीशु आयल छलाह। ");
INSERT INTO mai_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","जखन ओ सभ हुनका कहऽ लगलनि, “हम सभ प्रभु केँ देखने छी,” तँ ओ कहलथिन, “जा धरि हम हुनका हाथ मे काँटीक चेन्‍ह देखि ओहि छेद मे अपन आङुर नहि पैसायब आ हुनकर पाँजर मे अपन हाथ नहि धऽ लेब, ता धरि हम किन्‍नहुँ नहि विश्‍वास करब।” ");
INSERT INTO mai_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","आठ दिनक बाद शिष्‍य सभ फेर घर मे छलाह, और थोमा सेहो संग छलाह। केबाड़ सभ बन्‍द रहितो, यीशु अयलाह और हुनका सभक मध्‍य ठाढ़ भऽ बजलाह, “अहाँ सभ केँ शान्‍ति भेटय।” ");
INSERT INTO mai_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","तखन थोमा केँ कहलथिन, “एहिठाम अपन आङुर धऽ लिअ, और हमर हाथ देखि लिअ। अपन हाथ लाउ और हमरा पाँजर मे धऽ लिअ। अविश्‍वासी नहि, विश्‍वासी बनू।” ");
INSERT INTO mai_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","थोमा उत्तर देलथिन, “हे हमर प्रभु, हे हमर परमेश्‍वर!” ");
INSERT INTO mai_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","यीशु हुनका कहलथिन, “अहाँ हमरा देखबाक कारणेँ विश्‍वास करैत छी, धन्‍य छथि ओ सभ जे बिनु देखनहि विश्‍वास करैत छथि।” ");
INSERT INTO mai_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","यीशु आरो बहुत चमत्‍कारपूर्ण चिन्‍ह अपना शिष्‍य सभक समक्ष देखौलनि जे एहि पुस्‍तक मे नहि लिखल अछि। ");
INSERT INTO mai_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","मुदा जे सभ लिखल अछि से एहि लेल जे अहाँ सभ विश्‍वास करी जे यीशु उद्धारकर्ता-मसीह और परमेश्‍वरक पुत्र छथि, और जे विश्‍वास कयला सँ अहाँ सभ केँ हुनका द्वारा जीवन प्राप्‍त होअय। ");
INSERT INTO mai_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","एकरा बाद, तिबिरियास झीलक कात यीशु फेर शिष्‍य सभ केँ देखाइ देलनि जे एहि तरहेँ भेल— ");
INSERT INTO mai_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","सिमोन पत्रुस, थोमा, जे “जौंआ” कहबैत छथि, गलीलक काना गामक नथनेल, जबदीक दू पुत्र, आ दूटा आओर शिष्‍य एक संग छलाह। ");
INSERT INTO mai_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","सिमोन पत्रुस हुनका सभ केँ कहलथिन, “हम माछ मारऽ जाइत छी।” ओ सभ उत्तर देलथिन, “हमहूँ सभ चलैत छी।” ओ सभ बाहर जा कऽ नाव मे चढ़लाह, मुदा ओहि राति किछु नहि पकड़ि सकलाह। ");
INSERT INTO mai_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","भोर होइतहि यीशु कछेर पर ठाढ़ छलाह, मुदा शिष्‍य सभ नहि चिन्‍हलनि जे ई यीशु छथि। ");
INSERT INTO mai_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ओ हुनका सभ केँ सोर पारैत पुछलथिन, “यौ बाउ सभ! की अहाँ सभ किछु नहि पकड़ने छी?” ओ सभ उत्तर देलथिन, “नहि।” ");
INSERT INTO mai_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ओ कहलथिन, “नावक दहिना कात जाल फेकू तँ बहुत भेटत।” ओ सभ जाल फेकलनि तँ ततेक माछ फँसलनि जे ओ सभ जाल नाव मे नहि खीचि सकैत छलाह। ");
INSERT INTO mai_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","तखन ओ शिष्‍य जिनका सँ यीशु प्रेम करैत छलाह, पत्रुस केँ कहलथिन, “ई तँ प्रभु छथि!” ई शब्‍द सुनितहि जे, ई प्रभु छथि, सिमोन पत्रुस अपन कपड़ा पहिरि लेलनि (ओ ई कपड़ा खोलि कऽ रखने छलाह), और झील मे कुदि पड़लाह। ");
INSERT INTO mai_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","मुदा बाँकी शिष्‍य सभ माछ सँ भरल जाल खिचैत, नाव मे अयलाह, किएक तँ कछेर सँ बेसी दूर नहि, लगभग 200 हाथ पर छलाह। ");
INSERT INTO mai_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ओ सभ जखन कछेर पर अयलाह तखन देखलनि जे कोइलाक आगि पर माछ राखल अछि, और रोटी सेहो अछि। ");
INSERT INTO mai_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","यीशु हुनका सभ केँ कहलथिन, “जे माछ अहाँ सभ एखने पकड़लहुँ, ओहि मे सँ किछु लाउ।” ");
INSERT INTO mai_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","सिमोन पत्रुस नाव पर चढ़ि कऽ जाल कछेर पर खिचलनि। जाल बड़का-बड़का माछ सँ भरल छल, सभ मिला कऽ एक सय तिरपन, मुदा एतेक होइतो जाल नहि फाटल। ");
INSERT INTO mai_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","यीशु हुनका सभ केँ कहलथिन, “आउ, जलखइ कऽ लिअ।” शिष्‍य सभ मे सँ किनको हुनका सँ ई पुछबाक साहस नहि भेलनि जे, अहाँ के छी? ओ सभ तँ जनैत छलाह जे ई प्रभु छथि। ");
INSERT INTO mai_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","तखन यीशु अयलाह, आ रोटी लऽ कऽ हुनका सभ केँ देलथिन, और तहिना माछो। ");
INSERT INTO mai_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ई आब तेसर बेर अछि जे यीशु मृत्‍यु मे सँ जिआओल गेलाक बाद शिष्‍य सभ केँ देखाइ देलथिन। ");
INSERT INTO mai_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","हुनका सभ केँ जलखइ कयलाक बाद यीशु सिमोन पत्रुस केँ कहलथिन, “सिमोन, यूहन्‍नाक पुत्र, की अहाँ हिनका सभ सँ बढ़ि कऽ हमरा सँ प्रेम करैत छी?” ओ उत्तर देलथिन, “हँ, प्रभु, अहाँ जनैत छी जे हम अहाँ सँ प्रेम करैत छी।” यीशु कहलथिन, “तँ हमर नव भेँड़ा केँ चराउ।” ");
INSERT INTO mai_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","फेर दोसर बेर यीशु पुछलथिन, “सिमोन, यूहन्‍नाक पुत्र, की अहाँ वास्‍तव मे हमरा सँ प्रेम करैत छी?” ओ उत्तर देलथिन, “हँ, प्रभु, अहाँ तँ जनैत छी जे हम अहाँ सँ प्रेम करैत छी।” यीशु बजलाह, “हमर भेँड़ाक देख-रेख करू।” ");
INSERT INTO mai_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","फेर तेसर बेर यीशु पुछलथिन, “सिमोन, यूहन्‍नाक पुत्र, की अहाँ हमरा सँ प्रेम करैत छी?” पत्रुस दुखी भेलाह जे यीशु तेसर बेर पुछलनि जे, “की अहाँ हमरा सँ प्रेम करैत छी?” ओ उत्तर देलथिन, “प्रभु, अहाँ तँ सभ किछु जनैत छी। अहाँ जनैत छी जे हम अहाँ सँ प्रेम करैत छी।” यीशु हुनका कहलथिन, “हमर भेँड़ा केँ चराउ। ");
INSERT INTO mai_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","हम अहाँ केँ सत्‍ये कहैत छी जे जखन अहाँ जबान छलहुँ, तखन अहाँ अपन डाँड़ अपने कसि लैत छलहुँ, आ जतऽ मोन होइत छल ततऽ जाइत छलहुँ। मुदा जखन अहाँ बूढ़ भऽ जायब, तखन हाथ पसारब और केओ दोसर अहाँक डाँड़ बान्‍हि कऽ अहाँ केँ ततऽ लऽ जायत जतऽ अहाँ नहि जाय चाहब।” ");
INSERT INTO mai_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(ओ ई बात एकर संकेत देबाक लेल कहलथिन जे पत्रुस कोन तरहक मृत्‍यु द्वारा परमेश्‍वरक महिमा प्रगट करताह।) तखन ओ हुनका कहलथिन, “हमरा पाछाँ चलू।” ");
INSERT INTO mai_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पत्रुस घूमि कऽ देखलनि जे ओहो शिष्‍य पाछाँ-पाछाँ अबैत छथि जिनका सँ यीशु प्रेम करैत छलाह, और जे भोजन करैत समय हुनका छाती लग ओंगठि कऽ हुनका सँ पुछने छलनि जे, प्रभु, ओ के अछि जे अहाँ केँ पकड़बाओत? ");
INSERT INTO mai_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","पत्रुस ओहि शिष्‍य केँ देखि कऽ यीशु सँ पुछलथिन, “प्रभु, हिनकर की होयतनि?” ");
INSERT INTO mai_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","यीशु उत्तर देलथिन, “जँ हम चाही जे जा धरि हम फेर नहि आयब ता धरि ओ जीबैत रहथि, तँ एहि सँ अहाँ केँ की? अहाँ हमरा पाछाँ चलू!” ");
INSERT INTO mai_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","एहि कारणेँ भाय सभ मे ई कथन पसरि गेल जे ओ शिष्‍य नहि मरताह। मुदा यीशु ई नहि कहने छलाह जे ओ नहि मरताह; ओ मात्र ई कहने छलाह जे, जँ हम चाही जे जा धरि हम फेर नहि आयब, ता धरि ओ जीबैत रहथि तँ एहि सँ अहाँ केँ की? ");
INSERT INTO mai_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","और ओ शिष्‍य वैह छथि जे एहि सभ बातक गवाही दऽ रहल छथि और लिखने छथि। हम सभ जनैत छी जे हुनकर गवाही सत्‍य अछि। ");
INSERT INTO mai_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","आओर बहुत काज अछि जे यीशु कयलनि। जँ ओकरा एक-एकटा कऽ लिखल जाइत तँ हम सोचैत छी जे, जे किताब सभ लिखल जाइत से सौंसे संसार मे नहि अँटैत।");
INSERT INTO mai_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","आदरणीय थियुफिलुस, हम अपन पहिल पुस्‍तक मे यीशुक सभ काज आ शिक्षा जे ओ शुरू सँ लऽ कऽ स्‍वर्ग मे उठा लेल गेलाह ताहि दिन धरि कयलनि तकर सम्‍पूर्ण विवरण लिखने छी। स्‍वर्ग मे उठाओल जाय सँ पहिने ओ अपन चुनल दूत सभ केँ परमेश्‍वरक पवित्र आत्‍मा द्वारा अपन आदेश सभ देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","हुनका सभक मध्‍य ओ मुइलाक बाद चालिस दिन धरि बेर-बेर प्रगट भऽ कऽ एहि बातक अकाट्‌य प्रमाण दैत रहलाह जे ओ जीबि उठल छथि। ओ ओहि समय मे हुनका सभ केँ परमेश्‍वरक राज्‍यक विषय मे शिक्षा दैत छलाह ");
INSERT INTO mai_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","आ एक दिन जखन हुनका सभक संग छलथिन तँ ओ ई आदेश देलथिन जे, “अहाँ सभ ताबत धरि यरूशलेम सँ बाहर नहि जाउ जाबत धरि ओ बात अहाँ सभ केँ प्राप्‍त नहि भऽ जायत जे बात अहाँ सभ केँ देबाक लेल हमर पिता वचन देने छथि। एहि बातक सम्‍बन्‍ध मे हम पहिनहि अहाँ सभ केँ कहने छी जे, ");
INSERT INTO mai_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","यूहन्‍ना तँ पानि सँ बपतिस्‍मा देलनि मुदा अहाँ सभ केँ किछु दिन मे पवित्र आत्‍मा सँ बपतिस्‍मा देल जायत।” ");
INSERT INTO mai_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","एक दिन यीशु जखन फेर अपन दूत सभक संग छलाह तखन ओ सभ हुनका सँ पुछलथिन, “प्रभु, की अहाँ एही समय मे इस्राएली सभ केँ अपन राज्‍य फिरता करबा देब?” ");
INSERT INTO mai_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ओ उत्तर देलथिन, “कहिया कखन की होयत, से पिता अपना अधिकार सँ निश्‍चित कयने छथि, आ ताहि बात केँ जानी से अहाँ सभक काज नहि अछि। ");
INSERT INTO mai_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","मुदा जखन अहाँ सभ पर पवित्र आत्‍मा औताह तँ अहाँ सभ सामर्थ्‍य प्राप्‍त करब आ यरूशलेम मे, सम्‍पूर्ण यहूदिया और सामरिया प्रदेश मे, आ सम्‍पूर्ण पृथ्‍वी पर अहाँ सभ हमर गवाह होयब।” ");
INSERT INTO mai_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","एतेक कहलाक बाद हुनका सभक देखिते-देखिते ओ ऊपर उठा लेल गेलाह और एकटा मेघ आबि कऽ हुनका सभक नजरिक सोझाँ सँ हुनका झाँपि लेलकनि। ");
INSERT INTO mai_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","जखन मसीह-दूत सभ यीशु केँ ऊपर उठा लेल गेलाक बादो टकटकी लगा कऽ आकाश दिस तकिते रहलाह तखन एकाएक उज्‍जर वस्‍त्र पहिरने दूटा पुरुष हुनका सभ लग ठाढ़ भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ओ सभ मसीह-दूत सभ केँ कहलथिन, “हे गलीलक लोक सभ, अहाँ सभ आकाश दिस की तकैत छी? यैह यीशु जे अहाँ सभ लग सँ स्‍वर्ग मे उठा लेल गेलाह से ओही तरहेँ एक दिन फेर औताह जाहि तरहेँ अहाँ सभ हुनका स्‍वर्ग जाइत देखलहुँ।” ");
INSERT INTO mai_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","तखन मसीह-दूत सभ जैतून पहाड़ नामक परवत पर सँ यरूशलेम घुरि अयलाह। ओ पहाड़ यरूशलेम सँ करीब आधा कोस दूर अछि। ");
INSERT INTO mai_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","यरूशलेम पहुँचि कऽ ओ सभ उपरका कोठली मे गेलाह जाहि मे ओ सभ ठहरल छलाह। हुनका सभक नाम ई अछि—पत्रुस, यूहन्‍ना, याकूब और अन्‍द्रेयास, फिलिपुस और थोमा, बरतुल्‍मै और मत्ती, अल्‍फेयासक पुत्र याकूब और “देश-भक्‍त” सिमोन और याकूबक पुत्र यहूदा। ");
INSERT INTO mai_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ओ सभ किछु स्‍त्रीगण, यीशुक माय मरियम और हुनकर भाय सभक संग मिलि कऽ एक चित्त भऽ नित्‍य प्रार्थना करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ओहि समय मे एक दिन विश्‍वासी भाय सभक बीच, अर्थात् करीब एक सय बीस व्‍यक्‍तिक समुदाय मे, पत्रुस ठाढ़ भऽ कहऽ लगलाह, ");
INSERT INTO mai_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“यौ भाइ लोकनि, ई निश्‍चित छल जे धर्मशास्‍त्रक ओ बात पूरा होअय जे पवित्र आत्‍मा दाऊदक माध्‍यम सँ यहूदाक विषय मे पहिनहि कहलनि। यहूदा हमरा सभ मे सँ एक, और एहि सेवा-काज मे सहभागी होइतो, जे सभ यीशु के पकड़ऽ चाहैत छल, तकरा सभ केँ यीशु केँ चिन्‍हौलकैक।” ");
INSERT INTO mai_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(यहूदा पापक कमाइ सँ एक खेत मोल लेलक जतऽ ओ मुँहे भरे खसल। ओकर पेट फाटि गेलैक और अँतड़ी-भोतरी बाहर भऽ गेलैक। ");
INSERT INTO mai_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","एहि बात केँ सम्‍पूर्ण यरूशलेम मे रहऽ वला लोक सभ बुझि गेल, आ तेँ ओहि खेतक नाम ओ सभ अपना भाषा मे “हकलदामा”, अर्थात् “खूनक खेत”, राखि देलक।) ");
INSERT INTO mai_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“हँ, धर्मशास्‍त्रक बात पूरा होयबाक छल, कारण भजन-संग्रहक पुस्‍तक मे लिखल अछि, ‘ओकर वास स्‍थान उजड़ि जाय आ ओहि मे रहऽ वला केओ नहि होअय।’ और, ‘ओकर पद और अधिकार केओ दोसर लेअय।’ ");
INSERT INTO mai_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“तेँ आब ई जरूरी अछि जे अपना सभ ककरो चुनी जे अपना सभक संग प्रभु यीशुक जीबि उठनाइक गवाही देत। ओकरा तकरा सभ मे सँ चुनल जाय जे सभ ओहि समय सँ अपना सभक संग अछि जाहि समय मे प्रभु यीशु अपना सभक बीच रहलाह, अर्थात् यूहन्‍नाक बपतिस्‍मा सँ लऽ कऽ प्रभु यीशुक स्‍वर्ग उठाओल जयबाक समय धरि।” ");
INSERT INTO mai_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","तँ ओ सभ दू आदमीक नामक सुझाव देलनि—एकटा यूसुफ, जे बरसब्‍बा कहबैत छलाह और जिनकर दोसर नाम यूस्‍तुस सेहो छलनि; आ दोसर मतिया। ");
INSERT INTO mai_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","तखन ओ सभ प्रार्थना कयलनि जे, “यौ प्रभु, सभक हृदय अहाँ जनैत छी। हमरा सभ केँ ई बुझा दिअ जे एहि दूनू मे सँ अहाँ मसीह-दूतक ओहि पद आ सेवा-काजक लेल किनका चुनलहुँ, जाहि पद केँ त्‍यागि कऽ यहूदा अपना स्‍थान पर चल गेल।” ");
INSERT INTO mai_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","तकरबाद ओ सभ पुरजी खसौलनि, आ पुरजी मतियाक नाम सँ बाहर भेल, और ओ एगारहो मसीह-दूतक संग सम्‍मिलित कयल गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","पेन्‍तेकुस्‍त पाबनिक दिन अयला पर सभ विश्‍वासी एके ठाम जमा छलाह। ");
INSERT INTO mai_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","एकाएक आकाश सँ बड़का अन्‍हड़-बिहारि जकाँ आवाज आयल और ओ घर जाहि मे ओ सभ बैसल छलाह से ओहि आवाज सँ गोंगिया उठल। ");
INSERT INTO mai_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ओ सभ देखलनि जे जीहक आकार मे आगि सनक कोनो वस्‍तु आयल और अलग-अलग भऽ कऽ हुनका सभ मे प्रत्‍येक गोटे पर रूकि गेल। ");
INSERT INTO mai_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","सभ केओ पवित्र आत्‍मा सँ परिपूर्ण भऽ गेलाह और पवित्र आत्‍मा हुनका सभ केँ जे बजबाक क्षमता देलनि, ताहि अनुसार ओ सभ भिन्‍न-भिन्‍न भाषा मे बाजऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ओहि समय मे परमेश्‍वर केँ मानऽ वला बहुत देशक यहूदी सभ यरूशलेम मे रहैत छल। ");
INSERT INTO mai_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ई आवाज जखन भेल तँ बहुत लोक ओतऽ जमा भऽ गेल आ गुम्‍म रहि गेल, कारण मसीह-दूत सभ जे बात बजैत छलाह से ओ सभ अपना-अपना भाषा मे सुनैत छल। ");
INSERT INTO mai_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ओ सभ अकचका कऽ कहलक, “की ई सभ जे बाजि रहल छथि से सभ गलीले प्रदेशक नहि छथि? ");
INSERT INTO mai_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","तँ ई कोना भेल जे अपना सभ हिनकर सभक बात अपना-अपना मातृभाषा मे सुनि रहल छी? ");
INSERT INTO mai_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","अपना सभ जे पार्थी, मेदी और एलामी लोक छी, मेसोपोतामिया, यहूदिया, कप्‍पदुकिया, पुन्‍तुस, आसिया, ");
INSERT INTO mai_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","फ्रूगिया, पंफूलिया, मिस्र और कुरेनक लग मे पड़ऽ वला लिबियाइ क्षेत्रक निवासी छी, रोम सँ आयल यहूदी लोक आ दोसर समाजक लोक जे यहूदी धर्म केँ स्‍वीकार कयने अछि, ");
INSERT INTO mai_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","से छी, क्रेत द्वीपक वासी और अरबी लोक सभ छी—से हिनका सभक मुँह सँ परमेश्‍वरक महान्‌ काजक चर्चा अपना-अपना भाषा मे कोना सुनि रहल छी?” ");
INSERT INTO mai_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ओ सभ आश्‍चर्यित भऽ कऽ एक-दोसर सँ पुछऽ लागल, “एकर अर्थ की भऽ सकैत अछि?” ");
INSERT INTO mai_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","एहि पर किछु लोक ठट्ठा करैत कहऽ लागल, “ई सभ दारू पिबि कऽ मातल अछि।” ");
INSERT INTO mai_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","तखन पत्रुस एगारहो मसीह-दूतक संग ठाढ़ भेलाह और भीड़क लोक केँ जोर सँ कहऽ लगलथिन, “यहूदी भाइ लोकनि आ यरूशलेमक सभ निवासी, हम जे किछु कहैत छी तकरा ध्‍यानपूर्बक सुनू। ");
INSERT INTO mai_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","अहाँ सभ ई बुझि लिअ जे हम सभ मातल नहि छी, जेना कि अहाँ सभ सोचि रहल छी, कारण एखन तँ भोरक नौए बाजल अछि! ");
INSERT INTO mai_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","नहि, ई वैह बात अछि जकरा सम्‍बन्‍ध मे परमेश्‍वरक प्रवक्‍ता योएल कहने छथि, ");
INSERT INTO mai_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘परमेश्‍वर ई कहैत छथि जे, अन्‍त समय मे सभ वर्गक मनुष्‍य केँ हम अपन आत्‍मा देबैक। तखन तोरा सभक बेटा-बेटी सभ हमरा सँ सम्‍बाद पाओत आ सुनाओत। तोरा सभक युवक सभ हमरा द्वारा प्रगट कयल दृश्‍य देखत, और तोरा सभक वृद्ध लोकनि सपना देखत। ");
INSERT INTO mai_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","हँ, हम अपन दास-दासी सभ केँ सेहो ओहि समय मे अपन आत्‍मा देबैक और ओ सभ हमरा सँ सम्‍बाद पाओत आ सुनाओत। ");
INSERT INTO mai_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","हम ऊपर आकाश मे अद्‌भुत काज सभ करब आ नीचाँ पृथ्‍वी पर आश्‍चर्यजनक चिन्‍ह सभ देखायब, जेना कि खून, आगि और गाढ़ धुआँ। ");
INSERT INTO mai_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","परमेश्‍वरक महान् महिमापूर्ण दिन आबऽ सँ पहिने सूर्य अन्‍हार भऽ जायत आ चन्‍द्रमाक रंग खून सन लाल भऽ जायत। ");
INSERT INTO mai_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","मुदा जे केओ प्रभु सँ विनती करत तकर उद्धार होयतैक।’ ");
INSERT INTO mai_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“इस्राएली भाइ लोकनि, हमर बात सुनू। परमेश्‍वर नासरत-निवासी यीशु द्वारा अहाँ सभक बीच मे बहुत आश्‍चर्यजनक काज आ चमत्‍कारपूर्ण चिन्‍ह देखौलनि, जे अहाँ सभ केँ बुझले अछि। ओ एहि काज आ चिन्‍ह सभक द्वारा एहि बात केँ प्रमाणित कयलनि जे हुनका ओ अपने पठौने छथि। ");
INSERT INTO mai_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ओ परमेश्‍वरक निश्‍चित योजना आ पूर्वज्ञानक अनुसार अहाँ सभक जिम्‍मा मे देल गेलाह और अहाँ सभ हुनका अधर्मी सभक हाथेँ क्रूस पर चढ़बा कऽ मारि देलियनि। ");
INSERT INTO mai_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","मुदा परमेश्‍वर हुनका मृत्‍युक कष्‍ट सँ मुक्‍त कऽ कऽ फेर जीवित कऽ देलथिन, कारण ई असम्‍भव छल जे मृत्‍यु अपना वश मे हुनका रखितनि। ");
INSERT INTO mai_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","जेना दाऊद हुनका विषय मे कहलनि, ‘हम देखलहुँ जे प्रभु सदिखन हमरा सामने छथि, ओ हमर दहिन छथि, तेँ हम डगमगायब नहि। ");
INSERT INTO mai_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","एहि कारणेँ हम खुशी मोन सँ अहाँक स्‍तुति गबैत छी, हम अपन शरीरक लेल सेहो अहाँ पर भरोसा रखैत छी, ");
INSERT INTO mai_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","कारण, अहाँ हमरा मरले नहि छोड़ब और ने अपन पवित्र सेवक केँ सड़ऽ देब। ");
INSERT INTO mai_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","अहाँ हमरा जीवनक बाट देखौने छी; अहाँक संगति मे हम आनन्‍द सँ गद्‌गद्‌ होयब।’ ");
INSERT INTO mai_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“भाइ लोकनि, हम अहाँ सभ केँ खुलि कऽ कहि सकैत छी जे अपना सभक कुल-पिता दाऊद मरलाह आ गाड़ल गेलाह और हुनकर कबर एखनो कायम अछि। ");
INSERT INTO mai_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","मुदा ओ परमेश्‍वरक प्रवक्‍ता छलाह और ओ जनैत छलाह जे परमेश्‍वर सपत खा कऽ हुनका वचन देने छथिन जे, हम तोरा वंश मे सँ एक आदमी केँ तोरा सिंहासन पर बैसयबह। ");
INSERT INTO mai_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","तेँ जखन ओ कहलनि जे हमरा मरले नहि छोड़ल जायत आ ने हमर शरीर सड़त तँ से ओ उद्धारकर्ता-मसीहक जीबि उठनाइक सम्‍बन्‍ध मे कहलनि, किएक तँ परमेश्‍वर हुनका पहिने सँ ओ बात देखौने छलथिन। ");
INSERT INTO mai_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","एही यीशु केँ परमेश्‍वर जिआ देलथिन तकर हम सभ केओ साक्षी छी। ");
INSERT INTO mai_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","हुनका परमेश्‍वरक दहिना कातक सर्वोच्‍च पद देल गेलनि, और जहिना पिता हुनका वचन देने छलथिन, तहिना ओ हुनका सँ पवित्र आत्‍मा प्राप्‍त कयलनि। और अहाँ सभ आइ जे बात देखि आ सुनि रहल छी, से एकर परिणाम अछि जे ओ हमरा सभ केँ वैह पवित्र आत्‍मा देने छथि। ");
INSERT INTO mai_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","दाऊद तँ स्‍वर्ग पर नहि उठाओल गेलाह, तैयो ओ बजलाह, ‘प्रभु-परमेश्‍वर हमर प्रभु केँ कहलथिन, अहाँ हमर दहिना कात बैसू, ");
INSERT INTO mai_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","और हम अहाँक शत्रु सभ केँ अहाँक पयरक तर मे कऽ देब।’ ");
INSERT INTO mai_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“तेँ समस्‍त इस्राएली लोक ई निश्‍चय जानि लेअय जे एही यीशु केँ जिनका अहाँ सभ क्रूस पर चढ़ा कऽ मारि देलियनि, परमेश्‍वर तिनके प्रभु और उद्धारकर्ता-मसीह ठहरा देलथिन।” ");
INSERT INTO mai_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","सुनऽ वला लोक सभक मोन मे ई बात गड़ि गेलैक, और ओ सभ पत्रुस और आन मसीह-दूत सभ सँ पुछलकनि, “यौ भाइ लोकनि, हम सभ आब की करू?” ");
INSERT INTO mai_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पत्रुस उत्तर देलथिन, “अहाँ सभ गोटे अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन करू और यीशु मसीहक नाम सँ बपतिस्‍मा लिअ, जाहि सँ परमेश्‍वर अहाँ सभक पाप केँ क्षमा करथि आ अहाँ सभ केँ पवित्र आत्‍मा प्रदान करथि। ");
INSERT INTO mai_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","कारण, परमेश्‍वर जे वचन देलनि, से अहाँ सभक लेल और अहाँ सभक सन्‍तानक लेल अछि, और तकरो सभक लेल जे दूर-दूर रहैत अछि; हँ, तकरा सभ गोटेक लेल जकरा सभ केँ अपना सभक प्रभु-परमेश्‍वर अपना लग बजौथिन।” ");
INSERT INTO mai_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पत्रुस आरो बहुत बात द्वारा ओकरा सभ केँ बुझौलथिन आ चेतावनी दैत आग्रह कयलथिन जे, “अहाँ सभ एहि भ्रष्‍ट पीढ़ी पर आबऽ वला दण्‍ड सँ बँचू!” ");
INSERT INTO mai_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","जे सभ हुनकर बात स्‍वीकार कयलक, से सभ बपतिस्‍मा लेलक। ओहि दिन करीब तीन हजार लोक विश्‍वासी सभक समूह मे सम्‍मिलित भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ओ सभ मसीह-दूत सभक शिक्षा मे, सत्‍संग मे, “प्रभु-भोज” मे आ प्रार्थना मे तल्‍लीन रहऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","मसीह-दूत सभक द्वारा बहुत चमत्‍कारपूर्ण काज आ चिन्‍ह सभ देखाओल जाइत छल जकरा देखि सभ लोक आश्‍चर्य आ भय सँ भरि जाइत छल। ");
INSERT INTO mai_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","सभ विश्‍वासी मिलि-जुलि कऽ रहैत छलाह, और सभ धन-सम्‍पत्ति केँ सझिआ बुझैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ओ सभ अपन घर-जमीन वा धन-सम्‍पत्ति बेचि कऽ जिनका जेहन आवश्‍यकता होइत छलनि, ताहि अनुसार अपना मे बाँटि लैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","हरेक दिन ओ सभ मन्‍दिर मे जमा होइत छलाह, घर-घर मे “प्रभु-भोज” ग्रहण करैत छलाह, और खुशी आ विनम्र मोन सँ एक संग भोजन करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ओ सभ परमेश्‍वरक स्‍तुति करैत रहलाह और सभ लोक हुनका सभ सँ प्रसन्‍न छलनि। प्रभु प्रति दिन आरो-आरो लोक सभ केँ जे सभ उद्धार पबैत छलाह तिनका सभ केँ विश्‍वासी सभक समूह मे सम्‍मिलित करैत जाइत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","एक दिन पत्रुस आ यूहन्‍ना दुपहरियाक तीन बजे प्रार्थनाक समय मे मन्‍दिर जा रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ओही समय मे किछु लोक जन्‍म सँ लोथ एक आदमी केँ अनलक और मन्‍दिरक “सुन्‍दर” नामक द्वारि लग, जतऽ ओकरा सभ दिन बैसा देल जाइत छल ततऽ राखि देलकैक, जाहि सँ ओ मन्‍दिर मे जाय-आबऽ वला लोक सभ सँ भीख माँगि सकय। ");
INSERT INTO mai_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ओ जखन पत्रुस आ यूहन्‍ना केँ भीतर जाइत देखलकनि तँ हुनका सभ सँ भीख मँगलक। ");
INSERT INTO mai_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","पत्रुस आ यूहन्‍ना एकटक लगा कऽ ओकरा देखलनि। पत्रुस कहलथिन, “हमरा सभ दिस ताकह!” ");
INSERT INTO mai_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ओ लोथ आदमी हिनका सभ सँ किछु पयबाक आशा मे हिनका दिस तकलकनि। ");
INSERT INTO mai_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","पत्रुस कहलथिन, “हमरा संग मे सोना वा चानी नहि अछि, मुदा जे किछु अछि से तोरा दैत छिअह। नासरत-निवासी यीशु मसीहक नाम सँ चलह-फिरह!” ");
INSERT INTO mai_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","पत्रुस ओकर दहिना हाथ पकड़ि कऽ उठौलथिन, आ तखने ओकर पयर और घुट्ठी मे बल आबि गेलैक। ");
INSERT INTO mai_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ओ फुर्ती सँ ठाढ़ भऽ गेल आ चलऽ-फिरऽ लागल। ओ दौड़ैत आ कुदि-कुदि कऽ चलैत और परमेश्‍वरक स्‍तुति करैत हुनका सभक संग मन्‍दिर मे प्रवेश कयलक। ");
INSERT INTO mai_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","लोक सभ ओकरा चलैत-फिरैत आ परमेश्‍वरक स्‍तुति करैत देखलक ");
INSERT INTO mai_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","आ जखन चिन्‍हलकैक जे, ई वैह अछि जे मन्‍दिरक “सुन्‍दर द्वारि” लग बैसि कऽ भीख मँगैत छल तँ आश्‍चर्यित भऽ अवाक रहि गेल जे, एकरा ई कोना भऽ गेलैक? ");
INSERT INTO mai_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ओ नीक कयल आदमी पत्रुस और यूहन्‍ना केँ पकड़नहि छल तखने सभ लोक आश्‍चर्य सँ भरल हुनका सभ लग “सुलेमानक असोरा” नामक जगह पर दौड़ि कऽ आयल। ");
INSERT INTO mai_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ई देखि पत्रुस ओकरा सभ केँ कहलथिन, “यौ इस्राएली भाइ लोकनि, एहि बात सँ अहाँ सभ आश्‍चर्यित किएक छी? अहाँ सभ हमरा सभ दिस एना किएक तकैत छी जेना हम सभ अपनहि शक्‍ति वा भक्‍ति सँ एकरा चलबाक सामर्थ्‍य देने होइऐक? ");
INSERT INTO mai_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहम, इसहाक और याकूबक परमेश्‍वर, अपना सभक पुरखा सभक परमेश्‍वर अपन सेवक यीशु केँ महिमा प्रदान कयलथिन। अहाँ सभ हुनका पकड़ि कऽ मृत्‍युदण्‍डक लेल पिलातुसक हाथ मे सौंपि देलहुँ और ओ जखन हुनका छोड़बाक निश्‍चय कयलनि तँ अहाँ सभ पिलातुसक समक्ष हुनका अस्‍वीकार कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","अस्‍वीकार कयलहुँ तिनका जे पवित्र और धार्मिक छलाह, और अपना लेल छोड़बाक माँग कयलहुँ तकरा जे खूनी आदमी छल। ");
INSERT INTO mai_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","एहि तरहेँ अहाँ सभ जीवनक स्रोत केँ मारि देलहुँ मुदा परमेश्‍वर हुनका जिआ देलथिन। हम सभ एहि बातक गवाह छी। ");
INSERT INTO mai_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","यीशुएक शक्‍ति सँ आ हुनका नाम पर विश्‍वास कयला सँ ई आदमी, जकरा अहाँ सभ देखि रहल छी आ चिन्‍हितो छी, से स्‍वस्‍थ कयल गेल अछि। हँ, ओही नाम पर विश्‍वास कयलाक कारणेँ ई लोथ आदमी एखन अहाँ सभक समक्ष पूर्ण स्‍वस्‍थ अछि। ");
INSERT INTO mai_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“प्रिय भाइ लोकनि, हम जनैत छी जे अहाँ सभ और अहाँ सभक धर्मगुरु लोकनि सेहो बिनु किछु जननहि-बुझनहि ई काज कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","मुदा एहि तरहेँ परमेश्‍वर अपन ओहि बात केँ पूरा कयलनि जे ओ अपन सभ प्रवक्‍ता लोकनिक माध्‍यम सँ कहने छलाह जे, हमर उद्धारकर्ता-मसीह केँ दुःख उठाबऽ पड़तनि। ");
INSERT INTO mai_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","तेँ आब अहाँ सभ अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन करू और परमेश्‍वर लग आउ, जाहि सँ अहाँ सभक पाप मेटित होअय और प्रभु अहाँ सभ केँ आत्‍मिक उत्‍साहक समय प्रदान करथि, ");
INSERT INTO mai_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","और जाहि सँ अहाँ सभ लग परमेश्‍वर अपन मसीह केँ पठबथि जिनका ओ पहिनहि सँ नियुक्‍त कयने छथिन, अर्थात् यीशु केँ। ");
INSERT INTO mai_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ई आवश्‍यक अछि जे ओ ताबत धरि स्‍वर्ग मे रहथि जाबत धरि सभ बातक सुधार करबाक ओ समय नहि आओत जाहि समयक सम्‍बन्‍ध मे परमेश्‍वर प्राचीन काल मे अपन चुनल प्रवक्‍ता लोकनि द्वारा वचन देने छथि। ");
INSERT INTO mai_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","मूसा कहने छलाह जे, ‘तोरा सभक प्रभु-परमेश्‍वर तोरा सभक लेल हमरा जकाँ एक प्रवक्‍ता तोरा सभक अपन लोक मे सँ नियुक्‍त करथुन। ओ तोरा सभ केँ जे किछु कहथुन से तोँ सभ मानिहह। ");
INSERT INTO mai_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","जे केओ हुनकर बात नहि मानत से अपना लोक मे सँ नष्‍ट कयल जायत।’ ");
INSERT INTO mai_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","एहि तरहेँ शमूएल सँ लऽ कऽ हुनका बाद मे एखन तक आबऽ वला परमेश्‍वरक सभ प्रवक्‍ता लोकनि एहि वर्तमान समयक भविष्‍यवाणी कयने छथि। ");
INSERT INTO mai_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ओ सभ जाहि बातक भविष्‍यवाणी कयलनि, से अहाँ सभक बीच पूरा भेल, और परमेश्‍वर वचन दऽ कऽ अहाँ सभक पूर्वज सभक संग जे विशेष सम्‍बन्‍ध स्‍थापित कयलनि, ताहि मे अहूँ सभ सहभागी छी। ओ अब्राहम केँ कहलथिन, ‘तोरा वंश द्वारा पृथ्‍वीक सभ जाति आशिष पाओत।’ ");
INSERT INTO mai_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","परमेश्‍वर अपन सेवक यीशु केँ नियुक्‍त कऽ कऽ सभ सँ पहिने अहीं सभ लग पठौलनि जाहि सँ ओ अहाँ सभ केँ अधलाह मार्ग सँ घुमा कऽ आशिष देथि।” ");
INSERT INTO mai_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","पत्रुस और यूहन्‍ना जखन ई बात सभ बाजिए रहल छलाह तखन किछु पुरोहित, मन्‍दिरक सिपाहीक कप्‍तान और सदुकी पंथक लोक सभ हुनका सभ लग अयलाह। ");
INSERT INTO mai_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ओ सभ एहि बात सँ खिसिआयल छलाह जे मसीह-दूत सभ लोक सभ केँ उपदेश दैत छलाह आ यीशुक मरनाइ और जीबि उठनाइ द्वारा एहि बातक प्रमाण दैत छलाह जे सभ लोक मृत्‍यु मे सँ निश्‍चित जिआओल जायत। ");
INSERT INTO mai_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","एहि पर ओ सभ हिनका सभ केँ पकड़ि कऽ जहल मे राखि देलनि जे प्रात भेने निर्णय करब, कारण तखन साँझ पड़ि गेल छल। ");
INSERT INTO mai_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","मुदा जे लोक सभ हुनका सभक प्रवचन सुनैत छल ताहि मे सँ बहुतो लोक प्रभु यीशु पर विश्‍वास कयलक आ एहि तरहेँ विश्‍वास करऽ वला मात्र पुरुषक संख्‍या पाँच हजार भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","प्रात भेने यहूदी अधिकारी, बूढ़-प्रतिष्‍ठित आ धर्मशिक्षक सभ यरूशलेम मे जमा भेलाह। ");
INSERT INTO mai_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ओहिठाम महापुरोहित हन्‍ना छलाह, आ काइफा, यूहन्‍ना, सिकन्‍दर और महापुरोहितक परिवारक अन्‍य सदस्‍य सभ सेहो उपस्‍थित छलाह। ");
INSERT INTO mai_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ओ सभ पत्रुस और यूहन्‍ना केँ जहल सँ मँगबा कऽ पूछ-ताछ करऽ लगलाह जे “तोँ सभ कोन शक्‍ति सँ आ किनका नाम सँ ई काज कयलह?” ");
INSERT INTO mai_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","एहि पर पत्रुस पवित्र आत्‍मा सँ परिपूर्ण भऽ बजलाह, “जनताक आदरणीय पंच और बूढ़-प्रतिष्‍ठित लोक सभ, ");
INSERT INTO mai_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","एक लोथ आदमीक संग दयापूर्ण व्‍यवहार करबाक कारणेँ आइ जँ हमरा सभ सँ पूछ-ताछ कयल जा रहल अछि आ ई पुछल जाइत अछि जे ई आदमी कोना नीक भेल ");
INSERT INTO mai_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","तँ अपने लोकनि आ सम्‍पूर्ण इस्राएली जनता ई जानि लिअ जे ई आदमी, जे अहाँ सभक सामने ठाढ़ अछि से नासरत-निवासी यीशु मसीहक नाम सँ स्‍वस्‍थ भेल अछि—वैह यीशु जिनका अहाँ सभ क्रूस पर चढ़ा कऽ मारि देलियनि आ परमेश्‍वर जिनका फेर जिआ देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ओ ‘वैह पाथर छथि जिनका अहाँ राजमिस्‍तिरी सभ बेकार बुझि फेकि देलहुँ, मुदा ओ मकानक मुख्‍य पाथर बनि गेलाह।’ ");
INSERT INTO mai_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","कोनो दोसर व्‍यक्‍ति द्वारा उद्धार नहि अछि, कारण स्‍वर्गक नीचाँ मनुष्‍य केँ कोनो दोसर नाम नहि देल गेल अछि जाहि द्वारा अपना सभक उद्धार भऽ सकय।” ");
INSERT INTO mai_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ओ सभ जखन पत्रुस आ यूहन्‍ना केँ निडर भऽ कऽ बजैत देखलनि आ ई बुझि जे ई सभ कम पढ़ल-लिखल साधारण लोक अछि, तँ हुनका सभ केँ बहुत आश्‍चर्य भेलनि आ ओ सभ बुझि गेलाह जे यीशुक संग रहलाक कारणेँ ई सभ एतेक अधिकारपूर्बक बाजि रहल अछि। ");
INSERT INTO mai_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","मुदा हुनका सभक संग ओहि स्‍वस्‍थ कयल गेल आदमी केँ ठाढ़ देखि ओ सभ हुनका सभक विरोध मे किछु कहि नहि सकलाह। ");
INSERT INTO mai_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ओ सभ अपना मे विचार-विमर्श करबाक लेल हुनका सभ केँ महासभा सँ बाहर करबा देलथिन। तखन ओ सभ आपस मे बात करऽ लगलाह जे, ");
INSERT INTO mai_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“अपना सभ एकरा सभक संग की करी? ई सभ तँ एक चमत्‍कारपूर्ण काज कयलक, जकरा बारे मे सम्‍पूर्ण यरूशलेम जनैत अछि आ अपनो सभ अस्‍वीकार नहि कऽ सकैत छी। ");
INSERT INTO mai_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","मुदा जाहि सँ ई बात जनता मे आरो नहि पसरि जाय, एकरा सभ केँ डेरा-धमका कऽ कहिऐक जे, तोँ सभ आब एहि नाम सँ ककरो संग कोनो चर्चा नहि करिहह।” ");
INSERT INTO mai_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","तकरबाद ओ सभ हुनका सभ केँ बजा कऽ आज्ञा देलथिन, “तोँ सभ यीशुक नाम लऽ कऽ चर्चा करब आ लोक केँ उपदेश देब बन्‍द करह!” ");
INSERT INTO mai_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","मुदा एहि पर पत्रुस आ यूहन्‍ना उत्तर देलथिन, “की परमेश्‍वरक दृष्‍टि मे ई उचित होयत जे हम सभ परमेश्‍वरक बात सँ बढ़ि कऽ अहाँ सभक बात मानी, एकर निर्णय अहीं सभ करू। ");
INSERT INTO mai_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ई तँ हमरा सभ सँ नहि भऽ सकैत अछि जे, जे बात हम सभ देखने आ सुनने छी से दोसर केँ नहि कहिऐक।” ");
INSERT INTO mai_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","अन्‍त मे ओ सभ हुनका सभ केँ आरो डेरा-धमका कऽ छोड़ि देलथिन। हुनका सभ केँ दण्‍ड देबाक कोनो उपाय नहि भेटलनि, कारण सभ लोक ओहि चमत्‍कारक कारणेँ परमेश्‍वरक स्‍तुति-प्रशंसा करैत छल ");
INSERT INTO mai_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","किएक तँ जे आदमी ओहि चमत्‍कार द्वारा स्‍वस्‍थ कयल गेल छल तकर अवस्‍था चालिस वर्ष सँ उपर छलैक। ");
INSERT INTO mai_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ओतऽ सँ छुटलाक बाद पत्रुस आ यूहन्‍ना अपना संगी सभ लग आबि कऽ मुख्‍यपुरोहित आ बूढ़-प्रतिष्‍ठित लोकनिक कहल बात कहि सुनौलथिन। ");
INSERT INTO mai_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","सभ बात सुनि ओ सभ एक संग मिलि ऊँच स्‍वर मे परमेश्‍वर सँ एहि तरहेँ प्रार्थना करऽ लगलाह, “हे परम प्रभु, अहीं आकाश, पृथ्‍वी और समुद्र आ ओहि सभ मे जे किछु अछि, तकर सभक सृष्‍टिकर्ता छी। ");
INSERT INTO mai_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","अहाँ अपना पवित्र आत्‍मा द्वारा अपन सेवक, हमरा सभक पूर्वज दाऊदक मुँह सँ ई कहने छी, ‘संसारक जाति-जातिक लोक सभ किएक हुल्‍लड़ि मचबैत अछि? राष्‍ट्र सभ किएक व्‍यर्थ षड्‌यन्‍त्र रचैत अछि? ");
INSERT INTO mai_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","प्रभु और हुनकर मसीहक विरोध मे पृथ्‍वी परक राजा सभ ठाढ़ भऽ गेल और शासक सभ एक ठाम जमा भऽ गेल।’ ");
INSERT INTO mai_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","सत्‍ये मे अहाँक पवित्र सेवक यीशु केँ, जिनका अहाँ उद्धारकर्ता-मसीह नियुक्‍त कयलहुँ तिनका विरोध मे राजा हेरोद और पुन्‍तियुस पिलातुस गैर-यहूदी और इस्राएली लोकक संग एही शहर मे षड्‌यन्‍त्र रचबाक लेल जमा भेल। ");
INSERT INTO mai_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","मुदा ओ सभ मात्र वैह कयलक जे अहाँ पहिनहि सँ अपन सामर्थ्‍य आ इच्‍छा सँ निश्‍चित कयने छलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","हे प्रभु, आब ओकरा सभक धमकी केँ देखू आ अपन सेवक सभ केँ ई वरदान दिअ जे अहाँक शुभ समाचार निर्भय भऽ कऽ सुनबैत रही। ");
INSERT INTO mai_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","संगहि अपन हाथ बढ़ा कऽ पीड़ित लोक सभ केँ स्‍वस्‍थ करू आ अपन पवित्र सेवक यीशुक नाम सँ चमत्‍कारपूर्ण काज करबैत रहू।” ");
INSERT INTO mai_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","जखन ओ सभ प्रार्थना समाप्‍त कयलनि तखन ओ स्‍थान, जतऽ ओ सभ जमा भेल छलाह, से हिलि गेल और ओ सभ गोटे पवित्र आत्‍मा सँ भरि गेलाह आ निर्भयतापूर्बक परमेश्‍वरक वचन सुनाबऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","विश्‍वासी सभक समूह एक मोन एक प्राण छल। आ केओ अपना सम्‍पत्ति केँ अपने नहि बुझैत छलाह, बल्‍कि सभक सझिआ मानैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","मसीह-दूत सभ पूर्ण सामर्थ्‍यक संग प्रभु यीशुक जीबि उठनाइक सम्‍बन्‍ध मे अपन गवाही दैत छलाह। हुनका सभ गोटेक संग परमेश्‍वरक प्रशस्‍त आशिष छलनि। ");
INSERT INTO mai_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","किनको कोनो बातक कमी नहि छलनि, कारण जिनका घर वा जमीन छलनि से सभ ओकरा बेचि-बेचि कऽ ");
INSERT INTO mai_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ओकर मूल्‍य मसीह-दूत सभक चरण मे राखि दैत छलाह। तखन ओ पाइ जिनका जतबा आवश्‍यकता रहैत छलनि ताहि अनुसार बाँटल जाइत छल। ");
INSERT INTO mai_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","जेना साइप्रस-निवासी लेवी-कुलक यूसुफ नामक एक आदमी छलाह जिनका मसीह-दूत सभ बरनबास, अर्थात् “उत्‍साहित कयनिहार,” नाम देने छलनि, ");
INSERT INTO mai_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","तिनका किछु जमीन छलनि, जकरा ओ बेचि कऽ ओकर मूल्‍य मसीह-दूत सभ केँ आनि कऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","हननियाह नामक एक आदमी सेहो, अपना स्‍त्री सफीरा सँ विचार-विमर्श कऽ अपन जमीन बेचलक ");
INSERT INTO mai_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","और स्‍त्रीक सहमति सँ अपना लेल किछु पाइ राखि कऽ बाँकी पाइ आनि मसीह-दूत सभक चरण मे राखि देलक। ");
INSERT INTO mai_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","मुदा पत्रुस कहलथिन, “यौ हननियाह! ई केहन बात भेल जे शैतान अहाँक मोन तेना कऽ वश मे कऽ लेलक जे अहाँ परमेश्‍वरक पवित्र आत्‍मा सँ झूठ बजलहुँ आ जमीनक मोल सँ किछु अपना लेल राखि लेलहुँ? ");
INSERT INTO mai_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","की बेचऽ सँ पहिने ओ जमीन अहाँक नहि छल? आ बेचलाक बादो की अपना इच्‍छाक अनुसार ओहि पाइक खर्च करबाक अधिकार अहाँ केँ नहि छल? एहन बात अहाँ केँ फुरायल कोना? अहाँ मनुष्‍य सँ नहि, परमेश्‍वर सँ झूठ बजलहुँ।” ");
INSERT INTO mai_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ई बात सुनितहि, हननियाह खसि पड़ल आ मरि गेल। ई बात जे केओ सुनलक, तकरा सभ मे बड़का डर सन्‍हिया गेलैक। ");
INSERT INTO mai_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","तखन किछु नवयुवक उठि कऽ ओकर लास कपड़ा मे लपेटि लेलक आ बाहर लऽ जा कऽ गाड़ि देलकैक। ");
INSERT INTO mai_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","करीब तीन घण्‍टाक बाद ओकर स्‍त्री ओतऽ आयल। ओकरा एहि घटनाक सम्‍बन्‍ध मे कोनो जानकारी नहि छलैक। ");
INSERT INTO mai_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","पत्रुस ओकरा सँ पुछलथिन, “कहू! अहाँ सभ अपन जमीन एतेक मे बेचलहुँ?” ओ उत्तर देलकनि, “हँ, एतेक मे।” ");
INSERT INTO mai_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","तखन पत्रुस कहलथिन, “अहाँ दूनू गोटे किएक प्रभुक आत्‍मा केँ जाँच करबाक लेल एकमत भऽ गेलहुँ? देखू! अहाँक घरवला केँ जे सभ गाड़ि आयल, से सभ द्वारिए पर अछि और अहूँ केँ लऽ जायत।” ");
INSERT INTO mai_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ओ तुरत हुनका आगाँ मे खसि पड़ल आ मरि गेल। तखन ओ नवयुवक सभ फेर भीतर आयल, आ ओकरा मुइल देखि उठा कऽ लऽ गेलैक और ओकरा घरवलाक कात मे गाड़ि देलकैक। ");
INSERT INTO mai_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","एहि सँ पूरा मसीही मण्‍डली केँ, और जे सभ एहि घटना सभक बारे मे सुनलक, तकरा सभ केँ बड़का डर भऽ गेलैक। ");
INSERT INTO mai_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","मसीह-दूत सभक द्वारा लोकक बीच बहुत चमत्‍कारपूर्ण काज कयल जाइत छल। सभ विश्‍वासी सुलेमानक असोरा पर जमा होइत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","लोक सभ हुनका सभक प्रशंसा तँ करैत छल मुदा ककरो ई साहस नहि होइत छलैक जे हुनका सभ मे सम्‍मिलित भऽ जाइ। ");
INSERT INTO mai_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","तैयो बहुतो स्‍त्री आ पुरुष प्रभु पर विश्‍वास कऽ कऽ विश्‍वासी सभक समूह मे सम्‍मिलित भेल जाइत छल। ");
INSERT INTO mai_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","मसीह-दूत सभक चमत्‍कारपूर्ण काज देखि लोक सभ रोगी सभ केँ सड़क पर पटिया वा खाट पर राखि दैत छल, जाहि सँ पत्रुस केँ अयला पर हुनकर छाँहो ककरो-ककरो पर पड़ि जाय। ");
INSERT INTO mai_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","यरूशलेमक लग-पासक नगर सभ सँ सेहो हाँजक-हाँज लोक सभ रोगी आ दुष्‍टात्‍मा लागल आदमी सभ केँ हुनका सभ लग अनैत छल और सभ केओ स्‍वस्‍थ कयल जाइत छल। ");
INSERT INTO mai_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","एहि पर महापुरोहित आ हुनकर संग देबऽ वला सदुकी पंथक लोक सभ केँ डाह होमऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ओ सभ मसीह-दूत सभ केँ पकड़ि कऽ स्‍थानीय जहल मे राखि देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","मुदा ओही राति मे प्रभुक एकटा स्‍वर्गदूत जहलक द्वारि खोलि हुनका सभ केँ बाहर लऽ अनलथिन आ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“जाह, मन्‍दिर मे जा कऽ एहि ‘नव जीवन’क विषय मे सभ बात लोक सभ केँ सुनाबह।” ");
INSERT INTO mai_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ओ सभ भोर होइते मन्‍दिर मे जा कऽ स्‍वर्गदूतक कथनानुसार लोक सभक बीच उपदेश देबऽ लगलाह। एम्‍हर महापुरोहित आ हुनकर संगी सभ इस्राएलक सभ बूढ़-प्रतिष्‍ठित केँ बजा कऽ सम्‍पूर्ण धर्म-महासभाक लोक केँ जमा कयलनि आ जहल मे सँ मसीह-दूत सभ केँ अनबाक लेल ककरो पठौलनि। ");
INSERT INTO mai_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","मुदा सिपाही सभ जखन ओतऽ पहुँचल तँ मसीह-दूत सभ जहल मे नहि छलाह। ओ सभ घूमि कऽ आबि गेल आ ई खबरि महासभाक सदस्‍य सभ केँ देलकनि जे, ");
INSERT INTO mai_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“हम सभ ओहि जहलक द्वारि मे सुरक्षित तरीका सँ ताला लागल देखलहुँ आ पहरेदार सभ सेहो चौकस भऽ द्वारि पर ठाढ़ छल मुदा ताला खोलि कऽ भीतर गेला पर देखलहुँ जे केओ नहि अछि।” ");
INSERT INTO mai_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ई बात सुनला पर मन्‍दिरक सिपाहीक कप्‍तान आ मुख्‍यपुरोहित सभ सोच मे पड़ि गेलाह जे ई की भेल? ");
INSERT INTO mai_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","एतबे मे केओ आबि कऽ कहलकनि जे, “सुनैत छी, जकरा सभ केँ अपने लोकनि जहल मे बन्‍द कयने छलहुँ से सभ एखन मन्‍दिर मे ठाढ़ भऽ कऽ लोक सभ केँ शिक्षा दऽ रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","तखन मन्‍दिरक सिपाहीक कप्‍तान किछु सिपाही सभ केँ लऽ कऽ मन्‍दिर मे गेलाह आ हुनका सभ केँ लऽ अयलथिन, मुदा जबरदस्‍ती नहि, कारण हुनका सभ केँ डर छलनि जे लोक सभ कतौ पथरबाहि कऽ कऽ हमरा सभ केँ मारि नहि देअय। ");
INSERT INTO mai_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ओ सभ मसीह-दूत सभ केँ आनि कऽ महासभा मे ठाढ़ कऽ देलथिन। तकरबाद महापुरोहित हुनका सभ सँ पुछलथिन, ");
INSERT INTO mai_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“की हम सभ तोरा सभ केँ ई आज्ञा नहि देने छलिऔक जे तोँ सभ एहि नाम सँ शिक्षा देनाइ बन्‍द करै, लेकिन तोँ सभ सम्‍पूर्ण यरूशलेम केँ अपन शिक्षा सँ भरि देलेँ और ओहि आदमीक खूनक दोषी हमरा सभ केँ बनाबऽ चाहैत छेँ।” ");
INSERT INTO mai_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","एहि पर पत्रुस और आन मसीह-दूत सभ उत्तर देलथिन, “हमरा सभ केँ मनुष्‍यक आज्ञा सँ बढ़ि कऽ परमेश्‍वरेक आज्ञा केँ मानबाक अछि। ");
INSERT INTO mai_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","जाहि यीशु केँ अहाँ सभ क्रूस पर चढ़ा कऽ मारि देलियनि, तिनका अपना सभक पूर्वजक परमेश्‍वर जिआ देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","हुनका परमेश्‍वर प्रभु आ उद्धारकर्ताक ऊँच पद दऽ कऽ अपन दहिना कात बैसौलथिन, जाहि सँ ओ इस्राएलक लोक केँ पश्‍चात्ताप आ हृदय-परिवर्तन करबाक वरदान देथि आ पापक क्षमा प्रदान करथि। ");
INSERT INTO mai_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","एहि बात सभक गवाह हम सभ छी और पवित्र आत्‍मा सेहो छथि, जे आत्‍मा परमेश्‍वर अपन आज्ञाक पालन कयनिहार सभ केँ देने छथिन।” ");
INSERT INTO mai_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ई सुनि कऽ महासभाक सदस्‍य सभ तिलमिला उठलाह आ हुनका सभ केँ जान सँ मारि देबऽ चाहलनि। ");
INSERT INTO mai_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","मुदा फरिसी पंथक गमालिएल नामक एक आदमी जे धर्म-नियमक आचार्य छलाह आ सभक नजरि मे प्रतिष्‍ठित लोक छलाह से सभा मे ठाढ़ भऽ आज्ञा देलथिन जे, एकरा सभ केँ किछु कालक लेल बाहर कऽ दिऔक। ");
INSERT INTO mai_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","तकरबाद ओ महासभाक सदस्‍य सभ केँ कहऽ लगलाह, “इस्राएली भाइ लोकनि, एहि लोकक संग जे किछु अहाँ सभ करऽ वला छी से सोचि-विचारि कऽ करू। ");
INSERT INTO mai_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","कारण, किछु समय पहिने थियूदास नामक आदमी अपने प्रशंसा मे बहुत तरहक बात कहैत छल आ करीब चारि सय लोक ओकर बात सुनि कऽ ओकरा पाछाँ-पाछाँ चलऽ लागल मुदा ओकरा मारल गेलाक बाद ओकर चेला सभ जहाँ-तहाँ छिड़िया गेल और ओकर सभ बात समाप्‍त भऽ गेलैक। ");
INSERT INTO mai_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","तकरबाद जनगणनाक समय मे गलील वासी यहूदा बहुत लोक केँ चढ़ा-बढ़ा कऽ एक क्रान्‍ति शुरू कयलक, मुदा ओहो मारल गेल आ ओकरो पाछाँ चलऽ वला लोक सभ छिड़िया गेल। ");
INSERT INTO mai_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","तेँ एकरा सभक सम्‍बन्‍ध मे हमर कथन यैह अछि जे, एकरा सभ केँ किछु नहि कयल जाय, बल्‍कि छोड़ि देल जाय। जँ एकर सभक ई विचार आ काज मनुष्‍यक प्रेरणा सँ भऽ रहल अछि तँ अपने सँ समाप्‍त भऽ जायत। ");
INSERT INTO mai_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","मुदा जँ परमेश्‍वरक प्रेरणा सँ अछि तँ अहाँ सभ एकरा सभ केँ नहि रोकि सकब, बल्‍कि एना कयला पर अहीं सभ अपने परमेश्‍वर सँ लड़निहार बनि जायब।” ");
INSERT INTO mai_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","महासभाक सदस्‍य लोकनि गमालिएलक सल्‍लाह स्‍वीकार कऽ लेलनि। ओ सभ मसीह-दूत सभ केँ भीतर बजबा कऽ बेंत सँ पिटबौलथिन आ ई आज्ञा दऽ कऽ छोड़ि देलथिन जे यीशुक नाम लऽ कऽ किछु नहि बाज। ");
INSERT INTO mai_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","मसीह-दूत सभ एहि बातक लेल आनन्‍द मनबैत महासभा सँ बहरयलाह जे परमेश्‍वर हमरा सभ केँ एहि जोगरक बुझलनि जे हम सभ यीशुक नामक कारणेँ अपमानित होइ। ");
INSERT INTO mai_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ओ सभ प्रत्‍येक दिन मन्‍दिर मे आ लोक सभक घर-घर मे जा कऽ शिक्षा दैते रहलाह और एहि शुभ समाचारक प्रचार करिते रहलाह जे यीशु उद्धारकर्ता-मसीह छथि। ");
INSERT INTO mai_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ओहि समय मे जखन शिष्‍यक संख्‍या बढ़ि रहल छल तँ यूनानी भाषी यहूदी सभ इब्रानी भाषी यहूदी सभ पर कुड़बुड़ाय लागल जे सभ दिन जखन भोजन वला वस्‍तु सभ बाँटल जाइत अछि तँ यूनानी विधवा सभ पर ठीक सँ ध्‍यान नहि देल जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","तखन सभ शिष्‍य केँ बारहो मसीह-दूत सभ बजा कऽ कहलथिन, “ई उचित नहि होयत जे हम सभ परमेश्‍वरक वचनक शिक्षा देनाइ छोड़ि कऽ खुअयबा-पिअयबा मे लागि जाइ। ");
INSERT INTO mai_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","तेँ यौ भाइ लोकनि, अहाँ सभ अपना मे सँ सात गोटे केँ चुनि कऽ दिअ जे पवित्र आत्‍मा सँ परिपूर्ण और सच्‍चरित्र आ नीक बुद्धिक होथि। हम सभ हुनका सभ केँ एहि काजक भार दऽ देबनि ");
INSERT INTO mai_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","आ अपने हम सभ प्रार्थना और परमेश्‍वरक वचनक शिक्षाक काज मे लागल रहब।” ");
INSERT INTO mai_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","एहि विचार सँ सभ केओ प्रसन्‍न भेल आ ओ सभ स्‍तिफनुस जे पवित्र आत्‍मा आ विश्‍वास सँ परिपूर्ण छलाह, और फिलिपुस, प्रुखुरुस, निकानोर, तीमोन, परमिनास और अन्‍ताकिया निवासी निकुलाउस जे यहूदी धर्म स्‍वीकार कयने छलाह तिनका सभ केँ चुनलकनि। ");
INSERT INTO mai_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","तकरबाद ओ सभ हुनका सातो गोटे केँ मसीह-दूत सभक सामने आनि देलकनि। ई सभ प्रार्थना कयलनि आ हुनका सभ पर हाथ राखि ओहि काजक लेल नियुक्‍त कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","एहि तरहेँ परमेश्‍वरक वचन पसरैत गेल। यरूशलेम मे शिष्‍यक संख्‍या बहुत बढ़ि गेल और बहुत यहूदी पुरोहित सभ सेहो वचन स्‍वीकार कऽ आज्ञाकारी बनि प्रभु पर विश्‍वास कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्‍तिफनुस परमेश्‍वरक कृपा आ सामर्थ्‍य सँ परिपूर्ण भऽ लोकक बीच बड़का-बड़का अद्‌भुत काज आ चमत्‍कारपूर्ण चिन्‍ह सभ देखबैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","मुदा किछु यहूदी सभ हिनकर विरोध करऽ लागल। ओ सभ “मुक्‍त लोकक सभाघर” नामक समूहक सदस्‍य सभ, कुरेन और सिकन्‍दरिया नगर आ किलिकिया और आसिया प्रदेशक निवासी सभ छल। ओ सभ स्‍तिफनुस सँ वाद-विवाद करऽ लागल ");
INSERT INTO mai_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","मुदा पवित्र आत्‍मा हिनका बाजऽ काल मे ततेक नीक बुद्धि देलथिन जे ओ सभ हिनका सामने मे नहि टिकि सकल। ");
INSERT INTO mai_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","तखन ओ सभ किछु लोक केँ गुप्‍त रूप सँ चढ़ा-बढ़ा कऽ सिखौलक जे अहाँ सभ कहू जे हम सभ एकरा मूसा आ परमेश्‍वरक निन्‍दा करैत सुनलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","एहि तरहेँ ओ सभ जनता, बूढ़-प्रतिष्‍ठित लोकनि आ धर्मशिक्षक सभ केँ बहका देलक और ओ सभ मिलि कऽ स्‍तिफनुस केँ पकड़ि लेलकनि आ धर्म-महासभाक सामने अनलकनि। ");
INSERT INTO mai_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ओ सभ झुट्ठा गवाह सभ पेश कऽ कऽ कहबौलक जे, “ई आदमी सदिखन अपना सभक पवित्र मन्‍दिर आ धर्म-नियमक विरोध मे बजैत अछि ");
INSERT INTO mai_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","कारण हम सभ एकरा एहि तरहेँ कहैत सुनलहुँ जे, ‘ई नासरतक यीशु एहि मन्‍दिर केँ ढाहि देताह और मूसा द्वारा देल गेल प्रथा सभ केँ बदलि देताह।’ ” ");
INSERT INTO mai_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","महासभा मे बैसल लोक सभ जखन स्‍तिफनुसक दिस तकलनि तँ देखलनि जे हुनकर मुँह स्‍वर्गदूतक मुँह जकाँ देखाइ दऽ रहल अछि। ");
INSERT INTO mai_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","तखन महापुरोहित स्‍तिफनुस सँ पुछलथिन, “की ई बात सभ सत्‍य अछि?” ");
INSERT INTO mai_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","एहि पर स्‍तिफनुस उत्तर देलथिन, “बाबू-भैया लोकनि, हमर बात सुनू! अपना सभक पूर्वज अब्राहम हारान नगर मे वास करऽ सँ पहिने जखन मेसोपोतामिया क्षेत्र मे रहैत छलाह तखन हुनका महिमामय परमेश्‍वर दर्शन देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ओ कहलथिन, ‘तोँ अपन देश सँ निकलि जाह, अपन कुटुम्‍ब-परिवार केँ छोड़ि दैह और ओहि देश मे जाह जे हम तोरा देखयबह।’ ");
INSERT INTO mai_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","तेँ ओ कसदी जातिक लोकक देश छोड़ि कऽ हारान मे आबि कऽ बसलाह। हुनकर पिताक मृत्‍युक बाद परमेश्‍वर हुनका हारान नगर सँ एहि देश मे पठौलथिन जतऽ एखन अहाँ सभ रहि रहल छी। ");
INSERT INTO mai_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","एतऽ परमेश्‍वर उत्तराधिकारक रूप मे हुनका एतबो जमीन अपन कहाबऽ वला नहि देलथिन जतबा पर ओ पयर टेकि सकितथि, मुदा तैयो परमेश्‍वर हुनका ई वचन देलथिन जे, ‘हम ई देश तोरा आ तोरा बाद तोहर वंशक अधिकार मे कऽ देबह,’ जखन कि ओहि समय मे हुनका कोनो सन्‍तानो नहि छलनि। ");
INSERT INTO mai_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","परमेश्‍वर हुनका ई बात कहलथिन, ‘तोहर वंशक लोक सभ आन देश मे प्रवासी भऽ जयतह आ ओतऽ ओ सभ चारि सय वर्ष धरि गुलाम बनि कष्‍ट सहैत रहतह।’ ");
INSERT INTO mai_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","परमेश्‍वर फेर कहलथिन, ‘जाहि राष्‍ट्रक लोक ओकरा सभ केँ गुलाम बनाओत तकरा हम दण्‍ड देबैक। तकरबाद ओ सभ ओहि देश सँ निकलि आओत और एही देश मे आबि कऽ हमर आराधना करत।’ ");
INSERT INTO mai_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","तखन परमेश्‍वर अब्राहमक संग जे विशेष सम्‍बन्‍ध स्‍थापित कयने छलाह, तकर चिन्‍ह स्‍वरूप हुनका सँ खतनाक विधि शुरू करबौलनि। तेँ जखन हुनकर पुत्र इसहाकक जन्‍म भेलनि तँ तकर आठम दिन मे ओ हुनकर खतना करौलनि। बाद मे इसहाकक पुत्र याकूबक जन्‍म भेलनि और याकूब सँ अपना सभक बारह कुल-पिता जन्‍म लेलनि। ");
INSERT INTO mai_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“यैह कुल-पिता लोकनि अपन भाय यूसुफ सँ डाह रखैत हुनका बेचि देलनि और ओ मिस्र देश मे लऽ जायल गेलाह। मुदा परमेश्‍वर हुनका संग छलथिन। ");
INSERT INTO mai_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","सभ कष्‍ट और विपत्ति मे ओ हुनका बचौलथिन, और हुनका नीक बुद्धि देलथिन जाहि सँ मिस्रक राजा फरओ हुनका सँ प्रसन्‍न भेलनि और हुनका मिस्र देशक प्रधानमन्‍त्री आ अपन सम्‍पूर्ण राजभवनक मुख्‍य अधिकारी बनौलथिन। ");
INSERT INTO mai_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“जखन सम्‍पूर्ण मिस्र देश आ कनान देश मे भारी रौदी पड़ल तँ अपना सभक पूर्वज लोकनि केँ बड़का कष्‍ट सहऽ पड़लनि कारण हुनका सभ लग भोजनक लेल कोनो अन्‍न नहि छलनि। ");
INSERT INTO mai_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ओहि समय मे याकूब सुनलनि जे मिस्र देश मे अन्‍न भेटि रहल अछि, तँ ओ अपना सभक कुल-पिता सभ केँ पहिल बेर मिस्र देश सँ अन्‍न किनबाक लेल पठौलथिन। ");
INSERT INTO mai_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ओ सभ फेर जखन दोसर बेर अन्‍न किनबाक लेल ओतऽ गेलाह तँ यूसुफ हुनका सभ केँ अपन परिचय दऽ कऽ ई बात प्रगट कयलनि जे हम अहाँ सभक भाय यूसुफ छी। तखन फरओ केँ सेहो यूसुफक परिवारक बारे मे जानकारी भेलनि। ");
INSERT INTO mai_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","एकर बाद यूसुफ अपन पिता याकूब आ हुनकर सम्‍पूर्ण परिवार, अर्थात् पचहत्तरियो लोक केँ बजबा लेलथिन। ");
INSERT INTO mai_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","याकूब मिस्र देश गेलाह। ओ और अपना सभक कुल-पिता लोकनि ओतहि मुइलाह। ");
INSERT INTO mai_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","हुनका सभक लास ओतऽ सँ आनि कऽ एहि देशक शकेम नामक स्‍थान मे ओहि कबर मे राखल गेलनि जे अब्राहम हमोरक पुत्र सभ सँ पाइ दऽ कऽ किनने छलाह। ");
INSERT INTO mai_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“जँ-जँ ओहि वचन केँ पूर्ण होयबाक समय लगचिआइत गेल जे परमेश्‍वर अब्राहम केँ देने छलाह तँ-तँ मिस्र मे अपना सभक पूर्वजक संख्‍या बढ़ैत गेल। ");
INSERT INTO mai_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ओहि समय मे मिस्र मे एक नव राजा भेलाह जे यूसुफक सम्‍बन्‍ध मे नहि किछु जनैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ओ राजा अपना सभक जाति केँ धोखा दऽ कऽ अपना सभक पूर्वज लोकनि केँ अपन-अपन बच्‍चा सभ केँ फेकि देबाक लेल विवश कऽ देलथिन जाहि सँ ओ सभ मरि जाय। ");
INSERT INTO mai_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“ओही समय मे मूसाक जन्‍म भेलनि। परमेश्‍वरक नजरि मे हुनकर विशेष स्‍थान छलनि। तीन मास धरि हुनकर पालन-पोषण अपन पिताक घर मे भेलनि। ");
INSERT INTO mai_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","मुदा आरो दिन नहि नुका सकबाक कारणेँ हुनका जखन बाहर धऽ देल गेलनि तँ फरओ-राजाक बेटी हुनका पौलक और अपन पुत्र मानि कऽ पोसलक। ");
INSERT INTO mai_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","एहि तरहेँ मूसा मिस्र देशक सम्‍पूर्ण शिक्षा प्राप्‍त कयलनि और ओ बात आ काज दूनू मे सामर्थी भेलाह। ");
INSERT INTO mai_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“मूसा जखन चालिस वर्षक भेलाह तखन हुनका मोन भेलनि जे हम अपन जाति-भाय इस्राएली सभ सँ भेँट-घाँट करी। ");
INSERT INTO mai_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","एक दिन ओ देखलनि जे एक मिस्री लोक हुनकर जाति-भायक संग दुर्व्‍यवहार कऽ रहल अछि, तेँ ओ अपन भायक पक्ष लैत ओहि मिस्री लोकक खून कऽ कऽ तकर बदला लऽ लेलनि। ");
INSERT INTO mai_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ओ सोचैत छलाह जे हमर जाति-भाय सभ ई बात बुझि जायत जे परमेश्‍वर हमरा द्वारा ओकरा सभ केँ मुक्‍त करौताह मुदा ओ सभ एहि बात केँ नहि बुझलक। ");
INSERT INTO mai_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","प्रात भेने जखन ओ फेर बहरयलाह तँ दू इस्राएली भाय केँ अपने मे लड़ाइ करैत देखलनि। ओ ओकरा सभ केँ मेल-मिलाप कऽ लेबाक लेल बुझौलथिन, ‘सुनू, अहाँ सभ भाय-भाय छी तखन एक-दोसर केँ किएक कष्‍ट दैत छी?’ ");
INSERT INTO mai_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","एहि बात पर ओ जे दोषी छल से मूसा केँ धकिया कऽ कहलकनि, ‘अहाँ केँ के हमरा सभक हाकिम और न्‍यायाधीश बनौलक? ");
INSERT INTO mai_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","की जहिना अहाँ काल्‍हि ओहि मिस्री लोकक खून कयलहुँ तहिना हमरो खून कऽ देबऽ चाहैत छी?’ ");
INSERT INTO mai_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","मूसा ई बात सुनि मिस्र देश सँ भागि कऽ मिद्यान देश मे परदेशी भऽ कऽ रहऽ लगलाह और ओतहि हुनकर दूटा बेटाक जन्‍म भेलनि। ");
INSERT INTO mai_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“चालिस वर्षक बाद सीनय पहाड़ लग निर्जन क्षेत्र मे जरैत झाड़ीक धधरा मे एक स्‍वर्गदूत मूसा केँ देखाइ देलनि। ");
INSERT INTO mai_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ई देखि हुनका बड्ड आश्‍चर्य लगलनि। एहि दृश्‍य केँ लग सँ देखबाक लेल जखन गेलाह तँ प्रभु हुनका कहलथिन, ");
INSERT INTO mai_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘हम तोहर पूर्वजक परमेश्‍वर, अर्थात् अब्राहम, इसहाक और याकूबक परमेश्‍वर छी।’ मूसा थर-थर काँपऽ लगलाह और हुनका ओम्‍हर देखैत रहबाक साहस नहि भेलनि। ");
INSERT INTO mai_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","तखन प्रभु कहलथिन, ‘तोँ अपन चप्‍पल बाहर कऽ लैह, कारण जतऽ तोँ ठाढ़ छह से पवित्र स्‍थान अछि। ");
INSERT INTO mai_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","हम देखलहुँ जे मिस्र मे हमरा लोक केँ कोना सताओल जा रहल अछि, हम ओकरा सभक कुहरनाइ सुनलहुँ आ ओकरा सभ केँ मुक्‍त करयबाक लेल उतरि आयल छी। आब आबह! हम तोरा मिस्र देश मे पठा रहल छिअह।’ ");
INSERT INTO mai_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“ई वैह मूसा छथि जिनका ओ सभ ई कहि कऽ अस्‍वीकार कयने छलनि जे, अहाँ केँ के हाकिम आ न्‍यायाधीश बनौलक? हुनका परमेश्‍वर ओहि स्‍वर्गदूत द्वारा जे हुनका झाड़ी मे देखाइ देने छलनि हाकिम और मुक्‍त करौनिहार बना कऽ पठौलथिन। ");
INSERT INTO mai_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","वैह आदमी मिस्र मे, लाल सागर मे आ चालिस वर्ष धरि निर्जन क्षेत्र मे चमत्‍कारपूर्ण काज आ चिन्‍ह सभ देखबैत अपन इस्राएली लोक केँ मिस्र सँ बाहर निकालि अनलनि। ");
INSERT INTO mai_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ई वैह मूसा छथि जे ओकरा सभ केँ कहलथिन, ‘परमेश्‍वर तोरे सभ मे सँ हमरा सनक प्रवक्‍ता तोरा सभक लेल पठौथुन।’ ");
INSERT INTO mai_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","हँ, ई वैह छथि जे निर्जन क्षेत्र मे अपना सभक पूर्वजक समुदाय मे छलाह आ जिनका सँ सीनय पहाड़ पर स्‍वर्गदूत बात कयलनि। हुनके जीवनक वचन देल गेलनि जे ओ अपना सभ केँ प्रदान करथि। ");
INSERT INTO mai_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“मुदा अपना सभक पूर्वज सभ हुनकर बात नहि मानलनि, बल्‍कि हुनका अस्‍वीकार कयलथिन आ फेर मिस्र देश घूमि जयबाक इच्‍छा करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ओ सभ हारून केँ कहलथिन, ‘अहाँ हमरा सभक लेल एहन देवता बना दिअ जे हमरा सभक मार्गदर्शन करथि, कारण ई मूसा जे हमरा सभ केँ मिस्र देश सँ निकालि कऽ अनलनि तिनका नहि जानि की भऽ गेलनि!’ ");
INSERT INTO mai_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ओही समय मे ओ सभ एक बच्‍छाक मुरुत बना कऽ ओकरा लग बलि-प्रदान कयलनि। ओ सभ अपन हाथक बनाओल मुरुतक लेल एक पैघ उत्‍सव मनौलनि। ");
INSERT INTO mai_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","एहि पर परमेश्‍वर हुनका सभ केँ त्‍यागि देलथिन और आकाशक सूर्य, चन्‍द्रमा आ तारा सभक पूजा करबाक लेल छोड़ि देलथिन। एही सम्‍बन्‍ध मे परमेश्‍वरक प्रवक्‍ता सभक लेख मे लिखल अछि, ‘हे इस्राएली लोक सभ, की तोँ सभ निर्जन क्षेत्र मे चालिस वर्ष धरि पशु-बलि आ अन्‍य चढ़ौना सभ हमरे चढ़ौलह? ");
INSERT INTO mai_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","नहि, तोँ सभ मोलोक देवताक मण्‍डप केँ और रिफान देवताक तारा सभ केँ अर्थात् मुरुत सभ केँ जकरा तोँ सभ पूजा करबाक लेल बनौने छलह तकरा सभ केँ अपना संग लऽ कऽ घुमैत छलह। तेँ आब हम तोरा सभ केँ बेबिलोनो सँ दूर देश मे भगा देबह।’ ");
INSERT INTO mai_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“निर्जन क्षेत्र मे अपना सभक पूर्वज सभ लग ‘साक्षीक मण्‍डप’ छलनि। ओ मण्‍डप ओही नमूनाक अनुसार बनाओल गेल छल जे परमेश्‍वर मूसा केँ देखौने छलथिन आ ठीक ओहिना बनयबाक आज्ञा देने छलथिन। ");
INSERT INTO mai_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ओ मण्‍डप ओहि पुस्‍त सँ दोसर पुस्‍त मे आयल, और परमेश्‍वर जखन एहि देश मे सँ दोसर जाति सभ केँ भगा देलनि आ अपना सभक पूर्वज सभ एहि देश केँ जितलनि तँ ओ सभ यहोशूक संग ओहि मण्‍डप केँ सेहो एतऽ अनलनि। और ओ मण्‍डप राजा दाऊदक समय धरि एहि देश मे रहल। ");
INSERT INTO mai_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","राजा दाऊद सँ परमेश्‍वर विशेष प्रसन्‍न छलाह। ओ परमेश्‍वर सँ प्रार्थना कयलनि, ‘हे हमर पूर्वज याकूबक परमेश्‍वर, हम अहाँक निवासक लेल एक घरक निर्माण करी तकर आज्ञा हमरा दिअ।’ ");
INSERT INTO mai_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","मुदा परमेश्‍वरक ओहि घरक निर्माण करऽ वला हुनकर बेटा सुलेमान भेलाह। ");
INSERT INTO mai_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“परन्‍तु परम परमेश्‍वर मनुष्‍य द्वारा बनाओल घर सभ मे नहि रहैत छथि, जेना हुनकर एक प्रवक्‍ताक लेख मे अछि, ");
INSERT INTO mai_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘स्‍वर्ग हमर सिंहासन अछि, और पृथ्‍वी हमर पयरक चौकी। प्रभु कहैत छथि, तोँ हमरा लेल केहन घर बनयबह? हमर रहबाक स्‍थान कतऽ होयत? ");
INSERT INTO mai_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","की ई सभ हमरे बनाओल नहि अछि?’ ");
INSERT INTO mai_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“हे जिद्दी आ अशुद्ध मोनक, कानक बहीर लोक सभ! अहाँ सभ एकदम अपन पूर्वज सभ जकाँ छी, सदिखन पवित्र आत्‍माक विरोध करैत रहैत छी! ");
INSERT INTO mai_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","परमेश्‍वरक एहन एकोटा प्रवक्‍ता भेलाह, जिनका अहाँ सभक पूर्वज सभ नहि सतौलकनि? परमेश्‍वरक धार्मिक सेवकक आगमनक सम्‍बन्‍ध मे भविष्‍यवाणी कयनिहार सभक ओ सभ खून तक कऽ देलकनि। और आब अहाँ सभ ओहि धार्मिक सेवक केँ पकड़बा कऽ हुनकर हत्‍या कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","अहाँ सभ ओ लोक छी जकरा स्‍वर्गदूतक माध्‍यम सँ परमेश्‍वरक धर्म-नियम देल गेल मुदा अहीं सभ ओकरा नहि मानने छी।” ");
INSERT INTO mai_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ई बात सुनितहि ओ सभ तामसे-पित्ते हुनका पर दाँत पिसऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","मुदा स्‍तिफनुस पवित्र आत्‍मा सँ परिपूर्ण भऽ स्‍वर्ग दिस ताकऽ लगलाह और ओ ओतऽ परमेश्‍वरक तेज प्रकाश चमकैत आ परमेश्‍वरक दहिना कात यीशु केँ ठाढ़ देखलनि। ");
INSERT INTO mai_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ओ बाजि उठलाह, “हम स्‍वर्ग केँ खुजल आ परमेश्‍वरक दहिना कात मनुष्‍य-पुत्र यीशु केँ ठाढ़ देखि रहल छियनि।” ");
INSERT INTO mai_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","एहि बात पर ओ सभ अपन कान मुनि लेलक और जोर सँ हल्‍ला करैत हुनका दिस दौड़ल ");
INSERT INTO mai_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","आ हुनका पकड़ि कऽ घिसिअबिते शहर सँ बाहर लऽ गेल और हुनका खून कऽ देबाक लेल पाथर मारऽ लगलनि। गवाह सभ अपन वस्‍त्र साउल नामक युवक लग रखने छल। ");
INSERT INTO mai_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","जखन ओ सभ स्‍तिफनुस केँ पाथर मारि रहल छलनि तखन ओ प्रार्थना कऽ रहल छलाह, “हे प्रभु यीशु, हमर आत्‍मा केँ ग्रहण करू।” ");
INSERT INTO mai_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ओ ठेहुन रोपि फेर जोर सँ कहलनि, “हे प्रभु, एहि पापक हिसाब एकरा सभ सँ नहि लिऔक।” एतबा कहलाक बाद हुनकर प्राण छुटि गेलन्‍हि। ");
INSERT INTO mai_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","साउल स्‍तिफनुसक हत्‍या सँ सहमत छल। ओही दिन सँ यरूशलेमक विश्‍वासी मण्‍डली पर भयंकर अत्‍याचार शुरू भऽ गेल और मसीह-दूत सभ केँ छोड़ि आरो सभ विश्‍वासी यहूदिया आ सामरिया प्रदेश मे छिड़िया गेल। ");
INSERT INTO mai_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","परमेश्‍वरक भक्‍त सभ स्‍तिफनुसक लास लऽ जा कऽ कबर मे गाड़ि देलनि और हुनका लेल बहुत शोक मनौलनि। ");
INSERT INTO mai_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","एम्‍हर साउल विश्‍वासी मण्‍डली केँ नष्‍ट करबाक कोशिश कऽ रहल छल। ओ घर-घर मे हुलि कऽ स्‍त्रीगण और पुरुष सभ केँ पकड़ि जहल मे बन्‍द करबा दैत छल। ");
INSERT INTO mai_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","जे विश्‍वासी सभ छिड़िया गेल से सभ घूमि-घूमि कऽ प्रभुक वचनक प्रचार करैत छल। ");
INSERT INTO mai_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","फिलिपुस सामरिया प्रदेशक एक शहर मे आबि कऽ उद्धारकर्ता-मसीहक प्रचार करऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","फिलिपुसक प्रचारक बात सुनि आ हुनका द्वारा कयल चमत्‍कार सभ देखि भीड़क सभ लोक एक चित्त भऽ कऽ हुनका कथन पर पूरा ध्‍यान देबऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","बहुत लोक मे सँ दुष्‍टात्‍मा सभ चिचिया-चिचिया कऽ निकलि गेल और बहुत लकवा मारल आ नाङड़ आदमी सभ स्‍वस्‍थ भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","एहि सभ सँ ओहि शहरक लोक बहुत आनन्‍दित भेल। ");
INSERT INTO mai_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ओहि शहर मे सिमोन नामक एक जादूगर बहुत दिन सँ अपन जादू देखा कऽ सामरियाक लोक सभ केँ आश्‍चर्यित कयने छल। ओ अपना केँ बड्ड पैघ लोक कहैत छल, ");
INSERT INTO mai_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","और ऊँच-नीच सभ तरहक लोक ओकर बात मानैत छल। ओ सभ कहैत छल जे “ई आदमी ईश्‍वरक ओहि शक्‍तिक अवतार छथि जे ‘महाशक्‍ति’ कहबैत छथि।” ");
INSERT INTO mai_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","लोक सभ एहि लेल ओकर बात मानैत छल जे ओ बहुत दिन सँ एकरा सभ केँ अपन जादू द्वारा प्रभावित कयने छल। ");
INSERT INTO mai_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","मुदा ओ सभ जखन फिलिपुसक प्रचार सुनि यीशु मसीह आ परमेश्‍वरक राज्‍यक शुभ समाचार पर विश्‍वास कयलक तँ, पुरुष और स्‍त्रीगण, सभ केओ बपतिस्‍मा लेबऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","सिमोन सेहो विश्‍वास कयलक आ बपतिस्‍मा लेलक। ओ फिलिपुसक संगे-संग सभतरि घुमैत छल आ हुनकर अद्‌भुत चिन्‍ह और चमत्‍कारपूर्ण काज सभ देखि चकित रहि जाइत छल। ");
INSERT INTO mai_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","यरूशलेम मे जखन मसीह-दूत सभ ई सुनलनि जे सामरिया प्रदेशक लोक सभ परमेश्‍वरक वचन स्‍वीकार कऽ लेने अछि तँ ओ सभ पत्रुस आ यूहन्‍ना केँ ओतऽ पठौलनि। ");
INSERT INTO mai_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ओ दूनू गोटे ओतऽ पहुँचि कऽ ओकरा सभक लेल प्रार्थना कयलनि जाहि सँ ओ सभ पवित्र आत्‍मा केँ प्राप्‍त करय, ");
INSERT INTO mai_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","कारण एखन तक ओकरा सभ मे सँ ककरो पर पवित्र आत्‍मा नहि आयल छलथिन—ओ सभ मात्र प्रभु यीशु पर विश्‍वास कऽ कऽ हुनका नाम सँ बपतिस्‍मा लेने छल। ");
INSERT INTO mai_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","तखन ओ दूनू गोटे ओकरा सभ पर हाथ रखलनि और ओ सभ पवित्र आत्‍मा केँ प्राप्‍त कयलक। ");
INSERT INTO mai_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","सिमोन जखन देखलक जे ककरो शरीर पर मसीह-दूत सभ अपन हाथ रखैत छथि तँ ओकरा पवित्र आत्‍मा भेटैत छथिन तखन ओ अपन पाइ लऽ कऽ हुनका सभ लग गेल ");
INSERT INTO mai_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","आ कहलकनि, “हमरो ई गुण दिअ जाहि सँ हम ककरो शरीर पर हाथ रखिऐक तँ ओकरा पवित्र आत्‍मा भेटैक।” ");
INSERT INTO mai_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","एहि पर पत्रुस उत्तर देलथिन, “सत्‍यानाश होउ तोहर और तोरा पाइ केँ जे तोँ परमेश्‍वरक दान केँ पाइ सँ मोल लेबऽ चाहैत छेँ! ");
INSERT INTO mai_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","एहि काज मे तोहर कोनो हिस्‍सा वा अधिकार नहि छौक कारण परमेश्‍वरक दृष्‍टि मे तोहर मोन भ्रष्‍ट छौक। ");
INSERT INTO mai_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","आब तोँ अपना एहि दुष्‍ट विचारक लेल पश्‍चात्ताप कर और प्रभु सँ क्षमा माँग। भऽ सकैत अछि जे ओ तोहर एहन विचार केँ क्षमा कऽ देथुन। ");
INSERT INTO mai_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","हम देखैत छी जे तोँ ईर्ष्‍याक विष सँ भरल आ पाप मे जकड़ल छेँ।” ");
INSERT INTO mai_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","एहि पर सिमोन कहलकनि, “अहीं सभ हमरा लेल प्रार्थना करू जाहि सँ अहाँ जेना कहलहुँ तेना हमरा संग नहि होअय।” ");
INSERT INTO mai_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","पत्रुस और यूहन्‍ना प्रभु यीशुक विषय मे साक्षी दऽ कऽ आ परमेश्‍वरक वचनक प्रचार कऽ कऽ यरूशलेमक लेल फेर विदा भेलाह और रस्‍ता मे सामरिया प्रदेशक बहुतो गाम मे शुभ समाचार सुनबैत गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","एम्‍हर परमेश्‍वरक एक स्‍वर्गदूत फिलिपुस केँ कहलथिन, “तोँ एतऽ सँ दक्षिण मुँहें विदा भऽ कऽ यरूशलेम सँ गाजा नगर जाय वला रस्‍ता पर जाह जे बंजरभूमि दऽ कऽ गेल अछि।” ");
INSERT INTO mai_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ई सुनि फिलिपुस विदा भऽ गेलाह। रस्‍ता मे हुनका इथियोपिया देशक एक हाकिम भेटलथिन जे इथियोपियाक रानी कन्‍दकीक मुख्‍य खजांची छलाह। ओ आराधना करबाक लेल यरूशलेम गेल छलाह, ");
INSERT INTO mai_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","आ ओतऽ सँ घुमैत काल अपना रथ मे बैसल धर्मशास्‍त्र मे परमेश्‍वरक प्रवक्‍ता यशायाह द्वारा लिखल भाग केँ पढ़ि रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","तखन पवित्र आत्‍मा फिलिपुस केँ कहलथिन, “आगाँ बढ़ि कऽ ओहि रथक संगे-संग चलह।” ");
INSERT INTO mai_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिपुस दौड़ि कऽ रथ लग गेलाह और ओहि हाकिम केँ यशायाहक पुस्‍तक मे सँ पढ़ैत सुनलनि। तखन फिलिपुस पुछलथिन, “अहाँ जे पढ़ि रहल छी से बुझितो छी?” ");
INSERT INTO mai_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ओ उत्तर देलथिन, “हम कोना बुझब जाबत केओ हमरा बुझाओत नहि?” ई कहि कऽ ओ हुनका सँ रथ पर बैसबाक आग्रह कयलथिन। ");
INSERT INTO mai_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","धर्मशास्‍त्रक जे भाग ओ पढ़ि रहल छलाह से ई छल, “वध करबाक लेल भेँड़ा जकाँ हुनका लऽ गेलनि और भेँड़ी जहिना ऊन छोपयबा काल मे शान्‍त रहैत अछि तहिना ओ शान्‍त रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ओ बेइज्‍जति कयल गेलाह और हुनका उचित न्‍याय नहि भेटलनि। हुनकर सन्‍तानक वर्णन कोना भऽ सकत कारण हुनकर एहि पृथ्‍वी परक जीवन केँ समाप्‍त कऽ देल गेलनि।” ");
INSERT INTO mai_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","हाकिम फिलिपुस सँ पुछलथिन, “हमरा कहल जाओ—लेखक ई बात किनका विषय मे कहि रहल छथि, अपना विषय मे वा किनको दोसराक विषय मे?” ");
INSERT INTO mai_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","एहि पर फिलिपुस धर्मशास्‍त्रक ओही पाठ सँ शुरू कऽ कऽ हुनका यीशुक सम्‍बन्‍ध मे शुभ समाचार सुनौलथिन। ");
INSERT INTO mai_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","जाइत-जाइत आगाँ रस्‍ता मे हुनका सभ केँ पानि भेटला पर हाकिम फिलिपुस केँ कहलथिन, “देखल जाओ, एतऽ पानि अछि। आब हम किएक नहि बपतिस्‍मा लऽ ली?” ");
INSERT INTO mai_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिपुस उत्तर देलथिन, “जँ अहाँ सम्‍पूर्ण मोन सँ विश्‍वास करैत छी तँ लऽ सकैत छी।” ओ कहलथिन, “हम विश्‍वास करैत छी जे यीशु मसीह परमेश्‍वरक पुत्र छथि।” ");
INSERT INTO mai_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ई कहि हाकिम रथ केँ रोकबा देलथिन और दूनू गोटे उतरि कऽ पानि मे गेलाह और फिलिपुस हुनका बपतिस्‍मा देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","जखन ओ सभ पानि मे सँ उपर भेलाह तखन एकाएक प्रभुक आत्‍मा फिलिपुस केँ दोसर ठाम लऽ गेलथिन आ हाकिम फेर हुनका नहि देखलथिन मुदा आनन्‍दपूर्बक ओ अपन रस्‍ता पर बढ़ैत गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","एम्‍हर फिलिपुस अपना केँ अश्‍दोद नगर मे पौलनि। ओतऽ सँ आगाँ बढ़ि कऽ सभ नगर मे ओ शुभ समाचारक प्रचार करैत-करैत कैसरिया पहुँचलाह। ");
INSERT INTO mai_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","साउल एखनो तक प्रभु यीशुक शिष्‍य सभ केँ धमकी दैत छल आ हुनका सभक हत्‍या करबाक फिराक मे रहैत छल। ओ महापुरोहित लग जा कऽ ");
INSERT INTO mai_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","दमिश्‍कक सभाघर सभक लेल आज्ञा-पत्र मँगलक जाहि सँ जँ ओकरा दमिश्‍क मे एहि पंथ केँ मानऽ वला लोक सभ भेटैक तँ ओ ओकरा सभ केँ, चाहे स्‍त्रीगण होअय वा पुरुष, बन्‍दी बना कऽ यरूशलेम आनि सकय। ");
INSERT INTO mai_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","जखन ओ दमिश्‍क नगर लग पहुँचल तँ एकाएक आकाश सँ बहुत तेज प्रकाश ओकरा चारू कात पड़ल। ");
INSERT INTO mai_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ओ जमीन पर खसि पड़ल आ ओकरा एक स्‍वर सुनाइ देलक, “हौ साउल, हौ साउल, तोँ हमरा किएक सतबैत छह?” ");
INSERT INTO mai_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ओ पुछलकनि, “यौ प्रभु, अहाँ के छी?” ओ उत्तर देलथिन, “हम यीशु छी जिनका तोँ सता रहल छह। ");
INSERT INTO mai_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","आब तोँ उठि कऽ शहर मे जाह, ओतऽ तोरा कहल जयतह जे तोरा की करबाक छह।” ");
INSERT INTO mai_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","साउलक संग जे लोक सभ जा रहल छल से सभ अवाक रहि गेल, कारण ओ सभ आवाज सुनलक मुदा ककरो देखलक नहि। ");
INSERT INTO mai_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","साउल जमीन पर सँ उठलाह मुदा ओ जखन आँखि तकलनि तँ हुनका किछु देखाइ नहि दैत छलनि। तेँ ओ सभ हुनका हाथ पकड़ि कऽ दमिश्‍क शहर मे लऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ओ तीन दिन धरि आन्‍हर रहलाह आ किछु नहि खयलनि-पिलनि। ");
INSERT INTO mai_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमिश्‍क मे हननियाह नामक एक शिष्‍य छलाह, जिनका प्रभु यीशु दर्शन दऽ कऽ कहलथिन, “हौ हननियाह!” ओ उत्तर देलथिन, “कहल जाओ प्रभु।” ");
INSERT INTO mai_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","प्रभु आज्ञा देलथिन, “उठह, ‘सोझका गली’ नामक रस्‍ता मे जा कऽ यहूदाक घर मे तरसुस निवासी साउलक खोज करह, ओ प्रार्थना कऽ रहल अछि। ");
INSERT INTO mai_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","और ओकरा मोन मे एकटा दृश्‍य देखाइ पड़ल छैक जे हमरा घर मे हननियाह नामक एक आदमी अयलाह आ हमरा पर हाथ रखलनि जे हम देखि सकी।” ");
INSERT INTO mai_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हननियाह उत्तर देलथिन, “यौ प्रभु, हम एहि आदमीक बारे मे बहुत किछु सुनने छी जे कोना ओ यरूशलेम मे अहाँक चुनल लोक सभ केँ सतबैत छल ");
INSERT INTO mai_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","आ एहूठाम अहाँक शिष्‍य सभ केँ पकड़बाक लेल मुख्‍यपुरोहित सभक आदेश-पत्र लऽ कऽ आयल अछि।” ");
INSERT INTO mai_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","प्रभु उत्तर देलथिन, “तोँ जाह, ओकरा हम चुनने छी जाहि सँ ओ गैर-यहूदी, ओकर सभक राजा सभ मे आ इस्राएली लोकक बीच मे हमर नामक प्रचार करय। ");
INSERT INTO mai_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","आब हम ओकरा देखयबैक जे हमर नामक कारणेँ ओकरा कतेक कष्‍ट सहऽ पड़तैक।” ");
INSERT INTO mai_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","तखन हननियाह गेलाह आ ओहि घर मे प्रवेश कऽ साउल पर हाथ राखि कऽ कहलथिन, “यौ साउल भाइ, प्रभु जे अहाँ केँ रस्‍ता मे अयबा काल दर्शन देलनि, अर्थात् यीशु, सैह हमरा अहाँ लग पठौलनि जाहि सँ अहाँ फेर देखी आ पवित्र आत्‍मा सँ परिपूर्ण भऽ जाइ।” ");
INSERT INTO mai_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","तखने साउलक आँखि सँ पपड़ी जकाँ किछु खसल आ ओ देखऽ लगलाह। ओ उठलाह और बपतिस्‍मा लेलनि। ");
INSERT INTO mai_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","तकरबाद ओ किछु भोजन कयलनि आ हुनका बल भेटलनि। साउल दमिश्‍क मे शिष्‍य सभक संग किछु दिन रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ओ तुरत ओतुक्‍का सभाघर सभ मे जा कऽ प्रचार करऽ लगलाह जे यीशु परमेश्‍वरक पुत्र छथि। ");
INSERT INTO mai_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","एहि पर सभ लोक जे हुनकर प्रचार सुनलक से अकचका कऽ बाजऽ लागल जे, “ई की भेल? की ई वैह आदमी नहि अछि जे यरूशलेम मे एहि नाम पर विश्‍वास करऽ वला सभ केँ सतबैत छल? और की ओ एहूठाम एहि लेल नहि आयल अछि जे यीशु केँ मानऽ वला सभ केँ पकड़ि कऽ मुख्‍यपुरोहित सभ लग लऽ जाय?” ");
INSERT INTO mai_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","मुदा साउल प्रचारक काज मे आओर सामर्थ्‍यवान होइत गेलाह। यीशुए उद्धारकर्ता-मसीह छथि तकर प्रमाण दऽ-दऽ कऽ ओ दमिश्‍क मे रहऽ वला यहूदी सभक मुँह बन्‍द कऽ दैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","एहि तरहेँ बहुत दिन बिति गेल। आब यहूदी सभ षड्‌यन्‍त्र रचऽ लागल जे साउल केँ जान सँ मारि दी। ");
INSERT INTO mai_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","मुदा साउल केँ एहि बातक खबरि भऽ गेलनि। यहूदी सभ दिन-राति शहरक द्वारि लग पहरा दऽ कऽ हुनका मारबाक ताक मे रहैत छल। ");
INSERT INTO mai_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","मुदा एम्‍हर हुनकर चेला सभ एक राति एकटा ढाकी मे हुनका बैसा कऽ शहरक देवाल पर बाटे ओहि पार उतारि देलकनि। ओ ओहिठाम सँ यरूशलेम चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","यरूशलेम पहुँचि कऽ साउल विश्‍वासी सभ मे सम्‍मिलित होयबाक प्रयत्‍न कयलनि मुदा ओ सभ हिनका सँ डेराइत छलाह कारण हुनका सभ केँ एहि बातक विश्‍वास नहि होइत छलनि जे वास्‍तव मे ओ यीशु मसीहक शिष्‍य बनि गेल छथि। ");
INSERT INTO mai_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","तखन बरनबास हुनका मसीह-दूत सभ लग लऽ गेलनि। ओ हुनका सभ केँ कहलथिन जे कोना साउल रस्‍ता मे प्रभु केँ देखलनि आ प्रभु कोना हिनका सँ गप्‍प कयलथिन और ई कतेक साहसक संग दमिश्‍क मे प्रभु यीशुक प्रचार कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","एकरबाद साउल हुनका सभक संग रहऽ लगलाह। ओ यरूशलेम मे घूमि-फिरि कऽ निडर भऽ कऽ प्रभु यीशुक प्रचार कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ओ यूनानी भाषी यहूदी सभ सँ वाद-विवाद करैत छलाह मुदा ओ सभ हिनका जान सँ मारि देबाक कोशिश करऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","विश्‍वासी भाय सभ केँ जखन एहि बातक खबरि भेलनि तँ ओ सभ हुनका कैसरिया लऽ जा कऽ तरसुस नगरक लेल विदा कऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","तकरबाद समस्‍त यहूदिया, गलील आ सामरिया प्रदेश मे विश्‍वासी मण्‍डली केँ अत्‍याचार सँ आराम भेटल। प्रभुक आदर करैत आ आज्ञा मानैत मण्‍डली मजगूत होइत गेल और परमेश्‍वरक पवित्र आत्‍मा सँ प्रोत्‍साहित भऽ विश्‍वासी सभक संख्‍या बढ़ैत गेल। ");
INSERT INTO mai_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","पत्रुस बहुत ठाम घुमैत-फिरैत लुद्दा नामक गाम मे विश्‍वासी सभ सँ भेँट करबाक लेल अयलाह। ");
INSERT INTO mai_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","एहिठाम एनियास नामक एक आदमी भेटलनि जे लकवा बिमारीक कारणेँ आठ वर्ष सँ ओछायन धऽ लेने छल। ");
INSERT INTO mai_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पत्रुस ओकरा कहलथिन, “हौ एनियास, यीशु मसीह तोरा स्‍वस्‍थ करैत छथुन। तोँ उठह आ अपन ओछायन ठीक करह।” ओ तुरत ठाढ़ भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","लुद्दा आ शारोनक सभ निवासी ओकरा देखलक, आ प्रभु यीशु पर विश्‍वास कयलक। ");
INSERT INTO mai_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","याफा नगर मे एक विश्‍वासी स्‍त्री छलीह जिनकर नाम तबीता छलनि, जकरा यूनानी भाषा मे “दोरकस”, ⌞अर्थात् “हिरणी”⌟ कहल जाइत अछि। ओ बराबरि अनेक तरहक काज द्वारा दोसराक, आ खास कऽ गरीब सभक, सहायता करैत छलीह। ");
INSERT INTO mai_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","जाहि समय मे पत्रुस लुद्दा मे छलाह ताहि समय मे ओ बिमार भेलीह आ मरि गेलीह। हुनकर लास केँ स्‍नान करा कऽ उपरका तल्‍ला पर कोठली मे राखि देल गेलनि। ");
INSERT INTO mai_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लुद्दा याफा सँ बेसी दूर नहि छल, आ तेँ विश्‍वासी सभ ई जानि जे पत्रुस लुद्दा मे छथि, दू आदमी केँ ई कहबाक लेल पत्रुस लग पठौलनि जे, “अहाँ एतऽ आबऽ मे देरी नहि करू!” ");
INSERT INTO mai_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","पत्रुस हुनका सभक संग विदा भेलाह। पहुँचलाक बाद लोक सभ हुनका उपरका तल्‍ला पर लऽ गेलनि। विधवा सभ पत्रुस केँ चारू कात सँ घेरि कऽ जे कुर्ता और अन्‍य वस्‍त्र सभ दोरकस मरऽ सँ पहिने बनौने छलीह, से सभ कानि-कानि कऽ देखाबऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","तखन पत्रुस सभ लोक केँ घर सँ बाहर कऽ देलनि, आ अपने ठेहुनिया दऽ कऽ प्रार्थना करऽ लगलाह। तकरबाद ओ लास दिस घूमि कऽ कहलथिन, “तबीता, उठि जाउ!” तबीता आँखि तकलनि आ सामने मे पत्रुस केँ देखि उठि कऽ बैसलीह। ");
INSERT INTO mai_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","पत्रुस हुनका हाथ धऽ कऽ ठाढ़ कयलनि। तखन ओ विधवा सभ और अन्‍य विश्‍वासी सभ केँ बजा कऽ दोरकस केँ हुनका सभक जिम्‍मा मे जीवित सौंपि देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ई बात सम्‍पूर्ण याफा मे पसरि गेल आ बहुत लोक प्रभु पर विश्‍वास कयलक। ");
INSERT INTO mai_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","पत्रुस याफा मे चमड़ाक कारोबार करऽ वला सिमोनक ओतऽ बहुत दिन धरि रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया नगर मे कुरनेलियुस नामक एक आदमी छलाह जे रोमी सेना मे ओहि पल्‍टनक कप्‍तान छलाह जे “इटली पल्‍टन” कहबैत छल। ");
INSERT INTO mai_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ओ अपन पूरा परिवार भक्‍तिपूर्बक परमेश्‍वरक भय मानऽ वला छलाह। ओ गरीब सभ केँ दान दैत छलाह और परमेश्‍वर सँ नियमित रूप सँ प्रार्थना करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","एक दिन बेरिआ मे, करीब तीन बजे परमेश्‍वरक एक स्‍वर्गदूत हुनका दर्शन देलथिन। ओ स्‍वर्गदूत केँ अपना लग अबैत स्‍पष्‍ट देखलथिन। स्‍वर्गदूत हुनका नाम लऽ कऽ कहलथिन, “यौ कुरनेलियुस!” ");
INSERT INTO mai_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","कुरनेलियुस डेराइते हुनका दिस एकटक लगा कऽ तकैत कहलथिन, “की बात, प्रभु?” स्‍वर्गदूत उत्तर देलथिन, “अहाँक प्रार्थना और गरीब सभ केँ देल गेल दान सभ चढ़ौनाक रूप मे परमेश्‍वर लग पहुँचल अछि, और ओ अहाँ पर ध्‍यान देलनि अछि। ");
INSERT INTO mai_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","आब अहाँ एना करू—किछु गोटे केँ याफा नगर मे सँ सिमोन, जकर दोसर नाम पत्रुस छैक, तकरा बजाबऽ लेल पठा दिऔक। ");
INSERT INTO mai_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ओ ओहिठाम दोसर सिमोन नामक आदमी, जे चमड़ाक कारोबार करैत अछि, आ जकर घर समुद्रक कात मे छैक, तकरा ओतऽ रहि रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","स्‍वर्गदूत केँ चल गेलाक बाद, कुरनेलियुस दूटा नोकर और अपन निजि सहायक सभ मे सँ एक भक्‍त सैनिक केँ बजबौलनि। ");
INSERT INTO mai_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ओ ओकरा सभ केँ सभ बात कहि देलथिन आ याफा नगर पठौलथिन। ");
INSERT INTO mai_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","प्रात भेने दुपहर कऽ ओ सभ याफा नगर लग पहुँचल, आ एम्‍हर पत्रुस प्रार्थना करबाक लेल छत पर गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","हुनका भूख लगलनि और किछु खयबाक इच्‍छा भेलनि, मुदा भानस भइए रहल छल। ओही समय मे हुनका सामने एक दृश्‍य प्रगट भेलनि। ");
INSERT INTO mai_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ओ स्‍वर्ग केँ खुजल और ओतऽ सँ बड़का चद्दरि जकाँ कोनो चीज, जकर चारू खूँट बान्‍हल छलैक, से नीचाँ पृथ्‍वी दिस उतारल जाइत देखलनि। ");
INSERT INTO mai_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ओहि चद्दरि मे सभ प्रकारक चौपाया जानबर, जमीन मे ससरऽ वला जीव-जन्‍तु और आकाशक चिड़ै सभ छल। ");
INSERT INTO mai_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","तखन पत्रुस केँ एक आवाज सुनाइ पड़लनि जे, “पत्रुस, उठह, आ एहि मे सँ मारि कऽ खाह!” ");
INSERT INTO mai_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","पत्रुस उत्तर देलथिन, “नहि, नहि प्रभु! हम कोनो अपवित्र वा अशुद्ध वस्‍तु कहियो नहि खयलहुँ।” ");
INSERT INTO mai_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","एहि पर फेर आवाज आयल जे, “जाहि वस्‍तु केँ परमेश्‍वर शुद्ध ठहरौने छथिन, तकरा तोँ अशुद्ध नहि कहक।” ");
INSERT INTO mai_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ई बात तीन बेर भऽ गेल, तखन एकाएक ओ चद्दरि फेर स्‍वर्ग दिस घीचि लेल गेल। ");
INSERT INTO mai_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","पत्रुस सोचिए रहल छलाह जे एहन दृश्‍यक अर्थ की भऽ सकैत अछि, ठीक ओही समय मे कुरनेलियुसक पठाओल आदमी सभ पुछैत-पुछैत सिमोनक घर लग पहुँचल, और बाहर वला द्वारि लग ठाढ़ भऽ ");
INSERT INTO mai_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","सोर पारि कऽ पुछलक, “की सिमोन पत्रुस नामक कोनो व्‍यक्‍ति एतऽ ठहरल छथि?” ");
INSERT INTO mai_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","पत्रुस एखनो ओहि दृश्‍यक सम्‍बन्‍ध मे विचार कऽ रहल छलाह कि परमेश्‍वरक आत्‍मा हुनका कहलथिन, “सिमोन! तोरा तीन आदमी ताकि रहल छह। ");
INSERT INTO mai_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","तेँ आब नीचाँ जाह आ कोनो तरहक दुबिधा मे नहि पड़ि कऽ ओकरा सभक संग जाह, कारण हमहीं ओकरा सभ केँ तोरा लग पठौने छिऐक।” ");
INSERT INTO mai_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","पत्रुस नीचाँ जा कऽ ओकरा सभ केँ कहलथिन, “जिनका अहाँ सभ ताकि रहल छी, से हम छी। अहाँ सभ कोन काज सँ अयलहुँ?” ");
INSERT INTO mai_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ओ सभ उत्तर देलकनि, “हम सभ कप्‍तान कुरनेलियुसक ओतऽ सँ अयलहुँ। ओ धार्मिक आ परमेश्‍वरक भय मानऽ वला लोक छथि। हुनका समस्‍त यहूदी जाति मे मान्‍यता छनि। एक पवित्र स्‍वर्गदूत हुनका आज्ञा देलथिन जे अपने केँ ओ अपना ओहिठाम बजबा कऽ अपनेक उपदेश सुनथि।” ");
INSERT INTO mai_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","तखन पत्रुस ओकरा सभ केँ घरक भीतर आनि कऽ सेवा-सत्‍कार करऽ लगलथिन। तकर प्राते भेने पत्रुस ओकरा सभक संग विदा भेलाह, और याफा सँ किछु विश्‍वासी भाय सेहो संग गेलनि। ");
INSERT INTO mai_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","एक दिनक बाद ओ सभ कैसरिया मे पहुँचि गेलाह। कुरनेलियुस हिनका सभक बाट तकैत छलथिन और अपन सम्‍बन्‍धी लोक आ इष्‍ट-मित्र सभ केँ बजा लेने छलाह। ");
INSERT INTO mai_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","जखन पत्रुस घर मे प्रवेश करहे वला छलाह तखन कुरनेलियुस आबि कऽ हुनकर पयर पर खसि कऽ प्रणाम कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","मुदा पत्रुस हुनका उठबैत कहलथिन, “उठू, उठू, हमहूँ मनुष्‍ये छी!” ");
INSERT INTO mai_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","हुनका सँ गप्‍प-सप्‍प करैत पत्रुस भीतर गेलाह, और बहुत लोक जमा भेल देखि ");
INSERT INTO mai_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ओकरा सभ केँ कहलथिन, “अहाँ सभ केँ बुझले अछि जे हमरा यहूदी लोकनिक धर्म-नियम गैर-यहूदी सँ सम्‍पर्क राखब वा ओकरा ओहिठाम जायब मना करैत अछि। मुदा परमेश्‍वर हमरा स्‍पष्‍ट कऽ देलनि जे ककरो अशुद्ध वा अछोप नहि बुझबाक चाही। ");
INSERT INTO mai_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","तेँ हमरा जखन बजाओल गेल तँ बिनु कोनो आपत्ति मानैत हम चल अबैत रहलहुँ। आब अहाँ सभ कहू जे हमरा कोन काज सँ बजौलहुँ।” ");
INSERT INTO mai_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","कुरनेलियुस उत्तर देलथिन, “चारि दिन पहिने हम एही समय मे, अर्थात् तीन बजे मे, अपना घर मे प्रार्थना कऽ रहल छलहुँ। एकाएक बहुत चमकैत वस्‍त्र पहिरने एक आदमी हमरा सामने मे ठाढ़ भऽ गेलाह ");
INSERT INTO mai_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","आ कहलनि, ‘कुरनेलियुस! परमेश्‍वर अहाँक प्रार्थना सुनने छथि और अहाँक दानक काज सँ प्रसन्‍न छथि। ");
INSERT INTO mai_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","अहाँ एना करू, सिमोन केँ, जकर दोसर नाम पत्रुस छैक, याफा सँ बजबा लिअ। ओ चमड़ाक कारोबार करऽ वला सिमोन, जकर घर समुद्रक कात मे छैक, तकरा ओतऽ ठहरल अछि।’ ");
INSERT INTO mai_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","तेँ हम अपने केँ तुरत बजबौलहुँ, और ई अपनेक कृपा भेल जे अपने हमरा ओहिठाम अयलहुँ। आब हम सभ गोटे एतऽ परमेश्‍वरक समक्ष उपस्‍थित छी, और परमेश्‍वर जे किछु कहबाक आज्ञा अपने केँ देने होथि, से सभ बात सुनबाक लेल हम सभ तैयार छी।” ");
INSERT INTO mai_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","एहि पर पत्रुस कहऽ लगलाह, “हम आब बुझि गेलहुँ जे सत्‍ये मे परमेश्‍वर ककरो संग पक्षपात नहि करैत छथि, ");
INSERT INTO mai_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","और जे केओ हुनकर भय मानैत छनि आ उचित काज करैत अछि चाहे ओ कोनो जातिक होअय, तकरा परमेश्‍वर स्‍वीकार करैत छथिन। ");
INSERT INTO mai_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","अहाँ सभ जनैत होयब जे परमेश्‍वर इस्राएली लोकक बीच एक शुभ समाचार सुनबौलथिन। ओ शुभ समाचार ई अछि जे यीशु मसीह, जे सभक प्रभु छथि, तिनका द्वारा परमेश्‍वरक संग मेल-मिलाप भऽ सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","अहाँ सभ इहो जनैत होयब जे यूहन्‍ना द्वारा पश्‍चात्ताप आ बपतिस्‍माक प्रचार भेलाक बाद, गलील प्रदेश सँ लऽ कऽ सम्‍पूर्ण यहूदिया प्रदेश मे की-की भेल— ");
INSERT INTO mai_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","कोना नासरत-निवासी यीशु केँ परमेश्‍वर अपना पवित्र आत्‍मा आ सामर्थ्‍य सँ परिपूर्ण कयलथिन, आ कोना ओ सभतरि घूमि-घूमि कऽ भलाइक काज करैत छलाह और शैतान सँ पीड़ित लोक सभ केँ स्‍वस्‍थ कऽ दैत छलाह। ई काज सभ ओ एहि लेल कऽ सकलाह जे परमेश्‍वर हुनका संग छलथिन। ");
INSERT INTO mai_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","और जतेक काज ओ यहूदिया प्रदेश आ यरूशलेम शहर मे कयलनि, तकर सभक साक्षी हम सभ छी। लोक सभ हुनका क्रूस पर चढ़ा कऽ मारि देलकनि, ");
INSERT INTO mai_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","मुदा परमेश्‍वर हुनका तेसर दिन फेर जिआ देलथिन, और प्रत्‍यक्ष देखौलथिन, ");
INSERT INTO mai_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","सभ केँ नहि, बल्‍कि ओही लोक सभ केँ जकरा ओ पहिनहि सँ गवाहक लेल चुनि लेने छलाह। ओ गवाह हम सभ छी आ हुनकर मृत्‍यु मे सँ जीबि उठलाक बाद हम सभ हुनका संग खयलहुँ-पिलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ओ हमरा सभ केँ आज्ञा देलनि जे हम सभ लोक सभक बीच ई शुभ समाचारक प्रचार करी आ गवाही दिऐक जे हुनके परमेश्‍वर सभ लोकक न्‍याय करबाक लेल नियुक्‍त कयने छथि, ओ सभ चाहे मुइल होअय वा जीवित। ");
INSERT INTO mai_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","हुनके विषय मे परमेश्‍वरक सभ प्रवक्‍ता लोकनि गवाही देने छथि जे, जे केओ हुनका पर विश्‍वास करत तकरा हुनका द्वारा पापक क्षमा भेटतैक।” ");
INSERT INTO mai_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पत्रुस जखन बाजिए रहल छलाह तखने जे सभ हुनकर ई प्रवचन सुनि रहल छल, तकरा सभ पर पवित्र आत्‍मा अयलाह। ");
INSERT INTO mai_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","ओ सभ अनजान भाषा मे बाजऽ लागल और परमेश्‍वरक स्‍तुति-प्रशंसा करऽ लागल। यहूदी विश्‍वासी सभ जे पत्रुसक संग आयल छलाह, से सभ ई देखि चकित रहि गेलाह जे परमेश्‍वर गैर-यहूदी सभ केँ सेहो अपन पवित्र आत्‍मा प्रदान कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","तखन पत्रुस कहलथिन, “की एकरा सभक बारे मे, जे अपने सभ जकाँ पवित्र आत्‍मा केँ प्राप्‍त कयने अछि, केओ कहि सकत जे एकरा सभ केँ बपतिस्‍मा नहि देल जाइक?” ");
INSERT INTO mai_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ई कहि ओ ओकरा सभ केँ प्रभु यीशु मसीहक नाम सँ बपतिस्‍मा लेबाक आदेश देलथिन। तखन ओ सभ पत्रुस सँ निवेदन कयलकनि जे, अपने हमरा सभक संग किछु दिन रहल जाओ। ");
INSERT INTO mai_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","मसीह-दूत सभ और यहूदिया प्रदेशक आरो विश्‍वासी भाय सभ जखन सुनलनि जे गैर-यहूदी सभ सेहो परमेश्‍वरक वचन स्‍वीकार कयने अछि, ");
INSERT INTO mai_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","तँ पत्रुस केँ यरूशलेम अयला पर यहूदी विश्‍वासी सभ हुनका पर दोष लगाबऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ओ सभ कहलथिन, “अहाँ गैर-यहूदी सभक घर मे प्रवेश कयलहुँ आ ओकरा सभक संग भोजनो कयलहुँ!” ");
INSERT INTO mai_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","तखन पत्रुस, कोना की भेल छल, से सभ बात हुनका सभ केँ शुरू सँ सुनाबऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ओ कहलथिन, “याफा नगर मे प्रार्थना करैत काल हम ध्‍यान-मग्‍न भऽ गेलहुँ और हमरा सामने एक दृश्‍य प्रगट भेल। हम एक बड़का चद्दरि सनक कोनो चीज चारू खूँट सँ बान्‍हल स्‍वर्ग सँ उतारल जाइत देखलहुँ। ओ वस्‍तु हमरा लग आबि कऽ रूकल। ");
INSERT INTO mai_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","हम जखन गौर सँ देखऽ लगलहुँ तँ ओहि मे हमरा घरैया-पशु, जंगली जानबर, जमीन मे ससरऽ वला जीव-जन्‍तु, और आकाशक चिड़ै सभ देखाइ पड़ल। ");
INSERT INTO mai_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","तखन हमरा ई आवाज सुनाइ देलक, ‘पत्रुस, उठह! एहि मे सँ मारि कऽ खाह!’ ");
INSERT INTO mai_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","मुदा हम उत्तर देलियनि जे, ‘नहि नहि, प्रभु! हम कोनो अपवित्र वा अशुद्ध वस्‍तु कहियो नहि खयने छी।’ ");
INSERT INTO mai_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","तखन दोसर बेर फेर स्‍वर्ग सँ आवाज सुनाइ देलक जे, ‘जाहि वस्‍तु केँ परमेश्‍वर शुद्ध ठहरौने छथिन, तकरा तोँ अशुद्ध नहि कहक।’ ");
INSERT INTO mai_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","एहिना तीन बेर भेल, आ तकरबाद ओ सभ वस्‍तु फेर स्‍वर्ग दिस उठा लेल गेल। ");
INSERT INTO mai_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“ताही क्षण मे तीन आदमी जे हमरा बजयबाक लेल कैसरिया सँ पठाओल गेल छल, से सभ ओहि घर लग पहुँचल जतऽ हम रहैत छलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","पवित्र आत्‍मा हमरा आदेश देलनि जे, कोनो खराब बात नहि सोचि कऽ ओकरा सभक संग जाह। ई छओटा विश्‍वासी भाय सेहो हमरा संग गेलाह और हम सभ ओहि आदमीक घर मे गेलहुँ जे हमरा बजबौने छलाह। ");
INSERT INTO mai_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ओ हमरा सभ केँ कहलनि जे कोना हुनका अपना घर मे स्‍वर्गदूत दर्शन देलथिन आ कहलथिन जे, ‘ककरो याफा नगर पठा कऽ सिमोन जकर दोसर नाम पत्रुस छैक, तकरा बजबा लिअ। ");
INSERT INTO mai_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ओ आबि कऽ अहाँ केँ उपदेश देत जाहि द्वारा अहाँ सपरिवार उद्धार प्राप्‍त करब।’ ");
INSERT INTO mai_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“हम जखन उपदेश देनाइ शुरुए कयने छलहुँ तखने पवित्र आत्‍मा हुनका सभ पर उतरि अयलाह, ठीक ओहिना जेना अपना सभ पर शुरू मे अयलाह। ");
INSERT INTO mai_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","तुरत प्रभुक कहल ओ बात हमरा मोन पड़ल जे, ‘यूहन्‍ना लोक केँ पानि सँ बपतिस्‍मा देलनि मुदा अहाँ सभ केँ पवित्र आत्‍मा सँ बपतिस्‍मा देल जायत।’ ");
INSERT INTO mai_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","जँ परमेश्‍वर हुनका सभ केँ वैह दान देलनि जे दान अपना सभ जखन प्रभु यीशु मसीह पर विश्‍वास कयलहुँ तखन अपना सभ केँ देलनि, तँ हम परमेश्‍वरक काज केँ रोकऽ वला के छी!” ");
INSERT INTO mai_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ई सुनि ओ सभ सन्‍तुष्‍ट भऽ गेलाह आ परमेश्‍वरक स्‍तुति करैत बजलाह, “तखन तँ परमेश्‍वर दोसरो जाति सभ केँ सेहो अपना पापक लेल पश्‍चात्ताप आ हृदय-परिवर्तन करबाक वरदान देलथिन जाहि सँ ओहो सभ जीवन प्राप्‍त करय!” ");
INSERT INTO mai_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","स्‍तिफनुस केँ मारल गेलाक बाद मसीही विश्‍वासी सभ पर जखन अत्‍याचार बढ़ऽ लागल तँ ओ सभ जहाँ-तहाँ छिड़िया गेलाह आ फीनिकी प्रदेश, साइप्रस द्वीप और अन्‍ताकिया नगर तक पहुँचलाह। मुदा विशेष काल ओ सभ मात्र यहूदी सभक बीच शुभ समाचारक प्रचार करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","परन्‍तु हुनका सभ मे सँ किछु लोक, जे साइप्रस आ कुरेनक निवासी छलाह, से सभ अन्‍ताकिया नगर जा कऽ यूनानी सभ सँ सेहो सम्‍पर्क कऽ ओकरा सभ केँ प्रभु यीशुक सम्‍बन्‍ध मे शुभ समाचार सुनाबऽ लगलथिन। ");
INSERT INTO mai_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","प्रभुक शक्‍ति हुनका सभक संग छलनि, आ बहुतो लोक प्रभु पर विश्‍वास कऽ कऽ हुनकर रस्‍ता पर आबि गेलनि। ");
INSERT INTO mai_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","अन्‍ताकिया मे भेल सभ बातक खबरि जखन यरूशलेमक विश्‍वासी मण्‍डली लग पहुँचल तँ ओ सभ बरनबास केँ अन्‍ताकिया पठौलनि। ");
INSERT INTO mai_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","ओ विश्‍वास और पवित्र आत्‍मा सँ परिपूर्ण एक नीक लोक छलाह। ओहिठाम पहुँचला पर जखन ओहिठामक लोकक बीच परमेश्‍वरक कृपाक परिणाम देखलनि तँ बरनबास अति आनन्‍दित भेलाह, आ सभ केँ प्रोत्‍साहित कयलनि जे अहाँ सभ पूरा तन-मन-धन सँ प्रभुक लेल ठोस विश्‍वासक संग स्‍थिर रहू। एहि तरहेँ ओहिठामक बहुतो लोक प्रभु यीशु पर विश्‍वास कयलक। ");
INSERT INTO mai_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","तखन बरनबास साउल केँ तकबाक लेल तरसुस नगर गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","हुनका सँ भेँट भेला पर, ओ हुनका ओतऽ सँ अन्‍ताकिया लऽ अनलथिन। ओ दूनू गोटे वर्ष दिन ओतऽ मण्‍डलीक संगति मे रहलाह आ बहुत लोक केँ प्रभुक विषय मे शिक्षा देलथिन। ओतहि, अर्थात् अन्‍ताकिए मे, सभ सँ पहिने प्रभु यीशु मसीहक शिष्‍य सभ केँ “मसीही” कहबाक प्रथा शुरू भेल। ");
INSERT INTO mai_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ओहि समय मे यरूशलेम सँ परमेश्‍वरक किछु प्रवक्‍ता सभ अन्‍ताकिया अयलाह। ");
INSERT INTO mai_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ओहि मे सँ एक, अगबुस नामक प्रवक्‍ता उठि कऽ परमेश्‍वरक आत्‍माक प्रेरणा सँ भविष्‍यवाणी कयलनि जे सम्‍पूर्ण राज्‍य मे भयंकर रौदी पड़त। (ई बात सम्राट क्‍लौदियुसक शासन काल मे पूरा भेल।) ");
INSERT INTO mai_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","तेँ प्रभुक शिष्‍य सभ निर्णय कयलनि जे हम सभ अपन-अपन सामर्थ्‍यक अनुसार यहूदिया प्रदेशक भाय सभक लेल किछु मदति करी। ");
INSERT INTO mai_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ओ सभ एहिना करबो कयलनि, आ बरनबास और साउलक हाथेँ अपन दान मण्‍डलीक देख-रेख कयनिहार सभ लग पठा देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","एही समय मे राजा हेरोद मण्‍डलीक किछु विश्‍वासी सभ पर अत्‍याचार करबाक लेल हुनका सभ केँ बन्‍दी बना लेलनि। ");
INSERT INTO mai_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ओ यूहन्‍नाक भाय याकूब केँ तरुआरि सँ मरबा देलनि। ");
INSERT INTO mai_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","जखन ओ देखलनि जे एहि घटना सँ यहूदी सभ प्रसन्‍न भेल अछि तँ ओ पत्रुस केँ सेहो पकड़बा लेलनि। ई “बिनु खमीरक रोटी वला पाबनि”क समय मे भेल। ");
INSERT INTO mai_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","पत्रुस केँ बन्‍दी बना कऽ जहल मे रखबा देलनि, आ चारि-चारि सैनिकक चारिटा दलक पहरा मे राखि देलनि। हेरोद सोचलनि जे पत्रुस केँ फसह-पाबनिक बाद जनताक सामने न्‍यायक लेल उपस्‍थित करायब। ");
INSERT INTO mai_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","तँ पत्रुस जहल मे छलाह, मुदा एम्‍हर विश्‍वासी सभ पूरा मोन सँ पत्रुसक लेल परमेश्‍वर सँ प्रार्थना कऽ रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","जाहि दिन राजा हेरोद पत्रुस केँ जनताक समक्ष अनबाक विचार कयने छलाह, ओहि सँ पहिलुके राति मे पत्रुस दू सैनिकक बीच, दूनू कात जिंजीर सँ बान्‍हल, सुतल छलाह। द्वारि लग सेहो सैनिक सभ पहरा दऽ रहल छल। ");
INSERT INTO mai_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","एकाएक प्रभुक एक स्‍वर्गदूत पत्रुस लग जहल मे ठाढ़ भेलाह। सम्‍पूर्ण कोठली प्रकाशमय भऽ गेल। स्‍वर्गदूत पत्रुस केँ हिला कऽ जगौलनि आ कहलथिन, “जल्‍दी उठह!” तुरत हिनकर दूनू हाथ सँ जिंजीर खुजि कऽ खसि पड़ल। ");
INSERT INTO mai_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","स्‍वर्गदूत कहलथिन, “कपड़ा सम्‍हारि लैह, आ चप्‍पल पहिरि लैह।” पत्रुस ओहिना कयलनि। तखन स्‍वर्गदूत कहलथिन, “चद्दरि ओढ़ि लैह आ हमरा पाछाँ आबह।” ");
INSERT INTO mai_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ओ हुनका पाछाँ-पाछाँ जहल सँ बाहर अयलाह, मुदा हुनका निश्‍चित भान नहि भऽ रहल छलनि जे स्‍वर्गदूत जे कऽ रहल छथि से सही घटना अछि—हुनका होइत छलनि जे हम कोनो तरहक सपना देखि रहल छी। ");
INSERT INTO mai_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ओ सभ पहिल और दोसर पहरेदार केँ टपि कऽ लोहाक मुख्‍य फाटक लग पहुँचलाह। हुनका सभ केँ पहुँचतहि ओ फाटक अपने सँ खुजि गेल, और ओ सभ निकलि कऽ शहर मे प्रवेश कऽ गेलाह। ओ सभ जखन गलीक अन्‍त तक गेलाह तँ स्‍वर्गदूत एकाएक पत्रुस केँ छोड़ि कऽ चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","तखन हिनका होश भेलनि आ बजलाह, “आब तँ निश्‍चय जानि गेलहुँ जे ठीके प्रभु अपन स्‍वर्गदूत पठा कऽ हेरोदक हाथ सँ और जे बात यहूदी सभ चाहैत छल, ताहि सभ सँ हमरा बचौलनि।” ");
INSERT INTO mai_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ई बात बुझि ओ यूहन्‍ना, जिनकर दोसर नाम मरकुस छलनि, तिनकर माय मरियमक ओतऽ गेलाह, जतऽ बहुत लोक जमा भऽ कऽ प्रार्थना कऽ रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","पत्रुस बाहर सँ केबाड़ खटखटौलनि। एक नोकरनी, जकर नाम रोदा छलैक, से केबाड़ खोलबाक लेल आयल। ");
INSERT INTO mai_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","पत्रुसक आवाज चिन्‍हि कऽ ओ ततेक खुश भेल जे बिनु केबाड़ खोलनहि ओ ई कहैत भीतर दौड़ि कऽ गेल जे, “पत्रुस बाहर छथि!” ");
INSERT INTO mai_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ओ सभ ओकरा कहलथिन, “तोँ बताहि छह!” मुदा ओ जखन बहुत जोर दऽ कऽ कहैत रहल जे वैह छथि तखन ओ सभ बजलाह, “हुनकर रक्षा करऽ वला स्‍वर्गदूत होयतनि।” ");
INSERT INTO mai_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","एम्‍हर पत्रुस केबाड़ खटखटबिते रहलाह। ओ सभ जखन खोलि कऽ हुनका देखलथिन तँ चकित रहि गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","पत्रुस हुनका सभ केँ शान्‍त होयबाक लेल हाथ सँ संकेत कयलनि आ कहऽ लगलथिन जे प्रभु कोना जहल सँ मुक्‍त कऽ देलनि। तखन कहलथिन, “ई सभ बात याकूब और दोसरो भाय सभ केँ कहि देबनि।” ई कहि ओ ओतऽ सँ दोसर ठाम चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","प्रात भेने जहल मे पहरेदारक बीच बड़का खलबली मचि गेल जे पत्रुस की भऽ गेल? ");
INSERT INTO mai_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","राजा हेरोद हुनका खोजबाक हुकुम देलथिन, मुदा ओ नहि भेटलथिन। तेँ हेरोद सैनिक सभ सँ पूछ-ताछ कऽ कऽ ओकरा सभ केँ मृत्‍युदण्‍डक आज्ञा देलथिन। तखन हेरोद यहूदिया प्रदेश छोड़ि कैसरिया नगर जा कऽ रहऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","हेरोद सूर और सीदोनक लोक सभ पर खिसिआयल छलाह। तेँ ओ सभ मिलि कऽ हेरोद सँ भेँट करबाक लेल पहुँचल। राजभवनक मुख्‍यकर्मचारी ब्‍लास्‍तुस केँ अपना पक्ष मे कऽ कऽ हुनका माध्‍यम सँ राजा लग मेल करबाक प्रस्‍ताव रखलक, कारण ओकरा सभक भोजनक वस्‍तु हेरोदक देश सँ अबैत छलैक। ");
INSERT INTO mai_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","निश्‍चित कयल दिन अयला पर राजा हेरोद राजसी वस्‍त्र पहिरने ओकरा सभक सामने सिंहासन पर बैसलाह और भाषण देलनि। ");
INSERT INTO mai_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","भाषण सुनि लोक सभ जोर-जोर सँ प्रशंसा करऽ लागल जे, “ई तँ मनुष्‍य नहि, देवते बाजि रहल छथि!” ");
INSERT INTO mai_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","एहि पर परमेश्‍वरक स्‍वर्गदूत हेरोद केँ ओही क्षण कष्‍ट सँ पीड़ित कऽ देलथिन, कारण जे स्‍तुति-प्रशंसा परमेश्‍वर केँ देबाक चाही से ओ नहि देलथिन। और हुनका देह मे पिलुआ फड़ि गेलनि और ओ मरि गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","मुदा परमेश्‍वरक वचन पसरैत गेल और लोक सभ मे ओकर प्रभाव बढ़ैत गेल। ");
INSERT INTO mai_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","एम्‍हर बरनबास और साउल दान पहुँचाबऽ वला काज पूरा कऽ कऽ यरूशलेम सँ घूमि अयलाह आ अपना संग यूहन्‍ना जिनकर दोसर नाम मरकुस छलनि, तिनको लेने अयलाह। ");
INSERT INTO mai_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अन्‍ताकियाक मण्‍डली मे ई सभ परमेश्‍वरक प्रवक्‍ता आ शिक्षक छलाह—बरनबास, सिमियोन, जे करिया कहबैत छलाह, कुरेन निवासी लूकियुस, मनेन, जे शासक हेरोदक संग पोसल गेल छलाह, और साउल। ");
INSERT INTO mai_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","एक दिन जखन ओ सभ उपासक संग प्रभुक आराधना कऽ रहल छलाह, तखन पवित्र आत्‍मा कहलथिन, “हमर ओहि काजक लेल बरनबास और साउल केँ अलग कऽ दिअ जाहि काजक लेल हम हुनका सभ केँ चुनने छी।” ");
INSERT INTO mai_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","तँ ओ सभ उपास आ प्रार्थना कऽ कऽ हुनका सभ पर हाथ राखि विदा कयलथिन। ");
INSERT INTO mai_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ई दूनू गोटे पवित्र आत्‍माक आदेशक अनुसार सिलूकिया चल गेलाह आ ओतऽ सँ पानि जहाज सँ साइप्रस द्वीप गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ओ सभ सलामिस शहर पहुँचि कऽ यहूदी सभक सभाघर सभ मे परमेश्‍वरक वचनक प्रचार कयलनि। हुनका सभक संग सहयोग करबाक लेल यूहन्‍ना-मरकुस सेहो छलनि। ");
INSERT INTO mai_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","तखन ओ सभ पूरा द्वीपक यात्रा करैत द्वीपक दोसर कात पाफुस नगर पहुँचलाह। ओतऽ हुनका सभ केँ बारयीशु नामक एक यहूदी भेटलनि, जे जादूगर छल आ झूठ बाजि कऽ अपना केँ परमेश्‍वरक प्रवक्‍ता कहैत छल। ");
INSERT INTO mai_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ओ प्रदेशक राज्‍यपाल सिरगियुस-पौलुसक संगी छल। राज्‍यपाल सिरगियुस एक विचारशील लोक छलाह। ओ बरनबास आ साउल केँ अपना ओहिठाम बजबौलनि जाहि सँ ओ हुनका सभ सँ परमेश्‍वरक वचन सुनि सकथि। ");
INSERT INTO mai_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","मुदा ओ जादूगर, जकर नाम यूनानी भाषा मे एलिमास छलैक, से हिनका सभक विरोध कऽ कऽ राज्‍यपाल केँ विश्‍वास करऽ सँ रोकबाक कोशिश कयलक। ");
INSERT INTO mai_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","तखन साउल, जे पौलुस सेहो कहबैत छलाह, पवित्र आत्‍मा सँ परिपूर्ण भऽ जादूगर एलिमास दिस एकटक लगा कऽ तकैत कहलथिन, ");
INSERT INTO mai_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“हे शैतानक पुत्र! हे सभ सत्‍कर्मक दुश्‍मन! तोँ सभ तरहक छल-प्रपंच आ बइमानी सँ भरल छेँ! की तोँ प्रभुक सोझ बाट केँ टेढ़ बनौनाइ कहियो नहि छोड़बेँ? ");
INSERT INTO mai_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","देख! आब प्रभुक हाथ तोरा विरोध मे उठलौ अछि। तोँ एखन आन्‍हर भऽ जयबेँ आ किछु काल तक सूर्यक प्रकाश नहि देखबेँ।” तखने ओकरा आगाँ मे धुनि जकाँ बुझायल और ओकर आँखि अन्‍हरा गेलैक। ओ एम्‍हर-ओम्‍हर हथोड़ऽ लागल जाहि सँ केओ भेटय जे हाथ पकड़ि कऽ लऽ जाय। ");
INSERT INTO mai_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","राज्‍यपाल ई घटना देखि विश्‍वास कयलनि। ओ प्रभुक शिक्षा सँ चकित छलाह। ");
INSERT INTO mai_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","तखन पौलुस और हुनकर संगी सभ पाफुस सँ पानि जहाज सँ पंफूलिया प्रदेशक पर्गा नगर गेलाह। ओतऽ सँ यूहन्‍ना-मरकुस हुनका सभ केँ छोड़ि कऽ यरूशलेम घूमि गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ई सभ पर्गा सँ आगाँ पिसिदिया अंचलक अन्‍ताकिया नगर पहुँचलाह, और विश्राम-दिन मे यहूदी सभक सभाघर मे जा कऽ बैसलाह। ");
INSERT INTO mai_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","धर्म-नियम आ परमेश्‍वरक प्रवक्‍ता सभक पुस्‍तक सँ पाठ पढ़ल गेलाक बाद, सभाघरक अधिकारी लोकनि हिनका सभ लग एहि बातक कहा पठौलथिन जे, “यौ भाइ लोकनि, अहाँ सभ जँ लोक सभक प्रोत्‍साहनक लेल किछु कहऽ चाहैत छी, तँ कहू।” ");
INSERT INTO mai_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","एहि पर पौलुस उठलाह, आ लोक सभ केँ हाथ सँ शान्‍त रहबाक संकेत करैत कहऽ लगलाह, “इस्राएली भाइ लोकनि और परमेश्‍वर मे श्रद्धा रखनिहार सभ गोटे, हमर बात सुनू! ");
INSERT INTO mai_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इस्राएली जातिक परमेश्‍वर अपना सभक पूर्वज सभ केँ चुनलनि आ मिस्र देश मे प्रवास करैत काल हुनका सभक वंशक वृद्धि कयलनि। तखन ओ अपन महान् शक्‍ति द्वारा हुनका सभ केँ ओहि देश सँ निकालि लेलनि। ");
INSERT INTO mai_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","चालिस वर्ष धरि ओ निर्जन क्षेत्र मे हुनका सभक व्‍यवहार सहन कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","तखन ओ कनान देशक सात जाति केँ विनाश करबा कऽ ओ देश हुनका सभक अधिकार मे दऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ई सभ काज पूरा होमऽ मे करीब 450 वर्ष बिति गेल। “तहिया सँ लऽ कऽ शमूएल प्रवक्‍ताक समय धरि परमेश्‍वर हुनका सभ केँ प्रशासक सभ देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","तखन इस्राएली लोक जखन परमेश्‍वर सँ एकटा राजा मँगलनि तँ ओ हुनका सभक लेल बिन्‍यामीन कुलक कीशक पुत्र शाउल केँ नियुक्‍त कयलनि, जे चालिस वर्ष धरि हुनका सभक राजा रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","तखन शाउल केँ हटा कऽ परमेश्‍वर दाऊद केँ हुनका सभक राजा बना देलथिन। दाऊदक सम्‍बन्‍ध मे ओ ई बात कहलनि, ‘यिशयक बेटा दाऊद हमर मोन पसन्‍दक लोक अछि। जे किछु हम चाहैत छी जे ओ करय, से सभ काज ओ करत।’ ");
INSERT INTO mai_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","एही आदमीक वंश मे सँ परमेश्‍वर अपन देल वचनक अनुसार इस्राएलक लेल एक उद्धारकर्ता, अर्थात्‌ यीशु केँ, उत्‍पन्‍न कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","यीशुक अयबाक तैयारी मे यूहन्‍ना इस्राएलक सभ लोकक बीच एहि बातक प्रचार कयलनि जे, अपना पापक लेल पश्‍चात्ताप कऽ हृदय-परिवर्तन करू आ बपतिस्‍मा लिअ। ");
INSERT INTO mai_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","जखन यूहन्‍ना अपन काज समाप्‍त करऽ वला छलाह तखन ओ कहलनि, ‘तोँ सभ हमरा जे बुझि रहल छह, से हम नहि छी! मुदा ओ हमरा पाछाँ आबि रहल छथि और हम तँ हुनकर चप्‍पलो फोलऽ जोगरक नहि छी।’ ");
INSERT INTO mai_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“यौ भाइ लोकनि, अब्राहमक वंशज आ परमेश्‍वर पर श्रद्धा रखनिहार आरो जातिक लोक सभ, सुनू! अपना सभ गोटेक लेल ई उद्धारक शुभ समाचार पठाओल गेल अछि! ");
INSERT INTO mai_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","यरूशलेमक निवासी और ओकरा सभक धर्मगुरु सभ यीशु केँ नहि चिन्‍हलकनि, आ ने परमेश्‍वरक प्रवक्‍ता सभक बात बुझलक जे प्रत्‍येक विश्राम-दिन सभाघर मे पढ़ल जाइत अछि, ओना तँ हुनका मृत्‍युदण्‍ड दऽ कऽ ओ सभ बिनु बुझने ओहि प्रवक्‍ता सभक भविष्‍यवाणी सभ पूरा कयलक। ");
INSERT INTO mai_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ओकरा सभ केँ हुनका मृत्‍युदण्‍ड देबाक लेल कोनो आधार नहि भेटलैक, मुदा तैयो पिलातुस सँ माँग कयलक जे हुनका मारिए देल जानि। ");
INSERT INTO mai_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","हुनका विषय मे पहिने सँ लिखल सभ बात ओकरा सभ द्वारा पूरा भेलाक बाद ओ सभ हुनका क्रूस पर सँ उतारि कऽ कबर मे राखि देलकनि। ");
INSERT INTO mai_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","मुदा परमेश्‍वर हुनका मृत्‍यु सँ जिआ देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","और ओ बहुत दिन धरि ओहि लोक सभ केँ दर्शन दैत रहलाह जे लोक हुनका संग गलील सँ यरूशलेम आयल छलनि। यैह लोक सभ आब जनताक सामने हुनकर गवाह अछि। ");
INSERT INTO mai_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“हम सभ ई खुशीक खबरि अहाँ सभ केँ सुनयबाक लेल आयल छी जे, जाहि बातक वचन परमेश्‍वर अपना सभक पूर्वज सभ केँ देने रहथि ");
INSERT INTO mai_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","से ओ यीशु केँ जिआ कऽ हुनका सभक सन्‍तानक लेल, अर्थात् अपना सभक लेल, पूरा कयलनि। जेना धर्मशास्‍त्रक ‘भजन-संग्रह’क दोसर भजन मे सेहो लिखल अछि, ‘अहाँ हमर पुत्र छी, आइ हम अहाँ केँ उत्‍पन्‍न कयलहुँ।’ ");
INSERT INTO mai_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","और ई बात जे, परमेश्‍वर हुनका मृत्‍यु मे सँ जिआ देलथिन जाहि सँ ओ फेर कहियो नहि मरथि, ताहि बातक वचन ओ एहि शब्‍द मे देने रहथि, ‘पवित्र और अटल आशिषक वचन जे दाऊद केँ देल गेल, से हम तोरा सभ मे पूरा करबह।’ ");
INSERT INTO mai_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","तहिना दोसर ठाम लिखल अछि, ‘अहाँ अपन पवित्र सेवक केँ नहि सड़ऽ देब।’ ");
INSERT INTO mai_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“दाऊद तँ अपन पीढ़ी मे परमेश्‍वरक उद्देश्‍य पूरा कयलनि आ मरलाह। ओ अपन पुरखा सभ लग कबर मे राखल गेलाह आ हुनकर शरीर सड़ि गेलनि। ");
INSERT INTO mai_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","मुदा जिनका परमेश्‍वर मृत्‍यु मे सँ जिआ देलथिन, से सड़लाह नहि। ");
INSERT INTO mai_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","तेँ प्रिय भाइ लोकनि, अहाँ सभ ई बात बुझि लिअ जे यीशुए द्वारा अहाँ सभ पापक क्षमा प्राप्‍त कऽ सकैत छी। ");
INSERT INTO mai_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","जे केओ हुनका पर विश्‍वास करैत अछि, से सभ धार्मिक ठहराओल जाइत अछि, और पाप सँ मुक्‍त भऽ जाइत अछि। ई बात मूसाक धर्म-नियम द्वारा नहि भऽ सकल छल। ");
INSERT INTO mai_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","एहि लेल सावधान होउ! एना नहि होअय जे परमेश्‍वरक प्रवक्‍ता लोकनिक ई बात अहाँ सभक संग भऽ जाय— ");
INSERT INTO mai_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘हे निन्‍दा कयनिहार लोक सभ! देखह, चकित होअह आ नष्‍ट भऽ जाह! कारण हम तोहर समय मे एहन काज कऽ रहल छी जे जँ केओ ओहि सम्‍बन्‍ध मे तोरा कहबो करतह तँ तोँ ओकर विश्‍वास नहि करबह।’” ");
INSERT INTO mai_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","जखन पौलुस और बरनबास सभाघर सँ बाहर भऽ रहल छलाह तँ लोक सभ हुनका सभ सँ विनती कयलक जे अगिलो विश्राम-दिन मे एहि बात सभक सम्‍बन्‍ध मे आरो सुनबथि। ");
INSERT INTO mai_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","सभा समाप्‍त भेला पर बहुतो यहूदी आ यहूदी धर्म मानऽ वला आन जातिक भक्‍त सभ पौलुस आ बरनबासक संग भऽ गेल। पौलुस आ बरनबास ओकरा सभ सँ बात-चीत कयलनि आ परमेश्‍वरक कृपा पर भरोसा रखने रहबाक लेल सिखौलथिन। ");
INSERT INTO mai_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","अगिला विश्राम-दिन प्रभुक वचन सुनबाक लेल करीब सौंसे नगरक लोक जुटि गेल। ");
INSERT INTO mai_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","भीड़ केँ देखि कऽ यहूदी सभ डाह सँ भरि गेल आ पौलुस केँ अपमानित करैत ओ जे बजैत छलाह तकर विरोध करऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","तखन पौलुस और बरनबास निर्भय भऽ कऽ ओकरा सभ केँ उत्तर देलथिन जे, “परमेश्‍वरक वचन हमरा सभ केँ पहिने अहाँ सभ केँ सुनाबऽ पड़ल। मुदा अहाँ सभ ओकर अस्‍वीकार कऽ रहल छी आ अपना केँ अनन्‍त जीवनक लेल योग्‍य नहि बुझैत छी। तेँ हम सभ आब दोसर जाति सभ केँ परमेश्‍वरक वचन सुनाबऽ जाइत छी। ");
INSERT INTO mai_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","कारण एहि तरहेँ प्रभु हमरा सभ केँ ई कहि कऽ आज्ञा देने छथि, ‘हम तोरा आन जाति सभक लेल प्रकाश नियुक्‍त कयने छिअह, जे तोँ पृथ्‍वीक अन्‍तिम सीमा तक हमर उद्धार पहुँचाबह।’” ");
INSERT INTO mai_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ई बात सुनि गैर-यहूदी जातिक लोक सभ बड्ड खुश भेल आ प्रभुक वचनक प्रशंसा करऽ लागल। और जे सभ अनन्‍त जीवनक लेल ठहराओल गेल छल, से सभ प्रभु पर विश्‍वास कयलक। ");
INSERT INTO mai_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","एहि तरहेँ प्रभुक वचन सम्‍पूर्ण क्षेत्र मे पसरि गेल। ");
INSERT INTO mai_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","मुदा यहूदी सभ परमेश्‍वर केँ मानऽ वला गैर-यहूदी जातिक स्‍त्रीगण सभ केँ जे सभ धनिक वर्गक छलि आ ओहि शहरक प्रतिष्‍ठित पुरुष सभ केँ चढ़ा-बढ़ा कऽ पौलुस आ बरनबासक विरोध मे उपद्रव करबाक लेल भड़का देलक और हुनका सभ केँ ओहि क्षेत्र सँ भगा देलकनि। ");
INSERT INTO mai_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","एहि पर पौलुस आ बरनबास ओकरा सभक विरोध मे चेन्‍ह स्‍वरूप पयरक गर्दा ओतहि झाड़ि लेलनि आ इकुनियुम नगर चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","एम्‍हर अन्‍ताकियाक शिष्‍य सभ बहुत आनन्‍दित आ पवित्र आत्‍मा सँ परिपूर्ण छलाह। ");
INSERT INTO mai_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","करीब वैह बात इकुनियुम मे सेहो भेल—पौलुस आ बरनबास यहूदी सभक सभाघर मे गेलाह, और एहन उपदेश देलनि जे बहुतो यहूदी और आन जातिक लोक सभ विश्‍वास कऽ लेलक। ");
INSERT INTO mai_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","मुदा जे यहूदी सभ विश्‍वास नहि करऽ चाहलक, से सभ आन जातिक लोक केँ बहकाबऽ लागल आ ओकरा सभक मोन मे विश्‍वासी भाय सभक प्रति दुश्‍मनी उत्‍पन्‍न कऽ देलकैक। ");
INSERT INTO mai_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","पौलुस आ बरनबास ओतऽ बहुत दिन धरि रहलाह आ निडर भऽ प्रभु यीशुक लेल प्रचार करैत रहलाह। प्रभु हुनका सभक माध्‍यम सँ आश्‍चर्यपूर्ण चिन्‍ह आ चमत्‍कारक काज सभ कऽ कऽ अपन कृपाक विषय मे हुनका सभक प्रचार केँ सत्‍य ठहरौलनि। ");
INSERT INTO mai_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","शहरक लोक मे आब फूट पड़ि गेल—किछु लोक यहूदी सभक संग भऽ गेल, आ किछु लोक मसीह-दूत सभक संग। ");
INSERT INTO mai_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","जखन आन जातिक लोक आ यहूदी सभ अपन अधिकारी सभक संग मिलि कऽ हिनका सभ केँ अपमानित करबाक आ पथरबाहि कऽ मारि देबाक लेल नियारलक, ");
INSERT INTO mai_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","तँ ई बात हिनको सभ केँ बुझऽ मे आबि गेलनि, आ तुरत लुकाउनिया क्षेत्रक लुस्‍त्रा और दरबे नगर मे भागि गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ओ सभ ओहि नगर सभ मे आ लग-पासक देहात मे शुभ समाचारक प्रचार करैत रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्‍त्रा नगर मे एक लोथ आदमी बैसल छल। ओ जन्‍मे सँ लोथ छल आ कहियो चलल नहि छल। ");
INSERT INTO mai_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ई आदमी पौलुसक प्रवचन सुनि रहल छल। पौलुस ओकरा टकटकी लगा कऽ देखलथिन आ ई देखि जे ओकरा ई विश्‍वास छैक जे हम स्‍वस्‍थ भऽ सकैत छी, ");
INSERT INTO mai_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ओ जोर सँ ओहि आदमी केँ कहलथिन, “अपन पयर पर सोझ भऽ कऽ ठाढ़ होउ!” एहि पर ओ छरपि कऽ ठाढ़ भेल आ चलऽ-फिरऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","भीड़क लोक सभ जखन देखलक जे पौलुस की कयलनि, तँ ओ सभ लुकाउनियाक भाषा मे जोर-जोर सँ बाजि कऽ कहऽ लागल, “देवता सभ मनुष्‍य बनि कऽ हमरा सभक बीच अयलाह अछि!” ");
INSERT INTO mai_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","बरनबास केँ ओ सभ “ज्‍यूस-देवता” सँ सम्‍बोधन करऽ लगलनि, आ पौलुस केँ “हिरमेस-देवता,” कारण पौलुस मुख्‍य बाजऽ वला छलाह। ");
INSERT INTO mai_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ज्‍यूस-देवताक पुजारी, जकर मन्‍दिर शहर सँ बाहर छल, से बड़का भीड़क संग हुनका सभ लग पशु-बलि चढ़यबाक लेल बड़द आ फूलक माला सभ लऽ कऽ शहरक प्रवेश-द्वारि लग आयल। ");
INSERT INTO mai_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","मुदा बरनबास आ पौलुस ई सुनि कऽ विरोध स्‍वरूप अपन वस्‍त्र फाड़लनि आ ओहि भीड़ मे दौड़ि कऽ गेलाह आ ओकरा सभ केँ जोर सँ कहऽ लगलाह, ");
INSERT INTO mai_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“अहाँ सभ ई की कऽ रहल छी?! हमहूँ सभ अहीं सभ जकाँ मनुष्‍ये छी! हम सभ अहाँ सभ केँ ई शुभ समाचार सुनयबाक लेल आयल छी जे अहाँ सभ निरर्थक मुरुतक पूजा-पाठ कयनाइ छोड़ि कऽ जीवित परमेश्‍वर जे आकाश, पृथ्‍वी, समुद्र और ओहि मे जे किछु अछि, तकर सभक रचना कयने छथि, तिनका पर विश्‍वास करू। ");
INSERT INTO mai_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","प्राचीन समय मे ओ सभ जाति केँ अपना-अपना रस्‍ता पर चलऽ देलनि, ");
INSERT INTO mai_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","तैयो ओ अपना भलाइक काज द्वारा मनुष्‍य जाति केँ अपना बारे मे साक्षी दैत रहलाह—ओ अहाँ सभ केँ आकाश सँ वर्षा आ ठीक समय पर उपजा दैत छथि। अहाँ सभ केँ भोजनक वस्‍तु सँ तृप्‍त करैत छथि और अहाँ सभक मोन केँ हर्षित करैत छथि।” ");
INSERT INTO mai_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ई सभ बात कहलाक बादो ओ सभ ओकरा सभ केँ बहुत मुश्‍किल सँ मना सकलाह जे हमरा सभ लग बलि नहि चढ़ाउ। ");
INSERT INTO mai_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","तखन अन्‍ताकिया और इकुनियुम सँ यहूदी सभ आयल और जनता केँ अपना पक्ष मे कऽ कऽ पौलुस पर पथरबाहि कयलक, आ हुनका मरल बुझि कऽ शहर सँ बाहर घिसिआ कऽ धऽ अयलनि। ");
INSERT INTO mai_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","मुदा शिष्‍य सभ जखन हुनका चारू कात जमा भेलनि तँ हुनका होश अयलनि और ओ उठि कऽ शहर मे गेलाह। प्रात भेने ओ बरनबासक संग दरबे नगर चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ओहू नगर मे ओ सभ शुभ समाचारक प्रचार कयलनि, और बहुत शिष्‍य सभ बना कऽ लुस्‍त्रा, इकुनियुम आ अन्‍ताकिया नगर घूमि अयलाह। ");
INSERT INTO mai_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","एहि नगर सभ मे ओ सभ शिष्‍य सभक हिम्‍मत बढ़बैत ओकरा सभ केँ विश्‍वास मे स्‍थिर रहबाक लेल प्रोत्‍साहित करैत छलाह, और कहैत छलाह जे “परमेश्‍वरक राज्‍य मे प्रवेश करबाक लेल अपना सभ केँ बहुत कष्‍ट सहऽ पड़त।” ");
INSERT INTO mai_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ओ सभ शिष्‍य सभक लेल प्रत्‍येक मण्‍डली मे देख-रेख कयनिहार सभ केँ नियुक्‍त कयलथिन और उपास आ प्रार्थना कऽ कऽ प्रभु यीशु, जिनका पर ओ सभ विश्‍वास रखने छलाह, तिनका हाथ मे सौंपि देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ओतऽ सँ पौलुस आ बरनबास पिसिदिया अंचल दऽ कऽ पंफूलिया प्रदेश मे अयलाह। ");
INSERT INTO mai_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ओहि अंचलक पर्गा नगर मे शुभ समाचार सुना कऽ अतालिया नगर अयलाह। ");
INSERT INTO mai_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ओतऽ सँ ओ सभ पानि जहाज सँ ⌞सीरिया प्रदेशक⌟ अन्‍ताकिया नगर मे घूमि अयलाह, जतऽ विश्‍वासी भाय सभ हुनका सभ केँ परमेश्‍वरक जिम्‍मा मे ओहि काजक लेल सौंपि देने छलनि, जाहि काज केँ ओ सभ आब पूरा कऽ लेने छलाह। ");
INSERT INTO mai_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ओ सभ ओहिठाम पहुँचि कऽ मण्‍डली केँ जमा कऽ कऽ सुनौलनि जे परमेश्‍वर हुनका सभक द्वारा केहन-केहन काज कयलनि, आ कोना परमेश्‍वर गैर-यहूदी लोकक लेल विश्‍वासक द्वारि खोलि देलनि। ");
INSERT INTO mai_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ओ सभ अन्‍ताकिया मे शिष्‍य सभक संग बहुत दिन धरि रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","तखन किछु लोक यहूदिया प्रदेश सँ अन्‍ताकिया मे आबि कऽ विश्‍वासी भाय सभ केँ एहि तरहेँ सिखाबऽ लागल जे, “जाबत धरि अहाँ सभ मूसाक प्रथाक अनुसार अपना शरीर मे खतनाक चेन्‍ह नहि कऽ लेब, ताबत धरि अहाँ सभक उद्धार नहि भऽ सकत।” ");
INSERT INTO mai_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","एहि विषय पर ओकरा सभक संग पौलुस आ बरनबास केँ बहुत झगड़ा आ वाद-विवाद भऽ गेलनि। अन्‍त मे ई निश्‍चय कयल गेल जे पौलुस, बरनबास आ ओहिठामक आरो किछु विश्‍वासी भाय सभ यरूशलेम जाथि आ एहि प्रश्‍नक विषय मे ओतऽ मसीह-दूत सभ और मण्‍डलीक देख-रेख कयनिहार लोकनिक संग बात करथि। ");
INSERT INTO mai_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","अन्‍ताकियाक मण्‍डली हुनका सभ केँ विदा कयलकनि। ओ सभ फीनिकी आ सामरिया प्रदेश दऽ कऽ गेलाह आ ओहिठामक विश्‍वासी भाय सभ केँ ई खबरि सुनौलनि जे कोना गैर-यहूदी लोक सभ सेहो विश्‍वास कयलनि, जकरा सुनि कऽ सभ विश्‍वासी भाय अति आनन्‍दित भेलाह। ");
INSERT INTO mai_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","पौलुस आ बरनबास जखन यरूशलेम पहुँचलाह तँ ओहिठामक मण्‍डली, मसीह-दूत आ मण्‍डलीक देख-रेख कयनिहार सभ हुनका सभक स्‍वागत कयलथिन। तखन पौलुस आ बरनबास हुनका सभ केँ सुनाबऽ लगलाह जे परमेश्‍वर हुनका सभक माध्‍यम सँ केहन-केहन काज सभ कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","एहि पर फरिसी दलक किछु लोक, जे विश्‍वासी भऽ गेल छल, से सभ उठि कऽ कहऽ लागल, “अन्‍यजातिक विश्‍वासी सभ केँ खतना करौनाइ जरूरी अछि, और ओकरा सभ केँ आज्ञा देल जाय जे ओ सभ मूसाक धर्म-नियमक पालन करय।” ");
INSERT INTO mai_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","एहि बातक सम्‍बन्‍ध मे विचार-विमर्श करबाक लेल, मसीह-दूत आ मण्‍डलीक देख-रेख कयनिहार लोकनि एक ठाम जमा भेलाह। ");
INSERT INTO mai_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","बहुत काल धरि घमर्थन भेलाक बाद, पत्रुस उठि कऽ कहलनि, “यौ भाइ लोकनि, अहाँ सभ केँ बुझल अछि जे बहुत दिन पहिने परमेश्‍वर अहाँ सभ मे सँ हमरा एहि लेल चुनलनि जे गैर-यहूदी लोक सभ हमरा मुँह सँ शुभ समाचार सुनय आ विश्‍वास करय। ");
INSERT INTO mai_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","मोनक बात बुझऽ वला परमेश्‍वर अपना सभ जकाँ ओकरो सभ केँ अपन पवित्र आत्‍मा प्रदान कऽ कऽ एहि बातक प्रमाण देलनि जे ओकरा सभ केँ ओ स्‍वीकार कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","अपना सभ और ओकरा सभ मे ओ कोनो भेद नहि रखलनि—ओ ओकरा सभक मोन विश्‍वासेक द्वारा शुद्ध कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","तेँ अहाँ सभ आब किएक विश्‍वासी सभक कान्‍ह पर एहन जुआ लादि कऽ परमेश्‍वर केँ जँचैत छियनि, जकरा ने अपना सभ आ ने अपना सभक पूर्वज लोकनि खीचि सकलाह? ");
INSERT INTO mai_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","नहि! अपना सभक विश्‍वास अछि जे अपना सभक उद्धार प्रभु यीशुक कृपेक कारणेँ भेल अछि—जेना ओकरा सभक तेना अपनो सभक।” ");
INSERT INTO mai_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ई बात सुनि कऽ सभाक सभ लोक चुप भऽ गेलाह, और पौलुस आ बरनबासक बात सुनऽ लगलाह जे परमेश्‍वर हुनका सभक द्वारा केहन-केहन आश्‍चर्यपूर्ण चिन्‍ह आ चमत्‍कार सभ गैर-यहूदी लोक सभक बीच कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","हुनका सभक बात जखन समाप्‍त भेलनि तखन याकूब बजलाह, “यौ भाइ लोकनि, हमर बात सुनू! ");
INSERT INTO mai_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","परमेश्‍वर कोना शुरू मे दोसरो जाति सभ पर दया कऽ कऽ ओकरा सभ केँ अपन लोक बना लेलनि, तकरा सम्‍बन्‍ध मे सिमोन एखने कहलनि, ");
INSERT INTO mai_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","आ हिनकर ई बात परमेश्‍वरक प्रवक्‍ता लोकनिक बात सँ सेहो मिलैत अछि, जेना लिखल अछि, ");
INSERT INTO mai_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘एकरा बाद हम घूमि कऽ आयब, आ दाऊदक खसल घर केँ फेर उठायब। ओकर ढहलाहा भाग केँ फेर बनायब, ओकर पुनः निर्माण करब, ");
INSERT INTO mai_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","जाहि सँ बाँकी सभ लोक सेहो हमरा ताकय, अर्थात् दोसर जातिक ओ लोक सभ, जकरा सभ केँ हम एहि लेल बजौलहुँ जे ओ सभ हमर बनय। ");
INSERT INTO mai_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ई बात कहऽ वला हम ओ परमेश्‍वर छी जे प्राचीन काल सँ एहि बात केँ स्‍पष्‍ट करैत आयल छी।’ ");
INSERT INTO mai_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“एहि लेल दोसर जातिक लोक सभ जे अपना बाट केँ छोड़ि कऽ परमेश्‍वर लग आबि रहल अछि, तकरा सभक लेल अपना सभ कठिनाइ नहि उत्‍पन्‍न करी, से हमर विचार अछि। ");
INSERT INTO mai_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","तेँ ओकरा सभ केँ लिखि पठा देल जाय जे ओ सभ एहि बात सभ सँ बाँचल रहथु—मूर्ति पर चढ़यबाक कारणेँ अशुद्ध भेल वस्‍तु सभ सँ, अनैतिक शारीरिक सम्‍बन्‍ध सँ, कण्‍ठ दबा कऽ मारल ⌞अर्थात्, बिनु खून बहा कऽ मारल⌟ पशुक माँसु सँ आ खूनक खान-पान सँ। ");
INSERT INTO mai_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","कारण, प्राचीन काल सँ तँ मूसाक धर्म-नियमक प्रचार नगर-नगर मे कयल जाइत अछि, आ हुनकर लेख प्रत्‍येक विश्राम-दिन सभाघर सभ मे पढ़ल जाइत अछि।” ");
INSERT INTO mai_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","तखन मसीह-दूत सभ आ मण्‍डलीक देख-रेख कयनिहार लोकनि पूरा मण्‍डलीक संग मिलि कऽ निर्णय कयलनि जे अपना सभ मे सँ किछु गोटे केँ चुनि कऽ पौलुस आ बरनबासक संग अन्‍ताकिया पठाबी। तँ यहूदा, जिनकर दोसर नाम बरसब्‍बा छलनि, आ सिलास केँ ओ सभ चुनलनि। हुनका सभ केँ विश्‍वासी भाय सभ विशेष मानैत छलनि। ");
INSERT INTO mai_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","हुनके सभक हाथेँ ओ सभ ई चिट्ठी पठौलनि— प्रिय अन्‍ताकिया, सीरिया आ किलिकियाक निवासी गैर-यहूदी विश्‍वासी भाय सभ, अहाँ सभ केँ मसीह-दूत आ यरूशलेमक मण्‍डलीक देख-रेख कयनिहार अहाँ सभक भाय लोकनिक दिस सँ नमस्‍कार। ");
INSERT INTO mai_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","हमरा सभ केँ सुनबा मे आयल अछि जे हमरा सभ मे सँ किछु गोटे अहाँ सभक ओहिठाम जा कऽ अपना बात द्वारा दुःख देने अछि। हम सभ ओकरा सभ केँ एहि तरहक कोनो आदेश नहि देने छलिऐक। ");
INSERT INTO mai_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","तेँ हम सभ एक ठाम जमा भऽ कऽ सभक सहमति सँ दू आदमी केँ अहाँ सभ लग पठयबाक निर्णय कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","हमरा सभक प्रिय मित्र पौलुस आ बरनबास, जिनकर जान अपना सभक प्रभु यीशु मसीहक नामक कारणेँ जाय लागल छलनि, ");
INSERT INTO mai_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","तिनका सभक संग हम सभ एहि दूनू भाय यहूदा आ सिलास केँ अहाँ सभ लग पठा रहल छी। ओ सभ अपन मुँहो सँ यैह बात कहि देताह जे एहि पत्र मे लिखल अछि। ");
INSERT INTO mai_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","पवित्र आत्‍मा केँ आ हमरा सभ केँ ई उचित बुझायल जे निम्‍नलिखित आवश्‍यक बात सभ केँ छोड़ि कऽ आरो कोनो बातक बोझ अहाँ सभ पर नहि लादी— ");
INSERT INTO mai_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","मूर्ति पर चढ़ाओल खयबाक वस्‍तु सँ, खूनक खान-पान सँ, कण्‍ठ दबा कऽ मारल ⌞अर्थात् बिनु खून बहा कऽ मारल⌟ पशुक माँसु सँ, आ अनैतिक शारीरिक सम्‍बन्‍ध सँ बँचू। एहि बात सभ सँ दूर रहला सँ अहाँ सभक भलाइ होयत। शेष शुभ। ");
INSERT INTO mai_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","हुनका सभ केँ मण्‍डलीक लोक विदा कयलकनि, आ ओ सभ अन्‍ताकिया गेलाह। ओतऽ पहुँचि कऽ ओ सभ मण्‍डलीक लोक केँ बजा कऽ चिट्ठी देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ओ सभ चिट्ठी पढ़ि प्रोत्‍साहनक एहन बात सँ अति आनन्‍दित भेलाह। ");
INSERT INTO mai_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहूदा आ सिलास, जे स्‍वयं परमेश्‍वरक प्रवक्‍ता छलाह, विभिन्‍न तरहक बात सँ विश्‍वासी भाय सभ केँ विश्‍वास मे मजगूत आ प्रोत्‍साहित कयलथिन। ");
INSERT INTO mai_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","यहूदा आ सिलास किछु दिन धरि अन्‍ताकिया मे रहलाह। तकरबाद विश्‍वासी भाय सभ हुनका सभ केँ आशीर्वाद दऽ कऽ, तिनका सभ लग विदा कऽ देलथिन जे सभ हुनका सभ केँ पठौने छलथिन। ");
INSERT INTO mai_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","मुदा सिलास ओहीठाम रहबाक निर्णय कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","पौलुस आ बरनबास अन्‍ताकिया मे रहि गेलाह, जतऽ ओ सभ, आ दोसरो बहुत गोटे, प्रभुक वचनक शिक्षा दैत रहलाह आ शुभ समाचार सुनबैत रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","किछु समय बितला पर पौलुस बरनबास केँ कहलथिन, “चलू! जाहि-जाहि नगर मे अपना सभ प्रभुक वचनक प्रचार कयने छी, ताहि-ताहि ठाम जा कऽ देखी जे ओतुक्‍का विश्‍वासी भाय सभ केहन छथि।” ");
INSERT INTO mai_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","बरनबास यूहन्‍ना केँ, जिनकर दोसर नाम मरकुस छलनि, सेहो संग लऽ जाय चाहैत छलाह, ");
INSERT INTO mai_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","मुदा पौलुस केँ ई बात उपयुक्‍त नहि बुझि पड़लनि जे, जे आदमी हुनका सभ केँ पंफूलिया प्रदेश मे छोड़ि देने छलनि आ जे हुनका सभक काज मे संग नहि देबऽ चाहलक, तकरा अपना संग मे लऽ जाइ। ");
INSERT INTO mai_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","एहि पर हुनका दूनू गोटे मे बहुत बड़का मतभेद भऽ गेलनि, और अन्‍त मे ओ सभ एक-दोसर सँ अलग भऽ गेलाह। बरनबास मरकुस केँ अपना संग लऽ पानि जहाज सँ साइप्रस द्वीप चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","पौलुस सिलास केँ चुनलनि। अन्‍ताकियाक भाय सभ हुनका सभ केँ प्रभुक कृपा पर सौंपि विदा कयलथिन। ");
INSERT INTO mai_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ओ सभ सीरिया आ किलिकिया प्रदेश मे घूमि-घूमि कऽ ओहिठामक मण्‍डली सभ केँ विश्‍वास मे मजगूत करैत आगाँ बढ़ैत गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ओ सभ दरबे आ लुस्‍त्रा नगर पहुँचलाह। ओतऽ तिमुथियुस नामक एक शिष्‍य छलाह, जिनकर माय प्रभु यीशु पर विश्‍वास कयनिहारि यहूदी जातिक छलीह, मुदा हुनकर पिता यूनानी छलनि। ");
INSERT INTO mai_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","लुस्‍त्रा आ इकुनियुम नगर मे रहऽ वला विश्‍वासी भाय सभ हुनका नीक लोक कहैत छल। ");
INSERT INTO mai_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पौलुस हुनका अपना संग लऽ जाय चाहलनि, तेँ ओहिठामक यहूदी सभक कारणेँ ओ हुनकर खतना करबौलनि, कारण सभ केओ जनैत छल जे हुनकर पिता यहूदी नहि, बल्‍कि यूनानी अछि। ");
INSERT INTO mai_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","तखन पौलुस, सिलास आ तिमुथियुस शहर-शहर मे घूमि-घूमि कऽ विश्‍वासी सभ केँ ओ नियम आ निर्णय सभ सुना देलथिन आ पालन करबाक लेल सिखौलथिन, जे निर्णय मसीह-दूत सभ आ मण्‍डलीक देख-रेख कयनिहार लोकनि यरूशलेम मे कयने छलाह। ");
INSERT INTO mai_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","एहि तरहेँ मण्‍डली सभक लोक सभ अपना विश्‍वास मे मजगूत होइत गेल, आ संख्‍या मे दिनानुदिन बढ़ैत गेल। ");
INSERT INTO mai_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","पौलुस आ हुनकर संगी सभ फ्रूगिया आ गलातिया प्रदेश दऽ कऽ गेलाह, कारण पवित्र आत्‍मा हुनका सभ केँ प्रभुक वचन सुनयबाक लेल आसिया प्रदेश मे जयबाक आज्ञा नहि देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","जखन ओ सभ मीसिया क्षेत्र आ बितूनिया प्रदेशक सीमा पर पहुँचलाह, तँ बितूनिया प्रदेश मे जयबाक कोशिश कयलनि, मुदा यीशुक आत्‍मा हुनका सभ केँ ओतऽ नहि जाय देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","तेँ ओ सभ मीसिया दऽ कऽ त्रोआस नगर गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ओही राति पौलुस प्रभुक दिस सँ एक सपना देखलनि, जाहि मे मकिदुनिया निवासी एक आदमी ठाढ़ भेल एहि तरहेँ निवेदन करैत छलनि जे, “एहि पार मकिदुनिया प्रदेश मे आउ आ हमरा सभक मदति करू!” ");
INSERT INTO mai_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","पौलुस केँ एहि तरहक सपना देखलाक बाद, हम सभ तुरत्ते मकिदुनियाक लेल विदा होयबाक तैयारी करऽ लगलहुँ, ई बुझि जे परमेश्‍वरे ओकरा सभक बीच शुभ समाचार सुनयबाक लेल हमरा सभ केँ आदेश देलनि अछि। ");
INSERT INTO mai_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","त्रोआस नगर सँ पानि जहाज सँ हम सभ सोझे समुत्राके द्वीप तक गेलहुँ, आ दोसर दिन नियापुलस नगर तक। ");
INSERT INTO mai_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ओतऽ सँ मकिदुनिया प्रदेशक फिलिप्‍पी नगर गेलहुँ, जे जिलाक प्रमुख शहर अछि आ रोमी सरकार द्वारा निर्माण कयल गेल अछि। ओतऽ हम सभ बहुत दिन धरि रहलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","हम सभ विश्राम-दिन मे शहरक बाहर नदीक कछेर दिस गेलहुँ ई सोचि कऽ जे, ओतऽ कोनो ठाम होयत जतऽ लोक प्रार्थना करबाक लेल जमा होइत अछि। ओहिठाम पहुँचि कऽ हम सभ बैसि गेलहुँ, आ ओतऽ जमा भेल स्‍त्रीगण सभ सँ बात-चीत करऽ लगलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ओहि मे थूआतीरा नगरक एक लुदिया नामक स्‍त्री रहथि जे किमती रंगीन कपड़ाक व्‍यापार करैत छलीह। ओ परमेश्‍वर केँ माननिहारि छलीह आ हमरा सभक बात सुनि रहल छलीह। प्रभु हुनका मोनक द्वारि खोललनि जाहि सँ ओ पौलुसक बात पर ध्‍यान दऽ कऽ विश्‍वास करथि। ");
INSERT INTO mai_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ओ पूरा परिवारक संग बपतिस्‍मा लेलनि आ हमरा सभ सँ आग्रह कयलनि जे, “अपने लोकनि जँ बुझैत छी जे हम वास्‍तव मे प्रभु पर विश्‍वास कयलहुँ तँ हमरा ओतऽ चलि कऽ रहल जाओ।” एना कहि ओ हमरा सभ केँ बाध्‍य कऽ देलनि जे हम सभ हुनका ओतऽ जाइ। ");
INSERT INTO mai_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","एक दिन हम सभ जखन प्रार्थना करऽ वला स्‍थान पर जा रहल छलहुँ तँ रस्‍ता मे एक गुलाम बच्‍ची हमरा सभ केँ भेटल, जकरा मे भविष्‍यक बात कहऽ वला दुष्‍टात्‍मा छलैक। ओ लोक सभ केँ भाग्‍यक बात सभ कहि कऽ अपना मालिक सभक लेल बहुत पाइ कमाइत छल। ");
INSERT INTO mai_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ओ पौलुस आ हमरा सभक पाछाँ-पाछाँ आबि कऽ चिचियाय लागल, “ई सभ परम परमेश्‍वरक सेवक छथि और अहाँ सभ केँ उद्धारक बाटक विषय मे सुना रहल छथि।” ");
INSERT INTO mai_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ओ बहुत दिन धरि एहिना करैत रहल। अन्‍त मे पौलुस एक दिन तंग भऽ कऽ ओकरा दिस तकैत ओहि दुष्‍टात्‍मा केँ कहलथिन, “हम तोरा यीशु मसीहक नाम सँ आज्ञा दैत छिऔ जे तोँ एकरा मे सँ निकल!” तखने ओ दुष्‍टात्‍मा ओहि बच्‍ची मे सँ निकलि गेल। ");
INSERT INTO mai_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","जखन बच्‍चीक मालिक सभ देखलक जे ओकर सभक कमाइक बाट समाप्‍त भऽ गेल, तखन ओ सभ पौलुस आ सिलास केँ पकड़ि कऽ शहरक चौक तक अधिकारी सभक सामने घिसिअबैत अनलकनि। ");
INSERT INTO mai_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ओ सभ हुनका सभ केँ रोमी न्‍यायाधीश सभक समक्ष ठाढ़ कऽ कऽ कहलक, “ई सभ यहूदी अछि। ई सभ हमरा सभक शहर मे उपद्रव मचा रहल अछि, ");
INSERT INTO mai_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","आ एहन-एहन प्रथाक प्रचार कऽ रहल अछि जकरा स्‍वीकार कयनाइ वा पालन कयनाइ अपना सभक लेल जे रोमी छी, कानूनक दृष्‍टिकोण सँ मना अछि।” ");
INSERT INTO mai_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","एहि पर ओकरा सभक संग भीड़क लोक सभ सेहो पौलुस आ सिलासक विरोध करऽ लागल। तखन न्‍यायाधीश सिपाही सभ केँ ई आदेश देलनि जे हुनका सभ केँ कपड़ा उतारि कऽ लाठी मारल जाय। ");
INSERT INTO mai_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","हुनका सभ केँ बहुत पिटलाक बाद जहल मे राखि देलकनि। जहलक हाकिम केँ आज्ञा देल गेलैक जे, एकरा सभ केँ जहल मे नीक सँ बन्‍द करू। ");
INSERT INTO mai_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ई आदेश पाबि जहलक हाकिम हुनका सभ केँ भीतरका कोठली मे लऽ गेलनि आ हड़ी मे ठोकि देलकनि। ");
INSERT INTO mai_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","करीब दुपहर राति कऽ पौलुस आ सिलास प्रार्थना कऽ रहल छलाह आ परमेश्‍वरक स्‍तुति मे गीत गाबि रहल छलाह। हुनका सभक प्रार्थना आ गीत दोसरो कैदी सभ सुनि रहल छलनि। ");
INSERT INTO mai_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","एकाएक बड़का भूकम्‍‍प भेल आ जहलक न्‍योओ तक हिलि गेल। तुरत्ते सभ केबाड़ खुजि गेल आ सभ कैदी बन्‍हन-मुक्‍त भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","जहलक हाकिमक निन्‍द टुटलैक, आ ओ जखन देखलक जे जहलक केबाड़ सभ खुजल अछि तँ सोचलक जे कैदी सभ भागि गेल। तेँ ओ अपन तरुआरि खीचि कऽ आत्‍महत्‍या करऽ लागल, ");
INSERT INTO mai_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","मुदा तखने पौलुस जोर सँ सोर पारि कऽ कहलथिन, “रूकू रूकू! अपना केँ किछु नहि करू। हम सभ केओ छीहे!” ");
INSERT INTO mai_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ई सुनिते हाकिम इजोत मँगबा कऽ दौड़ैत भीतर अयलाह आ थर-थर कँपैत पौलुस आ सिलासक पयर पर खसलाह। ");
INSERT INTO mai_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ओ हुनका सभ केँ बाहर आनि कऽ कहलथिन, “यौ सरकार! अपने लोकनि हमरा ई कहू जे उद्धार पयबाक लेल हम की करू।” ");
INSERT INTO mai_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ओ सभ उत्तर देलथिन, “प्रभु यीशु पर विश्‍वास करू तँ अहाँक उद्धार होयत, और अहाँक पूरा परिवार उद्धार प्राप्‍त करत।” ");
INSERT INTO mai_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ओ सभ हुनका आ हुनकर पूरा परिवार केँ प्रभुक शुभ समाचारक बात सुना देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","तखन तुरत्ते रातिए मे, जहलक हाकिम हुनका सभ केँ लऽ जा कऽ घाव धो देलथिन। तकरबाद ओ अपन पूरा परिवारक संग बपतिस्‍मा लेलनि। ");
INSERT INTO mai_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","तखन जहलक हाकिम पौलुस आ सिलास केँ अपना डेरा मे आनि कऽ भोजन करौलनि। ओ अपन पूरा परिवारक संग परमेश्‍वर पर विश्‍वास करबाक कारणेँ बहुत आनन्‍दित छलाह। ");
INSERT INTO mai_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","भोर भेला पर न्‍यायाधीश सभ अपना सिपाही सभ केँ ई आदेश दऽ कऽ जहलक हाकिम लग पठौलनि जे, “ओहि दूनू गोटे केँ छोड़ि दिऔक।” ");
INSERT INTO mai_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","जहलक हाकिम पौलुस केँ कहलथिन, “न्‍यायाधीशजी आदेश पठौलनि अछि जे अपने लोकनि केँ छोड़ि देल जाय। तेँ अपने लोकनि आब जा सकैत छी। बेस, नीक सँ गेल जाओ।” ");
INSERT INTO mai_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","मुदा पौलुस सिपाही सभ केँ कहलथिन, “हम सभ, जे रोमी नागरिक छी, तकरा सभ केँ ओ सभ बिनु दोषी पौनहि जनताक सामने मे पिटबौलनि आ जहल मे बन्‍द करबौलनि, और आब की, हमरा सभ केँ चुपेचाप निकालऽ चाहैत छथि? नहि! ओ सभ अपने आबि कऽ हमरा सभ केँ बाहर लऽ चलथु।” ");
INSERT INTO mai_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","सिपाही सभ हुनकर कहल बात न्‍यायाधीश सभ केँ सुनौलक। ओ सभ जखन सुनलनि जे पौलुस आ सिलास रोमी नागरिक छथि, तँ बहुत डेरा गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ओ सभ पौलुस आ सिलास लग आबि हुनका सभ केँ मनाबऽ लगलथिन, आ जहल सँ बाहर आनि शहर छोड़ि कऽ चल जयबाक विनती कयलथिन। ");
INSERT INTO mai_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","पौलुस आ सिलास जहल सँ बाहर भऽ लुदियाक घर गेलाह। ओतऽ विश्‍वासी भाय सभ सँ भेँट कऽ कऽ हुनका सभ केँ विश्‍वास मे प्रोत्‍साहित कयलनि। तकरबाद ओ सभ ओतऽ सँ विदा भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ओ सभ अम्‍फिपुलस और अपुलोनिया नगर सभ दऽ कऽ थिसलुनिका शहर पहुँचलाह, जतऽ यहूदी सभक एक सभाघर छल। ");
INSERT INTO mai_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","पौलुस जहिना सभ ठाम करैत छलाह तहिना एहूठामक सभाघर मे गेलाह। तीन सप्‍ताह धरि विश्राम-दिन मे ओ ओकरा सभ सँ धर्मशास्‍त्र पर तर्क-वितर्क कयलनि, ");
INSERT INTO mai_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","और ओकरा सभ केँ धर्मशास्‍त्रक बात बुझबैत ओहि मे सँ एहि बातक प्रमाण दैत रहलाह जे उद्धारकर्ता-मसीह केँ दुःख भोगनाइ आ मरि कऽ जीबि उठनाइ आवश्‍यक छलनि। ओ कहैत छलाह, “ई यीशु जिनका बारे मे हम अहाँ सभ केँ सुना रहल छी, सैह उद्धारकर्ता-मसीह छथि।” ");
INSERT INTO mai_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ई बात यहूदी सभ मे सँ किछु गोटे स्‍वीकार कयलक, और पौलुस आ सिलासक संग भऽ गेल। तहिना परमेश्‍वर पर श्रद्धा रखनिहार बहुत यूनानी सभ आ प्रतिष्‍ठित स्‍त्रीगण सभ सेहो विश्‍वास कयलक। ");
INSERT INTO mai_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","मुदा एहि पर यहूदी सभ ईर्ष्‍या सँ भरि गेल, आ किछु आवारा-गुण्‍डा सभ केँ चढ़ा-बढ़ा कऽ बड़का भीड़ जुटा लेलक आ शहर मे हूलि मचाबऽ लागल। तखन ओ सभ पौलुस आ सिलास केँ तकबाक लेल यासोनक घर गेल। ओ सभ हुनका सभ केँ पकड़ि कऽ जन-सभाक सामने आनऽ चाहैत छल। ");
INSERT INTO mai_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","मुदा यासोनक घर मे ओ सभ जखन नहि भेटलथिन, तँ ओ सभ यासोन आ किछु आरो विश्‍वासी भाय सभ केँ घिसिअबैत आनि कऽ शहरक पंच सभक सामने ठाढ़ कऽ देलक आ जोर-जोर सँ हल्‍ला करैत हुनका सभ पर दोष लगाबऽ लागल जे, “ई सभ जे सौंसे संसार केँ उनट-पुनट कऽ रहल अछि से सभ आब एतौ आबि गेल अछि ");
INSERT INTO mai_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","आ यासोन एकरा सभ केँ अपना घर मे पाहुन बना कऽ रखने अछि। ई सभ सम्राट-कैसरक कानून सभक विरोध कऽ रहल अछि आ कहैत अछि जे एक दोसर आदमी, यीशु, हमरा सभक राजा छथि।” ");
INSERT INTO mai_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ई सुनि जनता आ शहरक हाकिम सभ बहुत घबड़ा गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","तेँ हाकिम सभ यासोन आ दोसरो लोक सभ सँ जमानत लेलनि, तखन हुनका सभ केँ जाय देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ओही दिन अन्‍हार होइत देरी विश्‍वासी भाय सभ पौलुस आ सिलास केँ बिरीया नगर पठा देलथिन। ओतऽ पहुँचि कऽ ओ सभ यहूदी सभक सभाघर मे गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","बिरीया निवासी यहूदी सभ थिसलुनिका निवासी यहूदी सभक अपेक्षा नम्र भावनाक छल, कारण ओ सभ बहुत उत्‍सुकता सँ प्रभुक शुभ समाचारक बात सुनलक आ प्रत्‍येक दिन धर्मशास्‍त्रक अध्‍ययन नीक जकाँ एहि लेल करैत छल जे, देखी, पौलुसक कहल बात एहि सँ मिलैत अछि वा नहि। ");
INSERT INTO mai_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","फलस्‍वरूप बहुत यहूदी लोक सभ विश्‍वास कयलक। तहिना बहुतो प्रतिष्‍ठित यूनानी स्‍त्रीगण आ पुरुष सभ सेहो विश्‍वास कयलक। ");
INSERT INTO mai_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","जखन थिसलुनिकाक यहूदी सभ केँ पता चललैक जे पौलुस आब बिरीया मे परमेश्‍वरक वचनक प्रचार कऽ रहल अछि, तँ ओ सभ ओतौ जा कऽ हूलि मचबाबऽ आ जनता केँ भड़काबऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","एहि पर विश्‍वासी भाय सभ तुरत पौलुसक लेल समुद्रक कात जयबाक व्‍यवस्‍था कऽ कऽ विदा कऽ देलथिन, मुदा सिलास आ तिमुथियुस बिरीये मे रहि गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पौलुसक संग जे सभ गेलाह से सभ हुनका एथेन्‍स शहर तक पहुँचौलथिन। ओतऽ पौलुस हुनका सभ केँ कहलथिन जे, सिलास और तिमुथियुस केँ जल्‍दी चल अयबाक लेल कहि दिऔन। तखन ओ सभ ओतऽ सँ घूमि गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","पौलुस एथेन्‍स शहर मे सिलास आ तिमुथियुसक अयबाक प्रतीक्षा कऽ रहल छलाह। शहर मे देवी-देवता सभक मूर्ति सभतरि देखि हुनका बहुत दुःख भेलनि। ");
INSERT INTO mai_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","तेँ ओ सभाघर मे यहूदी सभ आ परमेश्‍वर केँ माननिहार यूनानी सभ सँ एहि सम्‍बन्‍ध मे बात-चीत करैत छलाह, और प्रत्‍येक दिन चौक-बजार मे आबऽ-जाय वला लोक सभ सँ सेहो बात-चीत करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","किछु ईपिकूरी आ स्‍तोइकी विचारधाराक विद्वान सभ हुनका सँ विवाद करऽ लागल आ बाजल, “ई टर्र-टर्र करऽ वला कहऽ की चाहैत अछि?” दोसर सभ कहैत छल, “ई कोनो आन देशक देवताक प्रचार करऽ वला बुझाइत अछि।” ई बात एहि लेल कहलक जे पौलुस यीशुक आ मृत्‍यु मे सँ जीबि उठनाइक विषय मे प्रचार करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","एक दिन ओ सभ पौलुस केँ अपना संग अरियोपिगुस-सभा मे लऽ गेलनि। ओतऽ ओ सभ हुनका सँ पुछलकनि, “की हम सभ ई जानि सकैत छी जे अहाँ ई कोन नव शिक्षा दऽ रहल छी? ");
INSERT INTO mai_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","अहाँ जे किछु कहि रहल छी से हमरा सभ केँ एकदम नव बुझि पड़ैत अछि, तेँ हम सभ जानऽ चाहैत छी जे एकर अर्थ की अछि।” ");
INSERT INTO mai_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(एथेन्‍स नगरक वासी और ओतऽ रहऽ वला परदेशी सभक काजे एतबे छल जे नवका-नवका बात सुनी आ सुनाबी।) ");
INSERT INTO mai_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","एहि पर पौलुस अरियोपिगुस-सभा मे ठाढ़ भऽ कऽ कहऽ लगलाह, “एथेन्‍सक निवासी लोकनि, हम देखैत छी जे अहाँ सभ हर प्रकार सँ बड्ड धर्म-प्रेमी लोक छी। ");
INSERT INTO mai_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","हम घूमि-फिरि कऽ जखन अहाँ सभक ओहि स्‍थान सभ केँ देखैत छलहुँ जतऽ अहाँ सभ पूजा करैत छी तँ हमरा एक एहन पीड़ी भेटल जाहि पर लिखल अछि ‘अज्ञात ईश्‍वरक लेल’। तँ जिनका अहाँ सभ बिनु जननहि पूजैत छी, हम तिनके बारे मे अहाँ सभ केँ सुना रहल छी। ");
INSERT INTO mai_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“परमेश्‍वर, जे एहि संसार आ एहि मेहक प्रत्‍येक वस्‍तुक सृष्‍टि कयलनि, से स्‍वर्ग और पृथ्‍वीक मालिक भऽ, मनुष्‍य द्वारा बनाओल मन्‍दिर मे वास नहि करैत छथि। ");
INSERT INTO mai_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","आ हुनका कोनो वस्‍तुक कमी नहि छनि, जकरा मनुष्‍य हुनकर सेवा करैत पूरा करनि, किएक तँ वैह छथि जे सभ केँ जीवन, साँस, आ आओर सभ किछु दैत छथिन। ");
INSERT INTO mai_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ओ एके मनुष्‍य सँ सभ जातिक लोक केँ उत्‍पन्‍न कयलनि, जाहि सँ ओ सभ सौंसे पृथ्‍वी पर रहय। ओ ओकरा सभक रहबाक समय आ स्‍थान पहिनहि सँ निश्‍चित कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ई सभ बात ओ एहि लेल कयलनि जे लोक सभ हुनका ताकय आ शायद हथोड़ि-हथोड़ि कऽ प्राप्‍त करय, ओना तँ ओ अपना सभ मे सँ ककरो सँ दूर नहि छथि। कारण, जेना केओ कहने अछि, ");
INSERT INTO mai_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘हम सभ हुनके मे छी, हुनके मे जीबैत छी आ हुनके मे चल-फिर करैत छी।’ और जेना अहाँ सभक अपन किछु कवि लोकनि कहने छथि, ‘हम सभ हुनकर सन्‍तान छी।’ ");
INSERT INTO mai_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“तेँ अपना सभ जँ परमेश्‍वरक सन्‍तान छी तँ अपना सभ केँ एना नहि सोचबाक चाही जे ईश्‍वर कोनो तरहेँ सोना, चानी, वा पाथरक मूर्ति जकाँ छथि, जे मनुष्‍यक लूरि आ कल्‍पना सँ गढ़ल गेल अछि। ");
INSERT INTO mai_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","एहि अज्ञानताक दण्‍ड केँ परमेश्‍वर बितला युग सभ मे क्षमा कयलनि, मुदा एखन हुनकर आज्ञा छनि जे सभ ठामक सभ मनुष्‍य अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन करय। ");
INSERT INTO mai_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ओ तँ एक दिन निश्‍चित कयने छथि जहिया ओ अपन चुनल व्‍यक्‍ति द्वारा उचित न्‍यायानुसार संसारक न्‍याय करताह। एहि व्‍यक्‍ति केँ मृत्‍यु सँ जिआ कऽ सभ आदमी केँ एहि बातक प्रमाण देने छथि।” ");
INSERT INTO mai_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","मृत्‍यु सँ जीबि उठनाइक बात सुनि कऽ किछु लोक ओहि बातक हँसी उड़ाबऽ लागल, मुदा दोसर लोक सभ कहलकनि, “हम सभ एहि विषय मे अहाँ सँ फेर कहियो सुनऽ चाहैत छी।” ");
INSERT INTO mai_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","तकरबाद पौलुस ओहि सभा मे सँ चल जाइत रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","तैयो किछु लोक हुनका संग-संग आयल आ विश्‍वास कयलक। ओहि मे अरियोपिगुस-सभाक दियुनुसियुस नामक एक सदस्‍य, दमरिस नामक एक स्‍त्री आ किछु आओर लोक सभ छल। ");
INSERT INTO mai_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","तकरबाद पौलुस एथेन्‍स नगर केँ छोड़ि कऽ कोरिन्‍थ नगर गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ओतऽ हुनका अक्‍विला नामक एक यहूदी भेटलनि, जिनकर जन्‍म पुन्‍तुस मे भेल छलनि। ओ हाले-साल मे अपन स्‍त्री प्रिस्‍किलाक संग इटली सँ एतऽ आयल छलाह, कारण क्‍लौदियुस सम्राट यहूदी सभ केँ रोम शहर सँ निकलि जयबाक आदेश दऽ देने छलाह। पौलुस भेँट-घाँट करबाक लेल हुनका सभक ओहिठाम गेलाह, ");
INSERT INTO mai_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","आ हुनका सभक संग रहऽ लगलाह, कारण हिनकर व्‍यवसाय हुनके सभ जकाँ तम्‍बू बनौनाइ छलनि। ओ सभ संग-संग काज करऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","प्रत्‍येक विश्राम-दिन कऽ पौलुस सभाघर मे जा कऽ यहूदी आ यूनानी सभ सँ तर्क-वितर्क कऽ कऽ एहि कोशिश मे रहैत छलाह जे ओ सभ प्रभु यीशु केँ स्‍वीकार करय। ");
INSERT INTO mai_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","सिलास आ तिमुथियुस मकिदुनिया सँ जखन आबि गेलाह, तँ पौलुस अपन पूरा समय शुभ समाचार सुनयबा मे लगा देलनि। ओ यहूदी सभ केँ बुझबैत रहलाह जे यीशुए उद्धारकर्ता-मसीह छथि। ");
INSERT INTO mai_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","मुदा ओ सभ जखन हुनकर विरोध और अपमान करऽ लागल, तखन ओ ओकरा सभक सामने चेतावनी स्‍वरूप अपन कपड़ा मे सँ गर्दा झाड़ि लेलनि, आ कहलनि, “अहाँ सभ जँ नाश होयब तँ तकर दोषी अहीं सभ छी। हम निर्दोष छी। आब सँ हम दोसरे जातिक बीच शुभ समाचार सुनाबऽ जा रहल छी।” ");
INSERT INTO mai_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","तखन पौलुस सभाघर सँ निकलि कऽ तीतुस यूस्‍तुस नामक एक व्‍यक्‍तिक ओहिठाम गेलाह, जिनकर घर सभाघरक काते मे छलनि। ओ यहूदी नहि छलाह मुदा परमेश्‍वरक माननिहार छलाह। ");
INSERT INTO mai_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","सभाघरक अध्‍यक्ष क्रिस्‍पुस अपन सम्‍पूर्ण घर-परिवारक संग प्रभु मे विश्‍वास कयलनि। और बहुतो कोरिन्‍थ निवासी सभ पौलुस सँ शुभ समाचार सुनि विश्‍वास कयलक आ बपतिस्‍मा लेलक। ");
INSERT INTO mai_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","एक राति प्रभु पौलुस केँ सपना मे दर्शन दऽ कऽ कहलथिन, “नहि डेराउ! अहाँ प्रचार करैत रहू, रूकू नहि। ");
INSERT INTO mai_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","कारण, हम अहाँक संग छी। केओ अहाँ पर आक्रमण कऽ कऽ अहाँक हानि नहि कऽ पाओत। किएक तँ एहि शहर मे बहुते गोटे हमर लोक अछि।” ");
INSERT INTO mai_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","तेँ पौलुस लोक सभ केँ परमेश्‍वरक वचन सिखबैत ओतऽ डेढ़ वर्ष धरि रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","जखन गल्‍लियो अखाया प्रदेशक राज्‍यपाल छलाह तँ यहूदी सभ एक मत भऽ पौलुसक विरोध कयलक आ हुनका पकड़ि कऽ कचहरी मे लऽ गेलनि। ");
INSERT INTO mai_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","हुनका पर ओ सभ ई आरोप लगौलक जे, “ई आदमी लोक केँ बहका कऽ परमेश्‍वरक आराधना एहि तरहेँ करबाक लेल सिखबैत अछि जे कानूनक विरोध मे अछि!” ");
INSERT INTO mai_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","एहि पर पौलुस बाजहि चाहलनि कि गल्‍लियो यहूदी सभ केँ कहलथिन, “यौ यहूदी सभ! ई जँ कोनो अन्‍याय वा अपराधक मामिला रहैत तँ अहाँ सभक कथन सुननाइ उचित होइत। ");
INSERT INTO mai_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","मुदा ई खाली अहाँ सभक अपन धर्म-नियमक सम्‍बन्‍धित शब्‍द आ नामक विवाद अछि। तेँ अहीं सभ जानू! हम एहन बातक न्‍याय नहि करब।” ");
INSERT INTO mai_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","और ओ ओकरा सभ केँ कचहरी सँ भगा देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","तखन ओ सभ सभाघरक अध्‍यक्ष सोस्‍थिनेस केँ पकड़ि कऽ कचहरीक ठीक सामने मे पिटलक, मुदा एहि पर गल्‍लियो कनेको ध्‍यान नहि देलनि। ");
INSERT INTO mai_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","कोरिन्‍थ नगर मे बहुत दिन रहलाक बाद पौलुस विश्‍वासी भाय सभ सँ विदा लऽ कऽ पानि जहाज सँ सीरिया प्रदेशक लेल प्रस्‍थान कयलनि। हुनका संग प्रिस्‍किला आ अक्‍विला सेहो छलनि। चलऽ सँ पहिने पौलुस कोनो कबुलाक कारणेँ किंख्रिया शहर मे केश कटबौलनि। ");
INSERT INTO mai_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ओ सभ इफिसुस नगर मे पहुँचलाह, जतऽ पौलुस प्रिस्‍किला आ अक्‍विला केँ छोड़ि देलथिन। ओ अपने ओहिठामक सभाघर मे जा कऽ यहूदी सभ सँ शास्‍त्रार्थ करऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ओ सभ हुनका सँ इफिसुस मे आरो दिन रहबाक आग्रह कयलकनि, मुदा ओ अस्‍वीकार करैत ओकरा सभ केँ कहलथिन, ");
INSERT INTO mai_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","“जँ परमेश्‍वरक इच्‍छा होयतनि तँ हम फेर आयब।” एतबा कहि ओ इफिसुस सँ पानि जहाज सँ विदा भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ओ जखन कैसरिया नगर मे पहुँचलाह तँ ओतऽ सँ यरूशलेम जा कऽ मण्‍डली सँ भेँट कयलनि, आ तकरबाद ⌞सीरिया प्रदेशक⌟ अन्‍ताकिया नगर चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","अन्‍ताकिया मे किछु दिन रूकि कऽ पौलुस ओतऽ सँ फेर बहरयलाह आ क्रमशः गलातिया आ फ्रूगिया प्रदेश मे घूमि-घूमि कऽ शिष्‍य सभ केँ विश्‍वास मे मजगूत करैत रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","एम्‍हर इफिसुस मे, अपुल्‍लोस नामक एक यहूदी जिनकर जन्‍म सिकन्‍दरिया नगर मे भेल छलनि, पहुँचलाह। ओ नीक वक्‍ता आ धर्मशास्‍त्रक पंडित छलाह। ");
INSERT INTO mai_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ओ प्रभुक देखाओल बाटक नीक शिक्षा पौने छलाह, आ यीशुक विषय मे बहुत आत्‍मिक उत्‍साह सँ लोक सभक बीच ठीक-ठीक सुनबैत आ सिखबैत छलाह। मुदा तैयो हुनकर ज्ञान यूहन्‍नाक बपतिस्‍मा तक सीमित छलनि। ");
INSERT INTO mai_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ओ सभाघर मे सेहो निर्भयतापूर्बक बाजऽ लगलाह। प्रिस्‍किला आ अक्‍विला जखन हुनकर बात सुनलनि तँ हुनका अपना ओहिठाम लऽ गेलनि आ आओर बढ़ियाँ सँ परमेश्‍वरक बाटक सम्‍बन्‍ध मे बुझौलथिन। ");
INSERT INTO mai_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","तखन अपुल्‍लोस केँ जखन अखाया जयबाक इच्‍छा भेलनि तँ विश्‍वासी भाय सभ हुनका प्रोत्‍साहित कयलनि, आ हिनकर स्‍वागत करबाक लेल ओहिठामक शिष्‍य सभक नामे एक चिट्ठी लिखि देलथिन। अखाया पहुँचि कऽ ओ ओहि लोक सभ केँ बहुत मदति कयलनि जे परमेश्‍वरक कृपा सँ विश्‍वास मे आबि गेल छल, ");
INSERT INTO mai_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","कारण ओ धर्मशास्‍त्र सँ एहि बात केँ प्रमाणित कऽ कऽ जे यीशुए उद्धारकर्ता-मसीह छथि, सभक सामने मे यहूदी सभक मुँह एकदम बन्‍द कऽ दैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","जखन अपुल्‍लोस कोरिन्‍थ नगर मे छलाह, तखन पौलुस समुद्र सँ दूर वला इलाका सभ दऽ कऽ इफिसुस नगर अयलाह, जतऽ हुनका किछु शिष्‍य सभ भेटलनि। ");
INSERT INTO mai_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ओ ओकरा सभ केँ पुछलथिन, “अहाँ सभ जखन विश्‍वास कयलहुँ तँ की पवित्र आत्‍मा अहाँ सभ केँ प्राप्‍त भेलाह?” ओ सभ उत्तर देलकनि, “नहि। हम सभ तँ से सुननहु नहि छी जे पवित्र आत्‍मा होइत छथि।” ");
INSERT INTO mai_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","पौलुस पुछलथिन, “तँ कोन बात विश्‍वास कऽ कऽ बपतिस्‍मा लेलहुँ?” ओ सभ जबाब देलकनि, “जे बात यूहन्‍ना सिखबैत छलाह।” ");
INSERT INTO mai_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","एहि पर पौलुस ओकरा सभ केँ बुझौलथिन, “यूहन्‍नाक बपतिस्‍मा ई देखयबाक लेल छल जे, पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन कयलहुँ, मुदा यूहन्‍ना लोक सभ केँ इहो सिखबैत छलाह जे, जे हमरा बाद मे आबि रहल छथि, अर्थात् यीशु, तिनका पर विश्‍वास करू।” ");
INSERT INTO mai_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ओ सभ ई बात सुनि यीशुक नाम मे बपतिस्‍मा लेलक। ");
INSERT INTO mai_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","पौलुस ओकरा सभ पर हाथ रखलनि तँ पवित्र आत्‍मा ओकरा सभ मे अयलाह। ओ सभ अनजान भाषा मे बाजऽ लागल आ प्रभु सँ पाओल सम्‍बाद सभ सुनाबऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ओ सभ करीब बारह गोटे छल। ");
INSERT INTO mai_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","तीन मास धरि पौलुस ओतुक्‍का सभाघर मे जा कऽ निर्भयतापूर्बक लोक सभ सँ बात-चीत आ तर्क-वितर्क कऽ कऽ ओकरा सभ केँ परमेश्‍वरक राज्‍यक विषय मे बुझबैत रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","मुदा जखन ओकरा सभ मे सँ किछु लोक जिद्दिया कऽ शुभ समाचार नहि मानलक आ सौंसे सभाक सामने मे प्रभुक बाटक निन्‍दा करऽ लागल, तँ पौलुस ओकरा सभ केँ छोड़ि देलनि आ शिष्‍य सभ केँ अपना संग लऽ कऽ चल अयलाह। आब ओ सभ तुरन्‍नुस नामक व्‍यक्‍तिक भवन मे जा कऽ प्रति दिन तर्क-वितर्क करऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ई क्रम दू वर्ष धरि चलल। फलस्‍वरूप आसिया प्रदेश मे रहऽ वला सभ लोक, यहूदी आ यूनानी दूनू, प्रभुक वचन सुनऽ पौलक। ");
INSERT INTO mai_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","परमेश्‍वर पौलुसक माध्‍यम सँ बहुत अद्‌भुत चमत्‍कार करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","लोक सभ रुमाल आ अंगपोछा हुनका देह मे छुआ कऽ अस्‍वस्‍थ लोक सभ लग लऽ जाइत छल, तँ ओ सभ अपना बिमारी सँ मुक्‍त भऽ जाइत छल आ दुष्‍टात्‍मा सभ ओकरा सभ मे सँ निकलि जाइत छलैक। ");
INSERT INTO mai_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","एहि पर एम्‍हर-ओम्‍हर घुम-फिर करऽ वला किछु यहूदी ओझा-गुनी दुष्‍टात्‍मा सँ ग्रसित लोक सभ पर यीशुक नामक प्रयोग करबाक कोशिश कयलक। ओ सभ दुष्‍टात्‍मा सभ केँ एना कहैत छलैक, “यीशुक नाम सँ, जिनकर प्रचार पौलुस करैत छथि, हम तोरा आज्ञा दैत छिऔ—तोँ एकरा मे सँ निकल!” ");
INSERT INTO mai_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","एहि ओझा-गुनी सभ मे यहूदी सभक एक मुख्‍यपुरोहित, जिनकर नाम स्‍कीवा छलनि, तिनकर सातटा बेटा सेहो छल। ");
INSERT INTO mai_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","एक बेर दुष्‍टात्‍मा ओकरा सभ केँ उत्तर देलकैक, “यीशु केँ हम जनैत छियनि, आ पौलुस केँ चिन्‍हैत छियनि, लेकिन तोँ सभ के छेँ?” ");
INSERT INTO mai_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","तखन ओ दुष्‍टात्‍मा लागल आदमी ओकरा सभ पर झपटि कऽ सभ केँ पछाड़ि देलकैक, आ ततेक मारलकैक-पिटलकैक, जे ओ सभ नंगटे आ घायल भऽ कऽ ओहि घर सँ भागि गेल। ");
INSERT INTO mai_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","एहि घटनाक बारे मे जखन इफिसुसक निवासी, यहूदी आ यूनानी सभ सुनलक, तँ ओकरा सभ केँ बड़का डर सन्‍हिया गेलैक, आ प्रभु यीशुक प्रति आदर बहुत बढ़ि गेलैक। ");
INSERT INTO mai_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","विश्‍वासिओ सभ मे सँ बहुत गोटे आबि कऽ अपन गलत काज सभ खुलि कऽ मानि लेलक, ");
INSERT INTO mai_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","आ बहुत जादू-टोना करऽ वला सभ अपन पोथी सभ जमा कऽ कऽ सभक सामने मे जरा देलक। जखन ओहि सभ पोथीक मूल्‍यांकन कयल गेल तँ ओ पचास हजार चानीक सिक्‍काक छल। ");
INSERT INTO mai_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","एहि तरहेँ प्रभुक वचन आरो पसरैत गेल, और शक्‍ति आ प्रभाव मे बढ़ैत गेल। ");
INSERT INTO mai_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","एहि घटना सभक बाद पौलुस अपना मोन मे मकिदुनिया और अखाया प्रदेश दऽ कऽ यरूशलेम जयबाक निर्णय कऽ लेलनि। ओ कहलनि, “ओतऽ पहुँचलाक बाद हमरा रोम सेहो गेनाइ आवश्‍यक अछि।” ");
INSERT INTO mai_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","तखन ओ अपन दूटा सहकर्मी तिमुथियुस आ इरास्‍तुस केँ आगाँ मकिदुनिया पठा कऽ अपने किछु दिन आओर आसिया प्रदेश मे रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","एही समय मे प्रभुक “बाट” केँ लऽ कऽ इफिसुस शहर मे बड़का खलबली मचि गेल। ");
INSERT INTO mai_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","देमेत्रियुस नामक एक सोनार, जे अरतिमिस देवीक मन्‍दिरक चानीक मुरुत बनबैत छल आ कारीगर सभ केँ सेहो बहुते काज दिअबैत छल, ");
INSERT INTO mai_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","से एक दिन अपन कारीगर सभ आ एहि व्‍यवसाय सँ सम्‍बन्‍धित आरो कारीगर सभ केँ सेहो जमा कऽ कऽ कहलकैक, “यौ भाइ लोकनि! अहाँ सभ केँ बुझले अछि जे अपना सभक सभ धन-सम्‍पत्ति एही व्‍यवसाय सँ अछि। ");
INSERT INTO mai_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","और इहो देखि आ सुनि रहल छी जे ई पौलुस कोना इफिसुसो मे आ करीब-करीब सौंसे आसिया प्रदेश मे बहुतो लोक केँ समझा-बुझा कऽ बहका देने छैक जे, हाथक बनाओल देवता तँ देवता अछिए नहि। ");
INSERT INTO mai_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","एहि सँ एतबे बातक खतरा नहि, जे अपना सभक व्‍यवसायक प्रतिष्‍ठा जाइत रहत, बल्‍कि एकरो जे महान् देवी अरतिमिसक मन्‍दिर तुच्‍छ बुझल जयतनि, और ई देवी जिनकर पूजा आसिया प्रदेश मे आ सौंसे संसार मे सेहो कयल जाइत छनि, तिनकर ईश्‍वरीय गौरव समाप्‍त भऽ जयतनि।” ");
INSERT INTO mai_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ई सुनि ओकरा सभक क्रोध भड़कि उठल और ओ सभ जोर-जोर सँ नारा लगाबऽ लागल जे, “इफिसी सभक अरतिमिस देवी महान्‌ छथि!” ");
INSERT INTO mai_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","आब सौंसे शहर मे हुल्‍लड़ि मचि गेल। लोक सभ गयुस और अरिस्‍तर्खुस, जे मकिदुनिया प्रदेशक छलाह आ पौलुसक संग यात्रा कऽ रहल छलाह, तिनका सभ केँ पकड़ि लेलकनि आ सभ केओ एक जुट भऽ कऽ खेलक मैदान दिस दौड़ि पड़ल। ");
INSERT INTO mai_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","पौलुस भीड़क समक्ष जा कऽ लोक सभ केँ किछु कहऽ चाहैत छलाह, मुदा आरो शिष्‍य सभ हुनका ओतऽ नहि जाय देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","आसियाक किछु उच्‍चाधिकारी सभ, जे पौलुसक मित्र छलनि, सेहो हुनका खबरि पठा कऽ आग्रह कयलथिन जे ओ मैदान मे जयबाक कोशिश नहि करथि। ");
INSERT INTO mai_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","एम्‍हर मैदान मे लोक सभक बीच ततेक गड़बड़ी छल जे ओ सभ हल्‍ला कऽ कऽ केओ किछु कहैत छल, तँ केओ किछु। विशेष लोक इहो नहि जनैत छल जे एतऽ आयल छी किएक। ");
INSERT INTO mai_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","तखन यहूदी सभ सिकन्‍दर केँ ठेलि-ठालि कऽ प्रवक्‍ताक रूप मे सभाक आगाँ ठाढ़ कऽ देलकनि, और भीड़ मे सँ किछु लोक हुनका निर्देश देबऽ लगलनि। ओ भीड़ केँ चुप रहबाक लेल हाथ सँ संकेत कऽ कऽ लोक केँ बुझाबऽ लगलाह, ");
INSERT INTO mai_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","मुदा लोक सभ जखन बुझलक जे ई यहूदी अछि तँ करीब दू घण्‍टा धरि एक स्‍वर मे नारा लगबैत रहल जे, “इफिसी सभक अरतिमिस देवी महान्‌ छथि!” ");
INSERT INTO mai_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","अन्‍त मे शहरक प्रधानजी भीड़ केँ शान्‍त कयलनि आ कहलथिन, “यौ इफिसुस-निवासी सभ! की संसारक प्रत्‍येक मनुष्‍य ई नहि जनैत अछि जे इफिसुस शहर महान् देवी अरतिमिसक मन्‍दिर आ आकाश सँ खसल हुनकर मुरुतक रक्षक अछि? ");
INSERT INTO mai_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ई बात जखन निर्विवाद अछि तँ अहाँ सभ केँ शान्‍त रहबाक चाही आ बिनु सोचने-विचारने किछु नहि करबाक चाही। ");
INSERT INTO mai_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","कारण, अहाँ सभ तँ एहन व्‍यक्‍ति सभ केँ पकड़ि कऽ अनने छी जे ने तँ मन्‍दिर केँ लुटने अछि आ ने अपना सभक देवीक अपमान कयने अछि। ");
INSERT INTO mai_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","तेँ जँ देमेत्रियुस आ हुनकर संगी कारीगर सभ केँ ककरो सँ सिकायत छनि तँ कचहरी खुजल अछि आ न्‍यायाधीश लोकनि सेहो छथि। ओ सभ अपन अभियोग कचहरी मे पेश करथु। ");
INSERT INTO mai_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","और जँ अहाँ सभ कोनो दोसर प्रश्‍न उठाबऽ चाहैत होइ तँ तकर निर्णय नियमित नागरिक-सभा मे कयल जायत। ");
INSERT INTO mai_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","एखन हमरा डर अछि जे अजुका घटनाक कारणेँ कतौ अपना सभ पर दंगाक आरोप ने लगाओल जाय, कारण ई हुल्‍लड़ि बिनु कारणेँ छल, आ एकरा बारे मे अपना सभ कोनो उत्तर नहि दऽ सकब।” ");
INSERT INTO mai_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","एतबा कहि ओ सभा केँ समाप्‍त कऽ देलनि। ");
INSERT INTO mai_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ई खलबली वला बात शान्‍त भेलाक बाद, पौलुस शिष्‍य सभ केँ बजा कऽ हुनका सभ सँ प्रोत्‍साहनक किछु शब्‍द कहि विदा लेलनि आ मकिदुनियाक लेल प्रस्‍थान कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","मकिदुनिया प्रदेश दऽ कऽ जाइत काल ओ ओतुक्‍का विश्‍वासी सभ केँ बहुत बात द्वारा उत्‍साह बढ़ौलनि, और अन्‍त मे यूनान देश मे पहुँचलाह। ");
INSERT INTO mai_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","यूनान मे तीन मास धरि रहलाक बाद, ओ सीरियाक लेल पानि जहाज सँ विदा होमऽ पर छलाह, तखने पता चललनि जे यहूदी सभ हमरा विरोध मे षड्‌यन्‍त्र रचि रहल अछि। तेँ ओ फेर मकिदुनिया दऽ कऽ फिरि जयबाक निश्‍चय कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","हुनका संग ईहो सभ छलाह—पिरुसक बेटा सोपात्रस, जे बिरीयाक निवासी छलाह, थिसलुनिकाक निवासी अरिस्‍तर्खुस आ सिकुन्‍दुस, दरबे नगरक निवासी गयुस, तिमुथियुस, और आसिया प्रदेशक तुखिकुस आ त्रोफिमुस। ");
INSERT INTO mai_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","हुनकर ई संगी सभ हमरा सभ सँ आगाँ बढ़लाह आ त्रोआस नगर जा कऽ हमरा सभक प्रतीक्षा करऽ लगलाह। ");
INSERT INTO mai_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","एम्‍हर हम सभ “बिनु खमीरक रोटी वला पाबनि”क बाद फिलिप्‍पी नगर सँ विदा भेलहुँ, आ पानि जहाजक पाँच दिनक यात्राक बाद हुनका सभ लग त्रोआस मे पहुँचलहुँ। ओतऽ हम सभ सात दिन रहलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","सप्‍ताहक पहिल दिन हम सभ विश्‍वासी सभक संग प्रभु-भोज करबाक लेल एक ठाम जमा भेलहुँ। पौलुस लोक सभ सँ बात-चीत करऽ लगलाह, आ दुपहर राति तक बजैत रहलाह, कारण हुनका प्रात भेने विदा होयबाक छलनि। ");
INSERT INTO mai_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ऊपर वला कोठली जाहि मे हम सभ जमा भेल छलहुँ ताहि मे बहुते दीप सभ जरि रहल छल। ");
INSERT INTO mai_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","खिड़की मे युतखुस नामक एक युवक बैसल छल। पौलुसक बात सुनैत-सुनैत ओ औँघाय लागल आ अन्‍त मे भारी निन्‍द आबि गेला सँ ओ ओहि तीनमहला पर सँ खसि पड़ल। लोक सभ ओकरा मरल उठौलक। ");
INSERT INTO mai_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","पौलुस नीचाँ गेलाह, आ झुकि कऽ ओकरा भरि पाँज कऽ धऽ लेलथिन। तखन बजलाह, “नहि घबड़ाउ! ई जीविते अछि।” ");
INSERT INTO mai_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","तखन पौलुस फेर जा कऽ प्रभु-भोज कयलनि और भोजन कऽ कऽ लोक सभ सँ भोर तक बात-चीत करैत रहलाह आ विदा भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","लोक सभ बहुत खुश भऽ कऽ ओहि युवक केँ जीविते घर लऽ गेल। ");
INSERT INTO mai_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","हम सभ आब जहाज पर चढ़ि कऽ आगाँ असुस नगरक लेल विदा भेलहुँ। पौलुस हमरा सभक लेल एना सोचने छलाह जे हम सभ आगाँ पानि जहाज सँ जाइ आ असुस मे हुनका जहाज पर चढ़ा लियनि, कारण ओ असुस तक पैदले आबऽ चाहैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","असुस मे ओ हमरा सभ सँ भेँट कयलनि, आ हम सभ हुनका जहाज पर लऽ, मितुलेन नगर तक अयलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","दोसरे दिन ओतऽ सँ विदा भऽ खियुस द्वीपक सामने पहुँचलहुँ, आ तकर प्रात भेने सामोस द्वीप तक अयलहुँ। फेर दोसरे दिन मिलेतुस नगर मे अयलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","पौलुस निर्णय कयने छलाह जे हम सभ इफिसुस नगर केँ छोड़ैत निकलि जायब जाहि सँ आसिया प्रदेश मे देरी नहि होअय। ओ एहि लेल जल्‍दी मे छलाह जे, जँ सम्‍भव होअय तँ पेन्‍तेकुस्‍त दिन तक यरूशलेम पहुँचि जाइ। ");
INSERT INTO mai_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","मिलेतुस सँ पौलुस इफिसुसक मण्‍डलीक देख-रेख कयनिहार लोकनि केँ खबरि पठा कऽ बजबौलनि। ");
INSERT INTO mai_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ओ सभ जखन आबि गेलाह तँ पौलुस हुनका सभ केँ कहलथिन, “अहाँ सभ जनिते छी जे जाहि दिन हम आसिया प्रदेश मे अयलहुँ ताहि दिन सँ अहाँ सभक संग रहि कऽ हम अपन समय कोना व्‍यतीत कयने रही। ");
INSERT INTO mai_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","बहुत नम्रतापूर्बक आ नोर बहा-बहा कऽ ओहि संकटक घड़ी मे, जे यहूदी सभक षड्‌यन्‍त्रक कारणेँ हमरा पर आयल छल, हम प्रभुक सेवा करैत रहलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","जे कोनो बात अहाँ सभक हितक लेल छल, से सभ बात अहाँ सभ केँ खुलि कऽ कहलहुँ और सभा सभ मे आ घरो-घर जा-जा कऽ अहाँ सभ केँ उपदेश दैत रहलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","हम यहूदी आ यूनानी दूनू केँ दृढ़तापूर्बक चेतावनी दैत रहलहुँ जे ओ अपना पापक लेल पश्‍चात्ताप कऽ परमेश्‍वरक दिस फिरय आ अपना सभक प्रभु यीशु पर विश्‍वास करय। ");
INSERT INTO mai_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“और आब हम पवित्र आत्‍माक आज्ञाक अनुसार यरूशलेम जा रहल छी। ओतऽ हमरा संग की होयत, से नहि जनैत छी। ");
INSERT INTO mai_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","एतबे जनैत छी जे प्रत्‍येक शहर मे पवित्र आत्‍मा हमरा चेतावनी दऽ रहल छथि जे जहल आ कष्‍ट तोहर प्रतीक्षा मे छह। ");
INSERT INTO mai_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","मुदा हमरा लेल हमर प्राणक कोनो महत्‍व नहि अछि। हमरा एकेटा एही बात सँ मतलब अछि जे हम ओहि दौड़ केँ अन्‍त धरि दौड़ी आ ओहि काज केँ पूरा करी जे प्रभु यीशु हमरा देने छथि। ओ काज अछि परमेश्‍वरक कृपा सम्‍बन्‍धी शुभ समाचारक गवाही देनाइ। ");
INSERT INTO mai_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“हम आब जनैत छी जे अहाँ सभ, जिनका बीच मे हम परमेश्‍वरक राज्‍यक प्रचार करैत घुमलहुँ-फिरलहुँ, हमर मुँह फेर कहियो नहि देखब। ");
INSERT INTO mai_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","तेँ हम आइ अहाँ सभक सामने ई बात गम्‍भीरतापूर्बक कहैत छी जे जँ अहाँ सभ मे सँ केओ नाश होयब तँ तकर उत्तरदायी हम नहि होयब। ");
INSERT INTO mai_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","कारण, हम अहाँ सभ केँ परमेश्‍वरक पूरा योजना सुनाबऽ मे किछु बाँकी नहि रखलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“अहाँ सभ जे सभ मण्‍डलीक जिम्‍मेवार लोक छी, अपन आत्‍मिक जीवनक ध्‍यान राखू आ तकरो सभक जकरा सभ केँ पवित्र आत्‍मा अहाँ सभक जिम्‍मा मे राखि देने छथि। परमेश्‍वरक एहि भेँड़ाक मण्‍डली, जकरा ओ अपन पुत्रक खून सँ किनलनि, तकर अहाँ सभ चरबाह छी। ");
INSERT INTO mai_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","हम जनैत छी जे हमरा चल गेलाक बाद अति खतरनाक जंगली जानबर सभ अहाँ सभक बीच मे आओत आ भेँड़ा सभ केँ नहि छोड़त। ");
INSERT INTO mai_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","अहाँ सभक अपनो बीच सँ एहन लोक ठाढ़ होयत जे विश्‍वासी सभ केँ अपना दिस खीचि अपन चेला बनयबाक लेल सत्‍य केँ टेढ़-मेढ़ कऽ देत। ");
INSERT INTO mai_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","तेँ सतर्क रहू! आ मोन राखू जे कोना हम तीन वर्ष धरि दिन-राति नोर बहा-बहा कऽ अहाँ सभ मे सँ एक-एक गोटे केँ बुझबैत रहलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“और आब हम अहाँ सभ केँ परमेश्‍वरक जिम्‍मा मे छोड़ि रहल छी आ हुनकर कृपापूर्ण वचनक सुरक्षा मे सौंपि दैत छी, जे वचन अहाँ सभ केँ मजगूत बना सकैत अछि आ परमेश्‍वरक सभ पवित्र कयल लोकक संग अहाँ सभक उत्तराधिकार अहाँ सभ केँ दऽ सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","हम ककरो सोना-चानी वा वस्‍त्रक लोभ कहियो नहि कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","अहाँ सभ स्‍वयं जनैत छी जे हम अपन एहि हाथ सभ सँ परिश्रम कऽ कऽ अपन आ अपन संगी सभक आवश्‍यकता पूरा कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","हम अपन सभ काज मे अहाँ सभ केँ देखा देलहुँ जे कोना एहि तरहक परिश्रम कऽ कऽ अपना सभ केँ निर्बल सभक सहयोग करबाक अछि, आ प्रभु यीशुक कहल बात केँ मोन रखबाक अछि जे ओ अपने बाजल छलाह, ‘लेबऽ सँ देबऽ मे आशिष अछि।’ ” ");
INSERT INTO mai_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","एतबा कहि पौलुस सभक संग ठेहुनिया दऽ कऽ प्रार्थना कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","तखन ओ सभ कानि-कानि कऽ आ पंजिया-पंजिया कऽ हुनका चुम्‍मा लेबऽ लगलनि। ");
INSERT INTO mai_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","हुनका सभ केँ सभ सँ बेसी दुःख हुनकर एहि बात सँ भेलनि जे, अहाँ सभ हमर मुँह फेर कहियो नहि देखब। तकरबाद ओ सभ हुनका अरियाति कऽ जहाज तक पहुँचा देलनि। ");
INSERT INTO mai_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","हुनका सभ सँ विदा लऽ कऽ हम सभ जहाज मे चढ़लहुँ आ सोझे-सोझ जा कऽ कोस द्वीप पर पहुँचलहुँ। प्रात भेने रूदुस द्वीप तक अयलहुँ आ ओतऽ सँ पतारा नगर। ");
INSERT INTO mai_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","पतारा मे हमरा सभ केँ फीनिकी प्रदेश जाय वला एक जहाज भेटल, जाहि पर चढ़ि हम सभ फेर विदा भऽ गेलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","जाइत-जाइत हमरा सभ केँ साइप्रस द्वीप देखाइ देलक। ओकर दक्षिण भाग सँ होइत हम सभ आगाँ सीरिया प्रदेश दिस बढ़लहुँ। हम सभ सीरिया प्रदेशक सूर नगर मे उतरलहुँ, कारण ओतऽ जहाज केँ अपन माल उतारबाक छलैक। ");
INSERT INTO mai_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","सूर मे हम सभ प्रभुक शिष्‍य सभ केँ ताकि कऽ हुनका सभक संग सात दिन धरि रहलहुँ। पवित्र आत्‍माक प्रेरणा सँ बुझि ओ सभ पौलुस केँ बेर-बेर कहलथिन जे, “अहाँ यरूशलेम नहि जाउ!” ");
INSERT INTO mai_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","मुदा ओतऽ रहबाक समय जखन पूरा भऽ गेल तँ हम सभ विदा लऽ कऽ अपना रस्‍ता पर आगाँ बढ़लहुँ। सभ शिष्‍य अपन स्‍त्री-बच्‍चा सभक संग हमरा सभ केँ नगरक बाहर तक अरियातऽ अयलाह। ओतऽ समुद्रक कछेर पर हम सभ ठेहुनिया दऽ कऽ प्रार्थना कयलहुँ, ");
INSERT INTO mai_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","आ एक-दोसर सँ विदा लेलहुँ। तखन हम सभ जहाज मे चढ़लहुँ और ओ सभ घर घूमि गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","सूर सँ आगाँ बढ़ि हम सभ तुलमाइस नगर तक पहुँचलहुँ, जतऽ उतरि कऽ विश्‍वासी भाय सभ सँ भेँट कयलहुँ आ हुनका सभक संग एक दिन रहलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","प्रात भेने हम सभ विदा भऽ गेलहुँ आ कैसरिया नगर मे पहुँचि सुसमाचार-प्रचारक फिलिपुसक ओहिठाम जा कऽ रहलहुँ। ओ “सात सेवक” मे सँ एक छलाह। ");
INSERT INTO mai_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","हुनका चारिटा कुमारि कन्‍या छलनि, जे परमेश्‍वरक प्रवक्‍तिनि छलीह। ");
INSERT INTO mai_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","हमरा सभ केँ ओतऽ रहैत किछु दिन बितलाक बाद अगबुस नामक परमेश्‍वरक प्रवक्‍ता यहूदिया सँ कैसरिया अयलाह। ");
INSERT INTO mai_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ओ हमरा सभ सँ भेँट कयलनि, आ पौलुसक डाँड़ बान्‍हऽ वला गमछा लऽ कऽ अपन हाथ-पयर बान्‍हि लेलनि आ कहलनि, “पवित्र आत्‍मा कहैत छथि जे, जिनकर ई गमछा छनि, से एही तरहेँ यरूशलेम मे यहूदी सभक द्वारा बान्‍हल जयताह आ गैर-यहूदीक हाथ मे सौंपल जयताह।” ");
INSERT INTO mai_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ई बात जखन सुनलहुँ तँ हम सभ और ओहिठामक लोक सभ पौलुस सँ बेर-बेर विनती कयलहुँ जे ओ यरूशलेम नहि जाथि। ");
INSERT INTO mai_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","मुदा पौलुस उत्तर देलनि, “अहाँ सभ ई की कऽ रहल छी? एना कानि-कानि कऽ हमरा मोन केँ किएक दुखी कऽ रहल छी? हम तँ प्रभु यीशुक कारणेँ यरूशलेम मे बन्‍हयबेक लेल नहि, बल्‍कि मरबोक लेल तैयार छी।” ");
INSERT INTO mai_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","हम सभ हुनका जखन नहि मना सकलियनि तँ ई कहि कऽ बात छोड़ि देलहुँ जे, “प्रभुक इच्‍छा पूरा होनि।” ");
INSERT INTO mai_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","तकरबाद हम सभ अपन सामान तैयार कऽ यरूशलेमक लेल विदा भऽ गेलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","कैसरियाक किछु विश्‍वासी सभ सेहो हमरा सभक संग अयलाह, और हमरा सभ केँ साइप्रस-निवासी मनासोन नामक एक पुरान शिष्‍यक घर मे लऽ गेलाह, जतऽ हमरा सभ केँ रहबाक छल। ");
INSERT INTO mai_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","यरूशलेम मे जखन पहुँचलहुँ तँ विश्‍वासी भाय सभ बहुत आनन्‍दक संग हमरा सभक स्‍वागत कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","प्रात भेने पौलुस हमरा सभक संग याकूबक ओहिठाम गेलाह। मण्‍डलीक सभ देख-रेख कयनिहार लोकनि ओतऽ जमा छलाह। ");
INSERT INTO mai_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","पौलुस हुनका सभ केँ नमस्‍कार कऽ कऽ, ओ सभ काजक विषय मे एक-एकटा कऽ सुना देलथिन जे परमेश्‍वर हुनकर सेवा-काजक द्वारा गैर-यहूदी सभक बीच कयने छलाह। ");
INSERT INTO mai_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","पौलुसक बात सुनि ओ सभ परमेश्‍वरक स्‍तुति कयलनि। तखन पौलुस केँ कहलथिन, “यौ पौलुस भाइ, अहाँ तँ देखिते छी जे यहूदी सभ मे सँ हजारो-हजार लोक प्रभु यीशु पर विश्‍वास कऽ लेने अछि, आ सभ मूसाक धर्म-नियमक कट्टर समर्थक अछि। ");
INSERT INTO mai_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","अहाँक बारे मे ओकरा सभ केँ कहल गेल छैक जे अहाँ गैर-यहूदी लोकक बीच मे रहनिहार यहूदी सभ केँ सिखबैत छी जे मूसाक धर्म-नियम केँ छोड़ू, अपना बच्‍चा सभ केँ खतना नहि कराउ और पूर्वजक अन्‍य प्रथा सभ केँ नहि मानू। ");
INSERT INTO mai_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","आब की कयल जाय? ओ सभ अवश्‍य सुनत जे अहाँ आबि गेल छी। ");
INSERT INTO mai_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","तेँ अहाँ एकटा काज करू। एतऽ हमरा सभक संग चारि गोटे छथि जे कबुला कयने छथि। ");
INSERT INTO mai_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","हुनका सभ केँ लऽ जाउ और अहूँ हुनका सभक संग रीतिक अनुसार अपना केँ शुद्ध करू। हुनका सभ केँ एहि सभक खर्च दियौन, तखन ओ सभ अपन केशो कटबा सकताह। एहि तरहेँ सभ केँ पता लगतैक जे जतेक बात अहाँक बारे मे सुनने छल, से सभ फूसि अछि, और अहाँ अपने, धर्म-नियमक पालन करैत छी। ");
INSERT INTO mai_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","रहल गैर-यहूदी सभक विषय मे जे प्रभु पर विश्‍वास कऽ लेने छथि, तँ हुनका सभ केँ हम सभ अपन निर्णय लिखि पठा देने छियनि जे ओ सभ एहि बात सभ सँ बाँचल रहथु—मूर्ति पर चढ़ाओल खयबाक वस्‍तु सँ, खूनक खान-पान सँ, कण्‍ठ दबा कऽ मारल ⌞अर्थात् बिनु खून बहौने मारल⌟ पशुक माँसु सँ आ अनैतिक शारीरिक सम्‍बन्‍ध सँ।” ");
INSERT INTO mai_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","प्रात भेने पौलुस ओहि चारि गोटे केँ अपना संग लऽ जा कऽ हुनका सभक संग अपना केँ शुद्ध कयलनि। तखन शुद्धीकरणक सात दिन कहिया पुरि जायत, और हुनका सभ मे सँ प्रत्‍येकक लेल बलि-प्रदान कयल जायत, तकर जानकारी पुरोहित केँ देबाक लेल मन्‍दिर मे गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","शुद्धीकरणक सात दिन जखन पूरा होमऽ पर छल तँ आसिया प्रदेशक किछु यहूदी सभ पौलुस केँ मन्‍दिर मे देखलकनि। ओ सभ समस्‍त भीड़ केँ भड़का कऽ हुनका पकड़ि लेलकनि ");
INSERT INTO mai_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","आ हल्‍ला करऽ लागल, “इस्राएली बाबू-भैया सभ, मदति करू! ई वैह अछि जे सभतरि अपना सभक यहूदी जाति, मूसाक धर्म-नियम आ एहि मन्‍दिरक विरोध मे सभ केँ सिखबैत अछि। एतबे नहि। आब ओ यूनानिओ सभ केँ मन्‍दिर मे लाबि एहि पवित्र स्‍थान केँ अपवित्र कऽ देलक अछि!” ");
INSERT INTO mai_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ई बात ओ सभ एहि लेल कहलक जे शहर मे पौलुसक संग इफिसुस-निवासी त्रोफिमुस केँ देखने छलैक, आ तेँ बुझलक जे पौलुस ओकरा मन्‍दिरो मे लऽ गेल होयतैक। ");
INSERT INTO mai_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ई सुनि सौंसे शहरक लोकक खून खौलऽ लगलैक। सभ दिस सँ लोक सभ दौड़ैत आयल, आ पौलुस केँ पकड़ि कऽ मन्‍दिर सँ घिसिअबैत बाहर अनलकनि। मन्‍दिरक द्वारि तुरत बन्‍द कऽ देल गेल। ");
INSERT INTO mai_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ओ सभ पौलुस केँ जान सँ मारि देबाक कोशिश मे छल, मुदा तखने रोमी सैन्‍यदलक सेनापति लग ई खबरि पहुँचल जे सौंसे यरूशलेम मे उपद्रव मचि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ओ तुरत किछु सेनानायक आ सैनिक सभ केँ लऽ कऽ भीड़क दिस दौड़ि पड़लाह। लोक सभ जखन सेनापति आ हुनकर सैनिक सभ केँ देखलकनि तँ पौलुस केँ पिटनाइ छोड़ि देलक। ");
INSERT INTO mai_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","सेनापति पौलुस लग आबि कऽ हुनका बन्‍दी बना लेलनि, आ हुनका दू जिंजीर लऽ कऽ बन्‍हबाक आदेश देलनि। तखन लोक सभ केँ पुछलथिन, “ई के अछि आ की कयने अछि?” ");
INSERT INTO mai_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","भीड़क लोक सभ उत्तर मे केओ किछु बाजि कऽ तँ केओ किछु बाजि कऽ हल्‍ला करऽ लागल। हल्‍लाक कारणेँ सेनापति कोनो बातक पता नहि लगा सकलाह, तेँ आज्ञा देलनि जे पौलुस केँ गढ़ मे लऽ गेल जाय। ");
INSERT INTO mai_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","पौलुस जखन गढ़क सीढ़ी लग पहुँचलाह तँ भीड़ ततेक हिंसक भऽ गेल छल जे सैनिक सभ केँ पौलुस केँ उठा कऽ लऽ जाय पड़लैक। ");
INSERT INTO mai_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","भीड़ पाछाँ-पाछाँ अबैत हल्‍ला करैत रहल जे, “ओकरा खतम करू!” ");
INSERT INTO mai_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","सैनिक सभ जखन पौलुस केँ गढ़क भीतर लऽ जाय लागल तँ पौलुस सेनापति केँ कहलथिन, “अपने जँ आज्ञा दी तँ हम अपने सँ किछु बात करी।” ओ उत्तर देलनि, “तखन तोँ यूनानी भाषा जनैत छह? ");
INSERT INTO mai_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","की तोँ ओ मिस्र-निवासी नहि छह जे हाल मे विद्रोह करबा कऽ चारि हजार उग्रवादी केँ निर्जन प्रदेश मे लऽ गेल छल?” ");
INSERT INTO mai_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पौलुस उत्तर देलथिन, “हम यहूदी छी, किलिकिया प्रदेशक प्रसिद्ध महानगर तरसुसक नागरिक। अपने सँ निवेदन अछि जे एहि लोक सभ केँ हम किछु कही तकरा लेल हमरा हुकुम देल जाओ।” ");
INSERT INTO mai_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","सेनापतिक आज्ञा पाबि, पौलुस सीढ़ी पर ठाढ़ भऽ कऽ भीड़क लोक केँ शान्‍त रहबाक लेल हाथ सँ संकेत कयलनि। लोक सभ जखन शान्‍त भऽ गेल तँ ओ ओकरा सभ केँ इब्रानी भाषा मे कहऽ लगलथिन, ");
INSERT INTO mai_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“बाबू-भैया लोकनि, हम अपना बारे मे जे कहऽ चाहैत छी से सुनू।” ");
INSERT INTO mai_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","लोक सभ जखन अपना इब्रानी भाषा मे हुनका बजैत सुनलक तँ आरो शान्‍त भऽ गेल। पौलुस आगाँ कहऽ लगलथिन, ");
INSERT INTO mai_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“हम यहूदी छी। किलिकिया प्रदेशक तरसुस नगर मे हमर जन्‍म भेल, मुदा हमर पालन-पोषण एहि यरूशलेम शहर मे भेल। एतऽ आचार्य गमालिएलक चरण मे हमर शिक्षा-दीक्षा भेल। अपना सभक पूर्वजक धर्म-नियम सभ निष्‍ठापूर्बक पालन करबाक लेल हमरा विस्‍तारपूर्बक सिखाओल गेल, और हम परमेश्‍वरक लेल एहन उत्‍साह सँ समर्पित छलहुँ जेना अहाँ सभ आइ छी। ");
INSERT INTO mai_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","एहि ‘बाट’ पर विश्‍वास कयनिहार सभ केँ सता कऽ हम मारिओ दैत छलहुँ—पुरुष आ स्‍त्रीगण दूनू केँ बान्‍हि-बान्‍हि कऽ जहल मे रखबा दैत छलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","एहि बातक गवाह महापुरोहित अपने आ धर्मसभाक सदस्‍य सभ छथि। ओ सभ दमिश्‍कक यहूदी भाय सभक नामे हमरा पत्रो देलनि जाहि सँ हम दमिश्‍क जा कऽ विश्‍वासी सभ केँ बन्‍दी बना कऽ यरूशलेम आनि दण्‍ड दिआ सकी। ");
INSERT INTO mai_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“ओतऽ जाइत-जाइत करीब दुपहरक समय मे जखन हम दमिश्‍क केँ लगचिआ लेने छलहुँ तँ एकाएक आकाश सँ एकटा बहुत तेज इजोत हमरा चारू कात पड़ल। ");
INSERT INTO mai_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","हम जमीन पर खसि पड़लहुँ, आ एकटा आवाज हमरा ई कहैत सुनाइ देलक, ‘हौ साउल, हौ साउल, तोँ हमरा किएक सतबैत छह?’ हम पुछलियनि, ");
INSERT INTO mai_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","‘यौ प्रभु, अहाँ के छी?’ ओ उत्तर देलनि, ‘हम नासरतक यीशु छी, जिनका तोँ सता रहल छह।’ ");
INSERT INTO mai_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","हमर संगी सभ इजोत देखलनि, मुदा जे हमरा सँ बात कऽ रहल छलाह, तिनकर आवाजक अर्थ नहि बुझलनि। ");
INSERT INTO mai_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“हम पुछलियनि, ‘आब हम की करू, प्रभु?’ प्रभु उत्तर देलनि, ‘तोँ उठि कऽ दमिश्‍क जाह। ओतऽ तोरा कहल जयतह जे तोरा करबाक लेल परमेश्‍वर की निश्‍चित कयने छथुन।’ ");
INSERT INTO mai_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ओहि बड़का इजोतक कारणेँ हमर आँखि अन्‍हरा गेल छल, आ तेँ हमर संगी सभ हाथ पकड़ि कऽ हमरा दमिश्‍क मे लऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“हननियाह नामक एक आदमी हमरा सँ भेँट करबाक लेल अयलाह। ओ धर्म-नियम केँ भक्‍तिपूर्बक पालन करऽ वला छलाह, आ दमिश्‍कक सभ यहूदीक बीच प्रतिष्‍ठित मानल जाइत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ओ हमरा लग मे ठाढ़ भऽ कऽ कहलनि, ‘भाइ साउल, आब अहाँ फेर सँ देखऽ लागू!’ ओही क्षण हमरा फेर सुझऽ लागल आ हम हुनका देखलियनि। ");
INSERT INTO mai_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“तखन ओ हमरा कहलनि, ‘अपना सभक पूर्वजक परमेश्‍वर अहाँ केँ पहिनहि सँ एहि लेल चुनने छथि जे अहाँ हुनकर इच्‍छा केँ जानी, हुनकर धार्मिक सेवक केँ देखी आ हुनकर अपन मुँहक बात सुनी। ");
INSERT INTO mai_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","सभ मनुष्‍यक सामने अहाँ ओहि बातक गवाह होयब जे देखने आ सुनने छी। ");
INSERT INTO mai_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","आब आओर विलम्‍ब किएक? उठू, और प्रभु यीशु सँ विनती कऽ कऽ बपतिस्‍मा लिअ आ अपन पाप धो लिअ।’ ");
INSERT INTO mai_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“हम यरूशलेम घुरि अयलहुँ। एक दिन मन्‍दिर मे प्रार्थना करैत काल हम प्रभुक दर्शन पौलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","हम देखलहुँ जे प्रभु हमरा कहि रहल छथि जे, ‘जल्‍दी करह! यरूशलेम केँ तुरत छोड़ह, कारण लोक सभ हमरा बारे मे तोहर गवाही स्‍वीकार नहि करतह।’ ");
INSERT INTO mai_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","हम हुनका उत्तर देलियनि, ‘मुदा प्रभुजी, ओ सभ जनैत अछि जे हम सभाघर सभ मे जा-जा कऽ अहाँक विश्‍वासी सभ केँ पकड़ि कऽ पिटैत छलहुँ आ जहल मे रखैत छलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","और अहाँक गवाह स्‍तिफनुसक जखन हत्‍या भऽ रहल छल तँ हम अपने ओतऽ ठाढ़ छलहुँ आ हुनकर हत्‍या सँ सहमत छलहुँ। हत्‍यारा सभक वस्‍त्रक रखबारिओ कयलहुँ।’ ");
INSERT INTO mai_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","तखन प्रभु हमरा कहलनि, ‘तोँ जाह। हम तोरा दूर-दूर तक गैर-यहूदी सभक बीच पठयबह।’ ” ");
INSERT INTO mai_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","एतऽ तक लोक सभ पौलुसक बात सुनैत रहल, मुदा आब ई बात सुनिते जे “हम तोरा गैर-यहूदी सभक बीच पठयबह,” ओ सभ जोर-जोर सँ हल्‍ला करऽ लागल, “एकरा खतम कऽ दिअ! पृथ्‍वी पर सँ एकर नामो-निशान मेटा दिअ! ई जीवित रहऽ जोगरक नहि अछि!” ");
INSERT INTO mai_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","हल्‍ला करैत ओ सभ अपन कपड़ा हवा मे फेकि रहल छल और आकाश दिस गर्दा उड़ा रहल छल। ");
INSERT INTO mai_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","तँ सेनापति आदेश देलनि जे, एकरा गढ़ मे लऽ जाह, आ चाबुक सँ पिटि कऽ एकरा सँ पूछ-ताछ करहक जाहि सँ हम बुझि सकब जे लोक सभ एकरा विरोध मे एना किएक हल्‍ला कऽ रहल छैक। ");
INSERT INTO mai_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ओ सभ पौलुस केँ जखन पिटबाक लेल बान्‍हि लेने छल तँ पौलुस कप्‍तान, जे लग मे ठाढ़ छलाह, तिनका सँ पुछलथिन, “की कानूनक अनुसार ई बात ठीक अछि जे कोनो रोमी नागरिक केँ पिटब, आ ताहू मे, तकरा जे कोनो अपराधक दोषी नहि ठहराओल गेल होअय?” ");
INSERT INTO mai_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","कप्‍तान ई सुनि सेनापति लग जा कऽ कहलथिन, “अपने ई की कऽ रहल छी? ई आदमी तँ रोमी नागरिक अछि!” ");
INSERT INTO mai_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","सेनापति पौलुस लग अयलाह आ पुछलथिन, “कहह! की तोँ रोमी नागरिक छह?” ओ उत्तर देलथिन, “हँ।” ");
INSERT INTO mai_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","तखन सेनापति कहलथिन, “हमरा तँ अपन नागरिकता प्राप्‍त करऽ मे बहुत पाइ खर्च करऽ पड़ल।” पौलुस उत्तर देलथिन, “मुदा हम तँ जन्‍मे सँ नागरिक छी।” ");
INSERT INTO mai_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","तखन ओ सभ जे हुनका सँ पूछ-ताछ करितनि, से सभ तुरत पौलुस केँ छोड़ि कऽ ओतऽ सँ हटि गेल। सेनापति ई बुझि अपनो भयभीत छलाह, जे हम एक रोमी नागरिक केँ जिंजीर सँ बन्‍हबौने छी। ");
INSERT INTO mai_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","प्रात भेने एहि बातक ठीक सँ पता लगयबाक लेल जे यहूदी सभ पौलुस पर किएक अभियोग लगा रहल अछि, सेनापति हुनकर बन्‍हन खोलि देलनि और आदेश देलनि जे मुख्‍यपुरोहित सभ आ सम्‍पूर्ण धर्म-महासभा जमा होअय। धर्म-महासभा जमा भेला पर हुनका सभक सामने पौलुस केँ ठाढ़ कऽ देलनि। ");
INSERT INTO mai_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पौलुस धर्म-महासभाक दिस एकटक लगा कऽ देखलनि आ बजलाह, “भाइ लोकनि, हम जाहि तरहेँ आजुक दिन धरि अपन जीवन व्‍यतीत कयने छी, ताहि सम्‍बन्‍ध मे हम अपना केँ परमेश्‍वरक नजरि मे निर्दोष बुझैत छी।” ");
INSERT INTO mai_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","एहि पर महापुरोहित हननियाह पौलुसक लग मे ठाढ़ लोक सभ केँ आदेश देलथिन जे, मारू ओकरा मुँह पर थप्‍पड़। ");
INSERT INTO mai_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","तखन पौलुस हुनका कहलथिन, “यौ चुनक-पोतल देवाल, परमेश्‍वर अहीं केँ मारताह! अहाँ धर्म-नियमक अनुसार हमर न्‍याय करबाक लेल एतऽ बैसल छी, और अहाँ अपने धर्म-नियमक विरोध मे हमरा मारबाक लेल आज्ञा दैत छिऐक!” ");
INSERT INTO mai_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","पौलुसक लग ठाढ़ लोक सभ हुनका कहलकनि, “की अहाँ परमेश्‍वरक ठहराओल महापुरोहित केँ अपमानित करैत छियनि?” ");
INSERT INTO mai_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पौलुस उत्तर देलथिन, “भाइ लोकनि, हमरा नहि बुझल छल जे ई महापुरोहित छथि। धर्मशास्‍त्रक लेख अछि, ‘तोँ अपन समाजक शासक केँ अपशब्‍द नहि कहबह।’” ");
INSERT INTO mai_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","पौलुस जनैत छलाह जे उपस्‍थित लोक सभ मे सदुकी आ फरिसी दूनू पंथक लोक अछि, आ तेँ ओ सभा मे बाजऽ लगलाह, “भाइ लोकनि, हम फरिसी छी, आ फरिसीक पुत्र छी। हमर न्‍याय एखन एहि लेल कयल जा रहल अछि जे हमर विश्‍वासपूर्ण आशा अछि जे मुइल सभ फेर जिआओल जायत।” ");
INSERT INTO mai_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","हुनकर ई बात सुनिते, फरिसी आ सदुकी सभ अपने मे झगड़ा करऽ लगलाह, आ सभा मे फूट पड़ि गेल। ");
INSERT INTO mai_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","कारण, सदुकी सभक कथन अछि जे मुइल सभ नहि जिआओल जायत, और ने स्‍वर्गदूत अछि आ ने कोनो तरहक आत्‍मा होइत अछि, मुदा फरिसी सभ एहि तीनू बात केँ मानैत अछि। ");
INSERT INTO mai_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","तँ एहि तरहेँ बड़का हल्‍ला मचि गेल। फरिसी पंथक किछु धर्मशिक्षक सभ उठि बहुत जोर दऽ कऽ कहऽ लगलाह, “हम सभ एहि व्‍यक्‍ति मे कोनो खराबी नहि देखैत छी। आ मानि लिअ जे एकरा सँ कोनो स्‍वर्गदूत वा आत्‍मा बात कयने होथि, तखन?” ");
INSERT INTO mai_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ई झगड़ा ततेक ने बढ़ि गेल जे सेनापति केँ डर होमऽ लगलनि जे, कतौ ई सभ पौलुस केँ टुकड़ा-टुकड़ा नहि कऽ दैक। तेँ ओ सैनिक सभ केँ आज्ञा देलथिन जे सभा मे जा कऽ ओकरा जबरदस्‍ती छोड़ाबह आ गढ़ मे लऽ आनह। ");
INSERT INTO mai_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ओही राति प्रभु पौलुसक लग मे ठाढ़ भऽ कऽ कहलथिन, “साहस राखह! जहिना तोँ यरूशलेम मे हमरा विषय मे गवाही देलह, तहिना रोम मे सेहो तोरा गवाही देबाक छह।” ");
INSERT INTO mai_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","भोर भेला पर यहूदी सभ षड्‌यन्‍त्र रचलक आ सपत खयलक जे, जा धरि पौलुस केँ जान सँ नहि मारि देब, ता धरि किछु नहि खायब-पीब। ");
INSERT INTO mai_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ई षड्‌यन्‍त्र रचनिहार सभ चालिस सँ बेसी गोटे छल। ");
INSERT INTO mai_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ओ सभ मुख्‍यपुरोहित सभ आ बूढ़-प्रतिष्‍ठित लोकनि लग जा कऽ कहलकनि, “हम सभ भारी सपत खयलहुँ जे, जा धरि पौलुस केँ मारि नहि देब, ता धरि किछु नहि खायब-पीब। ");
INSERT INTO mai_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","तेँ अहाँ सभ धर्म-महासभाक संग मिलि कऽ सेनापति सँ निवेदन करू जे ओ पौलुस केँ एम्‍हर लऽ अबथि, एहि बहाना सँ जे हम सभ ओकर आरो ठीक सँ जाँच करऽ चाहैत छी। और हम सभ जे छी, से ओकरा एतऽ पहुँचऽ सँ पहिनहि ओकरा मारि देबाक लेल तैयार रहब।” ");
INSERT INTO mai_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","मुदा पौलुसक भागिन एहि षड्‌यन्‍त्रक बारे मे सुनि लेलक। ओ तुरत्ते गढ़ मे जा कऽ पौलुस केँ ई बात कहि देलकनि। ");
INSERT INTO mai_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","तखन पौलुस एक कप्‍तान केँ बजा कऽ कहलथिन, “एकरा सेनापति लग लऽ जाउ, ई हुनका किछु कहऽ चाहैत अछि।” ");
INSERT INTO mai_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","तँ कप्‍तान ओकरा सेनापति लग लऽ जा कऽ कहलथिन, “बन्‍दी पौलुस हमरा बजा कऽ कहलक जे हम एहि लड़का केँ अपनेक लग लऽ जाइ, कारण एकरा अपने सँ किछु कहबाक छैक।” ");
INSERT INTO mai_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","सेनापति ओहि लड़का केँ हाथ पकड़ि कऽ एकान्‍त मे लऽ गेलाह आ पुछलथिन, “तोँ हमरा कोन बात कहऽ चाहैत छह?” ");
INSERT INTO mai_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ओ उत्तर देलकनि, “यहूदी सभ नियारने अछि जे पौलुस केँ काल्‍हिखन धर्म-महासभाक सामने अनबाक लेल अपने सँ निवेदन करी, एहि बहाना सँ जे, हम सभ ओकर आरो ठीक सँ जाँच करऽ चाहैत छी। ");
INSERT INTO mai_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","मुदा ओकर सभक निवेदन अपने स्‍वीकार नहि करब, कारण, ओकरा सभ मे सँ चालिस सँ बेसी लोक हुनकर घात करबाक ताक मे अछि। ओ सभ ई सपत खयने अछि जे, जा धरि पौलुस केँ जान सँ नहि मारि देब, ता धरि किछु नहि खायब-पीब। एखनो ओ सभ तैयार अछि, खाली अपनेक आज्ञाक प्रतीक्षा कऽ रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","सेनापति युवक केँ ई कहि कऽ विदा कऽ देलथिन जे, “ककरो नहि बुझऽ दहक जे तोँ हमरा एहि बातक खबरि देलह।” ");
INSERT INTO mai_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","तखन सेनापति दूटा कप्‍तान केँ बजा कऽ आज्ञा देलथिन, “अहाँ सभ दू सय पैदल-सैनिक, सत्तरि घोड़सवार आ दू सय भालाधारी सैनिक केँ आइ नौ बजे राति तक कैसरिया विदा होयबाक लेल तैयार करू, ");
INSERT INTO mai_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","और पौलुसक लेल सेहो घोड़ाक व्‍यवस्‍था करू, जाहि सँ ओ सभ ओकरा सुरक्षित राज्‍यपाल फेलिक्‍स लग पहुँचाबय।” ");
INSERT INTO mai_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ओ राज्‍यपालक लेल ई पत्र लिखलनि— ");
INSERT INTO mai_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","परम श्रेष्‍ठ राज्‍यपाल फेलिक्‍स केँ क्‍लौदियुस लुसियासक दिस सँ सादर प्रणाम। ");
INSERT INTO mai_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","एहि आदमी केँ यहूदी सभ पकड़ने छल, और एकर खून करऽ पर लागल छल, मुदा तखने हम सैनिक सभक संग ओतऽ पहुँचि एकरा छोड़ौलहुँ, कारण हमरा पता लागल छल जे ई रोमी नागरिक अछि। ");
INSERT INTO mai_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","हम जानऽ चाहैत छलहुँ जे ओ सभ एकरा विरोध मे की आरोप लगा रहल अछि, तेँ ओकरा सभक धर्म-महासभाक सामने एकरा उपस्‍थित करौलिऐक। ");
INSERT INTO mai_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ओतऽ हमरा बुझऽ मे आयल जे ओकरा सभक अपन धर्म सँ सम्‍बन्‍धित जे विवादक बात सभ अछि ताहि विषय मे एकरा पर आरोप लगाओल जा रहल अछि, नहि कि कोनो एहन बातक विषय मे जाहि लेल एकरा मृत्‍युदण्‍ड देल जाय वा जहलो मे राखल जाय। ");
INSERT INTO mai_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","आब हमरा पता लागल जे एकर हत्‍याक लेल षड्‌यन्‍त्र रचल गेल अछि। तेँ एकरा अपनेक ओहिठाम तुरत पठयबाक निर्णय कयलहुँ। और एकरा पर जे सभ आरोप लगा रहल अछि, तकरा सभ केँ हम सेहो आदेश देने छिऐक जे ओ सभ अपन आरोप अपनेक समक्ष प्रस्‍तुत करय। ");
INSERT INTO mai_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","सैनिक सभ सेनापतिक आदेशक अनुसार पौलुस केँ राता-राती लऽ गेलनि और अन्‍तिपत्रिस नगर तक पहुँचा देलकनि। ");
INSERT INTO mai_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","प्रात भेने ओ सभ घोड़सवार सैनिक सभ केँ पौलुस केँ आगाँ लऽ जयबाक लेल छोड़ि देलक आ ओ सभ स्‍वयं गढ़ पर घुरि गेल। ");
INSERT INTO mai_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","कैसरिया मे पहुँचला पर घोड़सवार सैनिक सभ राज्‍यपाल केँ पत्र देलकनि आ पौलुस केँ हुनका जिम्‍मा मे लगा देलकनि। ");
INSERT INTO mai_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","पत्र पढ़लाक बाद राज्‍यपाल पौलुस सँ पुछलथिन, “अहाँ कोन प्रदेशक छी?” पौलुसक ई उत्तर सुनि जे, हम किलिकिया प्रदेशक छी, ");
INSERT INTO mai_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","राज्‍यपाल कहलथिन, “अहाँ पर आरोप लगौनिहार सभ जखन एतऽ आबि जायत, तखन हम अहाँक मोकदमा सुनब।” तखन ओ आदेश देलनि जे पौलुस केँ हेरोद-दरबार मे पहरा मे राखल जाय। ");
INSERT INTO mai_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पाँच दिनक बाद महापुरोहित हननियाह किछु धार्मिक अगुआ सभ और तरतुल्‍लुस नामक एक वकीलक संग कैसरिया अयलाह, आ राज्‍यपाल फेलिक्‍सक समक्ष पौलुसक विरोध मे अपन आरोप प्रस्‍तुत कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","पौलुस केँ बजाओल गेलनि, आ तरतुल्‍लुस एहि प्रकारेँ हुनका पर आरोप लगबैत राज्‍यपाल केँ कहऽ लगलनि, “परम श्रेष्‍ठ राज्‍यपाल जी, हमरा लोकनिक बीच जे ई निरन्‍तर शान्‍ति रहैत अछि से अपनेक कृपाक कारणेँ अछि। अपनेक बुद्धिमत्तापूर्ण शासनक फलस्‍वरूप एहि देश मे बहुतो समाजिक सुधार भऽ गेल अछि। ");
INSERT INTO mai_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ई सभ बात हमरा लोकनि सभ तरहेँ आ सभतरि हार्दिक धन्‍यवादक संग स्‍वीकार करैत छी। ");
INSERT INTO mai_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","हम अपनेक बेसी समय नहि लेबऽ चाहैत छी, तेँ निवेदन अछि जे हमरा लोकनिक दू-चारि शब्‍द केँ सुनबाक कृपा कयल जाओ। ");
INSERT INTO mai_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","बात एहि तरहेँ अछि। ई आदमी उपद्रवी अछि। सौंसे संसारक यहूदी सभ मे आन्‍दोलन मचबैत घुमैत अछि। ई नासरी-कुपंथक नेता अछि, और एतबे नहि, ");
INSERT INTO mai_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ई मन्‍दिरो केँ अपवित्र करबाक कोशिश कयलक, मुदा तखने हमरा लोकनि आबि एकरा पकड़ि लेलिऐक। हम सभ अपन धर्म-नियमक अनुसार एकर फैसला कऽ देने रहितिऐक, ");
INSERT INTO mai_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","मुदा सेनापति लुसियास आबि कऽ हमरा सभक हाथ सँ एकरा जबरदस्‍ती छिनि लेलनि ");
INSERT INTO mai_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","और अभियोगी पक्ष केँ अपनेक सम्‍मुख उपस्‍थित होयबाक आज्ञा दऽ देलनि। अपने स्‍वयं एकरा सँ पूछ-ताछ कऽ कऽ पता लगा सकब जे जाहि बातक आरोप हमरा लोकनि एकरा पर लगा रहल छी, से सभ सत्‍य अछि।” ");
INSERT INTO mai_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","यहूदी सभ सेहो हुनकर “हँ” मे “हँ” मिला कऽ आरोप लगाबऽ मे संग देलथिन आ कहैत रहलाह, “हँ, यैह बात सभ अछि।” ");
INSERT INTO mai_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","राज्‍यपाल आब पौलुस केँ बजबाक लेल संकेत कयलनि, तँ ओ एहि प्रकारेँ उत्तर देलथिन, “ई बुझि जे अपने बहुत वर्ष सँ एहि यहूदी जातिक न्‍यायाधीश छी, हमरा अपनेक सामने अपन वयान देबऽ मे बड्ड प्रसन्‍नता भऽ रहल अछि। ");
INSERT INTO mai_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","हमरा यरूशलेम मे आराधना करबाक लेल गेला बारह दिन सँ बेसी नहि भेल अछि, तकर पता अपने सेहो लगा सकैत छी। ");
INSERT INTO mai_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ई सभ जे छथि, से हमरा ने तँ मन्‍दिर मे ककरो सँ वाद-विवाद करैत आ ने सभाघर मे वा शहर मे कतौ भीड़ केँ भड़कबैत पौलनि। ");
INSERT INTO mai_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","जाहि बातक आरोप ई सभ आब हमरा पर लगा रहल छथि, से बात अपनेक सामने प्रमाणित नहि कऽ सकैत छथि। ");
INSERT INTO mai_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","हँ, हम स्‍वीकार करैत छी जे हम एहि ‘बाट’ केँ मानैत छी, जकरा ई लोकनि ‘कुपंथ’ कहैत छथि, और एही बाटक अनुसार हम अपन पूर्वजक परमेश्‍वरक आराधना करैत छी। जे बात मूसाक धर्म-नियम मे आ परमेश्‍वरक प्रवक्‍ता लोकनिक लेख मे लिखल अछि, ताहि सभ पर हम एखनो विश्‍वास करैत छी। ");
INSERT INTO mai_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","हमर पूर्ण विश्‍वास अछि, जेना कि हिनको सभक छनि, जे परमेश्‍वर धर्मी और अधर्मी दूनू केँ मृत्‍युक बाद जिऔथिन। ");
INSERT INTO mai_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","एहि कारणेँ हम सदिखन अपन जीवन ताहि तरहेँ व्‍यतीत करबाक प्रयत्‍न करैत छी, जाहि सँ हम परमेश्‍वरक आ मनुष्‍यक दृष्‍टि मे निर्दोष रही। ");
INSERT INTO mai_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“बहुत वर्षक बाद हम अपन जातिक गरीब लोक सभक लेल दान पहुँचाबऽ और परमेश्‍वर केँ चढ़ौना चढ़यबाक लेल यरूशलेम घूमि अयलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","एही काजक समय मे ई सभ हमरा मन्‍दिर मे देखलनि। हम शुद्धीकरणक विधि सभ पूरा कऽ लेने छलहुँ, और हमरा संग ने कोनो भीड़ छल आ ने कोनो बातक हुल्‍लड़ि मचि रहल छल। ");
INSERT INTO mai_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","मुदा तखन आसिया प्रदेशक किछु यहूदी सभ अयलाह आ... उचित तँ ई रहैत जे, जँ हुनका सभ केँ हमरा विरोध मे किछु छलनि तँ ओ सभ स्‍वयं अपनेक समक्ष एतऽ उपस्‍थित भऽ कऽ अपन आरोप हमरा पर लगबितथि। ");
INSERT INTO mai_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","आब तँ, ई सभ जे छथि, से सभ एखन कहथु जे हम जखन धर्म-महासभाक सामने मे ठाढ़ छलहुँ तखन ई सभ हमरा कोन अपराधक दोषी पौलनि। ");
INSERT INTO mai_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","एकेटा ई बात भऽ सकत जे हम हिनका सभक सामने मे ठाढ़ भऽ कऽ जोर सँ कहलहुँ जे, ‘अहाँ सभक समक्ष हमर न्‍याय आइ एही कारणेँ कयल जा रहल अछि जे, हमर पूर्ण विश्‍वास अछि जे परमेश्‍वर मुइल सभ केँ जिऔथिन।’ ” ");
INSERT INTO mai_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","तखन फेलिक्‍स, जे एहि “बाट”क बारे मे नीक जकाँ जनैत छलाह, ई कहि मोकदमाक सुनवाइ बन्‍द कयलनि जे, “सेनापति लुसियास जखन आबि जयताह, तखन अहाँ सभक मोकदमाक निर्णय करब।” ");
INSERT INTO mai_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ओ कप्‍तान केँ आदेश देलथिन जे पौलुस केँ किछु स्‍वतन्‍त्रताक संग पहरा मे राखल जाय आ हुनकर साथी-संगी सभ केँ हुनकर आवश्‍यकताक पूर्ति करऽ सँ रोकल नहि जाय। ");
INSERT INTO mai_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","किछु दिनक बाद फेलिक्‍स अपन घरवाली द्रुसिल्‍ला, जे यहूदी जातिक छलीह, तिनका लऽ कऽ अयलाह आ पौलुस केँ बजबौलनि। पौलुस हुनका सँ प्रभु यीशु मसीह पर विश्‍वास करबाक सम्‍बन्‍ध मे बात करऽ लगलाह आ फेलिक्‍स सुनैत रहलाह। ");
INSERT INTO mai_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","मुदा जखन ओ धार्मिकता, अपना केँ वश मे रखनाइ, और परमेश्‍वरक आबऽ वला न्‍यायक दिनक विषय मे बाजऽ लगलाह, तखन फेलिक्‍स भयभीत भऽ उठलाह आ कहलथिन, “आब रहऽ दैह! एखन तोँ जा सकैत छह। फेर फुरसति भेटला पर हम तोरा बजयबह।” ");
INSERT INTO mai_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","संगहि-संग ओ पौलुस सँ घूस प्राप्‍त करबाक आशा रखैत छलाह, आ तेँ हुनका बेर-बेर बजबा कऽ हुनका संग बात-चीत करैत छलाह। ");
INSERT INTO mai_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","दू वर्ष बितलाक बाद फेलिक्‍सक जगह पर पुरखियुस फेस्‍तुस राज्‍यपालक पद पर अयलाह, आ फेलिक्‍स यहूदी सभ केँ खुश करबाक उद्देश्‍य सँ पौलुस केँ जहल मे बन्‍दे छोड़ि गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","फेस्‍तुस अपना प्रदेश मे अयलाक तीन दिनक बाद कैसरिया सँ यरूशलेम गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ओतऽ यहूदी सभक मुख्‍यपुरोहित और अगुआ लोकनि हुनका समक्ष पौलुसक विरोध मे अपन अभियोग प्रस्‍तुत कयलनि, ");
INSERT INTO mai_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","और हुनका सँ विनती कयलनि जे ओ पौलुस केँ मोकदमाक लेल फेर यरूशलेम पठयबाक कृपा करथि। तकर कारण ई छल जे ओ सभ रस्‍ते मे पौलुसक हत्‍या करबाक योजना बना रहल छलाह। ");
INSERT INTO mai_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","मुदा फेस्‍तुस उत्तर देलथिन, “पौलुस कैसरिया मे बन्‍दी अछि, आ हम अपने जल्‍दिए ओतऽ जा रहल छी। ");
INSERT INTO mai_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","तेँ अहाँ सभ मे सँ जे प्रमुख व्‍यक्‍ति सभ होथि, से सभ हमरा संग चलथु और जँ ओ कोनो अनुचित काज कयने अछि तँ ओतहि ओकरा पर अभियोग लगबथु।” ");
INSERT INTO mai_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","फेस्‍तुस हुनका सभक बीच आठ-दस दिन बिता कऽ फेर कैसरिया घूमि अयलाह। प्राते भेने ओ न्‍यायासन पर बैसि कऽ आज्ञा देलनि जे पौलुस केँ उपस्‍थित कयल जाय। ");
INSERT INTO mai_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","पौलुस केँ अयला पर यरूशलेम सँ आयल यहूदी सभ हुनका चारू कात ठाढ़ भऽ कऽ हुनका पर भारी-भारी आरोप लगाबऽ लगलनि, जकरा प्रमाणित नहि कऽ सकलाह। ");
INSERT INTO mai_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","तखन पौलुस अपना पक्षक बात सुनौलनि, “हम ने तँ यहूदी सभक धर्म-नियमक विरोध मे, ने मन्‍दिरक विरोध मे आ ने सम्राट-कैसरक विरोध मे कोनो अपराध कयने छी।” ");
INSERT INTO mai_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","फेस्‍तुस यहूदी सभ केँ खुश करबाक लेल पौलुस सँ पुछलथिन, “की तोँ यरूशलेम जयबाक लेल तैयार होयबह जे ओतहि हमरा सामने मे एहि बात सभक सम्‍बन्‍ध मे तोहर न्‍याय होयतह?” ");
INSERT INTO mai_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","मुदा पौलुस उत्तर देलथिन, “हम एखन सम्राट-कैसरक न्‍यायासनक सामने ठाढ़ छी। एतहि हमर न्‍याय होयबाक चाही। जेना कि अपने नीक जकाँ जनैत छी, हम यहूदी सभ केँ कोनो हानि नहि पहुँचौने छी। ");
INSERT INTO mai_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","हम जँ मृत्‍युदण्‍डक योग्‍य कोनो अपराध कयने होइ तँ मरबाक लेल हम एकदम तैयार छी। मुदा जँ हिनका सभक द्वारा लगाओल अभियोग मे किछु सत्‍ये नहि अछि तँ हमरा हिनका सभक हाथ सौंपबाक अधिकार किनको नहि छनि। हम सम्राट लग अपील करैत छी!” ");
INSERT INTO mai_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","तखन फेस्‍तुस अपन सल्‍लाहकार सभ सँ विचार-विमर्श कऽ कऽ उत्तर देलथिन, “तोँ सम्राट लग अपील कयलह, तोँ सम्राटे लग जयबह!” ");
INSERT INTO mai_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","किछु दिनक बाद राजा अग्रिप्‍पा और बरनिकी फेस्‍तुस केँ नव पदक शुभकामना देबाक लेल कैसरिया अयलाह ");
INSERT INTO mai_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","आ हुनका ओतऽ बहुते दिन रहलाह। एहि सँ फेस्‍तुस केँ पौलुसक मोकदमाक विषय मे राजा केँ बुझयबाक मौका भेटलनि। ओ कहलथिन, “एतऽ एक आदमी अछि जकरा फेलिक्‍स बन्‍दिए छोड़ि गेल छथि। ");
INSERT INTO mai_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","हम जखन यरूशलेम गेलहुँ तँ यहूदी सभक मुख्‍यपुरोहित और बूढ़-प्रतिष्‍ठित सभ हमरा लग आबि एकरा पर लगाओल आरोप सभ सुनौलनि आ माँग कयलनि जे ओकरा दण्‍ड देल जाय। ");
INSERT INTO mai_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","मुदा हम हुनका सभ केँ उत्तर देलियनि जे, हम सभ जे रोमी छी, तकरा सभक ई प्रथा नहि अछि जे बन्‍दी केँ ओहिना ककरो हाथ सौंपि दिऐक। कोनो व्‍यक्‍ति पर जँ आरोप लगाओल गेल अछि, तँ पहिने ओकरा आरोप लगाबऽ वला सभक समक्ष अपन पक्षक वयान देबाक अवसर देल जाइत छैक, तकरा बादे फैसला कयल जाइत अछि, ओना नहि। ");
INSERT INTO mai_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ओ सभ हमरा संग एतऽ अयलाह तँ हम विलम्‍ब नहि कऽ कऽ प्राते भेने न्‍यायासन पर बैसि कऽ एहि आदमी केँ उपस्‍थित करयबाक आज्ञा देलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","मुदा ओकर विरोधी सभ जखन आरोप लगयबाक लेल ठाढ़ भेलाह, तँ ओ सभ एहन कोनो अपराधक आरोप ओकरा पर नहि लगौलनि जेना हम सोचने छलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","एतबे बात छल जे ओकरा सँ हुनका सभ केँ अपन धर्मक कोनो बात सभ मे मतभेद छलनि, और यीशु नामक एक मुइल आदमी, जकरा पौलुस जीविते कहैत छलैक, तकरा विषय मे विवाद छलनि। ");
INSERT INTO mai_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","हमरा फुरयबे नहि करैत छल जे एहन बात सभक छानबीन कोना कयल जाय। तेँ हम ओकरा सँ पुछलिऐक जे, की तोँ यरूशलेम जयबाक लेल तैयार होयबह जाहि सँ ओतहि एहि बात सभक सम्‍बन्‍ध मे तोहर न्‍याय होयतह? ");
INSERT INTO mai_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","मुदा ओ अपील कयलक जे ओ सम्राटक न्‍याय आ निर्णयक लेल संरक्षण मे राखल जाय, तँ हम आदेश देलहुँ जे जाबत तक हम ओकरा सम्राट लग नहि पठा दैत छी ताबत तक ओ पहरा मे राखल जाय।” ");
INSERT INTO mai_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","एहि पर अग्रिप्‍पा फेस्‍तुस केँ कहलथिन, “हम अपने एहि आदमीक बात सुनितहुँ।” फेस्‍तुस उत्तर देलथिन, “अहाँ काल्‍हिए ओकर बात सुनि लेबैक।” ");
INSERT INTO mai_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","तँ प्रात भेने अग्रिप्‍पा आ बरनिकी बड़का धूम-धामक संग सेनापति सभ आ शहरक गणमान्‍य व्‍यक्‍ति सभक संग सभा भवन मे प्रवेश कयलनि। फेस्‍तुसक आज्ञा पर पौलुस केँ बजाओल गेलनि। ");
INSERT INTO mai_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","तखन फेस्‍तुस बजलाह, “राजा अग्रिप्‍पा आ समस्‍त उपस्‍थित आदरणीय लोक सभ, ई आदमी, जकरा एतऽ देखैत छी, तकरा सम्‍बन्‍ध मे यरूशलेम मे और एतौ सम्‍पूर्ण यहूदी जातिक लोक सभ जोर-जोर सँ हल्‍ला कऽ कऽ हमरा सँ ई माँग कयने अछि जे ई आदमी जीवित रहबाक योग्‍य नहि अछि। ");
INSERT INTO mai_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","मुदा हम एहि निश्‍चय पर पहुँचल छी जे ई आदमी मृत्‍युदण्‍डक योग्‍य कोनो काज नहि कयने अछि। लेकिन ई अपने जखन सम्राट लग अपील कयलक तँ हम एकरा रोम पठयबाक निर्णय कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","मुदा हमरा लग एकरा विषय मे महाराजाधिराज केँ लिखबाक लेल कोनो निश्‍चित बात नहि अछि। एहि कारणेँ हम अपने सभक सम्‍मुख, आ खास कऽ, यौ राजा अग्रिप्‍पा, अपनेक सम्‍मुख, एहि आदमी केँ उपस्‍थित करौने छी, जाहि सँ एकर जाँच कयलाक बाद हमरा किछु लिखबाक लेल भेटय। ");
INSERT INTO mai_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","कारण, कोनो बन्‍दी केँ बिनु ओकर अभियोग-पत्र तैयार कयने सम्राट लग पठायब हमरा तर्कसंगत नहि बुझाइत अछि।” ");
INSERT INTO mai_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","तखन अग्रिप्‍पा पौलुस केँ कहलथिन, “अहाँ केँ अपना पक्षक वयान देबाक अनुमति अछि।” एहि पर पौलुस हाथ उठा कऽ अपन वयान सुनौनाइ शुरू कयलनि— ");
INSERT INTO mai_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“राजा अग्रिप्‍पा, ई हमरा लेल सौभाग्‍यक बात अछि जे हमरा आइ अपनेक समक्ष ओहि आरोप सभक सम्‍बन्‍ध मे उत्तर देबाक अवसर भेटल जे यहूदी सभ हमरा पर लगा रहल छथि, ");
INSERT INTO mai_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","विशेष कऽ एहि लेल जे अपने यहूदी सभक सभ प्रथा आ विवाद सँ नीक जकाँ परिचित छी। तेँ अपने सँ प्रार्थना अछि जे हमर बात धैर्यपूर्बक सुनबाक कृपा कयल जाओ। ");
INSERT INTO mai_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“हम शुरुए सँ अपना जातिक बीच अपनो देश मे आ यरूशलेमो मे अपन जीवन बचपने सँ कोना बितौलहुँ, से यहूदी सभ जनैत छथि। ");
INSERT INTO mai_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ओ सभ हमर पुरान परिचित लोक छथि आ तेँ जँ चाहितथि तँ हमरा बारे मे गवाहिओ दऽ सकितथि जे हम अपन यहूदी धर्मक सभ सँ कट्टर पंथ, अर्थात् फरिसी पंथक अनुसरण कयने छलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","और एखन हमर एहि लेल न्‍याय कयल जा रहल अछि जे हम पूर्ण विश्‍वासक संग ओहि वचन पर अपन आशा रखने छी जे वचन परमेश्‍वर हमरा सभक पूर्वज सभ केँ देने छथि। ");
INSERT INTO mai_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","आ ठीक यैह वचन पूरा होयबाक आशा रखैत हमरा यहूदी लोकनिक बारहो कुलक लोक सभ बहुत भक्‍तिक संग दिन-राति परमेश्‍वरक सेवा करैत छथि। हँ सरकार, एही वचन पर हमर आशाक कारणेँ यहूदी सभक द्वारा हमरा पर दोष लगाओल जा रहल अछि! ");
INSERT INTO mai_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","अपने सभ केँ ई बात अविश्‍वसनीय किएक लगैत अछि जे परमेश्‍वर मुइल सभ केँ जिअबैत छथिन? ");
INSERT INTO mai_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“हमहूँ सोचैत छलहुँ जे, जतेक हम नासरत-निवासी यीशुक नामक विरोध मे कऽ सकैत छी, ततेक हमरा करबाक अछि। ");
INSERT INTO mai_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","आ हम यरूशलेम मे एना करबो कयलहुँ। मुख्‍यपुरोहित सभ सँ अधिकार लऽ कऽ हम परमेश्‍वरक कतेको लोक सभ केँ जहल मे राखि देलहुँ, आ जखन ओकरा सभ केँ मृत्‍युदण्‍ड देल गेलैक तँ हमहूँ ओहि मे सहमति दैत छलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","हम कतेको बेर सभाघर सभ मे जा-जा कऽ ओकरा सभ केँ दण्‍ड दिआ कऽ ओकरा सभ सँ अपना प्रभु केँ अस्‍वीकार करयबाक कोशिश कयलहुँ। हमरा ततेक क्रोध छल जे सनकल जकाँ भऽ गेल छलहुँ आ हम ओकरा सभ केँ सतयबाक लेल आनो-आन देशक शहर सभ मे गेलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“एक बेर हम एही काजक लेल मुख्‍यपुरोहित सभक पूर्ण अधिकार और आज्ञाक संग दमिश्‍क जा रहल छलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","करीब दुपहरक समय मे, सरकार, रस्‍ता मे हम आकाश सँ एहन इजोत देखलहुँ जे सूर्योक इजोत सँ तेज छल, जे हमरा आ हमर सहयात्री सभक चारू कात चमकि रहल छल। ");
INSERT INTO mai_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","हम सभ गोटे जमीन पर खसि पड़लहुँ। तखन हमरा अपन इब्रानी भाषा मे एक आवाज सुनाइ देलक जे हमरा कहैत छल, ‘हौ साउल, हौ साउल, हमरा किएक सतबैत छह? तोँ हमर विरोध कऽ कऽ अपने केँ कष्‍ट पहुँचबैत छह।’ ");
INSERT INTO mai_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","तखन हम पुछलियनि, ‘प्रभु, अहाँ के छी?’ प्रभु हमरा उत्तर देलनि, ‘हम यीशु छी, जिनका तोँ सता रहल छह। ");
INSERT INTO mai_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","आब उठह! पयर पर ठाढ़ होअह, कारण हम तोरा एहि लेल दर्शन देने छिअह जे हम तोरा अपन सेवक आ गवाह नियुक्‍त करी। तोँ हमरा विषय मे जे देखने छह आ बाद मे जे किछु हम तोरा देखयबह, ताहि सभक सम्‍बन्‍ध मे तोरा गवाही देबाक छह। ");
INSERT INTO mai_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","हम तोहर अपन लोकक हाथ सँ और गैर-यहूदी लोक सभक हाथ सँ सेहो तोरा बचयबह। हम तोरा ओकरा सभ लग एहि लेल पठा रहल छिअह जे ");
INSERT INTO mai_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","तोँ ओकरा सभक आँखि खोलह और ओकरा सभ केँ अन्‍हार सँ इजोत मे, अर्थात् शैतानक राज्‍य सँ परमेश्‍वर लग, घुमाबह, जाहि सँ हमरा पर विश्‍वास कयला सँ ओ सभ पापक क्षमा प्राप्‍त करय आ परमेश्‍वरक पवित्र कयल लोकक संग उत्तराधिकारी बनय।’ ");
INSERT INTO mai_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“तेँ, हे महाराज अग्रिप्‍पा, हम एहि स्‍वर्गीय दर्शन सँ भेटल आज्ञाक उल्‍लंघन नहि कयलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","पहिने दमिश्‍क मे, तखन यरूशलेम मे आ सौंसे यहूदिया प्रदेश मे, आ गैर-यहूदी सभ मे सेहो हम प्रचार कयलहुँ जे, अपना पापक लेल पश्‍चात्ताप कऽ कऽ परमेश्‍वर लग घूमि आउ, और अपन काज द्वारा अपन हृदय-परिवर्तन केँ प्रमाणित करू। ");
INSERT INTO mai_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","एही कारणेँ यहूदी सभ हमरा मन्‍दिर मे पकड़लक आ जान सँ मारि देबाक कोशिश कयलक। ");
INSERT INTO mai_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","मुदा परमेश्‍वर अजुका दिन धरि हमर सहायता कयने छथि, आ तेँ हम आइ एतऽ ठाढ़ भऽ कऽ छोट-पैघ सभक सामने गवाही दऽ रहल छी। जाहि बात सभक भविष्‍यवाणी मूसा आ परमेश्‍वरक प्रवक्‍ता लोकनि कयलनि, ताहि सँ बेसी हम किछु नहि कहैत छी— ");
INSERT INTO mai_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","अर्थात् ई जे, उद्धारकर्ता-मसीह केँ दुःख उठयबाक छलनि, और सभ सँ पहिल मृत्‍यु सँ जीबि उठनिहार भऽ कऽ अपनो लोक केँ आ दोसरो जाति सभ केँ सेहो इजोतक शुभ समाचार सुनयबाक छलनि।” ");
INSERT INTO mai_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","पौलुस जखन ई बात सभ कहिए रहल छलाह तँ फेस्‍तुस बाधा करैत बड्ड जोर सँ कहलथिन, “हौ पौलुस! तोँ बताह भऽ गेलह! तोहर पैघ शिक्षा तोरा बताह कऽ देने छह!” ");
INSERT INTO mai_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","पौलुस उत्तर देलथिन, “परम श्रेष्‍ठ फेस्‍तुस, हम बताह नहि छी। हम जे कहैत छी से एकदम सत्‍य आ विवेकपूर्ण बात अछि। ");
INSERT INTO mai_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","राजा साहेब एहि बात सभक विषय मे जनैत छथि, आ हुनका सँ हम खुलि कऽ बात कऽ सकैत छी। हमरा पूर्ण विश्‍वास अछि जे एहि सभ बात मे एहन कोनो बात नहि अछि जकरा बारे मे ओ नहि जनैत होथि, कारण ई सभ घटना कोनो कोना मे नहि भेल अछि। ");
INSERT INTO mai_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","राजा अग्रिप्‍पा, की अपने परमेश्‍वरक प्रवक्‍ता लोकनिक बात पर विश्‍वास करैत छी? हम जनैत छी जे अपने केँ विश्‍वास अछि।” ");
INSERT INTO mai_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","एहि पर अग्रिप्‍पा पौलुस केँ कहलथिन, “की अहाँ एतबे काल मे हमरा मसीही बनाबऽ चाहैत छी?!” ");
INSERT INTO mai_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पौलुस उत्तर देलथिन, “ ‘एतबे’ काल वा ‘बहुत’ काल लागय, परमेश्‍वर करथु जे अपनेटा मात्र नहि, बल्‍कि आइ जतबा लोक हमर बात सुनि रहल छथि से सभ केओ हमरा जकाँ बनथि—मात्र एहिना जिंजीर सँ बान्‍हल नहि!” ");
INSERT INTO mai_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","तखन राजा अग्रिप्‍पा उठि गेलाह, आ तहिना राज्‍यपाल, बरनिकी आ हुनका सभक संग बैसल सभ लोक सेहो ठाढ़ भऽ गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","सभा सँ बहरा कऽ ओ सभ एक-दोसर सँ बात करऽ लगलाह, आ बजलाह, “ई आदमी मृत्‍युदण्‍ड वा जहल मे राखल जयबाक योग्‍य कोनो काज नहि कऽ रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","और अग्रिप्‍पा फेस्‍तुस केँ कहलथिन, “ई जँ सम्राट लग अपील नहि कयने रहैत तँ मुक्‍त कयल जा सकैत।” ");
INSERT INTO mai_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","जखन ई निश्‍चय भऽ गेल जे हम सभ पानि जहाज सँ इटली देश जायब तँ पौलुस और दोसरो बन्‍दी सभ केँ सम्राटक सैन्‍यदलक कप्‍तान यूलियुसक जिम्‍मा मे लगा देल गेलनि। ");
INSERT INTO mai_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","हम सभ अद्रमुतियुम नगरक एक जहाज जे आसिया प्रदेशक समुद्रक कछेर पर पड़ऽ वला शहर सभ होइत जाय वला छल, ताहि पर चढ़ि कऽ विदा भेलहुँ। हमरा सभक संग मकिदुनिया प्रदेशक थिसलुनिका नगरक निवासी अरिस्‍तर्खुस सेहो छलाह। ");
INSERT INTO mai_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","दोसर दिन सीदोन नगर मे पहुँचलहुँ। ओतऽ यूलियुस पौलुस पर दया कऽ कऽ हुनका संगी-साथी सभक ओहिठाम जा कऽ अपन आवश्‍यकताक वस्‍तु स्‍वीकार करबाक अनुमति देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ओतऽ सँ ओही जहाज सँ फेर विदा भेलहुँ, और हवा विपरीत दिस सँ रहबाक कारणेँ हम सभ साइप्रस द्वीपक अऽढ़ मे चललहुँ। ");
INSERT INTO mai_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","तखन किलिकिया और पंफूलिया प्रदेशक सामनेक समुद्री भाग दऽ कऽ आगाँ बढ़ि लुकिया प्रदेशक मूरा नामक स्‍थान पर पहुँचलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ओतऽ कप्‍तान केँ सिकन्‍दरिया नगरक एक जहाज भेटलनि जे इटली देश जा रहल छल। ओ हमरा सभ केँ ओहि पर चढ़ा देलनि। ");
INSERT INTO mai_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","कतेक दिन धरि धिरे-धिरे आगाँ बढ़ैत अन्‍त मे बहुत कठिनाइ सँ हम सभ कनिदुस नगर लग पहुँचलहुँ। हवा हमरा सभ केँ ओहि दिस आरो आगाँ बढ़ऽ नहि दऽ रहल छल आ तेँ हम सभ सलमोन नगर लग क्रेत द्वीपक अऽढ़ मे चल गेलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","द्वीपक काते-काते बहुत कठिनाइ सँ आगाँ बढ़ैत हम सभ “असल शरण” नामक स्‍थान पर पहुँचलहुँ, जे लसिया नगर लग अछि। ");
INSERT INTO mai_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","एहि तरहेँ बहुत समय बिति गेल छल। प्रायश्‍चित्त-दिवसक उपास सेहो बिति गेल छल, और जल-यात्रा करब आब खतरनाक छल। तेँ पौलुस लोक सभ केँ ई चेतावनी देलथिन जे, ");
INSERT INTO mai_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“यौ मित्र लोकनि! हम देखैत छी जे एहि यात्रा मे एखन आगाँ बढ़ला सँ बहुत भारी खतरा होयत। मात्र जहाज आ माल-सामानक नहि, बल्‍कि अपना सभ केँ अपन प्राणोक हानि उठाबऽ पड़त।” ");
INSERT INTO mai_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","मुदा सेनाक कप्‍तान पौलुसक सल्‍लाह नहि मानि कऽ जहाजक कप्‍तान आ मालिकक बात मानलनि। ");
INSERT INTO mai_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","एहि स्‍थान पर जाड़ मास बितयबाक लेल जहाज ठाढ़ करबाक उपयुक्‍त जगह नहि छल, आ तेँ अधिकांश लोक एहि आशा मे आगाँ बढ़ऽ चाहैत छल जे कोहुना कऽ फीनिक्‍स नगर तक पहुँचि जाइ और ओतहि जाड़ मास बिताबी। फीनिक्‍स क्रेत द्वीपक एक बन्‍दरगाह अछि जकर मुँह दक्षिण-पश्‍चिम आ उत्तर-पश्‍चिमक दिस अछि। ");
INSERT INTO mai_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","जखन दक्षिण सँ हवा सिहकऽ लागल तँ ई सोचि जे हमरा सभक उद्देश्‍य पूरा भऽ गेल, नाविक सभ लंगर खोललक आ क्रेत द्वीपक काते-काते बढ़ऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","मुदा कनेके कालक बाद द्वीपक दिस सँ भयंकर अन्‍हड़-बिहारि उठल जे “उत्तरबरिया-पुबरिया” कहबैत अछि। ");
INSERT INTO mai_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","जहाज अन्‍हड़-बिहारि मे तेना ने फँसि गेल जे नाविक सभ जेम्‍हर सँ अन्‍हड़-बिहारि आबि रहल छल जहाज केँ तेम्‍हर मोड़ऽ सँ असमर्थ भऽ गेल। तेँ हम सभ अपना केँ हवाक रुखि पर छोड़ि देलहुँ जे जतऽ लऽ जाय। ");
INSERT INTO mai_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","कौदा नामक छोट द्वीपक अऽढ़ मे पहुँचला पर हम सभ बहुत कठिनाइ सँ जहाजक पाछाँ बान्‍हल छोट नाव केँ अपना वश मे कऽ सकलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ओकरा जहाज पर लऽ लेलाक बाद नाविक सभ जहाज केँ मजगूत बनयबाक उद्देश्‍य सँ जहाज केँ नीचाँ-ऊपर रस्‍सी लपेटि कऽ बन्‍हलक। तकरबाद, एहि डरेँ जे जहाज कहीं सुरतिस नामक बालु वला क्षेत्र मे ने धँसि जाय, ओ सभ पाल उतारि कऽ जहाज केँ ओहिना हवा मे दहाय देलक। ");
INSERT INTO mai_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","अन्‍हड़-बिहारि हमरा सभ केँ ततेक झकझोड़ि रहल छल जे प्रात भेने ओ सभ जहाज परक माल-सामान समुद्र मे फेकऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","तेसर दिन ओ सभ अपने हाथ सँ जहाजक रस्‍सी-पाल इत्‍यादि फेकि देलक। ");
INSERT INTO mai_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","बहुतो दिन तक जखन सूर्य आ तारा सभ देखाइ नहि देलक और अन्‍हड़-बिहारि चलिते रहल तँ हमरा सभ केँ बचबाक कोनो आशा नहि रहि गेल। ");
INSERT INTO mai_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","जहाज परक लोक सभ बहुतो दिन सँ भोजन नहि कऽ रहल छल। तखन सभक बीच ठाढ़ भऽ कऽ पौलुस कहलथिन, “मित्र लोकनि! उचित तँ ई छल जे अहाँ सभ हमर सल्‍लाह मानि कऽ क्रेत द्वीप सँ विदाए नहि भेल रहितहुँ। तखन ने ई विपत्ति अबैत आ ने ई हानि उठाबऽ पड़ैत। ");
INSERT INTO mai_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","मुदा एखनो हम अहाँ सभ सँ आग्रह करैत छी जे, साहस राखू, कारण ककरो प्राणक हानि नहि उठाबऽ पड़त, मात्र जहाज नष्‍ट भऽ जायत। ");
INSERT INTO mai_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","आइए राति मे, परमेश्‍वर, जिनकर हम छियनि आ जिनकर सेवा करैत छी, तिनकर स्‍वर्गदूत हमरा लग ठाढ़ भऽ कऽ कहलनि जे, ");
INSERT INTO mai_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘हौ पौलुस, डेराह नहि! तोँ सम्राटक समक्ष अवश्‍य ठाढ़ होयबह। और परमेश्‍वर तोरा पर दया कऽ कऽ, तकरा सभ केँ सुरक्षित रखथुन जे सभ तोरा संग यात्रा कऽ रहल छह।’ ");
INSERT INTO mai_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","तेँ अहाँ सभ साहस राखू! कारण, हमरा परमेश्‍वर पर पूरा विश्‍वास अछि जे जेना हमरा कहल गेल अछि तेना हयबो करत। ");
INSERT INTO mai_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","मुदा अपना सभक जहाज कोनो द्वीप पर भसिया जायत।” ");
INSERT INTO mai_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","चौदहम राति मे जखन आद्रिया सागर मे एम्‍हर-ओम्‍हर भटकि रहल छलहुँ तँ करीब दुपहर राति कऽ नाविक सभ केँ बुझयलैक जे कोनो कछेरक लग मे आबि गेल छी। ");
INSERT INTO mai_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ओ सभ जखन थाह लेलक तँ ओतऽ अस्‍सी हाथ गहिंराइ छलैक। कनेक कालक बाद फेर थाह लेलक तँ साठि हाथ भेटलैक। ");
INSERT INTO mai_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","एहि डरेँ जे कहीं पाथर सभ मे ने टकरा जाइ ओ सभ जहाजक पछिलका भाग सँ चारिटा लंगर समुद्र मे खसा देलक आ भोर होयबाक प्रतीक्षा करऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","नाविक सभ केँ जहाज पर सँ भागि जयबाक विचार छलैक, तेँ जहाजक अगिला भाग सँ लंगर खसयबाक बहाना सँ ओ सभ छोटका नाव समुद्र मे उतारने छल। ");
INSERT INTO mai_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","मुदा पौलुस सेनाक कप्‍तान और सैनिक सभ केँ कहलथिन, “ई सभ जँ जहाज पर नहि रहत तँ अहूँ सभ नहि बाँचब।” ");
INSERT INTO mai_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","तेँ सैनिक सभ रस्‍सी सभ काटि कऽ ओहि छोटका नाव केँ समुद्र मे दहा देलक। ");
INSERT INTO mai_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","जखन भोर होमऽ-होमऽ पर छल तँ पौलुस सभ केँ भोजन करबाक लेल आग्रह कयलथिन। ओ कहलथिन, “आइ चौदह दिन भऽ गेल जे अहाँ सभ चिन्‍ताक कारणेँ भूखले छी, किछु नहि खयलहुँ हँ। ");
INSERT INTO mai_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","आब हम अहाँ सभ सँ विनती करैत छी, किछु खा लिअ! नहि तँ बाँचब कोना? अहाँ सभ मे सँ ककरो कोनो तरहक हानि नहि होयत।” ");
INSERT INTO mai_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","एतबा कहि ओ रोटी लेलनि आ सभक सामने मे परमेश्‍वर केँ धन्‍यवाद दऽ कऽ रोटी तोड़ि खाय लगलाह। ");
INSERT INTO mai_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","एहि सँ सभ केँ साहस भेटलैक आ ओहो सभ भोजन करऽ लागल। ");
INSERT INTO mai_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","जहाज पर सभ मिला कऽ हम सभ 276 गोटे छलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","भरि इच्‍छा भोजन कयलाक बाद ओ सभ जहाज परक भार हल्‍लुक करबाक लेल गहुम केँ समुद्र मे फेकि देलक। ");
INSERT INTO mai_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","भोर भेला पर ओ सभ ओहि लगक जगह केँ नहि चिन्‍हि सकल, मुदा ओकरा सभक दृष्‍टि कछेर परक एक लम्‍बा-चौड़ा बालु वला भाग पर पड़लैक, और ओ सभ निर्णय कयलक जे जँ सम्‍भव होअय तँ जहाज केँ ओही भाग मे लगाओल जाय। ");
INSERT INTO mai_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ओ सभ लंगरक रस्‍सी सभ काटि कऽ लंगर सभ केँ समुद्र मे छोड़ि देलक, आ संगहि पतवारक बन्‍हन ढील कऽ देलक। तखन जहाजक अगिला भागक पाल हवाक सम्‍मुख चढ़ा कऽ कछेर दिस आगाँ बढ़ल। ");
INSERT INTO mai_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","मुदा जहाज पानि मेहक बलुआह भाग मे टकरा कऽ फँसि गेल। जहाजक अगिला भाग तेना धँसि गेल जे टस्‍स सँ मस्‍स नहि होइत छल, आ पछिलका भाग बड़का लहरि सभ सँ टकरा-टकरा कऽ टुकड़ा-टुकड़ा भऽ रहल छल। ");
INSERT INTO mai_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","सैनिक सभक विचार छलैक जे कैदी सभ केँ जान सँ मारि दी जाहि सँ केओ हेलि कऽ भागि नहि सकय। ");
INSERT INTO mai_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","मुदा सेनाक कप्‍तान केँ पौलुसक जान बचयबाक इच्‍छा छलनि, तेँ ओ ओकरा सभ केँ एना करऽ सँ रोकि देलथिन। ओ आज्ञा देलनि जे जकरा सभ केँ हेलऽ अबैत होइक से सभ पहिने पानि मे कुदय और हेलि कऽ कछेर पर चल जाय, ");
INSERT INTO mai_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","आ बाँकी लोक काठक पटरा वा जहाजक कोनो टुटल टुकड़ाक सहारा लऽ कऽ पाछाँ सँ जाय। एना कऽ कऽ सभ केओ ओहि भूमि पर सकुशल पहुँचि गेलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","हम सभ जखन कछेर पर पहुँचलहुँ तँ पता लागल जे एहि द्वीपक नाम माल्‍टा अछि। ");
INSERT INTO mai_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ओहिठामक निवासी सभ हमरा सभक संग बहुत उदार भाव सँ व्‍यवहार कयलक। वर्षा भऽ रहल छल आ जाड़ लागि रहल छल, तँ ओ सभ आगिक घूर बना कऽ हमरा सभक स्‍वागत कयलक। ");
INSERT INTO mai_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","पौलुस जारनि-काठी बिछि कऽ घूर पर जखन रखलनि तँ ओहि मे सँ आगिक ताव लगला सँ एकटा साँप निकलि कऽ पौलुसक हाथ मे लटकि गेलनि। ");
INSERT INTO mai_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","हुनका हाथ मे साँप लटकल देखि, द्वीपक निवासी सभ एक-दोसर केँ कहऽ लागल, “ई आदमी पक्‍का हत्‍यारा अछि! समुद्र सँ तँ बचि कऽ आबि गेल, मुदा न्‍याय-देवी ओकरा जीबऽ नहि देथिन।” ");
INSERT INTO mai_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","एम्‍हर पौलुस साँप केँ आगि मे झाड़ि देलनि, आ हुनका किछु नहि भेलनि। ");
INSERT INTO mai_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ओकरा सभ केँ होइत छलैक जे, एकर शरीर आब फुलि जयतैक वा ई एकाएक खसि कऽ मरि जायत, मुदा बहुतो काल प्रतीक्षा कयलाक बाद जखन देखलक जे एकरा किछुओ नहि भऽ रहल छैक, तँ ओ सभ अपन विचार बदलि कऽ कहऽ लागल, “ई तँ देवता छथि!” ");
INSERT INTO mai_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ओहिठाम सँ लगे, द्वीपक मुखियाजी पुबलियुसक घर और जमीन छलनि। ओ हमरा सभक स्‍वागत कयलनि और अपना हवेली मे प्रेम भाव सँ तीन दिन धरि अतिथि-सत्‍कार कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","हुनकर पिताजी ओहि समय मे बोखार आ सुलबाहि सँ पीड़ित छलनि। पौलुस हुनका कोठली मे जा कऽ हुनका लेल प्रार्थना कयलनि, आ हुनका पर हाथ राखि कऽ स्‍वस्‍थ कऽ देलथिन। ");
INSERT INTO mai_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ई बात बुझि द्वीपक आरो रोगी सभ आबऽ लागल आ ओहो सभ स्‍वस्‍थ भऽ गेल। ");
INSERT INTO mai_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ओ सभ विभिन्‍न प्रकार सँ हमरा सभक आदर-सत्‍कार कयलक, और जखन फेर चलबाक समय भऽ गेल तँ ओ सभ हमरा सभक रस्‍ताक लेल आवश्‍यक वस्‍तु सभ आनि जहाज पर राखि देलक। ");
INSERT INTO mai_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","माल्‍टा द्वीप मे तीन मास रहलाक बाद हम सभ एक जहाज पर चढ़लहुँ जे माल्‍टा मे जाड़ मास बितौने छल। ओ जहाज सिकन्‍दरिया नगरक छल और ओहि पर “जौंआदेवता”क आकृति बनाओल गेल छलैक। ");
INSERT INTO mai_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","हम सभ ओहि जहाज सँ विदा भेलहुँ आ सुरकूसा नगर मे रूकि कऽ ओतऽ तीन दिन रहलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ओतऽ सँ फेर काते-कात आगाँ बढ़ैत रेगियुम बन्‍दरगाह मे पहुँचलहुँ। एक दिनक बाद जखन दछिनाही-पवन बहऽ लागल तँ ओतऽ सँ फेर विदा भेलहुँ आ दोसर दिन पुतियुली नगर मे अयलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ओतऽ हमरा सभ केँ किछु विश्‍वासी भाय सभ भेँट भेलाह। हुनका सभक आग्रह पर हम सभ सात दिन हुनका सभक ओहिठाम ठहरलहुँ। एहि तरहेँ हम सभ रोम महानगर पहुँचलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","रोमक विश्‍वासी भाय सभ जखन हमरा सभक बारे मे ई सुनलनि जे हम सभ आबि रहल छी तँ हमरा सभ सँ भेँट करबाक लेल ओ सभ रोम सँ “अपियुस चौक” आ “तीन सराय” तक अयलाह। पौलुस हुनका सभ केँ जखन देखलनि तँ परमेश्‍वरक धन्‍यवाद कयलनि आ प्रोत्‍साहित भेलाह। ");
INSERT INTO mai_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","हम सभ जखन रोम शहर मे पहुँचलहुँ तँ पौलुस केँ एक सैनिकक पहरा मे अपन अलग डेरा मे रहबाक अनुमति भेटलनि। ");
INSERT INTO mai_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","तीन दिनक बाद पौलुस रोमक प्रमुख यहूदी सभ केँ बजौलनि। ओ सभ जखन आबि गेलाह तँ पौलुस हुनका सभ केँ कहलथिन, “बाबू-भैया लोकनि, हम अपना सभक यहूदी जातिक विरोध मे वा पूर्वज सभक प्रथाक विरोध मे किछु नहि कयने छी, मुदा तैयो यरूशलेमक यहूदी सभ हमरा बन्‍दी बना कऽ रोमी सभक हाथ मे सौंपि देलनि। ");
INSERT INTO mai_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","रोमी शासनक अधिकारी सभ हमरा सँ पूछ-ताछ कऽ कऽ हमरा मुक्‍त करऽ चाहलनि, कारण मृत्‍युदण्‍डक योग्‍य हम कोनो काज नहि कयने छलहुँ। ");
INSERT INTO mai_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","मुदा यहूदी सभ जखन रोमी अधिकारी सभक निर्णयक विरोध कयलनि तँ हमरा सम्राट-कैसर लग अपील करऽ पड़ल। ई बात नहि छल जे हमरा अपन जातिक लोक सभ पर कोनो अभियोग लगयबाक छल। ");
INSERT INTO mai_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","एही कारणेँ हम अपने लोकनि केँ बजा कऽ बात-चीत करऽ चाहैत छलहुँ। जिनका पर यहूदी लोक अपन सभ आशा रखने छथि, तिनके कारण हम एहि जिंजीर सँ बान्‍हल छी।” ");
INSERT INTO mai_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ओ सभ उत्तर देलथिन, “हमरा सभ केँ यहूदिया प्रदेश सँ अहाँक सम्‍बन्‍ध मे ने कोनो पत्र भेटल अछि, आ ने ओतऽ सँ आयल भाय सभ मे सँ केओ औपचारिक वा अनौपचारिक रूप सँ अहाँक विरोध मे किछु कहने अछि। ");
INSERT INTO mai_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","अहाँक विचार आ विश्‍वासक सम्‍बन्‍ध मे हम सभ अहीं सँ सुनऽ चाहैत छी, कारण, एहि पंथक विषय मे एतेक जनैत छी जे सभ ठाम लोक एकर विरोध कऽ रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","तँ ओ सभ पौलुसक बात सुनबाक लेल एक दिन निश्‍चित कयलनि, आ ओहि दिन पहिल दिन सँ बेसी संख्‍या मे ओ सभ हुनका ओहिठाम अयलाह। भोर सँ लऽ कऽ साँझ तक ओ हुनका सभ केँ परमेश्‍वरक राज्‍यक शुभ समाचार सुनौलथिन, और मूसाक धर्म-नियम सँ आ परमेश्‍वरक प्रवक्‍ता सभक लेख सँ यीशुक बारे मे हुनका सभ केँ बुझयबाक प्रयत्‍न कयलनि। ");
INSERT INTO mai_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","किछु लोक हुनकर बात मानि कऽ विश्‍वास कयलनि, मुदा किछु लोक अविश्‍वासिए रहि गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ओ सभ आपस मे वाद-विवाद करऽ लगलाह, और पौलुसक एहि अन्‍तिम बातक बाद विदा होमऽ लगलाह जे, “पवित्र आत्‍मा अपन प्रवक्‍ता यशायाह द्वारा बाजि अहाँ सभक पूर्वज लोकनि केँ ई बात एकदम ठीक कहलनि जे, ");
INSERT INTO mai_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘एहि जाति लग जा कऽ कहक जे, तोँ सभ सुनैत रहबह, मुदा बुझबह नहि। तोँ सभ तकैत रहबह, मुदा सुझतह नहि। ");
INSERT INTO mai_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","कारण, एहि लोक सभक मोन मे ठेला पड़ि गेल छैक, एकरा सभक कान बहीर भऽ गेल छैक। ई सभ आँखि मुनि लेने अछि, जाहि सँ कतौ एना नहि होअय जे आँखि सँ देखय, कान सँ सुनय, मोन सँ बुझय, आ घूमि कऽ हमरा लग आबय और हम ओकरा सभ केँ स्‍वस्‍थ कऽ दिऐक।’ ");
INSERT INTO mai_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","तेँ अहाँ सभ ई बात बुझि लिअ जे परमेश्‍वरक उद्धारक ई शुभ समाचार गैर-यहूदी सभ लग पठाओल गेल अछि, और ओ सभ स्‍वीकार करत!” ");
INSERT INTO mai_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","पौलुसक एतेक कहलाक बाद यहूदी सभ आपस मे बहुत पैघ वाद-विवाद करैत चल गेलाह। ");
INSERT INTO mai_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","पौलुस ओहिठाम अपन किरायाक घर मे पूरा दू वर्ष धरि रहलाह। जे लोक सभ भेँट करबाक लेल हुनका ओहिठाम अबैत छलाह, तिनका सभक ओ स्‍वागत करैत छलथिन, ");
INSERT INTO mai_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","और बिनु कोनो रुकाबट केँ ओ निडर भऽ कऽ परमेश्‍वरक राज्‍यक विषय मे प्रचार करैत रहलाह और प्रभु यीशु मसीहक सम्‍बन्‍ध मे शिक्षा दैत रहलाह।");
INSERT INTO mai_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ई पत्र मसीह यीशुक सेवक पौलुसक दिस सँ अछि, जे मसीह-दूत होयबाक लेल बजाओल गेलहुँ आ परमेश्‍वरक ओहि शुभ समाचारक प्रचार करबाक लेल अलग कयल गेल छी, ");
INSERT INTO mai_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","जाहि शुभ समाचारक सम्‍बन्‍ध मे परमेश्‍वर पहिनहि सँ अपन प्रवक्‍ता सभक माध्‍यम सँ पवित्र धर्मशास्‍त्र मे वचन देने छथि। ");
INSERT INTO mai_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ई शुभ समाचार परमेश्‍वरक पुत्रक विषय मे अछि, जे मानवीय वंशावलीक अनुसार दाऊदक वंशज छलाह, ");
INSERT INTO mai_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","आ मुइल सभ मे सँ जीबि उठबाक कारणेँ परमेश्‍वरक पवित्र आत्‍मा द्वारा सामर्थ्‍यक संग परमेश्‍वरक पुत्र प्रमाणित भेलाह। ओ छथि अपना सभक प्रभु, यीशु मसीह। ");
INSERT INTO mai_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","हुनका द्वारा आ हुनकर नामक सम्‍मानक लेल हमरा सभ केँ मसीह-दूत बनबाक वरदान भेटल अछि जाहि सँ सभ जातिक लोकक बीच हम सभ हुनकर प्रचार करी आ ओ सभ विश्‍वास कऽ कऽ हुनकर अधीनता स्‍वीकार करनि। ");
INSERT INTO mai_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ओहि लोक सभ मे अहूँ सभ छी, अहाँ सभ जे सभ यीशु मसीहक अपन लोक होयबाक लेल बजाओल गेल छी। ");
INSERT INTO mai_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","अहाँ सभ जे रोम शहर मे परमेश्‍वरक प्रिय लोक छी आ पवित्र होयबाक लेल बजाओल गेल छी, अहाँ सभ गोटे केँ हम ई पत्र लिखि रहल छी। अपना सभक पिता परमेश्‍वर आ प्रभु यीशु मसीह अहाँ सभ पर कृपा करथि आ अहाँ सभ केँ शान्‍ति देथि। ");
INSERT INTO mai_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","सर्वप्रथम हम यीशु मसीहक माध्‍यम सँ अहाँ सभक लेल अपना परमेश्‍वर केँ धन्‍यवाद दैत छिऐन, किएक तँ अहाँ सभक विश्‍वासक चर्चा समस्‍त संसार मे पसरि रहल अछि। ");
INSERT INTO mai_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","जाहि परमेश्‍वरक सेवा हम हुनकर पुत्रक शुभ समाचारक प्रचार कऽ कऽ अपन सम्‍पूर्ण हृदय सँ करैत छी, सैह हमर साक्षी छथि जे हम प्रार्थना सभ मे निरन्‍तर अहाँ सभ केँ स्‍मरण करैत रहैत छी, ");
INSERT INTO mai_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","आ सदिखन ई विनती करैत छिऐन जे, जँ हुनकर इच्‍छा छनि, तँ ओ अन्‍त मे हमरा लेल अहाँ सभ लग अयबाक कोनो ने कोनो उपाय करताह। ");
INSERT INTO mai_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","किएक तँ हमरा अहाँ सभ सँ भेँट करबाक बड्ड इच्‍छा अछि, जाहि सँ अहाँ सभ केँ विश्‍वास मे दृढ़ बनयबाक लेल, हम आत्‍मिक रूप सँ अहाँ सभक मदति कऽ सकी। ");
INSERT INTO mai_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","वा एकरा एहि तरहेँ कहू—हम चाहैत छी जे अपना सभ एक संग रहि कऽ एक-दोसराक विश्‍वास द्वारा प्रोत्‍साहित होइ—अहाँ सभ हमरा विश्‍वास द्वारा आ हम अहाँ सभक विश्‍वास द्वारा। ");
INSERT INTO mai_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","यौ भाइ लोकनि, हम नहि चाहैत छी जे अहाँ सभ एहि बात सँ अनजान रहू जे कतेको बेर हम अहाँ सभक लग अयबाक योजना बनौने छलहुँ, जाहि सँ जहिना दोसर गैर-यहूदी सभक बीच हम फलदायक काज कऽ सकलहुँ, तहिना अहूँ सभक बीच कऽ सकी, मुदा एखन तक ओहि योजना मे कोनो ने कोनो बाधा अबैत रहल अछि। ");
INSERT INTO mai_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","हमरा यूनानी आ गैर-यूनानी सभक प्रति, और ज्ञानी आ अज्ञानी सभक प्रति एक दायित्‍व निर्वाह करबाक अछि। ");
INSERT INTO mai_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","एहि लेल हम रोम मे सेहो अहाँ सभक बीच यीशु मसीहक शुभ समाचारक प्रचार करबाक लेल उत्‍सुक छी। ");
INSERT INTO mai_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","हम ई शुभ समाचार सुनाबऽ सँ लज्‍जित नहि होइत छी, किएक तँ ई शुभ समाचार ओ माध्‍यम अछि जाहि द्वारा परमेश्‍वर अपना सामर्थ्‍य सँ प्रत्‍येक विश्‍वास कयनिहार लोकक उद्धार करैत छथि, पहिने यहूदी सभक आ फेर आन जातिक लोक सभक। ");
INSERT INTO mai_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","एहि शुभ समाचार मे परमेश्‍वरक ओ योजना प्रगट होइत अछि जाहि योजना द्वारा ओ अपना नजरि मे लोक केँ धार्मिक ठहरबैत छथि, आ ई धार्मिकता शुरू सँ अन्‍त तक विश्‍वास पर आधारित अछि, जेना धर्मशास्‍त्र मे लिखल अछि जे, “जे विश्‍वास द्वारा धार्मिक ठहराओल गेल अछि, से जीवन प्राप्‍त करत।” ");
INSERT INTO mai_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","परमेश्‍वरक क्रोध ओहन लोक सभक सभ प्रकारक अधर्म आ दुष्‍टता पर स्‍वर्ग सँ प्रगट भऽ रहल अछि जे सभ अपना दुष्‍टता द्वारा सत्‍य केँ झाँपि कऽ रखने अछि। ");
INSERT INTO mai_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","कारण, परमेश्‍वरक सम्‍बन्‍ध मे जे किछु जानल जा सकैत अछि से ओकरा सभ पर स्‍पष्‍ट रूप सँ प्रगट भेल अछि। परमेश्‍वर अपने ओकरा सभ पर एहि बात केँ प्रगट कऽ देने छथिन। ");
INSERT INTO mai_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","किएक तँ परमेश्‍वरक अदृश्‍य गुण, अर्थात् हुनकर अनन्‍त कालीन शक्‍ति आ ईश्‍वरीय स्‍वभाव, संसारक सृष्‍टिएक समय सँ हुनका रचना मे साफ-साफ देखाइ दैत अछि। तेँ ओकरा सभ केँ अपन आचरणक सफाइ देबाक कोनो बहाना नहि चलतैक। ");
INSERT INTO mai_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","किएक तँ ओ सभ परमेश्‍वर केँ जनितो ने हुनका परमेश्‍वर मानि कऽ समुचित आदर कयलकनि आ ने हुनका धन्‍यवाद देलकनि। ओ सभ निरर्थक कल्‍पना सभ मे पड़ि गेल आ ओकरा सभक विवेकहीन मोन अन्‍हार सँ भरि गेलैक। ");
INSERT INTO mai_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ओ सभ अपना केँ बुद्धिमान बुझलक मुदा मूर्ख बनि गेल। ");
INSERT INTO mai_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ओ सभ अविनाशी परमेश्‍वरक वैभव आ महानताक स्‍थान पर नाशवान मनुष्‍य, चिड़ै-चुनमुन, चौपाया जानबर आ साँपक आकार मे बनाओल मूर्ति सभ केँ परमेश्‍वरक समतुल्‍य मानि अपनौलक। ");
INSERT INTO mai_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","एहि लेल परमेश्‍वर ओकरा सभ केँ ओकर अपन हृदयक काम-वासनाक अशुद्धता मे छोड़ि देलथिन जाहि सँ आपस मे ओ सभ अपना शरीर केँ अपवित्र करऽ लागल। ");
INSERT INTO mai_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ओ सभ परमेश्‍वरक सत्‍यक बदला झूठ केँ अपनौलक आ सृष्‍टि कयल वस्‍तु सभक पूजा आ सेवा कयलक—नहि कि ओहि सृष्‍टिकर्ताक, जे सर्वदा धन्‍य छथि। आमीन। ");
INSERT INTO mai_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","यैह कारण अछि जे परमेश्‍वर ओकरा सभ केँ नीच वासना सभ मे छोड़ि देलथिन। ओकरा सभक स्‍त्रिओ स्‍वभाविक सम्‍बन्‍धक स्‍थान पर अस्‍वभाविक सम्‍बन्‍ध राखऽ लागलि। ");
INSERT INTO mai_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","एही तरहेँ पुरुष सभ सेहो स्‍त्रीक संग होमऽ वला स्‍वभाविक सम्‍बन्‍ध केँ छोड़ि पुरुषक संग वला काम-वासनाक लेल उत्तेजित होमऽ लागल। पुरुष पुरुषेक संग निर्लज्‍ज कर्म कऽ अपने व्‍यक्‍तित्‍व मे अपन दुराचरणक उचित फल पौलक। ");
INSERT INTO mai_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","एहि तरहेँ ओ सभ जखन परमेश्‍वरक सत्‍य-ज्ञान केँ रखनाइ महत्‍वपूर्ण नहि बुझलक तँ परमेश्‍वर ओकरा सभ केँ भ्रष्‍ट मोनक वश मे छोड़ि देलथिन जाहि सँ ओ सभ अनुचित काज करय, ");
INSERT INTO mai_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","30","और तेँ ओ सभ हर प्रकारक अधर्म, दुष्‍टता, लोभ, द्वेष आ ईर्ष्‍या, हत्‍या, झगड़ा, छल-कपट आ डाह सँ भरि गेल अछि। ओ सभ चुगली लगौनिहार, निन्‍दा कयनिहार, परमेश्‍वर सँ घृणा कयनिहार, जिद्दी, घमण्‍डी और अहंकारी अछि। ओ सभ अधलाह काज करबाक नव-नव तरीका सभ गढ़ैत रहैत अछि, माय-बाबूक आज्ञाक उल्‍लंघन करैत अछि, ");
INSERT INTO mai_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ओ सभ विवेकहीन, विश्‍वासघाती, प्रेम-शुन्‍य और निर्दयी भऽ गेल अछि। ");
INSERT INTO mai_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ओ सभ परमेश्‍वरक ई उचित फैसला जनैत अछि जे एहन काज कयनिहार मृत्‍युदण्‍ड पयबाक जोगरक अछि, तैयो ओ सभ मात्र अपने नहि एहन काज करैत अछि, बल्‍कि एहन काज कयनिहार लोक सभक समर्थन सेहो करैत अछि। ");
INSERT INTO mai_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","तेँ यौ दोष लगौनिहार, अहाँ जे केओ होइ, निरुत्तर छी, किएक तँ जाहि बात मे अहाँ अनका पर दोष लगबैत छी ताही मे अहाँ अपने केँ दोषी ठहरबैत छी, कारण, जे दोष अहाँ अनका पर लगबैत छी सैह काज अपनो करैत छी। ");
INSERT INTO mai_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","और अपना सभ जनैत छी जे एहन अधलाह काज कयनिहार लोक सभ पर परमेश्‍वरक दिस सँ दण्‍डक आज्ञा उचिते होइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","यौ जी, अहाँ दोसर पर जे एहन काज करबाक दोष लगबैत छी आ स्‍वयं वैह काज करैत छी, तँ की अहाँ सोचैत छी जे अहाँ परमेश्‍वरक दण्‍डक आज्ञा सँ बाँचि जायब? ");
INSERT INTO mai_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","वा की अहाँ परमेश्‍वरक असीम कृपा, सहनशीलता आ धैर्य केँ तुच्‍छ मानैत छी आ ई नहि जनैत छी जे परमेश्‍वर अपना कृपा द्वारा अहाँ केँ अपना पापक लेल पश्‍चात्ताप कऽ कऽ हृदय-परिवर्तन करबाक अवसर दऽ रहल छथि? ");
INSERT INTO mai_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","मुदा अपन जिद्दीपन आ अपरिवर्तित हृदयक कारणेँ अहाँ अपना लेल परमेश्‍वरक प्रकोप केँ ओहि दिनक लेल संचित कऽ रहल छी जहिया परमेश्‍वरक प्रकोप आ उचित न्‍याय प्रगट होयत। ");
INSERT INTO mai_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","परमेश्‍वर “प्रत्‍येक मनुष्‍य केँ ओकर काजक अनुरूप फल देथिन।” ");
INSERT INTO mai_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","जे लोक सभ धैर्यपूर्बक सत्‍कर्म करैत रहि कऽ परमेश्‍वर सँ देल सम्‍मान, आदर और अमरत्‍वक खोज मे लागल रहैत अछि तकरा परमेश्‍वर अनन्‍त जीवन देथिन। ");
INSERT INTO mai_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","मुदा जे केओ स्‍वार्थी लालसा सभक वश मे रहैत अछि आ सत्‍य केँ स्‍वीकार नहि करैत अछि, बल्‍कि अधर्म पर चलैत अछि, तकरा पर परमेश्‍वरक दण्‍ड आ क्रोध बरसत। ");
INSERT INTO mai_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","दुष्‍कर्म कयनिहार प्रत्‍येक मनुष्‍य पर कष्‍ट आ संकट आओत, पहिने यहूदी पर आ फेर आन जातिक लोक पर। ");
INSERT INTO mai_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","मुदा सत्‍कर्म कयनिहार प्रत्‍येक मनुष्‍य केँ सम्‍मान, आदर आ शान्‍ति भेटतैक, पहिने यहूदी केँ आ फेर आन जातिक लोक केँ। ");
INSERT INTO mai_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","किएक तँ परमेश्‍वर ककरो संग पक्षपात नहि करैत छथि। ");
INSERT INTO mai_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ओ लोक, जकरा लग मूसा द्वारा देल गेल धर्म-नियम नहि छलैक आ ओहि अवस्‍था मे पाप कयलक से सभ बिनु धर्म-नियमक आधार पर नाश होयत, और ओ लोक, जकरा लग धर्म-नियम छलैक आ पाप कयलक तकर न्‍याय धर्म-नियमक अनुरूप कयल जयतैक। ");
INSERT INTO mai_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","किएक तँ परमेश्‍वरक समक्ष ओ सभ धार्मिक नहि ठहरत जे सभ धर्म-नियमक सुननिहार अछि, बल्‍कि वैह सभ धार्मिक ठहराओल जायत जे सभ धर्म-नियमक पालन कयनिहार अछि। ");
INSERT INTO mai_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","जखन गैर-यहूदी लोक, जकरा सभ केँ धर्म-नियम नहि भेटलैक, से सभ स्‍वभाव सँ धर्म-नियमक बात सभ पर चलैत अछि तखन ई बात प्रमाणित होइत अछि जे, ओना तँ मूसा केँ देल गेल धर्म-नियम ओकरा सभ लग नहि अछि, तैयो ओकरा सभक भीतर एकटा नियम अछि— ");
INSERT INTO mai_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ओकरा सभक आचरण सँ ई स्‍पष्‍ट देखाइ दैत अछि जे, धर्म-नियमक आदेश ओकरा सभक हृदय पर लिखल छैक। ओकर सभक भितरी मोन ओकरा सभ केँ कखनो दोषी तँ कखनो निर्दोष ठहरा कऽ एहि बातक गवाही सेहो दैत अछि। ");
INSERT INTO mai_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ई बात सभ ओहि दिन स्‍पष्‍ट होयत जहिया हमर एहि शुभ समाचारक कथन अनुसार परमेश्‍वर यीशु मसीहक द्वारा लोक सभक गुप्‍त बात सभक न्‍याय करताह। ");
INSERT INTO mai_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","अहाँ सभ, जे सभ यहूदी कहबैत छी, धर्म-नियम पर भरोसा रखैत छी आ परमेश्‍वरक लोक होयबाक घमण्‍ड करैत छी। ");
INSERT INTO mai_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","परमेश्‍वरक इच्‍छाक ज्ञान अहाँ सभ केँ अछि और धर्म-नियमक शिक्षा पयबाक कारणेँ उत्तम बातक मोल जनैत छी। ");
INSERT INTO mai_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","अहाँ सभक धारणा अछि जे, अहाँ सभ आन्‍हर सभक लेल बाट देखौनिहार, अन्‍हार मे रहनिहार सभक लेल इजोत, ");
INSERT INTO mai_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","मूर्ख सभ केँ बुझौनिहार, और अज्ञानी सभक गुरु छी, किएक तँ अहाँ सभ केँ धर्म-नियमक द्वारा सम्‍पूर्ण ज्ञान आ सत्‍य प्राप्‍त भऽ गेल अछि। ");
INSERT INTO mai_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","मुदा एकटा बात, अहाँ सभ जे अनका शिक्षा दैत छिऐक, की अपनो केँ शिक्षा दैत छी? अहाँ सभ उपदेश दैत छी जे चोरी नहि करू, की अपने चोरी करैत छी? ");
INSERT INTO mai_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","अहाँ जे कहैत छी जे, परस्‍त्रीगमन नहि करू, की अहाँ करैत छी? अहाँ सभ मूर्ति सभ सँ घृणा करैत छी, की अहाँ सभ मन्‍दिर सभक धन केँ लुटैत छी? ");
INSERT INTO mai_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","अहाँ सभ धर्म-नियम पर घमण्‍ड करैत छी, की अहाँ सभ धर्म-नियमक उल्‍लंघन कऽ कऽ परमेश्‍वरक अपमान करैत छियनि? ");
INSERT INTO mai_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","जेना कि धर्मशास्‍त्र मे लिखल अछि, “तोरा सभक कारणेँ अन्‍य जातिक बीच मे परमेश्‍वरक नामक निन्‍दा भऽ रहल अछि।” ");
INSERT INTO mai_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","धर्म-नियमक अनुरूप कयल जाय वला विधि, खतना, सँ तखने लाभ होइत अछि जखन अहाँ धर्म-नियमक पालन करैत छी। जँ अहाँ धर्म-नियमक उल्‍लंघन करैत छी तँ अहाँक खतना करौनाइ बेकार अछि। ");
INSERT INTO mai_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","एही तरहेँ, जँ बिनु खतना कराओल कोनो व्‍यक्‍ति धर्म-नियमक पालन करैत अछि, तँ की ओ तैयो खतना कराओल व्‍यक्‍ति नहि मानल जायत? ");
INSERT INTO mai_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","एतबे नहि—ओहन मनुष्‍य जकरा शारीरिक रूप मे खतना नहि कयल गेल छैक, जँ धर्म-नियम पर चलैत अछि तँ ओ अहाँ केँ, जे लिखित रूप मे धर्म-नियम पाबि कऽ और खतना कराइओ कऽ धर्म-नियमक उल्‍लंघन करैत छी, दोषी ठहराओत। ");
INSERT INTO mai_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","असल यहूदी ओ नहि, जे मात्र बाहरी रूप सँ यहूदी देखाइ दैत अछि। तहिना असल खतना ओ नहि, जे मात्र शरीर मे बाहरी चेन्‍ह अछि। ");
INSERT INTO mai_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","असल यहूदी तँ ओ अछि जे मोन सँ यहूदी अछि, और असल खतना वैह अछि जे हृदय पर कयल गेल अछि। एहन खतना लिखित धर्म-नियम पर निर्भर नहि रहैत अछि, बल्‍कि पवित्र आत्‍मा द्वारा कयल जाइत अछि। एहन लोकक प्रशंसा मनुष्‍यक दिस सँ नहि, बल्‍कि परमेश्‍वरक दिस सँ होइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","तखन यहूदी भेला सँ की लाभ? वा खतना करौला सँ की लाभ? ");
INSERT INTO mai_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","हर तरहेँ बहुत लाभ! पहिल बात तँ ई जे, परमेश्‍वरक वचन यहूदी सभ केँ जिम्‍मा देल गेलैक। ");
INSERT INTO mai_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","जँ ओकरा सभ मे सँ किछु लोक विश्‍वास नहि कयलक तँ तकर मतलब की भेल? की ओकरा सभक अविश्‍वास कयनाइ परमेश्‍वरक विश्‍वासयोग्‍यता केँ व्‍यर्थ ठहराओत? ");
INSERT INTO mai_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","किन्‍नहुँ नहि! चाहे प्रत्‍येक मनुष्‍य झुट्ठा निकलय, मुदा परमेश्‍वर सत्‍य प्रमाणित होयताह, जेना कि धर्मशास्‍त्र मे लिखल अछि, “...जाहि सँ अहाँ अपना बात मे सत्‍य प्रमाणित होयब आ अहाँक फैसलाक जाँच भेला पर विजयी होयब।” ");
INSERT INTO mai_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","मुदा जँ हमरा सभक दुष्‍टता परमेश्‍वरक धार्मिकता केँ प्रदर्शित करैत अछि, तँ एना मे हम सभ की ई कही जे परमेश्‍वर जखन हमरा सभ पर क्रोध प्रगट करैत छथि तँ ओ अन्‍याय करैत छथि? ई बात हम मानवीय सोचक अनुरूप कहि रहल छी। ");
INSERT INTO mai_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ओ किन्‍नहुँ नहि अन्‍याय करैत छथि! जँ ओ अन्‍यायी होइतथि तँ संसारक न्‍याय कोना करितथि? ");
INSERT INTO mai_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","केओ शायद ई कहत जे, जँ हमरा झूठ सँ परमेश्‍वरक सत्‍यता आरो स्‍पष्‍ट रूप सँ देखाइ पड़ैत अछि आ एहि कारणेँ हुनकर गुणगान बढ़ैत छनि तँ पापी जकाँ हम किएक दण्‍डक योग्‍य ठहराओल जा रहल छी? ");
INSERT INTO mai_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ई तँ तेहने बात कहनाइ जकाँ भेल जे हम सभ अधलाहे किएक ने करी जाहि सँ नीक उत्‍पन्‍न होअय? किछु लोक हमरा सभक निन्‍दा करैत आरोप लगबैत अछि जे हम सभ एहने बात सभ सिखबैत छी। एहन लोक सभ केँ दण्‍ड भेटनाइ उचित अछि। ");
INSERT INTO mai_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","तखन एहि बातक मतलब की भेल? की हम सभ, जे यहूदी छी, आन लोकक अपेक्षा श्रेष्‍ठ छी? बिलकुल नहि! हम पहिनहि यहूदी आ आन जातिक लोक, दूनू पर दोष लगा चुकल छी जे ओ सभ केओ पापक अधीन अछि। ");
INSERT INTO mai_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","जेना कि धर्मशास्‍त्र मे लिखल अछि जे, “कोनो मनुष्‍य धार्मिक नहि अछि, एको गोटे नहि। ");
INSERT INTO mai_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","कोनो मनुष्‍य बुझनिहार नहि अछि। एको गोटे तेहन नहि अछि जे परमेश्‍वर केँ खोजैत होअय। ");
INSERT INTO mai_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","सभ केओ भटकि गेल अछि, सभ केओ भ्रष्‍ट भऽ गेल अछि। केओ नीक काज नहि करैत अछि, एको गोटे नहि।” ");
INSERT INTO mai_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“ओकर सभक कण्‍ठ खुजल कबर जकाँ छैक, ओकरा सभक मुँह मे छल-कपट छैक” आ “ठोर मे साँपक विष भरल छैक।” ");
INSERT INTO mai_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“ओकर सभक मुँह सराप आ कटुता सँ भरल छैक।” ");
INSERT INTO mai_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“ओकर सभक पयर खून करबाक लेल दौड़ैत छैक। ");
INSERT INTO mai_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ओ सभ जतऽ-कतौ जाइत अछि ततऽ विनाश आ दुःख लऽ जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ओ सभ शान्‍तिक बाट सँ अपरिचित अछि।” ");
INSERT INTO mai_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“ओकरा सभक मोन मे परमेश्‍वरक डर-भय नहि छैक।” ");
INSERT INTO mai_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","अपना सभ जनैत छी जे, धर्म-नियम जे बात कहैत अछि से ओकरे सभ केँ कहैत अछि जकरा सभ केँ धर्म-नियम देल गेल अछि। एहि तरहेँ सभक मुँह बन्‍द भऽ गेल अछि आ परमेश्‍वरक सम्‍मुख सम्‍पूर्ण संसार दण्‍डक योग्‍य ठहरि गेल अछि। ");
INSERT INTO mai_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","किएक तँ धर्म-नियमक पालन कयला सँ कोनो मनुष्‍य परमेश्‍वरक नजरि मे धार्मिक नहि ठहरत, बल्‍कि धर्म-नियमक माध्‍यम सँ मनुष्‍य केँ अपन पापक ज्ञान होइत छैक। ");
INSERT INTO mai_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","मुदा आब परमेश्‍वर अपना दिस सँ एकटा तेहन धार्मिकता प्रगट कयने छथि जे धर्म-नियम पर निर्भर नहि अछि, आ जाहि सम्‍बन्‍ध मे धर्म-नियम आ परमेश्‍वरक प्रवक्‍ता सभक लेख गवाही सेहो देने अछि। ");
INSERT INTO mai_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","प्रगट भेल धार्मिकता ई अछि जे परमेश्‍वर विश्‍वासक आधार पर तकरा सभ गोटे केँ धार्मिक ठहरबैत छथि जे सभ यीशु मसीह पर विश्‍वास करैत अछि। ककरो मे कोनो भेद नहि— ");
INSERT INTO mai_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","सभ केओ पाप कयने अछि आ परमेश्‍वरक महिमा तक पहुँचऽ मे चुकि जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","मुदा परमेश्‍वर अपना खुशी सँ दानक रूप मे विश्‍वास कयनिहार सभ केँ ओहि छुटकाराक माध्‍यम सँ धार्मिक ठहरबैत छथि जे छुटकारा ओ मसीह यीशु द्वारा पूरा कयलनि। ");
INSERT INTO mai_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","परमेश्‍वर यीशु मसीह केँ मनुष्‍यक पापक प्रायश्‍चित्त करऽ वला बलिदानक रूप मे संसार मे प्रस्‍तुत कयलनि, जाहि बलिदानक बहाओल खून पर विश्‍वास कयला सँ मनुष्‍य केँ पाप सँ मुक्‍ति भेटैत छैक। एहि तरहेँ परमेश्‍वर अपन उचित न्‍याय केँ प्रमाणित कयलनि, किएक तँ ओ अपन सहनशीलताक अनुरूप पूर्व समय मे कयल गेल पाप सभ केँ दण्‍डित नहि कऽ ओहिना छोड़ने छलाह। ");
INSERT INTO mai_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","वर्तमान समय मे परमेश्‍वर अपन उचित न्‍याय प्रमाणित कऽ ई बात प्रगट कयलनि जे ओ स्‍वयं न्‍यायी छथि आ ओहि सभ लोक केँ धार्मिक ठहरबैत छथि जे सभ यीशु मसीह पर विश्‍वास करैत अछि। ");
INSERT INTO mai_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","तखन घमण्‍ड करऽ वला बात कतऽ रहल? ओकर तँ कोनो स्‍थाने नहि अछि। कोन कारणेँ? की एहि कारणेँ जे धर्म-नियम केँ पालन नहि कऽ सकलहुँ? नहि, बल्‍कि एहि कारणेँ जे सभ बात आब विश्‍वासे पर निर्भर अछि। ");
INSERT INTO mai_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","तेँ हम सभ ई कहैत छी जे मनुष्‍य धर्म-नियमक पालन कयला सँ नहि, बल्‍कि विश्‍वासक कारणेँ धार्मिक ठहरैत अछि। ");
INSERT INTO mai_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","की परमेश्‍वर मात्र यहूदी सभक परमेश्‍वर छथि? की ओ आन जाति सभक परमेश्‍वर नहि छथि? हँ, ओ आन जाति सभक परमेश्‍वर सेहो छथि। ");
INSERT INTO mai_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","किएक तँ परमेश्‍वर एके छथि। ओ यहूदी सभ केँ ओकरा सभक विश्‍वासक आधार पर, आ अन्‍य जातिक लोक सभ केँ ओकरा सभक विश्‍वासक आधार पर धार्मिक ठहरौताह। ");
INSERT INTO mai_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","तखन की, हम सभ विश्‍वास पर जोर दऽ कऽ धर्म-नियम केँ आब बेकार ठहरबैत छी? किन्‍नहुँ नहि! बल्‍कि धर्म-नियम केँ समर्थन करैत छी। ");
INSERT INTO mai_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","आब हम सभ अपन पूर्वज अब्राहमक विषय मे की कही? धार्मिक ठहराओल जयबाक सम्‍बन्‍ध मे हुनका की अनुभव भेलनि? ");
INSERT INTO mai_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","जँ अब्राहम अपन कर्म द्वारा धार्मिक ठहराओल गेलाह तँ ओ अपना पर घमण्‍ड कऽ सकैत छलाह, मुदा परमेश्‍वरक सम्‍मुख हुनका घमण्‍ड करबाक कोनो आधार नहि छलनि, ");
INSERT INTO mai_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","किएक तँ धर्मशास्‍त्र मे ई लिखल अछि जे, “अब्राहम परमेश्‍वरक बातक विश्‍वास कयलनि आ ई विश्‍वास हुनका लेल धार्मिकता मानल गेलनि।” ");
INSERT INTO mai_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","काज कयनिहार केँ जखन मजदूरी देल जाइत अछि, तँ ई नहि मानल जाइत अछि जे ओकरा पर कृपा कयल गेलैक, बल्‍कि ई ओकर अधिकार छलैक। ");
INSERT INTO mai_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","मुदा जे व्‍यक्‍ति अपना काज पर भरोसा नहि रखैत अछि, बल्‍कि ओहि परमेश्‍वर पर विश्‍वास करैत अछि जे पापी सभ केँ धार्मिक ठहरबैत छथि, ताहि व्‍यक्‍ति केँ विश्‍वासक आधार पर परमेश्‍वर ओकरा धार्मिक मानैत छथि ⌞आ ई कृपाक बात अछि⌟। ");
INSERT INTO mai_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","एही तरहेँ धर्मशास्‍त्र मे दाऊद ओहन मनुष्‍य केँ धन्‍य कहैत छथि जकरा परमेश्‍वर बिनु कर्मक आधार पर धार्मिक मानैत छथिन— ");
INSERT INTO mai_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“धन्‍य अछि ओ सभ जकर सभक अपराध क्षमा भऽ गेल आ जकर सभक पाप झाँपि देल गेलैक। ");
INSERT INTO mai_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","धन्‍य अछि ओ मनुष्‍य जकर पापक लेखा प्रभु नहि लेथिन।” ");
INSERT INTO mai_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","की ई आशिष खतना कराओल लोक सभक लेल मात्र अछि वा तकरो सभक लेल जकरा सभक खतना नहि भेल अछि? हम सभ तँ कहैत आयल छी जे, “अब्राहमक विश्‍वास हुनका लेल धार्मिकता मानल गेलनि।” ");
INSERT INTO mai_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","तँ हुनकर विश्‍वास कोन स्‍थिति मे धार्मिकता मानल गेलनि—हुनकर खतना होमऽ सँ पहिने वा भेलाक बाद? खतना भेलाक बाद नहि, बल्‍कि पहिने! ");
INSERT INTO mai_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","हुनकर खतना जखन नहि भेल छलनि, ताहि समय मे विश्‍वास द्वारा जे धार्मिकता प्राप्‍त भेल छलनि ताहि पर छाप स्‍वरूप खतनाक चिन्‍ह बाद मे लगाओल गेलनि। एहि तरहेँ ओ ओहू लोक सभक पिता भेलाह जे सभ बिनु खतना करौने विश्‍वास करैत अछि, जाहि सँ ओकरो सभक विश्‍वास ओकरा सभक लेल धार्मिकता मानल जाइक। ");
INSERT INTO mai_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","अब्राहम ओहि खतना करौनिहार लोक सभक पिता सेहो छथि जे सभ मात्र खतने नहि करौने अछि, बल्‍कि हमरा सभक पिता अब्राहमक ओही विश्‍वासक पद-चिन्‍ह पर सेहो चलैत अछि, जे विश्‍वास खतना होमऽ सँ पहिने हुनका मे छलनि। ");
INSERT INTO mai_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","अब्राहम आ हुनका वंश केँ जे वचन देल गेल छल जे ओ पृथ्‍वीक उत्तराधिकारी होयताह, से वचन हुनका एहि लेल नहि देल गेल जे ओ धर्म-नियमक पालन कयलनि, बल्‍कि एहि लेल जे ओ विश्‍वास कयलनि आ परमेश्‍वर हुनका धार्मिक मानलथिन। ");
INSERT INTO mai_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","जँ वैह सभ उत्तराधिकारी बनैत अछि जे सभ धर्म-नियमक अधीन रहैत अछि, तँ विश्‍वास कयनाइ बेकार अछि आ परमेश्‍वर जे वचन देलनि से निरर्थक भऽ जाइत अछि, ");
INSERT INTO mai_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","किएक तँ धर्म-नियम परमेश्‍वरक प्रकोपे उत्‍पन्‍न करैत अछि, आ जतऽ नियम अछिए नहि, मात्र ततहि आज्ञाक उल्‍लंघन नहि पाओल जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","एहि कारणेँ परमेश्‍वरक वचनक पूर्तिक आधार अछि मनुष्‍यक विश्‍वास, जाहि सँ सम्‍पूर्ण बात परमेश्‍वरक दिस सँ कृपाक रूप मे रहय आ हुनकर वचन अब्राहमक सभ वंशजक लेल अटल होअय—मात्र तकरे सभक लेल नहि, जकरा सभ केँ धर्म-नियम भेटल छैक, बल्‍कि ओहि सभ लोकक लेल, जे सभ अब्राहम सनक विश्‍वास रखैत अछि। अब्राहम अपना सभ गोटेक पिता छथि, ");
INSERT INTO mai_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","जेना कि लिखल अछि जे, “हम तोरा बहुतो जाति सभक पिता बनौने छिअह।” परमेश्‍वरक दृष्‍टि मे अब्राहम अपना सभक पिता छथि। ओ ओहि परमेश्‍वर पर विश्‍वास कयलनि जे मुइल सभ केँ जिअबैत छथि और जे वस्‍तु अस्‍तित्‍व मे अछिए नहि तकरा अस्‍तित्‍व मे अनैत छथि। ");
INSERT INTO mai_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","जाहि परिस्‍थिति मे कोनो आशा नहि राखल जा सकैत छल, ताहू मे अब्राहम आशा राखि विश्‍वास कयलनि और तहिना बहुतो जातिक पिता बनि गेलाह, जेना कि हुनका कहल गेल छलनि जे, “तोहर वंशज असंख्‍य होयतह।” ");
INSERT INTO mai_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","हुनकर उमेर लगभग एक सय वर्षक भऽ गेल छलनि आ ओ जनैत छलाह जे हमर शरीर सँ आब किछु नहि होयत आ ओ इहो जनैत छलाह जे सारा केँ बच्‍चा होयब असम्‍भवे छनि। ");
INSERT INTO mai_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","तैयो ओ परमेश्‍वरक वचन पर कनेको सन्‍देह नहि कयलनि, बल्‍कि विश्‍वास मे आओर दृढ़ भऽ कऽ परमेश्‍वरक स्‍तुति कयलनि। ");
INSERT INTO mai_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","हुनका पक्‍का विश्‍वास छलनि जे जाहि बातक वचन परमेश्‍वर देने छथि तकरा पूरा करऽ मे ओ सामर्थ्‍यवान छथि। ");
INSERT INTO mai_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","एही विश्‍वासक कारणेँ ओ धार्मिक मानल गेलाह। ");
INSERT INTO mai_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","24","धर्मशास्‍त्रक ई शब्‍द जे, “विश्‍वासक आधार पर ओ धार्मिक मानल गेलाह,” मात्र अब्राहमेक लेल नहि, बल्‍कि अपनो सभक लेल लिखल गेल अछि। अपनो सभ केँ परमेश्‍वर धार्मिक मानताह—अपना सभ केँ, जे सभ ओहि परमेश्‍वर पर विश्‍वास करैत छी जे अपना सभक प्रभु, यीशु केँ, मुइल सभ मे सँ जीवित कयलथिन। ");
INSERT INTO mai_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","यीशु मसीह केँ अपना सभक पापक कारणेँ मृत्‍युदण्‍ड देल गेल छलनि आ अपना सभ केँ धार्मिक ठहरयबाक लेल जिआओल गेलनि। ");
INSERT INTO mai_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","एहि तरहेँ विश्‍वास सँ धार्मिक ठहराओल जयबाक कारणेँ प्रभु यीशु मसीहक द्वारा परमेश्‍वर सँ अपना सभक मेल भेल अछि। ");
INSERT INTO mai_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","यैह यीशु मसीह अपना सभ केँ परमेश्‍वरक संग एहि नव सम्‍बन्‍ध मे अनने छथि जे सम्‍बन्‍ध हुनका कृपा पर आधारित अछि आ जाहि सम्‍बन्‍ध मे अपना सभ स्‍थिर छी। और परमेश्‍वरक महिमा मे सहभागी होयबाक आशा मे आनन्‍दित छी। ");
INSERT INTO mai_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","एतबे नहि, बल्‍कि कष्‍टक समय सभ मे सेहो आनन्‍दित होइत छी, किएक तँ अपना सभ जनैत छी जे कष्‍ट सँ धैर्य उत्‍पन्‍न होइत अछि, ");
INSERT INTO mai_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","धैर्य सँ सच्‍चरित्रता आ सच्‍चरित्रता सँ आशा उत्‍पन्‍न होइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","और ई आशा अपना सभ केँ निराश नहि होमऽ दैत अछि, किएक तँ परमेश्‍वर अपन पवित्र आत्‍मा जे अपना सभ केँ देने छथि, तिनका द्वारा अपन प्रेम अपना सभक हृदय मे भरि देने छथि। ");
INSERT INTO mai_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","सोचू! अपना सभ जखन असहाये छलहुँ तहिए निर्धारित समय पर मसीह अधर्मी सभक लेल मरलाह। ");
INSERT INTO mai_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","दुर्लभ बात अछि जे कोनो धार्मिको मनुष्‍यक लेल केओ अपन प्राण दिअय। हँ, कोनो नीक मनुष्‍यक लेल केओ मरबाक साहस कैओ लिअय। ");
INSERT INTO mai_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","मुदा परमेश्‍वर अपना प्रेम केँ अपना सभक प्रति एहि तरहेँ देखबैत छथि जे, जखन अपना सभ पापिए छलहुँ तखने मसीह अपना सभक लेल मरलाह। ");
INSERT INTO mai_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","तेँ जखन अपना सभ मसीहक खून द्वारा एखन धार्मिक ठहराओल गेलहुँ तँ निश्‍चय अपना सभ हुनका द्वारा परमेश्‍वरक दण्‍ड सँ सेहो बँचाओल जायब। ");
INSERT INTO mai_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","किएक तँ जखन शत्रुताक अवस्‍था मे परमेश्‍वरक संग मेल-मिलाप हुनका पुत्रक मृत्‍यु द्वारा भऽ गेल, तखन मेल-मिलाप भऽ गेला पर हुनका पुत्रक जीवन द्वारा अपना सभक उद्धार किएक नहि होयत? ");
INSERT INTO mai_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","एतबे नहि! अपना प्रभु यीशु मसीहक कारणेँ अपना सभ परमेश्‍वर मे आनन्‍दित सेहो छी, किएक तँ हुनके द्वारा आब परमेश्‍वर सँ मेल-मिलाप भऽ गेल अछि। ");
INSERT INTO mai_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","एके मनुष्‍यक द्वारा संसार मे पापक प्रवेश भेल आ पाप द्वारा मृत्‍युक। एहि तरहेँ मृत्‍यु सभ मनुष्‍य मे पसरि गेल, कारण, सभ केओ पाप कयने अछि। ");
INSERT INTO mai_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","धर्म-नियम जे मूसा केँ देल गेल ताहि सँ पहिने सेहो संसार मे पाप छल, मुदा जतऽ नियम नहि होइत अछि ततऽ “नियम-उल्‍लंघन”क लेखा नहि राखल जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","तैयो मृत्‍यु आदमक समय सँ लऽ कऽ मूसाक समय धरि ओहू लोक सभ पर शासन कयलक जे सभ परमेश्‍वरक आज्ञाक उल्‍लंघन करबाक द्वारा पाप नहि कयने छल, जेना आदम कयलक। आदम तिनकर प्रतीक छल जे आबऽ वला छलाह। ");
INSERT INTO mai_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","मुदा आदमक अपराध आ परमेश्‍वरक वरदान मे कोनो समानता नहि। कारण, जँ एके मनुष्‍यक अपराध सँ अनेको मनुष्‍य मरल, तँ एहि सँ कतेक बढ़ि कऽ एके मनुष्‍यक, अर्थात् यीशु मसीहक, वरदान द्वारा अनेको मनुष्‍य पर परमेश्‍वरक कृपा बरसल। ");
INSERT INTO mai_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","कहाँ ओ एक व्‍यक्‍तिक पापक परिणाम आ कहाँ ई परमेश्‍वरक वरदान!—एहि मे कोनो समानता नहि, किएक तँ एक अपराधक फलस्‍वरूप न्‍याय कयल गेल आ मनुष्‍य केँ दण्‍ड-आज्ञा भेटलैक, मुदा बहुतो अपराधक बाद जे वरदान देल गेलैक, ताहि द्वारा दोष सँ छुटकारा भेटलैक। ");
INSERT INTO mai_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","जँ एके मनुष्‍यक पापक कारणेँ ओहि मनुष्‍य द्वारा मृत्‍यु राज्‍य कयलक, तँ एहि सँ कतेक बढ़ि कऽ जकरा सभ केँ परमेश्‍वरक प्रशस्‍त कृपा आ धार्मिकताक दान भेटल छैक, से सभ एके मनुष्‍य, अर्थात् यीशु मसीह, द्वारा जीवन मे राज्‍य करत। ");
INSERT INTO mai_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","एहि तरहेँ अपना सभ देखैत छी जे, जहिना एके अपराधक फलस्‍वरूप सभ मनुष्‍य केँ दण्‍ड-आज्ञा भेटलैक, तहिना एके नीक काजक फलस्‍वरूप सभ मनुष्‍यक लेल दोष सँ छुटकारा आ जीवनक प्रबन्‍ध कयल गेल। ");
INSERT INTO mai_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","किएक तँ जाहि तरहेँ एक मनुष्‍यक आज्ञा-उल्‍लंघन सँ अनेको मनुष्‍य पापी भेल, ओही तरहेँ एक मनुष्‍यक आज्ञा-पालन सँ अनेको मनुष्‍य धार्मिक ठहराओल जायत। ");
INSERT INTO mai_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","बीच मे धर्म-नियम आबि गेला सँ पापक वृद्धि भेल, मुदा जतऽ पाप बढ़ल ततऽ परमेश्‍वरक कृपा आरो बढ़ल, ");
INSERT INTO mai_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","जाहि सँ जहिना पाप मनुष्‍य केँ मृत्‍यु दऽ कऽ शासन करैत छल, तहिना परमेश्‍वरक कृपा मनुष्‍य केँ धार्मिक ठहरा कऽ शासन करय, जकर फल अपना सभक प्रभु यीशु मसीह द्वारा अनन्‍त जीवन अछि। ");
INSERT INTO mai_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","तखन की, अपना सभ आओर पाप करैत रही जाहि सँ परमेश्‍वर आओर कृपा करथि? ");
INSERT INTO mai_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","किन्‍नहुँ नहि! अपना सभ जे पापक लेखेँ मरि गेल छी, आब पाप मे जीवन कोना व्‍यतीत करब? ");
INSERT INTO mai_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","की अहाँ सभ ई नहि जनैत छी जे, अपना सभ गोटे जे बपतिस्‍मा लऽ कऽ मसीह यीशु मे सहभागी भेलहुँ से हुनका मृत्‍यु मे सेहो सहभागी भेलहुँ? ");
INSERT INTO mai_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","तेँ अपना सभ बपतिस्‍मा द्वारा हुनका मृत्‍यु मे सहभागी भऽ हुनका संग गाड़ल सेहो गेल छी जाहि सँ जहिना यीशु मसीह पिता परमेश्‍वरक महिमा द्वारा मुइल सभ मे सँ जिआओल गेलाह तहिना अपनो सभ एक नव जीवन जीबी। ");
INSERT INTO mai_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","जँ हुनका मृत्‍यु मे अपना सभ हुनका सँ संयुक्‍त भऽ गेल छी, तँ निश्‍चय हुनका जीबि उठनाइ मे सेहो अपना सभ हुनका सँ संयुक्‍त भऽ जायब। ");
INSERT INTO mai_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","अपना सभ केँ ई कखनो नहि बिसरबाक चाही जे अपना सभक पहिलुका स्‍वभाव हुनके संग क्रूस पर चढ़ा देल गेल, जाहि सँ अपना सभ मेहक पापपूर्ण “हम” मरि जाय आ अपना सभ फेर पापक दास नहि बनी, ");
INSERT INTO mai_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","किएक तँ मरल आदमी पर पाप केँ कोनो शक्‍ति नहि रहि जाइत छैक। ");
INSERT INTO mai_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","आब जँ अपना सभ मसीहक संग मरलहुँ तँ अपना सभ विश्‍वास करैत छी जे हुनका संग जीवित सेहो रहब। ");
INSERT INTO mai_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","किएक तँ अपना सभ जनैत छी जे मसीह मुइल सभ मे सँ जिआओल गेलाक बाद फेर कहियो नहि मरताह। आब मृत्‍यु केँ हुनका पर कोनो अधिकार नहि रहल। ");
INSERT INTO mai_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ओ जखन मरलाह तँ पाप केँ पराजित करबाक लेल सदाक लेल एके बेर मरलाह, आ जीबि उठि कऽ ओ आब परमेश्‍वरेक लेल जीबैत छथि। ");
INSERT INTO mai_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","एही तरहेँ अहाँ सभ सेहो अपना केँ पापक लेखेँ मुइल आ मसीह यीशु मे परमेश्‍वरक लेल जीवित बुझू। ");
INSERT INTO mai_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","एहि लेल आब अहाँ सभ अपन नश्‍वर शरीर मे पाप केँ राज्‍य नहि करऽ दिअ जे ओकर अभिलाषा सभक अनुसार जीवन व्‍यतीत करी। ");
INSERT INTO mai_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","अहाँ सभ अपना शरीरक अंग सभ केँ दुष्‍टताक साधनक रूप मे पाप करबाक लेल समर्पित नहि करू। बल्‍कि मृत्‍यु सँ जीवन मे लाओल लोक सभ जकाँ अपना केँ परमेश्‍वर केँ समर्पित कऽ दिअ आ शरीरक अंग सभ केँ नीक काज करबाक साधनक रूप मे परमेश्‍वर केँ अर्पित करू। ");
INSERT INTO mai_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","तखन पाप अहाँ सभ पर राज्‍य नहि कऽ पाओत, किएक तँ अहाँ सभ धर्म-नियमक अधीन नहि, बल्‍कि परमेश्‍वरक कृपाक अधीन छी। ");
INSERT INTO mai_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","तखन की? की अपना सभ जँ धर्म-नियमक अधीन नहि, बल्‍कि परमेश्‍वरक कृपाक अधीन छी, तँ एहि कारणेँ पाप करी? किन्‍नहुँ नहि! ");
INSERT INTO mai_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","की अहाँ सभ नहि जनैत छी जे जकर आज्ञा मानबाक लेल अहाँ सभ अपना केँ दासक रूप मे समर्पित करैत छी, अहाँ सभ तकरे दास छी?—ओ चाहे पापक होइ, जकर परिणाम मृत्‍यु अछि, चाहे आज्ञाकारिताक, जकर परिणाम धार्मिकता अछि। ");
INSERT INTO mai_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","परमेश्‍वर केँ धन्‍यवाद जे अहाँ सभ, जे सभ एक समय मे पापक दास छलहुँ, आब पूरा मोन सँ ओहि शिक्षाक आज्ञाकारी भऽ गेल छी जाहि मे अहाँ सभ सौंपल गेलहुँ। ");
INSERT INTO mai_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","अहाँ सभ पाप सँ मुक्‍त कयल गेलहुँ और आब धार्मिकताक दास भऽ गेल छी। ");
INSERT INTO mai_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","हम ई साधारण मानव जीवनक उदाहरण, अर्थात्‌ दास आ मालिकक उदाहरण, एहि लेल प्रयोग कऽ रहल छी जे अहाँ सभक मानवीय दुर्बलताक कारणेँ बात बुझनाइ अहाँ सभक लेल कठिन अछि। अहाँ सभ जहिना पहिने अपना शरीरक अंग केँ अशुद्धता आ अधर्मक अधीन कयने छलहुँ, जाहि सँ दुराचार बढ़ल, तहिना आब अपना शरीरक अंग केँ धार्मिकताक अधीन करू, जाहि सँ अहाँ सभ पवित्र बनी। ");
INSERT INTO mai_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","किएक तँ जखन अहाँ सभ पापक दास छलहुँ तँ धार्मिकताक नियन्‍त्रण सँ अहाँ सभ स्‍वतन्‍त्र छलहुँ। ");
INSERT INTO mai_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ओहि समय मे अहाँ सभ केँ ओहि कर्म सँ की लाभ भेल? आब ओहि बात सँ लज्‍जित होइत छी, कारण, ओकर परिणाम मृत्‍यु अछि। ");
INSERT INTO mai_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","मुदा आब अहाँ सभ पाप सँ छुटकारा पाबि परमेश्‍वरक दास बनि गेल छी, जकर फल अछि पवित्रता आ जकर परिणाम अछि अनन्‍त जीवन। ");
INSERT INTO mai_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","किएक तँ पापक मजदूरी अछि मृत्‍यु, मुदा परमेश्‍वरक वरदान अछि अनन्‍त जीवन जे अपना सभक प्रभु, मसीह यीशुक माध्‍यम सँ प्राप्‍त होइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","यौ भाइ लोकनि, अहाँ सभ तँ नियम-कानून केँ जननिहार लोक छी—की अहाँ सभ नहि जनैत छी जे तहिए तक कोनो मनुष्‍य पर कानूनक अधिकार रहैत छैक जहिया तक ओ मनुष्‍य जीवित अछि? ");
INSERT INTO mai_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","उदाहरणक लेल, विवाहित स्‍त्री तहिया धरि कानून द्वारा अपन पुरुषक बन्‍हन मे रहैत अछि जहिया धरि ओकर पुरुष जीवित छैक। जँ पुरुष मरि जाइत छैक तँ ओ विवाह-कानूनक बन्‍हन सँ मुक्‍त भऽ जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","एहि लेल, जँ ओ पतिक जीवन काल मे कोनो दोसर पुरुष सँ विवाह करैत अछि तँ ओ परपुरुषगमन करऽ वाली कहबैत अछि, मुदा जँ ओकर पति मरि जाइत छैक तँ ओ ओहि विवाह सम्‍बन्‍ध सँ मुक्‍त भऽ जाइत अछि और कोनो दोसर पुरुषक स्‍त्री बनिओ कऽ परपुरुषगमन करऽ वाली नहि होइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","एहि लेल, यौ हमर भाइ लोकनि, अहूँ सभ मसीहक शारीरिक मृत्‍यु मे सहभागी भऽ धर्म-नियमक दृष्‍टिकोण सँ मरि गेल छी, जाहि सँ कोनो दोसराक, अर्थात् यीशु मसीहक, जे मृत्‍यु मे सँ जिआओल गेलाह, तिनकर भऽ जाइ आ परमेश्‍वरक लेल फलदायक सेवा करी। ");
INSERT INTO mai_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","जखन अपना सभ अपन पापी स्‍वभावक अनुसार आचरण करैत छलहुँ, तँ पापमय लालसा सभ धर्म-नियम द्वारा प्रेरणा पाबि कऽ अपना सभक शरीरक अंग सभ मे काज करैत छल, जाहि सँ तेहन जीवन बितबैत छलहुँ जकर परिणाम मृत्‍यु अछि। ");
INSERT INTO mai_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","मुदा आब तकरा लेखेँ मरि कऽ जे एक समय मे अपना सभ केँ अपना वश मे बान्‍हि कऽ रखने छल, अर्थात् धर्म-नियम, अपना सभ ओहि सँ मुक्‍त भऽ गेल छी। आब पुरान तरीका सँ लिखित नियमक दास भऽ कऽ नहि, बल्‍कि नव तरीका सँ, जे पवित्र आत्‍माक तरीका छनि, परमेश्‍वरक सेवा करबाक लेल स्‍वतन्‍त्र भऽ गेल छी। ");
INSERT INTO mai_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","तखन, जँ पापमय लालसा सभ धर्म-नियम द्वारा प्रेरणा पबैत अछि, तँ की अपना सभ ई कही जे धर्म-नियम आ पाप दूनू एके चीज अछि? एकदम नहि! बात ई अछि जे, धर्म-नियमक अभाव मे हम पाप केँ चिन्‍हने नहि रहितहुँ। जँ धर्म-नियम नहि कहने रहैत जे, “लोभ नहि करह” तँ हम ई नहि जनितहुँ जे, लोभ अछि की। ");
INSERT INTO mai_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","एहि आज्ञा सँ मौका पाबि पाप हमरा मे सभ प्रकारक लोभ उत्‍पन्‍न कऽ देलक, कारण, नियमक अभाव मे पाप निर्जीव अछि। ");
INSERT INTO mai_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","एक समय छल जहिया धर्म-नियम नहि छल आ हम जीवित छलहुँ, मुदा जखन आज्ञा आबि गेल तँ पाप जीवित भऽ गेल आ हम मरि गेलहुँ। ");
INSERT INTO mai_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","और एहि तरहेँ जाहि आज्ञाक उद्देश्‍य छल जीवन देनाइ, से आज्ञा हमरा लेल मृत्‍युक कारण बनि गेल। ");
INSERT INTO mai_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","किएक तँ पाप आज्ञाक उपस्‍थिति सँ अवसर पाबि हमरा धोखा देलक आ ओही आज्ञा सँ हमरा मारि देलक। ");
INSERT INTO mai_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","एहि तरहेँ अपना सभ देखैत छी जे धर्म-नियम अपने पवित्र अछि और आज्ञा सेहो पवित्र, उचित आ कल्‍याणकारी अछि। ");
INSERT INTO mai_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","तखन की, जे बात कल्‍याणकारी छल, सैह हमरा लेल मृत्‍युक कारण बनि गेल? कदापि नहि! बल्‍कि जे वस्‍तु कल्‍याणकारी छल, तकरा प्रयोग कऽ कऽ पाप हमरा लेल मृत्‍युक कारण बनि गेल। एहि तरहेँ पापक वास्‍तविक स्‍वरूप प्रगट भऽ गेल आ आज्ञाक माध्‍यम सँ पाप आओर अधिक पापमय प्रमाणित भेल। ");
INSERT INTO mai_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","अपना सभ जनैत छी जे धर्म-नियम आत्‍मा सँ सम्‍बन्‍ध रखैत अछि, मुदा हम मानवीय स्‍वभावक प्रभाव मे छी आ पापक हाथेँ बिका गेल छी। ");
INSERT INTO mai_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","हम की करैत छी, से नहि बुझि पबैत छी, किएक तँ हम जे करऽ चाहैत छी से नहि करैत छी, बल्‍कि जाहि बात सँ हम घृणा करैत छी सैह करैत छी। ");
INSERT INTO mai_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","आब हम जे करैत छी, जँ से करबाक इच्‍छा हमरा नहि अछि, तँ एहि सँ स्‍पष्‍ट होइत अछि जे हम वास्‍तव मे मानैत छी जे धर्म-नियम उचित अछि। ");
INSERT INTO mai_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","तखन एहन अवस्‍था मे करऽ वला हम नहि रहलहुँ, बल्‍कि करऽ वला ओ पाप अछि जे हमरा मे वास कऽ रहल अछि। ");
INSERT INTO mai_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","किएक तँ हम जनैत छी जे हमरा मे कोनो नीक वस्‍तुक वास नहि अछि, अर्थात् हमर मानवीय स्‍वभाव मे। नीक काज करबाक इच्‍छा तँ हमरा होइत अछि, मुदा हम ओकरा कऽ नहि पबैत छी। ");
INSERT INTO mai_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","कारण, जाहि नीक काज केँ हम करऽ चाहैत छी तकरा नहि करैत छी, आ जाहि अधलाह काज केँ करऽ नहि चाहैत छी तकरे करैत रहैत छी। ");
INSERT INTO mai_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","जँ हम जे नहि करऽ चाहैत छी सैह करैत छी, तँ ओ करऽ वला हम नहि, बल्‍कि पाप अछि, जे हमरा मे वास करैत अछि। ");
INSERT INTO mai_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","एहि तरहेँ हम अपना मे ई नियम पबैत छी जे, जखन हम नीक काज करबाक इच्‍छा करैत छी तँ अधलाहे काज हमरा सँ होइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","हम अपना अन्‍तरात्‍मा मे परमेश्‍वरक धर्म-नियम केँ तँ सहर्ष स्‍वीकार करैत छी, ");
INSERT INTO mai_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","मुदा हमरा अपना शरीर मे एक दोसरे नियम काज करैत देखाइ दैत अछि, जे ताहि नियम सँ संघर्ष करैत अछि जे हमर बुद्धि स्‍वीकार करैत अछि। हमरा शरीरक अंग मे क्रियाशील ओ नियम पाप-नियम अछि और ओ हमरा अपन बन्‍दी बना लैत अछि। ");
INSERT INTO mai_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","हम कतेक अभागल मनुष्‍य छी! एहि मृत्‍युक अधीन रहऽ वला शरीर सँ हमरा के छुटकारा दियाओत? ");
INSERT INTO mai_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","परमेश्‍वरक धन्‍यवाद होनि! वैह अपना सभक प्रभु यीशु मसीहक द्वारा हमरा छुटकारा दिऔताह। अतः एक दिस तँ हम अपना बुद्धि सँ परमेश्‍वरक नियमक दास छी, मुदा दोसर दिस अपना मानवीय पाप-स्‍वभाव सँ पाप-नियमक दास छी। ");
INSERT INTO mai_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","एहि लेल, आब जे सभ मसीह यीशु मे अछि, तकरा सभक लेल कोनो दण्‍डक आज्ञा नहि अछि। ");
INSERT INTO mai_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","किएक तँ परमेश्‍वरक जीवनदायक आत्‍माक नियम मसीह यीशु द्वारा पाप आ मृत्‍युक नियम सँ हमरा स्‍वतन्‍त्र कऽ देने अछि। ");
INSERT INTO mai_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","धर्म-नियम मानवीय पाप-स्‍वभावक कारणेँ कमजोर भऽ कऽ जे काज करऽ मे असमर्थ छल, से काज परमेश्‍वर कऽ देलनि। ओ पापक प्रायश्‍चित्तक लेल अपने पुत्र केँ पठौलनि, जे पापी मनुष्‍यक समान मानव शरीर धारण कयलनि। एहि तरहेँ परमेश्‍वर मानव शरीर मे पाप केँ दण्‍डित कयलनि, ");
INSERT INTO mai_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","जाहि सँ अपना सभ मे, जे सभ मानवीय पाप-स्‍वभावक अनुसार नहि, बल्‍कि पवित्र आत्‍माक इच्‍छाक अनुसार आचरण करैत छी, धर्म-नियमक उचित माँग पूरा भऽ जाय। ");
INSERT INTO mai_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","कारण, मानवीय पाप-स्‍वभावक अनुसार चलनिहार लोक सभ ताहि बात सभ पर मोन लगबैत अछि जाहि बातक लेल पाप-स्‍वभाव इच्‍छा रखैत अछि, मुदा पवित्र आत्‍माक अनुसार चलनिहार लोक सभ ताहि बात सभ पर जे पवित्र आत्‍मा चाहैत छथि। ");
INSERT INTO mai_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","मानवीय पाप-स्‍वभावक इच्‍छा सभ पर मोन लगौनाइक परिणाम अछि मृत्‍यु, मुदा पवित्र आत्‍माक इच्‍छा पर मोन लगौनाइक परिणाम अछि जीवन आ शान्‍ति, ");
INSERT INTO mai_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","किएक तँ मानवीय पाप-स्‍वभावक सोच-विचार परमेश्‍वरक विरोधी अछि। मानवीय स्‍वभाव तँ परमेश्‍वरक नियमक अधीन नहि अछि आ ने ओकर अधीन भऽ सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","जे केओ मानवीय स्‍वभावक इच्‍छाक अनुसार आचरण करैत अछि, से परमेश्‍वर केँ प्रसन्‍न नहि कऽ सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","मुदा अहाँ सभ मानवीय स्‍वभावक अनुसार नहि, बल्‍कि परमेश्‍वरक आत्‍माक अनुसार जीबैत छी, किएक तँ अहाँ सभ मे परमेश्‍वरक आत्‍मा वास करैत छथि। और जँ ककरो मे मसीहक आत्‍मा वास नहि करैत छथि तँ ओ मसीहक नहि अछि। ");
INSERT INTO mai_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","मुदा जँ मसीह अहाँ सभ मे वास करैत छथि, तँ पापक कारणेँ अहाँ सभक शरीर मृत्‍युक अधीन मे होइतो, अहाँ सभ केँ धार्मिक ठहराओल जयबाक कारणेँ अहाँ सभक आत्‍मा जीवित अछि। ");
INSERT INTO mai_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","और जँ तिनकर आत्‍मा जे यीशु मसीह केँ मुइल सभ मे सँ जीवित कयलथिन, अहाँ सभ मे वास करैत छथि, तँ जे मसीह केँ मुइल सभ मे सँ जीवित कयलथिन से अपना आत्‍मा द्वारा, जिनकर वास अहाँ सभ मे अछि, अहाँ सभक नश्‍वर शरीर केँ सेहो जीवन प्रदान करताह। ");
INSERT INTO mai_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","एहि लेल यौ भाइ लोकनि, अपना सभ ऋणी छी, मुदा मानवीय पाप-स्‍वभावक नहि, जे ओकर इच्‍छाक अनुसार जीबी। ");
INSERT INTO mai_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","कारण, जँ अहाँ सभ मानवीय स्‍वभावक अनुरूप जीब तँ अवश्‍य मरब, मुदा जँ पवित्र आत्‍माक शक्‍ति द्वारा ताहि अधलाह काज सभक अन्‍त करब जे शरीर सँ कयल जाइत अछि तँ जीवन प्राप्‍त करब, ");
INSERT INTO mai_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","किएक तँ जे सभ परमेश्‍वरक आत्‍मा द्वारा संचालित कयल जाइत अछि, सैह सभ परमेश्‍वरक सन्‍तान अछि। ");
INSERT INTO mai_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","अहाँ सभ केँ जे आत्‍मा देल गेल छथि, से अहाँ सभ केँ फेर डेराय वला गुलाम नहि बनबैत छथि, बल्‍कि परमेश्‍वरक पुत्र बनौने छथि। ओहि आत्‍माक द्वारा अपना सभ हुनका पुकारि उठैत छियनि जे, “हे बाबूजी! हे पिता!” ");
INSERT INTO mai_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","पवित्र आत्‍मा स्‍वयं अपना सभक आत्‍मा केँ गवाही दैत छथि जे अपना सभ परमेश्‍वरक सन्‍तान छी। ");
INSERT INTO mai_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","जँ अपना सभ हुनकर सन्‍तान छी तँ उत्तराधिकारी सेहो छी—परमेश्‍वरक उत्तराधिकारी आ मसीहक संग सह-उत्तराधिकारी। कारण, जँ अपना सभ यीशु मसीहक संग दुःख सहब तँ हुनका संग महिमा मे सेहो सहभागी होयब। ");
INSERT INTO mai_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","हम ई मानैत छी जे, जे महिमा अपना सभ मे प्रगट होमऽ वला अछि तकरा तुलना मे वर्तमान समयक कष्‍ट किछु नहि अछि। ");
INSERT INTO mai_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ई सृष्‍टि बहुत जिज्ञासाक संग ओहि समयक प्रतीक्षा कऽ रहल अछि जहिया परमेश्‍वरक सन्‍तान सभ केँ प्रगट कयल जायत। ");
INSERT INTO mai_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ई सृष्‍टि तँ व्‍यर्थताक अधीन कऽ देल गेल, मुदा से अपन इच्‍छा सँ नहि, बल्‍कि हुनकर इच्‍छा सँ जे एकरा अधीन कऽ देलथिन, मुदा ई आशा बनल रहल जे, ");
INSERT INTO mai_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","एक दिन आओत जहिया सृष्‍टि सरनाइ आ मरनाइक बन्‍हन सँ मुक्‍त भऽ ओहि महिमामय स्‍वतन्‍त्रता मे सहभागी बनत जे परमेश्‍वरक सन्‍तान सभक होयतैक। ");
INSERT INTO mai_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","हम सभ जनैत छी जे सम्‍पूर्ण सृष्‍टि मिलि कऽ आइ तक ओहि प्रकारक कष्‍ट सँ कुहरैत आयल अछि जेना प्रसव-पीड़ाक कष्‍ट होइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","मात्र वैह नहि, बल्‍कि अपनो सभ, जकरा सभ केँ परमेश्‍वरक वचनक पूर्तिक पहिल भागक रूप मे पवित्र आत्‍मा भेटल छथि, भीतरे-भीतर कुहरैत छी और एहि बातक प्रतीक्षा करैत छी जे अपना सभ पूर्ण रूप सँ परमेश्‍वरक पोषपुत्र बनाओल जायब आ शरीर सरनाइ आ मरनाइक बन्‍हन सँ छुटकारा पाबि नव कयल जायत। ");
INSERT INTO mai_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","जहिया सँ अपना सभक उद्धार भेल, तहिया सँ अपना सभ मे ई आशा बनल रहल अछि। मुदा जँ अपना सभ ओहि वस्‍तु केँ प्राप्‍त कैए लेने छी जकर आशा रखैत छी, तँ ओकरा “आशा” नहि कहल जाइत अछि। जकरा कोनो वस्‍तु प्राप्‍त भऽ गेल छैक, से तकर आशा किएक करत? ");
INSERT INTO mai_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","मुदा अपना सभ ओहि वस्‍तुक आशा करैत छी जे देखैत नहि छी, आ तेँ धैर्यपूर्बक ओकर प्रतीक्षा करैत छी। ");
INSERT INTO mai_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","एही तरहेँ पवित्र आत्‍मा सेहो अपना सभक दुर्बलता मे सहायता करैत छथि, किएक तँ अपना सभ नहि जनैत छी जे अपना सभ केँ प्रार्थना कोन तरहेँ करबाक चाही, मुदा आत्‍मा अपने कुहरि-कुहरि कऽ अपना सभक लेल विनती करैत छथि, जकरा शब्‍द मे व्‍यक्‍त नहि कयल जा सकैत अछि। ");
INSERT INTO mai_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","और परमेश्‍वर, जे अपना सभक हृदयक भेद केँ जनैत छथि, से जनैत छथि जे आत्‍माक अभिप्राय की छनि, कारण, आत्‍मा परमेश्‍वरक इच्‍छाक अनुसार हुनकर लोक सभक लेल विनती करैत छथि। ");
INSERT INTO mai_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","अपना सभ जनैत छी जे परमेश्‍वर सँ प्रेम कयनिहार लोक, अर्थात् हुनका उद्देश्‍यक अनुरूप बजाओल गेल लोक सभक लेल प्रत्‍येक परिस्‍थिति मे परमेश्‍वर भलाइ उत्‍पन्‍न करैत छथि। ");
INSERT INTO mai_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","परमेश्‍वर अपना लोक केँ शुरुए सँ चिन्‍हैत छलाह, आ ओकरा सभक लेल ओ ई निश्‍चित कयलनि जे ओ सभ हुनकर पुत्रक समरूप बनय, जाहि सँ यीशु मसीह बहुतो भाय सभक जेठ भाय ठहरथि। ");
INSERT INTO mai_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","जकरा सभक लेल ओ ई निश्‍चित कयलनि जे ओ सभ हुनकर पुत्रक समरूप बनय, तकरा सभ केँ ओ बजौलनि सेहो, आ जकरा सभ केँ बजौलनि तकरा सभ केँ धार्मिक सेहो ठहरौलनि। जकरा सभ केँ ओ धार्मिक ठहरौलनि, तकरा सभ केँ ओ अपन महिमा मे सहभागी सेहो बनौलनि। ");
INSERT INTO mai_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","एहि बात सभक सम्‍बन्‍ध मे आब अपना सभ की कही? जँ परमेश्‍वर अपना सभक पक्ष मे छथि तँ अपना सभक विरोध मे के भऽ सकत? ");
INSERT INTO mai_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","परमेश्‍वर अपन निज पुत्र केँ जँ बँचा कऽ नहि रखलनि, बल्‍कि अपना सभ गोटेक लेल दऽ देलनि, तखन की ओ खुशी सँ अपना पुत्रक संग सभ किछु अपना सभ केँ नहि देताह? ");
INSERT INTO mai_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","परमेश्‍वरक चुनल लोक सभ पर के दोष लगाओत? परमेश्‍वर स्‍वयं अपना सभ केँ धार्मिक ठहरा रहल छथि, ");
INSERT INTO mai_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","तँ फेर अपना सभ केँ दण्‍डक आज्ञा के दऽ सकत? मसीह यीशु तँ स्‍वयं अपना सभक लेल मरलाह—एतबे नहि, ओ जिआओल सेहो गेलाह आ परमेश्‍वरक दहिना कात विराजमान भऽ अपना सभक पक्ष मे विनती करैत छथि। ");
INSERT INTO mai_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","अपना सभ केँ मसीहक प्रेम सँ के अलग कऽ सकैत अछि? की कष्‍ट, वा संकट, वा अत्‍याचार, वा अकाल, वा गरीबी, वा खतरा, वा तरुआरि? ");
INSERT INTO mai_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","जेना कि धर्मशास्‍त्र मे लिखल अछि, “अहाँक लेल दिन भरि हम सभ वध कयल जाइत छी। वध होमऽ वला भेँड़ा सभ जकाँ हम सभ मानल गेल छी।” ");
INSERT INTO mai_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","नहि! अपना सभ सँ जे प्रेम कयने छथि तिनका द्वारा अपना सभ एहि सभ बात मे पूर्ण विजय पबैत छी। ");
INSERT INTO mai_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","किएक तँ हमरा पूर्ण विश्‍वास अछि जे, ने मृत्‍यु आ ने जीवन, ने स्‍वर्गदूत आ ने नरकदूत, ने वर्तमान आ ने भविष्‍य, ने कोनो तरहक शक्‍ति, ");
INSERT INTO mai_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ने आकाश आ ने पाताल, और ने सौंसे सृष्‍टि मे आरो कोनो वस्‍तु अपना सभ केँ परमेश्‍वरक ओहि प्रेम सँ अलग कऽ सकत जे ओ अपना सभक प्रभु, मसीह यीशु, द्वारा प्रगट कयलनि। ");
INSERT INTO mai_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","हम मसीहक उपस्‍थिति मे सत्‍य कहैत छी, हम झूठ नहि बजैत छी; हमर विवेक सेहो परमेश्‍वरक पवित्र आत्‍माक अधीन रहि कऽ एहि बातक गवाही दऽ रहल अछि जे, ");
INSERT INTO mai_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","हम अत्‍यन्‍त दुखी छी आ हमर हृदय अटूट वेदना सँ भरल रहैत अछि— ");
INSERT INTO mai_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","एतऽ तक जे हम एहू लेल तैयार छी जे, जँ एहि द्वारा हमर अपन सजाति वला भाइ-बन्‍धु सभ मसीह पर विश्‍वास कऽ उद्धार पबितथि, तँ हम अपने सरापित भऽ मसीह सँ अलग भऽ जइतहुँ। ");
INSERT INTO mai_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ओ सभ इस्राएली छथि, हुनका सभ केँ परमेश्‍वर अपन पुत्र मानलथिन, अपन महिमाक दर्शन देलथिन, हुनका सभक संग विशेष सम्‍बन्‍ध स्‍थापित कयलनि। हुनका सभ केँ धर्म-नियम और परमेश्‍वरक सेवाक विधान देल गेलनि। हुनका सभ केँ परमेश्‍वर अनेको बातक विषय मे वचन देलनि। ");
INSERT INTO mai_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ओ सभ महान्‌ पूर्वजक सन्‍तान छथि, आ मसीह सेहो शारीरिक दृष्‍टिकोण सँ हुनके सभक वंशज छथि—यीशु मसीह जे सर्वोच्‍च परमेश्‍वर छथि। युग-युग तक हुनकर स्‍तुति होनि! आमीन। ");
INSERT INTO mai_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","मुदा इस्राएली सभक अविश्‍वासक अर्थ ई नहि, जे हुनका सभ केँ देल गेल परमेश्‍वरक वचन असफल भऽ गेल, किएक तँ ई बात नहि अछि जे इस्राएलक वंश मे जन्‍म लेनिहार सभ लोक इस्राएली अछि। ");
INSERT INTO mai_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","आ ने अब्राहमक वंशज होयबाक कारणेँ सभ हुनकर सन्‍तान मानल जाइत अछि। कारण, धर्मशास्‍त्र मे लिखल अछि जे परमेश्‍वर अब्राहम केँ कहने छलथिन जे, “इसहाके सँ उत्‍पन्‍न वंशज तोहर वंश मानल जयतह।” ");
INSERT INTO mai_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","एकर अर्थ ई भेल जे, अब्राहमक वंश मे जे सभ प्राकृतिक तरीका सँ जन्‍म लेलक, सैह सभ परमेश्‍वरक सन्‍तान नहि मानल जाइत अछि, बल्‍कि जे सभ परमेश्‍वरक देल वचनक अनुसार जन्‍म लेलक, वैह सभ वास्‍तविक वंशज मानल जाइत अछि। ");
INSERT INTO mai_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","किएक तँ वचनक शब्‍द ई छल, “हम निर्धारित समय पर फेर आयब आ तहिया सारा केँ एकटा बेटा होयत।” ");
INSERT INTO mai_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","एतबे नहि, बल्‍कि रिबका केँ सेहो, जिनकर दूनू बच्‍चाक पिता हमरा सभक पूर्वज इसहाक छलाह, तिनको एक वचन देल गेल छलनि। ");
INSERT INTO mai_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","जाहि समय मे हुनकर ओ दूनू जौंआ जन्‍मो नहि लेने छल, आ ने ओ सभ कोनो नीक वा अधलाह काज कयने छल, ताहि समय मे हुनका कहल गेलनि जे, “जेठ बेटा छोटकाक सेवा करत।” ई एहि लेल भेल जे परमेश्‍वरक निर्णयक उद्देश्‍य पूरा होनि, और से निर्णय मनुष्‍यक कर्म पर नहि, बल्‍कि बजौनिहारक स्‍वतन्‍त्र चुनाव पर निर्भर अछि। ");
INSERT INTO mai_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","तहिना एहि दूनू भायक सम्‍बन्‍ध मे धर्मशास्‍त्र मे परमेश्‍वरक ई कथन सेहो लिखल अछि जे, “हम याकूब सँ प्रेम कयलहुँ मुदा एसाव केँ तुच्‍छ बुझलहुँ।” ");
INSERT INTO mai_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","तँ एहि बात सभक सम्‍बन्‍ध मे अपना सभ की कही? की परमेश्‍वर अन्‍यायी छथि? एकदम नहि! ");
INSERT INTO mai_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","किएक तँ परमेश्‍वर मूसा केँ कहलथिन, “हम जकरा पर चाहब तकरा पर कृपा करब, आ जकरा पर चाहब तकरा पर दया करब।” ");
INSERT INTO mai_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","तेँ परमेश्‍वरक निर्णय मनुष्‍यक इच्‍छा वा ओकर परिश्रम पर नहि, बल्‍कि हुनकर अपन कृपा पर निर्भर अछि। ");
INSERT INTO mai_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","किएक तँ धर्मशास्‍त्र मे फरओ केँ कहल गेल बात लिखल अछि जे, “हम तोरा एहि लेल राजा नियुक्‍त कयने छिअह जे तोरा जीवन मे हम अपन सामर्थ्‍य देखाबी जाहि सँ हमर नामक प्रचार समस्‍त पृथ्‍वी पर कयल जाय।” ");
INSERT INTO mai_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","तेँ निष्‍कर्ष ई जे परमेश्‍वर जकरा पर कृपा करऽ चाहथि, तकरा पर कृपा करैत छथि, आ जकरा जिद्दी बनाबऽ चाहथि, तकरा जिद्दी बना दैत छथिन। ");
INSERT INTO mai_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","भऽ सकैत अछि जे अहाँ सभ मे सँ केओ हमरा कहब, “जँ एहन बात अछि तँ परमेश्‍वर हमरा सभ केँ दोषी किएक मानैत छथि? हुनकर इच्‍छाक विरोध के कऽ सकैत अछि?” ");
INSERT INTO mai_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ऐ मनुष्‍य! अहाँ छी के जे परमेश्‍वर सँ मुँह लगबैत छी? की कोनो गढ़ल गेल वस्‍तु अपन गढ़ऽ वला सँ ई कहत जे, “अहाँ हमरा एहन किएक बनौलहुँ?” ");
INSERT INTO mai_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","की कुम्‍हार केँ ई अधिकार नहि अछि जे ओ माटिक एके थुम्‍मा सँ कोनो बर्तन विशेष काजक लेल बनाबय आ कोनो बर्तन साधारण काजक लेल? ");
INSERT INTO mai_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","जँ परमेश्‍वर अपन क्रोध देखयबाक और अपन सामर्थ्‍य प्रगट करबाक इच्‍छा रखितो कोप मे पड़ऽ वला ओहि लोक सभ केँ अधिक समय धरि सहन कयलनि जे सभ विनाशक लेल तैयार कयल गेल छल, तँ की, हुनकर से अधिकार नहि छलनि? ");
INSERT INTO mai_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ओ एहि लेल एना कयलनि जे ओ जाहि लोक सभ पर दया कयने छथि तकरा सभ पर अपन महान्‌ महिमा प्रगट करऽ चाहलनि। ओकरा सभ केँ आरम्‍भहि सँ ओ अपन महिमा पयबाक लेल तैयार कयने छलाह। ");
INSERT INTO mai_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","हुनकर ओ दया पौनिहार लोक अपना सभ छी जकरा सभ केँ ओ मात्र यहूदीए सभ मे सँ नहि, बल्‍कि आन जाति सभ मे सँ सेहो बजौने छथि। ");
INSERT INTO mai_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","जेना कि ओ धर्मशास्‍त्र मे होशेक किताब मे कहनहुँ छथि जे, “जे लोक हमर प्रजा नहि छल, तकरा सभ केँ हम अपन प्रजा कहब, आ जे हमर प्रिय नहि छल, तकरा हम ‘अपन प्रिय’ कहब।” ");
INSERT INTO mai_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","और, “जतऽ ओकरा सभ केँ ई कहल गेल छलैक, ‘तोँ सभ हमर प्रजा नहि छह,’ ततऽ ओ सभ ‘जीवित परमेश्‍वरक सन्‍तान’ कहाओत।” ");
INSERT INTO mai_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","धर्मशास्‍त्र मे इहो लिखल अछि जे, इस्राएलक सम्‍बन्‍ध मे यशायाह घोषणा करैत छथि जे, “इस्राएलक सन्‍तानक संख्‍या समुद्रक बालु जकाँ असंख्‍य किएक ने होअय, तैयो ओकरा सभ मे सँ किछुए लोक बचाओल जायत। ");
INSERT INTO mai_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","किएक तँ प्रभु पृथ्‍वी पर अपन दण्‍ड-आज्ञाक वचन जल्‍दी आ पूर्ण रूप सँ पूरा करताह।” ");
INSERT INTO mai_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","जहिना परमेश्‍वरक प्रवक्‍ता यशायाह पहिने कहने छलाह, तहिना भयबो कयल जे, “जँ सर्वशक्‍तिमान प्रभु हमरा सभक लेल किछु वंशज केँ नहि छोड़ि देने रहितथि, तँ हम सभ सदोम आ गमोरा नगर जकाँ नष्‍ट भऽ गेल रहितहुँ।” ");
INSERT INTO mai_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","तँ ई सभ कहबाक अर्थ की अछि? ओकर अर्थ ई अछि जे, गैर-यहूदी सभ, जे सभ धार्मिकताक खोजो नहि करैत छल, से सभ ओकरा पौलक, अर्थात्, वैह धार्मिकता जे विश्‍वास सँ प्राप्‍त होइत अछि, ");
INSERT INTO mai_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","मुदा इस्राएली सभ, जे सभ धर्म-नियम पालन करबाक माध्‍यम सँ धार्मिकता पयबाक लेल प्रयत्‍नशील रहल, से सभ ओकरा प्राप्‍त नहि कऽ सकल। ");
INSERT INTO mai_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","किएक नहि कऽ सकल? तकर कारण ई जे, ओ सभ तकरा विश्‍वास द्वारा नहि, बल्‍कि कर्म द्वारा पयबाक कोशिश करैत छल। एहि तरहेँ “ठेस लागऽ वला पाथर” मे ओकरा सभ केँ ठेस लागिए गेलैक। ");
INSERT INTO mai_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","जेना कि धर्मशास्‍त्र मे लिखल अछि, “देखू, हम सियोन मे ओहन पाथर रखैत छी जाहि मे लोक केँ ठेस लगतैक, ओहन चट्टान रखैत छी जाहि पर लोक खसत। जे केओ हुनका पर भरोसा राखत तकरा कहियो लज्‍जित नहि होमऽ पड़तैक।” ");
INSERT INTO mai_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","यौ भाइ लोकनि, हमर हार्दिक इच्‍छा आ परमेश्‍वर सँ प्रार्थना अछि जे इस्राएली सभ उद्धार पबथि। ");
INSERT INTO mai_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","हम हुनका सभक सम्‍बन्‍ध मे ई गवाही दऽ सकैत छी जे, हुनका सभ केँ परमेश्‍वरक प्रति जोस छनि, मुदा ई जोस सत्‍यक ज्ञान पर आधारित नहि छनि। ");
INSERT INTO mai_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","कारण, ओ सभ धार्मिक ठहरबाक ओहि माध्‍यम पर ध्‍यान नहि देलनि जे परमेश्‍वर स्‍थापित कयलनि, बल्‍कि अपन माध्‍यम स्‍थापित करबाक प्रयत्‍न कयलनि। एहि तरहेँ ओ सभ परमेश्‍वर द्वारा देल जाय वला धार्मिकताक अधीन भेनाइ अस्‍वीकार कयलनि। ");
INSERT INTO mai_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","मसीह धार्मिकता प्राप्‍त करबाक ओहि माध्‍यम केँ अन्‍त करैत छथि जे धर्म-नियम पर निर्भर रहैत अछि, जाहि सँ जे केओ विश्‍वास करैत अछि से धार्मिक ठहराओल जाय। ");
INSERT INTO mai_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","मूसा धर्म-नियम पर आधारित धार्मिकताक विषय मे ई लिखने छथि जे, “जे व्‍यक्‍ति धर्म-नियमक पालन करैत अछि से ओहि द्वारा जीवन पाओत।” ");
INSERT INTO mai_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","मुदा जे धार्मिकता विश्‍वास पर आधारित अछि, ताहि सम्‍बन्‍ध मे ई लिखल अछि, “अपना मोन मे ई नहि कहू जे, ‘स्‍वर्ग पर के चढ़त?’” अर्थात्, मसीह केँ नीचाँ लयबाक लेल। ");
INSERT INTO mai_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“वा ‘पाताल मे के उतरत?’” अर्थात्, मुइल सभ मे सँ मसीह केँ जिआ कऽ ऊपर अनबाक लेल। ");
INSERT INTO mai_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","विश्‍वास पर आधारित धार्मिकताक सम्‍बन्‍ध मे यैह लिखल अछि जे, “वचन अहाँ सभक लगे मे अछि, ओ अहाँक मुँह मे आ अहाँक हृदय मे अछि,” अर्थात्, ई विश्‍वासक वचन, जकर हम सभ प्रचार करैत छी जे, ");
INSERT INTO mai_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","जँ अहाँ अपना मुँह सँ खुलि कऽ स्‍वीकार करी जे, “यीशु प्रभु छथि,” आ हृदय सँ विश्‍वास करी जे, “परमेश्‍वर हुनका मुइल सभ मे सँ जिऔलथिन” तँ अहाँ उद्धार पायब। ");
INSERT INTO mai_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","किएक तँ हृदय सँ विश्‍वास कऽ मनुष्‍य धार्मिक ठहरैत अछि; मुँह सँ स्‍वीकार कऽ उद्धार पबैत अछि। ");
INSERT INTO mai_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","धर्मशास्‍त्र सेहो कहैत अछि जे, “जे केओ हुनका पर भरोसा राखत, तकरा कहियो लज्‍जित नहि होमऽ पड़तैक।” ");
INSERT INTO mai_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","यहूदी आ आन जाति मे कोनो भेद नहि अछि—एके प्रभु सभक प्रभु छथि, आ जे सभ हुनका सँ प्रार्थना करैत अछि, ताहि सभ लोक पर ओ खुशीपूर्बक अपन आशिष बरसबैत छथि। ");
INSERT INTO mai_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","कारण, लिखल अछि, “जे केओ प्रभु सँ विनती करत तकर उद्धार होयतैक।” ");
INSERT INTO mai_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","मुदा लोक तिनका सँ विनती कोना करत जिनका पर विश्‍वास नहि कयने अछि? आ तिनका पर विश्‍वास कोना करत जिनका विषय मे सुनने नहि अछि? आ सुनत कोना जाबत धरि केओ हुनका सम्‍बन्‍ध मे प्रचार नहि करत? ");
INSERT INTO mai_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","और लोक प्रचार कोना करत जाबत धरि पठाओल नहि जायत? धर्मशास्‍त्र मे लिखल अछि जे, “खुस खबरी सुनौनिहारक पयरक आगमन कतेक सुखद अछि।” ");
INSERT INTO mai_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","मुदा सभ इस्राएली एहि शुभ समाचार केँ मानलनि नहि। जेना कि यशायाह कहैत छथि जे, “यौ प्रभु, हमरा सभक द्वारा सुनाओल गेल उपदेशक बात पर के विश्‍वास कयने अछि?” ");
INSERT INTO mai_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","एहि तरहेँ अपना सभ देखैत छी जे, सुनलाक बादे केओ विश्‍वास कऽ सकैत अछि, आ जे सुनबाक अछि, से अछि मसीहक वचन। ");
INSERT INTO mai_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","मुदा आब हम पुछैत छी जे, “की ओ सभ नहि सुनने छथि?” हँ, ओ सभ अवश्‍य सुनने छथि, जेना कि धर्मशास्‍त्र कहैत अछि जे, “सम्‍बाद सुनाबऽ वला सभक स्‍वर समस्‍त पृथ्‍वी पर पसरि गेल अछि आ हुनकर सभक वचन संसारक कोना-कोना मे पहुँचि गेल अछि।” ");
INSERT INTO mai_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","हम फेर पुछैत छी, “की इस्राएली सभ ओ शुभ समाचार नहि बुझि पौलनि?” हँ, अवश्‍य बुझलनि, कारण, पहिने मूसा कहलनि जे, प्रभु कहैत छथि— “जे सभ कोनो जातिए नहि अछि, तकरा सभक द्वारा हम तोरा सभ मे डाह उत्‍पन्‍न करबह, आ जाहि जातिक लोक सभ किछु बुझैत नहि अछि, तकरा सभक द्वारा हम तोरा सभ मे क्रोध उत्‍पन्‍न करबह।” ");
INSERT INTO mai_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","तखन यशायाह एकदम खुलि कऽ कहलनि जे, प्रभु कहैत छथि— “जे सभ हमरा तकैत नहि छल, से सभ हमरा पाबि लेलक, आ जे सभ हमरा सम्‍बन्‍ध मे पुछितो नहि छल, तकरा सभ पर हम अपना केँ प्रगट कऽ देलिऐक।” ");
INSERT INTO mai_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","मुदा इस्राएली सभक सम्‍बन्‍ध मे ओ ई कहैत छथि, “आज्ञा नहि मानऽ वला आ जिद्दी अपन प्रजा सभक दिस हम भरि दिन अपन बाँहि पसारने रहलहुँ।” ");
INSERT INTO mai_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","आब ई प्रश्‍न उठैत अछि जे, की परमेश्‍वर अपन प्रजा इस्राएली सभक परित्‍याग कऽ देने छथि? किन्‍नहुँ नहि! हम अपने इस्राएली छी, अब्राहमक वंशज आ बिन्‍यामीनक कुलक छी। ");
INSERT INTO mai_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","परमेश्‍वर अपन ओहि प्रजा केँ जकरा ओ शुरुए सँ चिन्‍हैत छलाह, परित्‍याग नहि कयने छथि। की अहाँ सभ नहि जनैत छी जे धर्मशास्‍त्रक ओहि भाग मे की लिखल अछि, जतऽ कहल गेल अछि जे एलियाह कोना परमेश्‍वर सँ इस्राएली सभक विरोध मे सिकायत कयलनि? ओ कहलनि, ");
INSERT INTO mai_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“यौ प्रभु, ओ सभ अहाँक प्रवक्‍ता सभक हत्‍या कऽ देने अछि आ अहाँक बलि-वेदी सभ केँ नष्‍ट कऽ देने अछि। हम असगरे अहाँ केँ मानऽ वला बाँचि गेल छी आ ओ सभ हमरो प्राण लेबऽ चाहैत अछि।” ");
INSERT INTO mai_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","तँ परमेश्‍वर हुनका की उत्तर देलथिन? ई जे, “हम अपना लेल सात हजार लोक केँ बँचा कऽ रखने छी, जे सभ बाअल देवताक मुरुतक समक्ष दण्‍डवत नहि कयने अछि।” ");
INSERT INTO mai_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ठीक एही प्रकारेँ वर्तमान समय मे सेहो परमेश्‍वर अपना प्रजा मे सँ अपना लेल एक छोट भाग बचा कऽ रखने छथि जकरा ओ अपना कृपा सँ चुनलनि। ");
INSERT INTO mai_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","और ई जँ परमेश्‍वरक कृपाक परिणाम अछि, तँ मनुष्‍यक कर्मक फल आब नहि भेल, नहि तँ परमेश्‍वरक कृपा कृपे नहि रहैत। ");
INSERT INTO mai_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","तँ एकर मतलब की भेल? ई जे, इस्राएली सभ जाहि बातक खोज मे छलाह, से हुनका सभ गोटे केँ नहि भेटलनि, मुदा तिनका सभ केँ भेटलनि जे सभ चुनल गेल छलाह। बाँकी लोक सभ जिद्दी बनि गेलैक, ");
INSERT INTO mai_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","जेना धर्मशास्‍त्र मे लिखलो अछि, “परमेश्‍वर ओकरा सभक मोन सुस्‍त बना देलथिन, एहन आँखि देलथिन जे देखि नहि सकैत छल आ एहन कान देलथिन जे सुनि नहि सकैत छल, और आइ धरि ओकरा सभक दशा एहने बनल छैक।” ");
INSERT INTO mai_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","तहिना दाऊद कहैत छथि जे, “ओकर सभक भोजन ओकरा सभक लेल जाल आ फाँस बनि जाइक, ओकरा सभक पतन आ दण्‍डक कारण बनैक। ");
INSERT INTO mai_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ओकरा सभक आँखिक आगाँ अन्‍हार पसरि जाइक जाहि सँ ओ सभ देखि नहि सकय आ ओकरा सभक पीठ सभ दिनक लेल बोझ सँ झुकल रहैक।” ");
INSERT INTO mai_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ई प्रश्‍न आब उठि सकैत अछि जे, की इस्राएली सभ एहन ठोकर खयलनि जे आब हुनका सभक लेल कोनो उपाये नहि अछि? किन्‍नहुँ नहि! बल्‍कि हुनका सभक अपराधक कारणेँ गैर-यहूदी लोक सभ केँ उद्धार भेटल अछि, जाहि सँ से देखि कऽ इस्राएलिओ सभ मे उद्धार पयबाक उत्‍सुकता जागि उठनि। ");
INSERT INTO mai_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","आब जखन इस्राएली सभक अपराध आ पतन सँ संसार केँ, अर्थात् आन जाति सभ केँ, एतेक लाभ भेलैक, तँ सोचू जे तखन कतेक लाभ होयत जखन ओ सभ इस्राएली, जतेक केँ परमेश्‍वर चुनने छथि, से अपन पूर्ण संख्‍या मे विश्‍वास कऽ कऽ मसीह लग आबि जयताह! ");
INSERT INTO mai_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","आब अहाँ सभ केँ, जे सभ गैर-यहूदी लोक छी, हम ई कहैत छी। हम तँ गैर-यहूदी लोक मे प्रचार करबाक लेल मसीह-दूतक रूप मे चुनल गेल छी, आ हम अपन एहि काज केँ विशेष महत्‍व दैत छी, ");
INSERT INTO mai_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","जाहि सँ अहाँ सभ केँ जे किछु भेटल अछि, से प्राप्‍त करबाक उत्‍सुकता हम अपन सजातिक लोक सभ मे उत्‍पन्‍न कऽ कोनो तरहेँ हुनका सभ मे सँ किछु लोक केँ बचा सकी। ");
INSERT INTO mai_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","किएक तँ जँ हुनका सभ केँ परित्‍यागक फलस्‍वरूप परमेश्‍वरक संग संसारक मेल-मिलाप भेल अछि तँ हुनका सभ केँ स्‍वीकारक परिणाम हुनका सभक लेल मरल स्‍थिति मे सँ जिआओल जयबाक बात छोड़ि आओर की होयत? ");
INSERT INTO mai_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","जँ सानल आँटाक ओ भाग पवित्र अछि जे “प्रथम फलक” रूप मे अर्पण कयल गेल, तँ सम्‍पूर्ण सानल आँटा पवित्र अछि। जँ गाछक जड़ि पवित्र अछि तँ गाछक ठाढ़ि सेहो पवित्र अछि। ");
INSERT INTO mai_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","मुदा जँ गाछक किछु ठाढ़ि काटि कऽ अलग कयल गेल अछि आ अहाँ सभ, जे सभ जंगली जैतूनक ठाढ़ि छी, से सभ ओहि नीक जैतून मे कलम लगाओल गेलहुँ आ ओकर जड़ि आ रस-भण्‍डार मे सहभागी भेलहुँ, ");
INSERT INTO mai_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","तँ ओहि काटल ठाढ़ि सभक सम्‍मुख अहंकार नहि करू। जँ अहाँ सभ अहंकार करी तँ मोन राखू जे जड़ि अहाँ सभ पर नहि, बल्‍कि अहाँ सभ जड़ि पर आश्रित छी। ");
INSERT INTO mai_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","आब अहाँ सभ कहब जे, “ठाढ़ि सभ केँ एहि लेल काटल गेल जे हमरा सभ केँ कलम लगाओल जाय।” ");
INSERT INTO mai_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","मानलहुँ। मुदा हुनका सभ केँ अविश्‍वासेक कारणेँ काटि कऽ अलग कयल गेलनि, आ अहाँ सभ विश्‍वासक कारण अपन स्‍थान पर स्‍थिर छी। तेँ अहंकार नहि करू, बल्‍कि भय मानू। ");
INSERT INTO mai_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","किएक तँ जखन परमेश्‍वर मूल ठाढ़ि केँ नहि छोड़लनि तँ ओ अहूँ सभ केँ नहि छोड़ताह। ");
INSERT INTO mai_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","तेँ परमेश्‍वरक दया आ कठोरता, दूनू पर ध्‍यान राखू—कठोरता तकरा सभ पर अछि जकरा सभक पतन भऽ गेल छैक, मुदा अहाँ सभक लेल हुनकर दया अछि, लेकिन से तखने जखन अहाँ सभ हुन