﻿USE sofia;
DROP TABLE IF EXISTS sofia.maaNT_vpl;
CREATE TABLE maaNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES maaNT_vpl WRITE;
INSERT INTO maaNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jè xo̱jo̱n xi oxki̱t'aà 'ín‑la̱ na̱'èn‑jchá kjiìn‑la̱ Jesucristo, xi ya̱ inchrobàt'aà‑ne tje̱‑la̱ David ko̱ ts'e̱ Abraham. ");
INSERT INTO maaNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Jè Abraham, jè komà na̱'èn‑la̱ xi Isaac ki'mì; ko̱ jè Isaac, jè komà na̱'èn‑la̱ xi Jacob ki'mì; ko̱ jè Jacob, jè komà na̱'èn‑la̱ xi Judá ki'mì, ko̱ jñà xi̱ta̱ 'ndse̱. ");
INSERT INTO maaNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá, jè komà na̱'èn‑la̱ xi Fares ko̱ Zara ki'mì. Ko̱ jè nea̱‑la̱, Tamar ki'mì. Jè Fares, jè komà na̱'èn‑la̱ xi Esrom ki'mì; ko̱ jè Esrom, jè komà na̱'èn‑la̱ xi Aram ki'mì; ");
INSERT INTO maaNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ko̱ jè Aram, jè komà na̱'èn‑la̱ xi Aminadab ki'mì; ko̱ jè Aminadab, jè komà na̱'èn‑la̱ xi Naasón ki'mì; ko̱ jè Naasón, jè komà na̱'èn‑la̱ xi Salmón ki'mì; ");
INSERT INTO maaNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ko̱ jè Salmón, jè komà na̱'èn‑la̱ xi Booz ki'mì; ko̱ jè nea̱‑la̱ Booz, Rahab ki'mì. Ko̱ jè Booz, jè komà na̱'èn‑la̱ xi Obed ki'mì; ko̱ jè nea̱‑la̱ Obed, Rut ki'mì. Ko̱ jè Obed, jè komà na̱'èn‑la̱ xi Isaí ki'mì; ");
INSERT INTO maaNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ko̱ jè Isaí, jè komà na̱'èn‑la̱ xi David ki'mì xi xi̱ta̱xá ítjòn tsibìjna; koa̱ jè David, jè komà na̱'èn‑la̱ xi Salomón ki'mì; ko̱ jè nea̱‑la̱ Salomón, jè xi komà chjo̱ón‑la̱ Urías nga sa̱ ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Jè Salomón, jè komà na̱'èn‑la̱ xi Roboam ki'mì; ko̱ jè Roboam, jè komà na̱'èn‑la̱ xi Abías ki'mì; ko̱ jè Abías, jè komà na̱'èn‑la̱ xi Asa ki'mì; ");
INSERT INTO maaNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ko̱ jè Asa, jè komà na̱'èn‑la̱ xi Josafat ki'mì; ko̱ jè Josafat, jè komà na̱'èn‑la̱ xi Joram ki'mì; ko̱ jè Joram, jè komà na̱'èn‑la̱ xi Uzías ki'mì; ");
INSERT INTO maaNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ko̱ jè Uzías, jè komà na̱'èn‑la̱ xi Jotam ki'mì; ko̱ jè Jotam, jè komà na̱'èn‑la̱ xi Acaz ki'mì; ko̱ jè Acaz, jè komà na̱'èn‑la̱ xi Ezequías ki'mì; ");
INSERT INTO maaNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ko̱ jè Ezequías, jè komà na̱'èn‑la̱ xi Manasés ki'mì; ko̱ jè Manasés, jè komà na̱'èn‑la̱ xi Amón ki'mì; ko̱ jè Amón, jè komà na̱'èn‑la̱ xi Josías ki'mì; ");
INSERT INTO maaNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ko̱ jè Josías, jè komà na̱'èn‑la̱ xi Jeconías ki'mì, ko̱ jñà xi̱ta̱ 'ndse̱, k'e̱ nga kiìko̱ kjo̱'in xi̱ta̱ Israel ján i̱'nde ñánda 'mì Babilonia. ");
INSERT INTO maaNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Xi komà i̱skan k'e̱ nga jye kiìko̱ kjo̱'in xi̱ta̱ ján Babilonia, jè Jeconías, jè komà na̱'èn‑la̱ xi Salatiel ki'mì; ko̱ jè Salatiel, jè komà na̱'èn‑la̱ xi Zorobabel ki'mì; ");
INSERT INTO maaNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","jè Zorobabel, jè komà na̱'èn‑la̱ xi Abiud ki'mì; ko̱ jè Abiud, jè komà na̱'èn‑la̱ xi Eliaquim ki'mì; ko̱ jè Eliaquim, jè komà na̱'èn‑la̱ xi Azor ki'mì; ");
INSERT INTO maaNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ko̱ jè Azor, jè komà na̱'èn‑la̱ xi Sadoc ki'mì; ko̱ jè Sadoc, jè komà na̱'èn‑la̱ xi Aquim ki'mì; ko̱ jè Aquim, jè komà na̱'èn‑la̱ xi Eliud ki'mì; ");
INSERT INTO maaNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ko̱ jè Eliud, jè komà na̱'èn‑la̱ xi Eleazar ki'mì; ko̱ jè Eleazar, jè komà na̱'èn‑la̱ xi Matán ki'mì; ko̱ jè Matán, jè komà na̱'èn‑la̱ xi Jacob ki'mì; ");
INSERT INTO maaNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ko̱ jè Jacob, jè komà na̱'èn‑la̱ José. Ko̱ José, jè xi x'i̱n‑la̱ komà María; ko̱ jè María, nea̱‑la̱á komà Jesús xi Cristo, xi̱ta̱ xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ngats'iì xi̱ta̱ jchínga‑la̱ Jesús, teñijòn sko̱ ma‑ne xi inchrobàt'aà‑ne ts'e̱ Abraham skanda David. Ko̱ jñà xi̱ta̱ jchínga‑la̱ Jesús xi inchrobàt'aà‑ne ts'e̱ David skanda k'e̱ nga kiìko̱ kjo̱'in jñà xi̱ta̱ Israel ján i̱'nde ñánda 'mì Babilonia, ti̱koa̱á teñijòn sko̱ ma‑ne. Ko̱ nguì teñijòn sko̱ ma‑ne skanda k'e̱ kits'iìn xi Cristo, xi̱ta̱ xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","K'e̱ nga kits'iìn Jesucristo kiís'ín komà: María xi nea̱‑la̱ Jesús ko̱ José jñà títsa̱jna'ñó‑la̱ xíkjín nga ki̱xan. K'e̱ nga ti̱kj'eè bìtsa̱jnako̱ xíkjín, María ki'ya‑la̱ nga ki'ndí 'ya xi i̱t'aà ts'e̱ nga'ñó‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, xi x'i̱n‑la̱ komà, nga xi̱ta̱ kixi̱‑né, majìn‑la̱ nga kjo̱sobà tsjá‑la̱ jè María, kisìkítsjeèn nga tà si̱ìkíjna‑ne chjo̱ón jè, ko̱ mì yá xi̱ta̱ kji̱'nchré. ");
INSERT INTO maaNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","K'e̱ nga k'oa̱s'ín tísíkítsjeèn jñà kjoa̱ koi, jngoò àkja̱le̱‑la̱ Nainá tsohóko̱ i̱nga nijñá. Kitsò‑la̱: ―José, xi ya̱ nchrobàt'aà‑ne tje̱‑la̱ David, kì tsakjoòn‑jèn nga bijnakoi María xi chjo̱ón‑lè ko̱ma, jè ki'ndí xi 'ya, nga'ñó ts'e̱ Ini̱ma̱ Tsjeè‑la̱ Nainá‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","S'e̱é jngoò‑la̱ ki'ndí x'i̱n, ko̱ 'ín‑la̱ Jesús k'oín. Koií k'oa̱s'ín k'oín‑ne nga jè ko̱chrjetjì na̱xa̱ndá‑la̱ xi kjoa̱ ts'e̱ jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ngats'iì kjoa̱ koi, k'oa̱á s'ín tsitasòn koni s'ín kitsò Nainá xi i̱t'aà ts'e̱ xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá kjòtseé nga kitsò: ");
INSERT INTO maaNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jngoò chjo̱ón xo̱ngó, ki'ndí k'oa̱ ko̱ k'oe̱è jngoò ki'ndí x'i̱n xi Emanuel k'oín 'ín‑la̱. Jè 'ín xi Emanuel tsò, Nainá tíjnako̱‑ná tsòyaá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","K'e̱ nga jaá‑la̱ José, k'oa̱á s'ín kis'iìn koni s'ín kitsò‑la̱ àkja̱le̱‑la̱ Nainá, kiskoétjò María ko̱ chixàn‑ko̱. ");
INSERT INTO maaNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ta̱nga mìkiì tsoyijòko̱ xíkjín skanda k'e̱‑né nga kits'iìn ki'ndítjòn‑la̱ María. Ko̱ k'oa̱á s'ín tsibít'aà 'ín‑la̱ nga Jesús ki'mì. ");
INSERT INTO maaNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús kits'iìn ya̱ na̱xa̱ndá xi 'mì Belén, nangui xi chja̱‑ne Judea, k'e̱ nga xi̱ta̱xá ítjòn tíjna xi 'mì Herodes ya̱ i̱'nde jè. Ijchò ján Jerusalén, xi na̱xa̱ndá sko̱‑la̱ Judea, xi̱ta̱ xi 'ñó tjín‑la̱ kjoa̱chji̱ne̱, xi inchrobà‑ne ñánda bitjokàtji‑ne ts'oí ");
INSERT INTO maaNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","nga kjònangui. Kitsò: ―¿Ñánda tíjna xi̱ta̱xá ítjòn‑la̱ ts'e̱ xi̱ta̱ judío xi jye kits'iìn? Ki'yaá jngoò‑je̱n ni'ño ján ñánda bitjokàtji‑ne ts'oí xi tsakó nga jye kits'iìn. Ko̱ ngaje̱n koií xá kjoi̱‑naje̱n nga jcha̱xkón‑je̱n. ");
INSERT INTO maaNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","K'e̱ nga kiì'nchré Herodes xi xi̱ta̱xá ítjòn tíjna, tà kitsakjòn‑né ko̱ ngats'iì xi̱ta̱ na̱xa̱ndá Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jè xi̱ta̱xá ítjòn xi 'mì Herodes, kiìchja̱‑la̱ ngats'iì xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés; kiskònangui‑la̱ ñánda jts'ín xi Cristo, jè xi̱ta̱ xi xó si̱ìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jñà xi̱ta̱ koi kitsò‑la̱: ―Ya̱á Belén, na̱xa̱ndá xi chja̱‑ne Judea. K'oa̱á s'ín tíchja̱ xo̱jo̱n xi kiskiì jñà xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá nga kitsò: ");
INSERT INTO maaNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Jñò xi xi̱ta̱ Belén 'mì‑nò, xi nangui Judá nokjoà‑nò, ngásòn chjí‑la̱ na̱xa̱ndá‑nò koni jñà na̱xa̱ndá ítjòn‑la̱ nangui Judá, nga ya̱á ki̱tjojiìn jngoò xi̱ta̱xá ítjòn xi si̱ìkinda̱ na̱xa̱ndá‑na̱ Israel. ");
INSERT INTO maaNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jè xi̱ta̱xá ítjòn xi 'mì Herodes, kiìchja̱'ma‑la̱ jñà xi̱ta̱ xi 'ñó tjín‑la̱ kjo̱chji̱ne̱ nga kiskònangui‑la̱ mé na̱chrjein‑ne nga kijtseè ni'ño. ");
INSERT INTO maaNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","K'e̱é kisìkasén ján Belén; kitsò‑la̱: ―Tanguió ján, koa̱ ndaà chji̱nanguio xi i̱t'aà ts'e̱ ki'ndí jè. K'e̱ nga sa̱kò‑nò, ti̱kí'nchré‑ná mé‑ne ti̱koa̱ kjián katsejèn‑la̱ nga skoexkoán koa̱ jeya siìkíjna. ");
INSERT INTO maaNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","K'e̱ nga jye kiì'nchré xi̱ta̱ xi 'ñó tjín‑la̱ kjoa̱chji̱ne̱ koni s'ín kitsò Herodes, k'e̱é kiì xi̱ta̱ koi ko̱ jè ni'ño xi kijtseè ñánda bitjokàtji‑ne ts'oí k'oa̱á s'ín kiì ítjòn‑la̱ skanda ijchò ñánda tíjna ki'ndí jè, ko̱ ya̱á tsasìjna jè ni'ño. ");
INSERT INTO maaNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jñà xi̱ta̱ xi 'ñó tjín‑la̱ kjoa̱chji̱ne̱ k'e̱ nga kijtseè ni'ño jè, ta̱xki̱ tsjaá komà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","K'e̱ nga jahas'en ni'ya jñà xi̱ta̱ koi, kijtseè ki'ndí ko̱ nea̱‑la̱ María. K'e̱é chincha-xkó'nchit'aà‑la̱ jè ki'ndí ko̱ kijtseèxkón; jeya kisìkíjna. I̱kjoàn kiskíx'a̱ kaxa̱‑la̱ ko̱ kitsjaà‑la̱ to̱n oro, ko̱ chrjongó‑la̱ Nainá ko̱ xkiì xi 'ñó ndaà jne̱ xi 'mì mirra. ");
INSERT INTO maaNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nga komà i̱skan kits'iì‑la̱ nijñá xi̱ta̱ xi 'ñó tjín‑la̱ kjoa̱chji̱ne̱ nga mì ti̱ k'oa̱á s'ín ndi̱yá kjoi̱‑ne ñánda tíjna Herodes. Xìn ndi̱yá kiì‑ne nangui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","K'e̱ nga jye kiì‑ne jñà xi̱ta̱ xi 'ñó tjín‑la̱ kjoa̱chji̱ne̱, jngoò àkja̱le̱‑la̱ Nainá kisìnijñá‑la̱ José, kitsò‑la̱: ―Ti̱sítji̱in; chjoí jè ki'ndí ko̱ nea̱‑la̱; t'in ján nangui Egipto; ya̱á tijni skanda k'e̱ 'a̱n ko̱xán‑lè. Nga jè Herodes xi xi̱ta̱xá ítjòn tíjna, ko̱hótsji ki'ndí jè nga mejèn‑la̱ nga si̱ìk'en. ");
INSERT INTO maaNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","K'e̱é tsasítje̱n José, k'e̱ nga ni̱tje̱n kiskoé jè ki'ndí ko̱ nea̱‑la̱ nga kiì ján nangui Egipto. ");
INSERT INTO maaNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ya̱á tsibìtsa̱jna skanda k'e̱ nga k'en Herodes. K'oa̱á s'ín tsitasòn koni s'ín kitsò Nainá xi i̱t'aà ts'e̱ xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá nga kitsò: “Ya̱ nangui Egipto kichjà‑la̱ ki'ndí‑na̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","K'e̱ nga kijtseè jè Herodes nga jñà xi̱ta̱ xi 'ñó tjín‑la̱ kjoa̱chji̱ne̱ kiskoòna̱cha̱n‑la̱, tsí jti komà‑la̱. I̱kjoàn kitsjaà o̱kixi̱ nga si̱ìk'en yije ndí i̱xti x'i̱n xi jò nó tjín‑la̱ ko̱ ngats'iì xi ìsa̱ ki'ndí ìsa̱ kóho̱kji ján na̱xa̱ndá Belén, ko̱ ya̱ na̱xa̱ndá i̱ndiì‑la̱ koni s'ín jye kisijiìn‑la̱ mé na̱chrjein‑ne nga kijtseè ni'ño jñà xi̱ta̱ xi 'ñó tjín‑la̱ kjoa̱chji̱ne̱. ");
INSERT INTO maaNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","K'oa̱á s'ín tsitasòn 'én xi kitsò Jeremías, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, nga kitsò: ");
INSERT INTO maaNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ya̱ i̱'nde Ramá kina'yà jngoò‑la̱ xi̱ta̱ xi tísíkájno ko̱ 'ñó tíkjindáya ko̱ títsiné; jè chjo̱ón Raquel xi tíkjindáyakeè ndí i̱xti‑la̱, nga mìkiì majehikon ini̱ma̱‑la̱ nga jye k'en i̱xti‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","K'e̱ nga jye k'en Herodes, xi xi̱ta̱xá ítjòn tíjna, jngoò àkja̱le̱‑la̱ Nainá kisìnijñá‑la̱ José ján Egipto. Kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Ti̱sítji̱in, chjoí ki'ndí jè ko̱ nea̱‑la̱. T'in ìjngoò k'a‑ne nangui Israel. Jyeé k'en jñà xi̱ta̱ xi tjín‑ne nga mejèn‑la̱ si̱ìk'en ki'ndí jè. ");
INSERT INTO maaNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","K'e̱é tsasítje̱n José, kiìko̱‑ne ki'ndí jè ko̱ nea̱‑la̱ ya̱ nangui Israel. ");
INSERT INTO maaNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ta̱nga k'e̱ nga kiì'nchré José nga jè tíhotíxoma jè xi 'mì Arquelao ya̱ nangui Judea, nga jè tíjna ngajo‑la̱ na̱'èn‑la̱ Herodes, José kitsakjòn‑né; mì k'oa̱á s'ín kiì. Ján kiì i̱'nde ñánda 'mì Galilea nga k'oa̱á s'ín kis'eno̱jmíya‑la̱ i̱nga nijñá. ");
INSERT INTO maaNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","K'e̱ nga ijchò i̱'nde jè, ya̱á tsibìtsa̱jna ya̱ na̱xa̱ndá xi 'mì Nazaret. K'oa̱á s'ín komà mé‑ne nga tsitasòn koni s'ín kitsò jñà xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, nga jè Jesús xi̱ta̱ Nazaret k'oín. ");
INSERT INTO maaNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jñà na̱chrjein koi j'iì Juan xi kis'iìn bautizar xi̱ta̱ ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn, nangui xi chja̱‑ne Judea, nga kisìka'bí 'én‑la̱ Nainá, ");
INSERT INTO maaNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","kitsò: ―Ti̱kájno jé‑nò, kì ti̱ jé binchaàtsji‑nò nga jyeé kjòchrañàt'aà‑nò na̱chrjein nga jcha̱a kó s'ín otíxoma jè xi ngajmiì nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jè Isaías, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, k'oa̱á s'ín kiskiì xo̱jo̱n‑la̱ xi i̱t'aà ts'e̱ Juan nga kitsò: Na'yà‑la̱ jta̱‑la̱ jngoò xi̱ta̱ xi 'ñó chja̱ ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn, nga tsò: “Tjandaà ndi̱yá‑la̱ Nainá ya̱ i̱jiìn ini̱ma̱‑nò; kixi̱ ti̱kíjna koni jngoò ndi̱yá ñánda ko̱jmeèya Na̱'èn‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nikje xi tsohòkjá Juan, tsja̱‑la̱ cho̱ camello‑né; ko̱ jngoò sincho̱ chrjoa̱ tsibíkjá ndáyá‑la̱. Koa̱ jñà tsojmì xi kiskine, cho̱ langosta‑né ko̱ tsjén‑la̱ cho̱ cera xi tjín i̱jiìn ijñá. ");
INSERT INTO maaNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ijchò 'nchré‑la̱ xi̱ta̱ xi inchrobà‑ne Jerusalén, ko̱ nga kijndà nangui Judea ko̱ ngats'iì na̱xa̱ndá xi ya̱ chrañàt'aà‑la̱ xa̱jngá nandá Jordán. ");
INSERT INTO maaNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","K'e̱ nga jye tsafátakòn jé‑la̱ jñà xi̱ta̱, Juan, i̱kjoàn kis'iìn bautizar ya̱ xa̱jngá nandá Jordán. ");
INSERT INTO maaNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","K'e̱ nga kijtseè Juan nga kjìn xi̱ta̱ fariseo ko̱ xi̱ta̱ saduceo j'iì nga ko̱ma bautizar, kitsò‑la̱: ―¡Jñò, k'oa̱á s'ín ngaya‑nò koni tsà tje̱‑la̱ ye̱! ¿Yá xi o̱kitsò‑nò nga ki̱nchat'aàxìn‑là jè kjo̱'in xi nchrobá machrañàt'aà‑nò? ");
INSERT INTO maaNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ndaà tjín kjoa̱ xi t'e̱en nga ndaà kàta'ya‑nò nga jyeé kinìkájno jé‑nò nga mì ti̱ jé binchaàtsji‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kì k'oa̱á s'ín nìkítsjeèn i̱jiìn ini̱ma̱‑nò nga bixón: “Ngaje̱n, mìkiì s'e̱‑naje̱n kjo̱'in nga ya̱á inchrobàt'aà‑naje̱n tje̱‑la̱ Abraham.” K'oa̱á xan‑nò, Nainá, skanda jñà nda̱jo̱ ko̱ma‑la̱ si̱ìkjatjìya‑la̱ nga i̱xti‑la̱ Abraham ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jè ki̱cha̱yá jyeé kjijnandaà nga ko̱tesòn yá; ngats'iì yá xi 'mì ndaà toò ojà‑la̱, skanda ko̱ i̱ma̱‑la̱, jtísòn‑né, i̱kjoàn si̱nchájiìn ni'ín nga ki̱ti̱. ");
INSERT INTO maaNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Xi o̱kixi̱, 'a̱n ko̱ó nandá s'i̱in‑nò bautizar, mé‑ne nga si̱kájnoò jé‑nò ko̱ mì ti̱ jé ki̱nchátsji‑nò. Ta̱nga jè xi nchrobátji̱ngui‑na s'iìn‑nò bautizar ko̱ Ini̱ma̱ Tsjeè‑la̱ Nainá koa̱ ko̱ ni'ín. Ìsa̱á tjín‑la̱ nga'ñó mì k'oa̱á‑ne 'a̱n. Skanda mìkiì tjí'nde‑na̱ nga 'a̱n kjíkoa̱a xo̱jté‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jyeé kjinaya tsja jè pala nga si̱ìtsjeè tjé‑la̱ trigo. Ki̱nchàxkó trigo ya̱ i̱ya ni'nga; ko̱ jè tjé paja ki̱nchàjiìn ni'ín ñánda nga mìkiì bits'o ni̱ta̱ mé na̱chrjein‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús j'iì‑ne Galilea ya̱ xa̱jngá nandá Jordán nga mejèn‑la̱ nga jè Juan s'iìn bautizar Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ta̱nga jè Juan k'e̱ nga sa̱ ítjòn mìkiì kòkjeiín‑la̱, kitsò‑la̱ Jesús: ―'A̱án xi mochjeén‑na nga ji̱í s'e̱en‑ná bautizar, ta̱nga ngaji̱, ta̱ sa̱á 'a̱n f'iìchòn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","K'e̱é kitsò Jesús: ―Tjiì‑lè kjo̱ndaà, t'e̱en‑ná bautizar mé‑ne nga k'oa̱s'ín si̱kitasoán kjo̱tíxoma‑la̱ Nainá. K'e̱é kòkjeiín‑la̱ Juan. ");
INSERT INTO maaNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","K'e̱ nga jye komà bautizar Jesús, k'e̱ nga jye itjojiìn‑ne nandá, i̱kjoàn kitáx'a̱‑la̱ ngajmiì, ko̱ jè Jesús kijtseè Ini̱ma̱ Tsjeè‑la̱ Nainá xi inchrobàjen‑ne ngajmiì, koni kji ni̱se paloma kji; ya̱á kiskaàsòn‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","K'e̱é kina'yà jngoò‑la̱ 'én xi ngajmiì inchrobà‑ne xi kitsò: ―Jè jèe̱ xi ki'ndí‑na̱ xan‑la̱ xi 'ñó matsjake̱; tsja tjín‑la̱ takoàn i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jè Ini̱ma̱ Tsjeè‑la̱ Nainá kiìko̱ Jesús jngoò i̱'nde i̱t'aà xìn nga jè xi̱ta̱ nei̱í skót'aà nga mejèn‑la̱ nga kàtátsji jé. ");
INSERT INTO maaNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ichán na̱chrjein ko̱ ichán ni̱tje̱n tsibìjnachjan Jesús ko̱ k'e̱ nga ko̱ma i̱skan jye kjòhojò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jè xi̱ta̱ nei̱í xi ma‑la̱ kona̱cha̱n ijchò kasìt'aà chrañà‑la̱ ñánda tíjna Jesús, kitsò‑la̱: ―Tsà kixi̱í kjoa̱ nga ngaji̱ xi Ki'ndí‑la̱ Nainá 'mì‑lè, tjiì‑la̱ o̱kixi̱ jñà nda̱jo̱ koi nga i̱nchra̱jín kàtama. ");
INSERT INTO maaNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ta̱nga Jesús kitsò‑la̱: ―Tjít'aà Xo̱jo̱n‑la̱ Nainá, nga tsò: “Mìtsà tà koi tsojmì xi ma chine kítsa̱kon‑ne xi̱ta̱, ti̱koa̱á kítsa̱kon‑ne nga yije 'én xi chja̱ Nainá.” ");
INSERT INTO maaNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jè xi̱ta̱ nei̱í kiìko̱ Jesús ya̱ Na̱xa̱ndá‑la̱ Nainá xi xó kitjaàjiìn‑ne ñánda 'mì Jerusalén; kisìkíjnasòn i̱ngo̱ ítjòn ñánda ìsa̱ 'nga kji. ");
INSERT INTO maaNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kitsò‑la̱: ―Tsà kixi̱í kjoa̱ nga ji̱ xi Ki'ndí‑la̱ Nainá 'mì‑lè, ti̱katje̱ngui yijo‑lè, nga k'oa̱á s'ín tjít'aà Xo̱jo̱n‑la̱ Nainá nga tsò: Nainá koií xá‑la̱ àkja̱le̱‑la̱ i̱t'aà tsi̱ji, nga ko̱ tsja tso̱ba̱'ñó‑lè, mé‑ne nga ni̱jngoò nda̱jo̱ satíngui‑ne ndso̱koiì. ");
INSERT INTO maaNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús kitsò‑la̱: ―Ti̱koa̱á tjít'aà Xo̱jo̱n‑la̱ Nainá, nga tsò: “Kì k'oa̱á s'ín chít'iì Na̱'èn‑ná xi Nainá.” ");
INSERT INTO maaNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ìjngoò k'a jè xi̱ta̱ nei̱í kiìko̱ Jesús i̱sòn nindoò xi 'ñó 'nga kji, koa̱ tsakó yije‑la̱ ngats'iì na̱xa̱ndá xi tjín i̱sò'nde ko̱ kjoa̱jeya‑la̱ jñà na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kitsò‑la̱: ―Nga ji̱í tsjaà yije‑lè na̱xa̱ndá koi, tsà ko̱si̱xkó'nchit'aà‑ná ko̱ jeya si̱kíjna‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","K'e̱é kitsò Jesús: ―Ti̱xín xi̱ta̱ nei̱í, ti̱si̱t'aàxìn‑ná. Nga k'oa̱á s'ín tjít'aà Xo̱jo̱n‑la̱ Nainá nga tsò: “Jeya ti̱kíjni Na̱'èn‑ná xi Nainá 'mì‑la̱; tà jè ta̱jngoò ti̱kitasòn‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","K'e̱é kiì jè xi̱ta̱ nei̱í, tsasìt'aàxìn‑la̱ Jesús. I̱kjoàn ijchò àkja̱le̱‑la̱ Nainá xi kisìs'in‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","K'e̱ nga kiì'nchré Jesús nga jè Juan xi kis'iìn bautizar xi̱ta̱ nda̱yá tíjna'ya, kiì ìjngoò k'a‑ne ya̱ i̱'nde‑la̱ ñánda 'mì Galilea. ");
INSERT INTO maaNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ta̱nga mì ya̱ tsibìjna ñánda 'mì Nazaret; ján kiì kíjna ñánda 'mì Capernaum, jngoò na̱xa̱ndá xi kijnandiì ndáchikon ya̱ i̱'nde xi chja̱‑ne Zabulón ko̱ Neftalí. ");
INSERT INTO maaNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","K'oa̱á s'ín komà mé‑ne nga tsitasòn‑ne 'én xi kiskiì Isaías xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá nga kitsò: ");
INSERT INTO maaNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Jè nangui xi ts'e̱ Zabulón ko̱ jè nangui xi ts'e̱ Neftalí, ya̱ ndi̱yá xi fì i̱ndiì ndáchikon, ján xijngoaà xa̱jngá nandá Jordán ya̱ nangui Galilea, ñánda tjín xi mìtsà xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Jñà xi̱ta̱ na̱xa̱ndá koi xi tjíjñò kjo̱hítsjeèn‑la̱, kijtseè jngoò ni'ín xi 'ñó tse kji, koa̱ jñà xi̱ta̱ xi ya̱ tjímaya ndi̱yá‑la̱ kjoa̱biyaà, kjòhiseèn kjo̱hítsjeèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","K'e̱é tsibíts'ia̱ Jesús nga kiìchja̱ya 'én ndaà‑la̱ Nainá. Kitsò: ―Ti̱kájno jé‑nò, kì ti̱ jé binchaàtsji‑nò nga jyeé kjòchrañàt'aà‑nò na̱chrjein nga jcha̱a kós'ín otíxoma jè xi ngajmiì nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","K'e̱ nga tífa Jesús ya̱ i̱ndiì ndáchikon ts'e̱ Galilea, kijtseè jò xi̱ta̱ xi 'ndse̱ ma, jngoò xi 'mì Simón ko̱ ti̱jè‑ne xi 'mì Pedro, ko̱ xi ìjngoò, jè xi 'mì Andrés. Jñà xi̱ta̱ koi xi sík'en ti̱n. K'e̱ nga nchisíkatje̱n‑jiìn‑ndá na̱'ya‑la̱, ");
INSERT INTO maaNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús kitsò‑la̱: ―Nchrohótji̱ngui‑ná, 'a̱án tsjaà‑nò xá nga kíxkóya xi̱ta̱ xi 'a̱n kjìt'aà‑na koni s'ín maxkóya ti̱n. ");
INSERT INTO maaNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jñà xi̱ta̱ koi ni̱to̱ón kisìkájna na̱'ya‑la̱ nga kiìtji̱ngui‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ìsa̱ xijngoaà ìsa̱ Jesús kijtseè nguì jò xi̱ta̱ xi ti̱koa̱ 'ndse̱ ma‑ne; jngoò xi 'mì Jacobo, ko̱ xi ìjngoò, Juan 'mì; i̱xti‑la̱ Zebedeo. Ya̱á títsa̱ya chitso ko̱ na̱'èn‑la̱. Nchibíndaàya jñà na̱'ya‑la̱. Jesús kiìchja̱‑la̱ nga jñà ko̱jmeiìko̱. ");
INSERT INTO maaNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Xi̱ta̱ koi ni̱to̱ón kisìkájna chitso‑la̱ ko̱ na̱'èn‑la̱ nga kiìtji̱ngui‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús tsajmeè kóho̱kji nangui Galilea, tsakóya 'én‑la̱ Nainá ya̱ ni'ya i̱ngo̱ sinagoga nga íjngó íjngó na̱xa̱ndá. Kiìchja̱ya 'én ndaà‑la̱ Nainá koni s'ín otíxoma Nainá; ti̱koa̱ kisìndaà‑ne ngats'iì ch'in xi tjín‑la̱ xi̱ta̱ nga xki̱ xi ján ijòjno ijòt'aà yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kina'yà‑la̱ Jesús kóho̱kji ya̱ i̱'nde ñánda 'mì Siria, koa̱ j'iìko̱‑la̱ xi̱ta̱ xk'én xi kjìn ska̱ya ch'in tjín‑la̱, jñà xi ijòjno ijòt'aà yijo‑la̱ ko̱ xi̱ta̱ xi ch'in nei̱í tíjiìn ini̱ma̱‑la̱, ko̱ tjín xi ch'in biyaàxín tjín‑la̱, ko̱ xi̱ta̱ xi mì kì ndaà ma síhiníyá yijo‑la̱. Jesús kisìndaà‑ne ngats'iì xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kjìn xi̱ta̱ xi ya̱ i̱'nde‑la̱ Galilea kiìtji̱ngui‑la̱, ko̱ jñà xi̱ta̱ na̱xa̱ndá xi te ma‑ne (xi 'mì Decápolis), ko̱ jñà xi̱ta̱ na̱xa̱ndá Jerusalén ko̱ na̱xa̱ndá xi i'nga xi ya̱ chja̱‑ne nangui Judea, ko̱ xi chja̱‑ne xijngoaà xa̱jngá nandá Jordán. ");
INSERT INTO maaNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús, k'e̱ nga kijtseè ngats'iì xi̱ta̱ xi kjìn ma‑ne, kiìmijìn‑jno ya̱ i̱sò'nga nindoò koa̱ ya̱á tsibìjna. Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ ijchò kinchat'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesús k'e̱é tsakóya‑la̱ kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Mé tà ndaà‑la̱ jñà xi̱ta̱ xi machi̱ya‑la̱ nga mochjeén‑la̱ kjo̱ndaà‑la̱ Nainá; xi̱ta̱ koi, jyeé ts'e̱ ngats'iì kjo̱ndaà xi tjín ya̱ ñánda tíhotíxoma jè xi ngajmiì nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Mé tà ndaà‑la̱ jñà xi̱ta̱ xi kjindáya; Nainá si̱ìjetakòn‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Mé tà ndaà‑la̱ jñà xi̱ta̱ xi indaàjiìn tjín ini̱ma̱‑la̱; jñà tjoé‑la̱ nangui xi Nainá jye k'oa̱s'ín kitsò nga jñà tsjá kjo̱tjò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Mé tà ndaà‑la̱ jñà xi̱ta̱ xi 'ñó mejèn‑la̱ nga ki̱tasòn xi kjoa̱ kixi̱ xi Nainá síjé; Nainá ko̱si̱ko̱ nga ki̱tasòn kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Mé tà ndaà‑la̱ jñà xi̱ta̱ xi mahi̱ma̱keè xi̱ta̱ xi kj'ei̱í; Nainá ko̱hi̱ma̱keè ngajo‑ne jñà xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Mé tà ndaà‑la̱ jñà xi̱ta̱ xi tsjeè tjín ini̱ma̱‑la̱; jñà xi̱ta̱ koi, jñà‑né xi skoe̱xkon Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Mé tà ndaà‑la̱ jñà xi̱ta̱ xi síkijna'nchán kjoa̱; Nainá ki'ndí‑la̱á ki̱tso̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Mé tà ndaà‑la̱ jñà xi̱ta̱ xi kjo̱'in tjín‑la̱ nga fìtji̱ngui kondra̱‑la̱ xi̱ta̱, koi kjoa̱‑la̱ nga ndaà síkitasòn xi kjoa̱kixi̱. Xi̱ta̱ koi, jyeé ts'e̱ ngats'iì kjo̱ndaà xi tjín ya̱ ñánda tíhotíxoma jè xi ngajmiì nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Mé tà ndaà‑nò k'e̱ nga jñà xi̱ta̱ ch'o ki̱tso̱‑nò nga ko̱tít'aà‑nò ko̱ k'e̱ nga ch'o si̱ìko̱‑nò, ko̱ k'e̱ nga 'én ndiso tsját'in‑nò xi kjoa̱ ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tsja t'è‑là ini̱ma̱‑nò, koa̱ tsja t'è‑là takòn. Jñò, tseé kjo̱ndaà tjoé‑nò ján ngajmiì. Mìtsà tà jñò xi o̱tínìko̱‑nò. K'oa̱á ti̱s'ín kinìko̱ jñà xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá xi chinchima ítjòn‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Jñò, k'oa̱á s'ín ngaya‑nò koni tsà na̱xa̱ xi mochjeén‑la̱ xi̱ta̱ i̱sò'nde. Ta̱nga tsà jè na̱xa̱ mì ti̱ kiì si̱ìjnchra‑ne tsojmì, ¿kó ti̱s'ín ko̱chjeén‑ne? Mì ti̱ mé chjí‑la̱; xíxteèn‑ne ko̱ ya̱á ki̱nchanè xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Jñò, k'oa̱á s'ín ngaya‑nò koni tsà ni'ín xi mochjeén‑la̱ xi̱ta̱ i̱sò'nde. Tsà jngoò na̱xa̱ndá xi i̱sò'nga nindoò kijna, mìkiì ko̱ma kíjna'ma. ");
INSERT INTO maaNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","K'e̱ nga jngoò ni'ín sit'a'í, mìtsà ya̱ si̱jnangui kaxa̱. Ya̱á si̱jna ñánda 'nga choòn, mé‑ne nga ko̱hiseèn yije‑la̱ xi̱ta̱ xi títsa̱jnaya ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Koni ni'ín xi síhiseèn‑la̱ xi̱ta̱, k'oa̱á s'ín ndaà ti̱jchá yijo‑nò nguixko̱n xi̱ta̱ xi kj'ei̱í, mé‑ne jñà xi̱ta̱ koi, jeya si̱ìkíjna Na̱'èn‑nò xi Nainá xi tíjna ngajmiì k'e̱ nga skoe̱‑nò nga ndaà titsa̱'nè. ");
INSERT INTO maaNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Jñò, kì k'oa̱á s'ín nìkítsjeèn: mìtsà koi xá j'i̱‑na 'a̱n nga kochrjekànguia jè kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés ko̱ jè xi tsakóya xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. Tà sa̱á j'i̱ sìjngoò‑ná 'én xi tjít'aà kjo̱tíxoma. ");
INSERT INTO maaNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","O̱kixi̱í xi xan‑nò, koni tjín na̱chrjein kíjna‑ìsa i̱sò'nde ko̱ ngajmiì, ni̱mé xi tjáxìn‑la̱ jè kjo̱tíxoma, ni̱jngoò punto ko̱ ni̱jngoò letra tjáxìn‑la̱, skanda kóni nga ko̱jngoò yije kjoa̱ xi tjít'aà kjo̱tíxoma. ");
INSERT INTO maaNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jè xi̱ta̱ xi mìkiì síkitasòn koni s'ín tíchja̱ kjo̱tíxoma, na̱s'ín 'ñó chiba tíchja̱, ko̱ k'oa̱á s'ín okóya‑la̱ xi̱ta̱, k'oa̱á ti̱s'ín 'ñó chiba jcha̱‑la̱ ya̱ i̱jiìn na̱xa̱ndá xi jè otíxoma‑la̱ xi ngajmiì nchrobá‑ne. Ko̱ jè xi̱ta̱ xi síkitasòn kjo̱tíxoma‑la̱ Nainá ko̱ k'oa̱s'ín okóya‑la̱ xi̱ta̱ xi kj'ei̱í, jè xi̱ta̱ jè, jè xi 'ñó 'nga kíjna ya̱ i̱jiìn na̱xa̱ndá xi jè otíxoma‑la̱ xi ngajmiì nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","O̱kixi̱í xi xan‑nò, tsà mìkiì ìsa̱ ndaà si̱kitasòn kjoa̱kixi̱ koni jñà xi̱ta̱ fariseo ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, mìkiì ki̱tjás'e̱n‑jñoò ñánda tíhotíxoma jè xi ngajmiì nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Jñò jye kina'yà koni s'ín ki'mì‑la̱ jñà xi̱ta̱ jchínga‑nò: “Kì xi̱ta̱ nìk'eèn; ni̱ta̱ yá‑ne xi xi̱ta̱ si̱ìk'en, kjo̱'in s'e̱‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ta̱nga 'a̱n k'oa̱á xan‑nò, tsà jngoò xi̱ta̱ xi ko̱jtikeè 'ndse̱, s'e̱é‑la̱ kjo̱'in. Jè xi ch'o ki̱tso̱‑la̱ 'ndse̱, xi̱ta̱xá tsjá‑la̱ kjo̱'in. Ko̱ jè xi 'ndse̱ ki̱tso̱‑la̱: “Ngaji̱ ni̱mé chjí‑lè”, ok'ìn‑la̱ nga ján kjoi̱ i̱jiìn ni'ín ts'e̱ i̱'nde kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Tsà k'e̱ nga kíkoi̱i tsojmì kjo̱tjò‑lè nga Nainá k'oi̱‑la̱ ya̱ i̱'nde tsjeè‑la̱, koa̱ ya̱ koi̱ìtsjeèn‑lè nga jè 'ndsì tjín‑la̱ kondra̱ tsi̱ji, ");
INSERT INTO maaNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ti̱kítsajnei tsojmì kjo̱tjò‑lè ya̱ i̱'nde tsjeè, i̱kjoàn tikìtsi'ba‑la̱ 'ndsì koa̱ k'e̱é ko̱ma si̱kítsajnei tsojmì‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Tsà tjín xi̱ta̱ xi ko̱hòngui‑lè nga kji̱ko̱‑lè ni'ya osen, k'e̱ nga tjaàya ndi̱yá, ni̱to̱ón jchi̱bàndaà‑nò, mé‑ne nga mì ya̱ kji̱ko̱‑lè nguixko̱n xi̱ta̱xá, ko̱ jè xi̱ta̱xá mì ya̱ tsjá‑la̱ kinda̱ jñà policía nga mì nda̱yá kji̱ko̱‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","O̱kixi̱í xi xan‑lè, mì ti̱ kiì ko̱ma ki̱tjo̱o‑ne nda̱yá skanda k'e̱ nga kíchjítjì yijo‑lè nga yije xi si̱ìjé‑lè xi̱ta̱xá. ");
INSERT INTO maaNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Jñò, jye kina'yà koni s'ín ki'mì‑nò kjòtseé: “Kì kjoa̱ chijngui 'nè.” ");
INSERT INTO maaNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ta̱nga 'a̱n k'oa̱á xan‑nò, ni̱ta̱ yá‑ne xi kotsejèn‑jno jngoò chjo̱ón nga fahajiìn‑la̱, jye kjoa̱ chijngui tís'ín koni títsò ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Tsà jñà xkoòn kixi̱ ótsji jé‑nò, ti̱nachrjeè; kjiìn ti̱katsjoò. Ìsa̱á ndaà‑ne tsà chija jngoò xkoòn mì k'oa̱á‑ne tsà ya̱ ki̱xo̱jiìn yije yijo‑nò ya̱ i̱jiìn ni'ín ya̱ i̱'nde kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tsà jñà ndsei̱i kixi̱ ótsji jé‑nò, ti̱chátjòn; kjiìn ti̱katsjoò. Ìsa̱á ndaà‑ne tsà chija jngoò ndsei̱i mì k'oa̱á‑ne tsà ján kjoi̱ yijo‑nò i̱jiìn ni'ín ya̱ i̱'nde kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’K'oa̱á ti̱s'ín kis'eno̱jmí kjòtseé, ni̱ta̱ yá xi̱ta̱‑ne xi mejèn‑la̱ tsjín chjo̱ón‑la̱, ítjòn tjámiì'nga xo̱jo̱n xi tsjeiìn‑ne xíkjín xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ta̱nga 'a̱n k'oa̱á xan‑nò: tsà jngoò xi̱ta̱ x'i̱n xi tsjín chjo̱ón‑la̱, tsà mìtsà kjoa̱ chijngui tís'ín jè chjo̱ón, jè x'i̱n‑la̱ tíbít'in‑la̱ nga kjoa̱ chijngui kàtas'ín chjo̱ón. Jè chjo̱ón, k'e̱ nga ki̱xan ìjngoò k'a‑ne, jè x'i̱n xi ki̱xan‑ko̱, ti̱koa̱á jye kjoa̱ chijngui tís'ín. ");
INSERT INTO maaNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ti̱koa̱á jye kina'yà koni s'ín ki'mì‑la̱ jñà xi̱ta̱ jchínga‑ná: “K'e̱ nga bixón: tíbeè Nainá, kì chona̱cha̱n‑jèn, ti̱kitasòn 'én‑nò.” ");
INSERT INTO maaNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ta̱nga 'a̱n k'oa̱á xan‑nò: K'e̱ nga 'bioò 'én‑nò, jngoò k'aá kì yá xi nìkíjna ítjòn. Kì k'oa̱s'ín bixón: “Tíbeè ngajmiì.” Nga jè ngajmiì, jè íxi̱le̱ kjo̱tíxoma‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ti̱koa̱á kì bixón‑jèn: “Tíbeè i̱sò'nde”, nga jè nangui, ya̱á nchasòn ndso̱ko̱ Nainá. Ti̱koa̱á kì bixón‑jèn: “Tíbeè na̱xa̱ndá Jerusalén”, nga jè na̱xa̱ndá jè, ts'e̱é Xi̱ta̱xá Ítjòn xi Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ti̱koa̱á kì skoò nìkíjna ítjòn k'e̱ nga mé 'én xi 'bioò. Nga mìkiì ko̱ma‑nò nga si̱jmà o si̱chroba jngoò tsja̱ skoò. ");
INSERT INTO maaNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tà k'oa̱á s'ín ti̱nókjoa̱a “jon”, o xi “majìn”. Jñà 'én xi kjisòn, ya̱á nchrobá‑ne i̱t'aà ts'e̱ xi̱ta̱ nei̱í. ");
INSERT INTO maaNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Jye kina'yà koni s'ín ki'mì‑nò kjòtseé: “Tsà yá xi ko̱chrje jngoò xkoiìn, ti̱nachrjeè ngajo‑ne ts'e̱. Ko̱ tsà yá xi skoe̱toòn‑lè nga skónáje̱n jngoò ni'ñoi, chjínáje̱n ngajo‑ne ts'e̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ta̱nga 'a̱n, k'oa̱á xan‑nò: Ti̱kjeiín‑là xi̱ta̱ ts'e̱n. Tsà jngoò xi̱ta̱ xi si̱ìjts'iìn‑t'aà kjioòn kixi̱, ti̱koa̱á tjiì‑là xi ngobà nga kàt'eé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tsà jngoò xi̱ta̱ ko̱hòngui‑nò nga mejèn‑la̱ skoé na̱chro̱‑nò, ti̱koa̱ tjiì‑là na̱chro̱kisòn‑nò nga kàtakjoé. ");
INSERT INTO maaNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tsà jngoò xi̱ta̱ xi kjò'ñó s'i̱n‑nò nga si̱ìkajen jngoò hora‑nò ch'á‑la̱ nga onguíko̱‑là, jò hora ìsa̱ kjiìn tanguíko̱‑là. ");
INSERT INTO maaNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tsà yá xi̱ta̱ xi síjé‑nò tsojmì, tjiì‑là; ko̱ tsà jngoò xi̱ta̱ xi mejèn‑la̱ ski̱ñat'aà‑nò tsojmì, kì 'mì‑là: mìkiì ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ti̱koa̱á jye kina'yà koni ki'mì‑nò kjòtseé: “Ti̱tsjacha xi̱ta̱ xinguio̱o ko̱ ti̱jticha kondra̱‑nò.” ");
INSERT INTO maaNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ta̱nga 'a̱n k'oa̱á xan‑nò: Ti̱tsjacha jñà xi kondra̱‑nò, ti̱chikon‑t'ioòn jñà xi chja̱'on‑ko̱‑nò, ndaà ti̱ko̱o jñà xi jtikeè‑nò, titsi'batjiò jñà xi ch'o tsò‑nò ko̱ jñà xi ch'o síko̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tsà k'oa̱s'ín s'e̱én, ki'ndí‑la̱ Nainá xi tíjna ngajmiì ko̱ma; Nainá síhiseèn‑la̱ ndobá‑la̱ ts'oí xi̱ta̱ xi ndaà ko̱ xi mì kì ndaà; ti̱koa̱á Nainá sík'a‑la̱ jtsí jñà xi̱ta̱ kixi̱ ko̱ xi mìtsà xi̱ta̱ kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jñò, tsà tà jñà matsjacha xi̱ta̱ xi matsjakeè‑nò, ni̱ mé kjo̱ndaà xi s'e̱‑nò; nga k'oa̱á ti̱s'ín jñà xi̱ta̱ xi síkíchjítjì tsojmì ts'e̱ Roma. ");
INSERT INTO maaNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tsà tà jñà xi̱ta̱ xinguio̱o xi 'ndsè chiba si̱xat'aà, ¿a k'oa̱á ma‑nò nga 'ñó ndaà titsa̱'nè?; nga ti̱koa̱á jñà xi̱ta̱ xi mìkiì beèxkon Nainá, k'oa̱á ti̱s'ín. ");
INSERT INTO maaNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jñò, nguì kjoa̱kixi̱í t'e̱en, koni jè Na̱'èn‑ná xi tíjna ngajmiì nga nguì kjoa̱kixi̱í s'ín. ");
INSERT INTO maaNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’K'e̱ nga ndaà tjín kjoa̱ xi 'nè, ti̱kinda̱ko̱‑nò yijo‑nò; kì tà k'e̱é k'oa̱ 'nè k'e̱ nga nguixko̱n xi̱ta̱, tsà tà jè xi mejèn‑nò nga skoe̱‑nò xi̱ta̱ xi kj'ei̱í. Tsà k'oa̱s'ín s'e̱en, Na̱'èn‑ná xi tíjna ngajmiì mìkiì si̱ìchikon‑t'in‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","K'e̱ nga jngoò kjo̱ndaà k'oi̱i‑là xi̱ta̱ i̱ma̱, kì kiì bèno̱jmí‑là ngats'iì xi̱ta̱ xi kj'ei̱í, koni s'ín xi̱ta̱ xi jò i̱sén tjín‑la̱ ya̱ ni'ya i̱ngo̱ sinagoga ko̱ ya̱ ndi̱yá nga tsjá kjo̱tjò‑la̱ tsojmì xi̱ta̱; tà jé xi mejèn‑la̱ nga skoe̱ yije xi̱ta̱. Ta̱nga o̱kixi̱í xi xan‑nò, jñà xi̱ta̱ xi k'oa̱s'ín s'ín, jyeé tjín‑la̱ chjí‑la̱ nga nguixko̱n xi̱ta̱. Mì ti̱ mé si̱ìchikon‑t'in‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","K'e̱ nga tsà tsojmì k'oi̱ kjo̱tjò‑là xi̱ta̱ i̱ma̱, mochjeén‑né nga mì yá xi̱ta̱ xi skoe̱; ni̱ jè skoe̱ xi 'ñó amigo chibá. ");
INSERT INTO maaNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tjà'ma‑là jè kjo̱ndaà‑nò; k'e̱ nga jè Na̱'èn‑ná skoe̱ jè xi kjoa̱'ma, jè tsjá‑nò chjí‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’K'e̱ nga bìtsi'ba, kì k'oa̱á 'nè koni s'ín xi̱ta̱ xi jò i̱sén tjín‑la̱. Jñà xi̱ta̱ koi, k'e̱ nga bítsi'ba‑la̱ Nainá, tsjakeè‑né nga bincha kixi̱ ya̱ ni'ya i̱ngo̱ sinagoga ko̱ ya̱ chrja̱ngui̱‑la̱ ndi̱tsi̱n ñánda kjìn xi̱ta̱ kotsejèn‑la̱ nga Nainá bítsi'ba‑la̱. Xi o̱kixi̱ k'oa̱á xan‑nò, jñà xi̱ta̱ koi, jyeé tjín‑la̱ chjí‑la̱ nga nguixko̱n xi̱ta̱. Mì ti̱ mé si̱ìchikon‑t'in‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ta̱nga k'e̱ nga mejèn‑lè nga kítsi'ba‑la̱ Na̱'èn‑ná, ti̱tjás'i̱in ni'ya‑lè, tichjoì xotjoa̱‑la̱ ni'ya‑lè, i̱kjoàn ti̱jé‑la̱ kjo̱ndaà‑la̱ Na̱'èn‑ná xi ya̱ ta̱jngoò tíjna'mako̱‑lè. Jè Na̱'èn‑ná tsjá‑lè chjí‑lè nga jè tíbeè xi kjoa̱'ma. ");
INSERT INTO maaNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’K'e̱ nga bìtsi'ba, kì ta̱xki̱ kjìn 'én nokjoà, koni s'ín xi̱ta̱ xi mìkiì beèxkon Nainá. K'oa̱á s'ín síkítsjeèn nga kjìn 'én ki̱chja̱‑la̱ Nainá, ìsa̱á ndaà kji̱'nchré‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kì k'oa̱á 'nè koni s'ín jñà xi̱ta̱ koi; jè Na̱'èn‑ná jye tíjiìn‑la̱ mé xi mochjeén‑nò k'e̱ nga ti̱kj'eè nìjét'aà‑là. ");
INSERT INTO maaNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","K'e̱ nga bìtsi'ba, kiís'ín ti̱nókjoa̱a: Na̱'èn‑na̱je̱n xi tijni ngajmiì, kàtayaxkón‑la̱ kjoa̱jeya‑lè nga tsjeè tijni. ");
INSERT INTO maaNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kàtjanchrobá kjo̱tíxoma‑lè, k'oa̱s'ín kàtama i̱ i̱t'aà nangui koni s'ín mejèn‑lè nga ko̱ma, koni s'ín ma ján ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tjiì‑náje̱n i̱'ndei̱ jè ni̱ño̱ xi mochjeén‑naje̱n nga na̱chrjein inchijòn. ");
INSERT INTO maaNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ti̱jchàat'aà‑náje̱n jé‑na̱je̱n koni s'ín nìjchàat'aà‑la̱je̱n jñà xi̱ta̱ xi ch'o síko̱‑na̱je̱n. ");
INSERT INTO maaNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kì kiì biì'ndi yá xi mejèn‑la̱ nga kot'aà‑naje̱n nga ki̱nchátsji jé‑je̱n. Ti̱kinda̱‑náje̱n xi i̱t'aà ts'e̱ xi̱ta̱ nei̱í. Nga̱ tsi̱jií kjo̱tíxoma, tsi̱jií nga'ñó ko̱ tsi̱jií kjoa̱jeya ni̱ta̱ kjé‑ne. K'oa̱s'ín kàtama. ");
INSERT INTO maaNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Tsà jñò si̱jchàat'aà‑là jé‑la̱ xi̱ta̱ xi kj'ei̱í, ti̱koa̱á jè Na̱'èn‑ná xi tíjna ngajmiì si̱ìjchàat'aà‑nò jé‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ta̱nga tsà jñò mìkiì si̱jchàat'aà‑là jé‑la̱ xi̱ta̱, ti̱koa̱á Na̱'èn‑ná mìkiì si̱ìjchàat'aà‑nò jé‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’K'e̱ nga bitsa̱jnachjan, kì k'oa̱á 'nè koni s'ín jñà xi̱ta̱ xi jò i̱sén tjín‑la̱ nga síkjatjìya i̱sén‑la̱, mé‑ne nga skoe̱‑ne xi̱ta̱ nga ba tjín‑la̱ nga títsa̱jnachjan. Xi o̱kixi̱, k'oa̱á xan‑nò, jñà xi̱ta̱ koi, jyeé kitjoé‑la̱ chjí‑la̱ nga nguixko̱n xi̱ta̱. Mì ti̱ mé si̱ìchikon‑t'in‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ta̱nga jñò, k'e̱ nga bitsa̱jnachjan, kì k'oa̱á 'nè. Ta̱ sa̱á ta̱nìjnoò i̱sén‑nò ko̱ ta̱si'a tsja̱skoò, ");
INSERT INTO maaNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","mé‑ne nga mìkiì skoe̱‑nò xi̱ta̱ tsà titsa̱jnachjan, ko̱ jè Na̱'èn‑ná xi tíjna'mako̱‑nò, ta̱ jè xi tíbeè. Jè si̱ìchikon‑t'in‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Jñò, kì tsojmì kjìn binchatjò i̱ i̱sò'nde; bits'on‑né ko̱ makixo‑né ko̱ jñà xi̱ta̱ síchijé. ");
INSERT INTO maaNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ta sa̱á ján ngajmiì ti̱nchatjò tsojmì. Ján ngajmiì mìkiì bits'on ko̱ mìkiì makixo tsojmì; ti̱koa̱á tsjìn xi̱ta̱ chijé. ");
INSERT INTO maaNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ya̱ ñánda ki̱nchatjò tsojmì‑nò, ti̱koa̱á ya̱á si̱ìkítsjeèn ini̱ma̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Jñà xkoaán, jè ma ni'ín xi síhiseèn‑la̱ yijo‑ná. Koií kjoa̱‑la̱ k'e̱ nga ndaà tsejèn‑ná, iseèn choòn yije‑la̱ yijo‑ná; ");
INSERT INTO maaNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ta̱nga tsà mìkiì ndaà tsejèn‑la̱ xkoiìn, ti̱koa̱á kóho̱kji yijo‑lè, tà jñò choòn‑la̱. Nga tjíjñò‑la̱ kjo̱hítsjeèn‑lè ti̱koa̱á nguì tà jñò choòn‑la̱ yijo‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ni̱jngoò xi̱ta̱ xi jò ko̱ma nei‑la̱ nga si̱ìxá‑la̱. Tsà jò ko̱ma nei‑la̱, jngoò ko̱jtikeè koa̱ jngoò ko̱tsjakeè; jngoò ndaà kjit'aà‑la̱ koa̱ ch'o si̱ìko̱ xi ìjngoò. Jñò, tsà kjoa̱ nchi̱ná si̱ìs'in‑là, mìkiì ko̱s'in‑la̱ kjoa̱ ts'e̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’K'oa̱á xan‑nò, kì makájno‑nò mé tsojmì xi chji̱ne̱e, xi s'io̱o, nga si̱jchá yijo‑nò, ko̱ mé nikje xi chi̱kjá. ¿A mì 'ya‑jèn k'e̱ nga titsa̱jnakoaán i̱ i̱sò'nde tjín‑ìsa kjoa̱ xi ìsa̱ 'ñó chjí‑la̱ mì k'oa̱‑ne koni tsojmì xi ma chine? Ti̱koa̱á yijo‑ná, tjín‑ìsa kjoa̱ xi ìsa̱ 'ñó chjí‑la̱ mì k'oa̱‑ne koni jè nikje xi chíkjá. ");
INSERT INTO maaNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chítsejèn‑là ni̱se xi tjíma i̱jiìn i̱sén; mì jno̱ó 'beé; mì ni̱ji̱n majchá‑la̱ koa̱ mì ni'nga tjín‑la̱ ñánda bincháxkó ni̱ji̱n‑la̱; ta̱nga jè Na̱'èn‑ná xi tíjna ngajmiì tsjá‑la̱ tsojmì xi kine; koa̱ jñò, ìsa̱á chjí‑nò mì k'oa̱‑ne jñà ni̱se. ");
INSERT INTO maaNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Jñò, na̱s'ín ta̱kó 'ñó si̱kájnoò, ni̱ i̱tsé ko̱ma si̱katonè‑là na̱chrjein‑nò koni s'ín tjíndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Mé‑ne nìkájno‑nò xi i̱t'aà ts'e̱ nikje xi chi̱kjá? Chítsejèn‑là naxó lirio xi majchá i̱jiìn ijñá; mìkiì síxá ko̱ mìkiì ma‑la̱ faña nikje. ");
INSERT INTO maaNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ta̱nga 'a̱n, k'oa̱á xan‑nò, ndaà tsà jè Salomón xi xi̱ta̱xá ítjòn tsibìjna nga 'ñó xi̱ta̱ jeya, mì k'oa̱á kjoàn nikje xi tsohòkjá koni kjoàn jñà naxó nga ndaà kjoàn. ");
INSERT INTO maaNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nainá, k'oa̱á s'ín ndaà kjoàn s'ín xka̱ ijñá, xi jngoò na̱chrjein títsa̱jnakon ko̱ xi ma nchijòn kotsjòojiìn ni'ín. Jñò xi xi̱ta̱ 'mì‑nò xi mìkiì ndaà mokjeiín‑nò, ¿a mìtsà ìsa̱ ni̱to̱n tsjá‑nò Nainá nikje xi mochjeén‑nò nga chi̱kjá? ");
INSERT INTO maaNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kì makájno‑nò, kì bixón‑jèn: “¿Mé xi chji̱ne̱é?, ko̱ ¿mé xi s'ioa̱á? ko̱ ¿mé nikje xi chi̱kjá?” ");
INSERT INTO maaNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nga yije tsojmì koi, k'oa̱á tjín xi ótsji jñà xi̱ta̱ xi mìkiì mokjeiín‑la̱ i̱t'aà ts'e̱ Nainá. Ta̱nga jñò tíjnaá‑nò Na̱'èn xi tíjna ngajmiì xi jyeé tíjiìn‑la̱ nga mochjeén‑nò ngats'iì tsojmì koi. ");
INSERT INTO maaNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ítjòn ti̱nchátsjioò kjoa̱ ts'e̱ Nainá koni s'ín otíxoma ko̱ kjoa̱kixi̱‑la̱; ngats'iì tsojmì xi mochjeén‑nò tà tjoésòn‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kì makájno‑nò mé kjoa̱ xi s'e̱ nchijòn‑lè; nga nchijòn‑lè, s'e̱é‑nò kjoa̱ xi ko̱kájno‑nò; tà koií kjoa̱ ti̱kájno xi tjín na̱chrjein i̱'ndei̱. ");
INSERT INTO maaNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Kì kjo̱'in 'biì‑là xi̱ta̱ xinguio̱o kjoa̱ ts'e̱ jé‑la̱ mé‑ne nga mì kjo̱'in tjoé‑nò kjoa̱ ts'e̱ jé‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Koni s'ín k'oi̱‑là kjo̱'in xi̱ta̱ xi kj'ei̱í, k'oa̱á ti̱s'ín tjoé ngajo‑nò kjo̱'in. Jè chi̱ba̱ xi si̱chi̱ba̱ya‑là xinguio̱o, ti̱jè ko̱chi̱ba̱ ngajo‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Mé‑ne jé‑la̱ xingui̱i nìkinda̱‑ne koa̱ tsi̱ji mìkiì nìkindi̱i? ¿Mé‑ne chìtsejèn‑la̱ jè tjé xi kjinangui xko̱n xingui̱i, ko̱ jè yá chi̱so̱ xi kjinangui xkoiìn mìkiì chìtsejèn‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tsà yá chi̱so̱ kjinangui xkoiìn, ¿a ko̱ma k'oín‑la̱ xi̱ta̱ xingui̱i: “Tjiì'nde‑ná nga kochrjekànguia tjé xi kjinangui xkoiìn”? ");
INSERT INTO maaNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ngaji̱ xi jò ma i̱sén‑lè, ítjòn ti̱nachrjekàngui chi̱so̱ xi kjinangui xkoiìn mé‑ne nga ndaà ko̱tsejèn‑lè, i̱kjoàn ti̱nachrjekàngui tjé xi kjinangui xko̱n xingui̱i. ");
INSERT INTO maaNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Tsojmì tsjeè xi ts'e̱ Nainá, kì nañá 'biì‑la̱ mé‑ne nga mì ya̱ si̱ìkáfat'aà‑lè ko̱ ya̱ ski̱ne̱‑lè. Koa̱ jè ndáto̱n chjí xi nìkjiín, kì chi̱nga̱ nìkatje̱n‑la̱ mé‑ne nga mì ndso̱ko̱ ki̱nchanè‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Ti̱jé mé xi mejèn‑nò, jè Nainá tsjá‑nò; ti̱nchátsjioò Nainá, sakó‑nò; ti̱nókjoa̱t'aà‑là Nainá mé xi mejèn‑nò mé‑ne skíx'a̱'nde‑nò koni jngoò xotjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ngats'iì xi̱ta̱ xi síjé, tjoé‑la̱, jè xi ótsji, sakó‑la̱ ko̱ jè xi chja̱t'aà‑la̱ Nainá, táx'a̱'nde‑la̱ koni jngoò xotjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Jñò xi xi̱ta̱ jchínga 'mì‑nò, tsà i̱nchra̱jín si̱ìjé‑nò i̱xti‑nò, ¿a nda̱jo̱ó k'oi̱‑là? Majìn. ");
INSERT INTO maaNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Koa̱ tsà ti̱n si̱ìjé‑nò, ¿a ye̱é k'oi̱‑là? Majìn. ");
INSERT INTO maaNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jñò na̱s'ín xi̱ta̱ xi ch'o 'nè, ma‑nò 'biì‑là i̱xti‑nò tsojmì xi ndaà kjoàn. Jè Na̱'èn‑nò xi tíjna ngajmiì, ìsa̱á ni̱to̱n si̱ìs'in‑nò nga tsjá‑nò tsojmì xi ndaà kjoàn tsà jñò si̱jét'aà‑là. ");
INSERT INTO maaNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ni̱ta̱ mé kjo̱ndaà xi mejèn‑nò nga si̱ìko̱‑nò xi̱ta̱, k'oa̱á ti̱s'ín ti̱ko̱ ngajo‑nò. K'oa̱á s'ín tíchja̱ kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés ko̱ xo̱jo̱n‑la̱ xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Ti̱tjás'io̱òn jè xotjoa̱ xi 'nchrèya kji. Jè xotjoa̱ ko̱ jè ndi̱yá xi 'ñó tiyà, ndi̱yá‑la̱ kjo̱'in‑né. Kjìn xi̱ta̱ xi ya̱ fahas'en. ");
INSERT INTO maaNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ko̱ jè xotjoa̱ ko̱ ndi̱yá xi 'nchrèya choòn, ndi̱yá‑la̱ kjoa̱binachon‑né, ko̱ chiba xi̱ta̱ matsji‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Ndaà ti̱kinda̱a yijo‑nò i̱t'aà ts'e̱ xi̱ta̱ ndiso xi tsò nga 'én‑la̱ Nainá síka'bí. K'e̱ nga f'iìkon‑nò jñà xi̱ta̱ koi, i̱ma̱ kjoa̱á s'ín koni orrè ta̱nga ini̱ma̱‑la̱, tse̱jén ts'e̱én 'ya. ");
INSERT INTO maaNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jñò jcha̱xkoòn xi̱ta̱ koi i̱t'aà ts'e̱ xá xi s'ín. K'oa̱á ngaya‑la̱ koni jngoò yá xi ndaà toò ojà‑la̱. Jè toò uva, mìtsà jè majchá‑la̱ yá na'yá. Ti̱koa̱á jè toò iko̱, mìtsà jè majchá‑la̱ yá na'yá. ");
INSERT INTO maaNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ngats'iì yá xi ndaà kjoàn, ndaà toò ojà‑la̱. Ta̱nga jè yá xi mìkiì ndaà kjoàn, mìkiì ndaà toò xi ojà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jngoò yá xi ndaà kji, mìtsà ch'o kjoàn toò xi ojà‑la̱. Koa̱ jè yá xi ch'o kji, mìkiì ojà‑la̱ toò xi ndaà kjoàn. ");
INSERT INTO maaNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nga yije yá xi mìkiì ojà‑la̱ toò xi ndaà, sa̱tèsòn‑la̱ i̱kjoàn si̱nchájiìn ni'ín nga ki̱ti̱. ");
INSERT INTO maaNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","K'oa̱á s'ín jcha̱xkoòn xi̱ta̱ koi i̱t'aà ts'e̱ xá xi s'ín. ");
INSERT INTO maaNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Mìtsà tà ngats'iì xi̱ta̱ xi tsò‑na: “Na̱'èn, Na̱'èn”, kjoa̱s'en‑jiìn jè kjo̱tíxoma‑la̱ ngajmiì. Tà jñà xi̱ta̱ xi kjoa̱s'en‑jiìn xi síkitasòn koni s'ín mejèn‑la̱ Na̱'èn‑na xi tíjna ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","K'e̱ nga ki̱jchò na̱chrjein, kjìn xi̱ta̱ ki̱tso̱‑na: “Na̱'èn, Na̱'èn, ngaje̱n kinokjoàya‑náje̱n 'én‑lè xi i̱t'aà tsi̱ji. Nga ko̱ó 'ín‑lè kinachrjekàjiìn‑náje̱n ini̱ma̱ ch'o‑la̱ nei̱í xi mìkiì ndaà; ti̱koa̱á kjìn kjo̱xkón ki'nè‑je̱n xi ndaà tjín.” ");
INSERT INTO maaNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","K'e̱é k'oa̱ xán‑la̱: “Mìkiì bexkon‑nò. Ti̱nchat'aàxìn‑ná jñò xi ch'o ki'nè.” ");
INSERT INTO maaNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Jè xi 'nchré koa̱ síkitasòn 'én‑na̱ koni xan‑la̱, k'oa̱á s'ín ngaya‑la̱ koni jngoò xi̱ta̱ xi tjín‑la̱ kjo̱hítsjeèn; ya̱á bíndaàsòn ni'ya‑la̱ ñánda na̱xi̱ choòn. ");
INSERT INTO maaNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","'Ba jtsí; 'ba tjo̱xkón; f'iì xa̱jngá nandá xi fahanè ni'ya; nì mé xi ma‑la̱ nga ndaà tjíndaà jè ni'ya, ya̱á kijnasòn ñánda na̱xi̱ choòn. ");
INSERT INTO maaNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ta̱nga ni̱ta̱ yá‑ne xi 'nchré 'én‑na̱ ko̱ mìkiì síkitasòn, k'oa̱á ngaya‑la̱ koni jngoò xi̱ta̱ xi tsjìn‑la̱ kjo̱hítsjeèn; ya̱á bíndaàsòn ni'ya ñánda jncha tsomì. ");
INSERT INTO maaNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","'Ba jtsí; 'ba tjo̱xkón; f'iì xa̱jngá nandá ya̱á bixòña ni'ya jè; mì tà k'oa̱á kji kjoa̱ xi ma k'e̱ nga bixòña. ");
INSERT INTO maaNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","K'e̱ nga jye kiìchja̱ Jesús, ngats'iì xi̱ta̱ xi títsa̱jna, tà k'oa̱á komà‑la̱ koni tsò 'én xi tsakóya. ");
INSERT INTO maaNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","K'oa̱á s'ín tsakóya koni jngoò xi̱ta̱ xi 'ñó tjín‑la̱ kjo̱tíxoma, mìtsà k'oa̱s'ín tsakóya koni xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. ");
INSERT INTO maaNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","K'e̱ nga itjojen‑ne Jesús ya̱ i̱sò'nga nindoò, kjìn xi̱ta̱ j'iìtji̱ngui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jngoò xi̱ta̱ xi tíbindojno chrjoa̱ yijo‑la̱ ijchòkon koa̱ tsasìxkó'nchit'aà‑la̱, kitsò‑la̱: ―Na̱'èn, tsà mejèn‑lè, ti̱tsjeè‑ná ch'in xi tjín‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús, k'e̱é tsijmeé tsja nga tsohót'aà‑la̱ yijo‑la̱ xi̱ta̱ jè, kitsò‑la̱: ―Mejèn‑na, kàtandaà‑ne yijo‑lè. K'e̱ nga o̱kitsò Jesús, ni̱to̱ón kjòndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","K'e̱é kitsò‑la̱ Jesús: ―Ti̱ná'yi, kì yá xi̱ta̱ xi bèno̱jmí‑la̱. T'in ñánda tíjna no̱'miì, ta̱kó‑la̱ yijo‑lè nga jyeé kjòndaà‑ne; koa̱ jch'i̱i kjo̱tjò‑lè, tsojmì xi síjé kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, mé‑ne nga kàteè‑ne jñà xi̱ta̱ nga jyeé kjòndaà‑ne ch'in‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","K'e̱ nga jahas'en Jesús ya̱ na̱xa̱ndá Capernaum, jngoò xi̱ta̱ sko̱‑la̱ soldado ts'e̱ Roma ijchòkon, kisìjé‑la̱ kjo̱ndaà. ");
INSERT INTO maaNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Kitsò‑la̱: ―Na̱'èn, xi̱ta̱ chi̱'nda‑na̱ kijna‑né ján ni'ya‑na̱. Tsí 'ñó xk'én koa̱ tífa kjo̱'in nga mìkiì ma síhiníyá yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús kitsò‑la̱: ―Ko̱ma kjísìndaà‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jè xi̱ta̱ sko̱‑la̱ soldado kitsò: ―Na̱'èn, mìkiì ok'ìn‑na nga ngaji̱ k'oín sobì ni'ya‑na̱, ta̱ sa̱á tjiì o̱kixi̱ nga kàtandaà‑ne, koa̱ ko̱ndaà‑ne chi̱'nda‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","'A̱n, tíjiìn‑na nga tjín‑lè kjo̱tíxoma. Ti̱koa̱á 'a̱n, tjín‑na xi̱ta̱ ítjòn xi otíxoma‑na, ti̱koa̱á tjín‑na soldado xi 'a̱n otiìxoma‑la̱, k'e̱ nga xan jngoò‑la̱: “T'in”, fì‑né; xan‑la̱ xi ìjngoò: “Nchroboí”, nchrobá‑né; koa̱ k'e̱ nga xan‑la̱ jè xi chi̱'nda‑na̱: “K'oa̱ t'i̱in”, síkitasòn‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","K'e̱ nga kiì'nchré Jesús jñà 'én koi, tà kjòxkón‑la̱. Kitsò‑la̱ jñà xi̱ta̱ xi tji̱ngui‑la̱: ―O̱kixi̱í xi xan‑nò, ya̱ Israel ni̱ sa̱á jngoò xi̱ta̱ sakó‑na xi k'oa̱s'ín ndaà mokjeiín‑la̱ koni jè xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","K'oa̱á xan‑nò, kjìn xi̱ta̱ kjoi̱í‑ne nga ñijòn chrja̱ngui̱‑la̱ i̱sò'nde xi ko̱kje̱n‑ko̱ Abraham ko̱ Isaac ko̱ Jacob ya̱ ngajmiì ñánda tíhotíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ta̱nga jñá xi̱ta̱ xi tjín‑ne nga ya̱ kítsa̱jna ñánda ko̱tìxoma Nainá, ki̱tjokàjiìn‑né; ján kjoi̱ ndi̱tsin ñánda jñò choòn, ko̱ ya̱á ski̱ndàya koa̱ si̱ìjts'iìn ni̱'ño̱. ");
INSERT INTO maaNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","K'e̱é kitsò‑la̱ Jesús jè xi̱ta̱ sko̱‑la̱ soldado: ―T'in‑ne ni'ya‑lè; koni s'ín nga ndaà mokjeiín‑lè, k'oa̱á s'ín ko̱ma. Jè chi̱'nda‑la̱ ti̱k'e̱é kjòndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús kiì ni'ya‑la̱ Pedro koa̱ kijtseè na̱chíya‑la̱ nga kijna xk'én; ch'in tìjnga tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús tsohót'aà‑la̱ tsja jè chjo̱ón, ni̱to̱ón kjòndaà‑ne ch'in tìjnga‑la̱, tsasítje̱n‑ne jè chjo̱ón, i̱kjoàn kisìs'in‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","K'e̱ nga jye kòjñò, kjìn xi̱ta̱ xk'én j'iìko̱‑la̱ Jesús xi ini̱ma̱ ch'o‑la̱ nei̱í tjín‑la̱. Jesús tà jngoò o̱kixi̱ kitsjaà nga tsatíxoma‑la̱ mé‑ne nga itjokàjiìn‑ne ini̱ma̱‑la̱ jñà xi̱ta̱ ngats'iì ini̱ma̱ ch'o‑la̱ nei̱í, koa̱ kjòndaà yije‑ne xi̱ta̱ xk'én. ");
INSERT INTO maaNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kjoa̱ koi koni s'ín komà, koií tsitasòn koni kitsò Isaías xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá k'e̱ nga kitsò: “Jè jaàxìn ch'in‑ná ko̱ jè kisìkjeiín kjo̱'in nga kjòndaà‑ne ñánda kitsì'on yijo‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","K'e̱ nga kijtseè Jesús nga kjìn ma‑ne xi̱ta̱ xi kitseèndiì‑la̱, kitsjaà‑la̱ o̱kixi̱ xi̱ta̱ xi kota'yàt'aà‑la̱ nga kiì ján xijngoaà ndáchikon. ");
INSERT INTO maaNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","K'e̱é j'iì jngoò xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, ijchòkon Jesús, kitsò‑la̱: ―Maestro, kjítji̱ngui‑lè ni̱ta̱ ñánda nga k'oín. ");
INSERT INTO maaNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús kitsò‑la̱: ―Jñà ni̱nda̱ tjín‑la̱ nguijo ñánda oyijò, koa̱ jñà ni̱se tjín‑la̱ tjé, ta̱nga 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, tsjìn‑na i̱'nde ñánda síkjáya. ");
INSERT INTO maaNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ìjngoò xi̱ta̱ xi kota'yàt'aà‑la̱ kitsò‑la̱: ―Na̱'èn, tjiì'nde‑ná nga ítjòn kjián kìhijñaà na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús kitsò‑la̱: ―Ji̱, nchrobátji̱ngui‑ná, jñà mik'en kàtìhijiìn mik'en‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jahas'en Jesús jè chitso; kjihijtako̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tà ni̱to̱ón tsatsejèn jngoò tjo̱xkón ko̱ jtsí ya̱ i̱jiìn ndáchikon, ko̱ jè ndáchikon ta̱xki̱ komà‑né, mejèn bíjtsa'ma jè chitso. Ta̱nga jè Jesús kjinafé‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ k'e̱é kiìkon nga kisìkjaá‑la̱ Jesús, kitsò‑la̱: ―Na̱'èn, ti̱kinda̱‑náje̱n. Jye titsa̱bixònguindá. ");
INSERT INTO maaNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kiìchja̱ Jesús kitsò: ―¿Mé‑ne tsakjoòn‑nò? 'Ñó chiba mokjeiín‑nò xi i̱t'aà ts'a̱n. K'e̱é tsasítje̱n Jesús, tsohótiko̱ tjo̱xkón ko̱ ndáchikon koa̱ ni̱to̱ón kisijyò‑ne tjo̱ koa̱ kjòndaàya‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Koa̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ tà kjòxkón‑la̱, kitsò: ―Yá xi̱ta̱‑ne jè skanda jè tjo̱ ko̱ ndáchikon síkitasòn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","K'e̱ nga ijchò Jesús ján xijngoaà ndáchikon ya̱ nangui Gadara, jò xi̱ta̱ ijchò kinchat'aà‑la̱ xi ya̱ itjo‑ne ya̱ ñánda sihijiìn mik'en. Ini̱ma̱ ch'o‑la̱ nei̱í tjín‑la̱. 'Ñó jchán ts'e̱n, kjaán‑ko̱‑ne tsà yá xi ya̱ kjoa̱haya ndi̱yá. ");
INSERT INTO maaNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","'Ñó kiìchja̱ nga kitsò: ―¿Mé xi mejèn‑lè ko̱ ngaje̱n, ji̱ xi Ki'ndí‑la̱ Nainá 'mì‑lè? ¿A koií xá kòf'i̱‑ne nga jcha̱toòn‑náje̱n k'e̱ nga ti̱kj'eè bijchó na̱chrjein‑la̱ kjo̱'in? ");
INSERT INTO maaNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ya̱ chrañàt'aà‑la̱ kjìn jchán chi̱nga̱ nchikjèn‑jno, ");
INSERT INTO maaNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","koa̱ jñà ini̱ma̱ ch'o‑la̱ nei̱í tsibítsi'ba‑la̱ Jesús, kitsò‑la̱: ―Tsà ki̱nachrjekàjiìn‑náje̱n, tjiì'nde‑náje̱n nga ki̱tjás'e̱n‑jiìn‑je̱n yijo‑la̱ chi̱nga̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús kitsò‑la̱: ―Ndaà tjín, tanguió. I̱kjoàn itjojiìn yijo‑la̱ jñà xi̱ta̱ koi, k'e̱é jahas'en‑jiìn yijo‑la̱ jñà chi̱nga̱, koa̱ ngats'iì chi̱nga̱ tsatíkjájen‑jno ya̱ na̱xi̱ skanda i̱jiìn ndáchikon ko̱ ya̱á k'en. ");
INSERT INTO maaNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jñà xi̱ta̱ xi ko'ndà chi̱nga̱ tsanga; k'e̱ nga ijchò i̱jiìn na̱xa̱ndá, tsibéno̱jmí yije kjoa̱ xi komà ko̱ kjoa̱ xi komàt'in jñà xi̱ta̱ xi ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","K'e̱é ijchò ngats'iì xi̱ta̱ na̱xa̱ndá ñánda tíjna Jesús; k'e̱ nga kijtseèxkon tsibítsi'ba‑la̱ nga xìn nangui kàtjì. ");
INSERT INTO maaNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","K'e̱ nga jahas'en Jesús jè chitso, jahatot'aà xijngoaà ndáchikon koa̱ ijchò‑ne na̱xa̱ndá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ya̱ ijchòko̱ jngoò‑la̱ xi̱ta̱ xi mìkiì ma síhiníyá yijo‑la̱; kjinasòn‑la̱ na̱chan‑yá. K'e̱ nga kijtseè Jesús nga jñà xi̱ta̱ koi mokjeiín‑la̱ i̱t'aà ts'e̱, kitsò‑la̱ jè xi̱ta̱ xk'én: ―Ji̱ ndí na̱'èn, tjiì‑la̱ nga'ñó yijo‑lè; jé‑lè jye kichàat'aà‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jñà xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, tjín i'nga xi kitsò kjo̱hítsjeèn‑la̱: “Xi̱ta̱ jè, Nainá chja̱jno‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús ni̱to̱ón kijtseèya‑la̱ koni s'ín nchisíkítsjeèn, kitsò‑la̱: ―¿Mé‑ne ko̱tsò‑ne kjo̱hítsjeèn‑la̱ ini̱ma̱‑nò nga ch'o tsò‑ne? ");
INSERT INTO maaNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Mé xi ìsa̱ chiba 'in tjín, tsà xán‑la̱ jè xi̱ta̱ xi xk'én: “Jé‑lè jye kichàat'aà‑lè”, ko̱ tsà xán‑la̱: “Ti̱sítji̱in koa̱ ti̱tjeí”? ");
INSERT INTO maaNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kokoò‑nò nga 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, tjí'nde‑na nga sìjchàat'aà‑la̱ jé‑la̱ xi̱ta̱ i̱ i̱sò'nde. K'e̱é kitsò‑la̱ jè xi̱ta̱ xk'én: ―Ti̱sítji̱in, chjoí na̱chan‑lè, t'in‑ne ni'ya‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","K'e̱é tsasítje̱n jè xi̱ta̱ xk'én, kiì‑ne ni'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","K'e̱ nga kijtseè jñà xi̱ta̱ nga tsasítje̱n‑ne jè xi̱ta̱ xk'én, tà k'oa̱á ko̱ma‑la̱; k'e̱é jeya kisìkíjna Nainá nga k'oa̱s'ín tse nga'ñó tsjá‑la̱ xi̱ta̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús kiì‑ne i̱'nde jè. K'e̱ nga tífì, kijtseè jngoò xi̱ta̱ xi 'mì Mateo xi tíjnat'aà ími̱xa̱ ya̱ ñánda síkíchjítjì tsojmì, to̱n xi fì Roma; kitsò‑la̱: ―Nchrobátji̱ngui‑ná. K'e̱é tsasítje̱n Mateo, kiìtji̱ngui‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","K'e̱ nga tíjnat'aà ími̱xa̱ Jesús nga tíkjèn ya̱ ni'ya‑la̱ Mateo, kjìn xi̱ta̱ j'iì xi ti̱koa̱ tsojmì síkíchjítjì ko̱ xi̱ta̱ xi jé tjín‑la̱. Ti̱koa̱ tsibìtsa̱jnat'aà ími̱xa̱, tsakjèn‑ko̱ Jesús ko̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ta̱nga jñà xi̱ta̱ fariseo, k'e̱ nga kijtseè xi̱ta̱ koi, kiskònangui‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, kitsò‑la̱: ―¿Mé‑ne k'oa̱s'ín‑ne maestro‑nò nga xi̱ta̱ xi síkíchjítjì tsojmì ko̱ xi̱ta̱ jé kjèn‑ko̱‑ne? ");
INSERT INTO maaNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kiì'nchré Jesús, k'e̱é kitsò‑la̱: ―Jñà xi̱ta̱ xi mì ch'in tjín‑la̱, mì chji̱ne̱xkiì mochjeén‑la̱, jñà‑né xi̱ta̱ xi xk'én xi mochjeén‑la̱ chji̱ne̱xkiì. ");
INSERT INTO maaNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tanguió chíta'yà ìsa̱ kó tsòya‑ne Xo̱jo̱n‑la̱ Nainá xi tsò: “'A̱n mejèn‑na nga kàtas'e‑nò kjo̱hi̱ma̱takòn; kì ta̱ tsjaà cho̱ nìk'eèn kjo̱tjò xi 'a̱n 'biì‑ná.” Mìtsà koi xá j'i̱‑na 'a̱n nga j'i̱kjaàjñaà xi̱ta̱ kixi̱, jñà‑né xi̱ta̱ xi tjín‑la̱ jé nga kàtasíkájno jé‑la̱ nga mì ti̱ jé ko̱hótsji‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jè Juan xi kis'iìn bautizar xi̱ta̱, jñà xi̱ta̱ xi kota'yàt'aà‑la̱ j'iìkon Jesús ñánda tíjna koa̱ kiskònangui‑la̱, kitsò: ―Ngaje̱n ko̱ xi̱ta̱ fariseo kjit'aà na̱chrjein bitsa̱jnachjan‑je̱n. ¿Mé‑ne jñà xi̱ta̱ tsi̱ji mìkiì bìtsa̱jnachjan‑ne? ");
INSERT INTO maaNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús kitsò‑la̱: ―¿A baá bìtsa̱jna xi̱ta̱ k'e̱ nga s'eí tjín k'e̱ nga títsa̱jna osen xi kòbixan? Ta̱nga ki̱jchò na̱chrjein k'e̱ nga tjáxìn‑la̱ x'i̱n xi kòbixan, k'e̱‑né nga kítsa̱jnachjan xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Jngoò nikje i̱baà mìkiì ma si̱jto‑ne ko̱ nikje xi̱tse̱; nga jè nikje xi̱tse̱, kjeèn‑yó‑né koa̱ ko̱tejnda‑né jè nikje i̱baà. Ìsa̱ tse ko̱ma ñánda kixajndà kji. ");
INSERT INTO maaNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ti̱koa̱á mìkiì ma si̱nchá xán ixiì jè chrjoa̱ jchínga, jè xán ixiì ko̱tijnda‑né jè chrjoa̱ jchínga koa̱ xíxteèn jè xán. Ti̱koa̱á chi̱ja jè chrjoa̱. Jè xán ixiì, chrjoa̱ xi̱tse̱é si̱nchá. K'oa̱á s'ín ndaà si̱nchá ingajò. ");
INSERT INTO maaNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ti̱k'e̱é‑ne nga tíchja̱ Jesús, ijchò jngoò xi̱ta̱ sko̱‑la̱ jñà xi̱ta̱ judío, tsasìxkó'nchit'aà‑la̱, kitsò‑la̱: ―Ndí tsòti‑na̱, sa̱ kò jye k'en; ta̱nga tsà ji̱ k'oín ko̱ tsà kjòt'aà‑la̱ ndsei̱i, kíjnakon ìjngoò k'a‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tsasítje̱n Jesús, kiìko̱ jè xi̱ta̱ sko̱‑la̱ ko̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","K'e̱ nga nchifì, jngoò chjo̱ón ijchòtji̱ngui‑la̱; chjo̱ón jè, jyeé ko̱ tejò nó xk'én nga tíxíxteèn‑la̱ jní. Kiì kasìt'aà chrañà‑la̱ Jesús ya̱ i̱jto̱n íts'i̱n nga kitsobà'ñó i̱tjòn nikje‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","K'oa̱á s'ín tíhóko̱ ini̱ma̱‑la̱: “Tsà tà jè sìkoa̱a nikje‑la̱, ko̱ndaá‑na.” ");
INSERT INTO maaNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jè Jesús kisìkáfaya, kijtseè chjo̱ón jè, kitsò‑la̱: ―Ndí nea̱, tjiì‑la̱ nga'ñó yijo‑lè. Kòmandaà‑ne koií‑né nga mokjeiín‑lè i̱t'aà ts'a̱n. Ti̱jè‑ne hora kjòndaà‑ne chjo̱ón jè. ");
INSERT INTO maaNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","K'e̱ nga ijchò Jesús ya̱ ni'ya‑la̱ jè xi̱ta̱ sko̱‑la̱ xi̱ta̱ judío, kijtseè música xi nchisíkjane nga jye ki̱hijiìn mik'en koa̱ kijtseè nga fìjen fìkjá xi̱ta̱ nga 'ñó nchikjindáya. ");
INSERT INTO maaNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kitsò‑la̱: ―Tìtjo̱o ni'ya; jè tsòti mìtsà kòbiyaà, tà kjinafé‑né. Jñà xi̱ta̱, tà tsijnòkeè‑né k'e̱ nga o̱kitsò Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ta̱nga Jesús tsachrje ni'ya ngats'iì xi̱ta̱ xi títsa̱jna; k'e̱é jahas'en ni'ya, kiskoé tsja jè tsòti, koa̱ jè tsòti tsasítje̱n. ");
INSERT INTO maaNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nga kijndà i̱'nde jè, tsabísòn 'én i̱t'aà ts'e̱ kjoa̱ xi ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","K'e̱ nga itjo‑ne Jesús i̱'nde jè, jò xi̱ta̱ xi mìkiì tsejèn‑la̱ kiìtji̱ngui‑la̱; 'ñó kiìchja̱, kitsò‑la̱: ―¡Jcha̱hi̱ma̱takòn‑náje̱n, ngaji̱ xi ya̱ nchrobàt'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David nga ji̱ tijna ngajo‑la̱! ");
INSERT INTO maaNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","K'e̱ nga jahas'en ni'ya Jesús, jñà xi̱ta̱ xi mìkiì tsejèn‑la̱ ijchòkon. Jesús, kiskònangui‑la̱, kitsò‑la̱: ―¿A mokjeiín‑nò nga ko̱ma‑na sìndaà‑nò? K'e̱é kitsò jñà xi̱ta̱ xi mìkiì tsejèn‑la̱: ―Jon, Na̱'èn. Ko̱maá‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesús k'e̱é kisìko̱ jñà xko̱n, kitsò‑la̱: ―Jñò, koni s'ín mokjeiín‑nò, k'oa̱s'ín kàtandaà‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jñà xi̱ta̱ xi mìkiì tsejèn‑la̱, kitáx'a̱‑ne xko̱n koa̱ kjòndaà‑ne. Jesús 'ñó tsibínè‑la̱ nga kitsò‑la̱: ―Ndaà t'e̱en kinda̱ nga mì yá xi̱ta̱ xi skoe̱ kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ta̱nga jñà xi̱ta̱ koi, k'e̱ nga itjo‑ne ni'ya, ti̱k'e̱é tsibíts'ia̱ nga tsibéno̱jmí nga kijndà i̱'nde jè, kós'ín kis'iìn Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","K'e̱ nga jye nchifì‑ne jñà xi̱ta̱ xi mìkiì tsejèn‑la̱, j'iìko̱ jngoò‑la̱ Jesús xi̱ta̱ xi mìkiì ma chja̱ nga ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús k'e̱ nga jye tsachrjekàjiìn ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ jè xi̱ta̱ xi mìkiì ma chja̱, ti̱k'e̱é komà kiìchja̱‑ne. Ngats'iì xi̱ta̱ xi ya̱ títsa̱jna tà kjòxkón‑la̱. Kitsò: ―Kj'eè kiì 'yaá kjoa̱ xi k'oa̱s'ín ma i̱ i̱'nde Israel. ");
INSERT INTO maaNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ta̱nga jñà xi̱ta̱ fariseo kitsò: ―Jè sobà xi̱ta̱ sko̱‑la̱ xi̱ta̱ nei̱í tsjá‑la̱ nga'ñó nga ma‑la̱ ochrjekàjiìn ini̱ma̱ ch'o‑la̱ nei̱í xi tjín‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús tsajmeèjiìn ñánda na̱xa̱ndá iì ko̱ na̱xa̱ndá jtobá nga tsakóya 'én‑la̱ Nainá ya̱ ni'ya i̱ngo̱ sinagoga ts'e̱ na̱xa̱ndá koi. Kiìchja̱ya 'én ndaà‑la̱ Nainá koni s'ín otíxoma Nainá; ti̱koa̱ kisìndaà‑ne ngats'iì ch'in xi tjín‑la̱ xi̱ta̱ nga xki̱ xi ján ijòjno ijòt'aà yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","K'e̱ nga kijtseè Jesús nga kjìn ma xi̱ta̱, kjòhi̱ma̱keè nga 'ñó makájno‑la̱ ko̱ mì yá xi osìko̱ nga jye títsjohoya k'oa̱á ngaya‑la̱ koni orrè xi tsjìn‑la̱ paxtò xi ko'ndà. ");
INSERT INTO maaNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","K'e̱é kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Xi o̱kixi̱, 'ñó tse xá tjín xi i̱t'aà ts'e̱ 'Én‑la̱ Nainá koni s'ín ma k'e̱ nga kjìn tsojmì majchá ta̱nga jñà xi̱ta̱ chi̱'nda xi síxá, chiba ma‑ne; ");
INSERT INTO maaNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","tìtsi'ba‑là jè Nei‑la̱ xá, kàtasíkasén‑ìsa xi̱ta̱ chi̱'nda xi koi̱ìxkó tsojmì koi. ");
INSERT INTO maaNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nga ko̱ma i̱skan Jesús kiìchja̱‑la̱ xi̱ta̱‑la̱ xi tejò ma‑ne xi kota'yàt'aà‑la̱, kitsjaà‑la̱ kjo̱tíxoma nga ko̱ma ko̱chrjekàjiìn ini̱ma̱ ch'o‑la̱ nei̱í xi tjín‑la̱ xi̱ta̱ koa̱ ko̱ma‑la̱ si̱ìndaà‑nè ni̱ta̱ mé ch'in‑ne nga ijòjno ijòt'aà yijo‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jñà 'ín‑la̱ xi̱ta̱ xi tejò jaàjiìn Jesús nga tsibíxáya‑la̱: jè tíjna ítjòn, Simón xi ti̱koa̱ Pedro ki'mì, ko̱ Andrés xi 'ndse̱ ma Pedro; Jacobo ko̱ 'ndse̱ Juan xi i̱xti‑la̱ Zebedeo; ");
INSERT INTO maaNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, ko̱ Mateo jè xi kisìkíchjítjì tsojmì ts'e̱ Roma; Jacobo, ti‑la̱ Alfeo; Lebeo xi ti̱koa̱ Tadeo ki'mì; ");
INSERT INTO maaNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, xi̱ta̱ xi ya̱ fìt'aà‑la̱ xi̱ta̱ cananista; ko̱ Judas Iscariote jè xi kisìnga̱tsja kondra̱‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús kisìkasén nga tejò xi̱ta̱ xi kota'yàt'aà‑la̱ nga kisìka'bí 'én‑la̱ Nainá koa̱ kitsjaà‑la̱ kjo̱tíxoma, kitsò‑la̱: ―Mìkiì onguió ya̱ i̱'nde‑la̱ jñà xi mìtsà xi̱ta̱ judío; ti̱koa̱ mìkiì bitjaàs'en‑jñoò ya̱ na̱xa̱ndá‑la̱ xi̱ta̱ Samaria. ");
INSERT INTO maaNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ya̱á tanguíchòn jñà xi̱ta̱ na̱xa̱ndá Israel koni orrè xi kichijà. ");
INSERT INTO maaNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","K'e̱ nga onguió ti̱nókjoa̱ya koa̱ tixón: “Jye kjòchrañàt'aà‑nò na̱chrjein nga jcha̱a kó s'ín otíxoma jè xi ngajmiì nchrobá‑ne.” ");
INSERT INTO maaNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ti̱ndaà‑nò xi̱ta̱ xi xk'én; ti̱tsjeè xi tíbindojno chrjoa̱ yijo‑la̱; ti̱kjaáya‑là xi jye k'en; na̱chrjekàjñoò ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ xi̱ta̱. Tà kjo̱tjò kitjoé‑nò nga'ñó koi, ti̱koa̱á tà kjo̱tjò tjiì ngajo‑là jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ni̱mé to̱n ch'aà. ");
INSERT INTO maaNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kì na̱'ya ch'aà xi i̱t'aà ts'e̱ ndi̱yá. Mìkiì tsà jò na̱chro̱ ch'aà. Ti̱koa̱á mìkiì xo̱xté tsjayaà. Ti̱koa̱á kì yá garrote ch'aà. Nga̱ jè xi̱ta̱ xi síxá, mochjeén‑né nga k'oi̱‑la̱ tsojmì xi ski̱ne̱. ");
INSERT INTO maaNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’K'e̱ nga kijchoò na̱xa̱ndá iì, o xi na̱xa̱ndá jtobá ti̱nchátsjioò jngoò ni'ya xi ndaà xi̱ta̱ nei‑la̱, ya̱á titsa̱jnako̱o skanda k'e̱ nga onguí‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","K'e̱ nga ki̱tjás'e̱en ni'ya, ti̱ixat'aà jñà xi̱ta̱ nei‑la̱ ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tsà jñà xi̱ta̱ nei‑la̱ ni'ya skoétjò‑nò, ti̱chikon‑t'ioòn nga s'e̱‑la̱ kjoa̱'nchán, ta̱nga tsà mìkiì skoétjò‑nò, tà sa̱á jñò s'e̱‑nò kjoa̱'nchán nga si̱ìchikon‑t'in‑nò Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tsà mìkiì skoétjò‑nò, ko̱ tsà majìn‑la̱ kji̱'nchré 'én‑nò, tìtjo̱o ni'ya jè, o na̱xa̱ndá jè, koa̱ titsajneè chijo‑la̱ ndso̱koò. ");
INSERT INTO maaNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","O̱kixi̱í xi xan‑nò, na̱xa̱ndá jè, ìsa̱á tse kjo̱'in s'e̱‑la̱ jè na̱chrjein k'e̱ nga si̱ndaàjiìn‑la̱ xi̱ta̱, mì k'oa̱á‑ne koni jñà xi̱ta̱ ts'e̱ na̱xa̱ndá Sodoma ko̱ Gomorra. ");
INSERT INTO maaNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Ti̱ná'ya, 'a̱n, k'oa̱á s'ín sìkasén‑nò koni tsà orrè ya̱ i̱jiìn‑la̱ cho̱ tse̱jén. Jñò, titsa̱jnandaà ni̱ta̱ mé kjoa̱‑ne koni tsà ye̱ xi 'ñó maña̱ ti̱koa̱ indaàkjoa̱ kàtama koni tsà ni̱se paloma. ");
INSERT INTO maaNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ndaà ti̱kinda̱a yijo‑nò. Jñà xi̱ta̱ koi, ján ski̱nìt'aà‑nò nguixko̱n xi̱ta̱xá koa̱ ska̱àn‑ko̱o‑nò ya̱ ni'ya i̱ngo̱ sinagoga. ");
INSERT INTO maaNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Skanda ján kji̱ko̱‑nò nguixko̱n xi̱ta̱xá gobernador ko̱ xi̱ta̱xá ítjòn, tà koií kjoa̱‑la̱ i̱t'aà ts'a̱n. K'oa̱á s'ín ko̱ma ki̱nókjoa̱‑là 'én xi ts'a̱n jñà xi̱ta̱xá ko̱ jñà xi mìtsà xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","K'e̱ nga ski̱nìt'aà‑nò ñánda títsa̱jna xi̱ta̱xá, kì makájno‑nò kós'ín ki̱nókjoa̱a, o kós'ín kixón. Nga ti̱k'e̱é‑ne, Nainá tsjá‑nò 'én xi ki̱nókjoa̱a. ");
INSERT INTO maaNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nga mìtsà jñò xi ki̱nókjoa̱a; jè Ini̱ma̱ Tsjeè‑la̱ Nainá tsjá‑nò kjo̱hítsjeèn nga ma ki̱nókjoa̱jiìn‑là jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ti̱jè‑ne 'ndse̱ si̱ìnga̱tsja 'ndse̱ xi̱ta̱ nga si̱ìk'en. Jè na̱'èn‑la̱ si̱ìnga̱tsja ki'ndí‑la̱ nga si̱ìk'en xi̱ta̱. Jñà i̱xti‑la̱ si̱ìnga̱tsja na̱'èn‑la̱ nga ki̱yá. ");
INSERT INTO maaNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ngats'iì xi̱ta̱ i̱sò'nde ko̱jtikeè‑nò xi kjoa̱ ts'a̱n; ta̱nga jè xi̱ta̱ xi kixi̱ kíjna skanda kjoe̱het'aà‑ne, jè‑né xi ki̱tjokàjiìn kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","K'e̱ nga kji̱tji̱ngui kondra̱‑nò xi̱ta̱ xi jngoò na̱xa̱ndá, ti̱yó, xìn na̱xa̱ndá tanguió. O̱kixi̱í xi xan‑nò, 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, ìsa̱á ítjòn kjoia̱a nga ti̱kj'eè onguió yije kóho̱kji na̱xa̱ndá Israel. ");
INSERT INTO maaNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Jngoò xi̱ta̱ xi kota'yà mìtsà ìsa̱ tíjna ítjòn koni maestro‑la̱; ti̱koa̱á jngoò xi̱ta̱ xi chi̱'nda tíjna mìtsà ìsa̱ tíjna ítjòn‑la̱ nei‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jè xi̱ta̱ xi kota'yà ko̱jngoó ikon tsà k'oa̱s'ín ki̱jchò koni jè maestro‑la̱ ko̱ jè xi chi̱'nda tíjna tsà tà k'oa̱s'ín kíjna koni jè nei‑la̱. Jè xi na̱'èn tíjna, xi̱ta̱ nei̱í tsò‑la̱; jñà xi i̱xti‑la̱, ìsa̱á tsato ch'o ki̱tso̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Kì xi̱ta̱ tsakjoòn‑là. Nga nì mé tjín xi tíjtsa'ma xi mìkiì ko̱tsejèn; ngats'iì xi tjí'ma, jcha̱á‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jè kjoa̱ xi k'oa̱ xan‑nò k'e̱ nga jñò choòn, k'oa̱á tixón k'e̱ nga na̱chrjein; koa̱ jè xi kjoa̱'ma xan‑nò, jñò ti̱nókjoa̱ya kóho̱kji i̱sò'nga ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kì tsakjoòn‑là jè xi ma‑la̱ sík'en yijo‑ná, ta̱nga ini̱ma̱‑ná mìkiì ko̱ma‑la̱ si̱ìk'en. Jè xi ti̱skón‑là xi ma‑la̱ sík'en yijo‑ná ko̱ ini̱ma̱‑ná nga kinìjiìn‑ná ni'ín ts'e̱ kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Maá satíjna jò ndí ni̱se na̱s'ín tà jngoò ma to̱n‑ná. Ta̱nga ni̱jngoò ni̱se ki̱yá tsà mìkiì tsjá'nde Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jñò, skanda tsja̱skoò tíxke̱ya yije‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Koií kjoa̱‑la̱, kì tsakjoòn‑jèn. Ìsa̱á tse chjí‑nò mì k'oa̱á‑ne na̱s'ín kjìn ma ndí ni̱se. ");
INSERT INTO maaNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Ni̱ta̱ yá‑ne xi tsjá 'én nga nguixko̱n xi̱ta̱ nga 'a̱n fìt'aà‑na, 'a̱n k'oa̱á ti̱ xán nga nguixko̱n Na̱'èn‑na̱ xi tíjna ngajmiì nga xi̱ta̱ ts'a̱n‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ta̱nga jè xi kjójna'mat'in‑na nga nguixko̱n xi̱ta̱, 'a̱n k'oa̱á ti̱s'ín kójna'mat'ian i̱t'aà ts'e̱ nga nguixko̱n Na̱'èn‑na̱ xi tíjna ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Kì k'oa̱á s'ín nìkítsjeèn nga kjoa̱'nchán j'iìkoa̱a i̱sò'nde. Mì kjoa̱'nchán j'iìkoa̱a, ta̱ sa̱á kjoa̱jchán j'iìkoa̱a. ");
INSERT INTO maaNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Koií xá j'i̱‑na nga jñà xi̱ta̱, ti̱jè‑ne na̱'èn‑la̱ ko̱ma‑ne kondra̱‑la̱; jè tsòti‑la̱, ti̱jè ko̱ma‑ne kondra̱‑la̱ nea̱‑la̱; ko̱ jè kja'nda‑la̱, ti̱jè na̱chíya‑la̱ ko̱ma‑ne kondra̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nga jngoò ìjngoò xi̱ta̱, ti̱jñà‑ne xi̱ta̱ ni'ya‑la̱ ko̱ma kondra̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Jè xi ìsa̱ tjòkeè na̱'èn‑la̱ ko̱ nea̱‑la̱ ko̱ 'a̱n mìkiì matsjakeè‑na, mìkiì ok'ìn‑la̱ nga xi̱ta̱‑na̱ xán‑la̱; ko̱ jè xi ìsa̱ tjòkeè ti‑la̱, o jè tsòti‑la̱, ko̱ 'a̱n mìkiì matsjakeè‑na, mìkiì ok'ìn‑la̱ nga xi̱ta̱‑na̱ xán‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jè xi kjo̱'in tsakjón‑la̱ nga majìn‑la̱ ojen krò‑la̱ nga 'a̱n kji̱nchrobà tji̱ngui‑na mìkiì ok'ìn‑la̱ nga xi̱ta̱ ts'a̱n xán‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jè xi̱ta̱ xi ndaà ótsji kós'ín ma si̱ìkinda̱ yijo‑la̱ nga mì mé kjo̱'in sa̱kò‑la̱, tà sa̱á si̱ìchija‑né ko̱ kjo̱'in kíjnajiìn; ta̱nga jè xi tíjnandaà nga tsjá yijo‑la̱ nga ki̱yá xi kjoa̱ ts'a̱n, sa̱kò‑la̱ kjoa̱binachon nga i̱t'aà ts'a̱n ndaà kíjna. ");
INSERT INTO maaNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Jè xi̱ta̱ xi skoétjò‑nò, 'a̱n kjoétjò‑na; ko̱ jè xi skoétjò‑na, jè kjoétjò xi kisìkasén‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jè xi̱ta̱ xi kjoétjò jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá, koií kjoa̱‑la̱ nga 'én‑la̱ Nainá chja̱, k'oa̱á ti̱s'ín ko̱chikon‑t'in koni jè xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá. Ko̱ jè xi̱ta̱ xi skoétjò jngoò xi̱ta̱ kixi̱, koií kjoa̱‑la̱ nga ndaà s'ín, ti̱koa̱á tà ngásòn ko̱chikon‑t'in koni jè xi̱ta̱ kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ni̱ta̱ yá‑ne xi tsjá jngoò chi̱tsín‑la̱ nandá 'nchán jngoò ndí xi̱ta̱ i̱ma̱‑na̱ koií kjoa̱‑la̱ nga 'a̱n kota'yàt'aà‑na, o̱kixi̱‑né ko̱chikon‑t'in‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","K'e̱ nga jye kitsjaà‑la̱ o̱kixi̱ kós'ín si̱ìxá xi̱ta̱‑la̱ xi tejò ma‑ne xi kota'yàt'aà‑la̱ Jesús, kiìkakóya ko̱ kisìka'bí 'én‑la̱ Nainá ngats'iì na̱xa̱ndá xi tjín ya̱ i̱'nde jè. ");
INSERT INTO maaNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan, nga nda̱yá tíjna'ya, kiì'nchré kjoa̱ xi tís'ín Cristo xi̱ta̱ xi xó kisìkasén‑ne Nainá. Kisìkasén i'nga xi̱ta̱ xi kota'yàt'aà‑la̱ ");
INSERT INTO maaNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nga kiì kjònangui‑la̱. Kitsò‑la̱: ―¿A ji̱‑né xi Cristo xi tjínè‑lè nga kjoi̱i a xi kj'ei̱í chíña‑la̱je̱n? ");
INSERT INTO maaNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús kitsò‑la̱: ―Tanguió, tèno̱jmí‑là Juan jñà kjoa̱ xi titsa̱'yaà ko̱ xi titsa̱na'yà. ");
INSERT INTO maaNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jñà xi̱ta̱ xi mìkiì tsejèn‑la̱, jyeé tsejèn‑la̱; jñà xi tsá'yá kjoàn, jyeé ma fì‑ne; jñà xi tíbindojno chrjoa̱ yijo‑la̱, tímatsjeèjno‑ne yijo‑la̱; jñà xi̱ta̱ xi jtayaà, jyeé 'nchré‑ne; ko̱ xi̱ta̱ xi jye k'en, nchifaáyaá‑la̱; koa̱ jñà xi̱ta̱ i̱ma̱, jyeé tís'eno̱jmí‑la̱ 'én ndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mé tà ndaà‑la̱ jè xi̱ta̱ xi nguì jngoò k'a ndaà mokjeiín‑la̱ i̱t'aà ts'a̱n nga nì mé xi o̱si̱jna‑ikòn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","K'e̱ nga jye kiì‑ne xi̱ta̱ xi kota'yàt'aà‑la̱ Juan, tsibíts'ia̱ Jesús nga tsohóko̱ xi̱ta̱ xi i̱t'aà ts'e̱ Juan, kitsò‑la̱: ―¿Mé xi tsanguì chìtsejèn‑là ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn? ¿A jè tsanguì chìtsejèn‑là jngoò xi̱ta̱ xi yá ína̱xo̱ kji nga tsjìn‑la̱ nga'ñó nga ma síjtìya‑la̱ tjo̱? ");
INSERT INTO maaNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tsà majìn, ¿mé‑nè xi tsanguì chìtsejèn‑là? ¿A jngoò xi̱ta̱ xi 'ñó ndaà kji nikje‑la̱? Jñà xi̱ta̱ xi 'ñó ndaà kjoàn nikje‑la̱, ya̱á títsa̱jna ya̱ ni'ya‑la̱ xi̱ta̱xá ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Mé xá xi tsanguì‑nò? ¿A jè tsanguì chìtsejèn‑là jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá? O̱kixi̱‑né, k'oa̱á xan‑nò, Juan, ìsa̱á tíjna ítjòn mì k'oa̱à‑ne koni jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","I̱t'aà ts'e̱ Juan, ya̱á tíchja̱ Xo̱jo̱n‑la̱ Nainá nga tsò: 'A̱án sìkasén ítjòn‑lè xi̱ta̱‑na̱ xi kji̱ko̱ 'én, jè xi koi̱ìndaàya ítjòn‑lè ndi̱yá‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","O̱kixi̱‑né, ngats'iì xi̱ta̱ xi tjín i̱ i̱sò'nde, ni̱ sa̱á jngoò xi̱ta̱ bitjokàjiìn xi mangásòn koni jè Juan xi kis'iìn bautizar xi̱ta̱; ta̱nga ya̱ i̱jiìn na̱xa̱ndá ñánda otíxoma jè xi ngajmiì nchrobá‑ne, jè xi̱ta̱ xi fehet'aà‑ne, ìsa̱á jeya tíjna mì k'oa̱á‑ne koni Juan. ");
INSERT INTO maaNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Tje̱n‑ne nga j'i̱ Juan xi kis'iìn bautizar xi̱ta̱, jè kjo̱tíxoma‑la̱ ngajmiì, tse kjoa̱siì tísakó‑la̱ skanda na̱chrjein i̱'ndei̱; jñà xi̱ta̱ ts'e̱n mejèn‑la̱ nga kàtachija kjo̱tíxoma. ");
INSERT INTO maaNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ngats'iì xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá ko̱ xo̱jo̱n ts'e̱ kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, tà 'én j'iìko̱ skanda k'e̱ nga j'iì Juan xi kis'iìn bautizar xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tsà mokjeiín‑nò koni tsò jè kjo̱tíxoma ko̱ xi̱ta̱ xi kiìchja̱ya ti̱koa̱á ko̱kjeiín‑nò nga jè Juan, jè‑né xi̱ta̱ xi 'mì Elías xi tjínè‑la̱ nga kjoi̱í. ");
INSERT INTO maaNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ndaà ti̱ná'yaà koni xan‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Yá xi siìngásòn‑koa̱a jñà xi̱ta̱ xi tjín na̱chrjein i̱'ndei̱? Jñà ko̱ngásòn‑kjoò jñà i̱xti xi bìtsa̱jna ndi̱tsi̱n nga síská, chja̱‑la̱ xíkjín, tsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Kànìkjaneé‑nòje̱n xo̱bí ta̱nga jñò, mìkiì kàchà; kàjndaá‑nòje̱n sò xi ba tsò ta̱nga jñò, mìkiì kàchìhindáyaà.” ");
INSERT INTO maaNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","K'e̱ nga j'iì Juan, mìtsà 'ñó tsakjèn, ni̱ mì xán kits'iì, koa̱ jñò bixón‑nò: “Ini̱ma̱ ch'o‑la̱ nei̱í tjín‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","I̱kjoàn j'ia̱a xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱; ma‑na kje̱en, ti̱koa̱ ma‑na 'bia̱a; jñà xi̱ta̱ tsò‑né: xi̱ta̱ chrjá'a‑né, xi̱ta̱ ch'i̱‑né, amigo‑la̱‑né jñà xi̱ta̱‑la̱ xi̱ta̱xá Roma xi síkíchjítjì tsojmì ko̱ jñà xi xi̱ta̱ jé. Ta̱nga jè kjoa̱chji̱ne̱‑la̱ Nainá, 'yaá‑la̱ nga kixi̱ tjín k'e̱ nga jye bitasòn. ");
INSERT INTO maaNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesús k'e̱é tsibíts'ia̱ nga tsohótiko̱ ngats'iì xi̱ta̱ na̱xa̱ndá ñánda nga kjìn kjo̱xkón‑ndaà kis'iìn, koií kjoa̱‑la̱ nga jñà xi̱ta̱ xi ya̱ i̱'nde‑la̱ mìkiì kisìkájno jé‑la̱ nga tákó jé nchihótsji. Kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡I̱ma̱ xó‑nò jñò, xi̱ta̱ na̱xa̱ndá Corazín! ¡I̱ma̱ xó‑nò jñò, xi̱ta̱ na̱xa̱ndá Betsaida! Tsà ya̱‑làne na̱xa̱ndá Tiro ko̱ Sidón nga k'oa̱s'ín kis'iaàn kjo̱xkón xi ndaà tjín xi komà ya̱ i̱jiìn na̱xa̱ndá tsa̱jòn, tsà jñà xi̱ta̱ Tiro ko̱ Sidón kijtseè, jyeé‑la nikje naxá íkjá ko̱ chijo ni'ín kisìkaàjno sko̱ koni seña nga jye kisìkájno kjoa̱ ts'e̱ jé‑la̱, mì ti̱ jé ótsji‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ta̱nga k'oa̱á xán‑nò, k'e̱ nga jè na̱chrjein nga si̱ndaàjiìn, ìsa̱á tse kjo̱'in s'e̱‑nò mì k'oa̱á‑ne koni jñà xi̱ta̱ na̱xa̱ndá Tiro ko̱ Sidón. ");
INSERT INTO maaNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Koa̱ jñò xi xi̱ta̱ na̱xa̱ndá Capernaum tsa̱jòn, ¿a k'oa̱á s'ín mokjeiín‑nò nga jcha̱xkón‑nò ján ngajmiì? Majìn, ya̱á ki̱tsa̱jnajñoò i̱'nde ñánda tjín kjo̱'in. Tsà ya̱á‑làne na̱xa̱ndá Sodoma k'oa̱s'ín komà kjo̱xkón xi komà tsa̱jòn, jè na̱xa̱ndá Sodoma tákó kijnaá‑la skanda na̱chrjein i̱'ndei̱. ");
INSERT INTO maaNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","K'oa̱á xán‑nò, k'e̱ nga ki̱jchò na̱chrjein nga si̱ndaàjiìn, ìsa̱á tse kjo̱'in s'e̱‑nò mì k'oa̱á‑ne koni jñà xi̱ta̱ na̱xa̱ndá Sodoma. ");
INSERT INTO maaNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jñà na̱chrjein koi Jesús kitsò: ―Na̱'èn xi tsi̱ji ngajmiì ko̱ tsi̱ji i̱sò'nde, jeya síkíjna‑lè nga jñà kjoa̱ koi tsibì'ma‑la̱ jñà xi̱ta̱ xi tjín‑la̱ kjoa̱chji̱ne̱ ko̱ xi 'ñó tjín‑la̱ kjo̱hítsjeèn nga jñà tsakoò‑la̱ xi ta̱xki̱ ndí xi̱ta̱ i̱ma̱ kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jon, Na̱'èn, nga k'oa̱á s'ín kjòmejèn‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Ngats'iì kjoa̱ ts'e̱ kjo̱tíxoma, 'a̱án kisìnga̱tsja‑na Na̱'èn‑na̱. Mìtsà yá xi beèxkon yá‑né xi Ki'ndí‑la̱ ma, ta̱jngoò jè xi Na̱'èn ma; ti̱koa̱á mìtsà yá xi beèxkon yá‑né xi Na̱'èn ma, ta̱jngoò jè xi Ki'ndí‑la̱ beèxkon; ko̱ jè Ki'ndí‑la̱ ko̱kò‑la̱ jñà xi̱ta̱ xi jè mejèn‑la̱ nga skoe̱xkon, yá‑né xi Na̱'èn ma. ");
INSERT INTO maaNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nchrobáchón‑ná ngats'ioò xi jye ijta‑nò nga nìxá ko̱ nga kich'àjen ch'á‑nò, 'a̱án síkjáya‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jch'a̱jen‑ko̱‑ná jè yá i̱bo̱ xi 'a̱n 'yajen mé‑ne nga ko̱ma‑nò ko̱s'ín s'e̱en koni s'ín s'iaàn 'a̱n. K'oa̱s'ín t'e̱en koni 'a̱n nga tjín‑na kjoa̱tsejta ko̱ indaá kjoa̱ tjín ini̱ma̱‑na̱. K'oa̱s'ín sakó‑nò kjoa̱ nìkjáya ts'e̱ ini̱ma̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Jè yá i̱bo̱ ko̱ ch'á xi 'a̱n sik'àje̱n‑nò, jna̱‑né, mìtsà 'ñó i'í. ");
INSERT INTO maaNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jè na̱chrjein nìkjáya, Jesús ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱ ya̱ ja ya̱ ñánda títje̱ trigo. Koa̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kjòhojò‑la̱. K'e̱é tsate natín‑la̱ trigo, i̱kjoàn kiskine. ");
INSERT INTO maaNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jñà xi̱ta̱ fariseo k'e̱ nga kijtseè, kitsò‑la̱ Jesús: ―Chítsején‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑lè, jè kjoa̱ xi nchis'ín; mìkiì tjí'nde nga k'oa̱s'ín ko̱ma jè na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús kitsò‑la̱: ―¿Jñò, a mìtsà jye tíjiìn‑nò koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá koni kis'iìn xi̱ta̱xá ítjòn xi ki'mì David ko̱ jñà xi̱ta̱‑la̱ xi kjihijtako̱ k'e̱ nga kjòhojò‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jahas'en ni'ya‑la̱ Nainá koa̱ tsakjèn i̱nchra̱jín tsjeè‑la̱ Nainá xi mìkiì tjí'nde‑la̱ nga jè David ko̱kje̱n ko̱ xi̱ta̱ xi kjihijtako̱; ta jñà no̱'miì tjí'nde‑la̱ nga ko̱kje̱n. ");
INSERT INTO maaNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿A ti̱koa̱á mìtsà jye tíjiìn‑nò koni tsò kjo̱tíxoma xi kiskiì Moisés? Nga jñà no̱'miì, ya̱ i̱ya i̱ngo̱ ítjòn, síxá‑né na̱s'ín jè na̱chrjein nìkjáya, ko̱ na̱s'ín síxá mìtsà jé nchihótsji. ");
INSERT INTO maaNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","'A̱n, k'oa̱á xan‑nò, jngoò tíjna i̱jndé xi ìsa̱ jeya tíjna mì k'oa̱á‑ne koni jè i̱ngo̱ ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ngats'ioò jñò mìkiì machi̱ya‑nò kó tsòya‑ne Xo̱jo̱n‑la̱ Nainá nga tsò: “'A̱n, mejèn‑na nga kàtas'e‑nò kjo̱hi̱ma̱takòn, kì ta̱ tsjaà cho̱ nìk'eèn kjo̱tjò xi 'a̱n 'biì‑ná.” Tsà ko̱chi̱ya‑nò, mì‑la kiì kjo̱'in k'oi̱‑là xi̱ta̱ xi mìtsà jé tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","K'oa̱á s'ín tjín, 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, 'a̱án otiìxoma‑la̱ na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","I̱kjoàn kiì‑ne Jesús ya̱ i̱'nde jè; jahas'en jngoò ni'ya i̱ngo̱ sinagoga. ");
INSERT INTO maaNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ya̱ tíjna jngoò xi̱ta̱ xi kixìt'aà jngoò tsja. Jñà xi̱ta̱ xi ya̱ títsa̱jna kiskònangui‑la̱ Jesús nga mejèn‑la̱ ko̱hòngui, kitsò‑la̱: ―¿A tjí'nde‑né nga kjo̱ndaà‑ne xi̱ta̱ k'e̱ nga jè na̱chrjein nìkjáya? ");
INSERT INTO maaNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús kitsò‑la̱: ―Jñò, tsà tíjna jngoò‑nò orrè ko̱ tsà ya̱ ska̱ya nga̱jo̱, ¿a mìtsà konguínachrjeè na̱s'ín na̱chrjein nìkjáya? ");
INSERT INTO maaNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Jyeé 'ya, ìsa̱á 'ñó chjí‑la̱ jngoò xi̱ta̱ mì k'oa̱á‑ne koni jngoò orrè. Koií kjoa̱‑la̱ nga tjí'nde‑né nga ko̱si̱koa̱á xi̱ta̱ na̱s'ín jè na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesús kitsò‑la̱ jè xi̱ta̱ xi kixìt'aà jngoò tsja: ―Tjeèndojoì ndsei̱i. Xi̱ta̱ jè, tsijmeé tsja, ni̱to̱ón kjòndaà‑ne; k'oa̱á ti̱ kji komà‑ne koni kji xi ìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jñà xi̱ta̱ fariseo, k'e̱ nga itjo‑ne i̱ngo̱, i̱kjoàn tsajoóya‑ne nga mejèn‑la̱ si̱ìk'en Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús, k'e̱ nga kijtseè nga jñà xi̱ta̱ fariseo mejèn‑la̱ si̱ìk'en, itjo ni'ya, kiì. Kjìn xi̱ta̱ kiìtji̱ngui‑la̱. Jesús kisìndaà‑ne ngats'iì xi̱ta̱ xi xk'én. ");
INSERT INTO maaNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kitsjaà‑la̱ o̱kixi̱ jñà xi̱ta̱ nga mìkiì ke̱èno̱jmít'in yá‑né jè. ");
INSERT INTO maaNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","K'oa̱á s'ín komà mé‑ne nga tsitasòn‑ne 'én xi kiìchja̱ Isaías, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, nga kitsò: ");
INSERT INTO maaNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","I̱ tíjna jè chi̱'nda‑na̱ jè xi 'a̱n jaàjñaà, xi 'ñó matsjake̱, tjín‑la̱ kjo̱tsja ini̱ma̱‑na̱ xi i̱t'aà ts'e̱. 'A̱án tsjaà‑la̱ Ini̱ma̱ Tsjeè‑na̱ nga jè ki̱chja̱jiìn‑la̱ ngats'iì xi̱ta̱ i̱sò'nde xi kjoa̱kixi̱ mé‑ne nga ko̱ma si̱ndaàjiìn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mìtsà xi̱ta̱ ska̱àn‑ko̱, ko̱ nì mé 'én xi 'ñó ki̱chja̱, ko̱ mì kì ki̱ná'ya‑la̱ ya̱ i̱ya ndi̱yá 'én xi ki̱chja̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mìkiì skít'o̱ jngoò yá ína̱xo̱ xi jye mejèn tít'ò, ti̱koa̱á mìkiì si̱ìkits'o jngoò ni'ín xi ta ni̱'ndi̱í tíbitjo sa̱‑la̱. K'oa̱s'ín s'i̱in skanda k'e̱ nga koi̱ìndaàjiìn xi kjoa̱kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jñà xi̱ta̱ na̱xa̱ndá xi tjín i̱sò'nde xi mìtsà xi̱ta̱ judío, ko̱kjeiín‑la̱ nga skóña‑la̱ kjo̱ndaà xi tsjá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","J'iìko̱ jngoò‑la̱ xi̱ta̱ Jesús xi mìkiì tsejèn‑la̱, ko̱ xi mìkiì ma chja̱ nga ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱. Kisìndaà‑ne Jesús nga komà kiìchja̱‑ne koa̱ kjòtsejèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ngats'iì xi̱ta̱, tà kjòxkón‑la̱. K'e̱é kitsò: ―¿A jè jèe̱ xi ya̱ nchrobát'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David nga jè kíjna ngajo‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","K'e̱ nga kiì'nchré jñà xi̱ta̱ fariseo kitsò: ―Xi̱ta̱ jè, ma‑la̱ ochrjekàjiìn ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ xi̱ta̱, k'oi̱í‑né nga jè síkjeén nga'ñó‑la̱ Beelzebú xi sko̱‑la̱ xi̱ta̱ nei̱í. ");
INSERT INTO maaNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús kijtseèya‑la̱ koni s'ín nchihóko̱ ini̱ma̱‑la̱, kitsò‑la̱: ―Ngats'iì na̱xa̱ndá xi jòya tjín nga kondra̱ títsa̱jna‑la̱ xíkjín, ti yijo‑lá tísíkixòña‑ne; koa̱ tsà jngoò na̱xa̱ndá ko̱ tsà jngoò ni'ya xi̱ta̱ si̱ìjòya xíkjín, mìkiì ko̱ma ndaà kítsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tsà jè xi̱ta̱ nei̱í ti̱jè tíhochrjejiìn‑ne yijo‑la̱ nei̱í, jòya tís'ín xi ti̱jè‑ne yijo‑la̱. ¿Kós'ín ko̱ma s'e̱‑la̱ nga'ñó nga ko̱tìxoma? ");
INSERT INTO maaNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Jñò bixón‑nò nga 'a̱n sìkjeén nga'ñó‑la̱ xi sko̱‑la̱ xi̱ta̱ nei̱í k'e̱ nga ochrjekàjñaà ini̱ma̱ ch'o‑la̱ nei̱í. Tsà k'oa̱á s'ín tjín kjoa̱, jñà xi̱ta̱ tsa̱jòn, ¿yá xi tsjá‑la̱ nga'ñó k'e̱ nga ochrjekàjiìn nei̱í? Koií kjoa̱‑la̱, ti̱jñà‑ne xi̱ta̱‑nò ke̱èno̱jmí nga mìtsà kixi̱ kjoa̱ nga jè sko̱‑la̱ nei̱í sìkjeén. ");
INSERT INTO maaNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ta̱nga 'a̱n, k'e̱ nga ochrjekàjñaà ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ xi̱ta̱, jè Ini̱ma̱ Tsjeè‑la̱ Nainá tsjá‑na nga'ñó. Jè kjoa̱ koi tsòyaá‑ne nga Nainá, jyeé i̱ tíhotíxoma i̱ i̱t'aà nangui. ");
INSERT INTO maaNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Kó s'ín ko̱ma kjoa̱has'en ni'ya‑la̱ nga si̱ìchijé‑la̱ jngoò xi̱ta̱ nei‑la̱ ni'ya xi tjín‑la̱ nga'ñó tsà mìtsà ítjòn koi̱ìt'aà'ñó? K'e̱é ko̱ma si̱ìchijé‑la̱ k'e̱ nga jye kàsìt'aà'ñó. ");
INSERT INTO maaNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Ni̱to̱n yá‑ne xi mì 'a̱n fìt'aà‑na, jè‑né kondra̱‑na̱; koa̱ ni̱to̱n yá‑ne xi mìkiì síchját'aà‑na nga bíxkóyako̱‑na xi̱ta̱ xi ts'a̱n ko̱ma, jè tísítsjohoba xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’K'oa̱á xan‑nò, Nainá si̱ìjchàat'aà‑la̱ jñà xi̱ta̱ ni̱ta̱ mé jé xi ko̱hótsji, ni̱ta̱ mé 'én xi ch'o tsò ki̱chja̱. Ta̱nga jè xi Ini̱ma̱ Tsjeè‑la̱ Nainá ki̱chja̱jno‑la̱ mìkiì jcha̱t'aà‑la̱ jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ni̱to̱n yá‑ne xi ki̱chja̱jno‑na 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, jcha̱t'aà‑la̱ jé‑la̱; ta̱nga jè xi ki̱chja̱jno‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá, mìkiì jcha̱t'aà‑la̱ jé‑la̱ ni̱ jè na̱chrjein i̱'ndei̱, ko̱ ni̱ jè na̱chrjein xi i̱skan kjoi̱í. ");
INSERT INTO maaNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Tsà jngoò yá xi ndaà kji, ndaà toò xi ojà‑la̱. Ko̱ tsà jngoò yá xi mìkiì ndaà kji, mìkiì ndaà toò xi ojà‑la̱. Jngoò yá, jè toò‑la̱ yaxkon‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Jñò, xi̱ta̱ tje̱‑la̱ ye̱‑nò! ¿Kós'ín ma ki̱nókjoa̱a 'én xi ndaà tsò nga ch'o tsò ini̱ma̱‑nò? Nga k'oa̱á tsò 'én xi chja̱ jñà xi̱ta̱ koni tsò kjo̱hítsjeèn xi tíjiìn ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jngoò xi̱ta̱ xi 'én ndaà chja̱, koií‑né nga kjo̱ndaà tíjiìn ini̱ma̱‑la̱; koa̱ jngoò xi̱ta̱ xi 'én ts'e̱n chja̱, koií‑né nga kjoa̱ts'e̱n tíjiìn ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","K'oa̱á xán‑nò k'e̱ nga ki̱jchò na̱chrjein nga si̱ndaàjiìn, k'oa̱á s'ín tsjá kinda̱ ngats'iì xi̱ta̱ ni̱ta̱ mé 'én xi ta̱xki̱ chja̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Xi i̱t'aà ts'e̱ 'én‑nò, k'oa̱á s'ín si̱ndaàjiìn‑nò nga jcha̱‑la̱ tsà xi̱ta̱ ndaà‑nò, o tsà jé tjín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jñà xi̱ta̱ fariseo ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés kitsò‑la̱ Jesús: ―Maestro, mejèn‑naje̱n nga jcha̱ jngoò‑je̱n seña xi ji̱ 'nì. ");
INSERT INTO maaNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús kitsò‑la̱: ―Jñà xi̱ta̱ ts'e̱n ko̱ xi̱ta̱ xi mìkiì 'nchréñijon‑la̱ Nainá, síjé jngoò seña xi jeya tjín; ta̱nga ni̱mé seña skoe̱; ta jè skoe̱ ts'e̱ Jonás, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Koni jè Jonás nga jàn na̱chrjein ko̱ jàn ni̱tje̱n tsibìjnaya i̱ndso̱'ba̱ jngoò ti̱n je, k'oa̱á ti̱s'ín 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, jàn na̱chrjein ko̱ jàn ni̱tje̱n kójna̱ i̱jñaà nangui. ");
INSERT INTO maaNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jñà xi̱ta̱ na̱xa̱ndá Nínive ko̱sítje̱n‑né jè na̱chrjein k'e̱ nga koi̱ìndaàjiìn Nainá; jñà tsját'in 'én jñà xi̱ta̱ xi tjín na̱chrjein i̱'ndei̱, koií kjoa̱‑la̱ nga kisìkájno jé‑la̱ nga mì ti̱ jé tsohótsji‑ne k'e̱ nga kiìchja̱ya 'én‑la̱ Nainá Jonás; ta̱nga na̱chrjein i̱'ndei̱, 'a̱n xi tìchjàko̱‑nò, ìsa̱á 'ñó jeya tìjna̱a mì k'oa̱á‑ne koni Jonás ta̱nga jñò, mìkiì mokjeiín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ti̱koa̱á jè chjo̱ón ítjòn xi ya̱ otíxoma nangui sur, ko̱sítje̱n‑né jè na̱chrjein k'e̱ nga koi̱ìndaàjiìn Nainá; jè tsját'in 'én jñà xi̱ta̱ xi tjín na̱chrjein i̱'ndei̱, koií kjoa̱‑la̱ nga kjiìn nangui j'iì‑ne nga j'iì 'nchré‑la̱ kjoa̱chji̱ne̱‑la̱ Salomón; ta̱nga na̱chrjein i̱'ndei̱, 'a̱n xi tìchjàko̱‑nò, ìsa̱á 'ñó jeya tìjna̱a mì k'oa̱á‑ne koni Salomón ta̱nga jñò, mìkiì na'yà‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’K'e̱ nga jngoò ini̱ma̱ ch'o‑la̱ nei̱í bitjokàjiìn ini̱ma̱‑la̱ jngoò xi̱ta̱, ya̱á ojmeè i̱'nde ñánda kixì choòn, ótsji'nde nga si̱ìkjáya; k'e̱ nga mìkiì sakó'nde‑la̱, ");
INSERT INTO maaNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ìjngoò k'a síkítsjeèn, tsò: “Kjín‑la ìjngoò k'a‑na̱ ni'ya‑na̱ ñánda inchrobà‑na.” K'e̱ nga bijchó ìjngoò k'a‑ne, beè ni'ya‑la̱ nga kjijñá, ndaà kisatiìcha ko̱ tsjeè choòn. ");
INSERT INTO maaNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","I̱kjoàn fìkjaá nguì itoò xíkjín xi ìsa̱ ch'o s'ín. K'e̱é fahas'en‑jiìn ini̱ma̱‑la̱ xi̱ta̱ jè; ya̱á bìtsa̱jna. Xi̱ta̱ jè ìsa̱á 'ñó ch'o bìjna koni s'ín tsibìjna k'e̱ nga sa̱ ítjòn. Jñò, xi xi̱ta̱ ts'e̱n 'mì‑nò, k'oa̱á ti̱s'ín ko̱mat'ioòn na̱chrjein i̱'ndei̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tákó ti̱k'e̱é tíhóko̱ xi̱ta̱ Jesús nga ijchò nea̱‑la̱ ko̱ 'ndse̱. Ya̱á tsibìtsa̱jna ján ndi̱tsiaán nga mejèn‑la̱ ki̱chja̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jngoò xi̱ta̱ kitsò‑la̱ Jesús: ―Nea̱‑lè ko̱ jñà 'ndsì ján ndi̱tsiaán títsa̱jna. Ji̱ xó ko̱òko̱‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesús kitsò‑la̱ jè xi̱ta̱ xi ijchòko̱‑la̱ 'én: ―¿A mejèn‑lè nga jchi̱i yá‑né xi nea̱‑na̱ ko̱ xi 'ndsè? ");
INSERT INTO maaNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","K'e̱é tsakó‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱. Kitsò: ―Chítsején‑lá jñá xi̱ta̱ koi, jè‑né xi nea̱‑na̱ ko̱ jñà‑né xi 'ndsè. ");
INSERT INTO maaNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ngats'iì xi síkitasòn koni s'ín mejèn‑la̱ Na̱'èn‑na̱ xi tíjna ngajmiì, jñà‑né xi 'ndsè xi tichja ko̱ xi nea̱‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ti̱jè‑ne na̱chrjein, Jesús itjo‑ne ni'ya, ya̱á tsibìjnandiì ndáchikon. ");
INSERT INTO maaNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kjín jchán xi̱ta̱ chixoñat'aà‑la̱; Jesús jahas'en jngoò chitso; ya̱á tsibìjnaya. Ngats'iì xi̱ta̱ xi i'nga, ya̱á tsibìtsa̱jna i̱ndiì nandá. ");
INSERT INTO maaNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tsibíts'ia̱ Jesús nga kjìn sko̱ya kjoa̱ xi mangásòn tsibéno̱jmí kitsò: ―Jngoò xi̱ta̱ kiì kíjndi̱ xojmá. ");
INSERT INTO maaNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","K'e̱ nga tsibíts'ia̱ nga kiskíjndi̱ xojmá, chixò chiba ya̱ i̱ya ndi̱yá. I̱kjoàn j'iì ni̱se; tsakjèn. ");
INSERT INTO maaNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nguì koa̱ tjín chixò ñánda na̱xi̱ choòn nga chiba ni'nde tjín‑la̱. Jñà xojmá koi, ni̱to̱ón isò, koi‑né nga mì na̱nga̱ tjín nangui. ");
INSERT INTO maaNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ta̱nga k'e̱ nga itjokàtji ts'oí nga kjòtsjè ndobá, kixìñó, i̱kjoàn jngoò k'aá kixì, koi‑né nga tsjìn‑la̱ i̱ma̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nguì koa̱ tjín chixò ya̱ i̱jiìn na'yá. K'e̱ nga kjò'nga na'yá, kisìk'en‑ngui xka̱‑la̱ xojmá. ");
INSERT INTO maaNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jñà xi chixò ñánda nangui ndaà, ndaà tsajà‑la̱ toò. Tjín xi kitsjaà jngoò sìndo̱ nga jngoò ìjngoò xojmá, tjín xi kitsjaà jàn kaàn, koa̱ tjín xi kitsjaà katé. ");
INSERT INTO maaNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ndaà ti̱ná'yaà koni xan‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús ijchòkon ñánda tíjna koa̱ kiskònangui‑la̱ kitsò‑la̱: ―¿Mé‑ne k'oa̱s'ín nokjoà‑la̱ xi̱ta̱ kjoa̱ xi mangásòn k'e̱ nga okoòyi? ");
INSERT INTO maaNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús kitsò‑la̱: ―Jñò, Nainá jye kitsjaà‑nò nga jcha̱a kjoa̱'ma‑la̱ xi béno̱jmíya kó s'ín otíxoma jè xi ngajmiì nchrobá‑ne. Ta̱nga jñà xi̱ta̱ xi kj'ei̱í, mìkiì tíjiìn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jè xi tjín‑la̱ kjo̱hítsjeèn, k'oi̱í ìsa̱‑la̱ skanda tsatoó s'e̱‑la̱, ta̱nga jè xi tsjìn‑la̱, skanda tjá'aán‑la̱ mé xi chiba tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Koií kjoa̱‑la̱ k'e̱ nga okoòya, koií 'én chjà‑la̱ kjoa̱ xi mangásòn. Jñà xi̱ta̱ koi, sík'aá xko̱n ta̱nga mìkiì tsejèn‑la̱. Binchá líká‑la̱ ta̱nga mìkiì 'nchré, ti̱koa̱á mìkiì machi̱ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kjoa̱ ts'e̱ xi̱ta̱ koi, k'oa̱á s'ín bitasòn koni kitsò Isaías xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, nga kitsò: Jñò, na̱s'ín í'ñó‑ìsa ki̱ná'ya‑nò ta̱nga mìkiì ko̱chi̱ya‑nò, na̱s'ín í'ñó‑ìsa chítsejèn‑nò ta̱nga mìkiì jcha̱a. ");
INSERT INTO maaNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ini̱ma̱‑la̱ xi̱ta̱ koi, tájaàjiìn tjín; tsibíchjoàjto líká‑la̱, tíchjoàjto xko̱n. Koií kjoa̱‑la̱ mìkiì ndaà 'nchré ko̱ mìkiì tsejèn‑la̱ ko̱ mìkiì fahas'en‑jiìn‑la̱. K'oa̱á ma‑ne nga majìn‑la̱ nga 'a̱n fìt'aà‑na̱ mé‑ne nga 'a̱n sìndaà‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Jñò, mé tà ndaà‑nò nga tjín xkoòn nga ma tsejèn‑nò ko̱ tjín líká‑nò nga ma na'yà kjoa̱ xi tíma na̱chrjein i̱'ndei̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","O̱kixi̱í xi xan‑nò, kjìn xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá ko̱ xi xi̱ta̱ kixi̱ kjòmejèn‑la̱ nga skoe̱ jè xi jñò titsa̱'yaà ta̱nga mìkiì kijtseè; ti̱koa̱á kjìn xi̱ta̱ kjòmejèn‑la̱ nga kji̱'nchré jè xi jñò titsa̱na'yà ta̱nga mìkiì kiì'nchré. ");
INSERT INTO maaNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Ti̱ná'yaà kó tsòya‑ne jè kjoa̱ xi mangásòn ts'e̱ xi̱ta̱ xi kíjndi̱ xojmá. ");
INSERT INTO maaNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jñà xojmá xi chixò i̱ya ndi̱yá, jè ngaya‑la̱ koni jñà xi̱ta̱ xi 'nchré 'én‑la̱ Nainá koni s'ín otíxoma ta̱nga mìkiì machi̱ya‑la̱; f'iì xi̱ta̱ nei̱í, i̱kjoàn faáxìn jè 'én i̱jiìn ini̱ma̱‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jñà xojmá xi chixò ya̱ ñánda na̱xi̱ choòn, jè ngaya‑la̱ xi̱ta̱ xi 'nchré 'én‑la̱ Nainá. Tsjaá ma‑la̱ nga sa̱ 'nchré. ");
INSERT INTO maaNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ta̱nga jè‑nè nga tsjìn‑la̱ i̱ma̱, ta chiba na̱chrjein chíkjoa̱‑la̱. K'e̱ nga mé kjoa̱ xi sakó‑la̱ ko̱ tsà xi̱ta̱ fìtji̱ngui kondra̱‑la̱ nga jè nga̱tjì‑la̱ 'én‑la̱ Nainá, ni̱to̱ón síkíjna ndi̱yá‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jñà xojmá xi chixò i̱jiìn ñánda tjín na'yá, jè ngaya‑la̱ xi̱ta̱ xi 'nchré 'én‑la̱ Nainá ta̱nga 'ñó síkájno kjoa̱ ts'e̱ tsojmì xi tjín i̱sò'nde ko̱ jè kjoa̱ nchi̱ná kona̱cha̱n‑la̱. Jñà kjoa̱ koi síkits'ón‑jiìn 'én‑la̱ Nainá, k'oa̱á ma‑ne nga mìkiì makjìn‑ya. ");
INSERT INTO maaNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ta̱nga jñà xojmá xi chixò ñánda nga nangui ndaà, jè ngaya‑la̱ xi̱ta̱ xi 'nchré 'én‑la̱ Nainá koa̱ machi̱ya‑la̱; i̱kjoàn makjìn‑ya 'én, k'oa̱á ngaya‑la̱ koni yá xi ojà‑la̱ toò. Tjín xi tsjá katé; tjín xi tsjá jàn‑kaàn; tjín xi tsjá jngoò sìndo̱ nga jngoò ìjngoò yá. ");
INSERT INTO maaNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús nguì jngoò kjoa̱ xi mangásòn tsakóya‑la̱ xi̱ta̱, kitsò‑la̱: ―Koni s'ín otíxoma jè xi ngajmiì nchrobá‑ne, k'oa̱á ngaya‑la̱ koni jngoò xi̱ta̱ xi 'ñó ndaà xojmá‑la̱ trigo tsibítje̱sòn nangui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ta̱nga k'e̱ nga kjifè yije kóho̱tjín xi̱ta̱, j'iì kondra̱‑la̱ nga tsibítje̱jiìn xka̱ ijñá xi mìkiì ndaà ya̱ i̱jiìn trigo. I̱kjoàn kiì. ");
INSERT INTO maaNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","K'e̱ nga jye kjò'nga jñà trigo koa̱ kixò‑la̱ natín, ya̱á tsatsejèn‑jiìn ijñá xi mìkiì ndaà. ");
INSERT INTO maaNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","K'e̱é kiì jñà chi̱'nda nga tsibéno̱jmí‑la̱ nei‑la̱. Kitsò‑la̱: “Na̱'èn, jñà xojmá xi tsibìtji̱i ya̱ nangui‑lè, ndaà‑né. Ta̱nga, ¿ñánda j'iì‑ne ijñá xi mìkiì ndaà xi tsatsejèn‑jiìn trigo?” ");
INSERT INTO maaNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jè nei‑la̱ nangui, kitsò: “Jngoò‑la xi̱ta̱ kondra̱‑na̱ xi o̱kis'iìn.” K'e̱é kitsò jñà xi̱ta̱ chi̱'nda: “¿A mejèn‑lè nga ko̱nguí‑je̱n, chjínèjiìn‑je̱n jñà ijñá xi mìkiì ndaà?” ");
INSERT INTO maaNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ta̱nga jè nei‑la̱ nangui kitsò: “Majìn, tsà chjínè jñò ijñá xi mìkiì ndaà, tsà koi na̱chrjein‑la̱ ya̱á chjínèkjoò jñà trigo.” ");
INSERT INTO maaNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ti̱koa̱á‑ne kàtamajchákjoò ingajò skanda k'e̱ nga jye ko̱jchá. K'e̱ nga jè na̱chrjein nga si̱ncháxkó, 'a̱án ko̱xán‑la̱ chi̱'nda xi koi̱ìxkó: “Ítjòn xìn ki̱ncha ijñá xi mìkiì ndaà, ko̱'ñójté‑né mé‑ne nga ki̱ti̱‑ne. Nga ko̱ma i̱skan ki̱nchàxkó jñà trigo; ya̱á ki̱ncha i̱ya ni'nga‑na̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús ìjngoò k'a tsakóya‑la̱ xi̱ta̱ kjoa̱ xi mangásòn, kitsò‑la̱: ―Koni s'ín otíxoma jè xi ngajmiì nchrobá‑ne, jè mangásòn‑ko̱ koni kji xojmá mostaza k'e̱ nga jngoò xi̱ta̱ bítje̱jiìn nangui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","O̱kixi̱‑né xojmá jè, jè xi ìsa̱ i̱tsé kji ngats'iì xojmá xi tjín, ta̱nga k'e̱ nga jye majchá, ìsa̱á 'nga ma koni xka̱ xi ma chine xi sitje̱ i̱ndiì ni'ya. K'oa̱á kji 'nga ma koni jngoò yá 'nga; f'iì ni̱se xi tjímajiìn i̱sén, jñà chrja‑la̱ ya̱ bíndaà'a tjé‑la̱ ni̱se. ");
INSERT INTO maaNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús nguì jngoò k'a tsakóya‑la̱ xi̱ta̱ kjoa̱ xi mangásòn, kitsò‑la̱: ―Koni s'ín otíxoma jè xi ngajmiì nchrobá‑ne, k'oa̱á ngaya‑la̱ koni jè na̱'yo̱ san, k'e̱ nga jngoò chjo̱ón síkájiìn jàn chi̱ba̱ skoa̱n i̱nchra̱jín, masan yije‑né kóho̱kji na̱'yo̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ngats'iì 'én koi, Jesús, nguì kjoa̱ xi mangásòn tsakóya‑la̱ xi̱ta̱; ni̱mé 'én kiìchja̱ xi mìtsà kjoa̱ xi mangásòn tsibéno̱jmí. ");
INSERT INTO maaNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","K'oa̱á s'ín tsitasòn koni s'ín kitsò jè xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá nga kitsò: Kjoa̱ xi mangásòn kichjà. Koií kjoa̱ kèno̱jmiá kjoa̱ xi tjí'ma skanda tje̱n‑ne nga kisindaà i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús k'e̱ nga kisìhixat'aà xi̱ta̱ xi kjìn ma; i̱kjoàn jahas'en ni'ya. Ya̱á ijchòkon xi̱ta̱ xi kota'yàt'aà‑la̱. Kitsò‑la̱: ―Tèno̱jmí‑náje̱n kó tsòya‑ne jè kjoa̱ xi mangásòn ko̱ jè ijñá xi mìkiì ndaà xi tjín ya̱ i̱jiìn trigo. ");
INSERT INTO maaNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús kitsò: ―Jè xi kíjndi̱ xojmá xi ndaà, 'a̱n‑ná xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱; ");
INSERT INTO maaNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ko̱ jè nangui, jè i̱sò'nde; jñà xojmá xi ndaà, jñà‑né xi̱ta̱ xi títsa̱jnajiìn kjo̱tíxoma‑la̱ ngajmiì; jñà ijñá xi mìkiì ndaà, jñà‑né xi xi̱ta̱‑la̱ xi̱ta̱ nei̱í; ");
INSERT INTO maaNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ko̱ jè xi̱ta̱ kondra̱ xi tsibítje̱ ijñá xi mìkiì ndaà, ti̱jè‑ne xi̱ta̱ nei̱í; k'e̱ nga jye sincháxkó tsojmì xi ko̱jchá jè ngaya‑la̱ k'e̱ nga kjoe̱het'aà i̱sò'nde; koa̱ jñà xi bíxkó tsojmì, jñà ngaya‑la̱ àkja̱le̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","K'oa̱á s'ín sincháxkó ijñá xi mìkiì ndaà mé‑ne nga ko̱tsjòjiìn‑ne ni'ín nga ki̱ti̱, k'oa̱á s'ín ko̱ma k'e̱ nga kjoe̱het'aà i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ siìkasén àkja̱le̱‑na̱ i̱t'aà ts'e̱ kjo̱tíxoma‑na̱ mé‑ne nga koi̱ìxkó ngats'iì xi̱ta̱ xi bít'in‑la̱ xi̱ta̱ xi kj'ei̱í nga kàtátsji jé, ko̱ ngats'iì xi̱ta̱ xi ch'o s'ín. ");
INSERT INTO maaNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ya̱á ko̱tsjoya nga̱jo̱ ñánda títì ni'ín; ya̱á ski̱ndàya ko̱ si̱ìjts'iìn ni̱'ño̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Koa̱ jñà xi xi̱ta̱ kixi̱, k'oa̱á s'ín ote ko̱tsejèn koni ndobá‑la̱ ts'oí ya̱ ñánda nga tíhotíxoma Na̱'èn‑la̱. ¡Ndaà ti̱ná'yaà koni xan‑nò! ");
INSERT INTO maaNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Koni s'ín otíxoma jè xi ngajmiì nchrobá‑ne, k'oa̱á ngaya‑la̱ koni jngoò to̱n xi 'ñó chjí xi tíjna'ma i̱jiìn nangui. Jè xi̱ta̱ xi sakó‑la̱, tsjaá ma‑la̱. Ti̱ya̱á ìjngoò k'a bíjna'ma‑ne. K'e̱é fì katíjna yije tsojmì xi tjín‑la̱; i̱kjoàn otse nangui jè, nga ts'e̱ ko̱ma to̱n xi 'ñó chjí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Koni s'ín otíxoma jè xi ngajmiì nchrobá‑ne, k'oa̱á ti̱s'ín ngaya‑la̱ koni jngoò xi̱ta̱ xi koi xá s'ín nga tsojmì otíjnaya. Ótsji ndáto̱n chjí xi 'ñó ndaà. ");
INSERT INTO maaNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","K'e̱ nga jye sakó‑la̱ xi 'ñó chjí, i̱kjoàn fì katíjna yije tsojmì‑la̱ xi tjín‑la̱; k'e̱é otse ndáto̱n jè. ");
INSERT INTO maaNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Koni s'ín otíxoma jè xi ngajmiì nchrobá‑ne, ti̱koa̱á k'oa̱á s'ín ngaya‑la̱ koni jngoò na̱'ya xi nìkatje̱n‑jiìn ndáchikon mé‑ne nga ko̱ma kjìn sko̱ya ti̱n koi̱ìxkóya‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","K'e̱ nga jye tse na̱'ya‑la̱ jñà xi̱ta̱ xi sík'en ti̱n, fìko̱ ya̱ i̱ndiì ndáchikon; ya̱á faájiìn ngats'iì ti̱n xi ndaà kjoàn; ni̱si̱yá binchá; koa̱ jñà ti̱n xi mìkiì ndaà kjoàn, síkatsjoò‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","K'oa̱á s'ín ko̱ma k'e̱ nga kjoe̱het'aà i̱sò'nde, ki̱tjojen àkja̱le̱ xi kjoa̱ájiìn jñà xi̱ta̱ xi ch'o s'ín ya̱ ñánda títsa̱jna xi̱ta̱ kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ko̱ jñà xi̱ta̱ xi ch'o s'ín ko̱tsjoya nga̱jo̱ ñánda títì ni'ín; ya̱á ski̱ndàya ko̱ si̱ìjts'iìn ni̱'ño̱. ");
INSERT INTO maaNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús kiskònangui‑la̱ jñà xi̱ta̱, kitsò‑la̱: ―¿A machi̱yaá‑nò ngats'iì kjoa̱ koi? Jñà xi̱ta̱ kitsò: ―Jon, Na̱'èn. ");
INSERT INTO maaNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","K'e̱é kitsò‑la̱ Jesús: ―Jngoò xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés k'e̱ nga kota'yà kó s'ín otíxoma jè xi ngajmiì nchrobá‑ne, k'oa̱á s'ín ngaya‑la̱ koni jngoò nei‑la̱ ni'ya xi 'nchaxkó‑la̱ tsojmì, koa̱ k'e̱ nga mochjeén‑la̱, ochrje tsojmì chjí xi xi̱tse̱, o xi jye kòjchínga. ");
INSERT INTO maaNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús, k'e̱ nga jye tsibéno̱jmíya kjoa̱ xi mangásòn, kiì‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","K'e̱ nga ijchò‑ne nangui‑la̱ ján Nazaret, ya̱ ni'ya i̱ngo̱ sinagoga, tsibíts'ia̱ nga tsakóya‑la̱ xi̱ta̱ 'én‑la̱ Nainá. Koa̱ jñà xi̱ta̱ ta̱ kjòxkón‑la̱, k'e̱é kitsò: ―¿Xi̱ta̱ jè, ñánda komà‑la̱ ngats'iì kjoa̱chji̱ne̱ xi okóya? ¿Kó ma‑ne nga ma‑la̱ s'ín kjo̱xkón xi ndaà tjín? ");
INSERT INTO maaNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿A mìtsà jè ti‑la̱ chji̱ne̱yá? ¿A mìtsà jè nea̱‑la̱ xi 'mì María? ¿A mìtsà 'ndse̱ ma Jacobo, José, Simón, ko̱ Judas? ");
INSERT INTO maaNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ti̱koa̱á, ¿a mìtsà i̱ títsa̱jnajiìn‑ná jñà íchjín ndichja? ¿Ñánda ma yije‑la̱ kjoa̱ koi? ");
INSERT INTO maaNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","K'oa̱á ma‑ne nga mìkiì kòkjeiín‑la̱ i̱t'aà ts'e̱ Jesús. Ta̱nga jè Jesús kitsò‑la̱: ―Jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá, ni̱ta̱ ñá na̱xa̱ndá‑ne yaxkón‑né, ta̱nga ya̱ na̱xa̱ndá‑la̱ ko̱ ni'ya‑la̱ mìkiì yaxkón. ");
INSERT INTO maaNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mìkiì kjìn kjo̱xkón xi ndaà tjín kis'iìn nga jñà xi̱ta̱ xi ya̱ i̱'nde‑la̱ mìkiì kòkjeiín‑la̱ i̱t'aà ts'e̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jñà na̱chrjein koi, jè Herodes xi xi̱ta̱xá ítjòn tíjna ya̱ nangui Galilea, kiì'nchré koni s'ín béno̱jmí xi̱ta̱ mé kjoa̱ xi tís'ín Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kitsò‑la̱ jñà xi̱ta̱ xi síxá‑la̱: ―Xi̱ta̱ jè, jè‑né xi 'mì Juan xi kis'iìn bautizar xi̱ta̱ xi jye jaáya ìjngoò k'a‑la̱. K'oa̱á ma‑ne nga tjín‑la̱ nga'ñó nga ma‑la̱ s'ín kjo̱xkón xi ndaà tjín. ");
INSERT INTO maaNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nga ìsa̱ kjòtseé, jè Herodes kitsjaà o̱kixi̱ nga kitsobà'ñó Juan, i̱kjoàn kiskinìs'en nda̱yá, koií kjoa̱‑la̱ nga jè chjo̱ón Herodías xi chjo̱ón‑la̱ Felipe xi 'ndse̱ komà Herodes k'oa̱á s'ín kisìjé. ");
INSERT INTO maaNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Koií kjoa̱‑la̱ nga jè Juan xi kis'iìn bautizar xi̱ta̱, kjìn k'a o̱kitsò‑la̱ Herodes: “Mìkiì tjí'nde‑lè nga ji̱ tijnakoi̱i chjo̱ón‑la̱ 'ndsì.” ");
INSERT INTO maaNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","K'oa̱á ma‑ne nga jè Herodes mejèn‑la̱ kisìk'en Juan, ta̱nga jñà kitsakjòn‑la̱ xi̱ta̱ na̱xa̱ndá, nga jyeé tíjiìn‑la̱ na̱xa̱ndá nga jè Juan, jè xi̱ta̱ xi chja̱ya ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","K'e̱ nga ijchò nó‑la̱ jè Herodes, tsachrje s'eí‑la̱ koa̱ jè tsòti‑la̱ Herodías kitè nga nguixko̱n xi̱ta̱ xi títsa̱jna s'eí. Jè Herodes, 'ñó ndaà kisaseèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Koa̱ kitsjaà kixi̱ 'én‑la̱ nga tsjá yije‑la̱ mé xi si̱ìjé‑la̱ jè tsòti. ");
INSERT INTO maaNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Koa̱ jè nea̱‑la̱ chinchá'a ítjòn jè tsòti nga kàtasíjé‑la̱ sko̱ Juan. Jè tsòti, k'e̱é kitsò‑la̱ Herodes: ―Tjiì‑ná sko̱ Juan xi kis'iìn bautizar xi̱ta̱, tinaya‑ná chro̱ba̱te. ");
INSERT INTO maaNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jè Herodes xi xi̱ta̱xá ítjòn tíjna, kjòba‑la̱ k'e̱ nga kiì'nchré‑la̱ jè tsòti. Ta̱nga koií kjoa̱‑la̱ nga jye kitsjaà kixi̱‑la̱ 'én nga nguixko̱n xi̱ta̱ xi ya̱ títsa̱jna s'eí, k'e̱é kitsjaà o̱kixi̱ nga k'oi̱‑la̱ sko̱ Juan jè tsòti. ");
INSERT INTO maaNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jè Herodes kitsjaà‑la̱ o̱kixi̱ xi̱ta̱‑la̱ nga tsatesin Juan ya̱ i̱ya nda̱yá. ");
INSERT INTO maaNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","I̱kjoàn kiìko̱ sko̱ Juan, tjíya‑la̱ chro̱ba̱te nga kitsjaà‑la̱ jè tsòti, ko̱ jè tsòti kisìnga̱tsja nea̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","K'e̱é ijchò xi̱ta̱ xi kota'yàt'aà‑la̱ Juan; kiskoé yijo‑la̱ nga jye k'en, i̱kjoàn kiì kíhijiìn; nga komà i̱skan, kisìkí'nchré Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús, k'e̱ nga jye kiì'nchré jè kjoa̱ xi komàt'in Juan, tà ta̱jngoò kiì‑ne; tsibìjna'ya jngoò chitso; ijchò jngoò i̱'nde i̱t'aà xìn. Ta̱nga jñà xi̱ta̱, nga jye kiì'nchré nga kiì‑ne Jesús, ti̱koa̱á kiìtji̱ngui‑la̱; saà ndso̱ko̱ó kiì‑ne ngats'iì xi̱ta̱ xi ya̱ chrañàt'aà‑la̱ na̱xa̱ndá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús, k'e̱ nga itjojen chitso, kijtseè nga 'ñó kjìn ma xi̱ta̱ xi títsa̱jna; kjòhi̱ma̱keè‑né. K'e̱é kisìndaà‑ne ngats'iì xi̱ta̱ xi xk'én. ");
INSERT INTO maaNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nga jye kjòhoxòn jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús ijchò kinchat'aà‑la̱, kitsò‑la̱: ―Jye kjòhoxòn, ko̱ i̱'nde jè, i̱t'aà xìn‑né; ni̱mé tjín. Ko̱t'ìn‑la̱ jñà xi̱ta̱ kàtjì‑ne nga kàtatse tsojmì xi ski̱ne̱ jñà na̱xa̱ndá ñánda nga chrañàt'aà. ");
INSERT INTO maaNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús kitsò: ―Mìkiì kjoi̱‑ne. Tjiì‑là jñò xi ko̱kje̱n xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kitsò: ―Ni̱mé tjín‑naje̱n. Tà 'òn ma i̱nchra̱jín ko̱ jò ma ti̱n xi títsa̱jna‑na̱je̱n. ");
INSERT INTO maaNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús kitsò‑la̱: ―Nchrohóko̱‑ná i̱jndé. ");
INSERT INTO maaNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","K'e̱é kitsò‑la̱ jñà xi̱ta̱ xi kjìn ma‑ne nga kàtìtsa̱jnajiìn ijñá; i̱kjoàn kiskoé jñà i̱nchra̱jín xi 'òn ma‑ne ko̱ jñà ti̱n xi jò ma‑ne; i̱kjoàn kiskoòtsejèn ngajmiì, kitsjaà‑la̱ kjo̱ndaà Nainá, i̱kjoàn kisìxkoa̱ya i̱nchra̱jín; k'e̱é kitsjaà‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱, koa̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ kisìka'bí‑la̱ jñà xi̱ta̱ xi kjìn ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tsakjèn yije kóho̱tjín xi̱ta̱ kó nga kjòskiì. K'e̱é tsibíxkó‑ne jñà xi tsiningui‑ne. Nguì tejò ni̱si̱yá komà. ");
INSERT INTO maaNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jñà xi̱ta̱ xi tsakjèn, 'òn jmiì ma‑ne xi xi̱ta̱ x'i̱n. Mìkiì kòxke̱ya jñà íchjín ko̱ i̱xti. ");
INSERT INTO maaNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nga komà i̱skan, Jesús kisìkas'en xi̱ta̱ xi kota'yàt'aà‑la̱ ya̱ i̱ya chitso mé‑ne nga ìsa̱ ítjòn ki̱jchò‑ne ján xijngoaà ndáchikon; koa̱ jè Jesús k'e̱é tísíhixat'aà xi̱ta̱ xi kjìn ma‑ne nga jye nchifì‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","K'e̱ nga jye kisìhixat'aà yije jñà xi̱ta̱, Jesús kiìmijìn‑jno jngoò nindoò nga kiì kiìchja̱t'aà‑la̱ Nainá nga ta̱ jè ta̱jngoò. K'e̱ nga jye kòjñò, Jesús tà ta̱jngoò tíjna ya̱ i̱'nde jè. ");
INSERT INTO maaNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jè chitso jye 'ñó kjìn ijchò. Jè nga'ñó‑la̱ nandá jye ngaxìn ngaje̱n tífìko̱ chitso nga jè tjo̱ bíchjoà ikon‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","K'e̱ nga ta̱jñòya ìsa̱, Jesús kiìtji̱ngui‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱ nga kiì‑ne ndso̱ko̱ ya̱ i̱sòn nandá. ");
INSERT INTO maaNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ k'e̱ nga kijtseè nga tífìsòn nandá tà kitsakjòn‑la̱; k'e̱é kiskindàya xkón, kitsò: ―Ini̱ma̱ ch'o‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ta̱nga Jesús ni̱to̱ón kiìchja̱‑la̱, kitsò‑la̱: ―'Ñó t'è‑là takòn, kì tsakjoòn‑jèn, 'a̱n‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jè Pedro, k'e̱é kiìchja̱‑la̱ kitsò‑la̱: ―Na̱'èn, tsà ji̱‑né, tjiì'nde‑ná nga kjísoàn nandá skanda ñánda tìsìjni. ");
INSERT INTO maaNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús kitsò‑la̱: ―Nchroboí. Jè Pedro itjojen‑jno chitso koa̱ tsibíts'ia̱ nga kiì‑ne ndso̱ko̱ ya̱ i̱sòn nandá ñánda síjna Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ta̱nga k'e̱ nga kijtseè nga jè tjo̱ 'ñó tí'ba, kitsakjòn‑né, i̱kjoàn tsibíts'ia̱ nga mejèn kiskaàjiìndá; k'e̱é kiskindàya kitsò: ―¡Na̱'èn, na̱chrjejiìn‑ndá‑ná! ");
INSERT INTO maaNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesús ni̱to̱ón kitsobà'ñó tsja, kitsò‑la̱: ―¡Chibaá mokjeiín‑lè i̱t'aà ts'a̱n! ¿Mé‑ne jò kòbeè‑la̱ takoìn? ");
INSERT INTO maaNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","K'e̱ nga jahas'en‑ne chitso ingajò, ni̱to̱ón kisijyò‑ne tjo̱. ");
INSERT INTO maaNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jñà xi̱ta̱ xi títsa̱jnaya chitso chincha-xkó'nchit'aà‑la̱ Jesús, kitsò‑la̱: ―¡Xi o̱kixi̱, ji̱‑né xi Ki'ndí‑la̱ Nainá! ");
INSERT INTO maaNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","K'e̱ nga jye tsatojiìn ndáchikon, ijchò ján nangui Genesaret. ");
INSERT INTO maaNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jñà xi̱ta̱ xi ya̱ i̱'nde‑la̱, k'e̱ nga kijtseèxkon Jesús nga jè xi ya̱ ijchò, kisìkí'nchré xíkjín kóho̱kji ya̱ i̱'nde ñánda chrañàt'aà; i̱kjoàn j'iìko̱‑la̱ ngats'iì xi̱ta̱ xi xk'én ya̱ ñánda tíjna Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tsibítsi'ba‑la̱ na̱s'ín ta̱ jè i̱tjòn nikje‑la̱ tsobà'ñó nga kàtandaà‑ne; ngats'iì xi kitsobà'ñó nikje‑la̱ kjòndaà yijeé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ijchò i'nga xi̱ta̱ fariseo ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés xi inchrobà‑ne Jerusalén nga kiskònangui‑la̱ Jesús, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Mé‑ne jñà xi̱ta̱ xi kota'yàt'aà‑lè, k'e̱ nga kjèn, mì k'oa̱á s'ín oníjno‑ne tsja koni s'ín síjé kjo̱tíxoma‑la̱ xi̱ta̱ jchínga‑ná? ");
INSERT INTO maaNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús k'e̱é kiskònangui‑la̱ jñà xi̱ta̱ koi, kitsò‑la̱: ―¿Jñò, mé‑ne mìkiì nìkitasòn‑nò kjo̱tíxoma‑la̱ Nainá nga koi onguítji̱ngui‑là kjo̱tíxoma‑la̱ xi̱ta̱? ");
INSERT INTO maaNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jè Nainá k'oa̱á kitsò: “Jcha̱xkoín na̱'èn‑lè ko̱ nea̱‑lè”, ko̱: “Jè xi chja̱jno‑la̱ na̱'èn‑la̱ ko̱ nea̱‑la̱ tjínè‑la̱ nga ki̱yá.” ");
INSERT INTO maaNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ta̱nga jñò bixón‑nó: “Jngoò xi̱ta̱ ma ki̱tso̱‑la̱ na̱'èn‑la̱, o nea̱‑la̱: Mìkiì ko̱ma siìchját'aà‑lè; ngats'iì tsojmì xi tjín‑na, jè Nainá jye kitsjaà‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Bixón‑nó nga mì ti̱ kiì tjí'nde‑la̱ nga skoe̱xkón na̱'èn‑la̱ ko̱ nea̱‑la̱; mì ti̱ kiì ko̱ma ko̱si̱ko̱‑nò. K'oa̱á s'ín 'nè jñò nga nìkíjna kjo̱tíxoma‑la̱ Nainá nga koi onguítji̱ngui‑lá kjo̱tíxoma tsa̱jòn. ");
INSERT INTO maaNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jñò, xi̱ta̱ xi jò ma i̱sén‑nò, ndaà kiìchja̱ i̱t'aà tsa̱jòn Isaías, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá k'e̱ nga kitsò: ");
INSERT INTO maaNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Jñà xi̱ta̱ koi beèxkón‑na xi tà 'én chja̱ ta̱nga jè ini̱ma̱‑la̱ kjiìn tíjnat'aàxìn. ");
INSERT INTO maaNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ni̱mé chjí‑la̱ nga beèxkón‑na, nga kjo̱tíxoma‑la̱ xi̱ta̱á okóya koni tsà kjo̱tíxoma‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesús, k'e̱é kiìchja̱‑la̱ ngats'iì xi̱ta̱, kitsò‑la̱: ―Ti̱ná'yaà ko̱ ndaà kàtachi̱ya‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jñà tsojmì xi tso'ba kine‑ne xi̱ta̱, mìtsà jñà xi síkits'ón xi̱ta̱ nga nguixko̱n Nainá; jñà xi tso'ba bitjo‑ne xi síkits'ón. ");
INSERT INTO maaNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús ijchòkon, kiskònangui‑la̱, kitsò‑la̱: ―¿A tíjiìn‑lè jñà xi̱ta̱ fariseo kòjti‑la̱ k'e̱ nga kiì'nchré 'én koni s'ín kinokjoì? ");
INSERT INTO maaNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús kitsò‑la̱: ―Ni̱to̱n mé tsojmì tjè xi mìtsà jè Na̱'èn‑na̱ xi tíjna ngajmiì tsibítje̱, tjánè‑né skanda ko̱ i̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kì kiì 'nè kinda̱; jñà xi̱ta̱ fariseo mejèn‑la̱ okó‑la̱ ndi̱yá jñà xi̱ta̱ xi mìkiì tsejèn‑la̱, ta̱nga jñà, ti̱koa̱á mìkiì tsejèn‑la̱. Tsà jngoò xi̱ta̱ xi mìkiì tsejèn‑la̱, mìkiì ko̱ma ko̱kò‑la̱ ndi̱yá ìjngoò xi ti̱koa̱ mìkiì tsejèn‑la̱. Ingajò, ya̱á ki̱xo̱ya nga̱jo̱ ñánda ch'o choòn. ");
INSERT INTO maaNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro kitsò‑la̱ Jesús: ―Tèno̱jmíya‑náje̱n jè kjoa̱ koi koni s'ín kasi. ");
INSERT INTO maaNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús kitsò: ―¿Jñò, a ti̱koa̱á mìkiì machi̱ya‑nò kó tsòya‑ne? ");
INSERT INTO maaNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A mì fìya‑nò ngats'iì tsojmì xi ndso̱baá chine‑ná, i̱ndso̱'bá fìs'en, i̱kjoàn bitjojiìn‑ne yijo‑ná? ");
INSERT INTO maaNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ta̱nga ngats'iì 'én xi ndso̱baá nokjoàa‑ná, ini̱ma̱‑ná bitjojiìn; jñà 'én koi, jñà‑né xi síkits'ón xi̱ta̱ nga nguixko̱n Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nga ya̱á bitjokàjiìn ini̱ma̱‑la̱ xi̱ta̱ kjo̱hítsjeèn xi ch'o tsò, koni jñà xi xi̱ta̱ sík'en, ko̱ xi kjoa̱ chijngui s'ín ts'e̱ xi̱ta̱ xi kj'eè kiì bixan ko̱ xi jye chixàn, ko̱ kjoa̱ chijé, ko̱ kjoa̱ ndiso ko̱ kjoa̱ nga chja̱jno‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ngats'iì kjoa̱ koi xi ini̱ma̱‑la̱ bitjokàjiìn‑ne xi̱ta̱, jñà‑né xi síkits'ón xi̱ta̱; ta̱nga k'e̱ nga bichiaá, na̱s'ín mìkiì onìjnoaá ndsa̱á, mìkiì síkits'ón‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús itjokàjiìn ya̱ i̱'nde jè; kiì i̱'nde ñánda 'mì Tiro ko̱ Sidón. ");
INSERT INTO maaNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jngoò chjo̱ón xi xi̱ta̱ Cananea xi ya̱ i̱'nde‑la̱, inchrobà‑ne ijchòkon Jesús, 'ñó kiìchja̱, kitsò‑la̱: ―¡Na̱'èn, nga ya̱ nchrobàt'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David nga ji̱ tijna ngajo‑la̱ jcha̱hi̱ma̱‑ná! Ndí tsòti‑na̱ ch'in nei̱í tíjiìn ini̱ma̱‑la̱, tseé kjo̱'in tísíkjeiín. ");
INSERT INTO maaNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ta̱nga Jesús nì mé 'én kiìchja̱‑la̱ jè chjo̱ón. Ko̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, kitsò: ―Ko̱t'ìn‑la̱ chjo̱ón jè, kàtjì‑ne; tsí ch'o kjindáya tji̱ngui‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","K'e̱é kitsò Jesús: ―Nainá kisìkasén‑na, tà jñà j'i̱ katsjià xi̱ta̱ na̱xa̱ndá Israel nga kichijà koni orrè. ");
INSERT INTO maaNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ta̱nga jè chjo̱ón tsasìxkó'nchit'aà‑la̱ Jesús, kitsò‑la̱: ―Na̱'èn, ti̱chját'aà‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús kitsò‑la̱: ―Mìkiì ndaà tjín nga chjaà'an‑lá ni̱ño̱ jñà i̱xti, i̱kjoàn k'oi̱‑lá nañá. ");
INSERT INTO maaNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ta̱nga jè chjo̱ón kitsò: ―Jon, Na̱'èn, ta̱nga jñà nañá kineé xi̱‑la̱ tsojmì xi bixòngui ími̱xa̱‑la̱ nei‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesús k'e̱é kitsò‑la̱: ―Ji̱ chjo̱ón, 'ñó ndaà mokjeiín‑lè i̱t'aà ts'a̱n. K'oa̱s'ín kàtama koni s'ín mejèn‑lè. Ko̱ jè tsòti‑la̱ chjo̱ón, ti̱k'e̱é kjòndaà‑ne nga ti̱jè‑ne hora. ");
INSERT INTO maaNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús kiì‑ne ya̱ i̱'nde ñánda 'mì Tiro ko̱ Sidón koa̱ tsatot'aà i̱ndiì nandá Galilea. K'e̱é kiìmijìn‑jno jngoò nindoò ko̱ ya̱á tsibìjna. ");
INSERT INTO maaNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kjìn jchán xi̱ta̱ ijchòtji̱ngui‑la̱ ñánda tíjna; ijchòko̱‑la̱ xi̱ta̱ xi tsá'yá kjoàn, xi̱ta̱ xi mìkiì tsejèn‑la̱, xi̱ta̱ xi kótó tsja kjoàn, xi̱ta̱ xi mìkiì ma chja̱ ko̱ xi̱ta̱ xi kj'ei̱í ch'in tjín‑la̱; ya̱á kisìkítsa̱jnangui ndso̱ko̱ Jesús. Ngats'iì xi̱ta̱ koi kisìndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tà kjòxkón‑la̱ jñà xi̱ta̱ k'e̱ nga kijtseè nga komà kiìchja̱‑ne jñà xi mìkiì ma chja̱; koa̱ jñà xi mìkiì ndaà síxá tsja, kjòndaà‑ne; xi mì ma fì, komà kiì‑ne; koa̱ jñà xi mìkiì tsejèn‑la̱, kjòtsejèn‑la̱. K'e̱é jeya kisìkíjna Nainá koni kisìko̱ jñà xi̱ta̱‑la̱ na̱xa̱ndá Israel. ");
INSERT INTO maaNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús kiìchja̱‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱, kitsò‑la̱: ―Mahi̱ma̱keè‑ná jñà xi̱ta̱ koi. Jye kò jàn na̱chrjein tjín‑la̱ nga títsa̱jnako̱‑na, koa̱ ni̱mé tjín tsojmì xi kine. Majìn‑na nga tà k'oa̱s'ín sìkasén chjan‑na ni'ya‑la̱ tsà ya̱ ko̱hindaàya ndi̱yá. ");
INSERT INTO maaNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kitsò: ―Jngoò i̱'nde i̱t'aà xìn ñánda ni̱mé tsojmì tjín, ¿kós'ín ko̱ma sakó‑ná tsojmì xi ko̱kje̱n jñà xi̱ta̱ koi nga 'ñó kjìn ma‑ne? ");
INSERT INTO maaNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús kiskònangui‑la̱, kitsò‑la̱: ―¿Kó tjín ma i̱nchra̱jín xi tíyijò‑nò? Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ kitsò: ―Itoò ma‑ne i̱nchra̱jín, ko̱ tjín chiba‑naje̱n ti̱n jtobá. ");
INSERT INTO maaNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","K'e̱é kitsò Jesús: ―Koa̱tìn‑la̱ kàtìtsa̱jnat'aà nangui jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jesús kiskoé i̱nchra̱jín xi itoò ma‑ne ko̱ jñà ti̱n jtobá, kitsjaà‑la̱ kjo̱ndaà Nainá, i̱kjoàn kisìxkoa̱ya, kjònga̱tsja jñà xi̱ta̱ xi kota'yàt'aà‑la̱ mé‑ne nga kitsjaà‑la̱ jñà xi̱ta̱ xi kjìn ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tsakjèn yije xi̱ta̱ kóho̱tjín skanda kó nga kjòskiì. K'e̱ nga tsibíxkó‑ne xi tsiningui‑ne, nguì itoò ni̱si̱yá komà. ");
INSERT INTO maaNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jñà xi̱ta̱ xi tsakjèn, ñijòn jmiì ma‑ne xi xi̱ta̱ x'i̱n, mìkiì kòxke̱ya jñà íchjín ko̱ i̱xti. ");
INSERT INTO maaNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesús kisìhixat'aà xi̱ta̱, i̱kjoàn jahas'en chitso koa̱ kiì ya̱ i̱'nde ñánda 'mì Magdala. ");
INSERT INTO maaNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jñà xi̱ta̱ fariseo ko̱ xi̱ta̱ saduceo kiìkon Jesús ñánda tíjna nga mejèn‑la̱ skót'aà tsà kixi̱ kjoa̱ nga Nainá kisìkasén. Kisìjé jngoò‑la̱ seña xi jeya tjín xi i̱t'aà ts'e̱ Nainá nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ta̱nga Jesús kitsò‑la̱: ―K'e̱ nga jye mahixòn, jñò, bixón‑nò: “Ndaà choòn nchijòn‑lè, inì choòn ján ngajmiì.” ");
INSERT INTO maaNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","K'e̱ nga ta̱jñòya bixón‑nò: “Mìkiì ndaà choòn na̱chrjein i̱'ndei̱; ngajmiì inì choòn ko̱ ifi kjiya.” Jñò xi jò ma i̱sén‑nò, 'ya‑nò kó choòn ngajmiì ta̱nga mìkiì fìya‑nò kó tsòya‑ne kjo̱xkón xi tíma na̱chrjein i̱'ndei̱. ");
INSERT INTO maaNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jñà xi̱ta̱ ts'e̱n ko̱ xi̱ta̱ xi mìkiì 'nchréñijon‑la̱ Nainá, jngoò seña síjé xi jeya tjín; ta̱nga ni̱mé seña skoe̱, tà jè skoe̱ ts'e̱ Jonás, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. Jesús ya̱á kisìkítsa̱jna xi̱ta̱ koi; jè, kiì‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, k'e̱ nga tsatot'aà xijngoaà nandá, kijchàajiìn‑la̱ mìkiì ts'a i̱nchra̱jín. ");
INSERT INTO maaNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús kitsò‑la̱: ―Chítsejèn‑là koa̱ ti̱kinda̱a yijo‑nò i̱t'aà ts'e̱ na̱'yo̱ san‑la̱ xi̱ta̱ fariseo ko̱ xi̱ta̱ saduceo. ");
INSERT INTO maaNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús tsohóko̱ xíkjín, kitsò‑la̱: ―Koií ko̱tsò‑ná nga mìkiì kich'á i̱nchra̱jín. ");
INSERT INTO maaNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús ni̱to̱ón kijtseèya‑la̱, kitsò‑la̱: ―¿Mé‑ne ko̱kixón‑nò nga tsjìn‑nò i̱nchra̱jín? 'Ñó chi̱ba̱ mokjeiín‑nò i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿A mì machi̱ya‑nò, a mì bítsjeèn‑nò k'e̱ nga kisìka'biá i̱nchra̱jín xi 'òn ma‑ne koa̱ 'òn jmiì xi̱ta̱ x'i̱n tsakjèn? ¿Kó tjín ni̱si̱yá tsibíxkó‑ìsa? ");
INSERT INTO maaNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿A mì tíjiìn‑nò ti̱koa̱á k'e̱ nga kisìka'biá i̱nchra̱jín xi itoò ma‑ne ko̱ ñijòn jmiì xi̱ta̱ tsakjèn? ¿Kó tjín ni̱si̱yá tsibíxkó‑ìsa? ");
INSERT INTO maaNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Mé‑ne nga mìkiì machi̱ya‑nò nga 'a̱n mìtsà koi xi o̱tìxan‑nò i̱t'aà ts'e̱ i̱nchra̱jín? Jè‑né nga ti̱kinda̱a yijo‑nò na̱'yo̱ san‑la̱ xi̱ta̱ fariseo ko̱ xi̱ta̱ saduceo. ");
INSERT INTO maaNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","K'e̱é kjòchi̱ya‑la̱ nga jè Jesús k'e̱ nga o̱kitsò‑la̱: “Ti̱kinda̱a yijo‑nò”, mìtsà na̱'yo̱ san‑la̱ i̱nchra̱jín xi tsibéno̱jmí‑la̱, jñà kjo̱hítsjeèn xi okóya jñà xi̱ta̱ fariseo ko̱ xi̱ta̱ saduceo. ");
INSERT INTO maaNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","K'e̱ nga ijchò Jesús ya̱ i̱'nde ñánda 'mì Cesarea ts'e̱ Filipo kiskònangui‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱. Kitsò‑la̱: ―¿Kó tsò jñà xi̱ta̱? ¿Yá‑ná 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱? ");
INSERT INTO maaNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kitsò jñà xi̱ta̱ xi kota'yàt'aà‑la̱: ―Tjín xi tsò: “Jè Juan xi kis'iìn bautizar xi̱ta̱.” Ko̱ tjín xi tsò: “Jè Elías.” Ti̱koa̱á tjín xi̱ta̱ xi tsò: “Jè Jeremías.” Ko̱ xi kj'ei̱í xi̱ta̱ tsò‑né: “Jngoò xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá.” ");
INSERT INTO maaNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","K'e̱é kitsò Jesús: ―¿Koa̱ jñò, kó bixón? ¿Yá‑ná 'a̱n? ");
INSERT INTO maaNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","K'e̱é kiìchja̱ Simón Pedro kitsò: ―Ji̱‑né xi Cristo xi xó kisìkasén‑ne Nainá, Ki'ndí‑la̱ Nainá xi tíjnakon. ");
INSERT INTO maaNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","I̱kjoàn kiìchja̱ Jesús; kitsò‑la̱: ―Mé tà ndaà‑lè nga ji̱ Simón, ki'ndí‑la̱ Jonás. Jè Nainá xi tíjna ngajmiì tsakó‑lè ngats'iì kjoa̱ koi; mìtsà xi̱ta̱ i̱sò'nde tsibéno̱jmí‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","'A̱n, k'oa̱á xán‑lè nga Pedro 'mì‑lè nga nda̱jo̱ tsò‑ne; ya̱á i̱sòn nda̱jo̱ jè kìndaàsoàn na̱xa̱ndá‑na̱; na̱s'ín jè nga'ñó‑la̱ kjoa̱biyaà mìkiì si̱ìkijne‑la̱ jñà xi̱ta̱ na̱xa̱ndá‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","'A̱án tsjaà‑lè ibi̱‑la̱ xotjoa̱‑la̱ na̱xa̱ndá xi jè otíxoma‑la̱ jè xi ngajmiì nchrobá‑ne; ngats'iì kjoa̱ xi koi̱'ndi i̱ i̱sò'nde, ti̱koa̱á ján ngajmiì Nainá tsjá'nde‑né; ko̱ jñà kjoa̱ xi mìkiì koi̱'ndi i̱ i̱sò'nde, ti̱koa̱á ján ngajmiì, Nainá mìkiì tsjá'nde. ");
INSERT INTO maaNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesús kitsò‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱: ―Kì yá xi bèno̱jmí‑là nga 'a̱n‑ná xi Cristo nga 'a̱án kisìkasén‑na Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ti̱koi̱‑ne na̱chrjein Jesús tsibíts'ia̱ nga tsibéno̱jmíya‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱ nga jè, ján kjoi̱ Jerusalén, koa̱ jñà xi̱ta̱ jchínga ko̱ xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, tseé kjo̱'in tsjá‑la̱. Si̱ìk'en‑né. Ta̱nga k'e̱ nga ki̱jchò jàn na̱chrjein, kjoa̱áya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jè Pedro k'e̱é kiìko̱ Jesús ñánda i̱t'aà xìn nga kiìchja̱ko̱ nga mìkiì ndaà tjín koni tsò. Kitsò‑la̱: ―Na̱'èn, kì k'oa̱á s'ín nìkítsjiìn. Mì k'oa̱á tsò Nainá nga k'oa̱s'ín ko̱mat'in. ");
INSERT INTO maaNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ta̱nga Jesús kisìkáfaya, kitsò‑la̱ jè Pedro: ―Ti̱si̱t'aàxín‑ná ji̱ xi̱ta̱ nei̱í. Tà mejèn‑lè nga jé binchaàtsji‑ná. Mìtsà k'oa̱s'ín nìkítsjiìn koni s'ín tjín kjo̱hítsjeèn‑la̱ Nainá. Ngaji̱ tà k'oa̱á s'ín nìkítsjiìn koni s'ín tjín kjo̱hítsjeèn‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesús k'e̱é kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Tsà yá xi mejèn‑la̱ nga xi̱ta̱ ts'a̱n ko̱ma, kàtatsjeiìn‑takòn mé xi mejèn‑la̱ yijo‑la̱; koni jngoò xi̱ta̱ xi 'yajen krò‑la̱, kàtìjnandaà nga si̱ìkjeiín kjo̱'in xi kjoa̱ ts'a̱n; ndaà kàtjìt'aà‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nga ni̱ta̱ yá xi̱ta̱ xi mejèn‑la̱ ko̱chrjetjì yijo‑la̱ nga ni̱mé kjo̱'in sa̱kò‑la̱, tà sa̱á si̱ìchija‑né ko̱ kjo̱'in kíjnajiìn; ta̱nga jè xi tíjnandaà nga tsjá yijo‑la̱ xi kjoa̱ ts'a̱n, sa̱kò‑la̱ kjoa̱binachon nga i̱t'aà ts'a̱n ndaà kíjna. ");
INSERT INTO maaNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Mé xi si̱ìkijne jngoò xi̱ta̱ na̱s'ín tjoé yije‑la̱ i̱sò'nde tsà si̱ìchja ini̱ma̱‑la̱? Ni̱mé. ¿A ko̱maá koi̱ìchjí kjoa̱biyaà jngoò xi̱ta̱ xi majìn‑la̱ nga ki̱yá? Majìn. ");
INSERT INTO maaNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ ki̱tjojeén ìjngoò k'a‑na nga kjoi̱koa̱a kjoa̱jeya‑la̱ Na̱'èn‑na̱ ko̱ àkja̱le̱‑la̱ nga sichikon‑t'ian nga jngoò ìjngoò xi̱ta̱ koni s'ín kisìkitasòn. ");
INSERT INTO maaNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","O̱kixi̱í xi xan‑nò, títsa̱jnajiìn i'nga i̱jndé xi̱ta̱ xi mì kì ki̱yá skanda k'e̱ nga skoe̱‑na xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ nga kítjo̱je̱n ìjngoò k'a nga kotiìxoma. ");
INSERT INTO maaNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nga komà joòn na̱chrjein Jesús kiìmijìn‑jno jngoò nindoò xi 'nga kji; kiìko̱ jè Pedro, Jacobo, ko̱ Juan xi 'ndse̱ ma Jacobo. ");
INSERT INTO maaNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","K'e̱ nga ijchò i̱'nde jè, Jesús, jahatjìya í'ñó i̱sén‑la̱ nga nguixko̱n jñà xi̱ta̱ koi. K'oa̱á kji komà i̱sén‑la̱ koni kji ts'oí ko̱ jè nikje‑la̱ kjòchroba‑né koni i̱sén ndobá. ");
INSERT INTO maaNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jñà xi̱ta̱ koi tà ni̱to̱ón kijtseè Moisés ko̱ Elías nga nchijoókjoò Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro kitsò‑la̱ Jesús: ―Na̱'èn, ndaà tjín nga i̱ titsa̱jnaá; tsà mejèn‑lè jàn ni'ya xkójndà kíndaà‑je̱n, jngoò tsi̱ji, jngoò ts'e̱ Moisés ko̱ xi ìjngoò ts'e̱ Elías. ");
INSERT INTO maaNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","K'e̱ nga tíchja̱ Pedro, j'iì jngoò 'nguién‑la̱ ifi xi ote kji xi tsibí'ma xi̱ta̱ koi, ko̱ ya̱ i̱jiìn ifi kina'yà jngoò‑la̱ 'én xi kitsò: ―Jè jèe̱ xi ki'ndí‑na̱ xi 'ñó matsjake̱ ko̱ xi xó jaàjiìn‑na̱; jè ti̱ná'ya‑là. ");
INSERT INTO maaNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús k'e̱ nga kiì'nchré, tà kitsakjòn‑né. K'e̱é tsoyijò tsakjàn skanda i̱t'aà nangui. ");
INSERT INTO maaNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús kiìkasìt'aà chrañà‑la̱; kisìkjaníyá‑la̱, kitsò‑la̱: ―Ti̱sítje̱en, kì tsakjón‑jèn. ");
INSERT INTO maaNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","K'e̱ nga kiskoòtsejèn xi̱ta̱ koi mì ti̱ yá tjín‑ne. Tà jè ta̱jngoò síjna Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","K'e̱ nga inchrohòjen‑t'aà‑ne nindoò, Jesús kitsò‑la̱: ―Kì yá xi̱ta̱ xi bèno̱jmí‑là jè kjoa̱ xi kà'yaà skanda k'e̱ nga kjoa̱áya‑na i̱t'aà ts'e̱ kjoa̱biyaà 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kiskònangui‑la̱, kitsò‑la̱: ―¿Mé‑ne ko̱tsò‑ne xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés nga jè Elías kjoi̱í ítjòn? ");
INSERT INTO maaNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús kitsò: ―O̱kixi̱‑né, jè kjoi̱í ítjòn Elías, ko̱ jè koi̱ìndaàjiìn yije kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ta̱nga 'a̱n, k'oa̱á xán‑nò, jè Elías, jyeé j'iì. Jñà xi̱ta̱, mìkiì kijtseèxkon. Ta k'oa̱á s'ín kisìko̱ koni s'ín mejèn‑la̱. K'oa̱á ti̱s'ín ko̱mat'ian 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱; tseé kjo̱'in tsjá‑na jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús k'e̱é kjòchi̱ya‑la̱ nga jè Jesús, k'e̱ nga tíchja̱ i̱t'aà ts'e̱ Elías, jè Juan xi kis'iìn bautizar xi̱ta̱ xi o̱tsò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","K'e̱ nga ijchò Jesús ñánda títsa̱jna xi̱ta̱ xi kjìn ma‑ne, jngoò xi̱ta̱ ijchò kasìt'aà‑la̱ nga tsasìxkó'nchit'aà‑la̱, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Na̱'èn, chahi̱ma̱i ki'ndí‑na̱. Ch'in biyaàxín tjín‑la̱. 'Ñó tse kjo̱'in síkjeiín. Jyeé kòkjìn k'a kaàjiìn ni'ín ko̱ nandá. ");
INSERT INTO maaNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","I̱í kòf'iìko̱‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑lè, ta̱nga mìkiì mandaà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús kitsò: ―Jñò xi̱ta̱ xi mìkiì mokjeiín‑nò i̱t'aà ts'a̱n xi ch'o 'nè. ¿Skanda mé na̱chrjein kóti̱jnako̱‑nò? ¿Skanda mé na̱chrjein ska̱‑na kjoa̱‑nò? Nchrohóko̱‑ná jè ti i̱jndé. ");
INSERT INTO maaNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesús tsohótiko̱ jè ini̱ma̱ ch'o‑la̱ nei̱í koa̱ itjokàjiìn‑ne yijo‑la̱ jè ti. Ti̱jè‑ne hora, ni̱to̱ón kjòndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kiskònanguit'aàxìn‑la̱. Kitsò‑la̱: ―¿Mé‑ne ngaje̱n mìkiì kòbitjojiìn‑na̱je̱n jè ini̱ma̱ ch'o‑la̱ nei̱í? ");
INSERT INTO maaNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús kitsò‑la̱: ―Mìkiì komà‑nò koi‑né nga tà chiba mokjeiín‑nò i̱t'aà ts'a̱n. O̱kixi̱í xi xan‑nò tsà ta o̱kji ko̱kjeiín‑nò koni kji xojmá mostaza nga i̱tsé kji, ko̱ma k'oín‑là nindoò: “Ti̱xín i̱jndé. T'in ján xijngoaà ñánda i̱t'aà xìn.” Koa̱ jè nindoò ko̱si̱t'aàxìn‑né. Jñò, ni̱mé kjoa̱ xi 'in ko̱ma‑nò tsà ndaà ko̱kjeiín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jñà ini̱ma̱ ch'o‑la̱ nei̱í xi o̱kjoàn, k'e̱é bitjokàjiìn nga nokjoàt'aà‑là Nainá ko̱ nga bijnachjaán. ");
INSERT INTO maaNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","K'e̱ nga ta̱ña ki̱tje̱n nga tjíma ya̱ i̱'nde Galilea, Jesús kitsò‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱: ―'A̱n, xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, ya̱á tso̱ba̱'ñó‑na jñà xi̱ta̱, ");
INSERT INTO maaNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","i̱kjoàn si̱ìk'en‑na. Ta̱nga k'e̱ nga ki̱jchò jàn na̱chrjein nga ki̱yá, kjoa̱áya‑na. Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ k'e̱ nga kiì'nchré 'én koi ta̱ ba ko̱ma‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","K'e̱ nga ijchò Jesús ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱ ján na̱xa̱ndá Capernaum, jñà xi̱ta̱ xi bíxkó to̱n ts'e̱ i̱ngo̱ ítjòn kiskònangui‑la̱ Pedro kitsò‑la̱: ―Jè Maestro‑lè, ¿a mìkiì bíchjí to̱n ts'e̱ i̱ngo̱? ");
INSERT INTO maaNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Jè Pedro kitsò: ―Jon, bíchjí‑né. K'e̱ nga jahas'en ni'ya Pedro, Jesús, jè kiìchja̱ ítjòn‑la̱, kitsò‑la̱: ―¿Kó si Simón, jè xi̱ta̱xá ítjòn xi i̱ i̱sò'nde ts'e̱, yá‑né xi síkíchjítjì tsojmì ko̱ to̱n‑sá? ¿A jñà‑né xi i̱ na̱xa̱ndá‑la̱, o xi jñá‑né xi xìn i̱'nde‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro kitsò: ―Jñà xi xìn i̱'nde‑la̱ xi bíchjí. K'e̱é kitsò‑la̱ Jesús: ―Jñà xi i̱ na̱xa̱ndá‑la̱ ni̱mé koi̱ìchjí. ");
INSERT INTO maaNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ta̱nga mé‑ne nga mì ch'o ki̱tso̱‑ná jñà xi̱ta̱, t'in ján i̱ndiì ndáchikon. Ti̱katje̱n‑jiìn ki̱cha̱ libá‑lè xi tsobà'ñó ti̱n, koa̱ jè ti̱n xi chjoé ítjoìn, chíx'ei̱ì tso'ba; ya̱ tjí'a jngoò to̱n. Ko̱maá‑ne nga kíchjí xi ts'a̱n ko̱ tsi̱ji. Tikoi̱i, tíchjí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jñà na̱chrjein koi jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús ijchòkon nga kiskònangui‑la̱; kitsò‑la̱: ―Jñà xi̱ta̱ xi jè otíxoma‑la̱ xi ngajmiì nchrobá‑ne, ¿yá‑ne xi tíjna ítjòn nga ìsa̱ 'ñó chjí‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús kiìchja̱ jngoò‑la̱ ndí ti. Kisìkasíjna jngoò osen‑la̱ jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kitsò: ―O̱kixi̱í xi xan‑nò, jñò, tsà mì kì si̱kjatjìya‑là kjo̱hítsjeèn‑nò ko̱ tsà mì kì k'oa̱s'ín s'e̱en koni jñà ndí i̱xti mìkiì ki̱tjás'e̱n‑jñoò ñánda tíhotíxoma jè xi ngajmiì nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jè xi síkjajen‑la̱ ini̱ma̱‑la̱ koni ndí ti jè, jè‑né xi tíjna ítjòn‑la̱ ngats'iì xi̱ta̱ xi jè tíhotíxoma‑la̱ xi ngajmiì nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ni̱ta̱ yá‑ne xi i̱t'aà ts'a̱n skoétjò jngoò ndí ti koni jè, 'a̱án xi skoétjò‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Ni̱ta̱ yá‑ne xi jé ski̱nìjiìn jngoò ndí xi̱ta̱ i̱ma̱ xi mokjeiín‑la̱ i̱t'aà ts'a̱n, ìsa̱á‑la ndaà ko̱ma tsà si̱ngui'ñó jngoò nda̱jo̱ natsí ís'iìn, i̱kjoàn si̱katje̱n‑jiìn ndáchikon ñánda nga 'ñó na̱nga̱ 'ncha nandá. ");
INSERT INTO maaNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","I̱ma̱ xó‑ne jñà xi̱ta̱ i̱sò'nde nga tjín jchán xi̱ta̱ xi ótsji'nde‑la̱ nga mejèn‑la̱ nga sakó jé. Ta̱nga xó k'oa̱á ko̱ma‑ne i̱sò'nde, ta̱nga i̱ma̱ xó‑nè jè xi̱ta̱ xi ótsji‑la̱ jé xi kj'ei̱í xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Tsà jè ndsa̱a ko̱ ndso̱koò ótsji jé‑nò, ti̱chátjòn koa̱ kjiìn ti̱katsjoò. Ìsa̱á ndaà‑nè tsà xkoán titsjoò nga ki̱tjás'e̱en ñánda s'e̱‑nò kjoa̱binachon, mì k'oa̱à‑ne tsà jò ma ndsa̱a ko̱ ndso̱koò koa̱ ján onguió i̱jiìn ni'ín ts'e̱ i̱'nde kjo̱'in ni̱ta̱ mé na̱chrjein‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tsà jè xkoòn ótsji jé‑nò, ti̱nachrjeè, kjiìn ti̱katsjoò. Ìsa̱á ndaà‑nè tsà jngoò ma xkoòn nga ki̱tjás'e̱en ñánda s'e̱‑nò kjoa̱binachon, mì k'oa̱á‑ne tsà jò ma xkoòn koa̱ ján onguió i̱jiìn ni'ín ts'e̱ i̱'nde kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Ni̱jngoò ndí xi̱ta̱ koi xi na̱chrjenguioò; k'oa̱á xán‑nò, ján ngajmiì, jñà àkja̱le̱‑la̱ xi̱ta̱ koi, ya̱á títsa̱jna kjit'aà nga nguixko̱n Na̱'èn‑na̱ xi tíjna ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ koií xá j'i̱‑na nga j'i̱ kàchrjekàjñaà kjo̱'in jñà xi̱ta̱ xi kichijà. ");
INSERT INTO maaNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Kó bixón? Tsà jngoò xi̱ta̱ xi jngoò sìndo̱ ma orrè‑la̱ koa̱ tsà si̱jchaya jngoò ján i̱jiìn ijñá, ¿a mìtsà si̱ìkítsa̱jna jñà xi ñijòn‑kaàn ko̱ chrj'oòn ñijòn ma nga kjoi̱ kátsji jè orrè xi kichijà jngoò? ");
INSERT INTO maaNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tsà ko̱tsji‑la̱, o̱kixi̱í xi xan‑nò, ìsa̱á tsja ko̱ma‑la̱ nei‑la̱ jè orrè xi jngoò ma, mì k'oa̱á‑ne jñà xi kjìn ma xi mì kì kichijà. ");
INSERT INTO maaNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","K'oa̱á s'ín mejèn‑la̱ Nainá xi tíjna ngajmiì nga ni̱jngoò xi̱ta̱ si̱ìchja ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Tsà jè 'ndsì ch'o tísíko̱‑lè, ti̱nókjoa̱‑la̱ k'e̱ nga tà jè ta̱jngoò tíjna; tìndaàjiìn‑koi̱i jè kjoa̱‑la̱; tsà kji̱'nchré‑lè, jyeé ndaà kichibà‑nò 'ndsì. ");
INSERT INTO maaNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ta̱nga tsà mìkiì kji̱'nchré‑lè, k'e̱é ti̱nókjoa̱‑la̱ tsà jngoò ko̱ tsà jò xi̱ta̱ mé‑ne nga kji̱'nchré yije‑ne 'én xi chibà koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá nga tsò: Mochjeén‑né tsà jò ko̱ tsà jàn xi̱ta̱ xi tsjá 'én nga ko̱ma si̱ndaàjiìn ni̱ta̱ mé kjoa̱‑ne mé‑ne nga chjí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tsà mìkiì 'nchréñijon‑la̱ jñà xi̱ta̱ koi, koa̱tìn‑la̱ xi̱ta̱ na̱xa̱ndá‑la̱ Nainá; koa̱ tsà mìkiì 'nchréñijon‑la̱ jñà xi̱ta̱ na̱xa̱ndá‑la̱ Nainá, tà k'oa̱s'ín jcha̱takoìn koni tsà jngoò xi̱ta̱ xi mìkiì beèxkon Nainá, koni tsà jngoò xi̱ta̱ xi tsojmì síkíchjítjì. ");
INSERT INTO maaNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’O̱kixi̱í xi xan‑nò, jñò, ngats'iì kjoa̱ xi koi̱'nde i̱ i̱sò'nde, ti̱koa̱á ján ngajmiì Nainá tsjá'nde‑né; koa̱ jñà kjoa̱ xi mìkiì koi̱'nde i̱ i̱sò'nde, ti̱koa̱á ján ngajmiì Nainá mìkiì tsjá'nde. ");
INSERT INTO maaNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ìjngoò k'a koa̱ xan‑nò: tsà jò ma‑nò i̱ i̱sò'nde xi tíjngoò takòn nga si̱jét'aà‑là Na̱'èn‑na xi tíjna ngajmiì ni̱ta̱ mé kjoa̱‑ne, tsjá‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ya̱ ñánda títsa̱jna jò jàn xi̱ta̱‑na̱ xi i̱t'aà ts'a̱n bixoña, ya̱á tìjna̱jiìn osen‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","K'e̱é kiì kasìt'aà chrañà‑la̱ jè Pedro, kiskònangui‑la̱ Jesús, kitsò‑la̱: ―Na̱'èn, ¿kó tjín k'a siìjchàat'aà‑la̱ xinguia̱a k'e̱ nga tsà ch'o tísíko̱‑na? ¿A skanda itoò k'a? ");
INSERT INTO maaNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús kitsò‑la̱: ―Mìtsà xan‑lè itoò k'a; xaán‑lè itoò k'a xi jàn‑kaàn ko̱ te. ");
INSERT INTO maaNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Koni s'ín otíxoma jè xi ngajmiì nchrobá‑ne, k'oa̱á s'ín tjín koni kis'iìn jngoò xi̱ta̱xá ítjòn xi kisìjé‑la̱ kinda̱ xi̱ta̱ chi̱'nda‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","K'e̱ nga tís'ín kinda̱ j'iì jngoò chi̱'nda‑la̱ xi 'ñó kjìn millón to̱n kitje̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chi̱'nda jè tsjìn‑la̱ to̱n xi koi̱ìchjí‑la̱. Jè nei‑la̱ kitsjaà o̱kixi̱ nga kàtasatíjna osen jè chá, ko̱ chjo̱ón‑la̱ ko̱ i̱xti‑la̱, ngats'iì tsojmì xi tjín‑la̱ mé‑ne nga ko̱chjí‑la̱ to̱n xi kitje̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Chi̱'nda jè tsasìxkó'nchit'aà‑la̱ jè nei‑la̱; tsibítsi'ba‑la̱, kitsò‑la̱: “Na̱'èn, tjín‑lè kjo̱ndaà, chíñakjoa̱‑ná; kíchjí yijeé‑lè ngats'iì xi kitje̱n‑na.” ");
INSERT INTO maaNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jè nei‑la̱ kjòhi̱ma̱keè chi̱'nda‑la̱, kisìjchàat'aà‑la̱ nga yije kinda̱ xi kitje̱n‑la̱ koa̱ kisìkíjnandei̱í‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ti̱k'e̱‑ne nga itjo ni'ya chi̱'nda jè, kisatiìkjoò jngoò chi̱'nda xíkjín xi ti̱koa̱ to̱n kitje̱n chiba‑la̱ xi ts'e̱. Kitsobà'ñó ís'iìn nga mejèn‑la̱ ki̱nchàjta̱‑la̱, kitsò‑la̱: “Tíchjí‑ná xi kitje̱n‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Koa̱ jè chi̱'nda xíkjín tsasìxkó'nchit'aà‑la̱, tsibítsi'ba‑la̱. Kitsò‑la̱: “Chíñakjoa̱‑ná, kíchjí yijeé‑lè xi kitje̱n‑na̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ta̱nga jè mìkiì kòkjeiín‑la̱. Ta̱ saà nda̱yá kiskinìs'en skanda k'e̱ nga koi̱ìchjí yije‑la̱ kóho̱tjín xi kitje̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","K'e̱ nga kijtseè jñà chi̱'nda xíkjín xi i'nga, baá ko̱ma‑la̱. K'e̱é kiì tsibéno̱jmí‑la̱ nei‑la̱ ngats'iì kjoa̱ xi komà. ");
INSERT INTO maaNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jè xi̱ta̱xá ítjòn xi nei‑la̱, k'e̱é kiskinìkjaá chi̱'nda jè, kitsò‑la̱: “Ji̱ chi̱'nda xi ch'o 'nì. 'A̱n kisìjchàat'aà‑lè ngayije xi kitje̱n‑lè k'e̱ nga tsibítsi'ba‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ti̱koa̱á ngaji̱ tjí'nde‑lè nga jcha̱hi̱ma̱chiì chi̱'nda xingui̱i koni s'ín kisìko̱‑lè nga kjòhi̱ma̱keè‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jè nei‑la̱ kjòjtií‑la̱, k'e̱é kitsjaà o̱kixi̱ nga kàt'iì‑la̱ kjo̱'in skanda k'e̱ nga koi̱ìchjí yije xi kitje̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús kitsò: ―Jñò k'oa̱á ti̱s'ín si̱ìko̱‑nò nga jngoò ìjngoò Na̱'èn‑na̱ xi tíjna ngajmiì tsà nga mì ko̱o ini̱ma̱‑nò si̱jchàat'aà‑là jé‑la̱ xinguio̱o. ");
INSERT INTO maaNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","K'e̱ nga jye kiìchja̱ Jesús, kiì‑ne ya̱ Galilea ján nangui Judea xi tíjna xijngoaà xa̱jngá nandá Jordán. ");
INSERT INTO maaNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","'Ñó kjìn xi̱ta̱ kiìtji̱ngui‑la̱ koa̱ ya̱á kisìndaà‑ne i̱'nde jè jñà xi̱ta̱ xi xk'én. ");
INSERT INTO maaNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ijchò i'nga xi̱ta̱ fariseo ya̱ ñánda tíjna Jesús nga mejèn‑la̱ skóna̱cha̱n‑la̱. I̱kjoàn kiskònangui‑la̱, kitsò‑la̱: ―¿A tjí'nde‑la̱ xi x'i̱n nga tsjiìn chjo̱ón‑la̱ xi ni̱ta̱ mé kjoa̱‑ne? ");
INSERT INTO maaNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús kitsò‑la̱: ―¿A kj'eè bìxke̱jñoò Xo̱jo̱n‑la̱ Nainá nga tsò: “Nainá, k'e̱ nga sa̱ tsibíndaà xi̱ta̱, tsibíndaà x'i̱n ko̱ chjo̱ón”? ");
INSERT INTO maaNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","K'oa̱á kitsò: “K'oa̱á ma‑ne nga jè x'i̱n si̱ìkíjna na̱'èn‑la̱ ko̱ nea̱‑la̱ nga kíjnako̱ chjo̱ón‑la̱. Ta jngoò xi̱ta̱ ko̱ma‑ne ingajò.” ");
INSERT INTO maaNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mìtsà ti̱ jò ma‑ne, tà jngoò ko̱ma‑ne. K'oi̱í kjoa̱‑la̱ nga mì yá xi̱ta̱ tjí'nde‑la̱ nga si̱ìtsjiìn‑ne xíkjín xi Nainá kisìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jñà xi̱ta̱ fariseo kiskònangui‑la̱ Jesús: ―¿Mé‑ne jè Moisés kitsjaà'nde‑ne nga tsò: xo̱jo̱n kàtasindaà nga ko̱ma tsjín xíkjín xi̱ta̱? ");
INSERT INTO maaNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús kitsò‑la̱: ―Koií‑né nga tájaàjiìn tjín ini̱ma̱‑nò, Moisés kitsjaà'nde‑nò nga kijnioò íchjín‑nò, ta̱nga k'e̱ nga sa̱ tàts'en‑la̱ kjoa̱, mì k'oa̱á s'ín tjín. ");
INSERT INTO maaNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","'A̱n k'oa̱á xán‑nò, jè x'i̱n xi tsjín‑ne chjo̱ón‑la̱, tsà mìtsà kjoa̱ chijngui tísíko̱, ko̱ tsà kj'ei̱í chjo̱ón ki̱xan‑ko̱, jyeé kjoa̱ chijngui tís'ín jè x'i̱n. Ti̱koa̱á tsà jè x'i̱n xi ki̱xan‑ko̱ jngoò chjo̱ón xi kitsjiìn x'i̱n‑la̱, ti̱koa̱á kjoa̱ chijngui tís'ín. ");
INSERT INTO maaNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kitsò: ―Tsà k'oa̱á s'ín 'iín tjín kjoa̱ ts'e̱ xi̱ta̱ xi bixan, ìsa̱á‑la ndaà s'e̱ tsà mì kì ki̱xan xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús kitsò‑la̱: ―Tjín xi̱ta̱ xi mìkiì mokjeiín‑la̱ kjo̱hítsjeèn jè; tà jñá xi̱ta̱ xi Nainá xó k'oa̱s'ín kitsjaà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tjín xi̱ta̱ xi mìkiì bixan nga xó k'oa̱s'ín kits'iìn‑ne nga mì íchjín si̱ìs'in‑la̱; ti̱koa̱á tjín xi̱ta̱ xi xi̱ta̱ xíkjín o̱kisìko̱ nga mì íchjín si̱ìs'in‑la̱; ti̱koa̱á tjín xi̱ta̱ xi mìkiì bixan nga k'oa̱s'ín tsibínè‑la̱ yijo‑la̱ nga mì íchjín si̱ìs'in‑la̱ nga mejèn‑la̱ si̱ìxá i̱t'aà ts'e̱ kjo̱tíxoma‑la̱ ngajmiì. Jñà xi̱ta̱ xi chíkjoa̱‑la̱ nga mokjeiín‑la̱ kjoa̱ koi, k'oa̱s'ín kàtasíkitasòn. ");
INSERT INTO maaNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jñà xi̱ta̱ j'iìko̱‑la̱ ndí i̱xti ñánda tíjna Jesús nga mejèn‑la̱ ko̱òt'aà‑la̱ tsja ko̱ ki̱ìtsi'batjì, ta̱nga jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús tsohótiko̱ jñà xi̱ta̱ xi j'iìko̱ ndí i̱xti. ");
INSERT INTO maaNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","K'e̱é kitsò Jesús: ―Tjiì'nde‑là jñà ndí i̱xti nga kàtjanchrobákon‑na. Kì binchahikon‑là. Jñà xi k'oa̱ s'ín tjín ini̱ma̱‑la̱ koni ts'e̱ ndí i̱xti, jyeé ts'e̱ ngats'iì kjo̱ndaà xi tjín ya̱ ñánda tíhotíxoma jè xi ngajmiì nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesús tsohósòn‑la̱ tsja jñà ndí i̱xti; i̱kjoàn kiì‑ne ya̱ i̱'nde jè. ");
INSERT INTO maaNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jngoò xi̱ta̱ ijchòkon Jesús, kiskònangui‑la̱, kitsò‑la̱: ―Maestro, ¿mé kjo̱ndaà xi s'iaàn nga s'e̱‑la̱ kjoa̱binachon ini̱ma̱‑na̱ ni̱ta̱ kjé‑ne? ");
INSERT INTO maaNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús kitsò‑la̱: ―¿Mé‑ne chjinangui‑ná i̱t'aà ts'e̱ kjoa̱ xi ndaà tjín? Mìtsà yá tjín xi ndaà xi̱ta̱, tà jngoò Nainá. Tsà mejèn‑lè nga s'e̱‑lè kjoa̱binachon ni̱ta̱ kjé‑ne, ti̱kitasoìn kjo̱tíxoma‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Xi̱ta̱ jè kiskònangui: ―¿Ñá‑la̱á kjo̱tíxoma‑ne? Jesús kitsò‑la̱: ―“Kì xi̱ta̱ nìk'in; kì kjoa̱ chijngui 'nì; kì chijé 'nì; kì 'én ndiso nokjoì i̱t'aà ts'e̱ xi̱ta̱ xi kj'ei̱í; ");
INSERT INTO maaNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","jcha̱xkoín na̱'èn‑lè ko̱ nea̱‑lè; ti̱tsjachi xi̱ta̱ xingui̱i koni tsà ti̱ yijo tsi̱ji‑ne.” ");
INSERT INTO maaNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","―Ngats'iì kjo̱tíxoma koi jyeé kisìkitasoàn ―kitsò jè ti―. ¿Mé xi chija ìsa̱‑na̱? ");
INSERT INTO maaNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús kitsò‑la̱: ―Tsà mejèn‑lè nga nguì kixi̱ ki̱jni, t'in, tatìjni yije tsojmì xi tjín‑lè. Jè to̱n‑lè ti̱ka'bí‑la̱ xi̱ta̱ i̱ma̱ mé‑ne nga s'e̱‑lè kjoa̱ machikon‑t'in ján ngajmiì. I̱kjoàn nchrobátji̱ngui‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Xi̱ta̱ jè, k'e̱ nga kiì'nchré 'én koi, tà baá komà‑la̱, koií kjoa̱‑la̱ nga 'ñó kjìn tsojmì tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","K'e̱é kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús: ―O̱kixi̱í xi xan‑nò. 'Ñó 'in ko̱ma‑la̱ jñà xi̱ta̱ nchi̱ná nga kjoa̱has'en‑jiìn ñánda tíhotíxoma jè xi ngajmiì nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nguì jngoò k'a ko̱xan‑nò, ìsa̱á mì 'in ko̱ma‑la̱ jngoò cho̱ camello nga kjoa̱has'en xko̱n nindoò xi tjahaña‑ne nikje, mì k'oa̱á‑ne koni jngoò xi̱ta̱ nchi̱ná xi 'ñó tjín‑la̱ tsojmì nga ko̱ma kjoa̱has'en‑jiìn ñánda tíhotíxoma jè xi ngajmiì nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","K'e̱ nga kiì'nchré 'én koi jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús tà kjòxkón‑la̱. K'e̱é kitsò: ―¿Yá‑né xi ki̱tjokàjiìn kjo̱'in kjoa̱ ts'e̱ jé‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús kiskoò'an, kitsò‑la̱: ―Jñà xi̱ta̱ mìkiì ko̱ma‑la̱ ko̱chrjekàjiìn kjo̱'in ini̱ma̱‑la̱. Ta̱nga xi Nainá ko̱maá‑la̱ ngats'iì kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","K'e̱é kitsò Pedro: ―Na̱'èn, ngaje̱n, jyeé kinìkítsa̱jna yije‑je̱n ngats'iì tsojmì xi tjín‑naje̱n, koa̱ ji̱ tjaàtji̱ngui‑lèje̱n. ¿Mé xi tjoé‑naje̱n? ");
INSERT INTO maaNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús kitsò‑la̱: ―Xi o̱kixi̱í xi xan‑nò, k'e̱ nga ki̱jchò na̱chrjein nga ko̱xi̱tse̱ya ìjngoò k'a i̱sò'nde, ko̱ 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, k'e̱ nga kóti̱jnasoàn íxi̱le̱ xi 'ñó jeya tíjna, jñò, xi jye 'a̱n tjaàtji̱ngui‑ná, ti̱koa̱á ya̱á ki̱tsa̱jnasòn íxi̱le̱ ts'e̱ kjo̱tíxoma xi tejò ma‑ne, nga jñò kíndaàjiìn‑là jñà xi̱ta̱ xi tejò tje̱‑la̱ ts'e̱ na̱xa̱ndá Israel. ");
INSERT INTO maaNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ngats'iì xi kjoa̱ ts'a̱n kisìkíjna ni'ya‑la̱, 'ndse̱, ndichja, na̱'èn‑la̱, nea̱‑la̱, chjo̱ón‑la̱, i̱xti‑la̱, nangui‑la̱, jngoò sìndo̱ k'a k'oa̱ tjín tjoé ìsa̱‑la̱. Ti̱koa̱á tjoé‑la̱ kjoa̱binachon ni̱ta̱ kjé‑nè. ");
INSERT INTO maaNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","I̱'ndei̱, kjìn xi̱ta̱ xi títsa̱jna ítjòn, k'e̱ nga ko̱ma i̱skan jñà kítsa̱jna tji̱ngui. Ko̱ xi títsa̱jna tji̱ngui i̱'ndei̱ k'e̱ nga ko̱ma i̱skan jñà kítsa̱jna ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Koni s'ín otíxoma jè xi ngajmiì nchrobá‑ne, k'oa̱á s'ín ngaya‑la̱ koni tsà jngoò xi̱ta̱ xi tjín‑la̱ nangui. Kiì nga ta̱jñòya nga kiì kátsji chi̱'nda xi si̱ìxáko̱ ñánda tjín‑la̱ toò uva. ");
INSERT INTO maaNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","K'e̱ nga jye tsibíndaàjiìn‑ko̱ nga koi̱ìchjí‑la̱ koni tjín síkijne xi̱ta̱ chi̱'nda nga jngoò na̱chrjein, i̱kjoàn kisìkasén ñánda kisìxá. ");
INSERT INTO maaNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ìjngoò k'a kiì jè nei‑la̱ xá koni xi ñijaàn‑la nga ta̱jñòya. Kijtseè ìsa̱ chi̱'nda xi tíyijòjiìn ndi̱tsi̱n xi tsjìn‑la̱ xá. ");
INSERT INTO maaNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kitsò‑la̱: “Tanguió ti̱xáko̱‑ná. 'A̱n kíchjí‑nò koni tjín machjí‑nò.” Kiì chi̱'nda koi nga kisìxá. ");
INSERT INTO maaNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jè nei‑la̱ xá, kiì ìjngoò k'a k'e̱ nga ijchò nchisen. Ti̱koa̱á kiì ìjngoò k'a k'e̱ nga ijchò xi jàn nga kjòhoxòn. ");
INSERT INTO maaNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jye‑la ijchò tsà xi 'òn nga kjòhoxòn, itjo ìjngoò k'a jè nei‑la̱ xá; koa̱ kisakò ìsa̱‑la̱ chi̱'nda xi tà jyò títsa̱jna. Kitsò‑la̱: “¿Mé‑ne tà jyò títsa̱jna‑nò kó nga kò'ba‑nò na̱chrjein nga mì nìxá‑nò?” ");
INSERT INTO maaNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Jñà chi̱'nda koi kitsò: “Koií‑né nga mì yá tsjá xá‑na̱je̱n.” K'e̱é kitsò‑la̱: “Tanguió ndaà tsà jñò; tanguí ti̱xá ján i̱jiìn tsojmì tjè‑na̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","K'e̱ nga jye kòjñò, jè nei‑la̱ xá kitsò‑la̱ jè xi̱ta̱ xi síkinda̱ chi̱'nda‑la̱: “Ti̱nókjoa̱‑là ngats'iì chi̱'nda. Tichjí‑la. Títs'ia̱ko̱‑ne jñà xi i̱skan kòfahas'en xá‑la̱; koa̱ jñà xi ítjòn kòfahas'en, ti̱kjehet'aà‑ne.” ");
INSERT INTO maaNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","K'e̱é kiìchja̱‑la̱ jñà chi̱'nda xi jahas'en xi 'òn nga kjòhoxòn; k'oa̱á tjín tsibíchjí‑la̱ koni tjín chjí‑la̱ nga jngoò na̱chrjein nga jngoò ìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","K'e̱ nga kjòchjí‑la̱ jñà chi̱'nda xi jahas'en ta̱jñòya, k'oa̱á komà‑la̱ tsà ìsa̱á tse ko̱chjí‑la̱. Ta̱nga tà ngásòn tjín kjòchjí‑la̱ koni tjín machjí‑la̱ nga jngoò na̱chrjein nga jngoò ìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","K'e̱ nga jye kjòchjí‑la̱ chi̱'nda koi i̱kjoàn tsibíts'ia̱ nga tsatít'aà jè nei‑la̱ xá. ");
INSERT INTO maaNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kitsò‑la̱: “Jñà chi̱'nda xi i̱skan kòbijchó, tà jngoò hora kàsíxá, koa̱ ngaje̱n kànìxá‑náje̱n nga kò'ba na̱chrjein koa̱ kànìkjeiín‑la̱je̱n ndobá nga kò'ba na̱chrjein. Tà ngásòn tjín tíbíchjí‑náje̱n.” ");
INSERT INTO maaNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ta̱nga jè nei‑la̱ xá kitsò jngoò‑la̱ jñà chi̱'nda: “Ji̱ amigo mìtsà mé xi ch'o tìsìko̱‑lè; k'oa̱á tjín tìbìchjí‑lè koni tjín chjí‑la̱ nga jngoò na̱chrjein nga k'oa̱á s'ín kàchibá. ");
INSERT INTO maaNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chjoí chjí‑lè koa̱ t'in‑ne. K'oa̱á s'ín mejèn‑na nga k'oa̱ ti̱ tjín tsjaà‑la̱ jè xi i̱skan kàsíxá koni tjín tìtsjaà‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nga ko̱ to̱n‑na̱, ¿a mì tjí'nde‑na nga k'oa̱s'ín s'iaàn koni s'ín mejèn‑na? ¿A maxìtakòn‑né nga 'a̱n ndaà xi̱ta̱?” ");
INSERT INTO maaNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesús kitsò ìsa̱: ―K'oa̱á s'ín ko̱ma jñà xi̱ta̱ xi títsa̱jna tji̱ngui na̱chrjein i̱'ndei̱, nga ko̱ma i̱skan, jñà kítsa̱jna ítjòn; koa̱ jñà xi títsa̱jna ítjòn i̱'ndei̱ nga ko̱ma i̱skan jñà kjoe̱het'aà‑ne. Kjìn ma‑ne xi xó chja̱‑la̱ Nainá ta̱nga chiba ma‑ne xi tjájiìn. ");
INSERT INTO maaNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús k'e̱ nga nchifì ján na̱xa̱ndá Jerusalén, kiìchja̱t'aàxìn‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ xi tejò ma‑ne, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―I̱'ndei̱ nga titsa̱honguiá na̱xa̱ndá Jerusalén, 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ ya̱á tsobà'ñó‑na xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés nga koi̱ì'nè‑na kjoa̱biyaà, ");
INSERT INTO maaNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","i̱kjoàn si̱ìnga̱tsja‑na jñà xi mìtsà xi̱ta̱ judío nga si̱ìsobà‑na, ko̱jà‑na, ko̱òt'aà‑na krò. Ta̱nga xi ko̱ma jàn na̱chrjein kjoa̱áya‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nea̱‑la̱ Jacobo ko̱ Juan i̱xti‑la̱ Zebedeo ijchòkon ñánda tíjna Jesús. Tji̱ko̱ i̱xti‑la̱. Tsasìxkó'nchit'aà‑la̱ Jesús nga kisìjé jngoò‑la̱ kjo̱ndaà. ");
INSERT INTO maaNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús kiskònangui‑la̱, kitsò‑la̱: ―¿Mé xi mejèn‑lè? Jè chjo̱ón kitsò: ―Ya̱ ñánda ko̱ti̱xomai, tjiì o̱kixi̱ nga ya̱ kàtiyijòt'aà‑lè i̱xti‑na̱. Jngoò kàtìjnakixi̱‑lè koa̱ jngoò kàtìjnat'aà‑lè xi ngaskón‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús kitsò‑la̱: ―Mìkiì 'yaà mé xi nìjé. ¿A ki̱chìkjoa̱á‑nò nga ko̱tojñoò jè kjo̱'in xi 'a̱n ko̱tojñaà? Xi̱ta̱ koi kitsò: ―Ki̱chìkjoa̱á‑na̱je̱n. ");
INSERT INTO maaNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","K'e̱é kitsò‑la̱ Jesús: ―O̱kixi̱‑né, k'oa̱á ti̱s'ín ko̱tojñoò kjo̱'in koni 'a̱n, ta̱nga xi 'a̱n tsjaà‑nò nga ya̱ ki̱tsa̱jnat'aà‑ná ya̱ kixi̱‑na̱ ko̱ ngaskón‑na̱ mìtsà 'a̱n oko̱‑na nga tsjaà‑nò. Jñà i̱'nde koi, jñà tjoé‑la̱ xi̱ta̱ xi Nainá títsa̱jnandaà‑la̱ nga tsjá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","K'e̱ nga kiì'nchré jñà xi̱ta̱‑la̱ Jesús xi i'nga xi te ma‑ne, kòjti‑la̱ i̱t'aà ts'e̱ xi̱ta̱ xi jò ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús kiìchja̱‑la̱, kitsò: ―Jyeé tíjiìn‑nò nga jñà xi̱ta̱ sko̱‑la̱ na̱xa̱ndá, nangui síkítsa̱jna xi̱ta̱‑la̱ xi jñà otíxoma‑la̱. Ti̱koa̱á jñà xi̱ta̱ xi 'nga xá tjín‑la̱, jñà xi beè nga otíxoma‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ta̱nga jñò mìkiì k'oa̱s'ín s'e̱en. Tsà jngoò xi̱ta̱ xinguio̱o mejèn‑la̱ 'nga kíjna, jè xi kàtasíxá‑la̱ xi̱ta̱ xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ko̱ jè xi mejèn‑la̱ kíjna ítjòn, chi̱'nda‑nò kàtama. ");
INSERT INTO maaNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, mìtsà koi xá j'i̱‑na nga 'a̱n ko̱s'in‑na, tà sa̱á 'a̱n siìxá‑la̱ xi̱ta̱ xi i'nga ko̱ tsjaà yijo‑na̱ nga ki̱yá mé‑ne nga kjìn xi̱ta̱ ki̱tjokàjiìn‑ne kjo̱'in xi kjoa̱ ts'e̱ jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","K'e̱ nga jye nchifì‑ne ya̱ na̱xa̱ndá Jericó, kjìn xi̱ta̱ kiìtji̱ngui‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ya̱ i̱ndiì ndi̱yá koni s'ín tífì Jesús, jò xi̱ta̱ xi mìkiì tsejèn‑la̱ títsa̱jna. K'e̱ nga kiì'nchré nga jè Jesús tífaya ndi̱yá, 'ñó kiìchja̱‑la̱ kitsò‑la̱: ―¡Na̱'èn, nga ya̱ nchrobàt'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David nga ji̱ tijna ngajo‑la̱ jcha̱hi̱ma̱takòn‑náje̱n! ");
INSERT INTO maaNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jñà xi̱ta̱ xi tji̱ko̱ Jesús tsohótiko̱‑ne nga jyò kàtìtsa̱jna, ta̱nga jñà xi̱ta̱ xi mìkiì tsejèn‑la̱, ìsa̱á 'ñó kiìchja̱, kitsò: ―¡Na̱'èn, xi tje̱‑la̱ David, jcha̱hi̱ma̱takòn‑náje̱n! ");
INSERT INTO maaNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","K'e̱é tsasíjna Jesús koa̱ kiìchja̱‑la̱, kiskònangui‑la̱, kitsò‑la̱: ―¿Mé xi mejèn‑nò nga si̱ìko̱‑nò? ");
INSERT INTO maaNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Jñà xi̱ta̱ koi, kitsò: ―Na̱'èn, mejèn‑naje̱n nga kàtatsejèn‑naje̱n. ");
INSERT INTO maaNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús kjòhi̱ma̱keè jñà xi̱ta̱ koi. Tsohót'aà‑la̱ tsja xko̱n koa̱ ni̱to̱ón kjòtsejèn‑la̱. I̱kjoàn kiìtji̱ngui‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","K'e̱ nga jye kjo̱meè bijchó chrañà‑la̱ na̱xa̱ndá Jerusalén ijchò jngoò na̱xa̱ndá xi 'mì Betfagé ya̱ chrañàt'aà‑la̱ nindoò Yá Olivo. Jesús kisìkasén jò xi̱ta̱ xi kota'yàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Kitsò‑la̱: ―Tanguió ján ndí na̱xa̱ndá i̱tsé xi kijnat'aà ján koa̱ ya̱ sakó jngoò‑nò orra̱ xi tjít'aà'ñó ko̱ ndí búrró ki'ndí‑la̱. Chíjnda̱'ñó koa̱ nchrohóko̱‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tsà yá xi kó ki̱tso̱‑nò, ko̱t'ìn‑là: “Jè xó Na̱'èn‑ná ko̱chjeén‑la̱ koa̱ ni̱to̱ón xó si̱ìkasén‑ne.” ");
INSERT INTO maaNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","K'oa̱á s'ín komà mé‑ne nga tsitasòn‑ne koni s'ín kiskiì xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, nga tsò: ");
INSERT INTO maaNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ko̱t'ìn‑la̱ na̱xa̱ndá Sión: “Chítsejèn‑là Xi̱ta̱ Ítjòn‑lè; nga ji̱í nchrobá katsejèn‑lè; i̱ma̱á kji; tínasòn jngoò‑la̱ búrró, jngoò ndí búrró i̱tsé xi ki'ndí‑la̱ cho̱ ch'á.” ");
INSERT INTO maaNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kiì jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, k'oa̱s'ín kisìkitasòn koni s'ín kisatiìxá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","K'e̱ nga ijchòko̱ ñánda tíjna Jesús jè orra̱ ko̱ ki'ndí‑la̱, jñà kisìkjeén nikje‑la̱ nga tsohójtsa‑la̱; i̱kjoàn tsibìjnasòn‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Koa̱ jñà xi̱ta̱ xi kjìn ma‑ne tsohójngoò nikje‑la̱ ya̱ i̱ya ndi̱yá. Tjín i'nga xi chrja‑la̱ yá tsate, i̱kjoàn tsohójngoò i̱ya ndi̱yá. ");
INSERT INTO maaNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jñà xi̱ta̱ xi tjíma ítjòn‑la̱ ko̱ xi tji̱ngui‑la̱ tsibíts'ia̱ nga 'ñó kiìchja̱, kitsò: ―¡Jeya kàtìjna jè xi ya̱ nchrobát'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David nga jè kíjna ngajo‑la̱! ¡Mé ta ndaà‑la̱ jè xi nchrobá ngajo‑la̱ Na̱'èn‑ná! ¡Jeya choòn ján ngajmiì! ");
INSERT INTO maaNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","K'e̱ nga jahas'en Jesús ya̱ na̱xa̱ndá Jerusalén ngats'iì xi̱ta̱ na̱xa̱ndá tà kjòxkón‑la̱, koa̱ kiskònangui‑la̱ xíkjín. Kitsò: ―¿Yá xi̱ta̱‑ne jè? ");
INSERT INTO maaNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jñà xi̱ta̱ xi kjìn ma‑ne kitsò: ―Jè xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá xi Jesús 'mì xi Nazaret ts'e̱, ya̱ nangui Galilea. ");
INSERT INTO maaNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús jahas'en ya̱ ndi̱tsin i̱ngo̱ ítjòn‑la̱ Nainá, tsachrje yije ngats'iì xi̱ta̱ xi ya̱ nchihotíjna ko̱ nchihotse tsojmì ya̱ ndi̱tsin i̱ngo̱. Kisìhitíkjá ími̱xa̱‑la̱ jñà xi̱ta̱ xi síkjatjìya to̱n ko̱ ti̱koa̱á kisìkatsjoò íxi̱le̱‑la̱ jñà xi otíjna ni̱se paloma. ");
INSERT INTO maaNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kitsò‑la̱: ―Jè Xo̱jo̱n‑la̱ Nainá tsò‑né: “Ni'ya‑na̱, ni'ya‑la̱ o̱chikoón k'oín.” Ta̱nga jñò, nguijo‑la̱ xi̱ta̱ chijé titsa̱'nè. ");
INSERT INTO maaNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nga ya̱ i̱ngo̱ ítjòn tíjna Jesús, ijchò kinchat'aà‑la̱ xi̱ta̱ xi mìkiì tsejèn‑la̱ ko̱ xi tsá'yá kjoàn; jè Jesús kisìndaà‑ne xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés kòkjan‑la̱ k'e̱ nga kijtseè kjo̱xkón xi kis'iìn Jesús ko̱ nga kiì'nchré 'én‑la̱ jñà ndí i̱xti xi chja̱ya i̱ya i̱ngo̱ ítjòn, nga tsò: “¡Jeya kàtìjna jè xi ya̱ nchrobát'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David nga jè kíjna ngajo‑la̱!” ");
INSERT INTO maaNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","K'e̱é kiìchja̱ xi̱ta̱ koi, kitsò‑la̱ Jesús: ―¿A na'yà‑né? ¿A ndaà tsò 'én xi chja̱ jñà i̱xti koi? Jesús kitsò: ―Jon, 'nchré‑ná. ¿A kj'eè bìxke̱jñoò Xo̱jo̱n‑la̱ Nainá nga tsò?: Jñà ndí i̱xti xi jtobá kjoàn ko̱ ki'ndí xi sa̱ oki, jñà‑né xi títsa̱jnandaà nga jeya si̱ìkíjna Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesús ya̱á kisìkítsa̱jna jñà xi̱ta̱ koi, itjojiìn‑ne ya̱ na̱xa̱ndá ítjòn Jerusalén. Kiì ján na̱xa̱ndá Betania. Ya̱á kisìkjáya nga ni̱tje̱n. ");
INSERT INTO maaNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","K'e̱ nga ta̱jñòya nga tífì‑ne Jerusalén, Jesús, kjòhojò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kijtseè jngoò yá‑la̱ toò iko̱ xi ya̱ chrañà i̱ndiì ndi̱yá síjna. Kiì katsejèn‑la̱ ta̱nga ni̱mé toò yijà‑la̱. Tà xka̱á tjín‑la̱. K'e̱é kitsò‑la̱ Jesús: ―Ni̱ ti̱ jngoò na̱chrjein ko̱ja̱‑lè toò. Koa̱ jè yá toò iko̱ ni̱to̱ón kixì. ");
INSERT INTO maaNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","K'e̱ nga kijtseè jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, tà kjòxkón‑la̱. K'e̱é kiskònangui‑la̱ mé‑ne nga tà ni̱to̱n kixì‑ne jè yá‑la̱ toò iko̱. ");
INSERT INTO maaNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús kitsò‑la̱: ―Xi o̱kixi̱, tsà ndaà mokjeiín‑nò i̱t'aà ts'a̱n, tsà mì jò tjín‑la̱ ini̱ma̱‑nò, ko̱maá‑nò nga k'oa̱s'ín s'e̱én koni s'ín kàsìkoa̱a jè yá iko̱; ti̱koa̱á ko̱maá‑nò k'oín‑là jè nindoò: “Ti̱si̱xìn; ján ti̱katje̱n‑jiìn yijo‑lè ndáchikon.” Ko̱ k'oa̱á s'ín ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jñò, tsà ndaà mokjeiín‑nò ni̱ta̱ mé xi si̱jé k'e̱ nga kítsi'ba, k'oa̱á s'ín tjoé‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","K'e̱ nga jye komà kjoa̱ koi, Jesús jahas'en ya̱ ndi̱tsin i̱ngo̱ ítjòn ko̱ k'e̱ nga tíhokóya‑la̱ xi̱ta̱ ijchòkon jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ jchínga‑la̱ jñà xi̱ta̱ judío. Kiskònangui‑la̱: ―¿Mé kjo̱tíxoma xi tsjá'nde‑lè koni s'ín 'nì? ¿Yá xi kitsjaà‑lè kjo̱tíxoma koi? ");
INSERT INTO maaNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús kitsò‑la̱: ―Ti̱koa̱á 'a̱n skònangui jngoò‑nò kjoa̱. Jñò, tsà ko̱k'oín‑ná, ti̱koa̱á 'a̱n k'oa̱á xán‑nò yá xi kitsjaà‑na̱ kjo̱tíxoma koni s'ín s'iaàn. ");
INSERT INTO maaNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jè Juan, k'e̱ nga kis'iìn bautizar xi̱ta̱, ¿yá xi kitsjaà‑la̱ kjo̱tíxoma? ¿A Nainá‑né xi tíjna ngajmiì, o xi tà xi̱ta̱‑né? Jñà xi̱ta̱ koi k'e̱é tsajoóya‑ne. Kitsò‑la̱ xíkjín: ―Tsà kixoán: “Nainá kitsjaà‑la̱ kjo̱tíxoma”, ki̱tso̱‑ná: “¿Mé‑ne mìkiì kòkjeiín‑nò i̱t'aà ts'e̱?” ");
INSERT INTO maaNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Koa̱ tsà kixoán: “I̱t'aà ts'e̱ xi̱ta̱‑né”, tsakjoòn‑ná tsà koi na̱chrjein‑la̱ jñá xi̱ta̱ na̱xa̱ndá ska̱àn‑ko̱‑ná, nga ngats'iì, nguì k'oa̱á tsò nga jè Juan, jngoò xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","K'e̱é kiìchja̱, kitsò‑la̱ Jesús: ―Mì kì 'ya‑je̱n. Koa̱ jè Jesús kitsò‑la̱: ―Ti̱koa̱á 'a̱n mìkiì k'oa̱ xán‑nò yá xi kitsjaà‑na kjo̱tíxoma koni s'ín s'iaàn. ");
INSERT INTO maaNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús kiskònangui‑la̱, kitsò‑la̱: ―¿Jñò, kó bixón? Jngoò xi̱ta̱ xi jò ma i̱xti x'i̱n‑la̱ kitsò jngoò k'a‑la̱ jngoò ti‑la̱: “Na̱'èn, t'in, ti̱xá‑la̱ jè toò uva‑na̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ti jè kitsò: “Majìn‑na.” Ta̱nga ko̱ma i̱skan, kisìkítsjeèn; k'e̱é kiì síxá. ");
INSERT INTO maaNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Na̱'èn‑la̱ k'e̱é kiì nga kiìkon ti xi ìjngoò. K'oa̱á ti̱ kitsò‑la̱. Ta̱nga ti jè, kitsò: “Ndaà tjín na̱'èn, ko̱maá kjián.” Ta̱nga mìkiì kiì. ");
INSERT INTO maaNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ñá‑la̱á nga ingajò i̱xti xi kisìkitasòn‑la̱ na̱'èn‑la̱? Jñà xi̱ta̱ kitsò: ―Jè xi ítjòn. K'e̱é kitsò‑la̱ Jesús: ―O̱kixi̱í xi xan‑nò, jñà xi̱ta̱ xi síkíchjítjì tsojmì ts'e̱ Roma ko̱ jñà íchjín ská, ìsa̱á ni̱to̱n kjoa̱has'en ñánda nga Nainá tíhotíxoma mì k'oa̱á‑ne koni jñò. ");
INSERT INTO maaNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nga jè Juan xi kis'iìn bautizar xi̱ta̱ k'oi̱í xá j'iì‑ne nga tsakóya‑la̱ xi̱ta̱ kós'ín si̱ìjchá yijo‑la̱, ta̱nga jñò mìkiì kòkjeiín‑nò. Koa̱ jñà xi síkíchjítjì tsojmì ko̱ jñà íchjín ská kòkjeiín‑la̱. Ta̱nga jñò ndaà na̱s'ín ki'yaà yije kjoa̱ koi, mìkiì kinìkájno jé‑nò ko̱ mìkiì kòkjeiín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Ti̱ná'yaà ìjngoò‑là kjoa̱ xi mangásòn. Jngoò xi̱ta̱ xi tjín‑la̱ nangui, tsibítje̱ toò uva ko̱ tsibíndiì‑la̱ ínchíbá, i̱kjoàn tsibíndaà jngoò i̱'nde ñánda tsi'ñóngui nandá‑la̱ toò uva. Ti̱koa̱ tsibíndaà jngoò torre ñánda bìtsa̱jna xi̱ta̱ nga síkinda̱ yije kóho̱tjín. I̱kjoàn kisìkìña‑la̱ nangui‑la̱ xi̱ta̱ xi kj'ei̱í nga kisìxásòn. I̱kjoàn kiì nei‑la̱ nangui ñánda i̱'nde kjiìn. ");
INSERT INTO maaNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","K'e̱ nga ijchò na̱chrjein‑la̱ nga jye kòjchá toò uva, jè nei‑la̱ nangui kisìkasén xi̱ta̱ chi̱'nda‑la̱ nga kisìjé‑la̱ xi jè oko̱‑la̱ ts'e̱ toò uva xi kòjchá. ");
INSERT INTO maaNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ta̱nga jñà xi̱ta̱ xi kisìxásòn nangui kitsobà'ñó xi̱ta̱‑la̱ jè nei‑la̱ nangui. Jngoò xi tsi'beé‑la̱ ko̱ jngoò xi kisìk'en koa̱ jè xi ìjngoò nda̱jo̱ tsibínè. ");
INSERT INTO maaNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","K'e̱ komà i̱skan jè nei‑la̱ nangui ìsa̱á kjìn xi̱ta̱‑la̱ kisìkasén ta̱nga jñà xi̱ta̱ xi síxásòn nangui ta ngásòn kisìko̱ ngats'iì chi̱'nda xi j'iì. ");
INSERT INTO maaNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’K'e̱ nga jyehet'aà‑ne kisìkasén ki'ndí‑la̱. Kisìkítsjeèn kitsò: “Skoe̱xkón‑la̱ ki'ndí‑na̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Jñà xi̱ta̱ xi síxásòn nangui k'e̱ nga kijtseè jè ki'ndí‑la̱ nei‑la̱ nangui tsajoóya‑ne, kitsò‑la̱ xíkjín: “Jè jèe̱ xi tjoé kjo̱tjò‑la̱ i̱'nde, si̱k'eén ko̱ tsa̱ján ko̱ma i̱'nde.” ");
INSERT INTO maaNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kitsobà'ñó, tsachrjejiìn ya̱ nangui ñánda títje̱ toò uva. I̱kjoàn kisìk'en. ");
INSERT INTO maaNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Jñò, ¿kó bixón? K'e̱ nga kjoi̱í nei‑la̱ nangui, ¿mé xi si̱ìko̱ jñà xi̱ta̱ xi kisìxásòn nangui‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jñà xi̱ta̱ xi nchi'nchré kitsò: ―Jngoò k'aá si̱ìk'en jñà xi̱ta̱ ts'e̱n; mìkiì ko̱hi̱ma̱keè. Ko̱ jè nangui‑la̱, kj'ei̱í xi̱ta̱ si̱ìkìña‑la̱ xi koi̱ìchjí kó kji oko̱‑la̱ k'e̱ nga ko̱jchá toò uva. ");
INSERT INTO maaNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús kitsò‑la̱: ―¿A kj'eè bìxke̱jñoò Xo̱jo̱n‑la̱ Nainá nga tsò?: Jè nda̱jo̱ xi tsachrjekàngui chji̱ne̱chrjó nga sa̱ ítjòn, jè‑né xi komà nda̱jo̱ tàts'en chrjó‑la̱ ni'ya. K'oa̱á s'ín kis'iìn Nainá. Jñá, tà maxkón‑ná k'e̱ nga 'yaá kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","K'oi̱í ko̱xan‑nò jñò, tjáxìn‑nò kjoa̱ machikon‑t'in nga jè Nainá tíhotíxoma‑nò. Jñá tjoé‑la̱ xi̱ta̱ xi k'oa̱s'ín síxá koni s'ín ok'ìn‑la̱ xá‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Xi i̱t'aà ts'e̱ nda̱jo̱, ni̱ta̱ yá‑ne xi ki̱xo̱sòn nda̱jo̱ jè, ko̱xkoa̱ya‑né; ko̱ tsà jè nda̱jo̱ ska̱nè xi̱ta̱, ko̱chijo‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ fariseo, k'e̱ nga kiì'nchré koni s'ín kiìchja̱ Jesús nga tsibéno̱jmí 'én xi mangásòn, k'e̱é kjòchi̱ya‑la̱ nga i̱t'aà ts'e̱‑né koni s'ín kiìchja̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ti̱k'e̱é‑ne mejèn kitsobà'ñó Jesús ta̱nga jñá kitsakjòn‑la̱ xi̱ta̱ na̱xa̱ndá, koi‑né nga k'oa̱á s'ín mokjeiín‑la̱ jñà xi̱ta̱ nga jè Jesús, jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús tsibíts'ia̱ ìjngoò k'a nga tsakóya‑la̱ xi̱ta̱ kjoa̱ xi mangásòn. Kitsò: ");
INSERT INTO maaNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Koni s'ín otíxoma jè xi ngajmiì nchrobá‑ne, k'oa̱á s'ín mangásòn koni jngoò xi̱ta̱xá ítjòn xi tsibíjna jngoò s'eí k'e̱ nga chixàn ti‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kisìkasén chi̱'nda‑la̱ mé‑ne nga kiì kíchja̱‑la̱ ngats'iì xi̱ta̱ xi xó kinokjoá‑la̱ nga ti‑la̱ tíbixan. Ta̱nga jñà xi̱ta̱ koi, mìkiì kòkjeiín‑la̱ nga kiì s'eí. ");
INSERT INTO maaNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ìjngoò k'a kisìkasén chi̱'nda‑la̱ xi kj'ei̱í. Kitsò‑la̱: “Ko̱t'ìn‑là jñá xi̱ta̱ xi jye kiì'nchré: Tsojmì xi ski̱ne̱, jyeé tjíndaà; jyeé kisìk'en nchra̱ja̱‑na̱, cho̱ xi 'ñó xiné. Jyeé tjíndaà yije kóho̱tjín. Kàtjanchrobá s'eí.” ");
INSERT INTO maaNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ta̱nga jñà xi̱ta̱ koi mìkiì kisìs'in. Tjín xi rancho̱‑la̱ kiì‑katsejèn‑la̱; tjín xi kjo̱hi̱ma̱‑la̱ kiì. ");
INSERT INTO maaNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Koa̱ jñà xi̱ta̱ xi i'nga, kitsobà'ñó chi̱'nda‑la̱ jè xi̱ta̱xá ítjòn. Kiskaàn‑ko̱ koa̱ kisìk'en. ");
INSERT INTO maaNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jè xi̱ta̱xá ítjòn, 'ñó kòjti‑la̱. K'e̱é kisìkasén xi̱ta̱ soldado nga kisìk'en yije kóho̱tjín jñà xi̱ta̱ koi nga ma‑la̱ sík'en‑ná, koa̱ tsaká na̱xa̱ndá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jè xi̱ta̱xá ítjòn, ìjngoò k'a kitsò‑la̱ chi̱'nda‑la̱: “Kixi̱í kjoa̱, jyeé tjíndaà yije xi kjoa̱ ts'e̱ s'eí, ta̱nga jñà xi̱ta̱ xi jye kiì'nchré, mìkiì mochjeén‑la̱ nga i̱ kjoi̱í. ");
INSERT INTO maaNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tanguió ìjngoò k'a ya̱ ndi̱yá jngoò osen‑la̱ na̱xa̱ndá, ti̱nókjoa̱‑là xi̱ta̱ ni̱ta̱ yá‑ne xi ska̱jñoò nga s'eí tjín kjoa̱ ts'e̱ xi̱ta̱ xi bixan.” ");
INSERT INTO maaNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jñà chi̱'nda‑la̱ xi̱ta̱xá ítjòn kiì kíxkóya xi̱ta̱ i̱nchò calle ni̱ta̱ yá xi kjòtsja‑la̱ nga kiì s'eí, xi̱ta̱ xi ndaà ko̱ xi mìkiì ndaà; k'oa̱á s'ín kitseè ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Jè xi̱ta̱xá ítjòn, k'e̱ nga jahas'en ni'ya, kiskoòtsejèn‑la̱ jñà xi̱ta̱ xi ijchò. K'e̱é kijtseè jngoò xi̱ta̱ xi ya̱ tíjnajiìn nga mìkiì íkjá nikje‑la̱ xi ts'e̱ kjoa̱ bixan. ");
INSERT INTO maaNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kitsò‑la̱: “Ji̱, amigo, ¿kó s'ín komà nga kòbitjaàs'i̱in i̱jndé nga mìkiì kichíkjeí nikje xi ts'e̱ s'eí?” Ta̱nga xi̱ta̱ jè, tà jyò tsibìjna. ");
INSERT INTO maaNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jè xi̱ta̱xá ítjòn kitsò‑la̱ jñà xi̱ta̱ xi nchisís'in‑la̱ ími̱xa̱: “Tit'aà'ñó ndso̱ko̱ ko̱ tsja. I̱kjoàn ti̱katje̱en ján i̱jiìn jñò ya̱ ñánda nga ski̱ndàya ko̱ si̱ìjts'iìn ni̱'ño̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kitsò‑ìsa Jesús: ―K'oa̱á s'ín ko̱ma nga kjìn ma‑ne xi̱ta̱ xi nokjoà‑la̱ ta̱nga tà chibaá ma‑ne xi tjájiìn. ");
INSERT INTO maaNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jñà xi̱ta̱ fariseo k'e̱é kiì tsajoóya‑ne nga mejèn‑la̱ ko̱hòngui Jesús mé 'én xi ki̱chja̱. ");
INSERT INTO maaNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Koií kjoa̱‑la̱ nga kisìkasén‑la̱ Jesús xi̱ta̱‑la̱ ko̱ xi̱ta̱‑la̱ Herodes; kiskònangui‑la̱, kitsò‑la̱: ―Maestro, 'ya‑náje̱n nga 'én kixi̱í xi nokjoì koa̱ k'oa̱á s'ín okoòyi ndi̱yá‑la̱ Nainá koni s'ín tjín xi kjoa̱ kixi̱. Mìkiì 'nì kinda̱ koni tsò‑lè xi̱ta̱; ko̱ mìtsà jè chìtsejèn‑jnoi kó kjoàn xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Koa̱tìn‑náje̱n. ¿A ndaà tjín nga kíchjítjì‑je̱n tsojmì i̱t'aà ts'e̱ xi̱ta̱xá ítjòn ts'e̱ Roma, a xi majìn‑né? ");
INSERT INTO maaNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús kjòchi̱ya‑la̱ nga ch'o nchisíkítsjeèn. K'e̱é kitsò‑la̱: ―Jñò, xi̱ta̱ xi jò i̱sén tjín‑nò, mé‑ne chona̱cha̱n‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ta̱kó‑ná jè to̱n xi machjítjì‑ne tsojmì. K'e̱é j'iìko̱ jngoò‑la̱ to̱n denario. ");
INSERT INTO maaNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","K'e̱ nga kijtseè Jesús, kiskònangui‑la̱, kitsò‑la̱: ―¿Yá ts'e̱ i̱sén jè ko̱ jè 'ín xi tjít'aà? ");
INSERT INTO maaNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kitsò xi̱ta̱ koi: ―Ts'e̱é César, xi̱ta̱xá ítjòn ts'e̱ Roma. K'e̱é kitsò‑la̱ Jesús: ―Tjiì‑lá César xi ts'e̱ César koa̱ tjiì‑lá Nainá xi ts'e̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","K'e̱ nga kiì'nchré 'én koi jñà xi̱ta̱ fariseo ko̱ xi̱ta̱‑la̱ Herodes, tà kjòxkón‑la̱. Kitsjiìn Jesús, i̱kjoàn kiì‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ti̱koi‑ne na̱chrjein ijchòkon Jesús jñà xi̱ta̱ saduceo nga mìkiì mokjeiín‑la̱ nga faáya‑la̱ jñà xi̱ta̱ xi jye k'en. Xi̱ta̱ koi kiskònangui‑la̱ Jesús, ");
INSERT INTO maaNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","kitsò‑la̱: ―Maestro, Moisés kitsò‑né: “Tsà jngoò xi̱ta̱ x'i̱n ki̱yá xi mìkiì kis'e‑la̱ i̱xti ko̱ chjo̱ón‑la̱, jè 'ndse̱ mik'en ki̱xan‑ko̱ ìjngoò k'a chjo̱ón‑la̱ 'ndse̱ nga s'e̱‑la̱ i̱xti xi tje̱ ts'e̱ 'ndse̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kis'e xó jngoò k'a xi̱ta̱ i̱jndé xi itoò komà 'ndse̱. Jè xi síjna ítjòn chixàn, ta̱nga k'e̱ nga k'en, mìkiì kis'e‑la̱ i̱xti koa̱ jè 'ndse̱ xi ma jò‑ne tsibìjnako̱ jè chjo̱ón ka'àn. ");
INSERT INTO maaNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","K'oa̱á ti̱ komàt'in jè 'ndse̱ xi ma jò‑ne ko̱ xi ma jàn‑ne skanda komà itoò. Ni̱jngoò xi kis'e‑la̱ i̱xti. ");
INSERT INTO maaNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Xi jyehet'aà‑ne, k'en jè chjo̱ón. ");
INSERT INTO maaNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","K'e̱ nga tsà kjoa̱áya ìjngoò k'a‑la̱ mik'en, ¿ñá‑la̱á nga itoò 'ndse̱ xi ko̱ma chjo̱ón‑la̱? Nga jñà chixàn‑ko̱ nga itoò. ");
INSERT INTO maaNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","K'e̱é kitsò‑la̱ Jesús: ―Jñò, maskáya‑nò koi‑né nga mìkiì 'yaà kó s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá ko̱ nga'ñó xi tjín‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","K'e̱ nga kjoa̱áya ìjngoò k'a‑la̱ mik'en, íchjín, íchjá, mì ti̱ kiì ki̱xan‑ne. K'oa̱á s'ín s'e̱ koni jñà àkja̱le̱ xi títsa̱jna ngajmiì xi ts'e̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Jè kjoa̱ nga faáya ìjngoò k'a‑la̱ mik'en, ¿a kj'eè bìxke̱jñoò Xo̱jo̱n‑la̱ Nainá nga jè sobà Nainá xi kitsò: ");
INSERT INTO maaNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“'A̱n‑ná xi Nainá tsò‑na Abraham, Isaac ko̱ Jacob”? ¡Jñà xi jye k'en, mìtsà Nainá tsò‑la̱ xi Nainá; tà jñà xi títsa̱jnakon xi Nainá tsò‑la̱! Nga̱ i̱t'aà ts'e̱ Nainá, títsa̱jnakon xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jñà xi̱ta̱ na̱xa̱ndá, k'e̱ nga kiì'nchré 'én koi, tà kjòxkón‑la̱ koni s'ín tsakóya Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jñà xi̱ta̱ fariseo k'e̱ nga kiì'nchré nga Jesús kisìkítsa̱jnajyò jñà xi̱ta̱ saduceo, tsibíxkóya xíkjín. ");
INSERT INTO maaNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jngoò xi xi̱ta̱ ts'e̱, xi chji̱ne̱ xo̱jo̱n‑la̱ kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, mejèn‑la̱ skót'aà Jesús nga skóna̱cha̱n‑la̱. Kiskònangui‑la̱, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿ñá‑la̱á kjo̱tíxoma xi ìsa̱ tíjna ítjòn nga yije kjo̱tíxoma ts'e̱ Moisés? ");
INSERT INTO maaNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús kitsò‑la̱: ―“Ti̱tsjachi Na̱'èn‑ná xi Nainá 'mì‑la̱, nga ko̱ ini̱ma̱‑lè ko̱ kjo̱hítsjeèn‑lè ko̱ nga tijnakoin.” ");
INSERT INTO maaNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jè kjo̱tíxoma xi ìsa̱ 'ñó tjín ko̱ xi tíjna ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jè xi ma‑ne jò, k'oa̱á ti̱ tsò‑ne: “Ti̱tsjachi xi̱ta̱ xingui̱i xi i'nga koni tsà ti̱ yijo tsi̱ji‑nè.” ");
INSERT INTO maaNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jñà títsa̱jna ítjòn jñà kjo̱tíxoma koi. Ya̱á bitjokàt'aà kóho̱tjín kjo̱tíxoma xi i'nga xi ts'e̱ Moisés ko̱ xi ts'e̱ xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tà kó ya̱á títsa̱jna jñà xi̱ta̱ fariseo. Jesús kiskònangui‑la̱, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Jñò, kó bixón i̱t'aà ts'e̱ Cristo jè xi̱ta̱ xi xó si̱ìkasén‑ne Nainá? ¿Ñánda kitje̱n‑la̱? Jñà xi̱ta̱ fariseo kitsò: ―Ya̱á kji̱nchrobàt'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David nga jè kíjna ngajo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","K'e̱é kitsò Jesús: ―Ta̱nga jè David k'e̱ nga kiìchja̱ nga ko̱ nga'ñó‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá, kitsò i̱t'aà ts'e̱ Cristo: “Jè otíxoma‑na.” K'oa̱á s'ín kiìchja̱ David: ");
INSERT INTO maaNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Jè Nainá kitsò‑la̱ jè xi otíxoma‑na: “Ti̱jnat'aà‑ná i̱ kixi̱‑na̱ skanda k'e̱ nga sìkítsa̱jnanguia ndso̱koiì jñà xi kondra̱‑lè nga 'a̱n jye kisìkijne‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Jè David, tsà ko̱s'ín kitsò‑la̱ Cristo jè xi̱ta̱ xi xó síkasén‑ne Nainá, ¿kó s'ín tjín‑ne nga ya̱ nchrobát'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David? ");
INSERT INTO maaNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ni̱jngoò xi ko̱ma‑la̱ nga kisìkátji‑ne 'én koi. Tje̱n‑ne na̱chrjein koi, mì ti̱ yá xi kjò'ñó‑ne ikon nga kiskònangui ìsa̱‑la̱ 'én xi kj'ei̱í. ");
INSERT INTO maaNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Xi komà i̱skan kitsò‑la̱ Jesús jñà xi̱ta̱ xi kjìn ma‑ne ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Jñà xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés ko̱ jñà xi̱ta̱ fariseo tjín‑la̱ xá nga okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. ");
INSERT INTO maaNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ti̱ná'yaà yije‑là koni s'ín okóya‑nò. Ta̱nga mìkiì k'oa̱ 'nè koni s'ín jñà xi̱ta̱ koi. Kj'ei̱í tsò ko̱ kj'ei̱í s'ín. ");
INSERT INTO maaNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Jñà xi̱ta̱ koi bínè‑la̱ xi̱ta̱ xi kj'ei̱í kjo̱tíxoma‑la̱ xi 'ñó 'in tjín koni tsà ch'á i'í sík'a xi mìkiì k'a‑la̱; koa̱ jñà xi̱ta̱ xi okóya kjo̱tíxoma, ni̱ i̱tsé síchját'aà‑la̱ jñà xi̱ta̱ nga si̱ìkitasòn kjo̱tíxoma‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Koni s'ín s'ín yije kjoa̱ koi, tà jè‑né nga mejèn‑la̱ nga ìsa̱ ndaà skoe̱ xi̱ta̱. Jè Xo̱jo̱n‑la̱ Nainá xi ót'aà tje̱n‑la̱ ko̱ chrja‑la̱, ìsa̱á iì s'ín; koa̱ jè nikje xi ókjá, ìsa̱á ndojò kjoàn s'ín lixto xi títjòn‑la̱ nikje‑la̱, tà jè xi mejèn‑la̱ nga okó yijo‑la̱ nga tsò nga xi̱ta̱ tsjeè‑la̱ Nainá‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mejèn‑la̱ nga jñà kítsa̱t'aà ítjòn ími̱xa̱ k'e̱ nga kjèn xi̱ta̱ ñánda tjín s'eí ko̱ ya̱ ni'ya i̱ngo̱ sinagoga mejèn‑la̱ nga jñà kítsa̱nè íxi̱le̱ xi jncha ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ti̱koa̱á mejèn‑la̱ nga skoe̱xkón xi̱ta̱ xi kj'ei̱í, ndaà si̱ìxat'aà ya̱ ndi̱tsi̱n; ki̱tso̱‑la̱: “Maestro, Maestro.” ");
INSERT INTO maaNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Ta̱nga jñò, mìkiì biì'nde nga “Maestro” ki̱tso̱‑nò xi̱ta̱; ngats'ioò jñò, 'ndsè chibàko̱o xinguio̱o; tà jngoò ma xi Maestro‑nò, jè Cristo xi̱ta̱ xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ni̱jngoò xi “Na̱'èn” 'mì‑là i̱ i̱t'aà nangui; tà jngoò ma xi Na̱'èn‑nò xi tíjna ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Koa̱ ni̱ yá xi xi̱ta̱ sko̱‑la̱ ki̱tso̱‑nò; ta̱jngoò Cristo xi sko̱‑la̱ tíjna‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jè xi 'ñó 'nga síkíjna yijo‑la̱ i̱t'aà tsa̱jòn, jè‑né xi si̱ìxá‑la̱ xi̱ta̱ xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jè xi 'nga síkíjna yijo‑la̱, ìsa̱á nangui kíjna nga ko̱ma i̱skan; ko̱ jè xi nangui síkíjna yijo‑la̱, ìsa̱á 'nga kíjna nga ko̱ma i̱skan. ");
INSERT INTO maaNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡I̱ma̱ xó‑nò jñò, xi̱ta̱ xi okoòya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, ko̱ jñò xi xi̱ta̱ fariseo, xi̱ta̱ xi jò i̱sén tjín‑nò! Bíchjoà‑là ndi̱yá‑la̱ ngajmiì jñà xi̱ta̱ xi mejèn‑la̱ fahas'en ya̱ ñánda nga tíhotíxoma Nainá. Jñò, mìkiì bitjaàs'en‑jñoò ko̱ mìkiì biì'nde‑là xi kj'ei̱í xi̱ta̱ nga fahas'en‑jiìn. ");
INSERT INTO maaNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡I̱ma̱ xó‑nò jñò, xi̱ta̱ xi okoòya kjo̱tíxoma‑la̱ Nainá, ko̱ jñò xi xi̱ta̱ fariseo, xi̱ta̱ xi jò i̱sén tjín‑nò! Chja̱à'an‑là ni'ya‑la̱ íchjín ka'àn xi jye k'en x'i̱n‑la̱; i̱kjoàn 'ñó ndojò onguíko̱o o̱chikon‑nò nga mejèn‑nò nga bitsa̱jna'ma nga mì jcha̱‑nò mé kjoa̱ xi 'nè. Koií kjoa̱‑la̱ ìsa̱á tse kjo̱'in s'e̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡I̱ma̱ xó‑nò jñò, xi̱ta̱ xi okoòya kjo̱tíxoma‑la̱ Nainá, ko̱ jñò xi xi̱ta̱ fariseo, xi̱ta̱ xi jò i̱sén tjín‑nò! Bitjaàsòn yije i̱sò'nde ko̱ ndáchikon nga nokjoà‑là na̱s'ín tà jngoò xi̱ta̱ nga ya̱ fìt'aà‑nò. Ko̱ k'e̱ nga jye bitasòn‑nò xi̱ta̱ jè, jò k'a o̱kji ok'ìn‑la̱ koni jñò nga s'e̱‑la̱ kjo̱'in ya̱ ñánda títì ni'ín ts'e̱ i̱'nde kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡I̱ma̱‑xó‑nò jñò, xi̱ta̱ xi mìkiì tsejèn‑nò nga mejèn‑nò okoò‑là ndi̱yá xi̱ta̱ xi kj'ei̱í! Bixón‑nó: “Tsà jngoò xi̱ta̱ xi tsjá 'én‑la̱ xi i̱t'aà ts'e̱ i̱ngo̱, mìtsà mé‑ne. Ta̱nga tsà jngoò xi̱ta̱ tsjá 'én‑la̱ xi i̱t'aà ts'e̱ tsojmì chjí xi oro ts'e̱ i̱ngo̱, koií xi kjo̱'ñó ki̱tasòn 'én‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Jñò xi xi̱ta̱ tòndo̱ ko̱ xi̱ta̱ xka̱n 'mì‑nò! ¿Ñá‑la̱á xi ìsa̱ ndaà tjín? ¿A jñà tsojmì chjí xi oro a xi jè i̱ngo̱ xi síchikon‑t'in tsojmì chjí? ");
INSERT INTO maaNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jñò k'oa̱á ti̱ bixón: “Tsà jngoò xi̱ta̱ tsjá 'én‑la̱ nga ki̱tso̱: Tíbeè i̱'nde tsjeè ñánda binchasòn kjo̱tjò xi tsjá‑la̱ Nainá, jñà xi̱ta̱ mìkiì kjo̱'ñó ki̱tasòn 'én‑la̱. Ta̱nga tsà tsjá 'én‑la̱ xi i̱t'aà ts'e̱ tsojmì xi ya̱ títsa̱jnasòn jè i̱'nde tsjeè, jè xi o̱kixi̱ nga kjo̱'ñó ki̱tasòn.” ");
INSERT INTO maaNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Jñò xi xi̱ta̱ tòndo̱ ko̱ xi̱ta̱ xka̱n 'mì‑nò! ¿Ñá‑la̱á xi ìsa̱ ndaà tjín? ¿A jñà tsojmì xi tjín‑sòn ya̱ i̱'nde tsjeè a xi jè i̱'nde tsjeè xi síchikon‑t'in tsojmì? ");
INSERT INTO maaNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jè xi tsjá 'én‑la̱ xi i̱t'aà ts'e̱ i̱'nde tsjeè, ti̱koa̱á tsjá 'én‑la̱ xi i̱t'aà ts'e̱ ngayije tsojmì xi ya̱ tjín‑sòn ya̱ i̱'nde tsjeè. ");
INSERT INTO maaNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jè xi tsjá 'én‑la̱ i̱t'aà ts'e̱ i̱ngo̱ mìtsà tà jè i̱t'aà ts'e̱ i̱ngo̱ tsjá, ti̱koa̱á tsjá 'én‑la̱ xi i̱t'aà ts'e̱ Nainá xi ya̱ tíjna. ");
INSERT INTO maaNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jè xi tsjá 'én‑la̱ i̱t'aà ts'e̱ ngajmiì, tsjá 'én‑la̱ xi i̱t'aà ts'e̱ íxi̱le̱ kjo̱tíxoma‑la̱ Nainá; ti̱koa̱á tsjá 'én‑la̱ xi i̱t'aà ts'e̱ Nainá xi ya̱ tíjnasòn íxi̱le̱. ");
INSERT INTO maaNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡I̱ma̱ xó‑nò jñò, xi̱ta̱ xi okoòya kjo̱tíxoma‑la̱ Nainá, ko̱ jñò xi xi̱ta̱ fariseo, xi̱ta̱ xi jò i̱sén tjín‑nò! Nga ma‑nò 'biì‑là Nainá xi teya oko̱‑la̱ ts'e̱ xka̱ menta ko̱ xka̱ anís ko̱ xka̱ comino; ta̱nga mìkiì nìkitasòn jè kjo̱tíxoma xi ìsa̱ 'ñó mochjeén koni jè kjoa̱ kixi̱, kjoa̱hi̱ma̱takòn ko̱ jè kjoa̱ nga kixi̱ kàtakjeiín‑nò i̱t'aà ts'e̱ Nainá. Koií kjoa̱ xi 'ñó mochjeén nga ki̱tasòn; ti̱koa̱á mochjeén‑né nga ki̱tasòn jñà kjoa̱ xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Jñò, xi̱ta̱ xi mìkiì tsejèn‑nò nga mejèn‑nò okoò‑là ndi̱yá xi̱ta̱ xi kj'ei̱í, jñò, nìkjaànguioò na̱tse̱ nga majìn‑nò nga chíjeèn cho̱ xi tjé, ta̱nga mìkiì 'yaà k'e̱ nga chíjeèn cho̱ ch'á xi 'mì camello! ");
INSERT INTO maaNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡I̱ma̱ xó‑nò jñò, xi̱ta̱ xi okoòya kjo̱tíxoma‑la̱ Nainá, ko̱ jñò xi xi̱ta̱ fariseo, xi̱ta̱ xi jò i̱sén tjín‑nò! Onìjnoò chi̱tsín‑nò ko̱ chro̱ba̱‑nò ya̱ i̱sò'nga‑la̱ ta̱nga ya̱ i̱ya‑la̱ kitseè tsojmì xi nìchijé ko̱ nga tse mejèn‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Jñò xi xi̱ta̱ fariseo 'mì‑nò, xi mìkiì tsejèn‑nò. Ítjòn ta̱níya chi̱tsín‑nò ko̱ chro̱ba̱‑nò ya̱ i̱ya‑la̱, mé‑ne nga ko̱tsjeè‑ne i̱sò'nga‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡I̱ma̱ xó‑nò jñò, xi̱ta̱ xi okoòya kjo̱tíxoma‑la̱ Nainá, ko̱ jñò xi xi̱ta̱ fariseo, xi̱ta̱ xi jò i̱sén tjín‑nò! K'oa̱á titsjoò koni kjoàn chrjó‑la̱ mik'en xi kitsiìnga i̱sò'nga‑la̱. Ndaà kjoàn, ta̱nga ya̱ i̱ya‑la̱ kitseè nindaà‑la̱ mik'en ko̱ ngats'iì tsojmì xi ch'o kjoàn. ");
INSERT INTO maaNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jñò, k'oa̱á s'ín 'nè nga nguixko̱n xi̱ta̱, xi̱ta̱ ndaà‑nò; ta̱nga i̱jiìn ini̱ma̱‑nò kitseè kjoa̱ xi jò i̱sén tjín‑la̱ ko̱ kjoa̱ nga ch'o 'nè. ");
INSERT INTO maaNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡I̱ma̱ xó‑nò jñò, xi̱ta̱ xi okoòya kjo̱tíxoma‑la̱ Nainá, ko̱ jñò xi xi̱ta̱ fariseo, xi̱ta̱ xi jò i̱sén tjín‑nò! Bìndaà chrjó‑la̱ mik'en ts'e̱ xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá ko̱ nìkiìnga chrjó‑la̱ xi xi̱ta̱ kixi̱ komà. ");
INSERT INTO maaNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","I̱kjoàn bixón: “Tsà jñá‑la‑ná xi titsa̱jnakoaán jè na̱chrjein‑la̱ xi̱ta̱ jchínga‑ná mì‑la kiì kinìchját'aà‑lá xi̱ta̱ jchínga‑ná nga kisìk'en jñà xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá.” ");
INSERT INTO maaNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","K'oa̱á s'ín 'ya‑la̱ nga ti̱jñò 'ya‑nò yijo‑nò nga i̱xti‑la̱ maá xi̱ta̱ xi kisìk'en xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jñò, koni s'ín tsibíts'ia̱ xi̱ta̱ jchínga‑nò, jngoò k'a ti̱kitasòn yije kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Jñò, k'oa̱á ngaya‑la̱ koni ye̱, nga ya̱ tje̱n‑nò i̱t'aà ts'e̱ ye̱. Mìkiì ko̱jno‑nò i̱'nde ts'e̱ kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","K'oi̱í kjoa̱‑la̱, 'a̱n sìkasén‑nò xi̱ta̱ xi ki̱chja̱ ngajo‑la̱ Nainá, xi̱ta̱ xi tjín‑la̱ kjoa̱chji̱ne̱ ko̱ xi ko̱kòya kjo̱tíxoma. Ta̱nga jñò, tjín xi si̱k'eèn, tjín xi kjòt'aà krò koa̱ tjín xi ki̱xkàn‑ko̱o ya̱ i̱ya ni'ya i̱ngo̱ sinagoga; koa̱ ko̱nguítji̱ngui kondra̱‑là xi̱ta̱ koi nga xki̱ xi ján na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jñò ska̱nè yije‑nò kjo̱'in jè jní xi kixíxteèn ts'e̱ xi̱ta̱ ndaà xi k'en, mats'ia̱ko̱‑ne Abel, xi̱ta̱ kixi̱ xi k'en ítjòn, skanda jè Zacarías, ki'ndí‑la Berequías, jè xi kisìk'en xi̱ta̱ tsa̱jòn ya̱ i̱'nde jngoò osen‑la̱ ñánda tíjna Ni'ya Tsjeè‑la̱ Nainá ko̱ ñánda binchásòn kjo̱tjò xi tsjá‑la̱ Nainá jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","O̱kixi̱í xi xan‑nò, ngats'iì kjoa̱ koi, jñà ska̱nè‑la̱ kjo̱'in jñà xi̱ta̱ xi tjín i̱'ndei̱. ");
INSERT INTO maaNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Jñò xi xi̱ta̱ na̱xa̱ndá Jerusalén tsa̱jòn xi nìk'eèn xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá ko̱ bìnè nda̱jo̱ jñà xi̱ta̱ xi Nainá síkasén‑nò! ¡Kjìn k'a kjòmejèn‑na nga tsibíxkóya xi̱ta̱ na̱xa̱ndá‑nò, koni s'ín xa̱'nda̱ nga bíngui jnga̱á‑la̱ jñà i̱xti‑la̱; ta̱nga jñò, mìkiì kòkjeiín‑nò! ");
INSERT INTO maaNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chítsejèn‑là ni'ya‑nò nga jye tsjiìn‑takòn Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","K'oa̱á xán‑nò mats'ia̱‑ne na̱chrjein i̱'ndei̱ mì ti̱ kiì jcha̱xkoòn‑ná skanda k'e̱ nga jè na̱chrjein nga kixón: “¡Mé ta ndaà‑la̱ jè xi nchrobá ngajo‑la̱ Nainá!” ");
INSERT INTO maaNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús k'e̱ nga jye itjo‑ne i̱ngo̱ ítjòn, jyeé tífì nga ijchò kinchat'aà chrañà‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱. I̱kjoàn tsakó‑la̱ jè i̱ngo̱ ítjòn ko̱ ni'ya xi tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús kitsò‑la̱: ―¿A titsa̱chìtsejèn‑là ngats'iì ni'ya koi? O̱kixi̱í xi xan‑nò, nì ti̱ jngoò nda̱jo̱ si̱yijòsòn‑la̱ xíkjín. Ki̱xo̱ña yije‑né kóho̱tjín. ");
INSERT INTO maaNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesús, k'e̱ nga tíjna ya̱ nindoò Yá Olivo, ijchò kinchat'aà‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ nga kiskònanguit'aàxìn‑la̱ kitsò‑la̱: ―Koa̱tìn‑náje̱n, ¿mé na̱chrjein‑ne nga o̱ko̱ma kjoa̱ koi? ¿Mé seña xi s'e̱ k'e̱ nga kjoi̱i ìjngoò k'a ko̱ k'e̱ nga kjoe̱het'aà i̱sò'nde? ");
INSERT INTO maaNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","K'e̱é kitsò‑la̱ Jesús: ―Ti̱kinda̱a yijo‑nò nga mì yá xi̱ta̱ xi skóna̱cha̱n‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kjìn xi̱ta̱ kjoi̱í xi 'ín ts'a̱n si̱ìkjeén; ki̱tso̱: “'A̱n‑ná xi Cristo, nga 'a̱án kisìkasén‑na Nainá”; koa̱ kjìn xi̱ta̱ skóna̱cha̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","S'e̱ kjo̱jchán ñánda chrañàt'aà ko̱ ti̱koa̱ ki̱ná'ya‑la̱ kjoa̱ ts'e̱ kjo̱jchán ñánda kjiìn i̱'nde, ta̱nga jñò, kì tsakjoòn‑jèn. Xó k'oa̱á ko̱ma‑ne. Ta̱nga kj'eè tsà i̱sò'nde tífehet'aà. ");
INSERT INTO maaNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Na̱xa̱ndá ska̱àn‑kjoò xi kj'ei̱í na̱xa̱ndá. Koa̱ xi̱ta̱xá koi̱ìts'ia̱ nga ska̱àn‑kjoòko̱ xi̱ta̱xá xi kj'ei̱í na̱xa̱ndá. S'e̱ kjinchrá, s'e̱ ch'in, ko̱ k'oa̱ ch'ón nga xki̱ xi ján i̱'nde. ");
INSERT INTO maaNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ngats'iì kjoa̱ koi, tà jè xi sa̱ tímats'ia̱ko̱ kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Jñà xi̱ta̱ ski̱nìt'aà‑nò ts'e̱ xi̱ta̱xá nga tsjá‑nò kjo̱'in; si̱ìk'en‑nò. Ngats'iì xi̱ta̱ i̱sò'nde ko̱jtikeè‑nò koií kjoa̱‑la̱ nga 'a̱n onguít'aà‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jè na̱chrjein koi, kjìn ko̱ma xi mì kiì ti̱ ko̱kjeiín‑la̱ i̱t'aà ts'a̱n. Ti̱jñà ko̱ótjinè‑ne xíkjín xi̱ta̱ ko̱ tsjénguikeè xíkjín. ");
INSERT INTO maaNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kjìn xi̱ta̱ s'e̱ xi xi̱ta̱ ndiso xi ki̱tso̱ nga Nainá chja̱ ngajo‑la̱. Ti̱koa̱á kjìn xi̱ta̱ skóna̱cha̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ndaà jchán s'e̱ kjoa̱ts'e̱n; skanda mì ti̱ kiì ko̱tsjakeè‑ne xíkjín xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ta̱nga jè xi kixi̱ kíjnako̱ kjoa̱ xi mokjeiín‑la̱ skanda k'e̱ nga kjoe̱het'aà‑ne kjoa̱, jè xi ki̱tjokàjiìn kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Koa̱ jè 'én ndaà‑la̱ Nainá koni s'ín otíxoma Nainá, ko̱bísòn yije‑né nga tíjtsa i̱sò'nde mé‑ne nga kji̱'nchré‑ne ngats'iì xi̱ta̱ na̱xa̱ndá; i̱kjoàn k'e̱é kjoe̱het'aà i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’K'e̱ nga jcha̱a nga 'ñó ch'o tíma ya̱ I̱'nde Tsjeè‑la̱ Nainá, koií kjoa̱ tíbitasòn koni s'ín kiskiì Daniel, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. (Kàtasijiìn‑la̱ jñà xi̱ta̱ xi bíxke̱ xo̱jo̱n jé.) ");
INSERT INTO maaNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jñò, k'e̱ nga jcha̱a kjoa̱ koi, jñà xi̱ta̱ xi títsa̱jna Judea, kàtanga, kàtjì ñánda nindoò choòn. ");
INSERT INTO maaNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jè xi tíjnasò'nga ni'ya‑la̱, kì ti̱ kiì fahas'en‑ne ni'ya nga skoé tsojmì‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jè xi tísíxájiìn nangui‑la̱, kì ti̱ kì nchrobá‑ne nga nchrohókjá nikje‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡I̱ma̱ xó‑ne jñà íchjín xi ki'ndí 'ya ko̱ xi i̱xti xó nchisíkaki jñà na̱chrjein koi! ");
INSERT INTO maaNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ti̱jét'aà‑là Nainá mé‑ne nga mì k'e̱é ki̱yó‑nò k'e̱ nga na̱chrjein‑la̱ cho̱ 'nchán ko̱ k'e̱ nga na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Jñà na̱chrjein koi, tseé kjo̱'in s'e̱; kj'eè kiì k'oa̱ ma skanda tje̱n‑ne nga kisindaà i̱sò'nde. Koa̱ mì ti̱ kiì o̱ko̱ma‑ne nga ko̱ma i̱skan. ");
INSERT INTO maaNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tsà mì k'oa̱á ki̱tso̱ Nainá nga ìsa̱ chiba na̱chrjein s'e̱ kjo̱'in ni̱jngoò xi̱ta̱ ki̱tjokàjiìn kjo̱'in. Ta̱nga koií kjoa̱‑la̱ jñà xi̱ta̱ xi xó jaàjiìn‑ne Nainá, ìsa̱ chiba na̱chrjein s'e̱ kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’K'e̱ nga tsà yá xi̱ta̱ xi ki̱tso̱‑nò: “¡Chítsejèn‑là i̱í tíjna Cristo xi̱ta̱ xi xó kisìkasén‑ne Nainá!”, o tsà ki̱tso̱‑nò: “¡Ján tíjna ján!”, kì kiì mokjeiín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kjoi̱í xi̱ta̱ ndiso xi Cristo ki̱tso̱‑la̱ yijo‑la̱, ti̱koa̱á kjoi̱í xi̱ta̱ xi koa̱ ti ki̱tso̱ nga jñà xi chja̱ ngajo‑la̱ Nainá. K'oa̱á ti̱s'ín ko̱kò seña ko̱ kjo̱xkón xi ndaà tjín nga skóna̱cha̱n. Skanda jñà xi̱ta̱ xi jye jaàjiìn Nainá mejèn skóna̱cha̱n‑la̱ tsà ko̱kjeiín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kangui na̱chrjeiín tìbeno̱jmíya yije‑nò kjoa̱ xi ko̱ma i̱skan. ");
INSERT INTO maaNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tsà yá xi̱ta̱ xi ki̱tso̱‑nò: “¡Chítsejèn‑là ya̱á tíjna Cristo ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn!”, kì kiì onguió; ko̱ tsà ki̱tso̱‑nò: “¡Ya̱á tíjnaya i̱nga ni'ya!”, ti̱koa̱á kì kiì mokjeiín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Koni ma ni'ín ch'o̱n k'e̱ nga ote ñánda bitjokàtji‑ne ts'oí skanda ñánda okaàtjì‑ne, k'oa̱á s'ín ko̱ma k'e̱ nga kjoia̱a ìjngoò k'a xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ya̱ ñánda kijna mik'en, ya̱á kítsa̱jnajtín jñà líké. ");
INSERT INTO maaNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Ti̱jè‑ne na̱chrjein, k'e̱ nga kjoe̱het'aà kjo̱'in koi, jè ts'oí, mì ti̱ kiì si̱ìhiseèn‑ne, ko̱jñò‑né, mì ti̱ kiì ko̱tsjè‑ne ndobá‑la̱. Ti̱koa̱á jè sá, mì ti̱ kiì si̱ìhiseèn‑ne. Ni'ño xi tjín ngajmiì, ki̱xo̱ngui‑né. Jñà nga'ñó xi tjín ngajmiì ki̱ti̱ya yijeé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","I̱kjoàn skoe̱ xi̱ta̱ ján ngajmiì seña‑na̱ xi Ki'ndí‑la̱ Xi̱ta̱ 'mì‑na̱. Ngats'iì na̱xa̱ndá xi tjín i̱ i̱sò'nde, jñà xi̱ta̱ ski̱ndàya‑né nga 'ñó tsakjón. Koa̱ skoe̱‑na xi̱ta̱ xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ nga kji̱nchrobàjñaà i̱jiìn ifi xi tjín ngajmiì; tse nga'ñó ko̱ kjoa̱jeya kjoi̱ikoa̱a. ");
INSERT INTO maaNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Siìkasén àkja̱le̱‑na̱ nga 'ñó si̱ìkjindáya chrjo nga koi̱ìxkóya xi̱ta̱‑na̱ xi 'a̱n xó jaàjiìn‑na nga ñijòn chrja̱ngui̱‑la̱ i̱sò'nde, nga jngoò ìjngoò ngobà‑la̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Chíta'yàko̱ò jè yá‑la̱ toò iko̱ mé xi okóya‑ná; k'e̱ nga ma kíndíya chrja‑la̱, i̱kjoàn bíjts'én xka̱‑la̱, tíjiìn‑nò nga jye nchrobá machrañà cho̱n ndobá. ");
INSERT INTO maaNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","K'oa̱á ti̱s'ín tjín, k'e̱ nga jcha̱a nga k'oa̱s'ín tíma kjoa̱ koi, kàtasijiìn‑nò nga 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ jyeé ni̱to̱n kjoia̱a, k'oa̱á ngaya‑la̱ koni tsà jye tìjna̱ chrañà xotjoa̱‑la̱ ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","O̱kixi̱í xi xan‑nò, k'oa̱á s'ín ki̱tasòn yije kjoa̱ koi, k'e̱ nga ti̱kj'eè biyaà xi̱ta̱ xi tjín na̱chrjein i̱'ndei̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Jè ngajmiì ko̱ i̱sò'nde kjoe̱het'aà‑né, ta̱nga jñà 'én‑na̱ mìkiì kjoe̱het'aà; ki̱tasòn‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Ta̱nga k'e̱ nga o̱ko̱ma, mì yá xi tíjiìn‑la̱ mé na̱chrjein‑ne ko̱ mé hora‑ne; ni̱ jñà àkja̱le̱ xi tjín ngajmiì, ko̱ ni̱ jè Ki'ndí‑la̱ Nainá tíjiìn‑la̱; ta̱jngoò Nainá xi Na̱'èn‑ná tíjiìn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Koni s'ín komà na̱chrjein‑la̱ Noé, k'oa̱á ti̱s'ín ko̱ma k'e̱ nga kjoia̱a ìjngoò k'a 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Jñà na̱chrjein koi, k'e̱ nga ti̱kj'eè 'ba jtsí xkón, jñà xi̱ta̱ xi tjín k'e̱‑ne, nchikjèn, nchi'biì, nchibixan íchjá ko̱ íchjín skanda k'e̱ nga jè na̱chrjein nga jahas'en ni'ya chitso jè Noé. ");
INSERT INTO maaNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Xi̱ta̱ xi tjín koi na̱chrjein, mìkiì tíjiìn‑la̱ mé xi ko̱ma skanda k'e̱ nga j'iì jtsí xkón xi kiìchrjoako̱ nandá ngats'iì xi̱ta̱. K'oa̱á ti̱s'ín ko̱ma k'e̱ nga kjoia̱a ìjngoò k'a 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jè na̱chrjein k'e̱ nga 'a̱n xi kjoia̱a, jò xi̱ta̱ xi nchisíxá ján i̱jiìn ijñá, jngoò tjámiìtje̱n, xi ìjngoò si̱jna‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jò íchjín nchat'aà natsí xi nchi'o na̱'yo̱, jngoò tjámiìtje̱n, xi ìjngoò si̱jna‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Titsa̱jnakoòn nga mìkiì 'yaà mé na̱chrjein‑ne ko̱ mé hora‑ne nga kjoia̱a 'a̱n xi Nainá 'mì‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kàtasijiìn‑nò, tsà jngoò nei‑la̱ ni'ya si̱jiìn‑la̱ mé hora‑ne k'e̱ nga jñò kjoi̱í xi̱ta̱ chijé nga si̱ìchijé‑la̱, si̱ìkinda̱á ni'ya‑la̱; mìkiì tsjá'nde nga ko̱chijé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jñò, ti̱koa̱á titsa̱jnandaà; nga̱ 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, k'e̱é kjoia̱a ìjngoò k'a k'e̱ nga jñò mìkiì titsa̱chiñà. ");
INSERT INTO maaNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Yá‑ne xi chi̱'nda kixi̱ xi tjín‑la̱ kjoa̱chji̱ne̱? Jè nei‑la̱ si̱ìkíjna'nda jñà chi̱'nda‑la̱ xi i'nga xi ya̱ síxá ni'ya‑la̱ mé‑ne nga k'e̱ ki̱jchò chi̱ba̱‑la̱, si̱ìkjèn chi̱'nda xíkjín. ");
INSERT INTO maaNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mé tà ndaà‑la̱ jè chi̱'nda xi k'oa̱s'ín ndaà tísíkitasòn k'e̱ nga kjoi̱í‑ne nei‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Xi o̱kixi̱í xi xan‑nò, nei‑la̱ chi̱'nda jè, jè si̱ìkíjna'nda yije tsojmì xi tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ta̱nga tsà jè chi̱'nda ts'e̱n ki̱tso̱ nga ko̱òko̱ ini̱ma̱‑la̱: “Nei‑na̱, kjìn na̱chrjein ko̱chrjein‑la̱ nga kjoi̱í‑ne.” ");
INSERT INTO maaNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","I̱kjoàn koi̱ìts'ia̱ nga ska̱àn‑ko̱ chi̱'nda xíkjín, koa̱ ko̱kje̱n‑ko̱ ko̱ skoíko̱ xi̱ta̱ ch'i̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Chi̱'nda jè, kjoi̱í‑ne nei‑la̱ jè na̱chrjein ko̱ jè hora k'e̱ nga mìkiì tíkoña‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","'Ñó tse kjo̱'in tsjá‑la̱. Tà ngásòn o̱kji kjo̱'in tsjá‑la̱ koni jñà xi̱ta̱ xi jò i̱sén tjín‑la̱. I̱kjoàn ski̱ndàya ko̱ si̱ìjts'iìn ni̱'ño̱. ");
INSERT INTO maaNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Jè na̱chrjein k'e̱ nga ko̱tìxoma jè xi ngajmiì nchrobá‑ne, k'oa̱á s'ín ko̱ma koni komàt'in jñà i̱xti íchjín xi te ma‑ne. Kiskoé ni'ín lámpara‑la̱ xi ts'e̱ asìti̱. Kiìkoña‑la̱ jè xi̱ta̱ xi bixan. ");
INSERT INTO maaNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","'Òn ma‑ne i̱xti íchjín xi tjín‑la̱ kjo̱hítsjeèn koa̱ 'òn ma‑ne xi tsjìn‑la̱ kjo̱hítsjeèn. ");
INSERT INTO maaNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jñà i̱xti íchjín xi tsjìn‑la̱ kjo̱hítsjeèn kiskoé lámpara‑la̱ ta̱nga mìkiì ts'a‑la̱ asìti̱. ");
INSERT INTO maaNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Koa̱ jñà i̱xti íchjín xi jye tíjiìn‑la̱ ts'a nomìta̱ asìti̱‑la̱ ko̱ lámpara‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Jè xi̱ta̱ xi tíbixan, mìkiì xátí j'iì, koa̱ kjònijñá‑la̱ ngats'iì i̱xti íchjín; tsohofè í'ñó. ");
INSERT INTO maaNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","K'e̱ nga ijchò osen ni̱tje̱n, 'ñó kiìchja̱ jñà xi̱ta̱, kitsò: “Jye nchrobá jè xi̱ta̱ xi bixan. Tìtjo̱o ni'ya, tanguíchjaà indiaà.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ngats'iì i̱xti íchjín tsasítje̱n, koa̱ tsibítsa̱jnandaà lámpara‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jñà xi 'òn ma‑ne xi tsjìn‑la̱ kjo̱hítsjeèn kitsò‑la̱ jñà xi tjín‑la̱: “Tjiì i̱tsé‑náje̱n asìti̱‑nò. Jè ni'ín‑na̱je̱n jye tíbits'o.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ta̱nga jñà i̱xti íchjín xi tjín‑la̱ kjo̱hítsjeèn, kitsò‑la̱: “Mìkiì ko̱ma, mìkiì ki̱chóya‑la̱ tsa̱je̱n. Tanguí kindá ñánda satíjna.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ta̱nga jñà i̱xti íchjín xi tsjìn‑la̱ kjo̱hítsjeèn k'e̱ nga kiì katse asìti̱‑la̱, k'e̱é j'iì xi̱ta̱ xi bixan. Koa̱ jñà i̱xti íchjín xi 'òn ma‑ne xi títsa̱ndaà nga títì lámpara‑la̱, jahas'en ko̱ jè xi̱ta̱ xi bixan ya̱ ni'ya ñánda tjín s'eí. I̱kjoàn kisìchjoà xotjoa̱‑la̱ ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ko̱ma i̱skan j'iì‑ne jñà i̱xti íchjín xi nguì 'òn ma. Kitsò: “Na̱'èn, Na̱'èn, chíx'a̱‑náje̱n ni'ya.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ta̱nga jè xi̱ta̱ xi bixan, tà kitsò‑la̱: “O̱kixi̱í xi xan‑nò, mìkiì bexkon‑nò yá‑nò jñò.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesús kitsò‑ìsa: ―Jñò, titsa̱jnandaà, nga mìkiì 'yaà mé na̱chrjein‑ne koa̱ mé hora‑ne nga kjoia̱a 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Jè na̱chrjein k'e̱ nga ko̱tìxoma jè xi ngajmiì nchrobá‑ne, k'oa̱á ti ngaya‑la̱ koni tsà jngoò xi̱ta̱ xi tjín‑la̱ chi̱'nda. Kjiìn i̱'nde tífì. Kiìchja̱‑la̱ chi̱'nda‑la̱; kisìnga̱tsja to̱n‑la̱ nga jngoò ìjngoò nga kàtasíkinda̱. ");
INSERT INTO maaNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Jngoò chi̱'nda xi kitsjaà‑la̱ 'òn jmiì to̱n oro; xi ìjngoò jò jmiì kitsjaà‑la̱; xi ma‑ne jàn jngoò jmiì kitsjaà‑la̱. K'oa̱á s'ín kitsjaà‑la̱ koni s'ín ko̱ma‑la̱ nga si̱ìxáko̱ nga jngoò ìjngoò. I̱kjoàn kiì jè nei‑la̱ xá ñánda i̱'nde kjiìn. ");
INSERT INTO maaNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jè chi̱'nda xi kitjoé‑la̱ 'òn jmiì, kisìxáko̱ to̱n xi kitjoé‑la̱ koa̱ nguì o̱kji kisìkijnesòn. ");
INSERT INTO maaNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ko̱ jè chi̱'nda xi jò jmiì kitjoé‑la̱, k'oa̱á ti̱ kis'iìn, ti̱koa̱ nguì jò jmiì kisìkijnesòn. ");
INSERT INTO maaNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ta̱nga jè chi̱'nda xi kitjoé‑la̱ jngoò jmiì, tà tsibíjna'ma‑né to̱n xi kitsjaà‑la̱ nei‑la̱. Ya̱á tsibíjnajiìn i̱t'aà nangui. ");
INSERT INTO maaNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’K'e̱ nga jye kjòtseé kiì nei‑la̱ chi̱'nda koi, j'iì ìjngoò k'a‑ne; kis'iìn‑la̱ kinda̱ jè to̱n xi kitsjaà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ijchò jè xi kjònga̱tsja xi 'òn jmiì, koa̱ nguì 'òn jmiì ijchòko̱sòn. Kitsò‑la̱ nei‑la̱: “Na̱'èn, 'òn jmiì to̱n xi ji̱ kinìnga̱tsja‑ná, koa̱ nguì 'òn jmiì kisìkijnesoàn.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jè nei‑la̱ kitsò‑la̱: “Ndaà tjín; ngaji̱, xi̱ta̱ ndaà‑né. Ndaà kinìtasòn‑ná na̱s'ín tà chiba to̱n kitsjaà‑lè. 'A̱n, ìsa̱á tse tsja ìsa̱‑lè. Ti̱tjás'e̱n‑jiìn nga ti̱tsjako̱‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","I̱kjoàn ijchò jè chi̱'nda xi jò jmiì kjònga̱tsja, kitsò: “Na̱'èn, jò jmiì to̱n kinìnga̱tsja‑ná koa̱ nguì jò jmiì kisìkijnesoàn.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jè nei‑la̱ kitsò‑la̱: “Ndaà tjín; ngaji̱, xi̱ta̱ ndaà‑né. Ndaà kinìtasòn‑ná na̱s'ín tà chiba to̱n kitsjaà‑lè. 'A̱n ìsa̱á tse tsja ìsa̱‑lè. Ti̱tjás'e̱n‑jiìn nga ti̱tsjako̱‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Koa̱ k'e̱ nga ijchò jè chi̱'nda xi jngoò jmiì kjònga̱tsja kitsò‑la̱ nei‑la̱: “Na̱'èn, bexkoón‑lè nga xi̱ta̱ jti takòn‑né nga bìxkoí tsojmì xi mì ji̱ bìtji̱i, ko̱ bìxkoí jñà xi mì ji̱ chíjndi̱i. ");
INSERT INTO maaNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Koií kjoa̱‑la̱ nga kitsakjòn‑na nga tsibìjna'ma to̱n‑lè ya̱ i̱jiìn nangui. I̱ tíjna‑ne to̱n‑lè xi jngoò jmiì kinìnga̱tsja‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jè nei‑la̱ kitsò‑la̱: “¡Ngaji̱, chi̱'nda ch'o‑né koa̱ xi̱ta̱ ts'eè‑né! Tsà jye tíjiìn‑lè nga 'a̱n bìxkoá ñánda mì 'a̱n bìtje̱e ko̱ bìxkoá ñánda mì 'a̱n kíjndia̱a. ");
INSERT INTO maaNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tsà ya̱ tsibìjni to̱n‑na̱ ya̱ banco mé‑ne k'e̱ nga kjoi̱‑na̱, tjoé‑na̱ to̱n‑na̱ ko̱ ki'ndí‑la̱ to̱n xi ts'a̱n.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","I̱kjoàn kitsò‑la̱ jñà xi̱ta̱ xi ya̱ títsa̱jna: “Chja̱à'an‑là jè to̱n xi jngoò jmiì; jè tjiì‑la̱ chi̱'nda xi te jmiì ma ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nga̱ jè xi tjín‑la̱, k'oi̱í ìsa̱‑la̱ skanda tsatoó s'e̱‑la̱, ta̱nga jè xi tsjìn‑la̱, skanda tjá'aán‑la̱ mé xi chiba tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jè chi̱'nda xi nì mé chjí‑la̱, ti̱katje̱en ján ndi̱tsiaán ya̱ ñánda jñò choòn, ya̱á ski̱ndàya ko̱ ya̱á si̱ìjts'iìn ni̱'ño̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’K'e̱ nga kjoia̱a ìjngoò k'a 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ koni jngoò xi̱ta̱xá ítjòn nga kjoi̱ikoa̱a kjoa̱jeya‑na̱, ko̱ àkja̱le̱ tsjeè‑na̱ xi títsa̱jnandiì‑na̱, k'e̱é kóti̱jnasoàn íxi̱le̱ ts'e̱ kjo̱tíxoma‑na̱ xi 'ñó jeya tíjna. ");
INSERT INTO maaNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ngats'iì xi̱ta̱ xi tjín i̱sò'nde, ya̱á ko̱xkóya nguixkoaàn; i̱kjoàn siìjòya koni s'ín paxtò xi ko'ndà tíndsó nga ochrjekàjiìn orrè ko̱ tíndsó ska. ");
INSERT INTO maaNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jñà orrè, ya̱á kítsa̱jnat'aà kixi̱‑na̱, koa̱ jñà tíndsó ska, ya̱á kítsa̱jnat'aà ngaskón‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","'A̱n xi xi̱ta̱xá ítjòn 'mì‑na̱ xán‑la̱ jñà xi títsa̱jnat'aà kixi̱‑na̱: “Nchrobá jñò xi Nainá kisìchikon‑t'in‑nò; chjoé kjo̱ndaà xi tíjnandaà‑la̱ Nainá skanda k'e̱ nga kisindaà i̱sò'nde, nga ya̱ ki̱tsa̱jnaà ya̱ ñánda nga jè tíhotíxoma. ");
INSERT INTO maaNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","K'e̱ nga kjòhojò‑na, kits'iì‑ná jñò xi tsoókje̱en; k'e̱ nga kjòxíndá‑na, kits'iì‑ná nandá nga kits'ia̱a; k'e̱ nga tsjìn‑na i̱'nde ñánda sìkjáya, kits'iì'nde‑ná ni'ya‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","K'e̱ nga tsjìn‑na nikje xi ónakjá, jñò kits'iì‑ná; k'e̱ nga kjòxk'én, tsanguì nìkinda̱‑ná; k'e̱ nga nda̱yá tsohóti̱jna'ya, tsanguì chìtsejèn‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Koa̱ jñà xi xi̱ta̱ kixi̱ sko̱nanguií‑na, ki̱tso̱‑na: “Na̱'èn, ¿kjé‑né nga ki'ya‑lèje̱n nga kjòhojò‑lè, ko̱ kìts'iì‑lèje̱n xi chichi?, o ¿kjé‑né nga ki'ya‑lèje̱n nga kjòxíndá‑lè, ko̱ kìts'iì‑lèje̱n nandá nga ki'yoì? ");
INSERT INTO maaNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Kjé‑né nga ki'ya‑lèje̱n nga tsjìn‑lè i̱'nde ñánda nìkjáyi, ko̱ kits'iì'nde‑lèje̱n ni'ya‑na̱je̱n, na̱s'ín mìkiì yaxkon‑lèje̱n? ¿Kjé‑né nga ki'ya‑lèje̱n nga tsjìn‑lè nikje xi chíkjeí, ko̱ kìts'iì‑lèje̱n? ");
INSERT INTO maaNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Kjé‑né nga ki'ya‑lèje̱n nga kjòxk'ín, ko̱ tsanguì nìkinda̱‑lèje̱n?, o ¿kjé‑né nga ki'ya‑lèje̱n nga tina'yi nda̱yá, ko̱ tsanguì chìtsejèn‑lèje̱n?” ");
INSERT INTO maaNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","'A̱n xi xi̱ta̱xá ítjòn 'mì‑na xán‑la̱: “O̱kixi̱í xi xan‑nò, k'e̱ nga k'oa̱s'ín kinìko̱ jngoò xi̱ta̱ xinguia̱a na̱s'ín ta̱kó 'ñó xi̱ta̱ i̱ma̱ kji, 'a̱án xi k'oa̱s'ín kinìko̱‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’'A̱n xi xi̱ta̱xá ítjòn 'mì‑na xán‑la̱ jñà xi̱ta̱ xi títsa̱jna ngaskón‑na̱: “Ti̱nchat'aàxìn‑ná jñò xi kjo̱'in tjínè‑nò. Tanguió ya̱ i̱'nde ñánda títì ni'ín xi mìkiì bits'o ni̱ta̱ kjé‑ne, jè i̱'nde xi tjíndaà i̱t'aà ts'e̱ xi̱ta̱ nei̱í ko̱ àkja̱le̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","K'e̱ nga kjòhojò‑na, jñò, mìkiì kìts'iì‑ná xi tsoókje̱en; k'e̱ nga kjòxíndá‑na, mìkiì kìts'iì‑ná nandá nga kits'ia̱a; ");
INSERT INTO maaNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","k'e̱ nga tsjìn‑na i̱'nde ñánda sìkjáya, mìkiì kits'iì'nde‑ná ni'ya‑nò. K'e̱ nga tsjìn‑na nikje xi ónakjá, jñò mìkiì kìts'iì‑ná; k'e̱ nga kjòxk'én mìkiì tsà kinìkinda̱‑ná; k'e̱ nga nda̱yá tsohóti̱jna'ya, mìkiì tsanguì chìtsejèn‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ti̱koa̱á jñà xi̱ta̱ xi títsa̱jna ngaskón‑na̱ sko̱nangui‑na, ki̱tso̱‑na: “Na̱'èn, ¿kjé‑né nga ki'ya‑lèje̱n nga kjòhojò‑lè, nga kjòxíndá‑lè nga tsjìn‑lè i̱'nde ñánda nìkjáyi, nga tsjìn‑lè nikje xi chíkjeí, nga kjòxk'ín, o k'e̱ nga tina'yi nda̱yá ko̱ mìkiì kinìchját'aà‑lèje̱n?” ");
INSERT INTO maaNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","'A̱n xi xi̱ta̱xá ítjòn 'mì‑na, xán‑la̱: “O̱kixi̱í xi xan‑nò, k'e̱ nga mìkiì k'oa̱s'ín kinìko̱ò jngoò xi̱ta̱ na̱s'ín ta̱kó 'ñó i̱ma̱ kji, 'a̱án xi mìkiì k'oa̱s'ín kinìko̱‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jñà xi̱ta̱ ts'e̱n koi s'e̱é‑la̱ kjo̱'in ni̱ta̱ kjé‑ne, koa̱ jñà xi xi̱ta̱ kixi̱ s'e̱é‑la kjoa̱binachon ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús k'e̱ nga jye kiìchja̱ yije 'én koi kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Jñò, jye tíjiìn‑nò nga tà jò na̱chrjein chija ts'e̱ s'eí Paxko̱; 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, ya̱á ko̱nga̱tsja i̱t'aà ts'e̱ xi̱ta̱ na̱xa̱ndá nga ko̱òt'aà‑na krò. ");
INSERT INTO maaNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na̱chrjein koi jñà xi̱ta̱ sko̱‑la̱ no̱'miì, xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés ko̱ xi̱ta̱ jchínga‑la̱ jñà xi̱ta̱ judío, ya̱á chixoña ya̱ ndi̱tsin ni'ya‑la̱ Caifás xi no̱'miì ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ya̱á tsajoóya‑ne kós'ín tsobà'ñó Jesús xi kjoa̱ chijé, i̱kjoàn si̱ìk'en. ");
INSERT INTO maaNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kitsò‑la̱ xíkjín: ―Mì na̱chrjein‑la̱ s'eí si̱k'eén nga mì ko̱ts'e̱n jñà xi̱ta̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús, k'e̱ nga tíjna ján na̱xa̱ndá Betania, ya̱ ni'ya‑la̱ jngoò xi̱ta̱ xi tsindojno chrjoa̱ yijo‑la̱ nga sa̱ ítjòn xi 'mì Simón, ");
INSERT INTO maaNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ijchò jngoò chjo̱ón xi 'ya jngoò lamìta̱ nda̱jo̱ xi 'mì alabastro xi tjíya‑la̱ xkiì jne̱, xi 'ñó chjí‑la̱. K'e̱ nga tíjnat'aà ími̱xa̱ Jesús, chjo̱ón jè, tsibíxteèn‑sòn sko̱ jè xkiì jne̱. ");
INSERT INTO maaNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús k'e̱ nga kijtseè, kòjti‑la̱, kitsò: ―¿Mé‑ne nga kasíkits'ón‑ne jè xkiì jne̱? ");
INSERT INTO maaNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tsà kàsatíjna, 'ñó‑là tse chjí‑la̱ koa̱ jè to̱n‑la̱ ko̱maá ko̱chját'aà‑la̱ xi̱ta̱ i̱ma̱. ");
INSERT INTO maaNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kiì'nchré Jesús. K'e̱é kitsò‑la̱: ―¿Mé‑ne nìjti‑là chjo̱ón jè? Koni s'ín kasìko̱‑na ndaà kàs'ín. ");
INSERT INTO maaNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Jñà xi̱ta̱ i̱ma̱ kítsa̱jnako̱ kjit'aà‑nò; ta̱nga 'a̱n mì i̱ tìjna̱ko̱ kjit'aà‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Koni s'ín kasìko̱‑na chjo̱ón jè, nga kàbíxteèn‑jno xkiì jne̱ yijo‑na̱, koií o̱kàs'ín‑ne nga síkíjnandaà‑na nga si̱ìjñaà. ");
INSERT INTO maaNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","O̱kixi̱í xi xan‑nò, ni̱ta̱ ñánda‑ne nga tíjtsa i̱sò'nde nga ko̱bísòn 'én ndaà‑la̱ Nainá, ti̱koa̱á ko̱bísòn‑nè koni s'ín kasìko̱‑na mé‑ne nga si̱ìkítsjeèn‑ne xi̱ta̱ i̱t'aà ts'e̱ chjo̱ón jè. ");
INSERT INTO maaNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jè xi 'mì Judas Iscariote xi ya̱ itjojiìn ts'e̱ xi̱ta̱ xi tejò ma‑ne xi̱ta̱‑la̱ Jesús, kiìkon jñà xi̱ta̱ sko̱‑la̱ no̱'miì, ");
INSERT INTO maaNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kitsò‑la̱: ―¿Kó tjín to̱n k'oi̱‑ná nga sìnga̱tsja‑nò Jesús? Jñà xi̱ta̱ sko̱‑la̱ no̱'miì, katé ixo̱ to̱n chroba tsibíndaàjiìn‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Judas, k'e̱é tsibíts'ia̱ nga tsohótsji'nde‑la̱ kós'ín si̱ìnga̱tsja Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jè na̱chrjein xi mats'ia̱ ítjòn ts'e̱ s'eí k'e̱ nga kjèn i̱nchra̱jín xi tsjìn‑la̱ na̱'yo̱ san jñà xi̱ta̱ judío, jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús ijchòkon, kiskònangui‑la̱, kitsò‑la̱: ―¿Ñánda mejèn‑lè nga onguí kíndaà‑je̱n tsojmì xi chji̱ne̱é ts'e̱ s'eí Paxko̱? ");
INSERT INTO maaNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús kitsò‑la̱: ―Tanguíchòn ni'ya‑la̱ jngoò xi̱ta̱ ya̱ i̱jiìn na̱xa̱ndá. Ko̱t'ìn‑là: “Jè maestro k'oa̱á tsò: Jyeé tíma chrañà na̱chrjein‑na̱ nga ki̱yá. Ya̱á ni'ya‑lè kjián kachrje s'eí Paxko̱ ko̱ xi̱ta̱ xi kota'yàt'aà‑na.” ");
INSERT INTO maaNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱, k'oa̱á s'ín kis'iìn koni s'ín kitsò‑la̱ Jesús. Ya̱á tsibíndaà tsojmì xi ko̱kje̱n kjoa̱ ts'e̱ s'eí Paxko̱. ");
INSERT INTO maaNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","K'e̱ nga jye kòjñò, Jesús, tsibíjnat'aà ími̱xa̱ ko̱ xi̱ta̱‑la̱ xi tejò ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","K'e̱ nga nchikjèn, Jesús kitsò‑la̱: ―O̱kixi̱í xi xan‑nò, jñò, i̱ tíjnajiìn jngoò‑nò xi si̱ìnga̱tsja‑na̱ i̱t'aà ts'e̱ xi̱ta̱ kondra̱‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús 'ñó kjòba‑la̱ k'e̱ nga o̱kitsò. K'e̱é jngó jngó kiskònangui‑la̱, kitsò‑la̱: ―Na̱'èn, ¿a 'a̱n‑ná? ");
INSERT INTO maaNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús kitsò‑la̱: ―Jè xi kóngájiìn‑ko̱‑na chro̱ba̱, jé xi si̱ìnga̱tsja‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, k'oa̱á s'ín ko̱mat'ian koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá. ¡Ta̱nga i̱ma̱ xó‑ne jè xi̱ta̱ xi si̱ìnga̱tsja‑na! Ìsa̱á‑là ndaà komà tsà mìkiì kits'iìn xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","K'e̱é kiìchja̱ Judas, jè xi si̱ìnga̱tsja Jesús, kitsò: ―Maestro, ¿a 'a̱n‑ná? Jesús kitsò‑la̱: ―Jon, ngaji̱‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","K'e̱ nga nchikjèn, Jesús kiskoé i̱nchra̱jín, kiìchja̱t'aà‑la̱ Nainá nga kisìchikon‑t'in, kisìxkoa̱ya i̱kjoàn kitsjaà‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱, kitsò‑la̱: ―Chjoé, ti̱chioò, yijo‑na̱ né. ");
INSERT INTO maaNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","I̱kjoàn kiskoé jngoò chi̱tsín, kitsjaà‑la̱ kjo̱ndaà Nainá, k'e̱é kitsjaà‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱. Kitsò‑la̱: ―Ngats'ioò, t'io̱o jè xi tjíya chi̱tsín. ");
INSERT INTO maaNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Jè‑né xi jní‑na̱ xi síkixi̱ya kjoa̱ xi̱tse̱ xi bìndaàjiìn‑ko̱‑nò. Jè jní‑na̱ xíxteèn xi kjo̱ndaà ts'e̱ kjìn xi̱ta̱ mé‑ne nga jcha̱t'aà‑la̱ jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","K'oa̱á xán‑nò, mì ti̱ kiì ski̱‑na vino skanda jè na̱chrjein k'e̱ nga ski̱ko̱ ìjngoò k'a‑nò vino xi̱tse̱ jè na̱chrjein k'e̱ nga ko̱tìxoma Na̱'èn‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","K'e̱ nga jye kiseè jngoò‑la̱ sò Nainá ts'e̱ Salmo, i̱kjoàn kiì ján i̱'a nindoò Yá Olivo. ");
INSERT INTO maaNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Ngats'ioò jñò, ni̱tje̱n jè, ki̱jneí takòn‑ná, nga k'oa̱á s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá nga tsò: “Ki̱yá jè paxtò koa̱ jñà orrè tsjohoya‑né.” ");
INSERT INTO maaNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ta̱nga ko̱ma i̱skan, k'e̱ nga kjoa̱áya‑na, kjín ítjòn‑nò ján nangui Galilea. ");
INSERT INTO maaNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kitsò Pedro: ―Na̱s'ín ngats'iì xi̱ta̱‑lè xi i'nga tsjín takòn‑lè, 'a̱n, ni̱mé na̱chrjein‑ne nga tsjiìn takòn‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","K'e̱é kitsò‑la̱ Jesús: ―O̱kixi̱í xi xan‑lè, ni̱tje̱n jè, k'e̱ nga ti̱kj'eè kjindáya kóxtí, ngaji̱, jàn k'a tsjá'mat'in‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro kitsò: ―Na̱s'ín skanda ya̱ ki̱yáko̱‑lè mìkiì kójna̱'mat'in‑lè. Ngásòn kitsò ngats'iì xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","K'e̱é kiì Jesús ya̱ ñánda 'mì Getsemaní ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱. Kitsò‑la̱: ―Ti̱tsa̱jna i̱jndé. 'A̱n, ya̱ kò‑là kjián nga kichjàt'aà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesús kiìko̱ Pedro ko̱ ingajò i̱xti‑la̱ Zebedeo. I̱kjoàn tsibíts'ia̱ nga kjòba‑la̱ koa̱ kisìkájno ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","K'e̱é kitsò Jesús: ―Tsí baá ma‑la̱ ini̱ma̱‑na̱ koni tsí mejèn ki̱yá. Ti̱tsa̱jna i̱jndé koa̱ titsa̱jnakon‑ko̱‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús kiìkjá chiba‑ìsa. I̱kjoàn tsohojna tsakjàn skanda i̱t'aà nangui koa̱ kisìjét'aà‑la̱ Nainá, kitsò: ―Ji̱ xi Na̱'èn‑na̱ xan‑lè, tsà ko̱ma, kàtatjaàxìn‑ná kjo̱'in koi, ta̱nga mìtsà jè 'én ts'a̱n ki̱tasòn, jè kàtitasòn 'én tsi̱ji. ");
INSERT INTO maaNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","I̱kjoàn j'iì ìjngoò k'a‑ne ya̱ ñánda títsa̱jna xi̱ta̱‑la̱ xi kota'yàt'aà‑la̱, ta̱nga jñà xi̱ta̱‑la̱, kjiyijòfè‑né. Jesús kitsò‑la̱ Pedro: ―¿A mì kachíkjoa̱‑nò tsà tà jngoò hora kòbìtsa̱jnakon ko̱‑ná? ");
INSERT INTO maaNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Titsa̱jnakoòn koa̱ tìtsi'ba‑là Nainá mé‑ne nga mì si̱ìkijne‑nò kjoa̱ ts'e̱ jé. Xi o̱kixi̱, jé ini̱ma̱‑nò tíjnandaà‑né ta̱nga jè yijo‑nò xi tsjìn‑la̱ nga'ñó. ");
INSERT INTO maaNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Xi ma‑ne jò k'a kiì ìjngoò k'a Jesús nga kiì kítsi'ba. Kitsò: ―Ji̱ xi Na̱'èn‑na̱ xan‑lè, tsà mìkiì ko̱ma tjáxìn‑na kjo̱'in koi, ko̱s'ín kàtitasòn koni s'ín mejèn‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","K'e̱ nga j'iì ìjngoò k'a‑ne, jñà xi̱ta̱ xi kota'yàt'aà‑la̱, tákó kjiyijòfè‑né nga 'ñó nijñá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Komà jàn k'a nga kiì kítsi'ba. Ya̱á kisìkítsa̱jna xi̱ta̱ xi kota'yàt'aà‑la̱. Tákó k'oa̱á ti̱ kitsò nga tsibítsi'ba. ");
INSERT INTO maaNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","J'iì ìjngoò k'a‑ne ya̱ ñánda títsa̱jna xi̱ta̱ xi kota'yàt'aà‑la̱. Kitsò‑la̱: ―¿A tákó titsa̱nìkjáya‑nò ko̱ titsa̱fè‑nò? Jyeé ijchò hora‑la̱, 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, ya̱á ko̱nga̱tsja jñà xi̱ta̱ jé. ");
INSERT INTO maaNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ti̱sítje̱en, chítsejèn‑là, tíkjiaán, jyeé nchrobá chrañà jè xi si̱ìnga̱tsja‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tákó ti̱k'e̱é tíchja̱‑ìsa Jesús nga ijchò Judas xi ya̱ itjojiìn ts'e̱ xi̱ta̱‑la̱ Jesús xi tejò ma‑ne. Kjìn xi̱ta̱ tji̱ko̱ xi 'ya ki̱cha̱ ndojò ko̱ yá. Jñà kisìkasén xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ jchínga xi ts'e̱ xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, jè xi tsatíjna Jesús, ítjòn tsibéno̱jmí‑la̱ kós'ín ko̱kò‑la̱ Jesús. Kitsò‑la̱: ―Jè xi skíne̱'a, jè‑né xi ti̱ndo̱ba̱'ñó. ");
INSERT INTO maaNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ni̱to̱ón kiì kasìt'aà chrañà‑la̱ Jesús. Kitsò‑la̱: ―Ndaà‑lè Maestro. I̱kjoàn kiskine'a. ");
INSERT INTO maaNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús kitsò‑la̱: ―Amigo, ¿mé xá kjoi̱‑ne? Jñà xi̱ta̱ xi tji̱ko̱ Judas, ni̱to̱ón kitsobà'ñó Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jngoò xi̱ta̱ xi ti̱koa̱ ya̱ tsóhoko̱ Jesús, tsachrje ki̱cha̱ ndojò‑la̱. Tsajá‑la̱ jè xi̱ta̱ chi̱'nda‑la̱ no̱'miì ítjòn; tsatet'aà líká‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús kitsò: ―Ti̱kájnatjoì ki̱cha̱ ndojò‑lè ya̱ i̱'nde‑la̱; jñà xi ki̱cha̱ ska̱àn‑ne nga si̱ìk'en xíkjín, ngásòn ki̱cha̱ ki̱yá ngajo‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿A mì 'ya‑jèn tsà 'a̱n si̱jé‑la̱ Na̱'èn‑na̱, tsatoó tejò jmiì àkja̱le̱ ni̱to̱ón si̱ìkasén‑na? ");
INSERT INTO maaNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ta̱nga tsà k'oa̱s'ín si̱jé, mìkiì ki̱tasòn koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá nga mochjeén‑né nga k'oa̱s'ín ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jesús kitsò‑la̱ jñà xi̱ta̱ xi kjìn ma‑ne: ―¿Mé‑ne ko̱s'ín kòf'iì ndobà'ñó‑ná nga ko̱ ki̱cha̱ ko̱ yá kich'à koni tsà jngoò xi̱ta̱ chijé? Na̱chrjein nchijòn tìjna̱ko̱‑nò ján i̱ngo̱ ítjòn nga okoòya‑nò ko̱ mìkiì kindobà'ñó‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","K'oi̱í kjoa̱‑la̱ o̱ko̱ma‑ne nga ki̱tasòn 'én xi tjít'aà xo̱jo̱n‑la̱ jñà xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. Ti̱k'e̱é‑né ngats'iì xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús tsanga ko̱ kitsjeiìn takòn. ");
INSERT INTO maaNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jñà xi̱ta̱ xi kitsobà'ñó Jesús kiìko̱ ñánda tíjna Caifás xi no̱'miì ítjòn. Ya̱á títsa̱jna xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés ko̱ xi̱ta̱ jchínga‑la̱ xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jè Pedro, tà kjiìn tà kjiìn tsajmeètji̱ngui‑la̱ skanda ijchò ndi̱tsin ni'ya‑la̱ no̱'miì ítjòn. Jahas'en ni'ya. Ya̱á tsibìjnat'aà‑la̱ ñánda títsa̱jna xi̱ta̱ xi síkinda̱ ni'ya i̱ngo̱ nga mejèn‑la̱ skoe̱ kós'ín ko̱ma nga kjoe̱het'aà kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ jchínga, ngats'iì xi̱ta̱ xi tjín‑la̱ xá ts'e̱ xi̱ta̱ judío, tsohótsji'nde‑la̱ nga tsját'in 'én xi kondra̱ ts'e̱ Jesús mé‑ne nga ko̱ma si̱ìnga̱tsja‑ne xi̱ta̱ Roma nga si̱ìk'en Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ta̱nga ni̱mé 'én kisakò‑la̱ na̱s'ín ijchò xi̱ta̱ ndiso xi kondra̱ ts'e̱. Xi komà i̱skan ijchò jò xi̱ta̱ ndiso ");
INSERT INTO maaNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","xi kitsò: ―Xi̱ta̱ jè kitsò‑né: “'A̱n, ko̱ma‑na nga sìhixòña i̱ngo̱ ítjòn‑la̱ Nainá koa̱ jàn na̱chrjein kìndàyà ìjngoò k'a‑na.” ");
INSERT INTO maaNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","K'e̱é tsasìjna kixi̱ jè no̱'miì ítjòn. Kitsò‑la̱ Jesús: ―¿A nìmé 'én nokjoì, koni tsò 'én xi tsjá xi̱ta̱ koi xi kondra̱ tsi̱ji? ");
INSERT INTO maaNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús mìkiì kiìchja̱. Jè no̱'miì ítjòn kitsò‑la̱: ―Tèno̱jmí kixi̱ nga nguixko̱n Nainá xi tíjnakon. Ko̱t'ìn‑náje̱n. ¿A ngaji̱‑né xi Cristo xi̱ta̱ xi xó kisìkasén‑lè Nainá nga Ki'ndí‑la̱ mai? ");
INSERT INTO maaNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús kitsò‑la̱: ―Ngaji̱í xi k'oa̱ si nga 'a̱n‑ná. Ti̱koa̱, k'oa̱á xán‑nò, jñò jcha̱‑ná xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ nga kóti̱jnat'aà kixi̱‑la̱ ñánda tíjna Nainá xi 'ñó tse nga'ñó tjín‑la̱. Ti̱koa̱á jcha̱‑ná k'e̱ nga kji̱nchrobàjñaà i̱jiìn ifi xi ts'e̱ ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jè no̱'miì ítjòn tsatijndajno yijo‑la̱ nikje‑la̱ xi íkjá nga 'ñó kòjti‑la̱, kitsò: ―Xi̱ta̱ jè, jyeé kà'yaà nga chja̱jno‑la̱ Nainá koni tsò 'én xi chja̱. ¿Mé s'e̱én‑ìsa̱‑ná xi̱ta̱ xi kj'ei̱í xi tsjá 'én? Jñá, jyeé kàna'yà‑lá koni s'ín chja̱jno‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Jñò, kó bixón, mé xi si̱koa̱á? Ngats'iì xi̱ta̱ kitsò: ―Tjín‑la̱ jé, ok'ín‑la̱ nga si̱k'en. ");
INSERT INTO maaNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","I̱kjoàn tsibíchrá'a ko̱ tsi'beé‑la̱. Koa̱ tjín xi i̱sén‑la̱ tsi'beé'a, ");
INSERT INTO maaNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kitsò‑la̱: ―Ji̱ Cristo xi xó kisìkasén‑lè Nainá, ko̱t'ìn‑náje̱n, ¿yá xi tí'beé‑lè? ");
INSERT INTO maaNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jè Pedro k'e̱ nga tíjna ndi̱tsin ni'ya, ijchòkon jngoò chjo̱ón chi̱'nda xi kitsò‑la̱: ―Ti̱koa̱á ngaji̱, ya̱á tjaàkoi̱i Jesús xi Galilea i̱'nde‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ta̱nga jè Pedro tsoho'mat'in‑né nga nguixko̱n ngats'iì xi̱ta̱. Kitsò: ―Mìkiì be mé 'én xi tinokjoì. ");
INSERT INTO maaNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jè Pedro jyeé tíbitjo xotjoa̱ ni'ya k'e̱ kijtseè ìjngoò chjo̱ón xi k'oa̱ ti kitsò‑la̱ jñà xi̱ta̱ xi ya̱ títsa̱jna. Kitsò: ―Xi̱ta̱ jè, ti̱koa̱á ya̱ tsóhoko̱ Jesús xi Nazaret ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro ìjngoò k'a tsoho'mat'in. Kitsò: ―¡Tíbeè Nainá, mìkiì bexkoan xi̱ta̱ jè! ");
INSERT INTO maaNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nga komà i̱skan jñà xi̱ta̱ xi ya̱ títsa̱jna ijchòkon ñánda tíjna Pedro. Kitsò‑la̱: ―O̱kixi̱‑né, ti̱koa̱á ngaji̱ xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús‑né. 'Yaà‑lè; k'oa̱á ti̱s'ín nokjoì. ");
INSERT INTO maaNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","K'e̱é ìsa̱ 'ñó kiìchja̱ Pedro kitsò: ―¡Beè Nainá, na̱s'ín ti̱k'eèn‑ná, mìkiì bexkoan xi̱ta̱ jè! Ti̱k'e̱‑ne kiskindàya jngoò kóxtí. ");
INSERT INTO maaNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","K'e̱é tsibítsjeèn‑la̱ Pedro koni kitsò‑la̱ Jesús: “K'e̱ ti̱kj'eè kjindáya kóxtí, ngaji̱, jàn k'a tsjá'mat'in‑ná.” K'e̱é itjo ni'ya Pedro, jàn ndi̱tsiaán; ndaà jchán kiskindàya. ");
INSERT INTO maaNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","K'e̱ nga kis'e i̱sén, ngats'iì xi̱ta̱ sko̱‑la̱ no̱'miì, jñà xi̱ta̱ jchínga ts'e̱ xi̱ta̱ judío tsajoóya‑ne nga kondra̱ kjoi̱‑la̱ Jesús mé‑ne nga ko̱ma si̱ìnga̱tsja‑ne jñà xi̱ta̱ Roma nga si̱ìk'en. ");
INSERT INTO maaNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tsibít'aà'ñó, kiìko̱ nga kisìnga̱tsja Pilato xi xi̱ta̱xá gobernador tíjna ts'e̱ Roma. ");
INSERT INTO maaNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, jè xi tsatíjna Jesús, k'e̱ nga jye kijtseè nga jye kitjoòt'in kjoa̱ nga ki̱yá, 'ñó kokájno‑la̱ kjoa̱ xi kis'iìn koa̱ kisìkátji‑ne to̱n chroba xi katé ma‑ne jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ jchínga. ");
INSERT INTO maaNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kitsò‑la̱: ―Tseé jé tsohótsji‑la̱ yijo‑na̱ nga kisìnga̱tsja‑nò jngoò xi̱ta̱ xi ni̱mé jé tjín‑la̱. Ta̱nga jñà xi̱ta̱ koi kitsò: ―Ngaje̱n, mìkiì 'ya‑je̱n. Kjoa̱ tsi̱ji‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas tsibítsjo to̱n ya̱ i̱ngo̱ ítjòn. K'e̱é kiì tsibítjo̱hóngui yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì, kiskoé to̱n, kitsò: ―Mìkiì ko̱ma ya̱ si̱jngoaá to̱n xi tjíya kaxa̱‑la̱ to̱n kjo̱tjò‑la̱ Nainá. To̱n jè, chjí‑la̱ mik'en‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","K'e̱é tsajoóya‑ne nga jè to̱n jè, nanguií ko̱tse jngoò 'nde‑ne, xi 'mì: I̱'nde Ñánda Mandaà Ti̱jí, mé‑ne nga s'e̱‑ne i̱'nde ñánda ko̱ma si̱ìjiìn xi̱ta̱ xi xìn na̱xa̱ndá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","K'oi̱í kjoa̱‑la̱, skanda na̱chrjein i̱'ndei̱, tákó k'oa̱á 'mì i̱'nde jè nga I̱'nde‑la̱ Jní 'mì. ");
INSERT INTO maaNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","K'oa̱á s'ín tsitasòn koni s'ín kitsò Jeremías xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá nga kitsò: “Kiskoé to̱n chroba xi katé ma‑ne, koni tjín tsibíjna‑la̱ chjí‑la̱ jñà xi̱ta̱ Israel, ");
INSERT INTO maaNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ko̱ k'oa̱á s'ín kisìkjeén to̱n jè nga tsatse i̱'nde‑la̱ xi̱ta̱ xi ti̱jí bíndaà koni s'ín kitsjaà‑na o̱kixi̱ Nainá.” ");
INSERT INTO maaNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús, k'e̱ nga síjna nguixko̱n jè xi̱ta̱xá gobernador kiskònangui‑la̱, kitsò‑la̱: ―¿A ji̱‑né xi xi̱ta̱xá ítjòn‑la̱ jñà xi̱ta̱ judío? Jesús kitsò: ―Ngaji̱í xi k'oa̱ si nga 'a̱n‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","K'e̱ nga nchihóngui Jesús jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ jchínga‑la̱ xi̱ta̱ judío, Jesús ni̱mé 'én kiìchja̱. ");
INSERT INTO maaNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","K'e̱é kitsò Pilato, jè xi xi̱ta̱xá gobernador: ―¿A mì na'yà‑la̱ koni tsò‑lè? Kjìn 'én tsjá xi kondra̱ tsi̱ji. ");
INSERT INTO maaNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ta̱nga Jesús ni̱jngoò 'én kiìchja̱. K'oi̱í kjoa̱‑la̱ nga jè xi̱ta̱xá gobernador tà k'oa̱á komà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nga xki̱ nó k'e̱ nga bitjo s'eí Paxko̱, jè xi̱ta̱xá gobernador síkíjnandei̱í jngoò xi̱ta̱ xi títsa̱'ya nda̱yá, jè xi mejèn‑la̱ xi̱ta̱ na̱xa̱ndá nga kíjnandei̱í. ");
INSERT INTO maaNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ti̱k'e̱é‑ne tíjna'ya nda̱yá jngoò xi̱ta̱ xi 'ya‑la̱ nga 'ñó ts'e̱n xi 'mì Barrabás. ");
INSERT INTO maaNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","K'e̱ nga chixoña xi̱ta̱ na̱xa̱ndá, jè Pilato kiskònangui‑la̱, kitsò‑la̱: ―¿Yá‑né xi mejèn‑nò nga kíjnandei̱í? ¿A Barrabás‑né, o xi Jesús‑né xi Cristo 'mì‑là? ");
INSERT INTO maaNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Koií o̱kitsò‑ne Pilato nga jyeé tíjiìn‑la̱ nga tà kjoa̱xìtakòn‑né nga ya̱ ijchò sínga̱tsja Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jè Pilato k'e̱ nga tíjna ni'ya osen, jè chjo̱ón‑la̱ kisìkasén xá‑la̱, kitsò‑la̱: “Kiì ji̱ chingájiìn kjoa̱‑la̱ xi̱ta̱ kixi̱ jè. Na̱ti ni̱tje̱n, tsí 'ñó ch'o tsò nijñá xi kò'biì‑na i̱t'aà ts'e̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ta̱nga jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ jchínga, chinchá'a xi̱ta̱ na̱xa̱ndá nga kàtasíjé nga kàtìjnandei̱í Barrabás ko̱ kàtasík'en Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jè xi̱ta̱xá gobernador ìjngoò k'a kiskònangui‑la̱ jñà xi̱ta̱ na̱xa̱ndá; kitsò‑la̱: ―¿Ñá‑la̱á nga ingajò xi̱ta̱ koi xi mejèn‑nò nga sikíjnandia̱á? Jñà xi̱ta̱ na̱xa̱ndá kitsò: ―Jè Barrabás. ");
INSERT INTO maaNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato kiskònangui‑la̱ jñà xi̱ta̱ na̱xa̱ndá. Kitsò‑la̱: ―¿Mé xi si̱koa̱á Jesús xi Cristo 'mì‑là? Ngats'iì xi̱ta̱ na̱xa̱ndá kitsò: ―¡Kàtasit'aà krò! ");
INSERT INTO maaNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","K'e̱é kitsò Pilato: ―¿Mé jé xi tsohótsji, mé‑ne ki̱yá‑ne? Jñà xi̱ta̱, ìsa̱á 'ñó kiìchja̱, kitsò: ―¡Kàtasit'aà krò! ");
INSERT INTO maaNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","K'e̱ nga kijtseè Pilato nga nì mé kjoa̱ sindaàjiìn, tà ìsa̱á tímatse kjoa̱siì, kiskinìkjaá nandá nga tsaníjno tsja nga nguixko̱n xi̱ta̱ na̱xa̱ndá mé‑ne nga skoe̱‑ne jñà xi̱ta̱ nga ni̱mé jé tjín‑la̱. Kitsò: ―Ni̱mé jé tjín‑na xi i̱t'aà ts'e̱ xi̱ta̱ kixi̱ jè nga mejèn‑nò nìk'eèn. Kjoa̱ tsa̱jòn‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ngats'iì xi̱ta̱ kjìn kitsò: ―Kjoa̱biyaà‑la̱ xi̱ta̱ jè, kinda̱ tsa̱je̱n‑náje̱n ko̱ i̱xti‑na̱je̱n. ");
INSERT INTO maaNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato, k'e̱é kisìkíjnandei̱í Barrabás; k'e̱ nga jye kitsjaà o̱kixi̱ nga tsajá‑la̱ Jesús, i̱kjoàn kisìnga̱tsja nga si̱t'aà krò. ");
INSERT INTO maaNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jñà soldado‑la̱ xi̱ta̱xá gobernador kiìko̱ Jesús ján ni'ya osen. I̱kjoàn kiìchja̱ yije‑la̱ soldado xíkjín nga tsibìtsa̱jnandiì‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tsachrje nikje‑la̱ koa̱ kisìkjá jngoò nikje xi inì kji. ");
INSERT INTO maaNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","I̱kjoàn tsibí'a sko̱ jngoò corona na'yá xi jñà xó tsibíndaà‑ne, koa̱ jngoò yá tsohóya tsja kixi̱; k'e̱é chincha-xkó'nchit'aà‑la̱ nga kisìsobà‑la̱. Kitsò‑la̱: ―¡Viva xi̱ta̱xá ítjòn‑la̱ xi̱ta̱ judío! ");
INSERT INTO maaNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ti̱koa̱á tsibíchrájno koa̱ kiskoé yá xka̱jnchra̱ xi kjiya tsja, tsatjì sko̱. ");
INSERT INTO maaNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","K'e̱ nga jye kisìsobà‑la̱, jaàxìn‑la̱ nikje inì xi íkjá. I̱kjoàn kisìkákjá‑ne xi nikje ts'e̱. K'e̱é kiìko̱ nga ko̱sit'aà krò. ");
INSERT INTO maaNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","K'e̱ nga jye nchifìko̱ Jesús, kiskaàkjoò jngoò xi̱ta̱ xi Cirene i̱'nde‑la̱ xi 'mì Simón. Jñà soldado kjo̱'ñó kis'iìn‑la̱ nga kisìk'ajen krò‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","K'e̱ nga ijchòko̱ ya̱ i̱'nde ñánda 'mì Gólgota 'én xi tsòya‑ne i̱'nde sko̱ mik'en, ");
INSERT INTO maaNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ya̱á kitsjaà‑la̱ vino xi tsjájiìn‑la̱ ndá chikitsja. K'e̱ nga kiskoòt'aà Jesús mìkiì kits'iì. ");
INSERT INTO maaNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","K'e̱ nga jyeé tsasìt'aà krò, jñà soldado kisìskáko̱ nikje‑la̱ Jesús nga kisìka'bí‑la̱ xíkjín yá ts'e̱ ko̱ma. K'oa̱á s'ín tsitasòn 'én‑la̱ jè xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá nga kitsò: “Kisìka'bí nikje‑na̱ koa̱ kisìskáko̱ yá ts'e̱ ko̱ma.” ");
INSERT INTO maaNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","I̱kjoàn ya̱á tsibìtsa̱jna nga kisìkinda̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ya̱ i̱sòn sko̱ krò tsibít'aà 'én xi k'oa̱ kitsò mé jé xi komà‑la̱ nga kinìk'en. Jñà 'én koi, tsò: “Jè jèe̱ xi Jesús xi Xi̱ta̱xá Ítjòn‑la̱ xi̱ta̱ judío.” ");
INSERT INTO maaNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ti̱koa̱á kisit'aà krò jò xi̱ta̱ chijé. Jngoò kisit'aà nga kixi̱‑la̱ koa̱ jngoò kisit'aà nga ngaskón‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jñà xi̱ta̱ xi ya̱ ja, síkatji sko̱ nga kiìchja̱jno‑la̱, ");
INSERT INTO maaNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","kitsò‑la̱: ―Ji̱, k'oa̱á kisi nga si̱ixòñi i̱ngo̱ ítjòn‑la̱ Nainá ko̱ jàn na̱chrjein kíndaà ngajo‑ne; ti̱kíjnandei̱í yijo‑lè. Tsà kixi̱ kjoa̱ nga ji̱ xi Ki'ndí‑la̱ Nainá, chináje̱n‑t'i yijo‑lè krò. ");
INSERT INTO maaNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","K'oa̱á ti̱s'ín kisìsobà‑la̱ jñà xi̱ta̱ sko̱‑la̱ no̱'miì, ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, ko̱ xi̱ta̱ jchínga ts'e̱ xi̱ta̱ judío. Kitsò: ");
INSERT INTO maaNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Xi̱ta̱ jè, tsachrjekàjiìn kjo̱'in xi kj'ei̱í xi̱ta̱, ta̱nga jè xi yijo‑la̱, mìkiì ma ochrjekàjiìn kjo̱'in. Tsà kixi̱ kjoa̱ nga jè Xi̱ta̱xá Ítjòn‑la̱ Israel, kàtìtjojen‑t'aà krò mé‑ne nga ko̱kjeiín‑ná i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xi̱ta̱ jè, i̱t'aà ts'e̱ Nainá kjò'ñót'aà ikon. Tsà kixi̱í kjoa̱ tsjakeè Nainá, i̱'ndei̱, jè kàtasìko̱. Nga̱ k'oa̱á ti̱ kitsò nga Ki'ndí‑la̱ Nainá ma. ");
INSERT INTO maaNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Skanda jñà xi̱ta̱ chijé xi ti̱koa̱ ya̱ kjit'aà krò ti̱koa̱á tsatít'aà. ");
INSERT INTO maaNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","K'e̱ nga ijchò nchisen skanda xi jàn nga kjòhoxòn, kóho̱kji nga tíjtsa i̱sò'nde kòjñò. ");
INSERT INTO maaNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ti̱jè‑ne hora Jesús 'ñó kiìchja̱ nga kitsò: “Elí, Elí, ¿lama sabactani?” 'Én jè tsòya‑ne: Nainá, Nainá, ¿mé‑ne kàjneitakòn‑ná? ");
INSERT INTO maaNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tjín i'nga xi̱ta̱ xi ya̱ títsa̱jna xi kiì'nchré‑la̱, kitsò: ―Xi̱ta̱ jè, jé chja̱‑la̱ Elías. ");
INSERT INTO maaNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","K'e̱é tsangachikon jngoò xi kiìkjaá tsa̱nga̱; kisìka'nchi̱‑la̱ ko̱ vinagre; i̱kjoàn tsibísko̱‑la̱ ína̱xo̱; kitsjaà‑la̱ Jesús nga kàt'iì. ");
INSERT INTO maaNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ta̱nga kitsò xi̱ta̱ xi i'nga: ―Kiì k'oa̱ nìko̱, chítsejèn‑lá, ¿a kjoi̱í Elías nga skónáje̱n‑t'aà krò? ");
INSERT INTO maaNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús ìjngoò k'a 'ñó kiskindàya. I̱kjoàn k'en. ");
INSERT INTO maaNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jè nikje velo xi tjo̱hóya jngoò osen i̱ngo̱ ítjòn kixajndà. Jòya komà skanda i̱t'aà nangui; ts'a ch'ón koa̱ tsàkjàn na̱xi̱ ");
INSERT INTO maaNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","nga kitáx'a̱ jñà i̱tsjó‑la̱ mik'en. Kjìn xi̱ta̱ tsjeè‑la̱ Nainá jaáya‑la̱ xi kjòtseé k'en. ");
INSERT INTO maaNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jñà xi̱ta̱ mik'en xi itjo‑ne i̱tsjó‑la̱, k'e̱ nga ko̱ma i̱skan nga jaáya‑la̱ Jesús, xi̱ta̱ koi, jahas'en ya̱ na̱xa̱ndá tsjeè Jerusalén; kjìn xi̱ta̱ kijtseèxkon. ");
INSERT INTO maaNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jñà xi̱ta̱ xi nchisíkinda̱ Jesús ko̱ jé xi̱ta̱ sko̱‑la̱ soldado, k'e̱ nga kijtseè nga ts'a ch'ón, ngats'iì kjoa̱ xi komà, tsí ndaà kitsakjòn. K'e̱é kitsò: ―Kixi̱í‑là kjoa̱, xi̱ta̱ jèe̱, Ki'ndí‑la̱ Nainá‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ti̱koa̱á kjìn íchjín títsa̱jna xi kjiìn nchikotsejèn‑ne xi inchrobà‑tji̱ngui‑la̱ Jesús skanda ján Galilea nga kisìchját'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ya̱á títsa̱jna xi 'mì María Magdalena, María xi nea̱‑la̱ ma Jacobo ko̱ José, ko̱ nea̱‑la̱ i̱xti‑la̱ Zebedeo. ");
INSERT INTO maaNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","K'e̱ nga jye kòjñò, j'iì jngoò xi̱ta̱ nchi̱ná xi 'mì José. Ya̱á i̱'nde‑la̱ jè na̱xa̱ndá xi 'mì Arimatea. Xi̱ta̱ jè ti̱koa̱á ya̱á kiskoòta'yàt'aà‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","K'e̱é kiìchja̱‑la̱ Pilato nga kisìjé‑la̱ yijo‑la̱ Jesús. Jè Pilato kitsjaà o̱kixi̱ nga kàtatjoé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José kiskoé yijo‑la̱ Jesús; kisìkájté jngoò nikje sábana tsjeè. ");
INSERT INTO maaNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kiì kíhijiìn ya̱ nangui‑la̱ xi ts'e̱ José. Kiskinìs'engui jngoò nga̱jo̱ i̱tsjó xi̱tse̱ xi xó tsibíndaà‑ne ya̱ i̱ngui nguijo. I̱kjoàn tsohójtsa xotjoa̱‑la̱ nga̱jo̱ jngoò nda̱jo̱ teè; i̱kjoàn kiì‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jè María Magdalena ko̱ María xi ìjngoò, ya̱á tsibìtsa̱jnat'aà chrañà‑la̱ ñánda kisìhijiìn Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","K'e̱ nga komà inchijòn, jè na̱chrjein nìkjáya, jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ fariseo kiìkon Pilato. ");
INSERT INTO maaNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kitsò‑la̱: ―Na̱'èn, bítsjeèn‑na̱je̱n, jè xi̱ta̱ ndiso jèe̱, k'e̱ nga sa̱ tsibìjnakon kitsò‑né: “K'e̱ nga ki̱jchò jàn na̱chrjein kjoa̱áya‑na.” ");
INSERT INTO maaNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","K'oi̱í kjoa̱‑la̱ kàtamakinda̱ i̱tsjó‑la̱ skanda k'e̱ ko̱ma jàn na̱chrjein nga mì ya̱á ki̱jchò xi̱ta̱‑la̱ xi kota'yàt'aà‑la̱ k'e̱ nga ni̱tje̱n nga kji̱ko̱ chijé yijo‑la̱. I̱kjoàn ki̱tso̱ jñà xi̱ta̱‑la̱ nga ke̱èno̱jmí‑la̱ jñà xi̱ta̱ na̱xa̱ndá: “Jyeé jaáya‑la̱ xi i̱t'aà ts'e̱ kjoa̱biyaà.” Koa̱ ìsa̱á ch'o komà 'én ndiso koi koni jñà xi ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kitsò Pilato: ―Ya̱ títsa̱jna soldado. Tanguió ti̱kinda̱a. 'Ñó tichjoà jè i̱tsjó nga 'ñó kàtas'e. ");
INSERT INTO maaNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","K'e̱é kiì nga tsibíchjoà'ñó jè i̱tsjó koa̱ tsasén jngoò‑la̱ sello ya̱ i̱sò'nga‑la̱ nda̱jo̱ xi kijtsa. I̱kjoàn kisìkítsa̱jna soldado xi kisìkinda̱. ");
INSERT INTO maaNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","K'e̱ nga jye tsato na̱chrjein nìkjáya, nga jye tís'e i̱sén jè na̱chrjein tahàngo̱ nga tàts'en xomàna̱, kiì María Magdalena ko̱ María xi ìjngoò nga kiì katsejèn‑la̱ i̱tsjó‑la̱ ñánda kisìhijiìn Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","K'e̱ nga itjokàjen jngoò àkja̱le̱‑la̱ Nainá xi inchrobà‑ne ngajmiì, tà ni̱to̱ón ts'a jngoò ch'ón xi 'ñó ts'a nga jaàxìn jè nda̱jo̱ xi kijtsa nga̱jo̱ i̱tsjó; ya̱á tsibìjnasòn. ");
INSERT INTO maaNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jè àkja̱le̱ ote kji koni jngoò ni'ín ch'o̱n; ko̱ jè nikje‑la̱ xi íkjá, chroba kji koni kjoàn 'nchán. ");
INSERT INTO maaNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jñà soldado k'e̱ nga kijtseè, tsí ndaà kitsakjòn‑la̱. Tsí chi̱ba̱‑la̱ tsatsé‑né koa̱ ya̱á k'en‑ña. ");
INSERT INTO maaNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jè àkja̱le̱ kitsò‑la̱ jñà íchjín: ―Kì tsakjoòn‑jèn. Be‑ná, jè binchaàtsjioò Jesús xi kisit'aà krò. ");
INSERT INTO maaNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mì ti̱ i̱í tíjna‑ne. Jyeé kòfaáya‑la̱ koni s'ín kitsò nga kjoa̱áya‑la̱. Nchrobá chìtsejèn‑là i̱'nde‑la̱ ñánda kisijna. ");
INSERT INTO maaNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ni̱to̱ón tanguió, koa̱tìn‑là xi̱ta̱ xi kota'yàt'aà‑la̱: “Jyeé kòfaáya‑la̱. Jè, ya̱á tífì ítjòn‑nò ján Galilea. Ya̱á jcha̱xkoòn ìjngoò k'a.” Ta̱ k'oa̱á tjín 'én xi tsja‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jñà íchjín ni̱to̱ón itjongui‑ne nguijo; kiì tsangachikon; o̱kji tsakjón koa̱ o̱kji 'ñó tsja s'e‑la̱ nga kiì kéno̱jmí‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","K'e̱ nga nchifì íchjín, tà ni̱to̱ón kisatiìkjoò Jesús koa̱ kisìhixat'aà. Jñà íchjín, kiì kinchat'aà chrañà‑la̱, i̱kjoàn chincha-xkó'nchit'aà‑la̱ nga kijtseèxkón, k'e̱é kitsohòkjá ndso̱ko̱. ");
INSERT INTO maaNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús kitsò‑la̱: ―Kì tsakjoòn‑jèn. Tanguió ti̱kí'nchré jñà 'ndsè mé‑ne nga kàtjì‑ne ján Galilea. Ya̱á skoe̱ ìjngoò k'a‑na. ");
INSERT INTO maaNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","K'e̱ nga nchifì‑ne jñà íchjín, ti̱koa̱á kiì i'nga‑ne jñà soldado xi kisìkinda̱ jé i̱tsjó; kiì ján jngoò osen na̱xa̱ndá nga kiì kéno̱jmí‑la̱ jñà xi̱ta̱ sko̱‑la̱ no̱'miì ngats'iì kjoa̱ xi komà. ");
INSERT INTO maaNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì kiìkáko̱ jñà xi̱ta̱ jchínga. K'e̱ nga jye tsajoóya‑ne, tseé to̱n kitsjaà‑la̱ jñà soldado, ");
INSERT INTO maaNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","i̱kjoàn kitsò‑la̱: ―Jñò, k'oa̱á tixón: “K'e̱ nga ijchò osen ni̱tje̱n nga titsa̱yijòfè‑je̱n, jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús ijchòkjaá chijé yijo‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tsà kji̱'nchré jè xi̱ta̱xá gobernador nga titsa̱yijòfè, ngaje̱én onguíchoòn‑je̱n mé‑ne nga mì kjo̱'in tsjá‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jñà soldado kiskoé to̱n xi kitsjaà‑la̱ ko̱ k'oa̱á s'ín kitsò koni s'ín ki'mì‑la̱. Skanda na̱chrjein i̱'ndei̱ tákó k'oa̱á tsò jñà xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús xi nguì tejngoò ma‑ne, kiì ján Galilea ya̱ nindoò ñánda nga o̱kitsò‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","K'e̱ nga kijtseè Jesús, chincha-xkó'nchit'aà‑la̱ nga kijtseèxkón. Ta̱nga tjín i'nga xi mìkiì kòkjeiín‑la̱ tsà jè‑né. ");
INSERT INTO maaNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús, k'e̱é kiì kasìt'aà chrañà‑la̱, kitsò‑la̱: ―Jyeé kitjoé yije‑na nga'ñó nga 'a̱n kotiìxoma ngajmiì ko̱ i̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tanguíchòn yije xi̱ta̱ xi tjín nga tíjtsa na̱xa̱ndá xi tjín i̱sò'nde; ta̱kóya‑là nga i̱t'aà ts'a̱n kàtakota'yà; t'e̱en bautizar i̱t'aà ts'e̱ 'ín‑la̱ Na̱'èn‑ná ko̱ ts'e̱ Ki'ndí‑la̱ koa̱ ko̱ ts'e̱ Ini̱ma̱ Tsjeè‑la̱ Nainá; ");
INSERT INTO maaNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ta̱kóya‑là nga kàtasíkitasòn yije kjoa̱ xi 'a̱n tsakoòya‑nò. Kì nìjchàajiìn‑jèn nga 'a̱án tìjna̱ko̱‑nò na̱chrjein inchijòn skanda k'e̱ nga kjoe̱het'aà i̱sò'nde. K'oa̱á s'ín kàtama.");
INSERT INTO maaNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","I̱ mats'ia̱‑ne 'én ndaà‑la̱ Jesucristo xi Ki'ndí‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","K'oa̱á s'ín komà koni s'ín tjít'aà xo̱jo̱n‑la̱ Isaías xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá nga kitsò: 'A̱n, sìkasén ítjòn‑lè xi̱ta̱‑na̱ xi kji̱ko̱ 'én, jè xi koi̱ìndaàya ítjòn‑lè ndi̱yá‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Na'yà‑la̱ jta̱‑la̱ jngoò xi̱ta̱ xi 'ñó chja̱ ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn, nga tsò: “Tjandaà ndi̱yá‑la̱ Nainá ya̱ i̱jiìn ini̱ma̱‑nò; kixi̱ ti̱kájna koni jngoò ndi̱yá ñánda ko̱jmeèya Na̱'èn‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","K'oa̱á s'ín komà; j'iì jè Juan nga kis'iìn bautizar xi̱ta̱ ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn. Kiìchja̱ya nga kàtasíkájno jé‑la̱ jñà xi̱ta̱ nga mì ti̱ jé ko̱hótsji‑ne, i̱kjoàn kàtas'ín bautizar yijo‑la̱ mé‑ne nga si̱ìjchàat'aà‑la̱ Nainá jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kjìn xi̱ta̱ ijchò 'nchré‑la̱ Juan xi inchrobà‑ne nangui Judea ko̱ na̱xa̱ndá Jerusalén. K'e̱ nga jye jahatakòn jé‑la̱ jñà xi̱ta̱, jè Juan kis'iìn bautizar ya̱ nandá xa̱jngá nandá Jordán. ");
INSERT INTO maaNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nikje xi tsohòkjá Juan, tsja̱‑la̱ cho̱ camello‑né; ko̱ jngoò sincho̱ chrjoa̱ tsibíkjá ndáyá‑la̱; tsojmì xi kiskine Juan, jñà cho̱ langosta, ko̱ tsjén‑la̱ cho̱ cera xi tjín i̱jiìn ijñá. ");
INSERT INTO maaNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","K'oa̱á s'ín kiìchja̱ nga tsò: ―Ìjngoò nchrobátji̱ngui‑na xi ìsa̱ tse nga'ñó tjín‑la̱ mì k'oa̱à‑ne koni 'a̱n, skanda mì kì tjí'nde‑na nga kósi̱ñiat'aà‑la̱ nga skíjnda̱ jè xo̱x'ín‑la̱ xo̱jté‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kixi̱í kjoa̱ 'a̱n, ta nandá s'iìn‑na bautizar xi̱ta̱, ta̱nga jè xi sa̱ nchrobátji̱ngui‑na, ko̱ó Ini̱ma̱ Tsjeè‑la̱ Nainá s'iìn‑nò bautizar. ");
INSERT INTO maaNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jngoò na̱chrjein j'iì‑ne Jesús ya̱ Nazaret, nangui xi chja̱‑ne Galilea; i̱kjoàn jè Juan kis'iìn bautizar ya̱ nandá xa̱jngá nandá Jordán. ");
INSERT INTO maaNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","K'e̱ nga itjokàjiìn‑ne nandá Jesús, ni̱to̱ón kijtseè nga kitáx'a̱ ngajmiì koa̱ jè Ini̱ma̱ Tsjeè‑la̱ Nainá inchrobàjen 'nè‑la̱ koni jngoò ni̱se paloma. ");
INSERT INTO maaNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Koa̱ kina'yà jngoò‑la̱ 'én xi ngajmiì inchrobà‑ne xi kitsò: ―Ji̱‑né xi ki'ndí‑na̱, xan‑lè, xi 'ñó matsjake̱‑lè, tsja tjín‑la̱ takoàn i̱t'aà tsi̱ji. ");
INSERT INTO maaNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nga komà i̱skan jè Ini̱ma̱ Tsjeè‑la̱ Nainá kisìkasén Jesús ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn. ");
INSERT INTO maaNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ichán na̱chrjein tsibìjna; tsibìjnajiìn‑la̱ cho̱ ts'e̱n ko̱ jè xi̱ta̱ nei̱í kiskoòt'aà nga mejèn‑la̱ nga kàtátsji jé. Ta̱nga jñà àkja̱le̱ kisìs'in‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","K'e̱ nga jye kiì nda̱yá Juan xi kis'iìn bautizar xi̱ta̱, Jesús kiì ján Galilea nga kiìchja̱ya 'én ndaà‑la̱ Nainá koni s'ín otíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kitsò: ―Jye kjòchrañàt'aà‑nò na̱chrjein nga jcha̱a kós'ín otíxoma Nainá. Ti̱kájno jé‑nò, kì ti̱ jé binchaàtsji‑nò; kàtakjeiín‑nò 'én ndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús, k'e̱ nga ja i̱ndiì ndáchikon Galilea, kijtseè xi 'mì Simón ko̱ 'ndse̱ Andrés nga nchisíkatje̱n‑nguindá na̱'ya‑la̱. Xi̱ta̱ koi, ti̱ín sík'en. ");
INSERT INTO maaNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús kitsò‑la̱: ―Nchrobátji̱ngui‑ná, 'a̱n tsjaà‑nò xá nga kíxkóya xi̱ta̱ xi 'a̱n kjìt'aà‑na koni s'ín maxkóya ti̱n k'e̱ nga nìk'eèn. ");
INSERT INTO maaNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jñà xi̱ta̱ koi ni̱to̱ón kisìkájna na̱'ya‑la̱ nga kiìtji̱ngui‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ìsa̱ xijngoaà ìsa̱, Jesús kijtseè xi 'mì Jacobo ko̱ 'ndse̱ Juan, i̱xti‑la̱ Zebedeo nga títsa̱ya chitso; nchibíndaàya na̱'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ti̱koa̱á ni̱to̱ón kiìchja̱‑la̱ xi̱ta̱ koi; ya̱á kiìtji̱ngui‑la̱ Jesús; kisìkíjna Zebedeo xi na̱'èn‑la̱ ma, ko̱ xi̱ta̱ chi̱'nda xi síxáko̱ ya̱ i̱ya chitso. ");
INSERT INTO maaNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ijchò na̱xa̱ndá Capernaum; k'e̱ nga jye ijchò na̱chrjein nìkjáya, jahas'en ni'ya i̱ngo̱ sinagoga ts'e̱ xi̱ta̱ judío; i̱kjoàn tsakóya 'én‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jñà xi̱ta̱, tà k'oa̱á komà‑la̱ koni tsò 'én xi tsakóya. K'oa̱á s'ín tsakóya koni jngoò xi̱ta̱ xi 'ñó tjín‑la̱ kjo̱tíxoma; mìtsà k'oa̱s'ín tsakóya koni xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. ");
INSERT INTO maaNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ya̱ ni'ya i̱ngo̱ sinagoga tíjna jngoò xi̱ta̱ xi ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱. 'Ñó kiìchja̱ nga kitsò: ");
INSERT INTO maaNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Ji̱ Jesús, xi Nazaret tsi̱ji, ¿mé xi mejèn‑lè? ¿Mé xi binchaàtsji? ¿A kòf'i̱ nìkjehesòn‑náje̱n? Bexkon‑lè; ji̱‑né xi Xi̱ta̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ta̱nga Jesús tsohótiko̱ jè ini̱ma̱ cho̱‑la̱ nei̱í, kitsò‑la̱: ―Jyò ti̱jni, titjo̱jiìn ini̱ma̱‑la̱ xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jè ini̱ma̱ cho̱‑la̱ nei̱í kisìkatsé koa̱ kiskindàya xá, i̱kjoàn itjojiìn ini̱ma̱‑la̱ xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ngats'iì xi̱ta̱ xi títsa̱jna, tà k'oa̱á ko̱ma‑la̱; xki̱ xi ján tsohóko̱ xíkjín; kitsò: ―¿Mé kjoa̱‑ne koi? Jngoò kjoa̱ xi̱tse̱ okóya xi tjín‑la̱ kjo̱tíxoma. Skanda jñà ini̱ma̱ cho̱‑la̱ nei̱í tsjá‑la̱ o̱kixi̱, ko̱ 'nchréñijon‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jesús, ni̱to̱ón kina'yà‑la̱ kóho̱kji nga jngoò itjandiì nangui xi chja̱‑ne Galilea. ");
INSERT INTO maaNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesús, k'e̱ nga itjo‑ne ni'ya i̱ngo̱ sinagoga, kjihijtako̱ Jacobo ko̱ Juan, ni̱to̱ón kiì ya̱ ni'ya‑la̱ ñánda tíjna Simón ko̱ Andrés. ");
INSERT INTO maaNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jè na̱chíya‑la̱ Simón, kijna xk'én‑né. Ch'in tìjnga tjín‑la̱. Ni̱to̱ón kis'eno̱jmí‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","I̱kjoàn kiìkasìt'aà chrañà‑la̱; kitsobà'ñó tsja; kisìkasítje̱n. Ko̱ ni̱to̱ón kitjaàxìn‑la̱ ch'in tìjnga. I̱kjoàn chjo̱ón jè, kisìs'in‑la̱ Jesús ko̱ xi̱ta̱ xi kjihijtako̱. ");
INSERT INTO maaNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","K'e̱ nga jye kiskaàtjì ts'oí nga jye kòjñò, j'iìko̱‑la̱ Jesús ngats'iì xi̱ta̱ xk'én ko̱ xi ini̱ma̱ cho̱‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ngats'iì xi̱ta̱ na̱xa̱ndá, ya̱á kitseèjto xotjoa̱ ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús, kjìn jchán xi̱ta̱ kisìndaà‑ne xi kjìn ska̱ya ch'in tjín‑la̱ ti̱koa̱á tsachrjekàjiìn ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ xi̱ta̱; Jesús mìkiì kitsjaà'nde nga jñà nei̱í kiìchja̱ nga jñà ini̱ma̱ ch'o‑la̱ nei̱í jyeé beèxkon yá‑né Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","'Ñó ta̱jñòya tsasítje̱n Jesús; tákó jñò‑ìsa nga itjojiìn na̱jnchra̱; kiì jngoò i̱'nde i̱t'aà xìn ñánda tsjìn xi̱ta̱ nga kiìchja̱t'aà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón ko̱ xi̱ta̱ xíkjín xi i'nga, kiì kátsji Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","K'e̱ nga jye kisakò‑la̱ ñánda tíjna Jesús, kitsò‑la̱: ―Ngats'iì xi̱ta̱, ji̱í ótsji‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kiìchja̱ Jesús, kitsò: ―Ti̱koa̱ tíkjiaán jñà na̱xa̱ndá chrañàt'aà nga kichjàya 'én‑la̱ Nainá nga koií xá j'i̱‑na. ");
INSERT INTO maaNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","K'oa̱á s'ín tsajmeè Jesús kóho̱kji i̱'nde Galilea nga kiìchja̱ya 'én‑la̱ Nainá ya̱ ni'ya i̱ngo̱ sinagoga nga xki̱ xi ján na̱xa̱ndá. Ti̱koa̱á tsachrjekàjiìn‑ne ini̱ma̱ cho̱‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","J'iìkon jngoò xi̱ta̱ xi tíbindojno chrjoa̱ yijo‑la̱. Tsasèn-xkó'nchit'aà‑la̱ Jesús, tsibítsi'ba‑la̱, kitsò‑la̱: ―Tsà mejèn‑lè, ti̱tsjeè‑ná ch'in xi tjín‑na. ");
INSERT INTO maaNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús kjòhi̱ma̱keè‑né, tsijmeé tsja nga tsohót'aà‑la̱ yijo‑la̱ xi̱ta̱ jè, kitsò‑la̱: ―Mejèn‑na, kàtandaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ti̱k'e̱é‑ne nga tíchja̱ Jesús, ni̱to̱ón kjòndaà‑ne; kitjaàxìn‑la̱ ch'in; kjòtsjeè‑ne yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús kisìhixat'aà xi̱ta̱ jè nga kiì‑ne. Ta̱nga ítjòn 'ñó tsibít'in‑la̱, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Ti̱ná'yi, kì yá xi̱ta̱ bèno̱jmí‑la̱. T'in ñánda tíjna no̱'miì, ta̱kó‑la̱ yijo‑lè nga jye kjòndaà‑ne; jch'i̱i kjo̱tjò‑lè, tsojmì xi síjé kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, mé‑ne nga tsjeè kijna‑ne nguixko̱n Nainá ti̱koa̱ skoe̱ jñà xi̱ta̱ nga jye kjòndaà‑ne ch'in‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ta̱nga xi̱ta̱ jè, k'e̱ nga kiì‑ne, tsibíts'ia̱ nga tsibéno̱jmí yije kós'ín komàt'in. K'oa̱á komà‑ne nga jè Jesús, mì ti̱ kiì ma ta̱xki̱ jahas'en‑jiìn‑ne jñà na̱xa̱ndá; ya̱á tsibìjna ñánda tsjìn xi̱ta̱. Ta̱nga jñà xi̱ta̱ xi xki̱ xi ján i̱'nde inchrobà‑ne, ya̱á ijchòkon ñánda tíjna Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Xi komà jò jàn na̱chrjein, ijchò ìjngoò k'a Jesús ján na̱xa̱ndá Capernaum. Kiì'nchré xi̱ta̱ nga ya̱ tíjna Jesús ya̱ ni'ya jè. ");
INSERT INTO maaNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ti̱k'e̱‑ne kjìn jchán xi̱ta̱ ijchò maxkót'aà‑la̱ skanda mì ti kiì tsì'ndè‑ne xotjoa̱ ni'ya. Jesús kiìchja̱yajiìn‑la̱ 'én ndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jngoò xi̱ta̱ j'iìko̱ xi mìkiì ma síhiníyá yijo‑la̱. Ñijòn xi̱ta̱ yangui. ");
INSERT INTO maaNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nga mìkiì komà kitjò'nde‑la̱ nga jahas'en ya̱ xotjoa̱ ni'ya, nga 'ñó kjìn xi̱ta̱ títsa̱jna, ya̱á kiskíx'a̱ i̱tsjá ni'ya ya̱ kixi̱‑la̱ ñánda tíjna Jesús. Ya̱á kiskinìjen‑ne jè xi̱ta̱ xi xk'én xi kjiya‑la̱ yá. ");
INSERT INTO maaNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús, k'e̱ nga kijtseè nga jñà xi̱ta̱ koi mokjeiín‑la̱ i̱t'aà tse, kitsò‑la̱ jè xi̱ta̱ xi xk'én: ―Ji̱ ndí na̱'èn, jé‑lè jye kichàat'aà‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ya̱ títsa̱jna i'nga xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés nga nchisíkítsjeèn i̱jiìn ini̱ma̱‑la̱. Kitsò: ");
INSERT INTO maaNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Mé‑ne ko̱s'ín chja̱‑ne jè xi̱ta̱ jè nga Nainá chja̱jno‑la̱? Nga ta̱jngoò Nainá síjchàat'aà‑ná jé‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ti̱k'e̱ kijtseèya‑la̱ Jesús koni s'ín nchisíkítsjeèn i̱jiìn ini̱ma̱‑la̱. Kitsò‑la̱: ―¿Mé‑ne ko̱tsò‑ne kjo̱hítsjeèn‑la̱ ini̱ma̱‑nó? ");
INSERT INTO maaNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Mé xi ìsa̱ chiba 'in tjín? Tsà xan‑la̱ jè xi̱ta̱ xi xk'én: “Jé‑lè jye kàchàat'aà‑lè”, o tsà xán‑la̱: “Chjoí na̱chan‑lè, ti̱sítji̱in, ti̱tjeí.” ");
INSERT INTO maaNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kokoò‑nò nga 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, tjí'ndeé‑na nga sìjchàat'aà‑la̱ jé‑la̱ xi̱ta̱ i̱ i̱sò'nde. K'e̱é kitsò‑la̱ jè xi̱ta̱ xi xk'én: ");
INSERT INTO maaNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Ji̱, k'oa̱á xan‑lè: Ti̱sítji̱in, chjoí na̱chan‑yá‑lè, t'in‑ne ni'ya‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","K'e̱é tsasítje̱n jè xi̱ta̱ xk'én. Kiskoé na̱chan‑la̱. Itjojiìn‑la̱ ngats'iì xi̱ta̱ xi títsa̱jna. K'e̱ nga kijtseè kjoa̱ koi, tà kjòxkón‑la̱ ngats'iì xi̱ta̱. K'e̱é jeya kisìkíjna Nainá. Kitsò: ―Ni̱ sa̱á jngoò k'a 'yaá jngoò kjoa̱ xi ko̱s'ín ma. ");
INSERT INTO maaNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesús, ìjngoò k'a itjo. Kiì ján i̱ndiì ndáchikon. Ngats'iì xi̱ta̱ ya̱á ijchòkon, i̱kjoàn tsakóya‑la̱ 'én ndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","K'e̱ nga nchifì, Jesús kijtseè jè Leví, ki'ndí‑la̱ Alfeo. Tíjnat'aà ími̱xa̱ ya̱ ñánda síkíchjítjì tsojmì ts'e̱ Roma. Kitsò‑la̱: ―Nchrohótji̱ngui‑ná. K'e̱é tsasítje̱n Leví, kiìtji̱ngui‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","K'e̱ nga tíjnat'aà ími̱xa̱ Jesús nga tíkjèn ya̱ ni'ya‑la̱ Leví, kjìn ma xi̱ta̱ xi síkíchjítjì tsojmì ko̱ xi̱ta̱ xi jé tjín‑la̱ títsa̱t'aàko̱ ími̱xa̱ Jesús ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱. Kjìn jchán ma xi̱ta̱ xi tji̱ngui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jñà xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés ko̱ xi̱ta̱ fariseo k'e̱ nga kijtseè Jesús nga tíkjèn‑ko̱ xi̱ta̱ xi tse jé tjín‑la̱ ko̱ xi̱ta̱ xi síkíchjítjì tsojmì, kitsò‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús: ―¿Mé‑ne k'oa̱s'ín‑ne Maestro‑nò nga xi̱ta̱ xi síkíchjítjì tsojmì ko̱ xi̱ta̱ jé kjèn‑ko̱‑ne? ");
INSERT INTO maaNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","K'e̱ nga kiì'nchré Jesús; kitsò‑la̱: ―Jñà xi̱ta̱ xi mì ch'in tjín‑la̱, mì chji̱ne̱xkiì mochjeén‑la̱; jñà‑né xi̱ta̱ xi xk'én xi mochjeén‑la̱ chji̱ne̱xkiì. 'A̱n, mìtsà koi xá j'i̱‑na nga jñà kichjà‑la̱ jñà xi̱ta̱ xi tsò‑la̱ yijo‑la̱ nga xi̱ta̱ kixi̱, koií xá j'i̱‑na nga jñà kichjà‑la̱ xi̱ta̱ xi beè‑la̱ ikon nga jé tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jngoò k'a, k'e̱ nga jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Juan ko̱ jñà xi kota'yàt'aà‑la̱ xi̱ta̱ Fariseo nchibìtsa̱jnachjan, kiì i'nga xi̱ta̱ koi nga kiskònangui‑la̱ Jesús. Kitsò‑la̱: ―Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Juan ko̱ xi kota'yàt'aà‑la̱ xi̱ta̱ Fariseo bìtsa̱jnachjan‑né. ¿Mé‑ne jñà xi̱ta̱ tsi̱ji xi kota'yàt'aà‑lè mì bìtsa̱jnachjan‑né? ");
INSERT INTO maaNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kitsò Jesús: ―¿A bìtsa̱jnachjaán xi̱ta̱ k'e̱ nga xi̱ta̱ kòbixan k'e̱ nga ya̱ tíjnako̱‑ìsa jè xi̱ta̱ x'i̱n xi kòbixan? Majìn, mìkiì bìtsa̱jnachjan xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ta̱nga ki̱jchò na̱chrjein k'e̱ nga tjáxìn‑la̱ x'i̱n xi kòbixan; k'e̱‑né nga kítsa̱jnachjan xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Jngoò nikje i̱baà mìkiì ma si̱jto‑ne ko̱ nikje xi̱tse̱; nga jè nikje xi̱tse̱, kjeèn‑yó‑né koa̱ ko̱tejnda‑né jè nikje i̱baà. Ìsa̱á tse ko̱ma ñánda kixajndà kji. ");
INSERT INTO maaNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ti̱koa̱á mìtsà yá xi ko̱ma binchá xán ixiì ko̱ chrjoa̱ jchínga; tsà ko̱s'ín s'e̱en, k'e̱ nga jye ko̱jchá xán, si̱ìxajndà chrjoa̱ jchínga, i̱kjoàn chi̱ja xán ko̱ chrjoa̱. Jè xán ixiì, chrjoa̱ xi̱tse̱é sinchá. ");
INSERT INTO maaNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jngoò na̱chrjein nìkjáya ja Jesús ya̱ ñánda títje̱ trigo. Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ tsate chiba natín‑la̱ trigo. ");
INSERT INTO maaNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jñà xi̱ta̱ Fariseo kitsò‑la̱: ―¿Mé‑ne ko̱s'ín‑ne xi̱ta̱‑lè jè na̱chrjein nìkjáya? Mìkiì tjí'nde nga ko̱s'ín ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Kiìchja̱ Jesús kitsò‑la̱: ―¿Jñò, a mìtsà jye tíjiìn‑nò koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá koni kis'iìn xi̱ta̱xá ítjòn xi ki'mì David ko̱ jñà xi̱ta̱‑la̱ xi kjihijtako̱ k'e̱ nga no̱'miì ítjòn tsibìjna jè Abiatar? K'e̱ nga kjòhojò‑la̱ nga nì mé tjín xi kine, jahas'en ni'ya‑la̱ Nainá. Tsakjèn i̱nchra̱jín tsjeè‑la̱ Nainá. Ti̱koa̱ kitsjaà‑la̱ xi̱ta̱‑la̱ xi tji̱ko̱. Mìkiì tjí'nde nga jñà ko̱kje̱n. Tà jñà no̱'miì tjí'nde‑la̱ nga ko̱kje̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ìjngoò k'a kitsò Jesús: ―Jè na̱chrjein nìkjáya, koií xá kisindaà‑ne nga kjo̱ndaà ts'e̱ xi̱ta̱. Mìtsà koi xá kisindaà‑ne xi̱ta̱ nga kjo̱ndaà ts'e̱ na̱chrjein. ");
INSERT INTO maaNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","K'oa̱á s'ín tjín, 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, skanda jè na̱chrjein nìkjáya, 'a̱án otiìxoma‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ìjngoò k'a jahas'en Jesús ñánda tíjna jngoò ni'ya i̱ngo̱ sinagoga. Ko̱ ya̱ tíjna jngoò xi̱ta̱ xi kixìt'aà jngoò tsja. ");
INSERT INTO maaNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jñà kondra̱‑la̱ Jesús nchisíkinda̱ nga mejèn‑la̱ nga skoe̱ a si̱ìndaá‑ne jè xi̱ta̱ xi kixìt'aà tsja jè na̱chrjein nìkjáya, mé‑ne nga ko̱ma ko̱hòngui‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús kitsò‑la̱ jè xi̱ta̱ xi kixìt'aà jngoò tsja: ―Ti̱sítji̱in, ti̱si̱jni i̱ jngoò osen‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesús k'e̱é kitsò‑la̱ jñà xi̱ta̱ xi i'nga: ―¿A tsjá'nde kjo̱tíxoma nga ndaà s'e̱én, o xi ch'o s'e̱én, jè na̱chrjein nìkjáya? ¿A si̱ndaá‑ná xi̱ta̱, o xi si̱k'en‑ná? Jñà xi̱ta̱ xi o̱tì'mì‑la̱ ta jyò tsibìtsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús kiskoòtsejèn‑jiìn‑la̱ xi̱ta̱ nga jti komà‑la̱. Ti̱koa̱ ba kis'e‑la̱ nga tájaàjiìn tjín ini̱ma̱‑la̱ jñà xi̱ta̱. K'e̱é kitsò‑la̱ jè xi̱ta̱ xi kixìt'aà tsja: ―Tjeèndojoì ndsei̱i. Tsijmeé tsja, ni̱to̱ón kjòndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jñà xi̱ta̱ fariseo, k'e̱ nga itjo‑ne, tsajoóya‑ne ko̱ xi̱ta̱ Herodes nga mejèn‑la̱ si̱ìk'en Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱ chinchat'aà xìn. Ján kiì i̱ndiì ndáchikon. Kjìn xi̱ta̱ kiìtji̱ngui‑la̱ xi nangui Galilea ts'e̱ ko̱ xi̱ta̱ nangui Judea, ");
INSERT INTO maaNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ko̱ xi̱ta̱ na̱xa̱ndá Jerusalén, ko̱ xi̱ta̱ nangui Idumea, ko̱ xi̱ta̱ xijngoaà xa̱jngá nandá Jordán kóho̱kji jngoò itjandiì‑la̱ na̱xa̱ndá Tiro ko̱ Sidón nga kiì'nchré‑la̱ kjo̱xkón xi kis'iìn Jesús. K'oa̱á komà‑ne kjìn jchán xi̱ta̱ ijchò tji̱ngui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesús kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Kjit'aà na̱chrjein tjajnandaà jngoò chitso mé‑ne nga mì xi̱ta̱ ko̱jtínè‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Koií kjoa̱‑la̱ nga jyeé kjìn jchán xi̱ta̱ xk'én kjòndaà‑ne. Jñà xi̱ta̱ xk'én xi i'nga, ya̱á fìkjanè'ñó ñánda tíjna Jesús nga mejèn‑la̱ ko̱òt'aà‑la̱ tsja. ");
INSERT INTO maaNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jñà xi̱ta̱ xi ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱, k'e̱ nga beè Jesús bincha-xkó'nchit'aà‑la̱, i̱kjoàn 'ñó chja̱, tsò: ―Ji̱‑né xi Ki'ndí‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ta̱nga jè Jesús 'ñó tsohótiko̱ nga mì jñà ke̱èno̱jmí yá‑né jè. ");
INSERT INTO maaNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Xi jye komà i̱skan, Jesús kiìmijìn‑jno jngoò nindoò. Kiìchja̱‑la̱ xi̱ta̱ xi jè ndaà kisaseèn takòn. Xi̱ta̱ koi, ijchò kinchat'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","I̱kjoàn jaàjiìn tejò xi̱ta̱ xi koa̱hijtako̱, ti̱jñà‑ne xi si̱ìkasén nga ki̱chja̱ya 'én ndaà‑la̱ Nainá ");
INSERT INTO maaNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","xi ti̱koa̱ kitjoé‑la̱ o̱kixi̱ nga si̱ìndaà‑ne xi̱ta̱ xi ch'in tjín‑la̱ ti̱koa̱ ko̱chrjekàjiìn ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jñà xi̱ta̱ xi kitjaàjiìn: jè Simón. I̱kjoàn tsibít'aàsòn 'ín‑la̱; Pedro kitsò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ko̱ jñà i̱xti‑la̱ Zebedeo xi 'mì Jacobo ko̱ jè 'ndse̱ xi 'mì Juan, xi ti̱koa̱ tsibít'aàsòn 'ín‑la̱; Boanerges kitsò‑la̱. (Jè 'én jè tsò‑ne: I̱xti‑la̱ ch'o̱n.) ");
INSERT INTO maaNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ko̱ Andrés; Felipe; Bartolomé; Mateo; Tomás; Jacobo xi ti‑la̱ ma Alfeo; Tadeo; Simón, xi̱ta̱ xi ya̱ fìt'aà‑la̱ xi̱ta̱ cananista; ");
INSERT INTO maaNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote, jè xi̱ta̱ xi kisìnga̱tsja kondra̱‑la̱ Jesús. K'e̱ nga j'iì‑ne Jesús ni'ya ñánda síkjáya, ");
INSERT INTO maaNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ìjngoò k'a kòkjìn xi̱ta̱ skanda mì ti kiì kitjò'nde‑la̱ nga tsakjèn. ");
INSERT INTO maaNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","K'e̱ nga kiì'nchré xi̱ta̱ xíkjín Jesús, kjoa̱ xi tís'ín, kiì kátsji nga tso̱ba̱'ñó; kitsò: Skáyaá‑la. ");
INSERT INTO maaNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jñà xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés xi j'iì‑ne Jerusalén k'oa̱á kitsò nga jè xi̱ta̱ nei̱í xi 'mì Beelzebú tíjiìn ini̱ma̱‑la̱ Jesús, nga jè xi̱ta̱ sko̱‑la̱ xi̱ta̱ nei̱í tsjá‑la̱ nga'ñó nga ochrjekàjiìn ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús kiìchja̱‑la̱ xi̱ta̱ koi. Tsibéno̱jmí jngoò‑la̱ kjoa̱ xi mangásòn. Kitsò‑la̱: ―¿A ko̱maá jè xi̱ta̱ nei̱í ko̱chrjekàjiìn‑ne xi ti̱jè‑ne yijo‑la̱ ya̱ ini̱ma̱‑la̱ xi̱ta̱? Majìn. ");
INSERT INTO maaNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tsà jngoò na̱xa̱ndá je, tsà jòya tjín nga kondra̱ títsa̱jna‑la̱ xíkjín, mìkiì ko̱ma 'ñó kítsa̱jna; ");
INSERT INTO maaNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ko̱ tsà jngoò ni'ya, tsà jòya tjín nga kondra̱ títsa̱jna‑la̱ xíkjín, ti̱koa̱á mìkiì ko̱ma 'ñó kítsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tsà jè xi̱ta̱ nei̱í, tsà jòya tís'ín xi ti̱jè‑ne yijo‑la̱, mìkiì ko̱ma 'ñó kíjna. Jye tífehet'aà na̱chrjein‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Jngoò xi̱ta̱ xi tjín‑la̱ nga'ñó, mì yá xi ko̱ma kjoa̱has'en ni'ya‑la̱ nga si̱ìchijé‑la̱ tsà mì ítjòn koi̱ìt'aà'ñó. K'e̱é ko̱ma si̱ìchijé‑la̱ k'e̱ nga jye kàsìt'aà'ñó. ");
INSERT INTO maaNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’O̱kixi̱í xi xan‑nó, xi̱ta̱ xi tjín‑la̱ jé ko̱ xi chja̱jno‑la̱ Nainá, jcha̱t'aà‑la̱ jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ta̱nga jñà xi̱ta̱ xi chja̱jno‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá, mìkiì jcha̱t'aà‑la̱ ni̱ta̱ mé nó‑ne, ni̱ta̱ mé na̱chrjein‑ne. Kjo̱'in s'e̱‑la̱ ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Koií k'oa̱s'ín kitsò‑ne Jesús nga jñà xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés kitsò‑né: “Xi̱ta̱ jè, ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Xi komà i̱skan, ijchò 'ndse̱ ko̱ nea̱‑la̱ Jesús. Ján ndi̱tsiaán tsibìtsa̱jna. K'e̱é kinokjoà‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jñà xi̱ta̱ xi títsa̱jnandiì‑la̱, kitsò‑la̱: ―Nea̱‑lè ko̱ jñà 'ndsì, ján ndi̱tsiaán títsa̱jna. Ji̱ xó ótsji‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","K'e̱é kiìchja̱ Jesús, kitsò: ―¿Yá‑né xi nea̱‑na̱ ko̱ xi 'ndsè? ");
INSERT INTO maaNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","I̱kjoàn kiskoòtsejèn‑jiìn‑la̱ jñá xi̱ta̱ xi títsa̱jnandiì‑la̱. Kitsò: ―Jñà xi̱ta̱ koi xi nea̱‑na̱, ko̱ xi 'ndsè. ");
INSERT INTO maaNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nga̱ ni̱ta̱ yá xi̱ta̱‑ne xi síkitasòn koni s'ín mejèn‑la̱ Nainá, jñà‑né xi 'ndsè, xi tichja, ko̱ xi nea̱‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús ìjngoò k'a tsibíts'ia̱ nga tsakóya ya̱ i̱ndiì ndáchikon. Kjìn jchán ma xi̱ta̱ xi chixoñat'aà‑la̱. Jesús jahas'en jngoò chitso xi kjijnajiìn ndáchikon; i̱kjoàn tsibìjnaya. Ngats'iì xi̱ta̱, ya̱á títsa̱jnat'aà nanguií ya̱ i̱ndiì ndáchikon. ");
INSERT INTO maaNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kjìn ska̱ya kjoa̱ xi mangásòn tsakóya‑la̱ xi̱ta̱. K'e̱ nga tsibéno̱jmí‑la̱ kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Ndaà ti̱ná'yaà. Jngoò xi̱ta̱ kiì kíjndi̱ xojmá. ");
INSERT INTO maaNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","K'e̱ nga tsibíts'ia̱ nga kiskíjndi̱ xojmá, chixò chiba ya̱ i̱ya ndi̱yá. I̱kjoàn j'iì ni̱se; tsakjèn. ");
INSERT INTO maaNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nguì k'oa̱ tjín chixò ñánda na̱xi̱ choòn nga chiba ni'nde tjín‑la̱. Jñà xojmá koi, ni̱to̱ón isò koi‑né nga mì na̱nga̱ tjín nangui. ");
INSERT INTO maaNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ta̱nga k'e̱ nga itjokàtji ts'oí nga kjòtsjè ndobá, kixìñó, i̱kjoàn jngoò k'aá kixì, koi‑né nga tsjìn‑la̱ i̱ma̱. ");
INSERT INTO maaNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nguì k'oa̱ tjín chixò ya̱ i̱jiìn na'yá. K'e̱ nga kjò'nga na'yá, kisìk'en‑ngui xka̱‑la̱ xojmá; k'oa̱á ma‑ne nga mìkiì tsajà‑la̱ toò. ");
INSERT INTO maaNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ta̱nga jñà xojmá xi chixò ñánda nangui ndaà, tsijin, kjò'nga, tsajà‑la̱ toò, ndaà itjo. Kitsjaà katé, jàn‑kaàn skanda jngoò sìndo̱ toò nga jngoò ìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","I̱kjoàn kitsò Jesús: ―Ndaà ti̱ná'yaà koni xan‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","K'e̱ nga jye tsibìjna ta̱jngoò Jesús, jñà xi̱ta̱ xi chrañà títsa̱jnat'aà‑la̱ ko̱ xi̱ta̱‑la̱ xi tejò ma‑ne, kiskònangui‑la̱ kó tsòya‑ne 'én xi tsibéno̱jmí. ");
INSERT INTO maaNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kitsò Jesús: ―Jñò, Nainá jye kitsjaà‑nò nga jcha̱a kjoa̱'ma‑la̱ kó s'ín otíxoma Nainá. Ta̱nga jñà xi̱ta̱ xi kj'ei̱í, tà 'én ts'e̱ kjoa̱ mangásòn s'e̱no̱jmí yije‑la̱, ");
INSERT INTO maaNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","mé‑ne nga mìkiì skoe̱‑ne na̱s'ín skótsejèn, ti̱koa̱á mìkiì ko̱chi̱ya‑la̱ na̱s'ín kji̱'nchré. Nga jñà xi̱ta̱, majìn‑la̱ síkjatjìya kjo̱hítsjeèn‑la̱ koa̱ mìkiì jcha̱t'aà‑la̱ jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kitsò Jesús: ―¿A mì fìya‑nò jè 'én ts'e̱ kjoa̱ xi mangásòn? ¿Kós'ín ska̱ya‑nò ngats'iì kjoa̱ xi i'nga? ");
INSERT INTO maaNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jè xi bítje̱ xojmá, jè ngaya‑la̱ xi̱ta̱ xi síka'bí 'én‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jñà xojmá xi chixò ya̱ i̱ya ndi̱yá, jñà ngaya‑la̱ xi̱ta̱ xi 'nchré 'én‑la̱ Nainá. K'e̱ nga ma i̱skan nga jyeé 'nchré, f'iì xi̱ta̱ nei̱í faáxìn jè 'én ya̱ i̱jiìn ini̱ma̱‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jñà xojmá xi chixò ya̱ ñánda na̱xi̱ choòn, jñà ngaya‑la̱ xi̱ta̱ xi 'nchré 'én‑la̱ Nainá. Tsjaá s'e‑la̱ k'e̱ nga sa̱ 'nchré. ");
INSERT INTO maaNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ta̱nga jè 'én mìkiì ndaà kisijiìn ini̱ma̱‑la̱ koni xka̱ xi tsjìn‑la̱ i̱ma̱, mì 'ñó binchako̱ 'én, ta chiba na̱chrjein chíkjoa̱‑la̱. K'e̱ nga mé kjoa̱ xi sakó‑la̱ ko̱ tsà xi̱ta̱ fìtji̱ngui kondra̱‑la̱ nga jè nga̱tjì‑la̱ 'én‑la̱ Nainá, ni̱to̱ón síkíjna ndi̱yá‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jè xojmá xi chixò ya̱ ñánda tjín na'yá, jñà ngaya‑la̱ xi̱ta̱ xi 'nchré 'én‑la̱ Nainá, ");
INSERT INTO maaNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ta̱nga 'ñó síkájno kjoa̱ ts'e̱ tsojmì xi tjín i̱sò'nde; ko̱ jè kjoa̱ nchi̱ná kona̱cha̱n‑la̱; ko̱ mejèn yije‑la̱ tsojmì xi tjín i̱sò'nde. Jñà kjoa̱ koi síkits'ón‑jiìn 'én‑la̱ Nainá, k'oa̱á ma‑ne nga mìkiì makjìn‑ya. ");
INSERT INTO maaNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ta̱nga jñà xojmá xi chixò ñánda nga nangui ndaà, jñà ngaya‑la̱ xi̱ta̱ xi 'nchré 'én‑la̱ Nainá koa̱ mokjeiín‑la̱; i̱kjoàn makjìn‑ya 'én, k'oa̱á ngaya‑la̱ koni yá xi ojà‑la̱ toò. Tsjá katé, jàn‑kaàn skanda jngoò sìndo̱ nga jngoò ìjngoò yá. ");
INSERT INTO maaNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús kitsò‑ìsa: ―¿A k'oa̱á s'ín mochjeén ni'ín xi síhiseèn nga ya̱ si̱jnangui kaxa̱, o ya̱ si̱jnangui na̱chan? Majìn, jngoò ni'ín xi síhiseèn, 'ngaá si̱jna mé‑ne nga síhiseèn‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ni̱mé kjoa̱ tjín xi tjí'ma i̱'ndei̱ xi mìkiì jcha̱‑la̱; ti̱koa̱á tsjìn kjoa̱ xi tjí'ma i̱'ndei̱ xi mìkiì ko̱tsejèn. ");
INSERT INTO maaNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Ndaà ti̱ná'yaà koni xan‑nò! ");
INSERT INTO maaNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús kitsò‑ìsa‑la̱: ―Jñò xi na'yà, ndaà ti̱ná'yaà. Koni kji machi̱ya‑nò, k'oa̱á ti̱ kji si̱ìkíchi̱ya‑nò Nainá, skanda tsjásòn‑ìsa‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jè xi tjín‑la̱ kjo̱hítsjeèn, tjoé‑ìsa‑la̱; ta̱nga jè xi tsjìn‑la̱, skanda tjá'aán‑la̱ kjo̱hítsjeèn xi chiba tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kitsò Jesús: ―Koni s'ín otíxoma Nainá k'oa̱á ti̱s'ín tjín koni k'e̱ tsà jngoò xi̱ta̱ bítje̱ no̱jmé. ");
INSERT INTO maaNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Jè no̱jmé, síxá nga bisò, ma'nga, na̱s'ín jè xi̱ta̱ xi bítje̱ mìkiì tíbeè kós'ín tísíxá nga jè xi̱ta̱ ojnafè‑né k'e̱ nga ni̱tje̱n; nga s'e i̱sén osítje̱n; ");
INSERT INTO maaNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","nga jè nangui tísíjchá; ítjòn bitjo xka̱‑la̱, i̱skan ma'nga, i̱kjoàn tjo‑la̱ natín koa̱ i̱kjoàn majchá ni̱ji̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","K'e̱ jye majchá ni̱ji̱n, jye ma maxkó nga jye ijchò chi̱ba̱‑la̱ nga sincháxkó ni̱ji̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús ìjngoò k'a kitsò: ―¿Mé xi ko̱ngásòn‑ko̱ koni s'ín otíxoma Nainá?, o ¿mé 'én xi si̱ngásòn‑kjoaá? ");
INSERT INTO maaNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jè mangásòn‑ko̱ koni kji xojmá mostaza; k'e̱ nga sitje̱ i̱jiìn nangui, jè xi ìsa̱ i̱tsé kji i̱ i̱t'aà nangui. ");
INSERT INTO maaNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","K'e̱ nga jye sitje̱, bisò, ma'nga skanda ìsa̱á 'nga ma koni ngats'iì xka̱ xi ma chine xi sitje̱ i̱ndiì ni'ya. 'Ñó 'nga ma chrja‑la̱ skanda ma bíndaà'a tjé‑la̱ ni̱se ya̱ ngui 'nguién‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesús kjìn ska̱ya kjoa̱ xi mangásòn kisìkjeén nga tsakóya 'én ndaà‑la̱ Nainá, koni kji nga ndaà fìya‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nguì ko̱ó kjoa̱ xi mangásòn tsakóya‑la̱ xi̱ta̱; ni̱mé 'én kiìchja̱ xi mìtsà kjoa̱ xi mangásòn tsibéno̱jmí; ta̱nga k'e̱ nga jye tíjnat'aàxìn‑ko̱ xi̱ta̱‑la̱ xi kota'yàt'aà‑la̱, k'e̱é ìjngoò k'a tsakóya ndaà yije‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","K'e̱ nga jye kòjñò nga ti̱jè‑ne na̱chrjein, Jesús kitsò‑la̱ xi̱ta̱‑la̱ xi kota'yàt'aà‑la̱: ―Tíkjiaán, ján xijngoaà ndáchikon. ");
INSERT INTO maaNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jñà xi̱ta̱ xi kjìn ma‑ne ta ya̱á kisìkítsa̱jna; kiì Jesús ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱ nga títsa̱jnaya chitso. Ti̱koa̱á tsafáhijtako̱ chitso xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","K'e̱ nga jye tjímajiìn nandá, j'iì jngoò tjo̱xkón xi ta̱xki̱ komà‑né; kiskímiì'nga nandá koa̱ jè chitso jye kitseè nandá. ");
INSERT INTO maaNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús ya̱á kjinafè tàts'en chitso. Kijnanguisko jngoò nikje nguisko. K'e̱é kisìkjaá‑la̱, kitsò‑la̱: ―Maestro, ¿a mìtsà tì'yi nga titsa̱bixònguindá‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús k'e̱é tsasítje̱n, tsohótiko̱ jè tjo̱; kitsò‑la̱ ndáchikon: ―Jyò ti̱jni. Ni̱to̱ón kisijyò‑ne tjo̱; kjòndaàya‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesús kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―¿Mé‑ne tsakjoòn‑nò? ¿A mìtsà mokjeiín‑nò i̱t'aà ts'a̱n? ");
INSERT INTO maaNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ ndaà jchán kitsakjòn. Xki̱ xi ján kjònangui‑la̱ xíkjín, tsò‑la̱: ―¿Yá xi̱ta̱‑ne jè skanda jè tjo̱ ko̱ ndáchikon síkitasòn‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱ ijchò ján xijngoaà ndáchikon ya̱ nangui‑la̱ xi̱ta̱ Gadareno. ");
INSERT INTO maaNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","K'e̱ nga itjojen chitso Jesús ijchò kasìt'aà jngoò‑la̱ xi̱ta̱ xi ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱. Jè xi̱ta̱ jè ya̱á itjo‑ne i̱tsjó nga̱jo̱ mik'en. ");
INSERT INTO maaNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Xi̱ta̱ jè ya̱á bìjnaya ya̱ i̱tsjó nga̱jo̱ mik'en. Mì yá xi ma bít'aà'ñó na̱s'ín na'ñó ki̱cha̱ cadena. ");
INSERT INTO maaNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kjìn k'a o̱kis'iìn‑ko̱ nga tsibít'aà'ñó ndso̱ko̱ ko̱ tsja na'ñó ki̱cha̱ cadena. Ni̱yá xi chíkjoa̱‑la̱ nga kisì'nchré; otejtso xó cadena. ");
INSERT INTO maaNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ko̱ na̱chrjein ko̱ ni̱tje̱n ya̱á ojmeèsòn nindoò ñánda tjín i̱tsjó nga̱jo̱‑la̱ mik'en. Kjindáya tsò kjindáya ská nga kjaán ko̱ yijo‑la̱; 'beé‑la̱ nda̱jo̱ yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","K'e̱ nga kijtseè nga kjiìn tínchrobá Jesús, tsangachikon. Kiì kasìt'aà chrañà‑la̱, tsasèn‑xkó'nchit'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","'Ñó kiìchja̱, kitsò: ―¿Mé xi tjín‑lè ko̱ 'a̱n, Jesús, Ki'ndí‑la̱ Nainá xi 'ñó 'nga tíjna? Bìtsi'bà‑lè nga nguixko̱n Nainá, kì yatoòn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Koií k'oa̱s'ín kiìchja̱‑ne nga jè Jesús kitsò‑la̱: ―Ngaji̱ ini̱ma̱ ch'o‑la̱ nei̱í, titjo̱jiín ini̱ma̱‑la̱ xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús kiskònangui‑la̱. Kitsò‑la̱: ―¿Kó 'mì‑lè? Jè kitsò: ―Legión 'mì‑na, koií‑né nga kjìn jchán ma‑naje̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jñà ini̱ma̱ ch'o‑la̱ nei̱í, 'ñó tsibítsi'ba‑la̱ Jesús nga mì i̱t'aà xìn ski̱nì ya̱ i̱'nde jè. ");
INSERT INTO maaNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ko̱ ya̱ chrañà i̱t'aà nindoò, kjìn chi̱nga̱ nchikjèn‑jno. ");
INSERT INTO maaNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jñà ini̱ma̱ ch'o‑la̱ nei̱í tsibítsi'ba‑la̱ Jesús. Kitsò‑la̱: ―Ya̱á ti̱kasén‑náje̱n ñánda tjín chi̱nga̱; ya̱á ki̱tjás'e̱n‑jiìn‑je̱n yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús kitsjaà'nde‑la̱; jñà ini̱ma̱ ch'o‑la̱ nei̱í itjojiìn ini̱ma̱‑la̱ xi̱ta̱ jè; i̱kjoàn jahas'en‑jiìn yijo‑la̱ chi̱nga̱. Ma‑la̱ tsà jò jmiì jñà chi̱nga̱ xi tsanga; tsatíkjájen‑jno ya̱ na̱xi̱ skanda i̱jiìn ndáchikon, ya̱á k'en yije i̱jiìn ndáchikon. ");
INSERT INTO maaNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jñà xi̱ta̱ xi ko'ndà chi̱nga̱, tsanga. Kiì kéno̱jmí‑la̱ xi̱ta̱ na̱xa̱ndá ko̱ xi̱ta̱ rancho̱ jè kjoa̱ xi komà. Jñà xi̱ta̱ na̱xa̱ndá ijchò katsejèn‑la̱ kjoa̱ xi komà. ");
INSERT INTO maaNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kjìn xi̱ta̱ ijchò ñánda tíjna Jesús, kijtseè jè xi̱ta̱ xi ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱ nga sa̱ ítjòn. Jyò tíjna. Íkjá‑ne nikje‑la̱. Ndaà tjín‑ne kjo̱hítsjeèn‑la̱. Xi̱ta̱ xi ijchò, ta kitsakjòn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jñá xi̱ta̱ xi kijtseè koni s'ín komàt'in jè xi̱ta̱ xi ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱ nga kjòndaà‑ne ko̱ chi̱nga̱ xi tsatíkjá, tsibéno̱jmí‑la̱ jñá xi̱ta̱ xi ijchò xi mìkiì kijtseè. ");
INSERT INTO maaNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jñà xi̱ta̱ xi ijchò tsibítsi'ba‑la̱ Jesús nga xìn i̱'nde kàtjì. ");
INSERT INTO maaNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","K'e̱ nga jahas'en chitso Jesús, jè xi̱ta̱ xi ini̱ma̱ ch'o‑la̱ nei̱í kisijiìn ini̱ma̱‑la̱, tsibítsi'ba‑la̱ Jesús nga mejèn‑la̱ kji̱ko̱. ");
INSERT INTO maaNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ta̱nga jè Jesús mìkiì kitsjaà'nde‑la̱. Kitsò‑la̱: ―T'in‑ne ni'ya‑lè, tèno̱jmí yije‑la̱ xi̱ta̱ xingui̱i jè kjo̱ndaà xi kisìko̱‑lè Nainá; kós'ín kijtseè i̱ma̱‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Xi̱ta̱ jè, kiì; i̱kjoàn tsibíts'ia̱ nga tsibéno̱jmí‑la̱ jñà xi̱ta̱ na̱xa̱ndá Decápolis jè kjo̱ndaà xi kisìko̱ Jesús. Ngats'iì xi̱ta̱ xi kis'eno̱jmí‑la̱ tà k'oa̱á komà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús tsibìjna'ya chitso, inchrobà ìjngoò k'a‑ne ján xijngoaà ndáchikon, kjìn jchán xi̱ta̱ chixoñat'aà ìjngoò k'a‑la̱, koa̱ ya̱á tsibìjnandiì ndáchikon. ");
INSERT INTO maaNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ijchòkon jngoò xi̱ta̱ xi 'mì Jairo xi xi̱ta̱ ítjòn ts'e̱ ni'ya i̱ngo̱ sinagoga. K'e̱ nga kijtseè Jesús tsasèn‑xkó'nchit'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","'Ñó tsibítsi'ba‑la̱, kitsò‑la̱: ―Ndí tsòti‑na̱ jye kjo̱meè biyaà; nchroboí, tíkjiaán, tjat'aà‑la̱ ndsei̱i nga kàtandaà‑ne, mé‑ne nga kíjnakon‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús kiìko̱, kjìn jchán xi̱ta̱ kiìtji̱ngui‑la̱; chi̱ba̱‑la̱ ó'nchò'ñó‑né. ");
INSERT INTO maaNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ya̱á tsóhojiìn jngoò chjo̱ón xi kjò tejò nó xk'én, ch'in jní tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kjòtseé tísíkjeiín kjo̱'in i̱t'aà ts'e̱ chji̱ne̱xkiì; jye xó kisìkje yije to̱n‑la̱; mìkiì mandaà‑ne, ta̱ saà tíma'ñó ch'in‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chjo̱ón jè, k'e̱ nga kiì'nchré i̱t'aà ts'e̱ Jesús, kiìjiìn‑la̱ ngats'iì xi̱ta̱ kjìn; i̱jto̱n íts'i̱n kitsobà‑ne nikje‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","K'oa̱s'ín tísíkítsjeèn, kitsò: “Tsà tà jè nikje‑la̱ sìkoa̱a, ko̱ndaá‑na.” ");
INSERT INTO maaNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","K'e̱ nga kitsobà'ñó nikje‑la̱, ni̱to̱ón kisijyò‑la̱ jní, koa̱ kijtseèyaá‑la̱ yijo‑la̱ nga jye kjòndaà‑ne ch'in‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús ni̱to̱ón kijtseèya‑la̱ nga nga'ñó‑la̱ itjojiìn; kisìkátji, kiskoòtsejèn‑jiìn‑la̱ xi̱ta̱ kjìn, kitsò: ―¿Yá xi kàtsobà'ñó nikje‑na̱? ");
INSERT INTO maaNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kitsò‑la̱: ―¿A mìtsà 'yi nga jñà xi̱ta̱ ó'nchò'ñó‑lè? Ngaji̱ si‑né: “¿Yá xi kàtsobà'ñó nikje‑na̱?” ");
INSERT INTO maaNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ta̱nga jè Jesús kotsejèn‑jiìn‑la̱ jñà xi̱ta̱ nga mejèn‑la̱ skoe̱ yá xi kitsobà'ñó nikje‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Chjo̱ón jè, tsí tíhotsé‑né nga kitsakjòn, nga jyeé tíjiìn‑la̱ kós'ín komà ch'in‑la̱; kiì, tsasèn‑xkó'nchit'aà‑la̱ Jesús; tsibéno̱jmí kixi̱ yije‑la̱ kós'ín komàt'in. ");
INSERT INTO maaNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús kitsò‑la̱: ―Ndí nea̱a, koi‑né nga mokjeiín‑lè i̱t'aà ts'a̱n nga kòmandaà‑ne. T'in‑là ndaà‑ne. Jyeé kòmaxkiì‑la̱ ch'in‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tákó ti̱k'e̱é tíchja̱‑ìsa Jesús nga j'iì i'nga xi̱ta̱ xi inchrobà‑ne ni'ya‑la̱ xi̱ta̱ ítjòn ts'e̱ ni'ya i̱ngo̱ sinagoga, kitsò‑la̱: ―Kì ti̱ kiì nìsiì‑la̱ Maestro, ndí tsòti‑lè jyeé k'en. ");
INSERT INTO maaNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ta̱nga jè Jesús, nga kiì'nchré koni kitsò o̱kixi̱ xi j'iìko̱, kitsò‑la̱ jè na̱'èn‑la̱ ndí tsòti: ―Kì tsakjoòn‑jèn; tà jè‑né nga kàtakjeiín‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesús mìkiì kitsjaà'nde nga kjìn xi̱ta̱ kiìko̱. Tà jè Pedro, Jacobo ko̱ Juan 'ndse̱ Jacobo. ");
INSERT INTO maaNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","K'e̱ nga ijchò ni'ya‑la̱ jè xi̱ta̱ ítjòn ts'e̱ ni'ya i̱ngo̱ sinagoga, Jesús kijtseè nga fìjen fìkjá xi̱ta̱, 'ñó nchikjindáya ko̱ 'ñó nchisíkájno. ");
INSERT INTO maaNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jahas'en ni'ya Jesús, kitsò‑la̱: ―¿Mé‑ne ko̱'nè‑nò nga ko̱ tà ndaà chìhindáya‑nò? Jè ndí tsòti mìtsà kòbiyaà; ta kjinafé‑né. ");
INSERT INTO maaNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jñà xi̱ta̱ xi títsa̱jna tà tsijnòkeè Jesús. K'e̱é tsachrje yije ni'ya kóho̱tjín xi̱ta̱; tà jñà tsibìtsa̱jna na̱'èn‑la̱, nea̱‑la̱, ko̱ xi̱ta̱ ts'e̱ xi tji̱ko̱. I̱kjoàn jahas'en ñánda kijna ndí tsòti. ");
INSERT INTO maaNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kiskoé tsja, kitsò‑la̱: ―Talita cumi ―'én xi tsòya‑ne: Ji̱ tsòti, k'oa̱á xan‑lè, ti̱sítji̱in. ");
INSERT INTO maaNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jè ndí tsòti ni̱to̱n tsasítje̱n, tsajmeè‑ne. Jye kjò tejò nó tjín‑la̱. Jñà xi̱ta̱ xi títsa̱jna, 'ñó jchán kitsakjòn. ");
INSERT INTO maaNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ta̱nga Jesús 'ñó kitsjaà o̱kixi̱ nga mì yá xi̱ta̱ xi ke̱èno̱jmí‑la̱. I̱kjoàn kitsò‑la̱: ―Tjiì‑la̱ nga kàtakjèn ndí tsòti. ");
INSERT INTO maaNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús itjojiìn‑ne ya̱ i̱'nde jè, kiì‑ne nangui‑la̱ Nazaret, tji̱ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","K'e̱ nga jye ijchò na̱chrjein nìkjáya, tsibíts'ia̱ nga tsakóya 'én ndaà‑la̱ Nainá ya̱ ni'ya i̱ngo̱ sinagoga. Kjìn jchán ma xi̱ta̱ xi kiì'nchré‑la̱ koni s'ín tsakóya. Jñà xi̱ta̱, tà k'oa̱á komà‑la̱, kjònangui‑la̱ xíkjín, kitsò: ―Xi̱ta̱ jè, ¿ñánda komà‑la̱ ngats'iì 'én xi okóya? ¿Ñánda ochrje kjoa̱chji̱ne̱ koi ko̱ kjo̱xkón xi s'ín? ");
INSERT INTO maaNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿A mìtsà jè xi chji̱ne̱yá xi ti‑la̱ María, xi 'ndse̱ ma Jacobo, José, Judas ko̱ Simón? ¿A mìtsà ti̱koa̱ i̱ títsa̱jnajiìn‑ná íchjín ndichja? Xi̱ta̱ koi mìkiì ko̱kjeiín‑la̱ i̱t'aà ts'e̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ta̱nga jè Jesús kitsò‑la̱: ―Jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá, ni̱ta̱ ñá na̱xa̱ndá‑ne yaxkón‑né, ta̱nga ya̱ na̱xa̱ndá‑la̱ ko̱ ni'ya‑la̱ ko̱ i̱t'aà ts'e̱ xi̱ta̱ xíkjín mìkiì yaxkón. ");
INSERT INTO maaNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jesús ni̱mé kjo̱xkón xi ndaà tjín kis'iìn nangui‑la̱, tà chiba xi̱ta̱ xk'én xi tsohót'aà‑la̱ tsja nga kisìndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tà kjòxkón‑la̱ Jesús, nga jñà xi̱ta̱ koi, mìkiì mokjeiín‑la̱ i̱t'aà ts'e̱. Jesús ya̱á tsajmeè na̱xa̱ndá jtobá xi chrañàt'aà kjiyijò nga tsakóya. ");
INSERT INTO maaNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nga komà i̱skan, Jesús kiìchja̱‑la̱ xi̱ta̱‑la̱ xi tejò ma‑ne xi jè tsibíxáya‑la̱; jò jò kisìkasén, kitsjaà‑la̱ o̱kixi̱ nga ko̱chrjekàjiìn ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","K'oa̱á ti̱s'ín kitsjaà‑la̱ o̱kixi̱ nga ni̱mé tsojmì k'oa̱ k'e̱ nga kjoi̱ ndi̱yá. Kitsò‑la̱: ―Tà k'oa̱á s'ín tanguió. Tà jngoò yá garrote ch'aà. Kì na̱'yaá ch'aà, kì i̱nchra̱jín ch'aà, kì to̱n ch'aà. ");
INSERT INTO maaNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ko̱maá tsjayaà xo̱jté‑nò. Tà jngoò na̱chro̱ ch'aà. Kì jò ch'aà. ");
INSERT INTO maaNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jesús kitsò‑ìsa‑la̱: ―K'e̱ nga ki̱jchò jngoò na̱xa̱ndá, jngoò ni'ya ti̱tsa̱jna skanda k'e̱ nga ko̱nguí‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tsà tjín na̱xa̱ndá ñánda mìkiì skoétjò‑nò, tsà majìn‑la̱ nga 'nchré‑nò, titjo̱jñoò, titsajneè chijo‑la̱ ndso̱koò mé‑ne nga skoe̱‑ne nga jñà tjín‑la̱ jé nga mìkiì 'nchréñijon. Xi nguì o̱kixi̱ k'oa̱á xan‑nò k'e̱ nga ki̱jchò na̱chrjein‑la̱ jñà na̱xa̱ndá koi, ìsa̱á tse kjo̱'in s'e̱‑la̱ koni s'ín komàt'in na̱xa̱ndá Sodoma ko̱ Gomorra. ");
INSERT INTO maaNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Xi̱ta̱ koi, kiì nga tsibéno̱jmíya‑la̱ xi̱ta̱ nga kàtasíkájno jé‑la̱ nga mì ti̱ jé ko̱hótsji‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kjìn ini̱ma̱ ch'o‑la̱ nei̱í tsachrjekàjiìn ini̱ma̱‑la̱ xi̱ta̱, ti̱koa̱ kjìn xi̱ta̱ kisìndaà‑ne xi xk'én nga kisìkaàjno‑la̱ asìti̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jè Herodes xi xi̱ta̱ xá ítjòn tíjna, kiì'nchré i̱t'aà ts'e̱ Jesús nga jye xki̱ xi ján na̱xa̱ndá kina'yà‑la̱. Tjín xi̱ta̱ xi kitsò: ―Jè Juan xi kis'iìn bautizar xi̱ta̱, jyeé jaáya‑la̱. K'oa̱á ma‑ne nga tjín‑la̱ nga'ñó nga ma‑la̱ s'ín kjo̱xkón xi ndaà tjín. ");
INSERT INTO maaNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tjín xi̱ta̱ xi kitsò: ―Jè Elías. Ti̱koa̱ tjín xi kitsò: ―Jngoò xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá kjòtseé. ");
INSERT INTO maaNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jè Herodes, k'e̱ nga kiì'nchré kitsò‑né: ―Jè Juan xi jaáya‑la̱ xi 'a̱n tsatesian sko̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nga ìsa̱ kjòtseé, Herodes kisìkasén xi̱ta̱ nga kitsobà'ñó Juan nga kiskinìs'en nda̱yá, koi kjoa̱‑la̱ ts'e̱ chjo̱ón Herodías xi chjo̱ón‑la̱ Felipe nga jè Herodes chixàn‑ko̱ xi chjo̱ón‑la̱ 'ndse̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nga jè Juan xi kis'iìn bautizar xi̱ta̱, kjìn k'a o̱kitsò‑la̱ Herodes: ―Mìkiì tjiì'nde‑lè nga ji̱ tijnakoi̱i chjo̱ón‑la̱ 'ndsì. ");
INSERT INTO maaNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jè chjo̱ón Herodías, kòjtikeè Juan, mejèn‑la̱ nga si̱ìk'en ta̱nga mìkiì ma xi síko̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Nga jè Herodes, beèxkón Juan ko̱ síkinda̱‑ne nga jye tíjiìn‑la̱ nga xi̱ta̱ kixi̱‑né ko̱ xi̱ta̱ tsjeè‑né. Herodes k'e̱ nga chja̱ko̱ Juan, matsjaá‑la̱ nga 'nchré‑la̱, ta̱nga mìkiì beè mé xi s'i̱in, a si̱ìkitasòn‑né, a xi majìn. ");
INSERT INTO maaNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ijchò jngoò na̱chrjein xi ndaà ts'e̱ chjo̱ón Herodías k'e̱ nga tsachrje s'eí‑la̱ jè Herodes jè na̱chrjein nga kits'iìn. Ijchò xi̱ta̱‑la̱ xi̱ta̱xá ítjòn, ko̱ xi̱ta̱ sko̱‑la̱ soldado, ko̱ xi̱ta̱ nchi̱ná xi tjín kóho̱kji Galilea nga tsakjèn‑ko̱ Herodes. ");
INSERT INTO maaNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ti̱koa̱ ijchò tsòti‑la̱ Herodías, jahas'en ni'ya; kitè. Jè Herodes ko̱ xi̱ta̱ xi títsa̱jna, ndaà jchán kisaseèn‑la̱ koni s'ín kitè jè tsòti. Herodes, xi xi̱ta̱ xá ítjòn tíjna, kitsò‑la̱: ―Ti̱jé‑ná mé xi mejèn‑lè, tsjaà‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","K'oa̱á s'ín kitsjaà‑la̱ tso'ba nga tsjá yije‑la̱ ni̱ta̱ mé xi mejèn‑la̱ na̱s'ín osen nangui xi jè otíxoma‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jè tsòti, itjo ni'ya, kiskònangui‑la̱ nea̱‑la̱. Kitsò‑la̱: ―¿Mé xi siìjé‑la̱? Jè nea̱‑la̱. Kitsò: ―Ti̱jé‑la̱ sko̱ Juan xi s'ín bautizar xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jè tsòti, ni̱to̱ón jahas'en ìjngoò k'a ni'ya ñánda tíjna xi̱ta̱xá ítjòn. Kitsò‑la̱: ―I̱'ndei̱ mejèn‑na nga ni̱to̱n tjiì‑ná sko̱ Juan xi s'ín bautizar xi̱ta̱; tinaya‑ná chro̱ba̱te. ");
INSERT INTO maaNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jè Herodes, xi xi̱ta̱xá ítjòn tíjna, 'ñó kjòba‑la̱ k'e̱ nga kiì'nchré‑la̱ jè tsòti. Ta̱nga koií kjoa̱‑la̱ nga jye kitsjaà‑la̱ 'én‑la̱ nga nguixko̱n xi̱ta̱ xi títsa̱jna s'eí, kjo̱'ñó kisìkitasòn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jè Herodes, ti̱k'e̱é‑ne kisìkasén jngoò soldado, kitsjaà o̱kixi̱ nga kàtjanchrohóko̱ sko̱ Juan. ");
INSERT INTO maaNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jè soldado kiì ján nda̱yá nga tsatesin Juan; i̱kjoàn j'iìko̱ sko̱ Juan; tjíya‑la̱ chro̱ba̱ nga kitsjaà‑la̱ jè tsòti; ko̱ jè tsòti kisìnga̱tsja nea̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","K'e̱ nga kiì'nchré xi̱ta̱ xi kota'yàt'aà‑la̱ Juan nga jye k'en, kiìkjaá yijo‑la̱ nga kiskinìs'en‑ngui jngoò nga̱jo̱ i̱tsjó‑la̱ mik'en. ");
INSERT INTO maaNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","K'e̱ nga j'iì ìjngoò k'a‑ne jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús, tsibéno̱jmí ngats'iì kjoa̱ xi kis'iìn ko̱ xi tsakóya ñánda kiì. ");
INSERT INTO maaNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús kitsò‑la̱: ―Nchrobá. Tíkjiaán nga si̱kjáya í'ñoá jngoò i̱'nde i̱t'aà xìn. Koií k'oa̱ kitsò‑la̱ nga kjìn jchán ma xi̱ta̱, koa̱ tjín bijchó, koa̱ tjín nchrobá‑ne. Jesús ko̱ xi̱ta̱ xi tsibíxáya‑la̱ skanda mì ti̱ kiì ma'a‑la̱ nga kjèn. ");
INSERT INTO maaNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tsibìtsa̱jnaya chitso nga ta jñà kiì jngoò i̱'nde i̱t'aà xìn ñánda tsjìn xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ta̱nga kjìn xi̱ta̱ kijtseè k'e̱ nga kiì. Kijtseèxkon nga jè Jesús. I̱kjoàn kiìtji̱ngui‑la̱ ngats'iì xi̱ta̱ na̱xa̱ndá xi ya̱ chrañàt'aà‑la̱ nga kiì‑ne ndso̱ko̱; skanda ìsa̱ ítjòn ijchò jñà xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús, k'e̱ nga itjojen chitso, kijtseè nga 'ñó kjìn ma xi̱ta̱ xi títsa̱jna; kjòhi̱ma̱keè‑né. K'oa̱á ngaya‑la̱ koni jñà orrè xi tsjìn‑la̱ paxtò xi ko'ndà. I̱kjoàn tsibíts'ia̱ko̱ nga kjìn 'én tsibéno̱jmí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","K'e̱ nga jye 'ñó kjòhoxòn, jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús ijchò kinchat'aà‑la̱, kitsò‑la̱: ―Jyeé kjòhoxòn, jè i̱'nde jè, i̱t'aà xìn‑né, ni̱mé tjín. ");
INSERT INTO maaNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ko̱t'ìn‑la̱ jñà xi̱ta̱ kàtjì‑ne nga kàtatse tsojmì xi ski̱ne̱ ya̱ na̱xa̱ndá ko̱ tsà jñà ni'ya ñánda nga chrañàt'aà. ");
INSERT INTO maaNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kiìchja̱ Jesús, kitsò‑la̱: ―Tjiì‑là jñò xi ko̱kje̱n xi̱ta̱ koi. Kitsò jñà xi̱ta̱: ―¿A mejèn‑lè nga konguí kindaà‑je̱n i̱nchra̱jín koni tjín síkijne xi̱ta̱ nga jò sìndo̱ na̱chrjein síxá? ");
INSERT INTO maaNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kitsò Jesús: ―Chítsejèn‑là kó tjín ma i̱nchra̱jín‑nò. K'e̱ nga kijtseè kó tjín ma‑ne, kitsò‑la̱: ―'Òn ma i̱nchra̱jín ko̱ jò ma ti̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","K'e̱é kitsjaà o̱kixi̱ Jesús nga kàtìtsa̱jnajtín jñà xi̱ta̱ ya̱ i̱jiìn ijñá ñánda sa̱se̱ choòn. ");
INSERT INTO maaNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Íjngó íjngó sìndo̱ tsibìtsa̱jnajtín‑ne jñà xi̱ta̱; ko̱ tjín ñánda icháte icháte tsibìtsa̱jnajtín‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús kiskoé jñà i̱nchra̱jín xi 'òn ma‑ne ko̱ jñà ti̱n xi jò ma‑ne; i̱kjoàn kiskoòtsejèn ngajmiì; kitsjaà‑la̱ kjo̱ndaà Nainá; i̱kjoàn kisìxkoa̱ya i̱nchra̱jín; k'e̱é kitsjaà‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ nga kisìka'bí‑la̱ ngats'iì xi̱ta̱ kjìn xi títsa̱jna. Ti̱koa̱ kisìjòya ti̱n xi jò ma‑ne. Kitsjaà‑la̱ ngats'iì xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tsakjèn yije kóho̱tjín xi̱ta̱ kó nga kjòskiì. ");
INSERT INTO maaNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","K'e̱é tsibíxkó‑ne i̱nchra̱jín ko̱ ti̱n xi kjòxkoa̱ya jñà xi tsiningui‑ne; nguì tejò ni̱si̱yá komà. ");
INSERT INTO maaNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jñà xi̱ta̱ xi tsakjèn, 'òn jmiì ma‑ne xi xi̱ta̱ x'i̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nga komà i̱skan, Jesús kisìkas'en xi̱ta̱ xi kota'yàt'aà‑la̱ ya̱ i̱ya chitso mé‑ne nga ìsa̱ ítjòn ki̱jchò‑ne ján na̱xa̱ndá Betsaida ya̱ xijngoaà ndáchikon; koa̱ jè Jesús k'e̱é tísíhixat'aà xi̱ta̱ xi kjìn ma‑ne nga jye nchifì‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","K'e̱ nga jye kisìhixat'aà xi̱ta̱, Jesús kiìmijìn‑jno jngoò nindoò nga kiì kiìchja̱t'aà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","K'e̱ nga jye kòjñò, jè chitso, jyeé ya̱ síjna jngoò osen ndáchikon. Jesús, nga ta̱jngoò tsibíjnat'aà nangui, ");
INSERT INTO maaNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","kijtseè chitso nga mìkiì ma fì. Nga jè tjo̱ bíchjoà ikon‑la̱. K'e̱ nga ta̱jñòya ìsa̱, Jesús kiìtji̱ngui‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱ nga kiì‑ne ndso̱ko̱ ya̱ i̱sòn nandá. Ta̱nga k'oa̱á kis'iìn koni tsà mejèn‑la̱ nga kjoi̱ ítjòn‑la̱ chitso. ");
INSERT INTO maaNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱, k'e̱ nga kijtseè nga tífìsòn nandá, k'oa̱á s'ín kisìkítsjeèn, kitsò, tsà ini̱ma̱ ch'o‑né; kiskindàya xkón ");
INSERT INTO maaNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","nga kitsakjòn‑la̱ k'e̱ nga kijtseè kóho̱tjín. Ta̱nga Jesús ni̱to̱ón kiìchja̱‑la̱, kitsò‑la̱: ―'Ñó t'è‑là takòn, kì tsakjoòn‑jèn, 'a̱n‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","K'e̱ nga jahas'en chitso Jesús, ni̱to̱ón kisijyò‑ne tjo̱. Tà k'oa̱á komà‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱, ");
INSERT INTO maaNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","nga kj'eè kì ndaà fahas'en‑jiìn‑la̱ jè kjo̱xkón xi kis'iìn Jesús ts'e̱ i̱nchra̱jín, koi‑né nga tájaàjiìn tjín ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","K'e̱ nga jye tsatojiìn ndáchikon, ijchò ján nangui Genesaret; ya̱á tsibít'aà'ñó chitso‑la̱ ya̱ i̱ndiì ndáchikon. ");
INSERT INTO maaNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","K'e̱ nga tsitajen yije chitso, jñà xi̱ta̱ xi ya̱ títsa̱jna, ni̱to̱ón kijtseèxkon nga jè Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ti̱koa̱á ni̱to̱ón kiì kóho̱kji nga jngoò itjandiì i̱'nde jè. I̱kjoàn tsibíts'ia̱ xi̱ta̱ nga j'iìko̱‑la̱ ngats'iì xi̱ta̱ xi xk'én; kjisòn‑la̱ na̱chan‑yá ya̱ i̱'nde ñánda nga 'nchré xi̱ta̱ nga bijchó Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ni̱ta̱ ñánda na̱xa̱ndá nga jahas'en Jesús, tsà na̱xa̱ndá jtobá‑né, na̱xa̱ndá iì‑né, i̱nchi̱ya‑né, ko̱ tsà rancho̱‑né, jñà xi̱ta̱ ya̱á sikáyijò jñà xi̱ta̱ xi xk'én ya̱ jngohosen ndi̱yá; i̱kjoàn bítsi'ba‑la̱ na̱s'ín tà jè i̱tjòn nikje‑la̱ tsobà'ñó nga kàtandaà‑ne. Ngats'iì xi̱ta̱ xi kitsobà'ñó nikje‑la̱ kjòndaà yijeé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ijchò xi̱ta̱ fariseo ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés xi j'iì‑ne na̱xa̱ndá Jerusalén. Ya̱á ijchòtji̱ngui‑la̱ ñánda tíjna Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jñà xi̱ta̱ koi, kijtseè i'nga xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús nga kjèn tjéko̱ tsja nga mìkiì oníjno; kitsò‑la̱ xíkjín nga mìkiì nchisíkitasòn koni s'ín tjín kjo̱tíxoma ts'e̱ xi̱ta̱ judío xi xkón tjín. ");
INSERT INTO maaNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nga jñà xi̱ta̱ fariseo ko̱ ngats'iì xi̱ta̱ judío, k'oa̱á s'ín síkitasòn koni s'ín tjín kjo̱tíxoma‑la̱ xi̱ta̱ jchínga; tsà mì nguì ndaà ko̱níjno tsja, mìkiì ko̱kje̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ti̱koa̱á k'e̱ nga f'iì‑ne ndi̱tsi̱n, ítjòn oníjno tsja, k'e̱é kjèn; tjín‑ìsa‑la̱ kjo̱tíxoma xi kj'ei̱í koni oníya chi̱tsín‑la̱, ti̱jí‑la̱, ko̱ chi̱tsín ki̱cha̱‑la̱ ko̱ na̱chan‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Koií kjoa̱‑la̱ jñà xi̱ta̱ fariseo ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés kiskònangui‑la̱ Jesús, kitsò‑la̱: ―¿Mé‑ne mìkiì síkitasòn‑ne xi̱ta̱ xi kota'yàt'aà‑lè, koni s'ín tjín kjo̱tíxoma‑la̱ xi̱ta̱ jchínga nga ta k'oa̱á s'ín kjèn tjéko̱ tsja? ");
INSERT INTO maaNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús kitsò‑la̱: ―Koni s'ín kiskiì Isaías, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, ndaà kiìchja̱ i̱t'aà tsa̱jòn, jñò, xi̱ta̱ xi jò ma i̱sén‑nò, k'e̱ nga kitsò: Jñà xi̱ta̱ koi, beèxkón‑na xi tà 'én chja̱, ta̱nga jñà ini̱ma̱‑la̱ kjiìn títsa̱jna; ");
INSERT INTO maaNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nìmé chjí‑la̱ nga beèxkón‑na, nga kjo̱tíxoma‑la̱ xi̱ta̱á okóya koni tsà kjo̱tíxoma‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jñò, nìkíjna‑nò xi nguì kjo̱tíxoma‑la̱ Nainá, ko̱ jè onguítji̱ngui‑là kjo̱tíxoma‑la̱ xi̱ta̱ jchínga‑nò nga oníya ti̱jí‑nò, chi̱tsín‑nò; kjìn ska̱ya kjo̱tíxoma tjín‑nò koni s'ín 'nè. ");
INSERT INTO maaNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kitsò‑ìsa Jesús: ―Jñò, nachrjekàngui‑nò xi nguì kjo̱tíxoma‑la̱ Nainá, jè nìkitasòn kjo̱tíxoma‑la̱ xi̱ta̱ jchínga‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés k'oa̱á kitsò: “Jcha̱xkoín na̱'èn‑lè ko̱ nea̱‑lè.” K'oa̱á ti̱ kitsò: “Jè xi chja̱jno‑la̱ na̱'èn‑la̱ ko̱ nea̱‑la̱, tjínè‑la̱ nga si̱k'en.” ");
INSERT INTO maaNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ta̱nga jñò bixón‑nó: “Jngoò xi̱ta̱, ma ki̱tso̱‑la̱ na̱'èn‑la̱, o nea̱‑la̱: Mìkiì ko̱ma siìchját'aà‑lè; ngats'iì tsojmì xi tjín‑na, Corbán‑né.” ('Én xi tsò Corbán, 'én Hebreo‑né; tsòyaá‑ne: jè Nainá jyeé kitsjaà yije‑la̱.) ");
INSERT INTO maaNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Bixón‑nó nga mì ti̱ kiì tjí'nde‑la̱ nga ko̱si̱ko̱ na̱'èn‑la̱, o nea̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jñò, nachrjekàngui‑nò 'én‑la̱ Nainá nga nìkatoya‑là xinguio̱o kjo̱tíxoma‑la̱ xi̱ta̱ jchínga‑nò. Kjìn ska̱ya kjo̱tíxoma tjín‑ìsa‑nò xi k'oa̱s'ín 'nè. ");
INSERT INTO maaNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesús, k'e̱é kiìchja̱‑la̱ ngats'iì xi̱ta̱, kitsò‑la̱: ―Ngats'ioò, ti̱ná'yaà ko̱ ndaà kàtachi̱ya‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ni̱mé tjín xi fahas'en‑jiìn yijo‑la̱ xi̱ta̱ xi síkits'ón. Jè‑né xi ini̱ma̱‑la̱ xi̱ta̱ bitjojiìn‑ne, xi síkits'ón. ");
INSERT INTO maaNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Ndaà ti̱ná'yaà koni xan‑nò! ");
INSERT INTO maaNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús itjokàjiìn‑la̱ xi̱ta̱; kiì, jahas'en jngoò ni'ya; i̱kjoàn jñà xi̱ta̱ xi kota'yàt'aà‑la̱ kiskònangui‑la̱ kó tsòya‑ne jè kjoa̱ mangásòn xi tsibéno̱jmí. ");
INSERT INTO maaNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kitsò Jesús: ―¿Jñò, a ti̱koa̱á mìkiì machi̱ya‑nò kó tsòya‑ne? ¿A mì fìya‑nò ngats'iì tsojmì xi fahas'en‑jiìn yijo‑la̱ xi̱ta̱ mìkiì síkits'ón ");
INSERT INTO maaNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","nga mìtsà ini̱ma̱‑la̱ fahas'en‑jiìn? Ya̱á fahas'en i̱ndso̱'ba̱, i̱kjoàn bitjo‑ne k'e̱ nga fì kítsa̱jna ján baño. Jesús kitsòyaá‑ne: Ngats'iì tsojmì xi ma chine, tsjeè‑né; mìkiì síkits'ón ini̱ma̱‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kitsò‑ìsa Jesús: ―Jè kjo̱hítsjeèn xi bitjojiìn ini̱ma̱‑la̱ xi̱ta̱, jè xi síkits'ón. ");
INSERT INTO maaNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Koi‑né nga ini̱ma̱‑la̱ xi̱ta̱ nchrobájiìn, jñà kjo̱hítsjeèn xi ch'o tsò, koni jè kjoa̱ chijngui ts'e̱ xi̱ta̱ xi jye chixàn ko̱ xi kj'eè bixan jèn, ko̱ xi xi̱ta̱ sík'en, ");
INSERT INTO maaNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ko̱ kjoa̱ chijé, ko̱ kjoa̱ tse mejèn, ko̱ kjoa̱ ts'e̱n, ko̱ kjoa̱ kona̱cha̱n, ko̱ kjoa̱ ts'e̱ xi otonè‑la̱ kjoa̱ ts'e̱ yijo‑ná, ko̱ kjoa̱xìtakòn, ko̱ kjoa̱ 'on takòn, ko̱ kjoa̱ 'nga ikon, ko̱ kjoa̱ 'én ndiso, ko̱ kjoa̱ tòndo̱ xi mìtsà ítjòn nìkítsjeèn. ");
INSERT INTO maaNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ngats'iì kjoa̱ koi xi ini̱ma̱‑la̱ xi̱ta̱ bitjokàjiìn‑ne, koií xi síkits'ón xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kiì Jesús ján na̱xa̱ndá Tiro ko̱ Sidón. K'e̱ nga ijchò ya̱, jahas'en jngoò ni'ya; mejèn‑la̱ nga mì yá xi̱ta̱ xi skoe̱, ta̱nga mìkiì komà tsibìjna'ma. ");
INSERT INTO maaNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ni̱to̱ón kiì'nchré jngoò chjo̱ón xi ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱ tsòti‑la̱. Kiì ñánda tíjna Jesús nga tsasìxkó'nchit'aà‑la̱; ");
INSERT INTO maaNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","tsibítsi'ba‑la̱ nga ko̱chrjekàjiìn jè ini̱ma̱ ch'o xi tíjiìn ini̱ma̱‑la̱ tsòti. Jè chjo̱ón, ya̱á i̱'nde‑la̱ ñánda 'mì Sirofenicia; 'én griego chja̱. ");
INSERT INTO maaNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús kitsò‑la̱: ―Tjiì'nde‑la̱ jñà kàtakjèn ítjòn xi i̱xti ma. Mìkiì ndaà tjín tsà chjaà'an‑la̱ ni̱ño̱ jñà i̱xti, i̱kjoàn k'oi̱‑lá ndí nañá. ");
INSERT INTO maaNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Jè chjo̱ón kitsò: ―Ndaà tjín Na̱'èn; ta̱nga jñà ndí nañá kineé xi̱‑la̱ tsojmì xi bixòngui ími̱xa̱ xi síkatsjoò i̱xti. ");
INSERT INTO maaNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","K'e̱é kitsò Jesús: ―Ndaà kinokjoì. T'in‑ne ni'ya‑lè. Jè ini̱ma̱ ch'o‑la̱ nei̱í, jye itjokàjiìn‑ne ini̱ma̱‑la̱ tsòti‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","K'e̱ nga ijchò‑ne ni'ya‑la̱, jè chjo̱ón, jè tsòti‑la̱, ya̱á kijnasòn na̱chan; ta̱nga jye itjokàjiìn‑ne ini̱ma̱‑la̱ jè ini̱ma̱ ch'o‑la̱ nei̱í. ");
INSERT INTO maaNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús kiì‑ne ya̱ i̱'nde ts'e̱ Tiro; jahatojiìn i̱'nde Sidón, ti̱koa̱ jahatojiìn nangui xi 'mì Decápolis, ijchò‑ne ya̱ ndáchikon ts'e̱ Galilea. ");
INSERT INTO maaNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ya̱á ijchòko̱ jngoò xi̱ta̱ xi jtayaà ko̱ skí'i̱n, tsibítsi'ba‑la̱ Jesús nga ko̱òt'aà‑la̱ tsja jè xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús, i̱t'aà xìn kiìko̱ ñánda tsjìn xi̱ta̱, k'e̱é jahas'en jnótsja ya̱ líká‑la̱, ko̱ ndána̱chrá‑la̱ kisìkaàjno ni̱je̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jesús kiskoòtsejèn ngajmiì; i̱kjoàn jaátse‑la̱, kitsò: ―¡Efata! ―tsò‑ne 'én jè: ¡Kàtatáx'a̱! ");
INSERT INTO maaNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ni̱to̱ón kitáx'a̱‑ne líká‑la̱ xi̱ta̱ jè, ti̱koa̱á ndaà komà kiìchja̱‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús kitsò‑la̱ jñà xi̱ta̱: ―Kì yá xi̱ta̱ xi bèno̱jmí‑là. Ta̱nga k'e̱ nga 'ñó tsibít'in‑la̱ Jesús nga mì yá xi̱ta̱ ke̱èno̱jmí‑la̱, ta̱nga jñà xi̱ta̱ ìsa̱á ndaà kiskinìsòn 'én. ");
INSERT INTO maaNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jñà xi̱ta̱ xi kiì'nchré, ta kjo̱xkón‑la̱, kitsò: ―Ndaà s'ín yije. Síndaà‑ne xi̱ta̱ xi jtayaà ko̱ xi mìkiì ma chja̱. ");
INSERT INTO maaNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ìjngoò na̱chrjein nga kjìn jchán xi̱ta̱ kjòxkóya koa̱ tsjìn tsojmì xi kine, Jesús kiìchja̱‑la̱ xi̱ta̱‑la̱ xi kota'yàt'aà‑la̱, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Jñà xi̱ta̱ koi, mahi̱ma̱keè‑ná. Jyeé kò jàn na̱chrjein tjín‑la̱ nga títsa̱jnako̱‑na koa̱ ni̱mé tjín tsojmì xi kine. ");
INSERT INTO maaNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tsà tà ko̱s'ín siìkasén chjan‑na ni'ya‑la̱ ya̱á ko̱hindaàya ndi̱yá nga tjín xi kjiìn inchrobà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kitsò xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús: ―¿Kós'ín si̱kjèn xi̱ta̱ koi jngoò i̱'nde i̱t'aà xìn ñánda ni̱mé tjín? ");
INSERT INTO maaNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús kiskònangui‑la̱, kitsò‑la̱: ―¿Kó tjín ma i̱nchra̱jín xi tíyijò‑nò? Kitsò jñà xi̱ta̱ xi kota'yàt'aà‑la̱: ―Itoò ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","K'e̱é kitsò Jesús: ―Koa̱tìn‑la̱ kàtìtsa̱jnat'aà nangui jñà xi̱ta̱. Jesús kiskoé i̱nchra̱jín xi itoò ma‑ne; kitsjaà‑la̱ kjo̱ndaà Nainá i̱kjoàn kisìxkoa̱ya; k'e̱é kjònga̱tsja jñà xi̱ta̱ xi kota'yàt'aà‑la̱ mé‑ne nga kisìka'bí‑la̱ jñà xi̱ta̱ xi kjìn ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ti̱koa̱á tíyijò chiba‑la̱ ti̱n jtobá. Jesús kisìchikon‑t'in; i̱kjoàn kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Ti̱ka'bió. ");
INSERT INTO maaNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tsakjèn yije xi̱ta̱ kóho̱tjín skanda kó nga kjòskiì; k'e̱ nga tsibíxkó‑ne jñà xi kjòxkoa̱ya nga tsiningui‑ne, nguì itoò ni̱si̱yá ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jñà xi̱ta̱ xi tsakjèn, kjo̱meè ñijòn jmiì ma‑ne. Jesús, i̱kjoàn kisìhixat'aà‑ne jñà xi̱ta̱; ");
INSERT INTO maaNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","i̱kjoàn jahas'en chitso ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱. Ya̱á kiì i̱'nde ñánda 'mì Dalmanuta. ");
INSERT INTO maaNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ijchò xi̱ta̱ fariseo, tsibíts'ia̱ nga tsajoókjoò‑ko̱ Jesús. Kisìjé jngoò‑la̱ seña xi jeya tjín xi i̱t'aà ts'e̱ Nainá nchrobá‑ne nga mejèn‑la̱ skoe̱ tsà kixi̱ kjoa̱ nga Nainá kisìkasén. ");
INSERT INTO maaNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús 'ñó jaátse‑la̱, kitsò: ―Jñà xi̱ta̱ koi, ¿mé‑ne seña xi jeya tjín síjé‑ne? Xi nguì o̱kixi̱, k'oa̱á xan‑nò, ni̱jngoò seña jcha̱a. ");
INSERT INTO maaNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ya̱á kisìkítsa̱jna xi̱ta̱ koi; jahas'en ìjngoò k'a‑ne chitso; kiì ján xijngoaà ndáchikon. ");
INSERT INTO maaNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, k'e̱ nga kiì, kijchàajiìn‑la̱ mìkiì ts'a i̱nchra̱jín. Tà jngoò ma i̱nchra̱jín xi kjinaya‑la̱ chitso. ");
INSERT INTO maaNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús kitsò‑la̱: ―Chítsejèn‑là koa̱ ti̱kinda̱a yijo‑nò i̱t'aà ts'e̱ na̱'yo̱ san‑la̱ xi̱ta̱ fariseo ko̱ ts'e̱ Herodes. ");
INSERT INTO maaNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús tsohóko̱ xíkjín, kitsò‑la̱: ―Koií k'oa̱ tsò‑ná nga mìkiì kich'á i̱nchra̱jín. ");
INSERT INTO maaNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús kisijiìn‑la̱ koni s'ín nchijoó, k'e̱é kitsò‑la̱: ―¿Mé‑ne ko̱bixón‑nò nga tsjìn‑nò i̱nchra̱jín? ¿A kj'eè fìya‑nò? ¿A mì machi̱ya‑nò? ¿A tsí 'ñó tájaàjiìn tjín ini̱ma̱‑nò? ");
INSERT INTO maaNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tjín xkoòn, ¿mé‑ne mìkiì tsejèn‑nò? Tjín líká‑nò, ¿mé‑ne mìkiì na'yà‑nò? ¿A mì bítsjeèn‑nò ");
INSERT INTO maaNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","k'e̱ kisìka'biá i̱nchra̱jín xi 'òn ma‑ne koa̱ 'òn jmiì xi̱ta̱ tsakjèn? ¿Kó tjín ni̱si̱yá tsiningui‑ne xi tsibíxkó‑ìsa̱? Kitsò jñà xi̱ta̱: ―Tejò ni̱si̱yá komà. ");
INSERT INTO maaNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―K'e̱ nga kisìka'biá jñà i̱nchra̱jín xi itoò ma‑ne, koa̱ ñijòn jmiì xi̱ta̱ tsakjèn, ¿kó tjín ni̱si̱yá tsiningui‑ne xi tsibíxkó‑ìsa̱? Kitsò jñà xi̱ta̱: ―Itoò ni̱si̱yá komà. ");
INSERT INTO maaNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","K'e̱é kitsò‑la̱: ―¿A tà kó kj'eè machi̱ya‑nò? ");
INSERT INTO maaNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesús ijchò ján na̱xa̱ndá Betsaida; ya̱ ijchòko̱ jngoò‑la̱ xi̱ta̱ xi mìkiì tsejèn‑la̱. Tsibítsi'ba‑la̱ nga kàtát'aà‑la̱ tsja jñà xko̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús kitsobà'ñó tsja jè xi̱ta̱ xi mìkiì tsejèn‑la̱. I̱kjoàn tsachrjekàjiìn na̱xa̱ndá, tsibíchrángui xko̱n, i̱kjoàn tsohósòn‑la̱ tsja. K'e̱é kiskònangui‑la̱ a tsejèn chiba‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jè xi̱ta̱ xi mìkiì tsejèn‑la̱ kiskoòtsejèn, kitsò: ―Jye be xi̱ta̱ ta̱nga k'oa̱á ma‑na̱ ta koni kjoàn yá kjoàn nga tjíma. ");
INSERT INTO maaNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús, ìjngoò k'a tsohót'aà‑la̱ tsja jñà xko̱n. Kitsò‑la̱ nga ndaà kàtakotsejèn, ni̱to̱ón kjòndaà‑ne. Ndaà kijtseè yije‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús kisìkasén‑ne ni'ya‑la̱ xi̱ta̱ jè, kitsò‑la̱: ―Kì ya̱ bitjaàs'en‑jiìn na̱xa̱ndá, kì yá xi̱ta̱ xi bèno̱jmí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Itjo Jesús ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱, kiì ya̱ na̱xa̱ndá jtobá xi chja̱‑ne Cesarea ts'e̱ Filipo. K'e̱ nga tjímaya ndi̱yá, Jesús kiskònangui‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱, kitsò‑la̱: ―¿Kó tsò jñà xi̱ta̱? ¿Yá‑ná 'a̱n? ");
INSERT INTO maaNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kitsò jñà xi̱ta̱ xi kota'yàt'aà‑la̱: ―Tjín xi tsò: “Jé Juan xi kis'iìn bautizar xi̱ta̱.” Tjín xi tsò: “Jé Elías.” Ti̱koa̱á tjín xi tsò: “Jngoò xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá.” ");
INSERT INTO maaNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús kiskònangui‑la̱ jñá xi̱ta̱ xi kota'yàt'aà‑la̱; kitsò‑la̱: ―¿Jñò kó bixón? ¿Yá‑ná 'a̱n? Kiìchja̱ Pedro, kitsò: ―Ji̱‑né xi Cristo xi xó kisìkasén‑lè Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ta̱nga jè Jesús kitsò‑la̱: ―Kì yá xi̱ta̱ xi bèno̱jmí‑là xi i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tsibíts'ia̱ Jesús nga tsakóya‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱, kitsò‑la̱: ―'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, tse kjo̱'in siìkjiaán; ko̱chrjengui‑na jñà xi̱ta̱ jchínga, ko̱ jñà xi̱ta̱ sko̱‑la̱ no̱'miì, ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. Si̱ìk'eén‑na ta̱nga k'e̱ nga ki̱jchò jàn na̱chrjein kjoa̱áya‑na. ");
INSERT INTO maaNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesús nguì ndaà tsibéno̱jmí kjoa̱ xi komàt'in. Jé Pedro kiìchja̱t'aàxìn‑la̱ Jesús nga mìkiì ndaà tjín koni tsò. ");
INSERT INTO maaNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ta̱nga Jesús, kisìkáfaya, kiskoòtsejèn‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱, tsohótiko̱ Pedro. Kitsò‑la̱: ―Ti̱si̱t'aàxìn‑ná ji̱ xi̱ta̱ nei̱í. Nga ji̱, mìtsà k'oa̱s'ín nìkítsjiìn koni s'ín tjín kjo̱hítsjeèn‑la̱ Nainá. Ngaji̱ tà k'oa̱s'ín nìkítsjiìn koni s'ín tjín kjo̱hítsjeèn‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesús kiìchja̱‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱ ko̱ xi̱ta̱ xi tji̱ngui‑la̱. Kitsò‑la̱: ―Tsà yá xi mejèn‑la̱ nga xi̱ta̱ ts'a̱n ko̱ma, kàtatsjeiìn‑takòn mé xi mejèn‑la̱ yijo‑la̱; koni jngoò xi̱ta̱ xi 'yajen krò‑la̱, kàtìjnandaà nga si̱ìkjeiín kjo̱'in xi kjoa̱ ts'a̱n; ndaà kàtjìt'aà‑na. ");
INSERT INTO maaNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nga ni̱ta̱ yá xi̱ta̱ xi mejèn‑la̱ ko̱chrjetjì yijo‑la̱ nga ni̱mé kjo̱'in sa̱kò‑la̱, tà sa̱á si̱ìchija‑né ko̱ kjo̱'in kíjnajiìn; ta̱nga jè xi tíjnandaà nga tsjá yijo‑la̱ xi kjoa̱ ts'a̱n ko̱ kjoa̱ ts'e̱ 'én ndaà‑la̱ Nainá, jè‑né xi ki̱tjokàjiìn kjo̱'in nga i̱t'aà ts'a̱n ndaà kíjna. ");
INSERT INTO maaNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Mé xi si̱ìkijne xi̱ta̱ na̱s'ín tjoé yije‑la̱ i̱sò'nde tsà si̱ìchja ini̱ma̱‑la̱? Ni̱mé. ");
INSERT INTO maaNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿A ko̱ma koi̱ìchjí kjoa̱biyaà jngoò xi̱ta̱ xi majìn‑la̱ nga ki̱yá? Majìn. ");
INSERT INTO maaNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tsà tjín i'nga xi̱ta̱ xi ko̱sobà‑la̱ i̱t'aà ts'a̱n ko̱ i̱t'aà ts'e̱ 'én‑na̱ ya̱ nguixko̱n xi̱ta̱ jé xi tjín, ti̱koa̱á 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, ko̱sobà‑na̱ i̱t'aà ts'e̱ k'e̱ nga kjoi̱ikoa̱a ìjngoò k'a kjoa̱jeya‑la̱ Na̱'èn‑na̱ ko̱ àkja̱le̱ tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús kitsò‑ìsa̱: ―O̱kixi̱í xi xan‑nò, títsa̱jnajiìn i'nga xi̱ta̱ i̱jndé xi mìkiì ki̱yá skanda k'e̱ nga skoe̱ kó s'ín otíxoma Nainá nga kjoi̱íko̱ nga'ñó‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nga komà joòn na̱chrjein, Jesús kiìmijìn‑jno jngoò nindoò xi 'nga kji; tà jñà kiìko̱ Pedro, Jacobo ko̱ Juan. K'e̱ nga ijchò i̱'nde jè, Jesús, jahatjìya í'ñó i̱sén‑la̱ nga nguixko̱n jñà xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jè nikje‑la̱ 'ñó kjòchroba, tsí ote ni'ín né. Tsjìn xi̱ta̱ nga tíjtsa i̱sò'nde xi ma‑la̱ ts'iìn nikje koni s'ín kjòchroba. ");
INSERT INTO maaNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ti̱koa̱á kijtseè jè Elías ko̱ Moisés nga nchijoókjoò ko̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jè Pedro kitsò‑la̱ Jesús: ―Maestro, ndaà tjín nga i̱ titsa̱jnaá. Jàn ni'ya xkójndà kíndaà‑je̱n. Jngoò tsi̱ji, jngoò ts'e̱ Moisés, jè xi ìjngoò ts'e̱ Elías. ");
INSERT INTO maaNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jè Pedro tà k'oa̱á kitsò. Mì ti̱ kì beè‑ne kó s'ín kiìchja̱ nga 'ñó kitsakjòn xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","K'e̱é j'iì jngoò 'nguién‑la̱ ifi xi tsibí'ma xi̱ta̱ koi; ya̱á i̱jiìn ifi kina'yà jngoò‑la̱ 'én xi kitsò: ―Jè jèe̱ xi ki'ndí‑na̱ xi 'ñó matsjake̱. Jè ti̱ná'ya‑là. ");
INSERT INTO maaNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ti̱k'e̱‑ne kiskoòtsejèn xi̱ta̱ koi. Mì ti̱ yá tjín‑ne. Tà jè ta̱jngoò Jesús síjna. ");
INSERT INTO maaNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","K'e̱ nga inchrobàjen‑t'aà‑ne nindoò, Jesús kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Kì yá xi̱ta̱ xi bèno̱jmí‑là jè kjoa̱ xi kà'yaà; skanda k'e̱é tèno̱jmí‑là k'e̱ nga kjoa̱áya‑na i̱t'aà ts'e̱ kjoa̱biyaà 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ tsibí'ma jè kjoa̱ jè, sakoa̱á tsajoóya‑ne kó tsò‑ne xi tsò‑la̱ kjoa̱áya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kiskònangui‑la̱ Jesús. Kitsò‑la̱: ―¿Mé‑ne ko̱tsò‑ne jñà xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés nga jè Elías kjoi̱í ítjòn? ");
INSERT INTO maaNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús kitsò‑la̱: ―O̱kixi̱ né. Jè kjoi̱í ítjòn Elías, jè koi̱ìndaàjiìn yije kjoa̱. ¿Koa̱ mé‑ne ko̱tsò‑ne Xo̱jo̱n‑la̱ Nainá nga 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, tseé kjo̱'in siìkjiaán, toòn skoe̱‑na xi̱ta̱? ");
INSERT INTO maaNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ta̱nga 'a̱n, k'oa̱á xán‑nò, jè Elías jyeé j'iì. Jñà xi̱ta̱ k'oa̱á s'ín kisìko̱ koni s'ín mejèn‑la̱. Ta̱nga k'oa̱á s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá nga k'oa̱á s'ín ko̱mat'in. ");
INSERT INTO maaNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesús k'e̱ nga ijchò‑ne ñánda títsa̱jna xi̱ta̱ xi kota'yàt'aà‑la̱ xi i'nga, kijtseè nga kjìn jchán ma xi̱ta̱ xi títsa̱jna. Ya̱á títsa̱jnajiìn i'nga xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, 'ñó nchijoóya‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jñà xi̱ta̱ k'e̱ nga kijtseè nga ijchò Jesús, tà k'oa̱á ko̱ma‑la̱. Kiì yije kóho̱tjín nga kisìhixat'aà. ");
INSERT INTO maaNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús kiskònangui‑la̱, kitsò‑la̱: ―¿Mé xi ko̱ ta ndaà chibàya‑nò? ");
INSERT INTO maaNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","K'e̱é kiìchja̱ jngoò xi̱ta̱ xi ya̱ tíjnajiìn. Kitsò: ―Maestro, jè ki'ndí‑na̱ kòf'iìko̱‑lè. Ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱; mìkiì ma chja̱. ");
INSERT INTO maaNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ni̱to̱n ñánda tíjna k'e̱ nga tsobà'ñó, majndoòt'aà nangui ko̱ ochrje ndáxó tso'ba, síjts'iìn ni̱'ño̱, i̱kjoàn si̱jna tsjò. Koi tìsìjé‑la̱ xi̱ta̱ xi kota'yàt'aà‑lè nga kàtachrjekàjiìn ini̱ma̱‑la̱ jè ini̱ma̱ ch'o‑la̱ nei̱í ta̱nga mìkiì bitjokàjiìn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kiìchja̱ Jesús, kitsò: ―Jñò, xi̱ta̱ xi mìkiì mokjeiín‑nò i̱t'aà ts'a̱n. ¿Skanda mé na̱chrjein kóti̱jnako̱‑nò? ¿Mé na̱chrjein ska̱‑na kjoa̱‑nò? Nchrohóko̱‑ná jè ti i̱jndé. ");
INSERT INTO maaNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","K'e̱é kiìko̱ jè ti ya̱ nguixko̱n Jesús; jè ini̱ma̱ ch'o‑la̱ nei̱í, k'e̱ nga kijtseè Jesús, ìjngoò k'a k'en xín ti. K'e̱ nga kiskaàt'aà nangui tsangáyà'nde koa̱ itjo ndáxó tso'ba. ");
INSERT INTO maaNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús kiskònangui‑la̱ na̱'èn‑la̱, kitsò‑la̱: ―¿A kjòtseé o̱ma‑la̱ ti‑lè? Jè na̱'èn‑la̱ kitsò: ―Ti̱k'e̱‑ne nga sa̱ ndí ti jtobá kji. ");
INSERT INTO maaNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Jè ini̱ma̱ ch'o‑la̱ nei̱í kò kjìn jchán k'a síkatje̱n‑jiìn ni'ín ko̱ síkatje̱n‑jiìn nandá nga mejèn‑la̱ sík'en. Tsà ko̱ma‑lè mé xi si̱koi̱i, jcha̱hi̱ma̱takòn‑náje̱n ko̱ ti̱chját'aà‑náje̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús kitsò‑la̱: ―¿Kó si tsà ko̱ma‑lè? Ma yije‑né ni̱ta̱ mé kjoa̱‑ne jè xi mokjeiín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ni̱to̱ón 'ñó kiìchja̱ jè na̱'èn‑la̱ ti. Kitsò: ―Mokjeiín‑na̱, ti̱chját'aà‑ìsa̱‑ná nga nguì ìsa̱ ndaà ko̱kjeiín‑na. ");
INSERT INTO maaNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesús k'e̱ nga kijtseè nga tíma kjìn xi̱ta̱, tsohótiko̱ jè ini̱ma̱ ch'o‑la̱ nei̱í; kitsò‑la̱: ―Ngaji̱, ini̱ma̱ ch'o‑la̱ nei̱í xi mìkiì ma‑lè nokjoì ko̱ mìkiì na'yì, 'a̱n, k'oa̱á xan‑lè, titjo̱jiìn ini̱ma̱‑la̱ ti jè; kì ti ya̱á bitjaàs'en‑jiìn‑ne ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jè ini̱ma̱ ch'o‑la̱ nei̱í kiskindàyaxá; i̱kjoàn ìjngoò k'a k'en xín ti. I̱kjoàn itjojiìn‑ne ini̱ma̱‑la̱. Kisìkájna jè ti koni tsà jye k'en, jñà xi̱ta̱ xi nchikotsejèn, kitsò: ―Jyeé k'en. ");
INSERT INTO maaNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ta̱nga jè Jesús kitsobà'ñó tsja; kiskímiì'nga; i̱kjoàn tsasíjna kixi̱ jè ti. ");
INSERT INTO maaNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","K'e̱ nga jahas'en ni'ya Jesús, jñà xi̱ta̱ xi kota'yàt'aà‑la̱ kiskònangui‑la̱ nga ta̱jngoò, kitsò‑la̱: ―¿Mé‑ne ngaje̱n mìkiì kòbitjojiìn‑na̱je̱n jè ini̱ma̱ ch'o‑la̱ nei̱í? ");
INSERT INTO maaNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kiìchja̱ Jesús, kitsò: ―Jñà ini̱ma̱ ch'o‑la̱ nei̱í xi o̱kjoàn, k'e̱é bitjokàjiìn nga nokjoàt'aà‑là Nainá ko̱ nga bijnachjaán. ");
INSERT INTO maaNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","K'e̱ nga kiì‑ne ya̱ i̱'nde jè, jahatojiìn nangui Galilea. Ta̱nga Jesús majìn‑la̱ nga xi̱ta̱ skoe̱; ");
INSERT INTO maaNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jesús k'oa̱á s'ín tsakóya‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱. Kitsò‑la̱: ―'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ ya̱á tso̱ba̱'ñó‑na jñà xi̱ta̱; i̱kjoàn si̱ìk'en‑na. Ta̱nga k'e̱ nga ki̱jchò jàn na̱chrjein nga ki̱yá, kjoa̱áya‑na. ");
INSERT INTO maaNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ta̱nga jñà xi̱ta̱ xi kota'yàt'aà‑la̱ mìkiì kjòchi̱ya‑la̱ 'én xi kitsò‑la̱. Tà kitsakjòn‑né, mìkiì kiskònangui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","K'e̱ nga ijchò ya̱ na̱xa̱ndá Capernaum, k'e̱ nga jye títsa̱jna i̱ya ni'ya, Jesús kiskònangui‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱, kitsò‑la̱: ―¿Mé xi koa̱ ta ndaà chibàya‑nò k'e̱ nga tìtsa̱nchrobáya ndi̱yá? ");
INSERT INTO maaNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Xi̱ta̱ xi kota'yàt'aà‑la̱ tà jyò tsibìtsa̱jna, koi‑né, k'e̱ nga nchinchrobá ya̱ ndi̱yá, tsajoóya‑ne yá xi̱ta̱ xíkjín xi kíjna ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesús tsibìjna; i̱kjoàn kiìchja̱‑la̱ nga tejò xi̱ta̱ xi kota'yàt'aà‑la̱, kitsò‑la̱: ―Tsà yá xi̱ta̱ xi mejèn‑la̱ nga kíjna ítjòn, ta saà jè kjoe̱het'aà‑ne, chi̱'nda‑la̱ kàtama ngats'iì xi̱ta̱ xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesús kiskoé jngoò ndí ti. Tsasíjna 'nchòhosen. Tsa'nga. I̱kjoàn kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Ni̱ta̱ yá‑ne xi i̱t'aà ts'a̱n skoétjò jngoò ndí ti koni jè, 'a̱án xi skoétjò‑na; ko̱ jè xi skoétjò‑na mìtsà tà 'a̱n skoétjò‑na, ti̱koa̱á jè skoétjò xi kisìkasén‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kiìchja̱ Juan, kitsò: ―Maestro, jngoò xi̱ta̱ ki'ya‑je̱n xi i̱t'aà tsi̱ji ochrjekàjiìn ini̱ma̱ ch'o‑la̱ nei̱í ini̱ma̱‑la̱ xi̱ta̱. Ta̱nga mìtsà xi̱ta̱ tsa̱ján; mìkiì kits'iì'nde‑la̱je̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús kitsò: ―Kì k'oa̱á nìko̱o. Ni̱yá‑jèn xi i̱t'aà ts'a̱n s'i̱in jngoò kjo̱xkón xi ndaà tjín xi ti̱jè ki̱chja̱jno‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jè xi mìtsà kondra̱ tsa̱ján, i̱t'aà tsa̱ján tíjna. ");
INSERT INTO maaNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ngats'iì xi̱ta̱ xi i̱t'aà ts'a̱n tsjá jngoò chi̱tsín‑nò nandá, koií kjoa̱‑la̱ nga xi̱ta̱‑la̱ Cristo 'mì‑nò, o̱kixi̱í xi xan‑nò, jñà xi̱ta̱ koi, tjoé‑la̱ chjí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Ni̱ta̱ yá‑ne xi jé ski̱nìjiìn jngoò ndí xi̱ta̱ i̱ma̱ xi mokjeiín‑la̱ i̱t'aà ts'a̱n, ìsa̱á‑la ndaà ko̱ma tsà si̱ngui'ñó jngoò nda̱jo̱ natsí ís'iìn, i̱kjoàn si̱katje̱ngui ndáchikon. ");
INSERT INTO maaNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tsà jè ndsa̱a ótsji jé‑nò, ti̱chátjòn. Ìsa̱á ndaà‑ne tsà xkoán titsjoò nga ki̱tjás'e̱n‑jñoò kjoa̱binachon mì k'oa̱‑ne tsà jò ma ndsa̱a koa̱ ján konguió i̱jiìn ni'ín ñánda mìkiì bits'o, ");
INSERT INTO maaNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ya̱ ñánda mìkiì biyaà chi̱'ndo xi kine‑ná ko̱ ya̱ ñánda mìkiì bits'o ni'ín nga tìtiá. ");
INSERT INTO maaNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tsà jñà ndso̱koò ótsji jé‑nò, ti̱chátjòn. Ìsa̱á ndaà‑ne tsà xkoán titsjoò nga ki̱tjás'e̱n‑jñoò kjoa̱binachon mì k'oa̱‑ne tsà jò ma ndso̱koò koa̱ ján konguió i̱jiìn ni'ín, ");
INSERT INTO maaNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ya̱ ñánda mìkiì biyaà chi̱'ndo xi kine‑ná ko̱ ya̱ ñánda mìkiì bits'o ni'ín nga tìtiá. ");
INSERT INTO maaNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tsà jñà xkoòn ótsji jé‑nò, ti̱nachrjeè. Ìsa̱á ndaà‑ne tsà jngoò ma xkoòn nga ki̱tjás'e̱n‑jñoò ñánda tíhotíxoma Nainá mì k'oa̱á‑ne tsà jò ma xkoòn koa̱ ján konguió i̱jiìn ni'ín ");
INSERT INTO maaNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ya̱ ñánda mìkiì biyaà chi̱'ndo xi kine‑ná ko̱ ya̱ ñánda mìkiì bits'o ni'ín nga tìtiá. ");
INSERT INTO maaNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ngats'iì xi̱ta̱ sa̱ ni'ín ko̱tsjeè‑ne, koa̱ jñà kjo̱tjò xi tsjá xi̱ta̱, na̱xa̱á ko̱jnchra‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jè na̱xa̱, ndaà‑né; ta̱nga tsà mì ti̱ kiì jnchra‑ne, ¿kós'ín si̱ko̱‑là nga ko̱jnchra ìjngoò k'a? Kàtasijiìn na̱xa̱ ini̱ma̱‑nò koa̱ 'nchán titsa̱jnako̱ xinguio̱o. ");
INSERT INTO maaNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús itjojiìn ya̱ na̱xa̱ndá Capernaum, kiì ján i̱'nde Judea, ijchò ján nangui i̱jto̱n xa̱jngá nandá Jordán. Ya̱á kòkjìn ìjngoò k'a xi̱ta̱; koa̱ jè tsibíts'ia̱ ìjngoò k'a nga tsakóya‑la̱ xi̱ta̱ koni s'ín kjit'aà. ");
INSERT INTO maaNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ijchò kinchat'aà chrañà i'nga‑la̱ xi̱ta̱ fariseo. Nga mejèn‑la̱ skóna̱cha̱n‑la̱, kiskònangui‑la̱, kitsò‑la̱: ―¿A tjí'nde‑la̱ xi x'i̱n nga tsjín chjo̱ón‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ta̱nga Jesús kitsò‑la̱: ―¿Kós'ín tsakóya‑nò Moisés? ");
INSERT INTO maaNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kitsò xi̱ta̱ koi: ―Moisés kitsjaà'nde‑né nga ma si̱ndaà xo̱jo̱n nga ko̱ma tsjín xíkjín xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús kitsò‑la̱: ―Moisés, koi k'oa̱ kitsò‑nò, jñò, 'ñó tájaàjiìn tjín ini̱ma̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ta̱nga k'e̱ nga sa̱ kisindaà i̱sò'nde, Nainá tsibíndaà x'i̱n ko̱ chjo̱ón. ");
INSERT INTO maaNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","K'oa̱á ma‑ne nga jè x'i̱n si̱ìkíjna na̱'èn‑la̱ ko̱ nea̱‑la̱ nga kíjnako̱ chjo̱ón‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ta jngoò xi̱ta̱ ko̱ma‑ne ingajò. Mìtsà ti̱ jò ma‑ne, ta̱ jngoò ko̱ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","K'oi̱í kjoa̱‑la̱ nga mì yá xi̱ta̱ tjí'nde‑la̱ nga si̱ìtsjiìn xíkjín xi Nainá kisìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","K'e̱ nga ijchò‑ne ni'ya‑la̱, jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kiskònangui ìjngoò k'a‑la̱ ti̱koi‑ne kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús kitsò‑la̱: ―Jè xi̱ta̱ xi tsjín chjo̱ón‑la̱, i̱kjoàn bixan‑ko̱ ìjngoò xi kj'ei̱í chjo̱ón, kjoa̱ chijngui tís'ín i̱t'aà ts'e̱ chjo̱ón‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tsà jè chjo̱ón tsjín x'i̱n‑la̱ i̱kjoàn bixan‑ko̱ ìjngoò xi kj'ei̱í x'i̱n, ti̱koa̱á kjoa̱ chijngui tís'ín i̱t'aà ts'e̱ x'i̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jngoò k'a jñà xi̱ta̱ j'iìko̱‑la̱ ndí i̱xti jè Jesús nga mejèn‑la̱ si̱ìchikon‑t'in; ko̱òt'aà‑la̱ tsja. Ta̱nga jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús mìkiì kitsjaà'nde‑la̱. Tsohótiko̱‑né. ");
INSERT INTO maaNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","K'e̱ nga kijtseè Jesús, kòjti‑la̱, kitsò‑la̱: ―Tjiì'nde‑là ndí i̱xti kàtjanchrobákon‑na. Kì binchahikon‑là. Jñà xi k'oa̱á s'ín tjín ini̱ma̱‑la̱ koni ts'e̱ ndí i̱xti, jñà xi tjín‑la̱ kjo̱ndaà nga Nainá tíhotíxoma‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","K'oa̱á xan‑nò xi nguì o̱kixi̱, jñà xi mìkiì ko̱kjeiín‑la̱ koni jngoò ndí i̱xti nga skoé kjo̱ndaà‑la̱ Nainá nga jè ko̱tìxoma‑la̱, mìkiì kjoa̱has'en‑jiìn ñánda tíhotíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesús tsa'nga jñà ndí i̱xti; tsohósòn‑la̱ tsja; i̱kjoàn kisìjét'aà‑la̱ Nainá nga kàtasíchikon‑t'in jñà i̱xti. ");
INSERT INTO maaNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","K'e̱ nga tífì ìjngoò k'a‑ne Jesús, tsangachikon jngoò xi̱ta̱ xi ijchò tji̱ngui‑la̱. Tsasìxkó'nchit'aà‑la̱; i̱kjoàn kiskònangui‑la̱; kitsò‑la̱: ―Ji̱ Maestro ndaà, ¿mé xi s'iaàn nga s'e̱‑na kjoa̱binachon ni̱ta̱ kjé‑ne? ");
INSERT INTO maaNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús kitsò‑la̱: ―¿Mé‑ne nga xi̱ta̱ ndaà 'mì‑ná? Ni̱jngoò xi̱ta̱ xi ndaà, ta̱ jngoò jè Nainá xi ndaà. ");
INSERT INTO maaNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jyeé tíjiìn‑lè kó tsò kjo̱tíxoma: “Kì xi̱ta̱ nìk'in; kì kjoa̱ chijngui 'nì; kì chijé 'nì; kì 'én ndiso nokjoì i̱t'aà ts'e̱ xi̱ta̱ xi kj'ei̱í; kì chona̱cha̱n‑jèn; cha̱xkoín na̱'èn‑lè ko̱ nea̱‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jè xi̱ta̱ nchi̱ná kitsò: ―Maestro, ngats'iì kjo̱tíxoma koi, jyeé kisìkitasoàn kó nga sa̱ chítia. ");
INSERT INTO maaNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús tsja komà‑la̱, kiskoò'an, i̱kjoàn kitsò‑la̱: ―Ìjngoò kjoa̱ chija‑lè. T'in, tatìjni yije tsojmì xi tjín‑lè. I̱kjoàn ti̱ka'bí‑la̱ xi̱ta̱ i̱ma̱ mé‑ne nga s'e̱‑lè kjoa̱ machikon‑t'in ján ngajmiì. I̱kjoàn nchrobátji̱ngui‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jè xi̱ta̱ nchi̱ná, tà kjòbaá‑la̱ nga kiì'nchré 'én koi. Tà ba kis'e‑la̱ nga kiì, koi xó nga 'ñó kjìn tsojmì tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús kiskoòtsejèn tji̱ngui‑la̱, kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―'Iín jchán ko̱ma‑la̱ jñà xi̱ta̱ nchi̱ná nga kjoa̱has'en‑jiìn ñánda tíhotíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, k'e̱ nga kiì'nchré 'én koi, tà k'oa̱á komà‑la̱. Ta̱nga jè Jesús ìjngoò k'a kitsò‑la̱: ―Jñò xi ki'ndí‑na̱ xan‑nò, 'ñó 'iín ko̱ma‑la̱ jñà xi̱ta̱ xi to̱n‑la̱ 'ñót'aà takòn nga kjoa̱has'en‑jiìn kjo̱tíxoma‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ìsa̱á mì 'in ko̱ma‑la̱ jngoò cho̱ camello nga kjoa̱has'en xko̱n nindoò xi tjahaña‑ne nikje, mì k'oa̱á‑ne koni jngoò xi̱ta̱ nchi̱ná xi 'ñó tjín‑la̱ tsojmì nga ko̱ma kjoa̱has'en‑jiìn ñánda tíhotíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, ìsa̱á ndaà kjòxkón‑la̱. I̱kjoàn kiskònangui‑la̱ xíkjín, kitsò: ―¿Yá‑né xi ki̱tjokàjiìn kjo̱'in? ");
INSERT INTO maaNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús kiskoò'an, kitsò: ―Jñà xi̱ta̱ mìkiì ko̱ma‑la̱; ta̱nga Nainá ko̱maá‑la̱; i̱t'aà ts'e̱ Nainá ni̱ta̱ mé kjoa̱‑ne, ko̱ma yijeé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kiìchja̱ Pedro, kitsò: ―Na̱'èn, ngaje̱n, jyeé kinìkítsa̱jna yije‑je̱n ngats'iì tsojmì xi tjín‑naje̱n nga tjaàtji̱ngui‑lèje̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús kitsò: ―O̱kixi̱ xi xan‑nò, ni̱ta̱ yá xi̱ta̱‑ne xi kisìkíjna ni'ya‑la̱, 'ndse̱, ndichja, nea̱‑la̱, na̱'èn‑la̱, chjo̱ón‑la̱, i̱xti‑la̱ ko̱ nangui‑la̱ xi kjoa̱ i̱t'aà ts'a̱n ko̱ i̱t'aà ts'e̱ 'én ndaà‑la̱ Nainá ");
INSERT INTO maaNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","i̱ i̱sò'nde, ìsa̱á tsato tjoé ngajo‑la̱ xi ni'ya 'mì, xi 'ndse̱, ndichja, nea̱‑la̱, i̱xti‑la̱ ko̱ nangui‑la̱, na̱s'ín kji̱tji̱nguikeè xi̱ta̱ kondra̱. Ta̱nga jè i̱sò'nde xi sa̱ nchrobá, s'e̱é‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kjìn xi̱ta̱ xi títsa̱jna ítjòn i̱'ndei̱, k'e̱ nga ko̱ma i̱skan jñà kítsa̱jna tji̱ngui. Ko̱ xi títsa̱jna tji̱ngui i̱'ndei̱ k'e̱ nga ko̱ma i̱skan jñà kítsa̱jna ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús, tsó'ba ítjòn‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱ nga nchifì ján na̱xa̱ndá Jerusalén. Jñà xi̱ta̱ xi tji̱ngui tà nchimaxkón‑la̱ nga nchifì. K'e̱é kiìchja̱t'aà‑xìn ìjngoò k'a‑la̱ xi̱ta̱‑la̱ xi tejò ma‑ne, i̱kjoàn tsibéno̱jmí ìjngoò k'a‑la̱ jè kjoa̱ xi komàt'in. Kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―I̱'ndei̱ ján titsa̱honguiá na̱xa̱ndá Jerusalén; 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, ya̱á tsobà'ñó‑na xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés nga koi̱ì'nè‑na kjoa̱biyaà, i̱kjoàn si̱ìnga̱tsja‑na jñà xi mìtsà xi̱ta̱ judío ");
INSERT INTO maaNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","nga si̱ìsobà‑na̱, ki̱ìchrájno‑na̱, ko̱jà‑na, i̱kjoàn si̱ìk'en‑na. Ta̱nga k'e̱ ki̱jchò jàn na̱chrjein kjoa̱áyaá‑na. ");
INSERT INTO maaNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jacobo ko̱ Juan i̱xti‑la̱ Zebedeo ijchò kinchat'aà‑la̱ Jesús, kitsò‑la̱: ―Maestro, mejèn‑naje̱n nga k'oi̱‑náje̱n jè kjo̱ndaà xi si̱jé‑lèje̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús kiskònangui‑la̱, kitsò‑la̱: ―¿Mé‑ne xi mejèn‑nò nga tsjaà‑nò? ");
INSERT INTO maaNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Jacobo ko̱ Juan kitsò: ―K'e̱ nga jeya ki̱jni nga tìhotìxomai, ki̱'nde‑náje̱n nga ya̱ kitsa̱t'aà‑lèje̱n, jngoò kíjnat'aà‑lè kixi̱‑lè koa̱ jngoò kíjnat'aà‑lè ngaskón‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","K'e̱é kitsò Jesús: ―Mìkiì 'yaà mé xi nìjé. ¿A ki̱chìkjoa̱á‑nò nga s'io̱ya jè chi̱tsín ts'e̱ kjo̱'in xi 'a̱n skia̱a, a chíkjoa̱‑nò nga ko̱ma bautizar ts'e̱ kjo̱'in xi 'a̱n tímat'ian? ");
INSERT INTO maaNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kitsò jñà xi̱ta̱ koi: ―Ki̱chìkjoa̱á‑na̱je̱n. Kitsò‑la̱ Jesús: ―Jñò, ko̱maá s'io̱o koa̱ ko̱ma‑nò bautizar i̱t'aà ts'e̱ kjo̱'in xi 'a̱n ko̱tojñaà, ");
INSERT INTO maaNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ta̱nga xi 'a̱n tsjaà‑nò nga ya̱ ki̱tsa̱jnat'aà‑ná ya̱ kixi̱‑na̱ ko̱ ngaskón‑na̱ mìtsà 'a̱n oko̱‑na nga tsjaà‑nò. Jñà i̱'nde koi, jñà tjoé‑la̱ xi̱ta̱ xi Nainá títsa̱jnandaà‑la̱ nga tsjá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","K'e̱ nga kiì'nchré jñà xi̱ta̱‑la̱ Jesús xi i'nga xi te ma‑ne, kòjti‑la̱ koni kitsò Jacobo ko̱ Juan. ");
INSERT INTO maaNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ta̱nga jè Jesús kiìchja̱‑la̱, kitsò‑la̱: ―Jye tíjiìn‑nò nga jñà xi̱ta̱ sko̱‑la̱ na̱xa̱ndá xi 'ya‑la̱ nga kjo̱tíxoma tjíya tsja, nangui síkítsa̱jna xi̱ta̱‑la̱ xi jñà otíxoma‑la̱. Ti̱koa̱á jñà xi̱ta̱ xi 'ñó jeya títsa̱jna, beètoòn‑né jñà xi xi̱ta̱ i̱ma̱. ");
INSERT INTO maaNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ta̱nga jñò mìkiì k'oa̱s'ín s'e̱en; tsà jngoò xi̱ta̱ xinguio̱o mejèn‑la̱ 'nga kíjna, jè xi kàtasíxá‑la̱ xi̱ta̱ xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Koa̱ jè xi mejèn‑la̱ kíjna ítjòn, chi̱'nda‑la̱ kàtama ngats'iì xi̱ta̱ xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ndaà tsà 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, mìtsà koi xá j'i̱‑na nga 'a̱n ko̱s'in‑na; tà sa̱á 'a̱n siìxá‑la̱ xi̱ta̱ xi i'nga, ko̱ tsjaà yijo‑na̱ ko̱ ini̱ma̱‑na̱ nga kjìn xi̱ta̱ kítsa̱jnandei̱í kjoa̱ ts'e̱ jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","K'e̱ nga ijchò na̱xa̱ndá Jericó nga jye nchibitjojiìn na̱jnchra̱, Jesús tji̱ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱ ko̱ kjìn xi̱ta̱ tji̱ngui‑ìsa̱‑la̱. Ya̱ i̱ndiì ndi̱yá tíjna jngoò xi̱ta̱ i̱ma̱ xi mìkiì tsejèn‑la̱ xi 'mì Bartimeo, ti‑la̱ ma xi̱ta̱ xi 'mì Timeo, nga tísíjé kjo̱tjò tsojmì. ");
INSERT INTO maaNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jè xi̱ta̱ xi mìkiì tsejèn‑la̱ k'e̱ nga kiì'nchré nga jè Jesús xi Nazaret ts'e̱ tífì, ni̱to̱ón kiìchja̱‑la̱, kitsò‑la̱: ―¡Jesús, nga ya̱ nchrobàt'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David nga ji̱ tijna ngajo‑la̱, jcha̱hi̱ma̱takòn‑ná! ");
INSERT INTO maaNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kjìn ma xi̱ta̱ xi tsohótiko̱ Bartimeo nga jyò kàtìjna. Ta̱nga jè Bartimeo ìsa̱á 'ñó kiìchja̱. Kitsò: ―¡Ji̱ xi ya̱ nchrobàt'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David, jcha̱hi̱ma̱takòn‑ná! ");
INSERT INTO maaNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","K'e̱é tsasíjna Jesús, kitsò: ―Ti̱nókjoa̱‑là. I̱kjoàn kinokjoà‑la̱ jè xi̱ta̱ xi mìkiì tsejèn‑la̱. Kitsò‑la̱: ―'Ñó te‑la̱ takoìn, ti̱sítji̱in, chja̱‑lè Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jè xi̱ta̱ xi mìkiì tsejèn‑la̱ kisìkatje̱n i̱nchro̱kisòn‑la̱, ni̱to̱ón tsasítje̱n, kiì kasìt'aà‑la̱ ñánda síjna Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús kiskònangui‑la̱, kitsò‑la̱: ―¿Mé xi mejèn‑lè nga si̱ìko̱‑lè? Jè xi̱ta̱ xi mìkiì tsejèn‑la̱ kitsò: ―Maestro, mejèn‑na̱ nga kàtatsejèn‑na. ");
INSERT INTO maaNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús kitsò‑la̱: ―T'in‑ne; koi‑né nga mokjeiín‑lè i̱t'aà ts'a̱n nga kòmandaà‑ne. Jè xi̱ta̱ xi mìkiì tsejèn‑la̱ ni̱to̱ón kjòtsejèn‑la̱. Kiìtji̱ngui‑la̱ koni s'ín ndi̱yá tífì Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","K'e̱ nga jye kjo̱meè bijchó chrañà‑la̱ na̱xa̱ndá Jerusalén, jñà na̱xa̱ndá xi 'mì Betfagé ko̱ Betania, ya̱ i̱t'aà nindoò Yá Olivo, Jesús kisìkasén jò xi̱ta̱ xi kota'yàt'aà‑la̱; ");
INSERT INTO maaNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kitsò‑la̱: ―Tanguió ján ndí na̱xa̱ndá i̱tsé xi kijnat'aà ján. K'e̱ nga kijchoò ya̱á síjnat'aà'ñó jngoò búrró ki'ndí xi ni̱ sa̱á yá bìjnasòn‑la̱. Chíjnda̱'ñó, nchrohóko̱o. ");
INSERT INTO maaNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tsà yá xi kjònangui‑nò, tsà ki̱tso̱‑nò: “¿Mé‑ne ko̱nìko̱‑nò búrró?”, tìn‑là: “Jé xó Na̱'èn‑ná Jesús ko̱chjeén‑la̱, koa̱ ni̱to̱ón xó si̱ìkasén‑ne.” ");
INSERT INTO maaNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kiì jñà xi̱ta̱ xi kota'yàt'aà‑la̱. K'e̱ nga ijchò jngoò ni'ya, ya̱á tjít'aà'ñó jngoò búrró jè xotjoa̱‑la̱ ni'ya ya̱ i̱ya ndi̱yá. K'e̱ nga kiskíjnda̱'ñó. ");
INSERT INTO maaNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jñà xi̱ta̱ xi ya̱ títsa̱jna kitsò‑la̱: ―¿Mé s'e̱en‑nò, mé‑ne chíjnda̱'ñó‑nò ndí búrró? ");
INSERT INTO maaNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","K'oa̱á s'ín kitsò‑la̱ koni s'ín tsibéno̱jmí‑la̱ Jesús; kitsjaà'nde‑la̱ nga kiìko̱. ");
INSERT INTO maaNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","K'e̱ nga ijchòko̱ ñánda tíjna Jesús jè ndí búrró, jñà nikje ts'e̱ xi̱ta̱ kisìkjeén nga tsohójtsa‑la̱ jè ndí búrró; i̱kjoàn tsibìjnasòn‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kjìn xi̱ta̱ tsohójngoò nikje‑la̱ ya̱ i̱ya ndi̱yá. Jñà xi̱ta̱ xi i'nga, xka̱ chrja‑la̱ yá tsohójngoò xi tsate ya̱ i̱jiìn ijñá. ");
INSERT INTO maaNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jñà xi̱ta̱ xi títjòn ko̱ xi tji̱ngui 'ñó chja̱, nga kitsò: ―¡Mé tà ndaà‑la̱ jè xi nchrobá ngajo‑la̱ Nainá, jè xi otíxoma‑ná! ");
INSERT INTO maaNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Mé tà ndaà‑ne nga jè ko̱tìxoma ngajo‑la̱ xi̱ta̱ jchínga‑ná David! ¡Kàtas'e kjoa̱jeya ján ngajmiì! ");
INSERT INTO maaNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús jahas'en‑jiìn ya̱ na̱xa̱ndá Jerusalén. I̱kjoàn jahas'en ndi̱tsin i̱ngo̱ ítjòn. Xki̱ xi ján kiskoòtsejèn. I̱kjoàn itjo‑ne; kiìko̱ xi̱ta̱‑la̱ xi tejò ma‑ne ján na̱xa̱ndá Betania, koi‑né nga jye kjòhoxòn. ");
INSERT INTO maaNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","K'e̱ ko̱ma nchijòn nga itjo ìjngoò k'a‑ne ján na̱xa̱ndá Betania, Jesús kjòhojò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","K'e̱é kijtseè jngoò yá‑la̱ toò iko̱ xi kjiìn síjna. Kiì katsejèn‑la̱ tsà yijà‑la̱ toò, ta̱nga ni̱mé tjín‑la̱; tà xka̱á tjín‑la̱. Mìtsà na̱chrjein‑la̱ toò. ");
INSERT INTO maaNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","K'e̱é kitsò‑la̱ jè yá toò iko̱: ―Ni̱ ti̱ yá xi ski̱ne̱‑ne toò‑lè. Xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kiì'nchré 'én koi. ");
INSERT INTO maaNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","K'e̱ nga ijchò na̱xa̱ndá Jerusalén, Jesús jahas'en ya̱ ndi̱tsin i̱ngo̱ ítjòn; i̱kjoàn tsibíts'ia̱ nga tsachrje jñà xi̱ta̱ xi tsojmì otíjna ko̱ xi otse tsojmì. Kisìhitíkjá ími̱xa̱‑la̱ jñà xi̱ta̱ xi síkjatjìya to̱n ti̱koa̱á kisìhitíkjá íxi̱le̱‑la̱ xi̱ta̱ xi otíjna ni̱se paloma. ");
INSERT INTO maaNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mì ti̱ kiì kitsjaà'nde‑la̱ xi̱ta̱ xi tsojmì otíjna nga ch'á fahatoyako̱ i̱ngo̱ ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","I̱kjoàn tsakóya‑la̱ xi̱ta̱. Kitsò‑la̱: ―Jè Xo̱jo̱n‑la̱ Nainá tsò‑né: “Ni'ya‑na̱, ni'ya ts'e̱ o̱chikoón k'oín nga i̱ ki̱chja̱t'aà‑na ngats'iì xi̱ta̱ na̱xa̱ndá xi tjín kóho̱kji i̱sò'nde.” Ta̱nga jñò, nguijo‑la̱ xi̱ta̱ chijé titsa̱'nè. ");
INSERT INTO maaNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","K'e̱ nga kiì'nchré jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, tsohótsji'nde‑la̱ kós'ín si̱ìko̱ nga si̱ìk'en Jesús nga tsakjón‑la̱. Koií kjoa̱‑la̱ nga jñà kjo̱tíxoma xi okóya Jesús ndaá tsò, ko̱ jñà xi̱ta̱ xi 'nchré‑la̱ tà k'oa̱á ma‑la̱ 'én xi okóya. ");
INSERT INTO maaNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","K'e̱ nga jye kòjñò, Jesús ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱ itjojiìn na̱xa̱ndá Jerusalén, xìn kiì. ");
INSERT INTO maaNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","K'e̱ nga ta̱jñòya nga ko̱ma nchijòn, ja ìjngoò k'a ñánda síjna yá toò iko̱, kijtseè nga jye kixì yá kóho̱kji skanda i̱'ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jè Pedro tsibítsjeèn‑la̱ koni kitsò Jesús. K'e̱é kitsò‑la̱: ―Maestro, chítsejèn‑la̱ jè yá toò iko̱ xi 'on kinokjoàkoi̱i ngojña̱. Jye kixì. ");
INSERT INTO maaNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús kiìchja̱; kitsò: ―Kàtakjeiín‑nò i̱t'aà ts'e̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","O̱kixi̱í xi xan‑nò, tsà yá xi ki̱tso̱‑la̱ jè nindoò jè: “Ti̱si̱xìn; ján ti̱katje̱n‑jiìn yijo‑lè ján i̱jiìn ndáchikon.” Tsà mìtsà tà jò tjín‑la̱ k'e̱ nga o̱ki̱tso̱ nga tíjngoò ini̱ma̱‑la̱ nga mokjeiín‑la̱, k'oa̱á s'ín ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Koi ko̱s'ín xan‑nò kóho̱tjión, k'e̱ nga kítsi'ba‑là Nainá, k'oa̱á s'ín kàtakjeiín‑nò koni tsà jye kitjoé‑nò mé‑ne nga tjoé‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","K'e̱ nga ki̱nókjoa̱t'aà‑la̱ Nainá ti̱jchàat'aà‑là jé‑la̱ xinguio̱o mé‑ne jè Na̱'èn‑nò xi tíjna i̱t'aà ngajmiì si̱ìjchàat'aà‑nò jé‑nò xi tsa̱jòn. ");
INSERT INTO maaNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ta̱nga tsà mìkiì si̱jchàat'aà‑là jé‑la̱ xi̱ta̱ xinguio̱o ti̱koa̱ mìkiì si̱ìjchàat'aà‑nò Na̱'èn‑ná xi tíjna ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesús ijchò ìjngoò k'a Jerusalén. K'e̱ nga tsó'ba ya̱ ndi̱tsin i̱ngo̱ ítjòn, j'iì kinchat'aà‑la̱ jñà xi̱ta̱ sko̱‑la̱ no̱'miì, ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, ko̱ xi̱ta̱ jchínga; ");
INSERT INTO maaNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","kiskònangui‑la̱, kitsò‑la̱: ―¿Mé kjo̱tíxoma xi tsjá'nde‑lè koni s'ín 'nì? ¿Yá xi kitsjaà‑lè kjo̱tíxoma kjoa̱ xi 'nì? ");
INSERT INTO maaNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús kitsò‑la̱: ―Ti̱koa̱á 'a̱n jngoò kjoa̱ skònangui‑nò. Ko̱t'ìn‑ná, koa̱ 'a̱n, k'oa̱á xán‑nò yá xi kitsjaà‑na̱ kjo̱tíxoma koni s'ín s'iaàn. ");
INSERT INTO maaNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Yá xi kitsjaà‑la̱ kjo̱tíxoma Juan nga kis'iìn bautizar xi̱ta̱? ¿A Nainá‑né xi tíjna ngajmiì, o xi tà xi̱ta̱‑né? Ko̱t'ìn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jñà xi̱ta̱ koi, k'e̱é tsajoóya‑ne, kitsò‑la̱ xíkjín: ―Tsà kixoán: “Nainá kitsjaà‑la̱ kjo̱tíxoma”, ki̱tso̱‑né: “¿Mé‑ne mìkiì kòkjeiín‑nò i̱t'aà ts'e̱?” ");
INSERT INTO maaNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mì‑la kiì ko̱ma kixoán: “I̱t'aà ts'e̱ xi̱ta̱‑né.” Nga̱ jñà xi̱ta̱ na̱xa̱ndá tsakjón‑la̱, koi‑né nga jñà xi̱ta̱ k'oa̱á tsò nga jè Juan, nguì kjoa̱ kixi̱‑né nga jè xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","K'e̱é kiìchja̱, kitsò‑la̱ Jesús: ―Mìkiì 'ya‑je̱n. Jè Jesús kitsò‑la̱: ―Ti̱koa̱á 'a̱n mìkiì k'oa̱ xán‑nò yá xi kitsjaà‑na kjo̱tíxoma koni s'ín s'iaàn. ");
INSERT INTO maaNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tsibíts'ia̱ Jesús nga tsibéno̱jmíya kjoa̱ xi mangásòn. Kitsò: ―Jngoò xi̱ta̱ tsibítje̱ toò uva, tsibíndiì‑la̱ ínchíbá, i̱kjoàn tsibíndaà jngoò i̱'nde ñánda tsi'ñóngui nandá‑la̱ toò uva. Ti̱koa̱ tsibíndaà jngoò torre xi síkinda̱ yije kóho̱tjín. I̱kjoàn kisìkìña‑la̱ nangui xi̱ta̱ xi kj'ei̱í nga kisìxásòn. I̱kjoàn kiì jè nei‑la̱ nangui ñánda i̱'nde kjiìn. ");
INSERT INTO maaNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","K'e̱ nga ijchò na̱chrjein‑la̱ nga kòjchá toò uva, jè nei‑la̱ nangui kisìkasén jngoò xi̱ta̱ chi̱'nda‑la̱ nga kisìjé‑la̱ xi jè tjoé chiba‑la̱ ts'e̱ tsojmì xi kòjchá. ");
INSERT INTO maaNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ta̱nga jñá xi̱ta̱ xi síxásòn nangui kitsobà'ñó koa̱ kiskaàn‑ko̱, tà kisìkasén tiyaá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jé nei‑la̱ nangui kisìkasén ìjngoò xi̱ta̱ chi̱'nda‑la̱. Ti̱koa̱á tà nda̱jo̱ tsibínè, tsate sko̱, kisìki'on ko̱ ch'o kisìko̱. ");
INSERT INTO maaNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jè nei‑la̱ nangui ìjngoò kisìkasén xi̱ta̱ chi̱'nda‑la̱. Ti̱koa̱á kisìk'en‑né. Kjìn xi̱ta̱‑la̱ kisìkasén‑ìsa, ta̱nga tjín xi kiskaàn‑ko̱, koa̱ tjín xi kisìk'en. ");
INSERT INTO maaNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ko̱ jè nei‑la̱ nangui tà jngoò xi̱ta̱‑la̱ tíjna‑ìsa; tà jè ki'ndí‑la̱ xi 'ñó matsjakeè kisìkasén, kitsò: “Skoe̱xkón‑la̱ ki'ndí‑na̱.” ");
INSERT INTO maaNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ta̱nga jñà xi̱ta̱ xi síxájiìn nangui, tsajoóya‑ne, kitsò‑la̱ xíkjín: “Jè jèe̱ xi tjoé kjo̱tjò‑la̱ i̱'nde, si̱k'eén, tsa̱ján ko̱ma i̱'nde.” ");
INSERT INTO maaNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kitsobà'ñó, kisìk'en, i̱kjoàn kisìkatje̱n ján i̱jto̱n nangui ñánda títje̱ toò uva. ");
INSERT INTO maaNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Jñò, ¿kó bixón? K'e̱ nga kjoi̱í nei‑la̱ nangui, ¿mé xi si̱ìko̱ jñà xi̱ta̱ koi? Si̱ìk'en‑né; kj'ei̱í xi̱ta̱á si̱ìnga̱tsja jè nangui ñánda tjín toò uva. ");
INSERT INTO maaNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿A kj'eè bìxke̱jñoò Xo̱jo̱n‑la̱ Nainá? Tsò‑né: Jè nda̱jo̱ xi tsachrjekàngui chji̱ne̱chrjó nga sa̱ ítjòn, jè‑né xi komà nda̱jo̱ tàts'en chrjó‑la̱ ni'ya; ");
INSERT INTO maaNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","K'oa̱á s'ín kis'iìn Nainá. Jñá, tà maxkón‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì, ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá ko̱ xi̱ta̱ jchínga mejèn kitsobà'ñó Jesús nga kiskaàya‑la̱ jè kjoa̱ xi mangásòn xi tsibéno̱jmí nga kondra̱ ts'e̱‑né, ta̱nga jñà kitsakjòn‑la̱ xi̱ta̱ na̱xa̱ndá; kisìkíjna, i̱kjoàn kiì‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kisìkasén i'nga‑la̱ Jesús xi̱ta̱ Fariseo ko̱ xi̱ta̱ ts'e̱ Herodes nga mejèn‑la̱ ótsji'nde‑la̱ kós'ín si̱ìko̱ nga ko̱hòngui. ");
INSERT INTO maaNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Xi̱ta̱ koi, kií kitsò‑la̱: ―Maestro, 'ya‑náje̱n nga 'én kixi̱í xi nokjoì; mìkiì 'nì kinda̱ koni tsò‑lè xi̱ta̱; ko̱ mìtsà jè chìtsejèn‑jnoi kó kjoàn xi̱ta̱; k'oa̱á s'ín okoòyi ndi̱yá‑la̱ Nainá koni s'ín tjín xi kjoa̱ kixi̱. ¿A ndaà tjín nga kíchjítjì‑je̱n tsojmì i̱t'aà ts'e̱ xi̱ta̱xá ítjòn ts'e̱ Roma, o xi majìn‑né? ¿A kíchjí‑náje̱n a xi mìkiì kíchjí‑je̱n? ");
INSERT INTO maaNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús jye beè nga jò tjín ini̱ma̱‑la̱; kitsò‑la̱: ―¿Mé‑ne nga chona̱cha̱n‑ná? Nchrohóko̱ jngoò‑ná to̱n nga skoeè kó kji. ");
INSERT INTO maaNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","K'e̱é kiìko̱ jngoò‑la̱ to̱n. Jesús kitsò‑la̱: ―¿Yá ts'e̱ i̱sén jè ko̱ jè 'ín xi tjít'aà? Kitsò‑la̱: ―Ts'e̱é César, xi̱ta̱xá ítjòn ts'e̱ Roma. ");
INSERT INTO maaNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","K'e̱é kitsò Jesús: ―Tjiì‑là César xi ts'e̱ César koa̱ tjiì‑là Nainá xi ts'e̱ Nainá. Tà k'oa̱á ko̱ma‑la̱ nga kiì'nchré koni kitsò Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jñà xi̱ta̱ Saduceo ijchòkon Jesús. Jñà xi̱ta̱ koi mìkiì mokjeiín‑la̱ nga faáya‑la̱ xi jye k'en. Kiskònangui‑la̱, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, jè Moisés, k'oa̱á s'ín kiskiì: Tsà jngoò xi̱ta̱ xi ki̱yá 'ndse̱, tsà tsjìn‑la̱ i̱xti k'e̱ nga ki̱yá, jè chjo̱ón‑la̱, ti̱jè‑ne 'ndse̱ ki̱xan‑ko̱ ìjngoò k'a‑ne mé‑ne nga s'e̱‑la̱ i̱xti xi tje̱ ts'e̱ 'ndse̱. ");
INSERT INTO maaNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kis'e xó jngoò k'a xi̱ta̱ xi itoò komà 'ndse̱. Jè xi síjna ítjòn, kis'e xó‑la̱ chjo̱ón; ta̱nga k'e̱ nga k'en, mìkiì kis'e‑la̱ i̱xti. ");
INSERT INTO maaNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jè xi ma jò‑ne chixàn‑ko̱ chjo̱ón ka'àn‑la̱ 'ndse̱. Ti̱koa̱á jè k'en. Mìkiì kis'e‑la̱ i̱xti. K'oa̱á ti̱ komà jè xi ma jàn‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ngásòn komà nga itoò. Ni̱jngoò xi kis'e‑la̱ i̱xti. Nga jye i̱t'aà‑ne k'en jè chjo̱ón. ");
INSERT INTO maaNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","K'e̱ nga tsà kjoa̱áya‑la̱ mik'en, nga itoò 'ndse̱, ¿yá‑né xi chjo̱ón‑la̱ ko̱ma? Nga jñà tsibìtsa̱jnako̱ nga itoò 'ndse̱. ");
INSERT INTO maaNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kisìkátji‑ne 'én Jesús, kitsò‑la̱: ―Jñò, koií maskáya‑nò nga mìkiì 'yaà kó s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá ko̱ nga'ñó xi tjín‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","K'e̱ nga kjoa̱áya‑la̱ mik'en, íchjín, íchjá mì ti̱ kiì ki̱xan‑ne. K'oa̱á s'ín s'e̱ koni jñà àkja̱le̱ xi títsa̱jna ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Jè kjoa̱ ts'e̱ mik'en nga kjoa̱áya‑la̱, ¿a kj'eè bìxke̱jñoò xo̱jo̱n‑la̱ Moisés ya̱ ñánda tíchja̱ ts'e̱ yá na'yá xi títì? Nainá kitsò‑la̱ Moisés: “'A̱n‑ná xi Nainá tsò‑na Abraham, Isaac, ko̱ Jacob.” ");
INSERT INTO maaNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡Jñà xi jye k'en, mìtsà Nainá tsò‑la̱ xi Nainá; tà jñà xi títsa̱jnakon xi Nainá tsò‑la̱! Jñò, 'ñó maskáya‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jngoò xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés kiì'nchré‑la̱ Jesús nga ndaà kiìchja̱; k'e̱ nga nchijoókjoò ijchò kasìt'aà chrañà‑la̱, i̱kjoàn kiskònangui‑la̱, kitsò‑la̱: ―¿Ñá‑la̱á kjo̱tíxoma‑la̱ Nainá xi tíjna ítjòn? ");
INSERT INTO maaNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kiìchja̱ Jesús, kitsò‑la̱: ―Jè kjo̱tíxoma xi tíjna ítjòn tsò‑né: “Ti̱ná'yaà xi̱ta̱ Israel, jè Nainá xi Na̱'èn‑ná, ta jè ta jngoò‑né xi otíxoma‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ti̱tsjachi Na̱'èn‑ná xi Nainá 'mì‑la̱, nga ko̱ ini̱ma̱‑lè ko̱ yijo‑lè ko̱ kjo̱hítsjeèn‑lè ko̱ nga'ñó‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jè xi ma‑ne jò: “Ti̱tsjachi xi̱ta̱ xingui̱i koni tsà ti̱ yijo tsi̱ji‑ne.” Mì ti̱ tsjìn‑ne kjo̱tíxoma xi ìsa̱ xkón tjín. ");
INSERT INTO maaNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jè xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá kitsò: ―Ndaà tjín, Maestro. O̱kixi̱‑né koni s'ín nokjoì. Jngoò ma‑ne Nainá ko̱ mì ti̱ yá tjín‑ne xi kj'ei̱í. ");
INSERT INTO maaNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ìsa̱ chjí‑la̱ nga ko̱ ini̱ma̱‑ná jcha̱xkoán Nainá, ko̱ kjo̱hítsjeèn‑ná ko̱ nga'ñó‑ná ko̱ nga jcha̱xkoán xinguia̱á koni tsà yijo‑ná. Ìsa̱á chjí‑la̱ koni ngats'iì cho̱ xi tìsòn ími̱xa̱ tsjeè‑la̱ Nainá, kjo̱tjò xi tsjá jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús k'e̱ nga kijtseè nga ndaà kiìchja̱ jè xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá, kitsò‑la̱: ―Mìtsà kjiìn ti̱jni i̱t'aà ts'e̱ kjo̱ndaà xi tjín‑la̱ jñà xi̱ta̱ xi Nainá otíxoma‑la̱. Mì ti̱ yá xi kjò'ñó‑ne ikon nga kiskònangui‑ìsa̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús k'e̱ nga tíhokóya ya̱ ndi̱tsin i̱ngo̱ ítjòn, kiskònangui‑la̱, kitsò‑la̱: ―¿Mé‑ne ko̱tsò‑ne jñà xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés nga jè xi Cristo, xi̱ta̱ xi xó si̱ìkasén‑ne Nainá, nga ya̱á kji̱nchrobàt'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David? ");
INSERT INTO maaNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ti̱jè‑ne David k'e̱ nga kiìchja̱ nga ko̱ nga'ñó‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá, kitsò‑né: Jè Nainá kitsò‑la̱ jè xi Nei‑na̱: “Ti̱jnat'aà‑ná i̱ kixi̱‑na̱ skanda k'e̱ nga sìkítsa̱jnanguia ndso̱koiì jñà xi kondra̱‑lè nga 'a̱n jye kisìkijne‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Jè David, tsà Nainá kitsò‑la̱ Cristo, xi̱ta̱ xi xó si̱ìkasén‑ne Nainá, ¿kó s'ín tjín‑ne nga tje̱‑la̱ ma‑ne David? Ngats'iì xi̱ta̱ xi kjìn ma‑ne, tsja ma‑la̱ nga 'nchré‑la̱ Jesús koni s'ín okóya. ");
INSERT INTO maaNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús k'oa̱á s'ín tsakóya‑la̱ xi̱ta̱. Kitsò‑la̱: ―Ti̱kinda̱a yijo‑nò i̱t'aà ts'e̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. Sasén‑la̱ nga nikje ndojò ókjá. Ti̱koa̱á sasén‑la̱ nga skoe̱xkón xi̱ta̱ xi kj'ei̱í, ndaà si̱ìxat'aà ya̱ ndi̱tsi̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ti̱koa̱á jñà ótsji íxi̱le̱ xi jncha ítjòn ya̱ ni'ya i̱ngo̱ sinagoga, ko̱ mejèn‑la̱ nga jñà kítsa̱t'aà ítjòn ími̱xa̱ k'e̱ nga kjèn xi̱ta̱ ñánda tjín s'eí. ");
INSERT INTO maaNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Koa̱ faá'an ni'ya‑la̱ xi tjín‑la̱ íchjín ka'àn xi jye k'en x'i̱n‑la̱. K'e̱ nga chja̱t'aà‑la̱ Nainá 'ñó nda̱jo̱ fìko̱ o̱chikon nga mejèn‑la̱ nga bìtsa̱jna'ma nga mì jcha̱‑la̱ mé kjoa̱ xi s'ín. Jñà xi̱ta̱ koi ìsa̱á tse kjo̱'in s'e̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús tsibìjna ya̱ kixi̱‑la̱ ñánda tíjna kaxa̱ xi sinchá to̱n kjo̱tjò‑la̱ Nainá. Tíkotsejèn‑la̱ xi̱ta̱ na̱xa̱ndá nga bítsa̱jna to̱n kjo̱tjò‑la̱ Nainá. Kjìn xi̱ta̱ nchi̱ná xi tse to̱n bítsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ijchò jngoò chjo̱ón ka'àn xi 'ñó i̱ma̱. Jò ndí to̱n jtobá tsibíjna xi chiba chjí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús kiìchja̱‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱, kitsò‑la̱: ―K'oa̱á xan‑nò xi nguì o̱kixi̱, jè chjo̱ón ka'àn xi 'ñó i̱ma̱, jè xi ìsa̱ tse to̱n kòbíjna mì k'oa̱á‑ne koni jñà xi̱ta̱ xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tà jè tsjá xi ningui‑la̱ ta̱nga jè ndí chjo̱ón i̱ma̱, na̱s'ín ni̱mé tjín‑la̱, jngoò k'a kàtsjá yije ngats'iì ndí to̱n xi tíjna‑la̱ xi tísíjchá‑ne yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","K'e̱ nga itjo‑ne ndi̱tsin i̱ngo̱ ítjòn, Jesús, jngoò xi̱ta̱ xi kota'yàt'aà‑la̱ kitsò‑la̱: ―Maestro, chítsejèn‑la̱ mé tà ndaà kjoàn ni'ya ko̱ nda̱jo̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kitsò Jesús: ―Chítsejèn‑là ngats'iì ni'ya koi xi iì kjoàn. Ni̱ì ti̱ jngoò nda̱jo̱ si̱yijòsòn‑la̱ xíkjín. Ki̱xo̱ña yije‑né kóho̱tjín. ");
INSERT INTO maaNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesús, k'e̱ nga tíjna ya̱ nindoò Yá Olivo ya̱ kixi̱‑la̱ I̱ngo̱ Ítjòn ts'e̱ Jerusalén, jè Pedro, Jacobo, Juan ko̱ Andrés, ijchò kinchat'aà‑la̱ Jesús, kiskònanguit'aàxìn‑la̱ kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Koa̱tìn‑náje̱n, ¿mé na̱chrjein‑ne nga o̱ko̱ma kjoa̱ koi? ¿Mé seña xi s'e̱ k'e̱ nga jye mejèn ki̱tasòn yije kjoa̱ koi? ");
INSERT INTO maaNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kiìchja̱ Jesús, kitsò‑la̱: ―Ti̱kinda̱a yijo‑nò nga mì yá xi̱ta̱ xi skóna̱cha̱n‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kjìn xi̱ta̱ kjoi̱í xi 'ín ts'a̱n si̱ìkjeén; ki̱tso̱: “'A̱n‑ná xi Cristo, nga 'a̱án kisìkasén‑na Nainá.” Ko̱ kjìn xi̱ta̱ skóna̱cha̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Jñò, k'e̱ nga ki̱ná'ya kjoa̱ ts'e̱ kjo̱jchán nga xki̱ xi ján i̱'nde tjín, kì tsakjoòn‑jèn. Xó k'oa̱á ko̱ma‑ne, ta̱nga kj'eè tsà i̱sò'nde tífehet'aà. ");
INSERT INTO maaNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Na̱xa̱ndá ska̱àn‑kjoò xi kj'ei̱í na̱xa̱ndá. Koa̱ xi̱ta̱xá koi̱ìts'ia̱ nga ska̱àn‑kjoò ko̱ xi̱ta̱xá xi kj'ei̱í na̱xa̱ndá. Xki̱ xi ján k'oa̱ ch'ón. S'e̱ kjinchrá. S'e̱ kjoa̱siì. Jñà kjoa̱ koi, tà jè xi sa̱ tímats'ia̱ko̱ kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Ndaà ti̱kinda̱a yijo‑nò nga ya̱á ski̱nìt'aà‑nò nguixko̱n xi̱ta̱xá. Si̱ki'oón‑nó nga ska̱àn‑ko̱‑nò xi̱ta̱ ya̱ ni'ya i̱ngo̱ sinagoga. Kji̱ko̱‑nò nguixko̱n xi̱ta̱xá gobernador ko̱ xi̱ta̱xá ítjòn, tà koií kjoa̱‑la̱ i̱t'aà ts'a̱n. K'oa̱á s'ín ko̱ma ki̱nókjoa̱‑là 'én xi ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mochjeén‑nè nga ítjòn ko̱bísòn 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo nga tíjtsa i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","K'e̱ ki̱jchò nguixko̱n xi̱ta̱xá, kì makájno‑nò kós'ín ki̱nókjoa̱a. Kì nìkítsjeèn‑jèn. Nga ti̱k'e̱é‑ne, Nainá tsjá‑nò 'én xi ki̱nókjoa̱a. Nga mìtsà jñò xi ki̱nókjoa̱a; jè Ini̱ma̱ Tsjeè‑la̱ Nainá xi ki̱chja̱ ngajo‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ti̱jè‑ne 'ndse̱ si̱ìnga̱tsja 'ndse̱ xi̱ta̱ nga si̱ìk'en. Jè na̱'èn‑la̱ si̱ìnga̱tsja ki'ndí‑la̱ nga si̱ìk'en xi̱ta̱. Jñà i̱xti‑la̱ si̱ìnga̱tsja na̱'èn‑la̱ nga ki̱yá. ");
INSERT INTO maaNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ngats'iì xi̱ta̱ i̱sò'nde ko̱jtikeé‑nò xi kjoa̱ ts'a̱n; ta̱nga jè xi ki̱chìkjoa̱‑la̱ skanda k'e̱ nga kjoe̱het'aà‑ne kjoa̱, jè xi ki̱tjokàjiìn kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’K'e̱ nga jcha̱a nga 'ñó ch'o tíma ya̱ I̱'nde Tsjeè‑la̱ Nainá ñánda mìkiì ok'ìn‑la̱, koni s'ín kiskiì Daniel xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. (Kàtasijiìn‑la̱ jñà xi̱ta̱ xi bíxke̱ xo̱jo̱n jé.) K'e̱ nga o̱ko̱ma kjoa̱ koi, jñà xi̱ta̱ xi títsa̱jna Judea, kàtanga, kàtjì ñánda nindoò choòn. ");
INSERT INTO maaNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jè xi tíjnasò'nga ni'ya‑la̱, kì ti̱ kiì nchrobájen‑ne, kì ti̱ kiì fahas'en‑ne ni'ya‑la̱ tsà mé xi mejèn‑la̱ nga skoé. ");
INSERT INTO maaNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jè xi tísíxájiìn nangui‑la̱ kì ti̱ kì nchrobá‑ne nga nchrohókjá nikje‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡I̱ma̱ xó‑ne jñà íchjín xi ki'ndí 'ya ko̱ xi i̱xti xó nchisíkaki jñà na̱chrjein koi! ");
INSERT INTO maaNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ti̱jét'aà‑là Nainá nga mì k'e̱é o̱ko̱ma k'e̱ nga na̱chrjein‑la̱ cho̱n 'nchán. ");
INSERT INTO maaNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","K'e̱ nga jè na̱chrjein nga o̱ko̱ma, 'ñó tse kjo̱'in s'e̱, kj'eè ñá o̱ma skanda tje̱n‑ne tsibíndaà i̱sò'nde Nainá koa̱ mì ti̱ kiì o̱ko̱ma‑ne nga ko̱ma i̱skan. ");
INSERT INTO maaNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tsà mì k'oa̱á ki̱tso̱ Nainá nga ìsa̱ ko̱chiba na̱chrjein, ni̱jngoò xi̱ta̱ ki̱tjokàjiìn kjo̱'in. Ta̱nga koií kjoa̱‑la̱ jñà xi̱ta̱ xi xó jaàjiìn‑ne Nainá, ko̱chibaya na̱chrjein. ");
INSERT INTO maaNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’K'e̱ nga tsà yá xi ki̱tso̱‑nò: “Chítsejèn‑là, i̱í tíjna Cristo xi̱ta̱ xi xó kisìkasén‑ne Nainá”, o tsà ki̱tso̱‑nò: “Chítsejèn‑là, ján tíjna ján”, kì kiì mokjeiín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kjoi̱í xi̱ta̱ ndiso xi Cristo ki̱tso̱‑la̱ yijo‑la̱, ti̱koa̱á kjoi̱í xi̱ta̱ xi koa̱ ti ki̱tso̱ nga jñà xi chja̱ ngajo‑la̱ Nainá. K'oa̱á ti̱s'ín ko̱kò seña ko̱ kjo̱xkón xi ndaà tjín nga skóna̱cha̱n. Skanda jñà xi̱ta̱ xi jye jaàjiìn Nainá mejèn skóna̱cha̱n‑la̱ tsà ko̱kjeiín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ti̱kinda̱a yijo‑nò. Nga jyeé tìbeno̱jmíya yije‑nò ngats'iì kjoa̱ xi ko̱ma i̱skan. ");
INSERT INTO maaNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’K'e̱ nga ko̱ma i̱skan nga jye ko̱to na̱chrjein ts'e̱ kjo̱'in, jè ts'oí ko̱jñò‑né, mì ti̱ kiì ko̱tsjè‑ne ndobá‑la̱; ti̱koa̱á jè sá mì ti̱ kiì ko̱hiseèn‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ni'ño xi tjín ngajmiì, ki̱xo̱ngui‑né. Jñà nga'ñó xi tjín ngajmiì ki̱ti̱ya yijeé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","I̱kjoàn skoe̱‑na xi̱ta̱ xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ nga kji̱nchrobàjñaà i̱jiìn ifi; tseé nga'ñó ko̱ kjoa̱jeya kjoi̱ikoa̱a. ");
INSERT INTO maaNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Siìkasén àkja̱le̱‑na̱ nga koi̱ìxkóya xi̱ta̱‑na̱ xi 'a̱n xó jaàjiìn‑na nga ñijòn chrja̱ngui̱‑la̱ nga tíjtsa i̱sò'nde ko̱ nga tíjtsa ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Chíta'yàko̱ò jè yá‑la̱ toò iko̱ mé xi okóya‑ná; k'e̱ nga ma kíndíya chrja‑la̱, i̱kjoàn bíjts'én xka̱‑la̱, tíjiìn‑nò nga jye nchrobá machrañà cho̱n ndobá. ");
INSERT INTO maaNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","K'oa̱á ti̱s'ín tjín, k'e̱ nga jcha̱a nga k'oa̱s'ín tíma kjoa̱ koi, kàtasijiìn‑nò nga 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, jyeé ni̱to̱n kjoia̱a, k'oa̱á ngaya‑la̱ koni tsà jye tìjna̱a chrañà xotjoa̱‑la̱ ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","O̱kixi̱í xi xan‑nò, ngats'iì kjoa̱ koi, k'oa̱s'ín ko̱ma k'e̱ nga ti̱kj'eè biyaà xi̱ta̱ xi tjín na̱chrjein i̱'ndei̱. ");
INSERT INTO maaNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Jè ngajmiì ko̱ i̱sò'nde kjoe̱het'aà‑né, ta̱nga jñà 'én‑na̱ mìkiì kjoe̱het'aà; ki̱tasòn‑né. ");
INSERT INTO maaNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ta̱nga k'e̱ nga o̱ko̱ma, mì yá xi tíjiìn‑la̱ mé na̱chrjein‑ne ko̱ mé hora‑ne; ni̱ jñà àkja̱le̱ xi títsa̱jna ngajmiì ko̱ ni̱ jè Ki'ndí‑la̱ Nainá tíjiìn‑la̱; ta̱jngoò Nainá xi Na̱'èn‑ná tíjiìn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’T'e̱en kinda̱ yijo‑nò, ti̱tsa̱jnakon, tìtsi'ba nga mìkiì tíjiìn‑nò kjé‑né nga o̱ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","K'oa̱á s'ín t'e̱en koni s'ín chi̱'nda‑la̱ xi̱ta̱ xi kjiìn i̱'nde tífì, jè xi̱ta̱ xi tífì sínga̱tsja ni'ya‑la̱ xi̱ta̱ chi̱'nda‑la̱. Tsjá‑la̱ xá nga ìjngoò ìjngoò, tsò‑la̱ jè xi síkinda̱ xotjoa̱ ni'ya: “Ti̱jni, ti̱jnakoin.” ");
INSERT INTO maaNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","K'oa̱á s'ín titsa̱jnakoòn ngats'ioò nga mìkiì 'yaà mé na̱chrjein kjoi̱í‑ne nei‑la̱ ni'ya. ¿A k'e̱é‑nè nga kjòhoxòn, o xi k'e̱é‑nè nga ki̱jchò osen ni̱tje̱n, o xi k'e̱é‑nè nga ski̱ndàya kóxtí, o xi k'e̱é‑né nga jye s'e̱ i̱sén? ");
INSERT INTO maaNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kì tsjayijòfè‑jèn tsà koi na̱chrjein‑la̱ tà ni̱to̱n j'iì‑ne nei‑la̱ ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Koni s'ín xan‑nò jñò, k'oa̱á xan yije‑la̱ kóho̱tjín xi̱ta̱: “Titsa̱jnakoòn.” ");
INSERT INTO maaNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tà jò na̱chrjein chija‑la̱ nga ki̱tjo s'eí Paxko̱ ts'e̱ xi̱ta̱ judío k'e̱ nga kjèn i̱nchra̱jín xi tsjìn‑la̱ na̱'yo̱ san. Jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés tsohótsji'nde‑la̱ kós'ín si̱ìko̱ nga skóna̱cha̱n‑la̱ nga tsobà'ñó Jesús, i̱kjoàn si̱ìk'en. ");
INSERT INTO maaNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tjín i'nga xi̱ta̱ xi kitsò: ―Mì na̱chrjein‑la̱ s'eí si̱k'eén nga mì ko̱ts'e̱n jñà xi̱ta̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús, k'e̱ nga tíjna ján na̱xa̱ndá Betania, ya̱ ni'ya‑la̱ Simón, jngoò xi̱ta̱ xi tsindojno chrjoa̱ yijo‑la̱ nga sa̱ ítjòn, k'e̱ nga tíjnat'aà ími̱xa̱, ijchò jngoò chjo̱ón xi 'ya jngoò nda̱jo̱ chi̱tsín xi tjíya‑la̱ xkiì jne̱ ts'e̱ nardo, xi 'ñó chjí‑la̱. Kiskíx'a̱ nda̱jo̱ chi̱tsín, i̱kjoàn tsibíxteèn‑jno sko̱ Jesús jè xkiì jne̱. ");
INSERT INTO maaNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tjín i'nga xi̱ta̱ xi ya̱ títsa̱jna, kòjti‑la̱, kitsò‑la̱ xíkjín: ―¿Mé‑ne kasíkits'ón‑ne jè xkiì jne̱? ");
INSERT INTO maaNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tsà kàsatíjna, tsatoó‑la̱ jàn sìndo̱ to̱n denario chjí‑la̱ koa̱ jè to̱n‑la̱ ko̱ma ko̱chját'aà‑la̱ xi̱ta̱ i̱ma̱. Kiìchja̱jno‑la̱ jè chjo̱ón xi o̱kis'iìn. ");
INSERT INTO maaNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ta̱nga kitsò Jesús: ―Kì k'oa̱á 'mì‑là. ¿Mé‑ne nìjti‑là? Koni s'ín kàs'ín‑ko̱‑na, ndaà kàs'ín. ");
INSERT INTO maaNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Jñà xi̱ta̱ i̱ma̱ kítsa̱jnako̱ kjit'aà‑nò, ko̱ maá si̱chját'aà‑là k'e̱ nga mejèn‑nò. Ta̱nga 'a̱n, mì i̱ tìjna̱ko̱ kjit'aà‑nò. ");
INSERT INTO maaNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jè chjo̱ón jè, k'oa̱á s'ín kàs'ín koni kji ma xi kàs'ín. Kàsíkaàjno ítjòn xkiì jne̱ yijo‑na̱ xi ts'e̱ nga si̱ìjñaà. ");
INSERT INTO maaNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","O̱kixi̱í xi xan‑nò, ni̱ta̱ ñánda‑ne nga tíjtsa i̱sò'nde nga ko̱bísòn 'én ndaà‑la̱ Nainá, ti̱koa̱á ko̱bísòn‑né koni s'ín kasìko̱‑na mé‑ne nga si̱ìkítsjeèn‑ne xi̱ta̱ i̱t'aà ts'e̱ chjo̱ón jè. ");
INSERT INTO maaNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jè Judas Iscariote xi ya̱ itjojiìn‑ne ts'e̱ xi̱ta̱ xi tejò ma‑ne xi tsajmeiìko̱ Jesús, kiìkon jñà xi̱ta̱ sko̱‑la̱ no̱'miì nga si̱ìnga̱tsja Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì, k'e̱ nga kiì'nchré, kjòtsja‑la̱, kitsjaà‑la̱ tso'ba nga to̱n tsjá‑la̱. Jè Judas tsohótsji'nde‑la̱ kós'ín si̱ìnga̱tsja Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jè na̱chrjein ts'e̱ s'eí xi mats'ia̱ ítjòn‑ne k'e̱ nga kjèn i̱nchra̱jín xi tsjìn‑la̱ na̱'yo̱ san jñà xi̱ta̱ judío, k'e̱ nga sík'en orrè xi ts'e̱ s'eí Paxko̱, jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kiskònangui‑la̱; kitsò‑la̱: ―¿Ñánda mejèn‑lè onguíkindaà‑je̱n xi ki̱chiaá ts'e̱ s'eí Paxko̱? ");
INSERT INTO maaNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesús kisìkasén jò xi̱ta̱ xi kota'yàt'aà‑la̱ ján Jerusalén, kitsò‑la̱: ―Tanguió ján i̱jiìn na̱xa̱ndá, ya̱á ska̱jñoò jngoò xi̱ta̱ xi 'yajen jngoò nisa nandá; tanguítji̱ngui‑là. ");
INSERT INTO maaNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ya̱ ñánda kjoa̱has'en, koa̱tìn‑là nei‑la̱ ni'ya: “K'oa̱á tsò Maestro: ¿Ñánda tíjna jè cuarto ñánda kókje̱n‑koa̱a xi̱ta̱ xi kota'yàt'aà‑na jè s'eí Paxko̱?” ");
INSERT INTO maaNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ya̱á ko̱kò jngoò‑nò cuarto xi je kji xi tíjna i̱sò'nga ni'ya. Jyeé tjíndaà tsojmì xi ko̱chjeén. Ya̱ tìndaà xi ki̱chiaá. ");
INSERT INTO maaNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kiì jñà xi̱ta̱ xi kota'yàt'aà‑la̱ ján i̱jiìn na̱xa̱ndá. K'oa̱á s'ín kisakò‑la̱ koni s'ín kitsò‑la̱ Jesús, ya̱á tsibíndaà tsojmì xi ko̱kje̱n kjoa̱ ts'e̱ s'eí Paxko̱. ");
INSERT INTO maaNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","K'e̱ nga jye kòjñò, Jesús, ijchòko̱ xi̱ta̱‑la̱ xi tejò ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","K'e̱ nga títsa̱jnat'aà ími̱xa̱ nga nchikjèn, Jesús kitsò‑la̱: ―O̱kixi̱í xi xan‑nò, jñò, i̱í tíjnajiìn jngoò‑nò xi si̱ìnga̱tsja‑na̱ i̱t'aà ts'e̱ xi̱ta̱ kondra̱‑na̱, jngoò xi 'a̱n tíkjèn‑ko̱‑na. ");
INSERT INTO maaNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús ta kjòba‑la̱ k'e̱ nga o̱kitsò. K'e̱é jngó jngó kiskònangui‑la̱, kitsò‑la̱: ―¿A 'a̱n‑ná? ");
INSERT INTO maaNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús kitsò: ―Jngoò xi ki̱tjokàjiìn ts'e̱ xi̱ta̱‑na̱ xi tejò ma‑ne jè xi ti̱jè‑ne chro̱ba̱ ts'a̱n tísíka'nchi̱‑ne i̱nchra̱jín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, k'oa̱á s'ín ko̱mat'ian koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá. ¡Ta̱nga i̱ma̱ xó‑ne jè xi̱ta̱ xi si̱ìnga̱tsja‑na! Ìsa̱á‑là ndaà komà tsà mìkiì kits'iìn xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","K'e̱ nga nchikjèn, Jesús kiskoé i̱nchra̱jín, kiìchja̱t'aà‑la̱ Nainá nga kisìchikon‑t'in, kisìxkoa̱ya i̱kjoàn kitsjaà‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱, kitsò‑la̱: ―Chjoé. Yijo‑na̱ né. ");
INSERT INTO maaNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","I̱kjoàn kiskoé jngoò chi̱tsín, kitsjaà‑la̱ kjo̱ndaà Nainá; k'e̱é kitsjaà‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱, ngats'iì xi̱ta̱ kits'iì vino xi tjíya chi̱tsín. ");
INSERT INTO maaNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kitsò‑la̱: ―Jè‑né xi jní‑na̱ xi si̱ìkixi̱ya jè kjoa̱ xi̱tse̱ xi bìndaàjiìn‑ko̱‑nò. Jè jní‑na̱ xi̱ìxteèn xi kjo̱ndaà ts'e̱ nga kjìn xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","O̱kixi̱í xi xan‑nò, mì ti̱ kiì ski̱‑na vino skanda jè na̱chrjein k'e̱ nga skia̱a vino xi̱tse̱, ján ñánda tíhotíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jesús ko̱ xi̱ta̱‑la̱, k'e̱ nga jye kiseè jngoò‑la̱ sò Nainá ts'e̱ Salmo, i̱kjoàn kiì ján nindoò Yá Olivo. ");
INSERT INTO maaNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Ngats'ioò jñò, ki̱jneí takòn‑ná jè ni̱tje̱n jè, nga k'oa̱á s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá, nga tsò: “Ki̱yá jè paxtò koa̱ jñà orrè tsjohoya‑né.” ");
INSERT INTO maaNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ta̱nga ko̱ma i̱skan, k'e̱ nga kjoa̱áya‑na, kjín ítjòn‑nò ján nangui Galilea. ");
INSERT INTO maaNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kitsò Pedro: ―Na̱s'ín ngats'iì xi̱ta̱‑lè xi i'nga tsjeiìn takòn‑lè, 'a̱n, mìkiì tsjeiìn‑takòn‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús kitsò‑la̱: ―O̱kixi̱í xi xan‑lè; ni̱tje̱n jé, k'e̱ nga ti̱kj'eè kjindáya jò k'a kóxtí, ngaji̱, jàn k'a tsjá'mat'in‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Jè Pedro ìsa̱ 'ñó kiìchja̱; kitsò: ―Na̱s'ín ya̱ ki̱yáko̱‑lè, mìkiì kójna̱'mat'in‑lè. Ngásòn kitsò yije xi̱ta̱ xi kota'yàt'aà‑la̱ xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kiì ján i̱'nde ñánda 'mì Getsemaní; Jesús kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Ti̱tsa̱jna i̱jndé; 'a̱n, Nainá kò‑là kichjàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jesús kiìko̱ Pedro, Jacobo, ko̱ Juan. I̱kjoàn tsibíts'ia̱ Jesús nga ba ko̱ma‑la̱. 'Ñó kisìkájno. ");
INSERT INTO maaNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","K'e̱é kitsò Jesús: ―Tsí baá ma‑la̱ ini̱ma̱‑na̱ koni tsà mejèn ki̱yá. Ti̱tsa̱jna i̱jndé, titsa̱jnakoòn. ");
INSERT INTO maaNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesús kiìkjá chiba‑ìsa. I̱kjoàn tsohojna skanda i̱t'aà nangui koa̱ kisìjét'aà‑la̱ Nainá tsà ko̱ma, kjoa̱áxìn‑la̱ kjo̱'in jè. ");
INSERT INTO maaNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","K'e̱ nga tíchja̱t'aà‑la̱ Nainá, kitsò‑la̱: ―Na̱'èn xi Na̱'èn‑na̱ xan‑lè, ma yijeé‑lè ni̱ta̱ mé kjoa̱‑ne i̱t'aà tsi̱ji. Chja̱àxìn‑ná kjoa̱ ts'e̱ kjo̱'in jè, ta̱nga mìtsà jè 'én ts'a̱n ki̱tasòn, jè kàtitasòn 'én tsi̱ji. ");
INSERT INTO maaNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","I̱kjoàn j'iì ìjngoò k'a‑ne ya̱ ñánda títsa̱jna xi̱ta̱‑la̱, ta̱nga jñà xi̱ta̱‑la̱, kjiyijòfè‑né. Jesús kitsò‑la̱ Pedro: ―Simón, ¿a titsa̱jnafè‑né? ¿A mì kachíkjoa̱‑lè tsà tà jngoò hora kòbìjnakoin? ");
INSERT INTO maaNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Titsa̱jnakoòn, ti̱jét'aà‑là Nainá mé‑ne nga mì si̱ìkijne‑nò kjoa̱ ts'e̱ jé. Xi o̱kixi̱, jè ini̱ma̱‑nò tíjnandaà‑né ta̱nga jè yijo‑nò, indaá tjín, tsjìn‑la̱ nga'ñó. ");
INSERT INTO maaNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesús kiì kítsi'ba ìjngoò k'a. Tákó k'oa̱á ti̱ kitsò‑ne koni kitsò nga sa̱ ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","K'e̱ nga j'iì ìjngoò k'a‑ne, jñà xi̱ta̱ xi kota'yàt'aà‑la̱, tákó kjiyijòfè‑né nga 'ñó nijñá‑la̱. Mìkiì beè kó ki̱tso̱‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ko̱ma jàn k'a nga j'iì Jesús. Kitsò‑la̱: ―¿A tákó titsa̱nìkjáya‑nò ko̱ titsa̱fè‑nò? Kàtje kjoa̱. Jyeé ijchò hora‑la̱, 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, ya̱á ko̱nga̱tsja jñà xi̱ta̱ jé. ");
INSERT INTO maaNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ti̱sítje̱en, chítsejèn‑là, tíkjiaán, jye nchrobá chrañà jè xi si̱ìnga̱tsja‑na. ");
INSERT INTO maaNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tákó ti̱k'e̱é tíchja̱‑ìsa Jesús nga ijchò Judas, xi ya̱ itjojiìn‑ne ts'e̱ xi̱ta̱‑la̱ Jesús xi tejò ma‑ne. Kjìn xi̱ta̱ tji̱ko̱ xi 'ya ki̱cha̱ ndojò ko̱ yá. Xi̱ta̱ koi, jñà kisìkasén xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés ko̱ xi̱ta̱ jchínga‑la̱ xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, jè xi tsatíjna Jesús, ítjòn tsibíhichi̱ya‑la̱ kós'ín ko̱kò‑la̱ Jesús. Kitsò‑la̱: ―Jè xi skíne̱'a, jè‑né xi ti̱ndo̱ba̱'ñó; ndaà ti̱kinda̱a k'e̱ nga onguíko̱o. ");
INSERT INTO maaNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","K'e̱ nga ijchò Judas, kiì ndi̱yá‑né ñánda tíjna Jesús, kitsò‑la̱: ―Maestro. I̱kjoàn kiskine'a. ");
INSERT INTO maaNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jñà xi̱ta̱ xi tji̱ko̱, ni̱to̱ón kitsobà'ñó Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ya̱á tíjna jngoò xi̱ta̱ xi tsachrje ki̱cha̱ ndojò‑la̱. Tsajá‑la̱ jè xi̱ta̱ chi̱'nda‑la̱ no̱'miì ítjòn, tsatet'aà jngoò líká‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús kiìchja̱, kitsò‑la̱ jñà xi̱ta̱: ―¿Mé‑ne ko̱s'ín ko̱f'i̱ ndobà'ñó‑ná nga ko̱ ki̱cha̱ ko̱ yá kich'à koni tsà jngoò xi̱ta̱ chijé? ");
INSERT INTO maaNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Na̱chrjein nchijòn tìjna̱ko̱‑nò ján i̱ngo̱ ítjòn nga okoòya‑nò koa̱ mìkiì kindobà'ñó‑ná. Koií k'oa̱á s'ín tíma‑ne nga ki̱tasòn 'én xi tjít'aà Xo̱jo̱n‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ngats'iì xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús tsanga‑né, ya̱á kitsjeiìn‑takòn. ");
INSERT INTO maaNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jngoò chíti tji̱ngui‑la̱ xi tíjnajté jngoò nikje sábana. Jñà xi̱ta̱ kitsobà'ñó, ");
INSERT INTO maaNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ta̱nga jè chíti kitsjeiìn nikje sábana‑la̱; i̱kjoàn k'oa̱s'ín tsanga laká. ");
INSERT INTO maaNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesús kiìko̱ ñánda tíjna no̱'miì ítjòn. Ya̱á chixoña kóho̱tjín xi̱ta̱ sko̱‑la̱ no̱'miì, jñà xi̱ta̱ jchínga, ko̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. ");
INSERT INTO maaNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jè Pedro, tà kjiìn tà kjiìn tsajmeètji̱ngui‑la̱ skanda k'e̱ nga ijchò ya̱ ndi̱tsin ni'ya‑la̱ no̱'miì ítjòn. Ya̱á tsibíjnat'aà‑la̱ ñánda títsa̱jna xi̱ta̱ chi̱'nda xi síkinda̱ i̱ngo̱ nga títsa̱jna'ngui. ");
INSERT INTO maaNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ ngats'iì xi̱ta̱xá xi ts'e̱ xi̱ta̱ judío tsohótsji'nde‑la̱ nga tsját'in 'én xi kondra̱ ts'e̱ Jesús mé‑ne nga ko̱ma si̱ìk'en‑ne ta̱nga nìmé 'én kisakò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kjìn ma xi̱ta̱ xi tsját'in 'én ndiso xi kondra̱ ts'e̱ Jesús ta̱nga kj'ei̱í tsò nga jngoò ìjngoò; mìkiì mangásòn 'én xi tsját'in. ");
INSERT INTO maaNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Chincha kixi̱ i'nga xi̱ta̱ xi tsibéno̱jmí 'én ndiso. Kitsò: ");
INSERT INTO maaNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Ngaje̱n, kina'yà‑la̱je̱n nga tsò: “'A̱n siìki̱xo̱ña i̱ngo̱ ítjòn xi tsja xi̱ta̱ kisindaà‑ne, ko̱ jàn na̱chrjein kìndaà ìjngoò‑na xi mìtsà tsja xi̱ta̱ sindaà‑ne.” ");
INSERT INTO maaNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ni̱ mìkiì kjòngásòn 'én‑la̱ na̱s'ín o̱kitsò. ");
INSERT INTO maaNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","K'e̱é tsasítje̱n jè no̱'miì ítjòn; tsasíjnajiìn osen‑la̱; kiskònangui‑la̱ Jesús, kitsò‑la̱: ―¿A nì mé 'én nokjoì, koni tsò 'én xi tsjá xi̱ta̱ koi xi kondra̱ tsi̱ji? ");
INSERT INTO maaNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ta̱nga jè Jesús jyò tsibìjna, ni̱mé 'én kiìchja̱. Jè no̱'miì ítjòn ìjngoò k'a kiskònangui‑la̱, kitsò‑la̱: ―¿A ji̱‑né xi Cristo, xi Ki'ndí‑la̱ Nainá xi 'ñó jeya tíjna? ");
INSERT INTO maaNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús kitsò: ―'A̱n‑ná, jñò jcha̱‑ná xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ nga kóti̱jnat'aà chrja kixi̱‑la̱ Nainá xi 'ñó tse nga'ñó tjín‑la̱, koa̱ kji̱nchrobàjñaà ifi ján ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jè no̱'miì ítjòn tsatijndajno yijo‑la̱ nikje‑la̱ xi íkjá nga 'ñó kòjti‑la̱. Kitsò: ―¿Mé s'e̱én‑ìsa̱‑ná xi̱ta̱ xi kj'ei̱í xi tsjá 'én? ");
INSERT INTO maaNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jñá, jye titsa̱na'yà koni s'ín chja̱jno‑la̱ Nainá. ¿Jñò, kó bixón? ¿Mé xi si̱koa̱á? Ngats'iì xi̱ta̱ kisìjngoò ikon nga tjín‑la̱ jé koa̱ ok'ín‑la̱ nga ki̱yá. ―Ok'ín‑la̱ nga si̱k'en. ");
INSERT INTO maaNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jñà xi̱ta̱ tsibíts'ia̱ nga tsibíchrájno koa̱ tsibíchjoà xko̱n, tsi'beé‑la̱, kitsò‑la̱: ―K'oa̱á si, ¿yá xi tí'beé‑lè? Jñà xi̱ta̱ xi síkinda̱ i̱ngo̱, kisìjts'iìn‑'a i̱sén‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jè Pedro ya̱á tíjna kangui ndi̱tsin ni'ya. Ijchò jngoò chjo̱ón xi chi̱'nda‑la̱ no̱'miì ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","K'e̱ nga kijtseè Pedro, nga tíjna'ngui, kiskoòtsejèn‑jno, kitsò‑la̱: ―Ti̱koa̱á ngaji̱, ya̱á tjaàkoi̱i Jesús xi Nazaret i̱'nde‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ta̱nga jè Pedro tsoho'mat'in‑né. Kitsò: ―Mìkiì bexkoan. Mìkiì be mé 'én xi tinokjoì. Pedro itjo ni'ya ján xotjoa̱‑la̱. K'e̱é kiskindàya jngoò kóxtí. ");
INSERT INTO maaNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jè chjo̱ón chi̱'nda‑la̱ no̱'miì ítjòn kijtseè ìjngoò k'a jè Pedro. Kitsò‑la̱ jñà xi̱ta̱ xi ya̱ títsa̱jna: ―Jè xi̱ta̱ jè, xi̱ta̱ ts'e̱é Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ta̱nga jè Pedro tsoho'mat'in ìjngoò k'a. Nga ko̱ma i̱skan, jñà xi̱ta̱ xi ya̱ títsa̱jna, ìjngoò k'a kitsò‑la̱ Pedro: ―Xi o̱kixi̱, ngaji̱, xi̱ta̱‑la̱ Jesús‑né nga Galilea i̱'nde‑lè, k'oa̱á tsò 'én‑lè xi nokjoì. ");
INSERT INTO maaNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ta̱nga ìsa̱á 'ñó kiìchja̱ Pedro kitsò: ―¡Beè Nainá, na̱s'ín ti̱k'eèn‑ná, mìkiì bexkoan jè xi̱ta̱ xi o̱'mì‑là! ");
INSERT INTO maaNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ti̱k'e̱‑ne nga o̱kitsò Pedro, jè xi ma‑ne jò k'a kiskindàya kóxtí. K'e̱é tsibítsjeèn‑la̱ Pedro koni kitsò‑la̱ Jesús: “K'e̱ ti̱kj'eè kjindáya jò k'a kóxtí, ngaji̱, jàn k'a tsjá'mat'in‑ná.” I̱kjoàn ndaà jchán kiskindàya. ");
INSERT INTO maaNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","K'e̱ nga kis'e i̱sén jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ jchínga ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés ko̱ ngats'iì xi̱ta̱xá ts'e̱ xi̱ta̱ judío tsajoóya‑ne. Tsibít'aà'ñó Jesús, kiìko̱, kisìnga̱tsja jè Pilato. ");
INSERT INTO maaNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jè Pilato kiskònangui‑la̱, kitsò‑la̱: ―¿A ji̱‑né xi xi̱ta̱xá ítjòn‑la̱ jñà xi̱ta̱ judío? Jesús kitsò: ―Ngaji̱í xi k'oa̱ si nga 'a̱n‑ná. ");
INSERT INTO maaNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ta̱nga jñà xi̱ta̱ sko̱‑la̱ no̱'miì, kjìn ska̱ya 'én tjín‑ne xi tsját'in nga óngui. ");
INSERT INTO maaNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato ìjngoò k'a kiskònangui‑la̱, kitsò‑la̱: ―¿A ni̱mé 'én nokjoì? Ti̱ná'yaà‑la̱, 'ñó kjìn ska̱ya kjoa̱ tsját'in‑lè nga óngui‑lè. ");
INSERT INTO maaNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús mìkiì kiìchja̱ na̱s'ín koa̱ tí'mì‑la̱. Pilato, tà k'oa̱á komà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nga xki̱ nó k'e̱ nga bitjo s'eí Paxko̱ jè Pilato síkíjnandei̱í jngoò xi̱ta̱ xi títsa̱'ya nda̱yá, jè xi síjé xi̱ta̱ na̱xa̱ndá nga kíjnandei̱í. ");
INSERT INTO maaNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jñà xi̱ta̱ xi títsa̱'ya nda̱yá nga kjoa̱siì tsohótsji ts'e̱ gobierno, ya̱ tíjna xi 'mì Barrabás xi xi̱ta̱ kisìk'en. ");
INSERT INTO maaNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jñà xi̱ta̱ na̱xa̱ndá kiìkáko̱ Pilato nga mejèn‑la̱ koa̱ s'ín síkitasòn koni ma nga xki̱ nó. ");
INSERT INTO maaNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kiìchja̱ Pilato, kitsò: ―¿A mejèn‑nò nga siìkíjnandei̱í‑nò xi xi̱ta̱xá ítjòn‑la̱ xi̱ta̱ judío? ");
INSERT INTO maaNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato jye tíjiìn‑la̱ nga tà kjoa̱xìtakòn‑né nga jñà xi̱ta̱ sko̱‑la̱ no̱'miì ya̱ ijchò sínga̱tsja Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì chinchá'a xi̱ta̱ na̱xa̱ndá nga ko̱s'ín kàtasíjé nga kàtìjnandei̱í‑ne Barrabás. ");
INSERT INTO maaNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato ìjngoò k'a kiskònangui‑la̱ xi̱ta̱ na̱xa̱ndá, kitsò‑la̱: ―¿Mé xi si̱koa̱á jè xi 'mì‑là xi̱ta̱xá ítjòn‑la̱ xi̱ta̱ judío? ");
INSERT INTO maaNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jñà xi̱ta̱, 'ñó kiìchja̱, kitsò: ―Ta̱sit'iì krò. ");
INSERT INTO maaNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","K'e̱é kitsò Pilato: ―¿Mé jé xi tsohótsji, mé‑ne ki̱yá‑ne? Jñà xi̱ta̱, ìsa̱á 'ñó kiìchja̱, kitsò: ―Ta̱sit'iì krò. ");
INSERT INTO maaNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato mejèn‑la̱ nga ndaà kíjnako̱ xi̱ta̱ na̱xa̱ndá. Kisìkíjnandei̱í Barrabás. K'e̱ nga jye kitsjaà o̱kixi̱ nga tsajá‑la̱ Jesús, i̱kjoàn kisìnga̱tsja nga si̱t'aà krò. ");
INSERT INTO maaNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jñà soldado kiìko̱ Jesús ján ni'ya osen. I̱kjoàn kiìchja̱ yije‑la̱ soldado xíkjín. ");
INSERT INTO maaNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kisìkákjá jngoò nikje xi inì jmà kji; tsibí'a sko̱ jngoò corona na'yá xi jñà xó tsibíndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","I̱kjoàn tsibíts'ia̱ nga kiskindàyat'in. Kitsò‑la̱: ―Viva xi̱ta̱xá ítjòn‑la̱ xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tsatjì yá xka̱jnchra̱ sko̱; i̱kjoàn tsibíchrájno koa̱ chincha-xkó'nchit'aà‑la̱ koni tsà nchibeèxkón. ");
INSERT INTO maaNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","K'e̱ nga jye kisìsobà‑la̱, jaàxìn‑la̱ nikje sko xi íkjá, i̱kjoàn kisìkákjá‑ne xi nikje ts'e̱. K'e̱é itjoko̱ nga ko̱sit'aà krò. ");
INSERT INTO maaNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jngoò xi̱ta̱ kisatiìkjoò xi 'mì Simón xi Cirene i̱'nde‑la̱ xi tínchrobá‑ne rancho̱‑la̱. Na̱'èn‑la̱á ma jè Alejandro ko̱ Rufo. Jñà soldado kjo̱'ñó kis'iìn‑la̱ nga kisìk'ajen krò‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kiìko̱ Jesús ján i̱'nde ñánda 'mì Gólgota, jè 'én xi tsòya‑ne i̱'nde sko̱ mik'en. ");
INSERT INTO maaNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kitsjaà‑la̱ vino xi tsjájiìn xich'a tsja xi 'mì mirra ta̱nga jè Jesús mìkiì kits'iì. ");
INSERT INTO maaNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","K'e̱é tsasìt'aà krò, i̱kjoàn jñà soldado kisìskáko̱ nikje‑la̱ Jesús nga kisìka'bí‑la̱ xíkjín yá ts'e̱ ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ijchò‑la̱ tsà xi ñijaàn nga ta̱jñòya nga kisasìt'aà krò Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jñà 'én xi tsohót'aà i̱sòn sko̱ krò, ya̱á tíchja̱ mé jé xi komà‑la̱ Jesús nga kinìk'en. Tsò‑né: “Xi̱ta̱xá Ítjòn‑la̱ xi̱ta̱ judío.” ");
INSERT INTO maaNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ti̱koa̱á chinchat'aà krò jò xi̱ta̱ chijé. Jngoò tsasíjnat'aà nga kixi̱‑la̱ Jesús ko̱ jngoò tsasíjnat'aà nga ngaskón‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","K'oa̱á s'ín kjòngásòn koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá nga tsò: “K'oa̱á ngaya‑la̱ koni jngoò xi̱ta̱ xi tse jé tjín‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jñà xi̱ta̱ xi ya̱ ja, síkatji sko̱ nga kiìchja̱jno‑la̱, kitsò‑la̱: ―Ji̱, k'oa̱á kisi nga si̱ixòñi i̱ngo̱ ítjòn‑la̱ Nainá ko̱ jàn na̱chrjein kíndaà ngajo‑ne, ");
INSERT INTO maaNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ti̱kíjnandei̱í yijo‑lè ko̱ chínáje̱n‑t'i yijo‑lè krò. ");
INSERT INTO maaNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","K'oa̱á ti̱s'ín kisìsobà‑la̱ jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. Kitsò‑la̱ xíkjín: ―Xi̱ta̱ jè, tsachrjekàjiìn kjo̱'in xi kj'ei̱í xi̱ta̱, ta̱nga jè xi yijo‑la̱, mìkiì ma ochrjekàjiìn kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kàtìtjojen‑t'aà krò jè xi Cristo, xi Xi̱ta̱xá Ítjòn‑la̱ na̱xa̱ndá Israel, mé‑ne nga jcha̱‑ná koa̱ ko̱kjeiín‑ná. Skanda jñà xi̱ta̱ xi ti̱koa̱ ya̱ kjit'aà krò, ti̱koa̱á tsatít'aà. ");
INSERT INTO maaNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","K'e̱ nga ijchò nchisen, kóho̱kji nga tíjtsa i̱sò'nde kòjñò skanda xi jàn nga nguixòn. ");
INSERT INTO maaNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ti̱jè‑ne hora Jesús 'ñó kiìchja̱ nga kitsò: ―Eloi, Eloi, ¿lama sabactani? ―'Én jè tsòya‑ne: Nainá, Nainá, ¿mé‑ne kàjneitakòn‑ná? ");
INSERT INTO maaNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tjín i'nga xi̱ta̱ xi ya̱ títsa̱jna xi kiì'nchré‑la̱, kitsò: ―Ti̱ná'yaà‑là, jè chja̱‑la̱ Elías. ");
INSERT INTO maaNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","K'e̱é tsangachikon jngoò xi kisìka'nchi̱ tsa̱nga̱ ko̱ vinagre, i̱kjoàn tsibísko̱‑la̱ ína̱xo̱, kitsjaà‑la̱ Jesús nga kàt'iì, kitsò: ―Chítsejèn‑là, ¿a kjoi̱í Elías nga skónáje̱n‑t'aà krò? ");
INSERT INTO maaNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ta̱nga Jesús ìsa̱á 'ñó kiskindàya; k'en. ");
INSERT INTO maaNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jè nikje velo xi tjo̱hóya jngoò osen i̱ngo̱ ítjòn kixajndà, jòya ko̱ma skanda i̱t'aà nangui. ");
INSERT INTO maaNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jè xi̱ta̱ sko̱‑la̱ soldado xi síjna ñánda kisit'aà krò Jesús k'e̱ nga kijtseè nga jye k'en Jesús, kitsò: ―Kixi̱í kjoa̱, xi̱ta̱ jèe̱, Ki'ndí‑la̱ Nainá‑né. ");
INSERT INTO maaNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ti̱koa̱ títsa̱jna i'nga íchjín xi kjiìn nchikotsejèn‑ne; jè María Magdalena, ko̱ chjo̱ón Salomé, ko̱ María xi nea̱‑la̱ ma José ko̱ Jacobo, jè xi ìsa̱ ma ki'ndí. ");
INSERT INTO maaNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jñà íchjín koi, k'e̱ nga tsibìjna Galilea Jesús, ya̱á chinchima‑tji̱ngui‑la̱ ko̱ ya̱á kisìchját'aà‑la̱. Kjìn ma íchjín xi ya̱ títsa̱jna xi ijchòko̱ ján Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","K'e̱ nga jye kjònguixòn nga jye bìtsa̱jnandaà‑la̱ na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José xi Arimatea i̱'nde‑la̱, jngoò xi̱ta̱ xi ti̱koa̱ 'nga xá tjín‑la̱ ts'e̱ xi̱ta̱xá‑la̱ xi̱ta̱ judío xi ti̱koa̱ tíkoña‑la̱ nga mejèn‑la̱ skoe̱ kó s'ín otíxoma Nainá, kitsjaà‑la̱ nga'ñó yijo‑la̱, jahas'en ya̱ ni'ya ñánda tíjna Pilato nga kisìjé yijo‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato, tà k'oa̱á ko̱ma‑la̱ nga jye k'en Jesús; kiìchja̱‑la̱ jè xi̱ta̱ sko̱‑la̱ soldado; kiskònangui‑la̱ tsà kixi̱ kjoa̱ nga jye k'en. ");
INSERT INTO maaNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","K'e̱ nga jye tsibéno̱jmí jè xi̱ta̱ sko̱‑la̱ soldado nga jye k'en Jesús, Pilato kisìnga̱tsja José yijo‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José tsatse jngoò nikje sábana; kiskóje̱n‑t'aà krò yijo‑la̱ Jesús; i̱kjoàn kisìkájté jè nikje. K'e̱é kiì kíhijiìn ñánda jye tjíndaà jngoò nga̱jo̱ i̱tsjó i̱ngui nguijo; kiskinìs'en‑ngui, i̱kjoàn tsohójtsa xotjoa̱‑la̱ nga̱jo̱ jngoò nda̱jo̱. ");
INSERT INTO maaNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena ko̱ María nea̱‑la̱ José, nchikotsejèn‑la̱ nga kisìhijiìn Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","K'e̱ nga jye tsato na̱chrjein nìkjáya, María Magdalena, Salomé, ko̱ María nea̱‑la̱ Jacobo, tsatse xkiì jne̱ nga mejèn‑la̱ si̱ìkaàjno yijo‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jè na̱chrjein nga tàts'en xomàna̱, 'ñó ta̱jñòya kiì katsejèn‑la̱ ñánda kisìhijiìn Jesús. Ti̱k'e̱é tíbitjokàtji ts'oí. ");
INSERT INTO maaNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tsò‑la̱ xíkjín: ―¿Yá xi kjoa̱áxìn‑ná nda̱jo̱ xi tíchjoàjto ya̱ xotjoa̱‑la̱ nga̱jo̱ i̱tsjó? ");
INSERT INTO maaNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","K'e̱ nga ijchò, kiskoòtsejèn, kijtseè nga jè nda̱jo̱ je xi 'ñó i'í xi tíchjoàjto‑la̱ nga̱jo̱ i̱tsjó ñánda kisijna Jesús, jye kitjaàxìn. ");
INSERT INTO maaNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","K'e̱ nga jahas'en‑ngui nguijo kijtseè jngoò xi̱ta̱ i̱xti xi tíjnajté jngoò nikje chroba ndojò. Tíjnat'aà kixi̱‑la̱ nga̱jo̱. Jñà íchjín tà kitsakjòn‑né. ");
INSERT INTO maaNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ta̱nga jè xi̱ta̱ i̱xti kitsò‑la̱: ―Kì tsakjoòn‑jèn. Jñò, jè binchaàtsjioò Jesús xi Nazaret i̱'nde‑la̱, jè xi kisit'aà krò. Jye kòfaáya‑la̱. Mì ti̱ i̱ tíjna‑ne. Chítsejèn‑là i̱'nde‑la̱ ñánda kisijna. ");
INSERT INTO maaNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tanguió koa̱tìn‑là xi̱ta̱ xi kota'yàt'aà‑la̱ ko̱ Pedro: “Jè tífì ítjòn‑nò ján Galilea. Ya̱á jcha̱xkoòn ìjngoò k'a koni s'ín kitsò‑nò.” ");
INSERT INTO maaNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jñà íchjín, itjo ni̱to̱ón‑ne ya̱ i̱ya nguijo. Kiì, tsangachikon. Chi̱ba̱‑la̱ nchihotsé‑né nga kitsakjòn. Ni̱yá xi tsibéno̱jmí‑la̱ nga 'ñó tsibíxkón‑la̱ yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jè na̱chrjein nga tàts'en xomàna̱, Jesús jaáya‑la̱ nga ta̱jñòya. Jè kijtseè ítjòn María Magdalena, jè xi tsachrjekàjiìn itoò ini̱ma̱ ch'o‑la̱ nei̱í ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","María Magdalena kiì, kisìkí'nchré ngats'iì xi̱ta̱‑la̱ Jesús nga ba tjín‑la̱ koa̱ nchikjindáya. ");
INSERT INTO maaNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱, k'e̱ nga kiì'nchré nga tíjnakon Jesús nga jè chjo̱ón kijtseè, mìkiì kòkjeiín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","K'e̱ komà i̱skan, Jesús, kj'ei̱í kji i̱sén‑la̱ k'e̱ nga tsakó‑la̱ yijo‑la̱ jò xi̱ta̱‑la̱ xi nchifì campo. ");
INSERT INTO maaNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tsohótji‑ne jñà xi̱ta̱ xi jò ma, kisìkí'nchré jñà xi̱ta̱ xi i'nga. Ti̱koa̱á mìkiì kòkjeiín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Xi jyehet'aà‑ne, Jesús tsakó‑la̱ yijo‑la̱ jñà xi̱ta̱ xi tejngoò ma‑ne k'e̱ nga títsa̱jnat'aà ími̱xa̱ nga nchikjèn. Tsohótiko̱ nga tájaà tjín ini̱ma̱‑la̱ nga mì kòkjeiín‑la̱ k'e̱ nga tsibéno̱jmí‑la̱ jñá xi̱ta̱ xi tsakó ítjòn‑la̱ yijo‑la̱ nga jè jye jaáya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Koa̱ kitsò‑la̱: ―Tanguió nga tíjtsa i̱sò'nde. Tèno̱jmí yije‑là ngats'iì xi̱ta̱ jè 'én ndaà‑la̱ Nainá xi kjoa̱ ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jñà xi̱ta̱ xi ko̱kjeiín‑la̱ i̱t'aà ts'a̱n koa̱ ko̱ma bautizar, ki̱tjokàjiìn kjo̱'in. Ta̱nga jñà xi mìkiì ko̱kjeiín‑la̱, kjo̱'iín s'e̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jñà xi ko̱kjeiín‑la̱ i̱t'aà ts'a̱n, k'oa̱á s'ín jcha̱‑la̱; nga ko̱ma‑la̱ ko̱chrjekàjiìn ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ xi̱ta̱; ti̱koa̱á ko̱ma‑la̱ ki̱chja̱ 'én xi kj'ei̱í tsò; ");
INSERT INTO maaNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","tsà ye̱ tsobà'ñó, tsà xkiì kjan ski̱ne̱, ni̱mé xi ko̱ma‑la̱; ko̱hòsòn‑la̱ tsja xi̱ta̱ xi xk'én, ko̱ndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","K'e̱ nga jye o̱kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱, Na̱'èn‑ná Jesús, kitjámiì'nga; nga kiì ngajmiì, tsibìjna i̱t'aà kixi̱‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jñà xi̱ta̱‑la̱ kiì; kisìka'bí 'én ndaà‑la̱ nga kijndà i̱'nde, ko̱ jè Na̱'èn‑ná Jesús kisìchját'aà‑la̱ ko̱ kisìkixi̱yandaà 'én‑la̱ ko̱ kjo̱ndaà xi kis'iìn xi̱ta̱‑la̱. K'oa̱á s'ín kàtama.");
INSERT INTO maaNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kjoa̱ kixi̱ xi komà i̱jiìn na̱xa̱ndá i̱t'aà ts'e̱ Cristo, jye kjìn ma‑ne xi̱ta̱ xi kiskiì chiba ");
INSERT INTO maaNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","koni s'ín tsakóya‑naje̱n jñà xi̱ta̱ xi xko̱n kijtseè‑ne skanda tàts'en‑la̱ kjoa̱, ti̱jñà‑ne xi kis'e‑la̱ xá nga kisìka'bí 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ngaji̱ Na̱'èn Teófilo xi 'ñó ndeè, ti̱koa̱á 'a̱n, ndaà sasén‑na nga tìkjiì‑lè xo̱jo̱n jè, koni s'ín tjín nga jngoò ìjngoò sko̱ya kjoa̱; ndaà tsohotsjì‑jñaà yije skanda ti̱sa̱ tàts'en‑la̱ kjoa̱ ");
INSERT INTO maaNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","mé‑ne nga ìsa̱ ndaà jcha̱‑ne kjoa̱ kixi̱ xi nguì ko̱s'ín tjín, jñà 'én xi k'oa̱s'ín tsakóya‑lè xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Koi na̱chrjein k'e̱ nga jè tíjna xi̱ta̱xá ítjòn Herodes ján nangui Judea, tíjna jngoò no̱'miì xi Zacarías 'mì xi tje̱‑la̱ ts'e̱ Abías. Jè Zacarías tjín‑la̱ chjo̱ón xi Elisabet 'mì xi ti̱koa̱ tje̱‑la̱ ts'e̱ Aarón. ");
INSERT INTO maaNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jñà ingajò, xi̱ta̱ kixi̱‑né nga nguixko̱n Nainá. Síkitasòn yije‑né ngats'iì kjo̱tíxoma‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tsjìn‑la̱ i̱xti; jè Elisabet, chjo̱ón 'ndi̱‑né; ingajò, jyeé 'ñó xi̱ta̱ jchínga. ");
INSERT INTO maaNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jngoò na̱chrjein, jñà xi̱ta̱ no̱'miì xi síxákjoò Zacarías, jñà tsako̱‑la̱ nga kisìxá nguixko̱n Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Koni s'ín tjín kjo̱tíxoma xi ts'e̱ no̱'miì Israel, tsako̱‑la̱ suerte Zacarías nga jahas'en ni'ya tsjeè‑la̱ Nainá, ya̱ i̱ya i̱ngo̱ ítjòn, nga jè ko̱kà chrjongó‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jè hora k'e̱ nga tì chrjongó‑la̱ Nainá ngats'iì xi̱ta̱ na̱xa̱ndá, ya̱á títsa̱jna ndi̱tsin nga nchichja̱t'aà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jè Zacarías tsatsejèn jngoò‑la̱ àkja̱le̱‑la̱ Nainá xi síjna kixi̱ ya̱ ngobà kixi̱‑la̱ ñánda tìsòn chrjongó‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jè Zacarías k'e̱ nga kijtseè, tà kjòxkón‑la̱, tà kitsakjòn‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ta̱nga jè àkja̱le̱‑la̱ Nainá kitsò‑la̱: ―Ngaji̱, Zacarías, kì tsakjoòn‑jèn; jè kjoa̱ bìtsi'ba‑lè jye kina'yà‑la̱; jè chjo̱ón‑lè Elisabet, jts'ín jngoò‑la̱ ki'ndí x'i̱n; k'oa̱á s'ín kít'aà 'ín‑la̱ nga Juan k'oín. ");
INSERT INTO maaNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","'Ñó s'e̱‑lè kjo̱tsja. Koi kjoa̱‑la̱ nga jè ki'ndí xi jts'ín, kjìn xi̱ta̱ kjo̱tsja‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Xi̱ta̱ ítjòn kíjna nga nguixko̱n Nainá; mìkiì xán sk'oí nga xó k'oa̱á s'ín kitjaàjiìn‑ne; Ini̱ma̱ Tsjeè‑la̱ Nainá si̱jiìn ini̱ma̱‑la̱ skanda ti̱k'e̱‑ne nga ti̱sa̱ tíjna'ya'ma i̱ndso̱'ba̱ nea̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Xi i̱t'aà ts'e̱, kjìn xi̱ta̱ na̱xa̱ndá Israel ko̱ófat'aà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jè kjoi̱ ítjòn‑la̱ Na̱'èn‑ná. Si̱jiìn ini̱ma̱‑la̱ nga'ñó xi kisìkjeén jè Elías xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. Ini̱ma̱‑la̱ xi̱ta̱ jchínga, 'nchán si̱ìkítsa̱jnako̱ i̱xti‑la̱. Jñà xi̱ta̱ xi tájaàjiìn tjín ini̱ma̱‑la̱ nga mìkiì síkitasòn, si̱ìkjatjìya‑la̱ kjo̱hítsjeèn‑la̱ mé‑ne nga s'e̱‑la̱ kjoa̱ chji̱ne̱ xi tjín‑la̱ xi̱ta̱ kixi̱. K'oa̱á s'ín si̱ìkíyijòndaà xi̱ta̱ na̱xa̱ndá mé‑ne nga kítsa̱jnandaà‑ne k'e̱ nga kjoi̱í Na̱'èn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías kitsò‑la̱ jè àkja̱le̱: ―¿Kó s'ín skoeè‑na tsà kixi̱ kjoa̱? 'A̱n, jye 'ñó xi̱ta̱ jchínga; ti̱koa̱á chjo̱ón‑na̱ jye tífehet'aà na̱chrjein‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jè àkja̱le̱ kitsò: ―'A̱n‑ná Gabriel xi tìjna̱a nguixko̱n Nainá; kisìkasén‑na nga kichjàko̱‑lè, tsjaà‑lè 'én ndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","I̱'ndei̱, kijna chi̱sín‑né, mìkiì ko̱ma ki̱nókjoi̱i skanda k'e̱ nga ki̱jchò na̱chrjein nga ki̱tasòn 'én koi, koií kjoa̱‑la̱ nga mìkiì kòmokjeiín‑lè 'én‑na̱ xi kàxan‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jñà xi̱ta̱ na̱xa̱ndá, nchikoña‑la̱ Zacarías. Kjònangui‑la̱ xíkjín nga tífìchrjein‑la̱ nga mìkiì xátí bitjo‑ne ni'ya tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","K'e̱ nga jye itjo‑ne jyeé kjòchi̱sín; mì ti̱ kiì ma chja̱‑ne; jñà xi̱ta̱ xi nchikoña‑la̱ kis'ejiìn‑la̱ nga tjín kjoa̱ xi kijtseè ya̱ i̱ya ni'ya tsjeè‑la̱ Nainá; Zacarías tà jmeé chi̱sín‑ìsa tsja. K'oa̱á s'ín tsibìjna nga mìkiì komà kiìchja̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zacarías, k'e̱ nga jye kisisòn jñà na̱chrjein nga kisìkitasòn xá‑la̱, kiì‑ne ni'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","K'e̱ nga komà i̱skan, jè chjo̱ón Elisabet, ki'ndí ts'a; 'òn sá mì ti̱ kiì itjo‑ne ni'ya‑la̱. Kitsò: ");
INSERT INTO maaNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“K'oa̱á s'ín kisìko̱‑na jè Nainá xi i̱t'aà ts'a̱n: kijtseè i̱ma̱á‑na nga kitsjaà‑na kjo̱ndaà‑la̱ mé‑ne nga mì kiì ti̱ ko̱chrjekàngui‑na xi̱ta̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","K'e̱ nga ijchò joòn sá, jè àkja̱le̱ Gabriel, Nainá kisìkasén jngoò na̱xa̱ndá xi chja̱‑ne Galilea ñánda 'mì Nazaret. ");
INSERT INTO maaNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kiìkon jngoò chjo̱ón xo̱ngó xi tjín‑ne nga jè ki̱xan‑ko̱ jngoò xi̱ta̱ xi 'mì José xi tje̱‑la̱ ts'e̱ xi̱ta̱xá ítjòn xi ki'mì David. Jè 'ín‑la̱ chjo̱ón xo̱ngó, María 'mì. ");
INSERT INTO maaNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jè àkja̱le̱, k'e̱ nga jahas'en ni'ya nga kijtseèxkon María, kitsò‑la̱: ―¡Ndaà‑lè, ngaji̱ xi ji̱ kitjoé‑lè kjo̱ndaà jè! Nainá tíjnako̱‑lè. Ngaji̱ xi ndaà kjòchikon‑t'in mì k'oa̱á‑ne koni íchjín xi kj'ei̱í. ");
INSERT INTO maaNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Jè María k'e̱ nga kijtseèxkon, tà kjòxkón‑la̱ koni s'ín kitsò‑la̱ jè àkja̱le̱; kisìkítsjeèn kó tsòya‑ne nga ko̱s'ín j'iì síhixat'aà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jè àkja̱le̱ kitsò‑la̱: ―María, kì tsakjoòn‑jèn, jye kitjoé‑lè kjo̱ndaà nga nguixko̱n Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","I̱'ndei̱ ko̱xk'én‑né, ki'ndí jcha̱ jngoiì. K'oa̱á s'ín kít'iì 'ín‑la̱ nga Jesús k'oín. ");
INSERT INTO maaNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Xi̱ta̱ ítjòn ko̱ma; Ki'ndí‑la̱ Nainá k'oín xi ìsa̱ 'ñó 'nga tíjna; Nainá, jè si̱ìnga̱tsja kjo̱tíxoma‑la̱. Xi̱ta̱xá ítjòn kíjna koni s'ín tsibìjna David xi xi̱ta̱ jchínga‑la̱ komà. ");
INSERT INTO maaNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jè ko̱tìxoma‑la̱ na̱xa̱ndá Israel. Kjo̱tíxoma‑la̱ mì kì kjoe̱het'aà ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jè María k'e̱é kitsò‑la̱ àkja̱le̱: ―¿Kó s'ín ko̱ma jè kjoa̱ koi? Nga mìtsà x'i̱n tjín‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jè àkja̱le̱ kitsò: ―Jè Ini̱ma̱ Tsjeè‑la̱ Nainá ki̱tjojen‑nè‑lè. Jè nga'ñó‑la̱ Nainá xi 'ñó 'nga tíjna koi̱ìjtsat'in‑lè koni jngoò 'nguién‑la̱ ifi mé‑ne jè ki'ndí tsjeè xi jts'ín, Ki'ndí‑la̱ Nainá k'oín. ");
INSERT INTO maaNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jè xingui̱i Elisabet xi chjo̱ón 'ndi̱, kò joòn sá tjín‑la̱ nga ki'ndí 'ya na̱s'ín jye 'ñó xi̱ta̱ jchínga. ");
INSERT INTO maaNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Xi i̱t'aà ts'e̱ Nainá, ni̱jngoò kjoa̱ xi mìkiì ko̱ma‑la̱ ―kitsò àkja̱le̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","K'e̱é kitsò María: ―'A̱n‑ná xi chjo̱ón chi̱'nda‑la̱ Nainá; k'oa̱s'ín kàtama koni s'ín kò'mì‑ná. Jè àkja̱le̱ ti̱nguixko̱ón‑ne kiì‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na̱chrjein koi, jè María ni̱to̱ón kiì jngoò na̱xa̱ndá xi kijna'nchò nindoò ján nangui Judea. ");
INSERT INTO maaNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jahas'en ni'ya‑la̱ Zacarías; kisìhixat'aà Elisabet. ");
INSERT INTO maaNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","K'e̱ kiì'nchré Elisabet nga kisìhixat'aà María, ki'ndí xi 'ya, kiskì'nga i̱ya i̱ndso̱'ba̱. Jè ini̱ma̱‑la̱ Elisabet ndaà kis'ejiìn Ini̱ma̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","K'e̱é 'ñó kiìchja̱, kitsò: ―¡Nainá, ìsa̱á 'ñó ndaà tísíchikon‑t'in‑lè mì k'oa̱á‑ne koni jñà íchjín xi kj'ei̱í; ti̱koa̱á ki'ndí‑lè xi tíjnaya i̱ndso̱'boì 'ñó ndaà tímachikon‑t'in! ");
INSERT INTO maaNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Yá‑ná 'a̱n? ¡Mé tà ndaà kòf'ìi̱jchon‑ná ji̱ xi nea̱‑la̱ Na̱'èn‑ná! ");
INSERT INTO maaNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ti̱k'e̱‑né nga kà'nchrè nga kànìhixat'aà‑ná, ki'ndí‑na̱ kàkjì'ngaya i̱ndso̱'bà nga tsja kòma‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Mé tà ndaà‑lè nga mokjeiín‑lè 'én xi kis'eno̱jmí‑lè! Jè 'én xi kiìchja̱ Nainá ki̱tasòn‑né ―kitsò Elisabet. ");
INSERT INTO maaNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jè María kitsò: Ini̱ma̱‑na̱ 'ñó 'nga tísíkíjna Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Matsja‑na i̱t'aà ts'e̱ Nainá xi ochrjekátjì‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kijtseè i̱ma̱á‑na, 'a̱n xi chjo̱ón chi̱'nda‑la̱ ma; i̱'ndei̱ skanda ni̱ta̱ kjé‑ne k'oa̱á s'ín ki̱tso̱‑na xi̱ta̱: “Mé tà ndaá‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","'Ñó ndaà tse kjoa̱ kisìko̱‑na Nainá, jè, nga ìsa̱ tse nga'ñó tjín‑la̱. Nainá, xi̱ta̱ tsjeè‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tjín kjit'aà‑la̱ kjo̱hi̱ma̱takòn i̱t'aà ts'e̱ jñà xi̱ta̱ xi beèxkón skanda tàts'en‑la̱ kjoa̱ ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","K'oa̱á s'ín okó nga tse nga'ñó tjín‑la̱; jñà xi̱ta̱ xi 'ñó 'nga ikon i̱jiìn ini̱ma̱‑la̱, ochrjekàngui kjo̱hítsjeèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jñà xi̱ta̱xá ítjòn xi 'nga títsa̱jna, faáxìn kjo̱tíxoma‑la̱, koa̱ jñà xi nangui títsa̱jna, ìsa̱á 'nga síkítsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jñà xi̱ta̱ xi tsjìn‑la̱ tsojmì xi kine, 'ñó kjìn tsjá‑la̱, koa̱ jñà xi̱ta̱ nchi̱ná, ni̱mé tsjá‑la̱, tà síkasén tiyaá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nainá síchját'aà‑la̱ na̱xa̱ndá Israel, jñà xi̱ta̱ chi̱'nda‑la̱; mìkiì síjchàajiìn nga tjòkeè Abraham, ");
INSERT INTO maaNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ngats'iì tje̱‑la̱ ni̱ta̱ mé na̱chrjein‑ne. Nga Nainá, k'oa̱á s'ín kitsjaà‑la̱ tso'ba jñà xi̱ta̱ jchínga‑ná. Kitsò María. ");
INSERT INTO maaNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Jè María, jàn sá tsibìjnako̱ Elisabet; k'e̱ komà i̱skan kiì‑ne ni'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","K'e̱ nga jye ijchò na̱chrjein‑la̱, Elisabet, kits'iìn jngoò‑la̱ ki'ndí x'i̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nainá, 'ñó ndaà kisìko̱. K'e̱ nga kiì'nchré xi̱ta̱ xíkjín ko̱ xi̱ta̱ i̱ndiì ni'ya‑la̱ ti̱koa̱á kjòtsja‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nga komà jiìn na̱chrjein, kiìko̱ jè ki'ndí nga nguixko̱n no̱'miì, mé‑ne nga kisit'aà chi̱ba̱‑la̱ yijo‑la̱ kjoa̱ ts'e̱ circuncisión. Jñà xi̱ta̱ xi kj'ei̱í, k'oa̱á s'ín mejèn tsibít'aà 'ín koni 'mì na̱'èn‑la̱ nga Zacarías 'mì. ");
INSERT INTO maaNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ta̱nga jè nea̱‑la̱ kitsò: ―Majìn, Juan k'oín. ");
INSERT INTO maaNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kitsò jñà xi̱ta̱ xi títsa̱jna: ―¿Mé‑ne ko̱s'ín k'oín‑ne? Ni̱jngoò xi̱ta̱ xingui̱i xi ko̱s'ín 'mì 'ín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","K'e̱é kitjònangui chi̱sín‑la̱ na̱'èn‑la̱ kó k'oín. ");
INSERT INTO maaNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarías kisìjé jngoò íteè nga kiskiìjno, tsibít'aà: “Juan 'mì 'ín‑la̱.” Ngats'iì xi̱ta̱ xi ya̱ títsa̱jna, tà k'oa̱á komà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zacarías ti̱k'e̱é‑ne kitáx'a̱‑ne tso'ba ko̱ tsanìyá‑ne ni̱je̱n, i̱kjoàn komà kiìchja̱‑ne. K'e̱é kitsjaà‑la̱ kjo̱ndaà Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ngats'iì xi̱ta̱ xi títsa̱jna chrañà i̱ndiì ni'ya‑la̱, tà kjòxkón‑la̱ k'e̱ nga kiì'nchré nga jye ma kiìchja̱‑ne Zacarías. Xki̱ xi ján tsabísòn kjoa̱ koi kóho̱kji i̱nchò nindoò nangui Judea. ");
INSERT INTO maaNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ngats'iì xi̱ta̱ xi kiì'nchré kjoa̱ koi, tsohóko̱ i̱jiìn ini̱ma̱‑la̱; kitsò: ―Jè ki'ndí, k'e̱ nga ko̱jchínga, ¿yá xi̱ta̱ xi ko̱ma? Nga jè nga'ñó‑la̱ Nainá tíjnako̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, na̱'èn‑la̱ Juan, kisijiìn ini̱ma̱‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá. Kiìchja̱ ngajo‑la̱ Nainá, kitsò: ");
INSERT INTO maaNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Mé tà ndaà kji‑la̱ Na̱'èn‑ná jè xi Nainá tsò‑la̱ na̱xa̱ndá Israel nga j'iì kíchjítjì na̱xa̱ndá‑la̱ ti̱koa̱ j'iì síkíjnandei̱í! ");
INSERT INTO maaNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kitsjaà jngoò‑ná xi̱ta̱ xi tse nga'ñó tjín‑la̱ nga j'iì kachrjetjì‑ná kjo̱'in xi kjoa̱ ts'e̱ jé‑ná, jè xi tje̱‑la̱ David xi chi̱'nda‑la̱ Nainá tsibìjna. ");
INSERT INTO maaNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nainá kisìkjeén tso'ba jñà xi̱ta̱ tsjeè‑la̱ xi kiìchja̱ ngajo‑la̱. K'oa̱á s'ín kitsò nga ti̱sa̱ tàts'en‑la̱ kjoa̱ nga ");
INSERT INTO maaNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ko̱chrjekátjì‑ná i̱t'aà ts'e̱ xi̱ta̱ kondra̱‑ná, ko̱ xi̱ta̱ xi jtikeè‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","K'oa̱á ti̱ kitsò Nainá nga skoe̱ i̱ma̱ jñà xi̱ta̱ jchínga‑ná. Mìkiì si̱ìjchàajiìn jè 'én xi kitsjaà‑la̱ xi̱ta̱ jchínga‑ná Abraham nga tsibíndaàjiìn‑ko̱ jngoò kjoa̱ tsjeè. ");
INSERT INTO maaNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nainá, k'oa̱á s'ín kitsjaà‑la̱ tso'ba Abraham xi xi̱ta̱ jchínga kjiìn‑ná nga ");
INSERT INTO maaNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","si̱ìkítsa̱jnandei̱í‑ná ts'e̱ xi̱ta̱ kondra̱‑ná mé‑ne nga mìkiì ki̱skoán nga si̱xá‑lá. ");
INSERT INTO maaNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kjit'aà na̱chrjein tsjeè ki̱tsa̱jnaá ti̱koa̱ kixi̱ ki̱tsa̱jnaá nga nguixko̱n Nainá. Kitsò Zacarías. ");
INSERT INTO maaNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","K'e̱é kitsò‑la̱ ki'ndí‑la̱: Ngaji̱, si̱ìkjeén‑lè Nainá xi 'ñó 'nga tíjna nga ki̱nókjoa̱ ngajo‑la̱. Ngaji̱í k'oín ítjòn‑la̱ Na̱'èn‑ná nga kíndiì ndi̱yá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kéno̱jmí‑la̱ na̱xa̱ndá‑la̱ kós'ín s'ín Nainá nga ko̱chrjekátjì‑ná jé‑ná. Nainá, 'ñó tse kjo̱hi̱ma̱takòn tjín‑la̱ nga síjchàat'aà‑la̱ jé‑la̱ jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nainá si̱ìkasén jngoò‑ná xi nchrobá‑ne ngajmiì. K'e̱ nga kjoi̱í, k'oa̱á s'ín si̱ìhiseèn‑la̱ xi̱ta̱ koni s'ín mahiseèn k'e̱ nga ta̱jñòya. ");
INSERT INTO maaNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jñà ko̱hiseèn‑la̱ kjo̱hítsjeèn‑la̱ xi̱ta̱ xi i̱'nde jñò títsa̱jnajiìn, ko̱ xi jye ndi̱yá kjoa̱ biyaà tjímaya. Ya̱á kji̱ko̱‑ná ndi̱yá ñánda tjín kjoa̱'nchán. Kitsò Zacarías. ");
INSERT INTO maaNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ki'ndí jè tímajchínga ti̱koa̱ tís'e‑la̱ nga'ñó xi ts'e̱ ini̱ma̱‑la̱. Ya̱á tsibìjna i̱'nde i̱t'aà xìn ñánda nangui kixì choòn skanda k'e̱ nga tsibíts'ia̱ nga tsibìjna osen‑la̱ na̱xa̱ndá Israel. ");
INSERT INTO maaNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Koi na̱chrjein k'e̱ nga tjín‑la̱ xá ítjòn César Augusto tsjachrje jngoò o̱kixi̱ nga ngats'iì xi̱ta̱ na̱xa̱ndá xi otíxoma‑la̱ Roma, xo̱jo̱ón si̱t'aà 'ín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jè xo̱jo̱n censo xi kisindaà ítjòn k'e̱ nga tíjna gobernador xi̱ta̱ xi 'mì Cirenio ján i̱'nde ñánda 'mì Siria. ");
INSERT INTO maaNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kiì yije xi̱ta̱ nga kiì kít'aà xo̱jo̱n yijo‑la̱ nga jngoò ìjngoò na̱xa̱ndá‑la̱ xi chja̱‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José itjo‑ne Nazaret, na̱xa̱ndá ts'e̱ Galilea, kiì nangui ñánda 'mì Judea ya̱ na̱xa̱ndá Belén ñánda kits'iìn xi̱ta̱ ítjòn xi David ki'mì nga jè José, tje̱‑la̱ ts'e̱ David‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kiì kít'aà xo̱jo̱n yijo‑la̱; ti̱koa̱á kiì jè María, chjo̱ón‑la̱ xi tíjna'ñó‑la̱ nga jè ki̱xan‑ko̱, ta̱nga jyeé ki'ndí 'ya. ");
INSERT INTO maaNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","K'e̱ nga jye títsa̱jna Belén, María ijchò na̱chrjein‑la̱ nga kits'iìn ki'ndí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kits'iìn ki'ndítjòn‑la̱ xi ndí ki'ndí x'i̱n; kisìkájté nikje‑la̱; ya̱ kisìkánaya kaxa̱ ñánda kjèn‑ya cho̱, nga mì ti̱ kiì tjín‑ne i̱'nde ya̱ ni'ya ñánda ma nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ya̱ chrañàt'aà‑la̱ Belén títsa̱jna paxtò xi nchisíkinda̱ cho̱ orrè‑la̱ nga ni̱tje̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tà ni̱to̱ón ijchòkon jngoò àkja̱le̱‑la̱ Nainá. Jè kjoa̱jeya‑la̱ Nainá xi 'ñó ote kji, kisìhiseèn yije kóho̱kji jngoò itjandiì ñánda títsa̱jna jñà paxtò. K'e̱ nga kijtseè, tsí ndaà kitsakjòn. ");
INSERT INTO maaNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jè àkja̱le̱ kitsò‑la̱: ―Kiì tsakjoòn‑jèn; 'a̱n, koií xá j'i̱‑na nga síkí'nchré jngoò‑nò 'én xi̱tse̱ xi ndaà tsò xi 'ñó kjo̱tsja‑la̱ ngats'iì na̱xa̱ndá: ");
INSERT INTO maaNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","I̱'ndei̱ kats'iìn jngoò ki'ndí ya̱ na̱xa̱ndá‑la̱ David jè xi ko̱chrjekàjiìn‑ná kjo̱'in, jè xi Cristo, xi̱ta̱ xi xó kisìkasén‑ne Nainá, nga jè ko̱tìxoma‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tjín jngoò seña nga kixi̱ kjoa̱: sa̱kò jngoò‑nò ki'ndí xi tsjájtéjiìn nikje‑la̱; kjinaya kaxa̱ ñánda kjèn‑ya cho̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ti̱k'e̱‑ne kjìn jchán àkja̱le̱ tsatsejèn‑kjoò‑ìsa xi inchrobà‑ne ngajmiì xi 'nga kisìkíjna Nainá. Kitsò: ");
INSERT INTO maaNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Nainá kàtas'e‑la̱ kjoa̱jeya ján ngajmiì; ko̱ i̱ i̱t'aà nangui, 'nchán kàtas'e kjoa̱, i̱t'aà ts'e̱ xi̱ta̱ xi tjín‑la̱ kjo̱ndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","K'e̱ nga kiì‑ne jñà àkja̱le̱ ján ngajmiì, jñà paxtò kitsò‑la̱ xíkjín: ―Tíkjiaán skanda Belén nga jcha̱á kjoa̱ xi kòma koni s'ín kàsìkí'nchré‑ná Na̱'èn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ni̱to̱ón kiì jñà paxtò ján Belén; k'e̱ nga ijchò, kisakò‑la̱ ñánda tíjna María ko̱ José, koa̱ jè ki'ndí, kjinaya kaxa̱ ñánda kjèn‑ya cho̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","K'e̱ nga kijtseèxkon ki'ndí jè, tsibéno̱jmí yije koni s'ín kitsò jè àkja̱le̱ i̱t'aà ts'e̱ ki'ndí. ");
INSERT INTO maaNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ngats'iì xi̱ta̱ xi kiì'nchré koni s'ín kitsò jñà paxtò tà k'oa̱á komà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ta̱nga jè María ya̱á tsibíjiìn yije i̱jiìn ini̱ma̱‑la̱ jñà 'én xi kis'eno̱jmí‑la̱. 'Ñó kisìkítsjeèn‑jiìn kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kiì ìjngoò k'a‑ne jñà paxtò; jeya tsachrje ti̱koa̱ ndaà kisìkíjna Nainá ngats'iì kjoa̱ xi kiì'nchré ko̱ xi kijtseè, nga nguì k'oa̱á s'ín komà koni s'ín kis'eno̱jmí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","K'e̱ nga ijchò jiìn na̱chrjein nga kits'iìn ki'ndí jè, kisit'aà chi̱ba̱‑la̱ yijo‑la̱ kjoa̱ ts'e̱ circuncisión; Jesús kisit'aà 'ín‑la̱ koni s'ín kitsò àkja̱le̱‑la̱ Nainá k'e̱ nga ti̱sa̱ kisinaya'ma i̱ndso̱'ba̱ nea̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ijchò na̱chrjein nga k'oa̱s'ín s'ín xi̱ta̱ koi, koni s'ín tíchja̱ kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, mé‑ne jè María tsjeè kíjna‑ne nguixko̱n Nainá. Na̱chrjein koi, kiìko̱ Jesús i̱ngo̱ ítjòn ya̱ Jerusalén nga kisìnga̱tsja Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","K'oa̱á s'ín tjít'aà kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés: “Ngats'iì ki'ndí x'i̱n xi jts'ín ítjòn, ts'e̱é Nainá, jè ko̱nga̱tsja.” ");
INSERT INTO maaNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Xi̱ta̱ jchínga‑la̱ Jesús kiìko̱ kjo̱tjò‑la̱ nguixko̱n Nainá; jò tjo̱ni̱'ña̱ ko̱ tsà jò pichón koni s'ín tjín kjo̱tíxoma‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Koi na̱chrjein ján Jerusalén tíjna jngoò xi̱ta̱ kixi̱ xi ndaà beèxkón Nainá, Simeón 'mì. Ti̱koa̱á tíkoña‑la̱ jè xi si̱ìkíjnandei̱í na̱xa̱ndá Israel; jè Simeón, ya̱á tíjnako̱ Ini̱ma̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jè Ini̱ma̱ Tsjeè‑la̱ Nainá k'oa̱á s'ín tsibéno̱jmíya‑la̱ Simeón nga mìkiì ki̱yá skanda k'e̱ nga skoe̱xkon Cristo xi Nainá si̱ìkasén. ");
INSERT INTO maaNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jè Ini̱ma̱‑la̱ Nainá kisìkasén Simeón ján i̱ngo̱ ítjòn Jerusalén. K'e̱ nga ijchòko̱ Jesús jñà xi̱ta̱ jchínga‑la̱ mé‑ne nga kisìkitasòn‑ne koni s'ín síjé kjo̱tíxoma‑la̱, ");
INSERT INTO maaNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón kiskoé ki'ndí jè, tsohóya tsja; 'nga kisìkíjna Nainá. Kitsò: ");
INSERT INTO maaNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Na̱'èn, jyeé kòbitasòn 'én‑lè koni s'ín ki'mì‑ná, i̱'ndei̱, 'nchán kàtiyaà 'a̱n xi chi̱'nda‑lè ma. ");
INSERT INTO maaNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Jyeé kòbe‑na xkoaàn jè xi ko̱chrjekátjì‑ná kjo̱'in, ");
INSERT INTO maaNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","jè xi kànìkíjna‑osin nguixko̱n ngats'iì na̱xa̱ndá, ");
INSERT INTO maaNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","jè xi si̱ìhiseèn‑la̱ kjo̱hítsjeèn‑la̱ jñà xi̱ta̱ xi mìtsà xi̱ta̱ na̱xa̱ndá Israel. I̱t'aà ts'e̱ ki'ndí jè, na̱xa̱ndá‑lè Israel jeyaá kíjna. ");
INSERT INTO maaNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jñà xi̱ta̱ jchínga‑la̱ Jesús tà k'oa̱á komà‑la̱ koni s'ín kitsò Simeón i̱t'aà ts'e̱ ki'ndí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón kisìjét'aà‑la̱ Nainá nga kàtasíchikon‑t'in; i̱kjoàn kitsò‑la̱ María, nea̱‑la̱ Jesús: ―I̱t'aà ts'e̱ ki'ndí jè, k'oa̱á s'ín tjínè‑la̱ nga kjìn xi̱ta̱ na̱xa̱ndá Israel ki̱tjojiìn kjo̱'in koa̱ kjìn ki̱xo̱jiìn. Seña‑la̱ Nainá kíjna ");
INSERT INTO maaNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","mé‑ne nga jcha̱‑la̱ kó s'ín tjín kjo̱hítsjeèn‑la̱ nga jngoò ìjngoò xi̱ta̱, ta̱nga kjìn xi̱ta̱ xi mìkiì ko̱kjeiín‑la̱; ti̱koa̱á ngaji̱, k'oa̱á s'ín s'e̱‑lè kjo̱'on‑takòn koni tsà jngoò ki̱cha̱ ndojò ko̱tokjá ini̱ma̱‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ti̱koa̱á ya̱á tíjna chjo̱ón Ana xi chja̱ya 'én‑la̱ Nainá, tsòti‑la̱ Fanuel xi tje̱‑la̱ Aser. Jyeé 'ñó xi̱ta̱ jchínga. Itoò nó tsibìjnako̱ x'i̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Na̱chrjein koi, jè chjo̱ón Ana kò ñijòn kaàn ko̱ ñijòn nó tjín‑la̱ nga tíjna ka'àn. Ya̱á bìjnaya na̱chrjein inchijòn ya̱ ndi̱tsin i̱ngo̱ ítjòn; ko̱ na̱chrjein ko̱ ni̱tje̱n beèxkón Nainá; bítsi'ba‑la̱ koa̱ bìjnachjan. ");
INSERT INTO maaNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ti̱jè‑ne hora, chjo̱ón jè ijchò kasìjnat'aà chrañà‑la̱ xi̱ta̱ jchínga‑la̱ Jesús; kitsjaà‑la̱ kjo̱ndaà Nainá; kiìchja̱‑la̱ ngats'iì xi̱ta̱ i̱t'aà ts'e̱ ki'ndí jè, jñà xi ti̱koa̱ nchikoña‑la̱ nga ki̱tjotjì yije na̱xa̱ndá xi chja̱‑ne Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José ko̱ María, k'e̱ nga jye kisìhitasòn yije koni s'ín tíchja̱ kjo̱tíxoma‑la̱ Nainá, kiì ìjngoò k'a‑ne ján Galilea ya̱ na̱xa̱ndá‑la̱ Nazaret. ");
INSERT INTO maaNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ki'ndí jè tímajchínga; tís'e‑la̱ nga'ñó i̱jiìn ini̱ma̱‑la̱; ti̱koa̱á ìsa̱ ndaà tímachi̱ya‑la̱; ya̱á tíjnako̱ kjo̱ndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jñà xi̱ta̱ jchínga‑la̱ Jesús, xki̱ nó fì ya̱ Jerusalén k'e̱ nga bitjo s'eí Paxko̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús, k'e̱ nga jye tjín‑la̱ tejò nó ti̱koa̱ kiì ján Jerusalén koni s'ín choòn kjo̱tíxoma ts'e̱ s'eí Paxko̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","K'e̱ nga inchrobà‑ne xi̱ta̱ nga jyehet'aà s'eí, jè Jesús ya̱á tsibìjna Jerusalén; koa̱ jñà xi̱ta̱ jchínga‑la̱ mìkiì kisijiìn‑la̱ tsà ya̱ tsibìjna. ");
INSERT INTO maaNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jngoò na̱chrjein chinchimaya ndi̱yá. Maá‑la̱ tsà ya̱á tsóhojiìn‑la̱ jñà xi̱ta̱ xi nchifì‑ne. K'e̱ nga tsohótsjijiìn‑la̱ xíkjín ko̱ xi̱ta̱ xi beèxkon, ");
INSERT INTO maaNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","mìkiì kisakò‑la̱. K'e̱é kiì ìjngoò k'a ján Jerusalén nga kiì kátsji. ");
INSERT INTO maaNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","K'e̱ nga komà jàn na̱chrjein nga nchihótsji, kisakò‑la̱ ya̱ ndi̱tsin i̱ngo̱ ítjòn; tíjnajiìn‑la̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá; tí'nchré‑la̱ ti̱koa̱ tíkjònangui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ngats'iì xi̱ta̱ xi nchi'nchré‑la̱ tà k'oa̱á komà‑la̱ jè kjo̱hítsjeèn xi tjín‑la̱ koni s'ín tíchja̱. ");
INSERT INTO maaNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jñà xi̱ta̱ jchínga‑la̱, k'e̱ nga kijtseè nga ya̱ tíjna, ti̱koa̱á tà k'oa̱á komà‑la̱; jè nea̱‑la̱ kitsò‑la̱: ―Ji̱ na̱'èn, ¿mé‑ne nga ko̱s'ín nìko̱‑náje̱n? Na̱'èn‑lè ko̱ 'a̱n tímakájno‑naje̱n nga kichijì, titsa̱binchaàtsji‑lèje̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús kitsò: ―¿Mé‑ne nga binchaàtsji‑ná? ¿A mì tíjiìn‑nò nga tjínè‑na nga ya̱ kóti̱jna ni'ya‑la̱ Na̱'èn‑na̱? ");
INSERT INTO maaNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ta̱nga jñà xi̱ta̱ jchínga‑la̱ mìkiì jahas'en‑jiìn‑la̱ jè 'én xi kitsò Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesús, kiì ìjngoò k'a‑ne ján Nazaret ko̱ nea̱‑la̱ ko̱ na̱'èn‑la̱; Jesús ndaà kisìkitasòn‑la̱ xi̱ta̱ jchínga‑la̱. Jè nea̱‑la̱ tà ya̱á tsibíjiìn‑ikon ini̱ma̱‑la̱ ngats'iì kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús, tímajchínga koa̱ na̱chrjein inchijòn, ìsa̱ ndaà tímachi̱ya‑la̱; ti̱koa̱ tís'e‑la̱ kjo̱ndaà‑la̱ Nainá ko̱ ts'e̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","K'e̱ nga jye tjín‑la̱ chrj'oòn nó nga tíhotíxoma‑la̱ i̱sò'nde xi chja̱‑ne Roma jè xi 'mì Tiberio César, ko̱ ján nangui Judea, jè tíjna gobernador Poncio Pilato; ko̱ jè Herodes, xi̱ta̱xá ítjòn tíjna ya̱ nangui Galilea; ko̱ jè Felipe xi 'ndse̱ ma Herodes, xi̱ta̱xá ítjòn tíjna ya̱ nangui ñánda 'mì Iturea ko̱ ya̱ nangui Traconite; ko̱ jè Lisanias, xi̱ta̱xá ítjòn tíjna ya̱ nangui Abilinia. ");
INSERT INTO maaNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ko̱ ján Jerusalén, no̱'miì ítjòn títsa̱jna jè Anás ko̱ Caifás. Ti̱koi‑ne na̱chrjein, Juan, ki'ndí‑la̱ Zacarías, kits'iì‑la̱ 'én‑la̱ Nainá ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn. ");
INSERT INTO maaNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan, kiì kóho̱kji i̱ndiì xa̱jngá nandá Jordán nga kiìchja̱ya nga kàtasíkájno jé‑la̱ jñà xi̱ta̱ nga mì ti̱ jé ko̱hótsji‑ne, i̱kjoàn kàtas'ín bautizar yijo‑la̱ mé‑ne nga si̱ìjchàat'aà‑la̱ Nainá jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","K'e̱ nga k'oa̱s'ín kiìchja̱ya Juan, jñà tíbitasòn 'én xi kiskiì Isaías, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá nga tsò: Na'yà‑la̱ 'én xi 'ñó chja̱ ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn: “Tjandaà ndi̱yá‑la̱ Nainá ya̱ i̱jiìn ini̱ma̱‑nò; kixi̱ ti̱kíjna koni jngoò ndi̱yá ñánda ko̱jmeèya Na̱'èn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ngats'iì xa̱jngá ko̱ngásòn‑né; ngats'iì nindoò ko̱ chrja̱ngui̱, ko̱kixi̱‑né; jñà ndi̱yá xi tsó'ño̱ tjín, ti̱koa̱á ko̱kixi̱‑né; koa̱ jñà ndi̱yá xi tje̱n‑jen‑jno tje̱n‑jen‑t'aà choòn, ko̱jchoòn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ngats'iì xi̱ta̱ nga tíjtsa i̱sò'nde, skoe̱‑né kó s'ín s'i̱in Nainá nga ko̱chrjekátjì jé‑la̱ xi̱ta̱.” Kitsò Isaías. ");
INSERT INTO maaNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Juan kitsò‑la̱ jñà xi̱ta̱ xi ijchò nga mejèn‑la̱ ko̱ma bautizar: ―¡Jñò xi xi̱ta̱ tje̱‑la̱ ye̱ 'mì‑nò! ¿Yá xi o̱kitsò‑nò nga ki̱nchat'aàxìn‑là jè kjo̱'in xi sa̱ nchrobá machrañàt'aà‑nò? ");
INSERT INTO maaNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ndaà tjín kjoa̱ xi t'e̱en nga ndaà kàta'ya‑nò nga jyeé kinìkájno jé‑nò nga mì ti̱ jé binchaàtsji‑nò. Kì bixón‑jèn ya̱ i̱jiìn ini̱ma̱‑nò: “Ngaje̱n, mìkiì s'e̱‑naje̱n kjo̱'in nga ya̱á inchrobàt'aà‑naje̱n tje̱‑la̱ Abraham.” K'oa̱á xan‑nò, Nainá, skanda jñà nda̱jo̱ ko̱maá‑la̱ si̱ìkjatjìya‑la̱ nga i̱xti‑la̱ Abraham ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jè ki̱cha̱yá jyeé kjijnandaà nga ko̱tesòn yá; ngats'iì yá xi 'mì ndaà toò ojà‑la̱, skanda ko̱ i̱ma̱‑la̱, jtísòn‑né, i̱kjoàn si̱nchájiìn ni'ín nga ki̱ti̱. ");
INSERT INTO maaNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jñà xi̱ta̱ kiskònangui‑la̱ kitsò‑la̱: ―¿Mé xi s'e̱n‑je̱n? ");
INSERT INTO maaNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan kiìchja̱ kitsò‑la̱: ―Jè xi jò ma na̱chro̱‑la̱ kàtatsjá jngoò‑la̱ jè xi tsjìn‑la̱; jè xi tjín‑la̱ tsojmì xi kine, kàtatsjá‑la̱ jè xi tsjìn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ti̱koa̱á j'iì i'nga xi̱ta̱‑la̱ xi̱ta̱xá Roma xi síkíchjítjì tsojmì nga mejèn‑la̱ ko̱ma bautizar. Kitsò‑la̱ Juan: ―Maestro, ngaje̱n, ¿mé xi s'e̱n‑je̱n? ");
INSERT INTO maaNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan kitsò: ―Kì tsato níkíchjió koni s'ín tíchja̱ kjo̱tíxoma. ");
INSERT INTO maaNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ti̱koa̱á kiskònangui i'nga jñà soldado, kitsò: ―Ngaje̱n, ¿mé xi s'e̱n‑je̱n? Juan kitsò‑la̱: ―Kì xi̱ta̱ binchaxkón‑là, kì 'én ndiso nìyasòn‑là k'e̱ nga nì mé kjoa̱ tjín‑la̱ nga to̱n mejèn‑nò nachrjekàjno‑là; kàtajngoò‑takòn koni tjín machjí‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nchikoña jñà xi̱ta̱ na̱xa̱ndá; nchisíkítsjeèn i̱jiìn ini̱ma̱‑la̱ xi i̱t'aà ts'e̱ Juan: tsà jè xi Cristo, xi̱ta̱ xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan kitsò‑la̱ ngats'iì xi̱ta̱ na̱xa̱ndá: ―O̱kixi̱‑né, 'a̱n, tà nandá s'iìn‑nò bautizar; ta̱nga nchrobá ìjngoò xi ìsa̱ tse nga'ñó tjín‑la̱ mì k'oa̱á‑ne koni 'a̱n; skanda mìkiì tjí'nde‑na nga skíjnda̱'ñoá xo̱x'ín‑la̱ xo̱jté‑la̱; jè xi sa̱ nchrobá, s'i̱in‑nò bautizar ko̱ Ini̱ma̱ Tsjeè‑la̱ Nainá koa̱ ko̱ ni'ín. ");
INSERT INTO maaNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jyeé kjinaya tsja jè pala nga si̱ìtsjeè tjé‑la̱ trigo. Ki̱nchàxkó trigo ya̱ i̱ya ni'nga; ta̱nga jè tjé‑la̱ trigo, ko̱kà‑né ya̱ i̱jiìn ni'ín ñánda mìkiì bits'o ni̱ta̱ mé na̱chrjein‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Juan, k'oa̱á s'ín kiìchja̱yajiìn‑la̱ xi̱ta̱ 'én ndaà‑la̱ Nainá; kjìn sko̱ya kjo̱tíxoma tsibít'in‑la̱ xi ndaà tsò. ");
INSERT INTO maaNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juan, tsohótiko̱ jè Herodes xi xi̱ta̱ ítjòn tíjna, koií kjoa̱‑la̱ nga jè tíjnako̱ Herodías chjo̱ón‑la̱ Felipe xi 'ndse̱ Herodes. Ti̱koa̱ tsohótiko̱ Herodes ngats'iì kjoa̱ xi ch'o tís'ín. ");
INSERT INTO maaNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ta̱nga jè Herodes, ìsa̱á 'ñó ch'o kis'iìn‑ìsa: nda̱yá kiskinìs'en Juan. ");
INSERT INTO maaNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","K'e̱ nga ti̱kj'eè nda̱yá fahas'en Juan nga tís'ín bautizar ngats'iì xi̱ta̱ na̱xa̱ndá, ti̱koa̱á k'e̱é komà bautizar Jesús; k'e̱ nga tíchja̱t'aà‑la̱ Nainá Jesús, kitáx'a̱ ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","I̱kjoàn itjojen‑nè‑la̱ Jesús jè Ini̱ma̱ Tsjeè‑la̱ Nainá xi o̱kji koni kji ni̱se paloma; koa̱ kina'yà jngoò‑la̱ 'én xi ngajmiì inchrobà‑ne xi kitsò: ―Ji̱‑né xi ki'ndí‑na̱ xan‑lè xi 'ñó matsjake̱‑lè; tsja tjín‑la̱ takoàn i̱t'aà tsi̱ji. ");
INSERT INTO maaNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús k'e̱ nga tsibíts'ia̱ nga kisìxá, tjín‑la̱ tsà katé nó. K'oa̱á s'ín tíjiìn‑la̱ xi̱ta̱, nga ki'ndí‑la̱ xó José; José, ki'ndí‑la̱ Elí; ");
INSERT INTO maaNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí, ki'ndí‑la̱ Matat; Matat, ki'ndí‑la̱ Leví; Leví, ki'ndí‑la̱ Melqui; Melqui, ki'ndí‑la̱ Jana; Jana, ki'ndí‑la̱ José; ");
INSERT INTO maaNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José, ki'ndí‑la̱ Matatías; Matatías, ki'ndí‑la̱ Amós; Amós, ki'ndí‑la̱ Nahúm; Nahúm, ki'ndí‑la̱ Esli; Esli, ki'ndí‑la̱ Nagai; ");
INSERT INTO maaNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai, ki'ndí‑la̱ Maat; Maat, ki'ndí‑la̱ Matatías; Matatías, ki'ndí‑la̱ Semei; Semei, ki'ndí‑la̱ Josec; Josec, ki'ndí‑la̱ Judá; ");
INSERT INTO maaNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá, ki'ndí‑la̱ Joanán; Joanán, ki'ndí‑la̱ Resa; Resa, ki'ndí‑la̱ Zorobabel; Zorobabel, ki'ndí‑la̱ Salatiel; Salatiel, ki'ndí‑la̱ Neri; ");
INSERT INTO maaNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, ki'ndí‑la̱ Melqui; Melqui, ki'ndí‑la̱ Adi; Adi, ki'ndí‑la̱ Cosam; Cosam, ki'ndí‑la̱ Elmodam; Elmodam, ki'ndí‑la̱ Er; ");
INSERT INTO maaNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er, ki'ndí‑la̱ Josué; Josué, ki'ndí‑la̱ Eliezer; Eliezer, ki'ndí‑la̱ Jorim; Jorim, ki'ndí‑la̱ Matat; ");
INSERT INTO maaNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat, ki'ndí‑la̱ Leví; Leví, ki'ndí‑la̱ Simeón; Simeón, ki'ndí‑la̱ Judá; Judá, ki'ndí‑la̱ José; José, ki'ndí‑la̱ Jonam; Jonam, ki'ndí‑la̱ Eliaquim; ");
INSERT INTO maaNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim, ki'ndí‑la̱ Melea; Melea, ki'ndí‑la̱ Mainán; Mainán, ki'ndí‑la̱ Matata; Matata, ki'ndí‑la̱ Natán; ");
INSERT INTO maaNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán, ki'ndí‑la̱ David; David, ki'ndí‑la̱ Isaí; Isaí, ki'ndí‑la̱ Obed; Obed, ki'ndí‑la̱ Booz; Booz, ki'ndí‑la̱ Salmón; Salmón, ki'ndí‑la̱ Naasón; ");
INSERT INTO maaNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón, ki'ndí‑la̱ Aminadab; Aminadab, ki'ndí‑la̱ Aram; Aram, ki'ndí‑la̱ Esrom; Esrom, ki'ndí‑la̱ Fares; Fares, ki'ndí‑la̱ Judá; ");
INSERT INTO maaNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá, ki'ndí‑la̱ Jacob; Jacob, ki'ndí‑la̱ Isaac; Isaac, ki'ndí‑la̱ Abraham; Abraham, ki'ndí‑la̱ Taré; Taré, ki'ndí‑la̱ Nacor; ");
INSERT INTO maaNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor, ki'ndí‑la̱ Serug; Serug, ki'ndí‑la̱ Ragau; Ragau, ki'ndí‑la̱ Peleg; Peleg, ki'ndí‑la̱ Heber; Heber, ki'ndí‑la̱ Sala; ");
INSERT INTO maaNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala, ki'ndí‑la̱ Cainán; Cainán, ki'ndí‑la̱ Arfaxad; Arfaxad, ki'ndí‑la̱ Sem; Sem, ki'ndí‑la̱ Noé; Noé, ki'ndí‑la̱ Lamec; ");
INSERT INTO maaNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec, ki'ndí‑la̱ Matusalén; Matusalén, ki'ndí‑la̱ Enoc; Enoc, ki'ndí‑la̱ Jared; Jared, ki'ndí‑la̱ Mahalaleel; Mahalaleel, ki'ndí‑la̱ Cainán; ");
INSERT INTO maaNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán, ki'ndí‑la̱ Enós; Enós, ki'ndí‑la̱ Set; Set, ki'ndí‑la̱ Adán; Adán, xi jè sobà Nainá tsibíndaà. ");
INSERT INTO maaNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús, nga ndaà tíjiìn ini̱ma̱‑la̱ jè Ini̱ma̱ Tsjeè‑la̱ Nainá, inchrobà ìjngoò k'a‑ne ya̱ xa̱jngá nandá Jordán, koa̱ jè Ini̱ma̱ Tsjeè‑la̱ Nainá kiìko̱ jngoò i̱'nde i̱t'aà xìn ñánda nangui kixì choòn. ");
INSERT INTO maaNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ichán na̱chrjein tsibìjna. Jè xi̱ta̱ nei̱í kiskoòt'aà nga mejèn‑la̱ kàtátsji jé Jesús. Ngats'iì na̱chrjein koi, Jesús mìkiì tsakjèn, tsibìjnachjan‑né. K'e̱ nga jyehet'aà na̱chrjein, jyeé 'ñó kjòhojò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jè xi̱ta̱ nei̱í kitsò‑la̱: ―Tsà kixi̱ kjoa̱ nga ngaji̱ xi Ki'ndí‑la̱ Nainá 'mì‑lè, tjiì‑la̱ o̱kixi̱ nda̱jo̱ jè nga i̱nchra̱jín kàtama. ");
INSERT INTO maaNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús kiìchja̱ kitsò: ―Tjít'aà Xo̱jo̱n‑la̱ Nainá nga tsò: “Mìtsà tà koi tsojmì xi ma chine kítsa̱kon‑ne xi̱ta̱, ti̱koa̱á kítsa̱koón‑ne ngats'iì 'én‑la̱ Nainá.” ");
INSERT INTO maaNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jè xi̱ta̱ nei̱í kiìko̱ Jesús jngoò nindoò 'nga, tà jngoòhijta tsakó yije‑la̱ ngats'iì na̱xa̱ndá xi tjín i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jè xi̱ta̱ nei̱í kitsò‑la̱ Jesús: ―Ngaji̱í tsjaà yije‑lè ngats'iì na̱xa̱ndá koi, nga ji̱ ko̱ti̱xoma‑la̱ nga jeya ki̱jni. Nga 'a̱án kjònga̱tsja yije. Tsà mejèn‑na maá sìnga̱tsja ni̱ta̱ yá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ngaji̱, tsà ko̱si̱xkó'nchit'aà‑ná ko̱ jeya si̱kíjna‑ná, tsi̱jií ko̱ma kóho̱tjín. ");
INSERT INTO maaNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kiìchja̱ Jesús, kitsò‑la̱: ―Ti̱si̱t'aà xìn‑ná ji̱, xi̱ta̱ nei̱í. K'oa̱á s'ín tjít'aà Xo̱jo̱n‑la̱ Nainá nga tsò: “Jeya ti̱kíjni Na̱'èn‑ná xi Nainá; tà jè ta̱jngoò cha̱xkoín.” ");
INSERT INTO maaNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jè xi̱ta̱ nei̱í, i̱kjoàn kiìko̱ Jesús ján Jerusalén; kisìkíjnasòn i̱ngo̱ ítjòn ñánda ìsa̱ 'nga kji; kitsò‑la̱: ―Tsà kixi̱í kjoa̱ nga ji̱ xi Ki'ndí‑la̱ Nainá 'mì‑lè, ti̱katje̱ngui yijo‑lè i̱jndé; ");
INSERT INTO maaNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","k'oa̱á s'ín tjít'aà Xo̱jo̱n‑la̱ Nainá nga tsò: Nainá koií xá‑la̱ àkja̱le̱‑la̱ mé‑ne nga si̱ìkinda̱‑lè, ");
INSERT INTO maaNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","nga ko̱ tsja tso̱ba̱'ñó‑lè mé‑ne nga ni̱jngoò nda̱jo̱ satíngui‑ne ndso̱koiì. ");
INSERT INTO maaNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kiìchja̱ Jesús, kitsò‑la̱: ―K'oa̱á s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá nga tsò: “Kì ta̱xki̱ chít'aà‑jèn Na̱'èn‑ná xi Nainá.” ");
INSERT INTO maaNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jè xi̱ta̱ nei̱í, k'e̱ nga mì ti̱ kiì kisakò‑la̱ kós'ín skóna̱cha̱n‑la̱ Jesús nga mejèn‑la̱ ko̱hótsji jé, tsasìt'aà xìn chiba na̱chrjein‑la̱ skanda komà i̱skan. ");
INSERT INTO maaNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús j'iì ìjngoò k'a‑ne Galilea, ko̱ nga'ñó‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá ndaà tíjiìn ini̱ma̱‑la̱; kina'yà‑la̱ i̱t'aà ts'e̱, kóho̱kji nga jngoò itjandiì nangui ts'e̱ Galilea. ");
INSERT INTO maaNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tsakóya ya̱ ni'ya i̱ngo̱ sinagoga xi ts'e̱ na̱xa̱ndá ñánda tsajmeè; ngats'iì xi̱ta̱ xi kiì'nchré 'én‑la̱ ndaà kisìkíjna Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús ijchò Nazaret ya̱ nangui‑la̱ ñánda kòjchá. Jè na̱chrjein nìkjáya, koni s'ín s'ín kjit'aà, jahas'en ni'ya i̱ngo̱ sinagoga. Tsasìjna kixi̱ nga tsibíxke̱ Xo̱jo̱n‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kits'iì‑la̱ xo̱jo̱n‑la̱ Isaías, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá; k'e̱ nga kiskíjnda̱ya jè xo̱jo̱n, kjòtsji‑la̱ ñánda tjít'aà 'én xi tsò: ");
INSERT INTO maaNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Jè Ini̱ma̱ Tsjeè‑la̱ Nainá tíjnako̱‑na nga 'a̱án tsibít'aà‑na xá nga sìka'bí‑la̱ xi̱ta̱ i̱ma̱ 'én ndaà‑la̱ Nainá; 'a̱án kisìkasén‑na nga sìndaà‑na xi̱ta̱ xi kjo̱'on tíjiìn ini̱ma̱‑la̱; ti̱koa̱á koi xá kisìkasén‑na nga 'a̱n kichjàjiìn‑la̱ xi̱ta̱ xi nda̱yá títsa̱jna nga kítsa̱jnandei̱í‑ne; sìndaà‑na jñà xi̱ta̱ xi mìkiì tsejèn‑la̱; kítsa̱jnandei̱í xi̱ta̱ xi tíyatoòn; ");
INSERT INTO maaNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kichjàya jè nó‑la̱ Nainá k'e̱ nga tsjá‑la̱ kjo̱tjò xi̱ta̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tsibíxkóya‑ne xo̱jo̱n, kitsjaà‑la̱ jè xi̱ta̱ xi síchját'aà xá ts'e̱ ni'ya i̱ngo̱ sinagoga, i̱kjoàn tsibìjna. Tà nchikotsejèn‑la̱ ngats'iì xi̱ta̱ xi ya̱ títsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","K'e̱é tsibíts'ia̱ Jesús nga kiìchja̱ kitsò: ―I̱'ndei̱, jyeé kàna'yà‑là nga nguixkoòn kòbitasòn koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá xi 'a̱n kòbìxke̱e. ");
INSERT INTO maaNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ngats'iì xi̱ta̱ ndaà kiìchja̱ i̱t'aà ts'e̱ Jesús. Tà k'oa̱á komà‑la̱ nga 'ñó ndaà tsò 'én xi chja̱. Jñà xi̱ta̱ kitsò‑la̱ xíkjín: ―¿A mìtsà jè jèe̱ xi ki'ndí‑la̱ José? ");
INSERT INTO maaNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","K'e̱é kitsò Jesús: ―Xi o̱kixi̱, jñò, k'oa̱á k'oín‑ná 'én xi tsò: “Chji̱ne̱ xkiì, ti̱ji ti̱xkiì‑la̱ yijo‑lè.” K'oa̱á ti̱s'ín k'oín‑ná: “Koni s'ín kina'yà‑je̱n kjoa̱ xi ki'nì ján Capernaum nga kinìxkiì‑la̱ xi̱ta̱, k'oa̱ ti̱s'ín ti̱xkiì‑la̱ i̱ nangui‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesús kitsò‑ìsa: ―O̱kixi̱í xi xan‑nò, ni̱jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá xi yaxkón ya̱ nangui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ti̱koa̱á o̱kixi̱í xi xan‑nò, kjìn íchjín ka'àn tjín ya̱ Israel jè na̱chrjein ts'e̱ Elías k'e̱ nga jàn nó osen mì ti̱ kiì ts'a‑ne jtsí; j'iì kjinchrá 'ñó kóho̱kji i̱'nde Israel. ");
INSERT INTO maaNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ta̱nga jè Elías mìtsà ya̱ kiì ñánda títsa̱jna íchjín ka'àn ts'e̱ na̱xa̱ndá Israel; ya̱á kinìkasén ñánda tíjna chjo̱ón ka'àn ts'e̱ na̱xa̱ndá Sarepta xi chja̱‑ne Sidón. ");
INSERT INTO maaNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ti̱koa̱á kjìn ma xi̱ta̱ xi tíbindojno chrjoa̱ yijo‑la̱ ya̱ Israel koi na̱chrjein ts'e̱ Eliseo, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. Ta̱nga ni̱jngoò xi xi̱ta̱ Israel kjòndaà‑ne, tà jè ta̱jngoò Naamán xi Siria ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ngats'iì xi̱ta̱ xi ya̱ títsa̱jna ya̱ ni'ya i̱ngo̱ sinagoga, 'ñó kòjti‑la̱ k'e̱ nga kiì'nchré 'én xi kiìchja̱ Jesús nga k'oa̱á s'ín kiskaàya‑la̱ nga kondra̱ ts'e̱‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ngats'iì xi̱ta̱ koi tsasítje̱n, tsachrjejiìn Jesús ya̱ na̱xa̱ndá jè, kiìko̱ i̱sò'nga nindoò ñánda kijna na̱xa̱ndá‑la̱ nga mejèn‑la̱ si̱ìkatje̱n‑ngui na̱xi̱ ñánda nga 'ñó tje̱n‑jen‑jno choòn. ");
INSERT INTO maaNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ta̱nga jè Jesús jahajiìn osen‑la̱ koa̱ kiì. ");
INSERT INTO maaNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús kiì ñánda 'mì Capernaum, na̱xa̱ndá xi chja̱‑ne Galilea; tsakóya‑la̱ xi̱ta̱ k'e̱ nga na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jñà xi̱ta̱, tà k'oa̱á komà‑la̱ koni tsò 'én xi tsakóya, nga jè 'én xi kiìchja̱, tjín‑la̱ kjo̱tíxoma. ");
INSERT INTO maaNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ya̱ ni'ya i̱ngo̱ sinagoga tíjna jngoò xi̱ta̱ xi ini̱ma̱ ch'o‑la̱ nei̱í síxájiìn yijo‑la̱; xi̱ta̱ jè, 'ñó kiìchja̱: ");
INSERT INTO maaNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Jesús xi Nazaret tsi̱ji, kì k'oa̱á nìko̱‑náje̱n. ¿Mé kjoa̱ xi tjín‑lè ko̱ ngaje̱n? ¿Mé‑ne ngaje̱n nìjti‑náje̱n? ¿A kòf'i̱ nìkjehesòn‑náje̱n? Beèxkon‑lè; ji̱‑né xi Xi̱ta̱ Tsjeè‑la̱ Nainá ―kitsò. ");
INSERT INTO maaNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús tsohótiko̱ jè xi̱ta̱ nei̱í: ―¡Jyò ti̱jni, titjo̱jiìn yijo‑la̱ xi̱ta̱ jè! ―kitsò‑la̱. Jè ini̱ma̱ ch'o‑la̱ nei̱í, tsajndoòt'aà nangui nga nguixko̱n ngats'iì xi̱ta̱, i̱kjoàn itjojiìn yijo‑la̱ xi̱ta̱ jè, ta̱nga nì mé xi kisìki'on. ");
INSERT INTO maaNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ngats'iì xi̱ta̱ xi títsa̱jna, tà kitsakjòn‑né; k'e̱é tsohóko̱ xíkjín: ―¿Mé 'én‑ne koi? K'e̱ nga chja̱ xi̱ta̱ jè, tjín‑la̱ nga'ñó ti̱koa̱ tjín‑la̱ kjo̱tíxoma nga síkitasòn‑la̱ ini̱ma̱ ch'o‑la̱ nei̱í ―kitsò. ");
INSERT INTO maaNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesús, kina'yà‑la̱ kóho̱kji nga jngoò itjandiì nangui xi chja̱‑ne Galilea. ");
INSERT INTO maaNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús tsasítje̱n; itjo‑ne ni'ya i̱ngo̱ sinagoga; kiì; jahas'en ni'ya‑la̱ Simón. Jè na̱chíya‑la̱ Simón 'ñó xk'én. Ch'in tìjnga tjín‑la̱. Jñà xi̱ta̱ kiìchja̱tjì nga skótsejèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús tsasìñiat'aà‑la̱, tsohótiko̱ ch'in tìjnga; jè chjo̱ón ni̱to̱ón kjòndaà‑ne. I̱kjoàn tsasítje̱n, kisìs'in‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","K'e̱ nga tíkaàtjì ts'oí, ngats'iì xi̱ta̱ xi tjín‑la̱ xi̱ta̱ xk'én xi kjìn sko̱ya ch'in tjín‑la̱, j'iìko̱ ñánda tíjna Jesús. Jè Jesús tsohót'aà‑la̱ tsja nga jngoò ìjngoò xi̱ta̱ xk'én; ngats'iì xi̱ta̱ koi, kjòndaà yijeé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ti̱koa̱á kjìn ma xi̱ta̱ xi ini̱ma̱ ch'o‑la̱ nei̱í itjokàjiìn yijo‑la̱ nga kjòndaà‑ne. 'Ñó kiìchja̱ ini̱ma̱ ch'o‑la̱ nei̱í: ―¡Ji̱‑né xi Ki'ndí‑la̱ Nainá 'mì‑lè! ―kitsò. Ta̱nga jè Jesús tsohótiko̱. Mìkiì kitsjaà'nde‑la̱ nga kiìchja̱, koií kjoa̱‑la̱ nga jyeé beèxkon nga jè xi Cristo, xi̱ta̱ xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","K'e̱ nga jye kis'e i̱sén, itjo Jesús; kiì jngoò i̱'nde i̱t'aà xìn ñánda tsjìn xi̱ta̱. Jñà xi̱ta̱ tsohótsji ñánda kiì. K'e̱ nga ijchò ñánda tíjna, mejèn‑la̱ nga ya̱ kíjnako̱ nga mì xìn kjoi̱. ");
INSERT INTO maaNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ta̱nga jè Jesús kitsò‑la̱ jñà xi̱ta̱: ―Ti̱koa̱á mochjeén‑né nga xìn na̱xa̱ndá kjíkoa̱a 'én ndaà‑la̱ Nainá koni s'ín otíxoma Nainá. Koií xá kisìkasén‑na Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","K'oa̱á s'ín chja̱ya 'én‑la̱ Nainá kóho̱kji ni'ya i̱ngo̱ sinagoga xi tjín ya̱ nangui‑la̱ xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jesús k'e̱ nga síjna ya̱ i̱ndiì ndáchikon ts'e̱ Genesaret kjòjtínè jñà xi̱ta̱ xi ijchò nga mejèn‑la̱ kji̱'nchré 'én‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús, kijtseè jò chitso xi ya̱ kjioòndiì ya̱ i̱ndiì nandá. Jñà xi̱ta̱ nei‑la̱ xi bíxkóya ti̱n, jyeé itjojen chitso nga nchihoníjno na̱'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús jahas'en jngoò chitso xi ts'e̱ Simón, tsibítsi'ba‑la̱ nga ski̱nìkjá‑ìsa chitso‑la̱ ya̱ i̱jiìn ndáchikon. I̱kjoàn tsibìjnaya nga tsakóya‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","K'e̱ nga jye tsakóya‑la̱ xi̱ta̱, kitsò‑la̱ Simón: ―Tikoi̱i chitso‑lè ñánda nga ìsa̱ 'ñó na̱nga̱ nandá; i̱kjoàn ti̱katje̱n‑ngui‑ndá na̱'ya‑nò mé‑ne nga kíxkóya‑nò ti̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón kiìchja̱ kitsò: ―Maestro, kànìk'a‑náje̱n ni̱tje̱n nga kànìxá‑je̱n, ni̱mé xi kàsakó‑naje̱n; ta̱nga tsà ji̱ xi o̱si nga siìkatje̱n‑ngui‑ndá na̱'ya‑na̱, ko̱ma‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","K'e̱ nga ìjngoò k'a kisìkatje̱n‑ngui‑ndá na̱'ya‑la̱, kjìn jchán ti̱n tsibíxkóya, tsí mejèn xajndà na̱'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","K'e̱é kisìkatjiì‑la̱ tsja xíkjín nga kiìchja̱‑la̱ jñà xi̱ta̱ xi títsa̱ya chitso xi ìjngoò mé ne nga kisìchját'aà‑la̱. Ingajò chitso jngoò k'a kitseè ti̱n. Mejèn tsà bixòngui‑ndá nga 'ñó i'í komà. ");
INSERT INTO maaNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jè Simón xi ti̱koa̱ Pedro 'mì, k'e̱ nga kijtseè kjoa̱ koi, tsasèn‑xkó'nchit'aà‑la̱ Jesús, kitsò‑la̱: ―¡Ti̱si̱t'aàxìn‑ná Na̱'èn, 'a̱n xi̱ta̱ jé‑ná! ");
INSERT INTO maaNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jè Simón ko̱ xi̱ta̱ xíkjín xi ta̱ña síxákjoò, tà kjòxkón‑la̱ nga 'ñó kjìn ti̱n kjòxkóya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ti̱koa̱á tà kjòxkón‑la̱ jè Jacobo ko̱ Juan, i̱xti‑la̱ Zebedeo, jñà xi̱ta̱ xi ta̱ña síxákjoò Simón. Jesús kitsò‑la̱ Simón: ―Kì tsakjoòn‑jèn, i̱'ndei̱ mì ti̱ kiì ti̱n kíxkóya‑ne, xi̱ta̱á kíxkóyi xi i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","K'e̱ nga jye kiìko̱‑ne chitso‑la̱ ya̱ i̱ndiì ndáchikon, ya̱á kitsjeiìn‑takòn yije tsojmì‑la̱, i̱kjoàn kiìtji̱ngui‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús k'e̱ nga tsibìjna jngoò na̱xa̱ndá, ijchò jngoò xi̱ta̱ x'i̱n xi tíbindojno chrjoa̱ yijo‑la̱; nga kijtseè Jesús, tsohojna‑ñiat'aà nangui nga kijtseèxkón Jesús, tsibítsi'ba‑la̱, kitsò‑la̱: ―Na̱'èn, tsà mejèn‑lè, ti̱tsjeè‑ná ch'in xi tjín‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús tsijmeé tsja nga tsohót'aà‑la̱ yijo‑la̱ xi̱ta̱ jè, kitsò‑la̱: ―Mejèn‑na; ¡kàtandaà‑ne! Xi̱ta̱ jè, ni̱to̱ón kjòndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jè Jesús kitsò‑la̱: ―Kì yá xi̱ta̱ xi bèno̱jmí‑la̱; t'in ñánda tíjna no̱'miì; ta̱kó‑la̱ yijo‑lè nga jye kjòndaà‑ne; tjiì‑la̱ kjo̱tjò xi síjé kjo̱tíxoma‑la̱ Moisés mé‑ne nga tsjeè kijna‑ne nguixko̱n Nainá ti̱koa̱ skoe̱ jñà xi̱ta̱ nga jye kjòndaà‑ne ch'in‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ta̱nga Jesús, ìsa̱á 'ñó kina'yà‑ìsa‑la̱; ko̱ ìsa̱á kjìn xi̱ta̱ kjòxkóya xi mejèn‑la̱ nga kji̱'nchré‑la̱; ti̱koa̱ mejèn‑la̱ nga ko̱ndaà‑ne ch'in xi tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ta̱nga Jesús xìn i̱'nde fì ñánda tsjìn xi̱ta̱ nga chja̱t'aà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jngoò na̱chrjein k'e̱ nga tíhokóya‑la̱ xi̱ta̱ Jesús, ya̱ títsa̱jnajiìn xi̱ta̱ fariseo ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. Xi̱ta̱ koi, ján inchrobà‑ne na̱xa̱ndá xi chja̱‑ne Galilea, Judea ko̱ Jerusalén. Jesús ya̱ tíjnajiìn ini̱ma̱‑la̱ nga'ñó‑la̱ Nainá nga si̱ìndaà‑ne ngats'iì xi̱ta̱ xi xk'én. ");
INSERT INTO maaNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","J'iìko̱ jngoò xi̱ta̱ xk'én xi mìkiì ma síhiníyá yijo‑la̱; kjiya‑la̱ na̱chan‑yá. Tsohótsji'nde‑la̱ kó s'ín si̱ìkas'en xotjoa̱ ni'ya ya̱ ñánda tíjna Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ta̱nga mìkiì komà jahas'en ni'ya nga 'ñó kjìn xi̱ta̱ títsa̱jna; k'e̱é tsijin i̱sò'nga ni'ya; jaàxìn nitja; kiskinìjen‑jiìn‑la̱ xi̱ta̱ koni s'ín kjiya na̱chan‑yá‑la̱ jè xi̱ta̱ xk'én. Ya̱á tsohójna nguixko̱n ñánda tíjna Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús k'e̱ nga kijtseè nga mokjeiín‑la̱ i̱t'aà ts'e̱, kitsò‑la̱ jè xi̱ta̱ xk'én: ―Ngaji̱, jyeé kàchàat'aà‑lè jé‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jñà xi̱ta̱ fariseo ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés tsohóko̱ ini̱ma̱‑la̱, kitsò: “Xi̱ta̱ jè, chja̱jno‑la̱ Nainá koni s'ín tsò. ¿Yá‑né jè nga ma‑la̱ síjchàat'aà‑ná jé‑ná? Ta̱jngoò Nainá xi síjchàat'aà‑ná jé‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús kijtseèya‑la̱ koni s'ín nchisíkítsjeèn; kiìchja̱, kitsò‑la̱: ―¿Mé‑ne ko̱tsò‑ne ini̱ma̱‑nò? ");
INSERT INTO maaNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Mé xi ìsa̱ chiba 'in tjín, tsà xán‑la̱ jè xi̱ta̱ xi xk'én: “Jé‑lè jyeé kichàat'aà‑lè”, ko̱ tsà xán‑la̱: “Ti̱sítji̱in koa̱ ti̱tjeí”? ");
INSERT INTO maaNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kokoò‑nò nga 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, tjí'nde‑na nga sìjchàat'aà‑la̱ jé‑la̱ xi̱ta̱ i̱ i̱sò'nde. Jè Jesús k'e̱é kitsò‑la̱ jè xi̱ta̱ xi mìkiì ma síkjaníyá: ―Ji̱, k'oa̱á xan‑lè, ti̱sítji̱in, chjoí na̱chan‑lè, t'in‑ne ni'ya‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jè xi̱ta̱ xk'én ni̱to̱ón tsasítje̱n nga nguixko̱n ngats'iì xi̱ta̱ xi ya̱ títsa̱jna; kiskoé na̱chan‑la̱ xi kijnasòn; k'e̱ nga tífì‑ne ni'ya‑la̱, jeya chja̱t'aà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ngats'iì xi̱ta̱ xi ya̱ títsa̱jna tà kjòxkón‑la̱, ti̱koa̱á jeya kiìchja̱t'aà‑la̱ Nainá. Tsakjón‑ko̱‑ne, kitsò: ―I̱'ndei̱ kàyaxkon jngoaá kjo̱xkón. ");
INSERT INTO maaNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","K'e̱ nga jye o̱s'ín komà kjoa̱ koi, itjo Jesús, kiì; k'e̱é kijtseè jngoò xi̱ta̱ xi 'mì Leví, xi̱ta̱‑la̱ xi̱ta̱xá Roma xi síkíchjítjì tsojmì. Tíjnat'aà ími̱xa̱ ya̱ ñánda síkíchjítjì tsojmì ts'e̱ Roma. Jesús kitsò‑la̱: ―Nchrobátji̱ngui‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leví, tsasítje̱n; kisìkítsa̱jna yije tsojmì xi tjín‑la̱; kiìtji̱ngui‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leví, ya̱ ni'ya‑la̱, tsí ndaà kis'iìn‑la̱ s'eí Jesús. Ti̱koa̱á kjìn xi̱ta̱ xíkjín títsa̱jna xi ti̱koa̱ tsojmì síkíchjítjì, ko̱ xi̱ta̱ xi kj'ei̱í; títsa̱t'aà ími̱xa̱. ");
INSERT INTO maaNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jñà xi̱ta̱ fariseo ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés tsatít'aà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, kitsò‑la̱: ―¿Mé‑ne jñà xi̱ta̱ xi síkíchjítjì tsojmì, ko̱ xi tjín‑la̱ jé, 'yò‑ko̱o koa̱ bichi‑ko̱o? ");
INSERT INTO maaNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","K'e̱é kiìchja̱ Jesús kitsò: ―Jñà xi̱ta̱ xi mìtsà ch'in tjín‑la̱ mìtsà chji̱ne̱ xkiì mochjeén‑la̱, tà jñà xi̱ta̱ xi xk'én xi mochjeén‑la̱ chji̱ne̱ xkiì. ");
INSERT INTO maaNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mìtsà koi xá j'i̱‑na 'a̱n nga j'i̱kjaàjñaà xi̱ta̱ kixi̱, jñà‑né xi̱ta̱ xi tjín‑la̱ jé nga kàtasíkájno jé‑la̱ nga mì ti̱ jé ko̱hótsji‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jñà xi̱ta̱ kitsò‑la̱ Jesús: ―¿Mé‑ne jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Juan tsí ndaà bìtsa̱jnachjan ti̱koa̱ tsí ndaà bítsi'ba; k'oa̱á ti̱s'ín jñà xi̱ta̱ fariseo; ta̱nga jñà xi̱ta̱ tsi̱ji, kjèn‑né koa̱ 'biì‑né? ");
INSERT INTO maaNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús kitsò‑la̱: ―K'e̱ nga bixan jngoò xi̱ta̱, ¿a ko̱maá si̱kítsa̱jnachjaán xi̱ta̱ xi báhijtako̱‑ná k'e̱ nga tákó tíjna xi̱ta̱ x'i̱n xi kòbixan? ");
INSERT INTO maaNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ta̱nga ki̱jchò na̱chrjein nga tjáxìn‑la̱ x'i̱n xi kòbixan, k'e̱‑né nga kítsa̱jnachjan xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ti̱koa̱á tsibéno̱jmí jngoò‑la̱ 'én xi mangásòn nga tsakóya‑la̱ nga jñà kjo̱tíxoma jchínga, mìkiì sasén‑la̱ xi kjo̱tíxoma xi̱tse̱. Kitsò‑la̱: ―Mìtsà yá xi ote chiba nikje xi̱tse̱ nga bíjto‑ne ko̱ nikje i̱baà. Tsà ko̱s'ín s'e̱en ki̱ts'ón nikje xi̱tse̱; ti̱koa̱á mìkiì ndaà ko̱ngásòn nikje xi̱tse̱ ko̱ nikje i̱baà. ");
INSERT INTO maaNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ti̱koa̱á mìtsà yá xi binchá xán ixiì chrjoa̱ jchínga; tsà ko̱s'ín s'e̱en, k'e̱ nga jye ko̱jchá xán, si̱ìxajndà chrjoa̱ jchínga, i̱kjoàn xíxteèn xán; ti̱koa̱á chi̱ja jè chrjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jè xán ixiì, chrjoa̱ xi̱tse̱é sinchá mé‑ne nga ndaà si̱nchátjò‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tsà yá xi skoí xán jchínga xi kjòtseé jncha, mìkiì ni̱to̱n si̱ìjé ìjngoò k'a xi xán ixiì. Ki̱tso̱‑né: “Jè xán jchínga, ìsa̱á ndaà.” ");
INSERT INTO maaNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jngoò k'a jè na̱chrjein nìkjáya, ja Jesús ñánda títje̱ trigo. Xi̱ta̱ xi kota'yàt'aà‑la̱ tsate natín‑la̱ trigo, tsafèya‑ne tsja, i̱kjoàn kiskine. ");
INSERT INTO maaNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tjín i'nga xi̱ta̱ fariseo xi kitsò: ―¿Mé‑ne ko̱'nè‑enò jè kjoa̱ xi mìkiì tjí'nde nga ko̱s'ín ko̱ma jñà na̱chrjein nìkjáya? ");
INSERT INTO maaNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kiìchja̱ Jesús, kitsò‑la̱: ―¿Jñò, a mìtsà jye tíjiìn‑nò koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá koni kis'iìn xi̱ta̱xá ítjòn xi ki'mì David ko̱ jñà xi̱ta̱‑la̱ xi kjihijtako̱ k'e̱ nga kjòhojò‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jahas'en ni'ya‑la̱ Nainá; kiskoé i̱nchra̱jín tsjeè‑la̱ Nainá; tsakjèn. Ti̱koa̱ kitsjaà‑la̱ xi̱ta̱‑la̱ xi tji̱ko̱. Mìkiì tjí'nde nga jñà ko̱kje̱n. Tà jñà no̱'miì tjí'nde‑la̱ nga ko̱kje̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesús kitsò‑ìsa‑la̱: ―'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, 'a̱án otiìxoma‑la̱ na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ìjngoò k'a k'e̱ nga jè na̱chrjein nìkjáya, Jesús jahas'en ni'ya i̱ngo̱ sinagoga; tsibíts'ia̱ nga tsakóya‑la̱ xi̱ta̱. Koa̱ ya̱á tíjna jngoò xi̱ta̱ xi kixìt'aà tsja kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jñà xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés ko̱ xi̱ta̱ fariseo nchisíkinda̱ Jesús kó s'i̱in, a si̱ìndaá‑ne jè xi̱ta̱ xi xk'én jè na̱chrjein nìkjáya; mejèn‑la̱ nga skoe̱ mé‑ne nga ko̱ma ko̱hòngui‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ta̱nga Jesús jyeé tíjiìn‑la̱ kó s'ín nchisíkítsjeèn jñà xi̱ta̱ koi. Kitsò‑la̱ jè xi̱ta̱ xi kixìt'aà tsja: ―Ti̱sítji̱in, ti̱si̱jna kixi̱ ya̱ jngoò osen. Xi̱ta̱ jè tsasítje̱n, tsasìjna kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús, k'e̱é kitsò‑la̱ ngats'iì xi̱ta̱ xi ya̱ títsa̱jna: ―Jngoò kjoa̱ skònangui‑nò: ¿A tjí'nde‑né k'e̱ nga jè na̱chrjein nìkjáya nga ndaà s'e̱én, o xi ch'o s'e̱én? ¿A si̱k'en‑ná o xi si̱ndaá‑ná jngoò xi̱ta̱? ");
INSERT INTO maaNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús kiskoòtsejèn yije‑la̱ kóho̱tjín xi̱ta̱ xi ya̱ títsa̱jnandiì‑la̱. K'e̱é kitsò‑la̱ jè xi̱ta̱ xi kixìt'aà tsja: ―Tjeèndojoì ndsei̱i. Xi̱ta̱ jè, tsijmeé tsja, ni̱to̱ón kjòndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jñà xi̱ta̱ fariseo, 'ñó jti komà‑la̱; k'e̱é tsibíts'ia̱ nga tsajoóya‑ne mé xi si̱ìko̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ti̱jñà‑ne na̱chrjein koi, Jesús kiìmijìn‑jno jngoò nindoò nga kiìchja̱t'aà‑la̱ Nainá; kisìk'a ni̱tje̱n nga tíchja̱t'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","K'e̱ nga kis'e i̱sén kiìchja̱‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱; i̱kjoàn jaàjiìn tejò xi̱ta̱ xi tsibíxáya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jè Simón xi ti̱koa̱ Pedro tsibít'aà 'ín; Andrés xi 'ndse̱ ma Simón; Jacobo; Juan; Felipe; Bartolomé; ");
INSERT INTO maaNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo; Tomás; Jacobo, ti‑la̱ Alfeo; Simón xi ya̱ fìt'aà‑la̱ kjo̱tíxoma ts'e̱ xi̱ta̱ Celote; ");
INSERT INTO maaNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, ti‑la̱ Jacobo; ko̱ Judas Iscariote, jè xi i̱skan komà kondra̱‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús itjojen‑jno‑ne nindoò, tji̱ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱; j'iì jngoò i̱'nde ñánda i̱sòn choòn; ya̱á tsibìtsa̱jna. Kjìn ma xi̱ta̱‑la̱ xi ya̱ nchikoña‑la̱; ti̱koa̱á kjìn ma xi̱ta̱ xi kj'ei̱í xi inchrobà‑ne kóho̱kji i̱'nde Judea ko̱ na̱xa̱ndá Jerusalén ko̱ xi inchrobà‑ne Tiro ko̱ Sidón, na̱xa̱ndá xi kjiyijòndiì ndáchikon. Koi xá j'iì‑ne nga kji̱'nchré‑la̱ Jesús, ti̱koa̱ mejèn‑la̱ ko̱ndaà‑ne ch'in xi tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jñà xi̱ta̱ xi ini̱ma̱ ch'o‑la̱ nei̱í síjti‑la̱, ti̱koa̱á kjòndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ngats'iì xi̱ta̱, mejèn‑la̱ nga ko̱òt'aà‑la̱ tsja yijo‑la̱ Jesús nga tseé nga'ñó tíbitjojiìn yijo‑la̱ nga mandaà yije‑ne xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús kiskoòtsejèn‑'a xi̱ta̱ xi kota'yàt'aà‑la̱ kitsò‑la̱: ―Mé tà ndaà‑anò jñò xi xi̱ta̱ i̱ma̱ 'mì‑nò, nga tsa̱jòn‑nó jñà kjo̱ndaà xi tsjá Nainá nga jè tíhotíxoma. ");
INSERT INTO maaNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Mé tà ndaà‑anò jñò xi ijò‑nò i̱'ndei̱, nga ko̱ma i̱skan, ko̱skiì‑nò. ’Mé tà ndaà‑anò jñò xi chìhindáya i̱'ndei̱, nga ko̱ma i̱skan ki̱jno̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Mé tà ndaà‑anò k'e̱ nga tjín xi̱ta̱ xi síjtikeè‑nò tà 'a̱n nga̱tjì‑na xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱; k'e̱ nga síkítsa̱jnat'aàxìn‑nò, k'e̱ nga chja̱'on‑ko̱‑nò, k'e̱ nga ochrjekàngui‑nò koni tsà jngoò xi̱ta̱ xi 'ñó ts'e̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tsja t'è‑là takòn jè na̱chrjein koi; ti̱tsja‑là ini̱ma̱‑nò; tseé kjo̱ndaà tjoé‑nò ján ngajmiì; ti̱koa̱á jñà xi̱ta̱ jchínga‑la̱ xi̱ta̱ xi beètoòn‑nò, k'oa̱á ti̱s'ín kijtseètoòn jñà xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Ta̱nga i̱ma̱‑xó‑nò jñò xi xi̱ta̱ nchi̱ná 'mì‑nò nga tjín yije‑nò xi mochjeén‑la̱ yijo‑nò ta̱nga mìkiì nìkítsjeèn kjo̱ndaà‑la̱ Nainá xi mochjeén‑la̱ ini̱ma̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’I̱ma̱‑xó‑nò xi skiì titsa̱jnaà i̱'ndei̱; k'e̱ nga ko̱ma i̱skan, ko̱hojò‑nò. ’I̱ma̱‑xó‑nò jñò xi bijnò i̱'ndei̱; k'e̱ nga ko̱ma i̱skan ko̱baá‑nò koa̱ jchìhindáya‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’I̱ma̱‑xó‑nò jñò k'e̱ nga ndaà síkítsa̱jna yije‑nò xi̱ta̱. Jñà xi̱ta̱ jchínga k'oa̱á ti̱s'ín ndaà kisìkítsa̱jna jñà xi̱ta̱ xi 'én ndiso kiìchja̱ya. ");
INSERT INTO maaNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Ta̱nga jñò xi titsa̱na'yà, k'oa̱á xán‑nò: Ti̱tsjacha kondra̱‑nò, ndaà ti̱ko̱o jè xi jtikeè‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ti̱jét'aà‑là Nainá nga kàtasíchikon‑t'in jñà xi chja̱'on‑ko̱‑nò, titsi'batjiò jè xi ch'o síko̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jè xi síjts'iìn‑t'aà kjioòn, ti̱koa̱ tjiì‑là xi ngobà; jè xi faá'an na̱chro̱kisòn‑nò, ti̱koa̱ tjiì‑là na̱chro̱‑nò xi ìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ni̱ta̱ yá xi̱ta̱ xi síjé‑nò tsojmì, tjiì‑là; tsà yá xi skoé xi tsojmì tsa̱jòn, kì ti̱ kiì nìjé‑là. ");
INSERT INTO maaNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Koni s'ín mejèn‑nò nga si̱ìko̱‑nò xi̱ta̱, k'oa̱á ti̱s'ín ti̱ko̱ ngajo‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tsà matsjacha jè xi matsjakeè‑nò, ni̱mé kjo̱ndaà xi s'e̱‑nò, nga k'oa̱á ti̱s'ín jñà xi̱ta̱ ts'e̱n, matsjakeè xíkjín. ");
INSERT INTO maaNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tsà tà jñà ndaà siko̱ò xi̱ta̱ xi ti̱koa̱ ndaà síko̱‑nò, ni̱mé kjo̱ndaà xi s'e̱‑nò. Jñà xi̱ta̱ ts'e̱n, k'oa̱á ti̱ síko̱ xíkjín. ");
INSERT INTO maaNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tsà si̱kìña‑là jè xi yaxkoòn nga koi̱ìchjí, ti̱koa̱á ni̱mé kjo̱ndaà s'e̱‑nò. Ti̱koa̱á jñà xi̱ta̱ ts'e̱n síkìña‑la̱ xíkjín nga jyeé tíjiìn‑la̱ nga koi̱ìchjí yije kóho̱tjín. ");
INSERT INTO maaNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ti̱tsjacha kondra̱‑nò; ndaà ti̱ko̱o; ti̱kìña‑là mé xi síjé‑nò, ni̱mé xi chiñà‑là i̱t'aà ts'e̱. Tsà ko̱s'ín s'e̱en, ìsa̱á tse kjo̱ndaà s'e̱‑nò. I̱xti‑la̱ Nainá xi 'ñó 'nga tíjna ko̱maà k'e̱ nga k'oa̱s'ín s'e̱en koni s'ín Nainá, nga tjín‑la̱ kjo̱hi̱ma̱takòn i̱t'aà ts'e̱ xi̱ta̱ xi 'nga ikon ko̱ xi ch'o s'ín. ");
INSERT INTO maaNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Chahi̱ma̱a xinguio̱o koni s'ín beèhi̱ma̱‑nò Nainá xi Na̱'èn‑ná 'mì‑là. ");
INSERT INTO maaNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Kì jé‑la̱ xinguio̱o 'nè kinda̱a mé‑ne nga Nainá ti̱koa̱ mìkiì si̱ìkinda̱ jé‑nò; kì jé binchanè‑là xinguio̱o mé‑ne nga Nainá mì jé ki̱nchanè‑nò; ti̱jchàat'aà‑là jé‑la̱ xinguio̱o mé‑ne nga Nainá ti̱koa̱ si̱ìjchàat'aà‑nò jé‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tjiì‑là xinguio̱o; jè Nainá tsjá ngajo‑nò; Nainá si̱ìchi̱ba̱‑nò chi̱ba̱ xi ndaà kitseè, xi 'ñó jncha, xi ndaà kisitsajneè ko̱ xi tíxíxteèn‑tjì nga ki̱ncha chijtsa‑nò; jè chi̱ba̱ xi si̱chi̱ba̱ya‑là xinguio̱o, ti̱jè si̱ìchi̱ba̱ya ngajo‑nò Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús tsibéno̱jmí jngoò‑la̱ kjoa̱ xi mangásòn, kitsò‑la̱: ―Jngoò xi̱ta̱ xi mìkiì tsejèn‑la̱, mìkiì ko̱ma ko̱kò‑la̱ ndi̱yá ìjngoò xi ti̱koa̱ mìkiì tsejèn‑la̱. Ingajò, ya̱á ki̱xo̱ya nga̱jo̱ ñánda ch'o choòn. ");
INSERT INTO maaNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jngoò xi̱ta̱ xi kota'yà mìtsà ìsa̱ 'nga tíjna koni maestro‑la̱; ta̱nga k'e̱ nga kjoe̱het'in‑la̱ nga ndaà skóta'yà, ti̱koa̱á ko̱ngásòn‑né koni jè maestro‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Mé‑ne jé‑la̱ xingui̱i nìkinda̱‑ne koa̱ tsi̱ji mìkiì nìkindi̱i? ¿Mé‑ne chìtsejèn‑la̱ tjé xi kjinangui xko̱n xingui̱i, koa̱ jè yá chi̱so̱ xi kjinangui xkoiìn mìkiì chìtsejèn‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿A mì 'ya‑jèn yá chi̱so̱ xi kjinangui xkoiìn? ¿Mé‑ne ko̱'mì‑la̱ xingui̱i: “'Ndsè, tjiì'nde‑ná nga kochrjekànguia tjé xi kjinangui xkoiìn”? Ngaji̱ xi jò ma i̱sén‑lè; ítjòn ti̱nachrjekàngui chi̱so̱ xi kjinangui xkoiìn, mé‑ne nga ndaà ko̱tsejèn‑lè, i̱kjoàn ti̱nachrjekàngui tjé xi kjinangui xko̱n xingui̱i. ");
INSERT INTO maaNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Tsjìn yá xi ndaà kjoàn ko̱ ch'o kjoàn toò xi ojà‑la̱; ti̱koa̱á tsjìn yá xi ch'o kjoàn ko̱ ndaà kjoàn toò xi ojà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nga jngoò ìjngoò sko̱ya yá, k'oa̱á s'ín yaxkon‑la̱ koni kjoàn toò xi ojà‑la̱. Jè toò iko̱, mìtsà yá na'yá ojà‑la̱. Ti̱koa̱á jñà toò uva mìtsà na'yá xanchroò ojà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Koni kjoàn yá, k'oa̱á ti̱ kjoàn xi̱ta̱; jngoò xi̱ta̱ xi 'én ndaà chja̱, koií‑né nga kjo̱ndaà tíjiìn ini̱ma̱‑la̱; koa̱ jngoò xi̱ta̱ xi 'én ts'e̱n chja̱, koií‑né nga kjoa̱ts'e̱én tíjiìn ini̱ma̱‑la̱; nga̱ k'oa̱á tsò 'én xi nokjoá koni tsò kjo̱hítsjeèn xi tíjiìn ini̱ma̱‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Mé‑ne ko̱s'ín 'mì‑ná nga bixón: “Na̱'èn, Na̱'èn”, koa̱ mìkiì nìkitasòn koni xan‑nò? ");
INSERT INTO maaNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","K'oa̱á xan‑nò yá xi mangásòn jè xi̱ta̱ xi 'a̱n fìt'aà‑na, xi 'nchré 'én‑na̱, ti̱koa̱ síkitasòn. ");
INSERT INTO maaNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jè mangásòn jngoò xi̱ta̱ xi bíndaà ni'ya‑la̱; 'ñó na̱nga̱ ò'nguiì; bíjna tàts'en chrjó ni'ya ya̱ i̱sòn na̱xi̱. K'e̱ nga 'ba jtsí xkón, f'iì xa̱jngá nandá, kaàt'aà'ñó‑la̱ ni'ya; ni̱mé xi síko̱ nga ya̱ tjíndaàsòn na̱xi̱. ");
INSERT INTO maaNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ta̱nga jè xi 'nchré 'én‑na̱ koa̱ mìkiì síkitasòn, k'oa̱á ngaya‑la̱ koni jngoò xi̱ta̱ xi bíndaàsòn ni'ya‑la̱ ñánda tà nangui; mìkiì ndaà bíndaà tàts'en chrjó; f'iì xa̱jngá nandá, kaàt'aà'ñó‑la̱ ni'ya; ya̱á bixòña ni'ya jè; jngoò k'a bixòjen. ");
INSERT INTO maaNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús, k'e̱ nga jye tsakóya‑la̱ xi̱ta̱ na̱xa̱ndá xi nchi'nchré 'én‑la̱, kiì, jahas'en‑jiìn na̱xa̱ndá Capernaum. ");
INSERT INTO maaNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ya̱ tíjna jngoò soldado ítjòn. Jè chi̱'nda‑la̱, 'ñó xk'én. Kjo̱meè biyaà. Ta̱nga 'ñó tjòkeè. ");
INSERT INTO maaNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","K'e̱ nga kiì'nchré xi̱ta̱ jè i̱t'aà ts'e̱ Jesús, kisìkasén xi̱ta̱ jchínga xi ts'e̱ xi̱ta̱ judío nga kiì kítsi'ba‑la̱ Jesús mé‑ne nga kàtjanchrobá, kàtasíxkiì‑la̱ jè chi̱'nda‑la̱ xi xk'én. ");
INSERT INTO maaNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jñà xi̱ta̱ jchínga, k'e̱ nga ijchòkon Jesús 'ñó tsibítsi'ba‑la̱, kitsò‑la̱: ―Ok'ín‑la̱ nga si̱chját'aà‑la̱ xi̱ta̱ ítjòn jè. ");
INSERT INTO maaNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tsjakeè na̱xa̱ndá xi chja̱‑ne Judea, koa̱ jè tsibíndaà jngoò‑ná ni'ya i̱ngo̱ sinagoga i̱ na̱xa̱ndá‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús kiìko̱ jñà xi̱ta̱ jchínga koi, ta̱nga k'e̱ nga jye kjo̱meè bijchó chrañàt'aà‑la̱ ni'ya, jè xi̱ta̱ ítjòn‑la̱ soldado kisìkasén i'nga amigo‑la̱ nga kitsò‑la̱ Jesús: ―Na̱'èn, kì yijo‑lè nìjti‑la̱. 'A̱n, mìkiì ok'ìn‑na nga ngaji̱ k'oín sobì ni'ya‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ti̱koa̱á mìkiì ok'ìn‑na nga 'a̱n kòfìkon sobà‑lè. Ta̱nga tjiì o̱kixi̱ nga kàtandaà‑ne chi̱'nda‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","'A̱n, tíjiìn‑na nga tjín‑lè kjo̱tíxoma. Ti̱koa̱á 'a̱n, tjín‑na xi̱ta̱ ítjòn xi otíxoma‑na, ti̱koa̱á tjín‑na soldado xi 'a̱n otiìxoma‑la̱, k'e̱ nga xan jngoò‑la̱: “T'in”, fì‑né; xan‑la̱ xi ìjngoò: “Nchroboí”, nchrobá‑né; koa̱ k'e̱ nga xan‑la̱ jè xi chi̱'nda‑na̱: “K'oa̱ t'i̱in”, síkitasòn‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","K'e̱ nga kiì'nchré Jesús jñà 'én koi, tà kjòxkón‑la̱. K'e̱é kiskoòtsejèn‑'a jñá xi̱ta̱ xi tji̱ngui‑la̱; kitsò‑la̱: ―K'oa̱á xan‑nò, ya̱ Israel, ni̱ saà jngoò xi̱ta̱ sakó‑na xi ko̱s'ín ndaà mokjeiín‑la̱ koni jè xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jñà xi̱ta̱ xi kiìkjaá Jesús, k'e̱ nga j'iì‑ne, jè chi̱'nda xi xk'én, jyeé kjòndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nga komà i̱skan Jesús kiì jngoò na̱xa̱ndá xi 'mì Naín. Tji̱ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱, ti̱koa̱á kjìn xi̱ta̱ xi tà xi̱ta̱ na̱xa̱ndá tji̱ngui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","K'e̱ nga jye ijchò chrañà i̱jto xotjoa̱ na̱xa̱ndá, kjìn ma xi̱ta̱ na̱xa̱ndá xi kjihijtako̱ chjo̱ón ka'àn nga nchifì kíhijiìn jngoò mik'en xi ti ta̱ jngoò‑la̱ jè chjo̱ón ka'àn. ");
INSERT INTO maaNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na̱'èn‑ná Jesucristo, k'e̱ nga kijtseèxkon, kjòhi̱ma̱keè; kitsò‑la̱ chjo̱ón ka'àn: ―Kì chìhindáya‑jèn. ");
INSERT INTO maaNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kiì kasìt'aà chrañà‑la̱ jè kaxa̱ mik'en, tsohósòn‑la̱ tsja; jñà xi̱ta̱ xi yangui mik'en chinchako̱. Kitsò Jesús: ―Ngaji̱ ti, k'oa̱á xán‑lè: ¡Ti̱sítji̱in! ");
INSERT INTO maaNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jè mik'en ni̱to̱ón tsibìjna kixi̱; i̱kjoàn kiìchja̱. Jesús, k'e̱é kisìnga̱tsja nea̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ngats'iì xi̱ta̱ xi tji̱ko̱, tà kitsakjòn‑né; k'e̱é jeya kisìkíjna Nainá kitsò: ―Jngoò xi̱ta̱ tíjnako̱‑ná xi 'ñó ndaà chja̱ ngajo‑la̱ Nainá. Ti̱koa̱á tjín xi kitsò: ―Nainá j'iì kasìko̱ na̱xa̱ndá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jñà 'én koi, kina'yà‑la̱ kóho̱kji nangui Judea, ngats'iì i̱'nde nga jngoò itjandiì nangui Judea. ");
INSERT INTO maaNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan xi kis'iìn bautizar xi̱ta̱ kiì'nchré yije kjoa̱ xi tís'ín Jesús; jñà xi̱ta̱ xi kota'yàt'aà‑la̱ tsibéno̱jmí‑la̱. K'e̱é kiìchja̱ jò‑la̱ xi xi̱ta̱ ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kisìkasén ñánda tíjna Jesús nga sko̱nangui‑la̱, ¿a jè‑né xi Cristo xi tjínè‑la̱ nga kjoi̱í a xi kj'ei̱í chíña‑lá? ");
INSERT INTO maaNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jñà xi̱ta̱‑la̱ Juan, k'e̱ nga ijchòkon Jesús, kitsò‑la̱: ―Jè Juan kàsíkasén‑naje̱n xi i̱t'aà tsi̱ji nga chji̱nangui‑lèje̱n, ¿a ji̱‑né xi Cristo xi tjínè‑lè nga kjoi̱i a xi kj'ei̱í chíña‑la̱je̱n? ");
INSERT INTO maaNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ti̱jè‑ne hora, Jesús, kjìn xi̱ta̱ kisìndaà‑ne xi xk'én, xi kjo̱'in nchisíkjeiín, xi ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱; ti̱koa̱á kjìn xi̱ta̱ xi mìkiì tsejèn‑la̱ kjòndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesús kitsò‑la̱ jñà xi̱ta̱ xi ijchòkon: ―Tanguió tèno̱jmí‑là Juan jñà kjoa̱ xi kà'yaà ko̱ xi kàna'yà. Jñà xi̱ta̱ xi mìkiì tsejèn‑la̱, jyeé tsejèn‑la̱; jñà xi tsá'yá kjoàn, jyeé ma fì‑ne; jñà xi tíbindojno chrjoa̱ yijo‑la̱, tímatsjeèjnoó‑ne yijo‑la̱; jñà xi̱ta̱ xi jtayaà, jyeé 'nchré‑ne; ko̱ xi̱ta̱ xi jye k'en, nchifaáyaá‑la̱; koa̱ jñà xi̱ta̱ i̱ma̱, jye tís'eno̱jmí‑la̱ 'én ndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Mé tà ndaà‑la̱ jè xi̱ta̱ xi nguì jngoò k'a ndaà mokjeiín‑la̱ i̱t'aà ts'a̱n nga ni̱mé xi osìjna‑ikòn‑la̱! ");
INSERT INTO maaNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","K'e̱ nga jye kiì‑ne xi̱ta̱ xi kisìkasén Juan, tsibíts'ia̱ Jesús nga tsohóko̱ xi̱ta̱ xi i̱t'aà ts'e̱ Juan, kitsò‑la̱: ―¿Mé xi tsanguì chìtsejèn‑là ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn? ¿A jè tsanguì chìtsejèn‑là jngoò yá ína̱xo̱ xi síjtìya‑la̱ tjo̱? ");
INSERT INTO maaNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Mé‑né xi tsanguì chìtsejèn‑là? ¿A jngoò xi̱ta̱ xi 'ñó ndaà kji nikje‑la̱? Jñò, jyeé 'yaà, jñà xi ndaà kjoàn nikje xi ókjá, xi ti̱koa̱ 'ñó ndaà kjoàn tsojmì xi tjín‑la̱, ya̱á títsa̱ya ni'ya‑la̱ xi̱ta̱xá ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ta̱nga, ¿mé xi tsanguì chìtsejèn‑là? ¿A jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá? O̱kixi̱‑né, k'oa̱á xan‑nò, Juan, ìsa̱á 'ñó ndaà koni jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","I̱t'aà ts'e̱ Juan, ya̱á tíchja̱ Xo̱jo̱n‑la̱ Nainá nga tsò: 'A̱n, sìkasén ítjòn‑lè xi̱ta̱‑na̱ xi kji̱ko̱ 'én; jè xi koi̱ìndaàya ítjòn‑lè ndi̱yá‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","K'oa̱á xán‑nò, ngats'iì xi̱ta̱ xi tjín i̱ i̱sò'nde, ni̱jngoò xi̱ta̱ xi mangásòn koni jè Juan xi kis'iìn bautizar xi̱ta̱, ta̱nga ya̱ i̱jiìn na̱xa̱ndá ñánda otíxoma Nainá, jè xi̱ta̱ xi fehet'aà‑ne, ìsa̱á jeya tíjna mì k'oa̱á‑ne koni Juan. ");
INSERT INTO maaNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","K'e̱ nga kiì'nchré jñà xi̱ta̱ na̱xa̱ndá ko̱ jñà xi̱ta̱‑la̱ xi̱ta̱xá Roma xi síkíchjítjì tsojmì, kjòjngoò‑ikon nga ndaà tjín jè ndi̱yá kixi̱‑la̱ Nainá, nga jye komà bautizar i̱t'aà ts'e̱ Juan. ");
INSERT INTO maaNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ta̱nga jñà xi̱ta̱ fariseo ko̱ xi̱ta̱ chji̱ne̱ xo̱jo̱n ts'e̱ kjo̱tíxoma‑la̱ Nainá, mìkiì komà bautizar i̱t'aà ts'e̱ Juan. Tsachrjengui‑né kjo̱ndaà xi tjíndaà‑la̱ Nainá nga tsjá‑la̱ xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús kitsò: ―¿Yá xi siìngásòn‑koa̱a jñà xi̱ta̱ xi tjín na̱chrjein i̱'ndei̱? ¿Kó kjoàn xi ko̱ngásòn‑ko̱? ");
INSERT INTO maaNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jñà ko̱ngásòn‑kjoò jñà i̱xti xi bìtsa̱jna ndi̱tsi̱n nga síská, chja̱‑la̱ xíkjín, tsò‑la̱: “Kànìkjaneé‑nòje̱n xo̱bí ta̱nga jñò mìkiì kàchà; kàjndaá‑nòje̱n sò xi ba tsò ta̱nga mìkiì kàchìhindáyaà.” ");
INSERT INTO maaNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","J'iì Juan xi kis'iìn bautizar xi̱ta̱ xi mìtsà i̱nchra̱jín tsakjèn, ti̱koa̱ mìtsà xán kits'iì koa̱ jñò bixón‑nò: “Ini̱ma̱ ch'o‑la̱ nei̱í tjín‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","I̱kjoàn j'ia̱a xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱; ma‑na kje̱en, ti̱koa̱ ma‑na 'bia̱a; jñò, k'oa̱á s'ín bixón i̱'ndei̱: “Xi̱ta̱ chrjá'a‑né, xi̱ta̱ ch'i̱‑né, amigo‑la̱‑né jñà xi̱ta̱‑la̱ xi̱ta̱xá Roma xi síkíchjítjì tsojmì ko̱ jñà xi xi̱ta̱ jé.” ");
INSERT INTO maaNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ta̱nga jè kjoa̱chji̱ne̱‑la̱ Nainá, 'yaá‑la̱ nga kixi̱ tjín k'e̱ nga jye bitasòn. ");
INSERT INTO maaNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jngoò xi̱ta̱ fariseo kiìchja̱‑la̱ Jesús nga mejèn‑la̱ ko̱kje̱n‑ko̱. K'e̱ nga jahas'en ni'ya‑la̱ jè xi̱ta̱ fariseo, tsibìjnat'aà ími̱xa̱. ");
INSERT INTO maaNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ya̱ na̱xa̱ndá jè, tíjna jngoò chjo̱ón xi tse jé tjín‑la̱. K'e̱ nga kiì'nchré nga ya̱ tíjnat'aà ími̱xa̱ Jesús, ya̱ ni'ya‑la̱ jè xi̱ta̱ fariseo, ijchòko̱ jngoò chi̱tsín xi tjíya‑la̱ xkiì xi ndaà jne̱. ");
INSERT INTO maaNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ya̱á tsasìjnat'aà i̱jto̱n ndso̱ko̱ Jesús nga tíkjindáya. I̱kjoàn tsaníjno ndso̱ko̱ Jesús ko̱ ndáxko̱n. K'e̱é kisìxìjno‑ne ko̱ tsja̱ sko̱. Kjìn k'a kiskine'a ndso̱ko̱. I̱kjoàn kisìkaàjno xkiì xi ndaà jne̱. ");
INSERT INTO maaNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jè xi̱ta̱ fariseo xi kiìchja̱‑la̱ Jesús, k'e̱ nga kijtseè kjoa̱ koi, kitsò i̱jiìn ini̱ma̱‑la̱: “¿Mé‑ne nga mìkiì beèxkon‑ne yá chjo̱ón‑ne xi o̱tísíko̱? Tsà kixi̱ kjoa̱ nga jè xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá, skoe̱xkon‑né nga chjo̱ón xi jé tjín‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","K'e̱é kiìchja̱ Jesús, kitsò‑la̱: ―Simón, jngoò kjoa̱ ko̱xán‑lè. Simón kitsò: ―Maestro, ko̱t'ìn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús kitsò: ―Jò xi̱ta̱ títsa̱jna xi to̱n tje̱n‑la̱ ts'e̱ xi̱ta̱ xi síkìña to̱n; jngoò xi 'òn sìndo̱ tje̱n‑la̱; jè xi ìjngoò icháte tje̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ingajò xi̱ta̱ koi, tsjìn‑la̱ to̱n xi koi̱ìchjí ngajo‑ne. Jè nei‑la̱ to̱n kisìjchàat'aà‑la̱ ingajò. Ko̱t'ìn‑ná, ¿ñá‑la̱á ingajò xi̱ta̱ koi xi ìsa̱ 'ñó matsjakeè jè nei‑la̱ to̱n? ");
INSERT INTO maaNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kiìchja̱ Simón kitsò: ―'A̱n, k'oa̱á s'ín sìkítsjeèn, jè‑la xi ìsa̱ tse to̱n kitje̱n‑la̱. Jesús kitsò: ―Ndaà kichoòsòn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús kiskoòtsejèn‑jno jè chjo̱ón, kitsò‑la̱ Simón: ―Chítsejèn‑la̱ chjo̱ón jè. 'A̱n, k'e̱ nga kòfaha̱s'eèn ni'ya‑lè mìkiì kànìkitasoìn koni s'ín tjín kjo̱tíxoma tsa̱ján; mìkiì kò'biì‑ná nandá xi mochjeén‑la̱ ndso̱koaà nga saníjno; ta̱nga chjo̱ón jè, ndáxko̱ón kòhoníjno‑ne ndso̱koaà koa̱ tsja̱ sko̱ó kàsíxìjno‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","K'e̱ nga kànìhixat'aà‑ná mìkiì kichine'a‑ná ta̱nga chjo̱ón jè, kóni kòfaha̱s'eèn ni'ya‑lè tíkine'a ndso̱koaà. ");
INSERT INTO maaNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","’Ngaji̱, mìkiì kànáhijnoi asìti̱ skoaà, ta̱nga chjo̱ón jè, kòfàhijno ndso̱koaà xkiì xi ndaà jne̱. ");
INSERT INTO maaNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Koií k'oa̱s'ín xan‑lè: Chjo̱ón jè, jyeé kàchàat'aà yije‑la̱ ngats'iì jé‑la̱ koi kjoa̱‑la̱ nga 'ñó matsjakeè‑na, ta̱nga jè xi̱ta̱ xi chiba kàchàat'aà‑la̱ jé‑la̱, ìsa̱á chiba matsjakeè‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","K'e̱é kitsò‑la̱ Jesús jè chjo̱ón: ―Jé‑lè jyeé kàchàat'aà‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jñà xi̱ta̱ xi ta̱ña títsa̱jnat'aà ími̱xa̱ kitsò‑la̱ xíkjín: ―¿Yá xi̱ta̱‑né jè nga ti̱koa̱ ma‑la̱ síjchàat'aà‑ná jé‑ná? ");
INSERT INTO maaNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús kitsò ìjngoò k'a‑la̱ jè chjo̱ón: ―Koi‑né nga mokjeiín‑lè i̱t'aà ts'a̱n nga bitjotjì‑ne jé‑lè; t'in‑là ndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","K'e̱ nga komà i̱skan, Jesús, kjìn na̱xa̱ndá tsajmeè, ko̱ rancho̱, nga kiìchja̱ya ko̱ kisìka'bí 'én ndaà‑la̱ Nainá koni s'ín otíxoma Nainá. Tji̱ko̱ xi̱ta̱‑la̱ xi tejò ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ti̱koa̱á tji̱ko̱ i'nga íchjín xi jye kjòndaà‑ne ch'in nei̱í‑la̱ ko̱ xi kj'ei̱í ch'in. Ya̱á tji̱ko̱ María jè xi Magdalena 'mì, xi itoò ini̱ma̱ ch'o‑la̱ nei̱í itjojiìn yijo‑la̱; ");
INSERT INTO maaNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","tji̱ko̱ Juana, chjo̱ón‑la̱ Chuza xi síkinda̱ tsojmì‑la̱ xi̱ta̱xá ítjòn xi 'mì Herodes; ti̱koa̱á tji̱ko̱ xi 'mì Susana koa̱ kjìn‑ìsa íchjín tji̱ko̱ xi síchját'aà‑la̱ mé tsojmì xi tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","K'e̱ nga jye kòkjìn xi̱ta̱ xi xki̱ xi ján na̱xa̱ndá j'iì‑ne, Jesús, tsibéno̱jmí‑la̱ kjoa̱ xi mangásòn. Kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Jngoò xi̱ta̱ xi kiì kíjndi̱ xojmá. K'e̱ nga tsibíts'ia̱ nga kiskíjndi̱ xojmá, chixò chiba ya̱ i̱ya ndi̱yá. Koa̱ chinchanè xi̱ta̱ koa̱ jñà ni̱se tsakjèn. ");
INSERT INTO maaNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nguì k'oa̱ tjín chixòsòn ya̱ ñánda na̱xi̱ choòn, ta̱nga k'e̱ nga isò xojmá, ni̱to̱ón kixì nga mìkiì 'nchi̱'nde nangui. ");
INSERT INTO maaNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nguì k'oa̱ tjín chixò ya̱ i̱jiìn na'yá; ya̱á ta̱ña isòkjoò; k'e̱ nga kjò'nga na'yá, kisìk'en‑ngui xka̱‑la̱ xojmá. ");
INSERT INTO maaNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nguì k'oa̱ tjín chixò ñánda nangui ndaà; isò, kjò'nga, koa̱ tsajà‑la̱ toò; kitsjaà jngoò sìndo̱ nga jngoò ìjngoò. Jesús k'e̱ nga jye tsibéno̱jmí kjoa̱ koi, 'ñó kiìchja̱, kitsò: ―¡Ndaà ti̱ná'yaà koni xan‑nò! ");
INSERT INTO maaNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kiskònangui‑la̱ kó tsòya‑ne jè kjoa̱ xi mangásòn xi tsibéno̱jmí‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús kitsò: ―Jñò, Nainá jye kitsjaà‑nò nga jcha̱a kjoa̱'ma‑la̱ xi béno̱jmíya kó s'ín otíxoma Nainá; ta̱nga jñà xi̱ta̱ xi kj'ei̱í, tà kjoa̱ xi mangásòn s'e̱no̱jmí‑la̱, mé‑ne nga mìkiì skoe̱‑ne xi kjoa̱ kixi̱ na̱s'ín skótsejèn, mìkiì ko̱chi̱ya‑la̱ na̱s'ín nchi'nchré. ");
INSERT INTO maaNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Jè kjoa̱ xi mangásòn ts'e̱ xojmá, kií tsòyaá‑ne: Jñà xojmá, jè 'én‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jñà xojmá xi chixò i̱ya ndi̱yá, jñà ngaya‑la̱ xi̱ta̱ xi 'nchré 'én‑la̱ Nainá, i̱kjoàn f'iì xi̱ta̱ nei̱í, faáxìn jè 'én i̱jiìn ini̱ma̱‑la̱ mé‑ne nga mìkiì ko̱kjeiín‑la̱ koa̱ mìkiì ki̱tjojiìn kjo̱'in ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jñà xojmá xi chixòsòn na̱xi̱, jñà ngaya‑la̱ xi̱ta̱ xi 'nchré 'én‑la̱ Nainá, k'e̱ nga tàts'en‑la̱ kjoa̱ tsjaá ma‑la̱ nga mokjeiín‑la̱, ta̱nga tsjìn‑la̱ i̱'ma̱; tà chibaá na̱chrjein mokjeiín‑la̱; k'e̱ nga mé kjoa̱ xi sakó‑la̱, ni̱to̱ón síkíjna‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jñà xojmá xi chixò i̱jiìn na'yá, jñà ngaya‑la̱ xi̱ta̱ xi 'nchré 'én‑la̱ Nainá; k'e̱ nga jye tjímaya ndi̱yá‑la̱ Nainá, bíts'ia̱ nga síkájno‑la̱ yijo‑la̱, ótsji xi kjoa̱ nchi̱ná ko̱ xi kjoa̱ kjo̱tsja. Jñà kjoa̱ koi xi tjín i̱sò'nde bíchjoà‑ikòn‑la̱ nga mìkiì makixi̱ nga ojà‑la̱ toò. ");
INSERT INTO maaNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jñà xojmá xi chixò ñánda nangui ndaà, jñà ngaya‑la̱ xi̱ta̱ xi ndaà tjín ko̱ xi kixi̱ tjín ini̱ma̱‑la̱; 'nchré 'én‑la̱ Nainá ti̱koa̱ bíjiìn‑ikon 'én xi 'nchré; ndaà bincha kixi̱ skanda k'e̱ nga ndaà makjìn‑ya jñà 'én. ");
INSERT INTO maaNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Tsjìn xi̱ta̱ xi oká ni'ín, i̱kjoàn bíjtsa'ma, o xi ya̱ síkíjnangui na̱chan; jngoò ni'ín xi tì, sijna 'nga‑né; ya̱á sijnaya candelero mé‑ne nga ko̱hiseèn‑la̱ jñà xi̱ta̱ xi kjoa̱has'en ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ni̱mé kjoa̱ tjín xi tjí'ma i̱'ndei̱ xi mìkiì ko̱tsejèn nga ko̱ma i̱skan; ti̱koa̱á tsjìn kjoa̱ xi tjí'ma i̱'ndei̱ xi mìkiì jcha̱‑la̱. Ngats'iì kjoa̱ skoe̱xkon yije xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’T'e̱en kinda̱ kjo̱hítsjeèn‑nò k'e̱ nga ki̱ná'ya 'én‑la̱ Nainá. Ndaà ti̱ná'yaà. Nga̱ jè xi tjín‑la̱ kjo̱hítsjeèn k'oi̱í ìsa̱‑la̱; ta̱nga jè xi tsjìn‑la̱, skanda tjá'aán‑la̱ mé xi k'oa̱s'ín síkítsjeèn nga tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nea̱‑la̱ ko̱ 'ndse̱ kiìkon ñánda tíjna Jesús. Ta̱nga mìkiì komà ijchò skanda ñánda tíjna nga 'ñó kjìn ma‑ne xi̱ta̱ xi títsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jesús kis'eno̱jmí‑la̱, kitsò‑la̱: ―Nea̱‑lè ko̱ jñà 'ndsì, ján ndi̱tsiaán títsa̱jna, mejèn xó‑la̱ nga skótsejèn‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kiìchja̱ Jesús, kitsò: ―Xi nea̱‑na̱ ko̱ xi 'ndsè xan‑la̱, jñà‑né xi 'nchré 'én‑la̱ Nainá, ti̱koa̱ síkitasòn. ");
INSERT INTO maaNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jngoò na̱chrjein, Jesús ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱ jahas'en jngoò chitso, kitsò Jesús: ―Tíkjiaán, ki̱tjájtoaá ján xijngoaà ndáchikon. I̱kjoàn kiì. ");
INSERT INTO maaNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ta̱nga k'e̱ nga kiìsòndá chitso, Jesús tsohojnafè‑né. I̱kjoàn kjòts'ia̱ nga j'iì tjo̱xkón ya̱ i̱jiìn ndáchikon. Jyeé tífahas'en nandá chitso; xkón tjín tsà ya̱ ska̱jiìn‑ndá. ");
INSERT INTO maaNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jñà xi̱ta̱‑la̱ k'e̱é kiìkon nga kisìkjaá‑la̱ Jesús; kitsò‑la̱: ―¡Maestro! ¡Maestro! ¡Chitso, jye tíkaànguindá! Jyeé‑la ki̱yá. Jaá‑la̱ Jesús; i̱kjoàn tsohótiko̱ tjo̱xkón ko̱ ndáchikon, ni̱to̱ón kisijyò‑ne, kjòndaàya‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesús kitsò: ―¿Mé‑ne mìkiì mokjeiín‑nò i̱t'aà ts'e̱ Nainá? Jñà xi̱ta̱‑la̱ tà kitsakjòn‑né. Tà kjòxkón‑la̱. Kitsò‑la̱ xíkjín: ―¿Yá xi̱ta̱‑ne jè nga chja̱‑la̱ tjo̱ ko̱ nandá koa̱ síkitasòn‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","I̱kjoàn ijchò ya̱ nangui‑la̱ xi̱ta̱ Gadareno xi kijna xijngoaà ndáchikon ts'e̱ Galilea. ");
INSERT INTO maaNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","K'e̱ nga itjojen chitso, Jesús, ijchò kasìt'aà jngoò‑la̱ xi̱ta̱ x'i̱n xi ya̱ i̱'nde‑la̱ na̱xa̱ndá Gadara. 'Ñó kjòtseé tíjiìn yijo‑la̱ ini̱ma̱ ch'o‑la̱ nei̱í; mìtsà nikje ókjá, koa̱ mì ni'ya tjín‑la̱; ya̱á xó bìjnaya nga̱jo̱‑la̱ mik'en. ");
INSERT INTO maaNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Xi̱ta̱ jè, k'e̱ nga kijtseè Jesús, 'ñó kiskindàyat'aà‑la̱ koa̱ tsasèn‑xkó'nchit'aà‑la̱; i̱kjoàn 'ñó kiìchja̱, kitsò: ―Jesús, ngaji̱ xi Ki'ndí‑la̱ Nainá 'mì‑lè xi 'ñó 'nga tíjna, ¿mé xi mejèn‑lè ko̱ 'a̱n? ¡Bìtsi'bà‑lè, kì yatoòn‑ná! ");
INSERT INTO maaNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Koií o̱kitsò‑ne, nga jè Jesús, jyeé ko̱s'ín tsatíxoma‑la̱ jè ini̱ma̱ ch'o‑la̱ nei̱í nga kàtitjojiìn yijo‑la̱ xi̱ta̱ jè. Jyeé kjòtseé ko̱s'ín tíjiìn yijo‑la̱ nga biyaàxín; na̱s'ín na'ñó ki̱cha̱ cadena sit'aà'ñó ndso̱ko̱ ko̱ tsja, chíkjoa̱á‑la̱ nga otejtso, i̱kjoàn fìko̱ jè ini̱ma̱ ch'o‑la̱ nei̱í ya̱ nangui kixì ñánda tsjìn xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús kiskònangui‑la̱, kitsò‑la̱: ―¿Kó 'mì‑lè? Xi̱ta̱ jè kitsò: ―Legión 'mì‑na. Koií ko̱'mì‑ne nga 'ñó kjìn ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jñà ini̱ma̱ ch'o‑la̱ nei̱í tsibítsi'ba‑la̱ Jesús nga mì ya̱á si̱ìkatsjoya ni̱tja̱n‑la̱ nei̱í ñánda tjín kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ya̱ i̱t'aà nindoò, 'ñó kjìn ma chi̱nga̱ xi nchikjèn‑jno i̱jiìn ijñá. Jñà ini̱ma̱ ch'o‑la̱ nei̱í, tsibítsi'ba‑la̱ Jesús nga tsjá'nde‑la̱ nga ya̱ kjoa̱has'en‑jiìn yijo‑la̱ chi̱nga̱. Jesús, kitsjaà'nde‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jñà ini̱ma̱ ch'o‑la̱ nei̱í, nga jye itjojiìn yijo‑la̱ xi̱ta̱ jè, i̱kjoàn jahas'en‑jiìn yijo‑la̱ jñà chi̱nga̱. I̱kjoàn jñà chi̱nga̱ tsatíkjájen‑jno ya̱ na̱xi̱ skanda i̱jiìn nandá; ya̱á k'en‑jiìn nandá ngats'iì jñà chi̱nga̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jñà xi̱ta̱ xi nchikondà chi̱nga̱, k'e̱ nga kijtseè kjoa̱ xi komà, tsangachikon nga kisìkí'nchré na̱xa̱ndá kóho̱kji ñánda rancho̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jñà xi̱ta̱ na̱xa̱ndá, k'e̱ nga kiì'nchré, itjo katsejèn jñà kjoa̱ xi komà. Kiì ñánda tíjna Jesús. Ti̱koa̱ ya̱ tíjnat'aà ndso̱ko̱ Jesús jè xi̱ta̱ xi jye itjojiìn‑ne yijo‑la̱ jñà ini̱ma̱ ch'o‑la̱ nei̱í. Jyeé íkjá‑ne nikje‑la̱, ti̱koa̱á jyeé ndaà tjín‑ne kjo̱hítsjeèn‑la̱. Jñà xi̱ta̱ k'e̱ nga kijtseèxkon, tà kitsakjòn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jñà xi̱ta̱ xi kijtseè kjoa̱ koi, tsibéno̱jmí‑la̱ xíkjín kó s'ín komà nga kjòndaà‑ne jè xi̱ta̱ xi ini̱ma̱ ch'o‑la̱ nei̱í kisijiìn yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ngats'iì xi̱ta̱ xi títsa̱jna ya̱ nangui‑la̱ xi̱ta̱ Gadareno, kóho̱kji jngoò itjandiì, tsibítsi'ba‑la̱ Jesús nga kàtjì‑ne, koií kjoa̱‑la̱ nga 'ñó kitsakjòn xi̱ta̱ koi. Jesús jahas'en‑ne chitso, i̱kjoàn kiì‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jè xi̱ta̱ xi jye itjokàjiìn‑ne yijo‑la̱ ini̱ma̱ ch'o‑la̱ nei̱í tsibítsi'ba‑la̱ Jesús nga mejèn‑la̱ nga ya̱ ko̱jmeiìko̱; ta̱nga jè Jesús kitsjaà‑la̱ o̱kixi̱ nga kàtìjna; kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―T'in‑ne ni'ya‑lè, tèno̱jmí yije‑la̱ xi̱ta̱ nga 'ñó tse kjoa̱ kàsíko̱‑lè Nainá. Xi̱ta̱ jè, kiì‑ne; i̱kjoàn tsibíts'ia̱ nga tsibéno̱jmí, kisìhingasòn 'én kóho̱kji na̱xa̱ndá jè nga 'ñó tse kjoa̱ kisìko̱ Jesús xi i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","K'e̱ nga jye j'iì ìjngoò k'a‑ne Jesús ján xijngoaà ndáchikon, kjòtsjaá‑la̱ jñà xi̱ta̱ xi kjìn ma‑ne, koií kjoa̱‑la̱ nga ngats'iì, nchikoña‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","J'iìkon jngoò xi̱ta̱ sko̱‑la̱ xi ts'e̱ ni'ya i̱ngo̱ sinagoga xi 'mì Jairo; tsasèn‑xkó'nchit'aà ndso̱ko̱ Jesús, tsibítsi'ba‑la̱ nga mejèn‑la̱ kji̱ko̱ ni'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Koií xá j'iìkjaá‑ne nga jye tíbiyaà ndí tsòti‑la̱ xi ta̱jngoò ma‑ne xi tejò nó tjín‑la̱. Jesús, k'e̱ nga tífì, jñà xi̱ta̱ nga kjìn ma‑ne, chi̱ba̱‑la̱ tsohó'nchò'ñó‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ya̱ tsóhojiìn jngoò chjo̱ón xi jye kjò tejò nó tjín‑la̱ ch'in jní. Jye kjò tse to̱n ko̱ tsojmì xi tjín‑la̱ kisìkjeheya xi kjoa̱ ts'e̱ chji̱ne̱xkiì; mìkiì mandaà‑ne ni̱ta̱ yá xi síxkiì‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chjo̱ón jè, kiì kasìt'aà chrañà‑la̱ Jesús ya̱ i̱jto̱n íts'i̱n nga kitsobà'ñó i̱tjòn nikje‑la̱, koa̱ jè jní xi tíxíxteèn‑la̱, ni̱to̱ón kisijyò‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","K'e̱é kiskònangui Jesús, kitsò: ―¿Yá‑né xi kàtsobà‑na? Ngats'iì xi̱ta̱ kitsò: ―Mìtsà yá‑jèn. K'e̱é kitsò Pedro ko̱ xi̱ta̱ xi i'nga: ―Maestro, jñà xi̱ta̱ nga kjìn ma‑ne fàhitje̱n‑lè koa̱ ó'nchò'ñó‑lè, ngaji̱ si‑né: “¿Yá‑né xi kàtsobà‑na?” ");
INSERT INTO maaNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús kitsò ìjngoò k'a: ―Tjín xi kàtsobà‑na; kàbeéyaá‑na nga kòbitjojiìn nga'ñó yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jè chjo̱ón, k'e̱ nga kijtseè nga mìkiì ko̱ma kójna'ma nga ki'yat'in‑la̱, chi̱ba̱‑la̱ tíhotsé yijo‑la̱ nga tsasèn‑xkó'nchit'aà‑la̱ Jesús. Tsibéno̱jmí‑la̱ nga nguixko̱n ngats'iì xi̱ta̱ na̱xa̱ndá mé kjoa̱‑ne nga nikje‑la̱ Jesús kitsobà‑ne, koa̱ kó s'ín nga ni̱to̱n kjòndaà‑ne ch'in‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús kitsò‑la̱: ―Ndí nea̱a, koi‑né nga mokjeiín‑lè i̱t'aà ts'a̱n nga kòmandaà‑ne. T'in‑là ndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tákó ti̱k'e̱é tíchja̱‑ìsa Jesús nga j'iì jngoò xi̱ta̱ xi ts'e̱ xi̱ta̱ ítjòn xi inchrobà‑ne ni'ya‑la̱ nga kitsò: ―Ndí tsòti‑lè jyeé k'en; kì ti̱ kiì nìjti‑la̱ Maestro. ");
INSERT INTO maaNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","K'e̱ nga kiì'nchré Jesús kitsò‑la̱: ―Kì tsakjoòn‑jèn; tà jè‑né nga kàtakjeiín‑lè, jè ndí tsòti‑lè ko̱ndaá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","K'e̱ nga jahas'en ni'ya, Jesús, mìkiì kitsjaà'nde‑la̱ xi̱ta̱ xi kj'ei̱í nga jahas'en‑ko̱, tà jè Pedro, Jacobo, Juan, ko̱ na̱'èn‑la̱ ko̱ nea̱‑la̱ ndí tsòti. ");
INSERT INTO maaNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ngats'iì xi̱ta̱ xi títsa̱jna, nchikjindáya‑né koa̱ nchisíkájno‑né xi i̱t'aà ts'e̱ ndí tsòti. Ta̱nga jè Jesús kitsò‑la̱: ―Kì chìhindáya‑jèn; mìtsà kòbiyaà ndí tsòti, tà kjinafè‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jñà xi̱ta̱ xi títsa̱jna tà tsijnòkeè Jesús nga tíjiìn‑la̱ nga jyeé k'en. ");
INSERT INTO maaNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ta̱nga Jesús kiskoé tsja ndí tsòti; 'ñó kiìchja̱‑la̱ kitsò‑la̱: ―Tsòti, ¡ti̱sítji̱in! ");
INSERT INTO maaNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","J'iì ìjngoò k'a‑ne ini̱ma̱‑la̱; i̱kjoàn ni̱to̱ón tsasítje̱n; Jesús kitsjaà o̱kixi̱ nga tsjá‑la̱ xi ski̱ne̱. ");
INSERT INTO maaNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jñà xi̱ta̱ jchínga‑la̱, tà kjòxkón‑la̱; ta̱nga jè Jesús kitsò‑la̱: ―Kì yá xi̱ta̱ xi bèno̱jmí‑la̱ jè kjoa̱ xi kòma. ");
INSERT INTO maaNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús kiìchja̱‑la̱ xi̱ta̱‑la̱ xi tejò ma‑ne xi jè tsibíxáya‑la̱; kitsjaà‑la̱ nga'ñó ko̱ kjo̱tíxoma nga ko̱chrjejiìn yije ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn yijo‑la̱ xi̱ta̱; ti̱koa̱ ko̱ma‑la̱ si̱ìndaà‑ne xi̱ta̱ xi ch'in xk'én tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kisìkasén nga ki̱chja̱ya kó s'ín otíxoma Nainá, ti̱koa̱ si̱ìndaà‑ne xi̱ta̱ xi ch'in tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kitsò‑la̱: ―Ni̱mé xi ch'aà xi ts'e̱ ndi̱yá; kì yá garrote ch'aà; kì na̱'yaá ch'aà; kì i̱nchra̱jín ch'aà; kì to̱ón ch'aà; ti̱koa̱ kì jò na̱chro̱ ch'aà. ");
INSERT INTO maaNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ni̱ta̱ ñánda ni'ya nga kijchoò, ya̱á ti̱tsa̱jna, skanda k'e̱ ki̱tjo̱o‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tsà jngoò na̱xa̱ndá ñánda kijchoò, tsà mìkiì skoétjò‑nò, titjo̱jñoò, titsajneè chijo‑la̱ ndso̱koò nga kàteè kjoa̱ koi koni jngoò seña, nga jñò, mì ti̱ kiì si̱s'in‑là; kjo̱'iín s'e̱‑la̱ nga mìkiì mokjeiín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Itjo xi̱ta̱ koi, xki̱ xi ján na̱xa̱ndá kiì; kisìka'bí 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo; ti̱koa̱á kisìndaà‑ne xi̱ta̱ xi ch'in tjín‑la̱ nga kjijndà na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jè xi̱ta̱xá ítjòn xi 'mì Herodes, k'e̱ nga kiì'nchré ngats'iì kjoa̱ xi tís'ín Jesús, mìkiì beè kó s'ín si̱ìkítsjeèn, nga tjín i'nga xi̱ta̱ xi tsò: “Juan, jyeé jaáya‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Xi̱ta̱ xi i'nga tsò: “Jè Elías xi tsatsejèn ìjngoò k'a‑ne.” Ti̱koa̱á xi̱ta̱ xi kj'ei̱í tsò: “Jaáya jngoò‑la̱ xi̱ta̱ jchínga xi kiìchja̱ ngajo‑la̱ Nainá.” ");
INSERT INTO maaNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kitsò Herodes: ―'A̱n sobà tsibìxá‑la̱ xi̱ta̱ xi kisìk'en Juan nga tsatesin. ¿Yá xi̱ta̱‑ne jè xi ko̱s'ín tís'ín kjoa̱ xi 'nchrè? K'oa̱á ma‑ne nga mejèn‑la̱ skoe̱xkon Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","K'e̱ nga j'iì ìjngoò k'a‑ne jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús, tsibéno̱jmí ngats'iì kjoa̱ xi kis'iìn. Jesús, k'e̱é kiìko̱ jngoò i̱'nde ts'e̱ na̱xa̱ndá Betsaida ñánda tsjìn xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jñà xi̱ta̱, k'e̱ nga kiì'nchré nga jye kiì Jesús, kiìtji̱ngui‑la̱; k'e̱ nga ijchòtji̱ngui‑la̱, Jesús, kisìs'in‑la̱, tsohóko̱, tsibéno̱jmí‑la̱ kó s'ín otíxoma Nainá, ti̱koa̱ kisìndaà‑ne xi̱ta̱ xi mochjeén‑la̱ nga ko̱ndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","K'e̱ nga jye tímahixòn, jñà xi̱ta̱‑la̱ xi tejò ma‑ne, ijchò kinchat'aà‑la̱ Jesús, kitsò‑la̱: ―Ko̱t'ìn‑la̱ ngats'iì xi̱ta̱ kàtjì‑ne mé‑ne nga kàtasíkjáya ya̱ na̱xa̱ndá chrañàt'aà ko̱ rancho̱ ñánda sa̱kò‑la̱ xi ski̱ne̱. I̱ i̱'nde ñánda titsa̱jnaá, i̱t'aà xìn‑né, ni̱mé tjín. ");
INSERT INTO maaNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús kitsò‑la̱: ―Tjiì‑là jñò xi ko̱kje̱n xi̱ta̱ koi. Jñà xi̱ta̱‑la̱ kitsò: ―Nìmé tjín‑naje̱n, tà 'òn ma i̱nchra̱jín‑naje̱n koa̱ jò ma ti̱n, tà jè‑la tsà konguí kindaà‑la̱je̱n xi ko̱kje̱n ngats'iì xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Maá‑la̱ tsà 'òn jmiì xi nguì xi̱ta̱ x'i̱n. Jesús kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Ti̱kítsa̱jnajtión, icháte icháte ti̱kítsa̱jna‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","K'oa̱á s'ín kisìkítsa̱jna kóho̱tjín. ");
INSERT INTO maaNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús, kiskoé jñà i̱nchra̱jín xi 'òn ma‑ne ko̱ jñà ti̱n xi jò ma‑ne; i̱kjoàn kiskoòtsejèn ngajmiì; kitsjaà‑la̱ kjo̱ndaà Nainá; i̱kjoàn kisìxkoa̱ya i̱nchra̱jín, k'e̱é kitsjaà‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ nga kisìka'bí‑la̱ jñà xi̱ta̱ xi kjìn ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tsakjèn yije kóho̱tjín xi̱ta̱, kó nga kjòskiì; k'e̱é tsibíxkó‑ne jñà xi tsiningui‑ne; nguì tejò ni̱si̱yá komà. ");
INSERT INTO maaNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jngoò k'a k'e̱ nga tíjnat'aàxìn Jesús nga tíchja̱t'aà‑la̱ Nainá, ya̱ títsa̱jnako̱ xi̱ta̱ xi kota'yàt'aà‑la̱. Jesús kiskònangui, kitsò‑la̱: ―¿Kó tsò xi̱ta̱, yá‑ná 'a̱n? ");
INSERT INTO maaNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jñà xi̱ta̱‑la̱ kitsò: ―Tjín xi tsò: jè Juan xi kis'iìn bautizar xi̱ta̱, ti̱koa̱á tjín xi tsò: jè Elías, koa̱ tjín i'nga xi tsò: jaáyaá‑la jngoò‑la̱ xi̱ta̱ xi chinchima kjòtseé xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesús kiskònangui‑la̱ kitsò‑la̱: ―Jñò, kó bixón. ¿Yá‑ná 'a̱n? K'e̱é kiìchja̱ Pedro, kitsò: ―Ji̱‑né xi Cristo xi xó kisìkasén‑lè Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ta̱nga Jesús 'ñó tsibít'in‑la̱ nga mì yá xi̱ta̱ xi ke̱èno̱jmí‑la̱ kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kitsò‑la̱: ―'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, tseé kjo̱'in siìkjiaán; ko̱chrje‑nguií‑na jñà xi̱ta̱ jchínga, ko̱ xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. Si̱ìk'eén‑na ta̱nga k'e̱ nga ki̱jchò jàn na̱chrjein kjoa̱áya‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Xi komà i̱skan kitsò‑la̱ kóho̱tjín: ―Tsà yá xi mejèn‑la̱ nga xi̱ta̱ ts'a̱n ko̱ma, kàtatsjeiìn‑takòn mé xi mejèn‑la̱ yijo‑la̱; koni jngoò xi̱ta̱ xi 'yajen krò‑la̱, na̱chrjein inchijòn kàtìjnandaà nga si̱ìkjeiín kjo̱'in xi kjoa̱ ts'a̱n; ndaà kàtjìt'aà‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nga ni̱ta̱ yá xi̱ta̱ xi mejèn‑la̱ ko̱chrjetjì yijo‑la̱ nga ni̱mé kjo̱'in sa̱kò‑la̱, tà sa̱á si̱ìchija‑né ko̱ kjo̱'in kíjnajiìn; ta̱nga jè xi tíjnandaà nga tsjá yijo‑la̱ xi kjoa̱ ts'a̱n, jè‑né xi ki̱tjokàjiìn kjo̱'in nga i̱t'aà ts'a̱n ndaà kíjna. ");
INSERT INTO maaNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Mé xi si̱ìkijne jngoò xi̱ta̱ na̱s'ín tjoé yije‑la̱ i̱sò'nde tsà chija ini̱ma̱‑la̱ koa̱ si̱ìkits'ón yijo‑la̱? Ni̱mé. ");
INSERT INTO maaNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tsà tjín i'nga xi̱ta̱ xi ko̱sobà‑la̱ i̱t'aà ts'a̱n ko̱ i̱t'aà ts'e̱ 'én‑na̱, ti̱koa̱á 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, ko̱sobà‑na k'e̱ nga ki̱tjojen ìjngoò k'a nga skoe̱ xi̱ta̱ kjoa̱jeya‑na̱, skoe̱ kjoa̱jeya‑la̱ Na̱'èn‑na̱ ti̱koa̱ skoe̱ kjoa̱jeya‑la̱ ts'e̱ àkja̱le̱ tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Xi o̱kixi̱, k'oa̱á xán‑nò, i̱jndé títsa̱jnajiìn i'nga xi̱ta̱ xi mìkiì ki̱yá skanda k'e̱ nga skoe̱ kó s'ín otíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tjín‑la̱ tsà kó jiìn na̱chrjein nga tsibéno̱jmí 'én koi, Jesús, kiìmijìn‑jno jngoò nindoò nga kiìchja̱t'aà‑la̱ Nainá. Kiìko̱ Pedro, Juan ko̱ Jacobo. ");
INSERT INTO maaNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","K'e̱ nga tíchja̱t'aà‑la̱ Nainá, Jesús, jahatjìya í'ñó i̱sén‑la̱; jè nikje‑la̱ 'ñó kjòchroba; tsí ote tsatsejèn. ");
INSERT INTO maaNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jò xi̱ta̱ x'i̱n tsatsejèn xi nchijoókjoò Jesús, jè Moisés ko̱ Elías. ");
INSERT INTO maaNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Xi̱ta̱ koi, tsí ote choòn kjoa̱jeya‑la̱ nga jngoò itjandiì ñánda jncha. Nchijoóya‑ne nga jè Jesús, jye tífì síkitasòn kjoa̱ ján Jerusalén nga ya̱ ki̱yá. ");
INSERT INTO maaNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Jè Pedro ko̱ xi̱ta̱ xíkjín, tsí 'ñó nijñá‑la̱, ta̱nga k'e̱ nga jye kitjaàxìn‑la̱ nijñá kijtseèxkon kjoa̱jeya‑la̱ Jesús ko̱ jñà xi̱ta̱ xi jò ma‑ne xi títsa̱jnako̱. ");
INSERT INTO maaNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","K'e̱ nga jye chinchat'aà xìn‑la̱ Jesús xi̱ta̱ koi, jè Pedro kitsò: ―Maestro, ndaà tjín nga i̱ titsa̱jnaá. Kíndaá jàn ni'ya xkójndà, jngoò tsi̱ji, jngoò ts'e̱ Moisés, jè xi ìjngoò ts'e̱ Elías. Jè Pedro tà k'oa̱á kitsò, mì ti̱ kiì beè‑ne kó s'ín ki̱chja̱. ");
INSERT INTO maaNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ti̱k'e̱‑né nga tíchja̱ Pedro, j'iì jngoò 'nguién‑la̱ ifi xi tsibí'ma xi̱ta̱ koi. K'e̱ nga jahas'en‑jiìn ifi, tà kitsakjòn‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ya̱ i̱jiìn ifi kina'yà jngoò‑la̱ 'én xi kitsò: ―Jè jèe̱ xi ki'ndí‑na xi 'ñó matsjake̱, jè ti̱ná'ya‑là. ");
INSERT INTO maaNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","K'e̱ nga jye kina'yà‑la̱ 'én koi tà jè ta̱jngoò síjna‑ìsa Jesús. Na̱chrjein koi jñà xi̱ta̱‑la̱ jyò tsibìtsa̱jna, ni̱mé 'én xi kiìchja̱, mìtsà yá xi̱ta̱ tsibéno̱jmí‑la̱ kjoa̱ xi kijtseè. ");
INSERT INTO maaNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Xi komà inchijòn, k'e̱ nga itjojen‑jno‑ne nindoò, 'ñó kjìn xi̱ta̱ kisatiìkjoò. ");
INSERT INTO maaNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","K'e̱é jngoò xi̱ta̱ xi ya̱ tíjnajiìn‑la̱ xi̱ta̱ kjìn, 'ñó kiìchja̱, kitsò‑la̱ Jesús: ―Maestro, tìbitsi'bà‑lè nga chítsejèn‑la̱ ki'ndí‑na̱ xi tà jè ta̱jngoò‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jngoò ini̱ma̱ ch'o‑la̱ nei̱í tsobà'ñó; tà ni̱to̱ón kjindáya, i̱kjoàn 'ñó síkatsé yijo‑la̱; ochrje ndáxó tso'ba; tse kjo̱'in tsjá‑la̱, mìkiì xátí tsjeiìn. ");
INSERT INTO maaNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kàbìtsi'bà‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑lè nga kàtachrjekàjiìn ini̱ma̱ ch'o xi tíjiìn yijo‑la̱, ta̱nga mìkiì kòma‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","K'e̱é kiìchja̱ Jesús kitsò: ―Jñò, xi̱ta̱ xi mìkiì mokjeiín‑nò i̱t'aà ts'a̱n, xi ch'o 'nè. ¿Skanda mé na̱chrjein kóti̱jnako̱‑nò koa̱ ska̱‑na kjoa̱‑nò? Nchrohókoi̱i ki'ndí‑lè i̱jndé. ");
INSERT INTO maaNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","K'e̱ nga tínchrobá chrañà jè ti, jè ini̱ma̱ ch'o‑la̱ nei̱í, tsajndoòt'aà nangui, i̱kjoàn kisìkatsé yijo‑la̱; ta̱nga jè Jesús, tsohótiko̱ jè ini̱ma̱ ch'o‑la̱ nei̱í; i̱kjoàn kisìndaà‑ne jè ti; kisìnga̱tsja‑ne na̱'èn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ngats'iì xi̱ta̱ tà kjòxkón‑la̱ jè kjoa̱jeya‑la̱ Nainá. Ngats'iì kjoa̱ xi kis'iìn Jesús, ti̱koa̱á tà kjòxkón‑la̱ ngats'iì xi̱ta̱. Jesús kitsò‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Ndaà ti̱ná'yaà jñà 'én koi; kì nìjchàajiìn‑jèn: 'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ ya̱á si̱ìnga̱tsja‑na xi̱ta̱ nguixko̱n xi̱ta̱xá. ");
INSERT INTO maaNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jñà xi̱ta̱‑la̱ mìkiì kjòchi̱ya‑la̱ jè 'én xi ko̱s'ín kitsò‑la̱. Nainá tsibí'ma‑né nga mìkiì kjoa̱has'en‑jiìn‑la̱; tà kitsakjòn‑né, mìkiì kiskònangui‑la̱ Jesús kó tsòya‑ne 'én xi tsibéno̱jmí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, tsibíts'ia̱ nga tsajoóya‑ne yá xi̱ta̱ xíkjín xi kíjna ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús, k'e̱ nga kijtseè koni s'ín nchisíkítsjeèn, kiskoé jngoò ndí ti, kisìkíjnat'aà‑la̱ yijo‑la̱, ");
INSERT INTO maaNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kitsò‑la̱: ―Ni̱ta̱ yá‑ne xi i̱t'aà ts'a̱n skoétjò jngoò ndí ti koni jè, 'a̱án xi skoétjò‑na; jè xi skoétjò‑na, ti̱koa̱á skoétjò‑né jè xi kisìkasén‑na. Koií kjoa̱‑la̱, jè xi ìsa̱ nangui tíjna xi ya̱ tíjnajiìn‑nò, jè‑né xi ìsa̱ tíjna ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan kitsò: ―Maestro, ki'ya jngoò‑je̱n xi̱ta̱ xi ko̱ 'ín‑lè ochrjekàjiìn ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn yijo‑la̱ xi̱ta̱; mìkiì kits'iì'nde‑la̱je̱n nga mìtsà xi̱ta̱ tsa̱ján xi jñá fìt'aà‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús kitsò‑la̱: ―Kì bichakjáya‑là. Jè xi mìtsà kondra̱ tsa̱ján, xi̱ta̱ tsa̱ján‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","K'e̱ nga jye kjòchrañà na̱chrjein nga kjoi̱ ìjngoò k'a‑ne Jesús ján ngajmiì, 'ñó tsi'beé‑la̱ ikon nga kiì ján Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kisìkasén ítjòn i'nga xi̱ta̱‑la̱ jngoò na̱xa̱ndá jtobá ján nangui Samaria. Kiì kátsji'nde ñánda si̱ìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jñà xi̱ta̱ Samaria mìkiì kitsjaà'nde‑la̱ nga jyeé tíjiìn‑la̱ nga ján nchifì Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, Jacobo ko̱ Juan, k'e̱ nga kijtseè nga mìkiì kitsjaà'nde‑la̱ kitsò: ―Na̱'èn, ¿a mejèn‑lè nga k'oa̱ kixón‑je̱n nga kàtjanchrobá‑jen ni'ín xi ts'e̱ ngajmiì nga kàtjehesòn xi̱ta̱ koi koni s'ín kis'iìn Elías? ");
INSERT INTO maaNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ta̱nga jè Jesús kisìkátji'a, tsohótiko̱. Kitsò‑la̱: ―Jñò, mìkiì tíjiìn‑nò yá ts'e̱ ini̱ma̱ xi kàtsjá‑nò kjo̱hítsjeèn jè. ");
INSERT INTO maaNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, mìtsà koi xá j'i̱‑na nga kàtachija ini̱ma̱‑la̱ xi̱ta̱; jè‑né nga kàtitjokàjiìn kjo̱'in. I̱kjoàn xìn na̱xa̱ndá kiì. ");
INSERT INTO maaNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","K'e̱ nga nchifìya ndi̱yá, jngoò xi̱ta̱ kitsò‑la̱: ―Na̱'èn, kjítji̱ngui‑lè ni̱ta̱ ñánda‑ne nga k'oín. ");
INSERT INTO maaNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús kitsò‑la̱: ―Jñà ni̱nda̱, tjín‑la̱ nguijo ñánda oyijò; ti̱koa̱á jñà ni̱se tjín‑la̱ tjé; ta̱nga 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, tsjìn‑na i̱'nde ñánda síkjáya. ");
INSERT INTO maaNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús kitsò ìjngoò‑la̱ xi̱ta̱: ―Nchrobátji̱ngui‑ná. Jè xi̱ta̱ xi o̱ki'mì‑la̱ kitsò: ―Na̱'èn, tjiì'nde‑ná nga ítjòn kjián kìhijñaà na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús kitsò‑la̱: ―Jñà mik'en kàtìhijiìn mik'en‑la̱; ngaji̱ t'in, ti̱ka'bí 'én kó s'ín otíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ìjngoò xi̱ta̱ xi k'oa̱ ti̱ kitsò: ―Kjítji̱nguií‑lè ngaji̱ Na̱'èn, ta̱nga tjiì'nde‑ná nga kjián síhixat'aà ítjoàn jñà xi̱ta̱ xi títsa̱jna ni'ya‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús kitsò‑la̱: ―Ni̱jngoò xi̱ta̱ xi i̱jto̱n íts'i̱n tíkotsejèn‑ne ko̱ma si̱kitasòn xá‑la̱ Nainá nga jè tíhotíxoma. K'oa̱á ngaya‑la̱ tsà jngoò xi̱ta̱ xi tísíkon nchra̱ja̱, tsà i̱jto̱n íts'i̱n tíkotsejèn‑ne, mìkiì ko̱ma si̱ìxá. ");
INSERT INTO maaNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","K'e̱ nga jye komà kjoa̱ koi, Na̱'èn‑ná Jesús kitsjaà‑la̱ xá nguì jàn‑kaàn ko̱ te xi̱ta̱ xi kj'ei̱í. Jò jò kisìkasén ítjòn nga kjijndà na̱xa̱ndá ko̱ i̱'nde ñánda nga ìsa̱ i̱skan kjoi̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kitsò‑la̱: ―Xi o̱kixi̱, 'ñó tse xá tjín xi i̱t'aà ts'e̱ 'Én‑la̱ Nainá koni s'ín ma k'e̱ nga kjìn tsojmì majchá, ta̱nga jñà xi̱ta̱ chi̱'nda xi síxá, chiba ma‑ne. Tìtsi'ba‑là jè Nei‑la̱ xá, kàtasíkasén‑ìsa xi̱ta̱ chi̱'nda xi koi̱ìxkó tsojmì koi. ");
INSERT INTO maaNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tanguió; 'a̱án siìkasén‑nò koni orrè ki'ndí ya̱ i̱jiìn‑la̱ cho̱ tse̱jén. ");
INSERT INTO maaNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kì chijtsa to̱n ch'aà, kì naxá na̱'yaá ch'aà, ni̱ xo̱xté tsjayaà; ti̱koa̱á mìkiì yá xi̱ta̱ xi nìhixat'aà ya̱ i̱ya ndi̱yá. ");
INSERT INTO maaNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ni̱ta̱ ñánda ni'ya nga ki̱tjás'e̱en, ítjòn k'oa̱ tixón: “'Nchán kàtas'e ni'ya jè.” ");
INSERT INTO maaNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ni'ya jè, tsà tjín xi̱ta̱ xi ok'ìn‑la̱ nga s'e̱‑la̱ kjoa̱'nchán, ki̱tasòn‑né; tsà majìn, mìkiì ki̱tasòn. ");
INSERT INTO maaNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ti̱tsa̱jna ya̱ ni'ya ñánda ki̱tjás'e̱en; kì xki̱ xi ján ni'ya onguió; chi̱ne̱e, t'io̱o mé tsojmì xi tsjá‑nò. Jè xi̱ta̱ xi síxá mochjeén‑né nga k'oi̱‑la̱ chjí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","K'e̱ nga kijchoò jngoò na̱xa̱ndá ñánda tsjá'nde‑nò, chi̱ne̱e mé tsojmì xi tsjá‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tsà tjín xi̱ta̱ xi xk'én, ti̱ndaà‑nò; koa̱tìn‑là: “Jye kjòchrañàt'aà‑nò nga jcha̱a kó s'ín otíxoma Nainá.” ");
INSERT INTO maaNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tsà jngoò na̱xa̱ndá ñánda kijchoò, tsà mìkiì tsjá'nde‑nò, ti̱tjáyaà ndi̱yá, koa̱tìn‑là: ");
INSERT INTO maaNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Skanda jè chijo‑la̱ na̱xa̱ndá‑nò xi kàtsobà'ñó ndso̱koò‑je̱n, kítsajneè‑nòje̱n koni jngoò seña nga mì ti̱ kiì si̱s'in‑nòje̱n. Ta̱nga kàtasijiìn‑nò nga jye kjòchrañàt'aà‑nò nga jcha̱a kó s'ín otíxoma Nainá.” ");
INSERT INTO maaNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","K'oa̱á xán‑nò, na̱xa̱ndá jè, ìsa̱á tse kjo̱'in s'e̱‑la̱ jè na̱chrjein k'e̱ nga si̱ndaàjiìn‑la̱ xi̱ta̱, mì k'oa̱á‑ne koni jñà xi̱ta̱ ts'e̱ na̱xa̱ndá Sodoma. ");
INSERT INTO maaNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡I̱ma̱ xó‑nò jñò, xi̱ta̱ na̱xa̱ndá Corazín! ¡I̱ma̱ xó‑nò jñò, xi̱ta̱ na̱xa̱ndá Betsaida! Tsà ya̱‑làne na̱xa̱ndá Tiro ko̱ Sidón nga k'oa̱s'ín kis'iaàn kjo̱xkón xi ndaà tjín xi komà ya̱ i̱jiìn na̱xa̱ndá tsa̱jòn, tsà jñà xi̱ta̱ Tiro ko̱ Sidón kijtseè, jyeé‑la nikje naxá íkjá ko̱ chijo ni'ín títsa̱jiìn koni seña nga jye kisìkájno jé‑la̱ nga mì ti̱ jé ótsji‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ta̱nga jè na̱chrjein nga si̱ndaàjiìn, ìsa̱á tse kjo̱'in s'e̱‑nò mì k'oa̱á‑ne koni jñà xi̱ta̱ na̱xa̱ndá Tiro ko̱ Sidón. ");
INSERT INTO maaNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jñò xi xi̱ta̱ na̱xa̱ndá Capernaum tsa̱jòn, ¿a k'oa̱á s'ín mokjeiín‑nò nga jcha̱xkón‑nò ján ngajmiì? Majìn, ya̱á ki̱tsa̱jnajñoò i̱'nde ñánda tjín kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Jè xi 'nchré‑nò, 'a̱án xi 'nchré‑na; jè xi ko̱chrjengui‑nò, 'a̱án xi ochrjengui‑na; jè xi ko̱chrjengui‑na, jè ochrjengui xi kisìkasén‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","J'iì‑ne jñà xi̱ta̱ xi jàn‑kaàn ko̱ te ma‑ne. 'Ñó tsja tjín‑la̱, kitsò: ―Na̱'èn, xi i̱t'aà tsi̱ji, skanda jñà ini̱ma̱ ch'o‑la̱ nei̱í síkitasòn‑naje̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús kitsò‑la̱: ―Kixi̱í kjoa̱, kìjtseè‑ná jè xi̱ta̱ nei̱í koni kji ni'ín ch'o̱ón kji nga kiskaàngui i̱t'aà ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","'A̱n, jyeé kitsjaà‑nò kjo̱tíxoma ko̱ nga'ñó nga ko̱ma ki̱nchanè ye̱ ko̱ cho̱ na'yá, nga si̱kijneè‑là ngats'iì nga'ñó‑la̱ xi̱ta̱ nei̱í xi kondra̱ tsa̱jòn; ni̱mé xi ch'o si̱ìko̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ta̱nga kì matsja‑nò nga jè ini̱ma̱ ch'o‑la̱ xi̱ta̱ nei̱í síkitasòn‑nò; jè xi kàtatsja‑nò nga jye tjín‑nò i̱'nde ján ngajmiì nga jyeé ya̱ tjít'aà 'ín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ti̱jè‑ne hora, Jesús, tsjaá komà‑la̱ xi i̱t'aà ts'e̱ Ini̱ma̱ Tsjeè‑la̱ Nainá; kitsò: ―Na̱'èn, xi tsi̱ji ngajmiì ko̱ tsi̱ji i̱sò'nde, tsjaà‑lè kjo̱ndaà nga jñà kjoa̱ koi tsibì'ma‑la̱ jñà xi̱ta̱ xi tjín‑la̱ kjoa̱chji̱ne̱ ko̱ xi 'ñó tjín‑la̱ kjo̱hítsjeèn nga jñà tsakoò‑la̱ xi ta̱xki̱ ndí xi̱ta̱ i̱ma̱ kjoa̱. Jon, Na̱'èn, nga k'oa̱á s'ín kjòmejèn‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Ngats'iì kjoa̱ ts'e̱ kjo̱tíxoma, 'a̱án kisìnga̱tsja‑na Na̱'èn‑na̱. Mìtsà yá xi beèxkon yá‑né xi Ki'ndí‑la̱ ma, ta̱jngoò jè xi Na̱'èn ma; ti̱koa̱á mìtsà yá xi beèxkon yá‑né xi Na̱'èn ma, ta̱jngoò jè xi Ki'ndí‑la̱ beèxkon, ko̱ jè Ki'ndí‑la̱ ko̱kò‑la̱ jñà xi̱ta̱ xi jè mejèn‑la̱ nga skoe̱xkon, yá‑né xi Na̱'èn ma. ");
INSERT INTO maaNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jesús kisìkáfaya'a xi̱ta̱ xi kota'yàt'aà‑la̱, tà jñà kiìchja̱t'aà xìn‑la̱, kitsò‑la̱: ―Mé tà ndaà‑la̱ jñà xi̱ta̱ xi xko̱n nchibeè‑ne koni s'ín titsa̱'yaà jñò. ");
INSERT INTO maaNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","K'oa̱á xán‑nò, kjìn xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, ti̱koa̱ kjìn xi̱ta̱xá ítjòn xi kjòmejèn‑la̱ nga skoe̱ jè kjoa̱ xi jñò titsa̱'yaà, ta̱nga mìkiì kijtseè; ti̱koa̱á kjòmejèn‑la̱ nga kji̱'nchré jè xi titsa̱na'yà, ta̱nga mìkiì kiì'nchré. ");
INSERT INTO maaNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jngoò xi̱ta̱ chji̱ne̱ xo̱jo̱n ts'e̱ kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés kiìkon Jesús nga mejèn‑la̱ skóna̱cha̱n‑la̱, kitsò: ―Maestro, ¿mé kjo̱ndaà xi s'iaàn nga kíjnakon ini̱ma̱‑na̱ ni̱ta̱ mé na̱chrjein‑ne? ");
INSERT INTO maaNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús kitsò‑la̱: ―¿Mé xi tjít'aà jè xo̱jo̱n ts'e̱ kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés? ¿Kó tsò xi bìxke̱jiìn? ");
INSERT INTO maaNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jè xi̱ta̱ chji̱ne̱ xo̱jo̱n kitsò: ―“Ti̱tsjachi Na̱'èn‑ná xi Nainá 'mì‑la̱ nga ko̱ ini̱ma̱‑lè, ko̱ nga'ñó‑lè, ko̱ kjo̱hítsjeèn‑lè; koa̱ ti̱s'ín ti̱tsjachi xi̱ta̱ xingui̱i koni tsà ti̱ yijo tsi̱ji‑ne.” ");
INSERT INTO maaNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús kitsò‑la̱: ―Ndaà kànokjoì. Tsà k'oa̱s'ín s'i̱in, ki̱jnakon‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jè xi̱ta̱ chji̱ne̱ xo̱jo̱n mejèn‑la̱ nga ndaà si̱ìkíjna yijo‑la̱ 'én xi kiskònangui; ìjngoò k'a kiskònangui‑la̱ Jesús, kitsò: ―¿Yá‑né xi xi̱ta̱ xinguia̱a? ");
INSERT INTO maaNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús kitsò: ―Jngoò xi̱ta̱ tífìjen ján ndi̱yá Jerusalén skanda Jericó. Ya̱ i̱ya ndi̱yá tsibíchjoà‑la̱ xi̱ta̱ chijé. Tsafaá'an tsojmì‑la̱ ko̱ nikje‑la̱. 'Ñó kisìki'on. I̱kjoàn ya̱á kisìkájna k'en ya̱ i̱ya ndi̱yá. ");
INSERT INTO maaNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ti̱jè‑ne ndi̱yá, k'e̱ chi̱ba̱‑la̱ jahajen jngoò no̱'miì, ta̱nga k'e̱ nga kijtseèxkon nga ya̱ kjinaya ndi̱yá xi̱ta̱ xi kitsì'on, tà jahat'aà xìn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ti̱k'e̱é‑ne ja jngoò xi̱ta̱ levita xi i̱ya i̱ngo̱ síxá k'oa̱á ti̱ kis'iìn k'e̱ nga kijtseèxkon xi̱ta̱ jè nga kjinaya ndi̱yá; ti̱koa̱á tà jahat'aà xìn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ta̱nga k'e̱ nga ijchò jngoò xi̱ta̱ Samaria xi xi̱ta̱ kondra̱‑la̱ xi̱ta̱ judío nga koa̱ ti̱s'ín tífì ndi̱yá jè, k'e̱ nga kijtseèxkon, kjòhi̱ma̱keè‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kiì kasìt'aà chrañà‑la̱. Kisìxkiì‑la̱; kisìkaàjno asìti̱ ko̱ xán ñánda kitiì‑la̱. I̱kjoàn tsibíjtéjiìn; kisìkíjnasòn‑la̱ kohòyo̱‑la̱; kiìko̱ jngoò ni'ya ñánda nga ma nìkjáyaá. Jè kisìkinda̱. ");
INSERT INTO maaNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Xi komà inchijòn k'e̱ nga jye tífì‑ne jè xi̱ta̱ Samaria, tsibíchjí‑la̱ nei‑la̱ ni'ya, kitsjaà‑la̱ to̱n koni tjín chjí‑la̱ chi̱'nda xi jò na̱chrjein; kitsò‑la̱: “Ti̱kinda̱‑ná xi̱ta̱ jè. K'e̱ nga kjoi̱ ìjngoò k'a‑na kíchjiá tsà ìsa̱ tse si̱ìkje.” ");
INSERT INTO maaNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ngaji̱, ¿kó si? Ingajàn xi̱ta̱ koi, ¿yá‑né xi xíkjín jè xi̱ta̱ xi kisìki'on chijé? ");
INSERT INTO maaNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jè xi̱ta̱ chji̱ne̱ xo̱jo̱n kitsò: ―Jè xi xíkjín, jè xi̱ta̱ xi kjòhi̱ma̱keè. Jesús kitsò‑la̱: ―Ngaji̱, k'oa̱á ti̱s'ín t'i̱in. ");
INSERT INTO maaNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús k'e̱ nga tjímaya‑ìsa i̱ya ndi̱yá, ijchò jngoò ndí na̱xa̱ndá jtobá ñánda tíjna ni'ya‑la̱ chjo̱ón xi 'mì Marta. Ya̱á kitsjaà'nde‑la̱ nga tsibìjna. ");
INSERT INTO maaNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jè Marta tíjna ìjngoò‑ìsa chjo̱ón ndichja xi 'mì María. Jè María tsibìjnat'aà ndso̱ko̱ Jesús nga kiì'nchré‑la̱ 'én xi tíbéno̱jmí. ");
INSERT INTO maaNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ta̱nga jè Marta, 'ñó tísíkájno xá xi tjín‑la̱. Kiì kasìt'aà‑la̱ Jesús, kitsò‑la̱: ―Na̱'èn, ¿a mì makájno‑lè nga jè xinguia̱a ta̱jngoò síkíjna‑na nga s'iaàn xá? Ko̱t'ìn‑la̱ kàtasíchját'aà‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús kiìchja̱ kitsò‑la̱: ―Marta, Marta, tsí ndaà nìkájnoi, tsí ndaà bìnè‑la̱ xá yijo‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tà jngoò kjoa̱ xi 'ñó mochjeén. Jè María ndaà tjín xi kòfaájiìn; ni̱yá xi kjoa̱áxìn‑la̱ kjoa̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jngoò k'a, Jesús tíjna jngoò i̱'nde ñánda tíchja̱t'aà‑la̱ Nainá; k'e̱ nga jye kiìchja̱t'aà‑la̱, jngoò xi̱ta̱ xi kota'yàt'aà‑la̱ kitsò‑la̱: ―Na̱'èn, ta̱kóya‑náje̱n kó s'ín ki̱nókjoa̱t'aà‑la̱je̱n Nainá koni s'ín kis'iìn Juan nga tsakóya‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús kitsò‑la̱: ―K'e̱ nga ki̱nókjoa̱t'aà‑là, k'oa̱á s'ín tixón: Na̱'èn xi tijni ngajmiì, kàtayaxkón‑la̱ kjoa̱jeya‑lè nga tsjeè tijni. Kàtjanchrobá kjo̱tíxoma‑lè. K'oa̱s'ín kàtama i̱ i̱t'aà nangui koni s'ín mejèn‑lè nga ko̱ma, koni s'ín ma ján ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tjiì kjit'aà‑náje̱n ni̱ño̱ xi mochjeén‑naje̱n nga na̱chrjein inchijòn. ");
INSERT INTO maaNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ti̱jchàat'aà‑náje̱n jé‑na̱je̱n koni s'ín nìjchàat'aà‑la̱je̱n ngats'iì xi̱ta̱ xi ch'o síko̱‑naje̱n. Kì kiì biì'ndi yá xi mejèn‑la̱ nga kot'aà‑naje̱n nga ki̱nchátsji jé‑je̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús kitsò‑ìsa‑la̱: ―Jñò, tsà tjín jngoò‑nò amigo, tsà osen ni̱tje̱n onguíchoòn, tsà k'oín‑là: “Amigo, ti̱kìña jàn‑ná i̱nchra̱jín‑lè, ");
INSERT INTO maaNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","jngoò amigo‑na̱ kòf'iìkon‑na koa̱ tsjìn‑na mé xi tsjaà‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tsà jè amigo xi tíjna i̱nga ni'ya, tsà ki̱tso̱: “Kì 'a̱n nìjti‑ná. Jè xotjoa̱ ni'ya jyeé tíchjoàjto. Jñà ndí i̱xti‑na̱ ko̱ 'a̱n jyeé kinìkjáya‑je̱n. Mìkiì ko̱ma kósi̱tje̱en nga tsjaà‑lè tsojmì xi mochjeén‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","K'oa̱á xán‑nò, na̱s'ín majìn‑la̱ nga osítje̱n nga amigo tsa̱jòn, tsà 'ñó si̱siì‑là, chaán ko̱sítje̱n. Tsjá yije mé xi mejèn‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","’K'oa̱á xan‑nò: Ti̱jé mé xi mejèn‑nò, jè Nainá tsjá‑nò; ti̱nchátsjioò Nainá, sakó‑nò; ti̱nókjoa̱t'aà‑là Nainá mé xi mejèn‑nò mé‑ne skíx'a̱'nde‑nò koni jngoò xotjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ngats'iì xi̱ta̱ xi síjé, tjoé‑la̱, jè xi ótsji, sa̱kò‑la̱ ko̱ jè xi chja̱t'aà‑la̱ Nainá, tjáx'a̱'nde‑la̱ koni jngoò xotjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Jñò xi na̱'èn 'mì‑nò, tsà i̱nchra̱jín si̱ìjé‑nò i̱xti‑nò, ¿a nda̱jo̱ó k'oi̱‑là? Majìn. Koa̱ tsà ti̱n si̱ìjé‑nò, ¿a ye̱é k'oi̱‑là? Majìn. ");
INSERT INTO maaNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tsà chjo̱ó si̱ìjé‑nò, ¿a cho̱ na'yá k'oi̱‑là? Majìn. ");
INSERT INTO maaNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jñò, na̱s'ín xi̱ta̱ xi ch'o 'nè, ma‑nò 'biì‑là i̱xti‑nò tsojmì xi ndaà kjoàn; jè Na̱'èn‑nò xi tíjna ngajmiì, ìsa̱á ni̱to̱n si̱ìs'in‑nò nga tsjá‑nò Ini̱ma̱ Tsjeè‑la̱ tsà jñò si̱jét'aà‑là. ");
INSERT INTO maaNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús, tíhochrjejiìn ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ jngoò xi̱ta̱ xi mìkiì ma chja̱. Xi̱ta̱ jè, k'e̱ nga jye itjokàjiìn jè ini̱ma̱ ch'o‑la̱ nei̱í, komà kiìchja̱‑ne. Jñà xi̱ta̱ xi nchikotsejèn, tà kjòxkón‑la̱ jè kjoa̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ta̱nga tjín i'nga xi̱ta̱ xi kitsò: ―Jè xi̱ta̱ sko̱‑la̱ xi̱ta̱ nei̱í xi 'mì Beelzebú, jè tsjá‑la̱ nga'ñó nga k'oa̱s'ín ochrjekàjiìn ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tjín i'nga xi̱ta̱ xi mejèn‑la̱ skót'aà tsà kixi̱ kjoa̱ nga Nainá kisìkasén Jesús; kisìjé jngoò‑la̱ seña xi jeya tjín xi i̱t'aà ts'e̱ Nainá nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús, ti̱k'e̱é kijtseèya‑la̱ koni s'ín nchisíkítsjeèn xi̱ta̱ koi, kitsò‑la̱: ―Ngats'iì na̱xa̱ndá xi jòya tjín nga kondra̱ títsa̱jna‑la̱ xíkjín, ti yijo‑la̱á tísíkixòña‑ne; ti̱koa̱á tsà jngoò ni'ya xi̱ta̱ xi jòya tjín nga kondra̱ títsa̱jna‑la̱ xíkjín ti̱koa̱á jngoò k'a tsjohoba xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tsà ti̱koa̱ jè xi̱ta̱ nei̱í, tsà jòya tís'ín xi ti̱jè‑ne yijo‑la̱. ¿Kós'ín ko̱ma s'e̱‑la̱ nga'ñó nga ko̱tìxoma? Jñò, bixón‑nò nga 'a̱n, ko̱ó nga'ñó‑la̱ Beelzebú ochrjekàjñaà ini̱ma̱ ch'o‑la̱ nei̱í. ");
INSERT INTO maaNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tsà k'oa̱s'ín tjín kjoa̱, jñà xi̱ta̱ tsa̱jòn, ¿yá xi tsjá‑la̱ nga'ñó k'e̱ nga ochrjekàjiìn nei̱í? Koií kjoa̱‑la̱, ti̱jñà‑ne xi̱ta̱‑nò ke̱èno̱jmí nga mìtsà kixi̱ kjoa̱ nga jè sko̱‑la̱ nei̱í sìkjeén. ");
INSERT INTO maaNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ta̱nga 'a̱n, k'e̱ nga ochrjekàjñaà ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ xi̱ta̱, jè Nainá tsjá‑na nga'ñó. Jè kjoa̱ koi tsòyaá‑ne nga Nainá, jyeé i̱ tíhotíxoma i̱ i̱t'aà nangui. ");
INSERT INTO maaNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’K'e̱ nga jngoò xi̱ta̱ xi tjín‑la̱ nga'ñó ko̱ tjín‑la̱ ki̱cha̱, ko̱ ndaà síkinda̱ ni'ya‑la̱, ndaà jncha tsojmì xi tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ta̱nga tsà kjoi̱í jngoò xi kj'ei̱í xi̱ta̱ xi ìsa̱ tse nga'ñó tjín‑la̱, si̱ìkijne‑la̱, kjoa̱á'an yije ki̱cha̱ xi ma'ñót'aà takòn, i̱kjoàn si̱ìjòya yije tsojmì xi tjín‑la̱; kji̱ko̱‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Ni̱to̱n yá xi̱ta̱‑ne xi mì 'a̱n fìt'aà‑na, jè‑né xi kondra̱‑na̱; koa̱ ni̱ta̱ yá xi̱ta̱‑ne xi mìkiì síchját'aà‑na nga bíxkóyako̱‑na xi̱ta̱ xi ts'a̱n ko̱ma, jè tísítsjohoba xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’K'e̱ nga jngoò ini̱ma̱ ch'o‑la̱ nei̱í bitjokàjiìn ini̱ma̱‑la̱ jngoò xi̱ta̱, ya̱á ojmeè i̱'nde ñánda kixì choòn, ótsji'nde nga si̱ìkjáya. K'e̱ nga mìkiì sakó'nde‑la̱, ìjngoò k'a síkítsjeèn, tsò: “Kjín‑la ìjngoò k'a‑na̱ ni'ya‑na̱ ñánda inchrobà‑na.” ");
INSERT INTO maaNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","K'e̱ nga bijchó ìjngoò k'a‑ne ni'ya‑la̱, beè nga ndaà kisatiìcha ko̱ tsjeè choòn. ");
INSERT INTO maaNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","I̱kjoàn fìkjaá nguì itoò xíkjín xi ìsa̱ ch'o s'ín. K'e̱é fahas'en‑jiìn ini̱ma̱‑la̱ xi̱ta̱ jè; ya̱á bìtsa̱jna. Xi̱ta̱ jè, ìsa̱á 'ñó ch'o bìjna koni s'ín tsibìjna nga sa̱ ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ti̱k'e̱‑né nga tíbéno̱jmí Jesús jñà kjoa̱ koi, kiìchja̱ jngoò chjo̱ón xi ya̱ tíjnajiìn‑la̱ xi̱ta̱ kjìn, 'ñó kiìchja̱, kitsò: ―¡Mé tà ndaà‑la̱ jè chjo̱ón xi kisìkatsejèn‑lè i̱sò'nde ti̱koa̱ kisìkaki‑lè! ");
INSERT INTO maaNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús kitsò: ―¡Ìsa̱á ndaà‑la̱ jñà xi̱ta̱ xi 'nchré 'én‑la̱ Nainá, ti̱koa̱ síkitasòn! ");
INSERT INTO maaNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","K'e̱ nga jye kòkjìn xi̱ta̱ ñánda tíjna Jesús, tsibíts'ia̱ nga kitsò: ―Xi̱ta̱ xi tjín na̱chrjein i̱'ndei̱, ch'oó s'ín; síjé jngoò seña xi i̱t'aà ts'e̱ Nainá, ta̱nga ni̱jngoò seña skoe̱. Tà jè skoe̱ seña ts'e̱ Jonás. ");
INSERT INTO maaNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Koni s'ín komàt'in Jonás, jñà xi̱ta̱ na̱xa̱ndá Nínive kijtseè jngoò kjo̱xkón xi ndaà tjín, 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, k'oa̱á ti̱s'ín tjín jè kjoa̱ xi sa̱ ko̱mat'ian; jñà xi̱ta̱ xi tjín i̱'ndei̱ skoe̱é kjo̱xkón xi ndaà tjín. ");
INSERT INTO maaNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jè chjo̱ón ítjòn xi ya̱ otíxoma nangui sur, ko̱sítje̱n‑né jè na̱chrjein k'e̱ nga koi̱ìndaàjiìn Nainá; jè tsját'in 'én jñà xi̱ta̱ xi tjín na̱chrjein i̱'ndei̱, koií kjoa̱‑la̱ nga kjiìn nangui j'iì‑ne nga j'iì 'nchré‑la̱ kjoa̱chji̱ne̱‑la̱ Salomón; ta̱nga na̱chrjein i̱'ndei̱, 'a̱n xi tìchjàko̱‑nò, ìsa̱á 'ñó jeya tìjna̱a mì k'oa̱á‑ne koni Salomón. ");
INSERT INTO maaNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jñà xi̱ta̱ na̱xa̱ndá Nínive ko̱sítje̱n‑né jè na̱chrjein k'e̱ nga koi̱ìndaàjiìn Nainá; jñà tsját'in 'én jñà xi̱ta̱ xi tjín na̱chrjein i̱'ndei̱, koií kjoa̱‑la̱ nga kisìkájno jé‑la̱ nga mì ti̱ jé tsohótsji‑ne k'e̱ nga kiìchja̱ya 'én‑la̱ Nainá Jonás; ta̱nga na̱chrjein i̱'ndei̱, 'a̱n xi tìchjàko̱‑nò, ìsa̱á 'ñó jeya tìjna̱a mì k'oa̱á‑ne koni Jonás. ");
INSERT INTO maaNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Ni̱jngoò xi̱ta̱ xi síkíjna'ma k'e̱ nga jngoò ni'ín bít'a'í. Mìtsà kaxa̱ síkíjnangui; síkíjna'nga‑né, candelero síkíjnaya mé‑ne nga ko̱hiseèn yije‑la̱ xi̱ta̱ xi fahas'en ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jñà xkoaán, jè ma ni'ín xi síhiseèn‑la̱ yijo‑ná; k'e̱ nga ndaà tsejèn‑ná, iseèn choòn yije‑la̱ yijo‑ná; ta̱nga tsà mìkiì ndaà tsejèn‑la̱ xkoiìn, jñò choòn‑la̱ yijo‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ndaà chítsejìn, ¿a ndaà tíjna ini̱ma̱‑lè? ¿A iseèn choòn‑la̱? ¿A xi jñò choòn‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tsà iseèn choòn kóho̱kji yijo‑lè, tsà mì ñánda tjít'aà xi jñò choòn, ndaà ko̱tsejìn k'oa̱á ngaya‑la̱ koni tsà jngoò ni'ín xi 'ñó títì tísíhiseèn‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","K'e̱ nga jye kiìchja̱ Jesús, jngoò xi̱ta̱ fariseo kiìchja̱‑la̱ nga mejèn‑la̱ ko̱kje̱n‑ko̱ ya̱ ni'ya‑la̱. K'e̱ nga jahas'en ni'ya Jesús, tsibìjnat'aà ími̱xa̱. ");
INSERT INTO maaNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jè xi̱ta̱ fariseo, tà k'oa̱á komà‑la̱ nga kijtseè nga jè Jesús, mìkiì kisìhitasòn kjo̱tíxoma xi xkón tjín, mìkiì tsaníjno tsja nga tsakjèn. ");
INSERT INTO maaNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kiìchja̱ Na̱'èn‑ná Jesucristo, kitsò‑la̱: ―Jñò, xi xi̱ta̱ fariseo 'mì‑nò, onìjnoò chi̱tsín‑nò ko̱ chro̱ba̱‑nò ya̱ i̱sò'nga‑la̱, ta̱nga i̱jiìn ini̱ma̱‑nò, 'ñó fahajiìn‑nò nga chjaà'an‑là tsojmì‑la̱ xi̱ta̱ xi kj'ei̱í ti̱koa̱á binchaàtsjioò kjoa̱ xi ch'o tjín. ");
INSERT INTO maaNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Jñò xi xi̱ta̱ tòndo̱ 'mì‑nò. ¿A mì tíjiìn‑nò: Nainá, k'e̱ nga tsibíndaà i̱sò'nga yijo‑la̱ xi̱ta̱, ti̱koa̱á ti̱jè‑ne xi tsibíndaà ini̱ma̱‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tjiì‑là xi̱ta̱ i̱ma̱ kjo̱ndaà xi tíjiìn ini̱ma̱‑nò mé‑ne nga tsjeè ki̱tsa̱jnaà nguixko̱n Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡I̱ma̱ xó‑nò xi xi̱ta̱ fariseo 'mì‑nò! Nga ma‑nò bíchjí‑là Nainá xi teya oko̱‑la̱ ts'e̱ xka̱ menta ko̱ xka̱ ruda ngats'iì xka̱ xi ma chine, ta̱nga mìkiì kjoa̱ kixi̱ nìko̱o xi̱ta̱; mìkiì tjòcha 'yaà Nainá. Koií kjoa̱ xi 'ñó mochjeén nga ki̱tasòn; ti̱koa̱á mochjeén‑né nga ki̱tasòn jñà kjoa̱ xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡I̱ma̱ xó‑nò xi xi̱ta̱ fariseo 'mì‑nò! Nga mejèn‑nò nga jñò ki̱tsa̱nè íxi̱le̱ xi jncha ítjòn ya̱ ni'ya i̱ngo̱ sinagoga, ti̱koa̱á mejèn‑nò nga skoe̱xkón‑nò xi̱ta̱ xi kj'ei̱í, ndaà si̱ìxat'aà‑nò ya̱ ndi̱tsi̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡I̱ma̱ xó‑nò jñò xi̱ta̱ xi okoòya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés ko̱ xi xi̱ta̱ fariseo 'mì‑nò xi jò ma i̱sén‑nò! K'oa̱s'ín titsjoò koni kjoàn nga̱jo̱‑la̱ mik'en nga mìkiì tsejèn; k'e̱ nga binchimasòn xi̱ta̱, mìkiì beè mé xi jnchaya. ");
INSERT INTO maaNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","K'e̱é kitsò jngoò jñà xi̱ta̱ chji̱ne̱ xo̱jo̱n: ―Maestro, k'e̱ nga k'oa̱s'ín nokjoì, ti̱koa̱á 'on nokjoàko̱‑náje̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús kitsò: ―Ti̱koa̱á, ¡i̱ma̱ xó‑nò jñò xi xi̱ta̱ chji̱ne̱ xo̱jo̱n 'mì‑nò! Nga bìnè‑là kjo̱tíxoma‑nò xi̱ta̱ xi kj'ei̱í xi 'ñó 'in tjín nga mìkiì chíkjoa̱‑la̱ nga síkitasòn, ta̱nga jñò, ni̱ i̱tsé nìchját'aà‑là. ");
INSERT INTO maaNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡I̱ma̱ xó‑nò xi bìndaà chrjó‑la̱ mik'en ts'e̱ jñà xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá! Jñà xi̱ta̱ jchínga‑nò kisìk'en. ");
INSERT INTO maaNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","K'oa̱á s'ín bitjo kixi̱ kjoa̱ nga tíjngoò‑takòn nga xi̱ta̱ jchínga tsa̱jòn kisìk'en xi̱ta̱ koi, koa̱ jñò, bìndaà chrjó‑la̱ mik'en. ");
INSERT INTO maaNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Xi kjo̱hítsjeèn ts'e̱ Nainá kitsò‑né xi i̱t'aà ts'e̱ xi̱ta̱ jchínga‑nò ko̱ tsa̱jòn: “Siìkasén xi̱ta̱ xi ki̱chja̱ ngajo‑na̱ ko̱ xi̱ta̱ xi 'a̱n kotiìxáya‑la̱; ta̱nga tjín xi si̱k'en koa̱ tjín xi kondra̱ kjoi̱ tji̱ngui‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nainá kinda̱á si̱ìjé‑la̱ jñà xi̱ta̱ xi tjín i̱'ndei̱, jní xi kixíxteèn ngats'iì xi̱ta̱ xi k'en xi kiìchja̱ ngajo‑la̱ Nainá skanda k'e̱ nga ti̱sa̱ kisindaà i̱sò'nde; ");
INSERT INTO maaNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mats'ia̱ko̱‑ne Abel xi̱ta̱ xi k'en ítjòn skanda jè Zacarías xi jyehet'aà‑ne nga k'en; jè xi̱ta̱ xi k'en ya̱ i̱'nde jngoò osen‑la̱ ñánda tíjna Ni'ya Tsjeè‑la̱ Nainá ko̱ ñánda binchásòn kjo̱tjò xi tsjá‑la̱ Nainá jñà xi̱ta̱. K'oa̱á xán‑nò, jè Nainá si̱ìjé‑la̱ kinda̱ jñà xi̱ta̱ xi tjín i̱'ndei̱. ");
INSERT INTO maaNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡I̱ma̱ xó‑nò jñò xi̱ta̱ xi okoòya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés! Binchachjoà‑là xi̱ta̱ xi kj'ei̱í nga mìkiì kjoa̱has'en‑jiìn‑la̱ kjoa̱ chji̱ne̱‑la̱ Nainá; jñò, mìkiì bitjaàs'en‑jñoò ko̱ mìkiì biì'nde‑là xi kj'ei̱í xi̱ta̱ nga fahas'en‑jiìn kjoa̱ chji̱ne̱‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","K'e̱ nga jye o̱kitsò Jesús jñà 'én koi, jñà xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá ko̱ xi̱ta̱ fariseo 'ñó tsibít'aà‑la̱ nga kjìn sko̱ya kjoa̱ kiskònangui‑la̱, ");
INSERT INTO maaNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ti̱koa̱ kisìkinda̱ nga skoe̱ mé 'én xi ki̱chja̱‑ìsa mé‑ne nga ko̱ma ko̱hòngui‑ne i̱t'aà ts'e̱ xi̱ta̱xá. ");
INSERT INTO maaNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","K'e̱ nga jye 'ñó kjìn jmiì kòkjìn xi̱ta̱, chi̱ba̱‑la̱ otíjno, otít'aà xíkjín, tsibíts'ia̱ Jesús nga kiìchja̱ ítjòn‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱; kitsò‑la̱: ―Ti̱kinda̱a yijo‑nò i̱t'aà ts'e̱ xi̱ta̱ fariseo xi jò i̱sén tjín‑la̱; kì k'oa̱á s'ín ko̱mat'ioòn koni ma na̱'yo̱ san nga sísan xíkjín k'e̱ nga ótijiìn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nì mé tjín xi tíjtsa'ma xi mìkiì ko̱tsejèn; ngats'iì xi tjí'ma, jcha̱á‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ngats'iì kjoa̱ xi ki̱nókjoa̱'maà k'e̱ nga ni̱tje̱n, kji̱'nchré yije xi̱ta̱ k'e̱ nga na̱chrjein; jè kjoa̱ xi ya̱ ki̱nókjoa̱'maà i̱ya ni'ya‑nò, ján i̱sò'nga ni'ya, 'ñó ki̱ná'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Jñò xi amigo ts'a̱n xan‑nò, kì tsakjoòn‑là jñà xi ma‑la̱ sík'en yijo‑ná; k'e̱ nga jye ma, ni̱ ti̱ mé xi síko̱‑ìsa‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","'A̱n, k'oa̱ xán‑nò yá xi ki̱skón‑là; jè xi ti̱skón‑là, jè xi ma‑la̱ sík'en‑ná, i̱kjoàn tjí'nde‑la̱ nga síkatje̱n‑jiìn‑ná ñánda títì ni'ín xi ts'e̱ kjo̱'in. K'oa̱á xan‑nò, jè xi ti̱skón‑là. ");
INSERT INTO maaNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’K'e̱ nga 'òn ndí ni̱se, sa̱á jò to̱n satíjna‑ne. Ta̱nga Nainá, tjín‑la̱ kinda̱. Ni̱jngoò ni̱se síjchàajiìn. ");
INSERT INTO maaNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Xi i̱t'aà tsa̱jòn, ìsa̱á 'ñó tse chjí‑nò mì k'oa̱á‑ne koni na̱s'ín 'ñó kjìn ma ni̱se. Skanda tsja̱skoò tíxke̱ya yije‑la̱ Nainá. Kì tsakjoòn‑jèn, nga Nainá 'ñó ndaà s'ín‑nò kinda̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ngats'iì xi̱ta̱ xi tsjá 'én nga nguixko̱n xi̱ta̱ nga 'a̱n fìt'aà‑na, ti̱koa̱á 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, tsjaà‑la̱ 'én jñà àkja̱le̱‑la̱ Nainá nga xi̱ta̱ ts'a̱n xan‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ta̱nga jè xi kjójna'mat'in‑na nga nguixko̱n xi̱ta̱, ti̱koa̱á si̱'mat'in‑né nga nguixko̱n àkja̱le̱‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Ngats'iì xi̱ta̱ xi ch'o tsò 'én xi ki̱chja̱jno‑na 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, jcha̱t'aà‑la̱ jé‑la̱; ta̱nga jñà xi ki̱chja̱jno‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá mìkiì jcha̱t'aà‑la̱ jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Jñò, k'e̱ nga kji̱ko̱‑nò xi̱ta̱ ya̱ ni'ya i̱ngo̱ sinagoga, ya̱ nguixko̱n xi̱ta̱ ítjòn ko̱ ts'e̱ xi̱ta̱xá, kì makájno‑nò kó s'ín kixón nga ko̱si̱ko̱ yijo‑nò mé 'én xi ki̱nókjoa̱a. ");
INSERT INTO maaNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","K'e̱ nga ki̱jchò hora nga ki̱nókjoa̱a, jè Ini̱ma̱ Tsjeè‑la̱ Nainá, ke̱èno̱jmíya‑nò kó s'ín kixón. ");
INSERT INTO maaNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jngoò xi̱ta̱ xi ya̱ tíjnajiìn‑la̱ xi̱ta̱ kjìn, kitsò‑la̱ Jesús: ―Maestro, ko̱t'ìn‑la̱ jè 'ndsè kàtasíjòya tsojmì‑la̱ xi̱ta̱ jchínga‑na̱je̱n; xi 'a̱n oko̱‑na, kàtatsjá‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ta̱nga jè Jesús kitsò‑la̱: ―Ji̱ amigo, mìtsà xi̱ta̱xá tjín‑na nga 'a̱n sìjòya‑nò tsojmì xi tsa̱jòn. ");
INSERT INTO maaNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jesús ti̱koa̱á kitsò‑ìsa‑la̱: ―Chítsejèn, ti̱koa̱ t'e̱en kinda̱ yijo‑nò; kì 'ñó kjìn tsojmì binchaàtsjioò i̱ i̱sò'nde; nga jngoò xi̱ta̱, na̱s'ín 'ñó kjìn tsojmì tjín‑la̱, mìkiì si̱ìkíjnakon tsojmì‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ti̱koa̱á tsibéno̱jmí jngoò‑la̱ kjoa̱ xi mangásòn; kitsò‑la̱: ―Jngoò k'a jngoò xi̱ta̱ xi 'ñó nchi̱ná, 'ñó kjìn tsojmì kòjchásòn nangui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Xi̱ta̱ jè, kisìkítsjeèn; kitsò: “¿Mé xi s'iaàn? Tsjìn‑na ñánda ki̱nchaàxkoá tsojmì‑na.” ");
INSERT INTO maaNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","K'e̱é kitsò: “Jyeé be mé xi s'iaàn. Siìkixòña ni'nga‑na̱, i̱kjoàn kìndaà‑ìsa xi ìsa̱ iì kjoàn; ya̱á ki̱nchaàxkoá yije kóho̱tjín tsojmì xi kòjchá‑na ko̱ xi tjín‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","I̱kjoàn xán‑la̱ yijo‑na̱: Kjìn tsojmì 'nchaxkó‑na. Kjìn nó ko̱ma‑la̱; siìkjáya, kókje̱en, skia̱a, siìtsjakoa̱a i̱sò'nde.” ");
INSERT INTO maaNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ta̱nga jè Nainá kitsò‑la̱: “Ji̱ xi xi̱ta̱ tòndo̱ 'mì‑lè, ni̱tje̱n jè, ki̱yá‑né. Tsojmì xi 'nchaxkó‑lè, ¿yá ts'e̱ ko̱ma?” ");
INSERT INTO maaNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","K'oa̱á s'ín mat'in jñà xi̱ta̱ xi tà tsojmì ts'e̱ yijo‑la̱ bincháxkó koa̱ mìtsà xi̱ta̱ nchi̱ná nga nguixko̱n Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nga komà i̱skan Jesús kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Koií k'oa̱ xan‑nò: kì makájno‑nò mé tsojmì xi chji̱ne̱e nga si̱jchá yijo‑nò ko̱ mé nikje xi chi̱kjá. ");
INSERT INTO maaNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ìsa̱á 'ñó tse chjí‑la̱ nga titsa̱jnakoaán i̱ i̱sò'nde koni jñà tsojmì xi ma chine. Ti̱koa̱á yijo‑ná, ìsa̱á 'ñó tse chjí‑la̱ koni jñà nikje xi chíkjá. ");
INSERT INTO maaNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Chítsejèn‑là jñà nchra̱á; mì jno̱ó 'beé, mì ni̱ji̱n bincháxkó, tsjìn‑la̱ kaxa̱ no̱jmé, ti̱koa̱ tsjìn‑la̱ ni'nga; ta̱nga jè Nainá tsjá‑la̱ tsojmì xi kine. ¡Jñò, ìsa̱á 'ñó chjí‑nò mì k'oa̱á‑ne koni jñà cho̱ xi tjímajiìn i̱sén! ");
INSERT INTO maaNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Jñò, na̱s'ín ta̱kó 'ñó si̱kájnoò, ni̱ i̱tsé ko̱ma si̱katonè‑là na̱chrjein‑nò koni s'ín tjíndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tsà mìkiì ma‑nò nìkitasòn kjoa̱ xi chiba tjín, mé‑ne nga jè nìkájno‑nò kjoa̱ xi ìsa̱ chjá tjín. ");
INSERT INTO maaNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Chítsejèn‑là naxó lirio, kó s'ín majchá; mìkiì síxá, mìkiì ma‑la̱ faña nikje; ta̱nga 'a̱n, k'oa̱á xan‑nò, ndaà tsà jè Salomón xi xi̱ta̱xá ítjòn tsibìjna nga 'ñó xi̱ta̱ jeya, mì k'oa̱á kjoàn nikje tsohòkjá koni kjoàn jñà naxó. ");
INSERT INTO maaNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nainá, k'oa̱á s'ín ndaà kjoàn s'ín xka̱ ijñá, xi jngoò na̱chrjein títsa̱jnakon ko̱ xi ma nchijòn kotsjòojiìn ni'ín. Jñò xi xi̱ta̱ 'mì‑nò xi mìkiì ndaà mokjeiín‑nò, ¿a mìtsà ìsa̱ ni̱to̱n tsjá‑nò Nainá nikje xi mochjeén‑nò nga chi̱kjá? ");
INSERT INTO maaNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jñò, kì nìkájno‑jèn; kì bixón‑jèn: “¿Mé xi chji̱ne̱é; mé xi s'ioa̱á?” ");
INSERT INTO maaNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ngats'iì xi̱ta̱ i̱sò'nde, k'oa̱á tjín tsojmì xi ótsji, ta̱nga jñò, tíjnaá‑nò Na̱'èn xi Nainá; jyeé tíjiìn‑la̱ nga ko̱tjín tsojmì xi mochjeén‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jñò, ti̱nchátsjioò kjoa̱ ts'e̱ Nainá koni s'ín otíxoma; ngats'iì tsojmì xi mochjeén‑nò ti̱koa̱á tjoésòn‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Jñò, xi ndí orrè‑na xan‑nò, kì tsakjoòn‑jèn; k'oa̱á s'ín kiskoòsòn‑la̱ Nainá nga jñò ko̱ti̱xomakjoò ya̱ ñánda tíhotíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tati̱jnaà tsojmì xi tjín‑nò; tjiì kjo̱tjò‑là jñà xi̱ta̱ xi mochjeén‑la̱; k'e̱ nga tsà k'oa̱s'ín s'e̱en, k'oa̱á ngaya‑la̱ koni tsà nchisakó ngajo‑nò chijtsa to̱n ján ngajmiì xi mìkiì majchínga; sa̱kò‑nò tsojmì xi 'ñó tse chjí‑la̱ ján ngajmiì ya̱ ñánda mìkiì kjoe̱het'aà, mìkiì bijchó chijé, ti̱koa̱ mìkiì síkje cho̱ kixo. ");
INSERT INTO maaNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ya̱ ñánda ki̱nchajtión tsojmì‑nò, ti̱koa̱á ya̱á si̱ìkítsjeèn ini̱ma̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Ndaà titsa̱jnandaà nga si̱kitasòn‑là Na̱'èn‑ná koni jngoò xi̱ta̱ xi ndaà tíkjá xincho̱‑la̱ ko̱ ndaà títì ni'ín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","K'oa̱á s'ín ndaà titsa̱jnakoòn koni jñà xi̱ta̱ chi̱'nda xi nchikoña‑la̱ nei‑la̱ xi s'eí kòfì ñánda kòbixan xi̱ta̱, mé‑ne k'e̱ nga kjoi̱í‑ne, nei‑la̱ ni'ya ki̱chja̱, si̱ìkjane xotjoa̱ ni'ya, i̱kjoàn skíx'a̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mé tà ndaà‑la̱ jñà xi̱ta̱ chi̱'nda xi títsa̱jnakon k'e̱ nga kjoi̱í‑ne nei‑la̱. Xi o̱kixi̱, k'oa̱á xán‑nò, jè sobà nei‑la̱ skoé nikje ot'aà‑la̱ nga ko̱òt'aà koa̱ si̱ìkítsa̱jnat'aà ími̱xa̱‑la̱, i̱kjoàn si̱ìkjèn. ");
INSERT INTO maaNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mé tà ndaà‑la̱ jñà chi̱'nda xi ko̱s'ín títsa̱jnakon na̱s'ín jye ijchò osen ni̱tje̱n, na̱s'ín jye nchrohós'e i̱sén nga kjoi̱í‑ne nei‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tíjiìn‑nò tsà jngoò nei‑la̱ ni'ya si̱jiìn‑la̱ mé hora kjoi̱í xi̱ta̱ chijé nga si̱ìchijé‑la̱, kíjnakon‑né nga mìkiì tsjá'nde nga ko̱chijé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jñò, k'oa̱á ti̱s'ín titsa̱jnandaà; 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, kjoi̱i ìjngoò k'a k'e̱ nga mìkiì titsa̱chiñà kjoa̱a. ");
INSERT INTO maaNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro kiskònangui, kitsò: ―Na̱'èn, jè kjoa̱ mangásòn xi tinokjoì, ¿a tà ji̱ín xi o̱tì'mì‑náje̱n, a xi kóho̱tjín xi̱ta̱? ");
INSERT INTO maaNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kitsò Na̱'èn‑ná Jesús: ―K'oa̱á xán‑nò yá‑né xi chi̱'nda kixi̱ xi tjín‑la̱ kjoa̱chji̱ne̱ nga jè nei‑la̱ si̱ìkíjna'nda jñà chi̱'nda‑la̱ xi i'nga xi ya̱ síxá ni'ya‑la̱ mé‑ne nga k'e̱ ki̱jchò chi̱ba̱‑la̱, si̱ìkjèn chi̱'nda xíkjín. ");
INSERT INTO maaNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mé tà ndaà‑la̱ jè chi̱'nda xi k'oa̱s'ín ndaà tísíkitasòn k'e̱ nga kjoi̱í‑ne nei‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","O̱kixi̱í xi xan‑nò, nei‑la̱ chi̱'nda jè, jè si̱ìkíjna'nda yije tsojmì xi tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ta̱nga tsà jè chi̱'nda jè ki̱tso̱ nga ko̱òko̱ ini̱ma̱‑la̱: “Nei‑na̱, kjìn na̱chrjein ko̱chrjein‑la̱ nga kjoi̱í‑ne.” I̱kjoàn koi̱ìts'ia̱ nga ska̱àn‑ko̱ chi̱'nda x'i̱n xíkjín, ti̱koa̱ k'oe̱è‑la̱ jñà chi̱'nda íchjín; ko̱kje̱n, koa̱ skoí, koa̱ ko̱ch'i̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Chi̱'nda jè, kjoi̱í‑ne nei‑la̱ jè na̱chrjein ko̱ jè hora k'e̱ nga mìkiì tíkoña‑la̱. 'Ñó tse kjo̱'in tsjá‑la̱; ya̱á si̱ìkíjnajiìn‑la̱ ñánda títsa̱jna xi̱ta̱ xi mìkiì mokjeiín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Jè chi̱'nda xi jye ndaà tíjiìn‑la̱ mé xi mejèn‑la̱ nei‑la̱, ta̱nga mìkiì bìjnandaà, ti̱koa̱ mìkiì síkitasòn koni s'ín síjé nei‑la̱, koií jé xi ko̱ma‑la̱ nga 'ñó ko̱jà‑la̱ nei‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ta̱nga tsà jè chi̱'nda, tsà mìkiì tíjiìn‑la̱ nga kjo̱'in tjín‑la̱ kjoa̱ xi ch'o tjín, ìsa̱á chiba kjo̱'in s'e̱‑la̱. Jè xi tse kitjoé‑la̱, ìsa̱á tse si̱jé‑la̱; ti̱koa̱ jè xi tse kjònga̱tsja, ti̱koa̱á ìsa̱á tse si̱jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Koni jngoò ni'ín xi oká tjé ko̱ síkijne‑ngui xi tsjeè, koií xá j'i̱‑na i̱ i̱t'aà nangui nga kjoa̱axìn‑la̱ jé‑la̱ xi̱ta̱ mé‑ne nga ko̱tsjeè‑ne. Tsí mejèn‑na tsà jye tíbitasòn. ");
INSERT INTO maaNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","K'oa̱á s'ín tjínè‑na nga tse kjo̱'in ko̱tojñaà; ¡tsí ndaà makájno‑na skanda k'e̱ nga ki̱tasòn! ");
INSERT INTO maaNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿A k'oa̱á s'ín nìkítsjeèn nga jè kjoa̱ xi j'iìkoa̱a nga 'nchán kítsa̱jna xi̱ta̱? Majìn, xán‑nò, kjoa̱siì kítsa̱jnajiìn jè nga̱tjì‑la̱ kjoa̱ ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mats'ia̱‑ne skanda i̱'ndei̱ kóni nga fì‑ìsa na̱chrjein, k'oa̱á ngaya‑la̱ tsà 'òn ma xi̱ta̱ xi títsa̱jna nga jngoò ni'ya, jòya ko̱ma; xi jàn ma‑ne ska̱àn‑kjoòko̱ xi jò ma‑ne, jñà xi jò ma‑ne ska̱àn‑ko̱ xi jàn ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Jò sko̱ya s'e̱. Na̱'èn‑la̱, kondra̱‑la̱á ko̱ma jè ki'ndí‑la̱; koa̱ jè ki'ndí‑la̱, kondra̱‑la̱á ko̱ma na̱'èn‑la̱; nea̱‑la̱, kondra̱‑la̱á ko̱ma tsòti‑la̱; jè tsòti‑la̱ kondra̱‑la̱á ko̱ma nea̱‑la̱; na̱chíya‑la̱, kondra̱‑la̱á ko̱ma jè kja'nda‑la̱; jè kja'nda‑la̱ kondra̱‑la̱á ko̱ma na̱chíya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús ti̱koa̱ kitsò‑la̱ jñà xi̱ta̱ xi kjìn ma‑ne: ―K'e̱ nga 'yaà nga nchrobá ifi, bixón‑nò: “Jtsí k'oa̱.” K'oa̱á s'ín bitasòn. ");
INSERT INTO maaNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","K'e̱ nga 'ba tjo̱ tsjè, bixón‑nò: “Ndobá ko̱tsjè.” K'oa̱á s'ín bitasòn, matsjè‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Jñò, xi̱ta̱ xi jò ma i̱sén‑nò! Maá‑nò chìtsejèn‑là kó choòn i̱t'aà ngajmiì ko̱ i̱t'aà nangui, koa̱, ¿mé‑ne nga mìkiì ma‑nò 'nè kinda̱ mé kjoa̱ xi tíma jñà na̱chrjein xi titsa̱jnaà? ");
INSERT INTO maaNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Mé‑ne nga mì tà jñò bìndaàjiìn‑là xinguio̱o nga kàtakixi̱ya kjoa̱ xi tjín‑nò? ");
INSERT INTO maaNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","K'e̱ nga onguió ján nguixko̱n xi̱ta̱xá ko̱ kondra̱‑lè, ti̱nchátsji'nde‑la̱ ya̱ i̱ya ndi̱yá mé‑ne nga ko̱ma jchi̱bàndaà‑nò nga mì ya̱ kji̱ko̱‑lè i̱t'aà ts'e̱ xi̱ta̱xá koa̱ jè xi̱ta̱xá mì ya̱ si̱ìnga̱tsja‑lè i̱t'aà ts'e̱ policía koa̱ jè policía nga mì nda̱yá ski̱nìs'en‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","K'oa̱á xan‑lè, mìkiì ko̱ma ki̱tjo̱o‑ne nda̱yá skanda k'e̱ nga kíchjítjì yijo‑lè nga yije xi si̱ìjé‑lè xi̱ta̱xá. ");
INSERT INTO maaNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ti̱jñà‑ne na̱chrjein koi, ijchò xi̱ta̱ xi tsibéno̱jmí‑la̱ Jesús nga jè Pilato tsatíxá‑la̱ xi̱ta̱ nga ta̱ña kisìk'en‑kjoò cho̱ ko̱ xi̱ta̱ Galilea k'e̱ nga nchitsjá‑la̱ kjo̱tjò Nainá. Kisìkátjijiìn jní‑la̱ cho̱ ko̱ ts'e̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kiìchja̱ Jesús, kitsò: ―Jñò, ¿a k'oa̱á s'ín nìkítsjeèn nga ìsa̱á tse jé tjín‑la̱ jñà xi̱ta̱ Galilea nga k'oa̱s'ín komàt'in? ");
INSERT INTO maaNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Majìn, xán‑nò; tsà mìkiì si̱kájnoò jé‑nò nga mì ti̱ jé ki̱nchátsji‑nò, jñò, ki̱yá yije‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","K'e̱ nga k'en jñà xi̱ta̱ xi chrj'oòn jàn ma‑ne xi kiskaànè chrjó ts'e̱ torre Siloé, ¿a k'oa̱á s'ín nìkítsjeèn nga ìsa̱á tse jé tjín‑la̱ xi̱ta̱ koi nga ko̱s'ín komàt'in, mì k'oa̱‑ne koni ngats'iì xi̱ta̱ xi tjín ján Jerusalén? ");
INSERT INTO maaNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Majìn, xán‑nò; tsà mìkiì si̱kájnoò jé‑nò nga mì ti̱ jé ki̱nchátsji‑nò, jñò, ti̱koa̱á ki̱yá yije‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús ti̱koa̱á tsibéno̱jmí jngoò‑la̱ kjoa̱ xi mangásòn. Kitsò‑la̱: ―Jngoò xi̱ta̱ xi kijna jngoò‑la̱ i̱'nde ñánda tjín‑la̱ toò uva, ya̱á títje̱jiìn jngoò‑la̱ yá toò iko̱. Xi̱ta̱ jè, j'iì katsejèn‑la̱ tsà yijà‑la̱ toò, ta̱nga ni̱mé kisakò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","K'e̱é kitsò‑la̱ jè xi̱ta̱ xi tíjna'nda: “Kó jàn nó nga f'iì katsejèn‑la̱ yá jè, tsà yijà‑la̱ toò. Ta̱nga ni̱mé tjín‑la̱. Ti̱chásoìn. Nanguií tísíkits'ón.” ");
INSERT INTO maaNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jè xi̱ta̱ xi tíjna'nda kitsò: “Na̱'èn, ti̱kíjna‑là nguì jngoò nó‑ìsa. Sikòn‑la̱, si̱ìxa̱n‑ngui‑la̱ ni'nde nga jngoò itjandiì; i̱kjoàn kinguì‑la̱ tjé'nde. ");
INSERT INTO maaNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tsà koií na̱chrjein‑la̱, ko̱ja̱‑la̱ toò nó xi nchrobá; tsà majìn, ko̱maá i̱skan ki̱chásoìn.” ");
INSERT INTO maaNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jesús, k'e̱ nga tíhokóya jngoò ni'ya i̱ngo̱ sinagoga ts'e̱ xi̱ta̱ judío, jè na̱chrjein nìkjáya, ");
INSERT INTO maaNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ya̱ tíjna jngoò chjo̱ón xi jye kò chrj'oòn jàn nó tíjna nga xk'én. Jngoò ini̱ma̱ ch'o‑la̱ nei̱í tísítsit'in koa̱ mì xó kiì ma osìjna kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús, k'e̱ nga kijtseè, kiìchja̱‑la̱, kitsò‑la̱: ―Chjo̱ón, jyeé ndaà‑ne ch'in xi tjín‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","I̱kjoàn tsohósòn‑la̱ tsja; jè chjo̱ón, ni̱to̱ón kjòkixi̱ ìjngoò k'a‑ne, i̱kjoàn kitsjaà‑la̱ kjo̱ndaà Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ta̱nga jè xi̱ta̱ sko̱‑la̱ ts'e̱ ni'ya i̱ngo̱ sinagoga kòjtií‑la̱ nga jè Jesús kisìndaà‑ne chjo̱ón jè, koií kjoa̱‑la̱ nga na̱chrjein nìkjáya; kitsò‑la̱ jñà xi̱ta̱ xi títsa̱jna: ―Joòn na̱chrjein tjín nga ma maxá; jñà na̱chrjein koi ko̱maá kji̱nchrobà nga ko̱ndaà‑nò, ta̱nga mìkiì tjí'nde jè na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","K'e̱é kiìchja̱ Na̱'èn‑ná Jesús, kitsò: ―Jñò, xi jò ma i̱sén‑nò. Jè na̱chrjein nìkjáya, ¿a mì chíjnda̱'ñó‑jèn nchra̱ja̱‑nò ko̱ búrró‑nò nga nachrjenguioò ni'nga nga onguí nìk'ioò nandá? ");
INSERT INTO maaNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ko̱ jè chjo̱ón jè, xi tsòti‑la̱ Abraham, jyeé kò chrj'oòn jàn nó tjín‑la̱ nga tjít'aà'ñó‑la̱ xi̱ta̱ nei̱í. ¿A mì ko̱ma tjájnda̱'ñó na̱s'ín jè na̱chrjein nìkjáya? ");
INSERT INTO maaNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","K'e̱ nga jye o̱kitsò Jesús, tà kjòsobà‑la̱ ngats'iì xi̱ta̱ kondra̱‑la̱ ta̱nga jñà xi̱ta̱ na̱xa̱ndá kjòtsja‑la̱ koni s'ín tjín kjo̱xkón xi 'ñó jeya tís'ín Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús kitsò: ―¿Mé xi k'oa̱s'ín mangásòn‑kjoò koni s'ín otíxoma Nainá? ¿Mé xi siìngásòn‑kjoaà? ");
INSERT INTO maaNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Jè mangásòn‑ko̱ koni kji xojmá mostaza; k'e̱ jngoò xi̱ta̱ bítje̱jiìn nangui‑la̱, i̱kjoàn bisò, ma'nga; jñà ni̱se xi tjíma i'ngaá, bíndaà'a tjé‑la̱ jñà chrja‑la̱ yá. ");
INSERT INTO maaNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ìjngoò k'a kiìchja̱ Jesús, kitsò: ―¿Mé xi si̱ngásòn‑kjoaá koni s'ín otíxoma Nainá? ");
INSERT INTO maaNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","K'oa̱á ngaya‑la̱ koni jè na̱'yo̱ san, k'e̱ nga jngoò chjo̱ón síkájiìn jàn chi̱ba̱ skoa̱n i̱nchra̱jín, masan yije‑né kóho̱kji na̱'yo̱. ");
INSERT INTO maaNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús, nga tífì ján ndi̱yá Jerusalén, kjìn na̱xa̱ndá jahato nga tsakóya, na̱xa̱ndá xi jtobá kjoàn ko̱ xi iì kjoàn. ");
INSERT INTO maaNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jngoò xi̱ta̱ xi kiskònangui‑la̱, kitsò‑la̱: ―Na̱'èn, ¿a chibaá ma xi̱ta̱ xi ko̱chrjekàjiìn kjo̱'in Nainá? Jè, k'e̱é kitsò: ");
INSERT INTO maaNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―T'e̱en‑là kjo̱'ñó yijo‑nò nga ki̱tjás'e̱en jè xotjoa̱ xi 'nchrèya kji. K'oa̱á xán‑nò: kjìn xi̱ta̱ ko̱mejèn‑la̱ kjoa̱has'en ta̱nga mìkiì ko̱ma kjoa̱has'en. ");
INSERT INTO maaNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","K'e̱ nga jè nei‑la̱ ni'ya ko̱sítje̱n nga ki̱ìchjoàjto xotjoa̱ ni'ya, jñò, tsà ndi̱tsiaán titsa̱jnaà, k'e̱é kíts'ia̱a nga ki̱nókjoa̱a, kixón: “Na̱'èn, chíx'a̱‑náje̱n xotjoa̱ ni'ya.” Jè nei‑la̱ ni'ya ki̱tso̱‑nò: “Mìkiì bexkon‑nò ñánda‑ne tsa̱jòn.” ");
INSERT INTO maaNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","K'e̱é kíts'ia̱a nga kixón: “Ta̱ñaá chichiko̱‑lèje̱n, ti̱koa̱á ta̱ñaá ki'yòko̱‑lèje̱n, ti̱koa̱á ya̱á ndi̱tsi̱n‑na̱je̱n tsakoòyi.” ");
INSERT INTO maaNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ta̱nga jè, tà ki̱tso̱ó‑nò: “K'oa̱á xan‑nò, mìkiì bexkon‑nò ñánda‑ne tsa̱jòn. ¡Ti̱nchat'aàxìn‑ná ngats'ioò xi ch'o 'nè!” ");
INSERT INTO maaNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ya̱á jchìhindáyaà, ti̱koa̱ si̱jts'ioòn ni'ñoò k'e̱ nga jcha̱xkoòn jè Abraham, Isaac, Jacob, ngats'iì xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá nga ya̱ títsa̱jna ñánda tíhotíxoma Nainá, koa̱ jñò, xìn i̱'nde si̱ìkasén‑nò Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kjoi̱í‑ne xi̱ta̱ xi kji̱nchrobà‑ne nga ñijòn chrja̱ngui̱‑la̱ i̱sò'nde xi kítsa̱jnat'aà ími̱xa̱ nga ko̱kje̱n ñánda tíhotíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","I̱'ndei̱, tjín xi̱ta̱ xi títsa̱jna‑tji̱ngui, nga ko̱ma i̱skan jñà kítsa̱jna ítjòn; ti̱koa̱á tjín xi̱ta̱ xi títsa̱jna ítjòn i̱'ndei̱, k'e̱ nga ko̱ma i̱skan, jñà kjoe̱het'aà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ti̱jè‑ne na̱chrjein ijchò i'nga xi̱ta̱ fariseo ñánda tíjna Jesús, kitsò‑la̱: ―Ti̱si̱t'aà xìn, jè Herodes mejèn‑la̱ si̱ìk'en‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kitsò Jesús: ―Tanguió, ko̱t'ìn‑là xi̱ta̱ maña̱ jè: “I̱'ndei̱ ko̱ nchijòn‑lè k'oa̱á s'iaàn: ko̱chrjekàjñaà ini̱ma̱ ch'o‑la̱ nei̱í xi tíjiìn ini̱ma̱‑la̱ xi̱ta̱, ti̱koa̱ siìndaà‑na xi̱ta̱ xi xk'én; skanda k'e̱ ki̱jchò na̱chrjein nga kjoe̱het'aà xá‑na̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","K'oa̱á s'ín ko̱ma i̱'ndei̱, nchijòn‑le̱ ko̱ jngui‑le̱, kàtjì‑ìsa ndi̱yá‑na̱. Mìkiì ndaà tjín nga jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá, xìn‑t'aà ki̱yá‑la̱ na̱xa̱ndá Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Jñò xi xi̱ta̱ na̱xa̱ndá Jerusalén tsa̱jòn xi nìk'eèn xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá, ko̱ bìnè nda̱jo̱ jñà xi̱ta̱ xi Nainá síkasén‑nò! ¡Kjìn k'a kjòmejèn‑na nga tsibìxkóya i̱xti‑nò koni s'ín xa̱'nda̱ nga bíngui jnga̱á‑la̱ jñà i̱xti‑la̱; ta̱nga jñò, mìkiì kòkjeiín‑nò! ");
INSERT INTO maaNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chítsejèn‑là ni'ya‑nò nga jye tsjeiìn‑takòn Nainá; k'oa̱á xán‑nò nga mì ti̱ kiì jcha̱xkoòn‑ná skanda k'e̱ nga ki̱jchò na̱chrjein nga kixón: “¡Mé tà ndaà‑la̱ jè xi nchrobá ngajo‑la̱ Nainá!” ");
INSERT INTO maaNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jngoò k'a jngoò na̱chrjein nìkjáya, Jesús kiì kjèn ni'ya‑la̱ jngoò xi̱ta̱ sko̱‑la̱ jñà xi̱ta̱ fariseo; jñà xi̱ta̱ koi, nchisíkinda̱ mé kjoa̱ xi s'i̱in Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ti̱koa̱ ya̱á tíjna nguixko̱n Jesús jngoò xi̱ta̱ xi ch'in chjón‑ndá tjín‑la̱ (jñà xi̱ta̱ xi nandá sinchá i̱ndso̱'ba̱). ");
INSERT INTO maaNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús kiskònangui‑la̱ jñà xi̱ta̱ chji̱ne̱ xo̱jo̱n ts'e̱ kjo̱tíxoma‑la̱ Nainá ko̱ xi̱ta̱ fariseo, kitsò‑la̱: ―¿A tjí'nde‑né nga si̱xkiì‑lá xi̱ta̱ jè na̱chrjein nìkjáya, a xi majìn‑né? ");
INSERT INTO maaNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ta̱nga jñà xi̱ta̱ koi, mìkiì kiìchja̱, tà jyò tsibìtsa̱jna. Ta̱nga jè Jesús kiskoé xi̱ta̱ jè, kisìndaà‑ne, i̱kjoàn kisìkasén‑ne ni'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","K'e̱é kitsò‑la̱ jñà xi̱ta̱ koi: ―Jñò, tsà búrró‑nò, ko̱ tsà nchra̱ja̱‑nò ki̱xo̱ya jngoò nga̱jo̱, ¿a mìtsà ni̱to̱n ki̱nachrje‑nò na̱s'ín na̱chrjein nìkjáya? ");
INSERT INTO maaNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jñà xi̱ta̱ fariseo, ni̱ ti̱ mé 'én kiìchja̱‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús, k'e̱ nga kijtseè jñà xi̱ta̱ xi xó kinokjoà‑la̱ nga nchifaájiìn íxi̱le̱ ts'e̱ xi̱ta̱ ítjòn ya̱ i̱t'aà ími̱xa̱, tsibéno̱jmí jngoò‑la̱ kjoa̱ xi mangásòn, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Tsà xó ki̱nókjoa̱‑lè ya̱ ni'ya ñánda tjín s'eí nga xi̱ta̱ bixan, mìkiì ya̱ bijnasoìn íxi̱le̱ ts'e̱ xi̱ta̱ ítjòn, tsà koi na̱chrjein‑la̱ tjín ìjngoò‑ìsa xi̱ta̱ xi 'ñó títjòn koni ngaji̱, xi ti̱koa̱ xó kànokjoà‑la̱; ");
INSERT INTO maaNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","jè xi̱ta̱ xi xó kàchja̱‑nò ki̱tso̱‑lè: “Tjiì'nde‑la̱ xi̱ta̱ jè nga kàtìjna.” Ngaji̱, ko̱sobà‑lè nga kj'ei̱í íxi̱le̱ ki̱jnasoìn ñánda fehet'aà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","K'e̱ nga xó ki̱nókjoa̱‑lè, ya̱á ti̱jnasoìn íxi̱le̱ xi fehet'aà‑ne mé‑ne k'e̱ nga kjoi̱í jè xi̱ta̱ xi xó kàchja̱‑lè, ki̱tso̱‑lè: “Amigo, ti̱jnat'eiì ími̱xa̱ ñánda síjna íxi̱le̱ ítjòn.” Ngaji̱, skoe̱xkón‑lè xi̱ta̱ xi ta̱ña titsa̱jnat'aà ími̱xa̱. ");
INSERT INTO maaNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jè xi̱ta̱ xi 'nga síkíjna yijo‑la̱, ìsa̱á nangui kíjna; jè xi nangui síkíjna yijo‑la̱, ìsa̱á 'nga kíjna. ");
INSERT INTO maaNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús, ti̱koa̱á kitsò‑la̱ jè xi̱ta̱ xi xó kiìchja̱‑la̱: ―K'e̱ nga xó ki̱nókjoa̱‑la̱ xi̱ta̱ nga ki̱chikoi̱i nga nchisen, o na̱s'ín nguixòn, kì jñà nokjoà ítjòn‑la̱ amigo‑lè, 'ndsì, xi̱ta̱ xingui̱i, ni̱ jñà xi̱ta̱ i̱ndiì ni'ya‑lè xi xi̱ta̱ nchi̱ná, mé‑ne nga jñà xi̱ta̱ koi, tsà koi na̱chrjein‑la̱ k'oa̱á ti̱s'ín ki̱chja̱ ngajo‑lè nga ko̱jndà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tà sa̱á k'e̱ nga s'eí s'i̱in, jñà ti̱nókjoa̱ ítjòn‑la̱ xi̱ta̱ i̱ma̱, xi tsjìn tsja, xi mìkiì ma fì, ko̱ xi mìkiì tsejèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ngaji̱, k'e̱ nga k'oa̱s'ín s'i̱in, ndaà s'e̱‑la̱ ini̱ma̱‑lè nga jñà xi̱ta̱ koi mìkiì ko̱ma si̱ìjndà ngajo‑lè; ta̱nga ngaji̱, k'e̱é ko̱chjí ngajo‑lè k'e̱ nga kjoa̱áya‑la̱ jñà xi xi̱ta̱ kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","K'e̱ nga kiì'nchré jngoò xi̱ta̱ xi ya̱ ta̱ña títsa̱jnat'aà ími̱xa̱, kitsò‑la̱ Jesús: ―¡Mé tà ndaà‑la̱ jè xi̱ta̱ xi ko̱kje̱n ya̱ ñánda tíhotíxoma Nainá! ");
INSERT INTO maaNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","K'e̱é kitsò Jesús: ―Jngoò xi̱ta̱, xi s'eí tsibíjna, kjìn xi̱ta̱ kiìchja̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","K'e̱ nga ijchò hora‑la̱ nga jye ko̱kje̱n xi̱ta̱, kisìkasén chi̱'nda‑la̱ nga kiì kíchja̱‑la̱ jñà xi̱ta̱ xi xó kinokjoà‑la̱, kitsò‑la̱: “Nchrobá, jyeé tjíndaà yije.” ");
INSERT INTO maaNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ngats'iì xi̱ta̱ kisìjé kjoa̱ nìjchàat'aà. Kitsò jè xi títjòn: “Mì‑la kiì ko̱ma kjián; jngoò nangui jye kòhotse; mochjeén‑né nga kjián katsejèn‑la̱; kìtsi'bà‑lè, ti̱je‑la̱ takoìn, mìkiì kjián.” ");
INSERT INTO maaNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jè xi ìjngoò kitsò: “'A̱n, 'òn nga nchra̱ja̱ xi bínchi jyeé kòhotse; mejèn‑na kjián kat'aà tsà ndaà síxá; kìtsi'bà‑lè, ti̱je‑la̱ takoìn, mìkiì kjián.” ");
INSERT INTO maaNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Xi ìjngoò, k'oa̱á ti̱ kitsò: “'A̱n, sa̱á jye kòbixan, koií kjoa̱‑la̱ nga mìkiì ko̱ma kjián.” ");
INSERT INTO maaNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","K'e̱ nga j'iì‑ne chi̱'nda jè, tsibéno̱jmí yije‑la̱ nei‑la̱ ngats'iì kjoa̱ koi. Jè nei‑la̱ ni'ya, kòjti‑la̱; k'e̱é kitsò‑la̱ chi̱'nda‑la̱: “T'in ni̱toi̱in ján ndi̱tsi̱n, kóho̱kji i̱ya ndi̱yá‑la̱ na̱xa̱ndá; nchrohókoi̱i yije xi̱ta̱ i̱ma̱, xi tsjìn tsja, xi mìkiì ma fì, ko̱ xi mìkiì tsejèn‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chi̱'nda jè, nga komà i̱skan kitsò: “Na̱'èn, jyeé kòbitasòn yije koni s'ín kò'mì‑ná, ta̱nga tjín‑ìsa i̱'nde.” ");
INSERT INTO maaNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","K'e̱é kitsò jè nei‑la̱ chi̱'nda: “T'in kóho̱kji ndi̱yá teè, ko̱ ndi̱yá i̱tsjí; nchrohókoi̱i xi̱ta̱; ko̱'ñó t'e̱n‑la̱ nga kàtjahas'en mé‑ne nga kàtatseè ni'ya‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","K'oa̱á xán‑nò; ni̱jngoò xi̱ta̱ xi kichjà ítjòn‑la̱ ko̱kje̱n‑ko̱‑na s'eí‑na̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","'Ñó kjìn xi̱ta̱ tji̱ngui‑la̱ Jesús; kisìkáfayat'aà‑la̱, kiìchja̱, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Tsà yá xi mejèn‑la̱ nga 'a̱n kji̱nchrobà‑tji̱ngui‑na, tsà jè yijo‑la̱, tsà na̱'èn‑la̱, tsà nea̱‑la̱, tsà chjo̱ón‑la̱, i̱xti‑la̱, 'ndse̱, ndichja, tsà ìsa̱ tjòkeè mì k'oa̱á‑ne koni 'a̱n, mìkiì ko̱ma nga xi̱ta̱ ts'a̱n xán‑la̱ nga 'a̱n kota'yàt'aà‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jè xi mìkiì síkitasòn koni jngoò xi̱ta̱ xi 'yajen krò‑la̱, tsà mìkiì tíjnandaà nga si̱ìkjeiín kjo̱'in nga 'a̱n kji̱nchrobà‑tji̱ngui‑na, mìkiì ko̱ma nga xi̱ta̱ ts'a̱n xán‑la̱ nga 'a̱n kota'yàt'aà‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jñò, tsà mejèn‑nò nga chrjó torre kíndaà jngoò, ¿a mìtsà ítjòn jchósòn‑là kó tjín si̱ngui chjí‑la̱, a tjín‑nò to̱n xi si̱ndaà yije‑ne? ");
INSERT INTO maaNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tsà koi na̱chrjein‑la̱ tà jè tàts'en chrjó si̱jna. Tsà mìkiì ko̱ngásòn yije chrjó, ngats'iì xi̱ta̱ xi skoe̱ ki̱jno̱keè‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ki̱tso̱: “Jñà xi̱ta̱ koi tsibíts'ia̱ nga kiskímiìtje̱n chrjó ni'ya ta̱nga mìkiì kisìkjehet'aà.” ");
INSERT INTO maaNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Tsà jngoò xi̱ta̱xá ítjòn xi mejèn‑la̱ koi̱ìts'ia̱ kjo̱jchán nga ska̱àn‑kjoòko̱ xíkjín xi ngásòn xi̱ta̱xá ítjòn, ¿a mìtsà ítjòn skósòn‑la̱ tsà te jmiì ma xi̱ta̱‑la̱, a ki̱chìkjoa̱á‑la̱ nga ska̱àn‑ko̱ tsà kaàn jmiì ma xi̱ta̱ kondra̱‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tsà beè‑la̱ ikon nga mìkiì ki̱chìkjoa̱‑la̱, ti̱k'e̱é‑ne nga kjiìn tíjna xi̱ta̱xá ítjòn xi ìjngoò, si̱ìkasén xi̱ta̱ xi kjoi̱ si̱ìjé kjoa̱'nchán. ");
INSERT INTO maaNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","K'oa̱á ti̱s'ín tjín, ngats'ioò, ni̱ta̱ yá‑nò xi mejèn‑nò nga xi̱ta̱ ts'a̱n ko̱ma, ítjòn ti̱kítsjeèn, a si̱jngoò‑takòn nga si̱chjaà yije tsojmì xi tjín‑nò. Tsà majìn, mìkiì ko̱ma nga xi̱ta̱ ts'a̱n xán‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Jè na̱xa̱, ndaà‑né; ta̱nga tsà mì ti̱ kiì si̱ìjnchra‑ne tsojmì, ¿kó ti̱s'ín ko̱chjeén‑ne? ");
INSERT INTO maaNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mì ti̱ mé chjí‑la̱; mì ti̱ kiì ko̱chjeén‑la̱ nangui; mì ti̱ kiì ko̱chjeén‑ne koni tjé'nde, tà xíxteèn‑né. ¡Ndaà ti̱ná'yaà koni xan‑nò! ");
INSERT INTO maaNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jñà xi̱ta̱‑la̱ xi̱ta̱xá Roma xi síkíchjítjì tsojmì ko̱ jñà xi̱ta̱ xi ch'o tjín kjoa̱ xi s'ín, ijchò kinchat'aà chrañà‑la̱ Jesús ñánda tíjna, nga mejèn‑la̱ kji̱'nchré‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jñà xi̱ta̱ fariseo ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés kiìchja̱jno‑la̱ Jesús, kitsò: ―Xi̱ta̱ jè, ndaà óko̱ jñà xi̱ta̱ xi ch'o s'ín, ti̱koa̱á ta̱ñaá kjèn‑ko̱. ");
INSERT INTO maaNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesús, k'e̱é tsibéno̱jmí jngoò‑la̱ kjoa̱ xi mangásòn, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Tsà jngoò xi̱ta̱ tsa̱jòn xi tjín‑la̱ jngoò sìndo̱ orrè, tsà chi̱ja jngoò orrè‑la̱, ¿a mìtsà si̱ìkítsa̱jna i̱jiìn ijñá jñà xi ñijòn kaàn ko̱ chrj'oòn ñijòn ma‑ne? I̱kjoàn kjoi̱ kátsji jè xi kichijà skanda kó nga sa̱kò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","K'e̱ nga jye sa̱kò‑la̱, tsjaá ko̱ma‑la̱; koa̱'nga ko̱hòsòn chrja‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","K'e̱ nga ki̱jchò‑ne ni'ya‑la̱, ki̱chja̱‑la̱ amigo‑la̱ ko̱ xi̱ta̱ i̱ndiì ni'ya‑la̱, ki̱tso̱‑la̱: “Ti̱tsjako̱‑ná, jye kàsakó‑ne orrè‑na̱ xi kichijà.” ");
INSERT INTO maaNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","K'oa̱á xán‑nò, k'oa̱á ti̱s'ín ìsa̱ ndaà s'e̱ kjo̱tsja ján ngajmiì i̱t'aà ts'e̱ jngoò xi̱ta̱ jé xi síkájno jé‑la̱ nga mì ti̱ jé ótsji‑ne, mì k'oa̱á‑ne koni tsà ñijòn kaàn ko̱ chrj'oòn ñijòn ma‑ne xi tjín‑la̱ o̱kixi̱ xi mìkiì mochjeén‑la̱ nga si̱ìkájno jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Tsà jngoò chjo̱ón xi te ma‑ne to̱n‑la̱, tsà chi̱ja jngoò to̱n‑la̱, ¿a mìtsà ko̱kà ni'ín, ti̱koa̱ ko̱tìcha i̱nga ni'ya‑la̱; ndaà ndaà ko̱hótsji to̱n‑la̱ skanda kó nga sa̱kò‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","K'e̱ nga jye sa̱kò‑la̱, ki̱chja̱‑la̱ amiga‑la̱ ko̱ íchjín i̱ndiì ni'ya‑la̱, ki̱tso̱‑la̱: “Ti̱tsjako̱‑ná, jye kàsakó‑ne to̱n‑na̱ xi kichijà.” ");
INSERT INTO maaNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","K'oa̱á xán‑nò, k'oa̱á ti̱s'ín tjín kjo̱tsja nga nguixko̱n àkja̱le̱‑la̱ Nainá k'e̱ nga jngoò xi̱ta̱ jé síkájno jé‑la̱ nga mì ti̱ jé ótsji‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús tsibéno̱jmí ìjngoò kjoa̱ xi mangásòn; kitsò: ―Jngoò xi̱ta̱ xi jò ma i̱xti‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jè ti xi ma ki'ndí kitsò‑la̱ na̱'èn‑la̱: “Na̱'èn, tjiì‑ná tsojmì xi 'a̱n ko̱ko̱‑na.” Jè na̱'èn‑la̱ kisìjòya yije‑la̱ tsojmì xi tjín‑la̱, i̱kjoàn kitsjaà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Xi jye tsato jò jàn na̱chrjein, ti jè, ni̱to̱ón tsatíjna yije tsojmì‑la̱ xi kitjoé‑la̱, kisìjngoò to̱n‑la̱. I̱kjoàn kiì jngoò na̱xa̱ndá xi 'ñó kjiìn kijna. Ya̱á kisìkjeheya yije to̱n‑la̱ nga ta̱xki̱ kisìko̱ yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","K'e̱ nga jye kisìkjeheya yije to̱n‑la̱, ya̱ i̱'nde ñánda tsibìjna, j'iì jngoò kjinchrá 'ñó; mì ti̱ mé tjín‑la̱ xi kine. ");
INSERT INTO maaNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","K'e̱é kiì síjé‑la̱ xá jngoò xi̱ta̱ xi ya̱ i̱'nde‑la̱ na̱xa̱ndá jè. Xi̱ta̱ jè, kisìkasén ñánda tjín‑la̱ rancho̱ nga kisìkinda̱ chi̱nga̱. ");
INSERT INTO maaNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ti jè, mejèn xó kine chrjoa̱ na̱jmá xi kjèn chi̱nga̱ ta̱nga mì yá xi tsjá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","K'e̱ nga jye kjòndaàya‑ne kjo̱hítsjeèn‑la̱ kitsò: “¡Kjìn xi̱ta̱ chi̱'nda tjín‑la̱ na̱'èn‑na̱ ya̱ ni'ya‑la̱ xi ningui‑la̱ i̱nchra̱jín xi kjèn, koa̱ 'a̱n, i̱jndé, tìbiyaà‑ná kjinchrá! ");
INSERT INTO maaNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kjín ìjngoò k'a‑na ni'ya‑la̱ na̱'èn‑na; k'oa̱á xán‑la̱: Na̱'èn, tseé jé tsohotsjià xi i̱t'aà ts'e̱ Nainá xi tíjna ngajmiì ko̱ i̱t'aà tsi̱ji; ");
INSERT INTO maaNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","mì ti̱ kiì ok'ìn‑na nga ki'ndí‑lè k'oín‑ná; k'oa̱á s'ín jcha̱‑takòn‑ná koni tsà jngoò chi̱'nda‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","K'e̱é tsasítje̱n, kiìkon na̱'èn‑la̱. ’Ti̱k'e̱é‑ne nga kjiìn tífì, jè na̱'èn‑la̱ kijtseèxkon, kjòhi̱ma̱keè, tsangachikon, i̱kjoàn kitsobàkjá ki'ndí‑la̱, kiskine'a. ");
INSERT INTO maaNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jè ki'ndí‑la̱ kitsò: “Na̱'èn, tsohotsjià jé xi i̱t'aà ts'e̱ Nainá xi tíjna ngajmiì ko̱ i̱t'aà tsi̱ji; mì ti̱ kiì ok'ìn‑na nga ki'ndí‑lè k'oín‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ta̱nga jè na̱'èn‑la̱ kitsò‑la̱ chi̱'nda‑la̱: “Ni̱to̱n nchrobáko̱ò nikje xi ìsa̱ 'ñó ndaà kjoàn, ti̱kákjá, ti̱koa̱ tíkjá jngoò ta̱ngò jnótsja, tjayaà xo̱xté ndso̱ko̱. ");
INSERT INTO maaNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tanguíchjaà jngoò nchra̱ja̱ ki'ndí xi 'ñó xiné, ti̱k'eèn. ¡Chji̱ne̱é, s'eí s'e̱én! ");
INSERT INTO maaNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Jè ki'ndí‑na̱, maá‑na tsà jyeé k'en, ta̱nga tíjnakon‑né; kichijà‑né ta̱nga i̱'ndei̱ kàsakó‑ne. I̱kjoàn tsibíts'ia̱ s'eí.” ");
INSERT INTO maaNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Jè ti‑la̱ xi ma jchínga, ján tísíxá rancho̱‑la̱. K'e̱ nga j'iì chrañà‑ne ni'ya‑la̱, kiì'nchré‑la̱ música nga s'eí tjín; xi̱ta̱ nchitè. ");
INSERT INTO maaNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","K'e̱é kiìchja̱ jngoò‑la̱ chi̱'nda, kiskònangui‑la̱ mé xi tíma. ");
INSERT INTO maaNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jè chi̱'nda kitsò: “Jè 'ndsì kòf'iì‑ne; jè na̱'èn‑lè kàsík'en jngoò nchra̱ja̱ ki'ndí xi 'ñó xiné, koií kjoa̱‑la̱ nga ndaà kòf'iì‑ne jè 'ndsì.” ");
INSERT INTO maaNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jè ti xi ma jchínga, 'ñó kòjti‑la̱; majìn‑la̱ fahas'en ni'ya; k'e̱é itjo ni'ya na̱'èn‑la̱, tsibítsi'ba‑la̱ nga kàtjahas'en ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kitsò‑la̱ na̱'èn‑la̱: “'A̱n, kjò kjìn nó sìxá‑lè; ni̱kjé‑ne nga mìkiì sìkitasòn‑lè; ni̱ saà jngoò ndí tíndsó ki'ndí 'biì‑ná nga si̱tsjakoa̱a amigo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ta̱nga k'e̱ nga kòf'iì‑ne ki'ndí‑lè xi kisìkjeheya to̱n‑lè, tsojmì‑lè, kisìkjeheyako̱ íchjín ská; i̱kjoàn kànìk'en jngoò‑la̱ nchra̱ja̱ ki'ndí xi 'ñó xiné.” ");
INSERT INTO maaNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jè na̱'èn‑la̱ kitsò‑la̱: “Ngaji̱ xi ki'ndí‑na̱ xan‑lè, i̱í tìjna̱ko̱ kjit'aà‑ná; ngats'iì tsojmì xi tjín‑na, tsi̱ji‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mochjeén‑né nga s'eí s'e̱én mé‑ne nga si̱tsjakoa̱á yijo‑ná, koi kjoa̱‑la̱ nga jè 'ndsì, jye kòf'iì‑ne. Maá‑na tsà jyeé k'en ta̱nga tíjnakon‑né; kichijà‑né ta̱nga i̱'ndei̱ kàsakó‑ne.” ");
INSERT INTO maaNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús tsibéno̱jmí ìjngoò‑la̱ kjoa̱ xi mangásòn, jñà xi̱ta̱ xi kota'yàt'aà‑la̱, kitsò‑la̱: ―Jngoò k'a, jngoò xi̱ta̱ nchi̱ná, tíjna jngoò‑la̱ xi̱ta̱ xi síkinda̱ chi̱'nda. Xi̱ta̱ xi kj'ei̱í kiì nga nguixko̱n nei‑la̱ nga kitsjaàt'in 'én nga tsojmì‑la̱ tísíkje. ");
INSERT INTO maaNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jè nei‑la̱, k'e̱é kiìchja̱‑la̱, kitsò‑la̱: “¿Mé 'én xi tsját'in‑lè xi̱ta̱? Tjiì‑ná kinda̱ kjoa̱ ts'e̱ xá‑lè; mì‑la ti̱ kiì chi̱'nda sko̱‑la̱ ki̱jna‑ne.” ");
INSERT INTO maaNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chi̱'nda jè, k'e̱é tsohóko̱ yijo‑la̱, kitsò: “¿Mé xi s'iaàn? Jè nei‑na̱ mì ti̱ kiì tsjá‑na xá. 'A̱n, mìkiì chíkjoa̱‑na nga siìxákoa̱a nangui. Masobà‑na tsà to̱n siìjé kjo̱tjoà. ");
INSERT INTO maaNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Jyeé be mé xi s'iaàn mé‑ne nga s'e̱‑na amigo xi tsjá'nde‑na ni'ya‑la̱ k'e̱ nga tjáxìn‑na xá jè.” ");
INSERT INTO maaNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","K'e̱é kiìchja̱ ìjngoò ìjngoò‑la̱ jñà xi̱ta̱ xi tje̱n‑la̱ to̱n ts'e̱ nei‑la̱. Kitsò‑la̱ jè xi ítjòn: “¿Kó tjín kitje̱n‑lè ts'e̱ nei‑na̱?” ");
INSERT INTO maaNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Xi̱ta̱ jè kitsò: “Jngoò sìndo̱ barril asìti̱ kitje̱n‑na.” Jè chi̱'nda kitsò‑la̱ xíkjín: “Chjoí xo̱jo̱n‑lè, ti̱jni, ni̱to̱n tìndaà ìjngoiì xi kj'ei̱í xo̱jo̱n xi tà icháte chjí‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","I̱kjoàn kiskònangui‑la̱ xi ìjngoò, kitsò‑la̱: “Ngaji̱, ¿kó tjín kitje̱n‑lè?” Xi̱ta̱ jè kitsò: “Jngoò sìndo̱ naxá trigo kitje̱n‑na.” K'e̱é kitsò‑la̱: “Chjoí xo̱jo̱n‑lè; tìndaà ìjngoiì xi tà ñijòn kaàn chjí‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chi̱'nda jè, kijtseèxkón nei‑la̱ nga tjín‑la̱ kjo̱hítsjeèn nga amigo tsohótsji, na̱s'ín ch'o kis'iìn nga kiskoòna̱cha̱n‑la̱ nei‑la̱. Jñà xi mìtsà xi̱ta̱‑la̱ Nainá, ìsa̱á tjín‑la̱ kjo̱hítsjeèn kó s'ín ótsji amigo‑la̱ xi skoétjò mì k'oa̱á‑ne koni jñà xi̱ta̱ xi iseèn tjín kjo̱hítsjeèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’K'oa̱á xán‑nò, ti̱kjeén to̱n ko̱ tsojmì xi tjín i̱ i̱sò'nde nga kàtas'e‑nò amigo mé‑ne k'e̱ nga mì ti̱ kiì ko̱chjeén‑ne i̱ i̱sò'nde, ján ngajmiì s'e̱‑nò amigo xi skoétjò‑nò ya̱ ñánda ki̱tsa̱jnaà ni̱ta̱ mé na̱chrjein‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Jè xi ndaà síkitasòn jè kjoa̱ xi chiba tjín, ti̱koa̱á ndaà síkitasòn jè kjoa̱ xi tse tjín; ta̱nga jè xi kona̱cha̱n kjoa̱ xi chiba tjín ti̱koa̱á kona̱cha̱n‑né kjoa̱ xi tse tjín. ");
INSERT INTO maaNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jñò, tsà mì ndaà titsa̱nìchjeén tsojmì ko̱ to̱n xi tjín i̱sò'nde jè, mìkiì tjoé‑nò kjoa̱ xi nguì ndaà tjín ts'e̱ ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tsà mì ndaà titsa̱nìkjeén tsojmì ko̱ to̱n xi mì tsa̱jòn‑jèn xi Nainá kisìnga̱tsja‑nò i̱ i̱sò'nde, ti̱koa̱á mìkiì tjoé‑nò xi nguì tsa̱jòn ján ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ni̱jngoò chi̱'nda xi jò ko̱ma nei‑la̱ nga si̱ìxá‑la̱; tsà jò ko̱ma nei‑la̱, jngoò ko̱jtikeè koa̱ jngoò ko̱tsjakeè; jngoò ndaà kjit'aà‑la̱ koa̱ ch'o si̱ìko̱ xi ìjngoò. Jñò, tsà kjoa̱ nchi̱ná si̱ìs'in‑là, mìkiì ko̱s'in‑la̱ kjoa̱ ts'e̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jñà xi̱ta̱ fariseo nga tsjakeè to̱n, k'e̱ nga kiì'nchré ngats'iì kjoa̱ koi, tà tsijnòkeè Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","K'e̱é kitsò‑la̱ jè Jesús: ―Jñò, ndaà nìkítsa̱jnaà yijo‑nò nga nguixko̱n xi̱ta̱, ta̱nga Nainá, beè ini̱ma̱‑nò nga mìtsà kixi̱ kjoa̱ nga ndaà 'nè. Jè kjoa̱ xi jeya síkíjna xi̱ta̱, Nainá ochrjekàngui‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesús kitsò‑ìsa: ―Jñà Xo̱jo̱n‑la̱ Nainá xi kiskiì Moisés ko̱ xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, jñà tímakjeén xo̱jo̱n koi skanda k'e̱ nga j'iì Juan xi kis'iìn bautizar xi̱ta̱. Tje̱n‑ne na̱chrjein koi, skanda i̱'ndei̱, tínokjoáya 'én ndaà‑la̱ Nainá kó s'ín otíxoma Nainá. Ngats'iì xi̱ta̱ xi mejèn‑la̱ kjoa̱has'en‑jiìn ñánda tíhotíxoma Nainá, bínè‑la̱ yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’'Ñó 'in tjín tsà jè i̱sò'nde ko̱ ngajmiì chi̱ja, ta̱nga ìsa̱á tà 'ñó 'in tjín nga chi̱ja jngoò letra ts'e̱ kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. Mìkiì chi̱ja ni̱ta̱ kjé‑ne ―kitsò Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","―Ni̱ta̱ yá‑ne xi tsjiìn chjo̱ón‑la̱ i̱kjoàn bixan‑ko̱ jngoò chjo̱ón xi kj'ei̱í, kjoa̱ chijngui tís'ín; ti̱koa̱á jè x'i̱n xi bixan‑ko̱ chjo̱ón xi kitsjiìn x'i̱n‑la̱, ti̱koa̱á kjoa̱ chijngui tís'ín ―kitsò‑ìsa Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús kitsò: ―Tsibìjna jngoò xi̱ta̱ nchi̱ná xi 'ñó ndaà kjoàn nikje chjí xi tsohòkjá; na̱chrjein inchijòn kis'iìn s'eí xi ta̱xki̱ 'ñó ndaà ma. ");
INSERT INTO maaNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ti̱koa̱ tsibìjna jngoò xi̱ta̱ i̱ma̱ xi Lázaro ki'mì, xi jtsé tjín yijo‑la̱. Ya̱á bìjna xotjoa̱ ni'ya‑la̱ jè xi̱ta̱ nchi̱ná. ");
INSERT INTO maaNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Xi̱ta̱ i̱ma̱ jè, fahajiìn xó‑la̱ jñà xi̱‑la̱ tsojmì xi kine jè xi̱ta̱ nchi̱ná nga bixòngui ími̱xa̱; ti̱koa̱á jñà nañá bijchó xó nga tomàjno jtsé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","K'e̱ nga k'en jè ndí xi̱ta̱ i̱ma̱, jñà àkja̱le̱‑la̱ Nainá kiìko̱; ya̱á kisìkíjnat'aà‑la̱ Abraham. Ti̱koa̱á chaán k'en jè xi̱ta̱ nchi̱ná; i̱kjoàn kisìhijiìn. ");
INSERT INTO maaNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’Ya̱ i̱'nde ts'e̱ mik'en ñánda nga tísíkjeiín kjo̱'in jè xi̱ta̱ nchi̱ná, kiskoòtsejèn, kijtseèxkon Abraham nga kjiìn tíjna; ya̱á tíjnat'aà‑la̱ jè Lázaro. ");
INSERT INTO maaNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Xi̱ta̱ nchi̱ná, k'e̱é 'ñó kiìchja̱ kitsò: “¡Na̱'èn Abraham, cha̱hi̱ma̱‑takòn‑ná! Ti̱kasín Lázaro nga kàtasíka'nchi̱ jnótsja ya̱ i̱jiìn nandá nga kàtasíkijne 'nchán ni̱je̱n‑na̱; 'ñó tse kjo̱'in tìsìkjiaán i̱ i̱jiìn ni'ín.” ");
INSERT INTO maaNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Jè Abraham kitsò‑la̱: “Na̱'èn, ti̱kítsjiìn k'e̱ nga tsijni i̱sò'nde, 'ñó ndaà tsijni. Jè Lázaro, kjo̱'iín kisìkjeiín, ta̱nga i̱'ndei̱, ndaà tíjna i̱jndé. Ngaji̱, kjo̱'iín tìnìkjeiín. ");
INSERT INTO maaNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","K'oa̱á s'ín tjín, ti̱koa̱á jngoò xa̱jngá jñò xi 'ñó na̱nga̱ kijna‑ikòn mé‑ne nga mìkiì ko̱ma ján ko̱tot'aà jñà xi̱ta̱ xi i̱ títsa̱jna; ti̱koa̱ xi títsa̱jna ján, mìkiì ko̱ma kji̱nchrobà i̱jndé.” ");
INSERT INTO maaNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Kitsò jè xi̱ta̱ nchi̱ná: “Na̱'èn Abraham, 'a̱n bìtsi'bà‑lè ti̱kasín Lázaro ya̱ ni'ya‑la̱ Na̱'èn‑na̱; ");
INSERT INTO maaNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","'òn ma‑ne 'ndsè xi títsa̱jna; kàtèno̱jmí‑la̱ xi o̱kixi̱ mé‑ne nga ti̱koa̱ mì i̱ kji̱nchrobà‑ne i̱'nde ts'e̱ kjo̱'in.” ");
INSERT INTO maaNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham kitsò‑la̱: “Xi̱ta̱ xingui̱i, jyeé tjín‑la̱ xo̱jo̱n‑la̱ Moisés ko̱ ts'e̱ xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá; ¡jñà kàta'nchré‑la̱!” ");
INSERT INTO maaNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","K'e̱é kitsò jè xi̱ta̱ nchi̱ná: “Majìn, na̱'èn Abraham, tsà jngoò mik'en xi jye kijtseè kjo̱'in kjoi̱ ke̱èno̱jmí‑la̱, si̱ìkájno jé‑la nga mì ti̱ jé ko̱hótsji‑ne.” ");
INSERT INTO maaNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Jè Abraham kitsò‑la̱: “Tsà mìkiì 'nchré‑la̱ Moisés ko̱ xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, ti̱koa̱á mìkiì ko̱kjeiín‑la̱ na̱s'ín kjoa̱áya jngoò‑la̱ mik'en.” ");
INSERT INTO maaNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Kjit'aà na̱chrjein s'e̱ xi̱ta̱ xi koi̱ìt'in‑ná nga ki̱nchátsjiaá jé, ta̱nga i̱ma̱‑xó‑ne jè xi̱ta̱ xi koi̱ìt'in. ");
INSERT INTO maaNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ìsa̱á‑la ndaà ko̱ma tsà si̱ngui'ñó jngoò nda̱jo̱ natsí ís'iìn, i̱kjoàn si̱katje̱n‑jiìn ndáchikon, mé‑ne nga mì jé ski̱nìjiìn‑ne ndí xi̱ta̱ xi mochjeén‑la̱ nga ko̱kinda̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡T'e̱en kinda̱ yijo‑nò! ’Tsà jè xingui̱i ótsji jé xi kondra̱ tsi̱ji, ti̱nókjoa̱‑la̱ nga kàtakixi̱; tsà si̱ìkájno jé‑la nga mì ti̱ jé ko̱hótsji‑ne, ti̱jchàat'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tsà itoò k'a nga jngoò na̱chrjein ótsji jé xingui̱i xi kondra̱ tsi̱ji, koa̱ tsà si̱ìkájno jé‑la koa̱ tsà itoò k'a nga jngoò na̱chrjein kjoi̱íkon‑lè, ki̱tso̱‑lè: “Mì ti̱ kiì k'oa̱ s'iìn‑na”, tsà k'oa̱ ki̱tso̱‑lè, ti̱jchàat'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jñà xi̱ta̱ xi tsibíxáya‑la̱ Na̱'èn‑ná Jesucristo kitsò‑la̱: ―Ti̱si̱ko̱‑náje̱n mé‑ne nga ìsa̱ 'ñó ndaà ko̱kjeiín‑naje̱n i̱t'aà tsi̱ji. ");
INSERT INTO maaNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jè Na̱'èn‑ná k'e̱é kitsò: ―Jñò, tsà tà o̱kji ko̱kjeiín‑nò koni kji xojmá mostaza nga i̱tsé kji, ko̱maá k'oín‑là yá xanchroò jè: “Chjínèyi yijo‑lè, i̱kjoàn ya̱ kàtatje̱n‑jiìn ndáchikon”; jè yá, k'oa̱á s'ín si̱ìkitasòn‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Jñò, tsà tíjna jngoò‑nò chi̱'nda xi kàfì síkínchi nchra̱ja̱, o xi kàfì ka'ndà tíndsó, k'e̱ nga kjoi̱í‑ne nga kàfì síxá, ¿a k'oín‑là: “Ti̱jni, ti̱jnat'eiì ími̱xa̱”? ");
INSERT INTO maaNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Majìn, a mìtsà ta̱ sa̱ k'oín‑là: “Tìndaà‑ná tsojmì xi kókje̱en; tíxkóngui nikje‑lè; tìya‑ná tsojmì xi kókje̱en ko̱ xi skia̱a. K'e̱ nga jye kjoe̱ ko̱ma, i̱kjoàn ti̱chi koa̱ tioi̱i ji̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Jè nei‑la̱, ti̱koa̱á mìkiì tsjá‑la̱ kjo̱ndaà chi̱'nda‑la̱ nga ndaà kàsìkitasòn jè xá xi kàsit'in‑la̱; mìtsà tsò‑la̱: “Ndaà chjí‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ti̱koa̱á jñò, k'e̱ nga jye nìkitasòn yije xá xi tsjá‑nò Nainá, k'oa̱á tixón: “Ngaje̱n, ta̱xki̱ chi̱'nda‑náje̱n, tà jè kànìkitasòn‑je̱n koni s'ín ki'mì‑náje̱n.” ");
INSERT INTO maaNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús, k'e̱ nga tífì ján na̱xa̱ndá Jerusalén, jahato ya̱ nangui Samaria ko̱ Galilea. ");
INSERT INTO maaNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","K'e̱ nga jahas'en‑jiìn jngoò ndí na̱xa̱ndá xi jtobá kji, te xi̱ta̱ kiskaàjiìn ya̱ i̱ya ndi̱yá xi tíbindojno chrjoa̱ yijo‑la̱; kjiìn chincha‑ne ");
INSERT INTO maaNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","nga 'ñó kiìchja̱ kitsò: ―¡Jesús, Maestro, cha̱hi̱ma̱‑takòn‑náje̱n! ");
INSERT INTO maaNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús, k'e̱ nga kijtseè, kitsò‑la̱: ―Tanguió, ta̱kó‑là yijo‑nò jè no̱'miì. K'oa̱á s'ín komà, k'e̱ nga nchifì‑ne, kjòtsjeè‑ne yijo‑la̱ ch'in xi tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","K'e̱ nga kijtseè yijo‑la̱ nga jye kjòndaà‑ne ch'in xi tjín‑la̱, jngoò‑ne xi inchrobà ìjngoò k'a‑ne; 'ñó kiìchja̱ nga kitsjaà‑la̱ kjo̱ndaà Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tsasèn‑xkó'nchit'aà‑la̱ Jesús skanda i̱t'aà nangui, nga kitsjaà‑la̱ kjo̱ndaà. Xi̱ta̱ jè, Samaria i̱'nde‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús kitsò‑la̱: ―¿A mìtsà te ma‑ne xi kòmatsjeè‑ne ch'in‑la̱? Jñà xi ñijaàn, ¿ñánda títsa̱jna? ");
INSERT INTO maaNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿A tà jè tà jngoò xi̱ta̱ xi xìn nangui‑la̱ kànchrobá ìjngoò k'a‑ne nga tsjá‑la̱ kjo̱ndaà Nainá? ");
INSERT INTO maaNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesús kitsò‑la̱ xi̱ta̱ jè: ―Ti̱sítji̱in, t'in‑ne; koi‑né nga mokjeiín‑lè nga kòmandaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jñà xi̱ta̱ fariseo kiskònangui‑la̱ Jesús, kitsò‑la̱: ―¿Kjé‑né nga jcha̱‑la̱ kó s'ín ko̱tìxoma Nainá? Jesús kitsò‑la̱: ―Koni s'ín otíxoma Nainá mìtsà tsejèn jcha̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mìtsà yá xi ki̱tso̱: “I̱í tíjna i̱jndé”, ko̱ “Ján tíjna ján”; nga jyeé tíjnajiìn‑nò kó s'ín otíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesús, kiìchja̱‑ìsa; kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Ki̱jchò na̱chrjein k'e̱ nga ko̱mejèn‑nò jcha̱xkoòn‑ná nga jye kóti̱jnajiìn‑nò 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, ta̱nga na̱chrjein jè, mìkiì jcha̱xkoòn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","K'oa̱á ki̱tso̱‑nò xi̱ta̱: “Chítsejèn‑là i̱jndé, chítsejèn‑là ján.” Ta̱nga kì kiì mokjeiín‑nò, ti̱koa̱á kì kiì onguítji̱ngui‑là na̱s'ín k'oa̱ ki̱tso̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Koni ma ni'ín ch'o̱n k'e̱ nga ote, ma iseèn kó o̱kji nga jngoò itjandiì, k'oa̱á s'ín ko̱ma k'e̱ nga ki̱jchò na̱chrjein nga kjoia̱a ìjngoò k'a xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ta̱nga 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, ítjòn, tse kjo̱'in siìkjiaán; jñà xi̱ta̱ xi tjín na̱chrjein i̱'ndei̱, ko̱chrjekànguií‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Koni s'ín komà jñà na̱chrjein ts'e̱ Noé, k'oa̱á ti̱s'ín ko̱ma jñà na̱chrjein k'e̱ nga kjoia̱a ìjngoò k'a 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Xi̱ta̱, tsakjèn, kits'iì, chixàn íchjá ko̱ íchjín skanda jè na̱chrjein nga jahas'en ni'ya chitso jè Noé, i̱kjoàn j'iì jtsí xkón, ya̱á jyehesòn yije xi̱ta̱ kóho̱tjín. ");
INSERT INTO maaNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","K'oa̱á ti̱s'ín komà na̱chrjein ts'e̱ Lot xi̱ta̱ xi tsiniì kitsò‑la̱ Abraham. Jñà xi̱ta̱ tsakjèn, kits'iì, tsatse tsojmì, tsatíjna tsojmì, tsibítje̱ tsojmì, tsibíndaà ni'ya; ");
INSERT INTO maaNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ta̱nga jè na̱chrjein nga itjojiìn jè Lot ya̱ na̱xa̱ndá Sodoma, ts'a jtsí ni'ín xi ngajmiì inchrobà‑ne xi nguì chijo azufre, ya̱á jyehesòn yije xi̱ta̱ kóho̱tjín. ");
INSERT INTO maaNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","K'oa̱á s'ín ko̱ma jè na̱chrjein k'e̱ nga 'a̱n kítjo̱je̱n ìjngoò k'a xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Jè xi tíjnasò'nga ni'ya‑la̱, kì ti̱ kiì nchrobájen‑ne nga skoé tsojmì xi 'ncha ni'ya‑la̱; ti̱koa̱á jè xi tísíxájiìn nangui‑la̱ kì ti̱ kiì nchrobá‑ne ni'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ti̱kítsjeèn koni s'ín komàt'in chjo̱ón‑la̱ Lot. ");
INSERT INTO maaNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ni̱ta̱ yá xi̱ta̱ xi mejèn‑la̱ ko̱chrjetjì yijo‑la̱ nga mì mé kjo̱'in sa̱kò‑la̱, tà sa̱á si̱ìchija‑né ko̱ kjo̱'in kíjnajiìn; ta̱nga jè xi tíjnandaà nga tsjá yijo‑la̱, jè‑né xi ki̱tjokàjiìn kjo̱'in nga i̱t'aà ts'a̱n ndaà kíjna. ");
INSERT INTO maaNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’K'oa̱á xan‑nò, jè ni̱tje̱n k'e̱ nga o̱ko̱ma, tjín ni'ya ñánda jò xi̱ta̱ kjioòsòn na̱chan, jngoò tjámiìtje̱n nga kji̱ko̱ Cristo, xi ìjngoò si̱jna‑né nga kjo̱'in s'e̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ti̱koa̱á tjín ni'ya ñánda jò íchjín nchi'o na̱'yo̱, jngoò tjámiìtje̱n nga kji̱ko̱ Cristo, xi ìjngoò si̱jna‑né nga kjo̱'in s'e̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","’Jò xi̱ta̱ xi nchisíxángui rancho̱‑la̱, jngoò tjámiìtje̱n nga kji̱ko̱ Cristo, jè xi ìjngoò sa̱síjna‑né nga kjo̱'in s'e̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jñà xi̱ta̱ kiskònangui‑la̱ Jesús: ―¿Ñánda‑ne nga k'oa̱s'ín ko̱ma Na̱'èn? Jesús kitsò‑la̱: ―Ya̱ ñánda kijna cho̱ k'en, ya̱á kítsa̱jnajtín jñà líké. ");
INSERT INTO maaNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús ti̱koa̱ tsibéno̱jmí jngoò‑la̱ kjoa̱ xi mangásòn nga mochjeén‑né nga mìkiì si̱ìndaàjñaá ini̱ma̱‑ná; na̱chrjein inchijòn ki̱nókjoa̱t'aà‑lá Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kitsò‑la̱: ―Jngoò na̱xa̱ndá ñánda tíjna jngoò xi̱ta̱xá xi mìkiì beèxkón Nainá ti̱koa̱ mìkiì beèxkón xi̱ta̱ xi kj'ei̱í. ");
INSERT INTO maaNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ti̱ya̱‑ne na̱xa̱ndá jè, tíjna jngoò chjo̱ón ka'àn xi f'iìkon kjit'aà xi̱ta̱xá jè nga tsò‑la̱: “Tìndaàjiìn‑ná kjoa̱ ts'e̱ kondra̱‑na̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Jè xi̱ta̱ xi tjín‑la̱ xá, mìkiì xátí tsibíndaàjiìn‑la̱, ta̱nga xi komà i̱skan kisìkítsjeèn nga tsibíndaàjiìn‑la̱ jè chjo̱ón mé‑ne nga mì ta̱ tsja si̱ìjti‑la̱. Kitsò i̱jiìn ini̱ma̱‑la̱: “Na̱s'ín mìkiì bexkoán Nainá, ti̱koa̱ mìkiì bexkoán xi̱ta̱, ");
INSERT INTO maaNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ta̱nga chjo̱ón jè, 'ñó tísísiì‑na, koií kjoa̱‑la̱ nga kìndaàjiìn‑la̱ mé‑ne nga mì ta̱ tsja i̱ kjoi̱íkon‑na, mì ta̱ tsja 'a̱n si̱ìjti‑na.” ");
INSERT INTO maaNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kitsò Na̱'èn‑ná: ―Ti̱ná'ya‑là koni tsò xi̱ta̱xá xi tsjìn‑la̱ o̱kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nainá, ¿a mìtsà ìsa̱ ndaà si̱ìs'in‑la̱ xi̱ta̱‑la̱ xi xó k'oa̱s'ín jaàjiìn‑ne nga ko̱ na̱chrjein ko̱ ni̱tje̱n 'ñó si̱jét'aà‑la̱? ¿A mìtsà ìsa̱ ni̱to̱n si̱ìs'in‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","K'oa̱á xán‑nò nga ìsa̱ xátíya koi̱ìndaàjiìn‑la̱. Ta̱nga k'e̱ nga kjoia̱a ìjngoò k'a 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, ¿a sakó‑na xi̱ta̱ i̱ i̱sò'nde xi mokjeiín‑la̱ i̱t'aà ts'a̱n? ");
INSERT INTO maaNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús tsibéno̱jmí ìjngoò‑la̱ kjoa̱ xi mangásòn ts'e̱ xi̱ta̱ xi xi̱ta̱ kixi̱ tsò‑la̱ yijo‑la̱ koa̱ ochrjekàngui xi i'nga. Kitsò: ");
INSERT INTO maaNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Jò xi̱ta̱ kiì ñánda tíjna i̱ngo̱ ítjòn nga kiìchja̱t'aà‑la̱ Nainá: jngoò xi xi̱ta̱ fariseo, xi ìjngoò, xi̱ta̱‑la̱ xi̱ta̱xá Roma xi síkíchjítjì tsojmì. ");
INSERT INTO maaNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Jè xi̱ta̱ fariseo, nga síjna kixi̱, tíchja̱tjì yijo‑la̱, kitsò: “Nainá, tsjaà‑lè kjo̱ndaà, ndaà chjí‑lè nga 'a̱n mì k'oa̱á s'iaàn koni s'ín xi̱ta̱ xi kj'ei̱í xi tsjìn‑la̱ kjoa̱ kixi̱, xi̱ta̱ chijé, xi̱ta̱ ts'e̱n, xi̱ta̱ chijngui; ni̱ mì k'oa̱á s'iaàn koni s'ín jè xi̱ta̱ xi síkíchjítjì tsojmì. ");
INSERT INTO maaNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jò k'a óti̱jnachjan nga jngoò xomàna̱; tsjaà‑ná xi teya ngats'iì xi sìkijne.” ");
INSERT INTO maaNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ta̱nga jè xi̱ta̱ xi síkíchjítjì tsojmì, kjiìn síjna; skanda majìn‑la̱ nga ko̱tsejèn ngajmiì; tà jè ini̱ma̱‑la̱ 'beé‑la̱; tsò: “¡Nainá, kàtas'e‑lè kjo̱hi̱ma̱takòn xi i̱t'aà ts'a̱n nga xi̱ta̱ jé 'mì‑na!” ");
INSERT INTO maaNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","K'oa̱á xán‑nò, xi̱ta̱ jè, k'e̱ nga kiì‑ne ni'ya‑la̱, jyeé xi̱ta̱ kixi̱ kitsò‑la̱ Nainá; ta̱nga jè xi̱ta̱ fariseo majìn. Koií kjoa̱‑la̱, ni̱ta̱ yá‑ne xi 'nga síkíjna yijo‑la̱, ìsa̱á nangui kíjna, koa̱ jè xi nangui síkíjna yijo‑la̱, ìsa̱á 'nga kíjna. ");
INSERT INTO maaNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ti̱koa̱á j'iìko̱‑la̱ ndí i̱xti mé‑ne nga ko̱òt'aà‑la̱ tsja; jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, k'e̱ nga kijtseèxkon jñà xi̱ta̱ xi ijchòko̱ ndí i̱xti, tsohótiko̱. ");
INSERT INTO maaNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ta̱nga jè Jesús kiìchja̱‑la̱ jñà i̱xti; kitsò‑la̱ xi̱ta̱‑la̱: ―Tjiì'nde‑là jñà ndí i̱xti nga kàtjanchrobákon‑na, kì binchahikon‑là. Jñà xi k'oa̱ s'ín tjín ini̱ma̱‑la̱ koni ts'e̱ ndí i̱xti, jñà xi tjín‑la̱ kjo̱ndaà nga Nainá tíhotíxoma‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","K'oa̱á xan‑nò xi nguì o̱kixi̱, jñà xi mìkiì ko̱kjeiín‑la̱ koni jngoò ndí i̱xti nga skoé kjo̱ndaà‑la̱ Nainá nga jè ko̱tìxoma‑la̱, mìkiì kjoa̱has'en‑jiìn ñánda tíhotíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jngoò xi xi̱ta̱ sko̱‑la̱ kiskònangui‑la̱ Jesús kitsò: ―Maestro ndaà, ¿mé xi s'iaàn nga s'e̱‑na kjoa̱binachon ni̱ta̱ kjé‑ne? ");
INSERT INTO maaNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús kitsò‑la̱: ―¿Mé‑ne nga xi̱ta̱ ndaà 'mì‑ná? Ni̱jngoò xi̱ta̱ xi ndaà; ta̱ jngoò jè Nainá xi ndaà. ");
INSERT INTO maaNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Jyeé tíjiìn‑lè kó tsò kjo̱tíxoma: “Kì kjoa̱ chijnguií 'nì, kì xi̱ta̱á nìk'in, kì chijé 'nì, kì 'én ndiso nokjoì i̱t'aà ts'e̱ xi̱ta̱ xi kj'ei̱í, cha̱xkoín na̱'èn‑lè ko̱ nea̱‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Xi̱ta̱ jè kitsò: ―Ngats'iì kjo̱tíxoma koi, jyeé kisìkitasoàn kó nga sa̱ chítia. ");
INSERT INTO maaNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","K'e̱ nga kiì'nchré Jesús, kitsò‑la̱: ―Nguì jngoò kjoa̱ chija‑lè: tatìjni yiji kóho̱tjín tsojmì xi tjín‑lè; i̱kjoàn ti̱ka'bí‑la̱ xi̱ta̱ i̱ma̱ mé‑ne nga s'e̱‑lè kjoa̱ machikon‑t'in ján ngajmiì. I̱kjoàn nchrobátji̱ngui‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Xi̱ta̱ jè, k'e̱ nga kiì'nchré, tà kjòbaá‑la̱, koií kjoa̱‑la̱ nga 'ñó nchi̱ná. ");
INSERT INTO maaNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús, k'e̱ nga kijtseè nga 'ñó ba kis'e‑la̱ kitsò: ―¡Jñà xi̱ta̱ nchi̱ná, 'iín ko̱ma‑la̱ nga kjoa̱has'en‑jiìn ñánda tíhotíxoma Nainá! ");
INSERT INTO maaNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ìsa̱á mì 'in ko̱ma‑la̱ jngoò cho̱ camello nga kjoa̱has'en xko̱n nindoò xi tjahaña‑ne nikje, mì k'oa̱á‑ne koni jngoò xi̱ta̱ nchi̱ná xi 'ñó tjín‑la̱ tsojmì nga ko̱ma kjoa̱has'en‑jiìn ñánda tíhotíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jñà xi̱ta̱ xi kiì'nchré kitsò: ―¿Yá‑né xi ki̱tjokàjiìn kjo̱'in? ");
INSERT INTO maaNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús kitsò‑la̱: ―Jè kjoa̱ xi mìkiì ko̱ma‑la̱ xi̱ta̱, Nainá ko̱maá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","K'e̱é kitsò Pedro: ―Na̱'èn, ngaje̱n, jyeé kinìkítsa̱jna yije‑je̱n tsojmì xi tjín‑naje̱n nga tjaàtji̱ngui‑lèje̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús kitsò‑la̱: ―O̱kixi̱í xi xan‑nò, ngats'iì xi̱ta̱ xi kitsjiìn‑takòn ni'ya‑la̱, na̱'èn‑la̱, 'ndse̱, chjo̱ón‑la̱, i̱xti‑la̱, nga mejèn‑la̱ k'oa̱s'ín si̱ìjchá yijo‑la̱ koni s'ín otíxoma Nainá, ");
INSERT INTO maaNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ngats'iì xi̱ta̱ koi, tsojmì xi kisìkítsa̱jna, ìsa̱á tse tjoé ngajo‑la̱ jñà na̱chrjein xi titsa̱jnaá i̱'ndei̱ i̱ i̱sò'nde; koa̱ jñà na̱chrjein xi sa̱ nchrobá, s'e̱é‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús kiìchja̱t'aà xìn‑la̱ xi̱ta̱‑la̱ xi tejò ma‑ne, kitsò‑la̱: ―I̱'ndei̱, ján onguiá Jerusalén; ya̱á ki̱tasòn yije ngats'iì kjoa̱ xi tjít'aà xo̱jo̱n i̱t'aà ts'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, koni s'ín kiskiì xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ya̱á si̱ìnga̱tsja‑na i̱t'aà ts'e̱ xi̱ta̱ xi mìtsà xi̱ta̱ judío; ki̱jno̱keè‑na; ch'o si̱ìko̱‑na; ki̱ìchrájno‑na; ");
INSERT INTO maaNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ko̱jà‑na, i̱kjoàn si̱ìk'en‑na; ta̱nga xi ko̱ma jàn na̱chrjein kjoa̱áya‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ta̱nga jñà xi̱ta̱‑la̱ mìkiì kjòchi̱ya‑la̱ 'én xi tsibéno̱jmí‑la̱; tjí'maá‑la̱; mìkiì jahas'en‑jiìn‑la̱ koni s'ín kitsò Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","K'e̱ nga jye tímachrañàt'aà nga ki̱jchò Jesús ya̱ na̱xa̱ndá Jericó, jngoò xi̱ta̱ i̱ma̱ xi mìkiì tsejèn‑la̱ tíjna i̱ndiì ndi̱yá; tísíjé kjo̱tjò to̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Xi̱ta̱ jè, k'e̱ nga kiì'nchré nga kjìn xi̱ta̱ nchifa, kiskònangui mé kjoa̱ xi tíma. ");
INSERT INTO maaNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","K'e̱é kitsò‑la̱ xi̱ta̱ nga jè Jesús xi Nazaret ts'e̱ tífahato. ");
INSERT INTO maaNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","K'e̱é 'ñó kiìchja̱, kitsò: ―¡Jesús, nga ya̱ nchrobàt'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David nga ji̱ tijna ngajo‑la̱, jcha̱hi̱ma̱takòn‑ná! ");
INSERT INTO maaNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jñà xi̱ta̱ xi tjíma ítjòn, tsohótiko̱ nga jyò kàtìjna; ta̱nga jè, ìsa̱á 'ñó kiìchja̱ nga kitsò: ―¡Ji̱ xi ya̱ nchrobàt'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David, jcha̱hi̱ma̱takòn‑ná! ");
INSERT INTO maaNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","K'e̱é tsasìjna Jesús; kitsò: “Nchrobáko̱ò.” K'e̱ nga ijchò kasìt'aà chrañà‑la̱ kiskònangui‑la̱, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Mé xi mejèn‑lè nga siìko̱‑lè? Jè xi̱ta̱ xi mìkiì tsejèn‑la̱, kitsò: ―Na̱'èn, mejèn‑na nga kàtatsejèn‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús kitsò‑la̱: ―¡Kàtatsejèn‑lè! Koi‑né nga mokjeiín‑lè nga kòmandaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Xi̱ta̱ jè, ni̱to̱ón kjòtsejèn‑la̱, i̱kjoàn kiìtji̱ngui‑la̱ Jesús; jeya kisìkíjna Nainá. Ngats'iì xi̱ta̱ na̱xa̱ndá xi kijtseè kjoa̱ koi, ti̱koa̱á jeya kisìkíjna Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús k'e̱ nga ijchò na̱xa̱ndá Jericó, tsibíts'ia̱ nga jahas'en‑jiìn na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ya̱ tíjna jngoò xi̱ta̱ xi 'mì Zaqueo xi xi̱ta̱ sko̱‑la̱ jñà xi̱ta̱‑la̱ xi̱ta̱xá Roma xi síkíchjítjì tsojmì; ti̱koa̱ 'ñó xi̱ta̱ nchi̱ná. ");
INSERT INTO maaNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mejèn‑la̱ nga skoe̱xkon yá‑né xi 'mì Jesús; ta̱nga mìkiì ma kotsejèn‑la̱ nga kjìn ma‑ne xi̱ta̱, nga jtobá kji Zaqueo. ");
INSERT INTO maaNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","K'e̱é tsangachikon ítjòn, i̱kjoàn tsijin‑jno jngoò yá sicómoro nga mejèn‑la̱ skoe̱xkon Jesús koni s'ín kjoa̱hato. ");
INSERT INTO maaNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","K'e̱ nga jahaya ndi̱yá Jesús, kiskoòtsejèn mijìn k'oa̱ kijtseèxkon Zaqueo nga ya̱ tíjna'a yá; kitsò‑la̱: ―Zaqueo, ni̱to̱ón tita̱ji̱in, i̱'ndei̱ mochjeén‑né nga ya̱ siìkjáya ni'ya‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueo, ni̱to̱ón tsitajen. Tsjaá komà‑la̱ nga kitsjaà'nde‑la̱ ni'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jñà xi̱ta̱ k'e̱ nga kijtseè nga ya̱ kisìkjáya ni'ya‑la̱ Zaqueo, tsibíts'ia̱ nga kiìchja̱jno‑la̱ Jesús; kitsò nga ya̱ kisìkjáya ni'ya‑la̱ xi̱ta̱ xi jé tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","K'e̱é tsasìjna kixi̱ Zaqueo, kitsò: ―Na̱'èn, osen tsojmì xi tjín‑na tsjaà‑la̱ xi̱ta̱ i̱ma̱; koa̱ tsà tjín xi̱ta̱ xi 'a̱n kiskoòna̱cha̱an‑la̱, ñijòn k'a ko̱kji tsjaà ngajo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús kitsò‑la̱: ―Ngats'iì xi̱ta̱ nei‑la̱ ni'ya jè, na̱chrjein i̱'ndei̱, jyeé kòbitjokàjiìn kjoa̱ ts'e̱ jé‑la̱, koií kjoa̱‑la̱ nga k'oa̱s'ín mokjeiín‑la̱ Zaqueo koni jè xi̱ta̱ jchínga‑la̱ Abraham. ");
INSERT INTO maaNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","’'A̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, koií xá j'i̱‑na nga j'i̱ katsjià xi̱ta̱ xi kichijà, ti̱koa̱ j'i̱ kàchrjekàjñaà jé‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jñà xi̱ta̱, k'e̱ nga nchi'nchré‑la̱ Jesús, koni s'ín tíbéno̱jmí kjoa̱ koi, k'oa̱á s'ín kisìkítsjeèn nga ya̱á koi̱ìts'ia̱ ni̱to̱n nga ko̱tìxoma Nainá; nga jè Jesús, jyeé kjo̱meè bijchó chrañà Jerusalén. Koií kjoa̱‑la̱, Jesús, tsibéno̱jmí jngoò‑la̱ kjoa̱ xi mangásòn nga mìtsà k'oa̱s'ín ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kitsò‑la̱: ―Jngoò k'a, jngoò xi̱ta̱ xi tje̱‑la̱ xi̱ta̱ ítjòn kiì jngoò nangui ñánda 'ñó kjiìn nga tjoé‑la̱ xá ítjòn, i̱kjoàn kji̱nchrobà‑ne k'e̱ nga jye tjoé‑la̱ xá. ");
INSERT INTO maaNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ta̱nga k'e̱ nga ti̱kj'eè bitjo xi̱ta̱ jè, te xi̱ta̱ chi̱'nda‑la̱ kiìchja̱‑la̱ nga tse to̱n kisìnga̱tsja nga jngoò ìjngoò; kitsò‑la̱: “Chjoé to̱n koi, ti̱xáko̱o skanda k'e̱ nga kjoi̱‑na.” ");
INSERT INTO maaNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ta̱nga jñà xi̱ta̱ xi ti̱ya̱‑ne na̱xa̱ndá‑la̱ nga jtikeè komà, kisìkasén‑tji̱ngui i'nga‑la̱ xi̱ta̱ xi kitsò‑la̱ xi̱ta̱xá ítjòn: “Majìn‑naje̱n nga jè xi̱ta̱xá jè ko̱tìxoma‑naje̱n.” ");
INSERT INTO maaNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Ta̱nga jè xi̱ta̱ jè, k'e̱ nga jye kitjoé‑la̱ xá, j'iì ìjngoò k'a‑ne nangui‑la̱. I̱kjoàn kiìchja̱‑la̱ ngats'iì xi̱ta̱ chi̱'nda‑la̱ xi kisìnga̱tsja to̱n mé‑ne nga skoe̱ kó tjín kisìkijne ki'ndí‑la̱ jè to̱n xi kisìnga̱tsja nga jngoò ìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Jè xi̱ta̱ xi j'iì ítjòn kitsò: “Na̱'èn, to̱n‑lè xi kinìnga̱tsja‑ná, te k'a o̱kji kisìkijnesòn ki'ndí‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jè xi̱ta̱xá ítjòn kitsò‑la̱: “Ndaà tjín; ngaji̱, chi̱'nda ndaà‑né; ndaà kinìkjiín to̱n xi chiba kjònga̱tsjei; i̱'ndei̱, te na̱xa̱ndá sìnga̱tsja‑lè xi ji̱ ko̱ti̱xoma‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ijchò ìjngoò xi ma‑ne jò chi̱'nda, kitsò: “Na̱'èn, to̱n‑lè xi kinìnga̱tsja‑ná, 'òn k'a o̱kji kisìkijnesòn ki'ndí‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jè xi̱ta̱xá ítjòn kitsò: “Ti̱koa̱á ngaji̱, 'òn na̱xa̱ndá sìnga̱tsja‑lè xi ji̱ ko̱ti̱xoma‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’J'iì ìjngoò xi kitsò: “Na̱'èn, i̱ tíjna to̱n‑lè xi kinìnga̱tsja‑ná. Ndaà tsibìtjoà; pahìto̱ tsibìjté'ñoá. ");
INSERT INTO maaNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kitsakjoón‑lè; ngaji̱, xi̱ta̱ jti‑takòn‑né; chjoí xi mì ngaji̱í tsibìjni ti̱koa̱ bìxkoí xi mì ngaji̱ tsibìtji̱i.” ");
INSERT INTO maaNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jè xi̱ta̱xá ítjòn kitsò: “Ngaji̱ xi chi̱'nda ch'o 'mì‑lè; ti̱jè‑ne 'én xi nokjoì si̱nè‑lè jé, nga si: xi̱ta̱ jti‑takòn‑né; chjoí xi mì ngaji̱ tsibìjni ti̱koa̱ bìxkoí xi mì ngaji̱ tsibìtji̱i. ");
INSERT INTO maaNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tsà jye tíjiìn‑lè, ¿mé‑ne mì ya̱á kinìkíjna‑ne to̱n‑na̱ ya̱ banco nga kisìkijnesòn ki'ndí‑la̱ mé‑ne k'e̱ nga kjoi̱ ìjngoò k'a‑na si̱nga̱tsja‑ná to̱n‑na̱?” ");
INSERT INTO maaNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","K'e̱é kitsò‑la̱ jñà xi̱ta̱ xi ya̱ títsa̱jna: “Chja̱à'an‑là to̱n; jè tjiì‑là xi̱ta̱ xi te k'a kisìkijnesòn.” ");
INSERT INTO maaNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jñà xi̱ta̱ xi o̱ki'mì‑la̱ kitsò: “Na̱'èn, ¡xi̱ta̱ jè, jyeé kò te k'a ko̱tjín tjín‑la̱!” ");
INSERT INTO maaNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jè xi̱ta̱xá ítjòn kitsò: “K'oa̱á xán‑nò, ngats'iì xi tjín‑la̱, k'oi̱í‑ìsa‑la̱; ta̱nga jè xi tsjìn‑la̱, skanda tjá'aán‑la̱ mé xi chiba tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ti̱koa̱ jñà xi̱ta̱ kondra̱‑na̱ xi majìn‑la̱ nga 'a̱n kotiìxoma‑la̱, nchrohóko̱‑ná i̱jndé, ti̱k'eèn nga nguixkoaàn.” ");
INSERT INTO maaNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","K'e̱ nga jye o̱kitsò Jesús, kiì ítjòn‑la̱ xi̱ta̱‑la̱ nga kiìko̱ ján Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","K'e̱ nga jye ijchò chrañà jñà na̱xa̱ndá xi 'mì Betfagé ko̱ Betania ya̱ chrañàt'aà‑la̱ jè nindoò xi 'mì Yá Olivo, kisìkasén jò xi̱ta̱ xi kota'yàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Kitsò‑la̱: ―Tanguió ján ndí na̱xa̱ndá i̱tsé xi kijnat'aà ján; k'e̱ nga kijchoò, ya̱á síjnat'aà'ñó jngoò ndí búrró ki'ndí xi ni̱ sa̱ yá xi̱ta̱ bìjnasòn‑la̱. Chíjnda̱'ñó, nchrohóko̱o. ");
INSERT INTO maaNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tsà yá xi kjònangui‑nò, tsà ki̱tso̱‑nò: “¿Mé‑ne chíjnda̱'ñó‑nò?”, tìn‑là: “Jè xó Na̱'èn‑ná Jesús ko̱chjeén‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kiì jñà xi̱ta̱‑la̱; k'oa̱á s'ín kisakò‑la̱ koni s'ín tsibéno̱jmí‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","K'e̱ nga nchikíjnda̱'ñó ndí búrró ki'ndí, kitsò nei‑la̱: ―¿Mé‑ne chíjnda̱'ñó‑nò ndí búrró? ");
INSERT INTO maaNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jñà xi̱ta̱‑la̱ Jesús kitsò: ―Jè xó ko̱chjeén‑la̱ Na̱'èn‑ná Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","K'e̱ nga ijchòko̱ ñánda tíjna Jesús, jñà kisìkjeén nikje‑la̱ nga tsohójtsa‑la̱ ndí búrró; i̱kjoàn kisìkíjnasòn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Koni s'ín tífì Jesús, jñà xi̱ta̱ tsohójngoò nikje‑la̱ ya̱ i̱ya ndi̱yá. ");
INSERT INTO maaNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","K'e̱ nga jye kjòchrañàt'aà nga nchifìjen ya̱ nindoò Yá Olivo, ngats'iì xi̱ta̱ xi kota'yàt'aà‑la̱ xi tji̱ko̱ tsibíts'ia̱ nga 'ñó kiìchja̱ xi nguì tà kjo̱tsja‑la̱ nga kitsjaà‑la̱ kjo̱ndaà Nainá nga koií kjoa̱‑la̱ jñà kjo̱xkón xi jye kijtseè. ");
INSERT INTO maaNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kitsò: ―Mé tà ndaà‑la̱ jè xi̱ta̱xá ítjòn xi jè nchrobá ngajo‑la̱ Nainá. Tjín kjoa̱'nchán i̱t'aà ngajmiì. Ti̱koa̱ tjín kjoa̱jeya. ");
INSERT INTO maaNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jñà xi̱ta̱ fariseo xi ya̱ ta̱ña tji̱ko̱ xi̱ta̱ kjìn kitsò‑la̱: ―¡Maestro, jchi̱tikoi̱i xi̱ta̱ xi kota'yàt'aà‑lè! ");
INSERT INTO maaNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ta̱nga jè Jesús kitsò‑la̱: ―K'oa̱á xán‑nò tsà jñà xi̱ta̱ koi kítsa̱jnajyò, jñà nda̱jo̱ ki̱chja̱. ");
INSERT INTO maaNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesús, nga jye ijchò chrañà na̱xa̱ndá Jerusalén, k'e̱ nga kijtseèxkon, kiskindàyakeè xi i̱t'aà ts'e̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kitsò: ―Jñò xi xi̱ta̱ na̱xa̱ndá Jerusalén 'mì‑nò, tsà jè‑là‑ne na̱chrjein i̱'ndei̱ ko̱kjeiín‑nò i̱t'aà ts'e̱ jè kjoa̱ xi tsjá‑nò kjoa̱'nchán; ta̱nga i̱'ndei̱, tjí'maá‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kjoi̱í na̱chrjein k'e̱ nga jñà kondra̱‑nò koi̱ìndiì‑nò chrjó nda̱jo̱, si̱ìkinda̱‑nò ko̱ kít'aà‑nò nga jngoò itjandiì. ");
INSERT INTO maaNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Jngoò k'a si̱ìkjehesòn‑nò, si̱ìk'en yijeé‑nò; ni̱í ti̱ jngoò nda̱jo̱ si̱yijòsòn‑la̱ xíkjín. Koií jé xi ko̱ma‑nò nga mìkiì kiyaxkoòn Nainá k'e̱ nga j'iì katsejèn‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús jahas'en ya̱ ñánda kijna i̱ngo̱ ítjòn, i̱kjoàn tsibíts'ia̱ nga tsachrje jñà xi̱ta̱ xi nchihotíjna ko̱ xi nchihotse tsojmì; ");
INSERT INTO maaNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kitsò‑la̱: ―K'oa̱á s'ín tíchja̱ Xo̱jo̱n xi tjít'aà 'Én Tsjeè‑la̱ Nainá: “Ni'ya‑na̱, ni'ya ts'e̱ o̱chikon‑né, ta̱nga jñò, nguijo‑la̱ xi̱ta̱ chijé titsa̱'nè.” ");
INSERT INTO maaNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesús, na̱chrjein inchijòn tsakóya‑la̱ xi̱ta̱ ya̱ ndi̱tsin i̱ngo̱ ítjòn; jñà xi̱ta̱ sko̱‑la̱ no̱'miì, xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, ko̱ jñà xi̱ta̱ sko̱‑la̱ na̱xa̱ndá, nchihótsji'nde‑la̱ nga mejèn‑la̱ si̱ìk'en Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ta̱nga mìkiì kisakò‑la̱ kó s'ín si̱ìko̱ nga jñà xi̱ta̱ na̱xa̱ndá, 'ñó ndaà nchi'nchré‑la̱ koni s'ín tsò 'én xi tíbéno̱jmí. ");
INSERT INTO maaNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jngoò na̱chrjein, k'e̱ nga jè Jesús tíhokóya‑la̱ xi̱ta̱ 'én ndaà‑la̱ Nainá ya̱ ndi̱tsin i̱ngo̱ ítjòn, ijchò xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés; kjihijtako̱ xi̱ta̱ jchínga. ");
INSERT INTO maaNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kitsò‑la̱: ―Koa̱tìn‑náje̱n, ¿mé kjo̱tíxoma xi tsjá'nde‑lè koni s'ín 'nì? ¿Yá xi kitsjaà‑lè kjo̱tíxoma koi? ");
INSERT INTO maaNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kiìchja̱ Jesús, kitsò: ―Ti̱koa̱á 'a̱n, jngoò kjoa̱ skònangui‑nò. Koa̱tìn‑ná: ");
INSERT INTO maaNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Yá xi kitsjaà‑la̱ kjo̱tíxoma Juan nga kis'iìn bautizar xi̱ta̱? ¿A Nainá‑né xi tíjna ngajmiì, o xi tà xi̱ta̱‑né? ");
INSERT INTO maaNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jñà xi̱ta̱ koi k'e̱é tsajoóya‑ne; kitsò‑la̱ xíkjín: ―Tsà kixoán: “Nainá kitsjaà‑la̱ kjo̱tíxoma”, ki̱tso̱‑né: “¿Mé‑ne nga mìkiì kòkjeiín‑nò i̱t'aà ts'e̱?” ");
INSERT INTO maaNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ti̱koa̱ tsà kixoán: “I̱t'aà ts'e̱ xi̱ta̱‑né”, jñà xi̱ta̱ na̱xa̱ndá nda̱jo̱ó koi̱ì'nè‑ná nga k'oa̱á s'ín mokjeiín‑la̱ nga jè Juan xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","K'e̱é kitsò: ―Mìkiì 'ya‑je̱n yá xi kitsjaà‑la̱ kjo̱tíxoma. ");
INSERT INTO maaNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jè Jesús, kitsò‑la̱: ―Ti̱koa̱á 'a̱n, mìkiì k'oa̱ xán‑nò yá‑né xi kitsjaà‑na kjo̱tíxoma koni s'ín s'iaàn. ");
INSERT INTO maaNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","I̱kjoàn tsibíts'ia̱ Jesús nga kiìchja̱‑la̱ xi̱ta̱ na̱xa̱ndá; tsibéno̱jmí jngoò‑la̱ kjoa̱ xi mangásòn, kitsò: ―Jngoò k'a jngoò xi̱ta̱ tsibítje̱ toò uva, i̱kjoàn kisìkìña‑la̱ xi̱ta̱ xi kj'ei̱í nga kisìxásòn; jè nei‑la̱ nangui, kjiìn nó kiì. ");
INSERT INTO maaNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","K'e̱ nga ijchò na̱chrjein nga jye kòjchá toò uva, jè nei‑la̱, kisìkasén jngoò chi̱'nda‑la̱ nga tjoé chiba‑la̱ chjí‑la̱ toò uva xi jè oko̱‑la̱; ta̱nga jñà xi̱ta̱ xi kisìxásòn nangui, tà kiskaàn‑ko̱‑né, tà kisìkasén tiyaá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Xi komà i̱skan, jè nei‑la̱ nangui ìjngoò xi̱ta̱ chi̱'nda‑la̱ kisìkasén; k'oa̱á ti̱s'ín kisìko̱; kiskaàn‑ko̱, ch'o kisìko̱, i̱kjoàn kisìkasén tiya‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ìjngoò kisìkasén xi ma‑ne jàn xi̱ta̱ chi̱'nda; tà ngásòn kisìko̱; kisìki'on, koa̱ tsachrjekàjiìn nangui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’K'e̱é kitsò jè nei‑la̱ nangui: “¿Mé xi s'iaàn? Jè‑la sìkasén ki'ndí‑na̱ xi 'ñó tsjakeè; jè‑la xi skoe̱xkón.” ");
INSERT INTO maaNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ta̱nga jñà xi̱ta̱ chi̱'nda koi, k'e̱ nga kijtseèxkon, kitsò‑la̱ xíkjín: “Jè jèe̱ xi tjoé kjo̱tjò‑la̱ i̱'nde; si̱k'eén mé‑ne nga tsa̱ján ko̱ma i̱'nde.” ");
INSERT INTO maaNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tsachrjekàjiìn ya̱ ñánda títje̱ toò uva; i̱kjoàn kisìk'en. ’Jñò, ¿kó bixón? Nei‑la̱ nangui, ¿mé xi si̱ìko̱ xi̱ta̱ koi? ");
INSERT INTO maaNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kjoi̱í sík'en xi̱ta̱ koi; kj'ei̱í xi̱ta̱ si̱ìnga̱tsja jè nangui ñánda tjín toò uva. Jñà xi̱ta̱ xi nchi'nchré‑la̱ Jesús kitsò: ―¡Ni̱kjé‑ne k'oa̱s'ín ko̱ma! ");
INSERT INTO maaNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ta̱nga Jesús, kiskoò'an, kitsò‑la̱: ―Tsà majìn, ¿kó bixón? ¿Kó tsòya‑ne koni s'ín tíchja̱ Xo̱jo̱n xi tjít'aà 'Én‑la̱ Nainá nga tsò?: “Jè nda̱jo̱ xi tsachrjekàngui chji̱ne̱chrjó nga sa̱ ítjòn, jè‑né xi komà nda̱jo̱ tàts'en chrjó‑la̱ ni'ya.” ");
INSERT INTO maaNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ngats'iì xi ya̱ ki̱xo̱sòn nda̱jo̱ jè, ko̱xkoa̱ya‑né; ko̱ tsà jè nda̱jo̱ ska̱nè xi̱ta̱, ko̱chijo‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, mejèn‑la̱ nga ti̱jè‑ne hora tsobà'ñó Jesús, nga jè kjoa̱ xi mangásòn, kiskaàya‑la̱ nga kondra̱ ts'e̱ koni s'ín tsibéno̱jmí; ta̱nga jñà xi̱ta̱ na̱xa̱ndá kitsakjòn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì kisìkinda̱; kisìkasén‑'ma‑la̱ xi̱ta̱ xi ijchò 'nchré‑la̱ xi k'oa̱s'ín kis'iìn koni tsà xi̱ta̱ ndaà nga mejèn‑la̱ sa̱kòtsji jngoò‑la̱ 'én xi ch'o tsò mé‑ne nga ko̱ma si̱ìnga̱tsja‑ne jè gobernador xi tjíya kjo̱tíxoma tsja nga jè koi̱ìndaàjiìn. ");
INSERT INTO maaNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jñà xi̱ta̱ koi kiskònangui‑la̱, kitsò‑la̱: ―Maestro, 'ya‑náje̱n jñà 'én xi nokjoì, ndaà okoòyi; mìkiì chjaàjiìn xi̱ta̱; k'oa̱á s'ín okoòyi ndi̱yá‑la̱ Nainá koni s'ín tjín xi kjoa̱ kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿A ndaà tjín nga kíchjítjì‑je̱n tsojmì i̱t'aà ts'e̱ xi̱ta̱xá ítjòn ts'e̱ Roma? ¿A xi majìn‑né? ");
INSERT INTO maaNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús, ti̱k'e̱é kijtseèya‑la̱ nga nchikona̱cha̱n‑la̱, kitsò‑la̱: ―¿Mé‑ne nga mejèn‑nò nga 'a̱n chít'aà‑ná? ");
INSERT INTO maaNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ta̱kó jngoò‑ná to̱n. ¿Yá ts'e̱ i̱sén ko̱ 'ín xi tjít'aà? Kitsò xi̱ta̱ koi: ―Ts'e̱é César xi xi̱ta̱xá ítjòn ts'e̱ Roma. ");
INSERT INTO maaNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús kitsò: ―Tjiì‑lá César xi ts'e̱ César, koa̱ tjiì‑là Nainá xi ts'e̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ngats'iì 'én xi kiìchja̱ Jesús nga nguixko̱n xi̱ta̱ na̱xa̱ndá, mìkiì kisakò‑la̱ xi ko̱ma ko̱hòngui‑ne. Tà kjòxkón‑la̱; tà sa̱á tà jyò tsibìtsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jñà xi̱ta̱ saduceo xi mìkiì mokjeiín‑la̱ nga faáya‑la̱ xi̱ta̱ xi jye k'en ijchò kjònangui‑la̱ Jesús, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, Moisés, k'oa̱á s'ín kiskiì: Tsà jngoò xi̱ta̱ xi ki̱yá 'ndse̱, tsà tsjìn‑la̱ i̱xti k'e̱ nga ki̱yá, jè chjo̱ón‑la̱ mik'en, ti̱jè‑ne 'ndse̱ ki̱xan‑ko̱ ìjngoò k'a‑ne mé‑ne nga s'e̱‑la̱ i̱xti xi tje̱ ts'e̱ 'ndse̱. ");
INSERT INTO maaNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kis'e xó jngoò k'a xi̱ta̱ xi itoò komà 'ndse̱. Jè xi síjna ítjòn, kis'e xó‑la̱ chjo̱ón; ta̱nga mìkiì kis'e‑la̱ i̱xti skanda kóni nga k'en. ");
INSERT INTO maaNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jè 'ndse̱ xi ma‑ne jò, chixàn‑ko̱ó; ti̱koa̱á k'e̱ nga k'en, mìkiì kis'e‑la̱ i̱xti. ");
INSERT INTO maaNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chjo̱ón jè, chixàn‑ko̱ó xi ma‑ne jàn; k'oa̱á xó s'ín chixàn‑ko̱ ngats'iì nga itoò 'ndse̱, ta̱nga ni̱jngoò xi kis'e‑la̱ i̱xti skanda k'e̱ nga k'en. ");
INSERT INTO maaNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Xi komà i̱skan, ti̱koa̱á k'en jè chjo̱ón. ");
INSERT INTO maaNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","K'e̱ nga tsà kjoa̱áya‑la̱, nga itoò 'ndse̱, ¿yá‑né xi chjo̱ón‑la̱ ko̱ma? Nga jñà tsibìtsa̱jnako̱ nga itoò 'ndse̱. ");
INSERT INTO maaNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús, k'e̱é kitsò‑la̱: ―Jñà xi̱ta̱ xi tjín na̱chrjein i̱'ndei̱, ko̱ chjo̱ón ko̱ x'i̱n, bixan‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ta̱nga jñà xi̱ta̱ xi Nainá o̱ki̱tso̱ nga ok'ìn‑la̱ nga kjoa̱áya‑la̱ nga kítsa̱jna i̱sò'nde xi sa̱ kjoi̱í, mì ti̱ kiì ki̱xan‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ti̱koa̱á mì ti̱ kiì ki̱yá‑ne. K'oa̱á s'ín ngásòn kítsa̱jnakon koni àkja̱le̱; ya̱á kítsa̱jnako̱ Nainá nga i̱xti‑la̱ ma nga jye kòfaáya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ti̱jè‑ne Moisés k'oa̱á s'ín okóya nga jñà xi jye k'en, kjoa̱áya‑la̱. K'oa̱á s'ín tjít'aà xo̱jo̱n i̱t'aà ts'e̱ yá na'yá xi títì k'e̱ nga tsò Moisés: “Jè xi Nainá 'mì‑lá, ti̱koa̱á Nainá tsò‑la̱ Abraham, Isaac, ko̱ Jacob.” ");
INSERT INTO maaNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¡Jñà xi jye k'en, mìtsà Nainá tsò‑la̱ xi Nainá; tà jñà xi títsa̱jnakon xi Nainá tsò‑la̱! I̱t'aà ts'e̱ Nainá, ngats'iì‑né nga títsa̱jnakon. ");
INSERT INTO maaNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","K'e̱é kiìchja̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, kitsò: ―Maestro, kixi̱í kjoa̱ 'én xi nokjoì. ");
INSERT INTO maaNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ni̱ ti̱ jngoò xi̱ta̱ xi kjò'ñó‑ne ikon nga kiskònangui‑ìsa‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús kitsò: ―¿Mé‑ne ko̱tsò‑ne jñà xi̱ta̱ nga jè xi Cristo, xi̱ta̱ xi xó si̱ìkasén‑ne Nainá, nga ya̱ kji̱nchrobàt'aà‑ne tje̱‑la̱ xi̱ta̱xá ítjòn David? ");
INSERT INTO maaNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ti̱jè‑ne David, tsò xo̱jo̱n‑la̱ ya̱ ts'e̱ Salmo: Jè Nainá kitsò‑la̱ Cristo, jè xi otíxoma‑na: “Ti̱jnat'aà‑ná i̱ kixi̱‑na̱, ");
INSERT INTO maaNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","skanda k'e̱ nga sìkítsa̱jnanguia kondra̱‑lè ñánda nchasòn ndso̱koiì nga 'a̱n, jye kisìkijne‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Jè David, tsà ko̱s'ín kitsò‑la̱ Cristo, ¿kó s'ín tjín‑ne nga ya̱ nchrobát'aà‑ne tje̱‑la̱ David? ");
INSERT INTO maaNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","K'e̱ nga nchi'nchré ngats'iì xi̱ta̱ na̱xa̱ndá, Jesús kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Ti̱kinda̱a yijo‑nò i̱t'aà ts'e̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. Sasén‑la̱ nga nikje ndojò ókjá. Ti̱koa̱á tsjaá ma‑la̱ nga ndaà beèxkón xi̱ta̱ xi kj'ei̱í, ndaà síhixat'aà ya̱ ndi̱tsi̱n. Ti̱koa̱á jñà ótsji íxi̱le̱ xi jncha ítjòn ya̱ ni'ya i̱ngo̱ sinagoga, ko̱ mejèn‑la̱ nga jñà kítsa̱t'aà ítjòn ími̱xa̱ k'e̱ nga kjèn xi̱ta̱ ñánda tjín s'eí. ");
INSERT INTO maaNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Faá'an ni'ya‑la̱ íchjín ka'àn xi jye k'en x'i̱n‑la̱. I̱kjoàn 'ñó ndojò fìko̱ o̱chikon‑la̱ nga mejèn‑la̱ nga bìtsa̱jna'ma nga mì jcha̱‑la̱ mé kjoa̱ xi s'ín. Jñà xi̱ta̱ koi ìsa̱á tse kjo̱'in s'e̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús k'e̱ nga kiskoòtsejèn, kijtseè xi̱ta̱ nchi̱ná xi 'ñó tjín‑la̱ to̱n nga nchibítsa̱jnaya to̱n‑la̱ ya̱ kaxa̱ ñánda sinchá to̱n kjo̱tjò‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ti̱koa̱á kijtseè jngoò chjo̱ón ka'àn xi 'ñó i̱ma̱ nga tsibítsa̱jnaya jò ndí to̱n xi chibachjí chjí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","K'e̱é kitsò: ―Xi kjoa̱ kixi̱, k'oa̱á xán‑nò, chjo̱ón ka'àn i̱ma̱ jè, ìsa̱á tse to̱n kòbíjna mì k'oa̱á‑ne ngats'iì xi̱ta̱ xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ngats'iì xi̱ta̱ koi xi tjín‑la̱ to̱n, koií tsjá‑la̱ Nainá jè xi ningui‑la̱, ta̱nga jè chjo̱ón i̱ma̱, kàtsjá yijeé to̱n xi tjín‑la̱ xi tímajchá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ti̱koa̱ nchijoóya i'nga‑ne xi̱ta̱ xi nchikotsejèn‑la̱ i̱ngo̱ ítjòn nga ndaà kjoàn nda̱jo̱‑la̱; ti̱koa̱ ndaà kjoàn tsojmì xi kitsjaà kjo̱tjò‑la̱ Nainá jñà xi̱ta̱. Jesús kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Kjoi̱í na̱chrjein k'e̱ nga jñà nda̱jo̱ ko̱ tsojmì xi ndaà kjoàn xi chìtsejèn‑là, ni̱í ti̱ jngoò si̱yijòsòn‑la̱ xíkjín, ki̱xo̱ña yije‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","K'e̱é kiskònangui‑la̱ kitsò‑la̱: ―Maestro, ¿mé na̱chrjein‑ne nga o̱ko̱ma kjoa̱ koi? ¿Mé seña xi s'e̱ k'e̱ nga jye ko̱chrañà nga k'oa̱s'ín ko̱ma kjoa̱ koi? ");
INSERT INTO maaNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús kitsò: ―Ti̱kinda̱a yijo‑nò nga mì yá xi̱ta̱ xi skóna̱cha̱n‑nò. Kjìn xi̱ta̱ kjoi̱í xi 'ín ts'a̱n si̱ìkjeén; ki̱tso̱: “'A̱n‑ná xi Cristo, nga 'a̱án kisìkasén‑na Nainá”, ti̱koa̱ ki̱tso̱‑nò: “Jyeé tíjna chrañà na̱chrjein nga 'a̱n kotiìxoma.” Kì kiì onguítji̱ngui‑là. ");
INSERT INTO maaNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","K'e̱ nga ki̱ná'ya kjoa̱ ts'e̱ kjo̱jchán, kjoa̱siì, kì tsakjoòn‑jèn; mochjeén‑né nga k'oa̱s'ín ko̱ma ítjòn ta̱nga kj'eè tsà jè na̱chrjein nga kjoe̱het'aà. ");
INSERT INTO maaNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kitsò‑ìsa‑la̱: ―Na̱xa̱ndá ska̱àn‑kjoò xi kj'ei̱í na̱xa̱ndá. Koa̱ xi̱ta̱xá koi̱ìts'ia̱ nga ska̱àn‑kjoòko̱ xi̱ta̱xá xi kj'ei̱í na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ndaà jchán k'oa̱ ch'ón xkón; xki̱ xi ján na̱xa̱ndá s'e̱ kjinchrá ko̱ ch'in xi 'ñó kjan. Ján ngajmiì jcha̱‑la̱ kjo̱xkón xi ch'o tjín ko̱ xi ch'o kjoàn. ");
INSERT INTO maaNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ta̱nga jñò, ítjòn tso̱ba̱'ñó‑nò xi̱ta̱; kji̱tji̱nguikeè‑nò kji̱ko̱‑nò ya̱ ni'ya i̱ngo̱ sinagoga nga ya̱ si̱ndaàjiìn. Ski̱nìs'en‑nò nda̱yá; kji̱ko̱‑nò i̱t'aà ts'e̱ xi̱ta̱xá ítjòn ko̱ ts'e̱ gobernador, tà koií kjoa̱‑la̱ nga mokjeiín‑nò i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","K'e̱ nga k'oa̱s'ín ko̱mat'ioòn, jè hora nga kéno̱jmí‑là xi̱ta̱ xi i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","K'oa̱á s'ín t'è‑là takòn, kì tà chjà ítjòn nìkítsjeèn kó kixón nga ki̱nókjoa̱a nga ki̱nchako̱o yijo‑nò, ");
INSERT INTO maaNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","koií kjoa̱‑la̱ nga 'a̱n, tsjaà‑nò 'én ti̱koa̱ tsjaà‑nò kjoa̱ kjìn‑takòn kó s'ín ki̱nókjoa̱a mé‑ne nga jñà xi̱ta̱ kondra̱‑nò mìkiì si̱ìkijne‑nò k'e̱ nga chibàkjoò. ");
INSERT INTO maaNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Skanda jñà si̱ìnga̱tsja‑nò xi na̱'èn‑nò, 'ndsè, xinguio̱o ko̱ amigo‑nò, ti̱koa̱ si̱ìk'en i'nga‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ngats'iì xi̱ta̱ i̱sò'nde ko̱jtikeé‑nò xi kjoa̱ ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ta̱nga ni̱jngoò tsja̱skoò chi̱ja. ");
INSERT INTO maaNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","¡Jè xi ki̱chìkjoa̱‑la̱ kjo̱'in, kíjnakon ini̱ma̱‑la̱! ");
INSERT INTO maaNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’K'e̱ nga jcha̱a na̱xa̱ndá Jerusalén nga kitseè jngoò itjandiì‑la̱ soldado, k'oa̱á s'ín tíjiìn‑nò nga jye kjòchrañà nga jngoò k'a kjoe̱hesòn yije mé xi tjín. ");
INSERT INTO maaNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jñà xi̱ta̱ xi títsa̱jna Judea, kàtanga, kàtjì ñánda nindoò choòn; jñà xi títsa̱jna Jerusalén, kàtitjokàjiìn na̱xa̱ndá, jñà xi ján títsa̱jna campo, kì ti̱ kiì nchrobá‑ne i̱jiìn na̱xa̱ndá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Koií kjoa̱‑la̱ nga na̱chrjein ts'e̱ kjo̱'in‑né mé‑ne nga ki̱tasòn yije‑ne koni s'ín tíchja̱ Xo̱jo̱n xi tjít'aà 'Én Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡I̱ma̱ xó‑ne jñà íchjín xi ki'ndí 'ya ko̱ xi i̱xti xó nchisíkaki jñà na̱chrjein koi, nga 'ñó tse kjo̱'in s'e̱ i̱t'aà nangui! Xi kjoa̱jti‑la̱ Nainá, tse kjo̱'in koi̱ì'nè‑la̱ xi̱ta̱ na̱xa̱ndá Israel. ");
INSERT INTO maaNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tjín xi̱ta̱ xi ki̱cha̱ machìti̱n ki̱yá‑ne; ti̱koa̱á tjín xi kj'ei̱í nangui kji̱ko̱ preso jñà xi̱ta̱ kjo̱jchán. Jñà xi mìtsà xi̱ta̱ judío, 'ñó ch'o si̱ìko̱ nga skoe̱toòn jñà xi̱ta̱ na̱xa̱ndá Jerusalén; jñà ko̱tìxoma skanda k'e̱ nga ki̱tasòn na̱chrjein‑la̱ xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’I̱kjoàn jcha̱‑la̱ jè ts'oí, sá ko̱ ni'ño nga ko̱tsejèn‑la̱ seña xi ch'o kjoàn. I̱ i̱t'aà nangui, ngats'iì xi̱ta̱ 'ñó tsakjón nga kji̱'nchré‑la̱ nga 'ñó kjo̱ne nga fì nchrobá ndáchikon. ");
INSERT INTO maaNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jñà xi̱ta̱ chi̱ba̱‑la̱ ki̱yáya‑né nga tsakjón k'e̱ nga skoe̱ kjoa̱ xi ko̱mat'in i̱sò'nde. Skanda jñà ni'ño xi tjín ngajmiì ki̱jtiyaá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","I̱kjoàn skoe̱‑na xi̱ta̱ xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ nga kji̱nchrobàjñaà i̱jiìn ifi. Tseé nga'ñó ko̱ kjoa̱jeya kjoi̱ikoa̱a. ");
INSERT INTO maaNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","K'e̱ nga ko̱ts'ia̱ kjoa̱ koi nga k'oa̱s'ín ko̱ma, kixi̱ ti̱nchaà, chjímiì'ngaà skoò, tsja t'è‑là ini̱ma̱‑nò, chíñakjoa̱a nga jyeé kjòchrañà na̱chrjein nga jñò ki̱tsa̱jnandei̱í‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","K'e̱é tsibéno̱jmí jngoò‑la̱ kjoa̱ xi mangásòn; kitsò‑la̱: ―Chítsejèn‑là yá toò iko̱, ngats'iì yá xi tjín. ");
INSERT INTO maaNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","K'e̱ nga jye bíts'ia̱ nga bíjts'én xka̱‑la̱ yá, jyeé 'yaà nga nchrobá machrañà cho̱n ndobá. ");
INSERT INTO maaNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","K'oa̱á ti̱s'ín tjín, k'e̱ nga jcha̱a nga k'oa̱s'ín tíma kjoa̱ koi, kàtasijiìn‑nò nga jye tíjnat'aà chrañà‑nò na̱chrjein nga jcha̱a kó s'ín otíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Xi o̱kixi̱, k'oa̱á xán‑nò: Mìkiì ki̱yá xi̱ta̱ xi tjín na̱chrjein koi skanda kóni nga jye ki̱tasòn yije jñà kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Jè ngajmiì ko̱ i̱sò'nde kjoe̱het'aà‑né, ta̱nga jñà 'én‑na̱ mìkiì kjoe̱het'aà; ki̱tasòn‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’T'e̱en kinda̱ yijo‑nò; mìkiì biì'nde nga sítájaàjiìn ini̱ma̱‑nò jñà kjoa̱ xi ch'o tjín koni kjoa̱ ch'i̱, kjoa̱ chrjá'a, ko̱ kjoa̱ xi nìkájnoò i̱ i̱sò'nde. Tsà k'oa̱s'ín s'e̱en, mìkiì titsa̱jnandaà jè na̱chrjein k'e̱ nga 'a̱n kjoia̱a ìjngoò k'a; tà ni̱to̱n kjoi̱í na̱chrjein, ska̱nè‑nò koni jngoò ch'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","K'oa̱á s'ín ko̱mat'in ngats'iì xi̱ta̱ xi tjín nga tíjtsa i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jñò, ndaà ti̱tsa̱jna, tìtsi'ba kijndà nga kjit'aà na̱chrjein mé‑ne nga s'e̱‑nò nga'ñó nga ko̱ma kitjo̱jñoò ngats'iì kjo̱'in xi k'oa̱s'ín ko̱ma, ti̱koa̱ mé‑ne nga mìkiì ko̱sobà‑nò nga ki̱ncha nguixko̱n Ki'ndí‑la̱ Xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","K'e̱ nga na̱chrjein, Jesús, ya̱á tsakóya ya̱ ndi̱tsin i̱ngo̱ ítjòn. K'e̱ nga majñò ya̱á fìsìkjáya ya̱ nindoò xi 'mì Yá Olivo. ");
INSERT INTO maaNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kjìn xi̱ta̱ na̱xa̱ndá, f'iìkon ya̱ ndi̱tsin i̱ngo̱ ítjòn nga xki̱ ta̱jñòya; f'iì 'nchré‑la̱ mé 'én xi okóya. ");
INSERT INTO maaNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jyeé tímachrañà na̱chrjein nga bitjo s'eí Paxko̱ k'e̱ nga kjèn i̱nchra̱jín xi tsjìn‑la̱ na̱'yo̱ san jñà xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, nga tsakjón‑la̱ xi̱ta̱ na̱xa̱ndá, tsohótsji'nde‑la̱ kó s'ín si̱ìko̱ Jesús nga si̱ìk'en. ");
INSERT INTO maaNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jè xi̱ta̱ nei̱í jahas'en‑jiìn ini̱ma̱‑la̱ jè Judas xi ti̱koa̱ Iscariote 'mì, xi ya̱ itjojiìn ts'e̱ xi̱ta̱ xi tejò ma‑ne xi tsajmeiìko̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas, kiìkáko̱ jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ sko̱‑la̱ xi síkinda̱ i̱ngo̱ ítjòn nga tsajoóya‑ne kó s'ín si̱ìnga̱tsja Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jñà xi̱ta̱ koi, tsjaá komà‑la̱; tsibíndaàjiìn nga to̱n tsjá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas, kòkjeiín‑la̱, i̱kjoàn tsohótsji'nde‑la̱ kó s'ín si̱ìnga̱tsja Jesús nga mìkiì skoe̱ jñà xi̱ta̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ijchò na̱chrjein‑la̱ s'eí ts'e̱ i̱nchra̱jín xi tsjìn‑la̱ na̱'yo̱ san, k'e̱ nga k'oa̱s'ín tjínè‑la̱ nga biyaà orrè xi bíxteèn jní‑la̱ xi i̱t'aà ts'e̱ s'eí Paxko̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús kisìkasén Pedro ko̱ Juan, kitsò‑la̱: ―Tanguió kìndaà tsojmì xi kjoa̱ ts'e̱ s'eí Paxko̱ mé‑ne nga ki̱chiaá. ");
INSERT INTO maaNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jñà xi̱ta̱‑la̱ kiskònangui‑la̱, kitsò‑la̱: ―¿Ñánda mejèn‑lè nga konguí kìndaà‑je̱n? ");
INSERT INTO maaNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús kitsò: ―K'e̱ nga ki̱tjás'e̱n‑jñoò na̱xa̱ndá, ya̱ ska̱kjoò jngoò xi̱ta̱ x'i̱n xi 'yajen jngoò nisa nandá. Tanguítji̱ngui‑là skanda ya̱ ñánda kjoa̱has'en ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ko̱t'ìn‑là nei‑la̱ ni'ya: “Jè Maestro kjònangui: ¿Ñánda tíjna cuarto‑la̱ ni'ya ñánda kókje̱n‑koa̱a xi̱ta̱ xi kota'yàt'aà‑na̱ ts'e̱ s'eí Paxko̱?” ");
INSERT INTO maaNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Xi̱ta̱ jè, ko̱kò jngoò‑nò cuarto xi tiyà kji xi jye ndaà choòn xi ya̱ tíjnasò'nga ni'ya. Ya̱ tìndaà nga ki̱chiaá. ");
INSERT INTO maaNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jñà xi̱ta̱ koi, kiì; k'oa̱á s'ín kisakò‑la̱ koni s'ín kitsò‑la̱ Jesús. Ya̱á tsibíndaà tsojmì xi ko̱kje̱n kjoa̱ ts'e̱ s'eí Paxko̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","K'e̱ nga ijchò hora nga ko̱kje̱n, Jesús tsibìjnat'aà ími̱xa̱ ko̱ xi̱ta̱‑la̱ xi tsibíxáya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kitsò‑la̱: ―¡'Ñó tìsìkítsjeèn nga mejèn‑na kókje̱n‑ko̱‑nò ts'e̱ s'eí Paxko̱ nga ti̱kj'eè fì‑na kjoa̱ biyaà! ");
INSERT INTO maaNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","K'oa̱á xán‑nò nga mì ti̱ kiì kókje̱en‑na s'eí Paxko̱ skanda k'e̱ nga ki̱tasòn yije kjoa̱ ts'e̱ s'eí Paxko̱ jñà na̱chrjein k'e̱ nga Nainá ko̱tìxoma. ");
INSERT INTO maaNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","K'e̱é kiskoé jngoò chi̱tsín, kitsjaà‑la̱ kjo̱ndaà Nainá, kitsò: ―Chjoé, ti̱ka'bí‑là xinguio̱o; ");
INSERT INTO maaNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","k'oa̱á xán‑nò nga mì ti̱ kiì ski̱‑na vino skanda k'e̱ nga ko̱tìxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","I̱kjoàn kiskoé i̱nchra̱jín, kitsjaà‑la̱ kjo̱ndaà Nainá, kisìxkoa̱ya, kitsjaà‑la̱ xi̱ta̱‑la̱, kitsò: ―I̱nchra̱jín jè, yijo‑na̱‑né nga 'a̱án ki̱yá ngajo‑nò. K'oa̱ ti̱s'ín t'e̱en nga ti̱xkoa̱ya i̱nchra̱jín, mé‑ne nga koi̱ìtsjeèn‑nò xi i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","K'e̱ nga jye tsakjèn, k'oa̱á ti̱s'ín kis'iìn; kiskoé chi̱tsín, kitsò: ―Chi̱tsín jè, jè‑né xi kjoa̱ xi̱tse̱ xi bìndaàjiìn‑ko̱‑nò xi i̱t'aà ts'e̱ jní‑na̱ xi xíxteèn xi kjo̱ndaà tsa̱jòn nga makixi̱ya kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","I̱í tíjnat'aàko̱‑ná ími̱xa̱, jè xi̱ta̱ xi si̱ìnga̱tsja‑na i̱t'aà ts'e̱ xi̱ta̱ kondra̱‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Xi o̱kixi̱, 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, tjínè‑na nga ki̱yá. Ta̱nga, ¡i̱ma̱ xó‑ne jè xi̱ta̱ xi si̱ìnga̱tsja‑na! ");
INSERT INTO maaNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jñà xi̱ta̱‑la̱ tsibíts'ia̱ nga kiskònangui‑la̱ xíkjín, kitsò: ―¿Yá‑né xi k'oa̱s'ín si̱ìnga̱tsja? ");
INSERT INTO maaNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jñà xi̱ta̱‑la̱ tsajoókjoò xi kjoa̱ ts'e̱ yá‑né xi tíjna ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús kitsò‑la̱: ―Jñà xi̱ta̱xá ítjòn‑la̱ xi mìtsà xi̱ta̱ judío, 'ñó beètoòn xi̱ta̱ na̱xa̱ndá‑la̱, ta̱nga jñà xi̱ta̱xá koi, tsò‑né nga ndaà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ta̱nga jñò, mìkiì k'oa̱s'ín s'e̱en. Jè xi tíjna ítjòn, ìsa̱á nangui kàtìjna; jè xi otíxá, tà sa̱á jè kàtama chi̱'nda. ");
INSERT INTO maaNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Yá‑né xi tíjna ítjòn? ¿A jè xi bìjnat'aà ími̱xa̱, o xi jè xi bíya tsojmì? ¿A mìtsà jè xi bìjnat'aà ími̱xa̱? Ta̱nga i̱'ndei̱, mìkiì k'oa̱s'ín ko̱ma. 'A̱n, tìjna̱jiìn‑nò koni jngoò xi̱ta̱ chi̱'nda xi síxá‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Skanda kó‑ne nga tàts'en‑la̱ kjoa̱, jñò‑nò xi titsa̱jnako̱ kjit'aà‑ná ni̱ta̱ mé kjoa̱ xi tímat'ian. ");
INSERT INTO maaNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Koií kjoa̱‑la̱ nga 'a̱n siìnga̱tsja‑nò kjo̱tíxoma nga jñò ko̱ti̱xomaà koni s'ín kisìnga̱tsja‑na Nainá xi Na̱'èn‑na̱, ");
INSERT INTO maaNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","mé‑ne jñò, ya̱ ki̱chioò ti̱koa̱ s'io̱o ya̱ i̱t'aà ími̱xa̱‑na̱ ñánda tìhotiìxoma, ti̱koa̱ ya̱ ki̱tsa̱jnasòn íxi̱le̱ ts'e̱ kjo̱tíxoma nga jñò, kíndaàjiìn‑là xi̱ta̱ xi tejò tje̱‑la̱ ts'e̱ na̱xa̱ndá Israel. ");
INSERT INTO maaNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kiìchja̱‑ìsa Na̱'èn‑ná, kitsò: ―Simón, Simón, jè xi̱ta̱ nei̱í kisìjé'nde nga mejèn‑la̱ 'ñó skót'aà‑nò. K'e̱ nga skót'aà‑nò, ya̱á jcha̱‑la̱ yá‑né xi ndaà ko̱ xi mìkiì ndaà, koni s'ín nìko̱ trigo nga matsjeè. ");
INSERT INTO maaNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","’Ta̱nga 'a̱n, tsibìtsi'batjì‑lè mé‑ne nga mì jchi̱jat'aà‑lè nga mokjeiín‑lè xi i̱t'aà ts'a̱n. K'e̱ nga jye si̱kátjifaya‑ne xi i̱t'aà ts'a̱n, ti̱si̱koi̱i xingui̱i nga kixi̱ kítsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón kitsò: ―Na̱'èn, tìjna̱ndaà‑ná nga kjíko̱‑lè na̱s'ín nda̱yá k'oín, na̱s'ín skanda ki̱yáko̱‑lè. ");
INSERT INTO maaNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús kitsò‑la̱: ―Ngaji̱ Pedro, k'oa̱á xan‑lè, i̱'ndei̱, jàn k'a k'oa̱ sí nga mìkiì yaxkon‑ná k'e̱ nga ti̱kj'eè kjindáya kóxtí. ");
INSERT INTO maaNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús kiskònangui‑la̱, kitsò‑la̱: ―K'e̱ nga kisìkasén‑nò nga tsanguió nìka'bió 'én‑na̱ nga mìkiì kich'à to̱n, mìkiì kich'à chijtsa, mìkiì xo̱xté kitsjaya, ¿mé xi kisìchjaàt'aà‑nò? Jñà xi̱ta̱ kitsò: ―Ni̱mé‑jèn. ");
INSERT INTO maaNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","K'e̱é kitsò‑la̱: ―I̱'ndei̱, jè xi tjín‑la̱ chijtsa to̱n, kàtakjoé; ti̱koa̱ jè xi tjín‑la̱ na̱'ya kàtakjoé; ko̱ jè xi tsjìn‑la̱ ki̱cha̱ ndojò, kàtatíjna na̱chro̱kisòn‑la̱ koa̱ kàtatse ki̱cha̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","K'oa̱á xán‑nò nga tjínè‑la̱ nga ki̱tasòn koni s'ín tíchja̱ Xo̱jo̱n xi tjít'aà 'Én Tsjeè‑la̱ Nainá xi i̱t'aà ts'a̱n nga tsò: “K'oa̱á s'ín skoe̱‑ikon koni jngoò xi̱ta̱ xi mìkiì ndaà s'ín.” Koni s'ín tíchja̱ 'Én Tsjeè‑la̱ Nainá xi i̱t'aà ts'a̱n, ki̱tasòn yije‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jñà xi̱ta̱‑la̱ kitsò: ―Na̱'èn, kjioò jò‑naje̱n ki̱cha̱ ndojò i̱jndé. Jè Jesús kitsò: ―Kàtje kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús kiì nga kiìchja̱t'aà‑la̱ Nainá ya̱ ñánda 'mì nindoò Yá Olivo koni s'ín s'ín kjit'aà; i̱kjoàn kiìtji̱ngui xi̱ta̱ xi kota'yàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","K'e̱ nga ijchò i̱'nde jè, kitsò‑la̱ xi̱ta̱‑la̱: ―Tìtsi'ba‑là Nainá mé‑ne nga mì jé ska̱jñoò. ");
INSERT INTO maaNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","K'e̱é tsasìt'aà xìn chiba‑la̱ koni kji saté jngoò nda̱jo̱ k'e̱ jngoò xi̱ta̱ osén. Tsasèn‑xkó'nchi, i̱kjoàn kiìchja̱t'aà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kitsò: ―Na̱'èn, tsà mejèn‑lè, chja̱àxìn‑ná kjo̱'in jè; ta̱nga mìtsà jè ki̱tasòn 'én‑na̱, jè kàtabitasòn tsi̱ji. ");
INSERT INTO maaNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","K'e̱ nga tíchja̱t'aà‑la̱ Nainá tsatsejèn jngoò àkja̱le̱‑la̱ Nainá xi inchrobà‑ne ngajmiì nga kitsjaà‑ìsa‑la̱ nga'ñó. ");
INSERT INTO maaNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nga tse kjo̱'in tísíkjeiín ini̱ma̱‑la̱, ìsa̱á 'ñó kiìchja̱t'aà‑la̱ Nainá; chi̱ba̱‑la̱ kitjoòndá‑né, jè ndátsjèya‑la̱ xi chixòt'aà nangui, jní kjoàn. ");
INSERT INTO maaNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","K'e̱ nga jye kiìchja̱t'aà‑la̱ Nainá, kiì ìjngoò k'a‑ne ñánda títsa̱jna xi̱ta̱ xi kota'yàt'aà‑la̱. Ta̱nga k'e̱ nga ijchò, jyeé kjiyijòfè, koií kjoa̱‑la̱ nga 'ñó 'on ma‑la̱ ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kitsò‑la̱: ―¿Mé‑ne titsa̱yijòfè‑nò? Ti̱sítje̱en, tìtsi'ba‑là Nainá mé‑ne nga mì jé ska̱jñoò. ");
INSERT INTO maaNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tákó ti̱k'e̱é tíchja̱‑ìsa Jesús, kjìn xi̱ta̱ ijchò; jè tsó'ba ítjòn Judas, xi ya̱ itjojiìn ts'e̱ xi̱ta̱‑la̱ Jesús xi tejò ma‑ne. K'e̱ nga ijchò, kiì kasìt'aà chrañà‑la̱ Jesús nga kiskine'a. ");
INSERT INTO maaNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jè Jesús kitsò‑la̱: ―Ngaji̱ Judas, ¿a k'oa̱á s'ín tà jngoò kjoa̱ xi chine'aá nìnga̱tsja‑ná 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱? ");
INSERT INTO maaNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jñà xi̱ta̱‑la̱ xi i'nga, k'e̱ nga kijtseè kjoa̱ xi ko̱mat'in Jesús, kitsò: ―Na̱'èn, ¿a mejèn‑lè nga ki̱ch'on‑je̱n ki̱cha̱ ndojò? ");
INSERT INTO maaNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jngoò xi̱ta̱‑la̱ Jesús tsajá‑la̱ ki̱cha̱ ndojò jè chi̱'nda‑la̱ no̱'miì ítjòn, tsatet'aà líká kixi̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","K'e̱é kitsò Jesús: ―¡Kì k'oa̱á nìko̱o, kàtje kjoa̱! I̱kjoàn tsohót'aà‑la̱ tsja líká‑la̱; ni̱to̱ón kjòndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","K'e̱é kitsò‑la̱ jñà xi̱ta̱ xi j'iìkjaá xi xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi síkinda̱ i̱ngo̱ ítjòn ko̱ xi̱ta̱ jchínga: ―¿Mé‑ne k'oa̱s'ín kà'nè‑nò nga ki̱cha̱ machìti̱n ko̱ yá kich'à koni tsà jngoò xi̱ta̱ chijé kòf'ìi̱chjaà? ");
INSERT INTO maaNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na̱chrjein inchijòn tsohóti̱jnako̱‑nò ya̱ ndi̱tsin i̱ngo̱ ítjòn; ¿mé‑ne nga mìkiì ya̱ kindobà'ñó‑ná? Koií kjoa̱‑la̱ nga jè hora jè nga jñò choòn, tsa̱jòn‑nò k'e̱ nga jè xi̱ta̱ nei̱í tíhotíxoma. ");
INSERT INTO maaNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesús, kitsobà'ñó xi̱ta̱, kiìko̱ ni'ya‑la̱ no̱'miì ítjòn. Jè Pedro, tà kjiìn tà kjiìn tsajmeètji̱ngui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ya̱ jngoò osen ndi̱tsin, jñà xi̱ta̱ tsibítse jngoò ni'ín, i̱kjoàn tsibìtsa̱jna'ngui jngoò itjandiì. Ti̱koa̱ jè Pedro tsibìjnajiìn‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","K'e̱é jngoò chjo̱ón chi̱'nda kijtseèxkon Pedro nga tíjna'ngui; kiskoò'an, kitsò: ―Xi̱ta̱ jè, ti̱koa̱á ya̱á tsóhoko̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ta̱nga jè Pedro tsoho'mat'in‑né, kitsò: ―Ngaji̱ chjo̱ón, xi̱ta̱ jè, mìkiì bexkoan. ");
INSERT INTO maaNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Xi komà ìjngoò tjò, nguì jngoò xi̱ta̱ kijtseèxkon Pedro, kitsò‑la̱: ―Ti̱koa̱á ngaji̱, ya̱á tjaàkoi̱i Jesús. K'e̱é kitsò Pedro: ―Ngaji̱ x'i̱in, mìtsà ya̱ tsòhokoa̱a. ");
INSERT INTO maaNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nga komà i̱skan, tjín‑la̱ tsà jngoò hora, ti̱koa̱á 'ñó o̱kitsò nguì jngoò xi̱ta̱: ―Kixi̱í kjoa̱, xi̱ta̱ jè, ya̱á tsóhoko̱, ti̱koa̱á ya̱á i̱'nde‑la̱ Galilea. ");
INSERT INTO maaNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro kitsò: ―Ngaji̱ x'i̱in, mìkiì be mé 'én xi ko̱'mì‑la̱. Ti̱k'e̱é‑ne tíchja̱ Pedro kiskindàya kóxtí. ");
INSERT INTO maaNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kisìkátjifaya Na̱'èn‑ná Jesús, kiskoòtsejèn‑la̱ Pedro. K'e̱é tsibítsjeèn‑la̱ Pedro 'én xi kitsò‑la̱ Na̱'èn‑ná Jesús nga kitsò‑la̱: “Jàn k'a k'oa̱ sí nga mìkiì yaxkon‑ná k'e̱ nga ti̱kj'eè kjindáya kóxtí.” ");
INSERT INTO maaNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jè Pedro, k'e̱é itjo ni'ya, i̱kjoàn 'ñó jchán kiskindàya nga 'on komà‑la̱ ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jñà xi̱ta̱ xi nchisíkinda̱ Jesús, kisìsobà‑la̱ ti̱koa̱ tsajá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tsibíchjoà xko̱n, i̱kjoàn kiskònangui‑la̱, kitsò‑la̱: ―¡Koa̱tìn‑náje̱n yá xi tí'beé‑lè! ");
INSERT INTO maaNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kjìn kjoa̱ tjín‑ìsa xi kj'ei̱í xi 'ñó 'on kitsò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","K'e̱ nga kis'e i̱sén, kjòxkóya jñà xi̱ta̱ jchínga ts'e̱ xi̱ta̱ judío, xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés; kiìko̱ Jesús ya̱ ñánda maxkóya jñà xi̱ta̱xá ítjòn; i̱kjoàn kiskònangui‑la̱, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Koa̱tìn‑náje̱n, ¿a ngaji̱‑né xi Cristo, xi xó kisìkasén‑lè Nainá, o xi majìn‑né? Jesús kitsò: ―Tsà k'oa̱ xán‑nò: “'A̱n‑ná”, mìkiì ko̱kjeiín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tsà 'a̱n skònangui‑nò, jñò, mìkiì ki̱nókjoa̱a ti̱koa̱á mìkiì si̱kíjnandei̱í‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Jyeé ijchò hora‑la̱ nga 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ ya̱á kóti̱jnat'aà kixi̱‑la̱ Nainá xi 'ñó tse nga'ñó tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ngats'iì xi̱ta̱ kitsò: ―¿A ngaji̱‑né xi Ki'ndí‑la̱ Nainá 'mì‑lè? Jesús kitsò‑la̱: ―Jñò sobà xi o̱bixón nga 'a̱n‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","K'e̱é kitsò jñà xi̱ta̱: ―¿Yá xi̱ta̱ xi mochjeén‑ìsa̱‑ná xi tsja 'én? Jñá sobá titsa̱na'yà‑lá koni s'ín tíchja̱‑ne tso'ba. ");
INSERT INTO maaNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tsasítje̱n ngats'iì xi̱ta̱, kiìko̱ Jesús ñánda tíjna Pilato. ");
INSERT INTO maaNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","K'e̱ nga ijchòko̱ nguixko̱n Pilato, jñà xi̱ta̱ tsibíts'ia̱ nga tsohóngui, kitsò: ―Xi̱ta̱ jè, kjòtsji‑naje̱n nga kj'ei̱í ndi̱yá fìko̱ na̱xa̱ndá‑ná. Tsò‑né nga mì xó kiì kíchjítjiá tsojmì xi i̱t'aà ts'e̱ César, xi̱ta̱xá ítjòn ts'e̱ Roma; ti̱koa̱á tsò‑né nga jè xó xi Cristo xi xó kisìkasén‑ne Nainá nga xi̱ta̱xá ítjòn kíjna. ");
INSERT INTO maaNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jè Pilato kiskònangui, kitsò‑la̱: ―¿A ji̱‑né xi xi̱ta̱xá ítjòn‑la̱ jñà xi̱ta̱ judío? Kitsò Jesús: ―Ngaji̱í xi k'oa̱ si nga 'a̱n‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato kitsò‑la̱ jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ na̱xa̱ndá: ―Ni̱mé jé xi matsji‑na i̱t'aà ts'e̱ xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ta̱nga jñà xi̱ta̱, ìsa̱á 'ñó kiìchja̱ nga tsohóngui, kitsò: ―Kj'ei̱í s'ín okóya‑la̱ xi̱ta̱ na̱xa̱ndá nga ótsji‑la̱ kjoa̱siì. Tsibíts'ia̱‑ne nangui Galilea, kóho̱kji nangui Judea, skanda i̱ Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","K'e̱ nga kiì'nchré Pilato jè 'én xi tsò, Galilea, kiskònangui‑la̱ xi̱ta̱: ¿A ya̱á i̱'nde‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","K'e̱ nga kis'eno̱jmí‑la̱ nga ya̱ i̱'nde‑la̱, kisìkasén‑la̱ jè xi̱ta̱ xi tíjna xi̱ta̱xá ítjòn Galilea xi 'mì Herodes; jñà na̱chrjein koi, ti̱koa̱á ján tíjna na̱xa̱ndá Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes, k'e̱ nga kijtseèxkon Jesús, 'ñó tsja komà‑la̱ nga kjòtseé mejèn‑la̱ nga skoe̱xkon, nga jyeé kjìn kjoa̱ kiì'nchré xi i̱t'aà ts'e̱. Mejèn‑la̱ skoe̱ jngoò kjo̱xkón xi s'ín. ");
INSERT INTO maaNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kjìn sko̱ya kjoa̱ kiskònangui‑la̱, ta̱nga jè Jesús, ni̱jngoò 'én kiìchja̱. ");
INSERT INTO maaNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ti̱koa̱á ya̱á títsa̱jna jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés nga 'ñó nchihóngui. ");
INSERT INTO maaNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jè Herodes ko̱ soldado‑la̱ tsachrjekàngui‑né; kisìkákjá nikje xi 'ñó ndaà kjoàn koni ts'e̱ xi̱ta̱xá ítjòn nga kisìsobà‑la̱; i̱kjoàn kisìkasén ìjngoò k'a‑la̱ jè Pilato. ");
INSERT INTO maaNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na̱chrjein jè, tsajoóndaà‑ne jè Pilato ko̱ Herodes; k'e̱ nga sa̱ ítjòn, kondra̱á títsa̱jna‑la̱ xíkjín. ");
INSERT INTO maaNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato tsibíxkóya jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ jñà xi̱ta̱xá, ngats'iì xi̱ta̱ na̱xa̱ndá, ");
INSERT INTO maaNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kitsò‑la̱: ―Jñò, kinìkasén‑ná xi̱ta̱ jè nga onguioò; bixón‑nó nga kjoa̱siì ótsji‑la̱ xi̱ta̱ na̱xa̱ndá; ta̱nga 'a̱n, kiskònanguií‑la̱ nga nguixkoòn; ngats'iì 'én xi 'bioò, ni̱mé jé sakó‑na i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","’Ti̱koa̱á jè Herodes, kisìkasén ìjngoò k'a‑na xi̱ta̱ jè nga ni̱mé jé kisakòt'aà‑la̱. Tsjìn‑la̱ jé nga ki̱yá. ");
INSERT INTO maaNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tsjaà‑la̱ kjo̱'in, i̱kjoàn siìkíjnandei̱í‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","K'oa̱á s'ín tjínè‑la̱, k'e̱ nga bitjo s'eí Paxko̱, bìjnandei̱í jngoò xi̱ta̱ xi nda̱yá títsa̱jna'ya. ");
INSERT INTO maaNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ta̱nga jñà xi̱ta̱ na̱xa̱ndá, tà jngoò jta̱á kiì ngats'iì, kitsò: ―¡Kàtiyaà Jesús; ti̱kíjnandei̱í‑náje̱n Barrabás! ");
INSERT INTO maaNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás, nda̱yá tíjna koií kjoa̱‑la̱ nga xi̱ta̱ na̱xa̱ndá Jerusalén kisìkjaán‑kjoò ti̱koa̱ xi̱ta̱ kisìk'en jngoò. ");
INSERT INTO maaNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato, mejèn‑la̱ nga si̱ìkíjnandei̱í Jesús; ìjngoò k'a kiìchja̱‑la̱ xi̱ta̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ta̱nga jñà xi̱ta̱ na̱xa̱ndá, ìsa̱á 'ñó kiìchja̱, kitsò: ―¡Tjat'aà krò! ¡Tjat'aà krò! ");
INSERT INTO maaNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Xi ma‑ne jàn k'a kitsò‑la̱ xi̱ta̱ na̱xa̱ndá: ―¿Mé jé xi tsohótsji, mé‑ne ki̱yá‑ne? 'A̱n, ni̱mé jé sakó‑na xi i̱t'aà ts'e̱ nga ki̱yá. Ti̱koa̱á‑ne tsjaà‑la̱ kjo̱'in, i̱kjoàn siìkíjnandei̱í‑na. ");
INSERT INTO maaNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Siì kis'iìn xi̱ta̱, 'ñó kiìchja̱ nga mejèn‑la̱ krò si̱t'aà Jesús. Koií kjoa̱‑la̱ nga 'ñó chja̱ xi̱ta̱ na̱xa̱ndá ko̱ xi̱ta̱ sko̱‑la̱ no̱'miì, kisìkijne nga kisìkitasòn Pilato. ");
INSERT INTO maaNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jè Pilato kitsjaà o̱kixi̱ nga kàtitasòn koni s'ín síjé xi̱ta̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kisìkíjnandei̱í Barrabás, xi̱ta̱ xi xó k'oa̱s'ín kisìjé‑ne na̱xa̱ndá xi tíjna'ya nda̱yá nga kjoa̱siì tsohótsji koa̱ xi̱ta̱ kisìk'en. I̱kjoàn kisìnga̱tsja Jesús nga k'oa̱s'ín kàtasíko̱ koni s'ín mejèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","K'e̱ nga kiìko̱ Jesús nga kiì sík'en i̱t'aà krò, kitsobà'ñó jngoò xi̱ta̱ xi tínchrobá‑ne rancho̱‑la̱ xi 'mì Simón xi ya̱ i̱'nde‑la̱ ñánda 'mì Cirene; jè kisìk'ajen krò nga kiìtji̱nguiko̱‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kjìn xi̱ta̱ na̱xa̱ndá tji̱ngui‑la̱, ti̱koa̱á kjìn íchjín tji̱ngui‑la̱ xi kjindáyakeè nga mahi̱ma̱keè kjoa̱ xi tímat'in Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús, kisìkátji, kiskoòtsejèn‑la̱, kitsò: ―Íchjín xi Jerusalén tsa̱jòn, kì 'a̱n chìhindáyachaà‑ná, chìhindáyachaà yijo‑nò ko̱ ts'e̱ i̱xti‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ki̱jchò na̱chrjein k'e̱ nga tse kjo̱'in s'e̱ nga ki̱tso̱ xi̱ta̱: “Mé tà ndaà‑la̱ jñà íchjín xi 'ndi̱, xi tsjìn‑la̱ i̱xti, xi mìkiì ki'ndí tsi'beé, xi mì i̱xti kisìkaki nga ìsa̱á chiba si̱ìkájno.” ");
INSERT INTO maaNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","I̱kjoàn koi̱ìts'ia̱ nga ki̱tso̱‑la̱ nindoò: “¡Kàtakaànè‑naje̱n!” K'oa̱ ti̱ ki̱tso̱‑la̱ chrja̱ngui̱‑la̱ nindoò: “¡Tìjtsa'nde‑náje̱n!” ");
INSERT INTO maaNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","'A̱n, koni jngoò yá xkoén, ta̱nga 'ñó ch'o síko̱‑na xi̱ta̱; jñò xi xi̱ta̱ Jerusalén tsa̱jòn, ìsa̱á tà 'ñó ch'o si̱ìko̱‑nò xi̱ta̱ koni jñà yá kixì. ");
INSERT INTO maaNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ti̱koa̱ kiìko̱ jò xi̱ta̱ xi tse jé tjín‑la̱ nga ti̱koa̱ krò ki̱yát'aà. ");
INSERT INTO maaNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","K'e̱ nga ijchòko̱ ya̱ i̱'nde ñánda 'mì I̱'nde Sko̱ Mik'en, tsasíjnat'aà krò Jesús ko̱ xi̱ta̱ xi jò ma‑ne, jñà xi tse jé tjín‑la̱; jngoò, tsasíjnat'aà nga kixi̱‑la̱ koa̱ jngoò, tsasíjnat'aà nga ngaskón‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","K'e̱é kitsò Jesús: ―Na̱'èn, ti̱jchàat'aà‑la̱; mìkiì beè mé kjoa̱ xi s'ín. I̱kjoàn jñà soldado kisìskáko̱ nikje‑la̱ Jesús nga kisìka'bí‑la̱ xíkjín yá ts'e̱ ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jñà xi̱ta̱ na̱xa̱ndá nchikotsejèn‑la̱; ti̱koa̱ jñà xi̱ta̱xá ítjòn nchisísobà‑la̱, nchitsò: ―Xi̱ta̱ xi kj'ei̱í tsachrjetjì kjo̱'in; tsà kixi̱ kjoa̱ nga jè xi Cristo xi xó k'oa̱s'ín jaàjiìn‑ne Nainá, kàtachrjetjì kjo̱'in yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ti̱koa̱á jñà soldado kisìsobà‑la̱ Jesús. Ijchò kinchat'aà chrañà‑la̱; kitsjaà‑la̱ nandá vinagre nga si̱ìkiì. ");
INSERT INTO maaNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kitsò‑la̱: ―¡Tsà ji̱‑né xi xi̱ta̱xá ítjòn‑la̱ xi̱ta̱ judío, ti̱kíjnandei̱í yijo‑lè! ");
INSERT INTO maaNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ti̱koa̱ tjít'aàsòn‑la̱ sko̱ krò xi 'én griego, 'én latín, ko̱ 'én hebreo xi tsò: “Jè jèe̱ xi Xi̱ta̱xá Ítjòn‑la̱ xi̱ta̱ judío.” ");
INSERT INTO maaNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jñà xi̱ta̱ xi tse jé tjín‑la̱ xi ti̱koa̱ ya̱ tjo̱hónguit'aà krò, jngoò xi 'ñó 'nga kiìchja̱ko̱ Jesús, kitsò‑la̱: ―¡Tsà ji̱‑né xi Cristo xi xó kisìkasén‑lè Nainá, ti̱kíjnandei̱í yijo‑lè ti̱koa̱ ti̱kítsa̱jnandei̱í‑náje̱n! ");
INSERT INTO maaNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jè xi̱ta̱ xi ìjngoò tsohótiko̱ xíkjín, kitsò‑la̱: ―¿A mì tsakjoòn‑la̱ Nainá nga ngásòn kjo̱'in titsa̱nìkjiaán? ");
INSERT INTO maaNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Xi o̱kixi̱, jñá ok'ín‑ná nga si̱kjiaán kjo̱'in nga kíchjiá jé‑ná, koi kjoa̱‑la̱ nga 'ñó ch'o ki'né; ta̱nga jè xi̱ta̱ jè, ni̱mé xi ch'o kis'iìn. ");
INSERT INTO maaNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","K'e̱é kitsò‑la̱ Jesús: ―Ti̱kítsjeèn‑ná k'e̱ nga jye kíts'i̱i nga ko̱ti̱xomai. ");
INSERT INTO maaNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","K'e̱é kitsò Jesús: ―O̱kixi̱í xi xan‑lè; i̱'ndei̱, ján ki̱jnako̱‑ná ngajmiì ya̱ i̱'nde ñánda 'ñó ndaà choòn. ");
INSERT INTO maaNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","K'e̱ nga ijchò nchisen, kòjñò nga tíjtsa i̱sò'nde skanda xi jàn nga nguixòn. ");
INSERT INTO maaNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jè ts'oí, kòjñò, koa̱ jè nikje xi tjo̱hóya jngohosen i̱ngo̱ ítjòn, jòya komà nga kixojndà. ");
INSERT INTO maaNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesús 'ñó kiìchja̱, kitsò: ―¡Na̱'èn, ndsei̱i bíjnaya ini̱ma̱‑na̱! K'e̱ nga jye o̱kitsò, k'en. ");
INSERT INTO maaNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jè xi̱ta̱ sko̱‑la̱ soldado, k'e̱ nga kijtseè kjoa̱ koi koni s'ín komà, kijtseèxkón Nainá, kitsò: ―Kixi̱í kjoa̱, xi̱ta̱ jè, xi̱ta̱ kixi̱‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ngats'iì xi̱ta̱ xi chixoña nga nchikotsejèn, k'e̱ nga jye kijtseè kjoa̱ xi komà, kiì‑ne ni'ya‑la̱; kisìjts'iìn‑sòn ini̱ma̱‑la̱ nga 'ñó tse kjoa̱ba kis'ejiìn ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ngats'iì xi̱ta̱ xi beèxkon Jesús ko̱ íchjín xi inchrobà‑tji̱ngui‑la̱ skanda ján Galilea, kjiìn jncha‑ne nga nchikotsejèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tíjna jngoò xi̱ta̱ xi 'mì José xi 'ñó ndaà xi̱ta̱, ti̱koa̱á xi̱ta̱ kixi̱‑né. Ya̱á i̱'nde‑la̱ ñánda 'mì Arimatea, jngoò na̱xa̱ndá xi chja̱‑ne Judea. Ti̱koa̱á xá ítjòn tjín‑la̱ ts'e̱ xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Jè José, ti̱koa̱á tíkoñaá‑la̱ nga mejèn‑la̱ skoe̱ kó s'ín otíxoma Nainá; mìkiì tíjngoò‑ikon koni s'ín tsajoóya‑ne xi̱ta̱xá xíkjín koni s'ín kisìko̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kiìkon Pilato; kiì síjé'nde‑la̱ nga kji̱nchrobàko̱ yijo‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kiskónáje̱n‑t'aà krò; kisìkájté jngoò nikje lino chroba. I̱kjoàn kiì kíhijiìn. Kiskinìs'en‑ngui jngoò nga̱jo̱ mik'en ñánda nga xó k'oa̱s'ín kitáx'a̱‑ne na̱xi̱. I̱'nde jè, ni̱ sa̱á jngoò mik'en sihijiìn. ");
INSERT INTO maaNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na̱chrjein jè, víspera‑la̱ s'eí Paxko̱‑né; jye kjo̱meè bijchó hora nga ko̱ts'ia̱ jè na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jñà íchjín xi tji̱ko̱ kóni nga inchrobà‑ne Galilea, kiìtji̱ngui‑la̱; kijtseèxkon nga̱jo̱ mik'en kó s'ín kisijna yijo‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","K'e̱ nga j'iì‑ne ni'ya‑la̱ tsibìtsa̱jnandaà xkiì xi 'ñó ndaà jne̱ ko̱ xkiì na̱'yo̱. I̱kjoàn kisìkjáya íchjín jè na̱chrjein nìkjáya, koni s'ín tíchja̱ kjo̱tíxoma. ");
INSERT INTO maaNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jè na̱chrjein nga tàts'en xomàna̱, 'ñó ta̱jñòya kiì jñà íchjín ya̱ nga̱jo̱ mik'en ñánda kisìhijiìn Jesús nga kiìko̱ xkiì jne̱ xi tsibítsa̱jnandaà nga ki̱ìxten‑jno yijo‑la̱ Jesús; ti̱koa̱ kjihijtako̱ íchjín xi kj'ei̱í. ");
INSERT INTO maaNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","K'e̱ nga ijchò, kijtseè jè nda̱jo̱ xi tíchjoàjto‑la̱ nga̱jo̱ mik'en, xìn kijna. ");
INSERT INTO maaNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","K'e̱ nga jahas'en‑ngui nga̱jo̱ mì ti̱ kiì kjòtsji‑la̱ yijo‑la̱ Na̱'èn‑ná Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","K'e̱ nga nchisíkájno íchjín koi, tà ni̱to̱ón chinchat'aà jò‑la̱ xi̱ta̱ x'i̱n xi íkjá nikje xi ote ni'ín kjoàn. ");
INSERT INTO maaNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Íchjín koi, tà kitsakjòn‑la̱; chincha‑ñiat'aà nangui. K'e̱é kitsò jñà xi̱ta̱ x'i̱n xi jò ma‑ne: ―¿Mé‑ne i̱ binchaàtsjijiìn‑là mik'en jè xi̱ta̱ xi tíjnakon? ");
INSERT INTO maaNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mì ti̱ yá tjín‑ne i̱jndé, jyeé kòfaáya‑la̱. Ti̱kítsjeèn koni s'ín kitsò‑nò k'e̱ nga ti̱sa̱ tsibìjna Galilea, ");
INSERT INTO maaNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","nga kitsò: “Mochjeén‑né nga jè Ki'ndí‑la̱ Xi̱ta̱, jñà ko̱nga̱tsja xi̱ta̱ jé nga ko̱òt'aà krò ta̱nga k'e̱ nga ki̱jchò jàn na̱chrjein kjoa̱áya‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jñà íchjín koi, k'e̱é tsibítsjeèn‑la̱ koni s'ín kitsò Jesús. ");
INSERT INTO maaNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","K'e̱ nga j'iì‑ne nga kiì katsejèn‑la̱ nga̱jo̱ mik'en, tsibéno̱jmí‑la̱ jñà xi̱ta̱ xi tsibíxáya‑la̱ xi tejngoò ma‑ne ko̱ xi̱ta̱ xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jñà íchjín koi, jè xi 'mì María Magdalena, Juana, María xi nea̱‑la̱ ma‑ne Jacobo ko̱ xi kj'ei̱í íchjín‑ìsa; jñà xi ijchòko̱ 'én nga tsibéno̱jmí‑la̱ jñà xi̱ta̱ xi tsibíxáya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ta̱nga jñà xi̱ta̱‑la̱ Jesús, xi kjoa̱ ni̱to̱n, tà kjoa̱ská komà‑la̱; mìkiì kòkjeiín‑la̱ 'én xi tsibéno̱jmí‑la̱ jñà íchjín. ");
INSERT INTO maaNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ta̱nga jè Pedro, tsangachikon, kiì katsejèn‑la̱ nga̱jo̱ mik'en; k'e̱ nga kiskoòtsejèn‑s'en nga̱jo̱, kijtseè nga tà jñà kjioò nikje xi kisìjtéjiìn Jesús. I̱kjoàn kiì‑ne ni'ya‑la̱; tà kjòxkón‑la̱ kjoa̱ xi komà. ");
INSERT INTO maaNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti̱jè‑ne na̱chrjein, jò xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús nchifì jngoò na̱xa̱ndá xi 'mì Emaús, xi tjín‑la̱ tsà tejngoò kilómetro skanda ján Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nga nchifì ya̱ ndi̱yá, koií nchijoóya‑ne ngats'iì kjoa̱ xi komà. ");
INSERT INTO maaNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nga nchijoóno̱jmí ti̱koa̱ nchikjònangui‑la̱ xíkjín ijchòtji̱ngui chrañà‑la̱ xi ti̱jè‑ne Jesús xi ta̱ña tsobáhijtako̱. ");
INSERT INTO maaNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ta̱nga jñà, k'oa̱á komà‑la̱ koni tsà tíchjoà xko̱n, mìkiì kijtseèxkon. ");
INSERT INTO maaNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús kiskònangui‑la̱, kitsò‑la̱: ―¿Mé 'én xi o̱ndaà chibàya‑nò nga tjaàya ndi̱yá? ¿Mé‑ne ba tjín‑nò? ");
INSERT INTO maaNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","K'e̱é kiìchja̱ Cleofas, kitsò: ―Ngats'iì xi̱ta̱ na̱xa̱ndá Jerusalén, tà ji̱ ta̱ jngoò‑lè xi mìkiì tíjiìn‑lè jè kjoa̱ xi komà ján Jerusalén, jñà na̱chrjein xi tsato. ");
INSERT INTO maaNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús kitsò: ―¿Mé kjoa̱‑ne? Jñà xi̱ta̱ koi kitsò‑la̱: ―Kjoa̱ ts'e̱ Jesús xi Nazaret i̱'nde‑la̱, jè xi kiìchja̱ ngajo‑la̱ Nainá; kis'eé‑la̱ nga'ñó, ma yijeé‑la̱ ni̱ta̱ mé kjoa̱‑ne, ni̱ta̱ mé 'én‑ne nga nguixko̱n Nainá, nguixko̱n ngats'iì xi̱ta̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Xi̱ta̱ sko̱‑la̱ no̱'miì, ko̱ xi̱ta̱xá tsa̱je̱n, kisìnga̱tsja xi̱ta̱ Romano nga kisìk'en, tsohót'aà krò. ");
INSERT INTO maaNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ngaje̱n, titsa̱chiñá‑la̱je̱n, bixón‑náje̱n tsà jè Mesías xi si̱ìkítsa̱jnandei̱í‑ne xi̱ta̱ na̱xa̱ndá Israel. Ta̱nga i̱'ndei̱, jyeé tjín‑la̱ jàn na̱chrjein nga k'oa̱s'ín komà kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ti̱koa̱á tjín i'nga íchjín xi títsa̱jnajiìn‑na̱je̱n, xi ta̱jñòya kòfì katsejèn‑la̱ jè nga̱jo̱ mik'en. K'e̱ nga kòf'iì‑ne kàbincháxkón‑naje̱n nga kàbéno̱jmí‑naje̱n ");
INSERT INTO maaNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nga mì xó kiì kàsakó‑la̱ yijo‑la̱ Jesús; ti̱koa̱ kàbeèxkon xó àkja̱le̱ xi kàtsò‑xó‑la̱: Jesús tíjnakon‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","K'e̱é kòfì i'nga xi̱ta̱ xingui̱‑je̱n xi kòfì katsejèn‑la̱ nga̱jo̱ mik'en, k'oa̱á ti̱s'ín kàbeèxkon koni s'ín kàtsò jñà íchjín ta̱nga jè Jesús, mì xó kiì kòbeè. ");
INSERT INTO maaNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","K'e̱é kitsò Jesús: ―¡Mé tà tòndo̱‑nò ti̱koa̱ mé tà tájaàjiìn tjín ini̱ma̱‑nò nga mìkiì ndaà mokjeiín‑nò kjoa̱ xi kitsò jñà xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá! ");
INSERT INTO maaNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿A mìtsà tíjiìn‑nò? K'oa̱á s'ín tjínè‑la̱ Cristo, xi̱ta̱ xi xó kisìkasén‑ne Nainá, nga ítjòn si̱ìkjeiín kjo̱'in, i̱kjoàn kjoa̱has'en ngajmiì ñánda jeya kíjna. ");
INSERT INTO maaNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tsibéno̱jmíya‑la̱ kó tsòya‑ne koni s'ín tíchja̱ ngats'iì Xo̱jo̱n‑la̱ Nainá i̱t'aà ts'e̱ Cristo. Tsibíts'ia̱ko̱‑ne xo̱jo̱n xi kiskiì Moisés; i̱kjoàn tsibéno̱jmíya‑la̱ ngats'iì xo̱jo̱n xi kiskiì jñà xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","K'e̱ nga ijchò ya̱ na̱xa̱ndá ñánda nchifì xi̱ta̱ koi, Jesús, k'oa̱á kis'iìn koni tsà ìsa̱ kjiìn tífì. ");
INSERT INTO maaNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ta̱nga jñà xi̱ta̱ koi, kjo̱'ñó kis'iìn‑la̱ nga kisìkíjna; kitsò‑la̱: ―Ti̱jnako̱‑náje̱n; jyeé kjòhoxòn, jye kiskaàtjì ts'oí. Jè Jesús, kòkjeiín‑la̱; jahas'en ni'ya; tsibìjnako̱. ");
INSERT INTO maaNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","K'e̱ nga jye títsa̱jnat'aà ími̱xa̱, kiskoé i̱nchra̱jín, kitsjaà‑la̱ kjo̱ndaà Nainá, kisìxkoa̱ya, i̱kjoàn kitsjaà‑la̱ jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","K'e̱é kitáx'a̱ xko̱n; kijtseèxkon nga jè Jesús; ta̱nga jè Jesús, tà kichijà‑né nga nguixko̱n xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","K'e̱é kitsò‑la̱ xíkjín: ―Koií‑la kjoa̱‑la̱ nga ndaà kòmatsja‑la̱ ini̱ma̱‑ná k'e̱ nga tíhóko̱no̱jmí‑ná ya̱ i̱ya ndi̱yá nga tíbéno̱jmí‑ná kjoa̱ ts'e̱ Xo̱jo̱n‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mì ti̱ kiì kiskoòñà‑ne, kisìkátji ni̱to̱ón‑ne nga kiì‑ne Jerusalén; ijchò ìjngoò k'a‑ne jngoò ni'ya ñánda títsa̱jnajtín xíkjín xi tejngoò ma‑ne ko̱ xi̱ta̱ xi kj'ei̱í‑ìsa. ");
INSERT INTO maaNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jñà xi̱ta̱ xi tejngoò ma‑ne kitsò‑la̱ xíkjín: ―Kixi̱í kjoa̱, jyeé kòfaáya‑la̱ Na̱'èn‑ná Jesús; jyeé kòbeèxkon Simón. ");
INSERT INTO maaNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","K'e̱é tsibéno̱jmí jñà xi̱ta̱ xi jò ma‑ne kó s'ín komàt'in ya̱ i̱ya ndi̱yá koa̱ kó s'ín komà nga kijtseèxkon Jesús k'e̱ nga kisìxkoa̱ya i̱nchra̱jín. ");
INSERT INTO maaNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tákó ti̱k'e̱é nchichja̱‑ìsa nga nchibéno̱jmí‑la̱ xíkjín kjoa̱ koi, nga tsasìjnajiìn osen‑la̱ Jesús; kisìhixat'aà, kitsò‑la̱: ―Nainá, 'nchán kàtasíkítsa̱jna‑nò. ");
INSERT INTO maaNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jñà xi̱ta̱ koi, tsí ndaà kitsakjòn, koa̱ tsí ndaà kisinchaàxkón; k'e̱ nga kijtseè, komà‑la̱ tsà tà ini̱ma̱‑la̱ mik'en‑né. ");
INSERT INTO maaNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ta̱nga Jesús kitsò‑la̱: ―¿Mé tà ndaà tsakjoòn‑nò? ¿Mé‑ne k'oa̱ tsò‑ne kjo̱hítsjeèn xi bitjojiìn ini̱ma̱‑nò? ");
INSERT INTO maaNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Chítsejèn‑là ndsa̱a ko̱ ndso̱koaà. 'A̱n‑ná. Tjat'aà‑ná ndsa̱a koa̱ chítsejèn‑ná. Jngoò xi̱ta̱ xi tà ini̱ma̱, tsjìn‑la̱ yijo, ti̱koa̱á tsjìn‑la̱ nindaà, ta̱nga 'a̱n, tjín‑na koni s'ín titsa̱'yaà‑ná. ");
INSERT INTO maaNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","K'e̱ nga jye o̱kitsò‑la̱, tsakó‑la̱ tsja ko̱ ndso̱ko̱. ");
INSERT INTO maaNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ta̱nga jñà xi̱ta̱‑la̱ mìkiì xátí kòkjeiín‑la̱ nga tsja komà‑la̱ ti̱koa̱ kisinchaàxkón nga kijtseèxkon Jesús; k'e̱é kiskònangui Jesús, kitsò‑la̱: ―¿A tjín chiba‑nò tsojmì xi ma chine? ");
INSERT INTO maaNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kitsjaà i̱tsé‑la̱ ti̱n xi jye kichjàn, ko̱ tsjén‑la̱ cho̱ cera. ");
INSERT INTO maaNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesús kiskoé, i̱kjoàn kiskine nga nguixko̱n jñà xi̱ta̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","K'e̱é kitsò‑la̱ jñà xi̱ta̱‑la̱: ―Jñà kjoa̱ xi komàt'ian, jñà‑né xi tsibeno̱jmí‑nò k'e̱ nga ti̱sa̱ tsohóti̱jnako̱‑nò. K'oa̱á s'ín kixan‑nò nga ki̱tasòn yije‑né koni s'ín tíchja̱ xo̱jo̱n i̱t'aà ts'a̱n, jè kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés ko̱ ts'e̱ xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá ko̱ xi tjít'aà libro ts'e̱ Salmo. ");
INSERT INTO maaNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","K'e̱é kisìkichi̱ya‑la̱ kjo̱hítsjeèn‑la̱ mé‑ne nga kàtjahas'en‑jiìn‑la̱ koni s'ín tíchja̱ Xo̱jo̱n xi tjít'aà 'Én Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kitsò‑la̱: ―K'oa̱á s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá nga tsò nga 'a̱n xi Cristo, xi xó kisìkasén‑na Nainá, k'oa̱á s'ín tjínè‑na nga ki̱yá; ta̱nga k'e̱ nga ki̱jchò jàn na̱chrjein, kjoa̱áya‑na i̱t'aà ts'e̱ kjoa̱ biyaà. ");
INSERT INTO maaNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Xi i̱t'aà ts'a̱n, Nainá si̱ìjchàat'aà‑la̱ jé‑la̱ xi̱ta̱ k'e̱ nga si̱ìkájno jé‑la nga mì ti̱ jé ko̱hótsji‑ne. Jè 'én koi, mochjeén‑né nga ki̱nókjoa̱yajiìn yije‑la̱ xi̱ta̱ mats'ia̱ko̱‑ne Jerusalén kó nga tíjtsa i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jñò kéno̱jmió kjoa̱ kixi̱ koni s'ín komà. ");
INSERT INTO maaNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","'A̱n sìkasén‑nò jè kjo̱tjò xi tsjá Na̱'èn‑na̱ koni s'ín kitsjaà tso'ba. Ta̱nga jñò, i̱í ti̱tsa̱jna na̱xa̱ndá Jerusalén skanda k'e̱ nga tjoé‑nò nga'ñó‑la̱ Nainá xi nchrobá‑ne ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","K'e̱é kiìko̱ xi̱ta̱‑la̱ skanda ján na̱xa̱ndá Betania. Kiskímiì'nga tsja nga kisìjét'aà‑la̱ Nainá nga kàtasíchikon‑t'in jñà xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","K'e̱ nga tísíjét'aà‑la̱, kitjámiì'nga nga kiì‑ne ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jñà xi̱ta̱‑la̱, k'e̱ nga jye chincha-xkó'nchit'aà‑la̱ nga jeya kisìkíjna Jesús, kiì‑ne Jerusalén; 'ñó tsja kis'e‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Na̱chrjein inchijòn tsibìtsa̱jnaya i̱ngo̱ ítjòn nga kitsjaà‑la̱ kjo̱ndaà Nainá ti̱koa̱ jeya kisìkíjna.");
INSERT INTO maaNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","K'e̱ nga ti̱sa̱ tàts'en‑la̱ kjoa̱, jè 'Én, jyeé k'oa̱ tíjna‑né. Ya̱á tíjnako̱ Nainá. Jè 'Én, Nainá‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ko̱ ya̱á tíjnako̱ Nainá skanda ti̱sa̱ tàts'en‑la̱ kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jè Nainá, k'e̱ nga tsibíndaà ngats'iì tsojmì xi tjín, i̱t'aà ts'e̱é 'Én tsibíndaà; nì mé tsojmì tjín xi mì i̱t'aà ts'e̱ kisindaà. ");
INSERT INTO maaNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jè 'Én, i̱t'aà ts'e̱‑né nga títsa̱jnakon xi̱ta̱; jè kjoa̱ nga títsa̱jnakon xi̱ta̱, jè‑né ni'ín xi síhiseèn‑la̱ ngats'iì xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jè ni'ín xi síhiseèn ñánda jñò choòn, ote‑né, ko̱ jè kjoa̱ jñò mìkiì ma síkijne‑la̱ ni'ín nga síkits'o. ");
INSERT INTO maaNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tsibìjna jngoò xi̱ta̱ xi 'mì Juan xi Nainá kisìkasén. ");
INSERT INTO maaNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jè j'iì tsjá 'én i̱t'aà ts'e̱ ni'ín xi síhiseèn, mé‑ne ngats'iì xi̱ta̱ ko̱kjeiín‑la̱ koni s'ín kiìchja̱ya. ");
INSERT INTO maaNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mìtsà jè Juan ni'ín xi síhiseèn‑la̱ xi̱ta̱, tà 'én j'iì tsjá i̱t'aà ts'e̱ ni'ín xi síhiseèn‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jè ni'ín xi nguì kixi̱ kjoa̱ xi síhiseèn‑la̱ ngats'iì xi̱ta̱, ya̱á tínchrobá i̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","I̱í tsibìjna i̱sò'nde, ko̱ i̱t'aà ts'e̱é kisindaà i̱sò'nde, ta̱nga jñà xi̱ta̱ i̱sò'nde mìkiì kijtseèxkon. ");
INSERT INTO maaNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","J'iì nangui ñánda ts'e̱, ta̱nga jñà xi̱ta̱‑la̱ mìkiì kiskoétjò. ");
INSERT INTO maaNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ngats'iì xi̱ta̱ xi kiskoétjò ti̱koa̱ kòkjeiín‑la̱ jñà 'én xi kiìchja̱, k'oa̱á s'ín kitjò'nde‑la̱ nga Ki'ndí‑la̱ Nainá ma, ");
INSERT INTO maaNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ta̱nga mìtsà koi kjoa̱‑la̱ nga jní kits'iìn‑jiìn, ni̱ mìtsà koi kjoa̱‑la̱ nga i̱t'aà ts'e̱ xi̱ta̱ kits'iìn; koi‑né nga i̱t'aà ts'e̱ Nainá kits'iìn. ");
INSERT INTO maaNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jè 'én, xi̱ta̱á komà, i̱í tsibìjnajiìn‑naje̱n. Ki'ya‑náje̱n kjoa̱ jeya‑la̱ nga Ki'ndí tà jngoò‑la̱ Nainá. 'Ñó tjín‑la̱ kjo̱ndaà ko̱ kjoa̱kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan kitsjaà 'én i̱t'aà ts'e̱, kitsò: ―Jè jèe̱ xi k'oa̱s'ín kixan‑nò k'e̱ nga kixan‑nò: “Jè xi sa̱ nchrobá tji̱ngui‑na̱, jè ìsa̱ tíjna ítjòn‑na̱, nga ìsa̱ kjòtseé tíjna koni 'a̱n.” ");
INSERT INTO maaNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","'Ñó tse kjo̱ndaà kitjoé‑ná ngats'iaá, sa̱ 'ñó, sa̱ 'ñó ko̱chikon‑t'ian. ");
INSERT INTO maaNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Jè kjo̱tíxoma, i̱t'aà ts'e̱ Moisés j'iì‑ne, ta̱nga xi kjo̱ndaà ko̱ kjoa̱kixi̱, i̱t'aà ts'e̱ Jesucristo j'iì‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni̱ sa̱á jngoò xi̱ta̱ beèxkon kó kji Nainá. Tà jè xi ki'ndí ta̱jngoò‑la̱ xi ya̱ tíjnat'aà‑la̱, béno̱jmí kixi̱‑ná i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jñà 'én koi xi kitsjaà Juan, k'e̱ nga jñà xi̱ta̱ judío xi títsa̱jna Jerusalén kisìkasén‑la̱ no̱'miì ko̱ xi̱ta̱ levita ñánda tíjna Juan nga kiskònangui‑la̱, kitsò‑la̱: ―¿Yá xi̱ta̱‑ne ji̱? ");
INSERT INTO maaNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan tsibéno̱jmí kixi̱‑né; mìkiì tsakajna'ma, kitsò: ―Mìtsà 'a̱n xi Cristo, xi̱ta̱ xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Xi̱ta̱ koi ìjngoò k'a kiskònangui‑la̱ kitsò‑la̱: ―¿Yá‑né ngaji̱? ¿A ji̱‑né Elías? Juan kitsò: ―Majìn, mìtsà 'a̱n. ―¿A ji̱‑né xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá xi tjínè‑la̱ nga kjoi̱í? Juan kitsò: ―Majìn, mìtsà 'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ìjngoò k'a kiskònangui‑la̱, kitsò‑la̱: ―Ko̱t'ìn‑náje̱n, yá‑ne ji̱, mé‑ne nga ko̱ma ko̱nguíko̱‑la̱je̱n 'én jñà xi̱ta̱ xi kàsíkasén‑naje̱n. ¿Mé 'én xi k'oi̱‑náje̱n i̱t'aà tsi̱ji? ");
INSERT INTO maaNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","K'e̱é kitsò Juan: ―'A̱n‑ná xi̱ta̱ xi 'ñó chjàya i̱'nde i̱t'aà xìn ñánda nangui kixì choòn: “Tjandaà kixio̱o ndi̱yá‑la̱ Nainá”, koni s'ín kitsò Isaías, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jñà xi̱ta̱ xi ijchò kjònangui‑la̱ Juan, xi̱ta̱ fariseo‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ìjngoò k'a kiskònangui‑la̱, kitsò‑la̱: ―Tsà mìtsà ji̱ xi Cristo, ni̱ Elías, ni̱ jè xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá, mé‑ne xi̱ta̱ 'nè‑ne bautizar. ");
INSERT INTO maaNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kiìchja̱ Juan kitsò: ―'A̱n tà nandá s'iìn‑na̱ bautizar xi̱ta̱, ta̱nga tíjnajiìn jngoò‑nò xi jñò mìkiì yaxkon, ");
INSERT INTO maaNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","jè xi i̱skan kjoi̱í, jè xi ìsa̱ tíjna ítjòn koni 'a̱n; skanda mìkiì tjí'nde‑na̱ nga 'a̱n skíjnda̱'ñoá xo̱x'ín‑la̱ xo̱jté‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ngats'iì kjoa̱ koi, ján na̱xa̱ndá Betania nga k'oa̱s'ín komà, na̱xa̱ndá xi kijna xijngoaà ndá je Jordán, ñánda kis'iìn bautizar xi̱ta̱ jè Juan. ");
INSERT INTO maaNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nga komà nchijòn, Juan kijtseè Jesús nga tínchrobákon, kitsò: ―¡Chítsejèn‑là, jè jèe̱ xi síkasén Nainá k'oa̱á ngaya‑la̱ koni Orrè Ki'ndí xi faáxìn jé‑la̱ xi̱ta̱ i̱sò'nde! ");
INSERT INTO maaNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jè jèe̱ xi k'oa̱ kixan‑nò k'e̱ nga kixan: “Nchrobá tji̱ngui jngoò‑na xi̱ta̱ x'i̱n xi ìsa̱ tíjna ítjòn‑na̱ nga ìsa̱ kjòtseé tíjna koni 'a̱n.” ");
INSERT INTO maaNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ti̱koa̱á 'a̱n, mìkiì bexkoan yá‑né jè. Koií kjoa̱‑la̱ nga ta nandá s'in‑na bautizar xi̱ta̱ mé‑ne jñà xi̱ta̱ na̱xa̱ndá Israel skoe̱xkon‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan, k'oa̱s'ín kitsjaà 'én nga kitsò: ―Kìjtseè‑ná jè Ini̱ma̱ Tsjeè‑la̱ Nainá nga itjojen‑ne ngajmiì koni kji ni̱se paloma kji, tsibìjnasòn‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","'A̱n, kj'eè kì bexkoan, ta̱nga jè Nainá xi kisìkasén‑na̱ nga ko̱ nandá s'iìn‑na bautizar xi̱ta̱, kitsò‑na: “Jè xi jchi̱i nga ki̱tjojenè‑la̱ Ini̱ma̱ Tsjeè‑na̱ nga ya̱ kíjnasòn‑la̱, jè‑né xi ko̱ Ini̱ma̱ Tsjeè‑na̱ s'i̱in‑ne bautizar xi̱ta̱.” ");
INSERT INTO maaNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","'A̱n, k'oa̱á s'ín kìjtseè, k'oa̱á ma‑ne k'oa̱s'ín tsjaà 'én nga Jesús, jè xi Ki'ndí‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nga komà nchijòn, Juan ya̱á tíjna ìjngoò k'a; tji̱ko̱ jò xi̱ta̱ xi kota'yàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Juan kijtseèxkon Jesús nga ti̱koa̱ ya̱ tsóba, kitsò: ―¡Chítsejèn‑là, jè jèe̱ xi orrè‑la̱ Nainá xi ki̱yátjì jé‑la̱ xi̱ta̱! ");
INSERT INTO maaNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ingajò xi̱ta̱ koi, k'e̱ nga kiì'nchré koni s'ín kitsò Juan, kiìtji̱ngui‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús k'e̱ nga kisìkátjiya, kijtseè nga xi̱ta̱ tji̱ngui‑la̱ kitsò‑la̱: ―¿Mé xi binchaàtsjioò? Ingajò xi̱ta̱ koi, kiìchja̱, kitsò: ―Maestro, ¿ñánda tijni? ");
INSERT INTO maaNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús kitsò‑la̱: ―Nchrobá, chítsejèn. I̱kjoàn kiìtji̱ngui‑la̱, kijtseè ñánda bìjna Jesús. Ya̱á tsibìtsa̱jnako̱ nga jye kjòhoxòn, ijchò‑la tsà xi ñijòn. ");
INSERT INTO maaNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ingajò xi̱ta̱ koi, jñà xi kiìtji̱ngui‑la̱ Jesús k'e̱ nga kiì'nchré‑la̱ koni s'ín kitsò Juan, jngoò xi 'mì Andrés xi 'ndse̱ ma Simón Pedro. ");
INSERT INTO maaNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés kiì kátsji ítjòn 'ndse̱ xi 'mì Simón, kitsò‑la̱: ―Jyeé kàyaxkon‑je̱n jè Mesías xi xó kisìkasén‑ne Nainá. Jè 'én Mesías, Cristo tsòya‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés kiìko̱ Simón xi 'ndse̱ ma ya̱ ñánda tíjna Jesús. Jesús, k'e̱ nga kijtseè, kitsò‑la̱: ―Ngaji̱‑né xi 'mì‑lè Simón xi ki'ndí‑la̱ ma Jonás. I̱'ndei̱, Cefas k'oín‑lè ('én xi Pedro tsòya‑ne). ");
INSERT INTO maaNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nga komà nchijòn, Jesús k'oa̱á s'ín kisìkítsjeèn nga ján kjoi̱ nangui Galilea. Kiskaàjiìn Felipe, kitsò‑la̱: ―Nchrobá tji̱ngui‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe, ya̱á i̱'nde‑la̱ na̱xa̱ndá Betsaida, ya̱ ñánda i̱'nde‑la̱ Andrés ko̱ Pedro. ");
INSERT INTO maaNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe kiì kátsji Natanael, kitsò‑la̱: ―Jè xi̱ta̱ xi oxki̱t'aà kjo̱tíxoma xi kiskiì Moisés ko̱ xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, jyeé kàyaxkon‑je̱n nga jè Jesús xi ki'ndí‑la̱ José xi Nazaret i̱'nde‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael, kitsò‑la̱ Felipe: ―Ján na̱xa̱ndá Nazaret, ¿a tjín jngoò xi ndaà xi̱ta̱ xi ya̱ ki̱tjokàjiìn‑ne? Felipe kitsò: ―Nchroboí, chítsejèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús, k'e̱ nga kijtseè Natanael nga tínchrobákon, kitsò: ―Jè xi̱ta̱ jè xi nguì kixi̱ kjoa̱ nga xi̱ta̱ Israel nga ndaà tísíjchá yijo‑la̱ ko̱ mìkiì kona̱cha̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael kitsò: ―¿Kó s'ín ma‑ne nga yaxkon‑ná? Jesús kitsò: ―K'e̱é kòbe‑lè k'e̱ nga ti̱kj'eè chja̱‑lè Felipe nga tijna'ngui yá toò iko̱. ");
INSERT INTO maaNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael kitsò: ―Maestro, ngaji̱‑né xi Ki'ndí‑la̱ Nainá; ji̱‑né xi xi̱ta̱xá ítjòn‑la̱ na̱xa̱ndá Israel. ");
INSERT INTO maaNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kiìchja̱ Jesús kitsò: ―¿A koií‑né nga xan‑lè: Kòbe‑lè k'e̱ nga tijna'ngui yá toò iko̱ nga mokjeiín‑lè? K'oa̱á xan‑lè nga ìsa̱ 'ñó tse kjo̱xkón jcha̱á‑ìsi. ");
INSERT INTO maaNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ìjngoò k'a kiìchja̱ Jesús kitsò: ―Nguì o̱kixi̱ xi xan‑nò, na̱chrjein xi sa̱ f'iì ìsa̱ jcha̱xkoòn ngajmiì nga ti̱x'á koa̱ jñà àkja̱le̱‑la̱ Nainá fìmijìn koa̱ nchrobájen nga tjímat'aà‑na xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Xi komà jàn na̱chrjein, kis'e jngoò s'eí nga chixàn xi̱ta̱ ján na̱xa̱ndá Caná, ya̱ nangui Galilea. Ti̱koa̱á ya̱á tíjna jè nea̱‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ti̱koa̱ kinokjoà‑la̱ Jesús ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱ ya̱ ñánda chixàn xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","K'e̱ nga jyehet'aà vino, jè nea̱‑la̱ Jesús kitsò: ―Mì ti̱ mé vino tjín‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús kitsò: ―¿Mé xi ma‑lè? ¿Mé‑ne 'a̱n kò'mì‑ná? Kj'eè kiì bijchó na̱chrjein‑na̱ nga skoe̱‑na̱ xi̱ta̱ yá‑ná 'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jè nea̱‑la̱ Jesús kitsò‑la̱ jñà xi̱ta̱ xi bíya vino: ―K'oa̱á s'ín ti̱kitasòn yije‑là koni s'ín tsò‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ya̱ títsa̱jna joòn ti̱jí nda̱jo̱ xi sinchá nandá, xi síkjeén jñà xi̱ta̱ judío nga ma sítsjeè‑ne tsojmì xi tjín‑la̱ koni s'ín tjín kjo̱tíxoma‑la̱ xi xkón tjín. Jñà ti̱jí kjiyaá‑la̱ tsà jò ko̱ tsà jàn nisa nandá. ");
INSERT INTO maaNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús kitsò‑la̱ jñà xi̱ta̱ chi̱'nda xi nchibíya vino: ―Ti̱nchaà nandá ti̱jí koi. Jñà xi̱ta̱ chinchá nandá; jngoò k'aá kisìtseè. ");
INSERT INTO maaNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","I̱kjoàn kitsò Jesús: ―Ti̱nachrjeè chiba vino; tanguíko̱‑là jè xi tísís'in‑la̱ xi̱ta̱. K'e̱é kiìko̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jè xi̱ta̱ xi oko̱‑la̱ nga tísís'in‑la̱ jñà xi̱ta̱, kiskoòt'aà nandá xi vino komà; xi̱ta̱ jè, mìkiì tíjiìn‑la̱ ñánda j'iì‑ne. (Tà jñá tíjiìn‑la̱ xi̱ta̱ chi̱'nda xi tsachrje nandá.) Jè xi̱ta̱ xi oko̱‑la̱, k'e̱é kiìchja̱‑la̱ xi̱ta̱ x'i̱n xi chixàn, ");
INSERT INTO maaNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kitsò‑la̱: ―Ngats'iì xi̱ta̱, jè tsjá ítjòn vino xi 'ñó ndaà; k'e̱ nga jye 'ñó 'biì jñà xi̱ta̱, k'e̱é tsjá xi chiba ndaà. Ta̱nga ngaji̱, kòbinchatjó‑né xi 'ñó ndaà, skanda sa̱á tì'biì. ");
INSERT INTO maaNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jè kjo̱xkón xi kis'iìn ítjòn Jesús ján na̱xa̱ndá Caná nangui xi chja̱‑ne Galilea; k'oa̱á s'ín tsakó kjoa̱ jeya‑la̱ ko̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ kòkjeiín‑la̱ i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Xi jye komà i̱skan, Jesús kiì ján na̱xa̱ndá Capernaum; kiìko̱ nea̱‑la̱, 'ndse̱, ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱. Tà chibaá na̱chrjein tsibìtsa̱jna ya̱ na̱xa̱ndá jè. ");
INSERT INTO maaNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nga jye nchrobá machrañà s'eí‑la̱ xi̱ta̱ judío xi bitjo k'e̱ nga itjokàjiìn kjo̱'in ján nangui Egipto, Jesús kiì ján Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","K'e̱ nga jahas'en i̱ngo̱ ítjòn, kijtseè nga tjín xi̱ta̱ ya̱ ndi̱tsin i̱ngo̱ xi nchihotíjna nchra̱ja̱ ko̱ orrè ko̱ paloma; ti̱koa̱ títsa̱jna xi síkjatjìya to̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesús tsibíndaà jngoò na'ñó xi tsajá‑la̱ jñà xi̱ta̱ nga tsachrje yije ya̱ ndi̱tsin i̱ngo̱, ko̱ nchra̱ja̱ ko̱ orrè. Tsibíxteèn to̱n‑la̱ jñà xi síkjatjìya to̱n. Jngoò k'aá chinchá ngajten ími̱xa̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jñà xi̱ta̱ xi nchihotíjna ni̱se paloma, kitsò‑la̱: ―Ti̱nachrjeè yije cho̱ koi; kì ni'ya ndi̱tsi̱n 'nè ni'ya‑la̱ Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ k'e̱é tsibítsjeèn‑la̱ nga k'oa̱s'ín tjít'aà Xo̱jo̱n‑la̱ Nainá nga tsò: “'Ñó matsjake̱ ni'ya‑lè; koií kjoa̱‑la̱ nga machi̱ni̱keè.” ");
INSERT INTO maaNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jñà xi̱ta̱ judío kiskònangui‑la̱ Jesús, kitsò‑la̱: ―¿Mé kjo̱xkón xi okoò‑náje̱n nga tjín‑lè kjo̱tíxoma i̱t'aà ts'e̱ kjoa̱ xi 'nì? ");
INSERT INTO maaNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Kiìchja̱ Jesús kitsò‑la̱: ―Ti̱kixàña i̱ngo̱ jè, 'a̱n, jàn na̱chrjein kìndàyà ìjngoò k'a‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kitsò jñà xi̱ta̱ judío: ―I̱ngo̱ jè ichán joòn nó kisindaà‑ne, koa̱ ji̱, ¿a tà jàn na̱chrjein kíndaà xi̱tse̱ ìjngoò k'a‑ne? ");
INSERT INTO maaNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ta̱nga jè i̱ngo̱ xi kisìkaxki̱ Jesús, jè yijo‑la̱ xi o̱kitsò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","K'e̱ nga jye jaáya‑la̱ Jesús nga k'en, k'e̱é tsibítsjeèn‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ 'én xi o̱kitsò. K'e̱é kòkjeiín‑la̱ koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá ko̱ 'én xi kiìchja̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús k'e̱ nga tsibìjna s'eí Paxko̱ ján Jerusalén, kjìn xi̱ta̱ kòkjeiín‑la̱ i̱t'aà ts'e̱ k'e̱ nga kijtseè kjo̱xkón xi kis'iìn. ");
INSERT INTO maaNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ta̱nga Jesús mìtsà nguì ndaà tíjngoò ikon i̱t'aà ts'e̱ xi̱ta̱ koi, nga jyeé beèxkon yije xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jesús mìkiì mochjeén‑la̱ nga kj'ei̱í xi̱ta̱ o̱ki̱tso̱‑la̱ kó s'ín jñà xi̱ta̱; jè, jyeé beè ini̱ma̱‑la̱ xi̱ta̱ kós'ín síkítsjeèn. ");
INSERT INTO maaNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tsibìjna jngoò xi̱ta̱ fariseo xi ti̱koa̱ xi̱ta̱ ítjòn tsibìjna i̱t'aà ts'e̱ xi̱ta̱ judío; Nicodemo ki'mì. ");
INSERT INTO maaNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jngoò k'a j'iìkon Jesús k'e̱ nga jñò, kitsò‑la̱: ―Maestro, 'ya‑náje̱n nga jè Nainá kisìkasén‑lè mé‑ne ko̱kóya‑náje̱n. Nga jngoò xi̱ta̱ xi mìtsà Nainá tíjnako̱, mìkiì ko̱ma‑la̱ s'i̱in kjo̱xkón xi ji̱ 'nì. ");
INSERT INTO maaNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús kitsò‑la̱: ―Xi nguì o̱kixi̱, k'oa̱á xan‑lè, jè xi̱ta̱ xi mìkiì jts'ín xi̱tse̱ ìjngoò k'a‑ne, mìkiì skoe̱ kó s'ín otíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo kiskònangui, kitsò: ―¿Kós'ín ko̱ma jts'ín xi̱tse̱ ìjngoò k'a xi̱ta̱ xi jye kòjchínga? Ni̱ i̱tsé ko̱ma kjoa̱has'en ìjngoò k'a i̱ndso̱'ba̱ nea̱‑la̱ nga jts'ín ìjngoò k'a. ");
INSERT INTO maaNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kiìchja̱ Jesús kitsò: ―Xi nguì o̱kixi̱, k'oa̱á xan‑lè, jè xi mì i̱t'aà ts'e̱ nandá ko̱ Ini̱ma̱ Tsjeè‑la̱ Nainá jts'ín‑ne, mìkiì ko̱ma kjoa̱has'en‑jiìn ñánda tíhotíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jè xi ts'iìn i̱t'aà ts'e̱ xi̱ta̱, xi̱ta̱‑né. Koa̱ jè xi ts'iìn i̱t'aà ts'e̱ Ini̱ma̱ Tsjeè‑la̱ Nainá, ini̱ma̱‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kì maxkón‑lè koni s'ín tìxan‑lè: “Mochjeén‑né nga jts'ín xi̱tse̱ ìjngoò k'a‑ne jñà xi̱ta̱.” ");
INSERT INTO maaNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Jè tjo̱ 'ba‑né ni̱ta̱ ñánda‑ne; na'yà‑la̱ nga one. Ta̱nga mìkiì 'ya‑la̱ ñánda nchrobá‑ne, ti̱koa̱ mìkiì 'ya‑la̱ ñánda fì. K'oa̱á ti̱s'ín ma yije ngats'iì xi i̱t'aà ts'e̱ Ini̱ma̱ Tsjeè‑la̱ Nainá ts'iìn‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","K'e̱é kitsò Nicodemo: ―¿Kós'ín ma‑ne nga k'oa̱s'ín ko̱ma‑ne kjoa̱ koi? ");
INSERT INTO maaNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús kitsò‑la̱: ―Ngaji̱, maestro tijni ts'e̱ xi̱ta̱ na̱xa̱ndá Israel. ¿Mé‑ne mìkiì tíjiìn‑lè kjoa̱ koi? ");
INSERT INTO maaNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Xi nguì o̱kixi̱, k'oa̱á xan‑lè: Jè kjoa̱ xi ma‑naje̱n, k'oa̱á s'ín nokjoà‑je̱n; xi jye kina'yà‑je̱n, k'oa̱á s'ín bèno̱jmí‑je̱n. Jñò, mìkiì mokjeiín‑nò 'én‑na̱je̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","K'e̱ nga beno̱jmí‑nò kjoa̱ xi tjín i̱sò'nde, mìkiì mokjeiín‑nò. ¿A ko̱kjeiín‑nò tsà ke̱èno̱jmí‑nò kjoa̱ xi tjín ján ngajmiì? ");
INSERT INTO maaNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ni̱ saà jngoò xi̱ta̱ xi jye kiìmijìn ján ngajmiì; tà jè Ki'ndí‑la̱ Xi̱ta̱ xi ngajmiì tíjna nga ya̱ itjojen‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Koni s'ín kis'iìn Moisés nga kiskímiì'nga yá xi tjo̱ót'aà ye̱ ki̱cha̱ bronce ya̱ i̱'nde i̱t'aà xìn ñánda kixì choòn, k'oa̱á ti̱s'ín tjínè‑la̱ jè Ki'ndí‑la̱ Xi̱ta̱ nga tjámiìtje̱n‑t'aà jè yá, ");
INSERT INTO maaNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","mé‑ne ngats'iì xi̱ta̱ xi ko̱kjeiín‑la̱ i̱t'aà ts'e̱, mìkiì chi̱ja, s'e̱é‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Nainá 'ñó tsatoó kjòtsjakeè xi̱ta̱ i̱sò'nde nga kitsjaà Ki'ndí‑la̱ xi ta̱jngoò ma‑ne, mé‑ne ngats'iì xi̱ta̱ xi mokjeiín‑la̱ i̱t'aà ts'e̱, mìkiì chi̱ja; s'e̱é‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nainá mìtsà koi xá kisìkasén‑ne Ki'ndí‑la̱ nga kjo̱'in koi̱ìnè‑la̱ xi̱ta̱ i̱sò'nde; koií xá kisìkasén‑ne nga ko̱chrjekàjiìn kjo̱'in xi̱ta̱ kjoa̱ ts'e̱ jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Jè xi mokjeiín‑la̱ i̱t'aà ts'e̱ Ki'ndí‑la̱ Nainá, mìtsà kjo̱'in si̱nè‑la̱ xi kjoa̱ ts'e̱ jé‑la̱, ta̱nga jè xi mìkiì mokjeiín‑la̱ jyeé kjo̱'in tjínè‑la̱, koií kjoa̱‑la̱ nga mìkiì mokjeiín‑la̱ i̱t'aà ts'e̱ Ki'ndí‑la̱ Nainá xi ta̱jngoò ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jñà xi̱ta̱ xi mìkiì mokjeiín‑la̱, jyeé kjo̱'in tjínè‑la̱, koií kjoa̱‑la̱ k'e̱ nga j'iì i̱ i̱sò'nde jè xi̱ta̱ xi j'iìko̱ kjoa̱hiseèn, mìkiì kisaseèn‑la̱ kjoa̱hiseèn; ìsa̱á ndaà kisaseèn‑la̱ kjoa̱jñò, nga ch'o tjín kjoa̱ xi nchis'ín. ");
INSERT INTO maaNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ngats'iì xi̱ta̱ xi ch'o s'ín, majtikeè kjoa̱hiseèn; mìkiì ya̱ síchrañat'aà ñánda iseèn choòn, mé‑ne nga mìkiì jcha̱‑la̱ kjoa̱ xi ch'o nchis'ín. ");
INSERT INTO maaNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ta̱nga jñà xi̱ta̱ xi kjoa̱ kixi̱ nchis'ín, nchrobá kinchat'aà chrañà‑la̱ ñánda iseèn choòn, mé‑ne nga jcha̱‑la̱ nga ndaà tjín kjoa̱ xi nchis'ín koni s'ín mejèn‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nga jye komà kjoa̱ koi, Jesús kiìko̱ xi̱ta̱ xi kota'yàt'aà‑la̱ ján nangui Judea; ya̱á tsibìtsa̱jna chiba na̱chrjein nga kis'iìn bautizar xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan ti̱koa̱ kis'iìn bautizar xi̱ta̱ ya̱ na̱xa̱ndá Enón, jngoò i̱'nde xi chrañàt'aà‑la̱ ya̱ na̱xa̱ndá Salim, koií kjoa̱‑la̱ i̱'nde jè tjín jchán nandá. Jñà xi̱ta̱, ya̱á ijchòkon Juan nga komà bautizar. ");
INSERT INTO maaNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Na̱chrjein koi, ti̱kj'eè nda̱yá fìs'en Juan. ");
INSERT INTO maaNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Juan ko̱ jngoò xi̱ta̱ judío tsohótiya‑ne kjo̱tíxoma‑la̱ xi̱ta̱ judío xi xkón tjín kós'ín matsjeèya‑ne xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kiì jñà xi̱ta̱ ñánda tíjna Juan, kitsò‑la̱: ―Maestro, jè xi̱ta̱ xi ijchòkoi̱i ján xijngoaà xa̱jngá nandá Jordán, jè xi̱ta̱ xi ji̱ kits'iì 'én i̱t'aà ts'e̱, i̱'ndei̱ ti̱koa̱ tís'ín bautizar; sa̱á jé fìtji̱ngui‑la̱ ngats'iì xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kiìchja̱ Juan, kitsò: ―Ni̱mé xi s'e̱‑la̱ xi̱ta̱ tsà mì jè sobà Nainá tsjá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jñò, ndaà tíjiìn‑nò koni s'ín kixan‑nò nga mìtsà 'a̱n xi Cristo; 'a̱n‑ná xi kinìkasén ítjòn‑na i̱t'aà ts'e̱ xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jè xi̱ta̱ x'i̱n xi sa̱ kòbixan, tíjna chjo̱ón‑la̱; jè amigo‑la̱ xi kòbixan síjnat'aà chrañà‑la̱ nga tí'nchré‑la̱ koni s'ín tíchja̱. Tsja jchán ma‑la̱ k'e̱ nga 'nchré‑la̱ xi̱ta̱ xi sa̱ kòbixan. 'A̱n, k'oa̱á ti̱s'ín matsja‑na k'e̱ nga 'nchrè koni s'ín tís'ín xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Xi̱ta̱ jè, mochjeén‑né nga kàtasijna ítjòn. 'A̱n, kósi̱jna tji̱ngui‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Jè xi nchrobá‑ne ngajmiì, jè tíjna ítjòn‑la̱ ngats'iì xi̱ta̱. Jè xi i̱ i̱sò'nde ts'e̱, xi̱ta̱ i̱sò'nde‑né, ko̱ jñà 'én xi chja̱ kjoa̱ ts'e̱ i̱sò'nde‑né. Ta̱nga jè xi ngajmiì nchrobá‑ne, jè tíjna ítjòn‑la̱ ni̱ta̱ yá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jè tsjá 'én mé xi kijtseè ko̱ mé xi kiì'nchré. Ta̱nga 'én xi tsjá, ni̱yá xi mokjeiín‑la̱ koni s'ín tsò. ");
INSERT INTO maaNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ta̱nga jè xi̱ta̱ xi mokjeiín‑la̱ 'én xi chja̱, jè tsjá 'én nga Nainá, nguì 'én kixi̱í xi chja̱. ");
INSERT INTO maaNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Xi̱ta̱ xi Nainá kisìkasén, 'én‑la̱ Nainá chja̱, nga mìkiì fehet'aà koni s'ín síxájiìn ini̱ma̱‑la̱ jè nga'ñó xi tjín‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Na̱'èn‑ná tsjakeé Ki'ndí‑la̱; jè kisìnga̱tsja yije ni̱ta̱ mé kjoa̱‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jè xi mokjeiín‑la̱ koni tsò 'én xi chja̱ Ki'ndí‑la̱ Nainá, tjín‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne. Ko̱ jè xi mìkiì mokjeiín‑la̱ mìkiì kíjnakon ini̱ma̱‑la̱; kjo̱'in si̱nè‑la̱ xi kjo̱jti‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesús, kis'eno̱jmí‑la̱ nga jñà xi̱ta̱ fariseo kitsò: Jesús ìsa̱á kjín xi̱ta̱ tís'ín bautizar mé‑ne nga ya̱ skóta'yàt'aà‑la̱ mì k'oa̱‑ne Juan. ");
INSERT INTO maaNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ta̱nga Jesús mìtsà xi̱ta̱ kis'iìn bautizar; tà jñà xi̱ta̱ xi kota'yàt'aà‑la̱ xi kis'iìn bautizar.) ");
INSERT INTO maaNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","K'oa̱á komà‑ne itjojiìn‑ne nangui Judea; kiì ìjngoò k'a‑ne nangui Galilea. ");
INSERT INTO maaNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","K'e̱ nga kiì‑ne, kjo̱'ñó tjín‑ne nga ya̱ kjoa̱hato Samaria. ");
INSERT INTO maaNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ijchò jngoò na̱xa̱ndá xi 'mì Sicar, nangui xi chja̱‑ne Samaria, ya̱ chrañàt'aà‑la̱ nangui xi kitsjaà kjo̱tjò‑la̱ kjòtseé Jacob jè ki'ndí‑la̱ xi José ki'mì. ");
INSERT INTO maaNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ya̱á tíjna jngoò nga̱jo̱ nandá xi nei‑la̱ komà Jacob. Jesús jye 'ñó ijta‑la̱ nga tsó'baya ndi̱yá. Tsibìjnat'aà jè nga̱jo̱ nandá nga jyeé kjo̱meè bijchó nchisen. ");
INSERT INTO maaNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, tsojmií kiì katse ján i̱jiìn na̱xa̱ndá, jñà tsojmì xi ski̱ne̱. K'e̱é ijchò jngoò chjo̱ón xi ya̱ i̱'nde‑la̱ Samaria xi ijchòkjaá nandá. Jesús kitsò‑la̱: ―Tjiì i̱tsé‑ná nandá xi skia̱a. ");
INSERT INTO maaNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jñà xi̱ta̱ judío mìkiì ndaà fìko̱ xi̱ta̱ Samaria. Koií kjoa̱‑la̱, jè chjo̱ón kitsò: ―Ngaji̱ xi̱ta̱ judío‑né, ko̱ 'a̱n chjo̱ón Samaria‑ná. ¿Mé‑ne nandá nìjé‑ná? ");
INSERT INTO maaNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kiìchja̱ Jesús kitsò‑la̱: ―Tsà 'ya‑lè kjo̱tjò xi tsjá Nainá ko̱ tsà yaxkoin yá‑né xi tísíjé‑lè nandá, tsà ji̱ si̱jé‑la̱ nandá, jè tsjá‑lè nandá xi síkíjnakon‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jè chjo̱ón kitsò: ―Na̱'èn, nìmé kich'ì xi ko̱ma ki̱nachrje‑ne nandá. Jè nga̱jo̱ nandá 'ñó na̱nga̱. Ñánda tjín‑lè nandá xi síkíjnakon‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ngaji̱, ¿a ìsa̱á tijna ítjòn‑la̱ xi̱ta̱ jchínga‑na̱je̱n Jacob? Jè kitsjaà‑na̱je̱n jè nga̱jo̱ nandá jè. Jñà xi̱ta̱ jchínga‑na̱je̱n, i̱í kits'iì nandá, i̱xti‑la̱ ko̱ cho̱ tjè‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kiìchja̱ Jesús kitsò‑la̱: ―Ni̱ta̱ yá‑ne xi skoí nandá xi i̱ tíbitjo, ko̱xíndá ìjngoò k'a‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ta̱nga jè xi̱ta̱ xi skoí nandá xi 'a̱n tsjaà‑la̱, mì ti̱ kiì ko̱xíndá‑la̱ ni̱ta̱ kjé‑ne. K'oa̱á s'ín s'e̱ i̱jiìn ini̱ma̱‑la̱ koni jngoò nga̱jo̱ nandá xi tíbitjo nga jè nandá si̱ìkíjnakon‑ne ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jè chjo̱ón kitsò: ―Na̱'èn, tjiì‑ná jè nandá xi ko̱'mì‑la̱ mé‑ne nga mì ti̱ kiì ko̱xíndá‑na ti̱koa̱ mì ti̱ i̱í kjoi̱ikjaá‑na̱ nandá. ");
INSERT INTO maaNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús kitsò‑la̱: ―Ti̱nókjoa̱‑la̱ x'i̱n‑lè, nchrobákoi̱i i̱jndé. ");
INSERT INTO maaNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kiìchja̱ jè chjo̱ón kitsò: ―Tsjìn‑na̱ x'i̱n. Jesús kitsò‑la̱: ―O̱kixi̱í xi si nga tsjìn‑lè x'i̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Jyeé kò 'òn ma x'i̱n‑lè xi bijnakoi̱i. Jè xi̱ta̱ xi tijnakoi̱i i̱'ndei̱, mìtsà x'i̱n‑lè ma. O̱kixi̱í xi kasi nga tsjìn‑lè x'i̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jè chjo̱ón k'e̱ nga kiì'nchré 'én koi kitsò: ―Na̱'èn, k'oa̱á s'ín machi̱ya‑na nga ji̱í‑là xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Xi̱ta̱ jchínga‑na̱je̱n xi Samaria tsa̱je̱n, i̱í nindoò jè kijtseèxkón Nainá. Ta̱nga jñò xi xi̱ta̱ judío 'mì‑nò bixón‑nó nga tà ján Jerusalén jcha̱xkoán Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús kitsò‑la̱: ―Ngaji̱ chjo̱ón, kàtakjeiín‑lè, jyeé nchrobá machrañà na̱chrjein nga jcha̱xkón Nainá na̱s'ín mì i̱ kji̱nchrobà nindoò jè ko̱ ni̱ ján onguió Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jñò, xi Samaria tsa̱jòn, mìkiì 'ya yá‑né xi yaxkón; ta̱nga ngaje̱n xi xi̱ta̱ judío 'mì‑na̱je̱n, 'ya‑náje̱n yá xi yaxkón‑je̱n; nga tje̱‑la̱ xi̱ta̱ judío ki̱tjokàjiìn jngoò xi ko̱chrjekàjiìn kjo̱'in xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Jyeé nchrobá na̱chrjein, ko̱ ti̱jè‑ne hora jè, k'e̱ nga jñà xi̱ta̱ xi nguì kixi̱ kjoa̱ nga beèxkón Nainá, kàteèxkón nga ko̱ ini̱ma̱‑la̱ ko̱ kjoa̱ kixi̱. Ti̱koa̱ jè Na̱'èn‑ná ótsji‑né xi̱ta̱ xi k'oa̱á s'ín mejèn‑la̱ nga skoe̱xkón. ");
INSERT INTO maaNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nainá Ini̱ma̱ Tsjeè‑né. Jè xi̱ta̱ xi beèxkón, mochjeén‑né nga nguì ko̱ kjoa̱ kixi̱ ko̱ nguì ko̱ ini̱ma̱‑la̱ kàteèxkón. ");
INSERT INTO maaNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jè chjo̱ón, k'e̱é kitsò: ―'A̱n, be‑ná nga sa̱ kjoi̱í jè Mesías xi xó si̱ìkasén‑ne Nainá jè xi Cristo tsòya‑ne; k'e̱ nga jè xi kjoi̱í ke̱èno̱jmí yije‑naje̱n kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús kitsò‑la̱: ―'A̱n‑ná, jè xi tìhóko̱‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ti̱jè‑ne hora j'iì‑ne xi̱ta̱ xi kota'yàt'aà‑la̱ xi kiì katse tsojmì. Ta̱ k'oa̱á komà‑la̱ nga kijtseè nga chjo̱ón tíhóko̱. Ta̱nga ni̱jngoò xi̱ta̱ xi kitsò ikon nga kiskònangui‑la̱ mé xi tíkjònangui‑la̱, o mé 'én xi nchijoó. ");
INSERT INTO maaNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jè chjo̱ón, k'e̱é kisìkíjna nisa nandá‑la̱; kiì ján i̱jiìn na̱xa̱ndá nga tsibéno̱jmí yije‑la̱ xi̱ta̱; kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Nchrobá, chítsejèn‑là jngoò xi̱ta̱ xi k'oa̱ kàtsò yije‑na̱ kjoa̱ xi kis'iaàn. Tsà jè‑né xi Cristo xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","K'e̱é kiì jñà xi̱ta̱ na̱xa̱ndá nga kiì katsejèn‑la̱ ñánda tíjna Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ti̱k'e̱‑ne jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, tsibítsi'ba‑la̱, kitsò‑la̱: ―Maestro, ti̱chi. ");
INSERT INTO maaNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ta̱nga Jesús kitsò: ―'A̱n, tjín‑na tsojmì xi kókje̱en, xi jñò mìkiì yaxkon. ");
INSERT INTO maaNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ kitsò‑la̱ xíkjín: ―¿Yá xi kòf'iìko̱‑la̱ tsojmì xi ski̱ne̱? ");
INSERT INTO maaNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ta̱nga Jesús kitsò: ―Jñà tsojmì xi kíne̱e, jè‑né nga sìkitasoàn koni s'ín mejèn‑la̱ jè xi kisìkasén‑na̱ ko̱ nga sikjehet'aà xá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jñò, bixón‑nó nga nguì ñijòn sá chija‑la̱ nga sincháxkó tsojmì xi jye tímajchá. 'A̱n, k'oa̱á xan‑nò: Chítsejèn‑là xi̱ta̱ koi; k'oa̱á ngaya‑la̱ koni tsojmì tjè xi jye kòjchá; jyeé ko̱ma sincháxkó. ");
INSERT INTO maaNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jè xi̱ta̱ xi bíxkó, machjí‑la̱, ko̱ jñà tsojmì xi bincháxkó, k'oa̱á ngaya‑la̱ koni xi̱ta̱ xi s'e̱‑la̱ kjoa̱binachon, mé‑ne nga jè xi bítje̱ ko̱ xi bincháxkó ngásòn s'e‑la̱ kjo̱tsja. ");
INSERT INTO maaNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","'Én kixi̱‑né xi tsò: “Kj'ei̱í xi̱ta̱ xi bítje̱ koa̱ kj'ei̱í xi bíxkó.” ");
INSERT INTO maaNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","'A̱n, kisìkasén‑nò nga ki̱nchàxkó tsojmì xi mìtsà jñò kisengui‑nò kjo̱'in. Kj'ei̱í xi kisìxá. Ta̱nga jñò tíhoko̱‑nò nga bíxkó tsojmì tjè‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kjìn jchán xi̱ta̱ Samaria xi ya̱ títsa̱jna na̱xa̱ndá jè kòkjeiín‑la̱ i̱t'aà ts'e̱ Jesús koni kitsò 'én xi kitsjaà jè chjo̱ón nga kitsò: “K'oa̱á kàtsò yije‑na kjoa̱ xi kis'iaàn.” ");
INSERT INTO maaNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","K'e̱ nga jñà xi̱ta̱ Samaria ijchòkon Jesús ñánda tíjna, tsibítsi'ba‑la̱ nga ya̱ kàtìjnako̱. Jesús, jò na̱chrjein tsibìjnako̱. ");
INSERT INTO maaNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kjìn xi̱ta̱ kòkjeiín ìsa̱‑la̱ i̱t'aà ts'e̱ Jesús, k'e̱ nga kiì'nchré‑la̱ 'én xi jè sobà tsibéno̱jmí. ");
INSERT INTO maaNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jñà xi̱ta̱ kitsò‑la̱ jè chjo̱ón: ―I̱'ndei̱ mokjeiín‑naje̱n; mìtsà tà koi kjoa̱‑la̱ koni s'ín ki'mì‑náje̱n. Ngaje̱n sobà kina'yà‑la̱je̱n; k'oa̱á s'ín ma‑ne nga mokjeiín‑naje̱n. Kixi̱í kjoa̱, jè xi ko̱chrjekàjiìn kjo̱'in kjoa̱ ts'e̱ jé‑la̱ xi̱ta̱ i̱sò'nde, jè‑né xi Cristo xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Xi jye komà jò na̱chrjein nga tsibìjna Samaria, Jesús, itjojiìn ìjngoò k'a‑ne i̱'nde jè. Kiì ìjngoò k'a‑ne nangui Galilea. ");
INSERT INTO maaNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jè sobà Jesús kitsò: Ni̱jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá yaxkón nangui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","K'e̱ nga ijchò ya̱ Galilea, jñà xi̱ta̱ xi ya̱ i̱'nde‑la̱, ndaà kiskoétjò, nga jyeé kijtseè jñà kjoa̱ xi kis'iìn ján Jerusalén k'e̱ nga itjo s'eí Paxko̱. Jñà xi̱ta̱ koi ti̱koa̱á kiì‑ne k'e̱ nga itjo s'eí. ");
INSERT INTO maaNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús ijchò ìjngoò k'a ján Caná, nangui xi chja̱‑ne Galilea, ñánda kisìkjatjìya‑la̱ nandá nga vino kis'iìn. Ya̱ na̱xa̱ndá Capernaum tíjna jngoò chi̱'nda‑la̱ xi̱ta̱xá ítjòn xi ti̱koa̱ xá 'nga tjín‑la̱. 'Ñó xk'én ki'ndí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Xi̱ta̱ jè k'e̱ nga kiì'nchré nga Jesús ya̱ ijchò Galilea nga inchrobà‑ne Judea, kiìkon, tsibítsi'ba‑la̱ nga kàtjì ni'ya‑la̱, kàtasìndaà‑ne ki'ndí‑la̱ xi jyeé kjo̱meè biyaà. ");
INSERT INTO maaNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús kitsò‑la̱: ―Jñò, mìkiì mokjeiín‑nò k'e̱ nga tsà mìkiì jcha̱a kjo̱xkón ko̱ kjoa̱ xi okó kjoa̱ jeya‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jè xi̱ta̱ chi̱'nda ítjòn kitsò‑la̱ Jesús: ―Na̱'èn, t'i̱in kjo̱ndaà, ni̱to̱n nchroboí nga ti̱kj'eè biyaà ki'ndí‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús kitsò‑la̱: ―T'in‑ne ni'ya‑lè. Ki'ndí‑lè jyeé ndaà tíjna‑ne. Xi̱ta̱ jè kòkjeiín‑la̱ 'én xi kitsò‑la̱ Jesús. I̱kjoàn kiì‑ne ni'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","K'e̱ nga jye kjo̱meè bijchó‑ne ni'ya‑la̱, xi̱ta̱ chi̱'nda‑la̱ kiìkjaá indiaà, kitsò‑la̱: ―Ki'ndí‑lè jyeé ndaà tíjna‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Xi̱ta̱ jè, kiskònangui‑la̱ chi̱'nda‑la̱: ―¿Mé hora kjòxa̱n‑la̱ ch'in 'ndi̱ xi tjín‑la̱? Kitsò xi̱ta̱ chi̱'nda‑la̱: ―Ngojña̱ xi jngoò‑là kjòndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jè na̱'èn‑la̱ ti xi xk'én, kisijiìn‑la̱ nga ti̱jè‑ne hora k'e̱ nga kitsò‑la̱ Jesús: “Ki'ndí‑lè jyeé ndaà tíjna‑ne.” Xi̱ta̱ jè ko̱ ngats'iì xi̱ta̱ xi títsa̱jna ni'ya‑la̱, jyeé ndaà tjíjngoò ikon nga mokjeiín‑la̱ i̱t'aà ts'e̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jè xi ma‑ne jò kjo̱xkón xi kis'iìn Jesús k'e̱ nga inchrobà‑ne Judea nga j'iì‑ne ya̱ Galilea. ");
INSERT INTO maaNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","K'e̱ nga jye k'oa̱s'ín komà kjoa̱ koi, nga komà i̱skan, jñà xi̱ta̱ judío tsibíjna jngoò s'eí ján Jerusalén. Jesús kiì ìjngoò k'a ján Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ya̱ Jerusalén tíjna jngoò chrjó nandá xi 'mì Betesda nga 'én hebreo. 'Òn ma nguitjoa̱ xi tjín‑la̱. Ya̱á tíjna chrañàt'aà‑la̱ xotjoa̱ ts'e̱ orrè. ");
INSERT INTO maaNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ya̱ nguitjoa̱‑la̱ kjìn xi̱ta̱ xk'én kjiyijòngui: xi mìkiì tsejèn‑la̱, xi tsá'yá kjoàn, xi mìkiì ma síkjaníyá. Ngats'iì xi̱ta̱ koi nchikoña‑la̱ k'e̱ nga síjtìya‑la̱ nandá xi 'ncha jè chrjó. ");
INSERT INTO maaNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Jngoò àkja̱le̱‑la̱ Nainá xi tà kjé tà kjé bitjojen‑ne nga síjtìya‑la̱ nandá. Jè xi̱ta̱ xk'én xi fahas'en‑jiìn ítjòn nandá, k'e̱ nga jye jtìya‑la̱, ni̱to̱ón mandaà‑ne ni̱ta̱ mé ch'in xi tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ya̱ kijnajiìn jngoò xi̱ta̱ xi jye tjín‑la̱ kaàn chrj'oòn jàn nó nga xk'én. ");
INSERT INTO maaNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús, k'e̱ nga kijtseèxkon nga ya̱ kijna, kisijiìn‑la̱ nga jyeé 'ñó kjòtseé xk'én. Kitsò‑la̱: ―¿A mejèn‑lè ko̱ndaà‑ne? ");
INSERT INTO maaNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jè xi̱ta̱ xk'én, kitsò: ―Na̱'èn, mì yá xi síchját'aà‑na nga kinís'en‑jiìn‑na k'e̱ jtìya‑la̱ nandá. 'A̱n, k'e̱ nga mejèn‑na fahas'en‑jñà, kj'ei̱í xi̱ta̱ síkijne‑na nga fahas'en‑jiìn ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús kitsò‑la̱: ―Ti̱sítji̱in, chjoí nijñaà‑lè, ti̱tjájmiì. ");
INSERT INTO maaNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Xi̱ta̱ jè ni̱to̱ón kjòndaà‑ne, kiskoé‑ne nijñaà‑la̱, komà tsajmeè‑ne. Na̱chrjein jè, na̱chrjein nìkjáya‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jñà xi̱ta̱ judío kitsò‑la̱ jè xi̱ta̱ xi kjòndaà‑ne: ―Na̱chrjein i̱'ndei̱, na̱chrjein nìkjáya‑né. Mìkiì tjí'nde‑lè nga kíkoi̱i nijñaà‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Xi̱ta̱ jè kitsò: ―Jè xi̱ta̱ xi kàsìndaà‑na̱, jè sobà xi ko̱kàtsò‑na: “Chjoí nijñaà‑lè, ti̱tjájmiì.” ");
INSERT INTO maaNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Jñà xi̱ta̱ koi kiskònangui‑la̱, kitsò‑la̱: ―¿Yá‑né xi o̱kàtsò‑lè: “Chjoí nijñaà‑lè, ti̱tjájmiì”? ");
INSERT INTO maaNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Jè xi̱ta̱ xi jyeé kjòndaà‑ne mìkiì beèxkon yá xi̱ta̱‑ne xi kisìndaà‑ne nga jè Jesús jyeé xìn kiì nga itjokàjiìn‑la̱ xi̱ta̱ xi kjìn ma‑ne xi ya̱ títsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Xi komà i̱skan, Jesús kisatiìkjoò ìjngoò k'a xi̱ta̱ jè ya̱ i̱ya i̱ngo̱, kitsò‑la̱: ―Jyeé kòmandaà‑ne; ta̱nga kì ti̱ jé binchaàtsji‑ne, mé‑ne nga mì ìsa̱ ch'o tjín kjoa̱ xi ko̱mat'in. ");
INSERT INTO maaNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Xi̱ta̱ jè kiìkon jñà xi̱ta̱ judío, tsibéno̱jmí‑la̱ nga jè Jesús xi kisìndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jñà xi̱ta̱ judío kiìtji̱ngui kondra̱‑la̱ Jesús, mejèn‑la̱ si̱ìk'en koií kjoa̱‑la̱ nga k'oa̱s'ín s'ín k'e̱ nga na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ta̱nga Jesús kitsò‑la̱: ―Na̱'èn‑na̱ skanda na̱chrjein i̱'ndei̱ k'oa̱á tjín xá xi tís'ín, ti̱koa̱á 'a̱n k'oa̱á ti̱s'ín tìs'iaàn. ");
INSERT INTO maaNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","K'oa̱á ma‑ne jñà xi̱ta̱ judío ìsa̱á 'ñó ndaà kiìtji̱ngui kondra̱‑la̱ Jesús nga mejèn‑la̱ si̱ìk'en. Mìtsà tà koií kjoa̱‑la̱ nga mìkiì beèxkón na̱chrjein nìkjáya, ti̱koa̱á koií‑né nga jè Jesús Na̱'èn‑na̱ tsò‑la̱ Nainá. K'oa̱á s'ín tísíngásòn‑kjoò yijo‑la̱ koni Nainá nga k'oa̱ tsò. ");
INSERT INTO maaNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús kitsò‑la̱: ―Xi nguì o̱kixi̱ xi xan‑nò, 'a̱n xi Ki'ndí‑la̱ Nainá nì mé kjoa̱ xi s'iaàn xi tà kjo̱hítsjeèn ts'a̱n. Tà koií kjoa̱ s'iaàn xi be koni s'ín Na̱'èn‑na̱. Ngats'iì kjoa̱ xi s'ín Na̱'èn‑na̱, 'a̱n xi Ki'ndí ma, k'oa̱á ti̱s'ín s'iaàn. ");
INSERT INTO maaNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Jè xi Na̱'èn‑na̱ ma, 'ñó tsjakeè‑na nga Ki'ndí‑la̱ tsò‑na; okó yije‑na̱ mé xi s'iaàn. Ko̱kò‑ìsa‑na kjoa̱ xi ìsa̱ 'ñó xkón tjín, mé‑ne jñò, k'e̱ nga jcha̱a, ìsa̱ 'ñó ndaà ko̱xkón‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Koni s'ín s'ín Nainá nga síkjaáya‑la̱ mik'en ko̱ síkítsa̱jnakon ini̱ma̱‑la̱ ni̱ta̱ kjé‑ne, 'a̱n xi Ki'ndí‑la̱ ma, k'oa̱á ti̱s'ín tsjaà‑la̱ kjoa̱binachon yá‑né xi mejèn‑na nga tsjaà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Jè xi Na̱'èn‑na ma, mìtsà jè bíndaàjiìn‑la̱ xi̱ta̱, 'a̱n‑ná xi Ki'ndí‑la̱ ma kisìnga̱tsja yije‑na kjo̱tíxoma nga ko̱ma kìndaàjiìn‑la̱ xi̱ta̱, ");
INSERT INTO maaNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","mé‑nè ngats'iì xi̱ta̱ skoe̱xkón‑na nga Ki'ndí‑la̱ ma koni s'ín beèxkón Na̱'èn‑na̱. Jè xi mìkiì beèxkón‑na nga Ki'ndí‑la̱ ma, ti̱koa̱á mìkiì beèxkón Na̱'èn‑na̱ nga jè kisìkasén‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Xi nguì o̱kixi̱, k'oa̱á xan‑nò: Jè xi 'nchré 'én‑na̱ koni s'ín chjà, ti̱koa̱ mokjeiín‑la̱ i̱t'aà ts'e̱ xi kisìkasén‑na̱, tjín‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne. Mìtsà kjo̱'in si̱nè‑la̱, jyeé itjokàjiìn kjo̱'in ts'e̱ kjoa̱ biyaà, jyeé tíjnakon ini̱ma̱‑la̱ i̱t'aà ts'e̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Xi nguì o̱kixi̱ xi xan‑nò: Nchrobá na̱chrjein, ti̱jè‑ne hora jè, k'e̱ nga jñà mik'en kji̱'nchré jta̱‑na̱ xi Ki'ndí‑la̱ Nainá ma; jñà xi kji̱'nchré jta̱‑na̱, kítsa̱jnakon‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jè Na̱'èn‑na̱, ti̱jè‑ne xi kjoa̱binachon; ko̱ 'a̱n xi Ki'ndí‑la̱ ma, k'oa̱á ti̱s'ín kitsjaà‑na nga ti̱'a̱n‑na xi kjoa̱binachon. ");
INSERT INTO maaNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ti̱koa̱á kitsjaà‑na kjo̱tíxoma nga 'a̱n kìndaàjiìn‑la̱ xi̱ta̱, nga 'a̱n‑ná xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kì maxkón‑nò 'én koi, ki̱jchò na̱chrjein k'e̱ nga ngats'iì xi̱ta̱ xi títsa̱jnak'en ján ínchíbá mik'en kji̱'nchré‑la̱ jta̱‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ko̱sítje̱n ìjngoò k'a‑ne ya̱ nga̱jo̱ mik'en. Jñà xi̱ta̱ xi ndaà kis'iìn, kjoa̱áya‑la̱ nga s'e̱‑la̱ kjoa̱binachon, ta̱nga jñà xi̱ta̱ xi ch'o kis'iìn, kjoa̱áya‑la̱ nga s'e̱‑la̱ kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesús kitsò: ―'A̱n, nì mé xi s'iaàn xi ta̱ kjo̱hítsjeèn ts'a̱n. K'oa̱á s'ín bìndaàjñaà koni s'ín tsò‑na̱ Na̱'èn‑na̱. Kixi̱í bìndaàjñaà; mìtsà k'oa̱s'ín s'iaàn koni s'ín mejèn‑na̱. K'oa̱á s'ín s'iaàn koni s'ín mejèn‑la̱ Na̱'èn‑na̱ xi kisìkasén‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tsà ti̱'a̱n tsjaà‑na̱ 'én xi i̱t'aà ts'a̱n, 'én xi tsjaà, jñò kixón‑nò: “Nì mé chjí‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ta̱nga tjín jngoò xi kj'ei̱í xi tsjá 'én xi i̱t'aà ts'a̱n, be‑ná nga jè 'én xi tsjá i̱t'aà ts'a̱n, nguì 'én kixi̱‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jñò kinìkasén‑la̱ xi̱ta̱ Juan nga kiskònangui‑la̱. Jè Juan, kitsjaà kixi̱ 'én xi i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mìtsà kjo̱'ñó tjínè‑la̱ nga kj'ei̱í xi̱ta̱ tsjá 'én xi i̱t'aà ts'a̱n, koií k'oa̱ xan‑nò mé‑ne nga ki̱tjokàjñoò kjo̱'in kjoa̱ ts'e̱ jé. ");
INSERT INTO maaNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan k'oa̱s'ín ngaya‑la̱ koni jngoò ni'ín xi títì nga síhiseèn, ta̱nga jñò tà chiba na̱chrjein kinìtsjako̱o kjoa̱ iseèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jè xá xi tìs'iaàn, ìsa̱ 'ñó ts'e̱ chjí‑la̱ mì k'oa̱‑ne koni 'én xi kitsjaà Juan, nga jè Na̱'èn‑na̱ kitsjaà‑na̱ nga sìkitasoàn; ti̱jè‑ne xá xi tìs'iaàn okó i̱t'aà ts'a̱n nga kixi̱ kjoa̱ nga jè Na̱'èn‑na̱ kisìkasén‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Jè Na̱'èn‑na̱ xi kisìkasén‑na̱, tsjá 'én xi i̱t'aà ts'a̱n. Jñò, kj'eè kiì na'yà‑là jta̱‑la̱, nì mìkiì yaxkon kó kji i̱sén‑la̱; ");
INSERT INTO maaNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ti̱koa̱á jè 'én‑la̱ mìkiì fahas'en‑jiìn ini̱ma̱‑nò. Jè xi Nainá kisìkasén, mìkiì mokjeiín‑nò i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ndaà binchaàtsjijñoò Xo̱jo̱n‑la̱ Nainá nga k'oa̱s'ín nìkítsjeèn nga ya̱ sakó‑nò kjoa̱binachon ni̱ta̱ kjé‑né. Jè Xo̱jo̱n‑la̱ Nainá, tsjá 'én xi i̱t'aà ts'a̱n, ");
INSERT INTO maaNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ta̱nga jñò, mìkiì sasén‑nò nga nchrobátji̱ngui‑ná, mé‑ne nga s'e̱‑nò kjoa̱binachon koi. ");
INSERT INTO maaNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Mìtsà koi kjoa̱ otsjià nga jeya si̱ìkíjna‑na xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ta̱nga 'a̱n, beèxkoòn‑nò, nga jñò, mìkiì matsjacha Nainá nga ko̱ ini̱ma̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","'A̱n, i̱t'aà ts'e̱ Na̱'èn‑na̱ j'i̱‑na; jñò majìn‑nò nga chjoétjò‑ná. Ta̱nga tsà kj'ei̱í xi̱ta̱ kjoi̱í xi ta kjo̱tsja ts'e̱ kjoi̱í‑ne, ìsa̱á‑là ni̱to̱n chjoétjò. ");
INSERT INTO maaNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Jñò, ¿kós'ín ko̱ma ko̱kjeiín‑nò? Nga tà jè binchaàtsjioò nga ndaà ki̱tsa̱jnaà nga nguixko̱n xi̱ta̱, ko̱ mìtsà jè binchaàtsjioò nga ndaà ki̱tsa̱jnaà nga nguixko̱n Nainá xi tà jngoò ma. ");
INSERT INTO maaNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kì k'oa̱ s'ín nìkítsjeèn nga 'a̱n tsjat'in‑nò 'én nga nguixko̱n Na̱'èn‑na̱. Jè xi tsját'in‑nò 'én, ti̱jè‑ne Moisés xi jè ma'ñót'aà takòn. ");
INSERT INTO maaNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Jñò, tsà mokjeiín‑nò koni s'ín kiskiì Moisés, ti̱koa̱á ko̱kjeiín‑nò i̱t'aà ts'a̱n nga jè Moisés i̱t'aà ts'a̱án kiìchja̱ nga kiskiì. ");
INSERT INTO maaNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tsà mìkiì mokjeiín‑nò koni s'ín kiskiì Moisés, ¿kós'ín ko̱kjeiín‑nò 'én‑na xi beno̱jmí‑nò? ");
INSERT INTO maaNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nga jye komà kjoa̱ koi, Jesús kiì ján xijngoaà ndáchikon Galilea, xi ti̱koa̱ Tiberias 'mì. ");
INSERT INTO maaNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","'Ñó kjìn xi̱ta̱ kiìtji̱ngui‑la̱ nga jye kijtseè kjo̱xkón ndaà xi s'ín nga síndaà‑ne xi̱ta̱ xk'én. ");
INSERT INTO maaNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesús k'e̱é kiìmijìn‑jno jngoò nindoò, ya̱á tsibìjna ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jyeé tímachrañà s'eí Paxko̱ ts'e̱ xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús, k'e̱ nga kiskoòtsejèn, kijtseè nga 'ñó kjìn ma xi̱ta̱ tjíma tji̱ngui‑la̱, kitsò‑la̱ Felipe: ―¿Ñánda kindá‑lá tsojmì xi ko̱kje̱n xi̱ta̱ koi? ");
INSERT INTO maaNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tà k'oa̱á kitsò‑la̱, tà jè xi mejèn‑la̱ nga skoe̱ kó ki̱tso̱ Felipe. Jesús, jyeé tíjiìn‑la̱ mé kjoa̱ xi s'i̱in. ");
INSERT INTO maaNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe kitsò: ―Na̱s'ín jò‑la sìndo̱ na̱chrjein tjín‑ne chjí‑la̱ xi̱ta̱, mì‑la kiì ki̱chìya‑la̱ nga i̱tsé i̱tsé ski̱ne̱ ngats'iì xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kiìchja̱ Andrés xi ti̱koa̱ xi̱ta̱ xi ya̱ kota'yàt'aà‑la̱ Jesús xi 'ndsè ma Simón Pedro, kitsò: ");
INSERT INTO maaNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―I̱ tíjna jngoò ti xi 'ya 'òn i̱nchra̱jín ts'e̱ cebada ko̱ jò ma ti̱n xi 'ya, ta̱nga mì‑la kiì ki̱chìya‑la̱ nga 'ñó kjìn ma‑ne xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús kitsò‑la̱: ―Ko̱t'ìn‑la̱ jñà xi̱ta̱, kàtìtsa̱jna yije. I̱'nde jè 'ñó tjín xka̱ ijñá. Jñà xi̱ta̱ xi tsibìtsa̱jna, ma‑la̱ tsà 'òn jmiì xi nguì xi̱ta̱ x'i̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús, kiskoé i̱nchra̱jín, kitsjaà‑la̱ kjo̱ndaà Nainá, i̱kjoàn kitsjaà‑la̱ jñà xi̱ta̱‑la̱. K'e̱é kisìka'bí‑la̱ jñà xi̱ta̱ xi títsa̱jna. K'oa̱ ti̱s'ín kisìko̱ jñà ti̱n, kiskine ni̱ta̱ kó kji mejèn‑la̱ nga jngoò ìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","K'e̱ nga jye kjòskiì yije xi̱ta̱, Jesús kitsò‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱: ―Tíxkó yije‑nò xi kaningui‑ne, mé‑ne nga mì ki̱ts'ón‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Jñà xi̱ta̱‑la̱ tsibíxkó‑ne i̱nchra̱jín xi tsiningui‑ne. Nguì tejò ni̱si̱yá komà, k'e̱ nga jye tsakjèn yije xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jñà xi̱ta̱, k'e̱ nga jye kijtseè kjo̱xkón ndaà xi kis'iìn Jesús, kitsò‑la̱ xíkjín: ―Kixi̱í‑la kjoa̱, jè‑la xi̱ta̱ jè xi chja̱ ngajo‑la̱ Nainá, xi tjínè‑la̱ nga kjoi̱í i̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ta̱nga Jesús, ti̱k'e̱é kijtseèya‑la̱ nga jñà xi̱ta̱ mejèn‑la̱ kjo̱'ñó kiìko̱ nga xi̱ta̱xá ítjòn si̱ìkíjna; ìjngoò k'a kiìmijìn‑jno nindoò nga tà ta̱jngoò tsibìjna. ");
INSERT INTO maaNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","K'e̱ nga jye kòjñò, xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús inchrohòjen ìjngoò k'a‑ne ñánda kijna ndáchikon. ");
INSERT INTO maaNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jahas'en jngoò chitso, kiìsòn‑ndá nga kiì ján na̱xa̱ndá Capernaum. Jyeé 'ñó kòjñò, Jesús mìkiì xátí j'iì tji̱ngui‑la̱ jñà xi̱ta̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ya̱ i̱jiìn ndáchikon j'iì jngoò tjo̱xkón xi 'ñó jchán ts'a. Jè ndáchikon tsibíts'ia̱ nga kiskì'nga. ");
INSERT INTO maaNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","K'e̱ nga jye tjín‑la̱ tsà 'òn ko̱ tsà joòn jmiì metro nga tjímajiìn nandá, kijtseè nga jè Jesús tsóbasòn ndáchikon. Tífì tji̱ngui chrañà‑la̱ jè chitso. Jñà xi̱ta̱ tà kitsakjòn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","K'e̱é kiìchja̱ Jesús, kitsò‑la̱: ―Kì tsakjoòn‑jèn, 'a̱n‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jñà xi̱ta̱ tsjaá komà‑la̱, k'e̱é kisìkas'en chitso. Ko̱ jè chitso ni̱to̱ón ijchò ya̱ na̱xa̱ndá ñánda nchifì. ");
INSERT INTO maaNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nga komà nchijòn, jñà xi̱ta̱ xi tsibìtsa̱jna ján xijngoaà ndáchikon, kijtseè nga tà jngoò chitso kijna xi kiìko̱ xi̱ta̱, ta̱nga Jesús mìkiì tsejèn jahas'en ya̱ chitso. Tà jñà xi̱ta̱ xi kota'yàt'aà‑la̱ jahas'en nga kiì. ");
INSERT INTO maaNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ta̱nga ijchò chitso xi kj'ei̱í xi ya̱ inchrobà‑ne na̱xa̱ndá Tiberias; ya̱á chincha chrañà i̱'nde ñánda tsakjèn i̱nchra̱jín xi̱ta̱ xi 'òn jmiì ma‑ne, k'e̱ nga jè Jesús kitsjaà‑la̱ kjo̱ndaà Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jñà xi̱ta̱, k'e̱ nga kijtseè nga mì yá tjín Jesús ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱, k'e̱é jahas'en jñà chitso koi, kiì kátsji Jesús ján na̱xa̱ndá Capernaum. ");
INSERT INTO maaNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Xi̱ta̱ koi, k'e̱ nga jye ijchò ján xijngoaà ndáchikon, ya̱á kiskaàjiìn Jesús kitsò‑la̱: ―Maestro, ¿mé na̱chrjein j'i̱i i̱jndé? ");
INSERT INTO maaNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kiìchja̱ Jesús, kitsò‑la̱: ―Xi nguì o̱kixi̱, k'oa̱á xan‑nò, mìtsà koi xá binchaàtsji‑ná nga ki'yaà kjo̱xkón‑ndaà xi kis'iaàn, koií‑né nga kisìkjèn‑nò skanda kó nga kjòskioò. ");
INSERT INTO maaNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kì koi nìxátjiò tsojmì xi fehet'aà. Jè ti̱xátjiò tsojmì xi síkíjnakon ini̱ma̱‑ná ni̱ta̱ kjé‑né, jè xi 'a̱n tsjá xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱. Na̱'èn‑ná xi Nainá jè kitsjaà‑na kjo̱tíxoma kjoa̱ xi s'iaàn. ");
INSERT INTO maaNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Xi̱ta̱ koi, kiskònangui, kitsò‑la̱ Jesús: ―¿Mé xi s'e̱n‑je̱n nga ko̱ma si̱xá‑la̱je̱n Nainá koni s'ín mejèn‑la̱ jè? ");
INSERT INTO maaNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús kitsò‑la̱: ―Xá‑la̱ Nainá, jè‑né nga ko̱kjeiín‑nò i̱t'aà ts'e̱ xi Nainá kisìkasén. ");
INSERT INTO maaNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Xi̱ta̱ koi, kitsò‑la̱ Jesús: ―¿Mé kjo̱xkón ndaà xi ko̱kó‑náje̱n mé‑ne k'e̱ nga jcha̱‑je̱n ko̱kjeiín‑na̱je̱n? ¿Mé xi ma‑lè 'nì? ");
INSERT INTO maaNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Jñà xi̱ta̱ jchínga kjìn‑na̱je̱n tsakjèn i̱nchra̱jín xi 'mì maná, ján i̱'nde i̱t'aà xìn ñánda nangui kixì choòn. Koni s'ín tjít'aà Xo̱jo̱n‑la̱ Nainá nga tsò: “I̱nchra̱jín xi nchrobá‑ne ngajmiì kitsjaà‑la̱ nga kisìkjèn.” ");
INSERT INTO maaNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kiìchja̱ Jesús kitsò‑la̱: ―Xi nguì o̱kixi̱ xi xan‑nò, mìtsà jè Moisés kitsjaà‑nò i̱nchra̱jín xi ngajmiì inchrobà‑ne; jè Na̱'èn‑na̱ xi tsjá‑nò xi nguì i̱nchra̱jín xi ngajmiì nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","I̱nchra̱jín xi tsjá Nainá, jè xi jye itjojen‑ne ngajmiì, jè xi tsjá‑la̱ kjoa̱binachon jñà xi̱ta̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Xi̱ta̱ koi kitsò: ―Na̱'èn, kjit'aà na̱chrjein tjiì‑náje̱n i̱nchra̱jín koi. ");
INSERT INTO maaNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús, kitsò‑la̱: ―'A̱n‑ná i̱nchra̱jín xi síkíjnakon ini̱ma̱‑la̱ xi̱ta̱. Jè xi 'a̱n kji̱nchrobàt'aà‑na̱, mì ti̱ kiì ko̱hijò‑la̱. Jè xi ko̱kjeiín‑la̱ i̱t'aà ts'a̱n, mì ti̱ kiì ko̱xíndá‑la̱ ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Jyeé o̱kixan‑nò, jñò na̱s'ín titsa̱'yaà‑ná mìkiì mokjeiín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ngats'iì xi̱ta̱ xi 'a̱n tsjá‑na Na̱'èn‑na̱, 'a̱án nchrobát'aà‑na̱; ko̱ jñà xi 'a̱n nchrobát'aà‑na̱ mìkiì ochrjenguia. ");
INSERT INTO maaNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","'A̱n, mìtsà koi xá itjojen‑na̱ ngajmiì nga k'oa̱s'ín s'iaàn koni s'ín mejèn‑na. K'oa̱á s'ín sìkitasoàn koni s'ín mejèn‑la̱ Na̱'èn‑na̱ xi kisìkasén‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jè xi mejèn‑la̱ Na̱'èn‑na̱ xi kisìkasén‑na̱, nga ni̱jngoò xi̱ta̱ chi̱ja xi 'a̱n tsjá‑na̱. 'A̱n siìkjaáya‑la̱ i̱t'aà ts'e̱ kjoa̱ biyaà k'e̱ nga kjoe̱het'aà na̱chrjein. ");
INSERT INTO maaNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Koi xi mejèn‑la̱ jè xi kisìkasén‑na: ngats'iì xi̱ta̱ xi skoe̱xkon‑na nga Ki'ndí‑la̱ Nainá 'mì‑na ko̱ ko̱kjeiín‑la̱ i̱t'aà ts'a̱n, s'e̱é‑la̱ kjoa̱binachon. 'A̱n siìkjaáya‑la̱ k'e̱ nga kjoe̱het'aà na̱chrjein. ");
INSERT INTO maaNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jñà xi̱ta̱ judío k'e̱é tsibíts'ia̱ nga kiìchja̱jno‑la̱ Jesús, koií kjoa̱‑la̱ nga kitsò: “'A̱n‑ná i̱nchra̱jín xi ngajmiì nchrobá‑ne.” ");
INSERT INTO maaNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kitsò‑la̱ xíkjín: ―¿A mìtsà jè Jesús, xi ti‑la̱ ma José? Yaxkon‑ná na̱'èn‑la̱ ko̱ nea̱‑la̱. ¿Mé‑ne tsò‑ne nga ngajmiì itjojen‑ne? ");
INSERT INTO maaNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","K'e̱é kitsò Jesús: ―Kiì k'oa̱s'ín nokjoàjno‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni̱jngoò xi̱ta̱ xi ko̱ma kji̱nchrobàt'aà‑na tsà mìtsà jè Na̱'èn‑na̱ xi kisìkasén‑na kji̱nchrobàko̱, mé‑ne nga 'a̱n siìkjaáya‑la̱ k'e̱ nga kjoe̱het'aà na̱chrjein. ");
INSERT INTO maaNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, k'oa̱á tsò xo̱jo̱n xi kiskiì nga tsò: “Jè sobà Nainá ko̱kòya yije‑la̱ xi̱ta̱.” K'oa̱á s'ín ma‑ne nga ngats'iì xi̱ta̱ xi 'nchré‑la̱ Na̱'èn‑na̱ ko̱ xi machi̱ya‑la̱ i̱t'aà ts'e̱, 'a̱án nchrobát'aà‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ni̱ sa̱á jngoò xi̱ta̱ xi beèxkon Na̱'èn‑ná. Ta̱jngoò jè beèxkon xi Nainá kisìkasén. ");
INSERT INTO maaNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Xi nguì o̱kixi̱ xi xan‑nò: Jè xi ko̱kjeiín‑la̱ i̱t'aà ts'a̱n s'e̱é‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","'A̱n‑ná i̱nchra̱jín xi síkíjnakon ini̱ma̱‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jñà xi̱ta̱ jchínga kjìn‑nò tsakjèn i̱nchra̱jín xi 'mì maná ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn, ta̱nga tákó k'en‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jè i̱nchra̱jín xi k'oa̱ xan‑nò xi nchrobájen‑ne ngajmiì. Ko̱ jè xi ko̱kje̱n i̱nchra̱jín jè mìkiì ki̱yá. ");
INSERT INTO maaNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","'A̱n‑ná i̱nchra̱jín xi tíjnakon xi itjojen‑ne ngajmiì. Tsà yá xi ko̱kje̱n i̱nchra̱jín jè, s'e̱é‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne. Jè i̱nchra̱jín xi 'a̱n tsja, jè yijo‑na̱. Koií k'oa̱s'ín tsjaà‑na nga 'a̱n ki̱yátjì‑la̱ xi̱ta̱ i̱sò'nde mé‑ne nga kítsa̱jnakon‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jñà xi̱ta̱ judío xki̱ xi ján tsajoóko̱ xíkjín, kitsò: ―¿Kós'ín s'i̱in nga siìkine‑ná yijo‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús kitsò‑la̱: ―Nguì o̱kixi̱í xi xan‑nò. Jñò, tsà mìkiì chji̱ne̱e yijo‑na̱ 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, ti̱koa̱ mìkiì s'io̱o jní‑na̱, mìkiì s'e̱‑nò kjoa̱binachon. ");
INSERT INTO maaNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jè xi ski̱ne̱ yijo‑na̱ ti̱koa̱ skoí jní‑na̱ tjín‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne. 'A̱n siìkjaáya‑la̱ k'e̱ nga kjoe̱het'aà na̱chrjein. ");
INSERT INTO maaNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yijo‑na̱, jè xi kixi̱ kjoa̱ xi nguì yijo xi ma chine; koa̱ jè jní‑na̱ jè nandá xi nguì kixi̱ kjoa̱ nga ma 'yò. ");
INSERT INTO maaNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jè xi ski̱ne̱ yijo‑na̱ koa̱ skoí jní‑na̱, kjit'aà na̱chrjein ya̱ kíjnako̱‑na, ti̱koa̱ 'a̱n kjit'aà na̱chrjein ya̱ tìjna̱kjoòkoa̱a. ");
INSERT INTO maaNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Na̱'èn‑na̱ xi kisìkasén‑na, tíjnakon‑né; ko̱ i̱t'aà ts'e̱‑né nga tìjna̱koan; k'oa̱á ti̱s'ín tjín jè xi ski̱ne̱ yijo‑na̱, i̱t'aà ts'a̱n kíjnakon‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jè i̱nchra̱jín xi itjojen‑ne ngajmiì, mìtsà jè xíkjín i̱nchra̱jín maná xi tsakjèn xi̱ta̱ jchínga kjiìn‑nò; nga komà i̱skan, xi̱ta̱ xi tsakjèn, k'en‑né. Ta̱nga jè xi ko̱kje̱n i̱nchra̱jín xi itjojen‑ne ngajmiì, s'e̱é‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús k'oa̱á s'ín kiìchja̱ nga tsakóya ya̱ ni'ya i̱ngo̱ sinagoga ya̱ na̱xa̱ndá Capernaum. ");
INSERT INTO maaNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jñà xi̱ta̱ k'e̱ nga kiì'nchré koni s'ín tsakóya Jesús, kjín ma xi̱ta̱ xi kota'yàt'aà‑la̱ xi kitsò: ―Jñà 'én koi, 'ñó 'in tjín. ¿Yá xi ko̱kjeiín‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús, k'e̱ nga kijtseèya‑la̱ nga jñà xi̱ta̱ xi kota'yàt'aà‑la̱ ch'o nchijoóya‑ne 'én xi tsakóya, kitsò‑la̱: ―¿'Én koi, a mì sasén‑nò? ");
INSERT INTO maaNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Kós'ín ko̱ma‑ne tsà jcha̱‑ná 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱ nga kjímijìn ìjngoò k'a‑na ñánda tìjna̱a nga sa̱ ítjòn? ");
INSERT INTO maaNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jè Ini̱ma̱ Tsjeè‑la̱ Nainá xi síkíjnakon‑ná. Jè yijo‑ná nìmé chjí‑la̱. 'Én xi 'a̱n okóya‑nò, ts'e̱é Ini̱ma̱ Tsjeè‑la̱ Nainá, ko̱ tsjá‑la̱ kjoa̱binachon ini̱ma̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ta̱nga jñò tjín i'nga xi̱ta̱ xinguio̱o xi mìkiì mokjeiín‑la̱. Nga jè Jesús jye tíjiìn‑la̱ kóni skanda tàts'en‑la̱ kjoa̱ yá‑né xi mìkiì ko̱kjeiín‑la̱ ko̱ yá‑né xi si̱ìnga̱tsja i̱t'aà ts'e̱ xi̱ta̱ kondra̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesús kitsò ìsa̱: ―Koií k'oa̱s'ín kixan‑nò nga ni̱jngoò xi̱ta̱ xi ko̱ma kji̱nchrobàt'aà‑na̱ tsà mìtsà jè Na̱'èn‑na̱ kji̱nchrobàko̱. ");
INSERT INTO maaNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","I̱kjoàn kjìn jchán xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús xi tji̱ngui‑la̱ tsibíts'ia̱ nga kiì‑ne íts'i̱n. Mì ti̱ kiì ya̱ chinchimako̱‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesús kitsò‑la̱ jñà xi̱ta̱‑la̱ xi tejò ma‑ne: ―Jñò, ¿a ti̱koa̱á mejèn‑nò nga onguió? ");
INSERT INTO maaNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kiìchja̱ Simón Pedro, kitsò: ―Na̱'èn, ¿yá xi onguítji̱ngui‑la̱je̱n? Ji̱‑né xi tjín‑lè 'én xi tsjá kjoa̱binachon. ");
INSERT INTO maaNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ngaje̱n 'ya‑náje̱n, ti̱koa̱á mokjeiín‑naje̱n nga ji̱‑né xi Cristo, xi Ki'ndí‑la̱ Nainá xi tíjnakon. ");
INSERT INTO maaNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús kitsò‑la̱: ―'A̱n, xó k'oa̱á s'ín jaàjiìn‑nò nga tejò ma‑nò, mé‑ne nga ki̱tjáko̱‑ná. Ta̱nga jñò, ya̱á tíjnajiìn jngoò‑nò xi xi̱ta̱ nei̱í tísíxájiìn ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús, jè kiìchja̱ i̱t'aà ts'e̱ Judas, ki'ndí‑la̱ Simón Iscariote. Nga jè si̱ìnga̱tsja Jesús i̱t'aà ts'e̱ xi̱ta̱ kondra̱‑la̱. Jè Judas, xi ya̱ itjojiìn xi̱ta̱‑la̱ Jesús xi tejò ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","K'e̱ nga jye k'oa̱s'ín komà kjoa̱ koi, Jesús ya̱á tsajmeè nangui Galilea. Majìn‑la̱ nga ya̱ ko̱jmeè na̱xa̱ndá Judea, koií kjoa̱‑la̱ nga jñà xi̱ta̱ judío nchihótsji nga mejèn‑la̱ si̱ìk'en. ");
INSERT INTO maaNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jyeé nchrobá machrañà s'eí‑la̱ xi̱ta̱ judío ts'e̱ Ni'ya Xka̱ Ijñá. ");
INSERT INTO maaNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jñà 'ndse̱ Jesús kitsò‑la̱: ―Kì ta̱ tsja i̱í bijni. T'in ján Judea mé‑ne jñà xi̱ta̱ xi kota'yàt'aà‑lè xi títsa̱jna ján kàteè‑lè mé kjoa̱ xi 'nì. ");
INSERT INTO maaNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tsà k'e̱ mejèn‑ná nga skoe̱‑ná xi̱ta̱ mé kjoa̱ xi tí'né, mochjeén‑né nga ko̱kó‑lá yijo‑ná. Ngaji̱, koni s'ín 'nì, ta̱kó‑là yijo‑lè ngats'iì xi̱ta̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Koií o̱kitsò‑la̱ jñà 'ndse̱ nga mìkiì kòkjeiín‑la̱ i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús kitsò‑la̱: ―Kj'eè kiì bijchó na̱chrjein‑na̱, ta̱nga xi i̱t'aà tsa̱jòn ndaà tjín ni̱ta̱ mé na̱chrjein‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Jñò, mìkiì majtikeè‑nò jñà xi̱ta̱ i̱sò'nde, ta̱nga 'a̱n majtikeé‑na̱, koií kjoa̱‑la̱ nga 'a̱n beno̱jmí kixi̱‑la̱ nga ch'o tjín kjoa̱ xi s'ín. ");
INSERT INTO maaNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tanguió jñò jè s'eí, 'a̱n mìkiì kjián. Kj'eè kiì bijchó na̱chrjein‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","K'e̱ nga jye o̱kitsò‑la̱ jñà xi̱ta̱, Jesús ya̱á tsibìjna ya̱ nangui Galilea. ");
INSERT INTO maaNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","K'e̱ nga jye kiì s'eí jñà 'ndse̱ Jesús, jè, ti̱koa̱á kiì 'ma‑né. Majìn‑la̱ nga xi̱ta̱ skoe̱xkon. ");
INSERT INTO maaNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ya̱ ñánda tíbitjo s'eí, jñà xi̱ta̱ judío nchihótsji Jesús, kitsò‑la̱ xíkjín: ―Xi̱ta̱ jè, ñánda tíjna. ");
INSERT INTO maaNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ngats'iì xi̱ta̱ xi ijchò s'eí, xki̱ xi ján tsajoóya‑ne i̱t'aà ts'e̱ Jesús. Tjín xi kitsò: “Xi̱ta̱ ndaà‑né.” Ti̱koa̱ tjín xi kitsò: “Majìn, na̱xa̱ndá kona̱cha̱n‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ta̱nga ni̱yá xi kiìchja̱ tsejèn nga nguixko̱n xi̱ta̱ xi kj'ei̱í, nga jñà xi̱ta̱ sko̱‑la̱ xi̱ta̱ judío, tsakjón‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","K'e̱ nga jye ijchò osen nga tíbitjo s'eí, ijchò Jesús, jahas'en i̱ngo̱ ítjòn, i̱kjoàn tsakóya‑la̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jñà xi̱ta̱ judío, k'e̱ nga kijtseè koni s'ín okóya, tà kjòxkón‑la̱ kitsò‑la̱ xíkjín: ―Xi̱ta̱ jè, ¿kós'ín ma‑ne nga ko̱ tà ndaà okóya‑ne nga mìtsà xo̱jo̱n kiskoòta'yà? ");
INSERT INTO maaNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús kitsò‑la̱: ―Jñà 'én xi 'a̱n okoòya, mìtsà 'én ts'a̱n, ts'e̱‑né jè xi kisìkasén‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tsà yá xi mejèn‑la̱ si̱ìkitasòn koni s'ín mejèn‑la̱ Nainá, skoe̱‑né jñà 'én xi 'a̱n okoòya tsà i̱t'aà ts'e̱ Nainá nchrobá‑ne, o xi tà kjo̱hítsjeèn ts'a̱n‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jngoò xi̱ta̱ xi tà kjo̱hítsjeèn ts'e̱ tísíkjeén nga tíchja̱, tà jè xi mejèn‑la̱ nga jè jcha̱xkón; ta̱nga jè xi̱ta̱ xi koií kjoa̱ tíhótsji nga jè kàtayaxkón jè xi kisìkasén, jè‑né xi nguì 'én kixi̱ tsjá, mìtsà 'én ndiso chja̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Jñò, ¿a mìtsà kixi̱ kjoa̱ nga kitjoé‑nò kjo̱tíxoma‑la̱ Nainá xi jè Moisés kiskiì? Ta̱nga jñò, ni̱jngoò xi ma‑la̱ síkitasòn. ¿Mé‑ne mejèn‑nò nga si̱k'en‑ná? ");
INSERT INTO maaNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jñà xi̱ta̱ kitsò: ―¡Nei̱í‑là tíjiìn ini̱ma̱‑lè! ¿Yá‑né xi mejèn‑la̱ si̱ìk'en‑lè? ");
INSERT INTO maaNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús kiìchja̱ kitsò‑la̱: ―Jñò, maxkón‑nò jngoò kjoa̱ xi kis'iaàn jè na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kixi̱í kjoa̱, jè Moisés kitsjaà‑nò kjo̱tíxoma xi kjoa̱ ts'e̱ circuncisión. (Ta̱nga kjo̱tíxoma jè, mìtsà ts'e̱ Moisés; i̱t'aà ts'e̱é xi̱ta̱ jchínga kjiìn‑nò inchrobà‑ne.) Ta̱nga jñò, na̱s'ín na̱chrjein nìkjáya bít'aà chibaá‑la̱ xi̱ta̱ x'i̱n kjoa̱ ts'e̱ circuncisión. ");
INSERT INTO maaNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jñò, nga bìt'aà chi̱ba̱‑la jñà xi̱ta̱ kjoa̱ ts'e̱ circuncisión jè na̱chrjein nìkjáya nga majìn‑nò nìjchaànguio kjo̱tíxoma xi kitsjaà‑nò Moisés, ¿mé‑ne majti‑nò nga 'a̱n jngoò k'a ndaà sìndaà‑na xi̱ta̱ jè na̱chrjein nìkjáya? ");
INSERT INTO maaNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kì k'oa̱á s'ín jchósòn‑là koni s'ín tsejèn‑nò. K'oa̱á s'ín jchósòn‑là koni s'ín tjín xi nguì kjoa̱ kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tjín i'nga xi̱ta̱ xi Jerusalén ts'e̱ xi kitsò: ―¿A mìtsà jè xi̱ta̱ jè xi ótsji jñá xi̱ta̱ judío nga mejèn‑la̱ si̱ìk'en? ");
INSERT INTO maaNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chítsejèn‑là, tíchja̱jiìn osen‑la̱ jñà xi̱ta̱ na̱xa̱ndá, ni̱yá xi kó tsò‑la̱. ¿A jyeé kòkjeiín‑la̱ jñà xi̱ta̱xá nga kixi̱ kjoa̱ nga jè xi Cristo xi xó Nainá kisìkasén‑ne? ");
INSERT INTO maaNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ta̱nga jñá, 'ya‑ná ñánda j'iì‑ne xi̱ta̱ jè, k'e̱ nga kjoi̱í Cristo ni̱yá xi skoe̱ ñánda kjoi̱í‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús nga tíhokóya ya̱ ndi̱tsin i̱ngo̱ ítjòn, kiì'nchré koni s'ín kitsò jñà xi̱ta̱. K'e̱é 'ñó kiìchja̱ kitsò: ―Jñò, yaxkoón‑ná; tíjiìn‑nò ñánda j'i̱‑na̱. Ta̱nga mìtsà tà kjo̱tsja ts'a̱n nga j'ia̱a. Jè xi kisìkasén‑na̱, jè‑né xi nguì kixi̱ kjoa̱ nga Nainá. Jñò, mìkiì yaxkon. ");
INSERT INTO maaNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ta̱nga 'a̱n, bexkon‑ná. I̱t'aà ts'e̱é inchrobà‑na̱ nga jè sobà kisìkasén‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ti̱jè‑ne hora jñà xi̱ta̱ mejèn‑la̱ nga tsobà'ñó Jesús ta̱nga ni̱jngoò xi kitsò ikon nga kitsobà'ñó, koi‑né nga kj'eè kì bijchó na̱chrjein‑la̱ nga ki̱yá. ");
INSERT INTO maaNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","'Ñó kjìn xi̱ta̱ kòkjeiín‑la̱ koni kitsò Jesús. Kitsò‑la̱ xíkjín: ―K'e̱ nga kjoi̱í Cristo, ¿a ìsa̱ kjiìn kjo̱xkón ndaà xi s'i̱in, koni jè xi̱ta̱ jè? Kixi̱í‑là kjoa̱, jè‑la xi Cristo. ");
INSERT INTO maaNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jñà xi̱ta̱ fariseo kiì'nchré koni s'ín nchijoó jñà xi̱ta̱ i̱t'aà ts'e̱ Jesús. Xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ fariseo kisìkasén xi̱ta̱ xi síkinda̱ i̱ngo̱ nga mejèn‑la̱ tso̱ba̱'ñó Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús kitsò‑la̱: ―'A̱n, tà chibaá na̱chrjein kóti̱jnako̱‑nò, i̱kjoàn kjín ìjngoò k'a‑na̱ ñánda tíjna xi kisìkasén‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jñò, ki̱nchátsji‑ná ta̱nga mìkiì sa̱kò‑nò nga mìkiì ko̱ma konguió ya̱ ñánda kóti̱jna. ");
INSERT INTO maaNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jñà xi̱ta̱ judío, tsibíts'ia̱ nga kiskònangui‑la̱ xíkjín kitsò: ―Xi̱ta̱ jè, ¿ñánda kjoi̱? ¿Mé‑ne nga mìkiì ko̱ma sa̱kò‑ná? ¿A ya̱á kji̱ko̱ xi̱ta̱ judío xinguia̱á xi xìn i̱'nde títsa̱jna nga jñà xi ta̱xki̱ xi̱ta̱ ko̱kòya‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Kó tsòya‑ne 'én xi béno̱jmí nga tsò: “Jñò, ki̱nchátsji‑ná ta̱nga mìkiì sa̱kò‑nò nga mìkiì ko̱ma konguió ya̱ ñánda kóti̱jna”? ");
INSERT INTO maaNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jè na̱chrjein xi fehet'aà‑ne s'eí, Jesús tsasíjna kixi̱, 'ñó kiìchja̱, kitsò: ―Tsà yá xi xíndá‑la̱ kàtjanchrobákon‑na, kàt'iì nandá. ");
INSERT INTO maaNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá nga tsò: Jè xi mokjeiín‑la̱ i̱t'aà ts'a̱n si̱jnajiìn ini̱ma̱‑la̱ koni jngoò xa̱jngá nandá xi mìkiì xìya xi síkíjnakon xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","K'e̱ nga o̱kitsò Jesús, i̱t'aà ts'e̱é Ini̱ma̱ Tsjeè‑la̱ Nainá kiìchja̱ nga i̱skan tjoé‑la̱ jñà xi̱ta̱ xi ko̱kjeiín‑la̱ i̱t'aà ts'e̱. Na̱chrjein jè, Ini̱ma̱ Tsjeè‑la̱ Nainá kj'eè kiì bitjojen nga kj'eè kiì fì‑ne ngajmiì Jesús nga jcha̱‑la̱ kjoa̱jeya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jñà xi̱ta̱, k'e̱ nga kiì'nchré 'én koi, tjín i'nga xi kitsò: ―Kixi̱í kjoa̱ xi̱ta̱ jè, jè‑né xi tjínè‑la̱ nga kjoi̱í nga ki̱chja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jñà xi̱ta̱ xi i'nga kitsò: ―Jè‑né xi Cristo xi xó kisìkasén‑ne Nainá. Ti̱koa̱á tjín i'nga xi kitsò: ―Majìn‑la nga jè Cristo, mìtsà nangui Galilea kjoi̱í‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Xo̱jo̱n‑la̱ Nainá k'oa̱á s'ín tíchja̱ nga jè Cristo, ya̱á kji̱nchrobàt'aà‑ne tje̱‑la̱ David, ya̱ na̱xa̱ndá Belén, i̱'nde‑la̱ David. ");
INSERT INTO maaNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","K'oa̱á s'ín komà‑ne nga kjòjòya jñà xi̱ta̱ xi kjoa̱ ts'e̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tjín i'nga xi̱ta̱ xi mejèn‑la̱ kitsobà'ñó nga kji̱ko̱ nda̱yá, ta̱nga ni̱jngoò xi kitsò ikon nga kitsobà'ñó. ");
INSERT INTO maaNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jñà xi̱ta̱ xi síkinda̱ i̱ngo̱, inchrobà‑ne ñánda títsa̱jna xi̱ta̱ fariseo ko̱ xi̱ta̱ sko̱‑la̱ no̱'miì, kitjànangui‑la̱, ki'mì‑la̱: ―¿Mé‑ne mìkiì kànchrobáko̱‑nò? ");
INSERT INTO maaNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jñà xi̱ta̱ xi síkinda̱ i̱ngo̱ kitsò: ―Ni̱ sa̱á jngoò xi̱ta̱ xi k'oa̱s'ín chja̱ koni s'ín chja̱ xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jñà xi̱ta̱ fariseo, kitsò: ―Jñò, ¿a ti̱koa̱á kachona̱cha̱án‑nò? ");
INSERT INTO maaNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿A k'oa̱á ti̱s'ín mokjeiín‑la̱ xi̱ta̱xá ítjòn tsa̱ján ko̱ xi̱ta̱ xinguia̱á fariseo? ");
INSERT INTO maaNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ta̱nga jñà xi̱ta̱ xi tíchona̱cha̱n‑la̱ nga mìkiì tíjiìn‑la̱ kjo̱tíxoma‑la̱ Moisés, tjínè‑la̱ nga kjo̱'in s'e̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo, jè xi xi̱ta̱ fariseo, xi jñò j'iìkon jngoò k'a Jesús, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Kjo̱tíxoma tsa̱ján, mìkiì tsjá'nde nga kjo̱'in k'oi̱‑la̱ xi̱ta̱, k'e̱ nga ti̱kj'eè kiì ndaà 'ya‑la̱ mé kjoa̱ xi tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Jñà xi̱ta̱ fariseo, kitsò‑la̱ Nicodemo: ―¿A ti̱koa̱á ya̱á nangui‑lè Galilea? Chíta'yì Xo̱jo̱n‑la̱ Nainá mé‑ne nga jcha̱‑ne ni̱ sà jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá f'iì‑ne Galilea. ");
INSERT INTO maaNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tà k'oa̱s'ín kitsjòya‑ne xi̱ta̱, xki̱ xi ján kiì‑ne ni'ya‑la̱ nga jngoò ìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ta̱nga Jesús, ján kiì ya̱ nindoò Yá Olivo. ");
INSERT INTO maaNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nga komà nchijòn ta̱jñòyaá j'iì‑ne ya̱ i̱ngo̱ ítjòn. Ngats'iì xi̱ta̱ j'iì tji̱ngui‑la̱ Jesús ñánda tíjna. K'e̱é tsibìjna nga tsakóya‑la̱ jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jñà xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés ko̱ xi̱ta̱ fariseo ijchòko̱ jngoò chjo̱ón xi ki'yat'in‑la̱ nga kjoa̱ chijngui tís'ín. Tsasíjna osen ñánda títsa̱jna ngats'iì xi̱ta̱; ");
INSERT INTO maaNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jñà xi̱ta̱ koi kitsò‑la̱ Jesús: ―Maestro, chjo̱ón jè, ndaà kà'yat'in‑la̱ nga kjoa̱ chijngui tís'ín. ");
INSERT INTO maaNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Jè kjo̱tíxoma‑la̱ Moisés, k'oa̱á s'ín tíchja̱ nga jñà íchjín xi k'oa̱ tjín kjoa̱ xi ótsji nda̱jo̱ó ki̱yá‑ne. Ngaji̱, ¿kó si? ");
INSERT INTO maaNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jñà xi̱ta̱ koi, koií k'oa̱s'ín kitsò‑la̱ Jesús nga mejèn‑la̱ skót'aà, mé‑ne ko̱ma ko̱hòngui‑ne i̱t'aà ts'e̱ xi̱ta̱xá. Ta̱nga Jesús, tsasìñiat'aà nangui nga kiskiìjno‑ne ko̱ jnótsja i̱t'aà nangui. ");
INSERT INTO maaNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Xi̱ta̱ koi nga siì nchis'ín nga kjònangui, Jesús tsasíjna kixi̱ kitsò‑la̱: ―Jñò, tsà tjín i'nga xi̱ta̱ xinguio̱o xi tsjìn‑la̱ jé, jè kàtínè ítjòn nda̱jo̱ chjo̱ón jè. ");
INSERT INTO maaNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jesús ìjngoò k'a tsasìñia nga kiskiìjno ìsa̱ i̱t'aà nangui. ");
INSERT INTO maaNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jñà xi̱ta̱ koi, k'e̱ nga kiì'nchré koni s'ín kitsò Jesús, tà íjngó íjngó kiì‑ne, nga kijtseè nga mìkiì ndaà tjín kjo̱hítsjeèn xi kiìchja̱, tsibíts'ia̱‑ne xi xi̱ta̱ jchínga, i̱kjoàn kiì‑ne i̱xti. Tà jè ta̱jngoò Jesús ko̱ chjo̱ón tsibìtsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesús tsasíjna kixi̱‑ne, kijtseè nga mì ti̱ yá xi̱ta̱ tjín‑ne. Ta̱ jè ta̱jngoò chjo̱ón síjna. K'e̱é kitsò‑la̱: ―¿Ñánda títsa̱jna xi̱ta̱ xi óngui‑lè? ¿A ni̱jngoò xi kòhónè‑lè kjo̱'in? ");
INSERT INTO maaNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jè chjo̱ón kitsò: ―Na̱'èn, ni̱yá‑jèn. Jesús kitsò‑la̱: ―Ti̱koa̱á 'a̱n, mìkiì kìnè‑lè kjo̱'in. T'in‑ne ni'ya‑lè; kì ti̱ jé binchaàtsji‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús, ìjngoò k'a kiìchja̱jiìn‑la̱ jñà xi̱ta̱, kitsò‑la̱: ―'A̱n‑ná ni'ín xi síhiseèn‑la̱ i̱sò'nde. Jè xi 'a̱n fìt'aà‑na s'e̱é‑la̱ ni'ín xi tsjá kjoa̱binachon. Mì ti̱ kiì ya̱ ko̱jmejiìn‑ne kjoa̱jñò. ");
INSERT INTO maaNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jñà xi̱ta̱ fariseo kitsò: ―Ti ji̱í tì'biì‑ne 'én i̱t'aà tsi̱ji. 'Én xi nokjoì, ni̱mé chjí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús kiìchja̱ kitsò‑la̱: ―'Én xi chjà, chjí‑la̱‑né, na̱s'ín ti̱'a̱n tsjaà‑na 'én xi i̱t'aà ts'a̱n. Nga be‑ná ñánda j'i̱‑na ko̱ ñánda tìfia. Ta̱nga jñò mìkiì 'yaà ñánda j'i̱‑na ko̱ ñánda tìfia. ");
INSERT INTO maaNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jñò, tà kjo̱hítsjeèn ts'e̱ xi̱ta̱á nìkjeén k'e̱ nga jé bìnè‑ná. Ta̱nga 'a̱n ni̱jngoò xi̱ta̱ bìnè‑la̱ jé. ");
INSERT INTO maaNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ta̱nga 'a̱n, tsà yá xi̱ta̱ xi konè‑la̱ jé, kjoa̱kixi̱í xi s'iaàn. Nga mìtsà ta̱jngoò bìndaàjiaàn, ko̱ó Na̱'èn‑na̱ xi kisìkasén‑na̱ bíndaàjiìn‑ko̱‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kjo̱tíxoma tsa̱jòn k'oa̱s'ín tíchja̱ nga tsò: K'e̱ nga tsà jò ma‑ne xi̱ta̱ xi tsjá 'én, tsà ngásòn tsò ingajò, kixi̱í kjoa̱, chjí‑la̱ né. ");
INSERT INTO maaNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ti̱'a̱án‑na̱ xi tsjaà 'én i̱t'aà ts'a̱n. Ko̱ ti̱koa̱á jè Na̱'èn‑na̱ xi kisìkasén‑na̱ tsjá 'én i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jñà xi̱ta̱ fariseo, kiskònangui‑la̱ kitsò‑la̱: ―¿Ñánda tíjna Na̱'èn‑lè? Kiìchja̱ Jesús, kitsò‑la̱: ―Jñò, 'a̱n, mìkiì yaxkon‑ná, ni̱ jè Na̱'èn‑na̱ mìkiì yaxkon. 'A̱n, tsà yaxkon‑ná ti̱koa̱á jcha̱xkon‑nò Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","K'e̱ nga tsakóya jñà 'én koi Jesús, ya̱á tíjna ya̱ i̱ngo̱ ítjòn ya̱ chrañàt'aà‑la̱ i̱'nde ñánda maxkón to̱n kjo̱tjò. Ni̱jngoò xi̱ta̱ xi kitsò ikon nga kitsobà'ñó Jesús nga kj'eè kiì bijchó na̱chrjein‑la̱ nga ki̱yá. ");
INSERT INTO maaNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús ìjngoò k'a kitsò‑la̱: ―'A̱n, tìfi‑ná. Jñò, ki̱nchátsji‑ná. Ta̱nga jñò ya̱á ki̱yájñoò jé‑nò. Ya̱ ñánda 'a̱n tìfia, jñò mìkiì ko̱ma konguió. ");
INSERT INTO maaNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jñà xi̱ta̱ judío kitsò‑la̱ xíkjín: ―¿A ti̱jè si̱ìk'en‑ne yijo‑la̱? ¿Mé‑ne k'oa̱ tsò‑ne, nga tsò: Ya̱ ñánda 'a̱n tìfia, jñò mìkiì ko̱ma konguió? ");
INSERT INTO maaNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús kitsò‑la̱: ―Jñò, i̱í i̱t'aà nangui tsa̱jòn, ta̱nga 'a̱n ján ngajmiì ts'a̱n. Jñò, i̱í i̱'nde‑nò i̱sò'nde, 'a̱n, mìtsà i̱sò'nde i̱'nde‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Koií k'oa̱s'ín kixan‑nò nga ya̱ ki̱yájñoò jé‑nò nga mìkiì mokjeiín‑nò nga 'a̱n‑ná (xi Cristo). Koií kjoa̱‑la̱ nga ki̱yájñoò jé‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Xi̱ta̱ judío, kiskònangui‑la̱, kitsò‑la̱: ―¿Yá‑ne ngaji̱? Jesús kiìchja̱, kitsò‑la̱: ―Jyeé o̱kixan‑nò nga sa̱ ítjòn yá‑ná 'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","I̱t'aà tsa̱jòn, kjín kjoa̱ tjín ìsa̱ xi 'a̱n kèno̱jmí‑nò, ko̱ xi 'a̱n kìndaàjiìn‑ko̱‑nò. Jè xi kisìkasén‑na nguì 'én kixi̱í xi chja̱. Koni s'ín ki'nchrè‑la̱, k'oa̱á tjín 'én xi 'a̱n chjàjiìn‑la̱ jñà xi̱ta̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ta̱nga jñà xi̱ta̱ judío mìkiì kjòchi̱ya‑la̱ tsà i̱t'aà ts'e̱ Na̱'èn‑ná xi Nainá tíchja̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesús kitsò‑la̱: ―Jñò, k'e̱ nga chjímiì'nga‑ná 'a̱n xi Ki'ndí‑la̱ Xi̱ta̱ xan‑la̱ yijo‑na̱, k'e̱é ko̱chi̱ya‑nò nga 'a̱n‑ná xi Cristo. Ni̱mé kjoa̱ xi s'iaàn xi ta̱ kjo̱hítsjeèn ts'a̱n. K'oa̱s'ín chjà koni s'ín tsakóya‑na xi Na̱'èn ma. ");
INSERT INTO maaNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Jè xi kisìkasén‑na i̱í tíjnako̱‑na. Mìkiì síkíjna ta̱jngoò‑na Na̱'èn‑na̱. Koií kjoa̱‑la̱ nga kjit'aà na̱chrjein sìkitasoàn koni s'ín sasén‑la̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús, k'e̱ nga kiìchja̱ 'én koi, kjìn jchán xi̱ta̱ kòkjeiín‑la̱ i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús kitsò‑la̱ jñà xi̱ta̱ judío xi kòkjeiín‑la̱ i̱t'aà ts'e̱: ―Tsà kixi̱ si̱kitasòn 'én‑na̱ xi okoòya‑nò, jñò‑nò xi nguì kixi̱ kjoa̱ nga 'a̱n kota'yàt'aà‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jcha̱xkoòn xi kjoa̱ kixi̱, koa̱ jè kjoa̱ kixi̱ si̱ìkítsa̱jnandei̱í‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kiìchja̱ xi̱ta̱ judío, kitsò: ―Ngaje̱n, xi̱ta̱ tje̱‑la̱ Abraham‑náje̱n. Ni̱ sa̱á jngoò xi̱ta̱ xi kj'ei̱í síkítsa̱jna'ñó‑naje̱n. Ngaji̱, ¿mé‑ne k'oa̱ si‑ne nga ki̱tsa̱jnandei̱í‑naje̱n? ");
INSERT INTO maaNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús kitsò‑la̱: ―Nguì kjoa̱ kixi̱í xi xan‑nò, ngats'iì xi̱ta̱ xi jé ótsji, ya̱á títsa̱jna'ñó i̱t'aà ts'e̱ jé‑la̱, k'oa̱á ngaya‑la̱ koni jngoò xi̱ta̱ chi̱'nda xi tíjna'ñó‑la̱ nei‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jngoò xi̱ta̱ xi chi̱'nda tíjna, mìkiì tjí'nde‑la̱ nga ya̱ kíjna kjit'aà ya̱ ni'ya ñánda síxá. Ta̱nga jngoò xi ki'ndí ma, tjí'ndeé‑la̱ nga kjit'aà na̱chrjein ya̱ kíjna ya̱ ni'ya‑la̱ na̱'èn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","K'oa̱á ma‑ne, tsà jè Ki'ndí‑la̱ Nainá si̱ìkíjnandei̱í‑nò, nguì kixi̱í kjoa̱ nga jñò, ki̱tsa̱jnandei̱í‑nó. ");
INSERT INTO maaNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","'A̱n, be‑ná nga tje̱‑la̱ Abraham‑nò; ta̱nga jñò mejèn‑nò nga si̱k'en‑ná, koi‑né nga mìkiì mokjeiín‑nò 'én‑na̱ xi chjà. ");
INSERT INTO maaNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","'A̱n, k'oa̱á s'ín chjà koni s'ín tjín xi kìjtseè k'e̱ nga ti̱sa̱ tìjna̱koa̱a Na̱'èn‑na̱. Jñò, k'oa̱á ti̱s'ín 'nè koni s'ín kina'yà‑là na̱'èn‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jñà xi̱ta̱ judío kitsò: ―Jè tje̱‑na̱je̱n, ya̱á inchrobàt'aà‑ne ts'e̱ Abraham. Jè na̱'èn‑jchá kjiìn‑naje̱n. Jesús kiìchja̱ kitsò‑la̱: ―Tsà kixi̱ kjoa̱ nga i̱xti‑la̱ Abraham 'mì‑nò, k'oa̱á s'ín s'e̱en koni s'ín kis'iìn Abraham. ");
INSERT INTO maaNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","'A̱n, na̱s'ín jye k'oa̱s'ín tsibeno̱jmí kixi̱‑nò, nga Nainá kitsjaà‑na 'én xi chjà, jñò mejèn‑nò nga si̱k'en‑ná. Abraham mì k'oa̱á kis'iìn. ");
INSERT INTO maaNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jñò, k'oa̱s'ín 'nè koni s'ín na̱'èn‑nò. Jñà xi̱ta̱ judío kitsò: ―Ngaje̱n, mìtsà kjoa̱ chijngui kits'iìn‑jiìn‑je̱n. Ta̱jngoò jè Na̱'èn‑naje̱n, jè Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús kiìchja̱, kitsò‑la̱: ―Tsà kixi̱ kjoa̱ nga jè na̱'èn‑nò Nainá, 'a̱n tjòchaá‑la s'e̱n‑ná nga i̱t'aà ts'e̱ Nainá inchrobà‑na; mìtsà tà kjo̱tsja ts'a̱n nga j'ia̱a; Nainá kisìkasén‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Mé‑ne mìkiì machi̱ya‑nò 'én‑na̱ xi chjàko̱‑nò? Koií‑né nga mìkiì ma‑nò na'yàñijon. ");
INSERT INTO maaNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Na̱'èn‑nò, jè xi̱ta̱ nei̱í, jè nokjoà‑nò. K'oa̱á s'ín 'nè koni s'ín mejèn‑la̱ na̱'èn‑nò. Jè xi ma‑la̱ sík'en xi̱ta̱ kóni nga ti̱sa̱ tàts'en‑la̱ kjoa̱. Mìtsà kjoa̱ kixi̱ s'ín nga tsjìn‑la̱ kjoa̱ kixi̱. K'e̱ nga chja̱ 'én ndiso, k'oa̱á tsò koni s'ín tjín ini̱ma̱‑la̱ nga nguì xi̱ta̱ ndiso‑né. Jè na̱'èn‑la̱ ts'e̱ 'én ndiso. ");
INSERT INTO maaNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ta̱nga 'a̱n, 'én kixi̱ beno̱jmí‑nò; koií kjoa̱‑la̱ jñò, mìkiì mokjeiín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Yá xi̱ta̱ xinguio̱o xi ko̱ma‑la̱ ko̱kò mé jé xi tjín‑na? K'e̱ nga chjàko̱‑nò, nguì 'én kixi̱ chjà, ko̱ ¿mé‑ne mìkiì mokjeiín‑nò? ");
INSERT INTO maaNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jè xi xi̱ta̱‑la̱ Nainá, 'én‑la̱ Nainá 'nchré. Ta̱nga jñò, nga mìkiì na'yà, koií‑né nga mìtsà xi̱ta̱‑la̱ Nainá 'mì‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jñà xi̱ta̱ judío kiìchja̱, kitsò‑la̱ Jesús: ―Ngaje̱n, koií kjoa̱‑la̱ k'oa̱s'ín 'mì‑lèje̱n: ji̱, xi̱ta̱ Samaria‑né, ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Kiìchja̱ Jesús kitsò‑la̱: ―'A̱n, mìtsà ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑na̱. Jè kjoa̱ xi tìs'iaàn, jè‑né nga bexkoán Na̱'èn‑na̱. Ta̱nga jñò mìkiì yaxkón‑ná. Tà sa̱á nachrjengui‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mìtsà jè kjoa̱ tìhotsjià nga jeya siìkíjna yijo‑na̱. Tíjna jngoò xi tíkosòn‑la̱, jè‑né xi jeya síkíjna‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nguì 'én kixi̱ xi chjàko̱‑nò, jè xi síkitasòn 'én‑na̱ koni s'ín xan‑nò, mìkiì ki̱yá ni̱ta̱ kjé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Xi̱ta̱ judío kiìchja̱, kitsò: ―I̱'ndei̱ jyeé 'ya‑je̱n nga ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑lè. Abraham ko̱ ngats'iì xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá kjòtseé, k'en‑né. Ta̱nga ji̱ si‑né: “Jè xi síkitasòn 'én‑na̱ koni s'ín xan‑nò, mìkiì ki̱yá.” ");
INSERT INTO maaNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ngaji̱, ¿a ìsa̱ tíjna ítjoìn a mì k'oa̱‑ne koni jè Na̱'èn‑na̱je̱n Abraham? K'en‑né. Ko̱ ngats'iì xi̱ta̱ xi kiìchja̱ya ngajo‑la̱ Nainá ti̱koa̱á k'en‑né. ¿Yá‑ne ji̱ nga ti̱ji̱ ti̱nachrjeè jeya‑ne yijo‑lè? ");
INSERT INTO maaNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Kiìchja̱ Jesús kitsò‑la̱: ―Tsà ti̱'a̱n jeya síkíjna‑na yijo‑na̱, nìmé chjí‑la̱. Jè xi jeya síkíjna‑na, jè Na̱'èn‑na̱ xi Nainá 'mì‑là. ");
INSERT INTO maaNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Jñò mìkiì yaxkon Nainá, ta̱nga 'a̱n beèxkon‑ná. Tsà xán‑nò mìkiì bexkoan, xi̱ta̱ ndiso ko̱ma koni jñò nga xi̱ta̱ ndiso‑nò. 'A̱n, bexkon‑ná koa̱ sìkitasòn‑ná 'én‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Xi̱ta̱ jchínga‑nò Abraham, tsjaá komà‑la̱ nga mejèn‑la̱ skoe̱xkon na̱chrjein‑na̱ nga j'ia̱a. K'e̱ nga kijtseè na̱chrjein‑na̱ ìsa̱ 'ñó ndaà kjòtsja‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jñà xi̱ta̱ judío kitsò‑la̱: ―Skanda kj'eè tjín‑lè icháte nó. ¿Kós'ín komà‑ne nga kiyaxkoin Abraham? ");
INSERT INTO maaNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús kiìchja̱ kitsò‑la̱: ―Nguì kixi̱ kjoa̱ xi xan‑nò, 'A̱n‑ná xi ìsa̱ kjòtseé tìjna̱a koni jè Abraham. ");
INSERT INTO maaNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jñà xi̱ta̱ judío, kiskoé nda̱jo̱ nga mejèn‑la̱ ko̱sèn‑la̱ Jesús. Ta̱nga Jesús tsibìjna'ma, itjo‑ne ndi̱tsin i̱ngo̱, jahajiìn osen‑la̱ xi̱ta̱, i̱kjoàn kiì. ");
INSERT INTO maaNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús k'e̱ nga tífì ya̱ ndi̱yá, kijtseè jngoò xi̱ta̱ xi mìkiì tsejèn‑la̱ xi xó k'oa̱s'ín kits'iìn‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kiskònangui‑la̱ kitsò‑la̱: ―Maestro, xi̱ta̱ jè, ¿mé‑ne k'oa̱s'ín kits'iìn‑ne? ¿Yá xi tsohótsji jé? ¿A jñà xi̱ta̱ jchínga‑la̱, o xi jè xi̱ta̱ xi mìkiì tsejèn‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Kiìchja̱ Jesús kitsò‑la̱: ―Mìtsà jè xi̱ta̱ xi mìkiì tsejèn‑la̱ tjín‑la̱ jé, ni̱ mìtsà jñà xi̱ta̱ jchínga‑la̱ tsohótsji jé. Koií‑né nga i̱t'aà ts'e̱ xi̱ta̱ koi jcha̱‑la̱ kjo̱xkón‑ndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mochjeén‑né nga siìkitasoàn kjo̱xkón‑ndaà‑la̱ jè xi kisìkasén‑na̱ nga na̱chrjein ìsa̱. Ki̱jchò na̱chrjein k'e̱ nga ko̱jñò; ni̱ ti̱ jngoò‑ne xi ko̱ma si̱ìxá. ");
INSERT INTO maaNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","K'e̱ tákó i̱ tìjna̱a ìsa̱ i̱sò'nde, 'a̱n‑ná ni'ín xi sìhiseèn‑la̱ xi̱ta̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","K'e̱ nga jye o̱kitsò, tsibíchrá i̱t'aà nangui. Jè ndána̱chrá‑la̱ tsibíndaà‑ne ndási, i̱kjoàn kisìkaàjno xko̱n jè xi̱ta̱ xi mìkiì tsejèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","I̱kjoàn kitsò‑la̱: ―T'in, kaníkjoiìn ya̱ chrjó nandá Siloé (jè 'én xi tsòya‑ne, jè xi kinìkasén). Jè xi̱ta̱ xi mìkiì tsejèn‑la̱ kiì kaníkjoa̱n, k'e̱ nga inchrobà‑ne jye tsejèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jñà xi̱ta̱ i̱ndiì ni'ya‑la̱ jè xi̱ta̱ xi mìkiì tsejèn‑la̱, ko̱ jñà xi̱ta̱ xi jye kjòtseé beèxkon nga to̱n síjé kjo̱tjò, kitsò‑la̱ xíkjín: ―¿A mìtsà jè xi̱ta̱ jè xi bìjna nga síjé kjo̱tjò to̱n? ");
INSERT INTO maaNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tjín i'nga xi̱ta̱ xi tsò: ―Jè‑né. Koa̱ jñà xi̱ta̱ xi i'nga kitsò: ―Kjo̱meè k'oa̱á kji, ta̱nga mìtsà jè. K'e̱é kiìchja̱ xi̱ta̱ xi mìkiì tsejèn‑la̱ nga sa̱ ítjòn, kitsò: ―'A̱n‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jñà xi̱ta̱ kiskònangui‑la̱ kitsò‑la̱: ―¿Kós'ín komà nga kitáx'a̱‑ne xkoiìn? ");
INSERT INTO maaNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Xi̱ta̱ jè kitsò: ―Jè xi̱ta̱ xi 'mì Jesús, kisindaà ndási, kisìkaàjno xkoaàn, i̱kjoàn kitsò‑na̱: “T'in, kaníkjoiìn ya̱ chrjó nandá Siloé.” 'A̱n, kiaà, k'e̱ nga jye tsaníkjoaàn, komà kotsejèn‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Jñà xi̱ta̱ koi kiskònangui‑la̱ kitsò‑la̱: ―Xi̱ta̱ jè, ¿ñánda tíjna? Jè xi̱ta̱ xi jye kjòndaà‑ne, kitsò: ―Mìkiì be ñánda tíjna. ");
INSERT INTO maaNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jè xi̱ta̱ xi mìkiì tsejèn‑la̱ nga jye kjòndaà‑ne kiìko̱ ñánda títsa̱jna xi̱ta̱ fariseo, ");
INSERT INTO maaNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","koií kjoa̱‑la̱ nga na̱chrjein nìkjáya‑né k'e̱ nga tsibíndaà ndási Jesús nga kisìkaàjno xko̱n jè xi̱ta̱ xi mìkiì tsejèn‑la̱ mé‑ne ko̱ma kitáx'a̱‑ne xko̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jñà xi̱ta̱ fariseo ìjngoò k'a kiskònangui‑la̱ jè xi̱ta̱ xi mìkiì tsejèn‑la̱ xi jye kjòndaà‑ne, kitsò‑la̱: ―¿Kós'ín komà nga kitáx'a̱‑ne xkoiìn? Xi̱ta̱ jè kitsò: ―Ndásií kisìkaàjno xkoaàn; i̱kjoàn tsanìkjoàn; i̱'ndei̱ jyeé tsejèn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tjín i'nga xi̱ta̱ fariseo xi kitsò: ―Xi̱ta̱ jè, mì‑la tsà Nainá kisìkasén nga mìkiì beèxkón na̱chrjein nìkjáya. Ti̱koa̱ tjín i'nga xi kitsò: ―¿Kós'ín ma‑ne nga ma‑la̱ s'ín kjo̱xkón xi ndaà tjín tsà xi̱ta̱ jé‑né? I̱kjoàn kjòjòya xi ti̱jñà‑ne xi̱ta̱ fariseo; mìkiì kjòngásòn kjo̱hítsjeèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ìjngoò k'a kitjànangui‑la̱ jè xi̱ta̱ xi mìkiì tsejèn‑la̱ xi jye kjòndaà‑ne, kitsò‑la̱: ―Ngaji̱, ¿kó si, yá xi̱ta̱‑ne xi kiskíx'a̱‑ne xkoiìn? Xi̱ta̱ jè kitsò: ―Jngoò xi̱ta̱ xi chja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ta̱nga jñà xi̱ta̱ judío, mìkiì kòkjeiín‑la̱ tsà kixi̱ kjoa̱ nga jè xi̱ta̱ xi mìkiì tsejèn‑la̱ nga k'oa̱s'ín kits'iìn koa̱ i̱'ndei̱ jyeé tsejèn‑la̱. K'e̱é kiìchja̱‑la̱ jñà xi̱ta̱ jchínga‑la̱, ");
INSERT INTO maaNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","kiskònangui‑la̱ kitsò‑la̱: ―Jè xi̱ta̱ jè, ¿a ki'ndí‑nò ma? ¿A kixi̱í kjoa̱ nga mìkiì tsejèn‑la̱ k'e̱ nga sa̱ kits'iìn? ¿Kó ma‑ne nga tsejèn‑la̱ i̱'ndei̱? ");
INSERT INTO maaNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jñà xi̱ta̱ jchínga‑la̱ kitsò: ―'Ya‑náje̱n nga ki'ndí‑naje̱n ma. Kixi̱í kjoa̱ nga mìkiì tsejèn‑la̱ k'e̱ nga sa̱ kits'iìn. ");
INSERT INTO maaNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ta̱nga mìkiì 'ya‑je̱n mé‑ne nga ma tsejèn‑la̱ i̱'ndei̱, ti̱koa̱á mìkiì 'ya‑je̱n yá‑né xi kiskíx'a̱‑ne xko̱n. Jè sobà chji̱nangui‑là, jè kàtèno̱jmí‑nò, nga jyeé xi̱ta̱ jchínga. ");
INSERT INTO maaNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jñà xi̱ta̱ jchínga‑la̱ koií k'oa̱s'ín kitsò‑ne nga jñà tsakjón‑la̱ xi̱ta̱ judío. Jñà xi̱ta̱ judío jyeé k'oa̱s'ín tsajoóya‑ne nga jngoò k'aá ki̱tjokàjiìn ya̱ ni'ya i̱ngo̱ sinagoga, tsà yá xi̱ta̱ xi ki̱tso̱ nga jè Jesús jè xi Cristo xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Koií k'oa̱ ti̱s'ín kitsò‑ne jñà xi̱ta̱ jchínga‑la̱, nga kitsò: “Jè sobà chji̱nangui‑là, nga jyeé xi̱ta̱ jchínga‑né.” ");
INSERT INTO maaNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jñà xi̱ta̱ judío ìjngoò k'a kiìchja̱‑la̱ jè xi̱ta̱ xi mìkiì tsejèn‑la̱, kitsò‑la̱: ―Tèno̱jmí kixi̱‑náje̱n nga nguixko̱n Nainá. Ngaje̱n 'ya‑náje̱n nga jè xi̱ta̱ jè, xi̱ta̱ jé‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jè xi̱ta̱ xi mìkiì tsejèn‑la̱ xi jye kjòndaà‑ne kiìchja̱, kitsò: ―'A̱n, mìkiì be tsà xi̱ta̱ jé‑né. Tà jè xi be, k'e̱ nga sa̱ kits'ian mìkiì tsejèn‑na, ta̱nga i̱'ndei̱ jyeé tsejèn‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ìjngoò k'a kitsò‑la̱: ―¿Mé xi kisìko̱‑lè? ¿Kó s'ín kisìko̱‑lè nga kitáx'a̱‑ne xkoiìn? ");
INSERT INTO maaNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jè xi̱ta̱ xi mìkiì tsejèn‑la̱ kitsò: ―Jyeé koa̱ kàxan‑nò, ta̱nga jñò mìkiì na'yà. ¿Mé‑ne mejèn‑nò nga ìjngoò k'a k'oa̱ xán‑nò? ¿A ti̱koa̱á mejèn‑nò nga xi̱ta̱‑la̱ ko̱ma nga ya̱ chíta'yàt'aà‑là? ");
INSERT INTO maaNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Jñà xi̱ta̱ judío k'e̱ nga k'oa̱ ki'mì‑la̱, kòjti‑la̱, kiìchja̱jno‑la̱ jè xi̱ta̱ xi mìkiì tsejèn‑la̱, kitsò‑la̱: ―Ji̱‑né xi̱ta̱ xi ya̱ chìta'yàt'aà‑la̱. Ta̱nga ngaje̱n ya̱á chìta'yàt'aà‑la̱je̱n Moisés. ");
INSERT INTO maaNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","'Ya‑náje̱n nga jè sobà Nainá kiìchja̱ko̱ Moisés. Ta̱nga jè xi̱ta̱ jè mìkiì 'ya‑je̱n ñánda j'iì‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jè xi̱ta̱ xi mìkiì tsejèn‑la̱ kitsò: ―Kjoa̱ jè, tà maxkón‑ná nga jñò, mìkiì 'ya ñánda j'iì‑ne xi̱ta̱ jè, ta̱nga 'a̱n be‑ná nga jè kiskíx'a̱‑ne xkoaàn. ");
INSERT INTO maaNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","'Yaà‑ná jñà xi̱ta̱ xi tjín‑la̱ jé, mìkiì 'nchré‑la̱ Nainá. Ta̱nga jñà xi̱ta̱ xi tsakjón‑keè Nainá ti̱koa̱ síkitasòn koni s'ín mejèn‑la̱, jñà‑né xi 'nchré‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kóni nga ti̱sa̱ kjòtseé, ni̱ sa̱á jngoò xi̱ta̱ na'yà‑la̱ xi ma‑la̱ kíx'a̱‑ne xko̱n jngoò xi̱ta̱ xi mìkiì tsejèn‑la̱ k'e̱ nga k'oa̱s'ín kits'iìn. ");
INSERT INTO maaNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Xi̱ta̱ jè, tsà mìtsà Nainá kisìkasén, ni̱mé xi ko̱ma‑la̱ nga k'oa̱s'ín s'i̱in. ");
INSERT INTO maaNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jñà xi̱ta̱ judío kitsò‑la̱ jè xi̱ta̱ xi mìkiì tsejèn‑la̱: ―Ngaji̱ xi ta̱xki̱ 'ñó tse jé tjín‑lè, ¿a ji̱í mejèn‑lè ko̱kóya‑naje̱n? I̱kjoàn tsachrje ni'ya i̱ngo̱ sinagoga. ");
INSERT INTO maaNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús kiì'nchré nga jè xi̱ta̱ jè kinachrjekàjiìn ya̱ ni'ya i̱ngo̱ sinagoga. K'e̱ nga kisatiìkjoò ìjngoò k'a, kiskònangui‑la̱ kitsò‑la̱: ―Ji̱, ¿a mokjeiín‑lè i̱t'aà ts'e̱ xi Ki'ndí‑la̱ Xi̱ta̱ tsò‑la̱ yijo‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Xi̱ta̱ jè kitsò: ―Na̱'èn, koa̱tìn‑ná yá‑né, mé‑ne nga ko̱kjeiín‑na i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús kitsò‑la̱: ―Jyeé ki'yi, 'a̱n‑ná xi tìchjàko̱‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Xi̱ta̱ jè tsasìjna xkó'nchit'aà‑la̱ Jesús nga kijtseèxkón, kitsò‑la̱: ―Na̱'èn mokjeiín‑na̱ i̱t'aà tsi̱ji. ");
INSERT INTO maaNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","I̱kjoàn kitsò Jesús: ―'A̱n, koií xá j'i̱‑na̱ i̱ i̱sò'nde; nga 'a̱n skosòn‑la̱ mé‑ne jñà xi̱ta̱ xi mìkiì tsejèn‑la̱ ko̱tsejèn ìjngoò k'a‑la̱, koa̱ jñà xi tsejèn‑la̱ mìkiì ko̱tsejèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tjín i'nga xi̱ta̱ fariseo xi ya̱ títsa̱jnako̱ Jesús, k'e̱ nga kiì'nchré 'én koi, kiskònangui‑la̱ kitsò‑la̱: ―Ngaje̱n, ¿a ti̱koa̱á mìkiì tsejèn‑naje̱n? ");
INSERT INTO maaNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús kiìchja̱ kitsò‑la̱: ―Jñò, tsà mìkiì tsejèn‑nò, tsjìn‑nò jé. Ta̱nga bixón‑nò: “Tsejèn‑naje̱n”, k'oa̱á ma‑ne nga ya̱ tjínè‑nò jé‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Nguì kjoa̱ kixi̱í xi xan‑nò, jè xi̱ta̱ xi mìtsà ya̱ fahas'en‑ne xotjoa̱‑la̱ ínchíbá‑la̱ orrè, xi xìn fahas'en‑kjá‑ne, xi̱ta̱ chijé‑né, jè xi̱ta̱ xi fìko̱ chijé cho̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ta̱nga jè xi ya̱ fahas'en‑ne xotjoa̱‑la̱ ínchíbá, jè‑né xi paxtò, xi síkinda̱ orrè. ");
INSERT INTO maaNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jè xi síkinda̱ xotjoa̱‑la̱ ínchíbá, jé kíx'a̱‑la̱. Jè xi paxtò, chja̱ 'ín‑la̱ nga jngoò ìjngoò orrè, ko̱ jñà orrè 'nchréjta‑la̱ nei‑la̱. I̱kjoàn ochrje ínchíbá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","K'e̱ nga jye bitjo yije ínchíbá‑la̱ jñà orrè, jè paxtò fìko̱ nga 'nchréjtaá‑la̱ nga jè nei‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ta̱nga jngoò xi̱ta̱ xi kj'ei̱í, mìkiì kji̱tji̱ngui‑la̱ nga mìkiì beèxkon. Ta̱ sa̱á ta ko̱ngaá‑la̱ nga mìkiì 'nchré jta̱‑la̱ xi̱ta̱ xi kj'ei̱í. ");
INSERT INTO maaNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús k'oa̱á tsò kjoa̱ xi mangásòn xi tsibéno̱jmí‑la̱. Ta̱nga jñà xi̱ta̱ koi mìkiì kjòchi̱ya‑la̱ kó tsòya‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús, ìjngoò k'a kitsò‑la̱: ―Xi nguì o̱kixi̱ k'oa̱á xán‑nò. 'A̱n‑ná xotjoa̱‑la̱ ínchíbá ñánda fahas'en‑ne jñà orrè. ");
INSERT INTO maaNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ngats'iì jñà xi j'iì ítjòn‑na, sa̱ xi̱ta̱ chijé‑né, jñà xi fìko̱ chijé cho̱. Jñà orrè mìkiì kiì'nchréñijon‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","'A̱n‑ná xi xotjoa̱; jè xi i̱t'aà ts'a̱n kjoa̱has'en, ki̱tjokàjiín kjo̱'in kjoa̱ ts'e̱ jé‑la̱. K'oa̱s'ín ngaya‑la̱ koni s'ín orrè nga fahas'en ínchíbá‑la̱ ko̱ bitjo ko̱ sakó‑la̱ ijñá xi kjèn. ");
INSERT INTO maaNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Jè xi̱ta̱ chijé tà f'iì síchijé‑né, f'iì sík'en‑né, f'iì síkjehesòn‑ne. Ta̱nga 'a̱n, koií xá j'i̱‑na nga kàtas'e‑nò kjoa̱binachon ni̱ta̱ kjé‑ne, nga ni̱mé chijat'aà‑nò nga nguì ndaà kàtas'e‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","'A̱n‑ná xi paxtò xi ndaà ko'ndà orrè. Jè paxtò xi ndaà ko'ndà orrè, jè xi tjíjngoò ikon nga ki̱yátjì jñà orrè. ");
INSERT INTO maaNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jè xi̱ta̱ xi tà chi̱'nda tíjna nga ko'ndà orrè, k'e̱ nga beè nga nchrobá chrañà tse̱jén, síkítsa̱jna jñà orrè, i̱kjoàn onga. Koií k'oa̱s'ín‑ne nga mìtsà jè paxtò xi ko'ndà, ti̱koa̱ mìtsà jè nei‑la̱ orrè. I̱kjoàn matsja‑la̱ jè tse̱jén nga tsobà'ñó jñà orrè, xki̱ xi ján sítsjòya jñà orrè xi i'nga. ");
INSERT INTO maaNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jè xi̱ta̱ xi chi̱'nda tíjna tà onga‑né; koií k'oa̱s'ín‑ne nga nìmé kinda̱‑la̱. Tà jè síkinda̱ chjí‑la̱ mìtsà jñà orrè síkinda̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’'A̱n‑ná paxtò xi ndaà ko'ndà orrè; koni s'ín beèxkon‑na Na̱'èn‑na̱, ti̱koa̱ 'a̱n bexkoan Na̱'èn‑na̱, k'oa̱á ti̱s'ín beèxkon‑ná orrè‑na̱ kó kjoàn, ko̱ jñà orrè beèxkoòn‑na nga ts'a̱n. 'A̱n tíjngoò takoàn nga ki̱yátjià jñà orrè‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ti̱koa̱ tjín‑ìsa‑na xi kj'ei̱í orrè, jñà xi mìtsà i̱ títsa̱jnaya ínchíbá jè. Ti̱koa̱á mochjeén‑né nga kji̱nchrobàkon‑na mé‑ne nga kji̱'nchréñijon‑na ti̱koa̱ si̱kitasòn‑na. Jngoò ínchíbá ko̱ma‑ne ko̱ jngoò ko̱ma paxtò xi skó'nda. ");
INSERT INTO maaNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Koií kjoa̱‑la̱ nga matsjakeè‑na Na̱'èn‑na̱ nga 'a̱n tíjngoò takoàn nga ki̱yá mé‑ne k'e̱ nga ko̱ma i̱skan kjoa̱áya‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni̱yá xi tjí'nde‑la̱ nga si̱ìk'en‑na, 'a̱n kjo̱tsja ts'a̱n‑ná nga tsja yijo‑na̱. Tjí'nde‑na̱ nga tsja, ti̱koa̱ tjí'nde‑na̱ nga kjoa̱áya‑na̱ i̱t'aà ts'e̱ kjoa̱biyaà. Jè Na̱'èn‑na̱ k'oa̱ tjín kjo̱tíxoma xi kitsjaà‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jñà xi̱ta̱ judío k'e̱ nga kiì'nchré 'én koi, ìjngoò k'a kjòjòya jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kjín ma xi̱ta̱ xi kitsò: ―Ini̱ma̱ cho̱‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱. Xi̱ta̱ ská‑né. ¿Mé‑ne o̱kji‑ne xi̱ta̱ xi na'yà‑là? ");
INSERT INTO maaNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jñà xi̱ta̱ xi i'nga kitsò: ―'Én koi mìtsà ts'e̱ xi̱ta̱ nei̱í. ¿A ko̱maá‑la̱ jè xi̱ta̱ nei̱í nga skíx'a̱ xko̱n xi̱ta̱ xi mìkiì tsejèn‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","K'e̱ nga na̱chrjein cho̱n 'nchán, ján Jerusalén tíbitjo s'eí nga ijchò ìjngoò nó nga kjòchikon‑t'in i̱ngo̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús ya̱ tíjna i̱ngo̱ ítjòn nga tsóbangui nguitjoa̱ xi 'mì Salomón. ");
INSERT INTO maaNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jñà xi̱ta̱ judío chincha jngoò itjandiì‑la̱ Jesús, kitsò‑la̱: ―¿Skanda mé na̱chrjein chíña‑lèje̱n? Jngoò k'a koa̱tìn‑náje̱n, ¿a ji̱‑né xi Cristo xi xó kisìkasén‑ne Nainá? ");
INSERT INTO maaNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús kiìchja̱ kitsò‑la̱: ―Jyeé k'oa̱ kixan‑nò, ta̱nga jñò mìkiì mokjeiín‑nò. Jñà kjo̱xkón xi i̱t'aà ts'e̱ Na̱'èn‑na̱ s'iaàn, jñà síkixi̱ya ndaà kjoa̱ xi i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ta̱nga jñò, mìkiì mokjeiín‑nò, koií kjoa̱‑la̱ nga mìtsà ndí orrè ts'a̱n xan‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Jñà ndí orrè‑na̱ 'nchréjtaá‑na̱; 'a̱n beèxkon‑ná, koa̱ fìtji̱ngui‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","'A̱án tsja‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne; mìkiì chija ni̱ta̱ kjé‑ne; ti̱koa̱ ni̱yá xi kjoa̱á'an‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Jè Na̱'èn‑na̱ xi kisìnga̱tsja‑na jñà ndí orrè, ìsa̱ tíjna ítjòn ni̱ta̱ yá‑ne. Ni̱jngoò xi ko̱ma‑la̱ kjoa̱á'an‑na i̱ya tsja Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","'A̱n ko̱ Na̱'èn‑na̱ tà jngoò ma‑naje̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jñà xi̱ta̱ judío tsibíxkó nda̱jo̱ nga mejèn‑la̱ ko̱sèn‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kiìchja̱ Jesús kitsò‑la̱: ―'Ñó kjìn kjo̱xkón xi ndaà tjín jye tsakoò‑nò xi inchrobà‑ne i̱t'aà ts'e̱ Na̱'èn‑na̱. ¿Jñò, ñá‑la̱á nga̱tjì‑la̱ kjoa̱ koi, nga nda̱jo̱ mejèn bínè‑ná? ");
INSERT INTO maaNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jñà xi̱ta̱ judío kitsò: ―Mìtsà koií kjoa̱‑la̱ kjo̱xkón ndaà xi tì'nì nga nda̱jo̱ kínè‑lèje̱n. Koií kjoa̱‑la̱ nga Nainá nokjoàjno‑la̱ nga Nainá 'mì‑la̱ yijo‑lè. Ji̱, tà xi̱ta̱‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús kiìchja̱ kitsò‑la̱: ―Jè Xo̱jo̱n‑la̱ Nainá xi jñò chìta'yà k'oa̱á s'ín tíchja̱ ñánda nga tsò Nainá: “Jñò, k'oa̱á kixan‑nò, nainá 'mì‑nò.” ");
INSERT INTO maaNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Xo̱jo̱n‑la̱ Nainá, mì yá xi ko̱ma ko̱chrjekàngui. K'oa̱á s'ín tíchja̱ nga jè Na̱'èn‑ná, nainá kitsò‑la̱ jñà xi̱ta̱ xi kitjoé‑la̱ 'én‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Tsà k'oa̱s'ín ki'mì xi̱ta̱ koi, ¿mé‑ne bixón‑nò nga Nainá chjàjno‑la̱ k'e̱ nga xan‑nò: 'A̱n‑ná xi Ki'ndí‑la̱ Nainá? Nga jè Nainá kitsjaà‑na̱ xá nga kisìkasén‑na̱ i̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kì kiì mokjeiín‑nò i̱t'aà ts'a̱n, tsà mì k'oa̱á s'ín tìs'iaàn koni s'ín tís'ín Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ta̱nga tsà k'oa̱ tjín kjoa̱ xi tìs'iaàn na̱s'ín mìkiì mokjeiín‑nò i̱t'aà ts'a̱n, kàtakjeiín‑nò i̱t'aà ts'e̱ kjoa̱ xi tìs'iaàn, mé‑ne nga k'oa̱s'ín jcha̱‑nò ko̱ kàtakjeiín‑nò nga ta jngoó ma‑naje̱n Na̱'èn‑na̱ ko̱ 'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jñà xi̱ta̱ judío mejèn‑la̱ nga kitsobà'ñó ìjngoò k'a Jesús. Ta̱nga Jesús itjokàya tsja xi̱ta̱ koi, i̱kjoàn kiì. ");
INSERT INTO maaNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","K'e̱é kiì ìjngoò k'a ján xijngoaà xa̱jngá nandá Jordán ya̱ ñánda kis'iìn ítjòn bautizar xi̱ta̱ jè Juan; Jesús ya̱á tsibìjna. ");
INSERT INTO maaNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","'Ñó kjìn xi̱ta̱ ijchò tji̱ngui‑la̱ Jesús. Xi̱ta̱ koi, kitsò: ―Juan, ni̱mé kjo̱xkón ndaà kis'iìn. Ta̱nga ngats'iì 'én xi kitsò jè Juan i̱t'aà ts'e̱ xi̱ta̱ jè, nguì kjoa̱ kixi̱‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ya̱ i̱'nde jè, 'ñó kjìn xi̱ta̱ kòkjeiín‑la̱ i̱t'aà ts'e̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tíjna xk'én jngoò xi̱ta̱ xi 'mì Lázaro xi ya̱ i̱'nde‑la̱ Betania, ya̱ na̱xa̱ndá ts'e̱ María ko̱ ndichja xi 'mì Marta. ");
INSERT INTO maaNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Jè María xi ndichja ma Lázaro, jè‑né xi kisìkaàjno xkiì jne̱ ndso̱ko̱ Jesús. I̱kjoàn ko̱ tsja̱ sko̱ kisìxìjno‑ne ndso̱ko̱.) ");
INSERT INTO maaNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jñà íchjín ndichja Lázaro, kisìkasén‑la̱ xá Jesús, kitsò‑la̱: ―Na̱'èn, jè amigo‑lè xi ndaà matsjachi kijna xk'én‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","K'e̱ nga kiì'nchré Jesús, kitsò: ―Ch'in jè, mìkiì ki̱yá‑ne; k'oa̱á s'ín ko̱chjeén nga jcha̱‑la̱ kjoa̱jeya‑la̱ Nainá, mé‑ne jè Ki'ndí‑la̱ ti̱koa̱ jeya kíjna‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús 'ñó matsjakeè Marta ko̱ ndichja ko̱ Lázaro xi 'ndse̱ ma. ");
INSERT INTO maaNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","K'e̱ nga kiì'nchré nga kijna xk'én Lázaro, nguì jò na̱chrjein tsibìjna Jesús, ya̱ i̱'nde ñánda tíjna. ");
INSERT INTO maaNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Xi jye komà, i̱kjoàn kitsò‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱: ―Ìjngoò k'a tíkjiaán ján nangui Judea. ");
INSERT INTO maaNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kitsò: ―Maestro, kj'eè tsà kjìn na̱chrjein tjín‑la̱ k'e̱ nga jñà xi̱ta̱ judío mejèn‑la̱ tsibínè‑lè nda̱jo̱ nga si̱ìk'en‑lè. ¿A ti̱ya̱á mejèn k'oín ìjngoò k'a ngá‑ne? ");
INSERT INTO maaNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kiìchja̱ Jesús kitsò‑la̱: ―Nga jngoò na̱chrjein, ¿a mìtsà tejò hora tjín‑la̱? Jè xi na̱chrjein tsóba mìkiì satíngui nga jè ni'ín xi tjín i̱sò'nde síhiseèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ta̱nga jè xi tsóba nga ni̱tje̱n, satíngui‑né nga tsjìn‑la̱ ni'ín xi síhiseèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","I̱kjoàn kitsò‑la̱ xi̱ta̱‑la̱: ―Jè amigo‑ná Lázaro kjinafé‑né, ta̱nga 'a̱n koií xá fì‑na̱ nga 'a̱n si̱kjaá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús kitsò: ―Na̱'èn, tsà kjinafé‑né, ko̱ndaá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús k'e̱ nga o̱kitsò, jè tíchja̱ i̱t'aà ts'e̱ kjoa̱biyaà‑la̱ Lázaro. Ta̱nga jñà xi̱ta̱ xi kota'yàt'aà‑la̱ k'oa̱á s'ín kisìkítsjeèn tsà tà tísíkjáya‑ne Lázaro nga kjinafè. ");
INSERT INTO maaNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","K'e̱é jngoò k'a tsibéno̱jmí kixi̱‑la̱ kitsò‑la̱: ―Lázaro jyeé k'en. ");
INSERT INTO maaNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Matsja‑na̱ xi i̱t'aà tsa̱jòn nga jè na̱chrjein nga mì ya̱ titsa̱jnaà, mé‑ne jñò ko̱kjeiín‑nò. Nchrobá, tíkjiaán chítsejèn‑lá. ");
INSERT INTO maaNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","K'e̱é kiìchja̱ Tomás xi ti̱koa̱ Dídimo tsò‑la̱ 'én xi tsòya‑ne Ti'ño̱; kitsò‑la̱ xíkjín: ―Jñá ti̱koa̱ tíkjiaán, mé‑ne ya̱ ki̱yákoa̱á Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","K'e̱ nga ijchò Jesús, kiì'nchré nga jyeé tjín‑la̱ ñijòn na̱chrjein nga kisìhijiìn Lázaro. ");
INSERT INTO maaNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na̱xa̱ndá Betania chrañàt'aà kijna‑la̱ na̱xa̱ndá Jerusalén, tjín‑la̱ tsà jàn kilómetro. ");
INSERT INTO maaNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kjìn xi̱ta̱ judío ijchòkon jè Marta ko̱ María nga ijchò síjehikon nga 'ndse̱ k'en. ");
INSERT INTO maaNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jè Marta, k'e̱ nga kiì'nchré nga Jesús tínchrobá chrañà, kiìkjaá indiaà. Jè María ya̱á tsibìjnaya ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jè Marta kitsò‑la̱ Jesús: ―Na̱'èn, tsà i̱‑là tijni, jè 'ndsè mì‑la kiì k'en. ");
INSERT INTO maaNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ta̱nga i̱'ndei̱ be‑ná ni̱ta̱ mé xi si̱jé‑la Nainá, tsjá‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús, kitsò‑la̱: ―Jè 'ndsì kjoa̱áya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta kitsò: ―Be‑ná k'e̱ nga kjoe̱het'aà na̱chrjein kíjnakon ìjngoò k'a‑ne, k'e̱ nga kjoa̱áya‑la̱ ngats'iì xi̱ta̱ xi jye k'en. ");
INSERT INTO maaNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús, k'e̱é kitsò‑la̱: ―'A̱n‑ná xi sìkjaáya‑la̱ xi̱ta̱ ko̱ tsjaà‑la̱ kjoa̱binachon. Jè xi mokjeiín‑la̱ i̱t'aà ts'a̱n na̱s'ín ki̱yá, kíjnakon ìjngoò k'a‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ngats'iì xi̱ta̱ xi títsa̱jnakon, jñà xi mokjeiín‑la̱ i̱t'aà ts'a̱n, mìtsà jngoò k'a ki̱yá. Ngaji̱, ¿kó si?, ¿a mokjeiín‑lè? ");
INSERT INTO maaNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta kiìchja̱ kitsò: ―Jon Na̱'èn, 'a̱n, mokjeiín‑na nga ji̱‑né xi Cristo; ji̱‑né xi Ki'ndí‑la̱ Nainá, jè xi k'oa̱s'ín tjínè‑la̱ nga kjoi̱í i̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta, k'e̱ nga jye o̱kitsò, kiìchja̱'ma‑la̱ María xi ndichja ma, kitsò‑la̱: ―I̱í tíjna Maestro, chja̱ xó‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Jè María k'e̱ nga kiì'nchré, ni̱to̱ón tsasítje̱n, kiìkon Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús, kj'eè kiì fahas'en‑jiìn na̱xa̱ndá, tákó ya̱á síjna ñánda ijchòkjaá indiaà Marta. ");
INSERT INTO maaNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jñà xi̱ta̱ judío xi títsa̱jnako̱ ni'ya‑la̱ María nga nchisíjehikon, k'e̱ nga kijtseè nga tà ni̱to̱n itjo ni'ya María, kiìtji̱ngui‑la̱. K'oa̱á s'ín kisìkítsjeèn tsà ya̱ tífì kjindáya ñánda kisìhijiìn Lázaro. ");
INSERT INTO maaNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María k'e̱ nga ijchò ñánda síjna Jesús, k'e̱ nga kijtseè, tsasìjna xkó'nchit'aà‑la̱, kitsò‑la̱: ―Na̱'èn tsà i̱í‑la tijni, jè 'ndsè mì‑la kiì k'en. ");
INSERT INTO maaNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús k'e̱ nga kijtseè nga tíkjindáya María ti̱koa̱ nchikjindáya xi̱ta̱ judío xi tji̱ko̱, 'oón komà‑la̱ ini̱ma̱‑la̱ Jesús, 'ñó kjòba‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jesús kiskònangui, kitsò: ―¿Ñánda kisìhijiìn? Kitsò jñà xi̱ta̱: ―Na̱'èn nchroboí, chítsejèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús kiskindàya‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jñà xi̱ta̱ judío kitsò‑la̱ xíkjín: ―Chítsejèn‑la̱, 'ñó matsjakeè Lázaro. ");
INSERT INTO maaNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tjín i'nga xi̱ta̱ xi kitsò: ―Xi̱ta̱ jè komà‑la̱ kiskíx'a̱ xko̱n xi̱ta̱ xi mìkiì tsejèn‑la̱, ¿a mìtsà komà‑la̱ tsà mìkiì k'en Lázaro? ");
INSERT INTO maaNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús ìjngoò k'a 'ñó 'on komà‑la̱ ini̱ma̱‑la̱. Kiì kasìt'aà chrañà‑la̱ jè i̱tsjó‑la̱ mik'en. Jngoò nguijo ñánda jngoò nda̱jo̱ teè tíchjoàjto‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús kitsò: ―Chja̱àxiòn jè nda̱jo̱. Jè Marta, ndichja mik'en, kitsò‑la̱ Jesús: ―Na̱'èn, jyeé‑la ch'o jne̱ nga jyeé tjín‑la̱ ñijòn na̱chrjein nga kisìhijiìn. ");
INSERT INTO maaNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kiìchja̱ Jesús kitsò‑la̱: ―¿A mì jyeé k'oa̱ kixan‑lè, tsà mokjeiín‑lè jcha̱‑ne kjoa̱jeya‑la̱ Nainá? ");
INSERT INTO maaNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","K'e̱é jaàxìn nda̱jo̱ xi tíchjoàjto‑la̱ i̱tsjó‑la̱ mik'en, Jesús kiskoòtsejèn ngajmiì, kitsò: ―Na̱'èn, tsjaà‑lè kjo̱ndaà, ndaàha̱ chjí‑lè nga na'yà‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","'A̱n be‑ná nga kjit'aá na̱chrjein na'yà‑ná, ta̱nga koií k'oa̱ kàxan‑lè nga kjìn ma xi̱ta̱ xi títsa̱jna mé‑ne nga ko̱kjeiín‑la̱ nga ji̱ kinìkasén‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","K'e̱ nga jye o̱kitsò, 'ñó kiìchja̱, kitsò: ―Lázaro, nchroboí, tìtjoi̱i nga̱jo̱. ");
INSERT INTO maaNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jè xi kijna k'en, itjo‑ne nga̱jo̱. Jñà ndso̱ko̱ ko̱ tsja, nikje na'ñó tjí'ñó‑ne. Jè i̱sén‑la̱, jngoò nikje chroba tíjtéjiìn. Jesús k'e̱é kitsò‑la̱ jñà xi̱ta̱: ―Chíjnda̱'ñó‑nò, kàtjì‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jñà xi̱ta̱ judío xi j'iì nga tsobáhijtako̱ María, k'e̱ nga kijtseè koni s'ín kis'iìn Jesús, kjìn ma xi kòkjeiín‑la̱ i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ta̱nga tjín i'nga xi̱ta̱ judío xi kiìkon jñà xi̱ta̱ fariseo, tsibéno̱jmí‑la̱ koni s'ín tjín kjoa̱ xi kis'iìn Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ fariseo tsibíxkóya xíkjín, tsibíjna jngoò junta ts'e̱ xi̱ta̱ ítjòn‑la̱ xi̱ta̱ judío, kitsò‑la̱ xíkjín: ―¿Mé xi s'e̱én? Xi̱ta̱ jè ndaà jchán tís'ín kjo̱xkón xi ndaà tjín. ");
INSERT INTO maaNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tsà ta ki̱'nde‑lá, ngats'iì xi̱ta̱ ko̱kjeiín‑la̱ i̱t'aà ts'e̱. I̱kjoàn kjoi̱í xi̱ta̱ Roma, si̱ìkits'ón‑ya i̱'nde tsjeè‑ná ko̱ na̱xa̱ndá‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Xi ti̱jñà‑ne xi̱ta̱ koi, jngoò xi 'mì Caifás xi no̱'miì ítjòn tíjna jè nó jè, kiìchja̱ kitsò: ―Jñò, ni̱mé kjoa̱ xi tíjiìn‑nò, ");
INSERT INTO maaNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ko̱ mìkiì nìkítsjeèn nga mochjeén‑né nga tà jngoò xi̱ta̱ kàtiyaàtjì‑la̱ na̱xa̱ndá‑ná mì k'oa̱á‑ne tsà ki̱yá yije xi̱ta̱ na̱xa̱ndá‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás k'e̱ nga k'oa̱s'ín kiìchja̱ mìtsà tà kjo̱hítsjeèn ts'e̱. Ta̱nga koi‑né nga no̱'miì ítjòn tíjna nó jè, Nainá kisìkichi̱ya‑la̱ nga Jesús, k'oa̱á s'ín tjínè‑la̱ nga jè na̱xa̱ndá ki̱yátjì ngajo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mìtsà ta jè na̱xa̱ndá ki̱yátjì ngajo‑la̱; ti̱koa̱á koi̱ìxkóya‑né ngats'iì i̱xti‑la̱ Nainá xi xki̱ xi ján na̱xa̱ndá nchisíjchá yijo‑la̱, kóho̱kji nga tíjtsa i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ti̱jè‑ne na̱chrjein jè tsajoóya‑ne nga si̱ìk'en Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Koií kjoa̱‑la̱ Jesús mì ti̱ kiì ta̱xki̱ tsajmeèjiìn osen‑la̱ xi̱ta̱ judío. Ya̱á kiì kíjna i̱'nde i̱t'aà xìn ñánda nangui kixì choòn ya̱ chrañàt'aà‑la̱ jngoò na̱xa̱ndá xi 'mì Efraín; ya̱á tsibìjna ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jyeé nchrobá machrañà s'eí Paxko̱ ts'e̱ xi̱ta̱ judío. K'e̱ nga ti̱kj'eè mats'ia̱ s'eí, kjìn xi̱ta̱ kiì ján Jerusalén nga kiì sítsjeèya yijo‑la̱ koni s'ín tjín kjo̱tíxoma‑la̱ xi xkón tjín. ");
INSERT INTO maaNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Xki̱ xi ján tsohótsji Jesús. K'e̱ nga títsa̱jna ya̱ ndi̱tsin i̱ngo̱, kitsò‑la̱ xíkjín: ―¿Kó bixón? ¿A kjoi̱í s'eí Paxko̱, o xi majìn‑né? ");
INSERT INTO maaNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ fariseo, k'oa̱á s'ín kitsjaà o̱kixi̱ tsà yá xi skoe̱xkon ñánda tíjna Jesús, kàtèno̱jmí mé‑ne nga tso̱ba̱'ñó‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nguì joòn na̱chrjein chija ìsa̱‑la̱ nga ki̱tjo s'eí Paxko̱. Jesús kiì ján na̱xa̱ndá Betania ñánda tíjna Lázaro xi jè Jesús kisìkjaáya‑la̱ k'e̱ nga k'en. ");
INSERT INTO maaNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ya̱á kisindaà‑la̱ tsojmì Jesús xi tsakjèn nga kòjñò. Jè Marta tsibíya tsojmì xi kiskine. Ngats'iì xi̱ta̱ xi ya̱ títsa̱jnat'aà ími̱xa̱, ti̱koa̱ ya̱ tíjna Lázaro ko̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María j'iìko̱ osen litro xkiì jne̱ xi 'ñó chjí xi nguì ts'e̱ nardo. Kisìkaàjno ndso̱ko̱ Jesús, i̱kjoàn kisìxìjno‑ne tsja̱sko̱. Kóho̱kji i'nga ni'ya, ndaà jchán kiìjne̱. ");
INSERT INTO maaNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jngoò xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, jè ti‑la̱ Simón xi 'mì Judas Iscariote, jè xi si̱ìnga̱tsja Jesús jñà xi̱ta̱ kondra̱‑la̱, kitsò: ");
INSERT INTO maaNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Mé‑ne mìtsà kàsatíjna‑ne xkiì jne̱ jè? Tsà kàsatíjna‑ne koni tjín síkijne chjí‑la̱ jngoò xi̱ta̱ xi jàn sìndo̱ na̱chrjein síxá, mé‑ne jè to̱n‑la̱ ko'bì‑la̱ jñà xi̱ta̱ i̱ma̱. ");
INSERT INTO maaNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas mìtsà koi kjoa̱‑la̱ o̱kitsò‑ne nga makájno‑la̱ xi̱ta̱ i̱ma̱, koií‑né nga xi̱ta̱ chijé‑né. Jè nga̱tsja chijtsa xi sinchá to̱n; ma síchijé to̱n xi sinchá chijtsa. ");
INSERT INTO maaNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús kitsò‑la̱: ―Kì k'oa̱ 'mì‑la̱ jè chjo̱ón. Xkiì jne̱ jè tíjnatjò‑la̱ k'e̱ nga 'a̱n xi siìjñaà. ");
INSERT INTO maaNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Jñò, kjit'aà na̱chrjein kítsa̱jnako̱‑nò jñà xi̱ta̱ i̱ma̱, ta̱nga 'a̱n mìtsà tà kjit'aà na̱chrjein i̱ kóti̱jnako̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","'Ñó kjìn xi̱ta̱ judío kisijiìn‑la̱ nga ya̱ tíjna Jesús ya̱ na̱xa̱ndá Betania; k'e̱é kiìtji̱ngui‑la̱. Ta̱nga mìtsà tà koií kjoa̱‑la̱ Jesús kiì‑ne; jè kiì katsejèn‑la̱ Lázaro xi jè Jesús kisìkjaáya‑la̱ k'e̱ nga k'en. ");
INSERT INTO maaNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì tsajoóya‑ne nga ti̱koa̱ mejèn‑la̱ si̱ìk'en jè Lázaro, ");
INSERT INTO maaNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","koií kjoa̱‑la̱ nga jè nga̱tjì‑la̱ Lázaro, kjìn jchán xi̱ta̱ judío chinchat'aàxìn nga jye mokjeiín‑la̱ i̱t'aà ts'e̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nga komà nchijòn, kjìn jchán xi̱ta̱ ijchò s'eí Paxko̱ ján Jerusalén; kisijiìn‑la̱ nga ti̱koa̱ ya̱ ki̱jchò Jesús; ");
INSERT INTO maaNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","tsate xka̱jén, itjo kiskoòñà‑la̱ i̱ya ndi̱yá; 'ñó kiìchja̱, kitsò: ―¡Jeya kàtìjna Nainá! ¡Mé tà ndaà‑la̱ jè xi̱ta̱ xi nchrobá nga̱jo̱‑la̱ Nainá, xi xi̱ta̱xá ítjòn‑la̱ xi̱ta̱ na̱xa̱ndá Israel! ");
INSERT INTO maaNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús kisakò jngoò‑la̱ ndí búrró ki'ndí xi tsibìjnasòn‑la̱ koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá, nga tsò: ");
INSERT INTO maaNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Kì tsakjoòn‑jèn, ji̱ na̱xa̱ndá Sión, chìtsejèn‑la̱ xi̱ta̱xá ítjòn‑lè xi nchrobá, tíjnasòn jngoò‑la̱ ndí búrró ki'ndí. ");
INSERT INTO maaNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","K'e̱ nga sa̱ ítjòn, jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús mìkiì kjòchi̱ya‑la̱ kó tsòya‑ne 'én koi. Ta̱nga k'e̱ nga k'en Jesús, i̱kjoàn jaáya‑la̱ nga kiìmijìn ján ngajmiì, skanda k'e̱é kjòchi̱ya‑la̱ nga k'oa̱á s'ín komàt'in koni s'ín tíchja̱ xo̱jo̱n xi i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jñà xi̱ta̱ xi kijtseè k'e̱ nga jè Jesús kisìkjaáya‑la̱ jè Lázaro nga jye kijnak'en, ìsa̱á ndaà kisìka'bísòn 'én, tsibéno̱jmí yije‑la̱ xi̱ta̱ xi kj'ei̱í. ");
INSERT INTO maaNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Koií kjoa̱‑la̱ 'ñó kjìn xi̱ta̱ kiìkjaá indiaà Jesús nga jye kiì'nchré jñà kjo̱xkón xi kis'iìn. ");
INSERT INTO maaNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jñà xi̱ta̱ fariseo kitsò‑la̱ xíkjín: ―Chítsején‑là; jñá, ni̱mé xi s'e̱én nga ngats'iì xi̱ta̱ i̱sò'nde sa̱ jè fìtji̱ngui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jñà xi̱ta̱ xi ijchò s'eí ján Jerusalén nga ya̱ beèxkón Nainá, ya̱á títsa̱jnajiìn i'nga xi̱ta̱ griego. ");
INSERT INTO maaNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Xi̱ta̱ koi ijchòkon Felipe xi Betsaida i̱'nde‑la̱, nangui xi chja̱‑ne Galilea; tsibítsi'ba‑la̱ kitsò‑la̱: ―Na̱'èn, mejèn‑naje̱n jcha̱xkon‑je̱n Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe kiì kéno̱jmí‑la̱ Andrés; k'e̱é kiì Andrés ko̱ Felipe tsibéno̱jmí‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús kiìchja̱ kitsò‑la̱: ―Jyeé ijchò na̱chrjein‑la̱ nga jè Ki'ndí‑la̱ Xi̱ta̱ kji̱mijìn ìjngoò k'a‑ne ngajmiì mé‑ne nga jeya kíjna‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nguì o̱kixi̱í xi xan‑nò, jè no̱jmé tsà mìkiì tjóki̱yá k'e̱ nga sitje̱, tà jngoò kjit'aá ko̱ma. Ta̱nga tsà tjóki̱yá k'e̱ nga si̱hijiìn, ko̱kjìn‑ya‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jè xi̱ta̱ xi tjòkeè yijo‑la̱ nga mì mé kjo̱'in sa̱kò‑la̱, tà sa̱á si̱ìchija‑né ko̱ kjo̱'in kíjnajiìn; ta̱nga jè xi̱ta̱ xi mìkiì tjòkeè yijo‑la̱ i̱ i̱sò'nde, ndaà tíjnatjò‑la̱ kjoa̱binachon‑la̱ skanda ta mé na̱chrjein‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tsà yá xi mejèn‑la̱ nga 'a̱n si̱ìxáko̱‑na kàtjanchrobá tji̱ngui‑na; ya̱ ñánda nga 'a̱n kóti̱jna, ti̱koa̱ jè, ya̱á kíjnat'aà‑na. Tsà yá xi 'a̱n si̱ìxáko̱‑na jè Na̱'èn‑na̱ ndaà skoe̱xkón. ");
INSERT INTO maaNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’I̱'ndei̱ 'ñó jchán ba ma‑la̱ ini̱ma̱‑na̱. ¿Mé 'én xi kichjà? ¿A k'oa̱á xan‑lè: “Na̱'èn, ti̱nachrjekàjiìn‑ná kjo̱'in xi ko̱mat'ian jè hora jè”? Majìn, nga koií xá j'i̱‑na nga ki̱tasòn. ");
INSERT INTO maaNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Na̱'èn, jeya tijni. Ti̱k'e̱‑ne kina'yà jngoò‑la̱ 'én xi ngajmiì nchrobá‑ne, kitsò: ―Jyeé kòkjìn k'a jeya síkíjna yijo‑na̱ ko̱ ìjngoò k'a jeya siìkíjna yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jñà xi̱ta̱ xi ya̱ títsa̱jna, k'e̱ nga kiì'nchré, tjín xi kitsò: ch'o̱ón xi jane. Jñà xi̱ta̱ xi i'nga, kitsò: ―Àkja̱le̱‑la̱ Nainá xi kiìchja̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kiìchja̱ Jesús kitsò: ―'Én xi kàna'yà‑là mìtsà kjo̱ndaà ts'a̱n, kjo̱ndaà tsa̱jòn‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Jè hora jè, nga sindaàjiìn‑la̱ i̱sò'nde; i̱'ndei̱, jyeé ijchò hora nga jè xi̱ta̱ nei̱í xi tíhotíxoma‑la̱ i̱sò'nde, jyeé ki̱tjojiìn. ");
INSERT INTO maaNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","K'e̱ nga 'a̱n, tjámiìtje̱n i̱t'aà nangui, ngats'iì xi̱ta̱, 'a̱án kichjà‑la̱ nga kji̱nchrobàt'aà‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Koií o̱kitsò‑ne, jè tsibéno̱jmíya kós'ín ko̱mat'in k'e̱ nga ki̱yá. ");
INSERT INTO maaNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jñà xi̱ta̱ kiìchja̱ kitsò‑la̱: ―'Ya‑náje̱n nga jè kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés, k'oa̱á s'ín tíchja̱, tsò‑né: Jè Cristo, kíjnakon‑ne ni̱ta̱ kjé‑ne. Ngaji̱, ¿mé‑ne ko̱si‑ne nga mochjeén‑né nga jè Ki'ndí‑la̱ Xi̱ta̱ tjámiìtje̱n‑t'aà nangui? ¿Yá‑ne xi Ki'ndí‑la̱ Xi̱ta̱ 'mì‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús kitsò‑la̱: ―Tákó kíjnajiìn chiba na̱chrjein‑nò ni'ín xi síhiseèn‑nò. Ti̱tjájmeè nga tíjnajiìn‑nò xi síhiseèn‑nò, mé‑ne nga mì ko̱jñò‑nò. Jè xi i̱jiìn jñò tsó'ba mìkiì beè kós'ín fì. ");
INSERT INTO maaNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kàtakjeiín‑nò i̱t'aà ts'e̱ ni'ín xi síhiseèn k'e̱ nga tákó tíjnajiìn‑nò, mé‑ne nga ya̱ ki̱tjá ñánda iseèn choòn. K'e̱ nga jye o̱kitsò Jesús, kiì tsibìjna'ma‑la̱ jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús, na̱s'ín tákó 'ñó kjìn kjo̱xkón ndaà kis'iìn nga nguixko̱n xi̱ta̱, jñà xi̱ta̱ mìkiì kòkjeiín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Koií tsitasòn 'én xi kiskiì Isaías, xi̱ta̱ xi kiìchja̱ya̱ nga̱jo̱‑la̱ Nainá, nga kitsò: Na̱'èn, ¿yá‑né xi tímokjeiín‑la̱ 'én‑ná xi kinokjoàyaá? ¿Yá xi tìhokoò‑la̱ nga'ñó xi tjín‑lè? ");
INSERT INTO maaNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Koií kjoa̱‑la̱ nga mìkiì kòkjeiín‑la̱, nga k'oa̱á s'ín tíchja̱ ìjngoò k'a xo̱jo̱n‑la̱ Isaías ñánda tsò: ");
INSERT INTO maaNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nainá tsibíchjoà xko̱n, kisìtájaàjiìn ini̱ma̱‑la̱, mé‑ne nga mìkiì ko̱tsejèn‑la̱, mìkiì ko̱chi̱ya‑la̱ i̱jiìn ini̱ma̱‑la̱ nga ti̱koa̱ mì 'a̱n kji̱nchrobàt'aà‑na̱ nga 'a̱n sìndaà‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías, koií k'oa̱s'ín kiìchja̱‑ne nga jyeé kijtseè jè kjoa̱ jeya‑la̱ Jesús nga i̱t'aà ts'e̱é kiìchja̱. ");
INSERT INTO maaNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na̱s'ín koa̱tsò 'én koi, kjìn xi̱ta̱ judío kòkjeiín‑la̱ i̱t'aà ts'e̱ Jesús, skanda kòkjeiín i'nga‑la̱ xi xi̱ta̱ sko̱‑la̱. Ta̱nga mìtsà jngoò k'a tsakó yijo‑la̱ nga jye kòkjeiín‑la̱ i̱t'aà ts'e̱ Cristo; nga jñà tsakjón‑la̱ jñà xi̱ta̱ fariseo, tsà ya̱ ko̱chrjekàjiìn ni'ya i̱ngo̱ sinagoga. ");
INSERT INTO maaNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jè xi mejèn‑la̱ nga ìsa̱ ndaà kítsa̱jna nga nguixko̱n xi̱ta̱ mì k'oa̱‑ne koni nga nguixko̱n Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús 'ñó kiìchja̱ kitsò: ―Jè xi mokjeiín‑la̱ i̱t'aà ts'a̱n, mìtsà tà i̱t'aà ts'a̱n mokjeiín‑la̱, ti̱koa̱á mokjeiín‑la̱ i̱t'aà ts'e̱ Na̱'èn‑na̱ xi jè kisìkasén‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jè xi beèxkon‑na, ti̱koa̱á beèxkon‑né jè xi kisìkasén‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","'A̱n xi síhiseèn‑la̱ xi̱ta̱, koií xá j'i̱‑na i̱ i̱sò'nde, nga ngats'iì xi̱ta̱ xi ko̱kjeiín‑la̱ i̱t'aà ts'a̱n, mì ya̱ kítsa̱jnajiìn i̱jiìn jñò. ");
INSERT INTO maaNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jè xi 'nchré 'én‑na̱ ko̱ mìkiì síkitasòn, mìtsà 'a̱n tsjaà‑la̱ kjo̱'in nga mìtsà koi xá j'i̱‑na nga kjo̱'in tsjaà‑la̱ xi̱ta̱ i̱sò'nde, koií xá j'i̱‑na nga ko̱chrjekàjñaà kjo̱'in xi̱ta̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jè xi ochrjekàngui‑na̱ nga mìkiì kjoétjò 'én‑na̱, tjín xi tsjá‑la̱ kjo̱'in. Jè 'én xi jye 'a̱n kichjà, jè tsjá‑la̱ kjo̱'in k'e̱ nga kjoe̱het'aà na̱chrjein. ");
INSERT INTO maaNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","K'e̱ nga chjà, mìtsà tà kjo̱hítsjeèn ts'a̱n sìkjeén, jè Na̱'èn‑na̱ xi kisìkasén‑na kitsjaà‑na o̱kixi̱ kós'ín chjà koa̱ mé 'én xi kokoòya. ");
INSERT INTO maaNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Be‑ná jè kjo̱tíxoma‑la̱ Na̱'èn‑na̱, jè xi tjín‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne. Jñà 'én xi 'a̱n chjà, k'oa̱á s'ín chjà koni s'ín tsatíxoma‑na Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Chibaá na̱chrjein chija‑ìsa nga ki̱tjo s'eí Paxko̱ ts'e̱ xi̱ta̱ judío. Jesús jyeé tíjiìn‑la̱ nga jye ijchò na̱chrjein nga si̱ìkíjna i̱sò'nde nga jye tífìko̱‑ne Na̱'èn‑la̱. Ta̱nga Jesús tjòkeè kijtseè yije xi̱ta̱‑la̱ i̱ i̱sò'nde kóni skanda jyehet'aà na̱chrjein‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","K'e̱ nga jye kòjñò, Jesús tíkjèn‑ko̱ xi̱ta̱‑la̱, ko̱ jè xi̱ta̱ nei̱í jyeé k'oa̱s'ín tsibíjiìn ini̱ma̱‑la̱ jè Judas Iscariote, ti‑la̱ Simón, nga jè si̱ìnga̱tsja Jesús i̱t'aà ts'e̱ xi̱ta̱ kondra̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús jyeé tíjiìn‑la̱ nga jè Na̱'èn‑la̱ kisìnga̱tsja yije kjoa̱ nga jè ko̱tìxoma‑la̱ nga i̱t'aà ts'e̱ Nainá inchrobà‑ne ko̱ ti̱jè tífìko̱ ìjngoò k'a‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jesús tsasítje̱n‑t'aà ími̱xa̱, jaàxìn na̱chro̱ xi kisòn‑'nga‑la̱, kiskoé jngoò nikje toalla, tsibíkjá ndáyá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","I̱kjoàn kiskoé jngoò tina̱, tsibíya nandá, tsibíts'ia̱ nga tsaníjno ndso̱ko̱ xi̱ta̱ xi kota'yàt'aà‑la̱, i̱kjoàn kisìxìjno‑ne jè nikje toalla xi tíkjá ndáyá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","K'e̱ nga ijchò kasìt'aà‑la̱ Simón Pedro nga mejèn‑la̱ ko̱níjno ndso̱ko̱, Simón kitsò: ―Na̱'èn, ¿a ok'ín‑na nga ji̱ ko̱nìjnoi ndso̱koaà? ");
INSERT INTO maaNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Kiìchja̱ Jesús, kitsò: ―I̱'ndei̱ mìkiì machi̱ya‑lè mé kjoa̱ xi tìs'iaàn, ta̱nga ko̱ma i̱skan, k'e̱é ko̱chi̱ya‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Jè Pedro kitsò: ―Mìkiì tsjaà'nde nga ndso̱koaà ko̱nìjnoi. Jesús kitsò‑la̱: ―Tsà mìkiì kóníjnoa ndso̱koiì mìtsà xi̱ta̱ ts'a̱n xán‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","K'e̱é kitsò Simón Pedro: ―Na̱'èn, mìtsà tà ndso̱koaà ta̱nìjnoiì, ti̱koa̱á ta̱nìjnoiì ndsa̱a ko̱ skoaà. ");
INSERT INTO maaNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kiìchja̱ Jesús kitsò‑la̱: ―Jè xi jye tsangàya, tà jè ndso̱ko̱ mochjeén nga saníjno, nga jyeé tsjeè yije yijo‑la̱. Jñò, tsjeé kjoàn na̱s'ín mìtsà kóho̱tjión. ");
INSERT INTO maaNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús koií k'oa̱s'ín kitsò‑la̱: “Mìtsà tà ngats'ioò nga tsjeè kjoàn”, nga jyeé tíjiìn‑la̱ yá‑né xi si̱ìnga̱tsja i̱t'aà ts'e̱ xi̱ta̱ kondra̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","K'e̱ nga jye tsaníjno ndso̱ko̱ jñà xi̱ta̱‑la̱, tsohòkjá‑ne na̱chro̱kisòn‑'nga‑la̱. Tsibìjnat'aà‑ne ími̱xa̱, kitsò‑la̱: ―¿A machi̱yaá‑nò kjoa̱ xi kàsiìko̱‑nò? ");
INSERT INTO maaNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jñò, k'oa̱á bixón nga Maestro ko̱ Na̱'èn 'mì‑ná. Ndaà bixón, kixi̱í kjoa̱ xi 'mì‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","'A̱n, xi Maestro ko̱ Na̱'èn 'mì‑na, kònìjnoa ndso̱koò, jñò ti̱koa̱á mochjeén‑né nga k'oa̱ ti̱s'ín ta̱nìjnoò ndso̱ko̱ xinguio̱o. ");
INSERT INTO maaNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","'A̱n, k'oa̱á s'ín kìjna jngoò‑nò xkósòn mé‑ne jñò k'oa̱ ti̱s'ín ti̱ko̱o xinguio̱o koni s'ín kàsiìko̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nguì kjoa̱ kixi̱í xi xan‑nò, jè xi chi̱'nda tíjna, mìtsà jè tíjna ítjòn‑la̱ nei‑la̱. Ti̱koa̱ jè xi satíxá‑la̱ mìtsà jè tíjna ítjòn‑la̱ jè xi otíxá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","I̱'ndei̱ nga jye machi̱ya‑nò kjoa̱ koi, mé ta ndaà‑nò tsà k'oa̱s'ín si̱kitasòn nga ko̱s'ín s'e̱en. ");
INSERT INTO maaNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Mìtsà ngats'ioò k'oa̱tìxan‑nò; bexkon‑ná jñà xi̱ta̱ xi 'a̱n jaàjñaà. Mochjeén‑né nga kàtitasòn koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá nga tsò: “Jè xi kjèn‑ko̱‑na, ti̱jè‑ne xi kondra̱ kiìtji̱ngui‑na.” ");
INSERT INTO maaNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tìbeno̱jmí‑nò kjoa̱ koi k'e̱ nga ti̱kj'eè k'oa̱ ma, mé‑ne k'e̱ nga jye k'oa̱s'ín ko̱ma, ko̱kjeiín‑nò nga 'a̱n‑ná xi Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nguì kjoa̱ kixi̱í xi xan‑nò, jè xi skoétjò xi̱ta̱ xi 'a̱n siìkasén, 'a̱án skoétjò‑na; ko̱ jè xi skoétjò‑na, jè skoétjò jè xi kisìkasén‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesús k'e̱ nga jye o̱kitsò, 'ñó jchán kokájno‑la̱; ìjngoò k'a kiìchja̱, kitsò: ―Nguì o̱kixi̱í xi xan‑nò, i̱ tíjnajiìn jngoò‑nò xi si̱ìnga̱tsja‑na i̱t'aà ts'e̱ xi̱ta̱ kondra̱‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱, xki̱ xi ján kiskoò'an xíkjín nga mìkiì tíjiìn‑la̱ yá‑ne xi o̱títsò‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jngoò xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús ya̱ tíjnakjoòko̱ k'e̱ nga nchikjèn, jè xi̱ta̱‑la̱ xi jè Jesús 'ñó matsjakeè. ");
INSERT INTO maaNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jè Simón Pedro, kitsjaà‑la̱ seña jè xi̱ta̱ xíkjín xi ya̱ tíjnakjoòko̱ Jesús nga sko̱nangui‑la̱ yá‑né xi o̱títsò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jè xi̱ta̱ jè, ìsa̱ 'ñó tsibìjnat'aà chrañà‑la̱; kiskònangui‑la̱, kitsò‑la̱: ―Na̱'èn, ¿yá‑né xi o̱tì'mì‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kiìchja̱ Jesús kitsò: ―Jè xi tsjaà jngoò‑la̱ i̱nchra̱jín 'nchi̱, jè‑né xi o̱tìxan‑la̱. K'e̱é kitsjaà‑la̱ jè Judas Iscariote, ti‑la̱ Simón. ");
INSERT INTO maaNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jè xi̱ta̱ nei̱í ni̱to̱ón jahas'en‑jiìn ini̱ma̱‑la̱ Judas k'e̱ nga kiskoé i̱nchra̱jín. Jesús kitsò‑la̱: ―Jè kjoa̱ xi s'i̱in xátíya ko̱t'i̱in. ");
INSERT INTO maaNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jñà xi̱ta̱ xi títsa̱jnat'aà ími̱xa̱ xi nchikjèn, ni̱jngoò xi kjòchi̱ya‑la̱ mé‑ne ko̱s'ín kitsò‑ne Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tjín i'nga xi̱ta̱ xi k'oa̱s'ín kisìkítsjeèn; maá‑la̱ tsà títsò‑la̱ Jesús: “Tsojmì ti̱ndí xi ts'e̱ s'eí.” O tsà títsò‑la̱: “To̱n tjiì chiba‑la̱ xi̱ta̱ i̱ma̱.” Nga jè Judas nga̱tsja chijtsa to̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas, k'e̱ nga jye tsakjèn i̱nchra̱jín, ni̱to̱ón itjo ni'ya; kiì; nga jye jñò choòn. ");
INSERT INTO maaNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","K'e̱ nga jye itjo ni'ya Judas nga kiì, Jesús kitsò: ―I̱'ndei̱, jè Ki'ndí‑la̱ Xi̱ta̱, jyeé jeya tíjna. Ti̱koa̱ Nainá jyeé jeya tíjna i̱t'aà ts'e̱ Ki'ndí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nainá tsà jeya tíjna i̱t'aà ts'e̱ Ki'ndí‑la̱, ti̱jè‑ne Nainá jeya si̱ìkíjna Ki'ndí‑la̱. Ni̱to̱ón jcha̱‑la̱ kjoa̱ jeya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Jñò, xi ndí i̱xti‑na̱ xan‑nò, mìtsà ti̱ tse kóti̱jnako̱ ìsa̱‑nò. Jñò, ki̱nchátsji‑ná ta̱nga k'oa̱á xan‑nò koni kixan‑la̱ jñà xi̱ta̱ judío: Ya̱ ñánda tìfia, jñò, mìkiì ko̱ma konguió. ");
INSERT INTO maaNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jngoò kjo̱tíxoma xi̱tse̱ tsjaà‑nò: Ti̱tsjacha xinguio̱o nga jngoò ìjngoò. K'oa̱s'ín ti̱tsjacha xinguio̱o koni s'ín 'a̱n kisìtsjakeè‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tsà k'oa̱s'ín si̱tsjacha xinguio̱o nga jngoò ìjngoò, k'oa̱á s'ín skoe̱‑ne ngats'iì xi̱ta̱ nga kixi̱ kjoa̱ nga ya̱ chìta'yàt'aà‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro kiskònangui‑la̱ Jesús, kitsò‑la̱: ―Na̱'èn, ¿ñánda tì'mì? Jesús, kitsò‑la̱: ―Ya̱ ñánda tìfia, mìkiì ko̱ma kjítji̱ngui‑ná xi kjoa̱ ni̱to̱n, ta̱nga k'e̱ nga ko̱ma i̱skan, ko̱maá kjítji̱ngui‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Simón Pedro kitsò‑la̱: ―Na̱'èn, i̱'ndei̱, ¿mé‑ne mìkiì ko̱ma kjítji̱ngui‑lè? Tíjngoò takoàn nga 'a̱n ki̱yá ngajo‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús kiìchja̱, kitsò‑la̱: ―¿A kixi̱í kjoa̱ nga tíjngoò takoìn nga ji̱ ki̱yá ngajo‑ná? Nguì o̱kixi̱í xi xan‑lè, k'e̱ nga ti̱kj'eè kjindáya kóxtí, jàn k'a tsjá'mat'in‑ná nga mìkiì yaxkon‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Kì makájno‑nò. Kàtakjeiín‑nò i̱t'aà ts'e̱ Nainá, ti̱koa̱ kàtakjeiín‑nò i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ján ni'ya‑la̱ Na̱'èn‑na̱ tjín jchán i̱'nde ñánda ma nìkjáya. Tsà mì kixi̱ kjoa̱ nga k'oa̱s'ín tjín, mì‑la tsà tà chjà k'oa̱ xán‑nò nga tìfìkìndaà‑nò jngoò i̱'nde xi tsa̱jòn. ");
INSERT INTO maaNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Koni s'ín kjián nga kìndaà‑nò i̱'nde, k'oa̱á ti̱s'ín kjoia̱a ìjngoò k'a nga kjíko̱‑nò, mé‑ne ya̱ ñánda kóti̱jna, ti̱koa̱ ya̱ ki̱tsa̱jnako̱‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Jñò jyeé 'yaà kós'ín fì ndi̱yá ñánda tìfia. ");
INSERT INTO maaNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás kitsò: ―Na̱'èn mìkiì 'ya‑je̱n ñánda tì'mì. ¿Kós'ín jcha̱‑naje̱n ndi̱yá? ");
INSERT INTO maaNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús kitsò‑la̱: ―'A̱n‑ná xi ndi̱yá, 'a̱n‑ná xi kjoa̱kixi̱, 'a̱n‑ná xi kjoa̱binachon. Ta̱jngoò i̱t'aà ts'a̱n ko̱ma ki̱jchò jñò ñánda tíjna Na̱'èn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jñò, tsà yaxkon‑ná, ti̱koa̱ jcha̱xkon‑nò Na̱'èn‑na̱. Ta̱nga i̱'ndei̱, jyeé yaxkon ko̱ titsa̱chìtsejèn‑la. ");
INSERT INTO maaNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe kitsò: ―Ta̱kó‑náje̱n yá‑ne xi Na̱'èn 'mì. Ta̱ k'oa̱á tjín xi ko̱jngoò‑ne takòn‑je̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús kiìchja̱ kitsò‑la̱: ―Ji̱ Felipe, kjòtseé tìjna̱ko̱‑nò, ¿a tà kj'eè yaxkon‑ná? Jè xi jye kijtseèxkon‑na̱, jyeé kijtseèxkon Na̱'èn‑na̱. ¿Mé‑ne ko̱si‑ne: “Ta̱kó‑náje̱n xi Na̱'èn 'mì”? ");
INSERT INTO maaNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿A mì mokjeiín‑lè nga 'a̱n, ya̱á tìjna̱koa̱a Na̱'èn‑na̱, koa̱ jè Na̱'èn‑na̱ ya̱ tíjnako̱‑na? Jñà 'én xi 'a̱n chjàko̱‑nò, mìtsà kjo̱hítsjeèn ts'a̱n; jè Na̱'èn‑na̱ xi tíjnako̱‑na, jè‑né xi tísíxá i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kàtakjeiín‑nò nga 'a̱n ya̱ tìjna̱koa̱a Na̱'èn‑na̱, ko̱ jè Na̱'èn‑na̱ ya̱ tíjnako̱‑na. Tsà mìkiì mokjeiín‑nò i̱t'aà ts'a̱n, na̱s'ín tà jè kàtakjeiín‑nò i̱t'aà ts'e̱ xá‑na̱ xi 'a̱n tìs'iaàn. ");
INSERT INTO maaNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nguì o̱kixi̱í xi xan‑nò, jè xi mokjeiín‑la̱ i̱t'aà ts'a̱n, ti̱koa̱á ko̱maá‑la̱ s'i̱in xá xi 'a̱n s'iaàn; skanda ìsa̱á tsato s'i̱in, nga 'a̱n, ján tìfia ñánda tíjna Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ni̱ta̱ mé xi si̱jé‑la Na̱'èn‑na̱ xi i̱t'aà ts'a̱n, 'a̱n sìkitasoàn, mé‑ne jè Na̱'èn‑na̱ jeya kíjna‑ne i̱t'aà ts'e̱ Ki'ndí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tsà mé xi si̱jé i̱t'aà ts'a̱n, 'a̱n, sìkitasòn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Jñò, tsà matsjacha‑ná ti̱kitasòn kjo̱tíxoma‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","'A̱n, kìtsi'bà‑la̱ Na̱'èn‑na̱ nga kàtasíkasén jngoò‑nò jè xi ko̱si̱ko̱‑nò, mé‑ne kjit'aà na̱chrjein kíjnako̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jè xi si̱ìkasén‑nò Na̱'èn‑na̱, jè Ini̱ma̱ Tsjeè‑la̱ xi nguì kjoa̱ kixi̱. Jñà xi̱ta̱ i̱sò'nde, mìkiì ko̱ma skoétjò nga mìkiì beèxkon, ta̱nga jñò yaxkon‑nò nga ya̱ tíjnako̱‑nò, ko̱ ya̱á kíjnajiìn ini̱ma̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mìkiì siìkítsa̱jna jcha̱n‑nò, kjoi̱kon ìjngoò k'a‑nò nga kóti̱jnako̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tà chibaá na̱chrjein chija‑la̱ nga jñà xi̱ta̱ i̱sò'nde mì ti̱ kiì skoe̱xkon‑na; ta̱nga jñò jcha̱xkon‑ná; ti̱koa̱á ki̱tsa̱jnakon‑nò nga 'a̱n tìjna̱kon‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","K'e̱ nga ki̱jchò na̱chrjein jè, jcha̱‑nò nga ya̱á tìjna̱koa̱a Na̱'èn‑na̱, koa̱ jñò ya̱á titsa̱jnako̱‑ná, ko̱ 'a̱n ya̱á tìjna̱ko̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jè xi tíjiìn‑la̱ kjo̱tíxoma‑na̱ ti̱koa̱á síkitasòn‑né, jè‑né xi matsjakeè‑na. Ko̱ jè xi matsjakeè‑na ti̱koa̱á ko̱tsjakeè Na̱'èn‑na̱. 'A̱n, ti̱koa̱á matsjake̱‑ná koa̱ kokoò tsejèn‑la̱ yijo‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kiskònangui Judas (mìtsà jè Iscariote). Kitsò‑la̱: ―Na̱'èn kós'ín ko̱ma nga tà ngaje̱n ko̱kótsejèn‑náje̱n yijo‑lè nga mìtsà jñà xi̱ta̱ i̱sò'nde ko̱kótsejèn‑la̱ yijo‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Kiìchja̱ Jesús, kitsò‑la̱: ―Jè xi matsjakeè‑na̱ si̱ìkitasòn 'én‑na̱; ko̱ jè Na̱'èn‑na̱ ko̱tsjakeè‑né. Na̱'èn‑na̱ ko̱ 'a̱n kji̱nchrobàchón‑náje̱n; ya̱á ki̱tsa̱jnako̱‑je̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jè xi mìkiì matsjakeè‑na mìkiì síkitasòn 'én‑na̱. Jñà 'én xi jñò titsa̱na'yà, mìtsà ts'a̱n, ts'e̱é Na̱'èn‑na̱ xi kisìkasén‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’K'oa̱á s'ín tibeno̱jmí yije‑nò 'én koi k'e̱ nga tákó tìjna̱ko̱ ìsa̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Jè xi ko̱si̱ko̱‑nò, jè Ini̱ma̱ Tsjeè‑la̱ Nainá xi i̱t'aà ts'a̱n si̱ìkasén‑nò Na̱'èn‑na̱, jè ko̱kòya yije‑nò koa̱ si̱ìkítsjeèn‑nò ngats'iì 'én xi tìxan‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’'A̱n, tsjaà‑nò kjoa̱'nchán; ya̱á sìkíjnajñaà ini̱ma̱‑nò. K'oa̱á s'ín tsjaà‑nò koni s'ín 'nchán tìjna̱a, mìtsà k'oa̱s'ín tsjaà‑nò koni s'ín tsjá i̱sò'nde. Kì makájno‑nò ko̱ kì tsakjoòn‑jèn. ");
INSERT INTO maaNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Jñò, jyeé kina'yà koni s'ín tìxan‑nò nga 'a̱n tìfia ta̱nga kjoi̱i ìjngoò k'a. Tsà kixi̱ kjoa̱ nga matsjacha‑ná, jñò, ti̱koa̱á ko̱tsjaá‑nò nga xan‑nò: Jye tìfia ñánda tíjna Na̱'èn‑na̱; nga jè Na̱'èn‑na̱ ìsa̱á tíjna ítjòn mì k'oa̱‑ne koni 'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","K'oa̱á s'ín tibeno̱jmí ítjòn‑nò kjoa̱ koi, mé‑ne k'e̱ nga jye ki̱tasòn, ko̱kjeiín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Mì ti̱ kiì kjìn 'én kichjàko̱ ìsa̱‑nò. Jyeé nchrobá xi̱ta̱ nei̱í xi tíhotíxoma‑la̱ jè i̱sò'nde; ta̱nga nìmé nga'ñó tjín‑la̱ nga jè si̱ìkijne‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","K'oa̱á s'ín ki̱tasòn, mé‑ne skoe̱‑ne jñà xi̱ta̱ i̱sò'nde nga matsjake̱ Na̱'èn‑na̱ nga tìsìkitasoàn kjo̱tíxoma xi kitsjaà‑na. ’Ti̱sítje̱en, tíkjiaán. ");
INSERT INTO maaNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’'A̱án ngaya‑la̱ yá je‑la̱ toò uva; jè Na̱'èn‑na̱ xi síxáko̱. ");
INSERT INTO maaNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ngats'iì chrja‑la̱ yá uva xi i̱t'aà ts'a̱n nchrobát'aà‑ne xi mìkiì ojà‑la̱ toò, Na̱'èn‑na̱ otet'aà‑né; koa̱ jñà xi ojà‑la̱ toò, ta sítsjeè‑né, mé‑ne nga ìsa̱ ndaà ko̱ja̱‑la̱ toò. ");
INSERT INTO maaNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jñò, jyeé k'oa̱s'ín kjòtsjeè‑nò xi i̱t'aà ts'e̱ 'én xi o̱kixan‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jñò, mochjeén‑né nga ya̱ ki̱tsa̱jnako̱ kjit'aà‑ná koa̱ 'a̱n, ya̱á kóti̱jnako̱ kjit'aà‑nò. Jngoò chrja‑la̱ yá toò uva, mìkiì ko̱ja̱‑la̱ toò tsà mìkiì 'ñó tjít'aà jè yá je‑la̱. I̱t'aà tsa̱jòn, k'oa̱ ti̱s'ín tjín, nìmé xi s'e̱en tsà mì 'a̱n ki̱tsa̱jnako̱ kjit'aà‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’'A̱n‑ná xi yá je‑la̱ toò uva, jñò‑nó xi chrja‑la̱. Jè xi 'a̱n kíjnako̱ kjit'aà‑na̱ ko̱ 'a̱n kóti̱jnako̱ kjit'aà, ndaà jchán ko̱ja̱‑la̱ toò. Ta̱nga ni̱mé xi s'e̱en tsà titsa̱jnat'aàxìn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jè xi mìtsà 'a̱n kíjnako̱ kjit'aà‑na, k'oa̱á s'ín tjáxìn koni chrja‑la̱ yá xi nìmé toò ojà‑la̱; k'e̱ nga jye xì, maxkó‑né i̱kjoàn sinchájiìn ni'ín nga tì. ");
INSERT INTO maaNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Jñò, tsà ya̱ ki̱tsa̱jnako̱ kjit'aà‑ná, koa̱ tsà kixi̱ ki̱tsa̱jnako̱o 'én‑na̱ xi 'a̱n tsakoòya‑nò, ti̱jé ni̱ta̱ mé xi mejèn‑nò, k'oa̱á s'ín ki̱tasòn‑nò koni s'ín kixón. ");
INSERT INTO maaNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","K'oa̱á s'ín ma‑ne jcha̱‑la̱ kjoa̱jeya‑la̱ Na̱'èn‑na̱ k'e̱ nga 'ñó kjìn toò ko̱ja̱‑nò ko̱ k'oa̱á s'ín ma‑ne nga 'ya‑la̱ nga kixi̱ kjoa̱ nga ya̱ chìta'yàt'aà‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Koni s'ín matsjakeè‑na̱ Na̱'èn‑na̱, jñò, 'a̱n, k'oa̱ ti̱s'ín matsjake̱‑nò. Mochjeén‑né nga k'oa̱s'ín titsa̱jnako̱ kjit'aà kjoa̱ tsjacha‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tsà si̱kitasòn kjo̱tíxoma‑na̱, ya̱á ki̱tsa̱jnajñoò kjit'aà kjoa̱ tsjacha‑na̱. 'A̱n, k'oa̱á ti̱s'ín sìkitasoàn kjo̱tíxoma‑la̱ Na̱'èn‑na̱ ko̱ ya̱á tìjna̱jñaà kjit'aà kjoa̱tsjacha‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Jñò, k'oa̱á s'ín chjàko̱‑nò mé‑ne si̱jnajiìn‑ne ini̱ma̱‑nò kjo̱tsja xi 'a̱n tjín‑na ko̱ nguì ndaà s'e̱‑nò kjo̱tsja. ");
INSERT INTO maaNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kjo̱tíxoma‑na̱ xi 'a̱n tsjaà‑nò, jè‑né nga ti̱tsjacha xinguio̱o nga jngoò ìjngoò, koni 'a̱n matsjake̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Jè xi̱ta̱ xi biyaàtjì ngajo‑la̱ amigo‑la̱, jè‑né xi ìsa̱ 'ñó matsjakeè xíkjín. ");
INSERT INTO maaNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jñò‑nó xi amigo‑na̱ xan‑nò, tsà si̱kitasòn koni s'ín bìnè‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mì ti̱ chi̱'nda‑na̱ xan‑nò nga jè chi̱'nda mìkiì beè mé xi s'ín nei‑la̱. Amigo ts'a̱án xan‑nò nga jyeé tsibeno̱jmíya yije‑nò kjoa̱ xi tsakóya‑na̱ Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mìtsà jñò kichjaàjiìn‑ná, ta̱ saà 'a̱n jaàjiìn‑nò. Kitsjaà‑nò xá nga konguió mé‑ne nga ndaà si̱xá‑nò. Jè xá‑nò si̱jna‑né ni̱ta̱ kjé‑ne, mé‑ne k'e̱ nga mé xi si̱jé‑là Na̱'èn‑na̱ xi i̱t'aà ts'a̱n, tsjá‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jè kjo̱tíxoma xi 'ñó tìbìnè‑nò: Nga tjòcha jcha̱a xinguio̱o nga jngoò ìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Jñò, tsà si̱ìjtikeè‑nò jñà xi̱ta̱ i̱sò'nde, kàtasijiìn‑nò nga 'a̱n, k'oa̱á s'ín kisìjtikeè ítjòn‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jñò, tsà tákó ya̱ titsa̱jnajiìn‑là xi̱ta̱ i̱sò'nde, jñà xi̱ta̱ i̱sò'nde ko̱tsjakeé‑nò koni s'ín matsjakeè xi̱ta̱ xíkjín. Ta̱nga jñò, mìtsà ti̱ i̱‑ne i̱sò'nde tsa̱jòn. 'A̱n jaàjiìn‑nò nga tsachrjekàjiìn‑nò kjoa̱ xi tjín i̱sò'nde, koií kjoa̱‑la̱ nga majtikeè‑nò jñà xi̱ta̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ndaà ti̱kítsjeèn koni s'ín kixan‑nò: “Jè xi chi̱'nda tíjna, mìtsà ìsa̱ tíjna ítjòn‑la̱ nei‑la̱.” Koni s'ín kiìtji̱ngui kondra̱‑na̱ jñà xi̱ta̱, jñò, k'oa̱á ti̱s'ín kji̱tji̱ngui kondra̱‑nò. Tsà kisìkitasòn 'én‑na̱, ti̱koa̱á si̱ìkitasòn tsa̱jòn. ");
INSERT INTO maaNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ngats'iì kjoa̱ koi, k'oa̱á si̱ìko̱‑nò jè nga̱tjì‑la̱ i̱t'aà ts'a̱n nga mìkiì beèxkon jè xi kisìkasén‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’'A̱n, tsà mì‑la kiì j'ia̱a ko̱ tsà mì‑la kiì tsohókoa̱a, ni̱ mé‑la jé tjín‑la̱. Ta̱nga i̱'ndei̱, mì ti̱ kiì ko̱ma ko̱si̱ko̱‑ne yijo‑la̱ kjoa̱ ts'e̱ jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jñà xi̱ta̱ xi 'a̱n majtikeè‑na, ti̱koa̱á majtikeè Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ni̱mé‑là jé tjín‑la̱ jñà xi̱ta̱ tsà mì‑la kiì kijtseè jñà kjo̱xkón xi 'a̱n kis'iaàn xi ni̱ sa̱á jngoò xi̱ta̱ k'oa̱s'ín s'ín. Ta̱nga jyeé kijtseè kjo̱xkón xi 'a̱n kis'iaàn, ta̱nga tákó majtikeè‑na̱ ti̱koa̱ majtikeè Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","K'oa̱s'ín tíma nga tíbitasòn 'én xi tjít'aà Xo̱jo̱n‑la̱ Nainá xi kota'yà xi̱ta̱ koi, nga tsò: “Tísíjtikeé‑na̱ na̱s'ín nì mé kjoa̱ tìsìkoa̱.” ");
INSERT INTO maaNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Ta̱nga k'e̱ ki̱tjojen jè xi ko̱si̱ko̱‑nò, xi 'a̱n sìkasén i̱t'aà ts'e̱ Na̱'èn‑na̱, jè Ini̱ma̱ Tsjeè‑la̱ Nainá xi nguì o̱kixi̱, xi i̱t'aà ts'e̱ Na̱'èn‑na̱ nchrobá‑ne, jè tsjá 'én i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jñò, ti̱koa̱á k'oio̱o 'én i̱t'aà ts'a̱n nga ya̱á titsa̱jnako̱‑ná kóni nga tàts'en‑la̱ kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’K'oa̱s'ín tìbeno̱jmí‑nò kjoa̱ koi mé‑ne nga mìkiì ki̱nchat'aàxìn‑nò nga mokjeiín‑nò i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ko̱chrjekàjiìn‑nò ya̱ ni'ya i̱ngo̱ sinagoga. Ti̱koa̱ ki̱jchò na̱chrjein k'e̱ nga ni̱ta̱ yá‑ne xi si̱ìk'en‑nò k'oa̱á s'ín si̱ìkítsjeèn nga Nainá nchisíxá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Koií kjoa̱‑la̱ nga k'oa̱s'ín s'i̱in‑ne nga mìkiì beèxkon Na̱'èn‑na̱, ti̱koa̱á 'a̱n mìkiì beèxkon‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Koií k'oa̱s'ín tìxan‑nò mé‑ne k'e̱ nga ki̱jchò na̱chrjein ki̱ìtsjeèn‑nò nga jyeé tsibeno̱jmíya yije‑nò. K'e̱ nga sa̱ ítjòn, mìkiì o̱kixan‑nò nga ya̱á tìjna̱ko̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","’Ta̱nga i̱'ndei̱, jyeé tìfiko̱‑na jè xi kisìkasén‑na. Jñò, ni̱jngoò chjinangui‑ná, ñánda tìfia. ");
INSERT INTO maaNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Tà saà kjoa̱ba tíjiìn ini̱ma̱‑nò, jè nga̱tjì‑la̱ koni tìxan‑nò kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","'Én kixi̱í xi tìxan‑nò; kjo̱ndaà tsa̱jòn‑nò nga kjián. Tsà mìkiì kjián, mìkiì ko̱ma ki̱tjojen jè xi ko̱si̱ko̱‑nò nga i̱ kíjnako̱‑nò. Mochjeén‑né nga kjián mé‑ne nga ko̱ma sìkasén‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","K'e̱ nga ki̱tjojen jè xi ko̱si̱ko̱‑nò, jè si̱ìkíchi̱ya ndaà‑la̱ xi̱ta̱ i̱sò'nde kjoa̱ ts'e̱ jé, ko̱ kjoa̱ xi kixi̱ tjín ko̱ nga si̱ndaàjiìn yá xi ko̱ko̱‑la̱ kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jè si̱ìkíchi̱ya ndaà‑la̱ xi̱ta̱ i̱sò'nde xi kjoa̱ ts'e̱ jé nga mìkiì mokjeiín‑la̱ i̱t'aà ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ko̱ si̱ìkíchi̱ya ndaà‑la̱ xi̱ta̱ i̱t'aà ts'e̱ kjoa̱ xi kixi̱ tjín, nga 'a̱n jyeé tìfia ñánda tíjna Na̱'èn‑na̱. Jñò, mì ti̱ kiì jcha̱xkon‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ko̱ si̱ìkíchi̱ya ndaà‑la̱ xi̱ta̱ nga si̱ndaàjiìn‑la̱ yá xi ko̱ko̱‑la̱ kjo̱'in, koi kjoa̱‑la̱ nga jè xi̱ta̱ nei̱í xi tíhotíxoma‑la̱ i̱sò'nde jye k'oa̱s'ín tjínè‑la̱ nga kjo̱'in s'e̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Kjìn jchán kjoa̱ tjín ìsa̱ xi kj'ei̱í xi ko̱xán‑nò ta̱nga i̱'ndei̱ mìkiì titsa̱jnandaà nga kjoa̱has'en‑jiìn‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","K'e̱ nga ki̱tjojen jè Ini̱ma̱ Tsjeè‑la̱ Nainá xi nguì kjoa̱ kixi̱, jè si̱ìkixi̱ya ndaà‑nò xi nguì kjoa̱ kixi̱ nga mìtsà kjo̱hítsjeèn ts'e̱ si̱ìkjeén k'e̱ nga ki̱chja̱. K'oa̱á s'ín ki̱chja̱ koni s'ín tjín kjoa̱ xi 'nchré. Ke̱èno̱jmí‑nò kjoa̱ xi s'e̱ k'e̱ nga ko̱ma i̱skan. ");
INSERT INTO maaNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jè jeya si̱ìkíjna‑na k'e̱ nga tjoé‑la̱ 'én‑na̱ i̱kjoàn ko̱kòya‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ngats'iì xi tjín‑la̱ Na̱'èn‑na̱, ti̱koa̱á ts'a̱n‑ná. Koií k'oa̱ xan‑nò nga jè Ini̱ma̱ Tsjeè‑la̱ Nainá tjoé‑la̱ 'én xi ts'a̱n, i̱kjoàn ko̱kòya‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Jñò, tà chibaá na̱chrjein chija nga mì ti̱ kiì jcha̱xkon‑ná; xi ko̱ma jò jàn na̱chrjein ìjngoò k'a jcha̱xkon ìjngoò k'a‑ná nga jè tìfikoa̱a Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Xi̱ta̱ xi kota'yàt'aà‑la̱ k'e̱é kitsò‑la̱ xíkjín: ―Kó tsòya‑ne 'én xi tsò‑la̱: tà chibaá na̱chrjein chija‑la̱ nga mì ti̱ kiì jcha̱xkon‑ná, xi ko̱ma jò jàn na̱chrjein, ìjngoò k'a jcha̱xkon‑ná nga jè tìfikoa̱a Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kitsò‑la̱ xíkjín: ―¿Kó tsòya‑ne 'én xi tsò‑la̱: “Ta chibaá na̱chrjein chija”? Mìkiì fìya‑ná koni s'ín chja̱. ");
INSERT INTO maaNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús, ti̱k'e̱é kjòchi̱ya‑la̱ nga jñà xi̱ta̱‑la̱ mejèn‑la̱ sko̱nangui‑la̱ kó tsòya‑ne 'én xi kiìchja̱. K'e̱é kitsò‑la̱: ―¿A titsa̱chjinanguií‑la xinguio̱o kó tsòya‑ne koni s'ín kàxan‑nò: Tà chibaá na̱chrjein chija‑la̱ nga mì ti̱ kiì jcha̱xkon‑ná, xi ko̱ma jò jàn na̱chrjein ìjngoò k'a jcha̱xkon‑ná? ");
INSERT INTO maaNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nguì o̱kixi̱í xi xan‑nò, jñò, ba s'e̱‑la̱ ini̱ma̱‑nò, jchìhindáya‑nò, ta̱nga jñà xi̱ta̱ i̱sò'nde tsjaá s'e̱‑la̱ ini̱ma̱‑la̱. Jñò, na̱s'ín ba s'e̱‑nò, jè kjoa̱ ba‑nò, nga ko̱ma i̱skan, kjoa̱ tsjaá ko̱ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jngoò chjo̱ón, k'e̱ nga chóya na̱chrjein‑la̱ nga 'beé ki'ndí, tse kjo̱'in síkjeiín. Ta̱nga k'e̱ nga jye ts'iìn jè ki'ndí, mì ti̱ kiì síkítsjeèn‑ne kjo̱'in xi kasíkjeiín jè chjo̱ón. Ta̱ sa̱á tà kjo̱tsjaá s'e̱‑la̱ nga jngoò xi̱ta̱ kats'iìn i̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","O̱kixi̱‑né i̱t'aà tsa̱jòn, i̱'ndei̱, ba tjín‑nò, ta̱nga ko̱ma i̱skan, k'e̱ nga skoexkon ìjngoò k'a‑nò, k'e̱‑né nga 'ñó tsja ko̱ma‑la̱ ini̱ma̱‑nò. Jè kjo̱tsja‑nò ni̱yá xi kjoa̱áxìn‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’K'e̱ nga ki̱jchò na̱chrjein nga jcha̱xkon ìjngoò k'a‑ná, ni̱mé xi chji̱nangui‑ná. O̱kixi̱í xi xan‑nò, ni̱ta̱ mé xi si̱jé‑là Na̱'èn‑na̱ xi i̱t'aà ts'a̱n, tsjá‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Skanda i̱'ndei̱, ni̱ sà mé xi nìjé xi i̱t'aà ts'a̱n; ti̱jé, tjoé‑nò, mé‑ne nga ni̱mé xi chijat'aà‑la̱ kjo̱tsja xi tíjiìn ini̱ma̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’'Én xi tìchjàko̱‑nò, tà kjoa̱ mangásòn‑né tìsìkjeén. Ta̱nga ki̱jchò na̱chrjein k'e̱ nga mì ti̱ kiì kjoa̱ mangásòn kichjàko̱‑nò. Kèno̱jmí kixi̱í‑nò i̱t'aà ts'e̱ Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na̱chrjein jè, jñò, i̱t'aà ts'a̱án si̱jét'aà‑là Na̱'èn‑na̱. 'A̱n, mì ti̱ kiì kìtsi'bà‑tjì‑nò xi i̱t'aà tsa̱jòn, ");
INSERT INTO maaNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","nga jè sobà Na̱'èn‑na̱ matsjakeè‑nò. Koií matsjakeè‑nò nga jñò, ti̱koa̱á matsjacha‑ná ko̱ mokjeiín‑nò nga i̱t'aà ts'e̱ Nainá inchrobà‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ya̱á itjokàt'aà‑la̱ Nainá nga inchrobà i̱ i̱sò'nde. I̱'ndei̱ siìkíjna‑ná i̱sò'nde, tìfiko̱ó ìjngoò k'a‑na̱ Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ kitsò‑la̱: ―I̱'ndei̱, tinokjoà kixi̱‑né, ni̱mé kjoa̱ mangásòn tìnìkjiín. ");
INSERT INTO maaNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","I̱'ndei̱, jyeé 'ya‑je̱n nga ji̱ machi̱ya yijeé‑lè ni̱ta̱ mé kjoa̱‑ne. Mìkiì mochjeén tsà yá xi sko̱nangui‑lè. K'oa̱á ma‑ne nga mokjeiín‑naje̱n nga i̱t'aà ts'e̱ Nainá inchrobà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kiìchja̱ Jesús, kitsò‑la̱: ―I̱'ndei̱, ¿a mokjeiín‑nò? ");
INSERT INTO maaNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Jyeé kjo̱meè bijchó hora, ti̱jè‑ne hora jè, jñò, tsjohoba‑nò nga jngoò ìjngoò; onguí‑nò ni'ya‑nò; ta̱jngoò si̱kíjna‑ná. Ta̱nga mìtsà ta̱jngoò tìjna̱a, jè tíjnako̱‑na Na̱'èn‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","K'oa̱á s'ín tìchjàko̱‑nò mé‑ne i̱t'aà ts'a̱n s'e̱‑nò kjoa̱'nchán. Koa̱ i̱ i̱sò'nde kjo̱'iín s'e̱‑nò, ta̱nga 'ñó t'è‑là takòn. 'A̱n, jyeé kisìkijne‑la̱ jñà kjoa̱ xi tjín i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús, k'e̱ nga jye k'oa̱s'ín kiìchja̱, kiskoòtsejèn ngajmiì, kitsò: ―Na̱'èn, jyeé ijchò hora‑la̱, jeya ti̱kíjni Ki'ndí‑lè, mé‑ne jè Ki'ndí‑lè ti̱koa̱ ngaji̱, jeya si̱ìkíjna‑lè, ");
INSERT INTO maaNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","koni s'ín kits'iì‑la̱ kjo̱tíxoma Ki'ndí‑lè i̱t'aà ts'e̱ ngats'iì xi̱ta̱ nga tjí'nde‑la̱ nga tsjaà‑la̱ kjoa̱binachon ni̱ta̱ kjé‑ne ngats'iì xi̱ta̱ xi ji̱ kits'iì‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Jè kjoa̱binachon xi tjín ni̱ta̱ kjé‑ne, jè‑né nga skoe̱xkon‑lè, nga ta ji̱ ta̱jngoò‑né xi kixi̱ kjoa̱ nga Nainá 'mì‑lè, ti̱koa̱ skoe̱xkon Jesucristo xi Ki'ndí‑lè xi xó ji̱ kinìkasén‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’'A̱n, jeya kisìkíjna‑lè i̱ i̱sò'nde, nga jyeé kisìjngoaà xá xi ji̱ kinìnga̱tsja‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Na̱'èn, i̱'ndei̱, k'oa̱s'ín jeya ti̱kíjna‑ná nga nguixkoiìn koni tjín kjoa̱ jeya xi kis'e‑na̱ nga tsohóti̱jnat'aà‑lè k'e̱ nga ti̱kj'eè sindaà i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Jñà xi̱ta̱ i̱sò'nde xi xó ji̱ kichjaàjiìn‑ne nga 'a̱n kinìnga̱tsja‑ná, jyeé tsibeno̱jmí‑la̱ i̱t'aà tsi̱ji. Xi̱ta̱ tsi̱ji‑né, nga ji̱ kits'iì‑ná, ko̱ nchisíkitasòn‑né koni tsò 'én‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jñà xi̱ta̱ koi, i̱'ndei̱, jyeé beè nga ngats'iì kjoa̱ xi 'a̱n kits'iì‑ná, i̱t'aà tsi̱ji nchrobá‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","'A̱n, tsibeno̱jmí‑la̱ jñà 'én xi ji̱ kits'iì‑ná; jñà xi̱ta̱ koi, jahas'en‑jiìn‑la̱; jyeé kijtseè nga kixi̱ kjoa̱ nga i̱t'aà tsi̱jií inchrobà‑na̱. Mokjeiín‑la̱ nga ji̱ kinìkasén‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Jñà xi̱ta̱ koi, bìtsi'batjià. Mìtsà jñà xi̱ta̱ i̱sò'nde bìtsi'batjià; tà jñà‑né xi ji̱ kits'iì‑ná, nga̱ xi̱ta̱ tsi̱ji‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ngats'iì xi̱ta̱ xi ts'a̱n, ti̱koa̱ tsi̱ji‑né, koa̱ jñà xi̱ta̱ xi tsi̱ji, ti̱koa̱á ts'a̱n‑ná. I̱t'aà ts'e̱é xi̱ta̱ koi, nga jeya óti̱jna. ");
INSERT INTO maaNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’'A̱n, mì ti̱ kiì tse kóti̱jna‑na̱ i̱ i̱sò'nde; ta̱nga jñà xi̱ta̱ koi, i̱í kítsa̱jna i̱sò'nde. 'A̱n, ya̱á tìfikon‑lè nga ya̱ kóti̱jnako̱‑lè. Na̱'èn tsjeè, ndaà ti̱kindi̱i xi̱ta̱ koi nga ko̱ nga'ñó‑lè, ti̱jè‑ne nga'ñó xi ji̱ kits'iì‑ná mé‑ne nga ndaà kítsa̱jnajtín‑ne koni jñá ndaà titsa̱jnakjoaá ngaji̱ ko̱ 'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","K'e̱ nga tsohóti̱jnakoa̱a i̱ i̱sò'nde, ndaà kisìkinda̱a nga ko̱ nga'ñó‑lè, ti̱jè‑ne nga'ñó xi ji̱ kits'iì‑ná. Ni̱jngoò xi kichijà, tà jé kichijà jè xi k'oa̱s'ín tjínè‑la̱ nga k'oa̱s'ín ko̱mat'in, mé‑ne ki̱tasòn‑ne koni s'ín tíchja̱ Xo̱jo̱n‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Ta̱nga i̱'ndei̱ ya̱á tìfikon‑lè ñánda tijni. Jñà 'én xi tìchjà k'e̱ nga tákó i̱ tìjna̱a i̱sò'nde, koi‑né nga 'ñó ndaà kàtasijiìn ini̱ma̱‑la̱ jñà xi̱ta̱‑na̱, jè kjo̱tsja xi tíjiìn ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","'A̱n, jyeé tsibeno̱jmí‑la̱ 'én‑lè jñà xi̱ta̱‑na̱; ta̱nga jñà xi̱ta̱ i̱sò'nde síjtikeè‑né, koií‑né nga mìtsà ti̱ xi̱ta̱ ts'e̱ i̱sò'nde‑ne, ti̱koa̱á 'a̱n, mìtsà ti̱ i̱ i̱sò'nde chjà‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mìtsà xan‑lè nga chja̱àxìn i̱ i̱sò'nde, tà jè‑né xi xan‑lè nga ti̱kindi̱i i̱t'aà ts'e̱ xi̱ta̱ nei̱í. ");
INSERT INTO maaNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Koni 'a̱n mìtsà i̱ i̱sò'nde chjà‑na, ti̱koa̱á jñà xi̱ta̱‑na̱ mìtsà ti̱ i̱‑ne i̱sò'nde chja̱‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","I̱t'aà ts'e̱ kjoa̱ kixi̱‑lè, tsjeè ti̱kítsa̱jni nga nguì xi̱ta̱ tsi̱ji kàtama; nga jñà 'én‑lè, nguì kjoa̱ kixi̱‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ji̱, koni s'ín kinìkasén‑ná i̱ i̱sò'nde, 'a̱n, k'oa̱á ti̱s'ín sìkasén jñà xi̱ta̱‑na̱ i̱t'aà ts'e̱ xi̱ta̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Xi kjo̱ndaà ts'e̱ xi̱ta̱‑na̱, 'a̱n, jyeé tsjeè tìsìnga̱tsja‑lè yijo‑na̱ mé‑ne jñà xi̱ta̱‑na̱ ti̱koa̱ tsjeè si̱ìnga̱tsja‑lè yijo‑la̱ xi i̱t'aà ts'e̱ kjoa̱ kixi̱‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Mìtsà tà jñà bìtsi'batjià jñà xi̱ta̱ ts'a̱n; ti̱koa̱á bìtsi'batjì‑ná jñà xi̱ta̱ xi i̱skan ko̱kjeiín‑la̱ i̱t'aà ts'a̱n k'e̱ nga kji̱'nchré 'én‑na̱ xi ke̱èno̱jmí‑la̱ jñà xi̱ta̱‑na̱, ");
INSERT INTO maaNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","mé‑ne ngats'iì jñà xi̱ta̱ koi, tà jngoò ko̱ma‑ne, koni jñá nga jngoò ma‑ná koni s'ín tijnako̱‑ná ngaji̱ Na̱'èn, ti̱koa̱ 'a̱n tìjna̱ko̱‑lè. Jñà xi̱ta̱ koi, ti̱koa̱ kàtìtsa̱jnako̱‑ná mé‑ne jñà xi̱ta̱ i̱sò'nde ko̱kjeiín‑la̱ nga ji̱ kinìkasén‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Jè kjoa̱jeya xi ji̱ kits'iì‑ná, 'a̱n, k'oa̱á ti̱s'ín kitsjaà‑la̱ jñà xi̱ta̱‑na̱ mé‑ne nga tà jngoò ko̱ma‑ne koni jñá nga tà jngoò ma‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","'A̱n tìjna̱koa̱a jñà xi̱ta̱‑na̱ ko̱ ji̱ tijnako̱‑ná, mé‑ne nga nguì jngoò ko̱ma‑ne. K'oa̱á s'ín skoe̱‑ne jñà xi̱ta̱ i̱sò'nde nga ji̱ kinìkasén‑ná ko̱ ti̱koa̱ skoe̱ nga matsjachi jñà xi̱ta̱‑na̱ koni s'ín matsjacha‑ná 'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Na̱'èn, koií xi mejèn‑na nga jñà xi̱ta̱ xi ji̱ kits'iì‑ná ya̱ kítsa̱jnako̱‑na ñánda kóti̱jna, mé‑ne nga skoe̱‑ne kjoa̱ jeya‑na̱ xi ji̱ kits'iì‑ná nga ti̱koa̱ matsjacha‑ná skanda k'e̱ nga ti̱kj'eè sindaà i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Na̱'èn xi xi̱ta̱ kixi̱ 'mì‑lè, jñà xi̱ta̱ xi tjín i̱sò'nde, mìkiì beèxkon‑lè, ta̱nga 'a̱n, beèxkoòn‑lè. Ti̱koa̱ jñà xi̱ta̱ xi ji̱ kits'iì‑ná jye kisijiìn‑la̱ nga ji̱ kinìkasén‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Jñà xi̱ta̱‑na̱ jyeé tsibeno̱jmí yije‑la̱ i̱t'aà tsi̱ji; tákó sa̱á kèno̱jmí ìsa̱‑la̱ mé‑ne jè kjoa̱tjòcha xi tjín‑lè i̱t'aà ts'a̱n, ti̱koa̱ s'e̱‑la̱ jñà xi̱ta̱ koi, koa̱ 'a̱n sobà kóti̱jnajñaà ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús k'e̱ nga jye o̱kitsò, i̱kjoàn itjo, kiìko̱ xi̱ta̱ xi kota'yàt'aà‑la̱ ján xijngoaà xa̱jngá nandá xi 'mì Cedrón. Ya̱ kijna jngoò i̱'nde ñánda kjìn ska̱ya tsojmì títje̱; ya̱á jahas'en‑jiìn Jesús ko̱ xi̱ta̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, xi̱ta̱ xi si̱ìnga̱tsja Jesús i̱t'aà ts'e̱ xi̱ta̱ kondra̱‑la̱, jyeé beèxkon i̱'nde jè, nga Jesús, kjìn k'a ya̱ chixoñako̱ xi̱ta̱ xi kota'yàt'aà‑la̱ ya̱ i̱'nde jè. ");
INSERT INTO maaNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas, kjìn soldado ijchòko̱, tji̱ko̱ xi̱ta̱ xi síkinda̱ i̱ngo̱ xi jñà kisìkasén xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ xi̱ta̱ fariseo; 'ya ni'ín linterna, 'ya ki̱cha̱ ndojò, 'ya ni'ín nicha. ");
INSERT INTO maaNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús, nga jyeé tíjiìn yije‑la̱ kjoa̱ xi ko̱mat'in, ni̱to̱ón itjo, kitsò‑la̱: ―¿Yá xi binchaàtsjioò? ");
INSERT INTO maaNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Xi̱ta̱ koi, kitsò: ―Jè Jesús xi Nazaret i̱'nde‑la̱. Jesús kitsò‑la̱: ―'A̱n‑ná. Judas, xi̱ta̱ xi tísínga̱tsja Jesús, ti̱koa̱á ya̱ tsóbajiìn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","K'e̱ nga kitsò Jesús: “'A̱n‑ná”, xi̱ta̱ koi, kiì‑ne íts'i̱n, chixòt'aà nangui. ");
INSERT INTO maaNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús, ìjngoò k'a kiskònangui‑la̱ kitsò‑la̱: ―¿Yá xi binchaàtsjioò? Xi̱ta̱ koi kitsò: ―Jè Jesús xi Nazaret i̱'nde‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kiìchja̱ Jesús, kitsò‑la̱: ―Jyeé, k'oa̱ tìxan‑nò, 'a̱n‑ná. Tsà 'a̱n binchaàtsji‑ná, tjiì'nde‑là jñà xi̱ta̱‑na̱ xi i'nga nga kàtjì‑ne. ");
INSERT INTO maaNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","K'e̱ nga o̱kitsò Jesús, koií tsitasòn 'én xi jè kiìchja̱ k'e̱ nga kitsò: “Na̱'èn, xi̱ta̱ xi ji̱ kits'iì‑ná, ni̱jngoò kichijà.” ");
INSERT INTO maaNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jè Simón Pedro, 'ya jngoò ki̱cha̱ ndojò; tsachrje; tsajà‑la̱ xi̱ta̱ xi 'mì Malco, xi̱ta̱ chi̱'nda‑la̱ no̱'miì ítjòn; tsatet'aà líká kixi̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús kitsò‑la̱ jè Simón Pedro: ―Ti̱kájnatjò‑ne ki̱cha̱ ndojò‑lè. Tjaya‑ne chrjoa̱‑la̱. Jè kjoa̱ ts'e̱ kjo̱'in xi tsjá‑na̱ Na̱'èn‑na̱ koni s'ín mejèn‑la̱, ¿a mìtsà tjínè‑la̱ nga siìkitasoàn? ");
INSERT INTO maaNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jñà xi̱ta̱ soldado ko̱ soldado ítjòn ko̱ xi̱ta̱ judío xi síkinda̱ i̱ngo̱ ítjòn, kitsobà'ñó Jesús, i̱kjoàn chinchá na'ñó. ");
INSERT INTO maaNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ítjòn kiìko̱ ján ñánda tíjna ni'ya‑la̱ Anás, nga̱ níxáya‑la̱ ma jè Caifás xi no̱'miì ítjòn tíjna nó jè. ");
INSERT INTO maaNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jè Caifás xi o̱kitsò‑la̱ jñà xi̱ta̱ judío nga kitsò‑la̱: Mochjeén‑né nga tà jngoò xi̱ta̱ kàtiyaàtjì‑la̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro tji̱ngui‑la̱ Jesús ko̱ ìjngoò sa̱ xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, jè xi beèxkon jè no̱'miì ítjòn, jahas'en‑ko̱ Jesús ya̱ ndi̱tsin ni'ya‑la̱ no̱'miì ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ta̱nga jè Pedro, ján kiskoòñà ndi̱tsiaán; ya̱á tsibìjna xotjoa̱‑la̱ ni'ya. Jè xi̱ta̱‑la̱ Jesús xi ìjngoò, k'e̱é itjo ìjngoò k'a, kiìchja̱‑la̱ jè chjo̱ón xi síkinda̱ xotjoa̱‑la̱ ni'ya, i̱kjoàn kisìkas'en Pedro. ");
INSERT INTO maaNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jè chjo̱ón xi síkinda̱ xotjoa̱‑la̱ ni'ya, kitsò‑la̱ Pedro: ―Ngaji̱, ¿a mìtsà ti̱koa̱ ya̱ chìta'yàt'aà‑la̱ xi̱ta̱ jè? Jè Pedro, kitsò: ―Majìn. ");
INSERT INTO maaNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jñà xi̱ta̱ chi̱'nda ko̱ xi̱ta̱ xi síkinda̱ i̱ngo̱ nchat'aà‑la̱ ni'ín xi jñà tsibítse nga nchisíhiso‑la̱ yijo‑la̱ nga 'ñó 'nchán tíma. Jè Pedro ti̱koa̱ ya̱ síjna nga tísíhiso‑la̱ yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jè no̱'miì ítjòn tsibíts'ia̱ nga kiskònangui‑la̱ Jesús i̱t'aà ts'e̱ xi̱ta̱ xi kota'yàt'aà‑la̱ ko̱ i̱t'aà ts'e̱ 'én xi okóya. ");
INSERT INTO maaNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kiìchja̱ Jesús kitsò‑la̱: ―'A̱n, kichjàjiìn osen‑la̱ xi̱ta̱ nga tíjtsa i̱sò'nde. Kjit'aà na̱chrjein tsakoòya ya̱ ni'ya i̱ngo̱ sinagoga ko̱ ya̱ ndi̱tsin i̱ngo̱ ítjòn ñánda bixoña yije xi̱ta̱ judío. Ni̱mé 'én xi tìchjà 'ma. ");
INSERT INTO maaNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Mé‑ne 'a̱n chjinangui‑ná? Jñà chji̱nangui‑la̱ xi̱ta̱ xi kiì'nchré‑na, mé 'én xi tsakoòya‑la̱. Jñà xi̱ta̱ koi, ndaà tíjiìn‑la̱ kó kixan‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","K'e̱ nga jye o̱kitsò Jesús, jngoò xi̱ta̱ xi síkinda̱ i̱ngo̱ ítjòn síjnat'aà chrañà‑la̱, kisìjts'iìn‑t'aà kjín Jesús, kitsò‑la̱: ―¿Mé‑ne ko̱tsò‑ne 'én xi nokjoàkoi̱i no̱'miì ítjòn? ");
INSERT INTO maaNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús kiìchja̱ kitsò‑la̱: ―Tsà ch'o tsò 'én xi tìchjà, koa̱tìn‑ná, kó xán. Ta̱nga tsà ndaà tsò 'én xi tìchjà, ¿mé‑ne ti'bé‑ná? ");
INSERT INTO maaNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nga k'oa̱s'ín tjít'aà'ñó Jesús, jè Anás kisìkasén ñánda tíjna jè Caifás jè xi no̱'miì ítjòn tíjna koi na̱chrjein. ");
INSERT INTO maaNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jè Pedro ya̱ síjnat'aà‑la̱ ni'ín nga tísíhiso‑la̱ yijo‑la̱; jñà xi̱ta̱ koi kiskònangui‑la̱, kitsò‑la̱: ―Ngaji̱, ¿a mìtsà ti̱koa̱ ya̱ chìta'yàt'aà‑la̱ xi̱ta̱ jè? Jè Simón Pedro tsibìjna'ma, kitsò: ―Majìn, mì ya̱á kota'yàt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","I̱kjoàn kiskònangui ìjngoò‑la̱ xi̱ta̱ chi̱'nda‑la̱ no̱'miì ítjòn; xíkjín ma xi̱ta̱ xi jè Pedro tsatet'aà líká‑la̱, kitsò‑la̱: ―Ngaji̱, ya̱á kijtseèxkon‑lè ko̱ Jesús ya̱ i̱'nde ñánda tjín tsojmì tjè. ");
INSERT INTO maaNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Jè Pedro, ìjngoò k'a tsibìjna'mat'in Jesús, i̱kjoàn ni̱to̱ón kiskindàya kóxtí. ");
INSERT INTO maaNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kiìko̱‑ne Jesús ya̱ ni'ya‑la̱ Caifás skanda ján ni'ya osen ts'e̱ xi̱ta̱xá ítjòn ts'e̱ Roma. Nga jye tís'e i̱sén, jñà xi̱ta̱ judío mìkiì jahas'en ni'ya osen koni s'ín tjín kjo̱tíxoma‑la̱ nga majìn‑la̱ nga si̱ìkits'ón yijo‑la̱ mé‑ne ko̱ma ko̱kje̱n‑ne s'eí paxko̱. ");
INSERT INTO maaNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","K'oa̱á komà‑ne nga itjo ni'ya osen jè Pilato, kiskònangui‑la̱ jñà xi̱ta̱ koi, kitsò‑la̱: ―¿Mé kjoa̱ xi ongui‑nò xi̱ta̱ jè? ");
INSERT INTO maaNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jñà xi̱ta̱ judío kitsò: ―Tsà nìmé jé tjín‑la̱, mì‑la ji̱ titsa̱nìnga̱tsja‑lèje̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","K'e̱é kitsò Pilato: ―Tanguíko̱o, jñò tìndaàjiìn‑là koni s'ín tjín kjo̱tíxoma‑nò. Jñà xi̱ta̱ judío kitsò: ―Ngaje̱n mìkiì tjí'nde‑naje̱n nga ta̱xki̱ si̱k'en jngoò‑je̱n xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","K'oa̱s'ín komà‑ne nga tsitasòn 'én xi kitsò Jesús k'e̱ nga tsibéno̱jmí kós'ín ko̱mat'in k'e̱ nga ki̱yá. ");
INSERT INTO maaNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato, ìjngoò k'a jahas'en ni'ya osen, kiìchja̱‑la̱ Jesús, kitsò‑la̱: ―¿A ji̱‑né xi 'mì‑lè xi̱ta̱xá ítjòn‑la̱ xi̱ta̱ judío? ");
INSERT INTO maaNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Kiìchja̱ Jesús, kitsò‑la̱: ―¿A tà kjo̱hítsjeèn tsi̱ji‑né nga k'oa̱ tisi, a xi kj'ei̱í xi̱ta̱á o̱kitsò‑lè i̱t'aà ts'a̱n? ");
INSERT INTO maaNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato kitsò: ―'A̱n, mìtsà xi̱ta̱ judío‑ná. Jñà xi̱ta̱ na̱xa̱ndá‑lè ko̱ xi̱ta̱ sko̱‑la̱ no̱'miì, jñà xi kòfì sínga̱tsja‑na̱ i̱t'aà tsi̱ji. ¿Mé kjoa̱ xi chinchaàtsji? ");
INSERT INTO maaNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Kiìchja̱ Jesús kitsò: ―Mìtsà i̱ i̱sò'nde tjínè‑na nga kotiìxoma. Tsà k'oa̱á‑la s'ín tjín jñà xi̱ta̱‑na̱ ko̱si̱ko̱‑na nga mì ya̱ ko̱nga̱tsja ts'e̱ xi̱ta̱ judío. Ta̱nga mìtsà i̱ kotiìxoma. ");
INSERT INTO maaNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato, ìjngoò k'a kiskònangui‑la̱ kitsò‑la̱: ―Ngaji̱, ¿a xi̱ta̱xá ítjòn 'mì‑lè? Kiìchja̱ Jesús kitsò: ―Ngaji̱í xi o̱si nga xi̱ta̱xá ítjòn 'mì‑na. Koií xá kits'iìn‑na ko̱ koií xá j'i̱‑na i̱ i̱sò'nde, mé‑ne nga kèno̱jmiá i̱t'aà ts'e̱ kjoa̱ kixi̱. Ngats'iì xi fìt'aà‑la̱ kjoa̱ kixi̱, 'nchré 'én‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato kiskònangui, kitsò‑la̱: ―¿Mé‑né xi 'mì‑la̱ kjoa̱kixi̱? K'e̱ nga jye kiskònangui Pilato, ìjngoò k'a itjo ni'ya osen. Kiìkon xi̱ta̱ judío, kitsò‑la̱: ―Xi̱ta̱ jè, nìmé jé xi sakót'aà‑na i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Jñò, k'oa̱á s'ín tjín kjo̱tíxoma‑nò k'e̱ nga bitjo s'eí Paxko̱: bìjnandei̱í jngoò xi̱ta̱ xi nda̱yá títsa̱jna. ¿A mejèn‑nò nga kàtìjnandei̱í jè Xi̱ta̱xá Ítjòn‑la̱ xi̱ta̱ judío? ");
INSERT INTO maaNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ìjngoò k'a 'ñó jchán kiìchja̱ kóho̱tjín xi̱ta̱ judío, kitsò: ―Majìn, jè Jesús, mìkiì kíjnandei̱í, jè Barrabás kíjnandei̱í. Ta̱nga jè Barrabás xi̱ta̱ chijé‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato kitsjaà‑la̱ o̱kixi̱ jñà xi̱ta̱ soldado nga tsajá‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jñà soldado tsibíndaà jngoò corona na'yá, tsibí'a sko̱ Jesús, i̱kjoàn kisìkákjá jngoò nikje sko. ");
INSERT INTO maaNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kitsò‑la̱: ―A ta k'oa̱á ndaà‑ne ji̱ xi xi̱ta̱xá ítjòn‑la̱ xi̱ta̱ judío 'mì‑lè. I̱kjoàn kisìjts'iìn‑t'aà kjín. ");
INSERT INTO maaNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato itjoko̱ ìjngoò k'a ya̱ ndi̱tsin, kitsò‑la̱ jñà xi̱ta̱ na̱xa̱ndá: ―Chítsejèn‑là, i̱ j'iìko̱ ìjngoò k'a‑nò mé‑ne nga jcha̱‑nò nga nìmé jé sakót'aà‑na i̱t'aà ts'e̱ xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Itjo Jesús, tjí'a corona na'yá sko̱; íkjá nikje xi sko kjoàn; Pilato kitsò‑la̱ jñà xi̱ta̱ na̱xa̱ndá: ―I̱ síjna xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","K'e̱ nga kijtseèxkon jñà xi̱ta̱ sko̱‑la̱ no̱'miì ko̱ jñà xi̱ta̱ xi síkinda̱ i̱ngo̱, tsibíts'ia̱ nga 'ñó jchán kiìchja̱, kitsò: ―¡Tjat'aà krò! ¡Tjat'aà krò! K'e̱é kitsò jè Pilato: ―Jñò, sobà tanguíko̱o nga tjat'aà krò. 'A̱n, nìmé jé xi sakót'aà‑na i̱t'aà ts'e̱ xi̱ta̱ jè. ");
INSERT INTO maaNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Kiìchja̱ jñà xi̱ta̱xá‑la̱ xi̱ta̱ judío, kitsò‑la̱ Pilato: ―Ngaje̱n, tjín jngoò‑naje̱n kjo̱tíxoma; k'oa̱á s'ín tíchja̱ kjo̱tíxoma tsa̱je̱n: Xi̱ta̱ jè, mochjeén‑né nga ki̱yá, koií kjoa̱‑la̱ nga Ki'ndí‑la̱ Nainá tsò‑la̱ yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato, k'e̱ nga kiì'nchré 'én koi, ìsa̱á 'ñó ndaà kitsakjòn. ");
INSERT INTO maaNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilato, jahas'en ìjngoò k'a ni'ya osen, kitsò‑la̱ Jesús: ―¿Ñánda‑ne i̱'nde‑lè? Ta̱nga Jesús, mìkiì kiìchja̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato kitsò‑la̱: ―¿Mé‑ne mì nokjoà‑ná? ¿A mì 'ya‑jèn? 'A̱n, tjí'ndeé‑na nga kot'aà‑lè krò, ti̱koa̱ tjí'ndeé‑na nga siìkíjnandei̱í‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Kiìchja̱ Jesús kitsò‑la̱: ―Ni̱mé‑la xi tjí'nde‑lè i̱t'aà ts'a̱n tsà mìtsà Nainá kitsjaà‑lè. Jè xi̱ta̱ xi sínga̱tsja‑na i̱t'aà tsi̱ji, ìsa̱á tse jé tjín‑la̱ mì k'oa̱‑ne koni ji̱. ");
INSERT INTO maaNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ti̱jè‑ne hora, jè Pilato mejèn‑la̱ si̱ìkíjnandei̱í Jesús ta̱nga jñà xi̱ta̱ judío ìsa̱á 'ñó kiìchja̱ kitsò: ―Xi̱ta̱ jè, tsà si̱kíjnandei̱í‑ne, mìtsà amigo tsi̱ji ma César xi xi̱ta̱xá ítjòn tíjna ts'e̱ Roma. Ni̱ta̱ yá‑ne xi xi̱ta̱xá ítjòn tsò‑la̱ yijo‑la̱, kondra̱ ts'e̱é César. ");
INSERT INTO maaNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato, k'e̱ nga kiì'nchré 'én koi, kiìko̱ Jesús ján ndi̱tsiaán; tsibìjnasòn íxi̱le̱‑la̱ ya̱ i̱'nde ñánda 'mì I̱sòn Chrjó Nda̱jo̱; Gabatá 'mì nga 'én hebreo. ");
INSERT INTO maaNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ta̱ jngoò na̱chrjein chija‑la̱ ts'e̱ s'eí Paxko̱; jyeé kjo̱meè bijchó nchisen. Pilato, kitsò‑la̱ jñà xi̱ta̱ judío: ―¡I̱ síjna xi̱ta̱xá ítjòn‑nò! ");
INSERT INTO maaNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Jñà xi̱ta̱ judío 'ñó jchán kiìchja̱ kitsò: ―¡Kàtabiyaà! ¡Kàtabiyaà! ¡Tjat'aà krò! Pilato kitsò‑la̱: ―Xi̱ta̱xá ítjòn‑nò, ¿a krò kót'aà? Jñà xi̱ta̱ sko̱‑la̱ no̱'miì, kiìchja̱ kitsò: ―Ngaje̱n, tsjìn‑naje̱n xi̱ta̱xá ítjòn xi kj'ei̱í, tà jè ta̱ jngoò César. ");
INSERT INTO maaNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilato kisìnga̱tsja nga kàtát'aà krò. Jñà xi̱ta̱ koi kiìko̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús itjo, 'yajen krò‑la̱; ya̱á kiìko̱ ya̱ i̱'nde ñánda 'mì I̱'nde Sko̱ Mik'en, xi 'én hebreo Gólgota 'mì. ");
INSERT INTO maaNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","K'e̱ nga ijchòko̱ i̱'nde jè, tsohót'aà krò, ko̱ nguì jò xi̱ta̱ xi kj'ei̱í, íjngó íjngó kisinchaàt'aà‑la̱ nga ngobà ngobà. Jè Jesús kìsasíjna jngoò osen‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato kiskiì 'én xi tsohót'aà sko̱ krò xi tsò: “Jesús xi Nazaret i̱'nde‑la̱, Xi̱ta̱xá Ítjòn‑la̱ xi̱ta̱ judío.” ");
INSERT INTO maaNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jñà 'én koi, kjìn xi̱ta̱ judío tsibíxke̱jiìn; nga̱ ya̱ i̱'nde ñánda kisit'aà krò Jesús, ya̱á chrañàt'aà‑la̱ na̱xa̱ndá. 'Én hebreo tjít'aà ko̱ 'én griego, ko̱ 'én latín. ");
INSERT INTO maaNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jñà xi̱ta̱ sko̱‑la̱ no̱'miì ts'e̱ xi̱ta̱ judío, kitsò‑la̱ jè Pilato: ―Kì k'oa̱á s'ín chjiì xi tsò: “Xi̱ta̱xá ítjòn‑la̱ xi̱ta̱ judío.” K'oa̱á s'ín chjí xi tsò: “Xi̱ta̱ jè, k'oa̱á tsò nga jè‑né xi xi̱ta̱xá ítjòn‑la̱ xi̱ta̱ judío.” ");
INSERT INTO maaNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kiìchja̱ Pilato kitsò: ―Koni s'ín jye kàkjiaà, k'oa̱á s'ín kàtìjna. ");
INSERT INTO maaNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jñà soldado k'e̱ nga jye tsohót'aà krò Jesús, tsibíxkó nikje‑la̱; ñijòn ya kis'iìn. Íjngó íjngó ya kitsjaà‑la̱ xíkjín. Ti̱koa̱ kiskoé jè nikje ndojò‑la̱ xi x'ió kji, mìkiì kitjahaña, tà kijna ndojò‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kitsò‑la̱ xíkjín: ―Mìkiì si̱xajndá; tà si̱skáko̱‑ná yá ts'e̱ ko̱ma. Jè kjoa̱ koi k'oa̱á s'ín tsitasòn koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá nga tsò: Nikje‑na̱ kisìka'bí‑la̱ xíkjín; jè nikje ndojò‑na̱ tà kisìskáko̱‑né. Jñà soldado, k'oa̱á kis'iìn. ");
INSERT INTO maaNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ya̱á nchat'aà chrañà‑la̱ krò nea̱‑la̱ Jesús ko̱ ndichja ko̱ María chjo̱ón‑la̱ Cleofas ko̱ María Magdalena. ");
INSERT INTO maaNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús, k'e̱ nga kijtseèxkon nea̱‑la̱ ko̱ jè xi̱ta̱ xi kota'yàt'aà‑la̱ xi 'ñó matsjakeè, kitsò‑la̱ nea̱‑la̱: ―Chjo̱ón, ya̱ síjna ki'ndí‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","I̱kjoàn kitsò‑la̱ jè xi̱ta̱ xi kota'yàt'aà‑la̱ xi 'ñó matsjakeè: ―Ya̱ síjna nea̱‑lè. Skanda ti̱k'e̱‑ne jè xi̱ta̱ jè kiskoétjò jè nea̱‑la̱ ya̱ ni'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Xi jye komà, Jesús kijtseè nga jye tsitasòn yije, kitsò: ―Xíndá‑na. K'oa̱á s'ín tsitasòn koni s'ín tjít'aà Xo̱jo̱n‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ya̱á tíjna jngoò ti̱jí xi tjíya nandá vinagre. Kiskoé tsa̱nga̱, kisìka'nchi̱‑ne vinagre, i̱kjoàn tsibí'a jngoò yá, tsijmeé'a chrañà‑la̱ tso'ba Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús, k'e̱ nga jye kits'iì nandá vinagre, i̱kjoàn kitsò: ―Jyeé tsitasòn yije. Tsibíjnajteén sko̱, k'en. ");
INSERT INTO maaNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tà jngoò na̱chrjein chija‑la̱ ts'e̱ s'eí Paxko̱; jñà xi̱ta̱ judío majìn‑la̱ nga ya̱ si̱tjo̱bát'aà krò yijo‑la̱ xi̱ta̱ xi jye k'en jè na̱chrjein nìkjáya (koií kjoa̱‑la̱ nga 'ñó xkón jè s'eí Paxko̱). Tsibítsi'ba‑la̱ Pilato nga kàtatsjá o̱kixi̱ mé‑ne nga kàtakjàn‑ne nindaà chrjomí‑la̱ jñà xi̱ta̱ xi tjo̱ót'aà krò, i̱kjoàn kàtakjínáje̱n‑t'aà krò. ");
INSERT INTO maaNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kiì jñà soldado nga tsakján nindaà chrjomí‑la̱ jè xi síjna ítjòn; k'oa̱á ti̱ kisìko̱ jè xi ìjngoò xi ngásòn ta̱ña kisit'aà krò. ");
INSERT INTO maaNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ta̱nga k'e̱ nga ijchò kinchat'aà‑la̱ Jesús, kijtseè nga jye k'en. Mìkiì tsakján nindaà chrjomí‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ta̱nga jngoò soldado tsibísekjá ni̱si̱n‑la̱ jngoò ki̱cha̱ xi 'mì lanza. I̱kjoàn itjo jní ko̱ nandá. ");
INSERT INTO maaNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jè xi kijtseè kjoa̱ koi, jè‑né xi tsjá 'én nga kixi̱ kjoa̱, ko̱ jè 'én xi tsjá, nguì 'én kixi̱‑né, ndaà tíjiìn‑la̱ nga 'én kixi̱í xi béno̱jmí, mé‑ne jñò ti̱koa̱ ko̱kjeiín‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kjoa̱ koi, k'oa̱á s'ín komà mé‑ne nga tsitasòn‑ne koni s'ín tjít'aà Xo̱jo̱n‑la̱ Nainá nga tsò: “Ni̱jngoò nindaà‑la̱ ko̱kjàn.” ");
INSERT INTO maaNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ti̱koa̱á tjít'aà‑né ñánda tsò: “Jè skótsejèn‑la̱ jè xi kiskíx'a̱kjá ni̱si̱n‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","K'e̱ nga jye komà kjoa̱ koi, José xi ya̱ na̱xa̱ndá Arimatea i̱'nde‑la̱, ti̱koa̱á jè xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús ta̱nga tà tsajmeè'ma‑né nga jñà tsakjón‑la̱ xi̱ta̱ judío. Tsibítsi'ba‑la̱ Pilato nga kàtatsjá'nde‑la̱ nga kji̱ko̱ yijo‑la̱ Jesús. Pilato kitsjaà'nde‑né. José kiskónáje̱n‑t'aà krò yijo‑la̱ Jesús, i̱kjoàn kiìko̱. ");
INSERT INTO maaNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ti̱koa̱ ijchò Nicodemo, jè xi̱ta̱ xi ijchòkon jngoò k'a Jesús k'e̱ nga jñò. 'Ya chijo jne̱ xi tsjájiìn‑la̱ chijo xi 'mì mirra ko̱ áloe. Ma‑la̱ tsà katé kilo chijo xi 'ya. ");
INSERT INTO maaNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","José ko̱ Nicodemo, kiìko̱ yijo‑la̱ Jesús. Kisìkájtéjno nikje xi tjín‑la̱ chijo xi ndaà jne̱ koni s'ín tjín kjo̱tíxoma‑la̱ jñà xi̱ta̱ judío k'e̱ nga sihijiìn mik'en. ");
INSERT INTO maaNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ya̱ i̱'nde ñánda kisit'aà krò Jesús, tjín jngoò i̱'nde ñánda títje̱ tsojmì tjè; ya̱á ti̱x'á jngoò nga̱jo̱ i̱tsjó‑la̱ mik'en xi nguì xi̱tse̱, ñánda ni̱ saà jngoò mik'en sijnaya. ");
INSERT INTO maaNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ya̱á kisìkájna yijo‑la̱ Jesús nga ìsa̱ chrañàt'aà nga jyeé tímats'ia̱ na̱chrjein nìkjáya ts'e̱ xi̱ta̱ judío, jè víspera‑la̱ s'eí Paxko̱. ");
INSERT INTO maaNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jè na̱chrjein nga tàts'en xomàna̱, jè María Magdalena 'ñó ta̱jñòya kiì, nga kiì katsejèn‑la̱ i̱tsjó ñánda kisìhijiìn Jesús; tákó jñò choòn k'e̱ nga kiì. K'e̱ nga ijchò, kijtseè nga jye kitjaàxìn nda̱jo̱ xi tíchjoàjto‑ne jè nga̱jo̱ i̱tsjó. ");
INSERT INTO maaNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","K'e̱é tsangachikon, kiìkon ñánda tíjna Simón Pedro ko̱ xi̱ta̱ xi ìjngoò xi ti̱koa̱ ya̱ kota'yàt'aà‑la̱ Jesús, jè xi 'ñó matsjakeè, kitsò‑la̱: ―Jñà xi̱ta̱, jyeé kiìko̱ jè Na̱'èn‑ná. Mìkiì 'yaá ñánda kisìkájna. ");
INSERT INTO maaNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro ko̱ xi̱ta̱ xi ìjngoò xi ngásòn ya̱ kiskoòta'yàt'aà‑la̱ Jesús, kiì katsejèn‑la̱ jè nga̱jo̱ i̱tsjó. ");
INSERT INTO maaNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ingajò xi̱ta̱ koi, 'ñó jchán tsangachikon, ta̱nga jè xi ìjngoò, ìsa̱á 'ñó tsangachikon mì k'oa̱á‑ne koni jè Pedro. Ìsa̱á ítjòn ijchò ya̱ nga̱jo̱ i̱tsjó‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","K'e̱ nga tsasìñia kiskoòtsejèn‑s'en nga̱jo̱, kijtseè nga tà jñà nikje‑la̱ kjioò, ta̱nga mìkiì jahas'en‑ngui ya̱ nga̱jo̱. ");
INSERT INTO maaNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","I̱kjoàn ijchò tji̱ngui Simón Pedro, jè‑né xi jahas'en‑ngui nga̱jo̱ i̱tsjó, ti̱koa̱ kijtseè nga tà jñà nikje‑la̱ kjioò. ");
INSERT INTO maaNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ti̱koa̱ kijtseè jè nikje xi kisìjtéjiìn sko̱ Jesús. Mìtsà ya̱ tsátijiìn‑la̱ nikje xi i'nga. Xìn kijna nga tíxkóya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","K'e̱é jahas'en‑ngui xi̱ta̱ xi ìjngoò, jè xi ijchò ítjòn; kijtseè kjoa̱ xi komà, kòkjeiín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kj'eè kiì ndaà machi̱ya‑la̱ nga k'oa̱s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá nga jè Jesús, k'oa̱á s'ín tjínè‑la̱ nga kjoa̱áya‑la̱ i̱t'aà ts'e̱ kjoa̱biyaà. ");
INSERT INTO maaNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús, kiì‑ne ni'ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ta̱nga jè María Magdalena, ya̱á tsibìjna ndi̱tsiaán nga tíkjindáyat'aà‑la̱ nga̱jo̱ i̱tsjó; k'e̱ nga tíkjindáya tsasìñia nga kiskoòtsejèn‑s'en jè nga̱jo̱ i̱tsjó‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Kijtseè jò àkja̱le̱ xi nikje chroba íkjá. Jngoò tíjna ya̱ sko̱ ñánda kisijna yijo‑la̱ Jesús; jè xi ìjngoò ya̱ tíjnangui ndso̱ko̱. ");
INSERT INTO maaNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Jñà àkja̱le̱, kitsò‑la̱ María: ―Ji̱ ndí chjo̱ón, ¿mé‑ne tìchìhindáya‑ne? Jè María kitsò: ―Koií tìkjindáya‑na, jyeé kiìko̱ xi̱ta̱ yijo‑la̱ Na̱'èn‑na̱; mìkiì be ñánda kisìkájna. ");
INSERT INTO maaNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","María k'e̱ nga o̱kitsò, kisìkátji sko̱, kijtseè Jesús nga ya̱ síjna, ta̱nga mìkiì beè tsà jè‑né. ");
INSERT INTO maaNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús kitsò‑la̱: ―Ji̱ ndí chjo̱ón, ¿mé‑ne chìhindáya‑ne? ¿Yá xi binchaàtsji? Jè María, k'oa̱á s'ín kisìkítsjeèn, maá‑la̱ tsà jè xi̱ta̱ xi síkinda̱ i̱'nde jè, kitsò‑la̱: ―Ji̱ na̱'èn, tsà ji̱ kiìkoi̱i, ko̱t'ìn‑ná ñánda kinìkájnei mé‑ne nga kíkjaá‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús kiìchja̱‑la̱ kitsò‑la̱: ―¡María! Ko̱ jè María, kisìkátji, kitsò‑la̱: ―¡Raboni! ―'én hebreo xi tsòya‑ne: Maestro. ");
INSERT INTO maaNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús, kitsò‑la̱: ―Kì 'a̱n nìko̱‑ná nga kj'eè kiì fì mijìn‑koa̱a jè Na̱'èn‑na̱. Ta̱nga t'in ti̱kí'nchré jñà 'ndsè, ko̱t'ìn‑la̱ nga jye tìfikoa̱a jè Na̱'èn‑na̱ jè xi ti̱koa̱ Na̱'èn‑nò ma, jè xi Nainá xan‑la̱, xi ti̱koa̱ Nainá 'mì‑là. ");
INSERT INTO maaNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","María Magdalena kiì kisìkí'nchré jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús nga jye kijtseèxkon Jesús, ti̱koa̱ tsibéno̱jmí‑la̱ 'én xi kiìchja̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","K'e̱ nga jye kòjñò, ti̱jè‑ne na̱chrjein nga tàts'en xomàna̱, jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús tíchjoàjto‑la̱ xotjoa̱‑la̱ ni'ya ñánda chixoña nga jñà tsakjón‑la̱ xi̱ta̱ judío. Jesús jahas'en ni'ya, tsasìjnajiìn osen‑la̱ xi̱ta̱‑la̱, kisìhixat'aà, kitsò‑la̱: ―¿A ta k'oa̱á ndaà‑ne? Kàtas'e‑nó kjoa̱'nchán. ");
INSERT INTO maaNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","K'e̱ nga jye o̱kitsò‑la̱, tsakó‑la̱ tsja ko̱ nindaà ni̱si̱n‑la̱. Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ 'ñó tsja kis'e‑la̱ k'e̱ nga kijtseè Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús, ìjngoò k'a kitsò‑la̱: ―Jñò, kàtas'e‑nò kjoa̱'nchán. Koni s'ín kisìkasén‑na Na̱'èn‑na̱, jñò, k'oa̱á ti̱s'ín siìkasén‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","K'e̱ nga jye o̱kitsò, i̱kjoàn kiskìnomájno, kitsò‑la̱: ―Chjoé jè Ini̱ma̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jñà xi̱ta̱ xi jñò si̱jchàat'aà‑là jé‑la̱, jcha̱t'aà‑la̱, jñá xi jñò mìkiì si̱jchàat'aà‑là jé‑la̱, k'oa̱á s'ín kítsa̱jna nga mìkiì jcha̱t'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús xi tejò ma‑ne, jngoò xi 'mì Tomás, xi ti̱koa̱ Dídimo tsò‑la̱ 'én xi tsòya‑ne: Ti'ño̱, mìkiì ya̱ tíjna k'e̱ nga ijchò Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jñà xi̱ta̱ xi i'nga xi ti̱koa̱ ya̱ kota'yàt'aà‑la̱ Jesús, kitsò‑la̱ Tomás: ―Kà'ya‑náje̱n Na̱'èn‑ná Jesús. Tomás kitsò: ―Tsà mìkiì skoeè tsja ñánda kisinchaàs'en xó, ko̱ tsà mìkiì skinìs'en na̱jmá ndsa̱a ñánda kitáx'a̱, ko̱ tsà mìkiì skinìs'en ndsa̱a ya̱ ni̱si̱n‑la̱, mìkiì ko̱kjeiín‑na. ");
INSERT INTO maaNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Xi jye komà jiìn na̱chrjein, jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús ìjngoò k'a ya̱ títsa̱jna; jyeé ya̱ tíjna‑ne Tomás; ta̱nga jè xotjoa̱ ni'ya tíchjoàjto‑né. Ijchò Jesús, tsasíjnajiìn osen‑la̱, kitsò‑la̱: ―Jñò, kàtas'e‑nò kjoa̱'nchán. ");
INSERT INTO maaNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jesús, i̱kjoàn kitsò‑la̱ Tomás: ―Chi̱nìs'in na̱jnóndsei̱i i̱jndé, chítsejèn‑la̱ ndsa̱a. Nchrobákoi̱i ndsei̱i, chi̱nìs'in ni̱si̱n‑na̱. Kì k'oa̱á s'ín mìkiì mokjeiín‑lè. Kàtakjeiín‑lè. ");
INSERT INTO maaNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","K'e̱é kiìchja̱ Tomás, kitsò: ―¡Ji̱ xi Na̱'èn xan‑lè ko̱ xi Nainá xan‑lè! ");
INSERT INTO maaNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús kitsò‑la̱: ―Ngaji̱ Tomás, koií kjoa̱‑la̱ mokjeiín‑lè nga kà'ya‑ná. ¡Mé tà ndaà‑la̱ jñà xi̱ta̱ xi mokjeiín‑la̱ na̱s'ín mìkiì beèxkon‑na! ");
INSERT INTO maaNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ta̱xki̱ kjìn jchán kjo̱xkón kis'iìn ìsa̱ Jesús nga nguixko̱n xi̱ta̱ xi kota'yàt'aà‑la̱ xi mìkiì tjít'aà xo̱jo̱n jè. ");
INSERT INTO maaNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tà jñà 'én koi k'oa̱s'ín kitjei mé‑ne nga ko̱kjeiín‑nò nga Jesús, jè xi Cristo, jè xi xó kinìkasén‑ne xi Ki'ndí‑la̱ Nainá. Ko̱ mé‑ne k'e̱ nga ko̱kjeiín‑nò s'e̱é‑nò kjoa̱binachon xi i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jesús, ìjngoò k'a tsakó‑la̱ yijo‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ ya̱ i̱ndiì ndáchikon xi 'mì Tiberias. Jñà kjoa̱ koi, kiís'ín komà. ");
INSERT INTO maaNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Títsa̱jna kjoò Simón Pedro ko̱ Tomás, xi ti̱koa̱ Dídimo tsò‑la̱ 'én xi tsòya‑ne: Ti'ño̱, ko̱ Natanael xi Caná i̱'nde‑la̱, nangui xi chja̱‑ne Galilea. Ti̱koa̱ títsa̱jna jñà i̱xti‑la̱ Zebedeo ko̱ nguì jò ìsa̱ xi̱ta̱ xi ti̱koa̱ ya̱ kota'yàt'aà‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro kitsò‑la̱ xi̱ta̱ xíkjín: ―Ti̱n kó‑lá tífì tsobà'ñoá nga sik'èn. Jñà xi̱ta̱ xi i'nga, kitsò‑la̱: ―Ti̱koa̱ onguíko̱‑lèje̱n. I̱kjoàn kiì, jahas'en jngoò chitso. Ta̱nga ni̱tje̱n jè, ni̱mé ti̱n kisakò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","K'e̱ nga jye kis'e i̱sén, Jesús tsatsejèn, tsasìjna ya̱ i̱ndiì nandá, ta̱nga jñà xi̱ta̱ xi kota'yàt'aà‑la̱ mìkiì kijtseèxkon tsà jè Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús kitsò‑la̱: ―I̱xti, ¿a kj'eè sakó chiba‑nò ti̱n? Jñà xi̱ta̱‑la̱ kitsò: ―Majìn, ni̱mé tjín. ");
INSERT INTO maaNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jè Jesús, k'e̱é kitsò‑la̱: ―Ti̱katje̱n‑ngui‑ndá na̱'ya‑nò ya̱ kixi̱ xijngoaà chitso. Sa̱kò‑nò ti̱n. Jñà xi̱ta̱ koi, k'oa̱á s'ín kisìkatje̱n‑ngui‑ndá na̱'ya‑la̱. K'e̱ nga tsachrjekàjiìn‑ne, jye mì ti̱ kiì ma bitjokàjiìn‑ne na̱'ya‑la̱ nga 'ñó jchán kjìn ti̱n 'ncha. ");
INSERT INTO maaNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jè xi̱ta̱‑la̱ Jesús xi 'ñó matsjakeè xi ngásòn ya̱ kota'yàt'aà‑la̱ Jesús, kitsò‑la̱ jè Simón Pedro: ―Jè Na̱'èn‑ná Jesús xi o̱kji. Simón Pedro, k'e̱ nga kiì'nchré nga jè Na̱'èn‑ná Jesús, ni̱to̱ón tsohòkjá na̱chro̱‑la̱ (nga sa̱ ítjòn tà nikje kjinguií íkjá), i̱kjoàn kiskìngui nandá nga kiìtji̱ngui‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jñà xi̱ta̱ xi i'nga xi ngásòn ya̱ kota'yàt'aà‑la̱, kiìko̱ jè chitso; tífejiìn nandá jè na̱'ya ti̱n nga kjìn jchán ti̱n 'ncha; nga mìtsà kjiìn kijna jè chitso; tjín‑la̱ tsà jngoò sìndo̱ metro ñánda kijnajiìn nandá. ");
INSERT INTO maaNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Xi̱ta̱ koi, k'e̱ nga tsitajen chitso, kijtseè i̱t'aà nangui tjítse jngoò ni'ín. Jngoò ti̱n tímatsjò, ti̱koa̱ kijtseè i̱nchra̱jín. ");
INSERT INTO maaNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús kitsò‑la̱: ―Nchrohóko̱o i'nga ti̱n xi sa̱ jye kitjoé‑nò. ");
INSERT INTO maaNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro, jahas'en chitso. Kiskoé na̱'ya ti̱n, tsibífet'aà nangui. Jngoò sìndo̱ ko̱ icháte jàn ma‑ne jñà ti̱n iì xi 'ncha na̱'ya. Na̱s'ín 'ñó kjìn ma‑ne ti̱n, jè na̱'ya mìkiì kixajndà. ");
INSERT INTO maaNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús kitsò‑la̱: ―Nchrobá, ti̱chioò. Ta̱nga ni̱jngoò xi̱ta̱ xi kota'yàt'aà‑la̱ kitsò ikon nga kiskònangui‑la̱ yá‑né jè. Nga̱ jyeé tíjiìn‑la̱ nga jè Na̱'èn‑ná Jesús. ");
INSERT INTO maaNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús, kiì kasìt'aà chrañà‑la̱, kiskoé i̱nchra̱jín, kitsjaà‑la̱ jñà xi̱ta̱ koi, k'oa̱á ti kisìko̱ jñà ti̱n. ");
INSERT INTO maaNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ya̱ ma‑ne jàn k'a nga tsakó‑la̱ yijo‑la̱ Jesús jñà xi̱ta̱ xi kota'yàt'aà‑la̱, k'e̱ nga jye jaáya‑la̱ i̱t'aà ts'e̱ kjoa̱biyaà. ");
INSERT INTO maaNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","K'e̱ nga jye tsakjèn, Jesús kiskònangui‑la̱ Simón Pedro, kitsò‑la̱: ―Ji̱, Simón, ti‑la̱ Jonás, ¿a ìsa̱á ndaà matsjacha‑ná mì k'oa̱‑ne koni jñà koi? Pedro kitsò: ―Jon Na̱'èn, jyeé 'yi nga matsjake̱‑lè. Jesús kitsò‑la̱: ―Ti̱kindi̱i jñà ndí i̱xti orrè‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Xi ma‑ne jò k'a, Jesús ìjngoò k'a kiskònangui‑la̱, kitsò‑la̱: ―Simón, ti‑la̱ Jonás, ¿a matsjacha‑ná? Kiìchja̱ Pedro, kitsò: ―Jon Na̱'èn, jyeé 'yi nga matsjake̱‑lè. Jesús kitsò‑la̱: ―Ti̱kindi̱i jñà orrè‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Xi ma‑ne jàn k'a, ìjngoò k'a kiskònangui‑la̱ kitsò‑la̱: ―Simón, ti‑la̱ Jonás, ¿a matsjacha‑ná? Pedro, ba kis'e‑la̱ nga ma‑ne jàn k'a nga kjònangui‑la̱ tsà nga matsjakeè‑né. Kitsò‑la̱: ―Na̱'èn, 'ya yije‑né, jyeé tíjiìn‑lè nga matsjake̱‑lè. Jesús kitsò‑la̱: ―Ti̱kindi̱i jñà orrè‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nguì o̱kixi̱í xi xan‑lè, k'e̱ nga ti̱sa̱ ti titsjoi, ji̱ ta̱jngoó kichíkjeí nikje‑lè k'e̱ nga k'iìn ñánda mejèn‑lè nga k'oín. Ta̱nga k'e̱ nga jye ko̱jchíngui, tà kjoén‑né ndsei̱i. Kj'ei̱í xi̱ta̱á si̱ìkákjá‑lè nikje‑lè, kjoi̱ko̱‑lè ñánda nga majìn‑lè nga k'oín. ");
INSERT INTO maaNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesús, koií o̱kitsò‑ne, jè kjoa̱ tsibéno̱jmíya kós'ín ko̱mat'in Pedro k'e̱ nga ki̱yá mé‑ne nga jeya si̱ìkíjna‑ne Nainá. K'e̱ nga jye o̱kitsò Jesús, i̱kjoàn kitsò‑la̱ Pedro: ―Nchrobátji̱ngui‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro, k'e̱ nga kiskoòtsejèn‑ne íts'i̱n, kijtseè jè xi̱ta̱‑la̱ Jesús xi 'ñó matsjakeè xi ngásòn ya̱ kota'yàt'aà‑la̱ nga tífìtji̱ngui‑la̱. Ti̱jè‑ne xi̱ta̱ xi ta̱ña tsibìtsa̱jnakjoò Jesús k'e̱ nga tsakjèn. Jè xi kiskònangui‑la̱ nga kitsò‑la̱: “¿Yá‑né xi si̱ìnga̱tsja‑lè i̱t'aà ts'e̱ xi̱ta̱ kondra̱‑lè?” ");
INSERT INTO maaNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro, k'e̱ nga kijtseè, kiskònangui‑la̱ Jesús, kitsò‑la̱: ―Na̱'èn, xi̱ta̱ jè, ¿mé xi ko̱mat'in? ");
INSERT INTO maaNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kiìchja̱ Jesús, kitsò‑la̱: ―Tsà 'a̱n xi mejèn‑na nga kíjnakon skanda k'e̱ nga kjoia̱a ìjngoò k'a, mìtsà ji̱ oko̱‑lè. Ngaji̱, nchrobátji̱ngui‑ná. ");
INSERT INTO maaNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","K'oa̱á s'ín komà‑ne nga tsabísòn 'én koi. Ngats'iì xi̱ta̱ 'ndse̱ kitsò nga jè xi̱ta̱ jè, mìkiì ki̱yá; ta̱nga Jesús mìtsà kitsò nga mìkiì ki̱yá. Kitsò‑né: “Tsà 'a̱n xi mejèn‑na nga kíjnakon skanda k'e̱ nga kjoia̱a ìjngoò k'a, mìtsà ji̱ oko̱‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ti̱jè‑ne xi̱ta̱ xi kota'yàt'aà‑la̱ Jesús xi tíbéno̱jmí kixi̱ ngats'iì kjoa̱ koi. Ko̱ ti̱jè‑ne xi kiskiì yije xo̱jo̱n jè. Ko̱ 'ya‑ná nga 'én kixi̱í xi chja̱. ");
INSERT INTO maaNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús kjìn jchán kjoa̱ kis'iìn‑ìsa xi kj'ei̱í. Tsà tjeí yije nga jngoò jngoò ska̱ya kjoa̱ xi kis'iìn, mì‑la kiì ki̱chìya‑la̱ nga tíjtsa i̱sò'nde jñà xo̱jo̱n. K'oa̱s'ín kàtama.");
INSERT INTO maaNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ngaji̱ Na̱'èn Teófilo, jè xo̱jo̱n xi 'a̱n kiskiì ítjòn‑lè, k'oa̱á kixan‑lè ngats'iì kjoa̱ xi kis'iìn ko̱ xi tsakóya Jesús kóni nga tsibíts'ia̱ nga kisìxá ");
INSERT INTO maaNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","skanda jè na̱chrjein k'e̱ nga Nainá kiìko̱ ìjngoò k'a‑ne ján ngajmiì. K'e̱ nga ti̱kj'eè fì‑ne ján ngajmiì, jè nga'ñó‑la̱ Ini̱ma̱ Tsjeè‑la̱ kisìkjeén nga jaàjiìn xi̱ta̱ xi tsibíxáya‑la̱ nga kitsjaà‑la̱ kjo̱tíxoma mé xá xi s'i̱in. ");
INSERT INTO maaNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","K'e̱ nga k'en ko̱ nga jaáya‑la̱ i̱t'aà ts'e̱ kjo̱biyaà nguì ichán na̱chrjein tsibìjna ìsa̱; kjìn k'a tsakó‑la̱ yijo‑la̱ jñà xi̱ta̱‑la̱ ko̱ kjìn sko̱ya kjoa̱ kis'iìn nga kixi̱ kjoa̱ nga tíjnakon. Ti̱koa̱á tsakóya‑la̱ xi̱ta̱‑la̱ kós'ín otíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","K'e̱ nga tíjnako̱ xi̱ta̱‑la̱ k'oa̱á s'ín kitsjaà‑la̱ o̱kixi̱, kitsò‑la̱: ―Kì tà chjà bitjojñoò na̱xa̱ndá Jerusalén. Chíña kjoa̱a skanda k'e̱ nga ki̱tjojen kjo̱ndaà xi tsjá Na̱'èn‑na̱ koni s'ín kitsjaà tso'ba. Jyeé k'oa̱s'ín kixan‑nò nga sa̱ ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kixi̱í kjoa̱, jè Juan, nandá kis'iìn‑ne bautizar xi̱ta̱. Ta̱nga jñò, machrañà na̱chrjein nga ko̱ Ini̱ma̱ Tsjeè‑la̱ Nainá ko̱ma‑nò bautizar. ");
INSERT INTO maaNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jñà xi̱ta̱ xi títsa̱jnako̱ Jesús, kiskònangui‑la̱, kitsò‑la̱: ―Na̱'èn, xi ji̱ otìxoma‑náje̱n, jñà na̱chrjein koi, ¿a si̱kíjnandei̱í ìjngoò k'a‑ne na̱xa̱ndá Israel nga ta jè ta̱jngoò ko̱tìxoma‑la̱ yijo‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús kitsò: ―Mìtsà jñò oko̱‑nò nga jcha̱a na̱chrjein; ta̱ jngoò Na̱'èn‑ná beè kó s'ín kosòn‑la̱ xi kjo̱tíxoma ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ta̱nga k'e̱ nga ki̱tjojen‑nè‑nò jè Ini̱ma̱ Tsjeè‑la̱ Nainá, tjoé‑nò nga'ñó‑la̱. Jñò kéno̱jmí‑là xi̱ta̱ xi i̱t'aà ts'a̱n i̱ Jerusalén, kóho̱kji nga kijndà nangui Judea ko̱ Samaria, skanda ñánda fehet'aà‑ne i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","K'e̱ nga jye o̱kitsò Jesús, i̱kjoàn kitjámijìn i'nga nga kiìko̱ ìjngoò k'a Nainá ján ngajmiì ko̱ jñà xi̱ta̱‑la̱ nchikotsejèn‑la̱. Chaán mì ti̱ kiì kijtseè‑ne nga jè ifi tsibíjtsa'ma. ");
INSERT INTO maaNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jñà xi̱ta̱‑la̱, k'e̱ nga nchikotsejèn‑la̱ nga tífì‑mijìn ngajmiì Jesús, tà ni̱to̱ón j'iì kinchat'aà jò‑la̱ xi̱ta̱ xi íkjá nikje chroba. ");
INSERT INTO maaNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kitsò jñà xi̱ta̱ koi: ―Jñò xi xi̱ta̱ Galilea tsa̱jòn, ¿mé‑ne ko̱s'ín chìtsejèn‑nò ngajmiì? Jè Jesús, koni s'ín kà'yaà nga kòfìmijìn ìjngoò k'a‑ne ngajmiì, ki̱jchò na̱chrjein nga k'oa̱ ti̱s'ín kjoi̱í ìjngoò k'a‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús inchrobà‑ne nindoò Yá Olivo nga kiì ìjngoò k'a‑ne Jerusalén. K'oa̱á kji chrañàt'aà fì ndi̱yá Jerusalén koni kji tsjá'nde kjo̱tíxoma nga ma fì xi̱ta̱ k'e̱ nga na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","K'e̱ nga ijchò‑ne na̱xa̱ndá Jerusalén, kiìmijìn i̱sò'nga ni'ya, jahas'en cuarto ñánda síkjáya. Jñà xi̱ta̱ xi ijchò, jè Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo ki'ndí‑la̱ Alfeo, Simón Celote, Judas, ti‑la̱ Jacobo. ");
INSERT INTO maaNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ngats'iì xi̱ta̱ koi ya̱á bixoña nga kjit'aà na̱chrjein nga jngoò tjín kjo̱hítsjeèn‑la̱ nga chja̱t'aà‑la̱ ti̱koa̱ bítsi'ba‑la̱ Nainá; ti̱koa̱á títsa̱jna i'nga íchjín ko̱ María xi nea̱‑la̱ Jesús ko̱ jñà 'ndse̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Jñà na̱chrjein koi, Pedro, kiìchja̱jiìn‑la̱ xi̱ta̱ xíkjín xi mokjeiín‑la̱ i̱t'aà ts'e̱ Cristo. Maá‑là tsà jngoò sìndo̱ ko̱ kaàn jñà xi̱ta̱. Pedro kitsò: ");
INSERT INTO maaNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―'Ndsè, tjín‑ne nga ki̱tasòn koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá jñà 'én xi kjòtseé kiìchja̱ Ini̱ma̱ Tsjeè‑la̱ Nainá nga jè xi̱ta̱xá ítjòn David kisìkjeén nga kiìchja̱ mé xi ko̱mat'in Judas, jè xi kiìkakó‑la̱ xi̱ta̱ xi kitsobà'ñó Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas, nga xi̱ta̱ xingui̱‑náje̱n. Ti̱koa̱á kitjoé‑la̱ xá nga ngaje̱n kisìxáko̱‑naje̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jè to̱n xi kisìkijne Judas i̱t'aà ts'e̱ jé xi tsohótsji, nanguií tsatse jngoò 'nde‑ne; i̱kjoàn sko̱ kiskaànguit'aà‑ne nangui, jngoò k'a kixojndà i̱ndso̱'ba̱, itjo ndó'ye‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","K'e̱ nga jye kiì'nchré yije xi̱ta̱ na̱xa̱ndá Jerusalén nga jye k'en Judas, i̱'nde jè, k'oa̱á s'ín tsibít'aà 'ín nga Acéldama kitsò‑la̱. 'Én ts'e̱ xi chja̱, tsòyaá‑ne: “I̱'nde ts'e̱ Jní‑né.” ");
INSERT INTO maaNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Jè xo̱jo̱n ts'e̱ Salmo, k'oa̱á s'ín tíchja̱ nga tsò: Ni'ya‑la̱ kàtasijna tiya‑né, ni̱jngoò xi̱ta̱ kítsa̱jnaya. Ti̱koa̱á tíchja̱ Salmo ñánda tsò: Kj'ei̱í xi̱ta̱ kàt'iì‑la̱ xá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Mochjeén‑né nga kj'ei̱í xi̱ta̱ sakó ìjngoò‑ìsa xi jè ngajo‑la̱ Judas; jñà chjaàjiìn‑jngoaá xi̱ta̱ xi kjòtseé tjímako̱‑ná skanda k'e̱ nga ti̱sa̱ tsajmeiìko̱‑ná Jesús, ");
INSERT INTO maaNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","mats'ia̱ko̱‑ne nga kis'iìn bautizar Juan skanda k'e̱ nga tsijin ìjngoò k'a‑ne Jesús ján ngajmiì, mé‑ne nga kíjnako̱‑ná ti̱koa̱ tsjá 'én nga Jesús jyeé jaáya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","K'e̱é tsafaájiìn jò xi̱ta̱: jngoò xi 'mì José, ti̱koa̱ tjít'aàsòn 'ín‑la̱ nga Barsabás 'mì. Barsabás, ko̱ ti̱jè‑ne xi 'mì Justo. Xi ìjngoò, Matías 'mì. ");
INSERT INTO maaNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","I̱kjoàn kiìchja̱t'aà‑la̱ Nainá kitsò: ―Ngaji̱ Na̱'èn, xi yaxkoin ini̱ma̱‑la̱ ngats'iì xi̱ta̱, ko̱t'ìn‑náje̱n ñá‑la̱á ingajò xi̱ta̱ koi jye kàchjaàjiìn, ");
INSERT INTO maaNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mé‑ne nga skoé xá‑lè xi ji̱ bíxáya‑la̱, jè xá xi kisìkíjna Judas k'e̱ nga tsohótsji jé, nga jye tíjna i̱'nde ñánda oko̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kisìskákjoò suerte‑la̱. Jè Matías kisìkijne. Jè komà‑ne tejò xi̱ta̱ xi tsibíxáya‑la̱ Jesús xi tejngoò ma nga sa̱ ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","K'e̱ nga ijchò na̱chrjein‑la̱ s'eí Pentecostés, ngats'iì xi̱ta̱ xi mokjeiín‑la̱ i̱t'aà ts'e̱ Cristo ta̱ jngoò jtín títsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tà ni̱to̱ón kina'yà jngoò‑la̱ xi 'ñó one, koni jngoò tjo̱ xi 'ñó tí'ba xi ngajmiì inchrobà‑ne. Kina'yà‑la̱ kóho̱kji i'nga ni'ya ñánda títsa̱jna jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tsatsejèn‑la̱ ni̱je̱n xi koni kjoàn ni'ín kjoàn; kjòxkoa̱ya íjngó íjngó kisijnasòn‑la̱ jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ngats'iì xi̱ta̱, jngoò k'a ndaà kis'ejiìn ini̱ma̱‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá; i̱kjoàn tsibíts'ia̱ nga kiìchja̱ 'én‑la̱ xi̱ta̱ xi kj'ei̱í na̱xa̱ndá koni s'ín kitsjaà‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá nga ki̱chja̱. ");
INSERT INTO maaNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na̱chrjein koi, kjìn xi̱ta̱ judío títsa̱jna xi ijchò s'eí ya̱ na̱xa̱ndá Jerusalén xi beèxkón Nainá xi inchrobà‑ne ñánda nga xìn na̱xa̱ndá nga tíjtsa i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jñà xi̱ta̱ xi ya̱ títsa̱jna xi ijchò s'eí ya̱ na̱xa̱ndá Jerusalén, ngats'iì kjòxkóya k'e̱ nga kiì'nchré‑la̱ xi jane. Ti̱koa̱á tà kjòxkón‑la̱ k'e̱ nga kiì'nchré‑la̱ xi̱ta̱‑la̱ Cristo nga ma‑la̱ chja̱ nga jngoò ìjngoò sko̱ya 'én‑la̱ xi̱ta̱ xi xìn na̱xa̱ndá‑la̱ xi ya̱ títsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tà k'oa̱á komà‑la̱, ti̱koa̱á tà kjòxkón‑la̱, kitsò‑la̱ xíkjín: ―¿A mìtsà xi̱ta̱ Galilea ngats'iì xi̱ta̱ xi nchichja̱? ");
INSERT INTO maaNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Kós'ín ma‑ne nga na'yá‑lá 'én‑ná xi nokjoá nga xìn na̱xa̱ndá‑ná nga ìjngoò jngoá? ");
INSERT INTO maaNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ngats'iaá xi i̱ titsa̱jnaá, tjín xi̱ta̱ Partia, xi̱ta̱ Media, xi̱ta̱ Elam, xi̱ta̱ Mesopotamia, xi̱ta̱ Judea, xi̱ta̱ Capadocia, xi̱ta̱ Ponto, xi̱ta̱ Asia, ");
INSERT INTO maaNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","xi̱ta̱ Frigia, xi̱ta̱ Panfilia, xi̱ta̱ Egipto, xi̱ta̱ Libia xi ya̱ chrañàt'aà‑la̱ Cirene. Ti̱koa̱ tjín xi̱ta̱ Roma xi i̱ títsa̱jna Jerusalén. Tjín xi nguì xi̱ta̱ judío. Ti̱koa̱á tjín xi tà jahatjìya‑la̱ nga xi̱ta̱ judío komà. ");
INSERT INTO maaNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ti̱koa̱á tjín xi inchrobà‑ne Creta ko̱ Arabia. ¡Ngats'iaá na'yà‑lá nga jngoò ìjngoò sko̱ya 'én‑ná koni s'ín béno̱jmí‑ná kjo̱xkón xi s'ín Nainá! ");
INSERT INTO maaNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ngats'iì xi̱ta̱ tà kisinchaàxkón‑né, mì ti̱ kiì machi̱ya‑la̱, kitsò‑la̱ xíkjín: ―¿Kó tsòya‑ne kjoa̱ koi? ");
INSERT INTO maaNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tjín i'nga xi̱ta̱ xi tà tsijnòkeè‑né, kitsò: ―¡Ch'i̱í xi̱ta̱ koi! ");
INSERT INTO maaNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","K'e̱é tsasíjna kixi̱ Pedro ko̱ xi̱ta̱ xi tejngoò ma‑ne; 'ñó kiìchja̱jiìn‑la̱ xi̱ta̱, kitsò: ―Jñò, xi̱ta̱ xinguia̱á xi judío 'mì‑ná ko̱ ngats'ioò xi xìn na̱xa̱ndá‑nò xi i̱ titsa̱jnaà Jerusalén, ndaà kàtasijiìn‑nò, ndaà ti̱ná'ya 'én xi kichjàko̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Jñò bixón‑nò: “Ch'i̱í xi̱ta̱ koi.” ¿Kós'ín ko̱ma‑ne nga ko̱ch'i̱ nga sa̱á ijchò xi ñijaàn nga ta̱jñòya? ");
INSERT INTO maaNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Koií tíbitasòn 'én xi kiìchja̱ Joel, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","K'oa̱á tsò Nainá: K'e̱ nga jye tífehet'aà na̱chrjein, síka'bí‑la̱ Ini̱ma̱ Tsjeè‑na̱ ngats'iì xi̱ta̱ xi tjín nga tíjtsa i̱sò'nde; jñà i̱xti x'i̱n ko̱ i̱xti íchjín‑nò, 'a̱án ki̱chja̱ ngajo‑na; jñà i̱xti xo̱ngó‑nò, skoe̱ kjo̱xkón xi okó Nainá; jñà xi̱ta̱ jchínga‑nò k'oi̱í‑la̱ nijñá xi i̱t'aà ts'e̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","O̱kixi̱‑né na̱chrjein koi, jñà chi̱'nda‑na̱ xi x'i̱n ko̱ íchjín siìka'bí‑la̱ Ini̱ma̱ Tsjeè‑na̱ mé‑ne nga ki̱chja̱ ngajo‑na. ");
INSERT INTO maaNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ján ngajmiì kjìn kjo̱xkón jcha̱‑la̱, ti̱koa̱á i̱ i̱t'aà nangui jcha̱á‑la̱ kjo̱xkón nga xíxteèn jní‑la̱ xi̱ta̱, nga ko̱ ni'ín ko̱ ni̱'ndi̱ tsjè xi kjoa̱ ts'e̱ kjo̱jchán. ");
INSERT INTO maaNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Jè ts'oí, ko̱jñò‑né, jè sá, jní kji ko̱ma k'e̱ nga ti̱kj'eè f'iì Na̱'èn‑ná nga kjoi̱í kíndaàjiìn‑la̱ xi̱ta̱ jè na̱chrjein xi jeya ko̱ 'ñó xkón. ");
INSERT INTO maaNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ta̱nga ngats'iì xi̱ta̱ xi ki̱chja̱t'aà‑la̱ Nainá, ki̱tjokàjiìn kjo̱'in. K'oa̱á tsò 'én‑la̱ Nainá xi kiskiì Joel (2:28‑32). ");
INSERT INTO maaNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Ti̱ná'ya xi xi̱ta̱ Israel 'mì‑nò 'én xi k'oa̱ xán‑nò: Jñò, ndaà tíjiìn‑nò, Nainá tsakó nga Jesús xi Nazaret ts'e̱, tjín‑la̱ kjo̱tíxoma. Xkoòn ki'ya‑nò nga kis'iìn ngats'iì kjo̱xkón ko̱ kjoa̱ ts'e̱ seña xi tseé nga'ñó tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Koni s'ín tjíndaà‑la̱ Nainá nga ti̱sa̱ tàts'en‑la̱ kjoa̱, jñò, kindobà'ñó xi̱ta̱ jè nga kinìk'eèn nga kinìnga̱tsja xi̱ta̱ xi mìkiì beèxkón kjo̱tíxoma nga tsakat'aà krò. ");
INSERT INTO maaNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ta̱nga Nainá kisìkjaáya‑la̱; kisìkíjnandei̱í kjoa̱ ts'e̱ kjo̱'in xi tjín‑la̱ kjoa̱biyaà nga mìkiì ko̱ma nga ya̱ si̱jna'ñó i̱t'aà ts'e̱ kjoa̱biyaà. ");
INSERT INTO maaNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Jè xi̱ta̱xá ítjòn xi David ki'mì, kitsò i̱t'aà ts'e̱ Jesús: Kìjtseè kjit'aà‑ná Nainá k'e̱ nga tíjna nguixkoaàn; i̱ tíjnat'aà ndsa̱a kixi̱ mé‑ne nga nì mé xi ko̱mat'ian. ");
INSERT INTO maaNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Koií kjoa̱‑la̱ nga matsja‑la̱ ini̱ma̱‑na̱, ti̱koa̱ matsja‑la̱ ni̱je̱n‑na̱ nga seè. Yijo‑na̱, ti̱koa̱á ndaà siìkjáya nga skóña kjoa̱, ");
INSERT INTO maaNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","koií kjoa̱‑la̱ nga mì ya̱ si̱kíjni ini̱ma̱‑na̱ ya̱ i̱'nde‑la̱ mik'en, ti̱koa̱ mìkiì koi̱'ndi nga ki̱'ndo yijo‑na̱ xi chi̱'nda tsjeè‑lè 'mì‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tsakoò‑ná ndi̱yá nga ma kóti̱jnakoan, tseé kjo̱tsja s'e̱‑la̱ ini̱ma̱‑na̱ nga ji̱ tijnako̱‑ná. K'oa̱á tsò 'én‑la̱ Nainá xi kiskiì David (Salmo 16:8‑11). ");
INSERT INTO maaNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’'Ndsè, k'oa̱á xan‑nò xi nguì kjoa̱ kixi̱: xi̱ta̱ jchínga‑ná David, jye kjòtseé k'en, ti̱koa̱ kisìhijiìn‑né. Jè i̱tsjó‑la̱, tíjna skanda na̱chrjein i̱'ndei̱. ");
INSERT INTO maaNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ta̱nga jè David, jngoò xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. Jyeé k'oa̱s'ín tíjiìn‑la̱ koni s'ín kitsjaà‑la̱ tso'ba Nainá nga tje̱ ts'e̱ ki̱tjokàjiìn Cristo nga jè kíjna ngajo‑la̱ koni xi̱ta̱xá ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jè David, k'oa̱á s'ín kiìchja̱ i̱t'aà ts'e̱ Cristo koni tsà jye kijtseè nga jye jaáya‑la̱. Kitsò: “Mìkiì ya̱ kisijna ini̱ma̱‑la̱ ya̱ i̱'nde‑la̱ mik'en, ti̱koa̱á mìkiì i'ndo yijo‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nainá, jyeé kisìkjaáya‑la̱ Jesús. Ngats'iì kjoa̱ xi komà, k'oa̱á s'ín bèno̱jmí‑nòje̱n nga xkoòn ki'ya‑naje̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nainá jeya kisìkíjnat'aà chrja kixi̱‑la̱; kitjoé‑la̱ Ini̱ma̱ Tsjeè‑la̱ koni s'ín kitsjaà tso'ba Nainá. Jè Jesús kisìka'bísòn ìjngoò k'a Ini̱ma̱ Tsjeè‑la̱. Koií kjoa̱‑la̱ nga k'oa̱s'ín titsa̱'yaà ko̱ titsa̱na'yà. ");
INSERT INTO maaNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Jè David, mìtsà ngajmiì kiì mijìn; ta̱nga k'oa̱á kitsò: Jè Nainá kitsò‑la̱ jè xi Nei‑na̱: “Ti̱jnat'aà‑ná i̱ kixi̱‑na̱, ");
INSERT INTO maaNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","skanda k'e̱ nga sìkítsa̱jnanguia kondra̱‑lè ñánda nchasòn ndso̱koiì.” ");
INSERT INTO maaNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Jñò xi xi̱ta̱ na̱xa̱ndá Israel tsa̱jòn, ndaà jcha̱a yije nga 'ñó kixi̱ tjín kjoa̱ nga jè Jesús xi jñò tsakat'aà krò, Nainá, k'oa̱á s'ín kisìkíjna nga jè‑né xi Na̱'èn‑ná, ko̱ ti̱jè‑ne xi Cristo xi̱ta̱ xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","K'e̱ nga kiì'nchré 'én xi o̱kitsò jñà xi̱ta̱ xi ya̱ títsa̱jna, kisìkájno i̱jiìn ini̱ma̱‑la̱; k'e̱é kiskònangui‑la̱ Pedro ko̱ xi̱ta̱ xíkjín xi i'nga xi ti̱koa̱ xó tsibíxáya‑la̱ Jesús. Kitsò‑la̱: ―'Ndsè, ¿mé xi s'e̱n‑je̱n? ");
INSERT INTO maaNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro kitsò‑la̱: ―Ti̱kájno jé‑nò, kì ti̱ jé binchaàtsji‑nò; t'e̱en bautizar yijo‑nò i̱t'aà ts'e̱ Jesucristo nga jngoò ìjngoò‑nò, mé‑ne nga si̱ìjchàat'aà‑nò Nainá, ti̱koa̱ tsjá‑nò Ini̱ma̱ Tsjeè‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Koni s'ín kitsjaà tso'ba Nainá, 'én xi tsibíjna tsa̱jòn‑nò; ti̱koa̱á ts'e̱é i̱xti‑nò, ko̱ ngats'iì xi̱ta̱ xi kjiìn títsa̱jna, nga yije xi jè sobà Nainá xó ki̱chja̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro, kjìn 'én kiìchja̱jiìn‑sa̱‑la̱. 'Ñó kiìchja̱ko̱. Kitsò‑la̱: ―¡Ti̱nchat'aàxìn‑là kjo̱'in xi tjoé‑la̱ jñà xi̱ta̱ koi xi ch'o s'ín! ");
INSERT INTO maaNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jñà xi̱ta̱ xi kòkjeiín‑la̱ 'én xi kiìchja̱ Pedro komà bautizar; ma‑la̱ tsà jàn jmiì xi̱ta̱ xi jahas'en‑t'aà na̱chrjein jè. ");
INSERT INTO maaNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kóho̱tjín, kixi̱í chinchako̱ 'én xi kiì'nchré koni s'ín tsakóya‑la̱ jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús, ti̱koa̱ kjit'aà na̱chrjein maxkóya nga kjèn‑ko̱ xíkjín ti̱koa̱ chja̱t'aà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ngats'iì xi̱ta̱ xi ya̱ títsa̱jna tà kitsakjòn‑né k'e̱ nga kijtseè ngats'iì kjo̱ndaà ko̱ kjo̱xkón xi kis'iìn jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jñà xi̱ta̱ xi jye kòkjeiín‑la̱ i̱t'aà ts'e̱ Cristo bìtsa̱jnajtín‑né kóho̱tjín; síxkoa̱ya yije mé tsojmì xi tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Otíjna nangui‑la̱ ko̱ tsojmì xi tjín‑la̱, i̱kjoàn síjòya to̱n‑la̱ koni s'ín mochjeén‑la̱ nga jngoò ìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na̱chrjein inchijòn bixoña ya̱ ndi̱tsin i̱ngo̱ ítjòn, ko̱ ya̱ ni'ya‑la̱ xíkjín nga kjèn‑kjoò nga tjín‑la̱ kjo̱tsja ko̱ indaàjiìn tjín ini̱ma̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Jeya kisìkíjna Nainá; jñà xi̱ta̱ na̱xa̱ndá tsjakeè komà xi̱ta̱‑la̱ Cristo; jè Nainá, na̱chrjein inchijòn kisìkas'en‑t'aà‑ìsa na̱xa̱ndá‑la̱ Cristo jñà xi̱ta̱ xi jè mejèn‑la̱ nga ki̱tjokàjiìn kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Jngoò k'a kiì Pedro ko̱ Juan ya̱ i̱ngo̱ ítjòn ts'e̱ xi̱ta̱ judío. Ijchò‑la xi jàn nga nguixòn k'e̱ nga chja̱t'aà‑la̱ Nainá jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na̱chrjein nchijòn bijchó síkíjna jngoò xi̱ta̱ i̱ma̱ xi mìkiì ma fì. Xi̱ta̱ jè k'oa̱á s'ín kits'iìn. Ya̱á bìjnajto xotjoa̱‑la̱ i̱ngo̱ ítjòn xi k'oa̱s'ín tjít'aà 'ín: xotjoa̱ xi ndaà kji. Xi̱ta̱ jè, to̱n síjé kjo̱tjò‑la̱ jñà xi̱ta̱ xi fahas'en ndi̱tsin i̱ngo̱. ");
INSERT INTO maaNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Jè xi̱ta̱ xi mìkiì ma fì, k'e̱ nga kijtseè Pedro ko̱ Juan nga nchifahas'en ndi̱tsin i̱ngo̱, kisìjé kjo̱tjò‑la̱ to̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Jè Pedro ko̱ Juan, kiskoò'an; jè Pedro kitsò‑la̱: ―¡Chítsejèn‑'a‑náje̱n! ");
INSERT INTO maaNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jè xi̱ta̱ xi mìkiì ma fì kiskoò'an; k'oa̱á s'ín komà‑la̱ koni tsà tjín xi tsjá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ta̱nga jè Pedro kitsò‑la̱: ―Ni̱mé to̱n tjín‑na xi oro ko̱ xi plata, ta̱nga jè xi tjín‑na tsjaà‑lè; i̱t'aà ts'e̱ Jesucristo xi Nazaret ts'e̱, ti̱sítji̱in, ti̱tjájmiì. ");
INSERT INTO maaNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Jè Pedro, k'e̱ nga o̱kitsò‑la̱, kiskoé tsja kixi̱, kiskímiìtje̱n; ni̱to̱ón kis'e‑la̱ nga'ñó tsji ndso̱ko̱, kóho̱kji ndso̱ko̱. ");
INSERT INTO maaNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jè xi̱ta̱ jè, kiskì'nga nga tsasítje̱n; i̱kjoàn tsibíts'ia̱ nga tsajmeè‑ne; jahas'en‑ko̱ ndi̱tsin i̱ngo̱ jè Pedro ko̱ Juan nga ndso̱ko̱ kiì‑ne; fìjen fìkjá, kjì'nga kìtsian nga jeya kisìkíjna Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ngats'iì xi̱ta̱ na̱xa̱ndá kijtseè jè xi̱ta̱ jè nga jye ma fì‑ne ko̱ nga jeya kisìkíjna Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tà kjòxkón‑la̱ xi̱ta̱, ti̱koa̱á tà kitsakjòn‑né koni s'ín komàt'in jè xi̱ta̱ jè nga jyeé beèxkon nga jè‑né xi síjé kjo̱tjò to̱n ya̱ xotjoa̱ i̱ngo̱ xi k'oa̱s'ín tjít'aà 'ín‑la̱: xotjoa̱ xi ndaà kji. ");
INSERT INTO maaNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Jè xi̱ta̱ xi jye kjòndaà‑ne, mìkiì tsjeiìn nga kitsobà'ñó Pedro ko̱ Juan. Ngats'iì xi̱ta̱ na̱xa̱ndá tà k'oa̱á komà‑la̱; k'e̱é tsangachikon kiìtji̱ngui‑la̱ ya̱ i̱ngo̱ ítjòn, ya̱ nguitjoa̱‑la̱ xi 'mì Salomón. ");
INSERT INTO maaNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Jè Pedro, k'e̱ nga kijtseè jñà xi̱ta̱ na̱xa̱ndá, kitsò‑la̱: ―Jñò, xi̱ta̱ xinguia̱á xi xi̱ta̱ Israel 'mì‑ná, ¿mé‑ne maxkón‑onò? ¿Mé‑ne ngaje̱n chì'àn‑náje̱n? ¿A k'oa̱á s'ín nìkítsjeèn koni tsà nga'ñó tsa̱je̱n ko̱ kjo̱ndaà tsa̱je̱n kòmandaà‑ne xi̱ta̱ jè nga ma fì‑ne? ");
INSERT INTO maaNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Jè xi Nainá tsò‑la̱ Abraham, Isaac, Jacob ko̱ ngats'iì xi̱ta̱ jchínga‑ná xi i'nga, jè‑né xi jeya kàsíkíjna Jesús xi chi̱'nda‑la̱ ma; ti̱jè‑ne Jesús xi jñò kinìnga̱tsja xi̱ta̱xá. Jñò, mìkiì kits'iì'nde k'e̱ nga jè Pilato mejèn‑la̱ si̱ìkíjnandei̱í‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jñò, kinachrjekànguio jè xi Xi̱ta̱ Tsjeè ko̱ xi Xi̱ta̱ Kixi̱; i̱kjoàn kinìjé nga tsibìjnandei̱í jè xi̱ta̱ xi mik'en kitje̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jñò kinìk'eèn jè xi síkíjnakon‑ná ta̱nga jè Nainá kisìkjaáya‑la̱. Ngats'iì kjoa̱ koi, ki'ya‑náje̱n, k'oa̱á ma‑ne nga bèno̱jmí‑je̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesús kàtsjá‑la̱ nga'ñó xi̱ta̱ jè xi jñò titsa̱'yaà ti̱koa̱ yaxkoòn, koi‑né nga mokjeiín‑naje̱n i̱t'aà ts'e̱ Jesús. Tà koií kjoa̱‑la̱ nga ndaà mokjeiín‑naje̱n nga ndaà kòmandaà‑ne xi̱ta̱ jè nga nguixkoòn jñò xi i̱ titsa̱jnaà. ");
INSERT INTO maaNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’'Ndsè, jyeé tíjiìn‑na, k'e̱ nga k'oa̱s'ín ki'nè ko̱ xi̱ta̱xá‑nò nga kinìk'eèn Jesús, koi‑né nga mìkiì machi̱ya‑nò. ");
INSERT INTO maaNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Jè Nainá, k'oa̱á s'ín kisìkitasòn koni s'ín kiìchja̱ ngats'iì xi̱ta̱‑la̱ xi kiìchja̱ ngajo‑la̱ nga jè Cristo jè xi xó kisìkasén‑ne Nainá k'oa̱á s'ín tjínè‑la̱ nga ki̱yá. ");
INSERT INTO maaNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Koií k'oa̱ 'mì‑nòje̱n nga ti̱kájno jé‑nò, kì ti̱ jé binchaàtsji‑nò; Nainá tanguít'aà‑là mé‑ne nga jcha̱t'aà‑nò jé‑nò i̱kjoàn tsjá‑nò Nainá kjoa̱'nchán ts'e̱ ini̱ma̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kàtasíkasén‑nò Jesús, jè xi xó k'oa̱s'ín kjòtseé jaàjiìn‑ne Nainá nga jè xi Cristo nga i̱t'aà tsa̱jòn kjoi̱í‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mochjeén‑né nga ján kíjna ngajmiì jè Jesucristo skanda k'e̱ nga jè Nainá si̱ìxi̱tse̱ya yije ìjngoò k'a tsojmì xi tjín. K'oa̱á s'ín kitsjaà o̱kixi̱ Nainá k'e̱ nga kiìchja̱ ngajo‑la̱ xi̱ta̱ tsjeè‑la̱ xi jè kisìkjeén nga sa̱ kjòtseé. ");
INSERT INTO maaNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés, k'oa̱á s'ín kitsò‑la̱ jñà xi̱ta̱ jchínga‑ná: “Jè Na̱'èn‑ná xi Nainá, ya̱á ko̱chrjekàjiìn jngoò xi̱ta̱ xinguia̱á xi ki̱chja̱ ngajo‑la̱ Nainá koni 'a̱n. Jè ti̱ná'ya‑là koni s'ín ki̱chja̱ko̱‑nò ngats'iì kjoa̱ xi ke̱èno̱jmí‑nò. ");
INSERT INTO maaNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ngats'iì xi̱ta̱ xi mìkiì kji̱'nchréñijon‑la̱, jngoò k'a tjáxìn i̱t'aà ts'e̱ na̱xa̱ndá‑la̱ Nainá.” ");
INSERT INTO maaNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ngats'iì xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, mats'ia̱‑ne Samuel, skanda i̱'ndei̱, sa̱á koií 'én tsibéno̱jmí mé kjoa̱ xi tíma na̱chrjein i̱'ndei̱. ");
INSERT INTO maaNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kjo̱ndaà tsa̱jòn‑nò koni s'ín kitsjaà tso'ba Nainá i̱t'aà ts'e̱ xi̱ta̱‑la̱ xi kiìchja̱ ngajo‑la̱. Ti̱koa̱á kjo̱ndaà tsa̱jòn‑nò koni s'ín tsibíndaàjiìn jngoò kjoa̱ Nainá ko̱ xi̱ta̱ jchínga‑ná k'e̱ nga kitsò‑la̱ Abraham: “Ngats'iì xi̱ta̱ xi tjín nga tíjtsa i̱sò'nde ko̱chikon‑t'in‑né xi i̱t'aà ts'e̱ tje̱‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nainá, k'e̱ nga kisìkjaáya‑la̱ Ki'ndí‑la̱, jñò kisìkasén ítjòn‑nò nga si̱ìchikon‑t'in‑nò mé‑ne nga si̱kjatjìya‑là kjo̱hítsjeèn‑nò nga jngoò ìjngoò, nga mì ti̱ ch'o s'e̱n‑nò. ");
INSERT INTO maaNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro ko̱ Juan tákó ti̱k'e̱é nchihóko̱ xi̱ta̱ na̱xa̱ndá nga ijchò jñà no̱'miì, tji̱ko̱ jè xi̱ta̱ sko̱‑la̱ policía xi síkinda̱ i̱ngo̱ ítjòn ko̱ jñà xi̱ta̱ saduceo. ");
INSERT INTO maaNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jñà xi̱ta̱ koi 'ñó jti komà‑la̱ nga jè Pedro ko̱ Juan k'oa̱á s'ín tsakóya‑la̱ xi̱ta̱ na̱xa̱ndá nga jyeé ki'ya‑la̱ nga kjoa̱áya‑la̱ xi̱ta̱ xi jye k'en koni s'ín jaáya‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kitsobà'ñó, kiìko̱, i̱kjoàn kiskinìs'en nda̱yá nga jyeé kjònguixòn. Ya̱á kisìkítsa̱jna nda̱yá skanda komà nchijòn. ");
INSERT INTO maaNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","'Ñó kjìn ma‑ne xi̱ta̱ xi kòkjeiín‑la̱ k'e̱ nga kiì'nchré 'én xi kiìchja̱ Pedro ko̱ Juan. Jyeé ma 'òn jmiì xi̱ta̱ x'i̱n xi mokjeiín‑la̱; ko̱ jñà íchjín xi kòkjeiín‑la̱ mìkiì kòxke̱ya. ");
INSERT INTO maaNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Xi komà inchijòn, kjòxkóya ján Jerusalén xi̱ta̱ sko̱‑la̱ jñà xi̱ta̱ judío ko̱ xi̱ta̱ jchínga ko̱ xi̱ta̱ chji̱ne̱ xo̱jo̱n xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. ");
INSERT INTO maaNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ti̱koa̱ ya̱ tíjna Anás, xi no̱'miì ítjòn, Caifás, Juan, ko̱ Alejandro, ngats'iì xi̱ta̱ xíkjín jñà xi no̱'miì ítjòn. ");
INSERT INTO maaNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kiskinìkjaá Pedro ko̱ Juan, i̱kjoàn chinchá osen nga kiskònangui‑la̱, kitsò‑la̱: ―¿Yá ts'e̱ nga'ñó? ¿Yá xi kitsjaà'nde‑nò nga xi̱ta̱ xk'én nìndaà‑nò? ");
INSERT INTO maaNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jè Pedro nga ndaà tíjiìn ini̱ma̱‑la̱ jè Ini̱ma̱ Tsjeè‑la̱ Nainá kitsò: ―Jñò xi xi̱ta̱xá ítjòn 'mì‑nò ko̱ xi̱ta̱ jchínga‑la̱ na̱xa̱ndá Israel: ");
INSERT INTO maaNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Jñò, ¿mé‑ne mejèn‑nò nga jcha̱a kjo̱ndaà xi kòmat'in xi̱ta̱ jè nga kòmandaà‑ne nga jye ma fì‑ne? ");
INSERT INTO maaNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Jñò nga nguixkoòn, kéno̱jmí‑nòje̱n, ti̱koa̱ kàtji'nchré yije ngats'iì xi̱ta̱ na̱xa̱ndá Israel. Xi̱ta̱ jè, i̱t'aà ts'e̱é Jesucristo xi Nazaret ts'e̱ kjòndaà‑ne. Ti̱jè‑ne xi kinìk'eèn nga tsakat'aà krò, ta̱nga Nainá kisìkjaáya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jñò, k'oa̱á ngaya‑la̱ koni chji̱ne̱chrjó xi bíndaà ni'ya. Kinachrjekàngui‑nò Jesús koni jngoò nda̱jo̱ xi ni̱mé chjí‑la̱. Ta̱nga i̱'ndei̱ jè tíjna ítjòn koni nda̱jo̱ chrja̱ngui̱‑la̱ chrjó ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tà jngoò ma xi̱ta̱ xi ma‑la̱ ochrjekàjiìn‑ná kjo̱'in, tà jè Jesucristo. Mì ti̱ yá xi̱ta̱ tjín‑ne i̱ i̱t'aà nangui xi Nainá kisìkasén nga ko̱ma ko̱chrjekàjiìn‑ná kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jñà xi̱ta̱xá, k'e̱ nga kijtseè nga 'ñó chja̱ Pedro ko̱ Juan nga mìkiì tsakjón, ti̱koa̱ kijtseè nga ta̱xki̱ ndí xi̱ta̱‑né nga mìtsà 'ñó ma‑la̱ xo̱jo̱n, tà kjòxkón‑la̱; k'e̱é kjòchi̱ya‑la̱ nga jñà xi̱ta̱ xi tsajmeiìko̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ti̱koa̱ kijtseè nga ya̱ síjna jè xi̱ta̱ xi jye kjòndaà‑ne, k'oa̱á s'ín komà‑ne nga mì ti̱ kó kitsò‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","K'e̱é tsachrje jngoò tjò ni'ya osen, i̱kjoàn tsajoóya‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kitsò‑la̱ xíkjín: ―¿Mé xi si̱koa̱á xi̱ta̱ koi? Ngats'iì xi̱ta̱ na̱xa̱ndá Jerusalén, jyeé tíjiìn‑la̱ kjo̱xkón xi kis'iìn, mìkiì ko̱ma kí'maá. ");
INSERT INTO maaNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ki̱nchaxkón‑la̱á nga ni̱ ti̱ jngoò xi̱ta̱ ko̱hóko̱‑ne xi i̱t'aà ts'e̱ Jesús, mé‑ne nga mì ti̱ kiì ko̱bísòn‑ne kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","K'e̱é kiìchja̱ ìjngoò k'a‑la̱ Pedro ko̱ Juan; kitsjaà‑la̱ o̱kixi̱ nga jngoò k'a mì ti̱ kiì tjí'nde‑la̱ nga ki̱chja̱‑ìsa‑la̱, ti̱koa̱ ko̱kòya‑ìsa‑la̱ xi̱ta̱ i̱t'aà ts'e̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Jè Pedro ko̱ Juan kiìchja̱, kitsò‑la̱: ―Jñò, ndaà jchósòn‑là, ñá‑la̱á xi kixi̱ tjín nga nguixko̱n Nainá. ¿Yá‑né xi si̱kitasòn‑la̱je̱n? ¿A jñò‑nò xi xi̱ta̱ 'mì‑nò? ¿A xi jè sobá Nainá? ");
INSERT INTO maaNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mìkiì ko̱ma jyò ki̱tsa̱jna‑je̱n i̱t'aà ts'e̱ kjoa̱ xi ki'ya‑je̱n ko̱ xi kina'yà‑je̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jñà xi̱ta̱xá mìkiì kjòtsji‑la̱ kós'ín si̱ìko̱ nga tsjá‑la̱ kjo̱'in, tà chincháxkón‑la̱, i̱kjoàn kisìkítsa̱jnandei̱í‑ne, koií kjoa̱‑la̱ nga jñà ngats'iì xi̱ta̱ na̱xa̱ndá, 'ñó jeya kisìkíjna Nainá i̱t'aà ts'e̱ kjo̱xkón xi komà. ");
INSERT INTO maaNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Koií‑né nga jè xi̱ta̱ xi jye kjòndaà‑ne, tsatoó ichán nó tjín‑la̱ k'e̱ nga k'oa̱s'ín komàt'in kjo̱xkón jè. ");
INSERT INTO maaNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","K'e̱ nga jye tsibìtsa̱jnandei̱í‑ne Pedro ko̱ Juan, kiì‑ne ñánda títsa̱jna xi̱ta̱ xíkjín; tsibéno̱jmí yije‑la̱ kó kitsò‑la̱ jñà no̱'miì ítjòn ko̱ jñà xi̱ta̱ jchínga. ");
INSERT INTO maaNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jñà xi̱ta̱ xíkjín, k'e̱ nga jye kiì'nchré koni s'ín kis'eno̱jmí‑la̱, ngats'iì, tsibíts'ia̱ nga tà jngoò jta̱ kiìchja̱t'aà‑la̱ Nainá, kitsò: ―Ji̱ Na̱'èn xi ji̱ tjín‑lè kinda̱ ngats'iì xi tjín, nga ji̱ tsibìndiì ngajmiì, nangui ko̱ ndáchikon, ngats'iì tsojmì xi tjín i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nga ko̱ Ini̱ma̱ Tsjeè‑lè kinìkjiín tso'ba chi̱'nda‑lè David xi xi̱ta̱ jchínga kjiìn‑naje̱n nga k'oa̱ kisi: ¿Mé‑ne nga mats'e̱n‑ne xi̱ta̱ i̱sò'nde? Ko̱ jñà xi̱ta̱ na̱xa̱ndá, ¿mé‑ne kjoa̱ ts'e̱n joóya‑ne xi kondra̱ ts'e̱ Nainá? ");
INSERT INTO maaNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kjòxkóya xi̱ta̱xá ítjòn xi tjín i̱sò'nde; kisìjngoò yijo‑la̱ jñà xi̱ta̱ xi tjín‑la̱ kjo̱tíxoma nga kondra̱ kiì‑la̱ Nainá ko̱ Cristo, xi̱ta̱ xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Kixi̱í kjoa̱, jè Herodes ko̱ Poncio Pilato, ko̱ xi ta̱xki̱ xi̱ta̱ xi mìtsà xi̱ta̱ judío, ko̱ ngats'iì xi̱ta̱ na̱xa̱ndá Israel, kisìjngoò yijo‑la̱ i̱ na̱xa̱ndá jè, nga kondra̱ kiì‑la̱ Ki'ndí‑lè Jesús xi xi̱ta̱ tsjeè xi ngaji̱ xó ji̱ kichjaàjiìn‑ne nga kinìkasín nga jè xi Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jñà xi̱ta̱ koi, k'oa̱á s'ín kis'iìn yije koni s'ín tjíndaà‑lè nga ti̱sa̱ tàts'en‑la̱ kjoa̱ nga k'oa̱s'ín ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na̱'èn, i̱'ndei̱, chítsején‑la̱ xi̱ta̱ koi nga mejèn‑la̱ beètoòn‑naje̱n; ti̱chját'aà‑náje̱n nga mìkiì ki̱skón‑je̱n nga ma ki̱nókjoa̱ya‑je̱n 'én‑lè xi chi̱'nda‑lè 'mì‑náje̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ta̱koí nga'ñó xi tjíya ndsei̱i nga kàtandaà‑ne xi̱ta̱ xi xk'én; i̱t'aà ts'e̱ Chi̱'nda Tsjeè‑lè Jesús, t'i̱in kjo̱xkón xi okó kjoa̱jeya‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","K'e̱ nga jye kiìchja̱t'aà‑la̱ Nainá, ts'a ch'ón ya̱ i̱'nde ñánda títsa̱jna. Ngats'iì xi̱ta̱ xi ya̱ títsa̱jna kis'ejiìn ini̱ma̱‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá; mì ti̱ kiì kitsakjòn‑ne nga kiìchja̱ya 'én‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ngats'iì xi̱ta̱ xi jye kòkjeiín‑la̱, ngásòn ngáya tjín ini̱ma̱‑la̱ ko̱ kjo̱hítsjeèn‑la̱; ngats'iì tsojmì xi tjín‑la̱ nga jngoò ìjngoò, ts'e̱ yije‑né kóho̱tjín. Ni̱jngoò xi kitsò: “Tsojmì xi tjín‑na̱, tà ts'a̱n, ta̱jngoò‑ná.” ");
INSERT INTO maaNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús 'ñó tse nga'ñó kis'e‑la̱ nga ìsa̱ ndaà tsibéno̱jmí nga jye jaáya‑la̱ Na̱'èn‑ná Jesucristo i̱t'aà ts'e̱ kjoa̱biyaà. Ngats'iì jñà xi̱ta̱ koi, Nainá 'ñó ndaà kisìchikon‑t'in. ");
INSERT INTO maaNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","K'oa̱á s'ín komà‑ne nga ni̱jngoò xi̱ta̱ kisìchijàt'aà‑la̱ tsojmì xi mochjeén‑la̱. Jñà xi̱ta̱ xíkjín xi tjín‑la̱ nangui ko̱ jñà xi tjín‑la̱ ni'ya, otíjna. I̱kjoàn f'iìko̱ yije to̱n‑la̱ tsojmì xi otíjna. ");
INSERT INTO maaNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Sínga̱tsja jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús; i̱kjoàn síka'bí‑la̱ xíkjín nga jngoò ìjngoò mé xi chijat'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ya̱ tíjnajiìn jngoò xi̱ta̱ levita xi José 'mì. Ya̱á i̱'nde‑la̱ na̱xa̱ndá Chipre. Jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús, tsibít'aàsòn 'ín‑la̱: Bernabé kitsò‑la̱. ('Ín jè, tsòyaá‑ne: xi̱ta̱ xi síjehikon‑ná.) ");
INSERT INTO maaNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Xi̱ta̱ jè, kijna jngoò 'nde‑la̱ nangui; tsatíjna; j'iìko̱ to̱n‑la̱; kisìnga̱tsja jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ta̱nga ìjngoò xi̱ta̱ x'i̱n xi 'mì Ananías ko̱ chjo̱ón‑la̱ Safira, ti̱koa̱ tsatíjna jngoò 'nde nangui‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Xi̱ta̱ jè tsajoóya‑ne ko̱ chjo̱ón‑la̱, tsibí'ma chiba to̱n chjí‑la̱ nangui. Tà chiba j'iìko̱ nga kisìnga̱tsja jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Jè Pedro kitsò: ―Ji̱ Ananías, ¿mé‑ne kòbiì'nde‑ne nga xi̱ta̱ nei̱í kòfahas'en‑jiìn ini̱ma̱‑lè nga mejèn‑lè kachona̱cha̱n‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá nga kòbì'ma chiba to̱n chjí‑la̱ nangui? ");
INSERT INTO maaNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿A mìtsà tsi̱ji nangui? K'e̱ nga jye kòhotijni, ¿a mìtsà tsi̱ji to̱n? ¿Mé‑ne k'oa̱s'ín kànìkítsjeèn‑ne i̱jiìn ini̱ma̱‑lè? Mìtsà ta̱xki̱ xi̱ta̱ mejèn‑lè kachona̱cha̱n‑la̱, jè sobà Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Jè Ananías, k'e̱ nga kiì'nchré 'én koi, kiskaàjndoòt'aà nangui, k'en. Ngats'iì xi̱ta̱ xi kis'ejiìn‑la̱ kjoa̱ xi komà, ndaà jchán kitsakjòn. ");
INSERT INTO maaNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","K'e̱é j'iì i'nga i̱xti x'i̱n xi kisìkájté nikje yijo‑la̱ Ananías; tsachrje ni'ya, nga kiì kíhijiìn. ");
INSERT INTO maaNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tjín‑la̱ tsà jàn hora nga j'iì Safira chjo̱ón‑la̱ Ananías; mìkiì tíjiìn‑la̱ mé kjoa̱ xi komà. ");
INSERT INTO maaNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro kiskònangui‑la̱ kitsò‑la̱: ―¿A k'oa̱á tjín kòhotijna‑nò nangui‑nò koni tjín bixón? Jè chjo̱ón kitsò: ―Jon, k'oa̱á tjín kòhotijna‑na̱je̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Jè Pedro kitsò‑la̱: ―¿Mé‑ne k'oa̱s'ín kàchibàya‑nò? ¿A k'oa̱á s'ín kànìkítsjeèn nga ma chóna̱cha̱n‑là jè Ini̱ma̱ Tsjeè‑la̱ Nainá? Chítsején‑la̱ jñà i̱xti xi nchajto xotjoa̱ ni'ya. Jñà kòfì kíhijiìn x'i̱n‑lè; ti̱koa̱á ngaji̱, jñà kji̱ko̱‑lè. ");
INSERT INTO maaNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Chjo̱ón jè, ni̱to̱ón kiskaàjndoòt'aà nangui ya̱ ñánda síjna Pedro; k'en. K'e̱ nga jahas'en ni'ya jñà i̱xti x'i̱n, kijtseè nga jye k'en; tsachrje ni'ya; kiì kíhijiìn‑t'aà‑la̱ x'i̱n‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ngats'iì xi̱ta̱ na̱xa̱ndá‑la̱ Cristo ko̱ ngats'iì xi̱ta̱ xi kiì'nchré kjoa̱ koi, ndaà jchán kitsakjòn. ");
INSERT INTO maaNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús, kjìn kjo̱xkón xi okó kjoa̱jeya‑la̱ Nainá kis'iìn nga nguixko̱n xi̱ta̱ na̱xa̱ndá. Ngats'iì xi̱ta̱‑la̱ Cristo, ya̱á bixoña kjit'aà ya̱ i̱ngo̱ ítjòn ya̱ nguitjoa̱‑la̱ xi 'mì Salomón. ");
INSERT INTO maaNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jñà xi̱ta̱ xi mìkiì mokjeiín‑la̱ i̱t'aà ts'e̱ Cristo, ni̱jngoò kjò'ñóhikon nga ya̱ kiìt'aà‑la̱ jñà xi̱ta̱‑la̱ Cristo. Ta̱nga jñà xi̱ta̱ na̱xa̱ndá, 'ñó ndaà kijtseèxkón jñà xi̱ta̱‑la̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ta̱nga jñà xi̱ta̱ xi kòkjeiín‑la̱ i̱t'aà ts'e̱ Cristo, íchjín íchjá, ìsa̱á 'ñó kòkjìn‑ya‑ìsa̱. ");
INSERT INTO maaNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jñà xi̱ta̱ tsachrje xi̱ta̱ xi xk'én ya̱ i̱ya ndi̱yá; kisìkáyijòsòn na̱chan ko̱ nijñaà mé‑ne k'e̱ nga kjoa̱ Pedro, na̱s'ín tà jè 'nguién‑la̱ ska̱t'aà i'nga‑la̱ jñà xi̱ta̱ xk'én. ");
INSERT INTO maaNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ti̱koa̱ kjìn xi̱ta̱ j'iì ya̱ Jerusalén xi inchrobà‑ne na̱xa̱ndá xi kjiyijòt'aà chrañà‑la̱; j'iìko̱ xi̱ta̱ xi xk'én ko̱ jñà xi ini̱ma̱ ch'o‑la̱ nei̱í nchibeètoòn; ngats'iì xi̱ta̱ koi kjòndaà yijeé‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jè no̱'miì ítjòn ko̱ ngats'iì xi̱ta̱ xi ya̱ báhijtako̱, jñà xi ya̱ chja̱‑ne i̱t'aà ts'e̱ xi̱ta̱ saduceo, kjòchi̱ni̱keé jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kitsobà'ñó; kiìko̱; kiskinìs'en nda̱yá xi ts'e̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ta̱nga k'e̱ nga jye kòjñò, jngoò àkja̱le̱‑la̱ Nainá ijchò kíx'a̱‑la̱ xotjoa̱ nda̱yá. Tsachrje xi̱ta̱ koi; kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Tanguió, ti̱nchajtoò xotjoa̱ i̱ngo̱ ítjòn. Tèno̱jmí yije‑là xi̱ta̱ na̱xa̱ndá kós'ín kítsa̱jnakon xi̱ta̱ i̱t'aà ts'e̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","K'e̱ nga kiì'nchré 'én koi, nga komà nchijòn, ta̱jñòyaá kiì ya̱ i̱ngo̱ ítjòn, i̱kjoàn tsibíts'ia̱ nga tsakóya‑la̱ xi̱ta̱. Ti̱k'e̱‑ne chixoña jè no̱'miì ítjòn, ngats'iì xi̱ta̱‑la̱ xi ya̱ títsa̱jnako̱. Kiìchja̱‑la̱ ngats'iì xi̱ta̱xá ko̱ xi̱ta̱ jchínga ts'e̱ na̱xa̱ndá Israel; i̱kjoàn kiskinìkjaá jñà xi̱ta̱‑la̱ Cristo xi títsa̱jna'ya nda̱yá. ");
INSERT INTO maaNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ta̱nga k'e̱ nga ijchò jñà policía, mìkiì kisakò‑la̱ jñà xi̱ta̱ xi títsa̱jna'ya nda̱yá; tà k'oa̱á s'ín inchrobà‑ne; kitsjaà o̱kixi̱ nga mì ti̱ yá tjín‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Kitsò: ―K'e̱ nga kòbijchò‑je̱n, ndaà tíchjoàjto xotjoa̱‑la̱ nda̱yá. Jñà xi̱ta̱ soldado xi síkinda̱, ya̱á nchajto xotjoa̱, ta̱nga k'e̱ nga kòbitjaàs'en‑je̱n mì ti̱ yá xi̱ta̱ tjín‑ne i̱ya nda̱yá. ");
INSERT INTO maaNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","K'e̱ nga kiì'nchré 'én koi, jè no̱'miì ítjòn ko̱ no̱'miì xi i'nga ko̱ jè xi̱ta̱ sko̱‑la̱ policía xi síkinda̱ i̱ngo̱ ítjòn, tà k'oa̱á komà‑la̱ nga mìkiì machi̱ya‑la̱ kós'ín ko̱ma nga kjoe̱het'aà kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ti̱k'e̱é‑ne j'iì jngoò xi̱ta̱ xi j'iì kéno̱jmí, kitsò: ―Jñà xi̱ta̱ xi kichinìs'en nda̱yá ngojña̱, ya̱á títsa̱jna i̱ngo̱ ítjòn nga nchihokóya‑la̱ xi̱ta̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","K'e̱é kiì jè xi̱ta̱ sko̱‑la̱ policía xi síkinda̱ i̱ngo̱, kjihijtako̱ jñà policía xi i'nga nga kiìkjaá Pedro ko̱ Juan. Tà kjo̱ndaá inchrobàko̱. Jñà tsakjón‑la̱ xi̱ta̱ na̱xa̱ndá tsà nda̱jo̱ koi̱ì'nè nga si̱ìk'en. ");
INSERT INTO maaNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","K'e̱ nga j'iìko̱, chinchá osen ñánda nchijoóya‑ne. Jè no̱'miì ítjòn kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿A mìtsà k'oa̱s'ín ki'mì‑nòje̱n nga jngoò k'a mì ti̱ k'oa̱á tsò‑ne 'én xi ko̱kóya i̱t'aà ts'e̱ Jesús? I̱'ndei̱, kóho̱kji Jerusalén, jyeé titsa̱chinìsòn yije kjo̱tíxoma‑nò; ti̱koa̱á mejèn‑nò ngaje̱n chinì'nè‑náje̱n nga k'en xi̱ta̱ xi 'mì Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Jè Pedro ko̱ xi̱ta̱ xi i'nga xi ta̱ña tsibíxáya‑la̱ Cristo kitsò: ―Ìsa̱á 'ñó mochjeén nga jè Nainá si̱kitasòn‑la̱je̱n mì k'oa̱á‑ne koni xi ta̱xki̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jè xi Nainá tsò‑la̱ xi̱ta̱ jchínga‑ná kisìkjaáya‑la̱ Jesús i̱t'aà ts'e̱ kjoa̱biyaà, ti̱jè‑ne Jesús xi jñò kinìk'eèn nga tsakat'aà krò. ");
INSERT INTO maaNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nainá, 'ñó jeya kisìkíjnat'aà chrja kixi̱‑la̱. Xi̱ta̱xá ítjòn kisìkíjna. Ti̱koa̱á jè kisìkíjna nga jè ko̱chrjekàjiìn‑ná kjo̱'in. K'oa̱á s'ín kis'iìn Nainá, mé‑ne nga jñá xi na̱xa̱ndá Israel 'mì‑ná si̱kájnoaá jé‑ná; mì ti̱ jé ki̱nchátsji‑ná nga si̱ìjchàat'aà‑ná Nainá jé xi tjín‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","K'oa̱á s'ín bèno̱jmí‑nòje̱n kjoa̱ koi xi xkoòn ki'ya‑na̱je̱n. Ti̱koa̱ béno̱jmí kixi̱‑né jè Ini̱ma̱ Tsjeè‑la̱ Nainá xi jye kitjoé‑la̱ jñà xi̱ta̱ xi síkitasòn‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","K'e̱ nga kiì'nchré 'én koi, 'ñó jchán kòjti‑la̱; skanda mejèn‑la̱ si̱ìk'en. ");
INSERT INTO maaNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ya̱ tíjnajiìn jngoò xi̱ta̱ fariseo xi ti̱koa̱ xá tjín‑la̱ xi 'mì Gamaliel, jè xi okóya kjo̱tíxoma. Ngats'iì jñà xi̱ta̱ na̱xa̱ndá 'ñó ndaà beèxkón xi̱ta̱ jè. K'e̱é tsasíjna‑kixi̱‑jiìn‑la̱ ngats'iì jñà xi̱ta̱ xi tjín‑la̱ xá; kitsjaà o̱kixi̱ nga kàtitjo jngoò tjò ni'ya jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Jè Gamaliel kitsò‑la̱ xi̱ta̱xá xíkjín: ―Jñò ngats'ioò xi xi̱ta̱ xinguia̱á Israel 'mì‑ná, ndaà ti̱kítsjeèn mé kjoa̱ xi si̱ko̱o jñà xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ti̱kítsjeèn jñà na̱chrjein xi jye tsato, tsibìjnaá jngoò xi̱ta̱ xi ki'mì Teudas. K'oa̱á kitsò nga xi̱ta̱ ítjòn‑né. Komà‑la̱ tsà ñijòn sìndo̱ xi̱ta̱ xi kiìt'aà‑la̱. Ta̱nga k'e̱ nga kisìk'en xi̱ta̱, ngats'iì xi̱ta̱ xi kiìt'aà‑la̱, kitsjohoba‑né. Tà ya̱á jyehet'aà kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","K'e̱ nga komà i̱skan, jè na̱chrjein nga kòxke̱ya xi̱ta̱, tsatsejèn ìjngoò xi̱ta̱ xi 'mì Judas xi xi̱ta̱ Galilea. Ti̱koa̱á kjìn xi̱ta̱ na̱xa̱ndá kiìt'aà‑la̱. Ta̱nga k'e̱ nga kinìk'en xi̱ta̱ jè, ti̱koa̱á ngats'iì xi̱ta̱ xi ya̱ kiìt'aà‑la̱, kitsjohoba yije‑né. ");
INSERT INTO maaNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","I̱'ndei̱ k'oa̱á ma‑ne ko̱xan‑nò, tà ti̱kjehet'aà kjoa̱. Tjiì'nde‑là xi̱ta̱ koi nga kàtjì‑ne. Tsà tà xá ts'e̱ xi̱ta̱á xi nchis'ín kjoe̱het'aà‑né. ");
INSERT INTO maaNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ta̱nga tsà xá ts'e̱ Nainá‑né xi nchis'ín, mìkiì ki̱chìkjoa̱‑nò nga jñò ki̱xkàn‑ko̱; ti̱kinda̱a yijo‑nò tsà koi na̱chrjein‑la̱, tsà xá‑la̱ Nainá titsa̱bixkàn‑ko̱o. ");
INSERT INTO maaNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ngats'iì xi̱ta̱ xi títsa̱jna junta, kòkjeiín‑la̱ koni s'ín kitsò Gamaliel. K'e̱é kiìchja̱ ìjngoò k'a‑la̱ jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús. I̱kjoàn tsajá‑la̱. 'Ñó tsibínè‑la̱ nga mì ti̱ k'oa̱ s'ín ki̱chja̱ya‑ne i̱t'aà ts'e̱ Jesús. I̱kjoàn kisìkítsa̱jnandei̱í‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús, 'ñó tsja tjín‑la̱ k'e̱ nga itjo‑ne ni'ya nga jè Nainá kitsjaà'nde nga kitjoé‑la̱ kjo̱ndaà nga kisìkjeiín kjo̱'in xi kjoa̱ ts'e̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jñà xi̱ta̱ koi, mìkiì jyò tsibìtsa̱jna. Na̱chrjein inchijòn tsakóya ti̱koa̱ kiìchja̱ya 'én ndaà‑la̱ Nainá ya̱ i̱ngo̱ ítjòn ko̱ xi kj'ei̱í ni'ya nga jè Jesús xi Cristo jè xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jñà na̱chrjein koi, k'e̱ nga jye 'ñó tímakjìn‑ya xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo, jñà xi̱ta̱ xi chja̱ 'én griego tsibíts'ia̱ nga tsohojét'in jñà xi̱ta̱ xi chja̱ 'én hebreo, nga jñà íchjín ka'àn xi ts'e̱ xi̱ta̱ griego mì ngásòn tí'biì‑la̱ tsojmì xi kine koni jñà íchjín ka'àn xi ts'e̱ xi̱ta̱ hebreo. ");
INSERT INTO maaNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jñà xi̱ta̱ xi tejò ma‑ne xi tsibíxáya‑la̱ Jesús, tsibíxkóya ngats'iì xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo, kitsò: ―Mì‑la kiì ndaà tjín nga si̱kíjna‑je̱n xá‑la̱ Nainá nga mì ti̱ kiì ki̱nókjoa̱ya‑naje̱n 'én‑la̱ Nainá, nga nguì ta koi xá s'e̱n‑je̱n nga xi̱ta̱ i̱ma̱ si̱kjèn‑je̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","'Ndsè, chja̱ájñoò itoò xi̱ta̱ x'i̱n xi 'yaà nga ndaà nchisíjchá yijo‑la̱, ti̱koa̱ ndaà tíjiìn ini̱ma̱‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá, xi̱ta̱ xi ndaà kjo̱hítsjeèn tjín‑la̱ mé‑ne jñà ko̱nga̱tsja xá koi. ");
INSERT INTO maaNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ngaje̱n, kjit'aà na̱chrjein ki̱nókjoa̱t'aà‑la̱je̱n Nainá; ti̱koa̱ ko̱kóya‑je̱n 'én‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jñà 'én koi, ndaà kisaseèn yije‑la̱ ngats'iì xi̱ta̱. K'e̱é jaàjiìn Esteban, jngoò xi̱ta̱ x'i̱n xi ndaà mokjeiín‑la̱ i̱t'aà ts'e̱ Nainá, ti̱koa̱ ndaà tíjiìn ini̱ma̱‑la̱ jè Ini̱ma̱ Tsjeè‑la̱ Nainá. Ti̱koa̱ kitjaàjiìn Felipe, Prócoro, Nicanor, Timón, Parmenas, Nicolás, jngoò xi̱ta̱ Antioquía xi jahatjìya‑la̱ nga xi̱ta̱ judío komà. ");
INSERT INTO maaNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jñà xi̱ta̱ xi itoò ma‑ne chinchá osen nga nguixko̱n xi̱ta̱ xi tsibíxáya‑la̱ Jesús. Ko̱ jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús kiìchja̱tjì i̱t'aà ts'e̱ Nainá, i̱kjoàn tsohósòn‑la̱ tsja nga kjònga̱tsja xá. ");
INSERT INTO maaNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ìsa̱á 'ñó tsabísòn‑ìsa̱ 'én‑la̱ Nainá. Ya̱ na̱xa̱ndá Jerusalén sa̱á 'ñó sa̱á 'ñó makjìn‑ya xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo. Skanda jñà no̱'miì, ti̱koa̱á jyeé kjìn ma‑ne xi mokjeiín‑la̱ i̱t'aà ts'e̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Jè Esteban, 'ñó ndaà kis'e‑la̱ nga'ñó ko̱ kjo̱ndaà xi i̱t'aà ts'e̱ Nainá. K'oa̱á komà‑ne nga kjìn kjo̱xkón xi okó kjoa̱jeya‑la̱ Nainá kis'iìn ya̱ i̱jiìn na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tjín i'nga xi̱ta̱ xi ya̱ chja̱‑ne ni'ya i̱ngo̱ sinagoga ñánda maxkóya xi̱ta̱ judío xi jye títsa̱jnandei̱í‑ne, ko̱ xi̱ta̱ Cirene, xi̱ta̱ Alejandría, xi̱ta̱ Cilicia ko̱ xi ján i̱'nde‑la̱ Asia; tsibíts'ia̱ nga tsakátikjoó ko̱ Esteban. ");
INSERT INTO maaNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ta̱nga xi̱ta̱ koi, mìkiì kisìkijne, nga̱ jè Esteban, ko̱ó kjo̱hítsjeèn‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá kiìchja̱. ");
INSERT INTO maaNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","K'e̱é tsohótsji xi̱ta̱ xi tsibíchjí‑la̱ nga kitsjaàt'in 'én ndiso; kitsò: ―Kina'yà‑la̱je̱n Esteban nga chja̱jno‑la̱ Moisés ko̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","K'oa̱á s'ín komà‑ne nga kòjti‑la̱ jñà xi̱ta̱ na̱xa̱ndá ko̱ xi̱ta̱ jchínga ko̱ xi̱ta̱ xi okóya kjo̱tíxoma‑la̱ Nainá xi kiskiì Moisés. Kitsobà'ñó Esteban, kiìko̱ ñánda títsa̱jna xi̱ta̱xá ítjòn xi joóya‑ne kjo̱tíxoma. ");
INSERT INTO maaNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ijchòko̱ xi̱ta̱ ndiso xi kitsjaàt'in 'én, kitsò: ―Xi̱ta̱ jè, mìkiì jyò bìjna, kjit'aà na̱chrjein chja̱jno‑la̱ jè I̱ngo̱ Tsjeè‑la̱ Nainá ko̱ kjo̱tíxoma xi kiskiì Moisés. ");
INSERT INTO maaNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jyeé kina'yà‑la̱je̱n nga tsò nga jè Jesús xi Nazaret ts'e̱, si̱ìkixòña I̱ngo̱‑la̱ Nainá ti̱koa̱ si̱ìkjatjìya‑la̱ kjo̱tíxoma xi 'né koni s'ín tsakóya‑ná Moisés. ");
INSERT INTO maaNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ngats'iì xi̱ta̱xá xi ya̱ títsa̱jna, k'e̱ nga kiskoò'an Esteban, k'oa̱á s'ín kijtseè i̱sén‑la̱ koni kji i̱sén‑la̱ àkja̱le̱. ");
INSERT INTO maaNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jè xi̱ta̱ sko̱‑la̱ no̱'miì kiskònangui‑la̱ Esteban kitsò‑la̱: ―¿A kixi̱í kjoa̱ nga k'oa̱ tjín jé xi ónè‑lè xi̱ta̱? ");
INSERT INTO maaNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Jè Esteban kitsò: ―'Ndsè, ko̱ xi xi̱ta̱ jchínga 'mì‑nò, ti̱ná'ya‑ná: Jè Nainá, xi 'ñó jeya tíjna, ya̱á ijchòkon ñánda tíjna xi̱ta̱ jchínga‑ná Abraham k'e̱ nga tákó ya̱ tíjna Mesopotamia, k'e̱ nga ti̱kj'eè bijchó kijna ján na̱xa̱ndá Harán. Ko̱ jè Abraham kijtseè tsejèn‑né kó kji Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","K'e̱é kiìchja̱ Nainá, kitsò‑la̱: “Titjo̱jiìn nangui‑lè; ti̱kítsajnei xi̱ta̱ xingui̱i; t'in ki̱jni ya̱ nangui ñánda 'a̱n kokoò‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jè Abraham, itjokàjiìn nangui‑la̱ xi̱ta̱ Caldea; ján kiì kíjna nangui Harán. K'e̱ nga k'en na̱'èn‑la̱, Nainá j'iìko̱ i̱ i̱'nde jè ñánda titsa̱jnaá i̱'ndei̱. ");
INSERT INTO maaNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nainá, ni̱mé i̱'nde kitsjaà kjo̱tjò‑la̱; ni̱ tsà tà i̱tsé ñánda ko̱sìjnasòn jngoò ndso̱ko̱. Ta̱nga k'oa̱á s'ín kitsjaà‑la̱ tso'ba nga kitsò‑la̱ nga ts'e̱é ko̱ma ko̱ ts'e̱é xi̱ta̱ tje̱‑la̱ ni̱ta̱ mé na̱chrjein‑ne. Na̱chrjein koi, kj'eè i̱xtií tjín‑la̱ jè Abraham. ");
INSERT INTO maaNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nainá k'oa̱á s'ín kitsò‑ìsa̱‑la̱: “Jñà tje̱‑lè, xi̱ta̱ chi̱'ndaá ko̱ma; ñijòn sìndo̱ nó xìn na̱xa̱ndá si̱ìjchá yijo‑la̱ nga si̱ìkjeiín kjo̱'in.” ");
INSERT INTO maaNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nainá kitsò: “'A̱án tsjaà‑la̱ kjo̱'in jè na̱xa̱ndá ñánda chi̱'nda kítsa̱jna; k'e̱ nga ko̱ma i̱skan, ki̱tjokàjiìn‑né nangui jè. Kji̱nchrobà ìjngoò k'a‑ne i̱jndé, ko̱ i̱í i̱'nde jè, skoe̱xkón‑na.” ");
INSERT INTO maaNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nainá jngoò kjoa̱ tsibíndaàjiìn‑ko̱ Abraham nga si̱t'aà chi̱ba̱‑la̱ yijo‑la̱ xi̱ta̱ kjoa̱ ts'e̱ circuncisión. Abraham, kis'e jngoò‑la̱ ki'ndí xi Isaac ki'mì; k'e̱ nga ijchò jiìn na̱chrjein nga kits'iìn, tsibít'aà chi̱ba̱‑la̱. Isaac kis'e‑la̱ ki'ndí xi 'mì Jacob; k'oa̱á ti̱s'ín kisìko̱. Jacob, kis'e‑la̱ i̱xti xi tejò ma‑ne tje̱‑la̱ xi̱ta̱ jchínga‑la̱ na̱xa̱ndá Israel. K'oa̱á ti̱s'ín tsibít'aà chi̱ba̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Jñà i̱xti‑la̱ Jacob, xi xi̱ta̱ jchínga‑ná, kjòxìtakòn‑keè jè 'ndse̱ xi 'mì José; i̱kjoàn tsatíjna nga kiìko̱ xi̱ta̱ xi tsatse ján nangui Egipto. Ta̱nga Nainá kisìkinda̱ José. ");
INSERT INTO maaNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nainá kisìchját'aà‑la̱ ni̱ta̱ mé kjoa̱ xi kis'e‑la̱ José. Kitsjaà‑la̱ kjo̱hítsjeèn, kitsjaà‑la̱ kjo̱ndaà nguixko̱n faraón xi xi̱ta̱xá ítjòn tíjna ján na̱xa̱ndá Egipto. Jè Faraón kisìkíjna José nga jè tsatíxoma‑la̱ na̱xa̱ndá Egipto, ti̱koa̱ jè tsatíxoma ni'ya‑la̱ faraón. ");
INSERT INTO maaNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Jñà na̱chrjein koi j'iì kjinchrá kóho̱kji nangui Egipto ko̱ i̱'nde Canaán; tseé kjo̱'in kis'e‑la̱ xi̱ta̱; jñà xi̱ta̱ jchínga‑ná tsjìn tsojmì xi kine. ");
INSERT INTO maaNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","K'e̱ nga kiì'nchré Jacob nga tjín tsojmì xi ma chine ján Egipto kisìkasén nga kiìkjaá ítjòn tsojmì i̱xti‑la̱ jñà xi xi̱ta̱ jchínga‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Xi komà jò k'a nga kiìkjaá tsojmì, José tsakó‑la̱ yijo‑la̱ xíkjín nga 'ndse̱ ma‑ne. Faraón k'oa̱á s'ín komà‑ne kijtseèxkon, ñánda nchrobát'aà‑ne tje̱‑la̱ José. ");
INSERT INTO maaNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","José kiskinìkjaá Jacob xi na̱'èn‑la̱ ma nga kji̱tji̱ngui‑la̱ ján Egipto. Ngats'iì xi̱ta̱ xíkjín, jàn kaàn ko̱ chrj'oòn ma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","K'oa̱á s'ín komà‑ne nga kiì Jacob ján Egipto; ya̱á k'en; ti̱koa̱á ya̱á k'en ngats'iì i̱xti‑la̱ jñà xi xi̱ta̱ jchínga‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Xi komà i̱skan, kiìko̱ nindaà‑la̱ Jacob ko̱ ts'e̱ ti‑la̱ nga kiì kíhijiìn jngoò nga̱jo̱ i̱tsjó ján Siquem; i̱'nde ñánda tsatse Abraham xi tsatíjna i̱xti‑la̱ Hamor. ");
INSERT INTO maaNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’K'e̱ nga jye kjòchrañà na̱chrjein nga ki̱tasòn 'én koni s'ín kitsjaà tso'ba Nainá koni s'ín tsajoókjoò Abraham, jè na̱xa̱ndá Israel, 'ñó kòkjìn‑ya jñà xi̱ta̱‑la̱ ján Egipto. ");
INSERT INTO maaNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ijchò na̱chrjein nga ìjngoò xi̱ta̱ kisakò xi xi̱ta̱ sko̱‑la̱ tsibìjna ján Egipto; ta̱nga xi̱ta̱ jè, mìkiì beèxkon José. ");
INSERT INTO maaNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Xi̱ta̱xá ítjòn jè, tsibíts'ia̱ nga kiskoòna̱cha̱n‑la̱ xi̱ta̱ jchínga‑ná nga kijtseètoòn; kis'iìn‑la̱ kjo̱'ñó nga kitsjeiìn takòn ngats'iì ndí i̱xti‑la̱ mé‑ne nga kàtiyaà yije‑ne nga kàtachija tje̱‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ti̱jñà‑ne na̱chrjein koi, kits'iìn Moisés. Ki'ndí jè, 'ñó ndaà kji i̱sén‑la̱. Jàn sá kisìkíjna'ma ni'ya‑la̱ xi̱ta̱ jchínga‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","K'e̱ nga ijchò síkíjna i̱jiìn nandá, jè tsòti‑la̱ faraón kiskoétjò, kisìjchá koni tsà ki'ndí ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jè Moisés kiskoòta'yà ngats'iì kjoa̱chji̱ne̱ xi tjín Egipto. 'Ñó ndaà kjo̱hítsjeèn xi kis'e‑la̱, ndaà kiìchja̱ ti̱koa̱ ndaà kis'iìn. ");
INSERT INTO maaNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Moisés, k'e̱ nga jye tjín‑la̱ ichán nó k'oa̱á s'ín tsi'beé‑la̱ ikon nga mejèn kiìkon xi̱ta̱ na̱xa̱ndá Israel xíkjín. ");
INSERT INTO maaNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Moisés, k'e̱ nga kijtseè nga ch'o tínìko̱ jngoò xi̱ta̱ Israel xíkjín, tsasìko̱ nga kisìk'en xi̱ta̱ Egipto mé‑ne nga kòjndà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés, k'oa̱á s'ín tísíkítsjeèn, maá‑la̱ tsà tímachi̱yaá‑la̱ jñà xi̱ta̱ Israel xíkjín nga jè Moisés si̱ìkjeén Nainá nga si̱ìkítsa̱jnandei̱í; ta̱nga jñà xi̱ta̱ Israel mìkiì kjòchi̱ya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","K'e̱ nga komà inchijòn, Moisés kijtseè jò xi̱ta̱ Israel xi nchikjaán‑kjoò, mejèn‑la̱ ko̱tekjáya‑la̱, kitsò‑la̱: “Jñò xi 'ndsè chiba, ¿mé‑ne bixkàn‑ko̱‑nò xinguio̱o?” ");
INSERT INTO maaNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jè xi̱ta̱ xi tíkjaán‑ko̱ xíkjín, k'e̱é kiì jahi̱tje̱n Moisés, kitsò‑la̱: “¿Yá xi xi̱ta̱xá kàsíkíjna‑lè ko̱ xi ixkàle̱ kàtsò‑lè xi i̱t'aà tsa̱je̱n? ");
INSERT INTO maaNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A ti̱koa̱á mejèn‑lè nga si̱k'en‑ná koni s'ín kinìk'in ngojña̱ jè xi̱ta̱ Egipto?” ");
INSERT INTO maaNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moisés, k'e̱ nga kiì'nchré 'én koi, tsanga‑né; ján kiì kíjna i̱'nde ñánda 'mì Madián. K'oa̱á s'ín tsibìjna koni jngoò xi̱ta̱ xi kjiìn i̱'nde‑la̱; jò i̱xti kis'e‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’K'e̱ nga jye ijchò ichán nó nga tíjna Madián, Moisés, tsatsejèn jngoò‑la̱ àkja̱le̱‑la̱ Nainá xi ya̱ síjnajiìn ni'ín ñánda títì jngoò yá na'yá ya̱ chrañàt'aà‑la̱ nindoò Sinaí, ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn. ");
INSERT INTO maaNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés, k'e̱ nga tíkotsejèn‑la̱ jè yá na'yá xi títì, tà kjòxkón‑la̱ koni s'ín tíma; k'e̱ nga ìsa̱ chrañàt'aà kiì kasìjna nga ìsa̱ ndaà skoe̱, kiì'nchré jta̱‑la̱ Nainá nga kiìchja̱‑la̱, kitsò: ");
INSERT INTO maaNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“'A̱n‑ná xi Nainá tsò‑na xi̱ta̱ jchínga‑lè, Nainá tsò‑na Abraham, ko̱ Isaac, ko̱ Jacob.” Ta̱nga jè Moisés tà tsatsé‑né nga 'ñó kitsakjòn, mìkiì kitsò‑ikon nga kiskoòtsejèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jè Nainá kitsò‑la̱ Moisés: “Chja̱àxìn xo̱jté xi titsjayi; jè i̱'nde ñánda tisìjnasoìn, i̱'nde tsjeè‑né. ");
INSERT INTO maaNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ndaà tìbe kjo̱'in xi nchisíkjeiín xi̱ta̱‑na̱ xi títsa̱jna Egipto. Jyeé ki'nchrè‑la̱ nga nchihojét'aà‑na; koií xá kòbitjojen‑na nga siìkítsa̱jnandia̱á. Koií xá tìchjà‑lè, nchroboí, ján siìkasén‑lè Egipto.” ");
INSERT INTO maaNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Jñà xi̱ta̱ Israel na̱s'ín tsachrjekàngui Moisés k'e̱ nga kitsò‑la̱: “¿Yá xi xi̱ta̱xá kàsíkíjna‑lè ko̱ xi ixkàle̱ kàtsò‑lè?”, ta̱nga jè sobá Nainá kisìkasén ján na̱xa̱ndá Egipto koni jngoò xi̱ta̱xá ítjòn xi kisìkítsa̱jnandei̱í xi̱ta̱ Israel. Nainá kisìkjeén jè àkja̱le̱ xi tsatsejèn‑jiìn yá na'yá xi títì. ");
INSERT INTO maaNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jé Moisés xi tsachrjekàjiìn xi̱ta̱ Israel ján na̱xa̱ndá Egipto. Nainá kisìkjeén Moisés nga 'ñó kjìn kjo̱xkón kis'iìn kóho̱kji Egipto, ko̱ ya̱ Ndáchikon Inì, kóho̱kji ñánda nangui kixì choòn nga ichán nó chinchimaya ndi̱yá. ");
INSERT INTO maaNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ti̱jè‑ne Moisés xi kitsò‑la̱ jñà xi̱ta̱ Israel: “Nainá ko̱chrjekàjiìn jngoò xi ti̱ xi̱ta̱ xinguio̱o‑nò, jè xi ki̱chja̱ ngajo‑la̱ Nainá koni 'a̱n.” ");
INSERT INTO maaNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ti̱koa̱á ti̱jè‑ne Moisés xi tsibìjnako̱ xi̱ta̱ na̱xa̱ndá Israel ya̱ ñánda nangui kixì choòn, jè xi tsohóko̱ àkja̱le̱ ya̱ nindoò Sinaí, jè xi tsajmeiìko̱ xi̱ta̱ jchínga‑ná nga kisìkatoya‑la̱ 'én xi kitsjaà‑la̱ àkja̱le̱; ti̱koa̱á ti̱jè‑ne xi kitjoé‑la̱ 'én‑la̱ Nainá xi síkíjnakon‑ná mé‑ne komà kisìkatoya‑ná jñà 'én. ");
INSERT INTO maaNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Ta̱nga jñà xi̱ta̱ jchínga‑ná, tsachrjenguií 'én xi kitsjaà Moisés, mìkiì kisìkitasòn. K'oa̱á s'ín kisìkítsjeèn i̱jiìn ini̱ma̱‑la̱, mejèn kiì ìjngoò k'a‑ne ján Egipto. ");
INSERT INTO maaNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kitsò‑la̱ jè Aarón: “Tìndaà i'nga‑ná nainá xi kji̱ko̱‑ná. Jè Moisés xi tsachrjekàjiìn‑ná ján nangui Egipto, mìkiì 'yaá mé xi komà‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","K'e̱é tsibíndaà jngoò xkósòn xi nainá kitsò‑la̱ xi i̱sén‑la̱ nchra̱ja̱ ki'ndí kji; kisìk'en cho̱ kjo̱tjò xi kitsjaà‑la̱ jè nchra̱ja̱ nga kijtseèxkón, i̱kjoàn tsibíjna jngoò‑la̱ s'eí xi i̱t'aà ts'e̱ xkósòn xi ti̱jñà tsibíndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Koií kjoa̱‑la̱ tsasìt'aàxìn Nainá i̱t'aà ts'e̱ xi̱ta̱ Israel. Kitsjaà'nde‑la̱ nga kijtseèxkón yije ni'ño xi tjín ngajmiì. K'oa̱á s'ín tíchja̱ jè xo̱jo̱n xi kiskiì jñà xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá nga tsò: Jñò xi xi̱ta̱ na̱xa̱ndá Israel tsa̱jòn, k'e̱ nga ichán nó tsitjaàyaà ndi̱yá ya̱ ñánda nangui kixì choòn, ko̱ kinìk'eèn cho̱ nga mejèn‑nò kits'iì kjo̱tjò‑ná, mìtsà 'a̱n kiyaxkón‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Majìn, ta̱ sa̱á kichijeèn ni'ya nikje‑la̱ Moloc, ko̱ ni'ño ts'e̱ Renfán xi nainá 'mì‑là; jñà i̱sén xi ti̱jñò tsibìndaà‑nò nga kiyaxkón. Koií kjoa̱‑la̱ nga ko̱chrjekàjiìn‑nò i̱'nde tsa̱jòn. Ján siìkasén‑nò ñánda nga ìsa̱ kjiìn‑la̱ Babilonia. ");
INSERT INTO maaNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Ya̱ ñánda nangui kixì choòn, jñà xi̱ta̱ jchínga‑ná kis'e‑la̱ Ni'ya Tsjeè xi nikje ñánda kjiyijòya kjo̱tíxoma‑la̱ Nainá. K'oa̱á s'ín kisindaà koni s'ín tsatíxoma‑la̱ Nainá jè Moisés k'e̱ nga kitsò‑la̱ nga kàtíndaà jngoò ni'ya koni kji i̱sén‑la̱ ni'ya xi jye jè tsakó‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ni'ya tsjeè jè xi nikje, jñà xi̱ta̱ jchínga‑ná kjònga̱tsja; jñà xi̱ta̱ Israel xi tji̱ko̱ Josué, j'iìko̱ ni'ya jè, k'e̱ nga jahas'en nangui i̱jndé ñánda Nainá kitsjaà‑la̱ ko̱ tsachrjekàjiìn nangui‑la̱ jñà xi̱ta̱ na̱xa̱ndá xi kj'ei̱í. Ni'ya jè, ya̱á kisijna skanda na̱chrjein ts'e̱ xi̱ta̱xá ítjòn xi David ki'mì. ");
INSERT INTO maaNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nainá, 'ñó ndaà kisaseèn takòn David. Ko̱ jè David mejèn‑la̱ koi̱ìndaà jngoò‑la̱ ni'ya ñánda jeya kíjna Nainá xi beèxkón jñà xi̱ta̱ tje̱‑la̱ Jacob. ");
INSERT INTO maaNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ta̱nga jè xi̱ta̱xá ítjòn xi ki'mì Salomón, jè xi tsibíndaà jngoò‑la̱ ni'ya Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nainá xi 'ñó 'nga tíjna, mìtsà ya̱ tíjnaya ni'ya xi xi̱ta̱ bíndaà. Jè xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá kitsò: ");
INSERT INTO maaNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Jè ngajmiì, jè íxi̱le̱‑na̱ ñánda otiìxoma; jè i̱sò'nde, k'oa̱á ngaya‑la̱ koni jngoò ísko̱n ñánda nchasòn ndso̱koaà. ¿A ko̱maá‑nò nga kíndaà jngoò‑ná ni'ya ñánda siìkjáya? tsò Na̱'èn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿A mìtsà 'a̱n sobà xi tsibìndaà yije tsojmì koi? ");
INSERT INTO maaNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Jè Esteban kitsò‑ìsa‑la̱: ―Jñò, kjit'aà na̱chrjein, 'ñó tájaàjiìn tjín ini̱ma̱‑nò, ko̱ mìkiì ndaà na'yà koni s'ín jñà xi mìtsà xi̱ta̱‑la̱ Nainá. Kjit'aà na̱chrjein kondra̱ onguí‑là Ini̱ma̱ Tsjeè‑la̱ Nainá koni kis'iìn jñà xi̱ta̱ jchínga‑nò. ");
INSERT INTO maaNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ni̱jngoò xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá xi mì kondra̱ kiì‑la̱; kisìk'en jñà xi̱ta̱ xi j'iì kéno̱jmí i̱t'aà ts'e̱ jè xi̱ta̱ kixi̱ xi tjínè‑la̱ nga kjoi̱í. I̱'ndei̱, nga jye j'iì jè xi̱ta̱ kixi̱, ya̱á kinìnga̱tsja jñà xi̱ta̱xá nga kisìk'en. ");
INSERT INTO maaNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Jñò, na̱s'ín i̱t'aà ts'e̱ àkja̱le̱‑la̱ Nainá kitjoé‑nò kjo̱tíxoma, ta̱nga mìkiì nìkitasòn. ");
INSERT INTO maaNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","K'e̱ nga kiì'nchré 'én xi kiìchja̱ Esteban, 'ñó jti komà‑la̱ i̱jiìn ini̱ma̱‑la̱, chi̱ba̱‑la̱ kinenè ni̱'ño̱ xi kondra̱ ts'e̱ Esteban. ");
INSERT INTO maaNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Jè Esteban, 'ñó ndaà tíjiìn ini̱ma̱‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá. Kiskoòtsejèn ngajmiì; kijtseè kjoa̱jeya‑la̱ Nainá nga Jesús ya̱ síjnat'aà chrja kixi̱‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kitsò Esteban: ―Tíbe‑ná ngajmiì nga ti̱x'á; jè xi Ki'ndí‑la̱ Xi̱ta̱ tsò‑la̱ yijo‑la̱ ya̱á síjnat'aà chrja kixi̱‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ngats'iì xi̱ta̱ koi, tsibíchjoàjto líká‑la̱; i̱kjoàn 'ñó kiskindàya; jngoò k'a kiì kóho̱tjín nga jahatje̱n Esteban; ");
INSERT INTO maaNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","tsachrjekàjiìn na̱xa̱ndá; ko̱ jñà xi̱ta̱ ndiso xi kitsját'in 'én xi kondra̱ kiì‑la̱ Esteban, ya̱á tsibítsa̱jnangui ndso̱ko̱ jñà nikje‑la̱ ñánda síjna jngoò xi̱ta̱ i̱xti xi 'mì Saulo mé‑ne nga komà tsibínè‑ne nda̱jo̱ nga kisìk'en. ");
INSERT INTO maaNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","K'e̱ nga tísinè nda̱jo̱, Esteban tíchja̱t'aà‑la̱ Nainá, kitsò: ―Na̱'èn Jesús, chjoétjoì ini̱ma̱‑na̱. ");
INSERT INTO maaNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Esteban tsasìjna-xkó'nchi, i̱kjoàn 'ñó kiìchja̱ kitsò: ―¡Na̱'èn, kì kinda̱á 'nì jé‑la̱ xi̱ta̱ koi! K'e̱ nga jye o̱kitsò, k'en. ");
INSERT INTO maaNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Jè Saulo, nga ya̱ síjna ti̱koa̱á kisìjngoò ikon nga kinìk'en Esteban. Kjòts'ia̱‑ne na̱chrjein jè nga 'ñó kiìtji̱ngui kondra̱‑la̱ xi̱ta̱ ngats'iì xi̱ta̱ na̱xa̱ndá‑la̱ Cristo ján Jerusalén. Kóho̱tjín xi̱ta̱‑la̱ Cristo kitsjohoba kóho̱kji nangui Judea ko̱ Samaria. Tà jñà tsiningui‑ne xi̱ta̱ xi tsibíxáya‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tjín i'nga xi̱ta̱ xi beèxkón Nainá, jñà tsibíhijiìn Esteban. 'Ñó kiskindàyakeè. ");
INSERT INTO maaNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ta̱nga jè Saulo, 'ñó kiìtji̱ngui kondra̱‑la̱ xi̱ta̱ na̱xa̱ndá‑la̱ Cristo. Xki̱ xi ján ni'ya jahas'en nga kjo̱'ñó ochrje íchjín ko̱ íchjá, i̱kjoàn kinís'en nda̱yá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jñà xi̱ta̱ xi kitsjohoba, xki̱ xi ján kiì nga kisìka'bí 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jè Felipe, k'e̱ nga ijchò na̱xa̱ndá Samaria, ya̱á tsibéno̱jmí i̱t'aà ts'e̱ Cristo xi̱ta̱ xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jñà xi̱ta̱ Samaria nga kjìn ma, k'e̱ nga kiì'nchré ti̱koa̱ kijtseè jñà kjo̱xkón ndaà xi kis'iìn Felipe, kóho̱tjín, ìsa̱á ndaà kiì'nchré‑ìsa̱ koni s'ín tsibéno̱jmíya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kjìn xi̱ta̱ xi ini̱ma̱ ch'o‑la̱ nei̱í tíjiìn ini̱ma̱‑la̱ kjòndaà‑ne. Jñà ini̱ma̱ ch'o‑la̱ nei̱í, 'ñó kjindáya k'e̱ nga bitjojiìn ini̱ma̱‑la̱ xi̱ta̱. Ti̱koa̱á kjìn xi̱ta̱ i̱ma̱ kjòndaà‑ne xi mìkiì ma síhiníyá yijo‑la̱ ko̱ xi tsá'yá kjoàn. ");
INSERT INTO maaNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","K'oa̱á ma‑ne nga jñà xi̱ta̱ na̱xa̱ndá jè, 'ñó tsja kis'e‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ya̱ Samaria tsibìjna jngoò xi̱ta̱ xi Simón ki'mì. K'e̱ nga sa̱ ítjòn, maá‑la̱ bíndaà. Kjìn nó kiskoòna̱cha̱n‑la̱ xi̱ta̱ xi ya̱ i̱'nde‑la̱ nga chincháxkón‑la̱ nga kitsò: “'A̱n 'ñó ndaà machi̱ya‑na̱.” ");
INSERT INTO maaNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ngats'iì xi̱ta̱ i̱xti ko̱ xi̱ta̱ jchínga, ndaà kiì'nchréñijon‑la̱; kitsò: ―Jè xi̱ta̱ jè xi tse nga'ñó tjín‑la̱ i̱t'aà ts'e̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Koií kjoa̱‑la̱ nga ndaà kiì'nchréñijon‑la̱ nga jye kò kjìn nó kona̱cha̱n‑la̱ nga bincháxkón‑la̱ nga 'ñó ndaà ma‑la̱ bíndaà. ");
INSERT INTO maaNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Jñà xi̱ta̱, k'e̱ nga kòkjeiín‑la̱ 'én ndaà‑la̱ Nainá kó s'ín otíxoma Nainá ko̱ i̱t'aà ts'e̱ Jesucristo xi jè Felipe tíbéno̱jmí, tsibíts'ia̱ nga komà bautizar íchjín íchjá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Skanda ti̱jè‑ne Simón ti̱koa̱á kòkjeiín‑la̱; i̱kjoàn komà bautizar. Ñánda tsajmeè Felipe, ya̱á tsajmeiìko̱ Simón. Tà k'oa̱á ma‑la̱ nga tíbeè kjo̱xkón ndaà xi tís'ín Felipe ko̱ kjoa̱ xi okó kjoa̱ jeya‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús xi títsa̱jna Jerusalén, k'e̱ nga kiì'nchré nga jñà xi̱ta̱ Samaria jyeé kòkjeiín‑la̱ 'én‑la̱ Nainá, kisìkasén jè Pedro ko̱ Juan. ");
INSERT INTO maaNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Jñà xi̱ta̱ koi, k'e̱ nga jye ijchò Samaria, tsibítsi'batjì jñà xi̱ta̱ xi jye kòkjeiín‑la̱ mé‑ne nga tjoé‑la̱ jè Ini̱ma̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nga̱ jè na̱chrjein jè, ni̱ sa̱á jngoò tjoé‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá. Sà tà jè i̱t'aà ts'e̱ Na̱'èn‑ná Jesús komà bautizar xi̱ta̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jè Pedro ko̱ Juan, k'e̱é tsohósòn‑la̱ tsja, i̱kjoàn kitjoé‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jè Simón, k'e̱ nga kijtseè nga jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús, ósòn‑la̱ tsja jñà xi̱ta̱, ni̱to̱ón tjoé‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá, jè Simón tsibít'aà‑la̱ to̱n jñà xi̱ta̱‑la̱ Cristo, ");
INSERT INTO maaNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kitsò‑la̱: ―'A̱n, ti̱koa̱ tjiì‑ná nga'ñó jè, mé‑ne ni̱ta̱ yá xi̱ta̱‑ne xi kosòn‑la̱ ndsa̱a ti̱koa̱ tjoé‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Jè Pedro kitsò‑la̱: ―¡Kàtiyaàkoi̱i to̱n‑lè! Ngaji̱, k'oa̱á s'ín nìkítsjiìn tsà maá bindaà‑ná kjo̱tjò xi tsjá Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ngaji̱ mìkiì tjí'nde‑lè i̱t'aà ts'e̱ xá jè nga jè ini̱ma̱‑lè mì kixi̱ tíjna nguixko̱n Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ti̱kájnoi jé‑lè, nga ch'o tsò ya̱ i̱jiìn ini̱ma̱‑lè, kì ti̱ jé binchaàtsji‑ne. Ti̱jét'aà‑la̱ Nainá tsà koi na̱chrjein‑la̱ si̱ìjchàat'aà‑lè jé‑lè. ");
INSERT INTO maaNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Be‑ná nga jè kjoa̱xìtakòn xi tíjiìn ini̱ma̱‑lè ko̱ jè kjoa̱ch'o‑lè mìkiì tsjá'nde‑lè nga ndaà 'nì. ");
INSERT INTO maaNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Jè Simón k'e̱é kitsò: ―Síjét'aà‑nò, titsi'ba‑là Nainá xi i̱t'aà ts'a̱n mé‑ne nga mì k'oa̱ s'ín ko̱mat'ian ngats'iì kjoa̱ xi k'oa̱s'ín titsa̱'mì‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús, k'e̱ nga jye kitsjaà 'én i̱t'aà ts'e̱ Cristo ti̱koa̱ tsakóya 'én ndaà‑la̱ Nainá, kiì ìjngoò k'a‑ne ján Jerusalén. K'e̱ nga chinchimaya ndi̱yá, kjìn xi̱ta̱ na̱xa̱ndá jtobá xi chja̱‑ne Samaria tsibéno̱jmí‑la̱ 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Xi jye komà, jngoò àkja̱le̱‑la̱ Nainá kiìchja̱‑la̱ Felipe, kitsò‑la̱: ―Ti̱sítji̱in, t'in kixi̱i ndi̱yá xi bitjokàt'aà‑ne Jerusalén, fìjen bijchó skanda Gaza. (Ndi̱yá jè, ya̱á fahato ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn.) ");
INSERT INTO maaNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe, tsasítje̱n, kiì; ya̱ i̱ya ndi̱yá kisatiìkjoò jngoò xi̱ta̱ x'i̱n ts'e̱ Etiopía xi 'ñó 'nga xá tjín‑la̱ xi jye kjòxkiì‑la̱ nga mì ti̱ íchjín si̱ìs'in‑ne; tesorero tjín‑la̱ ts'e̱ chjo̱ón sko̱‑la̱ Etiopía xi 'mì Candace. Jerusalén j'iì‑ne xi̱ta̱ jè nga kiì i̱ngo̱ ñánda beèxkón Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Xi̱ta̱ jè, k'e̱ nga tínchrobá‑ne nangui‑la̱, tíjnaya carreta‑la̱; tíbíxke̱jiìn xo̱jo̱n xi kiskiì Isaías, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jè Ini̱ma̱ Tsjeè‑la̱ Nainá kitsò‑la̱ Felipe: ―T'in tji̱ngui‑la̱ carreta jè, tsjahijtakoi̱i. ");
INSERT INTO maaNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe ni̱to̱ón kiìtji̱ngui‑la̱, kiì'nchré‑la̱ jè xi̱ta̱ nga tíbíxke̱jiìn xo̱jo̱n xi kiskiì Isaías, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá; i̱kjoàn kiskònangui‑la̱ kitsò‑la̱: ―¿A fìyaá‑lè kó s'ín tíchja̱ xo̱jo̱n xi tìbìxke̱jiìn? ");
INSERT INTO maaNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Jè xi̱ta̱ etiope kitsò: ―¿Kó s'ín ko̱ma kji̱ya‑na nga mì yá béno̱jmíya‑na? K'e̱é tsibítsi'ba‑la̱ Felipe nga tsijin‑jno carreta; ya̱á tsibìjnayako̱. ");
INSERT INTO maaNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jè Xo̱jo̱n‑la̱ Nainá xi tíbíxke̱jiìn ts'e̱ Isaías tsò‑né: Kiìko̱ koni jngoò orrè nga kiì sík'en; k'oa̱á ngaya‑la̱ koni jngoò orrè ki'ndí xi mìkiì kjindáya k'e̱ nga tísìjno‑la̱, k'oa̱á s'ín mìkiì kiìchja̱ k'e̱ nga tsatojiìn kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","K'e̱ nga tsachrjekàngui xi̱ta̱, mì kixi̱ kisindaàjiìn‑la̱. Nga mì yá xi̱ta̱ tje̱ s'e̱‑la̱, ni̱yá xi si̱ìkítsjeèn, nga jè, kinìk'en‑né i̱ i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jè xi̱ta̱ etiope kitsò‑la̱ Felipe: ―T'i̱in kjo̱ndaà. Tèno̱jmíya‑ná yá‑né xi k'oa̱s'ín títsò‑la̱ jè Isaías; ¿a kj'ei̱í xi̱ta̱‑né, a xi ti̱jè‑ne yijo‑la̱? ");
INSERT INTO maaNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipe tsibíts'ia̱ko̱‑ne jè xo̱jo̱n xi tíbíxke̱jiìn xi̱ta̱ etiope; tsibéno̱jmí yije‑la̱ i̱t'aà ts'e̱ 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Koni s'ín nchifìya ndi̱yá, ijchò jngoò i̱'nde ñánda tjín nandá, kitsò xi̱ta̱ etiope: ―I̱'nde jè, tjín nandá; ¿a mìtsà ndaà s'e̱ tsà s'iaàn bautizar yijo‑na̱? ");
INSERT INTO maaNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe kitsò‑la̱: ―Tsà ko̱ó ini̱ma̱‑lè nga ndaà mokjeiín‑lè ko̱ma‑né. Xi̱ta̱ jè kitsò: ―Mokjeiín‑na nga Jesús, jè xi Cristo xi Ki'ndí‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ko̱ kitsjaà o̱kixi̱ nga tsasíjna carreta, i̱kjoàn tsitajen ingajò, jahas'en‑jiìn nandá, jè Felipe kis'iìn bautizar. ");
INSERT INTO maaNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","K'e̱ nga jye itjokàjiìn‑ne nandá, Felipe, tà ni̱to̱ón kichijà; jè Ini̱ma̱ Tsjeè‑la̱ Nainá kiìko̱; mì ti̱ kiì kijtseèxkon‑ne xíkjín; ta̱nga jè xi̱ta̱ etiope, k'e̱ nga tífì ya̱ ndi̱yá, tsjaá jchán tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jè Felipe k'e̱ nga kjòchi̱ya‑la̱ jye ya̱ tíjna na̱xa̱ndá Azoto; xki̱ xi ján na̱xa̱ndá tsibéno̱jmí 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo skanda k'e̱ nga ijchò na̱xa̱ndá xi 'mì Cesarea. ");
INSERT INTO maaNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo, xki̱ xi ján i̱'nde bincháxkón‑la̱ xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo nga mejèn‑la̱ si̱ìk'en. K'oa̱á ma‑ne nga kiìkon jè no̱'miì ítjòn, ");
INSERT INTO maaNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nga kisìjé‑la̱ xo̱jo̱n xi tjín‑la̱ nga'ñó xi k'oa̱ ts'e̱ jñà ni'ya i̱ngo̱ sinagoga ján Damasco, mé‑ne nga ko̱ma tsobà'ñó‑ne xi̱ta̱ íchjín ko̱ íchjá xi fìt'aà‑la̱ jè ndi̱yá xi̱tse̱‑la̱ Cristo; i̱kjoàn kji̱nchrobàko̱ Jerusalén nga si̱ìkítsa̱jna nda̱yá. ");
INSERT INTO maaNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","K'e̱ nga nchifìya ndi̱yá nga jye kjòchrañàt'aà‑la̱ na̱xa̱ndá Damasco, tà ni̱to̱ón kjòhiseèn jngoò itjandiì‑la̱ jngoò ni'ín xi inchrobà‑ne ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Jè Saulo kiskaàjndoòt'aà nangui, i̱kjoàn kiì'nchré‑la̱ 'én xi kiìchja̱jiìn i̱sén xi kitsò: ―Saulo, Saulo, ¿mé‑ne 'a̱n tì'mìtji̱ngui kondra̱‑ná? ");
INSERT INTO maaNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo kitsò: ―¿Yá‑né ngaji̱, Na̱'èn? Jè xi tíchja̱ kitsò: ―'A̱n‑ná Jesús xi tì'mìtji̱ngui kondra̱‑ná. Ti̱ji̱í tìyatoòn‑ne yijo‑lè, k'oa̱á ngaya‑la̱ koni tsà nchra̱ja̱ tsjón‑la̱ jè yá xi bínès'en‑la̱ nei‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo, tsí tsatsé‑né; tsí ndaà kitsakjòn; k'e̱é kitsò: ―Na̱'èn, ¿mé xi mejèn‑lè nga 'a̱n s'iaàn? Jè Na̱'èn‑ná kitsò‑la̱: ―Ti̱sítji̱in, ti̱tjás'e̱n‑jiìn na̱xa̱ndá; ya̱á s'e̱no̱jmí‑lè mé xi s'i̱in. ");
INSERT INTO maaNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Jñà xi̱ta̱ xi tji̱ko̱ Saulo, tà kisinchaà‑né nga 'ñó kitsakjòn; kiì'nchré‑la̱ jè xi tíchja̱ ta̱nga mìkiì kijtseèxkon yá xi tíchja̱. ");
INSERT INTO maaNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jè Saulo, tsasítje̱n‑t'aà‑ne nangui, ta̱nga k'e̱ nga kiskíx'a̱ xko̱n mì ti̱ kiì kjòtsejèn‑la̱. Tà jñà xi̱ta̱ xi tji̱ko̱ kitsobàt'aà, kiìko̱ ján Damasco. ");
INSERT INTO maaNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Jàn na̱chrjein tsibìjna nga mì ti̱ kiì kotsejèn‑la̱; ni̱mé xi kiskine ti̱koa̱ ni̱mé xi kits'iì. ");
INSERT INTO maaNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ya̱ na̱xa̱ndá Damasco tíjna jngoò xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo xi 'mì Ananías; Nainá kiìchja̱‑la̱ nga tsatsejèn jngoò‑la̱ kjoa̱ koni tsà nijñá tí'biì‑la̱, kitsò‑la̱: ―¡Ananías! Kiìchja̱ Ananías kitsò: ―¿Mé‑ne Na̱'èn? ¿Mé xi mejèn‑lè? ");
INSERT INTO maaNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jè Na̱'èn‑ná kitsò‑la̱: ―Ti̱sítji̱in, t'in jè calle xi 'mì Calle Kixi̱, ya̱ ni'ya‑la̱ Judas; ya̱ ti̱nchátsji jngoiì xi̱ta̱ xi 'mì Saulo xi ya̱ i̱'nde‑la̱ Tarso. I̱'ndei̱, tíbítsi'ba‑né. ");
INSERT INTO maaNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Saulo jyeé kòbeè jngoò kjoa̱ koni tsà nijñá tí'biì‑la̱ xi tsò: jngoò xi̱ta̱ xi 'mì Ananías kòbijchókon nga kòhósòn‑la̱ tsja nga kòmandaà ìjngoò k'a‑ne xko̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías, k'e̱ nga kiì'nchré kitsò: ―Na̱'èn, tíjiìn‑na, kjìn xi̱ta̱ jye tsibéno̱jmí‑na nga 'ñó ch'o kjoàn xi̱ta̱ jè; jè‑né xi 'ñó tíbeètoòn xi̱ta̱ tsi̱ji ján Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","I̱'ndei̱ koií xá j'iì‑ne skanda i̱jndé, tjín‑la̱ o̱kixi̱ i̱t'aà ts'e̱ no̱'miì ítjòn nga tso̱ba̱'ñó ngats'iì xi̱ta̱ xi mokjeiín‑la̱ i̱t'aà tsi̱ji. ");
INSERT INTO maaNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nainá kitsò‑la̱ Ananías: ―Tich'oín xi̱ta̱ jè; xó jaàjiìn‑na; k'oa̱á s'ín ko̱chjeén‑na nga jè ki̱chja̱ya i̱t'aà ts'a̱n nga tíjtsa i̱sò'nde nguixko̱n ngats'iì xi̱ta̱ xi mìtsà xi̱ta̱ judío ko̱ xi̱ta̱xá ítjòn‑la̱, ti̱koa̱ jñà xi xi̱ta̱ Israel. ");
INSERT INTO maaNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","'A̱án kokoò yije‑la̱ kjo̱'in xi 'ñó tse si̱ìkjeiín xi kjoa̱ ts'a̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías kiì ñánda tíjna Saulo; jahas'en ni'ya. Tsohósòn‑la̱ tsja, kitsò‑la̱: ―'Ndsè Saulo, jè Na̱'èn‑ná Jesús xi kiìchja̱‑lè ya̱ i̱ya ndi̱yá k'e̱ nga tjinchroboí, jè kàsíkasén‑na nga ko̱tsejèn ìjngoò k'a‑lè ti̱koa̱ si̱jiìn ini̱ma̱‑lè Ini̱ma̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Saulo, ni̱to̱ón kitjaàxìn‑la̱ xko̱n xi koni kjoàn chrjoa̱ to̱n‑la̱ ti̱n. I̱kjoàn kjòtsejèn ìjngoò k'a‑la̱. K'e̱é tsasítje̱n, i̱kjoàn komà bautizar. ");
INSERT INTO maaNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Saulo, tsakjèn; i̱kjoàn kis'e ìjngoò k'a‑la̱ nga'ñó. Tsibìjnako̱ chiba na̱chrjein jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo xi títsa̱jna Damasco. ");
INSERT INTO maaNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Saulo, ni̱to̱ón tsibíts'ia̱ nga kiìchja̱ya i̱t'aà ts'e̱ Jesús ya̱ ngats'iì ni'ya i̱ngo̱ sinagoga nga jè Jesús, jè xi Ki'ndí‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ngats'iì xi̱ta̱ xi kiì'nchré‑la̱ tà kjòxkón‑la̱; kitsò‑la̱ xíkjín: ―¿A mìtsà jè xi̱ta̱ jè xi tsangatji̱ngui‑la̱ xi̱ta̱ ján Jerusalén, jñà xi mokjeiín‑la̱ i̱t'aà ts'e̱ Jesús? ¿A mìtsà ti̱koa̱ koií xá j'iì‑ne i̱jndé nga nda̱yá kji̱ko̱ yije xi̱ta̱ koi, i̱kjoàn si̱ìnga̱tsja no̱'miì ítjòn? ");
INSERT INTO maaNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ta̱nga Saulo, ìsa̱á 'ñó tse nga'ñó tísijiìn ini̱ma̱‑la̱ nga chja̱ya. Jñà xi̱ta̱ judío xi títsa̱jna Damasco, skanda mì ti̱ kiì beè‑ne kós'ín si̱ìkítsjeèn koni s'ín tsakóya Saulo nga nguì 'én kixi̱‑né nga Jesús, jè xi Cristo jè xi xó kisìkasén‑ne Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nga jye komà kjìn na̱chrjein, jñà xi̱ta̱ judío, tsajoóya‑ne nga si̱ìk'en Saulo. ");
INSERT INTO maaNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ta̱nga jè Saulo kiì'nchré koni s'ín tsajoóya‑ne nga jñà xi̱ta̱ judío, ko̱ na̱chrjein ko̱ ni̱tje̱n kisìkinda̱, tsibìtsa̱jnajto xotjoa̱‑la̱ na̱xa̱ndá nga mejèn‑la̱ si̱ìk'en. ");
INSERT INTO maaNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ta̱nga jñà xi̱ta̱‑la̱ Saulo, k'e̱ nga jñò, kiìko̱, kisìkíjnaya jngoò ni̱si̱yá xi je kji; i̱kjoàn kiskinìs'en‑kjá ñánda ti̱x'á chiba jè chrjó xi tjíndiì‑la̱ na̱xa̱ndá ko̱ ya̱á kiskinìjen‑jno jè chrjó, mé‑ne komà tsanga‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo, k'e̱ nga ijchò‑ne ján Jerusalén, mejèn‑la̱ nga ya̱ koa̱hijtako̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo, ta̱nga ngats'iì xi̱ta̱ koi, tà kitsakjòn‑la̱, nga̱ mìkiì kòkjeiín‑la̱ tsà kixi̱ kjoa̱ nga ti̱koa̱ ya̱ kota'yàt'aà‑la̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ta̱nga jè Bernabé k'e̱é kiìko̱ ñánda títsa̱jna xi̱ta̱ xi tsibíxáya‑la̱ Jesús. Tsibéno̱jmí‑la̱ nga jyeé jahatjìya‑la̱ k'e̱ nga kijtseè Na̱'èn‑ná Jesús nga kiìchja̱ sobà‑la̱ ya̱ i̱ya ndi̱yá k'e̱ nga tífì Damasco; ti̱koa̱á tsibéno̱jmí‑la̱ nga ján Damasco 'ñó ndaà kiìchja̱ i̱t'aà ts'e̱ Jesús, mìkiì kitsakjòn. ");
INSERT INTO maaNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saulo, ya̱á tsibìjnako̱ jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús; ya̱á tsajmeiìko̱ Jerusalén. Mìkiì kitsakjòn nga kiìchja̱ya i̱t'aà ts'e̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","'Ñó kiìchja̱ko̱ jñà xi̱ta̱ judío xi 'én griego chja̱ nga tsajoókjoòko̱ xíkjín; ta̱nga jñà xi̱ta̱ koi tsohótsji'nde‑la̱ kó s'ín si̱ìko̱ nga mejèn‑la̱ si̱ìk'en Saulo. ");
INSERT INTO maaNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jñà xi̱ta̱ xi 'ndse̱ joó i̱t'aà ts'e̱ Cristo, k'e̱ nga kiì'nchré 'én koi, kiìko̱ Saulo ján Cesarea, i̱kjoàn kisìkasén skanda ján Tarso. ");
INSERT INTO maaNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ngats'iì xi̱ta̱ na̱xa̱ndá‑la̱ Cristo, 'nchán tsibìtsa̱jna kóho̱tjín na̱xa̱ndá xi chja̱‑ne nangui Judea, Galilea ko̱ Samaria; nì ti̱ mé kjoa̱siì kis'e‑ne. Kis'e‑ìsa̱‑la̱ nga'ñó ts'e̱ ini̱ma̱‑la̱ nga ìsa̱ ndaà kijtseèxkón Nainá; jè Ini̱ma̱ Tsjeè‑la̱ Nainá ìsa̱á ndaà tsasìko̱ nga ìsa̱ kjìn komà xi̱ta̱‑la̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Jè Pedro, k'e̱ nga tsajmeèsòn i̱'nde koi, ti̱koa̱á kiìkon xi̱ta̱‑la̱ Cristo xi títsa̱jna ya̱ na̱xa̱ndá Lida. ");
INSERT INTO maaNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ya̱ tíjna jngoò xi̱ta̱ xi 'mì Eneas; jyeé tjín‑la̱ jiìn nó nga kijna xk'én, mìkiì ma síkjaníyá yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro kitsò‑la̱: ―Eneas, jè Jesucristo tísíndaà‑lè. Ti̱sítji̱in, tixkóyi nijñaà‑lè. Eneas, ni̱to̱ón tsasítje̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ngats'iì xi̱ta̱ xi títsa̱jna ya̱ na̱xa̱ndá Lida ko̱ Sarón, kijtseè Eneas nga tsajmeè‑ne, i̱kjoàn kòkjeiín‑la̱ i̱t'aà ts'e̱ Na̱'èn‑ná Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ya̱ na̱xa̱ndá Jope tíjna jngoò chjo̱ón xi kota'yàt'aà‑la̱ Cristo: Tabita 'mì. Jè 'én griego, Dorcas 'mì. Jè 'én tsa̱ján, Na̱xín tsò‑ne. Chjo̱ón jè, 'ñó ndaà xi̱ta̱, ti̱koa̱á ndaà síchját'aà‑la̱ xi̱ta̱ i̱ma̱. ");
INSERT INTO maaNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jñà na̱chrjein koi, chjo̱ón jè, kjòxk'én koa̱ k'en. K'e̱ nga jye kisìhingáya, kiìko̱, kisìkájnaya ni'ya xi ma‑ne jò piso. ");
INSERT INTO maaNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jè na̱xa̱ndá Lida ya̱á kijnat'aà chrañà‑la̱ Jope. Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo kiì'nchré nga ya̱ tíjna Lida jè Pedro. Kisìkasén jò xi̱ta̱ x'i̱n xi kiì kítsi'ba‑la̱, kitsò‑la̱: ―Kì nìkachrjein‑jèn, ni̱to̱n nchrobáchón‑náje̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro, k'e̱ nga kiskaàt'aà‑la̱ o̱kixi̱, ni̱to̱ón tsasítje̱n; tsobáhijtako̱ xi̱ta̱ koi. K'e̱ nga ijchò Jope, kiìko̱ ñánda kijna mik'en; jahas'en ni'ya. Ngats'iì íchjín ka'àn xi títsa̱jna ijchò kinchat'aà‑la̱ Pedro nga kjindáya; tsakó‑la̱ x'ió ko̱ na̱chro̱ xi tsibíndaà Dorcas k'e̱ nga ti̱sa̱ tíjnakon. ");
INSERT INTO maaNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro tsachrje yije ni'ya jñà xi̱ta̱ koi; i̱kjoàn tsasìxkó'nchi, kiìchja̱t'aà‑la̱ Nainá; k'e̱é kiskoò'an jè mik'en, kitsò‑la̱: ―¡Tabita, ti̱sítji̱in! Jè mik'en, kiskíx'a̱ngui‑ne xko̱n. K'e̱ nga kijtseè Pedro, tsibìjna kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro kitsjaà‑la̱ tsja, kisìkasítje̱n; i̱kjoàn kiìchja̱‑la̱ xi̱ta̱‑la̱ Cristo ko̱ jñà íchjín ka'àn; tsakó‑la̱ Dorcas nga tíjnakon‑né. ");
INSERT INTO maaNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kjoa̱ jè, ki'ya yijeé‑la̱ kóho̱kji Jope; kjìn xi̱ta̱ kòkjeiín‑la̱ i̱t'aà ts'e̱ Na̱'èn‑ná Jesucristo. ");
INSERT INTO maaNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jè Pedro, kjìn na̱chrjein tsibìjna ya̱ Jope, ya̱ ni'ya‑la̱ xi̱ta̱ xi 'mì Simón chji̱ne̱chrjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ya̱ na̱xa̱ndá Cesarea tsibìjna jngoò xi̱ta̱ xi 'mì Cornelio, jè xi xi̱ta̱ sko̱‑la̱ ts'e̱ soldado xi jngoò sìndo̱ ma‑ne xi ya̱ chja̱‑ne xi 'mì Italiano. ");
INSERT INTO maaNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jè Cornelio, ngats'iì xi̱ta̱ ni'ya‑la̱, ndaà beèxkón Nainá, ti̱koa̱á tsakjón‑keè Nainá. Ndaà síchját'aà‑la̱ jñà xi̱ta̱ i̱ma̱ xi nì mé tjín‑la̱. Kjit'aà na̱chrjein bítsi'ba‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Jngoò na̱chrjein, ijchò‑la tsà xi jàn nga nguixòn, tsatsejèn jngoò‑la̱ kjoa̱ koni tsà nijñá tí'biì‑la̱ nga jahas'en jngoò àkja̱le̱‑la̱ Nainá ya̱ ni'ya ñánda tíjna; kitsò‑la̱: ―¡Cornelio! ");
INSERT INTO maaNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Jè Cornelio, k'e̱ nga kiskoò'an àkja̱le̱, tà kitsakjòn‑la̱, kitsò‑la̱: ―¿Mé xi mejèn‑lè na̱'èn? Jè àkja̱le̱ kitsò: ―Jyeé ijchò kaàt'aà‑la̱ Nainá jè kjoa̱ bítsi'ba‑lè ko̱ kjoa̱ nga nìchját'aà‑la̱ xi̱ta̱ i̱ma̱ xi nì mé tjín‑la̱. Jè Nainá ndaà sasén‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ti̱kasín xi̱ta̱‑lè ján na̱xa̱ndá Jope; kàtìkjaá Simón xi ti̱koa̱ Pedro 'mì. ");
INSERT INTO maaNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ya̱ tíjna ni'ya‑la̱ xi̱ta̱ xi ti̱koa̱ Simón 'mì xi chrjoa̱‑la̱ cho̱ síhinda. Jè ni'ya‑la̱ ya̱á kijnandiì ndáchikon. Jè ke̱èno̱jmí‑lè mé xi s'i̱in. ");
INSERT INTO maaNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","K'e̱ nga jye kiì‑ne àkja̱le̱‑la̱ Nainá xi tíchja̱ko̱ Cornelio, kiìchja̱ jò‑la̱ xi̱ta̱ chi̱'nda‑la̱ koa̱ jngoò soldado xi ndaà beèxkón Nainá xi ya̱ síxát'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","K'e̱ nga jye tsibéno̱jmí yije‑la̱ ngats'iì kjoa̱ xi kiì'nchré, i̱kjoàn kisìkasén ján na̱xa̱ndá Jope. ");
INSERT INTO maaNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","K'e̱ nga komà nchijòn, ijchò‑la tsà nchisen, jñà xi̱ta̱ koi, jyeé kjo̱meè bijchó chrañà‑la̱ na̱xa̱ndá Jope. Ti̱jè‑ne hora jè Pedro, tsijin i̱sò'nga ni'ya nga kiì kítsi'ba‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pedro, jyeé 'ñó kjòhojò‑la̱; mejèn‑la̱ nga ko̱kje̱n, ta̱nga tíkoñaá‑la̱, k'e̱é tísindaà tsojmì xi ski̱ne̱; tsatsejèn jngoò‑la̱ kjoa̱ koni nijñá tí'biì‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kijtseè nga ti̱xá ngajmiì; inchrobàjen jngoò nikje skanda i̱t'aà nangui xi 'ñó teè kji, tjít'aà'ñó nga ñijòn chrja̱ngui̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Jè nikje, ya̱á títsa̱jnaya yije cho̱ xi tjín i̱ i̱t'aà nangui xi ñijòn ma ndso̱ko̱ ko̱ jñà cho̱ xi bífejno yijo‑la̱ nangui, ngats'iì cho̱ xi tjín‑la̱ jnga̱á xi tjíma i̱jiìn i̱sén. ");
INSERT INTO maaNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Jè Pedro kiì'nchré jngoò 'én xi kitsò‑la̱: ―Pedro, ti̱sítji̱in, ti̱k'in cho̱ koi, chi̱ni̱i. ");
INSERT INTO maaNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kitsò Pedro: ―Na̱'èn, majìn; ni̱ saà jngoò k'a tsojmì tjé kíne̱e xi xkón tjín i̱t'aà ts'e̱ kjo̱tíxoma. ");
INSERT INTO maaNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pedro, ìjngoò k'a kiì'nchré 'én xi kitsò‑la̱: ―Tsojmì xi Nainá jye kisìtsjeè nga ma chji̱ne̱, kì tsojmì tjé 'mì‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Jè kjoa̱ ts'e̱ nikje, jàn k'a o̱komà. I̱kjoàn tsijin ìjngoò k'a‑ne ján ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro, tísíkítsjeèn kó tsòya‑ne jè kjoa̱ xi kijtseè. Ti̱k'e̱é‑ne ijchò kinchajto xotjoa̱ ni'ya jñà xi̱ta̱ xi kisìkasén Cornelio nga jye kiskònangui ñánda‑ne ni'ya‑la̱ Simón. ");
INSERT INTO maaNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kiskònangui, a ya̱á tíjna jngoò xi̱ta̱ xi Simón 'mì, ti̱koa̱ tjít'aàsòn 'ín‑la̱ nga Pedro 'mì. ");
INSERT INTO maaNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Jè Pedro, tákó k'e̱é tísíkítsjeèn jè kjoa̱ xi kijtseè, jè Ini̱ma̱ Tsjeè‑la̱ Nainá kitsò‑la̱: ―Jàn ma xi̱ta̱ xi ji̱ ótsji‑lè. ");
INSERT INTO maaNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ti̱sítji̱in, titjo̱ji̱in, kì jò 'beé‑la̱ takoìn nga 'mìkoi̱i; jñà xi̱ta̱ koi, 'a̱án kàsíkasén. ");
INSERT INTO maaNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jè Pedro inchrobàjen ñánda 'ncha xi̱ta̱ xi kisìkasén Cornelio, kitsò‑la̱: ―'A̱n‑ná xi binchaàtsji‑ná; ¿mé xá xi kòf'i̱‑nò? ");
INSERT INTO maaNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Jñà xi̱ta̱ koi kitsò: ―Jè kisìkasén‑naje̱n xi̱ta̱ sko̱‑la̱ soldado xi 'mì Cornelio, jngoò xi̱ta̱ kixi̱ xi ndaà beèxkón Nainá, ti̱koa̱ jè, ndaà yaxkón i̱t'aà ts'e̱ na̱xa̱ndá Israel. Jngoò xó àkja̱le̱‑la̱ Nainá k'oa̱ kitsò‑la̱ nga ngaji̱ ski̱nìkjaá‑lè nga k'oín ni'ya‑la̱ mé‑ne nga kéno̱jmíya‑la̱ 'én xi ji̱ tìhokoòyi. ");
INSERT INTO maaNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Jè Pedro kisìkas'en ni'ya‑la̱; ya̱á kisìkjáyako̱ jngoò ni̱tje̱n. Xi komà nchijòn, kiìko̱ xi̱ta̱ koi; ti̱koa̱á tsobáhijtako̱ i'nga xi̱ta̱ xi mokjeiín‑la̱ i̱t'aà ts'e̱ Cristo xi títsa̱jna ya̱ Jope. ");
INSERT INTO maaNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Xi komà nchijòn ijchò Cesarea; jyeé tíkoña jè Cornelio; jyeé títsa̱jna xi̱ta̱ xíkjín ko̱ amigo‑la̱ xi ndaà óko̱ xi xó kisìkí'nchré‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","K'e̱ nga jye ijchò Pedro, jè Cornelio itjo ni'ya nga kisìhixat'aà; tsasìxkó'nchit'aà‑la̱ nga kijtseèxkón. ");
INSERT INTO maaNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ta̱nga jè Pedro kisìkasítje̱n, kitsò‑la̱: ―Ti̱sítji̱in; 'a̱n, ti̱koa̱á ta xi̱ta̱‑ná koni ngaji̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Jè Pedro, nga tíhóko̱ Cornelio, jahas'en ni'ya; kijtseè nga 'ñó kjìn ma‑ne xi̱ta̱ xi ya̱ títsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedro kitsò‑la̱: ―Jñò, tíjiìn‑nò nga jñà xi̱ta̱ judío mìkiì tjí'nde‑la̱ nga jñà xi̱ta̱ xi xìn i̱'nde‑la̱ si̱ìngásòn‑ko̱, mìkiì ma kjoa̱s'en ni'ya‑la̱ xi mìtsà xi̱ta̱ judío. Ta̱nga Nainá tsibéno̱jmíya‑na nga ni̱jngoò xi̱ta̱ xi ko̱ma xán‑la̱: jñò, ta̱xki̱ xi̱ta̱‑nò ko̱ xi̱ta̱ tjé‑nó nga nguixko̱n Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Koií kjoa̱‑la̱ k'e̱ nga ijchò nokjoà‑ná, mìkiì kisìtájaàjñaà, ni̱to̱ón inchrobà. Jè xi kjònanguia, ¿mé xá xi nokjoà‑ná? ");
INSERT INTO maaNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio kitsò: ―Tjín‑la̱ ñijòn na̱chrjein, ti̱jè‑ne hora jè nga xi jàn nga nguixòn, k'e̱ nga tìchjàt'aà‑la̱ Nainá i̱ ni'ya‑na̱, tà ni̱to̱ón tsatsejèn jngoò xi̱ta̱ xi tsasìjna nguixkoaàn; 'ñó ote kji nikje‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kitsò‑na: “Cornelio, jè kjoa̱ bítsi'ba‑lè jye kina'yà‑la̱ ko̱ jye ki'ya‑la̱ nga nguixko̱n Nainá koni s'ín nìchját'aà‑la̱ xi̱ta̱ i̱ma̱ xi nì mé tjín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ti̱kasín xi̱ta̱‑lè ján na̱xa̱ndá Jope, kàtìkjaá Simón xi ti̱koa̱ Pedro 'mì. Ya̱ tíjna ni'ya‑la̱ xi̱ta̱ xi ti̱koa̱ Simón 'mì xi chrjoa̱‑la̱ cho̱ síhinda. Jè ni'ya‑la̱ ya̱á kijnandiì ndáchikon.” ");
INSERT INTO maaNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","K'oa̱á komà‑ne nga ni̱to̱n kiskinìkjaá‑lè. Ndaà kà'nè‑ne nga kànchroboì. Kóho̱tjín‑je̱n i̱í titsa̱jna‑je̱n nga nguixko̱n Nainá mé‑ne nga ki̱ná'ya yije‑je̱n mé o̱kixi̱ xi kitsjaà‑lè Nainá nga kéno̱jmí‑náje̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro tsibíts'ia̱ nga kiìchja̱, kitsò: ―Kixi̱í kjoa̱, tíbe‑ná nga Nainá mìkiì faájiìn ni̱ta̱ yá xi̱ta̱‑ne, tà ngásòn fìko̱ yije. ");
INSERT INTO maaNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nainá kjoétjò‑né ni̱ta̱ yá xi̱ta̱‑ne ni̱ta̱ ñánda‑ne i̱'nde‑la̱ xi beèxkón Nainá xi ti̱koa̱ s'ín kjoa̱kixi̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nainá kisìkasén 'én‑la̱ ya̱ na̱xa̱ndá Israel; tsibéno̱jmíya‑la̱ 'én ndaà‑la̱ nga 'nchán ki̱tsa̱jnakoa̱á Nainá i̱t'aà ts'e̱ Cristo, jè xi otíxoma‑la̱ ngats'iì xi̱ta̱ xi tjín i̱sò'nde. ");
INSERT INTO maaNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jñò, ndaà tíjiìn‑nò koni s'ín komà kóho̱kji nangui‑la̱ xi̱ta̱ judío, kjòts'ia̱‑ne i̱'nde Galilea k'e̱ nga jye kiìchja̱ya Juan xi kjoa̱ ts'e̱ bautismo. ");
INSERT INTO maaNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tíjiìn‑nò nga jè Jesús xi Nazaret ts'e̱, Nainá xó jaàjiìn‑ne nga kitsjaà‑la̱ Ini̱ma̱ Tsjeè‑la̱ ko̱ nga'ñó. Ni̱ta̱ ñánda‑ne nga tsajmeè Jesús, ndaà tjín kjo̱ndaà xi kis'iìn; kisìndaà‑ne xi̱ta̱ xi kjo̱'in nchisíkjeiín i̱t'aà ts'e̱ xi̱ta̱ nei̱í. Koií k'oa̱s'ín kis'iìn‑ne nga jè Nainá tíjnako̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","K'oa̱á ma‑ne bèno̱jmí‑je̱n nga xko̱ón ki'ya‑naje̱n ngats'iì kjo̱ndaà xi kis'iìn Jesús ya̱ nangui‑la̱ xi̱ta̱ judío ko̱ Jerusalén. K'e̱ nga komà i̱skan, jñà xi̱ta̱ kisìk'en Jesús, tsibítjo̱hónguit'aà krò. ");
INSERT INTO maaNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ta̱nga nga ijchò jàn na̱chrjein Nainá kisìkjaáya‑la̱ ko̱ k'oa̱á s'ín kis'iìn nga kiyaxkon ìjngoò k'a‑la̱ nga jye jaáya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mìtsà ngats'iì xi̱ta̱ na̱xa̱ndá kijtseèxkon, tà ngaje̱n‑náje̱n xi xó kjòtseé kitjaàjiìn‑naje̱n mé‑ne nga ko̱ma kéno̱jmí‑je̱n xi i̱t'aà ts'e̱, ngaje̱n‑náje̱n xi chichiko̱‑je̱n ti̱koa̱ ki'yòko̱‑je̱n k'e̱ nga jye jaáya‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jè Jesús tsibít'in‑naje̱n nga ki̱nókjoa̱ya‑je̱n ko̱ kéno̱jmí kixi̱‑la̱je̱n xi̱ta̱ na̱xa̱ndá nga jè Jesús, k'oa̱á s'ín kisìkíjna Nainá koni xi̱ta̱xá ítjòn nga jè bíndaàjiìn‑la̱ xi̱ta̱ xi títsa̱jnakon ko̱ xi jye k'en. ");
INSERT INTO maaNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ngats'iì xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá, k'oa̱á s'ín tsjá 'én nga ngats'iì xi̱ta̱ xi mokjeiín‑la̱ i̱t'aà ts'e̱ Cristo, i̱t'aà ts'e̱‑né nga jcha̱t'aà‑la̱ jé‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tákó ti̱k'e̱é tíchja̱ ìsa̱ Pedro, ngats'iì xi̱ta̱ xi nchi'nchré‑la̱ itjojen‑nè Ini̱ma̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jñà xi̱ta̱ judío xi tji̱ko̱ Pedro xi ti̱koa̱ jye mokjeiín‑la̱ i̱t'aà ts'e̱ Cristo, tà k'oa̱á komà‑la̱ k'e̱ nga kijtseè nga jñà xi mìtsà xi̱ta̱ judío, ti̱koa̱ ndaà itjojen‑nè jè Ini̱ma̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nga kiì'nchré‑la̱ nga chja̱ xi kj'ei̱í 'én, ti̱koa̱ chja̱t'aà‑la̱ Nainá nga 'ñó jeya síkíjna. ");
INSERT INTO maaNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","K'e̱é kitsò Pedro: ―Mì‑la kiì ko̱ma ki̱chakjáya‑là jñà xi̱ta̱ koi nga ko̱ma bautizar nga jyeé kàtjoé‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá koni s'ín kitjoé‑ná jñá. ");
INSERT INTO maaNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jè Pedro kitsjaà o̱kixi̱ nga ko̱ma bautizar xi̱ta̱ koi i̱t'aà ts'e̱ Na̱'èn‑ná Jesucristo. I̱kjoàn jñà xi̱ta̱ tsibítsi'ba‑la̱ Pedro nga kàtìjnako̱ chiba na̱chrjein ìsa̱. ");
INSERT INTO maaNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús ko̱ xi̱ta̱ xíkjín xi 'ndse̱ joó i̱t'aà ts'e̱ Cristo xi títsa̱jna nangui Judea, kiì'nchré nga jñà xi mìtsà xi̱ta̱ judío ti̱koa̱á jye kòkjeiín‑la̱ 'én‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Jñà xi̱ta̱ judío xi mokjeiín‑la̱ i̱t'aà ts'e̱ Cristo tsohótiko̱ Pedro, k'e̱ nga ijchò‑ne ján Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Kitsò‑la̱: ―¿Mé‑ne ya̱ kiì‑ne ni'ya‑la̱ xi ta̱xki̱ xi̱ta̱ xi mìtsà xi̱ta̱ judío, skanda ya̱á chichikoi̱i? ");
INSERT INTO maaNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Jè Pedro k'e̱é tsibíts'ia̱ nga ndi̱yá ndi̱yá tsibéno̱jmí yije‑la̱ koni s'ín komàt'in; kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―K'e̱ nga tìjna̱a ján na̱xa̱ndá Jope, nga tìchjàt'aà‑la̱ Nainá, tsatsejèn jngoò‑na kjoa̱ koni tsà nijñá tí'biì‑na, jngoò nikje kìjtseè xi 'ñó te kji, tjí'ñó nga ñijòn chrja̱ngui̱‑la̱ xi ngajmiì inchrobàjen‑ne, j'iì skanda ñánda tìjna̱a. ");
INSERT INTO maaNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","K'e̱ nga kiskoòtsejèn‑la̱, ndaà kìjtseè nga títsa̱jnaya cho̱ xi tjín i̱ i̱t'aà nangui xi ñijòn ma ndso̱ko̱ ko̱ cho̱ ts'e̱n xi tjín i̱jiìn ijñá, ko̱ cho̱ xi bífejno yijo‑la̱ nangui, ngats'iì cho̱ xi jnga̱á tjín‑la̱ xi tjímajiìn i̱sén. ");
INSERT INTO maaNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ki'nchrè jngoaà 'én xi kitsò‑na: “Pedro, ti̱sítji̱in, ti̱k'iìn cho̱ koi, chi̱ni̱i.” ");
INSERT INTO maaNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","'A̱n kixan‑la̱: “Majìn Na̱'èn, 'a̱n, ni̱ saà jngoò k'a tsojmì tjé kíne̱e xi xkón tjín i̱t'aà ts'e̱ kjo̱tíxoma.” ");
INSERT INTO maaNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Xi ma‑ne jò k'a, ìjngoò k'a kiìchja̱‑na ján ngajmiì kitsò‑na: “Tsojmì xi Nainá jye kisìtsjeè nga ma chji̱ne̱, kì tsojmì tjé 'mì‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Jè kjoa̱ koi, jàn k'a o̱komà. I̱kjoàn tsijin yije ìjngoò k'a‑ne ján ngajmiì. ");
INSERT INTO maaNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ti̱jè‑ne hora, jàn xi̱ta̱ ijchò kátsji‑na ya̱ ni'ya ñánda tìjna̱a xi ján inchrobà‑ne Cesarea xi xó kisatiìxá‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jè Ini̱ma̱ Tsjeè‑la̱ Nainá kitsò‑na: “Tikoi̱i xi̱ta̱ koi; kì jò beè‑la̱ takoìn nga tsjáhijtakoi̱i; ti̱koa̱á tsobáhijtako̱‑na jñà xi̱ta̱ 'ndsè xi joòn ma‑ne xi i̱ títsa̱jna; ijchò‑je̱n ya̱ ni'ya‑la̱ jè xi̱ta̱ xi kiskinìkjaá‑na, i̱kjoàn tsitjaàs'en‑je̱n ni'ya‑la̱.” ");
INSERT INTO maaNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Xi̱ta̱ jè tsibéno̱jmí‑na̱je̱n nga jngoò xó àkja̱le̱ kijtseè ya̱ ni'ya‑la̱ xi kitsò xó‑la̱: “Ti̱kasín xi̱ta̱ ján na̱xa̱ndá Jope nga kàtìkjaá jè xi̱ta̱ xi 'mì Simón xi ti̱koa̱ Pedro 'mì. ");
INSERT INTO maaNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jè tsjá‑lè 'én nga ki̱tjokàjñoò kjo̱'in kjoa̱ ts'e̱ jé‑nò, ngaji̱ ko̱ ngats'iì xi̱ta̱ ni'ya‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","K'e̱ nga tsibíts'ia̱ nga tsibéno̱jmí‑la̱, jè Ini̱ma̱ Tsjeè‑la̱ Nainá, ni̱to̱ón itjojen‑nè jñà xi̱ta̱ koi koni s'ín komàt'iaán jñá nga sa̱ tàts'en‑la̱ kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","K'e̱é tsibítsjeèn‑na koni s'ín kitsò Na̱'èn‑ná Jesús nga kitsò: “Jè Juan, nandá kis'iìn‑ne bautizar, ta̱nga jñò, ko̱ó Ini̱ma̱ Tsjeè‑la̱ Nainá ko̱ma‑nò bautizar.” ");
INSERT INTO maaNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tsà Nainá k'oa̱s'ín sasén‑la̱ nga ti̱koa̱ tsjá kjo̱tjò‑la̱ jè Ini̱ma̱ Tsjeè‑la̱ koni s'ín kitsjaà‑ná jñá k'e̱ nga kòkjeiín‑ná i̱t'aà ts'e̱ Na̱'èn‑ná Jesucristo, ¿'a̱n, mé‑ne kondra̱ kóti̱jna‑la̱ Nainá? ");
INSERT INTO maaNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","K'e̱ nga kiì'nchré 'én koi, jyò tsibìtsa̱jna. Jeyaá kisìkíjna Nainá, kitsò: ―¡Kixi̱í‑la kjoa̱ nga jñà xi mìtsà xi̱ta̱ judío, ti̱koa̱ tsjá‑la̱ kjo̱ndaà Nainá mé‑ne nga si̱ìkájno‑ne jé‑la̱ ko̱ mì ti̱ jé ko̱hótsji‑ne mé‑ne nga s'e̱‑la̱ kjoa̱binachon ts'e̱ ini̱ma̱‑la̱! ");
INSERT INTO maaNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","K'e̱ nga jye k'en Esteban, jñà xi̱ta̱ xi mokjeiín‑la̱ i̱t'aà ts'e̱ Jesús kitsjohoba, koií kjoa̱‑la̱ nga 'ñó kiìtji̱nguikeè xi̱ta̱. Tjín xi kiì ján nangui Fenicia ko̱ Chipre ko̱ na̱xa̱ndá Antioquía. Xi̱ta̱ koi, k'e̱ nga ijchò i̱'nde koi, tsibéno̱jmí‑la̱ 'én‑la̱ Cristo jñà xi̱ta̱ judío xi ya̱ títsa̱jna ta̱nga xi ta̱xki̱ xi̱ta̱, majìn. ");
INSERT INTO maaNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Jñà xi̱ta̱ xi kitsjohoba, tjín i'nga xi ján i̱'nde‑la̱ nangui Chipre ko̱ na̱xa̱ndá Cirene. K'e̱ nga ijchò ya̱ na̱xa̱ndá Antioquía ti̱koa̱á tsibéno̱jmí‑la̱ jñà xi̱ta̱ xi mìtsà xi̱ta̱ judío 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Jesús xi otíxoma‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nainá kitsjaà‑la̱ nga'ñó; kjìn xi̱ta̱ koi kòkjeiín‑la̱ i̱t'aà ts'e̱ Cristo, jahatjìya‑la̱ kjo̱hítsjeèn‑la̱, kiìt'aà‑la̱ Na̱'èn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jñà xi̱ta̱ na̱xa̱ndá‑la̱ Cristo xi títsa̱jna Jerusalén kiì'nchré koni s'ín tíma ján Antioquía. Kisìkasén jè Bernabé. ");
INSERT INTO maaNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bernabé, k'e̱ nga ijchò Antioquía, kijtseè nga jè Nainá ndaà tísíchikon‑t'in xi̱ta̱ koi. Tsja jchán komà‑la̱. K'e̱é ìsa̱ ndaà tsibít'in yije‑la̱ nga ko̱ ini̱ma̱‑la̱ ìsa̱ ndaà kàtjìt'aà‑la̱ Na̱'èn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Jè Bernabé, 'ñó ndaà xi̱ta̱; ndaà tíjiìn ini̱ma̱‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá; ti̱koa̱á ndaà mokjeiín‑la̱ i̱t'aà ts'e̱ Nainá. K'oa̱á s'ín komà‑ne nga ìsa̱ kjiìn xi̱ta̱ jahas'en‑t'aà‑la̱ Na̱'èn‑ná Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nga komà i̱skan, Bernabé kiì ján Tarso nga kiì kátsji Saulo. ");
INSERT INTO maaNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","K'e̱ nga jye kisakò‑la̱, kiìko̱ ján Antioquía. Jngoò nó tsibìtsa̱jnako̱ jñà xi̱ta̱ na̱xa̱ndá‑la̱ Cristo; koií xá kis'iìn nga kjìn xi̱ta̱ tsakóya‑la̱. Ya̱á kisit'aà 'ín ítjòn nga xi̱ta̱‑la̱ Cristo 'mì ngats'iì xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Na̱chrjein koi ijchò i'nga xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá ján Antioquía xi inchrobà‑ne Jerusalén. ");
INSERT INTO maaNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jngoò xi̱ta̱ xi 'mì Agabo, tsasìjna kixi̱, kiìchja̱ nga jè Ini̱ma̱ Tsjeè‑la̱ Nainá tsibít'in‑la̱, kitsò nga tíjtsa i̱sò'nde kjinchrá 'ñó kjoi̱í. 'Én jè, k'oa̱á s'ín tsitasòn k'e̱ nga tsibìjna xi̱ta̱xá ítjòn ján Roma jè xi 'mì Claudio. ");
INSERT INTO maaNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo xi títsa̱jna Antioquía tsajoóya‑ne nga si̱ìkasén‑la̱ nga'ñó xi̱ta̱ xíkjín xi títsa̱jna nangui Judea koni kji bijchó nga'ñó‑la̱ nga jngoò ìjngoò. ");
INSERT INTO maaNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Koni s'ín tsajoóya‑ne, k'oa̱á s'ín kisìkitasòn. Jè Bernabé ko̱ Saulo, kiìko̱ kjo̱tjò jè ján nangui Judea nga kisìnga̱tsja jñà xi̱ta̱ jchínga xi tjín‑la̱ xá ts'e̱ na̱xa̱ndá‑la̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ti̱jñà‑ne na̱chrjein koi, jè Herodes xi xi̱ta̱xá ítjòn tíjna, kitsjaà o̱kixi̱ nga kitsobà'ñó i'nga xi̱ta̱ na̱xa̱ndá‑la̱ Cristo mé‑ne nga ko̱ma skoe̱toòn‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tsatíxá nga ki̱cha̱ ndojò kisìk'en‑ne Jacobo, 'ndse̱ Juan. ");
INSERT INTO maaNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Jè Herodes, k'e̱ nga kijtseè nga tsja komà‑la̱ jñà xi̱ta̱ judío nga jye k'en Jacobo, i̱kjoàn kitsobà'ñó Pedro jè na̱chrjein k'e̱ nga bitjo s'eí nga kjèn i̱nchra̱jín xi tsjìn‑la̱ na̱'yo̱ san. ");
INSERT INTO maaNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kiskinìs'en nda̱yá. Chrj'oòn jngoò soldado kisìkinda̱ ya̱ i̱ya nda̱yá; ñijòn kisìkinda̱ nga indiaà indiaà. Kjo̱hítsjeèn‑la̱ Herodes, jè‑né k'e̱ nga jye kjoe̱het'aà s'eí Paxko̱ ko̱chrje nda̱yá mé‑ne jñà xi̱ta̱ na̱xa̱ndá tsjá 'én nga ki̱yá Pedro. ");
INSERT INTO maaNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jè Pedro, ndaá tímakinda̱ i̱ya nda̱yá; ko̱ jñà xi̱ta̱ na̱xa̱ndá‑la̱ Cristo, mìkiì jyò tsibìtsa̱jna nga 'ñó ndaà nchisíjét'aà‑la̱ Nainá i̱t'aà ts'e̱ Pedro. ");
INSERT INTO maaNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Jè na̱chrjein k'e̱ nga mejèn‑la̱ Herodes nga si̱ìnga̱tsja xi̱ta̱ na̱xa̱ndá jè Pedro, ti̱jè‑ne ni̱tje̱n, kjijnafè'nchò osen‑la̱ jò soldado; jò na'ñó ki̱cha̱ cadena tjít'aà'ñó‑ne; jñà soldado xi i'nga ya̱á nchisíkinda̱ xotjoa̱ nda̱yá. ");
INSERT INTO maaNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tà ni̱to̱ón tsatsejèn jngoò àkja̱le̱‑la̱ Nainá ya̱ i̱ya nda̱yá; kjòhiseèn yije kóho̱kji; jè àkja̱le̱ kisìhiníyá‑la̱ Pedro nga kisìkjaá‑la̱; kitsò‑la̱: ―¡Ni̱to̱n ti̱sítji̱in! Jñà na'ñó ki̱cha̱ cadena xi tjít'aà'ñó‑ne tsja Pedro chixòt'aà nangui. ");
INSERT INTO maaNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Jè àkja̱le̱ kitsò‑la̱: ―Chi̱kjeí nikje‑lè, tsjayi xo̱jté‑lè. Jè Pedro, k'oa̱á s'ín kis'iìn. I̱kjoàn kitsò àkja̱le̱: ―Chi̱kjeí na̱chro̱kisòn‑lè, nchrobátji̱ngui‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro itjo tji̱ngui‑la̱ jè àkja̱le̱; mìkiì machi̱ya‑la̱ tsà kixi̱í kjoa̱ xi tísíko̱ àkja̱le̱; jè Pedro k'oa̱á ma‑la̱ koni tsà nijñá tí'biì‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Jahat'aà‑la̱ jè soldado xi síjna ítjòn, ti̱koa̱ jahat'aà‑la̱ xi ma‑ne jò; k'e̱ nga ijchò xotjoa̱‑la̱ nda̱yá xi nguì ki̱cha̱ nga jye bitjoaá calle, tà ta̱jngoò kitáx'a̱; i̱kjoàn itjo; tsato'nchò jngoò calle; tà ni̱to̱ón kichijà jè àkja̱le̱; jè Pedro, ta̱jngoò kisasijna. ");
INSERT INTO maaNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Jè Pedro, k'e̱é ndaà kjòchi̱ya‑la̱ nga kixi̱ kjoa̱ xi tímat'in, kitsò: ―Kixi̱í kjoa̱, mokjeiín‑na nga Nainá kàsíkasén àkja̱le̱‑la̱ nga kàsíkíjnandei̱í‑na i̱t'aà ts'e̱ Herodes ko̱ ngats'iì kjoa̱ xi ch'o tjín xi nchikoña‑la̱ xi̱ta̱ judío nga si̱ìko̱‑na Herodes. ");
INSERT INTO maaNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Jè Pedro, k'e̱ nga ndaà kjòchi̱ya‑la̱ kjoa̱ koi, kiì ni'ya‑la̱ María, nea̱‑la̱ Juan xi ti̱koa̱ Marcos 'mì. Ya̱ ni'ya jè, kjìn xi̱ta̱ chixoña xi nchibítsi'ba‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kiìchja̱, kisìkjane xotjoa̱‑la̱ ni'ya; k'e̱é itjo katsejèn jngoò tsòti xi 'mì Rode nga mejèn‑la̱ skoe̱ yá‑né xi tíchja̱. ");
INSERT INTO maaNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","K'e̱ nga kiì'nchré jta̱‑la̱ nga jè Pedro xi tíchja̱, tsja jchán komà‑la̱ skanda mì ti̱ kiì kiskíx'a̱‑la̱ xotjoa̱ ni'ya; ta̱ sa̱á tsangachikon i̱ya ni'ya; kisìkí'nchré ñánda títsa̱jna xíkjín nga jè Pedro síjnajto xotjoa̱ ni'ya. ");
INSERT INTO maaNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Jñà xi̱ta̱ xíkjín kitsò‑la̱: ―¡Ská‑lè! Ta̱nga jè tsòti tákó k'oa̱á tsò nga kixi̱í kjoa̱ jè Pedro xi tíchja̱. Ta̱nga jñà xi̱ta̱ kitsò‑la̱: ―Jè‑la àkja̱le̱‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Jè Pedro, tákó tíchja̱‑ne, síkjane xotjoa̱ ni'ya. K'e̱ nga kiskíx'a̱‑la̱ xotjoa̱ ni'ya, kijtseèxkon nga jè Pedro; jñà xi̱ta̱ xíkjín, tà kjòxkón‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Kiskímiìtje̱n tsja Pedro nga kitsò‑la̱ jyò titsa̱jnaà; i̱kjoàn tsibéno̱jmí‑la̱ kó s'ín komàt'in nga Nainá tsachrje‑ne nda̱yá. Kitsò‑la̱: ―K'oa̱á s'ín tèno̱jmí‑là jè Jacobo ko̱ xi̱ta̱ xinguia̱á xi i'nga. I̱kjoàn itjo ni'ya; xìn i̱'nde kiì. ");
INSERT INTO maaNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","K'e̱ nga kis'e i̱sén ngats'iì soldado xi nchisíkinda̱, mì tà k'oa̱á kji kjoa̱siì kis'e‑la̱ nga mìkiì tíjiìn‑la̱ kó s'ín komà nga itjo nda̱yá Pedro. ");
INSERT INTO maaNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Jè Herodes kitsjaà o̱kixi̱ nga tsohótsji Pedro ta̱nga mìkiì kisakò‑la̱. K'e̱ nga jye kiskònangui‑la̱ ngats'iì soldado xi kisìkinda̱, jñà kiskaànè‑la̱ nga tsjìn Pedro; i̱kjoàn kitsjaà o̱kixi̱ nga kàtiyaà jñà soldado. Herodes itjokàjiìn ya̱ Judea. Ján kiì kijna na̱xa̱ndá Cesarea. ");
INSERT INTO maaNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes kjoa̱sií tjín‑la̱ ko̱ xi̱ta̱ na̱xa̱ndá Tiro ko̱ Sidón. Xi̱ta̱ na̱xa̱ndá koi, tsajoóya‑ne nga inchrobàkon Herodes. Ta̱nga ítjòn ndaà tsajoóko̱ Blasto xi ti̱koa̱ xá tjín‑la̱ ya̱ ni'ya‑la̱ Herodes xi xi̱ta̱xá ítjòn tíjna. Ko̱ jè Blasto kiìchja̱tjì na̱xa̱ndá koi nga kàtas'e kjoa̱'nchán. Koií k'oa̱s'ín kis'iìn‑ne jñà na̱xa̱ndá koi, nga ya̱ nangui‑la̱ Herodes otse tsojmì xi kine. ");
INSERT INTO maaNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Jè na̱chrjein k'e̱ nga chixoña xi̱ta̱ nga kisijna junta, jè Herodes, tsohòkjá nikje‑la̱ xi ts'e̱ xi̱ta̱xá ítjòn; tsibìjnasòn íxi̱le̱‑la̱, i̱kjoàn kiìchja̱jiìn‑la̱ xi̱ta̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Jñà xi̱ta̱ na̱xa̱ndá, k'e̱ nga kiì'nchré‑la̱, tsibíts'ia̱ nga 'ñó kiìchja̱ kitsò: ―¡Jè xi tíchja̱, jngoò xi̱ta̱ xi nainá, mìtsà ta̱xki̱ xi̱ta̱! ");
INSERT INTO maaNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ti̱k'e̱‑ne j'iì àkja̱le̱‑la̱ Nainá xi kitsjaà ch'in‑la̱; kjòxk'én, chi̱'ndoó kisìkje, i̱kjoàn k'en, koií kjoa̱‑la̱ nga mìkiì jeya kisìkíjna Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ta̱nga jè 'én‑la̱ Nainá ìsa̱á ndaà tíhobísòn k'oa̱ ìsa̱á ndaà tímakjìn xi̱ta̱ xi mokjeiín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Jè Bernabé ko̱ Saulo, k'e̱ nga jye kjòngásòn xá‑la̱, inchrobà‑ne Jerusalén, kiì‑ne ján Antioquía. Tji̱ko̱ Juan xi ti̱koa̱ Marcos 'mì. ");
INSERT INTO maaNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jñà xi̱ta̱ na̱xa̱ndá‑la̱ Cristo xi títsa̱jna ya̱ na̱xa̱ndá Antioquía, tjín i'nga xi̱ta̱ xi chja̱ya ngajo‑la̱ Nainá ko̱ okóya 'én‑la̱ Nainá: jè xi 'mì Bernabé, Simón (xi ti̱koa̱ Niger 'mì), Lucio xi Cirene ts'e̱, Manaén (xi ta̱ña kòjcháko̱ Herodes, xi tsatíxoma Galilea), ko̱ Saulo. ");
INSERT INTO maaNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Jngoò na̱chrjein k'e̱ nga tíma culto ti̱koa̱ títsa̱jnachjan xi̱ta̱‑la̱ Cristo, jè Ini̱ma̱ Tsjeè‑la̱ Nainá kitsò: ―Ti̱kítsa̱jnandaà‑ná jè Bernabé ko̱ Saulo xá xi xó 'a̱n kichjà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jñà xi̱ta̱‑la̱ Cristo, k'e̱ nga jye tsibìtsa̱jnachjan koa̱ jye tsibítsi'ba, tsohósòn‑la̱ tsja Bernabé ko̱ Saulo, i̱kjoàn kisìkasén xi kjoa̱ ts'e̱ xá‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jè Ini̱ma̱ Tsjeè‑la̱ Nainá kisìkasén Bernabé ko̱ Saulo nga kiì Seleucia; ya̱á jahas'en chitso nga kiì nangui xi kijnajiìn‑ndá xi 'mì Chipre. ");
INSERT INTO maaNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","K'e̱ nga ijchò na̱xa̱ndá Salamina, tsibíts'ia̱ nga kiìchja̱ya 'én ndaà‑la̱ Nainá ya̱ jñà ni'ya i̱ngo̱ sinagoga ts'e̱ xi̱ta̱ judío. Tji̱ko̱ jè Juan Marco xi kisìchját'aà‑la̱ Bernabé ko̱ Saulo. ");
INSERT INTO maaNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tsatojiìn kóho̱kji nangui jiìn‑ndá Chipre, ijchò skanda na̱xa̱ndá Pafos. Ya̱á kiskaàt'aà jngoò‑la̱ xi̱ta̱ judío xi 'mì Barjesús xi xi̱ta̱ tj'e, ti̱koa̱á xi̱ta̱ ndiso‑né nga tsò, 'én‑la̱ Nainá chja̱ya. ");
INSERT INTO maaNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jè xi̱ta̱ tj'e, ya̱á ojmeèko̱ Sergio Paulo xi xi̱ta̱xá ítjòn tíjna kóho̱kji nangui Chipre. Jè Sergio Paulo ndaà fìya‑la̱. Kiìchja̱‑la̱ jè Bernabé ko̱ Saulo nga mejèn‑la̱ kji̱'nchré 'én ndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ta̱nga jè xi̱ta̱ tj'e, xi 'mì Barjesús xi ti̱koa̱ Elimas 'mì xi 'én griego, kondra̱á kiì‑la̱ jè Bernabé ko̱ Saulo nga majìn‑la̱ nga jè xi̱ta̱xá ítjòn ko̱kjeiín‑la̱ 'én ndaà‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ta̱nga jè Saulo, ti̱jè‑ne xi 'mì Pablo, ndaà tíjiìn ini̱ma̱‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá; 'ñó kiskoò'an, ");
INSERT INTO maaNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","kitsò‑la̱: ―¡Xi̱ta̱ ndiso xi ch'o tjín kjo̱hítsjeèn‑lè; ki'ndí‑la̱ xi̱ta̱ nei̱í; ngaji̱ kondra̱ 'mì yije‑la̱ xi kjoa̱ kixi̱! ¿Mé‑ne nga kjit'aà na̱chrjein mejèn‑lè nìkits'ón‑jiìn ndi̱yá kixi̱‑la̱ Nainá? ");
INSERT INTO maaNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","I̱'ndei̱ Nainá tsjá‑lè kjo̱'in; mì kiì ti̱ ko̱tsejèn‑lè. Kjìn na̱chrjein mì ti̱ kiì jcha̱‑ne i̱sén ndobá ts'e̱ ts'oí. Ti̱k'e̱‑ne mì ti̱ kiì kjòtsejèn‑la̱. Kj'ei̱í xi̱ta̱ tsohótsji xi kitsobàt'aà nga komà kiì. ");
INSERT INTO maaNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jè xi̱ta̱xá ítjòn, k'e̱ nga kijtseè kjoa̱ koi, kòkjeiín‑la̱ 'én‑la̱ Nainá nga kixi̱ kjoa̱. Tà kjòxkón‑la̱ koni s'ín tsakóya‑la̱ Pablo ko̱ Bernabé i̱t'aà ts'e̱ Na̱'èn‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo ko̱ jñà xi̱ta̱ xi kjihijtako̱ jahas'en chitso ya̱ Pafos, kiì ján Perge i̱'nde xi chja̱‑ne Panfilia. Ta̱nga jè Juan Marco, tsohótji‑ne, ján kiì‑ne Jerusalén. Mì ti̱ ya̱ tsobáhijtako̱‑ne Pablo. ");
INSERT INTO maaNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Jè Bernabé ko̱ Pablo jahato Perge, kiì Antioquía, na̱xa̱ndá xi chja̱‑ne Pisidia. Jè na̱chrjein nìkjáya, jahas'en ni'ya i̱ngo̱ sinagoga, i̱kjoàn tsibìtsa̱jna. ");
INSERT INTO maaNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","K'e̱ nga jye kjòxke̱jiìn kjo̱tíxoma‑la̱ Moisés ko̱ xo̱jo̱n xi kiskiì xi̱ta̱ xi kiìchja̱ya ngajo‑la̱ Nainá, jñà xi̱ta̱ sko̱‑la̱ ni'ya i̱ngo̱ sinagoga kisìkasén xá‑la̱ jè Pablo ko̱ Bernabé, kitsò‑la̱: ―'Ndsè, tsà tjín‑nò mé 'én xi ki̱nókjoa̱jiìn‑là xi̱ta̱, ti̱nókjoa̱a mé‑ne nga s'e̱‑la̱ nga'ñó ini̱ma̱‑la̱ jñà xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","K'e̱é tsasítje̱n Pablo; ko̱ó tsja kisìjé‑la̱ nga jyò kàtìtsa̱jna; kitsò‑la̱: ―Jñò xi xi̱ta̱ Israel 'mì‑nò, ko̱ xi mìtsà na̱xa̱ndá Israel tsa̱jòn ta̱nga yaxkón Nainá, ti̱ná'ya‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Jè Nainá xi ts'e̱ na̱xa̱ndá Israel, jaàjiìn xi̱ta̱ jchínga kjìn‑ná; jngoò na̱xa̱ndá je kis'iìn k'e̱ nga ti̱sa̱ ján títsa̱jna Egipto nga mìtsà ya̱ i̱'nde‑la̱; nga'ñó ts'e̱ Nainá‑né nga tsachrjekàjiìn nangui Egipto. ");
INSERT INTO maaNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nainá, ichán nó kis'e‑la̱ kjoa̱tsejta nga kisìkinda̱ jñà xi̱ta̱ Israel ya̱ i̱'nde i̱t'aà xìn ñánda nangui kixì choòn. ");
INSERT INTO maaNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nainá, itoò na̱xa̱ndá xi̱ta̱ kisìkjehesòn ya̱ nangui Canaán. I̱kjoàn kitsjaà‑la̱ jñà xi̱ta̱ Israel jè nangui jè nga ts'e̱ ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ngats'iì kjoa̱ koi, ñijòn sìndo̱ osen nó tsato. ’Xi komà i̱skan, Nainá kitsjaà‑la̱ xi xi̱ta̱ sko̱‑la̱ tsibìtsa̱jna nga tsibíndaàjiìn‑la̱ xi̱ta̱ na̱xa̱ndá Israel. Ko̱ jñà tsasìko̱ skanda k'e̱ nga j'iì Samuel, xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Xi̱ta̱ na̱xa̱ndá Israel, kisìjé‑la̱ Nainá jngoò xi̱ta̱xá ítjòn xi mejèn‑la̱ nga ko̱tìxoma‑la̱. Nainá kitsjaà‑la̱ Saúl, ki'ndí‑la̱ Cis xi tje̱‑la̱ Benjamín. Ichán nó tsatíxoma Saúl. ");
INSERT INTO maaNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nga komà i̱skan, Nainá jaàxìn Saúl; jè David kitsjaà‑la̱ xá nga tsibìjna xi̱ta̱xá ítjòn. Nainá kitsò: “Jyeé kisakò‑na nga jè David xi ki'ndí‑la̱ Isaí, jngoò xi̱ta̱ xi sasén‑la̱ ini̱ma̱‑na̱ nga si̱ìkitasòn yije xi 'a̱n mejèn‑na.” ");
INSERT INTO maaNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nainá kisìkasén‑la̱ xi̱ta̱ na̱xa̱ndá Israel, jngoò xi̱ta̱ xi tje̱‑la̱ David xi 'mì Jesús nga jè ko̱chrjekàjiìn kjo̱'in. Nainá, k'oa̱á s'ín kitsjaà tso'ba nga ti̱sa̱ tàts'en‑la̱ kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","K'e̱ nga ti̱kj'eè f'iì Jesús, Juan kiìchja̱yajiìn‑la̱ xi̱ta̱ na̱xa̱ndá Israel nga kàtasíkájno jé‑la̱, mì ti̱ jé ko̱hótsji‑ne ko̱ kàtama bautizar. ");
INSERT INTO maaNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","K'e̱ nga jye tífehet'aà na̱chrjein‑la̱ Juan xá xi j'iì‑ne, kitsò: “Jñò, ¿kó s'ín nìkítsjeèn i̱t'aà ts'a̱n? ¿A bixón‑nò: jè Cristo? Majìn. Sa̱á nchrobá tji̱ngui jngoò‑na xi ìsa̱ tíjna ítjòn skanda mìkiì ok'ìn‑na nga 'a̱n skíjnda̱'ñoá xo̱x'ín‑la̱ xo̱xté‑la̱”, kitsò Juan. ");
INSERT INTO maaNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Ta̱nga i̱'ndei̱, k'oa̱á ma‑ne ko̱xan‑nò ngats'ioò jñò ndí 'ndsè xi tje̱‑la̱ Abraham inchrobàt'aà‑nò ko̱ jñò xi mìtsà ya̱ inchrobàt'aà‑nò ta̱nga yaxkón Nainá: jñá j'iì‑ná jè 'én i̱t'aà ts'e̱ Cristo nga jè ko̱chrjekàjiìn‑ná kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jñà xi̱ta̱ na̱xa̱ndá Jerusalén ko̱ xi̱ta̱xá‑la̱, mìkiì kijtseèxkon Jesús nga jè xi Cristo, ti̱koa̱á mìkiì kjòchi̱ya‑la̱ jñà 'én xi maxke̱ nga jiìn jiìn na̱chrjein jè na̱chrjein nìkjáya ya̱ ni'ya i̱ngo̱ sinagoga koni s'ín tjít'aà xo̱jo̱n ts'e̱ xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá. Ta̱nga jñà xi̱ta̱ koi kitsjaà o̱kixi̱ nga kàtiyaà Jesús ko̱ k'oa̱á s'ín tsitasòn koni tsò 'én koi. ");
INSERT INTO maaNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Na̱s'ín tsjìn‑la̱ jé Jesús nga ok'ìn‑la̱ nga ki̱yá, xi̱ta̱ koi, kisìjét'aà‑la̱ Pilato nga kàtasík'en. ");
INSERT INTO maaNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","K'e̱ nga jye tsitasòn yije koni s'ín tíchja̱ Xo̱jo̱n‑la̱ Nainá i̱t'aà ts'e̱ Jesús, kiskónáje̱n t'aà krò, i̱kjoàn kiì nga tsibíhijiìn. ");
INSERT INTO maaNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ta̱nga Nainá kisìkjaáya‑la̱ i̱t'aà ts'e̱ kjoa̱biyaà. ");
INSERT INTO maaNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jesús, k'e̱ nga jye jaáya‑la̱, kjìn k'a tsakó‑la̱ yijo‑la̱ jñà xi̱ta̱ xi chinchimako̱ nga inchrobà‑ne Galilea skanda Jerusalén; na̱chrjein i̱'ndei̱, jñà xi̱ta̱ koi xi béno̱jmí kixi̱‑la̱ xi̱ta̱ na̱xa̱ndá i̱t'aà ts'e̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Koi xá j'iì‑naje̱n nga kéno̱jmí‑je̱n 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo koni s'ín kitsjaà‑la̱ tso'ba Nainá jñà xi̱ta̱ jchínga‑naje̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","I̱'ndei̱, k'e̱ nga kisìkjaáya‑la̱ Jesús, k'oa̱á s'ín kisìkitasòn xi i̱t'aà tsa̱je̱n xi i̱xti‑la̱ ma‑je̱n jñà xi̱ta̱ jchínga‑naje̱n. K'oa̱á s'ín tjít'aà xo̱jo̱n ts'e̱ Salmo xi ma‑ne jò, nga tsò: “I̱'ndei̱, ji̱‑né xi Ki'ndí‑na̱ xan‑lè; 'a̱n‑ná xi na̱'èn‑lè ma.” ");
INSERT INTO maaNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Koni kis'iìn Nainá nga kisìkjaáya‑la̱ Jesús i̱t'aà ts'e̱ kjoa̱biyaà nga mì ti̱ kiì ki̱yá‑ne, ya̱á makixi̱ya 'én koi nga tsò Xo̱jo̱n‑la̱ Nainá: “Siìkitasòn‑ná koni tsò 'én tsjeè‑na̱, ko̱ 'én kixi̱‑na̱ xi 'a̱n kitsjaà‑la̱ David.” ");
INSERT INTO maaNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","K'oa̱á ti̱s'ín tjít'aà ìjngoò xo̱jo̱n ts'e̱ Salmo nga tsò: “Mìkiì koi̱'ndi nga ki̱'ndo yijo‑la̱ Xi̱ta̱ tsjeè‑lè.” ");
INSERT INTO maaNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Jñà na̱chrjein nga tsibìjnakon David, k'e̱ nga jye kisìkitasòn koni s'ín mejèn‑la̱ Nainá, k'en. K'oa̱á ti̱s'ín kisìhijiìn koni komàt'in xi̱ta̱ jchínga‑la̱. Ti̱koa̱á i'ndo yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ta̱nga jè Xi̱ta̱ Tsjeè xi Nainá kisìkjaáya‑la̱ mìkiì i'ndo yijo‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ngats'ioò jñò ndí 'ndsè, k'oa̱á s'ín kàtasijiìn‑nò, jñà 'én xi nokjoàyajiìn‑nòje̱n, jè‑né nga i̱t'aà ts'e̱ Jesús, Nainá síjchàat'aà‑ná jé‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Jñà xi̱ta̱, ngats'iì kjoa̱ xi ch'o s'ín, mìtsà i̱t'aà ts'e̱ kjo̱tíxoma‑la̱ Moisés makixi̱ya; jè i̱t'aà ts'e̱ Jesús makixi̱ya xi̱ta̱, jñà xi mokjeiín‑la̱ i̱t'aà ts'e̱. ");
INSERT INTO maaNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","T'e̱en kinda̱ yijo‑nò mé‑ne nga mì k'oa̱á s'ín ko̱mat'ioòn koni s'ín tíchja̱ xo̱jo̱n‑la̱ jñà xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá nga tsò: ");
INSERT INTO maaNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Chítsejèn, jñò xi nachrjekànguioò kjoa̱kixi̱, kàtaxkón‑nò, ko̱ jngoò k'a kàtachija jñò. 'A̱n, jngoò xá s'iaàn na̱chrjein tsa̱jòn, k'e̱ nga ti̱sa̱ titsa̱jnakoòn. Mìkiì ko̱kjeiín‑nò na̱s'ín s'e̱no̱jmí‑nò xá xi 'a̱n tìs'iaàn. ");
INSERT INTO maaNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Jè Pablo ko̱ Bernabé k'e̱ nga itjo‑ne ni'ya i̱ngo̱ sinagoga, jñà xi̱ta̱ kisìjét'aà‑la̱ nga kàtèno̱jmíya kjoa̱ koi jè xòhoto̱ xi sa̱ nchrobá. ");
INSERT INTO maaNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","K'e̱ nga kisìhixat'aà xíkjín nga kiì‑ne, kjìn xi̱ta̱ kiìt'aà‑la̱ Pablo ko̱ Bernabé, jñà xi xi̱ta̱ judío ko̱ jñà xi̱ta̱ xi beèxkón Nainá xi jye jahatjìya‑la̱ nga xi̱ta̱ judío komà. Jè Pablo ko̱ Bernabé, k'e̱ nga tsohóko̱ xi̱ta̱ koi, 'ñó tsibít'in‑la̱ nga ndaà kàtíjiìn ini̱ma̱‑la̱ jñà 'én xi jye kiì'nchré xi kjo̱ndaà ts'e̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Jè na̱chrjein nìkjáya xi ìjngoò, kjo̱meé ijchò ngats'iì xi̱ta̱ na̱xa̱ndá nga kiì'nchré 'én‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ta̱nga jñà xi̱ta̱ judío k'e̱ nga kijtseè nga 'ñó kjìn ma xi̱ta̱, ìsa̱á ndaà kjòchi̱ni̱keè Pablo. I̱kjoàn tsibíts'ia̱ nga kondra̱ kiì‑la̱ Pablo 'én xi kiìchja̱, ti̱koa̱ tsakatít'aà. ");
INSERT INTO maaNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pablo ko̱ Bernabé, 'ñó tsi'beé‑la̱ ikon; kitsò‑la̱: ―Tjínè‑naje̱n nga kéno̱jmí ítjòn‑nòje̱n 'én‑la̱ Nainá jñò xi xi̱ta̱ judío 'mì‑nò; ta̱nga jñò nachrjengui‑nò; k'oa̱á ma‑ne nga jñò, mìkiì s'e̱‑nò kjoa̱binachon ni̱ta̱ mé na̱chrjein‑ne; ngaje̱n ta̱ sa̱á jñà kéno̱jmí‑la̱je̱n jñà xi mìtsà xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","K'oa̱á s'ín tsatíxoma‑naje̱n Nainá nga kitsò: Ji̱í tsjaà‑lè xá nga si̱hiseèn‑la̱ jñà xi̱ta̱ xi mìtsà xi̱ta̱ judío, kóho̱kji nga tíjtsa i̱sò'nde mé‑ne nga ki̱tjokàjiìn‑ne kjoa̱ ts'e̱ kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","K'e̱ nga kiì'nchré ngats'iì xi mìtsà xi̱ta̱ judío, kjòtsjaá‑la̱; i̱kjoàn tsibíts'ia̱ nga kitsò: Ndaà tjín 'én‑la̱ Nainá; kòkjeiín‑la̱ ngats'iì xi xó kitjaàjiìn‑ne nga s'e‑la̱ kjoa̱binachon ni̱ta̱ mé na̱chrjein‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","K'oa̱á s'ín komà nga tsabísòn 'én ndaà‑la̱ Nainá kóho̱kji ya̱ i̱'nde jè. ");
INSERT INTO maaNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ta̱nga jñà xi̱ta̱ judío tsibíts'ia̱ nga chinchá'a jñà íchjín ítjòn xi ndaà beèxkón Nainá ko̱ xi̱ta̱ ítjòn‑la̱ na̱xa̱ndá. K'oa̱á s'ín komà nga kondra̱ kiì‑la̱ jè Pablo ko̱ Bernabé. Tsachrjekàjiìn ya̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Jè Pablo ko̱ Bernabé tsibítsajneè chijo‑la̱ ndso̱ko̱ xi kondra̱ ts'e̱ xi̱ta̱ koi, jè kjoa̱ xi okó nga kjo̱'in s'e̱‑la̱ i̱t'aà ts'e̱ Nainá; i̱kjoàn kiì ján Iconio. ");
INSERT INTO maaNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ta̱nga jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo, ndaà kis'e‑la̱ kjo̱tsjacha ko̱ ndaà kisìxájiìn ini̱ma̱‑la̱ Ini̱ma̱ Tsjeè‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","K'oa̱á s'ín komà ya̱ Iconio, jè Pablo ko̱ Bernabé, k'e̱ nga jahas'en ni'ya i̱ngo̱ sinagoga ts'e̱ xi̱ta̱ judío, 'ñó ndaà tsakóya; k'oa̱á komà‑ne nga 'ñó kjìn xi̱ta̱ judío ko̱ xi mìtsà xi̱ta̱ judío kòkjeiín‑la̱ i̱t'aà ts'e̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ta̱nga jñà xi̱ta̱ judío xi mìkiì mokjeiín‑la̱, chinchá'a jñà xi mìtsà xi̱ta̱ judío mé‑ne nga ch'o tsò‑ne kjo̱hítsjeèn xi kisìkítsjeèn i̱t'aà ts'e̱ xi̱ta̱‑la̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pablo ko̱ Bernabé, tseé tsibìtsa̱jna ya̱ Iconio. Mìkiì kitsakjòn nga tsakóya 'én ndaà‑la̱ Nainá koií kjoa̱‑la̱ nga Nainá ndaà ma'ñót'aà takòn. Nainá kisìkixi̱yandaà nga kixi̱ kjoa̱ 'én xi tsibéno̱jmí xi kjo̱ndaà‑la̱ Nainá. Kitsjaà‑la̱ nga'ñó nga kis'iìn kjo̱xkón xi ndaà tjín xi okó kjoa̱jeya‑la̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Jñà xi̱ta̱ na̱xa̱ndá Iconio, jòya komà; osen kiìt'aà‑la̱ jñà xi̱ta̱ judío koa̱ osen kiìt'aà‑la̱ Pablo ko̱ Bernabé, xi̱ta̱ xi tsibíxáya‑la̱ Jesús. ");
INSERT INTO maaNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jñà xi̱ta̱ judío ko̱ xi mìtsà xi̱ta̱ judío tsajoóya‑ne ko̱ xi̱ta̱xá ítjòn‑la̱ nga mejèn‑la̱ ska̱àn‑ko̱, ki̱ìnè nda̱jo̱. ");
INSERT INTO maaNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pablo ko̱ Bernabé, k'e̱ nga jye kiì'nchré, tsanga; kiì ján Listra ko̱ Derbe, na̱xa̱ndá xi chja̱‑ne Licaonia; ti̱koa̱ chinchima kóho̱kji i̱'nde xi chja̱‑ne nga jngoò itjandiì. ");
INSERT INTO maaNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ya̱ i̱'nde jè, ti̱koa̱ kisìka'bí 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ya̱ Listra tíjna jngoò xi̱ta̱ x'i̱n xi mìkiì ma fì. K'oa̱á s'ín kits'iìn; ni̱ sa̱á jngoò na̱chrjein nga ndso̱ko̱ tsajmeè‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Xi̱ta̱ jè, tíjna; tí'nchré‑la̱ Pablo nga tíchja̱ya. Jè Pablo, k'e̱ nga kiskoò'an, kijtseè nga mokjeiín‑la̱ nga ko̱ndaà‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pablo, 'ñó kiìchja̱ kitsò‑la̱: ―¡Ti̱sítji̱in, ti̱si̱jna kixi̱‑ne ndso̱koiì! Xi̱ta̱ jè, nguì kiskì'nga‑né; tsibíts'ia̱ nga tsajmeè‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Jñà xi̱ta̱, k'e̱ nga kijtseè kjo̱xkón ndaà xi kis'iìn Pablo, 'ñó kiìchja̱ xi 'én Licaonia, kitsò: ―¡Jñà nainá, xi̱ta̱á kjoàn kòma nga kòf'iìkon‑ná! ");
INSERT INTO maaNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabé, Zeus kitsò‑la̱; Pablo, Hermes kitsò‑la̱ nga jè xi ìsa̱ 'ñó chja̱. ");
INSERT INTO maaNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jè i̱ngo̱ xkósòn‑la̱ Zeus, ya̱á kijna i̱ndiì na̱xa̱ndá. Jè no̱'miì‑la̱ j'iìko̱ nchra̱ja̱ ko̱ corona. Jè no̱'miì, ko̱ ngats'iì xi̱ta̱ na̱xa̱ndá mejèn sík'en‑la̱ jñà nchra̱ja̱ nga tsjá‑la̱ kjo̱tjò mé‑ne nga skoe̱xkón‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Jè Pablo ko̱ Bernabé xi kisìxáya‑la̱ i̱t'aà ts'e̱ Cristo, ch'oó komà‑la̱ k'e̱ nga kijtseè kjoa̱ xi nchis'ín; tsatejndajno yijo‑la̱ jè nikje‑la̱; i̱kjoàn kiìs'ejiìn‑la̱ xi̱ta̱. 'Ñó kiìchja̱, kitsò‑la̱: ");
INSERT INTO maaNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―Ti̱ná'yaà, ¿mé‑ne k'oa̱s'ín titsa̱'nè‑nò? Ngaje̱n, ti̱koa̱á ta̱xki̱ xi̱ta̱‑náje̱n koni jñò. Koií xá kòf'i̱‑naje̱n nga kéno̱jmí‑nòje̱n 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo mé‑ne nga si̱kíjna‑nò kjoa̱ koi xi nì mée chjí‑la̱; jè tanguít'aà‑là Nainá xi tíjnakon xi tsibíndaà ngajmiì, nangui, ko̱ ndáchikon, ko̱ ngats'iì tsojmì xi ya̱ tjín. ");
INSERT INTO maaNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Na̱chrjein xi jye tsato, Nainá kitsjaà'ndeé‑la̱ ngats'iì xi̱ta̱ na̱xa̱ndá xi tjín kóho̱kji i̱sò'nde nga chinchimaya ndi̱yá xi kisaseèn‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ta̱nga Nainá, kjit'aà na̱chrjein tíhokó yijo‑la̱ yá‑né jè, nga tí'ya‑la̱ ngats'iì kjo̱ndaà xi tís'ín; jè‑né xi tísíkasén‑nò jtsí xi ngajmiì tínchrobá‑ne; títsjá‑nò tsojmì xi ndaà tímajchá‑nò; jè tísíchikon‑t'in‑nò nga ndaà títsjá‑nò tsojmì xi ma chine, mé‑ne nga ndaà s'e̱‑nò kjo̱tsja. ");
INSERT INTO maaNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pablo ko̱ Bernabé, na̱s'ín k'oa̱s'ín tsatekjáya yije‑la̱ kjoa̱ xi nchis'ín nga mejèn si̱ìk'en‑t'aà‑la̱ cho̱, tseé xá kisengui nga kòkjeiín‑la̱ jñà xi̱ta̱ na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ti̱k'e̱‑ne j'iì xi̱ta̱ judío xi inchrobà‑ne Antioquía ko̱ Iconio xi chinchá'a jñà xi̱ta̱ na̱xa̱ndá nga tsibínè nda̱jo̱ jè Pablo. K'e̱ nga jye k'oa̱s'ín kisìko̱, kitsò‑né tsà jyeé k'en; i̱kjoàn tsibífejno nangui, kiì síkatje̱n ján i̱ndiì na̱xa̱ndá. ");
INSERT INTO maaNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ta̱nga jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo, k'e̱ nga chixoñat'aà‑la̱ Pablo ñánda kijna, jè Pablo tsasítje̱n ìjngoò k'a‑ne; jahas'en‑jiìn ìjngoò k'a‑ne na̱xa̱ndá; xi komà inchijòn, Pablo ko̱ Bernabé kiì ján Derbe. ");
INSERT INTO maaNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","K'e̱ nga jye tsibéno̱jmí 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo ya̱ Derbe, nga jye kjìn xi̱ta̱ kòkjeiín‑la̱, kiì ìjngoò k'a‑ne Listra, Iconio ko̱ Antioquía. ");
INSERT INTO maaNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pablo ko̱ Bernabé kitsjaà‑la̱ nga'ñó ini̱ma̱‑la̱ jñà xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo xi títsa̱jna na̱xa̱ndá koi; tsibéno̱jmí‑la̱ nga kixi̱ kàtìtsa̱jnako̱ 'én xi mokjeiín‑la̱; kitsò‑la̱: ―Mochjeén‑né nga tse kjo̱'in si̱kjiaán ítjoán k'e̱ nga ki̱tjás'e̱n‑jñaá ñánda tíhotíxoma Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nga jngoò ìjngoò i̱'nde ñánda tjín xi̱ta̱ na̱xa̱ndá‑la̱ Cristo, Pablo ko̱ Bernabé jaàjiìn xi̱ta̱ jchínga xi tsibít'aà xá nga si̱ìkinda̱ xi̱ta̱‑la̱ Cristo; k'e̱ nga jye kiìchja̱t'aà‑la̱ Nainá, jye tsibìtsa̱jnachjan, kisìkítsa̱jnaya tsja Nainá nga jye mokjeiín‑la̱ i̱t'aà ts'e̱ Nainá. ");
INSERT INTO maaNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Jahato i̱'nde Pisidia, ijchò‑ne nangui Panfilia. ");
INSERT INTO maaNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tsibéno̱jmí 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo ya̱ Perge, i̱kjoàn kiì‑ne Atalia. ");
INSERT INTO maaNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ya̱á jahas'en chitso nga tsohótji‑ne nga kiì ìjngoò k'a‑ne Antioquía, i̱'nde ñánda kisatiìxá‑la̱ i̱t'aà ts'e̱ kjo̱ndaà‑la̱ Nainá, xá xi jye kisìkitasòn. ");
INSERT INTO maaNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","K'e̱ nga jye ijchò‑ne Antioquía, tsibíxkóya xi̱ta̱ na̱xa̱ndá‑la̱ Cristo; tsibéno̱jmí‑la̱ ngats'iì kjoa̱ xi kisìko̱ Nainá, kós'ín komàt'in nga Nainá kitsjaà'nde nga ti̱koa̱ kòkjeiín‑la̱ jñà xi mìtsà xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pablo ko̱ Bernabé, tseé tsibìtsa̱jnako̱ xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo ya̱ Antioquía. ");
INSERT INTO maaNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Jñà na̱chrjein koi, j'iì i'nga xi̱ta̱ xi inchrobà‑ne Judea nga tsibéno̱jmí‑la̱ xi̱ta̱‑la̱ Cristo, kitsò‑la̱: “Mìkiì ki̱tjokàjñoò kjo̱'in tsà mìkiì si̱t'aà chi̱ba̱‑la̱ yijo‑nò kjoa̱ ts'e̱ circuncisión koni s'ín tíchja̱ kjo̱tíxoma xi kiskiì Moisés.” ");
INSERT INTO maaNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo ko̱ Bernabé 'ñó tsajoókjoò ko̱ jñà xi̱ta̱ koi; tsohótiyaá‑ne jñà kjoa̱ koi; i̱kjoàn kisìkasén Pablo ko̱ Bernabé ján Jerusalén; tsobáhijtako̱ i'nga xi̱ta̱‑la̱ Cristo xi títsa̱jna ya̱ Antioquía nga kiìkon jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús ko̱ xi̱ta̱ jchínga xi otíxoma ya̱ na̱xa̱ndá‑la̱ Cristo nga si̱ndaàjiìn kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jñà xi̱ta̱ na̱xa̱ndá‑la̱ Cristo xi títsa̱jna Antioquía, kisìchját'aà‑la̱ nga kiì‑ne xi̱ta̱ koi. Jahato Fenicia ko̱ Samaria; tsibéno̱jmí nga jñà xi mìtsà xi̱ta̱ judío ti̱koa̱ jyeé tífatjìya‑la̱ nga Cristo nchifìt'aà‑la̱. Ngats'iì xi̱ta̱ xi mokjeiín‑la̱ i̱t'aà ts'e̱ Cristo, 'ñó kjòtsja‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pablo ko̱ Bernabé, k'e̱ nga ijchò ján Jerusalén, jñà xi̱ta̱ na̱xa̱ndá‑la̱ Cristo ko̱ xi̱ta̱ jchínga xi ya̱ otíxoma ko̱ xi̱ta̱ xi tsibíxáya‑la̱ Jesús, ndaá kiskoétjò. Xi̱ta̱ koi tsibéno̱jmí yije mé kjoa̱ xi kis'iìn Nainá nga kisìchját'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ya̱ títsa̱jnajiìn i'nga xi̱ta̱ fariseo xi jye kòkjeiín‑la̱ 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo; chincha kixi̱, kitsò: ―Jñà xi mìtsà xi̱ta̱ judío xi jye mokjeiín‑la̱, mochjeén‑né nga si̱t'aà chi̱ba̱‑la̱ kjoa̱ ts'e̱ circuncisión; ti̱koa̱ si̱nè‑la̱ nga kàtasíkitasòn kjo̱tíxoma xi kiskiì Moisés. ");
INSERT INTO maaNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kjòxkóya xi̱ta̱ xi tsibíxáya‑la̱ Jesús ko̱ xi̱ta̱ jchínga xi otíxoma ya̱ i̱jiìn na̱xa̱ndá‑la̱ Cristo nga tsajoóya‑ne kjoa̱ koi. ");
INSERT INTO maaNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tse jchán tsajoóya‑ne kjoa̱ koi; chaán tsasíjna kixi̱ Pedro, kiìchja̱, kitsò: ―'Ndseé, jñò, jyeé tíjiìn‑nò nga kjòtseé jaàjiìn‑na Nainá nga 'a̱n kèno̱jmí‑la̱ 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo jñà xi mìtsà xi̱ta̱ judío mé‑ne nga ti̱koa̱ ko̱kjeiín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nainá xi beè ini̱ma̱‑ná, k'oa̱á s'ín tsakó kixi̱‑ná nga ti̱koa̱ kiskoétjò xi̱ta̱ koi nga k'oa̱á ti̱s'ín kitsjaà‑la̱ Ini̱ma̱ Tsjeè‑la̱ koni s'ín kitsjaà‑ná jñá. ");
INSERT INTO maaNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nainá, kisìtsjeè ini̱ma̱‑la̱ xi̱ta̱ koi k'e̱ nga kòkjeiín‑la̱ i̱t'aà ts'e̱ Cristo, nga mìkiì faájiìn xi̱ta̱, tà ngásòn fìko̱‑ná ngats'iaá, xi xi̱ta̱ judío 'mì‑ná ko̱ xi ta̱xki̱ xi̱ta̱. ");
INSERT INTO maaNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","I̱'ndei̱, ¿mé‑ne kondra̱ onguí‑là kjo̱hítsjeèn‑la̱ Nainá, tsà koi na̱chrjein‑la̱ ko̱jti‑la̱? Nga bìnè‑lá xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo nga si̱ìkitasòn kjoa̱ ts'e̱ kjo̱tíxoma. Ni̱ jñá ko̱ ni̱ jñà xi̱ta̱ jchínga‑ná chíkjoa̱‑ná nga nìkitasoán. ");
INSERT INTO maaNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mìkiì ko̱s'ín ko̱ma. Nga̱ k'oa̱á s'ín mokjeiín‑ná nga jñá, ko̱ xi ta̱xki̱ xi̱ta̱, ta ngásòn kjo̱ndaà‑la̱ Na̱'èn‑ná Jesucristo kítjokàjñaá kjo̱'in. ");
INSERT INTO maaNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Jyò tsibìtsa̱jna ngats'iì xi̱ta̱ xi ya̱ títsa̱jna. Kiì'nchré‑la̱ Bernabé ko̱ Pablo nga tsibéno̱jmí‑la̱ xi̱ta̱ nga 'ñó tse kjo̱xkón ndaà xi kis'iìn Nainá xi i̱t'aà ts'e̱ nga nguixko̱n jñà xi mìtsà xi̱ta̱ judío. ");
INSERT INTO maaNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","K'e̱ nga jye kiìchja̱ Bernabé ko̱ Pablo, k'e̱é kiìchja̱ Jacobo, kitsò: ―'Ndseé xi i̱ titsa̱jnaà, ti̱ná'ya‑ná. ");
INSERT INTO maaNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Jè Simón Pedro, jyeé tsibéno̱jmí‑ná kó s'ín komà nga ti̱sa̱ ítjòn nga Nainá jaàjiìn jñà xi mìtsà xi̱ta̱ judío nga na̱xa̱ndá‑la̱ ko̱ma. ");
INSERT INTO maaNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","K'oa̱á s'ín mangásòn 'én koni s'ín kiskiì jñà xi̱ta̱ xi kiìchja̱ ngajo‑la̱ Nainá nga kitsò: ");
INSERT INTO maaNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","K'e̱ nga ko̱ma i̱skan, ki̱tjojen ìjngoò k'a nga kìndàyà xi̱tse̱‑na kjo̱tíxoma‑la̱ xi̱ta̱xá ítjòn David xi jye its'oòn; jè xi jye chixoña, ìjngoò k'a síkixi̱ya‑na; siìkíjna jngoò‑na xi̱ta̱ xi ko̱tìxoma ngajo‑la̱ David, ");
INSERT INTO maaNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","mé‑ne jñà xi̱ta̱ xi i'nga ko̱hótsji‑ne Nainá, ngats'iì xi mìtsà xi̱ta̱ judío, jñà xi 'ín ts'a̱n tjít'aà. ");
INSERT INTO maaNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","K'oa̱á tsò Nainá, nga tsibéno̱jmí kjo̱hítsjeèn xi tjín‑la̱ skanda ti̱sa̱ tàts'en‑la̱ kjoa̱. ");
INSERT INTO maaNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’'A̱n, k'oa̱á xán‑nò nga mìkiì si̱nè‑la̱ kjoa̱ xi 'in tjín jñà xi mìtsà xi̱ta̱ judío, jñà xi nchifatjìya‑la̱ nga Nainá nchifìt'aà‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ta jè xi mochjeén nga si̱kasén‑lá xo̱jo̱n mé‑ne nga mìkiì ski̱ne̱ ngats'iì tsojmì xi ya̱ sinchá nguixko̱n kjoa̱xkósòn; ti̱koa̱ kì ti̱ kjoa̱ chijngui s'ín‑ne, mì ti̱ kiì ski̱ne̱‑ne jní ko̱ ngats'iì yijo‑la̱ cho̱ xi mìkiì xíxteèn jní‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Skanda kjòtseé, xki̱ xi ján na̱xa̱ndá tjín xi̱ta̱ xi bíxke̱jiìn xo̱jo̱n kjo̱tíxoma xi kiskiì Moisés ya̱ ni'ya i̱ngo̱ sinagoga nga jiìn jiìn na̱chrjein nga na̱chrjein nìkjáya. ");
INSERT INTO maaNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús ko̱ ngats'iì xi̱ta̱ na̱xa̱ndá‑la̱ Cristo ko̱ xi̱ta̱ jchínga xi ya̱ otíxoma, tsajoóya‑ne nga jaàjiìn i'nga xi̱ta̱ xíkjín xi kisìkasén ján Antioquía. Jñà kitjaàjiìn Judas xi ti̱koa̱ Barsabás 'mì ko̱ Silas, jñà xi̱ta̱ xi ndaà yaxkón ya̱ i̱jiìn na̱xa̱ndá‑la̱ Cristo. Tsobáhijtako̱ Pablo ko̱ Bernabé. ");
INSERT INTO maaNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kisìk'a jngoò xo̱jo̱n xi tsò: “Ngaje̱n, xi̱ta̱ xi tsibíxáya‑la̱ Jesús ko̱ xi̱ta̱ jchínga, nìhixat'aà‑nòje̱n jñò xi mìtsà xi̱ta̱ judío 'mì‑nò xi 'ndsé chibá i̱t'aà ts'e̱ Cristo xi titsa̱jnaà ya̱ na̱xa̱ndá Antioquía, ko̱ i̱'nde Siria ko̱ Cilicia. ");
INSERT INTO maaNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Jyeé kina'yà‑je̱n nga i̱ itjokàjiìn i'nga xi̱ta̱ xi ijchòkon‑nò nga siì síko̱‑nò nga chja̱ko̱‑nò 'én xi síkits'ón‑jiìn‑la̱ ini̱ma̱‑nò, ta̱nga mìtsà ngaje̱n tsatíxá‑la̱je̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ngats'iì‑je̱n, k'oa̱á s'ín kichoòsòn‑la̱je̱n nga kinìkasén i'nga‑nòje̱n xi̱ta̱ tsa̱je̱n xi kiìkon‑nò. Tsobáhijtako̱ xinguia̱á Pablo ko̱ Bernabé, xi̱ta̱ xi 'ñó matsjacha‑je̱n. ");
INSERT INTO maaNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Jñà xi̱ta̱ koi, jye k'oa̱s'ín tsibínè‑la̱ yijo‑la̱ ni̱ta̱ mé kjo̱'in xi komàt'in xi kjoa̱ ts'e̱ Na̱'èn‑ná Jesucristo. ");
INSERT INTO maaNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Titsa̱nìkasén‑nòje̱n Judas ko̱ Silas; ngats'iì 'én xi tjít'aà xo̱jo̱n, jñà xi̱ta̱ koi ke̱èno̱jmíya ìjngoò k'a‑nò xi tà 'én ko̱òko̱‑nò. ");
INSERT INTO maaNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ngaje̱n ko̱ Ini̱ma̱ Tsjeè‑la̱ Nainá ndaà kisaseèn‑naje̱n nga mì kjo̱'ñó ko̱ma‑nò kjoa̱ ts'e̱ kjo̱tíxoma xi 'in tjín; tà koi‑né xi ndaà mochjeén: ");
INSERT INTO maaNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","nga mìkiì ma chji̱ne̱e yijo‑la̱ cho̱ xi ya̱ biyaà nguixko̱n xkósòn; mìkiì ma chji̱ne̱e jní ko̱ mìkiì ma chji̱ne̱e yijo‑la̱ cho̱ xi mìkiì xíxteèn jní‑la̱; ti̱koa̱á kì ti̱ kjoa̱ chijngui nìs'in‑là; tsà chja̱àxìn‑là yijo‑nò ngats'iì kjoa̱ koi, ndaà s'e̱; k'e̱ chibá.” ");
INSERT INTO maaNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Xi̱ta̱ koi, k'e̱ nga jye kisìhixat'aà xíkjín, ni̱to̱ón kiì skanda ján Antioquía; k'e̱ nga ijchò tsibíxkóya ngats'iì xi̱ta̱‑la̱ Cristo, kisìnga̱tsja xo̱jo̱n xi 'ya. ");
INSERT INTO maaNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Jñà xi̱ta̱ na̱xa̱ndá‑la̱ Cristo, k'e̱ nga jye tsibíxke̱jiìn xo̱jo̱n, tsjaá komà‑la̱ nga ijchò‑la̱ 'én xi kisìjehikon. ");
INSERT INTO maaNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jè Judas ko̱ Silas ti̱koa̱á Nainá chja̱ ngajo‑la̱; ndaà kisìjehikon jñà xi̱ta̱‑la̱ Cristo; kitsjaà‑la̱ nga'ñó. ");
INSERT INTO maaNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Xi̱ta̱ koi, kjìn na̱chrjein tsibìtsa̱jna Antioquía. Nga komà i̱skan kisìhixat'aà xíkjín, kiì‑ne Jerusalén; kiìkon‑ne jñà xi̱ta̱ xi kisìkasén. ");
INSERT INTO maaNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ta̱nga jè Silas ndaà kisaseèn‑la̱ nga tsibìjna Antioquía. ");
INSERT INTO maaNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Jè Pablo ko̱ Bernabé, ya̱á tsibìtsa̱jna Antioquía; tsakóya‑ìsa 'én‑la̱ Nainá ti̱koa̱ kiìchja̱ya 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo. Ti̱koa̱á kjìn xi̱ta̱ xi kj'ei̱í kisìxákjoò. ");
INSERT INTO maaNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","K'e̱ nga komà i̱skan, Pablo kitsò‑la̱ Bernabé: ―Tíkjiaán ìjngoò k'aá kóho̱kji na̱xa̱ndá ñánda tsibèno̱jmiá 'én‑la̱ Nainá mé‑ne nga jcha̱á kó s'ín títsa̱jna xi̱ta̱ xinguia̱á. ");
INSERT INTO maaNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Jè Bernabé mejèn‑la̱ kji̱ko̱ Juan, xi ti̱koa̱ Marcos 'mì; ");
INSERT INTO maaNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ta̱nga jè Pablo mìkiì kisaseèn‑la̱ nga jè kji̱ko̱, koií kjoa̱‑la̱ nga kitsjeiìn takòn ján Panfilia nga mì ti̱ kiì tsobáhijtako̱‑ne nga kisìxá jè xá xi tjíma‑ne. ");
INSERT INTO maaNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","K'oa̱á s'ín komà‑ne nga kisakò kjoa̱ nga mìkiì kjòngásòn 'én‑la̱; chinchat'aà xìn‑la̱ xíkjín; jè Bernabé kiìko̱ Marcos; kiìsòn‑ndá skanda Chipre. ");
INSERT INTO maaNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Jè Pablo, jaàjiìn Silas nga tsobáhijtako̱. Jñà xi̱ta̱‑la̱ Cristo kisìkítsa̱jnaya tsja Nainá nga kiì. ");
INSERT INTO maaNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kiì kóho̱kji nangui Siria ko̱ Cilicia nga ya̱ chinchima nga ìsa̱ ndaà kisì'ñó ikon jñà xi̱ta̱ na̱xa̱ndá‑la̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo, k'e̱ nga ijchò na̱xa̱ndá Derbe ko̱ Listra, ya̱ kisatiìkjoò jngoò xi̱ta̱ xi kota'yàt'aà‑la̱ Cristo xi Timoteo 'mì; nea̱‑la̱ xi̱ta̱ judío‑né xi mokjeiín‑la̱ i̱t'aà ts'e̱ Cristo. Ta̱nga jè na̱'èn‑la̱ xi̱ta̱ griego‑né. ");
INSERT INTO maaNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jñà xi̱ta̱‑la̱ Cristo xi títsa̱jna Listra ko̱ Iconio 'ñó ndaà kisìkíjna Timoteo. ");
INSERT INTO maaNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo mejèn‑la̱ nga jè koa̱hijtako̱; k'oa̱á komà‑ne nga kisit'aà chi̱ba̱‑la̱ kjoa̱ ts'e̱ circuncisión mé‑ne nga ndaà kíjna‑ne Timoteo i̱t'aà ts'e̱ xi̱ta̱ judío; nga jñà xi̱ta̱ xi ya̱ i̱'nde‑la̱ jyeé beè nga na̱'èn‑la̱ Timoteo, xi̱ta̱ griego‑né. ");
INSERT INTO maaNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ngats'iì na̱xa̱ndá ñánda jahato, k'oa̱á kitsò‑la̱ nga kàtasíkitasòn kjoa̱kixi̱ xi tsajoóya‑ne jñà xi̱ta̱ xi tsibíxáya‑la̱ Jesús ko̱ xi̱ta̱ jchínga xi títsa̱jna Jerusalén xi otíxoma ya̱ i̱jiìn na̱xa̱ndá‑la̱ Cristo. ");
INSERT INTO maaNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jñà xi̱ta̱ na̱xa̱ndá‑la̱ Cristo, ìsa̱á 'ñó ndaà mokjeiín ìsa̱‑la̱; na̱chrjein nchijòn tímakjìn‑ya xi̱ta̱ xi nchimokjeiín‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Jè Ini̱ma̱ Tsjeè‑la̱ Nainá mìkiì kitsjaà'nde‑la̱ Pablo ko̱ xi̱ta̱ xi kjihijtako̱ nga 'én‑la̱ Cristo kiì síka'bí ján nangui Asia; k'oa̱á ma‑ne nga ya̱ jahatojiìn nangui ñánda 'mì Frigia ko̱ Galacia. ");
INSERT INTO maaNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","K'e̱ nga ijchò chrañàt'aà‑la̱ nangui Misia mején‑la̱ nga ján kjoi̱ nangui Bitinia, ta̱nga jè Ini̱ma̱‑la̱ Jesús mìkiì kitsjaà'nde‑la̱. ");
INSERT INTO maaNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tà jahato Misia, ijchò skanda na̱xa̱ndá Troas. ");
INSERT INTO maaNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nga jye títsa̱jna Troas, Pablo, k'e̱ nga ni̱tje̱n, tsatsejèn jngoò‑la̱ xi̱ta̱ koni tsà nijñá tí'biì‑la̱ xi nangui Macedonia i̱'nde‑la̱ xi tsasíjna kixi̱ nguixko̱n Pablo. Tsibítsi'ba‑la̱, kitsò‑la̱: “Nchroboí i̱ nangui Macedonia. Ti̱chját'aà‑náje̱n.” ");
INSERT INTO maaNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo, k'e̱ nga jye kijtseè kjoa̱ koi, ni̱to̱ón tsitsa̱jnandaà‑je̱n nga tsanguì‑je̱n ján nangui Macedonia; k'oa̱á s'ín kjòchi̱ya‑naje̱n nga kixi̱í kjoa̱ nga Nainá tíchja̱‑naje̱n mé‑ne nga si̱ka'bí‑je̱n 'én ndaà‑la̱ Nainá xi kjoa̱ ts'e̱ Cristo ya̱ i̱'nde jè. ");
INSERT INTO maaNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","K'e̱ nga itjo‑naje̱n ya̱ na̱xa̱ndá Troas, kichjoé jngoò‑je̱n chitso, tsanguí kixi̱‑je̱n ya̱ nangui xi kijnajiìn ndá xi 'mì Samotracia; xi komà inchijòn ìjngoò k'a tsanguì‑je̱n skanda na̱xa̱ndá Neápolis. ");
INSERT INTO maaNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Itjo‑naje̱n Neápolis, tsanguí‑je̱n Filipos, jngoò na̱xa̱ndá ítjòn ts'e̱ i̱'nde Macedonia xi 'ñó tjoé‑la̱ nga'ñó i̱t'aà ts'e̱ Roma. Kjìn na̱chrjein tsitsa̱jna‑je̱n ya̱ i̱'nde jè. ");
INSERT INTO maaNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jngoò na̱chrjein nìkjáya tsanguí jngoò‑je̱n i̱'nde i̱ndiì na̱xa̱ndá ñánda tífa jngoò xa̱jngá nandá nga k'oa̱s'ín kinìkítsjeèn‑je̱n nga tjín jngoò i̱'nde ñánda chja̱t'aà‑la̱ Nainá xi̱ta̱ judío. Tsitsa̱jna‑j