﻿USE sofia;
DROP TABLE IF EXISTS sofia.lyn_vpl;
CREATE TABLE lyn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lyn_vpl WRITE;
INSERT INTO lyn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Eyi ebuka no lusika lwa Jesu Kilesite mwanaye Dabida mwanaye Abulahama. ");
INSERT INTO lyn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abulahama na kuleya Isaka, mi Isaka na kuleya Jakobo, Jakobo na kuleya Juda na inaye, ");
INSERT INTO lyn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda na kuleya Pelezi ni Zela, woyo inawaye neli Tama, Mi Pelezi na kuleya Heziloni, Heziloni nakuleya Alama, ");
INSERT INTO lyn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alama nakuleya Aminadabi, woyo onakuleya Nashoni, Nashoni nakuleya Salumoni. ");
INSERT INTO lyn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salomoni nakuleya Boazi, woyo inawaye neli Lahaba. Boazi nakuleya Obedi woyo inawaye neli Lusi, Obedi nakuleya Jese. ");
INSERT INTO lyn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Cwale Jese nakuleya Mbumu Dabida, Dabida nakuleya Solomoni, woyo inawaye neli moyo waye Uliya. ");
INSERT INTO lyn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni nakuleya Lehoboami, Lehoboami nakuleya Abiya, mi Abiya nakuleya Asa, ");
INSERT INTO lyn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa nakuleya Jehosifati, Jehosifati nakuleya Jolami, Jolami nakuleya Uziya. ");
INSERT INTO lyn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya nakuleya Jotamu, Jotamu nakuleya Ahazi, Akazi nakuleya Ezekiya. ");
INSERT INTO lyn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiya nakuleya Manase, Manase nakuleya Amoni, Amoni nakuleya Josiya. ");
INSERT INTO lyn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Mi Josiya nakuleya Jekoniya, nainaye ba nako no mwendo woo ba nako ana kutwaliwa ku ukoba mu Babilona. ");
INSERT INTO lyn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Munyima no kutwaliwa ku Babilona, Jekoniya nakuleya Shelutelo, Shelutelo nakuleya Zelubabele. ");
INSERT INTO lyn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabele nakuleya Abihundi, Abihundi nakuleya Aliyakimu, Aliyakimu nakuleya Aza. ");
INSERT INTO lyn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aza nakuleya Zadoki, Zadoki nakuleya Akimi, Akimi nakuleya Elihudi. ");
INSERT INTO lyn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihudi nakuleya Eliyaza, Eliyaza nakuleya Matani, Matani nakuleya Jakobo. ");
INSERT INTO lyn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Mi Jakobo nakuleya Josefa munuwaye Maliya, Maliya inawaye Jesu woyo oisaniwa nji Kilesite. ");
INSERT INTO lyn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mi cwale, kame kuli amasika no kukwana likumi ni tunee (14), okutunda kwa Abulahama okutwala kwa Dabida likumi ni tunee (14) okutunda kwa Dabida okutwala ba kutwaliwa ku Babilona, mi likumi ni tunee (14) okutuda ba kutwaliwa ku Babilona okwiiya ba kuleiwa kwa Kilesite. ");
INSERT INTO lyn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Omu omuna kwiyela okuleiwa kwa Jesu Kilesite. Maliya inawaye kame ana kubeleziwa nji akwaliwe ku mulume oisaniwa Josefa, kono abo kaasiku kukwata kale, sebeli olimuka nji kame aimanine mu mundi ku maata no Mebo No Kukena. ");
INSERT INTO lyn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josefa neli omunu no kuluka, mi kasikusinga okwenisa Maliya balubala no aanu. Kaba ana kulela oku mukana kumukunda. ");
INSERT INTO lyn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Abo yolemine okunahana nji atende ngeeso, omone! Elin̄eloi lya Mbumu Nyambe sebeli liku monahaza kutulo ni kwamba nji, “Josefa mwanaye Dabida, olese kucila okukwata Maliya okumutenda mukatowe, kakuli eso akushimbile kame situnda ku Mebo No Kukena. ");
INSERT INTO lyn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mba leye omwana no ndumbana mi mba umutumbu elitina lya Jesu, kakuli mba yoyisa aanu aye kuuyi woo.” ");
INSERT INTO lyn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Eyi yonje nai kutendahala okwiyateteta eyi ina kwambiwa kwa Mbumu Nyambe ku munuhi waye. ");
INSERT INTO lyn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Komumone, omukatana no kwa kuwana ni mulume mbaikala ba meyi no ubya mi mba leye omwana no ndumbani, mi mbamwisana nji Imanuwele.” (Okutalusa nji, “Nyambe kame ali netu).” ");
INSERT INTO lyn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cwale Josefa abana inguka, sebeli otenda kanyi omo linamu ambelele elingeloi, mi sebeli omukwata. ");
INSERT INTO lyn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kono kasi kulangananga naye konji aba ana kuleya omwana no ndumbana, mi sebeli omutumba elitina lya Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesu abana kuleiwa mu mulenen̄i no Betelehema mu tolopo no Judeya, mu nako no mbumu Heloda. Ba nako eyo alume anjili no kushangama naku upa sebeli aiya mu Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Cwale sebeli aibanguta nji, “Kubine ali woyo ona leiwa ombumu no Majuda? Natu mono olutungweti lwaye aba lunapi ku upa, mi natwiyi nji tumu kubamene.” ");
INSERT INTO lyn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cwale mbumu Heloda aba ana kuyupa ngeeso, sebeli otina onene, bamweya naanu onje na mu Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Cwale sebeli oisana akulu no apulisita na iyeti no mulawo, sebeli waa ibanguta nji, “Kubine oko afanena oku leyelwa woyo Kilesite?” ");
INSERT INTO lyn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sebeli atambula nji, “Mu mulenen̄i no Betelehema mu Judeya,” kakuli yokame ina kun̄oliwa kwa munuhi wa Nyambe nji, ");
INSERT INTO lyn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kono wene Betelehema mu naha ya Juda, kame ukwite outokwa mukaci no titolopo ta Juda, kakuli mukaci no tolopo yowe mbaku tundu omubusi woyo so lisa aanu ange namu Isilaele.’ ");
INSERT INTO lyn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Cwale Heloda sebeli oisana alume no kushangama ku mukunda ni kwaibanguta enako luna kumonahala oweli olutungweti. ");
INSERT INTO lyn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mi sebeli waa tuma ku Betelehema nji, “Mute muka saisise wino woyo olukeke. Mi aba sa mumuwane munisimwete nji ni mene nite nika mukubamene.” ");
INSERT INTO lyn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Cwale aba ana kuyupa oku tundelela kwa mbumu, sebeli akutela endila yoo, mi olutungweti olo ana kumono ku upa sebeli lwaa enda ku lubala konji aba luna kwimana ba sibaka aba ana kwikala olukeke. ");
INSERT INTO lyn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Aba ana kumona olutungweti, sebeli awabelelwa onene. ");
INSERT INTO lyn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aba ana kwingena mu ndoo, sebeli amona olukeke ni inawaye Maliya, mi sebeli akubama banji ni kumulapela. Cwale sebeli ayatulula mu mikotana yoo ni kutundisamo etituwelo no Gauda, incense ni Mala. ");
INSERT INTO lyn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Munyima no kulemusiwa kwa Nyambe mu tolo nji alese oku ukela kwa Heloda, sebeli auka ku litunga lyoo oukutusisa endila indina. ");
INSERT INTO lyn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aba ana mana okuta ano kushangama, ababo elingeloi lya Mbumu sebeli limonahala kwa Josefa mu kulota. Mi sebeli lyamba nji, “Inguka! Olonde olukeke ni inawaye, oshotokele ku Egepita mi okaikalako konji abasa ni kwambele nji uuke kakuli Heloda mba saele olukeke nji alwibae.” ");
INSERT INTO lyn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josefa sebeli oinguka ni kulonda olukeke ni inawaye mu nako no usiku ni kushotokela ku Egepita. ");
INSERT INTO lyn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Sebeli aka ikalakoko okubitela abo ana kufela Heloda. Eyi yonje nai kutendahala okwiyateteta eyo ina kwambiwa kwa Mbumu, kutundelela kwa munuhi wa Nyambe nji, “Inaisana mwanange no mulume, okutunda mu Egepita.” ");
INSERT INTO lyn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cwale Heloda aba ana kulemuha nji ano kushangama na moongo, sebeli otina onene. Mi sebeli otuma aanu nji aibae anuke no andumana onje mu Betelehema mane sebeli aibaa naana no awo ana kwikalanga noo awo ana kukeela ba myaka yiili okutwala kunji, okukon̄elela omo ana kuyupela kwawo no kushangama enako luna kumonahala olutungweti. ");
INSERT INTO lyn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mu ndila eyi yakwiyateteta kale eyo ana kwamba omunuhi wa Nyambe Jelemiya nji, ");
INSERT INTO lyn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Esitumena sebeli siyupahala mu Lama, okulila ni kutenda esililo sinene. Lahele yo lilela anaye, mi ni mukana okumu omba-omba, kakuli anaye naafu.” ");
INSERT INTO lyn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Munyima no kufa kwa Heloda, ababo elingeloi lya Mbumu sebeli liku monahaza kwa Josefa ku tulo mu Egepita ");
INSERT INTO lyn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ni kwamba nji, “Inguka, oshimbe omwana ni inawaye, muukele ku litunga no Isilaele, kakuli awo ana saelanga okwibaa olukeke naafi.” ");
INSERT INTO lyn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Cwale sebeli oinguka, ni kushimba olukeke ni inawaye, ni kuukela ku litunga no Isilaele. ");
INSERT INTO lyn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kono Josefa aba ana kuyupa nji Akelausi nashwana sitaye Heloda okutenda ombumu no Judeya, sebeli ocila okutako. Mulibaka no kubiwa emamela ku tulo, sebeli ota mu sikiliti no Galileya. ");
INSERT INTO lyn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Sebeli okayoya mu sibaka siisaniwa Nazaleta, abonji kwiyatetetwe eyo ana kwamba asikunuha a Nyambe nji, “Mbaisaniwa omunazaleta.” ");
INSERT INTO lyn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ba nako eyo Jowani omukolobezi sebeli ota mu lihalaupa no Judeya yo kutaza eliywi yo amba nji, ");
INSERT INTO lyn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mubake kakuli omubuso na kuwilu sebeli oli beebi!” ");
INSERT INTO lyn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Uyu yokame woyo ona kwambiwa kwa munuhi wa Nyambe Isaya nji, “Eliywi no munjili kame liisana mu lihalaupa, ‘Mulukise endila ya mbumu, mutende endila no koloka yaye!’ ” ");
INSERT INTO lyn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Eikumango ya Jowani kame ina kutendiwa ba woya no tikamele, mane kame ana kwikalanga ni lukanda no situmba yo tingile mu mbunda yaye, Eilya yaye neli timbimba ni uki namu mushitu. ");
INSERT INTO lyn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Elikwanamunu sebeli liiya kwa yonyene okutunda mu Jelusalema ni mu Judeya, mane ni mwibaka yonje ikubapile ni musindi no Jodani. ");
INSERT INTO lyn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Oukwaamba ouyi woo, mi sebeli wakolobeza mu musindi wisaniwa Jodani. ");
INSERT INTO lyn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kono aba ana kumona ano kupula no Afalisi na Saduki aiya kwa yonyene nji aakolobeze, sebeli wamba kwa onyene nji, “Anyi aana no tinyoka! Anyine ona kumyambela nji mushotoke okutweba kwa Nyambe oku sakwiiye? ");
INSERT INTO lyn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cwalehe mutende einu eyi imonisa okubaka ku uyi wenu. ");
INSERT INTO lyn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mi mulese oku nahana nji kame samu yoyisiwe mukwamba nji kame muli ni Abulahama kanyi sitenu. Kame ni myambela nji Nyambe kame atwesa okufutula amawee aa okwatenda anaye Abulahama! ");
INSERT INTO lyn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Esamu kame silukisitwe ni kutatelela okupatula emibisi no sitondo, cwale nji esitondo sonje no kwabeeka embuya no kuwaba, mbasi patuliwa ni kukondelwa mu mulilo. ");
INSERT INTO lyn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kame ni mi kolobeza ni meyi okumonisa nji namu baka, kono munyima yange mba kwiiyi woyo okwite amaata okubita mene nji mane simba etikwele no tinjatangwa taye kani fanene okutinungutula mbami kolobeze ni Mebo No Kukena mane ni mulilo. ");
INSERT INTO lyn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Enumbi yaye kame ili mu maoko aye mi mba fiyele esibaka saye abo ana fulele oubeke waye mi mba waneke ouloto mu sishete ni kucin̄a omuuku ni mulilo no kwatima.” ");
INSERT INTO lyn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ba nako eyo Jesu sebeli oiya okutunda mu tolopo ya Galileya okwiiya ku musindi wa Jodani okwiiya muku kolobeziwa kwa Jowani. ");
INSERT INTO lyn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kono Jowani sebeli weteka okukana nji, “Iikene aba wiiya kwa mene nji ni ku kolobeze? Time nifanena okwiya kwa wene!” ");
INSERT INTO lyn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kono Jesu sebeli otambula nji, “Kutendiwe yongeso ba nako ino. Bakutenda ngeeso bokame satwiyatetetwe okuluka konje.” Cwale Jowani sebeli opumena. ");
INSERT INTO lyn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ababo Jesu aba ana kumana okukolobeziwa, sebeli otunda mu meyi. Cwale eliwilu sebeli liyatuluka, mi sebeli omona Emebo ya Nyambe eishetumuka musibumbiwa no Nkwilimba ni kumwikala. ");
INSERT INTO lyn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Cwale eliywii sebeli liyupahala okutunda kuwilu okwamba nji, “Uyu yo mwanage woyo ni singa, kwa yonyene kame niwabelwa.” ");
INSERT INTO lyn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Cwale Emebo ya Nyambe sebeli itwaletela Jesu mu lihalaupa mukwetekiwa kwa Diyabulosi. ");
INSERT INTO lyn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Munyima no ukuyumena eilya mu maywaa no kukwana makumi anee ni usiku no kukwana makumi anee, Jesu sebeli oyomba. ");
INSERT INTO lyn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Cwale omweteki sebeli oiya kwa yonyene ni kumwambela nji, “Nji kame uli mwanaye Nyambe, wambele amawee aa nji atende esinkwa.” ");
INSERT INTO lyn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kono Jesu sebeli otambula nji, “Nakuku n̄oliwa mu man̄olo nji, ‘Omunu katamba okuyoya kweyo no kulya fela, kono ku liywi lyonje eli litunda mu kanwa ka Nyambe.’ ” ");
INSERT INTO lyn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Cwale Diyabulozi sebeli omutwala mu Jelusalema, omulenen̄i no kukena, nuka mutuleka ba mongola no Ndoo ya Nyambe, ");
INSERT INTO lyn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ni kwamba kwa yonyene nji, “Nji kame uli mwanaye Nyambe, omatukele banji. Nakuku n̄oliwa mu man̄olo nji, ‘Mba laele amangeloi aye mulibaka lyowe, nji akwakele mu maoko oo, nji simba amakondo owe alese oukulemeka ku mawee.’” ");
INSERT INTO lyn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Cwale Jesu sebeli omutambula nji, “Nakuku n̄oliwa mu man̄olo kame nji, ‘Ulese okweteka Mbumu Nyambe wowe.’ ” ");
INSERT INTO lyn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kame Diyabulozi sebeli omutwala ba lilundu no kuleba nukamumonisa emibuso no litunga yonje ni uwa walyo, ");
INSERT INTO lyn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","sebeli omwambela nji, “Eyi yonje mbani kubi, nji uni kubamena niku nilapela.” ");
INSERT INTO lyn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Cwale Jesu sebeli otambula nji, “Otunde kwa mene Satani, naku kun̄oliwa mu man̄olo nji, ‘Olapele Mbumu Nyambe wowe mi obelekele yonyene feela!’ ” ");
INSERT INTO lyn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Cwale Diyabulosi sebeli omusiya, mi amangeloi sebeli aiya muku mutusa. ");
INSERT INTO lyn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cwale Jesu aba ana kuyupa nji Jowani nabekiwa mu mutolongo, sebeli oukela mu tolopo no Galileya. ");
INSERT INTO lyn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jesu sebeli otunda mu Nazaleta, nukayaka mu kapenauma omundi oli ku munanga no lisa lya Galileya mwikiliti ya Zebuloni ni Nafetali. ");
INSERT INTO lyn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nakutenda ngeeso okwiyateteta eso sina kwambiwa kwa munuhi wa Nyambe Isaya nji, ");
INSERT INTO lyn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Wene esikiliti no Zebuloni ni Nafetali, mu ndila no liwate, mu linjaliya lya Jodani, Galileya, woyo no asimacaba! ");
INSERT INTO lyn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Aanu awo ayoya mu uwi na mono eliseli linene. Naawo ayoya mu naha no mwinda no lufu, eliseli na limonahala kwa onyene.” ");
INSERT INTO lyn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kutunda eyo nako Jesu sebeli otateka okukutaza nji, “Mubake, kakuli omubuso na kuwilu sebeli uli beebi.” ");
INSERT INTO lyn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Abo Jesu aba ana kwendanga kunyonga no Liwate no Galileya, sebeli omona alume ayiili Simoni woyo wisaniwa nji Pitolosi ni minaye Andiliasi. Kame ana lemanga oku kondela otunyandi too mu Lisa kakuli neli andui. ");
INSERT INTO lyn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesu sebeli wamba nji, “Komwiye muni kon̄e mi mbani mitende ayambi no aanu.” ");
INSERT INTO lyn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ababo sebeli asiya otunyandi too ni kumu kon̄a. ");
INSERT INTO lyn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Cwale aba ana kusheteta ku lubala, sebeli omona Jakobo ni minaye Jowani aana a Zebedeya. Aikalile mu wato alemine okulukisa otunyandi too, mi sebeli waa isana. ");
INSERT INTO lyn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Cwale ababo sebeli asiya owato ni sitoo okumu kon̄a. ");
INSERT INTO lyn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesu sebeli ota mu Galileya monje, yo lemine okusimweta mu tindoo no milapelo ni kupaka eyi no ebangeli no kuwaba eyi no mubuso. Mane kame ana kubalisa aanu ku meeti oo onje. ");
INSERT INTO lyn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Elibubo lyaye sebeli liyupahala mu ibaka yonje no Siliya, mi aanu sebeli alita kwa yonyene awo onje ana kutomanga ameeti no kusiyana, awo ana kwikalanga ni madimona, oweeti no kukwa ni awo no kombola etinyutu mi sebeli waa balisa. ");
INSERT INTO lyn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Eli kwanamunu eli lina kutunda, mu Galileya, mu Dakapolisi, mu Jelusalema, mu Judeya ni mu naha na mulinjaliya lya Jodani sebeli amukon̄a. ");
INSERT INTO lyn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cwale Jesu aba ana kumona elikwanamunu elimukon̄a, sebeli ota ba lilundu nuukekala banji, aiyetwa aye sebeli aiya kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ababo sebeli otateka okwa iyeta. ");
INSERT INTO lyn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Embuyoti ni yaawo ashebile mu micima, kakuli omubuso na kuwilu ni woo. ");
INSERT INTO lyn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Embuyoti ni yaawo alila, kakuli mba ombaombiwa. ");
INSERT INTO lyn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Embuyoti ni yaawo aa sikukushuwa kakuli mba yoola elitunga. ");
INSERT INTO lyn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Embuyoti ni yaawo afile elishebo nawo afile elinyotwa no kuluka, kakuli mba ikuta. ");
INSERT INTO lyn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Embuyoti ni yaawo ali ni sishemo kakuli mba shemubiwa. ");
INSERT INTO lyn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Embuyoyi ni yaawo akenine mu micima kakuli mba ka mono Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Embuyoti ni yaawo alita ekozo, kakuli mba isaniwa aana a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Embuyoti ni yaawo a yandisiwa mulibaka no kuluka, kakuli omubuso naku wilu ni woo. ");
INSERT INTO lyn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Emboyoti ni yenu aba mwangoliwa, muyandisiwa ni ku minungelela eyi no mapwa neyi no kwiiba mu mifuta yayo yonje mulibaka lyange. ");
INSERT INTO lyn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muwabelwe mi munyakalale, kakuli omupuzo munene niwenu ku wilu. Mundila imweya ana kuyandisa anuhi a Nyambe awo ana kwikalako ba weli. ");
INSERT INTO lyn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kame muli omungwa no litunga. Kono nji omungwa nau amuba, ngasibine sau usetwe nji umamate kame? Kau kwite tuso konji abasau yumbiwe feela banji mi aanu alyatebo. ");
INSERT INTO lyn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kame muli eliseli no litunga. Omulenen̄i ou uyakilwe ba lilundu kau kwangwa okumonahala. ");
INSERT INTO lyn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kakwisa omunu otumbula elambi ni kwibeeka munji no tubana. Abo cwale kame saibeeke ba lutala lwayo nji ilite eliseli kwaanu onje ali mu ndoo. ");
INSERT INTO lyn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mundila imweya mulesele eliseli lyenu limonyeke kwa kwenu, nji amone ouwa mutenda mi akanyise sitenu na kuwilu. ");
INSERT INTO lyn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mulese oku yambuta nji kame ninaiyi muku kandakanda emilawo ya Mushe simba etuto no anuhi a Nyambe. Kani siiya mukwa kandakanda kono muku iyateteta. ");
INSERT INTO lyn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Niti luli kame nimyambela nji, simba esipeleta sicana no mulawo mbasi iyatetetwe mi kaitamba kusinyeha eliwilu ni litunga ekayasibwa kale. ");
INSERT INTO lyn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Abo cwale woyo yonje socola einjili kweeti etitaelo ni kwiyeta akwaye okutenda ngeeso mba tendiwa munyonyo mu mubuso naku wilu. Kono woyo yonje okuteka etitaelo ni ku simweta akwaye okutenda ngeeso mba tendiwa no kuneneba mu mubuso na kuwilu. ");
INSERT INTO lyn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kame ni myambela nji, okuluka kwenu kame ku fanena okubita okuluka no aiyeti no mulawo na Falisi, nji kasa ngeeso ka mutamba kwingena mu mubuso na kuwilu. ");
INSERT INTO lyn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Na muyupu nji nai kwambiwa kwanu naku kale nji, ‘Ule kwibaa mi woyo oibaa mba fanene okwatuliwa. ");
INSERT INTO lyn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kono kame nimyambela nji omunu kame atinena omukwaye, mba tuliwa. Nji omunu kame angula omukwaye “Wene omwelo!” mba atuliwa mu kuta ni kuyumbeliwa mu mulilo no lihele. ");
INSERT INTO lyn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Cwalehe aba ulita empo yowe ba aletale, mi wapuluka kale nji nu foseze omukowe, ");
INSERT INTO lyn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","usiye empo yowe ba lubala no aletale, mi uuke oweli muka kuuse ni mukowe. Cwale wiye obeeke empo yowe. ");
INSERT INTO lyn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nji omunu kame asinga oku kutwala ku kuta mukwambote ababo anyi musili mu ndila. Nji kamutende ngeseo mbaku beeke mu maoko no mwatuli mi yonyene aka kubeeke mu maoko no mupolisa woyo ofanena okuku yumbela mu tolongo. ");
INSERT INTO lyn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Luli kame ni myambela nji, kutamba kutundamo konji aba sautenekele omubonda wowe no mamaneneno. ");
INSERT INTO lyn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Na muyupu naku kwambiwa nji, ‘Mule kutenda owozwa.’ ");
INSERT INTO lyn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kono kame ni myambela nji, omunu yonje woyo waliketa omukati niku mulakaza natende owozwa naye mu mucima waye. ");
INSERT INTO lyn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Cwale nji elitiyo lyowe no silyo kame likutendisa ouyi oli tundise ni kuliyumbela oku no kuleba. Mba kwikala wino nji utaukelwe esilama simweya no lutu lowe, kasa nji olutu lowe lonje lukayumbeliwe mu lihele. ");
INSERT INTO lyn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Cwale nji elyoko lyowe no silyo kame likutendisa ouyi oli patuleko ni kuliyumbela oku no kuleba. Mba kwikala wino nji utaukelwe esilama simweya kasa nji olutu lowe lonje lukabeekiwe mu lihele. ");
INSERT INTO lyn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Naku kwambiwa nji, ‘Omulume yonje woyo olukulula omukataye kame afanena okumun̄olela elin̄olo no tukuluho.’ ");
INSERT INTO lyn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kono kame ni myambela nji, cwale nji omulume kame alukulula omukataye mulibaka no mubonda mundina kasa ou no wozwa, kame ali ni mubonda ou nokumulitela nji atende omubonda no wozwa, mi omulume woyo okwata omukati woyo ona lukululwa, kame atenda owozwa. ");
INSERT INTO lyn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Namuyupu kame nji aanu nakwambeliwa kunyima nji, ‘Mulese kucola oukwamanyinga wenu, kono mwiyatetete oukwamanyinga wenu ou mutenda kwa Mbumu.’ ");
INSERT INTO lyn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kono bano kame nimyambela nji, mule oukutusisa oukwamanyinga aba mutenda etisepiso tonje. Mule okweeta neyi no liwilu kakuli ni lubona lwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mi kame mule okweeta neyi no litunga kakuli ni sibaka aba lyatile amakondo aye, mi kame mule okweeta neyi no Jelusalema kakuli ni mulenen̄i ou no Mbumu munene. ");
INSERT INTO lyn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mule kweeta simba eyi no mutwi wenu kakuli kamutwese okufutula etin̄uki tenu nji titende etino likena simba etino wiilu. ");
INSERT INTO lyn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mwambe felea eeni nji kame mutalusa ‘Eeni’ simba ‘Kokuulwa’ aba mutalusa kokuulwa kakuli aba mubitelela okwamba eyo kame itunda kwa woyo no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Namu yupu nji, naku kwambiwa nji, ‘Elitiyo ku litiyo, elyeo ku lyeo.’ ");
INSERT INTO lyn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kono bano kame ni myambela nji, mulese okulwisa omunu woyo ona mitende ouyi. Kono nji omunu naku bakula olubaka ku litama no silyo omube abakule kame neli no simoo. ");
INSERT INTO lyn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mi nji omunu kame akutwala ku kuta nji ashimbe ehembe, omulese ashimbe ni baki yonje. ");
INSERT INTO lyn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Cwale nji omunu kame aku kandimeka okushimba omushimbo waye esibima simweya, wene omushimbele eibima yiili. ");
INSERT INTO lyn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Cwale omunu aba aku kumbela esinu, omubeso, nji omunu kame asinga oku kalima esinu kwa wene, omukalimise. ");
INSERT INTO lyn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Namu yupu nji nai kwambiwa nji, ‘Osinge alikani owe, mi otimbe eila yowe.’ ");
INSERT INTO lyn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kono bano kame nimyambela nji, ‘Osinge eila yowe mi olapelele awo alemine oukuyandisa. ");
INSERT INTO lyn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Aba utenda ngeeso mbutende mwanaye sitowe naku wilu, kakuli eliywaa lyaye kame libenya ku munu no kwiiba ni woyo no kuwaba, ombula waye kame aloka kwawo no kwiiba ni kwawo no kuwaba. ");
INSERT INTO lyn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Iikene eyo samubelwe omupuzo nji kame musinga felea awo amisinga? Na telisi kame atendanga yongeso! ");
INSERT INTO lyn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Cwale nji kame utambula alikani owe feela, kubine obitela akowe? Asimacaba mwatendela yongeso! ");
INSERT INTO lyn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kame mufanena okutenda ano kupetahala kanyi sitenu naku wilu aba atendile woyo no kupetahala. ");
INSERT INTO lyn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mumamele! Aba mutenda einu no kuwaba mulese ouku monisa kwaanu nji amone eyi mutenda. Aba mutenda ngeeso kamutamba kubiwa omupuzo kwa sitenu naku wilu. ");
INSERT INTO lyn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Cwale aba muba kwawo aulwile mulese ouku monisa nji nubi kanyi omo atendela asikukuba mu tindoo no milapelo nimu tindila nji abubekwe kwaanu. Niti luli kame nimyambela nji, atambula kale omupuzo woo. ");
INSERT INTO lyn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kono cwale aba muba kwawo aulwile mumone nji elikaa lyenu no simoo lilese okulimuka eyi litenda elikaa lyenu no silyo. ");
INSERT INTO lyn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Cwale nji okuba kwenu kutende naku mukunda, cwale abo sitenu woyo omwine eyi itendahala ku mukunda mba mibi omupuzo. ");
INSERT INTO lyn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Cwale aba mulapela mule kutenda kanyi omo atendela asikukuba kakuli kame asinga okwimana mu tindoo no milapelo ni mu tindila okulapela nji amoniwe kwaanu. Niti luli kame ni myambela nji atambula kale omupuzo woo. ");
INSERT INTO lyn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kono aba mulapela mwingene ku muzuzu ni kuyatilako esaandi cwale mulapele kwa Sitenu woyo oli kumukunda, woyo omwine eyi itendahala ku mukunda mba mibi omupuzo. ");
INSERT INTO lyn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Mi aba mulapela mulese okwamba amaywi no kupula no kwayupahala kanyi omo atendela aanu no kwalimuka Nyambe, kakuli kame ayabuta nji okubinda sayupiwe aba amba amaywi no kupula. ");
INSERT INTO lyn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mulese okwaafeka kakuli Sitenu kame limukile eyi musaela anyi akamwa simukumbela kale. ");
INSERT INTO lyn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Cwale kame mufanena okulapela ngeesi, ‘Sitetu naku wilu, kulumbiwe elitina lyenu ");
INSERT INTO lyn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","kwiiye omubuso wenu, esi sisaeliwa kwa wene sitediwe banji, kanyi omo sitendeliwa kuwilu. ");
INSERT INTO lyn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Otube balelo esilyanu setu eso tusaela, ");
INSERT INTO lyn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Otulemene emibonda yetu, kanyi omo tulemenanga awo sikutu foseza. ");
INSERT INTO lyn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ole kutu ingenyeka mu miliko, kono utulamulele kwa woyo no kwiiba.’ ");
INSERT INTO lyn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Cwale nji kame mulemena akwenu kweyo no kwiiba ana mitende ni sitenu naku wilu mba milemene. ");
INSERT INTO lyn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kono nji kamulemene akwenu, ni sitenu naku wilu katamba kumi lemena ouyi wenu. ");
INSERT INTO lyn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Cwale aba muku yumena eyi no kulya, mulese okusosobanisa mul ubala lwenu, kanyi omo atendela asikukuba. Kame amonisa nji kame ayandile nji alimukiwe nji kame ali bouku yumena eilya. Niti luli kame ni myambela nji atambula kale omupuzo woo. ");
INSERT INTO lyn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Cwale aba muku yumena eyi no kulya mukuyowe kulubala, mushakule etin̄uki tenu, ");
INSERT INTO lyn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","nji akwenu alese okulimuka nji kame muku yumena eyi no kulya, konji sitenu woyo oli nenu ku mukunda. Mi sitenu woyo omwine eyi itendahala ku mukunda mba mibi omupuzo. ");
INSERT INTO lyn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mulese okuungekela oufumu na muno mu litunga kakuli outwa mane ni mafumi kame itwesa oku usinya, mane bamweya ni ambuyi kame atwesa okucuula etindoo ni kwiita. ");
INSERT INTO lyn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kono cwale mu kuungekele oufumu na mu wilu oko outwa ni mafumi kaitwese oku usinya, mane nambuyi katwese oku cuula etindoo ni kwiita. ");
INSERT INTO lyn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kame nimyambela eyi, kakuli oko kuli oufumu wenu ni micima yenu kosa ikaikale. ");
INSERT INTO lyn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Amiyo kame fekile kanyi elambi no lutu, nji amiyo owe kame amona wino, olutu lowe mba lwikala mu liseli lonje. ");
INSERT INTO lyn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kono nji amiyo owe kamono wino, olutu lowe lonje mba lwiyala ouwi. Mi nji eliseli mwa wene ni uwi, babine saukume ouwi mwa wene? ");
INSERT INTO lyn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kakwisa woyo otwesa oku belekela ambumu ayiili, kakuli mba timbibo mumweya mbasingi omunjili. Mba sepehala ku mumweya mi mba shwaula omunjili. Kautwese oku belekela Nyambe ni mali. ");
INSERT INTO lyn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Cwale abo kame nimyambela nji, mulese okubilaela neyo no kuyoya kwenu, simba eyisa mulye neyisa munwe, simba eyi no lutu lwenu eyisa mukumange. Kasanji okuyoya ni kwautokwa onene okubita esilya, simba olutu ni lwautokwa onene okubita eyi kumango nji? ");
INSERT INTO lyn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kamumone otuyuni otu tutuka mu wilu katu limi, katu yangula mi katu teula mu ishete simba mu ituli kono sitenu naku wilu kame atu babalela. Kasanji kame muli ni tuso okubita otuyunyi? ");
INSERT INTO lyn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Cwale mukaci kenu kwaali woyo sotwesa okubeeka ehola imweya kukuyoya kwaye mukubilaela? ");
INSERT INTO lyn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Cwale iikene aba mubilaela neyi no kukumanga? Kamumone etipalisa na mu mushitu omo tikulela. Kati beleke simba okutenda eikumango tonyene. ");
INSERT INTO lyn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kono kame ni myambela nji simba yonyene Solomoni ona kufuma onene mu umbumu waye kakwite eikumango no kuwaba kanyi eyinjili no tipalisa. ");
INSERT INTO lyn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nyambe yotwesa okufuka ngeeso omoopu na mu musitu, omoopu uliko balelo, byunda wakukuta kale ni kuuyumbela mu mulilo. Kandi katwese okumifuka ngeeo naanyi mane ni kubitelela? Kandi ngasibine omo icanibele etumelo yenu! ");
INSERT INTO lyn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Abo cwale mulese okubilaela okwamba nji, ‘Iikene satulye ni eyo satunwe neyi satu kumange. ");
INSERT INTO lyn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kame namba ngeseo kakuli awo nokwa limuka Nyambe yasaela eyi yonje, mi sitenu naku wilu kame alimukile nji kame musaela inu eyi yonje. ");
INSERT INTO lyn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Oweli musaele eyi no mubuso wa Nyambe ni kuluka kwawo, cwale eyi yonje mba mwiibiwi. ");
INSERT INTO lyn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Cwale abo mulesele okubilaela eyi no byunda, kakuli eyi no byunda mba iiyi ni tipilaelo tayo. Eliywaa ni liywaa kame lili ni ubamba walyo. ");
INSERT INTO lyn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mulese okwatula akwenu nji, nanyi mulese okwatuliwa, ");
INSERT INTO lyn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mundila imweya aba mwatula akwenu naanyi mba mwatuliwa, mi owiima mukutusisa kwa kwenu mba ikutusisiwa kwaanyi. ");
INSERT INTO lyn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Cwale iikene aba waliketa esopu sili mu litiyo lya mwabowe, kono kame ukwangwa okumona omusumo uli mu litiyo lyowe? ");
INSERT INTO lyn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ngasibine wambela omwabowe nji ‘Kotumone ni kutundise esopu sili mu litiyo lyowe,’ kono enako yonje mu litiyo lyowe kame kuli omusumo. ");
INSERT INTO lyn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wene osikukuba, oweli otundise omusumo oli mu litiyo lyowe, okubinda so mone wino mane ni kutundisa esopu sili mu litiyo lya mwabowe. ");
INSERT INTO lyn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mulese okuba einu no kukena kwaambwa tamba auka ni kumyuuma, mi mule kuyumbela einu yenu no utokwa ku tingulube tamba tiilyatingela feela. ");
INSERT INTO lyn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mukumbele mi mba mubiwi, musaele mi mba muwana mi mungongote omwelo mbau yatuluka kwaanyi. ");
INSERT INTO lyn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Omunu yonje woyo okumbela mba biwi, woyo osaela mba wana, kwa woyo ongongota omwelo mbau yatuleliwa. ");
INSERT INTO lyn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Anyine mukaci kenu woyo otwesa okuba mwanaye eliwee aba amukumbela esinkwa? ");
INSERT INTO lyn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Simba oku muba enyoka aba akumbela ondi? ");
INSERT INTO lyn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Cwale nji anyi no kwiiba mulimukile okuba anenu einu no kuwaba, ngasibine onene cwale eyi no kuwaba saabe sitenu nakuwilu kwawo amu kumbela? ");
INSERT INTO lyn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mu inu yonje, mutende akwenu eyo musinga nji amitendele naanyi, kakuli eyi etaluso no mulawo wa Mushe mane ni tuto no anuhi a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mwingenene mu mwelo no kukumbana onene, kakuli omwelo simba endila eyi itwala kukusinyeha niya kuyatuluka, mi anokupula wa ingenenanga. ");
INSERT INTO lyn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kono omwelo ou utwala kukuyoya ni wakukumbana, mi endila itako ni yakubambaba mi niacana aiwana. ");
INSERT INTO lyn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mutokomele asikunuha no mapwa. Kame aiya kwaanyi akuyawekile mu situmba no mukoko kono mukaci kame atendile amaakanyani. ");
INSERT INTO lyn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mbamwa limukele kweyo atenda. Omukona kaubeeke embuya no beine mi omukona kaubeeke etifenega. ");
INSERT INTO lyn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mu ndila imweya, esitondo no kuwaba kame sibeekanga embuya no kuwaba kono esino kwiiba kame sibeekanga embuya no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Esitondo no kuwaba kasitwese okubeeka embuya no kwiiba mi ni sitondo no kwiiba kasitwese okubeeka embuya no kuwaba. ");
INSERT INTO lyn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Esitondo sonje nji kasibeeke embuya no kuwaba kame sipatuliwa ni kuyumbeliwa mu mulilo. ");
INSERT INTO lyn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Abo cwale anuhi no mapwa mbamwa limukele ku mbuya yoo. ");
INSERT INTO lyn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kasa omunu yonje woyo wamba kwa mene nji, ‘Mbumu, Mbumu’ nji yoso ingena mu mubuso na kuwilu, kono konji feela awo atenda etato ya sitange na kuwilu. ");
INSERT INTO lyn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ba liywaa no katulo aanu no kupula mbaamba kwa mene nji, ‘Mbumu, Mbumu’ katwasiku nuhanga mu litina lyowe, mi katwa sikutundisanga amandimona mu litina lyowe, ni kutendanga etimakazo no kupula-pula? ");
INSERT INTO lyn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Cwale mbanaambele epatalaza nji, ‘Kanimi limukile mutunde kwa mene, anyi asikutenda ouyi!’ ");
INSERT INTO lyn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Cwale abo omunu yonje woyo oyupa amaywi ange ni kwamamela, kame akufekile kanyi omuyaki no kushangama ona kuyaka endoo yaye ba liwee. ");
INSERT INTO lyn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Abana kwiiya ombula sebeli oloka mi emisindi sebeli iiyala ameyi, mi emebo sebeli efuka onene ni kukafula abo ba ndoo, kono kayasikwa kakuli kame ina kusumiwa ba liwee. ");
INSERT INTO lyn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Kono omunu yonje woyo oyupa amaywi ange mi kaamamele, kame akufekile kanyi omuyaki no kweluba woyo ona kuyaka endoo yaye ba lipumasheke. ");
INSERT INTO lyn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Cwale ombula sebeli oloka emisindi sebeli iiyala mi emebo sebeli efuka onene ni kukafula ba ndoo mi sebeli ikwa ni kusinyeha onene!” ");
INSERT INTO lyn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cwale Jesu aba ana kumana okwamba ngeeso amaywi aa, enyangela sebeli ikomoka ekutazo yaye, ");
INSERT INTO lyn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kakuli kame ana kwaiyetanga kanyi woyo oli ni maata, kasa kanyi aiyeti no mulawo. ");
INSERT INTO lyn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cwale Jesu aba ana shetumukanga okutunda ba lilundu, enyangela sebeli imukon̄a. ");
INSERT INTO lyn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Omulume ona kutomanga embingwa, sebeli oiya ni kukubama kwa yonyene ni kwamba nji, “Mbumu nji usinga kamotwesa okuni balisa.” ");
INSERT INTO lyn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesu sebeli oolola elyoko lyaye ni kumulema ni kwamba nji, “Nisinga, woombole.” Mi ababo sebeli obalisiwa ku mbingwa yaye. ");
INSERT INTO lyn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Cwale Jesu sebeli wamba kwa yonyene nji, “Omone nji kautamba okwambela aanu. Kono ote oka kumonahaze kwa mupulisita mi okabe empo, eyo ana kwamba Mushe nji aanu apumene nji nubala.” ");
INSERT INTO lyn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Cwale Jesu aba ana kwingena mu Kapenama, omukulu no masole sebeli oiya kwa yonyene okukumbela etuso ni kwamba nji, ");
INSERT INTO lyn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Mbumu, omubika wange kame atoine oweti no lun̄an̄ali, kame alanganine feela ku mundi. ");
INSERT INTO lyn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesu sebeli omwambela nji, “Nikeyili nimubalise.” ");
INSERT INTO lyn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Cwale omukulu no masole sebeli otambula nji, “Mbumu kanifanene okukuisana nji wiye mu ndoo yange. Kono waambe eliywi feela mi omubika wange mbabala. ");
INSERT INTO lyn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kame nilimukile eyi kakuli ni mene kame nili omunu woyo oli munji no maata no akulu ange, mi kame nikwite amasole awo nilaelela, aba nambela omunu nji ote, kame ata. Ku munjili kame nji oiye, kamea iya. Aba nambela omubika wange nji otenda ngeesi mi kame atenda.” ");
INSERT INTO lyn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Cwale Jesu aba ana kuyupa ngeeso, sebeli okomoka mi sebeli wamba kwaanu ana mukon̄a nji, “Kame ni myambela nji, kana siwana kale omunu woyo okwite etumelo inene ngeesi muno mu Isilaele kanyi woyo. ");
INSERT INTO lyn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kame ni myambela nji ano kupula mba tundu ku upa ni ku wiko mi mba ikala bamweya ba mukiti ni Abulahama, Isaka ni Jakobo mu mubuso na kuwilu. ");
INSERT INTO lyn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kono kwaawo afanena okekala mu mubuso kame saka yumbelwe kundee ku uwi oko cwale sakukekale okulila ni kukweca amaeo.” ");
INSERT INTO lyn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Cwale Jesu sebeli wamba ku mukulu no masole nji, “Ote ku ndoo yowe, mi mbutendeliwa eyo upumena.” Mi ababo omubika waye sebeli obala. ");
INSERT INTO lyn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Cwale Jesu aba ana kwingena mu ndoo ya Pitolosi, sebeli owana njemunwaye Pitolosi no mukati yo langanine mu mumbeta yokola elitomaapa. ");
INSERT INTO lyn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesu sebeli omulema ku lyoko, ababo elitomaapa sebeli litunda, mi sebeli obala ni kwinguka oku mutendela eyi no kulya. ");
INSERT INTO lyn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mu nako no mangolwaa awo, aanu sebeli alita kwa Jesu anokupula asimandimona. Jesu sebeli otundisa emebo no kwiiba ni liywi ni kubalisa ana kukolanga oonje. ");
INSERT INTO lyn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Esi neli okwiyateteta eyo ina kwambiwa kwa munuhi wa Nyambe Isaya nji, “Nalondo amayando etu onje, ni meeti etu.” ");
INSERT INTO lyn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cwale Jesu aba ana kumona enyangela no aanu imutingulukile, sebeli olaela aiyetwa aye nji, “Mute mu linjaliya no liwate.” ");
INSERT INTO lyn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Cwale akasita kale omwiyeti no mulawo sebeli oiya kwa yonyene ni kwamba nji, “Mwiyeti, mba niku kon̄o konje soute.” ");
INSERT INTO lyn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu sebeli omutambula nji, “Aluwawa akwite emina mi otuyunyi tukwite eiyaleto, kono Omwana no munu kakwite simba aba sasame omutwi waye.” ");
INSERT INTO lyn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Omunjili omwiyetwa sebeli wamba nji, “Mbumu, mbani kukon̄o kono oweli nite ni kapumbeke sitange.” ");
INSERT INTO lyn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kono Jesu sebeli omutambula nji, “Muni kon̄e mi mulese aafu apumbeke aafu woo.” ");
INSERT INTO lyn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Cwale sebeli oingena mu sisepe na iyetwa aye sebele ata naye. ");
INSERT INTO lyn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ababo akatile sebeli kwiiya emebo no kunenenba ni mandinda sebeli atateka okwingena mu wato, kono Jesu kame nalangananga. ");
INSERT INTO lyn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aiyetwa sebeli ata kwa yonyene ni kumwingula nji, “Mbumu, otuyoyise kame tufa.” ");
INSERT INTO lyn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesu sebeli otambula nji, “Anyi asi tumelo icana, iikene aba mucila?” Cwale sebeli oinguka ni kukanena emebo ni mandinda mi sebeli koondoka onene. ");
INSERT INTO lyn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Aiyetwa aye sebeli akomoka onene mane ni kwamba nji, “Ngasibine aikalile woyo mulume? Simba emebo ni mandinda kame imu yupa!” ");
INSERT INTO lyn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mi cwale Jesu aba ana kukeela mu naha no Magadaleni mu linjaliya no lisa, sebeli okuwana nalume ayiili asi mandimona akatundelele ku mabita. Alume awo kame ana kwikalanga ni mandimona no kucilisa onene nji mane kakwisa simba omunu ona kubitanga endila eyo. ");
INSERT INTO lyn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ababo sebeli akuwa ni kwamba nji, Siikene usaela okutende kwaaci, weene mwana Nyambe? Ninji kame uneyi mukutu yandisa enako eya kasikwana kale? ");
INSERT INTO lyn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bakatamba minwe kame kuna kwikala etingulube no kupula etilemine okulya. ");
INSERT INTO lyn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Amandimona sebeli akumbela kwa Jesu nji, “Aba ututundisa utu citele muya mu tingulube.” ");
INSERT INTO lyn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesu sebeli wamba ku mandimona nji, “Kamute! Mi ababo isitunda feela sebeli ikengena mu tingulube. Munyima omulaka wonje sebeli oshetumuka oka kuyumbela mu liwate ni kufela mu meyi.” ");
INSERT INTO lyn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Alisana no tingulube sebeli aituka nikuta mu mulenen̄i, sebeli akambela aanu eyo ina tendahala yonje mane neyo yalume asimandimona. ");
INSERT INTO lyn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aanu namu mulenen̄i sebeli ata nuuka kuwana ni Jesu. Mi aba ana kumu mona sebeli amu kumbela nji atunde mu litunga lyoo. ");
INSERT INTO lyn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesu sebeli oingena mu wato ni kuta mu linjaliya mu mulenen̄i waye. ");
INSERT INTO lyn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Cwale aanu sebeli amulitela omulume onaku kukutela olun̄an̄ali, yo langanine ba museme. Jesu aba namona etumelo yoo, sebeli wamba kwa woyo no kukola nji, “Oongote omucima mwanange, eibi yowe na wilemenwe.” ");
INSERT INTO lyn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ababo aiyeti anjili no mulawo sebeli amba mu micima yoo nji, “Uyu mulume kame anyefula Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesu aba ana ku lemuha emihupulo yoo, sebeli wamba nji, “Anyi iikene munahanela emihupulo no kwiiba mu micima yenu?” ");
INSERT INTO lyn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sibine esi sotobile, ni kwamba nji, ‘Eibi yowe nai lemenwe,’ ni kwamba nji, ‘Wimane weende?’ ");
INSERT INTO lyn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mi cwale kame ni singa mu limuke nji Mwana no Munu kame ali ni tukelo bano banji noku lemena aanu eibi, ababo Jesu sebeli wambela omulume no kukutelanga olun̄an̄ali nji, “Imana olonde omuseme wowe ute ku mundi.” ");
INSERT INTO lyn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Woyo mulume sebeli oimana nuu kutela ku mundi waye. ");
INSERT INTO lyn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aanu no kupula aba ana kumona ngeeso sebeli acila, mi sebeli alumba Nyambe onabi kwaanu etukelo no ngeeso. ");
INSERT INTO lyn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Abo Jesu aba ana suweta okwenda, sebeli omona omulume no litina lya Mateu yo ikalile ba lubala no ndoo no mutelo. Sebeli wamba kwa yonyene, “Oni kon̄e” Ababo omulume sebeli oimana ni kumu kon̄a. ");
INSERT INTO lyn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ababo Jesu abana lyanga mu ndoo ya Mateu, atelisi no kupula na sikutenda eibi sebeli aingena ni kulya ni Jesu bamweya naa iyetwa aye. ");
INSERT INTO lyn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Afalisi aba ana kumona ngeeso, sebeli aibanguta aiyetwa aye nji, “Iikene omwiyeti wenu abalya naanu no ngeesi?” ");
INSERT INTO lyn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesu aba ana ku yupa ngeeso sebeli otambula nji, “Awo nokwa kolo kasaele onganga, kono onganga kame asaeliwa kwa asikukola. ");
INSERT INTO lyn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mute muka kwiyete eyo litalusa elin̄olo eli nji, ‘Kame ni singa esishemo kasa esitabelo no iyamana.’ Kana siiya mu kwisanena ano kuluka ku kubaka, kono asikutenda eibi.” ");
INSERT INTO lyn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Cwale aiyetwa a Jowani omukolobezi sebeli aiya kwa Jesu ni kwamba nji, “Aci na Afalisi kame tukuyumenanga eilya mu nako injili. Cwale ngasibine aiyetwa owe aba kaakuyumene eilya?” ");
INSERT INTO lyn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mi Jesu sebeli wamba kwa yonyene nji, “Ninji alikani no mukwati kame satwese okulila, omukwati yo sili kwa onyene? Kono eliywaa kame liiya, elyo omukwati aba sa tundisiwe kwa onyene. bokame abo saa kuyumene eilya.” ");
INSERT INTO lyn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ka kwisa omunu woyo so beeka esimanahani no ubya ba sikumango no kukulubala, kakuli esimanahani eso kame sasi kaule esikumango eso, kame sekeza abo no ku kauka.” ");
INSERT INTO lyn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kame aanu ka itele ewaine no ubya mu singumbuli no kupangiwa ba itumba no kale, kakuli eyitumba mbei kauka. Mi cwale ewaine mba iitekele banji, mi sonyene esingumbui no kupanga ba itumba mbasi kauka. Kono ewaine no ubya kame iitelwa mu singumbuli no kupanga ba itumba no ubya, mi einu yiili kame ibabalelwa. ");
INSERT INTO lyn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Cwale Jesu yosamba eyambo eyi, sebeli kukeela onduna nikumu kubamena nji, “Mwanange no mukatana okubinda afe abano, kono wiiye, mu ku beeka elyoko lyowe beulu yaye mi mba yoyo kame.” ");
INSERT INTO lyn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesu na iyetwa aye sebeli aimana ni kumu kon̄a. ");
INSERT INTO lyn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ababo omukati onaku katazeha ku weeti no mweeya emyaka no kukwana likumi ni yiili (12), sebeli oiya mu nyima ni kulema ku mungundo no mukanjo waye. ");
INSERT INTO lyn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Omukati sebeli okwambisa yonyene nji, “Aba sanileme feela ba mukanjo waye mbibala.” ");
INSERT INTO lyn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesu sebeli oku setuka, ni kumumona, mi sebeli wamba kwa yonyene nji, “Oongote omucima mwanange, etumelo yowe nai kuyoyisa.” Mi ababo ba nako eyo, omukati sebeli obala. ");
INSERT INTO lyn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cwale Jesu aba ana kwingena mu ndoo no nduna, sebeli omona aa alemine okupeta etipala, naanu no kupula alemine okulila onene, ");
INSERT INTO lyn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","sebeli waambela nji, “Komu tunde, kakuli omukatana ka sifa, kono kame alanganine feela.” Mi aanu sebeli a musheka. ");
INSERT INTO lyn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cwale ababo aanu aba ana kubanena bandee, sebeli oingena ni kumu lema ku lyooko, mi omukatana sebeli oinguka. ");
INSERT INTO lyn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Cwale etaba eyo ana kutenda Jesu sebeli ita elibubo mu naha yonje. ");
INSERT INTO lyn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesu aba nasiya esibaka eso, eibofu yiili sebeli imukon̄a eyikuwa nji, “Mwanaye Dabida otu yupele amakeke.” ");
INSERT INTO lyn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aba ana kwingena mu ndoo, eibofu eyo sebeli iiya kwa yonyene, mi Jesu sebeli oiibanguta nji, “Kame mupumena nji kame ni twesa okumi balisa?”Eibofu sebeli itambula nji, “Ee Mbumu.” ");
INSERT INTO lyn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Cwale Jesu sebeli walema ba miyo ni kwamba nji, “Ku tendwe okuta mu tumelo yenu!” ");
INSERT INTO lyn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mi amiyo oo sebeli amona. Cwale Jesu sebeli waa laela onene nji, “Mu mamele nji mulese okwamba etaba eyi kwaanu.” ");
INSERT INTO lyn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kono sebeli ata nu kambela aanu eyo ana tende mu naha yonje. ");
INSERT INTO lyn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cwale awo alume ayiili asita feela, aanu sebeli alita kwa Jesu omulume. Mi neli esimumu kakuli kame ana kwikalanga ni mebo no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ababo emebo no kwiiba aba ina kutundisiwa, omulume sebeli otangisa okwamba, mi aanu onje sebeli akomoka. Sebeli amba nji, “Katwa simona kale esinu kanyi esi mu Isilaele.” ");
INSERT INTO lyn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kono Afalisi sebeli amba nji, “Kame acita amadimona mu libaka no Mbumu no madimona.” ");
INSERT INTO lyn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Cwale Jesu sebeli ota yo enda mu milenen̄i ni mu mindi yonje. Sebeli oiyetanga aanu mu tindoo too no milapelo, yo amba eliywi no mubuso, yo lemine oku balisa aanu awo ana kwikalanga ni meeti onje. ");
INSERT INTO lyn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aba ana kumona aanu no kupula sebeli waa yupela amakeke, kakuli nakuyanda onene okuulwa etuso kanyi emikoko nambulwa omulisani ");
INSERT INTO lyn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ababo sebeli wambela aiyetwa aye nji, “Ekutulo niyaku neneba, kono asiku kutula acana. ");
INSERT INTO lyn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Cwale abo mu lapele kwa Mbumu no kutulo nji atume abeleki nji awaneke ekutulo yaye.” ");
INSERT INTO lyn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesu sebeli oisana aiyetwa aye, noku kwana likumi na yiili mi sebeli waaba amaata no kutundisa emebo no kwiiba, ni kubalisa ameeti onje. ");
INSERT INTO lyn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Cwale amatina no atumiwa noku kwana likumi nayiili (12) aa okame. Woyo no weli ni Simoni woyo isaniwa nji Pitolosi ni Adiliyasi minaye, Jakobo ni minaye Jowani anaye Zebediya, ");
INSERT INTO lyn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi ni Batolome, Tomasi ni Mateu no mutelisi, Jakobo omwana Alufeya, ni Tandeya. ");
INSERT INTO lyn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni Omukanana ni Judasi isikaliyota woyo ona kubeteka Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesu sebeli otuma ano kukwana likumi na yiili ni kwalaela nji, “Mulese kuta kwaa simacaba onje simba mu mindi ni milenen̄i no Masamaliya. ");
INSERT INTO lyn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kono mute kwaanu no Isilaele, akufekile kanyi emikoko no kutauka. ");
INSERT INTO lyn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mute mi mukakutaze nji, ‘Omubuso naku wilu sebeli oli beebi.’ ");
INSERT INTO lyn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mubalise asikutoma mi mwingule anokufa, mubalise asikutoma oweeti no mbingwa ni kutundisa amandimona. Namuku tambula okuulwa okuteneka, cwale naanyi mube nambulwa okutenekiwa. ");
INSERT INTO lyn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mulese ku shimba egauda, silibela simba amali outale mu tipokoto tenu. ");
INSERT INTO lyn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Cwale mulese kushimba emikotana, ehembe einjili, etinjatangwa tinjili simba olutaa. Abeleki kame afanena okubiwa eyi yaalukele. ");
INSERT INTO lyn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aba mwingena mu mulenen̄i simba mu mindi, mwi bangute woyo ofanena okumitambula mwikale kwa yonyene kubitela aba sa mutundemo. ");
INSERT INTO lyn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cwale aba mwingena mu ndoo, mukeete awo alimo. ");
INSERT INTO lyn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nji awo anu ali omo mu ndoo kame amitambula, musiye ekozo no kukeeta kwenu, kono nji kaamitambula, mulese okwasiyela okukeeta kwenu. ");
INSERT INTO lyn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nji mu ndoo ni mu mulenen̄i kami tambula ni kumi teeteta, mutundemo mi mututule eliluli no tinjatangwa tenu. ");
INSERT INTO lyn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Niti luli kame ni myambela nji, Nyambe mba monisa amakeke ba liywaa no katulo kwanau namu Sodoma ni Gomola okubita aanu namu milenen̄i eyo. ");
INSERT INTO lyn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kamumone! cwale kame ni mituma kanyi emikoko mukaci no maakanyani.” Cwale mutende ano kushangama kanyi tinyoka mi mutende ano kukukokobeza kanyi otunkwilimba. ");
INSERT INTO lyn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mutokomele aanu, kakuli kwaali awo samitwale ba kuta, mi mbamifulu mu ndoo no milapelo. ");
INSERT INTO lyn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mulibaka lyange mba mutwaliwa muku zekisiwa balubala no abusisi ni kwaa mbumu. Mundila eyi mbamwamba eliywi no kuwaba kwa onyene ni kwa simacaba. ");
INSERT INTO lyn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Cwale aba samilite mukumyeteka, mulese kubilaela neyo samwambe simba omusa mwitambulele, aba saiiye enako mbamubiwi eyo samwambe. ");
INSERT INTO lyn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Cwale amaywi samwambe kasa enu, kono mbaatundu ku Mebo ya Nyambe Sitenu okwamba mwaanyi. ");
INSERT INTO lyn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Omwabae munu mbabeteke omwabae nji aibaiwe, ni ashemi mbatende ngeeso kwa noo mi aana mbafutukele ashemi oo mane aibaiwe. ");
INSERT INTO lyn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Omunu yonje mbamitimbi mulibaka lyange. Kono woyo so tundamena okutwala ku mamaneneno mbayoyisiwa. ");
INSERT INTO lyn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cwale aba amiyandisa mu mulenen̄i umweya mushotokele mu unjili. Kame nimyambela luli nji, kamutamba okumana omusebezi mu milenen̄i yonje no Isilaele abo Omwana no munu yokasiiya. ");
INSERT INTO lyn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kakwisa omwiyetwa woyo obita omwiyeti waye, mi simba omubika obita molyaye. ");
INSERT INTO lyn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Cwale omwiyetwa kame afanena okupumena okwikala kanyi omwiyeti waye, mi ni mubika kanyi molyaye. Nji omunya ndoo kame isaniwa nji Beezebule, asindoo yaye mbanyefulwa onene ni kubitelela ni kwiisaniwa amatina no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Cwale mulese kucila aanu. Eyo yonje ifukilwe mbaifukulwa, mi simba eyi ishwekilwe yonje mbai limukiwa. ");
INSERT INTO lyn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Eyi nimyambela mu uwi, kame mufanena okuyamba mu liseli, mi neyi muna yupu ku mukunda, kame mufanena okwikuweleza ba kashongwa no ndoo. ");
INSERT INTO lyn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mulese kucila awo aibaa olutu kono katwese okuibaa omooyo, kono mucile Nyambe woyo otwesa okusinya olutu bamweya ni mooyo mu lyangalilo. ");
INSERT INTO lyn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kasa nji etitaha timbili kame tiula akangwee kamweya, kandi kakwisa etaha simba imweya ikwela banji abo sitenu yo kasipumena. ");
INSERT INTO lyn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Cwale Nyambe kame alimukile simba etin̄uki tili ku mitwi yenu. ");
INSERT INTO lyn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Cwale mulese kucila, kame mulukele okubita etitaha no kupula. ");
INSERT INTO lyn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Omunu yonje soamba patalaza kwaanu nji kame apumena kwa mene, ni mene kame sanambe kwa sitange naku wilu nji kame ali kwa mene. ");
INSERT INTO lyn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kono omunu yonje soni latula kwaanu, ni mene mbani mulatula kwa Sitange naku wilu. ");
INSERT INTO lyn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mulese okuyabuta nji kame nina liti ekozo mu litunga, kokuulwa kanisi kulita ekozo kono olutimbo. ");
INSERT INTO lyn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kame nina kwiiya muku fapahanya omwana no ndubana ni sitaye, omwana no mukatana ni inawaye, mi onjemunwa ni njemunwaye no mukati. ");
INSERT INTO lyn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Eila yowe mbatende asindoo yowe. ");
INSERT INTO lyn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Omunu woyo osinga sitaye simba inawaye onene okubita mene, kafanene okutenda omwiyetwa wange, mi omunu woyo osinga mwanaye no ndumbana simba mwanaye no mukatana okubita mene, kafanene okutenda omwiyetwa wange. ");
INSERT INTO lyn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mi woyo soulwa okushimba esifapano saye ni kuni kon̄a, kafanene okutenda omwiyetwa wange. ");
INSERT INTO lyn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Woyo obabalela omooyo waye mbautaukelwe, kono woyo osinyehelwa omooyo waye mulibaka lyange mbauwana. ");
INSERT INTO lyn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Onje awo amitambula kame atambula mene, mi onje awo ani tambula kame atambula ni woyo ona ni tumu. ");
INSERT INTO lyn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mi woyo yonje so tambula omunuhi wa Nyambe mulibaka lyanji nimuhi wa Nyambe, mba wana omupuzo ou ufanena omunuhi wa Nyambe. Mi woyo yonje sotambula omunu no kuluka kakuli ni wakuluka mba wana omupuzo ou ufanena osikuluka. ");
INSERT INTO lyn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Niti luli kame nimyambela nji, woyo yonje soba mumweya ameyi no kunwa ku mucana no aiyetwa ange kakuli ni mwiyetwa wange, luli mba wana omupuzo. ");
INSERT INTO lyn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Cwale Jesu osimana feela okuba etitaelo kwa iyetwa aye anaku kwana likumi na yiili, sebeli osiya esibaka eso ni kuta mukwiyeta ni mukukutaza mu titolopo tili beebi. ");
INSERT INTO lyn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Cwale Jowani omukolobezi aba ana kuyupa yooli mu tolongo einu eyo Kilesite ana ku tenda, sebeli otuma aiyetwa aye kwa yonyene, ");
INSERT INTO lyn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Cwale sebeli amwibanguta nji, “Yawene ana kwamba Jowani nji ukeile, nji mundina tufanena okutatelela?” ");
INSERT INTO lyn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesu sebeli waa tambula nji, “Mute muka simwete Jowani eyi muna yupu neeyi muna mono, ");
INSERT INTO lyn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","eibofu kame imona, eiyanga kame yeenda, asi kutoma embingwa kame abalisiwa, ano kwa yupa kame ayupa, aafu kame aingulwa mi amaywi no kuwaba kame akutaziwa kwaanu no kusheeba. ");
INSERT INTO lyn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Embuyoti ni yaawo aulwa okunikana mulibaka no eyo nitenda! ");
INSERT INTO lyn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Aiyetwa a Jowani aba ana kuuka, Jesu sebeli otateka okwamba kwaanu eya Jowani nji, “Aba mu nakuta kwa Jowani mu lihalaupa iikene muna ku tatelela okumona? Nji neli olutaka olu lunyendaela mu mebo? ");
INSERT INTO lyn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Iikene mu nakutela oka mona? Omulume woyo oku mangile eikumango no kutula? Kasa ngeeso! anu awo akumangile ngeseo kame ayoya mu tindoo no ambumu. ");
INSERT INTO lyn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mu nambele, iikene eyo muna kutela oka monako? Ninji neli omunuhi wa Nyambe woyo muna kutela oka mona? Ee, kame nimyambela nji, Jowani kame abita omunuhi wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yokame woyo aamba aman̄olo nji Nyambe kame ana kwamba nji, ‘Omone! Kame sani tume onumwana wange balubala lowe nji akaku lukisete endila yowe.’ ");
INSERT INTO lyn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kame ni myambela eniti luli nji, Jowani omukolobezi yo munene kwaanu onje ana yoya bano banji. Kono woyo mucana mu mubuso naku wilu yo munene okubita Jowani. ");
INSERT INTO lyn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Oku tunda ba nako ya Jowani omukolobezi yoiyeta eliywi lyaye oku keela ni balelo lino omubuso naku wilu nau yandisiwa onene, alume no tindwaa kame aulwisa nji aukome. ");
INSERT INTO lyn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Oku keela ba nako ya Jowani omukolobezi anuhi a Nyambe onje ni mulawo wa Mushe kame ana kwamba eyi no mubuso. ");
INSERT INTO lyn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Cwale nji kame musinga oku pumena eyo namba, mbamu yupisisa nji Jowani yo Eliya woyo anuhi a Nyambe ana kwamba nji mbaiyi. ");
INSERT INTO lyn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Woyo okwite amatwi yonje ayupe! ");
INSERT INTO lyn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jesu sebeli otwalelela okwamba nji, “Ngaibi sani bapanye aanu no balelo? Kame aku fekile kanyi anuke aikalile mu sibaka no lyuliseto. Esikwata sinjili esi kuweleza akoo, ");
INSERT INTO lyn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Natumi futele epala kono kamwa sinenga, natu miimbele etindimo no malilo kono kamwa silila. ");
INSERT INTO lyn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Cwele abo Jowani aba ana kwiiya, kame ana kukuyumena eino kulya ni kunwa kanyi aanu anjili, mi aanu onje sebeli amba nji, ‘Kame ali ni mandimona!’ ");
INSERT INTO lyn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Cwale abana kwiiya Omwana no munu, sebeli olya ni kunwa, mi aanu onje sebeli amba nji, ‘Komumone woyo mulume! woyo osikulya onene ni undalabangwana omulikani no atelisi ni awo asikutenda eibi! Kono okushangama kame kuku monahaleza ku tikezo. ");
INSERT INTO lyn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Cwale Jesu sebeli otangisa okwayuta emilenen̄i omo ana ku tenda etimakazo no kupula, kakuli kaya sibaka. ");
INSERT INTO lyn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Mba mumono oumai wenu anyi Kolazini ni wene Betisaida! Kambe etimakazo tina tendiwa kwaanyi kambe kame tina tendahala mu Tile ni mu Sidoni, emilenen̄i eyo kambe naibaka mwiikumango no masaka ni mute na ba litiko. ");
INSERT INTO lyn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kono kame ni myambela nji, ekoto no Tile ni Sidoni kame sa itende eyi no kotoba okubita eyenu mu liywaa no katulo. ");
INSERT INTO lyn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ni wene Kapenauma kame so tulekelwe ku wilu? Kokuulwa kame sobeekiwe kunji mu lyangalilo, kakuli etimakazo tina tendahala kwa wene kambe kame tinaku tendahala mu Sodoma, kambe kwa tisili ni balelo lino. ");
INSERT INTO lyn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kono kame nimyambela nji ba liywaa no katulo, ekoto no Sodoma kame sa itende eyi no kotoba okubita yowe. ");
INSERT INTO lyn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mu nako eyo Jesu sebeli wamba nji, “Kame ni ku lumbeka Sitange, Ombumu no litunga ni liwilu, kakuli na ushweeke eyi inu kwasi kushangama naawo asiku kwiyeta, mi kame ona tishootwele aana acana. ");
INSERT INTO lyn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, Sitange, mo kwikalele, kakuli mo na singele. ");
INSERT INTO lyn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Cwale Jesu sebeli wamba kwaanu nji, “Sitange nabi einu yonje kwa mene. Mi kakwisa woyo olimukile Omwana konji sitaye, kame kakwisa woyo olimukile sitaye konji Omwana, naawo asingwa kwa Mwana okwa taluseta. ");
INSERT INTO lyn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mwiiye kwa mene monje anyi mu katalile naanyi mu imelwe, mi kame sani mibe epumulo. ");
INSERT INTO lyn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Muku tweke ecoko yange, mi mu kwiyete kwa mene, kakuli kame nili ni wikokobezo ni mucima no kotoba, mi mba mu wanene Emebo yenu epumulo, ");
INSERT INTO lyn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","kakuli ecoko yange niya kotoba mi omushimbo wange ka ukwite okulema.” ");
INSERT INTO lyn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ba nako eyo Jesu sebeli ota mu matema elino Sabata. Aiyetwa aye kame ana kuyomba mi sebeli atangisa oku tola oubeke ni kulya. ");
INSERT INTO lyn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kono Afalisi aba ana ku mona ngeeso, sebeli amba kwa Jesu nji, “Komone, aiyetwa owe kame atenda eyi no kwafanena ba liywaa no Sabata.” ");
INSERT INTO lyn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesu sebeli otambula nji, “Kamu si kubala mu man̄olo eyo ana ku tenda Dabida naanu aye abana ku yomba? ");
INSERT INTO lyn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Sebeli wingena mu ndoo ya Nyambe, mi yonyene nawo ana kwikala naye sebeli alya esinkwa eso sina kulukisetwa Nyambe, mi eyo kaya siku pumenenwa ku mulawo oku tendiwa, kono konji apulisita anaku pumenenwa okulya esinkwa eso. ");
INSERT INTO lyn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kame kamwa sikubala mu mulawo wa Mushe nji, eli no Sabata apulisita mu Ndoo ya Nyambe kame acolanga omulawo no Sabata kono ka kwite omubonda? ");
INSERT INTO lyn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kame ni myambela nji esinu no kuneneba okubita endoo ya Nyambe sino sokame. ");
INSERT INTO lyn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kambe namu ku limuka eyo atalusa amaywi a Nyambe nji, ‘Kame nilakaza esishemo, kasa esitabelo,’ kambe kamwa satula ano kuluka. ");
INSERT INTO lyn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Cwale abo Omwana no Munu yo Mbumu no Sabata.” ");
INSERT INTO lyn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesu aba ana kutunda omo mu sibaka sebeli oingena mu ndoo yoo no milapelo, ");
INSERT INTO lyn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","omo kuna kwikala omulume no kombola elyoko. Kame kuna kwikalamo aanu ana kusinga okunyaza Jesu nji kame acola omulawo, sebeli amwibanguta nji, “Kasa okufosa okubalisa eli no Sabata?” ");
INSERT INTO lyn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesu sebeli wamba kwa onyene nji, “Cwale nji kwaanyi kame kuli ni woyo oli ni mukoko ona kwele mu wina ba liywaa no Sabata, kamu twese oku utundisamo? ");
INSERT INTO lyn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ka utokwa oli ba mukoko okubita omunu? Abohe ni mulawo kame otupumenena oku tenda wino ba liywaa no Sabata.” ");
INSERT INTO lyn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Cwale sebeli wamba ku mulume no kombola elyoko nji, “Oolole elyoko lyowe.” Cwale sebeli olyolola mi luli nali ku bala, kanyi omwa yupelanga elinjili. ");
INSERT INTO lyn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kono Afalisi sebeli ata bandee okalela omo saibaele Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Cwale Jesu aba ana kulimuka eyo ana kulela, sebeli otunda mu sibaka eso. Aanu no kupula sebeli amu kon̄a , mi sebeli obalisa asikutoma onje. ");
INSERT INTO lyn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Sebeli waaba emamela nji alese okambela akoo eyaye. ");
INSERT INTO lyn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Eyi neli okwiyateteta eyo ina kwambiwa kwa omunuhi wa Nyambe Isaya nji, ");
INSERT INTO lyn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Woyo yo mubika wange woyo ni na kete, woyo nisinga, woyo nikatelwe onene. Mba ni beeke Emebo yange mwa yonyene, mi mbaamba ku matunga elin̄usa no uuwa no katulo yange. ");
INSERT INTO lyn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ka tamba okwauta simba okukuwa, kakwisa woyo so yupa eliywi lyaye mu tindila. ");
INSERT INTO lyn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ka tamba okucolelela olutaka luna funyuka mi katamba okutima olumonyi olu lusi tunya owise, konji eyi no kuluka aba sa ikome. ");
INSERT INTO lyn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mu litina lyaye asimatunga mba musepe. ");
INSERT INTO lyn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Cwale aanu sebeli amu litela omulume osi madimona woyo no kwa mona ni kwamba, mi Jesu sebeli omubalisa, nji cwale amone ni kwamba. ");
INSERT INTO lyn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aanu onje sebeli akomoka ni kwamba nji, “Anyi! Uyu kasa mwanaye Dabida!” ");
INSERT INTO lyn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kono cwale afalisi aba ana kuyupa eyi, sebeli amba nji, “Uyu munu kame atundisa amadimona mulibaka no maata a Beeluzebule ombumu no madimona.” ");
INSERT INTO lyn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesu no limuka emihupulo yoo mi sebeli wamba kwa onyene nji, “Omubuso onje aba uku tabile wonyene mbau futuka amatota, mi omulenen̄i simba endoo ikutaba yonyene mba ishandauka. ");
INSERT INTO lyn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nji Satani kame akulwisa yonyene, cwale ngasibine sa wikale omubuso waye? ");
INSERT INTO lyn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mi nji kame ni tundisa amandimona mulibaka lya Beeluzebule, cwale anyine aku tusisa anenu oku tundisa amandimona? cwale abo mba tende aatuli enu. ");
INSERT INTO lyn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kono cwale nji kame ni tundisa amandimona mulibaka lya Mebo ya Nyambe, cwale omubuso wa Nyambe na wiiyi kwaanyi. ");
INSERT INTO lyn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nji kame, ngaibi saingenene omunu mu ndoo no mulume no kongola ni kwiita eibyana yaye, konji aba sa mu nunge oweli? Cwale okubinda sa ite einu yonje mu ndoo yaye. ");
INSERT INTO lyn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Woyo yonje kasa kwa mene kame ani lwisa, mi woyo onje no kwanitusa okuwaneka kame ashandaula. ");
INSERT INTO lyn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mu libaka eli kame ni myambela nji, aanu kame atwesa okulemenwa eibi ni tinyefulo, kono okunyefula ba Mebo No Kukena kaku tamba oku lemenwa. ");
INSERT INTO lyn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yonje woyo wamba eliywi no ku lwisa Omwana no munu mba lemenwe, kono woyo yonje soamba eliywi oku lwisa Emebo No Kukena katamba ku lemenwa, simba muno mu nako ni mu nako eyo ikeyile. ");
INSERT INTO lyn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Esitondo aba sambiwa nji sa kuwaba ni mbuya yaso niya kuwaba, esitondo no kwiiba ni mbuya yaso ni yakwiiba, esitondo kame silimukelwa ku mbuya yaso sibeeka. ");
INSERT INTO lyn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Anyi etinyoka! Ngaibi aba mwamba eyi no kuwaba me muli ano kwiiba? Kamutwese okwamba ngeeso kakuli akanwa kame kamba eyi iyalile mu mucima. ");
INSERT INTO lyn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Omunu muwa kame alita einu no kuwaba oku tunda mu sitewelo saye no kuwaba, ni munu no kwiiba kame alita eyi no kwiiba oku tunda mu sitewelo saye no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Cwale kame ni myambela nji, “Omunu yonje kame sakutambwele ba liywaa no katulo ku liywi lyonje nambulwa tuso ana kwamba. ");
INSERT INTO lyn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Amaywi enu mba kutusisiwa oku myatula. Eyi munamba mba imonisa nji kame mukenine simba nji kame mukwite emibonda. ");
INSERT INTO lyn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Cwale anjili no Afalisi na iyeti no mulawo sebeli aiya kwa Jesu ni ku mwibanguta nji, “Mwiyeti, kame tu saela oku mona esisupo no makazo oku tunda kwa wene.” ");
INSERT INTO lyn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Cwale sebeli otambula nji, “Anyi olusika no kwiiba ni wozwa kame musinga oku mona emakazo kono ka mu tamba kubiwa konji emakazo no munuhi wa Nyambe Jonasi. ");
INSERT INTO lyn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonasi aba ana kwikala amaywaa aatu ni mausiku aatu mu lipumo no ndi no kuneneba. Mundila imweya Omwana no munu kame sa ikale mu libita amaywaa aatu ni mausiku aatu. ");
INSERT INTO lyn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Beelyo eliywaa no katulo alume no Nanibe mba imana ba katulo noolu olusika ni ku lunyaza, kakuli naaku baka aba ana kuyupa ekutazo ya Jonasi, mi bano esinu no kuneneba okubita Jonasi sino sokame. ");
INSERT INTO lyn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Beelyo eliywaa Ombumu no mukati na ku mboela kame sa imane ba katulo ni olu olusika ni ku lunyaza, kakuli nakwiiya oku tunda ku mamaneneno no litunga mu ku teeteta kukushangama kwa Solomoni, mi bano esi no kuneneba okubita Solomoni sino sokame. ");
INSERT INTO lyn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Cwale emebo no kwiiba aba itunda ku munu, kame ikutela mu lihalaupa mu ku saela epumulo mi kaya siiwana. ");
INSERT INTO lyn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Cwale kame yamba nji, ‘Mbani uku ku ndoo nina ku siya, cwale aba ikeela, sebeli iwana endoo kakwisa eyi ilimo kame ikenine naifiyeliwa ni ku baakanyiwa wino. ");
INSERT INTO lyn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Cwale kame ita oka shimba emebo injili ikwana mutanu ni twiili (7) no kwiiba okwibitelela, mi kame ingena ni ku yoya mo. Mi omwikalelo waye no mamaneneno kame sobambabe okubita ba weli. Mo sa lwikalele nolu olusika no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Abo Jesu yo samba kwaanu, inawaye nainaye sebeli aimana ba ndee, okusaela okwamba naye. ");
INSERT INTO lyn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Omunjili sebeli omwambela nji, “Inaowe na inowe kame aimanine bandee okusaela okwamba nowe.” ");
INSERT INTO lyn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kono Jesu sebeli omutambula nji, “Inawange nanyine, mi na inange anyine?” ");
INSERT INTO lyn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yo yulekile kwa iyetwa aye, sebeli wamba nji, “Aa, amandi na inange! ");
INSERT INTO lyn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Woyo yonje otenda esi asinga sitange naku wilu yo inawange ni minange ni mandange no mulume simba no mukati. ");
INSERT INTO lyn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ba liywa elyo, Jesu sebeli otunda mu ndoo nu kekala ba likamba no liwate. ");
INSERT INTO lyn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kame ana kwingena mu wato kakuli aanu ana kuungana kwa yonyene neli ano kupula. Sebeli oikala banji abo aanu aimanine ba likamba. ");
INSERT INTO lyn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Cwale sebeli waambela eyambo no kupula mu tinguli nji, “Omukuni nakuta mukukuna. ");
INSERT INTO lyn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aba anaku kunanga ngeeso, einjili embuto sebeli ikwela mu ndila mi otuyunyi sebeli twiiya mukwilya. ");
INSERT INTO lyn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Einjili embuto sebeli ikwela mu mawee, omo kuulwile omumbu no kupula, mi sebeli imena muwangu kakuli omumbu kawasitunga. ");
INSERT INTO lyn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kono eliywaa aba linakupa eimena sebeli iletuka, mi kakuli kaikwite emibisi, sebeli ikukuta. ");
INSERT INTO lyn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Einjili embuto sebeli ikwela mu mikakani, mi emikakani aba ikula kame iyowelisa eimena. ");
INSERT INTO lyn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kono einjili embuto sebeli ikwela mu mumbu no kuwaba mi sebeli ikula ni kubeeka obeeke. Einjili embuto sebeli ibeeka omwaanda (100), einjili sebeli ibeeka amakumi mutanu ni likumi limweya (60), einjili makumi aatu (30). ");
INSERT INTO lyn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mi Jesu sebeli omanenena mu kwamba nji, “Woyo yonje oli ni matwi ayupe!” ");
INSERT INTO lyn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Aiyetwa sebeli aiya kwa yonyene ni kumwibanguta nji, “Iikene aba wamba kwaanu mu tinguli?” ");
INSERT INTO lyn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesu sebeli waatambula nji, “Anyi namubiwi okulimuka etikunutu no mubuso na kuwilu, kono onyene kasibiwa. ");
INSERT INTO lyn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Woyo yonje okwite mbabiwi onene, mi mbakwiyala kwa yonyene, kono woyo oulwile simba kanyonyo mba byanguliwa nesi ali naso. ");
INSERT INTO lyn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Eli elibaka naambela noo mu tinguli. Aa aanu mba mona, kono kamonisisa, mbayupu kono katamba kuyupisisa. ");
INSERT INTO lyn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mwa onyene nakwiyatetetwe eyi ana kwamba omunuhi wa Nyambe Isaya nji, “Okuyupa mba muyupu kono kamutamba kuyupisisa, mba mumono kono kamu tamba kumonisisa. ");
INSERT INTO lyn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Emicima yaa aanu, kame inakulu muku timbiba, amatwi oo kayupisisa mi kame ana kutimi ku miyo nji alese okumona. Amatwi oo kayupu, emicima yoo kaiyupisisa mi kafutukele kwa mene nji naabalise. ");
INSERT INTO lyn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kono kwaanyi amiyo enu kame afuyolilwe, kakuli kame amona, ni matwi enu kakuli kame ayupa. ");
INSERT INTO lyn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Niti luli kame nimyambela nji, asikunuha no kupula naa no kuluka no kupula kame anyolelwe okumona eyi mumona kono kasiimona ni kuyupa eyi muyupa kono kasiiyupa. ");
INSERT INTO lyn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Cwale komuyupe etaluso no nguli no mukuni. ");
INSERT INTO lyn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Embuto ina kuniwa mu ndila kame ikufekile kanyi omunu woyo ona yupu eliywi no mubuso mi kaliyupisisa, woyo no kwiiba kame aiya kwa yonyene ni kumubyangula esisinakuniwa mu mucima waye. ");
INSERT INTO lyn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Embuto ina kwele mu mumbu no mawee, kame ikufekile ni munu woyo oyupa eliywi mi ababo ni mulitambula mukuwabelelwa. ");
INSERT INTO lyn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Abo omunu no ngeeso kakwite emibisi, kono kame atambula eliywi mu nako icana. Kono cwale amayando ni utata aba iiya mulibaka no liywii, kame aleluba okukwa. ");
INSERT INTO lyn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Embuto ina kwele mu mikakani kame ikufekile ni munu woyo ona yupu eliywi, kono etipilaelo na mu litnga ni titakazo no ufumu kame tiyowelisa eliywi, cwale kabeeke embuya. ");
INSERT INTO lyn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kono embuto eyi ina kwele mu mumbu no kuwaba kame ikufekile kanyi omunu woyo ona yupu eliywi ni kuliyupisisa ni kuyoya nalyo. Cwale kame akufekile kanyi embuto eyi ibeeka oubeeka, einjili sebeli ibeeka omwanda (100), einjili makumi mutanu ni likumi limweya (60) mi einjili amakumi aatu (30) okubita eyo inaku kuniwa. ");
INSERT INTO lyn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesu sebeli waambela enguli einjili nji, “Omubuso na kuwilu kame ukufekile kanyi eso sina kutendahala ku munu ona kukuna embuto no kuwaba mu litema lyaye. ");
INSERT INTO lyn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kono aanu onje aba alanganine sebeli kwiiya esiila saye ni kukuna omufuka mu uloto nuu kutela. ");
INSERT INTO lyn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mi ouloto aba ona mana okumena ni kubeeka, omufuka ni wonyene sebeli okula. ");
INSERT INTO lyn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mi abika no munya ndoo sebeli aiya kwa yonyene ni kwamba nji, ‘Mbumu kasanji kame munakukuna embuto no kuwaba mu litema lyenu? Cwale kubine ona tundu omufuka?’ ");
INSERT INTO lyn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Sebeli otambula kwa onyene nji, ‘Esiila sange yo natende ngeesi, cwale sebeli amwiibanguta nji, ‘Kausingi nji tukautulemo?’ ");
INSERT INTO lyn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kono sebeli waatambula nji, ‘Kokuulwa! Kakuli aba samutule omufuka mwendi mba mutulelele bamweya ni uloto. ");
INSERT INTO lyn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mwilesele yonje ikulele bamweya okutwala ba nako no kuyangula mi cwale mbani ambele asi kuyangula nji, ‘Muungekemo omufuka muununge otun̄ata cwale muu cin̄e okubinda samuyangule ouloto niku ubeeka mu sishete sange.” ");
INSERT INTO lyn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kame Jesu sebeli waambela enguli injili nji, “Omubuso na kuwilu kame ukufekile kanyi embuto no masitete eyi ana shimbi omunu nuu kaikuna mu mutabo waye. ");
INSERT INTO lyn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Naaba itendile icana kutimbuto tonje, kono aba imena, kame itenda esimena no kuneneba ku miloho yonje mi kame ifutuka esitondo, cwale abo eiyunyi kame iiya mukuyakelako eiyaleto ku mitai yaso. ");
INSERT INTO lyn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesu sebeli waambela kame enguli injili nji, “Omubuso na kuwilu kame ukufekile kanyi eso sitendahalanga abo omukati aba awaneka omumena ni unga no uloto no kupula okukanda, cwale elin̄ende lyonje kame litunduluka.” ");
INSERT INTO lyn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesu sebeli wamba eyambo eyi yonje ku sicaba mu tinguli, kasi kwamba noo feela konji mu tinguli. ");
INSERT INTO lyn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Naku tenda ngeesi okwiyateteta esi sina kwambiwa kwa munuhi wa Nyambe nji, “Kame sani yaamise akanwa kange ni kwamba mu tinguli, mbanamba eyi inaku shweekiwa, okutunda ku matatekelo no litunga.” ");
INSERT INTO lyn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Cwale Jesu aba ana kusiya aanu no kupula sebeli oingena mu ndoo. Aiyetwa aye sebeli aiya kwa yonyene ni kumu ambela nji, “Otu talusete enguli no mufuka mu mutabo.” ");
INSERT INTO lyn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesu sebeli otambula nji, “Woyo ona kunu embuto no kuwaba, Mwana no Munu. ");
INSERT INTO lyn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Omutabo wokame elitunga, embuto iwa okame aanu no mubuso wa Nyambe, omufuka okame aanu awo ali kwa woyo no Kwiiba. ");
INSERT INTO lyn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mi esila sina kukuna omufuka yokame Diyabulosi, ekutulo okame mamaneneno no litunga, mi asi kukutula okame amangeloi. ");
INSERT INTO lyn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kanyi aba kukutulwa omufuka ni ku ucin̄a ni mulilo, mbakwikala ngeeso niku mamaneneno no litunga. ");
INSERT INTO lyn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Omwana no munu kame satume amangeloi aye mi mbawaneke nikutundisa mu mubuso waya awo onje atendisa aanu okutenda esibi nawo acola emilawo ya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mi mbaakondele mu mulilo no kuneneba no lihele omo sa kaikale alila ni kukweca amaeo. ");
INSERT INTO lyn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Cwale asikuluka mba benye kanyi eliywaa mu mubuso wa sitoo. Woyo oli ni matwi ayupe. ");
INSERT INTO lyn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Omubuso na kuwilu kame ukufekile kanyi oufumu ona shweekiwa mu mutabo, Omunu sebeli ouwana niku ushweeka kame. Cwale muku wabelelwa kwaye sebeli ota okaulisa eyaye yonje ni kuula elyo litema. ");
INSERT INTO lyn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kame omubuso na kuwilu kame ukufekile kanyi eso sina kutendahala ku muulisi woyo aba ana kuta muku saaela etinyuma no kutula (isaniwa nji etipelela). ");
INSERT INTO lyn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aba ana kuwana eyi no utokwa, sebeli ota mukaulisa eyaye yonje nukuulela yo. ");
INSERT INTO lyn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mi kame, omubuso na kuwilu kame ukufekile kanyi esisi tendahalanga abo elituwa aba likondelwa mu lisa ni kukoka etindi no mifutafuta. ");
INSERT INTO lyn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cwale aba lina kwiyala sebeli alikokela ba libamba, cwale sebeli aikala banji nikuketa etimdi no kuwaba ni kubeeka mu matanda, kono niku yumba etino kwiiba. ");
INSERT INTO lyn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Yongeso mo sa kwikalele ku mamaneneno no litunga. Amangeloi mbaiyi mu kutaba ano kwiiba kwaawo no kuwaba ");
INSERT INTO lyn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","niku yumbela aanu no kwiiba mu mulilo no kuneneba no lihele, omo sa kwikale okulila ni kukweca amaeo. ");
INSERT INTO lyn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesu sebeli oibanguta aiyetwa aye nji, “Namu yupisisa eyi einu yonje?” Sebeli atambula nji, “Ee.” ");
INSERT INTO lyn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesu sebeli wamba kwa onyene nji, “Abo cwale omwiyeti yonje no mulawo woyo ona tende omwiyetwa mu mubuso na kuwilu kame akufekile kanyi omunya ndoo woyo olita mu sitewelo saye eyi no kale neyi no ubya.” ");
INSERT INTO lyn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Cwale Jesu aba ana kumana okwamba eyi yonje mu tinguli, sebeli otunda mo. ");
INSERT INTO lyn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Aba ana kukeela mu mulenen̄i waye sebeli otangisa okwiyeta aanu mu ndoo yoo no milapelo, mane sebeli akomoka ni kwamba nji, “Kandi uyu mulume kubine ana shimbi okushasngama no ngeesi ni maata no kutenda etimakazo? ");
INSERT INTO lyn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aaka! kasa kanaye osi kwaaya? Kasa nji inawaye ni Maliya, kasanji ainaye ni Jakobo, Josefa, Simoni ni Juda? ");
INSERT INTO lyn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kasanji amandaye onje kame ali naaci? Cwale kubine uyu mulume oko ana wana eyi inu yonje? ");
INSERT INTO lyn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mi sebeli afosezwa onene mane sebeli akana oku pumena kwa yonyene. Jesu sebeli wamba kwa onyene nji, “Mu sibaka feela omo omunuhi wa Nyambe aulwa okukutekiwa, mu mulenen̄i waye ni mu ndoo yaye.” ");
INSERT INTO lyn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mi kasi kutenda etimakazo no kupula muya mulibaka no kuulwa etumelo koo. ");
INSERT INTO lyn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ba nako eyo ombumu Heloda namu Galileya, sebeli oyupa elibubo lya Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Mi Sebeli wambela abika aye nji, “Uyu ya Jowani omukolobezi na inguka kwaafu! Mulibaka elyo aa maata kame abeleka mwa yonyene okutenda etimakazo.” ");
INSERT INTO lyn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nakwamba eyi kakuli mu nako nakunyima, kame ana kumulema Jowani okumununga mane ni kumu beeka mu tolongo mulibaka lya Helodiyasi onaku kwaliwangwa oweli kwa mukulwaye Filipi, ");
INSERT INTO lyn_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","kakuli Jowani kame ana kwambela Heloda nji, “Kasa etukelo nji weene omukwate.” ");
INSERT INTO lyn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heloda osaela okwibaa Jowani, kono kame ana kucila aanu, kakuli aanu kame ana ku yambuta nji Jowani neli munuhi wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kono ba liywaa no mukiti no kuleiwa kwa Heloda, omwana Helodiyasi no mukatana sebeli onenga balubala no angenda ni ku wabelisa Heloda onene, ");
INSERT INTO lyn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","cwale mane sebeli omusepisa ni kweeta nji, “Kame samube eso sonje sakumbele.” ");
INSERT INTO lyn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Muku susuweziwa kwa nyinawaye, sebeli wamba nji, “Onibe muno mu siwana omutwi wa Jowani omukolobezi.” ");
INSERT INTO lyn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ombumu sebeli weena, kono mulibaka no kweeta naa ngenda, sebeli olaela nji abiwe eyi ana kumbele. ");
INSERT INTO lyn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Heloda sebeli otuma amasole aye okapatula omutwi wa Jowani mu tolongo. ");
INSERT INTO lyn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Omutwi waye nolitiwa mu siwana ni kuuba omukatana, mi sebeli oulita kwa nyinawaye. ");
INSERT INTO lyn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Cwale aiyetwa a Jowani sebeli aiya ni ku shimba olutu lwaye okapumbeka, cwale sebeli ata nu kambela Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Cwale Jesu aba ana kuyupa eya Jowani eyi ina kutendahala, sebeli ofuula esisepe ni kuta ku mukunda aka ikalako yomboci. Esicaba aba sina kuyupa ngeeso, sebeli simukon̄a ni makondo okutunda mu milenen̄i. ");
INSERT INTO lyn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Cwale Jesu aba ana ku fuweka sebeli omona aanu no kupula-pula, sebeli waayupela amakeke niku balisa awo ana kutomanga mukaci koo. ");
INSERT INTO lyn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Cwale aba kuna kutenda amangolwaa, aiyetwa aye sebeli aiya kwa yonyene ni ku mwambela nji, “Kuno ku sibaka ni kwakuleba ni mindi mi eliywaa lyatakale, ouse esicaba sikutele mu mindi sikakuulele sonyene eilya. ");
INSERT INTO lyn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesu sebeli otambula nji, “Kalukele okuta. Mwaabe esinjili esi sa lye.” ");
INSERT INTO lyn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aiyetwa sebeli atambula nji, “Aci muno katukwite esi no kwaaba konji feela einkwa mutanu ni tindi timbili.” ");
INSERT INTO lyn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesu sebeli wamba nji, “Mwilite kuno kwa mene.” ");
INSERT INTO lyn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesu sebeli olaela aanu okwikala banji ba moopu. Sebeli oshimbe einkwa mutanu ni tindi timbili ni kwaliketa ku wilu, sebeli okutumela ni kupatoola einkwa. Cwale sebeli oba aiyetwa aye einkwa, mi aiyetwa aye sebeli aaba aanu einkwa. ");
INSERT INTO lyn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Cwale onje sebeli alya ni kwikuta, mi aiyetwa sebeli atola oungululwa ni kwiyata amatanda no kukwana likumi ni twiili kweyo ina kusiyalako. ");
INSERT INTO lyn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Epalo yawo ana ku lyako kame ina kukwana eikiti mutanu alume okutundisako akati naa nukana. ");
INSERT INTO lyn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ababo Jesu sebeli wambela aiyetwa aye nji aingene mu wato, aku tangete okuta mu linjaliya no liwate yonyene abo yosi fundula elikwanamunu. ");
INSERT INTO lyn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aba ana ku mana okufundula elikwanamunu, sebeli okambama ba lilundu yomboci oka lapela. Cwale aba kuna kutenda amangolwaa, Jesu yoliko yomboci. ");
INSERT INTO lyn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ba nako eyo owato omo ana ikalanga aiyetwa owendela kule bakaci no liwate, ouzukuzwa ku mandinda kakuli emebo eifuka onene okulwisa owato. ");
INSERT INTO lyn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cwale amalungasiku Jesu sebeli oiiya kwa iyetwa yo enda ba meyi. ");
INSERT INTO lyn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Cwale aiyetwa aba anaku mumona yoenda ba meyi, sebeli acila. Mukucila koo sebeli akuwa nji, “Silumba!” ");
INSERT INTO lyn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kono ababo Jesu sebeli wamba kwa onyene nji, “Moongole emicima! Meene. Mulese kucila.” ");
INSERT INTO lyn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Cwale Pitolosi sebeli wamba nji, “Mbumu, nji yawene, olaele nji niiye kwa wene ba meyi.” ");
INSERT INTO lyn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Cwale Jesu sebeli wamba nji, “Wiiye!” Cwale Pitolosi sebeli otunda mu wato ni kweenda ba meyi, okuta kwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kono cwale aba ana ku mona emebo no kupula, sebeli ocila, mi sebeli otangisa okutika. Cwale Pitolosi sebeli okuwa nji, “Mbumu, uni yoyise.” ");
INSERT INTO lyn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Muwangu Jesu sebeli oolola elyoko lyaye ni kulema Pitolosi ku Lyoko, mi sebeli wamba nji, “Wene ositumelo icana, iikene aba wasepile?” ");
INSERT INTO lyn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ababo aba ana ingene mu wato, emebo sebeli yondoka. ");
INSERT INTO lyn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Cwale awo ana ikalanga mu wato sebeli amukubamena ni kwamba nji, “Niti luli yawene omwana Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Cwale aba ana kukanduka elisa, sebeli afuweka ba likamba kunyonga ni mundi no Genesaleti. ");
INSERT INTO lyn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Munyima no aanu nwaabo ba sibaka aba ana kulimuka nji Jesu, sebeli a tuma elin̄usa mu sibaka sonje. Aanu sebeli alita asikutoma onje kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Cwale sebeli amu kumbela nji apumenene asikutoma okulema feela ku mungundo no sikumango saye, mi onje ana kulemako sebeli abala. ");
INSERT INTO lyn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Cwale afalisi na iyeti no mulawo sebeli aiya kwa Jesu okutunda ku Jelusalema, ni kumwibanguta nji, ");
INSERT INTO lyn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Iikene aiyetwa owe aba acola esizo no akulu? Abo kakuyowanga ku maoko oo akasilya kale!” ");
INSERT INTO lyn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesu sebeli otambula nji, “Cwale iikene mucolelanga etitaelo ta Nyambe mulibaka no sizo senu?” ");
INSERT INTO lyn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nyambe na kwamba nji, ‘Okuteke sitowe ni nyinawowe,’ mi ‘Omunu yonje aba ashwaula sitaye simba inawaye mba ibaiwa.’ ");
INSERT INTO lyn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kono anyi kame mwamba nji, ‘Woyo wambela sitaye simba inawaye nji, ‘Etuso sa ni mibe, kame nina ibi Nyambe,’ ");
INSERT INTO lyn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","mu ndila eyi kame mwiyeta nji kafanene okukuteka sitaye ni inawaye kame musinya omulawo wa Nyambe mulibaka no sizo senu. ");
INSERT INTO lyn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Anyi asikukuba, Isaya naku nuha wino eyenu aba ana kwamba nji, ");
INSERT INTO lyn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Aa anu kame ani kuteka ni tunwa too, kono emicima yoo kame ili oku no kuleba ni Mene. ");
INSERT INTO lyn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kame ani kubamena oku nambulwa tuso, kakuli kame aiyeta aanu emilawo no unu ni kwamba nji titaelo ta Nyambe!’ ");
INSERT INTO lyn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Cwale Jesu sebeli oisanena aanu no kupula kwa yonyene ni kwamba nji, “Mu teetete ni ku yupisisa. ");
INSERT INTO lyn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kasa eso si ingena mu kanwa no munu esi simusilafaza, kono esi situnda mu kanwa kaye, sokame esi sisilafaza omunu.” ");
INSERT INTO lyn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Cwale aiyetwa sebeli aiya kwa yonyene ni ku mwibanguta nji, “Kauyii nji afalisi nakufoseziwa aba ana kuyupa omwambelo owe?” ");
INSERT INTO lyn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesu sebeli otambula nji, “Esikunanu sonje esi sasi kuniwa kwa sitange na kuwilu mbasi tuliwa emibisi. ");
INSERT INTO lyn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mwa lesele nibofu eyi yendisa eyibofu. Nji esibofu sitwaletele esibofu sinjili, yoonje mba ikwele mu wina.” ");
INSERT INTO lyn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Cwale Pitolosi sebeli wamba nji, “Otu talusete eyo otalusa aba wamba eyi no inu eyo itenda omunu woyo no kwakena.” ");
INSERT INTO lyn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesu sebeli waambela nji, “Naanyi musulwile oku yupisisa? ");
INSERT INTO lyn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kamu limukile nji esinu sonje esi siingena mu kanwa, kame sita mu lipumo mi cwale mba situndisetwe bandee? ");
INSERT INTO lyn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kono eliywi eli litunda mu kanwa no munu kame litunda ku muchima waye, mi yokame eyi isilafaza omunu. ");
INSERT INTO lyn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kakuli mu muchima mo kame omo kutunda emihupulo no kwiiba, kwibaa, ku buka, owozwa, oumbuyi, oupaki no mapwa, ni nyefulo. ");
INSERT INTO lyn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yokame eyi isilafaza omunu. Kono okulya ni maoko aasi yowisiwa, ka ku silafaza omunu.” ");
INSERT INTO lyn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Cwale Jesu sebeli osiya esibaka eso nuukutela mu sibaka sili kunyonga ni milenen̄i no Tile ni Sidoni. ");
INSERT INTO lyn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ababo sebeli kwiiya omukati no mukanana, oyo ona kutunda mu sibaka siya, sebeli okuwa nji, “Mbumu Omwana Dabida, oniyupele amakeke, omwanange no mukatana kame ayandisiwa ku mandimona.” ");
INSERT INTO lyn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kono Jesu kasi kumu tambula nebe eliywi. Aiyetwa aye sebeli aiya ni ku mukumbela ni kwamba nji, “Omu cite, kakuli kame atukon̄a munyima ni kutenda elilata.” ");
INSERT INTO lyn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Cwale Jesu sebeli otambula nji, “Kame nina kutumiwa feela ku Mikoko no kutauka eyi no Isilaele.” ");
INSERT INTO lyn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kono omukati sebeli oiya ni ku mukubamena ni kwamba nji, “Mbumu, oni tuse!” ");
INSERT INTO lyn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Cwale Jesu sebeli otambula omukati nji, “Ka ku fanene oku byangula anukana eilya ni kwikondela ambwa.” ");
INSERT INTO lyn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Omukati sebeli wamba nji, “Ee Mbumu! Kono nonyene ambwa kame alya ku ungululwa ou ukwa ku tafule no molyoo.” ");
INSERT INTO lyn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Cwale Jesu sebeli omutambula nji, “Mukati, etumelo yowe niya kuneneba! Ku tendiwe kwa wene omo usingela.” Mi mwanaye no mukatana sebeli obala ababo. ");
INSERT INTO lyn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Munyima ya Jesu okutunda mu sibaka eso, sebeli obita ku mukenga no liwate lya Galileya. Mi sebeli okambama ba lilundu, nuu kaikalabo. ");
INSERT INTO lyn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Aanu no kupula-pula sebeli aiya kwa yonyene, oku mulitela eihole, eimumu, naa no kutika amatwi naanjili ngeso, sebeli aabeka ku makondo aye, mi sebeli waabalisa. ");
INSERT INTO lyn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aanu no kupula sebeli akomoka aba ana ku mona eimumu eyamba, eihole eyenda, mi sebeli ayeema Nyambe no Isilaele. ");
INSERT INTO lyn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Cwale Jesu sebeli oisana aiyetwa aye ni kwamba nji, “Kame ni yupela aanu no kupula amakeke, kakuli sebeli maywaa aatu aikalile ni mene, mi kakwite eyi no kulya, mi okwa usa ni lishebo kani singi, mba tamba awelela mu ndila. ");
INSERT INTO lyn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aiyetwa sebeli amba kwa yonyene nji, “Kubine satu wane einkwa no kupula muno mulihalaupa nji tufepe aanu no kupula ngeesi?” ");
INSERT INTO lyn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Cwale Jesu sebeli wamba kwa onyene nji, “Kame mukwite einkwa no kukuma babine?” Sebeli amba nji, “Einkwa eyi ikwana mutanu ni yiili (7), ni tusi tu cana.” ");
INSERT INTO lyn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesu sebeli olaela aanu no kupula nji aikale banji. ");
INSERT INTO lyn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Cwale Jesu sebeli oshimba einkwa mutanu ni yiili (7) ni tindi, mi sebeli okutumela, ni kwipatoola ni kuba aiyetwa, mi aiyetwa sebeli aba aanu. ");
INSERT INTO lyn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Cwale aanu sebeli alya onje ni kwikuta, mi sebeli atola amatanda no kukwana mutanu naa yiili (7) ku ilya ina ku siyalako. ");
INSERT INTO lyn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Epalo no aanu awo ana kulyako neli alume akuma ba ikiti inee, (4,000), ka ku baliwa aana naakati. ");
INSERT INTO lyn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesu aba ana kumana okuusa aanu no kupula, sebeli aingena mu wato ni kukanduka eliwate ni kuta ku likamba ku nyonga no mulenen̄i no Magadani. ");
INSERT INTO lyn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Cwale Afalisi anjili na Saduki sebeli aiya, mukweteka Jesu oku mukumbela nji aamonise sisupo no makazo itunda ku wilu. ");
INSERT INTO lyn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kono Jesu sebeli waatambula nji, “Aba ku tenda amangolwaa, kame mwamba nji, ‘Mba kupi wino, kakuli eliwilu nilya mucaa.’ ");
INSERT INTO lyn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Cwale ba nako no masiku kame mwamba nji, ‘Balelo ombula mba pumu, kakuli eliwilu kame limonahala amakumbi no mbula.’ Kame mu limukile oku toloka esisupo no liwilu, kono kamu twese oku toloka esisupo no tinako. ");
INSERT INTO lyn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Olusika no kwiiba no kwapumena kame lukumbela esisupo, kono kakwisa esisupo salu biwe, konji esisupo sa Jonasi.” Mi sebeli waa siya, oukutela. ");
INSERT INTO lyn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cwale aiyetwa aba ana kukeela mu linjaliya, kame ana ku pulama okushimba einkwa. ");
INSERT INTO lyn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesu sebeli wamba kwa onyene nji, “Mu tokomele mi mumamele omumena no Afalisi na Saduki.” ");
INSERT INTO lyn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Cwale sebeli akwambota mu kacikoo nji, “Kame amba ngesi kakuli katwasi shimba einkwa.” ");
INSERT INTO lyn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kono Jesu naku limuka eyo ana kwambanga aanu mi sebeli wamba nji, “Anyi asitumelo icana, iikene aba mwamba eyi no kwa shimba einkwa? ");
INSERT INTO lyn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ninji musili ano kwayupisisa? Ka mwa sipuluka einkwa mutanu (5) eyi ina kufepa aanu ana ku tenda eikiti mutanu (5,000) ni palo no matanda mu na kwiyata oungululwa? ");
INSERT INTO lyn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Simba einkwa mutanu ni yiili (7) eyi ina kufepa aanu ana ku tenda eikiti inee (4,000) ni palo no matanda muna kwiyata oungululwa? ");
INSERT INTO lyn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ngasibine aba mukwangwa okuyupisisa nji kanisi kwamba eyi no inkwa? Mumamele omumena no Afalisi na Saduki.” ");
INSERT INTO lyn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Cwale aiyetwa sebeli ayupisisa nji kaa si kwaambela nji amamele omumena obekiwangwa mu sinkwa, kono neli nji amamela etuto no Afalisi na Saduki. ");
INSERT INTO lyn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cwale Jesu aba ana kukeela mu sibaka no Sesaliya Filipi, sebeli oibanguta aiyetwa aye nji, “Aanu kame amba nji Omwana no munu nanyine?” ");
INSERT INTO lyn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Cwale aiyetwa sebeli amba nji, “Anjili kame amba nji tiwe Jowani omukolobezi, anjili nji Tiwe Eliya, anjili nji, Tiwe Jelemiya, simba omunjili no anuhi anjili a Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesu sebeli wamba kwa onyene nji, “Anyi, kame mwamba nji time anyine?” ");
INSERT INTO lyn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Pitolosi sebeli otambula nji, “Tiwe Kilesite, Omwana Nyambe noku Yoya.” ");
INSERT INTO lyn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Cwale Jesu sebeli omu tambula nji, “Kame oli ni mbuyoti, wene Simoni omwana Jona!” Kakuli kasa nyama ni unyinga, kono ni sitange na kuwilu ona ku shootwele eyo. ");
INSERT INTO lyn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mi kame ni kwambela nji, tiwe Pitolosi eliwe basa ni yake Ekeleke yange, mi amaata no lufu katamba okwikoma. ");
INSERT INTO lyn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kame sani kube etinotolo no mubuso naku wilu, mi esi so nunge sonje mu litunga, mbasi nungiwa niku wilu, mi esi so lukulule sonje mu litunga mbasi lukululwa niku wilu. ");
INSERT INTO lyn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Cwale Jesu sebeli olaela aiyetwa nji alese okwambela omunu nji yokame Kilesite. ");
INSERT INTO lyn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ku tunda ba nako eyo, Jesu sebeli otangisa okutoloka kwa iyetwa aye nji, “Kame afanene okuta ku Jelusalema, ayupiswe okukola no kuneneba mu makaa no akulu na pulisita akulu na iyeti no milawo, mi aibaiwe, mi ainguke ba liywaa no waatu.” ");
INSERT INTO lyn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Cwale Pitolosi sebeli otwala Jesu ku nyonga akamu kalimela nji, “Mbumu! Nyambe akuyoyise kweyi einu ilese okutendahala kwa wene.” ");
INSERT INTO lyn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kono Jesu sebeli okusetuka ni kwambela Pitolosi nji, “Otunde kwa mene, weme osatani, kame oli esisitataliso kwa mene, kakuli kaunahana omo anahanela Nyambe, kono kame onahana kanyi omo anahanela aanu.” ");
INSERT INTO lyn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Cwale Jesu sebeli wambela aiyetwa aye nji, “Omunu aba asinga okuni kon̄a, kame afanena oku toboha, ashimbe esifapano saye, mi ani kon̄e munyima. ");
INSERT INTO lyn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwawo onje asinga oku yoyisa omooyo woo, kame sau sinyehelwe, kono omunu yonje woyo sosinyehelwa omooyo waye mulibaka lyange, mbauwana. ");
INSERT INTO lyn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kame saku tuse iikene omunu aba sa luwe elitunga lyonje, mi sebeli osinyehelwa omooyo waye? Simba iikene sabe nji ausetwe omooyo waye? ");
INSERT INTO lyn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Omwana no munu kame saiye mu kanya ya sitaye, ni mangeloi aye, mi mbabi omunu ni munu omupuzo kwesi ana tende. ");
INSERT INTO lyn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Niti luli kame nimyambela nji kwaa aimanine muno, kame kuli anjili awo sa ulwe okufa, konji amone oweli Omwana no Munu yo keyile mu mubuso waye.” ");
INSERT INTO lyn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Maywaa mutanu ni limweya (6) aba ana kubwa, Jesu sebeli oshimba Pitolosi ni Jakobo, ni Jowani minaye, mi sebeli waatwala ba lilundu no kuleba nji akaikalebo omboci. ");
INSERT INTO lyn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Cwale Jesu sebeli ofutuka bo lubala loo, olubala lwaye sebeli lubenya kanyi eliywaa, mi eikumango yaye sebeli ifutuka okutenda eyi no likena tooo. ");
INSERT INTO lyn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ababo sebeli kumonahala Mushe ni Eliya alemine okwamba ni Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Cwale Pitolosi sebeli wamba kwa Jesu nji, “Mbumu, kame sa kuwabe aba sa twikale bano. Aba so singe kame sani tende eitebule yaatu, esinjili sitende sowe, esinjili sa Mushe, esinjili sa Eliya.” ");
INSERT INTO lyn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Yo samba, ababo elikumbi no kubenya sebeli lyaa fuka, mi sebeli ku yupahala eliywi litunda mu likumbi, eli lyamba nji, “Woyo yo mwanange osingwa, woyo ni katelwa, mu muyupe.” ");
INSERT INTO lyn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cwale aiyetwa aba ana kuyupa eyi, sebeli acila onene mane nikukwa aalikete banji. ");
INSERT INTO lyn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kono Jesu sebeli oiya, ni kwalema, yo amba nji, “Mwimane, mi mulese kucila.” ");
INSERT INTO lyn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Cwale aba ana kwaliketa ku wilu kasi kumona omunu konji Jesu feela. ");
INSERT INTO lyn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Aba ana shetumukanga oku tunda ba lilundu, Jesu sebeli waa laela nji, “Mulese okwambela omunu eyi muna mono, konji Omwana no Munu aba sa inguke kwaafu.” ");
INSERT INTO lyn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Cwale aiyetwa sebeli aibanguta Jesu nji, “Iikene asi kun̄ola aba amba nji, Eliya kame afanena okwiiya oweli?” ");
INSERT INTO lyn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesu sebeli waa tambula nji, “Eliya niti luli kame afanena okwiiya oweli nji abaakanye einu yonje.” ");
INSERT INTO lyn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kono kame ni myambela nji, “Eliya na kwiiya, mi kasi kumu limuka, mi kame ana tende omu ana saelele monje kwa yonyene. Mundila imweya Omwana no munu niyonyene mba yandisiwa ngeeso kwa onyene.” ");
INSERT INTO lyn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Cwale aiyetwa sebeli ayupisisa nji kame ana kwaambela eya Jowani omukolobezi. ");
INSERT INTO lyn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cwale Jesu na iyetwa aye aba ana kuuka kwaanu no kupula, omulume sebeli oiya kwa yonyene, sebeli omu kubamena balubala, ");
INSERT INTO lyn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ni kwamba nji, “Mbumu, oyupele mwanange amakeke, kakuli kame akola oweti no kukwa, mi kame ayanda onene, kakuli aka no kupula kame akwelanga mu mulilo ni mu meyi. ");
INSERT INTO lyn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Cwale Kame nina muliti kwa iyetwa owe, kono kasi twesa okumu balisa.” ");
INSERT INTO lyn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu sebeli otambula nji, “Anyi olusika no kwa pumena, no kwiiba, kame sani ikale naanyi enako ikuma babine? Kame kubambabile onene okwikala nimucima no kutatelela kwaanyi? Mu mulite kwa mene.” ");
INSERT INTO lyn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesu sebeli okalimela onene emebo no kwiiba, mi emebo sebeli itunda mwa woyo ondumbana, mi sebeli obala mu yonyene enako eyo. ");
INSERT INTO lyn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Cwale aiyetwa sebeli aiya kwa Jesu ku mukunda ni kwamba nji, “Iikene aci aba katwasi twesa okucita eyo emebo no kwiiba?” ");
INSERT INTO lyn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesu sebeli wamba kwa onyene nji, “Kakuli etumelo yenu ni icana onene.” Niti luli kame ni myambela nji, “Kambe kame muli ni tumelo eyi ilikana ni mbuto no masitete ku kuneneba, simba aba sa mwambele elilundu elyo nji, ‘Otunde bano oshimbulukele baya,’ kambe kame lishimbuluka, mi kambe kakwisa esi sasi kwangwiwe kwaanyi.”  ");
INSERT INTO lyn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kono emebo no mufuta owo ka itundu, konji ni tapelo nuuku yumena eilya.” ");
INSERT INTO lyn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Aba akuwanine mu Galileya, Jesu sebeli wamba kwa onyene nji, “Omwana no munu kame sa betekiwe, abiwe mu maoko no aanu ");
INSERT INTO lyn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","mi kame sa mwiibae, kono mu liywaa no waatu, mba inguka.” Cwale aiyetwa sebeli aena onene. ");
INSERT INTO lyn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cwale aba ana kukeela mu kapenauma, asiku telisa aanu amali no keleke sebeli aiya kwa Pitolosi, sebeli amba kwa yonyene nji, “Ninji omwiyeti wenu ka tele omutelo no Ndoo ya Nyambe?” ");
INSERT INTO lyn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Cwale Pitolosi sebeli otambula nji, “Ee,” kame atelanga. Cwale Pitolosi aba ana kwingena mu ndoo, yo kasamba kale Jesu sebeli wamba kwa yonyene nji, “Iikene onahana Simoni? Kana ambumu no litunga kame ashimbanga omutelo kwanoo, nji kwa njili feela?” ");
INSERT INTO lyn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Cwale Pitolosi sebeli otambula nji, “Kwaanu feela,” Cwale Jesu sebeli wamba kwa Pitolosi nji, “Aana kandi kame alukuluhile. ");
INSERT INTO lyn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nji cwale tulese okwafoseza, ote ku liwate, okakondele akashuto mu meyi, mi oshimbe ondi so leme oweli, aba omuyaamisa mu kanwa, kame so wane amali no muwayawaya. Wa shimbe mi waabe wo, otenda omutelo wange ni wowe. ");
INSERT INTO lyn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mu nako eyo aiyetwa sebeli aiya kwa Jesu ni kumwibanguta nji, “Uyu no kuneneba luli mu mubuso naku wilu anyine?” ");
INSERT INTO lyn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesu sebeli oisana omwanukana, niku mu beeka bakaci koo ");
INSERT INTO lyn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ni kwamba nji, “Niti luli kame ni myambela, nji kamufutuka okufeka kanyi mwanukana, kamu tamba okwingena mu mubuso naku wilu. ");
INSERT INTO lyn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Cwale abo omunu yonje so kushuwa kanyi omwanukana wuyo, yo munene mu mubuso naku wilu. ");
INSERT INTO lyn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mi woyo otambula omwanukana kanyi wuyo mu litina lyange, kame ani tambula. ");
INSERT INTO lyn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kono woyo so sitatalisa omunjili kwa nukana awo apumena kwa mene, esi no kuwaba kwa yonyene nikumu nungelela eliwee no kuneneba mu ndingo mi akondelwe aba no kutunga no liwate. ");
INSERT INTO lyn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Oumai ku litunga, mulibaka no inu eyo yasitatalisa, einu eyi isitatalisa aanu mbai iyi, kono oumai niwa woyo otendisa aanu okutenda esibi. ");
INSERT INTO lyn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nji elyoko lyowe simba elikondo, kame liku sitatalisa, oli patule mi oli kondele okuno kuleba. Esiwa kwa wene ninji oingene mu mooyo ni lyoko limweya, simba elikondo limweya, kasa wokwite amaoko ayili, simba amakondo ayili ni kukondelwa mu mulilo no kwa tima. ");
INSERT INTO lyn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mi elitiyo lyowe aba liku sitatalisa, oli tundisemo, olikondele oku no kuleba. Esiwa kwa wene naba so ingene mu mooyo me oli ni litiyo limweya, kasa okwikala ni miyo ayili niku kondelwa mu mulilo no lihele. ");
INSERT INTO lyn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mu tokomele, mulese okunyefula mumweya kwa nukana awo, kakuli kame namba kwaanyi nji ku wilu amangeloi oo kame a mona mu nako yonje olubala lwa sitange woyo oli ku wilu. ");
INSERT INTO lyn_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kame namba ngesi kakuli Omwana no munu neeyi muku yoyisa esi si taukile. ");
INSERT INTO lyn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Omu mu yambutela ni ngaibi? Nji omunu kame akwite emikoko no kukwana omwanda (100), mi sebeli kutauke mumweya, kana katwese okusiya ba malundu eyi no kukwana makumi mutanu naanee ni mutanu ni tunee. (99) nji aka saele owo ona tauka? ");
INSERT INTO lyn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Niti luli kaama ni myambela nji, aba sauwane kame sa wabelelwe onene mwa yonyene okubita eyo no kukwana makumi mutanu naane ni makumi mutanu ni tunee (99). ");
INSERT INTO lyn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mu ndila imweya kasa omwasingela Sitenu woyo oli ku wilu nji ku tauke omunjili kwa anukana awo. ");
INSERT INTO lyn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nji omukowe naku foseze, ote kwa yonyene oka mwambele yoikalile yomboci. Aba sa kuyupe, naumuusu okutenda omukowe. ");
INSERT INTO lyn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kono nji kaku yupu, oshimbe kame mumweya simba ayili ni wene, nji etaba yonje ipakiwe kwaanu ayili simba aatu. ");
INSERT INTO lyn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Cwale nji ka yupu awo, wambele ekeleke mi aba akana okuyupa simba ekeleke, atende kwa wene kanyi omunu no kwa limuka Nyambe simba omutelisi. ");
INSERT INTO lyn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Niti luli kame ni myambela nji, eyi sa mununge yonje mu litunga, kame sa inungiwe ku liwilu, mi eyi sa mu lukulule yonje mu litunga, mbai lukululwa mu liwilu. ");
INSERT INTO lyn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kame nisi myambela nji ayiili kwaanyi aba akuyupa banji einu yonje eyi akumbela, kame sabiwe kwa Sitange naku liwilu. ");
INSERT INTO lyn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kame namba eyi kakuli omo kuli ayiili simba aatu aa aku wanine mu litina lyange, kame nili noo mukaci koo. ");
INSERT INTO lyn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Cwale Pitolosi sebeli oiya kwa Jesu ni kwamba nji, “Mbumu, omwabange aba ani foseza, kame sa ni mu lemene tunjinga? Ninji ku tende mutanu ni twiili (7)?” ");
INSERT INTO lyn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu sebeli wamba kwa yonyene nji, “Kani kwambele oku lemena mutanu ni twiili (7), kono makumi mutanu na yiili (70) aba itaimisiwa mutanu ni twiili (7). ");
INSERT INTO lyn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mulibaka elyo, omubuso naku wilu kame ufekile kanyi abo Ombumu aba asinga nji abika aye amuteneke amali aye. ");
INSERT INTO lyn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aba na tateka okushimba amali, sebeli alita omunjili ona kumu kolotela amasaka no mali akwana olule no mali no kupula. ");
INSERT INTO lyn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Omubika owo kame ana kuulwa esi sa teneke, ombumu waye sebeli olaela nji aulisiwe, bamweya ni mukatayaye naa naye, neyi akwite yonje nji ateneke esikoloti. ");
INSERT INTO lyn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Omubika sebeli omu kubamena balubala lwaye ni kwamba nji, ‘Mbumu, oni tende esishemo,’ mi mba ni ku usete esikoloti sowe sonje.’ ");
INSERT INTO lyn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ombumu sebeli omu yupela amakeke ni kumu lukulula, mi sebeli omu lemena esikoloti. ");
INSERT INTO lyn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kono omubika woyo aba ana ku tunda abo, sebeli okuwana ni mukwaye mubika woyo ana ku luwiwa naye, ona ku mu kolotela amali no kucaniba. Sebeli omu lema niku moowa yoamba nji, ‘Oniteneke esikoloti sange.” ");
INSERT INTO lyn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Cwale woyo omukwaye mubika no sikoloti saye sebeli okwa ni manwi, ni kumu kumbela nji, ‘Onifele amakeke mba ni kuteneke esikoloti sowe!’ ");
INSERT INTO lyn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kono sebeli okana niku mwingenyeka mu tolongo oku twala ba nako saka tenekele esikoloti. ");
INSERT INTO lyn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cwale akwaye abika aba ana kumona esi ana kutenda, sebeli aena onene, nukambela ombumu woo eyi ina tendahala yonje. ");
INSERT INTO lyn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Cwale ombumu waye, sebeli omu tumena aanu okamwisana ni kumwambela nji, ‘Wene omubika no kwiiba, kame nina kuleselele esikoloti sowe sonje kakuli kame ona kuni kumbela. ");
INSERT INTO lyn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kame ona fanene okuyupela omukowe amakeke kanyi omo nina kuku yupelela amakeke. ");
INSERT INTO lyn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Cwale mu kutina onene ombumu waye sebeli omuba mu maata no atukufazi no tolongo nji amu yandise oku twala ba nako saka tenekele esikoloti sonje. ");
INSERT INTO lyn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Eyo yasatende Sitange naku wilu ku munu ni munu woyo oulwa oku lemena omwabaye etifoso taye, okutundelela kunji no mucima waye wonje. ");
INSERT INTO lyn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Cwale Jesu aba ana kumana okwamba amaywi aa, sebeli otunda mu Galileya mi sebeli oiya mu tolopo no Judeya, eyi ili mu linjaliya no Jodani. ");
INSERT INTO lyn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aanu no kupula onene sebeli amukon̄a, mi sebeli waa balisa oko. ");
INSERT INTO lyn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Afalisi nonyene sebeli aiya kwa Jesu muku mweteka okwamba nji, “Ninji omulume na pumenenwe okulukulula mukataye, mulibaka no mubonda wonje?” ");
INSERT INTO lyn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesu sebeli otambula nji, “Kamusibala mu man̄olo nji ku simuluho omuumbi kame ana kutenda aanu omulume ni mukati? ");
INSERT INTO lyn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mi Nyambe sebeli wamba nji, ‘Mulibaka eli, omulume mba siyi sitaye ni inawaye, akumalele mukataye, mi ayili mba tende enyama imweya.’ ");
INSERT INTO lyn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Cwale kasa ayili, kono sebeli nyama imweya feela. Cwalehe, Nyambe eyi ana waneke bamweya, omunu alese okwitaba.” ");
INSERT INTO lyn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Afalisi sebeli amba kwa yonyene nji, “Cwale iikene Mushe aba ana kutu laela okuba omukati elin̄olo no kulukulula ni ku mulukulula? ");
INSERT INTO lyn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesu sebeli wamba kwa onyene nji, “Neli mulibaka no koongola emicima kwenu, nji mane Mushe sebeli omipumenena okulukulula akatenu. Kono ku simuluho kakwasi ku tendiwangwa ngeeso. ");
INSERT INTO lyn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mi kame namba kwaanyi nji, “Woyo yonje so lukulula omukataye ni kukwata mundina kame abuka. Omulume kame atwesa okulukulula mukataye nji kame na waniwa yo tenda ouhule.” ");
INSERT INTO lyn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aiyetwa aye sebeli amba kwa yonyene nji, “Cwale nji mokwikalele ngeso omulume kwa mukataye, ouwa ni kwaa kwata.” ");
INSERT INTO lyn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kono Jesu sebeli wamba kwa onyene nji, “Kasa aanu onje aa atwesa oku tambula etuto eyi, kono konji feela kwaawo ana pumenenwe kwa Nyambe okutambula. ");
INSERT INTO lyn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kame kuli amabaka no kupula abo alume anjili katwese okukwata. Alume anjili kame ana kuleiwa yongeso nambulwa okwikala naana. Anjili kame ana kutendiwa ngeso kwakoo aanu, mi alume anjili kaakwata mulibaka no mubuso naku wilu. Woyo otwesa yonje atambule etuto eyi.” ");
INSERT INTO lyn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Cwale aanu sebeli alita aanuke anyonyo kwa Jesu nji aabeeke amaoko, mi aa lapelele. Aiyetwa aye sebeli aayuta ana kwa lita. ");
INSERT INTO lyn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kono Jesu sebeli wamba kwa onyene nji, “Mulesele anukana aiye kwa mene mi mulese okwa kanisa okwiiya kwa mene, kakuli Omubuso naku wilu, kame oli kwaanu akufekile kanyi aa anuke.” ");
INSERT INTO lyn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Cwale Jesu sebeli waa beeka amaoko nuukutela. ");
INSERT INTO lyn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Cwale omulume munjili sebeli oiya kwa Jesu ni kwamba kwa yonyene nji, “Mwiyeti, esiwa sani tende ni sibine nji nika wane omooyo no kwaabwa?” ");
INSERT INTO lyn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesu sebeli otambula nji, “Iikene oni ibanguteta eyi no uwa? Omuwa ni Nyambe mumweya feela. Nji kame osinga okwingena mu mooyo, omamele emilawo.” ");
INSERT INTO lyn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ondumbana woyo sebeli oibanguta Jesu nji, “Ibine emilawo eyo?” Jesu sebeli wamba nji, “Olese kwibaa, Olese kubuka, Olese kwiita, Olese ku paka eyi no mapwa, ");
INSERT INTO lyn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","okuteke sitowe ni inaowe, mi osinge omukowe kanyi omo ukusingela wenyene.” ");
INSERT INTO lyn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ondumbana sebeli wamba kwa Jesu nji, “Eyo yonje kame ni imamele, iikene nisi ulwile?” ");
INSERT INTO lyn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesu sebeli wamba kwa yonyene nji, aba usinga okutenda woyo no kupetahala, ote mi okaulise eyi oluwile yonje, mi otabele afuzana amali, mi mbuikala ni ufumu naku wilu. Cwale oiye oni kon̄e. ");
INSERT INTO lyn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Cwale ondumbana aba ana kuyupa ngeeso, sebeli okutela yo enine, kakuli kame ana kuluwa eyi no kupula onene. ");
INSERT INTO lyn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Cwale Jesu sebeli wamba kwa iyetwa aye nji, “Niti luli kame ni myambela nji, mba kubambaba onene omunu no kuluwa okuingena mu mubuso na kuwilu. ");
INSERT INTO lyn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kame nisi myambela nji, nikwa kwakotoba ekamele aba saiingene mu litiyo no ndonga, okubita osi kuluwa akaingene mu mubuso wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Cwale aiyetwa aba ana kuyupa ngeeso sebeli akomoka onene ni kwamba nji, “Nji mokwikalele ngeesi cwale anyine soka yoyisiwa?” ");
INSERT INTO lyn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesu sebeli waaliketa ni kwamba nji, “Kwaanu kame kukwangwiwa, kono kwa Nyambe einu yonje kame itwisahala.” ");
INSERT INTO lyn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Cwale Pitolosi sebeli omu tambula nji, “Omone aci natu lesele einu yonje mi natuku kon̄o. Cwale iikene satuwane aci?” ");
INSERT INTO lyn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesu sebeli otambula nji, “Niti luli kame ni myambela nji, “Cwale elitunga aba salitendiwe oubya, cwale Omwana no munu aba saikale ba lubona no kanya yaye, anyi muna nikon̄o kame sa mwikale naanyi ba mabona likumi na yiili (12), mi mu atule amasika no Isilaele likumi na yiili (12). ");
INSERT INTO lyn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Cwale omunu yonje woyo onasiyi etindoo, simba amandaye, simba inawaye, simba sitaye simba aana ni matema aye mulibaka no litina lyange, kame sa tambule onene oku bitelela omwanda, mi kame salye esanda no mooyo no kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kono ano kupula ali ku lubala, mba tende aa na munyima, mi aa na munyima asatende aa na ku lubala. ");
INSERT INTO lyn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesu sebeli otwalelela okwamba omo wikalele omubuso naku wilu nji, “Eliywaa linjili amasiku omulume sebeli ota mukwisanena abeleki mu litema lyaye. ");
INSERT INTO lyn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Munyima no kulumelelana nabeleki okwabaanga etifo no baliywaa, mi sebeli waa tuma mu litema lyaye no beine oka sebeza. ");
INSERT INTO lyn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Cwale sebeli ota kame ba musika amasiku enako aba ina kutenda mutanu ni tunee (09:00) mi sebeli omona anjili aimanine feela nambulwa omusebezi, ");
INSERT INTO lyn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","mi sebeli wamba kwa onjene nji, “Mute naanyi mu litema no beine muka sebeze, mi mbani mibi esi silukele.” ");
INSERT INTO lyn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Cwale sebeli ata. Mi aba ana kuuka kame ku musika mu nako no munji eliywaa elili ba kaci no mutwi ni mangolwaa kuma 3 okoloko (15:00) sebeli otenda yongeso. ");
INSERT INTO lyn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mi aba ina kusinga okwana 5 okoloko (17:00) sebeli ouka ku musika nuukawana anjili aimanine, mi sebeli wamba kwa onyene nji, ‘Iikene mwimanene bano eliywaa lyonje nambulwa esi mutenda?’ ");
INSERT INTO lyn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Cwale aanu sebeli amba kwa yonyene nji, ‘Kakuli kakwisa woyo ona tubi omusebezi. Mi sebeli waambela nji, ‘Mute naanyi mu litema lyange no beine muka sebeze.’ ");
INSERT INTO lyn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Enako no mangolwaa aba ina kukeela, omunya litema no beine, sebeli wamba ku mwendisi no musebezi waye nji, ‘Oisane abeleki, mi waabe etituwelo too, otangise kwaa ana ingene munyima, otwale kwaa ana ingene ba weli.’ ");
INSERT INTO lyn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Cwale awo ana kwingena omusebezi, aba ina kukwana enako no 5 okoloko (17:00), omunjili ni munjili sebeli otambula etuwelo yaye eyi no ba liywaa. ");
INSERT INTO lyn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Cwale awo ana kwingena ba weli aba ana kwiiya, kame ana ku yambuta nji kame sa biwe onene, kono nonyene sebeli abiwa kanyi akoo. ");
INSERT INTO lyn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cwale aba ana kumana okutambula, sebeli ahalala ku munya litema no beine. ");
INSERT INTO lyn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Cwale aanu awo sebeli amba nji, ‘Aa ana ingene munyima, kame ana sebeze ehola imweya feela, mi nwaabi kanyi aci tuna shimbi okulema ni liywaa ni kubya kwa lyo.’ ");
INSERT INTO lyn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kono omunya litema sebeli otambula omunjili no kwawo nji, ‘Mulikani, kani sikoonga, ninji kawa siku kuyupa ni mene nji mbubelekele amali no ba liywaa limweya? ");
INSERT INTO lyn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Oshimbe sowe esi sikulukele mi okutele. Meene kame ni keta okuba woyo ona kwisaniwa munyima kanyi omo nina bele wene. ");
INSERT INTO lyn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kana kani sipumenenwa okutenda eso nisinga okutenda ku mali ange? Nji kame oyupa omuna kakuli kame nili ni lyoko no koloka eli liba?’ ");
INSERT INTO lyn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mumukwanongeso, “Aa na munyima mba tende aa na ku lubala, mi aa na ku lubala mba tende aa na munyima.” ");
INSERT INTO lyn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cwale Jesu yota ku Jelusalema, sebeli oshimbela kunyonga aiyetwa no kukwana likumi na yiili (12), mi sebeli wamba kwa onyene nji, ");
INSERT INTO lyn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Komu mone, kame tu katile ku Jelusalema, mi Omwana no munu kame sa biwe mu maata no apulisita akulu, na iyeti no mulawo mi mba mwa tulele elifu, ");
INSERT INTO lyn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","mi mba beekiwa mu maoko no macaba nji mu shubule, amushape ni kumu ngongotela ba sifapano, mi mba ingulwa ba liywaa no waatu.” ");
INSERT INTO lyn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Cwale mukataye Zebedeya sebeli oiya kwa Jesu na naaye ayiili no andumbana, mi sebeli akubama niku kumbela simweya kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesu sebeli wamba kwa yonyene nji, “Iikene osaela?” Omukati sebeli wambela Jesu nji, “Oni sepise nji anange ayiili, akwikale omunjili kulyooko lyowe no silyo, omunjili kweli no simoo, mu mubuso owe.” ");
INSERT INTO lyn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kono Jesu sebeli otambula nji, “Ka muyii esi mu kumbela.” Ninji kame mu twesa oku nwena mu komoki no mayando eyi ni tatelele oku nwena? Sebeli amba kwa yonyene nji, “Kame tutwesa.” ");
INSERT INTO lyn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesu sebeli wamba kwa onyene nji, “Luli mba mu nwene mu komoki yange, kono oku niikala kweli no silyo, simba kweli no simoo, kasa mene woyo so keta awo saniikale ku lyoko no silyo simba kweli no simoo, kono eyo eibaka niyaawo ana lukisetwe ngeeso kwa sitange.” ");
INSERT INTO lyn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Cwale anjili aiyetwa aye aba ana kuyupa eyo, sebeli atinena Jacobo ni minaye. ");
INSERT INTO lyn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kono Jesu sebeli waisanena kwa yonyene ni kwamba nji, “Kame muyii nji abusi no macaba kame akwite amaata beulu yoo, mi awo ali mu itulo no kuneneba kame abusa mu kutweba. ");
INSERT INTO lyn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kono kaku fanene okwikala ngeeso mukaci kenu. Woyo yonje osinga oku tenda woyo no kuneneba mukaci kenu, atende omubika kwaanyi moonje, ");
INSERT INTO lyn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","mi woyo yonje osinga okutenda woyo no weli, atende omubika kwaanyi, ");
INSERT INTO lyn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","kanyi Omwana no munu kasiiya nji abelekelwe, kono abelekele aanu, ni kuba omooyo waye nji aanu no kupula aliululwe.” ");
INSERT INTO lyn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ababo Jesu na iyetwa aye aatunda mu Jeliko, aanu no kupula-pula sebeli amu kon̄a. ");
INSERT INTO lyn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Eibofu yiili kame ina kwikalanga kunyonga no ndila. Aba ina kuyupa nji Jesu kame abita, sebeli ikuwa nji, “Mbumu, mwana Dabida, otu yupele amakeke!.” ");
INSERT INTO lyn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ano kupula sebeli aayuta nji aondoke, kono onyene sebeli aekeza okukuwa nji, “Mbumu, Mwana Dabida, otu yupele amakeke!” ");
INSERT INTO lyn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesu sebeli oimana, nikwaisana, mi sebeli waibanguta nji, “Siikene musaela nji nimi tendele?” ");
INSERT INTO lyn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Eibofu sebeli itambula Jesu nji, “Mbumu amiyo etu amone!” ");
INSERT INTO lyn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesu sebeli waa yupela amakeke ni kwalema ba miyo oo. Mi mu wangu-wangu sebeli amona niku mukon̄a. ");
INSERT INTO lyn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Cwale aba ana kukeela kunyonga no Jelusalema, sebeli aiya ku Betefage, ba lilundu no itondo no olibe, Jesu sebeli otuma aiyetwa aye ayiili, ");
INSERT INTO lyn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ni kwaambela nji, “Mute mu mundi ou mwa likete, mi mu muwanguwangu mba mu wana embongolo ina fungiwa ni mwana yo, mutu fungulule, mi muni litele to. ");
INSERT INTO lyn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nji omunu yonje kame sa miibanguta, mu mwambele nji, ‘Ombumu kame atusaela, mi mu wangu mba mi pumenene okutu lita kwa mene.” ");
INSERT INTO lyn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Etaba eyo na kame ina kutendiwa nji ku tendahale esi sina kwambiwa kwa munuhi wa Nyambe Isaya nji, ");
INSERT INTO lyn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mwambele omulenen̄i no Sione nji, Omone, Ombumu wowe uno, Uyu okukokobelize yo ikalile ba mbongolo akana no kambongolo.” ");
INSERT INTO lyn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aiyetwa aye sebeli ata, nuu katenda eso ana kwaambela Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Sebeli a lita akambongolo ni mwana ko, sebeli ayala eikumango yoo ba tonyene, mi Jesu sebeli otinabo. ");
INSERT INTO lyn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Cwale aanu no kupula sebeli ayala eikumango yoo mu ndila, anjili sebeli atema emitayi no itondo ni kwiiyala mu ndila. ");
INSERT INTO lyn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Cwale aanu no kupula ana kwenda ku lubala, nawo ana kumu kon̄anga, sebeli akuweleza nji, “Hosanna kwa Mwana Dabida! Ku lumbekwe woyo oiya mulitina lya Mbumu! Etumbo ikale ku mawilu naku liwilu!” ");
INSERT INTO lyn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cwale Jesu aba ana kwingena mu Jelusalema, omundi onje sebeli wimana amaefe-efe, mi sebeli aibanguta nji, “Anyine wuyu?” ");
INSERT INTO lyn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Cwale aanu no kupula sebeli amba nji, “Ya Jesu, omunuhi wa Nyambe mi kame atunda mu Nazaleta no Ngalilea.” ");
INSERT INTO lyn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesu sebeli wingena mu lilapa no ndoo ya Nyambe, mi sebeli ocitela kundee aanu onje ana kuulisetangamo ni kuula, sebeli okwisa etitafule ta siku cinca amali, ni ipula no awo asi kuulisa otunkwilimba. ");
INSERT INTO lyn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesu sebeli wamba kwa onyene nji, “Kame kuna n̄oliwa mu man̄olo nji,‘Endoo yange mba iisanwa endoo no milapelo,’ kandi anyi na mwitende amakundamo no ambuyi!” ");
INSERT INTO lyn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Cwale sebeli kwiiya kwa yonyene mu lilapa no Ndoo ya Nyambe eibofu ni iyanga, mi sebeli waabalisa. ");
INSERT INTO lyn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kono apulisita no akulu na iyeti no milawo, aba ana kumone eyi no kukomokisa eyi ana kutenda, naana alemine oku kuwa mu lilapa no Ndoo ya Nyambe amba nji, “Hosanna kwa Mwana Dabida!” Mi sebeli atina onene. ");
INSERT INTO lyn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Cwale sebeli amba kwa Jesu nji, “Ninji kame oyupa eyamba aamba?” Jesu sebeli otambula nji, “Ee, anyi kamusi kubala mu man̄olo nji, namwiyete aana nawo ayamwa okumiba emilumbeko?” ");
INSERT INTO lyn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Cwale Jesu sebeli waasiya okutunda mu mulenen̄i nikuta ku Beteni, mi sebeli oka langanamo. ");
INSERT INTO lyn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Amasiku Jesu youka ku mulenen̄i, sebeli oyomba. ");
INSERT INTO lyn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Cwale aba ana kumona esitondo no feiga ku nyonga no ndila, sebeli otako ku sitondo, kono kasiku wanako eyi no kulya, konji amamuna feela. Sebeli wamba ku sitondoo nji, “Ku lese oku monahala efeiga kwa wene, okuta oku no kwabwa!” Ababo esitondo no Feiga sebeli si kukuta. ");
INSERT INTO lyn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aaiyetwa aye aba ana ku mona ngeeso, sebeli akomoka ni kwibanguta nji, “Esi sitondo no Feiga ngasibine sina kukuta mu wangu-wangu?” ");
INSERT INTO lyn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Cwale Jesu sebeli waa tambula nji, “Niti luli kame ni myambela nji, “Kambe kame muli ni tumelo no kwiyala, kambe kame mutwesa okutenda kanyi omo nina tendele ku sitondo eso mane ni kubitelela. Kambe simba aba mwambela elilundu eli nji, “Otunde aba, okaku kondele mu liwate, kambe mbaku tendahala ngeseo.” ");
INSERT INTO lyn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mi einu yonje eyi sa mu kumbele mu tapelo, aba muli ni tumelo, kame sa mwi biwe. ");
INSERT INTO lyn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Cwale Jesu aba ana kwingena mu lilapa no Ndoo ya Nyambe ni kutangisa okwiyeta, apulisita akulu na kulu no sicaba, sebeli aiya kwa yonyene ni ku mwibanguta nji, “Otwambele oko itunda etukelo eyi okutusisa okutenda einu eyi? Mi anyine ona kubi etukelo eyi?” ");
INSERT INTO lyn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesu sebeli waa tambula nji, “Ni mene mba nimi ibanguta, aba samuni tambule, ni mene, mba ni myambele oko itunda etukelo eyi nikutusisa okutenda einu eyi. ");
INSERT INTO lyn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kubine ana kuwana Jowani etukelo no kukolobeza, kwa Nyambe nji kwaanu? Sebeli akukananisa mukaci koo nji, “Iikene sa twambe?” Cwale aba satu tambule nji, Kame itunda kwa Nyambe, yonyene kame sambe nji, cwale iikene aba ka mu siku pumena Jowani?” ");
INSERT INTO lyn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kono aba sa twambe nji, ‘Kame ina kutunda kwaanu, kame tu cila anu no kupula, kakuli onje kame ana kolwa nji Jowani neli munuhi wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Cwale sebeli atambula Jesu nji, “Aci katu yii.” Mi ni yonyene sebeli wamba kwa onyene nji, “Ni mene, ka nitamba ku myambela mu tukelo yanyine eyo nikutusisa okutenda einu eyi. ");
INSERT INTO lyn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Cwale iikene muyambuta okukumanenna neyi enguli? Omulume kame ana kwikalanga naana ayiili, sebeli wiiya ku woyo no weli ni ku mwambela nji, Mwanange, ote oka sebeze mu litema lyange no beine balelo.’ ");
INSERT INTO lyn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Cwale woyo sebeli otambula nji, “Sisingi.” Kono munyima nokukana sebeli obaka ni kuta. ");
INSERT INTO lyn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Cwale sitoo sebeli ota ku mwanaye omunjili sebeli oamba esinu simweya. Mi woyo sebeli otambula nji, ‘Kame nita Sitange,’ kono ka sikuta. ");
INSERT INTO lyn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kwaa ayiili, woyo ona tende esi ana ku singa sitaye ubine? Sebeli amba nji, “Woyo no weli.” Cwale Jesu sebeli wamba kwa onyenenji nji, “Niti luli, kame ni myambela nji, Asikutelisa naa kati no mahule mbaingene mu mubuso wa Nyambe okusiya anyi munyima. ");
INSERT INTO lyn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kame namba ngeesi kakuli Jowani nakwiya kwanyi mukumimonisa omo mufanena okwikalela ano kuluka, kono ka mwa siku mupumena, kono asikutelisa ni mahule nwa kati naa ku mupumena, kono anyi simba aba muna kumona ngeeso, ka mwa sikubaka nikumu pumena. ");
INSERT INTO lyn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Komu yupe enguli injili,” Kame kuna kwikalanga omunyaa litema woyo ona ku kuna elitema no beine mi sebeli oli sileleza ni lukwakwa, mi kame sebeli otombolamo elisima omo kuna kukamunenwanga eino okutunda kuitolwana, niku yaka etawala no mumameli. Sebeli olibeeka mu pabalelo nwo alimi, mi sebeli ota mu naha indina. ");
INSERT INTO lyn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Enako no ku kutula aba ina kusheteta, sebeli otumena abika aye kwasi kulima nji aka mushimbele etuwelo yaye no kutulo, ");
INSERT INTO lyn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","kono asi kulima sebeli alema abika aye nikufulabo mumweya ni kwibaabo omunjili, mi woyo no waatu kame sebeli amu pobaula ni mawee ni kumwibaa. ");
INSERT INTO lyn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kame sebeli otuma anjili abika, aa na ku bitelela aa no weli ku kupula, mi asikulima sebeli aatenda kanyi akoo aya no weli. ");
INSERT INTO lyn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ku mamaneneno sebeli otumako mwanaye kwa onyene, ni kwamba nji, “Mwanange mbaka mukuteke.” ");
INSERT INTO lyn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kono asikulima aba ana ku mono mwanaye, sebeli akwambela nji, ‘Uno yokame oshwana, twendenyi tu ka mwibaye, mi mbatu yolo esanda saye.’ ");
INSERT INTO lyn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sebeli amu lema, ni ku mu kondela ku ndee no litema no bine, mi sebeli a mwibaa. ");
INSERT INTO lyn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Cwalehe, omunya litema no beine aba asa iye, asikulima awo ngaibi omu saatendele? ");
INSERT INTO lyn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Sebeli amba kwa yonyene nji, “Kame sa aibae ouyi aanu awo no lunya, mi elitema no beine kame saa libeeke mu pabalelo ya sikulima andina, awo asa mube etuwelo yaye no kutulo.” ");
INSERT INTO lyn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesu sebeli wamba kwa onyene nji, “Kamu sibala mu man̄olo awo amba nji, ‘Eliwee ana yumbu asikuyaka, lokame eli lina futuka eli lyongotite elilulu no ndoo. Kame lina tendiwa ngeeso kwa Mbumu, Mm eyi mu miyo etu kame ikomokisa. ");
INSERT INTO lyn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mulibaka eli, kame namba kwaanyi nji, “Mba mu byanguliwa omubuso wa Nyambe, mi kame saubiwe esicaba sindina, esi sasi beeke embuya yaso.” ");
INSERT INTO lyn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Woyo so kwela ba liwee elyo, kame sa coke mi kame sa li pyate woyo sali kwele beulu. ");
INSERT INTO lyn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Apulisita akulu na falisi aba ana yupu etinguli eto, sebeli alimuka nji kame ti yuleka onyene, ");
INSERT INTO lyn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kame ana kusinga okumuleme, kono sebeli acila aanu nokupula, kakuli kame ana kupumena nji, Jesu kame atendile omunuhi wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesu kame sebeli otwalelela okwamba kwa kulu no mulawo naakulu no macaba mu tinguli nji, ");
INSERT INTO lyn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Omubuso na kuwilu kame uku fekile kanyi eso sina kutendahala abo ombumu aba ana kutendele mwanaye no mulume omukiti no makwala. ");
INSERT INTO lyn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Sebeli otuma abika aye nji aka isana awo ana kwisanenwa ku mukiti no makwala, kono sebeli akana okwiiyako. ");
INSERT INTO lyn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kame kabana tumako anjili abika nji, ‘Mukaambele ana kwisaniwa nji, “Nakulukisiwa omulalelo. Mi amapulu ange ni tingombe etinjili no kusuwa nati ibaiwa, mi einu yonje nai lukisiwa mwiye ku mukiti no makwala.” ");
INSERT INTO lyn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kono kasitwalako etingana sebeli akutele ku misebezi yoo, omunjili ku matema aye omunjili ku miulo yaye. ");
INSERT INTO lyn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mianjili sebeli alema abika aye okwa yandisa ni kwaibaa. ");
INSERT INTO lyn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ombumu sebeli otina mane ni ku tuma etimpi taye no masole nji aka yundise aanu no kwiiba nu ka cin̄a omulenen̄i woo. ");
INSERT INTO lyn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Cwale sebeli wamba kwabika aye nji, ‘Omukiti no makwala nau lukisiwa kono aanu nina isana kawaafanene. ");
INSERT INTO lyn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cwale mute ba mangana ndila mi mwambele omunu yonje sa muwane aiye ku mukiti no makwala.’ ");
INSERT INTO lyn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Abika awo sebeli ata mu tindila, mi sebeli aungeka aanu onje awo ana kuwana, ano kwiiba naa no kuwaba mi endoo no mukiti sebeli iiyala no angenda. ");
INSERT INTO lyn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kono cwale ombumu aba anaingena okamona ana memiwa ku mukiti, sebeli olemuha omulume nokwa ku manga olwambi no mukiti no makwala. ");
INSERT INTO lyn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mi sebeli wamba kwa yonyene nji, ‘Mulikani! ngaibi ona ingene muno me oulwile olwambi no mukiti?’ Kono omulume kakwisa eyi ana kwamba. ");
INSERT INTO lyn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Cwale ombumu sebeli wamba kwa beleki aye nji, ‘Mumu nunge ku makondo ni ku makaa, mumu kondele ku uwi na ku ndee, oko sakwikale okulila ni ku kweca amaeo.’” ");
INSERT INTO lyn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesu sebeli omanenena okwamba nji, “Aa no kupula naisaniwa, kono aa naketiwa na cana.” ");
INSERT INTO lyn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Cwale afaisi sebeli ata oka kuwana oku lela omo samu swaseze mu maywi aye. ");
INSERT INTO lyn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Cwale sebeli atuma aiyetwa awo kwa yonyene, naanu a Heloda, sebeli amba nji, “Mwiyeti, kame tu limukile nji weene kame uli wa niti, mi kame wiiyeta endila ya Nyambe okuta mu niti yayo, mi kaubilaele neyo amba aanu mi kumonisa esaluluti kwaanu. ");
INSERT INTO lyn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Otwambele, omo uyambuteta? Kana, kame ku lukela oku tundiseta Sezale omutelo nji kakulukele?” ");
INSERT INTO lyn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kono Jesu muku limuka eminahano yoo no kwiiba, sebeli wamba nji, “Anyi asikukuba! iikene munetekela? ");
INSERT INTO lyn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Muni monise omuwayawaya mutenekanga ku mutelo.” Sebeli amu litela wo. ");
INSERT INTO lyn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mi sebeli wamba kwa onyene nji, “Esifateho ni litina ilibo yaanyine?” ");
INSERT INTO lyn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Sebeli atambula nji, “Ya Sesale.” Cwale sebeli wamba kwa onyene nji, “Cwalehe, mube Sesale esi sili sa Sesale, mi mube Nyambe esi sili sa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cwale aba ana kuyupu ngeeso, sebeli akomoka niku musiya nuu kutela. ");
INSERT INTO lyn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kusili mu liywaa elyo Asaduki awo amba nji kakwisa okwinguka nwaafu, sebeli aiya kwa Jesu niku mwibanguta nji, ");
INSERT INTO lyn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mwiyeti, Mushe kame ana kwamba nji, ‘Omulume aba afa yoka kwite aana, minaye simba mukulwaye kame twesa oku kwata ombelwa, aleyeleko aana nji alitele omwabaye olusika.’ ");
INSERT INTO lyn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kwaaci naku kwikala aana no andumbana ana ku kwana mutanu na yiili (7), woyo no weli sebeli okwata nikufa yo kakwite omwana, mi woyo nomu kon̄elela munyima sebeli okwata ombelwa. ");
INSERT INTO lyn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Cwale sebeli kutendahala ngeeso nikwa woyo no wiili, nikwa woyo no waatu okutwala mane nikwa woyo no mutanu ni twiili (7). ");
INSERT INTO lyn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Munyima yoo onje, omukati ni yonyene sebeli ofa. ");
INSERT INTO lyn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Cwalehe, ba nako no kwinguka nwafu, omukati woyo kame sa tende waanyine kwawo noku kwana mutanu ni twiili (7) kakuli onje kame ana kumu kwatanga.” ");
INSERT INTO lyn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesu sebeli waatambula nji, “Kame mu fosa, kakuli kamu limukile aman̄olo, simba amaata a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Cwale Nyambe aba saingule aafu, kakwisa woyo so kwata, simba oku kwaliwa, kono kame sa tende kanyi amageloi naku wilu. ");
INSERT INTO lyn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mi kweyi no kwinguka nwaafu, kamwa sikubala esi anaku myambela Nyambe nji, ");
INSERT INTO lyn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Time, Nyambe wa Abulahama, Nyambe wa Isaka, Nyambe wa Jakobo?’ Kasa Nyambe waa no kufa, kono wawo no kuyoya.” ");
INSERT INTO lyn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mi enyangela aba ina kuyupa ngeeso, sebeli akomokiswa ku tuto yaye. ");
INSERT INTO lyn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Cwale Afalisi aba ana kuyupa nji Jesu kame ana ondokisa Asaduki, sebeli akuwana onje. ");
INSERT INTO lyn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Cwale omunjili kwa onyene omwiiyeti no mulawo sebeli omweteka niku mwibanguta nji, ");
INSERT INTO lyn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mwiyeti, kandi etaelo inene mu milawo, ibine?” ");
INSERT INTO lyn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu sebeli wamba kwa onyene nji, “Osinge Ombumu Nyambe wowe ni mucima wowe wonje, ni mooyo wowe wonje mane ni muku yupisisa kowe konje.’ ");
INSERT INTO lyn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Eyi etaelo inene neyi no weli. ");
INSERT INTO lyn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ou no wiili nou, owo ukufekile kanyi wonyene mi kame wamba nji, ‘Osinge omwabowe kanyi omo uku singela wenyene.’ ");
INSERT INTO lyn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ku titaelo eto timbili, oku beekilwe emilawo ya Mushe yonje ni tituto tonje no anuhi a Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Afalisi aba ano kuwana, Jesu sebeli waa ibanguta nji, ");
INSERT INTO lyn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Anyi ikene munahana kweyi ya Kilesite? Wa lusika lwa anyine? Sebeli amba kwa yonyene nji, “Kame ali wa lusika lwa Dabida.” ");
INSERT INTO lyn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesu sebeli wamba kwa onyene nji, “Cwale iikene Dabida aba amwisana nji Mbumu? Dabida kame ana kwambanga ni mebo aba ana kwamba nji, ");
INSERT INTO lyn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ombumu Nyambe kame anamba kwa Mbumu wange nji oikale ku lyoko lyange no silyo, okutwala aba sa ni kabeekele eila yowe kunji no makondo owe.’ ");
INSERT INTO lyn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nji Dabida kame aisana Kilesite nji Mbumu, cwale ngasibine satendele nji Kilesite wa lusika lwa Dabida?” ");
INSERT INTO lyn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kakwisa simba mumweya woyo ona kutwesa oku mutambula, simba okutunda ba liywaa elyo kakwisa woyo ona kwikala ni undume noku mwibanguta. ");
INSERT INTO lyn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Cwale Jesu sebeli wamba kwaanu no kupula ni kwa iyetwa aye nji, ");
INSERT INTO lyn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Aiyeti no mulawo na Falisi kame ali mu situlo sa Mushe. ");
INSERT INTO lyn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Cwalehe mu tende ni kumamela eyi amiyeta, kono mulese okutenda kanyi omwatendela onyene, kakuli katende eyi aiyeta. ");
INSERT INTO lyn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kame abeeka emishimbo no kulema ba mafuti no anu eyo no kubambaba okwishimba. Kono onyene katende esinjili okwaatusa okushimba emitiyo eyo. ");
INSERT INTO lyn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kame atenda eyoo yonje nji imoniwe kwaanu. Mi kame atenda eikwama no man̄olo inyonyo ni kwinunga mu lubala ni ba maoko ni kwitenda inene. Mi kame atenda amashamba no kuleba ku mikanjo yoo eyi akumanganga aba alapela nji amoniwe kwaanu. ");
INSERT INTO lyn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kame asinga eibaka no kukutekeha ba mikiti ni ipula eyi ili ku lubala mu tindoo no milapelo. ");
INSERT INTO lyn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kame asinga oku keetiwa mu likute mu misika ni ku isaniwa kwaanu nji ‘Mwiyeti.’ ");
INSERT INTO lyn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kono anyi mule kupumena oku miisana nji ‘Mwiyeti,’ kakuli omwiyeti wenu ni mumweya feela, mi moonje kame muli aiyetwa. ");
INSERT INTO lyn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mi mulese kwisana omunu bano banji nji ‘Sitenu,’ kakuli Sitenu ni mumweya feela, woyo oli ku wilu. ");
INSERT INTO lyn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mi mulese okupumena oku miisana nji ‘Omwendisi,’ kakuli kame mukwite omwendisi wenu mumweya feela, yonyene Kilesite. ");
INSERT INTO lyn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Woyo no kuneneba onene mwaanyi, yosotende omubika wenu. ");
INSERT INTO lyn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Awo onje aku nuneka kame sa kokobeziwe mi awo aku kokobeza kame sa nunekiwe. ");
INSERT INTO lyn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kono oumai ni wenu aiyeti no mulawo na Falisi, anyi asikukuba! Kame mu yatilela aanu omubuso naku wilu. Anyi ka mwingene, mi kamu pumenene awo asinga okwingenamo. ");
INSERT INTO lyn_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Oumai ni wenu Aiyeti no mulawo na Falisi, anyi asikukuba! Kame moonga etimbelwa ni kwaitela etindoo too. Cwale kame mulapela etitapelo no kuleba oku wabelisa aanu. Cwaleabo ekoto yenu mbaitende eyi no kuneneba ni kubitelela akwenu. ");
INSERT INTO lyn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Oumai ni wenu, Aiyeti no mulawo na Falisi, anyi asikukuba! Kame mweenda memu mana elitunga ni komboka amawate, nji mu wane omunu mumweya mi aba mu muwana, kame mu mufutula okutenda omwana lihele twiili kanyi anyi. ");
INSERT INTO lyn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Oumai ni wenu anyi aendisi no kufa miyo, anyi mwamba nji, “Omunu aba aeta ni ndoo ya Nyambe kakwisa etuso, kono aba aeta ni gauda no ndoo ya Nyambe, na nungiwa mu kweeta kwaye.” ");
INSERT INTO lyn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Anyi aelo no ibofu, esinene ni sibine? egauda nji endoo ya Nyambe eyo ina kenisa egauda? ");
INSERT INTO lyn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mi kame mwamba nji, “Omunu aba aeta ni aletale kakwisa etuso, kono aba aeta ni mpo eyi ili ba aletale kame anungilwe mu kweeta kwaye.” ");
INSERT INTO lyn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Anyi alume no ibofu! cwale esinene ni sibine, empo nji ni aletale, eyo itenda empo okukena? ");
INSERT INTO lyn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Cwale omunu yonje aba aeta ni aletale, kame aeta mu yonyene neyo ili ba aletale yonje, ");
INSERT INTO lyn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","mi woyo yonje oeta ni ndoo ya Nyambe, kame aeta kame ni Nyambe woyo oyoyamo. ");
INSERT INTO lyn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mi woyo oeta ni liwilu, kame aeta ni lubona lwa Nyambe, ni kwa woyo oikalilebo. ");
INSERT INTO lyn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Oumai ni wenu aiyeti no mulawo na Falisi, anyi asikukuba! Kame muba simweya kweyi itenda likumi eimena eyi itendisa eilya okumamata mi ka mu kwite taba ni inene namu mulawo, okuluka, amakeke ni usepahali. Eyi yokame mufanena okutenda nambulwa ketululo kwaa kwenu. ");
INSERT INTO lyn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Anyi aendisi no kufa miyo, kame mutundisa otumbulumbulu mu ino yenu, kono kame mumina Ekamele. ");
INSERT INTO lyn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Oumai ni wemu aiyeti no mulawo na Falisi, anyi asikukuba! Kame muyowisa ekomoki ni siwana bandee, mi mukaci kame kwiyalile einu munawana mu umbuyi ni ulyangelino. ");
INSERT INTO lyn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wene Omufalisi no sibofu, oyowise ekomoki ni siwana mukaci oweli, cwale ni bandee mbakukene ngeeso! ");
INSERT INTO lyn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Oumai ni wenu aiyeti no mulawo na Falisi, anyi asikukuba! Kame mu fekile kanyi amabita noku basiwa elikena, amonahala okutenda ano kuwaba bandee, kono mukaci kame aiyalile eifuba no aanu no kufa neyi no kwiiba yonje. ");
INSERT INTO lyn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Naanyi kame muli ngeso, bandee kame mu monahala okuluka kwaanu, kono mukaci kenu kame mwiyalile omwiipo ni ibi. ");
INSERT INTO lyn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Oumai ni wenu aiyeti no mulawo na Falisi, anyi asikukuba! Kame mu yaka amabita no anuhi a Nyanbe, mi kame mu kabisa awo asikuluka, ");
INSERT INTO lyn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","mi kame mwamba nji, ‘Kambe natu kuyoya mu maywaa no anjekulyetu, kambe katwa siku kuwana noo mu kwiita ounyinga no anuhi a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mukwamba eyi kame mukupaka mwenyene nji kame muli asilusika lwawo ana kwiibaa anuhi a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Cwale mutwalelele okumanenena eyo anaku tateka anjekulyenu. ");
INSERT INTO lyn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Anyi etinyoka, aana no imili, ngasibine samu picuke ekatulo no lyangalilo? ");
INSERT INTO lyn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Cwalehe kame nimi tumena anuhi wa Nyambe, nawo no kushangama, na iyeti no mulawo, anjili kame sa mwaibae ni kwa ngongotela, anjili mba mwa fulu mu tindoo no milapelo ni kwacita okutunda mu tolopo injili nikuta kwiinjili. ");
INSERT INTO lyn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Cwale abo ounyinga wao ano kuluka onje mbau saelelwe ba mitwi yenu, okutunda ba unyinga wa woyo osikuluka Abele okutwala ku unyinga wa Zakaliya mwanaye Balakiya, woyo muna kwibaa mukaci no ndoo ya Nyambe ni aletale. ");
INSERT INTO lyn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Niti luli kame ni myambela nji, anyi aanu muyoya muno mu nako mbamu wana ekoto ku inu eyi yonje! ");
INSERT INTO lyn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jelusalema, Jelusalema, omulenen̄i onaibaa anuhi a Nyambe, nikwibaa ni mawee awo ana tumiwa kwa wene! Tunjinga ni lakazanga okuwaneka anowe bamweya kanyi on̄uku no seke aba awanekanga anaye munji no maando, kono kawa sisinga! ");
INSERT INTO lyn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Komone, endoo yowe nai siyala kwa wene kanyi matota. ");
INSERT INTO lyn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cwale kame ni myambela nji, “Ka mutamba kuni mona kame, konji aba sa mwambe nji, ‘Ku lumbekwe woyo oiya mu litina lya Mbumu.’ ” ");
INSERT INTO lyn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesu sebeli otunda mu lilapa no ndoo ya Nyambe nukutela kundina, ababo aiyetwa aye sebeli aiya kwa yonyene ni kumu yulekela emiyako no tindoo ta Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kono sebeli waatambula nji, “Mumone eyi yonje, mwimwine? Niti luli, kame ni myambela nji, “Ka kwisa eliwee simba limweya elyo sali siyale bano, eli lilemine ba liwee elinjili, elyo sa liulwe okukwisetwa banji.” ");
INSERT INTO lyn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Cwale Jesu yoikala ba lilundu no itondo no Olibe, aiyetwa aye sebeli aiya kwa yonyene kumukunda, ni kwamba nji, “Otwambele eyo abo saika monahalele, nesi sasi tusimwete okwiiya kowe ni kubwa kwa litunga.” ");
INSERT INTO lyn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Cwale Jesu sebeli waatambula nji, “Mu mamele nji omunu alese okumiyembulula ");
INSERT INTO lyn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","kakuli aanu no kupula kame saiye mu litina lyange ni kwamba nji, ‘Mene time Kilesite,’ mi kame sayembulule ano kupula. ");
INSERT INTO lyn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mi kame sa mu upe etindwaa ni mabulwati no tindwaa, kono mu mone nji mulese kucila, kakuli einu eyo kame ifanene okwiiya, kono abo amamaneneno kasi tendahala kale. ");
INSERT INTO lyn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Esicaba kame sasi lwise esicaba sinjili, omubuso olwise omubuso munjili, mi olukupwe kame sa luikaleko ni tizikinyeho mu ibaka no kupula. ");
INSERT INTO lyn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kono eyo yonje kame sa itende feela amatatekelo no mayando. ");
INSERT INTO lyn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Cwale kame saminunge oku mitwala oka yandisiwa ni kumiibaa. Mi kame samu timbiwe ku matunga onje mu litina lyange. ");
INSERT INTO lyn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mi cwale aanu no kupula kame sa sitatale, mi kame sa betekane, mane nuukutimba. ");
INSERT INTO lyn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mi cwale anuhi no mapwa no kupula mba iiyi, mi kame sayembulule aanu no kupula. ");
INSERT INTO lyn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Cwale kakuli ouyi kame sau ekezehe onene, elilato no aanu no kupula mba libwi. ");
INSERT INTO lyn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kono woyo so tundamena okutwala ku mamaneneno, yokame soka yoyisiwa. ");
INSERT INTO lyn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mi eliywi eli no kuwaba eli no mubuso kame sa lyambiwe mu litunga lyonje, cwale nji litende oupaki ku macaba onje, ba sakwiiye amamaneneno. ");
INSERT INTO lyn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Daniele omunuhi wa Nyambe na kwamba eyi nji, ‘Esinu no kwiiba eso sisilafaza endoo ya Nyambe ni kusilokiwa. Mbamu mono ouyi oimanine mu sibaka no kukena.” (Osi ku bala alemuhe). ");
INSERT INTO lyn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Cwale awo ali mu Judeya acilele ku malundu. ");
INSERT INTO lyn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mi woyo oli ba situwa no ndoo, alese ku shotokela mu ndoo akashimba esinu. ");
INSERT INTO lyn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mi woyo oli mu matema, alese okuukela ku mundi oka shimba olwambi. ");
INSERT INTO lyn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Oumayi ni waawo akati sawaniwe akushimbile nawo sawaniwe ayamwisa mu maywaa awo! ");
INSERT INTO lyn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mu lapele nji mule okashotoka mu nako no mubebo simba mu liywaa eli no Sabata, ");
INSERT INTO lyn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","kakuli ba nako eyo, amayando mbatende ano kuneneba, awo kaa sitendahala kale simba okutunda ku matakelo no litunga ku lita bano, mi kame kakutamba ku tendahala ngeeso. ");
INSERT INTO lyn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mi cwale nji amaywaa awo ka kusufaziwa, kakwisa simba mumweya woyo so yoyisiwa. Kono cwale mulibaka lyaawo ana ketiwa, amaywaa awo mba kusufaziwa. ");
INSERT INTO lyn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Cwale nji omunu kame amba kwa wene nji, ‘Omone, uno ya Kilesite!’ simba uya yokame!’ mulese kupumena. ");
INSERT INTO lyn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kame namba eyi kakuli asi konga nji aonyene asi Kilesite na nuhi no mapwa kame samonahale ni kumonisa eisupo inene ni timakazo nji kutwesahala, alyanganise simba awo ana kuketiwa. ");
INSERT INTO lyn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kono mumamele! Kame nina myambele oweli. ");
INSERT INTO lyn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Cwale, simba naba sa myambele nji, ‘Mumone, kame ali mu mushitu, mulese kutako, simba aba saambe nji, ‘Mumone, kame ali mu misusu no ndoo, mulese ku pumena, ");
INSERT INTO lyn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","kakuli kanyi olumonyi aba lweesa okutunda mu upa nikuka esela mu wiko, mwasa iyele ni Mwana no munu. ");
INSERT INTO lyn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mba kumonahala ngeeso kanyi amanon̄u aba aungana, aanu kame alimuka nji kame kuli esitupu. ");
INSERT INTO lyn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ababo kusibwa feela en̄alelwa no maywaa awo, eliywaa kame sa li ilole, okweti kame sa ulwe eliseli mi etitungweti kame sa tikwe ku wilu, amaata na ku liwilu kame sa nyanganye. ");
INSERT INTO lyn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Cwale esisupo no Mwana no munu mbasi monahala mu wilu aanu onje noba litunga kame sa lile. Mi kame sa mone Omwana no munu yokeyile mu makumbi no liwilu mu maata ni mu kanya inene. ");
INSERT INTO lyn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Cwale kame sa tume amangeloi aye ni titolombita no mulumo no kuneneba, mi kame sa ungeke aketwa aye mu maneku anee okutunda ku mamaneneno no litunga linjili okuta ku linjili. ");
INSERT INTO lyn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mu kwiyete ku tuto okutunda ba sitondo no mukuyu, muwangu-wangu aba mumona nji emitai yaso aba yotoba mi kame ishoshela amamuna, mu limuke nji esilimwe kame sili beebi. ");
INSERT INTO lyn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mu ndila imweya, aba mu mona eyo yonje, mu limuke nji Omwana no munu sebeli oli beebi mi kame ali ba mwelo. ");
INSERT INTO lyn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Niti luli kame ni myambela nji, lusika luno no balelo ka lu tamba okubwa, konji eyo naitendahala oweli. ");
INSERT INTO lyn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Eliwilu ni litunga mbaibwe, kono amaywi ange ka tamba okubwa. ");
INSERT INTO lyn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kono eyi no liywaa ni nako eyo, kakwisa woyo wi limukile, simba amangeloi naku wilu kayii, simba Omwana, konji Sitange. ");
INSERT INTO lyn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Omo kuna kwikalela mu maywaa a Nuwe, kame sa kwikale ngeeso ni mu kwiiya kwa Mwana no munu. ");
INSERT INTO lyn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mu maywaa awo omunda kawasiiya kale, aanu kame ana ku lya, oku nwa, oku kwata, oku kwalisa, konji eliywaa ana kwingena Nuwe mu Aleka. ");
INSERT INTO lyn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mi kasiku limuka esinjili konji omunda aba ona kwiiya mukwayundisa. Mi mosa kwikalele yongeso aba saiye Omwana no munu. ");
INSERT INTO lyn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ba nako eyo kwa alume ayiili aa saikale mu litema, omunjili mba shimbiwa, omunjili mba siyala. ");
INSERT INTO lyn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Akati ayiili asa silange oubeeke, mumweya mba shimbiwa, omunjili mba siyala. ");
INSERT INTO lyn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Cwale abo mutone, kakuli ka muyii eliywaa elyo saiye Ombumu wenu. ");
INSERT INTO lyn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kono mu limuke eyi, nji omunya ndoo kambe mba limuka enako no usiku aba saiye ombuyi, kambe kame satone mi kambe kaleselela ombuyi okucuula endoo yaye. ");
INSERT INTO lyn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Cwalehe naanyi muku tukise, kakuli Omwana no munu kame saiye mu nako eyo mwa limukile. ");
INSERT INTO lyn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Anyine cwale omubika no ku sepahala, ni kushangama, woyo sa beeke Ombumu okwendisa abika aye, okwaba eyi no kulya mu nako eyi ilukeele? ");
INSERT INTO lyn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Embuyoti niya woyo omubika sawane Ombumu yo tenda omusebezi owo aba saiye. ");
INSERT INTO lyn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Niti luli kame ni myambela nji kame samu beeke okwendisa kweyo aluwile yonje. ");
INSERT INTO lyn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kono iikene saitendahale nji woyo omubika ni wakwiiba mi kame ayambuta nji ombumu waye katamba okwiiya wangu, ");
INSERT INTO lyn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mba tateke oku fula akwaye abika, alye, awee na cakolwa. ");
INSERT INTO lyn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ombumu no mubika woyo kame saiye mu liywaa elyo sa ulwe oku mu tatelela, ni mu nako no kwa limuka. ");
INSERT INTO lyn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mi kame sa mupatole eibindi, ni kumu beeka na asikukuba, oko sa kwikale okulila ni kukweca amaewo. ");
INSERT INTO lyn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ba nako eyo omubuso naku wilu kame sokufeke kanyi eso sina kutendahala abo akatana noku kwana likumi aba ana ku shimba amaboni oo ni kuta oka waniketa omukwati. ");
INSERT INTO lyn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ana kukwana mutanu kwa onyene neli aelo, mi mutanu neli ano kushangama. ");
INSERT INTO lyn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Cwale aelo no kukwana mutanu kasiku shimbela amaboni oo amaati no kupula, ");
INSERT INTO lyn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kono ano kushangama kame ana ku shimba amaati mwishimbelo yoo, bamweya ni maboni oo. ");
INSERT INTO lyn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Cwale kakuli omukwati kame ana ku liyeha bakwiiya, sebeli akosa onje ni ku langana. ");
INSERT INTO lyn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kono bakaci no usiku omuhuwo sebeli o yupahala nji, ‘Komumone, omukwati uno! Ko mwiiye mu mu wanikete!’ ");
INSERT INTO lyn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Cwale akatana awo sebeli ainguka onje ni kutateka oku lukisa amaboni oo. ");
INSERT INTO lyn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Cwale ano kweluba sebeli amba kwaa ano kushangama nji, “Mu tube ku maati enu, kakuli amaboni etu kame atima.” ");
INSERT INTO lyn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kono ano kushangama sebeli aa tambula nji, “Ka ku twesahala! katamba ku tu kwana aci naanyi. Mute kwa aulisi nji mu ka ku ulele eenu.” ");
INSERT INTO lyn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mi cwale akatana no kweluba asita feela mukuula amaati, omukwati sebeli okeela, mi awo ana kuku tukiseta sebeli aingena naye mu mukiti no likwala, mi esaandi sebeli siyatiliwa. ");
INSERT INTO lyn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Munyima nweyo, akatana anjili sebeli aiya nonyene ni kwamba nji, ‘Mbumu, Mbumu! otu yatulwele.’ ");
INSERT INTO lyn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kono omukwati sebeli otambula nji, “Niti luli kame ni myambela nji, kani mi yii.” ");
INSERT INTO lyn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Cwale mwikale anyi me mutona, kakuli kamu limuka eliywaa simba enako eyo saiye Omwana no munu. ");
INSERT INTO lyn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Omubuso naku wilu kame okufekile kanyi eso sina kutendahala abo omulume aba ano kutukiseta okuta mu mwendo waye, sebeli oisana abika aye ni kwaambela nji ababalele ofumu waye. ");
INSERT INTO lyn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sebeli oba omunjili amasaka no mali noku kwana mutanu, omunjili sebeli omuba amasaka ayiili no mali, omunjili esaka no mali imweya, sebeli oba omunjili ni munjili oku faniketa nomo atwesela. Cwale sebeli okutela. ");
INSERT INTO lyn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Cwale woyo ona ku biwa amasaka mutanu no mali, ababo sebeli oka belekisa ni ku wanenabo kame no kukwana mutanu. ");
INSERT INTO lyn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mi kame ni woyo ona kubiwa amasaka ayiili sebeli ota okabelekisa ni kuwanenabo kame amasaka ayiili. ");
INSERT INTO lyn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kono woyo ona kubiwa esaka iweya no mali sebeli ota, nuka tombola owina banji niku shweeka amali no molyaye. ");
INSERT INTO lyn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Cwale aba kuna kubita amaywaa no kupula omolya abika awo sebeli oiya, mi sebeli waisana nji amone omo ana belekisete amali aye. ");
INSERT INTO lyn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Cwale woyo ona kutambula amasaka mutanu no mali sebeli oiya kwa molyaye okulita amasaka no mali kame noku kwana mutanu ni kwamba nji, ‘Molyange kame ona kuniba amasaka mutanu no mali, komone, kame nina wanenebo kame masaka mutanu no mali beulu.’ ");
INSERT INTO lyn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Omolyaye sebeli wamba kwa yonyene nji, ‘Nu tende wino, mi uli mubika no kuwaba ni ku sepahala! Nu sepahala ku inu no kucaniba, mba niku beeke okubusa eyi no kupula. Wingene mu kuwabelwa kwa molyowe!’ ");
INSERT INTO lyn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mi ni woyo ona kubiwa amasaka ayiili no mali, sebeli oiya kwa molyaye ni kwamba nji, ‘Molyange, kame ona kuniba amasaka ayiili no mali, Omone! kame nina wanenebo kame amasaka ayiili no mali.’ ");
INSERT INTO lyn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Omolyaye sebeli wamba kwa yonyene nji, ‘Nu tende wino, wene omubika no kuwaba niku sepahala, nu twese oku sepahala mu inu no kucaniba, mba niku beeke okubusa eyi no kupula, wingene mu kuwabelwa kwa molyowe!’ ");
INSERT INTO lyn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Cwale ni woyo ona kubiwa esaka imweya no mali, ni yonyene sebeli oiya ni kwamba nji, “Molyange, kame niku limukile nji wene uli mulume noku bambaba, woyo ukutula omu wasi kuna, mi kame uungeka omu kausi kwaa embuto. ");
INSERT INTO lyn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Cwale kakuli kame nina kucila, sebeli nita okatombola owina banji niku pumbeka esaka yowe no mali mu mumbu. Esinu sowe sino sokame.” ");
INSERT INTO lyn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kono omolyaye sebeli omu tambula nji, ‘Wene omubika no kwiiba ni kububa! Kame wamba nji kame olimukile nji kame ni kutula omo kanisi kuna, mi kame ni ungeka omo kanasi kwaa embuto. ");
INSERT INTO lyn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Cwale kame onaku fanena nji obeeke amali ange mu Panga, mi aba ni nauku kambe nonu sete amali ange niku beekelabo en̄ambekelo. ");
INSERT INTO lyn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Cwale mu mu biangule esaka no mali, mi mube kwa woyo okwite amasaka likumi no mali. ");
INSERT INTO lyn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwaawo akwite, mba beekelwa, mi mba ikala neyi nokupula, kono kwaawo aulwile mane kame sa byanguliwe neyo akwite. ");
INSERT INTO lyn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kanyi kwa woyo omubika nambulwa tuso, mu mu kondele ku uwi, oko salila ni kukweca amaeo. ");
INSERT INTO lyn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Cwale omwana no munu aba saiye mu kanya yaye, yoli ni Mangeloi aye onje, kame saikale ba lubona no kanya yaye. ");
INSERT INTO lyn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mba ku ungana ba lubala lwaye amacaba onje, mi mba kete aanu anjili kwaa njili, kanyi omulisana aba ataba omukoko mu tupuli. ");
INSERT INTO lyn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mi kame sa beeke omukoko ku lyoko lyaye no silyo, mi abeeke otupuli kweli no simoo. ");
INSERT INTO lyn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Cwale molyoo kame saambe kwaawo ali ku lyoko lyaye no silyo nji, ‘Komwiye! anyi muna fuyolwa kwa Sitange! Mu yole omubuso ona ku lukisetwa anyi okutunda ku matatekelo no litunga. ");
INSERT INTO lyn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ni wenu kakuli kame nina ku yomba, mi sebeli muniba esi no kulya, mi kame nina kufa elinyotwa, mi sebeli muniba esi no kunwa, kame nina kutenda ongenda, mi sebeli muni tambula, ");
INSERT INTO lyn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","kame nina kuulwa esikumango, mi sebeli muniba esi no ukumanga, kame nina kutoma, mi sebeli muni babalela, kame nina kwikala mu tolongo, mi sebeli mwiiya mukunilekula. ");
INSERT INTO lyn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Cwale ano kuluka kame sa mu tambule nji, ‘Molyetu, ka mwaka tuna ku kumona wo yombile, mi sebeli tu kuba esi no kulya, simba wofile elilyotwa ni kukuba esi no kunwa? ");
INSERT INTO lyn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mi cwale ka mwaka aba tuna kuku mona o endile ongenda, mi sebeli tuku tambula, simba oulwile esikumango, mi sebeli tu kuba esi no kukufuka? ");
INSERT INTO lyn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mi cwale ka mwaka tu naku ku mona me u tomine, simba ouli mu tolongo, mi sebeli twiiya kwa wene mu kukupotela? ");
INSERT INTO lyn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mi molyowo mba atambula nji, ‘Niti luli kame ni myambela nji kwawo abange acana muna kutendela ngeeso, yamene muna kutenda ngeeso!’ ");
INSERT INTO lyn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Cwale kame saambe kwawo ali ku lyoko no simoo nji, ‘Anyi mu kutilwe kwa Nyambe, mutunde kwa mene, mute mu mulilo no kwaabwa, ou u lukisetwe Diabulosi ni mangeloi aye! ");
INSERT INTO lyn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kame ni tenda ngeesi kwaanyi kakuli kame ni naku yomba, mi ka mwasiku niba esi no kulya, kame nina kufa elinyotwa mi kamwasikuniba esi no kunwa. ");
INSERT INTO lyn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kame nina kutenda ongenda, mi ka mwasikuni tambula, kame nina kuulwa esikumango, mi ka mwasi kuni fuka, kame nina kukola, ni kwikala mu tolongo, mi ka mwasi kwiiya mu kuni lekula. ");
INSERT INTO lyn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Cwale nonyene kame samu tambule nji, ‘Molyetu, ka mwaka tuna kuku mona woyombile, simba wofile elinyotwa, simba wotendile ongenda, simba wo ulwile esikumango, simba wotomine, simba mu tolongo, mi sebeli tu kwangwa oku kubabalela?’ ");
INSERT INTO lyn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Cwale kame saatambule nji, “Niti luli kame ni myambela nji aba muna kukwangwa oku babalela omunjili kwaa acana ngeeso, yamene muna kukwangwa oku babalela ngeeso.” ");
INSERT INTO lyn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mi awo kame saate mu koto no kwaabwa, kono awo no kuluka kame saate mu mooyo no kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cwale Jesu aba ana kumana okwamba eyi yonje, sebeli wamba kwa iyetwa aye nji, ");
INSERT INTO lyn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kanyi omo mulimuukele nji, omukiti no paseka kwasiyala kale amaywaa ayiili nji otendahale, mi cwale Omwana no munu mba beekiwa mu maoko no aanu okumu ngongotela.” ");
INSERT INTO lyn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Cwale apulisita akulu na akulu sebeli akuwana mu ndoo no mupulisita no mukulu woyo elitina lyaye neli Kefasi. ");
INSERT INTO lyn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mi sebeli ata oka lelisana omo salemene Jesu muku shangama mane ni kumwibaa. ");
INSERT INTO lyn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kono sebeli amba nji, “Kuleswe oku tendahala mu nako no mukiti, mwendi esicaba mba sitende omufilili.” ");
INSERT INTO lyn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesu kame ana kwikalanga ku Betani mu ndoo ya Simoni, ona kutomanga kunyima oweti no mbingwa. ");
INSERT INTO lyn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Cwale omukati sebeli oiya kwa yonyene ni komoki no alabasita no maati no kutula, mi sebeli waitela ku mutwi wa Jesu abo yolemine okulya ku tafule. ");
INSERT INTO lyn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kono cwale aiyetwa aba ana kumona ngeso, sebeli atina ni kwamba nji, “Iikene akandakandelwa aa maati? ");
INSERT INTO lyn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Amaati awo kame ana lukele oku ulisiwa amali no kupula, nji abiwe kwaa ashebile.” ");
INSERT INTO lyn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kono Jesu sebeli olemuha eyo ana kwambanga, ni kwamba kwa onyene nji, “Iikene esi muyandiseta omukati woyo? Kame ana tende ekezo no kuwaba kwa mene. ");
INSERT INTO lyn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ano kusheba mba mwikala noo enako yonje, kono mene ka mu tamba okwikala nange enako yonje. ");
INSERT INTO lyn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Na itele amaati awo ba lutu lwange okulukisa okuteulwa kwange. ");
INSERT INTO lyn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Niti luli kame ni myambela nji, oko konje sa likutaziwe eliywi eli no kuwaba mu litunga lyonje, kame sa kwambiwe nesi ana tende, sitende eso sa pulukiwe naso.” ");
INSERT INTO lyn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Cwale omunjili no aiyetwa no kukwana likumi na yiili woyo oisaniwa nji Judasi isikalyota, sebeli ota kwa pulisita akulu. ");
INSERT INTO lyn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Sebeli wamba nji, “Iikene sa muniteneke aba sani beteke Jesu kwaanyi?” Sebeli amuteneka amali ana kukwana makumi aatu omuwayawaya no silibela. ");
INSERT INTO lyn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mi okutunda abo, Judasi sebeli osaela omukwa no kubeteka Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ba liywaa no matatekelo no mukiti ou no lin̄ende nambulwa omumena, aiyetwa sebeli aiya kwa Jesu ni kwamba nji, “Kubine usinga nji tukalukise nji ukalyeleko omukiti no paseka?” ");
INSERT INTO lyn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesu sebeli wamba nji, “Mute mu tolopo ku mulume munjili mi mu mwambele nji, ‘Omwiyeti namba nji enako yange kame ili beebi, mbanilyele omukiti no paseka na aiyetwa ange ku ndoo yowe.’ ” ");
INSERT INTO lyn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Cwale aiyetwa aye sebeli atenda omo na kwaambelela Jesu oku lukisa omulalelo no mukiti no paseka. ");
INSERT INTO lyn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jesu kame ana kwikalanga ba tafule na iyetwa aye noku kwana likumi na yiili, ");
INSERT INTO lyn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","mi alemine okulya ngeeso, sebeli wamba nji, “Niti luli kame ni myambela nji, omunjili mwaanyi yosoni beteka.” ");
INSERT INTO lyn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mi sebeli aena onene luli mi sebeli atangisa oku mwibanguta, omunjili ni munjili nji, “Mwendi mene, Mbumu?” ");
INSERT INTO lyn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesu sebeli otambula nji, “Woyo ona ingenyeke elyoko bamweya ni mene mu siwana yosoni beteka. ");
INSERT INTO lyn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Omwana no munu mbafu kanyi omo kun̄olelwe mu man̄olo, kono oumai ni woyo so beteka Omwana no munu! Esiwa ku munu woyo ni nji kambe ka siku leiwa!” ");
INSERT INTO lyn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judasi, woyo ona kumu beteka, sebeli otambula nji, “Mwendi mene, Mwiyeti?” Jesu sebeli wamba kwa yonyene nji, “Nwaamba.” ");
INSERT INTO lyn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Cwale abo alemine okulya ngeeso, Jesu sebeli oshimba esinkwa, mi munyima no okutumela, sebeli osi patola, nikuba aiyetwa aye, sebeli wamba nji, “Mu shimbe mi mulye, “Olu ni lutu lwange.” ");
INSERT INTO lyn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Cwale sebeli oshimba ekomoki nuuku tumela, ni kwaaba ni kwamba nji, “Mu nwemo moonje,” ");
INSERT INTO lyn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Kakuli ou ni unyinga wange no ulikani ona itekele ano kupula, mulibaka no kulemeniwa eibi. ");
INSERT INTO lyn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mi kame namba kwaanyi nji, ku tunda bano, kani tamba kunwa kwesi si bekilwe ku sitondo no beine, mane kubitela kame ba liywaa elyo sani nwe naanyi, konji esi tendile esi no ubya mu mubuso wa Sitange.” ");
INSERT INTO lyn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cwale sebeli aimba olusimo, nukutela ba lilundu no Olibe. ");
INSERT INTO lyn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Cwale Jesu sebeli wamba kwa onyene nji, “Anyi moonje mba munishotoka mulibaka lyange uno usiku, kakuli na ku n̄oliwa nji, ‘Kame sani fule omulisana, mi omulaka no mikoko kame so hasane.’ ");
INSERT INTO lyn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kono aba sani inguke kwaafu, mba niku tangete kulubala lwenu okuta ku Galileya.” ");
INSERT INTO lyn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pitolosi sebeli omu tambula nji, “Simba nji onje kame saku shotoke mulibaka lyowe, “Mene, kani tamba oku kushotoka.” ");
INSERT INTO lyn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu sebeli wamba kwa yonyene nji, “Niti luli kame ni kwambela nji, ouno ousiku omukombwe owasilila kale, kame soni latule twaatu.” ");
INSERT INTO lyn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pitolosi sebeli wamba kwa yonyene nji, “Naaba sani fanene okufa ni wene, ka nitamba okuku latula!” Mi na iyetwa aye anjili onje sebeli amba ngeeso. ");
INSERT INTO lyn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Cwale Jesu sebeli ota noo ku sibaka siisaniwa Gesemani, mi sebeli wambela aiyetwa aye nji, “Mwikale bano, mene abani sita kuya oka lapela.” ");
INSERT INTO lyn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mi sebeli oshimba Pitolosi naana ayiili a Zebedeya Jowani ni Jokobo, mi sebeli otangisa okweena onene nu uku kalelwa. ");
INSERT INTO lyn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Cwale sebeli wamba kwa onyene nji, “Emebo yange sebeli ili beebi ni kufa mulibaka no likenyi. Mu siyale bano, mi mutone ni mene.” ");
INSERT INTO lyn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mi sebeli ota ba lubala mbicana, sebeli okwela banji ni kulapela nji, “Sitange, nji kame ku twesahala, kambe esinweno no mayando ni lufu ibitele aba no kuleba ni mene! Kono kulese kutendahala omo ni singela, ku tendiwe omo usingela wene.” ");
INSERT INTO lyn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Cwale Jesu sebeli oiya kwa iyetwa aye mi sebeli waa wana alanganine batulo, sebeli wamba kwa Pitolosi nji, “Kandi kamu twesa oku tona ni mene muhola imweya? ");
INSERT INTO lyn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mutone, mi mu lapele nji mulese kwingena mu muliko. Emebo yonyene kame isinga, kono olutu kame lufokola.” ");
INSERT INTO lyn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kame sebeli ota aka no wili oka lapela nji, “Sitange, nji esinweno esi no mayando ni lufu kasi twesahala okutunda konji aba sani nwemo, ku tendahale esisi singwa kwa wene.” ");
INSERT INTO lyn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mi kame sebeli oiya kwa onyene ni kwaa wana alanganine, kakuli amiyo oo kame ana kuyupahala okulema. ");
INSERT INTO lyn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Cwale sebeli waasiya kame oka lapela aka no waatu, ni kwamba amaywi kanyi aa ana kwamba ba weli. ");
INSERT INTO lyn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Cwale sebeli ouka kwa iyetwa aye kame, mi sebeli wamba kwa onyene nji, “Mu silanganine nuku katulusa? Komumone! enako ya keela kale eyo Omwana no munu kame abekiwa mu makaa no asikutenda ouyi. ");
INSERT INTO lyn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ko mwimane tute. Komumone, woyo osi kuni beteka wakeela kale!” ");
INSERT INTO lyn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ababo yosi lemine okwamba ngeeso, Judasi omumweya kwawo noku kwana elikumi na yiili sebeli okeela naanu no kupula ashimbile etisabule ni milamu. Kame ana kutumiwa kwaa pulisita no akulu ni manduna no sicaba. ");
INSERT INTO lyn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Cwale omubeteki na kwaaba esisupo, okwamba nji, “Woyo sani tubete yokame, mu mununge!” ");
INSERT INTO lyn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Muwangu sebeli osheeteta kwa Jesu ni kwamba nji, “Olumele Mwiyeti,” mi sebeli omu tubeta. ");
INSERT INTO lyn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesu sebeli wamba kwa yonyene nji, “Mulikani, otenda eso ona iyele mukutenda!” Cwale sebeli aiya mukumulema ni kumununga. ");
INSERT INTO lyn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ababo kwaawo ali kwa Jesu, omunjili sebeli oshomona omukwale waye ni kupatula elitwi no mubika no mupulisita no mukulu. ");
INSERT INTO lyn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Cwale Jesu sebeli omwambela nji, “Ouse emukwale wowe mu sipusu sawo, kakuli awo onje akutusisa emikwale mbaafi ku mikwale. ");
INSERT INTO lyn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kame oyambuta nji kani twese okwisana kwa sitange, mi mu nako imweya feela kame twesa okulita etimpi no mangeloi likumi ni ayiili? ");
INSERT INTO lyn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kono ba kutenda ngeeso, Aman̄olo ngasibine sa iyatetetwe aa amba nji, Naku fanene oku tendahala ngeeso?” ");
INSERT INTO lyn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ba nako eyo Jesu sebeli wamba kwaanu nji, “Na mwiiyi ni mikwale ni milamu muku nilema, kanyi mbili sikebenga? Amaywaa onje nani kwikalanga mu ndoo no milapelo okwiyeta, mi ka mwa siku nilema. ");
INSERT INTO lyn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kono eyi yonje na itendahala nji eyi ina n̄oliwa kwa nuhi a Nyambe iiyatetetwe.” Cwale aiyetwa onje sebeli amusiya ni kumu shotoka. ");
INSERT INTO lyn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Awo ana kulema Jesu sebeli amutwala ku ndoo ya Kayafa, omukulu no apulisita, oko ana kuku wanena aiyeti no mulawo naa kulu. ");
INSERT INTO lyn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kono Pitolosi kame ana ku mukon̄anga munyima aba no kuleba, sebeli oka keela ku lilapa no mupulisita omukulu. Sebeli oingenamo mi sebeli oikala na tateleli nji amone etaba omo saibwele. ");
INSERT INTO lyn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Cwale apulisita akulu nasi kuta onje sebeli asaela oupaki no mapwa nji amwibae, ");
INSERT INTO lyn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kono kasi kuuwana, simba naba ana kwiiya apaki no mapwa no kupula. Ku mamaneneno sebeli kwiiya ayiili ");
INSERT INTO lyn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ni kwamba nji, “Uyu mulume nakwamba nji, kame ni twesa oku kwisa endoo ya Nyambe, ni kwiyaka kame mu maywaa aatu.’” ");
INSERT INTO lyn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Omupulisita omukulu sebeli oimana ni kwambela Jesu nji, “Kukwite ekalabo otwesa oku tambula? Kweyo alemine ooku kandimeka?” ");
INSERT INTO lyn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kono Jesu kame ana koondoka. Cwale omupulisita omukulu sebeli wamba kwa yonyene nji, “Kame weeta ni Nyambe no kuyoya, otwambele nji ya wene Kilesite Mwanaye Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesu sebeli wamba kwa yonyene nji, “Nwamba. Kono kame ni myambela nji, oku tunda abano kame sa mu mone Omwana no munu yoikale ku lyoko no silyo lya Nyambe no Maata, mi yokeile mu makumbi no liwilu!” ");
INSERT INTO lyn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Cwale omukulu no mupulisita sebeli otina onene ni kukaula eikumango yaye ni kwamba nji, “Na nyefula! Iikene aba tusi saelela oupaki? Na mu yupu akashwau kaye! ");
INSERT INTO lyn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Anyi ekatulo yenu niibine?” Sebeli atambula nji, “Kame afanena okufa.” ");
INSERT INTO lyn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Cwale sebeli amusibwela amate ba lubala niku mufula efaindi, niku mufula olubaka ");
INSERT INTO lyn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","amba nji, Kilesite! otu nuhe, Anyine woyo ona kufulu?” ");
INSERT INTO lyn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ba nako imweya Pitolosi kame ana ikalanga ku ndee no lilapa no kuta. Omubika no mukatana sebeli oiya kwa yonyene ni kwamba nji, “Ni wene nau kwikalanga ni Jesu Omugalileya.” ");
INSERT INTO lyn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kono yonyene sebeli okana ba lubala no aanu onje ni kwamba nji, “Silimukile eso otalusa.” ");
INSERT INTO lyn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Cwale abana iya ku mwelo, omubika munjili no muskatana sebeli omumona ni kwamba kwaawo ana kwikalangamo nji, “Ni woyo kame ana kwikalanga ni Jesu no Nazaleta.” ");
INSERT INTO lyn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mi kame sebeli okana ni kweeta nji, “Mene kani mulimukile woyo mulume!” ");
INSERT INTO lyn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Munyima no nako icana, awo ana kwimana omo sebeli aiya ni kwambela Pitolosi nji, “Niti luli ni wene kame oli mumweya kwawo ana kwikalanga ni Jesu, kakuli omwambelo wowe kame uku limukisa kanyi omugalileya!” ");
INSERT INTO lyn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Cwale Pitolosi sebeli kweeta nji, “Nikukaule bakaci, kani mu limukile omunu woyo!” Mi ababo omukombwe sebeli okuwa. ");
INSERT INTO lyn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Cwale ababo Pitolosi sebeli opuluka eyo anaku mwambela Jesu nji, “Omukombwe owasikuwa kale mbunikana twaatu.” Ababo sebeli ota bandee nuuka lila onene. ");
INSERT INTO lyn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kusili amasikusiku akulu no apulisita onje na kulu no mulawo sebeli atenda omulelo woo omo saibaele Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mi sebeli amu nunga ku maoko ni ku mutwala, nuuka mubeeka mu maata a Pilato omubusisi no Maloma. ");
INSERT INTO lyn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Cwale Judasi omubeteki, aba ana kumona nji Jesu na atulelwe olufu, sebeli okunyaza ni kuusa amali no silibela ana kukwana makumi aatu ano muwaya-waya kwa kulu no apulisita ni kwa kulu. ");
INSERT INTO lyn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Sebeli wamba nji, “Kame nina tende ouyi aba nina beteke ounyinga nambulwa omubonda.” Kono sebeli amba nji, “Iikene eyo kwaaci? Eyo ni taba yowe!” ");
INSERT INTO lyn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Cwale Judasi sebeli oyumbela amali awo no muwaya-waya mu ndoo ya Nyambe, mi sebeli okutela nuuka kunungelela yonyene. ");
INSERT INTO lyn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kono akulu no apulisita sebeli ashimba amali awo no muwaya-waya ni kwamba nji, “Ka ku fanene okwa beeka mu sitewelo no ndoo ya Nyambe, kakuli ni mali no unyinga.” ");
INSERT INTO lyn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Munyima no kwambola onje, amali awo sebeli akutusisa okuula elitema lya muumbi no tucoo, esibaka no matutaeti no angenda. ");
INSERT INTO lyn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mulibaka eli, elitema elyo kame liisaniwa nji, “Elitema no unyinga” okulita ni balelo lino. ");
INSERT INTO lyn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Cwale kame kuna kwiyatetetwa eyo ina kwambiwa kwa munuhi wa Nyambe Jelemiya, aba amba nji, “Mi kame ana shimbi amali no silibela ana kukwana makumi aatu, omuulo wamunu mumweya ona kusumiwa kwaana no Isilaele, ");
INSERT INTO lyn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mi sebeli akutusisa amali awo okuula elitema no muumbi no tucoo, kanyi omo ana kuni laelela Mbumu.” ");
INSERT INTO lyn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Cwale Jesu sebeli oimana balubala no mubusisi, mi omubusisi sebeli omwibanguta nji, “Kana ya wene Ombumu no Majuda?” Jesu sebeli omutambula nji, “Nwamba.” ");
INSERT INTO lyn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kono naba ana ku nungelelwa eyambo kwa kulu no apulisita naakulu, kasi ku tambula. ");
INSERT INTO lyn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Cwale Pilato sebeli wambela Jesu nji, “Kuyupile eyo yonje aku nungelela?” ");
INSERT INTO lyn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kono kasi kutambula simba simweya kweyo anaku munungelela yonje, mi omubusisi sebeli okomoka onene. ");
INSERT INTO lyn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cwale enako yonje ba mukiti no Paseka, omubusisi kame anaku lukulwelanga esicaba omunjili no mapantiti, woyo asinga aanu. ");
INSERT INTO lyn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mi cwale mu nako eyo, kame kuna kwikalanga elipantiti no sikebenga ona ku limukiwa onene, no litina lya Jesu Balabasi. ");
INSERT INTO lyn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cwale aanu aba ana kumana oukuwana, Pilato sebeli waaibanguta nji, “Anyine mu singa nji nimi lukulwele, Jesu Balabasi nji Jesu woyo oisaniwa nji Kilesite?” ");
INSERT INTO lyn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nakwaibanguta ngeeso kakuli naku lemuha nji ni mulibaka no muna aba ana muliti kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Cwale ababo Pilato yoli ba situlo no katulo, mukataye sebeli omutumena amaywi nji, “O lese kutenda esinjili kwa woyo omulume nambulwa omubomda, kakuli balelo kame ni a yanda onene okulota mu libaka lyaye.” ");
INSERT INTO lyn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kono akulu no apulisita naakulu nwaanu sebeli asusuweza aanu nji akumbele okulukulula Balabasi, mi Jesu yonyene aibaiwe. ");
INSERT INTO lyn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Omubusisi kame sebeli waaibanguta nji, “Kwaa ayili, ubine woyo mu singa nji ni i lukulwele?” Onyene sebeli atambula nji, “Balabasi!” ");
INSERT INTO lyn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato sebeli wamba kwa onyene nji, “Cwale ngasibine sani tende kwa Jesu woyo oisaniwa Kilesite?” Oonje sebeli amba nji, “A ngongoteliwe!” ");
INSERT INTO lyn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Cwale Pilato sebeli waibanguta nji, “Iikene? ubine ouyi ana tende?” Kono onje sebeli akuwa onene nji, “Angongoteliwe!” ");
INSERT INTO lyn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Cwale Pilato aba ana kumona nji katwese okutenda esinjili, kono kame kutwesa okwiiya omufilifili, sebeli oku yowa ku maoko ni meyi balubala no aanu no kupula, ni kwamba nji, “Mene sikwite omubonda mu unyinga wa woyo omulume! Muku monene eyo ni taba yenu!” ");
INSERT INTO lyn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Cwale esicaba sonje sebeli si tambula nji, “Ounyinga waye wikale beulu wetu na neetu!” ");
INSERT INTO lyn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Cwale Pilato sebeli olukulula Balabasi kwa onyene. Munyima no kushapa Jesu, sebeli omuba mu maoko no masole nji amungongotele. ");
INSERT INTO lyn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Cwale amasole no mubusisi sebeli atwala Jesu mu lilapa no mubusisi, mi esitopa no masole sonje sebeli simutinguluka. ");
INSERT INTO lyn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mi sebeli amutubula eikumango yaye ni kumu fuka olwambi no mucaa. ");
INSERT INTO lyn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","cwale sebeli amutingela en̄ata no myunguya nikumu fuka yo ku mutwi waye. Sebeli amulemisa olutaka ku lyooko no silyo ni kukubama okumusheka okwamba nji, “Yoshoo uyoye, wene Ombumu no Majuda!” ");
INSERT INTO lyn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Cwale sebeli amusibwela amate ni kushimba olutaka ni kumufula mu mutwi. ");
INSERT INTO lyn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mi cwale aba ana kumana oku muyandisa, sebeli amutubula olwambi no mucaa ni kumufuka eikumango yaye. Cwale sebeli amutwala oka mungongotela. ");
INSERT INTO lyn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Amasole aba na taanga ngeso ni Jesu sebeli akuwana ni mulume oisaniwa Simoni, omunu no mulenen̄i no Silene, mi sebeli amukandimeka nji ashimbe esifapano sa Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sebeli akeela ba sibaka siisaniwa Gologota, “Okutalusa nji esibaka no katendele.” ");
INSERT INTO lyn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sebeli atambeka Jesu ebeine ina ku wanekiwa ni nyoko nji anwe, kono aba na ku lupamo sebeli okana okwiinwa. ");
INSERT INTO lyn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mi cwale aba ana kumana okumu ngongotela sebeli akutabela eikumango yaye muku shebuluka. ");
INSERT INTO lyn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Cwale sebeli aikala banji niku mu tatelela. ");
INSERT INTO lyn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Cwale beulu no mutwi waye kame ana ku beekabo elin̄olo no mubonda waye eli lyamba nji, “Uyu ni Jesu Ombumu no Majuda.” ");
INSERT INTO lyn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Cwale sebeli angongotela ni isinyi yiili ni yonye, esinjili ku lyoko lyaye no silyo ni sinjili kweli no simoo. ");
INSERT INTO lyn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mi awo ana ku bitanga na ku munyefula ni kunyunga emitwi yoo, ");
INSERT INTO lyn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ni kwamba nji, “Wene woyo utwesa oku shandola endoo ya Nyambe ni kwiyaka kame mu maywaa aatu! Okuyoyise wenyene nji yawene Omwana Nyambe Otuluke ba sifapano wiiye banji!” ");
INSERT INTO lyn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mi noonyene apulisita akulu sebeli amuyandisa, ba mweya na iyeti no mulawo nakulu, aamba nji, ");
INSERT INTO lyn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Kame ana kuyoyisanga akwaye, kono katwese oukuyoyisa yonyene! Kame amba nji ni Mbumu no Isilaele. Nji kame sa kutulule ba sifapano mba tu pumene kwa yonyene! ");
INSERT INTO lyn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kame ana ku sepanga Nyambe, mulesele Nyambe amu lamulele cwale nji Nyambe kame asinga ngeeso, kakuli kame anamba nji, “Time Mwanaye Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mi ni isinyi yiili ina ku ngongoteliwa ni yonyene ba sifapano sebeli imunyefula ngeeso. ");
INSERT INTO lyn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Oku tangisa mu nako no munji, ouwi sebeli ufuka elitunga lyonje mu tihola taatu. ");
INSERT INTO lyn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mi aba ina kukwana enako no 3 okoloko Jesu sebeli olila ni liywi no kuneneba ni kwamba nji, “Eloi, Eloi, lema sabakatani?” Ninji, “Nyambe wange, Nyambe wange iikene ona ni leselele?” ");
INSERT INTO lyn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Cwale anjili ana kwimana omo aba ana kuyupa eyo, sebeli amba nji, “Uyu mulume kame aisana Eliya!” ");
INSERT INTO lyn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ababo omunjili kwa onyene sebeli oituka oka shimba esiponji esi siiyalile ebenega, sebeli osi beeka ku lutaka ni kumu nwisa. ");
INSERT INTO lyn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kono anjili sebeli amba nji, “Tumusiye, tumone nji Eliya mba iyi muku muyoyisa!” ");
INSERT INTO lyn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Cwale Jesu sebeli olila kame ni liywii no kuneneba, mi sebeli obwelwa Emebo. ");
INSERT INTO lyn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ba nako eyeyo olwambi namu Ndoo ya Nyambe sebeli lu kauka bakaci, oku tangisa ku wilu konji banji. Mi sebeli kwiiya ezikinyeho, amawee sebeli akaoka. ");
INSERT INTO lyn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Cwale amabita sebeli ayatuluka mi eitupu no aanu no kupula a Nyambe ana kufa sebeli inguka. ");
INSERT INTO lyn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nakutunda mu mabita munyima ya Jesu okwinguka kwaafu, mi sebeli aingena mu mulenen̄i no kukena ni kumonahala kwaanu onje ano kupula. ");
INSERT INTO lyn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Cwale omukulu no masole, nawo ana ku tatelela Jesu noo, aba ana kumona ezikinyeho neeyi ina kutendahala sebeli acila onene ni kwamba nji, “Niti luli, woyo mulume neli Mwanaa Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Akati no kupula mwa na kwikala omo, aalikete, aali aba no kuleba, okame ana kukon̄a Jesu aba ana kutunda ku Galileya, amu belekela. ");
INSERT INTO lyn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kwa onyene kame kuna kwikala omukati wisaniwa nji Maliya Magadalena, ni Malia inawaye Jakobo ni Josefa, ni mukataye Zebadeya. ");
INSERT INTO lyn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cwale mu nako no mangolwaa, sebeli kwiiya omulume ona kufuma, na ku Alimateya, ona kwiisanwa nji Josefa, mini yonyene neli omwiyetwa wa Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Sebeli ota kwa Pilato, nukakumbela olutu lwa Jesu, cwale Pilato sebeli olaela nji abiwe. ");
INSERT INTO lyn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Cwale Josefa sebeli oshimba olutu, ni ku lupungela mu lwambi no kukena ni kuwaba, ");
INSERT INTO lyn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Mi sebeli okabeeka esitupu mu libita lyaye eli no ubya, eli ana ku cakula mu liwee. Sebeli obeeka eliwee no kuneneba ba mwelo no libita mi sebeli okutela. ");
INSERT INTO lyn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliya Magadalena ni mukwaye Maliya kame na ikalanga aalikete ku mwelo no libita. ");
INSERT INTO lyn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Eliywaa lina kutatama elino Sabata, apulisita akulu na Falisi sebeli aka kuwanena kwa Pilato ");
INSERT INTO lyn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","sebeli amba nji, “Mbumu, tu si puluka nji omoongi woyo yo si yoya, kame ana kwamba nji, ‘Munyima no maywaa aatu, mba ni inguka kame.’ ");
INSERT INTO lyn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Cwalehe olaele nji elibita li tatelelwe onene, ku twala ba liywaa no waatu, mwendi aiyetwa aye mba fanene okwiiya mu kwiita olutu lwaye, aambele esicaba nji, ‘Na inguka kwaafu.’ Abo okoonga no mamaneneno kame sa kutende oku no kwiiba okubita ba weli.” ");
INSERT INTO lyn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato sebeli wamba kwa onyene nji, “Mushimbe atateleli no masole, mute mu ka tatelele omo mu tweseta monje.” ");
INSERT INTO lyn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Sebeli ata na tateleli nu kabeeka esisupo ba liwee no ba libita nji cwale kakwisa omunu sotwesa okuli sheeta. ");
INSERT INTO lyn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Munyima no liywaa no Sabata, elino matatekelo mu sunda amasikusiku aba lina kupa, Maliya Magadalena ni Maliya munjili, sebeli ata muku mona ku libita. ");
INSERT INTO lyn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ababo sebeli kwikala ezikinyeho inene luli, kakuli elingeloi no Mbumu na likutunda kuwilu ni kwiiya muku pikulusa eliwee ba libita, ni kwikala ba liwee. ");
INSERT INTO lyn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kame lina kumonahala kanyi olumonyi no mbula, ni ikumango yalyo no likena kanyi elitwaa. ");
INSERT INTO lyn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Atateleli sebeli acila ni kukun̄a, mi sebeli amonahala kanyi omunu no kufa mulibaka no kumona elingeloi. ");
INSERT INTO lyn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Elingeloi sebeli lyamba kwakati nji, “Mulese kucila,” “Kame ni limukile nji kame musaela Jesu onaku ngongotelwa ba sifapano. ");
INSERT INTO lyn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ka sako kuno, kakuli Nyambe na mwingula kwaafu, kanyi omu ana kwambela Jesu. Ko mwiye mumone mu sibaka ana ku langana. ");
INSERT INTO lyn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Cwale mute mu lelube, mi mu kambele aiyetwa aye nji, ‘Nyambe namwingula kwaafu, mi kame akatile balubala lwenu okuta ku Galileya, okoko kwa samu ka mumone. Aa amaywi nineyele muku myambela.” ");
INSERT INTO lyn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Cwale sebeli atunda muwangu ku libita acilile ni kuwabelwa onene, sebeli aituka nu kambela aiyetwa aye. ");
INSERT INTO lyn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Cwale aba ana taanga mukwambela aiyetwa aye, Jesu sebeli okuwana noo ni kwa keeta mi sebeli aiya kwa yonyene, ni kumulema ku makondo ni kumulapela. ");
INSERT INTO lyn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Cwale Jesu sebeli wamba kwa onyene nji, “Mulese ku cila,” “Mute mukambele abaange nji ate ku Galileya kwasa kani mone.” ");
INSERT INTO lyn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ababo akati akatile, atateleli anjiili sebeli ata mu mulenen̄i okabihela apulisita akulu eyi ina tendahala yonje. ");
INSERT INTO lyn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Cwale apulisita akulu nakulu sebeli akuwana ni kulelisana. Sebeli aba amasole amali no kupula, ");
INSERT INTO lyn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ni kwaambela nji, “Mwambe nji, aiyetwa aye kame aneyi ousiku, mi naiiti olutu lwaye, aci metu langanine. ");
INSERT INTO lyn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nji omubusisi aba sa yupe etaba eyo, mba tu mu kolwisa, ni kumi tundisa mu utata.” ");
INSERT INTO lyn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Cwale sebeli ashimba amali ni kutenda kanyi omo anaku laelelwa. Mi etaba eyi nai kuhasana mukaci no Majuda mi isambiwa ni balelo lino. ");
INSERT INTO lyn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Cwale aiyetwa ana kukwana likumi ni mu mweya (11) sebeli ata ku Galileya, ku lilundu elyo ana kwasimweta Jesu. ");
INSERT INTO lyn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Cwale aba ana kumu mona, sebeli amu kubamena, kono anjili alimbululile. ");
INSERT INTO lyn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Cwale Jesu sebeli oiya kwa onyene ni kwaambela nji, “Etukelo yonje namu wilu ni mu litunga kame ina biwe kwa mene. ");
INSERT INTO lyn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mute cwale mu katende aiyeti no macaba onje, mwa kolobeze mu litina lya Sitange, ni lya Mwana, neli no Mebo No Kukena. ");
INSERT INTO lyn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mi mwaiyete oku mamela einu yonje nina milaelele. Mi mupuluke nji, kame nili nenu mu nako yonje, okutwala ku mamaneneno no litunga.”");
INSERT INTO lyn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aa amaywi no Kuwaba a Jesu Kilesite Omwana Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kanyi omo ku n̄olelwe mu buka no omunuhi wa Nyambe Isaya nji, “Omone, ‘Kame ni tuma onumwana wange balubala no lubala lowe woyo so lukisa endila yowe,’ ");
INSERT INTO lyn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Eliywi lya woyo okuweleza mu lihalaupa, Mu lukise endila no Mbumu, mutende etindila no kooloka nji yonyene abitemo.” ");
INSERT INTO lyn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Cwale Jowani omukolobezi sebeli omonahala mu lihalaupa, yo lemine okukutaza ekutazo no kubaka nji, “Mufutuke mi mu kolobeziwe cwale Nyambe mbami lemene ouyi wenu.” ");
INSERT INTO lyn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aanu no kupula ali mu tolopo no Judeya onje, naa ayakile mu mulenen̄i no Jelusalema onje, sebeli abanena kwa yonyene mukuteeteta, mi asimana okwamba etifoso too, sebeli akolobeziwa mu musindi wa Jodani kwa Jowani. ");
INSERT INTO lyn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jowani kame ano kufuka esikumango no woya no kamele, ni lukanda no situmba mu mbunda, mi kame ana kuyoya etimbimba ni uki mu mushitu. ");
INSERT INTO lyn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mi kame ana kwiiyeta aanu nji, “Mu nyima yange, kame kwiiya omunjili uyu unibita ku maata, mi kanilukela okwinama ni kunungutula etikwele no tinjatangwa taye. ");
INSERT INTO lyn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mene, kame ni mikolobeza ni meyi, kono yonyene kame sami kolobeze ni Mebo No Kukena.” ");
INSERT INTO lyn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ba nako eyo, Jesu sebeli otunda mu Nazaleta omundi na mu tolopo no Galileya, mi sebeli okolobeziwa kwa Jowani mu musindi no Jodani. ");
INSERT INTO lyn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ababo Jesu aba ana kukatunda mu meyi, sebeli omona eliwilu liyatuluka, mi Emebo No Kukena ifeka kanyi elikwici sebeli ishulumukela kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mi sebeli ku yupahala eliywi litundelela ku wilu, elyamba nji, “Wene yo mwana nge osingwa, uyu ni katelelwa onene.” ");
INSERT INTO lyn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ababo, Emebo No Kukena sebeli imutwala mu lihalaupa. ");
INSERT INTO lyn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesu sebeli okaikala mu lihalaupa amaywaa makumi anee, yo etekiwa kwa Satani. Mi kame ana kwikalanga ni ibatana, mi amangeloi na ku mu babalela. ");
INSERT INTO lyn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Cwale munyima no kunungiwa kwa Jowani ni kubeekiwa mu tolongo, Jesu sebeli oiya mu Galileya yo kutaza eliywi no kuwaba lya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mi sebeli wamba nji, “Enako na ikwana, mi omubuso wa Nyambe kame uli beebi. Mubake, mi mu pumene ku liywi no kuwaba.” ");
INSERT INTO lyn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Cwale Jesu aba na endanga ku munanga no lisa no Galileya, sebeli omona Simoni ni minaye Adiliyasi, ayamba otunyandi too mu liwate kakuli neli anduyi. ");
INSERT INTO lyn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesu sebeli wamba kwa onyene nji, “Munikon̄e, mi kame sa ni mitende asiku yamba aanu.” ");
INSERT INTO lyn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mi ababo sebeli asiya otunyandi too ni kumukon̄a. ");
INSERT INTO lyn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Aba ana kusheteta kuusombicani, sebeli omona Jakobo mwanaa Zebedeya ni Jowani minaye, nonyene kame ana kwikala mu wato, alemine okoongolola otunyandi too. ");
INSERT INTO lyn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mi ababo sebeli waaisana mu wangu, mi sebeli asiya sitoo Zebedeya mu wato nawo ana kuteneka okwatusa ni kumukon̄a. ");
INSERT INTO lyn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mi sebeli ata mu Kapenauma, mi ababo ba liywaa no Pumulo, Jesu sebeli oingena mu Ndoo no milapelo no Majuda ni kwiiyeta. ");
INSERT INTO lyn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aanu sebeli akomoka onene mulibaka no tuto yaye, kakuli kame ana kwiyeta kanyi omunu oli ni maata, kasa kanyi aiyeti no mulawo. ");
INSERT INTO lyn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ababo, aali mu Ndoo no milapelo omulume no mebo no kwakena, sebeli wiiya nikukuwa nji, ");
INSERT INTO lyn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iikene usaela kwaaci wene Jesu no Nazaleta? Ninji kame oneeyi mu kutumana? Ni ku limukile nji tiwe anyine, tiwe Woyo no Kukena omutumiwa wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kono Jesu sebeli oikalimela nji, “Ondoka! Otunde mwa yonyene.” ");
INSERT INTO lyn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Cwale emebo no kwakena sebeli imukwiseta banji mu koongola, mi sebeli itunda mwa yonyene yokuwa ni liywi no ku neneba. ");
INSERT INTO lyn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mi aanu onje sebeli akomoka, sebeli akwambisa mukaci koo nji, “Esi ni siikene? Eyi ni tuto no ubya? Kame akwite amaata no kulaela emebo no kwiiba, mi kame imu kuteka!” ");
INSERT INTO lyn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ababo elibubo lyaye sebeli lita kule, mu tolopo yonje no Galileya. ");
INSERT INTO lyn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cwale ababo Jesu aba natunda mu Ndoo no milapelo no Majuda, sebeli oingena mu ndoo ya Simoni ni Adiliyasi, yoli ni Jakobo ni Jowani. ");
INSERT INTO lyn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Cwale onjemunwaa Simoni no mukati kame ana langananga, yotomine oweti no fibele eyi ingangamisa, ababo sebeli asimweta Jesu muwangu. ");
INSERT INTO lyn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Cwale sebeli osheteteta kwa yonyene, niku mulema ku lyoko mi sebeli omwingula, sebeli obala kuweeti no fibele, mi sebeli waa sebeleza. ");
INSERT INTO lyn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Amangolwaa, eliywaa aba lina kwiika, sebeli ku litwa kwa yonyene asi kutoma, naa aingenwe Emebo no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aanu mu mulenen̄i wonje sebeli aungana ba mwelo waye. ");
INSERT INTO lyn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mi cwale sebeli obalisa aanu no kupula awo ana kutomanga ameeti no mifuta-futa, ni kucita Emebo no kwiiba no kupula, mi kasipumenena Emebo no kwiiba nji yaambe kakuli kame imulimukile. ");
INSERT INTO lyn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Amalungasiku, eliywaa elyakalisipa kale, Jesu sebeli oinguka, ni kuta ku sibaka no mbulwa aanu okuno kuleba yomboci oka lapela. ");
INSERT INTO lyn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Cwale Simoni naa ana kwikala naye mu ndoo sebeli ata mu ku musaela. ");
INSERT INTO lyn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Asimana oku muwana, sebeli amwambela nji, “Aanu onje kame aku saela.” ");
INSERT INTO lyn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Cwale sebeli waatambula nji, “Twendeni kwibaka indina lili beebi ni mindi, ni ka kutazeko kame, kakuli omusebezi nina iyele.” ");
INSERT INTO lyn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mi sebeli ota ngeeso ni mu Galileya monje, yo kutaza mu tindoo no milapelo no Majuda, ni kucita Emebo no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Cwale omulume osi mbingwa sebeli wiiya kwa Jesu ni ku mukubamena ni manwi okukumbela ni kumwambela nji, “Nji aba usinga, kame utwesa okunibalisa.” ");
INSERT INTO lyn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesu sebeli omufela amakeke, ni kolola elyoko lyaye okumulema, ni ku mwambela nji, “Ni singa, mi okene.” ");
INSERT INTO lyn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cwale ababo embingwa sebeli ibwa kwa yonyene, ni kukenisiwa. ");
INSERT INTO lyn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Cwale Jesu sebeli omulemusa mukongota, ni kumuusa muwangu, ");
INSERT INTO lyn_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ni ku mwambela nji, “Omone nji olese okwambela omunu esinjili, kono weende oka ku monahaze kwa mupulisita, obe esitabelo sowe mukukenisiwa kowe esi silaelwe kwa Mushe, kutendiwe oupaki kwaanu.” ");
INSERT INTO lyn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kono omulume woyo aba kuta sebeli otangisa okutalusa etaba eyo yolukuluhile, ni kwihasanya konje, mumukwanongeso Jesu sebeli okwangwa okwingena mu tolopo injili aanu amumwine, kono kame ana kwikalanga ku mukunda, mi aanu no kupula kame ana kutundanga mu mabaka onje, ni kwiiya kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Munyima no maywaa acana Jesu abana ukela ku Kapenauma, aanu sebeli ayupa nji kame ali mu ndoo. ");
INSERT INTO lyn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Cwale aanu no kupula sebeli aunganamo, mane sebeli akwangwa oku kwanamo konji ni ba mwelo, mi yonyene yokutaza eliywii kwa onyene, ");
INSERT INTO lyn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","cwale alume anee sebeli aiya kwa Jesu ashimbile omulume no ku kutela olun̄an̄ali. ");
INSERT INTO lyn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kono sebeli akwangwa okusheteta kwa Jesu mulibaka no aanu okupula, mi sebeli ashuula esituwa no ndoo abo ana kwikalela Jesu niku shulumukisetamo omuseme abo ana kulangana omulume osi kukukutela olun̄an̄ali. ");
INSERT INTO lyn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Cwale Jesu aba ana kumona etumelo yoo, sebeli wamba kwa woyo osi kukutela olun̄an̄ali nji, “Mwana nge, eibi yowe na wilemenwe.” ");
INSERT INTO lyn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Aiyeti anjili no mulawo ana kwikala omo, sebeli anahana mu micima yoo nji, ");
INSERT INTO lyn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Uyu mulume, ngaibi aba aamba ngeesi? Kame anyefula! Woyo otwesa okulemena eibi anyine konji Nyambe yomboci!” ");
INSERT INTO lyn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesu sebeli olimuka mu wangu ni mebo yaye nji kame akengeela ngeeso, mi sebeli waambela nji, “Iikene mukengeela mu micima yenu? ");
INSERT INTO lyn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Esi no kotoba ni sibine, okwambela osi kutoma olun̄an̄ali nji, ‘Eibi yowe nwilemenwe,’ ni ku mwambela nji, ‘Imana, oshimbe oulangano wowe, mi wende?’ ");
INSERT INTO lyn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Cwalehe nji mu limuke nji, Omwana no Munu kame ali ni maata bano banji no ku lemena eibi, sebeli wambela osi kukukutela olun̄an̄ali nji, ");
INSERT INTO lyn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kame nikwaambela nji oimane, oshimbe oulangano wowe, mi okutele ku mundi wowe.” ");
INSERT INTO lyn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Cwale woyo sebeli oimana, mi ababo niku shimba oulangano waye nuukutela yo monwa kwaanu onje, mi sebeli akomoka onje ni ku lumba Nyambe nji, “Asimbakwatanga, katu mono etaba no ngeesi!” ");
INSERT INTO lyn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Cwale Jesu sebeli ota kame ku munanga no lisa no Galileya, mi aanu no kupula onje sebeli sisheteta okuungana kwa yonyene, mi sebeli waaiyeta. ");
INSERT INTO lyn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mi yoenda mu ndila, sebeli omona Lebi omwana Alufeya, yo ikalile ba ofisi no mutelo, mi sebeli omwambela nji, “Onikon̄e.” Lebi sebeli oimana, niku mukon̄a. ");
INSERT INTO lyn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mi Jesu yo ikalile ba tafule mu ndoo ya Lebi, asikutelisa no kupula na sikutenda eibi sebeli aikala naye ba tafule na iyetwa aye, kakuli aanu no kupula kame ana ku mukon̄a. ");
INSERT INTO lyn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Cwale aiyeti no mulawo no afalisi aba ana kumona Jesu yo lya na sikutelisa na sikutenda eibi, sebeli aibanguta aiyetwa aye nji, “Iikene Omolyenu aba alya ni kunwa naanu no ngeeso?” ");
INSERT INTO lyn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mi cwale Jesu aba na yupa eyo, sebeli waatambula nji, “Awo ayoya wino ka saele onganga, kono kame asaelwa kwaa tomine. Kani siiya nji ni isane awo alukile, kono asikutenda eibi.” ");
INSERT INTO lyn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Cwale aiyetwa a Jowani na Falisi kame anooku yumenanga eilya, mi aanu sebeli aiya kwa Jesu niku mwibanguta nji, “Iikene aiyetwa a Jowani na Falisi aba aku yumenanga eilya, kono ikene aiyetwa owe abaka ku yumenanga eilya?” ");
INSERT INTO lyn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu sebeli waatambula nji, “Kana kame kutwesahala nji alikani no mukwati aku yumene eilya, omukwati yo sili kwa onyene? Omukwati yosili kwa onyene, kakutwesahala nji aku yumene eilya. ");
INSERT INTO lyn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kono enako kame iiya, eyo omukwati aba sa tundisiwe kwa onyene, abohe, kame sa kuyumene eilya mu liywaa elyo. ");
INSERT INTO lyn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Kakwisa omunu so beeka esimanahanyi no ubya ba sikumango no kukulubala, kakuli esimanahanyi no ubya mba sikaula esi no kukulubala, mane kwikezehe abono kukauka. ");
INSERT INTO lyn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kame kakwisa omunu so itela ewaine no ubya mu singumbuli no kupangiwa ba itumba no kukulubala, aba ku tendiwa ngeeso, ewaine no ubya kame ikaula esingumbuli sipangilwe ba situmba, mi ewaine kame isinyeha bamweya ni singumbuli sipangilwe ba situmba. Kono ewaine no ubya kame itelwa mu singumbuli sipangilwe ba situmba no ubya.” ");
INSERT INTO lyn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Eliywaa linjili eli no Pumulo, Jesu yo bita mu matema no uloto na iyetwa aye alemine okucola ni kububula oubeke. ");
INSERT INTO lyn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Cwale Afalisi sebeli amba kwa Jesu nji, “Komone, aiyetwa owe ikene aba atenda esi no kwapumenenwa mu liywaa no Pumulo?” ");
INSERT INTO lyn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesu sebeli waatambula nji, “Ka musibala esi sinaku tendiwa kwa Dabida, enako ana ku ulwa esi no kulya, mi yoyombile, yonyene naa ana kwikala naye? ");
INSERT INTO lyn_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Omo ana kwingenena mu ndoo ya Nyambe, omupulisita omukulu yoli Abiatale, mi nolya ku inkwa ina kubeekelwa Nyambe, eyi ina kulukela okuliwa kwa pulisita feela, mane Dabida na kubako naa ana kweenda naye.” ");
INSERT INTO lyn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mi Jesu sebeli wekeza nji, “Eli no Pumulo kame litendelwe aanu, kasa omunu okutendelwa eli no Pumulo, ");
INSERT INTO lyn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mihe, Omwana no Munu ni Mbumu neli no Pumulo.” ");
INSERT INTO lyn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Cwale Jesu abana kuukela kame mu Ndoo no milapelo no Majuda, mi omo kame kuna kwikalanga omulume no kombola elyoko. ");
INSERT INTO lyn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aanu sebeli aaliketa Jesu okumona nji, kana mba mubalisa mu liywaa no Pumulo, nji awane omo no kumunungelela eyambo. ");
INSERT INTO lyn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu sebeli wambela omulume no lyoko no kombola nji, “wiiye kuno ku lubala.” ");
INSERT INTO lyn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Cwale sebeli waaibanguta nji, “Esi sipumenenwa mu liywaa no Pumulo, okutenda wino nji okutenda ouyi? Oku yoyisa omunu nji oku mwibaa?” Kono sebeli aondoka feela. ");
INSERT INTO lyn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Cwale sebeli waaliketa onje ni miyo yo tinine ni kufilikana onene, mulibaka no micima yoo no kongola, sebeli wamba ku mulume nji, “Oolole elyoko lyowe.” Sebeli olyolola, ababo elyoko lyaye sebeli libala. ");
INSERT INTO lyn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ababo Afalisi sebeli atunda mu ndoo no milapelo no Majuda okalelisana nasi Heloda omo sa ibaele Jesu. ");
INSERT INTO lyn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Cwale Jesu na iyetwa aye sebeli ata ku lisa no Galileya. Mi aanu no kupula sebeli amukon̄a okutunda mu Galileya, mu Judeya, ");
INSERT INTO lyn_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","mu Jelusalema, ku Idumeya ni mu naha na mulinjaliya no Jodani, ni mu naha ikubapile ni Tile ni Sidoni, aba ana kuyupa eyi ana tende yonje, sebeli aiya kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mi cwale Jesu sebeli wambela aiyetwa aye nji amu lukisete owato, mulibakano aanu okupula, nji alese oku sinanisiwa. ");
INSERT INTO lyn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kakuli kame ana ku balisa aanu no kupula, mi cwale awo onje ana kutoma ameeti kame ana lwelanga kwa yonyene oku mulema. ");
INSERT INTO lyn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Cwale aanu ana kwikalanga ni mebo no kwakena aba ana kumumona, sebeli akwela mu makondo aye ni kukuwa nji, “Ya wene Omwana Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Cwale Jesu sebeli waalaela nji alese okumu limukisa. ");
INSERT INTO lyn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Cwale Jesu sebeli ota ba lilundu nukaisana awo anaku singa onje, mi sebeli aiya kwa yonyene, ");
INSERT INTO lyn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","mi sebeli oketa ano kukwana likumi na yiili (12), awo ana kutumbiwa elitina no atumiwa, nji aikala naye ni kwatuma nji akakutaze aanu, ");
INSERT INTO lyn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ni kwaaba amaata no kucita emebo no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aa ana kukwana likumi na yiili (12) ana kuketa, neli Simoni uyu ona bekiwa elitina lya Pitolosi, ");
INSERT INTO lyn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","anjili naa, Jakobo ni minaye Jowani ana a Zebedeya, awo, nakwabeka elitina lya Boanegesi, ninji aana no mulumo no mbula. ");
INSERT INTO lyn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Adiliyasi ni Filipi ni Batolome ni Mateu ni Tomasi ni Jakobo omwana Alufea, Tadeya ni Simoni no Mukanana, ");
INSERT INTO lyn_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Judasi Sakalyote ona ku mubeteka. ");
INSERT INTO lyn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Cwale Jesu sebeli oukela ku ndoo, mi aanu no kupula sebeli aiya kame, mane Jesu na iyetwa sebeli akwangwa okulya. ");
INSERT INTO lyn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mi abaaye Jesu aba ana kuyupa nji mwaali, sebeli aiya nji amushimbe, kakuli aanu nakwamba nji, “Kame apulumuka.” ");
INSERT INTO lyn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Cwale aiyeti no mulawo aa na kutunda mu Jelusalema, ni kwamba nji, “Kame akwite amaata no Beeluzebule mwa yonyene, mi naaba acita emebo no kwiiba ni mu maata no mukulu no mebo no kwiiba.” ");
INSERT INTO lyn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesu sebeli waaisana, ni kwamba noo mu nguli nji, “Satani ngaibi sa twese okucita Satani? ");
INSERT INTO lyn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mi omubuso aba uku futukela ookulwisa, omubuso owo kame sa ukutabe bakaci mi kautamba okwimana. ");
INSERT INTO lyn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na asindoo imweya aba akulwisa, endoo eyo kaitamba kwimana. ");
INSERT INTO lyn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Cwale nji Satani kame akulwisa, nuukutaba, ka twese okwimana, kono kame satende amamaneneno aye. ");
INSERT INTO lyn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Cwale kakwisa woyo so ingena mu ndoo no ndume no koongola, nji ashimbe einu yaye, konji aba sa tangise okununga omulume woyo no ndume, mi cwale basatwese okumushimbela einu aye. ");
INSERT INTO lyn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Niti luli kame ni myambela nji eibi yonje no aanu mba ilemeniwa, bamweya ni tinyefulo too. ");
INSERT INTO lyn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kono omunu yonje so nyefula Emebo No Kukena, ka tamba oku lemenwa, kono kame ali ni mubonda no sibi no kwaabwa.” ");
INSERT INTO lyn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu na kwamba ngeeso, kakuli aanu kame ana kwambanga nji, “Kame ali ni mebo no kwakena.” ");
INSERT INTO lyn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Inawaye Jesu na inaaye sebeli akeela ni kwimana ba ndee, mi sebeli atuma omunu okamwisana mu Ndoo. ");
INSERT INTO lyn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Aanu no kupula aikalile, amu beekile mukaci. Sebeli aambela Jesu nji, “Inaowe na inoowe kame ali ba ndee, kame aku saela.” ");
INSERT INTO lyn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kono Jesu sebeli waatambula nji, “Inawange na inange anyine?” ");
INSERT INTO lyn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Sebeli waliketa aanu ana kwikala naye mu Ndoo amu beekile mukaci, mi sebeli wamba nji, “Ko mumone, ainawange na inange okame aa!” ");
INSERT INTO lyn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kakuli omunu yonje woyo otenda esi sisingwa kwa Nyambe, yokame ominange, ni mandange ni Inawange.” ");
INSERT INTO lyn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesu sebeli otangisa kame okwiyeta aanu ba likamba no lisa, mi kakuli aanu no kupula kame anaku ungana kwa yonyene, cwale sebeli oingena mu wato ni kuta mu lisa, mi aanu mu kupula koo, sebeli aikala ba likamba. ");
INSERT INTO lyn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Cwale sebeli waaiyeta eno kupula mu tinguli, mi mu tuto yaye sebeli waaiyeta nji, ");
INSERT INTO lyn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Komuteetete! Omukuni na kuta okakuna, ");
INSERT INTO lyn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","mi yo lemine okukuna, embuto injili sebeli ikwela mu ndila, mi otuyunyi sebeli twiiya mu kwiilya. ");
INSERT INTO lyn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Embuto injili na ikukwela mu mumbu noku kukutela ni mawee, omo kuulwile omumbu no kupula, sebeli imena muwangu kakuli ka yasi kwingena onene mu mumbu. ");
INSERT INTO lyn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kono eliywaa aba lishashumuka, eyi ina mene kame iletuka, mi kakuli kame yulwile emibisi, kame ikukuta. ");
INSERT INTO lyn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Einjili embuto sebeli ikwela mu mikakani, emikakani aba ikula kame iipukelisa, mi embuto sebeli yuulwa okubeeka oubeke. ");
INSERT INTO lyn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Embuto injili sebeli ikwela mu mumbu no kuwaba, mi sebeli ikubeeka eilya no kupula, naiku mena ni koongola, mi embuto imweya sebeli ibeeka amakumi aatu, einjili amakumi mutanu ni kamweya, einjili kame sebeli ibeeka omwaanda. ");
INSERT INTO lyn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ku mamaneneno Jesu sebeli wamba nji, “Woyo okwite amatwi ayupe mi ayupisise.” ");
INSERT INTO lyn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ababo Jesu yoli yomboci, awo ana kwikala na iytwa aye, sebeli amwibanguta etuso no tinguli. ");
INSERT INTO lyn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Mi sebeli waambela nji, “Anyi na mubiwi oku limuka etikunutu no mubuso wa Nyambe, kono aa ali kundee kame abeekelwe einu yonje mu tinguli. ");
INSERT INTO lyn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nji cwale, Asikumona mbamono, kono katamba kuyupisisa, ni kuyupa ayupe, kono alese oku yupisisa, Mane kame afanene oku siuluka, nji awane okulemenwa.’” ");
INSERT INTO lyn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Cwale Jesu sebeli wamba kwa onyene nji, “Ninji ka mu yupisisa enguli eyo? Ngaibi cwale sa mu yupisise etinguli tonje? ");
INSERT INTO lyn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Osikukuna, woyo okuna Eliywi. ");
INSERT INTO lyn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Embuto ina kwele mu ndila kame ikufekile kanyi aanu awo ayupa eliywi kono ababo Satani kame aiya ni kulitundisa mwa onyene. ");
INSERT INTO lyn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aanu anjili kame akufekile kanyi embuto ina kwele ba mumbu no mawee, aba ayupa eliywi, ababo kame alitambula mu kuwabelelwa, ");
INSERT INTO lyn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","mi kakwite emibisi, kono kame atundamena enako icana fela, mihe outata simba amayando aba yiiya mulibaka no Liywi, ababo kame akwa. ");
INSERT INTO lyn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Anjili aanu kame akufekile kanyi embuto ina kwele mu mikakani, okame awo ayupa eliywi, ");
INSERT INTO lyn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kono etipilaelo no litunga ni kongiwa ku ufumu niku lakaza einjili, aba ingena kwa onyene kame ipukutisa eliywi, mi kaibeeke embuya. ");
INSERT INTO lyn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kono anjili aanu kame akufekile kanyi embuto ina kuniwa ba mumbu no kuwaba, okame awo ana yupu eliywii ni kulitambula ni kubeeka embuya, embuto injili naibeeke eyi ikwana makumi aatu, injili makumi mutanu ni kamweya, einjili ikwana omwanda. ");
INSERT INTO lyn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Cwale Jesu kame sebeli wamba nji, “Aba mulita elambi kame ibeekiwa mu tubana nji munji no mumbeta, kasa okwibeeka aba ku monahala? ");
INSERT INTO lyn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Cwale kakwisa esinu esi sishweekilwe, konji si shootolwe, simba esinu sina tendiwa ku mukunda konji siiye ba ngandaleza. ");
INSERT INTO lyn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nji omunu kame akwite amatwi no ku yupisa, a yupe!” ");
INSERT INTO lyn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mi kame sebeli waambela nji, “Mutokomele kweeyi mu yupa, omo mutendela akwenu, mwasamu tendelwe naanyi, mane niku bitelela. ");
INSERT INTO lyn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ku munu woyo okwite esinu sinjili mba bekelwa mukupula, kame kwa woyo ulwile, nesi ali naso mba byanguliwa simba eso alinaso. ");
INSERT INTO lyn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesu sebeli wamba kame nji, “Omubuso wa Nyambe kame ukufekile kanyi omunu okwaa embuto mu litema lyaye. ");
INSERT INTO lyn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Simba alangane nji atone omunji ni usiku, embuto kame ikula ni kubeeka, yo kalimukile omo ina menene. ");
INSERT INTO lyn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kakuli omumbu onyene kame ubeeka, oweli omutungo, okubinda omukun̄u, basa kwiiye oubeke ba mukun̄u. ");
INSERT INTO lyn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kono oubeke aba wiimba, mu nako imweya kame abeeka ecekesi, kakuli enako no kutulo nai kwana. ");
INSERT INTO lyn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Cwale kame sebeli wamba nji, “Siikene eso tutwesa oku faniketa ni mubuso wa Nyambe, simba ka nguli eyo satukutusise okwamba eyi? ");
INSERT INTO lyn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kame ikufekile kanyi embuto no Masitete, eyo aba ikuniwa mu mumbu, ni mbuto icana onene ku timbuto tonje na mu litunga, ");
INSERT INTO lyn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","cwale aba ikuniwa kame ikula ni ku tenda esimena sinene okubitelela yonje eyi ikuninwe mu litema ni kubeeka emitai inene, mane cwale otuyunyi na kuwilu kame tutwesa okuyaka eiyaleto mu mwinda waso. ");
INSERT INTO lyn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesu na kwasimweta amaywi mu tinguli okukumanena mukuyupisisa koo. ");
INSERT INTO lyn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ka sikwaambela okuulwile enguli, kono ku mukumda nakwa mbelanga aiyetwa aye eyambo yonje. ");
INSERT INTO lyn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mu liywaa elyo, mu nako no mangolwaa, Jesu sebeli waambela nji, “Tulutelenyi mu linjaliya no lisa.” ");
INSERT INTO lyn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aba ana kumana okuusa aanu no kupula, aiyetwa sebeli akulonga mu wato omo ana ikalanga Jesu, ni mato anjili kwana kwikalanga. ");
INSERT INTO lyn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mi elin̄ungwa linene sebeli liinguka, mi amandinda sebeli aiya nikufula ba wato mane ni meyi sebeli atateka okwingena mu wato, mane owato sebeli osinga okwiyala ku meyi. ");
INSERT INTO lyn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kono Jesu yo langanine yoli mutulo ku litusi no wato na kunyima ana kwikala yosamine ba musamo, sebeli amwingula ni kwamba kwa yonyene nji, “Mwiyeti, kaukwite taba naaba tufaa?” ");
INSERT INTO lyn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Cwale Jesu sebeli oinguka ni kukalimela emebo, ni kwambela elisa nji, “Ondoka!” Mi ababo emebo sebeli yimana, mi sebeli kwiiya okondoka kunene. ");
INSERT INTO lyn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Cwale Jesu sebeli wambela aiyetwa aye nji, “Iikene aba mu cila? Mu sikwangwa okupumena ni mu nako ino?” ");
INSERT INTO lyn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aiyetwa aye sebeli acila onene, mi cwale sebeli akwambisa nji, “Uyu anyine, nji mane emebo ni lisa imu kuteke?” ");
INSERT INTO lyn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesu na iyetwa aye sebeli akeela mulinjaliya no lisa mu sibaka no Magelaseni. ");
INSERT INTO lyn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ababo Jesu abana kutunda mu wato, sebeli okuwana ni mulume osi mebo no kwiiba, ");
INSERT INTO lyn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","uyu munu kame ana kwikalanga mu mabita, ka ku sikwikala omunu ona kutwesa okumununga simba ni mawenge. ");
INSERT INTO lyn_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Aka no kupula aba na kunungiwangwa amawenge ku makondo ni ku maoko, na kucolanga amawenge ni yoondo ku makondo aye, mi kakwisa ni munu ona kutwesa oku mubita ku maata. ");
INSERT INTO lyn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aka no kupula, ousiku ni munji kame ana kwikalanga mu libita ni ba malundu, yolemine okukuwa nukulemeka ku mawee. ");
INSERT INTO lyn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aba ana kumona Jesu yosili kule, sebeli witukela kwa yonyene, nikuka mukubamena, ");
INSERT INTO lyn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","mi sebeli okuwa ni liywi linene nji, “Iikene osaela kwa mene, Wene Jesu, Omwana Nyambe? Omwambakani uli-beulu? Kame ni ku kumbela weete kwa Nyambe nji kautamba ku ni yandisa!” ");
INSERT INTO lyn_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kakuli Jesu kame ana kwamba kwa yonyene nji, “Wene Emebo no kwiiba, otunde kwa uyu omulume.” ");
INSERT INTO lyn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Cwale Jesu sebeli omwibanguta nji, “Elitina lyowe tiwe anyine?” Emebo sebeli itambula nji, “Elitina lyange, time Mpi, kakuli kame tuli ano kupula!” ");
INSERT INTO lyn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mi sebeli omukumbela onene nji, alese oku citela emebo eyo oku no kuleba ni sibaka eso. ");
INSERT INTO lyn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Cwalehe, kame kuna kwikala omutapi munene no tingulube tinaku lyelanga kunyonga no lilundu elyo. ");
INSERT INTO lyn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Amadimona sebeli akumbela Jesu nji, “Otupumenene okwingena mu tingulube tica, tuka ingenemo.” ");
INSERT INTO lyn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ababo Jesu sebeli oipumenena, mi Emebo no kwakena sebeli itunda, nukaingena mu tingulube. Ababo omutapi sebeli witukela ba lin̄ope mi sebeli umatukela mu lisa, eli lifanena okutenda eikiti yiili (2,000) mi sebeli tikwela mu lisa ni kulwela. ");
INSERT INTO lyn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Alume no alisana sebeli acilako, mi sebeli ata mu ku simweta etaba eyo mu mundi oli beebi. Mi aanu no kupula sebeli aiya mu kumona eyi ina ku tendahala. ");
INSERT INTO lyn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Cwale sebeli aiya kwa Jesu, ni ku mona woyo onaku yandisiwa ku Mpi no madimona, yoikalile yo kufukile mane yokuketile, sebeli acila. ");
INSERT INTO lyn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mi awo ana kumona esisina kutendahala, sebeli ambela akoo esi sina kutendiwa kwa woyo omunu no mandimona, niku tingulube. ");
INSERT INTO lyn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Cwale sebeli atangisa oku kumbela kwa Jesu nji atunde mu naha yoo. ");
INSERT INTO lyn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mi Jesu yoingena mu waato, omunu no kwingenwa ku mebo no kwiiba sebeli oiya muku kumbela nji aikale naye. ");
INSERT INTO lyn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kono Jesu sebeli okana niku mwambela nji, “Ute ku ndoo yowe ni kwa boowe, mi okaambele monje omo ana kutendele Ombumu, noomo ana kufele amakeke. ");
INSERT INTO lyn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Cwale sebeli ota, ni kukatangisa okendisa eyambo yonje eyo ana mutendele Jesu mu (Dekapolisi) okutalusa nji esibaka no mindi likumi mi aanu onje sebeli akomoka onene. ");
INSERT INTO lyn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesu aba na kuukela kame mu linjaliya no lisa mu wato, aanu no kupula sebeli aungana kwa yonyene ku nyonga no lisa. ");
INSERT INTO lyn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Cwale sebeli kwiiya omunjili no akulu no sindoo no milapelo no Majuda, no litina lya Jailosi. Cwale aba anaku mona feela Jesu, sebeli okwela ku makondo aye. ");
INSERT INTO lyn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sebeli omukumbela onene nji, “Omwanange no mukatana kame ali beebi nikufa. Wiiye, omubeeke amaoko beulu, nji abale mi ayoye.” ");
INSERT INTO lyn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Cwale Jesu sebeli ota naye, mi aanu no kupula onene sebeli amukon̄a amu umbelele. ");
INSERT INTO lyn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ababo kame kuna kwikala omukati ona kutoma oweeti no mweeya, ba myaka likumi ni yiili, ");
INSERT INTO lyn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","omukati kame anaku yanda onene mukubangiwa kwa nganga no kupula, mi na kusinyehelwa onene eiluwo yaye yonje, kakwisa ni tuso ana ku mona simba icana, mane oweti waye na ukweekezeha onene. ");
INSERT INTO lyn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Cwale omukati woyo abana kuyupa eya Jesu, sebeli okukandimeka okwingena mwaanu no kupula, abana atumela Jesu munyima, mi sebeli omulema ba sikumango saye. ");
INSERT INTO lyn_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Abo sebeli okwambisa mu mucima waye nji, “Abasa nileme feele ku sikumango saye mbibala.” ");
INSERT INTO lyn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ababo omweeya waye sebeli wimana, mi kame ana kuyupa mu lutu lwaye nji nabala ku weeti waye. ");
INSERT INTO lyn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Cwale ababo Jesu sebeli oyupa mukaci kaye nji amaata naatundu mwa yonyene, sebeli okutemuna mukaci no aanu no kupula ni kwamba nji, “Anyine onaleme ku ikumango yange?” ");
INSERT INTO lyn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aiyetwa aye sebeli amutambula nji, “Kumwine nji aanu no kupula kame akuumbelele, ngasibine aba wibanguta nji, ‘Anyine ona kuleme?” ");
INSERT INTO lyn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kono Jesu sebeli okusetuka nji amone woyo ona tende ngeeso nji anyine. ");
INSERT INTO lyn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Omukati sebeli wiiya kwa Jesu yocilile ni kukun̄a, kakuli kame ana kulimuka esi sina kutendahala kwa yonyene, sebeli okukwiseta ku makondo aye, nikumwambela eniti yonje. ");
INSERT INTO lyn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesu sebeli wamba kwa yonyene nji, “Mwanange no mukati, etumelo yowe nai kuyoyisa. Ote ni kozo, mi obalelele luli ku weeti wowe.” ");
INSERT INTO lyn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesu osamba eyo, sebeli kwiiya aanu ana kutunda ku ndoo ya Jailosi, okwiiya muku mwambela nji, “Mwanowe nafu. Siikene eso okataleza Omwiyeti kame?” ");
INSERT INTO lyn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kono Jesu na kuulwa oku mamela amaywi awo, mi sebeli wambela Jailosi nji, “Olese kucila, kono opumene feela. ");
INSERT INTO lyn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mi Jesu sebeli okanisa aanu okumukon̄a, konji Pitolosi ni Jakobo, ni Jowani minaye Jakobo sebeli ata naye. ");
INSERT INTO lyn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jesu abana kakeela ku ndoo ya Jailosi, sebeli omona aanu aimanine amaefe-efe ni kulila onene. ");
INSERT INTO lyn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mi cwale abana ingena sebeli wamba kwa onyene nji, “Iikene aba mwimanine amaefe-efe ni kulila? Omwana kasifa kono kame alanganine feela. ");
INSERT INTO lyn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Cwale aanu sebeli amusheka, kono sebeli watundiseta bandee, sebeli oshimba sitaye ni nyinawaye nawo ana kwikalanga naye, ni kuta noo ku muzuzu oko kuna kulangana omwana. ");
INSERT INTO lyn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mukumu lema ku lyooko, sebeli wamba kwa yonyene nji, “Talita kumi” okutalusa nji, “Mwanuke munyonyo, kame namba kwa wene nji, inguka!” ");
INSERT INTO lyn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Cwale ababo omwanuke sebeli oimana, mi sebeli weenda, mi kame ana kwikala ni myaka likumi ni yiili. Cwale ababo sebeli akomoka onene luli. ");
INSERT INTO lyn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Cwale Jesu sebeli walaela luli nji kuulwe omunu soyupa etaba eyo, sebeli wamba nji, omwanukana abiwe eilya. ");
INSERT INTO lyn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesu aba na tunda omo mu sibaka, sebeli ota ku mundi waye, mi aiyetwa aye sebeli amwenda mu nyima. ");
INSERT INTO lyn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Cwale elino Pumulo, sebeli otangisa okwiyeta aanu mu ndoo no milapelo no Majuda, mi ano kupula aba ana ku muyupa sebeli akomoka ni kwamba nji, “Kubine ana itundisa eyi wuyu mulume? Kaku shangama oko anabiwi? Kubine ana wana amaata no kutenda etimakazo ni maoko aye? ");
INSERT INTO lyn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kasa yokame osikwaya omwana Maliya, omukulwaa Jakobo, Jose, Juda ni Simoni? Amandaye kasaa, tuli noo? Mi kame ana sitatala mu libaka lyaye. ");
INSERT INTO lyn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Cwale Jesu sebeli wamba kwa onyene nji, “Omunuhi wa Nyambe omu aulwa okukutekiwa mu naha yaye felea, kwasi lusika lwaye na sindoo yaye.” ");
INSERT INTO lyn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Omo kasiku twesa okutendamo omusebezi no koongola, konji okubalisa aanu acana ana kutoma, mukwabeeka amaoko aye beulu ni kwa balisa. ");
INSERT INTO lyn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mi kame anaku komoka okwa pumena koo. Cwale Jesu sebeli ota mu mindi ili beebi yoiyeta aanu. ");
INSERT INTO lyn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Cwale Jesu sebeli oisana ano kukwana likumi na yiili, mi kame ana kwatuma mu wiili, mu wiili. Mi nikwaaba amaata beulu no mebo no kwakena, ");
INSERT INTO lyn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","sebeli walaela nji, “Mulese okushimba esinu sonje, konji omulamu, mulese okushimba esinkwa, omukotana, simba amali mu tipokoto tenu. ");
INSERT INTO lyn_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mukumange einjatangwa yenu, mi mulese okushimba esikumango sinjili no wiili.” ");
INSERT INTO lyn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Cwale kame sebeli waambela nji, “Mu ndoo yonje omo samwingene, mwikalemo okutwala aba sa mukatundemo. ");
INSERT INTO lyn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Cwale omo mu ndoo sakane oku mitambula ni kumiyupa, mutundemo mututule amaluli ku makondo enu, otenda oupaki kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Cwale sebeli ata, mukwiyeta aanu nji abake. ");
INSERT INTO lyn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Cwale sebeli acita amadimona no kupula, mi sebeli awaa amaati kwawo asikutoma no kupula, mane sebeli abala. ");
INSERT INTO lyn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Cwale Ombumu Heloda aba ana kuyupa ya Jesu, kakuli elitina lyaye naliku bubaana mi aanu sebeli aamba nji, “Jowani mukolobezi nainguka kwaafu, elibaka aba atenda etimakazo mwa yonyene.” ");
INSERT INTO lyn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Anjili sebeli amba nji, “Yo kame Eliya,” Mi anjili nji omunuhi wa Nyambe, kanyi omunjili no anuhi a Nyambe na kukale. ");
INSERT INTO lyn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kono Heloda aba ana kuyupa ngeeso, sebeli wamba nji, “Yokame Jowani nina kupatula omutwi, nainguka kwaafu!” ");
INSERT INTO lyn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kakuli Heloda yona kutuma aanu okalema Jowani, ni kumununga okumubeka mu tolongo mulibkalya Helodiyasi omoywaa Filipi minaye, kakuli yonaku mukwata. ");
INSERT INTO lyn_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jowani kame ana kwambela Heloda nji, “Katukelo yowe okukwata omoywaa minowe!” ");
INSERT INTO lyn_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kakuli Helodiyasi kame ana kutimba onene Jowani mi sebeli osinga oku mwibaa, kono kame ana kukwangwa omusa mwiibaele. ");
INSERT INTO lyn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kakuli Heloda kame ana kucilanga Jowani, mukulimuka nji mulume no kuluka, mi ni wakukena. Mi kame na ku musilelezanga. Aba ana kuyupanga yo amba, kasi kuwabelelwanga mu mucima simba nji kame ana kumu teetetanga. ");
INSERT INTO lyn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ku mamaneneno Helodiyasi sebeli otandala okuwana esibaka, Heloda abana kutenda omukiti no kuleiwa kwaye, mi sesbeli oisanenako amanduna no kuta yaye na kulu no masole na kulu namu Galileya. ");
INSERT INTO lyn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Cwale omwana Helodiyasi no mukatana abana kukeela sebeli onenga onene niku wabelisa Heloda naa ana kwikala naye ba tafule. Cwale Ombumu sebeli wambela omukatana munyonyo nji, “Okumbele esi sosinge kwa mene sonje, mi mbani kubi so.” ");
INSERT INTO lyn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mane sebeli okununga oluci nji, “Esi so kumbele sonje, simba eseemba no mubuso wange mbani kubi. ");
INSERT INTO lyn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Cwale omukatana sebeli ota okaibanguta inawawe nji, “Ni kumbele eikene?” Inawawe sebeli omutambula nji, “Okumbele omutwi wa Jowani omukolobezi.” ");
INSERT INTO lyn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Cwale ababo omukatana sebeli oukela kwa Mbumu muwanguwangu ni kukumbela nji, “Kame nisinga nji abano, onibe omutwi wa Jowani omukolobezi mu siwana.” ");
INSERT INTO lyn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Cwale ombumu sebeli weena onene, kono mulibaka no kweeta oluci kwaye na ngenda awo ana kwikala naye, sebeli okwangwa okumatuka amaywi aye. ");
INSERT INTO lyn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ababo Ombumu sebeli otuma omunjili no masole no atateleli, niku laela nji akalite omutwi wa Jowani mukolobezi. Woyo sebeli ota nukapatula omutwi wa Jowani mukolobezi mu tolongo, ");
INSERT INTO lyn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ni kulita omutwi mu siwana, ni kuuba omukatana, mi omukatana yonyene sebeli ouba inawaye. ");
INSERT INTO lyn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cwale aiyetwa a Jowani aba ana kuyupa etaba eyo, sebeli aiiya muku shimba esitupu saye oka siteula mu libita. ");
INSERT INTO lyn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Atumiwa sebeli auka kwa Jesu, oka mwambela yonje eyo ana kutenda neyi ana kwiyeta aanu. ");
INSERT INTO lyn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Cwale sebeli wamba kwa onyene nji, “Mwiiye, tute ku mukunda muka pumuleko mbicani oku kuulwile aanu. Kakuli kame ku nakwikala aanu no kupula aa na iyanga ni kuuka mane kame ana kukwangwa ni nako no kulya.” ");
INSERT INTO lyn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Cwale sebeli ata mu wato okaikala omboci mu sibaka no kondoka. ");
INSERT INTO lyn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Cwale aanu no kupula sebeli aamona akatile, ni kwalimuka nji anyine, mi sebeli aitukelako ni makondo okutunda mu milenen̄i yonje, mi aanu sebeli aka keelako oweli Jesu na iyetwa aye asili munyima. ");
INSERT INTO lyn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cwale Jesu aba ana kutunda mu wato, sebeli omona aanu no kupula, mi sebeli wayupela amakeke, kakuli kame ana kufeka kanyi omukoko nambulwa mulisana. Mi sebeli otangisa okwaiyeta einu no kupula. ");
INSERT INTO lyn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cwale eliywaa aba lina kwiika, aiyetwa aye sebeli aiya kwa yonyene ni kwamba nji, “Sino ni sibaka no kondoka, mi enako yatakale. ");
INSERT INTO lyn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mwaa use, nji aka ku ulele eino kulya mu matema ni mu mindi ili beebi.” ");
INSERT INTO lyn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesu sebeli waatambula nji, “Mwaabe eino kulya mwenyene, Onyene sebeli amwibanguta nji, “Tukaule einkwa no mali a atenda emianda yiili no muwayawaya nji twaabe alye?” ");
INSERT INTO lyn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Cwale Jesu sebeli wamba kwa onyene nji, “Injinga einkwa mukwite? Mute muka imone. Cwale aba anaku imona, sebeli amba nji, “Kame kuli feela einkwa mutanu ni tindi timbili.” ");
INSERT INTO lyn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Cwale sebeli olaela nji, “Aanu onje aikale mu ikwata, ba moopu no musuhela.” ");
INSERT INTO lyn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Cwale aanu sebeli aikala banji mu ikwata, esinjili esikwata no aanu akwana omwaanda, anjili aanu ana ku kwana makumi mutanu. ");
INSERT INTO lyn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesu sebeli oshimba einkwa mutanu ni tindi timbili, ni kwaliketa kuwilu, mi sebeli okutumela ni kupatola einkwa okuba aiyetwa aye nji atabele aanu, mi kame ni kutabela aanu etindi. ");
INSERT INTO lyn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Cwale onje sebeli alya ni kwikuta. ");
INSERT INTO lyn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Cwale sebeli ashimba amatanda likumi na yiili, ana kwiyala oubulumusi no inkwa, nou no tindi. ");
INSERT INTO lyn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mi awo ana kulya neli alume ana kukwana eikiti Mutanu (5,000). ");
INSERT INTO lyn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ababo Jesu sebeli wambela aiyetwa aye nji aingene mu wato nji akutangete okuta mu linjaliya no lisa, ku Betisaida, yonyene yo suusa aanu. ");
INSERT INTO lyn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Osimana felea okuusa aanu sebeli ota ba lilundu oka lapela. ");
INSERT INTO lyn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cwale enako no mangolwaa aba ina kukwana, owato owendela ba kaci no lisa, mi Jesu yoli yomboci ba likamba. ");
INSERT INTO lyn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mi sebeli omona nji kame apuwa me aziyelehile, kakuli emebo kame ina kwalwisa onene. Mi mu nako no malungasiku, Jesu sebeli oiya kwa onyene yo enda ba meyi, mi sebeli osinga okwabitelela. ");
INSERT INTO lyn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kono aba ana ku mumona yo enda ba meyi no lisa, sebeli akuwa onene nji ni silumba. ");
INSERT INTO lyn_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Cwale onje sebeli acila aba ana kumumona. Kono sebeli oleluba okwamba noo nji, “Mu koongote, ya meene, mu lese kucila.” ");
INSERT INTO lyn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Cwale sebeli oku longa mu wato nonyene, mi emebo sebeli yondoka. Cwale aiyetwa aye sebeli akomoka onene. ");
INSERT INTO lyn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kakuli kasi ku yupisisa etaluso no kufepa aanu no kupula bokame abo emicima yoo kame ina koongola. ");
INSERT INTO lyn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Cwale aba ana kumana okuluta elisa ni kuta ba likamba, mi sebeli akeela mu naha iisaniwa Genesaleta mi sebeli afuweka ku likamba. ");
INSERT INTO lyn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mi abana kutunda mu wato, ababo aanu sebeli amu limuka. ");
INSERT INTO lyn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Cwale sebeli aitukela mu naha yonje ni kutangisa okalita asikutoma onje oko ana kuyupa nji Jesu kwaali. ");
INSERT INTO lyn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mi konje Jesu oku ana ku bita, mu mindi icana ni mu mindi inene, simba mwibaka no matema, asi kutoma kame ana kubeekiwa ba tipatelo, mi aanu kame ana kukumbela nji aa pumenene oku lema feela simba ku mungundo no sikumango saye, mi aa amulema onje kame abala. ");
INSERT INTO lyn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Cwale Afalisi na iyeti no mulawo anjili ana kutunda mu Jelusalema, sebeli aiya ni kuungana kwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Sebeli alemuha nji aiyetwa anjili a Jesu kame alya eilya ni maoko no kwakena, okutalusa amaoko nokwa yowisiwa. ");
INSERT INTO lyn_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kakuli Afalisi, ni aanu onje no Majuda kaali, konji akuyowe oweli ku maoko, okumamela esizo no akulu, ");
INSERT INTO lyn_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","mi cwale naba auka okutunda ku musika, kaali konji abasa kuyowe oweli. Kusili eizo injili no kupula eyi imamela, kanyi eno kuyowisa etikomoki ni tucoo, ni injili no oukutusisa. ");
INSERT INTO lyn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Cwale Afalisi na iyeti no mulawo sebeli aibanguta Jesu nji, “Iikene aiyetwa owe aba kayoyo ni sizo no akulu, kame alya ni maoko nokwakena? ");
INSERT INTO lyn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesu sebeli waatambula nji, “Anyi asikukuba, Isaya kame ana kunuha wino eyenu kanyi omo ku n̄olelwe, Aanu aa kame ani kuteka ni tunwa too, kono emicima yoo kame ili okuno kuleba ni mene. ");
INSERT INTO lyn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kame ani kubamena oku nambulwa tuso, okwiyeta koo ni kwa milawo no aanu. kanyi ni milawo yange!’ ");
INSERT INTO lyn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kame munasiyi etaelo ya Nyambe, mi kame mukuteka esizo no aanu.” ");
INSERT INTO lyn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Cwale Jesu sebeli wamba kame kwa onyene nji, “Kame muli ni ndila noku shangama no kukana emilawo ya Nyambe, nji mongote esizo senu. ");
INSERT INTO lyn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kakuli Mushe kame ana kwamba nji, ‘Okuteke sitowe ni inaowe’ kame, ‘Woyo soshwaula sitaye simba inawaye, aibaiwe.’ ");
INSERT INTO lyn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kono kame mwamba nji omunjili aba ambela sitaye simba inawaye nji, “Etuso sa ni mi tuse ni Kolobani”, okutalusa nji esitabelo sina biwi kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Cwale mu lese ku mu pumenena yo tenda esinjili kwa sitaye simba kwa inawaye. ");
INSERT INTO lyn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mi kame mu mana eliywi lya Nyambe mu sizo senu esi mongotite, mi kame mu tenda einjili no kupula no ngeeso.” ");
INSERT INTO lyn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesu sebeli oisana aanu no kupula kame ni kwaambela nji, “Munitetete anyi moonje, mi muyupisise. ");
INSERT INTO lyn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ku inu ili bandee eyi ingena ku munu, kakwisa esi sitwesa oku musilafaza, kono esi situnda kwa yonyene, sokame esi simu silafaza.”  ");
INSERT INTO lyn_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nji omunu kame ali ni matwi no ku yupisa, ayupe. ");
INSERT INTO lyn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mi cwale aba ana kusiya aanu okwingena mu ndoo, aiyetwa aye sebeli amwibanguta etaluso no nguli eyo. ");
INSERT INTO lyn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Cwale Jesu sebeli wamba kwa onyene nji, “Ninji naanyi kamu yupisisa? Kamu lemuha nji esinu sili bandee aba siingena ku munu kasimu silafaza? ");
INSERT INTO lyn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kakuli ka siingene mu mucima waye, kono kame siingena mu lipumo, mi kame situndela bandee.” (Bokame abo ana kulaela nji eilya yonje niya kukena.) ");
INSERT INTO lyn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Cwale Jesu sebeli wamba nji, “Esi situnda ku munu, so kame esi sisilafaza omunu. ");
INSERT INTO lyn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kakuli ni mu micima no aanu omo ku tunda emihupulo no kwiiba, outanya, oumbuyi ni kwibaa. ");
INSERT INTO lyn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Okubuka, etitakazo no inu simba amali, olunya, okoonga, okuyoya mu uhule, omuna, okooba oukukumusa ni weelo. ");
INSERT INTO lyn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Einu yonje eyi no kwiiba kame itunda mukaci mi kame isinya omunu.” ");
INSERT INTO lyn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Cwale Jesu sebeli otunda mo nuukutela mu sibaka sili mukaci no mulenen̄i wa Tile ni Sidoni. Sebeli oingena mu ndoo, mi ka sikusinga nji alimukiwe, kono na ku kwangwa oukushweeka. ");
INSERT INTO lyn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kono ababo omukati ona kwikala ni mwanaye no mukatana ona kwingenwa ku mebo no kwakena, abana kuyupa eyi, sebeli wiya mu kukwela ba makondo a Jesu. ");
INSERT INTO lyn_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Omukati neli Mugelike ona ku leyelwa mu Silofenisiya. Sebeli okumbela Jesu nji atundise emebo no madimona kwa mwanaye no mukatana. ");
INSERT INTO lyn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Cwale Jesu sebeli wambela omukati nji, “Olesele oweli anukana alye eyi asinga yonje, kakufanene okushimba esilya no anukana ni kondela otumbwanana.” ");
INSERT INTO lyn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kono omukati sebeli otambula nji, “Ee Mbumu, simba otumbwanana munji no tafule kame tulyanga oubulumusi ou ukwa kwanukana.” ");
INSERT INTO lyn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Cwale Jesu sebeli wambela omukati nji, “Mukutambula kowe ote emebo no madimona naitundu mwa mwanowe.” ");
INSERT INTO lyn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Cwale omukati sebeli ota ku ndoo nukawana mwanaye yo langanine ba mumbeta, mi emebo no madimona naitundu mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Cwale Jesu sebeli otunda ku Tile ni kuta ku Sidoni okushetumuka ku lisa no Galileya ni kubita mu naha no Dakapolisi. ");
INSERT INTO lyn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mi aanu sebeli amulitela omulume no susu ni umumu ni kukumbela Jesu nji abeeke amaoko aye beulu yaye. ");
INSERT INTO lyn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Cwale Jesu sebeli omutwala ku nyonga, kule naanu, Jesu sebeli obeeka eminwe mu matwi no mulume. Cwale sebeli osibula amate ni kulema omulume ba lulimi. ");
INSERT INTO lyn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Cwale Jesu sebeli waliketa ku wilu, ni kutula emebo ni kwamba kwa yonyene nji, “Effata!” Okutalusa nji, “Otikuke!” ");
INSERT INTO lyn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ababo amatwi no mulume sebeli atikuka, olulimi lwaye sebeli lutangisa okwamba wino. ");
INSERT INTO lyn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Cwale Jesu sebeli olaela aanu nji alese okwambela omunu yonje. Kono omo ana kwakaniseta, mwana ku ongoteteta okwamba etaba eyo. ");
INSERT INTO lyn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Aanu kame ana ku wabelelwa ni ku komoka onene. “Kame atenda einu wino sebeli aamba. Mane kame ayupisa aanu no kwayupa, ni kwambisa awo no kwatwesa okwamba.” ");
INSERT INTO lyn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mu maywaa awo kame aanu no kupula sebeli aungana, mi na kuulwa esi no kulya, cwale Jesu sebeli oisana aiyetwa aye ni kwaambela nji, ");
INSERT INTO lyn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kame nifela amakeke aa aanu no kupula, kakuli kame ana ikala ni mene ba maywaa aatu mi kakwite esi no kulya. ");
INSERT INTO lyn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cwale nji nause ayombile ku mindi yoo, kame sa welele ba ndila kakuli anjili kame atunda oku no kuleba.” ");
INSERT INTO lyn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Cwale aiyetwa aye sebeli amwibanguta nji, “Ngasibine omunu omo sa fepele aanu ni sinkwa muno nimu lihalaupa?” ");
INSERT INTO lyn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Cwale Jesu sebeli waibanguta nji, “Kame mukwite einkwa ikwana bukai?” Sebeli atambula nji, “Mutanu ni yiili” (7). ");
INSERT INTO lyn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Cwale Jesu sebeli olaela aanu no kupula nji aikale banji. Cwale sebeli oshimba einkwa mutanu ni yiili (7) nuukutumela ni kwipatola ni kuba aiyetwa aye nji atabele aanu no kupula, mi sebeli atenda ngeeso. ");
INSERT INTO lyn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mi kame ana kwikala ni tusi tunyonyo no kucaniba, cwale sebeli otulapelela ni kulaelela nji ni tonyene otu mwaatabele to. ");
INSERT INTO lyn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Cwale sebeli alya ni kwikuta ni kutola oubulumusi ou ona kusiyalako ni kwiyata amatanda ana kukwana mutanu na yiili (7). ");
INSERT INTO lyn_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mi aanu kame ana kukwana eikiti inee (4,000). ");
INSERT INTO lyn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Cwale Jesu sebeli waambela nji akutele, ababo yonyene sebeli oingena mu wato na iyetwa aye ni kuta mu sikiliti no Dalumanuta. ");
INSERT INTO lyn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Afalisi sebei aiya kwa Jesu niku tangisa okukanana naye, okumukumbela nji amonise esisupo situnda ku wilu, oku mweteka. ");
INSERT INTO lyn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesu sebeli otula emebo onene ni kwamba nji, “Iikene aa aanu aba asaela esisupo? Niti luli kame ni myambela nji, kakwisa esisupo sasi biwe ku lusika olu!” ");
INSERT INTO lyn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mi sebeli waasiya kame, ni kwingena mu wato ni kuta mu linjaliya no lisa. ");
INSERT INTO lyn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Aiyetwa kame ana kupulama okushimba einkwa konji feela simweya ana kwikala naso mu wato. ");
INSERT INTO lyn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesu sebeli waaba emamela nji, “Mutokomele omumena no Afalisi nou wa Heloda.” ");
INSERT INTO lyn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Cwale sebeli akwambota mukaci koo ni kwamba nji, “Kakuli katu kwite einkwa.” ");
INSERT INTO lyn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesu sebeli olemuha eyi anaku kwambota ni kwaambela nji, “Iikene aba mukwambisa eyi no kuulwa esinkwa? Anyi nibano kamu mono ni kuyupa? Emicima yenu iso ngolile? ");
INSERT INTO lyn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kame muli ni miyo kono ka mumono? Kame muli ni matwi kono kamu yupu? Mi ka mupuluka? ");
INSERT INTO lyn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Aba nina kupatola einkwa mutanu baanu ana kukwana eitiki mutanu, amatanda muna kutolabo kame anaku kwana babukai no ubulumusi ona kusiyalako?” Sebeli atambula nji, “likumi na yiili (12).” ");
INSERT INTO lyn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Mi cwale aba nina kupatola einkwa mutanu ni yiili, baanu ana kukwana eikiti inee bukai amatanda mu na kutolabo?” Sebeli atambula nji, “Mutanu na yiili (7).” ");
INSERT INTO lyn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesu sebeli wamba kwa onyene nji, “Nibano kame kamu yupisisa?” ");
INSERT INTO lyn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Cwale sebeli aiya ku Betisaida, mi aanu sebeli alita omulume no kufa amiyo, ni kukumbela Jesu nji amuleme. ");
INSERT INTO lyn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesu sebeli olema omulume no sibofu ni kumutundisa mu mundi. Mi cwale aba na mana okusibwela omulume amate ba miyo ni kubeeka amaoko beulu waye, Jesu sebeli omwibanguta nji, “Kame kuli eso mona?” ");
INSERT INTO lyn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Omulume sebeli waaliketa ni kwamba nji, “Kame ni mona aanu, kono kame amonahala kanyi eitondo eyi yeenda.” ");
INSERT INTO lyn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Cwale kame Jesu sebeli obeeka amaoko aye ba miyo no mulume. Mi omulume sebeli oukela oku mona, mi amiyo aye sebeli atateka okumona ni ku mona einu yonje wino-wino. ");
INSERT INTO lyn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesu sebeli omwambela nji, “Ote ku mundi wowe, olese okuuka ku mundi ou.” ");
INSERT INTO lyn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Cwale Jesu sebeli otunda mo na iyetwa aye, sebeli oingena mu mindi ya Filipi Sesaliya. Mi mu ndila sebeli oibanguta aiyetwa aye nji, “Aanu kame amba nji time anyine?” ");
INSERT INTO lyn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Cwale aiyetwa sebeli atambula nji, “Anjili kame amba nji, tiwe Jowani omukolobezi, anjili nji tiwe Eliya, kono anjili kame aamba nji, kame oli omunjili no anuhi a Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Cwale Jesu sebeli waibanguta nji, “Kono anyi kame mwamba nji time anyine?” Pitolosi sebeli omutambula nji, “Tiwe Kilesite.” ");
INSERT INTO lyn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Cwale Jesu sebeli waakanisa nji alese okwambela omunu eyaye yonje. ");
INSERT INTO lyn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Cwale Jesu sebeli otangisa okwaiyeta nji omwana no munu kame alukela oku yandisiwa onene, akaniwe kwa kulu, akulu no apulisita ni kwa aiyeti no milawo. Mi aibaiwe, mi aingulwe munyima no maywaa aatu. ");
INSERT INTO lyn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Cwale Jesu sebeli waambela etaba eyo patalaza. Cwale Pitolosi sebeli omushimbela ku nyonga ni kumwayuta. ");
INSERT INTO lyn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kono Jesu sebeli okutemuna okwaliketa aiyetwa aye, sebeli wayuta Pitolosi ni kwamba nji, “Otunde kwa mene, wene Osatani,” kakuli emihupulo yowe kasa mihupulo ya Nyambe, kono ni yaanu!” ");
INSERT INTO lyn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cwale Jesu sebeli oisana aanu na iyetwa aye ni kwaambela nji, “Nji omunu yonje kame asinga okunikon̄a akutobohe mi ashimbe esifapano saye anikon̄e munyima. ");
INSERT INTO lyn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kakuli omunu yonje woyo osinga okuyoyisa omooyo waye, kame sausinyehelwe, kono woyo so sinyehelwa omooyo waye mulibaka lyange ni liywi no kuwaba, kame sayoyisiwe. ");
INSERT INTO lyn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Cwale etuso ni ibine, omunu naba sa luwe elitunga lyonje, mi yosinyehelwa omooyo waye? ");
INSERT INTO lyn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Abo siikene satende omunu nji ausetwe omooyo waye? ");
INSERT INTO lyn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kakuli omunu yonje woyo soneenena ni maywi ange, mu lusika olu no abuki na sikutenda eibi, Omwana no Munu ni yonyene kame samwenene aba saiye mu kanya ya Sitange ni mangeloi aye no kukena.” ");
INSERT INTO lyn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Cwale Jesu sebeli wamba kwa onyene nji, “Niti luli kame ni myambela, kwaali anjili aimanine bano awo katamba okufa konji abasa mone omubuso wa Nyambe abasa wiye ni maata wawo.” ");
INSERT INTO lyn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cwale munyima no maywaa mutanu ni limweya Jesu sebeli oshimba Pitolosi, Jakobo ni Jowani ni kwaatwala ba lilundu no kuleba , oko ano kaikala omboci mi abana kwaliketa Jesu, sebeli ofutuka balubala woo, ");
INSERT INTO lyn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","mi eikumango yaye sebeli ifutuka eino likena onene mi kakwisa omunu sotwesa okuyowisa esikumango saye nji sitende elikena ngeeso. ");
INSERT INTO lyn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Cwale sebeli amona Eliya ni Moshe aamba ni Jesu. ");
INSERT INTO lyn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Cwale Pitolosi sebeli wamba kwa Jesu nji, “Labbi, esi no kuwaba kwaaci ninji tuikalelele okuno, tuyake eitebule yaatu, esinjili sitende sowe, esinjili sa Mushe, esinjili sa Eliya.” ");
INSERT INTO lyn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Abo kasi kulimuka esi no kwamba kakuli kame ana kucila onene. ");
INSERT INTO lyn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Cwale elikumbi sebeli liiya ni kwafuka, cwale eliywi sebeli liyupahala mu likumbi elyamba nji, “Woyo ya mwanange ni singa mumuyupe!” ");
INSERT INTO lyn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ababo abana kwaliketa kasi kumona aanu ana kwimana noo konji Jesu yomboci. ");
INSERT INTO lyn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kono abana shetumukanga okutunda ba lilundu, Jesu sebeli walaela nji alese okwambela omunu eyi ana mono, konji enako sainguke Omwana no munu kwaafu.” ");
INSERT INTO lyn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Cwale sebeli ateula etaba eyo mu micima yoo, nu kwaambota nji okwinguka kwaafu iikene eyi italusa?” ");
INSERT INTO lyn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mi sebeli amwibanguta nji, “Iikene aiyeti no mulawo aba amba nji Eliya yoso ku tangeta okwiiya?” ");
INSERT INTO lyn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesu sebeli waatambula nji, “Eliya kame afanene okwiiya oweli nji alukise einu yonje. Cwale iikene aba ku n̄olilwe nji Omwana no Munu kame fanene okuyandisiwa onene ni kukaniwa? ");
INSERT INTO lyn_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kono kame ni myambela nji, “Eliya nakwiiya mi nakutenda einu yonje kwa yonyene omo ana kusingela okwiyateteta omo in̄olelwe eyaye mu man̄olo.” ");
INSERT INTO lyn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mi cwale abana kukeela kwa iyetwa aye sebeli amona aanu no kupula na iyeti no mulawo akanana noo. ");
INSERT INTO lyn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Cwale ababo aanu no kupula abana kumona Jesu, sebeli akomoka onene ni kumwitukela okamukeeta. ");
INSERT INTO lyn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Cwale Jesu sebeli wibanguta aiyetwa aye nji, “Iikene eyi muna kanananga noo?” ");
INSERT INTO lyn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mi omunjili mukaci no aanu no kupula sebeli otambula nji, “Mwiyeti, kame nina liti mwanange kwa wene, kakuli kame akwite emebo no kwiiba katwese okwamba. ");
INSERT INTO lyn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aba imulemena booshe kame imukwiseta banji ni kulita olufulo ku kanwa ni kukweca amaeo ni ku kukutela. Kame ninambele aiyetwa owe nji aitundise kono na kwangwa okwitundisa.” ");
INSERT INTO lyn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Cwale Jesu sebeli wamba kwa onyene nji, “Anyi olusika no kwapumena, kame sani ikale nanyi enako ikuma babine? Kanako ikuma babine eyi samuni yupisise? Komulite ondumbana kwa mene.” ");
INSERT INTO lyn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mi sebeli alita ondumbana kwa Jesi. Cwale emebo aba ina ku mona Jesu, ababo sebeli imukwiseta banji ni ku tundu olufulo ku kanwa. ");
INSERT INTO lyn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesu sebeli wibamguta sitaye ndumbana nji, “Ba nako no kukuma babine yotoma eyi mebo no kwiiba?” Mi sebeli otambula nji, “Okutundelela kuwa nukana waye. ");
INSERT INTO lyn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Etinako no kupula emebo kame imukwesetenga mu meyi ni mulilo nji imwibae. Kono nji kame utwesa okutenda esinjili otuyupele amakeke mi otutuse.” ");
INSERT INTO lyn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Cwale Jesu sebeli otambula nji, “Nji kame utwesa! Einu yonje kame itwisahala ku munu woyo oli ni tumelo.” ");
INSERT INTO lyn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ababo sitaye omwanuke sebeli okuwa ni kwamba nji, “Kame nili ni tumelo kono icana, onituse nji niikale neyi no kupula” ");
INSERT INTO lyn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Cwale Jesu abana mona nji aanu no kupula akeile kwa yonyene, sebeli okalimela emebo no kwakena, ni kwamba nji, “Wene emebo no umumu ni ususu, kame ni kulaela nji, otunde mwa yonyene mi olese okuukela mo kame.” ");
INSERT INTO lyn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Cwale emebo no kwiiba sebeli ikuwa ni kumukwiseta ku makondo, emebo no kwiiba sebeli itunda. Cwale ondumbana sebeli osiyala kanyi omunu no kufa, cwale anu onje sebeli aamba nji, “Wafakale.” ");
INSERT INTO lyn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Cwale Jesu sebeli omulema ku lyooko ni kumutusa okwimana, mi sebeli oimana. ");
INSERT INTO lyn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Cwale Jesu abana kwingena mu ndoo, aiyetwa aye sebeli amwibanguta ku nyonga nji, “Cwale iikene aci aba tuna kwangwa okutundisa emebo eyi no kwiiba?” ");
INSERT INTO lyn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Cwale Jesu sebeli waambela nji, “Eyi mebo no mushobo ou kaitwesiwa okutundisiwa feela konji okulapela.” ");
INSERT INTO lyn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Cwale Jesu na iyetwa aye sebeli asiya eso sibaka nikubita endila no Galileya. Mi Jesu kasi kusinga nji aanu alimuke, ");
INSERT INTO lyn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kakuli kame ana kwiyetanga aiyetwa aye ni kwambela nji, “Omwana no munu mbabekiwa mu maoko no alume amwibae, mi abasa mane okwibaiwa, munyima no maywa aatu mbainguka kwaafu.” ");
INSERT INTO lyn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kono kasi yupisisa eyi ana kutalusanga, mi sebeli acila oku mwibanguta. ");
INSERT INTO lyn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Cwale Jesu na iyetwa aye sebeli aiya mu Kapenamu, cwale yo ikalile mu ndoo, Jesu sebeli waibanguta nji, “Iikene muna kanananga mu ndila?” ");
INSERT INTO lyn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kono aiyetwa aye sebeli aondoka, kakuli kame anoku kananisanga nji cwale munene ni anyine bano. ");
INSERT INTO lyn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Cwale Jesu sebeli oikala banji ni kwisana ano kukwana likumi na yiili ni kwamba kwa onyene nji, “Nji omunjili kame asaela okutenda uyu no weli, kame afanena okutenda ono mamaneneno ni kutenda omubika kwawo onje.” ");
INSERT INTO lyn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Cwale Jesu sebeli oshimba omwanuke ni kumulita mukaci koo mane ni kumwambeka ba maoko aye ni kwamba nji, ");
INSERT INTO lyn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Woyo yonje sotambula omwanukana mumweya kwaa anukana mu litina lyange na tambula mene, mi yonje sonitambula, kasi tambula mene, kono kame ana tambula woyo onani tumu.” ");
INSERT INTO lyn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Cwale Jowani sebeli wamba kwa Jesu nji, “Mwiyeti, natu mono omunu ona tundisa amadimona mu litina lyowe, mi natu mukanisa kakuli kasa wetu.” ");
INSERT INTO lyn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kono Jesu sebeli wamba nji, “Kamufanene okumu kanisa, kakwisa omunu otwesa okutenda etimakazo mu litina lyange kame nji munyima aambe amaywi no kwiiba kwa mene. ");
INSERT INTO lyn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kakuli omunu yonje woyo uulwa okutulwisa ni wetu. ");
INSERT INTO lyn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Niti luli kame ni myambela nji omunu yonje somiba ekomoki no meyi nji munwe kakuli kame mupumena mwa Kilesite mbatambula omupuzo waye. ");
INSERT INTO lyn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Cwale mumweya nji kame atenda esino kwiiba kwawo apumena kwa mene, nji atende esibi, mba kwikala wino nji omunu woyo amunungelele eliwee linene luli mu ndingo ni kumuyumbela mu liwate. ");
INSERT INTO lyn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nji elyoko lyowe kame liku tendisa eino kwiiba, olipatule kakuli esiwa kwa wene nukaingena mu mooyo ni lyooko limweya, kasanji okaingene ni maoko ayilii nu ukayumbelwa mu liangalilo, omulilo no kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Omo kaifi emibila yoo, nomo no kwatima omulilo. ");
INSERT INTO lyn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mi simba nji elikondo lyowe kame likutwala mukutenda ouyi, olipatuleko, ouwa nu okaingena mu mooyo woli ni likondo limweya, kasa nji oikale ni makondo ayiili nji oka yumbelwe mu liangalilo. ");
INSERT INTO lyn_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Omo kaifi emibila yoo, ni mulilo no kwatima. ");
INSERT INTO lyn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mi nji elitiyo lyowe kame likusaeseta nji otende eino kwiiba, olitundisemo, ouwa nuukaingena mu mubuso wa Nyambe ni litiyo limweya, kasa nji ni miyo ayiili nuka yumbelwa mu lyangalilo. ");
INSERT INTO lyn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Omo emibila yoo kaifu, nomo no kwaabwa omulilo. ");
INSERT INTO lyn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Omunu yonje mbaka lungiwa ni mulilo (kanyi esitabelo aba sina lungiwa omungwa.) ");
INSERT INTO lyn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Omungwa ni wakuwaba kono nji waamuba kale okuwaba ngasibine sausetwe okumamata kwawo kame? “Mwikale kanyi omungwa muno mwanyi mi mwikale ni kozo kwaa kwenu.” ");
INSERT INTO lyn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Cwale Jesu sebeli osiya esibaka eso ni kuta mu naha no Judeya ni kuta mu linjaliya ya Jodan. mi aanu no kupula sebeli aiya okuungana kwa yonyene kame, mi sebeli otangisa okwaiyeta, kakuli neli omukwa waye. ");
INSERT INTO lyn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Cwwale Afalisi anjili sebeli aiya kwa yonyene okumweteka oku mwibanguta nji, “Kana kame kufanena nji omulume alukulule omukataye?” ");
INSERT INTO lyn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Cwale Jesu sebeli waatambula nji, “Ngasibine omo ana ku milaelela Mushe?” ");
INSERT INTO lyn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Cwale sebeli atambula nji, “Mushe kame anaku pumenena omulume nji on̄olele mukataye elin̄olo no tukuluho ni kumulukulula nji akutele.” ");
INSERT INTO lyn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kono Jesu sebeli waambela nji, “Mushe naku min̄olela omulawo owo kakuli emicima yenu niyaku bambaba oyi. ");
INSERT INTO lyn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kono ku matatekelo no kumbiwa elitunga, “Nyambe sebeli oumba omulume ni mukati.’ ");
INSERT INTO lyn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Mu libakaelyo mulume kame sasiye inawaye ni sitaye ni kwikala ni mukataye, ");
INSERT INTO lyn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mi aanu awo ayili kame satende olutu lumweya.’ Abo kasa tinyutu timbili kono sebeli lutu lumweya. ");
INSERT INTO lyn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cwale eso ana beeke Nyambe bamweya, mulese oku pumenena omunu okusitaba.” ");
INSERT INTO lyn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cwale Jesu na iyetwa aye ali mu ndoo, sebeli amwibanguta kame etaba eyo. ");
INSERT INTO lyn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mi sebeli waambela nji, “Woyo yonje so lukulula omoyo waye ni kukwata mundina kame alwisa moyo waye mu kubuka. ");
INSERT INTO lyn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Simba nji omukati okukana mbumwaye nji akwaliwe kundina kame abuka.” ");
INSERT INTO lyn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Cwale aanu sebeli alita anukana kwa Jesu nji aafuyaule, kono aiyetwa sebeli aayuta. ");
INSERT INTO lyn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Cwale Jesu abana mona ngeeso, sebeli otina ni kwamba kwa onyene nji, “Komulesele anuke anyonyo aiye kwa mene, kakuli omubuso wa Nyambe niwoo. ");
INSERT INTO lyn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Niti luli kame nimyambela nji, omunu yonje nji katambula omubuso wa Nyambe kanyi mwanuke, katamba okuwingena.” ");
INSERT INTO lyn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mi Jesu sebeli waashimba nikwabeeka ba maoko mane ni kwafuyaula okubeeka amaoko aye beulu yoo. ");
INSERT INTO lyn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cwale Jesu abana tateka okwenda omwendo waye, sebeli kwiiya omulume yoitukela kway onyene ni kukwela ku makondo aye okukubama balubala lwaye ni kumwibanguta nji, “Weene omwiyeti no kuwaba, ngasibine sa nitende nji ni kawane omooyo no kwaabwa?” ");
INSERT INTO lyn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Cwale Jesu sebeli otambula nji, “Iikene oniisanena nji mbili wa kuwaba? Kakwisa uyu no kuwaba konji Nyambe yomboci. ");
INSERT INTO lyn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Olimukile emilawo, olese kwibaa , olese kubuka, olese kwiita, olese okupaka einu no mapwa, olese okoonga omukowe nji omubyangule esinu saye mi cwale okuteke inaowe ni sitowe. ");
INSERT INTO lyn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Omulume woyo sebeli otambula nji, “Mwiyeti, eyi yonje kame nii mamele okutunda ku undumbana wange.” ");
INSERT INTO lyn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu sebeli omwaliketa niku musinga ni ku mwambela nji, “Kosili esinu simweya onasiyi. Cwale ote okaulise oufumu wowe wonje cwale otabele awo ashebile, mbuwana oufumu kuwilu mi cwale wiiye onikon̄e.” ");
INSERT INTO lyn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Omulume abana yupa ngeeso, sebeli okomoka ni kweena onene kakuli kame ana kwikalanga ni ufumu no kupula. ");
INSERT INTO lyn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Cwale Jesu sebeli waliketa oku noku ni kwamba kwa iyetwa aye nji, “Ngasibine kubambabile nji afumi aka ingene mu mubuso wa Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Cwale aiyetwa sebeli akomoka onene amaywi aye. Kono Jesu sebeli wamba kame nji, “Anaange, kame ku bambabile ngaibi nji awo asepile oufumu akaingene mu mubuso na ku wilu! ");
INSERT INTO lyn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kwakotoba ekamele okwingena mu litiyo no Ndonga okubita omunu no kufuma okwingena mu mubuso wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Aiyetwa aye sebeli akomoka onene, nuukwambota nji, “Cwale anyine so kayoisiwa?” ");
INSERT INTO lyn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu sebeli waaliketa ni kwamba nji, “Kwaanu kame ku pala, kono kwa Nyambe kame kutwesahala, einu yonje kame itwesahala kwa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Cwale Pitolosi sebeli wamba kwa Jesu nji, “Omone, na tusiyi einu yetu yonje okukukon̄a.” ");
INSERT INTO lyn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu sebeli wamba nji, “Niti luli kame ni myambela, kakwisa omunu ona siyi endoo, simba amandaye, inawaye, sitaye, anaaye, amatema mulibaka lyange ni liywi no kuwaba, ");
INSERT INTO lyn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","woyo so kwangwa okutambula omwanda muno mu nako ino, etindoo, amandaye, inawaye, aana ni matema, niku yandisiwa mba tambula omooyo no kwabwa mu nako iiya. ");
INSERT INTO lyn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kono aanu no kupula no weli asaikale ku mamaneneno, anaku mamaneneno asa ikale ano weli.” ");
INSERT INTO lyn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cwale Jesu na iyetwa aye sebeli akambamena ku Jelusalema, Jesu yo twaletete aiyetwa aye ku lubala, mi aiyetwa sebeli akomoka okumona aanu awo ana ku mukon̄a acilile. Kame sebeli oshimbela ana kukwana likumi na yiili kunyonga ni kwaambela eyo saikatendahale kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesu sebeli waambela nji, “Muteetete, kame tukambamena ku Jelusalema, Omwana no munu kame akabiwa mu maoko no apulisita akulu na iyeti no mulawo, mba mwatulele elifu ni ku mubeeke mu maata ano macaba, ");
INSERT INTO lyn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","mi awo kame samu shubaule ni ku musibwela amate, okumushapa ni ku mwibaa, mi munyima no maywaa aatu mba inguka kame.” ");
INSERT INTO lyn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Cwale Jakobo ni Jowani aana a Zebedia, sebeli aiya kwa Jesu ni ku mwambela nji, “Mwiyeti, kame tusinga nji otutendele eyo tukukumbela.” ");
INSERT INTO lyn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Cwale Jesu sebeli waibanguta nji, “Iikene musinga nji nimi tendele?” ");
INSERT INTO lyn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sebeli amutambula nji, “Otupumenene nji aba so ikale mu kanya yowe, tukwikale omunjili nwaci ku silyo sowe omunjili ku simoo.” ");
INSERT INTO lyn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kono Jesu sebeli wamba kwa onyene nji, “Kamu limukile esi mu kumbela. Kame samutwese okunwena mu sinweno sani nwene? Simba oku kolobezwa ni kolobezo sani kolobeziwe?” ");
INSERT INTO lyn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Cwale sebeli amutambula nji, “Kame tutwesa.” Mi Jesu sebeli wamba kwa onyene nji, “Kame sa mu nwene mu sinweno sa ni nwene, ni ku kolobeziwa ni kolobezo sa ni kolobeziwe, ");
INSERT INTO lyn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kono okwikala ku lyoko lyange no silyo simba kweli no simoo, kasa mene sa nimiba, kono kame sa ku biwe kwawo ana lukisetwe ngeeso.” ");
INSERT INTO lyn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mi cwale aiyetwa no kukwana likumi aba ana kuyupa okukumbela oko, sebeli atinena Jakobo ni Jowani. ");
INSERT INTO lyn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Cwale Jesu sebeli waaisana ni kwaambela nji, “Kame mulimukile nji aa aliketiwa nji ambumu no sicaba, kame atenda abika oo, mi akulu kame aendisa ni maata oo. ");
INSERT INTO lyn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kono kwaanyi kakutamba kwikala ngeeso, kono woyo yonje osinga okutenda omunene kwaanyi, atende omubika wenu, ");
INSERT INTO lyn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","mi omunu yonje mwaanyi woyo osinga okutenda uyu no weli, atende omubika wenu moonje. ");
INSERT INTO lyn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kakuli Omwana no munu kasiiyela nji abelekelwe, kono ninji abeleke mi abe omooyo waye nji aliulula aanu no kupula.” ");
INSERT INTO lyn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Cwale sebeli aiya mu Jeliko, mi Jesu abana tunda mu Jeliko na iyetwa aye, naanu no kupula, Batimeya omukumbeli no sibofu omwana Timeya, yo ikalile kunyonga no ndila. ");
INSERT INTO lyn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mi cwale abana kuyupa nji Jesu no Nazaleta, sebeli otangisa okukuwa nji, “Jesu, wene omwana Dabida, oni yupele amakeke.” ");
INSERT INTO lyn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mi aanu no kukupula sebeli amwayuta nji aondoke, kono sebeli okuwa onene nji, “Wene omwana Dabida oni yupele amakeke!” ");
INSERT INTO lyn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Cwale Jesu sebeli oimana ni kwamba nji, “Mu mwisane.” Sebeli aisana esibofu nji, “O koongote, oimane, kame akwisana.” ");
INSERT INTO lyn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yonyene sebeli oyumba olwambi aye, ni kwimana ni makondo, mi sebeli oiya kwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Cwale Jesu sebeli omwambela nji, “Siikene osinga nji niku tendele?” Esibofu sebeli sitambula nji, “Molyange, ni biwe okumona.” ");
INSERT INTO lyn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Cwale Jesu sebeli wamba kwa yonyene nji, “Ote, etumelo yowe naiku balisa.” Ababo sebeli obiwa okumona, mi sebeli okon̄a Jesu mu mukwakwa. ");
INSERT INTO lyn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Cwale Jesu na iyetwa aye aba anaku keela ku nyonga no Jelusalema, ku mindi no Betefage ni Beteni, ba Lilundu lya Olibe, Jesu sebeli otuma aiyetwa aye ayiili, ");
INSERT INTO lyn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ni kwaambela nji, “Mute mu mundi oli balubala lwenu, mi ababo musiingena feela mu mundi omo mba muwana akambongolo kanungilwe, aka kakasiikaliwa kale omunu, mukanungutule mu kalite kuno. ");
INSERT INTO lyn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nji omunu kame sa miibangute nji, Iikene aba mutenda ngesi? Mwambe nji, ‘Ombumu kame akasaela mi kame tukausa abano.” ");
INSERT INTO lyn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mi sebeli ata, nuukawana akambongolo akanungilwe ku mwelo mu ndila, mi sebeli akanungutula. ");
INSERT INTO lyn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Cwale awo ana kwimananga oko sebeli amba kwa onyene nji, “Iikene mutenda, aba munungutula akambongolo?” ");
INSERT INTO lyn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mi awo sebeli aambela eyo Jesu ana kwaambela, mi sebeli aapumenena okuta. ");
INSERT INTO lyn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Cwale aiyetwa sebeli alita akambongolo kwa Jesu, ni kubekabo eikumango yoo beulu no kambongolo, mi Jesu sebeli oikalabo. ");
INSERT INTO lyn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mi aanu no kupula sebeli ayala eikumango yoo mu ndila, anjili sebeli ayala amamuna no mitayi no itondo ana kutema mu matema. ");
INSERT INTO lyn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mi awo ana kwendanga ku lubala naawo ana kwendanga munyima kame ana kukuwelezanga nji, “Hosana! Kulumbekwe woyo okeyile mu litina lya Mbumu! ");
INSERT INTO lyn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kulumbekwe omubuso wa Sitetu Dabida owo okeyile! Hossana mu wilu naku wilu!” ");
INSERT INTO lyn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesu abana ingena mu Jelusalema, sebeli ota mu Ndoo ya Nyambe, mi abana kumana okumonamo einu yonje, abana kumona nji kwaika kale, sebeli ota mu Beteniya na iyetwa aye likumi na yiili (12). ");
INSERT INTO lyn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Eliywaa linjili, abo Jesu na iyetwa aye akatundelele ku Beteni, sebeli oyomba. ");
INSERT INTO lyn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jesu yo sili aba no kuleba sebeli omona esitondo no mukuyu, sebeli otako okamona nji nakubekiwa esino kulya, mi kasikuwanako esinjili kono konji amamuna feela aliko, kakuli kayasi kukukwana enako no mukuyu. ");
INSERT INTO lyn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Cwale Jesu sebeli waambela esitondo nji, “Kuulwe omunu solya kame ku mbuya yowe.” Na iyetwa aye ayupetete eyi aamba. ");
INSERT INTO lyn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Cwale aba ana kukeela mu Jelusalema, Jesu sebeli oingena mu Ndoo ya Nyambe ni kutangisa okucita asikuulisa naa asikuula, ni kukwisa etitafule no asikucinca amali ni ipula no asikuulisa otunkwilimba, ");
INSERT INTO lyn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","mi Jesu kasiku pumenena omunu yonje okubita mu Ndoo ya Nyambe yoshimbile esinu. ");
INSERT INTO lyn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Cwale Jesu sebeli waaiyeta ni kwaambela nji, “Kaku sin̄oliwa nji, ‘Endoo yange kame saisaniwe nji ndoo no milapelo no aanu onje? Kono aanyi namwifutula amakundamo no ambuyi.” ");
INSERT INTO lyn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Cwale apulisita akulu na iyeti no mulawo abana kuyupa eyi, sebeli asaela omo sa ibaele Jesu, kono kame anaku mucila kakuli kame kuna kwikala aanu no kupula ana kukomoka etuto yaye. ");
INSERT INTO lyn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cwale aba kuna kwiika, Jesu na iyetwa aye sebeli atunda mu mulenen̄i. ");
INSERT INTO lyn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Eliywaa lina kutatamako amasiku alemine okwenda, sebeli amona esitondo no mukuyu esikukutile sonje kutangisa ku mamuna okutwala niku mibisi yaso. ");
INSERT INTO lyn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Cwale Pitolosi sebeli opuluka eyi ina kutendahala ni kumwambela Jesu nji, “Omone, Mwiyeti, esitondo ona kukuta nasi kukuta.” ");
INSERT INTO lyn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Cwale Jesu sebeli waatambula nji, “Mu pumene kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Niti luli kame ni mwiambela nji, woyo yonje so ambela elindu eli nji, ‘Otunde aba okaku kondele mu liwate,’ mi kame atenda yokashungula mu mucima waye, kono kame apumena nji eyi aamba kame itwesa okutendahala, mba itendahala kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Cwalehe kame ni myambela nji, “Einu yonje sa mukumbele mu tapelo, mupumene nji namwibiwi mi mbaitende yenu.” ");
INSERT INTO lyn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mi aba mwimana okulapela, mu lemene oweli akwenu anami foseze nji kwaali, nji cwale sitenu na kuwilu atwese okumi lenena emibonda yenu naanyi.”  ");
INSERT INTO lyn_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kono cwale aba kamwa lemene, Sitenu na kuwilu katamba okumi lemena emibonda yenu. ");
INSERT INTO lyn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Cwale sebeli aukela kame ku Jelusalema, Jesu yoenda mu Ndoo ya Nyambe, apilisita akulu na iyeti no mulawo na kulu sebeli aiya kwa yonyene, ");
INSERT INTO lyn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","mi sebeli aibanguta Jesu nji, “Otwambele amaata otenda nawo einu eyi? Anyine ona kubi amaata awo nji otende eyo?” ");
INSERT INTO lyn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu sebeli waatambula nji, “Kame sa nimiibanguta epuzo, nji kame sa muni tambule, ni mene mbani mitalusete amaata ni tenda nawo einu. ");
INSERT INTO lyn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ekolobezo ya Jowani kame ina kutunda kwa Nyambe nji ku munu? Muni tambule.” ");
INSERT INTO lyn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sebeli atangisa oukukananisa onyene nji, “Abasa twambe nji kame itunda kwa Nyambe,’ yonyene kame saambe nji, ‘Iikene, cwale, aba ka mwasiku pumena Jowani?’ ");
INSERT INTO lyn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kono aba sa twambe nji, ‘Kame ina kutunda kwaanu,’” abohe kame ana kucila aanu no kupula kakuli aanu kame anaku pumena nji Jowani neli munuhi wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Cwale sebeli atambula Jesu nji, “Katu yii.” Cwale Jesu sebeli waambela nji, “Ni mene kani myambele amaata ni tendisa nawo einu.” ");
INSERT INTO lyn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Cwale Jesu sebeli otateka okwamba kwa onyene mu tinguli nji, “Kame kuna kwikalanga omulume munjili woyo ona kukuna elitema lyaye, mi sebeli obeeka olukwakwa okutingulusa elitema lyonje, ni kutombola owina nji abeeke mo ewaine mane ni kuyakabo etawala mi sebeli olisiyela alimi nji alimangemo ni kuta omwendo waya mu naha indina. ");
INSERT INTO lyn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Cwale enako aba ina kukwana no kukutula, sebeli otumako omubeleki waye kwa limi nji akashimbe ku timbuya na mu litema. ");
INSERT INTO lyn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mi sebeli amu shimba ni kumufula ni kumucita mane ni kumuusa youlwile esi ana kushimba. ");
INSERT INTO lyn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kame sebeli otumako omubeleki mundina mi ni yonyene sebeli aka mulemeka mu mutwi, ni kumwenisa onene. ");
INSERT INTO lyn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Cwsale sebeli otumako omunjiili kame, cwale woyo sebeli akamwibaa. Kame sebeli otumako ano kupula anjili sebeli akafuliwako anjili okwibaiwa. ");
INSERT INTO lyn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ku mamaneneno sebeli omutumako mwanaye ana kusinga onene ni kwamba nji, ‘Uyu mbaka mukuteke kakuli ni mwanange.’ ");
INSERT INTO lyn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kono alimi sebeli akwaambela mukaci koo nji, ‘Uyu yoshwana okeile muya yo mwanaye omunya litema, twendenyi tu mwibae cwale nji oufumu waye utende wetu!’ ");
INSERT INTO lyn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Cwale sebeli amulema ni kumwibaa ni kuyumbela esitupu saye kundee no litema no beine. ");
INSERT INTO lyn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Cwale Jesu sebeli waibanguta nji, “Iikene satende omunya litema? Mba iyi mukwiibaa alimi awo ni kubeeka elitema mu maata no anjili. ");
INSERT INTO lyn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kana kamwa sibala Elin̄olo eli? “Eliwee ana kukana ayaki nali futuka okutenda eli no tuso onene ku mawee onje? ");
INSERT INTO lyn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Uyu neli Mbumu woyo ona kutenda ngeeso, mi kome ikomokisa mu miyo etu!’” ");
INSERT INTO lyn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Cwale sebeli aeteka nji amununge, kono sebeli acila aanu, kakuli nakulimuka nji kame amba eyi nguli okwa lwisa, cwale sebeli amusiya nukutela. ");
INSERT INTO lyn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Cwale sebeli atuma kwa yonyene Afalisi anjili ni kalulo injili no anu a Heloda nji aka muswase mu etipuzo. ");
INSERT INTO lyn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mi sebeli aiya ni kwamba kwa yonyene nji, “Mwiyeti, tulimukile nji kame wambanga eniti, mi kaukwite etaba neyo aamba aanu, mi kukwite taba nomo aikalele omunu, kono kame osimweta etato ya Nyambe kwaanu. Kana naku pumenenwe okuteneka omutelo kwa Sizale nji kakwa sipumenenwa? ");
INSERT INTO lyn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Twaa teneke nji tulese kuteneka?” Kono Jesu mulibaka no kukuba koo, sebeli waatambula nji, “Iikene aba muneteka? Komu nilitele amali no muwayawaya nji nimonebo.” ");
INSERT INTO lyn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Sebeli amulitela imweya, mi sebeli waibanguta nji, “Esifateho ni litina ilibo aba niyaa nyine?” Sebeli amutambula nji, “Ya Sizale.” ");
INSERT INTO lyn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Cwale Jesu sebeli wamba kwa onyene nji, “Mube Sizale ya Sizale, ni kwa Nyambe ya Nyambe” Cwale sebeli akomoka onene okutambula kwaye. ");
INSERT INTO lyn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Cwale Asaduki sebeli aiya kwa yonyene amba nji omunu abaafa kakwisa okwinguka, mi sebeli aiya kwa yonyene ni kumwibanguta nji, ");
INSERT INTO lyn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Omwiyeti, Mushe nakutu n̄olela okwamba nji, Mukulowe abaafa mi kame asiya mukataye yokakwite omwana, minaye simba mukulwaye no mulume akwate woyo mukataye nji aleyeleko mukulwaye simba minaye aana.’ ");
INSERT INTO lyn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nakukwikalanga andumbana no kukwana mutanu na yiili, omweeli sebeli okwata mukataye, mi cwale abana kufa kasikusiya omwana, ");
INSERT INTO lyn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","cwale ondundamweli sebeli okwata woyo mukati mi niyonyene sebeli ofa oku nambulwa omwana, mi sebeli kutendahala ngeeso nikwa woyo no waatu. ");
INSERT INTO lyn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mi onje mutanu na yiili naku mukwata kono sebeli afa oku nambulwa aana, mane kumamaneneno ni mukati sebeli ofa. ");
INSERT INTO lyn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Cwale abo abasa inguke onje, anyine so tenda omunya mukati? Kakuli onje mutanu na yiili naku mukwatanga.” ");
INSERT INTO lyn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu sebeli waibanguta nji, “Kamu limukile nji namufoso? Kakuli kamuyii aman̄olo ni maata a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Abo cwale ano kufa abasa inguke kakutamba kwikala okukwata simba okukwalwa kono mbafeke kanyi amangeloi mu liwilu. ");
INSERT INTO lyn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Cwale kweyi no kwingulwa kwafu, kamwa sibala mu buka ya Mushe, mu mubamba ou wamba eyino siputa, omo ana kwambelela Nyambe kwa yonyene nji, “Time Nyambe wa Abulahama Nyambe wa Isaka mane ni Nyambe wa Jakobo.’ ");
INSERT INTO lyn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kasa Nyambe wawo no kufa kono Nyambe wawo asikuyoya. Na mufoso!” ");
INSERT INTO lyn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Cwale omunjili no aiyeti no mulawo na kwikalako abaana kukananisanga. Mi nakumona nji Jesu naatambula wino, ababo sebeli oiya kwa yonyene ni kumwibanguta nji, “Ibine etaelo inene ku titaelo tonje?” ");
INSERT INTO lyn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu sebeli otambula nji, Etaelo inene ino, “Oyupe, weene Isilaele! Ombumu Nyambe wetu ni mumweya. ");
INSERT INTO lyn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Osinge Ombumu Nyambe ni mucima wowe wonje, ni mooyo wowe wonje, ni tingana towe mane ni maata owe onje.’ ");
INSERT INTO lyn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Eyi no wiili ino, ‘Osingi woyo oyakile naye kanyi omo okusingela weenyene.’ Kakwisa etaelo inene okubita eti.” ");
INSERT INTO lyn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Cwale omwiyeti no mulawo sebeli wambela Jesu nji, “Kame wamba eniti, Mwiyeti! nwamba eniti aba wamba nji ni mumweya mi niyonyene feela kakwisa mundina. ");
INSERT INTO lyn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mi muku musinga onene ni mucima wowe wonje, mane muku yupisisa kowe konje ni maata onje, ni kusinga omukowe kanyi omo okusingela weenyene, ni yautokwa onene okubita etinubu no kucin̄a ni itabelo.” ");
INSERT INTO lyn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Cwale Jesu abaana mona nji natambula mukushanganma, sebeli wamba kwa yonyene nji, “Kauli oku no kuleba ni mubuso wa Nyambe.” Mi munyima no eyo, kakwisa woyo no kuba okumwibanguta epuzo yonje. ");
INSERT INTO lyn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Cwale abo Jesu abana iyetanga mu Ndoo ya Nyambe, sebeli wibanguta nji, “Cwale ngasibine aiyeti no mulawo aba amba nji Kilesite ni mwanaa Dabida? ");
INSERT INTO lyn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dabida yonyene yokame ona kwamba ni Mebo No Kukena nji, ‘Ombumu naamba kwa mbumu wange nji, Oikale ku lyoko lyange no silyo, konji aba sani beeke esiila senu ku nji no makondo enu.’ ");
INSERT INTO lyn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dabida yonyene luli kame amwisananga nji Mbumu, cwale Kilesite ngasibine satende mwanaye Dabida?” Mi aanu no kupula kame ana kumuyupa wino. ");
INSERT INTO lyn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Cwale mukusimweta kwaye sebeli wamba nji, “Mumamele eyi no aiyeti no mulawo, ao asinga okuta mu tindila ni tinyambi no kuleba, mane ni kubiwa elikute mu ibaka no misika, ");
INSERT INTO lyn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ni kwikala ba ipula no kuwaba mu tindoo no milapelo mane ni ibaka no kuwaba ba nako no mikiti, ");
INSERT INTO lyn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","aa kame alyela etimbakati einu yoo mulibaka no kwatendela etitapelo no kuleba. Mba tambula ekoto yoo inene. ");
INSERT INTO lyn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Cwale sebeli okaikalela abeebi ni sibaka no tinubu okumona omo ana kubeekelanga amali aanu mu siwana no tinubu. Afumi no kupula alemine okuyumbelanga amali no kupula mu iwana. ");
INSERT INTO lyn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mi cwale ombakati no kusheba ni yonyene sebeli oiya, ni kuyumbela mo otupene twiili no muwayawaya. ");
INSERT INTO lyn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Cwale Jesu sebeli oisana aiyetwa aye ni kwamba kwa onyene nji, “Niti luli kame nimyambela nji, uyu mbakati no kusheba na beeke okubita onje alemine okubeeka amali mu siwana no tinubu. ");
INSERT INTO lyn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kakuli anjili kame atundisa abo bali esinjili, kono woyo yonyene kame ana tundisa abo kuulwile, kame nabi abo ayoyela omooyo waye wonje.” ");
INSERT INTO lyn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cwale Jesu abana kutunda mu Ndoo ya Nyambe, omunjili no aiyetwa aye sebeli wamba nji, “Mwiyeti! Komone, ouwa no mawee ni miyako eyi!” ");
INSERT INTO lyn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mi Jesu sebeli omutambula nji, “Wimwine emiyako inene? Kwa onyene kakwisa eliwee lyulwile okulema ba liwee elinjili, elisa lisiiwe okutwisetwa banji.” ");
INSERT INTO lyn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Cwale Jesu yoikalile ba lilundu no itondo no olibe, amabapa ni ndoo ya Nyambe, Pitolosi, Jacobo, Jowani ni Adiliyasi sebeli aiya kwa yonyene ku mukunda ni kumwibanguta nji, ");
INSERT INTO lyn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Otwambele, kamwaka saika monahalele eyo,” mi kame otwambele eisupo saitendahale okutumonisa nji enako yakeela kale nji okutwa iiye einu yonje?” ");
INSERT INTO lyn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Cwale Jesu sebeli otangisa okwaambela nji, “Mutokomele nji omunu alese okumyoonga. ");
INSERT INTO lyn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aanu no kupula kame saiye mu litina lyange, aambe nji, Time Kilesite! mi kame saonge aanu no kupula. ");
INSERT INTO lyn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mi cwale aba samuyupe emilumo no tindwaa abeebi, ni lin̄usa no tindwaa kule, mule kucila, kame ifanena yonje okumonahala, kono kakutalusa nji amamaneno aawo. ");
INSERT INTO lyn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kakuli esicaba sinjili mbasi lwisi esinjili, mi omubuso munjili olwise omunjili, ezikinyeho mba imoniwa mu litunga, mu mabaka no kupula, ni lukupwe ngeeso, eyo kame saitende feela kanyi amatatekelo no mayando. ");
INSERT INTO lyn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kono anyi mutone. Kakuli kame samunungiwe ni kutwaliwa ku tikuta, niku mifula mu ndoo no milapelo, kame samutwaliwe balubala no abusisi na Mbumu mulibaka lyange mukatende etipaki tange kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kono eliywi no kuwaba kame lifanena okukutaziwa kwaanu onje. ");
INSERT INTO lyn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mi cwale aba samileme ni kumitwala ku kuta mulese kubilaela neyo samwambe, kono mwaambe eyi samubiwe okwamba mu nako eyo. Kakuli kasa anyi asambe, kono ni Mebo No Kukena. ");
INSERT INTO lyn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mandaye munu kame sabeteke mandaye nji aibaiwe. Sitaye munu atende ngeeso kwa mwanaye. Aana kame safutukele asitoo ni kwaaibaa. ");
INSERT INTO lyn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Omunu yonje kame samitimbe mulibaka no litina lyange. Kono woyo sotundamena okutwala ku mamaneneno mba yoyisiwa. ");
INSERT INTO lyn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kono cwale abasa mumone ouyi ou usilafaza nji kame oli aba no kwafanena, (omubali ayupisise) abohe aali mu Jundeya, aitukele ku malundu. ");
INSERT INTO lyn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Woyo oli ba situwa no ndoo yaye alese okutundabo nji aingene mu ndoo ashimbemo simba sinu simweya. ");
INSERT INTO lyn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mi kame woyo oli mu litema alese okuuka ku mundi nji akashimbe omukanjo waye. ");
INSERT INTO lyn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kono oumayi kame sawikale kwakati awo sawaniketwe akushimbile ni kuyamwisa otumbututu. ");
INSERT INTO lyn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mulapele kwa Nyambe nji einu eyi ilese okutendahala omubebo. ");
INSERT INTO lyn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kakuli omo mu maywa awo en̄alelwa kame sainenebe. Okutunda ku matatekelo elitunga abana kulyuumba Nyambe, okulita bano, kakusi moniwa en̄alelwa inene ngeeso, mane ni ku lubala kaitamba kumonwa. ");
INSERT INTO lyn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mi kwaulu Ombumu apatule kumaywaa awo kambe kakwisa omunu yonje soka yoyisiwa, kono mulibaka no aketwa, awo ana kuketa, napatula ku maywaa. ");
INSERT INTO lyn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nji cwale omunu kame amyambela nji, Komumone, Kilesite uno yokame kuno simba nji komumone uya yokame mulese okupumena.” ");
INSERT INTO lyn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Asi Kilesite no mapwa na nuhi no mapwa mbaku monahaza, ni kutenda etiponiso ni timakazo nji kame kutwesahala naawo ana isaniwa. ");
INSERT INTO lyn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kono mutokomele, kame nina kumilemusa eyambo eyo yonge ba weli. ");
INSERT INTO lyn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kono mu maywaa awo , en̄alelwa aba saibwe, eliywaa kame sa liilole, okweti kame sakwangwe okulita eliseli. ");
INSERT INTO lyn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Etitungweti mbatikwi kuwilu, mi amaata naku wilu mba nyanganya. ");
INSERT INTO lyn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mi cwale kame samumone Omwana no munu yo keile mu makumbi ni maata no kuneneba ni kanya inene. ");
INSERT INTO lyn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Cwale kame satume amangeloi aye, mu maneku anee no litunga okuunganya aanu anakete, okutangisa kumatatekelo no litunga okuta ku mamaneneno no liwilu. ");
INSERT INTO lyn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mukwiyete mu nguli no sitondo no mukuyu. Emitai yaso aba itangisa okotoba ni kushoshela amamuna mulimuke nji esilimwe kame sili beebi. ");
INSERT INTO lyn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Cwale naanyi ngeeso aba samumone eyambo eyo, sebeli itendahala mulimuke nji Omwana no munu sebeli oli beebi ni kwiiya. ");
INSERT INTO lyn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Niti luli kame ni myambela nji, olusika olu kalutamba kubwa einu eyi ekayasi tandahala kale. ");
INSERT INTO lyn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Elitunga ni liwilu mba ibu kono amaywi ange katamba okubwa. ");
INSERT INTO lyn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kono kakwisa omunu olimukile eliywaa simba enako eyo aba saiye simba Amangeloi naku wilu simba Omwana, konji Sitange yolimukile yomboci. ");
INSERT INTO lyn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mutone, mutatelele mi mulapele, kakuli kamu limukile enako aba saitendahale. ");
INSERT INTO lyn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kame kukufekile kanyi omunu oli mu mwendo okusiya endoo yaye okuta ku ndina ni kusiya abika aye omunjili ni mujili kame abiwa omusebezi waye, mi ni woyo osikutatelela ba mweelo kame alaelelwa nji atatelele. ");
INSERT INTO lyn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Cwale mutatelele, kakuli kamu limukile enako eyo sakauke omunya ndoo, kana ni mangolwaa, simba bakaci no usiku, simba ba mikombwe aba saikuwe, nji enako no masiku. ");
INSERT INTO lyn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Cwale nji kame saiye mu sipundumukela alese kumiwana musi langanine. ");
INSERT INTO lyn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mi esi ni myambela, kame ni sambela naanu onje mene nji mutatelele!” ");
INSERT INTO lyn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aba kunaku siyala amaywaa ayiili nji aingene mu mukiti no Paseka ni kulya kulin̄ende nambulwa omumena. Apulisita akulu na iyeti no mulawo ku mukunda sebeli saela omukwa no kulema Jesu nji amununge ni ku mwibaa. ");
INSERT INTO lyn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Sebeli amba nji, “Katufanene okumulema bano ba mukiti kakuli aanu mbatende emifili-fili ni kutufutukela.” ");
INSERT INTO lyn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Cwale Jesu yoli ku Beteniya mu ndoo ya Simoni osi mbingwa. Cwale Jesu yoikalile ku tafule, sebeli kwiiya omukati yoshimbile amaati no kunuka wino auliwa ba teko inene aisaniwa nadi. Sebeli ofukula ni kwitela amaati awo ku mutwi wa Jesu. ");
INSERT INTO lyn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kono aanu anjili ana kwikala omo ni Jesu sebeli atina nukwambisa mukati koo nji, “Iikene amaati aa aba asinyiwa ngeesi? ");
INSERT INTO lyn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kakuli kambe amaati aa naulisiwa amali no kubitelela emyanda yaatu ni kwaaba kwaanu no kusheba.” Mi sebeli atongoka onene kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kono cwale Jesu sebeli waambela nji, “Komumu siye yomboci, iikene mumushupela? Uyu mukati kame ana tende wino kwa mene. ");
INSERT INTO lyn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mba mwikala naanu no kusheba enako yonje, mi abo musingela bonje mba mwatusu. Kono kamutamba okwikalanga ni mene enako yonje. ");
INSERT INTO lyn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Uyu mukati natende eyi ana twese, na niwaa amaati no kunuka wino ba lutu lwange okululukisa mulibaka no kepelo yange. ");
INSERT INTO lyn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mi niti luli kame nimyambela nji, konje oko sakaiyetiwe amaywi no kuwaba mu litunga lyonje, eyi ana tende uyu mukati mba yambiwa mukumu puluka. ");
INSERT INTO lyn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Cwale Judasi Isakalyota omunjili no aiyetwa aye no kukwana elikumi na yiili (12), sebeli ota kwa kulu no apulisita nji abeteke Jesu kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mi cwale abana kuyupa eyo sebeli awabelelwa onene ni kumusepisa okumuba amali. Cwale Judasi sebeli osaela omukwa no kubeteka Jesu. ");
INSERT INTO lyn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Cwale ba liywaa no matatekelo no mukiti no lin̄ende nambulwa omumena, abo abana kwibaa emikoko no kulya ba mukiti no paseka, cwale aiyetwa aye sebeli amwibanguta nji, “Kubine osinga nji tukaku lukisete nji ukalyeleko omulalelo no Paseka?” ");
INSERT INTO lyn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Cwale Jesu sebeli otuma aiyetwa aye ayiili ni kwaambela nji, “Mute mu tolopo, mi mba muwana omulume yo shimbile esindunga no meyi mi mumukon̄e, ");
INSERT INTO lyn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ku ndoo sakaingene, cwale mwambele omunya ndoo nji, “Omwiyeti naamba nji, kubine oli omusiyo wange oko sani lyele epaseka na iyetwa ange?’ ");
INSERT INTO lyn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Cwale mba mimonisa omusiyo naku wilu omunene ona lukisiwa wino, omo mosa mukalukise einu yetu yonje.” ");
INSERT INTO lyn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Cwale aiyetwa sebeli ata mu tolopo, mi sebeli awana einu yonje kanyi omo ana kwaambelela Jesu, mi sebeli alukisa eino kulya ba paseka. ");
INSERT INTO lyn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cwale aba kuna kutenda amangolwaa, Jesu sebeli oiya na iyetwa no kukwana elikumi na yiili (12). ");
INSERT INTO lyn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mi abaana lyaanga ba tafule, Jesu sebeli wamba nji, “Niti luli kame nimyambela nji, mumweya mukaci kenu mbani beteke mi kame nilya naye bamweya.” ");
INSERT INTO lyn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Aiyetwa sebeli aena, ni kutateka oku mwibanguta omunjili ni munjili nji, “Kana meene?” ");
INSERT INTO lyn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesu sebeli waatambula nji, “Mbatende mumweya kwanyi no kukwana likumi na yiili, mi kame lemine okubeeka elin̄ende lyaye mu siwana simweya ni mene. ");
INSERT INTO lyn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Omwana no munu mbafu kanyi omoku n̄olelwe eyaye, kono oumayi ni wa woyo sobeteka Omwana no Munu! Ouwa kambe woyo mulume kasi kuleiwa.” ");
INSERT INTO lyn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Cwale alemine okulya ngeseo, Jesu sebeli oshimba esinkwa ni kulapela etapelo no oukutumela, ni kusipatola ni kuba aiyetwa aye, ni kwaambela nji, “Mushimbe, olu nilutu lwange.” ");
INSERT INTO lyn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kame Jesu sebeli oshimba ekomoki mi cwale abana mana oukutumela ni kwaaba mi sebeli anwa onje. ");
INSERT INTO lyn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Cwale Jesu sebeli waambela nji, “Ou ni unyinga wange no ulikani no ubya, ona itekelwe ano kupula. ");
INSERT INTO lyn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Niti luli kame ni myambela nji, si tamba okunwa kame ku waine konji elyo liywaa aba sani kanwe kame eyi no ubya mu mubuso wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Cwale sebeli aimba olusimo ni kuta ku lilundu no itondo no Olibe. ");
INSERT INTO lyn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Cwale Jesu sebeli wamba kwa onyene nji, “Moonje mba muni shotoka okuta oku no kuleba, kakuli kame kun̄olilwe nji, ‘Kame sani ibae omulisani mi emikoko yaye yonje mba ihasana.’ ");
INSERT INTO lyn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kono cwale munyima no kwinguka kwange, mbanimi ende ku lubala okuta ku Galileya” ");
INSERT INTO lyn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Cwale Pitolosi sebeli wamba nji, “Simba nji onje mbaku siiyi oukutela, mene nyaa sitamba kuku siya.” ");
INSERT INTO lyn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mi Jesu sebeli wambela Pitolosi nji, “Niti luli kame nikwambela, balelo ouno usiku mbuni latula twaatu emikombwe ekayasilila kale twiili.” ");
INSERT INTO lyn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kono Pitolosi sebeli wamba okongota nji, “Simba okufa ni wene, sitamba kuku latula!” Cwale na kwaye aiyetwa onje sebeli aamba yongeso. ");
INSERT INTO lyn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Cwale sebeli ata ku sibaka siisaniwa Gesemani, mi Jesu sebeli wambela aiyetwa aye nji, “Kamwikale bano aba nisilapela.” ");
INSERT INTO lyn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Cwale Jesu sebeli oshimba Pitolosi, Jakobo ni Jowani, sebeli otangisa oukushonda nuukukalelwa, ");
INSERT INTO lyn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","mi sebeli waambela nji, Omooyo yange kame wenine onene, okutwala balufu lwange, mwikale abano mi mutone.” ");
INSERT INTO lyn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mi sebeli waasiya okusheteta oku no kuleba mbicani, ni kukwela banji ni kulapela nji, nji kame kutwesahala eyi nako no mayando kambe ilese okwiiya kwa mene. ");
INSERT INTO lyn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Cwale Jesu sebeli olapela nji, “Abba,” Okutalusa nji, “Sitange! Einu yonje kame itwesahala kwa wene, otundise ekomoki eyi kwa mene, kulese kutendiwa esi singwa kwa mene, kono esi osinga wene.” ");
INSERT INTO lyn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Cwale sebeli ouka kwa iyetwa aye ni kwawana alanganine, sebeli wambela Pitolosi nji, “Simoni, kame mulanganine? Kamutwese okutona simba ba hola imweya? ");
INSERT INTO lyn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Komutone, mi mulapele nji mulese kwingena mu miliko kakuli Emebo kame isinga kono enyama kame ifokola.” ");
INSERT INTO lyn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Cwale kame sebeli ouka oka lapela, okaamba amaywi akufekile. ");
INSERT INTO lyn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Cwale sebeli ouka kame ni kwawana alanganine, kakuli amiyo oo neli ano kulema onene mi kasi kulimuka neyi noku mutambula. ");
INSERT INTO lyn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kame sebeli oiya akano waatu, ni kwaibanguta nji, “Musilanganine nuuku katulusa? Nakubu, enako yakeela kale. Omwana no Munu wabekiwa kale mu maoko no asikutenda ouyi. ");
INSERT INTO lyn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mwinguke, twendenyi, mwalikete, osikunibeteka sebeli oli beebi!” ");
INSERT INTO lyn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Cwale ababo Jesu yosamba, Judasi omunjili kwawo no kukwana elikumi na yiili sebeli okeela. Kame ana kwiya naanu no kupula ashimbile emikwale ni milamu, ana kutumiwa kwa kulu no apulisita, aiyeti no mulawo ni kwa kulu no aanu. ");
INSERT INTO lyn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Cwale omubeteki sebeli oba aanu esisupo, no kwamba nji, “Woyo sani tubete yokame omulume musaela. Mumuleme ni kumushimba wino nji alese kushotoka.” ");
INSERT INTO lyn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mi cwale Judasi abana kukeela, sebeli osheteta kwa Jesu ababo ni kwamba nji, “Mwiyeti!” Niku mutubeta. ");
INSERT INTO lyn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Cwale alume sebeli alema Jesu niku mununga. ");
INSERT INTO lyn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kono omunjili kwawo ana kwimananga ku manyonga sebeli oshomona omukwale waye ni kupatula omunjili omubika no mu Pulisita mukulu elitwi. ");
INSERT INTO lyn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Cwale Jesu sebeli waambela nji, “Kame muneeyi ni mikwale ni milamu muku nilema kanyi mbili mbuyi? ");
INSERT INTO lyn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Etinako tonje nani kwikalanga nanyi okwiyeta mu ndoo ya Nyambe kono kamwa sikuninunga. Kono aman̄olo kame afanene okwiyatetetwa.” ");
INSERT INTO lyn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Cwale aiyetwa aye sebeli ashotoka niku musiya. ");
INSERT INTO lyn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Cwale kame kuna kwikalanga ondumbana onaku kon̄anga Jesu, yoku mangile feela olwambi ba lutu lwaye. Ni yonyene sebeli amushimba, ");
INSERT INTO lyn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kono sebeli oshotoka yoli njeshe ni kusiya olwambi lwaye. ");
INSERT INTO lyn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Cwale Jesu sebeli otwaliwa ku ndoo no pulisita mukulu ni kwa pulisita ni kwakulu mane ni kwa iyeti no mulawo oko ana kuunganena. ");
INSERT INTO lyn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mi Pitolosi sebeli okon̄a Jesu munyima akatile mu lilapa no kuta no mupulisita mukulu, mi sebeli okaikala na tateleli yoyota omulilo. ");
INSERT INTO lyn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Cwale apulisita akulu bamweya ni manduna no kuta no Majuda sebeli aibanguta Jesu nji awane omubonda owo sa twese okumwibaela, kono sebeli akwangwa. ");
INSERT INTO lyn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Cwale aanu no kupula sebeli aamba eyi no mapwa nji amuwanenebo omubonda, kono oupaki woo neli wa mapwa. ");
INSERT INTO lyn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Cwale anjili sebeli aimana niku munungelela oupaki no mapwa nji, ");
INSERT INTO lyn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Natu kumuyupa yo amba nji, ‘Kame nitwesa okushandaula endoo ya Nyambe eyi ina kuyakiwa kwaanu, mi munyima no maywaa aatu mbani twese okuyaka indina eyo kaitamba kuyakiwa kwaanu.’ ” ");
INSERT INTO lyn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kono simba abana kwamba ngeeso, oupaki woo kawasiku lumelelana. ");
INSERT INTO lyn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Cwale omupulisita mukulu sebeli oimana ni kwibanguta Jesu nji, “Kakwisa eso otwesa okutambula eyo aamba aanu kwa wene?” ");
INSERT INTO lyn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kono Jesu sebeli wondoka feela, kasi kutambula esinjili. Mi kame apulisita akulu sebeli amwibanguta nji, “Yawene Kilesite omwana Nyambe ona fuyaulwa?” ");
INSERT INTO lyn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Cwale Jesu sebeli otambula nji, “ Yamene, mi mba mumono Omwana no munu yo ikalile ku lyoko no silyo no maata mi yo keile mu makumbi no liwilu.” ");
INSERT INTO lyn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Cwale omupulisita no mukulu sebeli okaola eikumango yaye ni kwamba nji, “Iikene eyo tusisaelela oupaki kame! ");
INSERT INTO lyn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Namuku yupele enyefulo yaye. Cwale anyi iikene munahana bo?” Mi cwale onje sebeli amwatula nji kame afanena okufa. ");
INSERT INTO lyn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Cwale anjili sebeli atateka okumu sibwela amate, okumununga olwambi ba miyo, kumufula tin̄indi mame ni kumwambela nji onuhe kwaaci Kilesite anyine ona kufulu mane na tateleli nonyene sebeli amubakula etimaka. ");
INSERT INTO lyn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Cwale Pitolosi yoli mu lilapa, omunjili no abika no mukatana no mupulisita mukulu sebeli oiya. ");
INSERT INTO lyn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mi abana kumona Pitolosi yoyota omulilo, sebeli omwaliketa ni kumwambela nji, “Ni wene kame ona kwikalanga ni Jesu no Nazaleta.” ");
INSERT INTO lyn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kono Pitolosi sebeli okana ni kwamba nji, “Silimukile mane ni kuyupisisa eyi wamba,” mi sebeli otunda okaimana ku mwelo ababo omukombwe sebeli olila. ");
INSERT INTO lyn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Cwale omubika sebeli omumona mi sebeli wamba kame kwawo ana kwimananga naye nji, “Ni uyu omulume ni mumweya waawo ana kwikalanga ni Jesu.” ");
INSERT INTO lyn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kono kame Pitolosi sebeli okana, Mi munyima kame kwawo ana kwimananga sebeli aambela Pitolosi nji, “Niti luli ni wene, kame uli mumweya woo kakuli kame oli Omugalileya.” ");
INSERT INTO lyn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kono Pitolosi sebeli otateka okweeta ni kwamba nji, “Uyu mulume mwaamba, mene simuyii.” ");
INSERT INTO lyn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mi ababo omukombwe sebeli olila aka no wiili. Pitolosi sebeli opuluka eyo anaku mwambela Jesu nji, “Omukombwe owakasilila kale twiili mbunikana twaatu.” Mi sebeli waliketa banji ni kulila onene. ");
INSERT INTO lyn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Cwale amasikusiku, akulu no apulisita, na kulu na iyeti no mulawo na sikuta onje sebeli anahana emihupulo, mi sebeli anunga Jesu ni ku mu twala kwa Pilato. ");
INSERT INTO lyn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Cwale Pilato sebeli oibanguta Jesu nji, “Ninji yawene Ombumu no Majuda?” Jesu sebeli omutambula nji, “Kame wamba.” ");
INSERT INTO lyn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Cwale akulu no apulisita kame ana ku mununga einu no kupula. ");
INSERT INTO lyn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mi Pilato sebeli oibanguta Jesu kame nji, “Ku kwite ekalabo no kutambula? Komone, kame akununga eyambo no kupula!” ");
INSERT INTO lyn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kono Jesu kasi ku tambula, cwale Pilato sebeli okomoka. ");
INSERT INTO lyn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cwale ba nako no mukiti Pilato kame anakwa lukulwelanga omupantinti woyo ana kukumbelanga aanu nji alukululwe. ");
INSERT INTO lyn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mi kwawo ana kunungiwa mu tolongo naku kwikala omulume no litina lya Balabasi ona ku lemiwa mu mubonda no kwibaa omunu ba mufilifili no kufutukela omubuso no naha. ");
INSERT INTO lyn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Cwale aanu no kupula sebeli aiya niku tangisa okukumbela Pilato nji atendele kanyi omo ana kwatendelanga mu maywaa onje. ");
INSERT INTO lyn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Cwale Pilato sebeli waaibanguta nji, “Kame mu singa nji ni milukulwele Ombumu no Majuda?” ");
INSERT INTO lyn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato kame ana ku limbulula apulisita no akulu nji aba ana kumu litele Jesu, neli feela omuna. ");
INSERT INTO lyn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kono apulisita akulu sebeli asusuweza aanu nji akumbele Pilato okwa lukulwela Balabasi. ");
INSERT INTO lyn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mi Pilato kame sebeli waibanguta nji, “Cwale ngasibine sani tende, ni woyo mwamba nji ni Mbumu no Majuda?” ");
INSERT INTO lyn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Cwale aanu sebeli akuweleza nji, “Angongotelwe!” ");
INSERT INTO lyn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Cwale Pilato sebeli waaibanguta nji, “Siikene ana foso?” Kono sebeli akuweleza onene nji, “Angongotelwe!” ");
INSERT INTO lyn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Cwale Pilato mu kusinga oku wabelisa aanu no kupula, sebeli waalukulwela Balabasi, Jesu sebeli oshapiwa, ni kumuba kwa onyene nji aka mungongotele. ");
INSERT INTO lyn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Cwale amasole sebeli atwala Jesu mukaci no Kuta no mulenen̄i no mubusisi, mi sebeli oisana esitopa sonje no amasole. ");
INSERT INTO lyn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Cwale Jesu sebeli amufuka omukanjo no mucaa, ni ku mutingela en̄ata no myunguya ni kumufuka ku mutwi. ");
INSERT INTO lyn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mi sebeli atangisa kumukeeta muku musheka aamba nji, “Yoosho Ombumu no Majuda!” ");
INSERT INTO lyn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Cwale Jesu sebeli amufula olutaka ku mutwi ni ku musibwela amate ni kumu kubamena ni ku musheka. ");
INSERT INTO lyn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mi cwale aba ana kumana oku mushubaula ngeeso, sebeli amufukula olwambi no mucaa ni ku mu fuka eikumango yaye, cwale sebeli amutwala oka mu ngongotela. ");
INSERT INTO lyn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cwale sebeli akandimeka omulume omunjili woyo ana kukubitelanga okutunda ku matema mi woyo neli Simoni Omusailini, sitoo Alekizanda ni Lufusi oku shimba esifapano sa Jesu. ");
INSERT INTO lyn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mi sebeli atwala Jesu ku sibaka sina kwisaniwa Gologota, okutalusa nji esibaka no Katendele. ");
INSERT INTO lyn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Cwale Jesu sebeli amu litela ebeine ina kuwanekiwa ni Mila nji anwe, kono kasi kuinwa. ");
INSERT INTO lyn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mi sebeli amu ngongotela, nuuku tabela eikumango yaye muku shebuluka nji alimuke omunu ni munu eso sa shimbe. ");
INSERT INTO lyn_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Cwale neli ku ma 9 okuloko amasiku aba na kumu ngongotela. ");
INSERT INTO lyn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mi omubonda ana kwatulelwa olufu kame una kun̄oliwa ba lin̄olo eli lili beulu lyamba nji, “Ombumu no Majuda.” ");
INSERT INTO lyn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Cwale Jesu sebeli ongongotelwa ni ikebenga yiili, simweya ku silyo esinjli kweli no simoo. ");
INSERT INTO lyn_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nakwiyatetetwe aman̄olo awo aamba nji, “Kame ana baliwa na sikucola omulawo” ");
INSERT INTO lyn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Cwale aanu ana kubitanga mu ndila sebeli akuweleza niku musheka, aanyunga emitwi yoo ni kwamba nji, “Aha! Kayawene otwesa okusinya endoo ya Nyambe ni kwiyaka mu maywaa aatu! ");
INSERT INTO lyn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Okuyoyise mi otuluke ba sifapano! ");
INSERT INTO lyn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Cwale akulu no apulisita sebeli amusheka ngeeso bamweya na iyeti no mulawo, aamba nji, “Kame anaku yoyisanga akwaye, kono yonyene katwese oukuyoyisa! ");
INSERT INTO lyn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mu lesele uyu Kilesite Ombumu no Isilaele, atuluke ba sifapano cwale, nji tumone mi tu pumene mwa yonyene! Naawo ayiili ana ku ngongotelwa naye sebeli amwaangola. ");
INSERT INTO lyn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Cwale omunji eliywaa aba lina kukela bakaci no mutwi kuma 12 okuloko, sebeli kwiiya ouwi ona kufuka enaha yonje oku twala aba lina kusiuluka ba nako no 15 okuluko. ");
INSERT INTO lyn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Cwale ba nako no 15 okuluko Jesu sebeli okuwa ni liywi linene nji, “Eloi, eloi lemasabakatani? Okutalusa nji, “Nyambe wange, Nyambe wange, iikene aba oni leselela?” ");
INSERT INTO lyn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Cwale awo ana kwimananga ba nyonga aba na kuyupa ngeseo sebeli amba nji, “Muyupe kame aisana Eliya!” ");
INSERT INTO lyn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mi omunjili sebeli oituka oka cupwa esiponji mu fenega ni ku litela Jesu nji anwe, ni kwamba nji, “Cwale musiyenyi tumone nji Eliya mba iiyi ku mu tulula ba sifapano!” ");
INSERT INTO lyn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Cwale Jesu sebeli okuwa ni liywi linene, mi sebeli obwelwa Emebo. ");
INSERT INTO lyn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Cwale olwambi na mu Ndoo ya Nyambe sebeli lukauka bakaci oku tangisa ku wilu okutwala kunji. ");
INSERT INTO lyn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mi cwale omutateleli no musole ona kwimana ba nyonga ya Jesu aba na kumona omo ana fele, sebeli wamba nji, “Niti luli omulume uyu neli Mwana Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Akati ana kwimana oku no kuleba okumona, abo omunjili neli Maliya Magadalena, Maliya inawaye Jakobo omwanuke ni Jose okubeeka Salome. ");
INSERT INTO lyn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mu Galileya ana kwikalanga Jesu, akati kame ana kumu kon̄a ni kumu babalela. Nakati anjili ano kupula ana kumukon̄a oku tunda ku Jelusalema nonyene na kwikalako. ");
INSERT INTO lyn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Cwale aba ina kukwana enako no mangolwaa neli eliywaa nou kutukiseta eliywaa no pumulo, ");
INSERT INTO lyn_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josefa no Alimateya omunjili no Kuta no Majuda, woyo neli omunjili wawo ana kutatelelanga okwiiya no mubuso wa Nyambe, mu undume sebeli ota kwa Pilato okamu kumbela olutu lwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato sebeli okomoka abana kuyupa nji Jesu wafa kale. Sebeli oisana omutateleli, ni ku mwibanguta nji Jesu wafa kale? ");
INSERT INTO lyn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Cwale aba na kuyupa kwa mutateleli nji mo kwikalele, sebeli oba olutu ku mukulu no masole. ");
INSERT INTO lyn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Cwale Josefa sebeli oula olwambi, niku pungelamo Jesu niku mubeeka mu libita no liwee no kuchakuliwa. Sebeli opindumunenabo eliwee ba mwelo no libita, ");
INSERT INTO lyn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya Magadalena ni Maliya inawaye Jose kame ana kumona omo ana kumu langeka Jesu. ");
INSERT INTO lyn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mi cwale elino pumulo aba lina kubwa, Maliya Magadalena ni Maliya inawaye Jacobo, ni Salome, sebeli a ula amaati no kunuka wino, nji akawae olutu lwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Cwale amasiku luli ba liywa no weli mu sunda, sebeli ata ku libita abo eliywaa aba linakupa. ");
INSERT INTO lyn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mi sebeli akwambota mukaci koo nji, “Anyine osokatu tundiseta eliwee ba mwelo no libita?” ");
INSERT INTO lyn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kono aba ana kwaliketa, sebeli amona nji eliwee linene nali tundisiwabo ba libita. ");
INSERT INTO lyn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aba ana kwingena mu libita sebeli amona ondumbana yo kumangile olwambi no likena yoikalile ku silyo mi sebeli acila. ");
INSERT INTO lyn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mi sebeli waambela nji, “Mulese kucila, kame musaela Jesu no Nazaleta ona kungongotelwa. Na inguka! Kuno kasako. Mumone mu sibaka omo ana kumulangeka. ");
INSERT INTO lyn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kono mute, mukambele aiyetwa aye ni Pitolosi nji, ‘Kame akatile balubala lwenu okuta ku Galileya. Oko mbamu kamu mono kanyi omo ana ku myambelela.’ ” ");
INSERT INTO lyn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mi sebeli anjanjata ni ku komoko, cwale akati sebeli a tundako mukucila ku libita. Kasi kwamba esinjili kwaanu, kakuli kame ana kucila onene. ");
INSERT INTO lyn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Cwale Jesu aba ana kwinguka amasikusiku ba liywaa elino weli mu sunda, sebeli okumonahaza oweli kwa Maliya Magadalena, woyo ana kucita kwa yonyene Emebo no kwiiba mutanu ni twiili (7). ");
INSERT INTO lyn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sebeli ota nukambela awo ana kwikalanga ni Jesu, kakuli kame ana kwikala mu maswabi ni ku lila. ");
INSERT INTO lyn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kono abana kuyupa nji Jesu nainguka mi naamu mono, kasi kupumena. ");
INSERT INTO lyn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Okutunda abo Jesu sebeli okumonahaza mumu monahalelo mundina kame kwa yiili. Eyi kame ina kutendahala aenda enda mu naha. ");
INSERT INTO lyn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Awo ayiili aba ana kuuka sebeli ambela akoo, kono kaasi kwaa pumena. ");
INSERT INTO lyn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Cwale okutunda abo Jesu sebeli okumonahaza kwa iyetwa likumi ni mumweya (11), aali ba tafule alemine okulya, sebeli waanyaza mu kuulwa okupumena koo, ni ku micima yoo no koongola, kakuli kasi kupumena kwaawo ana kumumona munyima no kwinguka kwaafu. ");
INSERT INTO lyn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Cwale Jesu sebeli wamba kwa onyene nji, “Mute mu litunga lyonje mwiyete eliywi no kuwaba ku munu yonje. ");
INSERT INTO lyn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Omunu yonje woyo so pumena ni ku kolobeziwa mba yoyisiwa, kono omunu yonje woyo sokana okupumena mba biwi omubonda. ");
INSERT INTO lyn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Eyi eyisupo no timakazo eto sate nato awo apumena, kame sa cite amadimona mu litina lyange. Kame saambe mu tipuwo no ubya. ");
INSERT INTO lyn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kame saleme etinyoka ni maoko oo. Mi naba sanwe omulyashinji, kautamba okwalemeka. Kame sabeeke amaoko kwasi kutoma mi aanu awo mbabala. ");
INSERT INTO lyn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cwale Jesu aba na kumana okwamba noo, sebeli oshimbelwa ku wilu, ni ku kekala ku lyooko no silyo lya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Cwale aiyetwa sebeli ata muku kutaza mu litunga lyonje, abo Mbumu yo sebeza noo mukoongoteteta elin̄usa mu libaka no timakazo ana kutendanga.");
INSERT INTO lyn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kanyi aka no kupula, Aanu no kupula naeteke okun̄ola etitaba no inu eyi inaku tendahala mukaci ketu. ");
INSERT INTO lyn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kanyi omo ana kutwambelela awo ana kwikalanga kumatatekelo ana kwimona mi aambi no liywi. ");
INSERT INTO lyn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kame imonahala wino kwa mene muku kon̄a einu wino mu nako ina kubwa, okun̄ola eliywi kwa wene no kutompeha Teufilasi. ");
INSERT INTO lyn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nji cwale olimuke ouniti okukumanena ni inu ona kwambeliwa. ");
INSERT INTO lyn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mu tinako ta Heloda ombumu no Judeya, kame kuna kwikalanga omupulisita no litina lya Zakaliya, woyo noikalanga mu sikwata no mupulisita no Abija. Mukataye neli osilusika lwa Aloni, mi elitina lyaye neli Elizabeta. ");
INSERT INTO lyn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Onje neli ano kuluka balubala lwa Nyambe, okuyoya oku nambulwa okunyazahala okukumanena ku titaelo tonje ni milawo ya Mbumu. ");
INSERT INTO lyn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kono kasi kwikalanga ni mwana kakuli Elizabeta neli muumba, mi onje naku kulubala. ");
INSERT INTO lyn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Cwale yo sebeza kanyi mupulisata balubala lwa Nyambe abo esikwata saye esili ba nako no kusebeza. ");
INSERT INTO lyn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Okukumanena ku sizo no upulisita, kame ana kuketiwa okwingena mu keleke ya Mbumu okacin̄a eisense. ");
INSERT INTO lyn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Cwale aanu no kupula kame ana kulapelelanga bandee ba nako no kucin̄a einsense. ");
INSERT INTO lyn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ababo cwale sebeli kumonahala kwa yonyene elingeloi lya Nyambe, eli imanine ku silyo no aletale no insense. ");
INSERT INTO lyn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Cwale Zakaliya kame ana kuziyeleha aba ana kumona elingeloi, sebeli okucila. ");
INSERT INTO lyn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kono elingeloi sebeli lyamba kwa yonyene nji, “Olese kucila Zakaliya! Kakuli etapelo yowe naiyupiwa, mi mukatowe Elizabeta mbaku leyele omwana no ndumbana mi mbomu tumbu elitina lya Jowani. ");
INSERT INTO lyn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mi mbu wabelelwa nuukutumela mi ano kupula mba wabelelwe ba kuleiwa kwaye! ");
INSERT INTO lyn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kakuli mbatende woyo no kuneneba balubala lwa Mbumu. Mi katamba okunwa ewaine simba amalopu cwale mba iyala ni Mebo No Kukena simba okutunda mu lipumo lya inawaye. ");
INSERT INTO lyn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mi mba usu aanu no kupula no Isilaele kwa Mbumu Nyambe woo, ");
INSERT INTO lyn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","mi mbati balubala lwaye mu mebo ni maata a Eliya okuusa emicima no ashemi kwaana ni awo nambulwa okukon̄a okushangama no kuluka, oku baakanya aanu ana kulukisetwa kwa Mbumu .” ");
INSERT INTO lyn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaliya sebeli wamba ku lingeloi nji, “Ngasibine sani limuke eyi? Kakuli mene nakulubala kale ni mukatange nakulubala ku myaka.” ");
INSERT INTO lyn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Elingeloi sebeli limutambula nji, “Time Gabiliyele woyo oimanine mu sibaka sa Nyambe mi kame nina tumiwa okwamba kwa wene mane nuukulitela amaywi no kuwaba. ");
INSERT INTO lyn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Cwale komone, kame sondoke ni kuulwa okwamba okutwala ba liywaa elyo aba saiyele einu eyi. Kakuli kawasi pumena amaywi ange awo saiyatetetwe mu nako yawo.” ");
INSERT INTO lyn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Cwale aanu sebeli atatelela Zakaliya ni kukomoka okuliyeha kwaye mu keleke. ");
INSERT INTO lyn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cwale aba ana kubanena bandee kasi kutwesa okwamba kwa onyene, mi sebeli anahana nji namono epono mu keleke. Zakaiya sebeli wamba noo mu kuyuleka yooli esimumu. ");
INSERT INTO lyn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Cwale Zakaliya enako yaye no kusebeza aba ina kubwa, sebeli ota ku ndoo yaye. ");
INSERT INTO lyn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Munyima no maywaa awo mukataye Elizabeta sebeli oimana mu mundi (oukushimba) mi sebeli okushweeka mu ndoo ba tikweti no kukwana titanu ni kwamba nji, ");
INSERT INTO lyn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Eyi yokame ana tende Nyambe kwa mene mu maywaa ona likete, okutundisa elikenyi lyange mukaci no aanu!” ");
INSERT INTO lyn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mukweti no utanu ni kamweya elingeloi Gabiliyele sebeli litumiwa okutunda kwa Nyambe okuta ku mulenen̄i wisaniwa nji Nazaleta. ");
INSERT INTO lyn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kwa mukatana no naluleya woyo ona kubeleziwa ku mulume oisaniwa Josefa, no lusika lwa Dabida. Woyo naluleya elitina lyaye neli Maliya. ");
INSERT INTO lyn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mi selbeli oiya kwa yonyene ni kwamba nji, “Olumele, wene no kufuyaulwa! Nyambe kame ali ni wene!” ");
INSERT INTO lyn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kono kame ana komokisiwa ku maywi aye ni kumakala kumukwa no kuketiwa kwaye. ");
INSERT INTO lyn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Cwale Elingeloi sebeli lyamba kwa yonyene nji, “Olese kucila, Maliya, kakuli nuwana omuhau kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cwale komone kame sokushimbe mu lipumo lyowe ni kuleya omwana no ndumbana, mi mbumu tumbu elitina lya Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mba tende wuyu no kuneneba mi mba isaniwa Omwana a Nyambe OMWAMBAKANI onene mane Ombumu Nyambe mba mubi olubona lwa nyakulyaye Dabida, ");
INSERT INTO lyn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","mba busu endoo ya Jakobo okuta oku no kwaabwa mane ni mubuso waye no kwaabwa!” ");
INSERT INTO lyn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliya sebeli oibanguta elingeloi nji, “Ngasibine saitendahale eyi kakuli mene silimukile omulume?” ");
INSERT INTO lyn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Elingeloi sebeli lyamba kwa yonyene nji, “Emebo No Kukena mba iiyi kwa wene, mi amaata a Nyambe OMWAMBAKANI mba kufuku. Cwale abo omwana woyo soleiwa mba isaniwa nji wa kukena Omwana Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Cwale komone, mwabowe Elizabeta mu nako yaye no ku kulubala naku shimbi omwana no ndumbana, mi okweti uno sebeli ou no utanu ni kamweya, woyo ona kutoiwa nji muumba. ");
INSERT INTO lyn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kakuli kwa Nyambe kakwisa esi sikwangwiwa” ");
INSERT INTO lyn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Cwale Maliya sebeli wamba nji, “Komone, mene uno, omubika wa Mbumu, “sitendiwe kwa mene okukumanena ni maywi owe.” Cwale elingeloi sebeli limusiya. ");
INSERT INTO lyn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mu maywaa awo Maliya sebeli okutukiseta okuta mu naha no malundu mu mulenen̄i no Judeya. ");
INSERT INTO lyn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Cwale sebeli okaingena mu ndoo ya Zakaliya niku keeta Elizabeta. ");
INSERT INTO lyn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cwale Elizabeta aba ana kuyupa okukeetiwa kwa Maliya, omwana sebeli weenda mu lipumo. Mi Elizabeta sebeli oiyala Emebo No Kukena ");
INSERT INTO lyn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","mi sebeli okuweleza ni liywi no kuneneba nji, “Nufuyolwa mukaci no akati onje, mi embuyoti nimbuya no lipumo lyowe. ");
INSERT INTO lyn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mi iikene eyi aba ina tendahala kwa mene, nji inawaye Mbumu wange aiye kwa mene? ");
INSERT INTO lyn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kakuli komone, abo eliywi lyowe no kuni keeta aba lina keela mu litwi lyange, ababo omwana oli mu lipumo lyange sebeli weenda mulibaka no kuwabelelwa. ");
INSERT INTO lyn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Cwale embuyoti niya woyo opumena nji mba kwiyatetwe eso sina kwambiwa kwa yonyene okutunda kwa Mbumu.” ");
INSERT INTO lyn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mi Maliya sebeli wamba nji, “Emebo yange kame ilumbeka Ombumu, ");
INSERT INTO lyn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mi emebo yange kame iwabelelwa mwa Nyambe omuyoyisi wange, ");
INSERT INTO lyn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kakuli nalikete oukushuwa no mubika waye! Komumone okutunda bano amasika onje mbani isana nji wuyu no kufuyolwa, ");
INSERT INTO lyn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kakuli wuyu no kuneneba Nyambe nani tendele esinu sinene. Mi okukena lyokame elitina lyaye, ");
INSERT INTO lyn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","cwale amakeke aye kame ali kwaawo amucila okutunda ku lusika okuta ku lusika. ");
INSERT INTO lyn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Namonisa amaata ni lyoko lyaye nahasanya oukuyeema koo mu mihupulo no micima yoo. ");
INSERT INTO lyn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Natulula ano kuneneba ba mabona oo, mi natuleke awo no ukushuwa. ");
INSERT INTO lyn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Naiyata ano kuyomba ni inu no kuwaba, ni kucita asikufuma oku nambulwa simweya. ");
INSERT INTO lyn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Natusu omubika waye Isilaele, mu kupuluka amakeke aye. ");
INSERT INTO lyn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kanyi aba ana kwamba kwa njekulyetu kwa Abulahama ni ku masika aye okuta oku no kwabwa.” ");
INSERT INTO lyn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Cwale Maliya aba ana kusiyalelwa etikweti tin̄atu sebeli ouka ku mundi waye. ");
INSERT INTO lyn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Cwale enako sebeli ikeela eyi no kuleya kwa Elizabeta, mane sebeli oleya omwana no ndumbana. ");
INSERT INTO lyn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Cwale awo ayakile noo ku nyonga nabaaye aba ana kuyupa Ombumu namonisa amakeke no kuneneba kwa yonyene, sebeli awabelelwa naye. ");
INSERT INTO lyn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Cwale ba liywaa no mutanu ni twaatu sebeli atwala olukeke ku mupato, mi kame ana kusinga nji amutumbe Zakaliya elitina lya sitaye. ");
INSERT INTO lyn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kono inawaye sebeli wamba nji, “Kokuulwa! mbaisaniwa nji Jowani.” ");
INSERT INTO lyn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Cwale sebeli aamba kwa yonyene nji, “Kakwisa kwasi mukowa wowe oisaniwa ni litina eli!” ");
INSERT INTO lyn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Cwale sebeli ambela sitaye ni tiponiso, nji aasimwete elitina elyo asinga okubeeka mwanaye. ");
INSERT INTO lyn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaliya sebeli okumbela akabala ni ku n̄olabo nji, “Elitina lyaye ni Jowani.” Mi onje sebeli akomoka! ");
INSERT INTO lyn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Cwale ababo akanwa kaye sebeli kayatuluka ni lulimi lwaye sebeli lunungutuka, ni kwamba, oku lumbeka Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Cwale awo onje ayakile amabapa noo sebeli alemiwa okucila, mi etaba eyo sebeli ihasana mu naha yonje no malundu no Judeya. ");
INSERT INTO lyn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Cwale onje awo ana kwiyupa sebeli aiteula mu micima yoo ni kwamba nji, “Cwale uyu mwanukana kame sa kule oku tenda anyine?” Kakuli elyoko lya Mbumu kame lina kwikala ni yonyene. ");
INSERT INTO lyn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Cwale Zakaliya sitaye sebeli oiyala ni Mebo No Kukena, ni kunuha okwamba nji, ");
INSERT INTO lyn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ku lumbiwe Ombumu Nyambe no Isilaele! Kakuli na poto ni ku liulula aanu aye. ");
INSERT INTO lyn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mi na tulitele omuyoyisi no maata, mu ndoo ya mubika waye Dabida. ");
INSERT INTO lyn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kanyi omo ana kwambela ni tunwa no anuhi aye no kukena oku tunda ku kale ");
INSERT INTO lyn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","nji kame sa tuyoyisiwe ku ila yetu, ni mu maoko no awo atu timbile. ");
INSERT INTO lyn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Oku monisa amakeke ana kusepisiwa kwa anjekulyetu ni ku puluka oulikani waye no kukena ");
INSERT INTO lyn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","oluci ana kweeta kwa sitetu Abulahama ");
INSERT INTO lyn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","na ku tusepisa nji aba tuna mana oku lamulelwa mu maoko no iila yetu, tu mu sebeleze mu kwaacila, ");
INSERT INTO lyn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","me tuli ano kukena ni kuluka balubala lwaye amaywaa onje no mooyo wetu. ");
INSERT INTO lyn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Cale weene, olukeke, kame soisaniwe nji omunuhi wa Nyambe OMWAMBAKANI kakuli kame sote balubala lwa Mbumu okalukisa endila yaye, ");
INSERT INTO lyn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","okuba ezibo no kuyoya kwaanu aye mu ku lemenwa eibi yoo, ");
INSERT INTO lyn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","mulibaka no mukekecima wa Nyambe wetu. abo eliywaa aba saliiye beulu yetu okutunda ku wilu ");
INSERT INTO lyn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","okuba eliseli kwawo ali mu uwi ni mu mwiinda no lifu, oku simweta amakondo etu mu ndila no kozo.” ");
INSERT INTO lyn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Cwale omwana sebeli okula ni koongola mu Mebo, mi kame ana kwikala mu lihalaupa okutwala ba liywaa elyo ana kumonahala mu Isilaele. ");
INSERT INTO lyn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mu tinako tiya sebeli kwiiya etaelo ya Sesale Augasitasi nji elitunga lyonje kutendiwe esipalo. ");
INSERT INTO lyn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Esi neli esipalo no weli, abo Kuiliniyasi yoli omubusisi no Siliya. ");
INSERT INTO lyn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Cwale onje sebeli ata okan̄oliwa, omunu ni munu mu mulenen̄i waye. ");
INSERT INTO lyn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josefa ni yonyene sebeli otunda mu Galileya, omulenen̄i na mu Nazaleta okuta ku Judeya, omulenen̄i wa Dabida ona kwiisanwa nji Betelehema, kakuli neli osindoo ni lusika lwa Dabida. ");
INSERT INTO lyn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Sebeli oka n̄oliwa ni Maliya, woyo ana ku beeleza, woyo ona kwimananga mu mundi ");
INSERT INTO lyn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","mi asili omo, enako yaye no kuleya sebeli ikeela. ");
INSERT INTO lyn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Cwale sebeli oleya mwanaye no mweeli, ni ku mufuka eikumango no ukeke niku mu langeka mu silyelo, kakuli naku kuulwa esibaka soo mu ndoo no angenda. ");
INSERT INTO lyn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Cwale mu sibaka omo kame kuna kwikala alisana mu matema oo, ana ku tonenanga emilaka no mitapi yoo ousiku. ");
INSERT INTO lyn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Cwale elingeloi lya Mbumu sebeli liku monahaza kwa onyene, mi ekanya ya Mbumu sebeli yabeeka mukaci, mane sebeli acila onene, ");
INSERT INTO lyn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","kono elingeloi sebeli lyaamba kwa onyene nji, “Mulese kucila! kakuli komumone, kame nina militele eliywi no kuwaba eyo salilite oku wabelelwa no kuneneba oko sakwiiye kwaanu onje. ");
INSERT INTO lyn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Balelo na mu leyelwe Omuyoyisi mu mulenen̄i wa Dabida, yokame Kilesite Ombumu. ");
INSERT INTO lyn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Cwale eso sasitende esisupo kwaanyi sino, mba mukawana olukeke ona tingiwa etinyambi mi kame alangekilwe mu silyelo.” ");
INSERT INTO lyn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Cwale ababo sebeli kwiiya empi na ku wilu no kupula, sebeli iiya ni lingeloi, ni kulumbeka Nyambe nji, ");
INSERT INTO lyn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ekanya iikale kwa Nyambe mu mawilu na ku wilu, ni banji ni kozo iikale mu litunga mwaanu awo sa shemubiwe!” ");
INSERT INTO lyn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Cwale amangeloi aba ana kwasiya okuukela ku wilu, alisana sebeli akwambisa omujili ku munjili nji, “Twendeni ku Betelehema tu kamone etaba eyo ineeyi, eyo ana tu simwete Ombumu.” ");
INSERT INTO lyn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Cwale sebeli atako mu kuleluba, mi sebeli akawana Maliya ni Josefa, ni lukeke ona langekilwe mu silyelo. ");
INSERT INTO lyn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cwale aba ana kumana okumona, sebeli ata alimukisa okwamba etaba eyo anambelwe no mwana. ");
INSERT INTO lyn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mi onje awo ana kwiyupa, sebeli akomoka etaba eyo ambeliwa kwa alisana. ");
INSERT INTO lyn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kono Maliya sebeli oteula eyo inu yonje, ni kwimamela mu mucima waye. ");
INSERT INTO lyn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Cwale alisana sebeli auka alemine okukanyisa ni kulumbeka Nyambe kweyo ana yupu neyo ana mono, kanyi omo ana yambelelwe. ");
INSERT INTO lyn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cwale ku mamaneneno no maywaa atanu naatu, aba ana kubeekiwa ku mupato, sebeli amubeeka elitina lya Jesu, elyo ana ku biwa ku lingeloi yo kasi kushimba kale. ");
INSERT INTO lyn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mi cwale enako aba ina kukwana no ku kenisiwa okukumanena ku mulawo wa Mushe, sebeli akambamiseta Jesu ku Jelusalema oka mu monahaza kwa Mbumu, ");
INSERT INTO lyn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kanyi omo ku n̄olelwe mu mulawo wa Mbumu nji, “Omwana no mweeli yonje kame saisanwe nji wa kukena kwa Mbumu.” ");
INSERT INTO lyn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Cwale sebeli ata okaba esitabelo okukumanena mu mulawo wa Mbumu amakwici ayiili simba otwana no tunkwilimba twiili. ");
INSERT INTO lyn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Cwale kame kuna kwikalanga omulume mu Jelusalema no litina lya Simoni, mi woyo mulume neli wa kuluka ni kucila Nyambe, yo tatelele omuyoyisi no Isilaele, mi Emebo No Kukena na ikwikala mwa yonyene ");
INSERT INTO lyn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","mi kame ana kusepisiwa ku Mebo No Kukena nji katamba oku mona elifu yo kasi mona kale Kilesite Ombumu. ");
INSERT INTO lyn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Cwale sebeli osusuweziwa ku Mebo okwiiya mu Ndoo ya Nyambe. Mi cwale ashemi aba ana kulita omwana yonyene Jesu, nji ku tendahale kwa yonyene okuta mu sizo no mulawo, ");
INSERT INTO lyn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoni sebeli omubeeka mu maoko aye ni ku lumbeka Nyambe nji, ");
INSERT INTO lyn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mbumu, cwale olukulule omubika wowe afunduke mu kozo, okukumanena ku liywi lyowe, ");
INSERT INTO lyn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kakuli amiyo ange na mono oku yoyisa kowe, ");
INSERT INTO lyn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","oko ona lukisa balubala no aanu onje, ");
INSERT INTO lyn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Eliseli limonisa asimacaba ni ku lita ekanya kwaanu owe no Isilaele.” ");
INSERT INTO lyn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Sitaye ni inawaye sebeli okomokisiwa kweyo ana kwambiwa mulibaka lyaye. ");
INSERT INTO lyn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Cwale Simoni sebeli waafuyola ni kwamba kwa Maliya inawaye nji, “Komone, wuyu mwana na beekelwe okufa ni kuyoya kwano kupula no Isilaele. Aikale kanyi esisupo eso sasi kananiwe ");
INSERT INTO lyn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","mi omukwale mba ukuyaa mu mooyo wowe, nji emihupulo itunda mu micima no kupula imonahale.” ");
INSERT INTO lyn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Cwale kame kuna kwikala omunuhi no mukati no litina lya Anna, omwana Faniwelu no mukatana no lusika lwa Asele. Kame ana ku kulubala onene mi na kuyoya ni mbumwaye emyaka itanu ni yaatu oku tunda ba walanjo waye. ");
INSERT INTO lyn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yoli ombakati konji aba ana ku keela ba myaka makumi atanu ni aatu ni inee (84). Kasi kutunda mu Ndoo ya Nyambe, oku sebeleza Nyambe, ouku yumena eilya ni kulapela ousiku ni munji. ");
INSERT INTO lyn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mi sebeli oiya ba nako eyeyo nuukutumela kwa Nyambe ni kwamba ya Jesu kwaanu onje awo ana ku tatelela oku liululwa no Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cwale aba ana kumanenena einu yonje okukumanena ku mulawo wa Mbumu, sebeli aukela mu Galileya ku Nazaleta omulenen̄i woo luli. ");
INSERT INTO lyn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mi omwana sebeli okula ni koongola, ni kwiiyala okushangama, ni sishemo sa Nyambe kame sina kwikala beulu yaye. ");
INSERT INTO lyn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cwale ashemi aye kame ana ku taanga ku Jelusalema mu mwaka ni mwaka ku mukiti no Paseka. ");
INSERT INTO lyn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Cwale Jesu aba ana ku kwanisa emyaka likumi ni yiili (12) sebeli akambamenako okukumanena ku sizo. ");
INSERT INTO lyn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cwale omukiti aba ona kubwa sebeli aukela kwaawo, ondumbana Jesu sebeli osiyalela mu Jelusalema. Ashemi aye kasi kulimuka eyo, ");
INSERT INTO lyn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","kono mu kupuluka nji ni yonyene na kwikala mu sikwata, sebeli aenda eliywaa lyonje mi sebeli amu saela kwaboo ni kwawo aku limuka noo. ");
INSERT INTO lyn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mi cwale aba ana kuulwa oku mu wana, sebeli aukela ku Jelusalema oka mu saela. ");
INSERT INTO lyn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Munyima no maywaa aatu, sebeli amuwana mu Ndoo ya Nyambe, yo ikalile mukaci no aiyeti, okwa teeteta ni kwa ibanguta etipuzo. ");
INSERT INTO lyn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Cwale onje awo ana ku muyupa sebeli akomoka mu ku yupisisa kwaye ni tikalabo taye. ");
INSERT INTO lyn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Cwale aba ana ku mu mona sebeli akomoka onene, mi inawaye sebeli omwibnguta nji, “Mwanange, iikene ona tu tendele ngeeso? Komone, sitowe ni mene kame tu lemine oukusaela kame tu ziyelehile.” ");
INSERT INTO lyn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Cwale Jesu sebeli wamba kwa onyene nji. “Iikene mu ni saelela? Kamu limukile nji kame ni fanena okwikala mu ndoo ya Sitange?” ");
INSERT INTO lyn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mi onyene kasi ku yupisisa etaba ana kwamba kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Cwale sebeli oshetumuka noo ni kwiiya ku Nazaleta, kame anoku kokobeza kwa onyene, cwale inawaye sebeli oteula einu eyi yonje mu mucima waye. ");
INSERT INTO lyn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Cwale Jesu sebeli wekeza mu kushangama ni mu kukula, ni mu ku wabelisa Nyambe naanu. ");
INSERT INTO lyn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mu mwaka no likumi ni mutanu mu puzo ya Tibele Sesale, Ponse Pilato abo yooli omubusisi no Judeya, Heloda neli omwendisi no Galileya, minaye Filipi yooli omwendisi no naha ya Ituliya ni Tilakonita, mi Lisanyasi neli omwendisi no Abilene, ");
INSERT INTO lyn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","mi Annasi ni Kayafasi ali apulisita akulu, eliywi lya Nyambe sebeli liiya kwa Jowani omwana Zakaliya mu lihalaupa. ");
INSERT INTO lyn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Cwale sebeli ota mu naha yonje eyo ikubapile ni Jodani yo kutaza ekolobezo no kubaka nji eibi ilemenwe. ");
INSERT INTO lyn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kanyi omo ku n̄olelwe mu buka no maywi a Isaya omunuhi wa Nyambe nji, “Eliywi no munjili kame likuweleza mu lihalaupa eli lyaamba nji, mu lukise endila no Mbumu, mubakenye endila yaye nji yoloke! ");
INSERT INTO lyn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Omusindi onje mba wiyala, mi akalundu ni lilundu mbei ulululiwa. mi eyi ibetile mbei oloka, ni tindila no ku tengama mbati lukisiwa. ");
INSERT INTO lyn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mi omunu yonje mba mono okuyoyisa kwa Nyambe!’” ");
INSERT INTO lyn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Cwalehe sebeli wambela aanu no kupula awo ana kwiiya ku kukolobeziwa kwa yonyene nji, “Anyi aana no tinyoka! Anyine ona milemusa okucila okutweba oko kwiiya? ");
INSERT INTO lyn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mu beeke etimbuya eto tifanena nji na mubaka. Mi mulese oku tangisa okwamba mukaci kenu nji, ‘Sitetu ni Abulahama.” Kakuli kame ni myambela nji Nyambe kame atwesa oku shimba amawee aa okwaatenda aana a Abulahama! ");
INSERT INTO lyn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Simba abano esamu kame si beekilwe ba mibisi no itondo, mi cwale esitondo sonje eso suulwa oku beeka embuya no kuwaba kame sitemiwa ni ku siyumbela mu mulilo.” ");
INSERT INTO lyn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Cwale enyangela sebeli imwibanguta nji, “Iikene cwale sa tutende?” ");
INSERT INTO lyn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jowani sebeli waatambula nji, “Woyo yonje okwite eikumango yiili, aku tabele ni woyo waakwite, ni woyo okwite esilya, atende ngeeso ni yonyene.” ");
INSERT INTO lyn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Atelisi nonyene sebeli aiiya kwa Jowani mu kukolobeziwa, sebeli amwibanguta nji, “Mwiyeti, iikene sa tutende?” ");
INSERT INTO lyn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Cwale sebeli waambela nji, “Mulese okutelisa oku bitelela eso mu nalaelelwe. ");
INSERT INTO lyn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Amasole nonyene sebeli amwibanguta nji, “Cwale aci iikene sa tutende?” Cwale sebeli waambela nji, “Mulese okwitela omunu mu kukandimeka simba oku mubyangula, mi musepe etituwelo tenu.” ");
INSERT INTO lyn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aanu atatelele, mi onje kame ano kwibanguta mu micima yoo nji mwendi Jowani yokame Kilesite. ");
INSERT INTO lyn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jowani sebeli waatambula onje nji, “Mene, kame ni mikolobeza ni meyi, kono woyo onibita ku maata kame akeile, simba etikwele no tinjangwa taye sitwese okuti nungutula, yonyene kame sa mikobeze ni Mebo No Kukena ni mulilo. ");
INSERT INTO lyn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Enumbi yaye kame ili mu lyoko lyaye, mi kame sa fefule oubeke ba patelo niku ungeka ouloto waya mu sishete, kono omuuku kame sa ucin̄iwe mu mulilo no kwaabwa.” ");
INSERT INTO lyn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Cwale mu tindila tinjili no kupula, kame ana ku kutaza amaywi no kuwaba kwaanu. ");
INSERT INTO lyn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kono Ombumu Heloda, sebeli onyaziwa kwa Jowani mu taba no Helodiyasi omukataa minaye, ni mu inu yonje no kwiiba eyo ana ku tenda. ");
INSERT INTO lyn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Cwale Heloda sebeli oekeza kweyo yonje no kwiiba mu kwingenyeka Jowani mu tolongo. ");
INSERT INTO lyn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cwale onje aanu aba ana ku kolobeziwa, ni Jesu ni yonyene sebeli okolobeziwa. Yo lapela, eliwilu sebeli liyatuluka, ");
INSERT INTO lyn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","mi Emebo No Kukena sebeli ishetumuka beulu yaye mu siumbiwa sikufeka kanyi elikwici, mi eliywi sebeli litunda ku wilu eli lyaamba nji, “Yawene mwanange woyo osingiwa, ni kukatelwa.” ");
INSERT INTO lyn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu aba ana ku tangisa omusebezi waye yoli ni myaka makumi aatu. Yoli omwana, kanyi omo kuna kutendahalela, nji wa Josefa, omwana Heli, ");
INSERT INTO lyn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","omwana Matate, omwana Lebi, omwana Meleki, omwana Janai, omwana Josefa, ");
INSERT INTO lyn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","omwana Matatiyasi, omwana Amosi, omwana Nahumi, omwana Eseli, omwana Nagayi, ");
INSERT INTO lyn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","omwana Maate, omwana Matatiyasi, omwana Semeini, omwana Joseke, omwana Juda ");
INSERT INTO lyn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","omwana Joanani, omwana Lesa, omwana Zalubabele, omwana Shealutiele, omwana Neli, ");
INSERT INTO lyn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","omwana Meleki, omwana Adi, omwana Kosamu, omwana Elimadamu, omwana Ele, ");
INSERT INTO lyn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","omwana Joshuwa, omwana Eliezele, omwana Julimu, omwana Matate, omwana Libi, ");
INSERT INTO lyn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","omwana Simioni, omwana Juda mwana Josefa, omwana Jonami, omwana Eliyakimi, ");
INSERT INTO lyn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","omwana Meleya, omwana Mena, omwana Matasa, omwana Nasani, omwana Dabida, ");
INSERT INTO lyn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","omwana Jese, omwana Obedi, omwana Bowasi, omwana Salumoni, omwana Nashoni, ");
INSERT INTO lyn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","omwana Aminadabi, omwana Adamini, omwana Alini, omwana Heziloni, omwana Pelezi, omwana Juda, ");
INSERT INTO lyn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","omwana Jakobo, omwana Isaka, omwana Abulahama, omwana Tela, omwana Naholi, ");
INSERT INTO lyn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","omwana Selugi, omwana Leu, omwana Paleki, omwana Ebele, omwana Shela, ");
INSERT INTO lyn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","omwana Kainani, omwana Alifakasadi, omwana Sema, omwana Nuwe, omwana Lameke, ");
INSERT INTO lyn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","omwana Metusela, omwana Enoki, omwana Jalidi, omwana Mahalaele, omwana Kainani ");
INSERT INTO lyn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","omwana Enosi, omwana Seta, omwana Adama, omwana Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Cwale Jesu aba ana kwiyala Emebo No Kukena, sebeli ouka ku Jodani, mi sebeli otwaliwa ku Mebo ku lihaupa, ");
INSERT INTO lyn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","sebeli oka ikalamo mu lihalaupa amaywaa makumi anee, yo etekiwa kwa Diyabulosi. Kasi kulya esilya mu maywaa awo, amaywaa awo aba ana kubwa, sebeli oyomba. ");
INSERT INTO lyn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Odiyabulozi sebeli wamba kwa Jesu nji, “Nji uli mwana Nyambe, olaele amawee aa nji afutuke esinkwa.” ");
INSERT INTO lyn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Cwale Jesu sebeli omutambula nji, “Kame ku n̄olilwe nji, ‘Omunu katamba kuyoya ba sinkwa feela.’ ” ");
INSERT INTO lyn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Cwale Diyabulozi sebeli omutwala aba kulumbiile niku mumonisa emibuso yonje no litunga mu nako eyeyo. ");
INSERT INTO lyn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Odiyabulozi sebeli wamba kwa yonyene nji, “Kwa wene kame sa ni kube amaata onje ni kanya yawo yonje, kakuli yonje eye kame ina ibiwi, mi kame niiba kwa woyo ni singa. ");
INSERT INTO lyn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nji wene, cwale, kame soni lapele, yonje kame saitende yowe.” ");
INSERT INTO lyn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Cwale Jesu sebeli omutambula nji, “Kame ku n̄olilwe nji, ‘Olapele Mbumu Nyambe wowe ni ku sebeleza yonyene feela!’ ” ");
INSERT INTO lyn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kame sebeli omutwala mu Jelusalema nuukamu beeka ba monngola no Ndoo ya Nyambe, ni kwamba kwa yonyene nji, “Nji uli Mwana Nyambe, oku kondele banji wenyene okutunda bano, ");
INSERT INTO lyn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kakuli kame ku n̄olilwe nji, ‘Nyambe mba laele amangeloi aye nji aku sileleze.’ ");
INSERT INTO lyn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mi ‘Ba maoko oo mba kwakele nji cwale amakondo owe aulwe oukulemeka ku liwee.’ ” ");
INSERT INTO lyn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Cwale Jesu sebeli omutambula nji, “Kame ku n̄olilwe nji, ‘Ku twese okweteka Ombumu Nyambe wowe.’ ” ");
INSERT INTO lyn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cwale Diyabulosi aba ana kumana oku mweteka mu mikwa yonje, sebeli otunda kwa yonyene, oku twala ba nako injili. ");
INSERT INTO lyn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Cwale Jesu sebeli oukela ku Galileya mu maata no Mebo, mi elibubo lyaye sebeli lita okakeela mu maneku onje no naha. ");
INSERT INTO lyn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Cwale sebeli oiyeta mu tindoo too no milapelo ni kububekwa ku munu yonje. ");
INSERT INTO lyn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Cwale sebeli oiya mu Nazaleta, omu ana kulitiwa, mi sebeli ota mu ndoo no milapelo kanyi omo ana kwikalela omukwa waye ba liywaa no Pumulo. Sebeli oimana okubala ");
INSERT INTO lyn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","mi omo sebeli obiwa ebuka no munuhi Isaya. Yonyene sebeli ofukula ebuka ni kuwana aba ku n̄olilwe nji, ");
INSERT INTO lyn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Emebo ya Mbumu kame ili beulu yange, kakuli nani kete oku kutaza eliywi no kuwaba kwaa ashebile. Kame anani tumu oku kutaza etukuluho no awo ali mu ukoba ni kubalisa amiyo no ibofu, ni kulukulula awo ayandisiwa ");
INSERT INTO lyn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","mi naambe omwaka ona kupumenenwa wa Mbumu.” ");
INSERT INTO lyn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Cwale Jesu sebeli ofuka ebuka, ni ku yuusa ku mubika, mi sebeli oikala banji. Amiyo no awo onje ana kwikala mu ndoo no milapelo sebeli amwaliketa. ");
INSERT INTO lyn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Cwale sebeli otangisa okwamba kwa onyene nji, “Balelo elin̄olo eli nali iyatetetwa, me mu kuyupela.” ");
INSERT INTO lyn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Cwale onje sebeli aamba wino eyaye, ni ku komoka amaywi aye no musa ana ku tunda mu kanwa kaye, sebeli aamba nji, “Kana wuyu, kasa yokame Mwana Josefa?” ");
INSERT INTO lyn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Cwale Jesu sebeli wamba kwa onyene nji, “Luli mba mu nambele enguli eyi, ‘Onganga, oku balise wenyene.’ Eyo tuna yupu ona tende mu kapenauma, witende ngeeso ni muno mu naha yowe. ");
INSERT INTO lyn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Cwale sebeli wamba nji, “Niti luli kame nimyambela nji, kakwisa omunuhi okutekiwa mu naha yaye. ");
INSERT INTO lyn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kono niti luli, kame nimyambela nji kame kuna kwikalanga ambakati no kupula mu Isilaele mu maywaa a Eliya, abo eliwilu aba lina ku fukiwa mu myaka yaatu ni tikweti mutanu ni kamweya, mi kame kuna kwikala elishebo linene mu naha yonje. ");
INSERT INTO lyn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Cwale Eliya kasiku tumiwa ku munu yonje kono konji feela kwa Zalefasi, mu naha no Sidoni ku mukati no mbakati. ");
INSERT INTO lyn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mi kame kuna kwikalanga asimbingwa no kupula mu Isilaele mu nako ya munuhi Elisha, mi kakwisa woyo ona kubalisiwa, kono konji feela Naamani Omusiliya.” ");
INSERT INTO lyn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Cwale aba ana kuyupa eyi, onje mu ndoo no milapelo sebeli atweba. ");
INSERT INTO lyn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Cwale sebeli aimana ni ku mucita mu mulenen̄i, ni ku mutwala ba lin̄ope no lilundu elyo ana ku yakela omulenen̄i woo, nji amu kwisete kunji. ");
INSERT INTO lyn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kono sebeli waabita mukaci koo nuukutela. ");
INSERT INTO lyn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Cwale Jesu sebeli ota ku Kapenauma, omulenen̄i no Galileya, mi na kwaaiyeta ba liywaa no Pumulo. ");
INSERT INTO lyn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Cwale kame ana ku komoka onene etuto yaye, kakuli amaywi aye kame ana kwikala ni maata. ");
INSERT INTO lyn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mi mu ndoo no milapelo kame kuna kwikala omulume osi mebo no kwiiba, cwale sebeli okuwa ni liywi no kuneneba nji, ");
INSERT INTO lyn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Etaba yetu ni wene ibine, Jesu no Nazaleta? Kame oneeyi muku tusinya? niku limukile nji tiwe anyine, tiwe no Kukena wa Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kono Jesu sebeli omukalimela nji, “Ondoka, mi otunde mwa yonyene!” Mi cwale emebo aba inaku mukwiseta banji mukaci no aanu, cwale sebeli itunda mwa yonyene eyulwile okumutenda esi no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Cwale onje sebeli akomoka nuukwambisa omunjili ku munjili nji, “Eliywi eli libine? Kame ali ni tukelo ni maata no ku laelela emebo no kwakena, mi kame itunda!” ");
INSERT INTO lyn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Cwale elibubo lyaye sebeli lita mu ibaka yonje itingulukile enaha eyo. ");
INSERT INTO lyn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesu sebeli otunda mu ndoo no milapelo, ni kwingena mu ndoo ya Simoni. Njemunwa Simoni yo langanine yotomine onene elitomapa, mi sebeli aamba eyaye kwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Cwale Jesu sebeli oimana ku nyonga yaye ni ku kalimela litomapa, mi sebeli litunda mwa yonyene, cwale ababo sebeli oinguka ni kwaa sebeleza. ");
INSERT INTO lyn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Cwale eliywaa aba lina kwiika, onje awo ana kwikalanga naanu no meeti no oukusiya-siya sebeli aalita kwa Jesu, mi sebeli wabeeka amaoko aye beulu ni kwaabalisa. ");
INSERT INTO lyn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Cwale emebo no kupula no kwiiba sebeli itunda, eyi kuwa nji, “Tiwe Mwana Nyambe!” Kono Jesu sebeli oikalimela, ni kwilaela nji ilese okwamba, kakuli naiku limuka nji yokame Kilesite. ");
INSERT INTO lyn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Cwale eliywaa aba lina kupa, Jesu sebeli ofunduka ni kuta okaikala mu sibaka yomboci. Mi aanu sebeli amusaela ni kwiiya kwa yonyene nji amu kanise okwasiya. ");
INSERT INTO lyn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kono sebeli waatambula nji,“Kame nifanena okakutaza eliywi no kuwaba no mubuso wa Nyambe mu milenen̄i injili ngeeso, kakuli sokame eso ina tumenwe.” ");
INSERT INTO lyn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Cwale sebeli okutaza mu tindoo no milapelo mu Judeya. ");
INSERT INTO lyn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jesu yoli ba likamba no lisa lya Genesaleta, aanu sebeli amusheeteta onene nji ayupe eliywi lya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Cwale sebeli omona amato ayiili mu lisa, kono ayambi natundumo mi alemine oku yowisanga otunyandi too. ");
INSERT INTO lyn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesu sebeli oingena mu wato omunjili wa Simoni, sebeli omwambela nji aufule kanyonyo okutunda ba likamba. Cwale sebeli oikala banji ni kwiyeta aanu no kupula yoli mu wato. ");
INSERT INTO lyn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cwale aba ana kumana okwamba sebeli wambela Simoni nji, “Obeeke aba no kutunga onene mi oyambe otunyandi towe.” ");
INSERT INTO lyn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Cwale Simoni sebeli otambula nji, “Molyange, natu yamba ousiku wonje kono kakwisa esi tuna wana. Kono okuta mu liywii lyowe kame niyamba otunyandi.” ");
INSERT INTO lyn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Cwale aba ana kutenda ngeeso, sebeli akuuya elibunda linene no tindi, mane akanyandi sebeli ka kauka. ");
INSERT INTO lyn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Cwale sebeli akobeta alikani oo nji aiye mukwaatusa. Cwale sebeli aiya ni kwiiyata amato ayiili mane sebeli atateka okutika. ");
INSERT INTO lyn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kono Simoni Pitolosi abana kumona ngeeso, sebeli okukwiseta banji ni manwi aye kwa Jesu ni kwamba nji, “Otunde kwa mene, kakuli mene kame nili osiku tenda eibi, Mbumu!” ");
INSERT INTO lyn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mulibaka elyo kame ana kukomoka onene naawo ana kwikala naye ba ku mona okupula no tindi anaku kuuya. ");
INSERT INTO lyn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Cwale sebeli ku tendahala ngeeso ni kwa Jacobo ni Jowani aana a Zebedeya, alikani a Simoni, mi Jesu sebeli wambakwa Simoni nji “Olese ku cila, okutunda bano mbuyamba aanu.” ");
INSERT INTO lyn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Cwale aba ana kulita amato oo ku likamba, sebeli asiya einu yonje ni ku mukon̄a ");
INSERT INTO lyn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesu yoli mu mulenen̄i munjili, sebeli kwiiya omulume osi kutoma embingwa, mi aba ana kumona Jesu, sebeli okwela banji ni lubala lwaye ni kwamba nji, “Mbumu, nji kame osinga, kame otwesa okuni balisa!” ");
INSERT INTO lyn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Cwale Jesu sebeli oolola elyoko lyaye ni ku mulema ni kwamba nji, “Nisinga, obale!” Mi ababo embingwa sebeli ibwa. ");
INSERT INTO lyn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Cwale sebeli omulaelela nji alese okwambela omunu, “Kono ote oka kumonahalise kwa mupulisita, mi olite enubu no ku balisiwa kanyi omu ana ku laelela Mushe, itende oupaki kwaanu.” ");
INSERT INTO lyn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kono cwale elibubo lyaye sebeli lihasana, mi aanu no kupula sebeli aungana oku muteeteteta ni ku balisiwa ku meeti oo. ");
INSERT INTO lyn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kono sebeli ota mu lihalaupa oka lapela. ");
INSERT INTO lyn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ba liywaa elinjili yo iyeta, kame kuna kwikala Afalisi na iyeti no mulawo awo nakwiiya okutunda mu mindi yonje no Galileya ni Judeya ni mu Jelusalema, mi amaata a Mbumu kame ana kwikala kwa yonyene oku balisa aanu. ");
INSERT INTO lyn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Komumone, sebeli kwiiya alume ashimbile omulume ba saala osi lun̄an̄ali, mi sebeli akumbela oku mwingenyika mukaci ni ku mu langeka ba lubala lwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kono kasi kuwana esibaka no kwingena, mulibaka no aanu okupula, sebeli atina ba lituwa no ndoo ni ku mu shulumukiseta ni saala saye mukaci no aanu balubala lwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Cwale Jesu aba ana kumona etumelo yoo, sebeli wamba nji, “Mulume, eibi yowe na wilemenwe.” ");
INSERT INTO lyn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Cwale aiyeti no mulawo na Falisi sebeli atangisa okwibanguta aamba nji, “Anyine wuyu mulume woyo wamba mu malimbuluti? Woyo so twesa okulemena eibi konji feela konji Nyambe yomboci.” ");
INSERT INTO lyn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Cwale Jesu aba ana kulimuka etipuzo too, sebeli waatambula nji, “Ngasibine aba mukwibanguta mu micima yenu? ");
INSERT INTO lyn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Sibine esi sootobile, okwamba nji, ‘Eibi yowe nwilemenwe,’ ni kwamba nji, ‘Oimane mi weende?’ ");
INSERT INTO lyn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kono nji mulimuke nji Omwana no munu kame akwite etukelo no kulemena eibi bano banji.” sebeli wambela omulume osi lun̄an̄ali nji, “Kame nikwambela nji, oimane, oshimbe oulangano wowe mi ote ku mundi!” ");
INSERT INTO lyn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Cwale ababo sebeli oimana ba lubala loo onje, ni ku shimba oulangano waye, ni kuta ku mundi waye yo yeema Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sebeli akomoka onene onje, ni ku yeema Nyambe mane sebeli aiyala okucila aamba nji, “Balelo na tumono einu indina no ku komokisa!” ");
INSERT INTO lyn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Eyo aba ina kubwa, Jesu sebeli otundamo, mi sebeli omona Lebi omutelisi yo ikalile ba ofisi no mutelo, mi sebeli omwambela nji, “Onikon̄e.” ");
INSERT INTO lyn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Cwale Lebi sebeli osiya einu yonje, ni ku mu kon̄a ");
INSERT INTO lyn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Cwale Lebi sebeli otendeliwa omukiti no kuneneba mu ndoo yaye, mi kame kuna kwikala atelisi anjili no kupula naanjili ana kwikala noo ku tafule. ");
INSERT INTO lyn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Cwale Afalisi naa iyeti no mulawo sebeli an̄un̄uta ni kwambela aiyetwa aye nji, “Iikene aba mulya ni kunwa na telisi na sikutenda eibi?” ");
INSERT INTO lyn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Cwale Jesu sebeli waatambula nji, “Aanu awo ayoya wino kasaele onganga, kono awo atomine okame amusaela. ");
INSERT INTO lyn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kani siiya mu kwisana awo alukile, kono awo asikutenda eibi nji abake.” ");
INSERT INTO lyn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Cwale aanu sebeli aamba kwa Jesu nji, “Aiyetwa a Jowani aka no kupula kame aku yumenanga eilya mi kame alapelanga, na iyetwa no Afalisi kame atendanga ngeeso, kono aiyetwa owe kame alya ni kunwa.” ");
INSERT INTO lyn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Cwale Jesu sebeli waambela nji, “Kame ku twesahala nji alikani no mukwati aku yumene eilya omukwati yoli noo? ");
INSERT INTO lyn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amaywaa mba iiyi omukwati aba sa tundisiwe kwa onyene, mi cwale kame saaku yumene eilya mu maywaa awo.” ");
INSERT INTO lyn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesu kame sebeli waambela enguli injili nji, “Kakwisa omunu otwesa oku tundisa esimanahanyi ba sikumango no ubya nji asi beeke ba sikumango no ku kulubala. Nji atende ngeeso, mba kaula esikumango no ubya, mi esimanahanyi no ubya kasi tamba oku lumelelana ni sikumango noku kulubala. ");
INSERT INTO lyn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kakwisa omunu otwesa oku beeka ewaine no ubya mu sindunga no ku umbiwa ba itumba no ku kulubala, nji atende ngeeso, ewaine no ubya mbai kaula eitumba mane ni kwiteka, ni itumba mbai sinyehe. ");
INSERT INTO lyn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kono ewaine no ubya kame ifanena okwibeeka mu indunga no kuumbiwa ba itumba no ubya. ");
INSERT INTO lyn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Cwale kakwisa omunu so tateka okunwa ewaine no kale nji asinge eyi no ubya, kakuli kame saambe nji, ‘Ewaine no kale ya kuwaba okubita eyi no ubya.” ");
INSERT INTO lyn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ba liywaa linjili no Pumulo, Jesu yo bita mu matema no ubeke, aiyetwa aye sebeli ayangula amakunka no ubeke, ni kwapolola mu maoko oo ni kulya oubeke. ");
INSERT INTO lyn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kono anjili no Afalisi sebeli aamba nji, “Iikene aba mutenda eyi no kwafanena ba liywaa no Pumulo?” ");
INSERT INTO lyn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Cwale Jesu sebeli otambula nji, “Kamwa sikubala eyo ana ku tenda Dabida yo yombile, yonyene naawo ana kwikala naye? ");
INSERT INTO lyn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Omo ana kwingenena mu ndoo ya Nyambe, noomo ana kushimbela ni kulya esinkwa sina ku lukisetwa Nyambe, eyo nakwafanena okuliwa ku munu yonje konji apulisita, mi sebeli obako nawo ana kwikala naye.” ");
INSERT INTO lyn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Cwale Jesu sebeli wamba kwa onyene nji, “Omwana no Munu ni Mbumu no Pumulo.” ");
INSERT INTO lyn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ba liywaa elinjili no Pumulo, Jesu aba ana kwingena mu ndoo no milapelo ni kwiyetamo, na ku kwikala omulume osi ku kukutela olun̄an̄ali ku lyooko no silyo. ");
INSERT INTO lyn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Afalisi anjili na iyeti no mulawo sebeli aaliketa Jesu oku mona nji mba balisa omunu ba liywaa no Pumulo, nji cwale awane elibaka no kumununga eyambo. ");
INSERT INTO lyn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kono Jesu sebeli olimuka emihupulo yoo, mi sebeli wamba ku mulume osiku kukutela elyoko nji, “Wiiye wimane bano.” Cwale sebeli oimana ni kuta ba lubala no aanu. ");
INSERT INTO lyn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Cwale Jesu sebeli wamba kwa onyene nji, “Kame nimi ibanguta nji, kakufanene eli no Pumulo okutenda eyi no kuwaba simba okutenda ouyi? Oku yoyisa omooyo nji okuusinya?” ");
INSERT INTO lyn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Cwale sebeli waaliketa onje ni kwambela woyo mulume nji, “Oolole elyooko lyowe.” Mi sebeli otenda ngeeso, cwale elyoko lyaye sebeli libala. ");
INSERT INTO lyn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kono sebeli aiyala okutweba nuukwambisa mukaci koo eso sa fanene okutenda kwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mu maywaa aa Jesu sebeli ota ku lilundu oka lapela, mi usiku onje yotwalelela okulapela kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Cwale aba lina kupa eliywaa, sebeli oisana aiyetwa aye, ni kuketa mwa onyene aa no kukwana likumi na yiili, awo ana kubeekiwa nji atumiwa. ");
INSERT INTO lyn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni, ana kubeeka elitina lya Pitolosi, ni Adiliyasi minaye, Jakobo, ni Jowani, ni Filipi, ni Batolome, ");
INSERT INTO lyn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ni Mateu, ni Tomasi ni Jakobo omwana Alufeya, ni Simoni wisanwa nji Zeloti, ");
INSERT INTO lyn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ni Judasi Mwana Jakobo, ni Judasi Isikaliota, omubeteki. ");
INSERT INTO lyn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Cwale sebeli oshetumuka noo ni kwimana ba saana, ni kupula no aiyetwa aye naanu no kupula ana ku tunda mu Judeya monje ni mu Jelusalema ni ba likamba lya Tile ni Sidoni, ana kwiiya mu kumuteeteta ni ku balisiwa ku meeti oo, ");
INSERT INTO lyn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","naawo ana ku ziyeleha ku mebo no kwiiba naku balisiwa. ");
INSERT INTO lyn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Cwale oundi no aanu sebeli ayeya nji amuleme, kakuli amaata kame ana kutunda kwa yonyene ni kwaa balisa onje. ");
INSERT INTO lyn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Cwale sebeli waliketa aiyetwa aye ni kwamba nji, “Embuyoti ni yenu anyi mushebile, kakuli omubuso wa Nyambe ni wenu! ");
INSERT INTO lyn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Embuyoti ni yenu anyi mu yombile bano, kakuli mba mwikuta! Embuyoti ni yenu anyi mu lila bano, kakuli mba musheke! ");
INSERT INTO lyn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Embuyoti ni yenu aba mutimbiwa kwaanu, naaba amicita, naaba amyangola, ni kukana elitina lyenu kanyi lyakwiiba, mulibaka lya Mwana no Munu! ");
INSERT INTO lyn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mu wabelelwe mu liywaa elyo, mu nenge mu ku nyakalala, kakuli komone, omupuzo wenu ni wakuneneba ku wilu, kakuli anjekulyenu naaku tenda ngeeso kwa nuhi a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Kono oumai ni wenu asikufuma, kakuli na mu tambula omooyo no kotoba! ");
INSERT INTO lyn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Oumai ni wenu anyi mwiikutile bano, kakuli mba muyombo! Oumai ni wenu anyi musheka bano, kakuli mbamweene ni ku lila. ");
INSERT INTO lyn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Oumai ni wenu, abo aanu onje aba aamba ouwa wenu, kakuli anjekulyoo kame ana kutenda ngeeso kwa nuhi no mapwa. ");
INSERT INTO lyn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Kono kame namba kwaanyi muyupa, mu singe eila yenu, mu tende wino kwawo ami timbile, ");
INSERT INTO lyn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","mu fuyole awo amikuta, mu lapelele awo ami timbile. ");
INSERT INTO lyn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Woyo okufula ku litama limweya omube akufule kame ku litama linjili, mi omunu nji aku byangule ebaki yowe omube mane ni hembe yowe. ");
INSERT INTO lyn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Obe woyo okumbela kwa wene, ni woyo oshimba einu yowe olese ku mubyangulayo kame. ");
INSERT INTO lyn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Cwale omu musingela nji aanu ami tendele, naanyi mutende ngeeso kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nji kame musinga awo ami singa, kawitumelo sa mu mone? Kakuli simba asikutenda eibi kame asinga awo aasinga! ");
INSERT INTO lyn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Cwale nji otenda ouwa kwaawo atenda ouwa kwa wene, ka witumelo sau mone? kakuli simba nonyene asi kutenda eibi mwatendela ngeeso! ");
INSERT INTO lyn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Cwale nji kame mukalima awo mu sepile nji mba myusete, ka witumelo sa mu mone? Simba asiku tenda eibi, kame akalimana nawo atenda eibi, nji ausetwe mukupula ngeeso. ");
INSERT INTO lyn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kono mu singe eila yenu, mwaa tende wino, mwaa kolotise me mwabilaele nji muusetwe esinjili, mi omupuzo wenu kame saunenebe, mi kame sa mu tende aana a Nyambe Oli Beulu, kakuli yonyene niwa sishemo kwaawo no kwaku tumela naawo akusinga onyene. ");
INSERT INTO lyn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mwikale ni makeke kanyi Sitenu aba ali ni makeke. ");
INSERT INTO lyn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mu lese kwatula nji naanyi muulwe okwatuliwa, mu lese oku nyaza nji naanyi muulwe oku nyaziwa, mu lemene akwenu nji naanyi mu lemenwe. ");
INSERT INTO lyn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mube, nji naanyi mubiwe, niti luli kame sa mu tambule empo no utokwa eyo saibeekwe mu makaa enu. Kakuli esikala no kuwaba, mwetela banji mane mwinyunge bamweya, mwituke beulu mi mbaibekiwa ba yeelo yenu. Kakuli esikala muba kwa kwenu, naanyi sokame eso sa muwane.” ");
INSERT INTO lyn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kame Jesu sebeli waambela enguli nji, “Kana esibofu kame sitwesa oku twaletela esibofu sinjili? Yonje kaitamba okukwela mu wina?” ");
INSERT INTO lyn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Omwiyetwa katwese okubitelela omwiyeti waye, kono omunu yonje aba ana mana okwiyetiwa kame safeke kanyi omwiyeti waye. ");
INSERT INTO lyn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ngasibine waliketa esoopu sili mu litiyo no mwabowe, kono wene kumono omusumo oli mu litiyo lyowe? ");
INSERT INTO lyn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Simba nji ngasibine so twesete okwambela omwabowe nji, ‘Mwabange, tumone ni kutundise esoopu sili mu litiyo lyowe,’ abo weene kumono omusumo owo oli mu litiyo lyowe? Wene osikukuba, oweli otundise omusumo oli mu litiyo lyowe, okubinda cwale somone wino oku tundisa esoopu sili mu litiyo no mwabowe. ");
INSERT INTO lyn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kakuli kakwisa esitondo no kuwaba sibeeke embuya no kwiiba, simba nji kame esitondo no kwiiba sibeeke embuya no kuwaba. ");
INSERT INTO lyn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mulibaka elyo esitondo sonje kame silimukelwa ku mbuya yaso sibeeka, kakuli etifeiga kati yangulwa ku mikakani, simba esisansa no beine kasi yangulwa ku mukona. ");
INSERT INTO lyn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Omunu no kuwaba kame atundisa eyi no kuwaba mu sitewelo na mu mucima waye, mi omunu no kwiiba kame atundisa eyi no kwiiba mu sitewelo saye no kwiiba, kakuli akanwa no munu kame kaamba eso siiyalile mu mucima waye. ");
INSERT INTO lyn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ngasibine aba mu niisana nji ‘Mbumu, Mbumu,’ mi ka mutende eso ni myambela? ");
INSERT INTO lyn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Omunu yonje woyo wiiya kwa mene ni ku teeteta ku maywi ange ni kwasebelisa, mbimi simwete eso aku fekile naso. ");
INSERT INTO lyn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kame aku fekile kanyi omulume oyaka endoo yaye, woyo ona kutungisa onene bakutombola, ni kuyaka omutomo waye ba liwee, mi cwale omuunda aba wiiya, ameyi aba afula onene ba ndoo, mi katwese okunyanganyisa endoo eyo, kakuli kame iyakilwe wino. ");
INSERT INTO lyn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kono woyo oyupa amaywi ange mi kaasebelisa, kame akufekile kanyi omulume oyaka endoo yaye ba mumbu feela aba nambulwa omutomo, mi ameyi aba afulabo onene ababo kame ikwa, mi oku sinyeha no ndoo eyo kame sakutende oku no kuneneba onene!” ");
INSERT INTO lyn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cwale Jesu aba ana kumana okwambela aanu sebeli oingena mu Kapenauma. ");
INSERT INTO lyn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Cwale omukulu no masole kame ana kwikalanga ni mubika waye ona ku singiwangwa onene, ona ku tomanga mi kame ana kwikala abeebi ni kufa. ");
INSERT INTO lyn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Cwale aba ana kuyupa eya Jesu, sebeli omutumena akulu no Majuda oka mukumbela nji aiye mu kubalisa omubika waye. ");
INSERT INTO lyn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mi cwale awo aba ana kwiiya kwa Jesu, sebeli amu kumbela onene mu likute aamba nji, “Kame ku fanena nji wene omutendele eyi ngeeso. ");
INSERT INTO lyn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kakuli kame asinga aanu etu, mane na tuyakele endoo no milapelo.” ");
INSERT INTO lyn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Cwale Jesu sebeli ota noo. Abana ka keela ku nyonga no ndoo, omukulu no masole sebeli omutumena alikani, sebeli aiya mukwamba kwa yonyene nji, “Mbumu olese oku kataza kakuli silukele nji wene wingene munji no lituwa no ndoo yange, ");
INSERT INTO lyn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","bokame nina ku mona nji simba oukumonahaza kwa wene sifanene. Kono waambe eliywi mi omubika wange mba bala. ");
INSERT INTO lyn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kakuli mene naba nili munji no maata no akwange, kame nili ni masole ange, mi aba naamba ku munjili nji, ‘Ote!’ kame ata, ni ku munjili nji, ‘Wiiye!’ kame aiya, ni ku mubika wange aba naamba nji, ‘Otende esi!’ mi kame asi tenda.” ");
INSERT INTO lyn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Cwale Jesu aba ana kuyupa eyi sebeli okomoka, niku siulukela kwaanu ana ku mukon̄a ni kwaambela nji, “Kame ni myambela, simba mu Isilaele kani siwana etumelo iku fekile kanyi eyi!” ");
INSERT INTO lyn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mi cwale awo ana ku tumiwa aba ana kuukela ku ndoo, sebeli aka wana omubika yooli wino. ");
INSERT INTO lyn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Munyima nweyo, Jesu sebeli ota mu mulenen̄i wisanwa Naine, na iyetwa aye ni undi no aanu sebeli ata naye. ");
INSERT INTO lyn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ababo yo keela feela ba mwelo no mulenen̄i, sebeli okwangana naanu ashimbile omufu, neli mwana mumweya no ndumbana kwa inawaye mi neli mbakati, naanu no kupula ana ku tunda mu mulenen̄i aenda naye. ");
INSERT INTO lyn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Cwale Ombumu aba ana kumona omukati woyo, sebeli omuyupela amakeke ni ku mwambela nji, “Olese ku lila” ");
INSERT INTO lyn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Cwale sebeli wiiya ni ku lema ba lukutu, mi awo ana ku lushimba sebeli aimana. Cwale sebeli wamba nji, “Ndumbana, kame naamba kwa wene nji, inguka!” ");
INSERT INTO lyn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Cwale omunu ona kufa sebeli oimana ni kutangisa okwamba, mi Jesu sebeli omuusa kwa inawaye. ");
INSERT INTO lyn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Cwale onje sebeli aingenwa okucila, ni kuyeema Nyambe aamba nji, “Omunuhi munene wa Nyambe na monahala mukaci ketu!” mi “Nyambe na potele aanu aye!” ");
INSERT INTO lyn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Cwale elibubo lyaye sebeli lihasana mu naha yonje no Judeya ni mu tinaha tonje tiku bapile nayo. ");
INSERT INTO lyn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Aiyetwa a Jowani sebeli amwambela einu yonje. ");
INSERT INTO lyn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Cwale Jowani sebeli oisana aiyetwa aye ayiili, ni kwatuma kwa Mbumu nji akaibangute nji, “Kana yawene woyo fanene okwiiya, nji tu tatelele omunjili?” ");
INSERT INTO lyn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Cwale alume awo aba ana kukeela kwa Jesu, sebeli aamba nji, “Jowani Omukolobezi natu tumu kwa wene mukwibanguta nji yawene onafanene okwiiya, nji tutalele omunjili?’” ");
INSERT INTO lyn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mu nako eyo Jesu na kubalisa aanu no kupula ku meeti oo ni iyanga ni mebo no kwiiba, ni ibofu no kupula sebeli oimonisa. ");
INSERT INTO lyn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Cwale Jesu sebeli waatambula nji, “Mute mi mukambele Jowani eyi muna mono neyi muna yupu, eibofu kame imona, eiyanga kame yeenda, asi mbingwa kame akenisiwa, aafu kame aingulwa, mi aa ashebile kame aambelwa eliywi no kuwaba. ");
INSERT INTO lyn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Cwale embuyoti niya woyo oulwa oku sitatala kwa mene!” ");
INSERT INTO lyn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Cwale awo ana kutumiwa kwa Jowani aba ana kuuka, Jesu sebeli otangisa okwamba eyi ya Jowani kwaanu no kupula nji, “Iikene muno kamona aba muna kuta mu lihaupa, neli olutaka luna ku nyanganyisiwa ku mebo? ");
INSERT INTO lyn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Iikene cwale muna kutela oka mona? Nji neli omunu ona kukufuka eikumango no kotoba? Komumone, awo aku fukile eyi no kubenya ni ku yoya wino kame ali mu tindoo no Ambumu! ");
INSERT INTO lyn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Cwale iikene muna kutela oka mona? Neli omunuhi wa Nyambe? Ee, kame nimyambela nji, mane okubitelela omunuhi wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Eyi yokame eyaye in̄olilwe nji, ‘Komumone, kame nituma onumwana wange ba lubala no lubala lowe yokame solukisa endila yowe balubala lowe.’ ");
INSERT INTO lyn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kame ni myambela nji, “Kwaaawo ana leiwa kwaakati kakwisa woyo no kuneneba kwa Jowani, kono woyo no kucaniba mu mubuso wa Nyambe yo munene okubita Jowani.” ");
INSERT INTO lyn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aanu onje aba ana kumuyupa na telisi sebeli ayeema Nyambe ni ku kolobeziwa mu kolobezo ya Jowani omukolobezi. ");
INSERT INTO lyn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kono Afalisi na iyeti no mulawo sebeli akana omulelo wa Nyambe mu kukolobeziwa mu kolobezo ya Jowani. ");
INSERT INTO lyn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Cwale aanu no lusika olu kame sana fanikete ni siikene? Mi iikene aku fekile nayo? ");
INSERT INTO lyn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kame aku fekile kanyi anukana awo aikalile mu sibaka no musika akwisana omunjili ku munjili nji, ‘Natu mipetele, kono kamwa sinenga! Natu miimbele etindimo no malilo kono kamwa silila! ");
INSERT INTO lyn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kakuli Jowani nakwiiya yo kali esinkwa ni kunwa ewaine, mi kame mwamba nji, ‘Kame akwete emebo no kwiiba!’ ");
INSERT INTO lyn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Omwana no Munu kame aneeyi yoolya ni kunwa, mi kame mwamba nji, ‘Komumone, kame alya ni kunwa, omulikani no atelisi na sikutenda eibi!’ ");
INSERT INTO lyn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kono oku shangama na kukenisetwe anaye onje.” ");
INSERT INTO lyn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Omujili no Afalisi sebeli okumbela Jesu nji akalye naye, mane sebeli ota mu ndoo no mufalisi nukekala ba tafule. ");
INSERT INTO lyn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mi omukati na mu mulenen̄i, osi kutenda eibi aba ana kuyupa nji Jesu kame ali mu ndoo no Mufalisi, sebeli olita esitewelo no maati siisaniwa alabasita ");
INSERT INTO lyn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ni kwimana ku nyonga ya Jesu ku makondo aye, sebeli olila ni kombisa amakondo a Jesu ni myooti yaye. Cwale sebeli otundisa emyooti ni tin̄uki na ku mutwi waye, ni kwatubeta, okwawaa ni maati. ");
INSERT INTO lyn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Cwale Omufalisi woyo ona ku mwisana aba ana ku mona eyo, sebeli okwambisa yomboci nji, “Kambe wuyu mulume munuhi wa Nyambe luli, kambe kame amulikile wuyu mukati omulema ni ku limuka eyi atenda nji osiku tenda eibi!” ");
INSERT INTO lyn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Cwale Jesu sebeli otambula ni kwamba kwa yonyene nji, “Simoni, kwasili eso ni singa okwamba kwa wene.” Mi sebeli otambula nji, “Iikene eyo, Mwiyeti?” ");
INSERT INTO lyn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Omunu munjili kame ana ku kolotisa alume ayiili amali, omunjili sebeli omukolotisa amali no ku kwana ba myaanda itanu, mi omunjili kame sebeli omuba makumi atanu. ");
INSERT INTO lyn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Cwale aba ana ku kwangwa oku teneka sebeli walemena onje. Cwale kwaawo ayiili anyine somu singa onene?” ");
INSERT INTO lyn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni sebeli otambula nji, “Kame ni kakanya nji woyo ona lemeniwa onene.” Cwale Jesu sebeli omwambela nji, “Nu atula wino.” ");
INSERT INTO lyn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Cwale Jesu sebeli ofutukela ku mukati ni kwamba kwa Simoni nji, “Omwine wuyu mukati, ine ingene mu ndoo yowe, kausiniba ameyi no ukuyowa ku makondo ange, kono wuyu mukati na ombisa amakondo ange ni myooti yaye ni kwitundisa ni tin̄uki taye. ");
INSERT INTO lyn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kawasi nitubeta, kono oku tunda ba nako ina ingene muno, kasi lesela oku tubeta amakondo ange. ");
INSERT INTO lyn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kausi waa omutwi wange ni maati, kono yonyene na waa amaati ku makondo ange. ");
INSERT INTO lyn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Cwalehe kame ni kwambela nji, eibi yaye eyo itendile nji yakupula, nai lemenwe kakuli kame anisinga onene, kono woyo olemeniwa mbicani kame asinga mbicani.” ");
INSERT INTO lyn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Cwale Jesu sebeli wambela omukati nji, “Eibi yowe nwilemenwe.” ");
INSERT INTO lyn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Cwale awo ana kwikala naye ku tafule sebeli atangisa okwambisa mu micima yoo nji, “Anyine wuyu, wuyu otwesa simba oku lemena eibi?” ");
INSERT INTO lyn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Cwale Jesu sebeli wamba ku mukati nji, “Etumelo yowe naiku yoyisa, weende mu kozo.” ");
INSERT INTO lyn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Munyima no eyo Jesu sebeli ota mu milenen̄i ni mu mindi yo iyeta Eliywi no kuwaba no mubuso wa Nyambe. Aiyetwa aye no ku kwana likumi na yiili aali naye ");
INSERT INTO lyn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","nakati ngeeso ana ku balisiwa ku mebo no kwiiba ni ku meeti. Maliya ona kwiisaniwa nji Magadalena woyo ona ku tundisiwa emebo no kwiiba itanu ni yiili (7), ");
INSERT INTO lyn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ni Joana omoywa Chuza, esikombwa sa Heloda, ni Suzana, nanjili ngeeso ano kupula, ana ku sebeleza Jesu ni ufumu woo. ");
INSERT INTO lyn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cwale oundi no aanu aba ona kumana oukuwana, naanu ana ku tunda mu titolopo tonje sebeli aiya kwa Jesu, sebeli waambela enguli nji, ");
INSERT INTO lyn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Omukuni nakuta muku kuna embuto yaye, mi yo lemine okukuna ngeeso, injili embuto sebeli ikwela mu ndila, mi sebeli ilyatangiwa ni makondo, mi otuyunyi na mu wilu sebeli iilya. ");
INSERT INTO lyn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Injili sebeli ikwela ba mawee, eikula sebeli iletuka, kakuli kakwa sikwikala omukamo. ");
INSERT INTO lyn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Cwale einjili sebeli ikwela mu mikakani, mi emikakani aba ina kukulelela bamweya sebeli iyowelisa embuto. ");
INSERT INTO lyn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Cwale injili mbuto sebeli ikwela mu mumbu no kuwaba niku kula wino ni kubeeka omwaanda no etimbuto.” Yo amba ngeeso, sebeli okuweleza nji, “Woyo oli ni matwi no ku yupisa, ayupe!” ");
INSERT INTO lyn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Cwale aiyetwa aye aba ana ku mwibanguta etaluso no nguli eyo, ");
INSERT INTO lyn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","sebeli wamba nji, “Anyi na mubiwi oku limuka etikunutu no mubuso wa Nyambe, kono anjili kame atalusetwa mu tinguli, nji cwale oku mona kame amona kono kayupisisa. ");
INSERT INTO lyn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Cwale enguli kame italusa ngeesi nji, embuto eliywi lya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Embuto ina ku kwela mu ndila okame awo ana yupu eliywi, cwale Diyabulosi aba aiya kame atundisa eliywi ana yupu mu micima yoo nji alese oku pumena ni ku yoyisiwa. ");
INSERT INTO lyn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Embuto eyo ili ba liwee okame awo, aba amana okuyupa eliywi, kame alitambula mu kuwabelelwa, kono kakwite emibisi mi kame alitambula mu nako icana feela, cwale emiliko aba iiya kame akwa. ");
INSERT INTO lyn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mi kweyo ina kwele mu mikona, okame awo ayupa eliywi, kono aba ata mu ndila yoo kame akeshebiswa ni tipilaelo ni ufumu, ni myelembo no mooyo, mi embuya yoo kayiimbi. ");
INSERT INTO lyn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mi kweyo mbuto ili mu mumbu no kuwaba, okame awo ayupa eliywi ni ku litambula muwangu ni mu ku sepahala ni micima no kuwaba, ni ku beeka embuya mu ku tundamena. ");
INSERT INTO lyn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kakwisa omunu otwesa oku monyeka elambi ni kwifukela munji no siwana, simba okwibeeka munji no mumbeta, kono ibeekiwe ba lutala nji omunu aba aingena amone eliseli. ");
INSERT INTO lyn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kakuli kakwisa eso sishweekiwa eso sasi ulwe oku shootolwa, simba esi sili kuuwi sasi ulwe oku limukiwa ni kwiiya ba liseli. ");
INSERT INTO lyn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Cwale mumamele omu muyupela, kakuli woyo okwite eso ali naso, mba beekelwa, kono awo aulwile esinjiili, simba eso apuluka nji kame ali naso mbasi byanguliwa.” ");
INSERT INTO lyn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Cwale inawaye Jesu na inaaye sebeli aiya kwa yonyene, kono kasi ku twesa okukeela ku nyonga yaye, mulibaka no kupula no aanu. ");
INSERT INTO lyn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Cwale Jesu sebeli wambeliwa nji, “Inaowe na inoowe kame aimanine bandee, kame ashukele oukumona.” ");
INSERT INTO lyn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kono Jesu sebeli wamba kwa onyene nji, “Inawange na inaange okame awo ayupa eliywi lya Nyambe niku libelekisa.” ");
INSERT INTO lyn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Eliywaa linjili Jesu sebeli okulonga na iyetwa aye mu wato ni kwamba kwa onyene nji, “Tu lutelenyi mu linjaliya no lisa.” Cwale sebeli afuula. ");
INSERT INTO lyn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Alemine okuluta ngeeso, Jesu sebeli olangana okutela ba tulo. Cwale emebo no lin̄ungwa sebeli iinguka ba lisa, mane sebeli asinga okutika ku meyi mi kame ana kwikala mu utata no kuneneba. ");
INSERT INTO lyn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Aiyetwa sebeli ata kwa Jesu oka mwingula aamba nji, “Molyetu, Molyetu! kame tufa!” Mi Jesu sebeli oinguka ni ku kalimela elin̄ungwa ni mandinda, mi sebeli iimana ni kondoka tuu. ");
INSERT INTO lyn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Cwale Jesu sebeli wamba kwa iyetwa aye nji, “Etumelo yenu ibine?” Mi sebeli acila ni ku komoka nuukwambisa omunjili ku munjili nji, “Anyine cwale wuyu mulume? Nji mane kame alaela emebo ni meyi, mi kame imukuteka!” ");
INSERT INTO lyn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Cwale Jesu na iyetwa aye sebeli aka fuweka mu naha no Magelasenesi, eyo ikubapile ni Galileya. ");
INSERT INTO lyn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Cwale Jesu yosi longoka feela okuta ba likamba, sebeli okwangana ni mulume ona ku tunda mu mulenen̄i osi mebo no kwiiba, ba nako no kuleba kasi kumanganga eikumango mane kasi ku yoyanga mu ndoo, kono mu mayumbelo. ");
INSERT INTO lyn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Cwale omulume woyo aba ana kumona Jesu, sebeli okuweleza ni liywi no kuneneba ni ku mukubamena balubala lwaye ni kwamba niliywi linene nji, “Iikene osaela oku tenda ni mene, Jesu Mwana Nyambe OMWAMBAKANI oli beulu? Kame niku kumbela, olese oku ni yandisa!” ");
INSERT INTO lyn_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kakuli Jesu kame ana ku laela emebo no kwiiba oku tunda mwa woyo mulume. Kakuli mu tinako no kupula kame ina ku katazanga onene, mane kame ana ku babalelwangwa yo nungilwe ni tungongolo, ni yoondo ku makondo, kono kame ana kucola otungongolo, mi emebo no kwiiba sebeli imu twala mu lihalaupa. ");
INSERT INTO lyn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesu cwale sebeli omwibanguta nji, “Tiwe anyine elitina?” Mi sebeli otambula nji, “Time empi,’” kakuli emebo no kupula no kwiiba kame ina ku mwingena. ");
INSERT INTO lyn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Cwale emebo no kwiiba sebeli ikumbela Jesu nji alese okwilaela nji ite mu wina. ");
INSERT INTO lyn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Cwale omulaka no kuneneba no angulube kame ona ku lyelanga ba lilundu, mi cwale emebo no kwiiba sebeli ikumbela Jesu nji iingene mu tingulube, sebeli oipumenena okaingenamo. ");
INSERT INTO lyn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Cwale emebo no kwiiba sebeli itunda ku mulume nukaingena mu tingulube, mi omulaka sebeli witukela mu lin̄ope no lisa ni ku mina ameyi. ");
INSERT INTO lyn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cwale aanu aba ana kumona eyo ina tendahala, sebeli acila nuukabiha etaba eyo mu mulenen̄i ni mu naha. ");
INSERT INTO lyn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Cwale aanu sebeli ata oka mona eyo ina tendahala, mi sebeli aiya kwa Jesu nuukawana omulume ona ku tundisiwa emebo no kwiiba yo ikalile ba makondo a Jesu, yo ku fukile yo ku ketile wino ni tingana taye, cwale sebeli acila. ");
INSERT INTO lyn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Cwale awo ana ku mona eyo sebeli aambela aanu omu ana ku yandisetwa ku mebo no kwiiba nomo ana balisetwe. ");
INSERT INTO lyn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Cwale aanu onje na mu manyonga no naha no Magelesani sebeli akumbela Jesu nji aasiye kakuli kame ana ku lemiwa ku kucila onene, mi sebeli oingena mu wato ni kuuka. ");
INSERT INTO lyn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Omulume woyo ona ku tundisiwa emebo no kwiiba sebeli okumbela Jesu nji ate naye, Kono Jesu sebeli omulukulula nji akutele ni ku mwamba nji, ");
INSERT INTO lyn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ouke ku mundi wowe, mi okaambe einu no kuneneba ana tende Nyambe kwa wene.” Mi woyo mulume sebeli okutela okaamba eyo inene ana tendelwe kwa Jesu mu mulenen̄i monje. ");
INSERT INTO lyn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Cwale Jesu aba ana kuuka, oundi no aanu sebeli omu tambula, kakuli onje kame ana ku mu tatelela. ");
INSERT INTO lyn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Cwale sebeli kwiiya omulume no litina lya Jailasi, omwendisi no ndoo no milapelo, ni ku kwela ku makondo a Jesu, mi sebeli omu kumbela nji ate ku ndoo yaye, ");
INSERT INTO lyn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kakuli kame ana kwikalanga ni mwana mumweya no mukatana, osi myaka likumi ni yiili, mi kame ana kwiikala beebi ni kufa. Cwale Jesu yo seenda, aanu sebeli amuumbelela. ");
INSERT INTO lyn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Cwale omukati ona ku tomanga oweeti no mweeya mu myaka likumi ni yiili, kasi ku twesahala oku balisiwa ku munu, ");
INSERT INTO lyn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","sebeli wiiya munyima ya Jesu, ni kulema ku mungundo no mukanjo waye, mi ababo sebeli obala ku weeti waye no mweeya. ");
INSERT INTO lyn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Cwale Jesu sebeli oibanguta nji, “Anyini ona nileme?” Cwale aanu onje sebeli akana, mi Pitolosi sebeli wamba nji, “Molyange, oundi no aanu akuumbelele, mi kame aku sinanisa.” ");
INSERT INTO lyn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kono Jesu sebeli wamba nji, “Omunjili nani leme, kakuli kame ni lemuha nji amaata anjili naabu mwa mene.” ");
INSERT INTO lyn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Cwale omukati abana kumona nji katwese oukushweeka, sebeli oiya kwa Jesu yo cilile, ni ku mukubamena ni kwamba balubala no aanu eso ana ku mulemena noomo ana balele muwangu-wangu. ");
INSERT INTO lyn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Cwale Jesu sebeli wamba kwa yonyene nji, “Mwanange, etumelo yowe naiku yoyisa. Ote mu kozo.” ");
INSERT INTO lyn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesu yo saamba, sebeli kwiiya omulume ona ku tundelela ku ndoo no mwendisi ni kwamba nji, “Mwanowe nafu, olese oku kataza Omwiyeti.” ");
INSERT INTO lyn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kono Jesu aba ana kuyupa ngeeso, sebeli wambela Jailosi nji, “Olese ku cila, opumene feela, mi mwanowe mba yoyisiwa.” ");
INSERT INTO lyn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Cwale aba ana ku keela ku ndoo, kasi ku pumenena omunu okwingena mu ndoo, konji Pitolosi, ni Jowani, ni Jakobo, sitaye ni inawaye omwanukana. ");
INSERT INTO lyn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Cwale onje aanu kame anaku lilanga ni ku musilisa, kono Jesu sebeli waambela nji, “Mulese kulila, omwanukana kasifa, kono kame alanganine feela!” ");
INSERT INTO lyn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Cwale onje sebeli asheka Jesu, muku limuka nji omwanukana nafu. ");
INSERT INTO lyn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesu sebeli omulema ku lyooko ni ku mwisana nji, “Mwanukana, inguka!” ");
INSERT INTO lyn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Cwale emebo yaye sebeli yukela mwa yonyene, mi ababo omwanukana sebeli oinguka, cwale Jesu sebeli olaela nji omwanukana alukisetwe esi no kulya nji alye. ");
INSERT INTO lyn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Cwale ashemi aye sebeli akomoka, kono Jesu sebeli waalaelela nji alese okwambela omunu eyo ina tendahala. ");
INSERT INTO lyn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Cwale sebeli oisana aiyetwa no kukwana likumi ni twiili bamweya mi sebeli waaba amaata ni tukelo beulu no mandimona onje mane ni ku balisa ameeti. ");
INSERT INTO lyn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Cwale Jesu sebeli waatuma nji akaiyete eino mubuso wa Nyambe mane nuka balisa awo akola ameeti, ");
INSERT INTO lyn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","mi sebeli wamba kwa onyene nji, “Mulese okushimba esinu sinjili ba mwendo, simba olusata, simba esipaupau, simba esinkwa, simba amali, mane mulese okushimba etihembe timbili. ");
INSERT INTO lyn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Endoo yonje mwingena mi kame amitambula, mwikalemo okubitela abo samutunde mu mulenen̄i omo, ");
INSERT INTO lyn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","mi oko konje samwingene nji kamitambula, aba mutunda mu tolopo omo, mutotomone amaluli na kumakondo enu nji atende oupaki kwa onyene.” ");
INSERT INTO lyn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aiyetwa sebeli ata mu mindi yonje aka iyete eliywi ni kubalisa asikutoma ameeti mu ibaka yonje. ");
INSERT INTO lyn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Cwale Heloda, omubusisi abana kuyupa eyo ina kutendahala yonje, sebeli okomoka onene kakuli anjili kame ana kwambanga nji Jowani omukolobezi nainguka kwaafu. ");
INSERT INTO lyn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Anjili kame ana kwambanga nji Eliya wamonahala kale, mi anjili kame ana kwambanga nji omunjili no anuhi a Nyambe nakukale nainguka. ");
INSERT INTO lyn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Heloda sebeli wamba nji, “Jowani woyo nina kupatula omutwi, kono anyine woyo niyupa eyaye?” Mi sebeli osaela okumona Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Atumiwa aba ana kuuka sebeli ambela Jesu einu yonje ana tende. Cwale sebeli washimba ni kuta noo ku mulenen̄i oisaniwa Betisaida. ");
INSERT INTO lyn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Cwale aanu no kupula aba ana kuyupa ngeeso, sebeli amukon̄a mi sebeli waatambula wino ni kwamba kwa onyene eyo no mubuso wa Nyambe mane sebeli obalisa awo ana kusinga okublisiwa. ");
INSERT INTO lyn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Abo eliywaa elita mu kwiika, atumiwa no kukwana elikumi na yiili sebeli aiya kwa Jesu ni kwamba nji, “Ouse aanu nji akutele mu mindi ni mwilalanda monje ili beebi nji aka kusaelele oko sakalangane neso no kulya kakuli muno tuli ni mu sibaka sikushweekile.” ");
INSERT INTO lyn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kono Jesu sebeli wamba kwa onyene nji, “Anyi luli mwaabe eyi no kulya.” Cwale sebeli atambula nji, “Kame tuli feela ni inkwa itanu ni tindi timbili, konji aba satute nji tukaa ulele eino kulya onje. ");
INSERT INTO lyn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Oko kame kuna kwikalanga alume no kukwana eikiti itanu (5;000) Cwale Jesu sebeli wamba kwa iyetwa aye nji, “Mwambele aanu aikale banji mu ikwata akwanine eititi makumi atanu mu sikwata ni sikwata (50).” ");
INSERT INTO lyn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Cwale sebeli atenda ngeeso mane ni kwikala mu ikwata ni kwikala onje banji, ");
INSERT INTO lyn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","cwale Jesu sebeli olonda einkwa itanu ni tindi timbili, sebeli waliketa kuwilu ni kuba etumbo mane ni kwipatola ni kwiiba kwa iyetwa aye nji atabele aanu. ");
INSERT INTO lyn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Cwale onje sebeli alya ni kwikuta, mane sebeli atolabo amatanda no kukwana likumi ni twiili no ubulumusi onaku siyalako. ");
INSERT INTO lyn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cwale Jesu yoli yomboci yolapela aiyetwa sebeli aiya kwa yonyene mi sebeli waibanguta nji, “Kandi aanu kame aamba nji time anyine?” ");
INSERT INTO lyn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mi sebeli atambula nji, “Kame aamba nji tiwe Jowani omukolobezi, aanjili nji tiwe Eliya, mi anjili kame aamba nji omunjili no anuhi naku kale nainguka.” ");
INSERT INTO lyn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Cwale Jesu sebeli waibanguta nji, “Cwale anyi kame mwamba nji time anyine?” Mi Pitolosi sebeli otambula nji, “Tiwe Kilesite wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kono cwale Jesu sebeli waaba emamela nji alese okwambela omunu yonje ");
INSERT INTO lyn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","nji, “Omwana no munu kame afanena okuyanda einu no kupula, mi akaniwe kwa kulu ni kwa kulu no apulisita mane na sikun̄ola, mi aibaiwe mane nji ba liywa no waatu aingulwe kwaafu.” ");
INSERT INTO lyn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Cwale sebeli wamba kwa onyene nji, “Omunu yonje woyo osaela oku nikon̄a akutobohe yonyene mi akutweke esifapano saye mu maywaa onje cwale anikon̄e. ");
INSERT INTO lyn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Abo kwa woyo osaela okuyoyisa omooyo waye mbau taukelwe, mi woyo otaukelwa omooyo waye mulibaka lyange mba yoyisiwa. ");
INSERT INTO lyn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Siikene sawane omunu aba amuna elitunga lyonje, ni kutaukelwa omooyo waye simba okukomiwa? ");
INSERT INTO lyn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Woyo yonje soni enene mane ni maywi ange, ni yonyene Omwana no munu mba mwenene aba saiye mu kanya yaye ni mu kanya ya sitaye neyi no mangeloi no kukena. ");
INSERT INTO lyn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kono kame ni myambela eniti luli nji kwaali anjili aimanine bano awo katamba okufa akasi mona kale omubuso wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Munyima no maywaa atanu naatu Jesu aba ana kumana okwamba eyi sebeli oshimba Pitolosi, Jowani ni Jakobo ni kuta noo ba lilundu okalapela. ");
INSERT INTO lyn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesu yo lapela, sebeli omonahala olutu ni ikumango yaye okufutuka mane sebeli itenda eyi no likena too onene. ");
INSERT INTO lyn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ababo sebeli kumonahala alume ayiili aambola ni Jesu. Awo neli Mushe ni Eliya ");
INSERT INTO lyn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","awo ana kumonahala mu kanya aamba eyi no kuta kwaye eyo ana kufanena oka manenena ku Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Cwale Pitolosi nawo ana kwikala noo kame nalangananga onene ba tolo, cwale aba ana kwinguka sebeli amona ekanya ya Jesu na lume ayiili awo ana kwimananga naye. ");
INSERT INTO lyn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cwale alume aba ana kusiya Jesu, Pitolosi sebeli wamba kwa Jesu nji, “Molyange, nikwakuwaba ngasibine nji twikale feela bano! Tuyake eikun̄wa yaatu, esinjili sitende sowe, esinjili sa Mushe mane esinjili sitende sa Eliya.” Mukwalimuka eso ana kwamba. ");
INSERT INTO lyn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Abo yo amba eyo, sebeli kwiiya elikumbi ni kwafuka, mi sebeli acila aba ana kufukiwa ku likumbi. ");
INSERT INTO lyn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Cwale eliywi sebeli litunda mu likumbi eli lyamba nji, “Wuyu ya Mwanange woyo ni nakete, mumuyupe!” ");
INSERT INTO lyn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Cwale eliywi aba lina kumana okwamba, Jesu sebeli okumona nji kame ali yomboci. Aiyetwa sebeli aondoka feela nambulwa okwambela omunu kweyi ana mono. ");
INSERT INTO lyn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Eliywaa linaku tatamako Jesu na iyetwa aatu aba ana kushetumuka okutunda ba lilundu, cwale aanu no kupula sebeli akuwana ni Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Cwale komumone, omulume sebeli okuwa okutunda mwaanu no kupula nji, “Mwiyeti! Kame ni kukumbela nji oni monene mwanange, kakuli yomwanange nili naye nisepile yomboci! ");
INSERT INTO lyn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Cwale komumone emebo no kwiiba kame imulemanga muwanguwangu ni kulila onene ni kumoowa okutwala abo sakatundele olufulo ku kanwa mane ni kumukwiseta banji yonyakola eyisi mulemine. ");
INSERT INTO lyn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Cwale kame nina kumbele aiyetwa owe nji aitundise kono nakwangwa.” ");
INSERT INTO lyn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesu sebeli otambula nji, “Anyi aanu nakwapumena ni lusika nakwayupa! Ba nako no kukuma babine saniikale naanyi? Ba nako no kukuma babine sani miiyete? Kolite mwanowe kuno.” ");
INSERT INTO lyn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ababo ondumbana yokeyile, emebo no kwiba sebeli ingena mwayonyene okumulyanganisa. Kono Jesu sebeli olaela emebo no kwiiba, sebeli obalisa ondumbana ni kumuba kwa sitaye. ");
INSERT INTO lyn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mi onje kame ana kukomoka amaata no kuneneba a Nyambe. Kono abo aanu asikomokile kweyo yonje anatende, sebeli wamba kwa iyetwa aye nji, ");
INSERT INTO lyn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Muteetete wino ku maywi awo sanambe bano, Omwana no munu mbabeekiwa mu maoko no aanu. ");
INSERT INTO lyn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kono kasi kuyupisisa omwambelo ou, kakuli kame ona kushwekiwa kwa onyene, nji alese okuyupisisa wino mi kame ana kucilanga okumwibanguta etaluso no mwambelo owo. ");
INSERT INTO lyn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Cwale etin̄ananyi sebeli tiinguka mukaci koo nji anyine no kuneneba mukaci koo. ");
INSERT INTO lyn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kono Jesu aba ana kumona emihupulo eli mu micima yoo, sebeli oshimba omwanuke ni kumwimeka kunyonga yaye, ");
INSERT INTO lyn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","cwale sebeli wamba kwa onyene nji, “Woyo yonje sotambula wuyu mwanuke mu litina lyange natambula mene, mi woyo yonje sotambula mene natambula woyo ona nitumu. Mi cwale woyo no mamaneneno mukaci kenu yo munene kwaanyi.” ");
INSERT INTO lyn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jowani sebeli otambula nji, “Molyange, natumono omulume woyo otundisa amandimona mu litina lyowe natu mukanisa, kakuli kasa wetu. ");
INSERT INTO lyn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kono cwale Jesu sebeli wamba kwa yonyene nji, “Mulese okumu kanisa kakuli nji omunu kakulwisi woyo kame ali kwa wene.” ");
INSERT INTO lyn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Cwale amaywaa aba ana kusheeteta abeebi nji atambuliwe ku wilu, sebeli okutukiseta okuta ku Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Cwale sebeli otuma atumiwa balubala mu mundi wisaniwa nji Samalitani nji aka mulukisete einu. ");
INSERT INTO lyn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kono aanu kasiku mutambula kakuli olubala lwaye kame luna kulukisetwa okuta ku Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mi cwale aiyetwa aye Jakobo ni Jowani aba ana kumona ngeeso, sebeli aamba nji, “Mbumu, kame usinga nji aci tukumbele omulilo okutunda ku wilu nji wiiye mukwa cin̄a? ");
INSERT INTO lyn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kono Jesu sebeli ofutuka ni kwakalimela. ");
INSERT INTO lyn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Cwale sebeli aekeza okuta mu mundi munjili. ");
INSERT INTO lyn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Cwale akatile ngeseo mu mweendo woo, omulume munjili sebeli wamba kwa Jesu nji, “Kame sani kukon̄e oko konje soote.” ");
INSERT INTO lyn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Cwale Jesu sebeli wamba kwa yonyene nji, “Aluwawa kame akwite emina, mi otuyunyi oto tutuka mu mebo kame tukwite eiyaleto, kono Omwana no munu kakwite naba no kusama omutwi waye.” ");
INSERT INTO lyn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ku munjili sebeli wamba nji, “Onikon̄e.” Kono sebeli wamba nji, “Mbumu oweli nite nika pumbeke sitange.” ");
INSERT INTO lyn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Cwale Jesu sebeli otambula nji, “Mulesele aafu apumbeke aafu oo, cwale kono wene ote oka iyete eyi no mubuso wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kame omunjili kwa onyene sebeli wambela Jesu nji, “Mbi kukon̄o, kono oweli nite nikalaane asi ndoo yange.” ");
INSERT INTO lyn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesu sebeli wamba kwa yonyene nji, “Kakwisa omunu olemine ku sikekele ni kwaliketa kunyima woyo kafanene mu mubuso wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Munyima noeyi, Ombumu sebeli oketa ano kukwana makumi atanu nayili naanu ayiili, mane ni kwatuma balubala lwaye ayiili mu milenen̄i yonje ni mu sibaka eso afanena yonyene okuta. ");
INSERT INTO lyn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Cwale sebeli wamba kwa onyene nji, “Kame kuli ekutulo inene kono asi kuyangula acana, mulapele nji Ombumu no kuyangula atume asikuyangula mu iyangulo yaye. ");
INSERT INTO lyn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mute cwale! Komumone kame ni mituma kanyi emikoko mukaci no andiwi. ");
INSERT INTO lyn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mulese okushimba esikwama no mali, simba esipaupau, simba etinjatangwa mi mulese kwimana nji mukeete omunu mu ndila. ");
INSERT INTO lyn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Endoo samwingene yonje, oweli mwambe nji, ‘Ekozo iikale mu ndoo muno.’ ");
INSERT INTO lyn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Cwale nji omunu woyo osinga ekozo mwaali mwa onyene cwale ekozo yenu mbaiikala noo, kono nji kasamo ekozo yenu mbayuuku kwaanyi. ");
INSERT INTO lyn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cwale mwikale mu ndoo eyo mulye mane ni kunwa eyo samubiwe kakuli omubeleki kame afanena okubiwa okutenikiwa kwaye, mulese kuta endoo ni ndoo. ");
INSERT INTO lyn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Aba mwingena mu tolopo mi kame amitambula, mulye eso samubiwe, ");
INSERT INTO lyn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","mubalise asikutoma omo mu ndoo mi mwambe kwa onyene nji, ‘ Omubuso wa Nyambe nawiyi abeebi kwaanyi.’ ");
INSERT INTO lyn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kono aba mwingena mu tolopo nji kamitambula, mute mu mikwakwa yayo mi mwambe nji, ");
INSERT INTO lyn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Simba eliluli na mu tolopo yenu elyo lina kakatele ku tinjatangwa tetu, kame tumi totomonena lyo, kono cwale mulimuke nji omubuso wa Nyambe nawiyi abeebi!’ ");
INSERT INTO lyn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kame nimyambela nji, ba liywaa no katulo, Nyambe mba monisa esishemo ku mulenen̄i no Sodoma okubita etolopo iya! ");
INSERT INTO lyn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Oumai niwenu Asikolazini! Oumai niwenu kame asi Besesaida! Abo kambe etimakazo tina kutendiwa mwaanyi kambe nati kutendiwa mu Tile ni Sidoni, kambe naakubaka kale mane ni kukumanga eikumango no masaka ni kulangana ba mute! ");
INSERT INTO lyn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kono Nyambe mba monisa esishemo onene mu katulo no Tile ni Sidoni okubita aanyi. ");
INSERT INTO lyn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mane ni wene Kapenauma kame solumbekwe ku wilu? mbu kwisetwe banji mu lyangalilo. ");
INSERT INTO lyn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Cwale omunu yonje woyo omiyupa kame ayupa mene, mi kame woyo omikana kame akana mene, mi woyo okana mene kame akana ni woyo ona nitumu.” ");
INSERT INTO lyn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ano kukwana makumi atanu na yiili naanu ayiili sebeli akauka awabelelwe onene, ni kwambela Jesu nji, “Mbumu, simba amadimona kame atuyupa aba twa kalimela mu litina lyowe!” ");
INSERT INTO lyn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Cwale Jesu sebeli wamba kwa onyene nji, “Kame nina mono Satani yokwa okutunda ku wilu kanyi olumonyi no mbula. ");
INSERT INTO lyn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Komumone! Kame nina mibi amaata no kwenda ba tinyoka ni tubanse, mane ni maata onje beulu no ila, mi cwale kakwisa eso sasi milemeke. ");
INSERT INTO lyn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kono simba kuli ngeeso mulese kuwabelelwa mwesi nji abo emebo kame imiyupa, kono muwabelelwe nji amatina enu nan̄oliwa mu wilu.” ");
INSERT INTO lyn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mu hola eyeyo luli Jesu sebeli owabelelwa mu Mebo No Kukena ni kwamba nji, “Kame ni kutumela kwa wene Sitange, Ombumu no liwilu ni litunga, kakuli namushweeke eyi inu kwawo no kushangama na sikukwiyeta mi namwi shootwele anuke acana. Eee, Sitange, kakuli mona kusingela nji kutendahalele. ");
INSERT INTO lyn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Einu yonje nai kubiwa kwa mene okutunda kwa Sitange. Mi kakwisa woyo olimukile Omwana konji Sitaye, simba woyo olimukile Sitaye konji Omwana, simba awo anakete Omwana okwaa shotwela Sitaye.” ");
INSERT INTO lyn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Cwale Jesu sebeli osiulukela kwa iyetwa aye kunyonga ni kwamba nji, “Embuyoti niyawo amiyo awo amona eyi mumona! ");
INSERT INTO lyn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kono kame nimyambela nji, Anuhi no kupula na mbumu nashukele okumona eyi mumona, kono kasiimona, mane ni kuyupa eyi muyupa, kono kasiiyupa. ");
INSERT INTO lyn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Cwale komumone! omwiyeti no mulawo sebeli oimana ni kweteka okulema Jesu mukwamba nji, “Mwiyeti,” ngasibine sanitende nji nikaingene mu mooyo no kwaabwa? ");
INSERT INTO lyn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Cwale Jesu sebeli omutambula nji, “Siikene sin̄olilwe mu mulawo? Ngasibine mubalanga?” ");
INSERT INTO lyn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Cwale sebeli otambula nji, “Osinge Mbumu, Nyambe wowe ni mucima wowe wonje, ni mooyo wowe wonje, ni maata owe onje, ni tingana towe tonje, mi osinge awo oyakile noo kanyi omo okusingela wenyene.” ");
INSERT INTO lyn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Cwale Jesu sebeli wamba kwa yonyene nji, “Nwaamba eniti,” “Otende ngeeso mi mbuyoyo.” ");
INSERT INTO lyn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kono yonyene omulume woyo nakushukela oukukenisa yonyene sebeli wambela Jesu nji, “Anyine woyo ni yakile naye kunyonga?” ");
INSERT INTO lyn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesu sebeli otambula nji, “Omulume kame ana kuta ku Jeliko okutunda ku Jelusalema, mi ababo sebeli okuwana na mbuyi sebeli amubyangula eikumango ni kumufula mane sebeli akutela okumusiya yo langanine mu mandingwe no lifu. ");
INSERT INTO lyn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Cwale omupulisita sebeli obita endila eyo, mi aba naku mumona sebeli oyauka ni kumusiya. ");
INSERT INTO lyn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mu mukwa mumweya owo, omulebi ni yonyene sebeli obita endila eyo mi sebeli omumona mi ni yonyene sebeli oyauka ni kumubitelela. ");
INSERT INTO lyn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kono Omusamaliya yo enda mu ndila eyo sebeli okeela abo ana kwikala omulume woyo ona kulemekiwa, aba ana kumumona omo aikalele, sebeli omufela amakeke. ");
INSERT INTO lyn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Seli osheeteta kwa yonyene ni kwitela amaati ni waine ba itombo yaye mane ni kunungabo, mi sebeli omubeeka ba mbongolo yaye mane ni kumutwala ku ndoo no angenda oko ano kamu babalela. ");
INSERT INTO lyn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Cwale eliywaa lina kutatamako sebeli olita amali no muwayawaya no silibela, ni kwaaba kwa babaleli ni kwamba nji, ‘Mubabalele wuyu munu, mi mbi miteneke kweyo samu sinyehelwe aba saniuke oku nikatile.’” ");
INSERT INTO lyn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Cwale Jesu sebeli omana mukwamba nji, “Anyine mu waatu woo, woyo ona monisa nji mwabaye woyo mulume onaku fuliwa kwa mbuyi?” ");
INSERT INTO lyn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Omwiyeti no mulawo sebeli otambula nji, “Woyo ona monisa amakeke kwa yonyene.” mi Jesu sebeli wamba kwa yonyene nji, “Ote mi okatende ngeeso.” ");
INSERT INTO lyn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Cwale ababo Jesu na iyetwa aye aba ana kutaanga mu ndila yoo, sebeli aingena mu mundi omunjili mi omukati oisaniwa Maleta sebeli omutambula mu ndoo yaye. ");
INSERT INTO lyn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Cwale kame ana kwikalanga ni minaye no litina lya Maliya woyo ona kwikala ku makondo a Mbumu okuteeteta ku kutazo yaye. ");
INSERT INTO lyn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kono Maleta yonyene kame ana kupatehanga okulukisa eyi no kulya, cwale sebeli ota kwa Jesu oka mwambela nji, “Mbumu, kumwine nji Maliya nanisiyi memboci okulukisa eyi no kulya? Omwambele nji aiye anituse!” ");
INSERT INTO lyn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kono Ombumu sebeli omutambula nji, “Maleta, Maleta! Kame unyolelwe ni kushupiwa kwiinu no kupula, ");
INSERT INTO lyn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","esinu simweya kame sisaeliwa. Maliya nakete esinu simweya no kuwaba eso kasitamba kubyanguliwa kwa yonyene.” ");
INSERT INTO lyn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kame ana kulapelelanga mu sibaka sinjili, mi aba ana kumana, omunjili no aiyetwa aye sebeli wamba kwa yonyene nji, “Mbumu, otwiyete okulapela kanyi Jowani aba ana kwiyeta aiyetwa aye.” ");
INSERT INTO lyn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Cwale Jesu sebeli waambela nji, “Aba mulapela, mwambe nji, ‘Sitetu, elitina lyowe liikale eli no kukena, kwiiye omubuso wowe. ");
INSERT INTO lyn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Otube balelo esilyanu setu omo otubelanga mu liywaa ni liywaa. ");
INSERT INTO lyn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Otu lemene emibonda yetu kanyi omo tulemenanga akwetu awo atu foseza. Ole kutu leselela okwingena mu miliko.’” ");
INSERT INTO lyn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Cwale sebeli wamba kwa onyene nji, “Anyine kwaanyi woyo otwesa okuta kwa mulikani waye bakaci no usiku nuka mwambela nji, ‘Mulikani, onibeko einkwa yaatu. ");
INSERT INTO lyn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Omulikani wange naiyi mi sikwite esi no kumuyumbula. ");
INSERT INTO lyn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Cwale kame satambule yoli mukaci nji, ‘Ole kunikataza esaandi nasi yatiliwa kale, mene na naange twalangana kale mi sitwese okwinguka okukuba eso osaela.’ ");
INSERT INTO lyn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kame nimyambela nji, simba nji katamba okwiinguka okumuba eso asaela kakuli mulikani waye, kono mbainguka mane nikukuba eyo asaela yonje kakuli kaene okutwalelela okukumbela. ");
INSERT INTO lyn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Cwale kame nimyambela nji, mukumbele mi mba mubiwi, musaele mi mba muwana, mungongote mi mba muyatulelwa. ");
INSERT INTO lyn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwa woyo yonje okumbela mba biwi, woyo osaela mbawana mi woyo ongongota mba yatulelwa. ");
INSERT INTO lyn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Anyine omushemi mukaci kenu, nji mwanaye kame akumbela ondi, kana kame atwesa okumuba enyoka okubita ondi? ");
INSERT INTO lyn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Simba nji kame akumbela eliki kame otwesa okumuba esoowa? ");
INSERT INTO lyn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Cwale nji anyi no kwiiba mulimukile okuba anenu eyi no kuwaba aba amikumbela, cwale mbakwikala ngasibine kwa Sitetu nakuwilu kwawo amukumbela Emebo No Kukena!” ");
INSERT INTO lyn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Cwale Jesu kame ana kutundisanga esidimona no umumu, cwale esindimona aba sina kutunda, omulume no simumu sebeli otateka okwamba mi aanu sebeli akomoka, ");
INSERT INTO lyn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","kono aanu anjili sebeli aamba nji, “Kame atundisa amadimona mulibaka lya Beluzibule, omukulu no madimona.” ");
INSERT INTO lyn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Cwale anjili sebeli amweteka muku kumbela esisupo okutunda kuwilu. ");
INSERT INTO lyn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kono Jesu sebeli olimuka eyo ana nahananga, sebeli wamba kwa onyene nji, “Omubuso wonje owo okutabile wonyene, kame osinyeha, mi nji endoo kame ikutaba bakaci kame ikwa. ");
INSERT INTO lyn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mi cwale nji Satani kame akutabile yonyene, ngasibine sawongolele omubuso waye? Anyi kame mwamba nji kame nitundisa amadimona mulibaka lya Beluzibule. ");
INSERT INTO lyn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mi nji kame nitundisa amadimona mulibaka lya Beuzibule, cwale anenu kame tundisanga amadimona mulibaka lyaanyine? Abo cwale mbatende aatuli enu. ");
INSERT INTO lyn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kono nji ni mulibaka no munwe wa Nyambe aba nitundisa amadimona, cwale omubuso wa Nyambe nawiyi kwaanyi. ");
INSERT INTO lyn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Cwale omulume no koongola okutukisete okumamela endoo yaye, eibyana yaye mbaikala mu kozo. ");
INSERT INTO lyn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kono cwale nji omulume no koongola okumubita aba aiya niku mukoma, kame atundisa eilwiso yaye eyo asepile ni kutaba oufumu waye. ");
INSERT INTO lyn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Woyo kasa kwa mene kame anilwisa, mi nji omunu kakuwana ni mene kame ashandola. ");
INSERT INTO lyn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Cwale emebo no kwakena aba ina tundu ku munu, kame ibita mu ibaka nambulwa meyi okusaela esibaka no kwikala. Nji kaiwana cwale kame yamba nji, ‘Mbiuku mu ndoo yange omo nina tundu ni kayoyemo.’ ");
INSERT INTO lyn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cwale aba iiya sebeli iwana nji nai fiyeliwa ni kubeeka einu wino. ");
INSERT INTO lyn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Cwale kame ita okashimba kame injili no kwiiba okubita ni yonyene no kukwana itanu ni yiili, mi kame iiya ni kuyoya mo. Cwale aba iyoya mo yonje omwikalelo wa woyo munu kame sawiibe onene okubita ba weli.” ");
INSERT INTO lyn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesu aba ana kwambanga ngeeso, omukati sebeli otumuka mukaci no aanu yokuweleza ni liywi no kuneneba ni kwamba nji, “Embuyoti niya lipumo elyo linaku kuleya mane ni maele owo ona kuyamwa!” ");
INSERT INTO lyn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kono Jesu sebeli wamba nji, “Embuyoti cwale niyawo ayupa eliywi lya Nyambe ni kuliteula!” ");
INSERT INTO lyn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Cwale oundi no aanu aba ona kwekezeha, sebeli otateka okwamba nji, “Olusika olu nilwa kwiiba, kame akumbele emakazo kono kakwisa emakazo saibiwe kwa onyene konji feela emakazo ya Jonasi. ");
INSERT INTO lyn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kanyi Jona omo ana kutendela emakazo kwaanu a Nenibe, cwale ni Mwana no munu mba tende emakazo ku lusika olu. ");
INSERT INTO lyn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ombumu no mukati naku mutulo mba imana ba katulo na lume no lusika olu nik wanyaza, kakuli kame ana kutunda ku mamaneneno no litunga mukuteeteta okushangama kwa Solomoni, mi komumone esinjili no kubitelela Solomoni sino sokame. ");
INSERT INTO lyn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Alume no Nenibe mba inguka ba katulo ni lusika olu ni kulunyaza, kakuli nakubaka ba kutazo ya Jonasi, mi cwale komumone esinu no kuneneba okubitelela Jona sino sokame. ");
INSERT INTO lyn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kakwisa omunu woyo otumbula elambi ni kwibeeka munji no tafule simba okwishweeka, kono kame aibeeka beulu nji cwale awo aingena amone eliseli. ");
INSERT INTO lyn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Amiyo enu eliseli no lutu lwenu, cwale amiyo enu nji kame amona wino, olutu lwenu lonje kame lwiyalile eliseli kono cwale nji amiyo enu kamono wino, olutu lwenu kame lwiyalile ouwi. ");
INSERT INTO lyn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Cwalehe mumamele nji eliseli lyenu lilese okufutuka ouwi. ");
INSERT INTO lyn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nji cwale olutu lwenu lonje kame lwiyalile eliseli mi kalukwite esilama no uwi, kame salubenye kanyi abo elambi aba iba eliseli.” ");
INSERT INTO lyn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ababo yo sambola, Omulume no Mufalisi sebeli omukumbela nji alye naye, abo sebeli oingena nukekala ku tafule. ");
INSERT INTO lyn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Omufalisi sebeli okomoka onene okumona nji Jesu kasiku kuyowa ku makaa aye yokasilya kale. ");
INSERT INTO lyn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Abo Ombumu sebeli wamba kwa yonyene nji, “Cwale bano, anyi Afalisi kame muyowisa bandee no komoki yenu ni siwana, kono mukaci kenu kame kwiyalile ouyi ni ufokoli. ");
INSERT INTO lyn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Anyi aelo! Kasa nji Nyambe woyo ona kuumba bandee yona kutenda ni mukaci kame? ");
INSERT INTO lyn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kono mube awo ashebile eyo inu ili mukaci, cwale komumone, einu yonje yakukena kwaanyi. ");
INSERT INTO lyn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kono oumai niwenu Afalisi! Kakuli kame muba Nyambe esino likumi eso no Minta ni Lue ni miloho yonye ni kusheununa eniti ni lilato lya Nyambe eyi yamuna kufanena okutenda okuulwile okusheununa akwenu. ");
INSERT INTO lyn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Oumai ni wenu Afalisi! Kakuli kame musinga eipula no utokwa mu tindoo no milapelo mane ni kuba elikute mu ibaka no misika. ");
INSERT INTO lyn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Oumai ni wenu! Kakuli kame mukufekile kanyi amayumbelo no kwamoniwa mi aanu kame aenda beulu wawo nambulwa kulimukiwa. ");
INSERT INTO lyn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Omunjili no mwimaneni no mulawo sebeli otambula nji, “Mwiyeti, mu kwamba ngeeso kame otwangula kame!” ");
INSERT INTO lyn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Cwale Jesu sebeli wamba nji, “Oumayi ni wenu aimaneni no mulawo! Kakuli kame mushimbisa aanu ashimbo no kulema kono aanyi kame mukwangwa okushimba emishimbo yenu simba ni minwe. ");
INSERT INTO lyn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Oumai ni wenu! Kakuli kame muyaka amayumbelo no anuhi a Nyambe awo ana kwibaiwa kwa njekulyenu. ");
INSERT INTO lyn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Abo kame muli apaki naikaleli ku tikezo ta njekulyenu, kakuli naakwaibaa mi anyi kame muyaka amayumbelo oo. ");
INSERT INTO lyn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Abo cwale kame okushangama kwa Nyambe kame kwamba nji, ‘Mbi atumene anuhi ni atumiwa, anjili kwa onyene mbaa ibaa mane ni kwayandisa.’ ");
INSERT INTO lyn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Abo cwale olusika olu mba lubalelwe emibonda no ashemi oo no kwibaa anuhi okutunda ku matatekelo no litunga, ");
INSERT INTO lyn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","okutunda ku unyinga wa Abele okutwala ku unyinga wa Zakaliya, woyo ona kwibaelwa mukaci no aletale ni sibaka no kukena. Eee kame nimyambela nji olusika olu mba lubalelwe emibonda eyi yonje. ");
INSERT INTO lyn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Oumai ni wenu aimaneni no mulawo kakuli namushimbi etinotolo no tingana. Kamusi kwingenamo kono kame muna kukwangwesa awo ana kusinga okwingenamo!” ");
INSERT INTO lyn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Abo Jesu yositunda abo, aiyeti no mulawo na Falisi sebeli amukandimeka ni kumutinisa nji aambe einu no kupula, ");
INSERT INTO lyn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","okumu tatelela nji aleme einu saambe. ");
INSERT INTO lyn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mu nako icana abo aanu no kukwana eikiti no lule aba anoukuwana bamweya akulyatangela omunjili ku munjili, Jesu sebeli otateka okwamba kwa iyetwa aye oweli nji, “Mumamele omumena no Afalisi, owo oli asikukuba. ");
INSERT INTO lyn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kakwisa eso sifukilwe eso sasiulwe okumonahala, simba eso sishweekilwe sasiulwe okulimukiwa. ");
INSERT INTO lyn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Cwalehe eso sonje munaamba mu uwi mba siyupiwa mu liseli, mane neso muna obo ku kuuwi mu musiyo mba sambiwa beulu no ndoo. ");
INSERT INTO lyn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Abaange kame nimyambela nji, mulese okucila woyo oibaa olutu, kono munyima katwese okutenda esinjili kame. ");
INSERT INTO lyn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kono mbi milemusa woyo mufanena okucila. Mucile woyo munyima no kwibaa kakuli kame akwite amaata no kumi kondela mu lyangalilo. Eee kame ni myambela nji mumucile! ");
INSERT INTO lyn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kana kasa nji otutaha atanu kame tuuliwa etipene timbili? Mi kakwisa simba kamweya ako katwesiwa okupulamiwa kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ngasibine cwale nji simba etin̄uki tenu naku mutwi wenu tonje titwesiwa okubaiwa. Cwale mulese kucila, anyi kame muli ano utokwa onene okubita otutaha no kupula. ");
INSERT INTO lyn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Cwale kame nimyambela nji, omunu yonje woyo sotambula mene balubala no aanu, Omwana no munu niyonyene mbaka mutambula balubala no mangeloi a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kono omunu yonje oni kana balubala no aanu, mbaka kaniwa niyonyene balubala no mangeloi a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mi omunu yonje woyo wamba eliywi okulwisa Omwana no munu mba lemenwe, kono woyo so nyefula ba Mebo No Kukena katamba kulemenwa. ");
INSERT INTO lyn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Cwale aba amilita balubala no tindoo no milapelo, simba kwabusisi ni kwasi milawo, mulese kubilaela kweso sa mutambule simba eso samwambe. ");
INSERT INTO lyn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kakuli Emebo No Kukena mbai miiyete eyo mufanena okwamba ba nako eyeyo.” ");
INSERT INTO lyn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Omunjili kwawo no kupula sebeli wamba kwa Jesu nji, “Mwiyeti, wambele mukulwange nji tukutabele oufumu ana kusiya ashemi etu.” ");
INSERT INTO lyn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kono Jesu sebeli wamba kwa yonyene nji, “Mulume, anyine ona nitende omwatuli simba omutabi mwaanyi?” ");
INSERT INTO lyn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Cwale Jesu sebeli wamba kwa onyene onje nji, “Mutokomele mi mukubabalele mu titakazo no ufumu kakuli omooyo no munu aukutingile feela ba sifumu saye.” ");
INSERT INTO lyn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Cwale sebeli waambela enguli nji, “Omumbu no mulume no kufuma kame ona kumulitela esifumu no kupula. ");
INSERT INTO lyn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mi sebeli onahana yonyene nji, ‘Cwale iikene sani tende, kakuli sikwite omo no kutewela etimbuto tange? ");
INSERT INTO lyn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Cwale sebeli wamba nji, ‘Kame sani shandole eishete yange ni kuyaka eyino kuneneba mane nibeekemo embuto ni ibyana yange. ");
INSERT INTO lyn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mi mbi aamba ku Mooyo wange nji, mooyo, kame ukwite oufumu no kupula ubeekelwe ba myaka no kupula, okukete mu mooyo, olye, onwe mi owabelelwe!’ ");
INSERT INTO lyn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kono Nyambe sebeli wamba kwa yonyene nji, ‘Wene omwelo! Ouno ousiku omooyo wowe mba utundisiwamo mwa wene. Cwale eyo ona kutukisete yaanyine?’ ” ");
INSERT INTO lyn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Cwale kame kukufekile kanyi omunu woyo oli ni ufumu waye , kono cwale kasifuma ba miyo a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesu sebeli wamba kwa iyetwa aye nji, “Cwalehe kame nimyambela nji mulese kubilaela kweyi no mooyo wenu, eso sa mulye simba olutu lwenu eso samukumange. ");
INSERT INTO lyn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kakuli omooyo niwa utokwa okubita esilya, mane ni lutu nilwa utokwa okubita eikumango. ");
INSERT INTO lyn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kamumone aman̄walala, kakunu mane ni kuyangula, kakwite endoo noku tewela simba esishete, kono cwale Nyambe kame aababalela. Cwale anyi kame muli ano utokwa okubita otuyunyi! ");
INSERT INTO lyn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Cwale anyine mwaanyi mukubilaela woyo otwesa okwekeza ku nako yaye no kuyoya? ");
INSERT INTO lyn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nji cwale kutwese okutenda ngeeso kusinu simba sinyonyo, iikene aba obilaela kwiinu yonje? ");
INSERT INTO lyn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Komumone amapalisa omo akulela, katingi owanda simba okutenda eikumango. Kono cwale kame nimyambela, simba Solomoni mu kanya yaye yonje kasiku kufuka kanyi imweya no tipalisa eti. ");
INSERT INTO lyn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kono nji cwale Nyambe kame afuka omoopu owo uyoya mu litema balelo mi byuunda kame uyumbeliwa mu mulilo okuucin̄a, cwale anyi tunjinga samifuke. Anyi alume no tumelo icana! ");
INSERT INTO lyn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Cwale mulese kusaela eyi samulye neyi samunwe simba okubilaela mu minahano. ");
INSERT INTO lyn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kakuli aanu onje namu litunga kame asaelanga einu eyi, mi Sitenu kame alimukile nji kame mwisaela. ");
INSERT INTO lyn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kono musaele oweli Omubuso waye mi cwale einu yonje eyi mba itende yenu. ");
INSERT INTO lyn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Anyi omutapi mucana, mulese kucila, kakuli Sitenu naku wilu kame awabelelwe okumiba Omubuso. ");
INSERT INTO lyn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Muulise oufumu wenu wonje mi mutabele nawo ashebile, mi mukuunganyekele oufumu owo nakwa kulubala, ni ufumu naku wilu owo nakwa kwangwa, oko kakwisa ombuyi so wiita mane kakwisa ni munu sou sinya. ");
INSERT INTO lyn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kakuli oko kuli oufumu wowe ni mucima wowe kooli. ");
INSERT INTO lyn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mukutukisete mi etilambi tenu ti tumbuke. ");
INSERT INTO lyn_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Cwale mufeke kanyi alume atatelele omolyoo okutunda ku mukiti no likwala. Nji cwale atwese oku muyatulwela aba saiiye mukungongota. ");
INSERT INTO lyn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Embuyoti niyawo abika sawaniwe kwa molyoo atona aba saiiye. Niti luli kame nimyambela nji, mba kunungu ni kwaikata ba tafule mane mbaiyi kwa onyene mukwabelekela. ");
INSERT INTO lyn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nji aba aiya akano wiili simba aka no waatu nikwawana asitona ngeeso, embuyoti niyoo awo abika! ");
INSERT INTO lyn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kono mulimuke eyi, kambe omunya ndoo nakulimuka enako ana kwiiya ombuyi, kambe kasi kusiya endoo yaye nji aitemo. ");
INSERT INTO lyn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Naanyi mutatelele ngeeso kakuli Omwana no munu kame akeile mu nako no kwalimikiwa.” ");
INSERT INTO lyn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Cwale Pitolosi sebeli oibanguta nji, “Mbumu, enguli eyi kame oyambela aci nji kwanu onje?” ");
INSERT INTO lyn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Cwale Ombumu sebeli wamba nji, “Anyine cwale omubika no kusepahala ni kushangama woyo ombumu waye mbamubeeke ba ndoo yaye ni kumuba esemba saye no ilya ba nako no kufanena. ");
INSERT INTO lyn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Embuyoti niya woyo omubika nji ombumu waye aba sauke mba muwana yotenda eyo ana ku musiyele nji atende. ");
INSERT INTO lyn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Niti luli kame nimyambela nji, ombumu mba mubeeke okumamela esifumu saye sonje. ");
INSERT INTO lyn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kono cwale nji omubika woyo amba yonyene nji omolyange naliyehe okwiiya, ni kutateka okufula abika no alume naakati ni kulya ni kunwa mane ni kukoliwa, ");
INSERT INTO lyn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","cwale molyaye aba saiye ba liywaa elyo no kwalimukiwa nji kame aiya ba nako nokwa limukiwa kame samube omubonda bamweya nawo no kwasepahala. ");
INSERT INTO lyn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Cwale omubika woyo ona kulimuka eso asaela molyaye, kono kasiku tukiseta mane nikutenda okukumanena nomo asingela molyaye mba shapiwa onene. ");
INSERT INTO lyn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kono woyo omubika ona kuulwa okulimuka kono sebeli otenda mukucila okufuliwa kame safuliwe kanyonyo. Omunu yonje ona biwi onene kwa yonyene mbaku saeliwa onene kwa yonyene. Cwale woyo ona siyeliwa einu no kupula kame saku saeliwe onene kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Kame nineyi muku beeka omulilo ba litunga, cwale iikene nisi saela kame omulilo owatumbuka kale! ");
INSERT INTO lyn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kame nili ni kolobezo eyo nifanena okukolobezwa nayo, cwale kame nishukelwe nji itendahale! ");
INSERT INTO lyn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kame muyambuta nji kame nineyi okulita ekozo bano ba litunga? Kokuulwa, kasa ekozo kono etifapahano. ");
INSERT INTO lyn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kakuli okutunda bano mu ndoo imweya kame sakutabe atanu, aatu kame salwise ayiili mane ayiili kame salwise aatu. ");
INSERT INTO lyn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kame sakwikale oukutaba omushemi no mulume mba kulwisa ni mwanaye no ndumbana mane omushemi no mukati mba kulwisi ni mwanaye no mukatana, onjemunwa no mukati mba kulwisi ni njemunwaye no mukati.” ");
INSERT INTO lyn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesu sebeli wamba kame kwaanu no kupula nji, “Aba mumona elikumbi eliyaluka okutunda mu wiko, mwambe bamweya nji ombula mbaloko, mi kame kutendahala ngeeso. ");
INSERT INTO lyn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Cwale aba mumona emebo namu mbowela aba ifuka, kame mwambanga nji mbakwikala okwenya onene, mi kame kutendahala ngeeso. ");
INSERT INTO lyn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Anyi asikukuba! kame mutwesa okutoloka omo limonahalela elitunga ni liwilu, kono cwale iikene aba kamwatwese okutoloka eyi itendahala ba nako ino? ");
INSERT INTO lyn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Cwale iikene aba mukwangwa oukuketa mwenyene okutenda eino kuluka? ");
INSERT INTO lyn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nji kame mukutwala ku kuta ni woyo ona foseze balubala no mwatuli, mweteke oukweleza mwenyene mu ndila yokasiku kutwala kale baubala no mwatuli mi omwatuli mba kubeeke mu maata no mubeleki no muuso mi omubeleki no muuso kame sakutwale ku tolongo. ");
INSERT INTO lyn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kame nikwambela nji kutamba kutunda mo konji aba sotenekelele omubonda no mamaneneno.” ");
INSERT INTO lyn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ba nako eyo kame kuna kwikalanga aanu awo ana kwambela Jesu eyi no Magalileya awo ounyinga woo Piloto kame ana kuwaneka ni matabelo. ");
INSERT INTO lyn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Cwale Jesu sebeli watambula nji, “Anyi kame munahana nji Amangalileya aa ana kutenda esibi esinene okubita Amangalileya onje, mulibaka lya eyo ina kutendahala kwa onyene? ");
INSERT INTO lyn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kame ni myambela nji, kokuulwa, kono konji aba samubake, monje mba mufi kanyi onyene omo ana kufela. ");
INSERT INTO lyn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Simba aanu awo no kukwana likumi ni atanu ni twaatu (18) na mu Siloamu ana kukweliwa ku tawala ni kwaaibaa, kame munahana nji onyene ni asikutenda ouyi no kuneneba okubita awo ana kuyoya mu Jelusalema? ");
INSERT INTO lyn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kame nimyambela nji kokuulwa, kono konji aba sa mubake nji kasa ngeseo mba mufi moonje kanyi onyene.” ");
INSERT INTO lyn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Cwale Jesu sebeli waambela enguli eyi nji, “Omulume kame ana kwikalanga ni sitondo no feiga eso ana kukuna mu litema lyaye, cwale sebeli ota nji aka shimbeko eilya kono kasi ukawanako simba simweya. ");
INSERT INTO lyn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Cwale sebeli wamba kwa asikubabalela elitema nji, ‘Esitondo esi sebeli myaka yaatu me niiya muku saelako eilya, kono Siwanako cwale bano musiteme feela! Iikene aba sikutusisa feela omumbu?’ ");
INSERT INTO lyn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Cwale osikubabalela elitema sebeli omutambula nji, ‘Musisiye feela mu mwaka uno mumweya nji nitomboleko nji mane ni beekeko omununo, ");
INSERT INTO lyn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mi cwale nji mbasibeeke embuya omwaka wiiya kwakuwaba, kono cwale nji kasitamba kubeeka okubinda satu sipatule.’ ” ");
INSERT INTO lyn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Cwale Jesu kame ana kwiyetanga mu ndoo injili no milapelo ba liywaa no Pumulo. ");
INSERT INTO lyn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mukaci kame kuna kwikalanga omukati no siyanga ba myaka no kukwana likumi ni atanu ni twaatu (18), kame anaku kupunganga mane kasi kutwesanga okooloka. ");
INSERT INTO lyn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Cwale Jesu aba ana kumumona sebeli omwisana ni kwamba kwa yonyene nji, “Mukati, nulukululwa ku weeti wowe!” ");
INSERT INTO lyn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Cwale Jesu sebeli obeeka amaoko aye beulu no mukati, mi ababo sebeli ooloka mane sebeli oyeema Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kono omubusisi no ndoo no milapelo sebeli otina onene kakuli Jesu nakubalisa omunu ba liywaa no Pumulo, mi sebeli wamba kwaanu nji, “Kame tuli ni maywaa atanu ni kamweya (6) awo ana pumenenwe okutenda emisebezi, cwale mwiiye mu maywaa awo nji mubalisiwe, cwale kasa ba liywaa no Pumulo!” ");
INSERT INTO lyn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Cwale Ombumu sebeli omutambula nji, “Anyi asikukuba! Kana omunjili kwaanyi nji kame afumine amapulu simba ombongolo katwese oku munungutula ni kumutwala mukunwa ameyi ba liywaa no Pumulo? ");
INSERT INTO lyn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Cwale uno yo mwanaye Abulahama no mukati woyo ona kunungiwa kwa satani ba myaka no kukwana likumi ni itanu ni yaatu (18) cwale katwese okulukululwa mukunungiwa oku ba liywaa no Pumulo?” ");
INSERT INTO lyn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mukwamba ngeeso, eila yaye yonje sebeli yeena, mi aanu onje sebeli awabelelwa kwiinu eyo ana tende Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Cwalehe sebeli wamba nji, “Kana omubuso wa Nyambe kame okufekile niikene? Mi siikene saniubapise ni onyene? ");
INSERT INTO lyn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Cwale kame ukufekile kanyi embuto no Masitete eyo ana shimbi omulume ni kuka kuna mu litema lyaye, mi sebeli ikula ni kutenda esitondo sinene, mi otuyunyi na mu mebo kame tutenda eiyaleto ku mitayi yaso.” ");
INSERT INTO lyn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesu kame sebeli wamba nji, siikene sani bapise ni Mubuso wa Nyambe? ");
INSERT INTO lyn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kame ukufekile kanyi omumena owo ana kushimba omukati nukaushweka mu ipimo yaatu eyi no unga no fulawa konji aba una kumenena wonje.” ");
INSERT INTO lyn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesu sebeli okutela mu milenen̄i ni mu mindi yo iyeta mane ni kwenda emyendo mu Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Cwale omunu munjili sebeli wamba kwa yonyene nji, “Mbumu, kana mba kuyoyisiwa felea aanu anyonyo?” Mi sebeli waatambula nji, ");
INSERT INTO lyn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mweteke omo mutweseta monje okwingena ni mwelo no kukumbana, kame nimyambela kakuli aanu no kupula mba eteke nji aingene kono katamba kutwesa. ");
INSERT INTO lyn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Cwale abo omunya ndoo aba sainguke ni kuyatila emyelo, mba mutateke okwimana ni kungongota ba sandi ni kwamba nji, ‘Mbumu otu yatulwele!’ Cwale yonyene mba tambula nji, ‘Simiyii, kubine mukatundelele!’ ");
INSERT INTO lyn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Cwale mba mutateke okwamba nji, ‘Natu kunwa ni kulya ba lubala lowe, mi nau kwiyetanga mu titolopo tetu!’ ");
INSERT INTO lyn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kono mbaamba kame nji, ‘Kame ni myambela nji siyii oko mutunda kamutunde kwa meene anyi asikutenda ouyi!’ ");
INSERT INTO lyn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Oko mbamu lili ni ku kweca amaeo aba sa mumone Abulahama ni Isaka ni Jakobo mane na nuhi onje mu Mubuso wa Nyambe mi anyi mba muyumbelwe kundee. ");
INSERT INTO lyn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aanu mbaiyi okutunda ku upa ni ku wiko, simba ku mutulo ni ku mbowela okwikala ba tafule mu mubuso wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kamumone, anjili ali balubala mbatende ana munyima, mi aali munyima mbatende ana balubala.” ");
INSERT INTO lyn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ba nako eyeyo, Afalisi anjili sebeli aiya ni kwamba kwa yonyene nji, “Otunde bano kakuli Heloda kame asinga nji aibae wene.” ");
INSERT INTO lyn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Cwale sebeli wamba kwa onyene nji, “Mute mukambele oluwawa olo nji, ‘Kamumone, kame nitundisa amadimona mane ni kutenda etimakazo no kubalisa balelo ni byuunda mane mu liywaa no waatu mbi mana omusebezi wange.’ ");
INSERT INTO lyn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Simba ngeeso kame nifanena okuta mu mweendo wange kakuli kakufanene nji omunuhi wa Nyambe aibaelwe ku ndina okubita mu Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jelusalema, Jelusalema, okwibaa anuhi a Nyambe ni kupwacaula ni mawee awo ana tumiwa kwa wene! Tunjinga ni na kuwaneka anowe kanyi onasikuku woyo owaneka anaye munji no maando aye, kono kawasi nipumenena! ");
INSERT INTO lyn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Komone, endoo yowe kame ikaninwe! Mi kame nikwambela nji, kutamba kunimona konji aba sowambe nji, ‘Embuyoti niya woyo oiya mu litina lya Mbumu!’” ");
INSERT INTO lyn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Eliywaa linjili no Pumulo abo Jesu aba ana kuta mu ndoo no mubusisi no Afalisi okalya esinkwa, onje amwalikete. ");
INSERT INTO lyn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kamumone, sebeli kwiiya kwa yonyene omulume woyo ona kutimbanga amakondo ni makaa. ");
INSERT INTO lyn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Cwale Jesu sebeli wamba kwa simulawo na Falisi nji, “Kana kame kufanena okubalisa eli no Pumulo? ");
INSERT INTO lyn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kono onyene sebeli aondoka feela. Cwale Jesu sebeli oshimba omulume woyo ni kumu balisa mane ni kumu lukulula nji akutele. ");
INSERT INTO lyn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Cwale sebeli wamba kwa onyene nji, “Cwale anyine kwaanyi woyo okwite mwanaye simba opulu waye ona kwele mu wina woyo sokwangwa okumu tundisamo eli no Pumulo?” ");
INSERT INTO lyn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kono kasi kutwesa oku mutambula epuzo yaye eyo. ");
INSERT INTO lyn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Cwale sebeli wambela awo ana kwisaniwa ku mukiti enguli nji, aba ana kumona omo ana kukuketela eibaka no kukutekeha, sebeli wamba kwa onyene nji, ");
INSERT INTO lyn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nji kame ona memiwa ku mukiti no likwala, olese okwikala esipula no kukutekeha. Kakuli kame kutwesahala nji mwendi omunu no utokwa okubita wena ni yonyene namemiwa, ");
INSERT INTO lyn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","mi cwale woyo ona mimeme monje mbaiyi ni kwamba kwaanyi nji, ‘Mube wuyu mulume esipula esi cwale wene mbweene ba kwikala ba sipula no sibaka na kundi. ");
INSERT INTO lyn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kono cwale nji numemiwa, okaikale ba sipula na kunji nji cwale omunya mukiti aba saiye kame saambe kwa wene nji, ‘Mulikani ote okaikale ba sipula na balubala,’ mi cwale mbukutekehe mu miyo aawo aikalile onje ba tafule. ");
INSERT INTO lyn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Cwale omunu yonje woyo oku nuneka mba kokobeziwa, mi woyo oku kokobeza mba nunekiwa. ");
INSERT INTO lyn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Cwale Jesu sebeli wamba ngeeso ku mulume ona kumumema nji, “Cwale aba uba omukushuko simba omulalelo, olese okumema alikani owe, simba abowe, mane simba awo oyakile noo ano kufuma, kakuli nonyene mbaa kumeme eliywaa linjili muku kuuseta mi watenekiwa kale. ");
INSERT INTO lyn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kono cwale aba otenda omukiti, omeme awo ashebile, eiyanga, eihole mane ni ibofu, ");
INSERT INTO lyn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","cwale mukutenda ngeeso mbu fuyauliwa, kakuli katwese oukuuseta. Mi mbu tenekiwa mu niti ba liywaa no kwinguka no aafu.” ");
INSERT INTO lyn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Omunjili kwawo ana kwikala naye ba tafule sebeli oyupa eyi, mi sebeli wamba kwa Jesu nji, “Embuyoti niya woyo sokalya esinkwa mu mubuso wa Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kono Jesu sebeli wamba kwa yonyene nji, “Kame kuna kwikalanga omulume woyo ona kutenda omukiti no kuneneba, mi sebeli omema aanu no kupula. ");
INSERT INTO lyn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Cwale enako no mukiti aba inaku keela sebeli otuma omubika waye okambela awo onje ana kwisaniwa nji, ‘Komwiye cwale einu yonje yaluka kale!’ ");
INSERT INTO lyn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kono cwale onje sebeli atateka okuba amabaka. Woyo no weli sebeli wamba ku mubika nji, ‘Kame nina ulu elitema mi kame nisinga nji nite ni kalimone, kame ni lapela nji munilemene.’ ");
INSERT INTO lyn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Omunjili ni yonyene sebeli wamba nji, ‘Kame nina ulu eipani no mapulu no kukwana itanu mi kame nisinga nji ni kayeteke, cwale muyupe okukumbela kwange.’ ");
INSERT INTO lyn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Omunjili kame sebeli wamba nji, ‘Abano okubinda ni kwate, mulibaka elyo sitwese okwiiya. ");
INSERT INTO lyn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Cwale omubika sebeli oukamo nukambele molyaye. Cwale omolyaye sebeli ofilikana ni kwambela omubika waye nji, ‘Kandi cwale olelube ote mu makululu mane ni misika mi okashimbe ano kusheeba, eiyanga, eihole mane nawo no kwa mona aiye ku mukiti.’ ");
INSERT INTO lyn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Cwale omubika sebeli wamba nji, ‘Molyange eyi ona nambele naitendahala kono kame kusisiyalile esibaka.’ ");
INSERT INTO lyn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Cwale omolyaye sebeli wamba ku mubika waye nji, ‘Ote mu mikwakwa ni mu mikulo okandimeke aanu aiye mukwingena, nji endoo yange iiyale. ");
INSERT INTO lyn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kakuli kame ni kwambela nji kakwisa kwaawo aanu nina kumema oweli awo saiye mukulya ku silya sange!’” ");
INSERT INTO lyn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cwale enyangela sebeli imukon̄a mi Jesu sebeli ofutukela kwaanu ni kwamba nji, ");
INSERT INTO lyn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nji omunu kame aiya kwa mene mi katimbi sitaye, inawaye, mukataye, anaye mane nainaye nakulwaye, ee simba mane ni mooyo waye, katamba kutenda omwiyetwa wange. ");
INSERT INTO lyn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nji omunu yonje kashimbi esifapahano saye ni kuni kon̄a katamba kutenda omwiyetwa wange. ");
INSERT INTO lyn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Cwale anyine mukaci kenu woyo otwesa okuyaka etawala yokasiikala banji nji amone etisinyehelo taye eto satitwese okumana omusebezi waye? ");
INSERT INTO lyn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kono cwale aba abeeka amatatekelo no muyako, mi katwese oku umanenena, awo onje aumona kame atateka oku musheka. ");
INSERT INTO lyn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Mbaamba nji, ‘Wuyu mulume nakutateka okuyaka kono kame ana kwangwa okumanenena. ");
INSERT INTO lyn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Simba anyine ombumu woyo ota okalwisa omukwaye woyo nokwatwesa okwikala banji ni kunahana nji kana kame atwesa okalwa ni sikwata saye no kukwana eikiti likumi nji aka kuwane ni woyo okwite esikwata no kukwana eikiti makumi ayiili. ");
INSERT INTO lyn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Cwale nji otwesa abo omunjili yonyene kame amubita, mba tumu ondumeleti okakumbela ekozo asili kule. ");
INSERT INTO lyn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Cwalehe omunu yonje kwaanyi kakutoboha oufumu waye katamba okutenda omwiyetwa waye. ");
INSERT INTO lyn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Omungwa ni wakuwaba, kono nji waamuba kale, cwale ngasibine sausetwe nji mungwa kame? ");
INSERT INTO lyn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kaukwite etuso ku mumbu simba ku mununo, aanu kame auyumba. Cwale woyo okwite amatwi ayupe.” ");
INSERT INTO lyn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Cwale atelisi nasi kutenda eibi onje sebeli asheeteta abeebi okuteeteta Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Cwale Afalisi na iyeti no mulawo sebeli akushobotela aamba nji, “Wuyu mulume kame atambulanga asikutenda esibi mane ni kulya noo!” ");
INSERT INTO lyn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Cwale Jesu sebeli waambela enguli eyi nji ");
INSERT INTO lyn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Cwale ngasine sakwikale nji omunjili kwaanyi kame akwite emikoko no kukwana omwanda nji nakutauka mumweya, kana katwese okusiya emikoko no kukwana makumi atanu nanee ni mutanu ni tunee (99) mu lihalaupa ni kuta okasaela owo ona tauka okubitela abo sakauwanene? ");
INSERT INTO lyn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Cwale aba auwana kame aubeeka ba mafuti yo wabelelwe, ");
INSERT INTO lyn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","mi aba akeela ku mundi kame aisana alikani aye bamweya nawo ayakile naye, ni kwamba kwa onyene nji, ‘Kamuwabelelwe ni mene kakuli inawana omukoko wange owo ona kutauka!’ ");
INSERT INTO lyn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mukutenda ngeeso kame nimyambela nji mba kwikala okuwabelelwa kunene mu wilu abo osikutenda ouyi mumweya aba afutuka okubaka okubita awo no kukwana makumi atanu nanee ni mutanu ni tunee (99) awo nokwabaka. ");
INSERT INTO lyn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Simba abo omukati woyo okwite emiwayawaya no kukwana likumi mi sebeli bataukabo kamweya, kana katwese okutumbula elambi ni kufiyela mu ndoo okusaela akamuwayawaya kamweya okutwala abo sakakawanene? ");
INSERT INTO lyn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Cwale aba amana oukawana, sebeli oisana alikani aye nawo ayakile naye ni kwamba nji, ‘Muwabelelwe ni mene kakuli inawana akamuwayawaya kange kana kutauka.’ ");
INSERT INTO lyn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mukutenda ngeeso kame nimyambela nji kame kuli okuwabelelwa balubala no mangeloiloi a Nyambe abo osikutenda ouyi mumweya ona baka.” ");
INSERT INTO lyn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Cwale Jesu sebeli otwalelela okwamba nji, “Kame kuna kwikalanga omulume woyo ona kwikalanga naana no andumbana ayili. ");
INSERT INTO lyn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Cwale omwanukana bo sebeli wambela sitaye nji, ‘Sitange, mene munibeko ekabelo yange kweyo muluwile.’ Cwale omulume sebeli waatabela oufumu waye. ");
INSERT INTO lyn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Cwale munyima no maywaa feela acana, woyo mwanaye no mwanukana sebeli oungeka bamweya eyo ana kubiwa ni kwingena enaha muule mane oko sebeli oka kandakanda oufumu waye mukuyoya no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Cwale munyima no kumana oufumu waye onje, elishebo no kuneneba sebeli liingena omo mu naha, mi sebeli otateka okusaela omo sayoyele. ");
INSERT INTO lyn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ababo sebeli ota okaingena omusebezi ku mulume woyo ona kwikalanga omomo mu naha mi sebeli oka mutwala mu litema lyaye nuka muba omusebezi no kulisa angulube. ");
INSERT INTO lyn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mu mukwa no lishebo cwale sebeli olakaza fela okulya ku ilya no angulube, kono kakwisa simba mumweya woyo ona kumuba esi no kulya. ");
INSERT INTO lyn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kono cwale aba nausa etingana taye sebeli wamba nji, ‘Kandi anjinga abika a sitange awo akwite esinkwa simba esi no kulya mane kame ateulanga, kono kame nifa elishebo kuno! ");
INSERT INTO lyn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mbani inguka eliywaa linjili ni kuta kwa sitange nukamba nji, “Sitange, kame ina tende ouyi balubala lwa Nyambe mane ni balubala lowe. ");
INSERT INTO lyn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cwale sifanene okuniisana mwanowe bano, kono oniisane kanyi omunjili no abika owe.’ ");
INSERT INTO lyn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Eliywaa linjili sebeli oinguka ni kuuka kwa sitaye. “Cwale yo sili kule sitaye sebeli omumona ni kumulimuka mane ni kumufela amakeke, sebeli omwitukela oka mukwela musaali ni kumu tubeta. ");
INSERT INTO lyn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Cwale omwana sebeli wamba kwa sitaye nji, ‘Sitange, kame ina foso balubala lwa Nyambe mane ni balubala lowe, cwale sifanene okwiisanwa mwanowe.’ ");
INSERT INTO lyn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kono sitaye sebeli wambela abika aye nji, ‘Mulite muwangu wangu olwambi no kuwaba mu mumangeke mane mumubeeke elisala naku munwe naku lyooko mane ni tinjatangwa ku makondo. ");
INSERT INTO lyn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Cwale mulite olilole no kusuwa mwiibae nji tutende omukiti tuwabelelwe! ");
INSERT INTO lyn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kakuli wuyu mwanange kame ana kufa mi nayoyo kame, na kutauka cwale na waniwa, mi ababo sebeli atateka omukiti. ");
INSERT INTO lyn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Cwale omwanaye no mukulu kame ana kwikalanga ku matema. Cwale aba ana kusheeteta abeebi ni ndoo sebeli oyupa etindimo ni kunenga. ");
INSERT INTO lyn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Cwale sebeli oisana omunjili no abika ni kumwibanguta nji, ‘Siikene sitendahala?’ ");
INSERT INTO lyn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Cwale sebeli omutambula nji, ‘Minowe naiyi,’ mi sitowe naibaa olilole no kusuwa kakuli namu tambula wino mi yokwanine.’ ");
INSERT INTO lyn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kono cwale yonyene sebeli otina ni kukana okwingena, ababo sitaye sebeli oiya ni kumususuweza nji aingene. ");
INSERT INTO lyn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kono mwana sebeli otambula sitaye nji, ‘Mumone, nani mibelekele ba myaka no kupula nambulwa okwakuteka emilawo yenu, kono kamwa siniba elilole nji nitende omukiti na likani ange! ");
INSERT INTO lyn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kono cwale wuyu mwanenu woyo ona kuta mukulya ekalulo no ufumu wenu ni mahule aba aneeyi, namu mwibaele olilole no kusuwa!’ ");
INSERT INTO lyn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Cwale sitaye sebeli wamba kwa mwanaye nji, ‘Mwanange enako yonje kame uli ni mene, mi eyo niluwile yonje yowe. ");
INSERT INTO lyn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Cwale kame kulukela nji nitendele wuyu minowe omukiti mi owabelelwe, kakuli wuyu minowe nakufa mi nayoyo, mane naku tauka, kono cwale bano na waniwa.’ ” ");
INSERT INTO lyn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesu sebeli wamba kame kwa iyetwa nji, “Kame kuna kwikala omulume no kufuma ona kwikala ni mubika waye. Cwale epiho sebeli iiya kwa yonyene nji omunu woyo kame ana kusinya esifumu saye, ");
INSERT INTO lyn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","mi sebeli omwisana ni kwamba kwa yonyene nji, ‘Iikene eyi niyupa mulibaka lyowe? Otunde ba sipula sowe no ubika kakuli kufanene okutenda omubika wange.’ ");
INSERT INTO lyn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Cwale omubika sebeli okwambisa yomboci nji, ‘Iikene sani tende kakuli molyange nani tundisa ba ubika? Songolile onene okutombola mi kame neena okukumbela. ");
INSERT INTO lyn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kame niyii esi sanitende! Nji cwale aanu ani tambule mu tindoo too aba ina tundu ba musebezi wange.’ ");
INSERT INTO lyn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Cwale sebeli oisana awo ana kukolotela molyaye omunjili ni munjili. Sebeli oibanguta woyo no weli nji, ‘Bukai ona kolotele molyange?’ ");
INSERT INTO lyn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Sebeli otambula nji, ‘Omwanda no sipimo no oli,’ cwale sebeli wamba kwa yonyene nji, ‘Oshimbe esikoloti sowe mi oikale banji muwangu on̄ole nji makumi atanu 50.’ ");
INSERT INTO lyn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Cwale sebeli wamba ku munjili nji, ‘Bukai ona koloto?’ Sebeli wamba nji, ‘Masaka akwana omwanda no uloto,’ Sebeli omwambela nji, ‘Oitundise mi on̄ole makumi atanu naatu (80).’ ");
INSERT INTO lyn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Molyaye sebeli onyaza omubika mulibaka no kwasepahala kwaye kakuli aanu no litunga lino kame amonahala okutenda wino eyi no lusika loo feela okubita aanu no liseli. ");
INSERT INTO lyn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Cwale kame nimyambela nji, “Mukutende oulikani mwenyene mulibaka no kwaluka, nji cwale aba sai kwangwe kame samitambule mu mundi no kuta oku no kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Woyo no kusepahala kweyi no kucaniba mba sepahala kweyi no kupula, mi woyo no kwasepahala kweyi no kucaniba katamba kusepahala ngeeso kweyi no kupula. ");
INSERT INTO lyn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nji cwale kamusi sepahala mu inu no kwaluka, anyine so misepa mu ufumu no niti? ");
INSERT INTO lyn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Cwale nji kamusi sepahala mu sinu no mukowe, anyine sokuba eso sili senu? ");
INSERT INTO lyn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kakwisa omubika otwesa okusebeleza ambumu ayiili, kakuli mbu timbibo mumweya ni kusingabo munjili simba oukubeeka onene kumumweya ni kukana omunjili. Kutwese okusebeleza Nyambe ni mali.” ");
INSERT INTO lyn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Afalisi awo ana kusinganga amali aba ana kuyupa eyi, cwale sebeli atimba Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kono Jesu sebeli wamba kwa onyene nji, “Anyi mukuyeema mwenyene balubala no aanu, kono Nyambe kame ayii emicima yenu kakuli eyo itendile eyi no utokwa mukaci no aanu akwiiba mu miyo ya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Omulawo na nuhi konji ba nako ya Jowani okutunda abo cwale eliywi no kuwaba no mubuso wa Nyambe aba lina kukutaziwa, mi omunu yonje sebeli weteka onene okwingenamo. ");
INSERT INTO lyn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kono kwakotoba eliwilu ni litunga nji ibwe okubita enombolo imweya no mulawo nji ibwe. ");
INSERT INTO lyn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Munu yonje woyo olukulula mukataye ni kukwata omunjili kame abuka mane ni woyo okwata omukati ona lukululwa kwa mbumwaye kame abuka. ");
INSERT INTO lyn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Kame kuna kwikalanga omulume no kufuma ona kukumanganga eikumango no undilu ona kulyanga eilya no kuwaba ba liywaa ni liywaa. ");
INSERT INTO lyn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Cwale ba mweelo waye kame kuna kulangananga omulume no kusheba no litina lya Lazalo ona kwikalanga ni itombo olutu lonje, ");
INSERT INTO lyn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","woyo ona kulakazanga okulya eyo ina kukwanga ku tafule no mulume no kufuma, cwale ambwa sebeli aiya ni kulasa ba itombo yaye. ");
INSERT INTO lyn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Omulume no kusheba sebeli ofa mi amangeloi sebeli amushimbela kwa Abulahama mu saali saye. Omulume no mufumi ni yonyene sebeli ofa mane sebeli oteuliwa, ");
INSERT INTO lyn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","mi mu lyangalilo, yoli mu mayando sebeli waliketa ni kumona Abulahama aba no kuleba mane Lazalo yoli mu saali saye. ");
INSERT INTO lyn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Cwale sebeli okuwa nji, ‘Sitange Abulahama! Onifele amakeke, mi otume Lazalo acupwe amamaneneno no munwe waye mu meyi nji aombote olulimi lwange, kakuli kame nili mu utata onene muno mu mulilo!’ ");
INSERT INTO lyn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kono Abulahama sebeli omutambula nji, ‘Mwanange opuluke nji mu nako no kuyoya kowe nukutambulanga einu no kuwaba, mi Lazalo kasi kwikalanga ni inu no kuwaba. Kono bano kame ali wino kuno, mi wene kame oli mu utata. ");
INSERT INTO lyn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Cwale okwekeza kweeyi, mukaci ketu ni wene kame kuli owina no kuneneba onene, nji cwale awo ali muno katwese okwiiya kwa wene mane kakwisa woyo sotwesa okuta okutunda omo okwiiya kwaaci.’ ");
INSERT INTO lyn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Cwale omufumi sebeli wamba kwa Abulahama nji, ‘Kame ni kukumbela, sitange, otume Lazalo ku ndoo ya sitange, ");
INSERT INTO lyn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kakuli kame nikwite ainange atanu nji cwale akaalemuse nji alese okwiiya mu sibaka sino no mayando.’ ");
INSERT INTO lyn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kono Abulahama sebeli wamba nji, ‘Kame akwite Mushe na nuhi a Nyambe cwale walesele aayupe.’ ");
INSERT INTO lyn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Cwale omufumi sebeli wamba nji, ‘Kokuulwa, sitange Abulahama! Kono nji kute omunjili kwa onyene ona tundu kwaafu, mba baka.’ ");
INSERT INTO lyn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Cwale Abulahama sebeli wambela omufumi nji, ‘Nji katamba okuyupa Mushe na nuhi a Nyambe, katamba okuyupa simba woyo soingulwa okutunda kwaafu.’” ");
INSERT INTO lyn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesu sebeli wamba kwa iyetwa aye nji emiliko ku kutenda esibi mu niti ikeeyile, kono oumai ni kwa woyo ikeyele! ");
INSERT INTO lyn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nikwa kuwaba kambe kame sa nungelelwe eliwee linene mu ndingo yaye niku muyumbela mu liwate, okubita nji asaitete anyonyo okutenda esibi. ");
INSERT INTO lyn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cwale mu kumamele mukaci kenu, nji omwabowe kame atenda esibi omukalimele, mi nji na baka omulemene. ");
INSERT INTO lyn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Cwale nji kame ana kufoseze katanu ni twiili mu liywaa limweya, mi ni kwaliketa kwa wene katanu ni twiili ni kwamba nji, ‘Nabaka kale,’ kame ofanena oku mulemena.” ");
INSERT INTO lyn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Atumiwa sebeli aamba kwa Mbumu nji, “Otwekeleze ku tumelo yetu.” ");
INSERT INTO lyn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Cwale Ombumu sebeli wamba nji, “Kambe kame mukwite etumelo no okufeka kanyi oubeke no mbuto no masitete, kambe kame mutwesa okwambela esitondo no molobeni nji okutule mi okakunwe mu liwate, mi mbasi mikuteke. ");
INSERT INTO lyn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Anyine mukaci kenu woyo okwite omubika olima simba okubabalela omukoko, so amba kwa yonyene aba atunda mu litema nji, ‘Oiye muwangu kuno tulye ba tafule?’ ");
INSERT INTO lyn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Katamba kwamba kwa yonyene nji, ‘Oni lukisete omulalelo, okuyumene mi oni sebeleze, konji aba sa nilyele ni kunwa mi munyima bosolye ni kunwa.’ ");
INSERT INTO lyn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kana mba kutumele ku mubika ba kutenda eso anambeliwa? ");
INSERT INTO lyn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Naanyi yongeso nji aba mutenda yonje mu nalaelwa, mwambe nji, ‘Tuli abika awo no kwafanena, kame tuna tende eyo tufanena okuteda.’” ");
INSERT INTO lyn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesu abana kuta ku Jelusalema, sebeli weenda mu museto mukaci no Samaliya ni Galileya. ");
INSERT INTO lyn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Cwale abana kwingena mu mundi, sebeli okwangana ni aanu no kukwana likumi asikutoma embingwa, aimanine kule, ");
INSERT INTO lyn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","cwale sebeli akuweleza ni kwamba nji, “Jesu, Molyetu! Otufele amakeke!” ");
INSERT INTO lyn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Cwale aba ana kwamona sebeli waambela nji, “Mute muka kumonahaze kwa pulisita aka mitatube.” Ba ndila alemine okuta, sebeli abala. ");
INSERT INTO lyn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Cwale mumweya kwa onyene aba ana kumona nji nabala, sebeli ouka ni kulumbeka Nyambe ni liywi linene. ");
INSERT INTO lyn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Cwale sebeli okwela banji ni lubala ku makondo a Jesu nuukutumela. Omulume woyo neli Musamaliya. ");
INSERT INTO lyn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Cwale Jesu sebeli wamba nji, “Kasa likumi awo ana balisiwa? Kanti kubine ali awo akwana atanu nanee? ");
INSERT INTO lyn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ngasibine kasiuka nji alumbeke Nyambe konji wuyu osi mushobo mundina? ");
INSERT INTO lyn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Cwale sebeli omwambela nji, “Oimane okutele etumelo yowe nai kuyoyisa.” ");
INSERT INTO lyn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Afalisi aba ana ku mwibanguta nji omubuso na kuwilu kamwaka sawiye. Sebeli waatambula nji, “Omubuso wa Nyambe kautamba kwiiya ni imoniso. ");
INSERT INTO lyn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kautamba kwambiwa nji, ‘Komumone, kuno kwauli, simba nji, Uya baya, kakuli omubuso wa Nyambe kame uli mukaci kenu.” ");
INSERT INTO lyn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesu sebeli wamba kwa iyetwa aye nji, “Amaywaa akeyile abo samushukele okumona limweya eliywaa no Mwana no Munu, kono kamutamba kulimona. ");
INSERT INTO lyn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mi kame saambe kwanyi nji, ‘Komumone uno kuno, simba nji, ‘Komumone, uya kuya! Mulese kuta simba okwakon̄a. ");
INSERT INTO lyn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kanyi olumonyi aba lumonyeka ni kutumbuka mu liwilu ku maneku ayiili, mwasa kukaikalele mu liywaa no Mwana no Munu. ");
INSERT INTO lyn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kono ayande oweli kwiinu no kupula mane ni kukaniwa ni lusika olu. ");
INSERT INTO lyn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kanyi mu maywaa a Nuwe mwasa kuka ikalele ni mu liywaa no Mwana no munu. ");
INSERT INTO lyn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kame ana kulya, ni kunwa, ni kukwata, ni kukwalisa konji mane ba liywaa elyo Nuwe aba ana kwingena mu wato no aleka, mi ameyi no kupula sebeli aiya ni kwayundisa onje. ");
INSERT INTO lyn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kanyi kame omo kuna kwikalela mu maywaa a Lota, kame ana kulya, ni kunwa, kame ana kuulanga ni kuulisa, kame ana kukunanga ni kuyaka. ");
INSERT INTO lyn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kono ba liywaa ana kutunda Lota mu sondoma omulilo ni silufula sebeli iloka ku wilu ni kwaibaa onje. ");
INSERT INTO lyn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Cwale mwasa kukaikalele ni mu liywaa no Mwana no munu aba sa monahale. ");
INSERT INTO lyn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ba liywaa elyo woyo oli ba situwa no ndoo, ni ibyana yaye mu ndoo alese kutuluka nji aishimbe, mi kame ni woyo oli mu litema alese okuuka ku mundi. ");
INSERT INTO lyn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mupuluke mukataye Lota. ");
INSERT INTO lyn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Woyo yonje okununeka omooyo waye mba utaukelwe, kono woyo otaukelwa omooyo waye mba yoyisiwa. ");
INSERT INTO lyn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kame ni myambela nji mu usiku owo kame sakwikale ayiili ba mumbeta, mumweya mba shimbiwa omunjili mba siiwa. ");
INSERT INTO lyn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Akati ayiili satwe mu sinu simweya, mumweya mba shimbiwa omunjili mba siiwa ");
INSERT INTO lyn_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Alume ayiili awo sa ikale mu litema, omunjili mba shimbiwa munjili mba siiwa. ");
INSERT INTO lyn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Cwale sebeli aamba kwa yonyene nji, “Mbumu, kubine oko?” Jesu sebeli waambela nji, “Oko kuli olutu ni manon̄u kwa sa kaungane bamweya.” ");
INSERT INTO lyn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Cwale Jesu sebeli waambela enguli nji atundamene mu kulapela mi alese kuzwafa. ");
INSERT INTO lyn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Sebeli waambela nji, “Mu mulenen̄i munjili kame kuna kwikalanga omwatuli woyo kasi kucilanga Nyambe simba aanu. ");
INSERT INTO lyn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Cwale kame kuna kwikalanga ni mbakati woyo ona kwiyanga kwa yonyene ni ku mwambelanga nji, ‘Onituse kwa wuyu oni zekisa!’ ");
INSERT INTO lyn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Omwatuli sebeli okana ba nako no kuleba, kono munyima sebeli wamba kwa yonyene nji, ‘Simba nji sicili Nyambe simba okukuteka omunu, ");
INSERT INTO lyn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ee kakuli wuyu mbakati kame ani bilaeza, kame sani mutuse nji alese okuni kataza okuni iyelanga!’ ” ");
INSERT INTO lyn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Cwale Ombumu sebeli wamba nji, “Muyupe eyo amba omwatuli nambulwa niti. ");
INSERT INTO lyn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Cwale Nyambe katamba okutusa aketwa aye, awo alila kwa yonyene ousiku ni munji? Kana mba liyehe mukaci koo? ");
INSERT INTO lyn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kame ni myambela nji, kame saatuse muwangu, simbangeeso, Omwana no munu aba saiye mbawana etumelo ba litunga?” ");
INSERT INTO lyn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesu sebeli wamba enguli eyi kwa njili awo ana kukusepa onyene nji akukena mane ni kushendaula akoo. ");
INSERT INTO lyn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Alume ayiili sebeli ata mu ndoo ya Nyambe okalapela, mumweya neli Mufalisi omunjili neli mutelisi. ");
INSERT INTO lyn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Omufalisi sebeli oimana niku lapela nji, ‘Nyambe kame ni kutumela kwa wene kakuli mene sikufekile kanyi aanu anjili asikuyumena, nawo no kwa sepahala, asikubuka, simba mane kanyi wuyu mutelisi. ");
INSERT INTO lyn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kame niku yumenanga eyi no kulya twiili mu sunda, kame nibanga esi no likumi kweyo ni wananga.’ ");
INSERT INTO lyn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Kono omutelisi yoimanine oku no kuleba mane kasikutwesa okwinula amiyo aye okwaliketa ku wilu, kono sebeli ofula ba saali saye nikwamba nji, ‘Nyambe, onifele amakeke mene osikutenda eibi!’ ");
INSERT INTO lyn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kame nimyambela nji,” “Wuyu mulume kame ana uku ku ndoo yaye yo lukile okubita omukwaye. Kakuli omunu yonje woyo okununeka yonyene mba kokobeziwa, kono woyo oku kokobeza mba nunekiwa.” ");
INSERT INTO lyn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Cwale sebeli amulitela anuke nji aaleme amaka aye beulu. Cwale aiyetwa aye aba ana kumona ngeeso sebeli aayuta. ");
INSERT INTO lyn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kono Jesu sebeli waisanena kwa yonyene ni kwambela nji, “Mulesele anuke aiye kwa mene, mi mulese okwakanisa kakuli omubuso wa Nyambe niwoo. ");
INSERT INTO lyn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Niti luli kame nimyambela! Omunu yonje nji katambula omubuso wa Nyambe kanyi mwanuke katamba kwingena mo.” ");
INSERT INTO lyn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Cwale omubusisi sebeli oibanguta Jesu nji, “Omwiyeti no kuwaba, siikene sa nitende nji nika yole omooyo na kwaabwa?” ");
INSERT INTO lyn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Cwale Jesu sebeli wamba kwa yonyene nji, “Iikene abonisana nji nili muwa?” Kakwisa muwa konji Nyambe yomboci. ");
INSERT INTO lyn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Oyii etitaelo, ‘Mulese okubuka, Mulese kwibaa, Mulese kwiita, Mulese kuba oupaki no mapwa, Mukuteke asitenu na inawenu.’” ");
INSERT INTO lyn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mi sebeli wamba nji, “Yonje eyi ina imamela okutunda ku wanuke wange.” ");
INSERT INTO lyn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Cwale Jesu abana kuyupa ngeeso sebeli wamba kwa yonyene nji, “Kwasili esinu simweya eso ulwile. Oulise einu yowe yonje okwite mi otabele awo ashebile, mi mbu wana esifumu na kuwilu, cwale oiye oni kon̄e.” ");
INSERT INTO lyn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kono abana kuyupa eyi, sebeli weena, kakuli neli wakufuma onene. ");
INSERT INTO lyn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesu sebeli omwaliketa ni kwamba nji, “Ngasibine kubambabile nji awo akwite esifumu akaingene mu mubuso wa Nyambe! ");
INSERT INTO lyn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kono ni kwa kotoba ekamele okwingena mu litiyo no ndonga kasanji omufumi okwingena mu mubuso wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Awo ana kwiyupa sebeli amba nji, “Cwale anyine so kayoyisiwa?” ");
INSERT INTO lyn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Kono Jesu sebeli wamba nji, “Eso sibambabile kwaanu ni sakotoba kwa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Cwale Pitolosi sebeli wamba nji, “Komone! natusiyi etindoo tetu nuukukon̄a.” ");
INSERT INTO lyn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Cwale Jesu sebeli wamba kwa onyene nji, “Niti luli kame nimyambela nji, “Kakwisa omulume ona siyi endoo simba omukati simba mukulwaye simba ashemyaye simba anaye mulibaka no mubuso wa Nyambe, ");
INSERT INTO lyn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","awo aulwile okuwana onene ba nako ino, mi ba nako no mamaneneno mbawana omooyo no kwabwa. ");
INSERT INTO lyn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Cwale Jesu sebeli oshimba aiyetwa aye no kukwana elikumi ni twiili (12), ni kwamba kwa onyene nji, “Muteetete, kame tukatile ku Jelusalema, mi eyo yonje ina kun̄oliwa eyi no Mwana no munu kwa nuhi a Nyambe mba iyatetetwe. ");
INSERT INTO lyn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kakuli kame sa biwe kwa simacaba, mi kame sa shendaulwe mane ni ku yandisiwa no kwenisa mane ni kumu sibwela amate. ");
INSERT INTO lyn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kame sa mufule ni kumwibaa, mi ba liywaa no waatu mba inguka.” ");
INSERT INTO lyn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kono aiyetwa kasi kuyupa simba simweya kweyo ana kwamba, omwambelo ou kame una ku shweekiwa kwa onyene mi kasi kulimuka eyo Jesu ana kwamba. ");
INSERT INTO lyn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Abo Jesu yoli beebi ni Jeliko, kame kuna kwikalanga esibofu no mulume sina kwikalanga ku nyonga no ndila, esikumbelanga ");
INSERT INTO lyn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Cwale aba ana kuyupa aanu no kupula abita, sebeli oibanguta nji, “Siikene esi?” ");
INSERT INTO lyn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Sebeli amwambela nji, “Jesu no Nazaleta yokame woyo obita” ");
INSERT INTO lyn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Cwale sebeli okuwa nji, “Jesu! Omwana Dabida! Onifele amakeke!” ");
INSERT INTO lyn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Cwale awo ana kwikala balubala sebeli amukalimela nji aondoke. Kono sebeli okuwa onene nji, “Omwana Dabida oni yupele amakeke!” ");
INSERT INTO lyn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Cwale Jesu sebeli oimana niku laela nji amulite kwa yonyene mi aba ana kukeela abeebi, sebeli omwibanguta nji, ");
INSERT INTO lyn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Iikene osaela nji niku tendele?” Sebeli otambula nji, “Mbumu, kame ni singa okumona.” ");
INSERT INTO lyn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Cwale Jesu sebeli wamba kwa yonyene nji, “Omone! Etumelo yowe naiku yoyisa.” ");
INSERT INTO lyn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Cwale ababo sebeli omona niku mukon̄a yo kanyisa Nyambe, mi aanu onje aba ana kumona eyi, sebeli alumbeka Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesu sebeli oingena mu Jeliko mi kame ana kubita feela. ");
INSERT INTO lyn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Cwale kame kuna kwikalanga omulume no litina lya Zakiyasi, neli omukulu no mutelisi ni kufuma. ");
INSERT INTO lyn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Cwale sebeli osaela nji amone Jesu nji anyine, kono sebeli okwanggwa mulibaka no aanu no kupula ni kwibiba ku siyema saye. ");
INSERT INTO lyn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Cwale sebeli oitukela balubala nuukatina ku sitondo no sikamole nji amumone, kakuli Jesu nakubita endila eyo. ");
INSERT INTO lyn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Cwale Jesu aba ana kukeela ba sibaka eso, sebeli waliketa ku wilu ni kwamba kwa yonyene nji, “Zakiyasi otuluke muwanguwangu kakuli kame nifanena okwikala mu ndoo yowe balelo.” ");
INSERT INTO lyn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Cwale Zakiyasi sebeli oleluba ni kutulukela banji ni ku mutambula mu kuwabelelwa onene. ");
INSERT INTO lyn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Cwale aanu aba ana kumona ngeeso sebeli an̄un̄uta nji, “Kame anati okatenda ongenda no mulume osikutenda eibi!” ");
INSERT INTO lyn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Cwale Zakiyasi sebeli oimana ni kwamba kwa Mbumu nji, “Komone, Mbumu, elicika no ufumu wange kame niba kwa sikusheba, nji kame nina byangula omunu esinu saye, kame nimuuseta etitikanyo no kukwana tinee.” ");
INSERT INTO lyn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Cwale Jesu sebeli wamba kwa yonyene nji, “Balelo okuyoyisiwa na kwiiyi muno mu ndoo, kakuli ni yonyene mwana a Abulahama. ");
INSERT INTO lyn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kakuli Omwana no munu neeyi muku saela ni kuyoyisa eso sinatauka.” ");
INSERT INTO lyn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aba ana kuyupa einu eyi, Jesu sebeli otwalelela okwaambela enguli. Kakuli kame ana kwikala beebi ni Jelusalema, mi kakuli kame ana ku yambuta nji omubuso wa Nyambe kame uli beebi oku monahala ababo. ");
INSERT INTO lyn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Cwale Jesu ababo sebeli wamba nji, “Omulume no ku kutekeha sebeli ota ku naha oko no kuleba akatambula omubuso mi cwale sebeli ouka. ");
INSERT INTO lyn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sebeli oisana abika aye no kukwana likumi ni kwaaba etipondo likumi ni kwamba kwa onyene nji, ‘Mu fundote amali aa okutwala abo sanika ukele.’ ");
INSERT INTO lyn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kono aanu aye naku mutimba mane sebeli atuma onumwana munyima yaye okaamba nji, ‘Ka tusingi wuyu mulume nji atubuse.’ ");
INSERT INTO lyn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Aba ana kuuka munyima no katambula omubuso sebeli olaela abika aye awo ana kuba amali nji aiye kwa yonyene nji alimuke eso anawana mukuulisa koo. ");
INSERT INTO lyn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ono weli sebeli oiya ba lubala lwaye ni kwamba nji, Molyange, epondo yowe naini wanene etipondo likumi beulu.’ ");
INSERT INTO lyn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Cwale sebeli wamba kwa yonyene nji, ‘Nutende wino, wene omubika no kuwaba! Kakuli nusepahala kwicana onene, mbu busu emilenen̄i no kukwana likumi.’ ");
INSERT INTO lyn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Omubika no wiili sebeli oiya ni kwamba nji, ‘Molyange, epondo yowe ina wanenebo etipondo titanu kame.’ ");
INSERT INTO lyn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Cwale sebeli wamba kwa yonyene nji, ‘Cwale mbu busu milenen̄i itanu.’ ");
INSERT INTO lyn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Cwale omubika munjili sebeli oiya ni kwamba nji, ‘Molyange, ino yokame epondo yowe eyo nina kupungelanga mu lwambi. ");
INSERT INTO lyn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kakuli kame nina kucilanga wene kakuli uli munu no kubambaba. Kame oshimba omo kausi beeka mane kame okutula omo kausi kuna.’ ");
INSERT INTO lyn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Cwale sebeli wamba kwa yonyene nji, ‘Kame sani kwatule kweyo itunda mu kanw kowe! Wene omubika no kububa! Kame ona kulimuka nji mene nili omunu no kubambaba mene nishimba omo kanisibeeka mane niku kutula omo kani sikukuna. ");
INSERT INTO lyn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Cwale iikene aba wasikubeeka amali ange mu panga? Cwale bakwiya kwange kambe kame nina ishimbi ni n̄ambeko yayo.’ ");
INSERT INTO lyn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Cwale sebeli wamba kwawo ana kwimana naye kunyonga nji, ‘Mushimbe epondo kwa yonyene mi mwiibe woyo okwite etipondo likumi.’ ");
INSERT INTO lyn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Cwale sebeli aamba kwa yonyene nji, ‘Mbumu kame akwite etipondo likumi!’ ");
INSERT INTO lyn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Kame ni myambela nji, ‘Omunu yonje woyo okwite mbabiwi onene, kono kwa woyo oulwile simba neso akwite mba byanguliwa. ");
INSERT INTO lyn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kono kanyi kwiila yange awo ka sikusinga nji nabuse, mwalite kuno nikwaibaele balubala wange!”’ ");
INSERT INTO lyn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Cwale Jesu aba ana kumana okwamba eyi, sebeli wekeza okuta ku Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Cwale aba ana kukeela ku nyonga no Betefage ni Betani ku lilundu elyo liisaniwa nji Olibeti, sebeli otuma aiyetwa aye ayiili balubala, ");
INSERT INTO lyn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ni kwambela nji, “Mute mu mundi oli balubala lwenu, abasa mwingenemo mba muwana akana no mbongolo kanungilwe ako kaka sitiniwa kale ku munu. Mu kanungutule mi mukalite kuno. ");
INSERT INTO lyn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nji omunu kame sami ibangute nji, ‘Iikene aba muka fungutula,’ mu mwambele nji, ‘Ombumu kame aka saela.’” ");
INSERT INTO lyn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Cwale awo ana kutumiwa sebeli ata nukawana akambongolo kanyi omo ana kwaambela Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cwale alemine oku fungutula akambongolo, omunyako sebeli wamba kwa onyene nji. “Iikene aba mu fungutula akambongolo?” ");
INSERT INTO lyn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Cwale sebeli aamba nji, “Ombumu kame aka saela,” ");
INSERT INTO lyn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Cwale sebeli alita akambongolo kwa Jesu, ni kuyala eikumango yoo beulu no kambongolo ni kwikatabo Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Cwale yoenda, sebeli ayala eikumango yoo mu ndila. ");
INSERT INTO lyn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Cwale aba ana kukeela abeebi ni Jelusalema, ba ndila ishetumuka ba liundu no Olibe, okupula no aiyetwa sebeli atateka okuwabelelwa ni kuyeema Nyambe ni liywi no kuneneba mullibaka no musebezi no kuneneba ana mono. ");
INSERT INTO lyn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","aamba nji, “Embuyoti ni yawoyo oiya mu litina lya Mbumu! Ekozo iikaleko mu wilu ni kanya mu liwilu. ");
INSERT INTO lyn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Cwale Afalisi anjili mu kupula sebeli aamba nji, “Mwiyeti,” okalimele aiyetwa owe!” ");
INSERT INTO lyn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesu sebeli otambula nji, “Kame ni myambela nji, aa nji aondoke, amawee mba kuwu.” ");
INSERT INTO lyn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Cwale aba ana kusheeteta abeebi ni mulenen̄i no Jelusalema sebeli oulilela, ");
INSERT INTO lyn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ni kwamba nji, “Kambe na mukulimuka mu liywaa na balelo einu itenda ekozo! Kono cwale kame ishweekilwe ku miyo enu! ");
INSERT INTO lyn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kakuli amaywaa mbaiyi kwa wene abo eila yowe mbai kutinguluka ni lukwakwa no kwambeka ikuyatilele ku maneku onje. ");
INSERT INTO lyn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Cwale kame sa kukwisete banji wene bamweya naanowe, mi katamba kusiya eliwee limweya beulu no likwayo mwa wene, kakuli kusilimuka enako ona poteliwa!” ");
INSERT INTO lyn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Cwale Jesu sebeli oingena mu Ndoo ya Nyambe ni kutateka okucita awo ana kuulisangamo, ");
INSERT INTO lyn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ni wamba kwa onyene nji, “Kame kun̄olilwe nji, ‘Endoo yange kame saitende eyi no tapelo.’ Kono aanyi namwifutula omo akushweeka ambuyi!” ");
INSERT INTO lyn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Cwale Jesu nakwiyetanga mu Ndoo ya Nyambe amaaywaa onje. Apulisita akulu na n̄oli, ni manduna no sicaba sebeli alela okumwibaa, ");
INSERT INTO lyn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kono kasi kuwana esinjili eso ana kufanena okutenda, kakuli aanu onje kame ana ku teetetanga ku maywi aye. ");
INSERT INTO lyn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Eliywaa linjili Jesu yoiyeta ni kukutaza eliywi kwaanu mu Ndoo ya Nyambe, apulisita akulu na n̄oli bamweya na kulu sebeli aiya, ");
INSERT INTO lyn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ni kwamba kwa yonyene nji, “Otwambele, ka maata awo otendisa einu eyi, simba anyini ona kubi woo.” ");
INSERT INTO lyn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesu sebeli waatambula nji, “Ni mene kame sani mibangute epuzo nji munambele, ");
INSERT INTO lyn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","kana ekolobezo ya Jowani kame ina kutunda ku wilu nji neli kwaanu?” ");
INSERT INTO lyn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Cwale sebeli akwambota mukaci koo, ni kwamba nji, “Aba satwambe nji, ‘Kame itunda kuwilu,’ kame saambe nji, ‘Cwale iikene kamwa sikumupumena?’ ");
INSERT INTO lyn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kono aba satwambe nji, ‘Niya aanu feela, aanu onje kame satu pwacaule ni mawee, kakuli kame apumena nji Jowani neli munuhi.” ");
INSERT INTO lyn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Cwale sebeli atambula nji, “Katuyii oko ina kutunda.” ");
INSERT INTO lyn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Cwale Jesu sebeli wamba kwa onyene nji, “Ni mene simyambele amaata ni kutusisa okutenda einu eyi.” ");
INSERT INTO lyn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Cwale Jesu sebeli otateka okwambela aanu enguli eyi nji, “Omulume kame ana kukuna elitema no beine ni kulisiya mu maoko no abeleki, mi sebeli ota mu naha indina ba nako no kuleba. ");
INSERT INTO lyn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cwale enako aba ina kukwana, sebeli otuma omubika kwa beleki nji amube ku mbuya na mu litema no beine. Kono abeleki sebeli amufula ni kumuusa nambulwa esi ana kushimba. ");
INSERT INTO lyn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mi kame sebeli otuma omubika munjili, kono abeleki sebeli amufula ni yonyene ni ku muyandisa mu mukwa no kwenisa mane ni kumuusa nambulwa esi ana kushimba. ");
INSERT INTO lyn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Cwale sebeli otuma woyo no waatu, woyo sebeli amulemeka ni kumuyumbela kundee. ");
INSERT INTO lyn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Cwale omunya litema sebeli wamba nji, ‘Cwale iikene sanitende? Mbi tumu mwanange woyo nisinga onene, mwendi mba ka mukuteke!’ ");
INSERT INTO lyn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kono cwale abeleki abana ku mumona, sebeli akwambota mukaci koo nji, ‘Woyo yokame shwana twendenyi tu mwibae, nji cwale aci tu kayole esifumu!’ ");
INSERT INTO lyn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Cwale sebeli amuyumbela kundee no litema no beine niku mwibaa. “Cwale siikene satende omunya litema kwa onyene? ");
INSERT INTO lyn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Kame saiye mukusinya abeleki ni kuba anjili.” Cwale aanu aba ana kuyupa ngeeso sebeli aamba nji, “Nyambe otulemene!” ");
INSERT INTO lyn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kono Jesu sebeli waaliketa ni kwamba nji, “Iikene cwale eyo in̄olilwe? ‘Eliwee elyo lina kukaniwa kwayaki kame lina futuka omusumo no utokwa namu lilulu.’ ");
INSERT INTO lyn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Omunu yonje woyo so kwelabo mba patuka otubindi-bindi, kono cwale nji eliwee elyo likwele omunu mba limulemeke.” ");
INSERT INTO lyn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aiyeti no mulawo na pulisita akulu sebeli aeteka oku beeka amaoko oo beulu ya Jesu ba nako eyeyo, kono sebeli acila aanu kakuli kame ana lemuha nji naambele enguli eyo yalwisa. ");
INSERT INTO lyn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Cwale sebeli amwaliketa, ni kutumena amatwela awo ana kukumonahalisa nji akuluka, nji ayupe eyo saambe, nji amube mu maata ni mupuso no mubusisi. ");
INSERT INTO lyn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Cwale amatwela sebeli aibanguta Jesu nji, “Mwiyeti, kame tuyii nji kame wamba ni kwiyeta wino mane kukwite esishweka, kono kame wiyeta endila ya Nyambe mu niti. ");
INSERT INTO lyn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kame tulukeele aci okuba omutelo kwa Sesale nji katulukeele?” ");
INSERT INTO lyn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kono Jesu sebeli omona etingana too ni kwamba kwa onyene nji, ");
INSERT INTO lyn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Komunimonise omuwayawaya. Sanyine esifateho neyi ina n̄oliwabo?” Sebeli aamba nji, “Ya Sesale.” ");
INSERT INTO lyn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Cwale Jesu sebeli wamba kwa onyene nji, “Cwale mube Sesale eso sili sa Sesale, mi mube Nyambe eso sili sa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Cwale sebeli akwangwa mukaci no aanu okulema eso ana kwamba, kono sebeli akomoka ekalabo yaye, mi sebeli aondoka feela. ");
INSERT INTO lyn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Cwale sebeli kwiiya Aduki anjili kwa Jesu awo ana kwamba nji kakwisa okwinguka kwaafu, ");
INSERT INTO lyn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","mi sebeli amwibanguta nji, “Mwiyeti, Mushe kame ana kutun̄olela omulawo owo wamba nji mukulwaye munu nafi yo kwite omukati kono kakwite omwana, minaye kame afanena okukwata woyo mukati nji alitele mukulwaye aana.’ ");
INSERT INTO lyn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Cwale kame kuna kwikalanga alume atanu na yiili, wuyu no weli sebeli okwata omukati kono sebeli ofa nambulwa kuleyelako omwana. ");
INSERT INTO lyn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wuyu no wiili ");
INSERT INTO lyn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","mane wuyu no waatu sebeli omushimba. Mi onje atanu na yiili sebeli aafa nambulwa kusiya aana. ");
INSERT INTO lyn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Cwale munyima yoo ni mukati sebeli ofa. ");
INSERT INTO lyn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Cwalehe mukwinguka kwaafu anyine sotenda omunya mukati? Kakuli onje kame naku mukwatanga.” ");
INSERT INTO lyn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Cwale Jesu sebeli wamba kwa onyene nji, “Aana namu nako ino kame akwata ni kukwaliwa, ");
INSERT INTO lyn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kono awo sa biwe etukelo no kumona elitunga na kulubala ni kwinguka no aafu awo katamba kukwata ni kukwaliwa. ");
INSERT INTO lyn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Cwale katamba kufa kame, kakuli kame afekile kanyi mangeloi mi aana a Nyambe, atendile aana no kwinguka. ");
INSERT INTO lyn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kono nji aafu mba inguka, simba Mushe ni yonyene na kwamba ngeeso ku liputa lina kutumbuka aba ana kwisana Mbumu nji Nyambe wa Abulahama, ni Nyambe wa Isaka mane ni Nyambe wa Jakobo. ");
INSERT INTO lyn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Cwale ka Nyambe waa no kufa, kono wawo no kuyoya, kakuli kwa yonyene onje kame ayoya.” ");
INSERT INTO lyn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Cwale an̄oli anjili sebeli aamba nji, “Mwiyeti nwamba wino!” ");
INSERT INTO lyn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kakuli kame ana kucila oku mwibanguta epuzo injili kame. ");
INSERT INTO lyn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kono Jesu sebeli wamba kwa onyene nji, “Ngasibine aba aamba nji Kilesite ni Mwana Dabida? ");
INSERT INTO lyn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kakuli Dabida yonyene kame ana kwamba mu buka no Lisamu nji, ‘Ombumu naamba kwa Mbumu wange nji, Oikale ku lyooko lyange no silyo ");
INSERT INTO lyn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","okutwala abo sani tendele eila yowe eipula no kulyatabo makondo owe. ");
INSERT INTO lyn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dabida kame amwisana nji Mbumu, cwale ngasibine omo satendele nji mwanaye? ");
INSERT INTO lyn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jesu sebeli wambela aiyetwa aye aanu onje ateetete. ");
INSERT INTO lyn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Mucile an̄oli awo asinga oukumanga mu ikumango no kuleba mane ni kusinga okupota mu ibaka no misika ni kwikala mu ipula no utokwa mu tindoo no milapelo ni mu ibaka no kukutekeha ku mikiti. ");
INSERT INTO lyn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kame amana eiluwo no akati no ambakati aatendela etitapelo no kuleba! Awo kame sabiwe ekoto no kubambaba onene ni kubitelela!” ");
INSERT INTO lyn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesu sebeli waliketa ni kumona awo no kufuma abeeka etimpo too mu sitewelo, ");
INSERT INTO lyn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","cwale sebeli omona ombakati no kusheba yo beeka otumiwayawaya twiili. ");
INSERT INTO lyn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Cwale sebeli wamba nji, “Niti luli kame nimyambela nji wuyu mbakati na beeke amali no kupula okubita aanu onje. ");
INSERT INTO lyn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kakulii onje kame ana tundisa aba no kupula, kono yonyene mukusheba kwaye nabeeke eso ana kwikalanga naso sonje eso ana kufanena nji ayoyelebo.” ");
INSERT INTO lyn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Cwale anjili alemine okwamba eyi no Ndoo ya Nyambe omo ina kuyakelwa wino ni mawee no kuwaba mane ni tinubu, sebeli wamba nji, ");
INSERT INTO lyn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kanyi einu yonje eyi mumona, enako mba ikwana abo kakwisa eliwee elyo lishangamine ba linjili elyo salikwangwe oku kwisetwa banji.” ");
INSERT INTO lyn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Cwale sebeli amwibanguta nji, “Mwiyeti, kaliywaa sa itendahale eyi? Mi kasisupo eso sasi monise nji abano okutwa itendahala? ");
INSERT INTO lyn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Cwale Jesu sebeli wamba nji, “Mumamele nji mulese okoongiwa kakuli ano kupula mbaiyi mu litina lyange ni kwamba nji, ‘Yamene Jesu!’ mi ‘Enako naikwana!’ Kono mulese kwa kon̄a ");
INSERT INTO lyn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mulese kucila aba sa muyupe etindwa ni tizikinyeho kakuli eyi kame ifanena okutendahala oweli, kono kasanji amamaneneno kame ali beebi.” ");
INSERT INTO lyn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Cwale sebeli wamba kwa onyene nji, “Amatunga kame saku futukele oukulwisa, mi emibuso kame sai kufutukele oukulwisa. ");
INSERT INTO lyn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kame sakwikale etizikinyeho tinene mane mu maneku no kupula kame sakwikale elishebo ni mafu mane kame sakutunde einu no kucilisa kuwilu ");
INSERT INTO lyn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kono eyi yonje eyakasitendahala kale, kame sa mileme ni makaa oo mane amiyandise ni ku mitwala mu tindoo no milapelo ni mu titolongo mane niku mitwala balubala no ambumu mane na busisi mulibaka no litina lyange. ");
INSERT INTO lyn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eyo kame saimiiyele nji mube oupaki wange. ");
INSERT INTO lyn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mukukete mu micima yenu nji mulese kubilaele eyo samwambe. ");
INSERT INTO lyn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kakuli kame sanimibe eyi no kwamba mane ni kushangama nji kakwisa kwawo amitimbile satwese oku kanana naanyi. ");
INSERT INTO lyn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kame samubetekiwe simba kwa shemyenu, kwabeenu, asi mukowa wenu mane na likani enu mi anjili kwaanyi kame saibaiwe. ");
INSERT INTO lyn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Aanu onje kame samitimbe mulibaka no litina lyange. ");
INSERT INTO lyn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kono kakwisa simba oluuki naku mutwi wenu salu sinyehe. ");
INSERT INTO lyn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mukukoongota kwenu mbamu kawana okuyoyisiwa. ");
INSERT INTO lyn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kono abasa mumone nji Jelusalema kame atingulukilwe ku masole mulimuke nji oku sinyeha kwaye kame kuli beebi. ");
INSERT INTO lyn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Cwale awo ali mu Judeya ashotokele ku malundu, mi awo ali mukaci no mulenen̄i atundemo, mi awo ali kundee no naha alese kwingena kame. ");
INSERT INTO lyn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kakuli aa amaywaa no mayando, okwiyateteta eyo yonje ina kun̄oliwa. ");
INSERT INTO lyn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Oumai kwawo saikale naana mane nawo sayamwisa mu maywaa awo! Kakuli outata unene kame sawikaleko mu litunga mi okutweba kame sakwikale kwanuu aa. ");
INSERT INTO lyn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Anjili mbaibaiwa ni kutweba no mukwale mi kame sa komiwe ni kutwaliwa mukaci no asimacaba onje mi Jelusalema kame sa lyatangiwe okubitela abo enako no asimacaba aba saiyatetetwe. ");
INSERT INTO lyn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Cwale kame sakwikale esisupo ba liywaa ni kweti ni titungweti, mi ba litunga etinaha kame sati cile ni milumo no mawate ni mandinda. ");
INSERT INTO lyn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Alume kame sa welele mukucila mukumona eyo ikeyile ba litunga, kakuli amaata no liwilu kame sa nyanganyisiwe. ");
INSERT INTO lyn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Cwale kame sa mone Omwana no munu yokeyile mu likumbi ni maata ni kanya inene. ");
INSERT INTO lyn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Cwale einu eyi aba saitangise okutendahala, mwalikete kuwilu mi mwinule emitwi yenu kakuli okuliululwa kwenu sebeli kuli beebi. ");
INSERT INTO lyn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Cwale Jesu sebeli waambela enguli nji, “Komumone ku esitondo no Feiga ni itondo injili yonje. ");
INSERT INTO lyn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aba itangisa okumena amamuna, kame mu mona mwenyene mane ni kulimuka nji embumbi sebeli ili beebi. ");
INSERT INTO lyn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Cwale naanyi ngeeso aba mumona einu eyi eitendahala, mulimuke nji omubuso wa Nyambe sebeli oli beebi. ");
INSERT INTO lyn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Niti luli kame nimwyambela nji olu lusika kalutamba kubwa konji yonje yatendahala kale. ");
INSERT INTO lyn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Eliwilu ni litunga mba ibwi kono eliywi lyange kalitamba kubwa. ");
INSERT INTO lyn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Cwale mumamele nji emicima yenu ilese oku kandakandiwa ni mikiti ni kunwa ni tinongosi no litunga kakuli elyo eliywaa kame saaliye mukwa limukiwa. ");
INSERT INTO lyn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kakuli kame saaliyele aanu onje awo ayoya ba litunga lyonje. ");
INSERT INTO lyn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kono mutone enako yonje memu lapela nji muwane amaata no ka banduka einu eyi saitendahale mane ni kwimana balubala no Mwana no munu.” ");
INSERT INTO lyn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Cwale Jesu amaywaa onje kame ana kwiyetanga mu Ndoo ya Nyambe, kono ousiku sebeli ota okalangana ba lilundu no itondo no olibe, ");
INSERT INTO lyn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Amasikusiku onje aanu kame ana kutanga ku Ndoo ya Nyambe oka muteeteta ");
INSERT INTO lyn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Cwale enako no mukiti no inkwa nambulwa omumena aba ina kusheeteta owo wisaniwa nji Paseka. ");
INSERT INTO lyn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Cwale akulu no apulisita na n̄oli sebeli asaelanga omo saibaele Jesu kakuli kame ana kucila aanu. ");
INSERT INTO lyn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Cwale Satani sebeli oingena mwa Judasi woyo oisaniwa nji Isikaliota, woyo ona kutenda omunjili kwawo no kukwana likumi na yiili. ");
INSERT INTO lyn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Cwale Judasi sebeli ota nu kakwambota na pulisita akulu na endisi omo sa twesete okumubeteka kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mi sebeli awabelelwa nji mane kame atwesa okumuba amali. ");
INSERT INTO lyn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Cwale Judasi sebeli opumena nji awane ekolo no kumubeteka oku nambulwa aanu no kupula. ");
INSERT INTO lyn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Cwale eliywaa no mukiti no lin̄ende nambulwa omumena abo cwale omukoko no sitabelo aba sina kufanena okutendahala. ");
INSERT INTO lyn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Cwale Jesu sebeli otuma Pitolosi ni Jowani ni kwamba nji, “Mute mi mukalukise esibaka oko satukalyele omulalelo no Paseka. ");
INSERT INTO lyn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Sebeli aamba kwa yonyene nji, “Cwale kubine satu kakulukisete?” ");
INSERT INTO lyn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesu sebeli wamba kwa onyene nji, “Komumone, aba sa mwingene mu mulenen̄i mbamu kuwana ni mulume woyo oshimbile ekomoki no meyi mi mumukon̄e mu ndoo eyo sakaingene, ");
INSERT INTO lyn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","cwale mwambele omunya ndoo nji, ‘Omwiyeti kame aamba kwa wene nji, kubine oko kuli omusiyo no angenda oko sa nilyele epaseka na iyetwa ange?’ ");
INSERT INTO lyn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Cwale mbami monise omusiyo munene na kuwilu ona wabisiwa wino oko cwale mukalukise einu yonje.” ");
INSERT INTO lyn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Cwale sebeli aata nukawana kanyi omo ana ambelele Jesu, mi sebeli alukisa eilya no paseka. ");
INSERT INTO lyn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Cwale enako aba ina kukwana sebeli oikala ku tafuke na tumiwa aye. ");
INSERT INTO lyn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Cwale sebeli wamba kwa onyene nji, “Kame niwabelelwe onene okulya epaseka eyi naanyi abo me kani siyanda kale. ");
INSERT INTO lyn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kakuli kame nimyambela nji sitamba kuulya kame konji aba saiiyatetetwe mu muboso wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Cwale Jesu sebeli oshimba ekomoki, mi aba ana kumana oukutumela sebeli wamba nji, “Mushimbe esi mi mu kutabele mukaci kenu, ");
INSERT INTO lyn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","kakuli kame nimyambela nji okutunda balelo sitamba kunwa embuya no waine konji omubuso wa Nyambe aba sa ukeyele.” ");
INSERT INTO lyn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Cwale Jesu sebeli oshimba esinkwa mi abana mana oukutumela sebeli osipatola ni kusiba kwa onyene mane ni kwamba nji, “Olu ni lutu lwange luna biwi kwaanyi. Mutende esi memu ni puluka.” ");
INSERT INTO lyn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mi kame mundila imweya sebeli waba ekomoki munyima no mulalelo ni kwamba nji, “Eyi ekomoki no unyinga wange ina itelelwe aanyi ni ulikani no ubya. ");
INSERT INTO lyn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kono komumone elyoko lya woyo oni beteka kame lili ni mene ba tafule. ");
INSERT INTO lyn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kakuli Omwana no munu kame ata kanyi omo kun̄olelwe, kono oumai niwa woyo omubeteka. ");
INSERT INTO lyn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Cwale sebeli atangisa okwibanguta mukaci koo nji anyine mukaci ketu woyo ofanena okutenda eyi. ");
INSERT INTO lyn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Etin̄ananyi sebeli tiinguka mukaci koo nji omunene nanyine. ");
INSERT INTO lyn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesu sebeli wamba kwa onyene nji, “Ambumu no asimacaba kame akubabaza nji kame akwite amaata mukaci koo, mi abusisi kame aku babaza nji alikani no aanu.’ ");
INSERT INTO lyn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kono kasangeeso kwaanyi, cwale aanyi mulesele awo no kuneneba mukaci kenu atende kanyi anyonyo, mane omwendisi kanyi woyo wasebeleza. ");
INSERT INTO lyn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Cwale omunene naanyine woyo oikalile ba tafule simba nji woyo wabelekela? Kana kasa nji woyo oikalile ba tafule, kono kame nili naanyi kanyi woyo omi belekela. ");
INSERT INTO lyn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Anyi kame muli awo ana kwikala nange mu miliko yange, ");
INSERT INTO lyn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","mi cwale kame ni mituma kanyi sitange omo ana ku nitumena mu litunga. ");
INSERT INTO lyn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kame sa mulye mane ni kunwa ba tafule mu mubuso wange, mane ni kwikala ba lubona lwange okwatula amasika likumi na yiili no Isilaele. ");
INSERT INTO lyn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simoni, Simon! Komone! Satani nai saele nji amyuuluse kanyi uloto. ");
INSERT INTO lyn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kono kame nina milapelele nji etumelo yenu ilese kubwa. Mi cwale abasa mwiye kwa mene mongote abeenu. ");
INSERT INTO lyn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Cwale Pitolosi sebeli wamba kwa onyene nji, “Mbumu, kame nikutukisite okuta nowe mu tolongo mane ni ku lifu. ");
INSERT INTO lyn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Cwale Jesu sebeli wamba nji, “Kame ni kwambela Pitolosi nji omukombwe kautamba kukuwa balelo lino mbu nikana twaatu.” ");
INSERT INTO lyn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Cwale Jesu sebeli wamba kwa onyene nji, Cwale aba nina kumituma oku nambulwa esikwama simba esipaupau simba etinjatangwa siikene muna kuulwa? Seli amba nji “Kakwisa.” ");
INSERT INTO lyn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Cwale Jesu sebeli wamba kwa onyene nji, “Woyo okwite esipusu asishimbe mane ngeeso ni woyo okwite esipaupau ashimbe mi woyo wakwite omukwale aulise esikumango saye aule mumweya. ");
INSERT INTO lyn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kakuli kame nimyambela nji elin̄olo eli kame lifanena okwiiyatetetwa mwa mene elyo lyamba nji, ‘Kame ana balelwe kwiisinyi, Kakuli eyange eyo ina n̄oliwa sebeli ikwiyateteta.” ");
INSERT INTO lyn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Cwale sebeli aamba nji, “Omone! Mbumu, ino emikwale yiili!” Cwale sebeli wamba kwa onyene nji, “Naku kwana!” ");
INSERT INTO lyn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Cwale Jesu sebeli otunda, ni kuta kanyi omo kuna kutendela nji omukwa waye, ku lilundu no itondo no Olibe, aiyetwa aye sebeli amukon̄a ");
INSERT INTO lyn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Cwale aba ana kukeela ba sibaka Jesu sebeli wamba kwa onyene nji, “Mulapele nji cwale mulese okwingena mu miliko.” ");
INSERT INTO lyn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Cwale sebeli osheeta okutunda kwa onyene esibaka sikwana ba myeendo no liwee aba likondiwa ni kukubama banji ni manwi sebeli olapela nji, ");
INSERT INTO lyn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Sitange,” nji kame osinga, otundise esinweno esi kwa mene, kulese okutendiwa eso sisingwa kwa mene, kono eso sisingwa kwa wene.” ");
INSERT INTO lyn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Cwale elingeloi sebeli liiya okutunda ku wilu mukumoongota. ");
INSERT INTO lyn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Cwale yoli mu n̄alelwa no kuneneba sebeli otwalelela okulapela onene, mane esitukutuku saye sebeli sitenda kanyi ounyinga wooyela banji. ");
INSERT INTO lyn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Cwale aba ana kumana okulapela, sebeli oiya kwa iyetwa aye nu kawana alanganine mulibaka no kweena. ");
INSERT INTO lyn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Cwale sebeli wamba kwa onyene nji, “Iikene aba mulanganine? Mwinguke mulapele nji mulese okwingena mu miliko.” ");
INSERT INTO lyn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Abo yo silemine okwamba sebeli kwiiya enyangela no aanu ni mulume oisaniwa nji Judasi mumweya nwawo no kukwana likumi na yiili, yoatwaletete. Cwale sebeli osheeteta abeebi kwa Jesu ni kumutubeta. ");
INSERT INTO lyn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kono Jesu sebeli wamba kwa onyene nji, “Judasi iikene aba obeteka Omwana no munu okumutubeta?” ");
INSERT INTO lyn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Cwale awo ana kwikala naye aba ana kumona eyo ina kutendahala, sebeli amba nji, “Mbumu tulwe ni mikwale yetu?” ");
INSERT INTO lyn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Cwale omunjili mwa onyene sebeli oyaa omubika no mupulisita omukulu niku mupatula elitwi lyaye no silyo. ");
INSERT INTO lyn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kono Jesu sebeli wamba nji, “Kulese kame okutendahala ngeesi! Cwale sebeli olema elitwi lyaye ni ku mubalisa. ");
INSERT INTO lyn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Cwale Jesu sebeli wamba kwa pulisita akulu na endisi no ndoo ya Nyambe na kulu awo ana kwiiya muku mulwisa nji, “Kame muneeyi kanyi kame mulwisa ombuyi ni mikwale mane ni milamu? ");
INSERT INTO lyn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kono aba nina kwikalanga naanyi amaywaa onje mu Ndoo ya Nyambe, kamu si kunilemanga. Kono ino enako yenu, ni maata no woyo no osiuwi. ");
INSERT INTO lyn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Cwale sebeli anunga Jesu ni kumutwala mu ndoo no mupulisita omukulu. Pitolosi yo mukon̄a munyima abano kuleba. ");
INSERT INTO lyn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Cwale abana mana okutumbula omulilo mu lilapa no kuta ni kwikala banji bamweya, Pititolosi sebeli oikala mukaci koo. ");
INSERT INTO lyn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Cwale omubeleki no mukati aba ana kumona yo ikalile mu liseli, sebeli omwaliketa ni kwamba nji, “Wuyu mulume ni yonyene mumweya wa Jesu!” ");
INSERT INTO lyn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kono sebeli okana ni kwamba nji, “Wene wo mukati, mene si muyii!” ");
INSERT INTO lyn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aba kuna kubita enako icana omunu munjili sebeli omumona ni kwamba nji, “Ni wene kame oli mumweya wa onyene!” Kono Pitolosi sebeli wamba nji, “Wene we mulume, kasa mene!” ");
INSERT INTO lyn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aba kuna kubita enakao icana omunji kame sebeli oongoteta okwamba nji, “Ni yonyene wuyu mulume mumweya waye, kakuli ni yonyene, Mugalileya!” ");
INSERT INTO lyn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kono Pitolosi sebeli wamba nji, “Wene we mulume, siyii eso wamba!” Cwale ababo yo samba omukombwe sebeli okuwa. ");
INSERT INTO lyn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Cwale Jesu sebeli okusetuka ni kwaliketa Pitolosi, cwale Pitolosi sebeli opuluka amaywi ana kwamba Jesu kwa yonyene nji, “Omukombe owakasikuwa kale balelo mbuni kana twaatu.” ");
INSERT INTO lyn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Cwale sebeli ota kundee nu kalila onene. ");
INSERT INTO lyn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Cwale alume awo ana kulema Jesu sebeli amuyandisa mane ni kumufula. ");
INSERT INTO lyn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Cwale sebeli amununga ku miyo ni ku mwibanguta nji, “Onuhe! anyine ona kufulu?” ");
INSERT INTO lyn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Cwale sebeli aamba amaywi anjili no kupula no kashwau kwa yonyene oku munyefula. ");
INSERT INTO lyn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cwale eliywaa aba lina kukeela omukopano no akulu no apulisita na n̄oli sebeli akuwana bamweya. cwale sebeli atwala Jesu ba kuta yoo ni kwamba nji, ");
INSERT INTO lyn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nji ya wene Kilesite, otwambele?” Kono Jesu sebeli wamba kwa onyene nji, “Nji ni myambele, kamutamba kupumena, ");
INSERT INTO lyn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","cwale nji ni mibangute ka mutamba ku ni tambula. ");
INSERT INTO lyn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kono okutunda bano Omwana no munu kame saikale ku lyoko no silyo no maata a Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Cwale onje sebeli aamba nji, “Ya wene cwale Omwana Nyambe? Mi Jesu sebeli wamba kwa onyene nji, “Na mwamba ya mene.” ");
INSERT INTO lyn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Cwale sebeli aamba nji, “Ka upaki tusi saela kame! Natu kuyupele twenyene okutunda mu kanwa kaye!” ");
INSERT INTO lyn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Cwale esikwata sonje sebeli siimana ni kutwala Jesu kwa Pilato. ");
INSERT INTO lyn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Cwale sebeli atateka oku mukandimeka aamba nji, “Kame tuna wana wuyu mulume yo yaulula aanu ni kutukanisa nji tulese okuba omutelo kwa Sesale mane ni kwamba nji yonyene yokame Kilesite Ombumu.” ");
INSERT INTO lyn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Cwale Pilalto sebeli omwibanguta nji, “Kana ya wene Ombumu no Majuda? Cwale Jesu sebeli otambula nji, “Nwaamba.” ");
INSERT INTO lyn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Cwale Pilato sebeli wamba kwa Pulisita akulu naanu no kupula nji, “Kanisiwana omubonda mwa wuyu omulume.” ");
INSERT INTO lyn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kono sebeli aongoteta okwamba nji, “Kame afilikanya aanau yo iyeta mu Judeya monje, okutunda mu Galileya mane ni kukeela kuno ku sibaka.” ");
INSERT INTO lyn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cwale Pilato aba ana kuyupa eyi, sebeli oibanguta nji, “Wuyu mulume neli Mugalileya?” ");
INSERT INTO lyn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Cwale abana kuyupa nji Jesu kame atunda mu mubuso wa Heloda, sebeli omutumena kwa Heloda ona kwikalanga mu Jelusalema ba nako eyo. ");
INSERT INTO lyn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Cwale Heloda aba ana kumona Jesu sebeli owabelelwa onene kakuli kame ana kushukelanga onenene oku mumona, kakuli na kuyupa eyaye mi kame ana kusepa nji atende emakazo injili. ");
INSERT INTO lyn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Cwale Heloda sebeli oibanguta Jesu etipuzo no kupula, kono yonyene kasi kutambula. ");
INSERT INTO lyn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Akulu no apulisita na n̄oli sebeli aimana balubala lwa Jesu niku mukandimeka. ");
INSERT INTO lyn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heloda ni maslole aye sebeli ayandisa Jesu ni ku mushubaula mane ni kumufuka olwambi no kubenya ni kumuusa kwa Pilato. ");
INSERT INTO lyn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Okutunda ba liywaa elyo Heloda ni Pilato sebeli akulema oulikani, naba ano kutimbanga onene kunyima. ");
INSERT INTO lyn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato cwale sebeli oisana bamweya apulisita akulu na busisi naanu, ");
INSERT INTO lyn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ni kwamba kwa onyene nji, “Kame muna liti wuyu mulume ni kwamba nji kame ayembulula aanu. Cwale aba nina mwibanguta balubala lwenu esawana omubonda mu yaambo yenu mumu kandimeka. ");
INSERT INTO lyn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Simba Heloda ni yonyene namono ngeeso, sana muusete kwaaci. Komumone, kakwisa omubonda ana tende owo ofanena elifu. ");
INSERT INTO lyn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Cwale kame sa ni mufule ni ku mu lukuluka.” ");
INSERT INTO lyn_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kakuli Pilato na kufanena okwa lukulwela omunjili ba nako no mukiti. ");
INSERT INTO lyn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kono onje sebeli akuwa nji, Aibaiwe! Otulukulwele Banabasi!” ");
INSERT INTO lyn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Omulume ona kubeekiwa mu tolongo mulibaka no mifilifili ana kwingula mu mulenen̄i ni kwibaa.) ");
INSERT INTO lyn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato sebeli wamba noo kame, mukusinga nji alukulule Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kono sebeli akuweleza onene nji, “Angongoteliwe! Angongoteliwe!” ");
INSERT INTO lyn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sebeli kame wamba noo aka no waatu nji, “Iikene, eso no kwiiba ana tende? siikene esiyi eso ana tende? Mene kakwisa omubonda nina wana mwa yonyene owo ofanena elifu, kame sani mufule ni ku mulukulula.” ");
INSERT INTO lyn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kono onje sebeli amba mu kukuweleza nji angongoteliwe, mi okusinga koo sebeli kwiyatetetwa. ");
INSERT INTO lyn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Cwale Pilato sebeli watula nji kutendiwe omo mu singela. ");
INSERT INTO lyn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Cwale sebeli olukuluka omulume ona kubekiwa mu tolongo mulibaka no mifilifili ni kwibaa, woyo ana kukumbela, kono sebeli waaba Jesu mukusinga koo. ");
INSERT INTO lyn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Cwale aka mutwalile sebeli alema Simoni na ku Sillene, woyo ona kwiiya okutunda ku naha indina. Sebeli amushimbisa esifapano munyima ya Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Aanu no kupula sebeli amukon̄anga munyima na akati alila nukufula ba saali mulibaka lyaye. ");
INSERT INTO lyn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kono Jesu sebeli okutemuna ni kwamba kwa onyene nji, “Aana no akati no Jelusalema, mulese ku lila mene, kono mukulile mwenyene naanenu. ");
INSERT INTO lyn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kakuli komumone amaywaa akeyile abo aanu saambe nji, ‘Embuyoti yawo akati no kwaleye, ni mapumo awo nokwa kushimba mane ni maele awo no kwayamwisa!’ ");
INSERT INTO lyn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Cwale kame satateke okwamba ku malundu nji, ‘Mutukwele beulu!’ mane ni ku tulundu tucana nji, ‘Mutufuke!’ ");
INSERT INTO lyn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kakuli nji atende eyi abo eitondo esili eyi no kuyuba, ngasibine saku tendahale aba saikukute?” ");
INSERT INTO lyn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Eikebenga yiili no alume sebeli aishimba bamweya naye nji akaibae ni Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Cwale abana kukeela ba sibaka siisaniwa nji Katendele ababo sebeli amungongotela bamweya ni ikebenga yiili. Mi esikebenga esinjili ku lineku no silyo esinjili ku simoo. ");
INSERT INTO lyn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Cwale Jesu sebeli wamba nji, Sitange, waa lemene, kakuli kayii eso atenda.” Cwale sebeli akutabela eibyana yaye mu kushebuluka. ");
INSERT INTO lyn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Cwale aanu sebeli aimana aalikete. Kono abusisi sebeli anyefula Jesu ni kwamba nji, “Kame ana ku yoyisanga aanu cwale akuyoyise yonyene nji ya Kilesite wa Nyambe, woyo ana kuketa!” ");
INSERT INTO lyn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Amasole nonyene sebeli amuyandisa ni kwiiya kwa yonyene ni kumuba ebeine, ");
INSERT INTO lyn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ni kwamba nji, “Nji yawene Ombumu no Majuda okuyoyise wenyene!” ");
INSERT INTO lyn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mi beulu yaye kame kuna kun̄oliwa elin̄olo nji, “Wuyu ya Mbumu no Majuda,” ");
INSERT INTO lyn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Esinjili no sikebanga eso sina kungongoteliwa ni Jesu sebeli saamba nji, “Kawene Kilesite? Okuyoyise mane naaci otuyoyise!” ");
INSERT INTO lyn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kono esinjili sebeli simukalimela ni kwamba nji, “Kucili Nyambe, kakuli wene kame oli mu katulo imweya no kufanena okufa. ");
INSERT INTO lyn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Cwale kame tufanena kakuli kame tutambula omupuzo no eyi tunatende, kono wuyu mulume kasitenda esi no kwiiba.” ");
INSERT INTO lyn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Cwale sebeli wamba nji, “Jesu oka nipuluke abo so kaingene mu mubuso wowe!” ");
INSERT INTO lyn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesu sebeli wamba kwa yonyene nji, “Niti luli kame ni kwambela nji balelo kame so kaikale ni mene mu Paladaisi.” ");
INSERT INTO lyn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kame ina ku kwana enako no munji mi ouwi sebeli ufuka enaha yonje mane konji okakeela ba hola no utanu ni tunee (9) ");
INSERT INTO lyn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","mi eliywaa sebeli liilola, cwale olwambi luna ku tulekiwangwa mu keleke sebeli lukauka bakaci. ");
INSERT INTO lyn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Cwale Jesu abana mana okulila ni mulumo munene sebeli wamba nji, “Tate mu maoko owe mwa nibeeka emebo yange!” Cwale abana mana okwamba eyo, sebeli ooyela aka no mamaneneno. ");
INSERT INTO lyn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Cwale omutateleli abana kumona eso sina tendahala sebeli oyeema Nyambe ni kwamba nji, “Niti luli wuyu mulume muwa kakwite omubonda!” ");
INSERT INTO lyn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Cwale oundi ona kuungana ba sibaka aba ona kumona eso sina kutendahala, cwale sebeli auka ku mindi alemine ba yaali aenine onene. ");
INSERT INTO lyn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Cwale onje awo ana kulimukanga Jesu nakati ana kumukon̄a okutunda ku Galileya sebeli aimana oku no kuleba alikete einu eyi. ");
INSERT INTO lyn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Cwale kame kuna kwikalanga omulume no litina lya Josefa na ku Alimateya etolopo no Mujuda. Neli omunjili no manduna no Kuta, omulume no kuluka ni uwaa, ");
INSERT INTO lyn_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","woyo kasi kutenda esi no kwiiba, kono kame ana kusaelanga omubuso wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Woyo mulume sebeli ota kwa Pilato nuka kumbela olutu lwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cwale sebeli oshimba olutu lwa Jesu ni ku lupungela mu lwambi no likena ni kumubeeka mu liyumbelo omo kaku sikupumbekiwamo kale omunu. ");
INSERT INTO lyn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mi neli eliywaa no ukutukiseta omukiti no Pumulo nji otateke. ");
INSERT INTO lyn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Akati ana kumukon̄a Jesu okutunda ku Galileya sebeli amona eliyumbelo omo ana kulangeka Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Cwale sebeli auka okalukisa emitondo ni maati no kumuwaa ba lutu. Ba liywaa no Pumulo sebeli apumula okukumanena ni mulawo. ");
INSERT INTO lyn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kono cwale ba liywaa no matatekelo no sunda amasikusiku akati sebeli ata ku liyumbelo, okutwala emitondo ana kuula. ");
INSERT INTO lyn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Cwale sebeli akawana eliwee nali tundisiwa ba liyumbelo, ");
INSERT INTO lyn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","kono aba ana kwingena mu liyumbelo kasi kuwana olutu lwaye. ");
INSERT INTO lyn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Asikomokile eyo sebeli amona alume ayiili aimanine aku mangile eikumango no kumyamyata. ");
INSERT INTO lyn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Cwale asikomokike ni kwinamena etimala banji, alume sebeli amba kwa onyene nji, “Iikene aba musaela wuyu no kuyoya kwaafu? ");
INSERT INTO lyn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kamupuluke eyo ana kumyambela Jesu yosili mu Galileya. ");
INSERT INTO lyn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Nji Omwana no munu kame sabeekiwe mu maoko no aanu asikutenda esibi, mane angongoteliwe, mi liywaa no waatu ainguke.’” ");
INSERT INTO lyn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Cwale akati awo sebeli apuluka amaywi aye, ");
INSERT INTO lyn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","mi aba ana kuuka okutunda ku liyumbelo sebeli ambela ano kukwana likumi ni mumweya ni kwaanu onje eyo ina tendahala. ");
INSERT INTO lyn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Cwale neli Maliya Magdalena ni Jo-anna ni Maliya inawaye Jakobo na njili akati sebeli aamba eyi kwa tumiwa. ");
INSERT INTO lyn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kono amaywi aa kame ana kumonahala kwa onyene nji matangu mi kasi kwapumena. ");
INSERT INTO lyn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kono Pitolosi sebeli oimana ni kwitukela ku liyumbelo aka nangelamo, kono sebeli okawana feela olwambi ana kupungeliwamo mi Jesu kasamo. Sebeli ouka yo komokile esi sina tendahala. ");
INSERT INTO lyn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ba liywaa elyo ayiili kwawo ana ku kon̄anga Jesu sebeli ata ku mundi wisaniwa nji Emausi ibima ikwana itanu ni yiili okutunda ku Jelusalema, ");
INSERT INTO lyn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","alemine okwambota kwiinu yonje eyo ina tendahala. ");
INSERT INTO lyn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Alemine okwamba nu kwambota bamweya, Jesu ni yonyene sebeli osheeteta ni kuta noo. ");
INSERT INTO lyn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kono amiyo oo sebeli akwangwwa oku mulimuka, ");
INSERT INTO lyn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesu sebeli wamba nji, “Iikene mukwambota me mweenda?” Cwale sebeli aimana ni kumonahala okweena. ");
INSERT INTO lyn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cwale omunjili mukaci koo, osilitina lya Kileopasi sebeli otambula Jesu nji, “Wene wemboci feela ongenda nokwalimuka eyo ina tendahala mu Jelusalema mu maywaa ano?” ");
INSERT INTO lyn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jeau sebeli wamba kwa onyene nji, “Iikene einu eyo? mi sebeli aamba nji, “Okukumanena neyi ya Jesu no Nazaleta,” woyo ona kutendanga omunuhi wa Nyambe mu musebezi ni liywii balubala wa Nyambe naanu onje. ");
INSERT INTO lyn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Omo apulisita etu no akulu na busisi omo ana kumutwalela nji aibaiwe ni kungongoteliwa. ");
INSERT INTO lyn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kono kame tuna kusepa nji yoso yoyisa Isilaele! Ee, mi komone munyima no eyi, sebeli maywaa aatu okutunda abo ina kutendahalela eyi. ");
INSERT INTO lyn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Cwale akati no sikwata setu nakutu komokisa, kakuli kame ana kwikala ku liyumbelo amasiku-siku. ");
INSERT INTO lyn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kono kasi kuwana olutu lwaye, cwale sebeli auka aamba nji kono kame ana kumona epono no mangeloi awo ana kwamba nji kame ayoya. ");
INSERT INTO lyn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mu sikwata setu anjili sebeli ata ku liyumbelo nu kawana kanyi eso ana kwamba akati, kono yonyene kasi kumumona.” ");
INSERT INTO lyn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Cwale Jesu sebeli wamba kwa onyene nji, “Anyi alume no aelo no micima no kwapumena wangu yonje eyo ana kwamba anuhi a Nyambe! ");
INSERT INTO lyn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kana kasi kulukela nji Kilesite ayandele einu ni kwingena mu kanya yaye?” ");
INSERT INTO lyn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Cwale okutateka kwa Mushe nanuhi onje a Nyambe na kwatolokela mu man̄olo onje okukumanena ni Jesu. ");
INSERT INTO lyn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Cwale aba ana kusheeteta abeebi ni mundi ana kuta, Jesu sebeli omonahala yoli balubala loo, ");
INSERT INTO lyn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","kono sebeli amuusa ni kwamba nji, “oikale naaci kakuli sebeli mangolwaa mi eliywaa lyaika kale.” Cwale sebeli ota okaikala noo. ");
INSERT INTO lyn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Cwale yoli noo ba tafule sebeli oshimba esinkwa ni kusifuyola ni kusipatoola mane ni kwaaba. ");
INSERT INTO lyn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Cwale amiyo oo sebeli atona ni kumulimuka nji ya Jesu, kono sebeli opicuka mukaci koo. ");
INSERT INTO lyn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Cwale sebeli akwambota mukaci koo nji, “Kandi ngasibine emicima yetu kai simatuka aba ana mbanga naaci mu ndila, abo mane yo tubalela aman̄olo?” ");
INSERT INTO lyn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Cwale sebeli aimana mu nako eyeyo ni kuuka ku Jelusalema, nukawana ano kukwana likumi ni mumweya aunganine bamweya nawo ana kwikalanga noo, ");
INSERT INTO lyn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ona kwamba nji, “Ombumu nainguka luli mi namonahala kwa Simoni!” ");
INSERT INTO lyn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Cwale sebeli aamba eyo ina tendahala mu ndila, mane nomo ana kumu limukela ba kupatoola esinkwa. ");
INSERT INTO lyn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Asilemine okwamba eyi, Jesu yonyene sebeli oimana mukaci koo. ");
INSERT INTO lyn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Sebeli acila onene oku yambuta nji mwendi silumba ana mono. ");
INSERT INTO lyn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Sebeli wamba kwa onyene nji, “Iikene eyo mukukataleza mane nuukwibanguta etipuzo mu micima yenu.? ");
INSERT INTO lyn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Komumone amaoko ni makondo nji yamene, komuni leme kakuli esilumba kasikwite olutu simba eifuba kakuli mene mumwine nji nikwite.” ");
INSERT INTO lyn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kame ana kwamba eyi ni kwamonisa amakaa aye ni makondo aye. ");
INSERT INTO lyn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Asiulwile okupumena, mulibaka no ku wabelelwa, ni kukomoka, sebeli wamba kwa onyene nji, “Mukwite esi no kulya?” ");
INSERT INTO lyn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sebeli amuba eseemba no ndi no kukon̄ela, ");
INSERT INTO lyn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","mi sebeli oshimba ni kulya balubala woo amwine. ");
INSERT INTO lyn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Cwale sebeli wamba kwa onyene nji, “Aa amaywi ange awo nina kwamba kwaanyi meni sili nenu nji yonje eyo in̄olilwe mu mulawo wa Mushe nanuhi a Nyambe ni mu lisamu iiyatetetwe.” ");
INSERT INTO lyn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Cwale Jesu sebeli oyatulula etingana too nji ayupisise aman̄olo, ");
INSERT INTO lyn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","cwale sebeli wamba kwa onyene nji, “Esi sokame sin̄olilwe nji Kilesite afanene okuyanda nji eli no waatu ainguke kwaafu, ");
INSERT INTO lyn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","mi nji okubaka ni kulemeniwa eibi iyitiwe mu litina lyaye mu tinaha tonje okutateka mu Julusalema. ");
INSERT INTO lyn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aanyi muli apaki no inu eyi. ");
INSERT INTO lyn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Cwale komumone, kame nituma esepiso ya sitange kwaanyi, kono mwikale mu mulenen̄i okutwala abo samu katambulele amaata atunda ku wilu. ");
INSERT INTO lyn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Cwale Jesu sebeli washimba ni kuta ku Betaniya, cwale sebeli oimeka amakaa aye ni kwa fuyola. ");
INSERT INTO lyn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ababo yo lemine okwa fuyola sebeli waasiya ni ku shimbelwa kuwilu. ");
INSERT INTO lyn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Cwale sebeli auka ku Jelusalema awabelelwe onene, ");
INSERT INTO lyn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","cwale sebeli atwalelela mu Ndoo ya Nyambe alumbeka Nyambe.");
INSERT INTO lyn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ku simuluho kame kuna kwikala Eliywi, mi Eliywi kame lina kwikala ni Nyambe, mi Eliywi neeli Nyambe. ");
INSERT INTO lyn_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kame ana kwikala ku simuluho ni Nyambe. ");
INSERT INTO lyn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Einu yonje kame ina tendiwa mwa yonyene, mi kweyi ina tendiwa kakwisa esinu no kwaa tendiwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mwa yonyene kame kuna kwikala omooyo, mi omooyo neli eliseli no aanu onje. ");
INSERT INTO lyn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Eliseli kame libenya mu uwi, mi ouwi kawasikoma eliseli. ");
INSERT INTO lyn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kame kuna kwikala omunu ona ku tumiwa okutunda kwa Nyambe, mi elitina lyaye neli Jowani. ");
INSERT INTO lyn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kame ana kwiyela oupaki, mukupaka eyi no liseli, nji mwa yonyene aanu onje apumene. ");
INSERT INTO lyn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kasa nji yokame eliseli kono kame ana kwiiya mu kupaka eino liseli. ");
INSERT INTO lyn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Neli eliseli no niti elyo limonyekela omunu yonje woyo oiya mu litunga. ");
INSERT INTO lyn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Na kwikala mu litunga, mi elitunga kame lina tendiwa mwa yonyene, mi elitunga kalisi ku mulimuka kale. ");
INSERT INTO lyn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kame ana kwiiya ku naha yaye, mi aanu aye kasi kumu tambula. ");
INSERT INTO lyn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kono kwa onyene onje ana kumu tambula, awo ana kupumena mu litina lyaye, kame anaabi amaata no kutenda aana a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Awo na kwa leiwa ku unyinga, simba etakazo no unu, simba oku singa kwa munu, kono oku singa kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Cwale Eliywi sebeli litendiwa omunu ni kuyaka mwaaci, yo iyalile esishemo ni niti, mi kame tuna kubuha ekanya yaye, eili ekanya eyi ilukela Omwana no libanda woyo otunda kwa Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jowani kame ana ku paka eyaye niku kuweleza nji, “Yokame woyo nina kwamba nji, ‘Woyo oniiya munyima kame anibita, kakuli kame ana kwikalako oweli kwa mene.’ ” ");
INSERT INTO lyn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Cwale mu kwiyala kwaye kame tuna wana tonje, esishemo esi siekeza ba sishemo. ");
INSERT INTO lyn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kakuli omulawo na ukwiiya mu libaka lya Mushe, esishemo ni niti kame ineeyi mu libaka lya Jesu Kilesite. ");
INSERT INTO lyn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kakwisa omunu onaku monabo Nyambe. Konji Omwana feela, woyo oli ba saali sa Sitaye, yo kame woyo ona mutende nji alimukiwe. ");
INSERT INTO lyn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Cwale uno oupaki wa Jowani, aendisi no Majuda aba ana kutuma apulisita ni Malebi okutunda ku Jelusalema okwiiya muku mwibanguta nji, “Tiwe anyine?” ");
INSERT INTO lyn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jowani sebeli opumena, kasikukana, kono sebeli wamba nji, “Kasa mene Kilesite.” ");
INSERT INTO lyn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Cwale sebeli amwibanguta nji, “Iikene cwale?” “Tiwe Eliya?” Jowani sebeli wamba nji, “Kokuulwa kasa mene,” “Tiwe omunuhi wa Nyambe?” Mi sebeli otambula nji, “Kokuulwa.” ");
INSERT INTO lyn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Cwale sebeli aamba kwa yonyene nji, “Tiwe anyine, nji tu limuke omo sa tu tambwele awo anatu tumu. Ikene cwale wamba mulibaka lyowe?” ");
INSERT INTO lyn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jowani sebeli otambula nji, “Time eliywi eli likuweleza mu lihalaupa, eli lyamba nji, Mu lukise endila ya MBUMU, kanyi omo anambele omunuhi wa Nyambe Isaya.” ");
INSERT INTO lyn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Cwale awo ana kutumiwa kame ana kutunda kwa Afalisi, ");
INSERT INTO lyn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","cwale sebeli aibanguta Jowani nji, “Cwale iikene aba okolobeza nji kasa wene Kilesite, simba Eliya, simba omunuhi wa Nyambe?” ");
INSERT INTO lyn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jowani sebeli waatambula nji, “Mene kame ni kolobeza ni meyi, kono omo mwaanyi kame kwimanine omunu mwaayii. ");
INSERT INTO lyn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Simba yonyene woyo oiiya munyima yange, ka nitwese oku nungutula etikwele no etinjangwa taye.” ");
INSERT INTO lyn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Eyo yonje kame ina ku tendahala mu Betani mu linjaliya lya Jodani, omo ana kwikala Jowani yo kolobeza. ");
INSERT INTO lyn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Eliywaa lina ku tatamako Jowani sebeli omona Jesu yoiya kwa yonyene, mi sebeli wamba nji, “Komumone, uno omukoko wa Nyambe woyo utundisa esibi no litunga! ");
INSERT INTO lyn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Woyo yokame nina kwamba nji, ‘Woyo oniiya munyima kame anibita, kakuli kame ana kwikalako oweli kwa mene.’ ");
INSERT INTO lyn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ni mene kanisi kumu limuka, kono aba ni neeyi mu ku kolobeza ni meyi, neeli nji amonahale kwa Isilaele.” ");
INSERT INTO lyn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mi Jowani sebeli omupaka nji, “Kame nina mono Emebo ina tundu ku wilu ikufekile kanyi elikwici mane sebeli liikala ba yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mene kani sikumu limuka, kono woyo onani tumu muku kolobeza ni meyi kame ana nambele nji, ‘Woyo so mone Emebo ishetumuka kwa yonyene niku mwikala beulu, yokame woyo so kolobeza ni Mebo No Kukena.’ ");
INSERT INTO lyn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Cwale kame nina mono, mi kameni paka nji yokame Omwana a Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Eliywaa lina kutatamako kame Jowani sebeli oimana na iyetwa aye ayiili, ");
INSERT INTO lyn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","mi aba anaku mona Jesu yoenda sebeli wamba nji, “Komumone omukoko wa Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Aiyetwa ayiili sebeli amuyupa yoamba eyi mane sebeli akon̄a Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesu aba ano kutemuna, cwale sebeli waamona amukon̄a, mi sebeli wamba kwa onyene nji, “Iikene mu saela?” Cwale sebeli aamba kwa yonyene nji, “Labbi” (okutalusa nji Mwiyeti,) “Kubine wikala?” ");
INSERT INTO lyn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesu sebeli waatambula nji, “Mwiiye mumone.” Sebeli aiya niku mona oko ana kwikalanga, mi sebeli aikala naye eliywaa elyo, kakuli neli enako no likumi ni tutanu ni kamweya (4 okuloko) no mangolwaa. ");
INSERT INTO lyn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Adiliyasi minaye Simoni Pitolosi, neli omunjili kwa iyetwa ayiili woyo ona kuyupa Jowani yo amba, mi sebeli amukon̄a. ");
INSERT INTO lyn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kame ana kutateka oweli okuwana Simoni omukulwaye ni kwamba kwa yonyene nji, “Kame tuna wana Mesiya” (okutalusa nji “Kilesite”.) ");
INSERT INTO lyn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Adiliyasi sebeli olita mukulwaye kwa Jesu. Jesu sebeli omwaliketa ni kwamba nji, “Tiwe Simoni omwana a Jowani, kame soisanwe nji Kefasi.” (Okutalusa nji, “Pitolosi.”) ");
INSERT INTO lyn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Eliywaa lina kutatamako Jesu sebeli osinganyeka okuta ku Galileya. Cwale sebeli owana Filipi ni kwamba kwa yonyene nji, “Onikon̄e!” ");
INSERT INTO lyn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Cwale Filipi kame ana ku tunda ku Betisaida, omulenen̄i wa Adiliyasi ni Pitolosi. ");
INSERT INTO lyn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi sebeli owana Natanaele ni kwamba kwa yonyene nji, “Natumu wana woyo ona n̄oliwa eyaye kwa Mushe mu mulawo mane ngeseo ana kun̄ola anuhi. Jesu no Nazaleta, omwana a Josefa.” ");
INSERT INTO lyn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaele sebeli omwibanguta nji, “Kwa sili esinjili no kuwaba esisa si tunde ku Nazaleta?” Filipi sebeli wamba nji, “Wiiye, omone.” ");
INSERT INTO lyn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesu sebeli omona Natanaele yoiya kwa yonyene, sebeli wamba eyaye nji, “Komumone omwisilaele no niti, mi mwa yonyene kakwisa esi sinyazahala!” ");
INSERT INTO lyn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaele sebeli wamba kwa Jesu nji, “Ngasibine omo onani limukele?” Jesu sebeli omutambula nji, “Filipi yokasi kwisana kale, me oikalile munji no sitondo no mukuyu kame nina kumono.” ");
INSERT INTO lyn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaele sebeli omutambula nji, “Labbi, tiwe Mwana Nyambe! Ombumu no Isilaele!” ");
INSERT INTO lyn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesu sebeli otambula Natanaele nji, “Kakuli kame nina kwambele nji kame nina kumono oikalile munji no sitondo no mukuyu, bokame aba opumena? Mbumono einu no kuneneba okubita eyi!” ");
INSERT INTO lyn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesu sebeli omwambela nji, “Niti luli kame nikwambela nji mbumono eliwilu eliyatulukile, mi amangeloi a Nyambe akambama mane niku shetumukela beulu ya Mwana no Munu.” ");
INSERT INTO lyn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ba liywaa no waatu, sebeli ku tendiwa omukiti no likwala mu Kana na mu Galileya. Mi inawaye Jesu kwana kwikala, ");
INSERT INTO lyn_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesu ni yonyene sebeli oisaniwako ku likwala na iyetwa aye. ");
INSERT INTO lyn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Cwale ewaine aba ina kubwa, inawaye Jesu sebeli wamba kwa yonyene nji, “Ewaine naibu.” ");
INSERT INTO lyn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Cwale Jesu sebeli otambula inawaye nji, “Inawange, etaba yange ni wene ibine? Enako yange kai sikeela kale.” ");
INSERT INTO lyn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Inawaye Jesu sebeli wambela abika nji, “Mutende eso asa myambele sonje.” ");
INSERT INTO lyn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Cwale kame kuna kwikala otucoo no mawee tuna kukwana tutanu ni kamweya (6) tu suminwe abo, otu tuyowelelwa mu mukwa no Majuda, akanjili ni kanjili kame kana ku shimba owima ukuma ba mwanda. ");
INSERT INTO lyn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesu sebeli waambela nji, “Mwitelemo ameyi twiiyale.” Mi sebeli atwiyata mane niku yubooka. ");
INSERT INTO lyn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesu sebeli waambela nji, “Cwale mu tekulemo mi mu twalele osi kutaba eilya no mukiti.” Mi sebeli amu twalela. ");
INSERT INTO lyn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Cwale omutabi no ilya no mukiti aba ana kwetekako ku meyi ana ku futulwa ewaine, kakuli kasi kulimuka omo ina ku tunda, (kame kuna ku limukiwa feela abika ana ku tekula ameyi), omwendisi no mukiti sebeli oisana omukwati ");
INSERT INTO lyn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ni kwamba kwa yonyene nji, “Omunu yonje kame abaanga ewaine no ku mamata oweli, mi cwale aanu aba mana okukoliwa onene, cwale okubinda aabe eyi no kwamuba, kono wene kame ona teula eyi no kuwaba konji abano!” ");
INSERT INTO lyn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yo kame emakazo no weli eyi ana kutenda Jesu mu Kana no Galileya, mi sebeli omonisa ekanya yaye, na iyetwa aye sebeli apumena mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Aba kuna kubwa eyo, Jesu sebeli oshetumuka ku Kapenauma, ni Inawaye na inaaye, na iyetwa aye, mi omo sebeli aikalamo amaywaa no kucaniba feela. ");
INSERT INTO lyn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Epaseka no Majuda aba ina kukeela abeebi, cwale Jesu sebeli okambamena ku Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ba patelo no Ndoo ya Nyambe sebeli oka wanabo asi ku ulisa etingombe ni mikoko ni tunkwilimba, naasi kucinca amali aikalile ba myuulo yoo. ");
INSERT INTO lyn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Cwale Jesu sebeli okutendela olunupa no mihala icana, mi onje sebeli waacitela ku ndee no patelo no Ndoo ya Nyambe, bamweya ni mikoko ni tingombe, ni kwitela banji amali no asikucinca mane ni ku kwisa etitafule too. ");
INSERT INTO lyn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Cwale sebeli wambela asi kuulisa otunkwilimba nji, “Mu tundise einu eyi yonje! Kamufanene okutenda endoo ya Sitange okwifutula endoo no kuuliseta!” ");
INSERT INTO lyn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aiyetwa aye sebeli apuluka cwale esi sina kun̄oliwa nji, “Kame ni liwa mu kutukufalelwa endoo ya sitange.” ");
INSERT INTO lyn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Cwale aendisi no Majuda sebeli aibanguta Jesu nji, “Ibine emakazo otu monisa nji kame oli ni maata no kutenda eyi no ngeesi?” ");
INSERT INTO lyn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesu sebeli waatambula nji, “Mu yakulule Endoo eyi, mi mene mba ni ingula mu maywaa aatu.” ");
INSERT INTO lyn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aendisi no Majuda sebeli aamba kwa yonyene nji, “Kame ina kwana emyaka makumi anee ni mutanu ni kamweya (46) ba kuyaka Endoo ya Nyambe eyi, cwale wene mbwiiyaka mu maywaa aatu?” ");
INSERT INTO lyn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kono kame ana kwamba Endoo ya Nyambe no lutu lwaye. ");
INSERT INTO lyn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Abo cwalehe aba ana kumana okwiingulwa kwaafu, aiyetwa aye sebeli apuluka nji kame ana kwaambela eyo, mi sebeli apumena elin̄olo ni liywi elyo ana kwamba Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Cwale yooli mu Jelusalema ku mukiti no Paseka, aanu no kupula sebeli apumena mu litina lyaye aba ana kumona etimakazo ana kutenda. ");
INSERT INTO lyn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kono Jesu kaasi kwasepa, ");
INSERT INTO lyn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","kakuli kame ana kulimuka aanu onje, mi kasi kusinga oupaki no munu kakuli kame ana ku limuka esi sili mu munu. ");
INSERT INTO lyn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Cwale kame kuna kwikalanga omulume no Mufalisi no litina lya Nekudemasi, omwendisi no Majuda. ");
INSERT INTO lyn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Woyo mulume sebeli oiya kwa Jesu ousiku ni kwamba kwa yonyene nji, “Labbi, kame tuyii nji yawene omwiyeti woyo otunda kwa Nyambe, kakuli kakwisa omunu otwesa okutenda etimakazo eti otenda, konji Nyambe aba ali ni yonyene.” ");
INSERT INTO lyn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesu sebeli omu tambula nji, “Niti luli kame ni kwambela nji, omunu nji kaleiwa oubya, katwese okumona omubuso wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nekudemasi sebeli wamba kwa Jesu nji, “Ngasibine saleiwe omunu yowa kulubala kale? Ninji kame saukele kame mu lipumo lya Inawaye aka leiwe aka no wiili kame?” ");
INSERT INTO lyn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesu sebeli otambula nji, “Niti luli kame ni kwaambela nji, konji omunu aba saleiwe ni meyi ni Mebo, ka twese okwingena mu mubuso wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Esi sina leiwa ku unu sa unu, mi esi sina leiwa ku Mebo sa Mebo. ");
INSERT INTO lyn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Olese okukomoka aba ni kwambela nji kame ofanene okuleyiwa oubya. ");
INSERT INTO lyn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Emebo kame ifukela omo isinga, mi kame oyupa omulumo wayo, kono kuyii oko itunda noko ita. Yo ngeeso ni ku munu yonje woyo oleilwe ku Mebo.” ");
INSERT INTO lyn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nekudemasi sebeli oibanguta Jesu nji, “Ngasibine sa itendahale eyo?” ");
INSERT INTO lyn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesu sebeli otambula nji, “Wene kame otendile omwiyeti no Isilaele, mi cwale eyi kawiyupisisa? ");
INSERT INTO lyn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Niti luli kame ni kwambela nji kame twamba eyi tu limukile, mi kame tupaka esi tuna mono, kono kutambula oupaki wetu. ");
INSERT INTO lyn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Aba nina kwambele eyi no litunga kausi pumena, ngasibine so pumene nji ni kwambela einu na kuwilu? ");
INSERT INTO lyn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kakwisa omunu woyo ona kambamene ku liwilu, konji woyo ona shetumuka okutunda ku liwilu, yonyene Omwana no munu.” ");
INSERT INTO lyn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Cwale kanyi Mushe omo ana ku tulekela enyoka mu lihalaupa, Omwana no munu ni yonyene kame afanena okutulekiwa ngeeso, ");
INSERT INTO lyn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","nji cwale omunu yonje woyo opumena mwa yonyene aikale ni mooyo no kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kakuli Nyambe kame ana singi onene elitunga, mane kame ana libi Mwanaye no libanda, nji omunu yonje woyo opumena mwa yonyene alese okufa kono aikale ni mooyo no kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kakuli Nyambe kasiku tuma Mwanaye mu litunga nji atule elitunga, kono neli nji elitunga liyoyisiwe mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Woyo opumena mwa yonyene ka atuliwa, kono woyo nokwa pumena na atuliwa kale, kakuli kasi pumena mu litina lya Mwanaye Nyambe no libanda. ");
INSERT INTO lyn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Cwale ino ekatulo, eliseli kame lineeyi mu litunga, kono aanu kame ana singi ouwi okubita eliseli kakuli emisebezi yoo niya kwiiba. ");
INSERT INTO lyn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kakuli omunu yonge woyo otenda esi no kwiiba kame atimbile eliseli mi kaiyi ku liseli nji emisebezi yaye ilese oku nyaziwa. ");
INSERT INTO lyn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kono woyo otenda eyi no niti kame aiya ku liseli, nji ku monahale emisebezi yaye nji kame itundelela mwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Aba kuna kubwa eyo, Jesu na iyetwa aye sebeli ata mu naha no Judeya. Omo sebeli oikala noo ni kwa kolobeza. ");
INSERT INTO lyn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jowani ni yonyene kame ana ku kolobeza mu Enoni, abeebi ni Salimi, kakuli ameyi kame ana kupula mo. Cwale aanu kame ana kwiyanga mane nikwakolobeza. ");
INSERT INTO lyn_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kakuli abo Jowani yokasi bekiwa kale mu tolongo. ");
INSERT INTO lyn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Cwale sebeli kwiiya etin̄ananyi mukaci no aiyetwa a Jowani ni Mujuda omunjili ba taba no kukenisiwa. ");
INSERT INTO lyn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Cwale sebeli aiya kwa Jowani ni kwamba nji, “Mwiyeti, omunu ona kwikala naye mu linjaliya no Jodani, yonyene uya ona kupaka, uno yokame kame akolobeza, mi aanu kame ata kwa yonyene!” ");
INSERT INTO lyn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jowani sebeli otambula nji, “Omunu ka twese oku tambula esinu, konji esi ana biwi ku wilu. ");
INSERT INTO lyn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Anyi mwenyene kame muli apaki ange, kame ninaamba nji, ‘Kasa mene Kilesite, kono kame nina tumiwa balubala lwaye.’ ");
INSERT INTO lyn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Woyo oli ni mukwaliwa yo mukwati, kono omulikani no mukwati, woyo oimanine ni kuyupa, kame awabelelwa onene aba ayupa eliywi no mukwati, cwalehe oku wabelelwa kwange naku petahala. ");
INSERT INTO lyn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yonyene kame afanene okweekeza, mene ni tundise.” ");
INSERT INTO lyn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Woyo wiiya okutunda ku wilu kame ali beulu no akwaye onje. Woyo otunda mu litunga ni wa litunga, mi kame aamba kanyi woyo no litunga, woyo otunda ku wilu yonyene kame ali beulu no akwaye onje. ");
INSERT INTO lyn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Woyo opaka eso ana mono neso ana yupu, kono kamu pumene oupaki waye. ");
INSERT INTO lyn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Woyo ona pumene oupaki waye kame ana ongota nji Nyambe niwa niti. ");
INSERT INTO lyn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kakuli woyo ona tumiwa kwa Nyambe kame aamba amaywi a Nyambe, kakuli Nyambe ka mubi Emebo no kwetekela. ");
INSERT INTO lyn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Sitange kame asinga Omwana, mi kame ana beeke einu yonje mu makaa aye. ");
INSERT INTO lyn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Woyo opumena mwa Mwana kame ali ni mooyo no kwaabwa, mi woyo no kwakuteka Omwana katamba okumona omooyo, kono okutweba kwa Nyambe kame kuli beulu yaye. ");
INSERT INTO lyn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Cwale Jesu aba ana kulimuka nji Afalisi kame ana kuyupa nji na kuwana ni ku kolobeza aiyetwa no kupula okubita Jowani, ");
INSERT INTO lyn_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","simba nji kasa Jesu ona ku kolobeza, kono neli aiyetwa aye, ");
INSERT INTO lyn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","cwale sebeli otunda mu Judeya ni ku ukela kame ku Galileya. ");
INSERT INTO lyn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Cwale kame ana kubita endila eyi no Samaliya. ");
INSERT INTO lyn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Cwale sebeli okeela mu mulenen̄i no Samaliya wisaniwa nji Sikale, ou uli abeebi ni litema lya Jakobo, elyo ana kuba Josefa mwanaye. ");
INSERT INTO lyn_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ba kwikalile elisima lya Jakobo, mi cwale Jesu ona ku katala mu mweendo waye, sebeli oikala banji ku nyonga no lisima. Kame ina ku singa okukwana enako no hola no utanu ni kamweya (6) akamwii luli. ");
INSERT INTO lyn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Cwale sebeli kwiiya omukati no Musamaliya mu kutekula ameyi, mi Jesu sebeli wamba kwa yonyene nji, “Onibe ku meyi ni nwee.” ");
INSERT INTO lyn_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kakuli aiyetwa aye kame ana kuta mu mulenen̄i mu kuula eilya. ");
INSERT INTO lyn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Omukati no Musamaliya sebeli wamba kwa Jesu nji, “Wene Omujuda, kame oni kumbela ameyi mene me nili omukati no Musamaliya?” (Kakuli Amajuda kasamo mu ukuwana ni Masamaliya.) ");
INSERT INTO lyn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesu sebeli otambula omukati nji, “Kambe kame ona limuka empo ya Nyambe ni woyo wamba kwa wene nji, ‘Onibe ku meyi ni nwee,’ kambe kame ona mukumbele, mi kame sa kube ameyi no mooyo.” ");
INSERT INTO lyn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Omukati sebeli wamba kwa Jesu nji, “Mbumu, ku kwite esitekuliso, mi elisima kame litungile. Kubine ona kuwana ameyi no mooyo? ");
INSERT INTO lyn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ninji kame oli no kuneneba okubita sitetu Jakobo woyo ona kutuba elisima eli, mane kame anwa mo, yonyene na naaye ni tingombe taye?” ");
INSERT INTO lyn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesu sebeli otambula omukati nji, “Woyo onwamo yonje mu meyi aa, kame safe elilyotwa kame, ");
INSERT INTO lyn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kono woyo onwa ku meyi awo sani mube, katamba okufa elilyotwa, mi ameyi sani mube kame sa futuke mwa yonyene eliweluwelu no meyi no kububa okutwala ku mooyo no kwaabwa.” ");
INSERT INTO lyn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Omukati sebeli wamba kwa Jesu nji, “Mbumu, onibe ku meyi awo, nji nilese okufa elilyotwa simba okwiiya kuno muku tekula ameyi.” ");
INSERT INTO lyn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesu sebeli wambela omukati nji, “Ote, okaisane mbumowe, mi uuke kuno.” ");
INSERT INTO lyn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Omukati sebeli otambula nji, “Mene sikwite mbumwange.” Jesu sebeli wamba kwa yonyene nji, “Esi wamba sokame aba wamba nji, ‘Sikwite mbumwange’ ");
INSERT INTO lyn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kakuli kame ona kwikala na mbumowe atanu, mi woyo oikalile naye bano kasa mbumowe kame ona amba eniti.” ");
INSERT INTO lyn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Omukati sebeli wamba kwa yonyene nji, “Molyange, kame nina mono nji tiwe omunuhi wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Asitetu kame ana ku lapelelanga ba lilundu aba, kono anyi kame mwamba nji mu Jelusalema esibaka omo afanena aanu okulapelela.” ");
INSERT INTO lyn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesu sebeli wamba kwa yonyene nji, “Mukati oni pumene, enako ikeyile abo sitange katamba oku lapelelwa ba lilundu aba simba mu Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Anyi kame mu lapela esi mwa limukile, Aci kame tu lapela esi tu limukile, kakuli oku yoyisiwa kame kutunda ku Majuda. ");
INSERT INTO lyn_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kono enako ikeyile, mane ya iya kale, abo awo alapeli no niti kame sa lapele sitange ni mebo ni mu niti kakuli okame awo asaelwa kwa Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nyambe nimebo, mi awo amulapela kame afanena oku mu lapela ni mebo ni mu niti.” ");
INSERT INTO lyn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Omukati sebeli wamba kwa Jesu nji, “Kame ni limuka nji Mesiya kame aiya woyo oisanwa nji Kilesite. Aba sa keele, mba tu monisa einu yonje.” ");
INSERT INTO lyn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesu sebeli wamba kwa yonyene nji, “Mene woyo wamba kwa wene, ya mene.” ");
INSERT INTO lyn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mu nako eyo aiyetwa aye sebeli akeela, mi sebeli akomoka oku muwana yo amba ni mukati, kono kakwisa simba mumweya ona ku mwambisa nji, “Siikene eso osaela?” Simba nji, “Iikene eyo onaamba naye?” ");
INSERT INTO lyn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Cwale omukati sebeli osiya esitekulo saye no meyi ni kuukela mu mulenen̄i, nuuka ambela aanu nji, ");
INSERT INTO lyn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mwiiye mu mone omunu woyo ona nambele eyi yonje nina tende. Mwendi yokame Kilesite?” ");
INSERT INTO lyn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Cwale sebeli atunda mu mulenen̄i ni kwiiya kwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ababo asiiya feela, aiyetwa sebeli amu kumbela nji, “Labbi, olye esinjili!” ");
INSERT INTO lyn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kono Jesu sebeli wamba kwa onyene nji, “Kame nili ni silya no kulya eso mwalimukile.” ");
INSERT INTO lyn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Cwale aiyetwa sebeli akwambela omunjili ku munjili nji, “Kame kuli omunu ona mulitele esi no kulya?” ");
INSERT INTO lyn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesu sebeli wamba kwa onyene nji, “Esilya sange ninji ni tende eso si singwa kwa woyo ona ni tumu, mi ni manenene omusebezi waye. ");
INSERT INTO lyn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Esi kame mwamba nji, ‘Ku sili ni tikweti tinee, okutwala abo sakuka yangulelwe.’ Kono kame ni myambela nji, mu none amiyo enu, mwa likete amatema, kakuli sebeli aimba ouloto nji uyanguliwe. ");
INSERT INTO lyn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Woyo oyangula kame awana mu musebezi waye, niku ungeka embuya no mooyo no kwaabwa, nji cwale woyo osikukuna ni woyo oyangula awabelelwe bamweya. ");
INSERT INTO lyn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mo kumonahalela eniti no taba eyi yaamba nji, ‘Omunjili kame akuna, omunjili kame ayangula.’ ");
INSERT INTO lyn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kame nina mi tumu oka yangula eyo ka mwa si sebeza, anjili kame ana sebeze, mi na mwingene mu musebezi woo.” ");
INSERT INTO lyn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Amasamaliya no kupula na mu mulenen̄i owo sebeli apumena mwa Jesu mulibaka no mukati woyo ona kupaka nji, “Kame ana nambele eyi nina tende yonje.” ");
INSERT INTO lyn_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Cwale Amasamaliya aba ana kwiiya kwa yonyene, sebeli amu kumbela nji aikale noo, mi sebeli oikala noo amaywaa ayiili. ");
INSERT INTO lyn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mi anjili no kupula sebeli a pumena kwa yonyene, mulibaka no liywi lyaye, ");
INSERT INTO lyn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ni kwamba ku mukati nji, “Cwale aba tu pumena, kasa mu liywi lyowe, kakuli twenyene natu kuyupele, mi kame tu limuka nji yokame luli Omuyoyisi no litunga.” ");
INSERT INTO lyn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Munyima no maywaa ayiili, Jesu sebeli oukela ku Galileya. ");
INSERT INTO lyn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kakuli Jesu yonyene sebeli wamba nji, “Omunuhi wa Nyambe kakutekiwa mu naha yaye.” ");
INSERT INTO lyn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Cwale Jesu aba ana kukeela mu Galileya, sebeli oka tambulwa wino ku Magalileya ana ku mona eyi ana kutenda yonje mu Jelusalema ku mukiti, kakuli nonyene kwana kuta ku mukiti. ");
INSERT INTO lyn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Cwale Jesu sebeli oiya kame mu Kana no Galileya, omo ana ku futula ameyi okwatenda ewaine. Cwale mu Kapenauma kame kuna kwikala onduna omunjili no molyaye woyo mwanaye neli omweeti. ");
INSERT INTO lyn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aba ana kuyupa nji Jesu neeyi mu Galileya okutunda ku Judeya, sebeli oiya kwa yonyene, ni ku mukumbela nji ashetumuke muku balisa mwanaye no mulume, kakuli kame ana kwikala abeebi ni kufa. ");
INSERT INTO lyn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesu cwale sebeli wamba kwa yonyene nji, “Konji aba sa mumone etiponiso ni timakazo okubinda samu pumene.” ");
INSERT INTO lyn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Onduna sebeli omu tambula nji, “Mbumu, oshetumuke mwanange yo kasifa kale.” ");
INSERT INTO lyn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesu sebeli wamba kwa yonyene nji, “Ote, mwanowe kame ayoya!” Omulume woyo sebeli opumena eliywi lya Jesu nuukutela. ");
INSERT INTO lyn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yosi shetumuka ngeeso, abika aye sebeli amu waniketa ni ku mwambela nji, “Mwanowe kame ayoya!” ");
INSERT INTO lyn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Cwale sebeli waibanguta enako ana ku tangisa omwana okwikala wino, mi sebeli aamba kwa yonyene nji, “Bingolwa ba nako no utanu ni twiili akamwii (13 okuloko) elitomapa sebeli limu lesela.” ");
INSERT INTO lyn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Cwale sitaye sebeli olimuka nji yokame enako ana kwamba Jesu nji, “Mwanowe kame ayoya.” Mi sebeli opumena yonyene na sindoo yaye onje. ");
INSERT INTO lyn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Eyo neli emakazo no wiili ana kutenda Jesu aba ana kwiiya mu Galileya, okutunda ku Judeya. ");
INSERT INTO lyn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Aba kuna kubwa eyo, sebeli ku tendahala omukiti no Majuda mi Jesu sebeli okambamena ku Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Cwale mu Jelusalema abeebi ni Mwelo no Mikoko, kame kuli akasa kaisanwa nji Betizata mu Sihebelu, no myelo itanu. ");
INSERT INTO lyn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mu myelo eyo kame kuna kulangana aeti no kupula, eibofu, eihole no makondo, nasi lun̄an̄ali. ");
INSERT INTO lyn_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kakuli abanjili elingeloi kame lina ku shetumukelanga mu kasa, mi kame lina kushelaulanga ameyi. Cwale omunu no weli woyo oingena mu meyi aba amana okushelauliwa, kame ana ku tuseha, simba otoma oweti ubine nji ubine. ");
INSERT INTO lyn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Omulume mumweya kame ana kwikalanga omo, ona kutoma oweti emyaka makumi aatu ni mutanu ni twaatu (38). ");
INSERT INTO lyn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Cwale Jesu aba ana kumumona ni kulimuka nji kame ana kulanganamo enako no kuleba, sebeli omwibanguta nji, “Kame osinga oku balisiwa?” ");
INSERT INTO lyn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Omweeti sebeli omu tambula nji, “Mbumu, sikwite omunu no ku ni beeka mu kasa ameyi aba amana okushelauka, aba nisinga nji niingenemo omukwange wa nisiya kale oku shetumukamo oweli.” ");
INSERT INTO lyn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesu sebeli wamba kwa yonyene nji, “Imana, oshimbe oulangano wowe, mi weende.” ");
INSERT INTO lyn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ababo omulume sebeli obala, ni ku shimba oulangano waye, mi sebeli weenda. Cwale eliywaa elyo neli elino Pumulo. ");
INSERT INTO lyn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Cwale aendisi no Majuda sebeli ambela woyo mulume ona ku balisiwa nji, “Lino ni lya Pumulo, ka kupumenenwe nji oshimbe oulangano wowe.” ");
INSERT INTO lyn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kono sebeli waatambula nji, “Omunu woyo onani balisa na nambele nji, ‘Oshimbe oulangano wowe mi weende.’ ” ");
INSERT INTO lyn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Cwale sebeli amwibanguta nji, “Anyine omunu woyo ona kwambele nji oshimbe oulangano wowe mi weende?” ");
INSERT INTO lyn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kono omunu woyo ona ku balisiwa kasi kulimuka nji anyine, kakuli Jesu kame ana kwikiseta mu kupula no aanu ana kwikala omo mu sibaka. ");
INSERT INTO lyn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kutunda abo, Jesu sebeli omu wana mu Ndoo ya Nyambe ni kwamba kwa yonyene nji, “Omone, nu bala kono olese okutenda esibi kame, mwendi esi sicilisa oku bitelela mba si kwiyele.” ");
INSERT INTO lyn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Omulume woyo sebeli ota nu kambela aendisi no Majuda nji neli Jesu ona mubalisa. ");
INSERT INTO lyn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Cwale esi sokame eso aendisi no Majuda ana kuyandiseta Jesu, kakuli na kutenda eyo eli no Pumulo. ");
INSERT INTO lyn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kono Jesu sebeli waatambuta nji, “Sitange kame asebeza enako yonje, mi ni mene kame ni sebeza.” ");
INSERT INTO lyn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Elibaka elyo aendisi no Majuda ana kusinga oku mwibaela okubita ba weli, kakuli kasi kumatuka feela omulawo no Pumulo, kono kame yonyene ni kwisana Nyambe nji Sitaye mane nuukubeeka ba siyemo simweya ni Nyambe. ");
INSERT INTO lyn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Cwale Jesu sebeli waambela nji, “Niti luli kameni myambela nji, Omwana katwese okutenda esinu yonyene, konji ana kumona Sitaye yo sitenda. Kakuli eyo atenda yonje, ni yonyene Mwana kame aitenda ngeeso. ");
INSERT INTO lyn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kakuli Sitaye kame asinga Omwana, mane kame amu monisa eyo atenda yonje, mi mba mumonisa emisebezi no kuneneba okubita eyi nji mu komoke. ");
INSERT INTO lyn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kakuli kanyi Sitange aba aingula asikufa ni kwa yoyisa, ni Mwana yongeeso kame aaba awo asinga. ");
INSERT INTO lyn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Sitange kaatula omunu, kono kame anabi Omwana etikatulo tonje, ");
INSERT INTO lyn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","nji onje awo akuteke Omwana kanyi omo akutekela Sitange. Woyo no kwakuteka Omwana ka kuteke ni Sitange ona mu tumu.” ");
INSERT INTO lyn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Niti luli kame ni myambela nji, woyo oyupa eliywi lyange ni ku pumena kwa woyo onani tumu, kame ali ni mooyo no kwaabwa. Ka tamba okwatuliwa, kono nabiti mu lifu okwingena mu mooyo. ");
INSERT INTO lyn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Niti luli kame ni myambela nji, enako kame iiya, mane yaiya kale, abo aafu kame sa yupe eliywi lya Mwana Nyambe, mi awo aliyupa mba yoyo. ");
INSERT INTO lyn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kakuli kanyi Sitange aba ali ni mooyo mwa yonyene, ni Mwana ngeeso kame ana mubi okwikala ni mooyo mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mi na mubi ni maata no kwatula, kakuli yokame Omwana no Munu. ");
INSERT INTO lyn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mulese ku komoka ba taba eyo, kakuli enako kame iiya, abo aali mu mayumbelo onje mba yupu eliywi lyaye, ");
INSERT INTO lyn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mi awo ana tende eino kuwaba aingukele omooyo, mi awo ana tende eino kwiiba aingukele ekatulo.” ");
INSERT INTO lyn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Sitwese okutenda esinu mu maata ange, kanyi aba niyupa, kame na tula, mi ekatulo yange ya kuluka, kakuli sitende esisi singwa kwa mene, kono esisi singwa kwa yonyene onani tumu.” ");
INSERT INTO lyn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nji kame ni kupaka menyene, oupaki wange kasa wa niti. ");
INSERT INTO lyn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kwaali omunjili woyo opaka eyange, mi kame niyii nji oupaki owo ani paka nawo niwa niti. ");
INSERT INTO lyn_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kame muna tumu aanu kwa Jowani, mi na paka eniti. ");
INSERT INTO lyn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kasa nji oupaki nina tambula kame onatundu ku munu, kono kame naamba feela eyo nji mu kayoyisiwe. ");
INSERT INTO lyn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yonyene neli olumonyi lu tumbuka, ni lambi eyi imonyeka, mi anyi namu singi oku wabelelwa enako icana mu liseli lyaye. ");
INSERT INTO lyn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kono oupaki nili nawo ni wa kuneneba okubitelela wa Jowani, kakuli emisebezi ana nibi Sitange oku manenena, yokame emisebezi eyi nitenda, eini paka nji Sitange nani tumu. ");
INSERT INTO lyn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Cwale Sitange ona nitumu, ni yonyene kame ana paka eyange. Eliywi lyaye ka musili yupa simba okumona omo aikalele, ");
INSERT INTO lyn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","mi eliywi lyaye kali siikala mwaanyi, kakuli woyo ona tumiwa kwa yonyene kamu mupumene. ");
INSERT INTO lyn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kame musaisisa aman̄olo, kakuli kame mu yambuta nji mba mu wanamo omooyo no kwaabwa. Aman̄olo awo okame apaka eyange! ");
INSERT INTO lyn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kono kame mukana okwiiya kwa mene nji mwikale ni mooyo no kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Sitambula okububekwa oko kutunda kwaanu. ");
INSERT INTO lyn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kono kame ni yii nji kakwisa elilato lya Nyambe mwaanyi. ");
INSERT INTO lyn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mene kame nineyi mu litina lya Sitange, mi ka mu sini tambula, nji mundina aiye mu litina lyaye feela, yonyene mbamu mu tambula. ");
INSERT INTO lyn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ngasibine sa mu pumene woyo otambula emilumbeko itunda kwaanu, mi ka musaele emilumbeko itunda feela kwa Nyambe? ");
INSERT INTO lyn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mu lese oku yambuta nji kame sani mikandimeke kwa sitange, neli Mushe woyo ona kumikandimeka, ba yonyene bamuna kubeeka esepo yenu. ");
INSERT INTO lyn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nji kame mu na kupumena Mushe, ni mene mba muni pumene, kakuli yonyene na n̄olo eyange. ");
INSERT INTO lyn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kono nji kamwa sipumena eyo ana kun̄ola, ngasibine sa mu pumene amaywi ange?” ");
INSERT INTO lyn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Aba kunabu eyo, Jesu sebeli ota mu linjaliya no liwate no Galileya, eliwate no Tibeliyasi. ");
INSERT INTO lyn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mi aanu no kupula onene sebeli amukon̄a, kakuli kame ana ku mona etimakazo eti ana kutenda kwa asikutoma. ");
INSERT INTO lyn_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Cwale Jesu sebeli okambamena ba lilundu, mi abo sebeli okaikala banji na iyetwa aye. ");
INSERT INTO lyn_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Cwale Epaseka, omukiti no Majuda kame ona kwikala abeebi. ");
INSERT INTO lyn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesu aba ana kwaliketa cwale sebeli omona aanu no kupula onene aiya kwa yonyene, mi sebeli wambela Filipi nji, “Kubine sa tuule einkwa nji cwale aa aanu awane esi no kulya?” ");
INSERT INTO lyn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Eyi kame ana kuyamba ngeeso oku mweteka, kakuli yonyene kame ana ku limuka esi ana kufanena okutenda. ");
INSERT INTO lyn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi sebeli omutambula nji, “Emyanda yiili (200) no muwaya-waya ka yuulu einkwa no kupula nji omunjili ni munjili awane esino kucaniba feela.” ");
INSERT INTO lyn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Omunjili no aiyetwa aye, Andiliyasi mina Simoni Pitolosi, sebeli wamba kwa yonyene nji, ");
INSERT INTO lyn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kame kuna kwikala ondumbana omo, ona kwikala ni inkwa itanu ni tusi twiili. Kono eyo ni iikene kwaanu no kupula ngeeso?” ");
INSERT INTO lyn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesu sebeli waambela nji, “Mwiikate aanu banji.” Abo kame kuna kwikala omoopu no kupula onene ba sibaka eso, cwale alume sebeli aikala banji, mu palo no kukwana eikiti itanu (5;000). ");
INSERT INTO lyn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Cwale Jesu sebeli oshimba einkwa, cwale aba ana kumana ouku tumela, sebeli otabela awo ana kwikala banji, mi cwale sebeli otenda ngeeso niku tindi, cwale sebeli waaba omu ana kusingela. ");
INSERT INTO lyn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Cwale aba ana kumana okwikuta, sebeli wambela aiyetwa aye nji, “Mu tole oubulumusi ona siyalabo, nji ku lese oku yumbiwabo esinjili.” ");
INSERT INTO lyn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Cwale sebeli autola mane ni kwiyata amatanda likumi na yiili no inkwa itanu, ou ona ku siiwa kwa sikulya. ");
INSERT INTO lyn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Cwale aanu aba ana kumona emakazo ana kutenda Jesu, sebeli aamba nji, “Niti luli yokame omunuhi wa Nyambe ona kufanena okwiiya mu litunga!” ");
INSERT INTO lyn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Cwale Jesu aba na limuka nji kame ana ku singa oku mulema nji atendiwe ombumu, sebeli okutela kame yomboci ba lilundu. ");
INSERT INTO lyn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Cwale aba kuna kutenda amangolwaa, aiyetwa aye sebeli ashetumuka ku liwate, ");
INSERT INTO lyn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ni kwingena mu wato, niku tangisako oku lutela mu linjaliya no liwate okuta ku Kapenauma. Neli ousiku luli, mi Jesu yoka sikeela kale kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Cwale sebeli kwinguka amandinda mulibaka no mebo ina kufuka onene. ");
INSERT INTO lyn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Aba ana kumana okupuwa etibima taatu simba tinee, sebeli amona Jesu yo enda ba liwate, ni kusheeteta ku wato, cwale sebeli acila onene. ");
INSERT INTO lyn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kono sebeli wamba kwa onyene nji, “Meene, mu lese kucila!” ");
INSERT INTO lyn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Cwale sebeli awabelelwa ni kumulonga mu wato, mi ababo owato sebeli ofuwama ba likamba abo ana kulumba. ");
INSERT INTO lyn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ba liywaa lina ku tatamako, aanu awo ana kusiyala mu linjaliya no liwate, sebeli alemuha nji kakwa siku siyala owato omunjili muya. Cwale Jesu kasi kwingena mu wato na iyetwa aye, kono aiyetwa aye kame ana kuta omboci. ");
INSERT INTO lyn_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Simbakulingeeso cwale amato anjili ana ku tunda mu Tibeliya, me akeela kale abeebi ni sibaka eso ana kulyela einkwa Ombumu aba ana kumana ouku tumela. ");
INSERT INTO lyn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Cwale aanu aba ana kumona nji Jesu kasi kwikalamo, simba aiyetwa aye, onyene sebeli aingena mu maato omo ni kuta ku Kapenauma alemine oku saela Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cwale aba ana kuwana Jesu mu linjaliya no liwate, sebeli amwibanguta nji, “Labbi, ka mwaka oneyi kuno?” ");
INSERT INTO lyn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesu sebeli waatambula nji, “Niti luli kame ni myambela nji, aba mu ni saela, kasa nji na mumono etimakazo, kono ninji na muli einkwa mane na mwikuta. ");
INSERT INTO lyn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mu lese oku sebeleza esilya eso sibwa, kono esilya eso simi twala ku mooyo no kwaabwa. Eso Omwana no Munu asa mibe, kakuli ba yonyene Nyambe Sitange kame ana mubeeke eliswayo.” ");
INSERT INTO lyn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Cwale sebeli amwibanguta nji, “Iikene satu tende, nji tu tende emisebezi ya Nyambe?” ");
INSERT INTO lyn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesu sebeli waatambula nji, “Uno omusebezi wa Nyambe nji mu pumene kwa woyo ona tumiwa kwa yonyene.” ");
INSERT INTO lyn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Cwale sebeli aamba kwa yonyene nji, “Kaike emakazo sotende nji tumone, mi tu pumene kwa wene? Kamwike omusebezi otenda? ");
INSERT INTO lyn_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Asitetu kame anali amaana mu lihalaupa, kanyi aba kun̄olilwe nji, ‘Na kwaaba esinkwa eso situnda ku wilu nji alye.’ ” ");
INSERT INTO lyn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesu sebeli waambela nji, “Niti luli kame ni myambela,” “Mushe kasi kumiba esinkwa naku wilu, kono Sitange na mibi esinkwa no niti naku wilu. ");
INSERT INTO lyn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kakuli esinkwa sa Nyambe sokame eso situnda ku wilu mi kame siba omooyo ku litunga.” ");
INSERT INTO lyn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sebeli aamba kwa yonyene nji, “Mbumu, otube esinkwa eso mu nako yonje.” ");
INSERT INTO lyn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Cwale Jesu sebeli waambela nji, “Time esinkwa no mooyo,” “Woyo oiya kwa mene ka tamba okuyomba, mi woyo opumena kwa mene katamba okufa elinyotwa. ");
INSERT INTO lyn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kono kame nina myambele nji namu nimono kono kamu sipumena. ");
INSERT INTO lyn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sonje esi aniba sitange, kame sa siiye kwa mene. Cwale woyo oiya kwa mene sitamba oku mucitela kundee. ");
INSERT INTO lyn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kakuli kame nina shetumuka okutundu ku wilu kasa mu kutenda eso si singwa kwa mene, kono esi si singwa kwa woyo ona ni tumu. ");
INSERT INTO lyn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mi sokame eso si singwa kwa woyo ona ni tumu, nji ni lese oku taukelwa ku sinjili kweeyo ana nibi yonje, kono ni iingule mu liywaa no mamaneneno. ");
INSERT INTO lyn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kakuli sokame eso si singwa kwa Sitange nji omunu yonje woyo omona Omwana ni ku pumena mwa yonyene aikale ni mooyo no kwaabwa. Mi mba ni mwingula ba liywaa no mamaneneno.” ");
INSERT INTO lyn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Amajuda sebeli an̄un̄uta mulibaka lyaye, kakuli kame ana kwamba nji, “Time esinkwa esi situnda ku wilu.” ");
INSERT INTO lyn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Cwale sebeli aamba nji, “Kasa yokame Jesu, omwana Josefa, woyo sitaye ni inawaye tu yii? Ngaibi aamba nji, kame ni tunda ku wilu?” ");
INSERT INTO lyn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesu sebeli waatambula nji, “Mu lese okun̄un̄uta mukaci kenu. ");
INSERT INTO lyn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kakwisa omunu soiya kwa mene konji aba sakokiwe kwa sitange ona ni tumu, mi mene mba ni mwingula ba liywaa no mamaneneno. ");
INSERT INTO lyn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kame ina n̄oliwa mwa nuhi a Nyambe nji, ‘Omunu yonje mba iyetiwa kwa Nyambe.’ Cwale omunu yonje woyo ona yupu mane ni kwiyetiwa kwa Sitange kame aiya kwa mene. ");
INSERT INTO lyn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kasa nji kame kuli omunu ona mono Sitange, konji yonyene woyo ona tundu kwa Nyambe yonyene ona mono Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Niti luli kame ni myambela nji, woyo opumena kwa mene kame ali ni mooyo no kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Time esinkwa no mooyo. ");
INSERT INTO lyn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Asitenu naali amaana mu lihalaupa, mi naafu. ");
INSERT INTO lyn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kono sino esinkwa esi situnda ku wilu, nji omunu olyako alese okufa. ");
INSERT INTO lyn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Time esinkwa no kuyoya, esi sina tundu ku wilu. Omunu nji alye esinkwa eso, kame sa yoye enako yonje. Mi esinkwa sa nibe oku yoyisa elitunga, enyama yange.” ");
INSERT INTO lyn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Cwale Amajuda sebeli aku kananisa mukaci koo nji, “Omunu uyu ngaibi sa tube enyama yaye nji twiilye?” ");
INSERT INTO lyn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesu sebeli wamba kwa onyene nji, “Niti luli kame ni myambela konji aba sa mulye enyama no Mwana no Munu ni kunwa ounyinga waye, omooyo kausako mwaanyi. ");
INSERT INTO lyn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Woyo yonje solya enyama yange ni kunwa ku unyinga wange, kame sa ikale ni mooyo no kwaabwa mane mbani mwingula ba liywaa no mamaneneno. ");
INSERT INTO lyn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kakuli enyama yange, silya luli ni unyinga wange wa kunwa luli. ");
INSERT INTO lyn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Woyo olya ku nyama yange ni kunwa ku unyinga wange kame ali mwa mene, ni mene mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kanyi Sitange no kuyoya aba anani tumu, mane niku yoya mulibaka lya sitange, cwale woyo onilya kame sa yoye mulibaka lyange. ");
INSERT INTO lyn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Esi sokame esinkwa sina tundu ku wilu, ka siku feke neso anali asitenu ni kufa. Woyo olya ku sinkwa esi mba yoyo enako yonje.” ");
INSERT INTO lyn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesu kame ana kwamba etaba eyo mu ndoo no milapelo kanyi omo ana kwiyetela mu Kapenauma. ");
INSERT INTO lyn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Anjili no kupula kwa iyetwa aye, aba ana kuyupa eyo sebeli aamba nji, “Omwambelo uno niwa kubambaba. Anyine so uteeteta?” ");
INSERT INTO lyn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kono Jesu naku limuka mu mucima waye nji aiyetwa aye kame an̄un̄uta ba taba eyo, sebeli wamba kwa onyene nji, “Ninji etaba eyo kame imi sitatalisa? ");
INSERT INTO lyn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Cwale ngasibine saku tendahale abasa mumone Omwana no munu yo kambamena oko ana kwikala oweli? ");
INSERT INTO lyn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Emebo yokame eyi iba omooyo, enyama ka itusu esinjili. Amaywi nina myambele okame mebo ni moyo. ");
INSERT INTO lyn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kono muno mwaanyi kwaali anjili no kwa pumena.” Kakuli Jesu kame ana kulimuka ku matangiseto awo saulwe oku pumena, ni woyo somu beteka. ");
INSERT INTO lyn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Cwale sebeli wekeza okwamba nji, “Lyo kame elibaka nina myambele nji kakwisa woyo soiya kwa mene konji woyo ona biwi ngeeso kwa Sitange.” ");
INSERT INTO lyn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Okutunda abo, ano kupula kwa iyetwa aye sebeli aukela munyima okulesa oku mukon̄a okweenda naye. ");
INSERT INTO lyn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesu sebeli wamba kwawo ana kukwana likumi na yiili nji, “Naanyi kame musinga oukutela ngeeso?” ");
INSERT INTO lyn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Pitolosi sebeli omu tambula nji, “Mbumu, kame sa tute kwa nyine? Kame oli ni maywi no mooyo no kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Cwale aci natu pumene ni kulimuka nji ya wene no Kukena wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesu sebeli waatambula nji, “Kasa mene nina mikete moonje ano kukwana likumi na yiili? Cwale omunjili kwaanyi ni mudimona!” ");
INSERT INTO lyn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kame ana kwamba Judasi Omwana Simoni Isikalioti, kakuli yokame omunjili no asikukwana likumi na yiili (12) yoso mu beteka. ");
INSERT INTO lyn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Aba ku nabwi eyo, Jesu sebeli ota yo iyeta aanu mu Galileya, kasi kusinga okuta mu Judeya, kakuli aendisi no Majuda kame ana kusinga oku mwibaa. ");
INSERT INTO lyn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Cwale omukiti no Majuda ona kwisaniwa nji Tabanakele (eikun̄wa) kame ana kwikala abeebi, ");
INSERT INTO lyn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","cwale ainaye Jesu sebeli aamba kwa yonyene nji, “Otunde muno mi ote ku Judeya, nji aiyetwa owe amone emisebezi eyi otenda. ");
INSERT INTO lyn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kakuli kakwisa omunu osebeleza ku mukunda nji kame asinga okulimukiwa wino. Nji kame otenda einu eyi, oku monahaze wenyene ku litunga!” ");
INSERT INTO lyn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kakuli simba onyene ainaye kasi kupumena mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesu sebeli wamba kwa onyene nji, “Enako yange ka isikeela kale, kono enako yenu kame iliko enako yonje. ");
INSERT INTO lyn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Elitunga kali twese oku mitimba, kono kame litimbile mene, kakuli kame nipaka emisebezi ya lyo nji niya kwiiba. ");
INSERT INTO lyn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Anyi mute ku mukiti. Mene ka niti ku mukiti owo, kakuli enako yange ka isi petahala kale.” ");
INSERT INTO lyn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aba ana ku mana okwamba eyo, sebeli osiyala mu Galileya. ");
INSERT INTO lyn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kono munyima no ainaye okuta ku mukiti, cwale ni yonyene sebeli otako, kasa mu uku monahaza, kono mu kwa limukiwa. ");
INSERT INTO lyn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Cwale aendisi no Majuda ba mukiti sebeli a musaela, ni kwibanguta nji, “Ku bine ali?” ");
INSERT INTO lyn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mi oko kame kuna kwikala onene eyi no kumooba. Anjili sebeli aamba nji, “Jesu niwa kuluka,” Anjii nji, “Kokuulwa, kame ayaukisa aanu.” ");
INSERT INTO lyn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mulibaka no kucila aendisi no Majuda kakwisa omunu ona kwamba eyaye mu kulukuluha. ");
INSERT INTO lyn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bakaci no Mukiti Jesu sebeli okambamena ku Ndoo ya Nyambe nuuka iyetamo. ");
INSERT INTO lyn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aendisi no Majuda sebeli a komoka ni kwamba nji, “Ngasibine aikalile uyu munu aba alimukile, mi ka siku kwiiyeta?” ");
INSERT INTO lyn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesu sebeli waatambula nji, “Etuto yange ka itundu kwa mene, kono kame itunda kwa woyo onani tumu. ");
INSERT INTO lyn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nji omunu omunjili kame asinga okutenda esisi singwa kwa Nyambe kame sa limuke etuto yange nji kame itunda kwa Nyambe, nji kame ni kwambela feela menyene. ");
INSERT INTO lyn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Woyo okwambela mu maata aye yonyene kame asinga ekanya yaye feela. Kono woyo osinga ekanya ya woyo ona mutumu niwa niti, mi kakwisa okwiiba mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kasa nji Mushe kasi kumiba omulawo? Kono kakwisa mwaanyi ona mamele omulawo. Iikene mu saelela okuni ibaa?” ");
INSERT INTO lyn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Aanu sebeli atambula nji, “Kame okwite edimona.” “Anyine woyo osaela oku kwibaa?” ");
INSERT INTO lyn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesu sebeli waatambula nji, “Kame nina tende omusebezi mumweya, mi moonje kame mu na ukomoka. ");
INSERT INTO lyn_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mushe na ku miba omulawo no mupato (kasa nji kame utunda kwa Mushe, kono kame utunda kwa Sitenu naku kale), mi anyi kame mu beeka omunu mu mupato eli no pumulo. ");
INSERT INTO lyn_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nji cwale eli no Pumulo omunu kame abekiwa mu mupato nji omulawo wa Mushe omameliwe, iikene muni kaniseta oku balisa omunu olutu lwaye lonje ba liywaa elino pumulo? ");
INSERT INTO lyn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mu lese okwatula ni sobozi, kono mwatule mu kuluka.” ");
INSERT INTO lyn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Cwale anjili aanu namu Jelusalema sebeli aamba nji, “Kasa yokame uyu mulume asaela okwibaa? ");
INSERT INTO lyn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mi yokame uno, kame aamba patalaza, mi kakwisa esinjili esi aamba kwa yonyene! Ninji aendisi no Majuda nalimuka nji luli yokame Kilesite? ");
INSERT INTO lyn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kono kame tuyii oko atunda wuyu munu, mi cwale Kilesite aba sa monahale, kakwisa woyo so limuka oko sa tunde.” ");
INSERT INTO lyn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Cwale Jesu sebeli wamba kanyi omo ana kwiyetela ba patelo no Ndoo ya Nyambe nji, “Kame muni limukile ni kulimuka oko ni tunda? Kono kani siku kulita menyene, woyo onani tumu niwa niti, mi yonyene mwa limukile. ");
INSERT INTO lyn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mene ni muyii, kakuli kame ni tunda kwa yonyene mi yokame onani tumu.” ");
INSERT INTO lyn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Cwale sebeli aeteka oku mununga, kono kame kuna kuulwa omunu no ku mulema, kakuli enako yaye kaya si kukeela kale. ");
INSERT INTO lyn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Cwale aanu no kupula sebeli apumena mwa yonyene ni kwamba nji, “Cwale Kilesite aba sa iye, kame sa tende etimakazo no kupula okubita eti anatende wuyu mulume?” ");
INSERT INTO lyn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Afalisi sebeli ayupa aanu no kupula alemine okumooba, cwale apulisita akulu na Falisi sebeli atuma amapolisa oka mununga. ");
INSERT INTO lyn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesu sebeli wamba nji, “Ni sili naanyi enakoicana, mi cwale kame sa nite kwa woyo onani tumu. ");
INSERT INTO lyn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mba muni saele, kono kamu tamba ku niwana, mi kamu twese okwiiya omu nili.” ");
INSERT INTO lyn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Cwale aendisi no Majuda sebeli akwambisa omunjili ku munjili nji, “Kubine sate wuyu munu, nji tu kwangwe oku muwana? Ninji kame sate ku Magelike, aka iyete Amagelike? ");
INSERT INTO lyn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Iikene eyo atalusa aba aamba nji, mba muni saele kono ka mutamba kuni wana, mi oko nili kamutwese okwiyako?” ");
INSERT INTO lyn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ba liywaa noku manenena omukiti, eliywaa no utokwa, Jesu sebeli oimana ni kwamba nji, “Omunu aba afile elinyotwa aiye kwa mene mi anwe, ");
INSERT INTO lyn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","mi woyo opumena mwa mene, kanyi aman̄olo omo ambela nji, ‘Okutunda mu mucima waye kame sa kubube emisindi no meyi ayoyisa.’ ” ");
INSERT INTO lyn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Cwale eyi kame ana kwamba eyi no Mebo, eyo awo apumena mwa yonyene asa fanene okwitambula. Kakuli abo Emebo eka yasibiwa kale, mulibaka lya Jesu yo kasi ku yeemiwa kale. ");
INSERT INTO lyn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Cwale aba ana kuyupa amaywi awo, aanu anjili sebeli aamba nji, “Luli yokame omunuhi wa Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Anjili sebeli aamba nji, “Yokame Kilesite!” Kono anjili sebeli aamba nji, “Ninji Kilesite kame sa fanene okutunda mu Galileya! ");
INSERT INTO lyn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kasa nji elin̄olo kame lyamba nji Kilesite kame sa tunde mu lusika lwa Dabida mi kame atunda mu Betelehema, omundi ana kwikala Dabida.” ");
INSERT INTO lyn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Cwale sebeli kwiiya oukutaba mukaci no aanu mulibaka lyaye. ");
INSERT INTO lyn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Cwale anjili sebeli asinga oku mununga, kono kakwisa ona kubeeka elyooko ba yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Cwale amapolisa sebeli aukela kwa pulisita akulu ni kwa Afalisi, awo ana kwaibanguta nji, “Iikene aba kamwasi mulita?” ");
INSERT INTO lyn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Amapolisa sebeli atambula nji, “Simba kwatanga kakwisa omunu onaamba kanyi omunu wuyu!” ");
INSERT INTO lyn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Cwale Afalisi sebeli aatambula nji, “Ninji naanyi na moongiwa? ");
INSERT INTO lyn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kwa endisi no Majuda ni kwa Afalisi kame kuli awo ana pumene mwa yonyene? ");
INSERT INTO lyn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kono aanu no kupula aa, awo no kwa limuka omulawo, kame akutilwe!” ");
INSERT INTO lyn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nekudemasi ona kukutangeta okuta kwa Jesu mi yoli omunjili kwa onyene sebeli waambela nji, ");
INSERT INTO lyn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kana omulawo wetu kame otwesa okwatula omunu yo kasi yupa oweli ni kukwiyeta esi ana tende.” ");
INSERT INTO lyn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Sebeli atambula nji, “Ni wene kame otunda mu Galileya? Osingisise mi mbu mono nji kakwisa omunuhi wa Nyambe so imekwa okutunda mu Galileya.”  ");
INSERT INTO lyn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Cwale omunjili ni munjili sebeli okutela ku ndoo yaye. ");
INSERT INTO lyn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Cwale Jesu sebeli ota ba lilundu no itondo no Olibe. ");
INSERT INTO lyn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Amasiku luli Jesu kame sebeli oukela ku patelo no Ndoo ya Nyambe. Aanu onje sebeli aiya kwa yonyene, cwale sebeli oikala banji ni kwaiyeta. ");
INSERT INTO lyn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Cwale aiyeti no mulawo na Falisi sebeli alita omukati onaku waniwa yo buka ni kumubeeka mukaci koo. ");
INSERT INTO lyn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Sebeli aamba kwa Jesu nji, “Mwiyeti, omukati wuyu kame ana waniwa yo buka. ");
INSERT INTO lyn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Cwale mu mulawo, Mushe kame ana tu laele okwibaa ni mawee aa no ngeeso. Wene ngasibine wamba mulibaka lyaye?” ");
INSERT INTO lyn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Esi kame ana kwamba ngeeso oku mweteka, nji atwese oku mukandimeka. Kono Jesu sebeli oinamena banji yo n̄ola ni munwe waye. ");
INSERT INTO lyn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Cwale alemine okwekeza oku mwibanguta, Jesu sebeli oinumuka ni kwamba kwa onyene nji, “Nji omunjili mukaci kenu no kwatenda esibi atende wuyu no matatekelo okukonda eliwee ba yonyene.” ");
INSERT INTO lyn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Cwale sebeli oinama kame ni kun̄ola ni munwe waye banji. ");
INSERT INTO lyn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kono aba ana kuyupa eyo, sebeli akutela omunjili ni munjili oku tangiseta kwa kulu oweli. Jesu sebeli osiyala yomboci, omukati yo imanine balubala lwaye. ");
INSERT INTO lyn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Cwale Jesu sebeli oinumuka ni kwamba kwa yonyene nji, “Mukati kubine ali aanu? Kakwisa wuyu ona kubi omubonda?” ");
INSERT INTO lyn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Omukati sebeli otambula nji, “Kakwisa omunu, Mbumu.” Cwale Jesu sebeli wamba kwa yonyene nji, “Ni mene sikubi omubonda. Ote, mi olese okutenda esibi kame.” ");
INSERT INTO lyn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesu kame sebeli wamba kwa onyene nji, “Time eliseli no litunga,” “Woyo oni kon̄a katamba okwenda mu uwi, kono kame sa ikale ni liseli no mooyo.” ");
INSERT INTO lyn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Cwale Afalisi sebeli aamba kwa yonyene nji, “Kame okupaka wenyene, oupaki wowe kasa wa niti.” ");
INSERT INTO lyn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesu sebeli otambula nji, “Naba niku paka menyene, oupaki wange ni wa niti kakuli kame ni limuka omu ni tunda, nomu nita. Kono anyi ka mulimukile omuni tunda nomu nita. ");
INSERT INTO lyn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Anyi kame mwatula ni unu, mene kani atula omunu. ");
INSERT INTO lyn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Cwale naaba sani atule, ekatulo yange niya niti, kakuli kasa mene memboci natula, kono kame natula ni sitange ona ni tumu. ");
INSERT INTO lyn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mu mulawo wenu kame kun̄olilwe nji oupaki no aanu ayiili niwa niti. ");
INSERT INTO lyn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Time niku paka menyene, mi sitange ona ni tumu kame ani paka ni yonyene.” ");
INSERT INTO lyn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Cwale sebeli aamba kwa yonyene nji, “Okwali Sitowe?” Jesu sebeli otambula nji, “Kamu niyii, simba Sitange kamu muyii,” “Nji kambe namu kuni limuka, kambe ni sitange namu mulimuka ngeeso.” ");
INSERT INTO lyn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesu kame ana kwamba amaywi aa yo iyeta ba patelo no Ndoo ya Nyambe abeebi ni ibaka omo kutewelwangwa enubu. Kono kakwisa omunu ona ku mununga, kakuli enako yaye kaya sikukeela kale. ");
INSERT INTO lyn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesu sebeli waambela kame nji, “Kame ni kutela, mi mba muni saele, mi mbamufele mu sibi senu. Oko nita, kamu twese okwiyako.” ");
INSERT INTO lyn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aendisi no Majuda sebeli akwibanguta nji, “Ninji kame sa kwibae yonyene kakuli kame aamba nji oko nita kamu twese okwiyako?” ");
INSERT INTO lyn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesu sebeli waambela nji, “Anyi kame mu tunda banji, mene kame ni tunda ku wilu. Anyi kame muli asi litunga lino mene kasa nili wa litunga lino. ");
INSERT INTO lyn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kame nina myambele nji kame sa mufele mu ibi yenu. Kakuli anyi mba mufele mu ibi yenu konji aba samu pumene ‘esi nili so’.” ");
INSERT INTO lyn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sebeli amwibanguta nji, “Tiwe anyine?” Jesu sebeli waatambula nji, “Kanyi aba nina myambele okutunda ku matatekelo. ");
INSERT INTO lyn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kame nili neyi no kupula eyi no kwamba mulibaka lyenu neyi no kwatula, kono woyo ona nitumu niwa niti, mi kame nambela elitunga esi nina yupu okutunda kwa yonyene.” ");
INSERT INTO lyn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kame ana ku kwangwa oku yupisisa nji kame ana kwamba noo eya Sitaye. ");
INSERT INTO lyn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Cwale Jesu sebeli wamba kwa onyene nji, “Aba sa mumane oku tuleka Omwana no munu, cwale basa mulimukele esi nili so, mi ka nitende esinjili menyene, kono kame naamba esi anani iyete Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cwale woyo ona nitumu kame ali ni mene. Yonyene kasi nisiya memboci, kakuli enako yonje kame nitenda eyi imu wabelisa.” ");
INSERT INTO lyn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yo lemine okwamba eyo, ano kupula sebeli apumena mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Cwale Jesu sebeli wambela Amajuda awo ana kupumena mwa yonyene nji, “Nji kame mutwalelela mu liywi lyange, mba mu tende aiyetwa ange no niti, ");
INSERT INTO lyn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mi mba mulimuka eniti, mane eniti mbaimi lukulula.” ");
INSERT INTO lyn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Sebeli amu tambula nji, “Aci kame tuli asi lusika lwa Abulahama, mi katusi tendiwa kale abika ku munu. Iikene eso sikwambisa nji, ‘Mba mu lukululwa’?” ");
INSERT INTO lyn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesu sebeli waatambula nji, “Niti luli kame ni myambela nji omunu yonje woyo otenda esibi kame ali omubika ku sibi. ");
INSERT INTO lyn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Omubika katwalelele okwikala mu ndoo enako yonje, kono omwana kame aikalamo enako yonje. ");
INSERT INTO lyn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Cwale nji Omwana kame ami lukulula, mba mu tende asi kulukululwa luli. ");
INSERT INTO lyn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kame ni yii nji aanyi olusika lwa Abulahama. Cwale kame musaela oku nibaa, kakuli eliywi lyange kame lyulwile esibaka mwaanyi. ");
INSERT INTO lyn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kame namba esi nina mono kwa Sitange, mi anyi kame mu tenda esi mu nayupu kwa Sitenu.” ");
INSERT INTO lyn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Cwale sebeli amutambula nji, “Abulahama Sitetu.” Jesu sebeli wamba kwa onyene nji, “Nji kame muli aana a Abulahama, kambe kame mu tenda emisebezi ana tende Abulahama. ");
INSERT INTO lyn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kono bano kame mu saela oku nibaa, omunu ona myambele eniti nina yupu okutunda kwa Nyambe. Esi kasokame ana kutenda Abulahama. ");
INSERT INTO lyn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Anyi kame mu tenda eso ana kutenda Sitenu.” Sebeli aamba kwa yonyene nji, “Aci katusiku leyelwa mu unyazi Sitetu ni mumweya, yokame Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesu sebeli wamba kwa onyene nji, “Nji Nyambe neli Sitenu, kambe kame muni singa, kakuli kame ni simuluha ni kwiiya okutunda kwa Nyambe, kani siku kwiyela menyene, kono yokame ona ni tumu. ");
INSERT INTO lyn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Iikene aba kamwa yupisisa eyi ninaamba? Kakuli ka mupumene amaywi ange. ");
INSERT INTO lyn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Anyi kame mu tunda kwa sitenu Satani, mi kame mu singa okutenda etitakazo ta sitenu. Neli omwibai okutunda ku matangiseto, mi kakwisa eso atenda ni niti, kakuli kakwisa eniti mwa yonyene. Aba aonga, kame aamba esi ali so luli kakuli niwa mapwa mi sitaye amapwa. ");
INSERT INTO lyn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kono kakuli kame ni myambela eniti, kamuni pumene. ");
INSERT INTO lyn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Anyine mwaanyi woyo soni monisa nji kame nili ni sibi? Nji kame ni myambela eniti, iikene aba kamwa nipumene? ");
INSERT INTO lyn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Woyo oli wa Nyambe kame amamela amaywi a Nyambe. Elibaka aba kamwa mamele ninji kamutendile aa a Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Amajuda sebeli atambula Jesu nji, “Katwamba wino aba twamba nji kame oli Omusamaliya mi kame okwite edimona?” ");
INSERT INTO lyn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesu sebeli otambula nji, “Sikwite amadimona, kono kame nikuteka Sitange, mi anyi kamuni kuteke. ");
INSERT INTO lyn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Cwale kani saele ekanya yange, kwaali woyo oisaela mane kame satende omwatuli. ");
INSERT INTO lyn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Niti luli kame ni myambela nji omunu kame ateula eliywi lyange, ka tamba okufa.” ");
INSERT INTO lyn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Amajuda sebeli aamba kwa yonyene nji, “Cwale kame tu limuka nji kame uli ni madimona! Abulahama nafu kanyi omo ana tendele anuhi a Nyambe, mi wene kame wamba nji, Omunu aba ateula eliywi lyange katamba okufa. ");
INSERT INTO lyn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kana kame onenebile okubitelela sitetu Abulahama woyo onafu? Mane na nuhi a Nyambe naafu. Wene kame oku beeka anyine?” ");
INSERT INTO lyn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesu sebeli waatambula nji, “Nji kame niku kanyisa menyene, ekanya yange ka ikwite tuso. Sitange yoni kanyisa, woyo mwamba nji Nyambe wenu. ");
INSERT INTO lyn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kono kamwasi mulimuka mene ni muyii. Nji nambe nji kani muyii kame sani tende omoongi kanyi anyi, kono mene kame nimu limuka mane kame ni mamela eliywi lyaye. ");
INSERT INTO lyn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Sitenu Abulahama naku wabelelwa nji amone eliywaa lyange naku limona mane naku wabelelwa.” ");
INSERT INTO lyn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Cwale Amajuda sebeli aamba kwa yonyene nji, “Ka wasikwanisa kale emyaka makumi atanu, mi nu mono Abulahama?” ");
INSERT INTO lyn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesu sebeli wamba kwa onyene nji, “Niti luli kame ni myambela nji, Abulahama yokasiikalako kale, ‘Me niliko’.” ");
INSERT INTO lyn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Cwale sebeli atola amawee ni kumu konda, kono Jesu sebeli okushweeka, mane ni kutunda ba patelo no Ndoo ya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesu yobita, sebeli omona omulume ona kuleiwa yoka mono. ");
INSERT INTO lyn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Cwale aiyetwa aye sebeli amwibaguta nji, “Labbi, anyine ona tende esibi kana niyonyene nji ashemi aye, aba ana leiwa yoka mono?” ");
INSERT INTO lyn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesu sebeli otambula nji, “Kasanji wuyu mulume kame ana tende esibi, simba ashemi aye. Kono ninji emisebezi ya Nyambe imonahalele mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kame tufanena okusebeza emisebezi ya woyo ona nitumu, abo kusili omunji, ousiku aba sowiiye kakwisa omunu sotwesa okusebeza. ");
INSERT INTO lyn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kanyi aba nisili mu litunga, time eliseli no litunga. ");
INSERT INTO lyn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesu aba ana kumana okwamba ngeeso, sebeli osibwela banji niku kanda endowa no mate awo, mi sebeli olamba ba miyo no mulume ni ndowa ");
INSERT INTO lyn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ni kwamba kwa yonyene nji, “Ote oka kuyowe mu kasindi no Siloamu” (okutalusa nji kutumiwa). Cwale sebeli ota oka kuyowa ni kuukamo yo mona. ");
INSERT INTO lyn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aa ayoya naye nawo ana ku mu monanga yoli omukumbeli kunyima sebeli aamba nji, “Kana wuyu kasa yokame omulume ona kwikalanga mane yo kumbelanga?” ");
INSERT INTO lyn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Anjili sebeli aamba nji, “Yo kame” Anjili nji, “Kokuulwa, kono kame akufekile kanyi yokame.” Yonyene sebeli wamba nji “Ya mene luli.” ");
INSERT INTO lyn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Sebeli amwibanguta nji, “Cwale ngasibine kuna kutendahala nji amiyo owe afukuke?” ");
INSERT INTO lyn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Sebeli otambula nji, “Omulume wisaniwa Jesu kame ana ku kanda endowa ni kunokela mu miyo ange ni kwamba kwa mene nji ote ku kasindi no Siloamu, cwale sebeli nita nukakuyowa sebeli nimona.” ");
INSERT INTO lyn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Sebeli amwibanguta nji, “Okwaali yonyene?” Sebeli otambula nji, “Siyii.” ");
INSERT INTO lyn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Cwale sebeli alita kwa Afalisi omulume no kwamona. ");
INSERT INTO lyn_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Cwale neli eliywaa no Pumulo abo Jesu ana kukanda endowa ni kuyatulula amiyo aye. ");
INSERT INTO lyn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Afalisi sebeli amwibanguta kame omu ana kutendelwa nji amiyo aye amone. Cwale sebeli wamba kwa onyene nji, “Kame ana kubeeka endowa ba miyo ange nukuyowa mi sebeli ni mona.” ");
INSERT INTO lyn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Cwale Afalisi anjili sebeli aamba nji, “Wuyu mulume katundu kwa Nyambe, kakuli kamamela Epumulo.” Kono anjili sebeli aamba nji, “Ngasibine omulume woyo oli osikutenda eibi nji atende etimakazo no ngeesi?” Kame kuna kwikala oukutaba mukaci koo. ");
INSERT INTO lyn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Cwale kame sebeli aibanguta omulume no kwamona nji, “Iikene wamba mulibaka lyaye, okutunda abo ana kuyatulula amiyo owe?” Omulume sebeli wamba nji, “Kame ali omunuhi wa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Cwale aendisi no Majuda kasiku pumena nji omunu woyo kame ana ku leiwa yoli esibofu, mi nawana okumona kwaye, konji aba ana kwisana ashemi no mulume ona kutwesa okumona ");
INSERT INTO lyn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ni kwaibanguta nji, “Wuyu mwanenu? Woyo mwamba nji kame ana kuleiwa yoli esibofu, ngasibine kuna tendahala nji bano amone?” ");
INSERT INTO lyn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ashemi aye sebeli atambula nji, “Mwanetu wuyu mi kame ana kuleiwa yoka mono. ");
INSERT INTO lyn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kono omo kunaiyele nji amone katuyii simba okulimuka woyo ona yatulula amoyo aye. Mu mwibangute, nakulu kame saambe yonyene!” ");
INSERT INTO lyn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ashemi aye kame ana kwamba ngeeso mu kucila aendisi no Majuda, kakuli Amajuda kame ana kupumena nji omunu aba sa pumene nji Jesu yokame Kilesite, kame sa kondelwe kundee no ndoo no milapelo. ");
INSERT INTO lyn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Cwale ashemi aye sebeli amba nji, “Mukulu, mu mwibangute!” ");
INSERT INTO lyn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Cwale aka no wiili sebeli aisana omulume ona kuleiwa yoka mono ni kwamba kwa yonyene nji, “Oyeeme Nyambe! Kame tuyii nji wuyu mulume ni osikutenda eibi.” ");
INSERT INTO lyn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yonyene sebeli otambula nji, “Simba nji ninatende esibi, siyii.” “Esinu simweya niyii ninji kame nina kutenda wuyu no kwamona, kono bano kame ni mona.” ");
INSERT INTO lyn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Sebeli amwibanguta nji, “Iikene ana kutenda kwa wene?” “Ngasibine ana kuyatulula amiyo owe?” ");
INSERT INTO lyn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Sebeli waatambula nji, “Kale aba nina myambele kono ka musi teeteta. Iikene aba musinga okuyupa kame? Kame musinga okutenda aiyetwa aye?” ");
INSERT INTO lyn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Cwale sebeli amu nyefula ni kwamba nji, “Tiwe omwiyetwa waye kono aci kame tuli aiyetwa a Mushe. ");
INSERT INTO lyn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Aci kame tuyii nji Nyambe kame ana kwamba kwa Mushe, kono kanyi ba wuyu mulume katu yii oko atunda!” ");
INSERT INTO lyn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Omulume sebeli waatambula nji, “Iikene esi kame sikomokisa! Kamutamba okulimuka oko atunda mi cwale nani yatulula amiyo ange! ");
INSERT INTO lyn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cwale kame tuyii nji Nyambe ka yupu asi kutenda eibi, kono nji omunu kame ali omulapeli wa Nyambe mane nikutenda eso asinga, Nyambe kame amuteeteta. ");
INSERT INTO lyn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Asimba kwatanga okutunda ku matatekelo no litunga kaku siyupiwa kale omunu ona yatulula amiyo no munu ona kuleiwa yoka mono. ");
INSERT INTO lyn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nji omunu wuyu kasi kutunda kwa Nyambe, kambe kakwisa esi ana twese okutenda.” ");
INSERT INTO lyn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Seli amutambula nji, “Wene kame oleyelwe mu sibi no kumanenena, cwale kame wamba nji mbu twiyete?” Mi sebeli amucitela kundee. ");
INSERT INTO lyn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesu kame ana kuyupa nji namuciti, mi aba ana ku muwana sebeli wamba nji, “Kana kame opumena mwa Mwana no Munu?” ");
INSERT INTO lyn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Omulume sebeli otambula nji, “Mi anyine woyo, Mbumu, nji ni pumene mwa yonyene!” ");
INSERT INTO lyn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesu sebeli wamba kwa yonyene nji, “Nu mumono, mi yokame wuyu wamba kwa wene.” ");
INSERT INTO lyn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Omulume woyo sebeli wamba nji, “Kame ni pumena, Mbumu!” Mi sebeli omulapela. ");
INSERT INTO lyn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Cwale Jesu sebeli wamba nji, “Kakuli ekatulo nina iyele muno mu litunga nji cwale awo no kwamona afanene okumona mane nji awo amona aulwe okumona.” ");
INSERT INTO lyn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Anjili Afalisi ana kwikala ku nyonga ni yonyene aba ana yupa eyi, cwale sebeli amwibanguta nji, “Naaci kame tuli ano kwamona?” ");
INSERT INTO lyn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesu sebeli wamba kwa onyene nji, “Nji kambe kame muli eibofu, kambe ka mu kwite ouyi no sibi, kono cwale kame mwamba nji kame tumona, ouyi wenu kwausili.” ");
INSERT INTO lyn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesu sebeli waambela nji, “Niti luli kame ni myambela nji, woyo no kwaingena omulaka no mikoko okutusisa omwelo kono kame atina beulu ni ku matukelamo okutusisa endila indina, woyo munu mbuyi ni sisinyi. ");
INSERT INTO lyn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kono woyo oingena okutusisa omwelo yokame omulisana no mikoko. ");
INSERT INTO lyn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kwa yonyene omutateleli no mwelo kame au yatulula, mi emikoko kame iyupa eliywi lyaye, mane nikwisana emikoko yaye ni matina ni kwitwala kundee. ");
INSERT INTO lyn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cwale aba amana oku tundisa emikoko yaye yonje, kame aitwaletela mi emikoko kame imu kon̄a, kakuli kame ilimukile eliywi lyaye. ");
INSERT INTO lyn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mundina kaitamba oku mukon̄a, kono kame sai cilele oku no kuleba ni yonyene, kakuli kaiyii eliywi no andina.” ");
INSERT INTO lyn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesu sebeli waambela enguli eyi, kono kasikuyupisisa eso ana kwamba kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Cwale Jesu sebeli wamba kwa onyene kame nji, “Niti luli kame nimyambela nji, Time omwelo no mikoko. ");
INSERT INTO lyn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Awo onje aneyi oweli kwa mene ambuyi ni isinyi, kono emikoko kaisa yupa. ");
INSERT INTO lyn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Time Omwelo. Nji omunu kame aingena okutusisa mene mba yoyisiwa, mane mba ingene ni kubanamo mi mba wana amauyiseto. ");
INSERT INTO lyn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ombuyi kame aiyanga feela mu kwiita, okwibaa ni kusinya. Mene kame nina iyele nji iwane omooyo, mane iuwane mu kupula. ");
INSERT INTO lyn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Time omulisana no kuwaba. Omulisana no kuwaba kame aba emikoko yaye omooyo waye. ");
INSERT INTO lyn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kono woyo oli omubeleki mi kasa mulisana, woyo oluwile emikoko no kwatenda eyaye, aba a mona ondiwi yoiya, kame asiya emikoko mi kame acila mane ondiwi kame alema emikoko ni kwihasanya. ");
INSERT INTO lyn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Omubeleki kame acila ngeeso, kakuli yonyene kame ali omubeleki feela mi kababalele emikoko. ");
INSERT INTO lyn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Time omulisana no kuwaba, kame niyii emikoko yange mane emikoko yange kame iniyii. ");
INSERT INTO lyn_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Kanyi Sitange aba ani limukile, ni mene kame ni limukile Sitange, mi omooyo wange kame niuba emikoko yange. ");
INSERT INTO lyn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Cwale kame nikwite emikoko injili eyo kasa ya mu mulaka uno. Kame ni fanena okwilita ngeeso, mi kame seiyupe eliywi lyange, cwale kame sakwikale omutapi mumweya ni mulisana mumweya. ");
INSERT INTO lyn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Mulibaka eli Sitange yani singela, kakuli kame nikutoboha omooyo wange, nji ni uwane kame. ");
INSERT INTO lyn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kakwisa omunu woyo soushimba kwa mene. Kono kame nina kutoboha wo mukusinga kwange. Kame nili ni maata no ukutoboha wo mane ni kuushimba kame. Etaelo eyi kame nina itambula okutunda kwa Sitange.” ");
INSERT INTO lyn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kame kuna kwikala oukutaba kame mukaci no Majuda mulibaka no maywi aa. ");
INSERT INTO lyn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ano kupula mwa onyene sebeli aamba nji, “Jesu kame akwite amadimona mane kame atakana, iikene aba muteeteta kwa yonyene?” ");
INSERT INTO lyn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kono anjili sebeli aamba nji, “Amaywi aa kasa omwambelo no munu woyo oli ni madimona. Kana edimona kame itwesa okuyatulula amiyo no sibofu?” ");
INSERT INTO lyn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Cwale neli omukiti no kakulo ku Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Neli omubebo mi Jesu yo enda-enda ba patelo no Ndoo ya Nyambe, mu makozwana no mwelo wa Solomoni. ");
INSERT INTO lyn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Cwale Amajuda sebeli akuwana okumu beeka mukaci ni kwamba nji, “Kanako ikuma babine eyo sotu teule mu kwayupisisa? Nji ya wene Kilesite otwambele wino eniti.” ");
INSERT INTO lyn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesu sebeli waatambula nji, “Na niku myambela, mi ka mwasi pumena. Emisebezi eyi ni tenda mu litina lya Sitange yokame eyi ini paka. ");
INSERT INTO lyn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kono ka muni pumene, kakuli kamulamata ku mikoko yange. ");
INSERT INTO lyn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Emikoko yange kame iyupa eliywi lyange, mi kame ni ilimukile mane kame ini kon̄a, ");
INSERT INTO lyn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","kame niiba omooyo no kwaabwa, mi kaitamba okusinyeha, mane kakwisa omunu so itundisa mu lyoko lyange. ");
INSERT INTO lyn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Sitange ona kuniba yo, wa kuneneba okubitelela einu yonje, mi kakwisa omunu so twesa okwitundisa mu lyoko lya Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mene ni Sitange kame tuli bamweya.” ");
INSERT INTO lyn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Amajuda sebeli atola amawee kame, nji amukonde oo. ");
INSERT INTO lyn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesu sebeli waatambula nji, “Kame ninami monisa emisebezi no kuwaba eyi no kupula eyo itunda kwa Sitange. Ku yonyene emisebezi eyo ubine omusebezi ni ibaelwa?” ");
INSERT INTO lyn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Amajuda sebeli amutambula nji, “Katuku pwacaulele omusebezi no kuwaba, kono ni mu kunyefula, kakuli wene kame oli omunu mi kame okutenda nji tiwe Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesu sebeli waatambula nji, “Kana kaya sikun̄oliwa mu mulawo wenu?, Kame naamba nji, ‘Aanyi emilimu.’ ");
INSERT INTO lyn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nji kame ana isana nji milimi, kwanyine oko lina kwiiya eliywi lya Nyambe, (mi aman̄olo ka coliwa.) ");
INSERT INTO lyn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kame mwamba ya yonyene woyo ona sepiwa kwa Sitange ni kumu tuma mu litunga. Kame mu nyefula kakuli kame nina aamba nji time Omwana Nyambe? ");
INSERT INTO lyn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nji kani tende emisebezi ya Sitange, cwale mulese oku nipumena. ");
INSERT INTO lyn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kono nji kame niitenda, simba nji anyi kamuni pumene, mupumene amaywi awo mufanena oku limuka niku yupisisa nji Sitange kame ali mwa mene mane ni mene mwa Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kame sebeli aeteka okununga Jesu, kono sebeli obanduka mu maoko oo. ");
INSERT INTO lyn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesu sebeli ota kame oka luta okuta mu linjaliya lya Jodani ku sibaka eso ana kwikala Jowani ba weli yo kolobeza mi omo sebeli oka ikalamo. ");
INSERT INTO lyn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Cwale ano kupula sebeli aiya kwa yonyene ni kwamba nji, “Jowani kasiku tenda emakazo.” “Kono einu yonje eyo Jowani anaamba okukumanena ni wuyu mulume neli ya niti.” ");
INSERT INTO lyn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Cwale ano kupula sebeli apumena mwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Cwale kame kuna kwikala omulume munjili neli omweti ona kwisanwa Lazalo no Beteni, omundi wa Maliya ni mukulwaye Maleta. ");
INSERT INTO lyn_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maliya yokame ona kushokona Ombumu amati no sende, ni kumu kuumuna amakondo aye ni tin̄uki taye, Lazalo ona ku toma neli mandaye. ");
INSERT INTO lyn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Cwale amandaye sebeli atuma aanu kwa Jesu okaamba nji, “Mbumu, omusingiwa wowe kame atomine.” ");
INSERT INTO lyn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kono Jesu aba ana kuyupa ngeeso sebeli wamba nji, “Ou weeti kasa wa kufa, kono ni wa kuyeema Nyambe, nji cwale Omwana Nyambe ayemiwe mu libaka lyawo.” ");
INSERT INTO lyn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesu kame ana kusinga Maleta ni minaye ni Lazalo. ");
INSERT INTO lyn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Cwale aba ana kuyupa nji Lazalo neli omweti, sebeli oekeza okwikala amaywaa ayiili kame mu sibaka omo ana kwikala. ");
INSERT INTO lyn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Munyima no eyo Jesu sebeli wamba kwa iyetwa aye nji, “Twendeni kame mu Judeya.” ");
INSERT INTO lyn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Aiyetwa sebeli aamba kwa yonyene nji, “Labbi, Amajuda kame ana kusinga okukukonda amawee, cwale kosinga okuta kuya kame?” ");
INSERT INTO lyn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesu sebeli otambula nji, “Kasanji kame kuli etihola likumi ni timbili mu liywaa? Nji omunu kame aenda omunji kasisitala, kakuli kame amona eliseli no litunga lino. ");
INSERT INTO lyn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kono omunu aba aenda ousiku kame asitatala, kakuli eliseli ka lisako kwa yonyene.” ");
INSERT INTO lyn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Aba ana mana okwamba eyo ni kwaambela nji, “Lazalo omulikani wetu nalangana, kono nisita nika mwingule.” ");
INSERT INTO lyn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aiyetwa sebeli atambula nji, “Mbumu, nji nalangana, mbaikala wino.” ");
INSERT INTO lyn_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Cwale Jesu kame ana kwamba olufu lwaye, kono onyene kame ana ku yambuta nji kame aamba otulo feela. ");
INSERT INTO lyn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Cwale Jesu sebeli waataluseta wino nji, “Lazalo nafu, ");
INSERT INTO lyn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","mi mulibaka lyenu kame ni wabelelwa aba nina kuulwako, nji mu pumene. Kono cwale twendeni kwa yonyene.” ");
INSERT INTO lyn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi ona kwisaniwa Mbile sebeli wamba kwa iyetwa nji, “Twendeni naaci, tu kafe naye.” ");
INSERT INTO lyn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Cwale Jesu aba ana kukeela kame ana kuwana nji Lazalo sebeli okwite amaywaa anee yo teulilwe mu liyumbelo. ");
INSERT INTO lyn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Cwale Betaniya neli beebi ni Jelusalema omwendo ofanena eibima yiili, ");
INSERT INTO lyn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","mi Amajuda no kupula kame ana kwiiya kwa Maleta ni Maliya, muku silisa mulibaka no lifu lya mandoo. ");
INSERT INTO lyn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Cwale Maleta aba ana kuyupa nji Jesu kame akeile, sebeli ota nukuwana naye, abo Maliya yoikalile mu ndoo. ");
INSERT INTO lyn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maleta sebeli waambela Jesu nji, “Mbumu, kambe na ukwikalako, kambe mandange ka sifa! ");
INSERT INTO lyn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Cwale simba bano niyii nji esi sonje so kumbele kwa Nyambe, Nyambe mba kubiso.” ");
INSERT INTO lyn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesu sebeli wamba kwa yonyene nji, “Mandowe mba inguka kame.” ");
INSERT INTO lyn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maleta sebeli wamba kwa yonyene nji, Nilimukile nji mba inguka kame mu nako no kwinguka ba liywaa no mamaneneno. ");
INSERT INTO lyn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesu sebeli omwambela nji, “Time omooyo ni kwinguka. Woyo opumena mwa mene, simba afe mba yoyo, ");
INSERT INTO lyn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","mi omunu yonje woyo oyoya mane ni kupumena mwa mene, katamba okufa luli. Kana kame opumena ngeeso?” ");
INSERT INTO lyn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maleta sebeli otambula nji, “Ee Mbumu, kame nipumena nji ya wene Kilesite omwana Nyambe, oneyi mu litunga.” ");
INSERT INTO lyn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Aba ana kumana okwamba eyo, sebeli ouka oka isana minaye Maliya yo aamba mukondoka nji, “Omwiyeti kwaali bano, mi kame akwisana.” ");
INSERT INTO lyn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Cwale Maliya osi yupa ngeeso, sebeli oimana wangu ni kuta kwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Cwale Jesu yokasi ingena kale mu mundi, kono yosili abo Maleta ana ku muwaniketela. ");
INSERT INTO lyn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Cwale Amajuda awo ana kwikala ni Maliya mu ndoo a mongota, aba ana kumona nji kame ana leluba okwimana ni kubanena bandee, sebeli amukon̄a. Kame ana ku yambuta nji kame ata ku liyumbelo oka lila. ");
INSERT INTO lyn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Cwale Maliya aba ana kukeela oko Jesu ana kwikala, osimu mona feela, sebeli okwela ba makondo aye, yo aamba kwa yonyene nji, “Mbumu, kambe kona kwikala, kambe mandange ka sikufa!” ");
INSERT INTO lyn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Cwale Jesu aba ana kumumona yo lila, ni Majuda amukon̄elele alemine okulila no nyene, sebeli oyaiwa mu mebo ni kusisimuka. ");
INSERT INTO lyn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jesu sebeli oibanguta nji, “Kubine muna mubeeke?” Seli aamba kwa yonyene nji, “Molyetu, wiiye omone.” ");
INSERT INTO lyn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Cwale Jesu sebeli olila. ");
INSERT INTO lyn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Cwale Amajuda sebeli aamba nji, “Komumone omo anaku musingela!” ");
INSERT INTO lyn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kono anjili sebeli aamba nji, “Yokame wuyu ona kuyatulula amiyo no sibofu no mulume, iikene kasi teula wuyu mulume nji alese okufa?” ");
INSERT INTO lyn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesu sebeli oyaiwa kame mu mebo, mi sebeli ota ku libita, neli owina ona kuyatiliwa ni liwee. ");
INSERT INTO lyn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesu sebeli wamba nji, “Mu tundise eliwee!” Maleta omandaa no mulume onafu, sebeli wamba kwa Jesu nji, “Mbumu, ba nako ino sebeli onuka, kakuli sebeli amaywaa anee yofile!” ");
INSERT INTO lyn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesu sebeli wamba kwa yonyene nji, “Ka nisi kwambela nji aba opumena, mbu mono ekanya ya Nyambe?” ");
INSERT INTO lyn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Cwale sebeli atundisa eliwee. Jesu sebeli waliketa amiyo aye ku wilu ni kwamba nji, “Sitange, kame ni kutumela mwa wene, kakuli nuni yupu. ");
INSERT INTO lyn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kame niyii nji kame oni yupa enako yonje, kono kame naamba ngeeso mulibaka no aanu no kupula aa ana nibeke mukaci, nji apumene nji nuni tumu.” ");
INSERT INTO lyn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jesu aba ana kumana okwamba ngeeso, sebeli okuwa ni liywi linene nji, “Lazalo, otunde mu liyumbelo!” ");
INSERT INTO lyn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Omulume ona kufa sebeli obanamo, yo tingetilwe ku makondo ni ku maoko olwambi, mi olubala lwaye olu fukilwe ependeka. Jesu sebeli wamba kwa onyene nji, “Mu munungutule, mi mumu lesele akwendele.” ");
INSERT INTO lyn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Cwalehe Amajuda no kupula awo ana kwiiya ni Maliya mi sebeli amona eyo ana tende Jesu, sebeli apumena mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kono anjili kwa onyene, sebeli ata kwa Afalisi mu kwaambela esi ana tende Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Cwale apulisita akulu na Falisi sebeli awaneka aendisi no Keleke ni kwamba nji, “Iikene satutende? Kakuli wuyu mulume kame atenda etimakazo no kupula. ");
INSERT INTO lyn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nji tu muleselele yo tenda ngeeso, aanu onje kame sa pumene mwa yonyene, mi Amaloma kame saiiye mu kushandola esibaka setu no kukena ni sicaba setu.” ");
INSERT INTO lyn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kono omunjili kwa onyene, Kayafa, omupulisita mukulu mu mwaka owo, sebeli wamba kwa onyene nji, Kakwisa esi mulimukile! ");
INSERT INTO lyn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ka muyupisisa nji kwakuwaba omunu mumweya aba afela aanu, nji cwale esicaba sonje silesele okusinyeha? ");
INSERT INTO lyn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ka sikwamba feela mukusinga kwaye, kono bakutenda nji neli omupulisita mukulu mu mwaka owo, kame ana kunuha nji Jesu kame sa fele esicaba, ");
INSERT INTO lyn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","mi kasa esicaba feela, kono bamweya naana a Nyambe awo ana hasana. ");
INSERT INTO lyn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Cwale okutunda ba liywaa elyo, sebeli alela nji a mwibae. ");
INSERT INTO lyn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesu sebeli olesela okuta yoku monahaza mukaci no Majuda, kono sebeli otundamo oukutela mu naha ina kwikala ku nyonga ni lihalaupa, mu tolopo isaniwa nji Efalaimu, mi sebeli oikalamo na iyetwa aye. ");
INSERT INTO lyn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Cwale omukiti no Paseka no Majuda oli beebi, mi ano kupula sebeli atunda mu naha okuta ku Jelusalema okutangeta omukiti no Paseka owakasi tendahala kale nji aka kukenise. ");
INSERT INTO lyn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kame ana kusaelanga Jesu akwambisa omunjili ku munjili aimanine mu patelo no Ndoo ya Nyambe nji, “Kame mu yambuta ngasibine? Ninji katamba okwiiya ku mukiti?” ");
INSERT INTO lyn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Cwale apulisita akulu na Falisi sebeli alaela nji omunu olimukile omo ali Jesu, kame afanena okwasimweta, nji cwale amununge. ");
INSERT INTO lyn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Aba kuna kusiyala amaywaa atanu ni kamweya nji Epaseka itendiwe, Jesu sebeli wiiya ku Beteni, omo ana kwikala Lazalo woyo ona kwingulwa kwaafu. ");
INSERT INTO lyn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Omo sebeli otendelwa omulalelo, Maleta yo sikutaba eilya, mi Lazalo neli mumweya kwa sikulya naye ku tafule. ");
INSERT INTO lyn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maliya sebeli oshimba amaati no sende awo ali elicika mu katele, mane ni kuwaa amakondo a Jesu. Mi sebeli watundisa ni tin̄uki taye. Mi endoo yonje mane sebeli iiyala ni mumwee no maati. ");
INSERT INTO lyn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kono Judasi Isikaliota omunjili no aiyetwa aye woyo so mubeteka, sebeli wamba nji, ");
INSERT INTO lyn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Iikene esende eyo aba ka isiulisiwa emyanda yaatu no muwayawaya, (300) mi amali awo atabelwe awo ashebile?” ");
INSERT INTO lyn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kame ana kwamba ngeeso, kasa nji kame ana ku tokomela awo ashebile, kono mulibaka no kutenda nji neli mbuyi yokame ona ku teulanga esikwama no mali, mi kame ano ku shimbelanga eyo ina ku bekiwangwa mo. ");
INSERT INTO lyn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kono Jesu sebeli wamba nji, “Mu mulesele yomboci, mu mulesele aateule konji ba liywaa no kepelo yange. ");
INSERT INTO lyn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kakuli awo ashebile kame muli noo enako yonje. Kono ka mutamba okwikala ni mene enako yonje.” ");
INSERT INTO lyn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Amajuda no kupula aba ana kuyupa nji Jesu mwaali omo mi sebeli aiya, mi kasa mulibaka lya Jesu feela, kono ni mu kumona Lazalo ona kwingulwa kwaafu. ");
INSERT INTO lyn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Apulisita akulu sebeli alela okwibaa ni Lazalo, ");
INSERT INTO lyn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kakuli Amajuda no kupula kame ana kwa siya mulibaka lya Lazalo, mi sebeli apumena mwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Aba kuna kupa okupula no ku neneba no aanu aa ana kwiiya ku mukiti, aba ana yupa nji Jesu kame aiya mu Jelusalema, sebeli ashimba emitayi no tinzalu. ");
INSERT INTO lyn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Cwale sebeli ashimba emitayi no itondo no tinzalu ni kuta okamu waniketa akuweleza nji, “Hosana! Embuyoti ya woyo wiiya mu litina lya Mbumu, Ombumu no Isilaele!” ");
INSERT INTO lyn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mi Jesu sebeli owana akana no mbongolo, sebeli oikala beulu wako kanyi aba kun̄olilwe nji, ");
INSERT INTO lyn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Olese kucila, wene Omwana Sione no mukatana! Komone, ombumu wowe okeyile, yo ikalile beulu no kana no mbongolo.” ");
INSERT INTO lyn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Aiyetwa aye kasi kuyupisisa eyo ba weli, kono Jesu aba ana kumana okukanyisiwa, cwale sebeli apuluka nji eyi kame ina kun̄oliwa eyaye mane namutendele yo. ");
INSERT INTO lyn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mi oundi no aanu awo ana kwikala naye aba ana kwisana Lazalo okutunda mu liyumbelo, mi sebeli omwingula kwaafu, kame ana ku mupaka. ");
INSERT INTO lyn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mi elibaka elyo oundi no aanu aba ana kuta okamuwaniketa, neli nji kame ana kuyupa nji kame anatende emakazo. ");
INSERT INTO lyn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Afalisi sebeli akwambisa omunjili ku munjili nji, “Mu mone nji ka mutwese okutenda esinjili. Komumone, elitunga lyonje na limukon̄o!” ");
INSERT INTO lyn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Cwale kame kuna kwikala Amagelike anjili kwaa ana kwiiya mu kulapela ku mukiti. ");
INSERT INTO lyn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Seli aiya kwa Filipi na ku Betasaida na mu Galileya, mi sebeli amu kumbela nji, “Molyetu, kame tu singa oku mona Jesu.” ");
INSERT INTO lyn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipi sebeli ota nuka ambela Andiliyasi mi cwale Andiliyasi ni Filipi sebeli akambela Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesu kame ana kwatambula nji, “Enako naiyi eyo Omwana no munu eyi sa kanyisiwe. ");
INSERT INTO lyn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Niti luli kame ni myambela nji, embuto no uloto eyi ikunwa mu mumbu aba yulwa okufa, mba ikala yomboci, kono aba ifa, mba iliti eilya no kupula. ");
INSERT INTO lyn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Woyo osinga omoyo waye, mba utaukelwe, kono woyo otimbile omoyo waye mu litunga lino, mba tewelwa omoyo no kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Omunu aba ani sebeleza ani kon̄e, mi omu nili, woyo oni sebeleza mba ikala mo ni yonyene mi omunu aba ani sebeleza, Sitange mba mukuteke. ");
INSERT INTO lyn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Cwale Omoyo wange kame ukalelwe mi iikene sa naambe? ‘Sitange onisileleze mu nako eyi’? Kokuulwa mulibaka eli kame ineyi ba hola ino. ");
INSERT INTO lyn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Sitange okanyise elitina lyowe!” Cwale eliywi sebeli litunda ku wilu eli lyaamba nji, “Kame ninalikanyisa mi mbani likanyisa kame.” ");
INSERT INTO lyn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Cwale oundi no aanu ona kwimananga sebeli oyupa eliywi ni kwamba nji nalilumu, anjili sebeli aamba nji, “Elingeloi na lyamba kwa yonyene!” ");
INSERT INTO lyn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesu sebeli otambula nji, “Eliywi elyo kame lineyi mulibaka lyenu, kasa mulibaka lyange. ");
INSERT INTO lyn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cwale ino ni katulo no litunga lino, cwale ombumu no litunga lino mba citelwe kundee. ");
INSERT INTO lyn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Cwale mene aba sani none okutunda ba litunga mba niliti aanu onje kwa mene.” ");
INSERT INTO lyn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kame ana kwamba ngeso oku monisa elifu elyo safe. ");
INSERT INTO lyn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ano kupula sebeli atambula nji, “Kame tuna iyetwa ku mulawo nji Kilesite mba ikala enako yonje. Ngasibine aba wamba nji omwana no munu mba noniwa okutunda ba litunga? Anyine Omwana no Munu?” ");
INSERT INTO lyn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesu sebeli wamba kwa onyene nji, Eliseli kwa li sili mwaanyi enako icana fela. Mweende aba mu sili ni liseli, nji ouwi olese oku milema, kakuli woyo weenda mu uwi ka limukile oko ata. ");
INSERT INTO lyn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Aba mu sili ni liseli, mu pumene mu liseli, nji mu futuke aana no liseli. Jesu osi mana okwamba ngeso, sebeli okutela mi sebeli okushweeka kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Simba nji kame ana kutenda etimakazo no kupula ngeso balubala loo, kono aendisi no Majuda kasi kupumena mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Esi neli okwiyateteta amaywi ana kwambiwa kwa munuhi Isaya, eli lyaamba nji, “Mbumu, anyine ona pumene etaba yetu? Mi kwanyine oko ku monahalisa elyoko lya Mbumu?” ");
INSERT INTO lyn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Cwalehe kame ana ku kwangwa okupumena, kakuli Isaya na kwamba kame nji, ");
INSERT INTO lyn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nyambe kame ana fofalisa amiyo oo mi kame ana tatafalisa emicima yoo, nji alese okumona ni miyo oo, alese okuyupa ni micima yoo, alese oku siulukela kwa mene, nji nabalisa.” ");
INSERT INTO lyn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya kame ana kwamba eyo kakuli kame ana kumona ekanya yaye, mane sebeli wamba eya Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Simba aba kulingeso, aa no kupula kwa endisi no Majuda anjili kame ana pumene kwa yonyene, kono kasiku kutoya, mu kucila Afalisi nji alese oku citelwa ku ndee no ndoo no milapelo. ");
INSERT INTO lyn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kakuli kame ana kusinga oku bubekwa kwaanu, okubita oku bubekwa kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesu sebeli okuweleza nji, “Woyo opumena mwa mene, ka pumene mwa mene, kono kame apumena mwa woyo ona ni tumu. ");
INSERT INTO lyn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mi woyo oni mona, kame amona ni woyo ona ni tumu. ");
INSERT INTO lyn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kame ni neyi mu litunga kanyi eliseli nji woyo yonje opumena mwa mene alese okwikala muuwi. ");
INSERT INTO lyn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nji omunu kame ayupa amaywi ange, mi yo ulwa okwa teula, mene kani mwatula, kakuli ka ni siiya mu kwatula elitunga, kono nji ni yoyise elitunga. ");
INSERT INTO lyn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Woyo oni kana mi yo ka tambula amaywi ange, kame akwite woyo so mu atula, Eliywi ninaamba lyokame elyosa limwatule mu liywaa no mamaneneno! ");
INSERT INTO lyn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kakuli ka ni kwambele mu maata ange feela, kono Sitange woyo ona ni tumu, yokame ona laele esi ni fanena okwamba, ni mukwa owo naamba nawo. ");
INSERT INTO lyn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mi kame ni yii nji etaelo yaye ni moyo no kwaabwa. Mi cwale esi naamba, kame ni saamba kanyi Sitange aba ana nambele so.” ");
INSERT INTO lyn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Cwale omukiti no Paseka waka sikeela kale, Jesu naku limuka nji enako yaye no kutunda mu litunga okuta kwa sitaye naikwana mukusinga aye awo ana kwikalanga mu litunga, sebeli wasinga okutwala ku mamaneneno. ");
INSERT INTO lyn_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Cwale enako no kulya omulalelo aba ina kukwana, abo cwale Odiabulozi yo waingena kale mumucima wa Judasi Isikaliota, omwana Simoni, oku mubeteka. ");
INSERT INTO lyn_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesu mu kulimuka nji Sitaye kame ana kubeeka einu yonje mu maoko aye, ni nji kame ana kutunda kwa Nyambe, mi kame auka kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Seli oimana ba mulalelo ni kutubula esikumango saye nabeulu, mane nuku nunga olwambi mu mbunda. ");
INSERT INTO lyn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Seli oitela ameyi ba siwana, mi sebeli otangisa oku yowisa eilyatiso no aiyetwa aye, ni kwa kuumuna ni taulo eyi ano kununga mu mbunda. ");
INSERT INTO lyn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Seli oiya ngeso nikwa Simoni Pitolosi, mi cwale Pitolosi sebeli wamba kwa yonyene nji, “Mbumu, kame oyowisa eilyatiso yange nji?” ");
INSERT INTO lyn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesu sebeli omutambula nji, Esi ni tenda ka usilimukile bano, kono mbu si yupisisa ku lubala. ");
INSERT INTO lyn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pitolosi sebeli wamba kwa yonyene nji, Ku tamba ku ni yowisa eilyatiso yange. Jesu sebeli omutambula nji sikuyowisa kukwite ekabelo ni mene. ");
INSERT INTO lyn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Pitolosi sebeli wamba kwa yonyene nji, “Mbumu! kasa eilyatiso yange feela, kono ni maoko ange mane ni mutwi.” ");
INSERT INTO lyn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesu sebeli wamba kwa yonyene nji, “Woyo yonje ona ku yowo, kasaele okuyowa konji kuilyatiso, olutu lwaye lusikenine lonje. Mi anyi kame mu kenine, kono kasa aanyi moonje.” ");
INSERT INTO lyn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kakuli kame ana kulimuka woyo so mu beteka. Ni mulibakelyo aba ana kwamba nji, “Ka mu kenine moonje.” ");
INSERT INTO lyn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aba ana kumana okwa yowisa kwilyatiso, sebeli okumanga esikumango saye nabeulu, sebeli oikala ba tafule kame, mi sebeli wamba kwa onyene nji, “Kana kame mu yupisisa esi nina mitende?” ");
INSERT INTO lyn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kame mu ni isana nji Mwiyeti ni Mbumu, mi kame mwamba wino, kakuli ya meene. ");
INSERT INTO lyn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mi cwale nji mene ombumu ni mwiyeti wenu inayowisa eilyatiso yenu, naanyi kame mu fanena ouku yowisa kwilyatiso. ");
INSERT INTO lyn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kakuli kame nina mimonisa omwanda nji mutende omu nina mitendele. ");
INSERT INTO lyn_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Niti luli kame ni myambela nji, omubika ka biti Ombumu waye, mi woyo ona tumiwa ka biti woyo ona mutumu. ");
INSERT INTO lyn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nji kame mulimuka einu eyi, namufuyaulwa nji kame muitenda. ");
INSERT INTO lyn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Kanaamba anyi moonje, nilimukile aa ninakete, kono elin̄olo kame saliiyatetetwe nji, ‘Woyo ona kulya esinkwa sange nanifutukele.’ ");
INSERT INTO lyn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kame ni myambela etaba eyi bano abo yakasiiya kale, nji aba saitendahale mupumene nji yameene. ");
INSERT INTO lyn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Niti luli kame ni myambela nji, woyo otambula omunu yonje nituma, kame ana tambula mene, mi woyo otambula mene, kame atambula woyo ona nitumu.” ");
INSERT INTO lyn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Cwale Jesu aba ana kumana okwamba ngeso, sebeli oshupeka mu mucima ni kwambela aiyetwa aye nji, “Niti luli kame ni myambela nji, omunjili mwaanyi kame sani beteke.” ");
INSERT INTO lyn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Cwale aiyetwa sebeli akwaliketa, abo kalimukile woyo aamba. ");
INSERT INTO lyn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Omunjili kwa iyetwa aye Jowani, woyo ona ku singiwa kwa Jesu yo shendamine ba saali saye. ");
INSERT INTO lyn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Pitolosi sebeli omu kobeta nji, “Otwibangutele woyo aamba.” ");
INSERT INTO lyn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Cwale yonyene sebeli oshendamena ba Saali sa Jesu, sebeli oibanguta nji, Mbumu anyine cwale? ");
INSERT INTO lyn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesu sebeli otambula nji, “Woyo sani be esinkwa esi sina cupwiwa mu siwana.” Mi aba ana kumana okusi cupwa, sebeli osiba Judasi omwana Simoni Isikalyoti. ");
INSERT INTO lyn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Aba ana kumana oku tambula esinkwa, Satani sebeli oingena mu mucima wa Judasi. Cwale Jesu sebeli wamba kwa yonyene nji, “Esi osinga okutenda, ositende wangu.” ");
INSERT INTO lyn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Cwale kakwisa simba mumweya ba tafule woyo ona kulimuka elibaka anambele ngeso kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Anjili kame ana ku yambuta nji, Judasi aba ana kutenda nji yo kame osikuteula esikwama, Jesu kame ana ku mwambela nji, akaule esi tusaela ba mukiti simba nji akabe aa ashebile esinjili. ");
INSERT INTO lyn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yonyene aba ana kumana okushimba esinkwa, ababo sebeli otundamo. Mi neli usiku. ");
INSERT INTO lyn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judasi aba ana kumana oku bana, Jesu sebeli wamba nji, “Cwale Omwana no munu na kanyisiwa, mi mwa yonyene, Nyambe na kanyisiwa. ");
INSERT INTO lyn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nji Nyambe na kanyisiwa mwa yonyene, Nyambe kame mba kamu kanyisa mwa yonyene, mi mba mu kanyisa ababo. ");
INSERT INTO lyn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Anange, mbaniikala naanyi ba nako inyonyo feela. Mba muni saele, mi kanyi omo nina kwambela kwa aendisi no Majuda, kame ni myambela naanyi ngeso, ‘Oko nikatile ka mutwese kuni kon̄a.’ ");
INSERT INTO lyn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kame ni miba omulawo no ubya, ninji muku singe kanyi omu nina misingele, naanyi muku singe ngeso. ");
INSERT INTO lyn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mweesi aanu onje mbalimuka nji muli aiyetwa ange, nji kame mukusinga omunjili ku munjili. ");
INSERT INTO lyn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Pitilosi sebeli wamba kwa yonyene nji, “Mbumu, kubine okatile?” Jesu sebeli omu tambula nji, “Oko nikatile ka mutwese okunikon̄a cwale, kono munyima mba muni kon̄o.” ");
INSERT INTO lyn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pitolosi sebeli wamba nji, “Mbumu iikene abo kani kukon̄o abano? Mene kame sanife ni wene!” ");
INSERT INTO lyn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesu sebeli omu tambula nji, “Kana kame otwesa okutoboha omoyo wowe kwa mene? Niti luli kame ni kwambela nji, Omukombwe owa kasilila kale, kame sonilatule twaatu.” ");
INSERT INTO lyn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Mulese okubilaela mu micima yenu, mupumene mwa Nyambe mane mupumene ni mwa mene ngeso. ");
INSERT INTO lyn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mu ndoo ya Sitange emizuzu ni yakupula, kambe kasa ngeso kambe kanisi myambela ngeso nji kame nikatile oka milukiseta esibaka. ");
INSERT INTO lyn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Cwale aba nita oka milukiseta esibaka, mbani uku kame mukumishimbela kwa mene nji mukaikale nange oko nili. ");
INSERT INTO lyn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kame mulimuka endila ita ku sibaka oko nita.” ");
INSERT INTO lyn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi sebeli wamba kwa Jesu nji, “Mbumu, katuyii oko ukatile, cwale ngasibine satu limuke endila itako?” ");
INSERT INTO lyn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesu sebeli wamba kwa yonyene nji, “Time endila, ni niti, mane ni moyo, kakwisa omunu sota kwa Sitange konji mwa mene. ");
INSERT INTO lyn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nji namuku nilimuka, kambe namu limuka ngeso ni Sitange, okutunda bano namu mulimuka mane namumu mono.” ");
INSERT INTO lyn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipi sebeli wamba kwa Jesu nji, “Mbumu, otumonise Sitetu, mi mba tukolwa.” ");
INSERT INTO lyn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesu sebeli omwambela nji, “Kame nina ikala naanyi enako no kuleba, mi kausi nilimuka Filipi? Woyo ona nimono kame ana mono ni Sitange. Ngasibine aba wamba nji, ‘Otu monise Sitetu’? ");
INSERT INTO lyn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kaupumene nji kame nili mwa Sitange mane ni Sitange kame ali mwa mene? Amaywi awo naamba kwa wene kani myambele oo mu maata ange, kono Sitange woyo oli mwa mene yokame woyo otenda emisebezi yaye. ");
INSERT INTO lyn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mu nipumene nji kame nili mwa Sitange mane Sitange kame ali mwa mene. Nji kasangeso mu nipumene mulibaka no misebezi eyo. ");
INSERT INTO lyn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Niti luli kame ni myambela nji, “Woyo opumena mwa mene mbatende emisebezi nitenda mane kame sa tende minene niku bitelela, kakuli kame nita kwa Sitange.” ");
INSERT INTO lyn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Eyo yonje okumbela mu litina lyange, kame sani itende nji Sitange akanyisiwe mwa Mwana. ");
INSERT INTO lyn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nji kame mukumbela esinjili mu litina lyange, mba nisi tende. ");
INSERT INTO lyn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nji kame muni singa, mu mamele etitaelo tange. ");
INSERT INTO lyn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Cwale mba nilapele Sitange, mi mba mibi omuombaombi omunjili, nji aikale naanyi okuta oku no kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Simba Emebo no niti, eyo elitunga ka litwese okwitambula simba okwilimuka kakuli kali imwine, mi kali ilimuka. Kono anyi kame mu muyii, kakuli kame ali naanyi mane mba ikala kwaanyi. ");
INSERT INTO lyn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Kani tamba ku misiya memuli andiyala, mba ni uku kwaanyi. ");
INSERT INTO lyn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kusili enakoicana mi elitunga kali tamba oku ni mona kame, kono anyi mbamu nimono. Kakuli mene kame ni yoya, naanyi mba muyoyo. ");
INSERT INTO lyn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mu liywaa elyo, mba mu limuka nji kame nili mwa Sitange, naanyi kame muli mwa mene mane ni mene mwaanyi. ");
INSERT INTO lyn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Woyo oli ni titaelo tange mane nikutiteula, yokame woyo oni singa. Mi woyo oni singa, mba singiwa kwa Sitange ni mene mba nimu singi mane niku monahaze kwa yonyene.” ");
INSERT INTO lyn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judasi (kasa Isikalioti) sebeli wamba nji, “Mbumu, ngasibine wamba nji mbu kumonahaza kwaaci, mi kasa ku litunga?” ");
INSERT INTO lyn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesu sebeli omutambuta nji, “Omunu aba ani singa, mba mamele eliywi lyange. Mi Sitange mbamu singi, mi mbatwiyi kwa yonyene mane tuyake omundi wetu ni yonyene.” ");
INSERT INTO lyn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Woyo no kwani singa ka teula amaywi ange mi eliywi muyupa kasa lyange kono lya Sitange ona nitumu. ");
INSERT INTO lyn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Einu eyi kame nina myambele yo aba ni sili nenu. ");
INSERT INTO lyn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kono Omombaombi, Emebo No Kukena eyo Sitange mba itumu mu litina lyange, mba imiiyete einu yonge mane mbaimi pulukisa einu yonje eyo nina myambele. ");
INSERT INTO lyn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Kame nimi siyela ekozo, ekozo yange nimiba, kaikufeke ni omo limibelanga elitunga, omo nimibela. Emicima yenu ilese okukatazeha simba okucila. ");
INSERT INTO lyn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Na mukuyupa eyi nina myambele nji, ‘Kame nita, mi mba niiyi kwaanyi.’ Kambe namukunisinga, kambe mbamu wabelelwe kakuli kame nita kwa Sitange, kakuli Sitange wa kuneneba okubita mene. ");
INSERT INTO lyn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Cwale kame nina myambele eyo ekaya sitendahala, nji aba imana okwiiya, mu pumene. ");
INSERT INTO lyn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sitamba okwamba eino kupula naanyi, kakuli omubusisi no litunga lino okeyile. Ka kwite amaata beulu yange, ");
INSERT INTO lyn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kono kame nitenda kanyi Sitange omo anani laelele, nji cwale elitunga lilimuke nji kame ni singa Sitange. Ko mwimane, twendenyi abano. ");
INSERT INTO lyn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Time ebeine no niti, mi osi kulima ni Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Omutayi onje uli kwa mene nokwa beeka embuya, kame au temako mi omutayi onje ou ubeeka embuya, kame au kolela nji obeeke onene embuya. ");
INSERT INTO lyn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Anyi namu kenisiwa mulibaka no liywi nina myambele kale. ");
INSERT INTO lyn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mwikale mwa mene, kanyi mene aba nili mwaanyi. Kanyi omutayi aba kautwese okubeeka embuya wonyene, konji aba okubeeka mu beine, kame kuli ngeso ni kwaanyi, konji aba samukubeeke mwa mene. ");
INSERT INTO lyn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Time ebeine, anyi kame muli emitayi. Woyo okubeeka mwa mene, ni mene kame nili mwa yonyene, yokame woyo obeeka embuya onene, kakuli nji sisako ka mutwese okutenda esinjili. ");
INSERT INTO lyn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nji omunu kakubeeke mwa mene, kame akoliwa kanyi omutayi ni kukukuta, mi emitayi kame yungekiwa ni kukondelwa mu mulilo mane ni kubya. ");
INSERT INTO lyn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nji kame mukubekile mwa mene mane amaywi ange kame ali mwaanyi, mukumbele eso sonje musinga mi mbamu sitendelwe. ");
INSERT INTO lyn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ba kutenda ngeso Sitange mba kanyisiwa nji kame mubeeka onene embuya, mi bokame aba samutende aiyetwa ange. ");
INSERT INTO lyn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kanyi Sitange aba ana nisingi ni mene kame nimi singa ngeso, mu yoye mu lilato lyange. ");
INSERT INTO lyn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nji kame muteula etitaelo tange, kame sa mwikale mu lilato lyange, kanyi aba nina mamele etitaelo ta Sitange mane kame niikalile mu lilato lyaye. ");
INSERT INTO lyn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Kame nina myambele eyo nji okuwabelelwa kwange kwikale mwaanyi nji cwale okuwabelelwa kwenu kwiyale. ");
INSERT INTO lyn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Etaelo yange ninji muku singe omunjili ku munjili, kanyi aba nina misingi. ");
INSERT INTO lyn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kakwisa omunu woyo oli ni lilato no kuneneba okubitelela eli, konji omunu okutoboha omoyo waye mulibaka no alikani aye. ");
INSERT INTO lyn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kame muli alikani ange nji kame mutenda eyo nimi laelela. ");
INSERT INTO lyn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sitamba oku miisana nji muli abika, kakuli omubika ka limuka eso atenda Molyaye. Kono kame nimiisana alikani ange, kakuli kame nina misimwete eyi nina yupu yonje kwa Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kasa anyi muna nikete, kono time nina mikete ni kumi tuma nji mute mane muka beeke embuya onene. Cwale embuya yenu iikalelele, nji cwale esi sonje samu kumbele kwa Sitange mu litina lyange amibe so. ");
INSERT INTO lyn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Esi nimi laela ninji, muku singe omunjili ku munjili. ");
INSERT INTO lyn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Nji elitunga kame limi timbile, mulimuke nji kame lina tateke okutimba mene oweli ekalya sitimba anyi. ");
INSERT INTO lyn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kambe kame muli asi litunga, elitunga kame lisinga esi sili salyo. Kono kakuli kasa muli ano litunga, kono kame nina mikete mu litunga, bokame abo elitunga aba limi timbile. ");
INSERT INTO lyn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mu puluke eliywi elyo nina kumyambele nji, ‘Omubika kasa wakuneneba okubitelela Molyaye.’ Nji kame ani yandisa, mba mi yandisa naanyi, nji kame ana mamele eliywi lyange, mba mamele ngeso ni lyenu. ");
INSERT INTO lyn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kono kame sami tende eyo yonje mulibaka lyange, kakuli kayii woyo ona ni tumu. ");
INSERT INTO lyn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kambe kani siiya mu kwaambela kambe kakwite esibi, kono cwale kaku tatula ku sibi soo. ");
INSERT INTO lyn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Woyo onitimbile kame atimbile ngeso ni Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kambe ka ni sitenda mukaci koo emisebezi eyo kakwisa omunu ona itende, kambe kakwite esibi kono cwale kame ana mono, mane kame atimbile mene bamweya ni Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Neli okwiyateteta eliywi elyo lina kun̄oliwa mu mulawo woo nji, ‘Kame ani timbile feela okuulwile omubonda.’ ");
INSERT INTO lyn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kono cwale Omombaombi aba saiye, woyo sani tume kwaanyi okutunda kwa Sitange. Simba Emebo no niti eyo saitunde kwa Sitange kame saibe oupaki kwa mene. ");
INSERT INTO lyn_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Cwale naanyi mba mwipaka, kakuli namwikala ni mene okutunda ku matatekelo. ");
INSERT INTO lyn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Kame nina myambele eyo nji mulese oku sitatala. ");
INSERT INTO lyn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mba mitundisa mu tindoo no milapelo mane enako kame iiya eyo omunu yonje oso miibaa, mba yambuta nji kame abelekela Nyambe. ");
INSERT INTO lyn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Cwale mbami tende einu eyo kakuli kasi limuka Sitange simba mene. ");
INSERT INTO lyn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kono kame nina myambele einu eyi nji cwale enako yoo aba saiye, mba puluka nji kame nina ku myambela einu yoo. Ka nisi myambela einu eyi mu matangiseto, kakuli kame nina kwikala naanyi. ");
INSERT INTO lyn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kono cwale kame nita kwa woyo ona kunituma, mi kakwisa kwaanyi woyo soni ibanguta nji kubine ukatile. ");
INSERT INTO lyn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kono kakuli kame nina myambele einu eyi, elikenyi naliyala mu micima yenu. ");
INSERT INTO lyn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Simbakutendengeso kame nina myambela eniti, kame kumi lukeele aba nita kakuli aba niulwa okuta, Omuombaombi katamba okwiiya kwaanyi. Kono aba nita, mba nimu tumu kwaanyi. ");
INSERT INTO lyn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cwale aba saiye, mba kolwisa elitunga mulibaka no sibi, okuluka mane ni katulo. ");
INSERT INTO lyn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Okukumanena ni sibi kakuli ka pumene mwa mene, ");
INSERT INTO lyn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","okukumanena ni kuluka kakuli kame nita kwa Sitange, mi kamu tamba kuni mona ");
INSERT INTO lyn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","okukumanena ni katulo, kakuli omubusi no litunga lino na atuliwa. ");
INSERT INTO lyn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ni sili neyi no kupula no kumyambela, kono kamu twese okwiyupisisa bano. ");
INSERT INTO lyn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Emebo no niti aba saiye, kame sa mi twale mu niti yonje kakuli ka tamba okwambela yonyene, kono mba myambele eyi ana yupu yonje mane ami lemuse neyi isiiya. ");
INSERT INTO lyn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mba nikanyisa, kakuli mba shimbi kweyi ili yange, mi mba myambele yo. ");
INSERT INTO lyn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Esi sonje ali naso Sitange sange, cwalehe kame ninaamba nji mba shimbi kwesi sili esange, mi kame sami limukise so. ");
INSERT INTO lyn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kwesili enakoicana, mi ka mu tamba kuni mona, mi kame enakoicana mba muni mono. ");
INSERT INTO lyn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Anjili kwa iyetwa aye sebeli akwambota omunjili ku munjili nji, “Iikene eyi aamba wuyu kwaaci? Nji mu nako icana feela kamutamba kuni mona, mi mu nako icala kame mbamu nimono ni kwamba nji, ‘Kame nita kwa Sitange.’ ");
INSERT INTO lyn_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Seli aamba nji iikene aba aamba nji, ‘Mu nako icana feela?’ Katuyii esi atalusa.” ");
INSERT INTO lyn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesu muku limuka nji kame asinga okumwibanguta, cwale sebeli wamba kwa onyene nji, “Esi sokame mukwibanguta mukaci kenu nji ‘Mu nako icana feela kamutamba kunimona, mi mu nako icana kame mbamu nimono’? ");
INSERT INTO lyn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Niti luli kame ni myambela nji mba mu lili, mane kame sa mu bokolole, mi elitunga mba linyakalala. Mba mweene, kono okweena kwenu mba kufutuka okuwabelelwa. ");
INSERT INTO lyn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Omukati aba aleya kame akukalelwa, kakuli enako yaye na ikeela, kono aba amana okuleya omwana, ka puluka en̄alelwa yaye, mulibaka no kuwabelelwa nji omwana na leiwa mu litunga. ");
INSERT INTO lyn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Naanyi ngeso, kame muli mu likenyi bano, kono mba nimi mono kame emicima yenu mba iwabelelwa. Mi kakwisa omunu so mi byangula okuwabelelwa kwenu. ");
INSERT INTO lyn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ba liywaa elyo kamu tamba kuni ibanguta simweya. Niti luli kame ni myambela nji eso sonje sa mukumbele kwa Sitange, mba mibi so mu litina lyange. ");
INSERT INTO lyn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kubitela bano ka mu sikumbela simweya mu Litina lyange. Mu kumbele mi mba musi biwi, nji okuwabelelwa kwenu kutende okuno kwiyala. ");
INSERT INTO lyn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Kame nina myambele eyi mu tinguli. Kono enako kame iiya, eyi sa ni lesele okwamba naanyi mu tinguli, ni myambele eniti eyi ya Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Eliywaa elyo, kame sa mu kumbele mu Litina lyange, mi ka naamba nji mbani mi lapelele kwa Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kakuli Sitange yonyene kame amisinga, kakuli namu nisingi, mi kame muna pumene nji kame nina tundu kwa Sitange. ");
INSERT INTO lyn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kame nina tundu kwa Sitange, mi kame ni neeyi mu litunga kono cwale kame ni siya elitunga okuuka okuta kwa Sitange.” ");
INSERT INTO lyn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Aiyetwa aye sebeli aamba kwa yonyene nji, “Omone, cwale kame wamba wino, kasa okwamba mu tinguli. ");
INSERT INTO lyn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cwale na tu lemuha nji kame ulimuka einu yonje, mi ku saele nji omunu a kwibangute. Mumukwanongeso, kame tu pumena nji kame utunda kwa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesu sebeli otambula nji, “Cwale bano kame mu pumena? ");
INSERT INTO lyn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Enako kame ikeyile, mane naikeela, eyi sa muhasane, munu ni munu ku ndoo yaye mi mba mu ni siyi memboci. Kono ka nili memboci, kakuli Sitange kame ali ni mene. ");
INSERT INTO lyn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kame nina myambele eyo nji mwamene mwikale ni kozo mu micima mulibaka lyange. Kame sa muyandisiwe mu litunga kono mongole emicima, kame nina komo elitunga.” ");
INSERT INTO lyn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Cwale Jesu aba ana kumana okwamba amaywi awo, sebeli waliketa amiyo aye ku wilu ni kwamba nji, “Sitange, enako naikeela. Okanyise Mwanowe nji Omwana aku kanyise. ");
INSERT INTO lyn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kakuli kame ona mubi amaata beulu no aanu onje, okuba omoyo no kwaabwa kwa woyo yonje ona mubi. ");
INSERT INTO lyn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Uno omoyo no kwaabwa, nji aku limuke, wene Nyambe no niti ni Jesu Kilesite woyo ona kutuma. ");
INSERT INTO lyn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kame ni kukanyisa mu litunga, mukumana omusebezi ona kuniba mu litunga nji ni utende. ");
INSERT INTO lyn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Cwale bano Sitange, onikanyise ba lubala lowe ni kanya iya nina kwikala nayo ni weene abo elitunga ekalya sumbiwa kale.” ");
INSERT INTO lyn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Kame nina limukisa elitina lyowe kwaanu ona nibi mu litunga. Kame ali kwa wene mi nonibi woo mane na mamele eliywi lyowe, ");
INSERT INTO lyn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","cwale kame alimukile nji esinu sonje eso ona nibi, kame situnda kwa wene. ");
INSERT INTO lyn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kakuli kame ninaabi amaywi ona nibi, mi kame anaa tambula mane na limuka muniti nji kame ninatundu kwa wene, mi na pumene nji kame ona nitumu.” ");
INSERT INTO lyn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Kame na lapelela. Silapelele elitunga kono kame nilapelela awo ona nibi, kakuli owe. ");
INSERT INTO lyn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yonje eyo nili nayo yowe, mi yowe yange, mi kame ni kanyisiwa mwa onyene. ");
INSERT INTO lyn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Cwale bano silimo mu litunga, kono onyene kame ali mu litunga mi mene kame ni keyile kwa wene. Sitange No Kukena, wateule mu litina lyowe, elyo onanibi wene nji atende amweya kanyi aci. ");
INSERT INTO lyn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Abo meni sili noo, kame nina kwateula mu litina lyowe, awo ona kuniba, mi kame nina kwa sileleza mi kwa onyene kakwisa woyo ona tauka, konji woyo anakulimuka nji mbatauka, nji elin̄olo liiyatetetwe. ");
INSERT INTO lyn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kono bano kame ni iiya kwa wene, mi einu eyi naamba mu litunga, nji cwale aikale ni kuwabelelwa kwange nji iiyatetetwe mwa onyene. ");
INSERT INTO lyn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Kame ninaambele eliywi lyowe, mi elitunga kame lyatimbile kakuli onyene kaa ano litunga, kanyi mene aba ka nili osi litunga. ");
INSERT INTO lyn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ka niku lapelele nji wa tundise mu litunga, kono nji wa sileleze kwa woyo no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kasa ano litunga lino, kanyi mene aba ka nili osi litunga. ");
INSERT INTO lyn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Wakenise mu niti yowe kakuli eliywi lyowe lyokame eniti. ");
INSERT INTO lyn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kanyi aba ona nitumu mu litunga, cwale ni mene kame ninaa tumu mu litunga. ");
INSERT INTO lyn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mi mulibaka lyoo kame ni kukenisa menyene, nji nonyene abiwe okukenisa mu yonyene eniti. ");
INSERT INTO lyn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ka nilapelele onyene feela, kono kame ni lapelela ngeso nawo sa pumene mwa mene mu liywi lyoo. ");
INSERT INTO lyn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nji onje atende mumweya, kanyi wene Sitange aba uli kwa mene, ni mene kwa wene. Nonyene ngeso atende mumweya kwaaci, nji elitunga li pumene nji tiwe ona nitumu. ");
INSERT INTO lyn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ekanya eyo ona nibi kame ninaibi kwa onyene nji atende amweya kanyi aci aba tuli mumweya. ");
INSERT INTO lyn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mene, ni ikale kwa onyene, ni wene kwa mene, nji atendiwe asi kupetahala mu umweya, mi elitunga li limuke nji tiwe onani tumu, ninji kame onaa singi kanyi omu ona nisingele. ");
INSERT INTO lyn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Sitange, kame ni lakaza nji awo onanibi aikale ni mene omo nili, nji amone ekanya yange eyo onakuniba kakuli kame ona kunisinga elitunga eka lyasitendiwa kale. ");
INSERT INTO lyn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Wene Sitange no kuluka! Elitunga kalikuyii, kono mene nikuyii, mi nonyene kame ayii nji nauni tumu. ");
INSERT INTO lyn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kame ninaa simwete elitina lyowe, mi mba na simweta lyo, kakuli elilato ona nisingi liikale mwa onyene, mane nimene niikale mwa onyene.” ");
INSERT INTO lyn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Cwale Jesu aba ana kumana okwamba amaywi aa, sebeli ota naiyetwa aye mu linjaliya no Kasindi no Kediloni, omo kuna kwikala elitema, mi sebeli oingenamo na iyetwa aye. ");
INSERT INTO lyn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Cwale Judasi woyo ona kumu beteka, kame ana kulimuka esibaka eso, kakuli Jesu mwana ku kuwanenanga na iyetwa aye aka no kupula. ");
INSERT INTO lyn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Cwale Judasi sebeli oshimba esikwata no Masole ni tinumwana eti titunda kwa pulisita akulu nafalisi, sebeli ata mu litema ni tilambi ni mamonyi, mane neyi no kulwisa. ");
INSERT INTO lyn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Cwale Jesu muku limuka eso sasi mwiyele, sebeli wiiya kwa onyene ni kwamba nji, “Anyine musaela?” ");
INSERT INTO lyn_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Seli amutambula nji, “Jesu no Nazaleta,” Jesu sebeli wamba kwa onyene nji, “Yamene.” Judasi, ona kumubeteka, yo imanine noo. ");
INSERT INTO lyn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Aba ana kwaambela nji , mene uno, sebeli auka ngombemongo, ni kukwela banji. ");
INSERT INTO lyn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesu sebeli waibanguta kame nji, “Anyine mu saela?” Seli aamba nji, “Jesu no Nazaleta.” ");
INSERT INTO lyn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesu sebeli waatambula nji, “Kame nina myambele nji, yamene uno,” “Nji kame mu saela mene, mu lesele aa alume akutele.” ");
INSERT INTO lyn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Neli nji kwiyatetetwe eliywi eli ana kwamba nji, “Ka nisi taukelwa omunu simba mumweya, kwawo ona nibi.” ");
INSERT INTO lyn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Cwale Simoni Pitolosi ona kulema omukwale, sebeli oushomona ni kuuyaa omubika no mupulisita omukulu, mi sebeli omu patula elitwi no silyo, Omubika woyo kame ana kwisaniwa nji Malukuse. ");
INSERT INTO lyn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesu sebeli wamba kwa Pitolosi nji, “Ouse omukwale mu sipusu sao. Ninji nikwangwe okunwa mu sinweno esi ana nibi Sitange?” ");
INSERT INTO lyn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Cwale esikwata no masole ni mwendisi waso ni tinumwana naendisi no Majuda, sebeli alema Jesu ni kumu nunga, ");
INSERT INTO lyn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","mi sebeli amu twala oweli kwa Anasi, kakuli neli njemunwaye Kayafa woyo ona kutendanga omupulisita mukulu mu mwaka owo. ");
INSERT INTO lyn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa yokame ona kweleza aendisi no Majuda nji kame kufanena nji omunu mumweya afela aanu. ");
INSERT INTO lyn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Pitolosi kame ana kukon̄anga Jesu, bamweya ni mwiyetwa munjili. Omwiyetwa woyo kame ana kulimukiwa kwa mupulisita mukulu, cwale sebeli oingena bamweya ni Jesu mu lilapa no mupulisita mukulu, ");
INSERT INTO lyn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ababo Pitolosi yo imanine kundee ba mweelo. Cwale omwiyetwa munjili woyo ona kulimukiwa kwa mupulisita mukulu sebeli obanena kundee nukaamba ni mutateleli naba mweelo, mi sebeli oingenyeka Pitolosi mu lilapa. ");
INSERT INTO lyn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Cwale omutateleli naba mwelo sebeli wamba kwa Pitolosi nji, “Kana ni wene kame uli omunjili nwaa iyetwa no munu wuyu?” Pitolosi sebeli otambula nji, “Kokuulwa, kasa mene.” ");
INSERT INTO lyn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Cwale abika ni tinumwana tina kwikala omo sebeli atumbula omulilo, kakuli kame kuna kombola mi kame ana kwimana ayota omulilo. Ni yonyene Pitolosi na kwikala noo yoimanine okuyota omulilo. ");
INSERT INTO lyn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Omupulisita omukulu sebeli oibanguta Jesu mulibaka no aiyetwa aye ni tuto yaye. ");
INSERT INTO lyn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesu sebeli otambula nji, “Kame ninaamba aba no kukena kwaanu, aka no kupula kame nina kwa iyeta mu tindoo no milapelo, omo anaku kuwanenanga Amajuda onje, mi kanasi kwamba esinjili ku nyonga. ");
INSERT INTO lyn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Iikene aba oni ibanguta? Oibangute awo ana niyupu esi ninaamba kwa onyene kame ayii eyi naamba.” ");
INSERT INTO lyn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cwale Jesu aba ana kumana okwamba eyi, omunjili no atateleli ona kwimana abeebi ni yonyene, sebeli omu fula ni lyoko lyaye ni kwamba nji, “Mokame omo otambulela omupulisita mukulu!” ");
INSERT INTO lyn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesu sebeli omu tambula nji, “Nji kani saamba wino, otaluse eso sinaibi, kono nji kame ninaamba wino, siikene eso oni fulela?” ");
INSERT INTO lyn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Cwale Anasi sebeli omu tumena kwa Kayafa omupulisita omukulu yo nungilwe. ");
INSERT INTO lyn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Cwale Simoni Pitolosi yo imanine okututumuna ku mulilo. Seli aamba kwa yonyene nji, “Kasanji ni wene kame uli omunjili no aiyetwa aye?” Pitolosi sebeli okana ni kwamba nji, “Kokuulwa kasa mene.” ");
INSERT INTO lyn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Omunjili kwabika no mupulisita omukulu, omwabaye woyo ona ku patuliwa elitwi kwa Pitolosi, sebeli omwibanguta nji, “Kanisi ku kumona ni yonyene mu litema?” ");
INSERT INTO lyn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pitolosi sebeli okana kame mi ababo, omukombwe sebeli olila. ");
INSERT INTO lyn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Cwale sebeli atundisa Jesu mu ndoo ya Kefasi okumutwala ku kuta, neli amasiku. Kono onyene kasikwingena mu Kuta, nji cwale onyene aulwe ouku silafaza, kono atwese okulya Epaseka. ");
INSERT INTO lyn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Cwale Pilato sebeli obanena kwa onyene ni kwaibanguta nji, “Iikene mu mukandimeka wuyu mulume?” ");
INSERT INTO lyn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Sebeli amutambula nji, “Nji wuyu mulume kasitenda eyi no kwiiba, kambe katusi mulita kwa wene.” ");
INSERT INTO lyn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato sebeli wamba kwa onyene nji, “Mu mushimbe anyi, mi mu mwatule ni mulawo wenu.” Aendisi no Majuda sebeli amu tambula nji, “Kasa etukelo yetu nji twibae omunu.” ( ");
INSERT INTO lyn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Esi neli okwiyateteta eliywi elyo ana kwamba Jesu okumonisa elifu safe.) ");
INSERT INTO lyn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Cwale Pilato sebeli oingena mu Kuta kame ni kwisana Jesu ni kumwibanguta nji, “Tiwe Ombumu no Majuda?” ");
INSERT INTO lyn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesu sebeli otambula nji, “Kana kame okwambela feela mu maata owe nji anjili onakwambele yo mulibaka lyange?” ");
INSERT INTO lyn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato sebeli otambula nji, “Kana mene kame nili Omujuda? Aanu owe napulisita akulu kame ana kuliti kwa mene. Iikene ona tende?” ");
INSERT INTO lyn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesu sebeli otambula nji, “Omubuso wange kasa no litunga lino, kambe omubuso wange neli ouno litunga lino, kambe abika ange kame alwa ni kuulwa kuniba kwa endisi no Majuda. Kono cwale omubuso wange kasa wa litunga lino!” ");
INSERT INTO lyn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato sebeli oibanguta Jesu nji, “Kame uli Ombumu?” Jesu sebeli otambula nji, “Kame wamba nji kame nili Ombumu. Sokame esi nina leyelwe, mane sokame nina iyele mu litunga nji nipake eniti. Omunu yonje woyo oli no niti kame ayupa eliywi lyange.” ");
INSERT INTO lyn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato sebeli omwibanguta nji, “Cwale eniti niikene?” Munyima no kwamba eyi sebeli obanena kame ku Majuda ni kwaambela nji, “Kani siwana omubonda mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kono kame muli ni sizo senu nji kame nifanena okumi lukulwela omunu mumweya ba Paseka. Kame muni pumena nji nimi lukulwele Ombumu no Majuda?” ");
INSERT INTO lyn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Cwale sebeli akuwa kame nji, “Kokuulwa kasa wuyu mulume! Kono Banabasi!” Mi abo Banabasi neli sisinyi. ");
INSERT INTO lyn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Cwale Pilato sebeli oshimba Jesu ni kumushapa. ");
INSERT INTO lyn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mi amasole sebeli atinga en̄ata no myunguya ikufekile kanyi omushukwe ni kwibeeka ku mutwi wa Jesu mane sebeli amufuka esikumango no undilu ");
INSERT INTO lyn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","cwale sebeli asheteta kwa yonyene ni kwamba nji, “Yoosho, Ombumu no Majuda!” Mi alemine oku mufula ni maoko oo. ");
INSERT INTO lyn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato sebeli obana kame ni kwamba kwa onyene nji, “Komumone kame ni mulita kwaanyi cwale mulimuke nji kanisiwana omubonda mwa yonyene.” ");
INSERT INTO lyn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Cwale Jesu sebeli obana, yo ku fukile omushukwe no myunguya, ni sikumango no undilu. Pilato sebeli wamba kwa onyene nji, “Komumone wuyu munu!” ");
INSERT INTO lyn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Cwale apulisita akulu naanu oo, aba ana kumumona, sebeli akuwa nji, “Omungongotele! Omungongotele!” Pilato sebeli wamba kwa onyene nji, “Mu mushimbe anyi, mi mumu ngongotele, kakuli kani siwana omubonda mwa yonyene.” ");
INSERT INTO lyn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aendisi no Majuda sebeli amu tambula nji, “Kame tuli ni mulawo, mi mu mulawo wetu kame afanena okufa, kakuli kame ana kwamba nji Mwana Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cwale Pilato aba ana kuyupa amaywi awo, sebeli ocila onene. ");
INSERT INTO lyn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Seli oingena kame mu Kuta, mi sebeli oibanguta Jesu nji, “Kubine uka tundile?” Kono Jesu kasiku mutambula. ");
INSERT INTO lyn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato sebeli wamba kwa Jesu nji, “Iikene aba ka wamba nange? Ka uyii nji kame nili ni maata no kuku lukulula, ni maata no kuku ngongotela ba sifapano.” ");
INSERT INTO lyn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesu sebeli omutambula nji, “Kaukwite amaata beulu yange konji na wabiwi okutunda ku wilu, cwalehe woyo ona kubi mene kwa wene yokwite esibi no kuneneba.” ");
INSERT INTO lyn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mukuyupa amaywi awo, Pilato sebeli osinga oku mulukulula. Kono aendisi no Majuda sebeli akuwa nji, “Nji kame omu lukulula, kau sepahala kwa Sesale kakuli omunu yonje aba akutenda Oumbumu, kame alwisa Sesale!” ");
INSERT INTO lyn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Cwale Pilato aba ana kuyupa amaywi aa, sebeli otwala Jesu kundee, ni kwikala ba sipula no katulo, mu sibaka si isaniwa nji “Liwee limakilwe.” Mi mu Sihebelu kame italusa nji “Gabata.” ");
INSERT INTO lyn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Cwale neli eliywaa no ukutukiseta Epaseka, mi kame ina ku singa okutenda enako no kamwii luli likumi ni twiili, (12 okuloko). Mi Pilato sebeli wamba kwa endisi no Majuda nji, “Komumone, Ombumu wenu uno!” ");
INSERT INTO lyn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kono onyene kame ana kukuwa, nji, “Atwaliwe! Atwaliwe! Omungongotele!” Pilato sebeli wamba kwa onyene nji, “Ni ngongotele Ombumu wenu?” Kono apulisita akulu sebeli atambula nji, “Ka tukwite Ombumu mundina, konji Sesale!” ");
INSERT INTO lyn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Cwale Pilato sebeli waaba Jesu nji angongoteliwe ba sifapano. Mi sebeli ashimba Jesu, ni kuta naye. ");
INSERT INTO lyn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Cwale sebeli ashimba Jesu ni kushimbisa esifapano saye nikuta ku sibaka siisaniwa nji Katendele, eso siisaniwa nji Gologota mu Sihebelu. ");
INSERT INTO lyn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Abo sebeli amu ngongotela ba sifapano, nanjili ayiili, omunjili kweeli elineku, omunjili kweeli elineku, Jesu yoli mukaci koo. ");
INSERT INTO lyn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato sebeli on̄ola elin̄olo no kulimukisa ni kulituleka ba sifapano. Kame kuna kun̄oliwa nji, “Jesu no Nazaleta, Ombumu no Majuda.” ");
INSERT INTO lyn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Amajuda no kupula sebeli abala beulu no sifapano abo, kakuli esibaka ana ku ngongotelwa Jesu ba sifapano, kame sina kwikala abeebi ni mulenen̄i. Beulu kame kuna kun̄oliwa mu Sihebelu, mu Siloma, ni mu Singelike. ");
INSERT INTO lyn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Apulisita akulu no Majuda sebeli aiya mu kwambela Pilato nji, “Olese okun̄ola nji, ‘Ombumu no Majuda,’ kono on̄ole nji, ‘Yonyene ona kukwamba nji, Time Ombumu no Majuda.’” ");
INSERT INTO lyn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato sebeli otambula nji, “Esi nina n̄olo, na si n̄oliwa.” ");
INSERT INTO lyn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Cwale amasole aba ana kumana oku ngongotela Jesu ba sifapano, sebeli ashimba eikumango yaye, sebeli aitaba etikalulo tinee, nji omunjili ni munjili aikale ni saye. Seli ashimba ni sonyene esikumango na kunji kono esikumango eso kasi sikwikala ni mapeka, kame sina kutungiwa ngeso esinu simweya feela. ");
INSERT INTO lyn_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Seli akwambota mukaci koo nji, “Tulese okusikaula, kono tusi shebuluke, tu limuke nji kame sa sitende sa nyine.” Neli nji kutendahale esi sinambiwa mu lin̄olo nji, “Sebeli akutabela eikumango yange mi kame ashebuluka esikumango sange.” Sokame ana tende Amasole. ");
INSERT INTO lyn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Cwale abeebi ni sifapano sa Jesu kame kuna kwikala Inawaye ni minaye Inawaye, Maliya, omoywa Kulopasi, ni Maliya Magadalena. ");
INSERT INTO lyn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesu aba ana kumona Inawaye, ni mwiyetwa ana kusinga, aimanine abeebi ni yonyene, sebeli wamba kwa Inawaye nji, “Mukati, omone mwanowe.” ");
INSERT INTO lyn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Cwale Jesu sebeli wamba kwa mwiyetwa nji, “Komone, Inaowe.” Mi okutunda abo, omwiyetwa sebeli omu twala ku lilapa lyaye. ");
INSERT INTO lyn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Eyo aba ina kubwa, Jesu ba kulimuka nji einu yonje na ipetahala, sebeli wamba nji, elin̄olo liiyatetetwe “Kame nifile elinyotwa.” ");
INSERT INTO lyn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kame kuna kwikala esindunga sina kwiyala ebenega omo, cwale sebeli abeeka esiponji sina bekiwa mu benega niku sishomeka ku lunupa no hisopa, mi sebeli asi sheeteta ku kanwa kaye. ");
INSERT INTO lyn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Cwale Jesu aba ana kumana okunwa ebenega sebeli wamba nji, “Na kubu!” Cwale sebeli okobeka omutwi mane niku kuba Emebo yaye. ");
INSERT INTO lyn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kakuli neli eliywaa no Ukutukiseta omukiti no Paseka. Amajuda kasikusinga nji olutu lwikale ba sifapano ba liywaa no Pumulo kakuli Epumulo eyo neli eliywaa no utokwa onene, cwale aendisi no Majuda sebeli akumbela Pilato nji amakondo nwawo ali ba sifapano simba acoka mi mane kame atwesiwa okushimbiwa. ");
INSERT INTO lyn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Cwale amasole sebeli aiya nikucola amakondo no munu no weli ni wuyu no wiili awo ana kungongoteliwa ni Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kono aba ana kukeela kwa Jesu, sebeli amona nji nafu, kasi kucola amakondo aye. ");
INSERT INTO lyn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kono omunjili no masole sebeli omuyaa ku lubaci ni mbiinji, mi mu wangu sebeli otunda ounyinga ni meyi. ");
INSERT INTO lyn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mi woyo ona mono eyo ni paki, mi oupaki waye niwa niti, mi kame ayii nji kame aamba eyi no niti, nji naanyi mu pumene. ");
INSERT INTO lyn_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kakuli einu eyi naitendahala nji elin̄olo liiyatetetwe, eli lyaamba nji, “Kakwisa esifuba saye sasi coliwe.” ");
INSERT INTO lyn_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kame elin̄olo linjili kame lyamba nji, “Mba mono woyo ana yaa.” ");
INSERT INTO lyn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Aba ku nakubwa eyi, Josefa no Alimateya omwiyetwa wa Jesu, kono kunyonga mukucila aendisi no Majuda sebeli okumbela Pilato nji ashimbe olutu lwa Jesu. Mi Pilato sebeli opumena okushimba olutu lwa Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nekudemasi niyonyene ona kwiiya oweli ousiku kwa Jesu, sebeli oiya okulita milasi ni aloye inakuwanekiwa , inakukwana owima ukuma ba mwanda no tipondo. ");
INSERT INTO lyn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Seli ashimba esitupu sa Jesu, ni kusipungela mu lwambi bamweya neyo ina kuwanekiwa, mu mukwa no sizo no Majuda owo anakupumbeka nawo afu. ");
INSERT INTO lyn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mi mu sibaka ana ku ngongoteliwa kame kuna kwikala elitema, mi mu litema elyo kame kuna kwikala eliyumbelo no ubya, omo mu na kuulwa okupumbeka mo kale omunu. ");
INSERT INTO lyn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Cwale kakuli neli eliywaa no Majuda no Ukutukiseta omukiti no Paseka, mi kakuli eliyumbelo kame lina kwikala abeebi, sebeli apumbekamo Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Cwale ba liywaa no weli mu sunda, Maliya Magadalena sebeli omenekela ku liyumbelo kusiilolile mi sebeli omona nji eliwee na litundisiwa ba liyumbelo. ");
INSERT INTO lyn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Cwale sebeli oitukela kwa Simoni Pitolosi ni ku mwiyetwa woyo ona ku singiwa kwa Jesu, ni kwamba kwa onyene nji, “Kame ana tundisa Ombumu mu liyumbelo, mi katuyii oko ana mubeeke!” ");
INSERT INTO lyn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Cwale Pitolosi sebeli oimana ni mwiyetwa omunjili mi bamweya sebeli ata ku liyumbelo. ");
INSERT INTO lyn_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kame ana kwituka onje ayiili, kono omwiyetwa omunjili sebeli oituka okusiya Pitolosi, mane nukakeela oweli ku liyumbelo. ");
INSERT INTO lyn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Cwale sebeli onangelamo nikumona etinyambi ti bekilwe banji, kono kasi kwingena mo. ");
INSERT INTO lyn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Cwale Simoni Pitolosi sebeli okeela ona kumukon̄a, mi sebeli oingena mu liyumbelo. Seli omona etinyambi tibekilwe banji, ");
INSERT INTO lyn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ni lwambi luna kumufuka ku mutwi. Kono lonyene kalusi kubekiwa bamweya ni tinjili, kono lonyene kalu sikuwanekiwa ni tinyambi tinjili kono kame luna kupungiwa lomboci, olu bekilwe kunyonga. ");
INSERT INTO lyn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Cwale omwiyetwa omunjili ona kutateka okakeela ku liyumbelo, sebeli oingena ni yonyene mane nikumona, mi sebeli opumena. ( ");
INSERT INTO lyn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kakuli kasi kuyupisisa kale elin̄olo eli lyamba nji Jesu kame ana kufanena okwinguka kwaafu.) ");
INSERT INTO lyn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Cwale aiyetwa awo, sebeli aukela ku mindi yoo. ");
INSERT INTO lyn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kono Maliya sebeli oimana yo lila kundee no liyumbelo. Mi yolila sebeli obama ni kwaliketa mu liyumbelo ");
INSERT INTO lyn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ni kumona amangeloi ayiili akufukile eyi no likena, aikalile omo ana kulangeka olutu lwa Jesu, elinjili ku mutwi elinjili kwilyatiso. ");
INSERT INTO lyn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mi sebeli amwibanguta nji, “Mukati iikene olila?” Yonyene sebeli otambula nji, “Kakuli kame anashimbi Ombumu wange, mi kani yii omo ana mubeeke!” ");
INSERT INTO lyn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Osamba ngeso sebeli okutemuna ni kumona Jesu yo imanine, kono kasi kulimuka nji neli Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesu sebeli omwibanguta nji, “Mukati, iikene olila?” “Anyine osaela?” Yonyene ba kuyambuta nji niosi kulima elitema, sebeli wamba nji, “Molyange, nji wene ona mushimbimo, onambele omo ona mubeeke nika mushimbe.” ");
INSERT INTO lyn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesu sebeli wamba kwa yonyene nji, “Maliya!” Yonyene sebeli okutemuna ni kwamba kwa yonyene mu Sihebelu nji, “Labboni!” (Okutalusa nji, “Mwiyeti”.) ");
INSERT INTO lyn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesu sebeli wamba kwa yonyene nji, “Olese okunilema,” “Kakuli kani siuka kale kwa Sitange. Kono ote kwa singiwa ange okaambele nji, kame nita kwa Sitange yonyene Sitenu, kwa Nyambe wange yonyene Nyambe wenu.” ");
INSERT INTO lyn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maliya Magadalena sebeli ota nuka simweta aiyetwa nji kame ninamono Ombumu, ni kwaambela nji kame ana mwambele einu eyi. ");
INSERT INTO lyn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ba mangolwaa no liywaa elyo, eliywaa no matatekelo mu sunda emyelo eyi pakilwe omo ana kwikala aiyetwa okucila aendisi no Majuda, Jesu sebeli oiya mukwimana mukaci koo ni kwamba kwa onyene nji, “Ekozo ikale naanyi.” ");
INSERT INTO lyn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Jesu aba ana kumana okwamba ngeso, sebeli waamonisa amaoko ni lubaci lwaye. Cwale aiyetwa sebeli awabelelwa onene aba ana kumona Ombumu. ");
INSERT INTO lyn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesu sebeli wamba kwa onyene kame nji, “Ekozo ikale naanyi. Kanyi omu ana ni tumene Sitange, ni mene kame ni mituma ngeso.” ");
INSERT INTO lyn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Cwale aba ana kumana okwamba eyi, sebeli waoyelela beulu yoo mane nikwamba kwa onyene nji, “Mu tambule Emebo No Kukena. ");
INSERT INTO lyn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nji kame sa mulemene eibi no munu yonje, kame sa ilemenwe, nji kamwa lemene eibi yoo, katamba okwilemenwa.” ");
INSERT INTO lyn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Cwale Tomasi omunjili no kukwana likumi nayiili, (wisaniwa nji Mbile) ka sikwikala nonyene Jesu aba ana kwiiya. ");
INSERT INTO lyn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Cwale anjili aiyetwa sebeli amwambela nji, “Na tumono Ombumu!” Kono Tomasi sebeli wamba kwa onyene nji, “Konji aba sani mone mu maoko aye omo kunakuyaa esipikili mane nibeekemo omunwe wange mu lin̄iba muna kuyaa esipikili ni kulema amaoko ange ku lubaci lwaye, kani tamba kupumena.” ");
INSERT INTO lyn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Munyima no maywaa atanu ni aatu (8) aiyetwa aye aali kame mu ndoo ni Tomasi yoikalile noo. Emyeelo eipakilwe, kono Jesu sebeli okeela ni kwimana mukaci koo ni kwamba nji, “Ekozo ikale naanyi.” ");
INSERT INTO lyn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Cwale sebeli wamba kwa Tomasi nji, “Obeeke omunwe owe muno, omone ni maoko ange oshimbe amaoko owe obeeke ku lubaci lwange cwale olese oku tenda wuyu no kwapumena, kono opumene!” ");
INSERT INTO lyn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi sebeli otambula nji, “Ombumu wange, ni Nyambe wange!” ");
INSERT INTO lyn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesu sebeli wamba kwa yonyene nji, “Nupumene kakuli nu nimono? Embuyoti yawo ana pumene naba kasi mona!” ");
INSERT INTO lyn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Cwale Jesu natende etimakazo no kupula balubala no aiyetwa, eyo kaisi n̄oliwa mu buka eyi. ");
INSERT INTO lyn_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kono eyi nai n̄oliwa nji mupumene nji Jesu yokame Kilesite, Omwana Nyambe, mi cwale okupumena kwenu mwikale ni moyo mu litina lyaye. ");
INSERT INTO lyn_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Munyima no eyi, Jesu sebeli oku monahaza kame kwa iyetwa aye, kunyonga no lisa no Tibeliya mi sebeli oku monahaza mu mukwa ou. ");
INSERT INTO lyn_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Pitolosi, Tomasi woyo ona kwisaniwa nji Mbile, Natanaele na mu Kana no Galileya, naana a Zebediya, na njili ayiili no aiyetwa aye kame ano kuwana. ");
INSERT INTO lyn_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Pitolosi sebeli wamba kwa onyene nji, “Kame nita mu kuyamba.” Seli aamba kwa yonyene nji, “Naaci kame tuta niwene.” Seli ata mane nukaku longa mu wato, kono ousiku owo kasi kuuya esinjili. ");
INSERT INTO lyn_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Aba kuna kupatalala, Jesu sebeli oimana ba likamba, kono aiyetwa kasi kulimuka nji neli Jesu. ");
INSERT INTO lyn_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesu sebeli waaibanguta nji, “Anukana, kamu kwite ondi simba mumweya?” Seli amu tambula nji, “Ka kwisa.” ");
INSERT INTO lyn_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Cwale Jesu sebeli waambela nji, “Muyambe akanyandi ku lineku no silyo no wato, mi mba muwana esinjili.” Seli ayamba, mi sebeli akwangwa okuyambula akanyandi, mulibaka no tindi okupula. ");
INSERT INTO lyn_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Cwale omwiyetwa woyo ona kusingiwa kwa Jesu, sebeli wamba kwa Pitolosi nji, “Mbumu wuyu!” Cwale Simoni Pitolosi aba ana kuyupa nji Mbumu wuyu, sebeli okufuka esikumango saye kakuli kame ana kutundisa yo sebeza, ni kumatukela mu liwate. ");
INSERT INTO lyn_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kono aiyetwa anjili sebeli aiya ni wato alemine okuyambula akanyandi akaiyalile etindi. Kakuli kame ana kwikala abeebi kanyonyo ni likamba, neli amatambo no kukwana omwanda mumweya. ");
INSERT INTO lyn_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cwale aba ana kumana okufuweka owato ba likamba, sebeli amona amakala no mulilo abo ni ndi yoboniwabo ni sinkwa. ");
INSERT INTO lyn_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesu sebeli wamba kwa onyene nji, “Mu lite ku tindi eti muna uyu.” ");
INSERT INTO lyn_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Pitolosi sebeli oingena mu wato nikukokela akanyandi ku likamba aka kaneyala etindi no kuneneba eti tina kukwana omwanda mumweya ni makumi atanu ni twaatu (153) cwale simba nji etindi kame tina kupula ngeso, akanyandi kaka sikukauka. ");
INSERT INTO lyn_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesu sebeli wamba kwa onyene nji, “Mwiiye mulye.” Mi kwa iyetwa ka kwisa wuyu ona kongola oku mwibangute nji, “Tiwe anyine?” Kakuli kame ana kulimuka nji Mbumu. ");
INSERT INTO lyn_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Cwale Jesu sebeli oshetetako, ni kushimba esinkwa mane bamweya ni ndi mi sebeli waaba. ");
INSERT INTO lyn_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Aka cwale neli aka no waatu ako ana kukumonhaza kwa iyetwa munyima no kwingulwa kwaafu. ");
INSERT INTO lyn_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cwale aba ana kumana okusuka, Jesu sebeli oibanguta Simoni Pitolosi nji, “Simoni Omwana Jowani, kana kame oni singa okubita aa?” Seli otambula nji, “Ee Mbumu, kame uyii nji kame niku singa.” Jesu sebeli wamba kwa yonyene nji, “Olise otwana no mikoko yange.” ");
INSERT INTO lyn_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesu sebeli omwibanguta kame aka no wiili nji, “Simoni mwana Jowani kana kame oni singa?” Seli omu tambula nji, “Ee, Mbumu, kame uyii nji kame niku singa.” Jesu sebeli omwambela nji, “Olise emikoko yange.” ");
INSERT INTO lyn_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesu sebeli omwibanguta kame aka no waatu nji, “Simoni mwana Jowani, kana kame oni singa?” Pitolosi sebeli weena, kakuli Jesu kame ana ku mwibanguta emyendo yaatu nji, “Kana kame uni singa?” Mi Simoni sebeli wamba kwa yonyene nji, “Mbumu kame uyii einu yonje, kame olimukile nji kame niku singa!” Jesu sebeli omwambela nji, ‘Olele emikoko yange.’ ");
INSERT INTO lyn_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Niti luli kame ni kwambela nji, “Aba ona kwikala osili wuyu no ubya, kame onoku nunga olukanda wenyene, kame ono kwendelanga omu osingela, kono aba so kulubale, kame so olole amaoko, mi omunjili kame sa kununge olukanda, mi kame sa kutwale oko wasingi.” ");
INSERT INTO lyn_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesu kame ana kwamba ngeso okumonisa Pitolosi elifu safe okukanyisa Nyambe. Munyima no eyi sebeli wamba kwa Pitolosi nji, “Onikon̄e!” ");
INSERT INTO lyn_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pitolosi sebeli okutemuna, nikumona omwiyetwa ona ku singiwa kwa Jesu ywakon̄a, woyo ona ku shendamena ba saali sa Jesu mu nako no mulalelo, mi yokame woyo onakumwibanguta nji, “Mbumu, anyine woyo so kubeteka?” ");
INSERT INTO lyn_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Cwale Pitolosi aba ana ku mumona, sebeli oibanguta Jesu nji, “Mbumu, ngasibine sakwikale kwa wuyu mulume?” ");
INSERT INTO lyn_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesu sebeli omutambula nji, “Nji kame nisinga nji asiyale okutwala abo sanikaiyele, kwa wene iikene siliko? Onikon̄e!” ");
INSERT INTO lyn_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Cwale elibubo sebeli lihasana mu sicaba nji omwiyetwa wuyu katamba okufa. Kono Jesu kasi kumwambela nji katamba okufa. Kono nji nisinge nji aikale okutwala aba sa nikeyele, cwale eso siikene kwa wene? ");
INSERT INTO lyn_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wuyu yokame omwiyetwa woyo opaka etitaba eti, mi yokame ona tin̄olo mi kame tuyii nji oupaki waye niwa niti. ");
INSERT INTO lyn_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kono kweeli einu injili no kupula eyo ana kutenda Jesu. Kambe yonje nai kun̄oliwa kame nisepa nji elitunga kalitwese okuteula eyo ina n̄oliwa.");
INSERT INTO lyn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mutompehi Teofilasi, mu buka no matatekelo, kame nina kun̄ola etingambolo no inu yonje ana ku tenda Jesu ni kwiyeta ");
INSERT INTO lyn_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","okutwala ba liywaa ana ku shimbelwa ku wilu, aba ana kumana okuba etaelo mu maata no Mebo No Kukena kwaa tumiwa awo ana kuketa. ");
INSERT INTO lyn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Munyima no mayando aye sebeli okumonahaza kwa onyene yo yoya mu ukumonahaza aka no kupula mu maywaa anakukwana makumi anee (40) mi yo lemine okwamba eyi no mubuso wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yo ikalile noo, sebeli waaba etaelo nji mulese okutunda mu Jelusalema, kono mu tatelele esepiso ya Sitange eyo ana kwamba, eyi muna yupu kwa mene. ");
INSERT INTO lyn_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kakuli Jowani naku kolobeza ni meyi, kono kakwisa amaywaa no kupula okutunda abano anyi mba mukolobeziwa ni Mebo No Kukena. ");
INSERT INTO lyn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Cwale atumiwa aba ana kukuwana ni Jesu, sebeli amwibanguta nji, “Mbumu, ninji ba nako ino kame so usete omubuso kwa Isilaele?” ");
INSERT INTO lyn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesu sebeli waatambula nji, “Ka musibiwa okulimuka enako simba emiaka eyo ana beeke sitange mu maata aye. ");
INSERT INTO lyn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kono mba mutambula amaata aba saiiye Emebo No Kukena baanyi, mi kame samutende etipaki tange mu Jelusalema, ni mu Judeya ni mu Samaliya moonje, ni kutwala ku mamaneneno no litunga.” ");
INSERT INTO lyn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Aba ana kumana okwamba ngeso, sebeli oshimbelwa ku wilu amwalikete, mi elikumbi sebeli limutundisa mu miyo oo. ");
INSERT INTO lyn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yo katile ku wilu, mi onyene aaliketile ku wilu, ababo alume ayiili akufukile etinyambi no likena, sebeli aiya mukwimana ku nyonga yoo. ");
INSERT INTO lyn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Sebeli aamba nji, “Aanyi alume no Galileya, ngasibine aba mwimanine me mwaliketile ku wilu? Uyu Jesu, ona shimbiwa okuta ku wilu, mbaiyi mundila imweya kanyi omo mumumonena yo katile mu wilu.” ");
INSERT INTO lyn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Cwale atumiwa aba ana kuukela ku Jelusalema okutunda ba lilundu no itondo ya Olibe, eli lili beebi ni Jelusalema mi omusipili wateni kame okukumanena ni liywaa no Sabata ba ku weenda. ");
INSERT INTO lyn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Cwale aba ana kwingena mu mulenen̄i, sebeli ata ku musiyo oli kuwilu omo ana kwikalanga Pitolosi, ni Jowani, ni Jakobo, ni Andiliyasi, ni Filipi, ni Tomasi, ni Batolome, ni Mateu, ni Jakobo omwana Alufeya, ni Simoni Zeloti, ni Judasi omwana Jakobo. ");
INSERT INTO lyn_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Onje aa muumweya sebeli aongoteteta oku lapela, bamweya naakati, okubekabo ni Maliya inawaye Jesu, na inaaye. ");
INSERT INTO lyn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mu maywaa awo Pitolosi sebeli oimana mukaci no aasikupumena bamweya naaanu no kupula aa akwana omwaanda naanu makumi ayili (120), ni kwamba nji, ");
INSERT INTO lyn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Aalikani ange, elin̄olo kame lifanena okwiyatetetwa, elyo ku Mebo No Kukena eli lina kwambiwa kwa Dabida, eli lyaama oku kumanena eya Judasi woyo ona kutwaletela aa ana kununga Jesu. ");
INSERT INTO lyn_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kakuli neli omunjili mwaaci mi kame ana kubiwa ekalulo mu musebezi wetu.” ( ");
INSERT INTO lyn_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Cwale wuyu mulume sebeli oula elitema ni mupuzo no mali no uyii waye, mi sebeli okwela banji ni kukauka bakaci mi einu na mu lipumo lyaye sebeli itundela bandee. ");
INSERT INTO lyn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Cwale etaba eyi sebeli ilimukiwa kwaanu onje ana kwikala mu Jelusalema, mi elyo litema sebeli liisaniwa nji Hakeludama mu mushobo woo, okutalusa nji, “Elitema no unyinga.”) ");
INSERT INTO lyn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Kakuli kame ku n̄olilwe mu buka no Lisamu nji, ‘Cwale esibaka saye sifutuke amatota, cwale mi kuulwe omunu so yoya mo.’ Kame kun̄olilwe kame nji, ‘Mi esibaka saye no musebezi sishimbiwe ku munjili.’ ");
INSERT INTO lyn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Abakulingeso, omunjili kwa lume onakwendanga naaci mu nako yonje Mbumu Jesu yoenda naaci, ");
INSERT INTO lyn_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","okutangisa ba kolobezo ya Jowani okulita ba liywaa ana ku shimbiwa kwaaci, omunjili kwa lume aa kame afanena okutenda opaki naaci ku kwinguka kwaye.” ");
INSERT INTO lyn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Cwale sebeli alita aanu ayili, Josefa osi litina lya Basabasi, (nakwisaniwa kame nji, Jusitasi) ni Matiyasi. ");
INSERT INTO lyn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Cwale sebeli a lapela ni kwamba nji, “Mbumu, weene olimukile emicima no aanu onje, otumonise kwaa ayili anyine ona kete ");
INSERT INTO lyn_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nji ashimbe esibaka mu situlo ni muutumiwa owo ana tundu Judasi, ni kuta ku sibaka saye.” ");
INSERT INTO lyn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Cwale sebeli ashebuluka oonje, mi sebeli kulemiwa Matiyasi, woyo ona kwekiziwa kwao atumiwa likumi ni mumweya. (11) ");
INSERT INTO lyn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Cwale eliywaa no Pentakota aba lina ku keela, onje kame ana kuungana mu sibaka simweya. ");
INSERT INTO lyn_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ababo sebeli kuyupahala omulumo ona kutundelela ku wilu kanyi Emebo no lin̄ungwa, mi sebeli iiyala endoo yonje omo ana ikalanga. ");
INSERT INTO lyn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Cwale sebeli ku monahala kwa onyene eso sikufekile kanyi etindimi no mulilo, awo aku tabile mi ni kwiiya mu kwikala beulu yoo ba munjili ni munjili. ");
INSERT INTO lyn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Onje kame ana kwiyala ku Mebo No Kukena mi sebeli atangisa okwamba mu tipuwo tindina, omo Emebo No Kukena ina kwaa bela okwamba. ");
INSERT INTO lyn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Cwale kame kuna kwikalanga aendisi no Majuda mu Jelusalema, awo ana kucilanga Nyambe aa atundelela mu tinaha tonje na mu litunga. ");
INSERT INTO lyn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Cwale omulumo owo aba una kuyupahala aanu no kupula sebeli aunganako, mi kame ana kukomoka, kakuli onje kame ana kwayupa aamba mu tipuwo too. ");
INSERT INTO lyn_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mi onje kame ana kukomoka onene, ni kwamba nji, “Kasa nji aa onje aamba ni Magalileya? ");
INSERT INTO lyn_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Cwale iikene aba twaa yupa aamba mutipuwo tetu toonje? ");
INSERT INTO lyn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Aaci Amapanta ni Mamede ni Maelami naa ayakile mu Mesopotoniya, ni mu Judeya ni mu Kapadosiya, mu Ponto ni mu Esiya, ");
INSERT INTO lyn_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","aa na ku Filikiya ni Panfiliya, Egepita naa ali mu ibaka no Lebiya ikubapile ni Silene naa atunda mu mindi no Loma, oonje Majuda ni mapulosebelite, ");
INSERT INTO lyn_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Amakilete ni Maalabe, kame twa yupa aamba mu malimi etu omusebezi no kuwaba wa Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mi oonje kame ana kukomoka ni ku hakanyeha, akwambisa oonje nji, “Eyi taba kame italusa iikene?” ");
INSERT INTO lyn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kono anjili sebeli aasheka okwamba nji, “Kame akolilwe ni waine no ubya!” ");
INSERT INTO lyn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kono Pitolosi sebeli oimana naa akwana likumi ni mumweya ni kwamba ni liywii no kuyupahala onene nji, “Anyi aanu na mu Judeya naanyi monje muyoya mu Jelusalema, mulimuke etaba eyi, mi muteetete wino ku maywi ange. ");
INSERT INTO lyn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Aa aanu kasikoliwa, omo mu hupulela, kakuli ino isili ehola no (9 okoloko), ");
INSERT INTO lyn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","kono esi esi nakwambiwa kwa munuhi wa Nyambe Jowele nji, ");
INSERT INTO lyn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Cwale enako no mamaneneno aba saiye, kame kwamba Nyambe, kame sani itele Emebo yange ba munu yonje. mi aanenu no ashimani naa no akatana kame sa nuhe, mi andumbana enu mba mono etipono, mi naa supali enu mbaa loto etitolo. ");
INSERT INTO lyn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ee, mi mane naabika ange no alume naa no akati mu maywaa awo, mba na itele Emebo yange mi kame sa nuhe. ");
INSERT INTO lyn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kame sani tende etimakazo mu wilu neyi saimonahale ba litunga bano banji. ounyinga, ni mulilo, ni wise ");
INSERT INTO lyn_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","eliywaa kame saali futuke okutenda ouwi okweti afutuke kanyi ounyinga, abo eliywaa lya Mbumu ekalya siiya kale, eliywaa linene eli lilimukiwa. ");
INSERT INTO lyn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mi cwale ao onje aisana ba litina lya Mbumu kame sayoyisiwe.’ ");
INSERT INTO lyn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Anyi alume no Esilaele, muyupe amaywi aa! Jesu no Nazaleta omulume muna limukisiwa kwa Nyambe ni emisebezi no kongola, ni timakazo, ni tiponiso eyo ana kutenda Nyambe mwa yonyene mukaci kenu, kanyi omo mulimukele naanyi. ");
INSERT INTO lyn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wuyu Jesu ona kubetekiwa mu muhupulo ni mukulimuka kwa Nyambe, na muku mungongotela ni ku mwibaa ni maoko aawo asiku tenda ouyi. ");
INSERT INTO lyn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kono Nyambe na ku mwingula kwaafu, okumu lukulula kweeyi no kucilisa no aafu, kakuli ka kwa siku twesahala nji anungiwe ku lufu. ");
INSERT INTO lyn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kakuli Dabida abaamba okukumanena ni yonyene nji, “Kame ni monanga Ombumu balubala wange enako yonje, kakuli kame ali ku Lyoko lyange no silyo mi kanitamba okunyanganyisiwa. ");
INSERT INTO lyn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","cwale abo omucima wange kame onaku wabelelwa, mi olulimi lwange kame lunaku nyakalala. mane ni lutu lwange mba luyoyo mu sepo, ");
INSERT INTO lyn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kakuli kautamba kuleselela Emebo yange mu sibaka no afu, simba nji oleselele woyo no kukena nji aole. ");
INSERT INTO lyn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kame ona nimonisa endila ita ku moyo, mi okumonahala kowe kame sakuni iyate oku nyakalala.” ");
INSERT INTO lyn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Abaange, kame ni myambela epatalaza eyi no njekulyetu Dabida nji kame ana kufa ni kupumbekiwa, mi elibita lyaye kwa lisili kwaaci ni balelo lino. ");
INSERT INTO lyn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Mu kutenda omunuhi wa Nyambe, ni mu kulimuka nji Nyambe kame ana musepisa mukweeta kwaye nji kame sakutunde omunjili ku lusika lwaye ni kwikala ba lubona lwaye. ");
INSERT INTO lyn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","kame ana kumona eyi nakuuso ni kwamba eyi no kwinguka kwa Kilesite nji, ‘Katamba okuleselelwa musibaka no ao no kufa, simba nji olutu lwaye luole.’ ");
INSERT INTO lyn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yokame Jesu ona ingulwa kwa Nyambe kwaafu, mi mutaba eyo aaci toonje kame tuli etipaki. ");
INSERT INTO lyn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Munyima no kukambamisetwa ku Lyoko no silyo lya Nyambe, mi sebeli otambula Emebo No Kukena ana ku sepisiwa kwa Sitaye, cwale na iitelwe kwaaci yo mumona ni ku yupa. ");
INSERT INTO lyn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kakuli Dabida kasiku kambamena ku wilu, kono yo kame onamba nji, ‘OMBUMU naamba kwa Mbumu wange, Oikale ku Lyoko lyange no silyo ");
INSERT INTO lyn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","konji aba sani tende eila yowe esipula no malyatelo no makondo owe.’ ");
INSERT INTO lyn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Cwale mulesele onje asi ndoo no Isilaele alimuke eniti nji Nyambe na mutende oumbumu ni Kilesite wuyu Jesu woyo munaku ngongotela!” ");
INSERT INTO lyn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mi cwale aba ana kuyupa eyi, kaa sikukuyupa wino ku micima mi sebeli aamba kwa Pitolosi ni kwa atumiwa onje nji, “Abeetu, ngasibine sa tu tende?” ");
INSERT INTO lyn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Cwale Pitolosi sebeli wamba kwa onyene nji, “Mubake mi mu kolobeziwe moonje mu litina lya Jesu Kilesite nji mu lemenwe ku ibi yenu, mi mba mu tambula empo no Mebo No Kukena. ");
INSERT INTO lyn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kakuli esepiso kame ili kwaanyi ni kwaa nenu ni kwao ali oku no kuleba, awo onje sa isaniwe kwa Mbumu Nyambe wetu. ");
INSERT INTO lyn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pitolosi kame ana kwa kutaza ni maywii amanjili no kupula ana kwa kumbela, yo amba nji, “Mu ku babalele ku lusika olo no kwiiba!” ");
INSERT INTO lyn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Cwale awo ana ku tambula amaywii aye sebeli akolobeziwa, mi kame sebeli kwekeziwa aanu no kukwana eikiti yaatu (3;000) ba liywaa elyo. ");
INSERT INTO lyn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mi cwale sebeli aongoteteta onyene mu tuto no atumiwa, ni muukuwana, muukutabela esinkwa ni mu titapelo. ");
INSERT INTO lyn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mi okucila sebeli kwikala mwaanu onje, mi etimakazo no kupula ni tiponiso na ikutendahala mwa atumiwa. ");
INSERT INTO lyn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mi asikupumena sebeli aikala bamweya nukutabela einu yoo yonnje. ");
INSERT INTO lyn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mi kame ana kuulisa amatema oo ni ufumu woo ni ku tabela aanu onje, omo ana kusaelela omunu yonje. ");
INSERT INTO lyn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mi mu liywaa ni liywaa kame ana kwikalanga bamweya mu ndoo ya Nyambe, nuukutabela esinkwa mu tindoo too, kame ana kulya eilya yoo mu tabo ni micima no kuwabelelwa. ");
INSERT INTO lyn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Aalemine okulumbeka Nyambe ni ku wabelelwa kwaanu onje. Mi mu liywaa ni liywaa Nyambe kame na kuekeza ku palo no awo anakuyoyisiwa. ");
INSERT INTO lyn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Cwale Pitolosi ni Jowani kame ana ku kambemena ku ndoo ya Nyambe ba nako no milapelo, enako no munji eitenda eyi no waatu (15:00 okoloko). ");
INSERT INTO lyn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mi kame kuna kwikala omulume no siyanga okutunda ba kuleiwa kwaye kame ana kushimbiwangwa, woyo ona kubekiwangwa ba mwelo no limota lya Jeluslema mu liywaa, owo ona kwisaniwa nji wa kuwaba nji akumbele etuso kwaanu awo ana kwingenanga mu ndoo ya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Cwale aba na kumona Pitolosi ni Jowani aingena, sebeli waakumbela amali. ");
INSERT INTO lyn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Mi Pitolosi sebeli omwaliketa, bamweya ni Jowani ni kwamba nji, “Otwa likete!” ");
INSERT INTO lyn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Cwale yonyene sebeli waaliketa ni ku tatelela okutambula esinjili okutundelela kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kono Pitolosi sebeli omwambela nji, “Mene sikwite esilibela ni gauda, kono kame ni kuba esi nikwite, mu litina lya Jesu Kilesite no Nazaleta, oimane wende!” ");
INSERT INTO lyn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pitolosi sebeli omushimba ni Lyoko no silyo ni ku mwimeka, mi ababo amakondo ni tingongo taye sebeli yongola. ");
INSERT INTO lyn_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Mi sebeli omatoka ni kwimana ni kweenda ni kwingena mu lilapa no ndoo ya Nyambe nonyene, yo enda ni ku matoka ni ku lumbeka Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mi aanu onje sebeli amumona yo enda ni ku lumbeka Nyambe, ");
INSERT INTO lyn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","sebeli amulimuka nji yokame osikukumbela etituso ba mweelo no kuwaba no ndoo ya Nyambe, mi kame ana kukomoka onene ni kumakala kweyo ina tendahala kwa yonyene woyo mulume. ");
INSERT INTO lyn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Abo yo situndamene Pitolosi ni Jowani, aanu onje sebeli aitukela kwa onyene mu sibaka no mukunda wa Solomoni, akomokile onene. ");
INSERT INTO lyn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Mi cwale Pitolosi aba na mono ngeso sebeli waambela aanu nji, “Alume no Isilaele, iikene aba mu komoka etaba eyi, simba iikene aba mu twaliketile ngeso, kanyi ni mu maata etu simba ni mu kukuna kwetu kwa Nyambe aba tuna twese wuyu mulume nji aende? ");
INSERT INTO lyn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nyambe wa Abulahama ni wa Isaka ni wa Jakobo, Onyambe wa anjekulyetu, kame ana kanyisa omubika waye Jesu, woyo muna kuba ni ku mu kana balubala wa Pilato, naba ana kusinga nji amu lukulule. ");
INSERT INTO lyn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kono kame mu na kukana uyu no kukena ni kuluka, mi kame muna kukumbela omwibai nji alukululwe. ");
INSERT INTO lyn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Namukwibaa omunya moyo, woyo ana kwingula Nyambe kwaafu, mi aaci kame tuli etipaki no taba eyi. ");
INSERT INTO lyn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mi elitina lyaye, mulibaka no tumelo mu litina lyaye, na li ongota wuyu mulume woyo mu mona ni ku limuka mi ni tumelo mwa Jesu na ibalisa wino wuyu mulume balubala wenu moonje.” ");
INSERT INTO lyn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Cwale bano, abange, Kame ni limukile nji kame mutenda mukwalimuka, kanyi omo anaku tendala aendisi enu. ");
INSERT INTO lyn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kono eyo ana kwamba Nyambe ni tunwa no anuhi aye onje, nji Kilesite waye mba yanda, naiyatetetwe cwale. ");
INSERT INTO lyn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mubake cwale, mi musiuluke kame, nji eibi yenu ilemeniwe, enako eyo sakwiiye okuwetuluka sakutunde kwa Mbumu, ");
INSERT INTO lyn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","mi cwale kame sa tume Kilesite ona ketelwe aanyi, yonyene Jesu. ");
INSERT INTO lyn_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Woyo eliwilu kame lifanena okutambula okutwala enako eyo einu yonje abasa itendiwe eyino ubya eyo Nyambe ana kwamba ni tunwa no anuhi aye nokukena okutunda ku kale. ");
INSERT INTO lyn_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mushe na kwamba nji, ‘Mbumu Nyambe mba tumu kwaanyi omunuhi okutunda kwaabenu kanyi omo anakuni tumena. Kame samu tetete kwa yonyene mu inu yonje eyo samiambele. ");
INSERT INTO lyn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mi kame sakutende nji omunu yonje woyo soulwa oku teteta kwa munuhi wa Nyambe mba sinyiwa okutunda kwaanu.’ ");
INSERT INTO lyn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Cwale anuhi a Nyambe onje aa anamba elin̄usa, okutunda kwa Samuele naa aneyi munyima, kame ana nuhu etinako eto. ");
INSERT INTO lyn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kame muli aana no anuhi a Nyambe ni ulikani owo Nyambe ana kuba kwanjekulyenu. Ana kwamba kwa Abulahama nji, ‘cwale mu lusika lowe aanu onje na ba litunga mba fuyauliwa.’ ");
INSERT INTO lyn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nyambe nakutuma omubika waye kwaanyi oweli, okumi fuyola okufutula omunu yonje mwaanyi okutunda kuufokoli wenu.” ");
INSERT INTO lyn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Cwale alemine okwamba kwaanu, apulisita ni omukulu no atateleli no ndoo ya Nyambe na Saduki sebeli aiya kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Atinine kakuli kame ana kwiyetanga aanu ni kupaka mwa Jesu eyi no kwinguka kwaafu. ");
INSERT INTO lyn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Cwale sebeli aanunga ni kwabeka mu tolongo okutwala ba liywaa linaku tatamako, kakuli neli amangolwaa. ");
INSERT INTO lyn_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kono anokupula anakuyupa eliywi kame anaku pumena, mi epalo no aanu kame inaku kwana eikiti mutanu (5;000). ");
INSERT INTO lyn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Eliywaa linaku tatamako abusisi oo na kulu, na iyeti no mulawo wa Mushe sebeli aungana mu Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Aali ni Anna omukulu no apulisita ni Kayafa, ni Jowani, ni Alekizanda, nanjili no lubasi no apulisita akulu. ");
INSERT INTO lyn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Cwale aba ana kumana okwaimeka mukaci koo, sebeli aaibanguta nji, “Ka maata simba ka litina lya nyine mukutusisa okutendisa einu eyii?” ");
INSERT INTO lyn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Cwale Pitolosi yo iyalile Emebo No Kukena, sebeli wamba kwa onyene nji, “Abusi no aanu na kulu, ");
INSERT INTO lyn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nji balelo kame twiibangutiwa okukumanena kweyi no kuwaba ina tendiwa ku mulume no sihole ni mumukwa ubine ana balisetwe, ");
INSERT INTO lyn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ilimukiwe kwaanyi moonje naanu onje no Isilaele, nji mu litina lya Jesu Kilesite no Nazaleta, woyo munaku ngongotela ba sifapano, woyo Nyambe ana ingula kwaafu, mwa yonyene uyu mulume kame aimanine wino balubala wenu. ");
INSERT INTO lyn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‘Eli eliwee muna kukana anyi ayaki kono kame lina futuka omutomo no muyako.’ ");
INSERT INTO lyn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Cwale okuyoisisa kakusako ku munu yonje, kakuli kakwisa elitina linjili munji no liwilu eli libilwe kwaanu nji tuyoyiswe mwa lyonyene.” ");
INSERT INTO lyn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Cwale aba ana mona oundume wa Pitolosi ni Jowani sebeli alemuha nji kaasiku kwiyeta, mi neli aanu feela alume no utokwa sebeli akomoka ni lemuha nji kame na kwikalanga ni Jesu. ");
INSERT INTO lyn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kono ba kumona omulume onaku balisiwa oimanine kunyonga yoo, sebeli aulwa nesi ana kwamba. ");
INSERT INTO lyn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kono cwale aba ana kumana okwaa laela nji atunde ba kuta, sebeli atangisa okwaambisa mu kaci koo nji, ");
INSERT INTO lyn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Iikene sa tutende kwaa alume?” Kakuli emakazo eyi ilimukiwa ina tendiwa kwa onyene kame inayupahala kwaanu onje aa ayakile mu Jelusalema, mi katu twese okwilatula. ");
INSERT INTO lyn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kono nji etaba eyi yulwe oku yupahala kwaanu, twaakanise onene okwamba kame ku munu yonje mu litina lya Jesu.” ");
INSERT INTO lyn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Cwale sebeli aaisana ni kwaambela nji alese okwamba simba okwiyeta kame mu litina lya Jesu. ");
INSERT INTO lyn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kono Pitolosi ni Jowani sebeli aatambula nji, “Mu kwatule mwenyene nji kame kulukile mu miyo a Nyambe okumikuteka , aanyi mwatule. ");
INSERT INTO lyn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kakuli aaci katutwese okulesela okwamba eyi tuna mono neyi tuna yupu.” ");
INSERT INTO lyn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Cwale aba ana kumana okwacilisa sebeli aalukulula nji akutele. Kasikuwana oufosi nji aabe ekoto, mulibakano aanu onje kame anaku lumbeka Nyambe kweyo inaku tendahala. ");
INSERT INTO lyn_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kakuli omulume woyo inaku tendahalela emakazo no ku balisiwa kame ana kwikala ni myaka ibitelela makumi anee. ");
INSERT INTO lyn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Cwale aba ana kumana oku lukululwa sebeli ata kwaa likani oo ni kwaambela eyo anaambele apulisita akulu na kulu. ");
INSERT INTO lyn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Cwale aasikupumena aba ana kuyupa eyi, sebeli atumusa ku maywii oo onje oku lapela kwa Nyambe ni kwamba nji, Mbumu, wene ona uumbu eliwilu ni litunga ni liwate neyi ilimo! ");
INSERT INTO lyn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kame ona kwamba ni kanwa no mushemi wetu Dabida, omubika wowe, okwamba ni meyo no kukena nji, ‘Iikene amacaba aba atwebile, mi aanu ikene alelela eyi na mbulwa tuso? ");
INSERT INTO lyn_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","aambumu no litunga kame ana lumelelana, na endisi kame aku wanine bamweya okulwisa MBUMU ni ku lwisa Omuwabiwa waye.’ ");
INSERT INTO lyn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Niti luli mu mumulenen̄i kame ana kukuwana bamweya okulwisa omubika no kukena woyo ona kuketa, onje Heloda ni Ponse Pilato na simacaba naanu no Isilaele. ");
INSERT INTO lyn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kame ana tende einu yonje eyi mu maata owe ni mulelo wowe eyo una kulela eyaka sitendahala kale, nji itendahale. ");
INSERT INTO lyn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Cwale bano, Mbumu, omone emihupulo yoo, mi obe abika owe amaata no kwamba eliywi lyowe mu undume. ");
INSERT INTO lyn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Cwale wolole elyoko lyowe oku balisa, mi etiponisa ni timakazo titendiwe mu litina lya Jesu omubika wowe no kukena.” ");
INSERT INTO lyn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cwale aba ana ku mana oku lapela, esibaka omo ana kukuwanena bamweya sebeli sizikinyeha. Mi oonje sebeli aiyala ni Mebo No kukena ni kwamba amaywi a Nyambe ni undume. ");
INSERT INTO lyn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Cwale esikwata no aasikupumena sinakukuwana neli sa mucima ni mebo imweya. Kakwisa mukaci koo ona kwamba nji esinu ali naso nisaye yomboci, kono kame ana kuku tabelanga esinu akwite omukoo onje. ");
INSERT INTO lyn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Cwale mu maata no kuneneba atumiwa ana kupaka onene okwinguka kwa Mbumu Jesu, mi esishemo sinene nasikwikala kwa onyene onje. ");
INSERT INTO lyn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kakwisa omunu ona kusinga esinjili mwa onyene. kakuli ano kupula awo anakwikala ni matema simba etindoo kame ana kuyulisanga, ni kulita amali nweso sina ulisiwa, ");
INSERT INTO lyn_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","mi ni kusibeeka ku makondo no atumiwa, mi munu ni munu kame ana kutabelwanga omo asingela. ");
INSERT INTO lyn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Cwale Josefa ona kwisaniwa kwa atumiwa nji Banabasi (okutalusa nji, “Omwana no susuwezo”), neli Mulibi, onaku leyelwa mu Saipulisi, ");
INSERT INTO lyn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","sebeli oulisa elitema lyaye, ni ku lita amali, ni kwabeeka ku makondo no atumiwa. ");
INSERT INTO lyn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kono omulume wiisaniwa Ananiasi ni moywaye Safila sebeli aulisa esemba no litema lyoo. ");
INSERT INTO lyn_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Kono mu tingana no moyo waye sebeli oteulako amanjili amali awo anaku ulisako ni kulitako fela amanjili amali ni kwabeeka ku makondo no atumiwa. ");
INSERT INTO lyn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Cwale Pitoosi sebeli wamba nji, “Ananiasi, ikene Satani aba ona mulumelele mu mucima wowe nji woonge Emebo No Kukena okuteulela ku mali ona ulisa elitema? ");
INSERT INTO lyn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Abo owasiku ulisa kale elitema neli lyowe, mi naaba onamana okuli ulisa, amali asitendile owe. Kasa neli omuhupulo wowe? Iikene cwale ona tendele ngesi mu mucima wowe? Kausonga aanu, kono kame onaungo Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cwale Ananiasi aba ana kuyupa amaywi aa, sebeli okwela banji ni kufa. Mi aanu onje ana kuyupa etaba eyi sebeli acila onene. ");
INSERT INTO lyn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Andumbana sebeli aiya ni kufuka olutu lwaye ni kumutwala oka mu pumbeka. ");
INSERT INTO lyn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Munyima no nako itenda etihola taatu moywaye sebeli okeela, yo kalimukile eyi ina tendahala. ");
INSERT INTO lyn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pitolosi sebeli omwibanguta nji, “Ona mbele nji kame muna ulisa elitema amali akuma aba?” Mi sebeli otamula nji, “Ee, banakumu.” ");
INSERT INTO lyn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kono Pitolosi sebeli wamba kwa yonyene nji, “Ngaibi muna lumelelana moonje okweteka Emebo no Mbumu? Omone, amakondo aawo anati muku pumbeka mbumowe aa okame ba mwelo, mi kame saku sakutwale ni wene!” ");
INSERT INTO lyn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ababo sebeli okwela banji ku makondo aye ni kufa, mi sebeli amushimba nukamu pumbeka ku nyonga ya mbumwaye. ");
INSERT INTO lyn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Cwale okucila kunene sebeli kwingena kwaanu no ndoo ya Nyambe ni kwaanu onje anakuyupa etaba eyi. ");
INSERT INTO lyn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Cwale etimakazo ni tiponiso no kupula kame tinaku tendahala kwaanu ni maoko no atumiwa. Mi kame ana kukuwanenga mu sibaka sinjili sa Salomoni siisaniwa nji Kozwana. ");
INSERT INTO lyn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kakwisa omunu onakutwesa oukuwana noo, kono aanu kame ana kwaalumba onene mulikute. ");
INSERT INTO lyn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Cwale anokupula ana kupumena kwa Mbumu kame anakwekezeha, alume naakati. ");
INSERT INTO lyn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mane kame kuna litiwa asikutoma mu tindila ni kwalangeka ba mimbeta ni bamiseme nji Pitolosi abasabite anjili kwa onyene afukiwe ku mwinda waye. ");
INSERT INTO lyn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Naanu kame sebeli akuwana okutunda mumindi mu Jelusalema, sebeli alita asikutoma nawo akwite Emebo nokwiiba, onje sebeli abalisiwa. ");
INSERT INTO lyn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kono omupulisita omukulu bamweya nawo akuyupa naye onje na njili no Masaduki, sebeli ayupa omuna. ");
INSERT INTO lyn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","sebeli anunga atumiwa ni kwaabeka mu tolongo no sicaba. ");
INSERT INTO lyn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kono ousiku elin̄eloi lya Mbumu sebeli liiya mukuyatulula emwelo no tolongo nikwatundisamo ni kwamba nji, ");
INSERT INTO lyn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mute mi mwimane mu ndoo ya Nyambe mi mwaambe kwaanu amaywi onje no moyo noubya.” ");
INSERT INTO lyn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mi cwale aba ana kuyupa eyi, sebeli aingena lilapa no ndoo ya Nyambe amasiku ni kwiyeta. Cwale omupulisita omukulu sebeli oiya naawo anakwikalanga naye ni kwisana bamweya ekuta naanu onje no Isilaele, ni kutumena ku tolongo mukwaalita. ");
INSERT INTO lyn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kono otupaso aba tunakukeela, kasitu kwaawana mu tolongo, mi sebeli tuuka kukuta okabiha, ");
INSERT INTO lyn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Natuwana etolongo iyatililwe wino natateleli aimanine ba mwelo, kono abatuna iyatulula katusiwanamo omunu mukaci!” ");
INSERT INTO lyn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Cwale onduna no ndoo ya Nyambe napuliisita akulu aba ana kuyupa amaywi aa, sebeli aziyeleha ni kukomoka onene kweyo inatendahala kwa atumiwa, abilaela nji eyi taba ngasibine saitendahale. ");
INSERT INTO lyn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Cwale sebeli kwiiya omunu ni kwaambela nji, “Alume munakubeka mu tolongo kame aimanine mu ndoo ya Nyambe mi kame aiyeta aanu!” ");
INSERT INTO lyn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Cwale onduna ni tupaso sebeli ata okaashimba, kono kasa mukubambaba, kakuli kame ana kucila aanu okwakonda ni mawee. ");
INSERT INTO lyn_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Cwale aba anakumana okwaalita, sebeli aabeka balubala no Kuta, mi omukulu no mupulisita sebeli waibanguta nji, ");
INSERT INTO lyn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Natukumi laelela onene nji mulese okwiyeta mu litina lya Jesu, cwale bano namwiyata Jelusalema ni tuto yenu mi kame musinga okulita ounyinga no munu woyo beulu wetu!” ");
INSERT INTO lyn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kono Pitolosi naatumiwa sebeli atambula nji, “Kame tufanena okukuteka Nyambe, kasa omunu. ");
INSERT INTO lyn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Onyambe no ashemi etu naingula Jesu kwaafu woyo muna kwibaa okumu ngongotela ba sitondo. ");
INSERT INTO lyn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nyambe nakumukulisa ni Lyoko lyaye no silyo nji atende omubusi ni muyoisi, woyo oba Isilaele okubaka ni kulemenwa eibi. ");
INSERT INTO lyn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kame tuli aapaki kwiinu eyi, mi kame tukwite Emebo nokukena eyo anabi Nyambe kwaao amukuteka.” ");
INSERT INTO lyn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Cwale aba ana kuyupa eyi sebeli atina onene nikusinga okwaibaa. ");
INSERT INTO lyn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kono omufalisi munjili onakwisaniwa nji Gamaliele, omwiyeti no mulawo woyo olumbiwa ku sicaba sonje, sebeli oimana ni kulaelela nji aatumiwa atundisetwe bandee ba nako icana, ");
INSERT INTO lyn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","cwale sebeli wamba kwa onyene nji, “Alume no Isilaele, mutokomele eyi musinga kutenda kwaa alume. ");
INSERT INTO lyn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kakuli munyima no maywaa aaTeudasi sebeli omonahala, nuukutoya nji nisinu sinene, mi aanu no kukwana emyanda inee sebeli akuwana naye, kono nakwibaiwa nawo onje anakumu kon̄anga sebeli ahasana ni kubwa. ");
INSERT INTO lyn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Munyima ya woyo, Judasi omu Galileya sebeli omonahala mu nako no sipalo mi sebeli okoka aanu no kupula, kono ni yonyene sebeli ofa, mi naawo anakumu kon̄anga sebeli ahasana. ");
INSERT INTO lyn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Cwalehe mu taba eyi, kame ni myambela nji, mutundeko kwalume aa mi mwasiye omboci, nji ni mulelo simba omusebezi otunda kwaanu, mbaukwangwa, ");
INSERT INTO lyn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","kono nji kame itunda kwa Nyambe, kamutamba okwatwesa. mba mumonahala nji naanyi kame mulwisa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Cwale sebeli asitokomela ekelezo yaye, mi cwale abana mana okwisana atumiwa, sebeli aashapa ni kwaalaela nji alese okuukela okwiyeta aanu mu Litina lya Jesu, sebeli aalukulula nji akutele. ");
INSERT INTO lyn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Cwale sebeli asiya esibaka no Kuta awabelelwe, kakuli kame atendilwe aa alukela okwenisiwa mulibaka no Litina lya Jesu. ");
INSERT INTO lyn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mi amaywaa onje kasi kulesela okwiyeta mu Ndoo ya Nyambe ni mu tindoo nji Jesu yokame Kilesite. ");
INSERT INTO lyn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Cwale mu nako eyo epalo no aiyetwa abainakwekezeha, aendisi no Majuda ao aamba esigelike sebeli atongokela aendisi no Majuda ao aamba esihebelu kakuli neli ambelwa ao kame anakuketululwa abaku biwa eilya no liywaa ni liywaa. ");
INSERT INTO lyn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Cwale atumiwa likumi nayili sebeli aisana aiyetwa onje ni kwaambela nji, “Kakulukele nji tulese okwiyeta eliywi lya Nyambe nji tube eiyi no kulya ba titafule. ");
INSERT INTO lyn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Abetu, abakulingeso, mukete alume mutanu nayili mwaanyi aa asepahala aa aiyalile Emebo niku shangama, mi twabeke mu musebezi ou. ");
INSERT INTO lyn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kono aci mbatukongota muku lapela ni mu sebelezo no Liywi.” ");
INSERT INTO lyn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mi etaba eyo ana kwamba esikwata sonje sebeli siwabelelwa, mi sebeli aketa Setefani, omulume onaiyala etumelo ni Mebo No Kukena ni Filipi, ni Polokolasi, ni Nikolasi ni Timoni, ni Pamena, ni Nikolasi omupolosebelite na mu Antiyoke. ");
INSERT INTO lyn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Esikwata esi sebeli asiimeka balubala no Atumiwa, sebeli alapela ni kwabeka amaoko oo beulu woo. ");
INSERT INTO lyn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Cwale eliywi lya Nyambe sebeli lyekezeha okwambiwa, ni palo no aiyetwa sebeli yekezeha onene mu Jelusalema, mane ni palo no kupula no apulisita sebeli akubeeka ku tumelo. ");
INSERT INTO lyn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Setefani ona kwiyala esishemo ni maata, sebeli otenda etimakazo ni tiponiso no kupula mu sicaba. ");
INSERT INTO lyn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Cwale aanu anjili no ndoo no milapelo eyi isaniwa nji no alukuluhi, naa naku Sileni, naa naku Alekizandiya, naa naku tolopo no Silisia ni ku Asiya sebeli atangisa okukanana ni Setefani. ");
INSERT INTO lyn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kono sebeli akwangwa okukanana okushangama kwaye ni mebo eyo ana kwamba nayo. ");
INSERT INTO lyn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Cwale sebeli ashonga alume anjili anakwamba nji, “Natumuyupu yo amba amaywi noku nyefula Mushe ni Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sebeli asusuweza ngeso esicaba nakulu, naiyeti no mulawo wa Mushe, mi sebeli amupatisa okumulema niku mulita balubala no Kuta. ");
INSERT INTO lyn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Sebeli alita apaki no mapwa ana kwamba nji, “Uyu mulume kalesele okwamba eyambo no ku nyefula endoo ya Nyambe ni mulawo wa Mushe. ");
INSERT INTO lyn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kakuli natumu yupu yo amba nji Jesu no Nazaleta wuyu mba sinyi esibaka eso, afutule ni mikwa no sizo eyi tunabiwi kwa Mushe!” ");
INSERT INTO lyn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Aanu onje aa anakwikala ba Kuta aba ana kumulubukela, sebeli amona olubala lwaye nji kame lukufekile kanyi olubala no lin̄eloi. ");
INSERT INTO lyn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Omupulisita omukulu sebeli wibanguta nji, “Etaba eyo kana moikalele?” ");
INSERT INTO lyn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Setefani sebeli otambula nji, “Abaange, naanyi asitange, muyupetete kwa mene! Nyambe no kanya nakumonahaza kwa sitetu Abulahama abo yosiikala mu Mesopotamiya yokasita kale okaikala mu Halani, ");
INSERT INTO lyn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","mi sebeli wamba kwa yonyene nji, ‘Osiye esibaka sowe ni lusika lowe mi ote mu sibaka saniku monise.’ ");
INSERT INTO lyn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Cwale sebelli otunda mu naha no Makaladeya ni kuta okaikala mu Halani. Munyima ya sitaye Abulahama okufa, Nyambe sebeli omutundisamo niku mulita mu naha ino muyoya nibalelo lino. ");
INSERT INTO lyn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ka simuba esanda omo, simba esibaka no kulyata elikondo, kono sebeli omusepisa nji yonyene ni masika aye mbaabiwa esibaka simba nji kakwite omwana. ");
INSERT INTO lyn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Cwale Nyambe sebeli omwambela nji, ‘Aikulyowe mba kayoyo mu naha no akoo omo sakaikale mu ukoba niku yandisiwa mu myaka nokukwana emyanda inee. (400) ");
INSERT INTO lyn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kono kame sani atule aanu saabeeke mu ubika Nyambe sebeli wamba, mi munyima nweyo kame satundemo ni kwiya mukuni lumbekela muno mu sibaka.’ ");
INSERT INTO lyn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Cwale Nyambe sebeli omuba oulikani no mupato. Mi cwale Abulahama sebeli oleya Isaka, ni kumubeeka ku mupato ba liywaa no mutanu ni twaatu, mi Isaka sebeli oleya Jakobo, Jakobo sebeli oleya anjekulyetu nokukwana likumi ni twiili. ");
INSERT INTO lyn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Kakuli anjekulyetu kame ana kufela minoo Josefa omuna niku muulisa mu Engepita, kono Nyambe nakwikala naye, ");
INSERT INTO lyn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","mi sebeli omulamulela mu mayando aye onje niku muba okukateleha ni kushangama, balubala wa Falo Ombumu no Engepita woyo onaku muba oubusisi no Engepita ni beulu no asindoo yaye yonje. ");
INSERT INTO lyn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Cwale sebeli kwiiya olukupwe munaha yonje no Engepita ni mu Kanana, ni mayando manene mane na shemi etu sebeli akwangwa oku wana eilya. ");
INSERT INTO lyn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kono cwale Jakobo aba ana kuyupa eyo nji kame kuli eilya mu Engepita, sebeli otumako anjekulyetu akano weli. ");
INSERT INTO lyn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ba musipili no wiili Josefa sebeli okulimukisa kwakulwaye, mi olusika lwa Josefa sebeli lulimukiwa kwa Falo ");
INSERT INTO lyn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Cwale Josefa sebeli otuma aanu okashimba sitaye Jokobo ni lusika lwaye lonje, anakukwana makumi mutanu na yili naanu mutanu (75). ");
INSERT INTO lyn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Cwale Jakobo sebeli ota ku Engepita, nukafelako yonyene na njekulyetu. ");
INSERT INTO lyn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Eitupu yoo kame inaku twaliwa mu Shekemu nukateuliwa mu libita anaku ula Abulahama ni mali kwaana aa Homoli namu Shekemu. ");
INSERT INTO lyn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kono enako no sepiso aba inaku sheteta, eyo Nyambe anaku sepisa Abulahama epalo no aanu mu Egepita sebeli yekezeha onene. ");
INSERT INTO lyn_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mane sebeli kuyola Ombumu munjili mu Engepita woyo nokwa limuka Josefa. ");
INSERT INTO lyn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Woyo sebeli otenda omushobo wetu mu kushangama no kwiiba, na kuyandisa anjekulyetu, sebeli wataukisa anoo nji alese okupula afee. ");
INSERT INTO lyn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Munako eyi Mushe sebeli oleiwa, neli omwana no kuwaba onene balubala wa Nyambe. Mi kame anaku litiwa ba tikweti taatu mu ndoo ya sitaye, ");
INSERT INTO lyn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","mi ababo yosi limukiwa fela, mwanaye Falo no musizana sebeli okutolelaye, ni ukukuliseta ye nji atende mwanaye luli. ");
INSERT INTO lyn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Cwale Mushe sebeli oiyetiwa okushangama konje no Aengepita mi sebeli oikala ni maata mu kwamba ni mu misebezi. ");
INSERT INTO lyn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Cwale aba ana kukwanisa emyaka makumi anee (40), sebeli oiyelwa etakazo mu mucima waye nokuta oka potela abaye aana no Isilaele. ");
INSERT INTO lyn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Cwale sebeli omona omunjili no abaye yo tendiwa ouyi, sebeli omulwela, okumu lamulela mukwibaa Omuegepita. ");
INSERT INTO lyn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nakuyambuta nji abaye kame sa yupisise nji Nyambe kame saayoyise mulibaka no Lyoko lyaye, kono kaasikuyupisisa. ");
INSERT INTO lyn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Cwale liywaa linaku tatamako sebeli omumonahaza kwaonyene aalwa mi sebeli waaeleza nji, ‘Alume, kame muli omwabaye munu, iikene aba mukulwisa?’ ");
INSERT INTO lyn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kono omulume woyo onakutenda omukwaye ouyi sebeli okasha Mushe, ni kumwibanguta nji, ‘Anyine onaku beeke omubusisi ni mwatuli wetu?’ ");
INSERT INTO lyn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Kame usinga okunibaa kanyi omo unakwibaela Omuegepita bingolwa?’ ");
INSERT INTO lyn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mulibaka no liywi elyo, Mushe sebeli otunda mu Engepita okuta mu naha no Mindiyani, omo anokaleyelamo aana ayili. ");
INSERT INTO lyn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Cwale aba kuna mana emyaka makumi anee (40), elin̄eloi sebeli likumonahaza kwa Mushe mu lihalaupa no lilundu no Sinai, mu lulimi no mulilo mu liputa. ");
INSERT INTO lyn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Cwale Mushe aba anakumona ngeso sebeli okomoka, abana shetetako nji amonisise, sebeli oyupa eliywi lya Mbumu elyamba nji, ");
INSERT INTO lyn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Time Nyambe wa njekulyowe, Nyambe wa Abulahama Nyambe wa Isaka ni wa Jakobo.’ Cwale Mushe sebeli ocila ni kukwangwa okwaliketako. ");
INSERT INTO lyn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Cwale MBUMU sebeli wamba kwa yonyene nji, ‘Otundise etinjangwa towe ku makondo, kakuli esibaka wimanine ni sakukena. ");
INSERT INTO lyn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kame ninalikete mi kame nimono amayando no aanu ange mu Egepita mi nuyupu okutonga koo, mi kame nineyi mukwaa lukulula. Cwale wiiye, niku tume ku Egepita.’ ");
INSERT INTO lyn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mushe woyo ana kukana aamba nji, ‘Anyine ona kubeeke omubusisi ni mwatuli?’ Yokame ana beeke Nyambe omubusisi ni mulukululi woo mulibaka no lingeloi linaku monahala mu liputa. ");
INSERT INTO lyn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Sebeli watundisa mu Egepita, yo tenda etimakazo neyi ikomokisa ni ba liwate no mucaa ni mu lihalaupa emyaka makumi anee (40). ");
INSERT INTO lyn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mushe yokame onakwambela aana no Isilaele nji, ‘Nyambe wenu mba mi litele omunuhi mukaci no abenu kanyi omo ana kuni beekela.’ ");
INSERT INTO lyn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yokame woyo onakukuwana mu lihalaupa ni lingeloi linakwamba kwa yonyene ku lilundu lya Sinai, yoli na njekulyetu, ni ku tambula amaywi a yoyisa nji atube oo. ");
INSERT INTO lyn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Kono anjekulyetu sebeli akana okumukuteka, kono sebeli amukuteka ku nyonga mu micima yoo ni kuukela ku Engepita. ");
INSERT INTO lyn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Cwale sebeli aamba kwa Aluni nji,‘Otutendele emilimu eyi itwenda ku lubala, kanyi Mushe woyo onaku tutwaletela okutunda mu naha no Egepita, katu limukile esi sinamwiyele.’ ");
INSERT INTO lyn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Cwale mu maywaa awo sebeli aumba onamani, ni kutundiseta etinubu esiswaniso eso ni ku wabelelwa mu misebezi no maoko oo. ");
INSERT INTO lyn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kono Nyambe sebeli wafutukela ni kwaaba oku lapelela empi nakuwilu, kanyi omo kun̄olelwe mu buka no anuhi nji, ‘Anyi asi ndoo no Isilaele, ninji kame munaku nilitela eiyamana no kuyonda ni matabelo, emyaka inee mu lihalaupa. ");
INSERT INTO lyn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Cwale kame munakushimba Endoo ya Nyambe ya Muloke, ni lutungweti lwa Nyambe Lefani, neli amaswaniso munakukuketela okulapelela Cwale kame sanimitundise mu Babilona.’ ");
INSERT INTO lyn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Anjekulyetu nakwikala ni tabanakele no upaki mu lihalaupa, simba kanyi woyo ona kwamba kwa Mushe nakumu laelela yonyene ona kwitenda, kanyi esiswaniso eso anaku mona. ");
INSERT INTO lyn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Munyima anjekulyetu sebeli aiya mu naha ni Joshuwa ku sicaba anakucita Nyambe balubala wa anjekulyetu. Sebeli iikalamo okutwala ba maywaa a Dabida. ");
INSERT INTO lyn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dabida naku wana esishemo kwa Nyambe mi sebeli okumbela nji awanene Nyambe wa Jakobo esibaka. ");
INSERT INTO lyn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kono neli Solomoni ona kumuyakela endoo. ");
INSERT INTO lyn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kono Nyambe Omwambakani ka ikala mu tindoo tina yakiwa ni maoko, kanyi omunuhi aba anakwamba nji, ");
INSERT INTO lyn_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Eliwilu lyokame olubona lwange, mi elitunga lyokame esipula nilyatile amakondo ange Mufuta ubine no ndoo muniyakela, kame kwamba MBUMU, kamba kasibaka eso ni fanena oku pumulela? ");
INSERT INTO lyn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kasanji amaoko ange kasikuyaka einu yonje eyi?’ ");
INSERT INTO lyn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Anyi anu no tindingo tisatalalile, aa ulwile okwingenyeka emicima ni matwi yenu mu mupato, enako yonje kame mukanisa Emebo No Kukena! Kanyi omo ana kwikalela anjekulyenu, naanyi momwikalele. ");
INSERT INTO lyn_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Anyine omunuhi wasiku yandisiwa kwa njekulyenu? mane kame anakwibaa awo anakwamba baweli nji kame sakwiye woyo no kuluka. Cwale woyo muna kubeteka niku mwibaa. ");
INSERT INTO lyn_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Aanyi munaku tambula omulawo wa Nyambe onaku lukululwa ku mangeloi kono kamusi kuuteula. ");
INSERT INTO lyn_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Cwale aba ana kuyupa einu eyi sebeli atina, ni kukweca amaeo okumu lwisa. ");
INSERT INTO lyn_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kono Setefani, yo iyalile Emebo No Kukena, sebeli omona ekanya ya Nyambe ni Jesu yoimanine ku Lyoko no silyo lya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Cwale sebeli wamba nji, “Komumone, kame nimona eliwilu eli liyatulukile ni Mwana no munu yoimanine kweli no silyo lya Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Cwale sebeli akuwa ni liywi linene ni kutika amatwi oo ni kwitukela kwa yonyene onje, ");
INSERT INTO lyn_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","niku mukokela kundee no mulenen̄i niku mupwacula ni mawee. Etipaki sebeli abeeka eikumango yoo banji, ba makondo no ndumbana wisaniwa Saule. ");
INSERT INTO lyn_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Cwale alemine okupwacaula Setefani, sebeli olapela nji, “Mbumu Jesu otambule Emebo yange!” ");
INSERT INTO lyn_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Cwale sebeli okubama ni kukuwa ni liywi linene nji, “Mbumu, olese okwahupulela esibi sino!” Aba ana mana ngeso, sebeli okulanganena. ");
INSERT INTO lyn_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saule naku pumena olufu lwa Setefani. Cwale ba liywaa elyo sebeli kwinguka okuyandisiwa kunene mu Ndoo ya Nyambe mu Jelusalema, mi onje kame anakuhasanela mu naha no Judeya ni Samaliya sebeli kusiyala fela Atumiwa omboci. ");
INSERT INTO lyn_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Alume anjili no aasikupumena sebeli ata oka pumbeka Setefani, niku mulila onene. ");
INSERT INTO lyn_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kono Saule sebeli otateka okusisinya Endoo ya Nyambe, ni kwingena mu tindoo okukokamo alume na kati ni kwaaingenyeka mu tolongo. ");
INSERT INTO lyn_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Cwale awo anaku hasanyiwa sebeli ata alemine okukutaza eliywi. ");
INSERT INTO lyn_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipi sebeli ota mu mulenen̄i no Samaliya, nukaamba eyi ya Kilesite kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Aanu nokupula sebeli aikala ni mucima mumweya okutambula eyo anakwamba Filipi, Cwale sebeli amuyupa nikumona etimakazo ana kutende. ");
INSERT INTO lyn_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kakuli Emebo no kwiiba sebeli inakutunda mwaanu nokupula awo anakwingeniwa yolemine okukuwa ni liywi linene, naanu asikukutela olun̄an̄ali ni iyanga no makondo sebeli abalisiwa. ");
INSERT INTO lyn_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Cwale okuwabelelwa noku neneba sebeli kwikalamo omo mu mulenen̄i. ");
INSERT INTO lyn_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kono oweli kame kunakwikala omulume onakwisaniwa Simoni onakutendanga amabibo mu tolopo no Samaliya onaku komokisanga esicaba, yonyene kame ana kukyemanga nji munu nokuneneba, ");
INSERT INTO lyn_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","mi onje kame anaku mukutekanga, okutangisa ku mwanukana okutwala ku mukulu, sebeli aamba nji, “Uyu mulume ni maata a Nyambe awo aisanwa nji, ‘Amaata no kuneneba.’” ");
INSERT INTO lyn_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kame anaku mukolwa kakuli naku tangisa kale okwakomokisa ni mabibo aye. ");
INSERT INTO lyn_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kono aba anaku pumena Filipi aba anakwaambela eliywi no kuwaba no muboso wa Nyambe ni litina lya Jesu Kilesite onje alume nakati sebeli akolobeziwa. ");
INSERT INTO lyn_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simba yonyene Simoni naku pumena, mi munyima no ku kolobeziwa sebeli okumalela Filipi, mi aba mona etimakazo neyi ikomokisa, sebeli okomoka. ");
INSERT INTO lyn_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Cwale atumiwa ku Jelusalema abaana kuyupa nji amasamaliya kame anatambula eliywi lya Nyambe, sebeli atuma Pitolosi ni Jowani. ");
INSERT INTO lyn_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Awo abaana kukeela sebeli aalapelela nji abiwe Emebo No Kukena. ");
INSERT INTO lyn_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kakuli Emebo No Kukena kaya siku shulumukela simba ku mumweya kwa onyene, kono kame anaku kolobeziwa fela mu litina lya Mbumu Jesu. ");
INSERT INTO lyn_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Cewale sebeli abeka amaoko oo beulu yoo mi sbeli atambula Emebo No Kukena. ");
INSERT INTO lyn_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Cwale Simoni aba aaku mona nji Emebo kame inabiwi mukubeka amaoko no atumiwa, sebeli waasepisa okwaba amali, ");
INSERT INTO lyn_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ni kwamba nji, “Munibe ku maata awo, nji omunu yonje sanibeeke amaoko mba tambula Emebo No Kukenaa.” ");
INSERT INTO lyn_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kono Pitolosi sebeli omwambela nji, “Amali owe ofe nawo, kakuli kame onahana nji kame ofanena okula empo ya Nyambe ni mali! ");
INSERT INTO lyn_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kakwisa esi sobiwe simba esemba, mu taba eyo, kakuli omucima wowe kausiluka mu miyo a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Obake mu uyi wowe, mi olapele Nyambe, mwendi mbufanene okulemenwa omuhupulo oli mu mucima wowe. ");
INSERT INTO lyn_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kakuli kame ni mona nji kame oli mu mioti no kulula onene ni mu tolongo no sibi.” ");
INSERT INTO lyn_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni sebeli otambula nji, “Muni lapelele kwa Nyambe, nji kakwisa esinjili kweyo mu naamba sasini kwele.” ");
INSERT INTO lyn_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Cwale aba anakumana okupaka eliywi lya Nyambe, sebeli aukela ku Jelusalema, okakutaza eliywi no kuwaba kwaanu no kupula no masamaya. ");
INSERT INTO lyn_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kono elin̄eloi lya Mbumu sebeli lyambela Filipi nji, “Oimane mi ote ku Mbowela, ku ndila ishetumuka ku Jelusalema okuta ku Gaza, no lihalaupa, eyo nokwa endiwangwa.” ");
INSERT INTO lyn_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Cwale sebeli oimana ni kutako, sebeli omona omulume no muisopiya, neli muumba, esikombwa sinene sa Kandasi, Ombumu no mukati no isopiya, neli omubabaleli no ufumu waye onje, neyi mu Jelusalema muku lapela ");
INSERT INTO lyn_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","mi muku ukela kwaawo yoikalile mu koloi yaye yo lemine okubala mu buka no munuhi Isaya ");
INSERT INTO lyn_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Emebo No Kukena sebeli yamba kwa Filipi nji, “Otwalelelele, oshetete ku koloi eyi.” ");
INSERT INTO lyn_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Cwale Filipi sebeli oitukela kwa yonyene, niku muyupa yobala mu buka no munuhi Isaya, ni kumwibanguta nji, “Kame uyupa eyo olemine okubala?” ");
INSERT INTO lyn_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Onduna sebeli otambula nji, “Ngasibine sani yupisise, okuulwile omunu onisimweta?” mi sebeli omema Filipi okutina nji aikale naye. ");
INSERT INTO lyn_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Cwale ekalulo no lin̄olo anaku bala neli eyi, “Kanyi omukoko utwaliwa mukwiibaiwa simba akana no mukoko nokwalila owoya wako aba upatuliwa, kasi yaamisa akanwa kaye. ");
INSERT INTO lyn_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mu kwenisiwa, mi ekatulo yaye sebeli iimekiwa. Anyine sotwesa okwa olusika lwaye, kakuli omoyo waye nautundisiwa mu litunga.” ");
INSERT INTO lyn_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Cwale onduna sebeli oibanguta Filipi nji, “Onambele, kame ni kulapela, omunuhi aba aamba eyi, kame akwamba yonyene nji kame aamba omunjili?” ");
INSERT INTO lyn_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Cwale Filipi sebeli oyamisa akanwa kaye ni kutangisa nelyo elin̄olo okumwambela amaywi no kuwaba a Jesu. ");
INSERT INTO lyn_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Cwale alemine okuta mu ndila sebeli awana abakuli ameyi, mi onduna sebeliwamba nji, “Omone, bano kame kuli ameyi. sikene esi sasini kanise oku kolobeziwa?” ");
INSERT INTO lyn_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipi sebeli wamba nji, “Nji kame opumena ni mucima wowe wonje, kame kukonahala. Nduna sebeli otambula nji, Kame ni pumena nji Jesu Kilesite ni Mwanaa Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Onduna sebeli olaelela ekoloi okwimana, onje Filipi ni Nduna sebeli aingena mu meyi, mi Filipi sebeli kolobeza onduna. ");
INSERT INTO lyn_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Cwale aba anakutunda mu meyi, Emebo ya Nyambe sebeli ishimba Filipi, mi onduna nakuulwa okumona Filipi kame, cwale sebeli otwalelela mu mwendo waye yo wabelelwe. ");
INSERT INTO lyn_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Kono Filipi nokakuwana mu Azoto, yo twalelela okukutaza eliywi no kuwaba mu titolopo tonje mane sebeli okakeela ku Sizeliya. ");
INSERT INTO lyn_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kono Saule yosi tukufalile okufumbela okwibaa aiyetwa no Mbumu, sebeli ota ku mupulisita omukulu ");
INSERT INTO lyn_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","oka kumbela kwa yonyene aman̄olo no kuta nawo mu tindoo no milapelo naku Damaseka, nji abasa kawane anjili asi Ndila eyo, alume simba akati, aanunge ni kwalita mu Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Cwale Saule yo atumele okukeela ku Damaseka, ababo olumonyi lunaku tunda ku wilu sebeli lumubeeka mukaci. ");
INSERT INTO lyn_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Cwale sebeli okwela banji ni kuyupa eliywi elyaamba kwa yonyene nji, “Saule, Saule, iikene oniyandiseta?” ");
INSERT INTO lyn_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sebeli oibaguta nji, “Tiwe anyine, Mbumu?” Mbumu sebeli wamba nji, “Time Jesu woyo oyandisa.” ");
INSERT INTO lyn_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Cwale winguke oingene mu mulenen̄i, mi mbuka simwetiwamo eyo so fanene okutenda.” ");
INSERT INTO lyn_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Alume anakwenda naye kame anakwimana ni kukomoka, kakuli kame anaku yupa eliywi kono kaasiku mona omunu. ");
INSERT INTO lyn_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saule sebeli oinguka banji mi cwale amiyo aye abaana kutona nakukwangwa okumona omunu, cwale sebeli amulema ku Lyoko niku mulita mu Damaseka. ");
INSERT INTO lyn_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mu maywaa aatu yoka mono, ni kulya simba okunwa. ");
INSERT INTO lyn_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Cwale kame kuna kwikala omwiyetwa mu Damaseka no litina lya Ananiasi. Ombumu sebeli omwambela mu pono nji, “Ananiasi.” mi sebeli otambula nji, “Yamene yauno, Mbumu.” ");
INSERT INTO lyn_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ombumu sebeli omwambela nji, “Oimane mi ote mu ndila isaniwa nji eyi noku luka, okasaele mu ndoo ya Judasi omulume naku Tasusi no litina lya Saule. Kakuli kame alapela, ");
INSERT INTO lyn_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","mi ni yonyene namono omulume wisaniwa Ananiasi mu pono yoiya niku beeka amaoko aye beulu yaya nji cwale amone kame.” ");
INSERT INTO lyn_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kono Ananiasi sebeli otambula nji, “Mbumu, kame nina yupu ya uyu omulume kwaanu nokupula eyi ana tende, omo ana yandisete ouyi aasikupumena owe mu Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Naaba aneyi kuno, kame ana biwi amaata okutunda kwa apulisita akulu ni kununga onje aa alapela elitina lyowe.” ");
INSERT INTO lyn_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kono Ombumu sebeli omwambela nji, “Ote, kakuli kame ninamukete okutenda esibelekiso sange nji atwale Elitina lyange kwaa simacaba na Mbumu naana no Isilaele. ");
INSERT INTO lyn_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Cwale kame sanimu simwete okuneneba no kukola oko sayupe mulibaka no kuyandisa elitina lyange.” ");
INSERT INTO lyn_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Cwale Ananiyasi sebeli ota nuka ingena mu ndoo ni kubeeka amaoko aye beulu yaye ni kwamba nji, “Minange Saule, Ombumu onaku monahaza kwa wene mu ndila nani tumu, yonyene Jesu nji omone kame mi wiyale Emebo No Kukena.” ");
INSERT INTO lyn_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Cwale ababo esinu sikufekile kanyi amayayu sebeli situnda mu miyo aye ni kumona kame. Cwale sebeli oimana ni kukolobeziwa. ");
INSERT INTO lyn_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Cwale sebeli olya ni kuukeliwa amaata Saule sebeli oikala naiyetwa mu Damaseka amaywaa acana. ");
INSERT INTO lyn_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Mu ndoo no milapelo ababo sebeli okutaza nji Jesu ni Mwanaa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Onje anaku muyupa sebeli akomoka ni kwibanguta nji, “Kasa yokame onaku yandisanga ouyi anaku isananga ba litina Jesu mu Jelusalema? mane mulibaka elyo bokame aba aneyi kuno, mukwaanunga ni kwatwala kwa apulisita akulu?” ");
INSERT INTO lyn_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kono Saule sebeli oekeza onene mu kongola kwaye, ni kukoma aendisi no Majuda okwamonisa nji Jesu yokame Kilesite. ");
INSERT INTO lyn_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Cwale amaywaa nokupula abaanakubwa, amajuda sebeli asinganyeka okwibaa Saule, ");
INSERT INTO lyn_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","kono Saule sebeli olimuka omulelo woo. kame anaku mundamenanga munji ni ousiku ku myelo nji amwibae. ");
INSERT INTO lyn_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kono aiyetwa aye sebeli amushimba ousiku oku mumatukiseta ba limota, amubekile mu litanda. ");
INSERT INTO lyn_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saule aba ana kukeela mu Jelusalema sebeli weteka nji akuwane naiyetwa, mi onje kame anaku mucila, kakuli kasiku pumena nji niyonyene neli omwiyetwa. ");
INSERT INTO lyn_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kono Banabasi sebeli omushimba, ni kumu twala kwa atumiwa, ni kwataluseta omo anaku monena Ombumu mu ndila, woyo ona kwamba naye, nomo ana kutaleze ni maata mu Damaseka mu litina lya Jesu. ");
INSERT INTO lyn_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Cwale Saule sebeli oyoya noo mane nikukwendela oomo anakusingela mu Jelusalema, ");
INSERT INTO lyn_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","yo kutaza mukuzwafisa mu litina lya Mbumu, ni kwamba muku kanana ni Majuda ao aamba esi Gelike onyene aafumba okumwibaa. ");
INSERT INTO lyn_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Cwale abaye aba anakuyupa eyo, sebeli alita Saule kwa Sesaaliya, ni kumu fundula okuta ku Tasusi. ");
INSERT INTO lyn_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Cwale etikeleke monje mu Judeya ni mu Galileya ni mu Samaliya sebeli tiikala mu kozo, ni kweenda mu kucila kwa Mbumu, mi kame tina kukula ni kususeziwa mu tuso no Mebo No Kukena. ");
INSERT INTO lyn_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pitolosi yo lemine okupotela eibaka yonje no naha, sebeli oiya ni kwa asikupumena aa ayakile mu Lida. ");
INSERT INTO lyn_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Omo sebeli okawana omulume no Litina lya Aneya, woyo onaku langana ba mumbeta yokola oweti no lun̄an̄ali mu myaka mutanu ni twaatu (8). ");
INSERT INTO lyn_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Cwale Pitolosi sebeli wamba kwa yonyene nji, “Aneya, Jesu Kilesite kame akubalisa, oshimbe oulangano wowe.” Ababo Aneya sebeli oinguka. ");
INSERT INTO lyn_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Onje aa ayakile mu Lida ni Shaloni naku mumona, mi sebeli asiulukela kwa Mbumu. ");
INSERT INTO lyn_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mu Jopa kame kuna kwikala omuiyetwa no mukati elitina lyaye neli Tabita, (okutalusa nji Dokasi) Kame ana kutendanga emisebezi no kuwaba ni tituso. ");
INSERT INTO lyn_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mu maywaa ao sebeli okola ni kufa. Cwale aba anakumana okumu yowisa, sebeli akamu beeka mu musiyo na kuwilu. ");
INSERT INTO lyn_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida kakuli kame ina kwikala beebi ni Jopa, aiyetwa sebeli ayupa nji Pitolosi kwaali, sebeli atuma alume ayili okamu kumbela nji, “Shangwe, ulese ku liyeha wiye kwaaci.” ");
INSERT INTO lyn_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Cwale Pitolosi sebeli oinguka nikuta noo. Aba anaku keela, sebeli amutwala ku musiyo na kuwilu, etimbelwa tonje sebeli tiimana ku nyonga yaye alemine okulila, nikumu monisa eikumango ni misisi anaku tendanga Dokasi yo siyoya noo. ");
INSERT INTO lyn_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Kono Pitolosi sebeli watundiseta bandee onje, sebeli okubama ni manwi banji ni kulapela, cwale nikusiulukela ku situpu ni kwamba nji, “Tabita, oinguke!” sebeli otona, mi aba anaku mona Pitolosi sebeli oikala. ");
INSERT INTO lyn_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pitolosi sebeli omulema ku Lyoko okumwimeka. Cwale sebeli oisana etimbelwa naa asikupumena ni kwaaba Tabita yo yoya. ");
INSERT INTO lyn_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Etaba eyo sebeli ilimukiwa kwaanu onje mu Jopa, mi anokupula sebeli apumena kwa Mbumu. ");
INSERT INTO lyn_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Cwale Pitolosi sebeli oikala mu Jopa amaywaa nokupula ku mulume oisaniwa Simoni, omusuhi no itumba. ");
INSERT INTO lyn_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mu Sesaaliya, kame kuna kwikala omulume no litina lya Koneliyasi, omukulu no masole, no mpi iisaniwa nji, “Italiya.” ");
INSERT INTO lyn_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Neli omunu ona kukubeeka ni kucila Nyambe nia sindoo yaye onje, kame ana kutusanga onene anokusheba mi kame ana kulapelanga enako yonje kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ba nako no waatu omunji sebeli omona wino mu pono elin̄eloi lya Nyambe eliiya kwa yonyene ni kwamba nji, “Koneliyasi!” ");
INSERT INTO lyn_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cwale Koneliyasi sebeli waliketa elin̄eloi mukucila ni kwamba nji, “Etaba ni ibine, Mbumu?” Elin̄eloi sebeli limu tambula nji, “Etitapelo ni tituso towe kwawo ashebile nati kambamene kwa Nyambe, mi natipulukiwa. ");
INSERT INTO lyn_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Cwale otume alume ku Jopa akashimbe Simoni woyo oisaniwa Pitolosi. ");
INSERT INTO lyn_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kame ali ni Simoni omusuhi no itumba, endoo yaye kame ikubapile ni liwate.” ");
INSERT INTO lyn_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Cwale elin̄eloi lina kwamba naye aba linakuta, sebeli oisana abika aye ayili ni musole mumweya woyo ona kukubeeka kwa Nyambe kwawo ana ku mutatelelanga. ");
INSERT INTO lyn_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Munyima ya Koneliyasi okwaambela eyi inatendahala yonje sebeli waatuma ku Jopa. ");
INSERT INTO lyn_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Eliywaa linaku tatamako, awo asili mu ndila, aali beebi ni Jopa, Pitolosi sebeli otina ba situwa no ndoo oka lapela, ba nako aba ina kukwana likumi ni twiili (12) omunji. ");
INSERT INTO lyn_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pitolosi sebeli oyomba ni kusaela esino kulya, aasilemine okumu lukiseta eilya, sebeli omona epono. ");
INSERT INTO lyn_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Cwale sebeli omona eliwilu liyatuluka ni sinu siiya banji kanyi olwambi lunene lunungilwe ku mamaneneno yalo anee. ");
INSERT INTO lyn_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mukaci yalo kame kuna kwikala emifuta yonje no iyamana neyi yenda ni mapumo ni tuyunyi na kuwilu. ");
INSERT INTO lyn_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Cwale eliywi sebeli liiya kwa yoyene lyaamba nji, “Imana, Pitolosi, wibae mi olye!” ");
INSERT INTO lyn_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kono Pitolosi sebeli wamba nji, “Kokulwa, Mbumu, kakuli kanisilya kale esinu sonje no kwakena neyo no litilo.” ");
INSERT INTO lyn_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Eliywi sebeli liiya kwa yonyene kame akano wili nji, “Esi sikenisitwe kwa Nyambe, olese okwamba nji nisaalitilo.” ");
INSERT INTO lyn_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nakuku tendahala ngeso twaatu, esinu eso sebeli susetwa ku wilu. ");
INSERT INTO lyn_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pitolosi yosi nahana epono ana mono nji iikene, komumone, alume ana tumiwa kwa Koneliyasi munyima no kwibanguta ku ndoo ya Simoni sebeli akeela ni kwimana ba mwelo. ");
INSERT INTO lyn_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Cwale sebeli aisana ni kwibanguta nji, “Kana mokame muno ana tibelele Simoni wisaniwa Pitolosi?” ");
INSERT INTO lyn_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pitolosi yo sinahana eyi no pono eyo, Emebo sebeli yamba kwa yonyene nji, “Omone, alume aatu kame akusaela. ");
INSERT INTO lyn_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Wimane mi oshetumuke, ote noo oulwile oku lindalinda, kakuli time ninaa tumu.” ");
INSERT INTO lyn_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Cwale Pitolosi sebeli oshetumukela kwaao alume ana tumeniwa kwa yonyene ni kwamba nji, “Yamene mu saela. Mulibaka libine aba muneeyi?” ");
INSERT INTO lyn_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Cwale sebeli atambula nji, “Koneliyasi, omukulu no masole, kuluka, woyo ocila Nyambe ni kukutekiwa ku sicaba sonje no Majuda. Kame ana laeliwa ku lingeloi no kukena okwisanena ku ndoo yaye, nji ayupe eyo so wambe.” ");
INSERT INTO lyn_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Cwale Pitolosi sebeli waatambula ni kwaingenyeka mu ndoo. Eliywaa linaku tatamako Pitolosi sebeli ota noo, nanjili abaye namu Jopa sebeli ata naye. ");
INSERT INTO lyn_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kweeli linaku tatamako eliywaa sebeli aingena mu Sesaaliya. Koneliyasi kame anakwa atatelela, mane kame anakwisana bamweya aa asinga onene naabaye. ");
INSERT INTO lyn_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Cwale Pitolosi aba anakwingena, Koneliyasi sebeli omuwaniketa niku kwela banji ni manwi ku makondo aye niku mukubamena. ");
INSERT INTO lyn_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kono Pitolosi sebeli omwimeka ni kwamba nji, “Imana,” “Nimene, kame nili omunu fela.” ");
INSERT INTO lyn_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pitolosi yo ambola ni Koneliyasi, sebeli aingena mu ndoo ni kuwanamo aanu nokupula aunganine. ");
INSERT INTO lyn_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pitolosi sebeli wamba kwa onyene nji, “Aanyi kame mulimukile nji ni kulwisa omulawo omunu kakuli o Mujuda kalukele okuwana nasimacaba andina simba okulekula omunjili kwa yonyene. Kono Nyambe nanikete nji nilese okwaliketa omunu yonje nji kame aiyalile elitilo kasikena. ");
INSERT INTO lyn_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Cwale aba nina kutumeniwa, kame nineyi nambulwa mukwakana. Cwale kame nimi ibanguta nji, iikene munani isanene?” ");
INSERT INTO lyn_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koneliyasi sebeli otambula nji, “Kwabita kale amaywaa anee, Kame naikalanga mundoo yange me nilapela omunji ba nako no waatu (15:00) mi sebeli nimona omulume onaku manga eikumango no kubenya yo imanine balubala wange ");
INSERT INTO lyn_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ni kwamba nji, ‘Koneliyasi okulapela kowe naku yupahala mi ni tituso towe na tihupuliwa kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Cwale otumene ku Jopa mi okaisane Simoni no litina lya Pitolosi, kame ali mu ndoo ya Simoni osikusuha eitumba, eyi ili beebi ni liwate.’ ");
INSERT INTO lyn_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Cwale bokame aba nina leluba ookutumena, mi nutende wino aba uneyi. Cwale tonje kame tuli bamweya balubala wa Nyambe, oku yupa eyo ona laelwe yonje kwa Mbumu okutwambela.” ");
INSERT INTO lyn_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Cwale Pitolosi sebeli oyatulula akanwa kaye ni kwamba nji, “Niti luli kame nilemuha nji Nyambe kakete omunu omo aikalele. ");
INSERT INTO lyn_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kono mu sicaba ni sicaba munu yonje woyo omucila ni kutenda eyi ilukile, kame alumelelwa kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kame mulimukile elin̄usa anaku tuma kwaana a Isilaele, okwa kutaza eliywi no kuwaba no kozo ya Jesu Kilesite Ombumu no aanu onje. ");
INSERT INTO lyn_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kame mulimukile eyo ineyi mu Judeya monje eyi inaku tangisa mu Galileya munyima ya Jowani oku kutaza ei no kolobezo. ");
INSERT INTO lyn_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kame mulimukile Nyambe omo anaku wabela Jesu wa Nazaleta ni Mebo no Kukena ni maata, ao anaku tendisa einu no kuwaba niku balisa aanu onje awo anakwi kalanga munji no maata a Satani, kakuli Nyambe kame ana kwikala naye. ");
INSERT INTO lyn_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Cwale kame tuli apaki kwiinu yonje anaku tenda bamweya mu naha no Majuda ni mu Jelusalema. Kame ana mwibaa, okumu tuleka. ");
INSERT INTO lyn_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kono Nyambe naku mwingula ba liywaa no waatu ni kumuba oku monahala, ");
INSERT INTO lyn_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","kasa kwaanu onje kono kwaaci anaku yulekiwa kwa Nyambe okutenda apaki, awo anakulya ni kunwa naye munyima no kwinguka kwaafu. ");
INSERT INTO lyn_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kame ana tulaelele okukutaza kwaanu ni kupaka nji yokame ona ketiwa kwa Nyambe oku tenda omwatuli no asikuyoya naa sikufa. ");
INSERT INTO lyn_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kwayonyene anuhi a Nyambe onje kame apaka nji munu yonje so pumena kwa yonyene kame sa tambule okulemenwa eibi mu litina lyaye.” ");
INSERT INTO lyn_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Abo Pitolosi yo saamba eyi, Emebo No Kukena sebeli ishetumuka beulu no aanu onje awo ana yupu eliywi. ");
INSERT INTO lyn_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Aasikupumena mwa onyene asimupato ana kwiiya ni Pitolosi sebeli akomoka, kakuli empo no Mebo No Kukena naitelwe simba kwaa siacaba. ");
INSERT INTO lyn_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kakuli kame ana kwayupa aamba mu tipuo tindina oku lumbeka Nyambe. Cwale Pitolosi sebeli wamba nji, ");
INSERT INTO lyn_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kana kame kuli omunu so kanena aa aanu oku kolobeziwa ni meyi aa ana tambula Emebo No Kukena kanyi aaci?” ");
INSERT INTO lyn_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Cwale sebeli waalaela nji akolobeziwe mu litina lya Jesu Kilesite. Sebeli amukumbela okwikala noo amaywaa acana. ");
INSERT INTO lyn_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Cwale Atumiwa naaasikupumena awo ali mu Judeya sebeli ayupa nji asimacaba nonyene kame ana tambula eliywi lya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Cwale Pitolosi aba nata ku Jelusalema, onyene asimupato sebeli amuzekisa nji, ");
INSERT INTO lyn_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Iikene aba onati kwaalume aa kasita ku mupato ni kulya noo!” ");
INSERT INTO lyn_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kono Pitolosi sebei otangisa okwaataluseta mu utungi nji, ");
INSERT INTO lyn_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Kame nina kwikala mu mulenen̄i wa Jopa meni lapela, mi muku hapiwa sebeli ni mona epono no sinu simonahala okwiiya banji kanyi olwambi no kuneneba olu lunungilwe ku mamaneneno anee, mane ni kwiiya kwa mene. ");
INSERT INTO lyn_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Aba nishetetako okwaliketa, sebeli ni mona eiyamana ni ibatana neyi yeenda ni mapumo ni iyunyi naku wilu. ");
INSERT INTO lyn_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Cwale sebeli ni yupa eliywi elyamba kwa mene nji, ‘Oimane, Pitolosi, oibae mi olye!’ ");
INSERT INTO lyn_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kono sebeli naamba nji, ‘Kokuulwa Mbumu! Kakuli asimbakwatanga kakwisa esi no matilo simba nokwakena esi sina ingene mu kanwa kange.’ ");
INSERT INTO lyn_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kono eliywi sebeli litambula aka no wiili okutunda ku wilu nji, ‘Eso ana kenisa Nyambe kaufanene okusi isana nji litilo.’ ");
INSERT INTO lyn_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Esi kame sinaku tendahala kaatu, mi einu eyo yonje sebeli yukela ku wilu. ");
INSERT INTO lyn_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ba nako eyo alume aatu sebeli akeela ku ndoo omo tuna kwikala, anaku tumenwa kwa mene okutunda kwa Sesaaliya. ");
INSERT INTO lyn_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Cwale Emebo sebeli inambela nji nite noo, okuulwile okuba elibaka. Abaange mutanu ni mumweya sebeli ata nange, mi nuukaingena mu ndoo no mulume woyo. ");
INSERT INTO lyn_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Cwale sebeli otwambela omo ana kumonena elin̄eloi eli imanine mu ndoo yaye ni kwamba nji, ‘Waatume ku Jopa mi akalonde Simoni woyo oisaniwa Pitolosi. ");
INSERT INTO lyn_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kame saambe kwa wene elin̄usa elyo saaliku yoyise, wene naasindoo yowe onje.’ ");
INSERT INTO lyn_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nji ni tangise okwamba, Emebo No Kukena sebeli ishulumukela beulu yoo kanyi omo ina kwiyela kwaaci ku matatekelo. ");
INSERT INTO lyn_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Cwale sebeli ni puluka eliywi lya Mbumu, omo ana kwambela nji, ‘Jowani naku kolobeza ni meyi, kono anyi mbamu kolobeziwa ni Mebo No Kukena.’ ");
INSERT INTO lyn_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nji cwale Nyambe nakwaaba etimpo no kukufeka kanyi eto anakutuba aba tuna kupumena mwa Jesu Kilesite time anyine cwale nji nikanene Nyambe!” ");
INSERT INTO lyn_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Cwale aba anaku yupa eyi, sebeli akwa emicima ni ku kanyisa Nyambe aamba nji, “Cwale kwa simacaba Nyambe naabi ngeeso okubaka no moyo.” ");
INSERT INTO lyn_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Cwale awo anaku hasana mulibaka no mayando ana kwiiya ba nako ana kweenda Setefani okakeela ku Foenisiya ni ku Sipulasi ni ku Antiyoki, aulwile okwamba eliywi kumunu yonje konji ku Majuda omboci. ");
INSERT INTO lyn_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kono kame kuna kwikala anjili kwa onyene, alume naku Sipulasi ni ku Sileni nakwiiyanga ku Antiyoki mu kwambola ni Mangelike, oku kutaza eliywi lya Mbumu Jesu kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Amaata a Mbumu na kwikala noo, mi ni palo no kupula awo ana kupumena sebeli asiulukela kwa Mbumu. ");
INSERT INTO lyn_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Elin̄usa no eyi sebeli liiya mukuyupahala mu Ndoo ya Nyambe na mu Jelusalema, mi sebeli atuma Banabasi ku Antiyoki. ");
INSERT INTO lyn_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Cwale aba ana kukeela ni kumona esishemo sa Nyambe, sebeli owabelelwa ni kwasusueza onje nji aongotete kwa Mbumu ni mucima no ku tundamena. ");
INSERT INTO lyn_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Kakuli neli mulume no kuwaba, nokwiyala Emebo no Kukena ni tumelo. Cwale aanu no kupula sebeli aekezeha kwa Mbumu. ");
INSERT INTO lyn_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Cwale Banabasi sebeli ota kwa Tesasi oka saela Saule. ");
INSERT INTO lyn_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Cwale aba anaku muwana, sebeli omulita ku Antiyoki. Kame ana kwikalamo omwaka aakuwana ni Ndoo ya Nyambe ni kwiyeta aanu no kupula onene. Mu Antiyoki aiyetwa neli ano weli okwisaniwa nji aasikupumena. ");
INSERT INTO lyn_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Cwale mu maywaa aa, anuhi a Nyambe sebeli aiya okutunda ku Jelusalema okuta ku Antiyoki. ");
INSERT INTO lyn_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Cwale omunjili mwa onyene ona kwisaniwa nji Angabusi sebeli wimana ni kwamba ni Mebo nji kame sakwikale elishebo linene mu litunga lyonje, mi eyi kame inaku tendahala mu nako ya Kilaundiyasi. ");
INSERT INTO lyn_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aiyetwa sebeli alela oku twalela aasikupumena ayakile mu Judeya etituso omunu ni munu oku tundisa omwa tweseta monje. ");
INSERT INTO lyn_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Cwale sebeli atenda ngeso, mi niku tumena akulu no Ndoo ya Nyambe , mu maoko a Banabasi ni Saule. ");
INSERT INTO lyn_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mu nako eyo Ombumu Heloda sebeli otangisa oku yandisa anjili no Ndoo ya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Sebeli oibaa Jakobo minaye Jowani ni sabule. ");
INSERT INTO lyn_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Cwale aba ana kumona nji aendisi no Majuda na wabelelwa, sebeli wekeza okununga ni yonyene Pitolosi. Eyi neli mu maywaa no inkwa na mbulwa omumena. ");
INSERT INTO lyn_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Cwale aba ana kumana okumununga, sebeli omu beeka mu tolongo ni kumuba mu maoko no ikwata inee no masole, mi kame ana kulela oku mubeeka balubala noanu munyima no Paseka. ");
INSERT INTO lyn_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Cwale Pitolosi kame ana kuteulwa mu tolongo, kono Endoo ya Nyambe kaisiku lesele oku mulapelela mukusepahala kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ousiku owo luli abo Heloda yo hupula nji amulite bandee kwaanu, Pitolosi kame nalangananga mukaci no masole ayili yo nungilwe amawenge ayili, mi atateleli ayili aali ba mwelo no tolongo. ");
INSERT INTO lyn_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Cwale komumone, elin̄eloi lya Mbumu sebeli limonahala, mi eliseli sebeli limonahala mu tolongo, mi sebeli likuba Pitolosi ku timaci ni kumwingula okumwambela nji, “Oinguke mu wangu.” Amawenge sebeli akwa ku maoko aye. ");
INSERT INTO lyn_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Cwale elin̄eloi sebeli limwambela nji, “Okufuke mi okumange amakatulo owe.” mi sebeli otenda ngeso, elin̄eloi sebeli limwambela nji, “Okufuke omukanjo wowe mi onikon̄e.” ");
INSERT INTO lyn_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Cwale sebeli obana ni kukon̄a elin̄eloi, kasiku limuka nji elin̄eloi eyi litenda niya luli, kono yonyene kame anaku nahana nji kame amona epono. ");
INSERT INTO lyn_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Cwale aba anakusiya omutateleli no weli ni uyu no wili, sebeli akeela ba mweelo no sondo ou ota mu mulenen̄i. Omweelo sebeli oku yatulula wenyene kwa onyene, mi sebeli atundamo ni kwenda mu ndila, cwale ababo elin̄eloi sebeli limusiya. ");
INSERT INTO lyn_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Cwale Pitolosi sebeli olemuha yonyene ni kwamba nji, “Bano cwale kame ni yii nji ni niti! Mbumu na tumu elingeloi lyaye oku nilukulula mu maoko a Heloda ni kweyo yonje ana kutatelela aanu no Majuda.” ");
INSERT INTO lyn_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Cwale aba anaku lemuha sebeli ota ku ndoo ya Maliya, inawaye Jowani no litina linjili lya Maleka, omo ana kuungana ano kupula alemine okulapela. ");
INSERT INTO lyn_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Cwale abana kokota ba saandi no mweelo, omubika oisaniwa Loda sebeli oiya mukutambula. ");
INSERT INTO lyn_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Aba ana kulimuka eliywi lya Pitolosi, yo wabelelwe kasiku yatulula omweelo kono sebeli oituka okuta mukaci okaamba nji Pitolosi uno, kame aimanine ba mweelo. ");
INSERT INTO lyn_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Sebeli aamba kwa yonyene nji, “Kame otakana!” Kono yonyene sebeli ongoteta nji yokame. Sebeli aamba nji, “Ni lingeloi lyaye.” ");
INSERT INTO lyn_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kono Pitolosi sebeli otwalelela okukokota, mi aba anaku yatulula sebeli amumona mi sebeli akomoka. ");
INSERT INTO lyn_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Kono sebeli waakobeta ni Lyoko nji aondoke, mi sebeli waatolokela omo ana mutundisete Mbumu mu tolongo. Mi sebeli wamba nji, “Mu simwete Jakobo naaasikupumena etaba eyi.” Cwale sebeli waasiya ni kuta ku sibaka sinjili. ");
INSERT INTO lyn_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cwale aba kunakupa, sebeli kwikala omufilifili munene mukaci no masole kweeyo ina tendahala kwa Pitolosi. ");
INSERT INTO lyn_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Cwale Heloda aba ana kumusaela mi sebeli okwangwa okumuwana, sebeli ozekisa aatateleli ni kulaela nji kame afanena okufa. Cwale Heloda sebeli otunda mu Judeya okuta mu Sesaaliya oka ikalamo. ");
INSERT INTO lyn_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Cwale Heloda onaku tinena aanu namu Tile ni Sidoni, cwale sebeli aiya kwa yonyene aali muumweya onje mi aba anaku twesa okususueza Bulasitasi esikombwa sa Mbumu, sebeli akumbela ekozo. Kakuli eilya yoo kame inakutundanga mu naha ya Mbumu. ");
INSERT INTO lyn_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ba liywaa linaku ketiwa Heloda sebeli okufuka eikumango no umbumu ni kwikala mu lubona lwaye, mi sebeli wamba kwaanu mu umbumu. ");
INSERT INTO lyn_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Aanu sebeli akuweleza nji, “Eliywi eli lya mulimu, kasa lya munu.” ");
INSERT INTO lyn_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ababo elin̄eloi lya Nyambe sebeli limufula, kakuli kasiku kanyisa Nyambe, sebeli oliwa ku mibila ni kufa. ");
INSERT INTO lyn_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kono eliywi lya Nyambe sebeli likula ni kwekezeha. ");
INSERT INTO lyn_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Cwale Banabasi ni Saule sebeli auka ku Jelusalema aba anakumana okwiyateteta omusebezi woo, sebeli aiya ni Jowani no litina linjiili lya Maleka. ");
INSERT INTO lyn_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Cwale mu Ndoo ya Nyambe namu Antiyoki kame kuna kwikala aanuhi naaiyeti, Banabasi, Simyoni ona kwisaniwa Nija, Lusiusi namu Sileni ni Manaeni omunjili no manduna no kuta ya Heloda omubusisi ni Saule. ");
INSERT INTO lyn_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Abo alemine oku kubamena Ombumu ni kukuyumena eilya, Emebo No Kukena sebeli yaamba nji, “Muni ketele Banabasi ni Saule atende omusebezi owo ninaa isanene.” ");
INSERT INTO lyn_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Cwale aba ana kumana okuuyumena eilya ni kulapela sebeli abeeka amaoko woo beulu yoo ni kwaafundula ");
INSERT INTO lyn_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Cwale, bakutumiwa ku Mebo No Kukena sebeli ata ku Selusia, mi okutunda abo sebeli alutela mu Sipulasi. ");
INSERT INTO lyn_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Cwale aba anoka keela mu Salamisi, sebeli aaka kutaza eliywi lya Nyambe mu tindoo no ilapelo no Majuda. Kame ana kweenda ni Jowani ona kwaatusanga. ");
INSERT INTO lyn_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Cwale aba anaende mu sooli mane okakeela ku Pafosi, sebeli akuwana ni mulume no mabibo, omunuhi no mapwa no Majuda no Litina lya Bal-Jesu. ");
INSERT INTO lyn_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kame ana kwikalanga ku mubusisi Selgiusi Paulusi, omulume no kushangama. Woyo sebeli oisana Banabasi ni Saule na kulakaza okuyupa eliywi lya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kono Elimasi no mabibo (kakuli neli yonyene etaluso no litina lyaye) sebeli wahanyeza, ni kweteka okukanisa omubusisi nji alese okupumena. ");
INSERT INTO lyn_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kono Saule, woyo wisaniwa kame nji Paulusi, sebeli wiyala ni Mebo No Kukena mi sebeli omwaliketa ");
INSERT INTO lyn_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ni kwamba nji, “Weene omwana no kwiiba, wene esila no inu yonje nokuluka, wene wiyalile ouyi onje, kaulesele okusinya endila no kooloka ya Mbumu! ");
INSERT INTO lyn_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Cwale omone, elyoko lya Mbumu kame lili beulu yowe, kame sotende esibofu mi uulwe okumona eliywaa ba nako icana.” Ababo okwilola ni uwi sebeli ifuka amiyo aye, mi sebeli osaela omunu no kumwendisa ni Lyoko. ");
INSERT INTO lyn_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Cwale omubusisi sebeli opumena aba ana kumona esi sineeyi, kakuli kame ana kukomokisiwa ku tuto ya Mbumu. ");
INSERT INTO lyn_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Cwale Paulusi naa ana kwenda noo sebeli atunda mu Pafosi ni kuta okakeela ni ku Pega namu Pamfiliya. Mi Jowani sebeli waasiya ni kuuka ku Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kono onyene sebeli atunda mu Pega nuuka keela mu Antiyoki namu Pisidiya, mi ba liywaa no Pumulo sebeli aingena mu ndoo no milapelo nuu ka ikala banji. ");
INSERT INTO lyn_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Munyima no ku bala omulawo naanuhi a Nyambe, aendisi no ndoo no milapelo sebeli aatumena omunu ona kwamba nji, “Abaange, nji kame muli ni liywi no kususuweza aanu, mu lyaambe.” ");
INSERT INTO lyn_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Cwale Paulusi sebeli oimana, mi yo kobetite ni Lyoko, sebeli wamba nji, “Alume no Isilaele, naanyi mucila Nyambe, komuteetete! ");
INSERT INTO lyn_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nyambe no aanu aa no Isilaele kame ana kukuketela asitetu ni kwaakulisa asiikalile mu naha no Engepita, ni Lyoko no kwimana sebeli waatundisamo, ");
INSERT INTO lyn_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","cwale mu myaka no kukwana makumi anee (40) sebeli oyanda noo mu lihalaupa. ");
INSERT INTO lyn_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Cwale aba ana kumana okuyundisa amasika mutanu naayili mu naha no Kanana, mi sebeli waaba enaha yoo kanyi ayooli. ");
INSERT INTO lyn_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Cwale munyima nweeyo, Sebeli waaba aatuli okutwala ba nako no munuhi wa Nyambe Samwele, mi kame sina kushimba emyaka ina kukwana emwenda inee ni makumi atanu (450). ");
INSERT INTO lyn_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Cwale aba anaku kumbela nji abiwe ombumu, Nyambe sebeli waaba Saule omwana Kishi, omulume no lusika lwa Benjamine, ni kubusa emyaka inakukwana makumi anee (40). ");
INSERT INTO lyn_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Cwale aba ana kumana oku mutundisa, sebeli oimeka Dabida okutenda ombumu woo, yonaku pakiwa ni kwamba eyaye nji, ‘Kame nina wana Dabida omwana Jese, omulume woyo okolwisa omucima wange, woyo sotenda eyo nisinga yonje.’ ");
INSERT INTO lyn_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Mu lusika no mulume uyu Nyambe na liti omuyoyisi no Isilaele, yonyene Jesu, kanyi omo ana kusepiseza. ");
INSERT INTO lyn_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Cwale Jesu yo kasiiya kale Jowani yo wakutaza kale ekolobezo no kubaka kwaanu onje no Isilaele. ");
INSERT INTO lyn_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Cwale Jowani yoli beebi niku mana omusebezi waye, sebeli nji, ‘Ngasibine muyambuta nji time anyine? Kasa mene yonyene. Kokuulwa, kono munyima yange omunjili okeile, simba etinjatangwa naku makodo aye sitwese okwa nungutula.’ ");
INSERT INTO lyn_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Abaange, aanu no lusika lwa Abulahama naanyi monje aa acila Nyambe, kwaaci na kwiiyi elin̄usa no kuyoyisa. ");
INSERT INTO lyn_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kakuli awo ayoya mu Jelusalema naa endisi oo, mulibaka nji kasi limuka Jesu simba okwayupa amaywii no anuhi a Nyambe aa abaliwa ba liywaa ni liywaa eli no Pumulo, naiyateetete eyi no kumwatula. ");
INSERT INTO lyn_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Simba nji kasikuwana omubonda owo ofanena elifu, sebeli akumbela Pilato kwalukulwela yonyene nji aibaiwe. ");
INSERT INTO lyn_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Cwale aba ana kumana okwiiyateteta eyo inakun̄oliwa eyaye, sebeli amutundisa ba sitondo ni kumu langeka mu libita. ");
INSERT INTO lyn_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kono Nyambe naku mwiingula kwaafu, ");
INSERT INTO lyn_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ni kumoniwa mu maywaa no kupula kwaao ana kwiiya naye okutunda ku Galileya okuta ku Jelusalema, awo atendile cwale apaki aye kwaanu. ");
INSERT INTO lyn_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Cwale na tumilitele eliywi no kuwaba elyo Nyambe ana kusepisa kwaa njekulyetu nji, ");
INSERT INTO lyn_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","esi ana iyatetete mwaaci anoo mu kwingula Jesu, kanyi kame omo kun̄olelwe mu Lismu no wiili nji, ‘Tiwe Mwanange, balelo kame nina kuleye.’ ");
INSERT INTO lyn_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Cwale esisupo no niti aba ana mwingula kwaafu, nji katamba kuukela okoola, ya naamba Nyambe nji, ‘Kame sa nikube okukena ni timbuyoti no niti tina kusepisiwa kwa Dabida.’ ");
INSERT INTO lyn_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Cwale ni mu lisamu linjili nakwambiwa nji, ‘Kutamba kupumenena woyo no kukena wowe nji amone okoola.’ ");
INSERT INTO lyn_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kakuli Dabida aba ana kumana okusebeza mu maywaa aye eso sina kusaelwa kwa Nyambe, sebeli ofa, ni kulangekwa kwa sitaye, ni kumona okoola. ");
INSERT INTO lyn_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kono woyo anaingula Nyambe, katamba kumona okoola. ");
INSERT INTO lyn_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Cwalehe Abange, mu limuke nji, mwa yonyene woyo mulume na mwambeliwa oku lemenwa eibi yenu, ");
INSERT INTO lyn_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","mwa yonyene omunu yonje woyo opumena kame alukululwa ku inu yonje eyo kamutwese oku lukululwa mu mulawo wa Mushe. ");
INSERT INTO lyn_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mu tokomele nakubu, nji cwale mu lese okwiyelwa kweyo inambiwa kwaanuhi nji, ");
INSERT INTO lyn_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Komumone, anyi akamashungu, mu komoke, mi mufe! Kakuli kame ni tenda omusebezi mu maywaa enu, omusebezi samuulwe oku pumena, naba sami talusete woo omunu!’” ");
INSERT INTO lyn_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Aba ana kusinga okubanamo, aanu sebeli akumbela nji atalusete einu eyo afanena okutalusetwa eli no Pumulo linjili. ");
INSERT INTO lyn_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Cwale asi mukopano aba ana kufundulwa, aendisi no Majuda no kupula na pulosebelite awo asebeleza Nyambe sebeli akon̄a Paulusi ni Banabasi, awo sebeli aambola noo, ni kwakutaza okongoteta mu sishemo sa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Eli no Pumulo lina kutatamako omunu yonje namu mulenen̄i sebeli oiya mukuungana bamweya mukuyupa eliywi lya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kono aendisi no Majuda aba ana kumona elikwanamunu, sebeli ayupa omuna, ni ku kanana eyo ina kwambiwa kwa Paulusi, ni ku mushendoola. ");
INSERT INTO lyn_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Cwale Paulusi ni Bananbasi sebeli aambela mukwacila nji, “Kame ku lukeele nji eliywi lya Nyambe lyambelwe anyi oweli. Kono aba mulikana kame mukwatula mwenyene nji kamu fanenwe omooyo no kwaabwa, komumone, kame tusiulukela kwa simacaba. ");
INSERT INTO lyn_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kakuli cwale Ombumu natu laelele nji, ‘Kame nina kutumu nji otenda eliseli no asimacaba, nji olita oku yoyisa mu litunga lyonje okutwala ku mamaneneno.’” ");
INSERT INTO lyn_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Cwale asimacaba aba ana kuyupa ngeso, sebeli awabelelwa, ni kukanyisa eliywi lya Nyambe, mi ano kupula aa ana ketelwe omoyo no kwaabwa, sebeli apumena. ");
INSERT INTO lyn_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Cwale eliywi lya Mbumu sebeli lihasana mu silalanda sonje eso. ");
INSERT INTO lyn_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kono aendisi no Majuda sebeli asusueza akati aa aketukiwa naalume abusai no mulenen̄i, ni kwingulela Paulusi ni Banabasi amayando, mi sebeli aacita mu naha yoo. ");
INSERT INTO lyn_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kono onyene sebeli atutula eliluli ku makondo oo, ni kuta ku Ikoniyamu. ");
INSERT INTO lyn_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Cwale aiyetwa sebeli aiyala okuwabelelwa ni Mebo no Kukena. ");
INSERT INTO lyn_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Cwale mu Ikoniyamu sebeli aingena bamweya mu ndoo no milapelo no Majuda, aba ana kwambamo eliywi, epalo no kupula sebeli ipumena bamweya ku Majuda niku Mangelike ");
INSERT INTO lyn_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kono aendisi no Majuda anokwa pumena sebeli asusueza asimacaba, mi ni kwafilikanya emicima okulwisa aasikupumena. ");
INSERT INTO lyn_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Cwale sebeli aikalamo enako no kuleba, aamba eyi no Mbumu mukwacila, awo aaba oupaki ku liywi no sishemo saye, mukutenda eisupo neyi ikomokisa ni maoko oo. ");
INSERT INTO lyn_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kono aanu namu mulenen̄i kame anokutaba, anjili ku lineku no Majuda anjili ku lineku no atumiwa. ");
INSERT INTO lyn_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Cwale omufilifili aba una kutendiwa ku Majuda bamweya na asimacaba, naa endisi oo, aba ana kusinga nji akatende asiku pumena ouyi ni kwaafula ni mawee. ");
INSERT INTO lyn_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Atumiwa aba anaku lemuha etaba eyo, sebeli acilela ku Lisitila ni ku Deba emulenen̄i namu Likaoniya, ni mu naha ikubapile nayo. ");
INSERT INTO lyn_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Omo sebeli akutazamo eliywi. ");
INSERT INTO lyn_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Cwale mu Lisitila kame kuna kwikalanga omulume onaku leiwa yoli esiyanga no makondo, neli esiyanga okutunda ba kuleiwa kwaye. ");
INSERT INTO lyn_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Yonyene kame ana kuteteta Paulusi yo aamba. Paulusi sebeli omwaliketa, mi sebeli omona nji kame ali ni tumelo nji abalisiwe ");
INSERT INTO lyn_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","cwale sebeli omwambela ni liywi no kuneneba nji, “Oimane ni makondo owe!” mi sebeli omatuka ni kweenda. ");
INSERT INTO lyn_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Cwale enyangela aba ina kumona eyo ana kutenda Paulusi, sebeli atangisa okukuwa mu puo no Silikaniya nji, “emilimu kame ineyi kwaaci mu sumbiwa sikufeka kanyi aanu!” ");
INSERT INTO lyn_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banabasi kame anaku mubeeka elitina lya Zeusi, Paulusi neli lya Hemasi, kakuli neli yonyene omukulu ku kwamba. ");
INSERT INTO lyn_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Omupulisita, no ndoo ya Zeusi onyambe woo eyo inakwikala balubala no mulenen̄i, sebeli olita amapulu akabisitwe ni tipalisa ba myelo kame anaku singa okutenda esitabelo bamweya naanu. ");
INSERT INTO lyn_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kono atumiwa Banabasi ni Paulusi aba ana kuyupa eyo, sebeli akaola eikumango yoo, mi sebeli aitukela mukaci no aanu no kupula alemine okukuwa nji, ");
INSERT INTO lyn_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Alume, ikene aba mutenda ngesi? naaci tuli alume kanyi aanyi, mi kame tuna militele amaywi no kuwaba, nji kame mufanena okusiuluka okutunda ku inu eyi no mbulwa tuso okuta kuwa Nyambe no kuyoya woyo ona kutenda eliwilu ni litunga, ni liwate, neyo yonje ilimo. ");
INSERT INTO lyn_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mu tinako naku nyima kame ana ku lumelelanga aanu onje okwenda mu mikwa yoo. ");
INSERT INTO lyn_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nabakulingeso, kasikulesela okuba oupaki kakuli kame anatende wino ni kumiba ombula na kuwilu ni tinako no kukutula, okumiba eilya ni kwiiiyata emicima yenu oku wabelelwa.” ");
INSERT INTO lyn_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mu maywi aa kasikutwesa aanu okwakanisa okwatendela eitabelo. ");
INSERT INTO lyn_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kono sebeli kwiiya aendisi no Majuda ana kutunda mu Antiyoki ni mu Ikoniyamu, ni kusususweza aanu, sebeli afula Paulusi ni mawee ni ku mukoka oku mutundisa mu mulenen̄i mu kuhupula nji nafu. ");
INSERT INTO lyn_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kono aiyetwa sebeli amubeeka mukaci mi sebeli oinguka ni kwingena mu mulenen̄i. Ba liywaa linaku tatamako sebeli ota ni Banabasi ku Deba. ");
INSERT INTO lyn_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Cwale aba ana kumana okukutaza eliywi mu mulenen̄i owo, ni kuwana aiyetwa no kupula sebeli aukela ku Lisitila ni ku Ikoniyamu ni ku Antiyoki. ");
INSERT INTO lyn_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kame ana kongota emicima no aiyetwa ni kwaa susuweza nji atundamene mu tumelo, ni kwamba nji kame tufanena okwingena mu mayando no kupula nji twingene mu mubuso wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Cwale aba ana kumana okuketa akulu mu keleke ni keleke, ni kulapela nuukuyumena eilya, sebeli aasiya mu sishemo no Mbumu woyo ana ku pumena mwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Cwale sebeli abita mu naha no Pisidiya ni kuta ku Pamfiliya. ");
INSERT INTO lyn_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Cwale aba ana kumana okwamba amaywi mu Pega, sebeli ata ku Ataliya, ");
INSERT INTO lyn_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","cwale okutunda abo sebeli alutela ku Antiyoki, omo ana kubeekiwa mu sishemo sa Nyambe mu musebezi owo ana kwiyateteta. ");
INSERT INTO lyn_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Cwale aba ana kukeela, sebeli awaneka Ekeleke bamweya ni kwamba yonje eyo Nyambe ana tende noo, nomo ana yatulwele omweelo no tumelo no asimacaba. ");
INSERT INTO lyn_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Cwale sebeli aikala enako no kuleba naaiyetwa. ");
INSERT INTO lyn_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kono anjili alume ana kwiiya oku tunda mu Judeya sebeli aiyeta aasikupumena nji, “Aba kamwaingene mu mupato okuta mu mulawo wa Mushe, ka mu tamba okuyoisiwa.” ");
INSERT INTO lyn_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Cwale Paulusi ni Banabasi abaana kukanana noo onene, Paulusi ni Banabasi naanjili ngeso sebeli ayulekiwa nji ate ku Jelusalema kwaatumiwa naakulu akambole etaba eyo. ");
INSERT INTO lyn_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Cwale Endoo ya Nyambe sebeli yaafundula ngeso, sebeli ata endila no kubita mu Foenisiya bamweya ni mu Samaliya, alemine okwamba eyi no ku siuluka no asimacaba, mi sebeli aaba okuwabelelwa no kuneneba kwa asikupumena onje. ");
INSERT INTO lyn_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Cwale aba ana kwiiya ku Jelusalema, sebeli atambuliwa kwaatumiwa ni keleke, ni kwaakulu, mi sebeli atalusa yonje eyo ana kutenda Nyambe mwa onyene. ");
INSERT INTO lyn_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kono aasikupumena anjili ao ali ku seemba no Afalisi sebeli aimana ni kwamba nji, “Esi sifanena ni kwatwala ku mupato, ni kwaa laela nji akuteke omulawo wa Mushe.” ");
INSERT INTO lyn_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Atumiwa naakulu sebeli akuwana bamweya okutatuba etaba eyi. ");
INSERT INTO lyn_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Cwale munyima no kwaambota onene, Pitolosi sebeli oimana nikwamba nji, “Abaange, kame mulimukile nji mu maywaa ana kubwa Nyambe na kuniketa mukaci kenu nji mulibaka no kanwa kange asimacaba kame afanena okuyupa eliywi lya Nyambe ni kupumena. ");
INSERT INTO lyn_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Cwale Nyambe woyo olimukile emicima yoo, kame aapaka mu kwaaba Emebo No Kukena kanyi omo ana tendele kwaaci. ");
INSERT INTO lyn_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kasi tenda eshutano mukaci ketu nonyene, kono kame anaakenisa ni tumelo. ");
INSERT INTO lyn_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Cwalehe, iikene aba mweteka Nyambe mu kubeeka ecoko mu tindingo no aiyetwa eyo ana kwangwa anjekulyetu simba eyo natukutwesa okushimba? ");
INSERT INTO lyn_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Cwale kame tupumena nji kame satu yoyisiwe mu sishemo sa Mbumu Jesu, kanyi omo sayoyisetwe nonyene.” ");
INSERT INTO lyn_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Cwale esikwata sonje sebeli sondoka mi kame ana kuyupeteta kwa Banabasi ni Paulusi aba ana kutalusa etiponiso ni timakazo eto Nyambe ana kutenda mwa onyene mukaci no asimacaba. ");
INSERT INTO lyn_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Munyima aba ana kumana okwamba, Jakobo sebeli otambula nji, “Abaange muteetete kwa mene! ");
INSERT INTO lyn_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni sebeli otalusa omo Nyambe ana ku tangiseta oweli okupotela asimacaba, nji mukaci koo akuketele aanu aa afanena elitina lyaye. ");
INSERT INTO lyn_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Eyambo eyi kame ilumelelana ni maywi no anuhi a Nyambe, kanyi omo kun̄olelwe nji, ");
INSERT INTO lyn_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Munyima no eyi, kame sa nuuke, mi kame sa ni yake esibaka ana kuyoya Dabida , eso sinakwi Kame sani yake ba matota no kale, mi kame sani wiimeke. ");
INSERT INTO lyn_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nji aanu ana siyalako asaele Mbumu, naa simacaba onje awo ana isaniwa mulibaka no litina lyange. ");
INSERT INTO lyn_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kame kwamba Mbumu, woyo ona kutenda einu eyi nji ilimukiwe okutunda ku matatekelo.’ ");
INSERT INTO lyn_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Abakulingeso, ekatulo yange ninji, “Katu fanene oku kataza asimacaba awo asiulukela kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kono kame tufanena okwaan̄olela nji atunde kweyi no litilo no maswaniso, ni kuuhule, ni kweyi no kowiwa, ni ku unyinga. ");
INSERT INTO lyn_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kakuli okutunda ku nako na kukale mu mulenen̄i ni mulenen̄i kame kuli ao akutaza eyi no milao ya Mushe eli no Pumulo neli no Pumulo mu tindoo no milapelo.” ");
INSERT INTO lyn_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Cwale kame kuli wino atumiwa naakulu ni keleke yonje, okuketa alume okutunda mwaonyene ni kwaatuma ku Antiyoki bamweya ni Paulusi ni Banabasi. Sebeli atuma Juda woyo oisanwa nji Banabasi, ni Sailasi, alume abusa mukaci no aasikupumena, ");
INSERT INTO lyn_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ni kwatumena elin̄olo linjili eli lyamba nji, “Abaange, atumiwa bamweya naakulu, nikwaaasikupumena nwa simacaba mu Antiyoki ni mu Siliya ni mu silisiya, mulumele. ");
INSERT INTO lyn_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kakuli na tuyupu nji aanu anjili ana tundu mwaaci kame ana mishupu ni maywi, oka mifilikanya emicima yenu, simba nji katwasikwa laela ngeso. ");
INSERT INTO lyn_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Naku monahala wino mwaaci, aba tuna lumelelana bamweya, okuketa alume okwatuma kwaanyi naa singiwa etu Banabasi ni Paulusi, ");
INSERT INTO lyn_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","alume ana ku toboha omoyo woo mulibaka lya Mbumu wetu Jesu Kilesite. ");
INSERT INTO lyn_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Cwalehe natu mitumene Judasi ni Sailasi, awo onyene mbami talusete einu imweya mu liywi no kanwa. ");
INSERT INTO lyn_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kakuli na kumonahala wino ku Mebo no kukena ni kwaaci okwamibeeka omushimbo no kuneneba okubita eyi einu no utokwa, ");
INSERT INTO lyn_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","nji mukulya kweyo ina tendiwa esitabelo ku maswaniso neyi itunda ku unyinga ni kweyi no kowiwa neyi itunda mu uhule. Nji kame okuteula wenyene kweeyi, mbu tende wino. Musiyale wino.” ");
INSERT INTO lyn_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Cwale aba ana kufundulwa awo, sebeli ata ku Antiyoki, niku waneka bamweya emikopano ni kwaaba elin̄olo. ");
INSERT INTO lyn_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Cwale aba ana ku libala, sebeli awabelelwa onene ku maywi alyo no susuezo. ");
INSERT INTO lyn_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Cwale Judasi ni Sailasi, awo ana kutenda onyene aanuhi a Nyambe, sebeli asusueza aasikupumena ni maywi no kupula ni kwaaongota. ");
INSERT INTO lyn_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Cwale aba ana kwikalamo enako no kuleba, sebeli afundulwa mu kozo kwaaasikupumena awo ana kwafundula. ");
INSERT INTO lyn_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kono Sailasi sebeli osinga oku siyala. ");
INSERT INTO lyn_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Kono Paulusi ni Banabasi sebeli asiyala mu Antiyoki, aiyeta ni kukutaza eliywi lya Mbumu, bamweya naanjili ano kupula. ");
INSERT INTO lyn_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Cwale munyima no maywaa anjili, Paulusi sebeli wambela Banabasi nji, “Wiiye, tuuke tukapotele aasikupumena mu mulenen̄i ni mulenen̄i omo tuna kwambanga eliywi lya Mbumu, ni kumona omo ayoyela.” ");
INSERT INTO lyn_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Cwale Banabasi sebeli osinga okushimba Jowani woyo oisaniwa nji Maleka. ");
INSERT INTO lyn_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kono Paulusi sebeli onahana nji alese okushimba omunu ona kwaasiya asili mu Pamfiliya, mi kasi kuta noo mu musebezi woo. ");
INSERT INTO lyn_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Cwale sebeli kwinguka efapano no kuneneba, mane sebeli akutaba, Banabasi sebeli oshimba Maleka ni ku lutela mu Sipulasi, ");
INSERT INTO lyn_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","kono Paulusi sebeli oketa Sailasi ni ku funduka, yo beekilwe mu sishemo no Mbumu kwaaasikupumena. ");
INSERT INTO lyn_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Cwale sebeli ota mu Seliya ni mu Silisiya, yo ongota etikeleke namo. ");
INSERT INTO lyn_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulusi sebeli wiiya mu Deba ni ku Lisitila. Omo kame ku na kwikalanga omwiyetwa, no litina lya Timoteya. Omwana no mukati no Mujuda omuasikupumena, kono sitaye neli omungelike ");
INSERT INTO lyn_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kame ana kupakiwa wino kwaa asikupumena na mu Lisitila ni mu Ikoniyamu, ");
INSERT INTO lyn_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulusi kame ana ku saela Timoteya nji amu sindekete, mi sebeli omushimba ni ku mubeeka ku mupato mulibaka no Majuda ana kwiikalanga mu ibaka eyo, kakuli kame ana kulimuka nji sitaye neli mungelike ");
INSERT INTO lyn_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Aali mu musipili woo okuta ku milenen̄i, sebeli alaela aaasikupumena nji amamele omulawo ana kubeeka atumiwa naakulu awo ana kwikalnga mu Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Cwale etikeleke kame tina kongotiwa mu tumelo, ni kwekeza ku palo mu liywaa ni liywaa. ");
INSERT INTO lyn_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Cwale sebeli ata mu naha no Filinjiya ni mu Galatiya, kakuli Emebo No Kukena kame ina kwaakanisa okwamba amaywi mu Asia. ");
INSERT INTO lyn_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Cwale aba ana kwiiya okusheeteta amabapa ni Misiya, sebeli a saela okuta mu Betiniya, kono Emebo ya Jesu kaisikwa alumelela. ");
INSERT INTO lyn_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Cwale aba ana kumana okweenda mu naha no Misiya, sebeli ashetumukela ku Tulowasi. ");
INSERT INTO lyn_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Paulusi sebeli omona epono mu usiku, omulume naku Mesodoniya yo imanine yo mu kumbela ni kwamba nji, “Wiiye mu Mesodoniya mukututusa.” ");
INSERT INTO lyn_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Cwale aba ana kumana okumona epono eyo, Ababo sebeli tuku tukiseta mu wangu okuta ku Mesodoniya, me tunahana nji Nyambe kame ana twisanene oka kutazamo eliywi kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Aba tuna kufuula okutunda mu Tulowasi, sebeli tuta ku Samotilasi, eliywaa lina kutatamako sebeli tukafuweka mu Ne-yapolisi. ");
INSERT INTO lyn_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Aba tuna kutundamo sebeli tukaingena mu Filipi, omulenen̄i no weli mu sikiliti no Mesodoniya, kame ni koloni no Maloma. Sebeli twiikalamo amaywaa no mupula. ");
INSERT INTO lyn_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Cwale ba liywaa no Pumulo sebeli tuta ku nyonga no musindi, oko tuna kuhupula nji kame kuli esibaka no milapelo, mi sebeli twiikala ni kwamba naakati ana ku unganako. ");
INSERT INTO lyn_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Omukati omunjili mwa onyene ona kutuyupa neli no litina lya Lidiya, ona kutunda mu mulenen̄i no Tiyatila, omuulisi no ibyana no undilu. Woyo olapela Nyambe, mi Ombumu sebeli oyatulula omucima waye nji atokomele eyo aamba Paulusi. ");
INSERT INTO lyn_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Cwale aba ana kumana okukolobeziwa, naasindoo yaye, sebeli otu kumbela nji, “Nji namwaatula nji mbili wa ku sepahala kwa Mbumu, mwiiye mu ndoo yange mwikalemo.” Sebeli otu hapeleza okuta. ");
INSERT INTO lyn_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Eliywaa linjili kame tuna tanga mu sibaka no milapelo, sebeli tukuwana ni musizana no mubika woyo oli ni mebo no unuhi, naku fumisa onene molyaye mu ku nuha. ");
INSERT INTO lyn_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Sebeli okon̄a Paulusi naaci yo kuweleza nji, “Alume aa nabika a Nyambe oli beulu! Kame amyambela endila no mooyo!” ");
INSERT INTO lyn_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Eyi kame ana kwitenda mu maywaa no kupula. Kono Paulusi sebeli otina, ni ku futuka ni kwamba ku mebo nji, “Kame ni ku laela mu litina lya Jesu Kilesite otunde mwa yonyene!” Cwale sebeli itunda mwa yonyene ababo ba nako eyeyo. ");
INSERT INTO lyn_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kono aolyaye aba ana kumona nji naabwelwe esepo no ku fuma, sebeli alema Paulusi ni Sailasi ni kwatwala mu sibaka no musika balubala nwaa busisi. ");
INSERT INTO lyn_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Cwale aba ana kumana okwaalita bouso nwaatuli, sebeli aamba nji, “Alume aa, Majuda mi kame alyanganisa omulenen̄i wetu. ");
INSERT INTO lyn_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Kame aiyeta emikwa eyo no kwafanena nji twiikon̄e ni kwiitambula aaci Amaloma.” ");
INSERT INTO lyn_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Enyangela sebeli itateka okwaalwisa, mi aatuli sebeli akaola eikumango yoo ni kuba etaelo nji afuliwe ni pafa. ");
INSERT INTO lyn_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Cwale aba ana kumana okwafula emiupa no kupula, sebeli aaingenyeka mu tolongo, ni ku laela omutateleli nji aatatelele onene. ");
INSERT INTO lyn_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Woyo aba na laelelwe ngeeso, sebeli waabeeka mu tolongo na mukaci ni kwaabeeka amakondo oo mu itondo. ");
INSERT INTO lyn_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kono ba kaci no usiku Paulusi ni Sailasi sebeli alapela ni kwiimba etindimo kwa Nyambe, mi amapantiti ateeteta. ");
INSERT INTO lyn_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mu nako imweya fela sebeli kwiiya ezikinyeho no litunga, cwale emitomo no tolongo sebeli inyanganya mi ababo emyelo sebeli iyatuluka mi amawenge onje sebeli anungutuka ku munu yonje. ");
INSERT INTO lyn_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Cwale omutateleli aba ana kwinguka ni kumona nji emyelo naiyatuluka, sebeli oshomona omukwale waye nji akwibae, ba kuhupula nji mwendi amapantiti onje naatundumo. ");
INSERT INTO lyn_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kono Paulusi sebeli okuwa ni liywi no kuneneba nji, “Olese okwibaa, kakuli tusilimo toonje.” ");
INSERT INTO lyn_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Omutateleli aba ana ku kumbela elibona, sebeli witukelamo, mu kucila sebeli okakwela ku makondo a Paulusi ni Sailasi. ");
INSERT INTO lyn_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Cwale sebeli waatundiseta ba ndee ni kwamba nji, “Alume, ngasibine sani tende nji ni yoyisiwe?” ");
INSERT INTO lyn_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Cwale sebeli aamba nji, “Olumele mwa Mbumu Jesu, mbuyoyisiwa, wene mane naasindoo yowe.” ");
INSERT INTO lyn_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Cwale sebeli aamba amaywi no Mbumu kwa yonyene ni kwao onje ana kwikala mu ndoo yaye. ");
INSERT INTO lyn_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Sebeli waashimba mu nako eyeyo no usiku, ni kwaayowisa ba miupa-upa yoo, mi sebeli okolobeziwa ababo naasindoo yaye onje. ");
INSERT INTO lyn_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Cwale sebeli waalita mu ndoo yaye, ni kwaaba eilya balubala woo, ni ku wabelelwa naa sindoo yaya onje kakuli na lumele mwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kono aba kuna kupa, aatuli sebeli alaela omupolisa, ni kwamba nji, “Waalukulule awo alume akutele.” ");
INSERT INTO lyn_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Cwale omupolisa sebeli osimweta Paulusi amaywi awo, ni kwamba nji, “Aatuli nani tumu nji mu lukululwe mu kutele. Cwalehe na mulukululwa, mi mweende mu kozo.” ");
INSERT INTO lyn_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kono Paulusi sebeli wamba kwa onyene nji, “Kame ana tufulu balubala nwaanu, kono kasikutwatula oweli, aci tutendile tuli amaloma, mi naatubeeke mu tolongo. Cwale kame asaela oku tu tundisamo ku mukunda? Kokuulwa! Mwaalesele onyene aiye muku tutundisamo.” ");
INSERT INTO lyn_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Amapolisa sebeli asimweta aatuli amaywi ao, mi sebeli acila aba ana kuyupa nji neli Maloma. ");
INSERT INTO lyn_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Cwale sebeli aiya nuuku kokobeza kwaonyene. Sebeli aatundisamo, ni kwakumbela nji asiye omulenen̄i. ");
INSERT INTO lyn_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Cwale aba ana kutunda mu tolongo, sebeli ata kwa Lidiya, mi cwale aba ana kumana okumona naaasikupumena, ni kwaaongota emicima, mi sebeli afunduka. ");
INSERT INTO lyn_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Cwale aba ana kubita mu Amfipolisi ni mu Apoloniya, sebeli aiya mu Tesalonika omo kuna kwikala endoo no milapelo no Majuda. ");
INSERT INTO lyn_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulusi mu mukwa waye sebeli oingena kwa onyene, mi mu tisunda taatu, yo kanana noo okutunda mu man̄olo ");
INSERT INTO lyn_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ni kwataluseta ni kwamonisa nji kame kuna kufanena Kilesite oku yupisiwa okukola ni kwinguka kwaafu, ni kwamba nji, “Woyo Jesu nineeyi mu kwamba kwaanyi eyaye, yokame Kilesite.” ");
INSERT INTO lyn_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Cwale anjili mukaci koo sebeli asusuezwa, nuukuwana ni Paulusi ni Sailasi bamweya naa nokupula no Mangelike mane naakati no kupula ao akutekiwa. ");
INSERT INTO lyn_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kono aendisi no Majuda kame ana kwafelanga omuna, mi sebeli ashimba aafokoli anjili anatoliwa, ni kwaawaneka okwaatenda esitopa, ni kubeeka omulenen̄i mukaci, okutinguluka endoo ya Njasoni, okwaasaela nji aalite kwaanu. ");
INSERT INTO lyn_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Cwale aba na kuulwa okwawana, sebeli akokela Njasoni naanjili aasikupumena balubala no abusisi no mulenen̄i alemine okukuwa nji, “Alume awo ana liti outata mu litunga, kame aneyi ni kuno, ");
INSERT INTO lyn_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","mi Njasoni naatambula, mi onje kame alwisa emilao ya Sizale aamba nji kame kuli omunjili Ombumu yonyene Jesu.” ");
INSERT INTO lyn_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Cwale aanu naabusisi no mulenen̄i sebeli ahakanyeha aba ana kuyupa eyi. ");
INSERT INTO lyn_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Cwale aba ana kushimba amali kwa Josani ni kwaanjili, sebeli aalesela nuukutela. ");
INSERT INTO lyn_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ababo aasikupumena sebeli afundula Paulusi ni Sailasi ousiku okuta ku Beliya, mi aba ana kukeela sebeli aingena mu ndoo no milapelo no Majuda. ");
INSERT INTO lyn_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Cwale aendisi no Majuda aa kame ana kwikala ni micima no kuwaba okubita awo na mu Tesalonika, kakuli kame ana tambula eliywi mu kutukufalelwa, ni kusaisisa mu man̄olo mu liywaa ni liywaa okumona nji einu eyi moikalele. ");
INSERT INTO lyn_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ano kupula mwaonyene sebeli apumena, naakati no kukutekeha no Mangelike naalume ngeeso. ");
INSERT INTO lyn_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kono cwale aendisi no Majuda na mu Tesalonika aba ana kuyupa nji eliywi lya Nyambe kame lyambiwa kwa Paulusi mu Beliya, sebeli aiya mo mu kufilikanya esicaba. ");
INSERT INTO lyn_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Cwale aasikupumena ababo sebeli afundula Paulusi, okumutwala ku liwate, kono Sailasi ni Timoteya sebeli asiyalamo. ");
INSERT INTO lyn_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Awo ana sindeketa Paulusi sebeli akakeela ku Atenesisi, abaana kuuka sebeli aiya ni titaelo okutunda kwa Paulusi nji, Sailasi ni Timoteya ate kwa yonyene muwangu mi ababo sebeli afunduka. ");
INSERT INTO lyn_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ababo Paulusi yosaatatelele mu Atenesi, sebeli otina aba ana kumona nji omulenen̄i kame wiyalile eifekiso no milimu. ");
INSERT INTO lyn_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Cwale sebeli okanana ni Majuda mu ndoo no milapelo naanu awo acila Nyambe, sebeli otenda ngeso muliywaa ni liywaa ku munu yonje woyo ona kuwaninga mu musika. ");
INSERT INTO lyn_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Cwale a si Epikulini ni sitoiki filosofi sebeli aambola naye. Mi anjili sebeli aamba nji, “Osibuwabuwi uyu iikene aamba?” Anjili sebeli aamba nji, “Kame amonahala kanyi omukutazi no milimu indina.” kakuli kame ana kwaataluseta ya Jesu neyi no kwinguka kwaafu. ");
INSERT INTO lyn_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Cwale sebeli amushimba, okuta naye ku Aleopangasi ni kwamba nji, “Kame tusinga okulimuka eyi tuto no ubya eyi wamba iikene italusa? ");
INSERT INTO lyn_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kakuli nuliti eyambo no kwatwaelwa mu matwi etu, cwale kame tusinga okulimuka eyi italusa.” ");
INSERT INTO lyn_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Cwale Amaatenesi onje naanu andina ao ayoyanga mo kaasikutenda esindina konji okwamba simba okuyupa eyi no ubya. ");
INSERT INTO lyn_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Cwale Paulusi sebeli oimana bakaci nwa Aleopangasi ni kwamba nji, “Anyi alume no Atenesi, kame ni lemuhile nji mu ndila yonje kame muli ni tumelo. ");
INSERT INTO lyn_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kakuli aba ninabiti kame nina mono outokwa wetu noo ku lapela, sebeli ni wana ealetale aba ku n̄olilwe nji, ‘Kwa Nyambe no kwalimukiwa.’ Iikene cwale aba mu lapelela einu no kwalimukiwa, eyi yanamba kwaanyi. ");
INSERT INTO lyn_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nyambe ona ku tenda elitunga niinu yonje ilimo, bakutenda Ombumu no liwilu ni litunga, ka yoyo mu tikeleke ti yakilwe ni maoko nwaanu. ");
INSERT INTO lyn_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Simba kame asebelezwa ni maoko nwaanu, kanyi nji kame asaela esinjili, kakuli yonyene kame aba aanu onje ouplo ni kooyela ni inu yonje. ");
INSERT INTO lyn_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Cwale kame ana kutenda mumweya mu matunga onje nwaanu oku yoya ba lubala no litunga longe, yokame ona lukisa etinako ni miseto no aanu omo ayayo. ");
INSERT INTO lyn_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Cwale nji kame afanena okusaela Nyambe, mu kuyambuta nji mba mubabatele ni ku muwana, mi yonyene kayoyo oku no kuleba naaci. ");
INSERT INTO lyn_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","kakuli mwa yonyene kame, ‘Tuyoya, ni kweenda, ni kwikala kwetu.’ Sokame anaamba asikuloka anjili nji, ‘Naaci kame tuli anaaye luli.’ ");
INSERT INTO lyn_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Cwale aba tuli ana a Nyambe, ka tulukele oku yambuta nji Nyambe mba feke kanyi gauda, simba esilibela, simba eliwee, eili eyi imanena esifekiso no mihupulo no munu. ");
INSERT INTO lyn_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mu nako na kunyima Nyambe kame ana kwaliketanga aanu feela, kono bano kame alaela aanu onje okwaali nji abake. ");
INSERT INTO lyn_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kakuli na kubeeka eliywaa elyo saatule elitunga mu niti mu mulume woyo ana kuketa, mi mweesi nabi aanu onje mu kumwingula kwaafu!” ");
INSERT INTO lyn_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Cwale aba na kuyupa eyi no kwinguka kwaafu, anjili sebeli asheka kono anjili sebeli aamba nji, “Kame satu kuyupe kame wamba ba tuto eyi.” ");
INSERT INTO lyn_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Cwale Paulusi ababo sebeli waasiya. ");
INSERT INTO lyn_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kono aanu anjili sebeli akon̄a ni ku pumena, mwaonyene Denisi no Aleopangasi ni mukati no litina lya Damalisi naanjili aanu. ");
INSERT INTO lyn_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Aba kuna bwi eyo, Paulusi sebeli otunda mu Atenesi okuta ku Kolinte. ");
INSERT INTO lyn_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Cwale sebeli okawana Omujuda no litina lya Akila, kakuli Kulaude kame ana ku laela aendisi no Majuda okutunda mu Loma. Cwale sebeli ota okaamona, ");
INSERT INTO lyn_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","kakuli neli omunu no musebezi umweya nonyene, sebeli oikala noo, mi kame ana ku sebezanga, kakuli neli asiku tenda amatende. ");
INSERT INTO lyn_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Cwale kame anakukanananga mu ndoo no milapelo eli no Pumulo lyonje, mi sebeli osusuweza aendisi no Majuda ni Mangelike ");
INSERT INTO lyn_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Cwale Sailasi ni Timoteya aba ana kukeela okutunda ku Mesodenia, Paulusi yo patehile ni kukutaza, okuba oupaki ku Majuda nji Kilesite yokame Jesu. ");
INSERT INTO lyn_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Cwale aba ana ku mu sheununa, sebeli otutula eikumango yaye ni kwamba nji, “Ounyinga wenu wikale ba mitwi yenu! Mene sikwite omubonda ku onyene. Okutunda bano kame sanite kwaa simacaba.” ");
INSERT INTO lyn_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Cwale sebeli otundamo ni kuta ku ndoo ya mulume no litina lya Tite Justusi omulapeli wa Nyambe, endoo yaye kame ina kwikalanga abeebi ni ndoo no milapelo. ");
INSERT INTO lyn_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilisipo omubusisi no tindoo no milapelo, ona ku pumena mwa Mbumu, bamweya naa sindoo yaye, mi Amakolinte ano kupula ana kuyupa Paulusi sebeli apumena mane niku kolobeziwa. ");
INSERT INTO lyn_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Cwale Ombumu sebeli wamba kwa Paulusi mu usiku umweya mu pono nji, “Olese kucila, kono waambe mi olese okondoka, ");
INSERT INTO lyn_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kakuli kame nili ni wene, mi kakwisa omunu so kulwisa simba okulemeka, kakuli kame nili naanu no kupula muno mu mulenen̄i.” ");
INSERT INTO lyn_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Cwale sebeli oikala omwaka mu mweya ni tikweti mutanu ni kamweya, (6) yo iyeta eliywi lya Nyambe mwaonyene. ");
INSERT INTO lyn_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kono cwale Galiyo yoli omubusisi no Akaya, aendisi no Majuda sebeli akuwana ni ku lwisa Paulusi ni ku mulita balubala no Kuta. ");
INSERT INTO lyn_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Sebeli aamba nji, “Wuyu mulume kame asusuweza aanu ku lapele Nyambe mu ndila eyo ilwisa omulawo!” ");
INSERT INTO lyn_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kono Paulusi aba ana kusinga okwamba, Galiyo sebeli wambela aendisi no Majuda nji, “Kambe ni mulibaka no kufosa simba okutenda omubonda, kambe kame kuli elibaka elyo ni twesa oku miyupisisa anyi aendisi no Majuda. ");
INSERT INTO lyn_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kono kakuli ni mulibaka no tipuzo no maywi ni matina ni mulawo wetu, mu kumonene mwenyene. Kame ni kana okwatula eyambo eyi. ");
INSERT INTO lyn_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Cwale sebeli waatundisa mu Kuta. ");
INSERT INTO lyn_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Cwale onje sebeli alema Sosiene, omwendisi no ndoo no milapelo ni ku mufula balubala no Kuta. Kono Galiyo kasi kutwalako omucima. ");
INSERT INTO lyn_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Munyima no eyi, Paulusi sebeli oikala amaywaa no kupula, ni kusiya akwaye ni kulutela ku Siliya, yo enda ni Pulisila ni Akila. Ku Senkiliya, sebeli okukuliwa etin̄uki, kakuli kame ano kununga esinjili. ");
INSERT INTO lyn_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Cwale sebeli akeela mu Efese, mi sebeli waasiyamo, kono yonyene sebeli ota mu ndoo no milapelo mu ku kanana ni Majuda. ");
INSERT INTO lyn_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Cwale aba ana ku mukumbela nji aikale noo enako no kuleba, sebeli okana. ");
INSERT INTO lyn_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kono aba kwaasiya, sebeli waambela nji, “Kame sani kauke kwaaci nji Nyambe mba singi.” Cwale sebeli oluta okusiya Efese. ");
INSERT INTO lyn_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cwale aba ana kukeela mu Sesaaliya, sebeli ota okakeeta etikeleke mi cwale sebeli oshetumuka ku Antiyoki. ");
INSERT INTO lyn_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Munyima no kwikalamo enako, sebeli ota ku sibaka ni sibaka mu naha yonje no Galatiya ni Filigiya yo ongota aiyetwa. ");
INSERT INTO lyn_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Cwale Omujuda onakwisaniwa nji Apolosi, woyo ona kuleyelwa mu Alekizandiliya, sebeli wiiya mu Efese. Neli omulume no kulimuka okwamba wino ona kwiyeta eliywi. ");
INSERT INTO lyn_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kame ana kwiyeta mu ndila ya Mbumu, ni kutenda omubika mu mebo, kame aamba ni kwiyeta wino-wino einu eyi yaama Jesu, kono eyo ana kulimuka yonyene neli kolobezo ya Jowani fela. ");
INSERT INTO lyn_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Sebeli otateka okwamba mu undume mu ndoo no milapelo, kono cwale Pulisila ni Akila aba ana ku muyupa, sebeli amutwala ku ndoo ni ku mutaluseta omo aikalele Nyambe wino. ");
INSERT INTO lyn_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Cwale aba ana kusinga okuta okulutela ku Akaya, aasikupumena sebeli amususuweza ni kun̄olela aiyetwa nji amutambule. Aba ana kukeela, sebeli otusa onene mu sishemo awo ana ku pumena. ");
INSERT INTO lyn_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kakuli kame ana kutwesa okwambela aendisi no Majuda mu maata no kuneneba mukwamonisa mu man̄olo nji, Kilesite yokame Jesu. ");
INSERT INTO lyn_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolosi yoli mu Kolinte Paulusi sebeli okaula enaha eyi ilumbile ni kwiiya mu Efese. Omo sebeli owana aiyetwa anjili. ");
INSERT INTO lyn_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Cwale sebeli waaibanguta nji, “Na mukutambula Emebo No Kukena aba muna ku pumena?” Mi sebeli atambula nji, “Kokuulwa, katwa siku yupa simba mbicana nji kame kuli Emebo No Kukena.” ");
INSERT INTO lyn_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Cwale sebeli waaibanguta nji, “Ka kolobezo mu na kukolobezwa nayo?” Sebeli atambula nji, “Mu kolobezo ya Jowani.” ");
INSERT INTO lyn_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Cwale Paulusi sebeli wamba nji, “Jowani kame ana ku kolobeza ni kolobezo no kubaka, okwambela aanu nji apumene kwa woyo soiya munyima yaye, yonyene Jesu.” ");
INSERT INTO lyn_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Aba ana kuyupa eyo, sebeli akolobezwa mu litina lya Mbumu Jesu. ");
INSERT INTO lyn_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Cwale Paulusi aba anakumana okwabeeka amaoko aye beulu, Emebo No Kukena sebeli yaashulumukela beulu yoo, mi sebeli aamba mu tindimi no kwalimukiwa mane ni kunuha. ");
INSERT INTO lyn_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Oonje kame ana kukwana epalo ikuma ba likumi naayili (12). ");
INSERT INTO lyn_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Cwale sebeli oingena mu ndoo no milapelo mi mu tikweti taatu yo aamba mu undume, yo kanana noo ni kwakolwisa eyi no mubuso wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kono anjili kame ana kwikala ni mahanyi okwapumena, aamba eyi no kwiiba eyi no Ndila balubala no mukopano, sebeli otunda kwa onyene, ni ku shimba aiyetwa, yo ambola noo mu liywaa ni liywaa mu muyako no ndoo ya Tilanasi. ");
INSERT INTO lyn_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Eyo sebeli yekeza mu myaka yiili, nji cwale aanu no Asiya ayupe eliywi lya Mbumu aendisi no Majuda bamweya ni Magelike ");
INSERT INTO lyn_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Cwale Nyambe naku tenda etimakazo no ku komokisa mu maoko a Paulusi. ");
INSERT INTO lyn_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Etitaulo mane ni tinyambi naiku tundisiwa ba lutu lyaye sebeli ibeekiwa kwaa sikukola, ni meeti sebeli atunda, ni mebo no kwiiba sebeli itunda mwa onyene. ");
INSERT INTO lyn_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Cwale anjili no aendisi no Majuda ana kwendanga atundisa Emebo no kwiiba, kame ano kutusisanga okwamba elitina lya Jesu nji, “Kame ni ku laela mu litina lya Jesu, woyo ona kukutaziwa kwa Paulusi.” ");
INSERT INTO lyn_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Aana mutanu na yiili no mupulisita mukulu no Majuda no litina lya Sikeba ana kutenda ngeso. ");
INSERT INTO lyn_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kono emebo no kwiiba sebeli yaatambula nji, “Jesu ni muyii, ni Paulusi ni muyii, kono wene tiwe anyine?” ");
INSERT INTO lyn_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Cwale omulume woyo ona kwingeniwa ku mebo kwiiba sebeli waamatukela beulu ni kwaakoma, mane sebeli atunda ku ndoo eyo aali njeshe ni ku lemekiwa. ");
INSERT INTO lyn_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Cwale eyi yonje sebeli ilimukiwa kwaanu onje na mu Efese, aendisi no Majuda bamweya ni Magelike, mi sebeli aingenenwa okucila onje, mi elitina lya Mbumu Jesu sebeli lilumbiwa onene. ");
INSERT INTO lyn_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Aasikupumena no kupula kwaao ana kupumena sebeli aiya, mu kuukunyaza ni shongotola eyo no kwiiba ana kutendanga. ");
INSERT INTO lyn_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Cwale epalo nwao ana kutendanga amabibo sebeli alita etibuka too ni kuticin̄a aanu onje amwine, mi sebeli abala eteko no tibuka kame ina kwana eikiti makumi mutanu (50; 000) no muwaya-waya no silibela. ");
INSERT INTO lyn_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Cwale eliywi lya Mbumu sebeli liyanduluka ngeso ni kukula. ");
INSERT INTO lyn_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Cwale eyo aba ina kubwako, Paulusi sebeli olela mu muhupulo no mebo nji abite mu Mesodeniya ni Akaya ni kuta ku Jelusalema, yo aamba nji, “Munyima no kwikala kuya,” sebeli wamba nji, “Kame ni fanena okamona ku Loma.” ");
INSERT INTO lyn_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Cwale aba ana kumana otuma aiyetwa aye ayili mu Mesodoniya awo amutusa, Timoteya ni Elasito, yonyene yosili mu Asiya mbicani. ");
INSERT INTO lyn_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kusili mu nako eyo omufilifili no kuneneba sebeli wiiya mulibaka no Ndila. ");
INSERT INTO lyn_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kakuli omulume wisaniwa Demetiliusi, woyo ona kuumbanga endoo no silibela no milimu no Atemisi, kame ana kuluwisa onene abeleki no musebezi owo. ");
INSERT INTO lyn_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Cwale sebeli waawaneka bamweya, naawo anjili asebeza omusebezi kanyi woo, ni kwamba kwa onyene nji, “Alume, kame mulimukile nji aba mufuma ni mulibaka no musebezi ou. ");
INSERT INTO lyn_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Cwale kame mu mona ni kuyupa nji kasa mu Efese feela kono ni mu naha yonje no Asia Paulusi kame ana susuweze ni kukolwisa epalo no aanu, yo aamba nji, emilimu itendiwa ni maoko kasa emilimu. ");
INSERT INTO lyn_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ekozi eyo iiya, kasa nji omusebezi wetu mbau shwauka, kono ngeso ni ndoo no mulimu mukati otompeha oisniwa nji Atemisi kame saya liketwe kanyi esinu na mbulwa tuso, nji mane niku tompeha kwaye kame saku sinyehe, yonyene woyo olapelelwa mu Asiya ni mu litunga lyonje!” ");
INSERT INTO lyn_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Cwale aba ana kuyupa eyo, sebeli atina onene ni kukuwa nji, “Woyo no kuneneba ni Aetemisi no Maifese!” ");
INSERT INTO lyn_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Cwale omulenen̄i sebeli wiyala ni ku hakanyeha, mi sebeli aitukela bamweya mu teatele nikulema Gayusi ni Alisitako aanu na mu Mesodoniya awo ana ku sindeketanga Paulusi mu misipili. ");
INSERT INTO lyn_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulusi kame ana kusinganga oku monahaza kwaanu no kupula, kono aasikupumena kasi ku mulumelelanga. ");
INSERT INTO lyn_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Cwale ni manduna anjili na mu Esiya awo anokusinga naye, sebeli amutumena ni ku mukumbela nji alese okumonahaza ba patelo. ");
INSERT INTO lyn_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Cwale anjili sebeli akuwa sinu simweya, anjili sinjili kame, kakuli kame ana kuungana mu kuhakanyeha, mi ano kupula kasiku limuka eso ana kuunganena. ");
INSERT INTO lyn_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Anjili aanu mu nyangela sebeli atundisa Alekizanda, woyo aendisi no Majuda ana kubeeka kuuso. Cwale Alekizanda sebeli okobeta ni Lyoko nji akutambwele kwaanu. ");
INSERT INTO lyn_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kono aba ana ku lemuha nji neli Mujuda, mu tihola timbili sebeli akuwa onje mu liywi limweya nji, “Ounene ni wa Atemisi no Maifese!” ");
INSERT INTO lyn_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Cwale omun̄oli no Kuta no mulenen̄i sebeli ondota enyangela ni kwamba nji, “Aana no Efese!” anyine kwaanu no kwalimuka nji omulenen̄i no Efese omubabaleli no ndoo no mulimu no mukati no kutompeha Atemisi ni wa liwee no sitabelo no kukena sinakwi ku wilu? ");
INSERT INTO lyn_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Cwale mumone nji einu eyo kailatulwa, abakulingeso kame mulukela okondoka mi mulese okutenda esinjili mu wangu. ");
INSERT INTO lyn_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kakuli kame munaliti aa alume bano nji kasi sinya endoo no mulimu wetu no mukati simba nji asikunyefula emilimu yetu. ");
INSERT INTO lyn_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Cwale nji Demetiliyasi naabeleki ali kwa yonyene nji kame ali ni muzeko ni munu, etikuta kame tiyatulukile, kame kuli nasi kwatula, akutwale ku kuzeka. ");
INSERT INTO lyn_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kono nji kame kuli ni taba indina musaela, kame saiatulwe mu mukopano ofanena. ");
INSERT INTO lyn_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kakuli kame tuli mu utata no ku atulwa mu mufilifili balelo, kakuli katu kwite elibaka satwimane nalyo mulibakano mukopano owo. ");
INSERT INTO lyn_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Cwale aba ana kumana okwamba eyo, sebeli olukulula omukopano. ");
INSERT INTO lyn_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Cwale omufilifili aba una kubwa, Paulusi sebeli owaneka aiyetwa, okwaasusueza ni kwaalana, niku funduka okuta ku Mesodoniya. ");
INSERT INTO lyn_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Cwale aba ana kumana okumona enaha eyo, ni kwaasusuweza onene, sebeli ota mu naha no Magelike ");
INSERT INTO lyn_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Omo sebeli okaikalamo etikweti taatu, mi aendisi no Majuda sebeli amukundamena abo anokutukiseta okuta mu Siliya, sebeli onahana okuuka endila no Mesodoniya. ");
INSERT INTO lyn_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopatele naku Beliya omwana Pilasi sebeli oomu sindeketa, Alisitakasi ni Sekundasi Amatesalonika, ni Gayusi na ku Debe ni Timoteya, naa naku Asiya neli Tikikasi ni Tilofimasi. ");
INSERT INTO lyn_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Onyene kame anoku tangeta, sebeli aka twimanena mu Tulowasi. ");
INSERT INTO lyn_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kono aci sebeli tu tunda mu Filipi munyima no mukiti no Inkwa no mbulwa omumena, munyima no amaywaa mutanu, sebeli tu keela mu Tulowasi, omo sebeli twiikalamo amaywaa mutanu naayiili (7). ");
INSERT INTO lyn_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ba liywaa no weli mu sunda, abo me tukuwanine bamweya okulya esilyela, Paulusi sebeli wamba noo, kakuli kame na kufanena okufunduka amasiku eliywaa linaku tatamako, mi kame ana kwambola noo enako no kuleba mane konji bakaci no usiku. ");
INSERT INTO lyn_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kame kuna kwikala etilambi no kupula mu ndoo na kuwilu omo tu nakukuwanena. ");
INSERT INTO lyn_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Cwale ondumbana no litina lya Eutikasi kame ana kwikala mu lihaulo no ndoo, sebeli olangana otulo no kuneneba luli abo Paulusi yo twalelela okwambola ba nako no kuleba, yoli mu tulo, sebeli okwela banji okatunda ku ndoo na kuwilu no waatu. Sebeli ononiwa yo file. ");
INSERT INTO lyn_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Kono Paulusi sebeli oshetumukela banji ni kwinamena beulu yaye, ni ku mufumbatela yo aamba nji, “Olese kubilaela, kakuli omoyo waye osili mwa yonyene.” ");
INSERT INTO lyn_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Cwale Paulusi aba ana kukambama kame, sebeli okomauna esinkwa, aba ana kumana okulya, sebeli wambola noo enako no kuleba konji amasiku, sebeli ofunduka. ");
INSERT INTO lyn_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ondumbana sebeli amutwala ku mundi yo yoya, mi sebeliaombaombiwa mu micima onene luli. ");
INSERT INTO lyn_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Kono sebeli tuku tangeta ku sisepe, sebeli tukulongamo ni ku fuula okuta ku Asosi, omo kame tunaku singa okushimba Paulusi, yonyene kame ana kukutukiseta ngeso, kakuli yonyene kame ana kusaela okweenda ni makondo. ");
INSERT INTO lyn_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Cwale aba ana ku tuwana ku Asosi, sebeli tu mu longa, ni kuta naye ku Mitileni. ");
INSERT INTO lyn_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Aba tuna kufuulamo, eliywaa lina kutatamako sebeli tukeela ba mabapa ni Kiyosi, eli lina kutatamako kame sebeli tukakeela ku Samosi, elinjili kame eliywaa sebeli tukakeela ku Miletasi. ");
INSERT INTO lyn_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kakuli Paulusi kame ana kulela nji alese okufuweka mu Efese, nji cwale alese oku liyehela mu Esiya kakuli kame ano ku tukiseta okaikala mu Jelusalema nji kame kutwesahala, ba liywaa no Pentakota. ");
INSERT INTO lyn_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Paulusi yoli mu Miletasi, sebeli otumena ku Efese okaisana aakulu no keleke. ");
INSERT INTO lyn_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Cwale aba ana kukeela kwa yonyene, sebeli waambela nji, “Kame mulimukile omukwa nina yoyo mukaci kenu enako yonje okutunda ba liywaa no weli elyo nina kukeela mu Asiya. ");
INSERT INTO lyn_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Kame nina sebeleze Mbumu mu uku kokobeza konje ni mu myooti ni mu miliko ina kuniyela mu mifumbo no Majuda. ");
INSERT INTO lyn_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Omo ka nisi ukela munyima oku myambela esinu sonje eso sina ku fanena oku mitusa, ni ku miiyeta mu sicaba ni mu ndoo ni ndoo. ");
INSERT INTO lyn_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Menilemine okupakela aendisi no Majuda bamweya ni Mangelike kweeyi no kubaka kwa Nyambe neyi no tumelo mwa Mbumu wetu Jesu Kilesite. ");
INSERT INTO lyn_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Komumone cwale, kame nita ku Jelusalema, meni nungilwe mu mebo, mu kwalimuka eyo saika tendahaleko kwa mene. ");
INSERT INTO lyn_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Esi ni limukile ninji mu mulenen̄i ni mulenen̄i Emebo No Kukena kame ina kuni pakela nji okunungiwa ni ku yandisiwa kame initatelele. ");
INSERT INTO lyn_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kono kani bilaele eyo, mi kanibalele omoyo wange nji niwautokwa kwa mene, esi nisinga feela ninji ni manenene omusipili ni musebezi wange ananibi Ombumu Jesu, no kupaka eliywaa no sishemo sa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Cwale komumone, kame ni limukile nji aanyi monje awo inendele emisipili okumikutaza eyi no mubuso wa Nyambe kamutamba okumona olubala lwange kame. ");
INSERT INTO lyn_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Cwalehe kame ni myambela eniti balelo nji, kani kwite omubonda no unyinga wenu moonje. ");
INSERT INTO lyn_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kakuli kani siuka munyima mu kumitaluseta omulelo wonje wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Cwale aanyi muku babalele, mi mu lise omutapi mu nabiwi oku ubabalela mu Mebo No Kukena oku babalela Endoo ya Nyambe ya Nyambe eyo ana kuulele ni unyinga wa Mwanaye. ");
INSERT INTO lyn_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Kakuli kame ni limukile nji aba sani misiye, kame sakwiiye aandiwi no kucilisa mukaci kenu, awo saulwe okuyupela omutapi amakeke. ");
INSERT INTO lyn_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Cwale mukaci kenu luli kame sakutunde alume asaambe einu no mapwa nji aiyetwa aakon̄e. ");
INSERT INTO lyn_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Cwalehe mutokomele, muhupule nji mu myaka yaatu kani lesele okweleza ni myooti ousiku ni munji ku munu ni munu. ");
INSERT INTO lyn_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Cwalehe bano kame ni mibeeka kwa Nyambe ni ku liywi no sishemo saye, elyo saali miyake ni kumiba esanda naa akenine onje. ");
INSERT INTO lyn_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Kanisi lakaza esilibela ni gauda ya munu simba esibyana. ");
INSERT INTO lyn_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Aanyi mwenyine kame muyii omo ina belekele ni maoko ange okuwana omu no kuyoyela mane nawo ana kwikalanga nange. ");
INSERT INTO lyn_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mu inu yonje kame nina mi monisa nji mu sebeze ngeso, kame mu fanena okutusa asiku fokola, me muhupula amaywi ana kwamba Jesu nji, ‘Embuyoti kame ili onene mu kuba kasa muku tambula.’” ");
INSERT INTO lyn_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Cwale aba ana kumana okwamba ngeso, sebeli okubama ni manwi banji ni kulapela noo onje. ");
INSERT INTO lyn_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Cwale onje sebeli alila niku kwela mu mbando ya Paulusi ni kumutubeta. ");
INSERT INTO lyn_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kame ana kutomoha onene emicima onje mulibaka no maywi aye ana kwamba nji kaatamba kumona kame olubala lwaye. Cwale sebeli amusindeketa okamukeeta ku sisepe. ");
INSERT INTO lyn_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Cwale aba tuna mana oukutaba noo mu ku bambaba feela, sebeli tufuula, mi sebeli tulumba ku Kosi, mi liywaa linakutatamako sebeli tukeela mu Lodesi, okutunda omo sebeli tuta ku Patala. ");
INSERT INTO lyn_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Cwale aba tuna kuwana esisepe silumbile ku Foenisiya, sebeli tukulongamo ni kuta. ");
INSERT INTO lyn_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Cwale aba tuna keela mu sibaka no Sipulasi, sebeli tusi yupela ku simoo okuta mu Silia, sebeli tuka fuweka mu Tile, kakuli omo esisepe kame sina kulongola etutu. ");
INSERT INTO lyn_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Cwale sebeli tuwanamo aiyetwa, ni kwiikala noo amaywaa mutanu ni twiili (7). Mu mebo sebeli aambela Paulusi nji alese okuta ku Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Cwale amaywaa etu aba ana kubwa, sebeli tu funduka okwekeza omusipili wetu ni kutu sindeketa onje, naa moyo oo naanoo, ni ku tulita konji aba ana kutu siisa omulenen̄i, sebeli tu kubama ni manwi ba likamba okulapela ni ku kulana omnjili ni munjili okuwaba. ");
INSERT INTO lyn_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Cwale sebeli tukulonga mu sisepe, onyene sebeli aukela ku mundi. ");
INSERT INTO lyn_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Cwale aba tuna kumana omusipil wetu okutunda mu Tile, sebeli tuta ku Tolemaisi ni kukeeta aasikupumena ni kwiikala noo eliywaa limweya. ");
INSERT INTO lyn_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Eliywaa lina ku tatamako sebeli tu funduka nuukakeela mu Sesaaliya, mi sebeli twiingena mu ndoo ya Filipi omwaambi no mikopano, woyo ona kutenda omunjili noao mutanu ni twiili (7) ni kwikala kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Kame ana kwikala naanaye anee nwa sizana no kwaakwaliwa, ana ku nuhanga. ");
INSERT INTO lyn_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Aba tuna kwikalamo amaywaa mbicana, sebeli kwiiya omunuhi no litina lya Agabusi ona ku tunda ku Judeya. ");
INSERT INTO lyn_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Cwale aba ana kukeela kwaaci, sebeli okununga olukanda lwa Paulusi ku maoko ni ku makondoo ni kwamba nji, “Eesi, so kame esinaambiwa ku Mebo No Kukena nji, aendisi no Majuda mu Jelusalema mwasanungele omunya lukanda olu, ni ku mubeeka mu maata ano macaba.” ");
INSERT INTO lyn_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Cwale aba tuna kuyupa ngeso, aaci naanu sebeli tu mukumbela nji alese okukambama okuta ku Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Cwale Paulusi sebeli otambula nji, “Iikene aba mulila ni kucola omucima wange? Kakuli mene kame ni kutukisite kasa okwingena mu tolongo feela, kono simba okufa ku Jelusalema mulibaka no litina lya Mbumu Jesu.” ");
INSERT INTO lyn_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Sebeli okana okukolwisiwa kwaaci, sebeli toondoka ni kwamba nji, “Ku tendahale eso sisingwa kwa Mbumu.” ");
INSERT INTO lyn_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Munyima no maywaa ao, sebeli tuku tukiseta okuta ku Jelusalema. ");
INSERT INTO lyn_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Cwale naiyetwa anjili ana ku tunda ku Sesaaliya sebeli ata naaci, oku tutwala ku ndoo ya Nasoni, omwiyetwa no kale na ku Sipulasi, oko tuna ku fanena okwikala. ");
INSERT INTO lyn_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Cwale aba tuna ku keela mu Jelusalema, aasikupumena sebeli atu tambula wino mu ku wabelelwa. ");
INSERT INTO lyn_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Eliywaa lina ku tatamako Paulusi ota naaci kwa Jakobo, mi onje akulu sebeli aikalako. ");
INSERT INTO lyn_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Munyima no kwakeeta, sebeli otalusa wino einu eyo Nyambe ana tende kwaasimacaba mu musebezi waye. ");
INSERT INTO lyn_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Cwale aba ana kuyupa eyo, sebeli akanyisa Nyambe. Mi sebeli aamba kwa yonyene nji, “Omwabetu, esi omwine nji, aendisi no Majuda aa ana lumele sebeli eikiti no kupula, mi aanu onje kame atukufalelwe omulawo. ");
INSERT INTO lyn_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Kame anaambelwe eyowe nji wene kame wiyeta aendisi no Majuda onje awo ayoya mwano asimacaba nji afulalele Mushe, okwaambela nji alese okutwala anoo ku mupato simba okukuteka eizo yoo. ");
INSERT INTO lyn_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Cwale ngasibine saitendahale? Kame saayupe nji nwiyi. ");
INSERT INTO lyn_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Otenda eyo tukwambela. Kame tukwite alume anee awo ali munji no sepiso noutokwa. ");
INSERT INTO lyn_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Waashimbe aa alume okakukenise noo, mi waatenekele nji cwale aka beulise emitwi yoo. Cwale aanu onje kame saalimuke nji kakwisa esinjili eso ana yupu kweyo inambiwa mulibaka lyowe kono nji ni wene kame oyoya mu ku tokomela omulawo wa Mushe. ");
INSERT INTO lyn_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kono kweeyo no asimacaba ana lumele, kame tunaatumene elin̄olo no mulelo wetu nji kame afanena okukana kweeyo ina tendelwe emilimi, ni ku unyinga, ni kweyo ina owiwa, ni uhule. ");
INSERT INTO lyn_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Cwale Paulusi sebeli oshimba aalume awo, mi ba liywaa linaku tatamako sebeli okukenisa noo ni kwingena mu ndoo ya Nyambe, okwamba amaywaa no kukenisa koo aba saiyatetetwe ni nubu nai kubiwa eyi no munu ni munu woo. ");
INSERT INTO lyn_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Cwale amaywaa mutanu naayili aba ana kwatumela okubwa, aendisi no Majuda na ku Esiya awo ana kumumona mu ndoo ya Nyambe, sebeli asusuweza enyangela ina kukuwana mu kupula, ni ku mulema. ");
INSERT INTO lyn_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Cwale sebeli akuwa nji, “Alume no Isilaele, komutuse! Uno yokame omutu ona kwiiyetanga aanu onje mu ibaka yonje okulwisa aanu ni mulawo ni sibaka sino, abakulingeso osilita kame Amagelike mu ndoo ya Nyambe, mi na silafaza esibaka sino no kukena. ");
INSERT INTO lyn_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kakuli kame ana kumumona oweli yo enda ni Tolofimo Omwiifese mu mulenen̄i, mi sebeli anahana nji Paulusi mwendi namu liti mu ndoo ya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Cwale omulenen̄i onje sebeli oimana amaefe-efe, mi aanu sebeli aituka ba bamweya, okalema Paulusi ni ku mukoka okumutundisa mu ndoo ya Nyambe mi ababo emyelo sebeli iyatiliwa. ");
INSERT INTO lyn_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Cwale aba ana kweteka nji amwibaye, eliywi sebeli liiya ku mwendisi no masole no Maloma nji Jelusalema yonje naimana ni mufilifili. ");
INSERT INTO lyn_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mu nako imweya sebeli oshimba amasole na shebuluki oo, ni kwiitukela kwa onyene, cwale aba anakumona omwendisi ni masole, sebeli alesela okumufula. ");
INSERT INTO lyn_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Cwale omwendisi sebeli osheteta ni kulema Paulusi, ni ku laela nji anungiwe ni mawenge ayili. okubinda aibangute eyaye, nji yokame anyine, neeyo ana tende. ");
INSERT INTO lyn_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Anjili mu nyangela sebeli akuweleza sinu simweya, anjili sindina, mi sebeli okwangwa okulimukabo eniti mulibaka no lilata, sebeli nji Paulusi atwaliwe mu ndoo no kongola. ");
INSERT INTO lyn_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Cwale aba ana kukeela ba matulameno, konji oku shimbiwa ku Masole mulibaka no kutweba no nyangela. ");
INSERT INTO lyn_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kakuli okupula nwaanu kame ana ku mukon̄anga, akuweleza nji, “Aibaiwe!” ");
INSERT INTO lyn_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Paulusi yoli beebi ni kwingenyekwa mu ndoo no kongola, sebeli wamba ku mwendisi no masole nji, “Kame ni kumbela okwamba nowe?” Woyo sebeli omwibanguta nji, “Kame olimukile okwamba Esigelike?” ");
INSERT INTO lyn_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kana kasa wene Omwengepita, uya, ona liti omufilifili mu maywaa aya anabu ni kwetelela aibai alume ana ku kwana eikiti inee (4;000) okuta noo mu lihalaupa?” ");
INSERT INTO lyn_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulusi sebeli otambula nji, “Mene kame nili Omujuda, okutundelela ku Tasusi mu Silisia, omulenen̄i noutokwa, Kame ni kumbela kwa wene nji naambe kwaanu.” ");
INSERT INTO lyn_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Cwale aba ana ku mulumelela, sebeli oimana aba noku tinena, mi sebeli okobeta aanu ni Lyoko, cwale aba kuna kondoka onene tuu, sebeli wamba noo mu puo no Sihebelu nji, ");
INSERT INTO lyn_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Abaange naa sitange, muyupe aba ni kutambwela balubala wenu!” ");
INSERT INTO lyn_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Cwale aba ana kuyupa nji kame aambela mu puo no Mahehelu sebeli aondoka onene luli, mi sebeli wamba nji, ");
INSERT INTO lyn_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Kame nili Omujuda, ona leyeliwa ku Tasusi mu Silisiya, kono kame nina kulele omuno mu mulenen̄i ku makondo a Gamaliele, mi kame nina iyetiwa no kupetahala okuta mu mukwa nwaa njekulyetu, ni kutukufalelwa eyi no Nyambe, kanyi omo mwiikalele balelo naanyi. ");
INSERT INTO lyn_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Kame nina lwisi onene Endila eyo mane oku twala ku lifu, kame nina kununganga alume bamweya naakati okwaa ingenyeka mu tolongo. ");
INSERT INTO lyn_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Omupulisita mukulu ni kuta no akulu onje kame ani paka. kame nina ku shimba aman̄olo okutunda kwaa onyene okutwala kwaabange, mi sebeli ni funduka okuta ku Damaseka nuukashimbamo aawo ana kwikalangamo ni kwaalita mu tololongo mu Jelusalema nji abiwe ekoto. ");
INSERT INTO lyn_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Cwale abo meni lemine okweenda nji nishetete kunyonga ni Damaseka, omunji ba 12 okolokoluli olumonyi no kuneneba luna kutuda ku wilu ababo sebeli lunifuka. ");
INSERT INTO lyn_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Cwale sebeli nikwela banji ni kuyupa eliywi lyaamba kwa mene nji, ‘Suaule, Saule! Iikene oni yandiseta?’ ");
INSERT INTO lyn_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Sebeli ni tambula nji, ‘Tiwe anyine, Mbumu?’ Cwale sebeli oni tambula nji, ‘Time Jesu no Nazaleta, woyo o yandisa.’ ");
INSERT INTO lyn_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Cwale awo nina kwikala noo kame ana kumona olumonyi kono kasi kuyupa eliywi lya woyo ona kwamba kwa mene. ");
INSERT INTO lyn_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Cwale sebeli naamba nji, ‘Iikene nifanena okutenda, Mbumu?’ Mi Ombumu sebeli onambela nji, ‘Oimane, mi ote mu Damaseka, cwale omo kame soka ambelwe yonje eyo ofanena okutenda.’ ");
INSERT INTO lyn_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kakuli cwale kanisiku mona mulibakano kanya no lumonyi olo, kame nina kulemiwa ku Lyoko kwaao nina kweenda nooo okwingena mu Damaseka. ");
INSERT INTO lyn_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ananiasi, omulume onaku kubeeka kwa Nyambe okuta mu mukwa no mulawo, woyo opakwa kwaanu onje awo ayoyamo. ");
INSERT INTO lyn_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Cwale sebeli oiya kwa mene, ni kwiimana kunyonga yange, ni kwamba nji, ‘Saule minange, obiwe okumona kame!’ Mi mu nako eyeyo, sebeli ni mona ni ku mwaliketa. ");
INSERT INTO lyn_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Cwale ni kwamba nji, Nyambe nwaa njekulyetu nakukete nji olimuke eso asaela, okumona woyo no kuluka ni kuyupa ku liywi litunda mu kanwa kaye. ");
INSERT INTO lyn_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kakuli kame sotende opaki waye kwaanu onje kweeyo ona mono ni kuyupa. ");
INSERT INTO lyn_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Cwale bano siikene osi tatelele? Oimane mi okolobezwe, mi oyowisiwe ku ibi yowe, wisane ba litina lyaye.’ ");
INSERT INTO lyn_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Aba nina kumana okuukela ku Jelusalema ababo meni lapela mu ndoo ya Nyambe, sebeli ni mona epono, ");
INSERT INTO lyn_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ni ku mona Ombumu yo aamba kwa mene nji, ‘Olelube mi muwangu otunde mu Jelusalema, kakuli katamba ku tambula oupaki so ni pake.’ ");
INSERT INTO lyn_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Cwale sebeli ni tambula nji, ‘Kame alimukile nji time nina kwiingenyekanga mu tolongo mu ndoo ni ndoo no milapelo ni kufulanga awo ana kupumenanga kwa wene. ");
INSERT INTO lyn_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Cwale ababo ounyinga wa Setefani opaki wowe aba ona kwiiteka, kame nina kwikalako, ni kupumena okwiibaiwa kwaye, ni kubabalela eikumango ya awo ana ku mwiibaa.’ ");
INSERT INTO lyn_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Cwale sebeli wamba kwa mene nji, ‘Ote, kakuli kame sani kutume oku no kuleba kwaasimacaba.’ ” ");
INSERT INTO lyn_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Sebeli amuteeteta okutwala abo ana kwambela eliywi elyo, ababo sebeli atangisa okukuwa ni liywi lili beulu nji, “Omunu nongeso mu mutundise mu litunga, kafanene okuyoya!” ");
INSERT INTO lyn_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Sebeli akuwa ni kututula eikumango yoo ni ku tunyisa eliluli mu wilu. ");
INSERT INTO lyn_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Omwendisi no masole sebeli olaela nji alitiwe mu ndoo no kongola, nji aka mwibangute yo fuliwa nji alimuke eso amukuwela. ");
INSERT INTO lyn_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kono aba ana kumana okumununga ni mihala no itumba, Paulusi sebeli oibanguta omwendisi ona kwimananga ba nyonga nji, “Kana nitukelo okufula omunu no Muloma, yo kasi atuliwa kale?” ");
INSERT INTO lyn_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Cwale onduna aba ana kuyupa ngeso, sebeli ota ku mweendisi no masole ni kwamba kwa onyene nji, “Siikene eso osinga okutenda? Kakuli omunu uyu ni Muloma!” ");
INSERT INTO lyn_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Cwale omwendisi no masole sebeli wiiya kwa Paulusi ni kumwibanguta nji, “Onambele, niti luli kame oleilwe ku Maloma?” Paulusi sebeli otambula nji, “Ee.” ");
INSERT INTO lyn_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Omwendisi no masole sebeli otambula nji, “Kame nina teneke amali no kupula nji nu kuulele etukelo eyo.” Paulusi sebeli otambula nji, “Kono mene ni mu kuleiwa.” ");
INSERT INTO lyn_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Cwale awo ana ku singa oku mufula sebeli amusiya ababo, omwendisi no masole ni yonyene sebeli ocila aba ana kuyupa nji Muloma, kakuli kame ana ku mununga. ");
INSERT INTO lyn_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kono eliywaa aba lina kupa, mu kusinga oku limuka elibaka no niti eyo amuzekiseta aendisi no Majuda, omwendisi no masole sebeli onungutula Paulusi, ni ku laelela apulisita akulu naa sikuta onje nji akuwane, sebeli ota ni Paulusi ni ku mubeeka balubala woo. ");
INSERT INTO lyn_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulusi yo alikete onene asi Kuta no Majuda sebeli wamba nji, “Abaange, kame ninaende ni lizwalo no kuwaba koonje balubala wa Nyambe, okulita ba liywaa no balelo lino.” ");
INSERT INTO lyn_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Cwale Ananiyasi omupulisita mukulu sebeli olaela awo ana kwimananga kunyonga yaye nji amupobole ba kanwa, ");
INSERT INTO lyn_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Cwale Paulusi sebeli wamba kwa onyene nji, “Nyambe mba ku pobola, wene elimota libasizwe elikena! Kandi aba oikalile bano ni ku naatula okuta mu mulawo, kandi aba olaela nji nipoboliwe, kame ocola omulawo!” ");
INSERT INTO lyn_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Awo ana kwimananga ku nyonga yaye, sebeli aamba nji, “Weene kame okuta omupulisita mukulu wa Nyambe?” ");
INSERT INTO lyn_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulusi sebeli otambula nji, “Abaange, kanisi limuka nji mupulisita mukulu kakuli kame ku n̄olilwe nji, ‘Olese okwamba eyi no kwiiba ku mwendisi no aanu owe.’ ” ");
INSERT INTO lyn_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Cwale Paulusi mu kulimuka nji anjili neli Asaduki mi anjili neli Afalisi, sebeli okuwa mu Kuta nji, “Abaange, mene kame nili omufalisi, o mwana no mufalisi, kame naatulwa mulibakano kwinguka nwaafu kame nili mu muliko!” ");
INSERT INTO lyn_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Cwale aba ana kumana okwamba eyo, omufilifili sebeli winguka mukaci no Afalisi naa Saduki, mi esikwata sebeli sikutaba bakaci. ");
INSERT INTO lyn_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kakuli Asaduki kame aamba nji kakwisa okwinguka kwaafu, simba elin̄eloi, simba Emebo, kono Afalisi kame apumena eyo yonje. ");
INSERT INTO lyn_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Cwale sebeli kwinguka elilata no kuneneba luli, mi anjili aiyeti no mualao aa aimanena Afalisi, sebeli aimana ni kwamba nji, “Ka tusiwana esi sifosahalile kwa yonyene uyu mulume! Mwendi ni mebo simba elin̄eloi yaamba mwa yonyene!” ");
INSERT INTO lyn_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Cwale Omufilifii aba onaku ekezeha, omwendisi no masole sebeli ocila nji Paulusi mba kaolwa mu ibindi kwa onyene, ni ku laela amasole okushetumuka okashimba Paulusi mukaci koo ni ku mulita mu ndoo no kongola. ");
INSERT INTO lyn_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ousiku ona kutatamako Ombumu sebeli oimana kunyonga yaye ni kwamba nji, “Olese kucila, kakuli kanyi aba ona paka eyange mu Jelusalema, cwale ni mu Loma kame ofanena okanipaka ngeso.” ");
INSERT INTO lyn_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Cwale eliywaa aba lina kupa, Amjuda anjili sebeli akuwana okulela ni kweeta nji katamba kulya simba okunwa konji aba saibae Paulusi. ");
INSERT INTO lyn_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Awo ana ku tenda omulelo owo, neli aanu ana kubitelela makumi anee. ");
INSERT INTO lyn_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Cwale sebeli ata kwa mupulisita omukulu ni kwaakulu, ni kwamba nji, “Kame tuna kunungu oluci nji ka tutamba kulya esinjili konji aba satwiibae Paulusi oweli. ");
INSERT INTO lyn_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Abakulingeso, anyi naasi Kuta mu simwete omwendisi no masole amulite kwaanyi, mi munise kanyi kame musinga okusaisisa etitaba taye. “Cwale aci kame tukutukisite oku mwibaa yo kasikeela kale kwaanyi.” ");
INSERT INTO lyn_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kono omwana mandaye Paulusi no mushimani aba ana kuyupa emifumbo yoo, sebeli ota mu ndoo no kongola okasimweta Paulusi. ");
INSERT INTO lyn_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Cwale Paulusi sebeli oisana omunjili no abaleki ni kwamba nji, “Otwale uyu ndumbana ku mwendisi no masole, kakuli kame ali nesi asaela okumwambela.” ");
INSERT INTO lyn_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Cwale sebeli omushimba ni kumutwala ku mwendisi no masole ni kwamba nji, “Paulusi omupantiti kame anani isana ni kuni kumbela nji nilite uyu ndumbana kwa wene, kakuli kame kuli eso asaela okwamba kwa wene.” ");
INSERT INTO lyn_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Omwendisi no masole sebeli omulema ku Lyoko, ni kuta naye ku nyonga ni ku mwibanguta nji, “Siikene eso osaela oku naambela?” ");
INSERT INTO lyn_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Cwale sebeli wamba nji, “aendisi no Majuda kame ana kuyupu nji aku kumbele nji byuunda waalitele Paulusi ku Kuta yoo, atende kanyi kame asaele okusaisisa etaba yaye. ");
INSERT INTO lyn_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kono olese okwaa lumelela, kakuli alume no kubitelela amakumi anee awo ana mukundamene, kame akunungile oluci nji katamba okulya simba oku nwa esinjili koonji aba sa ibae Paulusi oweli. Cwale kame aku tukisite, ni kutatelela esepiso okutunda kwa wene.” ");
INSERT INTO lyn_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Cwale omwendisi no masole sebeli ousa ondumbana, ni ku mulaela nji, “Olese okwambela omunu nji nunambele etaba eyi.” ");
INSERT INTO lyn_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Cwale sebeli oisana aendisi ayiili no masole ni kwamba nji, “Ba nako no 9 okoloko (21) ousiku mu kutukisete mu shimbe amasole akwana emyanda yiili (200) ni timbii makumi mutanu naayili, (70) naalume akwana emyanda yiili (200) asikulwisa etimbi nji ate ku Sesaaliya. ");
INSERT INTO lyn_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mulukise ni tipeleswa eto sa titiniwe kwa Paulusi, mi mumutwale wino kwa Felikisi omubusisi.” ");
INSERT INTO lyn_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Cwale sebeli on̄ola elin̄olo eli lyaamba nji, ");
INSERT INTO lyn_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Mene Kilaudiyasi Lisiyasi kwa Felikisi, omubusisi okutekiwa onene, mulumele. ");
INSERT INTO lyn_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Omunu woyo kame ana kulemiwa ku Majuda, mi kame ana ku singa oku mwibaa, cwale mukuyupa nji ni muloma sebeli niiya ni masole oku muyoyisa. ");
INSERT INTO lyn_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Cwale mu kusinga nji ni limuke eyo amulwiseta, sebeli ni mutwala ku Kuta yoo. ");
INSERT INTO lyn_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Omo sebeli ni wana nji kame amu zekisa mu yambo no mulawo woo, kono kakwisa omubonda owo ofanena elifu simba okunungiwa. ");
INSERT INTO lyn_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Cwale aba nina kumana okuyupa nji munu woyo kame ana kundamenwa, ababo sebeli ni mutumena kwa wene, mi kame nina laelele awo amuzekisa nji eyo amuzekiseta ailite kwa wene .” ");
INSERT INTO lyn_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Cwale amasole, sebeli atenda omo ana laelelwe, okushimba Paulusi ni kumulita ousiku ku Antipatilisi. ");
INSERT INTO lyn_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Cwale eliywaa aba lina kupa sebeli aukela ku ndoo no kongola, okusiya asikutina etimbii aata ni Paulusi. ");
INSERT INTO lyn_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Cwale aba anaku keela mu Sesaaliya, sebeli aba omubusisi elin̄olo, mane niku lita Paulusi kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Omubusisi aba ana kumana okubala elin̄olo, sebeli oibanguta Paulusi nji kame atunda ku tolopo ibine. Cwale aba ana kuyupa nji kame atunda mu Silisiya, ");
INSERT INTO lyn_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","sebeli wamba nji, “Kame sani yupe eyowe aba sakeele awo akuzekisa.” Cwale sebeli olaela nji atatelelwe mu ndoo ya Heloda. ");
INSERT INTO lyn_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Munyima no maywaa mutanu omupulisita mukulu Ananiyasi sebeli oiya nakulu anjili nimutalusi wisanwa Tetulusi. Mi sebeli akumonahaza kwa mubusisi oku talusa eyi ya Paulusi. ");
INSERT INTO lyn_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Cwale aba ana ku mwiisana, Tetulusi sebeli otangisa oku muhapeleza okwamba nji, “Aba tu yoya mu kozo no kuneneba ni mwa wene, mu kubiwa kwetu kwa wene, wene Felekisi no kukutekeha, einu no kupula kame itandahala mwa wene muno mu litunga. ");
INSERT INTO lyn_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Mundila yonje ni kubine konje kame twiitambula mu witumelo no kuneneba. ");
INSERT INTO lyn_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kono nji nilese oku sinyeza enako, kame niku kumbela mu sishemo sowe otutetete kweyo tu kwambela. ");
INSERT INTO lyn_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kakuli kame tu nawana woyo mulume nji mususwezi omunya tiputeho no Majuda onje mu litunga lyonje, yokame omutwi no tuto no kukeluha no Anazaleta. ");
INSERT INTO lyn_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kame ana eteke mane okusilafaza Endoo ya Nyambe, kono natu muleme. ");
INSERT INTO lyn_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Kono omwendisi no masole Lisiasi, sebeli okeela ni ku mushimba mu maata no kuneneba, okutu byangulaye. ");
INSERT INTO lyn_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Mu ku mwibanguta mwenyene mba mulimuka okutundelela mwa yonyene einu yonje eyo tu munyaza.” ");
INSERT INTO lyn_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","aendisi no Majuda noyonyene sebeli apumena nji eyo amunyaza ni yaniti. ");
INSERT INTO lyn_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Cwale omubusisi aba ana kwamba kwa yonyene, Paulusi sebeli otambula nji, “Mu ku limuka nji mu myaka no kupula kame ona tende omwatuli no litunga eli, kame ni wabelelwe okuba oupaki wange. ");
INSERT INTO lyn_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kanyi omo olimukele nji kakusibita amaywaa likumi naayiili aba nino katunda ku Jelusalema mu kulaapela. ");
INSERT INTO lyn_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Kono kasikuniwana meni kanana naanu simba okususweza esicaba, simba mu keleke, simba mu tindoo no milapelo, simba mu mulenen̄i. ");
INSERT INTO lyn_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Simba mane okulita kwa wene esisupo kweeyo aamba eyange. ");
INSERT INTO lyn_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kono kweeyi kame ni pumena kwa wene, nji okukumanena ni Ndila eyo aisaniwa kunyefula, kame ni lapela Nyambe no asitetu ni kupumena einu onje eyo ina lyatisiwa mu mualao simba eyi ina n̄oliwa kwaanuhi a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mulibaka nokwikala ni sepo kwa Nyambe neyo nonyene apumena, nji okwinguka kwao no kuluka nawo nakwaluka, ");
INSERT INTO lyn_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","mi cwale kame netekanga onene nji ni ikale ni lizwalo kuneku la Nyambe ni aanu. ");
INSERT INTO lyn_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Aba kuna kubita emyaka sebli ni lita etituso ni timpo ku Jelusalema kwaanu no kusheba. ");
INSERT INTO lyn_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Meni lemine okutenda eyi, sebeli aniwana me kenine mu Ndoo ya Nyambe, okuulwile esicaba ni mifilifili. Kono aendisi no Majuda anjili ana kutunda ku Esiya ");
INSERT INTO lyn_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","kame afanena okukeela kwaanyi nji kame anyaza nji kame kuli esinjili eso nina foso. ");
INSERT INTO lyn_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Abakulingeso mu lesele aa alume onyene aambe eso nina kufosa aba nina kwimana balubala no Kuta, ");
INSERT INTO lyn_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","konji esinu simweya eso nina kwamba meni imanine mukaci koo, ‘Ni ku kuteka okwinguka nwaafu eyo ni zekisiwa mu liywaa no balelo lino.’ ” ");
INSERT INTO lyn_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Kono Felekisi woyo ona kulimuka wino Endila, sebeli wamba kwa onyene nji, “Aba sa keele Lisiyasi omendisi, okubinda sani nahane etaba yenu.” ");
INSERT INTO lyn_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Cwale sebeli oba etaelo ku mwendisi no masole nji iakale mu kutateleliwa nji mu kulukuluha mi aalikani aye abiwe ekolo no kumulitela eyo asela. ");
INSERT INTO lyn_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Munyima no maywaa, Felekisi sebeli oiya ni moyo waye Dulusila ona kutenda Omujuda, mi sebeli otumena Paulusi ni kuyupa yo aamba mu tumelo mwa Jesu Kilesite. ");
INSERT INTO lyn_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Yo lemine okwambola eyi no niti neyi no kuluka ni nuukulema mane ni katulo na kuuso, Felekisi yonyene sebeli ocila ni kwamba nji, “Ba nakon ino ote oweli. Cwale aba sani wane esibaka mba ni kwiisana.” ");
INSERT INTO lyn_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ba nako imweya sebeli ohupula nji kame sabiwe amali kwa Paulusi. Cwale sebeli omutumena aka no kupula nikamba kwayonyena. ");
INSERT INTO lyn_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kono aba ina kubwa eilimo yiili, Felekisi kame ana kuyoliwa kwa Polosiusi Festusi, ni ku laekaza okutenda aendisi no Majuda ouwa, Felekisi sebeli osiya Paulusi mu tolongo. ");
INSERT INTO lyn_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Cwale Fesitasi aba ana keela aye, munyima no aywaa aatu, sebeli okambamena ku Jelusalema okutunda mu Sesaliya. ");
INSERT INTO lyn_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Omupulisita mukulu naakulu no majuda sebeli akumonahaza kwa yonyene, mi sebeli abiha kwayonyene okukumanena neya Paulusi. ");
INSERT INTO lyn_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","mi sebeli akumbela nji atende mukwaawabelisa nji aatumene Paulusi ku Jelusalema, okulela okumu kundamena nji amwibae ba ndila. ");
INSERT INTO lyn_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fesitusi sebeli otambula nji, Paulusi kame ali mu Sesaaliya, ni kwamba nji ni yonyene okutwa atemo abano. ");
INSERT INTO lyn_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Cwale sebeli waamaba nji, “Mu lusele alume aali ni tukelo mukaci kenu ashetumuke ni mene, mi nji kame kuli eso sina fosahala mwa yonyene, aiye mukumuhapeleza.” ");
INSERT INTO lyn_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Cwale aba ana ku mana okwikala noo mu maywaa no kwaakwana mutanu ni twaatu simba likumi, sebeli oukela ku Sesaaliya. Ba liywaa lina kutatamako sebeli oikala ba situlo no katulo, mi sebeli olaelela nji Pulusi alitiwe. ");
INSERT INTO lyn_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Cwale aba ana kwiiya, aendisi no Majuda ana kutunda ku Jelusalema sebeli amubeeka mukaci, ni ku hapeleza emibonda no kupula eyo akwangwa okulita oupaki wayo. ");
INSERT INTO lyn_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulusi yonyene sebeli okutambwela nji, “Kanisifoseza omulawo no Majuda, simba Endoo ya Nyambe, simbsa Sesale kanisi mufoseza simba kanyonyo.” ");
INSERT INTO lyn_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Kono Fesitusi muku singa oku wabeliswa aendisi no Majuda, sebeli wamba kwa Paulusi nji, “Ninji kame osaela okuta ku Jelusalema, mi omo oka atulwemo eyambo eto balubala wange?” ");
INSERT INTO lyn_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Kono Paulusi sebeli wamba nji, “Kame niimanine balubala no Kuta ya Sesale, moni lukela okwatulwela, Ku Majuda kanisifoza simba simyeya, kanyi omo olimukele wino ni wene. ");
INSERT INTO lyn_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nji cwale kame nina matuka omulawo, nikutenda esinjili eso sifanena elifu, sikana okufa, kono nji kakwisa eniti mu yambo eyo aninungelela, kakwisa woyo sonibeeka mu maata oo. Kame niku lilelela kwa Sesale.” ");
INSERT INTO lyn_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Cwale Festusi aba ana ku kwaambota nasikuta yaye, sebeli otambula nji, “Kame ona bilaelele kwa Sesale, kame soote kwa Sesale.” ");
INSERT INTO lyn_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Cwale munyima no maywaa acana aba ana kubwa, Aglipa ombumu ni Belunice sebeli akeela mu Sesaaliya mu kutambula Felstusi. ");
INSERT INTO lyn_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Cwale aba ana kwikalamo amaywaa no kupula, Festusi sebeli wambela Ombumu eyambo ta Paulusi nji, “Kuno kame kuli omulume ona siiwa mu tolongo kwa Felekisi. ");
INSERT INTO lyn_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Aba nina kwikala ku Jelusalema, apulisita akulu naakulu no Majuda kame ana kwiiya kwa mene mukuni simweta eyambo ya Paulusi, ni kukumbela nji aatulelwe elifu. ");
INSERT INTO lyn_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kono sebeli naatambula nji kasa tukelo no sizo no Maloma okulumelela okwatuliwa abo omuzeki ni muzekisi kaasikuwana kale olubala ni lubala mane ni kubiwa okolo noukutambwela mu yambo yaye eyo amuzekisa. ");
INSERT INTO lyn_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Cwalehe abo aneeyi bamweya kuno, kanasiku liyeha, kono eliywaa linakutatamako sebeli niikala ba situlo no katulo ni ku laela nji alitiwe balubala no Kuta. ");
INSERT INTO lyn_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Cwale azekisi aye aba ana kwiimana, kasaamba esinjili no mibonda yaye eyo ana ku mununga, kanyi eyo nina kutatelela nji niiyupe. ");
INSERT INTO lyn_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Kono kame ana kwikala ni ngambolo naye eyi no tumelo yoo neyi no munjili woyo wiisaniwa nji Jesu, woyo ona kufa, kono Paulusi kame aongota nji kame ayoya. ");
INSERT INTO lyn_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mulibaka no kuziyeleha mu yambo no ngeso, sebeli ni mwibanguta nji kautwese okuta ku Jelusalema nji okaatulelweko etaba eyi. ");
INSERT INTO lyn_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kono cwale Paulusi sebeli okumbela nji abekiwe mu sitokisi okutatela ekatulo no Mbumu omukulu, sebeli ni laela nji ababalelwe okubitela aba sanimu tumene kwa Sesale.” ");
INSERT INTO lyn_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Cwale Aglipa sebeli wamba kwa Festusi nji, “Kame ni singa okuyupa wkwa woyo mulume.” Festusi sebeli otambula nji, “Mbumumono byuunda,” ");
INSERT INTO lyn_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Cwale eliywaa aba lina kupa Aglipa ni Belunice sebeli aiya mu umbumu no kuneneba ni kwiingena mu Kuta aali naendisi no masole, naanu akulu no mulenen̄i. Cwale mu taelo ya Fesitusi, Paulusi sebeli olitiwa. ");
INSERT INTO lyn_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Cwale Fesitasi sebeli wamba nji, “Mbumu Aglipa nawo onje aikalile naaci muno, mumumwine omulume woyo aneyele aendisi no Majuda no kupula kwa mene mu ku muzekisa, bamweya mu Jelusalema ni muno, sebeli akuweleza nji kalukeele okuyoya kame. ");
INSERT INTO lyn_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kono kame nina wana nji kakwisa omubonda anatende owo ofanena elifu, yonyene kame ana kubilaeze okuta kwa Sesale, kame ni nawana oku mutumenako. ");
INSERT INTO lyn_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kono sikwite eso ni lukela okun̄olela kwa Sisale eso no niti mu taba yaye. Cwalehe kame nina muliti balubala lwenu, onene balubala lowe wene luli Ombumu Aglipa, nji munyima no kwamba etaba yaye, ni limuke eso sani twese okun̄ola. ");
INSERT INTO lyn_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kakuli kwa mene ni taba nokwa yupahala aba sa ku tumiwe omunu no kunungiwa, ka kumonisiwa eyambo ana zekisiwa.” ");
INSERT INTO lyn_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Aglipa sebeli wamba kwa Paulusi nji, “Kame opumenenwe nji waambe.” Cwale Paulusi sebeli olola elikaa lyaye ni kwamba nji, ");
INSERT INTO lyn_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kame ni kwite etitonolo okwikala balubala lowe wene ombumu Aglipa, mi kame sa nibe oupaki wange wonje ku yambo eto anitamilikeza a majuda. ");
INSERT INTO lyn_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kakuli wene olimukile emilao ni yambo eyo kasingi a majuda, cwale kame ni kukumbela nji oni tetete wino. ");
INSERT INTO lyn_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Omooyo wange okutunda ku wanuke, inaikala okutunda kumatatekelo mu sicaba no abaange mane ni ku Jelusalema, kame a ulimukile oonje a majuda. ");
INSERT INTO lyn_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Kakuli kame au limukile, nji kame saela okupaka eniti, nji okukumanena ni ulapeli kame inakuyoya kanyi mufalisi. ");
INSERT INTO lyn_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Mi bano kame ni imana kuti ni atulwe mu sepo eyo a na ku sepisa Nyambe kwa sitetu, ");
INSERT INTO lyn_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","eyo emishobo yetu likumu ni yiili asepile okawana, abo sa lapele mu niti omunji ni usiku, mi musepiso eyi ya ni nyaza nayo aendisi no Majuda. ");
INSERT INTO lyn_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Aanyi nji nisinu sikwangwiwa oku pumena nji Nyambe kame atwesa okwingula asikufa? ");
INSERT INTO lyn_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Mene menyene, niti luli kame nina yambuta nji kame nina kufanena okutenda einu no kupula mu kulwisa elitina lya Jesu no Nazaleta. ");
INSERT INTO lyn_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Kame nini ku tenda ngeso mu Jelusalema, oku yatilela aasikupumena mu tolongo, oku tunda mu maata nina kubiwa kwa apulisita akulu, kono cwale aba ana kwaatulela elifu, ni mene sebeli ni pumena okwaalwisa. ");
INSERT INTO lyn_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Aka no kupula mu tindoo no milapelo tonje kame nina kwakandimekanga nji anyefule, mi kakuli kame nina kwaatwebela ouyi, sebeli nikaayandisa mu milenen̄i indina. ");
INSERT INTO lyn_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Mane sebeli nita ku Damaseka mu maata ni mu taelo no apulisita akulu. ");
INSERT INTO lyn_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Omunji luli Molyange, sebeli ni mona olumonyi menili mu ndila luna kutunda ku wilu, no ku benya onene okubitelela eliseli no liywaa, sebeli linibeeka mukaci na nina kweenda noo. ");
INSERT INTO lyn_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Cwale aba tuna kukwela banji tonje, sebeli ni yupa eliywi elyaamba kwa mene mu mushobo no Sihebelu nji, ‘Saule,Saule, iikene oniyandiseta? Kame olemana aba olaha ku muwayo.’ ");
INSERT INTO lyn_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Cwale sebeli ni ibanguta nji, ‘Tiwe anyine, Mbumu?’ Ombumu sebeli otambula nji, ‘Time Jesu woyo olemine okuyandisa. ");
INSERT INTO lyn_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kono oinguke mi wimane ni makondo owe, kakuli kame nina kumonaha kwa wene mulibaka eli, oku kuketa nji osebeze nikuba oupaki mweyo ona mono ni kweyo saniku monahaze nayo mwa wene otenda opaki no inu ino. ");
INSERT INTO lyn_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Kame sani ku lamulele kwaanu aa ni kwasimacaba oko ni ku tumena kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Nji otonise amiyo oo, nji afutuke okutunda mu uwi okuta mu liseli ni mu maata no Satani ni kusiulukela kwa Nyambe, ni ku lemeniwa ku iibi yoo, mi ni sibaka saawo akenine ni ku pumena mwa mene.’ ");
INSERT INTO lyn_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Okutunda abo, Molyange Mbumu Aglipa, kani sikana oku yupa ku pono na kuwilu. ");
INSERT INTO lyn_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Kono sebeli olemusa oweli ali ku Daseka, cwale ni mu Jelusalema ni mu naha yonje no Judeya, mane ngeeso ni kwaa simacaba, nji kam e afanena oku baka ni ku futukela kwa Nyambe ni ku tenda emisebezi eyo ilukela awo ana baka. ");
INSERT INTO lyn_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Mulibaka elyo aendisi no Majuda lyokame anani nungele eyambo mu Ndoo ya Nyambe elyo asinga okuni ibaela. ");
INSERT INTO lyn_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Mu liywaa no balelelo kame nina wana etuso okutunda kwa Nyambe, mi cwale kame niimana bano okuba oupaki kwaakkulu bamweya naanyonyo, kakwisa eso naamba kono eyo anaamba anuhi a Nyambe ni Mushe mbaitendahala, ");
INSERT INTO lyn_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","nji Jesu mbayanda, mi cwale yokame no weeli okwinguka kwaanu, mi kame saambe eliseli kwaanu ni kwaasimacaba.” ");
INSERT INTO lyn_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Cwale Paulusi yooba oupaki waye, Fesitusi sebeli wamba ni liywi linene nji, Paulusi, kame olyangana, oukwiiyeta kowe no kuneneba kame ku kupulumukisa!” ");
INSERT INTO lyn_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Kono Paulusi sebeli wamba nji, “Mene, sitakana, molyange Fesitasi, kono kame naamba eniti luli. ");
INSERT INTO lyn_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kakuli Ombumu oilimukile eyi inu, mi kwayonyene kame naamba meni lukuluhile, kakuli kame ni pumena nji einu eyi kakwisa eso kalimukile. kakuli eyo kaisiku tendahalela ku mukunda. ");
INSERT INTO lyn_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mbumu Aglipa, kana kame opumena kwaanuhi a Nyambe? Kame nilimukile nji kame opumena!” ");
INSERT INTO lyn_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Cwale Aglipa sebeli wamba kwa Paulusi nji, “Mu nako ino inyonyo kame osinga nji ni futuke omuasikupumena?” ");
INSERT INTO lyn_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulusi sebeli otambula nji, “Simba enako inyonyo simba no kupula, kame ni twesa kwa Nyambe nji kasa wene feela kono nawo onje aniyupa mu liywaa lino kame safeke kanyi mene, konji fela amawenge.” ");
INSERT INTO lyn_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Cwale Ombumu sebeli oimana, ni mubusisi ni Benisi, naao ana kwikala noo, ");
INSERT INTO lyn_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","mi cwale aba ana kumana okunda ba Kuta, sebeli akwambisa mukaci koo nji, “Uyu mulume kakwisa eso ana tende nji aatulelwe elifu simba okunungiwa mu tolongo.” ");
INSERT INTO lyn_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Cwale Aglipa sebeli wamba kwa Festusi nji, “Uyu mulume kame afanena oku lukululwa kambe kasi ku litiwa balubala wa Sesale.” ");
INSERT INTO lyn_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Cwale abo abaabna kulumelelana nji ate mu Italiya, sebeli atwala Paulusi ni mapantiti anjili ku mukulu no masole Juliusi no sikwata no Augusto. ");
INSERT INTO lyn_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Aba ana kumana okwingena mu sisepe no Adlamiti, eso sina kufunduka ku likamba lya Asia sebeli tu fuula aaci ni Alisitako na mu ku Tesalonika omundi na mu Mesadoniya. ");
INSERT INTO lyn_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Eliywaa lina ku tatamako sebeli tu kakeela mu Sidoni, mi Juliyasi sebeli obabalela wino Paulusi, ni ku mufundula nji ate kwaabaye aka mu babalele. ");
INSERT INTO lyn_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Cwale sebeli amubeeka mu sisepe sina kuta ku Sipulasi, kakuli Emebo kame ina ku tulwisa. ");
INSERT INTO lyn_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Cwale aba tunakumana okuluta eliwate eli lita ku Silisia ni Pamifilia, sebei tu keela mu Mila mu Lisiya. ");
INSERT INTO lyn_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Omwendisi no masole sebeli owanamo esisepe sa Alekizanda eso sina kuta ku Italia sebeli otubeekamo. ");
INSERT INTO lyn_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kame tuna kweenda mu kwaleluba mu maywaa no kupula, mi sebeli tu kakeela ku Silisia mu ku bambaba, mikanyi Emebo aba ina kutukanena oku luta sebeli tu kulisa ku nyonga ya Kilete ku lineku lya Salumoni. ");
INSERT INTO lyn_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Me tu kulisa elikamba mu kubambaba, sebeli twiiya mu sibaka siisaniwa Feya Habenisi, abeebi ni mulenen̄i no Lasea. ");
INSERT INTO lyn_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Mu kusinya enako no kupula, mi omusipili sebeli ocilisa kakuli okweti kame ina kubwa, cwale Paulusi sebeli waaeleza nji, ");
INSERT INTO lyn_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Aolyange, kame ni mwene nji omusipili kame so ikale ni tikolofalo ni kusinyehelwa onene, kasa eibyana fela ni sisepe, kono bamweya ni moyo wetu.” ");
INSERT INTO lyn_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kono omwendisi no masole sebeli obeeka etingana ku mwendisi ni munya sisepe okubita eyo ana kwamba Paulusi. ");
INSERT INTO lyn_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Cwale mulibaka no likamba okwa lukela oku fuwekelamo ba nako no mubebo, aanu no kupula sebeli aaeleza nji afuwekela fela mu liwate, mu litohonolo nji mba twese okakeela ku Fenekasi mu likamba no Kilete, elyo lyalikete ku mutulo ni upa, ni mbowela ni upa, okapumulelamo omubebo. ");
INSERT INTO lyn_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Cwale Emebo naku mbowela aba ifuka wino, sebeli ahupula nji, omulelo woo mbaukondo, niku mona Ankola, sebeli afuula okukulisa amakamba no Kilete ao ali beebi ni likamba. ");
INSERT INTO lyn_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kono kuuso mbicana sebeli kwinguka Emebo no lin̄ungwa elyo lisaniwa Eulakilo. ");
INSERT INTO lyn_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Cwale esisepe ba si nakushimbiwa ku mebo, sebeli sikwangwa oku yaliketa, sebeli tusi lesela sita nayo. ");
INSERT INTO lyn_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Cwale sebeli tu kashetwa kunji no sooli no Kilauda, ni kusinga okukwangwa oku kokela esisepe sicana. ");
INSERT INTO lyn_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Aba ana kumana okanona, sebeli ongota esisepe mu kusinunga emihala eyo ikeela kunji, mi mulibaka nji kame ana kucila okukashetwa ba muuwa naku Silete, sebeli akwisa amaseili ni kukuka yongeso. ");
INSERT INTO lyn_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kakuli kame tuna ku lwisiwa ku mebo no lin̄ungwa, mu liywaa lina kutatamako sebeli atateka okukondela etutu yoo mu liwate eyo ina longiwa mu sisepe, ");
INSERT INTO lyn_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","mi ba liywaa no waatu sebeli tu kondela ni maoko etu, einu eyo yendisa esisepe nayo. ");
INSERT INTO lyn_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Cwale eliywaa simba etitungweti kaisiku moniwa mu mywaa no kupula, mi eliwate kame lina bifi ouyi ku mebo, mane sebeli tuulwa esepo nji mbatu yoisiwa. ");
INSERT INTO lyn_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Cwale aba ana kwikala amaywaa no kupula aulwile esi no kulya, Paulusi cwale sebeli oiya kwa onyene ni kwaamba nji, “Alume, kambe kame muna kuni pumena oweli me musi fuula kale ku Kilete, kambe kamusiilwa okulemana ni ku sinyehelwa. ");
INSERT INTO lyn_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Kono cwale kame ni mi kutaza, mu koongote, kakuli kakwisa woyo so sinyehelwa omoyo kono kame sa ku sinyeha fela esisepe. ");
INSERT INTO lyn_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kakuli ouno usiku elin̄eloi lya Nyambe nali kumonahaza kwa mene nili waye woyo ni sebeleza ");
INSERT INTO lyn_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","mi sebeli lyaamba nji, ‘Paulusi olese okucila, kame so kaimane balubala lwa Sesale, mi omone, Nyambe nakubi onje awo oluta noo mu sisepe.’ ");
INSERT INTO lyn_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Cwale mongole emicima, alume! Kakuli kame nili ni tumelo mwa Nyambe nji kame sa ku tendahale kanyi omo nina ambelwe. ");
INSERT INTO lyn_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Kono kame sa tu twaliwe ku yooli injili.” ");
INSERT INTO lyn_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Cwale eliywaa no likumi ni tunee aba lina kukeela, me tu twaliwa oku nooku ku mebo mu liwate no Andilia, mu kaci no usiku aapuwi no sisepe sebeli akakanya nji natu keela ku naha injili. ");
INSERT INTO lyn_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Cwale aba aana kweteka ouliba no meyi sebeli awana eibima makumi aatu ni twiili, kuuso mbicana sebeli aeteka kame sebeli awana eibima makumi ayiili ni mutanu ni twiili. ");
INSERT INTO lyn_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kame ana kucila nji mwendi mba tu twaliwa ku mebo ba mawee, sebeli akwisa amanjanga anee na mu litusi na kunyima nji esisepe siimane, mi kame ana ku lakaza nji kupee. ");
INSERT INTO lyn_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Cwale aapuwi no sisepe sebeli asaela oku luta okutunda mu sisepe, okwingena mu sisepe sicana mu liwate kanyi kame akakwisa atiankola na ku litusi na ku uso. ");
INSERT INTO lyn_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paulusi sebeli osimweta omwendisi no masole ni masole nji, “Konji aa alume aba saikale mu sisepe, okubinda samu yoye.” ");
INSERT INTO lyn_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Cwale amasole sebeli apatula omuhala no sisepe, ni kuulesela okutela. ");
INSERT INTO lyn_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Cwale eliywaa ekalya sipa kale, Paulusi sebeli waakumbela onje nji alye eilya, ni kwamba nji, “Balelo yakwana kale amywaa likumi ni anee me mutatelele nuuku yumena eilya, memu ulwile esi no kulya. ");
INSERT INTO lyn_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Cwalehe kame ni mikumbela nji mulye esilya, mbaimibi okongola, kakuli kakwisa oluuki na ba mutwi no munu ni munu kwaanyi olo salu sinyehe.” ");
INSERT INTO lyn_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Cwale aba ana kumana okwamba eyi, sebeli oshimba esinkwa, nuukutumela kwa Nyambe balubala woo onje ni ku sipatola ni ku tangisa okulya. ");
INSERT INTO lyn_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Cwale sebeli aongola emicima ni kulya eilya nonyene. ");
INSERT INTO lyn_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Kame tunaku kwana epalo ikuma ba myaanda yiili ni makumi mutanu naayili ni mutanu ni kamweya (276) aanu mu sisepe. ");
INSERT INTO lyn_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Cwale aba ana kumana okulya wino, sebeli afukuza kukulema no sisepe oku yumbela ouloto mu liwate. ");
INSERT INTO lyn_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Cwale aba lina kupa eliywaa, kasi kulimuka enaha eyo nji ibine, mi sebeli alemuha esiko sili ni likamba, cwale sebeli asinga nji aba kukonahala atwalemo esisepe. ");
INSERT INTO lyn_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Cwale sebeli apatula emihala ina nungu etinkola ni kwisiya mu liwate, mi mu nako imweya ni kusheputula emihala eyo inungile amabala no ku siululisa esisepe, mi ni ku imeka eseili no kuneneba ba libala no sisepe nji cwale Emebo aba ifulabo yaatwale ku likamba. ");
INSERT INTO lyn_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kono sebeli tu fuwama bamwalala no mushekesheke eso sili ni meyi oku nooku. Elitusi nakunyima sebeli licoka, cwale eli nakuuso sebeli likakatela ba mushekesheke ");
INSERT INTO lyn_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Omuhupulo no masole neli nji aibae amapantiti, okwaa sileleza nji alese okuyowa ni ku sila. ");
INSERT INTO lyn_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kono omwendisi no masole mu ku singa okuyoisa Paullusi, sebeli waakanisa, mi ni ku laele nji aa atwesa okuyowa, amatukele oweeli mu liwate ate ba likamba, ");
INSERT INTO lyn_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","mi anjili aku tusise amabala, anjili baibindi ina coko no sisepe. Cwale mokame omo ana ku keelela ba likamba, aayoya. ");
INSERT INTO lyn_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Munyima no kuyoya ngeso, okubinda cwale tu limuke nji esooli eso kame siisaniwa nji Melita. ");
INSERT INTO lyn_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ni man̄eke aa alimo sebeli atutenda mu sishemo no kuneneba, ni kutu tambula toonje omunu ni munu, mi sebeli atumbula omulilo no kuneneba, mulibaka no mbula ona kuloka ni mulibaka no seenge. ");
INSERT INTO lyn_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Cwale Paulusi sebeli ocaa en̄ata no wandilala no itondo no kuku kuta ni kwibeeka ba mulilo, omo sebeli kutunda esibili mulibaka no kweenya, sebeli siku tingeta ba Lyoko lyaye. ");
INSERT INTO lyn_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Cwale aman̄ete aba ana ku mona enyoka ilepelela ba Lyoko lyaye, sebeli akwambisa mukaci koo nji, “Luli omunu uyu ni mwiibai, kakuli naaba aba bandukamu liwate, ouku faniketa ku wilu kalukele okuyoya. ");
INSERT INTO lyn_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Kono Paulusi sebeli otutulele fela enyoka mu mulilo kaisimu tenda ouyi. ");
INSERT INTO lyn_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Aanu kame ana kutatelela okumona nji kame sa timbe simba okukwela banji ababo nji afe, kono kame ana kutatelela ba nako no kuleba onene, mi sebeli amona nji kakwisa esi sitendahala kwa yonyene, sebeli afutuka okwamba nji neli nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Abeebi ni sibaka eso tuna kwikala kame kuna kwikala onduna no sooli wisaniwa nji Pubuliyasi, ni yonyene sebeli otu tambula wino, niku tushimba ku ndoo yaye amaywaa aatu. ");
INSERT INTO lyn_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Sitaye Publiusi kame ana ku langana okukola efibele ni ku sulula ounyinga. Pauusi sebeli otako oka mulekula ni kulapela, sebeli omu beeka amaoko aye beeulu niku mubalisa. ");
INSERT INTO lyn_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Eyo aba ina kubwa, onje aanu asikutoma ba sooli sebei aiya, mi kame ana ku balisiwa. ");
INSERT INTO lyn_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Cwale sebeli atuba etimpo no kupula, mi aba tuna ku fuula, sebeli atubeekela mu sisepe eyo tuna ku saela. ");
INSERT INTO lyn_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Munyima no tikweti taatu sebeli tu funduka ni sisepe sina ku fuwekelanga musoli, esisepe na ku Alekizandiliya, mi balitusi ababekilwe esiswaniso no aana no mambile ");
INSERT INTO lyn_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Aba tu na kukeela mu Silakuze sebeli twi ikalamo amaywaa aatu. ");
INSERT INTO lyn_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Mi aba tu na kufundaka sebeli twenda ku nyonga no liwate mi sebeli tu kakela ku Lihegiomu, mi munyima no liywaa limweya Emebo naku mboela sebeli ifuka, mi ba liywaa li no wiili sebeli tu kafuweka mu Petiyoli. ");
INSERT INTO lyn_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Omo sebeli tu ka wana aasikupumena, mi sbeli atumema njintwiikale noo mu maywaa ana kukwana mutanu naayiili. ");
INSERT INTO lyn_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Cwale aasikupumena omo aba ana ku tuyupa sebeli aiya okutunda oku no kuleba ku Folamu mu sibaka no Appiusi ni ku mahotela aatu mukutu waniketa. Mu kwaamona, Paulusi sebeli oku tumela kwa Nyambe nikuongola omucima. ");
INSERT INTO lyn_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Cwale aba tuna kukeela mu Loma, Paulusi sebeli amu lumelela nji aikale yomboci ni masole awo ana ku mu sileleza. ");
INSERT INTO lyn_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Munyima no maywaa aatu, sebeli oisana aendisi no Majuda, mi cwale aba anokuwana sebeli wamba kwa onyene nji, “Abaange, naaba kanisi tenda esinjili okulwisa aanu simba esizo sa Sitetu, kono kame nina kubeekiwa mu tolongo mu Jelusalema mu maata no Maloma. ");
INSERT INTO lyn_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Cwale aba ana kumana okuni ibanguta, sebeli asinga nji ani lukulule, kakuli kame ku nakuulwa omubonda no lifu mu taba yange. ");
INSERT INTO lyn_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kono aendisi no Majuda aba ana kukana, cwale sebeli ni ku bilaeza kwa Sesale, simba nji kani sikwikala ni mubonda no ku lwisa enaha yange. ");
INSERT INTO lyn_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Cwalehe mulibaka elyo kame nina kumbele nji ni kumone, kakuli ni mulibaka no sepo no Isilaele eyo inisaiseta oku nungiwa amawenge.” ");
INSERT INTO lyn_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Cwale sebeli aamba kwa onyene nji, “Katu sitambula aman̄olo okutunda ku Judeya aa aamba eyowe, mi kakwisa aasikupumena ana tundu oko aneeyi mu kubiha simba okwamba eyi no kwiiba ona ku tenda. ");
INSERT INTO lyn_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kono kame tu singa okuyupa kwa wene eso onahana, kakuli okwamana ku tuto no Ndila kame tu limuka nji kame ilwisa koonje.” ");
INSERT INTO lyn_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Cwale aba ana kumana oku lukisa eliywaa nookuwana naye, sebeli aiya oko ana kwikalanga mu kupula. Cwale sebeli waatolokela eyaye yonje oku tunda amasiku konji ku mangolwaa, okupaka eyi no mubuso wa Nyambe, nikweteka nji alumele eyambo ya Jesu bamweya oku tunda ba mulawo wa Mushe naanuhi a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Cwale anjili sebeli apumena eyo ana kwamba, mi anjili sebeli akana. ");
INSERT INTO lyn_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Cwale mu kukana okuyupa mukaci koo, sebeli afunduka, munyima ya Paulusi okwamba eliywi limweya nji, “Emebo No Kukena kame ina kwamba eniti kwa sitenu okubitela mu munuhi wa Nyambe Isaya nji, ");
INSERT INTO lyn_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Mute kwaanu aa, mi mu kaambe nji, luli mba mu yupu kono kamutamba ku yupisisa mi luli mba mu mono kono kamutamba oku monisisa, ");
INSERT INTO lyn_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","kakuli emicima no aanu aa, kame yongolile, ni matwi oo kaayupu mi amiyo oo kame akutimine, kono amiyo oo kame ana fanene okumona, amatwi oo kame afanena okuyupa, mane ni kuyupisisa ni micima yoo, mi kame afutukela kwa mene, nji naabalise.’” ");
INSERT INTO lyn_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Cwale mulimuke nji, “Okuyoisa kwa Nyamba kame kuna ku tumenwa asimacaba mi kame sayupe!” ");
INSERT INTO lyn_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Aba ana kumana okwamba amaywi ao, aendisi no Majuda sebeli amusiya, mi sebeli kwikala etin̄ananyi no kuneneba mukaci koo. ");
INSERT INTO lyn_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Cwale Paulusi sebeli oikala eilimo yiili mu ndoo eyo ana kutenekanga amali, ni ku tambulanga aanu onje awo ana kwiyanga kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kame ana ku kutazanga eyi no mubuso wa Nyambe ni kwaiyeta eyi ya Mbumu Jesu Kilesite epatalaza no kwaulwa okushweka simba simweya.");
INSERT INTO lyn_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mene Paulusi, omubika wa Jesu Kilesite ona isaniwa oku tendiwa omutumwa nji aambe eliywi no kuwaba lya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Eliywi no kuwaba ana kusepisa kale Nyambe mwanuhi aye mu man̄olo no kukena. ");
INSERT INTO lyn_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Eliywi no kuwaba okukumanena kwa mwanaye, ona kuleiwa mu lusika lwa Dabida mu lutu no unu, ");
INSERT INTO lyn_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","cwale naku monahalisiwa ni maata nji Mwanaa Nyanbe luli okukumanena ku mebo no kukena aba ana kwingulwa kwaafu, Jesu Kilesite Ombumu wetu. ");
INSERT INTO lyn_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Mwayonyene Jesu, Nyambe na kutuba esishemo no kutendiwa omutumiwa nji mulitina lyaye tu monise ano macaba etuso no ku kuteka. ");
INSERT INTO lyn_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Cwale okwekeza naanyi munaisaniwa kwa Nyambe nji mwikale kwa Jesu Kilesite. ");
INSERT INTO lyn_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Kwaanyi moonje aasikupumena muli mu Loma anyi musingiwa ni kwiisaniwa kwa Nyambe nji mutende esicaba saye. Mubiwe esishemo ni kozo kwa Nyambe Sitetu ni kwa Mbumu Jesu Kilesite. ");
INSERT INTO lyn_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Kame ni tateka oukutumela kwa Nyambe wange mwa Jesu Kilesite mulibaka lyenu moonje, kakuli etumelo yenu kame yambiwa mu litunga lyonje. ");
INSERT INTO lyn_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kakuli Nyambe ni paki wange woyo ni belekela ni mebo yange mu liywi no kuwaba lya Mwanaye nji ni lesele oku mipuluka, ");
INSERT INTO lyn_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","enako yonje abani lapela, kame ni kumbela nji mukusinga kwaye Nyambe alukise einu yonje nji ni lukisetwe omusipili no kuwaba aba niiya kwaanyi. ");
INSERT INTO lyn_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kakuli kame nilakaza onene oku mimona, nji ni mibe empo imweya no mebo no kukena nji ni shukelwa ");
INSERT INTO lyn_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","abo cwale kame tufanena oukususuweza toonje omunjili ku munjili mu tumelo yetu. ");
INSERT INTO lyn_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Anyi abange kame ni singa nji mulimuke, etinako no kupula kame ni singanga okwiiya mu ku mi mona kono kameni kwangwanga, kakuli kame kwiyanga indina eyi ini kwangwisanga. Kame ni naasingi nji niiye mu ku yangula etimbuto mwaanyi kanyi omo nina tendele kwa simacaba anjili. ");
INSERT INTO lyn_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Kakuli kame nili ni sikoloti ku Mageleke ni kwasi mishobo indina onje, bamweya kwasiku shangama naaelo. ");
INSERT INTO lyn_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Cwale kame ni shukelaoka kutaza eliywi no kuwaba lya Nyambe ni kwaanyi kame muyoya mu Loma. ");
INSERT INTO lyn_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kakuli seene oku kutaza eliywi no kuwaba lya Nyambe, kono ni maata a Nyambe no kuyoyisa onje awo asi ku pumena, oweli ku Majuda okubinda okuta ku Mangelike ");
INSERT INTO lyn_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kakuli mwasonyene okuluka kwa Nyambe kame kuna shootolwa, oku tunda ku tumelo ni kuta ku tumelo kanyi omo ku ng'olelwe nji, “Woyo no kuluka, mbayoyo mu tumelo yaye.” ");
INSERT INTO lyn_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Kakuli okutweba kwa Nyambe kame kutundelela kuwilu, mi okulwisa ouyi ni ufokoli onje no alume awo ana lyatelele eniti mutikezo too no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kakuli eso sitwesahala oku limukiwa sa Nyambe kame sina hupulelwa kwa onyene, kakuli Nyambe naimonahaza kwa onyene. ");
INSERT INTO lyn_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kakuli oku tunda ku simuluho no litunga eyi ya Nyambe no kwamoniwa, amaata aye ni Unyambe waye kame imonahala wino-wino mu inu yaye ana tende. Cwale abakulingeso kakwisa omo sakutatulele. ");
INSERT INTO lyn_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Kakuli simba nji kame alimukile Nyambe, kaasimukuteka kanyi yokame Nyambe simba okutumela kwa yonyene, kono kame ana futuka aa nambulwa tuso mu mihupulo yoo ni micima yoo eyi isaela oku yupisisa sebeli iilola. ");
INSERT INTO lyn_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Kame ana singi nji atende anoku shangama, cwale sebeli afutuka aaelo, ");
INSERT INTO lyn_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ni kufutula ekanya ya Nyambe na kwaafa okwitenda amaswaniso no kuumba kanyi omunu, simba otuyunyi simba eiyamana, simba eyi yeenda ni mapumo. ");
INSERT INTO lyn_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Cwalehe, Nyambe naaleselele okutenda eyino titakazo no micima yoo na kwakena, nji ashubule etinyutu too mukaci koo. ");
INSERT INTO lyn_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Kakuli kame ana futula eniti ya Nyambe okwitenda amapwa ni kulapelela ni kusebeleza eyumbiwa okubita omuumbi, woyo olumbiwa enako yonje okuno kwabwa! Ameni ");
INSERT INTO lyn_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Mulibaka eli, Nyambe naaleselele okutwalelela mu titakazo too atenda eyi no kwiiba. Mane akati sebeli alangana ni akoo akati. ");
INSERT INTO lyn_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Mukutenda ngeso alume ni onyene sebeli alesela emikwa no kulangana naakati kono sebeli alangana nalume akoo. ");
INSERT INTO lyn_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kakuli kasi tokomela oku limuka Nyambe woyo no niti, Nyambe naabi ku minahano na kwanahana wino. ");
INSERT INTO lyn_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Kame aiyalile eino kwiiba yonje mi kame ali ni matalu, ni lutimbo, mane kame ashukela eyi no akoo, ni muna nuukwibaa, ni tin̄ananyi ni tindwaa mane ni kooba ");
INSERT INTO lyn_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","asimapwa, aa atimbile Nyambe, asi kunyefula, asi ku kuhumusa, asi kutateka eyi no kwiiba mi kakuteke ashemi oo. ");
INSERT INTO lyn_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Kaakwite etingana, kaasepahala, kaakwite elizwalo ni kuulwa amakeke. ");
INSERT INTO lyn_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Naaba alimukile ekatulo ya Nyambe eyi yaamba nji, Aanu onje ayoya ngeso, kame afanena okufa. Cwale kaitende fela, kono kame alumelela awo aitenda. ");
INSERT INTO lyn_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Cwalehe weene omunu wakwite okulemena aakowe mi kame watula, kame okwatula wenyene. Kakuli wene watula kame otenda eyi atenda. ");
INSERT INTO lyn_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tulimukile nji ekatulo ya Nyambe niya niti kwao atenda eyi no kwiiba. ");
INSERT INTO lyn_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Cwale wene omunu feela aba watula akowe, kono ni wene otenda eyi atenda, kame onahana nji mbupicuka ekatulo ya Nyambe? ");
INSERT INTO lyn_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Kamba nji kame oshwaula esifumu no sishemo saye, nu ukukuteka kwaye, ni mucima waye no kuwaba kono kulemuha nji esishemo sa Nyambe kame sikutwala kukubaka? ");
INSERT INTO lyn_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kono mulibaka no kwaayupa kowe ni mucima wowe no kwabaka kame okutewela okutweba muliywa lya Nyambe abo cwale ekatulo yaye no kuluka aba saimonahale. ");
INSERT INTO lyn_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Kakuli Nyambe kame sabe omunu ni munu omupuzo okukumanena kweyo atenda. ");
INSERT INTO lyn_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Kwao atwalelela okutenda wino einu, okame awo asaela okuyemiwa, ni kukutekiwa na kwaafa, asabiwe omoyo na kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Kono kwao aku tendela eyoo ni kukana eniti yaye ni kutenda ouyi, kame sa tambule okutweba ni kutina kwaye. ");
INSERT INTO lyn_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kame sakwikale amayando ni kukola kwaanu onje awo atenda eyi no kwiiba, oweli ku Majuda ni ku Mangelike ");
INSERT INTO lyn_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Kono Nyambe mbabi ekanya ni tumbo ni kozo ku munu yonje woyo otenda wino, oweli ku Majuda okubinda ku Mangelike ");
INSERT INTO lyn_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kakuli kwa Nyambe kakwisa esaluluti. ");
INSERT INTO lyn_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Awo onje ana tende esibi nambulwa mulawo wa Mushe kame saatuliwe no mbulwa omulawo. Mi awo onje anatende esibi alimukile omulawo mbaatuliwa ku mulawo. ");
INSERT INTO lyn_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Abo kasa awo ayupa omulawo wa Mushe awo akenine balubala wa Nyambe, kono awo akokong'elela omulawo wa Mushe asa kayoyisiwe. ");
INSERT INTO lyn_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Cwale asimacaba aba kaakwite omulawo kono alemine okutenda eso sisaeliwa ku mulawo wa Mushe, ni onyene ni mulawo kwaonyene, simba kwakwite omulawo. ");
INSERT INTO lyn_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Kame amonisa nji eso omulawo wa Mushe osaela kame sing'olilwe ku micima yoo, abo emihupulo yoo kono elizwalo lyoo kame lyaapakela mi emihupulo yoo kame yaanyaza abanjili kame yaimanenanga. ");
INSERT INTO lyn_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ba liywaa elyo, okukumanena ni liywi lyange no kuwaba, Nyambe kame saatule etikunutu no aanu mwa Jesu Kilesite. ");
INSERT INTO lyn_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Cwale weene wisaniwa nji uli Mujuda kame oku sepisa ba mulawo wa Mushe mi kame oku lumba mwa Nyambe, ");
INSERT INTO lyn_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ni kulimuka etato yaye ni kwekeza okutenda wino kakuli kame ona iyetiwa mu mulawo wa Mushe, ");
INSERT INTO lyn_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","mi kame olimukile nji yawene otwaletele eibofu, eliseli kwawo ali mu uwi, ");
INSERT INTO lyn_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","tiwe omusiululi no aelo ni mwiyeti no awo ali mu uwi mu mulawo wa Mushe, kakuli kame okwite esisupo no kulimuka eniti. ");
INSERT INTO lyn_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Cwalehe, wene olemine okwiyeta akowe, ikene aba wasiku kwiyeta wenyene? Kame okutaza nji kakufanene okwiita, cwale ikene aba wiita? ");
INSERT INTO lyn_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Wene aba wamba nji kakufanene okutenda ouhule, cwale ikene aba utenda ouhule? Kame utimbile aafu no kuumba, cwale kame wiitanga mu tindoo no ku lapelela aafu ");
INSERT INTO lyn_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Wene kame oku nuneka bakwikala ni mulawo wa Nyambe, kono kame oshwaula Nyambe mukucola omulawo waye! ");
INSERT INTO lyn_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kakuli kame ku ng'oliwa nji, “Elitina lya Nyambe kame linyefulwa mwa asimacaba mulibaka lyenu aendisi no Majuda.” ");
INSERT INTO lyn_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Omupato wowe ni waniti nji kame okuteka omulawo, kono nji kame ocola omulawo, omupato wowe kautendile mupato luli. ");
INSERT INTO lyn_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Cwalehe nji omunu no kwaingena mu mupato, kame ateula etitaelo no mulawo wa Mushe, kame kukufekile kanyi naingene mumu pato. ");
INSERT INTO lyn_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Cwale woyo nakwaingena mu mupato kono kame amamela omulawo kame sami atule anyi muna ng'olelwe eyi no mulawo ni mupato kono kame mucola omulawo. ");
INSERT INTO lyn_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Kakuli woyo na kwatenda Omujuda luli oli bandee, simba nji omupato no niti sinu sinjili sili bandee ni lutu ");
INSERT INTO lyn_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Omujuda luli woyo mukaci, mi omupato luli ni wa mu mucima owo otendiwa ni mebo kasa feela. Okulumbiwa kwaye kakutundu kwaanu kono kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Cwale ouwa ana wana aendisi no Majuda ubine? Simba etuso no mupato ibine? ");
INSERT INTO lyn_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Onene ku maneku onje! Mu ku tateka, Nyambe na ku sepa omusebezi waye ni kubeeka amaywi aye ku Majuda oweli. ");
INSERT INTO lyn_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Cwale ngasibine nji anjili kakwite etumelo? Ninji okuulwa koo etumelo kame kutwesa oku shwaula etumelo ya Nyambe? ");
INSERT INTO lyn_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kokuulwa! Kasangeso, mulesele Nyambe no niti simba nji aanu onje ni amapwa. Kanyi omo kun̄olelwe mu man̄olo nji, “Kame ufanene oku monahala woyo no niti mu yambo wamba, Nji ushowelele woyo nakukunungelela eyambo aba uzekisiwa.” ");
INSERT INTO lyn_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Kono cwale nji okufosa kwetu kame kumonahala okuluka kanyi kwa Nyambe, abohe iikene sa twaambe? Cwale mbatwamba nji Nyambe kame afosa aba alita okutweba kwaaci? (Kame naamba ngeso mu mukwa no unu.) ");
INSERT INTO lyn_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kokuulwa! kakuli kambe Nyambe kasa wakuluka, kambe ngasibine saatwese okwatula elitunga? ");
INSERT INTO lyn_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Kono cwale nji okuulwa eniti kwange kame kutusa oku monisa wino eniti ya Nyambe, mane ni kwekeza ekanya yaye, iikene saniatulelwe kanyi osi ku tenda ouyi? ");
INSERT INTO lyn_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Cwale iikene aba twaatende eyi no kwiiba nji eyi no kuwaba iiye?” Kanyi aanu anjili aba aninyaza nji kame ni tenda ouyi! Oku nyaza koo na kuluku. ");
INSERT INTO lyn_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Iikene cwale! Ninji aaci aendisi no Majuda kame tuli wino okubita ano Magelike? Kokulwa kasangeso! Kakuli kame inaamba kale nji aendisi no Majuda ni Magelike kame ali mu maata no sibi. ");
INSERT INTO lyn_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Kanyi aba kun̄olilwe nji, Kakwisa omunu simba mumweya uyu no kuluka. ");
INSERT INTO lyn_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Kakwisa uyu uyupisisa simba uyu osaela Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Onje kame a yaukile, bamweya naafutuka aa no kwiiba mi naafoso kakwisa uyu otenda esi nokuluka, simba mumweya. ");
INSERT INTO lyn_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Emilyu yoo ni libita liyamine, kameonga ni tindimi too, nimaywi nokwiiba kanyi esifanu no sibili, aatunda mutunwa too. ");
INSERT INTO lyn_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Mutunwa too kame kuiyalile etingangu, ni ikuto no kulula. ");
INSERT INTO lyn_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Amakondo oo nakuleluba ba kwiita ounyinga. ");
INSERT INTO lyn_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Mutindila too kame kuli oku sinya ni mayando. ");
INSERT INTO lyn_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Kaalimukile endila no kozo, ");
INSERT INTO lyn_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Mi mu miyo oo kaacili Nyambe.” ");
INSERT INTO lyn_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Cwale kame tulimukile wino nji eiyambiwa mu mulawo yonje kame yambeliwa aayoya munji no mulawo, nji otunwa tonje tondoke mi aanu onje awaniwe ni mubonda balubala wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kakuli kakwisa omunu somoniwa nji niwakuluka mu miyo aye mu musebezi no mulawo, kakuli omulawo kame otulimukisa esibi. ");
INSERT INTO lyn_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Kono cwale okutundisako omulawo okuluka kwa Nyambe naku limukisiwa, me upakiwa ku mulawo ni unuhi. ");
INSERT INTO lyn_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Okuluka kwa Nyambe kame kutundelela mutumelo mwa Jesu Kilesite kwao apumena onje, kakuli kakwisa efapahano mukaci koo. ");
INSERT INTO lyn_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Kakuli onje kame ana tende esibi mi kame ana kauhelwe ku kanya ya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Mi kame ana beekiwa fela ano kuluka mu sishemo saye kanyi omupuzo mu kuliululiwa kwa Jesu Kilesite. ");
INSERT INTO lyn_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Woyo ona kubekiwa balubala kwa Nyambe okutenda esitabelo mulibaka no unyinga waye nji otambulwe mu tumelo. Esi kame sina kumonisa okuluka kwa Nyambe, naaba kasi kwaliketa ku ibi no kale. ");
INSERT INTO lyn_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Neli oku monisa mu nako no balelo lino nji yonyene niwakuluka, ninji woyo oli ni tumelo mwa Jesu, Nyambe kame amubeeka ono kuluka. ");
INSERT INTO lyn_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Cwalehe, ikene satukulumbe nayo? Kakwisa! Mulibaka libine? Mulibaka no musebezi? Kokuulwa! Kono mulibaka no tumelo. ");
INSERT INTO lyn_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kakuli kame tukolwa nji omunu kame abeekiwa ono kuluka mulibaka no tumelo kasa mu misebezi no mulawo. ");
INSERT INTO lyn_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Cwale Nyambe, ni Nyambe no Majuda feela nji? Kasa nji ni Nyambe no macaba? Ee, ni Nyambe waa no macaba nonyene. ");
INSERT INTO lyn_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Kaksuli Nyambe ni mumweya, mi aa ali ni mupato kame wabeeka ano kuluka mulibaka no tumelo yoo, nawo aulwile omupato ni mulibaka no tumelo yoo. ");
INSERT INTO lyn_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Cwale kame tucola omulawo mulibaka no tumelo? Kokulwa kasangeso, kono kame tongota omulawo. ");
INSERT INTO lyn_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Cwale iikene satwambe, Abulahama njekulyetu, siikene ana kuwana kuneku no unu? ");
INSERT INTO lyn_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","kakuli nji Abulahama kame na beekiwa wa kuluka mulibaka no misebezi, abo, kame ali neso sakulumbe naso. Kono kasa balubala wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Cwale eling'olo iikene lyamba? “Abulahama kame ana kupumena kwa Nyambe, mi okupumena kwaye, Nyambe kame amubalela nji wa kuluka.” ");
INSERT INTO lyn_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Cwale ku munu woyo otenda omusebezi, omupuzo waye kawaliketiwa nji ni mpo, kono ni tifo. ");
INSERT INTO lyn_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Cwale ku munu no kwa tenda omusebezi kono kame apumena fela kwa Nyambe, woyo oba aano kwiiba okubeekiwa ono kuluka, yonyene etumelo yaye kame ibaliwa nji kuluka. ");
INSERT INTO lyn_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Esi sokame Dabida esa aamba embuyoti no munu woyo waliketiwa kwa Nyambe nji ni wakuluka, oku ulwile emisebezi aba aamba nji, ");
INSERT INTO lyn_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Kame ali ni mbuyoti awo ana lemenwa etifoso too, Awo ana fukeliwa eibi yoo! ");
INSERT INTO lyn_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Embuyoti ni ya munu woyo uulwa okupulukelwa eibi yaye kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Embuyoti eyo kana kame ibiwa feela aa anati ku mupato, nji naa kasita ku mupato? kakuli kame twamba nji, “Abulahama naku pumena kwa Nyambe mi mu tumelo yaye, Nyambe naku mu pumena nji wa kuluka.” ");
INSERT INTO lyn_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Cwale ngasibine aba ana kubalelwa ngeso, yoli ngaibi? Abo yowa ingena kale mu mupato, nji yokasi ingena kale? Neli abo yokasi ingena kale, kasa nji yowa ingena kale kokulwa. ");
INSERT INTO lyn_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Sebeli ota ku mupato, neli esisupo no kumonisa nji wakuluka mu tumelo yaye anakwikala nayo yokasita kale ku mupato. Elibaka neli nji atende Sitoo onje kwawo apumena kwa Nyambe onje, nawo aulwile okuta ku mupato nji nonyene abalelwe etumelo nji nikuluka. mi kame a tambulwa kwa yonyene kakuli ni wa kuluka, simba nji kaa sita ku mupato. ");
INSERT INTO lyn_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Kame osili Sitoo kwao a tambulwa kuta ku mupato, kasa kwao fela anati ku mupato, kono nawo aenda mu mwanda no tumelo ya Sitetu Abulahama yokasita kale ku mupato. ");
INSERT INTO lyn_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Esepiso ya Abulahama na ikulyaye noku yola elitunga, kayasikwiiya mu mulawo kono neli mukuluka no tumelo. ");
INSERT INTO lyn_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Cwale nji okuyola kame kuyoliwa ni mulawo, ulimuke nji etumelo ni sepiso kaikwite tuso. ");
INSERT INTO lyn_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Kakuli omulawo kame ulita okutweba, kono aba kuulwile omulawo kakutamba kwikala okucola omulawo. ");
INSERT INTO lyn_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Mulibaka no ngeso, esepiso kame ina kwiya mu tumelo, nji itende mu sishemo, nji yongotetwe mu lusika lwa Abulahama, kasa kwao fela asi mulawo kono ni kwao akwite etumelo ya Abulahama. Yo sitetu toonje, ");
INSERT INTO lyn_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","kanyi omo ku n̄olelwe nji, “Kame inaku tende Sitoo no matunga no kupula.” Mu miyo a Nyambe, mwayonyene apumena, woyo oba omoyo kwaanokufa ni kwiisana einu nji kame iyoya eyo nokwayoya. ");
INSERT INTO lyn_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abulahama sebeli opumena mukusepa, naba kuna kuulwa esepo, mi sebeli otenda ngeeso Sitoo nomacaba no kupula, kanyi omo kuna kwambelwa kwa yonyene nji, “Kanyi olusika lowe omo salwikalele. ");
INSERT INTO lyn_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Mi kakuli kasi kufokola mu tumelo, mane kasi kwaliketa nji olutu lwaye kame lukulubalile, kakuli emyaka yaye kame inakwana omwanda (100), ni kunahana nji moyo waye Sala katwese ku leya kame. ");
INSERT INTO lyn_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Kakuli kakwisa esinu simba simweya sinaku mutongokisanga okukumanena ni sepiso ya Nyambe, kono sebeli okongota mu tumelo yaye muku lumbeka Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Kame ana kolwa nji Nyambe mbatwese okutenda eso anaku musepisa. ");
INSERT INTO lyn_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ababo etumelo yaye sebeli oibalelwa nji kuluka, ");
INSERT INTO lyn_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","kono amaywi anaku ng'olelwa kasa aye fela yomboci. ");
INSERT INTO lyn_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Kono naaci ngeso kame sabalelwe ni kwaaci tu pumena kwa woyo ona kwingulwa kwaafu Jesu Ombumu wetu. ");
INSERT INTO lyn_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Woyo ona kwibaiwa mulibaka no ibi yetu, ni kwingulwa nji tubekiwe ano kuluka. ");
INSERT INTO lyn_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Cwale aba tuna tendiwa anokuluka mu tumelo, kame tuli mu kozo ni Nyambe mulibaka lya Mbumu wetu Jesu Kilesite. ");
INSERT INTO lyn_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Mwa yonyene tunawana etumelo mu sishemo omo tuwaniwa, mi kame tuwabelelwa mu sepo no kanya ya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Cwale kasa ngeso fela, kono kame tuwabelelwa mu mayando etu, kakuli kame tulimukile nji amayando kame atulitela okongoteta, ");
INSERT INTO lyn_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Okutundamena kame kulita emikwa no kuwaba mi emikwa no kuwaba kame ilita esepo. ");
INSERT INTO lyn_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","mi esepo kaitwenisa, kakuli elilato lya Nyambe nali kwitelwa mu micima yetu, mu mebo no kukena, eyo ina kubiwa kwaaci. ");
INSERT INTO lyn_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kakuli abo metu sifokola, ba nako inakufanena Kilesite nakufela asikutenda ouyi. ");
INSERT INTO lyn_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Iikene aba kubambabile nji omuunu afele aa nokuluka, mwendi omunjili abasa kongote omucima okufela aano kuluka. ");
INSERT INTO lyn_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Kono Nyambe kame amonisa elilato lyaye kwaaci nji nabo tusilemine okutenda eibi, kakuli Kilesite nakutufela! ");
INSERT INTO lyn_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Cwalehe abo, aba tubeekilwe anokuluka ni unyinga waye, mbatu yoisiwa mwa yonyene ku kutweba kutunda kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kakuli naba tusili eiila, kame tuusetwa kwa Nyambe muibaka no lufu lwa Mwanaye, aba tuna usetwa kwa yonyene, kame satu yoisiwe onene mulibaka no moyo waye! ");
INSERT INTO lyn_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Kasangeso fela, kono tusi wabelelwa mwa Nyambe mulibaka lya Jesu Kilesite Ombumu wetu, kakuli aba tuna usiwa ngeso ni mulibaka lyaye. ");
INSERT INTO lyn_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Mulibakaelyo esibi nasikwiiya mu litunga mulibaka no munu mumweya mi elifu ni mulibaka no sibi, mu mukwanongeso elifu naliyi kwaanu onje kakuli kame anatende esibi onje. ");
INSERT INTO lyn_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Esibi luli kwasina kwikalanga oweeli mu litunga omulawo akawa sisumiwa kale, kono esibi kasi baliwa aba kuulwile omulawo. ");
INSERT INTO lyn_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Nabakulingeso elifu nali kubusa okutunda kwa Adama okutwala kwa Mushe, simba kwao ana kwatenda esibi kame liikalako noku matuka omulawo mu mukwa oku fekile kanyi anakutenda Adama, Yonyene oli esifekiso sa woyo soiya. ");
INSERT INTO lyn_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kono empo no sishemo kaikufekile kanyi esibi sa Andama. Kakuli aano kupula kame anafu mulibaka no munu mumweya, esishemo sa Nyambe ni mpo itunda mu sishemo no munu mumweya yonyene Jesu Kilesite yonyene kame ipulele aano kupula niku bitelela! ");
INSERT INTO lyn_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Mi empo kai kufekile kanyi esibi sina kwiiya mulibaka no munu mumweya, kakuli ekatulo no munu mumweya kame ina liti ekatulo no kuba aanu no kupula omubonda, kono empo no sishemo kame inatundu ku tifoso no kupula mi kame ina bwele mu kututenda aa no kuluka! ");
INSERT INTO lyn_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Nji mulibaka no mubonda no munu mumweya elifu kame linabusu mulibaka lya woyo omunu mumweya, onene awo nambula esishemo mukupula kwaso, ni mpo no kutenda aa no kuluka, kame saabuse mu moyo mwa yonyene woyo mumweya Jesu Kilesite. ");
INSERT INTO lyn_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Cwalehe, kanyi omubonda no munu mumweya aba ona liti ekatulo eyi iba aanu no kupla omubonda, mu mukwanongeso, okuluka no munu mumweya kame kulitela aanu onje okuluka oko kuba omoyo. ");
INSERT INTO lyn_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Mi kanyi aanu no kupula aba anabeekiwa asi kutenda esibi mulibka no kwaluka kwa munu mumweya, mu mukwanongeso mukuluka kwa munu mumweya aanu no kupula kame satendiwe aa no kuluka. ");
INSERT INTO lyn_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Omulawo nawiyi nji etifoso tipule, kono oko okupula no esibi, esishemo sa Nyambe kame sipula onene ni kubitelela. ");
INSERT INTO lyn_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Nji cwale esibi aba sina busu ni puso no lifu, mu mukwanngeso esishemo sibuse oku tutenda aa no kuluka, ni puso no omoyo no kwaabwa, mwa Jesu Kilesite Ombumu wetu. ");
INSERT INTO lyn_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Cwale iikene satwambe? Cwale tusiekeza okuyoya mu sibi nji esishemo simonahale mukupula. ");
INSERT INTO lyn_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Kokuulwa! Natukufa kulineku no sibi, cwale ngasibine satuyoye musibi? ");
INSERT INTO lyn_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Cwale kamulimukile nji aaci tonje tuna kolobezwa mwa Jesu Kilesite kame tuna kolobeziwa mu lifu lyaye? ");
INSERT INTO lyn_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Natu pumbekiwa cwale naye mu kolobezo no lifu, nji cwale abo Kilesite aba saingulwe kwaafu mu kanya ya Sitetu, naaci kame mba twende mu moyo no ubya. ");
INSERT INTO lyn_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kakuli nji natu kuwana naye mukufa noku kufeka kanyi kwaye, mbatu kuwana naye mukwinguka kwaye. ");
INSERT INTO lyn_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Cwale tulimukile nji ounu wetu no kale kame una kwiibaiwa ni yonyene, nji cwale olutu no sibi lubwe nji tulese okutenda aabika no sibi kame. ");
INSERT INTO lyn_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kakuli nji omunu nafu kame alukuluhile mu sibi. ");
INSERT INTO lyn_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nji natufi ni Kilesite kame tupumena nji mbatwinguka ni yonyene kame. ");
INSERT INTO lyn_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kakuli kame tulimukile nji Kilesite abana kwinguka kwaafu katamba kufa kame, mi elifu kali tamba okwikala ni maata kwa yonyene. ");
INSERT INTO lyn_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Elifu anafu kame anafu kamweya ku sibi sonje, kono omoyo a yoya, kame ayoyela kwa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Yongeso ni kwaanyi, muhupule nji namukufa ku sibi, mi kame muyoye kwa Nyambe mwa Jesu Kilesite. ");
INSERT INTO lyn_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Esibi silese okubusa mu tinyutu tenu nokufa, mulese okuteteta ku titakazo no sibi. ");
INSERT INTO lyn_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Kame mulese okuba esibi kwilama no lutu lwenu nji itende kanyi eyitusiso no kutendisa eyi no kwiiba, kono mukubeeke kwa Nyambe kanyi awo ana tundisiwa ku lufu okuta mu upiplo, nikuba ekalulo no ilama yenu kwa Nyambe nji itende eitusiso no kuluka. ");
INSERT INTO lyn_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Kakuli esibi kasitamba oku tenda Ombumu wowe, kakuli kausamo munji no mulawo wa Mushe kono munji no sishemo. ");
INSERT INTO lyn_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Iikene, cwale? Kana mbatutende esibi kakuli kame tuli munji no mulawo wa Mushe kono kakuli kame tuli munji no sishemo? Kakukonahala! ");
INSERT INTO lyn_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Cwale kamulimukile nji aba mukutenda aabika no munu oku muyupa, kame muli aabika aye yonyene woyo muyupa, simba abika no sibi esi sitwala ku lifu, simba ku likute eli litwala ku kuluka. ");
INSERT INTO lyn_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Kono kame tukutumela kwa Nyambe simba nji kame tuli aabika no sibi kame muna kukuteka etuto eyo muna kubiwa. ");
INSERT INTO lyn_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Namu lukululwa ku sibi mi sebeli muli aabika kweyi no kuluka. ");
INSERT INTO lyn_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Kame naamba mu mukwa no ounu, mulibaka no kufokola mu ku yupisisa kwenu. Ba weeli namu kutenda aabika kweyi no kwiiba, oku yoya omoyo no kwiiba. Cwalehe mukutende aabika no kuluka nji mukenisiwe. ");
INSERT INTO lyn_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Aba muna kwikalanga aabika no sibi, namu kulukuluha kweyi no kuluka. ");
INSERT INTO lyn_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Cwalehe omupuzo muna kuwanabo munako eyo ubine ku inu eyo imyenisa bano? Einu eyo kame imitwala ku lufu! ");
INSERT INTO lyn_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Kono cwale namukulukululwa kusibi, sebeli muli aabika a Nyambe, mi omupuzo munawana kame umitwale ku kukena, mi amamaneneno ni moyo na kwaabwa. ");
INSERT INTO lyn_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kakuli omupuzo no sibi nikufa, kono empo no sishemo sa Nyambe nikuyoya nokwabwa mulibaka lya Jesu Kilesite Ombumu weetu. ");
INSERT INTO lyn_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Abange kamulimukile, kakuli kame naamba kwaawo alimukile omulawo nji omulawo kame obusa omunu abo yosiyoya. ");
INSERT INTO lyn_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Mulibakaelyo, omukati no ku kwala kame anungilwi kwa mbumwaye mulibaka no mulawo yosiyoya, kono nji mbumwaye nafu, na lukululwa ku mulawo owo umununga kwa mbumwaye, ");
INSERT INTO lyn_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","cwale kame saisaniwe omubuki aba sakwale ku mulume mundina nji mbumwaye yosiyoya. kono nji mbumwaye nafu, na lukuluka ku mulawo owo, mi nji akwale ku mulume mundina kaisanwa nji mubuki. ");
INSERT INTO lyn_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Abange naanyi ngeso, namufu kulineku no mulawo mu lutu lwa Kilesite nji cwale mutende ano munjili, awoyo yonyene ona ingulwa kwaafu nji tubeekele Nyambe emiselo. ");
INSERT INTO lyn_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Kakuli abo tusiyoya mu nyama, etikezo tetu no kwiiba kame tina ku sebezanga mu ilama yetu, mi naiku litanga elifu. ");
INSERT INTO lyn_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Kono cwale, natu lukuluha ku mulawo, kakuli natufu ku onyene onakutu nunganga, nji tusebeleze Nyambe mu mukwa no ubya no mebo, kasa mu mukwa no kale no taku ina ng'oliwa. ");
INSERT INTO lyn_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Cwale iikene satwambe? nji omulawo ni sibi? Kokuulwa! Kono kwaulu omulawo kambe kanisi limuka esibi. Kwaulu omulawo waambe nji, “Olese oku lakaza,” kambe kanisi limuka oku lakaza. ");
INSERT INTO lyn_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Kono esibi nasiwana omukwa mi nasiingene mwa mene mukulaelwa, etitakazo tonje. Kakuli oko kuulwile omulawo, esibi nasifu. ");
INSERT INTO lyn_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Mene kame ina kuyoya okuulwile omulawo, kono etaelo aba ina kwiiya, esibi sebeli siinguka, mi mene sebeli nifa. ");
INSERT INTO lyn_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Etaelo inakuni sepisa omoyo, sebeli iwaniwa nji kame initwala ku lifu. ");
INSERT INTO lyn_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Kakuli esibi nasiwana esibaka oku nionga mu taelo, mi sebeli nifa mwa yonyene eyo etaelo. ");
INSERT INTO lyn_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Onyene omulawo niwakukena, niyonyene etaelo niyakukena, no kuluka, no kuwaaba. ");
INSERT INTO lyn_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Cwalehe, esinu no kuwaba nasiliti olufu kwa meme? Kokuulwa! neli esibi sina sebeze elifu kwa mene mu sinu esi no kuwaba nji simonahale nji ni sibi, nji mulibaka no taelo esibi nasi futuka esinu no kwiiba oku manenena onene luli. ");
INSERT INTO lyn_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Tulimukile nji omulawowa Mushe niwa mebo, kono mene kaniwa mebo, kame nina ulisiwa kanyi omubika no sibi. ");
INSERT INTO lyn_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Siyupisisa eso ni tenda, kakuli sitende eso ni saela, kono kame nitenda eso ni timbile. ");
INSERT INTO lyn_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Cwale nji ni tende eso ni ulwa okusinga, kame ni pumena nji omulawo niwa kuwaba. ");
INSERT INTO lyn_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Abo cwale kasa mene luli nitenda ngeeso, kono ni sibi eso sili mwa mene. ");
INSERT INTO lyn_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Kakuli kame nilimukile nji ouwa kausako mwa mene, mi mbili muunu feela, kakuli okusinga mwakuli mwa mene, kono sitwese okutenda ouwa. ");
INSERT INTO lyn_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Kakuli sitende ouwa ni singa, kono ouyi nitimbile wani twalelela oku tenda. ");
INSERT INTO lyn_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Cwale nji kame nitenda eyo nitimbile, kasa mene otenda ngeeso, kono ni sibi eso sili mwa mene. ");
INSERT INTO lyn_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Cwale kame niwana nji aba nisinga okutenda esino kuwaba, ouyi wokame oli kwa mene. ");
INSERT INTO lyn_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Kame ni lakaza omulawo wa Nyambe mu munu woyo oli mukaci no mucima wange. ");
INSERT INTO lyn_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Kono kameni mwine omulawo wa Mushe mundina mu ilama yange owo ukulwisa ni mulawo no ku yupisisa kwange, mi kame unitwala mu ubika no mulawo no sibi owo oli mu ilama yange. ");
INSERT INTO lyn_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Mbili munu no umayi no ngasibine? anyine soni tundisa mu lutu luno lunitwa ku lifu? ");
INSERT INTO lyn_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Kame niku tumela kwa Nyambe mwa Jesu Kilesite Ombumu wetu! Cwale simba mene, kame ni sebeleza omulawo wa Nyambe muku yupisisa kwange, kono mu nyama kame ni sebeleza omulawo no sibi. ");
INSERT INTO lyn_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Kakwisa katulo cwale kwaa aikalile kwa Jesu Kilesite. ");
INSERT INTO lyn_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kakuli omulawo no mebo no omoyo ou uli kwa Jesu Kilesite kame unani liulula ku mulawo no sibi ni lifu. ");
INSERT INTO lyn_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Kakuli Nyambe natende eso sina kukwangwiwa ku mulawo wa Mushe, mulibaka no kufokola ku unu. Kame ana atula esibi muunu mu kutuma Mwanaye mulibaka no sibi, woyo ona kwiya mu unu kanyi omukwa wetu no sibi. ");
INSERT INTO lyn_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Nyambe nakutenda ngeeso nji esi silaelelwa mu mulawo wa Mushe siiyatetetwe mwaaci aa aendisiwa ku Mebo kasa mumukwa noun. ");
INSERT INTO lyn_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Kakuli awo ayoya mu mukwa nounu kame atwala emihupulo yoo kweyi nounu, kono ao ayoya mu mebo kame atwala emihupulo yoo kweyi no mebo. ");
INSERT INTO lyn_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kakuli awo ayoya mu mukwa nounu kame ku twala ku lifu, kono awo ayupa eyi no mebo kame ku twala ku omoyo ni kozo. ");
INSERT INTO lyn_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Kakuli awo ayupa eyi nounu kame atimbile Nyambe, kakuwana ni mulawo wa Nyambe, mane kaatwese luli. ");
INSERT INTO lyn_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Cwale awo aendisiwa muunu katwese oku wabelisa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Kono anyi kamufanene okuyoya muunu, kakuli kame muli mu mebo, mi luli Emebo ya Nyambe kame ili mwaanyi. Omunu yonje nji kakwite Emebo ya Kilesite kaasa waye. ");
INSERT INTO lyn_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Kono nji Kilesite kame ali mwaanyi, simba nji etinyutu tenu natifi mulibaka no sibi, Emebo yenu kame iyoya mulibaka no kuluka balubala wa Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Cwale Emebo ya woyo ona ingula Jesu kwaafu nji kame ili mwaanyi, yonyene woyo ona ingula Jesu Kilesite kwaafu mbabi omoyo ku tinyutu tenu eti tifa mu mebo yaye eyi iyakile mwaanyi. ");
INSERT INTO lyn_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Cwalehe, abaange, kame tufanena okuyoya kanyi Emebo omo itu ambelela okuyoya, kono kasa okuyoya omo tusingela aaci. ");
INSERT INTO lyn_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kakuli aba mu yoya mu ku kon̄elela etitakazo no lutu lwenu, mba mufu, kono nji kame mwibaa emisebezi no lutu mulibaka no mebo, mba mu yoyo. ");
INSERT INTO lyn_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kakuli onje awo aendisiwa ku mebo ya Nyambe, ao naana a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Abo kamwasi tambula Emebo eyo imiingenyeka mu ubika nji mucile, kono kame muna tambula Emebo imi tenda aana a Nyambe, kakuli na mutambula Emebo eyi yang'ula, eyo mwa yonyene aba tulilaa nji, “Abba, Sitetu!” ");
INSERT INTO lyn_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Yo kame Emebo eyi ikupakela ni mebo yetu nji kame tuli aana a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Mi cwale nji kame tuli aana a Nyambe, mba tuli naaci esanda, tulye esanda sa Nyambe ni Kilesite nji kame tuyanda naye nji tuwane ekanya ni yonyene. ");
INSERT INTO lyn_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Kame ninahana nji amayando no ba nako ino kalukele okubapanywa ni kanya eyo saimonahale kwaaci. ");
INSERT INTO lyn_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Kakuli eyumbiwa yonje kame itatelele mu kushukela onene okushotolwa no aana a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kakuli eyo ina ku umbiwa, kame ina ku bekiwa mu puso eino mapwa, ka sa mu ku singa kwayo, kono mu kusinga kwa woyo ona kuibeekamo mu sepo, ");
INSERT INTO lyn_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","nji eyumbiwa ni yonyene kame sailukululwe mu ubika no koola nji ibiwe etukuluho no kanya ya aana a Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kame tu limukile nji eyumbiwa yonje kame itonga bamweya naaci mi kame iyupa okukola no kuleya ni balelo lino. ");
INSERT INTO lyn_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Mi kasa eyumbiwa fela, kono naaci, aa ali omuselo no weeli no mebo naaci kame tutonga me tu tatelele onene okutenda aana, mane ni kuliululwa ku tiyutu tetu. ");
INSERT INTO lyn_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kakuli mu sepo eyi natu yoyisiwa. Cwale esepo eyo imonahala cwale sebeli kasa sepo, kakuli anyine so sepa eyi amona? ");
INSERT INTO lyn_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Kono aba tu sepa eyi twasimona, kame tu si tatelele onene mu kukoongota. ");
INSERT INTO lyn_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Mu mukwanongeso Emebo no kukena kame itutusa mu kufokola kwetu, kakuli katuyii omo tufanena okulapelela, kono Emebo yonyene kame itu lapelela mu sitongo ni maywi ao ka twesiwa okutaluswa. ");
INSERT INTO lyn_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Cwale yonyene woyo otatuba emicima no aanu, kame alimukile emihupulo no mebo kakuli Emebo kame ilemine oku lapelela aanu a Nyambe, okukumanena ni tato ya Nyambe. ");
INSERT INTO lyn_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Kame tu limukile nji einu yonje kame ibelekisana bamweya okulita ouwa kwaawo asinga Nyambe, onyene awo ana isaniwa okwamana mu mulelo waye. ");
INSERT INTO lyn_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Kakuli awo ana kuketa oweli, nakwataba kame okwatenda aa afekile kanyi Mwanaye, nji atende yokame omweeli kwaainaye no kupula. ");
INSERT INTO lyn_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Cwale awo ana ku ketiwa, na kwaaisana, mi awo ana kwisaniwa nakwabeeka ano kuluka, mi awo abeekilwe okuluka, naabi ekanya yaye. ");
INSERT INTO lyn_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Cwale ikene sa twaambe kweeyi? Cwale nji Nyambe kame ali kwaaci, anyine sotu lwisa? ");
INSERT INTO lyn_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Yonyene woyo wasikukatwa mwanaye luli kono nakutubaye aaci toonje, cwale ngasibine satende, kana katamba okutuba einu yonje ni yonyene? ");
INSERT INTO lyn_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Anyine so lita ekatulo okulwisa awo ana ketiwa kwa Nyambe? Yonyene Nyambe onaa tende aa sikuluka! ");
INSERT INTO lyn_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Anyine, cwale so twesa okwaatula? Kasako, kakuli Jesu Kilesite ona kufa, eeni, mane naingulwa kwaafu, woyo oli ku lyoko no silyo lya N