﻿USE sofia;
DROP TABLE IF EXISTS sofia.lww_vpl;
CREATE TABLE lww_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lww_vpl WRITE;
INSERT INTO lww_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kristo naga molue kome lus na yermarua keviu lalua kiena ne repina ne le Yu lala, nane Epraam naga sumo, amio Tepet nap̃a naga sirau. Repina ne Yesu la punu ga, la kiela kia sanini: ");
INSERT INTO lww_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Epraam naga narina nap̃a Aisak. Aisak naga narina nap̃a Sekop. Sekop naga narina nap̃a Suta, amio wenla tap̃ena lala. ");
INSERT INTO lww_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Suta naga narina lua, Peres amio wenla Saera, nap̃a lalua na ape kaora, nap̃a lalua na anela nap̃a Tam̃a. Peres naga narina nap̃a Esron. Esron naga narina nap̃a Ram. ");
INSERT INTO lww_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram naga narina nap̃a Aminatap. Aminatap naga narina nap̃a Nason. Nason naga narina nap̃a Salom. ");
INSERT INTO lww_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salom naga narina nap̃a Poas, a Poas nene nap̃a naga anena Reap. Poas naga narina nap̃a Opet, a Opet nene nap̃a naga anena Rut. Opet naga narina nap̃a Sese. ");
INSERT INTO lww_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Sese naga narina nap̃a Tepet, a Tepet nene nap̃a naga pe p̃arin sup̃e kiena ne le Israel lala. Tepet naga narina nap̃a Solomon, a Solomon nene nap̃a anena, naga wona ne Uraea na sumo. ");
INSERT INTO lww_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon naga narina nap̃a Reopoam. Reopoam naga narina nap̃a Apia. Apia naga narina nap̃a Asa. ");
INSERT INTO lww_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa naga narina nap̃a Seosepat. Seosepat naga narina nap̃a Soram. Soram naga narina nap̃a Usaea. ");
INSERT INTO lww_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaea naga narina nap̃a Sotam. Sotam naga narina nap̃a Eas. Eas naga narina nap̃a Isakaea. ");
INSERT INTO lww_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Isakaea naga narina nap̃a Manasa. Manasa naga narina nap̃a Amon. Amon naga narina nap̃a Sosaea. ");
INSERT INTO lww_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sosaea naga narina nap̃a Sekonaea, amio wenla lala. Ana e pogos kiena ne la nene narui, yaru lala na purvanua tap̃ena nap̃a P̃apilon apanon ap̃ure plan le Israel lala ava ayum̃ae korena garu P̃apilon. ");
INSERT INTO lww_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Sekonaea naga narina nap̃a Seltiel, nane pogos nap̃a le Israel lala amiyum̃ae korena ke garu P̃apilon wa. Seltiel naga narina nap̃a Serup̃apel. ");
INSERT INTO lww_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serup̃apel naga narina nap̃a Apiut. Apiut naga narina nap̃a Eliakim. Eliakim naga narina nap̃a Aso. ");
INSERT INTO lww_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso naga narina nap̃a Satok. Satok naga narina nap̃a Akim. Akim naga narina nap̃a Eliut. ");
INSERT INTO lww_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut naga narina nap̃a Eliesa. Eliesa naga narina nap̃a Matan. Matan naga narina nap̃a Sekop. ");
INSERT INTO lww_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Sekop naga narina nap̃a Yosop, nap̃a wona ne Maria. Maria nene, naga anenane Yesu, nap̃a apisape naga pe Navisaarena. ");
INSERT INTO lww_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Siar e Epraam, teras lelei lala pimi tol Tepet, teras la nene tol lualima taaga pa vari. A siar e Tepet pimi tol pogos nap̃a le P̃apilon lala ap̃ure plan le Israel lala avanon ayum̃ae korena garu P̃apilon, teras lelei lala tol m̃ena ga lualima taaga pa vari, a siar e pogos nap̃a la asike garu P̃apilon, pimi tol Kristo, teras lelei lala tol ke sina ga lualima taaga pa vari. ");
INSERT INTO lww_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Suniena nini kiena ne Yesu Kristo, nap̃a naga paeme sanape, naga sanini: naga anena, sira nap̃a Maria, nap̃a la apisaaria sumo asape yokorena talopa amio yaru tai, kiena kia Yosop. Ana pogos nap̃a lalua pe atalopa re poli wa, Maria naga mlogekilale nap̃a naga m̃ep̃ena, na pimi kome Ninuna Wa. ");
INSERT INTO lww_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A Yosop nap̃a la apisaaria apisape yokorena naga talopa amio Maria nene, naga pe yaru wo tai, a naga pe pisa re pisape Maria naga kila suri tai piowa poli. Ana naga pisu sane p̃isi na lalua na monar akilaro kiela navisaarena nene, ana naga sitom ke pisape kila ga e p̃elaga tai nap̃a malumu ga, vanon nap̃a naga yepen mavin kilaen Maria memawa manenea vanon suri nene. ");
INSERT INTO lww_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","A pogos nap̃a naga sitom ke sape kila sanene, naga m̃enia, pisu navisi tai kiena ne Ntewa m̃alivin naga, ana navisi nene pisa pania, pisape “Yosop, ko lus kiena ne Tepet, ko na ve ologe re viowagan nap̃a oure Maria ve wom̃a, vanon sisi nap̃a teke e naga, naga pimi ga kome Ninuna Wa. ");
INSERT INTO lww_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yokorena Maria war narina yerm̃ene, a monar osikia kiena kia Yesu Natamaliaena, vanon yokorena naga warplan mlamulena viowa lala vetan kiena yeririna lala.” ");
INSERT INTO lww_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ana suri la nene pimi kakate sanene, vena kila visena kiena ne Ntewa tai vim ve lelaga, sa nap̃a Navisawalena Aisea naga pisawal sumo, ");
INSERT INTO lww_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","nap̃a naga pisape “Yokorena sira m̃ee tai nap̃a yerm̃ene pe pisu re poli wa, naga m̃ep̃ena, p̃isi na war narina tai ve yerm̃ene, ana p̃isi na asikia kiena kia ve ‘Emanuel.’” Kia nap̃a “Emanuel” naga kana kinas sane “Ntewa sike amio ita.” ");
INSERT INTO lww_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pogos nap̃a Yosop tavilo sina, kila sa nap̃a navisi kiena ne Ntewa pisa pania, ana naga talopa amio Maria, p̃ere pe wona. ");
INSERT INTO lww_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ana pe pa pisu re Maria tol pogos nap̃a Maria p̃arlua narina nene. A pogos nap̃a Maria p̃arlua sisi nene, ana Yosop sikia kiena kia “Yesu.” ");
INSERT INTO lww_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu naga paeme e pulkumali tai, kiena kia Petleem, lepas nae Yutea. E pogos nap̃a Yesu paeme, Erot naga pe p̃arin sup̃e kiena ne le Yu ke lala. A siraunia, pe piavi re nena poli, ana yaru la p̃asia nap̃a la akilia ruru p̃elaga kiena ne verue la po pap̃isi, apimi atol garu Yerusalem. Susumo la nene amolue e kiela purvanua, e lepas nap̃a mrae molue ke komea, ana apimi. ");
INSERT INTO lww_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ana la apiun tan yaru lala, asape “?Sisi nap̃a paeme mare ga na wa, nap̃a asape p̃isi na naga vim ve p̃arin sup̃e kiena ne le Yu lala, naga m̃eke pe? Imimi mom̃al kiena verue rui, molue ke e yo nap̃a mrae molue ea, ana imimi mepimin ke mesape meieluar naga.” ");
INSERT INTO lww_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ana pogos nap̃a P̃arin Sup̃e Erot tol visena la nene, amio yaru tap̃ena lap̃asia nae Yerusalem, amloge, ana la pe akekaran re nena ga. ");
INSERT INTO lww_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ana Erot pio yerkawa kiena ne yaru wa lala amio navianena navisaluaena lala apimi apisuia, ana naga piun tan la, pisape “?Navisaarena nap̃a apisape p̃isi na naga imi, la apisa ke asape p̃isi na naga vaeme pe?” ");
INSERT INTO lww_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","La nap̃ani apisatam̃ea, asape “Yokorena Navisaarena naga vaeme garu lepas nae Yutea, e pulkumali nap̃a Petleem. ");
INSERT INTO lww_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nanene vanon nap̃a sumo na, navisawalena tai siriyuia, pisape ‘Ntewa naga pisa sanini, pisape “Amiu nae kumali nap̃a Petleem, amiu tap̃atete avisavenua, yerkawa tap̃ena nae Yutea lala, la atola metavan amiu, ana amiu na ato ga tano, peraga, vanon yokorena nasumonena keviu tai molue nenaga kom pun amiu, ana naga visuar ruru kiau yeririna lala nae Israel.” ’” ");
INSERT INTO lww_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","P̃isi na P̃arin Sup̃e Erot naga pio vinaun ga yaru na kilia ruruen p̃elaga kiena ne verue la nene, vena aimi avis ga amio naga taaga, vena naga loge ruru tan la, pisape la apisu verue nap̃ani kate na pogwai. ");
INSERT INTO lww_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ana naga pisa pan la, pisape “Amiu na monar ava akale sisi nene vano-o alualia, ana awasup̃e si aimi avisawal van inu, vena inu m̃ena ga nevano neieluar naga,” ana naga mligan la apa garu Petleem. Ana kiena visena nene nap̃a naga pisa ana pisokan ga, naga sinenan pisape visae lual sisi tomtom nene, ana wem̃aria. ");
INSERT INTO lww_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ana yaru la nene la amloge visena kiena ne p̃arin sup̃e nene p̃isi, ana apa sina ga e kiela mraplepa, ana apisu sina verue nene nap̃a tego p̃esia e lepas nap̃a mrae molue ke komea. Pogos nap̃a la apisu si verue nene, akekara pap̃isi, ana verue nap̃a naga sumon la m̃a ga pano-o atol e nap̃a sisi nene m̃eke ea. ");
INSERT INTO lww_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ana la apa loyum̃a e yum̃a nene, apisu sisi nene, amio anena nap̃a Maria. Ana la akinai, amieluar naga. A la apikep̃a kiela karo lala, ap̃ar plan kiena nalaena la pania, suri tai nap̃a kol, amio suri lalua nap̃a ponos taninu po pap̃isi sa nap̃a m̃ap̃es, nap̃a kiela kia prakensis, amio mer, nap̃a mer nene naga kana kilavaru keviu pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ana kolemalo, Ntewa pisi pan la e m̃eniena tai, pisalup̃ar la pisape “Ve ava akom re si lepas nap̃a puna ne Erot.” Ana la amligan yo nene, ap̃asup̃ela ke sina ga, akome mrapa tap̃ena apa kiela. ");
INSERT INTO lww_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pogos nap̃a yaru la nene amial rui, ana Yosop m̃enia m̃a navisi kiena ne Ntewa tai pimi puna, pisa pania pisape “Yosop, osum̃alu, owar ninis nene amio anena, amiu aure ava garu Isip, vanon lavisi ke P̃arin Sup̃e Erot kale ninis tomtom nene vena wem̃ar narui. Ava asum̃a garu Isip vano-o tol pogos nap̃a nevisa van ko, ana awasup̃e amiu si aimi.” ");
INSERT INTO lww_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ana Yosop mlogear visena kiena navisi nap̃ani, ana sum̃alu p̃arlua ninis tomtom nene amio anena, ana amligan plan ke e yemalo nene, ana amialin ke ava garu Isip. ");
INSERT INTO lww_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ana la apa asum̃a garu Isip yam piavi li m̃a ga, pano-o tol pogos nap̃a P̃arin Sup̃e Erot mare. Suri la nene pimi kakate sanene, vena kila visena kiena ne Ntewa tai nap̃a Navisawalena Osea naga pisawal nanua sumo vena vim ve lelaga, nap̃a naga sapenua “Naruu na yerm̃ene sike garu Isip, ana nevio naga wasup̃e imi.” ");
INSERT INTO lww_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pogos nap̃a P̃arin Sup̃e Erot naga kilia sape yaru nakilia ruruen p̃elaga kiena ne verue lala pe akila re sa nap̃a naga pisa poli, pe apimi akom re si puna poli, ana naga sinena mimi pap̃isi, ana naga pisa pan kiena yaru na mara lala, pisape “Ava akale ninis la punu ga nap̃a ape yerm̃ene asike Petleem, a la m̃ena ga nap̃a asike lavisinia, la nap̃a pe kiela kas lua re poli wa, ana awe mom̃ar la make ga amarmare.” P̃arin Sup̃e nene naga polo pogos nene sanini, vanon mloge visena tan yaru la nene, nap̃a apisawal mesmesun pania nanua e pogos nap̃a verue nene katep̃esia. ");
INSERT INTO lww_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Suri la nene kila visena nap̃a Navisawalena Serem̃aea naga pisa sumo pimi pe lelaga, nap̃a naga pisape ");
INSERT INTO lww_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Le Ram̃a lala amloge sira nae pula tai tagi na tagi, naga mloge piowa pap̃isi, sira nene naga Resel, nap̃a naga tagin ke mapina lala. Ana naga yepena mavin yaru tai kila lup̃elup̃eena vena loge wo sina, vanon mapina la akokovio make p̃isi rui.” ");
INSERT INTO lww_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ana pogos nap̃a Yosop lala asike garu Isip wa, ana P̃arin Sup̃e Erot naga mare. Ana Yosop m̃enia, pisu sina navisi kiena ne Ntewa tai pimi puna, ");
INSERT INTO lww_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ana navisi nene pisa pania, pisape “Yosop, osum̃alu, oure ninis nene amio anena, awasup̃e amiu si, ava garu kiamiu purvanua nap̃a Israel, vanon P̃arin Sup̃e Erot nene nap̃a naga sape wem̃ar ninis nene, naga mare rui.” ");
INSERT INTO lww_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ana Yosop naga mlogear visena nene, naga sum̃alu, p̃ar ninis nene amio anena, ap̃asup̃ela ke sina ga apa e kiela purvanua nap̃a Israel. ");
INSERT INTO lww_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pogos nap̃a la amialin ke asape ava tol garu Yutea, ana Yosop mloge asape Akaleas kus ke lelena ne arimana nap̃a Erot, pe p̃arin sup̃e ke garu Yutea. Ana Yosop maraun si vaen garu Yutea, ana naga m̃eni si tai, m̃al Ntewa naga pisi pania, pisalup̃ar pisape “Ve ova re si garu Yutea,” ana Yosop lala apalein e yo tap̃ena tai, kiena kia Kalele. ");
INSERT INTO lww_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ana la apa asike e kumali tai e lepas nene, kiena kia Nasaret. Suri nene pimi kate sanene vena kila visena kiena ne navisawalena lala vim ve lelaga, nap̃a la apisayu Navisaarena nanua sumo rui, nap̃a la apisa apisapenua “Yokorena, lala avisave naga ve yaru nae Nasaret tai.” ");
INSERT INTO lww_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yesu naga kapuru pimi keviu, gar ga Nasaret, ana e pogos ke nene narui, Yoane Nakeena naga pimi p̃arpoyo e yokorena e lepas nae Yutea, ana naga sum̃a mlologon ke, pisapenua ");
INSERT INTO lww_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Amiu na monar avilopu amiu, vanon Nasup̃enena kiena ne Ntewa pimi ke narui.” ");
INSERT INTO lww_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yoane Nakeena nene naga pe yaru nap̃a Navisawalena Aisea pisawal nanua sumo rui, nap̃a naga pisa, pisapenua “Pulgon yaru tai sum̃a pio ke e yokorena, pisape ‘Amiu akila ruru make mrapa kiena ne Ntewa, vena naga kilia imi m̃alivi e kiamiu malena lala.’” ");
INSERT INTO lww_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoane Nakeena nene naga sane Navisawalena Elaisa nene nanua sumo, sa nap̃a naga pe miyen re kulsota nap̃a po poli, m̃ana kulsota na ape ga e vilulus nen kamel, a kiena kilika na kararen m̃ep̃ena na amiyum̃aen ga e kulus nen puluk. A kana kinanena e yokorena, kan ga narin suri la nap̃a asape kurpo ne, amio suri kiki nap̃a sukapak tetan la amiyum̃aenia. ");
INSERT INTO lww_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Naga sum̃a e yokorena nene pano pano-o, ana yeririna nae Yerusalem lala amio m̃ena ga pulkumali tap̃ena lala nae lepas nap̃a Yutea, a pulkumali m̃ena ga la nap̃a lavisin wii nae Yortan, la apanon apisu naga. ");
INSERT INTO lww_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","La amiyagogon kiena lologena lala, a la apisa plan kiela mlamulena viowa lala pania, ana Yoane kela e wii nae Yortan. ");
INSERT INTO lww_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ana e pogos tai, Yoane pisu nap̃a yeririna la moki na p̃egas nalotena lua nene kiena ne le Yu lala, nap̃a Varasi lala amio Satusi lala, la apimin ke nap̃a naga ke la, ana naga pisi m̃arera pan la, pisape “?Amiu na sane lom̃ara lala, nap̃a la amaraun kapi tai ana la ap̃ure, ana amiu na asitom asape akilia aurmatan kapi nap̃a Ntewa naga p̃isi na ligan imi, nap̃a pe amiu apilon amiu re poli wa? ");
INSERT INTO lww_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ana visae ve lelaga kemua nap̃a amiu amaraun nakoaena nene, ana kiamiu malena naga monar war mras la nap̃a powo, nap̃a torokin kiamiu navilopuena nene. ");
INSERT INTO lww_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ana avisuar amiu, popon amiu na ve awarwar amiu re sina, sa nap̃a asum̃a akila ke rui, nap̃a apisa ke asape ‘A, ita na poga ga rui, okilakan ita na tepe lus ruru kemua kiena ne yermarua Epraam.’ Ana nanene na pe suri re tai nene poli, vanon visae Ntewa naga sinenania, naga kilia la ga kilavaru la nene, kila la aimi ave lus kiena ne Epraam la ve moki, vena akus lelemiu. ");
INSERT INTO lww_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nevisa van amiu, nesape m̃ekiavi mon ruru rui pisape teroro purlaki la nap̃a pe p̃ar re mras wo poli, ana yokorena ateroro la ana akoven la ava e kapi. ");
INSERT INTO lww_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","In na nepimi sumo, ana nekee amiu ke ga e wii, vena kila merarava sa nap̃a amiu apilopu amiu rui, ana yaru tap̃ena tai naga pimi ke siraun inu wa. Yaru nene, naga to laa metavan inu, a in na nepiowa ga, netorokin re nowar plan kiena kulus nen lana poli, pona nekilia nekila kiena yum̃aena tap̃ena lala. Ana naga ke narui, naga kilia kee amiu e Ninuna Wa, amio kana kapi nena, vena kekan plan kororaki lala e kiamiu malena lala. ");
INSERT INTO lww_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Naga na sane mlarar ke koruak nayuraren wit e limana, ana sisilin plan mrasa la akekapil vito lele tap̃ena, a vinus vito lele tap̃ena, ana war plan mrasa va um̃a m̃ana, a yokorena naga kilia kuan vinusa va e kapi nap̃a tap̃atete mare pogos tai.” ");
INSERT INTO lww_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ana Yesu mligan lepas nap̃a garo Kalele, pam e wii nae Yortan vena Yoane ke naga. ");
INSERT INTO lww_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ana Yoane pisape visalup̃aria, pisapenua “?Sanape na ko opamin osape nekee ko? Suri nene na pe mesmesu re poli. Popon ga ko na okee inu.” ");
INSERT INTO lww_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ana Yesu pisatam̃ea, pisape “Peraga, p̃isi na ve ve sa re nene, popon ita na tetam̃an ga tetaveve suri wo la nap̃a Ntewa naga sinenania sape tekila.” Ana Yoane tam̃an Yesu pimi puna, ana kea. ");
INSERT INTO lww_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ana pogos nap̃a naga ke p̃isi, Yesu naga molue e wii pa metava, ana veraga ma e peni pietava pania, ana naga m̃al Ninuna ne Ntewa pitomi ke tano sa nap̃a lom̃e, pitomi tol Yesu. ");
INSERT INTO lww_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ana la amloge Ntewa nae ma e peni pisi pitomi tano, pisape “Nene na naruu ne, nap̃a nesitom naga pap̃isi. Kiau sitomena teke ga e naga, a nekekaran naga pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Suraun nap̃a Yoane Nakeena kee Yesu p̃isi, ana Ninuna Wa naga sumon Yesu pa e yokorena tai, vena Yermare tap̃ali naga. ");
INSERT INTO lww_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ana e pogos nene, Yesu monsilun leniena tol legiena lualima vari a lemalo m̃ena ga lualima vari, a siraunia naga viso kari pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ana Yermare, yaru na tap̃alien yeririna lala, pimi pisa pania, pisape “Visae ko na ope narina ne Ntewa kemua lelaga, ko ovisali van kilavaru la nene aimi ave kilaparavi, vena okan tai.” ");
INSERT INTO lww_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ana Yesu pisa pania, pisape “Peraga, vanon Visena Wa pisa sanini pisape ‘Kinanena ga tap̃atete kila yaru mali, ana visena punu ga nap̃a Ntewa pisa, naga ga nene kilia kila yaru mali.’” ");
INSERT INTO lww_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ana Yermare pisape wereli sina ga sitomena kiena Yesu va garu e Yum̃a Wa nap̃a garu Yerusalem, ana mligan naga sike e yo tai nap̃a pa manene metava pap̃isi e wosoyum̃a M̃ana Ntewa. ");
INSERT INTO lww_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ana naga pisa pania, pisape “Visae ko ope narina ne Ntewa kemua lelaga, ko oula, oto tano e nene. Ana yoko ko okila woga ga ne, vanon Visena Wa pisayu Ntewa, pisape ‘Naga yoko ligan kiena navisi lala aimi avisuar ko m̃aga, ana la ayukop yaun ko ga om̃eke metava e limala, vena ve owan re lam̃a e kilavaru tai.’” ");
INSERT INTO lww_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ana Yesu pisatam̃e ke sina ga Yermare, pisa pisape “Peraga, vanon Visena Wa pisa m̃ena ga sanini, pisape ‘Ko na tap̃atete otap̃ali kiom̃a Sup̃e Ntewa, nap̃a otap̃ali om̃areran osape naga kila kiom̃a suri tai.’” ");
INSERT INTO lww_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Naga na, Yermare p̃ere ke sina ga sitomena kiena Yesu pa metava e pupia kunus tai, pisape “Visae ova ose kunus nene, okira vito tano ovisu purvanua kerkeviu la ne sike e yomarava nini, amio kala suri wo la nap̃a asike ea.” ");
INSERT INTO lww_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ana tap̃ali ke sina ga Yesu yam telu narui, pisa pania, pisape “Suri punu la nene na yokorena netam̃an van ko, visae okinai olotun inu.” ");
INSERT INTO lww_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ana Yesu pisatam̃ea, pisa pisape “Ko oure, Yermare. Visena Wa pisa sanini, pisape ‘P̃isi na monar olotun ga Ntewa naga taaga, nap̃a pe kiom̃a Sup̃e, a okila ga kiena yum̃aena naga taaga.’” ");
INSERT INTO lww_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ana Yermare purmatan Yesu, ana navisi la apitomi, apisuar ke naga. ");
INSERT INTO lww_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ana e pogos nene, li na mara lala kiena P̃arin Sup̃e Erot la atarar Yoane Nakeena, amligan naga pa e yum̃a nakoaena. Ana pogos nap̃a Yesu mloge nalogeena nene, naga sitom sape wasup̃e si vito garo Kalele. ");
INSERT INTO lww_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A pogos nap̃a naga p̃asup̃e si pito garo Kalele, ana naga pe pa re si garo Nasaret poli, naga pito la garo Kapeneam rui, pulkumali nap̃a m̃eke lavisin lapa nae Kalele. Yo la nap̃a siar Kalele pito tol yo losi, yo la nene porotano kiena ne lus lalua kiena yermarua lalua na nanua sumo, Sepulan amio Naptali. ");
INSERT INTO lww_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Suri nene pimi m̃alivi vena kila visena kiena ne Ntewa nene vim ve lelaga, sa nap̃a Navisawalena Aisea naga pisawal sumo rui, nap̃a pisape ");
INSERT INTO lww_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Amiu yaru lala nae yo kiena ne Sepulan amio yaru lala nae yo kiena ne Naptali, nap̃a asike likan wii nae Yortan amio pupia sive, amiu yaru la nae garo Kalele, e lelen yaru la moki nap̃a pe ape le Yu re poli asike ea, amiu aloge visena nini: ");
INSERT INTO lww_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yeririna la nap̃a asike e yemalolo, p̃isi na alual pupia yomerarava tai. La nene asuke ga e yemalolo silaga, nap̃a la na ape namarena ga, ana pupia yomerarava tai tego pap̃isi pimi tegoli la.” ");
INSERT INTO lww_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ana siar e pogos nene, Yesu sum̃a ga mlologon ke, pisapenua “Amiu na monar avilopu kiamiu sitomena vetan kiamiu mlamulena viowa lala, vanon nap̃a nasup̃enena nae ma e peni pimi ke lavisi narui.” ");
INSERT INTO lww_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ana Yesu sum̃a ga miyaloro ke e isinen pupia lapa nae Kalele, ana m̃al yaru la lua, Saemon Pita amio wenla nap̃a Antru. Lalua asum̃a ga akuan ke lilivi, vanon lalua na ape yaru na wereen ika. ");
INSERT INTO lww_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ana naga pisa pan lalua, pisape “Amiu lua ataveve inu, ave kiau yaru lala, vena nevian amiu ana ave yaru na wereen yaru lala.” ");
INSERT INTO lww_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ana lalua nene amligan kiela lilivi nap̃ani veraga ga, lalua ataveve Yesu. ");
INSERT INTO lww_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ana Yesu mial li ga pa laa sane, m̃al si yaru la lua Semes amio wenla nap̃a Yoane, la lua na la narina ne Sepeti. Lalua asike e kiela los nen wa tai amio arimala, lala asum̃a ga akila ruru ke kiela lilivi. Ana Yesu pio lalua pisape lalua atavevea, ");
INSERT INTO lww_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ana la lua asum̃alu veraga, amligan arimala m̃eke e wa, ana ataveve Yesu apano. ");
INSERT INTO lww_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ana Yesu miyaloro ke pa e yo punu ga garu Kalele, pian ke le Yu lala e loyum̃a e kiela yum̃a na lotuena lala. Ana naga pisawal ke nalologena wo nene nasup̃enena kiena ne Ntewa, a kila ruru ke yaru la nap̃a maiena sike e yepela, a kila yaru la nap̃a yepela lap̃as malmalumu, apimi amloge po sina. ");
INSERT INTO lww_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ana la asunyu kia kiena Yesu pa kalo m̃ena yo punu ga e lepas nap̃a Kalele na vito tano, nap̃a apio asape Seria. Ana la ap̃ure yaru la nap̃a amai e yo punu ga nene apimi puna Yesu. La nene, lap̃asia nap̃a amai, lap̃asia nap̃a magka kar kare la amloge piowa pap̃isi, lap̃as nap̃a yermare la asike e la, lap̃as nap̃a amarmarelu ke lala, a lap̃asia nap̃a yepela lap̃asia marmare, ana Yesu kila ruru punu ga namaiena la nene amloge po sina. ");
INSERT INTO lww_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A yaru la moki pap̃isi nap̃a ataveve Yesu e pogos nene. La nene apimi garu Kalele, a e m̃ena e lepas nap̃a pulkumali lualima sike ea, a garu Yerusalem, a garu lepas tap̃ena lala nae Yutea, a ma m̃ena e lepas nen p̃alu nae Yortan lepas p̃asia na vano. Ana la nae yo la nene apimi ataveve Yesu e pogos nene. ");
INSERT INTO lww_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ana e pogos tai, Yesu pisu yeririna la moki, ana naga pa metava e kunus tai. Sane kiela navianena tai, naga totano ana kiena yeririna lala apimi atovivia, ");
INSERT INTO lww_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ana naga pian la. ");
INSERT INTO lww_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Navianena kerkeviu lap̃asia kiena ne Yesu sanini: naga pisape “La nap̃a apisu kilale nap̃a pe am̃al re Ntewa e kiela malena poli wa, ana p̃isi na navisa ruruena vim van la, vanon Ntewa naga pe P̃arin Sup̃e kiena ne yeririna la ne sanene. ");
INSERT INTO lww_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","La nap̃a suri viowa lala akila kare la ke pap̃isi, a amloge piowa, atagi ke na, ana navisa ruruena vim van la, e nakila lup̃elup̃eena lala. ");
INSERT INTO lww_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","La nap̃a ape yaru malumu ga, navisa ruruena vim van la, vanon nap̃a Ntewa pisaar pan la rui pisape la suri wo la nap̃a sike e yomarava nini van la. ");
INSERT INTO lww_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","La nap̃a sinelan manene p̃elaga mesmesu lala sa nap̃a Ntewa naga sinenania, ana navisa ruruena vim van la, nap̃a p̃isi na avisu kiela malena ulen namesmesuena la nene. ");
INSERT INTO lww_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","La nap̃a asum̃a sinela miye ke yaru tap̃ena lala, navisa ruruena vim van la, nap̃a yokorena Ntewa naga sinena ye manene la vap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","La nap̃a sinela mekiki po, navisa ruruena vim van la, nap̃a yokorena la avisu Ntewa. ");
INSERT INTO lww_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","La nap̃a ape yaru na kilaen sum̃are, ana navisa ruruena vim van la, nap̃a Ntewa naga vio yaru la nene ave narina lala. ");
INSERT INTO lww_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","La nap̃a amlelaga e Ntewa, ana yaru tap̃ena lala akila kare la vanon kiela nalelagaena nene, navisa ruruena vim van la, nap̃a yokorena Ntewa ure la ava loyum̃a e kiena nasup̃enena. ");
INSERT INTO lww_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Amiu la nap̃a yaru la akila kare ke kiamiu kia, a la am̃ene amiu ke na, a la apisa kare amiu, a apisa kotalia amiu, vanon nap̃a amiu na ape kiau yeririna lala, ana p̃isi na navisa ruruena vim m̃ena ga van amiu. ");
INSERT INTO lww_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ana ve sinemiu viowa re, akilia akekara ga, vanon kiamiu pupia suri wo tanea lala sike ma e peni. P̃isi na yaru la akila kare amiu vap̃isi, ana visae ve sanene, la akila ve sa ke nap̃a yaru na sumo lala akila kare navisawalena lala.” ");
INSERT INTO lww_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ana Yesu pisa m̃ena ga, pisapenua “Amiu na sane sive na e yaru na yomarava lala. Ana visae sive ve melkalka re sina, ana pe suri re si tai nap̃a kilia kila melkalka si poli. Ana sive nene na pe popon re si suri tai poli, popon ga akuan va narui. ");
INSERT INTO lww_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Amiu na sane kapi viaga na yomarava. Pogos nap̃a yaru la akila kiela pulkumali metava e kunus tai, kolemalo yaru la nap̃a asike perina akilia avisu kapi nena, ana tap̃atete akilawan kiela pulkumali nene. ");
INSERT INTO lww_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ana pe yaru re tai poli nap̃a silan kiena kapi, ana kalo si kapi nene e piaki tai. Pogos na yaru silan kapi, ana monar ligan to metava e lelena, ana yaru punu ga nap̃a asike loyum̃a ana kapi vivaga nene tegoli la. ");
INSERT INTO lww_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ana e p̃elaga ne na nene, amiu na monar atam̃an kapi na kiamiu malena tegoli yaru la punu ga vena akilia avisu kiamiu yum̃aena wo la nap̃a amiu akila ke na. Ana pogos nap̃a la avisu kiamiu yum̃aena wo la nene, ana la akilia ayeluar kia kiena Arimamiu nap̃a sike ma e peni.” ");
INSERT INTO lww_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ana Yesu pisa m̃ena ga, pisapenua “Pe sineun re nenaga, nap̃a amiu asitom ke asape inu nepimin nesape nekuan plan navisaluaena kiena Mosis, amio visena kiena ne yaru navisawalena la poli. Peraga, pe sa re nene poli. In na nepimin nesape nevian ruru amiu e kinas nen visena punu ga la nene van amiu. ");
INSERT INTO lww_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Suri na ne nepisa ke pan amiu ne, ana lelaga pap̃isi monar asitom̃alia, p̃isi na tap̃atete navisaluaena nene kovio, vanon sinapane amio yomarava nini lalua akovio. Ana tap̃atete narin mras nen visena tai, pona ya sina nap̃a teke e navisaluaena nene, kilia kovio, tap̃atete ga, vano-o tol pogos nap̃a suri na navisaluaena la nene vim kakate make ga. ");
INSERT INTO lww_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Vanon suri ne na nene, visae yaru tai kila pal narin suri tai e navisaluaena nene, pona vian yaru tap̃ena tai kila sanene, yaru nene na ve to re e yo wo tai e nasup̃enena kiena ne Ntewa. Ana yaru nap̃a taveve ruru visena na navisaluaena la nene, a pian ke yaru tap̃ena lala akila sanene, ana naga yoko kiena kia wo e nasup̃enena kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Inu nevisa van amiu, visae sinemiun asape ava e nasup̃enena kiena ne Ntewa, ana monar kiamiu p̃elaga la wo a mesmesu, taulu navianena navisaluaena lala, amio Varasi lala, visae peraga, tap̃atete ava ea.” ");
INSERT INTO lww_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ana Yesu pisa m̃ene ga, pisapenua “Amiu amloge m̃a nap̃a navianena la apian ke kieta yermarua la nanua sumo rui, apisape ‘Ve awem̃ar re yaru, a visae yaru na wem̃ar yaru mare, mesmesun ga nap̃a aure naga va kumali ana avis vania.’ ");
INSERT INTO lww_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ana nevisa van amiu sanini: Yaru nap̃a sinena kari wenla, yaru nene mesmesun aure va kumali avis vania. A yaru nap̃a visi viowa van wenla, visavenua ‘Ko na yaru viowa tai nene wa,’ yaru nene mesmesun aure va e kieta viorena keviu ana alip̃ere naga. A yaru nap̃a p̃isi na la sinemimiena van wenla, pisape ‘Ko na p̃arum̃a pe wowe,’ naga mesmesun va e kapi nap̃a e lele na loge viowaena. ");
INSERT INTO lww_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Vanon suri ne na nene, visae oimi e wonta kiena ne Ntewa vena ola nalaena vania, ana ositom̃al si nap̃a okila suri tai pa womla piowa teke na, ");
INSERT INTO lww_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ana oligan nalaena nene tom̃a e lepas nen wonta nene sumo wa, ana monar omolue sina, ova okila ke ne marawo wa, ana siraunia okilia oimi ola si kiom̃a nalaena nap̃ani va Ntewa. ");
INSERT INTO lww_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Visae okila suri piowa pa yaru tai, ana naga sinenan pisape were ko ova kumali avis van ko, ana popon okoskosin ovisi ruru omio yaru nene, e pogos nap̃a pe ap̃ure ko re opa kumali poli wa. Visae peraga, pona ligan ko e limana yaru na lip̃ereena la yo, ana la nene aligan ko e limana yaru na taren yaru lala, ana la akilia aligan ko e yum̃a nakoaena. ");
INSERT INTO lww_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Suri na nepisa ke pan ko ne naga lelaga, ana visae sanene, tap̃atete si omolue e yum̃a na koaena, vano-o tol pogos nap̃a oul make kiom̃a nakoaena.” ");
INSERT INTO lww_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ana Yesu pisa m̃ena ga, pisapenua “Amiu amloge m̃a nap̃a navianena lala apisalua sumo rui, asape ‘Ve okila re kolau.’ ");
INSERT INTO lww_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ana inu, nevisa van amiu sanini: Yaru nap̃a yepen kawe ke sira tap̃ena tai, nap̃a naga sinenania sape werea, ana naga sane kila kolau amio sira nene p̃isi rui e kiena sitomena. ");
INSERT INTO lww_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","“Visae kilamaram̃a na p̃amarua kila ko ke omloru e mlamulena viowa sanene, popon osilua kilamaram̃a nene vano. A visae lumom̃a na p̃amarua kila ko ke oloru e mlamulena viowa, popon otelua, okuan vano. Ana popon narin lepasnem̃a ga tai kovio, a visae peraga, akoven punu ga tasnem̃a va e lele na loge viowaena.” ");
INSERT INTO lww_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ana Yesu pisa m̃ena ga, pisapenua “Nanua sumo na apisa sanini, apisape ‘Yaru nap̃a koanlua wona, ana naga monar kila m̃aki tai vania, nap̃a pisa meraravan pania pisape koanlua rui, pe pe wona re si poli.’ ");
INSERT INTO lww_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","A in ne nanini, nevisa van amiu, sanini: Pe mesmesun re nena ga nap̃a yaru tai m̃enelua wona poli, visae nap̃a wona nene naga pe kila re kolau sumo poli. Visae yaru tai m̃enelua wona, naga kila kare wona nowo nene sa ga nap̃a wona nene naga pe sira na tap̃aen ga kolau rui. A yaru tap̃ena nap̃a naga were sira tai nap̃a wona nasumo naga m̃enelua naga rui, yaru tap̃ena nene, naga sum̃a kila ke kolau narui.” ");
INSERT INTO lww_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ana Yesu pisa m̃ena ga, pisapenua “Amiu na amloge m̃a nap̃a navianena lala apisa pan kieta yermarua la sumo rui, apisape ‘Visae ovisa kia kiena ne Ntewa vena kila kiom̃a visena m̃arera, siraunia ko tap̃atete okilaro sina visena nene. Visae ovisa kia kiena ne Ntewa, monar okila mesmesu sa nap̃a ko opisa.’ ");
INSERT INTO lww_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ana nanagane, inu nevisa van amiu, sanini ‘Tap̃atete ovisa kia kiena ne suri tap̃ena vena kila kiom̃a visena m̃arera.’ Tap̃atete ovisavenua ‘Lelaga metava,’ vanon nap̃a ma e peni na lelena ne Ntewa nap̃a totano ke ea, na pe yo wa pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","A tap̃atete m̃ena ga ovisa kia kiena yomarava nini, vanon yomarava nini lelen lana ne Ntewa nap̃a naga piawa ke ea. Tap̃atete ovisa Yerusalem, vanon Yerusalem na lelena ne kieta P̃arin Sup̃e Wa. ");
INSERT INTO lww_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","A tap̃atete m̃ena ga ovisa p̃arum̃a, vanon tap̃atete ovilon vilum̃a tai imi yuwowo pona imi malolo. ");
INSERT INTO lww_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Visae avisa suri na lelaga, monar avisa ga ‘Lelaga,’ a visae avisa suri nap̃a peraga, monar avisa ga ‘Peraga.’ A visena tap̃ena la nap̃a akilia avisa, naga molue ga kome Yermare.” ");
INSERT INTO lww_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ana Yesu pisa m̃ena ga, pisapenua “Amiu amloge m̃a nap̃a navianena lala apisa nanua sumo, apisape ‘Visae yaru tai kito kilamaram̃a tai, ana ko okilia okito m̃ena ga kilamarana. A visae yaru tai sulua maluem̃a tai, ko m̃ena ga okilia osulua maluena tai.’ ");
INSERT INTO lww_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ana nanagane, inu nevisa van amiu sanini: Amiu ve akilamaran re si suri van yaru nap̃a kila viowa van amiu. Visae yaru tai lipa pipim̃a e lepas na p̃amarua, ana monar otam̃an m̃ena ga lipa pipim̃a lepas na p̃am̃eli. ");
INSERT INTO lww_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ana visae yaru tai visave were ko ova avis van ko kumali, ana naga m̃areran visave owar mom̃a kulsota vania, ana ko owar m̃ena ga mom̃a kulsaket vania. ");
INSERT INTO lww_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A visae yerkawa tai m̃areran visave owar kiena karo amio ayal va tol mrae ve taaga, ana monar okekaran owar va tol si maran mrae ve taaga. ");
INSERT INTO lww_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Visae yaru tai viun suri tan ko, monar ola vania, a visae yaru sinenan visave la kiom̃a suri tai yum̃aenia, monar otam̃an vania vena lavia, ve ovisalup̃ar re vania.” ");
INSERT INTO lww_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ana Yesu pisa m̃ena ga, pisapenua “Amiu amloge m̃a nap̃a navianena pisa sumo rui pisape ‘Monar ositom nalavis pum̃a, a monar okila viowa va kiom̃a nasinekar lala.’ ");
INSERT INTO lww_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A nanagane, inu nevisa van amiu sanini: Monar asitom kiamiu nasinekar lala, a monar alen wo m̃ena yaru la nap̃a akila ke piowa pan amiu, ");
INSERT INTO lww_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","vena amiu ataveve ruru p̃elaga kiena ne Arimamiu nap̃a sike ma e peni, vanon nap̃a naga kekaran yaru punu ga maran taaga. Vanon suri ne nanene, naga kila kiena mrae tego, a kila kiena yua powo pitomi pun yaru punu ga, la nap̃a apo a la nap̃a apiowa. ");
INSERT INTO lww_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","?Visae akekaran ke ga yaru la nap̃a asitom amiu ke na, amiu na asitom ke asape yokorena atol kiamiu nalaena tai? A yaru na takis lala, nap̃a yaru tap̃ena la asape la ape yaru viowa ga, la akilia akila sanene. ");
INSERT INTO lww_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Visae otalopan ga kiom̃a yeririna lala, nanene na pe otaulu re p̃elaga kiena ne yaru viowa la poli. A yaru la nap̃a pe amlelaga re e Ntewa poli, la m̃ena ga akekaran kiela namratava lala. ");
INSERT INTO lww_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","A kiamiu malena monar mesmesu ruru wo, sa nap̃a p̃elaga kiena ne Arimamiu nap̃a sike ma e peni naga mesmesu ruru pap̃isi, a naga po pan yaru la punu ga.” ");
INSERT INTO lww_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ana Yesu sum̃a pisi pan la, pisa pisape “Suri la nap̃a kieta nalotena pisa pisape popon teyum̃aenia, amiu na ve akila re sa nap̃a amiu akila na vena yaru ve moki akilia avisu kilale nap̃a amiu akila ke suri wo. Visae amiu asum̃a akila m̃a sanene, p̃isi na Arimamiu nap̃a sike ma e peni, naga tap̃atete la nalaena van amiu vanon kiamiu yum̃aena la nene. ");
INSERT INTO lww_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Visae ve sanene, pogos nap̃a ko ola nalaena va yeririna la nap̃a pe kiela suri re poli, vena oiila la, ana pe pon re owarwar ko vanon poli, sane li navilavenen viskorenena. Yaru la nene apisawal ke kiela yum̃aena wo lala e loyum̃a na leniena, a e yepesinas la vanua, vena yaru la ayeluar la. Ana nevisa suri na lelaga van amiu, yaru la ne sanene amla kiela nalaena p̃isi rui e nayeluarena nap̃a yaru tap̃ena la amla pan la, a tap̃atete si ala suri tai. ");
INSERT INTO lww_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A pogos nap̃a ko ola nalaena va yaru la nap̃a pe kiela suri re poli, vena oiila la, monar okila ga e p̃elaga na tapolouena, yaru ve visu re, a ve kiom̃a sitomena yeluar ko re e nalaena nene. ");
INSERT INTO lww_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","A visae okila tapoloun ga kiom̃a yum̃aena wo la ne sanene, ana Arimom̃a nap̃a pisu ke suri la nap̃a yaru la pe apisu re poli, naga kilia la nalaena van ko vanon kiom̃a yum̃aena wo la nene.” ");
INSERT INTO lww_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","A Yesu pisa m̃ena ga, pisapenua “Ana pogos nap̃a amiu alen, pe pon re ataveve p̃elaga kiena ne li navilavenen viskorenena la poli. La nene na sinelan manene asape asum̃alu vena alen loyum̃a e yum̃a na leniena, a vanua e yometava lala, ana yaru la akilia avisu la. Ana inu nevisa suri na lelaga van amiu, yaru la ne sanene amla kiela nalaena p̃isi rui e nayeluarena nap̃a yaru tap̃ena la amla pan la, a tap̃atete si ala suri tai. ");
INSERT INTO lww_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ana pogos nap̃a visae okila leniena, ana ova loyum̃a e mom̃a yum̃a ko ga taaga, okotava ana okila leniena va Arimom̃a nap̃a sike na, ana pe yaru pisu re naga poli. Ana Arimom̃a nap̃a kilia visu suri la nap̃a pe yaru pisu re poli, naga kilia la kiom̃a nalaena van ko, vanon kiom̃a suri wo nap̃a okila. ");
INSERT INTO lww_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“A pogos nap̃a alenia, ana pe pon re avisa visena ve moki poli, ve sa yaru la nap̃a pe amlelaga re e Arimata lelaga poli. Yaru la nene am̃ape yokorena na alual suri nap̃a la amlen ke vanonia, komin la apisa ke visena la moki manenea, ana peraga. ");
INSERT INTO lww_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ana amiu na ve ataveve re kiela p̃elaga lala, vanon Arimamiu, naga kilia ke suri la nap̃a limamiu plasan rui, pogos nap̃a amiu pe apiun re suri la nene tan naga poli wa. ");
INSERT INTO lww_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Vanon suri ne nanene, mesmesun nap̃a amiu alen sane leniena nini, nap̃a pisa pisape ‘Arimamimi nap̃a ko osike ma e peni, mesmesun ga nap̃a yaru la asu vatanon kiom̃a kia wa. ");
INSERT INTO lww_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Memlen mesape kiom̃a nasup̃enena imi sum̃alu m̃arera se yomarava nini, vena yeririna la akila sa nap̃a ko sinom̃ania, sa nap̃a la ne ma e peni akila m̃aga. ");
INSERT INTO lww_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Awis, ola kinanena van imimi p̃ane, a e legiena punu ga. ");
INSERT INTO lww_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","A oviewo imimi e kiamimi mlamulena viowa lala, sa nap̃a imimi m̃ena mepiewo ke yaru tap̃ena la nap̃a akila ke piowa pan imimi. ");
INSERT INTO lww_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ko ve oligan manene re suri viowa lala aimi atap̃ali imimi, okila wo Yermare ve imi kila kare imimi re.’ ");
INSERT INTO lww_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Vanon nap̃a visae amiu aviewo ke yaru la nap̃a akila ke piowa pan amiu, ana Arimamiu nap̃a sike ma e peni viewo amiu m̃ena ga. ");
INSERT INTO lww_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","A visae ve aviewo re yaru tap̃ena la nap̃a akila ke suri piowa pan amiu, ana Arimamiu tap̃atete viewo kiamiu mlamulena viowa lala.” ");
INSERT INTO lww_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","A Yesu pisa m̃ena ga, pisapenua “A visae pogos nap̃a amiu amonsilu ke sina ga, ve akinan re vena amiu asitom̃ali Ntewa a alen vania, amiu ve akila re sa nap̃a pe ake re maramiu poli, pona amiu akila maramiu la viowa, a kulugomiu la miyopiop sa nap̃a viso kar amiu pap̃isi, vena yaru lala avisu kilia ya nap̃a akila ke na. Nanene na yum̃aena kiena ne li navilavenen viskorenena. Ana visae akila sanene, ana yeririna lap̃asia sinela ye la, naga ga nene kiela naulena nap̃a la akilia alavia vanon kiela monsilena, p̃isi na tap̃atete si Ntewa naga la sina ga suri tai van la. ");
INSERT INTO lww_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ana ko, pogos nap̃a amonsilu ga sanene, popon okee maram̃a, okila ruru vilum̃a, oyowau ruru wo sa nap̃a ko okila ke silaga, ");
INSERT INTO lww_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","vena yaru la aninue ya nap̃a ko okila ke ne. Arimom̃a ga nap̃a naga sike na, pe yaru la am̃a re naga poli, ana naga ga p̃isi na kilia pisu ke suri la nap̃a pe yaru la apisu re poli, p̃isi na naga la nalaena van ko vanonia.” ");
INSERT INTO lww_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ana Yesu pisa m̃ena ga, pisapenua “Pe pon re amiu akilapolo kiamiu suri wo na yomarava la nini poli, vena avim ave yaru keviu na suri moki manenea. E yomarava nini na kirara lala akilia akar suri la nene, a suri la nene akilia avililua a amenunu m̃ena ga, a amio m̃ena ga yaru na vinauena nap̃a kilia kilapo yum̃a, vena vinaun suri la nap̃a amiu ap̃ionia. ");
INSERT INTO lww_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ana amiu na monar awarpolo kiamiu suri wo lala ma e peni, vanon nap̃a e nene na yo tai nap̃a pe kirara re e poli, a suri tai tap̃atete vililua a menunu, a yaru na vinauena lala tap̃atete akila kare kiamiu suri nowo la nap̃a amiu amligan ruru sike ea. ");
INSERT INTO lww_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Popon vena amiu na kiamiu suri wo la ve moki sike ma e peni, vanon e nap̃a kiom̃a suri wo la sike ea, ana kiom̃a sitomena m̃ena ga sike e nene silaga.” ");
INSERT INTO lww_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","A Yesu pisa m̃ena ga, pisapenua “Kilamarana yaru naga pe yo taaga ga nap̃a kapi vivaga pimi loyum̃a e tasnena. Visae kilamaram̃a merarava ruruia, okilia ovisu kilale yaru tap̃ena, vena oiila naga. Visae okila sanene, losinem̃a pulen ruru kapi pivaga pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","A visae kilamaram̃a ve merarava ruru re, yoko tap̃atete ovisu kilale ruru yaru tap̃ena, yoko osum̃a ovisu ga kiom̃a suri lala ove puluvisin ga. Visae okila sanene, losinem̃a pulen manene la yemalolo, a visae yemalolo naga sike e nap̃a mesmesun kapi vivaga naga se ea, nanene sane ko na osike e yemalolo nap̃a pe pupumalo pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","A Yesu pisa m̃ena ga, pisapenua “Yaru tai tap̃atete kilia yum̃ae kiena sup̃e ve lua veraga. Visae sanene ana naga kekaran tai, a yepena mavin tai, pona naga logear tai, aligan tai. Amiu na tap̃atete akila sane ave yaru kiena ne Ntewa, ana ave yaru kiena kilavaru m̃ena ga.” ");
INSERT INTO lww_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ana Yesu pisa m̃ena ga, pisapenua “Vanon suri ne na nene, inu nevisa van amiu sanini: Pe pon re kiamiu sitomena ulen manene ga kiamiu yum̃aena na visuar amiuen la poli, nap̃a amiu asum̃a apiuviun ke, asapenua ‘?Am̃a e nape nap̃a yoko ita telual kata kinanena a m̃ata namunena?’ pona ‘?P̃isi na ita tetol m̃ata kulsota na yenwo e sanape ne?’ Sitomena la ne sanene na pe po re nenaga, komin kiamiu malena naga po taulu kinanena, a tasnemiu naga po taulu kulsota. ");
INSERT INTO lww_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Asitomli manu la ne akaka ke ne. Manu la nene pe amapla re kala lokove poli, a pe apa ap̃ar re kinanena pitomin nap̃a aligan ruru sike loyum̃a poli. Ana Arimamiu ga nap̃a sike ma e peni, naga ga mla ke kinanena pan la, ana e kiena navisuena, naga pisu amiu na sane ato metavan manu lala, p̃isi na naga kilia visuar amiu taulu la. ");
INSERT INTO lww_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","?Amiu na asitom asape yaru kilia kila kiena malena nap̃a plas ga ne vim ve piavi li laa sane wo ga, vanon sitom manene la kiena malena? Peraga, pe sa re nene poli, ana amiu na popon ve asitom manene re kiamiu malena. ");
INSERT INTO lww_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“?A komin ya ne asitom manene ke m̃amiu kulsota la vanonia? Amiu asitomli vinas nen purmeme la ne pitotovi ke e yo punu la ne. Vinas la nene na pe amiyum̃ae re poli, a pe asulu re m̃ala kulsota la poli. ");
INSERT INTO lww_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ana inu nevisa van amiu, P̃arin Sup̃e Solomon nene nanua sumo, naga pe yaru na suri moki, ana naga m̃ana kulsota la nap̃a naga miyenia na pe miyowau ruru re sane meme la nene poli. ");
INSERT INTO lww_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A meme la nene na la ape na legiena taaga ga, peni narui asikapi la e kapi, ana Ntewa ga naga paia ruru la ke apo sanene. ?Ana amiu na asitom asape p̃isi na Ntewa naga tap̃atete la kulsota van amiu? !Aulai, amiu na pe apiawa re nena m̃arera e Ntewa poli! ");
INSERT INTO lww_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Komin suri ne la nene, pe pon re sinemiu la ulen sitomena la nene poli nap̃a sape ‘?Yoko takan ya ne, a tomun ya ne, a telual m̃ata kulsota sanape ne?’ ");
INSERT INTO lww_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Lelaga, yaru la nap̃a pe amlelaga re e Ntewa poli la asitom manene suri la ne sanene silaga, ana amiu, Arimamiu nap̃a sike ma e peni, naga kilia m̃a ga nap̃a pisape yokorena monar kiamiu suri la nene na wa. ");
INSERT INTO lww_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Suri nap̃a amiu monar asitom p̃esan ve keviu e kiamiu malena, nane nasup̃enena kiena ne Ntewa, amio kana namesmesuena nena lala. Visae ve sanene, p̃isi na naga la m̃ena ga suri tap̃ena la nene van amiu.” ");
INSERT INTO lww_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Ve sanene, pe pon re sane p̃ane na, asitom manene suri la na legiena na peni poli. Peni ga, akilia asitom suri la na peni, komin legiena na p̃ane, ana suri viowa la moki pimi e rui.” ");
INSERT INTO lww_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ana Yesu pisi ke pan la na wa, pisape “Amiu na monar ve alip̃ere kare re yaru tap̃ena lala. Ve sanene, Ntewa m̃ena ga ve lip̃ere amiu manene re, ");
INSERT INTO lww_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","komin sitomena nap̃a teke e amiu pogos nap̃a amiu alip̃ere yaru tap̃ena, p̃isi na sitomena na sanene teke m̃ena ga e Ntewa e pogos nap̃a naga lip̃ere amiu. P̃isi na Ntewa naga lip̃ere amiu, ve sa ke nap̃a amiu amlip̃ere yaru tap̃ena lala. ");
INSERT INTO lww_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Pe pon re nap̃a ko osum̃a ovisasawal ke narin kororaki nap̃a teke e kilamarana ne womla poli, ana ko pe opisu kilale re pupia mora laki na m̃eke e kilamaram̃a poli. ");
INSERT INTO lww_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","?Sanape narui ko ositom ke osape okilia ovisi va womla nene, ovisave ‘P̃isi na nelalua ke ne kororaki na teke e kilamaram̃a ne sumo wa?’ ");
INSERT INTO lww_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","!Visae sanene, na ko na pe opisu kilale re kiom̃a mlamulena viowa poli, ana ko osum̃a omlip̃ere ke ga mlamulena kiena ne yaru tap̃ena lala! !Ko na ope yaru navilavenen viskorenena pap̃isi wa! Okilalua ke ne pupia miasin laki nap̃a m̃eke kilamaram̃a sumo wa, siraunia ana okilia ovisuveve narin kororaki nap̃a teke e kilamaran yaru tap̃ena. ");
INSERT INTO lww_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Pe pon re amiu akilali nap̃a avisawal Visena Wa kiena ne Ntewa va yeririna la nap̃a la pe akekaran re ala poli. Nanene sa nap̃a amiu asum̃a apagan ruru ke lokul tetan lala e kinanena nap̃a po, ana pogos nap̃a akinana p̃isi, p̃isi na avilon p̃arila ana akar amiu ke sina ga. Sa ke m̃ena ga nap̃a visae awar nalaena wo lala va nompui lala, p̃isi na la avie neno ga vitove sike e pulkene.” ");
INSERT INTO lww_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","A Yesu pisape “Yaru nap̃a sum̃a piun ke suria, silaga naga mlavia, a yaru nap̃a sum̃a kale suria, silaga naga m̃alia, a yaru nap̃a sum̃a sigariga ke mratava, silaga pulutava pietava pania. Visae sanene, p̃isi na amiu awar ya nap̃a amiu asum̃a apiun ke tan Ntewa, a p̃isi na amiu alual ya nap̃a amiu asum̃a akale ke tania, a mratava nap̃a amiu asum̃a asigariga ke ne, p̃isi na Ntewa naga vietava van amiu. ");
INSERT INTO lww_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Visae narum̃a tai viso karia, viun narin kilaparavi nap̃a teke ne, p̃isi na tap̃atete ola kilavaru tai vania, ");
INSERT INTO lww_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","pona visae naga viun ruru ika nap̃a teke rui, ana tap̃atete ola lom̃ara van kania. ");
INSERT INTO lww_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A lelaga nap̃a amiu na ape yaru viowa ga lala, ana tap̃atete amiu yaru tai kilia kila sanene, amiu na akekaran ga silaga nap̃a amla suri wo lala pan narimiu lala. Sanene, pogos nap̃a amiu aviun suri tai va Arimamiu nae ma e peni, naga kekaran ga nap̃a la suri wo la van amiu narina lala, va ve keviu la sane wa. ");
INSERT INTO lww_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Amiu na monar akila wo va yaru tap̃ena la silaga e suri wo ga lala, sa nap̃a amiu sinemiun asape yaru tap̃ena lala, la monar akila wo van amiu. Visena ke nene narui naga purp̃es nen visena kiena ne navisaluaena la nene nap̃a Mosis naga siriyuia, amio m̃ena ga ya nap̃a navisawalena na sumo lala la apisa.” ");
INSERT INTO lww_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Ana Yesu pisa m̃ena ga, pisapenua “Pupia pulutava tai nap̃a keviu mon m̃aga, ana mrapa nap̃a pa p̃arpoyo komea ana lepalepasa a pe yotop ruru po pap̃isi. Yeririna la mokliu nap̃a ataveve ke mrapa nene, ana mrapa nene naga va e yo natolen koaena. A amiu na monar ava loyum̃a e pulutava tap̃ena tai, nap̃a naga ve tokak la ga. Naga kana mrapa nena m̃arera pap̃isi, a pe yeririna moki re nap̃a akom ke e poli, ana mrapa nene naga mrapa na malena.” ");
INSERT INTO lww_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ana Yesu pisa m̃ena ga, pisapenua “Amiu na monar avisuar ruru yaru la nap̃a la apisape la ape yaru navisawalena lala, ana apian ke suri navisokanena lala. Pogos nap̃a la sinelan asape avian amiu, la apimi sa nap̃a ape erau wo amio amiu, nap̃a la yepela mom̃au ruru nenaga, sa nap̃a sipsip lala, ana e losinela lala la sa ga lokul tetan lala, nap̃a la visokarlan suri punu ga. ");
INSERT INTO lww_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ana p̃isi na amiu avisu kilale la e mras nen kiela malena lala. Vilum̃ini la nap̃a pe nenosa, amio kilika la nap̃a pe nenosa, la pe ap̃ar re kinanena wo poli pona mras nap̃a kiki ruru poli. ");
INSERT INTO lww_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Purlaki nap̃a kapuru ruru po, naga monar war mras nap̃a po, a purlaki nap̃a kapuru piowa ga, naga monar war mras nap̃a piowa ga. ");
INSERT INTO lww_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ana purlaki nap̃a kapuru po, ana tap̃atete war mras nap̃a viowa, a purlaki nap̃a kapuru piowa ga, ana tap̃atete war mras nap̃a po. ");
INSERT INTO lww_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Naga sa ga nene narui, visae purlaki viowa la nene nap̃a la tap̃atete awar mras napo, p̃isi na monar ate plan la ga vena akuan la ava e kapi. ");
INSERT INTO lww_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Visae ve sanene narui, mras nap̃a naga molue e malena kiena ne yaru kila meraravan pisape yaru nene naga pe yaru na sanape, ana p̃isi na amiu akilia avisu kilale navisawalena viowa la nene e mras viowa la nap̃a molue e kiela malena lala.” ");
INSERT INTO lww_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ana Yesu pisa m̃ena ga, pisapenua “Yaru la mokliu asum̃a apio inu ke asape ‘!Kiau Sup̃e, kiau Sup̃e o!’ ana tap̃atete la punu ga nene nap̃a p̃isi na akilia ava loyum̃a e nasup̃enena kiena ne Ntewa ma e peni. Yeririna nap̃a kilia va loyum̃a, naga yeririna ga nap̃a naga sum̃a kila ke suri la nap̃a Ata naga sinenania. ");
INSERT INTO lww_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","E pogos nap̃a p̃isi na Ntewa naga lip̃ere yeririna lala, yeririna la ve moki nap̃a p̃isi na avio inu ve sanene, avisave in na nepe kiela Sup̃e. P̃isi na la avisa avisave ‘?Sup̃e, sanapen imimi? Imimi na memiyum̃aen suri wo la mokliu e kiom̃a kia, a imimi mepisawal m̃ena ga kiom̃a visena, a imimi mem̃ene plan m̃ena ga yermare lala, a mekila ke m̃ena ga kile la mokliu. ?Pona ko pe ositom̃al re kiamimi yum̃aena wo la nene poli, yo?’ ");
INSERT INTO lww_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","“Ana yokorena inu nevisawal mesmesun van la, nevisave: Inu na pe nekilia amiu re nenaga pogos tai, nap̃a amiu na ape kiau. Amiu na ape yaru na mlamulena viowa ga la ne. !Amiu aurmatan inu nagane!” ");
INSERT INTO lww_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","A Yesu pisa m̃ena ga, pisapenua “Visae ve sanene, la nap̃a ataveve ruru sa nap̃a nepian amiu rui, la sane yaru tai nap̃a pe manmaruan nap̃a kila m̃ana yum̃a, nap̃a naga mapila kana kemrap̃e pito tano tol yo m̃arera tano. ");
INSERT INTO lww_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ana siraunia, yua pimi, a womie la mlau keviu, a lagi miyui, m̃e yum̃a nene, ana yum̃a nene pe mloru re poli, komin nap̃a yaru nene pisirlua ruru m̃ana yum̃a nene e yo m̃arera nap̃a. ");
INSERT INTO lww_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ana la nap̃a pe ataveve ruru re sa nap̃a nepian amiun rui, la sane yaru tai nap̃a kiena sitomena piowa ga, ana pogos nap̃a kila m̃ana yum̃a, kililinaria kana kemrap̃e lala su ga metava e none. ");
INSERT INTO lww_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","A siraunia, pupia yua kove, a womie la mlau keviu, a lagi miyui, m̃e yum̃a nene, ana yum̃a nene mloru. A pogos nap̃a mloru, yum̃aena kiena ne yar nene pimi piowa make nenaga.” ");
INSERT INTO lww_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Siraun nap̃a Yesu p̃isin kiena visena la nene, yeririna la amilan pap̃isi, ");
INSERT INTO lww_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","komin nap̃a la apisuvevea sane kiena visena na pe sa re visena kiena ne kiela navianena navisaluaen la poli, ana kiena visena la urmi pap̃isi, a naga sum̃a miur ke kiela sitomena lala, a naga pisawal visena sane yaru tai nap̃a nam̃areraena teke e naga. ");
INSERT INTO lww_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu mligan kunus keviu nap̃a naga pian ke yaru la ea, naga pitomi tano, ana yaru la mokliu nap̃a atavevea. ");
INSERT INTO lww_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ana yaru tai nap̃a leperosi sike e yepena pimi puna, ana kinai tano pania piunia, pisape “!Sup̃e! In na nemlelaga e ko nesape ko na okilia okila ruru inu wo ga, ana visae ko okekara, sineun nesape neviun tan ko vena okila van inu ve sanene.” ");
INSERT INTO lww_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ana Yesu pe maraun re yaru nap̃a poli vanon kiena maiena nene, ana p̃uarar naga e limana, pisape “Ee, inu sineunia. Poga ga, nesape yepem̃a ikiki.” Ana veraga ga yepena miania, leperosi nene p̃isi ea. ");
INSERT INTO lww_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ana Yesu pisa pania, pisape “Omloge ke ne, ovano ve ovisawal re suri nene va yaru lala wa, ana nanagane ga ne ova okom puna yaru wa vena naga kilia visuveveli yepem̃a. P̃isi na, monar ova okila lotuena va Ntewa, a okila m̃ena kup̃ap̃aena nene nap̃a Mosis pisa sape yaru monar kila vanon suri na sanene, ana siraun naga nene, yaru wa nene naga kilia visawal visave leperosi nene p̃isi rui.” ");
INSERT INTO lww_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ana pogos nap̃a Yesu pa loyum̃a garu pulkumali nap̃a Kapeneam, yaru keviu tai kiena ne li na mara lala nae Rom pimi puna, tagi pania, ");
INSERT INTO lww_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","pisape “Sup̃e, yaru na kilaen kiau yum̃aena tai mloru m̃eke e m̃ana tog nanagane garu m̃au. Tasnena lepas komp̃as mare, ana naga mloge ke piowa pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ana Yesu pisa pania, pisape “Ita, tevano. P̃isi na inu nekila ruru si naga loge wo.” ");
INSERT INTO lww_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ana yerkawa na kilaen mara nap̃a pisatam̃ea, pisape “Sup̃e, in na pe nepe yaru wo re tai nap̃a netorokin nap̃a ko oimi m̃au loyum̃a poli, sane in na pe nepe yere Yu re poli, ana visae okilia ovisa ga visena tai, nekilia nesape p̃isi na kiau yaru nene kilia loge wo narui. ");
INSERT INTO lww_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","In na nekilia nap̃a nesape p̃isi na monar ve sanene, vanon nekilia nesape kiom̃a visena nam̃areraena keviu sike ea. Naga sane yaru na mara la nap̃a asike vatanon inu, nap̃a monar alogear kiau visena. Visae nevisavenua ‘Ovano,’ monar tai vano, pona nevisave ‘Oimi,’ monar naga imi, pona nevisave ‘Okila ve sa nene,’ ana naga monar kila. A inu m̃ena ga monar nekila ya nap̃a kiau yaru keviu pisa pan inu. Ana nemlelaga nap̃a visae ko ovisa ga suri tai, ana monar ve sa nene.” ");
INSERT INTO lww_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ana pogos nap̃a Yesu mloge kiena visena nene, kila naga milan pap̃isi a kekara m̃ena ga pap̃isi. Ana pisa pan p̃ina la nap̃a ataveve ke ne, pisape “Nevisa suri na lelaga van amiu, in na pe nom̃al re nena ga yaru nae Israel tai nap̃a naga piawa m̃arera e inu sane yaru nene poli. ");
INSERT INTO lww_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Inu nevisawal van amiu sanini, ve le Yu re ga la nap̃a akilia aimi loyum̃a e p̃ap̃agena keviu na legiena maro nene. Peraga, ana yokorena yaru la ve moki ve sa yaru nene e yo tap̃ena lala na yomarava nini, nap̃a aimi atotano lele taaga vena akinana amio Epraam, Aisak, a Sekop. P̃isi na la nene na asu ruru silaga ve sanene e nasup̃enena kiena ne Ntewa ma e peni. ");
INSERT INTO lww_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ana le Yu la nene nap̃a Ntewa pio la sumo vena ava loyum̃a, nanagane la pe amlelaga re e inu poli, ana p̃isi na Ntewa koven plan la ava e yemalolo vanua, e yo nap̃a yaru la asum̃a atagi ke ea, akar ke maluela ea.” ");
INSERT INTO lww_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ana Yesu pisa pa yerkawa na kilaen mara nap̃ani, pisape “Ko, okilia ova um̃a. P̃isi na vim van ko ve sa nap̃a kiom̃a nalelagaena piawa ke m̃arera ea.” A e ke e pog nene narui, ana yepen yaru na yum̃aena nene pimi po sina. ");
INSERT INTO lww_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ana pogos nap̃a Yesu sike garu Kapeneam wa, ana naga pa loyum̃a m̃ana Pita, naga pisu anenane wona Pita naga miava karia, m̃eke e m̃ana tog. ");
INSERT INTO lww_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ana Yesu mligan limana te limana ne sira nene, ana miava nap̃a p̃isi, ana naga sum̃alu, mla kinanena pa Yesu. ");
INSERT INTO lww_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","A yepekilavi e legiena nene, yaru la ap̃ure yaru la moki nap̃a apimi puna Yesu, yaru la nap̃a yermare lala asike e la. Ana naga m̃ene plan yermare la nene e ga e kiena visena, a naga kila ruru m̃ena ga namaiena lala apimi apo sina. ");
INSERT INTO lww_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Suri la nene pimi kakate vena kila visena kiena ne Navisawalena Aisea imi ve lelaga, nap̃a naga pisape “Naga lalua kieta maiena lala, a naga kuslua kieta yepe lalaea lala.” ");
INSERT INTO lww_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","E legiena tap̃ena sina ga tai, Yesu sum̃a amio yaru la mokliu nap̃a la amiervivi naga telivi piora, ana naga sinenan pisape yali vetan la, ana naga pisa pan kiena nalogena lala, pisape “!Aulai! Ita, teva e lepas nen lapa nene lepas p̃asa.” ");
INSERT INTO lww_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ana asun ke asape avano, ana navianena navisaluaena tai naga pimi, pisaar pa Yesu, pisape “Navianena, p̃isi na netaveve ko, e nape nap̃a ko okom ea ana inu netaveve ko teva ea.” ");
INSERT INTO lww_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ana Yesu pisatam̃ea, pisape “Lokul tetan lala, la m̃ala pulus na monena la asum̃a ga, a manu m̃ena ga lala m̃ala ponovi la asum̃a ga. Ana inu, Narina ne Yeririna na, pe m̃au yo re tai nap̃a neva nomomalio e poli. Visae ko okekaran m̃ena ga malena na sanene, ko okilia oimi.” ");
INSERT INTO lww_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","E ke e pogos nene, ana nalogena tap̃ena kiena ne Yesu tai pisa pania, pisape “Awis M̃ara, otam̃an inu neva nevisuar ke ne ata sumo wa, a visae pogos nap̃a mare pae, p̃isi na neimi netaveve ko ga na wa.” ");
INSERT INTO lww_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ana Yesu pisa pania, pisape “Ko oimi otaveve inu ga. Ko oligan yeririna la nap̃a ninula mare rui, vena la asin kiela yaru la nap̃a la amare.” ");
INSERT INTO lww_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ana Yesu amio kiena nalogena lala apitomi atol lapa nene narui, ana ap̃iyu apa e waa tai e yo nene. ");
INSERT INTO lww_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ana apa li ga metava pe piavi re poli, pupia lagi tai molue, miyui kila pupia lapa nap̃ani kululu keviu pap̃isi, ana kila waa nap̃ani siar sape talilu. Ana Yesu m̃eke e waa, naga momalio ruru ga m̃eke na, ");
INSERT INTO lww_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ana la apito akilap̃egea, apisape “!Sup̃e, opisu ke ne! Lavisi tetalilu narui, monar otamalia ita.” ");
INSERT INTO lww_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ana Yesu pisa pan la, pisape “!Ei! ?Amaraun ke ya ne sanene? Aa, amiu na pe apiawa re nena m̃arera e kiau nam̃areraena poli.” Ana naga sum̃alu, pisalup̃ar lagi, pisape ve yui re sina, a pisalup̃ar sive, pisape malumu. Ana pog pimi po, amalumu. ");
INSERT INTO lww_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ana pogos nap̃a nalogena la apisu yo pimi pa ruru make nenaga po sanene, ana amilan pap̃isi, apisape “!Suwala! Yaru nene na pisa ga sanene, ana lagi amio sive lalua amlogear naga. !Yaru nene na pe yaru re nene poli yo!” ");
INSERT INTO lww_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ana pogos nap̃a Yesu pimi tol lapa nene lepas p̃asa, naga pa gare yo kiena ne le Katara lala. E yo nene, yaru la lua amolue e puluve m̃ana ne yaru mare lala, ana la lua am̃al Yesu. Ana la lua nene na yermare lala asike e la, ana la lua ape wowe asirag pap̃isi, ana kila yaru la amaraun vaen e mrapa nene pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ana pogos nap̃a apisu Yesu, lalua apio manene pap̃isi, apisape “?Ko Narina ne Ntewa, kiom̃a ya nap̃a teke e imimi? ?Ko opimin osape ola nakoaena van imimi nap̃a pe kana pog re poli wa, ne?” ");
INSERT INTO lww_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ana e yo nene, na p̃egas nen nompui tai asum̃a akolkol m̃a porotano lavis ga, ");
INSERT INTO lww_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ana yermare la nene atagi, apisa pa Yesu, asape “Visae om̃ene plan imimi, awis oligan imimi mava e los nen nompui la ne asike ne.” ");
INSERT INTO lww_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ana naga pisa pan la, pisape “Avano.” Ana la amolue petan lalua nene, apa e los nen nompui la nap̃ani. Ana pogos ke nene, nompui la nap̃ani akiriri apano, apitove e yeparpasa tai, amloloru apito tano e pupia lapa nene, atalilu apito akokovio ea. ");
INSERT INTO lww_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ana yaru na visuaren nompui lala apureure apa e kiela pulkumali, apisawal suri la nap̃a kakate, a ya nap̃a tol lalua nap̃a yermare la ase lalua sumo. ");
INSERT INTO lww_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ana pogos ke nene, yeririna la punu ga nap̃a e kiela pulkumali nene apimi apisu Yesu. A pogos nap̃a apisu naga, apisi m̃arera pania apisape naga ure vetan kiela yo. ");
INSERT INTO lww_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ana Yesu p̃asup̃e sina amio kiena nalogena lala, amiyai ke ga e waa nap̃ani, ana akusro si lapa keviu nap̃ani, ana ap̃asup̃e apimi e kiena pulkumali nap̃a Kapeneam. ");
INSERT INTO lww_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ana yaru lap̃asia akus namaiena tai pimi puna nap̃a naga tasnena komp̃as mare, naga mloru ga m̃eke e m̃ana tog. Ana pogos nap̃a Yesu pisu kiela nalelagaena m̃arera asape Ntewa naga p̃isi na iila namaiena nene, naga pisa pania pisape “Naruu, ve sinem̃a kona re. Kiom̃a mlamulena piowa lala, nepiewo p̃isi rui.” ");
INSERT INTO lww_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ana e pogos nene navianena navisaluaen lap̃asia asum̃a ga, ana amloge ke visena kiena ne Yesu nene. Ana verakorena la apismumunia, apisape “Yaru nene naga p̃arnena kare kia wa kiena ne Ntewa rui. Naga pisa ke sanene sa ga naga Ntewa rui.” ");
INSERT INTO lww_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ana Yesu kilia m̃a kiela sitomena lala, ana pisape “?Vanon ya ne kiamiu sitomena la pulen sitomena viowa sanene? ");
INSERT INTO lww_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Visae nevisa sanini va yaru nene, nevisavenua ‘Inu nepiewo kiom̃a mlamulena viowa,’ pona nevisa nevisavenua ‘Osum̃alu oyali,’ e visena lua nene, tai m̃areran na visaena, a tai meme ga navisaena. Visena nap̃a pisapenua ‘Osum̃alu oyali,’ naga m̃arera, vanon nap̃a yaru la apisu kilale asape yaru nene sum̃alu pona ve sum̃alu re. ");
INSERT INTO lww_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ana p̃isi na nekila suri tai nap̃a amiu asitom sane Ntewa naga ga taaga kilia kila, komin nap̃a sineun nesape nekila merarava van amiu nap̃a sane Narina ne Yeririna naga torokin nap̃a viewo mlamulena viowa lala e yomarava nini.” Ana Yesu pisa pan namaiena nene, pisa pisape “Osum̃alu osilowar mom̃a tog, oyali, ova mom̃a.” ");
INSERT INTO lww_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ana yaru nap̃ani sum̃alu, mial pa m̃ana. ");
INSERT INTO lww_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ana p̃ina na yeririna la nap̃a apisu suri nene amarau, a amieluar m̃ena ga Ntewa vanon nap̃a naga tam̃an nam̃areraena nene pisape yaru tai kilia kila ve sanene. ");
INSERT INTO lww_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ana Yesu mligan yo nene, naga mial ga pa m̃a sane. Naga pa m̃aga, ana m̃al inu neteke tano e lelen kiau yum̃aena. Kiau yum̃aena e pogos nene, nawarpoloen kilavaru na takis. Ana Yesu pio inu, pisape “Matiu, oimi otaveve inu.” Ana nesum̃alu veraga, netaveve Yesu. ");
INSERT INTO lww_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Siraunia, Yesu pimi kinana e m̃au yum̃a, ana e pogos nene nepure li nawarpoloen takis la moki, amio yaru viowa tap̃ena lala, apimi atotano, vena akilia akinana veraga amio Yesu a kiena nalogena lala. ");
INSERT INTO lww_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ana le Varasi lap̃asa asike e pogos nene, ana apisu nap̃a Yesu teke veraga amio yaru la ne sanene, ana apiun tan kiena nalogena lala, asape “?Komin ya ne kiamiu navianena kinana ke veraga amio yaru viowa la ne sanene?” ");
INSERT INTO lww_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ana Yesu mloge kiela visena nene, ana naga pisatam̃e la, pisape “Yaru la nap̃a yepela poga ga, pe sinelan re yaru na kilaruruen maiena poli, ana la ga nap̃a ap̃ar maiena, ana la sinelania. ");
INSERT INTO lww_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Popon amiu asitomyuli kinas nen visena tai nap̃a teke e Visena Wa, nap̃a Ntewa pisa, pisape ‘In na pe sineun re kiamiu kup̃ap̃aena la poli, ana sineun ga nasineyeena se kiamiu malena lala.’ In na pe nepimin re nap̃a nevio yaru la nap̃a asitom asape la amesmesu p̃isi rui, peraga, inu na nepimin ga nesape nevio yaru viowa lala vena ataveve inu.” ");
INSERT INTO lww_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Siraun suri nene, ana nalogena lap̃asia kiena ne Yoane Nakeena apimi pu Yesu, apiun tania, asape “Sinemimin mesape ovisawal suri nene van imimi. ?Imimi na memonsilu ga silaga vena mekila leniena, a Varasi m̃ena ga lala akila ke sanene, ana vanon ya ne kiom̃a nalogena lala pe akila re poli?” ");
INSERT INTO lww_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ana Yesu pisatam̃e la, pisayu naga amio kiena nalogena lala, sane la akekara pap̃isi pogos nap̃a naga sike amio la, ana p̃isi na sinela monar viowa siraun pogos nap̃a naga ure matan la, ana pisape “?Pogos nap̃a yaru nap̃a talopa naga sike e p̃ap̃agena amio kiena erau lala wa, amiu asitom asape akilia ataginia? Peraga. Ana e pogos tai, visae nasinekar kiena ne yaru nene lap̃asia aimi aurelua naga vetan kiena erau lala, e pogos nene narui p̃isi na kiena erau lala la akilia amonsilu ga vanon nasineyeena.” ");
INSERT INTO lww_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","P̃elaga na monsilena nene, naga p̃elaga marua na lotuena kiena ne le Yu lala, ana Yesu sinenan pisape kila meraravan van la sape p̃elaga marua la ne sanene, la tap̃atete akilia asikolia amio suri viu la nap̃a naga pian la ke ea, ana naga pisa p̃akaiwa tai e lepas nene pan la, pisape “Tap̃atete ola kinakina kulmrae tai nap̃a pe urviu ana osuluwo ruru pulus nap̃a teke e kulsota marua. Vanon nap̃a kinakina kulmrae viu nene kilia kilaroro kulsota marua nene komp̃asa, ana kana pulus kilia vim ve keviu la sane. ");
INSERT INTO lww_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Ana tap̃atete okonkonia kuruta na munena nap̃a sirpup pava ke ea wa, vito e kulus nen nani nap̃a pe urmarua, nap̃a akonkonia kuruta na munena pito ea yam moki rui. Ana visae akila sanene, kuruta na munena nene lapa e kulus nen nani nene, ana yukuswinia na m̃apoa, ana kuruta namunena nap̃ani lau, ana pias nene naga m̃ena viowa. Ana kuruta viu monar okonkonia va e pias viu, nap̃a m̃arera ruru po, ana okilia oligan ruru mom̃a kuruta na munena nene mom̃a ga.” ");
INSERT INTO lww_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ana pogos nap̃a Yesu pisayu ke pa nalogena kiena ne Yoane la sanene, ana yaru keviu nalotena kiena ne le Yu lala pimi lavisi, kinai pito tanon Yesu, tagi pania, pisape “!Awee! Kiau lom̃earu mare ga na wa, ana sineun nesape oimi, oligan lumom̃a towar naga, vena naga kiena malena imi sina.” ");
INSERT INTO lww_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ana Yesu sum̃alu, taveve yaru nene, naga amio kiena nalogena lala apano. ");
INSERT INTO lww_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ana pogos nap̃a Yesu pa ke sanene, ana sira tai sum̃a ga nap̃a maiena na kupario teke e naga legiena punu ga pano-o pimi tol kas lualima taaga pa lua rui. Ana naga pisu nap̃a Yesu mial pimi, naga sitom sape “Visae netol ga m̃ana kulsaket, vena kiau maiena p̃isi.” Ana naga kom rana Yesu, pimi tol ga m̃ana isinen kulsaket. ");
INSERT INTO lww_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ana Yesu pilon veraga, pisu sira nap̃ani, pisa pania, pisape “Auia, ve sinem̃a kona re. Kiom̃a naviawaena e inu kila ko owo sina.” Ana e ke e pogos nene, maiena nap̃ani p̃isi e sira nene. ");
INSERT INTO lww_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ana pogos nap̃a Yesu pa tol yum̃a m̃ana yerkawa nene, naga pisu yaru la sinela mie manene la sira m̃ee nap̃a mare m̃eke ne, ana asum̃a atagi a amiyaun ke yauena na marena lala. ");
INSERT INTO lww_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ana naga pisi pan la, pisape “Amiu amolue, ayal tetai sina. Sira m̃ee nene na pe mare re nene poli, naga momalio ga ne.” Ana la nap̃ani apitalia kare ga naga. ");
INSERT INTO lww_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ana amligan plan yaru la nene apa vanua, ana Yesu pa loyum̃a. Naga pa tarar limana sira m̃ee nene, ana naga sum̃alu, mali sina. ");
INSERT INTO lww_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ana amlologon suri nene pa e yo make ga, kalo make yo punu ga e lepas nene. ");
INSERT INTO lww_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ana Yesu molue petan yum̃a m̃ana yerkawa nene, a pogos nap̃a naga mial ke pano, ana kilamara p̃ala la lua atavevea, la asum̃a apio ke, asapenua “Ko lus kiena ne Tepet, ko Navisaarena, awis ko sinem̃a ye imimi lua nini ka.” ");
INSERT INTO lww_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ana Yesu mial pano, pa pa loyum̃a e yum̃a tai, ana kilamara p̃ala la lua nap̃ani apimi puna. Ana Yesu piun tan la luoka, pisape “?Amiu luoka ga amlelaga e inu, asape nekilia nekila ruru amiu sanene?” Lalua apisatam̃ea, apisape “Ee Sup̃e, imimi memlelaga.” ");
INSERT INTO lww_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ana Yesu mligan limana te kilamarala, pisape “P̃isi na ve sa nap̃a nalelagaena kiamiu amlua.” ");
INSERT INTO lww_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ana lalua kilamarala pimi po ke e pogos nene. Ana Yesu pisalup̃ar m̃arera pan la luoka, pisape “P̃isi na amiu lua ve avisawal re suri nene va yaru lala.” ");
INSERT INTO lww_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ana lalua amolue petania, ana lalua amlologon suri nap̃a Yesu kila pan la ne, pano-o kalo make yo la punu ga e lepas nene. ");
INSERT INTO lww_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ana pogos nap̃a lalua nene amligan Yesu apano, yaru tap̃ena lala ap̃ure yaru tai pimi puna. Yaru nene pe puru, vanon yermare sike e naga. ");
INSERT INTO lww_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ana Yesu pilelua yermare nene, ana puru nap̃a pisi ruru narui, ana yeririna lala sinela kurkur pap̃isi, apisape “Suwala, pe tepisuli re suri tai e Israel sanene poli wa, p̃ane ga.” ");
INSERT INTO lww_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ana Varasi lala apisayu Yesu, apismumunia, apisape “Yeririna nene pile plan ke ga yermare lala e nam̃areraena nap̃a sup̃e kiena ne yermare lala naga mla pania.” ");
INSERT INTO lww_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ana Yesu sum̃a mialili ke pulkumali lala, a pian ke yeririna lala e kiela yum̃a na lotuena lala. Naga pisawal ke nalologena wo nasup̃enena kiena ne Ntewa, a naga sum̃a kila ruru ke namaiena lala a la nap̃a tasnela la piowa. ");
INSERT INTO lww_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ana pogos nap̃a sum̃a mialili ke yaru la sanene, naga sum̃a pisu p̃ina lala, naga pisu la sa nap̃a kiela sitomena la pule pap̃isi, a suri la piowa pan la e kiela malena lala, ana naga sinena mie la pap̃isi, komin nap̃a asum̃a ga sa ga nene sane sipsip la nap̃a pe yaru navisuar laen re poli, la amninue asape p̃isi na la ave sanape narui. ");
INSERT INTO lww_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ana naga pisa pan kiena nalogena lala, pisape “Lelaga, kinanena moki pap̃isi nap̃a marua sike lokove, ana yaru la lua la ga nap̃a asum̃a ap̃ar ke pitomi um̃a. ");
INSERT INTO lww_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ana amiu na, monar aviun manene tan sup̃e na lokove nene, vena naga ligan plan re si yaru lap̃asia la avano vena awar kana kinanena la nene vim.” ");
INSERT INTO lww_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ana Yesu pio kiena nalogena la lualima taaga pa lua pisape aimi puna. Ana la apimi, ana naga pisi ruru pan la p̃isi, a naga mligan plan la apano vena akilia am̃ene plan ninuna viowa e yeririna lala, a vena akilia akila ruru namaiena lala a nainanena viowa tap̃ena lala.");
INSERT INTO lww_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ana kia kiena ne li nalologena ne la nanini narui: nasumo, Saemon, nap̃a apio asape Pita, nap̃a naga pe kiela yerkawa, amio wenla, nap̃a Antru, Semes, nap̃a narina ne Sepeti, amio wenla nap̃a Yoane, ");
INSERT INTO lww_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip, P̃atalomiu, Tom̃as, inu Matiu, in na nepe yaru na waren takis, Semes, nap̃a naga narina ne Alpeas, Tateas, ");
INSERT INTO lww_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saemon, nap̃a naga kila manene politik sape kuan plan le Rom lala, a Sutas nae Kariot, nap̃a siraunia, naga pielua Yesu. ");
INSERT INTO lww_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ana Yesu pisi ruru pa la lualima taaga pa lua nene, a siraunia naga mligan plan la apano. Visena wo la nene nap̃a naga pisa pan la nanini, nap̃a naga pisape “Amiu na ve ava re puna ne la nap̃a pe ape le Yu re la poli, a amiu ve ava re e pulkumali nae Samaria lala wa. ");
INSERT INTO lww_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amiu na avanon ga sipsip nae Israel la nap̃a akilalu mrapa. ");
INSERT INTO lww_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ana pogos nap̃a avanon la nene, ana monar alologon, avisave ‘!Nasup̃enena kiena ne Ntewa pimi ke pun ita narui!’ ");
INSERT INTO lww_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ana amiu monar akila ruru namaiena lala, a monar akila namarena lala aimi amal sina. A la nap̃a leperosi sike e yepela, monar akila yepela la imi ikiki sina, a amiu monar am̃ene plan yermare e yaru lala. Ana yum̃aena la nene, p̃isi na ayum̃aen e nam̃areraena tai nap̃a amla korenan ga, ana amiu monar ala korenan lein ga va yaru lala. ");
INSERT INTO lww_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","A amiu na ve awar re kiamiu kilavaru lap̃asia e kiamiu pultaga lala, ");
INSERT INTO lww_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","a ve awar re m̃ena kiamiu karo tai, nap̃a akon m̃amiu kulsota tap̃ena lala, a kiamiu kulus nen lamiu tap̃ena lala se ea, a ve awar re m̃ena kiamiu plasgai vano. Yaru la nap̃a akila yum̃aena wo la ne sane amiu, p̃isi yaru tap̃ena la nap̃a la amiyum̃ae pan la, monar avisuar ruru la vanonia.” ");
INSERT INTO lww_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ana Yesu pisa m̃ena ga, pisape “Pogos nap̃a amiu avano-o atol pulkumali tai, ana monar akale yaru tai nap̃a kekaran nap̃a were amiu ava m̃ana, ana asum̃a ga m̃ana, vano vano-o tol pogos nap̃a amiu avatani si pulkumali nap̃ani. ");
INSERT INTO lww_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ana pogos nap̃a avano asike mratava m̃ana yaru nene, ana monar atalopan ruru la, avisavenua ‘Sum̃are sike amio amiu.’ ");
INSERT INTO lww_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","A visae mratava nene kila wo van amiu, ana sum̃are nap̃a apisa ana p̃isi na sike amio la, a visae la akila viowa ga van amiu, p̃isi na sum̃are nene wasup̃e ke sina ga, vim van amiu. ");
INSERT INTO lww_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ana visae yaru lap̃asia yepela mavin were amiuena ava m̃ala um̃a, pona yepela mavin loge amiuena, ana popon aligan ruru mratava nene pona pulkumali nene m̃eke na. Ana pogos nap̃a amolue e yo nene, amiu atanvan puluyavi nae e yo nene nap̃a sike e lamiu, sane kiamiu visena m̃arera tai ne pan la ne, pisape p̃isi na la akus nakoaena nap̃a mesmesun ga kiela p̃elaga viowa la nene. ");
INSERT INTO lww_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Lelaga nap̃a nevisa meraravan van amiu, e legiena na lip̃ereena, ana la nene na m̃arera la van la, taulu nap̃a Ntewa mlip̃ere le Sotom amio le Komora lala nanua sumo.” ");
INSERT INTO lww_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ana Yesu pisa pan la, pisape “Amiu asitom ruru wo. Inu neligan plan amiu avano, a amiu ala limamiu ga ava sanene, amiu na sa ga sipsip la nap̃a asike likan p̃egas nen lokul tetan lala. Visae sanene, ana monar ave manmarua ruru wo, a amiu monar amom̃au ruruia. ");
INSERT INTO lww_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ana monar avisuar ruru amiu, vanon nap̃a sap̃isi yaru lala aure amiu ava kiela kumali, a e kiela yum̃a na leniena lala, vena avis van amiu, ana p̃isi na ala nakoaena van amiu, a avisuaria sap̃isi awe amiu. ");
INSERT INTO lww_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ana p̃isi na aligan amiu ava asum̃alu ase marana ne yerkawa na purvanua vanon ga nap̃a amiu ape kiau nalogena lala, a e pogos nene amiu akilia avisawal kiamiu nalelagaena e inu e maran la nene a e marana ne la nap̃a pe amlelaga re e Ntewa poli. ");
INSERT INTO lww_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ana pogos nap̃a la nene aimi aure amiu, ana amiu na ve asitom manene re avisave ‘?P̃isi na nevisa sanape ne, a nevisa ya ne van la ne?’ vanon nap̃a p̃isi na Ninuna Wa naga la visena na visawalena van amiu nap̃a avisa, mesmesun e pogos na visena. ");
INSERT INTO lww_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","A pogos nap̃a amiu avis, ana pe kiamiu visena re nene poli, ana visena kiena ne Ninuna ne Arimamiu nap̃a naga visi e amiu. ");
INSERT INTO lww_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“E pogos m̃arera nene, p̃isi na yaru kilia tam̃an yaru viowa tap̃ena la nene la aimi aurelua wenla ruru naapo pona narina ruru naapo, vena awe mom̃ar la amarmare, nanene komin nap̃a la nene amlelaga e inu. A nisisi lala la m̃ena ga akilia asum̃alu avisawal anela lala a arimala lala nap̃a la amlelaga e inu, vena la m̃ena ga amare sanene. ");
INSERT INTO lww_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ana p̃isi na yaru lala ve sinelan amiu re sina, akawe kiamiu visena silaga, vanon kiau kia teke e amiu, a yaru nap̃a sum̃alar m̃arera sum̃a ga vano-o pog m̃arera nene p̃isi, p̃isi na Ntewa tamalia naga. ");
INSERT INTO lww_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ana pogos nap̃a la asum̃a am̃ene manene amiu la e pulkumali tai, amiu monar aure ava e pulkumali tap̃ena, a visae am̃ene amiu ke sina ga e yo nene, amiu monar aure sina. Ana nevisa ruru van amiu, nesape kiamiu yum̃aena nene e pulkumali nae Israel lala, p̃isi na ve p̃isi ruru re wa ana Narina ne Yeririna vim warpoyo ke sina ga.” ");
INSERT INTO lww_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ana Yesu pisa, pisape “Naloge-na, naga pe to re metavan kiena navianena poli, a yaru na yum̃aena, naga pe to re m̃ena metavan kiena sup̃e poli. Ve sanene, amiu na ve asitom re avisave p̃isi na tap̃atete m̃arera van amiu pogos tai, ");
INSERT INTO lww_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","komin p̃elaga m̃arera nap̃a la akila va navianena, p̃isi na la akila ke m̃ena ga va nalogena, a suri m̃arera la nap̃a sup̃e naga kusia, p̃isi na kiena yeririna naga m̃ena ga monar tolia. Sa nap̃a yaru la apio kare inu, nap̃a in na nepe yerkawa e m̃au mratava, apisape in na Pielsipel, nap̃a naga pe sup̃e kiena ne yermare lala, p̃isi na la akilia avio kare amiu la sane na wa, amiu la nap̃a ape kiau e mratava taaga.” ");
INSERT INTO lww_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ana Yesu pisape “Vanon nap̃a p̃isi na avis viowa van amiu ve sa ke ga nap̃a apisi piowa pan inu, ana amiu ve amaraun la re. Suri viowa la punu ga nap̃a yaru lala akila vinaunia, pona apisawaniga, p̃isi na vim kakate e yometava na wa, vena yaru la punu ga akilia. ");
INSERT INTO lww_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","A amiu m̃ena ga, suri wo la nap̃a nesum̃a nepisa ke pan amiu e yemalolo, amiu monar avisawal ke sina ga e yomerarava, a suri la nap̃a nesum̃a nepragogon ke ga e kiligamiu, amiu na monar avion manene va metava e maran yeririna lala, vena yar punu ga akilia aloge. ");
INSERT INTO lww_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Ana amiu na ve amaraun re yaru la nap̃a akilia awem̃ar tasnemiu mare, komin nap̃a la tap̃atete awem̃ar ninumiu mare. Ana amiu na monar amaraun ga Ntewa, nap̃a naga kilia kilalele kare tasnemiu amio ninumiu luwoka e lele naloge viowaena. ");
INSERT INTO lww_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Amiu asitom̃alia. Ninlaea la ne akaka ke la ne, la moki pap̃isi, sa ga kororaki ga, a la asum̃a ap̃iliwilin ke lua e narin kilavaru ga tai, ana visae tai loru vitove tano e porotano, ana Arimamiu naga kilia m̃a ga. ");
INSERT INTO lww_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A vilp̃arimiu m̃ena ga moki pap̃isi, ana Ntewa naga poloar make ga peve taaga, naga kilia la m̃aga. ");
INSERT INTO lww_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Sanene, ana amiu ve amarau re, vanon nap̃a Ntewa pisu amiu na po manenea taulu ninlaea la nene, ana p̃isi na naga kilia visuar ruru amiu e suri punu ga e kiamiu malena.” ");
INSERT INTO lww_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ana Yesu pisa pisape “Yaru nap̃a naga visawal e marana ne yaru lala visave naga pe kiau yeririna tai, p̃isi na inu m̃ena ga, nevisawal naga e marana ne Ata nap̃a ma e peni, nevisave yaru nene pe kiau. ");
INSERT INTO lww_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ana yaru nap̃a visawal e marana ne yaru lala visave naga pe pe kiau yeririna re poli, ana inu m̃ena ga nevisawal e marana ne Ata nap̃a ma e peni, nevisave yaru nene naga pe pe kiau yeririna re poli.” ");
INSERT INTO lww_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ana Yesu pisape “Amiu na ve asitom re avisave inu nepimin nap̃a nekila sane pupia sum̃are pimi sike e yomarava nini. Peraga, inu pe nepimin re ga neligan sum̃are e poli, ana inu nepimi nemio playu na kilaen mara tai, nap̃a p̃isi na yaru la aveveyu la, a akila mara van la vanon inu. ");
INSERT INTO lww_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","In na nepimin nesape nekila sane p̃isi na yaru m̃ee lala akawe visena kiena ne arimala lala, a sira m̃ee lala akawe visena kiena ne anela lala, a sira la nap̃a atalopa ga na wa, p̃isi na akawe visena kiena ne anela simem lala. ");
INSERT INTO lww_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","P̃isi na la nap̃a sinela kari manene kiau nalogena lala, naga pe yaru tap̃ena re la poli, yaru na mratava ga m̃ala lala.” ");
INSERT INTO lww_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ana Yesu pisa, pisape “Yaru nap̃a sitom manene la arimana, pona anena, pona narina, taulu nap̃a naga sitom inu, yaru nene naga mesmesun re imi sane ve kiau nalogena poli. ");
INSERT INTO lww_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ana visae yaru tai nap̃a ve kus re kiena laktorovia taveve inu, sane naga pe tam̃an re naga loge viowa vanon inu poli, yaru nene tap̃atete imi ve kiau nalogena. ");
INSERT INTO lww_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Visae yaru tai nap̃a naga sitom manene la kiena malena, yaru nene naga p̃isi na kilalu kiena malena nene. A visae kiau nalogena tai naga kilalu kiena malena vanon inu, p̃isi na naga tol malena nap̃a tap̃atete p̃isi.” ");
INSERT INTO lww_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","A Yesu pisa, pisape “Visae yaru tai nap̃a were amiu ava m̃ana loyum̃a, nanene sa ga nap̃a p̃ere inu ke ga nepa m̃ana loyum̃a ne. A visae yaru tai were inu neva m̃ana loyum̃a, ana nanene sa ga nap̃a pere ke ga naga nap̃a naga mligan inu nepimi, pa ke m̃ana loyum̃a. ");
INSERT INTO lww_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Visae yaru tai were navisawalena tai pona yaru mesmesu tai ne sanene va m̃ana loyum̃a, komin naga kilia ke sape yerkawa nene naga pe yaru wa nayum̃aena kiena ne Ntewa, yoko naga kus ke ga nalaena torokin nap̃a yoko Ntewa la va kiena yerkawa la nene. ");
INSERT INTO lww_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A inu nevisa ruru van amiu sanini, visae yaru tai naga la piala na wii manini ve taaga va kiau nalogena tai, nap̃a naga pe sitom re pisape nalogena nene naga pe yerkawa tai poli, pona yaru tai nap̃a naga to ga tano, p̃isi na yaru nene la kiena nalaena tai komin suri wo nene nap̃a naga kila pa kiau yeririna tai.” ");
INSERT INTO lww_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ana pogos nap̃a Yesu pisa ruru pa kiena nalogena la lualima taaga pa lua nene p̃isi, naga mligan yo nene, ana naga pa e pulkumali nae Kalele lala, vena vian la a lologon van la. ");
INSERT INTO lww_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","E pogos nene, Yoane Nakeena sike e yum̃a nakoaena, a naga mloge ke yum̃aena la nap̃a Kristo kila ke ne, ana naga mligan kiena nalogena lap̃asia, ");
INSERT INTO lww_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","apanon apiun tan Yesu, apisape “?Sanape? ?Ko na yaru nanua apisa ke sumo asape p̃isi na yaru keviu tai imin vena ve kieta nasumonena, pona pe naga re nane ko poli, ana imimi na monar mesum̃ate laa na wa, p̃isi na yaru nene imi?” ");
INSERT INTO lww_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ana Yesu pisatam̃e la, pisape “Awasup̃e amiu sina, ava ke ga puna ne Yoane, a avisawal vania e suri la nap̃a amiu apisuia nap̃a nemiyum̃aen ke e yo nini, a suri la nap̃a apisayu inu ke pan amiu, sane suri la nap̃a Navisawalena Aisea naga pisayu sumo rui, nap̃a naga pisape: ");
INSERT INTO lww_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Kilamarap̃ala lala, nanagane akirava si rui, a yaru la nap̃a ape lapele a ape laulu, nanagane akilia amial po si narui, a yaru la nap̃a leperosi sike e yepela, nanagane yepela pimi mian ruru si narui, a yaru la nap̃a ape kiligapop̃e, nanagane amloge si suri narui, a yaru la nap̃a amare, nanagane amal si rui, a yaru la nap̃a limala korena ga, nanagane nemlologon ke Nalologena Wo pan la rui.’ ");
INSERT INTO lww_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","“A amiu avano avisa m̃ena va Yoane, avisave ‘Yaru nap̃a pe kiena sitomena pe peve lua li re e inu pogos tai poli, p̃isi na navisa ruruena sike e naga.’” ");
INSERT INTO lww_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ana pogos nap̃a nalogena kiena ne Yoane Nakeena lala amolue vena awasup̃e sina, Yesu pisayu Yoane nene pa yaru la nap̃a asike ne, pisape “?Nanua sumo na, pogos nap̃a amiu apa e yokorena nene, amiu na apanon apisu ya? !In na pe nesitom re nap̃a nesape amiu apanon apisu kiai na yokorena la nap̃a lagi miyuia ana kulkulul luen ga poli! ");
INSERT INTO lww_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","A pe nesitom re m̃ena ga nesape amiu avanon vena avisu yerkawa tai nap̃a naga miyowau ruru po poli, komin yaru la ne sanene ana tap̃atete ase lele viowa tai sane yokorena nene, ana silaga asike ga e pupia yum̃a wo m̃ana ne sup̃e kerkeviu lala. ");
INSERT INTO lww_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","?Peraga, ana in na nesitom ke nesape amiu apanon ke vena avisu navisawalena tai, ne? Ee, ana naga nene na poga ga ne, ana inu nevisa van amiu, yaru nene nap̃a amiu amoluen apa apisu naga, naga to laa metava, taulu navisawalena nasumo lala, ");
INSERT INTO lww_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","komin Ntewa naga pisayu Yoane nene sumo rui e kiena Visena Wa, nap̃a naga pisape ‘In na nemligan kiau navisi pimi sumon ko, vena kila ruru kiom̃a mrapa.’ ");
INSERT INTO lww_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Lelaga nevisa van amiu sanini, e yomarava nini, Yoane Nakeena naga to la metavan yaru tap̃ena la punu ga. Ana yeririna la punu ga nap̃a p̃isi na la ava loyum̃a e nasup̃enena kiena ne Ntewa, vano-o tol kiela yaru nap̃a su maro la garo tano, la punu ga nene la apa la metavan Yoane, nap̃a la awar kiela navisa ruruena kiena ne Ntewa pa laa taulu naga. ");
INSERT INTO lww_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","A siar e pogos nap̃a Yoane Nakeena siar mlologo, pimi tol nanagane, yaru lala asum̃a akawe ke nasup̃enena kiena ne Ntewa, a nasinekar m̃arera na kilaen mara lala la m̃ena ga akilali nap̃a atauluia. ");
INSERT INTO lww_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nanua sumo manene la, pimi tol pogos kiena ne Yoane, navisawalena lala, a navisaluaena nap̃a Mosis siria, ana la apisayu suri la moki nap̃a kilia kakate sirau. ");
INSERT INTO lww_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A visae amiu akekaran alelaga e suri la nene nap̃a p̃isi na am̃alivi sirau, ana p̃isi na amiu akilia avisu kilale nap̃a Yoane Nakeena naga pe Elaisa nene, nap̃a la apisaaria sumo rui apisape p̃isi na naga monar wasup̃e sina ga imi. ");
INSERT INTO lww_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","A visae kiligamiu tom̃a ga, popon ayagogon ruru kiau visena la nene.” ");
INSERT INTO lww_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","19","A Yesu pisi pa laa sane, pisa pisape “?Ana p̃isi na nevisawal visena ya nap̃a kilia tol p̃elaga kiena ne yeririna na nanagane lala? E lepas punu ga nap̃a Ntewa naga kila vena kilali wo van amiu, ana amiu yepemiu mavin ga, amiu apisa kare ga naga vanonia. Komin pogos nap̃a Yoane naga pimi sike ga wa, ana monsilu ga pe kinana re poli vena len, a naga palia m̃ena ga kuruta na munena, pe mun re poli, ana yaru la apisu naga sanene, la apismumun naga, apisape ‘Yaru nene yermare pa e naga.’ A pogos nap̃a Narina ne Yeririna naga pimi sike na, naga kinana ruru ga a mun ruru ga, sa ke ga yaru tap̃ena lala, ana yaru la apismumun naga, apisa apisape ‘Opisu ke ne, yaru nene naga pe yaru na kinan merorolen pap̃isi, a pe yaru na munena m̃ena kuruta na munena pap̃isi, a nap̃a naga kiena erau lala na, la ape yaru nawarpoloen ga takis, a ape yaru viowa ga lala.’ “Komin suri ne nanene narui, inu nepisu amiu yeririna na nanagane lala nap̃a amiu na sa ga sisi lala nap̃a visae asum̃a akirakirai e yometava na kumali, p̃isi na la asum̃a aviovion va kiela erau lala, avisave ‘!E, amiu na apiowa nene! Visae imimi mesum̃a mowe plap̃e, ana amiu ve awol re amio imimi, a visae imimi meyaun yauena na marena, ana amiu ve atagi re amio imimi.’ “Ana suri punu ga nap̃a la amolmolue e namanmaruaena kiena ne Ntewa, sumonia yaru la mokliu nap̃a apisu sane piowa ga, ana siraunia p̃isi na Ntewa naga kila imi merarava sane kiena manmaruaena nene naga mesmesu a naga pe lelaga ruru nenaga.” ");
INSERT INTO lww_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ana Yesu pisaar ruru pa yeririna lala na pulkumali la punu ga nap̃a naga kila kile la moki pan la, komin nap̃a apisu kiena suri la nene rui, ana pe apilon la re poli. ");
INSERT INTO lww_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Naga pisa pisape “Yaru nae Korasin lala, amio yaru nae Petsaeta lala, amiu na akila kare amiu keviu pap̃isi wa! Visae le Taea amio le Saeton la nanua sumo, ana la avisuli ga kile la nap̃a amiu apisu p̃isi rui, pona avilopu la nanua sumo yo rui. La pe ape le Yu re poli, ana p̃isi na vera na ayen p̃ililis nen karo, a pona la akuwani posnoyavi e p̃arila yo rui, vena yaru la avisu kilale sane amloge kemua piowa lelaga vanon kiela mlamulena piowa lala. ");
INSERT INTO lww_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Inu nevisa mesmesun van amiu, e legiena na lip̃ereena, p̃isi na kiamiu nakoaena nap̃a van amiu taulu nap̃a van la nene. ");
INSERT INTO lww_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","!Ana amiu le Kapeneam lala, nap̃a amiu asum̃a ap̃arwar amiu, a nap̃a sinemiun asape amiu ato manene metava, ana amiu avisuar amiu! P̃isi na Ntewa koven plan amiu ato tano, ato tano vap̃isi e pulukapi. Visae le Sotom lala la avisuli ga kile la nene nap̃a amiu apisuia, vera na la apilopu la rui, a vera na pupia kapi nae ma e peni nene tap̃atete kekan kiela yo nene kovio. Ana amiu apisu pa kile la nene rui, amiu pe apilopu amiu re nena poli, ");
INSERT INTO lww_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","nane nevisa van amiu, e legiena na lip̃ereena, p̃isi na Ntewa naga sinena ye la manenea taulu amiu.” ");
INSERT INTO lww_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ana e pogos nene, Yesu mlen, pisa pisape “!Ata-o, ko ope Sup̃e nae ma e peni a Sup̃e nae yomarava nini! Nevisa potena van ko, Ata, vanon nap̃a ko opian suri la nap̃a e inu pan la nap̃a kiela sitomena sa ga nisisi lala, ana yaru la nap̃a asitom asape ape manmarua a la nap̃a asitom asape akilia ruru suria, ko okilawan suri la nene van la. ");
INSERT INTO lww_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Lelaga, Ata, nanene ve sa ga nap̃a ko sinom̃ania.” ");
INSERT INTO lww_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ana Yesu pisa m̃ena ga, pisape “Arimau naga mligan make suri la punu ga e lum̃au p̃isi rui. A Arimau naga taaga naga kilia ruru inu, a inu nap̃a nepe narina, in ga taaga ga nekilia ruru naga. Inu nemio la nap̃a nemligan la vena nekilologia Arimau van la vena awasinea, ana imimi ga nene mekilia ruru naga nap̃a naga pe Arimamimi.” ");
INSERT INTO lww_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ana Yesu pisa m̃ena ga, pisape “Amiu punu ga nap̃a amiu sinemiu mare pap̃isi vanon nap̃a amiu asum̃a ap̃ar ke suri urmi lala e kiamiu malena lala, amiu aimi, amiu aimi pun inu, vena nekilia nekila amiu ava ruru amiu. ");
INSERT INTO lww_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Amiu alarar kiau visena lala ve sa nap̃a p̃eligas tai e kiamiu malena, a amiu alarar kiau p̃elaga lala, vanon nap̃a inu na nepe yaru mom̃au tai, a kiau sitomena to ga tano. Sanene, p̃isi na amiu alual nap̃a kiamiu sitomena lala varuruia, ");
INSERT INTO lww_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","vanon nap̃a kiau vianena lala ameme ga a amelala ga, a suri la nap̃a p̃isi na inu nowar van amiu vena amiu awaria, p̃isi na naga tap̃atete urmi manene van amiu.” ");
INSERT INTO lww_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ana e legiena tap̃ena si tai, nap̃a naga pe Legiena Wa, Yesu amio kiena nalogena lala amial apano, ana kiela mrapa pa ga likan lokove na wit lala. Amial ke sanene, ana kiena nalogena lala viso kar la, ana apeve plan mras nen wit lap̃asia vena akania. ");
INSERT INTO lww_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Asiar akila ke sanene, ana Varasi la p̃asia asike e yo nene, ana apisula m̃aga, ana la apisi pa Yesu, asape “!Ei, opisu ke ne! Kiom̃a nalogena lala la asum̃a ap̃ar ke kinanena e lokove sanene, la asum̃a amiyum̃ae ke e Legiena Wa ne, a visae ve sanene, la asu m̃a akilaro ke kieta navisaluaena ne.” ");
INSERT INTO lww_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ana Yesu pisatam̃e la, pisape “?Ana, sanene yo, pona amiu pe apuloli re Tusi Wa pogos tai poli yo, e suri la nap̃a P̃arin Sup̃e Tepet naga kila sumo? Naga amio kiena yeririna lala viso kar la pap̃isi, ");
INSERT INTO lww_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ana naga pa loyum̃a e silparpara wa m̃ana Ntewa, ana naga mla kilaparavi wa nene nap̃a Navisaluaena pisape yaru wa ga lala, la akilia akania, ana Tepet m̃ena ga la akania. ");
INSERT INTO lww_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","?Pona amiu na pe apulo re m̃ena Navisaluaena kiena ne Mosis poli yo, nap̃a e Legiena Wa punu ga, yaru wa lala, la monar ava loyum̃a e Yum̃a Wa m̃ana Ntewa vena akila kiela yum̃aena la ea? Sanene na, la akilaro ke Navisaluaena nap̃a pisalup̃ar ke sape yaru ve yum̃ae re e Legiena Wa ne, ana Ntewa naga pisu suri nene ana pe sitom re pisape suri viowa tai nene poli. ");
INSERT INTO lww_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Inu nevisa van amiu, nesape nasup̃enena viu tai sike nanagane, nap̃a naga to laa metava taulu navisaluaena na Yum̃a Wa m̃ana ne Ntewa, ");
INSERT INTO lww_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ana naga sa nap̃a e Tusi Wa, Ntewa pisa pisape ‘Inu na pe sineun re kiamiu kup̃ap̃aena la poli, ana in na sineun ga p̃elaga na sineyeena.’ ?Pona amiu na amninue ke kinas nen visena nene wa? Visae amiu akilia, a p̃isi na amiu tap̃atete asum̃a alip̃ere kare kiau nalogena la nene nap̃a pe akila re p̃elaga viowa tai poli. ");
INSERT INTO lww_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Narina ne Yeririna, naga ke nap̃a pe sup̃en Legiena Wa narui.” ");
INSERT INTO lww_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ana Yesu molue e yo nene, mial pano, ana pa loyum̃a e kiela yum̃a na lotuena tai. ");
INSERT INTO lww_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","E yo nene, yaru tai sike ea ana naga limana ve tokak, a pe lima mare, ana yaru m̃ena ga lap̃asia nap̃a asum̃a ga sinelan asape alual li suri lap̃asia nap̃a Yesu naga kila na pe mesmesu re poli yo. Ana yaru la nene apiun tan Yesu, asape “?Sanape, kieta navisaluaena pisalup̃ar yum̃aena na kilaruruen tas nen yaru e Legiena Wa, pona pe pisalup̃ar re poli? !Ovisali suri nene!” ");
INSERT INTO lww_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ana Yesu pisatam̃ea, pisape “Visae yaru tai kiena sipsip ve taaga ga, ana e Legiena Wa tai, kiena sipsip nene va loru vitove e p̃ilip̃ili tai, amiu asitom asape p̃isi na yaru nene tap̃atete va werelua sina? !Ee, p̃isi na ita punu ga monar tekila sanene va kieta suri mali lala! ");
INSERT INTO lww_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ana visae mesmesu ga ve sanene e kieta navisaluaena vena teiila kieta sipsip tai sanene e Legiena Wa, ana sanene ita tekilia tekila m̃ena ga yum̃aena naiilaen yaru tap̃ena e Legiena Wa, komin yaru naga po taulu sipsip.” ");
INSERT INTO lww_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ana Yesu pisa pa yaru nap̃a limana mare, pisape “Okian mesmesun lumom̃a.” Ana yaru nap̃a kila sane Yesu pisa, kian mesmesun limana, ana limana pimi po sina, sa ke ga limana komp̃as. ");
INSERT INTO lww_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ana Varasi la nap̃a asike e pogos nene apielue, ana amolue apa vanua, vena avisayu sanape nap̃a akilia awem̃ar Yesu mare. ");
INSERT INTO lww_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ana Yesu kilia m̃a nap̃a Varasi lala asape awe naga, ana naga molue e yo nene, amio yeririna la moki nap̃a atavevea. Ana naga sum̃a kila ruru ke namaiena lala, ");
INSERT INTO lww_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ana naga pisi m̃arera pan la, naga pisalup̃ar la pisape la ve avisayu re naga va yaru tap̃ena lala. ");
INSERT INTO lww_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Naga kila sanene vena visena kiena ne Ntewa tai vim ve lelaga, nap̃a Navisawalena Aisea pisawal sumo rui, a visena nene pisa sanini, pisape ");
INSERT INTO lww_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nanene yaru nap̃a naga miyum̃ae kiau, nap̃a in na nemligan lua naga. In na nesitom naga pap̃isi, a kiau sitomena kekaran naga pap̃isi. P̃isi na inu neligan Ninuu van naga, vena naga visawal p̃elaga mesmesu lala va yolai lala na yomarava nini. ");
INSERT INTO lww_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","P̃isi na naga tap̃atete visin sinekar van yaru, pona visi molmolue va p̃isi, a naga tap̃atete koven visena ve moki e yo metava. ");
INSERT INTO lww_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ana naga tap̃atete telua kiai nap̃a poroli p̃isi rui, a naga tap̃atete vilonm̃ar kapi vivaga nap̃a lavis mare rui. Naga p̃isi na yum̃ae m̃a sanene vano vano-o, tol nap̃a p̃elaga mesmesu sum̃alu m̃arera taulu nena p̃elaga viowa. ");
INSERT INTO lww_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ana p̃isi na yolai lala na yomarava nini, la alelaga m̃arera e naga, avisave p̃isi na naga tamalia la.” ");
INSERT INTO lww_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ana yaru lala asumon yaru tai nap̃a yermare pa e naga pimi puna Yesu. Yermare nene kila naga pe kilamara p̃ala, a pe puru m̃ena ga, ana Yesu kila ruru si kilamarana amio pulgona apimi apo sina. ");
INSERT INTO lww_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ana yeririna la nap̃a apisu suri nene amilania, a sinela kurkuru pap̃isi, ana apiun ke sina ga tan la, apisape “!E! ?Yaru nene naga narina ne Tepet nap̃a tesum̃ate ke yo, pona peraga?” ");
INSERT INTO lww_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ana pogos nap̃a Varasi lala amloge visena kiena ne yeririna la nene, ana apielue pap̃isi, nap̃a apisape “Yaru nene m̃ene plan yermare lala e ga e nam̃areraena kiena ne sup̃e kiena yermare lala, nap̃a Pielsipel, naga tam̃an pania.” ");
INSERT INTO lww_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ana Yesu mlogekilale m̃a kiela sitomena nene, ana naga pisa pan la, pisape “Visae sup̃e tai, kiena yeririna lala alip̃erela, nap̃a lap̃asia akawe si visena kiena ne lala komp̃asia, p̃isi na sup̃e nene kiena yum̃aena lala monar loloru ga vito sike na; a visae pulkumali tai pona mratava tai, kiela yeririna lala alip̃erela, nap̃a sane lap̃asia sinelan asape am̃ene plan si lap̃asia, p̃isi na yeririna la nene tap̃atete asu ruru pogos tai. ");
INSERT INTO lww_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","?A sa m̃ena ga nini, visae yermare lala kiena ne Yermare Lego, lap̃asia am̃ene plan ke sina ga lala p̃asia, nanene na kana kinasia sane amlip̃ere la p̃isi narui, ana nasup̃enena kiena ne Yermare Lego naga yoko sum̃alu ve sanape ne? ");
INSERT INTO lww_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","!Ana amiu na apisa ke asape sanene narui, asape in na nesum̃a nem̃ene plan ke yermare tap̃ena lala e nam̃areraena kiena ne pupia yermare nap̃a Pelsepel, ana pe sa re nena nene poli! Ana visae ve sa nap̃a amiu apisa, sanape na amiu m̃ena lap̃asia nap̃a am̃ene plan ke yermare lala? ?Ane mla nam̃areraena nene pan la, pona Yermare Lego m̃ena yo? A popon visae kiamiu nalogena la nap̃a am̃ene plan ke yermare lala, la alogeveveruruli kiamiu visena la nene. ");
INSERT INTO lww_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ana peraga, amiu apisa suri nene na pe mesmesu re poli. Inu na nem̃ene plan ke ga yermare lala e nam̃areraena kiena ne Ninuna Ntewa, ana suri nene na sane nasup̃enena kiena ne Ntewa sike likan amiu p̃isi rui. ");
INSERT INTO lww_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“!Amiu na apisu ke ne! Visae yaru tai sinenan ke pisape va loyum̃a m̃ana ne yaru m̃arera tai, vena vinaun kiena suria, naga monar war kilika viar ke ne yaru nene sumo wa, p̃isi na naga kilia va loyum̃a ana war plan make kiena suria. Ana in na nekila ke sanene pa yaru m̃arera nene nap̃a Yermare Lego. ");
INSERT INTO lww_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Yaru nap̃a pe taveve inu re poli, naga suwo inu ke ne, a yaru nap̃a pe miyum̃ae re amio inu poli vena moure kiau yeririna lala aimi lele taaga, naga sane sum̃a m̃enetetain la ke ne. ");
INSERT INTO lww_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Ana sanene narui, in na nevisa van amiu, mlamulena viowa lala, a visena viowa lala, a visena nap̃a kila kare Narina ne Yeririna, Ntewa naga kilia viewo yaru vanonia, ana yaru nap̃a pisayu kare Ninuna Wa, nap̃a pisa pisape kiena yum̃aena naga Yermare Lego ga miyum̃aenia, yaru na sanene, Ntewa tap̃atete viewo naga pogos tai, e pogos na tesike e ne, a e pogos nap̃a pimi ke sirau.” ");
INSERT INTO lww_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","A Yesu pisa m̃ena ga, pisape “Ita tekilia tevisu kilale purlaki lala e mrasnela nap̃a ap̃aria. Purlaki nap̃a kapuru po, naga mrasa m̃ena ga po, ana purlaki nap̃a piowa ga, p̃ar m̃ena ga mrasa nap̃a piowa ga. ");
INSERT INTO lww_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","A malena kiena ne yeririna naga sa ke m̃ena ga nene, nap̃a e losinena naga sane pe purp̃es tai, a visena la nap̃a amolmolue e kiena malena, la sane mras la nap̃a amolmolue ke e purp̃es nene. ?A inu nepisu kiamiu purp̃esia menunu p̃isi rui, ana sanape nap̃a yoko mras wo lap̃asia kilia molue kome kiamiu visena lala? !Amiu na ape lus kiena ne lom̃ara kemua lelaga narui! ");
INSERT INTO lww_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yaru nap̃a po, p̃arpolo suri wo lala sike e losinena, ana silaga naga kiena sitomena wo tom̃a ga nap̃a kilia lalua va yaru. Ana yaru viowa, naga sum̃a p̃arpolo suri viowa lala sike e losinena, ana naga tap̃atete kilia lalua kiena sitomena wo tai pogos tai. ");
INSERT INTO lww_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Inu sineun nesape amiu akilia nap̃a e legiena na lip̃ereena, ana yaru la punu ga monar akila navisawalena tai vanon kiela visena viowa la veve taaga nap̃a apisa e kiela malena lala, ");
INSERT INTO lww_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","vanon nap̃a p̃isi na Ntewa naga lip̃ere kiom̃a malena e ga e kiom̃a visena lala. Nanene, vanon nap̃a kiom̃a visena lala akilia akila ko vena omal, pona akila ko vena owar nakoaena.” ");
INSERT INTO lww_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ana navianena na navisaluaena lap̃asia, amio Varasi lap̃asia, apisa pa Yesu, apisape “!Ei, ko nap̃a apio ko ke asape Navianena, imimi sinemimin mesape okila kile tai van imimi vena imimi mevisu kiom̃a nam̃areraena.” ");
INSERT INTO lww_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ana Yesu pisatam̃e la, pisape “Yaru la nap̃a sinelan ga asape avisu kile la sanene, la ape yaru viowa la pap̃isi, akila ke wowe pa Ntewa sane la nap̃a akila ke kolau. Peraga, p̃isi na tap̃atete amiu avisu kile tai, ana kile nap̃a kiena ne Navisawalena Sona sumo, naga ga nene na akilia avisuia. ");
INSERT INTO lww_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sona nene m̃eke e lom̃ep̃en pupia ika lesumsum nene pano-o tol legiena telu a lemalo telu, ana p̃isi na ve sa ke m̃ena ga nene e Narina ne Yeririna, nap̃a p̃isi na naga m̃eke e los nen porotano vano-o tol legiena ve telu a lemalo ve telu. ");
INSERT INTO lww_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ana la nae Ninive nanua sumo amloge visena kiena ne Sona narui, ana apilopu la, a e legiena na lip̃ereena, p̃isi na la nene asum̃alu avisa lologia kiamiu naviowaena lala, komin nap̃a yaru tai nap̃a naga to laa metavan Sona naga sike amio amiu nanagane, ana amiu na pe apilopu amiu re nenaga. ");
INSERT INTO lww_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Nanua m̃ena ga sumo, ana sira kawa tai naga pe p̃arin sup̃e tai, nap̃a naga mligan kiena purvanua nap̃a sike koperina pap̃isi, ana pitomi tano vena loge visena namanmaruaena kiena ne P̃arin Sup̃e Solomon. Ana sira kawa m̃ena ga nene p̃isi na sum̃alu e legiena nalip̃ereena, naga visa lologia kiamiu naviowaena lala, komin nap̃a yaru tai naga pe manmarua to laa metavan Solomon sane, naga sike amio amiu nanagane, ana amiu na pe sinemiun re nenaga.” ");
INSERT INTO lww_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ana Yesu pisa m̃ena ga, pisapenua “Pogos tai, pogos nap̃a visae am̃enelua yermare e yaru tai, yermare nene kilia va yom̃arua vena kaleli yo tai nap̃a va se ea vena ve m̃ana um̃a. Ana visae ve lual re, ");
INSERT INTO lww_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","p̃isi na naga visavenua, ‘A, p̃isi na nevito li si e m̃au um̃a marua na sumo wa.’ Ana pogos nap̃a naga wasup̃e vitomi, p̃isi na naga vitomi wal yum̃a nap̃a mon korena ga, ana merarava po pap̃isi, a akila ruru make suri la e yum̃a nap̃a p̃isi rui. ");
INSERT INTO lww_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ana naga kilia wasup̃e sina va were si yermare tap̃ena lala ve olua, nap̃a la apiowa manene la taulu naga sane, atomi amio naga, ana akilia ava si asike e los nen yaru nene. Ana yaru nene, nanua sumo kiena malena piowa, ana siraunia kiena malena viowa la sane. A p̃isi na ve sa ke m̃ena ga nene e malena kiena ne yaru viowa nanagane lala.” ");
INSERT INTO lww_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Pogos nap̃a Yesu pisi ke amio yaru la nene wa, ana anena amio wenla lala apimi aporu e yo nene, asum̃alu asum̃a ga vanua, la sinelan asape avis amio Yesu. ");
INSERT INTO lww_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ana yaru la tai nene pisa pa Yesu, pisape “Ei, anom̃a amio womla lala asum̃alu asike vanua, la sinelan asape avis re amio ko wa.” ");
INSERT INTO lww_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ana Yesu pisatam̃ea, pisape “?Ana ane pe aneu, a ane pe wolai lala?” ");
INSERT INTO lww_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ana naga kiar kiena nalogena lala, pisapenua “?Apisu ke yaru la ne asike ne? Aneu a wolai lala, yaru ne la nane asike ne. ");
INSERT INTO lww_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Komin visae yaru nap̃a kila ke ya nap̃a Ata nae ma e peni naga sinenania, yaru na sanene naga pe wolai, a pe vineu, a pe aneu.” ");
INSERT INTO lww_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","E ke e legiena nene, Yesu molue um̃a, pito totano e yepas nen pupia lapa nene vena vian yeririna lala. ");
INSERT INTO lww_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ana yeririna la moki pap̃isi apitomi puna e pogos nene narui, ana kila naga p̃iyu pa to meta e waa tai, ana yeririna la punu ga yo pule ga asike ura, ");
INSERT INTO lww_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ana naga pian suri moki pan la e ga e p̃akaiwa lala. Ana naga pisa pan la, pisape “Yaru tai pa peven kurusa e kana lokove. ");
INSERT INTO lww_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pogos nap̃a naga sum̃a sisilin ke kurus la nene, ana kurus lap̃asia kekapil pa e mrapa, ana siraunia manu lala apimi ate plan make ga. ");
INSERT INTO lww_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ana kurus lap̃asia akekapili pa e nap̃a kilavaru m̃eke tano, ana pe porotano po re teke meta poli. Ana akakapur vilaga, vanon porotano meninivi ga. ");
INSERT INTO lww_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ana pogos nap̃a mrae pa m̃arera, kekan kurus nen suri la nap̃a pitotovi memeu veraga, vanon p̃eligas lala pe pito ruru re tano poli wa. ");
INSERT INTO lww_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ana kurus lap̃asia akekapili apa e nap̃a sumo pe ate plan ruru re kilika viowa la e poli, ana p̃isi na kilika viowa nap̃a pitovi pimi keviu sina, ana piwo kare kurus nen suri la nap̃a pitotovi ne ana amarmare. ");
INSERT INTO lww_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A kurus tap̃ena si lap̃asia akekapil apa e porotano tai nap̃a po, ana akapuru po, ana ap̃ar mrasnela, nap̃a lap̃as ap̃ar mras tol ponotia taaga, lap̃asia ap̃ar mras tol lualima orai, a lap̃asia lualima telu.” ");
INSERT INTO lww_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ana Yesu pisa, pisape “Yaru nap̃a kiligana teke ea naga monar yagogon ruru visena nene.” ");
INSERT INTO lww_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ana siraunia, nalogena lala apimi puna ne Yesu apiunia, asape “?Vanon ya ne ko osum̃a opian ke yeririna lala e p̃akaiwa la sanene?” ");
INSERT INTO lww_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ana Yesu pisatam̃ea, pisape “Ntewa naga kila ke sape p̃isi na amiu akilia alual nakilia wanena kiena ne kiena nasup̃enena, ana naga tap̃atete la kiliaena ne va yeririna tap̃ena la nene. ");
INSERT INTO lww_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nevisa sanini van amiu, visae yaru nap̃a kiena suri moki rui, p̃isi na war va la sane vena ve moki va p̃isi, a yaru nap̃a pe kiena suri re poli, p̃isi na naga kilalu narin suri ya nap̃a naga kiena. ");
INSERT INTO lww_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sanene, nepian la e p̃akaiwa lala, vanon nap̃a la asum̃a apisuia, ana apisu kilale p̃ele ga, ana asum̃a amloge, ana amloge kilale p̃ele ga. ");
INSERT INTO lww_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yaru suri la ne sanene, akila narui ana Ntewa pisayu la nanua sumo rui e visena lelaga nap̃a Navisawalena Aisea pisawal sumo, nap̃a pisa pisape ‘Ana p̃isi na amiu aloge vano-o, ana tap̃atete alogekilale pogos tai. A p̃isi na amiu avisu vano-o, ana tap̃atete avisu kilale pogos tai, ");
INSERT INTO lww_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","vanon nap̃a amiu na sane yaru la nap̃a kiela sitomena la amarmare p̃isi rui, sa nap̃a ap̃iwo pulkiligala, a sane ap̃elawa rui. Visae ve akila re sanene, pona vera na akilia avisu kilale suria, a vera na akilia alogekilale suria, a vera na kiela sitomena akilia asitomkilale suria, ana sanene, akilia avilopu la aimi pun inu vena nekila ruru la.’ ");
INSERT INTO lww_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ana nevisa van amiu, kiau nalogena lala, navisa ruruena sike e amiu komin nap̃a kilamaramiu la asum̃a apisu ke suri la nap̃a amiu apisuia, a kiligamiu la amloge m̃a suri la nap̃a nesum̃a nepian amiu ke ea. ");
INSERT INTO lww_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Inu nevisa van amiu, navisawalena la moki amio yeririna kiena ne Ntewa lala la moki liu nanua sumo, nap̃a sinelan manene pap̃isi nap̃a asape avisu suri la nap̃a amiu apisu ke nanagane, ana pe apisu re poli, a la akilayon manene nap̃a aloge suri la nap̃a amiu amloge ke nanagane, ana pe amloge re nenaga.” ");
INSERT INTO lww_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ana Yesu pisa pan la, pisape “Amiu, ayagogo ruruia, p̃isi na nevisayu kinas nen p̃akaiwa nene, nap̃a naga pisayu yaru nene nap̃a pa peven kurusa e kana lokove. ");
INSERT INTO lww_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Suri nasumo, naga kurus la nap̃a kekapili e mrapa, naga sa nap̃a yaru la ne amloge nalologena wo nasup̃enena nene ana pe amloge kilale re poli. Kurus wo lala kekapil e kiela sitomena lala, ana yaru viowa nene nap̃a Yermare, naga pimi p̃ar plan ke sina ga nalologena wo nene e losinela. ");
INSERT INTO lww_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Tap̃ena, naga nene na kurus la nap̃a kekapili e yo nap̃a kilavaru m̃eke tano, a naga sa nap̃a yaru la ne amloge lologena wo nene, ana akekaran veraga, ");
INSERT INTO lww_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ana sa nap̃a p̃eligasa pe po re poli. Akilia asu ve plas ga, a visae pogos m̃arera tai, pona yaru la am̃ene la vanon nap̃a la amlelaga e visena kiena ne Ntewa, p̃isi na la aloru ke veraga. ");
INSERT INTO lww_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Tap̃ena m̃ena ga, naga na kurus la nap̃a kekapil e yo nap̃a kilika viowa sike ea, ana naga na sa nap̃a yaru la ne amloge lologena wo nene, ana la asitom manene la kiela malena lala, a sinelan manene la suri na yomarava nini. P̃elaga la nene apimi sane kilika viowa, ana la apiwo kare nalologena wo nene vena ve war re si mrasa e kiela malena. ");
INSERT INTO lww_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Ana na maro, naga na kurus la nap̃a kekapili e porotano nap̃a po, naga na sa nap̃a yaru la amiyagogo ruru e lologena wo nene, ana amloge kilale ruru po, ana ap̃ar mras nen nalologena nene e kiela malena lala, nap̃a sane lap̃asia ap̃ar lualima telu, lap̃asia ap̃ar sane lualima orai, a lap̃asia ap̃ar moki sane mrasa tol ponotia taaga.” ");
INSERT INTO lww_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ana Yesu pisa sina ga p̃akaiwa tap̃ena tai pan la, pisape “P̃elaga nap̃a Ntewa p̃ere yaru lala apimi loyum̃a e nasup̃enena kiena naga sanini. Yerkawa tai nap̃a naga pa peven kurus nen wit la nap̃a po e kana lokove, ");
INSERT INTO lww_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ana pogos nap̃a yaru lala amomalio ke kolemalo, kiena nasinekar tai naga pimi, mapila kurus nen vilum̃ini viowa tai e lokove nene p̃isi, ana pure pano. ");
INSERT INTO lww_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ana suri la lua nene apitotovi, ana lalua maran taaga ga, ana pogos nap̃a wit lala asiar nap̃a awar mrasa, ana yerkawa nene, kiena yaru na yum̃aena lala apisu kilalea sane vilum̃ini viowa m̃ena ga kapuru ke amio wit nene. ");
INSERT INTO lww_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ana la apimi puna, apiun tania, asape ‘?Yerkawa, sanape? Kurus la nap̃a tepeven e kom̃a lokove, ana kurus wo ga lala. ?Ana vilum̃ini viowa nene pimi sanape?’ ");
INSERT INTO lww_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ana naga pisa pan la, pisape ‘Peraga, nene na kiau nasinekar tai ne kila suri sanene.’ “Ana kiena yaru na yum̃aena lala apiun ke sina ga tania, asape ‘?Poga ga, ana sanape, sinom̃an osape imimi meva moure plan vilum̃ini viowa la nene?’ ");
INSERT INTO lww_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ana naga pisalup̃aria, pisape ‘Toko, aligan suwa wa. Visae amiu ava aure plan vilum̃ini viowa la nene, pona visae akila palia sa aure plan lae m̃ena ga amio wit la nene veraga. ");
INSERT INTO lww_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lalua akilia akakapuru m̃a veraga vano-o tol pogos na waren kinas nen wit imi. E ke e pogos nene, p̃isi na nekilia nevisa va yaru la nap̃a ava awar wit, vena ava ate ke ne vilum̃ini viowa nene sumo wa, aviaria e p̃egasia akoven va e kapi. Siraunia, la akilia ava ate wit lala vena awar vitomi um̃a.’” ");
INSERT INTO lww_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ana Yesu pisawal p̃akaiwa tap̃ena tai pan la, pisape “Nasup̃enena nae ma e peni naga sane kurus nen mras nen purpa tai nap̃a pito pelan te laki tai. ");
INSERT INTO lww_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kurus nene na ve tokak na ve tokak pap̃isi, ana pogos nap̃a kapuru pano-o, ana pimi pe purlaki tai nap̃a keviu taulu make purlaki tap̃ena lala, ana manu lala akila m̃ala ponovi lala e kana korowas lala.” ");
INSERT INTO lww_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A Yesu pisawal sina p̃akaiwa tap̃ena tai pan la, pisape “Nasup̃enena kiena ne Ntewa, naga sa nap̃a sira tai p̃alelar narin is amio puluyavi na kilaparavi e pupia pialora tai, ana narin is nene kilia kila kilaparavi la nene punu ga mlapa.” ");
INSERT INTO lww_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","E visena kiena ne Yesu la nene, naga pisawal suri la ne sanene pa yaru lala, a silaga naga pisi pan la e ga e p̃akaiwa lala. ");
INSERT INTO lww_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sanene, naga kila visena kiena ne navisawalena nanua sumo imi ve lelaga, nap̃a Ntewa pisa, pisape “P̃isi na inu nevisawal kiau visena lala e ga e p̃akaiwa, p̃isi na nevisawal suri la nap̃a tapolou su nakonua rui, asike ga perina wa, siar e pogos na siien yomerava nini, pimi tol nanagane.” ");
INSERT INTO lww_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ana Yesu mligan p̃ina lala, pa loyum̃a, ana kiena nalogena lala apimi puna, apiunia apisape “?Yesu, imimi sinemimi mesape ovisawal van imimi ya ne kinas nen p̃akaiwa na vilum̃ini viowa nap̃a kapuru ke e lokove na wit nene?” ");
INSERT INTO lww_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ana Yesu pisatam̃e la, pisape “Yerkawa nap̃a peven ke kurus wo lala, nane Narina ne Yeririna nene. ");
INSERT INTO lww_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A kana lokove nene, nane yomarava nini. A kurus wo la nene, nane yeririna la nap̃a asike loyum̃a e nasup̃enena kiena ne Ntewa nene. A vilum̃ini viowa la nene, nane yeririna kiena ne Yermare la nene. ");
INSERT INTO lww_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","A nasinekar nene nap̃a pa peven kurus nen vilum̃ini viowa nene, nane Yermare na ga. A pogos nawarpoloen kinas nen wit la nene imi, nane luas nen pog nini. A yaru na yum̃aena la nene nap̃a avanon ate wit awarpuloia, nane navisi lala. ");
INSERT INTO lww_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","A yum̃aena nene na warpiloena vilum̃ini viowa la nene vena asikapila, nane p̃elaga ke sina ga nene nap̃a p̃isi na imi e pogos maro, ");
INSERT INTO lww_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","nap̃a Narina ne Yeririna, naga ligan kiena navisi lala vena avano awar plan suri la nap̃a kila yaru lala amloru e mlamulena viowa, amio yaru la natap̃aen mlamulena viowa, vena ve asu re si veraga amio yaru la nasup̃enena kiena. ");
INSERT INTO lww_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","P̃isi na navisi lala akoven la ava e pupia kapi, e yo nap̃a yaru lala asum̃a ga atagi, a asum̃a ga akar ke maluela ea. ");
INSERT INTO lww_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ana siraunia, yaru mesmesu lala p̃isi na atego ve sa mrae, loyum̃a e nasup̃enena kiena ne Arimala. A yaru nap̃a kiligana teke e naga monar yagogo ruru e visena nene.” ");
INSERT INTO lww_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","A Yesu pisape “P̃elaga kiena ne yaru nap̃a sinenan sape va loyum̃a e nasup̃enena kiena ne Ntewa, sane p̃akaiwa nini: yaru tai pa pisu kinakinas nen porotano tai, ana naga milan pupia kilavaru wo tai nap̃a monyouyou ga m̃eke ea. Ana naga sinwan rurulein kilavaru nap̃ani, ana naga pitove p̃iliwilin plan make kiena suri lala punu ga, vena kilia vam ul lua kinakinas nen porotano nene, vanon nap̃a mloge po manene la pap̃isi e suri wo nap̃a m̃alia.” ");
INSERT INTO lww_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","A Yesu pisa m̃ena ga, pisape “A sa ke sina ga nini, p̃elaga kiena ne yaru nap̃a sinenan pisape va loyum̃a e nasup̃enena kiena ne Ntewa, sa ke m̃ena ga nini: yaru tai nap̃a naga pul ke kilavaru yuwowo la nap̃a po tan yaru lala, nap̃a sike loyum̃a e mratamelilivi. ");
INSERT INTO lww_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ana pogos tai naga m̃al tai nap̃a po na po, pisa pisape ‘!Lelaga p̃a, in na sineun suri nene pap̃isi wa! Visae in na nokus ga ve kiau ga rui vera wo wa. Yoko in na neto nowilwilin plan make kiau suri tap̃ena lala, vena nevam nowul lua suri wo nini.’” ");
INSERT INTO lww_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ana Yesu pisa ke sina ga, pisape “A naga ke sina ga, p̃elaga kiena ne Ntewa nawereen yaru lala ava loyum̃a e kiena nasup̃enena, naga sa m̃ena ga nini, nap̃a pogos na yaru la ap̃ure lilivi e lapa, la akilia asuwoia ana aure ika la nap̃a veve tap̃ena ve moki vap̃isi ea. ");
INSERT INTO lww_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ana pogos nap̃a lilivi pule ruru po, ana yaru lala ap̃urelua pa ura e yomema, ana atapurpurga atotano, amlip̃ere ika lala. Ana ika la nap̃a po, akon apito e kiela karo lala, a ika la ne piowa, ana akuwani pano. ");
INSERT INTO lww_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","P̃isi na ve sa nene e luas nen pogos nini, nap̃a p̃isi na navisi lala ava alip̃ere yaru lala, awere plan yeririna viowa lala, ");
INSERT INTO lww_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","vena akoven la ava e pupia kapi nene, nap̃a yaru lala asum̃a ga atagi, a asum̃a ga akar ke maluela ea.” ");
INSERT INTO lww_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ana Yesu piun tan kiena nalogena lala, pisape “?Amiu amloge kilale ke visena la nene?” Ana lala apisatam̃ea, asape “Ee, pona mekilia m̃a yo.” ");
INSERT INTO lww_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ana naga pisa pan la, pisape “Suri la nene naga sane yaru tai nap̃a sumo, naga pe navianena tai e navisaluaena lala na Visena Wa kiena ne Ntewa, ana siraunia, naga pimi sane kiau nalogena tai e nasup̃enena kiena ne Ntewa. Yaru na sanene naga sane yerkawa tai nap̃a kiena suri wo na yum̃aena lala moki e m̃ana yum̃a. Ana silaga naga kilia lalua kiena suri marua nap̃a po ke ga wa, akilia m̃ena ga lalua kiena suri viu, vena kila kiena yum̃aena amio la.” ");
INSERT INTO lww_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ana pogos nap̃a Yesu pisawal p̃akaiwa la nene p̃isi, naga molue e yo nene, ");
INSERT INTO lww_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","p̃asup̃e sina ga pimi kiena. Ana naga sum̃a pian ke yaru lala nae yo nene, loyum̃a e kiela yum̃a na leniena, a la sinela kurkurun kiena visena la pano pap̃isi. Ana la asum̃a apisavisa ke pan la, apisape “!Aulai! ?Yaru nene tol nakiliaena na sanene sanape, a naga kila ke kile la nene sanape? ");
INSERT INTO lww_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ita tekilia ke yaru nene rui. Naga arimana, yaru na yum̃aenen ga yum̃a, nap̃a Yosop, a anena naga nap̃a Maria. A wenla lala yaru la nene, Semes, a Yosop, a Saemon, a Sutas, naga pe wenla la nene. ");
INSERT INTO lww_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A vinena lala, la ga nene nap̃a asike ga amio ita ne. ?Ana yaru nene naga molue pun ita pa p̃ar suri la nene pe?” ");
INSERT INTO lww_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ana sinela karia, pe sinelan re nena naga. Ana Yesu pisa pan la, pisape “Yaru nap̃a pe navisawalena, yaru tap̃ena lala akilia avatanon naga, ana yaru na m̃ana mratava lala, amio yaru na kiena yo lala, la ga nene na tap̃atete avatanon naga.” ");
INSERT INTO lww_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ana e yo nene, naga pe kila re kile la moki e poli, vanon nap̃a pe amlelaga re e naga poli. ");
INSERT INTO lww_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","E pogos nene, apisayu Yesu pa tol Sup̃e Erot, nap̃a naga pe p̃arin sup̃e e lepas nae garu Kalele. ");
INSERT INTO lww_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ana Sup̃e Erot mloge visena la nene, ana naga pisa pan kiena yerkawa lala, pisape “?Yaru nene nap̃a apisayu ke ne, pona naga Yoane Nakeena nene, nap̃a nanagane naga mali sina e marena yo? Vanon suri ne nanene, naga kila naga tol nam̃areraena nakilaena kile la nene.” ");
INSERT INTO lww_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ana Sup̃e Erot pisa sanene, vanon nap̃a naga m̃em̃ar Yoane Nakeena mare rui, ana naga marau pap̃isi. Ana marena kiena ne Yoane Nakeena kana suniena nena sanini: wenla Sup̃e Erot nene, naga kiena kia Pilip, nap̃a lalua arimala taaga, ana anela lua. Ana sumo, Pilip nene talopa amio sira tai, kiena kia Lerotias. Ana siraunia, Sup̃e Erot pa p̃erelua sira nene. Ana e pogos nene, Yoane pisi pa Sup̃e Erot, pisape “Suri nene pe mesmesu re nene poli, nap̃a ko oure sira nene, komin naga pe wona ne womla.” Ana Erotias naga pe kekaran re nena visena kiena ne Yoane poli, ana naga pisi pa Sup̃e Erot, ana Sup̃e Erot mligan kiena yeririna la p̃asia apa atarar Yoane, ana apiari naga, amligan naga pa e yum̃a nakoaena. ");
INSERT INTO lww_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ana Sup̃e Erot sape wem̃ar Yoane, ana naga maraun li m̃a le Israel lala, vanon nap̃a amlelaga e Yoane asape naga pe kiela navisawalena tai. ");
INSERT INTO lww_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ana Lerotias nene, naga narina na lom̃earu m̃a tai, ana pogos nap̃a la akila p̃ap̃agena nasitom̃alena legiena nap̃a Sup̃e Erot paeme ea, lom̃earu nene naga polu e marana ne la nap̃a asike lele taaga e p̃ap̃agena nene. Ana Sup̃e Erot kekaran kiena wolena pap̃isi, ");
INSERT INTO lww_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ana naga pisaar m̃arera pan lom̃earu nene, pisape suri ya nap̃a naga visa, p̃isi na naga la vania. ");
INSERT INTO lww_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ana Lerotias pisi amio narina nap̃a sira m̃ee nene, ana sira m̃ee pa pisalein pa Sup̃e Erot, pisape “In na sineun nesape okus p̃arina ne Yoane Nakeena, m̃ene pialo tai, imi van inu nagane ga ne e nini.” ");
INSERT INTO lww_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ana visena nene kila Sup̃e Erot mloge piowa vanon kiena navisalaweena nene, ana naga pisape akila ga ve sa nap̃a sira m̃ee nene pisa, vanon nap̃a naga pisaar m̃arera sanene e marana ne kiena erau la p̃isi rui. ");
INSERT INTO lww_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ana apa e loyum̃a nakoaena nene, atelua kolmekina ne Yoane, ");
INSERT INTO lww_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ana la amligan p̃arina m̃ene pialo tai, akus pimi pa sira m̃ee nap̃ani, ana sira m̃ee nene kus pa anena. ");
INSERT INTO lww_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ana siraunia nalogena kiena ne Yoane lala apimi akus tasnena, apa asinia, ana apano apa apisawal pa Yesu. Suniena kiena ne Yoane Nakeena nane maro e nene. ");
INSERT INTO lww_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ana pogos nap̃a Yesu mloge sanene, nap̃a Sup̃e Erot naga pisayu ke m̃ena naga, sape naga Yoane Nakeena nap̃a mali sina petan marena, ana Yesu molue e yo nene, ana p̃iyu e waa tai, vena va e yo m̃ano tai nap̃a pe yaru re e poli. Ana pogos nap̃a yeririna lala akilia asape naga pa ke e sanene, la m̃ena ga amolmolue e kiela pulkumali lala, la amial akom ura. ");
INSERT INTO lww_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ana pogos nap̃a Yesu pa ura, naga pisu nap̃a p̃ina na yeririna m̃eke pa ura rui, ana naga sinena mie la pap̃isi, ana naga kila ruru si kiela yaru namaiena lala apimi apo sina. ");
INSERT INTO lww_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ana pogos nap̃a mrae pito tano, nalogena lala apimi puna Yesu, apisa apisape “Ei, Sup̃e, yo nini pe po re nenaga, a lavisi m̃ena ga yemalo narui. Popon ko oligan p̃ina na yeririna la nene awasup̃e ava e pulkumali lala vena auli kala kinanena la p̃asia.” ");
INSERT INTO lww_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ana Yesu pisatam̃e la, pisape “Toko, akilia asum̃a ga ve sanene woga ga ne. Popon amiu awar kinanena lap̃asia van la.” ");
INSERT INTO lww_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ana la apisa, apisape “!Ke peraga yo, imimi memlarar narin kilaparavi lima ga teke na, amio narin ika nap̃a satin lua ga!” ");
INSERT INTO lww_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ana Yesu pisape “Ala imi van inu,” ");
INSERT INTO lww_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ana naga pisi pan yeririna la nene, pisape “Amiu atotano e vilum̃ini sumo wa.” Ana naga mla narin kilaparavi lima amio narin satin lua nap̃ani, kirava pa metava ma e sinapane, pisa potena pa Ntewa vanon kinanena nene, ana kauroro narin kilaparavi lima nap̃ani, kian pa kiena nalogena lala vena avion plan va yeririna la nene. ");
INSERT INTO lww_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ana la akan pano-o, m̃ep̃ela kawa pap̃isi, ana kinakinas nen kinanena la nap̃a pe akan re poli, torokin akon va e karo mavava la nap̃a kerkeviu ve lualima taaga pa lua. ");
INSERT INTO lww_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ana yaru la nap̃a akan kinanena nene, la pa sane manu lima, ana pe apulo re sira la poli amio ninis lala. ");
INSERT INTO lww_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ana Yesu pisa pan kiena nalogena lala, pisape “Inu sineun nesape amiu akus kieta waa, ana asumo akusro pupia lapa nene ava lepas p̃asia navano, ana in na nesuwa nesum̃a neligan plan kone yeririna la awasup̃ela avano wa.” ");
INSERT INTO lww_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ana pogos nap̃a naga mligan plan yeririna lala apavano p̃isi, ana naga pa metava e kunus tai, naga taaga, vena len. Pogos nap̃a yemalolo, Yesu naga ga taaga sike na, ");
INSERT INTO lww_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ana e pogos nene, waa nene m̃eke perina pap̃isi, m̃eke likan lapa nap̃ani, m̃eke va yotena narui. Ana sive keviu, a la asum̃a akawe lagi pap̃isi, a kila sane akus m̃ena ga sive nap̃a akus sive. ");
INSERT INTO lww_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pogos nap̃a lavisi yelagi merarava, Yesu pimi pula, naga mial yau ga metava e wos nen sive. ");
INSERT INTO lww_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pogos nap̃a kiena nalogena lala apisu naga mial yau ke e wos nen sive pimi pula sanene, amarau pap̃isi, apisa apisape “!Aulai! ?Suri ya na pimi ke sanene? ?Yermare yo, pona ya ne sanene?” A la asum̃a ga amlolokai keviu, vanon nap̃a la amarau pap̃isi, ");
INSERT INTO lww_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ana Yesu pis pan la vilaga, pisa pisape “!Ei, ve amarau re, in ga nini!” ");
INSERT INTO lww_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ana Pita pisatam̃ea, pisape “Sup̃e, visae ko kemua nene, otam̃an nap̃a inu m̃ena ga neyal yau metava e wos nen sive, neim̃asu pum̃a.” ");
INSERT INTO lww_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ana Yesu pisa, pisape “Ko, poga, otomi.” Ana Pita mligan waa, pito tano, siar mial yau e sive, pa lavisin Yesu, ");
INSERT INTO lww_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ana pogos nap̃a naga sitom̃al si lagi m̃arera nene, naga marau. Naga marau sanene, siar mian pito tano narui, ana naga pio Yesu, pisape “Sup̃e, ko otamalia inu.” ");
INSERT INTO lww_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ana Yesu kian limana pa veraga, tarar Pita, ana pisa pania, pisape “?Vanon ya ne sinem̃a miyuwawa sanene? !Ko pe opiawa re nena kawa e inu poli wa!” ");
INSERT INTO lww_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ana pogos nap̃a lalua ap̃iyu si apa meta e waa, lagi nene mare, ");
INSERT INTO lww_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","a la nap̃a e waa amieluar Yesu, apisa, apisape “Lelaga kemua, ko ope narina ne Ntewa lelaga.” ");
INSERT INTO lww_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ana Yesu lala akusro pupia lapa nene e kiela waa, apa e lap̃as p̃asia, ana apa ura e yo tai, kiena kia Kenasaret. ");
INSERT INTO lww_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ana pogos nap̃a yaru lala nae e yo nene apisu kilale Yesu, amligan visena telivi piora pa e yo punu ga. Ana yaru lala ap̃ure namaiena lala apimi puna, ");
INSERT INTO lww_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","apiun tan naga vena naga tam̃an namaiena lala atol ga m̃ana isinen kulkota. Ana la nap̃a atol ga sanene, kiela maiena la kokovio nenaga, apimi apowo sina. ");
INSERT INTO lww_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ana e pogos nene, Varasi la p̃asia amio navianena navisaluaena lap̃asia amolue garu Yerusalem, apimi apisu Yesu. ");
INSERT INTO lww_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Apiun tan naga, apisa apisape “?Vanon ya ne kiom̃a nalogena lala pe ataveve ruru re kieta p̃elaga marua na lotuen nanua sumo poli, nap̃a kieta nasumonena lala apian ita, sa nap̃a la asum̃a apisa, apisape visae yaru tai sinenan sape kinana, naga monar taveve ruru p̃elaga mesmesu lala na kevanen limana sumo wa, ana p̃isi na naga kilia kinana?” ");
INSERT INTO lww_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ana Yesu pisatam̃e la, pisape “?Ana amiu m̃ena ga, vanon ya ne amiu am̃areran nap̃a ataveve kiamiu p̃elaga marua lala, ana e kiamiu p̃elaga marua la nene, amiu asum̃a akilaro ke navisaluaena kiena ne Ntewa? ");
INSERT INTO lww_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ana Ntewa pisa rui, pisape ‘Ovatano e arimom̃a amio anom̃a,’ a naga pisa m̃ena ga, pisape ‘Yaru nap̃a pisi piowa pan arimana pona anena, awem̃ar naga mare.’ ");
INSERT INTO lww_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ana nanagane, pogos nap̃a yaru tai visaar visave kiena suri lala ve suri wa, p̃isi na la va Ntewa pogos tai, ana naga pisa sanene ana siraunia naga pe pisuar ruru re kiena yermarua la luwoka poli, pona ve iila re si la luoka e suri la nene, ");
INSERT INTO lww_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ana amiu asum̃a ga apisa ke asape sanene na poga ga ne, pe pe sur re tai nene poli. A e p̃elaga nene, amiu asum̃a ga akila ke navisaluaena kiena ne Ntewa pimi pe suri korena ga tai ne, vanon nap̃a amiu sinemiun asape auarar ga kiamiu p̃elaga marua lala. ");
INSERT INTO lww_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","!Ana amiu na apisokani ke nene, amiu apisi korena ga ne! Navisawalena Aisea naga pisayu amiu sumo rui, nap̃a naga pisawal visena nene nap̃a Ntewa pisa, nap̃a pisa pisape ");
INSERT INTO lww_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Yaru la nene apatanon inu e ga e kiela visena lala, ana kiela sitomena lala asike perinan inu wa. ");
INSERT INTO lww_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Akila ke lotuena pan inu, ana pe suri korena ga, vanon pogos nap̃a akilapian yeririna lala, apisa ke asape visena nene naga pe visena kiena ne Ntewa nene, ana visena la nene pe kiela ga la ga yeririna lala.’” ");
INSERT INTO lww_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ana Yesu pio viraviran yeririna lala vena aimi puna, ana naga pisa pan la, pisa pisape “Amiu ayagogo ruruia, amiu monar alogekilale kiau visena nene. ");
INSERT INTO lww_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Pe kinanena re nap̃a pa e logon yaru poli nap̃a kilia kila naga namname e marana ne Ntewa, ana visena lala nap̃a molue e logona yaru, suri ne nanene naga kilia kila naga namname.” ");
INSERT INTO lww_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ana siraunia, kiena nalogena lala apimi, apisa pania, apisape “?Ei, ko okilia m̃a nap̃a Varasi lala sinela mimi pap̃isi vanon kiom̃a visena la nap̃a osum̃a opisa ke ne?” ");
INSERT INTO lww_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Ana Yesu pisatam̃e la, pisape “Amiu na ve asitom re yaru la nene. Ya nap̃a la asum̃a akila ke ne, naga pe yum̃aena kiena ne re Ntewa nene poli, a yoko kau Ata nae ma e peni, p̃isi na naga wereplan make suri la nap̃a naga pe mapila re poli. ?Yeririna la nene na ape kilamara p̃ala ga, ana sinelan asape asumoni yeririna lala, ana sanape narui, yaru tai nap̃a pe kilamara p̃ala kilia sumon yaru tap̃ena nap̃a pe kilamara p̃ala lalua ayal? !P̃isi na lalua akilia aloru veraga atotano e p̃ilip̃ili tai ne!” ");
INSERT INTO lww_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ana Pita piun tan Yesu, pisape “Sup̃e, sineun nesape ovisawal ke ne kinas nen p̃akaiwa nene sumo wa, nap̃a opisa p̃esan ga na wa.” ");
INSERT INTO lww_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ana Yesu pisa pisape, “?Sanape ne, pona p̃arimiu m̃ena ga merorol ke yo wa? ");
INSERT INTO lww_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Pona amiu akilia m̃a ve tokak ga yo, nap̃a suri ya nap̃a vito kome logona yaru, pito tano vitove kome m̃ep̃ena narui, ana kilia pa vanua si kome tasnena, ");
INSERT INTO lww_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ana suri ya nap̃a molue e logona yaru, naga molue e losinena sumo, a suri ne nanene, naga kilia kila yaru namname. ");
INSERT INTO lww_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Naga nene na vanon nap̃a nasitomiena viowa lala amomolue e los nen yaru, sa nap̃a nawemom̃aren yaru, natap̃aen kolau, nakilaena lau, navinauena, navisokanena, a nasisiena visena. ");
INSERT INTO lww_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nanene p̃elaga la nap̃a akilia akila yaru namname e marana ne Ntewa. A p̃elaga nene nap̃a yaru kinana ana pe ke re limana sumo poli, suri nene naga tap̃atete kila yaru namname sanene.” ");
INSERT INTO lww_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ana Yesu molue e yo nene, naga pito e lepas nap̃a pulkumali lua asike ea, nap̃a Taea amio Saeton. ");
INSERT INTO lww_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ana sira tai nae lepas nap̃a Kenan, naga pe wolawa ga, sike e lepas nene, ana naga pimi puna ne Yesu, pio naga, pisape “Sup̃e, ko ope Navisaarena nap̃a ko omolue e lus kiena ne Tepet, neviun tan ko vena sinem̃a ye inu. Kiau lom̃earu, yermare tai sike e naga, nap̃a sum̃a kila kare naga silaga.” ");
INSERT INTO lww_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ana Yesu mloge visena nene, ana pe pisa re nena suri tai pa sira nene poli. Siraunia, nalogena lala apimi, apisa pa Yesu, apisape “Sira nene sum̃a taveve ita ke sanene na, naga sum̃a pio manene liu wa. Popon oligan lua naga vano.” ");
INSERT INTO lww_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ana pe Yesu pisatam̃e la re poli, ana naga pisi pa sira nene narui, pisa pania, pisape “Ntewa mligan inu nepimi vena neva ga puna ne le Israel lala, la nap̃a sane sipsip la nap̃a akila pal mrapa.” ");
INSERT INTO lww_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ana sira nap̃ani pimi, kinai tano e lana ne Yesu, pisape “Awis, Sup̃e, nepiun tan ko, nesape oiila inu.” ");
INSERT INTO lww_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ana Yesu pisatam̃ea, pisa pisape “Ana pe mesmesu re nap̃a nelalua kinanena kana ne nisisi lala, vena nela va lokul poli.” Naga pisi sanene vanon nap̃a naga kilia m̃a sape e pogos nene, le Yu tap̃ena lala, nap̃a la asitom asape la ga ape narina ne Ntewa, asum̃a apisayu kare yaru la nap̃a pe ape le Yu re poli, apisape la ape lokul ga la ne. ");
INSERT INTO lww_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ana sira nene pisi, pisa pisape “Ko opisa pe lelaga, Sup̃e, ana lokul lala akilia akan m̃ena kororos nen kinanena nap̃a amloloru vatano e lelen kinanena kana ne taena ne lokul lala.” ");
INSERT INTO lww_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ana Yesu pisatam̃e ruru naga narui, pisa pisape “Sira, ko opiawa ruru ke m̃arera e inu pap̃isi. P̃isi na ko ovisu ga nanagane imi van ko ve sa nap̃a ko omlelaga ea.” Ana e ke e pogos nene narui, sira m̃ee kiena ne sira nene pimi po sina. ");
INSERT INTO lww_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Siraunia, Yesu molue ke sina ga e yo nene, p̃asup̃e si pa lepas nap̃a Kalele. Naga sum̃a mial pano, ana pa kom ga lavisin pupia lapa na lepas nene, ana pa totano metava e kunus tai. ");
INSERT INTO lww_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tom̃a sane, ana p̃egas nen yeririna lala apimi puna, amio laulu lala, amio latakin lala, amio kilamara p̃ala lala, amio kiligapop̃e lala, amio m̃ena namaiena tap̃ena m̃ena ga lap̃asia. Ana ap̃ar la nene apimi, amligan la asike ga lavisin Yesu, ana Yesu kila ruru la apo ke sina ga. ");
INSERT INTO lww_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ana yeririna lala sinela kurkuru pap̃isi, pogos nap̃a apisu puru lala apisi, latakin lala apimi apo, laulu lala amial po, a kilamara kata lala akirava, ana la amieluar Ntewa kiena ne le Israel lala pap̃isi vanonia. ");
INSERT INTO lww_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ana Yesu pio kiena nalogena lala apimi puna, ana naga pisa pisape “Inu sineu mie p̃ina na yeririna la nene pap̃isi wa, komin nap̃a asike amio ita legiena telu narui, ana pe kala kinanena re si poli. A inu tap̃atete neligan la ava si um̃a nap̃a pe kala kinanena re sanene poli, vanon nap̃a visae nekila sanene, pona e mrapa komsusa ana yaru lap̃asia viso kar la vano-o marala malko yo.” ");
INSERT INTO lww_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ana nalogena kiena ne Yesu lala apisa pania, apisape “?Ana p̃isi na ita towar kala kinanena pe ne? Ana komin yo nini na yo korena ga nini, a la moki manene la wa.” ");
INSERT INTO lww_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ana Yesu piun tan la, pisape “?Ana amiu kamiu kilaparavi via na sike na?” Ana la apisa, pisape “Olua ga, amio narin ika nap̃a satin lap̃asia.” ");
INSERT INTO lww_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ana Yesu pisa pa p̃ina na yeririna la nap̃ani, pisape “Atotano e nene sumo wa.” ");
INSERT INTO lww_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ana naga p̃ar kilaparavi la olua nap̃ani, amio narin ika nap̃a satin la nene, ana naga pisa potena pan Ntewa vanonia, ana siraunia ana kawewowala, ana kian pa kiena nalogena lala, ana la lein ap̃ar apiovion pa yeririna lala. ");
INSERT INTO lww_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ana la punu ga akan pano-o m̃ep̃ela kawa ruru po pap̃isi. Ana siraunia, akon kinakinas nen kinanena la nene nap̃a sike na, pa e karo popos olua, ana puleule pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ana yerm̃ene la nap̃a akania, tol manu vari, ana pe apulo re sira lala amio ninis la poli. ");
INSERT INTO lww_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ana Yesu mligan p̃ina na yeririna la nene ap̃asup̃e apa si um̃a, ana naga pa si e kiela waa, ana mligan yo nene, pimi suli ga plas ga e lepas nap̃a kumali keviu nap̃a Makatan m̃eke ea. ");
INSERT INTO lww_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ana pogos tai Varasi la p̃asia amio Satusi la p̃asia apimi puna Yesu, nap̃a sinelan asape akilali naga, ana apisa, apisape “Imimi sinemiminia mesape ko okilali pupia kile tai van imimi, nap̃a ko okila e puriukawa nae ma e peni.” ");
INSERT INTO lww_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ana Yesu pisatam̃e la, pisape “Pogos nap̃a mrae pito ke tano, ana visae amiu avisu nap̃a yo vivaga e lepas nap̃a mrae pito ke tano ea, amiu akilia avisa avisave ‘P̃isi na yepisun peni,’ ");
INSERT INTO lww_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","a pogos nap̃a mrae pa p̃arpo yo, a visae amiu avisu sinapane tano vivaga a lul la malolo m̃ena ga metavania, amiu akilia avisave ‘P̃isi na yua kove p̃ane.’ ?Nane amiu asum̃a apisu kilale ke kile la nene e sinapane p̃isi narui, nap̃a p̃isi na pog ve sanape pona ve sanape, ana sanape nap̃a amiu pe apisu kilale re kiau kile lala na pog keviu nini nap̃a nesike nemio amiu poli?” ");
INSERT INTO lww_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ana Yesu pisa m̃ena pan la, pisape “Yaru la nap̃a sinelan ga avisu kile lala, la ape li viowa la pap̃isi, la akila wowe pa Ntewa, la apilon m̃asila pania, sane la nap̃a akila lau, ap̃ure matan wola lala. Peraga, p̃isi na tap̃atete amiu avisu kile tai narui, ana yoko amiu avisu ga nap̃a m̃alivi e inu ve sa ke ga kile nap̃a pa Navisawalena Sona nanua sumo, nap̃a Ntewa kila naga mali sina.” Ana Yesu purmatan la, naga mligan la asikena. ");
INSERT INTO lww_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ana pogos nap̃a Yesu amio kiena nalogena lala amligan e nene, ana ap̃aro e pupia lapa nap̃a apa e lepas p̃asa, ana nalogena lala sinela p̃esania nap̃a pe ap̃ar re si kala kilaparavi lap̃as poli. Ana pogos nap̃a atol lepas p̃asa, ");
INSERT INTO lww_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ana Yesu mla visena tai pan la, pisape “Amiu na monar avisuar ruru amiu, e is kiena ne Varasi lala amio Satusi lala.” ");
INSERT INTO lww_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ana la amloge visena nene, ana la apisayulein pan la, apisape “?Pona naga pisi sanene vanon nap̃a pe top̃ar re kilaparavi lap̃as pimi poli yo?” ");
INSERT INTO lww_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","9","Ana Yesu kilia m̃a kiela sitomena nene narui, pisape “?Pe na ya nap̃a amiu asitom manene ke m̃ep̃emiu la sanene, nap̃a apisape yoko takan ya ne? ?Sanape nap̃a amiu pe amloge kilale re suri la nene poli wa? !Kiamiu lelagaena ve tokaki pap̃isi wa! ?Pona amiu sinemiu p̃esan m̃ena ga kilaparavi la lima nene yo, nap̃a inu nemla pa yeririna lala tol manu lima nene, amio m̃ena karo la nap̃a amiu akon puleule? ");
INSERT INTO lww_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","?Pona amiu sinemiu p̃esan m̃ena ga kilaparavi la olua nene, nap̃a inu nemla pa yeririna lala tol manu vari nene yo, a karo via nap̃a amiu akon sirau? ");
INSERT INTO lww_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","?Sanape nap̃a amiu pe amloge kilale re nap̃a pe nepisi re pan amiu vanon kilaparavi poli? Inu nevisa ke sina ga van amiu, nesape amiu na monar avisuar ruru amiu e is kiena ne Varasi lala amio Satusi lala.” ");
INSERT INTO lww_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ana e pogos nene, la akilia m̃a nap̃a naga pe pisayu re is nakilaen kilaparavi pan la poli, ana naga pisa ke visena navisokanena la nap̃a Varasi lala amio Satusi lala akilia avian la ea, nap̃a kilia kila p̃arin yaru lapa imi ve keviu, ana kilia kila kare make kiena malena, sa nap̃a is na miyum̃aen ke e kilaparavi. ");
INSERT INTO lww_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ana Yesu lala apito garo e lepas nap̃a pulkumali keviu nene Sisaria Pilip̃ae m̃eke ea, ana e pogos nene naga piun tan kiena nalogena lala, pisape “?Amiu asum̃a amloge m̃a nap̃a yeririna lala asum̃a ga apisavisa ke Narina ne Yeririna, apisape naga ai?” ");
INSERT INTO lww_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ana lala apisa, apisape “La p̃asia apisa apisape ko Yoane Nakeena ke sina ga, a la p̃asia apisape ko Elaisa, a la p̃asia apisape ko Serem̃aea, pona navisawalena tap̃ena tai na nanua sumo.” ");
INSERT INTO lww_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ana naga piun tan la, pisape “?Ana amiu, amiu na asape inu na ai?” ");
INSERT INTO lww_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ana Saemon Pita pisatam̃ea, pisape “Ko, ko na Navisaarena, ko ope Narina ne Ntewa Mali.” ");
INSERT INTO lww_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ana Yesu pisatam̃e pania, pisape “Saemon, narina ne Yoane, navisa ruruena imi van ko. Suri nap̃a ko opisa ne, pe yaru re na pian ko e poli, ana Ata ga nae ma e peni naga pian ko ea. ");
INSERT INTO lww_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A ko nene ko kiom̃a kia tap̃ena nap̃a Pita, naga kana kinasia sanini, sane ‘kilavaru,’ ana lelaga pap̃isi, sa nap̃a nanagane, in na nepisu ko na sane ko ope varsu tai, ana p̃isi na in na nevisirlua p̃egas nen kiau li nalotena lala e kilatapili na sanene narui, a puriukawa na marena tap̃atete kilia taulu p̃egas nene. ");
INSERT INTO lww_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","P̃isi na in na nela kii lala navietavanena amio nakotaween nasup̃enena kiena ne Ntewa van ko, a suri ya nap̃a ko ovisalup̃ar e yomarava nini, ana Ntewa nae ma e peni naga m̃ena ga visalup̃aria amio ko, a suri ya nap̃a ko otam̃ania e yomarava nini, ana Ntewa nae ma e peni naga m̃ena ga tam̃ania amio ko.” ");
INSERT INTO lww_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ana Yesu pisa m̃arera pa kiena nalogena lala, pisape “Amiu na ve ava avisawal re van yeririna la avisave in na nepe Navisaarena.” ");
INSERT INTO lww_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ana siar e pogos nene, Yesu kilali nap̃a kila merarava va nalogena lala, sape naga monar va ma Yerusalem, ana e yo nene, p̃isi na sup̃e kiena ne le Israel lala, akila kare manene naga vap̃isi, amio p̃arin yaru wa lala, amio m̃ena ga navianena navisaluaena lala, la make narui p̃isi na akila kare naga vap̃isi. Yesu pisa m̃ena ga pisape p̃isi na la nene awem̃ar naga mare, ana kana legiena na telu p̃isi, Ata Ntewa kila naga sum̃alu mali sina. ");
INSERT INTO lww_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ana pogos nap̃a Pita mloge visena nene, piolua Yesu pano, pisi m̃arera pania, pisape visalup̃aria, pisape “Yesu, Ntewa monar visalup̃ar suri nene. Suri la nene tap̃atete kilia imi ve lelaga e ko ve sa nene.” ");
INSERT INTO lww_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ana Yesu pilopuia, pisi m̃arera pa Pita, pisape “!Yermare Lego, oure vetan inu! Ko osum̃a okilali inu ke sina ga e kiom̃a sitomena nene nap̃a pe sitomena kiena yaru ga, pe sitomena kiena ne Ntewa re nena ga.” ");
INSERT INTO lww_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ana Yesu pisa pa kiena nalogena lala, pisape “Yaru nap̃a sinenan sape siraun inu, monar sitom korenan ga kiena nasinenanena lala, ana monar kus kiena laki torovia, ana taveve inu. ");
INSERT INTO lww_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yaru nap̃a sinenan sape visuar ruru kiena malena, naga p̃isi na kilaluia, ana yaru nap̃a naga kilalu kiena malena vanon inu, naga p̃isi na kilia tol malena lelaga. ");
INSERT INTO lww_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ana visae yaru tai naga tol make suri na yomarava la punu ga, ana kilalu mrapa na malena, naga pe taulu re nena suri wo napo lelaga tai poli, ana siraunia, tap̃atete kiena suri wo la nene aulimaran si kiena malena. ");
INSERT INTO lww_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ana lavisi ke Narina ne Yeririna wasup̃e ke sina ga imi narui amio navisi lala, naga imi amio naurarena kiena ne Arimana, ana naga ul yaru lala mesmesun kiela nayum̃aen lala. ");
INSERT INTO lww_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Inu nevisa suri na lelaga nene van amiu, nesape yaru la p̃asia asum̃alu asike e nini, nap̃a p̃isi na tap̃atete amare asum̃a ga vano-o avisu Narina ne Yeririna warpoyo amio kiena nasup̃enena, vena vim ve sup̃en yeririna la punu ga.” ");
INSERT INTO lww_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Siraun e pogos nene, legiena orai p̃arovia, ana Yesu p̃ere Pita, a Semes, a wenla nap̃a Yoane, ana la ga vari nene apa metava e ravie tai. ");
INSERT INTO lww_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Asum̃a sanene, ana nalogena la telu nene apisu nap̃a yepena ne Yesu pimi ke pe tap̃ena, a marana pilavila manene sa nap̃a mrae, a m̃ana kulkota lala apimi amiyuwowo pano-o amiyuwowo po pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ana la telu nene apisu m̃ena ga Mosis amio Elaisa, lalua am̃aliv, ana lalua asum̃a ga asun ke amio Yesu. ");
INSERT INTO lww_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ana Pita pisa pa Yesu, pisape “Sup̃e, popon tanea ita tesum̃a ga e yo nini. Visae ko sinom̃ania, ana neyum̃aen silparpara ve telu e nini, mom̃a tai, m̃ana ne Mosis tai, a m̃ana ne Elaisa tai.” ");
INSERT INTO lww_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ana pogos nap̃a Pita sum̃a pisi ke ga wa, ana lul tai nap̃a pilavila pap̃isi pitomi kalo la, ana amloge visena tai molue e lul nene, pisa pisape “Nene na naruu nene, nap̃a in na nesitom naga pap̃isi. Kiau sitomena sike ga e naga, a nekekaran naga pap̃isi. Amiu na monar alogear ruru naga.” ");
INSERT INTO lww_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nalogena lala amloge visena nene, ana amarau na amarau, ana amloru e porotano, ap̃ariwani marala lala. ");
INSERT INTO lww_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ana Yesu pimi pulu, mlipalipa la telu nene, ana pisa pan la, pisape “Amiu asum̃alu, ve amarau re.” ");
INSERT INTO lww_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ana pogos nap̃a la ap̃ar plan si p̃arila pa metava, apisu re si lalua nene poli, ana la apisu ga Yesu naga taaga sike na. ");
INSERT INTO lww_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ana lala amolue e ravie nene, ap̃asup̃e la ke sina apitomi tano, ana Yesu pisaar m̃arera pan la, pisalup̃ar la, pisape “Suri nap̃a Ntewa kila amiu apisu ne, p̃isi na amiu ve avisawal re va yaru la nanagane, vano-o tol nap̃a Narina ne Yeririna mali sina ga e marena, e pogos nene narui amiu akilia avisawal va yeririna lala.” ");
INSERT INTO lww_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ana nalogena la telu nene apiun tan Yesu, apisape “?Sanapen nap̃a navianena na navisaluaena lala asum̃a ga apisa ke, apisape ‘Monar Elaisa naga wasup̃e ke sina ga imi sumo wa, siraunia na Navisaarena nene kilia imi m̃alivi’?” ");
INSERT INTO lww_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ana Yesu pisatam̃e la, pisape “Nap̃a la apisa sanene, naga lelaga kemua, komin Navisawalena Malakaea naga pisa sanene rui e kiena tusi. Elaisa naga monar imi sumo vena kila ruru make suri punu ga, p̃isi na Navisaarena naga kilia imi sirau, ");
INSERT INTO lww_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ana in na nevisa van amiu sanini, Elaisa nene pimi p̃isi rui, ana pe yaru lala apisu kilale re asape naga poli, ana pe asitom re naga poli. Ana e ke e p̃elaga nene, p̃isi na akila ke m̃ena ga viowa va Narina ne Yeririna.” ");
INSERT INTO lww_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ana e pogos ke nanene, nalogena la telu nene akilia ga na wa, nap̃a Elaisa nap̃a Yesu pisayu ke ne, nane Yoane Nakeena nene. ");
INSERT INTO lww_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ana Yesu amio la telu nene ap̃asup̃ela, ana apito asikolila amio p̃ina la nap̃a asike e pogos nene, ana yaru tai pimi kinai tano e lana ne Yesu, ana pisa pisape ");
INSERT INTO lww_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Sup̃e, inu sineun nesape ko sinem̃a ye kiau yaru m̃ee nini, oiila naga, komin nap̃a maiena tai teke e naga. Maiena nene kila naga marmarluia yam moki pap̃isi, ana kila kare manene la naga wa, sum̃a kila ke naga mlorvavae m̃a pano, mloru pa e kapi pona e m̃ena ga e wii lala. ");
INSERT INTO lww_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inu nepureli naga pimi puna ne kiom̃a nalogena lala, ana amiyum̃aen pano-o, peraga, ana akila ruru p̃ele naga.” ");
INSERT INTO lww_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ana Yesu pisi pa kiena nalogena lala, pisape “?Amiu la nene, sanape na sanene? Amiu na pe apiawa re nenaga e Ntewa poli, silaga amiu asum̃a ga apa ape wowe yo. ?Monar nesum̃a si nemio amiu vano tol pogwai? Inu sineu maren amiu pap̃isi rui. Ana poga ga, aure yaru m̃ee nene imi pun inu.” ");
INSERT INTO lww_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ana la ap̃ure yaru m̃ee nene pimi, ana Yesu pisaar pan yermare nap̃a sike e naga, pisape “!Omolue e naga nanagane ga ne!,” ana verakorena yaru m̃ee nene pimi po sina. ");
INSERT INTO lww_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ana siraun e pogos nene, pog nap̃a Yesu sum̃a naga taaga, nalogena lala apimi puna, apiun tania apisape “?Sanape na imimi mepilelua p̃ele yermare nap̃a sike e yaru m̃ee nene?” ");
INSERT INTO lww_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ana Yesu pisa pan la, pisape “Nanene na vanon nap̃a amiu pe apiawa ruru re m̃arera e inu poli wa. Lelaga nevisa van amiu, visae aviawa e inu ve tokak ga ve sa ga narin kurus nen mras nen purpa, ana visae kiamiu naviawaena ne ve lelaga kemua napo, ana p̃isi na amiu akilia avisa va tavie na m̃eke ne, avisave ‘Ko oure,’ ana p̃isi na naga monar ure. P̃isi na pe suri re tai nap̃a amiu akilia akila p̃ele poli. ");
INSERT INTO lww_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ana nap̃a nam̃eneplanen yermare la ne sanene, ana kana mrapa ne sanini: yaru na monar len, ana monar monsilu ga ve kinan re. E ga e p̃elaga nene, p̃isi na naga kilia m̃ene plan yermare kar la ne sanene.” ");
INSERT INTO lww_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ana pogos tai nap̃a Yesu amio kiena nalogena lala apimi lele taaga garu Kalele, Yesu pisa pan la, pisape “Lavisi ke nap̃a aligan Narina ne Yeririna va e limana yaru la narui, ");
INSERT INTO lww_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nap̃a p̃isi na awem̃ar naga mare, ana siraunia, e kana legiena na telu, p̃isi na Ntewa kila naga mali ke sina ga.” Ana pogos nap̃a Yesu pisa visena nene, kiena nalogena lala amloge piowa vanon pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pogos nap̃a Yesu amio kiena nalogena lala apimi atol Kapeneam, yaru lala na warpoloen takis na Yum̃a Wa M̃ana Ntewa, apimi puna ne Pita, apiunia apisape “?Sanape, kiom̃a navianena m̃ena ga pul m̃a takis ne, pona peraga?” ");
INSERT INTO lww_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ana Pita pisatam̃ea, pisape “Naga pul m̃aga.” Ana Pita p̃asup̃e si pa e yum̃a nap̃a Yesu sike ea, a naga pe pis re poli wa, ana Yesu naga pisp̃esia, piunia pisape “Saemon, ko ositomveveli p̃arin sup̃e na yomarava la nene. ?Li pe la ne apul ke takis nene pan la? ?Yaru na m̃ala mratava ga lala, pona yaru tap̃ena lala?” ");
INSERT INTO lww_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ana Pita pisa, pisape “Yaru tap̃ena ga lala, la monar aulia.” Ana Yesu pisa, pisape “Ee, sanene narui, ana kana kinasia sanini, mratava kiena ne p̃arin sup̃e lala, la tap̃atete aulia. Ana in ke nena nap̃a nepe mratava kiena ne Sup̃e Keviu na Yum̃a Wa nap̃a narui, ana vanon suri ne nanene, in na pe pon re neul takis nap̃a la apiun ke tan ko poli. ");
INSERT INTO lww_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ana popon italua na ve tekila kare re yaru lala na warpoloen takis, italua m̃ena ga monar toul ga. Ko, oto garo e lapa, oto om̃ate ika, a ika nap̃a om̃ate p̃esania, p̃isi na ko olual kilavaru tai e logona, nap̃a torokin italua toul kieta takis ea, ana olavia ola ova oulia.” ");
INSERT INTO lww_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ana e pogos ke nene, nalogena tap̃ena lala apimi am̃alivi, apimi nena puna Yesu, apiun tania, asape “Imimi sinemimin meviun mesape: ?Yaru ai nap̃a naga to laa metavan yaru tap̃ena lala e loyum̃a na nasup̃enena kiena ne Ntewa?” ");
INSERT INTO lww_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ana Yesu pio sisi tai nap̃a sum̃a ga pimi puna, ana mligan sisi nap̃ani sum̃alu su likan la, ");
INSERT INTO lww_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ana naga pisa pan la, pisape “In na nevisa van amiu, visae amiu ve avilopu amiu re nap̃a kiamiu p̃elaga la aimi ve sa p̃elaga kiena ne nisisi nene, p̃isi na amiu tap̃atete kemua aimi loyum̃a e nasup̃enena kiena ne Ntewa pogos tai. ");
INSERT INTO lww_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ana yaru nap̃a kila kiena sitomena su ga tano ve sa nisisi nini, yaru nene naga yoko kilia imi to laa metava, taulu yaru tap̃ena lala e nasup̃enena kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yaru nap̃a kiena sitomena pito tano e inu, ana naga kekaran nap̃a naga kila wo va nisisi kokan tai ne sanene, yaru nene naga sa ga nap̃a naga kekaran inu ke ga narui.” ");
INSERT INTO lww_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ana Yesu pisa m̃ena ga, pisape “Ana visae yaru tai kila nisisi tai ne sanene ligan inu, ve viawa re si m̃arera e inu, ana p̃isi na yaru nene kus nakoaena tai nap̃a m̃arera manene la. Visae am̃atear pupia kilavaru tai m̃ene kolmekina, ana akuwani naga talilu vitove e lowe memaena, nanene naga nakoaena tai ne meme ga ne, ana yaru nene naga yoko war va re la na wa taulu nanene. ");
INSERT INTO lww_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","!Aulai! Yomarava nini piowa manene la narui, nap̃a pulen manene la suri la nap̃a silaga asum̃a akilali ke yaru lala vena kila la akilalu kiela naviawaena e inu. Natap̃aliena la nene p̃isi na asum̃a likan amiu silaga, ana p̃isi na viowa manene la va yaru la nap̃a ap̃ar natap̃aliena viowa la nene pimi e yaru tap̃ena lala. ");
INSERT INTO lww_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","9","“Visae lumom̃a tai, pona lam̃a tai, pona kilamaram̃a tai, pona suri ya sina nap̃a e kiom̃a malena, visae suri la nene tai kila ko ve oviawa re si m̃arera e inu, popon otelua suri nene vetan ko, okuwan vano. Visae otelua p̃elaga na mlamulena viowa vetan kiom̃a malena ve sanene, p̃isi na ko okilia ova loyum̃a e malena, a visae ko ova loyum̃a e malena nap̃a lumom̃a, pona lam̃a, pona kilamaram̃a, pona suri ya sina e kiom̃a malena, visae suri la nene tai kovio p̃isi rui, ana nanene na poga ga nene. Ana piowa manene la nap̃a visae tasnem̃a la punu ga amio kiom̃a p̃elaga viowa lala asum̃a woga ga e ko, ana siraunia akoven ko e kapi nap̃a tap̃atete m̃ewo pogos tai e yo naloge viowaena.” ");
INSERT INTO lww_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ana Yesu pisa m̃ena ga, pisape “Amiu na monar avisuar ruruia vena amiu ve asitom korenan re naruu la tai nene pogos tai. Visae peraga, amaram̃e amiu, vanon nap̃a naruu la nene, la kiela navisi lala nae ma e peni nap̃a la asum̃a apisuar la m̃aga, a navisi la nene silaga asike e marana ne Ata nae ma e peni. ");
INSERT INTO lww_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ana yum̃aena kiena ne Narina ne Yeririna naga sanini: nap̃a naga pimin pisape tamalia la nap̃a akilalu mrapa. ");
INSERT INTO lww_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Amiu ayagogon ruru li suniena nini: Yaru tai nap̃a naga kiena sipsip lala tol ponotia taaga, ana lala tai kila p̃arina, pa la perina, ana kila pal mrapa, pa kovio. ?P̃isi na yaru nene kila sanape narui? Naga monar ligan kiena sipsip la lualima ovari pa ovari nene, asum̃a ga akinana ke e yo na vilum̃ini, ana naga monar vano vena kaleli sipsip nene nap̃a kilalu mrapa. ");
INSERT INTO lww_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Lelaga nevisa van amiu, pogos nap̃a naga m̃al si sipsip nene, ana naga kilia kekaran va p̃isi, taulu nap̃a naga kekaran kiena sipsip tap̃ena la moki nap̃a asu ruru asum̃a ga, pe amial re nap̃a apa akovio poli. ");
INSERT INTO lww_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","“Ana Arimamiu nae ma e peni, naga m̃ena ga sa ke ga, nap̃a naga yepen mavin narina tai nene yepe vetan mrapa vena vano va kovio.” ");
INSERT INTO lww_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ana Yesu pisa m̃ena ga, pisape “Visae womla tai naga kila viowa van ko pogos tai, monar ko ova ovisu naga nap̃a amiu ga lua nene asikena, ana ko monar ovisawal kiena naviowaena vania. Visae naga kekaran logeen kiom̃a visena, nanene naga sa nap̃a kiom̃a visena kila amiu luwoka ape mara wo si p̃isi narui. ");
INSERT INTO lww_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ana visae naga yepen mavin yagogonen kiom̃a visena, ana monar ko ovano oure si yaru tap̃ena la ve lua pona ve telu aimi amio ko, vena aiila ko e kiom̃a visena, sa nap̃a Tusi Wa pisa pisape ‘Visena la punu ga, monar yaru naiilaena visena, yaru ve lua pona ve telu, vena kila visena nene kilia sum̃alu.’ ");
INSERT INTO lww_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ana visae womla nene yepen mavin ke yagogon rurukoena wa, ana ko monar ovisawal kiena p̃arkawa nene va p̃egas nen li nalelagaena lala, vena la p̃asia akilia aimi avisuli re m̃ena ga naga. A visae naga m̃arera ke ga wa, ve yagogon re m̃ena ga nalelagaena lala, amiu monar avisu naga sa nap̃a naga pe wolawa ga tai, pona naga sa ga yaru na warpoloen takis, nap̃a yaru lala pe ape erau ruru re nenaga amio la poli.” ");
INSERT INTO lww_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ana Yesu pisa m̃ena ga, pisape “Lelaga, inu nevisa van amiu, ana suri ya nap̃a amiu avisalup̃aria e yomarava nini, ana Ntewa nae ma e peni naga m̃ena ga visalup̃aria amio amiu, a suri ya nap̃a amiu atam̃ania e yomarava nini, ana Ntewa nae ma e peni naga m̃ena ga tam̃ania amio amiu. ");
INSERT INTO lww_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“A naga sina, nevisa m̃ena ga van amiu, visae amiu yaru la ve lua nap̃a la lua aviranarlan suri tai e yomarava nini, ana visae lalua alenwoia, ana kau Ata nae ma e peni p̃isi na naga kila suri nene van lalua. ");
INSERT INTO lww_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Vanon nap̃a visae yaru ve lua pona ve telu aimi lele taaga e kiau kia, ana inu m̃ena nesike likan la.” ");
INSERT INTO lww_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ana Pita pimi puna Yesu, piun tania, pisape “?Sup̃e, visae kiau wolai kila ke pe mesmesu re pan inu silaga poli, inu monar neviewo naga yam ve via? ?Monar va tol yam ve olua pona sanape?” ");
INSERT INTO lww_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ana Yesu pisatam̃ea, pisape “Peraga, p̃isi na ko ve oviewo re ga naga yam ve olua ga, ko monar oviewo naga yam ve lualima yam ve olua, ko oviewo m̃a naga sanene vano tol sina ga kana yam ve olua 70 x 7. ");
INSERT INTO lww_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","P̃elaga naviewoena loyum̃a e nasup̃enen kiena ne Ntewa, monar ve sanene narui. Amiu ayagogo e suniena tai nap̃a pisayu p̃elaga naviewoena, nap̃a pisa sanini, pisape: P̃arin sup̃e tai, nap̃a naga sinenan sape visuveveli lapui la nap̃a kiena yaru na yum̃aena lala akila pania. ");
INSERT INTO lww_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ana naga kila m̃a sanene pano-o, ana ap̃ure kiena yaru nayum̃aena tai pimi puna, nap̃a yaru nene naga kila lapui na kilavaru na tenario via puna ne kiena yerkawa nene. ");
INSERT INTO lww_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pogos nap̃a apiun kilavaru tan yaru nene, naga pisape naga tap̃atete si ulmaran lapui nene. Ana yerkawa nene pisa pa kiena yeririna lala, pisape ‘Poga, akilalua naga a auliulinlua naga ve kiena ne yerkawa tap̃ena, vena yum̃ae korena ga vania. Ana auliulin m̃ena ga wona, amio narina lala, a amio make kiela suri lala, a awar kana kilavaru imi vena auli kiena lapui nene komp̃asia ea.’ ");
INSERT INTO lww_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ana yaru nene mloru e lana ne p̃arin sup̃e nene, tagi m̃arera pania, pisape ‘Ko ope yerkawa, awis, inu sineun nesape neviun tan ko vena ko ola re narin pogos tai van inu sumo wa, vena inu nekilali neul maranli lapui nene van ko.’ ");
INSERT INTO lww_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ana yerkawa nene sinena miye yaru nene, naga piewo make lapui nene pania, vena ve ul marana re sina, ana tam̃an yaru nap̃ani molue ga sa ga ne. ");
INSERT INTO lww_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ana pogos nap̃a yaru nene pano, naga pisu kiena erau tai, nap̃a kiena erau nene kiena lapui tai teke e yaru nene. Ana kiena lapui ne ve tokaki ga, ana yaru nene pano p̃uarar kolmekina, pisa pania, pisape ‘Ko monar oul lua kiom̃a lapui nene vetan inu nanagane ga ne.’ ");
INSERT INTO lww_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ana kiena erau nene pimi mloru e lana, tagi manene pania, pisape ‘M̃ara, ko ope kiau erau, awis, sineun nesape neviun tan ko vena ko ola re narin pogos tai van inu sumo wa, vena inu nekilali neul maranli lapui nene van ko.’ ");
INSERT INTO lww_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ana yaru nene yepena mavin viewoen kiena erau nene, p̃isi na naga pa kila la amligan naga pa e yum̃a nakoaena, vena sum̃a vano-o ul plan kiena lapui nene, p̃isi na naga kilia molue sina. ");
INSERT INTO lww_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ana pogos nap̃a yaru tap̃ena la nap̃a kiena ne p̃arin sup̃e nene apisu p̃elaga nene, amloge piowa pap̃isi, ana apa puna ne kiela p̃arin sup̃e, apisawal suri la nene pania. ");
INSERT INTO lww_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ana p̃arin sup̃e nene pio kiena yaru nene vena vim si puna, ana sinena karia, pis m̃arera pania, pisape ‘!Aa, ko na ope yaru p̃ilp̃il ya na sanene! Inu nepiewo ko e kiom̃a pupia lapui nene rui, vanon nap̃a otagin manene pan inu, ana okila sineu miye ko. ");
INSERT INTO lww_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","?Vanon ya ne ko tap̃atete m̃ena ga sinem̃a ye kiom̃a erau sa nap̃a inu sineu miye ko sumo rui?’ ");
INSERT INTO lww_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ana p̃arin sup̃e nene sinena mimi pa la narui, ana naga pisape monar aligan yaru nene va e yum̃a nakoaena, ana la monar ala m̃a nakoaena vania vano-o naga ul plan make kiena lapui nene.” ");
INSERT INTO lww_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ana Yesu pisa, pisape “Visae amiu ve aviewo re womlamiu lala silaga, ve lelaga e sinemiu la wetelu, p̃isi na kau Ata nae ma e peni, naga sinena kar amiu ve sanene, p̃isi na naga la nakoaena ve sa ke ga nene van amiu.” ");
INSERT INTO lww_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ana Yesu pisa visena la nene p̃isi, ana naga mligan Kalele naga kome wii nae Yortan lepas na vano, ana pa metava e lepas nae Yutea. ");
INSERT INTO lww_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ana p̃ina lala ataveve ke naga e pogos nene, ana e yo nene naga kila ruru namaiena la moki. ");
INSERT INTO lww_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ana Varasi m̃ena ga lap̃asia asike e pogos nene, ana apimi puna ne Yesu, apisape akilali ke sina ga naga, la apiun naviunena tai pania, la apiunia, apisape “?Kieta navisaluaena pisa ya ne e lepas nen p̃elaga kiena ne yaru nap̃a ligan lua wona? ?Mesmesu ga nap̃a yaru kilia kila sanene vanon suri kar punu ga nap̃a pe miasia, pona kilia kila vanon ga suri kerkeviu ga lap̃asia?” ");
INSERT INTO lww_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ana Yesu pisatam̃e la, pisape “?Pona amiu na pe akilia re Visena Wa kiena ne Ntewa nap̃a naga pisa, pisape ‘E purp̃esia, Ntewa naga sii suri punu ga, ana sii m̃ena ga yeririna lua, yerm̃ene tai, a sira tai?’ ");
INSERT INTO lww_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Suri nene amiu akilia p̃isi rui, amio m̃ena ga visena tap̃ena nene nap̃a pisa, pisape ‘Sanene, p̃isi na yaru ligan arimana amio anena, ana naga vano vilolar wona na sira, ana lalua aimi ave taaga ga narui.’ ");
INSERT INTO lww_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nanene kila sane lalua ve ave lua re sina, ana lalua apimi ape taaga ga narui. Ana ya nap̃a Ntewa naga vilolaria aimi ave taaga, pe pon re si yaru kilapure la poli.” ");
INSERT INTO lww_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ana Varasi la nene amloge visena la nene, ana apiun ke sina ga tan Yesu, asape “?Poga ga, ana vanon ya ne Mosis naga pisawal navisaluaena nene nap̃a tam̃an sape yaru naga kilia la m̃aki naliganluaena tai vena la va wona, vena ligan lua naga vano?” ");
INSERT INTO lww_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ana Yesu pisatam̃e la, pisape “Ee, ana sumon nap̃a nasiien yomarava nini, naga pe sa re nene poli, ana vanon nap̃a amiu p̃arimiu lala apimi m̃arera pap̃isi, nane kila Mosis tam̃ania sanene sape siar e repimiu la pimi, amiu akilia aligan plan womiu lala. ");
INSERT INTO lww_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ana nanagane, inu nevisa van amiu, visae yaru tai, wona kila kolau, yaru nene kilia ligan lua wona nene. Ana visae sira nene ve kila re kolau ve sanene sumo, ana yaru nene ligan lua naga, ana p̃isi na va were sira tap̃ena, visae ve sanene, ana Ntewa pisu sane yaru nene naga kila kolau narui amio sira tap̃ena nene, naga kila kare sira nene nap̃a wona na sumo.” ");
INSERT INTO lww_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ana nalogena kiena Yesu lala apisa pania, apisape “Visae ve sanene, p̃elaga na talopaena pe suri m̃arera tai ne pap̃isi ne. Pe pon re si tekila ita tetalopa poli.” ");
INSERT INTO lww_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","12","Ana Yesu pisa pan la, pisape “Ee, lelaga nap̃a yaru lap̃asia nap̃a p̃isi na la ve atalopa re pogos tai, sa nap̃a sane lap̃asia apaeme ana tasnela la piowa pa rui, pona lap̃asia akila kare tasnela, sa nap̃a asila, ana la tap̃atete atalopa. A lap̃asia, pe atalopa re poli vanon nap̃a la amligan talopaena vena la ayum̃ae e nasup̃enena kiena ne Ntewa. Ana Visena Wa, naga pisa pisape popon yerm̃ene amio sira, lalua atalopa, a popon lalua asu ruru m̃aga sanene tol luas nen kiela malena la luoka. A ko nap̃a ko okekaran visena nene, ana opisu nap̃a Ntewa naga kila sanene pan ko rui, popon olarar ruru visena nene m̃arera e kiom̃a malena.” ");
INSERT INTO lww_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ana lap̃asia akus narila lala apimi puna Yesu, vena naga ligan limana te la, len wo la. Ana nalogena lala apisuia, ana apisi m̃arera pan yaru la nene, apisalup̃ar la, ");
INSERT INTO lww_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ana Yesu pisa, pisape “Amiu ve avisalup̃ar re sisi la nene, amiu atam̃an la aimi pun inu, vanon nap̃a sisi la nene na asa ga la nap̃a asike loyum̃a e nasup̃enena kiena ne Ntewa.” ");
INSERT INTO lww_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ana naga mligan limana te sisi la nene, ana suraunia, naga mial pano. ");
INSERT INTO lww_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ana e pogos tap̃ena tai, yaru m̃ee tai pimi pisu Yesu, piun tania, pisape “?Navianena, ana in na monar nekila yum̃aena wo ya, nap̃a vena kila inu p̃isi na netol malena nap̃a ve uro re?” ");
INSERT INTO lww_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ana Yesu pisa pania, pisape “?Vanon ya ne ko opiun tan inu sanene, osape nevisa yum̃aena wo tai van ko? Ntewa ga naga po, a visae ko ologear kiena navisaluaena lala, p̃isi na ko okilia otol malena wo nene.” ");
INSERT INTO lww_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ana yaru nap̃ani piun ke sina ga tan Yesu, pisape “?Ana ko opisa ke navisaluaena ya la nene?” Ana Yesu pisa pania, pisape “Navisaluaena ne la nanini narui, nap̃a pisa pisape: ve owem̃ar re yaru mare, ve okila re kolau, ve ovinau re, ");
INSERT INTO lww_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ve ovisokan re, ko ova tanon arimom̃a amio anom̃a, a ko ositom nalavis pum̃a lala, ovisuar ruru la, ve sa ke nap̃a ko opisuar ruru ko ke ga.” ");
INSERT INTO lww_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ana yaru m̃ee nene pisa pania, pisape “Navisaluaena la nap̃a ko opisa ke nene, inu nesum̃a nemlarar make punu ga rui. ?Suri ya si nap̃a teke ga wa, nap̃a inu pe nekila re poli wa?” ");
INSERT INTO lww_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ana Yesu pisa pania, pisape “Visae ko sinom̃an osape oimi omesmesu ruru wo va p̃isi, torokin nap̃a ko otol malena nap̃a ve uro re, p̃isi na ko na monar okila ve sanini: ko ovano, oululin plan make kiom̃a suri la punu ga, ana owar kana kilavaru nena, ova oviovionia van yaru la nap̃a pe kiela suri re poli. Visae ko okila sanene, p̃isi na ko kiom̃a suri wo lala ve moki vap̃isi ma e peni. Ko, ova okila, siraunia oimi otaveve inu.” ");
INSERT INTO lww_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ana pogos nap̃a yaru m̃ee nene mloge visena nene, kiena sitomena urmi a sinena piowa pap̃isi, vanon nap̃a naga kiena suri la moki manene la. Ana naga pure matan Yesu. ");
INSERT INTO lww_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ana Yesu pisa pa kiena nalogena lala, pisape “Lelaga nevisa van amiu, visae yaru tai nap̃a kiena suri moki, naga sinenan pisape va loyum̃a e nasup̃enena kiena ne Ntewa, suri nene na m̃arera towe m̃a nap̃a. ");
INSERT INTO lww_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ee, inu nevisa van amiu, visae kamel tai naga va warpoyo e pulus nen nitil nene, nane naga m̃arera vap̃isi ne, ana visae yaru tai nap̃a naga kiena suri la moki ana sinenan sape va loyum̃a e nasup̃enena kiena ne Ntewa, naga m̃arera la na wa.” ");
INSERT INTO lww_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pogos nap̃a nalogena lala amloge visena nene, amilania pap̃isi, ana la apisape “?Suwala, ana visae ve sanene, p̃isi na ane kilia tol namalena nene?” ");
INSERT INTO lww_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ana Yesu kirava pisu la, naga pisa pisape “Ee, lelaga nap̃a yaru tap̃atete kilia kila yaru tol malena nene, ana Ntewa ga kilia kila make suri punu ga.” ");
INSERT INTO lww_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ana Pita pisatam̃ea, pisa pisape “?Ana sanapen imimi? Imimi meligan make kiamimi suri la rui, ana imimi metaveve ko. ?P̃isi na imimi metol m̃a suri wo lap̃as ne, pona peraga?” ");
INSERT INTO lww_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ana Yesu pisa pan la, pisape “Lelaga nevisa van amiu sanini, pogos nap̃a Narina ne Yeririna totano e kiena lelena wa natotanoena e yomarava viu nene nap̃a p̃isi na imi, amiu nap̃a ataveve inu ke nanagane, ana amiu m̃ena ga atotano e pupia lelemiu wa natotanoena ve lualima taaga va lua, vena avisuar lus nae Israel lala lualima taaga pa lua nene, sa nap̃a amiu ape kiela p̃arin sup̃e lala. ");
INSERT INTO lww_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ana yaru nap̃a visae ligan m̃ana yum̃a, pona wenla pona vinena, pona arimana pona anena, pona narina, pona kiena porotano, ana visae naga ligan suri la nene vanon ga inu, p̃isi na naga warmarana sina ga e yomarava nini kiena suri la nap̃a naga mligania, kilia tol sina ve ponotia tai, ana metavania, p̃isi na naga kilia tol m̃ena ga malena nap̃a ve uro re. ");
INSERT INTO lww_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“Ana yaru la moki liu nap̃a asu metava, p̃isi na ato tano, a yaru la nap̃a ato tano, p̃isi na la asu metava.” ");
INSERT INTO lww_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ana Yesu sum̃a pisa m̃aga pano-o, pisape “Suri nap̃a nepisa ga na wa, sa ke p̃elaga nap̃a Ntewa kila ke pa yaru lala loyum̃a e nasup̃enena kiena. A p̃isi na nevisayu suri nene van amiu e p̃akaiwa tai, nap̃a pisa sanene, pisape: Yerkawa tai, nap̃a kana pupia lokilm̃asm̃as tai. E kolulagi tai, nap̃a pe yemlagi ruru re poli wa, naga pa e pulkumali tai vena were yaru lap̃asia ava ayum̃ae e kiena lokilm̃asm̃as nene e legiena nene. ");
INSERT INTO lww_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Naga m̃al la p̃asia, ana pisaar pan la e kilavaru tai nap̃a torokin yum̃aena na legiena wetelu tai, ana mligan plan la apano vena ava ayum̃ae e kiena lokilm̃asm̃as nene. ");
INSERT INTO lww_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ana e mrae ovari, naga pa sina ga e pulkumali nene, pisu yaru tap̃ena lala asu korena ga, asum̃a sane pe kiela yum̃aena re poli, ");
INSERT INTO lww_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ana naga pisa pan la, pisape ‘Popon amiu m̃ena ga aimi ayum̃ae re e kiau lokilm̃asm̃as, ana p̃isi na nowul amiu ke ga.’ ");
INSERT INTO lww_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Ana la nene apa amiyum̃ae, a siraunia, kolpae m̃ena ga, a mrae telu m̃ena ga nap̃a yepekilavi, ana yerkawa nene p̃asup̃e si pano, p̃ere ke sina ga yaru lap̃as apimi amiyum̃ae kiena sanene. ");
INSERT INTO lww_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A yam si tai, e yepekilavi mrae lima, naga p̃asup̃e sina ga pa e pulkumali nene, pisu yaru lap̃asia nap̃a asum̃alu asike e yo nene na wa, ana naga pisa pan la, pisape ‘?Komin ya ne asu koren ke sanene na wa e yo nini, nap̃a pe akila re nena yum̃aena tai poli?’ ");
INSERT INTO lww_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ana la apisatam̃ea, apisape ‘Peraga, pe yaru tai pimin re sape meva meyum̃ae kiena poli.’ “Ana yerkawa nene pisa pan la, pisape ‘Poga, visae sanene, in na neure amiu narui. Amiu, aimi ayum̃ae kiau.’ ");
INSERT INTO lww_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ana e ko yepekilavi la rui, amiyum̃ae p̃isi, ana yerkawa nene pisa pa kiena navisuaren yum̃aena nene, pisape ‘Poga, ovio yaru na yum̃aena la nene aimi, oul la. P̃isi na ko okila sanini: oul p̃esan la nap̃a apimi mare ga na wa, vano-o op̃isi e la nap̃a apimp̃esani kolulagi.’ ");
INSERT INTO lww_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ana pogos nap̃a yaru la nap̃a asiar ga yum̃aena e mrae lima apimi, yaru nene mla kilavaru pan la torokin ke legiena wetelu na yum̃aena taaga. ");
INSERT INTO lww_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","A pogos nap̃a la nap̃a apami amiyum̃ae sumo apimin vena awar kiela kilavaru, la amape pona la ala va la metava, taulu la nap̃a amiyum̃ae plas ga, ana yaru nene mla kilavaru pan la, la punu ga torok ga. ");
INSERT INTO lww_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","“Ana pogos nap̃a la apisu kiela kilavaru sa ke ga nene, la amloge piowa, asum̃a apisimumun yerkawa nene. ");
INSERT INTO lww_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ana amligan lala tai pa piun tania, pisa pisape ‘La nap̃a apimi mare ga na wa, la amiyum̃ae aora taaga ga, ana imimi memiyum̃aen legiena wetelu e pupia yepisusun nene. Imimi mepisu nap̃a ko omla kilavaru maran taaga pan la, sa ke nap̃a omla pan imimi. ?Suri nene na sanape na sanene?’ ");
INSERT INTO lww_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ana yerkawa nene pisatam̃e naga, pisape ‘M̃ara, in na pe nekila kare ko re nene poli. Italua tepranar p̃isi rui, tesape ko oyum̃ae e legiena wetelu ve taaga nene, ana tesape p̃isi na nowul ko torokin ga kiom̃a yum̃aena nene. ");
INSERT INTO lww_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ve sanene, popon ko ola kiom̃a kilavaru ova ga um̃a. Naga kiau sitomena ga tai nene, nap̃a kilavaru nap̃a nemla pan ko, sineun nesape nela m̃ena ga marana ve taaga va la nap̃a apimi mare ga. ");
INSERT INTO lww_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","?Ko ositom osape in na tap̃atete nekila sa nap̃a inu sineunia, e kiau kilavaru? ?Sanape na ko opielue e yaru la nap̃a nekila ke po pan la? Ana p̃akaiwa nini p̃isi e nene.’” ");
INSERT INTO lww_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ana Yesu pisa make kiena visena e pogos nene, pisa pisape “Ana yaru la nap̃a asirau, p̃isi na la asumo, a la nap̃a asumo, p̃isi na la asirau.” ");
INSERT INTO lww_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ana Yesu pa ke metava ma Yerusalem narui, ana pogos nap̃a amial ke e mraplepa apavini, naga pio kiena nalogena la lualima taaga pa lua apimi puna, ana pisi pan la, pisape ");
INSERT INTO lww_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Amiu ayagogo ruruia. Nanagane ita tepa ke ma Yerusalem narui, nap̃a p̃isi na ve ve piavi re, p̃isi na aligan Narina ne Yeririna e limana ne yerkawa lala kiena ne yaru wa lala, a amio navianena kiena ne navisaluaena m̃ena lala, ana p̃isi na la nene la alip̃ere naga avisave p̃isi na naga monar mare. ");
INSERT INTO lww_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ana siraunia aligan naga e limana ne le Rom lala, nap̃a p̃isi na la nene akirakirai viowa vania, a p̃isi na la akoa naga, ana p̃isi na asuaria naga e laki torovia vena mare. Ana pogos nap̃a naga mare pae, ana e kana legiena na telu, p̃isi na Ntewa kilamalia sina naga.” ");
INSERT INTO lww_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ana wona ne Sepeti, naga p̃ere narila luwoka nene nap̃a Semes amio Yoane, apimi puna ne Yesu. Sira nene kinai e lana Yesu, piunia pisape “Inu sineunia nesape otam̃an suri tai van inu.” ");
INSERT INTO lww_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ana Yesu pisatam̃e naga, pisape “?Ana ko sinom̃an osape oviun ya?” Sira nene pisatam̃ea, pisape “Inu sineunia nesape otam̃an sanini: pogos nap̃a ko ovisirlua kiom̃a nasup̃enena, p̃isi na naruu la luwoka nene akilia atotano amio ko e kiom̃a yo wa nap̃a metava lavisin ko, tai e lepas nen lumom̃a na p̃amarua, a tai e lepas nen lumom̃a na p̃am̃eli.” ");
INSERT INTO lww_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ana Yesu pisatam̃e la, pisape “Amiu pe akilia re suri nap̃a apiun ke ne poli. ?Sanape, amiu lua nene asitom asape amiu lua atorokin nap̃a ita tomunpae e piala naloge viowaena nene nap̃a inu monar nomun ea?” Lalua apisa pania, apisape “Ee, imimi lua metoroki.” ");
INSERT INTO lww_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ana Yesu pisa pan la luoka, pisape “Ee, lelaga nap̃a p̃isi na amiu luwoka amun m̃ena ga e m̃au piala naloge viowaena nene, ana suri nene nap̃a amiu lua apiunia, apisape amiu lua atotano amio inu e lepasneu luwoka, suri nene naga pe kiau re nap̃a nela van amiu poli. Yo la ne sanene, kiena ne la ga nap̃a kau Ata naga kila ruru pe kiela, a nap̃a naga pisaar p̃isi rui pisape p̃isi na la atotano ea.” ");
INSERT INTO lww_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pogos nap̃a nalogena tap̃ena la lualima nene la amloge suri nene, nap̃a wolai lalua nene Semes amio Yoane apiunia, ana la sinela kari lalua. ");
INSERT INTO lww_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ana Yesu pio la, vena aimi puna, vena naga visi van la, ana naga pisa pisape “Ita tekilia rui p̃elaga kiena ne yaru la nap̃a pe amlelaga re e Ntewa poli. Ita tepisu m̃a nap̃a sup̃e lala amio yerkawa lala na yomarava nini, la sinelan asape am̃areran yaru tap̃ena lala vena asu vatanon la silaga. ");
INSERT INTO lww_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Ana amiu kiau nalogena lala, kiamiu p̃elaga monar ve ve sa re nene. Visae amiu yaru tai sinenan sape imi ve kiamiu yerkawa tai pona kiamiu nasumonena tai, kana mrapa nena sanini: yaru nene monar imi ve sa ga yaru na yum̃ae kiamiuena tai. ");
INSERT INTO lww_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Narina ne Yeririna naga kila sanene p̃isi rui, nap̃a naga pe pimin re nap̃a vena yaru la akila yum̃aena naiilaen naga poli, ana naga pimin vena naga yum̃ae vena iilaen lala, a vena tam̃an kiena malena vena ul plan yaru la ve moki.” ");
INSERT INTO lww_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","E pogos nene, Yesu amio kiena nalogena lala asike garu Seriko, ana pogos nap̃a amligan e pulkumali nene apano, ana yeririna la moki pap̃isi nap̃a ataveve la. ");
INSERT INTO lww_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ana kilamara kata la lua, nap̃a lalua atom̃a tano e isinen mraplepa. Ana pogos nap̃a lalua amloge nap̃a apisape Yesu mial ke e mraplepa pimi, lalua apio ke asape “!Sup̃e-o, ko lus kiena ne Tepet, imimi lua mesape ko sinem̃a ye imimi!” ");
INSERT INTO lww_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ana yaru tap̃ena lala apisin sinemimien pan lalua nene, apisa apisape “Ee, amiu lua nene am̃aaga.” Ana lalua apio manene la, asape “!Sup̃e-o, ko lus kiena ne Tepet, imimi lua mesape ko sinem̃a ye imimi.” ");
INSERT INTO lww_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ana Yesu sum̃alu su mrapa e yo nene, pio lalua, pisa pisape “?Amiu lua sinemiun asape nekila ya ne van amiu?” ");
INSERT INTO lww_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ana lalua apisatam̃ea, asape “Sup̃e, awis, imimi lua sinemimin mesape kilamaramimi la imi wo, vena mekilia mekirava.” ");
INSERT INTO lww_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ana Yesu sinen mie la, ana tol kilamarala, ana lalua apisu ruru ke ga suri e pogos nene, a lalua asum̃alu ataveve Yesu apano. ");
INSERT INTO lww_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nanagane, Yesu lala apami lavisin Yerusalem narui, ana la am̃alivi e narin pulkumali tai sumo, kiena kia Petpas, nap̃a teke e kunus nene nap̃a la apio asape Kunus Na Purolip. Ana Yesu miila kiena nalogena la lua, pisape ");
INSERT INTO lww_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Amiu lua ava e pulkumali na gare, a mesmesu e pogos nap̃a ava loyum̃a ea, p̃isi na amiu lua avisu togki tai, nap̃a am̃atear sike na, naga amio narina. Ana amiu lua alup̃ar plan la, a amiu aure ga la luoka aimi pun inu e nini. ");
INSERT INTO lww_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ana visae amiu lua aloge yaru tai visi van amiu, p̃isi na amiu lua avisa ga vania, avisave ‘Sup̃e na sinenan suri mali lalua nini vena ava akila kiena yum̃aena tai wa,’ ana pogos nap̃a amiu lua avisa sanene, naga kilia tam̃an lalua aimi veraga.” ");
INSERT INTO lww_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Suri nene pimi p̃arpoyo vena kila visena nene kiena ne navisawalena nanua sumo vim ve lelaga, nap̃a naga pisa pisape ");
INSERT INTO lww_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Amiu avion va le Saeon lala, avisave ‘Amiu apisu ke ne, nanagane kiamiu p̃arin sup̃e pam ke pun amiu narui. Naga pe yaru tai nap̃a kiena sitomena to ga tano, kila naga kus ga togki, togki tai nap̃a ve tokaki ga, nap̃a pe ninus ke ga wa.’” ");
INSERT INTO lww_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ana nalogena lalua nene apano, ana lalua akila sa nap̃a Yesu pisa. ");
INSERT INTO lww_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ana pogos nap̃a lalua ap̃ere togki nene amio narina apimi, ana lala ap̃atetae m̃ala kulkota lala e wos nen togki lalua nene, ana Yesu naga pa totano meta e navetokak. ");
INSERT INTO lww_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ana yaru la mokliu nap̃a ap̃atetae m̃ala kulkota lala suvileviles nen mraplepa, ana yaru lap̃asia apa ate m̃am̃ela lala pitomi ap̃atetae m̃ena ga, vena togki kiena ne Yesu yali ea. Ve sanene, akila sa nap̃a la apatanon Yesu sa nap̃a naga pe pupia p̃arin sup̃e tai. ");
INSERT INTO lww_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ana la amial ke apano vena ava loyum̃a Yerusalem, ana p̃ina na yeririna la nap̃a asumon Yesu, amio la nap̃a asiraunia, asum̃a apiovionia sanini, apisa apisape “!A ke suwala, po na po! !Teyeluar naga nap̃a pe lus kiena ne Tepet tai nene! !Ntewa na mava, ko ovisa ruru naga nene nap̃a pimi e kiom̃a kia! !Amiu nae ma e peni metava amiu m̃ena ga ayeluar naga!” ");
INSERT INTO lww_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ana pogos nap̃a Yesu pa loyum̃a e Yerusalem, yaru lala sinela pulaula, ana la asum̃a akila ke visena la moki, asum̃a apiuviunia, asape “?Yaru nene naga ai?” ");
INSERT INTO lww_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ana yeririna la nap̃a apimi amio Yesu, la apisatam̃ela sanini, apisa apisape “Nanene na navisawalena nene nap̃a naga molue e pulkumali nae Nasaret garu Kalele, nap̃a kiena kia Yesu.” ");
INSERT INTO lww_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ana Yesu pa e Yum̃a Wa m̃ana ne Ntewa, a e pogos nene naga pisu sane yaru la moki liu nap̃a la asum̃a e kopkop na yum̃a nene. La nene la asum̃a akila ke ga yum̃aena lala natauluen kilavaru, naga nene e lepas nalaena lala a e kup̃ap̃aena na Yum̃a Wa nene, ana la asum̃a akila kewia ke ga yaru lala. Ana pogos nap̃a Yesu pisu suri nene, naga pe kekaran re poli. Ana naga pa m̃ene plan la, naga kawepu narin varvara kiena ne yaru na keueen kururu varu lala, a naga koantetain lele na totanoena kiena la nap̃a apuliwilin ke kupa lala. ");
INSERT INTO lww_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ana naga pisa pan la, pisape “Ntewa pisa e kiena Visena Wa, pisape ‘P̃isi na la avisa m̃au Yum̃a Wa avisave naga yum̃a na leniena,’ ana amiu apilon p̃isi pimi sa ga puluve m̃ana yaru na vinauena la narui.” ");
INSERT INTO lww_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ana pogos nap̃a Yesu sike e Yum̃a Wa nene na wa, kilamara kata lala amio laulu lala apimi puna, ana naga kila ruru la sina. ");
INSERT INTO lww_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ana yerkawa lala kiena ne yaru wa lala, amio navianena na navisaluaena lala, apisu yum̃aena wo kiena ne Yesu la nene, a amloge m̃ena ga nap̃a sisi lala asum̃a ga apiovion ke ga wa, asape “!A ke suwala, pona po! Teieluar naga nap̃a naga pe lus kiena ne Tepet nene!” ana yerkawa la nene sinela mimi manene la. ");
INSERT INTO lww_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","La sinela mimi sanene, ana la apisa pa Yesu, apisape “?E sanape, ko omloge m̃a visena nap̃a la asum̃a apisa ke ne?” Ana Yesu pisatam̃e la, pisape “Ee, nemloge m̃a ne. ?Ana sanape, amiu asitom ke asape visena nene piowa ga? Pona pe apuloli re Visena Wa kiena ne Sup̃e nap̃a pisa, pisape ‘Ntewa o, ko okilia okila nin sisi kokan lala, amio m̃ena sisi tomtom lala, amieluar ruru ko pap̃isi.’” ");
INSERT INTO lww_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ana Yesu mligan la nene, molue ke sina ga petan Yerusalem, pa e narin pulkumali nap̃a Petani, pa mono ea. ");
INSERT INTO lww_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ana Yesu mon m̃a e nene, ana yemlagi kolulagi naga pisape wasup̃e sina va Yerusalem, a naga sum̃a mial m̃a pavini, ana naga mloge sane viso karia. ");
INSERT INTO lww_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Naga kira pa e isinen mraplepa, naga m̃al purpiliva tai, nap̃a naga m̃as ga moki, ana pe mras su re e poli. Ana Yesu pisa pa purlaki nene, pisape “Ko ove owar re si mrasnom̃a pogos tai.” Naga pisi sanene, ana veraga ga purpiliva nene mano tap̃a nenaga. ");
INSERT INTO lww_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nalogena lala apisu nap̃a purlaki nene pimi mano sanene, ana sinela kurkur pap̃isi. La apiun tai Yesu, apisape “?Ya ne kila purpiliva nene mano ke veraga sanene?” ");
INSERT INTO lww_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ana Yesu pisatam̃e la, pisape “Lelaga nevisa van amiu, visae amiu aviawa m̃arera e inu, nap̃a amiu kiamiu sitomena ve veve lua re, p̃isi na amiu m̃ena ga akilia akila sanene, a p̃isi na amiu akilia akila m̃ena ga va re laa na wa taulu nene. Sane visae amiu avisa va pupia kunus nene, avisave ‘Osum̃alu otove oula ova e sive,’ p̃isi na ve sanene narui. ");
INSERT INTO lww_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","A visae amiu aviawa kawa e Ntewa, nap̃a amiu alelaga kemua lelaga, p̃isi na amiu akilia atol suri ya nap̃a amiu amlen vanonia, amiu aviun tan naga.” ");
INSERT INTO lww_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ana Yesu p̃asup̃e si pa loyum̃a e Yum̃a Wa M̃ana ne Ntewa, ana naga pa sum̃a pian ke sina ga yaru lala. Ana yerkawa kiena ne yaru wa lala, amio nasumonena lala kiena ne le Yu lala, apimi puna, apiun tania, apisape “?Ko osum̃a okila ke suri la ne sanene e yo nini e kia kiena ai, a a m̃ena ga nap̃a tam̃an ko sape okila ve sanene?” ");
INSERT INTO lww_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ana Yesu pisatam̃e la, pisape “Poga ga, ana inu m̃ena ga nesape neviun naviunena tai van amiu wa. Visae amiu avisatam̃e ruru kiau naviunena nene, p̃isi na nekilia nevisawal van amiu sanape nap̃a nekilia nekila ve sanene. ");
INSERT INTO lww_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Poga ga, kiau naviunena sanini narui, sape: ?Nakeena nap̃a Yoane naga kila mare ga nanua e yaru lala, naga suri tai nap̃a Ntewa naga pisa pania pisape naga monar kila, pona yaru ga la apisa pania?” Ana naviunena nene kiena ne Yesu kila na la apisi ga pan la narui, nap̃a la asum̃a apisa apisape “?P̃isi na ita tevisa sanape na vania? !Tevisuaruruia! Visae ita tevisa tevisave nakeena nene Ntewa naga pisa pa Yoane, p̃isi na yaru nene viun si tan ita, visave vanon ya ne ita pe temlelaga re e Yoane poli. ");
INSERT INTO lww_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ana siraunia ita tap̃atete si tevisa tevisave nakeena nene, yaru ga la apisa pa Yoane, vanon nap̃a yeririna la nene la amlelaga ke m̃arera p̃isi rui, asape Yoane nene naga pe navisawalena na lelaga tai kiena ne Ntewa, ana pe pon re yeririna la nene sinela kar ita poli.” ");
INSERT INTO lww_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ana kiela sitomena la ne sanene narui kila la apisatam̃e Yesu sanini, apisa ga apisape “Imimi memninue ga.” Ana Yesu pisa pan la, pisape “Visae sanene, p̃isi na inu m̃ena ga, tap̃atete nevisa van amiu nevisave ane pisa pan inu pisape nekila yum̃aena la ne sanene.” ");
INSERT INTO lww_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ana Yesu pisa pan la, pisape “Amiu asitomli suniena nini. Yaru tai, narina na yerm̃ene lua, ana yaru nene pa pisu narina nap̃a m̃earu, pisa pania, pisape ‘Naruu, sineun nesape p̃ane na ko ova oyum̃ae e kata lokilm̃asm̃as.’ ");
INSERT INTO lww_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ana narina nene pisatam̃ea, pisape ‘Peraga, yepemavi.’ Ana pe piavi re poli, yaru viu nene sitom si arimana, ana naga pilon kiena sitomena, ana pa miyum̃ae sa nap̃a arimana pisa pania. ");
INSERT INTO lww_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ana arimana ne lalua nene naga sitom ke sape p̃isi na narina nene tap̃atete va yo, ana pisa si visena nene pan narina nasirau, ana narina nene pisatam̃e ruruia, pisape ‘Poga ga ata, p̃isi na neva ke nanagane ga ne,’ ana siraunia, ana naga pe pa re si poli.” ");
INSERT INTO lww_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ana Yesu piun tan la, pisape “?Lalua nene, ane kila sa nap̃a arimala sinenania?” Ana lala apisatam̃ea, apisape “M̃earu.” Ana Yesu pisa pan la, pisape “Ee, ana lelaga nevisa van amiu, nanagane na sanene narui. Inu nesum̃a nepisu nap̃a yaru viowa la moki sane yaru na warpoloen takis lala, amio sira na mraplepa lala, la ke nap̃a ape yeririna viowa la nene, ana nanagane la asum̃a akekaran ke nap̃a vena aimi loyum̃a e nasup̃enena kiena ne Ntewa, la asum̃a apilon la ke rui. Ana nepisu sane amiu asike la varaun la, asike la perina pap̃isi wa. ");
INSERT INTO lww_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ana pogos nap̃a Yoane Nakeena naga pimi, naga pian amiu e p̃elaga na mrapa nap̃a mesmesu, ana yeririna viowa la nene amlelaga e naga. A amiu m̃ena ga, amiu apisu suri la nene, ana amiu na pe apilon amiu re lelaga poli, a pe amlelaga re nenaga.” ");
INSERT INTO lww_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ana Yesu pisi ke pan la na wa, pisa pisape “Amiu ayagogon ruru si p̃akaiwa tap̃ena nini, nap̃a pisayu yerkawa tai, amio kiena lokilm̃asm̃as tai. Yaru nene kila ruru kiena yo nene nap̃a kila kove m̃arera tai telivi piora ea, a kila kana lelena navieplanen was nen m̃asm̃as, a kila m̃ena kana lele tai nap̃a pa metava nap̃a yaru kilia wiyu va se ea, vena visuar lokilm̃asm̃as nene. “Ana e pogos tai, yerkawa nene sinenan sape yalor re va e purvanua tap̃ena tai, ana naga mligan kana lokilm̃asm̃as nene e limana ne yaru la p̃asia ayum̃aenia, ana aul vania. ");
INSERT INTO lww_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ana yerkawa nene pa sum̃a perina pano-o, ana naga pisu kilale pisape nanagane pogos na mram̃asm̃as marua narui. Ana naga mligan kiena yaru la ava si puna ne la nap̃a asike e kana lokilm̃asm̃as nene vena awar kiena kilavaru na mras nen m̃asm̃as komp̃asia, nap̃a la nene monar aul vania. ");
INSERT INTO lww_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ana poglis nap̃a kiena yaru la nene apimi, ana yaru tap̃ena la nene am̃e la, nap̃a tai la am̃e ga naga, a tai asum̃ar naga mare, a tap̃ena sina akovem̃ar naga mare. ");
INSERT INTO lww_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Ana yerkawa nene mligan si kiena yaru tap̃ena lap̃asia, ana la moki la sane, ana la nap̃ani akila si p̃elaga maran taaga sa ke ga pan la. ");
INSERT INTO lww_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ana yerkawa nene sitomyu p̃elaga kiena la nene, ana naga pisape ‘Inu monar neligan ga naruu vano, p̃isi na monar avatanon naga,’ ana naga mligan narina wawa napo nene pano. ");
INSERT INTO lww_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ana pogos nap̃a apisu naga, asum̃a apisavisa pan la, apisape ‘Naga nene na narina ne yerkawa ke narui. Yaru ke nanene narui, nap̃a visae yerkawa nene kovio, p̃isi na naga ke narui naga kus porotano nene sane lalimana ne arimana. Popon ita towem̃ar m̃ena ga naga mare, ana p̃isi na ita ga tekilia tokus porotano nene ve kieta.’ ");
INSERT INTO lww_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ana sanene narui atarar naga, ap̃ure lua naga petan lokilm̃asm̃as pa vanua, ana am̃em̃ar naga mare.” ");
INSERT INTO lww_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ana Yesu piunia, pisape “?Pogos nap̃a yerkawa nene imi sina, p̃isi na naga kila sanapen la nap̃a asum̃a apisuar ke kiena lokilm̃asm̃as nene?” ");
INSERT INTO lww_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lala apisatam̃ea, apisape “Yaru viowa la nene, p̃isi na yerkawa nene wem̃ar la, monar amare e p̃elaga tai nap̃a m̃arera viowa vap̃isi. Siraunia, naga ligan kiena lokilm̃asm̃as e limana ne yaru wo tap̃ena lala, nap̃a p̃isi na akilia auli mesmesun vania e kana pog nena.” ");
INSERT INTO lww_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ana Yesu pisa pan la, pisape “Visena tai teke e Visena Wa kiena ne Ntewa, pisape ‘Kilavaru nene, yaru na yum̃aenen yum̃a lala, apisa apisape piowa ga, akoven rui. Ana nanagane, kilavaru nene pimi pe kilavaru wo na mrapun yum̃a, nap̃a uarar yum̃a m̃arera. Suri nene, naga Ntewa ga kila, a imimi mepisuia na po pap̃isi.’ “?Visena nene na amiu apuloli m̃a pogos tai rui, pona peraga yo? ");
INSERT INTO lww_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Inu nevisa van amiu, p̃isi na Ntewa lalua kiena nasup̃enena vetan amiu, ana p̃isi na la va yaru tap̃ena lala nap̃a kiela malena lala kilia war mras wo lala, torokin nap̃a asike loyum̃a ea. ");
INSERT INTO lww_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Ana visae yaru tai loru e kilavaru nene, p̃isi na si kare naga vap̃isi, tasnena wororowa make ga, pona visae kilavaru nene loru e yaru tai, p̃isi na kilamumu yaru nene kila kare naga vap̃isi.” ");
INSERT INTO lww_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ana pogos nap̃a yerkawa kiena ne yaru wa lala amio Varasi lala amloge p̃akaiwa kiena ne Yesu la nene, akilia nap̃a naga sum̃a pisayu la ke sanene. ");
INSERT INTO lww_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kila narui lala sinela kar naga, sinelan asape auarar naga, ana akila p̃ele ga komin amaraun manene laa p̃ina na yeririna la, nap̃a amlelaga asape Yesu naga navisawalena kiena ne Ntewa tai. ");
INSERT INTO lww_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ana Yesu pis sina ga pan la e p̃akaiwa, pisa pisape ");
INSERT INTO lww_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“P̃elaga kiena ne Ntewa nap̃a pio yaru lala apimi loyum̃a e kiena nasup̃enena sanini: P̃arin sup̃e tai kila ruru pupia kinanena tai e p̃ap̃agena na talopaena kiena ne narina. ");
INSERT INTO lww_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Naga piun tan yaru la moki rui nap̃a yoko aimi e p̃ap̃agena na talopaena nene, ana pogos nap̃a mligan kiena yaru na yum̃aena lala vena ava aure la nene aimi, ana la nene yepel mavin si imiena. ");
INSERT INTO lww_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ana p̃arin sup̃e nene pisa pan kiena yaru na yum̃aena tap̃ena lala, pisape ‘Amiu towe awasup̃e amiu ke sina ga avano, vena avisa kiau visena nene van la, avisavenua ita tom̃e puluk la rui, amio m̃ena ga suri mali tap̃ena lala nap̃a amlapa ruru po, ana suri punu ga lala e kinanena nene tekila ruru la pa rui. Avisa van la avisave monar aimi lele taaga amio ita e p̃ap̃agena nini.’ ");
INSERT INTO lww_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ana la apa apisa pan la sanene, ana la nene asitom korenan ga visena kiena ne p̃arin sup̃e nene, lala sinelan asape asum̃a akila ga suri nap̃a la sinelania. Tai pa kana lokove, a tai sum̃a ga pisuar m̃a kiena yum̃a na wilwilinen suria, ");
INSERT INTO lww_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","a lap̃asia apuarar yaru na yum̃aena kiena ne p̃arin sup̃e la nene, akila piowa pan la, ana am̃emom̃ar la. ");
INSERT INTO lww_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ana p̃arin sup̃e nene sinena mimi, ana mligan kiena li na mara lala apano, ana am̃e yeririna viowa la nene amarmare, a asikapi kiela pulkumali. ");
INSERT INTO lww_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ana p̃arin sup̃e nene pisa pan kiena yeririna lala, pisape ‘Kinanena nene tekila ruru p̃isi rui, ana la nap̃a nepio la p̃isi vena aimi ea, la pe pon re si aimi poli narui, teligan la. ");
INSERT INTO lww_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ana inu sineun nesape amiu ataveve narin mrapa tap̃ena lala, ana yaru ai la nap̃a amiu alualia, avio la vena aimi e p̃ap̃agena nini.’ ");
INSERT INTO lww_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ana kiena yeririna lala apano akila sanene, ap̃ure yaru la apimi, pe suri korena ga nap̃a visae yaru wo lala pona yaru viowa lala, aimi ga sanene vena akokonia ruru yo na p̃ap̃agena nene. ");
INSERT INTO lww_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Pogos nap̃a la asike loyum̃a e yo nene, ana p̃arin sup̃e nene pimi vena talopan la nap̃a apimi, ana e pogos nene naga pisu lala yaru tai, nap̃a pe miyen re mom̃a kulsota wo nap̃a torokin p̃ap̃agena poli, mien ga kulsota tai nap̃a pe tap̃ena ga. ");
INSERT INTO lww_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ana p̃arin sup̃e nene piun tan yaru nene, pisape ‘?M̃ara, ko opimi loyum̃a e yo nini sanape, nap̃a ko pe omiyen re mom̃a kulsota wo na p̃ap̃agena poli?’ Ana yaru nene pe pisa re si suri tai pan poli. ");
INSERT INTO lww_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ana p̃arin sup̃e nene pisa pan kiena yaru na yum̃aena lala, pisape ‘Amiu aviar ruru limana luwoka amio lana luwoka, ana amiu akoven naga va vanua, e yo malolo, e yo nap̃a p̃isi na naga sum̃a taglue, a sum̃a kar luen ga maluena ea.’” ");
INSERT INTO lww_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ana Yesu pisa, pisape “Ntewa naga pio yeririna la punu ga, ana ve ve moki re nap̃a naga wereplan la ave kiena.” ");
INSERT INTO lww_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ana Varasi lala apanon atap̃ali nap̃a alual naviunena m̃arera lap̃asia vena atap̃ali Yesu ea, nap̃a naga visatam̃e p̃ele ga. ");
INSERT INTO lww_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Lala apisayu m̃aga pano-o p̃isi narui, ana lala mligan kiela nalogena lap̃asia amio m̃ena ga lap̃as e p̃egas kiena ne Erot, apimi puna ne Yesu. Ana la nene akila kotalia naga e visena wo lala, la apisa apisape “Navianiena, imimi mekilia nap̃a ko ope yaru mesmesu tai. Kiom̃a visena lala punu ga pe lelaga, a ko opian ke yeririna lala e p̃elaga nap̃a Ntewa naga sinenania. Ana ko pe opisu re ga yaru lap̃as po poli, ana ko opisu yeririna punu ga marana taaga ga. ");
INSERT INTO lww_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","?Suri ne nanene narui, imimi mesitom mesape ko ovisali van imimi, nap̃a kieta navisaluaena pisa sanape? ?Pisa pisape, mesmesun ga nap̃a ita le Yu lala toul takis va Sisa, nap̃a pe p̃arin sup̃e kiena ne le Rom lala, pona pe mesmesu re na sanene poli?” ");
INSERT INTO lww_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ana Yesu kilia m̃aga nap̃a la sinelan asape akila kare naga, ana naga pisa pisape “Kiamiu visena lala po nap̃a po, ana losinemiu lala piowa a kona rui. ?Amiu asum̃a atap̃ali inu ke sanene vanon ya? ");
INSERT INTO lww_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Poga ga, amiu ala kilavaru na ulen takis tai imi.” Ana amla tai pimi, akian pania, ");
INSERT INTO lww_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ana Yesu piun tan la, pisape “?Ane marana na teke e narin kilavaru nene? ?A ane kiena kia nene?” La apisa apisape “Marana ne Sisa nene, a kiena kia m̃ena ga.” ");
INSERT INTO lww_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ana naga pisa pan la, pisape “Poga ga, suri nap̃a kiena ne Sisa, amiu ala va Sisa, a suri nap̃a kiena ne Ntewa, amiu ala va Ntewa.” ");
INSERT INTO lww_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ana pogos nap̃a la amloge visena nene, amilan pap̃isi, ana amligan Yesu ap̃ure apano. ");
INSERT INTO lww_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ana e ke e legiena nene narui, le Satusi lap̃as apimi puna ne Yesu, la sinelan asape aviun suri tai tan naga e lepas nap̃a lala amlelaga m̃arera ea, nap̃a la amlelaga asape yaru la nap̃a amare, tap̃atete amal sina e legiena maro. Vanon suri ne nanene apiun tan Yesu sanini, apisa apisape ");
INSERT INTO lww_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Yesu, ko nap̃a ope navianena, imimi sinemimi mesape meviun tan ko, mesape sanape e visena tai nap̃a yermarua Mosis pisa nanua sumo. Naga pisa pisape visae yaru tai mare tan wona, nap̃a pe narila re poli wa, naga wenla monar talopa sina amio letano nene vena ve wona. E p̃elaga nene, p̃isi na sira nene kilia war narila tai, vena uarar kia kiena ne wona na yerm̃ene nap̃a mare ne, vena kia nene mali m̃aga. ");
INSERT INTO lww_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Poga ga, ana e um̃a tai pun imimi, welelai la olua. Kiela m̃earu talopa, ana naga pe narina re tai poli wa ana naga mare tan wona, ana wenla nasiraunia p̃ere leinia pe wona. ");
INSERT INTO lww_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ana wenla nene naga mare tan m̃ena ga, a welelai na telu kila m̃ena ga sanene, pano-o tol welelai na olua, la punu ga amare tan sira nene. ");
INSERT INTO lww_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A siraun e wona la punu ga, sira m̃ena ga nene mare. ");
INSERT INTO lww_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","?Ana ko ovisali suri nene: e legiena maro, pogos nap̃a apisa ke apisape p̃isi na yaru la amal sina, p̃isi na sira nene na ve wona ai, vanon nap̃a naga talopa amio punu welelai la olua nene p̃isi rui?” ");
INSERT INTO lww_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ana Yesu pisa pisape “Peraga, kiamiu sitomena pa pe wowe la, vanon nap̃a amiu pe akilia re ya nap̃a Visena Wa kiena ne Ntewa pisa poli, a amiu pe akilia re m̃ena ga ya nap̃a naga kiena nam̃areraena keviu kilia kila poli. ");
INSERT INTO lww_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pogos nap̃a yaru lala amal sina, p̃isi na lala ave saga navisi kiena ne Ntewa lala ma e peni narui, ana p̃isi na ve akila re si suri nene natalopaena. ");
INSERT INTO lww_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","?A e lepas na malena si nene, ana Visena Wa tai kiena ne Ntewa sum̃a ga naga kilia iila ita e nene, pona amiu na pe apuloli re poli yo wa? Visena nene pisa sanini, pisape ‘In na nepe Ntewa kiena ne Epraam, Aisak, a Sekop.’ ?Ana visena nene pisa ya? La telu nene la amare e yomarava nini nakonua rui, ana kas moki na moki p̃aro rui, ana Ntewa pisa ga visena nene na wa, nap̃a pisape naga pe kiela Ntewa. Sanene na kiena visena naga kana kinasia sape la telu nene la amare e yomarava, ana la amal kemua puna na wa. Ntewa pe sinenan re sape kiena yeririna lala la ave yaru nap̃a mare la poli, ana naga sinenan sape naga ve Ntewa kiena ne yeririna la nap̃a la amali.” ");
INSERT INTO lww_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ana pogos nap̃a p̃ina na yeririna lala amloge visena kiena ne Yesu nene, la amilan suri lala nap̃a naga sum̃a pian la ke ea. ");
INSERT INTO lww_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ana pogos nap̃a Varasi lala amloge nap̃a Yesu kila Satusi lala pe akilia re si suri tai nap̃a avisa poli, ana la akila narin viorena tai p̃isi, ana apimi puna Yesu, la m̃ena ga asape akilalia. ");
INSERT INTO lww_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ana la yaru tai, nap̃a la apisu sane naga pe manmarua ruru e Navisaluaena, naga piun naviunena tai pan Yesu, pisape ");
INSERT INTO lww_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“?Navianena, inu sineun nesape ko ovisawal li, ovisave e visena la punu ga nap̃a sike e kieta Navisaluaena, nape nap̃a keviu, a to metavan la tap̃ena la sane?” ");
INSERT INTO lww_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ana Yesu pisa pania, pisape “Visena Wa pisa sanini, pisape ‘Ntewa na mava nap̃a naga pe kiom̃a Ntewa, ko monar ositom naga e losinem̃a wetelu, a e kiom̃a malena wetelu, a e kiom̃a sitomena wetelu.’ ");
INSERT INTO lww_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nanene naga pe navisaluaena p̃esia, a nap̃a naga keviu pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A navisaluaena na lua nene nap̃a naga keviu m̃ena ga sa ke ga nasumo nene, naga pisa sanini, pisape ‘Ko monar ositom nalavis pum̃a lala, okila wo van la, ve sa ke nap̃a ko ositom ko m̃aga.’ ");
INSERT INTO lww_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Navisaluaena la lua nene, ape purp̃es nen navisaluaena tap̃ena lala kiena ne Mosis, amio m̃ena ga visena kiena ne navisawalena lala, nap̃a asike e kieta Tusi Wa.” ");
INSERT INTO lww_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ana e pogos nap̃a Varasi lala asike veraga amio Yesu sanene, naga m̃ena ga piun naviunena tai pan la, pisape ");
INSERT INTO lww_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“?E kiamiu sitomena lala, asape p̃isi na Navisaarena m̃alivi e lus kiena ai?” Ana la apisatam̃ea, apisape “P̃isi na naga ve lus kiena ne yermarua Tepet nene nap̃a naga pe p̃arin sup̃e sumo.” ");
INSERT INTO lww_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Ana Yesu piun sina ga tan la, pisape “?Ee, nap̃a amiu apisa na pe lelaga, ana sanape nap̃a Ninuna Wa sike e Tepet, ana Tepet pisi, pisa pisape ‘Ntewa na mava pisa pa kiau Sup̃e, pisape “Ko ototano pun inu e lepas na p̃amarua, otom̃ate m̃a vano-o, p̃isi na inu neligan kiom̃a nasinekar lala aimi ve sa narin takue na vilanvanen lam̃a ea.” ’ “E yo nene tepisu nap̃a Tepet naga sum̃a pio Navisaarena nene pisape Navisaarena naga pe kiena Sup̃e. ");
INSERT INTO lww_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","?Ana vanon nap̃a Tepet pisa sanene, a sanapen nap̃a amiu apisa apisape Navisaarena nene naga molue ga e Tepet, ana naga pe kiena lus ga tai?” ");
INSERT INTO lww_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ana pe yaru re si tai nap̃a kilia visa si navisatam̃eena tai va Yesu, a siar m̃ena ga e legiena nene, pe yaru re si tai nap̃a kilali si Yesu e naviunena la poli. ");
INSERT INTO lww_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ana e pogos nene, Yesu pisi pa p̃ina lala, amio m̃ena kiena nalogena lala, pisape ");
INSERT INTO lww_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lelaga kemua nap̃a nanagane, navianena na navisaluaena amio Varasi lala, nap̃a la ke narui la akus lelena ne Mosis vena avisawal kinas nen navisaluaena lala kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ana visae ve sanene, ana amiu na monar alogear la, akila ve sa nap̃a la apisa. Ana amiu na ve ataveve re kiela p̃elaga lala, komin nap̃a pe akila re suri la nap̃a la asum̃a apisa ke pa yaru tap̃ena la poli. ");
INSERT INTO lww_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ana la asum̃a asikol ke si narin navisaluaena la moki nap̃a la ga akila, nap̃a m̃arera pap̃isi, nap̃a am̃areran ke pa yeririna lala vena alogear la. Asum̃a akila ke yum̃aena la nene sa nap̃a akon ke suri la nap̃a urmi pap̃isi e yeririna lala, ana lala na pe akekaran re nenaga nap̃a vena aiila la na akuspae ga suri la nene. ");
INSERT INTO lww_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Lala na ap̃arwar la manene la e kiela yum̃aena lala wa, nap̃a lala akila ga vena awere kilamarana yaru tap̃ena lala. Amiu apisu ke kiela narin pultaga la nene, nap̃a akon Visena Wa kiena ne Ntewa sike e la, nap̃a apiari e piamenala a e pilepile na limala. La asum̃a sinelan ke asape kiela lala na monar ve kerkeviu vap̃isi, taulu yaru tap̃ena lala. Amiu apisu m̃ena ga nap̃a lala apil m̃ala in kulsota na leniena lala piayavi pap̃isi. Ana la apilave manene la e suri la nene, a la sinelan ga asape yaru la ayeluar la ea. ");
INSERT INTO lww_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","A e pogos na p̃ap̃agena lala a e loyum̃a na lotena m̃ena ga lala, la sinelan nap̃a silaga asape atoga tano e lelen yerkawa lala, ");
INSERT INTO lww_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","a pogos nap̃a visae la ayaloro e lelen na wilwilena, sinelan asape monar yaru lala avatanon la, a avio ruru la avisa avisave ‘!Oo navianena wo, pokolulagi!’ ");
INSERT INTO lww_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ana amiu na, amiu kiamiu navianena taaga ga rui, a amiu na sa nap̃a na mratava taaga ga, ana visae ve sanene na amiu ve atam̃an re si yaru lala avio amiu lap̃as avisa avisave ‘Navianena.’ ");
INSERT INTO lww_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ana p̃isi na amiu ve avio re yaru e yomarava nini avisave arimamiu, vanon nap̃a amiu na Arimamiu na taaga ga, nap̃a naga sike ma e peni. ");
INSERT INTO lww_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A p̃isi na amiu ve atam̃an re yaru la avio amiu lap̃asia avisave amiu ave kiela nasumonena, komin nap̃a amiu na, kiamiu nasumonena na taaga ga, nap̃a Navisaarena nene. ");
INSERT INTO lww_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kiamiu yerkawa ai nap̃a naga to laa metava, naga monar imi ve sa ga yaru na yum̃ae kiamiuena. ");
INSERT INTO lww_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ana yaru ai nap̃a naga ga pisirlua naga vena vim ve yerkawa, p̃isi na Ntewa kila naga sum̃a tano. Ana yaru nap̃a naga ga kila naga sum̃a tano, p̃isi na Ntewa visirlua naga va metava.” ");
INSERT INTO lww_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ana Yesu pisa pan la, pisape “!Amiu navianena na navisaluaena lala amio Varasi lala, ake! Amiu akila kare amiu pap̃isi wa, p̃isi na viowa van amiu vap̃isi, komin nap̃a kiamiu visena lala pona po, ana losinemiu lala piowa a kona rui. Yaru la sinelan asape aimi loyum̃a e nasup̃enena kiena ne Ntewa, ana amiu asum̃a akotawela ke ga e marala, vena ve aimi re si loyum̃a narui, a metavania, amiu m̃ena ga pe apimi re loyum̃a poli. ");
INSERT INTO lww_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“!Amiu navianena na navisaluaena lala amio Varasi lala, ake! Amiu na apiowa ga. Amiu na asum̃a ap̃ure piavin ke kiamiu leniena la pap̃isi, ana apisokani ke ga ne, vanon nap̃a e ke e pogos nene, amiu asum̃a akila kotalia ke letano la nene, vena avinaun kiela suri lala. Vanon suri ne nanene, p̃isi na kiamiu nakoaena m̃arera re la sane. ");
INSERT INTO lww_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“!Amiu navianena na navisaluaena lala amio Varasi lala, amiu na amiyum̃ae piowa ga! Amiu akekaran nap̃a ayaloro e waa lala, vena ava e purvanua tap̃ena lala, vena akilali nap̃a aure yaru lala ataveve amiu. Ana pogos nap̃a amiu ataulu tai imi narui, ana ve ve piavi re naga la make kiamiu p̃elaga nap̃a piowa, va viowa la sane, taulu amiu sina. ");
INSERT INTO lww_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“!Ake, amiu na sumonena lala, na ape kilamara p̃ala ga lala! Akila kare amiu pap̃isi wa, p̃isi na viowa vap̃isi van amiu. E pogos nap̃a yaru lala apisa kia kien suri tai vena kila kiela navisaarena sum̃alu m̃arera, visae avisa avisave ‘Nepisa lelaga nene, Yum̃a Wa m̃ana ne Ntewa na m̃eke ne,’ ana siraun, visae akilaro sina navisaarena nene, amiu apisape ‘Nanene na naga poga ga nene, ve ve suri re tai.’ Ana visae avisa avisave ‘Nepisa lelaga, suri la nap̃a pe kol, la ne asike e Yum̃a Wa m̃ana ne Ntewa ne,’ amiu apisa apisape visena nene na m̃arera pap̃isi, tap̃atete si akilarovia. ");
INSERT INTO lww_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aa, amiu na kilamaramiu p̃ala ga, a p̃arimiu pe wowe. ?Ya ne pe suri wa manene la sane: suri la nap̃a pe kol nene, pona Yum̃a Wa m̃ana Ntewa nap̃a kila kol nene pe suri wa tai? ");
INSERT INTO lww_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“A visae yaru tai visa visave ‘Nepisa lelaga nene, wonta na m̃eke ne,’ amiu apisa apisape visena nene pe suri korena ga. A visae naga visa visae ‘Nepisa lelaga nene, kup̃ap̃aena nane m̃eke e wonta,’ nanagane amiu apisa apisape visena nene naga m̃arera pap̃isi, yaru tap̃atete kilarovia. ");
INSERT INTO lww_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","!Sa nap̃a nepisa rui, amiu ape kilamara p̃ala ga! ?Ya nap̃a pe suri wo manenea: kup̃ap̃aena nap̃a m̃eke e wonta, pona wonta nap̃a kila kup̃ap̃aena nene pe suri wa tai? ");
INSERT INTO lww_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Amiu na monar avisu kilale suri la nene, vanon nap̃a naga nap̃a ki wonta vena kila kiena visena va m̃arera, naga sum̃a ki ke m̃ena ga amio kup̃ap̃aena nap̃a sum̃a e wonta. ");
INSERT INTO lww_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","A yaru nap̃a ki ke Yum̃a Wa M̃ana Ntewa, naga ki ke m̃ena ga yerkawa nap̃a m̃ana yum̃a, ");
INSERT INTO lww_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","a yaru nap̃a ki ke pa ma e peni, naga sum̃a kipran ke m̃ena ga lele natotanoena wa kiena ne pupia P̃arin Sup̃e keviu nene, ana visae ve sanene, naga sum̃a ki mesmesun ke nena Ntewa narui. ");
INSERT INTO lww_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“!Amiu navianena na navisaluaena lala, amio Varasi lala, ake! Amiu akila kare amiu pap̃isi wa, p̃isi na viowa manene van amiu vap̃isi. In na nekilia m̃aga nap̃a amiu asum̃a apisu ruru ke silaga, nap̃a visae amiu awar kamiu kinanena ve lualima, p̃isi na monar ala tai va e Yum̃a Wa m̃ana ne Ntewa, sa nap̃a navisaluaena naga sum̃a pisa, a amiu asum̃a akila ke sanene e kiamiu suri punu ga, pano tol m̃ena ga narin m̃ak lala a suri m̃ena ga la ne sane mrasil. Ana pupia suri la nap̃a navisaluaena naga pisa, ana amiu na pe asitom re nena ga, sa nap̃a naga pisa pisape amiu na monar amesmesu ruru wo, a amiu monar asitom yaru tap̃ena lala, a amiu monar auarar kiamiu navisaarena lala. Visae amiu sinemiun awarar narin suri la ne sanene m̃arera, nanene na poga ga, ana pupia suri la nene naga popon visae amiu akila rui, ana peraga. ");
INSERT INTO lww_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“!Amiu nasumonena lala, ake, amiu na ape kilamara p̃ala ga! Amiu asum̃a akila ke sa nap̃a pogos nap̃a amiu amun suria, ana amiu asitom manene la nap̃a ve akilalu re nap̃a akilalua narin neneno tai nap̃a nap̃a talilu pito teke e m̃amiu piala, ana amiu pe apisu kilale re nap̃a amiu asum̃a asinomlaunlae ke puluk la nap̃a asike e poli. ");
INSERT INTO lww_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“!Amiu navianena na navisaluaena lala amio Varasi lala, ake! Amiu akila kare amiu pap̃isi wa, p̃isi na viowa van amiu vap̃isi. Amiu asum̃a ataveve ruru ke narin navisaluaena lala e lepas na kevanen m̃amiu piala amio kamiu pialo lala, ana amiu asitom ke asape kiamiu suri punu ga mekiki ruru narui. Ana kiamiu pialo la nene punu ga pulen ga kinanena na vinauena nap̃a amiu ap̃ar e p̃elaga na sinesunena ga lala. ");
INSERT INTO lww_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Amiu Varasi lala, amiu ape kilamara p̃ala kemua lelaga. Visae amiu sinemiun asape kamiu pialo amio m̃amiu piala lala imi ikiki ruru wo silaga, p̃isi na amiu ve akokonia la re si e kinanena la nap̃a kiamiu mlamulena viowa sike ea. ");
INSERT INTO lww_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“!Amiu navianena na navisaluaena lala amio Varasi lala, ake! Amiu na akila kare amiu pap̃isi wa, p̃isi na viowa van amiu vap̃isi. Amiu na sa ga tampona na yaru nap̃a mare, nap̃a amioa wosia miyuwowo na miyuwowo ruru po pap̃isi, ana e losa na pulen ga puriu na yaru mare nene, amio tasnena nap̃a menun ke na wa. ");
INSERT INTO lww_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","A sanene, na visae pogos nap̃a yaru la apisu ke yepas nemiu vanua, p̃isi na lala asitom ke asape amiu na amesmesu ruru ke ne, ana peraga, e losinemiu lala na apuleni ga visokanena a mlamulena viowa lala. ");
INSERT INTO lww_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“!Amiu navianena na navisaluaena lala amio Varasi lala, ake! Sila ga na amiu asum̃a apisi ke ga e kulugomiu. Amiu na asum̃a ga apisuar ruru ke tampona kiena ne navisawalena na sumo lala, ana amiu asum̃a ga apaia ke m̃ena ga kilavaru na nasitom̃alena kiena ne yaru mesmesu lala, ana sanape: ?Amiu na asitom ke asape amiu amesmesu ruru m̃ena ga amio la nene? ");
INSERT INTO lww_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","A amiu asum̃a apisa ke apisape visae amiu amal ke rui e pogos kiena ne repimiu la na nanua sumo nene, vera na amiu ve amio re la nene e pogos nap̃a la am̃e mom̃ar navisawalena lala kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ana e kiamiu visena na visokanena nene, amiu asum̃a apisa kare amiu ke sina ga, vanon nap̃a visena nene, kana kinasia sane pisape amiu ape lus ruru nenaga kiena ne repimiu lala li nawemom̃aren navisawalena lala. ");
INSERT INTO lww_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Poga ga, amiu ayum̃aen va m̃aga, amiu akilali nap̃a akila make yum̃aena nene nap̃a repimiu lala la asiar p̃esan nanua sumo rui.” ");
INSERT INTO lww_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ana Yesu pisi m̃arera ke pan la na wa, pisa pisape “Amiu na sa nena ga lom̃ara lala. ?Amiu asitom asape amiu akilia aure matan kiamiu nakoaena e lele naloge viowaena? !Peraga! ");
INSERT INTO lww_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","P̃isi na visae neiila navisawalena lala aim̃asu, amio yaru lala nap̃a ape manmarua ruru e visena kiena ne Ntewa, amio navianena na navisaluaena lala, visae aim̃asu pun amiu, ana p̃isi na amiu awe mom̃ar lap̃asia amare e laki torovia, a lap̃asia amiu awela e kiamiu yum̃a na leniena lala, a p̃isi na am̃ene plan la m̃ena ga e kiamiu pulkumali lala. ");
INSERT INTO lww_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ana p̃isi na amiu akilalue ga ve sanene van la vano-o, ana p̃isi na amiu ke ga narui nap̃a akus nakoaena vanon marena kiena ne yaru mesmesu la punu ga nene nap̃a repimiu nasumo lala am̃e mom̃ar la amarmare rui. Nanene siar e Epela, nap̃a naga pe kila re suri tai piowa poli, pimi pimi tol Sakaraea nap̃a narina ne P̃arakaea, nap̃a repimiu la nene am̃em̃ar naga mare lavisin wonta, loyum̃a e Yum̃a Wa m̃ana ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Lelaga nevisa van amiu, nakoaena nene vanon nawem̃arena kiena ne la nene, p̃isi na imi tol amiu la nene, nap̃a amiu amal ke nanagane.” ");
INSERT INTO lww_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ana Yesu tagin Yerusalem, naga pisa pisape “!Yerusalem oo, Yerusalem oo! ?Vanon ya ne ko osum̃a om̃e mom̃ar ke navisawalena lala amare sanene, a okove mom̃ar ke yaru lala nap̃a Ntewa mligan la apim̃asu pum̃a? Yam moki liu nap̃a inu sineun nesape neligan lum̃au yervivi kiom̃a yeririna lala, sa nap̃a lakaporo p̃ere narina lala apimi atapolou vatano e kupena, ana kiom̃a yeririna lala pe akekaran in re poli. ");
INSERT INTO lww_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ana ko opisu ke ne, Ntewa mligan ko ke narui, ana p̃isi na ko oimi ove yo yau korena ga narui. ");
INSERT INTO lww_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ana nevisa van ko, p̃isi na kiom̃a yeririna lala tap̃atete avisu inu sina, vano vano tol pogos nap̃a kiom̃a yeririna lala avisa sina ga sanene, avisave ‘Ntewa Namava, ovisa ruru naga nene nap̃a pimi ke e kiom̃a kia.’” ");
INSERT INTO lww_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ana Yesu molue e Yum̃a Wa m̃ana ne Ntewa, ana pogos nap̃a naga sum̃a mial pano, kiena nalogena lala apimi akilologia pupia yum̃a la nap̃a asike loyum̃a e kove na Yum̃a Wa nene, nap̃a la apowo pap̃isi, ana la apisape Yesu kirap̃atau si visu la. ");
INSERT INTO lww_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ana Yesu pisa pan la, pisape “?Amiu apisu ke yum̃a la nene? Lelaga inu nevisa van amiu, yum̃a la nene, p̃isi na tap̃atete si kana kilavaru ne tai nap̃a tom̃a ga towawa ruru teke e lelena, komin p̃isi na yar lap̃asia aimi, awe plan make nena yum̃a la nene vano.” ");
INSERT INTO lww_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","La amial sanene, apimi e Kunus Na Purolip, ana Yesu totano e yo nene. A pogos nap̃a pe yaru tap̃ena lala asu re poli, kiena nalogena lala apimi puna, ana apiun tania, apisape “?P̃isi na awe plan Yum̃a Wa nene pogwai, a kile ya na kiom̃a nawasup̃eena, nap̃a p̃isi na ko owasup̃e ko sina e luas nen pogos nini?” ");
INSERT INTO lww_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ana Yesu pisatam̃e la, pisape “Popon amiu avisuar ruru e amiu, vena ve yaru imi ve visa kotalia amiu re, ");
INSERT INTO lww_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","vanon nap̃a p̃isi na yaru la ve moki nap̃a ala kiau kia, ana p̃isi na aimi avisa avisave ‘In na nepe Navisaarena nene,’ ana visae ve sanene, p̃isi na aure yaru la ve moki nap̃a ava avewowe. ");
INSERT INTO lww_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ana e m̃ena ga e pogos nene, p̃isi na amiu aloge m̃aagena na mara nap̃a sum̃a lavisi, a lologena na mara la nap̃a sike perina, ana amiu ve sinemiu yuyuwawa manene re. Suri la nene monar imi kakate sumo, ana nanene na pe legien maro re poli la wa. ");
INSERT INTO lww_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","A p̃arin sup̃e lala, p̃isi na akila mara amio p̃arin sup̃e tap̃ena lala, a purvanua lala p̃isi na asum̃alu akawela amio purvanua tap̃ena lala. A yo kari ga e yomarava nini, p̃isi na pupia viso, a yokorena yemninu vap̃isi e yo punu ga. ");
INSERT INTO lww_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ana suri la nene, pe legiena maro re nene po la wa, ana sa ga sira nap̃a m̃ep̃ena, nap̃a sane mloge p̃esan m̃asina mlaea vena war sisi, ana pupia naloge viowaena naga pere na wa. ");
INSERT INTO lww_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“A e pogos nene narui, amiu nene nap̃a kiau kia sike e amiu, yokorena auarar amiu m̃arera, a akoa kare amiu m̃ena ga, vano vano-o awe mom̃ar amiu amarmare. Ana yaru na purvanua tap̃ena lala ve sinelan amiu re nenaga, la akawe kiamiu visena lala. ");
INSERT INTO lww_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Suri la nene, p̃isi na kila yaru la ve moki nap̃a ve aviawa re si m̃arera e inu, a p̃isi na la nene nap̃a amlelaga p̃esan e inu, p̃isi na ve sinelan re si la nap̃a amlelaga ke m̃arera e inu na wa e pogos nini, a p̃isi na la avie plan la ava e limana ne kiela nasinekar la nene. ");
INSERT INTO lww_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ana yokorena navisawalena navisokanena la ve moki asum̃alu, a p̃isi na la aure yaru la ve moki ava ayal wowe. ");
INSERT INTO lww_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yokorena naviowaena imi ve keviu manene va laa sane, kila yaru la ve moki vap̃isi nap̃a sinela la imi marmare, la pe asitom re si Ntewa poli. ");
INSERT INTO lww_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ana yaru nap̃a naga sum̃alar m̃arera sum̃a ga e inu vano vano-o pogos m̃arera nene p̃isi, p̃isi na Ntewa tamalia naga. ");
INSERT INTO lww_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","A lologena wo na nasup̃enena nene, yokorena alologon va yolai la punu ga e yomarava nini, p̃isi na kile tai nap̃a pisawal ke pisape legiena maro pimi ke narui.” ");
INSERT INTO lww_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ana Yesu pisa m̃ena ga visena tap̃ena tai, nap̃a popon visae yaru nap̃a wolovia, kilali nap̃a kilia ruru kana kinasia. Visena nene pisa sanini, pisape “Yokorena amiu akilia avisu avisirlua nono tai nap̃a viowa na viowa manene laa, nap̃a yoko sum̃alu ana warnena kare manene laa yo wa na Yum̃a Wa M̃ana ne Ntewa. Suri nene Navisawalena Taniel naga pisawal nanua sumo rui, ");
INSERT INTO lww_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","a pogos nap̃a amiu avisu suri nene, amiu nap̃a asike Yutea, amiu popon aure, ava atapolou e kunus lala. ");
INSERT INTO lww_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","E pogos nene, visae yaru tai va ruru teke vanua lavisin m̃ana yum̃a, naga monar ve va re si loyum̃a vena war kiena suri lap̃asia, ");
INSERT INTO lww_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","pona visae yaru sike e kana lokove, naga monar ve vito re si um̃a vena tar m̃ana kulsota, naga monar kiriri vitap̃ili ga sanene vano. ");
INSERT INTO lww_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ana e m̃ena ga e pogos nene, yokorena viowa la va sira la nap̃a la asena, amio m̃ena ga la nap̃a asum̃a amla ke yu pa kiela sisi tomtom lala. ");
INSERT INTO lww_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Visae ve sanene, popon amiu alen wo amiu vena kiamiu pog na ureena nene, p̃isi na ve imi tol amiu re e pogos nap̃a miava keviu, pona e legiena wa tai, ");
INSERT INTO lww_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","vanon nap̃a pogos m̃arera nene, p̃isi na m̃arera la sane taulu m̃ena ga pogos m̃arera tap̃ena lala, nap̃a siar e pogos nap̃a Ntewa sii yomarava nini pimi tol nanagane, a yokorena ve pupia pog m̃arera re si tai ve sanene pogos tai. ");
INSERT INTO lww_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ana Ntewa naga sitom̃al rui pisape yokorena tero pogos m̃arera nene imi ve plas ga, vanon kiena yeririna la nap̃a naga mligan plan la vena ave kiena, nap̃a asike e pogos nene. Ana visae naga ve tero re ve plas sanene, yokorena tap̃atete yaru tai kilia mali sike na. ");
INSERT INTO lww_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ana e pogos m̃ena ga nene, visae yaru tai visa van amiu, visa visavenua ‘Amiu apisu ke yaru nene, nanene na Navisaarena nene,’ pona visae visa visavenua ‘Nane Navisaarena ne nane gare,’ ana amiu na ve alelaga re e kiena visena la nene, ");
INSERT INTO lww_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","komin nap̃a navisaarena la mokliu nap̃a pe ape lelaga re poli, la akilia asum̃alu, amio m̃ena ga navisawalena navisokanena la ve moki, a p̃isi na la nene akila pupia kile lala, amio suri nailanena m̃ena ga lala. Yokorena akila sanene, ana p̃isi na la aure yaru lala avano avewowe, vano-o tol nap̃a p̃isi na akilali nap̃a aure m̃ena yeririna kiena ne Ntewa nap̃a naga mligan plan la vena ave kiena, ana la tap̃atete akilia akila. ");
INSERT INTO lww_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ana nanagane, akilia avisuar amiu, komin nepisawal suri la nene pan amiu sumo rui, e pogos nap̃a pe ap̃aripo re yo poli wa. ");
INSERT INTO lww_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ana vanon suri ne nanene, visae yaru la avisa van amiu, avisave ‘Navisaarena nene, nanagane naga sike gare yokorena nene rui,’ ana p̃isi na amiu na ve avanon re nap̃a avisulia, pona visae la avisa, avisave ‘Naga ke narui, naga nane sike ga loyum̃a e yum̃a nene,’ p̃isi na amiu ve alelaga re e visena la ne sanene. ");
INSERT INTO lww_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ana pogos nap̃a Narina ne Yeririna wasup̃e sina ga vitomi, ana p̃isi na vitomi merarava ruru nenaga va yeririna la punu ga, sa nap̃a yekarpla nap̃a pilavila, a vivaga ruru make ga e yo punu ga ma e sinapane. ");
INSERT INTO lww_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","E pogos nene, p̃isi na ve sa m̃ena ga nap̃a visae suri mare tai m̃eke e yo tai, ana pupia pepaum̃a la nap̃a akan ke suri mare lala, p̃isi na aiminia, la monar ave p̃egas ga asike e yo nene.” ");
INSERT INTO lww_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","A Yesu pisa pisape “Ana siraunia, mesmesun nena e pogos nap̃a naloge viowaena nene visae p̃isi narui, p̃isi na mrae imi ve pupumalo, a kupario ve tego re sina. A verue la ne ma e sinapane p̃isi na aloloru, a suri m̃arera lala nae ma e sinapane, yokorena Ntewa naga kululun la akululu.” ");
INSERT INTO lww_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“E pogos nene, kile nawasup̃eena kiena ne Narina ne Yeririna yokorena warpoyo ma e sinapane, a yokorena yolai lala nae yomarava nini atagtagi alolokai, a p̃isi na la avisu Narina ne Yeririna molue e lul lala amio pupia nam̃areraena a pupia naurarenakam kiena. ");
INSERT INTO lww_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ana siraunia, pupia kumasua yelu, a naga ligan kiena navisi lala ava e yo punu ga e yomarava nini a ma e peni, vena aure kiena yeririna la nap̃a naga mligan plan la p̃isi rui, aimi lele ve taaga puna.” ");
INSERT INTO lww_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ana Yesu pisa, pisape “Amiu asitomli purlaki nene, nap̃a asape purpiliva ne. Naga kiena suri navian amiuena tai teke ea, nap̃a amiu na monar avisururuia. Pogos nap̃a amiu avisu nap̃a naga korowas nena imi memaena, a imi malumu, sitos la siar miyulua sina, ana amiu akilia asape pogos na yepisinu m̃arera pimi ke lavisi narui. ");
INSERT INTO lww_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ve sanene, pogos nap̃a amiu avisu kile la nene e yomarava, sa nap̃a nepisa pan amiu rui, ana amiu akilia nap̃a Narina ne Yeririna naga sum̃a ga e pulutava rui, lavisi ke molue narui. ");
INSERT INTO lww_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nevisa suri na lelaga van amiu, yokorena suri la nene p̃isi na imi kakate sumo, ana siraunia, teras kiena ne yaru la nap̃a la amal ke e pogos nene, p̃isi na naga kilia kovio vetan yomarava nini. ");
INSERT INTO lww_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A yokorena sinapane amio yomarava nini lalua m̃ena ga akovio veraga, ana kiau visena lala tap̃atete akovio pogos tai. ");
INSERT INTO lww_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ana pe yaru re tai nap̃a kilia kana legiena pona aora nena nap̃a p̃isi na Narina ne Yeririna naga imi ea. Navisi lala nae ma e peni, amio Narina ne Ntewa, la m̃ena ga amninue ga, ana Ata ga, naga taaga naga kilia m̃aga.” ");
INSERT INTO lww_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ana Yesu pisa pisape “Vano vano tol pogos nap̃a Narina ne Yeririna imi sina, ana p̃isi na tap̃atete yaru la akila ruru la wo, ve sa ke pogos kiena ne Yermarua Noa nanua sumo. ");
INSERT INTO lww_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ana e pogos nene narui, sumon nap̃a pupia womie mlau, ana yaru lala asum̃a akinana m̃aga, a asum̃a amun m̃a namunena lala, a akila ke talopaena la sanene, pimi tol pogos nap̃a Noa pa loyum̃a e kiena pupia waa nap̃a naga miyum̃aenia. ");
INSERT INTO lww_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ana yeririna la nene asum̃a ga sanene, la pe asitom re suri tai poli, ana apisu ga pupia womie nene mlau pimi p̃ere plan la. Ana inu nevisa van amiu, yokorena e pogos nap̃a Narina ne Yeririna naga wasup̃e sina imi, ana p̃isi na la nene maran ve taaga ke ga ve sa nanua sumo e pogos kiena ne Noa. ");
INSERT INTO lww_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Visae yaru la ve lua, lalua asum̃a ayum̃ae ke e lokove, p̃isi na navisi lala aimi atarlua tai, ana aligan tai m̃eke na, ");
INSERT INTO lww_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","a visae sira ve lua, nap̃a lalua asum̃a ayum̃aen ke kinanena, ana la atarlua tai, ana aligan tai m̃eke na. ");
INSERT INTO lww_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Sanene, ana amiu monar asum̃a avisuar ruru amiu, komin nap̃a amiu amninue ga e legiena ya nap̃a kiamiu Sup̃e imi sina warpo yo. ");
INSERT INTO lww_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Amiu na monar avisu kilale suri nene, sa nap̃a visae yerkawa tai sum̃a ga, ana visae naga kilia m̃aga pogos nap̃a yokorena yaru navinauena tai imi e m̃ana yum̃a vena vinaun kiena suri lala, p̃isi na yerkawa nene sum̃a visuar ruru silaga, vena sum̃ate ruru yaru navinauena nene imi. ");
INSERT INTO lww_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ana ve sanene, na amiu monar asum̃a avisuar ruru amiu, vanon nap̃a Narina ne Yeririna p̃isi na naga imi kate, e pogos tai nap̃a amiu pe asitom re asape p̃isi na naga imi e poli.” ");
INSERT INTO lww_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ana Yesu pisa pisape “?Visae yaru na yum̃aena tai, nap̃a naga pe manmarua ea, naga p̃uarar ruru yum̃aena, naga yum̃ae sanape? Naga yum̃ae sanene, nap̃a visae kiena yerkawa naga ligan yo vena va perina, ana yerkawa nene ligan naga vena naga visuar ruru e yaru na yum̃aena tap̃ena lala, ana yoko yaru nene naga uarar ruru yum̃aena la nene. ");
INSERT INTO lww_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ana pogos nap̃a yerkawa nene wasup̃e sina, ana kilia lual nap̃a yaru na kiena yum̃aena nene sum̃a ga uarar ruru ke yum̃aena lala na wa. Ana yokorena yaru na yum̃aena nene loge wo vap̃isi, ");
INSERT INTO lww_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","komin nap̃a yokorena yerkawa nene ligan kiena suri punu ga e limana ne kiena yaru nene. Ee, lelaga, yoko Ntewa naga kila m̃ena ga ve sa ke nene. ");
INSERT INTO lww_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Ana visae yaru na yum̃aena nene viowa ga, a pogos nap̃a yerkawa nene ligan yo va sum̃a perina ve piavi, ana yaru na yum̃aena nene kilia visa, visave ‘?E suwala, yerkawa nene pa su piavi la wa, pona ve wasup̃e re si yo narui, pona m̃a sanape?’ ");
INSERT INTO lww_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ana p̃isi na naga sum̃alu kila viowa va yaru na yum̃aena tap̃ena lala, a yokorena naga va sum̃a mun m̃a wii, ve wowe amio yaru na munen wii lala, ana asum̃a akan kare ke ga kilavaru kiena ne yerkawa nene na. ");
INSERT INTO lww_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ana yokorena yerkawa nene naga wasup̃e imi e legiena tai nap̃a yaru na yum̃aena nene ilan ga, a e pogos tai nap̃a yaru nene naga pe sitom̃al re sape p̃isi na naga imi ea. ");
INSERT INTO lww_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ana yerkawa nene p̃isi na naga la nakoaena ve keviu va yaru nene, nap̃a yokorena kila naga va sike amio yaru na visokanena tap̃ena lala e yo nap̃a yaru la asum̃a atagi, a akar ga maluela ea.” ");
INSERT INTO lww_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ana Yesu pisa, pisape “E pogos nap̃a Narina ne Yeririna wasup̃e sina ga, yokorena nasup̃enena kiena ne Ntewa naga ve sa nap̃a p̃akaiwa nini pisa. P̃akaiwa nini, naga pisayu p̃ap̃agena na talopaena tai, nap̃a taveve kiela p̃elaga, la ne e lepas nap̃a puna ne yerm̃ene la ap̃ure naga pa e yum̃a m̃ana ne sira m̃ee vena aure sira nene amio naga imi amio la. Ana vinena ne yerm̃ene nene la lualima la asike ga um̃a, vena la akila ruru suri la punu ga. Ana lavisi yemalo, ana vinena lala la ap̃ar kiela kapi vivaga lala, la amiyalilu mrapan la, vena la punu ga awasup̃ela si aimi. ");
INSERT INTO lww_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Ana vinena la nene, lala lima la ape manmarua, asitom ruru suri po, nap̃a ap̃ar m̃a piawi na sirveve lap̃asia vena akokonia sina ga kiela nakapi vivaga lala, ana la lima na ape tampos ga, la pe asitom ruru re si sanene poli, ana la ap̃ar m̃aga kiela nakapi vivaga lala, ana la pe ap̃ar re si sirveve lap̃as poli nap̃a vena visae tap̃a, ana akilia akokonia sina ga. ");
INSERT INTO lww_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ana lala asum̃ate m̃a yaru natalopaena nene pano-o, ana naga susun pap̃isi, kila sanene sira m̃ee la lualima nene, atekavito pano-o pap̃isi, ana amomalio. ");
INSERT INTO lww_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ana kolemalo ko yepelilika, ana yaru tai pio, pisape ‘!Yaru na talopaena, pimi ke lavisi warpoyo narui. Amiu aimi avitawe naga!’ ");
INSERT INTO lww_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ana sira m̃ee la lualima nene atavilo, akila ruru kiela nakapi vivaga lala vena vivaga ruru sina. La akila plan m̃au na kilika na kapi lala, a apisuveve kiela sirveve lala. ");
INSERT INTO lww_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ana la nap̃a la pe asitom ruru re suri poli, apisu kilale kiela nakapi vivaga lala lavisi marmare, sirveve p̃isi, ana apiun tan lala p̃asia, apisape ‘Awis suwala, amiu akilia ala re narin sirveve van imimi wa, a visae peraga yokorena kiamimi nakapi la amarmare yo.’ ");
INSERT INTO lww_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ana la nap̃a asitom ruru suri po, apisa apisape ‘!Peraga yo! Sirveve nini pe torokin punu ita re poli. Popon amiu ava li si e yum̃a nawilwilena vena aul si kiamiu lap̃asia.’ ");
INSERT INTO lww_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ana la apanon si asape aul kiela sirveve, a pogos nap̃a apa ke ga wa, yaru natalopaena nap̃ani pimi poru. Naga pa loyum̃a e m̃ana yum̃a, a sira m̃ee la lima nene nap̃a la asum̃atea, lala amio naga apa veraga e kinanena na talopaena. Ana pogos nap̃a yeririna la apa asike loyum̃a rui, ana la akotava ruru e mratava. ");
INSERT INTO lww_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ana siraunia, sira m̃ee tap̃ena la nap̃ani ap̃asup̃e la ke sina ga, ana asum̃alu asum̃a mratava, apio apisape ‘!M̃eneu, m̃eneu, awis ovietava meim̃asu loyum̃a!’ ");
INSERT INTO lww_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ana yaru nap̃a pisa ga pan la, pisape ‘!Lelaga nevisa van amiu, nemninue amiu ga!’” ");
INSERT INTO lww_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ana Yesu pisa pae p̃akaiwa nene p̃isi, ana pisa pisape “Poga ga, ana amiu na monar avisuar ruru wo, vanon nap̃a amiu pe akilia re legiena na suri nene poli amio mrae nena.” ");
INSERT INTO lww_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ana Yesu pisa, pisape “Ana pogos nap̃a Narina ne Yeririna wasup̃e sina ga, p̃isi na ve sa m̃ena ga nap̃a p̃akaiwa nini pisa, pisape: Yerkawa tai, kila ruru ke pisape p̃isi na va e yo tai nap̃a koperina na koperina, e purvanua tap̃ena tai. Ana yerkawa nene pio kiena yaru na yum̃aena lala vena aimi puna, ana naga pisi pan la, mligan kiena suri lala e limala, vena avisuar ruruia ayum̃ae amio. ");
INSERT INTO lww_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ana naga pisuveve kiela na kiliaena lala p̃isi, ana mligan taga na kilavaru lima te liman tai, a mligan taga na kilavaru lua te limana yaru tap̃ena, a mligan taga na kilavaru taaga e limana ne tap̃ena, ana siraunia naga mligan la, ana pa sike koperina na piavi towe la ga. ");
INSERT INTO lww_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ana yaru nap̃a mla taga na kilavaru lima, mial ke veraga pano, kila yum̃aena la moki e kilavaru nene, pano-o tol ke sina ga taga na kilavaru tap̃ena lima. ");
INSERT INTO lww_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ana e ke e p̃elaga nene, yaru m̃ena ga nap̃a mla taga na kilavaru lua, naga m̃ena ga taulu ke sina ga taga na kilavaru tap̃ena lua. ");
INSERT INTO lww_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ana yaru nap̃a mla taga na kilavaru taga ga, naga pa kili p̃ilip̃ili e porotano, vena sinwan kilavaru kiena ne kiena yerkawa nene. ");
INSERT INTO lww_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ana pogos moki p̃aro pa rui, ana yerkawa kiena ne yaru la nene naga p̃asup̃e ke sina ga pimi, ana naga sinenan pisape visuveveli kilavaru la nap̃a naga p̃ar pa kiena yaru la telu nene. ");
INSERT INTO lww_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ana yaru nap̃a naga tol taga na kilavaru lima sumo, ana naga pimi sum̃alu se marana ne kiena yerkawa nene, naga p̃ar ke sina ga taga na kilavaru nene lima. Ana naga pisa pisape ‘M̃ara, nanua sumo ko op̃ar taga na kilavaru lima pan inu, ana na nini. Ana netaulu sina ga taga na kilavaru lima nini su metavania nanua sumo, nap̃a netauluia na pe kiom̃a.’ ");
INSERT INTO lww_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ana yerkawa nene pisa pania, pisape ‘Po pap̃isi, potena. Ko na okila yum̃aena po pap̃isi wa. Ko opuarar ruru narin yum̃aena nene nap̃a nemligan e lumom̃a, ana p̃isi na neligan ko vena ko ovisuar kiau yum̃aena kerkeviu la p̃asia. Poga ga, oimi omio inu e kiau p̃ap̃agena na kekarena nini.’ ");
INSERT INTO lww_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ana yaru nap̃a naga p̃ar taga na kilavaru lua, ana naga m̃ena ga pimi sum̃alu se marana ne yerkawa nene. Ana naga pisa pania, pisape ‘M̃ara, nanua sumo ko otar taga na kilavaru lua nini pan inu. Ana taga na kilavaru lua ne na nini, amio sina ga taga na kilavaru lua nap̃a netauluia na pe kiom̃a.’ ");
INSERT INTO lww_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ana yerkawa nene pisa pania, pisape ‘!Po pap̃isi! Potena, ko na okila yum̃aena po pap̃isi wa. Ko opuarar ruru narin yum̃aena nene nap̃a nemligan e lumom̃a, ana p̃isi na neligan ko vena ko ovisuar ruru kiau yum̃aena kerkeviu la p̃asia. Poga ga, oimi omio inu e kiau p̃ap̃agena na kekarena nini.’ ");
INSERT INTO lww_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ana yaru nap̃a tol taga na kilavaru taaga ga, naga pimi sum̃alu se marana ne yerkawa nene, pisawo ga, pisa pisape ‘M̃ara, nesitom nesape ko ope yaru m̃arera tai. Ko okilia ola kinanena e lokove nap̃a ko pe omiyum̃aen re poli, a ko okilia ola m̃ena ga mralaki e purmraki nap̃a pe ko re omapila poli. ");
INSERT INTO lww_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Vanon suri ne na nene, nemaraun ko ea, ana nepa nesinwan ga kiom̃a kilavaru e porotano. Ana nanini, ovisu kiom̃a kilavaru nane su ruru ga sum̃a ne.’ ");
INSERT INTO lww_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ana yerkawa nene pisatam̃ea, pisape ‘!Aa, ko na yaru viowa tai nene nap̃a ne, ko ope yowena pap̃isi wa! Ko opisa kare inu p̃isi rui, osape in na nepe tewena tai, ana visae ko opisu nap̃a in na nepe yaru m̃arera tai sanene, vanon ya ne ko omligan ga kilavaru su korena ga sum̃a sanene? ");
INSERT INTO lww_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Visae ko ova oligan ga e yum̃a na kilavaru vera na woga ga, vena pogos nap̃a neimi si sanini, nekilia nelalua sina amio ninusa nap̃a kapuru ke e yepasia.’ ");
INSERT INTO lww_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ana yerkawa nene pisi pa kiena yaru lala, pisape ‘Aulai, avano alalua kilavaru nene vetan limana, ana ala va van yaru nap̃a p̃arar ke taga na kilavaru lualima rui. ");
INSERT INTO lww_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nevisa sanini van amiu, visae yaru nap̃a kiena suri moki rui, p̃isi na naga war va la sane vena kiena ve moki vap̃isi, ana yaru nap̃a pe kiena suri re poli, p̃isi na naga kilia kilalu narin suri nap̃a naga mla ke na. ");
INSERT INTO lww_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ana amiu akoven melioi nene va vanua e yo malolo, e yo nap̃a yaru lala asum̃a ga atagi ke ea, a akar ke maluela ea!’” ");
INSERT INTO lww_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Siraunia, ana Yesu pisa pisape “Pogos nap̃a Narina ne Yeririna vitomi amio navisi lala e kiena naurarena, p̃isi na naga imi ve P̃arin Sup̃e narui, a p̃isi na naga vitomi va e kiena lele wa na totanoen ea. ");
INSERT INTO lww_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ana navisi lala, p̃isi na awere yolai punu ga na yomarava nini aimi asum̃alu ase marana. Ana e pogos nene narui, p̃isi na naga lip̃ere yaru lala ava e p̃egas ve lua, ve sa nap̃a yaru tai navisuaren suri mali lala, naga lip̃ere kiena sipsip lala e nane lala. ");
INSERT INTO lww_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ana p̃isi na p̃arin sup̃e nene ligan kiena sipsip lala ava ase kiena lepas na p̃amarua, a nane lala ava ase lap̃as na p̃am̃eli. ");
INSERT INTO lww_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ana p̃isi na naga visa van la ne asike e lepas na p̃amarua, visave ‘Amiu yeririna ne la na nene nap̃a Ata naga visa ruru amiu. Amiu aimi narui, a akus lelemiu loyum̃a e kiena nasup̃enena, nap̃a naga miyum̃aen ruru sum̃ate amiu ke rui nanua sumo, e pogos nap̃a naga sii yomarava nini ea. ");
INSERT INTO lww_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Amiu aimi, vanon pogos nap̃a visae viso kar inu, amiu amla kinanena pan inu, a pogos nap̃a moto kar inu, amiu amla wii pan inu. A pogos nap̃a nepe wolawa ga, amiu ap̃ure inu nepa e m̃amiu um̃a, ");
INSERT INTO lww_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","a pogos nap̃a yepeu korena ga, amiu amla kulsota pan inu. A pogos nap̃a nemai, amiu apimi akaten inu, a pogos nap̃a nesike e yum̃a na loge viowaena, amiu apimi asun amio inu.’ ");
INSERT INTO lww_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","39","“Ana yaru mesmesu lala nap̃a asike e lepas na p̃amarua p̃isi na aviun tania avisave ‘?Ana Sup̃e, sanape? Ko osum̃a apisa ke osape imimi memiila ko e kiom̃a pogos m̃arera la ne sanene, ana imimi pe mesitom re nena mesape mekila sanene pan ko poli-i p̃isa. ?Imimi mekila suri la nene pan ko na pogwai?’ ");
INSERT INTO lww_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ana yoko P̃arin Sup̃e nene visatam̃e la, visave ‘Lelaga nevisa van amiu, pogos nap̃a amiu akila ke sanene pan yaru na m̃au mratava tai, ana sa ga nap̃a akila ke ga pan inu narui, pe suri korena ga nap̃a naga pe yaru na sanape. ");
INSERT INTO lww_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ana siraunia, p̃isi na naga pisi m̃ena ga pa la nap̃a e lepas na p̃am̃eli, yokorena visa van la, visave ‘Amiu aure vetan inu, Ntewa piain nakoaena viowa tai pan amiu p̃isi rui. Amiu ava e kapi nene nap̃a pivaga m̃a silaga, tap̃atete mare pog tai, nap̃a sum̃ate ke Yermare Lego amio kiena navisi lala vena la ava ea. ");
INSERT INTO lww_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Vanon pogos nap̃a viso kar inu, ana pe amla re kinanena pan inu poli, a pogos nap̃a moto kar inu, ana pe amla re wii pan inu poli. ");
INSERT INTO lww_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","A pogos nap̃a nepe wolawa, ana pe ap̃ure inu re nepa m̃amiu um̃a poli, a pogos nap̃a yepeu korena, ana pe amla re kulsota pan inu poli, a pogos nap̃a neminana, pona nesike e yum̃a naloge viowaena, ana pe apimi akaten inu re poli.’ ");
INSERT INTO lww_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ana p̃isi na la avisatam̃e p̃arin sup̃e nene, avisave ‘?Ana Sup̃e, sanape? ?Imimi mom̃al ko na pogwai nap̃a ko viso kar ko, pona moto kar ko, pona ko ope wolawa, pona ko yepem̃a korena ga, pona omai, pona osike e yum̃a naloge viowaena? ?Ana pogwai nap̃a ko sanene, ana imimi pe mepimi memiila ko re poli?’ ");
INSERT INTO lww_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ana naga p̃isi na visatam̃e la, visave ‘Lelaga, nevisa van amiu, nevisave pogos nap̃a amiu na pe asitom̃ali re nap̃a akila ve sanene va kiau yaru tai nap̃a naga pe yaru na sanape, nanene na sa ga nap̃a amiu pe asitom̃ali re nap̃a akila pan inu poli.’” ");
INSERT INTO lww_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ana Yesu kila make kiena visena nene, naga pisa pisape “La nene yokorena la avanon vena atol nakoaena nene nap̃a ve uro re. Ana yaru mesmesu la nene yokorena la avanon atol malena nene nap̃a sum̃a vano vano ve uro re.” ");
INSERT INTO lww_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ana pogos nap̃a Yesu pian kiena yeririna lala e visena la nene p̃isi, ana naga pisa pan la, pisape ");
INSERT INTO lww_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Amiu akilia m̃a legiena na vewo rui, ana P̃ap̃agena Nasitom̃alena Natamaliaena siar narui. E pogos na p̃ap̃agena nene narui, p̃isi na aligan Narina ne Yeririna va e limana ne la nap̃a yoko asuari naga e laki torovia vena mare.” ");
INSERT INTO lww_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ana e pogos nene, yerkawa lala kiena ne yaru wa lala, amio nasumonena kiena ne le Israel lala, asum̃a e viorena e yum̃a m̃ana ne p̃arin yaru wa, nap̃a naga kiena kia Kaep̃as. ");
INSERT INTO lww_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","La apisayu ke nap̃a p̃isi na auaravinaun ga Yesu, a ala nakoaena namarena ga vania. ");
INSERT INTO lww_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ana la apisa apisape “Suri nene, ita tap̃atete tekila e pogos na p̃ap̃agena, vanon nap̃a p̃isi na yaru la sinela kar ita vap̃isi, ana yokorena la am̃aaga vap̃isi ne wa, komin nap̃a la mokliu nap̃a la akekaran yaru ne nanene p̃isa.” ");
INSERT INTO lww_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ana siraunia, Yesu sike garu e pulkumali nene Petani, ana naga pa sike e yum̃a m̃ana ne yaru nap̃a apio kiena kia asape Saemon Leperosi, komin nap̃a naga p̃ar leperosi sumo. ");
INSERT INTO lww_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ana pogos tai nap̃a Yesu kinana ke e yum̃a nene, ana sira tai pimi puna, ana sira nena kus piawi nap̃a amiyum̃aenia e kilavaru tai nap̃a po pap̃isi, a ponotaninu pule ga m̃eke ea, nap̃a kana kilavaru keviu manene la pap̃isi. Ana sira nene taron make ponotaninu nene e p̃arina ne Yesu. ");
INSERT INTO lww_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ana pogos nap̃a nalogena kiena ne Yesu lala apisu suri nene, ana sinela mimi pap̃isi, ana la apisape “?Vanon ya ne naga kila kare ponotaninu nene sanene? ");
INSERT INTO lww_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Visae naga wilwilin lua ga, vera na naga tol kilavaru keviu tai, naga kilia lavia vena iilaen yaru la nap̃a limala korena ga.” ");
INSERT INTO lww_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ana Yesu kilia m̃a nap̃a la apisi ke sanene, ana naga pisi pan la, pisape “Ei, ve akila kare re sira nene sanene. Naga kila yum̃aena wo tanea e inu ne. ");
INSERT INTO lww_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yaru la ne pe kiela suri re poli, p̃isi na la na asum̃a ga likan amiu silaga, vena akilia aiila la, ana inu na, tap̃atete nesike nemio amiu silaga. ");
INSERT INTO lww_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Suri nap̃a sira nene kila, nap̃a taron ponotaninu e tasneu, naga kila sane kila ruru ke tasneu vena asin inu. ");
INSERT INTO lww_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Lelaga nevisa van amiu, e yo punu ga e yomarava nini nap̃a p̃isi na avisawal kiau nalologena wo ea, ana p̃isi na lala asunyu m̃ena ga suri nap̃a sira nene kila, vena asitom̃ali luen ga kiena nasitomiena keviu nene, nap̃a sinena mie inu kemua lelaga.” ");
INSERT INTO lww_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ana nalogena la lualima taaga pa lua nene, lala tai, nap̃a kiena kia Sutas nae Kariot, naga pa puna ne yerkawa kiena ne yaru wa lala, ");
INSERT INTO lww_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ana naga pisa, pisape “?Visae nevielua Yesu vim̃asu e limamiu, p̃isi na amiu ala ya ne van inu?” Ana la nene apul pania e kilavaru nap̃a selpa tol lualima yam telu, ");
INSERT INTO lww_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ana siar e pogos nene, Sutas sum̃a kalewele mrapa nap̃a vielua Yesu van la ea. ");
INSERT INTO lww_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ana pimi tol legiena p̃esia na p̃ap̃agena nene, nap̃a la apisa m̃ena ga apisape naga pe P̃ap̃agena Na Kanen Kiligap̃e, ana nalologena lala apimi puna Yesu, apiunia apisape “?Ko sinom̃an osape imimi meva mekila ruru suri lala e yo nape, vena ita tekila Kinanena Na Sitom̃alena Natamaliaena ea?” ");
INSERT INTO lww_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ana Yesu pisatam̃ea, pisape “Ava garu Yerusalem, ava avisu yaru nap̃ani, avisa van sanini, avisave ‘Kiamimi navianena pisape naga kiena pogos pimi ke lavis narui. Naga sinenan pisape naga, amio imimi kiena nalogena lala, p̃isi na meimi mekila kanena nap̃ani e mom̃a um̃a.’” ");
INSERT INTO lww_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ana nalogena lala apa akila sa nap̃a naga pisa, ana la akila ruru suri lala na p̃ap̃agena nene. ");
INSERT INTO lww_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ana siraunia, Yesu lala apimi e um̃a nene, ana kolemalo, la atotano, la asum̃a akan ke kinanena nene narui, ");
INSERT INTO lww_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","a Yesu pisa pisape “Lelaga nevisa van amiu, p̃isi na amiu yaru tai, naga vielua inu.” ");
INSERT INTO lww_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ana kiena nalogena lala amloge nap̃a naga pisa sanene, ana la sinela piowa pap̃isi, ana lala peve taaga apiun tania, apisape “!Sup̃e! ?Pe inu re poli, ne?” ");
INSERT INTO lww_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ana Yesu pisatam̃e la, pisape “Tai nap̃a imimi lua melapae kamimi kinanena e pialo taaga, naga ke narui. ");
INSERT INTO lww_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yokorena Narina ne Yeririna monar mare ve sa nap̃a Nasiriena Wa la pisayuia, ana yaru nap̃a pielua naga, p̃isi na viowa la van naga, visae naga ve vaeme re vera wo va p̃isi.” ");
INSERT INTO lww_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ana Sutas, nap̃a siraunia naga pielua Yesu, naga piunia pisape “?Navianena, ana ai? ?Inu?” Ana Yesu pisatam̃ea, pisape “Ana, sane opisa ne yo.” ");
INSERT INTO lww_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ana pogos nap̃a la asum̃a akinana ke ga wa, Yesu mla kilaparavi tai, pisa potena pa Ntewa vanonia, ana naga kawe wowaia, kian pa kiena nalologena lala, pisa pisape “Amiu alavia, akania. Nanene na pe tasneu.” ");
INSERT INTO lww_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","A siraunia, mla piala na kuruta namunena, ana pisa potena pa Ntewa vanonia, ana kian pa pan la, naga pisa pisape “Amiu punu ga amunpae ga e piala nini, ");
INSERT INTO lww_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","vanon nap̃a nanene na tau nene, nap̃a vena kila naviranarena kiena ne Ntewa sum̃alu m̃arera, a vena lau vanon naviewoena na mlamulena viowa kiena ne yaru lala ve moki. ");
INSERT INTO lww_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nevisaar van amiu, yokorena ve nomun re si kuruta namunena nene narui, vano vano-o yoko nemun kuruta na munena viu nene nemio amiu, e pogos nap̃a tesike e nasup̃enena kiena ne Ata.” ");
INSERT INTO lww_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ana siraunia la amiyau maro e yauena tai na Yauena lala p̃isi, a siraunia la amolue, apa maro e Kunus Na Purolip. ");
INSERT INTO lww_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ana Yesu pisa pan la, pisape “E yemalo ke nini narui, kiamiu nalelagaena e inu p̃isi na loloru, vanon suri la nap̃a imi m̃alm̃alivin inu. P̃isi na ve sa ke ga nap̃a Ntewa pisa e Nasiriena Wa lala, nap̃a pisa, pisape ‘P̃isi na nowem̃ar yaru na visuarena sipsip mare, ana p̃isi na kiena sipsip lala ayaltetai ava e yo punu ga.’ ");
INSERT INTO lww_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Ana pogos nap̃a nemali sina ga vetan marena, yokorena nesumo neva garu Kalele, ana yokorena amiu m̃ena ga monar asirau aimi.” ");
INSERT INTO lww_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ana Pita pisawal pania, pisape “Yesu, pona nalelagaena kiena ne la nene punu ga loloru, ana la aure vetan ko yo, ana in na tap̃atete kemua neligan ko pog tai.” ");
INSERT INTO lww_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ana Yesu pisa pania, pisape “Lelaga nevisa van ko, p̃isi na yemalo ke ga nene, pogos nap̃a term̃ene ve kokoreko re yam tai wa, ana ko oviro inu yam ve telu narui, ko ovisave omninue nu ga.” ");
INSERT INTO lww_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ana Pita pisawal meraravan pa Yesu e marala, pisape “Visae la sinelan avisave awem̃ar nu nemio ko, nanene na poga ga ne, ana inu, yokorena tap̃atete kemua neviro ko, nevisave in na pe nepe kiom̃a re poli.” A e pogos nene, nalologena tap̃ena m̃ena ga lala apisa m̃ena ga sa ke ga. ");
INSERT INTO lww_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ana siraunia, Yesu amio kiena nalogena lala apa e yo tai, kiena kia Ketsemani. Ana naga pisa pan la, pisape “Amiu atom̃a e nene sumo wa, ana in na neva laa perina sane, vena nelen re yam ve plas ga.” ");
INSERT INTO lww_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ana naga p̃ere Pita amio narina ne Sepeti la luwoka, Semes amio Yoane, la teloka nene amio naga apa la perina ve tokak ga, a e pogos nene Yesu naga sinena pimi urmi manene la, mloge piowa pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ana naga pisa pa la telu nene, pisa pisape “Nanagane nemloge sane ninuu pilaroro la narui, ana kila inu lavisi nemare vanonia. Awis, amiu akilali asum̃a atavilo amio inu e yo nini sumo wa.” ");
INSERT INTO lww_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ana Yesu mial ga pa la sane, ana mloru kinai mono, monar marana, vena len. Ana naga pio, pisape “!Ata o! Visae okilia okila suri nene, awis ko olalua piala naloge viowaena nene vetan inu, vena p̃isi na ve nomun re ea. Ana ko ve okila re nasinenanena kiau, ana okila ga kiom̃a.” ");
INSERT INTO lww_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ana naga p̃asup̃e sina, pitomi puna ne kiena nalogena la telu nene, ana naga pisu nap̃a la asum̃a amomalio rui. Ana la atavilo sina, ana Yesu pisa pa Pita, pisape “?Sanape na amiu tap̃atete atavilo amio inu e aora ve taaga ga nene? ");
INSERT INTO lww_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Amiu monar avisuar ruru wo, a amiu monar alen silaga, vena nakilaliena lala ve akila amiu re aloru e mlamulena viowa. Ee, kiamiu sitomena m̃arera ruru po, ana tasnemiu malumu manene la.” ");
INSERT INTO lww_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ana yam lua, naga pa sina e nap̃ani, mlen pisape “!Ata o! Visae otap̃atete olalua m̃au piala naloge viowaena nene, ana monar nomun ea, komin nap̃a monar ve sa ga nap̃a ko sinom̃ania.” ");
INSERT INTO lww_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ana naga p̃asup̃e sina pimi, pisu nap̃a la telu nene asum̃a amomalio ke sina ga, komin nap̃a marala kawa, atekavito pap̃isi, atavilo p̃ele ga. ");
INSERT INTO lww_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ana naga mligan la telu nene asum̃a ga, ana p̃asup̃e ke sina ga pa e nap̃ani, mlen e visena taaga m̃a nena ga, nap̃a naga kila yam telu ne. ");
INSERT INTO lww_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ana naga p̃asup̃e si pimi pun la telu nene, pisape “?Ei, amiu asum̃a apa ruru amiu, a amomalio ke ga wa? !Amiu avisuaria! Lavisi ke pogos nap̃a Narina ne Yeririna va e limana ne li viowa la narui. ");
INSERT INTO lww_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ita, asum̃alu, tevano. Amiu apisu ke ne, yaru na vielua inuena nane sum̃a pimi m̃a ga lavisi nam̃a.” ");
INSERT INTO lww_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ana pogos nap̃a Yesu pisa ke visena nene wa, Sutas nene, nap̃a nalogena la lualima taaga pa lua nene lala tai, naga pimi, naga amio yaru na mara la moki nap̃a ap̃ar kiela playu na mara lala amio kiela plaki lala. La ke nene narui, nap̃a yerkawa lala kiena ne yaru wa lala, amio nasumonena kiena ne le Yu lala, la amligan la apimi. ");
INSERT INTO lww_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ana sumon nap̃a la apa am̃alivi sanene, yaru na vieluaena nap̃a Sutas nene, naga pisaar kile tai pan la, nap̃a naga pisa pisape “Yaru nap̃a visae neva nevitawe p̃esania, nane yaru ne nanene nap̃a p̃isi na amiu auarar ruru naga,” ");
INSERT INTO lww_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ana pogos nap̃a la am̃alivi, Sutas mial mesmesun ga Yesu, ana naga pitawea, pisa pania, pisape “!Pokolemalo, Navianena! Sum̃are sike amio ko.” ");
INSERT INTO lww_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ana Yesu pisa pania, pisape “M̃ara, yum̃aena nap̃a ko opiminia, ko okila ga.” Ana la apimi narui, apuarar Yesu m̃arera. ");
INSERT INTO lww_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","La apuarar naga sanene narui, ana Pita p̃erelua kiena playu, terania, tetereria yaru kiena ne P̃arin yaru wa tai, ana telua kiligana lepas tai. ");
INSERT INTO lww_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ana Yesu pisa pania, pisape “Ko oligan ruru si kiom̃a playu e kana taga. Yaru nap̃a p̃ar ke playu na kilaen mara, naga p̃isi na mare e playu na kilaen mara. ");
INSERT INTO lww_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","?Amiu asitom asape in na tap̃atete nevio Ata, vena naga iila inu? Visae nevio naga, yam ve taaga naga p̃isi na ligan p̃egas nen kiena navisi lala ve moki nap̃a vena aimi avisuar inu. ");
INSERT INTO lww_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ana visae nekila sanene, p̃isi na visena nasumo lala nap̃a asike e Nasiriena Wa lala, yokorena la tap̃atete aimi ave lelaga, sa nap̃a apisaar p̃isi rui.” ");
INSERT INTO lww_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ana Yesu pisi pan yaru la nene, pisape “?Vanon ya ne amiu ap̃ara kiamiu playu amio kiamiu plaki lala? ?A vanon ya ne amiu asape aimi atararvinaun inu e pupumalo sanene? ?Pona amiu asitom ke asape in na nepe yaru m̃arera na vinauena tai pona na wem̃aren yaru? ?Ana silaga e legiena punu ga, nap̃a in na nesum̃a nepian ke yaru lala loyum̃a e Yum̃a Wa M̃ana ne Ntewa, ana vanon ya ne pe apimi atarar inu re e pogos la nene poli? ");
INSERT INTO lww_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ana suri la nene la poga ga ne, vanon suri la ne amiu akila ke ne, sa ke ga nap̃a navisawalena nasumo lala apisawal nanua rui e kiela Nasiriena Wa lala, ana kiela visena la nene pimi ke sane pe lelaga make narui.” Ana e pogos nene, nalogena lala amligan Yesu, la ap̃ure matania. ");
INSERT INTO lww_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ana la nap̃a atarar Yesu, ap̃ure pimi vena akila naga sum̃alu se marana ne Kaep̃as, nap̃a naga pe P̃arin yaru wa. Ana navianena navisaluaena lala amio nasumonena kiena ne le Yu lala, apimi m̃ena ga lele taaga e kiena kumali nene rui. ");
INSERT INTO lww_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ana Pita m̃ena ga sum̃a taveve ke Yesu e pogos nene, ana pe pa re lavisin naga poli, ana pogos nap̃a la apimi loyum̃a e kove na kumali nene, Pita pano totano amio li nayum̃aena kiena ne Kaep̃as lala, vena naga logeli sanape nap̃a p̃isi na la akila va Yesu. ");
INSERT INTO lww_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ana yerkawa lala kiena ne yaru wa lala, amio yerkawa tap̃ena lala nap̃a la asike loyum̃a e viorena nene, akilali nap̃a akale yaru lap̃asia vena la avisokan ga e Yesu, nap̃a la avisa suri lap̃asia nap̃a la avisu sane akilia awem̃ar Yesu mare vanonia. ");
INSERT INTO lww_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ana la apisi narui, ana yaru la moki nap̃a asum̃alu, la apisokani pano pano-o pap̃isi, ana viorena nene pe m̃a re suri tai e kiela visena la poli vena torokin la akila ve sanene va Yesu. Kiela visena la peve tap̃ena ga sanene pano-o p̃isi, ana yaru la lua asum̃alu, ");
INSERT INTO lww_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ana la lua apiranari visena taaga, apisape “Yaru nene, pisa pisape naga kilia we plan Yum̃a Wa M̃ana ne Ntewa, ana visirlua sina e legiena ve telu ga.” ");
INSERT INTO lww_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ana P̃arin yaru wa nene sum̃alu, pisi pa Yesu, pisa pisape “?Sanape, yokorena ko ovisatam̃e la, pona peraga? ?Sanapen visena la nene nap̃a la asum̃a apisawal ke ne?” ");
INSERT INTO lww_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ana Yesu topuru ga tom̃a ga. Ana P̃arin yaru wa nene pisa sina ga pania, pisape “Nevisa van ko, ko na monar ovisa kia kiena ne Ntewa Mali, ovisave lelaga nap̃a ko Navisaarena, nap̃a ko ope narina ne Ntewa, pona pe ko re naga poli. !Ko na monar ovisawal ruru van imimi nanagane narui!” ");
INSERT INTO lww_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ana Yesu pisatam̃ea, pisape “Suri ne nanene narui, nane ko osum̃a opisa ke narui. Ana nevisa van amiu, nesape siraunia ve ve piavi re, p̃isi na amiu avisu Narina ne Yeririna nap̃a totano e lepas marua kiena ne Ntewa nam̃areraena, a p̃isi na amiu avisu nap̃a warpoyo e lul lala, vitomi tano e yomarava nini.” ");
INSERT INTO lww_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ana P̃arin yaru wa nene sinena mimi pap̃isi, pitolwowa m̃ana kulsaket, pisa pisape “!Nane-e, toroki! Yaru nap̃a sum̃a p̃arnena kare ke kia wa kiena ne Ntewa, nanene rui. ?Amiu amloge m̃a ne? ?Vanon ya ne ita tesum̃a takale ke si yaru vena visawal si suri lap̃as e naga? ");
INSERT INTO lww_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","?Ana viorena nini sitom sanape? ?P̃isi na telip̃ere naga sanape?” Ana la apisatam̃ea, apisape “Popon awem̃ar nena naga mare.” ");
INSERT INTO lww_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ana la nene la apilasiria marana, a asu naga, a lap̃asia la amlipa kare naga pap̃isi, ");
INSERT INTO lww_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ana apisa kare naga, apisape “?Ei, Navisaarena, ko ovisawalia, ane mlipa ko ga na wa?” ");
INSERT INTO lww_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ana e pogos nene, nap̃a Pita tom̃a tano loyum̃a e kove nene, sira m̃ee tai na visuaren yum̃a pimi puna, pisa pisape “!Ei, ko m̃ena ga otaveve Yesu nae Kalele nene!” ");
INSERT INTO lww_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ana e marala la punu ga, Pita piro suri nene, pisa pisape “Peraga, nemninue suri na ko opisa ke ne.” ");
INSERT INTO lww_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ana naga mial petania, pito tano e pupia pulutava na kove na kumali nene. Ana e yo nene, sira m̃ee tap̃ena m̃al naga, ana pisa pa yaru la nap̃a asike ga lavisinia, pisape “Yaru nene, naga m̃ena ga amio yaru nae Nasaret nap̃a Yesu.” ");
INSERT INTO lww_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ana Pita piro ke sina ga suri nene, pisa visena tai nap̃a pe visena m̃arera, pisape “!Peraga p̃a, in na nemninue nena yaru nene!” ");
INSERT INTO lww_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ana yam plas ga, yaru la nap̃a asike ga lavisin pulutava nene apimi puna ne Pita narui, ana apisa pania, apisape “Lelaga, ko na ko lala yaru tai, vanon nap̃a memloge kilale nap̃a ko osum̃a op̃an ke visena lala sa ga le Kalele ga lala.” ");
INSERT INTO lww_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ana Pita pisi m̃arera la sane, naga pisaar ga visena m̃arera lala, pisape “!Lelaga p̃a, sinapane! Nepisa pa rui, inu na pe nekilia re nena yaru nene poli.” Ana e ke e pogos nene nap̃a Pita pisa visena nene, term̃ene tai kokoreko, ");
INSERT INTO lww_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ana kila Pita sitom̃al si visena kiena ne Yesu, nap̃a naga pisa pania, pisape “Lelaga nevisa van ko, p̃isi na yemalo ke ga nene, pogos nap̃a term̃ene ve kokoreko re yam tai wa, ana ko oviro inu yam ve telu narui, ko ovisave omninue inu ga.” Ana Pita mloge piowa nap̃a piowa, ana naga pa vanua, naga tagi nap̃a tagi. ");
INSERT INTO lww_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ana e kolulagi nene, pogos nap̃a mrae siar pa metava, yerkawa kiena ne yaru wa lala amio nasumonena kiena ne le Israel lala, la atotano ke sina ga vena aviranar ruru li mrapa tai, vena kilaen Yesu mare. ");
INSERT INTO lww_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pogos nap̃a la apisayu p̃isi, ana la apiar limana ne Yesu, la ap̃ure naga pa puna ne P̃aelat, nap̃a naga pe p̃arin sup̃e nae Rom nap̃a naga pisuar ke Israel e pogos nene, ana la amligan Yesu e limana ne P̃aelat nene, vena naga lip̃ere naga. ");
INSERT INTO lww_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ana Sutas, nap̃a naga pielua Yesu p̃isi, naga pisu kilale nap̃a la amlip̃ere Yesu p̃isi rui asape naga monar mare, ana e pogos nene naga mloge si piowagan suri nap̃a naga kila. Ana naga pilon si kiena sitomena narui, ana naga p̃ar si selpa lualima yam telu nene, pa yerkawa la nap̃a apul naga sumo. ");
INSERT INTO lww_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ana naga pisa pan la, pisape “In na nekila mlamulena viowa nene, nap̃a inu nepielua yaru tai nap̃a pe kila re nena suri tai, ana kiau visena na kila na yoko awem̃ar naga mare.” Ana yerkawa la nene apisa ga pania, apisape “Ei, ve oimi otag re si van imimi. Imimi mep̃isin ko pa rui.” ");
INSERT INTO lww_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ana Sutas silin tetain kilavaru nene su tano e loyum̃a wa m̃ana Ntewa, ana naga pa vanua, pa telan kolmekina e kilika, naga mare. ");
INSERT INTO lww_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ana yerkawa kiena ne yaru wa lala, la apano ap̃ar kilavaru nene, ana la apisape “Kilavaru nene, kuruta kana yaru mlau vanon rui, a e kieta navisaluaena, ita tap̃atete teligan kilavaru na sanene va teke karo na Yum̃a Wa M̃ana Ntewa.” ");
INSERT INTO lww_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ana lala apisayuia, ana amla kilavaru nene, apa apul kinakinas nen porotano tai nap̃a nanua sumo, la apisape kiena kia “Porotano na piaki,” ana la amligan narin porotano nene pe lotap kiena ne wolawa lala. ");
INSERT INTO lww_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Vanon suri ne nanene, pimi tol nanagane, yaru lala apisa ke narin porotano nene, asape “Porotano na Kuruta.” ");
INSERT INTO lww_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","A suri ne nanene kila visena tai kiena ne Navisawalena Serem̃aea pimi pe lelaga, nap̃a sumo naga kiena visena pisape “La ala kilavaru nap̃a selpa ve lualima yam telu nene, na torokin maran kilavaru nap̃a le Israel lala apisa apisape mesmesun aul lua yaru, ");
INSERT INTO lww_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ana la amla apano apul porotano kiena ne yaru na kilaen piaki nene, sa ga nap̃a Ntewa pisa pan inu sape nekila.” ");
INSERT INTO lww_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ana la ap̃ure Yesu pimi sum̃alu se marana ne P̃arin Sup̃e P̃aelat, ana naga piun tan Yesu, pisape “?Ko ope P̃arin Sup̃e kiena ne le Israel lala, pona peraga?” Ana Yesu pisatam̃ea, pisape “Naga ke narui, sane ko opisa ke ne.” ");
INSERT INTO lww_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ana pogos nap̃a yerkawa kiena ne p̃arin yaru wa lala amio nasumonena lala apisavisawal suri moki e Yesu, ana Yesu pisatam̃e re si suri tai poli. ");
INSERT INTO lww_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Naga topuru ga tom̃a sanene, ana kila P̃aelat piun sina ga tania, pisape “?Sanape, ko pe ositom re nap̃a la apisa suri viowa la moki e ko poli?” ");
INSERT INTO lww_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ana e lepas na suri la nene nap̃a la asum̃a apisa ke ne, ana Yesu pe pisatam̃e re si suri tai pan la poli, ana P̃arin Sup̃e nene milan pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ana e pogos nene, la asike e pog na P̃ap̃agena na Sitom̃alena Natamaliaena na wa, ana e kayui punu ga e p̃ap̃agena nene, P̃arin Sup̃e nae Rom nene naga silaga kila suri tai pa le Israel lala. Naga kila nap̃a visae la p̃asia asike e yum̃a naloge viowaena, la akilia avisa kia kiena ne yaru ve taaga nap̃a la sinelania, ana yokorena P̃aelat naga ligan lua naga molue. ");
INSERT INTO lww_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ana e pogos nene, yaru na kilaen politik tai naga mom̃a e yum̃a naloge viowaena, nap̃a yaru la akilia ruru naga, kiena kia Yesu P̃arap̃as. ");
INSERT INTO lww_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","P̃isi na, pogos nap̃a p̃ina lala apimi ape moki lele taaga e marana ne P̃aelat, ana naga piun tan la, pisape “?Amiu sinemiun asape neligan lua ane molue sina im̃asu pun amiu? ?Sinemiun Yesu P̃arap̃as, pona Yesu nap̃a apio ke asape Navisaarena?” ");
INSERT INTO lww_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","P̃aelat piun sanene, vanon nap̃a naga kilia p̃isi rui nap̃a yerkawa ga lala kiena ne le Yu lala, la ap̃ure Yesu pimi puna, sane yum̃aena na vielueen ga, vanon nap̃a apisu nap̃a kiela yeririna tap̃ena lala akekaran Yesu pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ana e m̃ena ga e pogos nap̃a naga totano ke e lelen nalip̃ereena vena akila navisena nene, ana wona mligan visena pimi pania, pisape “Ko ve okila re suri tai va yaru nene. Naga pe kila re suri tai poli, ana na kolemalo nomomalio, nepisu naga, ana nanagane nemloge ke piowa vanon pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sanene narui, P̃aelat sinenan pisape ligan lua Yesu naga vano, ana yerkawa lala kiena ne yaru wa lala amio nasumonena kiena ne le Yu lala, la akila kare sitomena kiena ne yeririna lala, la am̃areran la pap̃isi vena la monar avisa va P̃aelat vena naga ligan lua P̃arap̃as nene vano, a naga monar kila Yesu va mare. ");
INSERT INTO lww_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ana P̃arin sup̃e nene piun sina ga tan la, pisape “?Amiu sinemiun asape netam̃an yaru la lua nene, ana ane molue ga sane?” Ana la apisatam̃ea, apisape “Imimi sinemimin P̃arap̃as.” ");
INSERT INTO lww_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ana P̃aelat piun tan la, pisape “Poga ga, ana visae ve sanene, p̃isi na nekila ve sanapen Yesu nene nap̃a apio ke naga asape Navisaarena?” Ana la punu ga apionia, la apisape “!Asuar naga e laki torovia!” ");
INSERT INTO lww_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ana P̃aelat piun tan la, pisa pisape “?Vanon ya? ?Naga kila suri ya nap̃a piowa?” Ana la apion manene la pa metava sane, la apisa apisape “!Asuaria, asuar naga e laki torovia!” ");
INSERT INTO lww_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ana P̃aelat pisu nap̃a naga tap̃atete si taulu la, vanon nap̃a pupia m̃aagena pap̃isi nap̃a pa ke metava rui, ana naga kus pialo na wii tai, ana e maran yeririna la nene, naga kevan limana ea, ana naga pisape “Kuruta na yaru nene naga pe su re e inu poli. Kiena marena, naga kiamiu yum̃aena ga nene.” ");
INSERT INTO lww_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ana pogos nap̃a yaru la amloge visena nene, la akiikii ke sina ga, apisape “Poga ga ne, suri ke nap̃a imimi sinemimin ke nanene narui e, nap̃a kiena marena pe kiamimi yum̃aena, a nap̃a kana kuruta sum̃a e imimi memio narimimi lala.” ");
INSERT INTO lww_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ana P̃aelat mligan lua P̃arap̃as molue si p̃asup̃e pa pula, sa nap̃a la sinelania, ana naga mligan Yesu e limana ne kiena li na mara lala vena akoa naga, a vena aure naga va asuaria e laki torovia. ");
INSERT INTO lww_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ana yaru na kilaena mara lala kiena ne P̃aelat, la atar Yesu ap̃urelua pa vanua e yometava na kiena kumali nene, ana la apio pa kiela p̃egas nen li na mara tap̃ena lala vena la aimi avisu Yesu. ");
INSERT INTO lww_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ana la amiyenlua m̃ana kulsota, ana amiyen kulkota tai e naga nap̃a marana pe melia vivaga sa nap̃a p̃arin sup̃e la amiyen, ");
INSERT INTO lww_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ana la ap̃ar nenos nen kilsirili, ana ap̃an ruruia, amligan e p̃arina, sa nap̃a karo na p̃arin sup̃e tai, a amligan m̃ena lakiavio tai e limana na p̃amarua vena lararia. Ana la asum̃a akinai tano pania, la asum̃a akirakirai viowa pania, la apisa apisape “!Imimi meva tanon ko, ko nap̃a ope P̃arin Sup̃e kiena ne le Yu lala, imimi memieluar ko!” ");
INSERT INTO lww_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ana la asum̃a apilasiria naga, a amla lakiavio nap̃ani, asum̃a am̃e p̃arina Yesu ea. ");
INSERT INTO lww_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ana pogos nap̃a la akirakirai piowa pania p̃isi, ap̃arlua kulkota nene e naga, ana amien si m̃ana kulsota la e naga, ana atar naga, apano vena asuar naga e laki torovia. ");
INSERT INTO lww_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ana pogos nap̃a li na mara lala la asumon Yesu apa ke narui, amal yaru tai nae Saerin, kiena kia Saemon, ana la am̃areran pania asape naga towe kus laki torovia kiena ne Yesu vano. ");
INSERT INTO lww_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ana la apa atol kunus tai, kiena kia Kolkota, nap̃a kana kinasia na asape yo nap̃a sane puriu na piap̃arin yaru. ");
INSERT INTO lww_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pogos nap̃a apimi aporu e wos nen kunus nene, ana la sinelan asape ala kuruta namunena va Yesu vena munia, ana kuruta namunena nene was nen suri tai nap̃a melkalka sike ea, vena kila tasnena ne Yesu kapulu ga, ve lae manene re, ana pogos nap̃a Yesu munli suri nene, naga yepen mavin si munena. ");
INSERT INTO lww_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ana la atar Yesu, asuari naga e laki torovia. P̃isi na, la akila sa nap̃a amlil m̃apila, vena alual li nap̃a ane war m̃ana kulsota tai, a ane war tai, ");
INSERT INTO lww_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ana la atotano atom̃aga e yo nene vena akirakira m̃aga va avisu naga. ");
INSERT INTO lww_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ana la asiri navisawalena tai, asuari teke metavan p̃arina, nap̃a pisawal suri nap̃a la am̃em̃ar naga mare vanonia, nap̃a pisa pisape “Yesu nene, P̃arin sup̃e kiena ne le Yu lala.” ");
INSERT INTO lww_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ana e pogos nene, yaru navinauena lalua, asuari m̃ena ga la luoka e laki torovia sa ke Yesu, la amligan tai e lepasnena na p̃amarua, tap̃ena e lepasnena na p̃am̃eli. ");
INSERT INTO lww_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ana yaru la nap̃a asum̃a amialoro ke apa e yo nene, asum̃a asisilin p̃arila, apisalele kare Yesu p̃isa, la apisa apisape ");
INSERT INTO lww_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“!Ke, suwala! Ko nene, nanua sumo ko opisa opisape ko okilia owe plan Yum̃a Wa M̃ana ne Ntewa, ana ovisirlua ke sina ga e legiena ve telu ga, ana sanape narui? !Poga, ko ga otamalia ko lia! !Visae ko ope narin Ntewa kemua lelaga, ko otapulu e laki torovia nam̃a, otomi tano!” ");
INSERT INTO lww_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","E p̃elaga m̃a nena ga nene, yerkawa lala kiena ne p̃arin yaru wa lala, amio navianena na navisaluaena, a li na sumonena kiena ne le Yu lala, la asum̃a apitalia kare naga pap̃isi, ");
INSERT INTO lww_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","la asum̃a apisa ke, apisape “!Pona naga tamalia m̃a yaru tap̃ena la moki yo rui, ana naga mninue kare si narui, tap̃atete si tamalia naga! ?Ana naga pe kieta p̃arin sup̃e ita le Yu lala, pona peraga? Popon naga vitomi tano e laki torovia nanagane, vena ita telelaga e naga. ");
INSERT INTO lww_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A yaru nene pisape naga piawa e Ntewa, ana pisape naga Narina ne Ntewa. !Poga ga, tevisulia, visave Ntewa kekaran naga, yoko naga tamalia naga nanagane narui!” ");
INSERT INTO lww_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ana yaru navinauena la lua nene, nap̃a asuar la e laki torovia amio Yesu, la m̃ena ga luoka asikol sina visena viowa kiena ne la nene pania. ");
INSERT INTO lww_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ana kolipae ga, yemalolo pimi kalo make yo punu ga e yo nene, pano tol mrae telu yepekilavi, ");
INSERT INTO lww_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","a lavis ga e pog nene, Yesu mlokai keviu e kiena visena ruru napo, pisa pisape “?Eli, Eli, lam̃a sap̃atani?” nap̃a kana kinasia sape “?Kiau Ntewa, kiau Ntewa, sanape nap̃a ko omligan inu nem̃eke sanene?” ");
INSERT INTO lww_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ana yeririna lap̃asia nap̃a asum̃alu asum̃a e yo nene, nap̃a la asum̃a apisuvisu ke suri la nene, ana amlogepalia nap̃a Yesu mlokai sane, ana la apisa apisape “Ke, yaru nene sum̃a pio ke yermarua Elaisa, vena imi iila naga-o.” ");
INSERT INTO lww_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ana veraga ga, lala yaru tai kiriri pimi, mla lumlum tai, taron kuruta namunena nap̃a melkalka pa ea, miyurar te laki tai, ana kian va Yesu munia. ");
INSERT INTO lww_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ana yaru tap̃ena lala apisa apisape “!Osuwa! Tevisulia wa, pona yokorena yermarua Elaisa vitomi tamalia naga, pona ve vitomi re.” ");
INSERT INTO lww_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ana Yesu mlokai manene sina, ana p̃ere maron kiena yalua, tam̃an ninuna pano, mare p̃an. ");
INSERT INTO lww_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ana pogos ke ga nene, pupia kulmrae nap̃a e Yum̃a Wa M̃ana ne Ntewa, nap̃a mono ke yo wa nap̃a pe yo wa pap̃isi, naga purp̃a pito ga lika, siar metava pito tol tano. A yemninu, a pupia kilavaru lala pororowa la, ");
INSERT INTO lww_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","a e lotap, tampona na yaru mesmesu la moki na nanua sumo apikevike, ana kana yaru ne lala amamal sina. ");
INSERT INTO lww_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ana la amolmolue e kiela tampona lala, ana siraun pogos nap̃a Yesu m̃ena ga mali sina ga e marena, la nene amial apa garu pulkumali wa Yerusalem, ana yaru la moki nap̃a apisula. ");
INSERT INTO lww_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ana li na mara lala, amio kiela yerkawa, nap̃a la asum̃a apisusuari ke Yesu, pogos nap̃a la amloge yemninu, a apisu suri la nap̃a kakate, la amilan pap̃isi, la sinela kurkur pano-o amiyuyuwawa, ana la apisa apisape “!Aulai, yaru nene naga pe Narina ne Ntewa kemua lelaga nap̃a ne!” ");
INSERT INTO lww_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ana sira la moki pap̃isi e yo nene, la asum̃a asum̃alu asike la perina sane, la asum̃a apisuvisu ke Yesu. La nene, naga la nap̃a amolue garu Kalele nanua sumo, la asum̃a ataveve m̃a Yesu pano-o, a asum̃a amiila naga. ");
INSERT INTO lww_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ana likan sira la nene, ana Maria tai nap̃a sira nae Maktala, a Maria m̃ena nap̃a anenane Semes amio Yosop, a sira m̃ena nap̃a wona ne Sepeti. ");
INSERT INTO lww_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ana yaru tai nae Aramatia sum̃a ga, nap̃a naga pe yaru na suri moki, kiena kia Yosop, a naga pe nalogena kiena ne Yesu tai. Ana pogos nap̃a lavisi mrae vito tano, ");
INSERT INTO lww_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","naga pa sum̃alu se marana ne P̃aelat, piun tania pisape kus tasnena ne Yesu. Ana P̃aelat pisa pa kiena li na mara lala, vena la akus tas nen Yesu imi vania. ");
INSERT INTO lww_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ana Yosop kus tasnena ne Yesu, mliluwoia e kulmrae tai nap̃a miyuwowo ruru po, ");
INSERT INTO lww_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ana naga pa mligan m̃eke e puluve viu nap̃a naga m̃ana, nap̃a la ate mare ga p̃isi ga na wa. Ana la amelilivin pupia kilavaru na monoen puluve nene, pimi mono pulusa, ana Yosop la ap̃asup̃e si apano. ");
INSERT INTO lww_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ana Maria lalua nene, nap̃a lala tai nae Maktala, amio tap̃ena nene, lalua apimi asike e yo nene, la atom̃a tano ato mesmesun ga pulmaran puluve nene nap̃a tasnena ne Yesu m̃eke ea. ");
INSERT INTO lww_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ana suri la nene la apimi kakate e legiena na kilaen suri la punu ga su ruruia sum̃ate Legiena Wa. Ana e legiena tap̃ena, nap̃a sane Legiena Wa nene narui, yerkawa kiena ne yaru wa lala amio Varasi lala la apa asum̃alu ase marana ne P̃aelat, ");
INSERT INTO lww_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ana la apisa apisape “Mesape mevisa ga van ko, P̃aelat, nap̃a imimi mesitom̃al ke visena kiena ne yaru na visokanena nene na wa, nap̃a pogos nap̃a naga mali ke ga wa, naga sum̃a pisaar pisape ‘Siraun legiena ve telu, p̃isi na nemali ke sina ga.’ ");
INSERT INTO lww_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ana visae ve sanene, imimi sinemimin mesape meviun tan ko sanini, mesape ko oligan kiom̃a li na mara lap̃asia ava avisuar e puluve nene, vano vano tol kana legiena telu nene warovia. Visae peraga sa p̃isi kiena nalogena la ava akusvinaun tasnena, ana p̃isi na la avisokan, avisawal va yaru lala, avisave ‘Naga mali sina e marena rui.’ A visae la akila ve sanene, p̃isi na kiena navisokanena maro nene yoko imi viowa la sane, taulu nap̃a nasumo.” ");
INSERT INTO lww_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ana P̃aelat pisa pan la, pisape “Poga ga, aure kiau li na mara lap̃asia avano. Amiu akilia ava akila ruru make suri punu ga sa nap̃a amiu ava akirakiravan ruru yo nene.” ");
INSERT INTO lww_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ana la apano, amligan pilu tai e kilavaru nap̃a mono ke puluve nene, nap̃a visae yaru tai melilivin kilavaru nene, p̃isi na pilu nene worovia, ana p̃isi na akilia avisu kilalea. Ana la amligan m̃ena li na mara lala asum̃a akirakirava e puluve nene. ");
INSERT INTO lww_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ana pogos nap̃a Legiena Wa p̃arovia, ana e legiena na siraunia, nap̃a legiena p̃esia na wik, pogos nap̃a mrae p̃arpoyo, ana Maria nae Maktala amio Maria tap̃ena nene, lalua apanon asape avisuli puluve nene. ");
INSERT INTO lww_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lalua apano atol yo nene, ana pupia yemninu veraga, vanon nap̃a navisi kiena ne Ntewa tai mligan ma e peni, pitomi tano melilivin lua kilavaru nene, ana pa teke metava e wosia. ");
INSERT INTO lww_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ana marana pilavila pap̃isi, a m̃ana kulsota merarava ruru po, nap̃a miyuwowo na miyuwowo ruru po, ");
INSERT INTO lww_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ana pogos nap̃a li na mara lala la apisuia, la amarau pano pano-o amarmarlula asike ea. ");
INSERT INTO lww_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ana navisi nene pisi pan sira la lua nene, pisa pisape “Marauen toko. Nekilia m̃a nap̃a amiu lua apimin ke Yesu, nap̃a asuar naga e laki torovia, ");
INSERT INTO lww_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ana naga pe mon re si e nini poli, naga mali sina, sum̃alu rui, sa nap̃a naga pisaar sumo. Amiu lua aimi avisuia e nap̃a tasnena momalio m̃enea. ");
INSERT INTO lww_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ana amiu lua ava vila ga, avisawal va kiena nalogena lala nap̃a naga mali si e marena rui. Ana nanagane, yokorena naga sumo vito garo Kalele, ana amiu m̃ena ga yoko atove, avisu naga e yo nene. Nane kiau visena pan amlua nene.” ");
INSERT INTO lww_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ana lalua akoskosin nap̃a lalua amolue e puluve, lalua apano. Lalua apano na, sa nap̃a lalua amarau ke ga wa ana lalua amloge sane akekara m̃ena ga pap̃isi. Ana lalua akiriri apano vena avisawal lologena nene va kiena nalogena lala, ");
INSERT INTO lww_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ana lalua apa m̃a sane, ana lalua apitawe Yesu. Lalua amilan kare naga pap̃isi, ana naga pisi pan lalua, pisa pisape “Pokolulagi.” Ana lalua apa akinai tano e naga, lalua atarar lana, lalua amlotun naga. ");
INSERT INTO lww_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ana Yesu pisa ga pan la luoka, pisape “Marauen toko. Amiu ga luoka ava avisa va wolai lala vena ato garo tano Kalele, ana e yo nene, la akilia avisu inu.” ");
INSERT INTO lww_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pogos nap̃a sira lalua nene ap̃asup̃ela apa ke puna ne nalogena lala, e ke e pogos ga nene, ana li na mara lala p̃asia ap̃asup̃ela apa Yerusalem, la apa apisawal suri la nene nap̃a kakate, van yerkawa kiena ne yaru wa lala. ");
INSERT INTO lww_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ana la nene, la apio nasumonena tap̃ena lala apimi, ana la apa lele taaga amio la, ana la apisayu suri la nene pano-o p̃isi, ana la apiranaria asape la monar awar kilavaru keviu tai va li na mara la nene, ");
INSERT INTO lww_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ana la apisi m̃arera pan la, apisape “Avano avisavisawal va yeririna lala, avisave ‘!Peraga, kiena nalogena ga la nene! Apimi kolemalo, e pogos nap̃a imimi mesum̃a momomalio ke ga wa, ana la apinaun tasnena akus apano.’” ");
INSERT INTO lww_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ana la apisa m̃ena ga pan la, apisape “A visae visena na suri nene va tol P̃aelat, p̃isi na imimi ga mevano mekila ruru memio naga, p̃isi na amiu ve aloge re visena tai vanonia.” ");
INSERT INTO lww_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ana li na mara la nene akekaran kilavaru nene, amlavia, ana la apano apisovisokani e yo punu ga sa nap̃a yerkawa la nene apisa pan la, a suri nene kila le Israel lala la apisavisa ke visena nene pimi tol nanagane. ");
INSERT INTO lww_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ana nalogena la lualima taaga pa taaga nene apito garo tano Kalele, e tavie nap̃a Yesu pisaar pan la, ");
INSERT INTO lww_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ana pogos nap̃a la apisu naga, amlotun naga, ana la p̃asia la asitom p̃ele ga asape Yesu re nene poli. ");
INSERT INTO lww_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ana Yesu pimi lavisin la, pisa pan la, pisape “Ntewa mligan suri punu ga nae ma e peni a nae m̃ena ga e yomarava nini, e lum̃au, vena nevesup̃en la. ");
INSERT INTO lww_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sanene, nemligan plan amiu ke narui, vena amiu monar ava e yolai punu ga na yomarava nini, amiu monar aurela aimi ave kiau nalogena lala, nap̃a amiu akela e kia kiena ne Ata, Narina, a Ninuna Wa, ");
INSERT INTO lww_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","a nap̃a avian la m̃ena ga vena alogear visena la nap̃a nepisa pan amiu p̃isi rui. Ana amiu monar asitom̃ali luen ga, nap̃a nesum̃a nemio amiu silaga, vano vano-o tol luas nen pog nini.” ");
INSERT INTO lww_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Na nene Lologena Wo kiena Yesu Kristo nap̃a narina Ntewa. ");
INSERT INTO lww_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Suniena na Lologena Wo nini siar e Yoane Nakeena, sa nap̃a Visena Wa kiena ne Ntewa pisayu naga konua rui e visena tai nap̃a Navisawalena Aisea pisawalia, nap̃a Ntewa pisa pisape “Naga pe yaru tai nalologonen kiau visena, nap̃a nemligan naga sumon ko, pe na kilaruruen mrapa lala kiom̃a mekiki ruru wo. ");
INSERT INTO lww_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ana naga sum̃a piovion ke e yokorena, piovion ke pisa ke pisape ‘Amiu na monar akila ruru mrapa lala kiena Sup̃e Ntewa, amesmes ruru wo, vena naga kilia yali ea imi kate e kiamiu malena lala.’” ");
INSERT INTO lww_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Sanene narui, Yoane Nakeena pimi kate e yokorena lepas nap̃a Yutea, ana mlologon ke visena kiena ne Ntewa pan yeririna lala. Naga pisawal ke pan la pisape “Amiu monar avilopu amiu e kiamiu mlamulena viowa lala, aimi, vena nekee amiu e wii nakeena, p̃isi na Ntewa viewo amiunia.” ");
INSERT INTO lww_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ana p̃isi na yeririna la moki nae Yerusalem amio nae pulkumali tap̃ena e lepas nap̃a Yutea, la apa amiyagogan Yoane, ana la apisa plan ke kiela naviowaena lala pania, ana naga kee la e wii nap̃a Yortan. ");
INSERT INTO lww_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ana pogos nap̃a Yoane Nakeena sike e yokorena sanene, naga kila sa ga yermarua navisawalena tai na konua rui nap̃a Elaisa, sa nap̃a pe miyen re kulsota la nap̃a po poli, ana m̃ana kulkota ape ga e vilulus nen sur mali tai nap̃a kiena kia kamel, ana kulka na m̃ep̃ena amiyum̃aen e narin kulus nen puluk tai. A kana kinanena e yokorena nene, naga kurpo ga ne amio kopululus nen lago na yom̃arua, nap̃a kiki sane purutevi. ");
INSERT INTO lww_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ana pisaar pan yeririna lala, pisa pisape “P̃isi na yar tai, nap̃a puryuna m̃arera taulunu, naga yoko siraun inu imi. Yar nene, naga to laa metavan inu, in na pe netorokin re poli nap̃a neulounia neyen plan kiena kulus nen lana, pona nekila si yum̃aen tai ne sanene vania. ");
INSERT INTO lww_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","In na nesum̃a nekee amiu e ga e wii, ana yoko naga kee amiu e Ninuna Wa.” ");
INSERT INTO lww_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ana Yesu mligan pulkumali nap̃a Nasaret, e lepas nap̃a Kalele, pimi e lepas nap̃a wii nae Yortan, ana Yoane kee e wii nene. ");
INSERT INTO lww_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ana pogos nap̃a kee pae Yesu, Yesu sum̃alu, molue e wii pa metava, ana veraga ga ma e peni pietava pania, naga m̃al Ninuna ne Ntewa pitomi ke tano sa ga manu nap̃a lom̃e, pitomi mesmes ga koan te naga. ");
INSERT INTO lww_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ana lala amloge Ntewa nae ma e peni pis pitomi, pisape “Ko, ko ga taaga ope naruu wawa, ana nepinaia ko pap̃isi. Sineu si ko, nekekaran ko pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ana e pogos m̃a ke nene, Ninuna Wa p̃ere Yesu naga taaga pa laa perina sane e yokorena, ");
INSERT INTO lww_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ana Yesu sum̃a e nene tol legiena lualima yam vari, nap̃a Yermare tap̃ali naga pap̃isi. Yesu sike amio sur mal tetan lala e lele nene, ana navisi kiena ne Ntewa lala apimi apisuar ke naga. ");
INSERT INTO lww_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ana siraunia, apim atarar Yoane Nakeena, ap̃ere pa akotawea e yum̃a naloge viowaena. Ana pogos nap̃a Yesu mloge lologena nene, petan yo p̃asup̃e pato si lepas nap̃a Kalele, ana siar e pogos nene, naga mlologon Lologena Wo kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ana pogos nap̃a naga mlologon ke, pisa ke sape “Nanagane na, Ntewa kilia sane pe pog mesmes nap̃a monar avilopu amiu narui. Navesup̃enena kiena ne Ntewa naga pimi ke pun amiu narui, monar avilopu amiu, alelaga e Lologena Wo nini.” ");
INSERT INTO lww_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ana siraunia, Yesu naga sum̃a mialoro ke e is nen pupia lapa nae Kalele, m̃al yaru la lua nawereen ika, nane Saemon amio wenla Antru, lalua asum̃a ap̃ere ke kiela lilivi. ");
INSERT INTO lww_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ana Yesu pisa pan la, pisape “Amiu lua aim atavevenu. Yoko nekila amiu ave li nawereen yeririna lala aim ave kiau.” ");
INSERT INTO lww_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ana veraga ga lalua nene amligan kiela lilivi lala, ataveve Yesu. ");
INSERT INTO lww_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ana Yesu mial pali laa sane, kirawal narina ne Sepeti la luoka, nane Semes amio wenla nap̃a Yoane. Lalua atotano ke e pulus nen kiela waa, akila ruru ke kiela lilivi lala. ");
INSERT INTO lww_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ana pogos nap̃a Yesu kirawal lalua nene, pio la, vena la m̃ena ataveve naga, ana asum̃alu, amligan arimala Sepeti naga m̃eke e waa amio kiena yaru nayum̃aena lala, lalua ataveve Yesu. ");
INSERT INTO lww_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ana Yesu amio kiena yaru lala amial apa atol pulkumali nap̃a Kapeneam, ana e Legiena Wa, apa e yum̃a nalotena, ana Yesu naga pian yeririna lala e Visena Wa kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ana la nap̃a amiyagogania amilan pap̃isi, komin nap̃a amloge navianena kiena ne Yesu naga pe tap̃ena, pe sa re navianena kiena ne kiela navianena la poli, komin Yesu naga kiena urmi po, puriukawaena kiena ne Ntewa teke ea. ");
INSERT INTO lww_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ana e pogos nene, yaru tai nap̃a ninuna viowa teke e naga sike amio la, ");
INSERT INTO lww_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","kila yar nene, naga m̃am̃aaga kare ga pap̃isi, naga pis pa Yesu, pisape “?Yesu nae Nasaret, kiom̃a ya ne teke e imimi? !Po ko na opimin osape okila kare imimi! In na nekilia ko pa rui, ko na ope Yar Nowo Wa kiena ne Ntewa.” ");
INSERT INTO lww_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ana Yesu pis m̃arera pan ninuna viowa nap̃ane, pisalup̃ar pania, pisape “!E, ko na ve ovis re! !Oure vetan yar nene nanagane ga ne!” ");
INSERT INTO lww_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ana ninuna viowa nap̃ane kila yepen yar nene miokamarmare, m̃aaga keviu yam si tai, p̃isi na molue petania pure pano. ");
INSERT INTO lww_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ana yar la nae yo nene amilan sur nene pap̃isi, asum̃a apisasayu ke Yesu, asape “?E, sanape na sanene? ?Navianena viu si tai nene, pona yar ne? Yar nene, naga puriuna kawa pap̃isi ne, pis ga pan ninuna viowa lala, ana amlogearia.” ");
INSERT INTO lww_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ana komin sur ne la nanene narui, akekarania, apisa ruru kia wo kiena Yesu pa e yo lala pa p̃ar punu yo punu ga e lepas nae Kalele. ");
INSERT INTO lww_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ana Yesu amio yaru ne la nini, Semes amio Yoane, a Saemon amio Antru, lala amolue petan yum̃a na lotena, apa e yum̃a m̃ana ne lalua nene Saemon amio Antru, nanene e pulkumali m̃a ke ga nap̃a Kapeneam. ");
INSERT INTO lww_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ana e um̃a m̃ana lalua nene, anenane wona Saemon naga mai m̃eke ea, yepena pisusun, momalio ke e m̃ana tog, ana lalua apisawal pa Yesu. ");
INSERT INTO lww_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ana Yesu pa tarar limana sira marua nene, tarlua tom̃alu e m̃ana tog, ana yepena pimi manin sina, naga sum̃alu, pa piran kala kap. ");
INSERT INTO lww_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ana e m̃a nena e legiena nene ko yepekilavi, pogos nap̃a Legiena Wa p̃arovia, sane mrae pito kovio pa rui, yeririna lala ap̃ure yar la nap̃a amai, a la nap̃a yermare la asike e la, apim pu Yesu, ");
INSERT INTO lww_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ana la moki manene la, sa nap̃a lavisi la punu ga nae kumali nene apim asum̃alu e mratava na yum̃a nene. ");
INSERT INTO lww_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ana Yesu kila ruru yeririna la moki nap̃a amain inanena tap̃ena lala, a m̃ene plan yermare la moki petan yar lala, pisawo yermare lala sape ve avisa re si sur tai, komin akilia pa rui sane naga pe Navisaarena kemua lelaga kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ana kolulagi, pogos nap̃a lakaporo pe kokoreko re poli waa, Yesu sum̃alu, naga taaga mial petan um̃a, ana pa e yo m̃ano tai, mlen pa Arimana. ");
INSERT INTO lww_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ana siraunia, yeririna la apimi akale si naga um̃a, ana Saemon la am̃a re si naga poli, la apa akalea. ");
INSERT INTO lww_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Lala akale m̃a pano-o, am̃al naga e yo nap̃ane, apisa pania, asape “Yeririna tap̃ena la moki apimin akale ko ke.” ");
INSERT INTO lww_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ana Yesu pisape “Ee, nekilia m̃a ga. Ana peraga, monar teva m̃ena ga e pulkumali tap̃ena lap̃as nap̃a sike ga waa, vena nekilia nelologon m̃ena Lologena Wo nene van la. Sur ne na nene, in na nepetan ma ne nepitom nesike e yo nene.” ");
INSERT INTO lww_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ana p̃isi na Yesu pato mialoro ke e yo punu ga garo Kalele, mlologon ke e yum̃a na lotena kiena le Yu lala, pile plan ke m̃ena yermare lala moki petan yeririna lala. ");
INSERT INTO lww_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ana yaru tai nap̃a leperosi sike e yepena pimi puna Yesu, kinai tano puna, piun m̃areran tania, pisape “Awis, visae ko na otam̃an ga, nelelaga sane ko ga okilia okilarurunu, neikiki sina.” ");
INSERT INTO lww_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ana Yesu sinena miye manene yaru nap̃ane, naga pe maraun re sape visae tol lae naga vanon kiena inanena, ana naga mligan limana te naga, pisape “Inu netam̃ania, nanagane monar yepem̃a ikiki sina.” ");
INSERT INTO lww_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ana veraga ga yepena miania, leperosi nene p̃isi petan yepena, naga mekiki sina. ");
INSERT INTO lww_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ana Yesu m̃areran pania, pisa pisape “Omloge ke ne, ovano ve ovisawal re suri nene wa, ana nanagane ga ne ova okom puna yaru wa vena naga kilia visuveve yepem̃a. P̃isi na monar ova okila lotena va Ntewa a okila m̃ena kup̃ap̃aena na ikikiena nene nap̃a Mosis pisa, sape yaru monar kila vanon sur na sa nene, ana p̃isin sur nene, yar wa kilia visawalia sape nanagane na leperosi naga p̃isi.” Ana Yesu pitetalia naga pano. ");
INSERT INTO lww_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ana pogos nap̃a yaru nene pano, pa pisayu sur la nene pan yeririna lala punu ga, kila sane visena nene pa p̃ar punu yo, pano-o kila sane Yesu pe mial re si pa loyum̃a e pulkumali tap̃ena la poli, komin visae vano, yoko yeririna la ve moki aiminia. Naga sum̃a ga perinan pulkumali lala, ana yeririna lala asum̃a apetan ke kiela pulkumali lala, apimi puna. ");
INSERT INTO lww_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ana legiena lap̃as p̃arovia, Yesu p̃asup̃e si pa ma pulkumali nap̃a Kapeneam, ana pe piavi re poli, yeririna la amloge asape naga pam si rui. ");
INSERT INTO lww_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ana p̃isi na la moki nap̃a apim puna, yo loyum̃a naga pulen la pap̃isi, a vanua m̃ena e mratava naga yepa vitokaki ga. Ana pogos nap̃a la asike lele taaga sanene, Yesu mlologon Visena Wa kiena ne Ntewa pan la. ");
INSERT INTO lww_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ana e ke e pogos nene na, yar lap̃asia atar yaru tai nap̃a minana pimi, nap̃a yepena wetelu ga mare. Ana la vari atar ga naga e m̃ana tog nap̃a mono ke ea pimi. ");
INSERT INTO lww_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ana pogos nap̃a apim atol yo nap̃ane, apisu sane yo pule pa rui, tap̃atete si atar kiela erau nene va lavisin Yesu. P̃isi na lala ataryaun naga apa metava e wos nen yum̃a nap̃ane, lala am̃epo wos nen yum̃a metava mesmesun ga e nap̃a Yesu sike ea, amligan malumun yaru nap̃a mono ke e m̃ana tog, pitomi tano e pulmas nap̃ane, pito loyum̃a. ");
INSERT INTO lww_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ana pogos nap̃a Yesu kira pisu sur nene, kilia sape la nene, amlelaga m̃arera e naga pap̃isi sane yoko naga iila kiela inanena nene, naga pisa pania, pisape “Naruu, in na nepiewo kon kiom̃a mlamulena piowa lala.” ");
INSERT INTO lww_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ana e pogos nene yaru navianena na visaluaena la p̃asia asum̃a ga, amloge ke visena kiena ne Yesu. Ana p̃isi na la kiela sitomena la miyum̃ae piowa ke e sur nene, ");
INSERT INTO lww_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","apisa kare ke naga, apisape “?Yaru nene pisalele kare ke kia wa kiena ne Ntewa sanape na sanene? Ntewa naga taaga kilia viewo mlamulena viowa lala, pe yar re si tai poli, ana yaru nene pis ke sanene, naga sitom ke sape naga pe Ntewa narui.” ");
INSERT INTO lww_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ana veraga ga, Yesu mnunulu-p̃aria sape asitom ke piowa sanene e naga, ana pis pan la, pisape “?Komin ya ne sinemiu la pulen ke sitomena viowa la ne sanene? ");
INSERT INTO lww_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Visae nevisa ve sanini van inanena nene, nevisave ‘Nepiewo pa kiom̃a mlamulena viowa rui,’ pona nevisa vania nesapenua ‘Osum̃alu, osulowar mom̃a tog, oyali,’ ana e visena lua nene, tai naga m̃areran navisaena, a tai naga meme ga nap̃a avisa. Nap̃a sape ‘Osum̃alu, oyali,’ naga m̃arera manene laa, komin yoko akilia avisulup̃ar sane kiau visena nene pe lelaga pona pe pe lelaga re poli, nap̃a yaru nene sum̃alu, pona pe sum̃alu re poli. ");
INSERT INTO lww_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ana nagane, neyum̃aen sur tai nap̃a amiu asitom ke asape Ntewa ga naga taaga kilia yum̃aenia, vena akilia avisulup̃ar sane Narina Yeririna naga kiena puriukawaena torokin nap̃a viewo mlamulena viowa lala na yomarava nini. Amiu ayagogan ruruia.” ");
INSERT INTO lww_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ana Yesu pisa pa yaru na inanena nap̃ane, pisape “Nepisa pan ko, osum̃alu, osulowar mom̃a tog, oyali ova um̃a.” ");
INSERT INTO lww_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ana veraga ga, e maran la nap̃a apisu ke, sum̃al sanene, kus m̃ana tog, mial pa vanua pa um̃a. Ana pogos nap̃a p̃ina la nene apisu sur nene, amilan pap̃isi, amieluar Ntewa, asape “Awee, pe tepisuli re sur tai sanene poli wa e kieta malena, p̃ane ga ne.” ");
INSERT INTO lww_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ana Yesu p̃asup̃e si pito garo e is nen pupia lapa, ana p̃ina la moki apim lele taaga e yo nene akovivia, naga pian la ke. ");
INSERT INTO lww_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","P̃isi na naga mial laa pa sane, kirawal yaru tai teke e kiena yum̃aena e yum̃a na warpoloen kururu varu na takis. Yaru nene naga Livae, narina ne Alpeas. Ana Yesu pion pania, pisape “Oimi otavevenu.” Ana veraga ga Livae sum̃alu, taveve Yesu. ");
INSERT INTO lww_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Siraunia, Yesu pa kinana e yum̃a m̃ana Livae, ana e pogos nene, li nawarpoloen m̃ena takis la moki, amio p̃arm̃arera tap̃ena la, nap̃a apimi atotano veraga amio Yesu amio kiena nalogena lala, komin e legiena nene, yeririna kar la ne nap̃a atavevelili m̃a Yesu. ");
INSERT INTO lww_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ana navianena navisaluaena la p̃asia, nap̃a la ape le Varasi lala, apisu nap̃a Yesu teke veraga amio yaru la ne sanene, apiun tan nalogena lala, apisape “?Komin ya ne kiamiu navianena kinan ke veraga amio p̃arm̃arera la sa nene?” ");
INSERT INTO lww_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ana Yesu mloge visena nene, pisatam̃e la, pisape “Yaru la nap̃a yepela poga ga la pe sinelan re asape ava puna ne yaru nakilaruruen maiena la poli, ana la ga nap̃a amai, la na sinelan pap̃isi. In na pe nepimin re nap̃a nevio yaru la nap̃a apisa ke asape amesmes p̃isi rui e marana ne Ntewa vena ataveve inu, peraga, in na nepimin li viowa la sane la nini.” ");
INSERT INTO lww_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ana e pogos nene, nalogena kiena ne Yoane Nakeena amio le Varasi lala ap̃uar ke p̃elaga namonsilena nakilaen lotuena van Ntewa, ana yeririna la apim pu Yesu, apiun tania, apisape “?E, sanape ne nap̃a nalogena kiena ne Yoane la amonsilu pe nakilaen leniena, a nalogena sa le Varasi m̃ena lala, akila ke maran taaga, ana komin ya ne kiom̃a nalogena lala pe akila re poli?” ");
INSERT INTO lww_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ana Yesu pisatam̃e la, pisayu naga amio kiena nalogena lala, sane la akekara pap̃isi pogos nap̃a naga sike amio la, ana p̃isi na sinela viowa pogos nap̃a sa naga ure matan la, ana pisape “?Pogos nap̃a yaru natalopa-ena sike e p̃ap̃agena amio kiena erau lala wa, asitom ke asape lala monar aligan kinanena na p̃ap̃agena? Peraga. ");
INSERT INTO lww_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ana siraunia, visae pogos tai nasinekar kiena ne yaru nene lap̃asia aimi aurelua naga vetan kiena erau lala, e pogos nene narui kiena erau la nene akilia aligan kinanena, komin nap̃a la sinela piowagan manene naga.” ");
INSERT INTO lww_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","P̃elaga na monsilena nene, naga p̃elaga marua tai na lotena kiena ne le Yu lala, ana Yesu sinenan pisape kila meraravan van la sape p̃elaga marua la ne sanene, la tap̃atete yakol si amio suri viu la nap̃a naga pian lan ke ne. Ana pisa p̃akaiwa tai e lepas nene pan la, pisape “Tap̃atete tela kinakina kulmrae tai nap̃a pe urviu ana tesuluwo ruru pulus nap̃a teke e kulsota marua nene, komin kulmrae viu nene kilia urewowa kulsota nene komp̃as, p̃isi na pulus naga kilia vim ve keviu laa sane. ");
INSERT INTO lww_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ana kuruta na munena nap̃a sirpup pava ke ga wa, tap̃atete tetaron vito e kulus nen nane nap̃a pe urmarua, nap̃a ataron kuruta na munena pito ea yam moki rui. Ana visae tekila ve sanene, yoko kuruta nap̃ani lapa, kila kulus mapoa, kuruta namunena naga taroi, a kana pias nena piowa nena ga. Ana kuruta viu, monar tetaron va e kulus nen nane nap̃a pe urviu, m̃arera ruru po, ana tekilia teligan ruru mom̃a yam ve piavi.” ");
INSERT INTO lww_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ana e legiena tap̃ena si tai, nap̃a pe Legiena Wa, Yesu amio kiena nalogena lala amial apano, ana kiela mrapa naga pa kom lokove na kona lala. La amial m̃a sanene, pano-o kiena nalogena la viso kari la, ana apae plan kona lap̃asia akania. ");
INSERT INTO lww_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Lala akila ke sanene, le Varasi la p̃asia asum̃a e nap̃ane, nap̃a akirawal ke Yesu lala, apisa pa Yesu, apisape “!Ei, okira! Kiom̃a nalogena la akila ke sanene, la pe pon re akila sanene e Legiena Wa poli, sa ve sanene la akilaro ke kieta navisaluaena ne.” ");
INSERT INTO lww_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ana Yesu pisatam̃e la, pisape “?Pona pe amiu apuloli re e Visena Wa pogos tai poli yo, nap̃a pisayu sur la nap̃a P̃arin Sup̃e Keviu Tepet kila nanua sumo? !Amiu akilia ruru pa rui! Naga amio kiena yaru lala viso kar la pap̃isi, ");
INSERT INTO lww_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","naga pa loyum̃a e lele wa kiena ne Ntewa, mla kilaparavi wa nap̃a navisaluaena pisape yar wa ga lala akilia akania, p̃isi na Tepet la akania. Ana Apieta, nap̃a pe p̃arin yaru wa e pog nene, naga tam̃an ga pan la. ");
INSERT INTO lww_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“Nevisa van amiu, sane kieta navisaluaena lala pe pe na m̃areran kare itaen re si poli. Ve sanene na, Legiena Wa naga pe pe na kila kareen re si malena kiena yeririna la poli, ana pe naiila itaena. ");
INSERT INTO lww_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ana Narina ne Yeririna nap̃a pe sup̃en sur punu ga, naga ke narui pe sup̃en m̃ena Legiena Wa, naga ga kilia visa ya nap̃a tekilia teyum̃aen e Legiena Wa, a nap̃a ve teyum̃aen re.” ");
INSERT INTO lww_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ana e Legiena Wa si tai na, Yesu naga pa si e yum̃a na lotuena, ana e pogos nene, yar tai naga m̃eke loyum̃a nap̃a limana tai pulu. ");
INSERT INTO lww_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ana le Varasi lap̃asa nap̃a sinela kar ke pa Yesu rui, asike lavisin naga e pogos nene, la asape apisuar ruruli ke naga, vena alual li p̃elaga viowa p̃asia e naga, ana sinelan asape avisuli m̃ena yoko Yesu kila ruru lima ulu nene e Legiena Wa nene pona ve kila re. ");
INSERT INTO lww_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ana Yesu pisa pan yar nap̃ane, pisape “Osum̃alu, ovam metava e nini wa,” ");
INSERT INTO lww_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ana naga piun tan la nap̃a asike ne, pisape “?E, kieta navisaluaena pisa ke sape tekilia teyum̃aen yara la ne e Legiena Wa lala? ?Pisa ke sape tekilia teyum̃aen sur la nap̃a po, pona sur la nap̃a piowa? ?Po pisa ke sape tekilia tetamalia yaru, po towemom̃aria?” Ana la nene pe apisa re si sur tai poli. ");
INSERT INTO lww_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ana Yesu kira pisuveve la, pisu marala la m̃arera ga sike na, ana naga mloge piowa manene pap̃isi vanonia, ana sinena kari la. Ana naga pis si pan yar nap̃a limana pulu, pisape “Kian mesmesun li lumom̃a wa.” Ana pogos ga nap̃a yar nene kila sanene, limana pimi po sina ga. ");
INSERT INTO lww_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ana le Varasi la amolue, apa mesmes ga apisu yeririna kiena Sup̃e Erot, nap̃a lala akilia alual li mrapa tai na wem̃aren Yesu ve sanape. ");
INSERT INTO lww_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ana Yesu amio kiena nalogena la apetan la, apato si garo pupia lapa, ana yeririna la moki atavevela apatove. Yeririna la nene, lap̃asia amolue e yo tap̃ena lala nae Kalele, ");
INSERT INTO lww_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","a la p̃asia apitom tano e lepas nap̃a Yutea, amio pupia kiela kumali nap̃a Yerusalem, a p̃as apitom e lepas nap̃a Itumea, a p̃as apitom e wii nap̃a Yortan lepas na vano, a p̃as akom ma pupia sive keviu e yo lala nae kumali keviu lua nene, Taea amio Saeton. La punu nene amloge pa visena na sur la nap̃a Yesu miyum̃aen ke rui, ana asape aviminia. ");
INSERT INTO lww_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ana pogos nap̃a la punu ga nene asike e is nen lapa, Yesu pisa pan kiena nalogena la pisape ava avisawo narin waa tai tom̃a ga, komin yaru la nene moki liu, ana naga yepen mavin sape sa p̃isi yar la aim yo kuskus manene la puna. ");
INSERT INTO lww_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Na nene komin naga kila inanena la moki amloge po si rui, ana yar tap̃ena la nap̃a aminana ke wa, la m̃ena moki nap̃a asusunlan ke asape aimi lavisin Yesu, vena atol ga naga. ");
INSERT INTO lww_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ana e pogos nene, visae ninuna viowa la asike e yeririna la p̃asia, visae avisu Yesu, lala monar avatanonia, akinai e mia lana, avion m̃areran, avisave “Ko na ope narina Ntewa.” ");
INSERT INTO lww_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ana Yesu pis m̃arera pan ninuna viowa la nene, pisalup̃ar la pisape yoko ve avisawal re sanene van yaru lala avisave naga ai. ");
INSERT INTO lww_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ana siraunia, Yesu naga pa metava e yo nap̃a pe kunusia, naga pio yeririna lap̃asia pisape aimi puna. ");
INSERT INTO lww_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ana pogos nap̃a apimi, naga mliganar la lualima taaga pa lua, pisa pisape lala ave nalologena, nap̃a kiela yum̃aena na ve sanini: yoko monar la ayal luen ga amio naga, a yoko naga ligan la vena akus Lologena Wo va e yo lala, ");
INSERT INTO lww_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","a yoko puriukawaena na m̃eneplanen yermare sike e la. ");
INSERT INTO lww_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ana kia kiena ne nalologena ne lala sanini: Saemon, nap̃a Yesu sikiapu si ki viu tai Pita, ");
INSERT INTO lww_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","a Semes, nap̃a narina ne Sepeti, a Yoane nap̃a wenla ne Semes nene, nap̃a Yesu sikiapu lalua nene rui, asape Ponases, nap̃a kana kinasia pisape la lua nene ape polilu nena ga, komin la lua nene, pulgola apismolue lue ga, ");
INSERT INTO lww_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","a Antru, a Pilip, a P̃atalomiu, a Matiu, a Tom̃as, a Semes nap̃a narina Alpeas, a Tateas, a Saemon, nap̃a kila politik pan le Rom lala, ");
INSERT INTO lww_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","amio Sutas nae Kariot, nap̃a siraunia pielua Yesu. ");
INSERT INTO lww_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ana siraunia, Yesu p̃asup̃e si um̃a, pupia p̃ina la apim si puna, ana Yesu amio kiena nalogena la amiyum̃aen la m̃a pano-o pe aparurula re nena ga, akinana re poli. ");
INSERT INTO lww_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ana la nap̃a e mratava puna ne Yesu amloge nap̃a naga miyum̃ae manene la pa sanene, amloge m̃ena yar tap̃ena la apisayu ke naga, apisape “!Yar nene kilalu pa p̃arina rui!” ana anena amio wenla lala, apano asape aurelua naga vetan la. ");
INSERT INTO lww_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ana e pogos nene, navianena na visaluaena lap̃asia amligan ma Yerusalem apitomi e yo nene, la m̃ena apisayu ke Yesu pan yeririna lala, asape “Yaru nene, sup̃e kiena yermare la nap̃a Pelsepel, naga pa m̃eke e rui,” ana apisa m̃ena, asape “Yar nene, naga m̃ena pile plan ke ga yermare lala e puriukawaena nap̃a Pelsepel tam̃an pania.” ");
INSERT INTO lww_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ana Yesu pio la apimi lavis puna, pisi pan la e p̃akaiwa, pisa sape “?Sanape, amiu asitom ke asape Yermare naga kilia m̃enelua sina Yermare? !Naga tap̃atete nena ve sa nene! ");
INSERT INTO lww_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Visae sup̃e tai, kiena yeririna la aureure, sane komp̃as la na akawela ke amio lap̃as, yum̃aena kiena sup̃e nene tap̃atete ga sum̃alu. ");
INSERT INTO lww_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","A visae um̃a tai, la aureure nap̃a la p̃asia asape am̃ene plan lala p̃asia, yoko yeririna la nene tap̃atete asu ruru pogos tai. ");
INSERT INTO lww_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ana sa m̃ena nene, sa yermare kiena Yermare Lego, la p̃asia asum̃alu asape akilali nap̃a am̃ene plan lala p̃asia, nanene kana kinasia sane nasup̃enena kiena Yermare tap̃atete sum̃al m̃arera, kiena puriukawaena naga p̃isi. !Ana peraga, yermare m̃arera ke ga wa! ");
INSERT INTO lww_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kam na apisu ke ne, visae yaru tai sinenan ke pisape va loyum̃a m̃ana ne yaru m̃arera tai vena vinaun kiena sur lala, naga monar war kilika viar ke ne yaru m̃arera nene sumo wa, p̃isi na kilia war plan kiena suria. Ana nekila ke sanene pan yaru m̃arera nene Yermare. ");
INSERT INTO lww_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Lelaga nepisa ke pan amiu, mlamulena viowa kiena yeririna lala, amio visena viowa la nap̃a apisa ke nene, Ntewa kilia viewo la vanonia, ");
INSERT INTO lww_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ana yar nap̃a visae visanena kare Ninuna Wa, visa kiena yum̃aena p̃asia Yermare Lego ga naga miyum̃aenia, yar na sa nene tap̃atete tol naviewoena pogos tai, kiena mlamulena viowa nene tolue ga vano-o tap̃atete p̃isi pogos tai.” ");
INSERT INTO lww_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu pisa ruru si visena m̃arera nene pan la komin la nene la ke narui nap̃a apisa ke asape ninuna nap̃a teke e naga pe ninuna viowa ga tai. ");
INSERT INTO lww_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ana anenane Yesu amio wenla la apimi akate e pog nene, asum̃al ga asum̃a vanua, amligan visena pavinia vena naga vitom katen la. ");
INSERT INTO lww_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ana e pogos nene, pupia p̃ina atotano ke lavisin Yesu, ana visena nene pa tol naga, la apisa apisape “!E, anom̃a amio womla lala asike vanua, asape avis kone amio ko wa!” ");
INSERT INTO lww_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A Yesu pisatam̃e la, pisape “?A aneu naga ai? ?A wolai lala ai?” ");
INSERT INTO lww_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ana kira pisuveve la nap̃a ateke lavisinia pisa pan la pisape “!E, apisu ke ne! Aneu, amio wolai lala, la ke nene narui. ");
INSERT INTO lww_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Komin yaru nap̃a miyum̃aen sur nap̃a Ntewa naga sinenania, yar ne sanene naga pe wolai, a pe vineu, a pe aneu p̃a rui.” ");
INSERT INTO lww_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ana e pogos tap̃ena si tai, Yesu pian ke yaru lala e yepas nen lapa nae Kalele. Ana yeririna la moki nap̃a apimi puna e pog nene, kila naga pa metava e narin waa tai nap̃a tom̃a e lapa nene, pa totano metava ea, ana yar la nap̃a asum̃a ga ura. ");
INSERT INTO lww_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ana naga pian la ke e sur la moki e p̃akaiwa, ");
INSERT INTO lww_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","naga pisa pan la, pisape “Ayagoga ruru lia. Yar tai, naga pa peven kona e kana lokove. ");
INSERT INTO lww_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ana pogos nap̃a naga peven kona la pa sanene, kurus la p̃asia kekapil lavisin laa is nen mraplepa. Ana siraunia, manu la apimi atete plan sina. ");
INSERT INTO lww_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","“Ana kurus lap̃asia kekapil e yo nap̃a kilavaru sike vatano. Ana e yo nene pe porotano wo keviu re poli teke metava, ana kila narui akapuru iroro ga, ");
INSERT INTO lww_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ana pogos nap̃a mrae p̃arlar pa metava, yepisusunun sus lala, veraga ga amiyayai komin p̃eligas la pe pito manene re tano poli. ");
INSERT INTO lww_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Ana kurus p̃asia amlolor e yo tai nap̃a sumo pe ate plan ruru re kilika la nap̃a pe nonos e poli, ana p̃isi na kilika nene kapur sina keviu, ana piwo make ga sus nen kona la nap̃ane pano-o amarmare, pe ap̃ar re si mras la poli. ");
INSERT INTO lww_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Ana kurus tap̃ena la amloloru e porotano nap̃a po, akapuru po, pano-o ap̃ar mrasnela lala. La p̃asia ap̃ar mrasnela tol lualima yam telu 30, a lap̃as ap̃ar tol lualima yam orai 60, ana lap̃asia pa laa tol ponotia taaga 100.” ");
INSERT INTO lww_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ana Yesu pisa pan la, pisape “!Amiu punu ga kiligamiu sike na. !Popon sa aloge kilia kiau visena nini!” ");
INSERT INTO lww_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ana siraunia, p̃ina lala apiap̃a tetai, ana Yesu naga taaga ga sike, ana yar la nap̃a asike amio naga amio kiena nalogena lala, apim apiun tania apisape “?Kinas nen p̃akaiwa nini naga sanape? ?Ana komin ya ne ko na okuan ke visena la ne sa nene, ana opian ke m̃ena yaru lala e p̃akaiwa?” ");
INSERT INTO lww_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Ana Yesu pisatam̃e la, pisape “In na nepian la ke e p̃akaiwa la nene, komin la ape p̃arm̃arera la pap̃isi, sa nap̃a akila ke visena kiena Navisawalena Aisea na konua rui pimi pe lelaga, nap̃a pisa ke sape ‘La akirava, akirava m̃a vano-o, amloge, amloge m̃a vano-o, ana tap̃atete avisu kilia suri tai, tap̃atete m̃ena aloge kilia suria. !Visae peraga, pona avilon kiela sitomena la yo rui, pona Ntewa viewo pa kiela mlamulena viowa la yo rui!’ “Vanon sur sanene, inu nepisape lala ape p̃arm̃arera lala, asum̃a perina pap̃isi. Ana amiu ke narui, yoko wo laa van amiu vap̃isi. Navisawanena navesup̃enena kiena ne Ntewa, yoko in na nevisawal ruru merarava wo van amiu. ");
INSERT INTO lww_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“?Ana sanape, amiu pe amloge kilia re kinas nen kona nene poli? ?Ana visae amiu pe asitom kilale re kinas poli, ana sanape yoko aloge kilia p̃akaiwa tap̃ena la nap̃a sa nevisayu van yeririna lala?” ");
INSERT INTO lww_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ana Yesu pisa, pisape “Pogaga, yoko in na nevisayu meraravan kinas nen p̃akaiwa nene van amiu. Kana kinasia naga sa nini: Porotano tap̃ena la nene, la sa nap̃a malena kar la ne kiena yeririna lala. A nap̃a yar nene peven ke kurusia e porotano la nene, naga sa nap̃a apisawal ke visena kiena ne Ntewa pan yeririna lala. ");
INSERT INTO lww_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Porotano m̃arera nap̃a e is nen mraplepa, naga sa nap̃a yar nap̃a pogos nap̃a mloge visena kiena ne Ntewa, ana visena nene pe pa ruru re nena loyum̃a e losinena poli. Ana manu la nene, la sa nap̃a Yermare, nap̃a veraga ga pimi mlalua sina visena kiena ne Ntewa petan los nen yeririna nene. ");
INSERT INTO lww_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Ana porotano nap̃a kilavaru naga sike tano, naga sa nap̃a yar nap̃a mloge visena kiena ne Ntewa, ana verakorena ga kekarania, ana mlavia, ");
INSERT INTO lww_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ana visena nene naga pe towawa ruru re e losinena poli. Ana naga kapuru sa ga narin sus tai nap̃a pe pe p̃eligas ruru re poli nap̃a kila yoko kapuru ve plas ga. Ana pogos nap̃a sa pog m̃arera la imi pona yar la asape avevela komin amlelaga ke e visena kiena ne Ntewa, ana verakorena ga aligan sina ga. ");
INSERT INTO lww_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Ana porotano nap̃a kilika viowa sike ea, naga sa nap̃a yar la amloge visena kiena ne Ntewa, ");
INSERT INTO lww_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ana p̃isi na, lala asitom manene la kiela malena, a sitomena na waren sur ve moki vim kila kotalia la, ana lala sinelan manene la sur wo lala na yomarava nini. P̃elaga la nene pimi sane kilika viowa, piwo Lologena Wo nene kila sane ve war re si mrasa e malena kiena yeririna la nene. ");
INSERT INTO lww_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Ana porotano wo nene, naga sa nap̃a yeririna la nap̃a amloge visena kiena ne Ntewa, amloge kilia, akekarania, amlararia e losinela, ana siraunia ap̃ar mras nen Lologena Wo nene e kiela malena, la p̃asia ap̃aria tol lualima yam telu 30, p̃as tol lualima yam orai 60, p̃as tol ponotia taaga 100. “Kinas na p̃akaiwa na kona maro ga e nene.” ");
INSERT INTO lww_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ana Yesu pisa sina pan la, pisape “Ita yeririna lala, visae tesilan kap vivaga, yoko ve telawan re to vatanon paket. Peraga, monar tetelan to metava e kana lele nena vena tegoli punu yo. ");
INSERT INTO lww_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sanene, nanagane nasup̃enena kiena ne Ntewa sane kapi te ga nene, nap̃a nanagane na molmolue ke e ita narui, vena tegoli sur punu ga, ana sur lala punu ga nap̃a apisawo sike na, a visena wan lala, monar akakate e yomerarava. ");
INSERT INTO lww_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","!Ana amiu punu ga kiligamiu sike na, popon sa aloge kilia kiau visena nini!” ");
INSERT INTO lww_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ana Yesu naga pis si pan la, pisape “Amiu monar ayagogan ruru kiau visena, asitom ruru la lia. Yaru nap̃a mloge, ana pe taveve re poli, naga yoko tap̃atete loge kilia ruru si narui. Ana yar nap̃a mlogear kiau visena la, naga kilia loge kilia ruru m̃ena kiau navianena la moki nap̃a sa imi si sirau. ");
INSERT INTO lww_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ana yar nap̃a kiena suri moki pa rui, yoko war ve moki laa va laa sane, ana yar nap̃a pe kiena sur re poli, p̃isi na naga kilalu narin sur nap̃a mla ke.” ");
INSERT INTO lww_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ana Yesu pisa ke sina ga pisape “Nasup̃enena kiena ne Ntewa naga sa nap̃a kona nap̃a yar tai naga peven ke e kiena porotano. ");
INSERT INTO lww_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pogos nap̃a peven pae na, pe kila re si sur tai e kurus nene poli. Naga mom̃a momalio ga, tavilo, momalio, tavilo, sum̃alu, salue ga nene yemalo a legiena, ana kurus nen sur nene, naga ga sus plamolue, kapuru ke sanene. Kapuru m̃a pano-o, ana yar nene naga kiliar re kurus nen sur nene kapur ke sanape poli. ");
INSERT INTO lww_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yar nene kilia re sur tai poli, pano-o korowas la kian pa perina piavi re na p̃ar vinasia, p̃isi na tau. ");
INSERT INTO lww_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ana pogos nap̃a kinas la menmene ruru po, yar nene siar si miyum̃ae narui, p̃ar kiena playu pa te plan mrasnena lala. “Ana navesup̃enena kiena ne Ntewa naga kapur tekak ga sanene, telivi ke e yomarava wetelu nagane, ana e legiena tai yoko tekirawal pupia mrasnena vam metava.” ");
INSERT INTO lww_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ana Yesu pisa sina, pisape “P̃elaga navesup̃enena kiena ne Ntewa naga pe tap̃ena ga sike na, naga m̃arera pap̃isi nap̃a nekilia nekirawal si p̃akaiwa tai nap̃a vena visaen sape naga sanape. ");
INSERT INTO lww_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sa nap̃a kurus nen purpa tai yo, nap̃a naga tekaki ga miyuve kurus nen sur tap̃ena la nap̃a temapila la ke e kata lokove lala, naga tekaki na tekaki. ");
INSERT INTO lww_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ana pogos nap̃a kapuru keviu, purp̃esia naga pimi keviu miyuve make ga kinanena tap̃ena la nap̃a sike e kata lokove lala. Ana pupia korowas la pap̃isi, nap̃a manu la akilia ava ase ea, vanon kana wamal po, yomanin ea.” ");
INSERT INTO lww_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ana Yesu pian ke yeririna la e Lologena Wo e p̃akaiwa la moki sanene, nap̃a sane torokin yoko akilia aloge kilia. ");
INSERT INTO lww_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Visena la punu ga nap̃a pian lania, p̃akaiwa teke loyum̃a, ana pogos nap̃a naga ga sike amio kiena nalogena la, e pogos nene narui na naga sun pisa meraravan kinas nen p̃akaiwa la nene pan la. ");
INSERT INTO lww_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ana Yesu sum̃a ke e waa nap̃a naga totano e pian yeririna lala, ana ko yepekilavi, naga pisa pan kiena nalogena la, pisape “Ei, ita tokusro teva komp̃as nen lapa vano.” ");
INSERT INTO lww_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ana kiena nalogena la amligan yeririna la asike na, apa e waa nap̃a Yesu naga teke pa e rui apano. Ana narin waa si lap̃asia asiraun la. ");
INSERT INTO lww_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Narin waa la nene apato m̃a pano-o, pupia lagi tai naga molue, miyu lapa nap̃ane kila pupia sive naga kekela ke e waa, kila na pulen ke e sive narui, lavisi talilu. ");
INSERT INTO lww_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ana Yesu naga miyulugan ke e yulugana tai e p̃eren waa, monon momalio m̃aga. P̃isi na lala apa apiop̃egeia, ana apisa pania, asape “!Navianena! ?E, sanape pe ositom̃al ita re na lavis tetalilu ne po?” ");
INSERT INTO lww_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ana Yesu sum̃alu, pis m̃arera pan lagi, a pis m̃ena pan pupia sive la nene, pisape “!Amiu ava ruru amiu!” P̃isi na lagi molue re si poli, yo mare ga m̃eke na. ");
INSERT INTO lww_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ana Yesu pisa pan la, pisape “?Komin ya ne amiu amarau sanene? ?Amiu pe amlelaga re e in poli yo?” ");
INSERT INTO lww_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","P̃isi na la amarau pap̃isi, apiuyun ke sina ga petan la, sape “?Yar a nene? Aulai, naga pis ga sanene na, lagi amio sive amlogear veraga ga.” ");
INSERT INTO lww_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ana Yesu amio kiena nalogena lala apimi ap̃arpo yo e komp̃as nen pupia lapa nene, ap̃arpo lologia yo nap̃a Kerasa, nap̃a lap̃as apio ke asape Katara pona Kerkasa. ");
INSERT INTO lww_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ana la apa ura e yo nene, ana e yo nene puluve na yar mare la asike ea, ana yar tai nap̃a ninuna viowa teke e naga, naga sike e lotap nene, sa nap̃a pe m̃ana um̃a. Ana pogos nap̃a Yesu pula tano petan waa, veraga ga yar nene molue e lotap, kiriri pitomi puna. ");
INSERT INTO lww_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yaru nene marana ka pap̃isi, yar la akilayon asape aviaria pano-o akilapule ga yonia. ");
INSERT INTO lww_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yam moki rui apiar lana amio limana e sen pona kilika, apiviaria panon laki ana naga pureroro ga sen la nene amio laki lala, pano-o pe yar re si tai poli nap̃a puryuna kawa torokin kila yar nene imi mom̃au. ");
INSERT INTO lww_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ana kolemalo punu ga amio legiena, naga sum̃a mialialor ke e lotap a metava m̃ena e kunus lala, naga monon m̃am̃aul ke, a pilavilan wowa ke yepena lala e kilavaru. ");
INSERT INTO lww_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ana yar nap̃ane, pogos nap̃a naga sum̃a ke perinan yo nap̃a Yesu la apim ura ea wa, naga m̃al pa Yesu rui, kiriri pitomi tano puna, patanonia, kinai puna. ");
INSERT INTO lww_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ana Yesu pisa, pisape “!Ninuna viowa, ovetan yar nam̃a, oure matan naga nanagane!” Ana ninuna viowa mlokai m̃arera pania, pisape “A ko, Yesu, narina ne Ntewa Mali, kiom̃a ya ne teke e inu? !In na nepiun tan ko, e kia kiena ne Ntewa, sane yoko ko na ve ola re nakoaena van inu.” ");
INSERT INTO lww_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ana Yesu piun tania, pisape “?Ko na kiom̃a kia ai?” Ana ninuna viowa pisatam̃ea, pisape “In sa kia Yaru Moki na Mara, komin imimi moki liu.” ");
INSERT INTO lww_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ana ninuna viowa nap̃ane piuyun m̃areran ke petan Yesu sape ve m̃ene plan la re vetan m̃ala nene. ");
INSERT INTO lww_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ana e yepas nen kunus nae yo nene, pupia p̃egas nen nompui, la asun akolkol m̃a e porotano, nap̃a tol sane manu lua 2000, ");
INSERT INTO lww_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","p̃isi na yermare la nap̃ane atagi, apiuyun m̃arera petan Yesu, asape “Awis, oligan imimi meva e nompui la nene, otam̃an imimi meva mese e losinela.” ");
INSERT INTO lww_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ana Yesu tam̃an pan la, pisape “Pogaga, amiu avano.” Ana lala amolue petan yar nap̃ane, apa e los nen nompui la nap̃ane. Ana veraga ga, nompui la nene akiriri, apito tano e yeparpas nen kunus nene, amloloru apito tano e pupia lapa nap̃ani, ana la amunm̃ar lan wii na amarmare. ");
INSERT INTO lww_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ana yaru navisuaren nompui la apureure, apito um̃a, apisawal sur nene, a lala apisawal m̃ena e yo tap̃ena la nap̃a sike ne, kila narui na yeririna la moki nap̃a apavin asape avisulia. ");
INSERT INTO lww_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ana pogos nap̃a la apavini, apisu Yesu naga sike amio yaru nap̃a sumo ninuna viowa la ase naga, mian pa kulmrae rui, pa ruru pa rui pe maran ka re si poli. La apisu naga pimi po si sanene rui, amaraunia. ");
INSERT INTO lww_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ana la nap̃a asup̃esania apisu ke sur la punu ga nene, la asunyu pan yeririna tap̃ena la nap̃a apam marea, la apisayu sur la nap̃a Yesu miyum̃aen pan yar nene, a sanapen nompui la nap̃a amloloru apito e wii. ");
INSERT INTO lww_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ana la apisu sane piowa ga, am̃areran ke pan Yesu asape naga monar ure vetan kiela yo. ");
INSERT INTO lww_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ana p̃isi na Yesu la apito si tano e kiela waa, pogos nap̃a Yesu pa ke metava e waa, yar nap̃a sumo ne, naga pitomi piun m̃areran ke pan Yesu, pisape “Awis Sup̃e, in na sineun nesape ko otam̃ania ita la nini!” ");
INSERT INTO lww_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ana Yesu pe tam̃an re poli, pisa pania, pisape “Peraga, popon sa ova si um̃a, ovisayu van la nap̃a na mratava pun ko amio kiom̃a erau lala, ovisayu van la sanape nap̃a Ntewa sinena miye ko pap̃isi, ana kila po na po sanene pan ko.” ");
INSERT INTO lww_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ana yaru nap̃ane p̃asup̃e sina, pa e yo punu ga e lap̃as nap̃a puna, nap̃a apio ke asape Pulkumali Lualima, nap̃a yaru la nap̃a Le Yu lala pe asu re e poli, ana pisawal ke yum̃aena wo nap̃a Yesu miyum̃aen pania. Ana lala nap̃a amiyagogon kiena sunena nene, lala amilan pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ana Yesu la akome waa, akusro sina komp̃as nen lapa nap̃a narui, ana pogos nap̃a Yesu pula pa ura sane na, pupia p̃ina na yeririna la apim akovivi sina asike. ");
INSERT INTO lww_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ana yaru keviu tai na yum̃a na lotena nae yo nene, kiena kia Saeras, naga pimin sape visu Yesu, pimi lavisinia, kinai tano puna. ");
INSERT INTO lww_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Naga tagi pania, piun tania, pisape “Naruu nap̃a sira, naga mai na mai, ana nanagane na pona naga mare pa yo rui. Ana nepiun ke tan ko vena ko oim, oligan lumom̃a te naga, vena loge wo sina, mal ve piavi re laa sane wa.” ");
INSERT INTO lww_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ana Yesu p̃arlar sum̃alu, amio yar nap̃ane apavin, ana yaru la moki e p̃ina la nene, la m̃ena ataveve la, nap̃a amigagar la ga e yepas nena ne Yesu apano. ");
INSERT INTO lww_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ana lala yaru tai nap̃a apa ataveve ke Yesu sanene, naga sira, nap̃a inanena na kupario teke e naga legiena punu ga, tol kas lualima taaga pa lua rui. ");
INSERT INTO lww_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ana sira nene, naga pul yaru na kilaruruen inanena la pano-o kiena kilavaru la p̃isi, akilayon naga pano-o pap̃isi, ana naga mloge maran taaga sike, inanena nene naga pimi keviu lue ga legiena punu ga. ");
INSERT INTO lww_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Naga mloge yam moki rui nap̃a yaru la apisayu ke Yesu, ana kiena sitomena tai na, sitom ke sape “Visae netol ga m̃ana kulkota, yoko kiau inanena naga p̃isi.” Sanene narui na pa tapolou likan yeririna la nap̃ane, naga pimlilue lavis varaun m̃asina ne Yesu, kian limana sane na, tol ga mrapogos nen kulkota m̃ana ne Yesu. ");
INSERT INTO lww_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pogos nap̃a naga tol kulkota m̃ana Yesu sane na, veraga ga e aora nene kiena kuruta nap̃ane p̃isi, ana naga mnunun lup̃aria e naga sane kiena inanena naga kovio petan rui. ");
INSERT INTO lww_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","A Yesu m̃ena mnunun lup̃ar sur tai, sane puriuna tai kovio petania, ana naga pilon veraga ga likan yeririna la nap̃ane, piunia pisape “?E, ane tol ga m̃a kulkota nanagane?” ");
INSERT INTO lww_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ana kiena nalogena la apisa-tam̃ea, asape “?Ko na opiun osape ane tol ko ga nagane, sanape ne, ko pe opisu re yeririna la moki manene na amigar la akovivi ko ke ne po?” ");
INSERT INTO lww_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ana naga sum̃a kirawele m̃aga sape kirawal li ane tol naga. ");
INSERT INTO lww_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ana sira nap̃ane kilia pa rui, sape naga, naga marau pap̃isi, sinena kurkur na kurkur, p̃isi na pimi puna Yesu, kinai tano e mialana, pisawal sur punu ga. ");
INSERT INTO lww_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ana Yesu pisa pania, pisape “Auia, nalelagaena ga kiom̃a e inu kila ko omloge si po narui. Kiom̃a inanena naga kovio nenaga. Sum̃arena kiena ne Ntewa sike amio ko, owasup̃e ko sina ga oto um̃a.” ");
INSERT INTO lww_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ana pogos nap̃a Yesu pis ke pan sira nap̃ane wa, visena tai kom ma um̃a m̃ana ne Saeras pitomi, pisawal pania sape “Narum̃a sira nap̃ane naga mare rui. Yoko ve oure re si pupia navianena nene vavini, ve okila kare re naga.” ");
INSERT INTO lww_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ana Yesu mloge m̃a visena nene, pisa pan Saeras, pisape “Ve sinem̃a viowa re, olelaga ga m̃arera e Ntewa.” ");
INSERT INTO lww_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ana Yesu pisalup̃ar yeririna la punu ga sape la asum̃ara ga ve ataveve la re avavini, naga pure ga la telu Pita, a Semes amio wenla nap̃a Yoane apavini. ");
INSERT INTO lww_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pogos nap̃a apa lavisin um̃a m̃ana ne yar keviu nap̃ane, apisu yar la sinela piowagan ke nin sira nene rui, la asike atagin ke, amlolokain ke. ");
INSERT INTO lww_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ana Yesu pa loyum̃a, pisa pan yaru la nene, pisape “?Sanape ne amiu amlolokai keviu ke, atagi ke sanene? Sira nene naga mare re poli, naga momalio ga ne.” ");
INSERT INTO lww_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ana la apitale viowa ga pania. Ana Yesu pisa pan la apa vanua, purear ga anenane sira nene amio arimana, a kiena nalogena la telu nap̃ane apa e lele nap̃a tas nen narin sira nene m̃eke ea. ");
INSERT INTO lww_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ana Yesu pa mlilu tarar limana, pis pania kome kiela visena, pisape “Talita kum,” kinas nen visena nene pisa ke sape “Kiau narin sira, ko osum̃alu lia.” ");
INSERT INTO lww_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ana veraga ga e aora nene, narin sira nene nap̃a kiena kas tol lualima taaga pa lua 12, naga sum̃alu, mial. Ana pogos nap̃a la apisu sur nene, amilan na pano-o kiela sitomena plas ga. ");
INSERT INTO lww_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ana Yesu pisa pan la pisape ala re kinanena tai vania, a pisa m̃ena pan la pisape yeririna tap̃ena la ve aloge re sur nene. ");
INSERT INTO lww_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ana Yesu molue e yo nene, p̃asup̃e sina ga pimi kiena, amio kiena nalogena la. ");
INSERT INTO lww_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ana e Legiena Wa, naga pa amio yaru lala nae kiena yo nene e loyum̃a e kiela yum̃a na lotena, ana sum̃a pian la ke. Ana pogos nap̃a la amloge amilan kiena visena la pano-o pap̃isi. Ana la apisa apisape “!Aulai! ?Yaru nene naga p̃ar sur la nene pe? ?Naga tol namanmaruaena nene sanape? A naga kila ke kile la nene sanape ne? ");
INSERT INTO lww_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ita tekilia ke yaru nene rui. Naga yaru na yum̃aenen ga yum̃a, naga pe narina ne sira nap̃a Maria, a la nene, Semes, a Yoses, a Suta, a Saemon, naga pe wenla ne la nene. A vinena lala, la ga nap̃a asike amio ita ne.” Ana sinela karia, pe sinelan re nena naga. ");
INSERT INTO lww_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ana Yesu pisa pan la, pisape “Yaru nap̃a pe navisawalena, yaru tap̃ena lala akilia avatanon naga, ana yaru nae kiena yo, amio m̃ena namratava puna, la ga nene tap̃atete avatanon naga.” ");
INSERT INTO lww_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ana e kiena yo wawa nene, Yesu tap̃atete kila kile la ea, ana naga mligan ga limana e yaru la lua la ga nap̃a aminana, amloge si po. ");
INSERT INTO lww_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ana Yesu sinen pula mila pap̃isi komin yaru la nae kiena yo wawa nap̃a pe amlelaga re e naga poli. P̃isi na naga petan kiena yo, mial pa e pulkumali tap̃ena lala ana pian ke yeririna lala. ");
INSERT INTO lww_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ana Yesu pio kiena lualima taaga pa lua nene, pis ruru pan la, mla nam̃areraena pan la vena akilia ataulu ninuna viowa lala, a siraunia mligan plan la peve lua apano. ");
INSERT INTO lww_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Visena wo la nene nap̃a naga pisa pan la sumon nap̃a lala apano, naga sanini, pisape “E lepas na kiamiu mrapa, yoko amiu ve awar re sur lap̃as amio amiu, ana kiamiu plasgai ga alararia avano. Yoko amiu ve awar re kamiu kinanena p̃asia, pona karo lala, pona varu. ");
INSERT INTO lww_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Amiu akilia ayen kiamiu kulus nen lamiu lala, a ve awar re m̃amiu kulmrae tap̃ena lap̃asia, m̃amiu kulmrae taaga nane amiyenar ke ne sa ayal avano.” ");
INSERT INTO lww_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ana Yesu pisa m̃ena ga, pisape “Pog nap̃a sa la awere amiu ava loyum̃a m̃ala, ana amiu monar akekaran ga nasuen amio na mratava nene, vano tol pogos nap̃a sa amiu avatan si pulkumali nap̃ane. ");
INSERT INTO lww_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ana visae pulkumali tai, yeririna lap̃as yepela mavin were amiuena ava m̃ala um̃a lala pona yepela mavin loge amiuena, amiu aligan ruru kiela yo nene m̃eke na, ana pogos nap̃a sa amolue e yo nene, monar atanvan puluyavi nae yo nene nap̃a sike e lamiu, sane kile tai, pona kiamiu visena m̃arera tai pan la, sane yoko lala akus nakoaena tai nap̃a mesmesun ga kiela p̃elaga viowa nene.” ");
INSERT INTO lww_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","P̃isi na kiena nalogena lala apa amlologon pan yeririna lala asape monar avilopu la, ");
INSERT INTO lww_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ana la am̃ene plan ninuna viowa la moki e yeririna lala, ataron m̃ena narin wel na mras nen olip e p̃arin nainanena la moki, sane kile na navisa ruruena kiena ne Ntewa, ana la amloge po sina. ");
INSERT INTO lww_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ana e pogos nene, P̃arin Sup̃e Erot naga m̃ena mlogeli m̃a sur la nap̃a Yesu miyum̃aenia, komin kia kiena Yesu, apisawal ke pa rui e yo punu ga, a yeririna la punu ga akilia pa rui. Yar la p̃asia apisa ke Yesu, asape “Naga na, pe Yoane Nakeena si ne, nap̃a naga mal sina e marena; sur ne na nene kila naga puriuna kawan nakilaen kile la sanene.” ");
INSERT INTO lww_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","La p̃asia apisa ke asape “Naga na yer marua Elaisa na konua rui,” a la p̃asia apisa ke asape “Naga navisawalena tai ne sa nap̃a yermarua navisawalena lala nakonua manene la rui.” ");
INSERT INTO lww_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ana pogos nap̃a Sup̃e Erot mloge sur la nap̃a Yesu naga kila ke ne, ana naga pisa sape “?Yaru nene, pona Yoane Nakeena ke sina ga ne. Inu netero pa p̃arina pa rui, ana nanagane naga mali sina e marena yo?” ");
INSERT INTO lww_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ana Sup̃e Erot pisa sanene vanon nap̃a naga m̃emar Yoane Nakeena mare nanua rui, ana naga marau pap̃isi. Ana marena kiena ne Yoane Nakeena kana suniena nena sanini: Wenla Sup̃e Erot nene, naga kiena kia Pilip, nap̃a lalua arimala taaga a anela lua. Ana sumo, Pilip nene talopa amio sira tai, kiena kia Erotias. Ana siraunia, Sup̃e Erot pa p̃erelua lein sira nene pe wona. Ana e pogos nene Yoane pis pa Sup̃e Erot, pisape “Sur mesmesu re nene poli, nap̃a ko opurelua sira nene, komin naga pe wona ne womla.” Ana Erotias pe kekaran re nena visena kiena ne Yoane nene, naga sinena karia, ana Sup̃e Erot mligan kiena yeririna la p̃asia apa atararia, apiari naga amligan pa e yum̃a nakoaena. ");
INSERT INTO lww_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ana Erotias sinenan ke sape monar wem̃ar Yoane, ana naga kila p̃ele ga, ");
INSERT INTO lww_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","komin Erot maraun wemom̃arena. Naga maraunia komin naga kilia ruruia sane Yoane naga pe yar mesmes tai a pe yar wa, naga puar ruru ga sum̃a ga. Yam la moki naga mligan visenan Yoane pa puna lalua asun, naga kekaran visena kiena ne Yoane la pap̃isi, ana yam punu ga, visena la nene miyur ke naga, kila narui na naga kiena sitomena peve lua ke narui. ");
INSERT INTO lww_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pe piavi re poli na, Erotias m̃al kiena mrapa tai. Nane e pogos nap̃a la akila p̃ap̃agena nasitom̃alen legiena nap̃a Sup̃e Erot paeme ea, ana Erot naga kila kinanena kana kiena yarkeviu lala, amio nasumonena na yum̃aena kiena, a yerkawa tap̃ena lala nae yo nap̃a Kalele. ");
INSERT INTO lww_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","E pogos na p̃ap̃agena nene, lom̃earu kiena ne Erotias naga polu e marala, ana Sup̃e Erot la akekaran kiena wolena pap̃isi, naga pisaaria m̃arera pania, pisape “Suri ya nap̃a visae oviun tan inu, nekilia netam̃an ga van ko, va tol komp̃as nen kiau sur make ga lala.” ");
INSERT INTO lww_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","P̃isi na sira nap̃a pa vanua, piun petan anena nap̃a Erotias, pisape “?Auia, yoko neviun yar ne tania?” Ana anena pisa pania pisape “Ovisa ga vania ovisave, naga monar kus ga p̃arina ne Yoane Nakeena van ita.” ");
INSERT INTO lww_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ana sira nap̃ani miroro si pa loyum̃a, pisa iroron ga pa Erot, pisape “In na sineun nesape okus ga p̃arina ne Yoane Nakeena m̃ene pialo tai imi ga nanagane e nini.” ");
INSERT INTO lww_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ana visena nene kila Sup̃e Erot mloge piowa, pe sinenan re sape kilaro kiena navisaarena nap̃a pisaar m̃arera rui e maran kiena erau lala, ");
INSERT INTO lww_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","p̃isi na veraga ga e m̃a nena ga e pogos nene, naga miila kiena yar na mara tai pa pisa, pisape akus p̃arina Yoane vano. P̃isi na lala apa e loyum̃a e yum̃a nakoaena nene, atelua kolmekina, ");
INSERT INTO lww_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ana la amligan p̃arina m̃ene pialo tai, akus pimi pan sira m̃ee nap̃ane, ana kus pa pan anena. ");
INSERT INTO lww_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ana siraunia, pogos nap̃a nalogena kiena ne Yoane la amloge suri nene, la apimi akus tasnena, apa amligan e lotap. Ana suniena kiena ne Yoane Nakeena maro ga e nene, ana pogos nap̃a Erot mloge suniena kiena ne Yesu, kila naga marau pap̃isi, m̃ape Yoane Nakeena nene nap̃a naga m̃emaria, mal sina. ");
INSERT INTO lww_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ana e pogos nene, nalologena la nap̃a Yesu mligan plan la apa amlologo, ap̃asup̃e la si apimi. Ana lala apisayu pa Yesu sur la punu ga nap̃a amiyum̃aen pan yeririna lala, a sanape nap̃a apian la. ");
INSERT INTO lww_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ana yar la moki nap̃a asum̃a apimi ke pu Yesu, p̃isi na apano, ana p̃isi na tap̃ena si la apimi, p̃isi na apano, salue ga nene, Yesu la pe apa ruru la re nenaga, pe aora re tai nap̃a la akilia ala narin kinanena tai. Ana Yesu pisa pan la, pisape “Aulai, ita, tevetanli la e yo nini wa. Teva takale yo tai nap̃a naga yo m̃ano, akilia avaruru amiu ea.” ");
INSERT INTO lww_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","P̃isi na la apa akus waa tai, asape ava akale yo tai lepas nen lapa nap̃a pe yar la asu re e poli. ");
INSERT INTO lww_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ana yeririna la moki apisu sane Yesu la apa ke sanene, la m̃ena ga amolue e kiela pulkumali lala, akiriri ataveve la akom ura, apato atolp̃esa yo nene nap̃a la apisu sane waa naga pato ke ea, la asumon Yesu lala. ");
INSERT INTO lww_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ana Yesu pa ura, pogos nap̃a pisu p̃ina na yeririna nap̃a asike pa ura rui, naga sinena mie la pap̃isi, komin naga pisu la sa nap̃a sipsip la nap̃a akuspal mrapa, pe yar re tai nap̃a kilia visuar la, p̃isi na naga pa sun pian la e visena wo la moki. ");
INSERT INTO lww_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ana pogos nap̃a mrae pito tano, nalogena lala apimi puna, apisa asape “E, Sup̃e, yo nini naga pe po re poli, a lavisi m̃ena yemalolo narui. ");
INSERT INTO lww_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ana popon ko oligan p̃ina la nene awasup̃e ava m̃ala um̃a pona pulkumali lala vena awul kala kinanena la p̃asia.” ");
INSERT INTO lww_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ana Yesu pisatam̃e la, pisape “Toko, popon amiu ga awar kinanena p̃asia van la.” A lala amape Yesu naga pe pisa ruru re poli, ana la apisa asape “!Ke, peraga yo! Pona ko na sinom̃an ke osape imimi mowar pupia kieta varu ana mevato meul kilaparavi torokin lala manu moki nene akania!” ");
INSERT INTO lww_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ana Yesu pitetalia la, pisape “Amiu avato avisulia ap̃ara ke kilaparavi via na sike amio amiu nanagane.” La apato apisu pae na, apam sina ga apisape “Memlarar narin kilaparavi lima ga teke na, amio narin ika nap̃a satin lua ga.” ");
INSERT INTO lww_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ana Yesu pis pan yeririna lala, pisape “Amiu atotano e vilum̃ini wa,” ");
INSERT INTO lww_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ana la atotano e p̃egas lala, p̃egas lap̃asia sane lualima lima 50, ana p̃egas tap̃ena lap̃asia sane ponotia taaga 100. ");
INSERT INTO lww_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ana naga mla narin kilaparavi lima nap̃ane amio narin satin lua nene, kira pa ma e peni, pisa potena pa Ntewa vanonia, p̃isi na kaweroro narin kilaparavi lima nap̃ane kian pa kiena nalogena lala vena avion plan van yeririna lala, pion m̃ena narin ika lua nap̃ane sa ke ga. ");
INSERT INTO lww_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ana la akan m̃a pano-o, mep̃ela la kawa pap̃isi, ");
INSERT INTO lww_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ana kinakinas nen kinanena la nap̃a akanligania, torokin akon si va e karo la tol lualima taaga pa lua 12. ");
INSERT INTO lww_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ana yaru la nap̃a akan kinanena nene, yerm̃ene ga lala, la atol sur sane manu lima. ");
INSERT INTO lww_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ana Yesu pisa pan kiena nalogena lala, pisape “Inu sineun nesape amiu akus kieta waa, asumo akusro pupia lapa nene ava lepas p̃asia e kumali nap̃a Petsaeta, ana in na nesuwa nesum̃a neligan plan ke ne yeririna la nene wa.” ");
INSERT INTO lww_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ana pogos nap̃a naga mligan plan yeririna la nene apa pae na naga pa metava e kunusia vena len. ");
INSERT INTO lww_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pogos nap̃a yemalolo ke narui, waa nap̃ane m̃eke perina pap̃isi, lika e lapa, ana Yesu naga taaga sike ura. ");
INSERT INTO lww_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ana naga kira pisu la na m̃arera pan la na valuanen waa pap̃isi, komin la apane ke pupia lagi, kila kiela waa naga pure malum ga. Pogos nap̃a lavisi yelagi merarava, Yesu pimi pula, mial yau ga metava e wos nen lapa. Suri ne na nene vena naga va p̃esan ura sumon la, ");
INSERT INTO lww_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","a pogos nap̃a lala apisu naga mial yau ke e lapa pimi pula sanene, la apionia asape “!Aulai, suri ya ne pimi ke sanene! ?Yermare yo, pona yar ne sanene?” ");
INSERT INTO lww_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Lala punu apisu naga sa nene, amarau pap̃isi. Ana veraga Yesu pisi pan la, pisape “!E, ve amarau re, in ga ne.” ");
INSERT INTO lww_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ana Yesu p̃iyu pa metava e waa amio la, ana veraga ga e aora nene, lagi nene mare, ana la nap̃a asike e waa amilan pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Amilan sanene komin kiela sitomena la m̃arera ke wa, la pe apisu kilia re sur la nap̃a Yesu naga kilia yum̃aenia e kiena puriu kawaena poli, sane ya nap̃a miyum̃aen amio narin kilaparavi la lima nap̃ane. ");
INSERT INTO lww_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ana Yesu lala akusro pupia lapa nene e kiela wa, apa atol yo tai, kiena kia Kenasaret. Ana pogos nap̃a akoan kana kilavaru pa ura, ");
INSERT INTO lww_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","apula petan kiela wa, ana verakorena ga yaru nae e yo nene lala apisu kilale Yesu. ");
INSERT INTO lww_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ana lala akiriri atelivi piora e m̃ala yum̃a lala, akus kiela inanena la e m̃ala tog, apa ke e yo la nap̃a amloge asape naga pa ke ea. ");
INSERT INTO lww_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ana e yo punu ga nap̃a Yesu pa ke ea, e yum̃a lala, pona pulkumali lala, pona mrapa lala, akus ke kiela inanena lala, amligan ruru la ke pa rui e yo metava lala, la apiun ke tania asape visae naga tam̃ania ana inanena lala akilia atoliga m̃ana luas nen kulkota. Ana lala nap̃a atolga sanene, kiela inanena la p̃isi, amloge po sina. ");
INSERT INTO lww_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ana e pogos nene, le Varasi la p̃asia apimi lele taaga puna Yesu, amio m̃ena navianena navisaluaena, nap̃a lala akom garo Yerusalem apami. ");
INSERT INTO lww_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ana lala apisu ke sane pogos nap̃a nalogena kiena Yesu la akinana ke, lala akila sane e nakiravaena kiena le Varasi la, la nene limala la na piowa ga. Na nene vanon pe ataveve ruru re narin mrapa la moki nap̃a na kevanen limala sa nap̃a le Varasi la apisa ke asape yar naga monar yum̃aen, sumon nap̃a kinana. ");
INSERT INTO lww_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nanene komin e pogos nene, le Varasi lala amio le Yu tap̃ena la am̃areran ke pap̃isi nayum̃aen ve sanene, vena taveve ruruen kiela p̃elaga marua na kiela nalotena na sumo lala. ");
INSERT INTO lww_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","La akila ke sanene pogos nap̃a amiyal apa kumali, pona akom pe, ana pogos nap̃a la awasup̃e la si um̃a, la monar ataveve kiela navisaluaena na kevanlaen amerarava wo pona ave wa ruru sina. P̃isin nakilaen sanene, la akilia akinana narui, komin visae la ve akila re, tap̃atete atol kala kinanena. Ana kiela narin navisaluaena m̃ena lap̃as moki nap̃a monar atavevea, nap̃a p̃asia, na kevanen m̃ala piala la monar akevan ve sanene ve sanene, a p̃asia, sane monar avilvan kala piaki ve sanene ve sanene, a p̃asia, nap̃a nakevanen kala pialo la nap̃a amiyum̃aen e pras ve sanene ve sanene, naga pa sa la nene. ");
INSERT INTO lww_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sur ne nanene kila le Varasi la apiun petan Yesu, asape “Komin ya ne kiom̃a nalogena la pe ataveve re p̃elaga marua la na kieta nalotena na sumo la poli, nap̃a kieta nasumonena la apian itania. Ana kiom̃a yar la nene, la akinana ga e limala namname lala, komin pe akevan ruru re limala la poli.” ");
INSERT INTO lww_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ana Yesu pisatam̃e la, pisape “Pe lelaga ga, navisawalena Aisea na sumo naga pisayu ruru amiu ga yeririna na visokanen lala, nap̃a naga mlologon visena nap̃a Ntewa naga pisa, nap̃a naga pisa sape ‘Yeririna la nene la apatanonu ga e kiela visena lala, ana kiela sitomena naga sike perinan inu pap̃isi wa. ");
INSERT INTO lww_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","La amiyeluarnu ke, ana pe sur korena ga, komin pog nap̃a la apian ke yeririna lala, apisa ke asape visena nene kiena ne Ntewa, ana peraga, visena nene naga pe kiela ga yeririna lala!’” ");
INSERT INTO lww_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","A Yesu pisa pan la, pisape “Amiu na amligan lua ke navisaluaena kiena ne Ntewa, apuarar ke ga p̃elaga marua kiena ne yeririna lala m̃arera. ");
INSERT INTO lww_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nanene naga pe mesmes re nap̃a ayum̃aen sanene poli, komin amiu am̃areran ga nataveveen p̃elaga marua kiena ne yeririna lala, a nanagane amiu akila pano-o p̃elaga marua ga la nene naga sike narui, miaslua make navisaluaena kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Amiu na ve asitom re asape amiu akila ke sanene, ana yoko nevisa kiamiu tai, nap̃a amiu asum̃a akila ke. Amiu asitom̃al li navisaluaen kiena Mosis, nap̃a pisape ‘Ologear arimom̃a amio anom̃a,’ pisa m̃ena sape yar nap̃a sa vis viowa van arimana amio anena, awemom̃aria. ");
INSERT INTO lww_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Navisaluaena nene pisa ke sape ita monar tevisuar ruru ita kieta yermarua lua nene, ana amiu na akila pe tap̃ena. Visae yar tai kilawoia sape kiena sur lap̃asia pe kiena ne Ntewa, ana pogos nap̃a kiena yermarua lua kiela sur re poli, aim aviunia, yoko amiu avisa ya ne vania? ");
INSERT INTO lww_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yoko amiu am̃areran vania, avisave ‘Toko, ve otam̃an re van lalua nene, vanon kieta p̃elaga naga pisa sape sur nap̃a tepisaarwoia pan Ntewa, ko na monar owar ga van kiena yar wa lala, ve otam̃an re van yar tap̃ena lala.’ ");
INSERT INTO lww_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","?Amiu na apisa ke sanene, ana sanape na sanene? Amiu na asum̃al ke m̃arera e kiamiu p̃elaga marua, amiu amligan lelein ke pitove, ana kila ke nap̃a p̃elaga marua la nene naga kila ke navisaluaena kiena ne Ntewa pimi pe sur korena ga. Ana pe naga re ga nene poli, amiu akila ke m̃ena sur la moki sanene.” ");
INSERT INTO lww_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","P̃isi na Yesu naga pio si yeririna lala pisape aimi veraga puna, ana pisa pan la, pisape “Amiu punu ga ayagogan ruru inu, monar aloge kilia kiau visena la nini. ");
INSERT INTO lww_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Pe sur re tai nap̃a teke vanuan yeririna, nap̃a sa naga va loyum̃a e losinena kilia kila naga namname e marana Ntewa. Ana suri ga la nap̃a sike loyum̃a e losinena yeririna, pogos nap̃a molmolue e naga, kila naga ve namname e marana Ntewa.” ");
INSERT INTO lww_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ana Yesu petan yeririna la nene, pato si um̃a, siraunia kiena nalogena la apim, apiun tania e kinas nen p̃akaiwa nap̃a naga pisayu pan la. ");
INSERT INTO lww_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ana Yesu pisape “?Ei, sanape, pona amiu m̃ena pe p̃arimiu pike re sane la nene poli yo? Komin ya ne amiu m̃ena pe apisulup̃ar re sur nene poli, sane suri la nap̃a teke vanua, sane kinanena lala, visae va loyum̃an yeririna, sur la nene naga tap̃atete kila yeririna viowa e marana ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nanene komin sur la nene pe tol re kiena sitomena poli, la apato ga e m̃ep̃ena, ana la amolue akom sina ga e yepena.” Yesu pisa pa sanene narui, siraunia, yeririna la apisulup̃ar kiena visena, naga pisa kilale pisape pe kinanen re tai poli nap̃a yeririna monar lonia vena mekiki e marana ne Ntewa, ana kinanena la punu ga naga pon na kanena. ");
INSERT INTO lww_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ana Yesu pisa m̃ena sape “A suri la nap̃a sike pa e yeririna rui, p̃isi na amolmolue e kiena malena, sur ne la nanene naga kilia kila yeririna ve namname. ");
INSERT INTO lww_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nanene komin e los nen yeririna, p̃elaga viowa la na amolmolue ke ea, suri ne la sane sitomen viowa, kolau, vinauena, nawemom̃aren yaru, navinaunen wona yar tap̃ena, ");
INSERT INTO lww_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sinenanen sur kiena yar tap̃ena, p̃elaga viowa lala, visokanena, kilaroen navisaluaena, veveyuena, navisa kareen yaru, nawarwarena, navilaveena, a ve woweena. ");
INSERT INTO lww_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","P̃elaga viowa ne la nene amolmolue e los nen yeririna, sur la nene kilia kila yeririna ve namname e marana ne Ntewa.” ");
INSERT INTO lww_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","P̃isi na Yesu petan yo nene, pato tano garo pulkumali nae Taea. Ana pa e um̃a tai, sape kila sane yaru la ve akilia re asape naga sike e yo nene, ana naga tapolou p̃ele ga sanene. ");
INSERT INTO lww_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ana sira tai sike e nene nap̃a kiena lus la kom ma Kris apitom, nap̃a la pe ape Yu re poli, apitom asike yo nap̃a Ponosia lavisin Seria. Sira nene, narina tai na sira, ninuna viowa teke ea, pogos nap̃a naga mloge asape Yesu naga sike e yo nene, naga pa kinai e mialana, tagi pania sinenan pisape naga m̃enelua ninuna viowa ure vetan narin sira nene. ");
INSERT INTO lww_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ana Yesu pisatam̃e pania, pisape “Ana sisi mesmes la na monar akinana ko ne wa. Pe mesmes re nap̃a nowar plan kinanena kan sisi la vetan la, nevagan lokul la ea.” Naga pisa sanene komin e pogos nene, le Yu la na asitom ke asape la ga ape narina Ntewa, la apio kare ke la nap̃a pe ape le Yu re la poli, asape “Amiu na ape lokul lala.” ");
INSERT INTO lww_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ana sira nap̃a pisatam̃e pania, pisape “Ko na opisa pe lelaga, Sup̃e, ana lokul m̃ena la apa ke lavisin lele na kinanen kan sisi kokan lala, akilia akan korkoro kinanena la nap̃a kekapili sike e porotano.” ");
INSERT INTO lww_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ana Yesu pisa pania, pisape “Ko na opisatam̃e kinas nen kiau visena nene po pap̃isi. Ana komin kiom̃a visena nowo nene, nepisulup̃ar sane opiawa m̃arera e inu. Poga, okilia ovato si um̃a, ninuna viowa molue petan narum̃a nap̃a rui.” ");
INSERT INTO lww_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","P̃isi na sira nap̃a pato si um̃a, pisu narina pa ruru ga tom̃a ga, tom̃a momalio m̃a pogaga e m̃ana tog. ");
INSERT INTO lww_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ana Yesu naga mligan yo nae Taea, pato kome pulkumali tap̃ena tai, Saeton, ana naga pam sina ga e lapa nae Kalele, e lepas nae yo nap̃a apio sape Pulkumali Lualima. ");
INSERT INTO lww_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ana la nae yo nene ap̃ure yar tai pimi puna, vena naga ligan limana te ea, komin yar nene kiligana la pop̃e, mon m̃a mnenene ga. ");
INSERT INTO lww_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ana Yesu p̃urelua yar nene petan yeririna moki la nap̃a asike lele nene, lalua apa li laa perina sane. Ana naga kian mrasilmana pa e pulkiligana lala, p̃isi na mla wasirina, plan e purmenen yar nap̃ane. ");
INSERT INTO lww_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ana Yesu kira pa ma e peni, pure kiena yalua keviu, pisa pan yar nap̃a e kiela visena, pisape “Epata.” Visena nene kana kinasia sape “Ovike.” ");
INSERT INTO lww_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ana veraga ga, yar nap̃ane kiligana la pike, a purmenena naga kululu sina, kila sane naga mloge ruru si sur lala, a pis ruru sina. ");
INSERT INTO lww_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","P̃isi narui na Yesu pisa m̃areran pan la, pisape ve ava asunun re sur nene van yar tap̃ena lala, ana silaga pogos nap̃a pisa sanene pan la la apa apisalelein ke pa e yo punu ga. ");
INSERT INTO lww_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ana la apisawal-lelein sa nene, komin sinela la pula na pulan sur la punu ga nap̃a apisu Yesu kilia tap̃a. La apisasa ke asape “Yesu nene kila la nap̃a kiligala la pop̃e amloge si suria, a kila la nap̃a apis pule ga, akilia apis ruru sina. Aulai, yar nene kila sur la punu ga po na po pa p̃isi.” ");
INSERT INTO lww_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ana e pogos tai, pupia p̃ina na yeririna la moki apimi sina pu Yesu, la asum̃a amio pano-o, viso kar la, ana la pe kala kinanen re poli. Ana Yesu pio kiena nalogena la apimi lavisi puna, pisa pan la pisape ");
INSERT INTO lww_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“E, in na sineu miye p̃ina la nini pap̃isi, komin nap̃a la asike amio ita legiena telu p̃aro rui, kala kinanena la p̃isi. ");
INSERT INTO lww_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ana visae netam̃an la ava um̃a m̃ala nap̃a pe akinana re sanene poli, pona lap̃as viso kar la e mrapa komsusa, kilamarala malko, komin lap̃asia m̃ala um̃a la sike koperina pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ana kiena nalogena la apisa pania, asape “?Ana tevagan yeririna la nene e yo korena nini sanape ne?” ");
INSERT INTO lww_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","P̃isi na naga piun tan la, pisape “?Amiu amlarar ke kilaparavi via?” Ana la apisatam̃ea “Olua ga p̃a.” ");
INSERT INTO lww_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","P̃isi na Yesu pisa pan p̃ina moki la nene, pisape “Amiu atotano e yo nene wa.” Naga mla kilaparavi la olua nene, pisa potena pan Ntewa panonia, p̃isi na kawewowaia, kian pan kiena nalogena lala vena akianlelein van yeririna lala, p̃isi na la apion tetain pan la. ");
INSERT INTO lww_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ana la amla m̃ena narin satin lua la ga e pogos nene, a Yesu mlotuwo m̃ena ga, pisa pan la sape ava avionlelein m̃ena ga van yeririna lala. ");
INSERT INTO lww_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ana la nap̃a akinana pano-o, mep̃ela la kawa, ana korkoro kinanena nap̃a akanligania, ap̃ar akon pa e karo olua. ");
INSERT INTO lww_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ana la nap̃a akinana e pogos nene tol sane manu vari. P̃isi na Yesu miila si p̃ina la nene ap̃asup̃e si m̃ala um̃a lala, ");
INSERT INTO lww_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ana naga pa e kiela wa, amio kiena nalogena lala, apetan yo nene, akusro apa atol yo tai nap̃a kiena ki Talmanuta. ");
INSERT INTO lww_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ana e pogos tai, le Varasi lap̃asia apim asape agorua Yesu, asape atap̃ali m̃ena ga naga, ana la apisa asape “Imimi sinemimin mesape okilali pupia kile tai van imimi, nap̃a sane okila e puriu kawaena nae ma e peni.” ");
INSERT INTO lww_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ana Yesu naga miyuveve pa kona, sa nap̃a sinena maren la pa rui, naga pisatam̃e la, pisape “?Sanape na amiu na nanagane, sinemiun asape avisu kile tai ne sanene? Nepisa ke pe lelaga pan amiu, sane peraga, yoko kiamiu lus la na nanagane tap̃atete avisu kile tai.” ");
INSERT INTO lww_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ana Yesu pure petan la mligan la asike na, pa si e wa, pa kusro lapa komp̃asia pa lepas na vano. ");
INSERT INTO lww_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ana pogos nap̃a la apetan yo nene apa atol komp̃as nen lapa nene, amilan sane sinela pon nawararen kala kilaparavi p̃asia amio la, ana la amlarar ga kilaparavi taaga teke amio la e wa. ");
INSERT INTO lww_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ana Yesu pisa visena tai pan la, pisape “Amiu monar avisuar ruru amiu, vanon is kiena ne le Varasi la amio Erot.” Yesu pisa is nene, kana kinasia p̃elaga viowa kiena ne nasumonena lala, ana nalogena la pe asitom kilia re poli. ");
INSERT INTO lww_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","La amloge visena nene, apisayu ke pan la, apisape “Pona naga pis sanene vanon ita pe top̃ar re kilaparavi lap̃as pimi poli yo.” ");
INSERT INTO lww_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ana Yesu kilia m̃a kiela sitomena lala, p̃isi na pisape “?Amiu apisayu ke asape ita pe top̃arar re kilaparavi komin ya? ?Sanape, amiu pe amloge kilia re poli, pona pe apisu kilia re sur la poli wa? !Sinemiu la m̃arera pap̃isi wa! ");
INSERT INTO lww_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Amiu kilamaramiu la sike na, ana apisu kilale re sur poli, ana kiligamiu la sike na, ana amloge kilia re sur poli. ?Pona amiu pe asitom̃al re si sur la nap̃a nemiyum̃aen pan yeririna la poli? ");
INSERT INTO lww_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","?Pogos nap̃a nekiantetain kilaparavi lima nanua ne pan yeririna la manu lima nap̃ane, akan pano-o mep̃ela kawa, ana akon korkoro kinanena la nene pa e karo via?” La apisatam̃ea, asape “Imimi mokonkonia lualima taaga pa lua 12.” ");
INSERT INTO lww_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","P̃isi na naga piun sina ga, pisape “?A pogos nap̃a lala manu vari nanua ne akan kilaparavi olua ga nap̃ane, p̃isi na amiu akon si karo via?” Ana la apisatam̃ea, asape “Imimi mokonkonia olua.” ");
INSERT INTO lww_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ana naga pis pan la, pisape “?Pogaga, ana sanapen nanagane? ?Amiu akiliali m̃a sur la nene, pona pere ke ga wa?” ");
INSERT INTO lww_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ana Yesu la apam atol pulkumali nene, Petsaeta. Ana la nae yo nene, a sumon kilamara kata tai pimi puna, atagi pania vena tol ruru yaru nene. ");
INSERT INTO lww_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ana Yesu tarar limana ne kilamara kata, sumon naga pano, la lua amiyuve kumali apa lepas na vano. P̃isi na Yesu mla wasirina, mligan e kilamaran yar luwoka nap̃ane, mligan liman tea, ana piun petania, pisape “?Sanape, ko na opisu ke suria, pona pere ke ga wa?” ");
INSERT INTO lww_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ana yar nap̃ane kirava, kira pisu suri lala, naga pisape “Ee, nepisu ke yar lala, ana nepisu la sa ga purp̃es nen laki la amiyal ke na.” ");
INSERT INTO lww_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ana Yesu mligan si limana e naga, yam luania, p̃isi na yar nene kilamarana pimi po ruruia, naga kilia kira pisu si suri lala, kira pisu la merarava po na po pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ana Yesu pisa pania, pisape “Yoko ko ove ova re si ovisu la nene gar um̃a, oto mesmes ga mom̃a.” ");
INSERT INTO lww_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","P̃isi na Yesu amio kiena nalogena la asape avato e narin pulkumali lala nap̃a lavisin kumali keviu nap̃a Sisaria Pilip̃ae, a e pogos nap̃a la amiyal ke apato e yo nene, naga piun tan la pisape “?Amiu amloge ke yar la apisa ke asape in na ai?” ");
INSERT INTO lww_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","La apisatam̃ea apisape “Lap̃asia apisa ke asape ko na Yoane Nakeena sina ga, lap̃asia asape ko na Elaisa, p̃asia asape ko na navisawalena tai nap̃a na konua rui.” ");
INSERT INTO lww_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ana naga piun si tan la, pisape “?A sanapen amiu, amiu na apisa ke asape in na ai?” Ana Pita pisatam̃ea, pisawalia pisape “Ko na ope kiamimi Navisaarena kemua lelaga.” ");
INSERT INTO lww_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ana Yesu pisa mesmesun ga pan la, pisape “Pogaga, ana amiu ve ava avisawal lelein re sur nene van yeririna lala.” ");
INSERT INTO lww_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ana e pogos nene, Yesu siar nap̃a mlologon ke pan kiena nalogena lala, pisape Narin Yeririna, monar akila sur la ve moki nap̃a naga loge viowagania, ana nasumonena kiena le Israel lala, amio yar keviu kiena yar wa lala, amio navianena navisaluaena, p̃isi na la akovenlua naga. Ana Yesu pisa m̃ena ga sape la awem̃ar naga mare, ana e kiena legiena na telu, sum̃alu sina, taulu marena. ");
INSERT INTO lww_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Visena la nene, Yesu pisa meraravan po pan la, ana pogos nap̃a Pita mloge, naga piolua Yesu, pis m̃arera pania, sape visawoia, yoko monar ve ve sa re nene. ");
INSERT INTO lww_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ana veraga ga Yesu pilon m̃asina pimi pu Pita, kira pa pun kiena nalogena tap̃ena la nap̃a asike ne, pisalup̃ar m̃arera pa Pita, pisape “!Yermare, oure vetan inu! Kiom̃a sitomena nene naga pe sitomena kien yeririna ga, pe pe sitomen kiena re Ntewa poli.” ");
INSERT INTO lww_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ana Yesu pio p̃ina lala amio kiena nalogena lala, sape aim puna, pisa pan la, pisape “Yar nap̃a sinenan sape taveve inu, monar sitom korenan nasinenanena kiena, monar kus kiena laki torovia, siraun inu. ");
INSERT INTO lww_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yar nap̃a sape taulu kiena malena, yoko kilaluia. A yar nap̃a kilalu kiena malena vanon inu pona vanon kiau lologena wo, naga yoko tauluia. ");
INSERT INTO lww_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Visae yar tai war make sur na yomarava la punu ga ne, p̃isi na kuspal mrapa na malena, naga pe taulu re sur wo tai poli. ");
INSERT INTO lww_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ana kiena sur nowo la nap̃a naga p̃aria, tap̃atete ulmaran si kiena malena. ");
INSERT INTO lww_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yeririna moki nap̃a lus na nanagane, la atap̃a mlamulena viowa, la pe ape lelaga re pan Ntewa poli, la apiowa manene la, a la amawan ke yar tap̃ena la vanon inu a vanon m̃ena kiau visena. Ana siraunia, Narin Yeririna naga yoko wasup̃e sina ga, amio kiena navisi wa lala, amio naurarena kiena arimana, ana pogos nap̃a avim, visae yar nap̃a yepena mavin ke naga nanagane, naga m̃ena yoko yepena mavin yar nene.” ");
INSERT INTO lww_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ana Yesu pisa m̃ena pan la, pisape “Lelaga nepisa ke pan amiu, yeririna lap̃as na asum̃al ke e nini, nap̃a p̃isi na tap̃atete amare, vano-o tol pogos nap̃a avisu nasup̃enena kiena ne Ntewa imi kate amio kiena pupia m̃areraena.” ");
INSERT INTO lww_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Siraun Legiena Orai p̃arovia, Yesu p̃ere Pita amio Semes, a Yoane, la ga vari apa metava e pupia ravie tai. Asum̃a sane na, nalogena la telu nap̃ane apisu ga yepena ne Yesu pimi pe tap̃ena ke narui, ");
INSERT INTO lww_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","apisu ga m̃ana kulkota la pilavila ke, miyuwowo na miyuwowo, miyuve make ga sur na yomarava la nap̃a miyuwowo. ");
INSERT INTO lww_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ana akirawal m̃ena navisawalena Elaisa amio yermarua Mosis akate, lalua asike asun ke amio Yesu. ");
INSERT INTO lww_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ana Pita pisa pa Yesu, pisape “Sup̃e, po pap̃isi nap̃a ita tesum̃a ga e nini. Popon sa meyum̃aen silparpara ve telu se e nini, mom̃a tai, m̃ana yermarua Mosis tai, a m̃ana ne navisawalena Elaisa tai.” ");
INSERT INTO lww_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita pis wowe ga sanene komin lala sinela kurkur pap̃isi, amarau m̃ena ga, ana la amninue ga avisa yara. ");
INSERT INTO lww_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Veraga ga lul tai pimi kalo la, amloge visena tai molue ea, pisape “Nanene naga pe Naruu, nap̃a nekekaran naga pap̃isi. Amiu monar alogear ruru naga.” ");
INSERT INTO lww_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nalogena la amloge visena nene, ana akirawele ke e yo nene, p̃isi na pe apisu re si lalua nap̃a poli, akirawal ga Yesu naga taaga sum̃al sike amio la. ");
INSERT INTO lww_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","P̃isi na lala apetan ravie nap̃ane, apitom ke sina ga tano, a Yesu pis m̃arera pan la, pisawo la pisape “Sur la nap̃a Ntewa kila pan amiu apisuia, amiu na ve ava avisasawal re van yeririna la nanagane, vano-o tol pogos nap̃a Narin Yeririna mal sina ga e marena, e pogos nene narui amiu akilia avisawal van yeririna lala.” ");
INSERT INTO lww_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","P̃isi na la amlogear visena kiena ne Yesu nene, amlarar ga pe kiela ga, ana la apiuyun ke sina ga petan la asape ya ne kinas nen kiena visena nene, nap̃a pisape mal sina ga e marena. ");
INSERT INTO lww_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ana nalogena la telu nene apiun tan Yesu, asape “Sanape ne navianena navisaluaena la apisa ke asape ‘Elaisa naga monar wasup̃e p̃esia wa, p̃isi na Navisaarena nene naga m̃alivi?’” ");
INSERT INTO lww_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","P̃isi na Yesu pisatam̃e la, pisape “Nap̃a apisa ke ne pe lelaga, Elaisa naga monar imi p̃esia vena kilaruruen sur la punu ga susumo, p̃isi na Navisaarena kilia vim. Ana nasiriena wa pisa ke m̃ena sur tap̃ena tai nap̃a pe asitom̃al re poli, nap̃a pisayu ke Narin Yeririna, sane naga monar vane natap̃aliena la ve moki, ana yoko yeririna la asitom korenan naga viowa vap̃isi ne. ");
INSERT INTO lww_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ana nevisa van amiu, Elaisa nene naga pimi ga na wa, ana yeririna la yepela mavinia. Sa nap̃a Visena Wa pisa, ana la akila pa piowa ga pan rui.” ");
INSERT INTO lww_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","P̃isi na Yesu amio la telu nap̃ane apa ke sina ga puna ne nalogena tap̃ena lala, ana apisu na pupia p̃ina na yeririna la akovivi la asike na, apisu navianena navisaluaena la agorua la ke amio la. ");
INSERT INTO lww_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ana pogos nap̃a p̃ina la akirawal Yesu pam ke sina, amilania, akekaran m̃ena nap̃a asape avisu naga, akiriri apim puna, atalopan naga. ");
INSERT INTO lww_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ana Yesu piun tan nalogena la, pisape “?E, amiu apisayu ke ya ne amio la nene?” ");
INSERT INTO lww_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","P̃isi na lala yar tai pisa pania, pisape “Navianena, in na nepure kiau sisi yerm̃ene nini pimin ko vena ovisulia, komin purkol m̃arera tai kila naga. ");
INSERT INTO lww_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ana pogos nap̃a kila naga, kovenlua naga pato tano e porotano, wasirina mlau piowa ga sa nap̃a siripu, karar ke mraluena, a yepena punu ga miokamarmare. Ana nepure naga pamin ko, ko na osu re poli, p̃isi na nepiun ga tan kiom̃a nalogena lala vena la alen nam̃eneluaen suri nene vetania, ana la amiyum̃aen m̃a pano-o, akilapule ga yonia.” ");
INSERT INTO lww_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ana Yesu pisatam̃e la, pis pan la, pisape “?Amiu la nene, sanape na sanene? Amiu na pe asum̃al m̃arera re nena e Ntewa. ?In na monar nesum̃a nemio amiu vano tol pog ya? Nemiowon amiu pa rui. Ana pogaga, akus teras nene vim punu.” ");
INSERT INTO lww_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ana la ap̃ure pimi, ana pogos nap̃a purkol nene m̃al Yesu, kila yepen teras nap̃ane miokamarmare, mloru pato tano e porotano m̃eke pilolon ke, kila wasirina naga mlau piowa ga sa nap̃a siripu. ");
INSERT INTO lww_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ana Yesu piun tan ariman teras nap̃ane, pisape “?Ana purkol nene siar kila sanene pogwai?” Ana arimana pisatam̃ea, pisape “E, sur nene siar na konua konua rui, pogos nap̃a pe sisi ke ga wa. ");
INSERT INTO lww_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ana pimi tol nanagane, yam moki rui nap̃a sur nene kila ke naga mlolor pa e kapi po pito e puluwii. Sur nene kila kare ke ga naga pap̃isi, sape kilam̃aria, ana sa ko na okilia okila sur yan tai, imimi mepiun tan ko, awis, ko na sinem̃a ye imimi, oiila imimi komin narimimi nini!” ");
INSERT INTO lww_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ana Yesu pisa pania, pisape “Nemloge ko na opisa sanene, osape sa in na nekilia nekila. Ana nepisa pan ko, visae ko na olelaga ga, okilia okila sur punu ga.” ");
INSERT INTO lww_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ana ariman teras nap̃ane pio verakorena ga pa Yesu, tagi pania, pisape “Nemlelaga tekak ga, ana pe nemlelaga toroki re poli wa. Awis, ko na oiila inu vena kiau nalelagaena vim ve keviu laa sane wa.” ");
INSERT INTO lww_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ana pogos nap̃a Yesu pisu p̃ina na yeririna la apim moki manene la akovivi la, ana naga pis pa purkol nap̃a teke e sisi yerm̃ene nene, pisape, “Ko yermare na kiliga pop̃e, a na plapur, nepisa mesmes ga pan ko, omolue vetan naga nanagane, ana ve oimi re si loyum̃a e naga pogos tai.” ");
INSERT INTO lww_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ana yermare nene ki viowa keviu, kila yepen sisi yerm̃ene nap̃ane miokamarmare pano-o piowa ga rui, p̃isi na molue petania, pure pano. Ana yepen yar nap̃ane malumu ga m̃eke, sa ga nap̃a naga mare pa rui, yar la nap̃a asike apisu ke la apisa ke sa nini, asape “Ke, teras nene mare pa p̃isi rui.” ");
INSERT INTO lww_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ana Yesu tarar limana, tarlua sum̃alu, ana teras nene sum̃al ruru ga sike. ");
INSERT INTO lww_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ana siraunia, Yesu pato si um̃a, a e pogos nene, nap̃a naga taaga sike, kiena nalogena la apim, apiun tania, asape “?Sanape ne imimi na mem̃enelua p̃ele yermare petan teras nene?” ");
INSERT INTO lww_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ana Yesu pisa pan la, pisape “Yermare la ne sanene, la am̃arera pap̃isi, ana leniena ga kilia m̃ene plan la.” ");
INSERT INTO lww_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ana Yesu la apetan yo nene, apa akom ga likan yo na e Kalele, ana e pogos nene, Yesu pe sinenan re sape yeririna la akilia suri la nap̃a naga kila ke poli, a e m̃ena yo la nap̃a apa ke ea. ");
INSERT INTO lww_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Na nene komin nap̃a pian ke kiena nalogena lala e pogos la nene, a naga pisa m̃ena ga ke pan la, sape “Lavisi m̃ena narui nap̃a aligan Narin Yeririna va e liman yar la nap̃a awem̃ar naga mare, siraunia e legiena na telu, p̃isi na Ntewa tamalia sina.” ");
INSERT INTO lww_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ana kiena nalogena la pe amloge kilia re sur la nap̃a Yesu pisayu ke ne, ana la amaraun m̃ena naviun ruruen si tania. ");
INSERT INTO lww_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ana siraunia, pogos tai la apam atol si Kapeneam, apa loyum̃a e yum̃a tai, ana Yesu piun tan kiena nalogena lala, pisape “?Amiu na akawe amiun ke visena ya nap̃a e mrapa?” ");
INSERT INTO lww_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ana la pe apisatam̃e re poli, komin nap̃a lala amiyal ke mrapa apami, apis ke pan la, asape lala ane naga to metavan make la, po miyuve make la ga. ");
INSERT INTO lww_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","P̃isi na Yesu totano, ana pio kiena lualima taaga pa lua apim lavis puna, pisa pan la, pisape “Visae amiu yar tai naga sinenan sape vim sumo, pona sinenan sape kiena kia to p̃esia, pogaga, naga monar kila naga imi maro, to vatanon la make ga, naga monar vim ve yar nayum̃aenen yum̃aena kiena ne yar tap̃ena la wa.” ");
INSERT INTO lww_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ana Yesu pio narin sisi tai nap̃a sum̃a ga pimi puna, mligan su likan la, ana tararia, pisa pan la, pisape ");
INSERT INTO lww_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yar nap̃a kiena sitomena pato ga tanon inu, ana kekaran na kilaen wo van nisisi tai ne sanini, nanene sane naga kekaran inu ke pa narui. A yar nap̃a kekaran inu sanene, pe kekaran inu re ga ne po, kekaran m̃ena ke pa naga nap̃a mliganu nepimi.” ");
INSERT INTO lww_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ana nalogena nap̃a Yoane pisa pa Yesu, pisape “Navianena, imimi mepisu yar tai, nap̃a naga m̃ene plan ke yermare lala, m̃ene plan la ke e kiom̃a kia. Ana yar nene na, pe mekilia re naga poli, naga pe ita yar re tai poli, ana imimi mepisalup̃aria.” ");
INSERT INTO lww_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ana Yesu pisa pan la, pisape “Peraga, amiu ve avisalup̃ar re naga. Visae yar tai sane pe lelaga, kila ke yum̃aena keviu la e kiau kia, ana yoko naga tap̃atete si visanena kare kiau kia pogos tai. ");
INSERT INTO lww_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yar nap̃a pe pisalup̃ar ita re poli, miila ita ke ne. ");
INSERT INTO lww_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Inu nepisa ke pe lelaga pan amiu, visae yar tai kilia sape amiu akus ke kia kiena ne Kristo e amiu, naga la piala na wii tai van amiu amunia, yar nene naga yoko tap̃atete kilalu kiena nalaena nowo nap̃a yoko tol sirau.” ");
INSERT INTO lww_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ana Yesu pisa m̃ena ga, pisape “A visae yar tai naga kila narin sisi tai ne sanini ve sum̃al m̃arera re e inu, yar nene yoko tol nakoaena tai ne m̃arera laa sane taulu nap̃a sa aviar pupia kilavaru tai e kolmekina, akuan naga talilu e lowe memaena. ");
INSERT INTO lww_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","46","Visae lumom̃a tai pona lam̃a tai nap̃a kila ko na pe osum̃alu m̃arera re si e in poli, popon manene ga otelua vano. Visae ko na ote plan p̃elaga naviowaena vetan kiom̃a malena sanene, p̃isi na okilia ova loyum̃a e malena, a sa ova loyum̃a e malena nap̃a komp̃as nen lumom̃a tai po lam̃a tai kovio pa rui, nanene naga pogaga ne. Ana piowa vap̃isi visae yepem̃a la asum̃a ga woga ga, p̃isi na akuan ko ova e kapi nap̃a tap̃atete mare pogos tai. ");
INSERT INTO lww_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ana visae kilamaram̃a pona suri ya si tai e malena kiom̃a nap̃a kila ko pe osum̃alu m̃arera re si e inu poli, popon manene ga osiplania. P̃isi na okilia ova loyum̃a e nasup̃enena kiena ne Ntewa nap̃a sane narin sur tai nene kovio petan ko, na nene naga pogaga ne. Ana piowa ga vap̃isi visae kilamaram̃a luoka pona kiom̃a p̃elaga viowa tai sum̃a ga, p̃isi na narin sur ga la nene aure kiom̃a malena wetelu va e kapi e lele naloge viowaena, ");
INSERT INTO lww_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nap̃a kapi nene tap̃atete p̃isi pogos tai, sisu la na akakarlue ga yepem̃a. ");
INSERT INTO lww_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Sa nap̃a kururu sive naga kila kinanena ponos tap̃atete kona, yoko Ntewa naga ligan kapi e yar lala vena kekan plan kororaki la nap̃a e kiela malena lala. ");
INSERT INTO lww_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ana tepisu m̃ena sane kururu sive kila kata kinanena naga kiki, ana visae kana m̃areraena kovio, tap̃atete si kila kiena yum̃aena narui. Ana amiu monar atam̃an kururu sive kiena ne Ntewa yum̃ae lue ga e amiu, vena kiamiu malena naga ve kona re, a vena kiamiu p̃elaga la kiki, nap̃a sane sum̃arena sike amio amiu silaga.” ");
INSERT INTO lww_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ana siraunia, Yesu mligan Kalele ana pa metava e lepas nae Yutea, kome wii nae Yortan lepas na vano. Ana p̃ina lala apim ke sina ga puna e pogos nene, ana sa nap̃a naga kila ke silaga, pian la ke e sur la moki. ");
INSERT INTO lww_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ana Varasi m̃ena ga p̃asia asike e pogos nene, apimi puna ne Yesu, apisape akilali sina ga naga, la apiun naviunena tai pania. La apisape “?Kieta Navisaluaena pisa ya ne e lepas nen p̃elaga nap̃a visae yaru mligan lua wona? ?Ositom sanape, mesmes ga nap̃a yaru kilia kila sanene, pona pe mesmes re poli?” ");
INSERT INTO lww_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ana Yesu piuntam̃e la, pisape “?Ana Yermarua Mosis pisalua ya ne e kiena navisaluaena rui?” ");
INSERT INTO lww_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ana Varasi la apisape “Mosis pisawal navisaluaena tai nap̃a naga tam̃ania sape yaru kilia la lum̃aki naliganluaena tai van wona, vena ligan lua.” ");
INSERT INTO lww_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ana Yesu pisatam̃e la, pisape “Lelaga, ana Mosis siri visena nene vanon ga nap̃a amiu p̃arimiu la m̃arera pap̃isi, suri nene kila naga tam̃ania sape akilia aligan plan womiu lala. ");
INSERT INTO lww_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","A siaria e nasiiena naga pe sa re nene poli, komin Visena Wa kiena ne Ntewa pisa sape ‘E purp̃esia, Ntewa sii yeririna, yerm̃ene a sira.’ ");
INSERT INTO lww_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ana visena tap̃ena si tai, nap̃a pisape ‘Vanon suri nene, p̃isi na yaru ligan arimana amio anena, naga va iakol amio wona, ");
INSERT INTO lww_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ana lalua aimi ave taaga ga narui.’ “Nanene kila sane lalua ve ave lua re sina ga, aimi ave taaga ga narui. ");
INSERT INTO lww_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ana sur ya nap̃a Ntewa vilolaria pimi taaga, pe mesmes re nap̃a yaru kilapure si poli.” ");
INSERT INTO lww_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ana pogos nap̃a lala apa si loyum̃a, kiena nalogena lala apiun sina ga tania e lepas nen visena la nap̃ane. ");
INSERT INTO lww_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ana Yesu pisa mesmes ga pan la, pisape “Visae yaru tai ligan lua wona, p̃isi na va ure si sira tap̃ena, Ntewa pisu sane yaru nene naga tap̃a ke pa kolau rui, naga kila kare sira nap̃a pe wona nasumo. ");
INSERT INTO lww_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ana visae sira tai ure matan wona na yerm̃ene, va pu yerm̃ene tap̃ena, naga m̃ena nene Ntewa pisu sane kolau.” ");
INSERT INTO lww_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ana lap̃asia akus narila la apimi pu Yesu, vena naga ligan limana te la, ana nalogena la apisuia, apisi m̃arera pan yeririna la nene, apisalup̃ar la. ");
INSERT INTO lww_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ana pogos nap̃a Yesu pisuia, pe kekaran re nena nap̃a kiena nalogena la amiyum̃aen sanene poli, naga pis pan la pisape “Amiu ve avisalup̃ar re sisi la nene, atam̃an la ga aim pun inu, vanon nap̃a sisi lala, la na sa ga yeririna la nap̃a asike loyum̃a e nasup̃enena kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","In na nevisa ve lelaga van amiu, yar nap̃a sinenan ke sape va loyum̃a e nasup̃enena kiena ne Ntewa, naga monar kilia sane naga sa ga sisi kokan tai, naga tap̃atete kila sur tai vena kus nasup̃enena kiena ne Ntewa e malena kiena.” ");
INSERT INTO lww_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ana Yesu kutarar sisi la nene e limana, mligan limana te p̃arila pisa ruru la. ");
INSERT INTO lww_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ana e pogos nap̃a Yesu siar mial pa ke narui, yaru m̃ee tai kiriri pimi kinai tano puna, piun tania, pisape “?Navianena Nowo, in na monar nekila yum̃aena wo ya, nap̃a kila p̃isi na netol malena nap̃a ve uro re?” ");
INSERT INTO lww_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ana Yesu pisa pania, pisape “?Vanon ya ne opiun tan inu sanene, osape in na nepe Navianena Nowo? Pe yar re tai po poli, Ntewa ga naga taaga po. ");
INSERT INTO lww_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ana ko na okilia m̃ena kiena navisaluaena la nap̃a monar ologear la, nap̃a apisa ke asape, ve owem̃ar re yaru mare, ve otap̃a re kolau, ve ovinau re, ve ovisokan re, ve okilakewean re yaru, ko ova tanon arimom̃a amio anom̃a.” ");
INSERT INTO lww_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ana yaru m̃ee nene pisa pania, pisape “Navianena, navisaluaena la nap̃a opisa ke ne, siar pogos nap̃a nepe sisi ke ga wa, nesum̃a nemlarar make punu ga rui pimi tol nagane.” ");
INSERT INTO lww_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ana Yesu kira pisu m̃a sane pano-o, kekaran naga vanon kiena visena nene pap̃isi, pisa pania, pisape “Sur taaga teke ga wa nap̃a ko na okila re poli wa. Ko ovano, owilwilin plan make kiom̃a sur la punu ga, owar kana kilavaru nena, ova oviovionia van yaru la nap̃a pe kiela sur re poli. Visae ko okila sanene, p̃isi na kiom̃a suri wo lala ve moki vap̃isi ma e peni. Ko, ova okila, siraunia oimi otavevenu.” ");
INSERT INTO lww_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ana pogos nap̃a yaru m̃ee nene mloge visena nene, kila naga milan karea, sinena piowa pap̃isi, vanon nap̃a naga kiena sur la moki manene laa. Ana naga pure matan Yesu. ");
INSERT INTO lww_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ana Yesu kira pisuveve kiena nalogena lala, pisa pan la, pisape “!Nevisa ruru van amiu, visae yaru tai nap̃a kiena suri moki, sinenan pisape va loyum̃a e nasup̃enena kiena ne Ntewa, suri nene na m̃arera towe m̃a nap̃a!” ");
INSERT INTO lww_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ana kiena nalogena lala amilan visena kiena ne Yesu nene pap̃isi, naga pisa si pan la, pisape “Pe lelaga naruu la, navaen loyum̃a e nasup̃enena kiena ne Ntewa naga m̃arera na m̃arera. ");
INSERT INTO lww_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ee, nevisa van amiu, nap̃a kamel tai naga va warpoyo e pulus nen nitil, nanene naga m̃arera vap̃isi ne, ana visae yaru tai nap̃a kiena suri la moki sinenan sape va loyum̃a e nasup̃enena kiena ne Ntewa, naga m̃arera laa na wa.” ");
INSERT INTO lww_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ana pogos nap̃a nalogena la amloge visena nene, amilan pap̃isi, apisape “?Suwala, ana visae ve sanene, p̃isi na ane kilia tol namalena nene?” ");
INSERT INTO lww_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ana Yesu kirava pisu la, pisape “Ee, lelaga nap̃a yaru tap̃atete tamalia yaru, ana Ntewa ga kilia kila make suri punu ga.” ");
INSERT INTO lww_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ana Pita sinenan sape vis, pisape “?Ana sanapen imimi? Imimi memligan make kiamimi sur la rui, ana metaveve ko.” ");
INSERT INTO lww_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ana Yesu pisa pan la, pisape “In na nepisa ke pe lelaga pan amiu, yaru a nap̃a visae ligan m̃ana um̃a, pona wenla pona vinena, anena pona arimana, narina pona kiena porotano, ana visae naga ligan sur la nene vanon ga inu, a vanon kiau lologena wo, ");
INSERT INTO lww_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","p̃isi na naga warmarana sina ga kiena suri la nap̃a mligania, kilia tol sina ga ve ponotia tai. E yomerava nini, yoko tol sina m̃ana um̃a la, wenla la, amio vinena la, anena la amio narina la, a porotano la, a amio sur la nene, yoko tol pog m̃arera ve moki, nap̃a yaru la sinela kar m̃ena ga. Ana metavan sur tap̃ena la nene, e pogos nap̃a imi, yoko tol m̃ena malena nap̃a tap̃atete p̃isi. ");
INSERT INTO lww_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ana yaru la moki liu nap̃a asike metava, p̃isi na avito tano, ana yaru la nap̃a asike tano, p̃isi na la ava metava.” ");
INSERT INTO lww_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ana Yesu lala amlulu ke mrapa, apa ke metava ma Yerusalem narui. Ana Yesu naga sumon ke kiena nalogena la, la sinela kurkur pap̃isi nap̃a apisu naga sumon la apa Yerusalem, komin la akilia ke asape yeririna nae yo nene la sinela kari ke pap̃isi. Ana li tap̃ena la nap̃a asurau ke ga wa, la m̃ena asum̃a amarau lili m̃aga. A naga piolua ga kiena lualima taaga pa lua apimi puna, pisawal si pan la sanape nap̃a p̃isi na akila viowa vania gar Yerusalem. ");
INSERT INTO lww_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Naga pisayu pan la, pisape “Amiu ayagoga ruruia. Nanagane ita tepa ke Yerusalem narui, nap̃a ve ve piavi re, p̃isi na aligan Narina Yeririna e limana ne yerkawa lala kiena ne yaru wa lala, amio navianena navisaluaena m̃ena lala, ana p̃isi na la nene alip̃ere naga avisave p̃isi na monar mare. Ana siraunia, aligan naga e limana ne la nap̃a pe ape le Yu re poli, ");
INSERT INTO lww_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","nap̃a p̃isi na la nene akirakirai viowa vania, avilasirkon marana, p̃isi na akoa naga vano-o awem̃aria. Ana e kana legiena natelu, p̃isi na mali sina.” ");
INSERT INTO lww_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ana amiyal laa apa sane, p̃isi na narina ne Sepeti lalua nene Semes amio Yoane, apimi puna ne Yesu, apiun petania, apisape “Navianena, imimi lua mesape sur ya nap̃a meviun tan ko nagane, mesape otam̃an van imimi.” ");
INSERT INTO lww_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ana Yesu pisatam̃e la, pisape “?Ana amiu lua sinemiun asape in na nekila ya ne van amiu?” ");
INSERT INTO lww_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Apisatam̃ea, asape “Imimi lua sinemimin mesape otam̃an sanini: pogos nap̃a ko na ovim ove p̃arin sup̃e na yomerava nini, p̃isi na mekilia metotano memio ko e kiom̃a yo wa metava lavisin ko, tai te lepas na p̃amarua, a tai e lepas na p̃am̃eli.” ");
INSERT INTO lww_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ana Yesu pisatam̃e la, pisape “Amiu pe akilia re sur ne apiun ke ne poli. ?Sanape, amiu lua nene asitom asape atorokin nap̃a tomunpae e piala naloge viowaena nene nap̃a in na monar nemun ea? ?Ana amiu asitom ke asape amiu akilia atol nakeena e wii nap̃a akee in ea?” ");
INSERT INTO lww_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Lalua apisa pania, apisape “Ee, imimi lua metoroki.” Ana Yesu pisa pan la, pisape “Ee, lelaga nap̃a p̃isi na amiu amun m̃ena ga e m̃au piala naloge viowaena nene, ana pe lelaga nap̃a atol nakeena e wii nakeena nap̃a akeenu ea, ");
INSERT INTO lww_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ana sur nene nap̃a amiu lua apiunia, asape atotano amio inu e lepasneu luwoka, sur nene naga pe kiau re nap̃a nela van amiu poli. Yo la ne sanene, kiena ga la nap̃a Ata kila ruru pe kiela, pisaar p̃isi rui pisape p̃isi na atotano ea.” ");
INSERT INTO lww_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ana pogos nap̃a nalogena tap̃ena la lualima nene amloge sur nene, nap̃a wenla lalua nene Semes amio Yoane apiunia, la sinela kar lalua. ");
INSERT INTO lww_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ana Yesu pio la apimi puna vena naga visi van la, ana pisape “Amiu akilia ruru p̃elaga kiena ne yaru la nap̃a pe amlelaga re e Ntewa poli. Tepisu sa nap̃a sup̃e lala amio yerkawa lala na yomerava, la sinelan asape am̃areran yaru tap̃ena lala asu vatanon la silaga. ");
INSERT INTO lww_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","“Ana amiu kiau nalogena lala, kiamiu p̃elaga monar ve ve sa re nene. Visae amiu yar tai sinenan sape imi ve yerkawa tai pona ve kiamiu nasumonena tai, kana mrapa nena sanini: yaru nene monar imi ve sa ga yaru na yum̃ae kiamiuena tai. ");
INSERT INTO lww_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Narina Yeririna naga kila sanene p̃isi rui, nap̃a pe pimin re vena yar la aiila naga poli, naga pimin naiilalaena, a vena tam̃an kiena malena nawulplanen yeririna la ve moki.” ");
INSERT INTO lww_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","E pogos nene, Yesu amio kiena nalogena lala apim asike garu Seriko, ana pogos nap̃a amligan yo e pulkumali nene apano, ana yeririna la moki pap̃isi ataveve la. Pog nap̃a amiyal ke apano, ana kilamara kata tai tom̃a tano e isinen mraplepa. Yar nene, arimana kiena kia Timeas, ana apio kia kiena ne narina asape P̃atimeas. P̃atimeas nene, totano e mraplepa legiena punu ga, pion ke pan yar lala sape akuan narin kururu varu vania vena iilaena kiena malena. ");
INSERT INTO lww_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ana pogos nap̃a mloge apisape Yesu nae Nasaret mial ke e mraplepa pimi, p̃isi na naga pion ke, sape “!Yesu-o, ko lus kiena ne Tepet, nesape ko sinem̃a ye inu wa!” ");
INSERT INTO lww_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ana yaru tap̃ena la apisin sinemimien pania, asape “Ee, ve om̃aaga re.” Ana naga pion manene la pavini, sape “!Sup̃e-o, ko lus kiena ne Tepet, awis, nesape sinem̃a ye inu.” ");
INSERT INTO lww_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ana Yesu panar sum̃alu su mrapa e yo nene, pis pan yeririna lala, pisape avio yar nene vim lavis puna, ana lala apa apisa pan kilamara kata nap̃ane, asape “Welu.” Ana naga sape “P̃asa.” Ana lala apisape “Ve ologe re viowa. Yesu nap̃ane sape oim puna wa. Ko osum̃alu, ita.” ");
INSERT INTO lww_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ana yaru nene kuanlua m̃ana kulkota, sum̃al veraga ga, pimi puna. ");
INSERT INTO lww_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ana Yesu piun tania, pisape “?Ko na sinom̃an osape nekila ya ne van ko?” Ana naga pisatam̃ea, sape “Sup̃e, awis, in na sineun nesape kilamarau la imi wo, vena nekilia nekirava.” ");
INSERT INTO lww_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ana Yesu pisa pania, pisape “Pogaga, ko na okilia ova si um̃a mom̃a. Kiom̃a nalelagaena ga kila ko opim omloge po narui.” Ana naga pisu ruru ke ga suria e pogos nene, ana mial taveve Yesu e mrapa apano. ");
INSERT INTO lww_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nanagane, Yesu lala apam lavisin Yerusalem narui, ana la am̃alivi e narin pulkumali lalua sumo, kiela kia Petpas amio Petani, nap̃a sike e yepas nen kunus nene nap̃a la apio asape Kunus Na Purolip Lala. Ana Yesu miila kiena nalogena la lua, pisape ");
INSERT INTO lww_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Amiu lua ava e pulkumali na gare, a mesmes ga e pogos nap̃a ava loyum̃a ea, p̃isi na avisu narin togki tai, nap̃a am̃atear teke na, pe yar tai totanoli re e wosia poli wa. Ana alup̃arlua aure imi pun inu e nini. ");
INSERT INTO lww_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ana visae yar tai vis van amiu vanonia, viunia visave ‘?Amiu akila sanene vanon ya?,’ p̃isi na avisa ga vania, avisave ‘Sup̃e na sinenan sur mal nini vena va kila kiena yum̃aena tai wa, p̃isi na naga ligan wasup̃e sina ve ve piavi re.’” ");
INSERT INTO lww_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ana p̃isi na nalogena lua nene apano, am̃al narin togki nap̃ane, apiaria teke na sike ga vanua e mratava na yum̃a tai lavisin ga mraplepa. Pogos nap̃a asape alup̃arlua kana kilika, ");
INSERT INTO lww_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ana lala nap̃a asike e yo nene apiunia, asape “?Amiu akila ke ya ne, amlup̃arlua ke kana kilika na ya ne?” ");
INSERT INTO lww_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ana la apisa pan la visena la nap̃a Yesu pisa ruru pan la, nap̃a sane avisa van yar la nene, ana la atam̃an asape akilia aure togki vano pogaga. ");
INSERT INTO lww_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","P̃isi na lalua ap̃ere togki nene pimi, ap̃atetae m̃ala kulkota lala e wos nena, ana Yesu pa totano metava ea. ");
INSERT INTO lww_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ana yar la moki liu nap̃a ap̃atetae m̃ala kulkota lala suvileviles nen mraplepa, ana yaru lap̃asia apa ate m̃am̃ela lala pitomi ap̃atetae m̃ena ga, vena togki yal ea. Sanene narui, akila sa nap̃a la apatanon Yesu sa nap̃a pe pupia p̃arin sup̃e tai. ");
INSERT INTO lww_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ana la amial ke apano vena ava loyum̃a Yerusalem, ana p̃ina na yeririna la nap̃a asumon Yesu, amio la nap̃a asiraunia, asum̃a apiovion manene sanini, apisape “!A ke suwala, pona po! !Teyeluar naga! !Ntewa na mava, ko ovisa ruru naga nene nap̃a pimi e kiom̃a kia! ");
INSERT INTO lww_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","!Ita tekekaran pap̃isi nasup̃enena kiena ne kieta yermarua Tepet nap̃a pimi ke! !Amiu nae mava peni, amiu m̃ena ga ayeluaria!” ");
INSERT INTO lww_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ana Yesu pa loyum̃a Yerusalem, a pa tol Yum̃a Wa m̃ana ne Ntewa. Ana pa loyum̃a, pisuveve yo lala, a sur la punu ga nap̃a amiyum̃aen ke ea, pano-o mrae naga pato ke tano narui, naga pure kiena lualima taaga pa lua, apetan si pupia kumali nap̃ani, apa amono gar Petani. ");
INSERT INTO lww_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ana yemlagi kolulagi la amligan si ma Petani ap̃asup̃e sina vena ava Yerusalem, ana Yesu mloge sane viso karia. ");
INSERT INTO lww_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Naga kira pa e is nen mraplepa, m̃al purpik tai sike, ana naga mial pa lavisinia vena war mras lap̃asia. Ana pogos nap̃a pimi pisuia, purpik nene m̃as ga moki, ana pe mras su re e poli, komin pe kana pog re poli wa. ");
INSERT INTO lww_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ana Yesu pisa pan purpik nene, pisape “Ko ove owar re si mrasnom̃a pogos tai vena yar la akilia akania.” Ana kiena nalogena m̃ena la amloge ke nap̃a naga pisalele kare laki na sanene. ");
INSERT INTO lww_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ana Yesu la apa atol si Yerusalem narui, lala apa sina ga loyum̃a e Yum̃a Wa m̃ana ne Ntewa. Ana e pogos nene naga pisu sane yar la moki liu nap̃a asum̃a e yepas nen yum̃a nene, la asum̃a akila ke ga yum̃aena natauluen kilavaru lala ea, ana yar la mok liu nap̃a apul ke sur la nap̃a ap̃iliwilin ke ne. Ana naga pe kekaran re nenaga, pa m̃ene plan la, kawepu narin varvara kiena ne yar nakeueen varu sa le Rom la pimi ve sa le Yu la, nakilaena nalaena. A naga koantetain lele na totanoena kiena ne la nap̃a apuliwilin ke kupa nakup̃ap̃aena lala. ");
INSERT INTO lww_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A naga pisawo m̃ena ga yar la nap̃a sinelan ke asape awar kiela sur na yum̃aena la ayal akom likan yepa na Yum̃a Wa nene. ");
INSERT INTO lww_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ana naga pisa pian la, pisape “?Sanape, amiu pe akilia re asape Ntewa pisa e kiena Visena Wa, sape ‘P̃isi na la avisa m̃au Yum̃a Wa avisave naga yum̃a nalotena kiena ne yolai punu ga e yomarava wetelu’? ‘Ana nanagane na amiu akepu pimi sa ga ponovi m̃ana yaru na vinauena la narui.’” ");
INSERT INTO lww_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ana pe piavi re nena, yerkawa lala kiena ne yaru wa lala, amio navianena na navisaluaena lala, amloge sur la nap̃a Yesu kila e Yum̃a Wa m̃ana ne Ntewa, ana la sinela kar pap̃isi, asape akila suriania. Ana amaraun Yesu, pe akila re si poli, vanon apisu kilale nap̃a yeririna la akekaran naga pap̃isi, asum̃a amilan ke kiena navianena wo lala. ");
INSERT INTO lww_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ana pogos nap̃a mrae pato pa tano narui, Yesu la apetan ke sina ga yo nap̃a Yerusalem. ");
INSERT INTO lww_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ana kolulagi, la ap̃asup̃e apa ke si Yerusalem, ana apisu purpik nap̃ane, m̃as la miaiai make nena rui. ");
INSERT INTO lww_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ana Pita sitom̃al si visena kiena ne Yesu, pisa pania, sape “Sup̃e, opisu ke ne! Purpik nap̃a opisanena kare nakoneva, nagane mare rui.” ");
INSERT INTO lww_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ana Yesu pisatam̃ea, pisa pan la, pisape “Amiu punu ga monar aviawa m̃arera e Ntewa. ");
INSERT INTO lww_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","In na nepisa ke pe lelaga pan amiu, visae yar tai nap̃a pe kiena sitomena peve lua re poli, a mlelaga m̃arera, ana visae suri ya nap̃a naga visa, monar ve sanene narui. Visae naga vis va pupia kunus nene, visave ‘Osum̃alu otove, oula ova e sive,’ p̃isi na monar ve sa ga nene. ");
INSERT INTO lww_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nane nepisa pan amiu, ana sur ya ne ko na oviunia e kiom̃a leniena, visae olelaga m̃arera sane sur nene pe kiom̃a pa rui, p̃isi na monar ve sa ga nene narui. ");
INSERT INTO lww_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ana e pogos punu ga nap̃a visae alen, amiu monar asitom ruru m̃ena ga, visae kilapurpu tai teke e ko amio yar tap̃ena tai, monar oviewo sumo wa, p̃isi na okilia osum̃alu okila kiom̃a leniena van Ntewa. Visae okila ve sa nene, yoko arimata nae ma e peni, naga m̃ena sitom̃al ko, viewo kon kiom̃a mlamulena viowa lala.” ");
INSERT INTO lww_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ana Yesu la ap̃asup̃e si apam atol Yerusalem, ana apa si loyum̃a e kove na Yum̃a Wa m̃ana ne Ntewa. Ana pogos nap̃a amialoro ke loyum̃a, yerkawa kiena ne yaru wa lala, amio navianena navisaluaena, a nasumonena lala kiena ne le Yu la, apimi puna, ");
INSERT INTO lww_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","apiun tania, asape “Ko osum̃a okila ke sur la ne sanene e yo nini e kia kiena ne ai? Ana a si na pisa pan ko sape okila ve sanene?” ");
INSERT INTO lww_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ana Yesu pisatam̃e la, pisape “Pogaga, ana inu m̃ena nesape neviun naviunena tai van amiu wa. Visae amiu avisatam̃e ruru kiau naviunena nene wo, p̃isi na nekilia nevisawal van amiu sanape nap̃a nekilia nekila ve sanene. ");
INSERT INTO lww_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ana kiau naviunena naga sanini narui, sape: ?Nakeena nap̃a Yoane naga kilamare ga nanua ne e yaru lala, naga pe sur tai nap̃a Ntewa pisa pania sape naga monar kila, pona yaru ga la apisa pania? Amiu avisatam̃eli kiau naviunena nene.” ");
INSERT INTO lww_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ana naviunena nene kiena ne Yesu kila la agorua la narui, nap̃a asum̃a apisa asape “?P̃isi na ita tevisa sanape na vania? !Tevisuaruruia! Visae ita tevisa tevisave nakeena nene Ntewa naga pisa pa Yoane, p̃isi na yaru nene viun si vetan ita, visave vanon ya ne ita pe temlelaga re e Yoane poli. ");
INSERT INTO lww_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ana ita tap̃atete si tevisa tevisave nakeena kiena Yoane nene pe sitomena kiena yeririna ga lala, visae peraga, la sinela kar ita.” Yar keviu la amaraun visaena visen nene, komin akilia asape yeririna la nene amlelaga ke po m̃arera e Yoane p̃isi rui, asape naga pe navisawalena na lelaga tai kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ana kiela sitomena la ne sanene narui, kila apisatam̃e Yesu sa ga nini, apisape “Imimi memninue ga.” P̃isi na Yesu pisa pan la, pisape “Visae sanene, inu m̃ena ga, tap̃atete nevisa van amiu nevisave ane pisa pan inu sape nekila yum̃aena la ne sanene.” ");
INSERT INTO lww_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ana pogos nap̃a Yesu sum̃a pian la ke, naga pisayu ke p̃akaiwa pan la. P̃akaiwa tai na pisa sa nini, pisayu yerkawa tai, amio kiena lokilkerep. Yaru nene kila ruru kiena yo nene, kila kove m̃arera tai telivi piora ea, a kila kana lele navieplanen was nen kerep, kila m̃ena kana lele tai nap̃a pa metava nap̃a yaru kilia wiyu va se ea, vena kiravawoen lokilkerep nene. “Ana e pogos tai, yerkawa nene sinenan sape yaloro re va e purvanua tap̃ena tai, p̃isi na mligan kana lokilkerep nene e limana ne yaru lap̃asia, vena ayum̃aenia, aul vania. ");
INSERT INTO lww_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Ana yerkawa nene pa sum̃a gare pano-o, p̃isi na pisu kilale sane nanagane na pogos na mrakerep la marua narui. Ana mligan kiena yaru tai pa si puna ne la nap̃a asike e kana lokilkerep nene vena war kiena kilavaru na mrakerep komp̃asia, nap̃a la nene monar aul vania. ");
INSERT INTO lww_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ana pogos nap̃a kiena yaru nene pano, ana yaru tap̃ena la nene am̃e kare naga, am̃enelua sina naga pano, pe mla re sur tai poli. ");
INSERT INTO lww_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Ana yerkawa nene miila si kiena yaru tap̃ena pano, ana la nap̃a am̃ea, p̃ar kuruta e p̃arina, akila piowa pan naga pap̃isi, am̃enelua pa sina. ");
INSERT INTO lww_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","P̃isi na naga miila ke sina ga tap̃ena tai, ana am̃emom̃ar naga mare, siraunia, naga miila kiena yeririna moki apano, asula am̃emom̃ar la m̃ena ga. ");
INSERT INTO lww_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ana yerkawa nene pisu sane yar taaga sike narui, pe narina wawa nap̃a naga kekaran pap̃isi, ana naga sitomveve pano-o, pisape ‘In na monar neligan ga naruu vano, vena monar avatanon naga.’ ");
INSERT INTO lww_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ana pogos nap̃a yar viowa la nene apisu narina ne yerkawa nene pimi, la asum̃a apismumun pan la, asape ‘Narina ne ke yerkawa nam̃a narui. Yaru ke na nene narui, nap̃a visae yerkawa kovio, p̃isi na kus porotano nene sane ve kiena lalimana. Popon ita towem̃ar m̃ena naga mare, ana ita ga tekilia tokus porotano nene ve kieta.’ ");
INSERT INTO lww_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ana sanene narui atarar naga, am̃em̃aria, akovenlua naga petan lokilkerep pa vanua.” ");
INSERT INTO lww_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ana Yesu piun tan la, pisape “?Pogos nap̃a yerkawa nene yoko imi sina, p̃isi na kila sanapen la nap̃a amiyum̃ae ke e kiena yo nene? Yaru viowa la nene, p̃isi na yerkawa nene imi wem̃ar la, monar amare e p̃elaga m̃arera tai, siraunia naga ligan kiena lokilkerep e limana ne yaru wo tap̃ena la p̃asia.” ");
INSERT INTO lww_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ana Yesu pisa pan la, pisape “Visena tai teke e Visena Wa kiena ne Ntewa, pisa sanini pisape ‘Kilavaru nene, yaru na yum̃aenen yum̃a lala apisa asape piowa ga, akoven rui, ana nanagane na, kilavaru nene pimi pe kilavaru wo na mrapun yum̃a, ve nauararen yum̃a m̃arera. ");
INSERT INTO lww_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ana sur nene, Ntewa ga kila, a mepisuia na po na po.’” “?Ana sanape, visena nene akilia pa rui, apuloli m̃a pogos tai, pona peraga yo?” ");
INSERT INTO lww_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ana pogos nap̃a Yesu pisa pae p̃akaiwa nene, yerkawa lala akilia nap̃a naga sum̃a pisa ke ga visena la nene vanon kiela p̃elaga lala, ana sinela kar naga, kila narui sinelan asape auarar naga, p̃isi narui na apisu sane yar la mokliu, amaraun la, amligan naga m̃eke na ap̃ure apano. ");
INSERT INTO lww_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ana yar keviu lala apa apisuveve sur nene, lala amligan Varasi lap̃as apimi, amio m̃ena ga p̃asia e p̃egas kiena ne Erot, nap̃a apiunli naviunena m̃arera lap̃asia ve natap̃alien Yesu ea, nap̃a sane naga visatam̃e p̃ele ga. ");
INSERT INTO lww_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ana apimi puna ne Yesu, akila kotalia e visena wo lala, apisa asape “Navianena, imimi mekilia ko na ope lelaga kemua. Ko ope omaraun re yar tai poli, sane yar keviu, pona yar nap̃a to metava, po yar na sanape, ana ko osum̃a apisalua ke mrapa mesmes kiena ne Ntewa pan la punu ga. Ana mesape meviunli tan ko, mesape kieta navisaluaena pisa sanape? ?Pisape mesmes ga nap̃a ita le Yu toul takis va Sisa, nap̃a pe p̃arin sup̃e kiena ne le Rom lala, pona pe mesmes re sanene poli? ");
INSERT INTO lww_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","?Pogaga nap̃a toul takis la nene po peraga?” Ana Yesu kilia m̃aga nap̃a la apiun kotalia ga, sinelan ke asape akila kare naga, ana naga pis pan la, pisape “?Amiu asum̃a atap̃alinu ke sanene vanon ya? Pogaga, amiu ala kilavaru tai imi vena nevisuvevelia.” ");
INSERT INTO lww_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ana amla tai pimi, akian pania, Yesu piun tan la, pisape “Ninun marana a ne teke e narin kilavaru nene? ?Ana kia na asiri teke ea, ane kiena kia nene?” La apisape “Marana ne P̃arin Sup̃e Sisa nene, a kiena kia m̃ena ga.” ");
INSERT INTO lww_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ana pisa pan la, pisape “Pogaga, sur nap̃a kiena ne Sisa, monar ala va Sisa, a suri nap̃a kiena ne Ntewa, monar ala va Ntewa.” Ana pogos nap̃a amloge navisatam̃eena nene, amilan kare pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ana siraunia, le Satusi lap̃asia apimi puna ne Yesu, sinelan asape aviunli suri tai tania e lepas na sur tai nap̃a la amlelaga m̃arera ea, asape sa yaru la nap̃a amare, tap̃atete amal sina e legiena maro. Vanon suri ne nanene apiun tan Yesu sanini, asape ");
INSERT INTO lww_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Navianena, sinemimin mesape meviunli tan ko sanape e visena tai nap̃a yermarua Mosis siri pan ita nanua sumo. Naga pisa pisape visae yaru tai, mare tan wona nap̃a sane pe narila re tai poli wa, p̃isi na wenla yaru nene monar talopa sina amio letano nene. Ana visae sira nene war sisi, akilia asikia e kia kiena ne arimana nap̃a mare pa rui, vena kia nene mali m̃aga. ");
INSERT INTO lww_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ana e pogos tai, wenla la olua. Kiela m̃earu talopa, ana naga mare petan wona, pe narila re tai poli wa. ");
INSERT INTO lww_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ana wenla nasiraunia p̃ereleinia pe wona, p̃isi na naga m̃ena ga mare petania, pe narila re tai poli, a wenla na telu kila m̃ena ga sanene, ");
INSERT INTO lww_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","pano-o tol wenla na olua, la punu ga amarmare tan sira nap̃a sanene. A siraun wona la punu ga nap̃a amarmare, sira m̃ena ga nene mare. ");
INSERT INTO lww_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ana ko ovisali sur nene: ?E legiena maro, pogos nap̃a apisa ke asape p̃isi na yaru la amal sina, p̃isi na sira nene na ve wona ai, vanon nap̃a naga talopa amio wenla la olua nene p̃isi rui?” ");
INSERT INTO lww_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ana Yesu pisape “Peraga, kiamiu sitomena pa pe wowe laa. ?Pona kam na pe akilia re ya ne kila amiu ape wowe ke sanene poli yo? Vanon pe akilia re ya nap̃a Visena Wa kiena ne Ntewa pisa ke poli, a pe akilia re m̃ena ya nap̃a kiena nam̃areraena keviu kilia kila poli. ");
INSERT INTO lww_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pogos nap̃a yaru la amal sina, p̃isi na lala ave sa ga navisi kiena ne Ntewa lala ma e peni narui, ana p̃isi na ve akila re si suri nene nap̃a natalopaena. ");
INSERT INTO lww_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A e lepas na malena si nene, kana visena tai teke e tusi nap̃a Mosis naga siria, nap̃a pisayu ke narin laki tai nap̃a kapi kekania, nap̃a Ntewa pisa pa Mosis sanini, pisape ‘Epraam, Aisak, a Sekop, in na nepe kiela Ntewa.’ “?Pona amiu na pe apuloli re visena nene pogos tai poli yo, ");
INSERT INTO lww_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ana in na nevisakilale van amiu vena kila ruru kiamiu sitomena lala. La telu nene la amare e yomarava nini nakonua rui, ana kas moki na moki p̃aro pa rui, ana Ntewa pisa ga visena nini na wa, nap̃a sape naga pe kiela Ntewa. Sanene na kiena visena naga kana kinasia sape la telu nene la amare e yomarava, ana la amal ke ma puna na wa. Ntewa pe sinenan re sape kiena yeririna lala la ave yaru la nap̃a amare poli, ana naga sinenan sape naga ve Ntewa kiena ne yeririna la nap̃a amali.” ");
INSERT INTO lww_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ana navianena na visaluaena tai pimi sum̃alu sike e pogos nene, ana miyagogan ke le Satusi lala atap̃ali ke Yesu, ana Yesu taulu la ga e kiena navisatam̃eena wo lala. Ana navianena nene, naga sitom sape naga towe lai viun va Yesu, pisape “?E kieta navisaluaena lala, nape nap̃a keviu, miyuve tap̃ena lala?” ");
INSERT INTO lww_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ana Yesu pisa pania, sape “Visena Wa pisa sanini, pisape ‘Yeririna nae Israel, amiu ayagoga. Ntewa na mava, kieta Ntewa, naga taaga pe Ntewa na mava. ");
INSERT INTO lww_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ntewa na Mava nap̃a pe kiom̃a Ntewa, ko na monar sinem̃a sia e losinem̃a wetelu, e kiom̃a malena wetelu, e kiom̃a sitomena wetelu, a e kiom̃a puriukawaena wetelu.’ ");
INSERT INTO lww_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Nanene naga pe navisaluaena p̃esia, a nalua nena naga pisa sanini, pisape ‘Ko monar sinem̃a si nalavis pum̃a lala, okila wo van la, sa ga nap̃a ko sinem̃a si ko ke ga.’ “Ana pe navisaluaena re si tai poli nap̃a naga keviu taulu lalua nene.” ");
INSERT INTO lww_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","P̃isi na navianena navisaluaena pisatam̃e pania, pisape “Lelaga ga navianena, ko opisa mesmesu ga. Ko opisa pe lelaga ga, osape yar keviu naga taaga ga, pe tai re si poli. ");
INSERT INTO lww_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ana ko opis pe lelaga m̃ena ga osape monar sineu si naga e sineu wetelu, e kiau nakiliaena wetelu, amio kiau puriukawaena wetelu, ana monar sineu si la nap̃a asike lavis pun inu, sa ga nap̃a sineu si in ke ga. Pe lelaga ga ne, e nakiravaena kiena ne Ntewa, visae nekila ve sa nene, nanene naga to laa metava, po manene laa taulu make nakup̃ap̃aena lala nap̃a netap̃a ke e m̃ana Yum̃a Wa.” ");
INSERT INTO lww_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ana Yesu mloge kiena navisatam̃eena naga po, pe manmarua po, ana pisa pania, pisape “In na nevisa van ko, sane ko ko na osike pa lavisi rui, ko na yoko p̃isi na ova loyum̃a e nasup̃enena kiena ne Ntewa na wa.” Ana siraun e pogos nene, p̃isi na pe yar tai tap̃ali re si Yesu e naviunena la poli. ");
INSERT INTO lww_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ana siraunia, Yesu naga pian ke yeririna lala e Yum̃a Wa m̃ana ne Ntewa, ana naga towelai piun naviunena tai pan la. Naga pisape “?Nekilia m̃aga nap̃a kiamiu navianena navisaluaena lala apian amiu m̃aga, ana nesape neviunlia, komin ya nap̃a apisa ke asape Navisaarena naga monar m̃alivi e lus kiena ne yermarua Tepet nene nap̃a naga pe p̃arin sup̃e sumo? ");
INSERT INTO lww_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nepiun ke sa nene, komin nanua sumo, Ninuna Wa pimi e Tepet, kila naga pisi, pisape ‘Ntewa na Mava pisa pa kiau Sup̃e, pisape “Ko ototano e kiau lepas na p̃amarua, otom̃ate m̃a vano-o, p̃isi na neligan kiom̃a nasinekar lala aimi ve sa narin takue na vilanvanen lam̃a ea.” ’ ");
INSERT INTO lww_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“E lele nene tepisu nap̃a Tepet sum̃a pio ke Navisaarena nene sape pe kiena Sup̃e rui. ?Ana vanon nap̃a Tepet pisa sanene, a sanapen nap̃a amiu apisa ke asape Navisaarena nene naga molue ga e Tepet, ana naga pe kiena lus ga tai?” Ana pupia p̃ina nap̃a asike e pogos nene, lala sinelan manene navianena kiena Yesu la ne sanene, la akekaran manene pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ana e pogos nene nap̃a Yesu naga pian la ke, pian lan la ke m̃ena ga e p̃elaga na yeluarlaena kiena ne kiela nasumonena lala. Naga pisape “Amiu avisuar amiu e navianena navisaluaena lala. Lala aplave ke pap̃isi e m̃ala kulkota piayavi lala, a pogos nap̃a visae la ayaloro e lele na wilwilinena, sinelan asape yaru lala monar avatanon la, a avio ruru la avisave ‘!Navianena, pokolulagi!’ ");
INSERT INTO lww_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","A e pogos na p̃ap̃agena lala, a loyum̃a e nalotena m̃ena ga lala, la sinelan nap̃a silaga asape atotano ga e lelen yerkawa lala. Amiu apisu kilale la ke narui, ne? ");
INSERT INTO lww_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ana lala asum̃a ap̃ure piavin ke kiela leniena la pap̃isi, ana apisokani ke ga ne, vanon nap̃a e ke e pogos nene, lala asum̃a akila kotalia ke letano la, vena avinaun kiela suri lala. Ana vanon suri ne nanene, p̃isi na kiela nakoaena m̃arera re laa sane.” ");
INSERT INTO lww_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ana siraunia, Yesu naga pa laa lavisin yo nap̃a akuan ke varu ea e Yum̃a Wa nene, ana kira pisulili ke yar lala nap̃a akuwakuan ke kiela nalaena lala. Naga pisu yar la moki nap̃a kiela sur la mokliu, ap̃ar kiela nalaena kerkeviu la pimi, akuwania. ");
INSERT INTO lww_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ana p̃isi na pisu m̃ena sira marua tai pimi, naga letano tai, pe kiena sur re poli. Ana naga mla narin kururu varu lua pimi, mla pan Ntewa. ");
INSERT INTO lww_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","P̃isi na Yesu pio kiena nalogena lala vena aim puna, naga pis pan la, pisape “?Amiu apisu ke sira marua nene, nap̃a kuan narin varu lua ga nene? In na nevisa ve lelaga van amiu, naga mla keviu taulu make nalaena punu ga nap̃a yar la nap̃a kiela sur la moki amlavia. ");
INSERT INTO lww_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Lala nene, kiela varu keviu pap̃isi, ana amla ga komp̃as tekak ga pano, ana letano nene, narin varu nap̃a naga mlararia vena iilaena kiena malena, mla punu ga pan Ntewa.” ");
INSERT INTO lww_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ana Yesu molue e Yum̃a Wa m̃ana ne Ntewa, ana pogos nap̃a naga sum̃a mial pa ke, kiena nalogena lala tai kilologia pupia yum̃a lala na Yum̃a Wa nene, pisa sape “!Navianena, ovisuia! !Yum̃a la nene amio kana kilavaru lala apo pap̃isi wa!” ");
INSERT INTO lww_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ana Yesu pisa pania, pisape “?Opisu ke pupia yum̃a la nene? Yum̃a la nene, p̃isi na tap̃atete si kana kilavaru ne tai nap̃a tom̃a ga towawa ruru teke e lelena, komin p̃isi na yar lap̃as aimi, awe plan make nena yum̃a la nene vano.” ");
INSERT INTO lww_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","La amial sanene, apim e Kunus Na Purolip lala, nap̃a kira pisu ke Yum̃a Wa, ana Yesu totano e yo nene. A pogos nap̃a pe yaru tap̃ena la asu re poli, kiena nalogena la vari apimi puna, Pita, Semes, Yoane amio Antru. Ana apiun tania, asape ");
INSERT INTO lww_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“?P̃isi na awe plan Yum̃a Wa nene pogwai, a kile ya ne yoko kila sur la nene vim kakate?” ");
INSERT INTO lww_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ana Yesu pisatam̃e la narui, pisape “Popon amiu avisuar ruru amiu, vena ve yaru imi visa kotalia amiu re, ");
INSERT INTO lww_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","vanon nap̃a p̃isi na yaru la ve moki nap̃a ala kiau kia, ana aimi avisave ‘In na nepe Navisaarena p̃a,’ ana p̃isi na aure yaru la ve moki ava ave wowe. ");
INSERT INTO lww_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ana visae e pogos nene, aloge m̃aagena na mara pimi ke lavisi, pona alologon pupia mara la nap̃a sike perina, ana ve sinemiu kurkur manene re. Suri la nene monar imi kakate sumo, ana nanene na pe pe legien maro re poli na wa. ");
INSERT INTO lww_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","A p̃arin sup̃e lala, yoko akila mara amio p̃arin sup̃e tap̃ena lala, a purvanua lala yoko asum̃alu akawela amio purvanua tap̃ena lala. A yo kar ga e yomarava nini, yoko yemninu vap̃isi, a pupia viso m̃ena, ana suri la nene, pe pe legiena maro re nene poli na wa. Ana suri la nene sa ga sira nap̃a m̃ep̃ena, nap̃a sane mloge p̃esan m̃asina mlaea vena waren sisi, ana pupia naloge viowaena naga pere na wa. ");
INSERT INTO lww_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ana monar avisuar ruru amiu, sa p̃isi yaru la aure amiu ava e kiela kumali, pona e kiela yum̃a na lotuena lala, vena avis van amiu, ala nakoaena van amiu, pona awe amiu. Yoko monar aligan amiu ava asum̃alu ase marana ne yerkawa na purvanua vanon ga nap̃a amiu ape kiau nalogena lala, ana e pogos nene amiu akilia avisawal kiamiu nalelagaena e inu e marala. ");
INSERT INTO lww_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","A lologena wo, yoko alologon va yolai la punu ga e yomarava nini sumo wa, p̃isi na sur la nene kilia imi m̃alivi. ");
INSERT INTO lww_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ana visae la nene aim atarar amiu, aure amiu avano vena ala nakoaena van amiu, amiu na ve asitom manene re avisave ‘?P̃isi na nevisa ya ne van la ne?’ Ana avisa ga visena nap̃a p̃isi na Ninuna Wa la van amiu, mesmes ga e pogos na visena, vanon pe amiu re apis poli, komin Ninuna Wa ga naga vis e amiu. ");
INSERT INTO lww_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“E pog m̃arera nene, yoko yar kilia tam̃an yaru viowa tap̃ena la aimi aurelua wenla ruru naapo pona narila ruru naapo, vena awe mom̃ar la, nanene komin nap̃a la nene amlelaga e inu. A nin sisi m̃ena ga lala akilia asum̃alu avisawal anela lala amio arimala lala nap̃a la amlelaga e inu, vena lala m̃ena ga amare sanene. ");
INSERT INTO lww_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ana yoko yaru la sinela kar manene amiu, nap̃a kiau kia teke e amiu, a amiu yaru a nap̃a sum̃alar m̃arera sum̃a ga vano-o pog m̃arera nene p̃isi, Ntewa tamalia naga.” ");
INSERT INTO lww_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ana Yesu pisa m̃ena ga visena tap̃ena tai, nap̃a popon yaru kilia wuloyuia, vena kilia ruru kana kinasia. Visena nene sanini, pisape “Yoko amiu akilia avisu nap̃a avisirlua nono tai nap̃a piowa manene laa, yoko sum̃alu se e yo wa tai pe pon re nena nap̃a aligan se ea. A pogos nap̃a avisu suri nene, amiu nap̃a asike Yutea, popon amiu aure, ava atapolou e kunus lala. ");
INSERT INTO lww_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","E pogos nene, visae yaru tai va ruru teke vanua lavisin m̃ana yum̃a, naga monar ve va re si loyum̃a war kiena suri lap̃asia, ");
INSERT INTO lww_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","pona visae yaru sike e kana lokove, naga monar ve vito re si um̃a tar m̃ana kulsota, naga monar kiriri vitap̃ili ga sanene vano. ");
INSERT INTO lww_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ana e pogos nene, yoko viowa laa m̃ena van sira la nap̃a mep̃ela, amio la nap̃a amla ke yu pan kiela sisi tomtom lala. ");
INSERT INTO lww_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Visae ve sanene, popon amiu alenwo amiu vena kiamiu pog naureena nene ve imi tol amiu re e pog na miava keviu. ");
INSERT INTO lww_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nanene vanon pogos nene, p̃isi na m̃arera na m̃arera, m̃arera laa sane taulu pogos m̃arera tap̃ena lala, nap̃a siar e pogos nap̃a Ntewa sii yomarava nini pimi tol nanagane, a yoko ve pog m̃arera re si tai ve sanene pogos tai. ");
INSERT INTO lww_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ana Ntewa sitom̃al rui pisape yoko tero pog m̃arera nene imi ve plas ga, vanon kiena yeririna la nap̃a pisir plan la vena ave kiena, asike e pogos nene. Ana visae ve tero re ve plas sanene, yoko tap̃atete yaru tai kilia mal sike na. ");
INSERT INTO lww_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ana visae yaru lala avivisa van amiu, avisave ‘Amiu avisu yaru nene, naga na Navisaarena nene,’ pona avisa tap̃ena, asape ‘Nane Navisaarena ne nane gare,’ ana amiu na ve alelaga re e kiela visena lala toko, ");
INSERT INTO lww_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","komin nap̃a navisaarena la mokliu nap̃a pe ape lelaga re la poli, la akilia asum̃alu, amio m̃ena ga navisawalena navisokanena la ve moki, a p̃isi na la nene akilia akila kile lala, amio sur nailanena lala. Ana yoko akila sanene, aure yaru la ava ave wowe, vano-o tol nap̃a akilali nap̃a aure m̃ena yeririna kiena ne Ntewa la nap̃a pisir plan la vena ave kiena, ana la tap̃atete akilia akila. ");
INSERT INTO lww_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ana akilia avisuar amiu ruruia, komin nepisawal make suri la rui pan amiu nanagane, nap̃a pe ap̃arpo yo re poli wa.” ");
INSERT INTO lww_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","A Yesu pisape “Ana e pogos nene, siraun nap̃a naloge viowaena nene p̃isi, mrae imi ve pupumalko, a kupario ve tego re sina. ");
INSERT INTO lww_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","A verue la ma e sinapane asum̃a aloloru, a suri m̃arera lala nae ma e sinapane, yoko Ntewa kululun la. ");
INSERT INTO lww_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","E pogos nene, p̃isi na la avisu Narin Yeririna molue e lul amio pupia kiena nam̃areraena amio naurarena. ");
INSERT INTO lww_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ana siraunia, naga ligan kiena navisi lala ava e yo punu ga e yomarava a ma e peni, ana yoko aure kiena yeririna la nap̃a naga pisir plan la p̃isi rui, aimi lele taaga puna.” ");
INSERT INTO lww_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ana Yesu pisape “Amiu asitomli purlaki nene, nap̃a asape purpiliva. Naga kiena sur navian amiuena tai teke ea, nap̃a monar avisururuia. Pogos nap̃a avisu sitos la siar miyunlua sina, imi memaena, ana amiu akilia asape pog na yepisusunu m̃arera pimi ke lavisi narui. ");
INSERT INTO lww_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ve sanene, pogos nap̃a avisu kile la nene e yomarava, la apimi akakate ke sa nap̃a nepisa pan amiu rui, ana amiu akilia nap̃a Narin Yeririna sum̃a ga e pulutava rui, lavisi ke kate narui. ");
INSERT INTO lww_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nevisa suri na lelaga van amiu, yoko sur la nene imi kakate sumo, ana siraunia, lus kiena ne yaru la nap̃a amal ke e pogos nene, p̃isi na akilia akovio e yomarava nini. ");
INSERT INTO lww_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","A yoko sinapane amio yomarava nini lalua m̃ena akovio veraga, ana kiau visena lala tap̃atete nena akokovio pogos tai. ");
INSERT INTO lww_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ana pe yar re tai nap̃a kilia kana legiena pona aora nena nap̃a p̃isi na Narin Yeririna m̃alivi ea. Navisi lala nae ma e peni, amio Narina ne Ntewa, la m̃ena amninue ga, ana Ata ga, naga taaga kilia.” ");
INSERT INTO lww_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ana Yesu pisape “Sanene, ana monar asum̃a avisuar ruru amiu, komin amninue ga asape kiamiu sup̃e naga imi sina e legiena ya. ");
INSERT INTO lww_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sur nene sa nap̃a yar keviu tai mligan m̃ana um̃a vena vanon kiena pupia yalena tai. Sumon nap̃a naga ligan kiena yo, naga monar ligan kiena sur la punu ga va sike limana ne kiena yar na yum̃aena lala, a monar vis ruru van la nap̃a apisuar ke mralaea, sape avisuar ruruia. ");
INSERT INTO lww_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ana nanagane sa m̃ena nene van amiu, amiu m̃ena asum̃a avisuar ruruia, komin pe tekilia re poli, yar keviu na um̃a vim pogwai. Pona imi kotap̃a, po kolemalo, pona sa lakaporo la akokoreko, po kolulagi, ");
INSERT INTO lww_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ana piowa ga nap̃a sa naga vim m̃alivin amiu, lual nap̃a kam na amomalio m̃aga. ");
INSERT INTO lww_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ana visena nap̃a nepisa ke pan amiu, mesmesun nap̃a yeririna la punu ga monar aloge, sane amiu akirarava ruruia, avisuaria.” ");
INSERT INTO lww_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ana p̃isi na, pog pimi lavisi nap̃a e kas punu ga asum̃a akila kiela pupia p̃ap̃agena lua. Legiena lua ga suwo ke wa, p̃isi na akila p̃ap̃agena na sitom̃alen natamaliaena naga sumo, p̃isi na akila p̃ap̃agena na kanen kiligap̃e naga sirau. A e legiena nene, p̃arin yar wa lala, amio navianena na visaluaena la sinelan ke asape yoko awem̃ar Yesu na wa, ana akale ke mrapa tai na tarwanen naga. ");
INSERT INTO lww_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ana lala apisayu ke pan la, asape “Sur nene tap̃atete tekila e maran yeririna la nap̃a apimi e p̃ap̃agena nene, komin visae pere na la sinela kar ita vap̃isi ne, yoko akila pupia m̃aagena, vanon la mokliu nap̃a akekaran ke pa yar nene rui.” ");
INSERT INTO lww_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ana e pogos nene, Yesu sike e kumali nap̃a Petani, naga sike e yum̃a m̃ana yaru tai nap̃a apio ke Saemon Leperosi, komin nanua susumo naga p̃ar leperosi se e yepena. Ana Yesu kinana ke e yum̃a nene, sira tai pimi puna, mla piawi tai nap̃a amiyum̃aen e kilavaru tai nap̃a po, a piawi nene na pulen ponotaninu nap̃a amiyum̃aen e was nen p̃eligalaki tai, nap̃a kana kilavaru keviu pap̃isi. Ana sira nene pilonpo gon piawi nene, taron make ga ponotaninu nene taroi e p̃arina ne Yesu. ");
INSERT INTO lww_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ana lap̃as nap̃a asike e lele nene e pogos nene, apisu ke sur nene, ana la sinela kar sira nene pap̃isi, asum̃a apisamumun ke pan la, asape “?Komin yar ne sira nene taron kare korenan ke ponotaninu sa nene? ");
INSERT INTO lww_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Visae wilwilinlua ga na, vera war varu keviu ea, vena iilaena yeririna la nap̃a pe kiela sur re la poli. Naga kila kare na!” Ana la asun apisa kare ke sira nap̃a sanene. ");
INSERT INTO lww_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ana Yesu pisa pan la, sape “?E, kam na akila ke sanene pan sira nene komin ya? Amiu na ve avisa kare re si naga, naga kila yum̃aena nap̃a po tanea pan inu, pisa ruru inu pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Li na lima korena la nap̃a apisa la ke ne, yoko lala asulue ga likan amiu, ana amiu akilia aiila la silaga e pog punu ga nap̃a sinemiunia. Ana inu, in na yoko ve nesu re silaga nemio amiu. ");
INSERT INTO lww_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Suri nap̃a sira nene miyum̃aenia, nap̃a taron ponotaninu e inu, naga kila sur wo punu ga nap̃a naga kilia kila, nap̃a pe nakilaruruen yepeu yoko neva e marena. ");
INSERT INTO lww_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nepisa ke sur na lelaga pan amiu, e yo punu ga e yomerava wetelu nap̃a avisawal kiau lologena wo ea, ana asunyu m̃ena sur nowo nene nap̃a sira nene miyum̃aenia, vena asitom̃al sina ga silaga pupia sitomena kiena e inu, nap̃a sinena miye inu lelaga.” ");
INSERT INTO lww_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ana Sutas nae Kariot, nap̃a naga m̃ena pe nalogena na lualima taaga pa lua tai, naga sitom ke pa rui nap̃a yoko wilwilinwan Yesu, p̃isi na pa pisu p̃arin yar wa lala. ");
INSERT INTO lww_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ana pogos nap̃a amloge yoko naga kila kiela mrapa na tarwan vinaunen Yesu, akekaran pap̃isi, apisaar pania, asape “!E po pap̃isi ne! Visae oiila imimi ve sanene, yoko mela narin nalaena tai van ko vanonia.” Ana e pogos nene, Sutas siar kale ke pulmas tai yoko kilia ligan Yesu va e liman yaru wa la nene. ");
INSERT INTO lww_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ana legiena p̃esia na p̃ap̃agena na kanen kiligap̃e pe Toste, naga legiena nap̃a la asum̃a akila ke nakup̃ap̃aena e narin sipsip lala vena sitom̃alena natamaliaena. Ana nalogena la apiun tan Yesu, asape “?Ko na sinom̃an osape mekila ruru kata kinanena na p̃ap̃agena nap̃a e lepas nape?” ");
INSERT INTO lww_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ana naga pisa pan lalua, sape “Ava gar Yerusalem, yoko alual yar tai kus ke pupia piawi na wii tai, imi m̃alivin amiu. Ana ataveve naga avano, ");
INSERT INTO lww_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ana yoko naga were amiu ava e yum̃a tai. Ana pogos nap̃a ava loyum̃a e yum̃a nene, amiu avis van p̃ar na yum̃a nene, avisa sanini asave ‘Kieta navianena piun ke sape awa yo kiena ne wolawa lala, vena naga memio imimi kiena nalogena lala mekilia makan kinanena na sitom̃alen natamaliaena ea?’ ");
INSERT INTO lww_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Amiu avisa sanene vania, ana naga vian amiu e pupia lele tai metava van amiu, nap̃a suri la punu ga sike pa e rui, ana yoko akila ruru sur la punu ga nakanena e lele nene.” ");
INSERT INTO lww_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ana Yesu pisa sanene pan nalogena lua nene, ana apano, amial m̃a apa atol Yerusalem. Ana e pogos nene, sur la punu ga pimi m̃alivi sa ga nap̃a Yesu pisayu susumo pan lalua. P̃isi narui na, lalua akila ruru maron kinanena na p̃ap̃agena nene kana Yesu, p̃isi na ap̃asup̃ela sina ga. ");
INSERT INTO lww_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ana kolemalo, Yesu amio kiena nalogena lala apitom garo Yerusalem, apito e yum̃a nap̃ani. ");
INSERT INTO lww_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ana pogos nap̃a asum̃a akinana ke narui, Yesu pisa pan la, sape “In na nepisa ke pe lelaga pan amiu ne, yoko amiu yaru ga tai yoko vielua inu, amiu yaru ga tai nap̃a ita tesike tekinana ke veraga nagane.” ");
INSERT INTO lww_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ana nalogena la amloge nap̃a naga pisa sanene, ana amloge piowa pap̃isi, apiun veve ke tan la peve taaga, asape “?E, in re poli?” ");
INSERT INTO lww_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ana Yesu pisatam̃e la, sape “Naga nap̃a yoko kila sanene van inu, naga pe kiau nalualima ga taaga pa lua tai, nap̃a naga yaru tai nap̃a imimi lua meputon kamimi kilaparavi e ga e pulpiala taaga. ");
INSERT INTO lww_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ana yoko Narin Yeririna naga monar mare sa nap̃a Nasiriena Wa pisayu pa sumo rui. A yaru nap̃a vielua naga, yoko viowa manene laa van naga, naga popon manene sa ve vaeme re ga rui.” ");
INSERT INTO lww_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ana pogos nap̃a la akinana ke sanene na, Yesu mla kilaparavi tai, pisa potena pan Ntewa, ana kawewowaia, kian pan la, ana naga pisa pan la, sape “Alavia, akania; nanene naga pe tasneu.” ");
INSERT INTO lww_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ana p̃isin nene, mla piala na kuruta, pisa potena pan Ntewa, ana kian pan kiena nalogena lala, ana la punu ga peve taaga amunpae ea. ");
INSERT INTO lww_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ana naga pisa pan la, sape “Nanene, naga pe tau nap̃a pe nakilaen naviranarena kiena ne Ntewa sum̃alu m̃arera silaga, nap̃a yoko tau nene naga lauwo malena kiena ne yeririna la ve moki. ");
INSERT INTO lww_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nepisaar ke pe lelaga na pan amiu ne, nesape yoko sane in na ve nemun re si kuruta pogos tai, vano vano-o nemun ga kuruta viu e navesup̃enena kiena ne Ntewa.” ");
INSERT INTO lww_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ana pogos nap̃a Yesu kila pa sanene, ana la amiyau e yauena tai nap̃a teke e tusi kiena ne Yauena lala, p̃isi na amolue petan yo nene, amiyal apa e Kunus Na Purolip la. ");
INSERT INTO lww_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ana pogos nap̃a asike e kunus nene wa, Yesu pisawal pan la pisape “P̃ane ga kolemalo, kiamiu lelagaena e inu naga loru, komin Visena Wa pisawal pa sur nene rui, nap̃a sape ‘Yoko in na nowe mom̃ar yar navisuaren sipsip, ana kiena sipsip lala yoko aureure tetai.’ ");
INSERT INTO lww_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“A pog nap̃a netaulu si marena, yoko in na nesumo neto garo Kalele, ana amiu m̃ena monar asirau atom garo lele nene.” ");
INSERT INTO lww_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ana pogos nap̃a Pita mloge visena nap̃a Yesu pisa pania, pisawolia pisape “Pona nalelagaena kiela punu ga nene e ko loru, aure vetan ko, a yoko inu, in na tap̃atete neligan ko pogos tai.” ");
INSERT INTO lww_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ana Yesu pisa pan la, sape “Lelaga nepisa ke pan ko, yoko p̃ane ga kolemalo, pogos nap̃a towa la ve akokoreko re yam ve lua wa, a ko, ko na yoko ovisawan inu yam ve telu rui.” ");
INSERT INTO lww_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ana Pita pisalup̃ar visena nene, pisaar m̃arera, sape “Visae la sinelan asape awem̃arnu m̃ena nemio ko, naga pogaga ne, ana inu, yoko tap̃atete nevisawan ko, nesape in na pe nepe kiom̃a re poli.” Ana e pogos nene, nalogena punu ga la apisa m̃ena sa nene. ");
INSERT INTO lww_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ana sirau, Yesu lala apa e lepas nen kunusia, amiyal apito tano e narin pulp̃alu tai, nap̃a kiena ki Ketsemani. Ana naga pis pan la pisape “Amiu asum̃a e nini wa. Ana in na neva nelen ve plas ga wa.” ");
INSERT INTO lww_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ana naga p̃ere Pita amio Semes a Yoane, ataveve naga, apa li la vitokak ga sane, ana e pog nene, sinena Yesu naga pimi urmi keviu, mloge piowa pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ana naga pisa pa la telu nene, pisa pisape “Nanagane, nemloge sa nap̃a ninuu naga pororowa make ga, nap̃a lavisi nemare narui. Awis, amiu asum̃ali atavilo amio inu e yo nini wa.” ");
INSERT INTO lww_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ana Yesu miyal pa laa sane, mlorun kinai, mlen pa arimana, sape “Ata-o, Ata-o, sa otam̃ania, yoko aora na pog m̃arera la nene naga ve imin in re sina. ");
INSERT INTO lww_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ko na okilia okila sur punu ga, ana nepiun tan ko vena okuslua piala naloge viowaena nene vetan inu, vena in na ve nemun re ea. Ana ko na ve okila re sa nap̃a na sinenanena kiau, ana okila ga sa nap̃a kiom̃a nasinenanena.” ");
INSERT INTO lww_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","P̃isi na, naga pimi sina ga puna kiena nalogena la telu nap̃ane, naga pisu lala amomalio pa rui. P̃isi na lala atavilo sina ga, ana Yesu pis pa Pita sape “?Sanape Saemon? Ko na omomalio? ?Komin ya ne kam na tap̃atete atavilo amio inu e aora nini? ");
INSERT INTO lww_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kam na monar avisuar ruru amiu, monar alen lue ga, vena natap̃aliena la ve akila amiu aloru re e mlamulena viowa. Pe lelaga, kiamiu sitomena m̃arera po, ana tasnemiu naga miyowo ga.” ");
INSERT INTO lww_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ana siraunia, naga pa si e yo na leniena nap̃ane, mlen, mlenin sina ga visena nap̃ane. ");
INSERT INTO lww_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ana pogos nap̃a naga p̃asup̃e sina, pisu la telu nene amomalio ke sina ga, komin atekavito pap̃isi, ana pogos nap̃a pis pan la, lala pe apisatam̃e re si suri tai pan poli. ");
INSERT INTO lww_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ana naga pavin sina, kiena leniena na telu, ana pogos nap̃a p̃asup̃ea, naga pis pan la, sape “!E! ?Amiu apa ruru amiu ke ga wa, amomalio ke ga wa? !Poga, p̃isi ga ne! Naga ne lavis ga pog nap̃a narin yeririna va e liman li viowa la narui. ");
INSERT INTO lww_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ko pogaga, amiu asum̃alu ita tetove, yar nawilwilin wan inuena, nagane pam ke lavis gar ne narui.” ");
INSERT INTO lww_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ana e pogos nene nap̃a Yesu pisa ke visen nene wa, Sutas, nap̃a naga tai lala lualima yam taaga pa lua ne, naga pimi, amio yeririna la moki nap̃a ap̃ar ke playu na mara amio kiela plaki lala. La nene, yar keviu la kiena yar wa la, amio navianena na visaluaena, amio na sumonena kiena le Yu la, lala amligan la apimi. ");
INSERT INTO lww_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Susumon nap̃a apimi, yar na wilwilinena nap̃a Sutas, naga pisap̃es kile tai pan la sumo rui, pisape “Yar nap̃a sa neva netalopan p̃esia, yar ne nanene nap̃a ita sinetan ke, ana kiamiu yar na mara la monar atararia m̃arera aure naga vano.” ");
INSERT INTO lww_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ana pog nap̃a apimi narui, Sutas miyal mesmesun ga Yesu, pis pania, sape “Navianena, pokolemalo.” Talopania, ");
INSERT INTO lww_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ana kiela yar na mara la apimi atararia asape aure naga vano. ");
INSERT INTO lww_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ana pogos nap̃a atarar sanene, ana nalogena tai p̃urelua kiena playu, sape te yar tai nap̃a nae pun yar wa la, ana naga tetereria ga p̃arina, telua kiligana komp̃as pano. ");
INSERT INTO lww_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","A Yesu pis pan yar la nene, sape “?Sanape na amiu ap̃ar kiamiu playu amio plaki lala? ?Sanape na asape aim ataranu sanene? ?Pona asitom ke asape in na nepe yar m̃arera na vinauena amio na wem̃aren yaru la yo? ");
INSERT INTO lww_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sila ga e legiena punu ga, in na nepian amiu e yum̃a m̃ana Ntewa, ana sanape na amiu pe apim ataranu re e pogos nene poli? Ana pogaga, kome sur la nap̃a nasiriena wa pisayu sumo rui, monar imi ve sa ga nene.” ");
INSERT INTO lww_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ana e pogos nene, nalogena la amligan Yesu, ap̃ure petania. ");
INSERT INTO lww_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ana e pogos nene, yar m̃ee tai taveve ke yar la nap̃a ap̃ure ke Yesu pano, ana naga pitavi ga. Ana yar la nene p̃asia apisulup̃ar naga, asape atarar m̃ena naga, ");
INSERT INTO lww_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ana atarpal ga naga, atarar ga kiena kulmrae ap̃urelua petania, pe plamom̃e ga kiriri pano. ");
INSERT INTO lww_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ana lala ap̃ere Yesu pimi sum̃al e marana ne p̃arin yar wa, nap̃a kiena ki Kaep̃as, amio yar keviu kiena yar wa lala amio navianena na visaluaena, amio na sumonena kiena ne le Yu lala, apim pa lele taaga e yo nene rui. ");
INSERT INTO lww_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ana Pita m̃ena taveve m̃a Yesu e pogos nene, ana pe pa re lavisin poli, ana pogos nap̃a apim loyum̃a e kove na kumali nene, Pita pa totano amio yeririna na yum̃aena kiena Kaep̃as, lala atega ke kapi, komin miava. ");
INSERT INTO lww_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ana yar keviu la nap̃a asike loyum̃a e viorena nene, lala akale ke yar lap̃as nap̃a akilia avisa plan sur lap̃asia nap̃a Yesu miyum̃aenia pona pisa, vena kila la akilia awem̃ar naga vanonia, ana pe am̃a re sur tai poli. ");
INSERT INTO lww_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","La am̃al lap̃asia ap̃erela apimi apisawal visena moki, ana visena punu ga nene apisokan ga, asum̃a apisa ke ga sur la nap̃a pe tap̃ena lala, ana kiela visokanena la nene mlolor ga. ");
INSERT INTO lww_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ana p̃isi na, lap̃as na visokanena am̃al visena tai, asum̃alu, asape ");
INSERT INTO lww_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Memloge yar nene naga p̃arwar e visena sanini rui, sape pupia yum̃a wa nap̃a kieta yermarua ga la amiyum̃aenia e limala, pisa sape yoko naga taaga ga kilia weplania, yoko yum̃aen ruru si yum̃a wa viu tap̃ena tai e legiena ve telu ga, nap̃a liman yeririna tap̃atete yum̃aenia.” ");
INSERT INTO lww_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","La apisa m̃a visena la nene pano-o, kaka ga, kiela visena la nene pe sum̃al m̃arera re poli. ");
INSERT INTO lww_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ana p̃arin yar wa sum̃alar se marala, pisi pa Yesu, piun tania, sape “?Ko na yoko ovisatam̃e van la pona ve ovisatam̃e la re? ?Sanape e visena la nene nap̃a apisa plan ke ne?” ");
INSERT INTO lww_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","A Yesu pe pis re si po, pisatam̃e re si poli. Ana p̃arin yar wa pis si pania, sape “?Sanape? Ko na ope Navisaarena nap̃a pe narina ne Ntewa, pona pe ko re poli?” ");
INSERT INTO lww_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ana Yesu pisatam̃e pania, sape “Ee, Navisaarena nene, naga inu. Ana nesape nevisa m̃ena van ko, p̃isi na yam ve plas ga, avisu si Narin Yeririna naga totano ke e lepas na p̃amarua puna Ntewa na m̃areraena, yoko avisu naga vaeme e lul metava vitom tano e yomarava nini.” ");
INSERT INTO lww_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ana p̃arin yaru wa sinen karia na pitolwowa m̃ana kulkota, pisape “P̃isi ga ne! ?Komin ya ne ita takale ke si yar tap̃ena nap̃a kilia visa plan si sur lap̃asia e naga? ");
INSERT INTO lww_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Amiu amloge ke ne! !Yar nene naga p̃arnena kare pa kia wa kiena ne Ntewa rui! Viorena sitom sanape, yoko tela nalip̃ereena van ve sanape?” Ana la amla nalip̃ereena pa Yesu, asape mesmes ga nap̃a monar awem̃aria. ");
INSERT INTO lww_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ana lap̃as aplasirkon naga, apiwo kilamarana, ana asuia, apisa karea, apiuyun tania, asape “?E, ovisalia, ane mlipa ko ke nanagane?” Ana yar na mara lap̃as kiena p̃arin yaru wa la apim ap̃urelua naga petan yo nene, ana la m̃ena nene asuia, amlilipa ke pogos nap̃a ap̃ure ke naga apano. ");
INSERT INTO lww_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ana e pogos nene, Pita sike loyum̃a e kove wa, ana sira na visuaren yum̃a m̃ana p̃arin yar wa pimi e lele nene, ");
INSERT INTO lww_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ana m̃al Pita tegan ke kapi, pisulup̃aria, pisa pania, sape “!E, ko nene ko m̃ena otataveve yar nae Nasaret nap̃ane!” ");
INSERT INTO lww_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ana Pita pisawan sur nene, sape “!E! In na pe nemloge ruru re sur na ko opisa ke ne poli!” Ana naga petan lele nene, pato laa lavisin pupia pulutava na yum̃a nene. ");
INSERT INTO lww_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ana e yo nene, sira nene naga m̃al sina, ana pisawal pan yar la nap̃a asike ne, sape “Yar nene pe yar kiena ke yar nam̃a tai narui.” ");
INSERT INTO lww_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ana Pita pisawan sina ga visena nene. Ana pe piavi re nenaga, la nene apisa pa Pita, asape “Peraga, ko ke tai narui, komin ko na yar nae ke Kalele tai narui.” ");
INSERT INTO lww_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ana Pita pis m̃arera, pisalup̃ar m̃arerania e visena sa nini, sape “!E lelaga kemua rui, Ntewa na Mava, in na nepisa pa rui, pe nekiliaar re nena yar na kam na apisayu ke ne poli.” ");
INSERT INTO lww_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ana veraga ga pogos nap̃a Pita pisa ke sanene, towa kokoreko yam lua narui, kila Pita sitom̃al si visena kiena Yesu, nap̃a pisa pania, sape “!Lelaga nepisa pan ko, p̃ane ga ne kolemalo, pogos nap̃a towa ve kokoreko re na yam lua poli wa, ko na ovisawan inu yam ve telu rui.” Ana Pita mloge sinena piowa na piowa, molue pa vanua, tag na tag. ");
INSERT INTO lww_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ana kolulagi e Praere nene, li kerkeviu la kiena le Yu la apiora sina ga e kiela pupia kumali. La nene nane yerkawa kiena ne yaru wa lala, amio kiela nasumonena lala, amio kiela navianena navisaluaena la. Apis m̃a pano-o, atol sitomena tai, p̃isi na apiar limana ne Yesu, ap̃ure naga pa puna ne p̃arin sup̃e keviu P̃aelat, ana la amligan Yesu e limana, vena naga lip̃erea. ");
INSERT INTO lww_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ana P̃aelat piun tan Yesu, sape “?Ko ope P̃arin Sup̃e kiena ne le Israel lala, pona peraga?” Ana Yesu pisatam̃ea, pisape “Naga ke narui, sane opisa ke ne.” ");
INSERT INTO lww_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ana yerkawa lala kiena ne p̃arin yaru wa lala apisasawal suri la e Yesu, asape naga kila sur la moki nap̃a piowa. ");
INSERT INTO lww_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ana P̃aelat piun sina ga tania, sape “?Sanape, la apisa suri viowa moki e ko rui, ana ko na omla m̃a kana navisatam̃eena pona peraga?” ");
INSERT INTO lww_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ana e lepas nen sur la ne apisa ke ne, Yesu pe pisatam̃e re si sur tai pan la poli, ana P̃aelat sinen pulan sur nene pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ana e pogos nene, la asike e pog na P̃ap̃agena na Sitom̃alena Natamaliaena wa, ana e kas punu ga e p̃ap̃agena nene, p̃arin sup̃e nae Rom silaga kila suri tai pan le Israel lala. Naga kila nap̃a visae lap̃as nap̃a asike e yum̃a naloge viowaena, la akilia aviun yaru ve taaga nap̃a sinelania, yoko P̃aelat naga ligan lua naga molue. ");
INSERT INTO lww_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ana e pogos nene, yaru na kilaen politik tai naga m̃eke e yum̃a naloge viowaena, nap̃a yaru la akilia ruru naga, kiena ki P̃arap̃as. Naga pe yar tai pogos nap̃a asum̃alun kawelaen amio le Rom lala, m̃emom̃ar lap̃as amare, ana amligan pa e yum̃a na loge viowaena. ");
INSERT INTO lww_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","P̃isi na, p̃ina lala apimi moki lele taaga e marana ne P̃aelat, apiun tania vena naga kila van la sa nap̃a naga sum̃a kila ke ne, monar ligan lua lala yar tai nap̃a sike e yum̃a naloge viowaena molue sina. ");
INSERT INTO lww_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ana P̃aelat pisatam̃e la, sape “Pogaga. ?Amiu sinemiun asape neligan lua yaru nene molue sina, naga pe kiamiu p̃arin sup̃e amiu le Yu la?” ");
INSERT INTO lww_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","P̃aelat piun sanene, vanon naga kilia pa rui nap̃a yerkawa ga kiena ne le Yu lala, ap̃ure Yesu pimi puna, sane yum̃aena na vielueen ga, vanon nap̃a apisu kiela yeririna tap̃ena lala akekaran Yesu pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sanene narui, P̃aelat sinenan sape ligan lua Yesu vano, ana yerkawa kiena ne yaru wa lala akila kare sitomena kiena ne yeririna lala pimi pisusun pap̃isi, asape am̃areran van P̃aelat vena ve ligan lua re Yesu, ligan lua ga P̃arap̃as vano. ");
INSERT INTO lww_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ana P̃aelat mloge ke sur la nap̃a apisa ke pania, piun tan la, sape “Pogaga, ana visae sanene, p̃isi na nekila ve sanapen yar nene nap̃a amiu apio ke naga asape p̃arin sup̃e kiena ne le Yu lala?” ");
INSERT INTO lww_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ana la punu ga apioyonia, asape “!Asuar naga e lak torovia!” ");
INSERT INTO lww_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ana P̃aelat piun tan la, sape “?Vanon ya? ?Naga kila suri ya ne piowa?” Ana la apioyoni manene laa pa metava sane, asape “!Asuar p̃a, asuar ma e laki torovia!” ");
INSERT INTO lww_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ana P̃aelat pisu p̃ele narui, sinenan sape visa sur tai nap̃a kila yeririna la nene aloge wonia, ana naga sape Yesu naga sum̃a ga, a mligan lua ga P̃arap̃as pa si pula. Ana mligan Yesu e limana ne kiena li na mara lala vena akoa, aure va asuar e lak torovia. ");
INSERT INTO lww_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ana li na mara lala atarar Yesu ap̃erelua pa vanua e yometava na kumali kiena ne P̃aelat nene, ana la apio pa kiela p̃egas nen li na mara tap̃ena lala vena aimi avisuia. ");
INSERT INTO lww_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ana la amiyenlua m̃ana kulsota, ana amiyen kulkota tai e naga nap̃a marana mene sa nap̃a p̃arin sup̃e la amiyen, ana ap̃ar nonos nen kilsirili, ana ap̃aniroron ga, amligan e p̃arina, sa nap̃a karo na p̃arin sup̃e tai. ");
INSERT INTO lww_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ana pogos nap̃a amligan sur la nene e p̃isi, la asum̃a akila lele kare ke, asape “!P̃arin sup̃e kiena ne le Yu lala-oo! Imimi mepatanon ko, memieluar ko!” ");
INSERT INTO lww_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","La amla lakiavio tai, am̃e p̃arina ea, la asum̃a aplasiria kare naga, akinai tano puna sa nap̃a apatanon ke naga. ");
INSERT INTO lww_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ana pogosia nap̃a la akila lele kare naga, p̃isi na ap̃arlua kulkota mene nene petan naga, ana amiyen si m̃ana kulsota tai ea, ap̃ure apano vena asuar naga e lak torovia. ");
INSERT INTO lww_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ana pogos nap̃a li na mara la asumon Yesu apa ke narui, am̃al yaru tai nap̃a naga pa yom̃arua ana naga mial pimi. Yar nene, naga Saemon nap̃a sumo naga nae Saerin, nap̃a naga arimanane lalua nene Aliksanta amio Rup̃as. Ana am̃areran pania asape naga towe kus lak torovia kiena ne Yesu vano. ");
INSERT INTO lww_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ana lala asumon Yesu apa atol kunus tai, kiena kia Kolkota, nap̃a kana kinasa asape yo nap̃a sane puryu na piap̃arin yaru. ");
INSERT INTO lww_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pogos nap̃a apimi aporu e wos nen kunus nene, ana la sinelan asape ala kuruta namunena va Yesu vena munia. Ana kuruta namunena nene ataron was nen suri tai nap̃a melkalka sike ea, vena kila tasnena ne Yesu kapulu ga, ve lae manene re, ana pogos nap̃a amla pania, yepen mavin munena. ");
INSERT INTO lww_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ana la atarar Yesu, asuar naga ma e laki torovia. P̃isi na, la akuan taes, vena alual li ane war m̃ana kulmrae tai, a ane war tai. ");
INSERT INTO lww_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ana pogos nap̃a amligan pa Yesu ma e laki torovia, naga kolulagi, maran mrae ovari. ");
INSERT INTO lww_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ana li na mara nae Rom la asiri navisawalena tai, nap̃a pisawal suri nap̃a nasumonena kiena ne le Yu la sinelan asape awem̃ar naga vanonia, nap̃a sape “Yaru nene naga pe p̃arin sup̃e kiena ne le Yu lala.” ");
INSERT INTO lww_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ana e pogos m̃ena nene, yar navinauena lalua, asuari la m̃ena ga e laki torovia sa ke Yesu, apisirilua tai e lepas na p̃amarua, tap̃ena e lepas na p̃am̃eli. ");
INSERT INTO lww_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","E mrapa ne nanene, lala akila visena marua tai na Tusi Wa pimi kate sina ga, nap̃a sape “Amligan naga m̃eke amio yar na kilaroen navisaluaena.” ");
INSERT INTO lww_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ana yaru la nap̃a asum̃a amiyaloro ke apa e yo nene, asisilin p̃arila, apisalele kare ke Yesu p̃isa, la asape “!Koe, suwala! Ko nene nanua sumo ko opisa osape ko okilia owe plan Yum̃a Wa m̃ana ne Ntewa, ana ovisirlua sina ga e legiena ve telu ga, ana sanape narui? ");
INSERT INTO lww_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","!Pon ko ga otamalia ko lia, ovetan laki torovia nam̃a, otom tano!” ");
INSERT INTO lww_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","E p̃elaga m̃a nenaga nene, yerkawa kiena ne p̃arin yaru wa lala, amio navianena na visaluaena, asum̃a apitalia kare ke naga pap̃isi, asum̃a apisa ke, asape “!Pona naga tamalia m̃a yaru tap̃ena la moki rui, ana naga mninue kare si narui, tap̃atete si tamalia naga yo! ");
INSERT INTO lww_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","?Ana naga pe kieta Navisaarena, a pe p̃arin sup̃en ita le Yu lala, pona peraga? Popon naga vitom tano e lak torovia nanagane, vena ita tevisu sane naga pe lelaga, vena telelaga e naga.” Ana la lua m̃ena nap̃a asuar la e laki torovia amio Yesu, la m̃ena ga amiyakol sina visena viowa kiena ne la nene pania. ");
INSERT INTO lww_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ana kolipae ga, yemalolo pimi kalo yo punu ga e yo nene, pano tol mrae telu koyepekilavi. ");
INSERT INTO lww_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","A e pogos nene, Yesu mlokai keviu e kiena visena ruru naapo, sape “?Eli, Eli, lam̃a sap̃atani?” nap̃a kana kinasia sape “?Kiau Ntewa, kiau Ntewa, sanape na omliganu nem̃eke sanene?” ");
INSERT INTO lww_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ana yeririna lap̃as nap̃a asum̃alu asike e yo nene, apisusu suri la nene, ana amlogepal m̃aagena kiena ne Yesu nene, ana la asape “Amloge ke ne, yaru nene pio ke yermarua Elaisa, vena imi iila naga yo?” ");
INSERT INTO lww_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ana veraga ga, lala yaru tai kiriri pimi, p̃ar lumlum p̃asia, taron kuruta namunena nap̃a melkalka pa ea, miyurar te laki tai, kian pa Yesu vena munia, p̃isi na naga sape “!Tesu wa! Tevisulia, pona yoko yermarua Elaisa vitom tamalia naga pona pere.” ");
INSERT INTO lww_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ana Yesu mlokai manene sina, p̃ere maron kiena yalua, marp̃anu. ");
INSERT INTO lww_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ana pogos ke ga nene, pupia kulmrae nap̃a merorol tamalele ke e Yum̃a Wa m̃ana ne Ntewa, nap̃a mono ke yo wa nap̃a pe yo wa pap̃isi, purp̃a pito ga lika, siar metava pito tol tano. ");
INSERT INTO lww_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ana yerkawa kiena ne li na mara lala, nap̃a pisusuar m̃a Yesu, pogos nap̃a pisu p̃ere maron kiena yaluaena, milan pap̃isi, pisa sape “!Aulai, yaru nene naga pe Narina kemua Ntewa lelaga nap̃ane!” ");
INSERT INTO lww_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ana sira lap̃asia nap̃a atataveve ke Yesu asike e yo nene, asum̃alu asike laa perina sane, asum̃a atamaren ke kiela navianena. E lala nene, la telu nap̃a kiela kia la sanini, Maria tai nap̃a sira nae Maktala, Maria m̃ena nap̃a anenane Semes kokan amio Yoses, a sira m̃ena tai, Salome. ");
INSERT INTO lww_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Naga lala nap̃a pogos nap̃a Yesu sike garu Kalele nanua sumo, la asum̃a ataveve naga, amiila m̃ena naga. Ana sira m̃ena la moki asum̃alu asike e pogos nene, nap̃a lala m̃ena akom garo Kalele ataveve Yesu apa ma Yerusalem. ");
INSERT INTO lww_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ana legiena na Praere, naga pe legiena na kilaruruen sur la punu ga sum̃ate Legiena Wa peni, ana pogos nap̃a lavis mrae vito tano, ");
INSERT INTO lww_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","yaru tai nae Aramatia, kiena ki Yosop, naga pe marau re poli, kila kiena sitomena m̃arera po, pa sum̃alu se marana ne P̃aelat, piun tania sape kus tasnena ne Yesu. Naga m̃arera pan pap̃isi nakilaen ve sanene, komin naga pe pupia yar tai na kansel kiena ne le Yu lala, nap̃a yar la akilia ruru naga po, pe yar m̃ena tai nap̃a sinenan ke navesup̃enena kiena ne Ntewa naga vim. ");
INSERT INTO lww_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ana P̃aelat mninue ga sape e pogos nene na Yesu mare rui po pere wa, pio kiena yar kawa na mara pimi piun tania. ");
INSERT INTO lww_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pogos nap̃a mloge sape Yesu mare rui, ana tam̃an tasnena Yesu imi va Yosop. ");
INSERT INTO lww_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ana Yosop temare ga m̃ana puluve viu tai p̃isi ga na wa, pa pul kulmrae nowo tai, pa akuslua tasnena ne Yesu petan laki torovia, amluluwoia ana la apa amligan m̃eke e m̃ana puluve nap̃ane. Ana amelilivin pupia kilavaru pimi mono pulusia, ana la ap̃asup̃e la si apano. ");
INSERT INTO lww_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ana Maria lalua nene, tai nap̃a nae Maktala, amio tap̃ena nene anenane Yoses, lalua m̃ena apimi apisu yo nap̃a tasnena ne Yesu m̃eke ea. ");
INSERT INTO lww_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ana pogos nap̃a Legiena Wa p̃arovia, ko yepekilavi e Pog Orai, Maria nae Maktala, amio Maria nap̃a anenane Semes, amio m̃ena Salome, la telu nene apito apul suri la nap̃a ponos taninu vena awar va avilan e yepena ne Yesu. ");
INSERT INTO lww_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ana e Sante kolulagi wa ke ga wa, sa nap̃a mrae siar molue, la teloka amiyal apa e puluve nap̃ane. ");
INSERT INTO lww_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ana pogos nap̃a amiyal ke apano, apiuyun ke sina ga pan la, asape “?Ana visae tetol ma ne, ane kilia melilivin lua pupia kilavaru nap̃a mono ke pulus nena van ita, vena tekilia teva loyum̃a?” ");
INSERT INTO lww_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ana pogos nap̃a la apimi lavisin yo nene, apisu ga pupia kilavaru nap̃ane, yaru tai melilivin lua pa rui. ");
INSERT INTO lww_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ana la apa loyum̃a e puluve nap̃ane, amilan yaru m̃ee tai totano teke e lepas na p̃amarua, miyen ke kulmrae nap̃a miyuwowo pap̃isi, ana pogos nap̃a apisuia, sinela kurkur, miyuyuwawa pano-o pap̃isi. ");
INSERT INTO lww_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ana naga pis pan la, pisape “!E, ve amarau re! In na nekilia pa rui nap̃a amiu apimi e yo nini vanon Yesu nae Nasaret, nap̃a am̃ear naga e laki torovia. Ana naga sum̃alu mali si rui, pe mon re si e yo nini poli. Aimi avisulia! Na nene yo nap̃a amligan tasnena m̃enea. ");
INSERT INTO lww_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ana ato vilaga, avisawal va Pita amio nalogena tap̃ena lala, avisave yoko Yesu naga sumo vito p̃es garo Kalele, ana p̃isi na la m̃ena monar asiraun atove, avisu naga e yo nap̃ani, sa nap̃a naga pisaar pan la sumo rui.” ");
INSERT INTO lww_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","P̃isi na la apitap̃ili, apetan puluve ap̃ure apitove, komin la amilan suri la nene pano-o pap̃isi, amiyuwawan ga rui. Ana la amarau m̃ena pap̃isi, kila sanene la apitove na pe apisawal re si pan yaru tap̃ena la poli, apa mesmes puna ne nalogena lala. ");
INSERT INTO lww_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ana Yesu mal sina e Pog Olua kolulag wa ke ga wa, nap̃a pe legien p̃esia na wik. P̃isi na naga m̃alivin ke la nap̃a atavevea, ana naga nap̃a m̃alivin p̃esia, Maria nae Maktala, nap̃a nanua sumo pile plan ninuna viowa la olua petania. ");
INSERT INTO lww_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","P̃isin nap̃a Maria pisu Yesu, pa m̃alivin la nap̃a asum̃a ataveve ke naga sumo, la asum̃a amloge ke piowa atag ke ga wa, naga pisawal pan la pisape Yesu naga mal si rui. ");
INSERT INTO lww_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Naga pisa ruru pan la pisape naga pisu Yesu e kilamarana rui, ana la pe amlelaga re e naga poli. ");
INSERT INTO lww_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ana siraun sina, e pogos tai nalogena la lua apetan Yerusalem amial apa ke apa sane, ana Yesu m̃alivin la. Lalua apisu sane yepena pe tap̃ena, pe sa re si nanua sumo poli, ");
INSERT INTO lww_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ana pogos nap̃a apisu pae p̃isi, lalua apilon la sina ap̃asup̃ela, apitove apisawal sur nene pan lala tap̃ena lala, ana yam si tai lala tap̃ena la nene pe amlelaga re e sur nene poli. ");
INSERT INTO lww_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","A siraun sina, Yesu m̃alivin kiena nalogena la lualima taaga pa taaga, e pogos tai nap̃a atotanon ke kinanena. Ana naga pisli m̃a pan la, komin nap̃a pe ap̃asine ruru re naga poli, komin sinela la m̃arera pap̃isi, kila na la pe amlelaga re e visena kiena ne la nap̃a akirawal naga mali si rui. ");
INSERT INTO lww_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ana Yesu pisa pan la, pisape “Nanagane na monar avano, aliureure amiu e yo punu ga e yomarava nini, monar alologon kiau lologena wo van yeririna la punu ga. ");
INSERT INTO lww_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Visae yar tai naga loge, ana lelaga ea, siraunia tol wii nakeena, yaru nene yoko tol malena, a visae naga nap̃a ve lelaga re, p̃isi na Ntewa visaar marena vania. ");
INSERT INTO lww_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ana la nap̃a yoko alelaga, p̃isi na kile la asike e la, sa nap̃a la avile plan yermare la e puriukawaena na kiau kia, ana avisin m̃ena visena tap̃ena lala, ");
INSERT INTO lww_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","a sa pogos tai auarar lom̃ara tai, ana yoko woga ga, a visae amun sur tai nap̃a monar amarenia, ana sur nene tap̃atete kila sur tai van la, ana yoko aligan limala la e inanena lala, p̃isi na aloge wo sina ga.” ");
INSERT INTO lww_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ana pogos nap̃a kieta Sup̃e Yesu pisa pa visena la nene pan la, Ntewa p̃urelua si naga pa ma e peni, mligan naga totano e lepas na p̃amarua puna. ");
INSERT INTO lww_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ana kiena nalogena la amial tetai, apa amlologo e yo punu ga, ana apisu sane Sup̃e naga miyum̃ae ke amio la, kila ke kile la moki pan la, vena kilaen yeririna la avisu kilia sane kiela visena la pe lelaga ga. A sunena nene maro ga e nene. ");
INSERT INTO lww_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Inu Luk nesiriyu suniena nini pan ko, Yerkawa Tiopilas. Sa nap̃a ko okilia p̃isi rui, yaru la moki liu nap̃a asiri suniena na suri la nene komp̃as rui nap̃a am̃alm̃alivin ita e kas lap̃as p̃aro rui. ");
INSERT INTO lww_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Suri la nene, ita pe tepisu mesmesun re e kilamarata poli, ana la nap̃a apisuia, siar e purp̃esa, a la na sa nap̃a la ape li Nalologena Wo p̃esia, la ke narui la apisawal ruru lelein pimi pan ita. ");
INSERT INTO lww_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ana siar nakonua rui, nesum̃a nepisusu ruru ke m̃aki tap̃ena la nap̃a la asiria, a nesum̃a nemla ke visena na suri la nene, ana nepisu sane popon visae nekilali nela sunien tap̃ena la nene komp̃asa, nesirikolia vena aim sane tus wo tai nap̃a taveve ruru narin mrapa lala na suniena nene. ");
INSERT INTO lww_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","A nane nesiri sike na rui, a nekekaran nap̃a neligan imi ve kiom̃a, vena ouloyuia, okilia ovisu kilalea sane suri la nap̃a osum̃a omloge ke rui, la amesmes ga a ape lelaga, la sa nap̃a kiau tus nini pisawalia. ");
INSERT INTO lww_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Suniena nena naga siar sanini, sape: E pogos nap̃a P̃arin Sup̃e Erot naga pe sup̃en ke lepas nae Yutea, yaru wa tai, naga pe namratava kiena ne Apisa, a naga p̃ere sira tai nap̃a naga m̃ena molue kome lus kiena ne yaru wa lala, nane e namratava kiena yermarua Eron, wenla Mosis nanua sumo ne. Yaru nene kiena kia Sakaraea, a wona kiena kia Lesipet. ");
INSERT INTO lww_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ana lalua nene kiela malena mesmesu po pap̃isi e navisuena kiena ne Ntewa, nap̃a la asum̃a amlogear kiena navisaluaena lala, a asum̃a akila ke p̃elaga la nap̃a mesmes silaga, pe akilalu re tai poli. ");
INSERT INTO lww_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ana suri ga tai, lalua pe narila re tai poli, komin sira nap̃a Lesipet naga pe lum̃alum̃a ga, a nanagane lalua apimi ape yermarua laa rui. ");
INSERT INTO lww_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ana e pogos tai, pe pog na p̃egas kiena ne Sakaraea nap̃a monar ava akila kup̃ap̃aena e Yum̃a Wa m̃ana ne Ntewa, sa nap̃a p̃egas tai kila e wik tai, p̃egas tai kila e wik tai. ");
INSERT INTO lww_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","A silaga, pogos nap̃a akila sanene, la monar akila sa nap̃a amlil m̃apila, vena alual yaru ai nap̃a yoko naga kila pupia yum̃aena navaen loyum̃a e Yo Wa na Yum̃a Wa nene, vena sikapen ponotaninu na wonta nap̃a sike ne. Ana e poglis nene akila sanene, a kia kiena ne Sakaraea naga pa metava, asape naga narui nap̃a va kila yum̃aena nene. ");
INSERT INTO lww_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ana e nena e pogos na sikapen ponotaninu nene, naga pa loyum̃a vena va kila, a pupia p̃ina na yeririna lala asike vanua, asum̃a amlen m̃aga. ");
INSERT INTO lww_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ana pog nap̃a Sakaraea pa loyum̃a, ana milan kare navisi tai kiena ne Ntewa nap̃a m̃alivinia, sum̃al ga sike e lepas nen wonta nap̃ani lepas na p̃amarua. ");
INSERT INTO lww_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ana pogos nap̃a Sakaraea pisu navisi nap̃ani, naga mninue kare narui sape am̃a kila ve sanape na wa, naga marau pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ana navisi nene pisa pania, pisape “Sakaraea, ve omarau manene re. In na nepimin ga nesape nevisawal van ko, Ntewa mloge kiamiu leniena amlua rui, a yoko wom̃a Lesipet, p̃isi na war narum̃a na mom̃e tai, a pogos nap̃a vaeme, yoko oligan kiena kia Yoane. ");
INSERT INTO lww_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","“Pogos nap̃a vaeme, yoko akekara vap̃isi, aloge wo, ana ve amiu re ga, ana yaru tap̃ena m̃ena lala akekara vap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","“Sisi nene, yoko imi ve yerkawa tai kiena ne Ntewa, a naga sane ve yaru wa tai, p̃isi na naga valia kuruta a wii m̃arera m̃ena lala. Siar e pog nap̃a naga teke e lom̃ep̃ena anena wa, ana yoko Ninuna Wa ulen naga vap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yoko naga ve yaru tai nap̃a p̃isi na vilon le Israel la ve moki awasup̃e la si puna Ntewa na Mava, kiela Sup̃e. ");
INSERT INTO lww_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yoko avisu nap̃a ninuna a nam̃areraena nap̃a se e Navisawalena Elaisa sumo sike sina ga e naga maran ve taaga, komin nap̃a naga imi sumo, vena visawal visave ve ve piavi re Navisaarena naga imi raunia. Yoko naga vilon sinen ata lala vena asitomyu ruru sina ga narila lala, a yoko vilon sitomena kiena ne li nakilaroen navisaluaena lala vena ataveve si p̃elaga nap̃a pe manmarua a mesmes ruruia. E mrapa ne la nanene narui, p̃isi na naga kila ruru p̃egas nen yeririna la tai va Ntewa, vena asum̃ate naga imi m̃alivin la.” ");
INSERT INTO lww_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ana Sakaraea mloge visena la nene, ana pisa pa navisi nene, pisape “Ei, ve ovisa re sanene. Tap̃atete ve sanene, komin imimi lua na mrae pito tano rui.” ");
INSERT INTO lww_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ana navisi nap̃ani pisa ke sina pania, pisape “Peraga, yoko ve sa ga nene. In na Navisi Kap̃riel nini, nap̃a silaga nesum̃al luen ga nesike e marana Ntewa vena nowar kiena visena, ana naga mligan inu nepim pum̃a vena nevisawal lologena wo nini van ko. ");
INSERT INTO lww_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ana pogos nap̃a nepisawal pan ko, ko na pe omlelaga re e poli, ana nevisa van ko sanini, yoko ove puru, ana p̃isi na osum̃a ga sanene imi tol pogos nap̃a ovisu suri la nene imi m̃alivin ko nena ga e kana pogosia.” ");
INSERT INTO lww_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ana pogos nap̃a navisi pis ke sanene pa Sakaraea, yeririna la asum̃al asike vanua na wa, asum̃ate m̃a pano-o, ana kiela sitomena lua narui, asape “Vanon ya ne naga pa loyum̃a, kila malion manene suri sanene.” ");
INSERT INTO lww_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ana siraunia na, molue sina, ana la apisu nap̃a naga pe pis re si pan la poli, ana la apisu kilale asape naga sike loyum̃a, naga pisu suri tai, nane kila naga sanene. Ana naga pis ga e limana pan la, naga pe puru ga mom̃a ga. ");
INSERT INTO lww_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ana sum̃a kila kiena yum̃aena e Yum̃a Wa m̃ana ne Ntewa, pano-o kilamake kiena pogosia, ana p̃asup̃e si pa m̃ana. ");
INSERT INTO lww_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ana asum̃a sanene pano-o, pe piavi re poli, wona sena, ana pogos nap̃a naga mloge sane m̃ep̃ena sanene, naga pa mom̃a ga m̃ala um̃a sanene pano-o tol kupario lima. ");
INSERT INTO lww_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","A e pogos nene, naga sum̃a pisa sanini, pisape “!Ntewa kila po pan inu pap̃isi nene wa! Sumonia, yaru la asum̃a apisu memawan inu komin nap̃a pe nop̃ar re sisi poli, ana nanagane Ntewa pisuveve inu, sinena miye inu, ana mlalua memawaena na kiau lum̃alum̃aena nene rui.” ");
INSERT INTO lww_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Ana Lesipet sena tol kupario orai rui, ana Ntewa pitetalia kiena navisi nap̃ani, Kap̃riel, vena vito visawal kiena visena tai va sira m̃ee tai, kiena kia Maria, nap̃a naga sira m̃ee tai na pulkumali nae Nasaret e lepas nap̃a Kalele. E pogos nene, la apisaar Maria rui vena va talopa amio yaru tai, kiena kia Yosop, nap̃a naga molue kome lus kiena ne P̃arin Sup̃e Tepet nanua sumo, ana Maria pe pa su re amio naga poli wa. ");
INSERT INTO lww_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ana navisi nap̃a Kap̃riel pimi m̃alivin Maria, pisape “O, Maria, Ntewa sitom ruru ko nena pap̃isi, naga sum̃a pisa ruru ko, sike kemua amio ko lelaga.” ");
INSERT INTO lww_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pogos nap̃a Maria mloge visena nene, naga sitom pap̃isi, sape visuvevelia, pisape navisi nene pisa po pap̃isi, ana kana kinas sanape. ");
INSERT INTO lww_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ana navisi pis sina pania, pisape “Maria, ve omarau re. Ntewa kekaran ko ga, ana yoko kila pupia navisa ruruena tai imi e kiom̃a malena. ");
INSERT INTO lww_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nanagane, yoko osena, vano-o owarwal narum̃a na yerm̃ene tai, a visae naga vaeme pae, monar osikia kiena kia Yesu. ");
INSERT INTO lww_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Visena Wa nanua sumo naga pisayu pa narum̃a nene rui, nap̃a pisape ‘Naga yoko ve yerkawa, a kiena kia, “Narina ne Ntewa na mava,” a Sup̃e Ntewa yoko kila naga imi ve p̃arin sup̃e tai nap̃a kus lelen repina marua nene P̃arin Sup̃e Tepet nanua, ");
INSERT INTO lww_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ana p̃isi na naga ve sup̃en la nap̃a amolue e mratava m̃ana yermarua Sekop, nane le Yu ne la ne asike nanagane, a la nap̃a yoko aim sirau, a kiena nasup̃enena nene yoko tap̃atete p̃isi pogos tai.’” ");
INSERT INTO lww_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ana Maria milan visena nene pap̃isi nap̃a sape yoko naga war sisi, ana naga piun tan navisi nene, pisape “?Ana suri nene yoko m̃alivi ve sanape ne, komin nap̃a in na pe nesu re nemio wou nene poli wa?” ");
INSERT INTO lww_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ana navisi pisatam̃ea, pisape “Ninuna Wa yoko naga vitom e ko, a nam̃areraena kiena ne Ntewa na mava p̃isi na kalo ko, ana yoko osena. A komin nap̃a yoko ove sanene, p̃isi na avisave sisi wa nene nap̃a yoko owaria, naga ve narina ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“E kiom̃a navisuena, opisu suri nene sane m̃arera pap̃isi nap̃a yoko ve sanene, ana popon ositomli anom̃a sira marua Lesipet nene. Asum̃a apisu ke naga asape naga tap̃atete nena ga war sisi narui, ana nevisa van ko, naga pe sira marua rui, ana nanagane, kiena kupario orai narui. ");
INSERT INTO lww_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ositomlia, sa nap̃a Ntewa pisa pa sira marua Sera nanua sumo laa rui, e lepas na puna, pe suri re nena tai nap̃a naga kila p̃ele poli.” ");
INSERT INTO lww_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ana Maria pisatam̃ea, pisape “Lelaga kemua nap̃a. In na nepe sira m̃ee na yum̃aena kiena ne Ntewa ga, ana netam̃an inu ga vena naga kila suri la nene imi ve lelaga e inu ve sa ga nap̃a naga sinenania, sa nap̃a opisawal pan inu.” Ana navisi nene purmatania. ");
INSERT INTO lww_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ana Maria sum̃a sitom̃al ke visena lala kiena ne navisi nene, ana sinenan manene pap̃isi sape va visu anena nene, nap̃a Lesipet, ana pe piavi re poli na, mligan kiena yo, mial kawa pa e pulkumali nap̃a Lesipet amio wona Sakaraea lalua asike ea, nane e lepas na kunus lala nae Yutea. ");
INSERT INTO lww_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ana Maria pa tol m̃ala yum̃a, pa pio Lesipet. ");
INSERT INTO lww_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","A poglis nap̃a Lesipet mloge kilale pulgo Maria nap̃a pis pania, mloge narina nap̃a teke e naga kulul keviu. Ana Ninuna Wa pitomi e Lesipet, pitomi pule ea, ");
INSERT INTO lww_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ana Lesipet pio manenea, pisape “!O, Maria, Ntewa pisa ruru ko keviu pap̃isi, taulu make sira la punu ga, a yoko pupia kiena navisa ruruena sike m̃ena e mrasnom̃a nap̃a yoko owaria. ");
INSERT INTO lww_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","In na pe nepe sira wo re nena tai poli vena anenane kiau Sup̃e imi yal li inu sanene, ana nepisu sane po pan inu pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","A kiau sisi tomtom pisu kilale ko, kekara pap̃isi, komin pogos nena nap̃a memloge p̃esan pulgom̃a, naga kulul pap̃isi e lom̃ep̃eu. ");
INSERT INTO lww_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ita lua tekekara na tekekara, komin temlelaga e visena kiena ne Ntewa, a yoko imi ve lelaga van ita ve sa nena nap̃a naga pisaar pan ita.” ");
INSERT INTO lww_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ana e poglis nene, yauena kiena Maria tai sanini, sape “Sineu mieluar Ntewa keviu, ");
INSERT INTO lww_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ninuu kekara pap̃isi pa kiau Sup̃e Natamaliaena, ");
INSERT INTO lww_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","naga pisu inu nesike tano nepe sira na kiena yum̃aena tai, naga pe Ntewa nam̃areraena, naga sitom̃al inu, kila po pan inu. Teras lelei la nap̃a aim sirau avisayu inu, asape ‘Sira nene, Ntewa pisa ruru naga keviu,’ nepisirlua kiena kia wa. ");
INSERT INTO lww_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Sinena miye la nap̃a apatanonia, teras na sumo, na sirau. ");
INSERT INTO lww_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nam̃areraena na limana kila suri moki, naga mlipureure la nap̃a ape p̃arm̃arera, kila la apa tetai. ");
INSERT INTO lww_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kila plan p̃arin sup̃e e lelela la, pisirilua la nap̃a sitomena su ga tano. ");
INSERT INTO lww_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","La nap̃a viso kar la, pagan ruru la, li na suri moki, m̃ene plan la, limala korena ga. ");
INSERT INTO lww_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kila sa nap̃a pisaar pa repita lala, pimi miila ita kiena le Israel lala. Pe sinen p̃esan re Epraam poli, sinen ye luen ga kiena piaparavi, vano-o ve uro re.” ");
INSERT INTO lww_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Yauena kiena ne Maria nane p̃isi e nene, a naga sike amio Lesipet pano-o tol kupario telu, siraunia p̃asup̃e si pa m̃ana um̃a. ");
INSERT INTO lww_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ana pimi tol ruru pogos na narina ne Lesipet vaeme, ana paeme pe mom̃e. ");
INSERT INTO lww_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ana pogos nap̃a namratava puna ne Lesipet amio la nap̃a asike lavisinia amloge suri nene, akekara pap̃isi amio naga e pupia sinewo kiena ne Ntewa nap̃a pimi pania, nap̃a nanua sumo naga pe lum̃alum̃a ga, ana nanagane narina nasumo nane paeme ne. ");
INSERT INTO lww_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ana pogos nap̃a sisi nene kiena legiena olua, apimin akila naga pe p̃aviu. E pogos nene, la sinelan asape asikia m̃ena kien kia, Sakaraea, sane kia kiena ne arimana, ");
INSERT INTO lww_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ana anena pisa lup̃aria, pisape “Peraga, kiena kia, Yoane.” ");
INSERT INTO lww_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ana la apis pania, apisape “Ya ne sanene? Namratava pum̃a na pe amligan re kia tai sanene e poli!” ");
INSERT INTO lww_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ana apisi ga e limala pa ariman sisi nap̃ani, vena aviun tania avisave naga sinenan sape aligan kia nape e narina nene. ");
INSERT INTO lww_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ana Sakaraea pis ga e limana pan la, pisape ala m̃aki tai vania, ana siri ea, pisape “Kiena kia, Yoane.” Suri nene kila la nae yo nene amilan pap̃isi, ");
INSERT INTO lww_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","a e m̃ena e pogos nene, purmenena ne Sakaraea kulul sina, kilia pis narui, ana mieluar Ntewa. ");
INSERT INTO lww_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ana yaru punu lala na lepas nene amloge suri nene, amilan kare pap̃isi, a suniena nene pa laa narui tol pulkumali tap̃ena lala na lepas na kunus lala nae Yutea. ");
INSERT INTO lww_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","A la nap̃a amloge, asitom pap̃isi, komin nap̃a la apisu kilale asape limana ne Ntewa sike amio naga, ana la asum̃a apiuviun pan la asape “?Nin sisi wa nene yoko naga ve sanape ne?” ");
INSERT INTO lww_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ana Ninuna Wa pitomi pule e Sakaraea arimanane sisi nene, ana naga pisawal sanini, pisape ");
INSERT INTO lww_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Teieluar kia kiena ne kieta Ntewa, Sup̃e nae Israel, pitomi pun ita, pul plan ita, ");
INSERT INTO lww_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","maplarar kana keyowo, molue e piaparavi na kiena yaru na yum̃aena Tepet, nap̃a yoko tamalia ita. ");
INSERT INTO lww_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nanene kiena navisaarena nanua, navisawalena apisawalia, asape ");
INSERT INTO lww_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Naga urelua ita vetan limana ne nasinekar lala, ");
INSERT INTO lww_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tap̃atete m̃ena sinen p̃esan naviranarena amio repita lala, sinena mie la ke na wa, ");
INSERT INTO lww_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","nane navisaarena m̃arera amio repita Epraam, ");
INSERT INTO lww_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Ntewa pisaar pisape tamalia ita vetan limana ne kieta nasinekar lala, vena ve temarau re sina, teve yaru wa, temesmesu e marana, teyum̃ae vania e legiena punu ga e kieta malena. ");
INSERT INTO lww_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nin naruu, avio kon Navisawalena kiena ne Ntewa na meta manenea, osumon Sup̃e okila ruru kiena mrapa. ");
INSERT INTO lww_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Yoko ovisawal sane Ntewa sinena ye kiena yeririna lala, ve sinewo van la, viewo kiela mlamulena viowa lala, tamalia la. Yoko Ntewa kila kiena narin yomerarava p̃esa na kolulagi va metava van ita, ");
INSERT INTO lww_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","vitom tegoli ita nap̃a tesike e yemalolo, nap̃a ninuna na marena kalo ita rui, a vitom vivagali mrapa na sum̃are vena teyaloro ea.” ");
INSERT INTO lww_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ana pogos nap̃a kas la pimi p̃aro pano, Yoane nene kapuru pimi keviu, a kiena sitomena marua ruru po, a sum̃alu m̃arera suwa wa se yum̃aena kiena ne Ntewa. A naga pa sike e yokorena, vena va tol pogos nap̃a naga monar vaeme e marana ne le Israel lala. ");
INSERT INTO lww_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ana e pogos nene, p̃arin sup̃e kiena ne le Rom lala, naga kiena kia Sisa Okastas. Ana naga pisawal pisape monar aulo yeririna punu ga e purvanua make ga nap̃a asike vatanon kiena navisuarena. ");
INSERT INTO lww_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yum̃aena nawuloen yaru la nene, la akila p̃esania, a e pogos nap̃a la akila, yeririna kiena ne Sisa tai naga pisuar ke pupia lepas nene Seria, a kia kiena ne yerkawa nena, naga Kuarinias. ");
INSERT INTO lww_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ana nakilaen yum̃aena nene, apisape yeririna punu ga monar ava si e kiela yo lala, vena akilia asiri ruru kiela kia, a aulo ruru la. ");
INSERT INTO lww_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Suri ne nanene kila Yosop molue e pulkumali nene Nasaret, nap̃a naga sike ea, naga nene e lepas nae Kalele, ana naga pa ma metava e pulkumali nene Petleem, nap̃a yermarua P̃arin Sup̃e Tepet naga paeme e nanua sumo, naga nene e lepas nap̃a Yutea, komin nap̃a Yosop naga molue e lus kiena ne yermarua Tepet nene. ");
INSERT INTO lww_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A Yosop p̃ere wona nap̃a Maria lalua apano, nap̃a e pogos nene, naga lavisin ke nap̃a kana sisi vaeme narui. ");
INSERT INTO lww_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ana lalua apano, a pogos nap̃a asike Petleem wa, Maria mninu sane kiena pogos na waren sisi pimi narui. ");
INSERT INTO lww_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ana Maria p̃arlua p̃esan kiena mom̃e nene, a naga mliluwo ruru e kinakinas nen kulmrae lala, ana pe m̃ana yo namonena po re poli, komin lalua akilali asape ava e yum̃a m̃ana wolawa lala, ana pule rui, ana Maria mligan ga sisi tomtom nene m̃ene lelen navaganen surmali lala. ");
INSERT INTO lww_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ana lemalo nene, yaru navisuaren sipsip lap̃as asike amio kiela surmali lala, e yo na vilum̃ini vanuan ga Petleem nene. ");
INSERT INTO lww_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ana navisi tai kiena ne Ntewa pitomi tano pula, a naurarena kiena ne Ntewa tegoli make yo nene sane pupia kapi tai, kila yaru la nene amilan pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ana navisi nap̃ani pis pan la, pisapenua “Ve amarau re. In na nop̃ar ke visena tanea tai ne navisaen van amiu, nap̃a kilia kila yeririna make ga aloge won vap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yemalo ga nini, e pulkumali kiena ne P̃arin Sup̃e Tepet nanua, nane Petleem, nin sisi tai paememare ga na wa, nap̃a yoko naga ve kiamiu Natamaliaena. Naga ke narui pe kiamiu Sup̃e, naga pe Navisaarena nap̃a Ntewa pisaaria nanua rui pisape yoko ligan imi. ");
INSERT INTO lww_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","“A nanene narui nane kile na sur ne tai nini. Yoko alual nin sisi tomtom nene, nap̃a la akila ve tap̃ena vania. Yoko avisu nap̃a aliluwo ga e kinakinas nen kulmrae lala, a amligan m̃eke e lelen kinanen kan surmali lala.” ");
INSERT INTO lww_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ana veraga ga amilan ga pupia p̃egas nen navisi tai nae ma e peni apitom asikol navisi nap̃ani. Ana navisi la nene amieluar Ntewa, amiyau apisape ");
INSERT INTO lww_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ma metava ma e peni, asike amieluar ke Ntewa keviu pap̃isi, a e yomarava nini, sum̃are sike e yeririna la nap̃a Ntewa naga kekaran la.” ");
INSERT INTO lww_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Navisi lala apisawal visena nene p̃isi, apur matan si yaru navisuaren sipsip la nap̃ani, ap̃asup̃e la si apa ma e peni. Ana yaru la nene asum̃a apisasayu ke sina suri la nene pan la, apisapenua “Suwala, ita, tevano. Popon teva garu Petleem vena tevisuli suri nap̃a m̃alivi ga na wa, nap̃a Ntewa pisawal pan ita.” ");
INSERT INTO lww_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ana amiyal kawa apano, apa am̃al Maria amio Yosop, apa akaten sisi tomtom nap̃ani, m̃eke ga m̃ana yo e lele navaganen suri mali lala. ");
INSERT INTO lww_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ana pogos nap̃a apisu suri la nene ana apisawal visena make ga nap̃a navisi pisa pan la e lepas na sisi tomtom nene. ");
INSERT INTO lww_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ana pogos nap̃a yaru tap̃ena la amloge suniena nene, apule mamaga e pupia nailanena tai. ");
INSERT INTO lww_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","A Maria, naga mligan ruru suri la nene e losinena, pe sinen p̃esan re poli, sisitom̃al luen ga silaga. ");
INSERT INTO lww_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ana yaru la nene ap̃asup̃ela si apa pun kiela sipsip lala, asum̃a apisirlua ke kia kiena ne Ntewa, a asum̃a amieluar naga pap̃isi vanon suri wo la nap̃a amloge a nap̃a apisuia, nap̃a atorokin nena ga visena kiena ne navisi nap̃a pisawal pan la. ");
INSERT INTO lww_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ana pogos nap̃a mom̃e nene kiena legiena olua, ana kana pogos na kilaen p̃aviu ea. Akila sanene p̃isi, asikia asape Yesu, kia nena nap̃a navisi pisawal p̃esania, sumon nap̃a Maria m̃ep̃enania. ");
INSERT INTO lww_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","A pogos nap̃a Yesu paeme wik orai p̃aro pae pano, pogos nakilaen kup̃ap̃aena naikikena e Yum̃a Wa m̃ana ne Ntewa narui, naga nene komin kuruta kana sira nap̃a p̃ar sisi. Ana akila kup̃ap̃aena nene, taveve Navisaluaena kiena ne Mosis nap̃a pisape “La nap̃a limala korena ga, akilia awe ga lom̃e ve lua, pona narin kupa ve lua.” Ana e ke e pogos nene, la akus toroun Yesu pa e Yum̃a Wa m̃ana Ntewa, amiyawawo pania. Suri nene taveve m̃ena Navisaluaena kiena ne Mosis, nap̃a pisape “Yerm̃ene punu ga la nap̃a apaeme p̃esia ape wa, la ape kiena ne Ntewa.” ");
INSERT INTO lww_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ana yaru tai sike e Yum̃a Wa m̃ana ne Ntewa e pogos nene, kiena kia Simion. Naga pe yaru nae ga Yerusalem, pe yaru mesmesu tai, a pe yaru m̃arera tai e p̃elaga na leniena. Naga sum̃a sum̃ate ke sape sinenan visu Nasineyeena kiena ne Ntewa nene, nane Navisaarena, imi iila le Israel lala e pog m̃arera nene nap̃a asike ea. Ana Simion nene naga yaru tai nap̃a Ninuna Wa sike e naga silaga, ");
INSERT INTO lww_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","a Ninuna Wa pisawal pa naga rui nap̃a yoko naga tap̃atete kovio, vano vano-o kilamarana visu Navisaarena kiena ne Ntewa sumo wa. ");
INSERT INTO lww_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","A Ninuna Wa p̃ere pimi e Yum̃a Wa m̃ana ne Ntewa, e nena e pogos nap̃a akus sisi tomtom Yesu pimi, vena akila p̃elaga navisaluaena nene. ");
INSERT INTO lww_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ana Simion miap̃ear sisi nene, mieluar Ntewa, pisa potena pania, pisape ");
INSERT INTO lww_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Sup̃e Keviu o, nanagane nepisu suri nap̃a opisaar pan inu, pimi pe lelaga rui. Ana suri nene kila sum̃are pimi e sineu, ana nanagane okilia otam̃an inu, yaru na kiom̃a yum̃aena, nevetan yomarava nini neim̃asu. ");
INSERT INTO lww_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","E ga e kilamarau, nepisu kiom̃a Natamaliaena, ");
INSERT INTO lww_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","nap̃a omligan pimi e maran yolai lala na yomerava, ");
INSERT INTO lww_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","sane kapi tai na kipian koena van yeririna tap̃ena lala, a yoko aieluar imimi kiom̃a le Yu lala, komin kiamimi naurarena nene Yesu.” ");
INSERT INTO lww_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ana Yosop amio Maria lalua amilan visena kiena ne Simion nene pap̃isi nap̃a pisayu Yesu, ");
INSERT INTO lww_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ana Simion pis ke sina ga, pisa ruru la, ana pisa pa anena Yesu, pisape “Ntewa mligan sisi nene pimi pan ita nae Israel vena kila ita ve moki teloru, a vena kila m̃ena ga ita ve moki tesum̃alu sina. Ntewa mligan naga pimi sane kile tai, ana yokorena yaru ve moki nap̃a avisa kare ga naga. ");
INSERT INTO lww_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ana ve sanene, yoko naga kila kiela nasitomwanena la nene am̃alivi e yometava. “Ana e lepas na pum̃a, p̃isi na naloge viowaena yur losinem̃a sane playu na mara tai, yokorena sinem̃a worovia komin suri la nap̃a yoko imi m̃alivin narum̃a nini.” ");
INSERT INTO lww_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","A sira marua tai naga m̃ena teke e poglis nene, kiena kia Ana, nap̃a naga pe navisawalena tai. Ana nene, arimana Panuel, nap̃a molue kome lus kiena ne Aisere nanua sumo. Naga talopa pogos nap̃a pe sira m̃ee ke ga wa, ana naga sike amio wona na yerm̃ene tol kas olua ga, ana wona nene mare tania. Naga pe letano ga sanene, pano-o tol kiena kas lualima orelu pa vari. Naga pe sira tai nap̃a silaga sulueen ga e Yum̃a Wa m̃ana ne Ntewa, nap̃a sum̃a pa ke e pogos na lotuena na kolulagi lala pa tol na yepekilavi, a silaga naga monsilu ga vena len. ");
INSERT INTO lww_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","E poglis nene narui, pimi lavisin la, mlen, pisa potena keviu pa Ntewa vanon sisi nene, a siraunia, molue pano sum̃a pisayu Yesu pa yeririna la nap̃a asun akiravan m̃ate ke asape Ntewa imi tamalia Yerusalem, ana Ana pisawal ruru pan la, nap̃a kiela Navisaarena pimi rui. ");
INSERT INTO lww_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pogos nap̃a Yosop amio Maria akila suri la nene sa nap̃a Navisaluaena kiena ne Ntewa pisa p̃isi narui, ana ap̃ar Yesu ap̃asup̃ela si apito garo kiela pulkumali nene Nasaret, lepas nap̃a Kalele. ");
INSERT INTO lww_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","A nin sisi nene kapur pimi keviu, kiena sitomena pimi pe manmarua ruru po pap̃isi, a apisu nap̃a Ntewa miila naga vena naga kila sur punu ga wo e kiena malena. ");
INSERT INTO lww_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ana e kas punu ga, le Yu la asum̃a akila ke kiela p̃ap̃agena tai, nap̃a P̃ap̃agena na Sitom̃alen Natamaliaena. A silaga, la nap̃a asike e yo tap̃ena lala, la sinelan manene pap̃isi vena ava ma Yerusalem akila p̃ap̃agena nene, a arimana Yesu amio anena, la m̃ena akila ke sanene. ");
INSERT INTO lww_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ana e kas tai, pog nap̃a Yesu kiena kas tol lualima taaga pa lua 12 ke na wa, apa sina, ana ap̃ure Yesu amio la. ");
INSERT INTO lww_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ana la akila suri na p̃ap̃agena la nene pano-o p̃isi, ana yeririna la ap̃asup̃ela si apa e kiela yo lala. Ana Yesu na pe pa re poli, naga sum̃a ga Yerusalem, ana arimana amio anena pe akilia re poli. ");
INSERT INTO lww_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Lalua asitom ke asape pona naga sike amio la p̃asia veraga e pupia p̃egas na kiela namratava lala a kiela erau lala, ana amial m̃a pano-o tol legiena wetelu tai. Ana e yemalo nene akale Yesu pano-o, ");
INSERT INTO lww_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","pe am̃al re naga sike amio la poli, ana apisu sane la monar atayu lala awasup̃e si ava garu Yerusalem vena alualia. ");
INSERT INTO lww_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","La amial legiena wetelu taaga, apim atol si Yerusalem, akale pano-o, ana e legiena tap̃ena, nap̃a kana legiena na telu na kiela yalena, am̃al ga na wa, apisu teke tano e Yum̃a Wa m̃ana ne Ntewa. Naga totano teke amio navianena lala nae e yo nene, tom̃a miyagogon ke kiela visena lala, a tom̃a piuviun ke naviunena la tan la. ");
INSERT INTO lww_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A la nap̃a asike lavisinia e pogos nene, la amilan manene pupia manmaruaena a nakiliaena kiena ne Yesu pap̃isi, amio navisatam̃een la nap̃a naga sum̃a mla ke pan la nap̃a apiun ke suri tania. ");
INSERT INTO lww_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ana pogos nap̃a arimana amio anena apisu nap̃a naga kila ke sanene, amilan pap̃isi, ana anena pis pania, pisape “Ei, naruu! Komin ya ne sinom̃an osape okila kare manene imimi sanene? Opisu ke ne, imimi lua makale ko pano-o, pe mom̃al ko re nena ga, ana okila imimi memloge piowa pap̃isi wa.” ");
INSERT INTO lww_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ana e pogos nene Yesu mla navisatam̃een tai pan lalua, pisa sanini, pisape “?Komin ya ne amiu lua apa akale inu e yo tap̃ena la ne sanene? Sanape, amlua pe asitom̃al re si sane in na monar nesum̃a nekila ga yum̃aena kiena ne kau Ata loyum̃a e m̃ana yum̃a poli?” ");
INSERT INTO lww_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ana navisatam̃eena nap̃a pisa pan la, amninue logekilaleen kana kinasia. ");
INSERT INTO lww_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ana Yesu mligan yo nene, naga pito amio la, ana la ap̃asup̃e si apito e kiela yo nap̃a Nasaret. A Yesu su pogaga amio la e yo nene, sum̃a mlogear ruru la m̃a silaga. A anena nap̃a Maria sum̃a sitom̃al luen ga suri la nene loyum̃a e losinena silaga. ");
INSERT INTO lww_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ana kas la pimi p̃aro pano, a Yesu kapur pimi keviu, a kiena manmaruaena amio kiena maruaena sum̃a pimi keviu laa narui, a Ntewa sum̃a pisa ruru naga keviu pap̃isi, kila yaru la apisu naga po na po, akekaran manene naga pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ana kas lap̃as p̃aro pa rui, ana Yoane Nakeena, narina ne Sakaraea, naga pimi m̃aliv e yokorena. Naga nene e pogos nap̃a pupia P̃arin Sup̃e Taepirias Sisa nae Rom naga pe sup̃e keviu ke tol kana kas lualima taaga pa lima rui, a e poglis nene na mliganar kiena yerkawa lap̃as rui, sane Ponses P̃aelat, naga pisuar Yutea, a Erot, naga pisuar Kalele, a wenla nap̃a Pilip, naga pisuar lepas nae Ituraea amio Trakonatis, a Lasanias, naga pisuar lepas nae Apilin. A e m̃ena ga e pogos nene, lalua nap̃a ape p̃ar na yaru wa lala asike garu Yerusalem, naga Anas amio Kaep̃as. Ana Yoane sike garu yokorena, ana Ntewa mla visena la pania, ");
INSERT INTO lww_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ana naga pa make e lepas punu ga na wii nae Yortan, naga sum̃a mlologon ke pisape yaru la punu ga monar avilopu la, a monar ava e nakeena, ana yoko Ntewa naga viewo kiela mlamulena viowa lala. ");
INSERT INTO lww_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Naga kila sa ga nap̃a Navisawalena Aisea pisa nanua rui e kiena tusi, nap̃a sape “Pulgo tai sum̃a pio ke e yokorena, sape Akila ruru make mrapa kiena ne Ntewa, vena naga kilia imi m̃alivi e kiamiu malena lala. ");
INSERT INTO lww_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yoko kam na monar asinwo make pulp̃alu lala, a monar akilro kunus la su ga tano, a yo la nap̃a kapinia la monar aim amesmesu ruruia a yo la nap̃a p̃ilp̃il la monar aim ameri ruruia; ");
INSERT INTO lww_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ana sanene, yoko yolai la punu ga avisu kiela Natamaliaena nap̃a Ntewa ligania yalin la e mrapa nene imi m̃alivin la.” ");
INSERT INTO lww_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yum̃aena kiena ne Yoane, naga mlologon sanene narui, ana pogos nap̃a p̃ina la moki amolue apa e yokorena vena naga kee la, naga pis m̃arera pan la, pisa sanini, pisape “Kam na sa ga lom̃ara la nap̃a amaraun kapi tai ana ap̃ure, ana kam na asitom asape akilia aurmatan pupia anen kapi nap̃a Ntewa yoko ligan imi? Peraga, komin pe apilopu amiu ruru re poli wa. ");
INSERT INTO lww_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ana visae lelaga kemua nap̃a amaraun nakoaena nene, kiamiu malena lala monar war mras wo la nap̃a torokin kiamiu navilopuena nene. Ana avisuaria, ve awarwar amiu re sina, sa nap̃a akila ke rui, nap̃a asum̃a apisa ke asape ‘E, ita na tesum̃a poga ga rui, okilakan ita ke narui tepe lus kiena ne Epraam nena nap̃a.’ Ana nanene na pe sur re tai nene poli, komin nap̃a visae Ntewa sinenania, naga kilia war kilavaru la nene, yum̃aen lus kiena ne Epraam la ve moki ea, vena la akus lelemiu. ");
INSERT INTO lww_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","In na nevisa van amiu, nevisave m̃ekiavi mon ruru m̃eke rui, vena te plan laki la nap̃a pe ap̃ar re mras wo la poli, akoven la ava e kapi.” ");
INSERT INTO lww_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ana pogos nap̃a p̃ina la amloge nene, amarau na amarau, ana apiunia, asape “Ana visae ve sa nene, yoko imimi mekila ve sanape narui?” ");
INSERT INTO lww_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ana Yoane pisatam̃e la, pisape “Yar nap̃a m̃ana kulsaket lua, yoko naga monar tam̃an tai va yar nap̃a pe m̃ana re tai poli. Yaru nap̃a kana kinanena keviu, yoko naga monar vion re komp̃as va yar nap̃a pe kana re poli.” ");
INSERT INTO lww_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A yar na takis la moki, nap̃a ape li nakila keuiaen nena yar lala, apimin vena Yoane kila nakeena van la, ana la m̃ena ga apisu kilale kiela napiowaena lala, ana la apiun m̃ena ga asape “?Navianena, sanapen imimi, yoko imimi monar mekila ve sanape?” ");
INSERT INTO lww_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ana naga pisa pan la, sape “Yoko awarpolo vetan yaru lala torokin ga ya nap̃a la monar aulia, ana ve yuve re, sa nap̃a akila ke p̃isi rui.” ");
INSERT INTO lww_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ana yaru na mara m̃ena lap̃asia apiun sanini pa Yoane, asape “?A imimi, yoko mekila ya?” Ana naga pis pan la, pisape “Amiu apuarar ke kiamiu suri na mara lala, ana yaru la asum̃a amaraun amiu pap̃isi, lala sane visae pog tai sinemiun kiela suri tai, amiu avisa ga ana monar atam̃ania. Ana p̃elaga nene, yoko monar ve akila re sina. A asum̃a sinemiu mimi lue silaga asape yerkawa la nene apul amiu ve tokak ga, pona torok ga yo, ana monar akekaran ga narui.” ");
INSERT INTO lww_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","E pogos nene, le Yu lala asum̃a asitom ke asape kiela Navisaarena lavisi m̃alivi, ana amloge visena wo la nene kiena ne Yoane, akekarania, ana naviunena sike e kiela sitomena lala, asum̃a apiuviun ke, asape “O, pona yaru ne nanene yo, naga pe kieta Navisaarena, pona peraga?” ");
INSERT INTO lww_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ana Yoane sum̃a pisawal ruru merarava pan la, pisape “Peraga. In na nepitom sumo, vena nesum̃a nekee amiu ke ga e wii, ana yaru tap̃ena tai vim siraun inu. Yaru nene, naga to laa metavan inu, a in na pe netorokin re nap̃a nelup̃arlua kulus nen lana poli pona nekila kiena yum̃aena tap̃ena. Ana naga ke narui, yoko kee amiu e Ninuna Wa, amio kana kapi nena, vena kekan plan kororaki lala vetan kiamiu malena. ");
INSERT INTO lww_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Naga sa nap̃a naga tarar ke koruak nayuraren wit, vena silsilin plan kana kinas lala. Ve sanene, yoko naga war ruru kinas nen wit la nene va um̃a, ana yoko naga koven vinus va e kapi tai nap̃a tap̃atete mare pogos tai.” ");
INSERT INTO lww_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nanene narui, Yoane Nakeena mlologon Lologena Wo pa yeririna la sa ke nene narui, a naga sum̃a pisa ke m̃ena visena wo naiilaaren tap̃ena la pan la, a visena nakila p̃egelaena. ");
INSERT INTO lww_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ana yar tai pe kekaran re nena Yoane, nane P̃arin Sup̃e Erot, komin Yoane sum̃a pis ke pania vanon nap̃a naga p̃erelua sira nene Lerotias, nap̃a wona wenla, a pis pania vanon sur tap̃ena m̃ena lap̃asia nap̃a naga kila. ");
INSERT INTO lww_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ana metavan kiena napiowaena tap̃ena lala, Erot sinen kar Yoane pano-o, sum̃al narui koven pa e yum̃a naloge viowaena. ");
INSERT INTO lww_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ana pogos nap̃a Yoane pe pa re e yum̃a naloge viowaena poli wa, naga kee m̃a yeririna la pano-o, ana pog tai Yesu m̃ena pimi e yo nene, ana Yoane kee m̃ena naga. Ana pogos nap̃a Yesu molue e wii, sum̃a mlen m̃aga, ana veraga ga sinapane pike, ");
INSERT INTO lww_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","a Ninuna ne Ntewa pimi pe tasa, mom̃a pitomi tano sane lom̃e tai, pitomi pran ea. Ana Ntewa pis ma e peni pitomi pania, pisape “Ko Naruu nene, nap̃a nepinaia ko pap̃isi. Kiau sitomena sike ga e ko, nekekaran ko pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ana siraun nap̃a Yoane kee Yesu, ana naga siar kiena yum̃aena narui, a e poglis nene, naga kiena kas la tol lualima telu. A lus nap̃a Yesu molue komea, e lepas na yerm̃ene, siar e Yosop, nap̃a apisu sane arimanane Yesu, pa sanini: Yosop, naga narina ne Eli; ");
INSERT INTO lww_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli, naga narina ne M̃atat; M̃atat, naga narina ne Livae; Livae, naga narina ne Melki; Melki, naga narina ne Sanae; Sanae, naga narina ne Yosop; ");
INSERT INTO lww_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosop, naga narina ne M̃atateas; M̃atateas, naga narina ne Amos; Amos, naga narina ne Neam; Neam, naga narina ne Esli; Esli, naga narina ne Nagae; ");
INSERT INTO lww_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagae, naga narina ne M̃at; M̃at, naga narina ne M̃atateas; M̃atateas, naga narina ne Semein; Semein, naga narina ne Sosek; Sosek naga narina ne Sot;, ");
INSERT INTO lww_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Sota, naga narina ne Soanan; Soanan, naga narina ne Resa; Resa, naga narina ne Serup̃apel; Serup̃apel, naga narina ne Saltiel; Saltiel, naga narina ne Neri; ");
INSERT INTO lww_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, naga narina ne Melki; Melki, naga narina ne Ati; Ati, naga narina ne Kosam; Kosam, naga narina ne Elm̃atam; Elm̃atam, naga narina ne Ere; ");
INSERT INTO lww_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere, naga narina ne Yosua; Yosua, naga narina ne Eliesa; Eliesa, naga narina ne Sorim; Sorim, naga narina ne M̃atat; M̃atat, naga narina ne Livae; ");
INSERT INTO lww_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livae, naga narina ne Simion; Simion, naga narina ne Suta; Suta, naga narina ne Yosop; Yosop, naga narina ne Sonam; Sonam, naga narina ne Eliakim; ");
INSERT INTO lww_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim, naga narina ne Melea; Melea, naga narina ne Mena; Mena naga narina ne M̃atata; M̃atata, naga narina ne Natan; Natan, naga narina ne Tepet; ");
INSERT INTO lww_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tepet, naga narina ne Sese; Sese, naga narina ne Opet; Opet, naga narina ne Poas; Poas, naga narina ne Sala; Sala, naga narina ne Nason; ");
INSERT INTO lww_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason, naga narina ne Aminatap; Aminatap, naga narina ne Atmin; Atmin, naga narina ne Ani; Ani, naga narina ne Esron; Esron, naga narina ne Peres; Peres, naga narina ne Suta; ");
INSERT INTO lww_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Suta, naga narina ne Sekop; Sekop, naga narina ne Aisak; Aisak, naga narina ne Epraam; Epraam, naga narina ne Tera; Tera, naga narina ne Nao; ");
INSERT INTO lww_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nao, naga narina ne Seruk; Seruk, naga narina ne Reu; Reu, naga narina ne Pelek; Pelek, naga narina ne Ep̃a; Ep̃a, naga narina ne Sela; ");
INSERT INTO lww_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela, naga narina ne Kaenan; Kaenan, naga narina ne Ap̃aksati; Ap̃aksati, naga narina ne Sem; Sem, naga narina ne Noa; Noa, naga narina ne Lamek; ");
INSERT INTO lww_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek, naga narina ne Metusela; Metusela, naga narina ne Inok; Inok, naga narina ne Saret; Saret, naga narina ne Malalil; Malalil, naga narina ne Kaenan; ");
INSERT INTO lww_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaenan, naga narina ne Enos; Enos, naga narina ne Set; Set, naga narina ne Atam; ana Atam, naga narina ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ana pogos nap̃a Yesu pimi si e lepas na wii nae Yortan nap̃a Yoane kee naga ea, naga pulen Ninuna Wa pap̃isi. Ana Ninuna p̃ere Yesu pa ke sina ga e yokorena, ");
INSERT INTO lww_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","a naga sike e yo nene pa tol legiena lualima yam vari, nap̃a p̃arin sup̃e kiena ne yermare lala sum̃a kilali naga. Ana e legiena la nene, pe kinan re poli, sum̃a pano pano-o tol nap̃a visokar na visokaria. ");
INSERT INTO lww_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ana Yermare Lego nene pimi pisa pania, pisape “Visae ko ope Narina ne Ntewa kemua lelaga, ovisali va kilavaru nene imi ve kilaparavi, vena okania.” ");
INSERT INTO lww_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ana Yesu pisatam̃ea, pisape “Peraga, komin Visena Wa pisape ‘Pe yar malin re ga kinanen poli.’” ");
INSERT INTO lww_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ana Yermare Lego sinenan sape kilali sina Yesu, ana p̃ere kiena sitomena pa metava e pupia kunus tai. Kipian naga e purvanua make ga na yomarava nini, ");
INSERT INTO lww_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ana pisa pania, pisape “Navisuaren yo la nene, amio kala naurarena make ga, asike pa e lum̃au rui. Inu nop̃ar kian la, ana nekilia netam̃an va yar ai nap̃a in na sineun nesape netam̃an vania. ");
INSERT INTO lww_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pogaga, visae ovatanon inu, olotun inu, vera na neligan make sur la nene se lumom̃a.” ");
INSERT INTO lww_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ana Yesu pisatam̃ea, pisape “Visena Wa pisape ‘Olotun ga Ntewa okila ga kiena yum̃aena naga taaga, komin naga ga pe kiom̃a Sup̃e.’” ");
INSERT INTO lww_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ana Yermare Lego sinenan sape kilali sina Yesu, p̃ere kiena sitomena pito garo Yerusalem, mligan naga e yo tai nap̃a pa manene metava, e wos nen yum̃a m̃ana Ntewa, ana pisa pania, pisape “Visae ko ope Narina ne Ntewa, oula oto tano. Okilia okila woga ga ne, ");
INSERT INTO lww_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","komin nap̃a Visena Wa pisayu Ntewa, pisape ‘Naga yoko ligan kiena navisi lala, vena aim asum̃a amio ko, avisuar ko m̃aga. ");
INSERT INTO lww_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Yoko ayukop yaun ko ga vena ve otan re lam̃a e kilavaru.’” ");
INSERT INTO lww_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ana Yesu pisatam̃e ke sina ga, pisape “Peraga rui, komin Visena Wa pisa m̃ena ga pisape ‘Ve om̃areran re okilali kiom̃a Sup̃e Ntewa vena kila kiom̃a sur tai.’” ");
INSERT INTO lww_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ana pogos nap̃a Yermare Lego kilali kiena natap̃aliena la nene pa Yesu p̃isi, ana purmatania pano, naga pa sum̃ate ke vena lual pogos tap̃ena nap̃a sitom ke sape kilia taulu Yesu ea. ");
INSERT INTO lww_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ana siraunia, Yesu mialoro e nam̃areraena kiena Ninuna Wa, pimi tol yo Kalele, ana yar la apisayu naga pano-o kalo make yo lepas nene. ");
INSERT INTO lww_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ana naga sum̃a pa ke e kiela yum̃a na leniena lala, sum̃a pian la, ana asum̃a akekaran naga pap̃isi, asum̃a apisirlua ke kiena kia. ");
INSERT INTO lww_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Ana Yesu pimi tol kiena yo nap̃a Nasaret, nap̃a kapuru pimi keviu ea, ana e Legiena Wa, sa nap̃a kila m̃a silaga, naga pa amio la e kiela yum̃a nalenena. Ana asape naga ulolua Visena Wa Kiena ne Ntewa van la, ana akian tus nap̃a Aisea siriyu pania. Ana naga sum̃alu na pikep̃a tus nap̃ani, m̃al e nap̃a sinenan sape ulolua van la, ana puloia, nap̃a pisa sanini, pisape ");
INSERT INTO lww_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ninuna ne Ntewa sike e in rui, komin nap̃a Ntewa mligan inu vena in ke narui nap̃a nelologon Nalologena Wo va la nap̃a limala korena ga. Naga mligan inu nepimin vena nevisawal va la nap̃a asike e yum̃a naloge viowaena, nevisave nanagane, akilia amolue ga sa ga ne, a vena nevisawal va kilamara p̃ala lala, nevisave nanagane, kilamarala la kilia imi wo sina. A naga mligan inun sape yeririna la nap̃a asike tano, nap̃a yar tap̃ena la asum̃a akila kare la ke silaga, yoko in na neure plan la, aim asu si e yo wo tai. ");
INSERT INTO lww_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ana sanene, in na nekilia nekila merarava nevisave nanagane, Ntewa kila kiena pog viu nowo tai pimi m̃alivin yar la nene rui.” ");
INSERT INTO lww_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ana pogos nap̃a Yesu pulo nawuloena nene p̃isi, naga pulonar si tus, kian si pa yaru na visuaren yum̃aena, ana pa to meta e lelen nalologena, vena vis va yar lala. Ana la make ga nap̃a asike loyum̃a asum̃a atamaria Yesu asape am̃a yoko aloge ya ne visa van la ne wa. ");
INSERT INTO lww_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ana pogos nap̃a naga siar kiena visena, ana pisa sanini, sape “Nevisa van amiu, nevisave Visena Wa kiena ne Ntewa nap̃a amloge ga na wa, kana visena la nene pimi pe lelaga nagane ga na wa, e maramiu.” ");
INSERT INTO lww_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ana pogos nap̃a yar la amloge visena la nap̃a kiena ne Yesu, amloge sane naga pis ruru po na po, pis malumu ga a pis tanea p̃isa, ana la amilan pap̃isi, asum̃a apisavisa pan la sanini, asape “!Ana yar nene, naga narina ne Yosop ga nene! ?Naga p̃ar visena tanea la ne sanene pe ne?” ");
INSERT INTO lww_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ana Yesu pisatam̃e la, pisape “Pona sinemiun asape avisa kieta visena marua nene van inu yo, nap̃a pisape ‘Tokta, okila ruru ko sumo wa, ana siraunia okilia oiila yar tap̃ena.’ Nanene komin nap̃a amloge p̃isi rui nap̃a nesike gar Kapeneam, nekila ruru ke namaiena la moki, ana asitom asape komin ya ne pe nepim nekila re m̃ena sanene pan amiu e kieta yo nini poli. ");
INSERT INTO lww_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ana lelaga nevisa van amiu, sane visae navisawalena tai, ana kiena yeririna lala nae kemua kiena yo nap̃a, la tap̃atete akekarania, tap̃atete alogearia. ");
INSERT INTO lww_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Nanene na lelaga. Sineun nesape asitomyuli pogos kiena ne yermarua Elaisa nanua sumo. E pogos nene, yua pe powo re poli pa tol kas telu komsusa, a pupia viso tai kalo make yo Israel. ?Ana Ntewa mligan Elaisa pa miila ane e poglis nene? Apisu ke ne, pe mligan re naga panon iila letano nae Israel lala tai nap̃a amloge ke piowa poli, ana mligan naga pa miila letano nae pulkumali keviu nene Sarep̃at, nane lepas tap̃ena nap̃a Saeton. ");
INSERT INTO lww_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ana asitomyuli m̃ena ga pogos kiena ne yermarua Elisa. ?E pogos nene, yar la moki nap̃a ap̃ar leperosi, ana Ntewa kila ruru ai? Naga pe kila ruru re le Israel lala tai nap̃a ap̃ar maiena nene poli, ana kila ruru ga yere Seria nene nap̃a Neman. Lelaga-o, ita yeririna la nap̃a tepisa ke tesape ita nena nap̃a tepe yeririna lala kiena ne Ntewa, ana yar la nap̃a Ntewa mligan la apimin asape akila kieta yum̃aena, ana yepeta mavin la ke sina ga.” ");
INSERT INTO lww_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ana pogos nap̃a la nene asike loyum̃a nalenena amloge visena nene, kiela sitomena la pilon pa pe tap̃ena narui, nagane la sinela kar Yesu narui. ");
INSERT INTO lww_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ana la aplamoluen Yesu, ap̃urelua naga petan kiela pulkumali pa vanua, ap̃ure pa e pupia yeparpas tai nap̃a kiela pulkumali m̃eke ea, la sinelan asape akuan Yesu vito tano e yo ne nanene narui. ");
INSERT INTO lww_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ana Yesu kila nap̃a la tap̃atete si auarar naga, ana mial ga pa p̃aro likan la sanene pano, mligan la asike na. ");
INSERT INTO lww_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ana Yesu mial pito tol pulkumali tap̃ena nae Kalele, nane Kapeneam, ana e Legiena Wa naga pian la e kiela loyum̃a na leniena. ");
INSERT INTO lww_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ana la nap̃a amiyagogonia amilan pap̃isi, komin amloge kiena visena urmi pap̃isi, a nam̃areraena kiena ne Ntewa sike ea. ");
INSERT INTO lww_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ana pogos nene yar tai sike loyum̃a amio la, nap̃a ninuna ne yermare viowa tai sum̃a kila kare naga, ana yar nap̃ani pio manene kare Yesu pap̃isi, pisa pania, pisape ");
INSERT INTO lww_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“?Ei, Yesu nae Nasaret, kiom̃a ya na teke e imimi? !Pona ko opimin osape okila kare imimi yo, a! Komin nap̃a in na nekilia ko rui, sane ko ope Yar Wa nena napo tai kiena ne Ntewa.” ");
INSERT INTO lww_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ana Yesu pis m̃arera pa yermare viowa nap̃ani, pisalup̃aria, pisape “!Ei, ve ovis re sina! Omolue ke vetan yar nene nagane.” Ana ninuna viowa nap̃ani koven yar nene mloru pito tano likan la, ana molue petania pure pano, ana yar ne po sina ga sike na. ");
INSERT INTO lww_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ana yar na yo la nene amilan pap̃isi, ana apisasayu Yesu, asape “?Ei, visen ya na sanene? Nanene yar m̃arera tai nene yo, kiena nam̃areraena keviu pap̃isi wa. Naga pis ga pa ninuna viowa lala, ana apureure ga sa nene.” ");
INSERT INTO lww_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ana komin sur ne la nanene narui la akekara, a asum̃a apisa ruru kia kiena ne Yesu mlewo pa e yo punu ga e lepas nene. ");
INSERT INTO lww_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ana Yesu sum̃alu pa vanua e yum̃a nalenena nene, ana pa um̃a m̃ana Saemon, nanene gar ke Kapeneam na wa. Ana e um̃a nene auia simem kana Saemon mloru m̃eke e togin namaiena, yepena pisusun, ana apisawal pa Yesu, apiun pania asape sanape e sira marua nene. ");
INSERT INTO lww_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ana Yesu pimi sum̃alu se yepas nen sira nap̃ani, ana pisalup̃ar maiena nena, ana yepen pimi manin sina, mloge nena po, ana sum̃alu pa miyum̃aen kala kinanena. ");
INSERT INTO lww_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ana pogos nap̃a mrae pito tano, sane Legiena Wa nene p̃isi narui, la nap̃a kiela namaiena la asikena, ap̃erela apim puna Yesu, ana Yesu p̃uarar la, kila ruru la. ");
INSERT INTO lww_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","A la moki nap̃a, yermare la amolue petan la, nap̃a asum̃a akiikii, asape “!Ei, ko kemua nap̃a ope Narina ne Ntewa narui!” Ana Yesu pisalup̃ar yermare la nap̃ani, pisape ve avisa re si suri tai, komin nap̃a akilia rui asape naga Navisaarena kemua lelaga. ");
INSERT INTO lww_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ana kolulag kona, Yesu sum̃alu naga taaga molue pa vanua, pa e yo m̃ano tai nap̃a pa ruru po na po pap̃isi. Ana siraunia, yar la apiminia, akale m̃a pano-o am̃al e yo ne nanene, a la sinelan asape naga sum̃a amio la, akilali asape avisalup̃aria vena ve ligan la re, ");
INSERT INTO lww_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ana pisa pan la, pisape “Toko, in na monar neva nelologon Nalologena Wo na sup̃enena kiena ne Ntewa va e pulkumali tap̃ena la nap̃a asike ga wa, komin naga mligan inu nepimin suri ne nanene.” ");
INSERT INTO lww_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ana naga petan la, pano mlologo teliv make e yum̃a nalenena lala e pulkumali punu ga nae lepas nap̃a Yutea. ");
INSERT INTO lww_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pogos tai, Yesu sike e yepas nen pupia lapa nap̃a lap̃as asape Lapa nae Kenasaret, a lap̃as asape Lapa nae Kalele. A e pogos nene, yaru la nap̃a asum̃alu amiyervivi Yesu la moki pap̃isi, sane yepa ve tokaki ga, komin nap̃a sinelan asape aloge naga lologon visena kiena ne Ntewa van la. ");
INSERT INTO lww_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ana Yesu pisu waa lua nap̃a sike ga lavisinia, nap̃a ap̃ure pimi sike ga e kukunone, a pisu kana yar ne la asum̃alu asike e sive, asum̃a akevan ke kiela lilivi lala. ");
INSERT INTO lww_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ana Yesu mial pano pa miai e waa tai nene, nap̃a kiena ne Saemon, ana pisa pania pisape suponlua va li laa sane. Ana Yesu teke e waa nap̃ani, tom̃a pian ke la nap̃a asike ura. ");
INSERT INTO lww_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ana pogos nap̃a naga pis pan la p̃isi, naga pisa pa Saemon, pisape “Ita, in na sineun nesape teva re laa e lowe memaena, vena toure re lilivi wa.” ");
INSERT INTO lww_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ana Saemon pisatam̃ea, pisape “E yerkawa, imimi mekila sur nene rui pano-o yemlagi, ana pe metol re nena ika tai poli. Ana komin nap̃a opisa sanene pan inu, poga, nekekaran nap̃a tevali ga.” ");
INSERT INTO lww_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ana la apa akila sa nap̃a Yesu pisa, ana la amilan pupia p̃egas nen ika tai pulen ga kiela lilivi nap̃ani, kila kiela lilivi nene siar pororovia, ");
INSERT INTO lww_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ana la apio lap̃as nap̃a asike e waa tap̃ena, la akup̃in limalan la vena aim aiila la. Ana la nap̃a apim, ana asum̃a ap̃ere lilivi nap̃ani amio kana ika ne lala apa metava e waa luwoka nene, pano-o waa luwoka ga nap̃ani pulemamaga ruru nena ga, lavis luoka ga talilu. ");
INSERT INTO lww_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ana Saemon pisu sur la nene, pisu kilale sane Yesu ga miyum̃aen e kiena pupia nam̃areraena wa, ana kinai tano e mialana ne Yesu, pisape “Sup̃e, in na nepe yar viowa ga tai. Popon oure matan inu, ve osu re si lavisin inu.” ");
INSERT INTO lww_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","A pe naga re ga taaga po, ana la m̃ena nap̃a asike amio e pogos nene, la punu ga amilan p̃an wa e pupia p̃egas nen ika nap̃a la ap̃ar ne, ");
INSERT INTO lww_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","amio narina ne Sepeti lua nene, Semes lalua Yoane, nap̃a asikol la amio Saemon amiyum̃ae lele taaga, la m̃ena luoka amilan pap̃isi. Ana Yesu pis pa Saemon, pisape “Ei, ve omaraun re si sur nene. Siar nagane, yoko ve oure re si ika, ana yoko osum̃a oure yar la aimi ataveve inu.” ");
INSERT INTO lww_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ana ap̃asup̃e la, ap̃ere si kiela waa la nap̃ani apa ura, ana pe akila re si sur tap̃ena poli, amligan kiela sur punu ga sum̃a sanene, ana ataveve Yesu apavini. ");
INSERT INTO lww_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ana siraunia, e pogos tai, Yesu sike pulkumali tai e yo nene, ana yar tai m̃alia pimi puna, nap̃a yaru nena, maiena nap̃a leperosi kilapel naga kila kare nena tasnena. Ana yaru nap̃ani pimi mloru e lana ne Yesu, tag pania, piun tania, pisape “Sup̃e! In na nemlelaga nesape ko okilia okila ruru in si wo ga, ana visae okekarania, in na sineun nesape neviun tan ko vena okila inu neikiki sina ga.” ");
INSERT INTO lww_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ana Yesu pe maraun re tolen maiena kiena ne yar nene poli, ana puararia, pisa pania pisape “Ee, in na sineun nesape yepem̃a yania.” Ana veraga ga yepena miania, leperosi nap̃ani p̃isi e naga. ");
INSERT INTO lww_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ana Yesu pisa pania, pisape “Omloge ke ne, ovano ve ovisayu re sur nene va yar lala wa, ana nanagane ova nena okom puna ne yar wa vena naga visu ko lia, a kilia visawal visave tasnem̃a mian rui. Siraunia, ana monar ova okila lotena va Ntewa a okila kup̃ap̃aena na kiom̃a yepe ikikena nene, sa nap̃a Mosis pisape monar akila.” ");
INSERT INTO lww_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yesu pisape yar nene vano ve visayu re sur nene, ana peraga, pe piavi re poli asum̃a apisayu m̃a Yesu pano-o pa tol yo punu ga, kila sane pupia p̃ina la apimin asape aloge kiena visena, ana la sinelan asape naga kila ruru kiela namaiena lala. ");
INSERT INTO lww_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ana e pogos la punu nene Yesu sum̃a petan m̃ena yeririna lala, pa ke e yokorena, mlen ke pa Ntewa. ");
INSERT INTO lww_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ana pogos sina tai, Yesu pian la m̃aga, a Varasi lap̃asa amio navianena navisaluaena lala atom̃aga tano e nene, nap̃a la na pulkumali tap̃ena lala e lepas lala nae Kalele amio Yutea, a lap̃asia amolue Yerusalem apimi. Ana e pogos nene, nam̃areraena kiena ne Ntewa pimi keviu manene laa e Yesu narui, kila naga kila ruru namaiena lala. ");
INSERT INTO lww_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ana yar lap̃asia akus namaiena tai pimi, nap̃a yepena la punu ga marmare, nap̃a akus pimi ana mlor ga m̃eke e m̃ana tog. La sinelan asape akus imi loyum̃a aligan mon lavisin Yesu, ");
INSERT INTO lww_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ana apisu sane pupia p̃ina m̃eke pa loyum̃a rui, ana yo ve tokak pap̃isi, tap̃atete akus kiela erau nene vano. Ana akus pa metava e wos nen yum̃a narui, akawepo lologia Yesu, ana amligan malumun yaru nap̃a amio m̃ana tog pito tano e pulus nap̃ani, pito m̃eke likan yeririna lala, m̃eke nena ga vamon Yesu. ");
INSERT INTO lww_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","A pogos nap̃a Yesu pisu suri nene, naga kilia nap̃a la amlelaga m̃arera e naga pap̃isi, asape yoko naga iila namaiena nene, ana naga pisa pania, pisape “M̃ara, in na nepiewo kiom̃a mlamulena viowa rui.” ");
INSERT INTO lww_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ana pogos nap̃a Varasi amio navianen navisaluaena lala amloge visena nene, asitom piowa e naga pap̃isi, ana asum̃a apiuviunia, asape “?Ane p̃arnena kare ke kia wa kiena ne Ntewa sanene? Ntewa naga taaga kilia viewo mlamulena viowa, pe yar tap̃ena re si poli, ana yaru nene pis ke sa nap̃a naga sitom ke sape naga Ntewa nene narui.” ");
INSERT INTO lww_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ana Yesu mninu kilale rui sape asitom ke piowa sanene e naga, ana pisa pan la, pisape “?Komin ya ne sinemiu la pulen ke sitomena viowa la sanene? ");
INSERT INTO lww_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Visae nevisa ve sanini va namaiena nene, nevisave ‘In na nepiewo kiom̃a mlamulena piowa,’ pona nevisa vania nevisave ‘Osum̃alu, oyali,’ ana visena lua nene, tai m̃areran navisaena, a tai meme ga. Na nap̃a sape ‘Osum̃alu, oyali,’ naga m̃arera laa sane, komin nap̃a yoko okilia ovisu kilale sane kiau visena pe lelaga pona peraga, nap̃a yar nene sum̃alu pona tap̃atete sum̃alu. ");
INSERT INTO lww_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ana nanagane p̃isi na nekila suri tai nap̃a asitom asape Ntewa ga naga taaga kilia kila, ana avisu kilale sane in na Narina ne Yeririna, nam̃areraena sike e inu. A nevisa van amiu, nesape nam̃areraena nene torokin nekilia neviewo m̃ena mlamulena viowa e yomarava nini. Ayagogo ruruia.” Ana Yesu pis pa namaiena nap̃ani, pisape “Nevisa van ko, nesape osum̃alu, ovilonar mom̃a tog, oyali ova um̃a.” ");
INSERT INTO lww_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ana sa nena nene, e marana ne la nap̃a apisu ke ne, yar nene sum̃alu, p̃ar m̃ana tog, mial pa vanua, naga pa um̃a nap̃a sum̃a miyeluarliluen Ntewa sanene pano. ");
INSERT INTO lww_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","A pogos na la nap̃ani apisu suri nene, amilan kare nena lelaga, yepela p̃il pap̃isi, asum̃a amiyeluar Ntewa, asape “E suwala, lelaga kemua-o, p̃ane na ita tepisu sur tai nap̃a pe tap̃ena pap̃isi!” ");
INSERT INTO lww_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ana siraunia, Yesu mialili ga pa laa sane, ana m̃al yar tai totano teke e kiena yum̃aena e yum̃a na warpoloen takis. Yaru nena, kiena kia Livae. Ana Yesu pio, sape “Oim otaveve inu.” ");
INSERT INTO lww_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ana Livae sum̃alu nena ga, mligan kiena yum̃aena, mligan kiena suri punu ga sike na, ana taveve Yesu. ");
INSERT INTO lww_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Siraunia, Livae nena kila pupia kinanena tai kana ne Yesu e m̃ana um̃a, a e pogos nene, yar na takis tap̃ena la moki, amio m̃ena yar tap̃ena la moki na sanene, la m̃ena apim ato lele taaga amio Yesu amio kiena nalogena lala e kinanena nap̃ani. ");
INSERT INTO lww_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ana Varasi lap̃asia, amio kiela navianen navisaluaena lap̃asia, apragogo pa nalogena lala, asape “?Komin ya ne akinan ke lele taaga sanene amio yaru viowa lala a p̃arm̃arera la nene?” ");
INSERT INTO lww_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ana Yesu ke pisatam̃e la narui, pisape “La nap̃a tasnela m̃arera ruru poga ga, la pe asitom re asape ava akom pun yar na kilaruruen maiena poli, ana la ga nap̃a ap̃ar maiena, la sinelan pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","In na pe nepimin re nevio yar la nap̃a apisa ke asape la apo rui e marana ne Ntewa vena ataveve inu, ana in na nepimin ke yeririna viowa la ne sanene narui, vena avilopu la vetan kiela mlamulena viowa lala.” ");
INSERT INTO lww_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ana la apiun naviunena tai pa Yesu, asape “Nalogena kiena ne Yoane Nakeena la asum̃a apuarar ruru ke p̃elaga nene nap̃a yam mokliu, asum̃a amonsilu ga vena alen va Ntewa, a Varasi m̃ena la akila sa ke ga. ?Ana komin ya ne kiom̃a nalogena la pe akila re poli, ana la asum̃a akinana a asum̃a amun ga sanene?” ");
INSERT INTO lww_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ana Yesu pisatam̃e la, pisayu naga amio kiena nalogena lala, sane la akekara pap̃isi pogos nap̃a naga sike amio la, ana yoko sinela viowa sirau e pogos nap̃a naga ure matan la. Ana pisape “?Pogos nap̃a yar natalopaena sike amio kiena erau lala wa, asitom asape yoko akilia aligan kinanena na p̃ap̃agena nene sike na, ve akan re? Peraga. ");
INSERT INTO lww_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ana yoko pogos tai imi, nap̃a yoko aurelua yar natalopaena nene vetan kiena erau lala, a e pogos nene narui akilia amonsilu, komin nap̃a sinela miye naga pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","P̃elaga na monsilena nene, naga p̃elaga marua tai nalotena kiena ne le Yu lala, ana Yesu sinenan sape kila meraravan sane p̃elaga marua na sanene, tap̃atete asikol amio suri viu la nap̃a naga pian la ke ea, ana pisa p̃akaiwa tai e lepas nene pan la. Pisape “Tap̃atete ola kinakinas nen kulmrae viu tai, nap̃a ovitolp̃a kinakinas tai, ana osuluar e kulmrae marua vena kilawo pulus nap̃a teke ea. Visae sanene, yoko opitol p̃a kare kulmrae viu nene narui, ana kana kinakinasa, yoko tap̃atete nena marana ve sa ke kulmrae marua nene, ana apisu piowa ga. ");
INSERT INTO lww_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","A tap̃atete okokonia kuruta viu nap̃a m̃eke p̃ep̃ela ke ga wa va e kulus nen nane tai nap̃a pe urmarua, nap̃a akon kuruta pa e yam moki li rui. Visae okila sanene, yoko kuruta viu nene lapa, kila kulus nen nane nap̃ani m̃apo, ana kuruta nene lau kare ga ne, ana kana pias m̃ena imi viowa nena ga. ");
INSERT INTO lww_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ana kuruta viu, monar okokonia va e kulus nen nane nap̃a naga m̃ena pe urviu, naga m̃arera ruru po, a okilia oligan ruru mom̃a kuruta mon m̃a ea. ");
INSERT INTO lww_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","A pogos m̃ena nap̃a yar la amun kuruta nap̃a amiyum̃aen towe laa nanua rui, yoko ve sinelan re si munen kuruta viu, nap̃a amiyum̃aen mare ga na wa, ana yoko monar avisave kuruta marua naga kiki laa sane.” ");
INSERT INTO lww_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ana e sina ga e legiena tai, nap̃a pe Legiena Wa, Yesu amio kiena nalogena lala amiyaloro apano, a kiela mrapa pa p̃aro e lokove na kona lala. La amiyal m̃a sanene, ana nalogena lala viso kar la ana akawe plan kona lap̃as nap̃ani, apae vania, akania. ");
INSERT INTO lww_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","La akila ke sanene, ana Varasi lap̃as asum̃a e nap̃ani, apisu ke Yesu lala, ana apisa pania, apisape “Ei, komin ya ne asum̃a akila ke yum̃aena nene e Legiena Wa sanene? Visae sanene, asum̃a akilaro ke kieta navisaluaena ne.” ");
INSERT INTO lww_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ana Yesu pisatam̃e la, pisape “?Pona pe apuloli re Visena Wa pog tai poli yo wa, e sur la nap̃a P̃arin Sup̃e Tepet nanua naga kila? !Kam na akilia pa rui! Naga amio kiena yeririna lala la viso kar la manenea, ");
INSERT INTO lww_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ana naga pa loyum̃a e yum̃a wa m̃ana Ntewa, a naga mla kilaparavi wa nap̃a Navisaluaena sape yar wa ga la akilia akania, ana Tepet amio kiena yeririna la akania.” ");
INSERT INTO lww_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ana Yesu pisa pan la, pisape “Inu Narina ne Yeririna, inu ke narui nepe sup̃en Legiena Wa, ana inu ga nekilia nevisa ya nap̃a popon akila e Legiena Wa, pona ya nap̃a pe pon re akila poli.” ");
INSERT INTO lww_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A e si e Legiena Wa tai, Yesu pa si loyum̃a e yum̃a na leniena, pian la. Ana poglis nene yar m̃ena tai sike loyum̃a nap̃ani, limana marua pulu. ");
INSERT INTO lww_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ana navianen navisaluaena lala, amio Varasi lala, nap̃a la sinela kar Yesu rui, asike ga lavisinia e poglis nene, asum̃a apisuar ruruia p̃isa, vena asape alual li p̃elaga viowa lap̃asa e naga, ana la sinelan asape avisu sane yoko Yesu kila ruru limaulu nap̃ani e kiela Legiena Wa nene pona yoko ve kila re. ");
INSERT INTO lww_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ana Yesu kilia ruru make ya nap̃a sike e kiela sitomena, ana pis pa yar nap̃ani, sape “Osum̃alu, ovam osu metava e nini sumo wa,” ana naga sum̃alu pavini. ");
INSERT INTO lww_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ana Yesu piun tan la nap̃a asike e ne, pisape “?Kieta Navisaluaena sape tekilia tekila ya ne e Legiena Wa? ?Pisape popon tekila sur wo pona popon tekila sur viowa? ?Pona pisape popon tetamalia yaru, pona popon towem̃ar yaru?” ");
INSERT INTO lww_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ana Yesu pisuveve la make ga, ana pis sina pa yaru nap̃ani, pisape “Lumom̃a visilia!” A e ga e pogos nap̃a yar nene kila sanene, limana nap̃ani pimi po nenaga. ");
INSERT INTO lww_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ana le Varasi lala sinela mimi, nap̃a sane amloge mlae pap̃isi, ana apa vanua apisayu weleli sane yoko akila ve sanape na va Yesu. ");
INSERT INTO lww_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ana siraunia, e sina e pogos tai, Yesu pa metava e pupia tavie tai vena naga se ea, len va Ntewa, ana sum̃a kila ke sanene e yo nap̃ani pa tol yemlagi. ");
INSERT INTO lww_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ana kolulag na pitomi pio kiena nalogena lala apimi lele taaga puna, ana e la nene, naga pisawal la lualima taaga pa lua nap̃a naga mliganar la pisape la narui, la ape nalologena. ");
INSERT INTO lww_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ana kia kiena ne la lualima taaga pa lua nanini: Saemon, nap̃a Yesu mligan kiena kia tap̃ena, sape Pita, a wenla nap̃a Antru, a Semes, a wenla nap̃a Yoane, a Pilip, a P̃atalomiu, ");
INSERT INTO lww_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","a Matiu, a Tom̃as, a Semes, nap̃a narina ne Alpeas, a Saemon, nap̃a sape m̃ene plan le Rom lala, a Sutas, nap̃a narina ne Semes, ");
INSERT INTO lww_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","a Sutas nae Kariot, nap̃a siraunia naga kom varaun Yesu. ");
INSERT INTO lww_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ana Yesu p̃ere nalologena la nene apitom si tano, ana am̃al yotop tai, apa asike ea. A poglis nene, nalogena kiena ne Yesu tap̃ena lala apule ga asike ea, amio m̃ena pupia p̃ina lala na pulkumali tap̃ena lala nae Yutea, a le Yerusalem m̃ena lala, amio le Taea a le Saeton lala, nap̃a amolue e kiela yo lala garo losi lavisin sive apami. ");
INSERT INTO lww_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","La nene apamin asape aloge visena lala kiena ne Yesu, a la sinelan asape kila ruru kiela maiena lala. Ana Yesu kila m̃a sanene pan la pano-o, naga kila ruru m̃ena la nap̃a yermare lala asum̃a akila kare la ke silaga. ");
INSERT INTO lww_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yaru la moki manene pap̃isi, ana la punu ga sinelan asape atol ga Yesu, vena la aninuli ga pupia nam̃areraena nap̃a apisu sane sum̃a m̃alivi ke ea, nap̃a sum̃a kila ruru ke yar la moki rui. ");
INSERT INTO lww_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ana Yesu kira pisu kiena na-logena la nene, ana pian la, pisape: “Kam nap̃a apisu kilale sane limamiu koren ga, navisa ruruena sike e amiu, komin amiu ke narui nap̃a Ntewa naga pe p̃arin sup̃en amiu, ana visuar amiu. ");
INSERT INTO lww_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kam nap̃a viso kar amiu ke nagane, navisa ruruena sike e amiu, yoko aloge sane aim aulemaamaga nena ga e suri wo ne lala. Kam nap̃a atagi ke nagane, navisa ruruena sike e amiu, yoko akilia akekara. ");
INSERT INTO lww_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kam nap̃a yar la pe akekaran amiu re poli, a nap̃a asum̃a yepel mavin amiu, a nap̃a asum̃a apisa kare amiu, a asum̃a akoven plan ke kiamiu kia lala sane kam na ape yar viowa ga lala, nanene komin nap̃a kam na ape yar kiena ne inu Narina ne Yeririna, navisa ruruena sike e amiu. ");
INSERT INTO lww_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","E pogos la ne sanene, ve asitom manene re, aulaula ga warar pupia kekarena, komin nap̃a asum̃a akila kare amiu ke ga e p̃elaga m̃a nena nap̃a repila lala akila pa navisawalena la nanua sumo. Ana pogaga, yoko awar kiamiu pupia nalaena ma e peni. ");
INSERT INTO lww_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ana kam la nap̃a ape nasur moki manenea, yoko viowa manene laa van amiu, komin nap̃a ap̃ar kiamiu nalogewoena a kiamiu nakekarena lala e kiamiu malena wo la na yomarava nini rui. ");
INSERT INTO lww_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","A kam la nap̃a m̃ep̃emiu pulemamaga ruru pa sike rui, yoko viowa van amiu vap̃isi, komin nap̃a yoko viso kar amiu manene va laa sane. A kam nap̃a apitale ke nanagane rui, yoko viowa van amiu vap̃isi, komin p̃isi na aloge viowa, atagi. ");
INSERT INTO lww_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“A monar avisuar ruru amiu pogos nap̃a yar la asum̃a amieluar ke kiamiu kia. Visae ve sanene, pe pon re amiu m̃ena asitom ke asape amiu na apo, komin nap̃a navisawalena navisokanena la nanua sumo, kieta yermarua la amiyeluar kiela kia la sanene, ana Ntewa pisu la sane la apiowa ga ana mla nakoaena pan la.” ");
INSERT INTO lww_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ana Yesu pisape “Kam la nap̃a amloge kilale ke kiau visena nene, in na nevisa van amiu, nevisave: Monar sineta si kieta nasinekar lala, a monar tekila wo van la nap̃a pe asitom ita re poli, ");
INSERT INTO lww_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","a monar tevisa ruru la nap̃a apiuelin ita, a monar telenwo la nap̃a akila kare ita. ");
INSERT INTO lww_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Visae yar tai lipa pipim̃a lepas tai, ko monar ovilopu m̃ena pipim̃a lepas p̃asia vania vena lipa, a visae yar tai m̃areran van ko vena war mom̃a kulsaket, yoko monar okekaran ga war m̃ena mom̃a kulsota. ");
INSERT INTO lww_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Visae yar tai viun kiom̃a sur tai, monar ola vania, a visae yar tai lalua kiom̃a suri tai, yoko ve ova oviun re si tania vena lamaran si van ko. ");
INSERT INTO lww_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","P̃elaga ya nap̃a sinom̃an vena yar la akila van ko, p̃elaga ne nanene yoko monar okila van la. ");
INSERT INTO lww_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Visae tesum̃a sineta si ga yaru la nap̃a asitom ita, nanene na pe sur re tai nene po laa wa, komin yar nakilaen mlamulena viowa lala asitom ke la nap̃a asitom la rui. ");
INSERT INTO lww_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pona visae tekila ga wo van la nap̃a akila ke po pan ita rui, naga m̃ena pe sur re tai nene poli, komin yar nakilaen mlamulena lala, la m̃ena akila ke sanene rui. ");
INSERT INTO lww_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pona visae tetam̃an ga kilavaru va la nap̃a akilia alamaran sina, naga m̃ena ga pe pe sur re tai nene po laa wa, komin yaru nakilaen mlamulena la akila ke yum̃aena nene silaga. ");
INSERT INTO lww_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Ana in na nevisa van amiu, nevisave: Sinem̃a si kiom̃a nasinekar, a okila wo vania, a otam̃an ga kiom̃a kilavaru sa ga ne, nap̃a ve ositom manene re van nap̃a omla pania, ovisave pona kilia lamaran si pogos tai, pona tap̃atete si lamarana. Visae osum̃a okila ke sanene, osum̃a okus ke p̃elaga kiena ne Arimata Yaru na Meta ne, a naga yoko la nalaena tai van ko ve keviu laa sane, komin nap̃a naga yar sur nap̃a sinen po pan la nap̃a pe apisa re potena pan poli, pona la nap̃a asitom la ke sina. ");
INSERT INTO lww_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sanene, ko na monar sinem̃a ye yar lala sa nap̃a Arimata naga sinena miye la.” ");
INSERT INTO lww_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ana Yesu pis ke pan la na wa, pisape “Yoko ve alip̃ere manene re yar tap̃ena pona ala nakoaena vania. Visae sanene, yoko Ntewa tap̃atete lip̃ere manene amiu, tap̃atete la nakoaena van amiu. Visae aviewo yar tap̃ena, yoko Ntewa viewo amiu, ");
INSERT INTO lww_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","a visae ala sur va yaru tap̃ena, yoko Ntewa la sur imi van amiu. A yoko Ntewa laa van amiu ve keviu la sane taulu nap̃a amlavia, yoko naga war ve moki vap̃isi, sa nap̃a akokonia karo, atanaria, yoko amiyalar m̃ena ga, pano-o pulemamaga ruru nenaga, suri lap̃as kekapil pito ke tano. Lelaga pap̃isi, yokorena awar imi pun amiu maran ve taaga sa ke ga nap̃a ap̃arwar ke pan yar tap̃ena.” ");
INSERT INTO lww_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ana Yesu pis ke pan la na wa, pisa p̃akaiwa tai pan la, pisape “?Sanape, visae kilamara p̃ala tai sum̃a ga, ana naga kilia sumon kilamara p̃ala tap̃ena tai lalua ayalp̃el woga ga? !Peraga, yoko la ga luwoka aloru ato e p̃ilip̃ili tai ne! ");
INSERT INTO lww_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nalogena naga pe pa manene re metavan yar nap̃a pian ke naga poli, ana visae naga kilia ruru make sur la nap̃a navianena piania, yoko naga imi maran ve taaga sa ke ga kiena navianena. ");
INSERT INTO lww_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Pe pon re osum̃a ovisavisa ke narin kororaki tai nap̃a teke e kilamarana ne womla poli, ana pe opisu kilale re osape pupia purp̃es nen laki tai m̃eke e kilamaram̃a poli. ");
INSERT INTO lww_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","“?Sanape na osape ovisa va womla nene, ovisave ‘Wolai, yoko nowarlua kone kororaki na kilamaram̃a wa’? Sanene ko na pe opisu kilale re kiom̃a mlamulena viowa poli, a osum̃a omlip̃ere ke ga mlamulena viowa kien yar tap̃ena lala. Okilia m̃a nap̃a ko opiowa ga, ana osape okila sane yar la asape ko opo rui. Okus lua pupia miasin laki na m̃eke e kilamaram̃a sumo wa, p̃isi na okilia ovisuveve narin kinakinas nen kororaki nap̃a teke e kilamaran yar tap̃ena nene.” ");
INSERT INTO lww_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ana Yesu pisa m̃ena ga, pisape “Purlaki nap̃a po tap̃atete war mras nap̃a piowa, a purlaki nap̃a piowa tap̃atete war mras nap̃a po. ");
INSERT INTO lww_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ee, sanene narui, nap̃a tevisu kilale purlaki, tesape sanape e ga e mrasnela. Mralaki la nap̃a mam ruru po, pe top̃ar re e vilum̃ini la nap̃a pe nenos poli, peraga. ");
INSERT INTO lww_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yaru nap̃a po naga miyuwon ruru suri wo la sike e losinena, ana silaga kiena sitomena wo sum̃a ga nap̃a kilia visaplania, ana yaru viowa naga sum̃a p̃arpolo ke suri viowa e losinena, ana naga visa plan ga sitomena viowa lala. Suri ya nap̃a pule sike e los nen yaru pona e kiena sitomena, sur ne na nene narui yoko sum̃a molmolue luen ga e gona.” ");
INSERT INTO lww_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ana Yesu pisape “?Komin ya ne apio in ke asape ‘Sup̃e o, Sup̃e o,’ ana siraunia pe asum̃a amlogear re ya nap̃a nepisa pan amiu nesape akila poli? ");
INSERT INTO lww_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yar nap̃a pimi pun inu, mloge kiau visena, naga monar logearia a monar kila. Yar nap̃a kila sanene naga sa nap̃a suniena tai pisayuia, nap̃a pisa sanini: ");
INSERT INTO lww_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yar tai sum̃a kila ke m̃ana yum̃a, a yaru nene pe manmarua ruru po, kil p̃ilip̃ili la pito manene tano vena tol yo m̃arera tano, ana maplar kemrap̃e lala e pulus la nap̃ani. Ana pogos na pog m̃arera, pupia womie lau, ana tap̃atete nena kila yum̃a nene kulul, komin nap̃a yar na kila, kila ruru m̃arera po. ");
INSERT INTO lww_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ana yar nap̃a mloge kiau visen lala, ana pe mlogear re poli, naga sane yar tap̃ena tai. Yar nena, naga m̃ena miyum̃aen m̃ana yum̃a tai, ana naga pe wowe ga, miyum̃aen m̃ana yum̃a sum̃al yau ga e porotano, kana kemrap̃e ne la pe pito manene re nena tano poli. Ana pogos nap̃a pog m̃arera, pupia womie mlau pitomi, kil lua yum̃a nap̃a, kilalua mloru, ana yum̃a nap̃a pororovia, piowa make nenaga.” ");
INSERT INTO lww_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ana pogos nap̃a Yesu pisa plan kiena navianena la nap̃ani p̃isi, naga pa loyum̃a e pulkumali nae Kapeneam. ");
INSERT INTO lww_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ana e yo nene, nasumonen li na mara nae Rom tai sike ea, ana naga kiena yar wo na yum̃aena tai naga mai pap̃isi, lavis ga kovio. ");
INSERT INTO lww_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ana pogos nap̃a mloge yar la apisayu ke Yesu, asape pimi ke lavisin kiela yo rui, ana pio nasumonena kiena ne le Yu lala, pitetalia la apanon Yesu, vena aviun tania imi kila ruru namaiena nene. ");
INSERT INTO lww_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ana la nap̃ani apim puna Yesu, apisayu namaiena nap̃a pania, ana apiun manene tan sanini, asape “Nasumonen li na mara la nene, popon sa oimi oiila naga. ");
INSERT INTO lww_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Lelaga nap̃a sane naga pe ita re tai nene poli, naga pe yere Rom ga, ana naga pe yar tai nap̃a sitom manene kieta p̃egas nen yeririna la pap̃isi, ana naga m̃ena miila imimi e yo nini keviu pap̃isi rui, nap̃a miyum̃aen kiamimi yum̃a na leniena. Ana visae ko okekarania, oim ovisu kiena yaru nene nap̃a mai pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ana Yesu tam̃ania, ana pa amio la. La amial apano, ana pogos nap̃a asike towe laa perinan yum̃a m̃ana nasumonen li na mara nena wa, apisu yaru lap̃asa amiyal ke apimi. La nene, erau kiena ne nasumonena si lap̃asa, nap̃a naga pitetalia la si apim puna Yesu, vena avisa kiena visena tai vania. Ana la apim apisawal pa Yesu, apisape “Yere Rom nap̃ani mligan imimi mepim si pum̃a, pisa sanini, pisape naga sum̃a kila kare ko pap̃isi. Naga pisape naga pisu sa nap̃a naga pe yaru tai nap̃a pe torokin re oim m̃ana loyum̃a poli. ");
INSERT INTO lww_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","A sitomena nene kila naga pisu sane pe pon re m̃ena naga imi kate pum̃a poli, komin naga pe pe yere Yu re sane ko poli, ana naga pisa ga pisape, visae ovisa ga visena tai, yoko kiena yaru nene loge wo woga ne. ");
INSERT INTO lww_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Naga kilia sape monar ve sanene komin naga kilia sape kiom̃a visena naga nam̃areraena sike ea. Naga sape suri nene naga sane li na mara la nap̃a asike vatanonia, nap̃a la monar alogear kiena visena. Visae visa van tai, visave ‘Ovano,’ naga monar vano, pona visae visave ‘Oimi,’ naga monar imi, pona visae visave ‘Okila sanene,’ yoko naga monar kila. A naga m̃ena sape monar kila ya nap̃a pupia yerkawa nasumonen li na mara la pisa pania. Naga sape naga sitom sanene narui, visae ovisa ga sur tai, ana monar ve sanene.” ");
INSERT INTO lww_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pogos nap̃a Yesu mloge visena nene, naga milan sitomen kiena ne nasumonen li na mara la nene pap̃isi, a kekaran pap̃isi, ana pis pa p̃ina la nap̃a asike amio e poglis nene, sape “Nevisa van amiu, nevisave pe nom̃al re nena yere Yu tai nap̃a sum̃al m̃arera se e in sane yar nene poli.” ");
INSERT INTO lww_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ana siraunia, la nene ap̃asup̃ela si apa m̃ana nasumonen li na mara la nap̃ani, ana la amilan nap̃a apisu namaiena nene pimi po si rui. ");
INSERT INTO lww_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ana siraunia, pe yam piavi re poli, Yesu mial pa tol pulkumali tap̃ena tai, kiena kia Naeni, a sa nap̃a silaga, kiena nalogena lala amio yaru tap̃ena la moki asum̃a ataveve ke naga. ");
INSERT INTO lww_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ana pogos nap̃a Yesu lala apim ke lavisin pupia mralaea na pulkumali nene, apisu sane yar la amiyalvai apim, asum̃a akus ke yar mare tai pano vena ava asinia. Naga nap̃a mare ne, naga m̃ee tai nap̃a anena pe letano. Letano nene, naga pe p̃ar re si narina tai poli, naga p̃ar nena taaga ne nane mare narui. ");
INSERT INTO lww_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ana Yesu la asum̃a apisu ke la nap̃a amial apim, ana pogos nap̃a kieta Sup̃e pisu letano nene, naga sinen mie pano-o p̃isa. Ana pa lavisinia, pisa pania, sape “E, tagen toko.” ");
INSERT INTO lww_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ana Yesu pimi lavisin marena nene, mligan limana tea, a la nap̃a akus pa ke ne asum̃alar la asu, pe amiyal re si poli. Ana naga pis pa yar mare nap̃ani, pisape “E, nevisa van ko, osum̃alu si na wa.” ");
INSERT INTO lww_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ana m̃ee nene sum̃alu, sum̃a pivis pan la, apikevike van sina, ana Yesu sumon naga pano, mligan si pa anena. ");
INSERT INTO lww_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ana pogos nap̃a yar la apisu sur nene, sinela kurkur pap̃isi, a asum̃a amieluar Ntewa, asape “!Ake, suwala! Pupia navisawalena kiena ne Ntewa sum̃alu nena sike likan ita rui.” A lap̃as apisa m̃ena, asape “!Lelaga p̃a! Ntewa pimi katen kiena yeririna la rui.” ");
INSERT INTO lww_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","A suniena na suri nene, asum̃a apisalelein pano, pano-o tol lepas nap̃a Yutea, amio yo tap̃ena la nap̃a asike lavisinia. ");
INSERT INTO lww_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ana e pogos nene, Yoane Nakeena sike e yum̃a nakoaena rui, ana kiena nalogena la apim apisayu pania e sur la punu ga nap̃a Yesu sum̃a kila. ");
INSERT INTO lww_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ana Yoane pis ga pan lala lua, pitetalia la apa puna kieta Sup̃e, vena ava aviun ruru tania, avisave naga Navisaarena nap̃a asum̃ate ke ne, pona pe naga re poli. ");
INSERT INTO lww_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ana la amial apim apisu Yesu, apiun sanini pania, asape “?Kiamimi yerkawa nap̃a Yoane sinenan sape kilia sanape? ?Ko na yar sur nap̃a apisa nanua sumo asape yoko yerkawa tai imi ve kieta nasumon itaena, pona pe ko re na nene poli wa, a monar mesum̃ate ke yar nene yoko imi na wa?” ");
INSERT INTO lww_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ana e nena e pogos nap̃a apim apiun naviunena nene, Yesu sum̃a kila ruru ke maiena lala a sum̃a pile plan ke yermare petan yeririna lala, a sum̃a kila ke kilamara p̃ala lala, kilamarala la pimi po sina, ana nalogena kiena ne Yoane la apisu sur la nene. ");
INSERT INTO lww_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ana Yesu pisatam̃e la, pisape “Awasup̃e amiu si ava puna Yoane, ana avisawal sur ya nap̃a apisuia pona amloge e nini. Suri la nene asa ga nap̃a navisawalena Aisea pisa pan amiu rui, nap̃a sape: ‘Kilamarap̃ala lala, nanagane apisu si suri rui, a laulu lala nanagane amial ruru si rui, a yaru la nap̃a ap̃ar leperosi, nanagane tasnela la mekik ruru si rui, a kiligapop̃e lala, nanagane amloge si suri narui, a yar mare lala, nanagane amal si rui, a la nap̃a limala korena, nepisawal Lologena Wo pan la rui.’ ");
INSERT INTO lww_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ana ava avisawal m̃ena va Yoane, avisave ‘Yaru nap̃a pe sinen peve lua re e inu pog tai poli, navisa ruruena sike e naga.’” ");
INSERT INTO lww_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ana pogos nap̃a nalogena kiena Yoane la amolue sina vena awasup̃e avano, Yesu pisayu Yoane nene pa yeririna la nap̃a asike ne, sape “?Pogos nap̃a apa p̃esan e yokorena nene, apanon asape avisu ya ne? !In na pe nesitom re nesape apanon ga avisu kana kiai ne la poli, nap̃a sisilin kare ke ga sanene. ");
INSERT INTO lww_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","A in na pe nesitom re m̃ena nesape apa apisu yerkawa tai nap̃a miyen m̃ana kulsota nowo la poli, po sike e malena naapo, komin yaru sur la ne sanene, la pe asusu re e yo viowa la ne sane yomema nene poli, ana la asike ga e yum̃a naapo m̃ana p̃arin sup̃e keviu lala. ");
INSERT INTO lww_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Peraga, ana in na nesitom nesape apanon apisu navisawalena tai, ne? Nanene naapo ne, ana nevisa van amiu, Yoane nap̃a apanon apisuia, naga pa laa sane, naga taulu navisawalena nasumo lala, ");
INSERT INTO lww_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","komin nap̃a Ntewa pisayu naga e kiena visena wa rui, sape ‘In na nemligan p̃esan kiau yaru na waren visena nene pitomi pun ko, vena kila ruru kiom̃a mrapa.’ ");
INSERT INTO lww_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Lelaga nevisa van amiu, sane e yomarava nini Yoane Nakeena nene naga mon metavan make yar la punu ga. Ana la punu nap̃a yoko aim e nasup̃enena kiena ne Ntewa, vito tol kiela yar maro nap̃a sike laa tano, la punu nene la asike metavan Yoane, nap̃a yoko la awar navisa ruruena kiena ne Ntewa va laa sane taulu naga.” ");
INSERT INTO lww_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ana pogos nap̃a apa amiyagogon Yoane Nakeena mlologo, naga pisawal mrapa kiena ne Ntewa vena la akilia avilopu la. Ana yar viowa la moki, pa tol m̃ena yaru na takis lala, apisu sane mrapa nene pe lelaga, ana apilon la, ana Yoane kee la e wii. ");
INSERT INTO lww_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ana yar tap̃ena lala, sa nap̃a Varasi lala amio navianen navisaluaena lala, la apilopu m̃asila e mrapa nap̃a Ntewa kila vena akilia avilon la ea, ana Yoane pe kee la re poli. ");
INSERT INTO lww_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ana Yesu pis m̃arera pa yar na vilaveena lala e poglis nene, pisape “?Yoko nevisa visena ya nap̃a kilia tol p̃elaga ken la na nagane, sane la ape yar ya? ");
INSERT INTO lww_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","34","E lepas punu ga nap̃a Ntewa kila vena kilali wo van amiu, ana yepemiu mavin ga, apisa kare ga naga vanonia. Komin poglis nap̃a Yoane pimi, naga sum̃a monsilun kinanena vena len, a naga mlon kuruta namunena, ana yaru la apisu sanene, asum̃a apisayuia, asape ‘Yaru nene, yermare sike e naga.’ “Ana pogos nap̃a inu Narina ne Yeririna nepim nesike na, nekinan ruru ga a nomun ruru ga, ana apisayu si inu p̃isa, apisape ‘Apisu ke ne, yaru nene naga kinan merorol pap̃isi wa, naga pe yar na mun maneneen m̃ena kuruta, a naga kiena erau lala, yar na warpoloen ga takis, a yar viowa ga lala.’ “Komin sur ne nanene nepisu yeririna na nagane lala asa ga ninis la nap̃a visae asum̃a akila kokan ke e yepesinas na kumali, yoko la aviovio kiela narin erau lala, avisave ‘!Ei, kam na apilon manene visena na! Visae mowe ke plap̃e, ana pe sinemiun re wolen amio imimi poli, pona visae meyaun ke yauena na marena, ana pe sinemiun re atagipae amio imimi poli.’ ");
INSERT INTO lww_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Sur ne na nene, yeririna la yepela mavin mrapa lala kiena ne Ntewa, ana mras wo nap̃a molue e malena kiena yaru nap̃a taveve ke mrapa kiena ne Ntewa, kilologia sane mrapa ne nanene narui, naga pe mrapa na manmaruaena nap̃a lelaga.” ");
INSERT INTO lww_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ana Varasi tai, kiena kia Saemon, naga sape sinenan kila kinanena tai ve kana Yesu, ana Yesu pa m̃ana, pa totano vena akinana. ");
INSERT INTO lww_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ana e pulkumali nena, sira tai sike ea, nap̃a naga kila p̃elaga viowa la moki pap̃isi, ana naga mloge nap̃a Yesu pa kinan ke m̃ana Varasi nap̃a Saemon ne. Ana sira nap̃a pisu kiena mlamulena viowa, mloge piowa manene laa, ana mloge sane monar imi visu Yesu, ana kus kiena piawi tanea tai na ponotaninu, kus pimi e yum̃a nap̃ani. ");
INSERT INTO lww_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ana Yesu pelein ke sape kinana, ana sira nene pimi sum̃al su varaun lana, nap̃a wamarana mlau, kekapil pito ke e lana ne Yesu. Wamarana kee ke lana sanene, ana tar viluna la nap̃a piayavi ne, sum̃a miyumuvan ke lana Yesu, a naga pelan pipina komp̃asa te lana ne Yesu, a yokorena taron ponotaninu nap̃ani ea. ");
INSERT INTO lww_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ana Varasi nap̃a p̃ere Yesu pimi m̃ana, naga pisu ke sur nene, ana sitom piowa towe ga ea. Naga sitom ke sanini, sape “Visae Yesu nene naga pe navisawalena tai nap̃a lelaga, pona vera na kilia ruru yo rui sane sira nene naga pe sira na mlamulena viowa na sanene, ana yoko ve tam̃an re tol lana wa nene. Ana naga tam̃an kila sanene, in na nemninue kare narui.” ");
INSERT INTO lww_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ana Yesu na kilia m̃a kiena sitomena nene, ana pisatam̃ea, sape “Saemon, in na nesape nevisa visena tai van ko sumo wa.” Ana tam̃ania sape “Pogaga, Navianena. Okilia ovisa.” ");
INSERT INTO lww_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ana Yesu pisatam̃e sanini pania, sape “Yerkawa tai, ana yar lua akila lapui pania. Lalua nene, tai na kiena lapui keviu, komp̃asa naga kiena lapui keviu manene laa pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ana pogos na ulmaranen lapui la nene, la ga luwoka apulmaran p̃ele ga, ana yerkawa nap̃ani sinen mie la, ana piewo make kiela lapui la nene pan la. ?Ana komin sur ne nanene, lalua nene ane sitom manene yerkawa nene?” ");
INSERT INTO lww_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ana Saemon pisatam̃e Yesu, pisape “Nemninue ga, pona nap̃a kiena lapui keviu manenea naga monar sitom va laa sane yo.” ");
INSERT INTO lww_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ana Yesu pisape “Ee, sa ke nene narui.” Ana Yesu p̃arpuia kilologia sira nap̃ani pa Saemon, sape “Saemon, pogos nap̃a nepim mom̃a, pe nom̃al re yar tai p̃ar wii pimi pan inu poli vena nekevan kororak na mraplepa e lau, sane e kieta p̃elaga na, monar okila. Ana opisu ke sira nini, naga ke nap̃a kevan lau e wamarana narui, a miyumuvan si mema e viluna. ");
INSERT INTO lww_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","In na nepim mom̃a loyum̃a, ko na pe otalopan ruru in re poli, sane nepe kiom̃a erau wo tai, ana siar e pogos nap̃a nepim loyum̃a, naga mligan pipina lepas p̃asia te lau silaga. ");
INSERT INTO lww_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ko na pe op̃ar re ponotaninu pimi otaron pito e p̃aruu po, ana naga kila e lau rui. ");
INSERT INTO lww_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ana nevisa ruru van ko, nevisave sira nene, kiena mlamulena viowa moki pap̃isi, ana nepiewo make ga rui, kila narui naga sinena sii inu keviu pap̃isi. Ana nepisu yaru nap̃a kiena mlamulena viowa pe keviu re poli, nepiewoia, ana naga pe sinen sii manene inu re poli.” ");
INSERT INTO lww_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ana Yesu pisa ruru m̃ena pa sira nap̃ani, pisa pania, sape “Kiom̃a mlamulena viowa la nap̃a ositom p̃ele ke ne, nepiewo make rui.” ");
INSERT INTO lww_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ana pogos nap̃a Yesu sum̃a pisa ke visena nene, yaru tap̃ena la nap̃a akinan ke amio la e pogos nene pe akekara re nena poli, asum̃a apragogo pan la, apisa ke asape “?Ana yaru nene sinenan sape naga ve ai, nap̃a naga pisa ke sape naga p̃ar plan ke mlamulena viowa kien yar la sanene?” ");
INSERT INTO lww_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ana Yesu pisa si pa sira nene yam tai, pisape “Kiom̃a naviawaena kila otol natamaliaena rui. Ve ologe re si viowa, okilia ova narui, a sum̃are kiena ne Ntewa sike amio ko.” ");
INSERT INTO lww_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ana pe yam piavi re poli, Yesu mial sina pano, pa kome pulkumali lala, la nap̃a ve torokak amio la nap̃a kerkeviu, a e yo punu ga naga sum̃a mlologo, a sum̃a mla lologena wo nasup̃enena kiena ne Ntewa pimi pa yeririna lala. Ana sane silaga, kiena nalualima taaga pa lua la m̃ena asike amio e pogos nene, ");
INSERT INTO lww_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","a sira la moki li m̃a nap̃a la asum̃a atavevela. E sira la nene, lap̃asia nap̃a Yesu tap̃a ruru la petan ninuna viowa lala a e inanena viowa la nap̃a se e la, sa nap̃a Maria nae Maktala, nap̃a sumo yermare la olua ase e naga, ");
INSERT INTO lww_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","amio Soana, nap̃a naga wona ne yar nap̃a Kusa, nap̃a naga pe yerkawa na kilaen yum̃aena kiena ne P̃arin Sup̃e Erot, a amio m̃ena Susana nene. A la moki manene ke sina ga, nap̃a la asum̃a amiila Yesu lala keviu pap̃isi, a la asum̃a apisuar la e nalaena la nap̃a asum̃a ap̃ar ke pan la. ");
INSERT INTO lww_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ana e pogos tai, pupia p̃ina na yeririna lala la moki amolue e kiela pulkumali la peve taaga, ana la apimi amiervivi Yesu piora, ana naga pis pan la, kuan p̃akaiwa tai pan la. ");
INSERT INTO lww_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Naga pisa sanini, sape “Yar tai sape va veven kurusia e kana lokove. Pogos nap̃a peven kurusia, sum̃a sisilinia, ana kurus lap̃asia amloloru e mraplepa, a siraunia, yar la apim amiyaloro ea, apie kare ga, a manu m̃ena lala apimi ate plan make ga. ");
INSERT INTO lww_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","A kurus lap̃asia amloloru e yo nap̃a kilavaru sike ea, pitotovi pavini, ana yoko miaiai ga, komin nap̃a pe wii re e yo nene poli. ");
INSERT INTO lww_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","A kurus lap̃asia mloloru e yo nap̃a sumo na pe ate plan ruru re kilika viowa e poli, ana yoko siraunia kilika viowa nene kapur ke sina ga pimi keviu, kewo make kurus la nap̃a pitotovi ne-e amarmare. ");
INSERT INTO lww_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A kurus tap̃ena ne lap̃asia amloloru e porotano naapo tai, ana la apitotovi akapur m̃a pano-o, la ap̃ar mrasnela la moki, tol ponotia taaga.” Ana pogos nap̃a Yesu pisa visena la nene p̃isi, naga pion manene pan la, sape “Yar nap̃a kiligana teke ea, monar yagogon ruru visena nene.” ");
INSERT INTO lww_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ana siraunia, nalogena lala apim puna Yesu apiun kinas nen p̃akaiwa nene tania. ");
INSERT INTO lww_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ana naga pisatam̃e la, pisape “Ntewa kila sanene sape vena akilia alual nakilia wanena na kiena nasup̃enena. ‘Ana e yar tap̃ena lala, nakilia wanena la nene la atapolou asike e p̃akaiwa na wa, ana la asum̃a apisu pano-o, pe apisu kilale re poli, a la asum̃a amiyagogo pano-o, pe amloge kilale re nena poli.’” ");
INSERT INTO lww_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ana Yesu pisavan ruru ga p̃akaiwa nene pan la na wa. Naga pisapenua “Pogaga, kinas nen p̃akaiwa nene naga sanini. Sur nasumo, naga kurusa, a naga na sane visena kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A kurus la nap̃a akekapil mraplepa, naga na sa nap̃a yar la ne amloge visena nene, ana kurus nowo lala mloloru pitomi e kiela sitomena lala. Ana P̃arin Yermare nene pimi p̃ar plan ke sina ga visena la nene petan sinela lala, vena kila sane ve alelaga re sina, ve atol re si natamaliaena. ");
INSERT INTO lww_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Tap̃ena, naga kurus la nap̃a asike e yo nap̃a pe kilavaru, a na nene sane yar la nap̃a amloge lologena wo nene, amlavia, akekarania, ana sa nap̃a p̃eligas nela pe po re poli. La asum̃a amlelaga yam plas ga, a visae atol pog m̃arera, pona nakilaliena imi, yokorena la aloloru ke sina ga. ");
INSERT INTO lww_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Tap̃ena m̃ena ga, naga na kurus la nap̃a asike e lelen kilika viowa lala, a na nene sa nap̃a yar la amloge, ana pogos nap̃a la amial ke apa sane, ana asitom manene laa kiela malena lala, a sinelan manene m̃ena kilavaru, a akekaran manene m̃ena kekarena na yomarava la nini pap̃isi. P̃elaga la nene apimi sane kilika viowa tai nap̃a piwo la, ana tap̃atete nena kiela malena war mras nap̃a marua ruruia. ");
INSERT INTO lww_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Ana na maro, naga kurus la nap̃a sike e porotano naapo, nanene naga sa nap̃a yar la amiyagogo ruru e Lologena Wo nene, ana amligan ruru sike e losinela lala, atarar ruru m̃arera, nap̃a ape lelaga kemua. Yeririna wo la ne sanene, la akila kiela sitomena la viayavi, ayum̃ae ruru m̃a vano-o awar mras nen Lologena Wo nene e kiela malena lala.” ");
INSERT INTO lww_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","A Yesu pisa m̃ena ga, pisapenua “Ita yeririna lala, visae towar kap vivaga imi, yokorena ve yar tai warwan re m̃eke vatanon karo tai pona sur tai sanene. Peraga, tetelan ga m̃eke metava vena kila yar la nap̃a aim loyum̃a la avisu nap̃a yo merarava ruru nena ga. ");
INSERT INTO lww_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pogaga, ana nasup̃enena kiena ne Ntewa naga sane kap vivaga nene, nap̃a nanagane sum̃a m̃alm̃alivin ita vena tegoli make suri punu ga. Suri punu ga nap̃a tapolou sike ga wa, a nakilia wanena punu ga, yokorena la monar amolue e yepesinasa vena yar la akilia avisu kilalea. ");
INSERT INTO lww_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kam na monar ayagogon ruru kiau visena lala, a akilali nap̃a asitom ruru la. Yar nap̃a kiena suri moki rui, yokorena naga war va ve mok manene vap̃isi. Ana yar nap̃a limana plasan suri lala, yokorena naga kilalu kiena narin sur nene nap̃a naga sitom ke sape pe kiena pa rui.” ");
INSERT INTO lww_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ana anenane Yesu amio wenla lala apim aporun naga e pogos nene, ana la akila p̃ele yon nap̃a ava atol naga loyum̃a, komin nap̃a p̃ina la moki, kila yo ve tokak ga. ");
INSERT INTO lww_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ana yar la amla lelein ga visena pimi tol Yesu, asape “!Ei, anom̃a amio womla lala asum̃alu asike vanua, sinelan asape avisu ko sumo wa!” ");
INSERT INTO lww_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ana Yesu pisatam̃ea, sape “Naga nap̃a pe aneu, pona pe wolai, nanene na la ga nap̃a amloge visena wa kiena ne Ntewa, a la asum̃a akila ke sa nap̃a visena nene pisa.” ");
INSERT INTO lww_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ana e legiena tai, Yesu p̃ere nalogena lala, la apa amiyai e waa tai, ana Yesu pisa pan la, sape “Ita, yoko teva e lepas nen lapa nene lepas p̃asia.” Ana la amligan yo, asum̃a apano, ");
INSERT INTO lww_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ana pogos nap̃a waa kiriri ke pa narui, Yesu maran kawa pano-o momalio. Ana siraunia, pupia lagi tai miyui, miyu lapa nap̃ani, ana pupia sive lala akilapela pano-o sive pule e pulu waa, apisu sane piowa ga narui. ");
INSERT INTO lww_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ana apito apiop̃ege Yesu, apisa pania, asape “!Sup̃e, Sup̃e, lavis ke tetalilu narui!” Ana Yesu sum̃alu, pisalup̃ar lagi amio sive m̃arera la nene, ana sur la nene apito tano, yo m̃ano ruru nenaga. ");
INSERT INTO lww_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ana Yesu pisa pan la, sape “?Awa kiamiu naviawaena?” Ana amarau pano-o, amilan manene pap̃isi, ana asum̃a apiuviun ke sina tan la, asape “?Aulai, yaru ya nene? Naga pis ga sanene ana lagi amio sive, lalua amlogearia. !Suwala!” ");
INSERT INTO lww_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ana Yesu la apa atol lepas p̃asa, e nap̃a Kalele kira ke pa ea, nanene mesmesun e yo nap̃a Karasa. ");
INSERT INTO lww_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ana pogos nap̃a Yesu pa ura e yo nene, yar nae e yo nene tai pitomi pitawea, nap̃a yar nene yermare la asike ea. Nakonua rui, yar nene pesinas ga, pe miyen re sur tai poli, a naga pe mon re e yum̃a poli, naga kekaran ga nap̃a monmon ga e lotap lala, e puluve la nap̃a amligan ke kiela tas nen yar mare la am̃em̃eke ea. ");
INSERT INTO lww_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ana yermare la nene akila kare yar nene yam moki rui, kila sane yar la akirakiravanli naga silaga, a apiar e kilipan, a apiar lana amio limana e kilika panon laki, ana naga sum̃a kilaroro ga, a yermare la nene am̃enelua naga pa m̃eke e yokorena nene. Ana Yesu pisuia, pis pa ninuna viowa, pilelua sape ligan yaru nene. Ana yar nene pisu Yesu, pio naga, a mloru e lana, ana ninuna nap̃a sike ea pis m̃arera, sape “?Ana Yesu, ko narina ne Ntewa na Mava, kiom̃a ya na teke e inu? !Nepiun m̃areran pan ko, nesape ve ola re nakoaena van inu!” ");
INSERT INTO lww_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ana Yesu piun tania, sape “?Ana kiom̃a kia ai?” Ana ninuna viowa nene pisatam̃ea, sape “Kiau kia ‘Yermare lala na kilaen mara.’” Naga pisa sanene komin nap̃a yermare la nap̃a apa e losinena la mok liu. ");
INSERT INTO lww_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","A ninuna viowa la nene asum̃a apiuviun m̃areran ke sina ga pa Yesu vena naga ve vile plan la re, naga ve kila la re ava aloru ato tano e pupia pulukapi. ");
INSERT INTO lww_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ana yepas nen kunus na yo nene, pupia p̃egas nen nompui lala asum̃a akolkol ke porotano, ana yermare la nene atagi pa Yesu, apiun m̃areran tania asape naga ligan la ga ava e nompui la nene. Ana Yesu tam̃an pan la, ");
INSERT INTO lww_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ana la amolue petan yar nene, apa e los nen nompui lala. Ana nompui la nene aplamolue yam veraga akiriri apito e yeparpas tai, ana apiovion la apito e pupia lapa nene, atalil make e sive. ");
INSERT INTO lww_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ana yar na visuaren nompui lala apisu sur nene, la ap̃ure apa um̃a, apisawal sur nene, ana apisa make m̃ena ga e yo la punu ga, ");
INSERT INTO lww_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","kila sane yar la moki sinelan asape aimi avisuia. A pogos nap̃a la apimi, apisu Yesu sum̃a ga, a yar nap̃a ninuna viowa la ap̃ure petan rui naga totano teke e lana ne Yesu. Nanagane, naga miyen ruru m̃ana kulmrae wo la rui, a pimi mom̃au ruru nenaga, pe sirag re si poli. Pogos nap̃a la apisu yaru nene pimi po si sanene narui, ana amarau. ");
INSERT INTO lww_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","A la nap̃a asup̃esania apisu suri punu ga, asunyu pa la nap̃a apim mare ga na wa, apisa meraravan pan la sanape nap̃a yaru nene nap̃a yermare la asup̃esan ea, ana Yesu kila naga pimi po si rui. ");
INSERT INTO lww_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ana yeririna lala na lepas nae Karasa, la apisu sane piowa ga, ana la asum̃a am̃areran pa Yesu asape la sinelan naga molue si vetan la, komin nap̃a sur nene kila amarau pap̃isi. Ana Yesu la apitovin si vena aiai e kiela waa, vena awasup̃ela sina. ");
INSERT INTO lww_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ana pogos nap̃a la asum̃a apito ke narui, yar nap̃ani pitomi piun m̃areran tan Yesu sape naga sinenan sape va su lue amio naga, ana Yesu pisalup̃aria, pisa pania, sape ");
INSERT INTO lww_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Peraga, komin nap̃a popon manene ko owasup̃e ko ga ova si um̃a, a ova osunyu van yar lala, ovisa van la sanape nap̃a Ntewa kila po nap̃a po manene pan ko sanene.” Ana yar nene p̃asup̃e sina, a naga sum̃a pa miyervivi yo punu ga nae lepas na kiena pupia pulkumali, a pisawal yum̃aena wo nap̃a Yesu kila pania. ");
INSERT INTO lww_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ana Yesu lala akusro lapa nene apa ke sina lepas p̃asia, a pupia p̃ina na yeririna lala asum̃ate ke naga, ana la akekaran nap̃a apisu pa m̃alivin la sina. ");
INSERT INTO lww_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ana yerkawa na kiela yum̃a na lotena nae e yo nene, kiena kia Saeras, naga pimi lavisin Yesu. Ana kinai tanonia, tag pania, piun tania sape imi m̃ana, ");
INSERT INTO lww_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","vena visu nin narina nap̃a sira, naga minana pap̃isi. Nin sira nene, nap̃a yerkawa nene naga narina taaga nena nene, a kiena kas pe sur sane lualima taaga pa lua ga 12, ana kiena inanena pimi keviu manene laa narui, kila narui apisu sane lavis ke mare ne. Ana Yesu sum̃alu, amio yar nene apano. Ana pogos nap̃a naga pa ke sanene narui, pulen yeririna na pupia p̃ina la nene asum̃a atavevea, asum̃a amiigin la piora e Yesu. ");
INSERT INTO lww_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ana lala tai, naga sira tai, nap̃a maiena kien sira lala teke e naga e legiena punu ga, tol kas lualima taaga pa lua 12 rui, ana pe yar re nena tai nap̃a kilia kila ruru kiena maiena nene poli. ");
INSERT INTO lww_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ana sira nene, naga mialvan ga yaru la lika, pimi pimi lavisin m̃asina ne Yesu, kian limana sane, tol ga m̃ana isinen kulkota. Tol ga kulkota m̃ana Yesu sane, ana e ke e pogos ga nene, kiena maiena nap̃ani p̃isi nena ga. ");
INSERT INTO lww_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ana Yesu piun ke ga, pisape “?Ane tolmare in ga na wa?” Ana la apisapenua “Pe yar tai tol ko re poli,” ana Pita m̃ena ga pisa pania, sape “?Ana Sup̃e, sanape? Yaru la apule manene laa asum̃a amiigin la kar ga miyervivi ko pivi, asum̃a apavan e ko.” ");
INSERT INTO lww_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ana Yesu pisa pania, sape “Peraga, yaru tai tol inu nena nap̃a, komin nap̃a in na nemninukilale sane kiau nam̃areraena komp̃as pa vanua e inu pa e yaru nene p̃isi rui.” ");
INSERT INTO lww_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ana sira nene pisu sane naga tap̃atete si tapolou narui, ana pimi puna ne Yesu, marau pap̃isi, sinen kurkur m̃ena ga. Naga pimi mloru e lana Yesu, ana e marana ne yeririna la nap̃a asike ne, naga pisawal make sur la e naga pania, sa nap̃a komin ya ne naga pimi tolia, a sanape nap̃a pimi po si rui e pogos nene. ");
INSERT INTO lww_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ana Yesu pisa pania, sape “Auya, kiom̃a naviawaena e inu kila ko opo si rui. Sum̃are kiena ne Ntewa sike amio ko, owasup̃e ko sina ova um̃a.” ");
INSERT INTO lww_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ana pogos nap̃a Yesu sum̃a pivis ke amio sira nene wa, visena pimi pa yerkawa nene, sape “Nin narum̃a nene kovio rui. Popon ve oure re si pupia navianena nene imi, vena ve okila kare korenan re naga.” ");
INSERT INTO lww_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ana Yesu m̃ena mloge m̃a visena nene, ana pisa pa Saeras, pisape “Ve ositom re suria, owasine ga Ntewa m̃arera, a yokorena nin narum̃a sira nene imi wo si ne.” ");
INSERT INTO lww_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ana Yesu pa amio yar nene apa m̃ana, a pogos nap̃a apim atol yo nene, naga pisalup̃ar lap̃asa sape yoko ve ava re loyum̃a amio naga, ana naga p̃ere ga Pita, amio Yoane, a Semes, a arimanane nin sira nene amio anena, ana apa loyum̃a. ");
INSERT INTO lww_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pogos nap̃a apa loyum̃a apisu nap̃a yar la asum̃a sinela miye ke nin sira nap̃a rui, asum̃a ataginia, ana Yesu pisa pan la, sape “Ve atagin re nin sira nene sanene. Naga pe mare re nene poli, naga momalio ke ga ne.” ");
INSERT INTO lww_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ana la apitalia kare ga naga, komin nap̃a la akilia asape nin sira nene marp̃antop nena rui. ");
INSERT INTO lww_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ana Yesu pa tarar limana ne nin sira nap̃ani, pisa pania, sape “Nin naruu, osum̃al li sumo wa.” ");
INSERT INTO lww_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ana e ke ga e pogos nene, apisu nap̃a nin sira nene, kiena malena p̃asup̃e sina pimi e naga, ana sum̃alu, sum̃a miyaloro, ana Yesu pisape popon ala narin kinanen tai vania. ");
INSERT INTO lww_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ana arimana amio anena, amilan pap̃isi nap̃a kiela sitomena la kovio nena ga, ana Yesu pisa pan la sape yoko ve avisawal re sur nene va yar tap̃ena lala. ");
INSERT INTO lww_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ana Yesu pio viraviran kiena lualima taaga pa lua 12, ana pis ruru pan la, naga mla m̃areraena pan la, tam̃an la vena akilia ataulu yermare lala, a vena akilia akila ruru maiena lala. ");
INSERT INTO lww_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Naga kila sanene vena vitetalia la avanon alologon navesup̃enena kiena ne Ntewa, a vena akila ruru namaiena lala. ");
INSERT INTO lww_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A visen wo lap̃as nap̃a pisa pan la sumon nap̃a apano, sanini, nap̃a sape “E lepas na kiamiu mrapa, yokorena ve awarar re sur tai. Ve awar re kiamiu plasgai, pona kiamiu karo, pona kinanena, pona kilavaru, a ve awar re m̃amiu kulsota ve lua, yokorena ayen ga m̃amiu kulsota ve taaga ga nap̃a amiyenar ke ne. ");
INSERT INTO lww_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“A um̃a ya nap̃a visae aure amiu ava ase ea, p̃isi na monar akekaran nap̃a asu amio mratava na um̃a nene, yokorena aligan ga um̃a nene pogos nap̃a amolue si vetan pulkumali nene. ");
INSERT INTO lww_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A e pulkumali ya nap̃a visae la yepel mavin were amiuena ava e m̃ala yum̃a lala, p̃isi na aligan ga kiela yo nene, a pogos nap̃a amolue vetania, monar atan plan puluyavi na mrapa na yo nene vetan lamiu, sane kile tai pona kiamiu visena m̃arera tai van la, sape yoko awar nakoaena tai nap̃a torokin ga kiela p̃elaga viowa nene.” ");
INSERT INTO lww_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ana nalogena lala amolue apa narui, a asum̃a ap̃aro ke e pulkumali lala, asum̃a amlologon ke lologena wo, a asum̃a akila ruru ke maiena lala. ");
INSERT INTO lww_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ana e pogos nene, P̃arin Sup̃e Erot m̃ena ga mloge towe m̃a ya nap̃a Yesu la asum̃a akila ke ne, ana naga sitom manene pap̃isi, komin nap̃a yar lap̃as asum̃a apisayu Yesu, asape naga Yoane Nakeena, naga mali si petan marena, ");
INSERT INTO lww_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ana tap̃ena lap̃as asape naga yermarua Elaisa nanua, nane m̃alivi si ne, a tap̃ena lap̃as asape naga pe navisawalena la tai nanua sumo sumo manene laa, nap̃a sum̃alu si petan marena. ");
INSERT INTO lww_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ana P̃arin Sup̃e Erot pisape “Pe Yoane Nakeena re nene poli, komin nesilua p̃arina rui, ana yar na apisayu ke ne, naga a si nene?” Ana sitomena nene kila naga sinenan visuen Yesu pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ana nalologena la nap̃a Yesu pitetalia la sape ava alologo, ap̃asup̃e sina, ana apisawal sur punu ga nap̃a amiyum̃aenia pa Yesu. Ana Yesu p̃ere la amolue petan yar lala, amiyepe la ve tokak ga apa e pulkumali tai, kiena kia Petsaeta. ");
INSERT INTO lww_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ana siraunia, yar la amloge asape apa ke e yo nene, ana la m̃ena ga asirau apano, apa m̃ena e yo nene. Ana Yesu kekara ga, naga sun towe amio la, a siraunia pian la e lepas navesup̃enena kiena ne Ntewa, a kila ruru yar la nap̃a sinelan ke asape popon yar tai iila la. ");
INSERT INTO lww_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ana Yesu sum̃a amio la pano pano-o, apisu nap̃a mrae pito ke tano narui, ana kiena lualima taaga pa lua nene apim puna, apisape “Ei, Sup̃e, popon oligan p̃ina la nene awasup̃ela ava m̃ala um̃a lala pona avakar ga e pulkumali la ne sike ne, vena akilia aul kala kinanena lap̃asia, a vena akilia alual m̃ala lele na monoena, komin e yo na tesike e ne pe pon re yemalo wo ita e poli.” ");
INSERT INTO lww_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ana Yesu pisa pan la, pisape “E, peraga. Popon kam ga awar kinanen lap̃as van la.” Ana la apisatam̃ea, apisape “!Kei! Imimi memla ke ga narin kilaparavi lima, amio narin ika lua. ?Ana visae peraga, pona ko sinom̃an ke osape yoko imimi ke narui meva moul kinanena torokin pupia p̃ina la nene?” ");
INSERT INTO lww_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","La apisa sanene komin yeririna la nap̃a asike ne la moki manene laa, ana yerm̃ene ga lala pa tol sur sane manu lima 5000. Ana Yesu pisa pan la, sape “Ava avisa va yeririna lala avisave atotano ke ne wa, atotano e p̃egas lala, nap̃a yar la lualima ve lima 50 e p̃egas tai.” ");
INSERT INTO lww_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ana apa akila sa nap̃a naga pisa, a yeririna lala atotano e p̃egas lala. ");
INSERT INTO lww_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ana Yesu mla kilaparavi lima nene amio narin ika lua nap̃ani, kirava pa ma e peni, pisa potenania ana kawewowa, kian pa nalologena lala vena alalein akian va p̃egas la nene. ");
INSERT INTO lww_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ana akan panpano-o m̃ep̃ela kawa ruru nena ga, a kororos nen kinanena nap̃a akanligania, akon pa e karo popos lala tol lualima taaga pa lua 12. ");
INSERT INTO lww_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ana pogos tai, Yesu sum̃a mlen ke naga taaga, a kiena nalogena lala asum̃a ga lavisinia, ana naga piun tan la, sape “?Asum̃a amloge yar la apisavisa inu asape in na ai?” ");
INSERT INTO lww_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ana apisa pania, asape “Lap̃as asape ko Yoane Nakeena, a lap̃as asape ko Navisawalena Elaisa, a lap̃as asape ko navisawalena tap̃ena lala tai nanua sumo sumo nane naga mali si petan marena ne.” ");
INSERT INTO lww_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ana naga piun tan la, pisape “?A sanapen amiu, kam asape in na ai?” Ana Pita pisatam̃ea, pisape “Ko Navisaarena kiena ne Ntewa nene.” ");
INSERT INTO lww_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ana Yesu pis m̃arera, pisaar nena pan la, pisape yokorena ve avisawal re sur nene va yar lala, ");
INSERT INTO lww_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ana pisa ruru pan la pisape yoko ve sanapen naga. Naga pisape “Inu na nepe Narina ne Yeririna, a yoko nasumonena kiena ne le Israel lala, amio yerkawa kiena ne yar wa lala, amio navianen navisaluaen lala, yoko akoven lua inu, p̃isi na monar akila sur ve moki na kila kare inuena. Yoko monar awem̃ar inu nemare, ana e kana legiena na telu, yoko Ntewa visirlua inu nemal sina.” ");
INSERT INTO lww_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ana e pogos nene, Yesu pis pan la, pisape “Yar nap̃a sinenan sape taveve inu, naga monar sitom korenan ga kiena nasinenanena lala, naga monar kus kiena laki torovia e legien punu ga, sa nap̃a yoko inu nekus kiau, ana taveve inu luen ga. ");
INSERT INTO lww_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nepisa sanene komin yar nap̃a sinenan sape ve puluvisin kiena malena, yoko kilalu kiena malena. Ana yar nap̃a tam̃an kiena malena vanon inu, yoko naga taulu si kiena malena. ");
INSERT INTO lww_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Visae yar tai tol make sur wo na yomarava nini lala, ana kila pal mrapa a kilalu kiena malena, naga pe taulu re nena sur wo tai poli. ");
INSERT INTO lww_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yar nap̃a mawa e marana yar tap̃ena lala vanon inu pona vanon kiau visena, yoko inu Narin Yeririna m̃ena nemawan yar nene e marana Ntewa e pogos nap̃a nowasup̃e sina, nap̃a yoko nevitom nemio pupia naurarena nap̃a pe kiau, a pe kiena ne Ata, a nap̃a pe kiena ne m̃ena navisi wa lala. ");
INSERT INTO lww_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lelaga nevisa van amiu, yar lap̃as asum̃al asike e nini, nap̃a tap̃atete amare na wa, vano-o tol pogos nap̃a avisu Navesup̃enena kiena ne Ntewa imi m̃alivi.” ");
INSERT INTO lww_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Siraun pogos nap̃a Yesu pisa visena la nene, pe sur sane legiena olua p̃aro ga na wa, ana naga p̃ere Pita, amio Yoane, a Semes, la vari apa metava e ravie tai, komin sape len. ");
INSERT INTO lww_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ana apam atol yo nene, a pogos nap̃a sum̃a mlen, nalogena la telu nene apisu nap̃a marana pimi pe tap̃ena, a apisu nap̃a m̃ana kulsota pilavila pap̃isi, a miyuwowo nap̃a miyuwowo manene laa. ");
INSERT INTO lww_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ana siraunia, yermarua lalua nene Elaisa amio Mosis, lalua am̃alivi amio pupia naurarena nae ma e peni, ana lalua asun ke amio naga, nap̃a asum̃a apisayu ke sanape nap̃a yoko naga monar va garu Yerusalem, a monar mare vetan yomarava nini, sa nap̃a Ntewa pisaaria p̃a rui. ");
INSERT INTO lww_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ana sumo, la telu Pita, Yoane a Semes nene asum̃a amloge marala kawa pap̃isi pano-o amomalio, ana pogos nap̃a atavilo sina, la amilan sur la nap̃ani, nap̃a apisu pupia naurarena kiena ne Yesu, a apisu lalua nap̃a asum̃al asike amio naga. ");
INSERT INTO lww_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ana apisu nap̃a lalua nene asape aligan si yo vena awasup̃ela, ana Pita sinenan sape visi, ana naga mninue m̃a visa ya ne, ana naga pisalawe ga visen kar tai pa Yesu, pisape “Sup̃e, popon nap̃a ita tesum̃a e nini. Popon teyum̃aen silparpara ve telu e yo nini, mom̃a tai, m̃ana Mosis tai, a m̃ana Elaisa tai.” ");
INSERT INTO lww_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ana pogos nap̃a naga sum̃a pisa ke visena nene, lul tai pitomi kalo la, ana pogos nap̃a la apisu sane apa ke loyum̃a e lul nene narui, amarau pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ana amloge visena tai molue e lul nap̃ani, pisape “Nanene na naruu ne, nap̃a nepisirlua naga rui. Naga ke narui monar alogear ruru naga.” ");
INSERT INTO lww_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ana pogos nap̃a visena nene p̃isi, lul nene kovio sina, apisu nap̃a Yesu naga taaga sike si amio la. Ana siraun nene, nalogena la nene apa ruru la, asum̃a ga sa ga ne, pe apa apisayu re sur nene pa yar tap̃ena la poli. ");
INSERT INTO lww_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ana e kana legiena na siraunia, Yesu amio la telu nap̃ani ap̃asup̃ela si apitom tano, ana pupia p̃ina na yeririna la asum̃ate ke naga, sinelan asape avisuia. ");
INSERT INTO lww_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ana pogos nap̃a apim am̃alivin la, lala yaru tai pion manene pa Yesu, pisape “Navianena, nepisa awis pan ko, ovisuli naruu na yerm̃ene nini, komin nap̃a naruu wawa taaga nena nini. ");
INSERT INTO lww_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ninuna viowa tai ne sum̃a pimi ke e naga sanene, kila naga mlokai manene pap̃isi, ana miokamarmare tasnena m̃arera pano-o wasirina la mlalau. Sur nene sum̃a kila ke naga pa piowa laa, kila kare naga pap̃isi, a sum̃a kila luen ga, pe mliganli re naga pa ruru pogos tai poli. ");
INSERT INTO lww_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","In na nopure naga pa puna ne kiom̃a nalogena lala, nepisa awis pan la vena am̃enelua ninuna viowa nene, ana la akilalia, amiyum̃aen pano-o, akila p̃ele yonia.” ");
INSERT INTO lww_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ana Yesu pisatam̃ea, pisa pan la, pisape “?Kam la nene, sanape na sanene? Pe asum̃al re nena ase Ntewa poli. ?Monar nesum̃a nemio kam wowe lala tol pogwai? In na sineu maren amiu rui. Ko, pogaga, oure narum̃a nene imi.” ");
INSERT INTO lww_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ana apa ap̃ure pimi, a pogos nap̃a apim ga sane, ninuna viowa nap̃ani kilapel ke sina ninis nap̃ani, kila tasnena miyuyuwawa a m̃arera. Ana Yesu pis kapuru pisalup̃ar ninuna viowa nap̃ani, a kila ruru m̃ee nene, ana mligan si pa arimana. ");
INSERT INTO lww_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","A la nap̃a apisu sur nene, amilan manene nam̃areraena nowo kiena ne Ntewa nene pap̃isi, nap̃a kila po sanene pap̃isi pan m̃ee nap̃ani. Ana siar e pogos nap̃a yar tap̃ena la asum̃a apisasayu ke sur wo nap̃a Yesu kila, ana Yesu pisa kiena visena tai pa kiena nalogena lala. ");
INSERT INTO lww_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Naga pisa pan la, pisape “Ayagogon ruru kiau visena nini, aligan ruru te kiamiu sitomena lala, vena ve sinemiu p̃esan re sina. Ee, nepisa ruru van amiu, nesape Ntewa mligan inu sane Narin Yeririna, ana lavis ke nap̃a aligan inu neva e limana ne yaru la nap̃a yoko awem̃ar inu nemare narui.” ");
INSERT INTO lww_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ana nalogena lala pe amloge kilale re ya nap̃a Yesu sum̃a pisayu ke pan la poli wa, sa nap̃a kana kinas tapolou ke ga wa, kila pe apisu kilale re poli, a amaraun m̃ena nap̃a aviun ruru va Yesu e lepas na visena nene. ");
INSERT INTO lww_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ana siraunia, veveyuena tai m̃alivi likan nalogena lala, nap̃a apisape ane to laa metavan lala tap̃ena lap̃asa. ");
INSERT INTO lww_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ana Yesu kilia m̃a kiela sitomena la nene, ana pio ninis tai nap̃a pimi ke puna, ana mligan ninis nap̃ani sum̃alu se yepasa, ");
INSERT INTO lww_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ana pisa pan la, sape “Yar nap̃a kiena sitomena patanon inu, ana naga kekaran wereruruen ninis nini, nanene sa ga nap̃a kekaran were ruru inuen ga narui. A yar nap̃a kekaran inu, naga sane kekaran ke ga naga nap̃a mligan inu nepim. Nanene komin nap̃a amiu ai nap̃a kiena sitomena su tano vap̃isi, naga ke narui nap̃a naga to metavan amiu make ga.” ");
INSERT INTO lww_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ana Yoane pisa pa Yesu, sape “Sup̃e, mepisu yar tai, nap̃a sum̃a pile plan ke yermare lala, naga m̃ene plan la e kiom̃a kia. Ana yaru nene, memninue ga, naga pe ita re tai poli, ana mepisalup̃aria.” ");
INSERT INTO lww_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ana Yesu pisa pania, pisape “Toko, visalup̃aren toko, komin yar nap̃a pe pisalup̃ar ita re poli, naga miila ita ke ne.” ");
INSERT INTO lww_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ana Yesu pisu kilale sape nanagane, lavis ke Ntewa were si naga va meta ma e peni narui, ana kila ruru kiena sitomena, sape kiena mrapa monar va ma meta Yerusalem narui. ");
INSERT INTO lww_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ana la amial apano, ana Yesu mligan kiena yar na waren visena lala la asumo apa e pulkumali tai kiena ne le Samaria lala, vena akila ruru make suria, naga sirau imi. ");
INSERT INTO lww_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ana la ne e yo nene, la pe sinelan re Yesu la aim e kiela yo poli, komin la pe sinelan re iilaen le Yu la nap̃a akom ke kiela yo poli vena ava meta Yerusalem. ");
INSERT INTO lww_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ana pogos nap̃a nalogena lalua nene Semes lalua Yoane apisu nap̃a apisalup̃ar la sa nene, lalua apiun tan Yesu, asape “Sup̃e, ko sinom̃an osape melen mevio kapi tai ligan ma e peni vitom tano kekan la nenaga?” ");
INSERT INTO lww_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ana Yesu p̃arpuia pis m̃arera pan lalua, pisalup̃ar la. ");
INSERT INTO lww_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ana pe apa re si e nene poli, la apa e pulkumali tap̃ena. ");
INSERT INTO lww_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ana pogos nap̃a amial ke e mrapa narui, yaru tai pimi pu Yesu, pisaar pania, pisape “Yoko netaveve ko e nape nap̃a visae ova ea.” ");
INSERT INTO lww_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ana Yesu pisatam̃ea, pisape “Lokul tetan lala la m̃ala pulus la sum̃a ga, a manu lala m̃ala ponovi la sum̃a ga. Ana inu Narina ne Yeririna, nap̃a nokom ma e peni nepitom, in na pe m̃au yo re poli, nap̃a neva nomonea. Visae ko okekaran m̃ena malena na sanene, ko okilia oimi.” ");
INSERT INTO lww_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","E ke e pogos nene, yaru tap̃ena tai, Yesu pisa m̃ena pania pisape imi tavevea, ana naga pisatam̃ea, pisape “Sup̃e, otam̃an neva nevisuar ke ne kiau yermarua sumo wa, a visae marp̃an pae, ana yoko neim netaveve ko ga na wa.” ");
INSERT INTO lww_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ana Yesu pisa pania, pisape “Oligan yaru la nap̃a pe atol re malena poli wa ava asin kiela yar mare lala. Ana ko, oim ga teva telologon navesup̃enena kiena ne Ntewa.” ");
INSERT INTO lww_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A yar tap̃ena si tai kila sa ke ga, kila sa nap̃a pisasa ga, pisa pa Yesu, sape “Sup̃e, yoko in na netaveve ko lue narui, ana sur taaga ga, nesape otam̃an neva nevisa ke ne pokolemalo va la ne um̃a m̃au wa.” ");
INSERT INTO lww_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ana Yesu pisa visen tai sanini pania, pisape “Yar nap̃a sum̃a sitom manene la m̃ana um̃a p̃arar kiena suri make ga, naga sane yaru nap̃a tarar ke p̃eligas nen waa, a silaga, sum̃a kira p̃atau lue ga. Yar na sanene pe torokin re imi ve yar na navesup̃enena kiena ne Ntewa poli.” ");
INSERT INTO lww_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ana e pogos nene, kieta Sup̃e pisir plan si kiena nalologena lap̃asa. La punu ga tol lualima yam olua pa lua 72, a naga sitom ke sape ligan la nene ava sumo, la veve lua ava e pulkumali lala a e yo la nap̃a yoko naga sirau va m̃alivi ea. ");
INSERT INTO lww_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ana naga pian la sanini, pisape “Lelaga, kinanena moki liu nap̃a marua sike lokove, ana yar la lua la ga nap̃a asum̃a ap̃ar ke pitomi um̃a. Monar aviun manene tan yerkawa na lokove nene, vena naga ligan plan re si yar lap̃asia la avanon awar kana kinanena la nene imi. ");
INSERT INTO lww_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sanene, monar ala kiamiu mrapa avano. Ana popon avisu kilale sane in na nemligan plan amiu apano, sa ga nap̃a narin sipsip, nap̃a apanon ke vena avitawe pupia lokul tetan lala. ");
INSERT INTO lww_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","A pogos nap̃a avano, ana ve awar re kiamiu taga na varu, a ve awar re kiamiu karo, a ve awar re si kiamiu kulus nen lamiu tap̃ena. Ava ga sa ga ne, ve asunlilue re mraplepa va yar lala. ");
INSERT INTO lww_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","A pogos nap̃a ava am̃aliv e yum̃a ya, sur nap̃a yoko avisa p̃esania, yoko avisa sanini, avisave ‘Sum̃are sike e um̃a nini.’ ");
INSERT INTO lww_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ana visae yaru nap̃a sike e um̃a nene naga sinenan sum̃are, yoko sum̃are nap̃a avisa kilia sike amio naga, ana visae pe yar re tai ne sanene poli, yokorena sum̃are wasup̃e si imi van amiu. ");
INSERT INTO lww_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","A ve ava aulaula kare e yum̃a tap̃ena lala, ana asum̃a ga e yum̃a nene, a akekaran ala kinanena ya pona namunena ya nap̃a ala imi van amiu. Ve amawan re ala sur wo ya nap̃a akila van amiu, komin nap̃a yar na yum̃aena naga mesmesun la kiena narin nalaena tai. ");
INSERT INTO lww_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Sanene na, visae kumali ya nap̃a ava aworu ea, visae akekaran nap̃a avisuar amiu, yoko monar akekaran ga kinanena ya nap̃a sinelan asape ala van amiu, ");
INSERT INTO lww_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","a monar akila ruru namaiena la e yo nene, a monar avisa van la, avisave ‘Nanagane, nasup̃enena kiena ne Ntewa pimi ke lavisin amiu, nanagane Ntewa pimi pe kiamiu Sup̃e narui.’ ");
INSERT INTO lww_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“A pogos lap̃asia, yoko aworworu e pulkumali tai, ana yoko ve akekaran re nap̃a aure amiu ava asike amio la. Visae sanene, amiu ataveve pupia mrapa nene ava e yepesinas na pulkumali nena, a avisawal va kana yar lala, avisave ");
INSERT INTO lww_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Puluyavi na mraplepa na kiamiu yo nini, imimi metan plan petan lamimi lala, sane kiamiu kile nasitom̃alen tai. Monar ve sinemiu p̃esan re, sane lavis ga navesup̃enena kiena ne Ntewa imi pun amiu narui, ana pe sinemiun re poli, ana akilalu narui.’ ");
INSERT INTO lww_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Nevisa lelaga van amiu, e legiena na lip̃ereena, yokorena la ne sanene la ava e nakoaena tai nap̃a m̃arera manene laa taulu nena nap̃a la nae pulkumali nap̃a Sotom nanua yoko awaria.” ");
INSERT INTO lww_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ana Yesu pis m̃arera pa yeririna na kumali tap̃ena lap̃asa, pisape “!Le Korasin, amio le Petsaeta, akila kare manene amiu pap̃isi wa! Visae le Taea amio le Saeton lala avisuli ga kile la nap̃a kam na apisu p̃isi rui, vera na avilopu la nanua rui. La pe ape le Yu re poli, ana vera na la ayen p̃ilili karo a akuan yavi e p̃arila rui, pona atotano m̃a sanene ana yaru la avisu sane sinela piowagan kemua kiela mlamulena viowa la lelaga. ");
INSERT INTO lww_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nevisa van amiu, e pogos nalip̃ereena, yokorena kiamiu nakoaena naga taulu nena nap̃a kiena ne la nene. ");
INSERT INTO lww_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“!A amiu le Kapeneam la nap̃a ap̃arwar amiu pap̃isi, nap̃a sinemiun asape avisir plan amiu asu manene metava, avisuar amiu! Yoko Ntewa koven amiu ato laa tano rui e pulus nen kapi.” ");
INSERT INTO lww_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","A Yesu pisa m̃ena pan la, pisape “Yar nap̃a visae yoko logear amiu, naga sum̃a mlogear in ke ne, a visae yar nap̃a yepen mavin amiu, naga sum̃a yepen mavin in ke ne, a yaru nap̃a visae yepen mavin in ke sanene, naga sum̃a yepen mavin ke yerkawa nap̃a naga mligan inu nepim.” Ana e visena la nene, Yesu mligan yar nalologena lala apanon akila yum̃aena. ");
INSERT INTO lww_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ana yar nalologena la nene apa akila yum̃aena wo la moki, ana siraunia ap̃asup̃e la si apim puna Yesu, nap̃a apulen manene kekarena e sur punu ga nap̃a akila rui. Ap̃asup̃e la, apisa pa Yesu, asape “!Sup̃e, memiyum̃aen sur la e kiom̃a kia pa tol nap̃a yermare m̃ena la asu vatanon imimi!” ");
INSERT INTO lww_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ana Yesu pisatam̃e la, pisape “Ee, kieta yum̃aena sanene narui. A in m̃ena ga, nom̃al Yermare molue ma e peni, akoven lua naga pitomi tano sane yekarpla tai. ");
INSERT INTO lww_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nanagane, in na netam̃an pan amiu rui, nesape akilia avieyar lom̃ara amio logovi, a m̃areraena kiena ne kieta nasinekar sike m̃ena vatanon lamiu, ana tap̃atete sur tai kila kare amiu. ");
INSERT INTO lww_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ana ve awarwar amiun re ya nap̃a in na netam̃an pan amiu, nap̃a ninuna viowa la asike vatanon amiu, ana sur taaga ga nap̃a akilia aulen manene kekarena vanonia, na nap̃a kiamiu kia lala asiri plan sike loyum̃a e tus namalena rui.” ");
INSERT INTO lww_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ana e pogos nene Ninuna Wa kila sinena ne Yesu kekara pap̃isi, ana Yesu mlen, pisape “!Ata o, ko ope Sup̃e nae ma e peni a Sup̃e nae yomarava nini! Nevisa potena van ko, Ata, vanon sur la nap̃a e lepas na pun inu, okila meraravan pan la nap̃a kiela sitomena sa ga nin sisi lala, ana yaru la nap̃a asitom asape ape manmarua a la nap̃a asape akilia ruru suria, ko okilawan sur la nene van la. Lelaga p̃a Ata, nanene na sa ga nap̃a ko sinom̃ania.” ");
INSERT INTO lww_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","A Yesu pisa m̃ena pan la, pisape “Ata mligan suri punu sike e lum̃au rui. A Ata naga taaga nap̃a kilia inu sape in na ai, a inu nap̃a nepe narina, in ga taaga nap̃a nekilia ruru naga, nesape naga ai. Inu nemio la nap̃a ne nemliganar la vena nekipian la e Ata vena awasine naga, imimi la nene narui nap̃a mekilia ruru naga nap̃a pe Arimamimi.” ");
INSERT INTO lww_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ana Yesu pilon pa puna ne kiena nalogena lala, pragogo ga pan la, la ga amloge, pisape “Ntewa kila po pan amiu pap̃isi, nap̃a akilia avisu suri la nene. ");
INSERT INTO lww_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Navisawalena la mok liu amio p̃arin sup̃e la mok liu nanua sumo nap̃a la sinelan manene pap̃isi asape avisu sur la nene, ana pe apisuli re pogos tai poli, a ap̃aryon asape aloge m̃ena sur la nene, ana la pe amloge re nena poli.” ");
INSERT INTO lww_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ana pogos tap̃ena si tai, yar tai naga pe manmarua ruru e navisaluaena, naga pisape kilali Yesu e naviunen m̃arera tai ana naga sum̃alu, piun tan Yesu, pisape “?Navianena, visae sineun nesape nekilali netol malena nap̃a pe luas re poli, yoko monar nekila ve sanape?” ");
INSERT INTO lww_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ana Yesu pisatam̃ea, pisape “Ana kieta Tus Wa pisa ya ne e lepas nene? ?Ko opuloia opisu pisa sanape?” ");
INSERT INTO lww_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ana yar nap̃ani pisatam̃ea, pisape “Tus Wa pisa sanini, pisape: Ntewa na mava nap̃a naga pe kiom̃a Ntewa, ko monar sinem̃a si naga, oligan naga to sumo e losinem̃a wetelu, a e kiom̃a malena wetelu, a e kiom̃a m̃areraena wetelu, a e kiom̃a sitomena wetelu, a ko na monar ositom nalavis pum̃a lala, okila wo van la, sa nap̃a ko ositom ko ke ga.” ");
INSERT INTO lww_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ana Yesu pisa pania, pisape “Ee, opisa mesmesun nena narui. A visae okila ve sa nene, yoko otol malena nane opiun ke ne.” ");
INSERT INTO lww_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ana yar nene kilia sape naga pe kila re mesmes sanene poli, ana naga kilali nap̃a kila pisape mninue ga, piun tan Yesu, pisape “?Ana a la ne asike lavis pun inu nap̃a monar nekila wo van la?” ");
INSERT INTO lww_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ana Yesu pisatam̃e kiena naviunena nene e p̃akaiwa tai, nap̃a pisape “E legiena tai, yar tai molue ma Yerusalem, sum̃a mialoro pito garo Seriko. Ana naga mialoro m̃a sanene pano tol yom̃arera tai, ana milan p̃egas nen yar na vinauen tai, nap̃a apulania, am̃e kare naga pap̃isi, ap̃ar plan make kiena suria ap̃ure, amligan naga marluia m̃eke kiena mrapa komsusa. ");
INSERT INTO lww_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ana kieta yar wa tai, naga m̃ena mialoro e mrapa nene naga siraun pimi, ana pogos nap̃a pimi lavisin yar nene, naga miyepe ga pa e isinen mraplepa, mial p̃aro pano. ");
INSERT INTO lww_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ana siraunia, yar tap̃ena mial pimi. Naga pe Livae la tai, nap̃a asum̃a akila ke yum̃aena make ga e Yum̃a Wa m̃ana ne Ntewa, ana pogos nap̃a pimi tol yar nap̃ani, naga m̃ena ga yepen mavin iilaena, miyepe ga pa e isinen mraplepa mial ga p̃aro pano. ");
INSERT INTO lww_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ana siraun sina, yar tap̃ena, nap̃a naga sum̃a mlilu kiena mrapa viavi tai pimi. Naga pe yere Samaria tai, ana sa nap̃a tekilia, yar la nene pe ape erau wo re amio ita le Yu la poli. Ana pogos nap̃a pimi tol e yo nap̃ani, pisu yar nene marlu m̃eke e yo nap̃a am̃e ea, ana sinen miye pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ana naga pimi lavisinia, kevan lele la nap̃a la nene am̃ea, plan sirveve e magka la nap̃ani, piar ruruia. Ana tarlua yar nena, mligan mon meta e kiena togki, ana mial m̃a amio pano-o tol yo tai nap̃a yum̃a na varuruen tai m̃eke ea. Ana p̃ere naga pa loyum̃a ea, miila naga po pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ana kolulagi, p̃ar kiena varu tai, kian pa p̃ar na yum̃a na varuruena nap̃ani, pisape ‘In na monar neva si e kiau mrapa narui, ana yar nene yoko sike e lumom̃a sumo wa. Ovisuar ruruia e sur punu ga, a visae varu nene ve torok re, yoko in na nevisuveve si e pogos nap̃a nowasup̃e si e kiau yalena nini.’” ");
INSERT INTO lww_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ana Yesu piun tan yar nap̃a piun naviunena nene pania, pisape “?Opisu suniena nene sanape? ?E yar la telu nap̃a amiyal e mrapa nap̃a yar nene m̃eke ea, yar ai nap̃a kila pania sa ga yar tai nap̃a m̃eke ga lavisinia?” ");
INSERT INTO lww_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ana yar nap̃a pisape “Nesitom nesape yar nap̃a sinen miyea, a miila.” A Yesu pisa si pania, pisape “Ore, naga ke narui, a ko m̃ena ga, ova otaveve kiena p̃elaga wo nene.” ");
INSERT INTO lww_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ana e pogos nap̃ani, Yesu amio kiena nalogena lala amiyaloro ke apa ma Yerusalem, ana apa am̃alm̃aliv e narin pulkumali nap̃a Petani, ana sira nap̃a Mareta p̃ere Yesu pa m̃ala um̃a. ");
INSERT INTO lww_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ana pogos nap̃a Yesu pa sike amio la nene, luena ne Mareta nene tai, kiena kia Maria, naga totano ga teke lavisin lana ne Yesu, tom̃a miyagogon ruru ke kiena navianena lala. ");
INSERT INTO lww_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ana e pogos nene, Mareta naga pe tom̃a miyagogo re poli, ana naga sum̃a m̃areran ke sape kila ruru make sur punu ga sum̃ate Yesu, a naga sitom manene laa e yum̃aena la nene. A siraunia, pimi pisu Maria to ga tano tom̃a ga, miyagogon m̃a Yesu, ana pisa pa Yesu, pisape “Sup̃e, luou nam̃a to koren ga tom̃a sanene, ana in ga taaga nekila make suria. Pona ko opisu kilale re poli yo, ana popon ovisa vania vena imi iila inu.” ");
INSERT INTO lww_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ana kieta Sup̃e pisatam̃ea, pisape “Mareta, ko sireyar tai nap̃a ositom manene sur pap̃isi, a omloge piowagan manene sur moki laa na sanene wa. ");
INSERT INTO lww_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ana sur taaga ga tom̃a ga nap̃a yoko ko ositom manene urmi ea, nane suri ne nane Maria m̃al rui e kiena malena, ana yoko in na tap̃atete si nelalua vetania.” ");
INSERT INTO lww_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pogos tai, Yesu pa mlen e yo tai, p̃isi p̃asup̃e pitomi, ana kiena nalogena tai piun tania, pisape “Sup̃e, visae okilia ovian imimi lia vena imimi m̃ena mekilia melen, sa ga nap̃a sumo na Yoane pian kiena nalogena lala vena alen, vera na wo vap̃isi.” ");
INSERT INTO lww_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ana Yesu tam̃an, pisape “Pogaga, visae sinemiun leniena, akilia avisa sanini, avisave: ‘Arimamimi, torokin kemua nap̃a imimi mevatanon kiom̃a kia wa. Memlen mesape kiom̃a navesup̃enena imi. ");
INSERT INTO lww_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mepiun tan ko, mesape ola kinanena van imimi p̃ane a e legiena punu ga. ");
INSERT INTO lww_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","A oviewo kiamimi mlamulena viowa lala, komin imimi mepiewo ke la nap̃a akila ke piowa pan imimi. A ve oligan re suri la imi akilali manene imimi.’” ");
INSERT INTO lww_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ana Yesu pisape monar ve amaraun re viunen sur tan Ntewa, ana pisa p̃akaiwa tai pan la, pisape “Visae kolemalo koe yepe lilika tai, oilan ga kiom̃a erau tai yal imi tol yo pum̃a. Ana pe kom̃a kinanen re si poli, ana monar okirir ova pun yum̃a tai nap̃a m̃eke lavisin ko, monar oviun manene tania, ovisave ‘Wolai, kiau erau tai pimi porun in ga nagane na wa, ana in na lum̃au plas nena ga. In na pe kau kinanena re si nap̃a nekilia nela van kan poli. ?Ko na kom̃a kinanen tai tom̃a ga okilia otam̃an van inu sumo wa?’” ");
INSERT INTO lww_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Ana sanape, tesitom tesape yoko yaru nene kilia visatam̃e visave ‘Aa, ve okila re yum̃aena m̃arera sanene van inu. Opisu ke ne, mokotava rui, ana memio nin sisi la, mom̃eke e m̃amimi tog rui, ana tap̃atete si nesum̃al narui.’ Ana peraga, yaru nene tap̃atete visa sanene.” ");
INSERT INTO lww_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ana Yesu yakol si visena van la, sape “Pona pogos tai yaru tai kilia sitom korenan ko, yepen mavin iila koena vanon ga ko na osike lavisinia. Ana visae ve omawan re nap̃a oviun kap̃aran m̃a sanene vano vano-o, yoko yar nene monar la ya nap̃a opiun ke ne van ko.” ");
INSERT INTO lww_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Ana maran taaga e p̃akaiwa kiena ne Yesu nene, naga pisa ke sina pan la, pisape “Yaru nap̃a piun ke suria, naga tol silaga, a yaru nap̃a kale ke suria, naga m̃alia, a yaru nap̃a sigariga ke mratava, pulutava pietava pan silaga. Visae sanene, yoko akilia awar ya nap̃a apiun tan Ntewa, a alual ya nap̃a akale ke puna, a mratava nap̃a asum̃a asigariga ke ne, vietava van amiu. ");
INSERT INTO lww_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Visae narum̃a tai viso karia, viun narin ika nap̃a teke ne, tap̃atete ola lom̃ara vania, ");
INSERT INTO lww_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","pona visae naga viun kopululus nen lakaporo nap̃a teke ne, tap̃atete ola logovi tai van kania. ");
INSERT INTO lww_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Lelaga nap̃a kam na ape yar viowa ga lala, ana amiu yar tai tap̃atete kila sanene, asum̃a akekaran ga nap̃a ala suri wo la va narimiu la silaga. Sanene, pogos nap̃a aviun tan Arimamiu nae ma e peni, naga kekara manene la a nap̃a la Ninuna Wa van amiu nap̃a ape narina lala.” ");
INSERT INTO lww_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ana siraunia, ap̃ure yaru tai nap̃a yermare pa e naga pimi puna Yesu. Yermare nene kila yar nena pe pis re poli, ana Yesu pilelua yermare nap̃ani petania, ana naga pis ruru sina, kila yar la nap̃a apisu sur nene amilan pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ana la p̃as apielue, ana apisalele kare Yesu p̃isa, apisape “Yar nene pile plan ke yermare lala e ga e nam̃areraena nap̃a sup̃e kiena ne yermare lala, nap̃a kiena kia Pielsipel, tam̃an pania.” ");
INSERT INTO lww_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ana la si p̃asa, la m̃ena asitom piowa e Yesu, ana asum̃a akilalia, sinelan asape am̃arerania vena kila kile tai nae ma e peni avisuia. ");
INSERT INTO lww_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ana Yesu mloge kilale kiela sitomena lala, ana pisape “Visae sup̃e tai, kiena yeririna la alip̃ere la, nap̃a lap̃asia akawe lap̃asia, yoko yum̃aena kiena ne sup̃e nap̃ani monar loru. A visae um̃a tai, asum̃a alip̃ere la, nap̃a lap̃asa asape am̃ene plan lap̃asa, yoko la nene tap̃atete asu ruru pog tai. ");
INSERT INTO lww_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","?Sa m̃ena nini, visae yermare kiena ne Yermare Lego la asum̃a amlip̃ere la ke rui, ana yoko nasup̃enena kiena ne Yermare Lego sum̃alu ve sanape ne? !Kam na apisa ke sur pa sanene narui, asape in na nesum̃a nom̃ene plan ke yermare lala e nam̃areraena kiena ne pupia yermare nap̃a Pielsipel, ana tap̃atete nena ve sa nene p̃isa! ");
INSERT INTO lww_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","?A visae ve sa kemua nap̃a apisa, ana komin ya nap̃a kam la p̃asa asum̃a am̃ene plan ke yermare? ?Ane tam̃an m̃areraena nene pan la, pona yermare m̃a nene yo? Popon sa kiamiu nalogena la nap̃a am̃ene plan ke yermare lala aloge kiamiu visena la nene. ");
INSERT INTO lww_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ana peraga, apis pe po re nene poli. In na nesum̃a nepile plan ke yermare lala e ga e nam̃areraena na limana Ntewa, a sur nene na kana kinasa sane navesup̃enena kiena ne Ntewa sike likan amiu rui. ");
INSERT INTO lww_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“!Apisu ke ne! Sa nap̃a visae pupia yar m̃arera tai, naga war kiena pupia suri na mara lala, naga sum̃a kirawo ruru ke m̃ana yum̃a. Ana sur kiena ne yar nene su ruru ga sum̃a e kiena kove. ");
INSERT INTO lww_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ana Yermare Lego kiena yum̃aena naga sa ga nene. Visae yar m̃arera tap̃ena imi nap̃a m̃arera laa taulu naga sane, yoko lalua akila m̃a mara vano naga taulu Yermare Lego, ana yoko kilia war plan kiena sur na mara lala, nap̃a naga p̃asine p̃esania, a yoko naga kilia war make sur la nap̃a sike loyum̃a e kove nene ve kiena, ana lip̃ere va kiena yeririna lala. ");
INSERT INTO lww_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Yaru nap̃a pe taveve in re poli, naga sane suwo in ke ne, a yar nap̃a pe miyum̃ae re amio in poli, vena moure kiau yeririna la aim lele taaga, naga sum̃a m̃ene tetain la ke ne.” ");
INSERT INTO lww_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ana Yesu pisa m̃ena ga, pisapenua “Pogos tai, pog nap̃a am̃enelua yermare e yar tai, yermare nena kilia va yom̃arua vena kaleli yo tai nap̃a va se ea ve m̃ana um̃a. Ana visae ve lual re, yoko naga visavenua ‘Aa, yoko neto li si e m̃au um̃a marua na sumo.’ ");
INSERT INTO lww_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ana pogos nap̃a pitomi, yoko naga lual sane akilavan ruru ga m̃eke na, akila ruru make sur la e yum̃a nap̃a p̃isi rui. ");
INSERT INTO lww_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ana yoko naga va were si yermare tap̃ena la ve olua nap̃a apiowa manene laa taulu naga sane atom amio, ana yoko ava si asike los nen yar nene. Ana yar nene nanua sumo kiena malena piowa, ana siraunia kiena malena piowa manene laa sane.” ");
INSERT INTO lww_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ana e pogos nene, sira tai sike amio la nap̃a apisu ke sur la nene, a nap̃a amloge ke visena kiena ne Yesu lala, ana sira nap̃ani kekaran pap̃isi. Ana pion manenea, pisape “!A kee, anom̃a nap̃a p̃ar ko, a mla yu pan ko, navisa ruruena kiena ne Ntewa keviu pap̃isi pania, nap̃a naga p̃ar sisi tai sane ko.” ");
INSERT INTO lww_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ana Yesu pisatam̃ea, pisape “Ee, nanene na lelaga, ana nevisa van ko, nesape navisa ruruena kiena ne Ntewa va ve keviu manene laa sanene sike e yar ai nap̃a logear visena lala kiena ne Ntewa, a nap̃a kila ya nap̃a naga sinenania.” ");
INSERT INTO lww_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ana e pogos nene, p̃ina la nap̃a amiagogon ke Yesu asum̃a apim la mok manene laa narui, ana Yesu kilia m̃a nap̃a sane la moki nap̃a apimin ga avisu kiena kile lala, ana pis pan la, pisape “In na nepisu sane lus na yeririna nanagane lala la apiowa laa. La sinelan asape avisu ga kile lala, ana peraga, Ntewa tap̃atete nena la kile tai van la vena avisuia. Ana kile kiena ne navisawalena Sona nanua sumo, naga ga nene akilia avisuia. ");
INSERT INTO lww_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ntewa mligan Sona, naga sane kile tai kiena ne la nae Ninive nanua sumo, ana naga mligan m̃ena inu Narina ne Yeririna nepimi sane kiamiu kile na nagane tai. ");
INSERT INTO lww_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","“Ana le Ninive la nanua sumo amloge visena kiena ne Sona, la apilopu la e pogos nene, a yoko la nene asum̃alu ase e legiena na lip̃ereena, la avisa lologia kiamiu naviowaena, komin yar tai nap̃a naga to laa metavan Sona naga sike amio amiu, ana pe apilopu amiu re nena ga. “A nanua m̃ena sumo nap̃a sira kawa tai pe p̃arin sup̃e tai nap̃a molue e kiena purvanua nap̃a sike koperin pap̃isi, pitomi tano vena loge visena na manmaruaena lala kiena ne yermarua P̃arin Sup̃e Solomon. Ana sira kawa m̃ena nap̃ani yoko naga sum̃alu se e legiena na lip̃ereena nene ana visawal ruru nena kiamiu naviowaena lala, komin nap̃a yar tai naga to laa metavan Solomon naga sike amio amiu, ana pe sinemiun re nena naga poli.” ");
INSERT INTO lww_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ana Yesu pisa m̃ena, pisape “Pogos nap̃a tesilan kapi vivaga, ve tesilan re ga p̃isi na teva towarwan m̃eke e p̃ilip̃ili tai e porotano, pona takalo si e piaki tai, ana tesilania vena tetelan to metava, vena visae yar imi loyum̃a ana lual nap̃a kapi vivaga nene tegoli make nena yo.” ");
INSERT INTO lww_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ana Yesu pisa m̃ena, pisape “Kilamaran yar naga sane yo taaga ga nap̃a yomerava pimi ke loyum̃a e tasnena. Sanene, visae kilamaram̃a merarava ruru wo, visu ruru nena sur lala, yoko ve sa nap̃a tasnem̃a pulemamaga nena e yomerarava. Ana visae kilamaram̃a viowa, pinaia sur la punu ga nap̃a sum̃a pisuia, yoko ve sa nap̃a losinem̃a pulen nena yemalolo. ");
INSERT INTO lww_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Visae sanene monar avisuar ruru amiu, vena kapi vivaga nap̃a teke e losinemiu ve imi re si ve sa yemalolo. ");
INSERT INTO lww_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","A visae losinemiu la ulen ruru luen ga kapi vivaga silaga, nap̃a ve narin malo re nena tai teke ea, yoko kiamiu malena tego ruru nenaga, tegoli make yo punu ga.” ");
INSERT INTO lww_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu pis m̃a pa p̃ina la pa sanene, ana Varasi tai nap̃a tom̃a miyagogonia pisa pania pisape yoko were va m̃ana, kila kinanen tai vania. Ana amio Yesu apano, ana pog nap̃a kinanena su ruru pa sike na, ana Yesu pa totano e lelen kinanena. ");
INSERT INTO lww_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ana e pogos nene, Varasi lala la sane monar atarar m̃arera navisaluaena tai nap̃a sane yar monar taveve mrapa lap̃asa nakevanen limana, p̃isi na kilia kinana. A Varasi nap̃ani sitom pisape Yesu naga pe yaru wa tai, naga monar kila ve sa nap̃a kiela p̃elaga m̃arera nene pisa, ana pogos nap̃a pisu sane Yesu pe sitom manene re kilaen poli, naga milan manene pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ana Sup̃e pis pa yar nap̃ani, pisape “In na nekilia make kiamiu p̃elaga le Varasi la rui. Amiu na sinemiun manene asape akevan ruru m̃amiu piala amio kamiu pialora la silaga, ana apilaven pap̃isi, asitom ke asape kam na amekik pap̃isi ne, a ape yar wa. Ana pupia kororaki sike e amiu na wa, komin losinemiu lala pulen kilakotaliaen yaru, a nakila kareen yaru, a p̃elaga viowa la ne sanene. ");
INSERT INTO lww_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","!E, ve ave wowe re sanene! ?Pe apisu kilale re nap̃a asape Ntewa nene nap̃a si make sur na vanua e sur punu ga, naga si m̃ena loyum̃a na sur make ga, ana po pap̃isi nap̃a visae akila yepas nemiu la punu ga ikik ruru nena wo lelaga, vanua amio loyum̃a. ");
INSERT INTO lww_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sur nowo la nap̃a asum̃a akokonia manene ke e kamiu pialora amio m̃amiu piala lala, visae alip̃ere re ga lap̃as va yar la nap̃a limala plasia, vera na wo na wo. Visae ve sanene, pona yoko avisu kiamiu sur la imi ikik ruru yo rui, ana ve am̃areran re si kilaen kiamiu p̃elaga tap̃ena lap̃asia.” ");
INSERT INTO lww_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ana Yesu pisayu p̃elaga navisokanena kiena ne li na sumonen na lotena lala pa laa sane, pisape “!Amiu le Varasi lala, o! Akila kare amiu pap̃isi wa, yoko viowa manene laa van amiu. In na nekilia m̃a nap̃a apisuar ruru ke silaga, asape visae awar kamiu kinanena ve lualima, yoko monar tai va e yum̃a m̃ana Ntewa, sa nap̃a navisaluaena sum̃a pisa, a asum̃a akila ke sanene e kamiu sur punu ga, pano-o tol m̃ena narin m̃as nen kapis lala a sur m̃ena la nap̃a sane mrasil. Ana sur kerkeviu la nap̃a navisaluaena pisa, kam na pe asitom re nena poli, sa nap̃a pisape monar amesmes ruru wo, a monar sinemiu si Ntewa a yar tap̃ena lala. Visae sinemiun uararen narin sur la nene m̃arera, naga pogaga, ana pupia sur kerkeviu la nene popon visae asum̃a akila ga rui, ana pe akilali re nenaga. ");
INSERT INTO lww_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“!Amiu le Varasi lala, o! Akila kare amiu pap̃isi wa, yoko viowa van amiu vap̃isi. Loyum̃a e yum̃a na leniena lala, sinemiun asape ato luen ga tano e lelen yerkawa lala, a visae ayaloro e marana yeririna lala, sinemiun asape monar avatanon amiu, avio ruru amiu, avisave ‘A ke, navianena wo, pokolulagi!’ ");
INSERT INTO lww_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yoko viowa manene van amiu vap̃isi, komin nap̃a kam na sane suri korena ga, kam na sane lotap marua la nap̃a yaru la sinela p̃esan rui, ana amialor ke ga meta ea, pe apisu kilia re asape suri kona tai menunu m̃eke tano e poli.” ");
INSERT INTO lww_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ana e poglis nene, yar tai nap̃a pe manmarua ruru e navisaluaena, naga m̃ena sum̃a miyagogonia, ana mloge sane visena kiena ne Yesu tol ruru naga amio m̃ena la nap̃a amiyum̃ae ke sane naga, ana pisape “!Navianena, nemloge sane sinom̃an osape ovisa kare imimi towe m̃ena ga!” ");
INSERT INTO lww_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ana Yesu pisatam̃ea, pisape “!Ee, yoko viowa m̃ena van amiu li navisaluaen lala! Asum̃a apisir plan ke sina narin navisaluaena lala e lepas nen nalotena silaga, sane sur urmi la nap̃a asum̃a akuanpolo sike e m̃asin yar lala asape monar awaria, ana amiu, asum̃a ga sanene, pe akululun re nena mrasilmamiu tai vena akilali nap̃a aiila la. ");
INSERT INTO lww_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yoko viowa nena van amiu, komin nap̃a kam na asum̃a amiyowauia ruru ke tampona kiena navisawalena la kiena ne Ntewa, ana amiu na maran taaga ga sa ke repimiu marua la nanua sumo, nap̃a la ke narui nap̃a am̃e mom̃ar navisawalena la nene. ");
INSERT INTO lww_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kam na amio la nene maran taaga, komin nanua sumo, yermarua la nene la am̃e mom̃ar navisawalena lala, ana nanagane kam na akekaran ke yum̃aena ken la nene, kam na asikol ke si ne nap̃a asum̃a amioa ke kiela tampona lala. ");
INSERT INTO lww_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Kam na sane na visena na manmaruaena kiena ne Ntewa nap̃a pisa nanua sumo, nap̃a pisape ‘Yoko neligan kiau navisawalena lala a kiau li nalologena lala imi van la, ana yoko akila kare la, pona yoko awe mom̃ar la.’ ");
INSERT INTO lww_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Visena nini, kana kinasa sane yoko kam ke narui nap̃a akus nakoaena kiena ne nawem̃aren navisawalen la punu ga nap̃a repimiu na sumo lala am̃e mom̃ar la, siar e nasiaren purp̃es nen yomarava nini. ");
INSERT INTO lww_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Naga nene siar e Epela nene, pimi tol Sakaraea nap̃a repimiu la nene am̃em̃aria likan wonta amio yo wa loyum̃a e yum̃a wa m̃ana ne Ntewa. Lelaga nane nevisa van amiu ne, sane nakoaena na kuruta kana navisawalena lala kiena ne Ntewa sike e kam nanagane. ");
INSERT INTO lww_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ee, piowa pan amiu yaru na kilia ruruen navisaluaena lala, komin kam ke nap̃a amlawan ki na pulutava na kiliaena, ana kam na pe apa re si loyum̃a e poli, a asum̃a asuwo ke mrapa pan yar tap̃ena la nap̃a sinelan asape ava loyum̃a.” ");
INSERT INTO lww_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ana Yesu pisa pa visena la nene, molue petan yum̃a nene pano, ana navianen navisaluaena lala amio Varasi lala sinela mlaean naga pap̃isi, nap̃a sinela mimi kar pap̃isi. Ana la apanon Yesu silaga, asum̃a akuan ke visen m̃arera a naviunen m̃arera la pania vena ayurli naga, ana akilali m̃ena nap̃a asape naga visa visena lap̃asa nap̃a ve mesmes re. ");
INSERT INTO lww_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","La apanon Yesu sa nap̃a naga pe sur tetan tai, komin nap̃a sinelan asape alual kiena visena lap̃as nap̃a torokin alip̃ere naga vanonia. ");
INSERT INTO lww_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ana p̃ina la apim ke puna Yesu na wa, la ataulu manu mok liu, a poglis nap̃a apim ke lele taaga sanene, yo ve tokaki ga, a asum̃a apieyepal kare ke ga lala lala. Ana pogos nap̃a Yesu pe pis re pan la poli wa, pis p̃esan pa kiena nalogena lala, pisape “Kam na avisuar ruru amiu e p̃elaga viowa kiena ne Varasi lala, komin nap̃a la asum̃a apivis ke ga e gola, la asum̃a apis vilave ke sanene, ana apisokan ga ne. P̃elaga viowa kien la nene kilia va tolkare yar tap̃ena lala, sa nap̃a is na kilaparavi naga ve tokak ga ana p̃armake puluyavi na kilaparavi nene veraga. ");
INSERT INTO lww_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sur viowa make ga nap̃a yar la ne sanene asum̃a amiyum̃aen vinaun ke na, pona nap̃a apisawan ke ga, yoko amolmolue e yo metava na wa, vena yar punu ga akilia. ");
INSERT INTO lww_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Visena ya nap̃a yar pisa ke ga e yemalolo, yoko monar aloge sina ko legiena, a sur la nap̃a yar pisa mumun ke ga m̃ana loyum̃a, yoko monar avion manene si va metava e maran yar make ga, vena yar make ga akilia aloge.” ");
INSERT INTO lww_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ana Yesu pisa m̃ena pa kiena nalogena lala, pisape “Erau lala, nevisa van amiu sanini, nesape ve amaraun re la nap̃a akilia awem̃ar ga tasnemiu mare, ana siraunia tap̃atete si akila sur tai va ninumiu. ");
INSERT INTO lww_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ana in na sineun nesape nevis ruru van amiu nesape yoko amaraun yar ai? Yoko monar amaraun nena Ntewa, nap̃a naga kilia kilam̃ar p̃esan tasnemiu sumo, a siraunia kilia kuan ninumiu vito e lele na logeen viowa. Lelaga p̃a, yar ne nanene na monar amaraunia. ");
INSERT INTO lww_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ana visae amaraunia, yoko tap̃atete si amaraun sur tai, komin Ntewa na sum̃a pisuar ruru amiu m̃aga, sitom̃al amiu m̃aga. Asitomli narin ninlaea la nap̃a la moki kar ga asike ne, sa ga kororaki, a yar la asum̃a ap̃iliwilin ke la lima e ga e narin varu tai, ana Ntewa naga sitom̃al make la ga peve taaga silaga, pe sinen p̃esan la re nena poli. ");
INSERT INTO lww_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","A vilp̃arimiu m̃ena lala, moki pap̃isi, ana naga polo make vilp̃arimiu la peve taaga na sike ne. A Ntewa na pisu amiu na po pap̃isi, taulu ninlaea la nene, ana yoko visuar amiu e sur punu ga na kiamiu malena lala.” ");
INSERT INTO lww_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ana Yesu pisape “Yar a nap̃a pisawal e maran yar lala pisape naga pe kiau tai, yoko inu Narina ne Yeririna inu m̃ena nevisawal e marana ne navisi lala nae ma e peni nevisave yar nene naga pe kiau. ");
INSERT INTO lww_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ana yar a nap̃a pisawal e maran yar lala pisape pe pe kiau re poli, yoko inu Narina ne Yeririna inu m̃ena nevisawal e marana yar lala nevisave yaru nene na pe pe kiau re poli. ");
INSERT INTO lww_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mlamulen viowa amio visen viowa lala, a visena nap̃a kila kare inu Narina ne Yeririna, Ntewa kilia viewo ke yar vanon na wa. A yar nap̃a kila kare sur wa kiena ne Ninuna Wa, pisayu yum̃aena kiena ne Ninuna Wa pisape Yermare Lego ga miyum̃aenia, yar na sanene Ntewa tap̃atete viewo pogos tai.” ");
INSERT INTO lww_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“A visae pogos lap̃asia, yar la sinela kar amiu, yoko avis van amiu. Yoko akilia aure amiu ava asum̃al ase maran yerkawa lala na yum̃a na leniena, pona kumali, ana ve asitom manene re avisave yoko akilia avisatam̃e la ve sanape ne, pona yoko avisa visena ya na van la ne. ");
INSERT INTO lww_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","E nena e aora ga nene, yoko Ninuna Wa ga iila amiu, vian amiu e visena ya nap̃a akilia avisa.” ");
INSERT INTO lww_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ana yaru na p̃ina nene tai pion ke pa Yesu, pisape “Navianena, wolai sum̃a kila kare in ke ne, pe mlip̃ere ruru re lalimana arimamimi pan in poli. Popon ovisa vania monar kila mesmes ga van inu.” ");
INSERT INTO lww_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ana Yesu pisatam̃ea, pisape “Peraga yaru, sur nene ve in re na nekila. In na pe nepe yar na lip̃ereen re yar poli.” ");
INSERT INTO lww_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sanene, Yesu pe kila re sa nap̃a yar nene pisa poli, ana mla visena tai pan la e lepas na sinesunen manenea. Naga pisape “Monar avisu ruruia, pe pon re avieluen manene yar tap̃ena la poli, sinemiun manene laa asape awar kiela sur lala. Kieta malena pe su re e sur moki la nap̃a towar poli, ana kieta malena na sum̃al ga sike e sur tap̃ena.” ");
INSERT INTO lww_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ana e nene Yesu sikol kiena visena pa laa sane, naga pisa p̃akaiwa tai pan la, pisape “Yar na sur moki tai, kiena porotano keviu pap̃isi, a po m̃ena pap̃isi, ana kana lokove la p̃ar kinanen moki pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ana yar nap̃a pisu kinanena la nene, sitom p̃ele narui, pisape yoko naga kila ve sanape ne, yoko ligan ruru kana kinanena la nene su pe ne, komin kiena yum̃a na kinanena lala a kiena yo tap̃ena la puleule make rui. ");
INSERT INTO lww_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ana yar nap̃ani pisape ‘Yoko nowe plan ga kiau yum̃a na kinanena na urmarua la nene, ana nekila si urviu lap̃asa, nap̃a akerkeviu laa sane, atorokin kinanen make la nene amio kiau sur moki tap̃ena la nap̃a sike ne. ");
INSERT INTO lww_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pogos nap̃a nekila pae, yoko nevisave in na sane in ke narui, in na nopo laa narui. !Lelaga p̃a, yoko neloge wo vap̃isi! Kiau sur moki la nene, yoko nakan la m̃a sanene vano-o, la avisuar ruru inu e kas ve moki. E pogos nene, in na tap̃atete si neyum̃ae narui, yoko in na nakan ga ya nap̃a in na sineunia, yoko nomun korena ga suria, sane nesu luen ga e malena wo narui.’ ");
INSERT INTO lww_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Yar nene sitomiyu ke sanene pano, ana mninue ga, naga ke nap̃a Ntewa kila ruru ke sape vis van narui, visave ‘Peraga yaru, ko na ope wowe ga. Yemalo ga nini, nesape nelalua si kiom̃a malena vetan ko. A kiom̃a sur moki la nap̃a om̃areran omiyuwon polo pe kiom̃a sike ne, yoko a ne ve kiena si narui?’” ");
INSERT INTO lww_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ana Yesu pisa pan la, pisape “Yoko ve sa ke nene narui va la nap̃a amiyuwon polo ke kiela sur lala, la ape yar na sur moki e yomarava nini, ana la pe ape yar na sur moki re nenaga e lepas kiena ne Ntewa.” ");
INSERT INTO lww_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ana Yesu pisa m̃ena pan kiena yeririna lala, pisape “Visae sanene, in na nevisa van amiu, nevisave, pe pon re kiamiu sitomena la ulen manene kiamiu yum̃aena na visuar amiuen ga la poli, nap̃a apiuviun ke asape ‘?Yoko telual kata kinanena pe ne?’ pona ‘?Yoko tetol m̃ata kulmrae na yenen sanape ne?’ ");
INSERT INTO lww_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sitomen la nene pe mesmes re poli, komin kiamiu malena naga to laa metavan kinanena, a yepemiu na to laa metavan kulmrae. ");
INSERT INTO lww_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Asitomli sako la ne akaka kar ke la ne. La nene pe amapla re lokove po, la pe apanon re ap̃ar kinanena pimi po, a pe lelen kala kinanena re tai nap̃a awarpolo se poli. Ana Ntewa pagan la ke ne, a e kiena navisuena, naga pisu amiu ato manene laa metavan manu la nap̃ani, ana naga monar visuar amiu manene laa na wa taulu la. ");
INSERT INTO lww_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","?Asitom asape yar nap̃a naga sitom manene laa kiena malena naga kilia kila kiena malena nap̃a plas imi ve piavi li laa sane? ");
INSERT INTO lww_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Peraga, pe sa re nene po, komin nap̃a kam na tap̃atete akila narin sur tai ne sanene, po pon kam na ve asitom manene re sur tap̃ena lala e kiamiu malena. ");
INSERT INTO lww_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Asitomli meme tanea la ne pitotovi kar ke ga la ne. La na pe amiyum̃ae re poli, a pe asuluwo re m̃ala kulmrae la poli. Ana nevisa van amiu, p̃arin sup̃e Solomon nanua sumo, naga pe yar na sur moki a naga kiena sur make ga, ana m̃ana kulsota pe miyowau ruru re poli sane meme la nene. ");
INSERT INTO lww_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Meme la nene na legiena taaga ga, yoko peni ga na asikapi la, ana Ntewa sum̃a miyowauia ruru la pap̃isi. ?Ana asitom asape yoko tap̃atete Ntewa war kulsota van amiu? Peraga, kam na pe apiawa re nena m̃arera e naga poli. ");
INSERT INTO lww_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Komin sur ne la na nene, pe pon re sinemiu ulen manene sitomena, nap̃a asape ‘?Sanape na yoko tekinana, pona tomun suria, pona telual m̃ata kulsota?’ Pe pon re asitom manene sur la sanene poli. ");
INSERT INTO lww_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ee lelaga p̃a, yar make ga lala na purvanua kerkeviu na yomarava nini la asum̃a asitom manene sur la ne sanene silaga, ana amiu na, Arimamiu kilia pa rui sape yoko monar awar sur la nene. ");
INSERT INTO lww_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sur nap̃a asitom p̃esan ve keviu e kiamiu malena, naga navesup̃enena kiena ne Ntewa. A visae akila sanene, yoko naga la m̃ena sur tap̃ena la nene van amiu. ");
INSERT INTO lww_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Lelaga p̃a, kiau narin sipsip lala, Arimamiu sinenan manene pap̃isi sape tam̃an amiu aimi avesup̃en kiena yeririna lala, ana kam na tap̃atete sinemiu konan sur tai, yoko suri punu ga woga ga van amiu.” ");
INSERT INTO lww_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ana Yesu pisapenua “Po pon auliwilin plan kiamiu sur la nene, awar kana varu la va van la nap̃a limala korena vena aiila la. Visae akila sanene, sa nap̃a ap̃ar ke kiamiu pupia karo tai nap̃a m̃eke ma e peni, nap̃a tap̃atete viowa pogos tai, a akokonia ke kiamiu sur moki pap̃isi pito ke ea, nap̃a akilia awasinea, nap̃a yar navinauena tap̃atete si warlua vetan amiu, nap̃a kirara la tap̃atete si akila karea. ");
INSERT INTO lww_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Popon sane kam na kiamiu sur nowo la ve moki sanene su ma e peni, komin nap̃a yoko kiamiu sitomena lala sulue ga e yo nene nap̃a kiamiu sur nowo la sike ea.” ");
INSERT INTO lww_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ana Yesu pisa m̃ena pan la, pisape “Monar asu ruru silaga vena kiamiu Sup̃e imi m̃alivin amiu. Kam na monar ave sa yar na yum̃aena kiena ne yerkawa tai, nap̃a mligan la vena va e talopaena tai. A amiyowau ruruia, a asilan kiela kapi lala, asum̃alu ga asum̃a ga, ana pog ya nap̃a kiela yerkawa imi m̃alivin la, sigariga mratava, ana la asu ruru asike rui, akilia avietavan veraga. ");
INSERT INTO lww_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pupia navisa ruruena sike e yar la nap̃a amiyum̃ae sanene, pogos nap̃a kiela yerkawa pimi m̃alivin la, ana asum̃ate m̃a naga, atavilo ga asum̃a ga. Yokorena kiela yerkawa kekaran la vap̃isi, ana yoko naga va yowau, siraunia imi ana la aiilan ga nap̃a vio la vena atotano e kana lelen kinanena, naga piovion kala kinanena tanea nene. ");
INSERT INTO lww_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pe sur koren ga visae yemalo rui, pona pa ko yepelilika la ne, pona lavis lakaporo kokoreko, ana visae yerkawa nap̃ani imi lual kiena yeririna la atavilon ke sanene wa, p̃isi na naga kila wo manene laa van la sane wa. ");
INSERT INTO lww_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ana maran taaga sina ga, visae yar tai kilia ruru pogos nap̃a yoko yar na vinauena tai imi m̃ana, yoko yar nene tap̃atete ligan m̃ana yum̃a ana va koyo tai, ana naga monar su ruru ga sum̃ate m̃aga. ");
INSERT INTO lww_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ana visae sanene, kam m̃ena monar asururuia, asum̃ate nap̃a inu Narina ne Yeririna neim nom̃alivi, komin nap̃a yoko neim nom̃alivin amiu sina e pogos tai nap̃a pe yar tai kilia re poli, pona sitom ke sape yoko nowasup̃e inu ea.” ");
INSERT INTO lww_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ana Pita piun tan Yesu, pisape “?Sup̃e, p̃akaiwa nap̃a opisa ga na wa, opisa ga pan imimi imimi kiom̃a li nalologena lala, pona pe kien yaru make ga?” ");
INSERT INTO lww_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ana Yesu pe pisatam̃e ruru re poli, ana pisatam̃ea e p̃akaiwa tai. P̃akaiwa nena sanini “?Visae yar na yum̃aena tai, nap̃a naga pe manmarua ruru ea, a naga p̃uarar ruru yum̃aena nene, naga yum̃ae sanape? Visae kiena yerkawa ligan yo vena va perina, ana yerkawa nap̃ani ligan kiena yum̃aena lala se e limana. Ana yar nene naga visuar ruru yar na yum̃aena tap̃ena lala, yoko uarar ruru yum̃aena la nene. ");
INSERT INTO lww_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","A pogos nap̃a yerkawa wasup̃e sina, yoko lual sane yar na kiena yum̃aena nap̃ani, sum̃a p̃uarar ruru ke yum̃aena la nap̃a na wa. Ana e pogos nene, yar na yum̃aena nap̃ani kilia loge wo vap̃isi, ");
INSERT INTO lww_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","komin yoko yerkawa nap̃ani ligan make kiena sur la e limana ne. Ee, a yoko Ntewa m̃ena ga kila ve sa ke ga. ");
INSERT INTO lww_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Ana visae yar na yum̃aena nap̃ani yum̃ae viowa ga, ana pogos nap̃a kiena yerkawa mligan yo pa sike perina, yoko naga sitom visave ‘E, yerkawa nene pa sike gare piavi laa narui, pona ve imi re si yo.’ Ana yoko naga sum̃alu kila viowa va kiena yar na yum̃aena lala, pona sira na yum̃aena lala, a yoko naga sum̃a kinanan kilavaru kiena ne yerkawa nap̃ani, a va mun luen ga wii e legiena punu ga. ");
INSERT INTO lww_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ana yoko yerkawa nap̃ani wasup̃e sina e legiena tai nap̃a yar na yum̃aena nene ilan ga, e pogos tai nap̃a yar nene pe sitom re pisape yoko imi e poli. Ana yoko yerkawa nap̃ani la pupia nakoaena tai van yar nene, nap̃a yoko kila naga va sike e yo kiena ne p̃arm̃arera lala. ");
INSERT INTO lww_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Yar na yum̃aena nap̃a kilia ruru ya nap̃a kiena yerkawa sinenan pisape monar kila, ana siraunia naga pe kila re poli, yoko awe kare naga vap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A yar na yum̃aena nap̃a kila piowa sane popon awe kare naga, ana komin naga mninue ga, yoko tap̃atete awe manene naga. “Yar nap̃a Ntewa mla keviu pania, Ntewa sinenan pisape visu yaru nene yum̃ae ve keviu m̃ena amio. A yar nap̃a visae yar la amligan sur la moki se limana, yoko aviun ke sina sur ve moki vania va laa sane na wa.” ");
INSERT INTO lww_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ana Yesu pisape “In na nepimin nena nesape neligan kapi e yomarava nini, a popon manene visae kapi nene vivaga rui, ana pere wa. ");
INSERT INTO lww_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ana pupia yum̃aena tai sike vamon inu wa, vena in na monar neva nowarpoyo ea, a nanagane in na nakawean in manene ke vanon rui. Popon sur nene imi vilaga, vena nekilia nekila makea. ");
INSERT INTO lww_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","?Kam na asitom ke asape in na nepimin nekila sa nap̃a pupia sum̃are imi sike e yomarava? Peraga, in na pe nepimin re neligan sum̃are e poli, ana in na nepimin nekila p̃elaga na viap̃aena imi ve keviu. ");
INSERT INTO lww_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Siar nanagane, pona e um̃a tai, yar la lima asike ea, ana yoko la ve telu aviap̃a vetan la ve lua, pona la lua aviap̃a vetan la ve telu. ");
INSERT INTO lww_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yoko yar la asum̃a aviaviap̃a, nap̃a yoko m̃ee lala akawe arimala lala, arimala lala akawe narila m̃ee lala, a anela lala akawe narila sira m̃ee lala, a sira m̃ee lala akawe anela lala, a yoko anen simem lala yoko akawe sira la nap̃a atalopa amio narila na yerm̃ene lala, a yoko sira la nap̃ani akawe anela simem la nene.” ");
INSERT INTO lww_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ana Yesu pis sina ga pa p̃ina lala, pisape “Pogos nap̃a ita tevisu pupia malo m̃eke e yo nap̃a lagi molue ke kom ea, tekilia tesape p̃isi na yua wowo, a ve ve piavi re yoko yua nene imi. ");
INSERT INTO lww_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A pogos nap̃a visae teloge kieta lagi ura yui, nanene na tekilia tesape yepisusun vap̃isi ne, a yokorena monar ve sa ga nene narui. ");
INSERT INTO lww_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","?Nanene narui, nane asum̃a apisu kilale ke kile lala na sinapane a na yomarava nini narui, avisave yoko pogos ve sanape pona ve sanape, ana sanapen nap̃a pe apisu kilale re kiau kile la poli, na pupia pogos nanagane nap̃a nesike nemio amiu ea? ?Pona kam na yepemiu mavin ga visu kilaleen yo? Aulai, kam na apilaven manene laa kiamiu visen koren la nene pap̃isi wa. ");
INSERT INTO lww_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Popon kam akilali nap̃a akilia towe laa narui sane mrapa ya nap̃a mesmesun aliluia. ");
INSERT INTO lww_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Visae pogos tai oveveyun sur tai omio yar tai, ana naga sinenan pisape were ko ova osum̃alu ose marana ne yar nalip̃ereena, popon okilayonli nap̃a vena ovis ruru omio naga sumo wa, pogos nap̃a pe atol re kumali poli wa. Visae peraga, pona naga ligan ko e limana ne yerkawa na lip̃ereen yar yo, ana yerkawa nap̃ani pona naga ligan ko m̃ena ova e limana ne yar na taren yaru lala, a yaru na taren yar lala pona aligan ko e yum̃a nakoaena yo. ");
INSERT INTO lww_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Lelaga, nevisa van ko sanini, nesape visae sanene, yoko tap̃atete si omolue e yum̃a nakoaena, vano-o oul plan make kiom̃a nakoaena sumo wa, p̃isi na okilia omolue sina.” “Ana visena nini pe lelaga e kiamiu malena na yomarava nini, a pe lelaga m̃ena e lepas na pun amiu amio Ntewa.” ");
INSERT INTO lww_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ana yeririna lap̃as nap̃a asike e pogos nene, la asunyu pa Yesu e lepas kiena ne le Kalele lap̃asia, nap̃a yerkawa nae Rom nap̃a P̃aelat kila p̃elaga piowa tai pan la. Apisape “La nene, asike e Yum̃a Wa m̃ana ne Ntewa, ana pogos nena nap̃a amlotun ke Ntewa akila kup̃ap̃aena pania, P̃aelat la apim amial mom̃ar la. A la ap̃alelar kuruta kan la nene amio kuruta na kup̃ap̃aena nene nap̃a la asum̃a akila ke ne.” Ana pogos nap̃a apisa sur nene pa Yesu, la asitom pa rui asape sur viowa nene nap̃a pimi m̃alivin la nene, pona nakoaena kiena ne Ntewa tai nene yo komin kiela sur viowa lap̃as nap̃a akila. ");
INSERT INTO lww_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ana Yesu pisatam̃e la, pisape “?Kam na apisu le Kalele la nap̃a kiela marena piowa sanene, asitom sanape? ?Pona kam na asitom ke asape la nene na ape yar viowa la lala, taulu le Kalele tap̃ena lala, pona kiela nakoaena ga? ");
INSERT INTO lww_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","In na sineun nesape nevisa van amiu nevisave peraga, pe sa re nene poli. Ana kam na monar avisuar ruruia, komin visae ve avilopu amiu re, yoko kam m̃ena amare e p̃elaga tai ve sa ke nene. ");
INSERT INTO lww_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","A kam na asitomiyuli m̃ena yum̃a na kirakiravaena nap̃a m̃eke e pulkumali nap̃a Siloam. Naga mon manene metava pap̃isi, ana poglis nanua mloru ne, ana kowar yar lala, la lualima taaga pa orelu 18 amare. ?Sanapen la nene? ?Pona kam na asitom ke asape la m̃ena apiowa laa taulu le Yerusalem tap̃ena lala, pona nanene na sane kiela nakoaena ga ne? ");
INSERT INTO lww_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ana peraga, naga m̃ena pe sa re nene poli. Ana in na nevisa si van amiu, kam na monar avisuar ruru amiu, komin visae ve avilopu amiu re, yoko kam m̃ena amare ke ga e p̃elaga tai ve sa nene.” ");
INSERT INTO lww_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ana Yesu pisa sina p̃akaiwa tai, nap̃a pisa sanini, pisape “Yar tai, kana purpiliva tai kapuru sike e kana lokove. Ana pogos tai yar nap̃ani pimin purlaki nena, sinenan pisape visulia p̃ar m̃a mrasa pona peraga. Ana pimi pisulia, m̃al purlaki nap̃a pe p̃ar re nena mras poli. ");
INSERT INTO lww_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ana pis pa yar nap̃a pisuar ke kana lokove, pisape ‘Nanagane tol kas telu narui nap̃a nepimin nakale mras nen purpiliva nini, ana peraga. Sineu maren rui, naga mono korenan ke ga yo wo nene, yoko otelua ga vano.’ ");
INSERT INTO lww_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ana yar nene sinen miye purpiliva nap̃ani, pisa pa kiena yerkawa, pisape ‘Visae sanene, yoko teliganli mon m̃a tol si kas ve taaga. Yoko nekilayonli nap̃a nekila ruru sumo, yoko nekilvivi purp̃esa, a yoko nokoven sin puluk lap̃as va ea vena kila kapur wo. ");
INSERT INTO lww_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ana visae kapur wo, war towe m̃a mras lap̃as e kas na sirau, yoko kilia sum̃a ga sanene, ana visae peraga, naga narui yoko otelua ga na wa.’” Ana p̃akaiwa nene pisayu ke sape narin pulmas teke ga wa nap̃a yaru la akilia avilon la, visae peraga, yoko Ntewa la nakoaena van la. ");
INSERT INTO lww_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ana e Legiena Wa tai, Yesu sum̃a pian ke yeririna lala loyum̃a e kiela yum̃a na leniena. ");
INSERT INTO lww_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ana e yo nene, sira marua tai sum̃a ea, nap̃a ninuna na maiena viowa sike ea. Ana ninuna nene kila naga pa tol kas lualima taaga pa orelu 18 rui, kila m̃asina ne sira nene pulu nena pap̃isi, naga sum̃alu mesmes p̃ele sina. ");
INSERT INTO lww_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ana pogos nap̃a Yesu pisuia, pio pimi, pisa pania, pisape “Sira marua, nevisa sanini, nevisave ko, inanena nap̃a piar ko ke ne, ligan ko ga nanagane.” ");
INSERT INTO lww_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A Yesu mligan limana tea amio visena nene, ana m̃asina pimi po ruru veraga e nena e pog nap̃ani, ana sira nap̃ani mloge po pap̃isi, mieluar Ntewa. ");
INSERT INTO lww_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ana nasumonen na yum̃a na leniena nap̃ani sinen kar Yesu vanon nap̃a kila ruru sira nap̃a e Legiena Wa. Ana pis pa yeririna lala, pisape “Sa nap̃a tekilia rui, tekilia teyum̃ae e legiena ve orai, a legiena ve taaga ve teyum̃ae re. Visae sinemiun nap̃a akila plan maiena vetan amiu, popon aimi e legiena orai la nene, ana Legiena Wa na sa nini pe pe kana pogos re nene poli.” ");
INSERT INTO lww_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ana Sup̃e pisatam̃ea, pisape “?Sanape? ?Pona akepu ke kiamiu puluk la e Legiena Wa yo, pona pe akila re poli? ?Pona apagan ke kiamiu sur mal lala, pona amla wii pan la e Legiena Wa yo, pona pe akila re poli? ?Ana vanon ya ne kam na pe akekaran re nap̃a nekila suri wo e sira marua nene? !Kam na ape yar navilavenen ga vis korenena nene! ");
INSERT INTO lww_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Sira marua nini, naga vineta tai nap̃a ita punu ga tomolue e lus kiena ne Epraam, ana Yermare Lego piar manene panon inanena nene m̃ene kas lualima taaga pa orelu rui. Ana in na nepisu sane Legiena Wa naga torokin ga nap̃a tourelua naga e yo viowa nap̃a naga sike ea.” ");
INSERT INTO lww_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","A pogos nap̃a Yesu pisa visena nene, kila kiena nasinekar la nap̃ani amloge amawa pap̃isi e marana ne yeririna lala. Ana yar tap̃ena lala, la amloge akekara pap̃isi e yum̃aena nam̃areraena wo la nap̃a Yesu kila pan la. ");
INSERT INTO lww_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ana Yesu pisa ke sina ga, pisape “?Yoko nevisa visena ya ne van amiu vena kila na akilia sane nasup̃enena kiena ne Ntewa naga sanape? Yoko nevisave nasup̃enena nene naga sane sur ya? ");
INSERT INTO lww_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yoko nekilali nap̃a nekila merarava van amiu e p̃akaiwa nini, nap̃a pisape: Nasup̃enena nene, naga sane kurus nen mrapa nap̃a mloru pito pelan te laki tai. Kurus nene na ve tokak pap̃isi, ana pogos nap̃a kapuru, pimi pe purlaki tai nap̃a keviu manene laa, ana manu la akila m̃ala ponovi lala e kana korowas lala.” ");
INSERT INTO lww_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ana Yesu pisa sina p̃akaiwa tap̃ena pan la, pisape “?Pona nevisave nasup̃enena kiena ne Ntewa sa si ya narui? ");
INSERT INTO lww_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nasup̃enena nene, naga sane sira tai p̃alelar is amio yavi na kilaparavi pa e pupia pialora tai, ana narin is nap̃ani kila kilaparavi la punu nene mlapa.” ");
INSERT INTO lww_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ana Yesu mla si kiena mrapa, sinenan pisape va ma Yerusalem. Ana pogos nap̃a pa sane, pa kome pulkumali lala, sum̃a pian ke yeririna lala. ");
INSERT INTO lww_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ana yar tai piun tania, pisape “?Sup̃e, la nap̃a yoko atol malena la moki, pona pe la moki manene re poli?” ");
INSERT INTO lww_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ana Yesu pisatam̃e la, pisape “Monar akilayonli nap̃a ava loyum̃a e pulutava tap̃ena nene, nap̃a ve tokak la ga. Nepisa ke lelaga na pan amiu ne, nesape yoko yar la ve moki nap̃a sinelan asape ava loyum̃a, ana yoko tap̃atete akila. ");
INSERT INTO lww_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nanene komin nap̃a siraunia, yoko yerkawa na yum̃a, naga visu sane toroki rui, ana yoko naga sum̃alu, kotava ruru sina. E pogos nene, yoko kam ve moki nap̃a aim awon amiu ase mratava nene, asigar ga avio, avisave ‘Sup̃e-o, awis ovietavan imimi!’ Ana yoko yerkawa nap̃ani visatam̃e ga sanini visave ‘Peraga o, nemninue amiu nena ga! Kam na yer pe la nene?’ ");
INSERT INTO lww_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ana yoko akilali nap̃a avisa van e pogos nene, avisave ‘?Ana sanape, ko na pe ositom̃al re si nap̃a osape ita ke narui nanua tesum̃a tekinan ke lele taaga ne? Imimi ke narui nap̃a opam opian imimi ke e yometava la nene e kiamimi pulkumali lala?’ ");
INSERT INTO lww_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ana yoko naga visa van la, visave ‘In na nepisa pan amiu yam tai rui, nesape nemninue amiu nena ga, nesape kam na yer pe la nene. Nekilia nesape kam la nene kam na yar na kilaen ga p̃elaga viowa lala. !Pogaga, kam na aure matan inu nagane!’ ");
INSERT INTO lww_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","E pogos nene, yoko kam na aloge viowa vap̃isi, yoko atag vano-o p̃isa, asum̃a akar maluemiu. Nanene komin nap̃a yoko kam na avisu yeririna wo lala kiena ne Ntewa, nap̃a sane Epraam, Aisak, Sekop, a navisawalen tap̃ena m̃ena ga lala, la asu ruru ga asike loyum̃a e kiena nasup̃enena ana kam na akoven amiu asum̃alu asum̃a ga vanua sanene. ");
INSERT INTO lww_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","“E pogos nene, yoko yeririna tap̃ena la ve moki nap̃a amolue e mrapun yomarava varoka, aimi atotano vena akinana e pupia p̃ap̃agena loyum̃a e navesup̃enena kiena ne Ntewa, ana kam na tap̃atete ava loyum̃a.” ");
INSERT INTO lww_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ana Yesu pisa make kiena visena e pogos nene, pisape “Ana yar la nap̃a asirau, p̃isi na la asumo, a la nap̃a asumo, p̃isi na la asirau.” ");
INSERT INTO lww_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ana e pogos nene nap̃a Yesu pa ke ma Yerusalem wa, Varasi lap̃as apim puna, apisawal pania, apisape “Pona ko pe okilia re poli yo, nap̃a P̃arin Sup̃e Erot, naga pisaar rui pisape yoko wem̃ar ko. Popon oure ova gar Yutea sumo wa, komin naga pisuar ke lepas nini.” ");
INSERT INTO lww_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ana Yesu pisatam̃e la, pisape “In na pe nesitom re kawe nene nesape naga pe yar tai nap̃a kilia kila sur tai van inu poli. Yoko ava avisawal e marana, avisave in na nekila ke ne kiau yum̃aena sumo wa. Avisa vania avisave in na nom̃ene plan ke yermare lala, a nekila ruru ke namaiena lala, a yoko neyum̃ae ve sanene p̃ane, amio peni, amio m̃ena vewo, vano-o nevisu sane nekila make nenaga. ");
INSERT INTO lww_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ana nekilia nevisa van amiu, sane ve asitom manene in re, komin nap̃a e ke e legiena la nene narui, in na nomolue nepa ke sanene narui. Monar neva netol ke ne yo ma Yerusalem wa, komin nap̃a nepisu sane siar nanua sumo yar la am̃e mom̃ar kiena navisawalena lala e ke e yo nena nene narui.” ");
INSERT INTO lww_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ana e pogos nene, Yesu sitom manene Yerusalem pano-o taginia, pisape “Yerusalem o! Komin ya ne om̃e mom̃ar ke navisawalena lala, a okove mom̃ar ke yar la nap̃a Ntewa mligan la pimi pan ko? Yam mok liu nap̃a sineun nesape neligan lum̃au yervivi kiom̃a yeririna lala, sa nap̃a lakaporo mligan narina lala apim atapolou vatanon kupena, ana kiom̃a yeririna lala pe akekaran re poli. ");
INSERT INTO lww_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ana opisu ke ne, Ntewa pilon ke m̃asina pan ko narui, ana naga pitetalia inu nepim p̃es e nini, ana nevisa van ko, nesape yoko kiom̃a yeririna lala tap̃atete si alual inu, vano-o tol pogos nap̃a avisu kilale inu, avisayu inu, avisave ‘!Ntewa na mava, ovisa ruru naga nap̃a pimi e kiom̃a kia!’” ");
INSERT INTO lww_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ana e Legiena Wa tai, nasumonena tai kiena ne Varasi lala p̃ere Yesu pa kinan m̃ana. Ana yar tap̃ena m̃ena la p̃asia asike e pogos nene, nap̃a pe sinelan re Yesu poli, la asum̃a apisusu naga visae kila sur tai nap̃a ve mesmes re, la akilia akila sur tai vania. ");
INSERT INTO lww_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ana yar namaiena tai sike loyum̃a amio la e pogos nene, nap̃a yar nena yepena la sirorop pap̃isi. Ana Yesu pisu yar nene, ");
INSERT INTO lww_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ana pis pa navianena navisaluaena lala, piun tan la pisape “?Sanape e lepas na kieta navisaluaena? ?Pisape tekilia tekila ruru maiena e Legiena Wa, pona pisalup̃ar pisape ve tekila ruru re?” ");
INSERT INTO lww_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ana pogos nap̃a Yesu piun naviunena nene, apisu sane tap̃atete avisatam̃ea, atopur nenaga. Ana Yesu p̃ere yar nap̃ani pimi lavis puna, kila ruru sina, ana pisape kilia wasup̃e si va ga um̃a. ");
INSERT INTO lww_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ana naga pis pa la nap̃a asike ne, pisape “Kam na asitomyulia. Visae kam yar tai nene, e Legiena Wa tai, narina tai pona kiena sur mali tai va loru vito e p̃ilip̃ili na wii tai, ana yoko okila ve sanape? ?Yoko ovitap̃ilin ne, nap̃a ova ga ourelua si ne, pona ovisave: Ke, piowa narui e, nagane na Legiena Wa nini narui, navisaluaena pisape ve neyum̃ae re e Legiena Wa, ana pona naruu pona kiau sur mali nene mon m̃a e p̃ilip̃ili wa, neva ga nourelua peni? Peraga, pona yoko ovitap̃ilin ga ourelua yo.” ");
INSERT INTO lww_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ana la amninue kare narui am̃a yoko avisatam̃e si naga e lepas nene ve sanape, la asupur ga asike na. ");
INSERT INTO lww_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ana pogos nap̃a apim asun ke nap̃a atotano e kinanena nene, Yesu pisu kilale nap̃a la tap̃ena lap̃as nap̃a p̃ar na p̃ap̃agena pio la apimi, sinelan manene alual yo tai nap̃a po, la apa atowo lelen yerkawa la metava. Ana Yesu pisu kiela p̃elaga navilaveena la nene, ana pisa pan la pisape ");
INSERT INTO lww_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Visae pogos tai avio kon ova e kinanena natalopaena tai, pona sur tai sane p̃ap̃agena, ana pe pon re ovitap̃ilin nap̃a ova oto nena tano e lelen yerkawa la poli. Pona yo nene akila ruru monm̃ate ke pupia yerkawa tai yo, ana pe okilia re poli, ");
INSERT INTO lww_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ana yoko p̃ar na p̃ap̃agena imi visa van ko, visave ‘Ake wolai, pe sineyeena pap̃isi, ana yoko otom ke ne tano wa, komin nap̃a oteke e lelen kiau yerkawa nam̃a.’ Ana yoko omawa ologe viowa vap̃isi, ana yoko monar oto si tano, okilali nap̃a olual narin pulmas tai tano vena okilia olawan maram̃a ea. ");
INSERT INTO lww_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Ana p̃elaga wo na sanini, visae avio ko ova e kinanena tai, pogos nap̃a om̃alivi ea, yoko ova oto ga tano omio yar kar ga lala. Ana visae p̃ar na p̃ap̃agena vim visu ko, visave ‘E, yerkawa, nepisuar ruru lelem̃a teke meta ma e ne rui. Yoko ita lua tevavini, neligan ruru ko otea.’ Ana e pogos nene, okilia ologe wo vap̃isi, nap̃a p̃ar na p̃ap̃agena pisirlua ko sanene e maran yeririna tap̃ena la nap̃a akinan ke lele taaga. ");
INSERT INTO lww_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Naga sanene narui, sane yar nap̃a naga ga pisirlua naga, yoko aligan naga mon tano, ana yaru nap̃a mligan naga mon tano, yoko avisirlua naga.” ");
INSERT INTO lww_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ana e pogos nene, Yesu pisa m̃ena visena tai pa yar nap̃a pio naga pimi kinan m̃ana, pisa pania, pisape “Nagane, tepisu pogos nap̃a visae yar la akila kinanena tai, la sinelan ga avio kiela erau wo lala, pona kiela wolai lala, pona kiela namratava tap̃ena lala, amio m̃ena pupia yerkawa la nap̃a asike lavisin la. Akila ke sanene, komin akilia ke asape visae siraunia, visae la m̃ena akila kinanena pogos tai, yoko monar akila maran sina van la. ");
INSERT INTO lww_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ana p̃elaga wo na kilaen e p̃ap̃agena naga pe sa re nene poli. Popon manene ovio yar tap̃ena lala, sane la nap̃a limala korena ga, a la nap̃a tasnela la pioyowa ga, pona laulu lala, pona kilamara p̃ala lala, yar la ne sanene, la aim akinana amio ko. ");
INSERT INTO lww_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yar sur la ne sanene la tap̃atete akilamaran si van ko pogos tai, ana pogos nap̃a Ntewa pisu nap̃a okekaran opure la nene apim akinana mom̃a, yoko naga kekara vap̃isi. Yoko naga visa ruru ko, a yoko owar kiom̃a nalaena wo vanonia, nanene e pogos nap̃a naga kila kiena yeririna mesmes lala amal si vetan marena.” ");
INSERT INTO lww_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ana yar tai tom̃a e kinanena nene, naga mloge m̃a nap̃a Yesu pisayu ke pisape yoko Ntewa visir plan kiena yar mesmes lala e legiena maro, ana naga pisape “!Lelaga nap̃ane, yoko wo manene laa van ita e pogos nene, nap̃a ita tesikol ita e pupia p̃ap̃agena nene loyum̃a e nasup̃enena kiena ne Ntewa!” ");
INSERT INTO lww_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yar nene pona naga sitom ke sape naga po narui, ana yar la na sanene la sinelan re vaen loyum̃a poli, ana Yesu pisa p̃akaiwa tai e lepas nene, nap̃a sanini “Yerkawa tai, naga sinenan pisape kila pupia kinanena tai, ana pio yar la moki nap̃a aimi. ");
INSERT INTO lww_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ana pogos nap̃a kila ruru make sur punu ga p̃isi, naga pitetalia kiena yar tai vena vanon were la nap̃a apio la p̃isi rui aimi. ");
INSERT INTO lww_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ana pogos nap̃a kana yar nena pimi m̃alivin la, la make ga nene maran taaga asum̃a akila ke sina ga visena na visawoen suria. Tai pisa sanini, pisape ‘Pogaga, ana in na nopul ga kiau narin porotano tai na wa, ana nepavin ke nesape nevisulia am̃a porotano nena sanape wa. Yoko ovisa va yerkawa ovisave pe nasineyeena pap̃isi ana tap̃atete neim̃as nanagane.’ ");
INSERT INTO lww_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","A tap̃ena, pisa sanini pisape ‘Pogaga, ana in na nopul ga kiau puluk lap̃as na wa, vena ureen kiau kat lala, ana nesape neva nevisu la lia am̃a am̃arera ruru m̃aga. Yoko ovisa va yerkawa ovisave pe nasineyeena pap̃isi, ana in na tap̃atete neim̃as nanagane.’ ");
INSERT INTO lww_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","A tap̃ena m̃ena ga, naga pisape ‘Pogaga, ana in na nekila ga p̃ap̃agena na kiau talopaena nanua ga nagane, ana in na nepisu sane tap̃atete neim̃as yo, komin sur moki pap̃isi.’ ");
INSERT INTO lww_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ana yar nap̃ani pimi pisawal visena la nap̃ani pan kiena yerkawa, mloge, sinen kar la. Ana naga pitetalia sina kiena yar nap̃ani, pisape ‘Pogaga, oyal kawa, ova e narin mrapa la ne lavis ga nam̃a, ova olual la nap̃a pe kiela sur re poli, amio la nap̃a tasnela la pioyowa ga, amio laulu lala, amio kilamara kata lala, ana owere la nene aimi e kieta p̃ap̃agena.’ ");
INSERT INTO lww_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ana naga pa kila, ana siraunia p̃asup̃e si pimi pun kiena yerkawa, pisape ‘Sup̃e, sur nap̃a opisa p̃a, nekila rui, a yaru moki apimi, ana yepa keviu m̃eke ga wa.’ ");
INSERT INTO lww_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ana pitetalia ke sina ga, pisape ‘Visae sanene, ova sina, ova kare ga yo um̃a la e pulkumali, a om̃areran kare ga va yar nap̃a visae olualia, ovisave monar aimi, vena akokonia kiau kove, vena akila p̃ap̃agena nini imi wo. ");
INSERT INTO lww_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tap̃ena la nap̃a akila ke navisawoen viowa lala, in na nepio ruru la nesape aim e p̃ap̃agena nini p̃a rui, ana nanagane, yoko tap̃atete nena lala yaru tai kan re narin kinakinas nen kinanena tai e p̃ap̃agena nini p̃isa, peraga. !Nepisa ruru ga ne!’” ");
INSERT INTO lww_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ana Yesu mla sina kiena mrapa, pa ke meta ma Yerusalem na wa, a pupia p̃ina moki la ataveveia. Amiyal m̃a pano-o, pilopu naga kira pimi pula, pisa pan la pisape ");
INSERT INTO lww_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yar nap̃a sitom sape taveve inu, naga monar ligan inu neto nena sumo e kiena malena, in na neto manene laa metavan arimana, pona anena, pona wona, pona narina, pona wenla, pona vinena. Yar nap̃a pe pisu kilale re kiena malena sane naga pe pe sur re tai poli, naga pe torokin re nena nap̃a imi sane kiau nalogena poli. ");
INSERT INTO lww_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ana yar nap̃a sinenan sape imi ve kiau nalogena, naga monar kila sanini. Monar kus kiena lak torovia, taveve inu lue ga, sa nap̃a kilia tam̃an naga loge viowa vanon inu. ");
INSERT INTO lww_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Po pon asitom ruru ke ne sur nene sumo wa, p̃isi na avitap̃ilin visena, avisave sinemiun ataveve inu. “Nanene naga sa ga nap̃a yaru tai, visae sitom ke sape kilia kila pupia yum̃a tai, naga monar totano, visu ruru ke ne sumo wa, wolo ruru kiena kilavaru nakilaen yum̃aena nene, naga monar visu kilale sane yoko naga torokin kilia kila make pupia yum̃aena nene, pona pe torokin re poli. ");
INSERT INTO lww_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Visae peraga, yoko naga siaria, yum̃aen ruru p̃eren yum̃a nena, va laa sane, yoko ilan ga nap̃a limana ve plas ruru nena ga ana yoko yum̃aena nene loru m̃eke na. Ana pogos nap̃a yar tap̃ena la aimi avisu yum̃a nap̃a komp̃as m̃eke na amio kana lepas ne lala, a pe m̃aero pa re e poli wa, yoko avitalia kare yar nene narui, yoko avisave ");
INSERT INTO lww_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Ke, yar nene, kiena sitomena po pap̃isi. Sinenan sape yum̃aen m̃ana yum̃a, ana pe maplar ruru re kiena yum̃aena po, ana tap̃atete nena kila makea.’ ");
INSERT INTO lww_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“A yar nap̃a sinenan sape visaar nap̃a yoko imi kila yum̃aena amio inu, naga monar kila sane p̃arin sup̃e tai, nap̃a yerkawa tap̃ena sum̃alunia, p̃ere kiena pupia p̃egas nen nakilaen mara tai aim akila mara vania. Li namara kiena ne p̃arin sup̃e nene pe la moki re poli sane yerkawa nene, ana p̃arin sup̃e nene monar visu ruru sumo, monar sitom ruruia, sane naga kilia taulu pupia p̃egas nap̃a pimi ke ne, pona tap̃atete tauluia. ");
INSERT INTO lww_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Visae visu sane tap̃atete kilia kila, naga monar ligan visena vano va yerkawa, pogos nap̃a sike perina wa. Naga monar viun tania, visave yoko ul ya nap̃a yerkawa nene pisa, vena lalua asu sina e sum̃are. Visae ve sanene, naga monar vatanon yerkawa, tam̃an make nena naga vania. ");
INSERT INTO lww_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ana kam nap̃a sinemiun asape aim ataveve inu, monar avisu kilale sane kam m̃ena monar akila ve sanene van inu. Yar nap̃a pe tam̃an re kiena malena poli, amio make kiena sur van inu, naga tap̃atete kilia imi sane kiau nalogena.” ");
INSERT INTO lww_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ana Yesu pisa sina p̃akaiwa tap̃ena pan la, pisape “Sive naga pe sur tai nap̃a po pap̃isi, ana visae pogos tai sive nene ve melkalka ruru re sina, tap̃atete kila kiena yum̃aena naapo, a tap̃atete si sur tai kilia kila imi melkalka ruru sina. ");
INSERT INTO lww_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A sive na sanene, tap̃atete si kilia kila yum̃aena wo tap̃ena tai van ko mom̃a um̃a, pona van m̃ena kom̃a lokove. Sur nene naga pe na kovenen ga va e kororak narui. “Naga ke nene narui naga pe kiau totou na kiau nalogena nap̃a kilalu kiena nam̃areraena nakilaen kiau yum̃aena. Ana yar nap̃a kiligana teke ea, popon naga loge kilale kiau visena nene.” ");
INSERT INTO lww_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ana e pogos la ne sanene, apisu sane yar lap̃as nap̃a yar la pe asitom la re poli, sane yar na takis lala, amio yar tap̃ena la nap̃a Varasi la asape la apiowa ga, la m̃ena apim ke lavisin Yesu vena ayagogonia. ");
INSERT INTO lww_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ana pogos nap̃a Varasi lala amio navianen navisaluaena lala apisu nap̃a Yesu sinenan pisape sun amio la nene, apisu sane piowa ga, ana asum̃a apisa ke apisape “Lelaga kemua nap̃ane, yar nene naga sitom ga li namlamulen viowa la ne sanene, a silaga sinenan m̃ena sape va kinan lele taaga amio la. ?Pona naga pisu sane la ga kiela p̃elaga po yo, a ita na kieta piowa ga?” ");
INSERT INTO lww_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ana la kiela sitomena sane kila Yesu sun pan la e p̃akaiwa la nap̃a pisayu sanape nap̃a naga pimi e yomarava nini vanon yar nap̃a kilalu mrapa. ");
INSERT INTO lww_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","P̃akaiwa p̃esa kiena ne Yesu e lepas nene naga sanini, nap̃a pisa pan la, pisape “Yar tai, naga pe yar na vaganen sipsip, ana kiena sipsip lala tol ponotia taaga 100. Kiena sipsip la moki sanene narui, ana visae pogos tai tai va kovio, yoko naga sitom korenan ga, pona naga sitom vap̃isi? Yoko naga monar ligan kiena sipsip tap̃ena lala asum̃a ga sanene wa, ana naga vanon nap̃a kovio, kale m̃a vano-o lualia. ");
INSERT INTO lww_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A pogos nap̃a lualia, kekaran vap̃isi, yoko kuslua sipsip nap̃ani va e purkaunena, kus wasup̃e imi. ");
INSERT INTO lww_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ana siraunia, pogos nap̃a p̃asup̃e si pitomi tano um̃a, yoko vio namratava la puna pona kiena erau tap̃ena lala vena aimi. Ana naga sunyu van la, visave ‘Aulai, sur tai nini nap̃a ita tekilia teloge won vap̃isi. Kiau sipsip tai nap̃a pa kovio na kovio lue, ana yoko nepanonia, nepa nakale m̃a pano-o, nom̃alia. !Pogos nap̃a nom̃alia, nekekara na nekekara!’” ");
INSERT INTO lww_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ana Yesu pisa meraravan pa Varasi lala, pisape “Ana yoko ve sa ke m̃ena nene ma e peni. Yar mok liu nap̃a asike e yomarava nini nap̃a sane amiu, la asitom ke asape la na apogaga narui, ana asape ma e peni amloge ke pon amiu la ne sanene yo? Ana pogos nap̃a visae yar namlamulen viowa ve taaga ga, naga vilopu kiena malena, yoko pupia kekaren vap̃isi vania ma e peni, nap̃a va ve keviu re laa sane na wa. Suri ne nanene kila narui inu na nekekaran sunen nemio yar la nap̃a kam na pe akekaran la re poli.” ");
INSERT INTO lww_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ana Yesu pisa si p̃akaiwa tai e lepas nene, pisape “Sira tai, naga kiena kururu varu lualima, nap̃a mlawan ruru teke e m̃ana loyum̃a. Ana visae pogos tai, naga wasup̃e imi m̃al tai nap̃a mloru rui, teke ko yo, yoko naga kila ve sanape narui? Yoko war kapi vivaga, war plan make kiena suri lala, yevan ruru m̃ana loyum̃a vano vano lualia. ");
INSERT INTO lww_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ana pogos na lualia, yoko vio namratava la puna, pona kiena erau tap̃ena lala, vena aimi. Ana yoko naga sunyu van la, visave ‘Aulai, sur tai nini nap̃a tekilia teloge won vap̃isi. Kiau pupia kilavaru tai nekilaluia pa kovio nenaga, ana siraunia, nakale m̃a pano-o, nom̃alia. Pogos nap̃a nom̃alia, nekekaran pano-o p̃isa!’” ");
INSERT INTO lww_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ana Yesu pisa meraravan pa Varasi lala, pisape “Ana yoko ve sa m̃ena nene ma e peni. Visae yar na mlamulen viowa ga tai, naga vilon kiena malena, yoko navisi kiena ne Ntewa lala avisu nap̃a pupia kekarena pap̃isi ma e peni.” ");
INSERT INTO lww_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ana p̃akaiwa maro kiena ne Yesu e lepas nene sanini, nap̃a pisape “Yaru tai, narina na yerm̃ene lua, nap̃a lalua amiyum̃ae ke amio naga e kiela porotano. ");
INSERT INTO lww_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ana pogos tai, prasmaro na lalua nene sum̃alu, pisawal pa arimala, pisape ‘Ata, in na sineun nesape nowar kiau kilavaru komp̃asa nap̃a na lalumom̃a nagane ga ne.’ “Ana sur nene pe mesmesun re nena nap̃a naga viun sanene poli, komin arimana mali sike ga wa, ana arimana pe pis re poli, mlip̃ere make kiena suria, tam̃an komp̃as pa prasmaro nene, a komp̃as pa m̃earu. ");
INSERT INTO lww_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A yokorena yar m̃ee nap̃ani sum̃a p̃iliwilin plan make sur la nap̃a arimana p̃ar pania, ana siraunia pe piavi re poli, am̃a ga naga kon make kiena sur lala, p̃ar kiena kilavaru pion pano. Ana naga pa sike e purvanua tap̃ena tai koperin pap̃isi, ana e yo nap̃ani, naga pa make nenaga e p̃elaga viowa lala, kan kilavaru nap̃ane pano-o, kila kare make punu nenaga. ");
INSERT INTO lww_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Ana naga kilia ruru sane limana plas ruru ga na wa, a e legiena nene, pupia viso pimi tol purvanua nap̃a naga sike ea, mligan yar m̃ee nap̃ani sike e yo tai nap̃a m̃arera pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ana pa kale yum̃aena tai nap̃a pona naga kilia yum̃aen vena tamalia kiena malena, ana pa miyum̃ae kiena ne yerkawa tai e yo nene, pagan kiena nompui lala. Yar m̃ee nap̃ani, naga pe mesmesun re kila yum̃aena nene poli, komin naga palia nompui sane ita le Yu la, ana yum̃aena taaga ga nene nap̃a naga kilia m̃alia. ");
INSERT INTO lww_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","“Ana miyum̃ae m̃a sanene pano-o, ana pe amla re kinanena pan poli, a pe m̃al re mrapa na lualen kinanen poli, kila naga visokar luen ga. Naga visokar m̃a sanene pano-o sinenan sape suan limana vito e karo na kinakinas nen kinanena ka nompui la nap̃a komp̃as pililua rui sike ea, amio purkavila na kona la nap̃a kiena yerkawa ponpolo sum̃a ga vena kiena nompui la akania. ");
INSERT INTO lww_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ana pogos nap̃a naga sinenan ke sape kila sanene, naga ga pisu kilale si naga narui, pisu kilale nap̃a kiena p̃arm̃arera ga kila kare manene si naga. Ana sitom̃al si arimana amio m̃ana um̃a, pisape ‘Lelaga kemua nap̃ane, in na nepe wowe pap̃isi. Kiau p̃arm̃arera ga nane kila nesike viso karm̃arin ke e yo nini. Ositomyu la nap̃a sane ape yar na yum̃aena kiena ne ata. Naga p̃ar ke kinanena moki pan la e legiena punu ga, nap̃a yoko akan make p̃ele ga. ");
INSERT INTO lww_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Sanene, popon nowasup̃eli in ga narui, neyum̃ae re ve sa la nene. Yoko neva nevisu ata, nevisa sanini vania nevisave: O Ata, in na nekila pupia mlamulen piowa pa Ntewa, a pan ko m̃ena ga. ");
INSERT INTO lww_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nanagane, pe popon re si nap̃a ovisu inu sane nepe narum̃a tai poli, ana nesape neviun tan ko vena sinem̃a ye inu, otam̃an inu neyum̃ae re ga sane lala yar tai nap̃a miyum̃ae kiom̃a ke ne.’ ");
INSERT INTO lww_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Ana naga kila ruru kiena sitomena sanene, ana sum̃alu, pimi lelei m̃a pimi p̃asup̃e si pu arimana. “Naga pe kilia re poli, ana arimana sitom̃al luen ga naga silaga, sum̃a kirakira ke mrapa sape pona naga imi. Ana pogos nap̃a sike perinan um̃a wa, ana arimana pisu kilalea, sinen miye pap̃isi, ana kiriri pa pitawea. Ana pogos nap̃a pimi puna narina nap̃ani, kutararia e limana luwoka yepen mavin liganen sina. ");
INSERT INTO lww_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ana yar m̃ee nene pisa pa arimana narui, pisape ‘O Ata, in na nekila pupia mlamulena piowa pap̃isi pa Ntewa, a pan ko m̃ena ga. Nanagane, pe mesmesun re si ovisu inu sane narum̃a tai poli.’ ");
INSERT INTO lww_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ana arimana pisalup̃aria, pio kiena yaru na yum̃aena lala, pisape ‘E, ava vilaga, ava awar kulsota tai nap̃a po, amio kana kulus nen lana, a kana rig nena, sur la ne sanene, awar imi ayen ea. ");
INSERT INTO lww_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","A narin puluk nap̃a apagan mlapa po ne, ava awem̃aria, tekila kinanena tai takania vena tekekara temio prasmaro nini. ");
INSERT INTO lww_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Komin naruu nini naga mare rui, ana nagane mali sina, naga kovio, nanagane tom̃al sina.’ Ana pe yam piavi re poli, la asum̃a akila ke p̃ap̃agena na yar m̃ee nene narui. ");
INSERT INTO lww_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ana e pogos nene, narina na m̃earu naga mialoro pa miyum̃ae ke kana lokove rui, ana siraunia pitomi si um̃a. Ana pogos nap̃a pitomi ke lavisin um̃a, mloge yauena a mloge m̃ena m̃aagena na wolena kapur pa m̃eke na. ");
INSERT INTO lww_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ana naga pisu yar na yum̃aena la tai, piun tania, pisape ‘?Ei, ya ne akila ke garo um̃a sanene?’ ");
INSERT INTO lww_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ana yaru nap̃a pisa pania pisape ‘!E, womla nap̃ani, naga p̃asup̃e si rui, mal ga! Ana arimom̃a sinenan sape kila kana kinanena tai. Am̃em̃ar narin puluk na p̃a rui!’ ");
INSERT INTO lww_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ana pogos nap̃a m̃earu mloge, sinena mimi pap̃isi, pe pa re loyum̃a amio la poli. “Ana arimana pimi pis amio, vena were va loyum̃a, ana naga yepen mavin ga vaena. ");
INSERT INTO lww_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pisa ga pa arimana pisape ‘?Ata, kas via rui nap̃a nesum̃a nemiyum̃ae ke nemio ko e nini? In na nemlogear ruru ko e suri punu ga, ana pe okila re sur tai sanene pan inu poli. In na pe nom̃al re nap̃a om̃em̃ar narin nane tai pan inu pogos tai poli, vena nekila kinanena tai nemio kiau erau lala. ");
INSERT INTO lww_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ana pogos nap̃a om̃al narum̃a tap̃ena nene p̃asup̃e sina, ana osum̃alu om̃em̃ar kieta narin puluk nap̃a tesum̃a tepagan ruruia. ?Ana yar nene kila ya ne po pan ko? Naga p̃ar plan pupia kiom̃a kilavaru komp̃asia, pa kan kilavaru nene na nam̃eneen ga sira, pano-o kila makea. ?Pona p̃elaga ne nanene na ko sinom̃ania ana okila kana kinanena nena?’ ");
INSERT INTO lww_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ana arimana sinena miye m̃ena kiena m̃earu nap̃ani, ana pisa pania pisape ‘Ei, naruu, in na pe nesitom re sanene poli. Ko okila inu nekekara manene laa rui, nap̃a osum̃a omio inu silaga, a kiau sur la punu nap̃a sike ne, in na netam̃an punu pan ko rui. ");
INSERT INTO lww_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Lelaga nap̃a kiau prasmaro nene kilalu kiena mrapa na malena, ana pogos nap̃a pilopuia p̃asup̃e si pimi pun inu, sineu miyea, a in na nepisu sane popon kemua tekekarania, a tekila kinanena tai temio. Womla nene naga mare rui, ana naga mali sina, naga kovio, ana tom̃al sina!’” Ana Yesu pisa pan le Varasi lala, pisape “Pogaga, p̃akaiwa nini p̃isi e nene narui. A sa nap̃a pisa ne, popon yar nap̃a kilalu mrapa, naga monar vilopu sina, sa nap̃a prasmaro nene. Ana monar avisuar ruru amiu m̃ena ga ve akila re ve sa m̃earu nene, nap̃a kiena sitomena m̃arera pap̃isi, naga pieluen wenla nap̃a pilopu kiena malena.” ");
INSERT INTO lww_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Siraunia, Yesu pis pa kiena nalogena lala, pisa p̃akaiwa tai pan la, ana pisayu yar na yum̃aena tai. Yaru nene, naga pisu sane yoko kiena yerkawa kovenlua, ana sum̃alu miyum̃aen sur tai nap̃a yoko siraunia kiena malena sum̃a woga ga. P̃akaiwa nena sanini, sane: “Yerkawa tai, naga mligan lua kiena yar tai ve na visuaren kiena kilavaru. Ana pogos tai, visena pimi tolia sape kiena yar nene sum̃a kan ke ga kiena kilavaru, a kila kare ke kiena sur lala. ");
INSERT INTO lww_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ana naga pio yar nene pimi puna, pis pania, pisape ‘Ei, yar la apisawal ko pan inu rui. In na nepisu sane popon nekovenlua ko si vetan yum̃aena nene, yoko op̃is nenaga. Ana sumon nap̃a yoko ovano, sineun nesape oligan ruru sur lala wa vena nekilia nevisu lapui la nap̃a yar la akila pan inu.’ ");
INSERT INTO lww_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ana yar na yum̃aena nap̃ani mloge piowa, pisape ‘Lelaga o, piowa narui, yerkawa nene lalua yum̃aena wo nene vetan inu, nemninue sane yoko am̃a nekinana ve sanape narui. In na netotano e yum̃aena nini nakonua rui, ana in na pe puriuu pe m̃areran re si yum̃aenen lokove poli, a pe sineun re m̃ena neva nesum̃a neviuviun kinanena vetan yar la poli. ");
INSERT INTO lww_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pogaga, kiau mrapa ve sa nini. Yoko nete plan si lapui kiena ne yaru lala vito laa tano, ana yoko la akekaran inu vano vano-o yoko la monar avisuar inu e pogos nap̃a yerkawa kovenlua inu vetan yum̃aena nene.’ ");
INSERT INTO lww_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ana naga pa pio la nap̃a kiela lapui sike e yerkawa, la peve taaga apim puna. Ana tai pimi puna narui, piun tania, pisape ‘?Ana ko okila lapui e sur ya, a tol kilavaru via?’ ");
INSERT INTO lww_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Pisatam̃ea, pisape ‘Pias nen wel na kanena tol ponotia taaga 100.’ Ana yar nap̃a pisa pania pisape ‘Pogaga, yoko italua tetelua si vito laa tano. Nane kiom̃a lapui ne nanini, ototano, oyumu plan ke ne vilaga wa, osiri lualima yam lima ga 50.’ ");
INSERT INTO lww_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ana naga pano, yar tap̃ena pimi, piun tania, pisape ‘?A ko, kiom̃a lapui na ya?’ Ana naga pisatam̃ea, pisape ‘Karo na wit manu taaga 1000.’ Ana naga pisa pania, pisape ‘Pogaga, yoko italua tetelua si vito laa tano. Nane kiom̃a lapui ne nanini, ototano, oyumu plan ke ne vilaga wa, osiri ga ponotia ve orelu 800.’ Ana naga kila m̃a sanene pano-o kila makea. ");
INSERT INTO lww_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ana siraunia, yerkawa nap̃ani pisu kilale sur nene, ana naga pisa ke pa kiena yar nap̃ane nap̃a naga kan kiena kilavaru sumo, pisape ‘Lelaga ne, opinaun ruru inu nenaga, ana nepisu sane kiom̃a manmaruaena po, ko p̃arum̃a po pap̃isi nap̃ane.’” Ana Yesu pisape “Kam na apisu ke ne, yaru na yomarava nini lala, pogos nap̃a amiyum̃ae amio kilavaru, ana akila masisuania p̃isa, akilia p̃elaga na kilaen erau wo amio yaru lala, vena yaru la nene akila wo van la sirau. Ana nepisu nap̃a naruu na yomerarava lala, yam mokliu nap̃a pe amanmarua ruru re poli nap̃a ayum̃ae amio kilavaru nap̃a Ntewa mla pan la.” ");
INSERT INTO lww_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nepisa ruru pan amiu, nesape “Kilavaru naga pe na yomarava ga nini, ana visae kilia iila ko vena ove erau ruru omio Ntewa, popon oyum̃ae ea. Visae oyum̃ae ruru wo amio kilavaru kome mrapa naapo, siraunia yoko Ntewa kekaran vena were ko ova e nap̃a pe kilavaru re e poli, nane ma e mom̃a um̃a ma metava. ");
INSERT INTO lww_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Yar nap̃a p̃ar yepem̃aen narin yum̃aena tai, tekilia towasinea sane yoko naga war m̃ena yepem̃aen pupia yum̃aena woga. Ana yar nap̃a miyum̃aen narin suri tai pe mesmes re poli, yoko naga yum̃ae viowa laa na wa e pupia suria. ");
INSERT INTO lww_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Visae kam na ve awar re yepem̃aen yum̃aena na kilavaru e yomarava nini, yoko ane ligan sina sur nowo lala kiena ne Ntewa e limamiu vena ave kiamiu? ");
INSERT INTO lww_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","A visae kam na tap̃atete ayum̃ae ruru amio sur la nap̃a Ntewa tam̃an pan amiu nap̃a ve plas ga e yomarava nini, a ne yoko tam̃an si nalaena nowo nap̃a asike ma metava e peni ave kiamiu lue?” ");
INSERT INTO lww_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","A Yesu pisa m̃ena ga, pisape “Naga sina nini, visae yar na yum̃aena tai, naga tap̃atete yum̃aen pran yum̃aena kiena ne sup̃e ve lua veraga. Visae sanene, yoko naga kekaran tai, ana yepen mavin tai, pona logear tai, ana ligan tai. Tap̃atete akila nap̃a ave yar na yum̃aena kiena ne Ntewa, a ave yar na kilavaru m̃ena veraga.” ");
INSERT INTO lww_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ana e poglis nene, Varasi m̃ena lala asike ga wa, asum̃a amiyagogon ke visena la nene. Ana lala, la ape yar la nap̃a asitom manene kilavaru silaga, ana apitalia kare ga mrapa wo na yum̃aen amio kilavaru nap̃a Yesu pisayu ke pa kiena nalogena lala. ");
INSERT INTO lww_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ana Yesu pis pan la, pisape “Kam na sinemiun asape akila sa nap̃a yar la avisu amiu sane yar mesmes lala, ana Ntewa naga pisu ke ya nap̃a sike e losinemiu. Sur mok liu nap̃a yar la amieluaria, asape po, ana e visuena kiena ne Ntewa, pisu sane sur viowa ga lala.” ");
INSERT INTO lww_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Visena tap̃ena nap̃a Yesu pisa sanini, pisape “Nanua sumo, Tus Marua mom̃a ga, nap̃a tus lala kiena ne Mosis amio tus la nap̃a kiena ne navisaluaena lala asike ea, pimi m̃a pano-o tol pogos kiena ne Yoane Nakeena. Yoane miyum̃ae pano-o p̃isi, a nanagane Lologena Wo na sup̃enena kiena ne Ntewa pimi, ana asum̃a amlologon kare ga, a yar la nap̃a sinelan asape ava loyum̃a ea asum̃a ap̃ar ke yon pap̃isi vena atolia. ");
INSERT INTO lww_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ana nanene pe kila re sane Navisaluaena kiena ne Ntewa nap̃a sike e Tus Marua naga piowa poli. Pona ma e peni amio yomarava nini ava akovio yo, ana tap̃atete narin mras nen visena na Navisaluaena nap̃ani kilia kovio pogos tai.” ");
INSERT INTO lww_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Visena tap̃ena si tai nap̃a Yesu pisa, sanini, pisape “Visae yar tai ligan lua wona, ana va were si sira tap̃ena, Ntewa pisu yar nene kila ke kolau amio sira tap̃ena ne. Maran taaga m̃ena ga visae yar tai talopa amio sira tai nap̃a wona na sumo ligan lua rui, yar m̃ena nene kila ke kolau.” ");
INSERT INTO lww_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu pisa m̃ena p̃akaiwa nene, nap̃a pisa sanini, pisape “Yar tai, naga limana pulen sur wo la moki pap̃isi, naga sum̃a miyowau ruru lue ga silaga, a legiena punu ga amiyum̃aen kana pupia kinanena wo lala. ");
INSERT INTO lww_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yar tap̃ena m̃ena tai tom̃a ga, nap̃a silaga ap̃ere naga pimi amligan teke vanua e kove na pupia yum̃a m̃ana yar na suri moki nap̃ani. Yar nene, naga pe yar tai nap̃a pe kiena suri re poli, naga pe yaru na loginen ga kinanena, tas nen wetelu pulen ga magka, kiena kia Lasaros. ");
INSERT INTO lww_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Amligan naga teke e yo nene pona visae yoko kilia tol re kororos nen kinanen lap̃as nap̃a yerkawa nene kanligan yo, ana peraga. Naga mlogin korenan ke ga sanene, ana lokul la apim asum̃a amunvan ke kiena magka lala. ");
INSERT INTO lww_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Pano-o yar nap̃ani mare, ana navisi lala apim akuslua pa amligan m̃eke e yepas nen Epraam, ma e peni. A pe piavi re poli, yerkawa m̃ena mare, asinia. ");
INSERT INTO lww_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ana akoven naga pa e kapi, nap̃a mloge piowa na mloge piowa pap̃isi, ana siraunia, kira pa metava, kira pa perina pap̃isi, pisu Epraam sike na, a pisu nap̃a Lasaros sike amio, lalua asum̃a akinana ke na. ");
INSERT INTO lww_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ana pio laa, pisape ‘Oe, Ata Epraam, awis sinem̃a ye inu, oligan Lasaros vitom suan luas nen mrasilmana vito e narin wii tai, vena ligan te purmeneu. Nanagane kapi kekan inu nemloge piowa pano-o p̃isa.’ ");
INSERT INTO lww_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ana Epraam pisatam̃ea, pisape ‘Naruu, nagane ositom̃al si malena wo nap̃a ose sumo. E pogos nene, ko otol make kiom̃a suri la nap̃a ko sinom̃ania po pan ko pap̃isi, ana Lasaros na ositom korenan ga vanon piowa ga. E kiena malena nanua, suri punu ga piowa ga, ana nanagane, naga mloge si po e nini narui, a ko omloge ke piowa manene laa pap̃isi e nam̃a. ");
INSERT INTO lww_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ana suri ga tai, tap̃atete im̃asu iila ko, komin Ntewa mligan pupia pulus tai m̃eke likan ita lua, vena kila sane yar tap̃atete molue e yo nini vena im̃asu pum̃a, a tap̃atete molue e na osike e ne vena imi e yo nini.’ ");
INSERT INTO lww_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ana yar nene piun ke si na ga, pisape ‘Ata, visae sanene, neviun m̃areran tan ko vena ovitetalia Lasaros wasup̃e si vito tano garo um̃a m̃ana kau ata, ");
INSERT INTO lww_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","komin nap̃a wolai lima asike ga wa. Popon Lasaros vito visawal van la, visae peraga, sa p̃isi la m̃ena aimlae e yo naloge viowaena nini.’ ");
INSERT INTO lww_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ana Epraam pisatam̃ea, pisape ‘?Ana komin ya ne monar Lasaros vitove? La ap̃ar ke Tus Wa rui, nap̃a nasiriena wa kiena Mosis amio navisawalena la sike e rui. Popon la auloia, yoko alual suri punu sike ea.’ ");
INSERT INTO lww_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ana naga m̃areran m̃aga, pisape ‘?Ata Epraam, pona tap̃atete akila yo? Ana visae yar tai wasup̃e si imi e marena, visawal make sur la nene van la, yoko monar avilon la ga narui.’ ");
INSERT INTO lww_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ana Epraam pisatam̃ea, pisape ‘Visae la nene yepel mavin logeen ya nap̃a Tus Wa pisa, pe sur re si tai nap̃a kilia kila na alelaga poli. Pona yar tai wasup̃e si imi e marena, visa sur punu van la, pona ya sina, ana yoko la yepel mavin ga lelagaena.’” ");
INSERT INTO lww_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ana Yesu pisa pan kiena nalogena lala, pisape “Yoko nakilaliena lala akilia aim lue silaga ne, ana yar nap̃a kila sur lap̃asa nap̃a were nakilaliena imi lavisi, yoko viowa van vap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Visae am̃atear kilavaru tai m̃ene kolmekina a akoan talilu vito e lowe memaena, nanene na nakoaena tai nap̃a melala ga ne. Ana yar nap̃a kila naruu tai ligan inu, ve viawa re si m̃arera e inu, loru e mlamulena viowa, yoko yar nene naga war nakoaena tai nap̃a m̃arera manene laa sane taulu naga nene. ");
INSERT INTO lww_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Sanene, kam na monar avisu ruru kiamiu malena la silaga, vena ve okila re nakilaliena viowa lala aim am̃alivin kiom̃a erau.” A Yesu pisape “Visae ovisu nap̃a womla mloru ke pito tano e mlamulen piowa tai, monar ovis omio vena okila ruruia, a visae naga vilonia, monar oviewoia. ");
INSERT INTO lww_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Visae naga kila viowa van ko yam ve olua e legiena ve taaga, a pogos punu ga, naga kila viowa, a siraunia naga pisa ga pan ko na wa pisape ‘Ake wolai, nekila kare ko pap̃isi. Awis, oviewo inu,’ yoko okilakania? P̃isi na monar oviewo naga e pogos make la olua nene.” ");
INSERT INTO lww_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ana nalologena la apiun tan Yesu, apisape “Sup̃e, sinemimin mesape okila kiamimi naviawaena imi m̃arera la sane wa.” ");
INSERT INTO lww_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ana naga pisatam̃ea pisape “Visae aviawa ve tokak ga e inu, sane kurus nen purpa, ana visae kiamiu naviawaena nene ve lelaga ruru naapo, ana p̃isi na akilia avisa va purlu na m̃eke gare avisave ‘Omolue e yo nene, omio p̃eligas nem̃a lala, ova okapur ke gare likan lowe memaena ne, ana yoko naga logear amiu woga.’” ");
INSERT INTO lww_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","A Yesu pisape “Visae kam yar tai ve yerkawa, a kiena yar tai sum̃a kila yum̃aena la pania. Pona pa miyum̃ae lokove yo, pona pisuar kiena sur mali lala, pona ya sina, ana visae yepekilavi, pogos nap̃a p̃asup̃e e yum̃aena pitomi, yoko yerkawa visa ya ne vania? Tap̃atete visa vania visave ‘Ko, oimi oto omio inu, italua tekinana,’ komin naga pe kiena yar na yum̃aena ga. ");
INSERT INTO lww_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yoko yerkawa monar visa ga vania, visave ‘Pogaga, yoko ova oviran kapi sumo wa. Visae kinanena manoa, ova oyowau ruru ke ne wa, p̃isi na owar kau imi nakania, nomunia, p̃isi, okilia ola kom̃a.’ ");
INSERT INTO lww_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","A pogos nap̃a yar nayum̃aena kila sur punu ga nap̃a yerkawa pisa pania, yoko yerkawa tap̃atete visa pupia potena vania, vanon naga kiena yum̃aena ga. ");
INSERT INTO lww_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ana kam m̃ena ga monar ave sanene. Visae akila ruru make yum̃aena nap̃a Ntewa pisa pan amiu, vano-o p̃isi, yoko avisa ga sanene, avisave ‘Ee, nanene na pe sur re tai nene poli. Tekila ga ya nap̃a torokin tekila sa ke ga yar na yum̃aena kiena ne Ntewa lala.’” ");
INSERT INTO lww_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ana e pogos nene, Yesu la asum̃a amial ke apa ma Yerusalem na wa, ana kiela mrapa pa likan lepas lua nene, Samaria amio Kalele. ");
INSERT INTO lww_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ana amial m̃a pano-o, lavis ga am̃alivi e pulkumali tai, apitawe p̃egas nen yar tai na leperosi lala, la lualima, nap̃a la asum̃a e yepas nen mrapa. ");
INSERT INTO lww_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ana pogos nap̃a apisu Yesu, apion manene pania, asape “Yesu, Sup̃e, awis sinem̃a ye imimi.” ");
INSERT INTO lww_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ana pogos nap̃a Yesu mloge, pisa pan la, sape “Ava akom p̃esan pun yaru wa lala vena la avisu ruru nena tasnemiu lala vena avisave kam na yepemiu mian rui.” Ana la apano, a pogos nap̃a la asum̃a amial apano, amilan ga nap̃a yepela la pimi mian ke narui. ");
INSERT INTO lww_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","A lala tai, pogos nap̃a pisu naga po sanene narui, naga pilonia p̃asup̃e si pimi, miyeluar Ntewa pap̃isi, ");
INSERT INTO lww_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","pimi mloru e lana Yesu, pisa potena pania. Yar nene, naga pe pe yere Yu re naapo poli, ana naga pe Yu la komp̃as tai nae Samaria. Ana tap̃ena lala, la ape yere Yu nena naapo, ana la pe ap̃asup̃e re si apim poli. ");
INSERT INTO lww_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ana Yesu pisa sanini, sape “La nap̃a yepela mian rui, la lualima, ana awa la ovari? ");
INSERT INTO lww_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nap̃a p̃asup̃e pimi, naga yar nae ga lele tap̃ena, ana komin ya ne naga taaga p̃asup̃e pimi mieluar Ntewa, lap̃as pe apim re poli?” ");
INSERT INTO lww_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ana Yesu pisa pania, pisape “Erau, osum̃alu oyali ova um̃a. Kiom̃a naviawaena tamalia ko rui.” ");
INSERT INTO lww_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ana siraunia, Varasi la apim apiun tan Yesu, asape “?Nasup̃enena kiena ne Ntewa nap̃a opisayu ke silaga, yoko mevisu pogwai?” Ana Yesu pisatam̃ea pisape “Nasup̃enena kiena ne Ntewa pe pimi re sane sur tai nap̃a yar kilia visu e kilamarana poli. ");
INSERT INTO lww_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Naga pe sur re tai nap̃a yoko avisave ‘Ke, na nam̃a narui, nane pimi ke nam̃a,’ pona avisave ‘Nane, sike gare rui.’ Kam na pe apisu kilale re poli, ana nasup̃enena kiena ne Ntewa sike pa likan amiu rui.” ");
INSERT INTO lww_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ana Yesu pisa pan kiena nalogena lala, sunyu pan la sape yoko ve sanape e legiena maro la ne pimi ke ne. Naga pisape “Siraunia, yoko kam na sinemiun manene vap̃isi navisuen pog nap̃a yoko inu Narina ne Yeririna neim nom̃alivin yomarava, ana nanene na pe pon re kam na avisu poli. ");
INSERT INTO lww_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yoko yar la avisasa sanini avisave ‘!Naga nane gare!,’ pona ‘!Naga nane garo ne!,’ ana kam na ve ava re amio la, komin pe inu re nene po laa wa. ");
INSERT INTO lww_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ana pogos nap̃a inu Narina ne Yeririna nowasup̃ea ve lelaga e kana legiena nena, yoko yar make ga avisu kilalea, yoko neimi sane yekarpla tai nap̃a kila sinapane vivaga e lepas tai va tol lepas komp̃asa. ");
INSERT INTO lww_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ana sur nene na pe kana pogos re poli wa, komin sumon nene, yoko inu Narina ne Yeririna, yar nanagane lala akila viowa van inu e sur viowa la ve moki, yoko monar akovenlua inu. ");
INSERT INTO lww_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Vano-o tol pogos nap̃a inu Narina ne Yeririna nowasup̃ea, yoko yar la ve akila ruru la re na wa, maran ve taaga ga sa ke pogos kiena ne yermarua Noa nanua sumo. ");
INSERT INTO lww_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","E pogos nene, yar la asum̃a akinana, amun suri lala, asum̃a akila ke talopaena sanene, pimi tol pogos nap̃a Noa pa loyum̃a e kiena pupia waa nap̃a naga miyum̃aenia. Ana pupia womie pitomi kus plan make kiela malena la punu ga. ");
INSERT INTO lww_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","A e pogos kiena ne Lot sa m̃a nenaga nene. Yar la asum̃a akinana, amun suri lala, asum̃a apa ke e lele na wilwilena po amiyum̃aen ke kilavaru, asum̃a amiyum̃aen ke lokove, amiyum̃aen ke yum̃a, la akila ke ga sanene pa ke na, pe asitom̃al re sur tai poli. ");
INSERT INTO lww_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ana e nena e legiena nap̃a Lot molue petan kiela yo, kapi amio pan na kapiapo mloloru pitomi ma e sinapane, kekan la akokovio make nenaga. ");
INSERT INTO lww_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ana nevisa van amiu, e pogos nap̃a yoko inu Narina Yeririna neimi, yar la tap̃atete asitom̃al sur tai, asitom̃al la ga, ana yoko ailan pupia sur kerkeviu la ne sanene imi m̃alivin la. ");
INSERT INTO lww_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“E pogos nene, visae yar tai sum̃a yum̃ae ke meta e m̃ana wos nen yum̃a, ana visu sur nene imi, ana vito tano pe pon re kilali sape va war suri lap̃as e m̃ana loyum̃a poli, naga monar va ga narui. Yaru nap̃a miyum̃ae ke lokove, naga m̃ena tap̃atete si vito um̃a, yoko monar va ga narui. ");
INSERT INTO lww_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kam na ve sinemiu p̃esan re wona Lot, nap̃a kirap̃atau, ana pimi pe kilavaru. ");
INSERT INTO lww_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yar nap̃a kilali sape visuar ruru ga kiena malena, yoko kovio, ana yar nap̃a tam̃an kiena malena kovio, yoko naga ga tamalia sina naga. ");
INSERT INTO lww_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nevisa van amiu nevisave e pogos nene, pona kolemalo nap̃a yar m̃eke amio wona yo e m̃ala tog, ana yoko aim awerelua ve taaga ga, aligan tai m̃eke na. ");
INSERT INTO lww_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ana pona yoko sira la ve lua asike avili ke kala kinanena lele taaga yo, ana ve taaga vano tai sike na. ");
INSERT INTO lww_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ana pona yar lalua ayum̃aevain ke lokove tai yo, yoko tai ure matania, ve taaga sum̃al wowe ga sike na.” ");
INSERT INTO lww_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ana nalogena la apiun tania, asape “?Ana Sup̃e, suri la nene yoko m̃alivi e nape?” Ana naga pisatam̃e la, sape “E pogos nene, yoko ve sa nap̃a visae sur mare tai m̃eke koyo tai. E yo nene narui yoko manu la nap̃a akakan ke sur mare, yoko aiminia, monar la ve moki ase yo nene. E nape nap̃a mlamulena viowa sike ea, yo ke ga nanene narui yoko nalip̃ereena se ea.” ");
INSERT INTO lww_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ana Yesu pisa sina p̃akaiwa tap̃ena tai pan la, vena iilaar la ve asitom p̃ele re si kiela leniena lala, vena asum̃al m̃arera asulue ga ea, alen m̃a vano-o atol kana navisatam̃eena. ");
INSERT INTO lww_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kiena p̃akaiwa nena pa sanini, sape: “Pulkumali tai, nap̃a kana sup̃e nena naga pe yar m̃arera tai, naga pe yar tai nap̃a pe patanon re Ntewa poli, pe maraun re nenaga, a naga sitom p̃ele m̃ena yar la. ");
INSERT INTO lww_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ana letano m̃ena tai sike e yo nene, nap̃a yar tai sum̃a kila kare ke kiena sur la silaga. Ana letano nap̃ani pa sum̃a tagi ke pan kiena sup̃e, naga sum̃a pisawal ke yar nap̃ani, sape ‘Awis, monar okila sur tai va yar nene, naga kila kare in pap̃isi wa.’ ");
INSERT INTO lww_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ana sup̃e nap̃ani pe sinen miye re sira nene poli, a pe yowenan visen va yar nap̃ani, ana kila luen ga sanene pa ke na, sira m̃ena nap̃ani pa tagi luen ga pan silaga. “Ana siraunia naga pisape ‘In na nepe yar tai nap̃a pe nesitom re nesape nekila ya nap̃a Ntewa pona yar tap̃ena pisa pan inu sape popon nekila. ");
INSERT INTO lww_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ana sira pimi tagin ke pan inu, ana in na pe sineun re nesape nekila ya nap̃a pisa ke poli. Ana naga pimi piun luen ga sanene, naga kila kare inu pap̃isi wa, ana pona nekila ga ya nap̃a naga piun ke yo. Visae peraga, yoko neloge kiena tagena vano-o sineu marenia.’” ");
INSERT INTO lww_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ana Sup̃e Yesu pis pa la nap̃a amiyagogon ke p̃akaiwa nene, pisape “?Kam na ayagogon ruru visena nap̃a sup̃e yowena nene pisa ne? Komin sira nene tagi yam moki pania, ana yoko monar sitomli sur na sira nene piun ke ne. ");
INSERT INTO lww_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","?Ana sanapen Ntewa nae ma e peni? ?Pogos nap̃a mloge kiena yeririna la nap̃a mligan plan la, atagi ke pania lemalo a legiena, naga kilia su kap̃ar sanene ve kila re sur tai van la? ");
INSERT INTO lww_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Peraga, ana nevisa van amiu sanini, visae loge nap̃a alen m̃arera vania silaga, yoko naga sum̃alu vilaga e pogos make ga kilia iila amiu. ?Ana nesape neviun m̃ena van amiu, sane visae pogos nap̃a inu Narina ne Yeririna nowasup̃e si neim e yomarava nini, yoko nelual nap̃a yar la asum̃alu m̃arera asike e inu sanene, pona peraga?” ");
INSERT INTO lww_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ana pogos nap̃a Yesu sike amio yeririna lala, naga pisu kilale nap̃a lap̃asa ap̃arwar la pap̃isi, asitom ke asape la kiela malena mesmes ruru po narui, a la apisu yar tap̃ena la apiowa ga, apisu sane la apiowa manene laa pe sa re la poli. Ana pisayu yar la sanini, pisa p̃akaiwa tai, sape ");
INSERT INTO lww_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Yar lalua apa ma e Yum̃a Wa m̃ana Ntewa e pogos na leniena. Lala yar tai, naga pe yere Varasi, a tap̃ena, naga kila yum̃aena tai nap̃a yaru la pe sinelan re naga vanon poli, naga pe yar na takis. ");
INSERT INTO lww_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ana pogos nap̃a yere Varasi naga sum̃alu mlen, pisa sanini, sape ‘Ake Ntewa nepisa pupia potena pan ko pap̃isi, nap̃a kiau malena naga po laa sane taulu kiena ne yar tap̃ena lala. Nemieluar ko, nap̃a in na pe sa re yar navinauen la poli, pona yar na kilakeuiaen yar lala, a yar na kilaen kolau lala, pona yar na takis lala sane yar na sum̃alu sike ne. ");
INSERT INTO lww_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Peraga, in na nesum̃a nekila ke po silaga, komin nap̃a in na nomonsilun kilaen leniena van ko e legiena lua e wik taaga, a e sur make ga nap̃a nemla e lum̃au, visae netol ve lualima, monar nela ve taaga van ko silaga. Sur ne la na nene narui nap̃a in na nesum̃a nekila, ana kila inu nopo pap̃isi e maram̃a.’ ");
INSERT INTO lww_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ana yar na takis, naga sum̃a mloge ke piowa vanon kiena mlamulena viowa nap̃a kila, ana mninu sane Ntewa pisu kiena malena pe po re nena poli. Ana naga yepen mavin va maneneen lavisi, sum̃alu ga sum̃a perina, a naga yepen mavin kiraen va metava ma e peni, a naga p̃arin tau ga tom̃a ga, mlipalipa ke yerena, tagi, pisape ‘!Ake Ntewa, ove lemam van inu, sinem̃a ye inu, yar na kilaen mlamulena piowa!’ ");
INSERT INTO lww_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ana kam na asitomyulia leniena kiena lalua nene, ana yoko Ntewa kekaran kiena ai? Lelaga, yar nap̃a pisu kilale kiena mlamulena viowa, a mloge piowagania, Ntewa p̃ar plan kiena mlamulena viowa. Ana yar tap̃ena nap̃ani, naga p̃asup̃e si pa um̃a nap̃a kiena malena maran taaga ga sa ke nap̃a pimi. Yar nap̃a sum̃a pisirlua naga, yoko Ntewa ligan naga m̃eke tano, ana yar nap̃a mligan naga sike tano, yoko Ntewa visirlua naga.” ");
INSERT INTO lww_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ana e poglis nene, auia lap̃as ap̃ar narila sisi tomtom lala apim puna Yesu, sinelan asape kus la, visa ruru la. Ana pogos nap̃a nalogena la apisuia, apisalup̃ar la, asape avava sina. ");
INSERT INTO lww_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ana Yesu pio sira la nap̃ani, sape aim m̃aga, ana pisa pan nalologena lala sanini, sape “Kam na ve avisalup̃ar re sisi la nam̃a, atam̃an la aim pun inu, komin nap̃a sisi la nam̃a, yeririna la nap̃a asa ke ga la nene, la ke ga nene narui nap̃a asum̃a apa loyum̃a e nasup̃enena kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","In na nepisa ke lelaga na pan amiu ne, visae yar nap̃a sinenan nasup̃enena kiena ne Ntewa, naga monar kila naga imi ve sa sisi la nini, visae peraga, naga tap̃atete va loyum̃a.” ");
INSERT INTO lww_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ana siraunia, sup̃e tai pimi piun tan Yesu, sape “Navianena wo, awis, popon ovisawal van inu sane in na monar nekila ya nap̃a visae nekila yoko nekilia netol malena nap̃a ve uro re.” ");
INSERT INTO lww_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ana Yesu pisatam̃ea, sape “!Ei! Ko na okilia ya ne, osape in na nopo? Pe yaru tai po ruru re naapo poli, ana Ntewa ga naga taaga. ");
INSERT INTO lww_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ana ko opiun osape sanape nap̃a yar tai sane ko naga kilia imi wo e marana Ntewa woga. Pona okilia ruru kiena Navisaluaena yo rui, nap̃a pisape ko ve okila re lau, ve owem̃ar re yaru, a ve ovinau re, ve ovisokan re, ovatanon arimom̃a amio anom̃a.” ");
INSERT INTO lww_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ana yar nap̃ani pisatam̃ea, pisape “Lelaga, in na nekilia kemua Navisaluaena la ne opisa ke ne, a nekilia nevisa van ko sanini, in na nopuar ruru la siar e pogos nap̃a nepe yar viu ke ga wa. Pimi tol nanagane, pe nekilalu re tai poli.” ");
INSERT INTO lww_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ana pogos nap̃a Yesu mloge pisa sanene, pisape “Pogaga, ana e lepas nap̃a pum̃a, sur tai sike ga wa. Monar ova owilwilin plan make kiom̃a sur moki la nene, ana owar kana kilavaru, ova okiakian kare ga va yar la nap̃a limala plasa. Visae okila sanene, yoko kiom̃a sur wo la ve moki ma e peni. Ko, ova okila, p̃isi na oim otaveve inu.” ");
INSERT INTO lww_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ana pogos nap̃a yar nene mloge visena nene, sinen piowa pap̃isi, kiena sitomena pimi urmi na urmi, komin naga pe yar na sur moki, limana pule pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ana Yesu pisu manene yerkawa nene pano-o p̃isa, siraunia pisape “Visae yar tai nap̃a kiena sur moki, naga sinenan sape va loyum̃a e Nasup̃enena kiena ne Ntewa, sur nene naga m̃arera towe m̃a nap̃a. ");
INSERT INTO lww_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ee, nevisa van amiu, visae kamel tai va warpo yo kome pulus nen nitil, nanene na m̃arera pap̃isi, ana visae yar tai nap̃a kiena sur moki sinenan sape va loyum̃a e Nasup̃enena kiena ne Ntewa naga m̃arera laa na wa.” ");
INSERT INTO lww_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ana la nap̃a amloge visena nene amilan pano-o pap̃isi, asape “!Aulai! Visae sanene, ane yoko tol malena?” ");
INSERT INTO lww_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ana Yesu pisatam̃ea, pisape “Lelaga, yar tap̃atete kila naga tol malena, ana ya nap̃a yar tap̃atete kila, Ntewa naga kilia kila woga.” ");
INSERT INTO lww_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ana Pita piunia, pisape “?A yoko ve sanapen imimi? Memligan m̃amimi um̃a la rui, ana metaveve ko ke narui.” ");
INSERT INTO lww_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ana Yesu pisa pa kiena nalogena lala, sape “Kam na ve asitom manene re e lepas nene. Yar a nap̃a visae ligan m̃ana um̃a, pona wona, pona wenla, pona arimana amio anena, pona narina lala, a visae ligan sur la nene vanon yum̃aena na Nasup̃enena kiena ne Ntewa, ");
INSERT INTO lww_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","yoko naga tol maran si kiena sur la nene va ve moki manene laa va laa sane na wa. Naga nene e pogos nanagane, a sirau m̃ena ga e pogos na pimi ke ne, yoko naga tol malena nap̃a ve uro re.” ");
INSERT INTO lww_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ana poglis nap̃a amiyaloro ke apano, Yesu pio kiena lualima taaga pa lua apim puna, pisa pan la pisape “Ayagogo ruruia. Nanagane tepa ke ma Yerusalem narui, a pogos nap̃a tetolia, sur make la nap̃a navisawalena lala asiriyu nanua sumo rui e lepas nen Narina ne Yeririna, yoko avisuia aimi am̃alm̃alivi ve sa nena nap̃a apisa. ");
INSERT INTO lww_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yoko avisu nap̃a aligan naga va e limana ne le Rom lala, nap̃a yoko akirakirai viowa vania, akila karea e p̃elaga viowa lala, avilasiria, ");
INSERT INTO lww_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","alilia, akila m̃a sanene vano-o awem̃aria. Ana yoko kana legiena ve telu, naga sum̃alu mal sina.” ");
INSERT INTO lww_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ana pe sur korena ga nap̃a Yesu pisawal meraravan make sur punu pan la sanene, ana la pe amloge kilia ruru re nenaga. Naga sa nap̃a visena la nene na atapolou ga e la, ana kila sane tap̃atete atol kana kinasa. ");
INSERT INTO lww_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ana Yesu la amiyaloro apa m̃aga, apim lavisin pulkumali nap̃a Seriko, ana kilamara p̃ala tai teke tano e is nen mrapa, tom̃a mlogin ke kana kinanena tan yeririna la nap̃a apa akomkom ke e nene. ");
INSERT INTO lww_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ana kilamara p̃ala nap̃ani mloge nap̃a Yesu la apim ke na amio p̃ina la nap̃a asum̃a amialoro ke amio, ana naga piunia pisape “La nene na li pe la nene, akope ke ne?” ");
INSERT INTO lww_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ana apisatam̃e sanini, asape “!Ke, nanene na Yesu nae Nasaret nap̃ane, nane pimi ke ne imi kom pun ita ne!” ");
INSERT INTO lww_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ana yar nap̃a pio manenea, a tagi pa Yesu pisape “!Yesu, ko lus kiena ne Tepet, sineun nap̃a sinem̃a ye inu!” ");
INSERT INTO lww_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ana la nap̃a asumon ke Yesu, amloge pio sanene, ana apisalup̃aria, apisape “Ova ruru ko ga.” Ana yar nap̃a yepen ma ga, pio ke sina ga, pa laa meta sane wa, pisape “!Yesu, ko na lus kiena Tepet, nemie awis pan ko, sinem̃a ye inu!” ");
INSERT INTO lww_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ana Yesu mial pano, pimi sum̃al su puna e yo nene, pisape atar yar nene imi lavisinia. Ana atar pimi, Yesu piun tania, pisape ");
INSERT INTO lww_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“?Ana ko sinom̃an osape nekila ya ne van ko?” Ana naga piunia pisape “Sup̃e, awis, sineun nesape kilamarau imi wo, nekilia nevisu suria.” ");
INSERT INTO lww_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ana Yesu pisape “Pogaga, nanagane nela kiom̃a nakiravaena van ko sa nap̃a opiunia. Kiom̃a naviawaena kila ko opim opo sina.” ");
INSERT INTO lww_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ana e nena e poglis nene, yar nap̃ani, kilamarana pimi po, ana mial ke amio Yesu, sum̃a miyeluar ke Ntewa. A yeririna m̃ena la nap̃a apisu sur nene, apisu po pap̃isi, asum̃a amieluar ke kia kiena ne Ntewa vanonia. ");
INSERT INTO lww_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ana Yesu la apim loyum̃a Seriko, amialin ke nap̃a ava awar ro ga ea. ");
INSERT INTO lww_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ana e nap̃ani yar tai sike ea kiena kia Sakias. Naga pe yerkawa kiena ne yar na warpoloen takis e pupia lepas nene, ana vanon nap̃a naga miyum̃ae piowa, kila kare ke yaru lala e kiela kilavaru na takis nena, kila naga liman pule pap̃isi, naga pe yar na sur moki. ");
INSERT INTO lww_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ana Sakias m̃ena pimi e poglis nene, sinenan sape visu Yesu naga pe yar na sanape, ana yeririna la mokliu nap̃a asike lavisin Yesu, asuwo ga yo, sa nap̃a yo kuskus ga rui, ana naga pe pisu ruru re poli, komin naga pe yar plas ga tai. ");
INSERT INTO lww_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ana Sakias pisu sane piowa narui, kiriri sumon Yesu lala, pa tol puryove tai p̃iyu pa e korowas tai, sum̃ate ke nap̃a visae Yesu la ayal aimi, ana naga kilia visu ruruia. ");
INSERT INTO lww_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ana pogos nap̃a Yesu pimi tol puryove nap̃ani, Sakias milan ga nap̃a Yesu kira pa pisuia, pis pania, pisape “Sakias, otapulu vilaga. In na nemninulup̃ar e inu sane p̃ane neva nesu re nemio ko sumo wa gar mom̃a.” ");
INSERT INTO lww_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakias mloge narui, sum̃alu pula nena pitomi tano, ana p̃ere Yesu pa m̃ana, amio pupia kekarena pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ana pogos nap̃a yeririna la apisu sur nene, la moki nap̃a pe akekaran re poli, apismumu, apisape “Yar nap̃a Sakias naga pe yar sur nap̃a miyum̃ae piowa ga, naga kila kareli yar lala wa, ana vanon ya ne Yesu sinenan sape amio ava asu m̃ana?” ");
INSERT INTO lww_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ana pogos nap̃a asike loyum̃a rui, Sakias mloge sane naga monar vilopuia, a monar kep̃u kiena malena, ana sum̃alu pisawal e marana ne Sup̃e, pisape “Sup̃e, nanagane in na netam̃an kiau sur la komp̃as va yar la nap̃a limala korena, pe kiela sur re poli. A suri ya nap̃a nepisa kotalia yar la ea, nepinaun la, yoko nowar maran si van la tol yam ve vari.” ");
INSERT INTO lww_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ana Yesu mloge pon manene visena nap̃a Sakias pisa, ana pisa pania pisape “Nepisu sane p̃ane na, natamaliaena kiena ne Ntewa pimi nena tol mratava nini. Yar nene naga kilalu mrapa na kiena malena, ana naga m̃ena pe lus kiena ne Epraam kemua lelaga, naga pe yere Yu kemua tai, ");
INSERT INTO lww_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ana inu Narina ne Yeririna nepim e yomarava nini vena nakale la nap̃a amiyepe petan mrapa sane yaru nene, vena netamalia la.” ");
INSERT INTO lww_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ana yeririna la asum̃a amiyagogon ke visena kiena Yesu la nene, ana pis m̃a pan la pano-o, pisa p̃akaiwa tai pan la. Naga pisu sane popon vian la e p̃akaiwa nena, komin naga kilia ke sape sane yeririna lala asitom ke asape pogos nap̃a ava atol yo Yerusalem, yoko naga kila nasup̃enena kiena ne Ntewa imi warpo ke yo van la veraga. A nanagane apim ke lavisin Yerusalem rui, a Yesu sape vianin la sane naga monar ligan la sumo wa, yoko imi si pula. ");
INSERT INTO lww_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naga pisa pan la sanini, sape “Yerkawa tai, naga pa perina e nap̃a pupia p̃arin sup̃e sike ea, vena avisirlua naga imi ve p̃arin sup̃e na kiena lepasa, yoko naga kilia wasup̃e sina visuar kiena yo. ");
INSERT INTO lww_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ana sumon nap̃a pe pa re poli wa, naga pio kiena yar lala, la lualima, a la punu ga mla kilavaru peve taaga pan la, sape monar ayum̃ae amio kilavaru nap̃ani vano-o tol pogos nap̃a naga wasup̃e sina. ");
INSERT INTO lww_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ana yeririna la nae lepas nene ape nasinekar kiena ne yerkawa nene, ana pogos nap̃a naga pur matan la pa narui, la apisayuia asape la pe sinelan re si naga imi ve kiela p̃arin sup̃e poli. Ana amligan visena pa pa p̃arin sup̃e keviu na purvanua nap̃ani, asape ‘Pe sinemimin re yar nene imi ve kiamimi p̃arin sup̃e poli. A pe sinemimin re nena nap̃a oligan kia keviu nene e naga poli.’ ");
INSERT INTO lww_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ana p̃arin sup̃e keviu nap̃ani kila ga, ana yerkawa nene pimi ve sup̃en ke sina ga kiena lepasa. Ana pimi pio viraviran kiena yar la nap̃a naga p̃ar p̃esan kilavaru nene pan la, sinenan sape visu sane amiyum̃ae ea, ana ataulu si kiena kilavaru via. ");
INSERT INTO lww_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ana yar nap̃a pimi sum̃al p̃esan se marana, pisape ‘Sup̃e kiom̃a kilavaru taaga nap̃a omla pan inu, nemiyum̃ae m̃a amio pano-o netaulu si lualima to metavania.’ ");
INSERT INTO lww_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ana yerkawa nene pisu kiena yar na yum̃aena nene miyum̃ae po, ana pisa pania sape ‘Po na po pap̃isi, ko omiyum̃ae po manene laa wa. Ana komin nap̃a osum̃alu m̃arera ose narin yum̃aena nap̃a nemligan e lumom̃a, ana nagane nela yum̃aena keviu tai van ko, neligan ko ovisuar kiau pupia pulkumali ve lualima.’ ");
INSERT INTO lww_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ana siraunia, yar nalua pimi, pisape ‘Sup̃e, kilavaru taaga nap̃a omla pan inu, nemiyum̃ae m̃a ea pano-o taulu si lima to metavania.’ ");
INSERT INTO lww_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ana yerkawa nap̃ani pisa pania, sape ‘Po wa, ko m̃ena omiyum̃ae po pap̃isi, yoko neligan ko ovisuar kiau pupia pulkumali ve lima.’ ");
INSERT INTO lww_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Yoko kiena yar tap̃ena pimi, pisape ‘Sup̃e, kiom̃a kilavaru nap̃a omla pan inu, nepiwo ruru e kinakina kulmrae tai, nemligan ruru tom̃a ga, nane nesape nela si wasup̃e imi van ko narui. ");
INSERT INTO lww_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","In na nesum̃a nepisu ko ke sane ko yar tai nap̃a okilia owar plan kiom̃a sur nap̃a yar tap̃ena p̃arar sike na, a okilia okinana e lokove nap̃a pe ko re omapila poli. Kiom̃a p̃elaga m̃arera towe laa sanene, kila nemaraun ko, ana pe nekila re surian kiom̃a kilavaru nene po, nepuarar ruru ga tom̃a ga.’ ");
INSERT INTO lww_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ana yerkawa nap̃ani sinen karia, pisape ‘Yaru, opisa kare in laa ne wa, nap̃a osape in na yar m̃arera tai ne sanene. Ana pogaga, kiom̃a visena nene naga ga kar ko ke sina ga. ");
INSERT INTO lww_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","?Visae in na yar sur na sanene, komin ya ne opuar kiau kilavaru sanene? Po pap̃isi nap̃a visae oligan ga e pag, vena pogos nap̃a nowasup̃ea, nekilia nowar plan sina amio narina nap̃a naga tauluia.’ ");
INSERT INTO lww_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ana yerkawa nap̃ani pisa pa yar tap̃ena la nap̃a asum̃al asike lavisinia, sape ‘Awar plan kilavaru nene e limana, awar va yar nap̃a taulu lualima.’ ");
INSERT INTO lww_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ana apis pa yerkawa nap̃ani, asape ‘!Ana sup̃e, naga p̃ar mokliu wa, kiena lualima rui!’ ");
INSERT INTO lww_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ana yerkawa pisa pan la pisape ‘Lelaga, ana sanene narui. Naga nap̃a kiena sur mok rui, yoko naga war si va laa sane na wa, ana naga nap̃a pe kiena sur re poli, yoko naga kilalu kiena narin sur ve tokak ga nap̃a naga mla ke rui. ");
INSERT INTO lww_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ana e lepas na kiau nasinekar la nene, nap̃a la yepela mavin nap̃a in na neve sup̃en la, sineun nesape ava aurela aim e nini, awe mom̃ar la amarmare e marau.’” Ana p̃akaiwa kiena ne Yesu nane p̃isi e nene. ");
INSERT INTO lww_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ana Yesu pisa pa visena la nene, sum̃alu, sumon la, p̃ere la apa ma Yerusalem. ");
INSERT INTO lww_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ana la apim lavisin narin pulkumali lua nene sumo, nap̃a Petpas amio Petani, e lepas nen Kunus Na Purolip lala. Ana Yesu pisa pa kiena nalogena lua, pisape ");
INSERT INTO lww_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kam lua ayalor ava ke ne e narin pulkumali na gare sumo wa. Pogos nap̃a ava loyum̃a, yoko alual togki tai, am̃atear teke ea. Togki nap̃ani pe teras ga, pe yar tai to li re e m̃asina poli wa, ana kamlua alup̃arlua, aure imi e nini. ");
INSERT INTO lww_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Visae aviun tan amiu amlua, avisave ‘E, amlup̃arlua ke pe na ya?,’ yoko avisatam̃ea avisave ‘Sup̃e sinenan sur mal nini kila kiena yum̃aena tai.’” ");
INSERT INTO lww_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yesu pisa sanene pan lalua, ana mligan la apano, ana apano apisu sanena nap̃a pisa pan la. ");
INSERT INTO lww_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ana apano asum̃a amlup̃arlua ke kilka petan sur mal nap̃ani, ana pogos nap̃a akila ke sanene, kana p̃ar ne la apiunia asape “?E, asum̃a amlup̃arlua ke kilika petan pe na ya?” ");
INSERT INTO lww_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ana apisatam̃ea asape “Peraga, Sup̃e sinenan sape sur mal nini kila ke ne kiena yum̃aena tai sumo wa.” ");
INSERT INTO lww_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ana atam̃an narui, ap̃ure togki nap̃ani pimi pa Yesu, ana ap̃atetae m̃ala kulkota lala meta e m̃asina, amligan Yesu totano ea. ");
INSERT INTO lww_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ana Yesu kus togki nene, mial pano, ana pogos nap̃a mial ke pa sanene, yeririna lala amien plan m̃ala kulkota lala ap̃atetae sululu mrapa, vena togki kiena ne Yesu yalor ga metava ea. ");
INSERT INTO lww_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ana amial m̃a e Kunus Na Purolip la pano-o, apim atol yo e nap̃a mrapa na vitoen garo Yerusalem. Ana pogos nap̃a pupia p̃ina moki lala na nalogena lala apisu nap̃a Yesu pimi ke lavisin Yerusalem, asitom̃al pupia yum̃aena lala a kile lala nap̃a apisu naga kila, a apisu sane kiela pupia p̃arin sup̃e viu tai ne pimi ke ne, ana akekara pap̃isi, asum̃a amieluar Ntewa keviu vanonia. ");
INSERT INTO lww_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Asum̃a apiovionia, asape “!Ntewa na mava, ovisa ruru p̃arin sup̃e nene nap̃a pimi ke e kiom̃a kia! !Pupia kekarena ma e peni, kam nae ma metava avisirlua kia kiena ne Ntewa, kiena naurarena po na po!” ");
INSERT INTO lww_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ana e poglis nene, Varasi lap̃as asike m̃ena likan p̃ina la nene, ana pe akekaran re nap̃a apisirlua ke kia kiena Yesu sanene poli, ana apisa pania asape “!Navianena, ovisalup̃ar kiom̃a nalogena lala ve akiikiin ko re si sanene!” ");
INSERT INTO lww_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ana Yesu pisatam̃e la, sape “E, peraga narui! Visae ve akiikii re sa nene, pona yoko kilavaru ga la ne sike ne monar akiikii yo.” ");
INSERT INTO lww_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ana Yesu pimi lavisin pupia pulkumali nene Yerusalem, kira pito pisuia, sinen miyea, siar nap̃a wamarana mlaunia. ");
INSERT INTO lww_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kila sanene narui, pisaar nena pania, pisape “Visae ovisu kilale ga ya nap̃a molue pum̃a nagane! Ntewa sum̃a kila ke kiom̃a mrapa wo tai vena olual sum̃are ea ana opisu kilale p̃ele ga. ");
INSERT INTO lww_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ana monar nevisa van ko sanini, yoko pogos tai imi van ko nap̃a kiom̃a nasinekar lala, la ve moki vap̃isi nap̃a aimin ko. Yoko asuvivi ko, asuwo ruru ko nenaga, a yoko awar porotano imi ayuwonpolo e yepas nen kiom̃a pupia kove ana akila mrapa na vitom̃asen loyum̃a, vena awe ko. ");
INSERT INTO lww_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Yoko awe mom̃ar narum̃a lala, a akilawowa make mom̃a yum̃a lala, awar plan make nena kala kilatapili lala. Nakoaena na sanene yoko imi van ko komin nap̃a ko yepmavin visu kilaleen nap̃a nagane naga pe kiom̃a pogos nap̃a Ntewa pimi m̃alivi vena tamalia ko.” ");
INSERT INTO lww_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ana Yesu mial pa loyum̃a e pulkumali, pa e Yum̃a Wa m̃ana Ntewa, ana pisu la nap̃a akila ke yum̃aena na tauluen kururu kilavaru ea. Ana naga m̃ene plan la, sape ");
INSERT INTO lww_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Ntewa pisa e kiena Visena Wa, pisape ‘M̃au yum̃a wa naga pe yum̃a na leniena, ana kam na apilon yum̃a nene narui pimi sane puluve tai m̃ana yar na vinauena lala.’” ");
INSERT INTO lww_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ana e poglis nene e legiena punu ga Yesu pa ke loyum̃a e Yum̃a Wa, ana pian ke yeririna lala, a yerkawa kiena ne yar wa lala amio navianena navisaluaena lala amio m̃ena yerkawa kiena ne yeririna lala, pe akekaran re nenaga. Asum̃a akalewele ke mrapa vena akilia akila sur tai vena kila narui monar awem̃ar Yesu. ");
INSERT INTO lww_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ana peraga, apisu sane tap̃atete alual mrapa, komin yeririna la nap̃a amiyagogon ke kiena navianena lala, akekaran manene laa kiena visena lala, la sinelan ga naga silaga. ");
INSERT INTO lww_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ana e si e legiena tap̃ena, Yesu p̃asup̃e si pa e Yum̃a Wa m̃ana Ntewa gar Yerusalem, sum̃a pian ke yeririna lala a mlologon ke m̃ena nalologena wo pan la. Ana nasumonena kiena yar wa lala amio navianena navisaluaena lala amio m̃ena nasumonen tap̃ena lala apim puna, apiun tania, asape ");
INSERT INTO lww_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“?Ovisali van imimi, sane okila ke sanene e nini e kia kiena ai? ?Ane pisa pan ko pisape okila sa nene?” ");
INSERT INTO lww_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ana Yesu pisatam̃e la, sape “Pogaga, ana yoko in m̃ena neviun naviunena tai van amiu sumo wa. Kiau naviunena sanini, sane ");
INSERT INTO lww_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","‘?Nakeena nap̃a Yoane kila nanua ga ne pa yar lala, naga pe sur tai nap̃a Ntewa pisa pan pisape kila, pona Yoane ga sitom sape kila? Amiu avisalia.’” ");
INSERT INTO lww_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ana naviunena kiena ne Yesu nene kila narui apis manene ke sina ga pan la, apisa ke asape “?Yoko tevisa ve sanape na vania? !Tevisuar ruruia! Visae tevisave nakeena nene, Ntewa naga pisa pa Yoane, yoko yar nene viun sina tan ita ne visave ana komin ya ne yepeta mavin lelagaena e Yoane? ");
INSERT INTO lww_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ana visae tevisave Yoane ga sitom sape kila, sa p̃isi yaru la sinela kar ita ana akove ita, komin nap̃a amlelaga m̃arera rui sane Yoane naga pe navisawalena kiena ne Ntewa kemua lelaga.” ");
INSERT INTO lww_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ana sitomena nene kila narui apisatam̃e Yesu asape amninue kare ga narui. ");
INSERT INTO lww_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ana Yesu pisa pan la, sape “Sanene, in m̃ena ga tap̃atete nevisa van amiu ane pisa pan inu sape nekila yum̃aena nene.” ");
INSERT INTO lww_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ana Yesu pisa p̃akaiwa tai pan yeririna la nap̃a asike e poglis nene, pisape “Yerkawa tai, amio kiena lokilkerep tai. Naga sinenan sape yaloro re va e purvanua tap̃ena tai, nap̃a m̃eke laa perina, ana naga mligan kiena lokilkerep nene pa yeririna tap̃ena lap̃asa nap̃a yoko aim ayum̃ae ea, ana aul vania. ");
INSERT INTO lww_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ana yerkawa nap̃ani pa sum̃a gare pano-o, pisu kilale sane nanagane pogos nap̃a mrakerep marua narui. Ana mligan kiena yar tai p̃asup̃e si pa pun la nap̃a asike e kiena lokilkerep nap̃ani, vena war kilavaru na mrakerep komp̃asa nap̃a monar aul vania. Yar nene pano, ana pogos nap̃a m̃alivin la, la pe sinelan re aul poli, ana am̃e kare naga, amligan si naga p̃asup̃ea liman korena ga. ");
INSERT INTO lww_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ana yerkawa nap̃ani mligan si kiena yar tap̃ena pano, ana am̃e m̃ena naga, akila piowa pania pap̃isi, ana am̃enelua p̃asup̃e koren ga pa sina. ");
INSERT INTO lww_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ana yam telu narui, yerkawa nap̃ani mligan kiena yar tap̃ena, ana naga m̃ena ga, am̃ea kulu ga kuruta rui, akoven lua e lokilkerep nene pano. ");
INSERT INTO lww_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ana yerkawa na lokilkerep pisu p̃elaga viowa la ne sanene, mninue kare narui, pisape ‘!Awe! ?Popon nekila ya narui? Pona nanagane monar neligan ga naruu wawa nini narui. Naruu taaga ga nini, nesitom naga pap̃isi, ana visae naga vano monar avisu kilalea, avatanonia.’ ");
INSERT INTO lww_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ana mligan naga pano, a pogos nap̃a yar la nene apisuia, asitom piowa pania. Apisayu sina pan la, asape ‘Nanene na narin yerkawa nene yo. Yar ne na nene narui, nap̃a visae yerkawa nene kovio, naga ke narui nap̃a yoko kus porotano nene sane kiena lalimana. Popon towem̃aria, vena ita ga touarar tano nene ve kieta.’ ");
INSERT INTO lww_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ana asum̃al narui atararia, akovenlua naga pa vanua e lokilkerep nap̃ane, ana am̃em̃aria.” Ana Yesu sape “Suniena nene pimi maro e nini na p̃a rui, ana popon asitomlia. Pogos nap̃a yerkawa mloge sur nene, yoko naga imi kila ve sanapen la nene? ");
INSERT INTO lww_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nevisa van amiu sanini, yeririna viowa la nene, yoko naga imi we mom̃ar la, yoko amarmare e nakoaen m̃arera tai, ana yoko ligan lokilkerep nap̃ani e limana yar lap̃as nap̃a apowo.” Ana poglis nap̃a amloge Yesu pisa sanene, amloge kilale nap̃a visena nene sane pisawan ga sur tai, pisayu sape le Yu lala pe sinelan re naga nap̃a pe narina ne Ntewa poli, ana yoko Ntewa were yar la nap̃a pe ape le Yu re poli akus lelela. Ana sur nene pe sinelan re aloge po, apis m̃arera, asape “Sur nap̃a opisa ke ne, Ntewa monar ve ligan re sur nene imi m̃alivi sanene.” ");
INSERT INTO lww_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ana Yesu kira pisu manene la, piun pisape “Pe sinemiun re poli, ana vanon ya ne asiri visen wa nap̃a pisa sanini, pisape ‘Kilavaru nini, yar na yum̃aenen yum̃a lala asape piowa ga, ana akoven lua pa rui, ana nanagane kilavaru nene pimi pe kilavaru wo tai nap̃a pe na mrapun yum̃a, vena uarar yum̃a m̃arera.’ ");
INSERT INTO lww_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Yeririna make ga nap̃a visae avane kilavaru nene, yoko aloru akove kilavaru nena, siwowa kare yepela lala. A visae vano vano-o tol pogos nap̃a kilavaru nene loru, ana yar a nap̃a kilavaru monoaria, yoko kilamumu kare naga vano-o kovio nenaga.” ");
INSERT INTO lww_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ana navianen navisaluaena lala amio yerkawa kiena ne yar wa lala, apisu kilale p̃akaiwa kiena Yesu nene panon la nena ga, ana sinela kar manene laa narui, asum̃alu asape auarar nena naga e pogos nene. Sinelan manene laa asape akila sur tai vania, ana akila p̃ele ga, komin apisu yeririna la akekaran laa naga. ");
INSERT INTO lww_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kila sanene narui ana silaga asum̃a apisuaria, a lap̃asa apa vinau ga apa lavisinia, akila kokanin ga sa nap̃a alelaga e naga, ana sur nap̃a la akila ke ne, asum̃a ap̃ar make nena kiena visena lala. Kiela sitomena sane sinelan asape alual visena lap̃as nap̃a naga pisa, ana akilia avisawal va yerkawa nae Rom nene P̃aelat, vena naga kilia la nakoaena tai vania sa nap̃a la sinelania. ");
INSERT INTO lww_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","P̃is na pog tai la nap̃a apinaun vena aim lavisin Yesu, apiun naviunena tai tania, sa nap̃a akila kotalia ga naga. Asape “Navianena, mepisu kilale sane kiom̃a visena lala a kiom̃a vianena lala ape lelaga a po pap̃isi. A mepisu kilale sa nap̃a kiom̃a nalip̃ereen yar lala pe peve tap̃ena re poli, nap̃a opisu la maran taaga ga, ko opisawal mesmesun ke mrapa kiena ne Ntewa pan yeririna make ga. ");
INSERT INTO lww_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ana sinemimin mesape meviun tan ko sanini, sane ‘?Kieta navisaluaena pisa sanape? ?Sape mesmesun ita le Yu lala toul takis va p̃arin sup̃e nae Rom, nap̃a Sisa, pona pisape pe mesmes re poli?’” ");
INSERT INTO lww_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ana Yesu pisu kilale sane asape akila kotalia ga naga, ana pisa pan la pisape ");
INSERT INTO lww_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ala narin kilavaru tai imi van inu. ?Avisuli sane marana ne ane teke ea? ?A kia nap̃a asiri teke ea, kia kiena ai?” Apisape “Marana Sisa, a kiena kia m̃ena ga.” ");
INSERT INTO lww_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ana naga pisa pan la sape “Pogaga, sur nap̃a pe kiena ne Sisa, ala va Sisa. A sur nap̃a pe kiena ne Ntewa, ala va Ntewa.” ");
INSERT INTO lww_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","La nene sinelan manene asape atol ruru Yesu e maran yeririna lala e kiena visena tai, ana pogos nap̃a amloge kana navisatam̃eena nena, amilan pap̃isi, apisu sane naga kilam̃ar ruru kiela kap narui, ana apa ruru la ga asikena, pe apisa re si sur tai po. ");
INSERT INTO lww_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ana siraun naga nene, le Satusi lap̃asa, apim puna Yesu, nap̃a sinelan asape aviun tania e lepas na sur tai nap̃a la amlelaga m̃arera ea, nap̃a asape yar la nap̃a amarmare rui, tap̃atete amamal sina e legiena maro. ");
INSERT INTO lww_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ana apiun tania, asape “Navianena, sinemimin mesape meviun tan ko sanini. Sanapen visena tai nap̃a yermarua Mosis siriyu pan ita na nanua sumo. Naga pisape visae yar tai, wenla mare tan wona, nap̃a lalua pe narila re tai poli wa, yokorena wenla nene monar were letano nene ve wona, vena kila sane sira nene kilia war sisi, vena uarar kia kiena ne wenla nap̃a mare mal tom̃a ga. ");
INSERT INTO lww_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pogaga, ana e pogos tai, welelai la olua. Kiela m̃earu p̃ere wona tai, ana naga mare tan wona nap̃ani lalua pe narila re tai poli wa. ");
INSERT INTO lww_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ana wenla na surana naga towe p̃ere sira nap̃ani, ana yoko naga m̃ena mare tania, ");
INSERT INTO lww_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ana wenla m̃ena na telu, kila sa ke ga, akila m̃a sanene pano-o tol wenla maro na olua, la make ga maran taaga ga, nap̃a pe ap̃ar re nena narila tai poli. ");
INSERT INTO lww_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A siraun wona la punu ga nene, sira m̃ena nap̃ani marp̃anu. ");
INSERT INTO lww_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ana ovisali sur nene: ?E legiena maro, pogos nap̃a apisa ke asape yoko yeririna la amamal sina, yoko sira nene ve wona ai, komin nap̃a talopa make amio welelai la olua nene?” ");
INSERT INTO lww_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ana Yesu pisatam̃e la sape “E ga e yomarava nini, yeririna lala asum̃a atatalopa, ");
INSERT INTO lww_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ana la nap̃a Ntewa pisape visae akilia amal si vetan marena vena ava loyum̃a e kiena yo, ve akila re sina. E pogos nene, tap̃atete si atalopa narui, ");
INSERT INTO lww_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","a yoko ve amarmare re sina komin nap̃a aim sa ga navisi la narui. Yoko Ntewa kila amal sina e marena ana avim ave narina ruru nena lala. ");
INSERT INTO lww_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A e lepas namalen si nene, Mosis m̃ena pisayu nanua sumo rui e suniena na purlaki nap̃a kap pivaga ke ea. E nene tepisu nap̃a Mosis pion pa Ntewa na mava sape naga pe Ntewa kiena ne Epraam a Ntewa kiena ne Aisak a Ntewa kiena ne Sekop. ");
INSERT INTO lww_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ana pogos nap̃a Mosis siri visena nene, la telu nene amarmare e yomarava nini nakonua rui, sane amare e yomarava nini, ana amal asike ma puna Ntewa na wa. Ntewa naga pe pe Ntewa kiena ne yeririna re ga la ne amarmare po, ana naga sinenan sape yeririna la nap̃a asike amio, yeririna la nap̃a amali. E navisuena kiena ne Ntewa, yeririna la nap̃a amarmare e yomarava nini rui, la amal ga asike ga wa.” ");
INSERT INTO lww_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ana navianen navisaluaena lala asum̃a amiyagogon navisatam̃eena kiena ne Yesu nap̃a pa le Satusi lala, ana apisu sane manmarua ruru po pap̃isi, asape “Navianena, kiom̃a navisatam̃eena po na po pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Apis sa nene vanon visena kiena Yesu nene kila sane le Satusi lala amaraun nap̃a aviunli si sur la tania. ");
INSERT INTO lww_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ana Yesu pis pan la pa laa sane, piun sur tai tan la, sape “Komin ya ne la apian amiun ke asape Navisaarena naga monar m̃aliv e lus kiena ne yermarua P̃arin Sup̃e Tepet, nap̃a naga pe p̃arin sup̃e p̃esania? ");
INSERT INTO lww_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nepiun nene, komin nanua sumo, Tepet siri e kiena tus na Yauena lala, sape ‘Ntewa na mava pisa pa kiau Sup̃e, sape “Ototano e lum̃au lepas na p̃amarua, ");
INSERT INTO lww_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","otom̃ate m̃a vano-o, yoko neligan kiom̃a nasinekar lala aim ve takue tai na kilavanen lam̃a.” ’ ");
INSERT INTO lww_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Nanene na tepisu sane Tepet pio ke pa Navisaarena sape naga pe kiena Sup̃e rui. ?Ana komin nap̃a Tepet pisa sanene, sanape nap̃a asum̃a apisa ke Navisaarena nene asape yoko molue kome Tepet, naga pe lus nena ga tai?” Ana yam si tai amilan visena kiena ne Yesu. ");
INSERT INTO lww_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ana p̃ina la asike amiyagogon ke ga wa, naga pisawal visena tai, nap̃a pe kiena ne kiena nalogena ga lala. ");
INSERT INTO lww_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Naga sape “Kam na avisuar ruru yar navianen navisaluaena la nene. Asum̃a aplave manene la e m̃ala kulsota viavi la nene, a visave ayaloro e yepesinasa e maran yar lala sinelan asape yar la avatanonla, a avio ruru la asave, ‘!Kee, pokolulagi, ko na ope Navianen tai nap̃a po pap̃isi!’ A e pogos na p̃ap̃agena a loyum̃a e yum̃a na leniena m̃ena lala, sinelan asape atoga e lelen yerkawa lala. ?Kam na apisu kilale narui ne? ");
INSERT INTO lww_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","A la akila kiela leniena la piayavi pap̃isi wa, ana apisokan ke ga ne, komin e ke e pog nene, asum̃a akila kotalia ke ga letano lala, akila kare la. Ana vanon kiela p̃elaga la ne sanene, yoko kiela nakoaena naga m̃arera manene laa sane.” ");
INSERT INTO lww_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ana pogos nap̃a Yesu la asike e yum̃a m̃ana Ntewa, apisu nap̃a yar lap̃asa apimin nap̃a akuan kiela nalaena lala e karo na Yum̃a Wa. Ana Yesu teke pisu ke ne, pisu nap̃a yar na sur moki la apim akuan kiela nalaena wo lala, ");
INSERT INTO lww_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","a siraunia, naga pisu m̃ena letano tai, nap̃a pe kiena sur re poli, pimi kuan kiena narin kururu varu lua ga. ");
INSERT INTO lww_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ana naga pisayu sira nap̃ani pan la, sape “Apisu ke letano nene, nap̃a kuan narin kururu varu lua ga ne? Nevisa sur na lelaga van amiu, sane naga kuan taulu make yar la nap̃a kiela sur moki. ");
INSERT INTO lww_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yar la nene, kiela kilavaru keviu pap̃isi, ana akuan ga narin kinakinas komp̃asa, ana letano nene, narin kilavaru nap̃a mlararia vena ve kiena malena, tam̃an make nena pan Ntewa.” ");
INSERT INTO lww_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ana siraun naga nene, yar lap̃as apisayu ke Yum̃a Wa, asape apisu po pap̃isi, amio kana kilatapili nowo lala, a kana sur tanea la nap̃a ap̃aria pe na vayaia punuen kana kove nena. Ana Yesu mloge m̃a nap̃a asunyu ke sanene narui, naga sape ");
INSERT INTO lww_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“?Kam na apisu sur la nene asape powo liu? Nevisa van amiu sanini, siraunia, e pogos la tai ne pimi ke ne, yoko tap̃atete si kana kilatapili ne tai to ruru si teke e lelena, komin nap̃a yoko yar lap̃asia aim awe plan tetain kare make yum̃a nene.” ");
INSERT INTO lww_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ana pogos nap̃a amloge Yesu pisa sanene, apiun tania, asape “?Ana Navianena, yoko awe plan Yum̃a Wa nene pogwai, a yoko mevisu kile ya nap̃a visawal visave lavisi sur la nene imi m̃alm̃aliv narui?” ");
INSERT INTO lww_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ana pisa pan la, pisape “Kam na popon avisuar ruru amiu, vena ve yar tai imi visa kotalia amiu re, komin yoko yar ve moki nap̃a ala kiau kia, ana aim avisave ‘!In ne nanini nepe Navisaarena nene!’ pona avisave ‘!Nane, kana pogos ne nanini narui!’ Ana ve ataveve la re. ");
INSERT INTO lww_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","A visae e pogos nene, aloge m̃aagena na mara lala, a sur viowa la asike ga lavisi, ana ve sinemiu kurkur manene re. Sur la nene monar am̃alm̃aliv sumo, ana naga nene na pe legiena maro re nene po la wa.” ");
INSERT INTO lww_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ana pisa m̃ena pan la, sape “A p̃arin sup̃e lala, yoko akila sina mara amio p̃arin sup̃e tap̃ena lala, a purvanua lala asum̃alun sina purvanua tap̃ena lala. ");
INSERT INTO lww_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yoko yemninu vap̃isi, a yoko yo kar ga la e yomarava nini pogos na pupia viso vap̃isi a maiena m̃arera lala, a nanene yoko amio m̃ena sur na sine kurkurena a pupia kile lala meta e sinapane. ");
INSERT INTO lww_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ana pogos nap̃a sur la nene pere wa, yoko yeririna la akila ke ne viowa van amiu. Yoko auarar amiu m̃arera, ala magka van amiu, ana siraunia aligan amiu e limana ne li na sumonen yum̃a nalenena, pona akoven amiu ava asike e yum̃a naloge viowaena, pona akila amiu asum̃alu ase marana ne kiela p̃arin sup̃e lala pona kiela nasumonena lala. Sur viowa la nene yoko akusia vanon nap̃a kam na apuarar ke kiau kia m̃arera. ");
INSERT INTO lww_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pogos nene yoko akila m̃arera van amiu vap̃isi, ana yoko imi sa nap̃a kiamiu pulmas na lologonen Lologena Wo van la. ");
INSERT INTO lww_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Ana nagane, pogos nap̃a sur la nene pere ke na wa, ve asitom manene re sane yoko am̃a avisa ya ne e pogos nene, ");
INSERT INTO lww_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","komin nap̃a yoko e nena e kana pogos nena, nela visena na manmaruaena van amiu. Ana pog nap̃a avisa visena la nene van kiamiu nasinekar lala, yoko ataulu la, yoko tap̃atete si avilon kiamiu visena nena. ");
INSERT INTO lww_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Yoko e kana pogos nena, la ga nap̃a kam na apio la ke asape arimamiu pona womla pona p̃apo pona erau, la ne sanene la ke nap̃a yoko aure plan amiu aligan amiu e limana ne yerkawa lala, ana yoko akilapel amiu sanene vap̃isi vano-o kam lap̃asa awe mom̃ar la. ");
INSERT INTO lww_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yoko yar la sinela kar amiu vap̃isi, yoko lap̃asa alamaran si visena van amiu, kam la nap̃a kiau kia sike e amiu. ");
INSERT INTO lww_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","“Ana nevisa van amiu sanini yoko tap̃atete vilp̃arimiu tai yoko kovio lue. ");
INSERT INTO lww_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yoko asum̃al m̃arera asum̃a vano-o ataulu pog m̃arera nene, a e mrapa nena nanene narui, yoko atol kiamiu malena na lelaga ea.” ");
INSERT INTO lww_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","A e lepas na pupia pog m̃arera nap̃a yoko imi, Yesu pisa sina pan la sape “Pogos nap̃a visae avisu p̃egas nen yeririna na kilaen mara lala asum̃al asuwo ke yo yervivi pupia pulkumali nap̃a Yerusalem, nane yoko akilia narui sane pupia kana pog na kilaroroen pimi ke lavis narui. ");
INSERT INTO lww_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","A pogos nap̃a avisu sur nene, kam nap̃a asike Sutea, popon aureure ana atapolou e kunus lala, a amiu nap̃a asike loyum̃a Yerusalem, popon amomolue ana aureure, pona amiu nap̃a asike yom̃arua, ve akilali re si nap̃a ato garo um̃a. ");
INSERT INTO lww_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nanene vanon poglis nene, naga pe pupia legiena na kila maranen sinemimiena kiena ne Ntewa, sa nap̃a nasiriena lala nanua sumo apisaaria. ");
INSERT INTO lww_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","E m̃ena e pogos nene, yoko viowa manene laa va sira la nap̃a m̃ep̃ela, amio m̃ena la nap̃a amla ke yu pa narila lala. E pog nene, yoko naloge viowaena ve keviu vap̃isi e kieta purvanua, a pupia sinemimiena imi va kieta yeririna la nene. ");
INSERT INTO lww_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","A yoko playu na mara kila la ave moki aloloru, a la ve moki nap̃a sen viar limala, aurela ava ayum̃ae korena kiena ne p̃egas nen yeririna tap̃ena lala. Ita le Yu lala yoko yar tap̃ena lala avienena kare kieta pulkumali wa nap̃a Yerusalem, la ave sup̃enia vano-o tol pogos nap̃a Ntewa ga kila sane lala kiela p̃isi narui.” ");
INSERT INTO lww_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","A Yesu pisayu legiena maro, sape “E pogos nene yoko avisu kile lala ma e mrae a e kupario a e verue lala. E yomarava nini, yoko p̃egas nen yeririna lala aloge viowa, asitom kare sur la vap̃isi, a pogos nap̃a avisu sive kululu ve keviu a lapa ke vam metava va ke ura, yoko la aninue kare narui asape m̃a yoko ve sanapen la na wa. ");
INSERT INTO lww_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A pogos nap̃a la avisu kilale ya nap̃a pivim ke e yomarava nini, a pupia sur la nap̃a ma e sinapane kulkulul kar ga narui, yoko sinela kurkur vap̃isi, asum̃a marala malon marauena, a amarmarluia. ");
INSERT INTO lww_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yoko akila m̃a sanene vano-o, avisu inu Narina ne Yeririna nom̃alivi e lul amio kiau pupia nam̃areraena amio kiau pupia naurarena. ");
INSERT INTO lww_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Ana e kiamiu lepasa, pogos nap̃a visae avisu sur la ne sanene asiar am̃alm̃aliv, ve amarau re. Ve asitom re suria, ana asum̃alu awar plan p̃arimiu vena akira va metava, komin nap̃a sur la nene kana kinasa sane kiamiu yaru nawere plan amiuena pimi ke, lavis warpoyo narui.” ");
INSERT INTO lww_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ana Yesu pisayu p̃akaiwa tai pan la e lepas na pogos m̃arera nap̃a pimi ke ga wa, sape “Kam na asitomyuli purpiliva nene pona purlaki tap̃ena nap̃a sanene. ");
INSERT INTO lww_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pogos nap̃a avisu sane korowas la imi memaena, a imi malmalumu, a kana stos la siar miyulua, ana kam na akilia sane pogos na yepisusun pimi ke lavis narui. ");
INSERT INTO lww_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sanene pogos nap̃a avisu kile la nene aim am̃alm̃aliv ke sa nap̃a nepisa pan amiu p̃a rui, yoko akilia sane nasup̃enena kiena ne Ntewa pimi ke lavisin amiu narui. ");
INSERT INTO lww_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Lelaga nevisa van amiu, yoko sur punu ga monar imi m̃alm̃aliv m̃a sanene vano-o p̃isi, ana siraunia, teras na yaru la nap̃a amal ke e pog nene akovio e yomarava nini. ");
INSERT INTO lww_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","A yoko sinapane amio yomarava nini la m̃ena luwoka akovio, ana kiau visena lala tap̃atete akovio pogos tai.” ");
INSERT INTO lww_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ana Yesu mla visena nene pan la e pogos nene, pe visena na wep̃ege laena, sape “Ana e kiamiu lepasa, kam na avisuar ruru amiu. Pe pon re kiamiu malena ve tap̃ena si poli, pona amun manene la kuruta na munena, pona sur kar la ne sanene, a ve kiamiu sitomena su manene re m̃ena ga e sur na yomarava nini la silaga. Visae peraga, yoko asum̃a akila m̃a sanene vano-o ailan ga pupia legiena nene imi m̃alivin amiu veraga sa ga ekarpila. ");
INSERT INTO lww_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Lelaga, yeririna make ga e yo punu ga e yomarava nini, pe asitom̃al re poli, asu wowe ga pe akilia re poli, ana yoko legiena nene imi tol la sa nap̃a manu milan ga p̃eregawa sum̃al maneno sike e naga, marp̃an nenaga. ");
INSERT INTO lww_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ana kam na monar avisuar ruru amiu silaga, monar alen lue ga vena akilia asm̃al m̃arera vena atamalia amiu e sur la nap̃a yoko imi m̃alm̃aliv, vena kila nap̃a akilia asum̃al ase marau Narina Yeririna.” ");
INSERT INTO lww_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ana Yesu sum̃a pian la ke sanene e Yum̃a Wa ko legiena lala, a kolemalo naga petan pulkumali pava ke e Kunus Na Purolip lala. ");
INSERT INTO lww_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","A kolulagi kona lala yeririna lala atavilo koskos, ap̃asup̃e la apa si e Yum̃a Wa vena aloge kiena visena lala. ");
INSERT INTO lww_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ana siraunia, pimi ke lavisin pog nap̃a kas punu ga, la akila kiela pupia p̃ap̃agena lua, sane p̃ap̃agena na kanen kiligap̃e nap̃a pe is re e poli, amio p̃ap̃agena na sitom̃alen natamaliaena. ");
INSERT INTO lww_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","A e pogos nene, yerkawa kiena ne yar wa lala amio navianen navisaluaena lala, asitom ke asape awem̃ar Yesu na wa, ana pe am̃al re mrapa na kilaen poli, komin amaraun nap̃a asape visae akila, pona yeririna la akila sur tai van la yo. ");
INSERT INTO lww_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ana e nena e pogos nene, Yermare pimi pa e sinena Sutas nae Kariot, naga nene la lualima taaga pa lua lala ga tai. ");
INSERT INTO lww_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ana pe yam piavi re nenaga, Sutas sum̃alu, pa m̃alivin yerkawa kiena ne yar wa lala amio yerkawa kiena ne kiela lokul lala, pisawal kiena sitomena nena, ana apisayu mrapa ya nap̃a po, vena yoko kilia vielua Yesu van la. ");
INSERT INTO lww_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ana sitomena kiena ne Sutas nene kila amloge po pap̃isi, ana la apisu sane popon ala kilavaru tai vania vanonia. ");
INSERT INTO lww_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ana Sutas kekarania, a siar e pogos nene, silaga naga sum̃a kale ke kiena pulmas tai nap̃a visae ve yeririna re lala, ana naga kilia vielua Yesu van la. ");
INSERT INTO lww_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ana apim tol legiena na siaren p̃ap̃agena na kanen kiligap̃e nap̃a pe is re e poli, nap̃a e m̃a nena e legiena nene monar akila kup̃ap̃aena na narin sipsip lala vena sitom̃alen natamaliaena. ");
INSERT INTO lww_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ana Yesu pisa pa Pita amio Yoane, sape “Nevitetalia amlua ava gare, vena akila ruru make sur lala na kinanena na p̃ap̃agena nene.” ");
INSERT INTO lww_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ana lalua apiun tania asape “?Ana ko na sinom̃an ke osape meva mekila ruru e nape ne?” ");
INSERT INTO lww_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ana Yesu sape “Kamlua ava atol pupia pulutava nae Yerusalem, ana pogos nap̃a avaliga loyum̃a ea, alual yar tai nap̃a kus ke pupia piawi tai imi vitawe amiu. Ana ataveve avano, yoko naga were amiu ava e yum̃a tai. ");
INSERT INTO lww_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ana pogos nap̃a ava loyum̃a, avis va p̃ar na yum̃a nap̃ani, avisave ‘Kieta Navianena piun sape, ?Awa m̃amimi yum̃a imimi wolawa lala, vena mekilia mese ea makan kinanena nasitom̃alen natamaliaena nene ea?’ ");
INSERT INTO lww_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kamlua avisa ve sanene vania, ana yoko naga kipian amiun pupia lele tai metava, nap̃a sur make sike pa e rui, ana yoko akila ruru make sur na kanen la e yo nene.” ");
INSERT INTO lww_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ana Yesu pisa pa sanene pa nalogena lua nene narui, lalua apano, ana apisu sur la punu ga pimi m̃alivi sa ga nap̃a naga pisa ruru p̃esan kemua pan la rui. Sanene narui, lalua akila ruru kinanena maro kana Yesu. ");
INSERT INTO lww_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ana siraunia Yesu la apa meta e yo nap̃ani, ana pog na kinanena, Yesu totano e lelen kinanena, ana li na lologena lala apim atotano amio. ");
INSERT INTO lww_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ana Yesu pisa pan la sape “Na nanua rui, in na nesitom m̃a kata kinanena nasitom̃alen natamaliaena nene. Na nene kau kinanena maro nini, nap̃a ita ga tekinana lele taaga, ana siraunia, nekilia neva ga e kiau pog m̃arera na wa. ");
INSERT INTO lww_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nevisa van amiu sanini, kilaparavi nini kana kinas pisayu natamaliaena. Ana yoko in na ve nakan re si narui, vano vano-o tol pogos nap̃a kiau natamaliaena imi m̃aliv e yomarava nini, e pogos nap̃a nasup̃enena kiena ne Ntewa imi.” ");
INSERT INTO lww_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ana naga mlarar piala tai, pisa potenan pa Ntewa, ana pisa pan la, sape “Ala nanini, ataron werewere van amiu, amunia. ");
INSERT INTO lww_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nanene komin nap̃a siar nanagane, in na yoko ve nomun re si kuruta na munena, vano-o tol pogos nap̃a nasup̃enena kiena ne Ntewa imi.” ");
INSERT INTO lww_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ana naga mla kala kilaparavi tai, mlenin pisa potena pa Ntewa, kawewowaia pisape “Naga nini tasneu ne, nap̃a netam̃an pan amiu. Ana yoko kam m̃ena ga monar akila ve sanene, sa nap̃a kiamiu nasitom̃alinena.” ");
INSERT INTO lww_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ana siraunia, pogos nap̃a akinana pae, naga kila ke sina sa nap̃a kila e kilaparavi sumo, mla piala na munen tai, pisape “Piala nini naga sane kile na kau kuruta nap̃a yoko lau vanon amiu, vena visirluaen naviranarena viu kiena ne Ntewa amio amiu. ");
INSERT INTO lww_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ana sur viowa tai, yar nap̃a yoko vielua inu, naga ita ga tai nap̃a tekinana ke lele taaga nagane. ");
INSERT INTO lww_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yoko inu Narina ne Yeririna monar nemare ve sa nap̃a apisaar kemua nanua sumo rui, ana yar nap̃a yoko vielua inu, sineu miye ke nagane, yoko viowa manene vania!” ");
INSERT INTO lww_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ana pogos nap̃a amloge, asum̃a apiuviun tan la asape akilali nap̃a alual lala ai nap̃a sitom ke sape kila sanene, ana pe am̃al re poli. ");
INSERT INTO lww_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ana e pogos nene, veveyuen tai molue likan nalologena lala, sape lala ai nap̃a yoko la monar avisu naga sane naga to laa metavan la sane, ve kiela nasumonena. ");
INSERT INTO lww_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ana Yesu mloge, pisa pan la, sape “Ita tekilia p̃elaga kiena ne yerkawa na yomarava la nini rui. P̃arin sup̃e lala la ape navisuaren kiela yeririna lala, a nasumonen lala, yar la monar avatanon la, ala kia nap̃a tometava van la, avio la avisave ‘yar navisuar itaena.’ ");
INSERT INTO lww_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ana kam na kiau nalogena lala, monar ve akilali re sa nap̃a aim ave yerkawa na yomarava nini. Kam yar tai nap̃a pona apisa ke asape naga pe yerkawa, yoko monar imi ve tokakin amiu, sa nap̃a pe pras maro. Kam yar tai nap̃a sape naga ve kiamiu nasumonena, monar imi ve sa yar na iila amiuena. ");
INSERT INTO lww_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“E pogos na kinanena, yar tai naga tom̃a ga sane kikinan ga, a yar tap̃ena nap̃a p̃ar ke kana kinanena pimi pania. Ana lalua nene apisu sane ane pe yerkawa, naga mon manene laa metava? Lelaga kam akilia m̃aga, ana in na pe sa re naga po, in na nepitom e yomarava nini sane naga nap̃a kila yum̃aena, miila yar tap̃ena lala a kila po pan la.” ");
INSERT INTO lww_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ana Yesu pisa pan la, sape “Kam nene, nepisu amiu sane kam na sane amiilar inu po e pog m̃arera la nap̃a netolia, pimi tol nanagane. ");
INSERT INTO lww_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ana sa nap̃a arimau mligan inu nepe sup̃en kiena yo, in m̃ena nevisa van amiu sanini nevisir plan amiu aim ave narin sup̃e lala e kiau yo la nene. ");
INSERT INTO lww_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Sanene, yoko kam ke narui kam nap̃a yoko ato si tano amio inu, tekinana lele taaga loyum̃a e kiau nasup̃enena, a yoko kam m̃ena atotano e lele na totanoena nap̃a mon metava vena visuaren lus lualima taaga pa lua nene nae Israel.” ");
INSERT INTO lww_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ana Yesu pis amio Saemon Pita, sape “Ake Saemon, ovisuar ruru ko. Yermare sinen kar amiu, sinenan sape kila kare amiu vap̃isi, ana Ntewa tam̃an rui sape yoko naga kilali amiu ve tokak ga, kilia lip̃ere nap̃a po vetan nap̃a piowa. ");
INSERT INTO lww_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ana in na nemlenwo amiu ke rui, in na nom̃areran ko ke e kiau leniena nesape visae ko na ve sanape, ana yoko kiom̃a naviawaena tap̃atete loru makea. A siraunia visae ko na oim owo ruru sina, owasup̃e ko oimi, yoko ko na oim ove yar tai nap̃a silaga okila womla lala aviawa m̃arera manene laa sane.” ");
INSERT INTO lww_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ana Pita pisatam̃e Yesu, sape “Sup̃e, visae akoven ko ova e yum̃a nakoaena, yoko in na nemio ko woga ga. Pona akila m̃a van ko vano-o ova otol marena, ana in m̃ena nekekaran ga nap̃a italua.” ");
INSERT INTO lww_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ana Yesu pisa pania, sape “Pita, nevisa sur na lelaga van ko, sane yemalo ga nini, ve lakaporo kokoreko re wa, yoko ovisa kotalia inu yam ve telu, ovisave ko na omninue in nena ga.” ");
INSERT INTO lww_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ana Yesu piun tan la, sape “Kam na asitom̃al ke nanua ne, pogos nap̃a nemligan amiu apa amlologo kar ga e yo la nene. In na nepisa pan amiu nesape ve awar re sur lap̃as amio amiu, sane taga na varu, pona karo, pona kulus nen lamiu tap̃ena, pona sur la ne sanene. ?Ana sanape, kam na apisu limamiu plasan sur lap̃as, pona peraga?” Ana apisatam̃ea, asape “Sup̃e, pe limamimi plasan re sur tai poli.” ");
INSERT INTO lww_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ana Yesu pisa pan la, sape “Lelaga, naga ke narui. Ana nanagane, tesike e pog tap̃ena nini narui. Nanagane, yar nap̃a kiena taga na varu, pona kiena karo tom̃a ga, yoko warar vano. Yar nap̃a pe kiena playu na mara re poli, popon wilwilin lua m̃ana kulkota ana la kana kilavaru, va ul kiena playu na mara tai. ");
INSERT INTO lww_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","In na nepisa nene pan amiu, komin nasiriena wa nasumo lala nap̃a la apisayu inu, apim am̃alm̃aliv ape lelaga narui, pano-o tol visena nap̃a Aisea pisa, nap̃a sape ‘Akila pania sa ga naga m̃ena pe yar viowa ga tai nap̃a kilakilaro ke navisaluaena.’” ");
INSERT INTO lww_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ana nalogena lala asum̃a asitom veve ke ga visena kiena Yesu e lepas na playu na mara nene, ana asape “Sup̃e, opisu ke ne, nanini kieta playu na mara lua nini.” Ana Yesu pisu sane la pe akilia ruru re kiena visena poli, ana sape “E, tepisayu sur nene torok narui.” ");
INSERT INTO lww_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ana Yesu la amligan yo na ma metava nene, ana sa nap̃a kilakila ke ne, naga mialoro pa tol Kunus Na Purolip lala, naga amio kiena nalogena lala. ");
INSERT INTO lww_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ana pogos nap̃a atol yo nap̃a Yesu pava ke ea, amap ea, ana pisa pan la, sape “Kam na monar alen silaga, vena nakilaliena lala ve akila amiu re aloru.” ");
INSERT INTO lww_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Naga pisa pa sanene pan la, ana mligan la, pa laa perinan laa sane, ana kinai mlen pa Ntewa. ");
INSERT INTO lww_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Naga mlen sanini, sape “Awis Ata, visae okilia okila woga ga, olalua piala na loge viowaena nene vetan inu ve nomun re. Ana ve okila re kiau nasinenanena, okila ga sa nap̃a kiom̃a.” ");
INSERT INTO lww_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ana e poglis nene Yesu mloge urmi pan pap̃isi, ana apisu navisi tai mligan ma e peni pitomi tano, pitomi miila naga vena naga m̃arera sina. ");
INSERT INTO lww_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ana Yesu sum̃a mloge piowa pap̃isi, sitom p̃ele narui ana mlen m̃arera laa sane, mlen m̃a pano-o kana ninena sigariga sane kuruta kekapili e porotano. ");
INSERT INTO lww_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ana pogos nap̃a mlen pae, sum̃al sina, p̃asup̃e si pa puna nalogena lala, ana pisu nap̃a nasineyeena m̃e la rui, amiyum̃aen ke ga momalena narui. ");
INSERT INTO lww_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ana naga pis malum kilap̃ege la, sape “?E, amomalion ke ya ne? Popon asum̃alu, akila ve sa nap̃a nepisa pan amiu rui. Kam na monar alen vena nakilaliena lala ve aim re akila amiu aloru.” ");
INSERT INTO lww_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ana pogos nap̃a Yesu pis ke pan la wa, apisu ga pupia p̃egas nen yeririna tai apim akaten la, apisu nap̃a yar tai sumon la apim ke lavis narui, nanene na lala yar ga na sumo tai, nap̃a Sutas. Ana Sutas mial pimi lavisin Yesu, kutararia ana mun pipina. ");
INSERT INTO lww_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ana Yesu pis p̃esan pania sape “Sutas, omun pipiu sanene na pogaga, ana komin ya ne osape owilwilin inu Narina ne Yeririna e mrapa na sanene?” ");
INSERT INTO lww_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ana la nap̃a ape kiena ne Yesu nap̃a asum̃alu asike lavisinia apisu kilale ya nap̃a Sutas la asape akila, la apiun tan Yesu, asape “?Sup̃e, sanape, tete la e kieta playu na mara lala?” ");
INSERT INTO lww_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ana Yesu pe pisatam̃e re poli wa, ana nalogena tai sum̃alu, p̃erelua kiena playu na mara, mligan pan tai tea, nap̃a naga yar kiena ne p̃arin yar wa, ana tetereria ga, telua kiligana na p̃amarua pano. ");
INSERT INTO lww_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ana Yesu pis pania, sape “!E toko! Ita ve tekila re si sanene van la.” Ana naga tol si lelen kiligana yar nene, kila ruru sina. ");
INSERT INTO lww_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ana kira pisu yerkawa kiena ne yar wa lala amio yerkawa kiena ne lokul lala na yum̃a m̃ana Ntewa, amio nasumonena tap̃ena kiena ne le Yu lala, nap̃a la m̃ena apiminia, pis pan la, sape “?Sanape na ap̃ar kiamiu playu lala a kiamiu plaki la sanene? ?Pona kam na asitom ke asape in na yar tai nap̃a nepinau m̃arera pona nom̃em̃e yaru? ");
INSERT INTO lww_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nanua sumo, e legiena punu ga, in na nesisike nemio amiu e Yum̃a Wa silaga pano-o, ana komin ya ne kam na pe apim re lavisin in poli vena atarar inu e pogos la nene? Ana nepisu sane kam na ape yar na yemalolo, nap̃a apim amio nam̃areraena na yemalolo tap̃ena lala, a nanagane kiamiu aora nena napo.” Ana apim atarar Yesu ap̃ere pano. ");
INSERT INTO lww_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ana atarar Yesu, ap̃ere p̃asup̃e amio la apano, apa loyum̃a e kove kiena ne p̃arin yar wa. Ana Pita m̃ena mial tapolou ga taveve la e pogos nene, pe pa re lavisin la poli. ");
INSERT INTO lww_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ana pogos nap̃a apim loyum̃a e kove nene, lap̃asa apa akila kapi pivaga vena ategania, ana Pita m̃ena pa totano amio la. ");
INSERT INTO lww_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ana la asum̃a narui kapi pivaga tegoli marana Pita, ana sira m̃ee na yum̃aena tai nap̃a naga sike amio la, naga pisu kilalea, sape “!E, avisulia! Yaru nene, naga m̃ena lala yar tai nap̃a silaga taveve yar nap̃ani!” ");
INSERT INTO lww_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ana Pita pirovia, sape “!Peraga, vineu! Nepisa ruru ke na pan ko ne, in na pe nekilia re yar nene poli.” ");
INSERT INTO lww_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ana pe piavi re poli, yar tap̃ena kira pisu Pita, pisu kilalea, sape “E, ko m̃ena tai nene nap̃a.” Ana Pita pisatam̃ea, sape “Peraga, mara.” ");
INSERT INTO lww_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ana asum̃a ga aora si taaga p̃arovia, tap̃ena pimi pilagan manene ke sina ga pan la, sape “Nevisa ruru van amiu, yar nene naga miaialor kemua amio yere Kalele nene nanua rui. !Apisu ke ne, naga m̃ena pe yere Kalele ruru nena napo!” ");
INSERT INTO lww_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ana Pita pisatam̃ea, pisa kotalia la ke sina ga sape “Peraga, nemninue nena sur na opisa ke ne.” Ana pogos nap̃a Pita pisa ke visena nene wa, lakaporo kokoreko. ");
INSERT INTO lww_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ana pogos nap̃a lakaporo kokoreko, Sup̃e pilon p̃arina kira pimi pisu manene Pita. Ana Pita sitom̃al si visena kiena ne Sup̃e nap̃a pisawal p̃esan pania, nap̃a sape “Nevisaar nena van ko, e yemalo na legiena ga nene, pogos nap̃a lakaporo pe kokoreko re poli wa, ana yoko oviro inu yam ve telu narui, ovisave ko na omninue in ga.” ");
INSERT INTO lww_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ana Pita mloge piowa pap̃isi, pa vanua, tagi na tagi. ");
INSERT INTO lww_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ana la nap̃a atarar ke Yesu e pogos nene akila piowa pania, apisa karea, asuia, ");
INSERT INTO lww_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","akila m̃a pano-o apiwo marana vena ve kirava re sina, ana pogos nap̃a asum̃a amlipa ke naga, apiai pania apiun tania asape “Ei, apisa ke asape ko navisawalena tai, a ko ovisawal lia, ane mlipa ko ga na wa.” ");
INSERT INTO lww_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ana akila m̃a sanene panpano-o, apisa kare naga pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Asum̃a ga sanene pano-o mrae pa metava, ana nasumonena kiena ne le Yu lala, sa nap̃a pupia yerkawa wa lala amio navianen navisaluaena lala, apim lele taaga e kiela pupia kumali. Pogos nap̃a apim pa e lele taaga narui, ap̃ere Yesu pa sum̃al se marala. ");
INSERT INTO lww_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ana apis pania, apiun asape “Visae ko ope Navisaarena kemua lelaga, nap̃a le Yu lala akiravan ke asape yoko naga monar imi, sinemimin mesape ovisawal ruru van imimi nanagane.” Ana Yesu pisatam̃e la, sape “Nekilia nevisawal van amiu, ana visae nevisa, pona tap̃atete akekaran nap̃a alelaga e yo. ");
INSERT INTO lww_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A sineun nesape in m̃ena neviun sur lap̃as tan amiu, ana visae neviunia, yoko kam na tap̃atete m̃ena avisatam̃e yo. ");
INSERT INTO lww_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ana sur tai nap̃a in na nekekaran nesape nevisawal van amiu, nevisa sanini, nesape ‘Siar nanagane, yoko ve sa nap̃a Tusi Wa pisa rui, nap̃a sape yoko Narina ne Yeririna va totano ma metava e lepas na p̃amarua puna ne Ntewa na pupia nam̃areraena.’” ");
INSERT INTO lww_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ana pogos nap̃a amloge visena nene, apiun tania, asape “!Ke, ya ne sa nene! ?Opisa ke osape ko ke nap̃a ope Narina Ntewa narui?” Ana Yesu pisatam̃ea sape “Naga ke narui, sane apisa ke ne.” ");
INSERT INTO lww_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ana pogos nap̃a la asum̃a apisu nap̃a Yesu pisa ke sape naga pe Narina ne Ntewa, sinela mimi, apisa sanini, asape “Yar nene pisa sanene, tepisu kilale ruru sane pupia veveyuena m̃eke ga e naga rui. Yoko ve takale re si yar tap̃ena la kiena visena imi visawalia, naga kiena visena ga mlip̃ere sina naga rui.” ");
INSERT INTO lww_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ana li na kumali kiena ne le Yu lala, amloge pa visena kiena Yesu rui, ana asum̃alu akuspran la e pupia p̃egas tai, ap̃ure Yesu pa sum̃al se marana ne P̃aelat e kiena lele nalip̃ereena. ");
INSERT INTO lww_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ana apis pa P̃aelat, apisawal sur la mok pap̃isi pania nap̃a apisayu Yesu. Asape “Yar nene, naga sum̃a kila kare ke sitomena kiena ne yeririna lala e kiamimi purvanua, sum̃a pisalup̃ar la ke sape ve aul re si takis va kiom̃a yerkawa nene, P̃arin Sup̃e Sisa nae Rom, a naga ga sum̃a pisirlua ke naga sape kus kia nap̃a Navisaarena, kila sane naga ve kiamimi p̃arin sup̃e keviu. Sur la nene, imimi na mepisu nena e kilamaramimi.” ");
INSERT INTO lww_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","P̃aelat miyagogon pae kiela visena, ana piun tan Yesu, sape “Ko towe ovisali kiom̃a. ?Lelaga kemua nap̃a ko ope p̃arin sup̃e kiena ne le Yu lala, pona peraga?” Ana Yesu pisatam̃ea, sape “Naga ke narui, nane opisa ne.” ");
INSERT INTO lww_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ana P̃aelat miyagogon visena kiena Yesu, ana pe m̃al re nap̃a naga kila sur tai piowa po, ana pisa pa pupia yar wa lala amio kiela yeririna lala, sape “Yar nene, e kiau navisuena, naga mesmesu ga, naga pe kilaro re navisaluaena tai poli.” ");
INSERT INTO lww_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ana la pe sinelan re logen visena kiena ne P̃aelat nene poli, ana la akila ga sane sur na vitap̃ilena, am̃areran manene pania, asape “Peraga, yar nene na piowa ga. Naga sum̃a miyuyur kare sitomena kiena kiamimi yeririna lala, a sum̃a mlologo ke pan la e yo kar ga la ne e yo punu ga, siar gar Kalele, pimi p̃ar make yo Yutea, pimi tol pupia pulkumali nene rui.” ");
INSERT INTO lww_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ana pogos nap̃a P̃aelat mloge asape Yesu siar kiena yum̃aena gar Kalele, piun sape naga pe yere Kalele naapo pona peraga. ");
INSERT INTO lww_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","P̃aelat piun sanene komin naga pe pisuar re lepas nae Kalele po, ana p̃arin sup̃e tap̃ena nap̃a Erot naga pisuar ke yo nene, a pogos nap̃a apisawal pa P̃aelat asape Yesu naga nae Kalele, naga pisa pan la sape yoko monar aure naga va m̃alivin nena P̃arin Sup̃e Erot e kiena lepasa. Ana e pogos ke nene, ana Erot m̃ena pimi mialiali ke Yerusalem rui, ana ap̃ere ga Yesu apa apisuia. ");
INSERT INTO lww_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ana pogos nap̃a P̃arin Sup̃e Erot pisu kilale sape Yesu nene, kekarania komin nap̃a mloge pa kiena suniena rui, kila sane nakonua rui naga sinenan sape visuia ana peraga, ana naga sitom ke sape nanagane narui, pona visu Yesu kila kile tai van yo. ");
INSERT INTO lww_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ana naga sunli amio Yesu, piun veve sur la mok pania, ana Yesu pe pisatam̃e re poli, tom̃a ga sane, pe pis re poli. ");
INSERT INTO lww_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ana e pogos nene, pupia yerkawa wa lala amio navianen navisaluaena lala, la m̃ena asum̃al asike ga lavis, apis keviu apisasawal ke sur lala e lepas kiena ne Yesu. ");
INSERT INTO lww_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ana sur la nene akila Erot amio kiena yar na mara lala pe sinelan re si Yesu po, akila piowa pania, apisalele karea p̃isa. Siraunia amiyen kulmrae nowo m̃ana ne p̃arin sup̃e ea, vena avitalia, ana akila m̃a sanene pano-o, yoko Erot mligan si p̃asup̃e pa pa P̃aelat vena visuvevea. ");
INSERT INTO lww_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ana sumon sur la nene, lalua nene P̃aelat amio Erot lalua ape erau viowa ga, ana siar e poglis nap̃a lalua amiyum̃ae si lele taagan lip̃ereen Yesu, ana p̃ere si lalua apim ape erau wo sina. ");
INSERT INTO lww_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ana ap̃asup̃e la si apim e yo kiena P̃aelat, ana naga pio viraviran pupia yerkawa wa lala amio sup̃e lala a yeririna lala sape aim avisuia. ");
INSERT INTO lww_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ana pogos nap̃a apim loyum̃a, pis pan la, sape “Nap̃a ap̃ere p̃esan yar nene pimi sum̃al se marau, kam na apisawal asape naga pilon kare lue ga sitomen kiena ne kiamiu yeririna lala. Ana nepiun sur lap̃as tania, sa nap̃a kam na amloge, ana in na pe nom̃al re sane naga kila sur la nap̃a apisa poli, nom̃al sane naga mesmesu ga. ");
INSERT INTO lww_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ana nemligan pa pa Erot pisuvevea, ana Erot pe m̃a re sur tai e poli, ana mligan sina pimi pan inu. Pogaga, kiau nalip̃ereena naga sanini, sane naga pe kila re nena sur tai nap̃a monar maren poli. ");
INSERT INTO lww_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Visae sanene, yoko in na nekila ga sanini vania, nekila ga nap̃a awea, yoko aligan si vano, kilia wasup̃e si va e kiena yo.” ");
INSERT INTO lww_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ana komin nap̃a e pogos nene naga pe pogos na kilaen pupia p̃ap̃agena kiena ne le Yu lala, asitom ke asape sa nap̃a P̃aelat naga kila ke silaga, yoko naga monar ligan lua si yere Yu tai nap̃a apuarar m̃eke e kiena yum̃a na loge viowaena. ");
INSERT INTO lww_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","19","Ana poglis nene lala yar tai nap̃a P̃aelat p̃uarar ke ga wa, naga yar nap̃a P̃arap̃as, nap̃a nanua sumo, naga p̃ere yar tap̃ena lap̃as akila sur piowa tai gar Yerusalem pa yar na kilaen mara lala nae Rom, am̃e mom̃ar la, ana P̃aelat koven pa e kiena yum̃a na loge viowaena. Ana pogos nap̃a apisu sane P̃aelat sinenan sape ligan lua si Yesu molue, apion manene pania, asape “Toko, toko! Imimi na sinemimin ga P̃arap̃as wasup̃e si imi van imimi. Yar nene, mesape olalua ga kiena malena.” ");
INSERT INTO lww_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ana P̃aelat yepen mavi, naga sinenan sape Yesu na molue koren ga sa ga ne va si vanua, ana kilali nap̃a pis sina ga pan la. ");
INSERT INTO lww_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ana la ato ga metavania, apionia asape “!Osuaria, osuar e laki torovia!” ");
INSERT INTO lww_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ana P̃aelat pis pan la yam telu narui, sape “?Ana komin ya ne, naga kila ya ne piowa? In na nepisuveve make sur la rui, ana pe nom̃al re sur tai piowa teke e naga po, nap̃a naga kilia marenia. Yoko nekila awe ga naga, yoko aligan si wasup̃e va um̃a.” ");
INSERT INTO lww_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ana la apisatam̃e si P̃aelat, apion manene laa pan sane, am̃areran asape Yesu na monar va e lak torovia, ana akila m̃a sanene pano-o atauluia. ");
INSERT INTO lww_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ana yokorena P̃aelat mla kiena nalip̃ereena, pisawal pisape naga tam̃an ya nap̃a la apiunia. ");
INSERT INTO lww_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yar nap̃a sike e yum̃a naloge viowaena komin p̃elaga na kilaen mara amio p̃elaga na wem̃aren yaru, P̃aelat tam̃an naga molue si pa pan la, sa nap̃a la apiunia. Ana e lepas kiena ne Yesu, naga pisawal sape yoko kiena yar na mara lala akila vania ve sa nap̃a le Yu la sinelania. ");
INSERT INTO lww_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ana la ap̃ere Yesu pavini, amiyal apa e lele na suaren naga e laktorovia. Poglis nap̃a apa ke narui, am̃al yar tai pa yom̃arua p̃asup̃ea, yar nena naga Saemon nap̃a nanua sumo naga nae Saerin, ana am̃areran asape naga kus laktorovia kiena ne Yesu, ana amligan e purkaunena, ana taveve Yesu vavini. ");
INSERT INTO lww_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Amiyal apa ke sanene, ana poglis nene yeririna tap̃ena m̃ena la mokliu nap̃a ataveve ke Yesu, nap̃a sira la moki, nap̃a asum̃a atagililue amio pupia sineyeena. ");
INSERT INTO lww_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ana Yesu mloge m̃a kiela visena na loge viowaena lala, ana kira p̃atau pisu la, pis pan la, sape “Sira re Yerusalem lala o, ve atagin in re si sanene. Visae sinemiun tagena popon atagin amiu ga, pona narimiu lala. ");
INSERT INTO lww_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nepisa sanene pan amiu, komin nap̃a pog m̃arera tai pimi ke ne nap̃a yoko yar la ne asuwal pog nena yoko avisa sanini, avisave ‘!Visae sira la ve kala sisi re ga rui! A wo manene laa sane visae ve awar re sisi la ne amun ke yu ne, komin e pogos nene yoko m̃arera manene laa van ita temio narita lala.’ ");
INSERT INTO lww_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“A yoko pog nene imi viowa manene laa van la vano-o asum̃alu atag va tavie lala a kunus la avisave ‘Awis, aloru akoar imimi, akove mom̃ar imimi, asinwo imimi.’ ");
INSERT INTO lww_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Monar avisuar ruruia, komin nanagane na lak memaena ke ga wa ana akila ke m̃arera manene pan inu rui, ana siraunia va m̃a sanene vano-o visae lak imi mano pae, yoko akilia akila viowa manene laa sane van amiu.” ");
INSERT INTO lww_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ana e poglis nene, apuarar ke m̃ena yar lua nakilaroen navisaluaena, ana ap̃ere lalua nene amio Yesu, vena awem̃ar la amio naga. ");
INSERT INTO lww_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ana amial m̃a apano-o, apa atol kana yo nene, yo tai nap̃a apio asape “Yo na puriu na p̃arin yaru.” Ana la atarar Yesu, asuar naga e laktorovia, apisirlua su lika, ana asuar yar na mlamulena viowa lua nene, apisirlua la tai se p̃amarua a tai se p̃am̃eli. ");
INSERT INTO lww_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Sa nene narui, Yesu telan m̃eke e lak torovia, ana pis pa Ntewa, pisape “Ata, awis oviewo la nene. La pe apisu kilale re sur na akila ke ne poli.” Ana siraunia li na mara la asum̃a ga, akila sur sa nap̃a amlil m̃apila, vena lualen lala ane yoko war kulmrae m̃ana Yesu tai, a ane war tai. ");
INSERT INTO lww_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A yeririna tap̃ena la asum̃alu asike laa perina, asum̃a apisuar ke ga, ana kiela nasumonena lala apis piowa pa Yesu, apisa karea, asape “Akira avisu yar nap̃a! Asape naga tamalia yar tap̃ena la mok rui, ana nanagane na sanape? Asape naga pe Navisaarena kiena ne Ntewa, pona naga pe yar tanea tai nap̃a Ntewa mligan pimi. Visae sanene, popon tamalia towe laa naga narui!” ");
INSERT INTO lww_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ana yar na mara m̃ena lala apisa karea, apim akian kuruta namunena nap̃a melkalka pania vena munia, ");
INSERT INTO lww_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","asape “!Visae ko ope p̃arin sup̃e kiena ne le Yu kemua la lelaga, sa nap̃a apisa ke ne, popon otamalia ko nanagane!” ");
INSERT INTO lww_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A e pogos nene asiri navisakilaleena tai, asuar to meta e laktorovia to metavan p̃arina ne Yesu, nap̃a sape “P̃arin Sup̃e kiena ne le Yu lala.” ");
INSERT INTO lww_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ana e pogos nene, lalua nap̃a atelan la asike meta e lak torovia amio Yesu apis pania. Tai pis piowa pania, sa ke tap̃ena lala, sape “?Ko ope Navisaarena nap̃a, po peraga? !Popon ovitap̃ilin otamalia ita!” ");
INSERT INTO lww_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ana tap̃ena pis pania pisalup̃aria, pisape “M̃ara, nanagane kieta pogos na marena narui, ana ko na pe opatanon re Ntewa poli wa. Ita telu nini, nalip̃ereena nap̃a akila pan ita naga taaga ga, ");
INSERT INTO lww_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","a e lepas na ita lua, mesmesun ga napiowaena nap̃a ita lua tekila, ana e lepas na puna, naga pe kila re nena sur tai poli.” ");
INSERT INTO lww_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ana pis pa Yesu, piun tania, sape “Yesu, pogos nap̃a oim ove p̃arin sup̃e owasup̃e ko sina, awis, ve sinem̃a p̃esan in re.” ");
INSERT INTO lww_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ana Yesu pisatam̃ea, sape “Nevisaar van ko, legiena ga na p̃ane, yoko italua tesike e kieta yo wo.” ");
INSERT INTO lww_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nanagane pimi tol kolpae narui, a siar e pogos nene mrae tego re si po, kila narui yemalolo kalo make ga yo nene, mon m̃a sanene pano-o tol mrae telu yepekilavi. ");
INSERT INTO lww_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ana siraunia, kulmrae nap̃a telan m̃eke loyum̃a e Yum̃a Wa m̃ana Ntewa, nap̃a kilawo yo wa nap̃a pe yo wa pap̃isi, naga purp̃a lepas lua. ");
INSERT INTO lww_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ana e pogos nene, Yesu pio maro sape “Ata, neligan ninuu e lumom̃a.” Pio sanene narui, ana p̃ere maron kiena yalua marp̃an top. ");
INSERT INTO lww_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ana pogos nap̃a yerkawa kiena ne yar na mara lala pisu sur la nene, naga pisirlua kia kiena ne Ntewa, sape “!Lelaga nap̃ane, yar nene naga pe yar mesmes ga nap̃a!” ");
INSERT INTO lww_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","A p̃ina la nap̃a apim lele taaga e yo nene, la m̃ena apisu make sur la nene nap̃a akila pa Yesu, pe nasineyeena pan la pap̃isi. Ana siraunia ap̃asup̃ela sina, amial apano amio pupia naloge viowaena, apa si m̃ala um̃a lala. ");
INSERT INTO lww_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","A p̃egas nen yeririna tap̃ena m̃ena lala asike e pogos nene, la asum̃alu asike laa perina sane, asum̃a apisu make sur lala. Naga nene erau kiena ne Yesu lala amio sira la nap̃a amolue gar Kalele nakonua rui, ataveve m̃a Yesu pano-o pimi tol yo nene, ana la m̃ena apisu marena kiena ne Yesu. ");
INSERT INTO lww_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ana yar tai, naga nae pulkumali kiena ne le Yu la nap̃a Arimatea, kiena kia Yosop. Naga pe yerkawa tai na pupia kumali kiena ne le Yu lala gar Yerusalem, pe yar mesmes tai nap̃a kiena p̃elaga po pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Naga tai nap̃a sinenan manene sape popon sa nasup̃enena kiena ne Ntewa imi, ana nanua pogos nap̃a apisayu ke asape akila ya ne va Yesu, naga taaga kiena sitomena pe sa re nene poli, naga kilali nap̃a pisalup̃ar la sape ve akila re viowa vania. ");
INSERT INTO lww_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ana pogos nap̃a mloge asape Yesu mare rui, naga pa sum̃al se marana ne P̃aelat, piun tania sape kilia kus tasnena ne Yesu. ");
INSERT INTO lww_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ana P̃aelat tam̃an pania, ana pa kuslua tasnena ne Yesu e laktorovia, mliluar e kulmrae, kus pa mligan ruru m̃eke loyum̃a e puluve viu tai nap̃a ate mare ga na wa, pe amliganli re yar tai m̃ene poli wa. ");
INSERT INTO lww_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ana legiena na marena kiena ne Yesu nene naga e Praere, sa nap̃a pe legiena na kila ruruen sur lala na Legiena Wa. Ana mrae pito ke narui, lavis ke Legiena Wa siar ne, naga nene e ruru nena e pogos nap̃a mrae pito kovio. ");
INSERT INTO lww_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ana sira la nap̃a nanua ataveve Yesu siar gar Kalele pimi tol kiena laktorovia, nanagane pogos nap̃a akus tasnena pimi, ataveve sina. Ataveve pimi tol kana yo na nasiniena, ana apisu nap̃a amligan m̃eke e puluve. ");
INSERT INTO lww_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ana apisu pae, ap̃asup̃ela apa si um̃a vena akila ruru ponotaninu lala sa nap̃a m̃ap̃es amio pomat. Atol yo um̃a, ana Legiena Wa siaria, kila narui pe pogos re si tai pan la nap̃a ava avaia tasnena ne Yesu poli. Ana asum̃a ga um̃a sanene, sa nap̃a navisaluaena pisape monar akila e legiena wa. ");
INSERT INTO lww_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Legiena Wa p̃aro pano, ana kana legiena tap̃ena na peni, naga legiena p̃esa na legiena olua. Ana kolulag kona, sira lap̃as nene ap̃ar ponotaninu sa nap̃a pomat amio m̃ap̃es nap̃a akila ruru pa rui, amiyal apa e puluve nap̃ani vena avaia ruru tasnena ne Yesu. ");
INSERT INTO lww_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ana pogos nap̃a apitom atol yo, am̃al nap̃a pupia kilavaru na kilawoen puluve nene, amelilivin lua rui, ");
INSERT INTO lww_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ana apa loyum̃a, amilan nap̃a tasnena ne Yesu kovio rui. ");
INSERT INTO lww_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ana asum̃al ga asike narui asitom wele m̃a pano-o amilan nap̃a yar lua asum̃alu asike amio la. Lalua nene m̃ala kulmrae la miyuwowo nap̃a miyuwowo ruru nena naapo. ");
INSERT INTO lww_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ana sira la nap̃ani amaraun nap̃a akira avisu lalua nene, ana akinai tanon lalua, p̃arila tau pito e porotano. Ana lalua nene apis pan la, asape “E, sira lala, tap̃atete alual yar na malena e yo na marena. ");
INSERT INTO lww_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Naga pe mon re si e nini poli, Ntewa pisirlua rui. Amiu asitomyuli sina ya nap̃a naga pisawal pan amiu, pogos nap̃a naga sike amio amiu nanua gar Kalele, pe apim re e nini poli wa. ");
INSERT INTO lww_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Naga pisa sanini sape sa nap̃a naga pe Narin Yeririna, yoko monar atam̃an naga va e limana ne li viowa lala, ana yoko asuar naga va e laktorovia, ana siraunia, e kana legiena natelu, yoko sum̃alu mal sina. Nane visena ke nanene narui nap̃a naga pisawal p̃esan pan amiu.” ");
INSERT INTO lww_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sira la amloge narui, kila la asitom̃al si visaarena nap̃a pisa ruru pan la pisape yoko naga kilia mal sina. ");
INSERT INTO lww_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ana asitom̃al sina, amligan yo nene ap̃asup̃ela, apa apisu nalologena la lualima taaga pa taaga amio lala tap̃ena lala. Sur la nap̃a apisu e puluve apisayu meraravan pan la, ");
INSERT INTO lww_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","11","ana la pe amlelaga re e poli, apisu sane sira la nene asun wowe ga. Ana sira la nap̃a apisu suri la nene, kiela kia la sanini: Maria nae Maktala, Soana, Maria nap̃a anenane Semes, amio si sira tap̃ena lap̃asa. ");
INSERT INTO lww_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ana Pita ga naga taaga sinenan sape visuli sur nene pe lelaga pona peraga, ana naga sum̃alu, kiriri pano, sinenan sape visuveve yo loyum̃a e puluve. Pimi tol yo nene, pulu pa loyum̃a, ana pisu ga kulmrae la sike na, tasnena Yesu kovio. Ana pa si vanua, mial si p̃asup̃e pa um̃a, sum̃a sitom liluenia sape sur nene na sanape ne, pona kana kinas na ya. ");
INSERT INTO lww_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ana siraunia, e ke ga e legiena nene, la ke ga lalua amligan Yerusalem, sinelan asape ava e narin pulkumali tai, kiena kia Emeas. Mraplepa na vaen e yo nene pe piavi manene re poli, sur sane tasme lualima. ");
INSERT INTO lww_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ana pogos nap̃a lalua amial apa ke narui, lalua asum̃a asunyu manene laa sur la nap̃a p̃aro pa rui. ");
INSERT INTO lww_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Asunlilue m̃a sanene apano, ana Yesu mial pimi piear la, amialpil amio apano. ");
INSERT INTO lww_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Apisu nap̃a mial ke amio la, apisu sane wolawa ga tai, komin nap̃a apisu kilale p̃ele naga. ");
INSERT INTO lww_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ana Yesu piun tan la, pisape “?Kam lua amial ke sanene asunyu liluen ke ya ne?” Ana pogos nap̃a naga piun sanene, aparurula, asum̃alu asu, marala piowa ga sike narui. ");
INSERT INTO lww_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ana lala tai nene, kiena kia Kleop̃as, naga pisatam̃e Yesu, pisape “Yar la mok liu na yo kar ga la ne, asum̃a amialiali ke Yerusalem e pogos nene, ana pona ko ga taaga manene ga pe omlogeyu li re pupia sur la ne kakate mare ga yo na wa?” ");
INSERT INTO lww_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ana Yesu piun pisape “?Ana ya la ne sane opisa ke ne?” Apisatam̃ea, asape “Naga nene e lepas kiena ne yar nae Nasaret nap̃a, Yesu. Naga pimi, pe navisawalen tai, kila kile la mok liu na kiena pupia nam̃areraena, mlologo, a pian ruru yeririna la po pap̃isi, kila sanene sinelan naga keviu, pano tol m̃ena Ntewa na Mava pisawal sape kekaran naga pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ana siraunia, nanua ga yemlagi nakoneva, pupia yar wa lala amio kieta nasumonena lala sinela karia, ap̃ere m̃a naga pa e pupia kumali la pano-o amlip̃erea, asape naga monar mare, ana apa asuar naga pa e laktorovia, mare rui. ");
INSERT INTO lww_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nanua sumo, kiamimi sitomena sike ga e naga, mesape naga ke narui nap̃a yoko tamalia ita le Israel lala, yoko were plan ita vetan nam̃areraena kiena ne le Rom lala, ana nanagane, sur la punu ga pa piowa si narui. Naga kovio petan imimi, nagane kana legiena telu narui. ");
INSERT INTO lww_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Ana sur si tai nap̃a kila imimi memilan manene pap̃isi, ana mesitomyu kap̃aran ke na wa. Nagane kolulag pogos nap̃a lakaporo kokoreko yam taaga, kiamimi sira lap̃as asum̃al apa si e puluve nap̃a amligan tasnena ne Yesu m̃enea, apavinin asape avaia ruru wo. ");
INSERT INTO lww_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ana pogos nap̃a apa aporu e yo nene, apisu nap̃a tasnena pe mon re si e lelen poli, ana akirir si ap̃asup̃e la apitom pun imimi, apisawalia, a pe naga re ga nene poli, ana pisawal m̃ena asape apisu navisi lalua, nap̃a apisawal asape Yesu mal si petan marena rui. ");
INSERT INTO lww_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ana imimi lap̃asa sinelan asape ava avisulia, ana la apito e puluve, apisu sanena nap̃a sira la apisa, pe am̃a re nena ga.” ");
INSERT INTO lww_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nanene narui visena la nap̃a lalua apisa pa Yesu, e pogos nap̃a asum̃al ga asike mrapa. Ana naga m̃ena pis, pisa pan la, pisape “Aulai, kam punu ga kiligamiu la pop̃e ga. Navisawalena la apisawal sur la nene nakonua rui, ana sanape nap̃a kam na pe amlelaga re poli wa? ");
INSERT INTO lww_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pona akilia rui nap̃a yoko Ntewa visirlua kiena Navisaarena ve pupia yerkawa e yomarava nini. Ana kam na pe apisu kilale re nena ga nap̃a Nasiriena Wa lala apisawal rui, asape yoko monar akila Navisaarena loge viowa e sur la ve moki, yoko akila kare naga sumo, p̃isi na Ntewa kilia visirlua naga, vena tol kiena pupia naurarena.” ");
INSERT INTO lww_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ana Yesu sunyu ke pan la sanene, pian la pa re laa sane wa. Naga siar e tus lala kiena ne Mosis, pimi tol tus lala kiena ne navisawalena lala, sum̃a pisa meraravan ruru ke pan lalua nene sanape nap̃a visena marua la nene sum̃a kiar ke ga naga, apisayu ke ga naga silaga. ");
INSERT INTO lww_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ana asum̃a amialor si apano, pe piavi re poli apim lavisin pulkumali nap̃a lalua apanon ke ne. Ana lalua apisu sane Yesu sum̃a mlilu mrapa pa yalen silaga. ");
INSERT INTO lww_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ana am̃areran pania vena sike ne amio la wa. Apis pania, asape “Nagane na mrae pito ke narui, lavis pintam̃a ne. Oimi osu re omio imimi sumo wa, om̃eke ga e nini.” Ana Yesu pa m̃eke amio la. ");
INSERT INTO lww_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Asum̃a ga tol pogos na kinanena, ana apim lele taaga e yo na kinanena. Ana pogos na lenwoen kinanena, Yesu ga sum̃alu mlarar kala kilaparavi, mlen pa Ntewa pisa potena pania, kawe wowaia pion pan la. ");
INSERT INTO lww_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ana pogos nap̃a kila sanene, e nena ga e pogos nene sa nap̃a kilamarala pike, apisu kilalea sane naga nap̃a sike amio la ne Yesu ke narui. Ana apisu manene m̃a sanene, a yam plas ga kovio nena ga. ");
INSERT INTO lww_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ana lalua asum̃a apisayuia, asape “Suwala, tepisu kilale re poli e, ana kieta Sup̃e ga nap̃a. Ana lelaga, naga nena ga, komin nap̃a tesun lilue ke temio mrapa nap̃a naga pisayu meraravan ke visena wa pan ita, kiena visena lala sa ga kapi kekan ke sineta.” ");
INSERT INTO lww_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ana pogos nap̃a akilia sane apisu marana ne Yesu rui, pe amomal re si poli, ana asum̃al ke ga, amial e pupia lepamiema ap̃asup̃e apa Yerusalem vena avisawal va lap̃asa. Ana am̃alivin la lualima taaga pa taaga nap̃a asike e viorena wa, amio lap̃asa, ");
INSERT INTO lww_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ana lalua pe apis re pan la poli wa, ana la apis p̃esan pan lalua, asape “E, pogos nap̃a kamlua apa ga sane, sur tai pimi m̃alivin imimi e nini. Visena nanua sira la apisa, lelaga kemua nap̃a, kieta Sup̃e sum̃alu molue petan marena rui, Pita ne nanene naga pisu e kilamarana.” ");
INSERT INTO lww_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ana la m̃ena lua nap̃ani asikol kiela visena, apisayu sanape nap̃a Yesu m̃alivin la mrapa, a nap̃a la pe apisu kilale re poli, pano-o tol pogos nap̃a kawewowa ga kilaparavi pan la. ");
INSERT INTO lww_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ana pogos nap̃a lalua asum̃a asunyu ke sur la nene pan la wa, amilan ga nap̃a Yesu sum̃al ga sike likan la rui, pisa pan la sape “Sum̃are sike amio amiu.” ");
INSERT INTO lww_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yesu pimi pula sanene, kila la am̃ape yermare, ana amarau pap̃isi. ");
INSERT INTO lww_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ana Yesu pisu kilale nap̃a amaraunia, piun tan la sape “!E, vanon ya ne asitom manene laa sanene? Ve sinemiu veve lua re! ");
INSERT INTO lww_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Avisuli lum̃au amio lau, lelen ya na sike e la? !Apisuia, in ga nini! Aim atolili tasneu la komp̃asa, komin sur sane yermare naga pe puryun re poli a pe kilam̃iu re poli sane tasneu nini.” ");
INSERT INTO lww_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ana sum̃a pisa ke sanene pan la, kipian limana amio lana pan la vena akilia avisuia. ");
INSERT INTO lww_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ana e pogos nene, nalogena lala kiela sitomena miyum̃ae manene sanene, nap̃a akekara pap̃isi nap̃a apisu si Yesu, ana asitom p̃ele towe ke ga wa. Ana Yesu pis ke sina ga, piun tan la sape “?E, apran kapi rui?” ");
INSERT INTO lww_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ana la amlega ika tai, manoa ga na wa, ana amla kinakinas tai pa Yesu, ");
INSERT INTO lww_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ana mlavia, kan ga e marala. ");
INSERT INTO lww_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ana siraunia, Yesu pis pan la, pisape “Pogos nap̃a nesike nemio amiu nanua sumo ne, in na nepisayu visen la moki na lepas make ga na Siriena Wa pan amiu. In na nep̃ar visena la e tus lala kiena ne Mosis, e tus lala kiena ne Navisawalena lala, a e tus na Yauena Wa lala, ana nesum̃a nepisa ke nesape visena ne la nanene narui, asum̃a apisayu in ke ga, a nesape yoko aim ave lelaga e inu ve ve piavi re. In na nepisa sanene pan amiu, ana nagane kam na apisu sur la punu ga nene apim ape lelaga e maramiu p̃isi narui.” ");
INSERT INTO lww_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ana Yesu pian la pa laa sane, kila kiela sitomen la pa keviu li laa sane loyum̃a e kinas nen Siriena Wa la nene, ana sur la punu ga pimi merarava ruru pan la. ");
INSERT INTO lww_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Naga pisa pan la, sape “Nane visen la nene kala kinas ne nanini narui, sane Navisaarena, yoko akila naga loge sinelae vano-o marenia, ana e kana legiena natelu, yoko sum̃alu mal si vetan marena. ");
INSERT INTO lww_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","A siraunia e ga e kiena kia, yoko kiena yeririna lala asiar gar Yerusalem, a yoko amolue ava e yomarava wetelu, ava alologon va p̃egas nen yeririna make ga, avisawal van la avisave monar avilopu la narui, ana akilia atol naviewoena e kiela mlamulen viowa lala. ");
INSERT INTO lww_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“Ana kam la nap̃a apisu sur la punu ga nene e kilamaramiu, kam ke narui ava avisawal va yar tap̃ena lala avisave suri la nene na lelaga. ");
INSERT INTO lww_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yum̃aena nene naga pe yum̃aena m̃arera tai nap̃a m̃arera pap̃isi, ana yoko neligan nam̃areraena tai e amiu vena iila amiu atauluia. Nam̃areraena nene, navisaarena kiena ne Ata sike nap̃a yoko naga ligan molue ma e peni vitom kokonia amiu, ana sineun nesape nevisa van amiu, ve aur matan re pulkumali nini wa, ana monar asum̃ate m̃a e nini, vano-o atolia.” ");
INSERT INTO lww_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ana pogos nap̃a Yesu sinenan sape ligan la, sumon la apito garo e narin pulkumali nap̃a Petani. Apitom atol yo nene, asum̃a sanene, pano-o Yesu p̃ar plan limana metavan la, pisa ruru la. ");
INSERT INTO lww_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sum̃a pisa ruru la m̃a sanene pano-o, sum̃a siar mligan la palilue narui, pa si metava pa nena ma e peni. ");
INSERT INTO lww_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ana nalogena lala apisu kiela Sup̃e kovio sina petan la, ana akinai tano amlotunia, ana ap̃asup̃e la si apa gar Yerusalem, nap̃a akekara nap̃a akekara. ");
INSERT INTO lww_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ana asum̃a e nene pano-o, ana silaga e pogos na leniena make ga asum̃a apa amieluar ke Ntewa e m̃ana Yum̃a Wa. Nane Lologena Wo kiena ne Yesu Kristo nap̃a in Luk nesiria, p̃isi e nene narui. ");
INSERT INTO lww_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na konua konua rui, e purp̃esia, naga nap̃a apio Purp̃es nen P̃elaga kiena ne Ntewa naga sike amio Ntewa, a naga pe Ntewa. ");
INSERT INTO lww_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","E pogos na siien sur punu ga, naga amio pa Ntewa rui, ");
INSERT INTO lww_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","naga miyum̃aen yum̃aena na kilaen sur punu ga. Pe sur re tai nap̃a naga pe miyum̃aen re poli. ");
INSERT INTO lww_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Malena na lelaga molue e naga, ana malena nene pimi pe sane yomerarava kiena p̃egas punu ga na yeririna lala. ");
INSERT INTO lww_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Naga pimi sa nap̃a yomerarava na tegolien la nap̃a asike e pupumalko, na yemalolo nene tap̃atete tauluia. ");
INSERT INTO lww_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Siraunia, Ntewa mligan kiena yar tai pimi e yomarava nini, nane Yoane Nakeena. ");
INSERT INTO lww_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Naga pimi sane yar na iilaena, vena visawalen yaru na yomerarava nene naga pimi ke ne, vena iilaen yeririna la punu ga akilia alelaga asape yaru nene naga pe yomerarava kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Sa nap̃a, Yoane naga pe pe yomerarava re poli na wa, ana pe yar na visawalen ga. ");
INSERT INTO lww_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ana siraunia, yaru na yomerarava nene pimi kate e yomarava nini. Naga pe yomerarava nalelaga napo, ana pimi pe na ligan kiena yomerarava nene e malena kiena yeririna punu ga. ");
INSERT INTO lww_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yaru na yomerarava, naga nap̃a sii yomarava nini, ana pogos nap̃a pimi ea, ana yeririna na yomarava lala pe apisulup̃ar re si naga poli. ");
INSERT INTO lww_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Naga pimi p̃es puna ne um̃a m̃ana ne kiena yeririna la, ana la na mratava puna pe sinelan re naga poli. ");
INSERT INTO lww_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ana la ga p̃asia akekaran naga, amlelaga ea, ana e la ga nene punuia, naga tam̃an la vena akilia aim ave narina ne Ntewa lala. ");
INSERT INTO lww_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Naga kila la apaeme sina yam luania, pe sa re nap̃a sisi la na apaeme taveve lus na kuruta, pona nasinenanen sa yerm̃ene amio sira, pona sitomena kiena yeririna, ana apaeme sina taveve nasinenanena kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Sanene na, Purp̃es nen P̃elaga kiena ne Ntewa pimi pe yeririna lelaga, pimi sike likan ita, ana tepisu kiena malena napo, pulen manene laa p̃elaga na lemamena amio p̃elaga nalelagaena. Naga pe nowo tanea wa m̃earu kiena ne Arimata, ana mepisu kiena pupia naurarena, kiena naga taaga. ");
INSERT INTO lww_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Pogos nap̃a Yoane Nakeena pisayu naga nanua ne, pisape “Naga nap̃a nepisawal pae pan amiu, nesape naga yoko siraun inu, naga su metava, in na neto ga tano, komin naga mal nakonua laa sane, in na na nanagane ga ne.” ");
INSERT INTO lww_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Naga pulen p̃elaga wo lala, ana silaga kila ke po pan ita pap̃isi, kiena pupia lemamena kila temlogelue ga po pap̃isi. ");
INSERT INTO lww_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nanua Ntewa pisirlua yermarua Mosis, p̃ar ga kiena navisaluaena lala pimi pan kiena yeririna lala, ana Yesu Kristo, Ntewa pisirlua naga p̃ar p̃elaga na lemamena amio visena na lelagaena pitomi e yomarava nini. ");
INSERT INTO lww_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ita yeririna lala pe yar re nena tai nap̃a kilia Ntewa poli, pona pisu e kilamarana, ana yaru nap̃a tolue ga e sitomena kiena ne Ntewa, lalua aparpran la ga veraga, naga ga pimi kila ita tekilia Ntewa amio kiena p̃elaga lala. ");
INSERT INTO lww_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ana pogos nap̃a Yoane Nakeena mlologo m̃a pano-o, nasumonena kiena le Yu lala nae Yerusalem la asitom veve ke pap̃isi sane naga miyum̃ae ke sanape, pona naga pe Navisaarena, po naga ai. Ana la apitetalia yaru wa p̃asia amio yar keviu si p̃asia na lus wa kiena ne Livae, apim apiun petania asape “Ko na ai?” ");
INSERT INTO lww_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ana pogos nap̃a lala apiunia, naga pisawal ruru ga sur punu ga pan la, pisatam̃e la, pisape “Peraga, in na pe nepe Navisaarena re poli.” ");
INSERT INTO lww_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ana la apisape “?Sanene na, ko na Yermarua Elaisa nanua sumo ne, ana ko omal sina, po pere? Nanene komin nap̃a Visena Wa pisape naga monar wasup̃e sina sumon Navisaarena.” Ana naga pisatam̃e la sina, pisape “Peraga, pe in re nene poli.” Ana apisape “?Pogaga, ana po ko na navisaluaena nap̃a Mosis pisaar nanua yo rui?” Ana pisatam̃e sina, pisape “Peraga rui.” ");
INSERT INTO lww_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ana la apiun ke sina ga tania, sape “?Ana ko na a si narui? Monar ovisa sur tai van imimi vena mekilia mevano mevisawal van la nap̃a amligan imimi mepimi. Ovisawal ruru ga van imimi, sane ko na ai?” ");
INSERT INTO lww_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ana kiena navisatam̃eena e pogos nene sanini, pisape “Inu in na pulgo korena ga ne e yokorena nini, nap̃a Navisawalena Aisea pisawal na konua rui. Ana pulgo nene pimi pe na visawalen sape: ‘Amiu akila ruru mrapa lala kiena Sup̃e e kiamiu malena!’” ");
INSERT INTO lww_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ana lala p̃as nap̃a asike e pogos nene, le Varasi lala, ");
INSERT INTO lww_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ana la apiun ke sina ga pan Yoane, apisape “Imimi memloge pa rui, ko na opisa osape pe ope Navisaarena re poli, pe ope Elaisa re poli, a pe ope navisaluaena re nap̃a Mosis pisa poli. ?A visae sanene na, vanon ya ne ko na ositom osape ko na otorokin osun okekee lue yeririna lala sanene?” ");
INSERT INTO lww_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ana Yoane pisatam̃e la, pisape “Inu, nakeena nap̃a nekila ke ne e la nene, naga e ga e wii. A yaru tap̃ena tai yoko imi kus leleu, nap̃a naga sike pa likan ita rui, ana pe akilia re naga poli wa. ");
INSERT INTO lww_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Naga to laa metavan manene inu, sane in na pe netorokin re neva lavisin po, pona neyal nemio.” ");
INSERT INTO lww_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ana lele nap̃a apa ke ea na visuen Yoane, nane e norava lavisin kumali nap̃a Petania, e wii nap̃a Yortan lepas na vano, nane e yo nap̃a Yoane sum̃a kee ke yeririna lala ea. ");
INSERT INTO lww_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ana e legien tap̃ena si tai, Yesu mial pa katen Yoane Nakeena amio imimi kiena nalogena la e yo nap̃a mesike ea. Ana pogos nap̃a Yoane pisu Yesu, pisa pan imimi, pisape “!E, amiu avisu yar na mial ke pimi nam̃a! Naga, sa ga narin sipsip kiena ne Ntewa nawarplanen nakoaena na mlamulena viowa kiena ne yeririna lala na yomarava nini. ");
INSERT INTO lww_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nanene naga nap̃a nepisayu ke pan amiu nanua rui, nepisa nesape: Siraun inu, pupia yar tai naga imi nap̃a sumon inu, to manene laa metavan inu sane, komin naga teke sumon inu. ");
INSERT INTO lww_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nepisa visena nene nanua, nemninue ga nesape naga ai, nemninue ga nesape erau ne nanene, ana nekilia ga nesape monar nekee ita le Israel lala e wii, vena kilaen nap̃a tekilia tevisu kilale kieta yerkawa nene.” ");
INSERT INTO lww_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Ana Yoane pisa meraravan pan imimi sanape nap̃a naga kilia sape Yesu pe Navisaarena. Naga sape “Sa nap̃a nepisa pa rui, in na pe nekilia re poli nesape naga ai, ana pe piavi re nena ga, Ntewa pis pan inu, pisa sanini, pisape: Visae ovisu kiau Ninuna Wa vitom ke tano, totano e yar tai, naga ke ga nene nap̃a yoko kee yeririna lala e Ninuna nap̃a kiau. “Naga pisa sanene pan inu, ana pogos nap̃a nepisu Yesu nene, nepisu Ninuna mligan ma e peni pitomi tano e naga, sa nap̃a lom̃e, pitomi koan e naga. ");
INSERT INTO lww_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Vanon sur ne na nene nap̃a nepisuia, nekilia nevisawal ruru van amiu, sane pe lelaga ga, yar nene pe narina ne Ntewa kemua lelaga.” ");
INSERT INTO lww_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ana e legiena tap̃ena si tai na, Yoane Nakeena sum̃a ke ga wa e yo nene, sun ke amio imimi lua Antru, nap̃a e pogos nene mepe kiena nalogena. ");
INSERT INTO lww_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ana mepisu Yesu mial pimi p̃aro lavis pu imimi. Ana Yoane pisa pan imimi lua, pisape “!Amiu lua avisu ke yar nene, naga sane narin sipsip na kup̃ap̃aena kiena ne Ntewa!” ");
INSERT INTO lww_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Memloge Yoane pisa sanene, ana veraga ga mesum̃alu, memial mepa mesiraun Yesu. ");
INSERT INTO lww_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ana Yesu kira p̃atau pisu imimi lua, pisape “Nepisu sane amiu lua sinemiun ke sur tai.” Ana mepisatam̃ea, mepio naga sane kiamimi navianena tai, mesape “?Rapae, opimi e nini na, ko na omomon ke pe?” ");
INSERT INTO lww_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ana naga sape “Pogaga, aimi teva avisuia.” Ana memial mepa metol e nap̃a Yesu sike ea e pogos nene, ana siar sane ko yepekilavi ko e maran mrae vari, mesun m̃a memio naga pano-o yemalolo. ");
INSERT INTO lww_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ana Antru nene nap̃a imimi lua memloge Yoane sunyu Yesu, mesum̃alu metaveve sanene, naga Antru nap̃a wenla Saemon Pita navetokak. ");
INSERT INTO lww_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ana pog nap̃a pisa sape taveve ga Yesu narui, ana miroro panon p̃esa wenla nene, a pogos nap̃a m̃alia pis pania pisayu Navisaarena, nap̃a e visena na Epru kiena ne le Yu la apio asape Mesaea, a e visena na Kris kiena ne le Krik la asape Kristo. Ana pisawal sanene, sape “M̃ara, Navisaarena nene, imimi mem̃al rui.” ");
INSERT INTO lww_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Naga pisa pan wenla nap̃ane, ana pure pimi pu Yesu. Ana pogos nap̃a Yesu pisu naga, pisape “?A, ko m̃ena nene nap̃a narina ne yermarua Yoane tai? Nenagane na nesikia ko sina ga, kiom̃a ki Kep̃as.” Ki m̃ena nene kome visena nae Epru, nap̃a kana kinasia kilavaru, nap̃a kome visena nae Kris asape Pita. ");
INSERT INTO lww_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ana e legiena tap̃ena si tai, Yesu sinenan pisape taveve si kiena mrapa, pisape kusro yo vato si kiena yo nap̃a Kalele. Mepa sanene, p̃isi na m̃al si yar tai, pisa pania pisape “Ko oim otaveve inu.” Yar nene, kiena ki Pilip, ");
INSERT INTO lww_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","nap̃a naga m̃ena nae yo kiena Antru amio Pita, nanene pulkumali na Petsaeta. ");
INSERT INTO lww_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ana pe piavi re poli na Pilip pa kale kiena erau tai, kiena ki Nataniel, pa pisa pania, pisape “Yar keviu nap̃a yermarua Mosis amio navisaluaena lala asiriyuia, apisawal na konua rui, naga pimi m̃alivi likan ita rui. Imimi mem̃al rui, naga nae Nasaret, narina ne yermarua tai kiena kia Yosop. Ana yar nene, kiena ki Yesu.” ");
INSERT INTO lww_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ana pogos nap̃a Nataniel mloge asape Yesu naga nae ga narin pulkumali nap̃ani, naga piunia pisape “Ana sanape? Pupia yar keviu napo tanea sanene tap̃atete m̃alivi e narin yo nene Nasaret!” Ana Pilip pisatam̃ea, pisape “Ei, ve ovis re sanene, ko na oim ovisuli kone wa.” ");
INSERT INTO lww_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ana p̃isi na lalua apa sina puna ne Yesu, a pogos nap̃a lalua amial apim lavis puna, Yesu pisu Nataniel, pisayu naga, pisape “Lelaga ga, nepisu yar nene sa ne yar wo lelaga tai nae Israel, yar tai nap̃a navisokanena pe to re nena e naga poli.” ");
INSERT INTO lww_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ana Nataniel mloge Yesu pisayu naga sanene, piun tania sape “?Ana sanape na ko na okilia osape in na yar na sanene?” Yesu pisatam̃ea pisape “Pogos nap̃a Pilip naga pe pim̃asun ko re poli wa, pogos nap̃a ko ga taaga opa ruru ko ke vatanon purpiliva, in na nekirawal ko pa rui.” ");
INSERT INTO lww_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ana Nataniel milan nakiliaena kiena Yesu nene, pisape “!Navianena, ko na narina ne Ntewa kemua na lelaga! Ko na ope p̃arin sup̃e lelaga kemua nae Israel.” ");
INSERT INTO lww_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ana Yesu pisa pania, pisape “!In na nepisa ga narin visena tai van ko, nap̃a nepisu ko e purpiliva nene, ana veraga ga kila ko na omlelaga m̃arera e inu! Nanene na po pap̃isi, ana nevisaar van ko sane yoko ovisu sur na ilanena la ve moki vap̃isi ne, nap̃a ve keviu laa sane taulu nap̃a opisu pa rui. ");
INSERT INTO lww_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Lelaga nepisa ruru ga, sane yoko amiu punu ga avisu ma e peni naga vike ga m̃eke na, amio navisi nae ma metava lala avitom ke tano e inu, ava sina metava, avitom tano, ava si metava ve sanene. Sur ne la nanene akilia avisuia komin nap̃a inu nepe Narina ne Yeririna, sane in na nae ma e peni nepimi nepe yeririna ruru nena naapo.” ");
INSERT INTO lww_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ana Yesu lala apimi atol pa norava nae Kalele, ana e legiena na telu, p̃ap̃agena na talopaena tai e kumali nene Kana. Ana anenane Yesu naga pa kate pa e p̃ap̃agena nene rui, ");
INSERT INTO lww_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","a siraunia amligan visena pimin Yesu amio kiena nalogena lala, apio la m̃ena ga vena ava ea. ");
INSERT INTO lww_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ana Yesu lala apa akate e p̃ap̃agena, asum̃a amio yeririna la pano-o, sur tai naga piowa, kuruta na munena na p̃ap̃agena nene naga p̃isi iroro ga. Ana anenane Yesu pimi pisa pa Yesu, pisape “Namunena la nap̃a yar keviu na p̃ap̃agena kila ruruia, amun make rui, ana nanagane na aplasan narui.” ");
INSERT INTO lww_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ana Yesu pisatam̃ea, pis pania, pisape “?Sira marua, yum̃aena ya ne e p̃ap̃agena nene teke e inu? Ve oligan re te lum̃au, vanon kiau pog na yum̃aenen sur la ne sanene, naga pere ke ga wa.” ");
INSERT INTO lww_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Anena mlogear sur la nap̃a Yesu pisa, ana pis pa yar la nap̃a na yum̃aenen p̃ap̃agena, pisape “Sur ya la nap̃a sa naga visa, amiu akila ga, ve avis re, ayum̃aen ga.” ");
INSERT INTO lww_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ana p̃isi na Yesu pisu pupia pias nen wii lap̃asia sum̃a ga lavis, nap̃a le Yu la asum̃a apio ke wii pa ea, akevan ke kiela sur la ea sa nap̃a kiela lotuena pisa ke. Pupia pias nen wii la nene ate e kilavaru torokin waren lita ponotia ve taaga 100, punu ga tol orai. ");
INSERT INTO lww_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ana naga pisa pan la, pisape “Amiu ava avio wii, awar imi ataron vito e pias nen wii la nene vano-o uleule.” La apio m̃a wii pano-o apuleule ruru nenaga. ");
INSERT INTO lww_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ana Yesu pisape “Pogaga, nagane na avioli ve tekaki ga, ala van yar keviu na p̃ap̃agena munlia.” P̃isi na apio, amla pano-o akian pania. ");
INSERT INTO lww_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ana yerkawa munlia, mloge sane pimi pe kuruta na munena narui, ana milan pap̃isi, mninue ga sape am̃al namunena nene pe. Lala nap̃a apio, la ga akilia ke, ana pe apisawal re poli, p̃isi na naga pio yar nap̃a talopa ga na wa pimi puna. ");
INSERT INTO lww_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Yar nene naga pimi ana yerkawa pis pania, pisape “E p̃ap̃agena tap̃ena lala, apio ke kuruta namunena nap̃a po pimi p̃esa, ana pogos nap̃a yar la amun lili m̃a pano-o, atol mare ga kuruta na munena nap̃a pe po manene re poli naga pimi maro. Ana e p̃ap̃agena nini, la amun m̃a pano-o, p̃isi na ko otol ga m̃au kuruta napo tai nap̃a pimi maro. Komin ya ne okila sanene?” ");
INSERT INTO lww_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ana sur nap̃a Yesu kila e pulkumali nae Kana e yo nap̃a Kalele, naga sane pe pupia kile tai, naga pe kiena kile p̃esia nap̃a miyum̃aenia. Naga kila, sa nap̃a naga sape siar na kila meraravanen kiena puriukawaena nae yo metava, ana pogos nap̃a kiena nalogena la apisuia, kiela nalelagaena e naga pa laa metava, sane naga pe Navisaarena kemua lelaga. ");
INSERT INTO lww_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","P̃isi narui na la punu ga nene apato si garo Kapeneam, nane Yesu amio anena, wenla lala amio kiena nalogena lala, apam atol si yo nene asu li m̃a sane pano-o tol legiena la p̃asia. ");
INSERT INTO lww_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ana pogos tai, lavis ke pog nap̃a le Yu la akila kiela pupia p̃ap̃agena tai, nap̃a P̃ap̃agena na Sitom̃alen Natamaliaena. Ana kiela p̃elaga marua tai, sane e kas punu ga lala punu ga monar akilali nap̃a ava ma metava Yerusalem e kana pog ne naapo vena kilaen p̃ap̃agena nene, vena sitom̃alen kala apua la nap̃a amolue gar Isip, ana e pogos nene Yesu m̃ena ga pavin. ");
INSERT INTO lww_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Naga pa tol yo, ana pa kate e Yum̃a Wa M̃ana ne Ntewa, pisu lala moki nap̃a asike ap̃ilwilin ke puluk la, sipsip lala amio manu la, pisu m̃ena la nap̃a nakepuen kilavaru tap̃ena lala va e kilavaru nena naapo na Yum̃a Wa m̃ana Ntewa. Yum̃aena la nene ape yum̃aena wo tai, komin ape yum̃aena na wilwilinen sur lala nap̃a yeririna la monar aulia vena kilaen kup̃ap̃aena ea, a pe sur viowa tai, la akila kare laa yar lala, ana metavania, akila ke loyum̃a e kove na yo wa. ");
INSERT INTO lww_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ana Yesu pisu nap̃a akila kare yo wa na yum̃a sanene, p̃isi na sinena mimi, p̃ar kilika lala, p̃uarar luas lua sane, panon la. Naga pa sanene, pa m̃ene plan la amio kiela sipsip lala amio puluk lala apa vanua petan Yum̃a Wa m̃ana ne Ntewa, ana e lepas kiena ne la nap̃a akepu ke kilavaru, pa taron plan kiela karo na kilavaru, kawe plan m̃ena kiela varvara lala. ");
INSERT INTO lww_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ana yar la nap̃a ap̃iliwilin ke manu lala, naga pis pan la pisape “!E, awar plan kiamiu sur la vetan yo nene! !Amiu ve akila re yum̃a m̃ana ne kiau ata nene imi ve yum̃a na tauluen kiamiu kilavaru sanene!” ");
INSERT INTO lww_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ana pogos nap̃a nalogena la apisu nap̃a Yesu m̃ene plan la sanene, kila lala asitom̃al si nasiriena wa tai, sa nap̃a pisayu pa Navisaarena sumo rui, nap̃a pisa sape “Kiau sitomena urmi pap̃isi e yum̃a wa kiom̃a, naga sa nap̃a kapi naga kekan ke loyum̃a e sineu.” ");
INSERT INTO lww_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ana vanon suri nene, yerkawa kiena le Yu lala, la m̃ena apisu ke sur la nap̃a Yesu miyum̃aenia, ana apiun tania, asape “Suria ne ko na omiyum̃aen ga ne, sur keviu tanea. ?Ana ko nene okilia okila kile ya ne e maramimi, vena kila imimi mevisu kilia sane mesmesu ga nap̃a okila sanene?” ");
INSERT INTO lww_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ana Yesu pisatam̃e pan la, pisape “Pogaga, kiau kile naga sanini: Amiu awe plan Yum̃a Wa nene, ana siraunia, e legiena ve telu ga, yoko nevisirlua sina ga.” ");
INSERT INTO lww_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ana asape “Lala nap̃a amiyum̃aen yum̃a nene, amiyum̃aen pano-o tol kas lualima yam vari pa orai, ana sanape ne ko na opisa sanene, osape okilia ovisirlua si naga e legiena ve telu ga? !Tap̃atete ga ve sanene p̃a!” ");
INSERT INTO lww_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lala apis sanene, vanon la pe akilia ruru re sur nap̃a Yesu pisa ke e pogos nene poli. La pe apisu kilia re asape pog nap̃a Yesu pisa ke Yum̃a m̃ana ne Ntewa nene, pisa ke ga tasnena ne. ");
INSERT INTO lww_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ana siraun laa sane, pogos nap̃a naga mal sina ga taulu marena, kiena nalogena lala asitom̃al nap̃a naga pisa visena la nene pan la, p̃isi na kila amlelaga manene laa e nasiriena wa lala amio visena kiena ne Yesu lala pan la. ");
INSERT INTO lww_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ana Yesu la asum̃a e p̃ap̃agena nene garo Yerusalem pano-o, naga kila ke kile la moki, ana pogos nap̃a yeririna la apisuia, lala moki amlelaga e naga asape naga pe Navisaarena. ");
INSERT INTO lww_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ana Yesu pe tam̃an manene re naga pan la poli, pe p̃asine manene la re poli, vanon naga kilia ruru la pa rui. ");
INSERT INTO lww_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yar tap̃ena tap̃atete visa sur tai va Yesu e lepas na p̃elaga kiena ne yeririna lala, vanon naga kilia ruru make ga, kilia ruru sur punu ga nap̃a sike e sitomena kiena yeririna lala. ");
INSERT INTO lww_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Ana pogos tap̃ena tai na, kolemalo, nasumonena tai kiena ne le Yu lala pimi sape visu Yesu. Yar nene naga Varasi tai, kiena kia Nikotimas. P̃isi na naga pimi, pisa pa Yesu pisape “Navianena, imimi mepisusu ko ke, nap̃a mepisulup̃ar sane ko, ko navianena tai nap̃a okom puna Ntewa opim, vanon pe yar re tai nap̃a kilia kila kile la ne sa nap̃a ko na okila ke ne poli, sa Ntewa ve to re amio naga.” ");
INSERT INTO lww_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ana Yesu pisatam̃e pania, pisape “Ee, kile la nene apogaga, ana in na monar nevisatam̃e ve lelaga van ko, sane yar nap̃a ve vaeme re sina ga imi ve urviu, yoko tap̃atete Ntewa ve sup̃e e kiena malena.” ");
INSERT INTO lww_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ana Nikotimas sinena pulan visena nene, pisa pisape “!Aulai! ?Ana yar nap̃a pe yermarua pa rui na kilia vaeme si ve sanape? In na pe nesitom re nesape naga kilia va sina ga loyum̃a e m̃ep̃ena ne anena poli, vena vaeme sina.” ");
INSERT INTO lww_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ana Yesu pisatam̃ea sape “Nepisa pe lelaga pan ko, sane yar monar vaeme e wii, a monar vaeme e ninuna. Visae peraga, naga tap̃atete va loyum̃a e navesup̃enena kiena ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yar kilia war sina ga yaru, ana Ninuna kiena ne Ntewa kilia war sina ga ninuna viu e malena kiena yeririna. ");
INSERT INTO lww_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nanene na vaemeena nalua nap̃a nepisa ke pan ko. Ve sanene, ko na ve sinem̃a ulan re si nap̃a nepisa pan ko nesape ko na monar ovaeme sina. ");
INSERT INTO lww_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Ositom veve li lagi. Lagi na miyui ke ne, naga pa ke ga e yo nap̃a sape va ea, pona temloge ga miyui ana temninue ga tesape miyui pimi ke sanape, pona pa ke pe. Ana mrapa nap̃a Ninuna miyum̃ae e malena kiena ne yeririna lala naga sa nene, naga sa nap̃a lagi.” ");
INSERT INTO lww_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ana Nikotimas sitom manene e visen la nene, piunia sape “Aulai, ana sur nene naga sanape p̃a!” ");
INSERT INTO lww_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ana Yesu pisatam̃e pania, pisape “Ko na ope pupia navianena tai kiena ne le Israel la rui, ana nepisu sane sur la ne nepisa meraravan ke pan ko ne, ko na pe okilia re nenaga na! ");
INSERT INTO lww_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Oyagogo ruruia! Sa nap̃a navisawalena la amiyum̃aen pa nanua rui, in na nepisa ke ga sur ya nap̃a nekilia amio suri ya nap̃a nepisuia, ana sa nap̃a silaga, amiu yeririna nae Israel lala yepemiu mavin kiamimi visena lala. ");
INSERT INTO lww_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","In na nepisayu pa sur na yomarava nini pan amiu rui, ana yepemiu mavin lelagaen ea, ana visae nevisayu si sur nae ma metava lala, yoko akilia alelaga e ve sanape? In na nepisu sane peraga yo. ");
INSERT INTO lww_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ana inu Narina ne Yeririna nekilia nevian amiun sur la nae metava, vanon pe yar re si tai poli nap̃a pisu yo nene, ana in ga Narin Yeririna nepetan ma e nene nepitom tano rui, siraunia yoko nowasup̃e neva si metava ea. ");
INSERT INTO lww_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Nanua sumo sumo, yermarua Mosis la asike e yo korena, lom̃ara la akar mom̃ar ke yeririna lala, ana pisirlua laki tai, miyum̃aen totouena na lom̃ara a mligan mono metava ea, ana yar la nap̃a lom̃ara kar la, visae akira ga va avisu lom̃ara nap̃a m̃eke metava, Ntewa tamalia la. Ana e ga e mrapa m̃a nena nene, yoko monar aligan inu m̃ena Narin Yeririna nomon metava e laki tai. ");
INSERT INTO lww_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ana yar nap̃a visae lelaga e inu, yoko tol malena viu nap̃a ve uro re pogos tai.” ");
INSERT INTO lww_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yesu pisa sanene komin Ntewa sinen si yeririna na yomarava la nini keviu pap̃isi, ana tam̃an narina nowo nene, nap̃a naga taaga ga pe kiena, pitomi mare wo ita, ana yar ai nap̃a lelaga e naga tap̃atete kovio, yoko tol malena wo nap̃a ve uro re pogos tai. ");
INSERT INTO lww_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","?Ana vanon ya ne Ntewa mligan narina nene pitomi tanon yomarava nini? Pe mligan re pitomi vena nalip̃ereen yeririna na yomarava nini poli, ana mligan pitomi vena tam̃an kiena malena vena tamalia itaena. ");
INSERT INTO lww_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Yar nap̃a mlelaga kemua e narina nene, yoko Ntewa tap̃atete lip̃ere naga, ana yar nap̃a pe mlelaga re poli, nakoaena teke pa e naga rui, vanon pe mlelaga re e narina ne Ntewa poli. ");
INSERT INTO lww_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","?Ana nalip̃ereena nene nap̃a Ntewa monar kila, purp̃esia naga ya? Nanene vanon mligan kiena yomerarava pitom e yomarava nini, ana yeririna la akila piowa ga pano-o, pe akekaran re naga poli, sinelan ga p̃elaga viowa la na yemalolo. ");
INSERT INTO lww_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","A lala punu ga nap̃a akila ke piowa sanene, sa nap̃a pe sinelan re nena yomerarava nene poli, pe sinelan re aim lavisin poli, amaraun asape sa kilalae kiela naviowaena la nene vim kakate e yometava, p̃isi na yar la akilia avisu kilalea. ");
INSERT INTO lww_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ana yar la nap̃a amiyum̃ae e p̃elaga nap̃a na po a mesmes, pe amaraun re yaru na yomerarava nene poli, apim lavisinia. Lala akekarania, komin yomerarava nini naga kila meraravania sane sur la nap̃a akila, pe yum̃aena nalogearena ga na sinenanena kiena ne Ntewa.” ");
INSERT INTO lww_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ana siraun sur la nene, Yesu pure kiena nalogena lala amligan Yerusalem apa e norava nae Yutea. Apa sanene, asun akee ke yaru lala. ");
INSERT INTO lww_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ana e m̃a nena e pogos nene, Yoane Nakeena m̃ena sum̃a e lele tap̃ena tai kiena ki Aenon, lavisin yo nap̃a Salim. Naga pimi e nene vanon wii tai m̃eke ea, p̃isi na yeririna la nap̃a apim puna, naga kee la e wii nene. ");
INSERT INTO lww_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nanene e pogos nap̃a pe atarar re naga amligan pa e yum̃a na koaena poli wa. ");
INSERT INTO lww_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ana e pogos nene nalogena kiena ne Yoane lala akila visena tai amio le Yu tap̃ena tai e lepas nakevanen sur lala sa nap̃a kiela lotuena pisa ke, ana e lepas m̃ena nakeena lala nap̃a Yoane amio Yesu lalua akila. ");
INSERT INTO lww_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Apisayu m̃a pano-o p̃isi na apim apisu Yoane, apiun petania, asape “Navianena, mesape meviun tan ko sanape e lepas nap̃a nanua sumo, pogos nap̃a tesike e wii nap̃a Yortan lepas navano, ana yaru nap̃a Yesu pimi pisu ko, ana ko na opisa plan sur moki kom puna. A nanagane na naga m̃ena kee ke yeririna lala, ana la punu ga asum̃a amliligan ita apa ke ga puna, la moki na moki.” ");
INSERT INTO lww_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ana pogos nap̃a apisa sanene pan Yoane, naga pe pielue re poli, pe mloge piowagan re poli, kekaran ga, pisape “Ita yeririna la punu ga monar teyum̃aen ga suri ya nap̃a sa Ntewa ligan te limata. ");
INSERT INTO lww_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Sa nap̃a amiu akilia ruru pa rui, in na nepisawal lue ga, sane kiau yum̃aena, in na pe Navisaarena re poli, in na nesumon ga naga nepimi, ve na visawalen sape naga pimi pa rui. ");
INSERT INTO lww_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A nenagane na, sane amiu na apisawal ga pan inu na wa, naga pimi kila ke pa kiena yum̃aena rui, ana suri nene nekekarania, nepisu po pap̃isi. “Naga sane pog na talopaena, nap̃a sanini. Visae yar nap̃a talopa, kiena erau tai, naga iila keviu nakilaruruen sur punu ga na p̃ap̃agena, ana siraunia, e kana legiena nena, pogos nap̃a aure sira imi, sira nene tap̃atete va totano amio yaru nene, va su ga amio wona. Ana yaru nene pe mloge re piowa poli, kiena kekarena maran taaga ga sane naga nap̃a talopa. Ana nanagane, in m̃ena nekekara sanene, nap̃a kiau nalogena la asum̃a ataveve Yesu. ");
INSERT INTO lww_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nanene komin Sup̃e Navisaarena naga monar imi ve keviu lue ga sanene, in na monar neim neve tokak lue ga.” ");
INSERT INTO lww_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ana Yoane Nakeena pisayu Navisaarena, sape “Naga nae yo na mava, naga su metavan sur punu ga. Ita tomolue ga tano e yo nini, ana tekilia tevisu ga sur na tano lala. Ana sa nap̃a nepisa, naga petan ma e peni pitomi tano, to metavan yeririna punu ga, ");
INSERT INTO lww_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","a naga pitomi pisawal ke sur la nap̃a nanua susumo pisu ma metava, a sur la nap̃a mloge. Naga pisawal sur wo la nene, ana yeririna la pe sinelan re kiena visena la nene poli, pe amlelaga re e poli. ");
INSERT INTO lww_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","La moki pe amlelaga re poli, ana ita nap̃a temlelaga, kieta nalelagaena kila sane Ntewa, naga kiena visena lala pe lelaga a mesmes ruru po. ");
INSERT INTO lww_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kiena visena la nene, mligan Navisaarena pitomi pisawal pan ita rui, ana tekilia tesape visena la nene pe visena lelaga. Nanene komin pogos nap̃a Navisaarena pitomi, tepisu sane naga pis e puriu kawaena na Ninuna Wa kiena ne Ntewa, vanon Ntewa mla kiena Ninuna pan naga pe komsus re poli, punu nenaga. ");
INSERT INTO lww_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ntewa Arimana kekaran narina nene keviu pap̃isi, ana mligan sur punu ga e limana. ");
INSERT INTO lww_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Ve sanene na, ita nap̃a temlelaga e naga, tetol malena rui nap̃a pe nalue ga. Ana yar nap̃a pe mlogear re poli, yoko tap̃atete visu malena na sanene pogos tai, ana sinekar kiena ne Ntewa ve keviu vania.” ");
INSERT INTO lww_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Ana e pogos nene, visena tai telivi m̃a ga, apisa ke asape Yesu sum̃a pure ke si nalogena tap̃ena la moki apim puna, sum̃a kee la. Ana sa nap̃a pe Yesu re kila ke nakeena e la poli, ana imimi nalogena ga la mekila, ana la apisu sane yeririna kiena ne Yesu la apim ape moki taulu kiena Yoane Nakeena. P̃isi na la apisasa lelein ke visena nene pa e yo la sanene, pano tol Varasi la, ana pogos nap̃a Yesu mloge sape la m̃ena akilia, ana kila amloge piowa kominia, ");
INSERT INTO lww_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","naga pisu sane popon vetan Yutea, vato si tano garo Kalele. P̃isi na naga mligan yo, pato sanene, ");
INSERT INTO lww_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ana e kiena mrapa Ntewa pisaar sape monar vato war ro e norava nae Samaria. ");
INSERT INTO lww_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Ana memial m̃a mepano, mepimi mop̃arpoyo e kumali tai, kiena ki Saeka. Ana lavisin kumali nene, pupia pulus nen wii tai mom̃a ga, nap̃a siar nakonua konua rui, pimi tol nagane, apio asape wii kiena ne Sekop. Porotano nene, nanua susumo pe kiena ne yermarua Sekop, ana siraunia naga tam̃an pa narina nap̃a Yosop. Ana memio Yesu memial mepim metol wii nene, mrae su va ruru nena, Yesu mloge yepena mimi vanon kiamimi pupia yalena e mrae m̃arera, p̃isi na pa totano e yepas nen wii nene. ");
INSERT INTO lww_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Mesum̃a e wii nene pano-o, p̃isi na imimi nalogena la mesum̃alu mepa e kumali pe na ulen kamimi kinanena, ana Yesu naga taaga pa ruru tom̃a ga. P̃isi na sira tai nae Samaria mial pimi sape vio wii. Naga pimi ana Yesu piun tania pisape “?Awis, okilia ovio re m̃a wii tai?” ");
INSERT INTO lww_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ana sira nene, pe kilia re Yesu poli, ana pisu kilia ga sane le Yu tai, ana milan pap̃isi nap̃a naga pis ruru po pan sanene, vanon e pogos nene, le Yu la amio le Samaria la pe apivis vitawa re poli. Ana piun tan Yesu, pisape “?Vanon ya ne ko na ope le Yu, opis panu, sira nae Samaria, opiun wii tan inu?” ");
INSERT INTO lww_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ana Yesu pisatam̃ea, pisape “!Sira, visae ko na okilia ga nalaena nowo nap̃a Ntewa sinena pisape la van ko! !Visae ko na okilia ga sape in na ai, nap̃a nepiun wii tan ko! Visae ve sa ga nene, pona ve in re nap̃a neviun wii tan ko, ana ko na nap̃a oviun wii tan inu. Ana pogos nap̃a visae oviun wii tan inu, nekilia nela wii nap̃a pe wii na laena malena van ko.” ");
INSERT INTO lww_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ana pogos nap̃a sira mloge sur nene, piun petan Yesu, pisape “Yar keviu, pe kiom̃a sur re tai nap̃a na vioen wii e poli, ana pulus nen wii nene naga pato tano pap̃isi. Ve sanene, wii na malena nap̃a opisa, yoko otol ve sanape, po yoko ovio lepas nape? ");
INSERT INTO lww_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ana opisa ke wii tap̃ena nene na, nane m̃eke nini naga pe wii tanea tai. Kieta yermarua na susumo nap̃a Sekop, naga m̃ana wii nanini. Naga mun ke ea, amio narina lala, kiena sur mal lala, amligan lelein pimi tol p̃ane. Ko na om̃ape ko opo taulu yermarua Sekop nene ana okilia ola wii tai nap̃a wo taulu nanini?” ");
INSERT INTO lww_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ana Yesu pisatam̃ea pisape “Lelaga, wii nene naga po, ana pogos nap̃a tomun pae na, ve piavi re na moto kar ita sina. ");
INSERT INTO lww_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ana yar nap̃a visae mun wii nap̃a nela vania, p̃isi na naga tap̃atete si moto karia. Yoko wii nap̃a naga munia, imi ve sa purp̃es nen wii si tai loyum̃a e kiena malena, ve wii na malena nap̃a ve uro re pogos tai, sum̃a lalau lue ga vetania, tap̃atete mema pogos tai.” ");
INSERT INTO lww_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ana sira nene pe kilia ruru re visena kiena ne Yesu nene poli wa, pisape “Yar keviu, visae sanene, popon ola re narin wii tai nene van inu, vena nemunia, ana ve moto kar inu re sina, ve netom re si e nini nevio wii.” ");
INSERT INTO lww_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ana Yesu sinenan sape sira nene kilia sape naga ai, ana pisa pania, pisape “Nevisa sur tai van ko sumo wa: ovato sina, oto ovio om̃a oure naga amiu lua avam si e nini.” ");
INSERT INTO lww_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","P̃isi na sira nap̃a pisape “Ee, pe wou re tai poli.” Ana Yesu pisa pania, pisape “Lelaga, ko na opisa ke mesmes ne, ko na pe om̃a re tai poli. ");
INSERT INTO lww_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nanene vanon yar la nap̃a ko na op̃ere la nanua sumo rui, la punu ga tol lima, ana nagane na osike sina amio tai, ana pe otalopa re amio poli. Sane kiom̃a visena pe lelaga ga, ko na pe om̃a re tai poli.” ");
INSERT INTO lww_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ana sira nene sinena pula pap̃isi nap̃a sane Yesu kilia ruru kiena malena sanene, pisape “Lelaga ga, yar keviu. Nenagane na nekilia narui, ko ko na navisawalena tai. ");
INSERT INTO lww_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Naga po pap̃isi ne, ana pona ko na navisawalena ga kiena ne le Yu la yo. Imimi le Samaria lala, kiamimi yo wa nane pupia tavie nane ma ne Kerasim, nap̃a repimimi la nasusumo amlotun Ntewa e konua rui, pimi tol nagane. Ana amiu le Yu lala, am̃areran ke asape pupia kumali wa kiamiu nap̃a Yerusalem, naga taaga ga pe lele mesmes na kilaen lotena van Ntewa. Sanene, a si na mesmesu narui, amiu pona imimi? Ovisali nene!” ");
INSERT INTO lww_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","22","Ana Yesu kekaran nakilaruruen sitomena kiena ne sira nene e p̃elaga mesmes na lotunen Ntewa, naga pisa pania, pisape “Lelaga vineu, opisa pe lelaga ne, lotena kieta italua pe maran taaga re poli. A nanene pe vanon re lele na kilaen lotena la lua, naga vanon sur na sanini. Amiu na yo nini, akila ke lotena, a pe akilia ruru re naga nap̃a amlotun ke poli, a imimi le Yu la, Ntewa kilaar pisape yaru na tamaliaen yeririna lala naga molue e kiamimi lusia, p̃isi na mekilia ruru Ntewa kamimi nap̃a memlotun ke naga. “Ana nekilia nevisa van ko sane yoko tap̃atete ve sanene. Monar olelaga e inu, nap̃a nepisa ke pan ko nagane, sane pogos tai ne pimi ke ne yoko nalotena viu tai siaria, nap̃a ve kieta ita punu ga. Le Yu amio le Samaria, ve tesitom̃al re si sape yo mesmes na lotunena Ntewa ea nane ma tavie ne, po kumali nap̃a Yerusalem, po yo tap̃ena si tai. ");
INSERT INTO lww_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","A pupia sur ga nap̃a tesitom̃alia, visae telotun Ntewa, na monar tetam̃an Ninuna Wa yum̃ae e ninuta, a monar telotun lelaga, torokin nap̃a kiena visena lelaga pisa. “Ana nanagane na Ntewa arimata kale ke yeririna la nap̃a akilia alotun naga e p̃elaga mesmesu na sanene. P̃isi na e pogos ne pimi ke na wa, po nap̃a pimi pa rui, yoko kiena p̃egas na lelaga na kiena lotena, alotun naga ve sanene. ");
INSERT INTO lww_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ntewa naga pe ninuna, ana yar nap̃a sape lotunia, monar lotun e ninuna, a suri nene monar ve lelaga e kiena malena.” ");
INSERT INTO lww_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","P̃isi na sira nene, naga mlelaga ke sape yoko Navisaarena imi, naga nap̃a visena nae Kris pisape Kristo, naga pisa pa Yesu pisape “Sur la nap̃a ko na opisa ke ne, pona pe lelaga yo, ana nemlelaga nesape Navisaarena nap̃a yoko imi, naga ke narui yoko visawal sur punu ga ve lelaga van imimi.” ");
INSERT INTO lww_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ana Yesu pisa ga narin visena nene pania, pisape “Nane ko na opisa ke ne, in ga nini, nane nesun ke nemio ko nagane.” ");
INSERT INTO lww_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Naga pisawal pa naga pan sira nene sanene, ana nalogena la ap̃asup̃e la sina apa atol yo nap̃ane. Apam na, apisu Yesu sun ke amio sira nap̃a ne, sane lalua ga, ana la sinela pulania. Sinela pula na aparurula ga, pe lala yar tai piun re petan sira nap̃ane pisape sinenan ya, po piun tan Yesu pisape lalua asunyu ke ya. ");
INSERT INTO lww_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ana sira nap̃a sum̃alu, mligan m̃ana piawi na wii m̃eke na, mial si pa um̃a e kiela kumali. Pogos nap̃a pa tol um̃a pisawal pan yeririna lala, pisape ");
INSERT INTO lww_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Wolawa le Yu tai sike tano garo puluwii, sun amio inu, kilia make sur punu ga e kiau malena. Nepisu sane Navisaarena kemua, po peraga? Amiu aimi, teto tevisulia.” ");
INSERT INTO lww_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ana lala asum̃alu apito tano asape avisu Yesu. ");
INSERT INTO lww_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ana pogos nap̃a lala amiyal ke apimi, akate re poli wa, nalogena la ap̃ar plan kala kinanena nap̃a apato apulia, apisa pan Yesu, asape “Navianena, oim okinana.” ");
INSERT INTO lww_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ana Yesu pimi re poli, ana apio sina ga pano-o p̃isi na Yesu pisape “Amiu akinana, in na kau kinanena tap̃ena tai teke na nap̃a amiu pe akilia re poli.” ");
INSERT INTO lww_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nalogena la amloge sanene na, la apisasa ke pan la, asape “?Ane kus kana kinanena nene pimi pania? !Pe tepisu re nena yar tai poli!” ");
INSERT INTO lww_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ana Yesu pisa pan la, pisape “Peraga, kinanena nap̃a nepisa ke ne naga pe tap̃ena. Kau kinanena, naga yum̃aena na logearen nasinenanena kiena ne naga nap̃a mligan inu nepitom tano, monar neyum̃aen punu ga vano-o p̃isi. ");
INSERT INTO lww_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pogos nap̃a temapila lokove, ita tepisayu lue ga tesape ‘Kupario vari sike ga wa, kinanena marua,’ ana nagane e lokove kana Ntewa yaru la asu ruru ke asape aloge kiena visena rui, la na asa ga kinanen la mamarua rui. Ana sineun nesape amiu avike li kilamaramiu lala, akirava ruru lia e yo lala, ana yoko akilia akirawal kinanena la mamarua ruru po rui, nagane pe pog na va waren imi. ");
INSERT INTO lww_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","37","Ana la nap̃a ava awaria, yoko akekara vap̃isi vanon kiela narin nalaen tai naga teke pa rui, ana pogos nap̃a awar kinanena la nene imi um̃a na malena nap̃a ve uro re, yar keviu nap̃a mapila, yoko naga m̃ena kekara vap̃isi. Naga sa ga visena nap̃a asape ‘Yar tap̃ena mapila, tap̃ena pa p̃aria, ana pupia kekarena pan yeririna punu ga!’ ");
INSERT INTO lww_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Sanene, in na nemligan amiu vena ava aure yeririna lala nap̃a li tap̃ena ga la akila pupia yum̃aena pan la rui, ana nanagane na amiu punu ga ayakol amiu veraga e na logewoena e yum̃aena nene.” ");
INSERT INTO lww_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ana pogos nap̃a le Samaria la e kumali nene amloge nap̃a sira nene pisape Yesu kilia make sur la punu ga e kiena malena, sinela pula pap̃isi, kila lala moki amlelaga e Yesu. ");
INSERT INTO lww_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ana pogos nap̃a apim asape avisuia, la asun m̃a amio naga pano-o, p̃isi na apiun tania asape visae mekilia meva um̃a amio la. P̃isi na mepa mesum̃a amio la pano-o tol legiena lua, ");
INSERT INTO lww_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ana la moki sina amlelaga e naga vanon kiena visena wo lala. ");
INSERT INTO lww_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Apisa m̃ena pa sira nene, asape “Nanua sumo, memloge sur la nap̃a opisa, memninue ga, a nanagane, memloge ruru nena kiena visena lala, mekilia sane pe lelaga ga narui, kieta yar keviu nene, naga pe Natamaliaena na yomarava.” ");
INSERT INTO lww_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ana legiena lua nene p̃aro pano, memio Yesu memligan yo nene, metaveve si kiamimi mrapa mepato si tano e lepas nap̃a garo Kalele. ");
INSERT INTO lww_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu sinenan sape wasup̃e si va gar kiena yo Kalele, komin nap̃a naga pisu li tap̃ena lala amaagan li visayuen naga, asum̃a akalewele silaga. Nanene taveve kiena visena tai, nap̃a pisape “Yeririna tap̃ena lala akekaran navatanon ruruen navisawalena, ana yeririna ga la na pulkumali puna na peraga, la asitom korenan ga naga.” ");
INSERT INTO lww_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ana pogos nap̃a mepa makate e yo nap̃a Kalele, yaru na kiena yo lala akekaran pap̃isi, aporworunia. Nanene vanon nap̃a sumo, lala moki la m̃ena asike e p̃ap̃agena ma Yerusalem, ana apisu pa natap̃aen m̃arera tai nap̃a Yesu miyum̃aen e Yum̃a Wa m̃ana ne Ntewa e pogos nene, ana apisu po pap̃isi. ");
INSERT INTO lww_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ana sun mialili ke yo lala nae Kalele pimi tol sina ga kumali nap̃a Kana, nap̃a nanua sumo kilapu wii pimi pe kuruta na munena. Ana e pogos nene pupia sup̃e tai nae pulkumali tap̃ena nae Kapeneam sike e yo nene, mloge ke piowa vanon narina yerm̃ene mai keviu pap̃isi, lavis ga mare. ");
INSERT INTO lww_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ana pogos nap̃a mloge asape Yesu p̃asup̃e ma Yutea pitomi si Kalele rui, naga pa kirawalia. Ana pisu Yesu, tag pania sinenan pisape va um̃a vena tamalia narina nene. ");
INSERT INTO lww_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ana Yesu pisa pania, pisape “Pona ko m̃ena sane yeririna tap̃ena la nene. Sinelan lue ga kile tap̃ena lala, ana visae neyum̃aenia, alelaga e in narui, a visae pe apisu re poli, pe akekaran re nalelagaena e inu poli.” ");
INSERT INTO lww_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ana pupia sup̃e m̃areran pania, pisape “Yar keviu, awis oimi vilaga, visae pere na naruu naga kovio.” ");
INSERT INTO lww_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ana Yesu tap̃ali nalelagaena kiena ne sup̃e nene, pisape “Peraga, ko ga taaga ovano. Nevisa van ko, narum̃a tap̃atete mare, mal m̃a woga ga.” P̃isi na naga mlelaga e visena nap̃a Yesu pisa pania, mligan yo pa si um̃a. ");
INSERT INTO lww_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ana e legien tap̃ena sina, pogos nap̃a p̃asup̃e ke si pavin, pitawe kiena yeririna lala, amial lulu ke mrapania. Ana apisa pania asape “Narum̃a mloge si pogaga teke na.” ");
INSERT INTO lww_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ana piun tan la pisape “Amiu asitom veve ruru lia: Pog ya ne naga siar mloge pimi po sina ga?” Ana apisatam̃ea, asape “Mepisu sane yepena pimi manin ruru nakoneva kolpae, sur tai sane koe aora taaga.” ");
INSERT INTO lww_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ana ariman yerm̃ene nene mloge na nene, kilia ga sape naga ke narui mesmesu ga aora nap̃a Yesu pisa pania pisape narina tap̃atete mare, mal ga woga ga. Ana sur nene kila naga, amio la punu ga na mratava puna, amlelaga e Yesu. ");
INSERT INTO lww_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ana natamaliaena kiena ne yerm̃ene nene, Yesu kila suraun nap̃a mligan ma Yutea pitomi, ana pe kiena kile nalua gar lepas nap̃a Kalele. ");
INSERT INTO lww_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ana Yesu sum̃a Kalele yam piavi m̃a pano-o, tol pog na p̃ap̃agena tap̃ena si tai kiena ne le Yu lala ma Yerusalem. Ana Yesu lala apa si metava e p̃ap̃agena nene. ");
INSERT INTO lww_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Asum̃a Yerusalem sanena e legien tai Yesu mial pito tano lavisin pulutava keviu na kumali nene nap̃a apio asape Pulutava Na Sipsip, ana apa lele tai nap̃a wii na kulena tai m̃eke ea, nap̃a e kiela visena apio kiena ki Petsaeta. Ana e yepas nen wii nene, silparpara la lima sike ea, amiyum̃aen e kilavaru. ");
INSERT INTO lww_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ana nalue ga inanena lala, kilamara kata lala, a laulu lala, amio la nap̃a yepela la marmare, la ne sanene amoki manene apim am̃eke e lepa yum̃a taaga la nene. Apim asike sanene, vanon wii nene yam peve taaga kulkulul, ");
INSERT INTO lww_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","sa nap̃a navisi kiena ne Ntewa tai pitomi kila wii nene kulkulul, ana pogos nap̃a apisu sanena, inanena la nene yar ai nap̃a va p̃es tol wii nene, yoko maiena ya nap̃a teke e yepena p̃isi veraga ga e pog nene. ");
INSERT INTO lww_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Sanene inanena la asum̃a apim e yo nene, ana lala yar tai nap̃a sike e pog nene, naga yepena marmare tol kas lualima yam telu pa orelu 38 rui. ");
INSERT INTO lww_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ana pogos nap̃a Yesu pimi, pisu yar nene, kilia sape yar nene monon inanena nene yam piavi sanene, piun tania pisape “?Kiau erau, ko na sinom̃an osape yepem̃a imi wo sina, ne?” ");
INSERT INTO lww_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ana inanena nene pisatam̃ea, sape “Yar keviu, sineun pap̃isi ne, ana pogos nap̃a wii kulul, pe yar nakusnuen re vito ligan nu e wii poli. Ana pogos nap̃a in ga taaga nekila wowen ke yo nayalvitoen tano, yar tap̃ena tai pitomi pito p̃es tano e wii sumon inu.” ");
INSERT INTO lww_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ana Yesu pis mesmes ga pan yar nene, sape “Pogaga, osum̃alu, okus mom̃a tog, oyali ovatove.” ");
INSERT INTO lww_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ana taveve visena kiena ne Yesu nene, yepe marmare la nene punu ga pimi po, naga sum̃al kus m̃ana tog mial pitove. Ana e legiena na sur nene pimi kate, naga pe legiena wa tai kiena ne le Yu la, ");
INSERT INTO lww_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","kila sane pogos nap̃a yar keviu p̃asia sa le Yu la apisu yar nene mial kus ke m̃ana tog, apis pan vanonia, akilawoia, asape “E, p̃a nini na pe Legiena Wa p̃a! Okus ke mom̃a tog sanene na okilaro ke kieta navisaluaena ita le Yu la ne.” ");
INSERT INTO lww_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ana pisatam̃e la, sape “In na yepeu pororowaia, ana yar nene pimi kila ruru inu, pisa panu sape nekus m̃au tog nevano.” ");
INSERT INTO lww_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","P̃isi na lala sinelan asape akilia laa sane wa, apiun tania, asape “?Ana a nene? ?Naga pe ane pisa pan ko sape okila sanene?” ");
INSERT INTO lww_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ana yar nene mninue ga visaena, vanon naga pe kilia re sape Yesu nap̃a kila ruru naga poli, a tap̃atete visu kilalea vanon p̃ina na yeririna la asike ea, ana Yesu mial p̃aroro likan yeririna lala, petan yo nene rui. ");
INSERT INTO lww_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ana siraunia pe piavi re poli, Yesu kirawal si yar nene e Yum̃a Wa, ana pisa pania sape “Nanagane omloge po si narui, popon ovisuar ruru ko. Oligan punu ga kiom̃a naviowaena lala, visae peraga yoko sur tai viowa sina ga imi van ko va re laa sane taulu na sumo.” ");
INSERT INTO lww_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ana e pogos nene yar nene kilia narui sape Yesu ga nap̃a kila ruru naga, ana pa pisawal pan yar keviu kiena le Yu lala. ");
INSERT INTO lww_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ana pogos nap̃a la amloge sape Yesu ke narui nap̃a tamalia, sinela karia, pe akekaran re nap̃a miyum̃aen sur nene e Legiena Wa, p̃isi na la asiar nap̃a apeveyunia. ");
INSERT INTO lww_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ana Yesu pisatam̃e la, sape “Kiau ata, naga miyum̃aen ke kiena yum̃aena wo lala e legiena make ga, pa tol m̃ena Legiena Wa, a in m̃ena monar neyum̃ae sa m̃a nena nap̃a naga miyum̃aenia.” ");
INSERT INTO lww_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sanene na e pogos nene, nasumonena kiena le Yu lala apisu ke pa Yesu narui sane pe yar na warnena kareen nawaena na Legiena Wa. A nanagane metavania, amloge nap̃a naga pio ke Ntewa sape Arimana wawa, apisu sane naga kila ke naga maran taaga ga sane Ntewa. Ana sur ne la nene kila sane la apim pisusun manene laa sane, sinelan manene laa na wemom̃aren naga mare. ");
INSERT INTO lww_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ana Yesu pisa pan la, sape “Nepisa pe lelaga pan amiu, in na narina ne Ntewa, tap̃atete nekila sur tai inu ga taaga, ana sur ga la nap̃a nepisu Arimau kila, naga ga nene nekilia nekila. ");
INSERT INTO lww_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","In na narina ne Ata Ntewa, naga sinen sii inu pap̃isi, kila pian inu e sur punu ga nap̃a naga sitom ke sape nekila. Ana yum̃aena tap̃ena si p̃asia sike ga wa, nap̃a kerkeviu laa sane, nap̃a war van inu vena neyum̃aen sirau, ana pogos nap̃a neyum̃aenia, yoko amiu sinemiu ulan vap̃isi ne. ");
INSERT INTO lww_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Naga m̃ena nanini, sa nap̃a Ata mla si malena pan la nap̃a amarmare, tam̃an si kiela malena pan la, ve sa m̃a nena nene inu narina nekilia nela malena van yar ai nap̃a sineun nesape nela vania. ");
INSERT INTO lww_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ana pe Ata re ga kila nalip̃ereena poli, ana yum̃aena m̃ena nene mligan e lum̃au, ");
INSERT INTO lww_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","vena kilaen yeririna punu ga monar avatanon inu sa ga nap̃a apatanon ke Ata. Ve sanene, visae yar nap̃a pe patanon ruru re inu narina poli, ana sa nap̃a naga pe patanon ruru re yerkawa nap̃a naga mligan inu nepitom tano poli.” ");
INSERT INTO lww_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ana Yesu pisa laa sanene, sape “Ayagogon ruru visena nene. Yar a nap̃a logear kiau visena, a lelaga e naga nap̃a mliganu nepitom tano, e ke e pogos nene tol malena. Naga pe su re nena vatanon nalip̃ereena m̃arera tai, sane petan p̃elaga na marena rui, pa tol kiena malena viu rui. ");
INSERT INTO lww_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“A nepisa visena nalelaga nini pan amiu, sane pogos pimi ke sirau nanagane nap̃a sane yar la nap̃a amarmare e p̃elaga naviowaena rui, aloge pulgou inu narina ne Ntewa, ana la nap̃a aloge kilia, yoko atol malena. ");
INSERT INTO lww_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kau Ata, malena nalelaga teke ga e naga, ana naga tam̃an malena nene sike e inu, ");
INSERT INTO lww_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","a tam̃an m̃ena sane inu Narina ne Yeririna, yoko nekila yum̃aena lala na lip̃ereena. ");
INSERT INTO lww_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Sur la nene pe pon re si sinemiu ulan poli, monar yoko ve sa ga nene e pog nap̃a nepisa ke nesape pimi ke ne. Yoko la nap̃a amomalio e porotano, aloge pulgou vio, ");
INSERT INTO lww_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ana amolmolue sina ga, ana la nap̃a amiyum̃ae po, kiela nasum̃alena si nene pe namalena, ana lala nap̃a amiyum̃ae piowa, kiela nasum̃alena pe nalip̃ereena.” ");
INSERT INTO lww_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ana Yesu pisa pa laa sane, pisa p̃arlologia ga pan yerkawa kiena ne le Yu la nap̃a amon nalelagaena e naga, pisayu sur la nap̃a kila meraravan sape naga pe lelaga. Pisa sape “E lepas nalip̃ereena nap̃a neyum̃aenia, yoko tap̃atete neyum̃aen e nasitomiena kiau in ga taaga, ana nekila ga e sur nap̃a nemloge Ata pisa. Ve sanene, kiau nalip̃ereena naga mesmes ga, vanon pe nekila re e kiau nasinenanena poli, nekila ga e nasinenanena kiena ne naga nap̃a mliganu nepimi. ");
INSERT INTO lww_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ana nepis sanene pan amiu, nekilia sane nepisayunu ke sina ga, pona amiu p̃as apisu sane pe pon re nevis ve sanene poli yo, tap̃atete alelaga e visena na sanene. ");
INSERT INTO lww_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ana pogaga, pe sur re tai nene po, vanon sur tap̃ena la p̃asia nap̃a kilia iila kiau visena sum̃al ruru wo. “Nasumo, naga yar tai nap̃a pisayu sur la nap̃a punu pe lelaga pap̃isi. ");
INSERT INTO lww_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nane Yoane Nakeena ne, nap̃a nanua sumo, amiu amligan visena pato pania, apiunu sanape petania, ana pisawal sur punu ga pe lelaga pan amiu. ");
INSERT INTO lww_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ana piowa ga nap̃a asitom asape kiau visena sum̃al sanene vanon ga visena kiena yaru tai sa ga Yoane. Ana sineun nesape amiu asitom ruru li e visena la nap̃a Yoane pisa pan amiu e lepas na punu, vanon nep̃aryon amiu ke vena akilia atol natamaliaena. ");
INSERT INTO lww_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","In na nepisa Yoane nene pan amiu, vanon naga sane pe kap tego tai na tegolien kiamiu sitomena lala, amiu nap̃a akekaran li m̃a naga. ");
INSERT INTO lww_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ana sur si tai naiilaen kiau visena, keviu laa taulu sur la nap̃a Yoane naga pisa. Naga kile la nap̃a Ata tam̃an panu nemiyum̃aenia e maramiu. Yum̃aena keviu la nap̃a nemiyum̃aen, lala amiila ke visena nene keviu sane pe lelaga Ata ne nanene mliganu nepimi. ");
INSERT INTO lww_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Ana metavan sur lua nene, tap̃ena tom̃a ga, nane kiau Ata nap̃a mliganu nepitom. Amiu pe amlogeli re pulgona poli, pe apisuli re marana po, ana naga m̃ena, kiena visena la miila kiau visena la keviu, nap̃a pisawal inu. ");
INSERT INTO lww_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ana amiu na akila sane visena nene pe lelena re e kiamiu malena poli, vanon amon lelagaen e naga nap̃a mliganu nepimi. ");
INSERT INTO lww_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yam moki asum̃a apisuveve ke Visena Wa lala, vanon amiu asitom ke asape yoko alual kiamiu malena nap̃a ve uro re ea, ana visena wa la nene nap̃a pisawal inu ga. ");
INSERT INTO lww_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Asape in na nepe purp̃es nen malena nene, ana amiu amon aimi atol malena nene e inu.” ");
INSERT INTO lww_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","P̃isi na Yesu pisu sane p̃arila m̃arera pap̃isi, pis sanini, sape “Sur la nap̃a nekila ke ne, pe nekila re nesape amiu ayeluar kiau ki, peraga. Pe nesitom̃al re nene poli, ");
INSERT INTO lww_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ana sur viowa tai, nekilia ruru amiu pa rui, ana nekilia sane pe asitom manene re nena Ntewa poli. ");
INSERT INTO lww_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Pogos nap̃a nepim nakaten amiu, nepim e ki kiena ne kiau Ata, ana amiu pe akekaranu re poli. Ana visae pogos tai yar tap̃ena imi, nap̃a imi ga e kiena ki naga taaga, pona amiu akekaran ga naga yo. ");
INSERT INTO lww_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sineu mie amiu pap̃isi, ana nepisu sane m̃arera pan amiu pap̃isi nap̃a atol nalelagaena nalelaga pogos tai. Nanene vanon amiu sinemiun lue ga nayeluaren kiamiu ki va metava. Amiu pe asitom re asape akilia avilopu si kiamiu p̃elaga poli, vena akila sur la nap̃a siraunia Ntewa kilia yeluar amiu vanonia. ");
INSERT INTO lww_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Nepisa visena la nene pan amiu, pona amiu asitom ke asape ‘E, yar nene sinen kar ita, pona e legiena nalip̃ereena naga visawal kieta naviowaena la van arimata Ntewa ma e peni!’ A peraga, ve in re nap̃a nekila sanene, ana yar tap̃ena naga kila. Tap̃ena nene nane yermarua Mosis, nap̃a amiu ap̃asine ke naga asape yoko visa visena na iila amiuena, ana nevisa ruru van amiu, naga ke narui nap̃a yoko visa plan ga kiamiu naviowaena lala. ");
INSERT INTO lww_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Amiu na apisa ke asape amlelaga ke m̃arera e visena kiena ne yermarua Mosis nene, ana visae ve sanene, vanon ya ne amiu pe amlelaga m̃ena re e in poli, vanon yermarua nene, naga siriyunu lue ke ga. ");
INSERT INTO lww_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ana nanagane, nepisu sane amiu pe amlelaga re e kiena nasiriena la poli, ana komin suri ne nanene yoko tap̃atete m̃ena alelaga e kiau visena lala.” ");
INSERT INTO lww_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Siraun naga nene, memio Yesu memiai e wa tai memligan si kiena yo nene, mepa mokusro pupia lapa nap̃a nae Kalele, nap̃a la p̃asia apio asape Lapa Taepirias. ");
INSERT INTO lww_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ana pogos nap̃a yeririna la apisu imimi mepa ke sanene e lepas navano, la m̃ena ga asum̃alu asiraun imimi. Asape ataveve Yesu vanon apisu kile natamaliaena la nap̃a miyum̃aen pan inanena lala. ");
INSERT INTO lww_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ana pogos nap̃a mepa metol lepas nene, mepa metava e kunus tai nap̃a m̃eke e yo nene, memial m̃a mepano-o, memapi. ");
INSERT INTO lww_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","5","Ana pogos nap̃a Yesu totano teke na kira pa gar tena, pisu pupia p̃ina la apim ke puna. Pisulup̃ar sane la moki, ape yeririna na yo tap̃ena ga la ne amlapran la ke apato Yerusalem. Apatovin ke pupia p̃ap̃agena kiena le Yu lala, P̃ap̃agena na Sitom̃alen Natamaliaena, nap̃a yoko ve yam ve piavi re na akila. Ana pogos nap̃a Yesu pisu la apimi, piun sur tai pa Pilip, pisape “Pilip, la nam̃a na viso kar la ke pap̃isi ne. ?Yoko toul kala kilaparavi ve sanape ne?” ");
INSERT INTO lww_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Naviunena kiena ne Yesu, pe natap̃aliena ga Pilip, vanon Yesu kilia pa rui sur nap̃a yoko kila van yeririna lala nene. ");
INSERT INTO lww_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","P̃isi na Pilip pisatam̃ea, pisa ga pisapenua “Visae neyum̃ae kas ve taaga, tap̃atete netaulu kilavaru torokin naulen kala kinanena lala la punu ga akan ve torokaki!” ");
INSERT INTO lww_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ana nalogena tap̃ena tai, Antru, nap̃a wenla Saemon Pita na ve tokak, pisa pa Yesu, pisape ");
INSERT INTO lww_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Sup̃e, nekirawal teras tai teke e nini, p̃ar ke narin kilaparavi lima amio narin ika lua. Nanene tekaki ga, vanon yeririna la mok pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ana Yesu pisape “Peraga, poga ga ne, ovisa van p̃ina la nene ovisave atotano wa.” Mepisa pan la, p̃isi na atotano e vilum̃ini lala, ana mepisu sane yerm̃ene ga lala tol sur sane manu lima 5000. ");
INSERT INTO lww_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","P̃isi na Yesu p̃arar kilaparavi la lima nene, mlen, pisa potena vanonia. Siraunia siar kaweroroia, piovion pan la nap̃a atotano ke ne, kila m̃ena sa ke ga e ika, mla make ga pan la torokin nap̃a sinelan asape akania. ");
INSERT INTO lww_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ana akan m̃a pano mep̃ela la kawa, p̃isi na Yesu pisa pa imimi, pisape “Korkoro kinanena la ne sike ne, ve tekila kare re, ana popon awarpolo va lele taaga.” ");
INSERT INTO lww_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ana mepa mop̃ar kinakina kilaparavi la lima nap̃a ne, nap̃a akanligania, mokon pa e karo pano-o tol karo lualima taaga pa lua 12. ");
INSERT INTO lww_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ana pog nap̃a yeririna la apisulup̃ar pupia kile nap̃a Yesu miyum̃aenia, apisa ke pan la sanini, apisape “Kieta pupia navisawalena nap̃a kieta li marua la apisaar asape imi kate e yomarava nini, yar ne na nene navisawalena ke narui.” ");
INSERT INTO lww_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ana la asitom ke asape ava atarar Yesu, asape am̃areran vania vena avisirlua sum̃al imi ve kiela p̃arin sup̃e, ana pogos nap̃a mnunulup̃ar sur nap̃a la asitom ke asape ayum̃aenia, naga petan la, naga taaga mial pa laa sane metava e kunus la nene. ");
INSERT INTO lww_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ana imimi nalogena la mepisu mrae pato ke tano narui, mepisu sane popon sa mowasup̃e imimi sina, ana mepato si tano e yepas nen lapa. ");
INSERT INTO lww_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mepato tano ana pe mom̃a re Yesu katen imimi si poli, ana vanon yemalo pa rui, a mokus kiamimi waa, memligan si yo nene mepalua mepanon vena mokusro lapa meva ma Kapeneam. ");
INSERT INTO lww_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ana mepa ke sane, na narin lagi tai miyui li m̃aga, kila sive siar piowa m̃a pap̃isi. ");
INSERT INTO lww_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ana pogos nap̃a mepaluan pa laa tol sane kilometa lima, memilan Yesu mial ke metava e sive pimi ke lavisi. Ana memaraun naga pap̃isi, ");
INSERT INTO lww_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ana naga pis pan imimi, pisape “!Ee, amiu ve amarau re! In ga ne.” ");
INSERT INTO lww_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ana memloge po sina, metar pa meta e waa, ana veraga ga mepisu kiamimi wa monlologia ke lele nap̃a mesape meva ea. ");
INSERT INTO lww_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ana kolulag, la nap̃a e lepas nen lapa, nap̃a Yesu pagan la ga na wa, asitomwele ke asape sanapen Yesu narui. Asitom ke sanene vanon pogos nap̃a memio Yesu mepim pula, mokus waa taaga ga, ana apisu imimi nalogena la mokus waa nene mepa pa rui, a Yesu pe amio imimi re poli, naga taaga sike na. A nanagane tap̃atete si alual naga amio la, ");
INSERT INTO lww_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","24","ana la apa akus waa tap̃ena lala, akusro apa Kapeneam akale imimi. Waa tap̃ena la nene, la pe kiela re poli, kiena ne la nae Taepirias nap̃a apim akaten la, apim ga ura e nap̃a Yesu mlenwo kilaparavi, kila pimi torokin nap̃a akania. ");
INSERT INTO lww_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ana yeririna la nap̃a ne apam atol Kapeneam, apa ura, apa akale Yesu. Ana pogos nap̃a am̃alia, apiun tania, apisape “?Navianena, ko opam otol e nini pogwai?” ");
INSERT INTO lww_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ana Yesu kilia pa sur nap̃a la asape avisu vanonia, naga pisatam̃e la, pisape “Visae apamin akale inu sina vanon apisu kiau kile lala a apisulup̃ar inu sane in na ai, visae ve sanene na po na. Ana in na nepisu sane asitom̃al asape nakoneva nepagan ruru amiu, akinana pano-o m̃ep̃emiu la kakawa po, ana amiu sinemiun si asape ve sa nene p̃ane, yo? ");
INSERT INTO lww_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","“Poga ga, kiau visena na lelaga van amiu naga sanini: ve asitom̃al manene re si kinanena nap̃a yoko ve ve piavi re na naga kona make sina. Popon ayum̃ae m̃arera vanon kinanena nap̃a sulue ga, kilia sum̃a ga sanene vano-o tol pog na malena nap̃a pe luas re poli. Lelaga, in na Narin Yeririna nekilia nela malena nene van amiu, vanon Ntewa arimau kilaar pan inu rui in ga taaga vena nekila ve sanene.” ");
INSERT INTO lww_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ana apiun tania, apisape “Ana sa imimi sinemimin mesape mekila sur la nap̃a Ntewa sinenania, yoko monar meyum̃ae ve sanape?” ");
INSERT INTO lww_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ana Yesu pisatam̃e pan la pisape “Pupia sur nap̃a Ntewa sinenan sape ayum̃aenia, sanini, sape alelaga lelaga e in nap̃a Ntewa miila inu nepim e yomarava nini.” ");
INSERT INTO lww_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ana apiun ke sina ga, apisape “?A ko, kiom̃a kile ya nap̃a sa mevisuia, yoko mekilia melelaga e ko? Ko na yoko okila yum̃aena wo ya ne van imimi? ");
INSERT INTO lww_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mepiun ke sanene vanon mesitom̃al kieta li marua la na susumo ne, nap̃a asu e yokorena. Asum̃a sanena Mosis kila kile wo tai pan la, nap̃a silaga la ap̃ar kilaparavi nap̃a apio mana, ana akania, pe visokar la re nena ga. Sur nene teke e Tus Wa, a pisa sape ‘Silau ga naga pagan la e kilaparavi nae ma e peni!’” ");
INSERT INTO lww_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ana Yesu pisatam̃e la ke sina ga, pisapenua “Lelaga, sur nene teke e Tus Wa, ana kilaparavi nap̃a Mosis mlavia, pe pe kilaparavi nae re ma e peni poli. Kilaparavi nap̃a nae ma e peni nalelaga, arimau ga kilia lavia. ");
INSERT INTO lww_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kilaparavi kiena ne Ntewa naga inu ga ne nap̃a nemligan ma e peni nepitom tano, vena nela malena viu van yeririna na yomerava lala.” ");
INSERT INTO lww_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ana apisatam̃ea, asape “Sup̃e, kilaparavi ke nene narui nap̃a imimi sinemiminia silaga.” ");
INSERT INTO lww_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ana Yesu pisa pan la, pisape “Inu, in na kilaparavi na malena. Yar a nap̃a vim pun inu, tap̃atete si viso karia, yar ai nap̃a lelaga e inu, tap̃atete si moto karia. ");
INSERT INTO lww_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ana sur taaga ga na piowa, sa nap̃a nepisa pa pan amiu rui, nap̃a apisu inu amio kiau kile lala e kilamaramiu rui, ana amon lelagaen e inu. ");
INSERT INTO lww_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ana monar yar p̃asia alelaga e inu, vanon la punu ga nap̃a Ata mligan sike e lum̃au, yoko monar aim pun inu, a la punu ga nap̃a aim pun inu, ve lala yar re si tai nap̃a nekilia nekuan lua sina, yoko nowarar ruru punu ga ave kiau. ");
INSERT INTO lww_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“In na nemligan ma e peni nepitom tano e yomerava nini, pe nakilaen re nasinenanena kiau poli, ana pe nakilaen nasinenanena kiena ne naga nap̃a mligan inu nepitom tano. ");
INSERT INTO lww_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A pupia kiena nasinenanena sanini, sape la nap̃a naga mligan la asike e lum̃au, yoko ve nekilalu re lala yar tai, naga sinenan pisape e legiena maro nevisir plan la punu sina ga. ");
INSERT INTO lww_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ata sinenan manene laa pisape ve sanene narui, nap̃a la punu ga nap̃a avisu inu, ana alelaga e inu, yoko atol malena nap̃a pe luas re poli, a sinenan manene m̃ena pisape e legiena maro, yoko in na nevisir plan la sina ga.” ");
INSERT INTO lww_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ana pogos nap̃a yerkawa kiena ne le Yu lala amiyagogan ke visena kiena ne Yesu, pe akekaran re nenaga, ana la apis lili m̃a vanonia. Kiena visen tai nap̃a amon logeena, nane visena nap̃a pisawalia sape naga pe kilaparavi nap̃a petan ma e peni pitomi tano e yomarava nini. ");
INSERT INTO lww_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Apisayu pan la, apisape “?Sanape ne yar nene pisa ke pan ita pisape petan ma e peni metava pitomi tano pun ita? Naga pe yar re tai nene po, tekilia ruru pa naga rui, anena amio arimana. Naga Yesu ga p̃a, narina yermarua Yosop.” ");
INSERT INTO lww_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ana Yesu pisatam̃e la, pisape “!Ei, visen mumu la e inu p̃isi, amiu ayagoga ruru kone wa! ");
INSERT INTO lww_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yar ai nap̃a imi lelaga e inu nagane, e legiena maro nevisirlua naga mal sina ga. A ata nap̃a tam̃an inu nepimi, visae naga ve ure re yaru nene vim, ana tap̃atete nena kilia imi punu. ");
INSERT INTO lww_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tus kiena ne navisawalena Aisea pisawal visena tai, pisape ‘Lala punu ga, yoko Ntewa ga vian la,’ ana komin nanene, nepisape la nap̃a aloge ruru visena kiena Ata Ntewa nap̃a naga vian ruru la ea, lala nene aim pun inu. ");
INSERT INTO lww_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ana la ne sanene, pe lala yar re tai nap̃a pisu ke Ata Ntewa poli, vanon yar taaga pisu ke naga, nane inu nap̃a nepetan ma puna nepitom. ");
INSERT INTO lww_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Nepisa ke lelaga pan amiu, sane yeririna punu ga nap̃a alelaga e inu, asike pa loyum̃a e malena nap̃a ve uro re rui, ");
INSERT INTO lww_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","vanon inu, in na kilaparavi na malena. ");
INSERT INTO lww_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kilaparavi nene pe maran taaga re poli sa nap̃a kilaparavi nap̃a mana nap̃a yermarua la akan e yokorena. Akan m̃a pano-o, ana siraunia pe lala yar tai mal lue re si teke poli, lala punu ga amarmare ga sa nene. ");
INSERT INTO lww_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ana visae kilaparavi tai tom̃a ga, visae yar nap̃a kania tap̃atete mare pogos tai, na nene tepio tesape kilaparavi nae peni lelaga. ");
INSERT INTO lww_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Pogaga, in ke narui nepe kilaparavi na malena nene, nap̃a petan ma e peni pitomi tano e yomarava nini, vena yar nap̃a kania, yoko mal lue. Kilaparavi ne nanene naga pe tasneu, netam̃an ke panon yomarava wetelu, nemla ke panon malena kiena ne kiena yeririna lala.” ");
INSERT INTO lww_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ana visena kiena ne Yesu la nene, m̃arera pan yerkawa kiena ne le Yu la nene akilia ruruia, ana apiun ke asape “?Ya nene? Yar nene pisape yoko war kana kilam̃iu van ita vena tekania, po pisa ke ya ne?” ");
INSERT INTO lww_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ana Yesu pisa meraravan pan la e lepas na kinas nen kiena marena, pisape “Nepisa lelaga pan amiu, sane amiu monar akan kiau kilam̃iu inu Narina Yeririna, amiu monar amun kau kuruta. Visae peraga, kiau malena tap̃atete te amiu. ");
INSERT INTO lww_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","A naga nap̃a kan kau kilam̃iu, a mun kau kuruta, naga tol pa malena nap̃a pe luas re poli, ana nevisirlua si naga sum̃alu e legiena maro, nekila naga mal sina ga. ");
INSERT INTO lww_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nanene komin kau kilam̃iu, naga pe kinanena tap̃ena tai, a kau kuruta, naga pe na munena tap̃ena tai. ");
INSERT INTO lww_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Naga nap̃a kan kau kilam̃iu, mun kau kuruta, kiena malena wetelu sike e inu, a kiau malena wetelu sike e naga. ");
INSERT INTO lww_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ata naga pe purp̃es nen malena, ana mligan inu nepimi, a nemalin ke kiena malena nap̃a teke e inu, ana naga nap̃a kan kau kilam̃iu yoko naga mali e kiau malena nap̃a teke e naga. ");
INSERT INTO lww_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Sur ne nanene nap̃a nepisa ke e kiau visena e lepas na kilaparavi nap̃a petan ma e peni pitomi tano. Kilaparavi nene naga pe sa re kilaparavi nap̃a repita nasumo la akan poli, ana amare ga sanene. Naga pe kilaparavi nap̃a yar a nap̃a visae kania, naga kilia mal lue narui.” ");
INSERT INTO lww_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Visena ne la nene Yesu pian lan ke e yum̃a na lotena nae Kapeneam. ");
INSERT INTO lww_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ana komin nap̃a Yesu pisa visena la nene, ana imimi kiena nalogena la moki asitom pano-o, apisa asape “Kiena navianena la nene m̃arera pap̃isi. ?A si na kilia loge kilale ruruia?” ");
INSERT INTO lww_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ana Yesu mloge kilale e naga sane kiena nalogena lap̃as apis lili m̃a vanon naga sa nene, naga piun tan la, pisape “?Sanape, pe akekaran re kiau narin visena nene poli? ");
INSERT INTO lww_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Narin visena ga nene, kila amiu asape aliganu sina? Visae ve sanene, nemninue amiu narui. Sane visae pogos tai, inu Narin Yeririna neligan amiu neva si metava ma e leleu, ana yoko sanape ne? Pona sinemiu p̃esan ruru inu yo? ");
INSERT INTO lww_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kiau visena la nene ape mrapa na Ninuna a mrapa na malena. Yaru kilia war si yaru, ana yaru tap̃atete la malena lelaga nene va yaru tap̃ena. Sur nene Ninuna ne Ntewa ga kilia lavia. ");
INSERT INTO lww_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ana nevisu kilale amiu lap̃asia amlelaga pa rui, a amiu p̃as peraga.” Yesu pisa naga nene, vanon siar nanua rui, naga kilia pa la nap̃a pe amlelaga re e naga po, pano-o tol nap̃a naga kilia lala ai nap̃a awilwilin wan naga. ");
INSERT INTO lww_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ana Yesu pisa m̃ena ga pan la, pisape “Lala p̃asia alelaga, p̃as ve alelaga re, naga nene nepisa ruru visena nene rui, nesape tap̃atete yar tai vim punu, nap̃a sa arimau naga ve tam̃an re naga imi.” ");
INSERT INTO lww_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ana e pogos nene imimi kiena nalogena lap̃as apisu sane navianena kiena Yesu la nene am̃arera laa narui, apisu sane peraga, ana ap̃asup̃e la sina, pe ataveve re si naga poli. ");
INSERT INTO lww_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ana pogos nap̃a Yesu pisu lala p̃as amligan si naga, pis pan imimi kiena nalogena lualima taaga pa lua 12, piun pisape “?A sanapen amiu? ?Pona sinemiun asape amiu m̃ena ava sina ga amio la nene?” ");
INSERT INTO lww_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ana Saemon Pita pisatam̃ea, pisaar m̃arera pa Yesu, pisape “Sup̃e, visae meligan ko, yoko mesiraun si a ne? Ko ga taaga nap̃a lologena wo na malena teke e ko, ");
INSERT INTO lww_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","nanagane na memlelaga ke ga e ko ga taaga, a mekilia pa rui mesape ko, ko na Navisaarena Wa nap̃a Ntewa mligan ko opimi vena otamalia imimi.” ");
INSERT INTO lww_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ana Yesu pisatam̃e pisape “Lelaga, in na nekiar amiu kiau lualima taaga pa lua, vena alelelaga e inu sanene, a tai teke m̃ena likan amiu naga pe Yermare Lego ruru nenaga.” ");
INSERT INTO lww_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ana Yesu pe pisawal re kiamimi kia lala tai e pogos nene poli, ana siraunia mepisu kilale sane kiena visena nene, naga pisa ke Sutas, narina ne yermarua Saemon nae Kariot, nap̃a naga imimi na lua lima taaga pa lua tai, nap̃a pe sitom re poli, p̃ililinwan si kiena Sup̃e naapo. ");
INSERT INTO lww_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Siraun naga nene, Yesu mial telilivi ke ga e yo lala na tavie na kiena yo nene Kalele. Naga pe pa re si metava e yo na tavie nae Yutea poli, vanon nasumonena sa le Yu la nae yo nene akale ke naga rui, asape awe mom̃ar naga mare. ");
INSERT INTO lww_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ana pogos tai, lavisin pog na kiela pupia p̃ap̃agena kiena le Yu la tai, nap̃a P̃ap̃agena na Silparpara. Ana sa nap̃a silaga, la moki sinelan asape avavini ma Yerusalem vanonia. ");
INSERT INTO lww_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ana e pogos nene, wenla Yesu lala apis pania, apisape “E, ko na ose nini yam piavi rui, popon ova li ma Yutea, vena kiom̃a nalogena la ma ne la towe avisu kile la nap̃a okila ke ne. ");
INSERT INTO lww_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ko na sinom̃an osape yeririna la akilia ruru ko, ana omiyum̃ae tapolou ke ga. Visae lelaga nap̃a omiyum̃aen ke pupia kile lala, popon ovanon okate yo punu ga e yomerava.” ");
INSERT INTO lww_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ana visena la ne sanene, sa nap̃a apisa kare ke ga Yesu, vanon lala na ape wenla ruru naapo, ana pe amlelaga re e naga poli. ");
INSERT INTO lww_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ana Yesu pisatam̃e la, pisape “Amiu akilia akila ga kiamiu sur ya e ga e pog nap̃a amiu sinemiun asape ayum̃aenia, ana kiau pupia pogos naga pe pimi re poli wa. ");
INSERT INTO lww_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Amiu akilia akila ga kiamiu yum̃aena la woga ga, yeririna la tap̃atete avisa kare amiu vanonia, ana pogos nap̃a in na nekila kiau yum̃aena, nepisawal sane p̃elaga viowa kiena la na yomarava pe mesmes re poli, ana la sinela kar inu pap̃isi. ");
INSERT INTO lww_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ve sanene na amiu ga ava ma Yerusalem, in na nesum̃a e nini wa. In na tap̃atete neva nakaten maran yar lala e p̃ap̃agena nene, vanon kiau pog pimi ke rui, ana pe pimi punu re poli wa.” ");
INSERT INTO lww_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Naga pisa visena nene pan la, siraunia apavin, naga sum̃a ga. ");
INSERT INTO lww_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu sum̃a sane na, pe piavi re poli, naga m̃ena pa ma Yerusalem, ana pe pa re sa nap̃a yeririna la akilia poli, naga tapoloun la ga. ");
INSERT INTO lww_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ana yerkawa kiena le Yu lala, asitom ke pa rui sape pona naga m̃ena ga vam e p̃ap̃agena, ana la akalewele, apiun asape naga m̃eke pe. ");
INSERT INTO lww_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ana yeririna m̃ena lala, asun apisayu lue ga naga, lap̃asia asape naga pe yar wo tai, lap̃asia asape naga pe yaru viowa ga, nap̃a kila kare ke ga sitomen kien yeririna lala. ");
INSERT INTO lww_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Asun apisayu ke Yesu sanene na, pe apisawal manene re pa e yo metava poli, vanon asitom ke asape visae kiela yar keviu la aloge, yoko akila viowa van la. ");
INSERT INTO lww_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ana akila m̃a p̃ap̃agena pano-o, legiena p̃as p̃aro rui, ana Yesu pisu sane monar va ma Yum̃a Wa M̃ana ne Ntewa vena vian si yeririna lala. ");
INSERT INTO lww_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ana pogos nap̃a yerkawa kiena le Yu la amloge kiena navianena nowo lala, amilan pap̃isi, apisape “!Sanape na yar nene kilia ruru visena kiena ne Ntewa sanene? !Naga pe apian re nena ga, ana kiena navianena po na po!” ");
INSERT INTO lww_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ana sanene na Yesu pisawal pan la, pisape “Sur nap̃a nepian lan ke ne, pe kiau re poli, pe kiena ne Ata ga nap̃a mligan inu nepitom tano e yomarava nini. ");
INSERT INTO lww_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Visae yar tai kekaran ga kila nasinenanena kiena ne Ata, yoko naga kila yar nene loge kilia sitom ruru kiau navianena. Yoko yaru nene kilia visu kilale sane in na pe nepian re yeririna la e ga e kiau kia poli, ana kilia visu kilale sane navianena la nene, pe lelaga nap̃a amolue kemua e Ntewa. ");
INSERT INTO lww_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Visae tevisu yar tai vis ke ga e kiena kia, tekilia ga sane naga miyeluar ga kiena kia. Ana visae yar nap̃a pis, miyeluar ke ga kia kiena ne kiena yerkawa nap̃a mligan naga pimi, tekilia ga sane pe lelaga ga, naga pe pisokan re poli. ");
INSERT INTO lww_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Yar tai ne kila sanene nane Mosis. Ntewa mla kiena navisaluaena pania, a naga pisaliluen pimi pan amiu, ana asum̃a akilaro ke pa narui. Ana sanape na asape awem̃ar inu vanon asape nekilaro navisaluaena. ?Pogaga na sanene?” ");
INSERT INTO lww_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ana yeririna la apisatam̃ea, apisape “!Kue-e, nagane na opis wowe ke ga, sa ga yermare tai teke e ko! ?Ane sape wem̃ar ko? Ovisawal lia.” ");
INSERT INTO lww_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ana Yesu pisatam̃ea, pisape “Nanua e pogos nap̃a nepim e yo nini, in na nekila pupia kile tai e maramiu, netamalia laulu nene. Ana pogos nap̃a apisuia, pe akekaran re poli, apisape in na nemiyum̃ae piowa ga nap̃a nekila sanene e Legiena Wa. ");
INSERT INTO lww_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ana popon asitom̃ali kieta p̃elaga na kilaen p̃aviu, sa nap̃a yermarua Mosis amio yermarua na sumo tap̃ena lala, sane Epraam lala, la amla pan ita. Naga m̃ena pe yum̃aena tanea, ana visae kana legiena nena sulologia Legiena Wa, pe asitom̃al re poli, amiyum̃aen ga. ");
INSERT INTO lww_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Amiu asum̃a apisa ke asape amon kilaroen navisaluaena kiena ne Mosis, ana atam̃an luen ga asape nakilaen yum̃aena na p̃aviu e Legiena Wa pogaga. Ana visae atam̃an nene, vanon ya ne sinemiu karnu keviu vanon ga kiau narin yum̃aena wo taaga ga nene nap̃a nekila ruru si yepen yaru nene e Legiena Wa? ");
INSERT INTO lww_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nepisu sane asitom veve ke sur la ne e ga e kulusia, ana popon ave manmarua li laa sane, asitom veve ruru li sur la va tol kana kilam̃iu.” ");
INSERT INTO lww_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ana e pogos nene yeririna moki nae Yerusalem apisu Yesu pian la ke e Yum̃a Wa, amilania, apisape “!Lelaga nap̃a ne! Yar ga nene nap̃ane, nap̃a yerkawa la apisa ke asape awem̃aria. ");
INSERT INTO lww_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ana nagane pisawal ke ga kiena visena la sanene, ana pe akila re si surian poli. Pe tekilia re poli, pona amon visaen vania vanon apisulup̃aria sane lelaga, yaru nene, kieta Navisaarena lelaga. ");
INSERT INTO lww_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ana peraga, tap̃atete naga, vanon kieta nalelagaena tai p̃a rui, sape Navisaarena, pogos nap̃a naga kate, yoko tap̃atete yar kilia sape naga su pe na pimi ne. Ana yaru nap̃a Yesu, ita punu ga tekilia ruru pa m̃ana um̃a rui.” Apisa sanene komin am̃ape Yesu na paeme Nasaret, ana peraga, naga paeme Petleem. ");
INSERT INTO lww_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ana vanon nap̃a apisa ke sanene, Yesu p̃aryon ga navian laena loyum̃a e Yum̃a Wa, pisawal visena nene pan la, pisape “Asitom asape akilia inu, akilia ke lele nap̃a nepim ea, ana in na nepisu sane pe akilia ruru re poli. Nepimi e nini, pe e re ga e kiau sitomena poli, ana yar tap̃ena ga mligan inu nepimi, nap̃a naga pe purp̃es nen lelagaena. A sa nap̃a amninue inu ga, ana amninue m̃ena naga. ");
INSERT INTO lww_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","A naga, in ke narui nap̃a nekilia ruru nena naga, vanon naga ke narui nap̃a mligan lua inu nepitom tano e yomarava nini.” ");
INSERT INTO lww_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ana visena kiena ne Yesu la ne sanene kila am̃areran asape monar atarar naga, ana pe yaru re nena tai nap̃a kilia tol naga, vanon kana pog ne pe pimi re poli wa. ");
INSERT INTO lww_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Asape awe mom̃ar naga, ana yaru la moki amlelaga e naga rui, vanon kile la nap̃a miyum̃aenia. Apisa sanini, asape “!Yoko Navisaarena nape nap̃a kilia imi kila si kile ya la nap̃a yuve naga? Peraga, yar nene kieta Navisaarena ke lelaga narui.” ");
INSERT INTO lww_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ana Varasi la p̃asia asum̃a amiyagogon ke yeririna la amiilaar ke Yesu e kiela visena lala, ana apa iroro ga, apis pa pupia yar wa lala, na apiranar asape monar akila ga sur tai va Yesu nagane ga ne. Ana amligan kiela lokul navisuaren Yum̃a Wa lala, asape ava akale pulmas tai na tararen Yesu, vena aure si naga vim pula. ");
INSERT INTO lww_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ana Yesu pisawalia, pisape “Yoko in na nekilia nesu si nemio amiu yam ve plas ga, p̃isi na nowasup̃e sina puna ne naga nap̃a mligan inu nepimi. ");
INSERT INTO lww_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pogos nap̃a sa nowasup̃e pae na, amiu akilali nap̃a akale inu vano-o yoko tap̃atete alual inu. Lele nap̃a neva nese ea, tap̃atete aim ea.” ");
INSERT INTO lww_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ana pogos nap̃a yerkawa kiena ne le Yu la amloge visena nene, asitom p̃ele narui, apisa ke pan la, apisape “?Yar nene pisa ke yo nape ne, nap̃a yoko va ea a p̃isi na tap̃atete ita telual si naga ea? Pona sitom ke pisape va e yo tap̃ena lala e yomarava nap̃a wenla ita le Yu lala ap̃ure apa ea e pog na pupia yaltetaena, ana pisape va vian la m̃ena ga? ");
INSERT INTO lww_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ana naga pisa ke ya nene, sape takale naga vano-o tap̃atete telual naga. Ana sanapen kiena visena nap̃a pisape naga pa ke lepas tai nap̃a tap̃atete tesiraun naga, tap̃atete teva ea.” Ana e pogos nene, lokul na visuaren Yum̃a Wa la pe atarar re Yesu poli wa. ");
INSERT INTO lww_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ana akila m̃a p̃ap̃agena nene pano-o, apa atol kana legiena maro, nap̃a sane pe kana pupia legiena nena. Ana pogos nap̃a asike veraga, Yesu sum̃al pion manene sanini, pisawal pisape “Amiu a nap̃a moto karia, popon imi pun inu, mun wii na malena. ");
INSERT INTO lww_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yar nap̃a mlelaga e inu, yoko wo van vap̃isi, sa nap̃a Nasiriena Wa pisa, pisape !Yar na sanene, yoko losinena ule mamagan wii na malena, vano vano-o tataroi vetania sa nap̃a wii mlau!” ");
INSERT INTO lww_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ana visena kiena Yesu nene, kana kinasia na Ninuna Wa, vanon naga kilia sape siraunia, lala nap̃a alelaga e naga, yoko atol Ninuna Wa. A e pogos nene, Ninuna Wa pe pimi re poli wa, vanon Yesu sike yomarava wa, pe pa totano re e kiena lele wa poli wa. ");
INSERT INTO lww_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ana pogos nap̃a yeririna la amloge Yesu pion sane na, kiela sitomena la pa pe tap̃ena lala. La p̃asia, apisa asape “Yar nene, naga navisawaliena sane Mosis, nap̃a temlelaga tesape yoko imi.” ");
INSERT INTO lww_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","La p̃asia apisa asape “Ana, pona visae peraga, naga pe kieta Navisaarena kemua.” Ana la p̃as apisatam̃ea, apisape “Peraga, pe visena re tai nap̃a pisa sanene sape Navisaarena yoko ve yeririna nae Kalele sane yar nene poli. ");
INSERT INTO lww_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nanene komin nap̃a kieta Nasiriena Wa la apisa ke ga asape Navisaarena naga molue ga e lus kiena ne P̃arin Sup̃e Tepet, yoko ve yeririna nae Petleem.” ");
INSERT INTO lww_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ana p̃arin sitomena moki la ne sanene kila narui yeririna la asu tetai vanon Yesu. ");
INSERT INTO lww_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","La p̃as pe akekaran re poli, apisu sane popon akuan va e yum̃a nakoaena, ana siraunia peraga, pe yar tai pa re lavis puna poli, vena tararia. ");
INSERT INTO lww_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ana siraun sur la nene, lala na visuaren Yum̃a Wa apa sina ga puna ne p̃arin yar wa amio Varasi lala, vena kilaen navisawalena lala van la. Ana pogos nap̃a am̃alivi e marala, yar keviu la nene pe apisu re Yesu poli, ana apis pan la, apisape “?Awa yar nap̃a memligan amiu apanonia? ?Vanon ya ne amiu pe ap̃ure re naga pimi poli?” ");
INSERT INTO lww_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ana navisuarena la apisatam̃eia, apisape “Imimi memiagogon kiena visena lala po na po, pe yar re si tai poli nap̃a kilia vian ruru ita wo sane naga.” ");
INSERT INTO lww_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ana navisatam̃eena nene kila Varasi la amilania, apisape “!Aulai, nagane na amiu m̃ena, yar nene p̃ere kiamiu sitomena la pa pe wowe! ");
INSERT INTO lww_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Amiu atam̃an naga pisa kotalia amiu, ana sanape, apisu sane e imimi yar kerkeviu lala pona imimi Varasi lala, la p̃as amlelaga ea? Peraga yo. ");
INSERT INTO lww_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lala ga nap̃a amlelaga ea, nane p̃ina viowa ga la nap̃a asike ko laa ne, a la pe akilia re sur poli. Pe akilia re kieta navisaluaena poli, Ntewa piain pa nakoaena pan la rui.” ");
INSERT INTO lww_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Asum̃a apis m̃arera ke sane na, lala yar tai kilayon ke sape kila kiela visena vito si tano. Nane Nikotimas, nap̃a nanua sumo e yemalo tai pa sun amio Yesu. ");
INSERT INTO lww_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Naga pisa pan la, pisape, “Ita tepisayu ke yar na sanene na, sa ga nap̃a ita temla ke pa nalip̃ereena pania. Ana kieta navisaluaena pisa lepas nene, pisa sape visae tesape tevis van yar tai, monar tetotano ruru temio e kumali, tela pog vania vena naga kilia visawal kiena sitomena van ita, ana monar teviun naviunena vania vena tekilia tekirawal tesape lelaga kemua naga kila sanene sanene po sanape. Naga nene pe mrapa mesmes nakilaen yum̃aena nene.” ");
INSERT INTO lww_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ana la pe sinelan re yagogonen kiena visena nene po, vanon apisu sane naga miilaar ke Yesu. Apis pania, apisape “!Aulai, ko na opis ke sa nap̃a ko m̃ena ope yar nae si Kalele tai! Asitomrurulia sur nap̃a Visena Wa pisa. Pe visena re nena tai nap̃a pisa sape yoko navisawalena viu tai sum̃alu garo Kalele vam e nini.” ");
INSERT INTO lww_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ana kiela visena pa m̃arera e lele nene, p̃is na la amial tetai sina ga ap̃asup̃e si m̃ala um̃a lala. ");
INSERT INTO lww_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ana Yesu mligan Yum̃a Wa, mial pa si ma Kunus Na Purolip Lala. ");
INSERT INTO lww_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Monomi e nene, ana yemlagi kolulag mial pato si Yum̃a Wa M̃ana ne Ntewa. Pogos nap̃a yeririna la apisuia, la moki apim puna, naga totano pian la. ");
INSERT INTO lww_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ana pe piavi re nena ga, navianena navisaluaena lala amio Varasi lala ap̃ure sira tai pimi puna, akila sum̃al e marana ne yeririna lala. Sira nene, atarar ke sanene vanon asape kila kolau, ana lap̃as apisuia, apisawalia. ");
INSERT INTO lww_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ana akila naga sum̃al sanene, apis pa Yesu, asape “Navianena, sira nene, akirawal kila ke kolau. ");
INSERT INTO lww_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ana sa nap̃a navisaluaena kiena ne Mosis pisa e lepas na mlamulena viowa nene, nanagane na monar mokove mom̃ar ga naga mare. Ana navisaluaena kiena ne le Rom lala naga sape yoko tap̃atete mokovem̃ar yaru. A ko na sanape, kiom̃a sitomena sanape?” ");
INSERT INTO lww_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ana naviunena nene, pe apiun ruru re pa Yesu poli, ana akila ke ga natap̃aliena pania, vena visapal sur tai nap̃a siraunia akilia ala nalip̃ereena vanonia. Ana Yesu pe pisatam̃e re poli, p̃arina tau pito tano, kian mrasilmana siri visena tai e porotano. ");
INSERT INTO lww_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ana apiuyun ke pania asape sanapen sira nene, ana Yesu tom̃al ruru sina, pis pan la narui. Pisa pan la, pisape “Pogaga, ana amiu yar nap̃a kove p̃es sira nene, naga monar ve yaru tai nap̃a pe naviowaena tai to re nena e naga.” ");
INSERT INTO lww_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ana yam si tai, pulu si pato tano, siri si visena tap̃ena e porotano. ");
INSERT INTO lww_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ana pogos nap̃a amloge sur nap̃a Yesu pisa pan la, asiar nap̃a amiyal tetai si lala. Naga nap̃a sumon la, kiela yermarua tai, a siraun naga, lala tap̃ena m̃ena lala apiayapa apavano, pano-o sira nap̃ani naga taaga sum̃al sike e marana Yesu. ");
INSERT INTO lww_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ana Yesu kira pa pisuia piun tania, sape “?Sira, la nap̃a asike pe nagane? ?Pe lala yar re si tai sape lip̃ere ko poli?” ");
INSERT INTO lww_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ana sira pisatam̃ea, pisape “Sup̃e, pe tai re si poli.” Yesu pisa pania, sape “Pogaga, in m̃ena tap̃atete nelip̃ere ko. Ko, okilia owasup̃e ko sina ova mom̃a, ana ovavini ve okila re si naviowaena.” ");
INSERT INTO lww_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ana siraunia Yesu pisi pan la, pisape “In na nepe yomerarava na yomarava, yar a nap̃a taveve inu tap̃atete si yal e yemalolo, yoko yomerarava namalena teke e naga.” ");
INSERT INTO lww_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ana p̃isi na le Varasi la p̃asia nap̃a asike wa apilon si kiena visena, apisape “Ko na opisa sanene, ko ga omiila ke si kiom̃a visena, ko na op̃arwar ko wa! Sanene na, imimi tap̃atete melelaga ne, kiom̃a visena pe pe lelaga re poli.” ");
INSERT INTO lww_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ana Yesu pisatam̃ea, pisape “Pona nekila sanene yo, ana kiau visena la punu ga amio kiau vianena la ape lelaga. In na nekilia sur punu ga e inu, sane nesu pe na nepim e nini, po nesike e nini p̃isi na nowasup̃e si neva pe, ana amiu pe akilia in re nena poli. ");
INSERT INTO lww_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Amiu amlip̃ere in ke ga e sitomena kiena ga yeririna lala, ana in na pe nemlip̃ere re ga amiu yar ta poli. ");
INSERT INTO lww_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ana visae pogos tai nelip̃ere yeririna lala, yoko kiau nalip̃ereena mesmes ga, vanon ve in ga taaga re nekila, nemio naga nap̃a mligan inu nepimi. ");
INSERT INTO lww_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","“Ana e kiamiu navisaluaena, asiri sanini asape visae yar la ve lua aviranarla e visena tai, p̃isi na monar alelaga ea, ");
INSERT INTO lww_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ana yoko monar ve sa m̃ena nene e imimi lua kau ata. In na nepisa ke nesape in na nepe lelaga, a naga miilaar inu, ana kila sane monar alelaga e inu narui.” ");
INSERT INTO lww_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Lala amloge visena nene, apiun tania, asape, “?Ko na opisa ke arimom̃a nene, ana sike pe nagane?” Yesu pisatam̃e la, pisape, “Amiu amninue ga naga, sa nap̃a amiu amninue inu ga. Visae amiu akilia ruru inu, yoko kila amiu akilia ruru m̃ena naga, ana tap̃atete si aviun naviunena na sanene, ana peraga.” ");
INSERT INTO lww_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Visena la nene, Yesu pian la ke e Yum̃a Wa, e lepas nap̃a akuan ruru nalaena lala kiena ne Ntewa sike ea. ");
INSERT INTO lww_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ana Yesu pisa m̃ena pan la, pisape “In na nepur matan amiu ke narui. Pogos nap̃a neva pae na, akalenu vano-o tap̃atete awal inu, yoko amare amio kiamiu naviowaena lala. In na nepa ke e lele tai nap̃a amiu tap̃atete avam ea.” ");
INSERT INTO lww_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ana pogos nap̃a yerkawa kiena ne le Yu la amloge visena nene, apiunia asape “?Yar nene sinenan pisape kila ya? Pisape va e lele tai nap̃a ita tap̃atete teva ea, pisa ke sape yoko we mom̃ar naga mare yo?” ");
INSERT INTO lww_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ana Yesu pisape “Kiamiu sitomen lala amio kiau naga peve tap̃ena manene laa. Amiu na ape nae ga yo tano nini, inu na nepe nae yo na ma metava. Amiu na yomarava nini, in na pe nae re e poli. ");
INSERT INTO lww_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ana sa ga nap̃a nepisa ga na wa, yoko amare ga amio kiamiu naviowaena lala. Visae pe amlelaga re e in poli, nap̃a nepe naga nap̃a sike na sike lue narui, yoko monar ve sa ga nene.” ");
INSERT INTO lww_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ana apiun, asape “Ko ovisa li sina osape ko na ai.” Ana Yesu pisatam̃e la, pisape “In na nepe naga ga nap̃a siar na konua rui pimi tol nagane, nepisa ke nesape in na nepe naga. ");
INSERT INTO lww_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Naga ga nene nepisa ke e lepas na punu. Ana e lepas na pun amiu, sur la moki nap̃a nekilia nevisa, ana visae nevisa, pe visen nalip̃ereena ga punu ga. Ana sur la ne nepisa ke ne e yomarava nini, naga pe visena ga la nap̃a nemloge tan naga nap̃a mligan inu, vanon silaga, kiena visena la mesmes pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesu pis merarava ga sanene, pisayu ke arimana nap̃a ma e peni pan la, ana pe akilia ruru re nena poli. ");
INSERT INTO lww_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ana pis si pan la, pisape “Pogos nap̃a yoko amiu atelan pae inu Narina Yeririna metava e laki, yoko akilia ga na wa sa nap̃a in na nepe kiamiu Navisaarena. Yoko amiu avisu kilale nap̃a sur punu ga nap̃a nemiyum̃aenia, pe nekila re ga in ga taaga poli, silaga nepisa ga sur la nap̃a Ata pisa pian inunia. ");
INSERT INTO lww_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Naga ke narui nap̃a mligan inu nepimi, a naga sike amio inu nagane. Naga pe mliganu li re poli, vanon silaga nekila ke sur punu ga sa ga nap̃a naga kekarania.” ");
INSERT INTO lww_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu pis ke sanene, kiena visena la p̃ere le Yu la moki amlelaga e naga. ");
INSERT INTO lww_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ana Yesu pis pan le Yu la nap̃a amlelaga mare ga e naga na wa, pisape “Visae awarar kiau visena m̃arera, amiu alogearia, amiu ave kiau nalogena la lelaga. ");
INSERT INTO lww_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yoko akilia ruru visena lelaga, ana visena lelaga kilia kila sen loru si vetan amiu.” ");
INSERT INTO lww_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Apisatam̃ea, apisape “Ee, imimi na lus kiena yermarua Epraam, imimi pe memiyum̃ae koren kiena ne re yar keviu tap̃ena tai poli. ?Ana sanape ne osape sen lala alolor vetan imimi?” ");
INSERT INTO lww_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu pisatam̃e la, sape “Nepisa lelaga pan amiu, yeririna punu ga nap̃a asum̃a akila ke naviowaena, la ape nayum̃ae korenaena na naviowaena, sen la na viowaena apiar m̃areran la. ");
INSERT INTO lww_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ana asum̃a amiyum̃ae korena ga kiena ne yar keviu na naviowaena, ana pe ape namratava re puna poli. A inu, in na nesulue ga nemio Ata, komin in na namratava nena puna. ");
INSERT INTO lww_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ana in na sisi nae ma e peni, visae noul plan amiu, yoko amiu m̃ena akilia asulue amio inu ma um̃a.” ");
INSERT INTO lww_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ana Yesu pisa ke sina ga pan yeririna lala, pisape “Nekilia ruru amiu na, ape lus nena kiena ne yermarua Epraam, ana lus kiena ne Epraam la narui nap̃a popon sa akekaranu. Ana peraga, amiu lap̃asia na lus ga nene nap̃a kiau visena pe towawa ruru re e kiamiu malena la poli, sinemiun manene asape awe mom̃ar inu. ");
INSERT INTO lww_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ana popon amiu alelaga e kiau visena lala, vanon in na nepisawal ke ga sur la nap̃a nepisuia pogos nap̃a nesike puna ne Ata, ana amiu na akila ke ga nap̃a amloge arimamiu pisa.” ");
INSERT INTO lww_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ana apisatam̃eia, asape “Lelaga, vanon arimamimi, yermarua apua Epraam na sumo sumo laa.” Ana Yesu pisa pan la, sape “Peraga yo! Visae amiu ape narina ne yermarua Epraam lelaga, popon amiu towe lai akilali sur wo la ve sa nap̃a naga miyum̃aenia. ");
INSERT INTO lww_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ana pere, amiu akila piowa manene laa pap̃isi. Sane inu, in na nepe yar tai nap̃a nepisa plan ke ga visena na lelaga la nap̃a Ntewa pisa pan inu, ana amiu asape awem̃ar inu. ?Pona amiu asitom ke asape p̃elaga wo ke narui nap̃a kiamiu yermarua Epraam sape akila? ");
INSERT INTO lww_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Peraga, nepisu sane pe naga re nene po, ana arimamiu tap̃ena ga tai sike ga wa, nap̃a amiyum̃ae kiena ke.” Ana la apisape “!Ke ya ne! !Osape okila imimi meve sisi na mrapa lala, memninue ga arimamimi! Armamimi taaga ga nalelaga nap̃a sike, nane Ntewa.” ");
INSERT INTO lww_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ana Yesu pisape “Visae visena nene lelaga, sape Ntewa pe arimamiu, yoko amiu monar akekaran manene inu, vanon in na nepetan ma puna nepitom tano e nini. In na nepim re ga sanene poli, naga ke narui mliganu nepimi. ");
INSERT INTO lww_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","In na nepisasa ke sur la nene pan amiu pano-o, ana silaga amiu pe amloge kilale re nena ga. Nemninue amiu ga, vanon ya ne yepemiu mavin logekilaleen kiau visen sanene? ");
INSERT INTO lww_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Amiu na arimamiu na Yermare, ana amiu sinemiun ga asape akila sa nap̃a naga sinenania. Siar nanua sumo e nasiarena pimi, naga pe yaru na wemom̃aren yaru, pe sinenan re visena nalelaga poli, pe sum̃al re nena e lepas nene poli. Kiena p̃elaga mesmes, pis lue ga e pupia visokanena lala, vanon naga pe purp̃es nen navisokanena punu ga, pe ariman navisokanena. ");
INSERT INTO lww_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Naga sanene, ana pogos nap̃a in na nepimi, nepisawal visena na lelaga wo pan amiu, ana siraunia amiu amon lelagaen si e inu. ");
INSERT INTO lww_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","?Ana amiu ane kilia visalua kiau naviowaena tai? ?Ana visae amiu apisu nepis pe lelaga, vanon ya ne amon lelagaen e inu? ");
INSERT INTO lww_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","“Yar nap̃a kiena ne Ntewa, naga sum̃a miyagogon ruru visena kiena ne Ntewa. Ana amiu la nap̃a pe sinemiun re aloge kiena visena la poli, nekilia sane nanene vanon pe ape kiena re nena ga.” ");
INSERT INTO lww_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ana visena m̃arera la nene kiena ne Yesu kila yerkawa kiena ne le Yu la nene amloge piowa, ana apiun pania, apisape “Imimi na memloge asape ko na pe ope yere Yu re lelaga poli, ko na ope apkas nae ga Samaria tai. Ana mepisu nap̃a yermare tai teke e ko, kila ko ope wowe li m̃aga. ?Visena la nene ape lelaga, po peraga?” ");
INSERT INTO lww_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ana Yesu pisatam̃e pan la, pisape “Peraga, pe yermare tai to re e inu poli. Sur la nap̃a in na nekila ke ne, nekila ke ga vena kia kiena ne ata va metava. Sur la nap̃a amiu akila panu, akila nap̃a kiau kia pato tano. ");
INSERT INTO lww_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ana pe pe sur re tai pan inu poli, vanon in na pe nemiyum̃aen re nap̃a na kilaen kiau kia va metava poli. Ana yar keviu tai m̃eke nap̃a sinenan pisape yeririna la popon avatanon inu, ana naga taaga ga kilia la nalip̃ereena e lepas la nene. ");
INSERT INTO lww_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ana visena tai nap̃a lelaga nekilia nevisa van amiu sa nini, visae amiu yar tai larar kiau visena m̃arera, logearia, yoko tap̃atete va tol marena pogos tai.” ");
INSERT INTO lww_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ana le Yu la amloge visena nene, apisa pania, asape “Nanagane na mekilia ruru nap̃a yermare sike pa e ko rui. Ko opisape yar nap̃a lelaga e ko tap̃atete mare, ana pe yar tai nap̃a yoko tap̃atete ve mare re pogos tai. Yermarua Epraam mal m̃a pano-o mare, a navisawalena lala, lala m̃ena amiyum̃ae m̃a pano-o amare. ");
INSERT INTO lww_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","?Pona ko na opisu sane oto laa metavan kieta yermarua wa la nene yo? ?Ko na ositom ke osape ko na a si ne?” ");
INSERT INTO lww_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ana Yesu pisatam̃e la, pisape “Visae nevisawal van amiu, pona avisu sane nemiyeluar ke sina ga kiau kia, ana avisu viowa ga. Yar tap̃ena ga tai kila ke kiau kia pa metava, naga nap̃a asape pe kiamiu Ntewa, naga kau ata ne. ");
INSERT INTO lww_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Naga, amiu pe akilia re poli, ana in na nekilia ruru naga. Pe nepisokan re sane amiu poli, nepisa ruru ga ne, nesape in na nekilia ruru naga, a kiena visena punu ga, nemligan ruru sike e kiau malena. ");
INSERT INTO lww_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nekilia nevisa m̃ena ga sane repimiu yermarua Epraam, naga tai nap̃a nanua sumo sinenan pisape visu kiau pog nane p̃ane. Naga sinenan pisape visu nap̃a nomolue e kiena lusia, nevim nekila kiau yum̃aena nini, ana pogos nap̃a naga siar pisu ke pa rui, naga kekara na kekara.” ");
INSERT INTO lww_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ana le Yu la apiunia, asape “Ana ko na pe ope yermarua re tai ne sane naga po, kiom̃a kas pe tol re lualima yam lima poli wa. ?Ana sanape na opisa ke osape okilia yermarua Epraam na sumo ne? Ko opisu naga koyo tai?” ");
INSERT INTO lww_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ana Yesu pisatam̃ea, pisape “Nepisa pe lelaga pan amiu, sane yermarua Epraam na nanua sumo ne, in na nesumon laa naga. Pogos nap̃a naga pere wa, ana inu in na naga nap̃a su sumo rui.” ");
INSERT INTO lww_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ana pogos nap̃a le Yu la amloge Yesu pisa narin visena ga nene, nap̃a sane kia wa kiena ne Ntewa, ana akilia asape naga pisa ke sape naga Ntewa, ana sinela mimi pap̃isi. Akale kilavaru na kovemareen Yesu, ana naga tapoloun la, mligan Yum̃a Wa, pure sina ga pano. ");
INSERT INTO lww_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ana imimi nalogena lala memio Yesu memial mepano, ana pogos nap̃a mepa ke sane na, mekirawal yaru tai nap̃a pogos nap̃a paeme, naga pe kilamara p̃ala. ");
INSERT INTO lww_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ana mepiun tan Yesu, mesape “?Navianena, sur ya ne kila yar nene? ?Pona nakoaena na kiena mlamulena viowa ga yo, po nakoaena na mlamulena viowa kiena ne anena po arimana, kila naga pe kilamara p̃ala sanene?” ");
INSERT INTO lww_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ana Yesu pisatam̃ea, pisape “Peraga, pe kiena naviowaena re poli, a pe naviowaena kiena re kiena yermarua lua poli, a naga paeme sanene vena kilaen ga sane yoko yaru la akilia avisu puriukawaena kiena ne Ntewa yum̃ae e kiena malena. ");
INSERT INTO lww_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sanene, yoko netamalia naga nanagane, komin pogos nap̃a yemlagi ke ga wa, monar teyum̃ae m̃arera, monar teyum̃aen kiena yum̃aena lala nap̃a naga mligan inu nepimi. Yemalolo naga pimi ke narui, nap̃a tap̃atete teyum̃ae ea. ");
INSERT INTO lww_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","A nanagane na, in na nesike tano e nini, in na nepe yomerarava na yomarava nini.” ");
INSERT INTO lww_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu pisa sanene, p̃isi na plasiria yavi na porotano p̃asia, pulou p̃alelar pimi sane kene, plan e kilamaran yar nap̃ane luwoka. ");
INSERT INTO lww_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ana pis pania, pisape “Pogaga, ovano oto tano e pulus nen wii nap̃a Siloam, okevan ruru si maram̃a.” Wii nap̃a Yesu pisa pania, kiena kia Wii Na Liganen Vano. Ana yar nene pito tano kila sanene, ana kilamarana pimi po. P̃isi na p̃asup̃e si pun imimi memio Yesu, sane naga kilia kira pisu sur narui. ");
INSERT INTO lww_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ana siraunia, la nap̃a nalavis puna ne yar nene, amio la nap̃a na sumo asum̃a apisu naga mlogi ke, apisu si naga, apisa asape “?Kilamara p̃ala ke nene narui, nap̃a nanua sum̃a monon mlolog kare ke ne, po pe naga re poli?” ");
INSERT INTO lww_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ana lala p̃asia apisape “Ee, naga ga nene ne,” a p̃asia asape “Peraga, yar tap̃ena ga tai ne kus marana ne,” ana yar nene pisa meraravan pan la, pisape “In ga nini.” ");
INSERT INTO lww_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ana pogos nap̃a pisawal pan la sane na, apiun tania asape “?Ana sanape na kilamaram̃a po sanene?” ");
INSERT INTO lww_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ana pisatam̃e la, pisape “Yar nap̃a Yesu, naga miyum̃aenia. P̃alelar narin kene amio kiena vilasirena, plan e kilamarau, ana pisape netotano e wii nap̃a Siloam ne, neke plan si vetan kilamarau. Ana nekila ga sanene, nepitove, nekevan marau, nepisu sane kilamarau po narui.” ");
INSERT INTO lww_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ana apiun Yesu tania, asape “?Yar nene m̃eke pe nagane?” Pisatam̃e la, pisape “Nemninue ga, pe nepisu re si po.” ");
INSERT INTO lww_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ana siraunia, ap̃ure yar nap̃a sumo pe kilamara p̃ala, ap̃ure naga pa puna Varasi lala vena avisulia. ");
INSERT INTO lww_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ap̃ure naga pa sanene vanon legiena nap̃a Yesu kila ruru kilamaran yaru nene, naga pe Legiena Wa, ana la asitom asape Yesu kila yum̃aena tai nap̃a navisaluaena na legiena wa pisa lup̃aria. ");
INSERT INTO lww_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ana pogos nap̃a apa apisawal pan Varasi lala, apiun tania, asape “Pogaga, ko towe ovisayu meraravan sanape nap̃a kilamaram̃a pimi po.” Ana naga pisa ga sanini, pisape “Peraga, yar nene mligan ga narin kene e kilamarau, ana nepa neke plan sina ga, nekilia nepisu ruru si sur punu ga.” ");
INSERT INTO lww_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ana pogos nap̃a Varasi la amloge, lap̃as apisape “Yar nap̃a kila nanene, naga kila sa ga sitom korena ga navisaluaena na Legiena Wa. Sanene na, naga pe molue re nena e Ntewa pitomi poli.” Ana la p̃asia asape, “Peraga, visae pe lelaga nap̃a pe yar viowa ga tai na kilaroen navisaluaena, sanape na naga kilia kila kile wo la ne sanene.” Ana apisayu m̃a sanene pano-o asum̃alu ase sitomena lua narui. ");
INSERT INTO lww_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ana apiun ke sina ga tan yar nap̃a nanua pe kilamara p̃ala, apisape “?Ana ko, ko nap̃a naga miyum̃aen kilamaram̃a, ko na ovisa ya ne e lepas na yaru nene?” Naga pisatam̃e ga la nena, pisape “Naga pe navisawalena lelaga tai.” ");
INSERT INTO lww_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Naga pisa sanene, ana yerkawa kiena le Yu la pe amlelaga re e kiena navisawalena la nene poli, pe amlelaga re asape nanua sumo yar nene pe kilamara p̃ala, a nagane kilia kirava. Ana apio arimana amio anena vena avim avisu la. ");
INSERT INTO lww_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ana pogos nap̃a lalua apim, apiun tan la, asape “Avisu ruru li yar nene. ?Naga pe narimiu kemua lelaga, nap̃a asape paeme ana pe kilamara p̃ala, pona pe naga re poli? ?Ana visae naga, sanape na kilamarana pimi po si sanene?” ");
INSERT INTO lww_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ana lalua apisatam̃ela, asape “Imimi lua mekilia mesape naga pe narimimi, mekilia mesape pogos nap̃a mop̃aria, pimi tol nanagane, naga pe kilamara p̃ala nenaga. ");
INSERT INTO lww_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","A pe mekilia re mesape naga kilia pisu ruru si sur la nanagane, pe mekilia re a ne kila ruru si kilamarana sanene. Ana popon aviun ruru ga tania, naga pe pe sisi re poli, kilia vis.” ");
INSERT INTO lww_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Lalua apis sanene, akilawan li m̃a kiela sitomena, vanon yerkawa kiena ne le Yu la apisayu pa rui, apisawal asape yar nap̃a mlelaga sape Yesu pe Navisaarena, yoko akuan lua ve su re si amio la e Yum̃a Wa M̃ana ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Apisawal sanena lalua amaraun pap̃isi, kila apisa ga asape amninue ga, asape “Popon amiu aviun ga tania, naga pe pe sisi re poli.” ");
INSERT INTO lww_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ana pogos tap̃ena si tai na, apio kilamara p̃ala na nanua ne pimi loyum̃a pula. Apis m̃arera pania, asape “Ovisa kia kiena ne Ntewa na mava, ovisa ke sur la punu ga nene van imimi ve lelaga, vanon nagane na mekirawal pa rui sane yar nene pe yar viowa kemua na kilaroen navisaluaena.” ");
INSERT INTO lww_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ana naga pisatam̃e la, sape “Naga pe yar viowa pona pe yar wo, in na pe nekilia re poli. Sur taaga nekilia, sanini. Nanua sumo, kilamarau p̃ala nena ga, ana nanagane na nekilia nepisu sur punu ga.” ");
INSERT INTO lww_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ana apiunia, asape “?Ana visae sanene, miyum̃aen ko sanape? ?Kila ruru kilamaram̃a sanape?” ");
INSERT INTO lww_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ana naga pisatam̃e la, sape “Nepisa meraravan ruru sur punu ga nene pan amiu yam tai p̃a rui, ana amiu amon logeena, ana nanagane na sinemiun asape aloge sina ga. ?Vanon ya? ?Pona amiu m̃ena sinemiun asape aim ave kiena nalogena la yo?” ");
INSERT INTO lww_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Naga pisa sanene, sa nap̃a pisa kare li la m̃a ga, ana la sinela kar manenea, apeveyunia asape “!Oo! Ko ga ope kiena nalogena tai, imimi na mepe nalogena la kiena ne yermarua wa Mosis. ");
INSERT INTO lww_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mosis nene, mekilia ruru mesape pe lelaga nap̃a Ntewa pisawal kiena visena pania, ana e lepas na yar tap̃ena nene, imimi pe mekilia re poli, sane naga yar nae pe pimi sanape.” ");
INSERT INTO lww_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ana yar nap̃a pisatam̃ea, sape “!Kue-e, nemilan amiu pap̃isi nap̃a pe akilia re naga poli! Naga kila ke pupia yum̃aena la sanene, pano-o kila ruru kilamarau, ana amiu akilia re asape naga ai po naga yar nae pe. ");
INSERT INTO lww_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tekilia tesape visae yar viowa vio van Ntewa, yoko Ntewa tap̃atete yagogonia, a visae yar nap̃a pe yar na lotena a mlogear ke naga, visae vio vania, yoko yagogonia. ");
INSERT INTO lww_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ana yaru nene, Ntewa miyagogon ke naga, vanon siar e nasiarena na yomarava nini pimi tol nagane, pe apisuli re yar tai nap̃a kila ruru si kilamaran yaru tai pogos nap̃a paeme pe kilamara p̃ala. ");
INSERT INTO lww_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Yar na monar petan ga Ntewa pitom e nini, visae pere, naga tap̃atete nena kila sur tai ne sanene.” ");
INSERT INTO lww_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ana lala pe akekara re nena nap̃a yar nene pis sanene pan la, asape “E, ko ope yar viowa kemua tai. Ko na p̃elaga na mlamulena viowa pulemamaga e ko siar e pogos nap̃a opaeme pimi tol nanagane. ?Ana ko ko na ai ositom ke osape okilia ovian imimi sina ga?” Apis kare naga sanene pano-o, p̃isi na am̃enelua si naga pa vanua. ");
INSERT INTO lww_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ana pe piavi re nena ga Yesu mloge asape am̃enelua yaru nene sanene, ana pa m̃alia, piun tania, pisape “?Sanape? ?Nanagane na ko na omlelaga pa e Narin Yeririna rui, po pere?” ");
INSERT INTO lww_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ana yar nap̃ane piun tan Yesu, pisape “?Ana naga nap̃a ko opisa ke ne, naga ai? Visae ko na okilia ovisali van inu, pona nekilia nelelaga e naga.” ");
INSERT INTO lww_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ana Yesu pisatam̃ea, sape “Ko na opisu pa naga rui, ko opisu ke naga nagane. In ga p̃a, nane nepis ke nemio ko ne.” ");
INSERT INTO lww_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ana pisatam̃ea, sape “O Sup̃e, visae sanene, in na nemlelaga nena ga e ko.” Ana yar nene p̃aryon lue ga na yeluaren Yesu. ");
INSERT INTO lww_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ana Yesu pis pisape “In na nepim e yomarava nini vena nevisusuveve yeririna lala, vena kilaen sane yeririna la nap̃a kilamarala p̃ala akilia avisusu suria, a vena kilaen sane yeririna la nap̃a asitom ke asape akilia apisu sur punu ga, avisu kilale sane la ape kilamara p̃ala ga.” ");
INSERT INTO lww_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ana Varasi la p̃as asum̃a lavis ga, amloge visena nene, apiun tania asape “?Ana opisape sane imimi m̃ena kilamaramimi p̃ala ga, a?” ");
INSERT INTO lww_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ana Yesu pisatam̃e la pisape “Visae pe lelaga nap̃a amiu apisu kilale asape kilamaramiu p̃ala, po li m̃a ga, yoko amiu tap̃atete akilia awar nakoaena vanonia. Ana pogos nap̃a visae apisa ke asape akilia avisu ruru sur punu ga, sanene na pupia naviowaena sike pa e amiu rui.” ");
INSERT INTO lww_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ana Yesu pis pa re laa sane, pisa p̃akaiwa tai pan la, e lepas na kove kan sipsip, nap̃a amiyum̃aen pae ana sipsip kiena ne yeririna punu ga akilia ava amomalio loyum̃a veraga. Naga pisa sanene, pisape “Nepisa pe lelaga pan amiu, yar nap̃a visae ve kom re e mralaea na vaen loyum̃a vanon sipsip lala, ana p̃iyukalawan ga kove, yar ne sanene pe yar viowa na vinauen ga. ");
INSERT INTO lww_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","A naga nap̃a silaga pa kom lologia mralaea, naga pe yar mesmes nena navisuaren sipsip. ");
INSERT INTO lww_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Visae aligan yar tai na kirakirawoen mralaea, ana pogos nap̃a yeririna navisuarena sipsip vim, yoko naga kilia vike ga vania. Ana pogos nap̃a va loyum̃a, sipsip la punu ga aloge pulgona, ana naga vio ga kia kiena ne lala nap̃a ape kiena ga, p̃isi na lala ga nene asum̃alu a naga sumon la ava vanua. ");
INSERT INTO lww_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ana pogos nap̃a visae sumon la apa ava vanua, naga yal sumon la, la asiraunia avano, vanon akilia ruru pulgona. ");
INSERT INTO lww_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tap̃atete akila ve sanene van wolawa tai, yoko amaraun ga, vanon pe amloge kilia re pulgon yar tap̃ena la poli.” ");
INSERT INTO lww_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ninun visena nene Yesu pisawal pan la, ana pe amloge kilia re kinas poli. ");
INSERT INTO lww_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Sanene na, Yesu sunyu m̃a pan la sane e lepas na kove na sipsip nene, pisape “Nepisa pe lelaga pan amiu, sane mralaea na kove na sipsip nene, naga inu. ");
INSERT INTO lww_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Lala tap̃ena la nap̃a apim sumon inu, nap̃a apisokan asape yoko avisuar ruru sipsip lala, ape yar viowa na vinauena ga lala, ana pogos nap̃a apa akaten sipsip lala, sipsip la pe amloge la re poli. ");
INSERT INTO lww_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","In ga nepe mralaea na kove, yar nap̃a imi kom ga pun inu, yoko nevisuar ruru kiena malena. Yoko naga kilia va vanua lual kana kinanena, p̃isi na kilia vim sina momalio kolemalo, kilia vim vano ve sanene naga pogaga. ");
INSERT INTO lww_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yar na vinauena pimi vena war plan vinaunen sipsip lala, pona nawe mom̃ar laena, pona kila kare manene laena, ana in na nepimin vena akilia atol malena, vena akilia akekaran malena nap̃a wo vap̃isi van la.” ");
INSERT INTO lww_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ana Yesu pisa m̃ena ga, sape “In na nepe yar na po na visuar ruruen sipsip lala. Yar na visuar ruruen sipsip naga monar kekara nap̃a tam̃an kiena malena vena tamaliaen kiena sipsip lala. ");
INSERT INTO lww_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Visae ve yar na yum̃aena ga tai, p̃isi na tap̃atete visuar ruru sipsip la ve sanene, naga pe kekaran re la ne sanene vanon pe pe kiena sipsip re poli. Visae pogos tai visu pupia lokul tetan lala atomin sipsip la nene, yoko naga marau ga, sum̃alu kiriri ure, ligan sipsip la asike na, p̃isi na lokul tetan la nene avim akarkare la am̃enetetain la. ");
INSERT INTO lww_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yar nene ure vetan sipsip la ne sanene, vanon naga pe yar tai nayum̃aenen ga kiena kilavaru, naga pe sitom manene re sipsip la nene poli. ");
INSERT INTO lww_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“A in na nepe yar na visuar ruruen kiau sipsip lala. Nekilia ruru la nap̃a ape kiau, a la nene akilia ruru m̃ena inu. ");
INSERT INTO lww_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Imimi na mekilia ruru imimi sa ga nap̃a imimi lua Ata mekilia ruru imimi lua. A in na sineu si kiau sipsip la nene torokin nap̃a netam̃an kiau malena vanon la. ");
INSERT INTO lww_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","“Ana kiau sipsip m̃ena la moki asum̃a ke ga wa, nap̃a pe apim asu re loyum̃a e kiau kove poli wa, ana monar neva nevio la m̃ena ga, ana pogos nap̃a aloge pulgou, yoko aimi. Nekila m̃a sanene vano-o kiau sipsip la punu ga aim ave p̃egas taaga ga narui amio inu, yar keviu na visuar laena. ");
INSERT INTO lww_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Vano-o yoko netam̃an kiau malena vanon la, ana kau Ata naga kekaran pap̃isi, kekaran inu vanonia. Ana nekilia nevisa m̃ena sane kiau malena nap̃a visae netam̃an vano-o, yoko nela maran sina. ");
INSERT INTO lww_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Pe yar tap̃ena re si nap̃a yoko lalua kiau malena vetan inu, ana in ga taaga netam̃ania. Naga pe kiau ga natam̃anen vano, a pe kiau ga nalamaranen sina. Na nap̃a neyum̃ae sanene, Ata ga mligan e inu.” ");
INSERT INTO lww_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ana yam si tai, visena kiena ne Yesu na sanene kila le Yu lala ap̃ure tetai e sitomena lua sina. ");
INSERT INTO lww_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Lala moki asape “Yermare ga na sike e naga, yar nam̃a p̃arina pe wowe viowa ne. !Ve ayagoga re!” ");
INSERT INTO lww_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ana lepas p̃asia asape “Peraga, kiena visena wo la nene pe pe visena kiena ne re yar nap̃a yermare sike e poli. ?Ana sanape, yoko yermare viowa kilia kila ruru si kilamaran yaru nap̃a pe p̃ala, sa nap̃a yaru nene kila rui?” ");
INSERT INTO lww_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ana e pogos nene la apim atol si pog na kala pupia p̃ap̃agena tai, ma Yerusalem. P̃ap̃agena nene apio asape P̃ap̃agena Navisa Ruruen Yum̃a Wa M̃ana ne Ntewa, ana amiyum̃aen ke e pog na miava. ");
INSERT INTO lww_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ana Yesu m̃ena pa sike e p̃ap̃agena nene, ana pogos tai naga pa ma e Yum̃a Wa M̃ana ne Ntewa, mial ke pa e pupia mraliu nap̃a apio sape Mraliu Kiena Solomon. ");
INSERT INTO lww_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ana yerkawa kiena le Yu lala nap̃a asike ne apim puna, ape p̃egas amiyervivia, apiun m̃areran pania, asape “!Konua rui mesape mekilia ruru ko ko na ai, ana ko okilawan ko m̃a sanene pano-o! Visae ko na ope Navisaarena kiamimi na lelaga, imimi sinemimin mesape ovisa meraravan ruru van imimi nanagane!” ");
INSERT INTO lww_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ana Yesu pisatam̃e la, sape “?Ana in na nepisa ruru pan amiu p̃a rui, po pere? Nepisa ruru pan amiu ana amon nap̃a alelaga ea. A pupia yum̃aena kerkeviu la nap̃a nemiyum̃aen e kia kiena ne kiau Ata, sa nap̃a amiu apisu pa rui, lala m̃ena akila meraravan inu pan amiu rui, ");
INSERT INTO lww_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ana naga m̃ena nene amiu pe amlelaga re e poli. Amiu pe amlelaga re nena e inu, pona nanene vanon amiu pe ape p̃egas na kiau sipsip re poli yo. ");
INSERT INTO lww_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kiau sipsip lala amloge kilia pulgou, a in m̃ena nekilia la punu ga, a lala asum̃a ataveve inu. ");
INSERT INTO lww_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","In na nemla ke malena nap̃a ve uro re pan la, ana tap̃atete akovio, pe yar re tai nap̃a kilia war plan la vetan lum̃au. ");
INSERT INTO lww_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nanene vanon kiau Ata ke narui nap̃a p̃ar la pan inu, a naga m̃arera manene laa taulu punu ga, ana tap̃atete yar tai war plan sipsip la nene vetan navisuarena na limana. ");
INSERT INTO lww_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Lelaga, inu nemio ata, imimi lua mepe taaga ga.” ");
INSERT INTO lww_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ana pogos nap̃a Yesu pisa pa visena nene, yerkawa kiena ne le Yu la sinela kar ke sina ga, ap̃ar kilavaru lala asape akovem̃aria. ");
INSERT INTO lww_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu pisuia, ana pis pan la, piunia pisape “?In na nekila p̃arin yum̃aena wo lala e maramiu rui, nap̃a Ata sinenan sape neyum̃aenia, ana amiu asape akove inu vanon nape?” ");
INSERT INTO lww_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ana la apisatam̃ea, asape “Peraga, mesape mokove ko, pe vanon re yum̃aena wo poli, ana vanon ga nap̃a ko na op̃arnena kare ke kia kiena ne Ntewa, nap̃a ko, ko na ope yeririna ga, ana silaga okila ke sa nap̃a ope Ntewa pa rui!” ");
INSERT INTO lww_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","P̃isi na Yesu pisatam̃e la, sape “E kieta Tus Wa, visena kiena ne Ntewa tai teke e Tus Na Yauena, nap̃a pis pa yeririna nae Israel lala, pisayu sanape nap̃a lala ape narina lala, naga pis sanene pan la, pisape ‘Amiu na sa ga ntewa lala.’ ");
INSERT INTO lww_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Sanene na, tevisu e yo nene sane la nap̃a visena kiena ne Ntewa nene pan la, la ape yeririna ga lala, ana visena nene pisape lala ape ntewa lala, ana visena nene naga pe kieta Nasiriena Wa tai, monar ve lelaga ga. ");
INSERT INTO lww_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","“Ntewa pisayu kiena yeririna la sanene rui, ana yoko ve sanape van inu, nap̃a in ga taaga naga miawawo inu, mligan inu nepitom e yomarava nini? Mesmesun ga nap̃a nepisawal nesape naga pe kau Ata Ntewa, ana inu nepe narina, ana amiu asape piowa ga nap̃a nevisa sanene. Apisa ke asape in na nep̃arnena kare kia wa kiena ne Ntewa, ana pe sa re nene poli. ");
INSERT INTO lww_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Visae pe lelaga nap̃a nemiyum̃ae ke pe pe kiena re arimau poli, pona amiu ve alelaga re e inu, naga pogaga. ");
INSERT INTO lww_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ana visae nekila ke kiena yum̃aena lala, pona amiu amlelaga ke e inu po pe amlelaga re poli, a amiu monar alelaga e kiau kile lala, sane ape yum̃aena kiena ne Ntewa lelaga. Visae ve sanene yoko amiu akilia avisu kilia sane Ata teke e inu lelaga, a inu m̃ena neteke e naga.” ");
INSERT INTO lww_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesu pisa sanene pan la, ana kiela sitomena m̃arera maran taaga sum̃a ga. Lala akilali nap̃a atararli si naga sanene na, amilan ga naga pure tan likan la pure pano. ");
INSERT INTO lww_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ana Yesu petan si Yerusalem kusro pito sina e wii nap̃a Yortan lepas na vano, e yo nap̃a Yoane Nakeena kee yeririna lala ea nanua sumo. Ana sum̃a e yo nene yam piavi li m̃aga, ");
INSERT INTO lww_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ana yeririna la apim ke puna silaga. Apim apisayu naga asape “Yoane nanua, naga pe kila re kile la sane yar nene kila ke ne poli, ana naga pisa plan sur moki e lepas na puna, ana tepisu e kilamarata sane sur la punu ga nap̃a pisa ne apim ape lelaga ga narui.” ");
INSERT INTO lww_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ana kiela sitomena na sanene kila sane la moki nae yo nene amlelaga e Yesu. ");
INSERT INTO lww_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ana pogos nap̃a Yesu sike perina wa, maiena m̃arera tai pimi tol kiena erau tai, Lasaros. Lasaros nene vinena la lua nap̃a Maria amio Mareta, la telu nene nae narin pulkumali nap̃a Petani lavisin Yerusalem. ");
INSERT INTO lww_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ana Maria ne naga m̃a nene nap̃a siraunia taron ponotaninu e Yesu, miyumu vania lana e vilp̃arina. ");
INSERT INTO lww_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ana pogos nap̃a vinena la lua nene apisu m̃enela nene mai keviu sanene, amligan visenan pa pan Yesu, asape “Sup̃e, kiom̃a erau nap̃a ko na sinem̃a si naga, mai tai na piowa ga.” ");
INSERT INTO lww_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ana pogos nap̃a visena nene pa tol Yesu, naga pe pito re poli, pisa ga sape “Inanena nene pe na marena re poli. Inanena nene sa ga mrapa kiena ne Ntewa tai, vena kila meraravanen kiena urarena, a vena kila meraravanen kiena pupia puriukawaena nap̃a mla pan inu Narina Ntewa.” Yesu pisa visena nene, sa nap̃a kilia pa rui suri nap̃a yoko yum̃aenia. ");
INSERT INTO lww_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu sinena si Mareta nene pap̃isi amio luena na ve tokak a m̃enela nene, a sinena mie la pap̃isi, ana pe kan pog mesmes re na kilaen suri nene poli wa. ");
INSERT INTO lww_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sa nene, naga pe pa re ga poli, sum̃a si legiena lua e yo nene nap̃a wii nae Yortan lepas na vano. ");
INSERT INTO lww_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sum̃a si sanene, p̃isi na pisa pan imimi nalogena lala, sape “Pogaga, tokusro sina ga teva si yo nae Yutea.” ");
INSERT INTO lww_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ana imimi mesitom̃al ke yerkawa kiena le Yu lala e yo nene nap̃a sinela kar Yesu pap̃isi, ana memaraun vitoen sina. Mepiun tania, mesape “?Navianena, sanape? Nanua ga nap̃a tesike ma ne na le Yu la akilayon asape akovem̃ar ko, ana nanagane na osape teva si pula.” ");
INSERT INTO lww_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ana Yesu pisa pan imimi pisape “Kiau navisatam̃eena van amiu naga sanini. E legiena, kana aora nena lualima yam taaga pa lua, pupia mrae tegoli yo, kila sane yar kilia yal ruruia, tap̃atete lolor. ");
INSERT INTO lww_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ana yar nap̃a yal li e yemalolo na kolemalo, naga yoko lolor ga, vanon yomerarava nene pe tegoli re si kiena mrapa poli.” ");
INSERT INTO lww_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu pisa visena nene pan imimi, kana kinasia sape naga kilia yaloro ga woga ga ne, tap̃atete suri viowa tai vania vano tol pogos nap̃a Ntewa ligan ruruia sape akilia awem̃ar naga. Ana miakolkol sina ga, sape “Kieta erau nene momalio rui. Ana nanagane na tevano na neviop̃ege sina naga.” ");
INSERT INTO lww_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ana imimi nalogena la pe memlogekilale re kinas nen visena nene po, ana mepisalup̃ar si Yesu, mesape “Sup̃e, visae naga momalio, pogaga ne, yoko kilia loge wo sina ga ne.” ");
INSERT INTO lww_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Mepisa sanene vanon mesitom ke mesape Yesu pisa ke sape Lasaros pa ruru ke ga, ana pere, Yesu pisa ke kana marena ne. ");
INSERT INTO lww_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ana nagane na Yesu pisa meraravan pan imimi narui, sape “Lasaros mare pa rui, ");
INSERT INTO lww_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","komin pogos nap̃a naga mai, pe nesu re nemio la poli. Ana sanene na nepisu pogaga, a po m̃ena ga pan amiu, vanon sane kiena marena nene yoko imi ve sa pulmas tai van amiu, vena amiu akilia alelaga lelaga e inu. Pogaga, tevanon, tevisuia.” ");
INSERT INTO lww_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ana imimi nalogena la memaraun ke navaena wa, ana Tom̃as nap̃a apio sape Tom̃as Kaora, pisa pan imimi sape “Amiu asum̃alu, ita punu ga tevano. Kieta Sup̃e sinenan sape va mare sanene, popon ita punu ga tevano, temare temio naga veraga.” ");
INSERT INTO lww_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ana imimi punu ga memial veraga mepano, mepa makate lavisin narin pulkumali nap̃a Petani. Ana apisawal pa Yesu asape Lasaros, amligan tasnena mono e pulu kilavaru legiena vari p̃aro rui. ");
INSERT INTO lww_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ana kumali nap̃a Petani sike lavisin ga pupia kumali nap̃a Yerusalem, torokin sane kilometa ve telu ga, ");
INSERT INTO lww_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","kila sane le Yu moki nae Yerusalem, pogos nap̃a amloge marena nene, sinela miye Mareta amio Maria, ana apim vena atag amio la atagin naga nap̃a kovio. ");
INSERT INTO lww_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ana Mareta sike amio la nene, ana amligan visenania, asape Yesu pam sike pa garo ne e mrapa rui, ana naga sum̃al pato talopania. Ana luena nap̃a ve tokak, Maria, naga sum̃a ga loyum̃a, ana pe pa re vanua poli. ");
INSERT INTO lww_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ana Mareta pitomi pisu Yesu, pisa pania, sape “!Sup̃e, visae ko na ovim ga e nini, m̃enemimi nene tap̃atete kovio! ");
INSERT INTO lww_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ana in na nemlelaga pe sur korena ga nap̃a mare, ana sur nap̃a ko oviun vetan Ntewa, yoko naga tam̃an ga van ko.” ");
INSERT INTO lww_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ana Yesu pisa pania, sape “Mareta, yoko m̃enem̃a nene sum̃al mal sina.” ");
INSERT INTO lww_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ana Mareta pisatam̃ea, sape “Lelaga, nekilia ke ne, nekilia nesape naga yoko mal sina ga e pupia nasum̃alena e legiena maro.” ");
INSERT INTO lww_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","A Yesu pisa visena nene pania, sape “In na nepe mrapa na sum̃alen sina, in na nepe purp̃es nen malena. Yar nap̃a lelaga e inu, pe suri korena ga nap̃a monar mare e yomarava nini, ana yoko mal sina ga. ");
INSERT INTO lww_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yar nap̃a tol malena nene, ana nalelagaena e inu teke e naga, naga tap̃atete visu si marena pogos tai. ?Mareta, ko na omlelaga sanene?” ");
INSERT INTO lww_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Naga pisatam̃ea, sape “O, Sup̃e nemlelaga. Nemlelaga e ko, sane ko na Navisaarena, narina ne Ntewa, ko ko na nap̃a siar nanua sumo sumo apisa ke sape yoko imi tamalia yeririna lala na yomerava nini.” ");
INSERT INTO lww_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ana pogos nap̃a Mareta pisa pa sanene pan Yesu, pa sina ga loyum̃a, pavinin vinena nap̃a Maria, pis malum ga pania, sape “Navianena nap̃a! Pam pa rui, sike garo e mrapa wa, pisape visu ko kone wa.” ");
INSERT INTO lww_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria mloge, sum̃alu veraga, sape vito visu Yesu, ");
INSERT INTO lww_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","nane e ga e mrapa nap̃a Mareta pisu ga naga e nanagane, vanon naga pe pimi re loyum̃a e kumali poli wa. ");
INSERT INTO lww_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ana le Yu la nap̃a asike loyum̃a amio la, apisu nap̃a sum̃al pa vanua pito yuroro sanene na, asitom asape naga sinenan sape va tag sina e pulkilavaru, ana la m̃ena asum̃alu, ataveve naga apano. ");
INSERT INTO lww_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ana Maria mial m̃a pito sanena, pimi tol e nap̃a Yesu sike ea. Naga kira pisuia, pimi lavis puna, kuan mlor pito tano e mialana, tag pania, pisape “!Sup̃e, visae ko na oimi ga e nini, m̃enemimi nene tap̃atete kovio ne!” ");
INSERT INTO lww_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ana naga tag m̃a sanene, le Yu tap̃ena la nap̃a atavevea, lala m̃ena atagi. Ana pogos nap̃a Yesu pisu pupia naloge viowaena kiena Maria la sanene, naga m̃ena mloge piowa, mnunu sur nene sane urmi manene e losinena, ");
INSERT INTO lww_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","naga piun petan la, sape “?Amiu amligan mono ke pe?” La asape “Sup̃e, oimi teva tevisuia.” ");
INSERT INTO lww_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu mloge sanene, ana tagena pimi e naga, wamarana la mlalau. ");
INSERT INTO lww_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Pogos nap̃a apisu naga tag sanene, la p̃as asape “!Lelaga nap̃a ne, naga sinen si kiena erau nene pap̃isi nap̃a ne, kila sinena piowa na sinena piowa!” ");
INSERT INTO lww_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ana lala p̃asia, naviunena teke e kiela sitomena, asape “Yar nap̃a nanua kila kilamara p̃ala tai, kilamarana pimi po sina ga. ?Visae sinenania na, naga kilia kila nap̃a kiena erau nene ve kovio re ga, a?” ");
INSERT INTO lww_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ana Yesu mial amio pupia sineyeena, amio Maria lala apa akate e pulkilavaru nap̃a amligan tasnena ne Lasaros mono ke ea. Pulkilavaru nene naga pe puluve, nap̃a amligan pupia kilavaru tai mono ke pulusia. ");
INSERT INTO lww_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ana Yesu pisape akuslua pupia kilavaru nene. Ana vinena tap̃ena nene Mareta mloge nap̃a Yesu sape akuslua kilavaru, p̃isi na sape visalup̃aria, pisa pania, sape “Sup̃e, piowa nap̃a tekila sanene, vanon naga mare legiena vari p̃aro pa rui, yoko ponos kona va p̃isi ne.” ");
INSERT INTO lww_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ana Yesu pisatam̃e pania, sape “?E, ko na pe ositom̃al re si kiau visena nap̃a nepisa pan ko rui? In na nesape sa ko na olelaga ga, ovisu nam̃areraena na urarena kiena ne Ntewa naga yum̃ae.” ");
INSERT INTO lww_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","P̃isi na la akila ga, akuslua pupia kilavaru, ana Yesu kira pa metava, mlen, sape “Ata, nepisa sip̃a pan ko keviu nap̃a ko na okekaran nalogeen kiau naviunena nini. ");
INSERT INTO lww_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nekilia sane sur ya nap̃a visae in ga taaga nesape neviun tan ko, yoko ko ologe ga. Ana suri nap̃a neviun tan ko nagane na, nepiunia e maran la ne asum̃al asike nini, vena la m̃ena akilia aloge. Ana visae avisu sane ko ovisatam̃e van inu sa nap̃a nepiunia, kilia iilala alelaga sane pe lelaga ko na omligan inu nepitom e yomarava nini.” ");
INSERT INTO lww_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ana pogos nap̃a Yesu mlen pae sane na, naga kii m̃arera sanene pano, pisape “Lasaros, omolue ovim.” ");
INSERT INTO lww_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ana amilan nap̃a yar mare sum̃alu pimi vanua, p̃arar kulmrae la nap̃a amluluar naga ea, tamalele ke e limana la amio lana a p̃arina asike wa. Ana Yesu pisa pan la sape “Pogaga, awar plan kulmrae la nene vetania, vena naga kilia yal ruru sina ga.” P̃isi na akila, ana Lasaros mal ruru ga sike si amio la. ");
INSERT INTO lww_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ana le Yu la moki nap̃a ataveve Maria apim e pulkilavaru nene, pogos nap̃a apisu Yesu kila Lasaros mal si e marena sanene na, amlelaga nena e naga. ");
INSERT INTO lww_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ana lala p̃asia amon lelagaena, ap̃asup̃e la sina ga, apa si pu Varasi lala, apisawal pan la sur nap̃a Yesu miyum̃aenia. ");
INSERT INTO lww_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","A pogos nap̃a amloge pe akekaran re nena ga, ana lala amio yerkawa na yar wa lala, apio m̃ena lala tap̃ena na pupia kumali kiena le Yu lala apim lele taaga asunyuia. Ana pogos nap̃a apim pae lele taaga, apisawal pan la asape “?Yoko tekila kan yar nene narui? Naga kila ke pupia kile la pap̃isi e maran kieta yeririna lala. ");
INSERT INTO lww_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Visae ve tevisawo re naga, yoko kila m̃a sanene vano-o ve tai re nap̃a ve lelaga re e naga, yoko ure la punu ga ataveve ne. Ana visae la na mara nae Rom avisu yar nene kila ke sape imi ve pupia nasumonena tai sanene, yoko sinela kar ita le Yu la punu ga. Yoko akilia aimi akila mara amio ita vano-o akila kare kieta p̃egas punu ga amio awe plan kieta Yum̃a Wa M̃ana Ntewa.” ");
INSERT INTO lww_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Apisa ke sanene na, kiela pupia nasumonena Kaep̃as, nap̃a e kas nene na naga p̃uarar kia nap̃a P̃arin Yaru Wa, pisa pan la, sape “?E, vanon ya ne kiamiu sitomena la plas ga sanene, nap̃a amiu amninue ga sane yoko tekila ya ne van yar nene? ");
INSERT INTO lww_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sur ya na po pan amiu? Pogaga nap̃a yar taaga ga nene kila ita make ga tokovio, pona popon naga taaga mare vena tamalia kieta p̃egasia ita punu ga?” ");
INSERT INTO lww_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pogos nap̃a pisa visena nene, naga m̃ape pisawal ke sitomena tai nap̃a kiena ga. Ntewa kila naga p̃uarar yum̃aena na p̃arin yaru wa e pogos nene, ana Ntewa ke narui mligan m̃ena visena nene e kiena sitomena, vena visawalen visena lelaga tai, sape Yesu monar mare vena tamaliaen yeririna punu ga. ");
INSERT INTO lww_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Naga pe kilia re poli, a pisa ke sape siraunia, pogos nap̃a Yesu mare, naga pe maren re ga p̃egas kiena ne le Yu ga la nene poli, ana kiena marena panon m̃ena narina ne Ntewa tap̃ena lala nap̃a asike m̃ena e purvanua tap̃ena lala, ve naurepran laena punu ga aim ave na mratava taaga ga. ");
INSERT INTO lww_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ana e pogos nene, Kaep̃as pisawal visena nene, pure sitomen kiena ne yerkawa la punu ga kiena ne le Yu la asape Yesu monar mare ga. Ana siar e pogos nene, apisayu ke silaga, asape akilia akila ve sanape. ");
INSERT INTO lww_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ana kiela sitomena nene kila Yesu mialorotete sina likan yeririna lala e yo nae Yutea, naga p̃ere plan imimi, mepa mesike e narin kumali tai, kiena kia Ipraim, nap̃a sike perina, lavisin yokorena. ");
INSERT INTO lww_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ana lavisin pog na p̃ap̃agena kiena le Yu la nene, P̃ap̃agena Nasitom̃alen Natamaliaena. Ana le Yu la nap̃a asike e yo la ne, amligan ke kiela yo lala, apa ke ma Yerusalem, asape ava e Yum̃a Wa M̃ana ne Ntewa, akila kup̃ap̃aena naikikena e marana ne Ntewa, sumon nap̃a p̃ap̃agena siaria. ");
INSERT INTO lww_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ana pogos nap̃a yeririna la apa ke metava e Yum̃a Wa, asike akale ke Yesu. Akale pano am̃a re naga poli, ana la apiuyun ke petan la, asape “?E, amiu asitom sanape? ?Yoko naga vim kate e p̃ap̃agena nini, po ve vim re?” ");
INSERT INTO lww_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ana p̃arin yar wa la amio Varasi lala, lala m̃ena asitom ke asape pona Yesu kate li e aora nene yo. Ana la apisaar m̃arera asape visae avisu Yesu sike lele tai, monar aligan visena va van la vena aim na atararia. ");
INSERT INTO lww_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ana pogos nap̃a P̃ap̃agena Nasitom̃alen Natamaliaena nene pere ke ga wa, legiena orai sike ga wa, ana imimi memio Yesu mepa tol si narin pulkumali nap̃ani Petani. Ana mepa makate si e um̃a m̃ana ne naga nap̃a Yesu kilamalia sina ga pe piavi re poli, nap̃a Lasaros. ");
INSERT INTO lww_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mesum̃a memio la pano-o, la nene asape akila kinanen tai akan amio Yesu. Ana pogos nap̃a akila ruru punu pa sur lala, imimi memio Yesu mepim metotano, a Lasaros m̃ena totano amio imimi, ana vinena nap̃a Mareta naga p̃ar ke kamimi kinanena pimi. ");
INSERT INTO lww_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ana vinena ne Lasaros tap̃ena nap̃a Maria, naga m̃ena sum̃a ga, naga kus pupia pias na ponotaninu pimi, ponotaninu nene apio asape nat, naga ponotaninu tai nap̃a kana maran kilavaru pa metava pap̃isi. Ana kus pimi lavis pu Yesu, taronia miyumuvan la Yesu ea. P̃isi na Maria tar pupia viluna piavi nene, miyumuvan sina ga la Yesu, ana pe piavi re poli, ponotaninu nap̃a ne ponos miyere make loyum̃a e nap̃a asike e ne. ");
INSERT INTO lww_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ana e pogos nene, nalogena kiena ne Yesu nap̃a yoko siraunia wilwilin wania, Sutas nae Kariot, naga m̃ena pisu ke sur nene. ");
INSERT INTO lww_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Naga pisape “?Vanon ya ne ve awilwilin re ga pupia ponotaninu nene? Visae sanene, akilia ataulu pupia varu tai, sane kilavaru nap̃a yaru tai tauluia e kiena yum̃aena na kas wetelu tai, ana akilia atam̃an vena iilaen la nap̃a pe kiela sur la poli. !Akila kare ga ne!” ");
INSERT INTO lww_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Naga pisa sanene, ana naga pe sitom̃al re yar la nap̃a pe kiela sur re la poli. Naga pisa vanon naga pisuar ke kiamimi karo na varu, a pinaun la ke, kan ke kiamimi varu lala, a naga sitom manene laa varu na ponotaninu nene. ");
INSERT INTO lww_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ana Yesu pisatam̃e e sur nap̃a Sutas pisa, sape “Ei, piowa nap̃a ko ovisa kare vineta sanene. Naga kila sanene pan inu vanon naga sitom ke sape legiena nap̃a yoko asinwo inu pimi make lavis narui. ");
INSERT INTO lww_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yoko yar la nap̃a ve kiela sur re la asulue ga amio amiu, vena amiu aiila la sanene, ana in na pe pe nasulueen re nemio amiu poli. Sanene, sur nene nap̃a naga kila pan inu naga po pap̃isi.” ");
INSERT INTO lww_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ana pe piavi re nena ga, visena pato tol lala nap̃a ap̃arpiran la ke e p̃ap̃agena garo Yerusalem, sape nagane na Yesu pam sike Petani rui. P̃isi na lala apava ke asape avisuia, a pe naga re ga poli, asape avisu m̃ena Lasaros, nap̃a Yesu kila naga mal si rui. ");
INSERT INTO lww_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Yeririna la apa apisu ke Lasaros sanene, a sur nap̃a Yesu miyum̃aen pania kila nap̃a lala moki, pano tol li na sumonena lap̃as kiena le Yu lala, ap̃ure petan kiela nasumonena tap̃ena lala, apim amlelaga e Yesu narui. Ana yer keviu kiena yar wa lala nap̃a asike ne apisayu sur nene, apiranaria asape akale mrapa nap̃a awe mom̃ar Lasaros mare. ");
INSERT INTO lww_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Lasaros lala akila pae kinanena kana ne Yesu p̃isi, ana e legiena tap̃ena sina, visena pato tol pupia p̃ina la nap̃a apam asike Yerusalem e p̃ap̃agena, asape Yesu naga pimi ke rui, vena vim loyum̃a e pupia kumali nene. ");
INSERT INTO lww_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ana yeririna la amloge, asum̃al amial apa ate lum̃am̃ela lala, amiyal apano vena avitawe naga mrapa. Asape akila sanene vania vena naga vim ve sane kiela p̃arin sup̃e, ana la amial apa sanene, apioyon ke sanini apisape, “!Pona we-e po! Teieluar naga, kieta p̃arin sup̃e viu nae Israel! !Ntewa na mava ovisa ruru naga nap̃a pimi e kiom̃a kia!” ");
INSERT INTO lww_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ana Yesu mial pimi ke, naga kila nap̃a ap̃ure narin togki tai pimi puna, pa totano ea mial pimi. Sur nene nap̃a naga kila taveve ruru ga visena tai na Visena Wa nap̃a pisape. ");
INSERT INTO lww_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Amiu le Yerusalem lala, amiu ve amarau re sina, Amiu avisuia, nanagane na kiamiu p̃arin sup̃e naga pimi ke pun amiu narui. Naga kus ke ga narin ninus nen togki tai, pa totano ea pimi ke.” ");
INSERT INTO lww_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ana e pogos nene, imimi nalogena kiena ne Yesu lala pe mesitom̃al re visena nene poli, a siraunia, pogos nap̃a pa pae ma e peni, imimi mepisu kilale ga na wa sane visena marua na nanua ne naga pisayu naga mesmes, ana mepisu sane naga kila sur punu ga mesmesu ga sa nap̃a Visena Wa lala apisa nanua sumo asape yoko Navisaarena yum̃aenia. ");
INSERT INTO lww_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ana p̃isi na pupia p̃ina nene kila ke naworworena pa Yesu sanene na. Lala moki la nap̃a nakoneva asike amio naga pogos nap̃a pio Lasaros m̃al si petan marena, ana la apa apisawal pupia kile nene pan yeririna tap̃ena lala, ");
INSERT INTO lww_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ana pogos nap̃a lala amloge sur la nap̃a Yesu miyum̃aenia, sinelan asape avisuia, ana la apim vena ava avisuia. ");
INSERT INTO lww_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ana lala punu ga nene, pupia p̃ina pa tai narui, ana pogos nap̃a le Varasi la apisuia, amloge piowa, asilin p̃arila, apisape “Top̃aryon yar nene pano-o piowa ga. Naga taulu ita punu ga, pure yomarava wetelu nene apa ataveve naga rui.” ");
INSERT INTO lww_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ana e yeririna moki la nap̃a ke metava ma Yerusalem vena alotun Ntewa e p̃ap̃agena nene, lala p̃asia pe ape le Yu re poli, lala le Krik la nap̃a apim amlelaga e Ntewa sane le Yu lala. ");
INSERT INTO lww_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ana pogos nap̃a amloge manene laa kia kiena ne Yesu, asape avisu naga. Apa akale, akirawal kiena nalogena nap̃a Pilip nae Petsaeta ma Kalele, ana apiun Yesu tania. ");
INSERT INTO lww_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ana Pilip pa pisawal pa Antru, p̃isi na lalua apa apisawal pa Yesu. ");
INSERT INTO lww_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ana pogos nap̃a Yesu mloge sape la nap̃a pe ape le Yu re la poli asape avisuia, naga pisawal sape “Nanagane na pe pogos mesmesu vena Ntewa kila kiau kia, inu Narina ne Yeririna, va metava. ");
INSERT INTO lww_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nepisa pe lelaga pan amiu, sane visae kurus tai, visae ve amapla re, yoko naga taaga to korena ga tom̃a sanene. Ana visae amapla, yoko menun nena ga, ana siraunia kilia war si mras ve moki. ");
INSERT INTO lww_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“Sanene, naga nap̃a kekaran manene laa malena kiena e yomarava nini, taulu nap̃a kekaran inu, yoko kilaluia, a naga nap̃a pe sitom manene re naga poli, yoko naga sum̃a ga woga ga vano-o tol malena viu nap̃a pe luas re poli. ");
INSERT INTO lww_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","“Yere Yu pona yere Krik nap̃a sape sinenan kiau yum̃aena, sinenan sape ilanu, naga monar taveve in lue ga. Ana pogos nap̃a naga taveve inu ke sanene, yoko e lele ya nap̃a sa neva nesike ea, a naga m̃ena kilia amio inu. Yar nap̃a pe yar na kiau yum̃aena, yoko Ntewa la kia wo vania.” ");
INSERT INTO lww_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ana Yesu siar sitomveve ke nap̃a yoko ve ve piavi re na, monar mare, ana mloge urmi pap̃isi e naga. P̃isi na sape “Nanagane na, nemloge sane sitomena la moki e losineu. ?Yoko nevisa ya ne va kau Ata? ?Popon nelen, neviun vetania, nesape: Ata, awis otarlua inu e aora m̃arera na loge viowaena nene? Pona piowa ga nap̃a nevisa sanene, vanon in na nepim e yomarava nini vanon nenaga yum̃aena ne nanene. ");
INSERT INTO lww_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Peraga, popon nevisa ve sa ga nene, nevisave: Ata, awis okila kiom̃a kia vim ve keviu kome sur la nap̃a sa akila van inu.” Ana pogos nap̃a Yesu pisa pa visena nene, pulgo tai metava ma e peni pis pitomi tano, pisape “Inu na nekila ke kiau kia pa metava kom ga e ko rui, a yoko nekila ke sina ga na wa.” ");
INSERT INTO lww_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ana p̃ina la nap̃a asu ke lavis ga amloge m̃aagena na pulgo nene, ana p̃asia asape polilu ga tai, la p̃as asape “Peraga, navisi ga ta ne pisi ke pania.” ");
INSERT INTO lww_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ana Yesu pisa pan la sape “Pulgona nap̃a temloge ne, naga pe pitomi re sape in na neloge poli, a pitomin amiu, vena amiu akilia sane inu nepimi pe. ");
INSERT INTO lww_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Monar ve sanene vanon nagane na, pe pog na lip̃ereen yeririna na yomarava narui, pe pog na kovenluaen p̃arin sup̃e na yomarava narui nap̃a Yermare. ");
INSERT INTO lww_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Vena nekila yum̃aena nene, monar netamalele metava e laki torovia, ana pogos nap̃a nem̃eke metava sanene, nekilia noure yeririna punu ga aim pun inu.” ");
INSERT INTO lww_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ana visena kiena ne Yesu, naga pisa pe nakilaen imi merarava van la sane kiena marena pe marena tai nap̃a ve sanape. ");
INSERT INTO lww_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ana pogos nap̃a p̃ina la amloge, asape “Memloge ke nap̃a apuloyu ke Visena Wa, pisa ke sape Navisaarena naga mal lue ga, tap̃atete mare pogos tai. ?Ana sanape nap̃a ko na opisa ke osape yoko atelan Narin Yeririna metava vena mare? ?Pona ko na opisa ke ga tap̃ena tai yo? Narin Yeririna ya nap̃a opisa ke ne, nap̃a yoko ve sanene vania?” ");
INSERT INTO lww_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ana Yesu pisatam̃e pan la, pisape “Inu na nepe yomerarava kiena ne Ntewa, a nekilia nesum̃a si nemio amiu yam ve plas ga. Ana pogos nap̃a nesike nemio amiu, popon ayal e kiau yomerarava nena, visae peraga, yoko pupumalko kalo make amiu, a yar nap̃a sape yali, tap̃atete visulup̃ar si kiena mrapa. ");
INSERT INTO lww_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pogos nap̃a inu nap̃a nepe yomerarava nene nesike ke nemio amiu wa, popon alelaga e inu, vena amiu m̃ena akilia aim ave yeririna na yomerarava lala.” Ana pogos nap̃a Yesu pisa pa visena la nene, naga mligan la asike, petan la pa tapolou e lele tai nap̃a tap̃atete aimin sina naga. ");
INSERT INTO lww_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu miyum̃aen pupia kile la moki e marala rui, ana pe suri korena, lala pe sinelan re asape alelaga e naga poli. ");
INSERT INTO lww_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ana kiela p̃elaga na sanene, akila ke sina ga sa ga nap̃a le Yu marua la nasumo akila e pogos kiena ne yermarua Aisea, nap̃a pisayu e visena la lua nap̃a pisawalia. Nasumo pisa sanene, pisape “Ntewa na mava, imimi mepisasawal ke pan la, ana lala pe akekaran re asape alelaga poli, a ko ko na okila meraravan kiom̃a puriukawaena na lumom̃a van la, ana lala a ne pisulup̃aria? Pe ta re poli.” ");
INSERT INTO lww_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ana na luania, naga m̃ena pisa sanapen lala amon lelagaena e Yesu, pisa sanini, pisape ");
INSERT INTO lww_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ntewa p̃aryon la pano-o peraga, p̃isi na kila ga kilamarala la pimi pe kilamara p̃ala, kila losinela la pimi m̃arera laa pap̃isi. P̃isi na kilamarala la tap̃atete si avisu ruru suria, po losinela la aninulup̃ar suria. Visae pere, yoko la avilon la ap̃asup̃e la aim pa panu rui, vena nekila ruru kiela malena la.” ");
INSERT INTO lww_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ana visena kiena Aisea nene pimi e naga, siraun nap̃a naga pisu naurarena kiena Navisaarena loyum̃a e Yum̃a Wa M̃ana ne Ntewa, a nanagane na tepisu sane pisayu ga Yesu lelaga, amio lala nap̃a e kiena pogosia. ");
INSERT INTO lww_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ana sa nap̃a visena la nene pisa, lala moki pe amlelaga re e Yesu poli, ana p̃asia amlelaga, pa tol m̃ena kiela nasumonena lap̃asia. Na nene naga po, ana sur taaga naga piowa, akilawan ke ga kiela nalelagaena, vanon amaraun Varasi lala, amaraun asape sa akoven plan la laea vetan kiela yum̃a na lotena. ");
INSERT INTO lww_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kiela marauena nene, naga sane lala pe asitom re si nakilaena vena yoko Ntewa kekaran la vanonia, ana lala asitom ke ga keviu sane yar tap̃ena ga la avisu la ve sanape. ");
INSERT INTO lww_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ana Yesu pisawal pupia visena maro tai e maran kiena yeririna lala, pisape “Naga nap̃a mlelaga e inu, pe mlelaga re ga e inu poli, ana mlelaga e imimi lua naga nap̃a mligan inu nepimi, ");
INSERT INTO lww_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","a naga nap̃a pisu nu ke, sa ga nap̃a pisu ke m̃ena naga. ");
INSERT INTO lww_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","In na nepim e yomarava nini, sane kana yomerarava, na kilaen yar ai nap̃a lelaga e inu, yoko ve su re si e yemalolo. ");
INSERT INTO lww_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","48","Ana visae la p̃asia aloge kiau visena, ana pe amlogear re poli, pona visae lap̃asia akovenwanu amon logeen kiau navianena lala, la nene yoko akus kiela nalip̃ereena e legiena maro. E pogos nene, ve in re nap̃a nesum̃alu nelip̃ere la, vanon in na pe nepimin re nalip̃ereen re yeririna na yomarava nini poli, nepimin natamaliaena. Ana sur nap̃a lip̃erela, nane kiau visena la nap̃a nepisa ke pan la pogos nap̃a nesike nemio la nagane narui. ");
INSERT INTO lww_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kiau visena kilia kila sanini, vanon pogos nap̃a nepisa plan ke visena la nene, in na pe nepis re ga e kiau kia in ga taaga poli, ana nepis ke e kia kiena ne Ata nap̃a mligan inu nepitom tano. Naga ga pisa plan ruru pan inu sur la punu ga nap̃a pe kiau na visaplanena, ");
INSERT INTO lww_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ana sanene, silaga in na nepisa ke sur punu ga nap̃a Ata sinenan pisape nevisa. A kiena navisaluaena punu ga nene, nekilia sane malena wo nap̃a pe luas re e poli, sike ga e lala.” ");
INSERT INTO lww_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nanagane na, sur la punu ga akila ruru pa rui, nap̃a peni ga na pupia legiena nap̃a P̃ap̃agena na Sitom̃alen na Tamaliaena siaria. Ana Yesu pisu kilale ke pa rui sane kiena pog pimi ke narui, legiena ga na peni pe pog nap̃a monar ligan si yomarava nini wasup̃e sina va puna ne arimana. Pimi tol pogos nene, e mrapa la moki, naga kila po pap̃isi pan la nap̃a puna nap̃a asike pa e yomarava nini, sitom la pap̃isi, a nanagane pe pog na sitom laen va ve keviu laa sane, vano-o tol nap̃a kiena malena kovio vanon la. ");
INSERT INTO lww_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ana naga sike amio imimi kiena nalogena lala e yo ma metava, kila ke kana kinanena maro amio imimi. A Sutas nap̃a nae Kariot ne, narina ne yermarua Saemon, naga m̃ena sike ke amio imimi e pogos nene, naga sike amio kiena sitomena viowa na wilwilinwanen Yesu, komin nap̃a Yermare mligan teke e kiena sitomena rui. ");
INSERT INTO lww_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ana mekinana m̃a pano-o p̃isi na Yesu naga sitomveve ke sanape nap̃a nanua sumo, petan ma puna Ntewa pitomi tano, a sanape na Ntewa mligan sur punu ga sike e limana, a sanape nap̃a monar tauluia, siraunia naga kilia vetan si yomarava nini va sina puna. ");
INSERT INTO lww_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Naga mloge pupia sineyeena e losinena vanon imimi kiena nalogena lala, sinenan sape kila kile tai e sineyeena nene van imimi, vena imimi m̃ena ga mekilia mekila van imimi. Ana sum̃alu, pa miyenlua m̃ana kulkota, pitavin tawol tai, ");
INSERT INTO lww_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","pio wii m̃ene pialo tai, kus pimi, siar kevan lamimi lala, kila naga sane pe yar na yum̃ae kiamimiena tai. Kevan m̃a lamimi la sanene pano-o, miyumuvan la e tawol nap̃a pitavin ke ne, ");
INSERT INTO lww_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","pano-o pimi tol lana ne Saemon Pita. Ana Pita pisu m̃a nap̃a naga pimi tolia, pisa pania, sape “?Sup̃e, yar nene? Ko na ope yerkawa pap̃isi wa, pe mesmes re nap̃a ko na okevan lau sanene poli.” ");
INSERT INTO lww_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ana Yesu pisatam̃ea, sape “Pita, sur na nekila ke ne, nanagane na pe opisu kilale re poli wa. Ana siraunia, ko na okilia ovisu kilale ruru ga na wa.” ");
INSERT INTO lww_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ana Pita sinenan sape kilawo Yesu wa, sape “Peraga Sup̃e, tap̃atete ga netam̃an okevan lau.” Ana Yesu pisape “Visae ve nekevan ruru ko re, pe kiau sur re tai teke e ko poli.” ");
INSERT INTO lww_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ana pogos nap̃a Pita mloge nene, kiena sitomena pe tap̃ena narui, pisa pa Yesu sape “!Sup̃e, visae ve sanene, netam̃an ga, sineun nesape okee inu, ane ve lau re ga, okee inu punu ga va tol m̃ena lum̃au lala amio p̃aruu!” ");
INSERT INTO lww_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ana Yesu pisatam̃e pa Pita e narin p̃akaiwa tai nap̃a pisayu p̃elaga nap̃a yaru mekiki e kiena mlamulena viowa lala. Naga sape “Yar nap̃a kulu mare ga na wa, yepena punu ga merarava rui. Ana visae lana ve namname sina, ana tap̃atete naga va kulu punu sina ga, yoko naga kevan ga lana. Ana nepisu sane amiu sanene narui. Amiu punu ga amerarava ruru pa rui, a amiu yar ga tai naga pe sa re nene poli, naga pe namname ga mom̃a ga.” ");
INSERT INTO lww_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ana Yesu pisa sanene, sape pe imimi punu re memerarava poli, vanon naga kilia pa rui imimi yar tai nap̃a yoko ve yam ve piavi re na naga wilwilinwan naga. ");
INSERT INTO lww_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ana Yesu kevan lana Pita amio imimi tap̃ena lala pano-o p̃isi, pa miyen sina ga m̃ana kulkota, totano piun tan imimi, pisape “?Amiu apisulup̃ar ke yum̃aena nap̃a nekila pan amiu ne, po peraga? ");
INSERT INTO lww_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Sur nene naga sanini. Pogos nap̃a amiu apio inu ke asape nepe Navianena pona nepe Sup̃e, amiu na apisa pe lelaga ga. ");
INSERT INTO lww_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ana visae apisu nap̃a inu kiamiu Navianena po kiamiu Sup̃e nekevan lamiu, popon amiu m̃ena akekevan ke lamiu lala, amiu akilakila p̃elaga wo la sanene van amiu silaga. ");
INSERT INTO lww_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","In na nekila sanene pan amiu, vena amiu na yoko ataveve maran taaga e legiena la nap̃a pimi ke ne, nap̃a amiu ga akila si van amiu sane in na nekila pa pan amiu rui. ");
INSERT INTO lww_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nepisa pe lelaga pan amiu, sane yar na yum̃aena naga tap̃atete to metavan kiena yerkawa, po yar na waren visena naga ve to re metavan naga nap̃a mligan naga pano. ");
INSERT INTO lww_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ana visae amiu avisu sane kiau visena la nene pe lelaga, a visae amiu akila ke sur la nap̃a nepisa, yoko pupia navisa ruruena vim van amiu sirau.” ");
INSERT INTO lww_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ana Yesu pisape “Nepisa sanene, a pe nepisa amiu punu re poli, komin ita yar ga tai naga sike ne, nap̃a naga kiena sitomena pa pe tap̃ena pa rui. Lelaga, in na nekilia ruru amiu punu ga nap̃a nekilologia amiu, ana nekilia nesape amiu yar tai yoko kila mesmes ga sa nap̃a Visena Wa pisawal nanua rui, nap̃a pisa sanini, sape ‘Naga nap̃a imimi lua makan pae kau kilaparavi, nanagane na naga tarlua pa lana rui vena vielua inu!’ ");
INSERT INTO lww_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Sur nene naga piowa ga, ana nesape nevisawal van amiu sumo wa, ana pogos nap̃a avisu sina ga ve yam piavi re na, akilia alelaga asape inu na lelaga, in na naga nap̃a mon lue. ");
INSERT INTO lww_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nepisa pe lelaga pan amiu, yar nap̃a porworun yar na waren kiau visena nap̃a nemligan naga pim̃asu, naga sa nap̃a porworun inu ke ne, a naga nap̃a porworun in sanene, naga sa nap̃a porworun ke naga nap̃a mligan inu nepimi.” ");
INSERT INTO lww_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu naga pisa pae visena nene pan imimi, ana siar mloge nap̃a sinena pulen naurmiena lala, pano-o pisawal meraravan ga e maramimi, pisape “Lelaga nepisa pan amiu, yoko amiu yar tai wilwilinwan inu.” ");
INSERT INTO lww_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ana pogos nap̃a naga pisa sanene, imimi memilania, mesum̃a metamaren imimi ke sina ga, memninue ga mesape naga pisa ke imimi a ne. ");
INSERT INTO lww_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ana e pog nene, inu Yoane, sane nalogena nap̃a Yesu sinena sii inu pap̃isi, inu netotano ke ga lavisin naga, ");
INSERT INTO lww_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","p̃isi na Saemon Pita kila limana pan inu, sape “Wolai, ko na oviunli ga tania, ovisave naga pisa ke ai.” ");
INSERT INTO lww_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Siraunia nepa la lavisi tekaki ga, nekian p̃aruu pa laa lavis puna ne Yesu, nepiunlili tania, nesape “?Sup̃e, ko opisa ke imimi ai?” ");
INSERT INTO lww_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ana Yesu pisatam̃ea, sape “Nepisa ke ga naga nap̃a narin kinakina kilaparavi nene, nowuton vito e m̃ata pursi, ana nekian vania.” Ana naga kila sa ga nap̃a naga pisa, mla kilaparavi tai, kian pito e m̃amimi pursi, ana mlalua mla pan Sutas, narina ne yermarua Saemon nae Kariot. ");
INSERT INTO lww_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","P̃isi na Sutas mla kania, ana veraga ga, Yermare pimi pa loyum̃a e naga. P̃isi na Yesu pisa pania, sape “Pogaga, sur nap̃a pe kiom̃a nakilaena, oto vilaga okilalia wa.” ");
INSERT INTO lww_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ana e imimi tap̃ena la nap̃a metotano ke e kinanena nene memio Yesu e pog nene, pe imimi yar ta kilia re poli, sane vanon ya ne Yesu pisa visena nene pan Sutas. ");
INSERT INTO lww_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Imimi p̃asia asitom amape vanon Sutas naga pisuar ke kiamimi karo, ana Yesu miila vena va ul kamimi kinanena yo, pona va la kilavaru tai van la nap̃a pe kiela sur re poli, pona sur tai ne sanene. ");
INSERT INTO lww_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ana Sutas naga kilia ruru ga sur ya nap̃a Yesu pisa ke pania, ana veraga ga sum̃alu pa si vanua, nap̃a sane yemalolo pa rui. ");
INSERT INTO lww_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ana pogos nap̃a Sutas pa pae vanua, Yesu siar pian imimi ke sina ga e sur la moki. Naga pisa pan imimi, sape “Nanagane na pe pog na naurarena kiena ne Narin Yeririna vim kate, nanagane na pe pog nap̃a yoko naga kila naurarena kiena ne Ntewa vim ve keviu laa sane. ");
INSERT INTO lww_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ana sur ya nap̃a yoko naga yum̃aenia, kila kia kiena ne Ntewa va metava, siraun naga nene, ve ve viavi manene re, yoko Ntewa visirlua sina inu narina, kila m̃ena kiau kia va metava. ");
INSERT INTO lww_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Naruu lala, narin aora ga teke na, nap̃a nekilia nesike nemio amiu wa, lavis ga nap̃a monar neligan amiu. Pogos nap̃a amiu avisu in na nevetan amiu pae na, yoko asape akalenulia ko laa ne, ana sur nap̃a nepisa pan yerkawa kiena ita le Yu tap̃ena lala, nevisa m̃ena si van amiu, sane lele nap̃a in na yoko neva ea, amiu tap̃atete asiraunu aim e nanagane. ");
INSERT INTO lww_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ana nanagane nesape nela si navisaluaena viu tai van amiu, sane amiu monar sinemiu sisii manene amiu, va laa sanene ve sa ga nap̃a sineu sii amiu. ");
INSERT INTO lww_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ana visae sinemiu sisii amiu ke sanene, naga nene pe mrapa nakilaen yeririna nae yomarava la avisu kilia sane amiu ape kiau nalogena kemua la pe lelaga.” ");
INSERT INTO lww_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yesu pisa pae pupia visena nene pan imimi narui, ana Saemon Pita sitom̃al ke sina ga nap̃a Yesu sape ligan imimi, naga piunia sape “Ana Sup̃e, ko na yoko okom pe?” Ana Yesu pisatam̃ea, sape “In na nepa ke e lele tai nap̃a amiu tap̃atete asiraun inu aim e na wa, ana akilia ga aim e sirau.” ");
INSERT INTO lww_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ana Pita mloge, piun sina ga, pisape “Sup̃e, sanape in na tap̃atete neim nemio ko ke nanagane? In na nekekaran ga netam̃an kiau malena vanon ko nanagane.” ");
INSERT INTO lww_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ana Yesu pisa pania, sape “Ko opisa osape otam̃an ga kiom̃a malena vanon inu? Pogaga, ana nevisa ve lelaga van ko, p̃ane ga ne kolemalko, pogos nap̃a lakaporo ve kokoreko re wa, ana ko na oviro inu yam ve telu pa narui osape pe ope kiau re poli.” ");
INSERT INTO lww_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ana Yesu pisu nap̃a imimi nalogena la memloge piowa nap̃a naga monar vetan imimi, p̃isi na pisa pan imimi, sape “Amiu ve akila re nap̃a sinemiu viowa manene sanene. Ap̃asine Ntewa rui, ana monar awasine in m̃ena ga. ");
INSERT INTO lww_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Sa nap̃a nepisa pa p̃a rui, neva nekila ruru lelemiu metava ma puna ne kau Ata, ana metava ma m̃ana yum̃a, lele moki sike ea torokin amiu punu ga. Visae ve ve lelaga re, ve nevisa re van amiu. ");
INSERT INTO lww_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Neva nekila ruru lelemiu nene, ana siraunia, nowasup̃e sina, netom tanon amiu, noure amiu avam punu, asulue ga amio inu e lele nap̃a yoko nesike ea. ");
INSERT INTO lww_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ana mrapa nap̃a na vaen tol lele nap̃a nepa ke ea, amiu akilia pa rui.” ");
INSERT INTO lww_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ana Tom̃as piun petania, pisape “Sup̃e, imimi memninue ga lele nap̃a ko opisa ke osape ova ea, ana sanape ne yoko mekilia mrapa na vaen ea?” ");
INSERT INTO lww_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ana Yesu pisape “In na nepe purp̃es nen mrapa, in na nepe purp̃es nen lelagaena, in na nepe purp̃es nen malena. Pe yar re tai kilia va ma puna ne Ata sa ve kom re pun inu. ");
INSERT INTO lww_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Visae amiu apisu kilale inu, asape in na nepe ai, naga sa ga nap̃a apisu kilale m̃ena Ata. Ana nanagane, amiu apisu ke pa naga narui, sane siar na ne p̃ane, amiu akilia naga ve lelaga.” ");
INSERT INTO lww_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ana Pilip piun petania, sape “Sup̃e, sur ne naga ke nene narui nap̃a sinemiminia, mesape mevisu Arimata. Awis, sa ko na ovisa lologia li naga van imimi, yoko mekekaran vap̃isi.” ");
INSERT INTO lww_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ana Yesu pisatam̃ea, pisape “?Pilip, nesike nemio amiu tol kas via rui, ana ko pe opisu kilale ruru re in poli wa? Sa nap̃a nepisa ke pa rui, yar nap̃a pisu inu, naga sa nap̃a pisu ke pa Ata narui. ?Ana sanape na ko opiun ke sina ga osape nevisa lologia li Ata nae ma e peni van amiu? ");
INSERT INTO lww_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","?Ko na omlelaga sane inu, in na e Ata, a Ata e inu, po ko na pe omlelaga re e poli? Visena la nap̃a nepisa ke pan amiu la, pe sa re nap̃a inu ga taaga ne nepis ke e kiau kia poli, ana Ata nap̃a teke e inu naga kila ke kiena yum̃aena la nene pimi p̃arpoyo e inu. ");
INSERT INTO lww_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Popon amiu alelaga e sur la nap̃a nepisa, sane in na e Ata, a Ata na e inu. Visae ve alelaga re e inu vanon ga kiau visena la nene, monar alelaga ga vanon yum̃aena la nap̃a amiu apisu in na nekila ke pa rui. ");
INSERT INTO lww_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Nepisa pe lelaga pan amiu, sane yar nap̃a sa lelaga e inu, yoko naga m̃ena kilia kila yum̃aena la sane in na nemiyum̃aen ke ne. Yoko neligan si yo neva si puna ne Ata, ana siraunia neligan Ninuna vitomi, ana naga kilia kila kile kerkeviu la sanene, taulu nap̃a amiu apisu pa rui. ");
INSERT INTO lww_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nepisaar pan amiu, sane sur ya ne aviunia e kiau kia, yoko in na nekila ga van amiu. Yoko nekila ga ve sanene vam amiu, vena kilaen kia kiena ne Ata naga kilia va laa metava ve keviu likan amiu, e yum̃aena la nap̃a inu, sane narina, nemiyum̃aenia. ");
INSERT INTO lww_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sanene na, sur ya nap̃a aviun tan inu, yoko nekila van amiu.” ");
INSERT INTO lww_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ana Yesu pisa m̃ena pan imimi, pisape “Visae amiu sinemiu sii inu pe lelaga, monar auarar ruru kiau navisaluaena lala. ");
INSERT INTO lww_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yoko in na ve nesu re si nemio amiu, ana yoko neviun tan Ata vena ligan yar tap̃ena tai vim kus leleu vena iila amiu. Naga nap̃a yoko imi, yoko sulue ga amio amiu, ");
INSERT INTO lww_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","naga pe Ninuna na visawalen visena lelaga. Yeririna na yemalolo na yomarava nini tap̃atete atol naga, vanon tap̃atete akilia avisu kilale naga, pe akilia re nena, ana yoko amiu akilia ruru naga vanon naga ke narui nap̃a amio amiu nanagane, a yoko sike lue ga e amiu. ");
INSERT INTO lww_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Kiau nalogena lala, tap̃atete neligan kare amiu nap̃a asum̃a sane ninuyu ga la poli. Peraga, yoko nowasup̃e si neimin amiu. ");
INSERT INTO lww_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Narin aora teke ga wa, pe piavi re nena, yoko yeririna na yomarava nini tap̃atete avisu in sina. Ana amiu ga yoko avisu nap̃a in na nemal sina ga, ana vanon nap̃a nemal, amiu m̃ena yoko amal. ");
INSERT INTO lww_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","E legiena nene nap̃a avisunu nemal sina, amiu akilia sane in na e Ata, a amiu e inu, a in na e amiu. ");
INSERT INTO lww_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Naga nap̃a sinena sii inu pe lelaga, naga pe naga nap̃a p̃uarar ruru kiau navisaluaena lala a mlogear la. Naga nap̃a sinena sii inu sanene, yoko Ata sinena siia, amio in m̃ena sineu siia, nakekaten ke naga vena nekila naga kilia inu laa sane.” ");
INSERT INTO lww_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ana imimi nalogena tai, nap̃a Yutas tap̃ena, pe naga re nap̃a nae Kariot poli, piun tan Yesu, sape “Ana Sup̃e, osape oim okekaten imimi, ana yoko okila e mrapa na sanape nap̃a yoko yeririna tap̃ena la nae yomarava tap̃atete avisu kilia?” ");
INSERT INTO lww_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ana Yesu pisatam̃ea, pisape “Visae yar sinena sii inu, yoko uarar ruru kiau visena lala, ana yoko Ata sinena sii naga. A yoko imimi lua meim puna, mekila m̃amimi um̃a memio naga e kiena malena, ana yoko tap̃atete ve sanene va la nap̃a pe amlelaga re poli. ");
INSERT INTO lww_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ana yar nap̃a pe sinena sii in re poli, naga tap̃atete logear ruru kiau visena lala. Naga nene navisatam̃eena na kiamiu naviunena nene, ana e visena nap̃a amiu amloge ga nagane, pe pe kiau visena re nene poli, naga pe visena kiena ne Ata nap̃a mliganu nepitom e nini.” ");
INSERT INTO lww_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ana Yesu pisape “Pogos nap̃a nesike nemio amiu wa, in na nepisa ke sur la moki sanini pan amiu rui. ");
INSERT INTO lww_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ana pogos nap̃a sa nevano, yoko Ata ligan Ninuna na iilaena vitomi, ana naga yoko kus leleu, vian amiu e sur punu ga, ana ligan nasitom̃alena e kiau visena la punu ga e kiamiu sitomena lala. ");
INSERT INTO lww_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","In na nevano, ana neligan sum̃arena sike amio amiu. Sum̃arena kiau nene pe sum̃are nowo tai nap̃a yomarava nini tap̃atete la van amiu. Ve sanene na, ve akila re nap̃a sinemiu viowa manenea, a ve amaraun re sur lala. Amiu ve asitom manene re, ");
INSERT INTO lww_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","kome monar ve sa ga nap̃a nepisa pa pan amiu rui, nesape in na neure kone wa, ana yoko neim si pun amiu. Pona amiu aloge viowa nap̃a nevano, ana visae sinemiu sii inu, popon amiu akekara manenea nap̃a nekilia neva sina puna ne Ata, nap̃a naga to laa metavan inu keviu pap̃isi. ");
INSERT INTO lww_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Sur la punu ga nene pere wa, ana nanagane na nepisawal ruru pan amiu rui. Ana pogos nap̃a avisu imi m̃alivi torokin nena ga sa nap̃a nepisa, ana p̃isi na akilia alelaga ga sane nepe lelaga. ");
INSERT INTO lww_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“A nanagane, tap̃atete nevisa si sur ve moki van amiu, vanon p̃arin sup̃e nap̃a pe p̃arin sup̃en ke yomarava nini nagane na, pimin inu ke pa rui. Ana yaru nene, puriukawaena kiena pe torokin re taulu kiau puriukawaena poli, ");
INSERT INTO lww_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ana netam̃an inu ga e limana, monar nekila ga sur ya nap̃a Ata sinenan sape nekila. Nekila sanene, vena yeririna na yomarava nini avisulup̃aria sane sineu sii la. “Poga, kana pog narui, tesum̃alu teva vanua.” ");
INSERT INTO lww_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ana e pog nap̃a memial mepano, Yesu pisa ke sina ga visena p̃as pan imimi. Naga pisape “In na nepe purp̃es nen kilkerep nap̃a lelaga, a Ata naga pe yar na visuaren lokove na kilika lala. ");
INSERT INTO lww_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Naga pisuar ruru ke korowasneu lala, visae visu korowas tai nap̃a p̃ar re mras poli, naga telua, a visae visu tai nap̃a p̃ar mrasa, yoko kilavan ruruia vena war si mras ve moki. ");
INSERT INTO lww_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Sur nene nekila pan amiu rui, nap̃a sane sur nap̃a kilavan ruru amiu, naga kiau visena la nap̃a nepisa ke pan amiu. ");
INSERT INTO lww_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Amiu na korowasneu lala, monar ayakolkol ruru amiu e inu, a in na neyakolkol ruru nemio amiu. Visae korowas nen kilka ve yakol ruru re amio purp̃esia, tap̃atete war mrasa, a maran taaga ga amio amiu, visae ve ayakolkol ruru re amio inu, yoko kiamiu malena tap̃atete nena war mras napo lala. ");
INSERT INTO lww_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“In na nepe purp̃es nen kilika, amiu na ape narin korowasneu lala. Naga nap̃a sikol e inu a nesikol e naga, naga ke nap̃a yoko kiena malena kilia war mras ve moki, vanon sa ve in re e amiu, tap̃atete nena akilia akila sur tai nap̃a po e marana ne Ntewa. ");
INSERT INTO lww_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Visae yar tai ve sikol re e inu, naga sane korowas tai nap̃a pimi mano pa rui, atelua awar akoven va e kapi, kapi kekania. ");
INSERT INTO lww_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Visae asu ruru m̃a e inu, a kiau visena to ruru m̃a e amiu, sur ya nap̃a sinemiun asape aviunia, akilia atolia. ");
INSERT INTO lww_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Popon amiu awar mras la ve moki e kiamiu malena lala, naga nene mesmesun kiau nalogena la asum̃a akila, a pe mrapa m̃ena nakilaen kia kiena ne Ata va manene laa metava. ");
INSERT INTO lww_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ata sinena sii inu pap̃isi, ana vanon nap̃a sinena sii inu, inu m̃ena sineu sii amiu, ana popon amiu asikol ruru amiu e kiau nasinesiena nene. ");
INSERT INTO lww_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","“Visae auarar ruru kiau navisaluaena lala, akilia asum̃a loyum̃a e kiau nasinesiena nene, sa nap̃a in na nepuarar ruru ke pa rui navisaluaena kiena ne Ata, nesike pa loyum̃a e kiena nasinesiena rui. ");
INSERT INTO lww_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ana sur la nap̃a nepisa ke pan amiu, nemla pan amiu vena kiau nakekarena sike amio amiu, kila pupia kekarena tai nap̃a po na po kilia sulue ga amio amiu silaga. ");
INSERT INTO lww_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","A kiau navisaluaena maro tai nalaen van amiu sanini, sane amiu monar sinemiu sisii amiu lue ga, sa nap̃a in na sineu si amiu ke ne. ");
INSERT INTO lww_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Pe sinesiena re si tai poli nap̃a po taulu na sinesiena nap̃a yar tai tam̃an kiena malena, mare vena tamalia kiena erau tai. ");
INSERT INTO lww_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ana yoko in na nekilia nekila ve sa ga nene van amiu, vanon visae alelaga e kiau visena lala, yoko ave kiau erau la rui. ");
INSERT INTO lww_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Pe nepio amiu re sina nesape kam yar na yum̃ae kiauena ga lala poli, vanon yar na yum̃aena naga miyum̃ae ga, pe kilia ruru re navisaarena na yum̃aena kiena ne kiena sup̃e poli. Ana in na nepisu amiu ape kiau erau lala, vanon sur punu ga nap̃a nemloge Ata pisa pan inu, nepisawalia pimi merarava pan amiu. ");
INSERT INTO lww_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Amiu pe apisa lologia in re poli asape nepe kiamiu, ana in na nepisa lologia amiu ape kiau, nepisirlar amiu vena ava awar mrasa e kiamiu malena lala, mras nap̃a sulue ga sike na rui. Ana pogos nap̃a ava ke sanene, sur ya nap̃a aviun e kiau kia van Ata nae ma peni, yoko naga la ga van amiu. ");
INSERT INTO lww_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na nene kiau navisaluaena van amiu naga sanini, sane amiu monar sinemiu sisii amiu.” ");
INSERT INTO lww_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","A Yesu pisape “Visae yoko avisu sane yaru na yomarava la nap̃a pe amlelaga re poli, sinela kar amiu, ve ailan manene re. Monar asitom̃al m̃a nap̃a lala na yomarava nini sinela kar inu sumo rui, p̃isi na sinela kar mare amiu m̃ena ga ne. ");
INSERT INTO lww_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Visae amiu ave sa ga yeririna na yomarava nini, yoko akekaran amiu ga, ana in na nekilologia amiu pa rui nesape aure vetan malena na yomarava nini. Kam na pe maran taaga re si sane kiena yar la poli, kila sane sinela kar amiu narui. ");
INSERT INTO lww_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ana popon amiu asitom̃al lue ga visena nap̃a nepisa pan amiu rui, nap̃a nesape yar na yum̃aena tap̃atete sukalawan kiena sup̃e. Visena nene kana kinasia sape sa ga nap̃a akila piowa ga akila karenu, yoko akila viowa akila kare amiu m̃ena. Sa ga nap̃a la pe amlogear re kiau visena la poli, yoko ve alogear re m̃ena kiamiu visena lala. ");
INSERT INTO lww_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","P̃elaga viowa na sanene yoko akila van amiu vanon ga nap̃a amiu ape kiau, akila vanon pe akilia re naga nap̃a mligan inu nepitom tano. ");
INSERT INTO lww_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Visae ve neim nevisa meraravan re sur la nene e marala, yoko Ntewa visu sane lala pe akilaro re kiau visena poli. Ana nanagane na, amloge kiau visena la punu ga rui, ana tap̃atete avisawan si visena tai e kiela naviowaena nap̃a akila p̃arm̃arera van Ntewa. ");
INSERT INTO lww_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Lelaga, akila p̃arm̃arera pa Ntewa rui, vanon nap̃a apieluen inu, ana naga sa nap̃a apieluen m̃ena Ata. ");
INSERT INTO lww_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Visae ve kiau kile re la nap̃a apisu nekila, nap̃a pe yar re si tai nap̃a kilia kila, pona Ntewa yoko ve visa re sape naviowaena sike e la. Ana pere, apisu pa rui, ana pe amlelaga re ga poli, ap̃aryon nakilaen navielueena pan imimi lua Ata. ");
INSERT INTO lww_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sur nene mesmesun ga visena tai nap̃a Ntewa mligan teke e Nasiriena Wa, nap̃a sape ‘Sinela kar nu pap̃isi, ana peraga, pe panon re kiau naviowaena tai poli.’ ");
INSERT INTO lww_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ana nevisa van amiu, sane yoko neligan Ninuna na iilaena vetan Ata mava vitom m̃alivin amiu, nap̃a pe Ninuna nap̃a molue e malena kiena ne Ntewa, nap̃a pe Ninuna na visawalen nalelagaena. Naga vitom visawal inu re laa van amiu sane, ");
INSERT INTO lww_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ana siraunia, amiu m̃ena monar avisawal manene inu va laa sane van yar tap̃ena lala. Na nene komin nap̃a amiu la nene asu lue ga amio inu silaga siar e nasiarena kiau yum̃aena pimi tol nanagane.” ");
INSERT INTO lww_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ana Yesu pis m̃a ke pan imimi kiena nalogena lala wa, sape “Visena la nene, nepisa ke pan amiu ve nauarar ruru amiuena, vena kiamiu viawaena ve lor re pogos tai. ");
INSERT INTO lww_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","“Pe lelaga, monar akilia asape kieta yerkawa lala yoko akoven plan amiu vetan kieta yum̃a nalotena lala, ana yoko viowa laa sane van amiu vano-o tol pogos nap̃a sane sa awe mom̃ar amiu, ana yoko la avisa asape nanene yum̃aena wo tai nene, ana akila vena Ntewa kekarania. ");
INSERT INTO lww_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yoko la akilia akila ve sanene van amiu, komin pimi tol nagane pe akilia ruru re Ata nae ma e peni poli wa, a pe akilia ruru in re m̃ena poli. ");
INSERT INTO lww_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ana siraunia, pogos nap̃a avisu sur la ne imi kakate ke ve sanene van amiu, akilia asitom̃al sina ga, ana yoko avisa asape ‘Lelaga ga o, nanagane na tepisu sur la nene sa ga 