﻿USE sofia;
DROP TABLE IF EXISTS sofia.lwo_vpl;
CREATE TABLE lwo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lwo_vpl WRITE;
INSERT INTO lwo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1"," Ka kwaan batien Jeacuu Kriihjto e man: Jeacuu tiene aay ke bang Deabid kedea Deabid tiene aay ke bang Abraahm. ");
INSERT INTO lwo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraahm e naa wur Yijaag, ea Yijaag wur Jeakob, Jeakob wur Juuda maa ge wuud men. ");
INSERT INTO lwo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juuda e naa wur Perej ge keehd Jerah, ge miih gen nyinge Tamar. Perej e naa wur Ejron, ea Ejron beehda wur Ram. ");
INSERT INTO lwo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram e naa wur Aminadaab, ea Aminadaab e naa wur Naacohn ge e naa wur Calmon. ");
INSERT INTO lwo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Calmon e naa wur Buoj e men nyinge Raahb, Buoj wur Obed kedea miih Obed anahg Rudh. Obed wur Jeci. ");
INSERT INTO lwo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jeci e naa wur Deabid ge anahg ruohdh me duohng yi paajo. Deabid e naa wur Caloamon, ge men anahg ciih Uriiha umodho. ");
INSERT INTO lwo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Caloamon e naa wur Rehboam ea Rehboam beehda wur Abihja. Abihja e naa wur Aja. ");
INSERT INTO lwo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ea Aja e naa wur Jiehcopad. Jiehcopad e naa wur Jeerom, ea Jeerom beehda wur Ujiiha. ");
INSERT INTO lwo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ujiiha e naa wur Joatham, ea Joatham ngo wur A'ahj, A'ahj wur Ejeekya. ");
INSERT INTO lwo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ejeekya e naa wur Manaajeh, ea Manaajeh wur Amon. Amon wur Joacya. ");
INSERT INTO lwo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Joacya e naa wur Jeekoanya. Jeekoanya keehd jo paar men ge anudo yi wong anaa apeej yaa Judea ukedh gen piny Baabihloanya ne baahng. ");
INSERT INTO lwo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Naa athube ke batien ka anaa apeej yaa Judea ubeehn gene Baabihloanya ne baahng, e Jeekoanya e naa wur Cealtiel, Cealtiel wur Jerubaabel. ");
INSERT INTO lwo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jerubaabel e naa wur Abuud ea Abuud wur Elyakihm. Elyakihm e naa wur Acoar. ");
INSERT INTO lwo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Acoar e naa wur Jadog, ea Jadog wur Akihm. Akihm e naa wur Eliihd, ");
INSERT INTO lwo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ea Eliihd wur Eleajar, Eleajar wur Mathahn. Mathahn e naa wur Jeakob. ");
INSERT INTO lwo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ea Jeakob e naa wur Jocebe ge naa anyuom Maarya ngaan anyuol Jeacuu ge cuohn ne Ngad Boadh nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ge kuow Jeacuu naa akwaan, ge wahdh kar apaar wonge angween naa athube ke rih Abraahm uwahdhe bang Deabid. Kedea ge wahdh kar apaar wonge angween dahng naa athube ke rih Deabid uwahdhe wong anaa apeej Judea yea. Keehdo ge kar apaar wonge angween thiow naa athube kii wong anaa apeej yaa Baabihloanya yaa Judea uwahdhe bang Jeacuu Ngad Boadh nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kaa anyuol Jeacuu Kriihjto anaa wa gihn. Maarya men anaa atuohj Jocebe. Maarya atuohje abea poohd kuu anaa acub yihr cuore. Gihn nu e Maarya nyethiin ake ngeyo ree. Anahg nyethiin maa ayoade ke bang Wahy Juog. ");
INSERT INTO lwo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jocebe anaa anahg ngaa maa abiohgrwaal, noono e cwihnye atooro bange uyaahre kuohm Maarya nyum nyoge ke nying gihn ayaje piny kalo. Kaano e lubo agweehge ne pahd kaahnye piny maahdh e ngaa me ngahy ngo tooro. ");
INSERT INTO lwo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Abea nye kaano adaahde kaahnye ke pahdo piny nu, e naa nye kaa aguo wuohnjuoge beehn wiihe yi laahg maa arube yihr Jocebe kea, “Jocebe! A abeehn ne rob yihri ke nying kaahnyi ke Maarya. Yih kwaar Deabid, yih keá kweer ke nyuom Maarya. Yih keá kweer ne weey weey bang gihn nyethiin niidi ree, beehda nyethiin maa ayoade ke bang Wahy Juog. ");
INSERT INTO lwo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ngo unyuol nyedhoohg kedea nyinge ucagi ne Jeacuu bang gihn unahg en nuu uboadh yaa paar gen yihdh anyoohne giih atiihy gene rih Juog.” Kaano e wuohnjuog ake aay. ");
INSERT INTO lwo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Maarya ayihdo ke nyethiin e ngo kuu aroohmo ke dhecuow. Gihn nu ree atiihye beere gihn anaa arob Juoge keehd leeb ngad agamloohngjuog pahdh kare. Anaa arob Juoge kea, ");
INSERT INTO lwo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nyaakow maa tongo unyuol ucag nying nyethiin ne Emanwel.” (Lum yea teed ngo kejea Juog ubeehdo ke won). ");
INSERT INTO lwo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Naa atahng Jocebe yihdh niine e wiihe awaare waaro ukahle Maarya paajo ne ciihe wa kaa arob wuohnjuoge ngo yihre. ");
INSERT INTO lwo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Jocebe abeehdo e be cidh wod ke ciihe uwahdhe kaa anyuole, noono maa acag Jocebe nying nyethiin ne Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jeacuu anyuol yi geen Bedhlehm yi piny Judea yi ruohdh Eroade. Batien kaa anyuol Jeacuu e tiehde me ngahy giih Juog ge a'aay kun moohl cahng kii ngo e ge beehn Jeruucalem. Naa awahnh gene ");
INSERT INTO lwo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","e ge apeehyo yihr nyoge, “Yaage, wa nyoge me aay ke ka me baahr. Wa daahd paan anyuol ruohdh Judea yea. Ciehro gihn nyoadh cahng anyuole ngo atuohl kedea uniid wane ngo. Cwihny wan ne bang wuor ngo, e naa gihn daahd wane kare.” ");
INSERT INTO lwo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lum caahdh tiehde ke nyinge ngo abeehn Eroade ne lihngo. Gihn nu e cwihnye adaag keter bang gihn wiihe apare kejea ruohdhe kaab ngaan anyuole kaabo. Keehd yaa beed geen Jeruucalem cwihny gen adaag thiow. ");
INSERT INTO lwo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kaano arumo e Eroade jo doong yaa lam maa yaa loohng Juog ge acuohne cang yi amaad. Naa amahd nyoge, e Eroade arubo yihr gen kea, “Yaage, gihn me daahda ke peehnyo yihru nud. Anahg kee e naa anaa arob kejea Ngad Boadh nyoge unyuol yea?” ");
INSERT INTO lwo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Gihn nu e ngo abeehr gene yihre kob gene, “Ngo unyuol kii Bedhlehm yi piny Judea. Bang gihn ngo anaa agweed agamloohngjuoge kea, ");
INSERT INTO lwo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Keehd me nahg Bedhlehme geew me gihr nyinge tooro paar yaa Judea e ngo uroomo keehd geedh muu nying gen awiihj bang gihn ruohdh gihn umag jo'a ge yaa Yijarael ngo unyuol Bedhlehm.’ ” ");
INSERT INTO lwo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kaano e Eroade tiehde ge acuohne bange e kwihy nyoge. Maa apeehnye gen ne ngey ngo ne cohg weehne e naa atuohl ciehj aniid gene. ");
INSERT INTO lwo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Naa ateed gene ngo yihr Eroade, e arubo yihr gen kea, “Nyethiin gihn daahdu ngo anyuol yi Bedhlehm. Cidhu udaahdu kare beer mee. Nea kare ayoadu arumo, e kea ne duu ke banga beere an ke nguda, a caa ne wuor ngo thiow.” Noono uoohre gen Bedhlehm. ");
INSERT INTO lwo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Batien kaa alihng gene lum Ruohdh, e rog gen atihng gene upahdh gene kii yoohn gen. Kaano keehdo e ciehro gihn anaa aniid gene kun moohl cahng kii ngo, acahg gene kaa niido e caahdh kaa maalo nyum gen. Naa aniid gene ciehro nyum gen, e cwihny gen ake mihno keter. Ciehro akaahn nyum gen uwahdhe kaa acuunge umeenye wiih wod ane nyethiine yea. ");
INSERT INTO lwo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Naa awahnh gene paan nu, e ge aci wod maa ayoad gene nyethiin maa men Maarya. Noono urung gene cung gen piny ne wuor nyethiin. Batiene e giih akahl gene ne cubo yihr nyethiin ge akahl gene oogo yihdh jooge. Giih acub gene ge anahg dhaahb maa duo me ngwaahy med me yug naa adung dung maa mow me ngwaahy me cuohn ne mihr. ");
INSERT INTO lwo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Batien kaa acub gene giih gen noono, e ge adog paar gen ke yooh moogo. Ge kuu adoog ke batien gen bang gihn arob Juoge yihr gen yi laahg kejea ge keá cahg dog bang Eroade. ");
INSERT INTO lwo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Naa a'aay tiehde e wuohnjuog abeehn wiih Jocebe yi laahg maa arube kea, “Jocebe! Lihng gihn teeda yihri. Aj maalo ugwiiri rihi ne goohd Micihr ke nyethiin maa men. Beehdi kun nu uwahdhe cahng ukoba ngo yihri kejea duui gen, bang gihn Eroade wiihe upare ne daahd nyethiin beere ngo ke naah.” ");
INSERT INTO lwo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Gihn nu e Jocebe ree agwiire maa a'aaye keehd gen dewaahr nu ne goohd Micihr. ");
INSERT INTO lwo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jocebe abeehdo kun nu uwahdhe kaa athow Eroade. Gihn nu ree ayuge beere gihn anaa arob Juoge ke leeb agamloohngjuog pahdh kare cahng uduu gene. Anaa akob Juoge kea, “Waahda naa anaa Micihr ngo acuohna.” ");
INSERT INTO lwo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kaa angey Eroade ngo kejea giih waal ge ayug tiehde ree, e cwihnye ake rahnyo ne cohg. Noono uteede lubo yihr acaakere ne cidh Bedhlehm maa yihdh miehy cahng keehde ne nahg nyedhoohy. Arobe kea thub naahg wudh nyedhoohg yihr gen ne run ariow kedea yaa anyuol batien gen. Arob Eroade wa gihn nu ne rom wiih cahng anaa ateed tiehde kejea ciehro atuohl: ciehj nyoadh cahng anyuol ruohdh Yijarael. ");
INSERT INTO lwo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","E naa kaa apahdhe kare e gihn anaa arob Juoge ke leeb agamloohngjuog e nyinge Jermya. Anaa akob Juoge kea, ");
INSERT INTO lwo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lan thoo alihng ke yoohn Ramaah. Thoo maa angeer yej. Rakeale e ne yuog thon nyethene. Cwihnye be rom ree ke ciihmo bang gihn nyethiin maa adoohng yihre tooro.” ");
INSERT INTO lwo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Eroade athow e Jocebe puud ne Micihr. Batien thone e wuohnjuog abeehn wiih Jocebe yi laahg maa arube kea, ");
INSERT INTO lwo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Jocebe! Lubo maa abeehna keehde yihri ngo nud. Yaa anaa adaahd nyethiin ke naah, ge athow. Awaahn ni, gwiir rihi ukaabi nyethiin maa men udoogu Yijarael.” ");
INSERT INTO lwo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Noono ugwiir Jocebe ree ukaabe nyethiin maa men udog gene Yijarael. ");
INSERT INTO lwo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Naa abeehn Jocebe Yijarael e ngo atud ke cidh yi piny Judea bang gihn ngo alihnge kejea Arkalaaw e naa aluuny yi ruohdh wahn Eroade kedea ngo arob yihre yi laahg thiow kejea cea Gaalili. ");
INSERT INTO lwo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Naa abeehne dom Gaalili, e ngo apiih Naajaread ne paajo. Gihn nu ree ayuge beere gihn anaa arob Juoge ke leehb yaa agamloohngjuog ke nying Ngad Boadh nyoge pahdh kare. Anaa akob Juoge kea, “Ngo ucuohn ne ngad Naajaread.” ");
INSERT INTO lwo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Naa abar wudh giih nu, e Joon Ngad Luogwahy ree anyoadhe e upuohnyo ke bang yi ukang gihr Judea kobe, ");
INSERT INTO lwo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Rahny cwihnyu bang anyoohne giihu naa atiihyu kedea logu anyoohne ngahdhu, bang gihn cahng beehn Juoge umage nyoge ne joe ngo adoohng cahng.” ");
INSERT INTO lwo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Joon e naa anaa arub Yicaaye agamloohngjuoge ke nyinge kea, “Nud ke duol me kwaag yi ukang kea, ‘Gwiir yooh yihr Ruohdh, gwiir yooh me ne cohg cohg yihre.’ ” ");
INSERT INTO lwo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Joon na cam caame giih na yoade yi ukang. Ngo na bodh kaa kihj maa baahnyo kedea na ngaab yiehj amana maa acwaahj kedea deehl e naa atuohye yi badhe. ");
INSERT INTO lwo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Gihn nu e nyoge me thoohdh awaahdo bange yi ukang ke bang geen Jeruucalem maa ke wudh geedh Judea. Nyoge aoohnyo thiow ke bang yihdh miehy cahng ke naam Joohrdoan. ");
INSERT INTO lwo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Maa abeehn gene urob gene adhemuohme giih atiihy gene oogo. Batiene naa akwaan gene adhemuohme giih gen, e wudh gen amuoj Joone ke piih Juog naam Joohrdoan ne cub luogwahy yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Naa aniid Joone ngo kejea Paarijea maa Caaduucean me thoohdh ge abeehn bange e ge daahd luogwahy, e Joon ake rubo yihr gen kea, “Wu nyoge me reje me neehn thoohne maa wu beehda yaa waal. Gihn daahdu ngahj! Wu daahd ukoolu rahny cwihny Juog ge beehn ni abea cwihnyu kuu arahnyo rog anyoohne giihu! ");
INSERT INTO lwo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","A teed lubo me ne cohg yihru: thubu kaa awaahn kan ke tiihy giih me beeye beere ngo ke ngeyo rogu kejea anyoohne giihu ge alogu ngahdhu. Kaano e kare nud umuoja wudhu ke luogwahy. ");
INSERT INTO lwo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yaage, wudhu keá paru kejea ne nahgu nyethea Abraahm e Juog wu buu ukihme. Wu kihm Juoge kihmo keehd maa akwanye wun ne joe. Kare nud yihr Juog ukaabe wey leele giih ni uloge gen udoohng gene ne kwaay Abraahm. ");
INSERT INTO lwo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ukihm mar Juog muu uroomo wa ley maa apaag me ngol yen piny keehd biey gen agwiire ke nyingu. E kwaad yaadh gihn nyuol ke nyethen me be cam dhiil kaa ngod piny cang uthoohre yi maaj ne waang. ");
INSERT INTO lwo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Yaage! Luogwahy mara ge cuba yihru kan, beehda luogwahy mar piih now me nyoadh ngo kejea dhaano cwihnye arahnyo rog anyoohne giihe naa atiihye. Ngaa me teege akaal wiih teeg mara muu ulog beehno ke batiena nud. Ngaan nu e naa ngaa duohng riha, gihn me a be rom kaahn wuoy tiene. Wahy Juog ke ngude e nuu uwuoje wudh nyoge ne muoj gen ke luogwahy, beere nyoge cwihny gen ungahmo kedea uteehng yiiho gihr gene wa ngiihnyo e thaahdh ke maaj. ");
INSERT INTO lwo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ataaj me wa gihr kuor beel nii cinge, noono e nyoge ge kuore kuoro wa beel, ukedhe liil yi gala abea coang ge ucwinye ke deeh maaj me waang e ngo be gug.” ");
INSERT INTO lwo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yihdh nihn nu, e Jeacuu anaa abeehn koohr naam Joohrdoan bang Joon e ngo beehn kaa yoohn Gaalili. Abeehno uteede ngo yihr Joon kea, “Cub luogwahy yihra neehn mar yaa ni.” ");
INSERT INTO lwo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Abea Joon adaahd ukweere ke cub luogwahy yihr ngo. Gihn nu e arubo yihr Jeacuu kea, “Ke ne diih! Kare tooro ucuba luogwahy yihri. Nea kare ne cohg ngahda ne nahg yihn ne ne cub luogwahy yihra ne?” ");
INSERT INTO lwo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Maa ateed Jeacuue ngo yihre kea, “Wii lumi noono robi tudi ukuongi gihn roba ke lihngo. Cub luogwahy yihra beere giih anaa ateed Juoge ke nyinga ge pahdh kar gen ne rihb.” Kaano e Joon kuu arom kweer maa acube luogwahy yihr Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Naa acub Joone luogwahy, e Jeacuu abeehn oogo yihdh piih. Nye wong kaano abeehne oogo nu, e maalo ree ayabe yabo maa aniide Wahy Juog wa kihd akuur e ngo beehn bange e loohn piny kaa yoohn maalo maa apiihe wiihe. ");
INSERT INTO lwo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kaano e duol ake lihngo kii lwahd maalo e ngo urubo kea, “Gihn e naa Waahda maa anhyaara kedea cwihnya med ree.” ");
INSERT INTO lwo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Batien kaa acub luogwahy yihr Jeacuu ke Piih Juog kedea kaa akoohb Juoge kea Jeacuu beehda waahde, e Wahy Juog a'aay keehde ne ci yi ukang maa awiie ngo kare keede. Ngo akedhe kare keede beer e ngo tum atiihb ukeehge tumo ke dwaahngo. ");
INSERT INTO lwo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jeacuu abeehdo yi ukang ke kar nihn jiehariow ne roang roang e cam be gweele. Gihn nu e abeehn kahje ke ne bango ne cohg. ");
INSERT INTO lwo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ge abang kahje Jeacuu e naa abeehn atiihb ukeehge ne tum ngo ke dwaahngo kobe, “Nea yih beehda Waahd Juog ne cohg, kea log leele giih ni naa amune.” ");
INSERT INTO lwo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Maa abeehr Jeacuue ngo yihre kea, “Bekihde! Wa ngo agweed yi kitaab Juog naa, ‘Padh amono cog e ne bodh nyoge keehde abea gihn boadh nyoge ne cohg beehda kwaad gihn rob Juoge.’ ” ");
INSERT INTO lwo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jeacuu acahg atiihb ukeehge ke kaabo ucube ngo alidh Wod Juog gihr Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Maa arube yihre kobe, “Nea yih Waahd Juog ne cohg kea thoohr rihi piny bang gihn ngo agweed yi kitaab Juog naa, ‘Juog wuohdjuog giihe ge uoohre bangi urihng gene ukoal gene yihn beer mee. Yih uboam gene uthaang gene yihn kii cing gen beer mee utoor leele me cwaany tieni.’ ” ");
INSERT INTO lwo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Maa arob Jeacuue ngo yihre kea, “Gahng! Ka me tuma Juog tooro ne weey weey. Ngo agweed yi kitaab Juog naa, ‘Juog ge e naa Juog Ruohdhi ngo keá tum now ke dhieny.’ ” ");
INSERT INTO lwo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Maa acahg atiihb ukeehge ngo ke kaabo ukedhe ngo alidh good me duohng unyoadhe kwaad giih nud upiny cang yihre ke kwaan gen kedea ke kaa awuohb gene kii ngo. Maa arobe ngo yihre kea, ");
INSERT INTO lwo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Awaahn kan, nea congi arungi piny uwuori an ne Juog, e alwaa amahr giih aniidi cang ge cuba cubo yihri kedea unahgi ruohdh wiih ngoom.” ");
INSERT INTO lwo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Maa arob Jeacuue ngo yihre kobe, “Atiihb ukeehg! Kaa coohr rihi oogo buuda! Agweed yi kitaab Juog naa, ‘Nahge Juog keede e ne wuor kedea e ne gihre tiihj.’ ” ");
INSERT INTO lwo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kaano e atiihb ukeehg a'aay kedea uguo wuohnjuoge beehno ne gwiir gihn daahde. ");
INSERT INTO lwo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Naa alihng Jeacuue ngo kejea Joon akedh yi thijin e ngo a'aay udoge piny Gaalili. ");
INSERT INTO lwo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jeacuu a'aay Naajaread kaa abeede ubeehne ne piih geen Kaparnaam. Kaparnaam beehda geew me ne dieng naam duohng me guge be niid kedea beehda geew me ne wudh pinye giih Jebulun maa Neptaali. ");
INSERT INTO lwo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","E naa kaa abeehn gihn anaa arob Juoge ke leeb agamloohngjuog me nyinge Yicaaya upahdhe kare. Anaa akob Juoge kea, ");
INSERT INTO lwo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Wu yaa Jebulun maa yaa Neptaali ge beed buud naam duohng kedea wu yaa buud naam Joohrdoan maa yaa padh Judea ge beed piny Gaalili, Ciig Beer ngo ulihngu. ");
INSERT INTO lwo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Noono e yaa padh Judea gihn maa adiehr ke nying Juog ulihng gene thiow kedea udoohng gene ne nyoge maa ayiih lum Juog. Ge udoohng wa nyoge maa anaa yi muudho ke nying lwahy thoo. Naa ameeny gen e ge ake niido.” ");
INSERT INTO lwo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Anahg Kaparnaam e naa athub Jeacuue ke puohny nyoge yea e ge puohnye puohnyo kobe, “Maan dhaane anyoohne giihe naa atiihye bang gihn kar beehn Juog ne mag nyoge ne joe ngo adoohng cahng.” ");
INSERT INTO lwo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Cahng man e Jeacuu anaa ake caahdho ke dieng naam duohng gihr Gaalili e nyoge ariow ge aniide, dhaano ge kuu umen. Cimoane, me nying tuode Piihter maa Andrya umen. Ge anaa ke mahyo ke rej e booy thoohr gene kii naam duohng bang gihn ge anahg yaa maay. ");
INSERT INTO lwo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Maa acuohn Jeacuue gen bange ukobe ngo yihr gen kea, “Beehnu unahgu yaa waahdha. Adaahd udoohngu ne yaa kahl nyoge yihra wa kwaad kaano kahlu rej oogo nu.” ");
INSERT INTO lwo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ke wong kaano e booy giih gen awii gene piny ubuodh gene batiene. ");
INSERT INTO lwo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Naa abar Jeacuue wong maalo e nyoge ariow mooge ge acahge kaa niido. Nyoge maa wuud meehe thiow, Jeamij waahd Jebeade kedea Joon umen. Ge anaa yi baabuur keehd wur gen e ge tuohj thool giih acoohd. Maa acuohn Jeacuue gen bange. ");
INSERT INTO lwo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ke wong kaano, e yaa ni wur ge awiihw gene kedea uwii gene baabuur gihr gen yihr wur gen. Maa abuodh gene batien Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kaano arumo, e Jeacuu nu ucaahdho e wen bang yi Gaalili e ngo puohny Ciig Beer yihr nyoge ke bang yihdh wuud amaad giih Judea, kedea e ngo thiehdh nyoge me rog gen anaa kwaad atwaanye me thoohdh. ");
INSERT INTO lwo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Gihn nu e nyinge awiihj kaano yi piny Ciihrya. Noono uwaahd nyoge bange ne kahl yaa tuu beere ge thiehdhe thiehdho. Nyoge mooge rog gen anaa atwaanye me ledh, e mooge koohm gen anaa atiihb ukeehg. Mooge dahng wudh gen anaa pol e mooge thiow ge nyoge maa adwaany. Amahr yaa nu cang ge athiehdhe. ");
INSERT INTO lwo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Amahr yaa abeehno ke yoohn Gaalili kedea amahr muu abeehno ke yoohn Geedhe Apaar maa Jeruucalem kedea piny Judea maa amahr muu abeehno ke yoohn miehr loog naam Joohrdoan, alwaa amahr akuud yaa nu cang ge ake caahdho ke batien Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Naa aniid Jeacuue ngo e amahr akuud nyoge awaahdo bange, e acaa maalo ka me thoohny maa apiihe ne puohny. Jo waahdhe ge anaa apiih buude e ngo atieg gene piny. ");
INSERT INTO lwo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Noono uthube ke puohny kobe, ");
INSERT INTO lwo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Med cwihny yihr nyoge me ngahy ngo kejea ge angoohng yi wong Juog, bang gihn Dhaahr Juog beehda gihr gen. ");
INSERT INTO lwo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Med cwihny yihr yaa cwihny gen yuog bang gihn cwihny gen uciihm. ");
INSERT INTO lwo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Med cwihny yihr yaa kweer ke nyoadh bad, bang gihn piny Juog ulag gene. ");
INSERT INTO lwo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Med cwihny yihr yaa adeehj tiihy ngaa maa abiohgrwaal yi koohdh gen, bang gihn Juog gihn me beer ucube yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Med cwihny yihr yaa duu cwihny gen caahn rog nyoge, bang gihn Juog cwihnye uduue caahn rog gen. ");
INSERT INTO lwo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Med cwihny yihr yaa bahdh yej, bang gihn Juog uniid gene. ");
INSERT INTO lwo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Med cwihny yihr yaa doohr nyoge, bang gihn ge nuu ucuohn ne nyethen Juog. ");
INSERT INTO lwo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Med cwihny yihr yaa ayoad giih ajohr ke nying gihn nahg gene nyoge maa abiohgrwaal, bang gihn Dhaahr Juog unahg gihr gen. ");
INSERT INTO lwo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mihn cwihnyu nea wu ke yaahlo kedea uyug giih ajohro rogu maa urob giih nyooro rogu bang gihn nahgu jo'a. ");
INSERT INTO lwo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nea giih nu ke yugo rogu kea mihn cwihnyu bang gihn akoohg nud yihru Paar Juog. Kwaad giih nu ayug rogu ge kwaad giih anaa ayug rog yaa agamloohngjuog naa anudo umodho nyumu. ");
INSERT INTO lwo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ka dhiilu beehdo kii ngo keew nyoge roma ke rih melo nea kedh yi cam e ngo loge logo udoohnge law yi dhog. Nea melo abahnho e be rom ke yug law keehdo kedea e gihr nyinge tooro noono e ngo wed dom. Wu thiow beehn beehdo gihru kiin nyoge loge nyoge udoohng gene beeye. ");
INSERT INTO lwo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Doohngu ne lama umeenyu piny yihr nyoge. Geew maa ageer wiih good maalo rom kaa kano ubahnge ngo be niid ne? ");
INSERT INTO lwo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ngaa e ne ahb lama ucahge ngo ke wum piny kaa adiido? Ngahda ngo cub maalo ka me meenye piny cang yihr yaa ne wod ne? ");
INSERT INTO lwo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wa gihn nu thiow, wu ge meeny piny, beehn nyoge niid gene giihu ge beey ge atiihyu ni, noono ubeehn gene uwuor gene Juog ge Maalo.” ");
INSERT INTO lwo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Yaage keá paru kejea a abeehn wiih piny kan ne waar loohng Moaje wale ne waar giih apuohny yaa agamloohngjuoge. A kuu abeehno ne waar gen. A abeehno beere giih nu cang rog gen tiihy gene tiihyo wa kaa agweehg Juoge gen. ");
INSERT INTO lwo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Beehda gihn maa athiir e ne roba yihru. Maalo ge ke piny kare nud ugug gene, abea kare tooro uwaar gihn me thiin mee me ne yihdh loohnge. Kihd gihn me waar yihdh gen tooro ne weey weey nea padh giih yihdh loohnge cang ge ne pahdh kar gen wa kaa agweehg Juoge gen. ");
INSERT INTO lwo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kwaad dhaano muu uwaar loohng, keehd me nahge gihn me ne yahng e naa awaare kedea upuohnye gihn nu, e ngaan nu ka me ne yahng yi Dhaahr Juog e nuu ucub Juoge yihre. Abea kwaad ngaan utiihy giih ne yihdh loohng Juog ke kwaan gen cang kedea upuohnye dhe yoohn ka mag gen kii ngo, e ngaan nu ucub Juoge wong maalo ka me beer yi Dhaahr Juog. ");
INSERT INTO lwo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ngo dhiila kaa robo yihru kejea ngaa me rom cidho yi Dhaahr Juog kiinu tooro nea padh ngaa abiohgrwaal mare akaale wiih mar Paarijea maa mar yaa loohng Juog, yaa kob naa lum Juog amag gene ke cing apaar. ");
INSERT INTO lwo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Yaage anaa lihngu e arob yihr yaa acoon kejea, ‘Dhaano keá nahgi, nea ngaa nahg dhaano e ngo dhiil kaa maa ukedhe yi lug.’ ");
INSERT INTO lwo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Abea yi mar awaahn ni teeda teedo yihru kejea, nea kwaad ngaa ngeeny rih dhaano, e ngaan nu dhiil kaa kedh tien yaadh ukihme. E thiow kwaad ngaan koohbo yihr dhaano kejea, ‘Yih adooro’ e mar ngude uyoade bang yaa lug. Abea nea ngaa yeny dhaano kejea, ‘Yih dhaano now,’ kar bodhe ubahnge ngo be thoohr Paar Maaj utooro.” ");
INSERT INTO lwo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Thiow nea yih daahd ucii kar lam ne cub gihri me beer yihr Juog, abea apari kejea ater nud kiinu ke ngaa moogo, kea wii gihri noono piny tudi, ");
INSERT INTO lwo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","udoogi bang ngaan nu udoohru keehde. Nea wu adoohr arumo kea duui uyoadi gihri ge daahdi ke cubo yihr Juog ukweehri ngo. ");
INSERT INTO lwo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Thiow mag gom keehd ngaa amag yihn kaano caahdhu e wu caa yi lug keehd en beere yih be kedhe nyum ruohdh ubeehn ruohdhe ucub gene yihn yihr buuliij ne toaw yi thijin. ");
INSERT INTO lwo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Athiir e ne roba yihri kejea, kar beehni oogo tooro keehdo, nea padh giih akihm yihri ge ne dhiili ke cub piny utoor gihn me doohng oogo. ");
INSERT INTO lwo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Yaage, beehde ngahyu kejea anaa apuohny naa, ‘Ciih ngaa moogo keá kaabi.’ ");
INSERT INTO lwo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Abea yi mar awaahn ni roba robo yihru kejea, nea cwihnyi ayuohd rih dhaago, e adoohng wa tien dhaar nu amagi. ");
INSERT INTO lwo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nea wong kwiihyi e ne meehg yihn yug adhemuohm, kea oohl ngo oogo uthoohri ngo dom. Bang gihn ngo beer urwaahny goan kuohmi, yihr man thoohr yihn Paar Maaj ke kuohmi ne roang roang. ");
INSERT INTO lwo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nea cing kwiihyi e ne meehg yihn yug adhemuohm, kea ngul ngo oogo uthoohri ngo dom. Bang gihn ngo beer urwaahny goan kuohmi, yihr man cidhi Paar Maaj ke kuohmi ne roang roang. ");
INSERT INTO lwo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Yaage, anaa apuohny yihr nyoge kejea, ‘Ngaa pahy ke ciihe, kea dhiile wargahng paah ke kahl oogo yihr dhaago.’ ");
INSERT INTO lwo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Abea yi mar awaahn ni, roba robo yihru kejea, keá ngaa riem ciihe now nea padh kaab e naa kaab ngaa mooge ngo. Nea ngaa riem ciihe ke nying luube mooge me padh kaab, e ngaa nu e naa ameehg ngo doohng wa ajaba. Thiow ngaan nyuom dhaar nu, e ngo beehdo kaa ciih ngaa moogo. ");
INSERT INTO lwo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Yaage, ngo alihngu kejea anaa ateed yihr yaa coon naa, ‘Gihri maa ateedi ukuohngi rihi ke nyinge keá piem keehdo. Abea dhiil cuungo yi gihn nu akuohngi rihi ke nyinge utiihyi ngo yihr Juog.’ ");
INSERT INTO lwo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","“Abea yi mar awaahn ni roba robo yihru kejea, keá ngaa tum ngo kejea ree kuohnge kuohngo ke nying gihn me daahde ke yugo. Ree keá kuohnge ke Juog kedea ke nying Paar Maalo. Bang gihn Maalo beehda koom Juog. Thiow ree keá kuohnge ke piny, bang gihn piny beehda upahm Juog ne cube tiene wiihe. Maa thiow ree keá kuohnge ke nying geen Jeruucalem, bang gihn beehda e naa geen Deabid Ruohdh Duohng ni. ");
INSERT INTO lwo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Keá ngaan tum ngo ukuohnge ree ke wiihe, bang gihn kare tooro yihre uyuge yiehno acielo yi wiihe ubuure wale uyuge ngo udoohnge col. ");
INSERT INTO lwo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Adiehj dhaano nahge, ‘Ayiih kedea gahng.’ Kwaad lubo me dog ke jwaa wiih lum nu ngo beehn ke bang atiihb ukeehg. ");
INSERT INTO lwo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Yaage, ngahyu kejea anaa arob naa, ‘Nea ngaa tooy wong dhaano e wonge ke tooyo thiow, e ngaa toar leehj dhaano e leehye ke toar thiow.’ ");
INSERT INTO lwo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Abea awaahn ni roba robo yihru kejea dhaano gihn raaj naa atiihy ree ngo keá coale. Me neehn nea yih dhoohng ngaa mooge dhoohngo yi thaahng kwiihyi kea log caami yihre. ");
INSERT INTO lwo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Thiow, nea ngaa moogo daahd yihn ke kedh yi lug, bang ukaabe athoohr gihri, kea mad melaayo yihre thiow. ");
INSERT INTO lwo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nea ujaadya yih amage ne tiehd giihe ne ngol good, kea bari keehde ungoli bar thiow. ");
INSERT INTO lwo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nea dhaano yih peehnye peehnyo ke gihr nyepiny kea cub ngo yihre. Thiow kwaad ngaa me cej amihdho bangi, kea cub ngo, yih keá kweer.” ");
INSERT INTO lwo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Yaage, ngahyu kejea anaa arob naa, ‘Nhyaar wadu umaani ngad mahni.’ ");
INSERT INTO lwo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","“Abea awaahn ni roba robo yihru kejea nhyaaru jo mahnu kedea kwayu Juog thiow ke nying yaa bang wun beere Juog cwihnye duue ke caahn rog gen. ");
INSERT INTO lwo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kaano e wu udoohng ne nyethen Juog Wuru ge Maalo ni, bang gihn Juog e ne meehg cahng lier wudh nyoge cang, jo reje kedea jo beeye. E ne oohr kodh yihdh puohdh nyoge cang, ngaa me raaj maa ngaa me beer. ");
INSERT INTO lwo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kwaad gihn me beer me yoadu tooro bang Juog nea wu nhyaar yaa nhyaar wun cog. Keehd yaa reje ni, ge jwaar cuol yihr ukuuma, ngahda yaa nhyaar gen ge nhyaar gene nhyaaro thiow? ");
INSERT INTO lwo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yaa reje uyoohmu kaa gihn nea wu baahb ne maahdh yaa nhyaaru cog? Keehd yaa kwihj Juog ngahda ge baahb rog gen ke maahdho? ");
INSERT INTO lwo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dhiilu beehdo ne nyoge me beeye nyum Juog, bang gihn Juog Wuru ge ne Maalo ni beer keter ke nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Cubu wudhu piny beere giih beeye ge tiihyu yihr Juog, ge be yugu bang uleej nyoge wun nea wu ke niido e ge tiihyu tiihyo. Bang gihn ne yug gihn me beer yihr Juog ke nying leej e akoohg me yoadu bang Juog Wuru ge Maalo ngo tooro. ");
INSERT INTO lwo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Nea ngaa maa angoohng daahdu kaa muojo, e ngo keá muoju ne nyoadh rogu yihr nyoge kejea ngaa maa angoohng amuoju. Beehda yaa waane, ge ne yug kwaad giih nu ke bang yihdh kuohn amaade maa ke bang yihdh yiehdhe beere ge ke leeyo. Athiir e ne teeda yihru kejea leej gihn daahd gene ke cwihny gen e naa koog mar gen ne yoad gene bang nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Abea nea wu daahde ucubu gihr kony maru yihr ngaa maa angoohng, e kea yugu ngo ke dhe yooh me keehd cing caam e gihn cub ke cing kwiihj kwihye. ");
INSERT INTO lwo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Noono e gihn acubu kuu aniid nyoge mooge, abea unahg Juog Wuru ge ngahy dhe yoohn ka muoj nyoge ke piny kii ngo e keede cog, e nuu ucub gihn kooge wun keehde. ");
INSERT INTO lwo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nea wu ukwahyo, rogu keá yugu neehn mar yaa waane ge nyoadh rog gen nea ge ukwahyo. Bang gihn kwaad yaa nu ge kwahyo e ge ucuungo yihdh wuud amaad kedea ke bang yihdh yiehdhe ka me niid gen e ge ukwahyo. Athiir e ne teeda yihru, kejea gihn moogo tooro me cahg gene ke yoado, bang gihn koog mar gen ayoad gene bang nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Abea nea wu daahde ukwayu Juog, kea aay dhaane ucea kare keede ne kway Juog, ge beehda Juog me be niid dhaane. Noono e Juog dhaano ukooge ke nying giihe naa atiihye kare e keede e ge kuu aniid nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nea dhaano uthubo ke kwaj Juog arumo, e ngo keá piih ne ber kwaj acielo tiel me thoohdh wa mar yaa kuu ayiiho. Yaa kuu ayiiho mar gen cuohn gene kejea ber kwaj tiel me thoohdh e ne meehg Juog lihng kwaj gihr gen. ");
INSERT INTO lwo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dhe yoohn kway gen noono keá ngooru ne weey weey. Bang gihn Juog Wuru kwaad giih daahdu ke cwihnyu ge ngahye e wu poohd kuu athubo ke kwaj. ");
INSERT INTO lwo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Nea wu ukwahyo yihr Juog kea kwahyu ke wa gihn, ‘Wur wan ne Maalo, nyingi ke wuoro. ");
INSERT INTO lwo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Beehn ne Ruohdh wan. Mari ke yugo Paar Maalo kedea wiih piny thiow. ");
INSERT INTO lwo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gihn me cam wane tihn, cub ngo yihr wan tihn noono ni. ");
INSERT INTO lwo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Wii anyoohne piny yihr wan. Neehn ma wii wane giih anyoohne piny yihr nyoge thiow. ");
INSERT INTO lwo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Wa keá meehg pahdho yihdh giih utum. Abea lony wan oogo yi gihn me raaj.’ ");
INSERT INTO lwo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Bang gihn nea gihn maa atiihy raaj rihi wii ke piny yihr nyoge mooge, e Juog Wuru ge Maalo ni, kwaad gihn raaj yugi ree ni, wiie ke piny thiow yihri. ");
INSERT INTO lwo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Abea nea lubo be wii ke piny yihr nyoge mooge, e Juog Wuru kwaad giih reje atiihyi ree ni, ge be wiie piny thiow yihri. ");
INSERT INTO lwo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nea wu ukweehro ke cam ke nying kway Juog kedea tiihy giihe, e nyingu keá jweehnu, wa kwaad mar yaa waane. Bang gihn yaa waane nying gen jweehn gene jweehno uyug gene rog gen ne wadhraa beere ge ke niido ne nyoge me kuu acahmo maa anahg kahje. Athiir e ne dhiila ke teedo yihru kejea leej, e koog gihn adaahd gene ke cwihny gen bang nyoge, ngo ayoad gene. ");
INSERT INTO lwo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Abea nea wu daahd kweehr kejea wu be cahmo ke nying kwaj Juog, kea beehn dhaane luoge wonge beer mee uwiihre ke mow ");
INSERT INTO lwo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","beere kwihj nyoge kejea ngo ukweehro ke cam. Noono unahge Juog Wuru ge be niid dhaane e nuu ngahy ngo kejea wu ukweehro kedea ukooge wun. ");
INSERT INTO lwo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Giih lonyo ge keá cong dhaane ukane gen upiny kan. Bang gihn ge raany biihe raanyo maa mooge ge ukeadh, thiow yaa kahw ge nud me kwal gen. ");
INSERT INTO lwo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Abea beehn dhaane cube wiihe ne kan giih lonyo ke Paar Maalo ka toor biih maa keadh kedea jo kahwe yea. ");
INSERT INTO lwo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bang gihn ka ne giih lony dhaane yea e naa ka beed aduune. ");
INSERT INTO lwo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Wong e naa gihn me wa lama me meeny kuohm. Nea dhaano wonge kwel kedea cwihnye cang bang lum Juog, e kuohme thiow ree meenye meenyo ke kare cang udoohnge ne cal cal. ");
INSERT INTO lwo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Abea nea wong dhaano col, e keehd kuohme cang udoohng col mee. Abea gihn me room ke con aduun dhaano tooro, bang gihn nea aduun dhaano col e gihn me kaal wiih con nu tooro. ");
INSERT INTO lwo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kare tooro utiihy dhaane yihr nyoge ariow ke cwihnye acielo ne cohg. Bang gihn dhaano acielo kiin gen e nuu unhyaare kedea umaane ngaa moogo. Wale dhaano acielo e ne lum ngo wuore kedea ukweere ke wuor lum ngaa moogo. Wa gihn nu thiow kare tooro yihr dhaano unhyaare Juog kedea giih lonyo ke cwihnye acielo muu uroomo ne tog. ");
INSERT INTO lwo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“E naa gihn roba ngo yihru kejea wu keá diero ke wahyu ke nying giih camu kedea giih maadhu wale ke nying waare giih ngaabu. Nea kare ne cohg, ngahda e wahy dhaano utaahngo wiihe ne maalo yihr cam ne? Kedea ngahda kuohm dhaano utaahngo e ne wiihe ne maalo yihr waaro ge ngaab ne? ");
INSERT INTO lwo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Maanyu winy ge paahr ke maalo do! Koohdhe me piidh gene tooro kedea giih me kaj gene tooro maa dune me peg gene tooro. Abea ngahda Juog Wuru ge Maalo ni, e naa ngaa miihdh gen ne? Ngahda kuowo maru wiihe ne maalo yihr mar gen ne? ");
INSERT INTO lwo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Keehd me nahgu rogu ke diero, e ngaa kiinu e ne rom rune ke jwaa beere be laar thoo? ");
INSERT INTO lwo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Gihn e ne nahg diere wun ke nying waare me ngaabu? Maahnyu kaa doong thiiwe yihdh puohdh kii ngo! Ge be tiihyo maa waare me cwaahj gene tooro. ");
INSERT INTO lwo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Abea roba robo yihru kejea keehd Caloamon ke buur ngude yi deeh ngaab wuohbo gihre naa anaa ngahbe e kuu anaa angahbo keehd ngaab gihn angaab Juoge thiiw acielo kiin thiiwe cang kii ngo. ");
INSERT INTO lwo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Beehda Juog e naa aruug lum yi puohdho wa gihn nu. Abea lumo beehda gihn me nea tihn e ngo nii puohdho, abea nea keroo e utalo, uwaange. Wudhu paru paro kejea uriehny yihr Juog ungaabe wun ke waare ne? Gihn e thiin yiiho gihru wa maano! ");
INSERT INTO lwo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Wu keá kwaya diero urubo kejea, ‘Kee e nuu uyoad wane cam yea tihn? Kee e nuu umahdh wane yea tihn? Waare me ngaab wane ge uyoad wane kee?’ ");
INSERT INTO lwo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Giih nu ge naa kwaad giih cub yaa kuu ayiiho cwihny gen rog gen. Juog Wuru ge maalo, ngahye kejea giih nu cang ge daahdu daahdo. ");
INSERT INTO lwo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ne maano cubu cwihnyu yihdh giih Dhaahr Juog maa giih daahde kejea tiihyu gen. Noono arumo e kwaad muu anow ge ucube yihru beehd. ");
INSERT INTO lwo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Wu keá diero ke nying gihr keroo, bang gihn gihr keroo ree ucube e keede. Cahng man ne keede. Giih udieru keehd gen keroo ge keá madu yihdh muu cahng tihn. ");
INSERT INTO lwo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Dhaano keá kihmi beere Juog yih be kihme. ");
INSERT INTO lwo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Juog yih ukihme kaa dhe yoohn kihmi nyoge kii ngo. Unahg loohng anaa akihmi nyoge keehde, e nuu ukihm yihn. ");
INSERT INTO lwo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Beehda ater gihn ge kobi nye weehlo gihn thiin apahdh yi wong wadu ni e ne niidi ukwihyi deeh mari ge nii wongi ni! ");
INSERT INTO lwo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Gihn e ne ngahmi ke nyinge adhaahr urubi yihr wadu kejea, ‘Beeh koda nye weehlo gihn apahdh yi wongi oogo,’ abea deeh mari nii wongi? ");
INSERT INTO lwo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kuong deeh mari ge duohng ke kahl oogo yi wongi, batiene e mar wadu ge thiin niidi niido ukahli ngo oogo. Nye ngad waane, dhaano keá cayi ke nying awuohj maa atiihye abea deeh awuohj mari ge duohng wiihi awul ree. ");
INSERT INTO lwo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Gihri me beer keá cubi yihr goohy kedea kwaad gihn me beer me wa demaro wale me wa tiiy ge keá thoohri nyum kudhruue bang gihn ge nyon gene ke piny kedea batiene e ge taahny rihi. Nea maano e adiehj yea lum Juog keá robi yihr nyoge me ngahyi kejea ngo buu ulihng gene. ");
INSERT INTO lwo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nea yih ukwahyo keehd gihr nyepiny e gihn ngo ke cubo yihri. Kwaad gihn daahdi, e ngo dhiili kaa yoado. Thiow nea dhe wod atuongi, e ke yabo yihri. ");
INSERT INTO lwo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bang gihn kwaad ngaa kwahyo e gihn akwaye ke cubo yihre, e ngaa daahd, e gihn daahde ngo dhiile kaa yoado. E ngaa tuong dhe wod, e dhe wod ke yabo yihre. ");
INSERT INTO lwo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ngaa kiinu do, nea nyethiine ukwahyo yihre keehd cam, e cub leelo yihre? ");
INSERT INTO lwo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","E nea nyethiine ukwahyo ke reehyo, e cub thuohl yihre? ");
INSERT INTO lwo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Beer nea wu ge beehda nyoge me reje kare nud yihru umuuyu keehd giih me beeye yihr nyethenu, maa Juog Wuru ge Maalo ni, ngo ukweer ke cub amahr giih me beeye yihr yaa kwahyo yihre? ");
INSERT INTO lwo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kwaad gihn daahd dhaane ke cwihnye kejea yug nyoge mooge ngo yihre, tiihye kwaad gihn nu thiow yihr nyoge. Gihn e naa yi meehn loohng Moaje kedea muu arob yaa agamloohngjuoge. ");
INSERT INTO lwo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Cidhu kaa dhe yoohn diiny, bang gihn yoohn rwaahny dhaano ukedhe ngo ka me raaj beehda dhe wod me laaj kedea nong. Dhe yoohn nu e naa dhe yoohn paar maaj ge cidh nyoge me thoohdhe kii ngo ne loony loony. ");
INSERT INTO lwo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Abea dhe yoohn kedh nyoge kar kuowo me beer ngo diiny keter. Beehda nyoge me noog mee ge ne rom cidho kii ngo. ");
INSERT INTO lwo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Yabu nyingu, ucubu wudhu piny beer mee ne cohg ke nying giih tiihy yaa ucahbe ge rubo kejea ge agamloohngjuog. Ge beehn bangu e rog ge alwaay gene piny, uniidu gen naa abeehle me wa roohme, abea ka gihn nii yihdh gen room kaa urude. ");
INSERT INTO lwo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ge ungeyu kaa giih tiihy gene. Ka me beehn nyoge upon gene nyethen akanyo wiih aduohng nud ne? Wale nyethen dhuuro ge ke pono wiih alwii ");
INSERT INTO lwo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Wa kwaad kaano acaala nu, kwaad yaadh me beer nyuol nyethen me cam, e kwaad yaadh me raaj nyuol nyethen me be cam. ");
INSERT INTO lwo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yaadh me cam be nyuol ke nyethiin me be cam kedea yaadh me raaj be nyuol ke nyethiin me cam. ");
INSERT INTO lwo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nea wa gihn nu, e kwaad yaadh gihn nyuol keehd nyethen me be cam, dhiil kaa ngod piny uthoohre yi maaj ne waang. ");
INSERT INTO lwo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Wa gihn nu e naa ka ungeyu yaa ucahb ke dhe yoohn ka tiihy gene kii ngo. ");
INSERT INTO lwo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Padh kwaad ngaan cuohn an now kejea, ‘Ruohdh,’ e nuu uci Paar Juog. Abea yaa cidh Paar Juog ge naa yaa tiihj kwaad gihn daahd Juog Wuru ge Maalo ni. ");
INSERT INTO lwo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cahng ubeehn Juoge ne lug arumo, e nyoge me thoohdh ge urubo yihra, ‘Ruohdh, ngahda nyoge anaa puohny wane ke lum Juog e wa rob nyingi ne? Kedea atiihb reje ge ariem wane oogo rog nyoge e wa rob nyingi ne? Maa kwaad giih me doong me gaahy nyoge ge kuu anaa ayug wane e wa rob nyingi ne?’ ");
INSERT INTO lwo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kaano arumo e unahg an nuu ubeehr ngo yihr gen e gihn me cahga ke kano tooro kejea, ‘Aayu oogo buuda! Coohru rogo oogo kun ca! Wu nyoge maa yaa adhemuohme, wu kwihya ne weey weey!’ ");
INSERT INTO lwo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Noono ngaa lihng luuba noon ni kedea utiihye ke gen e ngo uroomo keehd nyin me cwihnye nud maa ageer wode yi piny good. ");
INSERT INTO lwo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Naa abeehn kodhe ucwiie upahng nahme, ubeehn deeh yamo me teege umede wod, e wod kuu apahdho, bang gihn ngo ageer wiih leelo. ");
INSERT INTO lwo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Abea kwaad ngaa lihng luuba noon ni kedea ubahnge ge be mage yi cwihnye beer mee e ngo uroomo ke nyin me cwihnye tooro maa ageer wode yi kuohyo. ");
INSERT INTO lwo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kodh yamo e caa ne cwii, upahng nahme e wod ake pahdho ne buohb!” ");
INSERT INTO lwo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Naa agooy Jeacuue wudh luube giihe piny, e amahr yaa anaa amahdo ge ake gaahy, ke dhe yoohn apuohny Jeacuue kii ngo, ");
INSERT INTO lwo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","bang gihn apuohnyo wa dhaano me yihre ne teeo me wa en naa acub loohng Juog giih puohny ke deeh kaa acoon. Ngo kuu apuohnyo wa mar yaa loohng Juog giih gen. ");
INSERT INTO lwo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kaa aduu Jeacuue piny ke wiih ka thoohny, e amahr akuud nyoge me thoohdh mee ge ake caahdho ke batiene. ");
INSERT INTO lwo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kaano e ngaa me ree ne dhoobo abeehn bange, maa arunge cunge piny ne wuor ngo. Naa arunge cunge piny e arubo yihr Jeacuu kobe, “Ruohdh, nea cwihnyi ne bange, e kea yug kuohma udoohnge kwel.” ");
INSERT INTO lwo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kaano e Jeacuu cinge arwaage bang ngo maa agweele nyin kedea urube kea, “Cwihnya ne bange! Beehn kuohmi doohnge kwel!” Nye wong kaano e kuohme ake doohng kwel. ");
INSERT INTO lwo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Maa rob Jeacuue ngo yihre kea, “Lihng gihn roba. Gihn ayug ree rihi awaahn ni kan ngo keá waayi yihr ngaa moogo. Abea aayi awaahn ni ucii ne nyoadh rihi yihr ngad lam giih kweehr bang umaanye kuohmi. Nea kuohmi amaanye, kea yug giih kweehr wa kaa anaa arob loohng Moaje ngo bang ne nyoadh ngo yihr nyoge kejea dhoobo tooro rihi.” ");
INSERT INTO lwo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Naa abeehn Jeacuue Kaparnaam arumo e jaabidh abeehn bange ukwaye wonge kea, ");
INSERT INTO lwo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ruohdh! Kony an! Kadaahm gihra ngo ne piny kaa atwaany me ledh. Kar waahdh ke ngude ngo tooro yihre ne weey weey bang gihn ngo abaahl.” ");
INSERT INTO lwo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Maa abeehr Jeacuue ngo yihre kea, “Beer cidho tiehd ke yihn beere ngo caa ke ne thiehdho.” ");
INSERT INTO lwo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Maa arub jaabidhe yihr Jeacuu kea, “Ruohdh! A beehda ngaa ucii paara! Rob lumi uaay atwaany kadaahm gihra. ");
INSERT INTO lwo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","A ge niidi kan, a beehda ngaa me duohng nyum acaakere kedea nud ke nyoge me doonge nyuma. Nea maano e lum roba ngo dhiil gene kaa tiihyo. Nea a urubo kejea beehn dhaane e ngo ubeehno, aay dhaane e ngo uaay. Thiow nea a urubo yihr ubaahnga kejea tiihy gihn e gihn ngo tiihye tiihyo.” ");
INSERT INTO lwo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Naa alihng Jeacuue lum ni arob nyine, e ngo ake cwaahng ugaahye ne cohg maa arobe ngo yihr nyoge ge anaa awaahdo ke batiene kea, “Jo wan! Athiir e ne teeda yihru. Kwaad yiiho me duohng me teeg wa gihr ngaan padh Ujudea, kaa akuong ke yoado keew yaa Yijarael. ");
INSERT INTO lwo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Thiow ngo dhiila kaa robo yihru, kejea nyoge mooge me padh Judea me thoohdh ge uwaahd ke yoohn kun moohl cahng kii ngo maa ke yoohn kun kwaar cahnge piny kii ngo. Jo nu, ge upiih tiehd keehd Abraahm maa Yijaag kedea Jeakob yi Dhaahr Juog Paar Maalo kedea umag Juoge gen neehn joe. ");
INSERT INTO lwo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Abea Judea yaa anaa angahj kejea ge nuu ubeehdo yi Dhaahr Juog, ge buu ubeehdo yi ngo. Ge ujwang oogo ne beehdo yi muudho ne lalo ke lan ngoohng wong e lag gen kaany gene kaanyo ke nying raahm.” ");
INSERT INTO lwo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Noono urob Jeacuue ngo yihr jaabidh kea, “Cidhi! Neehn kaano ayiihi ngo kejea rom thiehdho yihra ke kan, ree uyuge wa kaano ayiihi ngo.” Ke wong kaano, e atwaany gihr baahng ake aay ree kii nyenij. ");
INSERT INTO lwo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Naa abeehn gene paar ge Piihter, e Jeacuu keehd jo waahdhe, miih ciih Piihter ayuud gene e ngo tuu wod ke jwaahy. ");
INSERT INTO lwo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Noono umag Jeacuue cinge beere ngo thiehdh thiehdho. Kaano e atwaany aguo aay ree kedea upiihe ne goong ge Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ke wong thiehno e nyoge ake thubo ke kahl yaa atwaanye bang Jeacuu. Nyoge me thoohdh keew gen rog gen anaa atiihb ukeehg. Gihn nu e Jeacuu arubo yihr atiihb nu ke lubo maa ariem gen. Yaa atwaany anaa akahl bange ge athiehdhe cang. ");
INSERT INTO lwo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jeacuu giih ge atiihye beere kwaad gihn anaa arob Juoge ke nying Ngad Boadh nyoge ke leeb Yicaaya agamloohngjuog pahdh kare naa athiir. Anaa akob Juoge kea, “Alwaa atwaanye giiho ke kar gen cang, ge atihnge wiihe.” ");
INSERT INTO lwo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kaa aniid Jeacuue amahr akuud nyoge athoohnho keter, e ngo arobe yihr jo waahdhe kejea ngud gene loo baaw. ");
INSERT INTO lwo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nye kaano, e naa abeehn ngad Puohny loohnge bang Jeacuu maa arube kea, “Ngad Puohny, kwaad kuohn caadhi a daahd ucaahdha ke yihn.” ");
INSERT INTO lwo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","E ngo aduog Jeacuue duogo yihre kea, “Thoohe yihr gen ne kuohn beed gene maa winy yihr gen ne wuude me beed gene. Abea a ge adoohng ne dhaano utaahngo yihra tooro ka me piehla thaahnga yea.” ");
INSERT INTO lwo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","E dhaano acielo kiin yaa waahdh Jeacuu ake rubo kea, “Ruohdh, wura athow meehga kuong ci ne koany ngo.” ");
INSERT INTO lwo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kob Jeacuue yihre kea, “Beehn ke batiena. Wii yaa acub wudh gen yihdh giih thunge ukoany gene yaa athow.” ");
INSERT INTO lwo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kaano arumo e Jeacuu apaahr yih baabuur. Maa abeehn jo waahdhe thiow ke batiene yih baabuur ne kiiw ngo. ");
INSERT INTO lwo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Naa awahdh gene yi diehr naam duohng e deeh yam giir me teeg ree atihnge tihngo upude baabuur ke olo. Abea ge acoohd deeh giire e Jeacuu wonge kaa anaa akwal niine. ");
INSERT INTO lwo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Gihn nu, e jo waahdhe ge arihng kaa abud Jeacuue yea ne tahng ngo kob gene, “Ruohdh, doohd wan! Wa amud!” ");
INSERT INTO lwo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kaano e Jeacuu arubo yihr gen kea, “Gihn, e mag lwaahre wun? Wu ka beehda nyoge me yiiho gihru thiin wa gihn ne!” Noono uyedhe maalo arumo ucuowe yamo cuowo, ucuung yame ne dihl. ");
INSERT INTO lwo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Utud jo waahdhe kedea ucwaahng gene maa arub gene ke rog gen e ge upeehyo kob gene, “Kwaad ngad gihn! Keehd yamo maa naam duohng lum ngo lihng gene lihngo!” ");
INSERT INTO lwo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Naa angud Jeacuue loo baaw e abeehn yi piny nyoge me cuohn ne Gaadarean. Kaano e aroohmo ke nyoge ariow e ge beehn oogo kaa wudh leehde ka beed gene. Nyoge me rog gen naa atiihb ukeehg me ge taahny rog nyoge. Ngaa me na caahdh kii yoohn nu tooro bang gihn nyoge atud uwii yooh yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Noono maa akwaag gene kob gene, “Waahd Juog! Wii wan, gihn me nweehd won tooro. Yih aguo moon piny ne joohr wan ne?” ");
INSERT INTO lwo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Abea kudhruue maa anaa ake kwaa ge anudo ka me cahng. ");
INSERT INTO lwo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Noono maa akwaj gene wong Jeacuu kejea nea ge rieme ke oogo kea rieme gen yihdh kudhruue. ");
INSERT INTO lwo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Maa ayiih Jeacuue ngo maa arieme gen yihdh kudhruue. Gihn nu e ge abeehn oogo umon gene yihdh kudhruue unahg kudhruue ke ne rudh ke ngweej, e ge loohn piny ke wiih good maa anahg gene thoadh yi naam duohng uthow gene. ");
INSERT INTO lwo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yaa anaa akwaag kudhruue naa aniid gene gihn ayug ree, e ge ake goohdo ke ngweej ne ci ne rob gihn ayug ree yi geew. Noono ukwaan gene gihn ayug ree rog atiihb ukeehg yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kaano e nyoge awaahd oogo ke bang yi geew, e ge beehn ne maany gihn ayug ree. Kaa awahnh gene kaa ane Jeacuue yea e wong Jeacuu akwaj gene kejea aaye oogo piny gen. ");
INSERT INTO lwo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Batiene arumo, e Jeacuu apaahr yi baabuur udoge caahn e ngo ngol baaw ne beehn Kaparnaam ka beede. ");
INSERT INTO lwo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Naa awahnhe e nyoge mooge ake beehno e ge kahl dhaano maa abab piny e ngo bien kaa belo. Kaa aniid Jeacuue kaa ayiih gene kii ngo, e arubo yihre kea, “Waahda, mag cwihnyi, adhemuohme giihi ge awii piny yihri.” ");
INSERT INTO lwo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kaa alihng yaa loohng Juoge gihn arob Jeacuue e ge ake ngoan ke cwihny gen kob gene, “Wa nyin wiihe arome ke Juog kea adhemuohme wiie ke piny yihr nyoge neehn mar Juog!” ");
INSERT INTO lwo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jeacuu ka gihn nii cwihny gen angeye maa apeehye kea, “Nye yaage, gihn e ngoanu giih me reje ke yaa aduunu! ");
INSERT INTO lwo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Maa aweehne e ne teeg ke tiihyo, ne rob ngo kejea, ‘Adhemuohme giihi ge awii piny yihri,’ wale ne rob ngo kejea, ‘Yedh maalo ucaahdhi?’ ");
INSERT INTO lwo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Awaahn a ge adoohng ne dhaano utaahngo, a utiihyo ke gihr nyepiny kedea uniidu ngo, gihn me be rom ree tiihyo yihr dhaano utaahngo ne nyoadh ngo yihru kedea ungahyu ngo kejea yihra ne tee wiih ngoom me wiia adhemuohme giih nyoge piny.” Kaano e dhee aloge ke bang nyin abab piny urube kea, “Aj maalo ukaabi belo gihri uci paajo.” ");
INSERT INTO lwo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Noono uaj nyine ke maalo ucea paajo. ");
INSERT INTO lwo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Naa aniid nyoge gihn ayug ree, e ge ake gaahy maa apiih gene ne puoj Juog ngaa cub kwaad tee me wa gihn nu yihr dhaano utaahngo. ");
INSERT INTO lwo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kaano e Jeacuu a'aay ne bar wong maalo ke waahdhe. Naa awahnhe kar yaa gwaaj cuol e ngaa me nyinge Matheewo aniide niido e ngo apiih ne gwaay cuol. Maa arob Jeacuue ngo yihre kea, “A daahd udoohngi ne ngad waahdha.” Maa ayedhe maalo uaaye tiehd ke Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Cahng man, e Jeacuu anaa paar Matheewo kaa agoonge yea. Nyoge me thoohdh mee ge anaa anudo tiehd keehd Jeacuu maa jo waahdhe. Yaa gwaaj cuol maa yaa adhemuohme ge cuohn Judea ne nyoge me reje, ge anudo thiow. Wudh gen anaa amad gene paar Matheewo kaano cang. ");
INSERT INTO lwo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bang gihn yaa Paarijea kwaad jo nu be nhyaar gene ubeehd gene kiin nyoge, e jo waahdh Jeacuu apeehny gene peehnyo kob gene, “Beehda ke nying gihn ge beehn ngad puohny gihru upiihe ka maa acielo ne cam keehd yaa gwaaj cuol kedea yaa adhemuohme?” ");
INSERT INTO lwo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Naa alihng Jeacuue ngo, e abeehre, “Padh yaa rog gen tooro atwaany ge ne daahd akiihm, abea beehda nyoge me tuu ge ne daahd akiihm. ");
INSERT INTO lwo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cidhu udaahdu yi lum gihn arob Juoge naa akoohbo kea, ‘A daahd ngaa me luu cwihnye caahn me wii lubo piny, a be daahd ngaan yug giih kweehr.’ A kuu abeehno kaa nying yaa koohbo kejea ge abiohgrwaale. A abeehno kaa nying yaa yiih ngo kejea ge yaa adhemuohm.” ");
INSERT INTO lwo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Cahng man thiow e jo waahdh Joon Ngad Luogwahy ge abeehn bang Jeacuu maa apeehny gene ngo kob gene, “Ke nying gihn do ge bahnge jo waahdh giihi cam be kweehr gene abea yaa Paarijea kedea wan cam kweehr wane kweehro ne wuor Juog?” ");
INSERT INTO lwo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Maa abeehr Jeacuue ngo yihr gen kea, “Ubeehra yihru kaa ucaale, e ngo caala ke rih ngaa maa atihng dhaago paajo. Kare nud umeehg yaa acuohn athiehge yi nyuohme kweehr cam abea athiehg nud bang gen ne? Abea cahng ukaab athiehg oogo bang gen e nuu ukweehr gene cam. ");
INSERT INTO lwo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Thiow, ngo uroma ke rih ucaale moogo me wa gihn. Padh kare udhahb dhaane waaro me nyaahn rih jwaahd waaro maa ayiej? Bang gihn nea waaro gihn nu ree cea ke ne juunyo e wong kaa adhahb ree cahge kaa jwaa? ");
INSERT INTO lwo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wale thiow ngo roma ke rih ucaale moogo me koohbo kejea dhaano koongo me poohd kuu uyaahnyo be pege yi keej maa acoon maa akuoj bang gihn koongo yea keej coohde coohdo, uwoj koonge oogo nea ngo utwag uyaahnye. Gihn me ne cohg beehda uyoad koongo me poohd kuu ayaahnyo, ukedhe yi keej me nyaahn beere koongo be rahny kedea keej yea be coohd.” ");
INSERT INTO lwo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kaano apoohde e Jeacuu urubo keehd nyoge nu, e Ujudea, me beehda ruohdh wod amaad gihr Judea abeehn bang Jeacuu. Gihn nu e cunge arung piny maa arube yihr Jeacuu kea, “Nyaara uthoo awaahn kan. Ngo awiia piny e ngo uluyo. Beehn uci ne cub cingi wiihe beere ngo ubodho.” ");
INSERT INTO lwo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Maa a'aj Jeacuue maalo keehd jo waahdhe ubuodhe batien nyin. ");
INSERT INTO lwo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kaano e dhaago me remo uwuur ree ke run apaar wong ariow e ngo be cuung abeehno ke ngahy Jeacuu maa agweele dhe athoohr gihr Jeacuu, ");
INSERT INTO lwo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","e urubo ke cwihnye kea, “Keehd me nahge dhe athoohr gihre e ne gweela, e remo ucuungo.” ");
INSERT INTO lwo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kaano e Jeacuu wiihe aloge ke bang dhaar ni umaahnye bang ngo maa akoohbe kea, “Mag cwihnyi nyaara! Yiiho mari yih aboadhe.” Kaano e remo ake cuungo. ");
INSERT INTO lwo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Naa awahnh ge Jeacuue paar ruohdh wod amaad e ge yuud nyoge uyuog kedea ugoohne giih thieng ge ke koadho ke nying thoo naa apahdh wihj. Naa angahy Jeacuue ngo kejea thoo uroomo wa niine e ake rubo: ");
INSERT INTO lwo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Aayu oogo kan, nyethiin kuu athow gihre beehda niine.” Naa a'aay gene e Jeacuu angier gene kejea gihn me ngahye tooro. ");
INSERT INTO lwo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Naa a'aay gene arumo, e Jeacuu acaa wod maa amage bad nyethiin kedea uyedh nyethiine maalo. ");
INSERT INTO lwo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wiihj gihn ayug ree paar ruohdh wod amaad, akeedho ke bang yea paajo ne raj. ");
INSERT INTO lwo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jeacuu acahg aay kaano ubare ke waahdhe. Abea yi waahdhe noono e nyoge ariow me nying gen acoor ge ake caahdho thiow e ge buodh batien Jeacuu kedea e ge ukwaago kob gene, “Kwaar Deabid, yeyi be ngeer yi ngoohng nying wan ne?” ");
INSERT INTO lwo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Naa awahnh Jeacuue paajo arumo, e ngo aci wod. Coohre giih thiow ge aci wod. Maa akob Jeacuue ngo yihr gen kea, “Ngo ayiihu ne cohg ke cwihnyu kejea kare nud yihra uthiehdha wun ne?” Maa ayiih gene ngo kob gene, “Ayiih! Ruohdh wa romi kaa thiehdho.” ");
INSERT INTO lwo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Gihn nu e nying gen agweel Jeacuue maa arube yihr gen kea, “Wa kwaad kaa ayiihu ngo kejea wu roma kaa thiehdho kea noono yuge ree wa kaa adaahdu.” ");
INSERT INTO lwo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ke wong kaano e nying gen anaa weehny, uniid gene piny. Kaano e angweel Jeacuue piny yihr gen teeg mee kea, “Gihn ayuga rogu keá robu yihr dhaano utaahngo.” ");
INSERT INTO lwo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Abea naa a'aay gene e ge ake cidho uteed gene gihn ayug Jeacuue rog gen ke bang yea paajo. ");
INSERT INTO lwo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nye kaano abeehn yaa ni athiehdh uaay gene nu, e ngaa maa amiing me kar rob tooro yihre ke nying gihn ree naa atiihb ukeehg akahl bange. ");
INSERT INTO lwo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Naa ariem Jeacuue atiihb ukeehg oogo rih nyin e ngo ake thubo ke rob beer mee. Gihn nu ucwaahng nyoge keter kob gene, “Kwaad gihn ree keá kuong ke tiihyo cahng acielo keew yaa Judea!” ");
INSERT INTO lwo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","E yaa Paarijea ge ake rubo ke piny yihr nyoge ke nying Jeacuu, kob gene, “Atiihb ukeehg rieme oogo kaa nying teeg gihn yoade bang ruohdh atiihb ukeehg.” ");
INSERT INTO lwo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Noono ucaahdh Jeacuue kedea e ngo wen yihdh miehr ke bang geedhe. Acaahdho e thiehdh kwaad atwaanye cang kedea e ngo puohny Ciig Beer ke bang yihdh wuud amaade. Ciig Beer ge rubo ke nying ka beehn Juoge uyuge nyoge udoohng gene ne joe. ");
INSERT INTO lwo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kaa aniid Jeacuue amahr akuud nyoge bange e yea angeer ke nying gen keter. Yea angeer bang gihn ge aniide wa kwaad amaahle me ngad kwaag gen tooro. ");
INSERT INTO lwo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Noono e Jeacuu arubo yihr jo waahdhe kea, “Tiihj puohny lum Juog yihr nyoge ngo adoohng teeg keter, adhaahr ngo uroma ke rih deeh puohdho me puur. Noono e daahd nyoge me thoohdh me tiihy giih acieg yi puohdho. ");
INSERT INTO lwo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nea wa gihn nu kea kwayu Juog, ge room ke ngad puohdho, umuoje wun keehd yaa tiihj me thoohdh ubeehn gene ne tiihj yi puohdho gihre.” ");
INSERT INTO lwo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kaano arumo e Jeacuu nyoge apaar wonge ariow kiin jo waahdhe ge acuohne bange, maa acube tee yihr gen. Tee me riem gene atiihb ukeehg oogo rog nyoge kedea tee me thiehdh gene kwaad atwaanye cang. ");
INSERT INTO lwo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nying jo oohr giih apaar wonge ariow naa akwany Jeacuue ge gen: Ngad umodho beehda Cimoane, me nying tuode Piihter kedea Andrya umen, Jeamij waahd Jebeade, keehd Joon umen. ");
INSERT INTO lwo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pihlihb ge ke Bartholomeao maa Thoamaj. Maa Matheewo ge anahg ngad gwaaj cuol. Jeamij waahd Alpaawo maa Thaadoj. ");
INSERT INTO lwo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Cimoan kedea Juudo Yijkaariod, ge anaa abeehn ne luom Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kaano e Jeacuu loohnge arobe yihr jo oohr kar ge apaar wonge ariow maa aoohre gen kobe, “Wu keá ci ne puohny yihdh geedhe giih padh geedh yaa Judea kedea yihdh geedhe giih yaa Camaarya. ");
INSERT INTO lwo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Cidhu ne puohny yaa Yijarael ge arwaahnyo ge akweer ke lum Juog. ");
INSERT INTO lwo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yi waahdhu noono caahdhu nahge ke Ciig Beer gihn ni en ne puohnyu. Adoohng e ka me cahng mee ubeehn Ruohdh Juoge wiih piny. ");
INSERT INTO lwo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Thiow thiehdhu nyoge me tuu maa yaa rog gen ne dhoobo maa meehgu nyoge maa athow cahro kedea riemu atiihb ukeehg oogo rog yaa amag gene. Wa kaano tiihyu giih nu yihr nyoge e gihn me daahdu ke nying gihn atiihyu tooro, e wu thiow cubu ge yihr nyoge neehn maano. ");
INSERT INTO lwo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Yi waahdhu noono caahdhu nu, wu keá piih ne daahd ngiihny me kaahnu yihdh mapade giihu. Ngaa keá kaahn wuor maa waaro. Kaahn dhaane ke muu ne ree cog kedea kihd ngaa keá kaahn aloadh. Giih nu ge keá yugu bang gihn yaa upuohnyu giih daahdu ge uyoadu bang gen. ");
INSERT INTO lwo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Yi geen toohngu yea kea peehnyu ke paar abiohgrwaal unahge ke kaano e ne beehdu yea yi nihn puohnyu Ciig Beer uwahdhe cahng uaayu. ");
INSERT INTO lwo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Abea yi beehnu paan nu kea kwayu Juog beere ge ubeehdo ke yoohm rog. ");
INSERT INTO lwo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nea yaa ne paan nu ge nyoge me beeye, e ge ubeehdo ke yoohm rog gen. Tooro, nea ge nyoge me reje, e gihn akwayu ke nying gen buu ucub Juoge. ");
INSERT INTO lwo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yaa kweer ke lor wun, wale yaa kweer ke lihng lumu keá wiiu gen. Abea yi aay aayu kea teengu ngoom kaano oogo yi tienu ne nyoadh ngo kejea nea gihn me yoad gen, e maru tooro yi ngo. ");
INSERT INTO lwo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Athiir e ne teeda yihru kejea giih teeg naa ayoad geedh Codom kedea Gomoarah cahng ukihm Juog ge uyoohd yi gihn uyoad yaa paan ukwihy wun ke loro. ");
INSERT INTO lwo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Maany kaa aoohra wun wa gihr nyethen roohme kiin urude. Kea noono nahgu nyoge me nyingu teeg wa mar thooh kedea nahgu nyoge me padh yaa agween. Wa kaano nahgu roohme, kea nahgu kwaad roohme me modh gihn me raaj. ");
INSERT INTO lwo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","18","“Wudhu keá thoohru piny now bang gihn wu ucub yi cing ruohdhe giih wuud amaade giih Judea ne kihmo kedea upuohd wun ke nying gihn nahgu nyoge maa aoohra kedea wu ukedh nyum ruohdhe kedea jaah ne kihmo ke nyinga. Kaano arumo e nuu udoohngu ne yaa rob leeba yihr yaa Judea kedea yaa padh Judea. ");
INSERT INTO lwo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Abea nea wu ke maa e wu keá diero ke ka ubeehru loohng kii ngo bang gihn Juog e nuu ucub kar beehr loohnge yihru. ");
INSERT INTO lwo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Luub urobu ge buu unahg luubu abea Wahy Juog ge beehda Wuru e nuu ucub giih urobu yi dhogu. ");
INSERT INTO lwo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Dhaano maa akweer ke luma, umen kedea nyethiine maa ayiih luma ge umaane uwahdhe ka uluome gen unahg gen. Thiow nyethiin maa akweer ke luma, wahn maa men naa ayiih luma ge umaane uwahdhe ka uluome gen unahg gen. ");
INSERT INTO lwo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wu thiow, wu umaan nyoge cang ke nyinga. Abea ngaan umag cwihnye teeg uwahdhe guge e ngaan nu e nuu uyoad boadh wahy. ");
INSERT INTO lwo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Geen yug giih ajohro rogu, kea wiiu ngo piny ucidhu geew moogo. Abea adiehj roba yihru e man: Wudh geedh Yijarael ge buu ukwanyu cang e a ge adoohng ne dhaano poohd kuu awahnho. ");
INSERT INTO lwo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Beeh peehnya wun do! Ngaan puohny, kare nud une wiihe maalo yihr ngaan puohny ngo ne? Wale baahng, kare nud une wiihe maalo yihr ngaa nahge baahng paare? ");
INSERT INTO lwo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ngaan puohny nea wiihe uroomo ke ngaa apuohny ngo, e cwihnye med kedea baahng nea wiihe uroomo ke ngaa nahge baahng paare e cwihny med. Nea a ge ngad puohny gihru e ne yieny gene kejea a beehda ruohdh atiihb ukeehg e cuohn ne Beeljebuul, nea unahg wun e gihn noono raaj e ne buu urob gene rogu? Nea maano kea ngahyu ngo kejea giih ajohro ge uyoadu neehn ka uyoada gen bang gihn wu beehda jo'a. ");
INSERT INTO lwo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nea neehn maano e wu keá tud yihr yaa maan wun ke nying gihn nahgu jo'a. Adiehj gihn nyoadh lum Juog ngo be rom ree kano, keehd me kwihye awaahn ni e ngo udhiil ke ngeyo wong maalo. ");
INSERT INTO lwo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Adiehj lum Juog naa aroba yihru karo keedo wale maa amuonga yihru cidhu ne teed ngo nyum nyoge beehde. ");
INSERT INTO lwo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Wu keá tud yihr dhaano utaahngo ge rom nahg kuohm cog abea wahy dhaano be rom ree naah yihre. Nahge ke Juog, e thoohr kuohm maa wahy Paar Maaj, e ne tudu yihre. ");
INSERT INTO lwo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ngahda adiid pure ariow ge ngeew kaa wong ryaal acielo cog ne? Abea keehd me yoohd ngiene e bekihd adiid puro acielo me thow e keede nea padh Juog e naa agweehg ngo. ");
INSERT INTO lwo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Keehd yiehy wudhu ke ngud gen, ge akwaan Juoge. ");
INSERT INTO lwo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nea wa gihn nu e wu keá diero kejea wu buu ukony Juoge, wu keá diero bang gihn keehd amahr adiid pure adiih e wudhu be rom Juoge ke gen. ");
INSERT INTO lwo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kwaad ngaa be tud ke rob ree nyum nyoge kejea ngo ngada, e a thiow a buu tud ke rob ngo yihr Wura ge ne Paar Maalo kejea ngo ngada. ");
INSERT INTO lwo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Abea kwaad ngaa kweer ke an nyum nyoge kejea ngo padh ngada e a ukweer ke en thiow nyum Wura ge ne Paar Maalo kejea ngo padh ngada. ");
INSERT INTO lwo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gihn abeehna ke nyinge upiny kan ngahyu ne? Wudhu aparu kejea a abeehno ne kahl doohr kiin nyoge wiih piny ne? Gahng! A abeehno ne kahl ater kiin yaa ayiih luma kedea yaa kuu ayiih luma. ");
INSERT INTO lwo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A abeehno ne, ‘Kahl ater kiin nyedhoohg maa ayiih luma kedea wahn kedea kiin nyaakow maa ayiih luma kedea men maa kiin nyekiihj maa ayiih luma kedea ciih waahde. ");
INSERT INTO lwo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yaa ater dhaano me raaj ubare ge unahg jo paare.’ ");
INSERT INTO lwo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ngaa nhyaar wahn wale men keraahyo uyoohme ka nhyaare an, e ngaan nu padh ngada. Ngaa nhyaar waahde wale nyaare keraahyo uyoohme ka nhyaare an, e ngaan nu padh ngada. ");
INSERT INTO lwo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ngaa kweer ke guum giih ajohro me nahge ke nyinga wa kwaad ka uguuma, e ngaan nu padh ngada. ");
INSERT INTO lwo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ngaa kweer ke thoo ke nyinga bang gihn daahde ukoare ree, e ngaan nu e nu uthow ne lihg lihgi bang gihn wahye ge uthow thiow. Ngaan be tud yi thoo ke nyinga bang gihn be daahd ukonye ree, e ngaan nu e ne buu uthow bang gihn wahye ge ukuow. ");
INSERT INTO lwo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kwaad ngaa lor wun ke med cwihny paare e ngo udoohng wa lor an. E kwaad ngaan lor an ke med cwihny paare ngo udoohng wa lor ngaan aoohr an. ");
INSERT INTO lwo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kwaad ngaan lor ngaan aoohr Juog ke med cwihny paare bang gihn Juog e naa aoohr ngo, e ngaan nu koohg gihn cub yihr ngaa aoohr ke cubo yihre thiow. E kwaad ngaan alor abiohgrwaal ke med cwihnye ke nying gihn nahge abiohgrwaal, e ngaan nu akoohg gihn cub yihr abiohgrwaal ke cubo yihre thiow. ");
INSERT INTO lwo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Lihngu lum ni beer mee! Kedea utiihyu keehde. Kwaad ngaa tiihy gihn me ne yahng wa cub piih yihr ngaa thiin kiin jo'a ke nying gihn nahge ngada, e ngaan nu koohg udhiil ke cubo yihre.” ");
INSERT INTO lwo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Naa athum Jeacuue ke rob yihr joe ge apaar wonge ariow e ngo a'aay ne ci ne puohny ke bang yihdh geedhe giih Gaalili. ");
INSERT INTO lwo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Giih beeye ge atiihy Ngad Boadh nyoge ge abeehn Joone ne lihngo e nii thijin. Gihn nu e joe ge aoohre ne peehny ngo ");
INSERT INTO lwo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nea en naa ngaa akob kejea ngo ubeehn wale padh en beere ge bar maalo ke koar ngaa akob naa ngo ubeehn. Naa apeehny gene Jeacuu ");
INSERT INTO lwo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","e beehre yihr gen kea, “Doogu bang Joon urobu gihn alihngu kedea gihn aniidu yihre. ");
INSERT INTO lwo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nyoge maa anaa acoor nying gen ayahbo yaa adwaany piny ge ucaahdho, yaa rog gen ne dhoobo, ge athiehdh uaay dhoobe oogo rog gen, nyoge maa amiing yihdh gen ayahbo ulihng gene, yaa athow ge acahr batien thoo kedea Ciig Beer ke puohnyo yihr yaa angoohng. ");
INSERT INTO lwo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Med cwihny me duohng yihr ngaa me cwihnye be diiw ke nyinga.” ");
INSERT INTO lwo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Naa a'aay yaa anaa aoohr Joone, e Jeacuu alog rob yihr amahr nyoge ke nying Joon kobe, “Ge anaa acidhu yi ukang wu anaa acaa ne maany gihn? Anahg ubeej me yahng yame yahngo? ");
INSERT INTO lwo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nea padh ubeej, e beehda gihn e naa acidhu ne maanye. Ngo anahg dhaano maa angahbo ke waare me ngien gen teeg? Bekihde! Yaa ngaab waare me ngien gen teeg ge beed yihdh miehy ruohdhe. ");
INSERT INTO lwo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Abea wu anaa acidho ne maany ngaa me ngihde? Wu acaa ne maany agamloohngjuoge ne? Ayiih, ngo beehda agamloohngjuog. Ateed gihn maa athiir yihru, Joon duohng rih agamloohngjuog. ");
INSERT INTO lwo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bang gihn anahg en naa arub Juoge ke nyinge kedea ugweed gihn arobe yi kitaab Juog naa, ‘Maany! Ngad wuohna uoohra wong maalo nyumi ne gwiir yooh yihri!’ ");
INSERT INTO lwo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Beeh roba gihn maa athiir yihru. Kiin yaa beed wiih ngoom, ngaa me rom wiihe ke Joon Ngad Luogwahy tooro. Abea keehd maano e ngaa thiin kiin yaa beed Paar Juog, e ngaan nu e ne wiihe ne maalo yihr Joon Ngad Luogwahy. ");
INSERT INTO lwo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ke wong cahng athub Ngad Luogwahye ke puohny uwahdhe cahng tihn, e Paar Juog adoohng e naa yi cing yaa bad kedea nyoge ci yea kaa bad. ");
INSERT INTO lwo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bang gihn yaa agamloohngjuog cang kedea loohnge giih Moaje giih arob gene ge gug rih Joon, ");
INSERT INTO lwo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","e naa gihn dhiilu luma ke yiiho kejea Joon e naa Eliija gihn akob naa ubeehn. ");
INSERT INTO lwo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nea ngaa yihdhe nud me lihngo, e kea lihnge. ");
INSERT INTO lwo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Wu yaa beed wiih piny awaahn ni, wu uroma kaa gihn? Wu uroma kaa nyethen me luohng luube ke rog gen kar tuoh kob gene, ");
INSERT INTO lwo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Cing wan apam wane beere cwihnyu umihno umielu maa akweeru kedea gumo agooj wane maa akweeru ke meehdo.’ ");
INSERT INTO lwo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kwaad giih nyethen ge ne yugu. Maanyu Joon naa abeehne ke puohnye e beehdo e ngaa me cam baahny kedea giih maadh wa kuong ge be maadhe. Bang gihn giih nu ge be maadhe, e ngo akobu kejea beehde atiihb ukeehg ge naa amag ngo. ");
INSERT INTO lwo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A, ge adoohng ne dhaano, a abeehno ke puohny mara e keew caame maa kuong ge be kwanya maa akoohbu kejea a ngaa maa awaahdh yi cam kedea maadh koongo. Wu arubo thiow kejea gom maga kaa yaa gwaaj cuol kedea nyoge maa awaadh. Abea roba robo yihru kejea dhe yoohn adiehj tiihy Juoge keehde niid ke rog yaae ge yiih tiihye.” ");
INSERT INTO lwo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Batiene e Jeacuu athubo ke yaahl yaa beed wudh geedh anaa ayuge amahr giih me gaahy nyoge yihdh gen. Ge ayaahle bang gihn keehd maa aniid gene giih teeg gaahy nyoge naa atiihye e yaa ni anyoohne giih gen naa atiihy gene rih Juog ge kuu amaan gene. Noono maa awuu Jeacuue gen kobe, ");
INSERT INTO lwo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Beehda kwaad gihn ge raaj wa gihn ge apahdh wudhu, wu yaa Korajin kedea Bedhceada! Alwaa giih teeg ge gaahy nyoge ge ayug yihdh geedhu ngahda ngweehn me ne yug gen yihdh geedh yaa Taayr kedea Ciihdoan, bang gihn yaa nu ka moogo e cwihny gen ne rahnyo rog anyoohne giih gen naa ayug gene rih Juog. Thiow ge ne piih uthur e cuole angaab gene. ");
INSERT INTO lwo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Abea yaage! Ngahyu ngo kejea Cahng Lug Juog e yaa geen Taayr kedea yaa geen Ciihdoan ge ungwaahn Juoge yi lug gihre nu uluge gen. Abea wun, Juog lug gihre uteeg rogu keter. ");
INSERT INTO lwo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Wu yaa beed yi geen Kaparnaam wu keá nhyaam kejea Paar Juog unahg gihru. Paar Juog be yoadu. Juog wu ukedhe yi buur thuudh cuohn ne Jaeena. Bang gihn nea kwaad giih teeg gaahy nyoge ge ayug yi geenu, ge ne yug ke yi geen Codom ge anaa awaang Juoge ne puuj, ka moogo e ngo ne poohdo e ngo ucuungo uwahdhe cahng tihn. ");
INSERT INTO lwo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Abea yaage! Ngahyu ngo ne cohg kejea Cahng Lug Juog, e yaa Codom ge ungwaahne. Abea wun, Juog lug gihre uteeg rogu keter.” ");
INSERT INTO lwo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Cahng nu e Jeacuu anaa arubo kobe, “Abaa Wura! Yih naa Ruohdh Maalo kedea wiih piny cang. Koohri amuohja tihn keter bang gihn luube ke nying dhaahri ge ngahy ke yihne cog, ge kii nyoadho yihr yaa par wudh gen kejea ge nyoge maa apiehj. Abea ge anyoadhi ke yihr yaa ngahy rog gen kejea ge neehn nyethen, gihn me ngahy gene tooro. ");
INSERT INTO lwo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ayiih! E naa kaa agweehgi dhe yoohn ka yoad dhaahri kii ngo noono. ");
INSERT INTO lwo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Teeg wong ne ngahy giih nyepinye cang ngo acub Juog Wura yihra kedea beehda Juog Wura cog e ne ngahy an me neehn man nahge an e ne ngahy Juog Wura kedea yaa ukwanya ungahy gene Juog Wura. ");
INSERT INTO lwo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Wu ge agoohg ke mag loohnge kedea ungoohng giih wiih ngoome nyingu, wu noono cang, wu ucuohn ne beehn banga beere wu be nahg diere. ");
INSERT INTO lwo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","A daahd ngo unahge ke loohnga ge ne magu kedea yiihu giih puohnya, bang gihn a beehda ngaa me cwihnya ngej me padh ngad diihd cwihny. Kaano e nuu uyoad wahyu kar beehdo me beer maa kar yuohmo yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Adiehr muon, ne mag loohnga ngo yoohd, ngo padh teehr me goohg wun.” ");
INSERT INTO lwo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Batien nihn mooge e Jeacuu kedea jo waahdhe ge anaa ake caahdho e ge cor yihdh puohdh me beel acieg yihdh gen kwaade tooro. Cahng nu anahg beriown nihn kedea e naa cahng yuohmo gihr yaa Judea gihn cuohn ne Cahng Cabadh. Jo waahdh Jeacuu ge anaa abang kahje ne cohg ugoohg kar guume. Noono e ge adhiil jag ke cwed beel bang yihdh puohdh, ucaahdh gene e ge raam gene raamo keehd maa anaa acier loohng Moaje tiihj Cahng Cabadh. ");
INSERT INTO lwo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Naa aniid yaa Paarijea gihn ayug ree, e anyiinyo agooy gene piny urub gene yihr Jeacuu kejea, “Maahny kwaad gihn tiihy jo waahdhi! Ge tiihy gihn maa acier loohng Moaje ke tiihyo Cahng Cabadh.” ");
INSERT INTO lwo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Maa abeehr Jeacuue ngo kea, “Ka moogo e gihn anaa atiihy Deabid Ruohdhe naa anahg kahje en maa joe anaa akwaanu? ");
INSERT INTO lwo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Deabid anaa abeehn ne ci yi Wod Juog ke joe ucam gene amono Wod Juog. Amono me beehda ngad lam yihr Juog e naa ngaa cam ngo, ngaa moogo tooro. ");
INSERT INTO lwo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Thiow ngo kuu akwaano yi loohng Moaje kejea yaa lam yihr Juog giih lam ge nahg gene nahgo Cahng Cabadh, abea be kob naa ge atiihyo Cahng Cabadh? ");
INSERT INTO lwo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Athiir roba robo nyumu kan, awaahn ni nud ke gihn me wiihe ne maalo me yoohm tiihy Wod Juog. ");
INSERT INTO lwo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Thiow, e naa gihn agweed yi kitaab Juog kejea Juog arubo kea, ‘Mara a daahd ngaa me luu cwihnye caahn me wii lubo piny, a be daahd ngaan yug giih kweehr.’ Ngaa maa abiohgrwaal awagu kaa cayo. ");
INSERT INTO lwo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Dhiilo ngo ke ngahyo kejea a ge adoohng ne dhaano utaahngo, a naa ruohdh acub loohng Cabadh yi cinge!” ");
INSERT INTO lwo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Naa acor ge Jeacuue yihdh puohdh cang, e ge atoohng wod amaad maa amon gene wod. ");
INSERT INTO lwo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ngaa me cinge abaahl anudo wod amaad gihn nu. Nyoge maa adaahd Jeacuu utiihye gihn maa acier loohng Juoge beere ngo luom gene luomo, ngo apeehny gene kob gene, “Do thiehdh dhaano Cahng Cabadh ngo amahn loohng Juoge ne?” ");
INSERT INTO lwo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Maa akoohb Jeacuue kea, “Beeh peehnya wun coadhi. Nea roomo apahdh yi abuulo yihr dhaano acielo kiin nu Cahng Cabadh, e ngo wiie ke yi abuulo cahng nu, bang gihn nahge Cahng Cabadh ne? ");
INSERT INTO lwo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wahy ngaa ge ne miehr ke konyo kiin roomo ke dhaano? Nea kaa ngo e wahy dhaano wiihe ne maalo yihr wahy roomo. Caahn e gihn nu thiow, nyoadh ngo kejea thiehdh dhaano uthaango Cahng Cabadh kuu amahn loohng paaje bang gihn beehda tiihy gihn me beer.” ");
INSERT INTO lwo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Noono maa alog Jeacuue dhee ne rob ke ngaan cinge abaahl kea, “Nyieh! Riihj badi.” Abea naa ariihj nyine bade e ado kare ne rihb. ");
INSERT INTO lwo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Paarijea giih anaa adaahd dhe Jeacuu, naa aniid gene gihn atiihy ree, e ge ayedh maalo ke leng leng ne ci ne gweehg dhe yoohn nahg Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jeacuu gihn agweehg yaa Paarijea ke nyinge ke piny angeye, uwiie kaano piny ucea ka moogo. Amahr nyoge batien Jeacuu abeehn gene ne buodho beere ge ke thiehdho, maa athiehdhe yaa atwaanye cang. ");
INSERT INTO lwo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Naa athiehdh Jeacuue nyoge, e aciere ke piny yihr gen kejea gihn atiihye keá rob gene yihr nyoge beere be ngej kejea ngo Waahd Juog. ");
INSERT INTO lwo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jeacuu ngo aciere beere gihn arob Juoge ke nying Waahd Juog ke leeb Yicaaya ngad agamloohngjuog pahdh kare ne tog. ");
INSERT INTO lwo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Anaa arob Juoge kea, “Ngaan e naa ngad tiihj yihra. Ngo akwanya ke med cwihny kedea ngo anhyaara ne cohg. Tee mara ke kare ngo acuba yihre beere ukihm gihra robe robo yihr nyoge cang. ");
INSERT INTO lwo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ngo buu unahg ngad weehr bang gihn ngo padh ngad nhyaam kedea duone buu uke lihngo. ");
INSERT INTO lwo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nyoge me cwihny ge bahw kedea me yiiho gihr gen thiin ge buu ukaahne ke cing nyooro. Abea ukihm gihra upuohnye yihr nyoge ke leng leng uwahdhe ka unieng adiehj lume piny unea ne rihb keew nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kaano e nyoge cang ge ugaahn en.” ");
INSERT INTO lwo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kaano arumo, e nyoge dhaano maa amiing kedea acoor akahl gene ke bang Jeacuu. Atiihb ukeehg me ne ree e naa ayug ngo umiinge kedea ucoor wonge. Naa awahnhe, e ngo athiehdh Jeacuue thiehdho une wonge pahd uniide nyepinye kedea ugoony leebe ree urube. ");
INSERT INTO lwo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Amahr lwaag gihn anudo, naa aniid gene gihn atiihy ree e ge agaahy urub gene kob gene, “Kwaad ngaan ni padh e naa kwaar Deabid gihn anaa arob ne?” ");
INSERT INTO lwo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Naa alihng Paarijea ajuohj gihr nyoge, e ge ake rubo kob gene, “Ngaan wa ngo be tiihyo kaa tee gihre. Ngahda beehda Ruohdh atiihb ukeehg e cuohn ne Beeljebuul e naa acub tee gihn nu yihre adhaahr urome atiihb ukeehg ka riem oogo yi koohm nyoge!” ");
INSERT INTO lwo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kaano e giih arob Paarijea ge kaa angej Jeacuue maa abeehre ngo yihr gen kobe, “Tien paajo me paahng yea naa akuude udog gene rog gen ke liny, akuongu ke lihngo kejea bar maalo ne? Dhe wod thiow me pahy ne dahg udo nyethen yeje ne liny ke rog gen keed gen, e dhe wod nu be kuong koad ne weey weey kedea utoar. ");
INSERT INTO lwo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Caahn e wudhu paru paro kejea atiihb ukeehg ge do rog gen keed gen, neehn ka rubu kejea tee ayoada ke bang ruohdh gen! Nea gihn nu ree atiihye yi dhaahr atiihb ukeehg, e nyoadh ngo kejea beehda dhaahr maa atoar. ");
INSERT INTO lwo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Beer, nea wu urubo kejea Ruohdh atiihb ukeehg e naa acub tee yihra ne riem atiihb ukeehg oogo rog nyoge, abea yaau ge riem atiihb ukeehg oogo rog nyoge, ngaa e naa acub tee yihr gen? Yaa nu ge nuu uguo ngo ke robo yihru kejea gihn robu beehda toohd. ");
INSERT INTO lwo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Awaahn ni lihngu gihn teeda yihru beer mee. Tee kaa ayoado ke bang Ruohdh atiihb ukeehg, abea beehda Juog Aciehg ke ngude e naa acub ngo yihra ne riem atiihb ukeehg oogo. Gihn nu nyoadh ngo yihru kejea Juog athubo ke tiihj yi dhaahre keewu. ");
INSERT INTO lwo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Wa gihn thiow, kare tooro ubeehn dhaane ucidhe paar ngaa me teeg ne tub giih ngo. Ngaa rom paar ngaan nu ke tubo beehda ngaa me teeg me ngo kuonge kaa tuohy piny, nea ngo atuohye piny, e giih paare ge tub tubo arumo. ");
INSERT INTO lwo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Wa gihn nu kwaad ngaa tooro kura, padh ngada, kedea ngaa be cong yihdh yaa beehn banga, uroomo ke ngaa maa akeedh yihdh gen ");
INSERT INTO lwo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Teeda teedo yihru kejea: kwaad adhemuohme cang rom Juoge kaa wii piny. Keehd ngaa maa arob gihn me raaj rih Juog wale rih Waahd Juog, e ngo rom kaa wii piny yihre. Abea ngaa arob gihn me raaj rih Wahy Juog, e adhemuohm ngaan nu be rom ree wii piny ne weey weey keehd me wahdhe weehne. ");
INSERT INTO lwo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“E naa gihn dhiilu kwaad giih tiihya ke niido ne ngej ngo kejea a beehda ngaa. Bang gihn keehd yaadh e yaadh me beer kedea me raaj ngej kaa nyethiine. ");
INSERT INTO lwo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wu beehda kwaad thoohne me yihdhu apahng ke giih me reje. Gihn me beer me rom beehn oogo yi dhogu ngo tooro. Bang gihn, gihn ne yaa aduun dhaano e naa gihn beehn oogo kii dhee. ");
INSERT INTO lwo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Noono e ngaa yea apahng ke luube me beeye, luube me beeye ge ne beehn oogo yi yea. Abea ngaa yea apahng ke luube me reje, luub nu reje ge ne beehn oogo yi yea. ");
INSERT INTO lwo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Athiir e ne dhiila ke robo yihru. Cahng Lug Juog, e kwaad dhaano cang upeehny ne kweeny yihdh kwaad giih reje naa ateede. ");
INSERT INTO lwo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Giih arob dhaane ge nuu unyoadh ngo nyum Juog nea ngaan nu beehda abiohgrwaal wale awuohj nud ree. Noono e gihn arob dhaane e nuu umag ngo.” ");
INSERT INTO lwo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kaano, e yaa loohng Juog mooge kedea Paarijea mooge ge ake rubo yihr Jeacuu kob gene, “Ngad puohny kare nud awaahn ni uromi gihn me gaahy nyoge ke tiihyo nyum wan kan ne?” ");
INSERT INTO lwo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Maa abeehr Jeacuue ngo kea, “Wu yaa awaahn ni, wu ka beehdo nyoge me reje me kwihy Juog e naa gihn peehyu yihra kejea tiihya gihn me gaahy nyoge ne? Bekihd gihn me tiihya yihru! Nea wu daahd gihn me gaahy nyoge e gihn uniidu ngo unahg gihn atiihy ree rih agamloohngjuog gihn nyinge Jona. ");
INSERT INTO lwo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona nihn adahg anaa anahge yi yea reehyo me duohng mee, wa maano thiow Waahd Juog ngaan adoohng ne dhaano nihn adahg unahge thaahdh ngoom. ");
INSERT INTO lwo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Cahng Lug Juog unahg yaa Niineba, ge nuu ucuung nyumu ne cay wun wu ge yaa upiny awaahn. Bang gihn naa abeehn Jonae ne puohny yaa Niineba e puohnye ayiih gene uwii gene tiihy giih anyoohne. Abea awaahn kan ngaa me duohng keter yihr Juog e man nyumu. ");
INSERT INTO lwo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Cahng Lug Juog unahg dhaar anahg ruohdh ukoom ne maang dhaahr Ceaba e nuu ucuung yi lug ne cay wun, wu ge yaa piny awaahn ni. Bang gihn dhaar ni anaa abeehno ke kur thar upiny ka me baahr keter ubeehne ne lihng loohnge giih Caloamon ge nyinge anaa awiihj. Abea awaahn kan ngaa me duohng keter rih Caloamon e man nyumu. ");
INSERT INTO lwo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nea atiihb ukeehg caa ne beehn oogo yi kuohm ngaan arieme oogo ree, e ngo caa ne waahdh ke bang kuohn me yihdh gen toor piih e ngo daahd ka me yuohme yea. Naa atoor kaa me beer maa ayoade ");
INSERT INTO lwo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","e wiihe apare ne do kare naa abeehne oogo yea. Ge acea ne duuo arumo, e kare naa acoon yuude e ngo acwad kedea agwiir beer mee ke dhe yooh me Wahy Juog toor yea ");
INSERT INTO lwo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kaano e ngo adog caahn ucea ne kahl atiihb ukeehge abiihjberiow mooge me akaal wiihe ke raahyo beere ge beehn ne piih wiih ngaan. Awaahn ni ngaan ayoad gihn me raaje ne cohg, bang gihn kar bodho mare yi dhoar ni unahg gihn me teeg keter. Teeda teedo yihru kejea ngo uneehn gihn nu ke wun, wu yaa reje ge nud awaahn ni.” ");
INSERT INTO lwo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nye kaano apoohde e Jeacuu ne yi wod e urubo yihr nyoge, e men kedea wuud wahn, ge abeehno maa acuung gene oogo kob gene ge daahd rob keehd Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Maa aguo ngaa mooge dhee ke log bang Jeacuu urube kea, “Miihu kedea wuud wuru ge ne oogo kedea ge daahd rob ke yihn.” ");
INSERT INTO lwo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Maa arub Jeacuue kea, “Miiha kedea wuud wura ge beehda jo kee?” ");
INSERT INTO lwo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Maa anyoadhe bang jo waahdhe kea, “Lihngu gihn! Yaan ni ge naa ge miiha kedea ge wuud wura! ");
INSERT INTO lwo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Miiha kedea ge nye wura maa ge uwura ge beehda yaa tiihj gihn daahd Wura ge ne Maalo.” ");
INSERT INTO lwo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Cahng nu ateed Jeacuue ngo kejea wuud men beehda kwaad yaa tiihj gihn daahd Juoge, e naa a'aaye ucea dieng naam duohng gihr Teberya. ");
INSERT INTO lwo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kaano, e amahr nyoge me thoohdh awaahdo ke batiene utoor kar tiele. Naa aniid Jeacuue ngo ne maano e ayedh yi baabuur beere urubo yihr gen e nii baabuur abea nyoge ne wiih agala ne gihr. ");
INSERT INTO lwo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Noono e Jeacuu ake thubo ke puohny e giih puohnye ge teede yihr nyoge kaa dhe yoohn ucaale. Kaano e athubo kuu ucaan ni kea, “Umodho coon nyin moogo koohdhe anaa akaabe ne ci yi puohdho ne puur. ");
INSERT INTO lwo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Abea naa ayore koohdhe, e mooge apahdh thaahng yooh maa abeehn winye uted gene gen. ");
INSERT INTO lwo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Koohdhe mooge ge apahdh wong leelo, me yea tooro ngoom me beeye. Maa aguo gene tuuyo bang gihn ngoom me ne cohg maa ayoad gene tooro. ");
INSERT INTO lwo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nye muu atuuy ge kuu nahbo abea ge aguo cahnge ke taal maalo une gene jongra ke talo bang gihn biey gen kuu anieng piny. ");
INSERT INTO lwo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mooge ge apahdh yi piny dhyaay kedea moodho. Abea naa adoong gene e ge ake juul bang gihn ge ateel dhyaaye piny uthow gene. ");
INSERT INTO lwo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Abea koohdhe mooge ge apahdh ka me yea ne ngoom me beeye maa atuuy gene beer mee kedea ucieg gene me wiih acielo yea ne cwed beel kar jiehabiihj kedea mooge yihdh gen ne jiehadahg kedea mooge dahng yihr gen ne dhaano aduuno wonge apaar. ");
INSERT INTO lwo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Teeda teedo yihru kejea nea ngaa yihdhe nud e kea lihnge.” ");
INSERT INTO lwo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Naa abeehn Jeacuue oogo yi baabuur e jo waahdh ge acaa bange upeehny gene ngo kob gene, “Ngad puohny gihn e rubi yihr nyoge kaa dhe yoohn ucaale?” ");
INSERT INTO lwo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Maa abeehr Jeacuue ngo yihr gen kobe, “Ne ngey yihdh luub Dhaahr Juog beehda Juog e naa acub ngo yihru wu jo waahdha. Abea ngo rob yihr nyoge maa now kaa ucaale. ");
INSERT INTO lwo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ngahyu ngo kejea ngaan cub wiihe piny ne lihng lum Juog, e Juog ubar maalo ke rob yihre kedea Juog ungahye. Abea ngaan thoohr wiihe piny ne yahng yi lum Juog, e keehd nye ma thiin ge anaa angeye meehg Juoge ke rwaahnyo yihre. ");
INSERT INTO lwo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","An, a rubo yihr nyoge kaa dhe yoohn ucaale bang gihn nyoge keehd me niid gene nyepinye e giih ngo ge be cub gene yi wudh gen wale me lihng gene nyepinye e yihdh gen be boar gene. ");
INSERT INTO lwo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Leeb Juog gihn agweed yi kitaab ngad agamloohngjuog gihn nyinge Yicaaya ke nying yaa be lihng luube ngo apahdh kare wa kaa anaa arub Juoge kea, ‘Kwaad yaa ni yihdh gen aceg gene piny ne lihng abea gihn me mon yi yihdh gen tooro kedea nying gen apeeny gene piny ne maahnyo abea gihn me niid gene tooro. ");
INSERT INTO lwo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yaa nu ge lihngo ke nahg diih abea wudh gen ne thihdh thihdh kedea yihdh gen atahg maa nying gen aciehg rog gen ne lihb. Nea be ne naa wa gihn nu, e giih nyepinye ne niid gene ke nying gen kedea ulihng gene ke yihdh gen kedea udead gene yihdh nyepinye kaa aduun gen kedea wudh gen ne waar gene noono e ge anaa athiehdh.’ ");
INSERT INTO lwo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Abea maru rogu med keter bang gihn Juog tee acube yihru me niidu nyepinye giih atiihya kedea ungeyu athiir kedea me lihngu giih apuohnya kedea uboaru yihdh gen. ");
INSERT INTO lwo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Teeda teedo yihru ne cohg kejea nyoge maa abiohgrwaale kedea yaa agamloohngjuog ge adaahd uniid gene giih niidu, abea ge kuu aniid gene kedea ulihng gene giih lihngu, abea ge kuu alihng gene.” ");
INSERT INTO lwo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Cegu yihdhu beer mee ne boar lum yea ucaale gihr ngad puur. ");
INSERT INTO lwo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kwaad yaa lihng Ciig Beer ke nying dhaahr Juog, abea lum yea Ciig Beer gihn nu be boar gene, kwaad yaa nu ge ne room keehd koohdhe giih apahdh thaahng yooh, uguo atiihb ukeehge beehno ne pihr wa gihr winyo ne yag Ciig Beer oogo yi koohdh gen. ");
INSERT INTO lwo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Abea koohdh muu apahdh wong leelo ge ne room keehd yaa lihng Ciig Beer umag gene ngo ke med cwihny nye wong kaano alihng gene ngo. ");
INSERT INTO lwo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kwaad yaa nu Ciig Beer kuu anieng yi cwihny gen. Noono nea bahng utuohl ke nying Ciig Beer, e cwihny ge guo baadh ugweey gene ngo piny. ");
INSERT INTO lwo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Dahng kwaad yaa lihng Ciig Beer ni, ugweey gene ngo caahn bang gihn cwihny gen athoohr gene yihdh giih lonyo giih upiny kan, ge ne room keehd koohdhe giih apahdh piny dhyaay kedea moodho. Kwaad yaa nu Ciig Beer be piih yi cwihny gen, bang gihn adeehj gene giih lonyo yi cwihny gen. ");
INSERT INTO lwo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Abea kwaad yaa lihng Ciig Beer unienge yi cwihny gen uboar gene yea kedea uyiih gene ngo, ge ne room keehd koohdh muu apahdh ka me yea ne ngoom me beer ucieg gene. Abea naa acieg gene e wiih acielo yea ne cwed beel kar jiehabiihj kedea mooge yihdh gen ne jiehadahg kedea mooge dahng yihr gen ne dhaano aduuno wonge apaar.” ");
INSERT INTO lwo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kaano keehdo e ucaale moogo acahg Jeacuue ke robo yihr gen ne nyoadh ka beehd Dhaahr Juog kii ngo kea, “Cahng ni ngad puur aci yi puohdho uyore koohdh beel piny upuure wudh gen. ");
INSERT INTO lwo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ke waahr e nyoge aneno cang kun peeg kun peeg e ngad mahn nyin ree akwale yi puohdho. Noono, upiihe ne yor beeg akaja kiin koohdhe giih apuur, unea liib oogo. ");
INSERT INTO lwo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Naa aci beele ne doongo udhahy gene, e wudh beeg akaja ge naa adoohng ne piil piil ke keew gen! ");
INSERT INTO lwo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Yaa tiihj yi puohdho naa niid gene kwaad gihn nu e ge agaahy urub gene yihr ngad puohdho kejea, ‘Wad wan! Ngahda yih anaa apuur koohdh beel me beey ne cahng ni me padh beeg akaja ne? Abea beeg akaja atuohl kaa kee keew gen?’ ");
INSERT INTO lwo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Maa abeehr wur puohdhe ngo yihr gen kobe, ‘Beehda yaa mahna ge naa atiihy kwaad gihn nu.’ Maa acahg yaa tiihye piehj kob gene, ‘Abea cidh wane ne pudh beeg akaja oogo ne?’ ");
INSERT INTO lwo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Maa amahn wur puohdhe gen kea, ‘Kea themu piny wa maano, bang gihn nea beeg akaja tumu kaa pudh oogo, e biey beel me beey beehn oogo thiow bang gihn beeg beey tien gen akahd gene keehd tien beeg akaja tiehd. ");
INSERT INTO lwo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wiiu beeg akaja giih nu ubeehd gene kiin beel. Nea wahdh kar kaj beel e uteeda yihr yaa tiihj ukuong gene beeg akaja ke toohng piny umodho utuohj gen ne duohde beere ge ke waango. Nea beeg akaja ge awaang, e muu beehda liil ge ke kayo udihn gen ukedh gen yihdh gale giiha.’ ” ");
INSERT INTO lwo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Jeacuu abar maalo ke rob kuu ucaale kea, “Dhaahr Juog uroomo keehd wong jaaro ge thiin maa akaab dhaane upiidhe ngo yi puohdhe. Nea ngo apiidh piny keehd me thiin wonge, ge cea ne tuuyo e udoongo ukaare ke baahd me thoohdh unea lihm. Kaano e winy wuud gen geer gene ke wiihe.” ");
INSERT INTO lwo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Noono, e ucaale moogo adog Jeacuue kaa caalo yihr nyoge kea, “Dhaahr Juog neehn thobe maa kaab dhaage, ulyaahbe ngo ke deeh moo, ce bihle ngo. Nea wahdh caahn e deeh mog abihl yaahny maalo cang.” ");
INSERT INTO lwo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Giih ge arob Jeacuue yihr nyoge ke nying Dhaahr Juog e ge teede kaa ucaale. Kihd wong acielo maa arobe now e ucaale be kahle yea tooro. ");
INSERT INTO lwo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jeacuu arubo kuu ucaale beere gihn arob Juog ke leeb ngad agamloohngjuog pahdh kare wa kaa ateede naa akob Juoge kea, “A urubo yihr gen kuu ucaale ne teed giih me kuu akuong gene ke lihngo ke kaa acag upiny cago.” ");
INSERT INTO lwo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kaano arumo e Jeacuu akuud nyoge awiie piny umone wod maa abuodh jo waahdhe batiene. Gihn nu e ge arubo yihre kob gene, “Ngad puohny kare nud uteedi lum yea ucaale gihr beeg akaja yihr wan ne?” ");
INSERT INTO lwo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Maa abeehr Jeacuue ngo kea, “Wur puohdho ngaan apiidh koohdhe me beeye beehda an ge adoohng ne dhaano utaahngo. ");
INSERT INTO lwo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Abea puohdho gihn ayor koohdhe yea e naa upiny ke kare cang ne dug. E dahng koohdhe muu beeye ge beehda yaa Dhaahr Juog. E thiow beeg akaja ge beehda yaa atiihb ukeehg. ");
INSERT INTO lwo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Abea ngad mahn gihn akwal ree yi puohdho ke waahr ne piidh beeg akaja ngo beehda atiihb ukeehg, e yaa tiihyo yi puohdho ge beehda wuohdjuog. Kedea cahng kaj beel e naa Cahng Lug gihr Juog. ");
INSERT INTO lwo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Cahng lug gihn nu e yaa anyoohne ge ukuong ke kwany oogo kiin nyoge wa gihr beeg akaja ge kuong ke toohng piny, ce tuohj gen ne duohde uwaang gen. ");
INSERT INTO lwo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","An ke nguda ge adoohng ne dhaano utaahngo wuohdjuog ge uoohra kan ukuong gene yaa yug giih me reje kedea yaa alyaahb ke poy oogo keew yaa beeye. ");
INSERT INTO lwo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Noono uthoohr wuohdjuoge gen yi diih maaj muu unyaahm ne ngahg ngahg wa maay peg leelo ne lalo ke lan ngoohng wong e dhog gen kaany gene kaanyo ke nying raahm. ");
INSERT INTO lwo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jo wan, nea ngaa yihdhe nud e kea lihnge. Cahng uthoohr yaa reje yi maaj, e yaa ayiih lum Juog awaahn ni, koohm gen uke liel ne cal cal wa meehr cahng yi Dhaahr Juog. ");
INSERT INTO lwo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Dhaahr Juog roma ke rih ngaa maa ayoad gihn maa wuohb me ngiene teeg maa akan yi puohdho. Gihn nu e wiih ngo adoge wumo beer mee batiene e adog paare ungeewe giihe naa anudo yihre oogo cang, beere beehn ne ngeew puohdh ni keehd ngiihny ayoade. ");
INSERT INTO lwo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Thiow Dhaahr Juog roma ke rih thaajir me daahd dhaahb me ngiene ne maalo. ");
INSERT INTO lwo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ngaan nu abuohj duug ke wen, abea naa atoohnge wiih dhaahb maa kar cwihnye, e adog paajo ungeewe giihe oogo cang uduue arumo ne ngeew dhaahb gihn anhyaare. ");
INSERT INTO lwo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Dhaahr Juog thiow uroma ke rih ngaa maa aceg booy yi naam duohng, ubeehn booy gihn nu umahge ne kahd kahd keehd kwaad gun reehyo cang, me cam kedea me be cam. ");
INSERT INTO lwo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ge aniid ngad booye ngo e reehyo ane kahn kahn yi booy, e booy ateele ke thaahng agala ne kwany kiin rej. Kwaad reehyo me beer thoohre kii diido, abea kwaad ma be daahde thoohre ke dom. ");
INSERT INTO lwo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Teeda teedo yihru kejea kwaad gihn nu ree uyuge yihr nyoge thiow cahng gug piny. Wuohdjuog ge ubeehn ke yoohn maalo ne lel yaa reje oogo keew yaa beeye, ");
INSERT INTO lwo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","uthoohr gene gen yi maaj muu unyaahm wa maay peg leelo, ne lalo ke lan ngoohng wong e lag gen kaany gene kaanyo ke nying raahm.” ");
INSERT INTO lwo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Batiene e jo waahdhe ge apeehnye kea, “Giih ni aroba yihru yihdh ge aboaru beer mee?” Maa abeehr gene ngo kejea yihdh ge aboar gene. ");
INSERT INTO lwo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Maa adog Jeacuue ngo ke beehro kea, “Wa maano e nyoadh ngo kejea kwaad ngad loohng Juog maa ayiiho me neehn wun, ngo uroomo ke dhaano me yihre ne gala. Gala me yea ne giih apuur ne caahngo kedea wong.” ");
INSERT INTO lwo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Naa athum Jeacuue ke rob yihr yaan nu, e ngo ake aay ke yaa waahdhe ne ci yi geen paar gen gihn cuohn ne Naajaread. Naa awahnhe yi geen nu, e ngo acaa wod amaad uthube ke puohny nyoge. Amahr yaa anudo, naa alihng gene giih puohny Jeacuue, e ge agaahy kwaad tooro uthub gene ke rob ke rog gen kejea, “Yaahy! Ngaan ngahy rob loohnge ngo akwanye ke kee! Kedea tiihy giih gaahy nyoge ayoade ke kee?” ");
INSERT INTO lwo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nyoge ge abar maalo dahng ke rob ke rog gen kob gene, “Naa cahy! Ngahda nyedhoohg ni, beehda waahd ngad tieng yen ne? E thiow ngahda waahd Maarya? Kedea Jeamij maa Jocebe maa Cimoane kedea Juudo ge beehda wuud wahn ne? ");
INSERT INTO lwo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ge nye wahn ngahda ge giih beehd ke won kan ne? Abea mare noono ni, deeh tee gihn ni tiihye giih me gaahy nyoge akahle ke kee?” ");
INSERT INTO lwo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Noono maa akweer gene ke yiih lume bang gihn ngo ngad paar gen muu uroomo ke gen. Maa akoohb Jeacuue yihr gen kea, “Keehd me yiih nyoge mooge giih tiihy agamloohngjuoge, e yaa geen paar gen ge be yiih gene naa athere.” ");
INSERT INTO lwo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Gihn nu e Jeacuu giih me gaahy nyoge me thoohdh ge keá tiihyo kaano naa aniide ngo e Ciig Beer kuu ayiih gene. ");
INSERT INTO lwo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Eroade ngaan anahg Ruohdh piny Gaalili Joon Ngad Luogwahy anaa abeehne ne kedh yi thijin unahge. Yihdh nihn anaa alihnge bang Jeacuu e ateede yihr joe kejea, “Ngaan ni udhiil nahg Joon Ngad Luogwahy e naa acahr, e naa gihn nud yihre tee me tiihye giih me gaahy nyoge.” ");
INSERT INTO lwo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Eroade ciih umen me cuohn ne Pihlihb anaa ageere e umen noon ni wonge poohd kuow. Dhaar ngo nyinge anahg Eroadaj. Naa aniid Joone gihn nu, e ateede teedo yihr Eroade Ruohdh kejea kare tooro ugeer dhaane ciih umen me kuow. Noono e Eroade cwihnye ake rahnyo umage Joon uthoohre ngo yi thijin. ");
INSERT INTO lwo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eroade anaa daahd Joon ke naah, abea ngo atud yihr yaa ngahy ngo kejea Joon beehda agamloohngjuog. ");
INSERT INTO lwo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Eroade Ruohdh deeh yaay me duohng na yuge yugo ke nying wong ke nying ne par cahng anyuole. Caahn e yihdh nihn ane Joone yi thijin, deeh yaan cahng anyuol en anaa ayug Eroade ucuohne amahr nyoge. Nyaar dhaar nyinge Eroadaj abeehn ne miel yi yaay gihn nu ke meehdo maa amihn cwihny Eroade keraahyo. ");
INSERT INTO lwo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Maa akuohnge ree nyum nyoge kea, “Kwaad kihd gihn daahd nyaane, e ngo dhiila kaa cubo.” ");
INSERT INTO lwo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nyaan yea abeehn men ne coamo kejea nahge wiih Joon e ne daahde. Adiehr muon, ngo acidho urobe ngo yihr Eroade kea, “A daahd wiih Joon Ngad Luogwahy ukahle yihra kan e nii caan.” ");
INSERT INTO lwo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Eroade cwihnye kuu amedo ke nying gihn ateed nyaane, abea keehd maano e adhiile ke teedo yihr yaae uci gene ne ngol wiih Joon oogo, bang gihn akuohnge ree nyum nyoge cang kejea kwaad gihn daahd nyaane udhiile ke cubo. ");
INSERT INTO lwo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Maa aoohre acaakere yi thijin ne ngol wiih Joon oogo kedea ukahl gene ngo. ");
INSERT INTO lwo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Maa acub wiih Joon yi caan ukahle yihr nyaan maa akaabe ngo ubaare ngo bang men. ");
INSERT INTO lwo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jo waahdh Joon naa alihng gene gihn atiihy ree e ge acidho ukaab gene kuohm Joon ne kedh ne koanyo. Batien kaa athum gene ke kan dhaano e ge acaa bang Jeacuu ne rob gihn atiihy ree. ");
INSERT INTO lwo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Naa alihng Jeacuue thon Joon, e ngo ayedh yi baabuur ne nyiig ree oogo ka me toor nyoge yea. Nyoge thiow alihng gene kejea Jeacuu a'aay. Noono upahdh yaa beed yihdh geedh dieng baawe yi yooh ke tien gen ne buodh batien Jeacuu e ge kwany bang geedhe. ");
INSERT INTO lwo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Naa ayihnh Jeacuue piny yi baabuur, e amahr nyoge aniide niido uyuog cwihnye yi ngoohng nying gen maa athiehdhe yaa atwaanye me thoohdh mee keew gen. ");
INSERT INTO lwo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ge abeehdo kaano uwahdhe thiehno. Abea naa acej cahng kwaar piny, e jo waahdh ge acaa bang Jeacuu ukoohb gene kejea, “Ngaa duohng, wo ne dom kedea cahng noono kwaar piny, abea nea kare nud, e kea oohr nyoge yihdh miehr ne ngiew ke caame me cam gene.” ");
INSERT INTO lwo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Maa ateed Jeacuue ngo yihr joe kea, “Ge aay kaa nying gihn? Cubu gihn me cam yihr gen.” ");
INSERT INTO lwo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Maa arub joe kejea, “Yey! Nye ngaan duohng! Wa yihr wan naa amune abiihj cog kedea nye rej ariow!” ");
INSERT INTO lwo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kob Jeacuue kea, “Kea kahlu gen yihra kan.” ");
INSERT INTO lwo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Naa akahl gen yihre, e arobe robo yihr nyoge kejea piih gene piny cang ne raahj yi lum. Noono ukaabe amune kedea rej giih ni, umaahnye maalo maa amuohje koohr Juog. Batiene e yihdh amune abanye kedea ucube gen yihr jo waahdhe ne paahngo yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nyoge acahmo uyahng gene cang. Goan caame kedea nye wey weye giih adoohng piny, ge acong jo waahdhe upaahng gene diide apaar wonge ariow. ");
INSERT INTO lwo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yaa acahmo, ge anahg kar alihbe abiihj, abea amahr maahn maa nyethen thene giih anudo, ge kuu akwaan. ");
INSERT INTO lwo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Naa athum jo waahdhe ke cong goan caame cang, e arob Jeacuue robo yihr gen kejea yedh gene yi baabuur ne moon loog baaw. Jeacuu anaa adoohng ne rob ngo yihr amahr nyoge beere ge dog miehy gen ");
INSERT INTO lwo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Naa a'aay nyoge e Jeacuu aci wiih good maalo kare keede ne kway Juog. Cahng ayuudho une piny bihb e poohd ne wiih good kar keede, ");
INSERT INTO lwo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","abea ka e baabuur anaa awahdh yi diehr naam duohng ka me baahr kaa agala. E thiow yamo anaa acoohd e baabuur yoore ke caahn kedea athewo daahd yaa kiihwo ke bano. ");
INSERT INTO lwo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ge awahdhe kar koohg uthuonjien umodho e Jeacuu alahb batien jo waahdh, e ngo caahdh kaa wudh piih ke maalo now e ngo be diihr. ");
INSERT INTO lwo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Naa aniid jo waahdhe Jeacuu e ucaahdho ke wudh piih, e ngo kuu angey gene maa atud gene ne cohg urub gene e koohm gen urihg ni kob gene, “Ngo beehda juog naam e gihn nu caahdh ke wudh piih ne wale beehda gihn?” Maa ajiedh cwihny gene. ");
INSERT INTO lwo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Noono e Jeacuu ake rubo yihr gen kejea, “Deedu cwihnyu teeg. Wu keá tudo, beehda an, a Jeacuu!” ");
INSERT INTO lwo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Naa alihng Piihtere gihn arob Jeacuue e ngo ake rubo kea, “Ruohdh, nea beehda yihn ne cohg, kea meehg an beehn bangi e a caahdh kaa wudh piih thiow!” ");
INSERT INTO lwo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Maa ateed Jeacuue ngo kea, “Beehni!” Naa alihng Piihtere lum nu, e ngo kuu acahg gaalo, abea ngo aguo paahr oogo yi baabuur uthube ke ci bang Jeacuu e ngo caahdh kaa wudh piih. ");
INSERT INTO lwo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nye kaano acaahdh Piihtere ke wudh piih, e aduune anaa rug umag lwahre ngo. Piihter atud ke nying yamo maa athewo giih anaa adhal. Kaano atude thiow, e ngo ake thubo ke diihr piny, umaahre piny ke lalo e kway wong Jeacuu kejea, “Ayoay! Ruohdh kony an!” ");
INSERT INTO lwo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kii nyenij kaano e Jeacuu aguo wahnh bang Piihter upaad ngo ce rube kea, “Aduuni daag unea rug kaa nying gihn? Juog ke ngude be gaahni ne?” ");
INSERT INTO lwo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kaano arumo e Jeacuu kedea Piihter ge acaa ne yedh yi baabuur uguo yame ke ne dihl tiehd. ");
INSERT INTO lwo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jo waahdh cang giih anaa yi baabuur, Jeacuu adoar gene uteed gene ngo yihre kejea: “Angej wane ne cohg kejea yih beehda Waahd Juog Aciehg!” ");
INSERT INTO lwo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jeacuu kedea jo waahdhe naa angol gene baaw e ge abeehn ne toohng paajo me nyinge Geneajared. ");
INSERT INTO lwo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yaa paan ni Jeacuu angey gene kejea beehda ngaa me thiehdh nyoge. Noono uoohr gene dhog yihdh miehy cahng ni, kejea kahl yaa atwaanye bang Jeacuu. Maa akahl yaa atwaanye yihre. ");
INSERT INTO lwo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wong Jeacuu akway nyoge kejea meehge yaa atwaanye gweel keehd dhe waahre now, bang gihn ngahy gene kejea kwaad ngaa gweel dhe waahr Jeacuu, e ngo ungweehno. Adiehr muon, kwaad ngaa agweel dhe waahr Jeacuu ngo athiehdh. ");
INSERT INTO lwo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Cahng man e Paarijea maa yaa loohng Juog ge abeehn bang Jeacuu ke yoohn Jeruucalem upeehny gene Jeacuu kob gene, ");
INSERT INTO lwo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Gihn ge beehn jo waahdhi udhahl gene yihdh loohnge giih jo doong Judea naa acoon? Cing gen be luog gene ke dhe yoohn ka ne tiihy ge kuowo ngo kaa nying gihn?” ");
INSERT INTO lwo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Maa abeehr Jeacuue ngo kea, “Gihn ge dhahlu loohng Juog thiow unahge ke dhe yoohn loohnge giihu ge ne tiihyu ke gen? ");
INSERT INTO lwo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ngahda Juog anaa arubo kejea, ‘Wuor wuru ge ke miihu ne?’ ‘E ngaa rob gihn me raaj rih wahn wale men e ngo ke naah ne?’ ");
INSERT INTO lwo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Abea nea dhaano urubo yihr wahn wale yihr men kea, ‘Gihn arob loohng Juoge kejea dhiila ngo ke cubo yihri ngo acuba piny ke nying lum Juog’ e ngaan nu lume yiihu yiiho. ");
INSERT INTO lwo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ke dhe yooh nu e naa kaa ameehgu ngaan nu paahl wahn maa men oogo. E naa kaa adhahlu lum Juog kii ngo noono uyoadu ke loohng maru e ne kedhu wong maalo. ");
INSERT INTO lwo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wu beehda yaa waal ne cohg. Gihn agweed yi kitaab Juog ke nyingu ge anaa arob ngad agamloohngjuoge gihn nyinge Yicaaya beehda athiir! Arob Yicaaye kea Juog anaa arubo kea, ");
INSERT INTO lwo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Yaa ni, a wuor gene kaa leehb gen now abea aduun gen tooro banga. ");
INSERT INTO lwo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Beehda toohd now keehd me koohb gene kejea ge wuor an. Noono ge piih ne puohny loohnge me yoad gene bang nyoge mooge abea ge padh loohnge giiha.’ ” ");
INSERT INTO lwo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kaano e Jeacuu akuud nyoge acuohne cuohno bange maa arube yihr gen kea, “Cegu yihdhu beer mee ne lihng gihn teeda yihru. ");
INSERT INTO lwo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Padh giih cam dhaane ge ci yi yea ge ne meehg dhaano cuohno ne ngaa me beer yihr Juog, abea beehda lubo gihn rob dhaane oogo ke dhee e ne meehg dhaano cuohno ne ngaa me raaj yihr Juog.” ");
INSERT INTO lwo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kaano e jo waahdh ge abeehn bang Jeacuu urub gene kejea, “Ngad puohny ngahyi awaahn ni kejea Paarijea cwihny gen arahnyo ke nying giih robi ne?” ");
INSERT INTO lwo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Maa abeehr Jeacuue ngo yihr gen kuu ucaale kea, “Kiin yen nud upiny cang, kwaad yaadh me kuu apiidh Wura ge Maalo ni, e yaadh nu dhiil kaa pudh oogo. ");
INSERT INTO lwo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Koohdhu keá tihngu kedea wudhu keá raamo ke nying nyoge me cwihny gen athow. Paarijea ge neehn ruohdhe maa acoor me piej rog gen. Nea cuor piej cuor mooge piejo, ngahda e ge dhiil pahdh yi buur ne?” ");
INSERT INTO lwo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","E Piihter ayedh maalo urube kea, “Ngad puohny gihn acaali yea kuu angey wane beer mee, kare nud uteedi lum yea yihr wan ne?” ");
INSERT INTO lwo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Maa abeehr Jeacuue ngo yihr gen kejea, “Wu thiow nyingu poohd kuu akweeg ne ngey nyepinye wa kwaad yaa wudh ge ne thihdh thihdh ne? ");
INSERT INTO lwo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Goohg ke ngeyo yihru ke naa diih? Cam gihn cam dhaane ke dhee ngahda ngo caa yi yej ubare oogo? ");
INSERT INTO lwo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Abea luub rob dhaane ke dhee ge tuohl kaa kee? Luub nu ge yaay ke yaa aduun dhaano kedea ge naa luub meehg Juog koohbo kejea dhaano raaj. ");
INSERT INTO lwo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aduulo e ne par kwaad giih reje ge meehg Juog cuohn dhaano ne ngaa me raaj. Noono, e gihn apar dhaane, en ne jwang ngo ne tiihy gihn me raaj. Gihn me neehn nahg dhaano kedea kaab ciih ngaa moogo. Thiow yug kwaad giih mooge maa acwaahne now, neehn yag gihr ngaa moogo kedea teed gihn maa toohd, wale ngier kuohm dhaano kaa aleeng dhaahl. ");
INSERT INTO lwo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kwaad giih ni cang ge ne meehg Juog cuohn dhaano ne ngaa me raaj. Abea mar cam e cing dhaano kuu aluoge wa ka rob gene, be meehg Juog cuohn dhaano ne ngaa me raaj ne weey weey.” ");
INSERT INTO lwo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Paan nu abeehn Jeacuue ne wii piny ucea piny me cahng ke geedh cuohn ne Taayr kedea Ciihdoan. ");
INSERT INTO lwo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ka me thiin e dhaar Kanaan maa abeed piny nu aguo rihng bang Jeacuu. Dhaar ni wong Jeacuu akwaye ke lalo kejea, “Ruohdh, yih ge beehda kwaar Deabid, luu wonge banga ukonyi nyethiina. Nyaara be kuow! Ngo amag atiihb reje kedea ngo abang gene keter.” ");
INSERT INTO lwo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dhaar ni abar maalo ke kwaago ke batien gen abea Jeacuu ulengo now. Noono, e jo waahdh ge ake rubo yihr Jeacuu kob gene, “Cub gihn daahd dhaar ni bang gihn ngo abuohj ke kwaago ke batieno.” ");
INSERT INTO lwo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Maa abeehr Jeacuue ngo kejea, “A abeehn upiny kan kaa nying boadh yaa Yijarael cog ge wa diehg maa arwaahnyo.” ");
INSERT INTO lwo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nye kaa arob Jeacuue gihn nu, e dhaar ni, aguo wahnho urunge cunge piny nyum Jeacuu e urubo kea, “Ngaan Duohng, konya!” ");
INSERT INTO lwo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Maa abeehr Jeacuue ngo kuu ucaale kea, “Kare tooro ucub cam nyethea paajo yihr goohy.” ");
INSERT INTO lwo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Noono, e abeehr dhaar ni kea, “Beehda kare ne cohg wa kaa ateedi ngo. Abea keehd maano, e nyethea goohy ge na ke muojo ke cam me doohng piny bang ruohdhe.” ");
INSERT INTO lwo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","E ngo acahg Jeacuue kaa beehro kea, “Aniida ungeya ngo kejea yih dhaago me cwihnyi teeg kedea yiiho gihri naa ayiihi an ree be waare. Ke nying gihn nu, e gihri naa adaahdi ke cwihnyi ngo upahdh kare ne tog.” Abea nye kaa arob Jeacuue gihn nu e naa nye kaa a'aay atiihb reje oogo rih nyaar dhaar ni. ");
INSERT INTO lwo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Paan nu acahg Jeacuue wii piny ubare yihdh miehy naam duohng gihr Gaalili. Jeacuu ayedh wiih good ucea ne piih. ");
INSERT INTO lwo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Noono, e amahr nyoge me thoohdh awaahd bange e ge kaahn yaa atwaanye. Keew yaa atwaanye giih nu, nyoge mooge ge anahg ngoohde, mooge ge acoor kedea mooge ge abab piny. E thiow, mooge kar rob ke ngude atooro yihr gen. Amahr yaa nu cang ge akahl ne cub buude, noono uthiehdhe gen cang ne raj. ");
INSERT INTO lwo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nyoge agaahy naa aniid gene gihn atiihy ree uwuor gene Juog ne cohg. Ge agaahy bang gihn ngaa maa miihng me leebe atuohj ngo alihngo urome rob, e ngaa anaa abab piny ngo acaahdho kedea ngaa me wonge anaa acoor wonge ayahbo. Noono upiih gene ne wuor Juog gihr yaa Yijarael. ");
INSERT INTO lwo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kaano arumo, e Jeacuu jo waahdhe ge acuohne urube yihr gen kejea, “Aduuna uyuog ke nying jo ni bango kan, bang gihn nihn ge beehda adahg awaahn ni e gihn maa agweel gene dhog gen tooro. Caahn e cwihnya tooro bange udog gene miehy gen ke deeh kahj me wa gihn rog gen. Bang gihn a utudo ka moogo e nyoge mooge caa ne pahdh yi yooh!” ");
INSERT INTO lwo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Maa apeehny jo waahdhe ngo kob gene, “Wo ne yi ukang ka me baahr ke miehr. Ka muu uyoado cam me rom amahr yaa ni amahdo ke yaahngo ngo tooro!” ");
INSERT INTO lwo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Maa apeehy Jeacuue kea, “Yihru naa amune adiih?” Maa abeehr gene ngo kejea, “Amune abiihjberiow, kedea nye rej me noog me thene mee ge ne nud cog.” ");
INSERT INTO lwo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Noono maa arob Jeacuue ngo yihr nyoge kejea piih gene piny ne raahj cang. ");
INSERT INTO lwo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Naa apiih nyoge, e Jeacuu amune kedea nye rej giih atudo ge akaabe kaabo, umuohye koohr Juog utoare yihdh gen, ce cube gen yihr jo waahdhe ne paahngo yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nyoge acahmo cang ne raj uyahng gene bang gihn cam aduohngo. Naa acong jo waahdhe goan caam adoohng piny e adiide abiihjberiow ge apahng ke caam adoohng piny. ");
INSERT INTO lwo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yaa acahmo ge anahg kar alihbe angween, abea amahr maahn kedea nyethen thene giih anudo ge kuu akwaan. ");
INSERT INTO lwo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Batien gihn nu e nyoge ameehg Jeacuue keedho, maa apaahre yi baabuur ne bar piny Magadan. ");
INSERT INTO lwo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Cahng man keehdo, e Paarijea kedea Caaduucean ge abeehn bang Jeacuu e ge daahd ngo ke tumo maa arub gene yihre kejea, “Wa daahd utiihyi gihr Paar Maalo me gaahy nyoge nyum wan kan uniid wane ngo.” ");
INSERT INTO lwo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Maa abeehr Jeacuue ngo kea, “Nye yaage, kaa ngo kwihyu ke naa diih! Wa nea cahng kwaar piny uyuge meehr me kwaar, e wu urubo kuu yamo me beer ukoohdo cahng nu. ");
INSERT INTO lwo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","E thiow, wu urubo kejea kodh ucwii cahng ruu piny e maalo ne wij wij kedea cahng naa ngaang. Kare nud yihru kejea giih yi maalo ge romu kaa ngahyo, abea giih yug rog gen awaahn ni ge be romu ke ngahyo ne? ");
INSERT INTO lwo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Beehda kwaad koohdh nyoge me reje me kwihy Juog ge ne daahd uyug gihn me gaahy nyoge yihr gen. Bekihd gihn me tiihya yihru! Nea wu daahd gihn me gaahy nyoge, e gihn uniidu unahg gihn atiihy ree rih agamloohngjuog gihn nyinge Jona.” Naa athum Jeacuue ke rob e ngo a'aay uwiie gen kaano. ");
INSERT INTO lwo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Naa awahdh gene loo naam, e angey jo waahdhe kejea wudh gen kaa awul utoor amune maa akaahn gene. ");
INSERT INTO lwo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kaano e Jeacuu arubo yihr gen kobe, “Yabu nyingu kedea koaru rogu rih kamiira gihr amono gihr Paarijea kedea Caaduucean.” ");
INSERT INTO lwo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kaano e ge athubo ke dwaano yi lum nu ke keew gen e ge urubo kob gene, “Gihn ni ngahda arobe kaa nying gihn awul wudhu utoor amune me kaahno.” ");
INSERT INTO lwo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gihn adwaan gene ke nyinge angey Jeacuue maa arube yihr gen kea, “Wu dwaan ke nying tooy amune kaa nying gihn? Bahw cwihny maa gihn e yihru ni! Yiiho gihru ka thiin ne weey weey! ");
INSERT INTO lwo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ka poohd kuu angeyu kejea kare tooro udiera ke nying cam ne? Wudhu awul ge anaa adooja amune abiihj uyaahng gene nyoge alihbe abiihj kedea ubeehn goan caam adoohng piny upaahng gene amahr adiide ne? ");
INSERT INTO lwo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Dahng wudhu awul yi mar amune abiihjberiow giih ayaahng nyoge kar ge alihbe angween ne kedea ubeehn goan caam adoohng piny upaahng gene amahr adiide ne? ");
INSERT INTO lwo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Goohg ke ngeyu yihru ke naa diih kejea a be rom rob ke nying cam? A arob ngo yihru kejea koaru rogu rih kamiira gihr amon Paarijea kedea Caaduucean.” ");
INSERT INTO lwo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Batien rob nu e angey jo waahdhe ngeyo kejea Jeacuu kuu arubo kaa nying thobe gihn meehg amono yaahny maalo. E thiow ngo angey gene kejea Jeacuu acier ngo kejea kwaad giih puohny Paarijea kedea Caaduucean ge keá cub gene yi cwihny gen. ");
INSERT INTO lwo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jeacuu maa jo waahdhe ge abar maalo ke waahdh utoohng gene paajo moogo me cuohn ne Cejearya Pihlihbi. Kaano e jo waahdh ge apeehny Jeacuue peehnyo kejea, “Nye yaage duud dhaano utaahngo kob gene a naa ngaa?” ");
INSERT INTO lwo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Maa arob gene ngo kejea, “Nyoge mooge ge urubo kejea yih beehda Joon Ngad Luogwahy e naa acahr, e nyoge mooge ge urubo kejea yih beehda ngad agamloohngjuog gihn nyinge Eliija e naa aduuo ke yoohn maalo. Nyoge mooge thiow ge ukoohbo kejea yih beehda Jermya naa anudo umodho coon maa nyoge mooge ge urubo kejea yih beehda agamloohngjuog maa anudo umodho coon.” ");
INSERT INTO lwo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Maa acahg Jeacuue piehj kea, “Abea nea maru, e a naa ngaa?” ");
INSERT INTO lwo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","E agaahr Cimoan Piihtere gaahro kea, “Yih beehda ngaan aoohr Juoge ne boadh nyoge, yih naa Waahd Juog Aciehg ge ne Maalo.” ");
INSERT INTO lwo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Maa arub Jeacuue kea, “Athiir muon. Atiingi yih Cimoane waahd Jona. Yih adooj Juoge ne cohg. Adiehr me tiing ree kare ne tog wa gihn nu ngahya kejea kii lihngo ke bang dhaano utaahngo, abea beehda Juog Wura ge ne Maalo ke ngude e naa anyoadh ngo yihri. ");
INSERT INTO lwo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Caahn e yih Cimoane, yih uke cuohno ne Piihter, lum yea ngaa me teeg wa kihdo. Jo'a ge ucuba yi cingi ne maa ke nying gihn teegi wa kihdo. Gihn muu uban yihn ngo utooro ne weey weey, keehd thoo yih buu ubane. ");
INSERT INTO lwo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mugthaa gihr dhe Paar Juog ngo ucuba yihri. Kwaad gihn ateedi kejea yuge wiih piny kan, e uyiih Juoge Paar Maalo wa kar dhii, abea gihn acieri kejea keá yug, e ucier Juoge thiow.” ");
INSERT INTO lwo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Naa agooy Jeacuue wiih lubo piny e arobe kea ngo keá teed jo waahdhe yihr nyoge kejea e naa Waahd Juog ge aoohre ne Boadh nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ke wong cahng nu e Jeacuu ake thubo ke rob yihr jo waahdhe kea, “A dhiil ci Jeruucalem, abea acaa ne pahdh yi bahng me duohng me wahya ge dhiile kaa kano, bang gihn jo doong paajo kedea jo doong yaa lam maa yaa loohng Juog ge nii koar an piny. A unahg gene abea a ucahr batien nihn adahg.” ");
INSERT INTO lwo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kaano e bad Jeacuu amag Piihtere uteele ngo kar ge keed gen maa angeenye yi wong ngo kea, “Bekihde Ruohdh! Gihn nu ree be rome tiihyo rihi!” ");
INSERT INTO lwo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Maa alog Jeacuue ngahye bang Piihter urube kea, “Atiihb ukeehg nyiig rih oogo buuda. Rihi ayugi ne kerahg dhe yoohna, bang gihn yih par kwaad giih me padh giih Juog, abea yih par giih par dhaano utaahnge.” ");
INSERT INTO lwo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Maa abar Jeacuue maalo ke rob yihr jo waahdhe kea, “Nea ngaa daahd ubuodhe batiena kea jaahye ree maa uguume giih raahm kuohm wa mara, ce beehne ubuodhe batiena arumo. ");
INSERT INTO lwo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwaad ngaan kweer ke buodh batiena bang gihn be daahd uthowe e ngaan nu kuowo me guge tooro buu uyoade. Abea kwaad ngaan be dier ke thoo ke nyinga, e ngaan nu kuowo me guge tooro uyoade. ");
INSERT INTO lwo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Gihn e ne kony giih wiih pinye yihr dhaano utaahngo ne boadh wahy be yoade? Wale gihn noono rom dhaane ke cubo me room ke wahye? ");
INSERT INTO lwo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","A ge adoohng ne dhaano utaahngo a uduu e a caahdh kaa teeg mar Juog Wura naa acub yihra. A ubeehn tiehd keehd wuohdjuog ne koog nyoge wa kwaad ka utiihy gene. ");
INSERT INTO lwo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A rob athiir yihru. Yaa nud kan ge buu uthow cang, nud ke nyoge kiin gen muu uniid an, a ge adoohng ne dhaano utaahngo beehn ne piih wiih koom ne ruohdh.” ");
INSERT INTO lwo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Naa abar nihn abiihjbeciele batien rob Jeacuu kejea e uyoad gihn me raaje Jeruucalem, e Jeacuu Piihter kedea Jeamij maa Joon umiih Jeamij ge akaabe uaaye ke gen ucidh gene wiih good me duohng keter kar gen keed gen. ");
INSERT INTO lwo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kaano anahg gene wiih good e ka nahg Jeacuue ngaa me yihre ne tee abeehn gene ne niido. Aniid gene bang gihn Jeacuu ree aloge, kaan nyinge tar wa meehr cahng kedea waahre ateany ne yim wa bur waaro. ");
INSERT INTO lwo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ka me thiin e ge niid Moaje kedea Eliija yaa agamloohngjuog naa acoon e ge urubo keehd Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Naa aniid Piihtere gihn nu e ngo ake rubo yihr Jeacuu kea, “Ruohdh! Ngo beer ubeehdo kan! Nea cwihnyi ne bang ngo e abuwe adahg geera geero! Acielo yihri maa acielo yihr Moaje kedea acielo yihr Eliija!” ");
INSERT INTO lwo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nye kaano apoohde e Piihter urubo, e poohl anaa niihm wudh gen. Maa abeehn poohle uryaale piny wa maahny kodh kedea ulihng gene duon Juog e urobo yi poohlo kea, “Gihn e naa Waahda maa anhyaara kedea cwihnya med ree. Lihngu lume beer mee.” ");
INSERT INTO lwo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Naa alihng jo waahdhe duol, e ge atud upahdh gene ne riehb piny. ");
INSERT INTO lwo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kaano e Jeacuu abeehn bang gen ugweele gen e ngo urubo kejea, “Aju maalo kedea wu keá tud.” ");
INSERT INTO lwo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Abea naa amaahny gene e Jeacuu e keede e naa aniid gene. ");
INSERT INTO lwo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Naa athub gene ke duuo e ge loon piny ke wiih good, e ngo acier Jeacuue piny yihr gen kea, “Gihn aniidu wiih good keá robu yihr kwaad dhaano cang uwahdhe cahng ucahra yi thoo, a ge adoohng ne dhaano utaahngo.” ");
INSERT INTO lwo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kaano e jo waahdhe Jeacuu apeehny gene kob gene, “Ruohdh, ke nying gihn e kob yaa loohng Juoge ngo kejea, ‘Eliija e nuu ukuong beehno umodho yihri?’ ” ");
INSERT INTO lwo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","E abeehr Jeacuue beehro kea, “Beehda kaa ngo. Eliija ubeehn umodho ne gwiir kwaad nyepinye cang. ");
INSERT INTO lwo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Abea wa Eliija abeehno coon! Kedea ubeehde kiin nyoge abea ngaa maa angey ngo tooro! Noono maa akaahne ke cing nyooro. Abea e nuu neehn mara, a ge adoohng ne dhaano utaahngo thiow. A ukaahn ke cing nyooro uyug giih me reje riha wa mar Eliija.” ");
INSERT INTO lwo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Naa alihng jo waahdhe gihn ateed Jeacuue, e angej gene ngeyo kejea ngo rubo kaa nying Joon Ngad Luogwahy. ");
INSERT INTO lwo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Naa aduu ge Jeacuue kedea joe naa acaahdh keehde bang akuud nyoge, e dhaano abeehn bang Jeacuu urunge cunge piny nyum ngo. ");
INSERT INTO lwo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ce rube kea, “Cedhree! Ruohdh kony waahda uthiehdhi ngo. Wiihe ne juu maa abang ngo kwaade tooro. Gihn abang ngo beehda kwaad atiihb ukeehg gooy dhaano yi maaj, bang gihn ngo gooy kii yi maaj kedea cahng moogo e ngo koole ke naam. ");
INSERT INTO lwo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nyethiin anaa akahla yihr jo waahdhi ge anaa adoohng kan abea ngo agoohg yihr gen ke thiehdho.” ");
INSERT INTO lwo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Maa ateed Jeacuue ngo yihr nyoge kobe, “Wu kwaad nyoge me yiiho tooro yihru. Wudhu paru paro kejea a ubeehdo ke wun uwahdhe weehne? Kahlu nyethiin ngo yihra kan!” ");
INSERT INTO lwo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Noono maa ariem Jeacuue atiihb ukeehg kejea aay gene oogo rih nyedhoohg, uguoe ngo ke thiehdho ke nye wong kaano. ");
INSERT INTO lwo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Naa adoohng gene ge keed gen, e jo waahdh Jeacuu apeehny gene kejea, “Gihn e anaa agoohg riem atiihb ukeehge oogo yihr wan?” ");
INSERT INTO lwo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Maa ateed Jeacuue ngo kea, “Agoohg ke riem oogo yihru bang gihn teeg Juog kuu ayiiho ke cwihnyu ne cohg. A rob lubo maa athiir yihru, keehd me thiin yiihoe gihru wa wong niino, e kare nud uteedo ngo yihr good me duohng udaye oogo kare kedea ngo dhiil dag. Nea yiiho me thiin nud yihru e kwaad gihn daahdu kedea gihn teedu pahdh kare ne tog.  ");
INSERT INTO lwo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ngahyu ngo kejea riem kwaad atiihb ukeehg me wa gihn oogo daahd kwaj Juog me ne cohg kedea kweehr cam.” ");
INSERT INTO lwo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Cahng maa anaa apiih Jeacuue keehd jo waahdhe yi piny Gaalili ka maa acielo e Jeacuu ake rubo yihr gen kea, “A ge adoohng ne dhaano utaahngo, a uluom ucub an yi cing nyoge me reje. ");
INSERT INTO lwo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Yaa ngo a umag gene unahg gene an. Abea batien nihn adahg, e a ucahr yi thoo.” Maa amaan jo waahdhe gihn arob Jeacuue keraahyo urahny cwihny gene. ");
INSERT INTO lwo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jeacuu kedea jo waahdhe ge abar maalo ke waahdh uwahdh gene geen Kaparnaam, kaa a'aahl gene yaa gwaaj cuol piny yea. Noono, e yaan ni Piihter apeehny gene peehnyo kejea, “Awaahn ni ngad puohny gihru noono cuol gihn gwaaj ke nying Wod Juog, beehde cube ke piny ne?” ");
INSERT INTO lwo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Maa agar Piihtere ngo kea, “Ayiih, cuol beehde cube ke piny.” Noono, uaay Piihtere kaano umone wod bang Jeacuu. Abea naa awahdhe wod e Jeacuu e naa akaang ngo oogo ke piehj kobe, “Piihter, nea mari e ruohdhe giih upiny cuol kaab gene ke bang yaa weehne? Kaab gene ke bang nyethen paajo wale ke bang aleye?” ");
INSERT INTO lwo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kob Piihter kea, “Beehda aleye ge ne cub cuol piny yihr ruohdh paaro kan.” Maa arub Jeacuue kea, “Beer! Kaa ngo. Gihn nu nyoadh ngo kejea nyethen paajo cuol be gwaaj bang gen. ");
INSERT INTO lwo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Abea wo be daahd ngo urahny cwihny yaa gwaaj cuole kejea wo akweer ke cub ngiihny Wod Juog ke dhieny keehd me nahgo nyethea Wod Juog. Abea yihn kaab ubihdh ucii naam duohng ne thoohr. Reehj umagi umodho ried yea, ngiihny uyoadi yi yea kaab ngiihny nu ucubi gen piny ne cuol mari maa mara.” ");
INSERT INTO lwo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nye wong kaano e jo waahdh ge abeehn bang Jeacuu upeehny gene ngo kejea, “Ngaa kiin wan, e ne duohng yi Dhaahr Juog?” ");
INSERT INTO lwo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Naa alihng Jeacuue piehj gihn nu e nyethiin acuohne cuohno uteede ngo yihr nyethiin kejea cuunge yi diehr kiin gen. ");
INSERT INTO lwo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Noono maa arub Jeacuue kea, “Lihngu adiehj teeda yihru beer mee. Wu be kuong ci yi Dhaahr Juog nea padh rogu e ne yugu udoohngu wa nyethen. ");
INSERT INTO lwo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ngaa lwaay ree piny wa nyethiin e naa ngaa wiihe ne maalo yi Dhaahr Juog. ");
INSERT INTO lwo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Kwaad ngaa me beehdo beer keehd nyethiin me wa nyethiin ni, e ngaan nu uroomo wa ngo abeehdo beer kaa an. ");
INSERT INTO lwo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kwaad ngaa meehg nyethiin wii luma naa ayiihe, e ngweehn me tuohj leele yi ngud ngaan nu uthoohre yi naam duohng. ");
INSERT INTO lwo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Uraaj ne cohg yihr yaa upiny ge umeehg rog gen dwaahngo. Adiehr muon adwaahngo nud wiih piny, abea gihn uyoad ngaa dwaahngo unahg gihn me raaj ne cohg. ");
INSERT INTO lwo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Cubu wudhu piny beer mee! Nea cingi wale tieni e naa ameehg yihn yug adhemuohm kea ngul ngo oogo uthoohri ngo dom. Bang gihn ngo beer uyoadi kuowo me guge tooro e cingi acielo wale e tieni acielo yihr man thoohr yihn yi maaj ke cingi ariow wale ke tieni kar ge ariow. ");
INSERT INTO lwo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nea wong dhaano e ne meehg ngo yug awuohj e kea oohle ngo oogo ubaahle ngo dom. Bang gihn ngweehn uyoadi kuowo me guge tooro e yihri ne wong acielo yihr man thoohr yihn yi maaj muu unyaahm ke nyingi ariow cang. ");
INSERT INTO lwo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Cubu wudhu piny beer mee. Keá ngaa ngier kuohm nyethiin ucwiide ngo ke dhieny bang gihn nyethen, wuohdjuog giih koar gen ge beed buud Juog Wura Paar Maalo ne rob ke nying gen.  ");
INSERT INTO lwo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Unahg a Jeacuu ge adoohng ne dhaano utaahngo ke nguda a nuu uboadh kwaad ngaa arwaahnyo. ");
INSERT INTO lwo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Teedu ngo yihra! Nea dhaano yihre ne roohme kar ge jiehabiihj, urwaahny aciele kiin gen, ngahda e ngaan nu goan roohme ge wiie ke dieng good ne nyam ucea ne daahd acien maa arwaahnyo ne? ");
INSERT INTO lwo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A teed gihn maa athiir yihru! Nea roomo gihn arwaahnyo ngo ayoade, e cwihnye udoohng med ukaale mihn cwihny ke nying roohme giih kuu arwaahnyo. ");
INSERT INTO lwo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Juog Wuru ge ne Maalo beehd ke wa gihn nu thiow ke nyethen. Ngo be daahd ngo urwaahny nyethiin aciele keew nyethen. ");
INSERT INTO lwo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Athiir teeda teedo yihru, nea wadu gihn me raaj ayuge rihi, kea cidhi bange ne nyoadh gihn raaj ge atiihye. Wadu keá cayi nyum nyoge ne dahr, abea teed awuohj gihre yihre karu keedu e wu ariow cog. Nea lumi noono ateedi alihnge umaane giih reje ge atiihye, e wadu akonyi nyum Juog. ");
INSERT INTO lwo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nea wadu noono akweer ke lihng lumi, kea cuohn dhaano acielo moogo wale nyoge ariow ne cuude giihi. Bang gihn, ‘Daahd cuude ariow wale adahg beere gihn raaj ge arob wadu ke yiiho naa adiehr.’ ");
INSERT INTO lwo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nea wadu noono akweer ke lihng lum amadu keew cuude, kea baar lubo wong maalo yihr jo yiiho, abea nea ngo acahg kweer yihr gen, kea waadh wiihi oogo ree uniidi ngo wa aley. ");
INSERT INTO lwo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“A rob athiir yihru kejea gihn ateedu kejea yuge wiih piny kan, e uyiih Juoge Paar Maalo wa kar dhogu, abea gihn acieru kejea keá yug, e ucier Juoge thiow. ");
INSERT INTO lwo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“E thiow ngahyu ngo kejea nea nyoge ariow kiinu wale nyoge me thoohdh wudh gen amad gene ka maa acielo ke nyinga ukwahy gene ke nying kwaad gihn me daahd gene, e gihn nu dhiil gene kaa yoado bang Wura ge ne Maalo. ");
INSERT INTO lwo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bang gihn nea nyoge keehd me nahg gene nyoge ariow wale adahg cog abea ge amahdo kaa nyinga, e a dhiil nudo kiin gen.” ");
INSERT INTO lwo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Noono e Piihter abeehn bang Jeacuu upeehye kea, “Ngad puohny, nea wad wan giih me reje kwaaye kaa ayugo riha e lubo uwiia piny yihre tiel adiih? Wiia ngo piny yihre tiel abiihjberiow ne?” ");
INSERT INTO lwo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Maa abeehr Jeacuue ngo kea, “Gahng. Padh tiel abiihjberiow keede, abea tiel me thoohdh. ");
INSERT INTO lwo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ka mag Juog yaa Dhaahre kii ngo uroomo ke ruohdh me daahd akweehn ke yugo ke yaa tiihj giihe. ");
INSERT INTO lwo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nye kaano akwaane akweehn kwaano, e ngaa maa akahbo bang ruohdh ni kaa amahr ngiihny naa amihdho akahl bange. ");
INSERT INTO lwo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ngiihny atooro yihr nyin me rome amihdho ke coalo, noono e arob ruohdhe kejea ngeewe oogo ne baahng keehd giihe cang maa ciihe kedea nyethene beere amihdho ke coalo. ");
INSERT INTO lwo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Naa alihng nyine gihn nu e ngo apahdh wudh conge ne rub nyum ruohdh ukwaye wong ngo kejea, ‘Cedhree! Ngwaahn an ruohdh, giihi ge ucoala cang.’ ");
INSERT INTO lwo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Noono e ruohdh aduune ake yuog uwiie amihdho piny yihre kejea keá coale keehdo maa alonye waahdh ngo. ");
INSERT INTO lwo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Abea ge a'aaye uwahdhe yi yooh, e ake roohmo ke ngaa moogo me ge tiihyo ke ka maa acielo keehde, maa anaa akaab ngiihny me noog mee naa amihdho bange. Naa aniid nyine ngaa anaa akaab ngiihny me noog mee naa amihdho, e anaa meen meen te ngud ngo e daahd ngud ngo ke deeyo kejea dhiile amihdho ke coalo kaa awaahn kan. ");
INSERT INTO lwo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Naa alihng ngaan nu gihn nu e anaa arub wudh conge piny nyum ngo urube kea, ‘Cedhree! Wad wan! Ngwaahn an tihn noon ni, ngiihnyi ge ucoala yihri cang!’ ");
INSERT INTO lwo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ngaan awii Ruohdh amihdho piny yihre abeehn ne kweer ne ped ne ngwaahn nyin, udhiile ngo ke mago ne nyoal yi thijin. Maa angweele ngo piny kejea nyin keá luny oogo nea padh amihdho e ne coale cang. ");
INSERT INTO lwo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nyoge mooge me tiihyo paar ruohdh cwihny ge arahnyo ucidh gene ne rob gihn ayug ree yihr ruohdh. ");
INSERT INTO lwo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Noono ucuohn ruohdhe ngaa amag dhaano maa acaye ngo kejea, ‘Yih beehda ngaa me raaj ne cohg! Wiihi awul naa awiia amihdhe giihi piny cang ke nying gihn akwayi wonga kejea ngwaahna yihn ne? ");
INSERT INTO lwo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nea ne nahg kare, e ngaan nu cwihnyi nii duu caahn ree, wa kaa aduua cwihnya caahn rihi.’ ");
INSERT INTO lwo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kaano e cwihny ruohdh arahnyo unyoale nyin yi karkoohn ne puohdo, kedea ungweele ngo piny kejea nea nyin be coal amihdho gihre e ngo keá lony oogo. ");
INSERT INTO lwo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Wura ge ne Maalo wu utiihye wa gihn nu, nea dhaano lubo be wiie piny yihr ngaa moogo ke cwihnye beehde.” ");
INSERT INTO lwo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Naa athum Jeacuue ke teed ucaale gihr wii lubo piny yihr dhaano, e ngo ake aay Gaalili ucea loog naam Joohrdoan yi piny Judea. ");
INSERT INTO lwo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Amahr akuud nyoge me thoohdh batien ngo abuodh gene buodho, e ge daahd uthiehdh atwaany gen. Maa abeehn Jeacuue uthiehdhe atwaany gen cang. ");
INSERT INTO lwo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kaano e Paarijea mooge ge abeehn bang Jeacuu e ge daahd dhe Jeacuu ke maa kob gene, “Do! Ngo beehda gihn maa amahn loohng Moaje ubahnge dhaano ciihe be rieme ke nying kwaad giih atiihy ciihe?” ");
INSERT INTO lwo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Maa abeehr Jeacuue ngo kea, “Nye jo wan! Ngo kuu anaa akwaano yi kitaab Juog kejea, ‘Ngaa acaah acag dhecuow kedea dhaago?’ ");
INSERT INTO lwo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘E naa gihn beehn dhecuowe udage oogo paar gen unweehde ke ciihe udoohng gene ne dhaano acielo.’ ");
INSERT INTO lwo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nyoge maa anweehd Juoge udoohng gene ne dhaano acielo keá ngaa paahng keew gen.” ");
INSERT INTO lwo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Naa alihng Paarijea lum nu, e Jeacuu adog gene kaa peehnyo kejea, “Abea gihn e naa akoohb Moaje kejea, ‘Nea dhaano daahd ciihe ke riemo, kea cube warga gihr paah yihr dhaago kedea urieme ngo?’ ” ");
INSERT INTO lwo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Uduog Jeacuue ngo yihr gen kobe, “Anaa arob Moaje bang gihn wu kwaad nyoge me wudhu teeg. Abea kuu anaa atiihy Juoge wa maano ge anaa acage nyoge umodho. ");
INSERT INTO lwo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jo wan, dhiila kaa robo yihru kejea ngaa riem ciihe now upadhe kaab e naa akaabe, kedea unyuome dhaago moogo e ngaan nu ayug adhemuohm muu uroomo kaa adhemuohm gihr ngaa maa akaab dhaago maa anyuom. A be rubo kaa nying riem dhaago me beehd dhaane now keehde, a rubo kaa nying dhaago maa anyuom.” ");
INSERT INTO lwo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Naa alihng jo waahdhe lum nu e ge ake rubo kob gene, “Ngad puohny! Nea giih nye kuome ge wa maano keew dhecuow ke dhaago kejea paah tooro, ngahda ngweehn uwaadh wihj oogo ke nying nyuohm ne?” ");
INSERT INTO lwo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Gihn nu acahg Jeacuue ke beehro kea, “Lum ubahnge dhaano be nyoohmo ngo be rob kaa nying nyoge cang naa arwaadh, abea ngo roba kaa nying yaa acub Juoge tee me ge be rom nyuohm. ");
INSERT INTO lwo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Juog kiin nyoge alele, ngaa moogo anyuol e ngo buoj utoor ka me yoade nyethen ke dhaago kedea moogo ke rojo udoohnge ne buoj. Abea ngaa moogo dahng ngo ukweer ke nyuohm ke nying cub wiihe yi tiihj lum Juog. Ngaan nu thiow uroomo wa ngaa kure tooro. Dhiilu lum ni ke yiiho ne gihn maa adiehr nea wu daahd ungahyu nyepinye.” ");
INSERT INTO lwo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kaano e nyethen me thene ge akahl nyoge bang Jeacuu ne doojo kedea beere Jeacuu Juog kwaye kwayo ke nying gen. Naa aniid jo waahdhe nyethen, e ge agahl gene ke oogo kejea ge keá kahl bang Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Naa aniid Jeacuue gihn nu, e ake rubo yihr jo waahdhe kea, “Ge keá mahnu! Weehgu gen beehno, bang gihn kwaad nyoge maa ayiiho kedea me gaahn Juog, me neehn nyethen ni ge ne wudh gen ne maalo Paar Juog.” ");
INSERT INTO lwo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nyethen ameehg bar bang Jeacuu, noono acube cinge wudh gen ne dooj gen, batiene e ngo a'aay ne ci ka moogo. ");
INSERT INTO lwo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Cahng man e ngaa maa riihj abeehn bang Jeacuu ukoohbe kea, “Ngad puohny, kwaad gihn me beer me ngihde e nuu utiihya beere kuowo me ne cohg yoada yoado Paar Juog?” ");
INSERT INTO lwo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Maa aduog Jeacuue ngo kea, “Gihn ge peehnyi an ke gihn me beer me tiihyi? Gihn beer beehda Juog. Abea nea yih daahd ngo uyoadi beehdo yi Dhaahr Juog, kea beehdi wa kaa arob loohng anyoadh Juoge.” ");
INSERT INTO lwo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nyin acahg piehj keehdo kea, “Loohng maa aweehne kiin loohng Juog?” Maa arob Jeacuue ngo kea, “Dhaano keá nahgi, ciih ngaa moogo keá kaabi, gihr ngaa moogo keá kwali yih keá rubo ke toohd. ");
INSERT INTO lwo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wuor wuru ge ke miihu kedea nhyaar wadu wa ka nhyaari rihi.” ");
INSERT INTO lwo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nyin adog rob dahng kea, “Loohng nu ge amaga ke kaa coon wa kaa arob, abea cwihnya poohd udaag kejea beehdo yi Dhaahr Juog buu uyoado. Nea maano e gihn noono e poohd kaa yugo?” ");
INSERT INTO lwo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Maa akob Jeacuue ngo yihre, “Nea yih daahd ngo ubari maalo ke yug gihn me beer keter, e kea dog paajo, ungeewi giih nud yihri oogo cang, upaahngi ngiihny ayoadi yihr nyoge maa angoohng beere giih lonyo ge yoadi ke Paar Juog. Kedea ubeehni unahgi ngad waahdha.” ");
INSERT INTO lwo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Naa alihng nyine gihn arob Jeacuue, e cwihnye kuu amihno, upahdhe yooh ne aay e cwihnye be med keter. Cwihnye be med bang gihn ngo beehda ngaa maa alony keraahyo. ");
INSERT INTO lwo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kaano e Jeacuu ake rubo yihr jo waahdhe kea, “Jo wan, a rob gihn maa athiir yihru. Ngahyu ngo kejea ngaa maa alony ci yi Dhaahr Juog uteeg yihre ubare. ");
INSERT INTO lwo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Thiow doga kaa teedo yihru, dhe yoohn Paar Juog ngo diiny keter yihr yaa lonyo ne mono kii ngo, adhaahr ngweehn roab amana yi libra wa mar libra ke keadh yihr mar yaa alony ne mono Paar Juog.” ");
INSERT INTO lwo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Naa alihng jo waahdhe gihn ni arob Jeacuue, e ge ake cwaahng urub gene kejea, “Abea ngaa noono e nuu urom mono yi Dhaahr Juog arumo!” ");
INSERT INTO lwo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Maa atal wong Jeacuue ne many bang gen ce koohbe kea, “Dhaano ke ngude cog beehd yi Dhaahr Juog be yoade, abea ngo yoade kaa kuny mar Juog, Juog e gihn me riehny yihre tooro.” ");
INSERT INTO lwo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Maa abeehr Piihtere ngo kobe, “Ngad puohny, wan, wa jo waahdhi giih wan ge awii wane piny cang ubuodh wane yihn, caahn e Juog gihn e nuu ucube yihr wan ne koog wan cahng moogo?” ");
INSERT INTO lwo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kaano e Jeacuu arubo kea, “Beehda athiir e ne teeda yihru Piihter, wu ukoog Juoge. Cahng ugwiire giih nyepinye cang ke nyinga, a ge adoohng ne dhaano utaahngo, a ubeehn upiiha wiih koom Juog e piny amora ke tee mara cang. Wu thiow, wu upiih wudh koome giih ruohdh kar ge apaar wonge ariow ne ruohdh mag dhog wuude giih yaa Dhaahr Yijarael giih apaar wonge ariow. ");
INSERT INTO lwo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Thiow, kwaad ngaan awii wuude giihe piny kedea ge umen maa ge nyemen maa ge wahn kedea ge men ke nyethen cang kedea puohdh, e kwaad ngaan nu giih mooge me nyaahn ge uyoade me yoohm muu umodho tiel me thoohdh, nea giihe ge anaa awiie piny kaa nyinga. Ngaan nu thiow, Dhaahr Juog dhiile kaa yoado. ");
INSERT INTO lwo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Abea ngahyu ngo kejea yaa ngahj wiih piny kan ne nyoge me wudh ge ne maalo ge naa yaa gihr nying gen tooro yi Dhaahr Juog, abea yaa gihr nying gen tooro wiih piny kan, ge naa yaa wudh gen ne maalo yi Paar Juog. ");
INSERT INTO lwo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ka koog Juoge yaa Dhaahre ge Maalo roma ke rih ngad paajo me yihre ne puohdho. Maa amool oogo ke nyango ne ci yi cuug ne caahyo ke nyoge me kedhe yi puohdho ne tiihj. ");
INSERT INTO lwo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Naa ayoade yaa tiihj e lubo amad gene kejea koog gihr gen ucub ke wong cahng tiihy gene. Koog gihn ngo unahg kar tiihy cahng acielo. ");
INSERT INTO lwo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ngaan ni yaa umodho ge akedhe yi puohdho. Abea naa abeehde ne naang, e dog ci yi cuug maa aniide nyoge me cej tiihj. ");
INSERT INTO lwo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Maa acea bang gen urobe ngo kea, ‘Cidhu yi puohdha ne tiihj, wu ungahya ke koo beer mee.’ ");
INSERT INTO lwo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Maa a'aay gene umad gene rog gen yi puohdho ne tiihj. “Abea ge ane cahnge cohg kedea thiow yi laahng cahng e ngad puohdho acaa yi cuug ne daahd ke nyoge mooge keehdo. Naa ayoade yaa tiihj e ge akahle ne tiihj yi puohdho. ");
INSERT INTO lwo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ke wong thiehno e ngad puohdho acahg dog ci yi cuug maa ayuude nyoge maa ake jwaado maa apeehnye gen kea, ‘Gihn e ne cuungu now ke kaa nyango uwahdh piny wa gihn e gihn me tiihyu tooro?’ ");
INSERT INTO lwo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Maa abeehr gene ngo kejea, ‘Ngaa maa ayoad wane tooro maa acub tiihj yihr wan.’ “Kob nyine kea, ‘Kea cidhu ne tiihj yi puohdha. Madu rogu bang yaa anaa umodho.’ ");
INSERT INTO lwo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Naa awahdhe ka kwaar cahnge piny e ngad puohdho ake rubo yihr ruohdh yaa tiihj kejea, ‘Cuohn yaa tiihj ukoogi gen. Abea thubi kaa yaa abeehno ke thiehno, ci wahdhi wudh yaa amoohlo ke nyango.’ ");
INSERT INTO lwo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Kaano e yaa abeehno ke thiehno akoohg gihr cahng acielo ake cubo yihr gen, naa acielo acielo. ");
INSERT INTO lwo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yaa athubo ke tiihj ke nyango ge abeehno e ge ugaahno kejea akoohg mar gen ujwag. Abea naa awahnh gene, e akoohg cahng acielo e naa acub yihr gen dahng. ");
INSERT INTO lwo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Naa amag gene ngiihny e ge ake ngoan rih ngad puohdho uweehr gene kejea, ");
INSERT INTO lwo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Maahny yaa ni abeehno ke thiehno ge atiihyo kaa kar caa acielo cog abea akoohg mar wan, wa yaa amoohlo utiihy wane kii diehr cahng maa maaj ukwaar wane cahng piny kare tooro urom koog mar wan keehd yaa nu. Gihn nu beehda ajohro e naa ajoohri wan!’ ");
INSERT INTO lwo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Maa alog ngad puohdhe wiihe bang dhaano acielo urube kea, ‘Lihng gihn goma! Wu kaa ajoohro! Abea koohw gihn anaa amado ke wun e naa acuba yihru. ");
INSERT INTO lwo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Wu keá ngoan! Kaabu ngiihnyu ucidhu miehyu. Beehda kar wiiha ukooga yaa abeehno ke thiehno ke koog muu uroomo ke maa acuba yihru. ");
INSERT INTO lwo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yihra tooro adiehja me tiihya gihn daahda ke ngiihny ne? Wale wu amag tiele kaa nying gihn bahnge gihn me beer kaa atiihyo yihru neehn mar yaa ni?’ ");
INSERT INTO lwo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“A rob adiehr yihru. Ngaan doohng dhe caahn, unahg ngad umodho kedea ngad umodho unahg ngad dhe caahn.” ");
INSERT INTO lwo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cahng man, e ge poohd nii wiih waahdh gen ne ci Jeruucalem, e Jeacuu jo waahdhe kar ge apaar wonge ariow ge acuohne ne ci ka me nyoge tooro yea ne rob yihr gen. Maa arube kobe, “ ");
INSERT INTO lwo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Lihngu gihn roba yihru! Wo aman ci Jeruucalem! Abea ge uwahdho, e a, ge adoohng ne dhaano utaahngo, a uluom ucub an yi cing jo doohng yaa lam kedea yaa loohng Juog ne kihmo ke thoo. ");
INSERT INTO lwo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","A ucub gene yi cing aleye muu ungier kuohma maa upuohd gene an ke ngeero kedea ugur gene an rih yaadh maa ariihw ne thoo, abea yi dahg nihn e a ucahr.” ");
INSERT INTO lwo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Cahng man e ciih Jebeade abeehn bang Jeacuu e ucaahdho ke waahde kar ge ariow, Jeamij maa Joon ge beehd jo oohr giih Jeacuu. Maa apiihe wudh conge ne kway gihre ne daahde. ");
INSERT INTO lwo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Maa apeehny Jeacuue ngo kea, “Yih daahd gihn wad wan?” Maa abeehr dhaar ni ngo kea, “A daahd umeehgi nyethena ge ariow ni piih wudh koom yi ruohdh ucingi. Ngaa man ukwiihyi kedea ngaa man ucaami yi ruohdhi.” ");
INSERT INTO lwo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Maa abeehr Jeacuue ngo kea, “Gihn peehnyu, lum yea kwihyu. Giih raahm kuohm ge uyug riha ge uromu ke guumo ne?” E ngo agar gene ke maalo kob gene, “Ayiih! Ge uguum wane.” ");
INSERT INTO lwo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jeacuu adog rob kea, “Adiehr, wu uguum wa ka uguuma gen. Abea piih ukwiihya kedea ucaama padh an ne cub kuohn nu. Ge beehda kuohn yaa acub Wura gen yihr gen.” ");
INSERT INTO lwo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Naa abeehn goan jo oohre giih apaar ne lihng gihn arob waahd Jebeade, e cwihny gen arahnyo rog yaa nuu ariow. ");
INSERT INTO lwo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kaano arumo e ge acuohn Jeacuue ke bange ke kar ge cang urube kea, “Beehde ngahyu kejea ruohdh upiny kan ge daahd utiihy nyoge yihr gen ne nyoadh ngo kejea ge naa ruohdhe. Thiow jo doonge nyoge kaahn gene kaa cing me raaj ne nyoadh ruohdh gen. ");
INSERT INTO lwo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Abea ruohdh maru buu uneehn ruohdh gihr wiih piny kan, bang gihn ngaa doohng ne ruohdh yihru e naa ngaa unahg ubaahng gihru. ");
INSERT INTO lwo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","E ngaa wiihe ne maalo yi doohngo kiin nu e naa ngaa unahg baahng yihru. ");
INSERT INTO lwo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Unaa wa gihn nu keehd wun wa kwaad mara, a ge adoohng ne dhaano utaahngo, ge abeehn upiny kan ne tiihj yihr nyoge ne baahng. A kuu abeehno beere giih nyepinye ge ke tiihyo yihra e a apiih kar bahba, a abeehno beere wahya dhiila kaa cub oogo ne boadh nyoge me thoohdh.” ");
INSERT INTO lwo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yi waahdh a'aay Jeacuue geen Jeriiko ke jo waahdhe, e batien gen abuodh amahr nyoge buodho. ");
INSERT INTO lwo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kaano acaahdh Jeacuue caahdho tiehd keehd nyoge, e yaaj ariow maa acoor ge anaa apiih lag yooh. Naa angey gene ngo kejea Jeacuu e ne caahdh, e ge ake kwaago e doohn gen atihng gene maalo kejea, “Cedhree Ruohdh! Kwaar Deabid ngeer yeyi ke nying wan!” ");
INSERT INTO lwo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kaano e ge acuow nyoge cuowo uyaahl gen naa leng gene. Abea kihde now, e naa atihng gene doohn gen maalo ke kwaago, “Ruohdh! Kwaar Deabid ngeer yeyi ke nying wan!” ");
INSERT INTO lwo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kaano e Jeacuu ake cuungo ucuohde e ngo peehny gen kobe, “Wu daahd utiihya gihn yihru?” ");
INSERT INTO lwo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kob gene, “Cedhree ruohdh! Wa miid ngo uyabi nying wan!” ");
INSERT INTO lwo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kaano naa aniid Jeacuue ngoohng nying gen e aduune ayuog. Noono ugweele nying gen beere nying gen uyahbo. Gihn nu e nying gen aguo yahbo upahdh gene ne buodh batien Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Naa adoohng gene cahng keehd geen Jeruucalem, e ge Jeacuu ge acaa paajo me cuohn ne Bedhpeag ge ne buud Good Ulihbe. Kaano e Jeacuu joe kar ge ariow ge aoohre wong maalo kobe, ");
INSERT INTO lwo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Cidhu paan cuud nyumu, abea ge wahdhu e akaja uyoadu e ngo amag piny ke nyethiine buude. Goonyu gen ukahlu gen yihra kan. ");
INSERT INTO lwo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nea ngaa me peehny wun kea gihn e lonyu akaja e kea beehru ngo kejea, ‘Ruohdh e ne daahd gen kedea ge uguoe ke duuo yihru piow piow.’ ” ");
INSERT INTO lwo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gihn nu apahdh kare wa kaa agweed agamloohngjuoge ngo yi kitaab Juog kea, ");
INSERT INTO lwo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Robu ngo yihr yaa geen Jeruucalem umaany gene ruohdh gen ge beehn e ngo apiih wiih akaja me caahdh kaa nyethiine. Ree ayuge ne yahng wa ngaa me padh ruohdh kedea upaahre wiih akaja ge beehda laahy me tihng giih nyoge.” ");
INSERT INTO lwo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Noono e joe ge acidho utiihy gene wa kaa arob Jeacuue ngo yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Naa akahl akaja kedea nyethiine e waaro apeedh gene ke ngahy akaja maa nyethiine, upaahr Jeacuue wiih akaja. ");
INSERT INTO lwo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Amahr yaa ake caahdho keehd ge Jeacuu thiow waay gen apeedh gene piny ke bang yi yooh kedea nyoge mooge booge ge ajag gene ne peedh yi yooh ne wuor ngo. ");
INSERT INTO lwo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yi gihn nu e akuud yaa anaa wong maalo nyum Jeacuu kedea akuud yaa anaa dhe caahn ngahye, wahy poong akiid gene kiido e ge uwahr kob gene, “Wuoro kwaar Deabid. Dooj Juoge ngade ge abeehno ke yoohn Paar Maalo. Wuoro yaa ne Paar Maalo.” ");
INSERT INTO lwo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Naa awahdh Jeacuue geen Jeruucalem, e deeh ajuohj ree atihnge tihngo yi buur geew e nyoge upeehyu kob gene, “Beehda ngaa e gihn?” ");
INSERT INTO lwo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","E abeehr amahr nyoge kob gene, “Ngaan e naa Jeacuu ngad agamloohngjuog. Ngo beehda ngad geen Naajaread gihn yi piny Gaalili.” ");
INSERT INTO lwo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kaano awahdhe yi buur geew nu, e Jeacuu acaa yi laaro gihr Wod Juog gihr Jeruucalem maa arieme yaa ngeehw oogo kedea yaa ngeew nyepinye. Tharbeaje giih yaa waar ngiihny ge ajwange piny kedea utuge kuohn yaa ngeehw oogo ke winy me nahg ne giih kweehr. ");
INSERT INTO lwo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kaano ajoge nyepinye kedea e nyoge rieme ke oogo nu e ake rubo kea, “Ngo beehda gihn maa agweed yi kitaab Juog kejea, ‘Wod Juog beehda kar kwaj yihr Juog cog,’ abea e aman ayugu, ‘ne kar yaa kahw!’ ” ");
INSERT INTO lwo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nyoge maa acoor kedea nyoge maa angool ge abeehn bange yi laar gihr Wod Juog maa athiehdhe gen cang. ");
INSERT INTO lwo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jo doong yaa lam kedea yaa loohng Juog cwihny gen arahnyo naa aniid gene giih beeye ge gaahy nyoge ge ayug Jeacuue. Yaa ni cwihny gen arahnyo thiow bang gihn nyethen ge anaa ke kwaago yi Wod Juog e ge puoj Jeacuu kob gene, “Wuor kwaar Deabid.” ");
INSERT INTO lwo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kaano e Jeacuu apeehny gene kob gene, “Gihn rob nyethene ni ngo ulihngo yihri ne?” Maa abeehr Jeacuue ngo kea, “Ayiih, ngo ulihngo yihra. Lum Juog gihn anaa agweed yi kitaab Juog kuu anaa akwaanu ne? Lum agweed naa, ‘Puohny me ne cohg beehn oogo kii dhog nyethen.’ ” ");
INSERT INTO lwo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Batien gihn nu e Jeacuu a'aay oogo Jeruucalem ne ci ne niihno Bathany. ");
INSERT INTO lwo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ruuwow ke nyango e Jeacuu maa jo waahdhe ge apahdh yooh ne dog Jeruucalem abea ree anaa kahj. ");
INSERT INTO lwo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Naa alog Jeacuue wonge thaahng yooh e niid yaadh me wa dhuuro ubaahbe ke kar ngo ne pon ke nyethen dhuuro. Ge awahdhe thar ngo e booge ge naa ayoade abea kihd wong nyethiin dhuuro maa ayoade tooro. Gihn nu e dhuuro alame kea, “Ke wong cahng tihn kihd nyethiin buu cahgi yoado keehdo.” Ke wong kaano e dhuuro ake talo yi nyenij. ");
INSERT INTO lwo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Naa aniid jo waahdhe gihn ni ayug ree e ge ake cwaahng kwaade tooro, upeehny gene Jeacuu kob gene, “Yaadh gihn ni aguo talo ke naa diih?” ");
INSERT INTO lwo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Maa abeehr Jeacuue ngo kea, “A rob gihn maa athiir yihru kejea nea ayiihu ne cohg kejea Juog yihre ne teege ubahnge cwihnyu be daag nea wu ukwahyo yihre, e kwaad gihn ni atiihya rih dhuuro romu kaa tiihyo. E thiow padh kwaad gihn nu e keede cog, abea keehd deeh good ni duohng e romu kaa robo yihre kejea, ‘Aayi uthoohri rihi naam duohng.’ E gihn nu ngo ke tiihyo. ");
INSERT INTO lwo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nea yiiho maa athiir nud yihru kejea gihn kwayu ucub Juoge e kwaad gihn daahdu ke cwihnyu cang ukwahyu ke nyinge, ngo yoadu yoado.” ");
INSERT INTO lwo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Naa abeehn Jeacuu yi laaro gihr Wod Juog ne puohny ke nyoge e jo doong yaa lam maa jo doong paajo ge abeehn bange maa apeehny gene ngo kob gene, “Tee mari noono ngaa e naa acube yihri? Teeg gihn riemi yaa ngeehw oogo yi laaro gihr wod Juog?” ");
INSERT INTO lwo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Maa abeehr Jeacuue ngo yihr gen kea, “Thiow a daahd upeehnya wun. Nea wiihe aduu'u, e piehj gihru wiihe uduua thiow. ");
INSERT INTO lwo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ngaa e naa akob ngo yihr Joon Ngad Luogwahy kejea cube luogwahy yihr nyoge? Anahg dhaano utaahngo wale Juog ke ngude e naa akob ngo yihre?” Kaano e ge ake thubo ke rob ke rog gen kob gene, “Awaahn ni nea wo urubo yihre kejea tee ayoad Joone ke bang Juog, e ngo duoge duogo kobe, ‘Abea gihn e bahnge lum Joon kuu anaa ayiiho?’ ");
INSERT INTO lwo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Abea nea wo urubo kejea tee ayoade ke bang dhaano utaahngo, e nyoge ge taahny rogo bang gihn beehda e ngahy gene cang kejea Joon anahg agamloohngjuog me duohng.” ");
INSERT INTO lwo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Naa agange wudh gen e ge ake rubo yihr Jeacuu kob gene, “Ngo kwihy wane.” Kob Jeacuu yihr gen, “A thiow e ngaa acub tee yihra ngo be roba yihru.” ");
INSERT INTO lwo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Maa abar Jeacuue maalo ke rob kea, “Boaru yea ucaale gihn. Umodho coon dhaano anaa anudo me yihre ne waahde ariow. Maa acea bang waahde ge duohng urube yihr ngo kejea, ‘Nyieh ci yi puohdho tihn noon ni ne tiihj.’ ");
INSERT INTO lwo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Uguo nyedhoohge ngo ke gaahro kea, ‘A be daahd ci ne tiihj yi puohdho tihn.’ Abea batiene e wiihe apare beer mee maa acea ne tiihj yi puohdho. ");
INSERT INTO lwo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Wur gen acahg cidho bang waahde ge thiin uteede ngo yihre kejea cea yi puohdho ne tiihj. Maa ayiih nyedhoohge ngo kea, ‘Ayiih, abaa a ucidhi.’ Abea ngo kuu abeehn ne ci yi puohdho. ");
INSERT INTO lwo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Awaahn ni ngaa kiin nyedhoohy ni ariow e naa atiihy gihn daahd wur gene?” Kob gene, “Ngad umodho.” E ngo abeehr Jeacuue beehro kea, “A rob adiehr yihru kejea yaa gwaaj cuol kedea maahn koag ke daahd cuow, ge ne kuong Dhaahr Juog ke yoado umodho yihru. ");
INSERT INTO lwo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bang gihn Joon abeehno ne nyoadh beehdo naa abiohgrwaal yihru, abea lume kuu ayiihu, yaa gwaay cuol kedea maahn daahd cuow ge nuu ukuong Dhaahr Juog ke yoado bang gihn, gihn atiihy Joon Ngad Luogwahye ngo ayiih gene. Abea maru, wu akweer ne ped. E thiow keehd maa aniidu gen e ge utiihyo ke dhe yooh me beer, e wudhu kuu awaaru ne weey weey ne maan anyoohne giihu kedea lum Juog kuu ayiiho, neehn maa amaan gene anyoohne giih gen kedea uyiih gene lum Juog. ");
INSERT INTO lwo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Lihngu ucaale gihn. Coon umodho dhaano anudo me yihre ne puohdho me duohng. Puohdho gihn ngo anaa aciele piny ke roog kedea upiidhe. Buur me yea laaj anaa akoanye yi puohdho thiow ne kar biij nyethea yen ne koongo kedea deeh peehm me baahr anaa ayuge ne gihr koar puohdho. Naa ayuge giih nu cang e puohdho ajore oogo yihr nyoge mooge ucea ne weel. ");
INSERT INTO lwo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Naa arome kar cieg nyepinye, e yaa tiihj giihe ge aoohre yi puohdho bang yaa anaa ajor puohdho beere kur mare ke cubo yihdh giih puohdho ge acieg. ");
INSERT INTO lwo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Naa awahnh yaa tiihj giihe yi puohdho bang yaa ajuro, e ge akwahny gene ke piny upuohd dhaano acielo ne cohg kedea ngaa moogo anahg kedea uyoad ngaa moogo ubahne ke leele. ");
INSERT INTO lwo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Maa acahg ngad puohdhe yaa tiihj mooge me thoohdh ke oohro keehdo. Abea e awahnh gene, e kwaad gihn ayug rog yaa umodho adog kaa tiihyo rog gen. ");
INSERT INTO lwo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Naa aniid ngad puohdhe ngo wa maano e ake rubo ke cwihnye kea, ‘Beer ngweehn muu uoohra waahda ge acielo ka moogo e ge utud rih ngo.’ Maa aoohre waahde bang gen. ");
INSERT INTO lwo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Naa aniid yaa nii puohdhe waahd ngad puohdho e ubeehno ke ka me baahr e ge ake rubo ke rog gen kob gene, ‘Waahd ngad puohdho e ne caa beehn. Kwahgo ngo piny unahgo ngo bang gihn e naa ngaan ulag giih wahn. Nea ngo anahgo e giih nu ge udoohng yihro.’ ");
INSERT INTO lwo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","E awahnh nyedhoohge e ngo akwahny gene ke piny uteele oogo yi puohdho unahge lag puohdho. ");
INSERT INTO lwo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nea ngad puohdho ubeehno e utiihy gihn rog yaa ajor puohdho?” ");
INSERT INTO lwo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Maa abeehr gene ngo kob gene, “Kwaad yaa nu reje ge buu uwiie. Nying gen urwaahnye kedea ujore puohdho oogo keehdo yihr nyoge mooge me beey me cub kur mare.” ");
INSERT INTO lwo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kob Jeacuu kea, “Nye yaage! Gihn agweed yi kitaab Juog kuu anaa akwaano, naa agweede naa, ‘Kaaw gihn akweer yaa geere keehde, e naa adoohng ne meehn wod. Gihn nu beehda tiihy Juog, e Juog Aciehg tiihy gihn me gaahy nyoge.’ ");
INSERT INTO lwo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ngo teeda teedo yihru kejea Dhaahr Juog, wu buu umeehg cidh yea unahge ke nyoge maa aleye me yug gihn me beer ge nuu umeehg cidho yea.  ");
INSERT INTO lwo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ngaa pahdh wiih leelo raahm rog yoade yoado, abea ngaa pahdh leele wiihe ngwiilo dhiile kaa yoado.” ");
INSERT INTO lwo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Naa alihng jo doong yaa lam maa Paarijea lum Jeacuu e cwihny gen arahnyo bang gihn angey gene kejea Jeacuu gaaj gen. ");
INSERT INTO lwo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Cwihny gen anaa kwahg ngo piny kaano abea ge atud ke wahy gen yihr amahr nyoge bang gihn ngahy nyoge kejea Jeacuu beehda agamloohngjuog. ");
INSERT INTO lwo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Cahng man keehdo e Jeacuu adog rob keehd ucaale yihr gen kea, ");
INSERT INTO lwo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Dhaahr Juog uroma ke rih ruohdh paajo maa ayug yaay ke nying gwiir kaahny waahde. ");
INSERT INTO lwo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Noono uoohre yaa tiihj giihe bang yaa acuohne. Abea naa arobe yihr yaa ngo, e ge akweer ne bihng kejea ge be ci yi kaahny. ");
INSERT INTO lwo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ruohdh, nyoge mooge acahge ke oohro ke dhog me nyaahn yihr yaa nu kea, ‘Teedu ngo yihr yaa nu kejea miohre giiha ge anahga kedea nyepinye ge agwiir cang, caahn e laar gene beehno.’ ");
INSERT INTO lwo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Abea kihde now. Yaa nu gihn acuohn ruohdhe gen ngo adhaahr gene, noono ukeedh gene ne tiihy giih gen mooge. Nyoge mooge ge aci yihdh puohdh kedea nyoge mooge ge aci kuohn tiihj giih gen, ");
INSERT INTO lwo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","kedea nyoge mooge ge ane taam taam rog yaa aoohr unahg gene gen. ");
INSERT INTO lwo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Gihn nu, e ruohdh cwihnye arahnyo uoohre acaakere giihe, unahg gene taam taam rog yaa anaah maa anahg acaakere gen kedea ucwiny geen gen oogo cang. ");
INSERT INTO lwo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Batien gihn nu e ruohdh yaa tiihj ge acuohne urube yihr gen kea, ‘Kwaad giih daahd cang ne gwiir kaahny ge ayug, abea yaa anaa acuohn ge nyoge me gihr nying gen tooro naa akweer gene ke beehn yi kaahny. ");
INSERT INTO lwo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Awaahn ni cidhu ke bang yihdh yiehdhe ne cuohn kwaad ngaan yoadu ubeehne paajo kan.’ ");
INSERT INTO lwo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Noono e yaa tiihj ge acaa yiehdh agaahg yiehdhe ne cong yaa yoad gene ne beehn yi kaahny paar ruohdh. Kwaad ngaan ayoad gene now ngo acuohn e kiin nyoge be kwany gene, ngaa me beer kedea ngaa me raaj. Maa abeehn paar ruohdhe upahnge ne pej ke nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Naa apiih nyoge ne raahj e ruohdh abeehno ne maany weehle giihe. Kaano e wonge anaa rag rih weehno me kuu angahbo ke waahr ngaab kar kaahny, ");
INSERT INTO lwo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","maa apeehnye ngo kobe, ‘Nye goma, rihi amadi kiin nyoge kan ke naa diih abea waahr ngaab tooro yihri?’ Maa ane bang nyine leng utoor gihn maa abeehre. ");
INSERT INTO lwo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Kaano e ruohdh dhee aloge ke bang yaa tiihj giihe mooge urube kejea, ‘Tuohyu tiene ke baahde uthoohru ngo oogo yi muudho ka yuog nyoge ke lan ngoohng wong e lag gen kaany gene kaanyo ke nying raahm.’ ");
INSERT INTO lwo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ngo unaa wa gihn nu thiow. Nyoge me thoohdh ge naa acuohn abea nyoge me noog kiin gen ge naa akwany.” ");
INSERT INTO lwo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Cahng ni keehdo e Paarijea ge acaa ne mad ne cej dhe Jeacuu beere gihn me raaj me maan loohnge robe robo. ");
INSERT INTO lwo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kaano e nyoge mooge keew gen kedea yaa batien Eroade ge aoohr gene bang Jeacuu. Naa abeehn gene e kob gene kejea, “Ngad puohny! Ngahy wane kejea yih rob athiir kedea yih puohny athere giih agweehg Juoge ke nying dhaano utaahngo. Thiow wiihi thihr yi gihn teed nyoge mooge ke nyingi, bang gihn cwihnyi be logi yi gihr dhaano utaahngo. ");
INSERT INTO lwo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Awaahn ni wa daahd ngo urobi nyepiny acielo yihr wan ungahy nyoge ngo cang ke nying cuol gihn cub yihr Jaah Roama. Jaah gihr Roama ge amag paaro. Lum mari beehda gihn! Beehda gihn maa arob loohng Juoge yihro kejea gwaay cuol yihr Jaah Roama ne wale ngo amahne?” ");
INSERT INTO lwo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Abea gihn raaj ge agweehg gene ke cwihny gen ngo angeye maa arube yihr gen kobe, “Nye jo wan, wu kwaad yaa waane me ngihde e tum an beere dhiia kadu kado! ");
INSERT INTO lwo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nyoadhu ngiihny jwaar ne cuol yihra do.” Maa akahl wong grihj yihre. ");
INSERT INTO lwo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Naa akaabe grihj e ngo arubo kea, “Cuuro gihr ngaa kedea nying ngaa ge naa agweed ngahy grihj gihn?” ");
INSERT INTO lwo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Maa arob gene ngo kob gene, “Beehda cuuro kedea nying Jaah Roama.” Noono e Jeacuu arubo kea, “Beer, cubu kwaad gihn beehda gihr Jaah Roama yihr Jaah Roama kedea cubu gihn beehda gihr Juog yihr Juog.” ");
INSERT INTO lwo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Naa alihng gene lum nu, e ge agaahy unahg wudh gene cohd udhiil gene aay uwii gene Jeacuu piny. ");
INSERT INTO lwo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Caaduucean kob gene nyoge be cahr. Cahng ni, e ge abeehn bang Jeacuu dahng ne peehny ngo kob gene, ");
INSERT INTO lwo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ngad puohny, anaa arob loohng Moaje kejea, ‘Nea dhaano athow uwiie ciihe piny e yihre tooro nyethiin, e ngaan umen athow, ciih umen geere geero beere yea ngo nyuole nyuolo.’ ");
INSERT INTO lwo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Anudo ke wuud meeho abiihjberiow maa anaa abeed kan ke wan. Ngaa duohng gen anaa abeehn ne nyuohm maa athowe e yihre tooro nyethiin. Naa athowe ke wiihe now e ciihe awiie ne geero yihr umen. ");
INSERT INTO lwo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Umen, thiow, abeehn ne thoo ke wiihe now. Gihn nu acaahdho ne naang uwahdhe yi beriown umiiho. Ngaan doohng ke dhaago uthoo abea nyethiin me wiie yi koohr dhaago tooro. ");
INSERT INTO lwo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Naa athow yaa nu cang, e dhaago ake thoo. ");
INSERT INTO lwo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Caahn arumo, nea nyoge ucahro yi thoo wa ka robi, e dhaar nu unahg ciih ngaa kiin gen bang gihn ge abeehdo keehd ngo cang?” ");
INSERT INTO lwo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Maa abeehr Jeacuue ngo yihr gen kea, “Wa luube ge abaaju ne cohg! Tee Juog kedea giih agweed yi kitaab Juog ke nying cahro yihdh gen poohd kuu adeadu! ");
INSERT INTO lwo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ngaa muu unahg dhaar nu ciihe ngo utooro. Ge ucahr nyoge batien thoo e ge uke roomo ke wuohdjuog ge be nyoohmo. Cahng umeehg Juoge nyoge cahro e gihn me cuohn ne nyuohm utooro ke rog. ");
INSERT INTO lwo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Gihn anaa arob Juoge yihr Moaje ke nying cahro batien thoo ngo dhiila kaa robo yihru udeadu yea beer mee. Ngo agweed yi kitaab Juog e gihn arob Juoge kobe, ");
INSERT INTO lwo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘A Juog wuor Abraahme kedea Yijaag maa Jeakob.’ Nea Juog beehda Juog ge kuowo naa acoon, e gihn nu nyoadh ngo kejea ge kuowo ge kuow ka nahg gene yea.” ");
INSERT INTO lwo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Naa alihng yaa amahdo puohny gihr Jeacuu, e ge ake cwaahng yi kwaad loohng me wa gihn nu. ");
INSERT INTO lwo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Naa alihng Paarijea ngo kejea Jeacuu Caaduucean ge ataaye e rog gen acong gene ka maa acielo. ");
INSERT INTO lwo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Maa beehn dhaano aciele kiin gen maa apuohny keehd luub yea loohng upeehnye Jeacuu e tum ngo kea, ");
INSERT INTO lwo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ngad puohny, loohng aweehne e ne wiihe ne maalo keew loohng Juog cang?” ");
INSERT INTO lwo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Maa abeehr Jeacuue ngo kea, “ ‘Nhyaar Juog Ruohdhi ke aduuni beehde ke wahyi beehde ke wiihi beehde.’ ");
INSERT INTO lwo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lum ni e naa loohng me wiihe ne maalo. ");
INSERT INTO lwo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Riown loohnge me room wa maano beehda, ‘Nhyaar wadu wa kwaad ka nhyaari rihi kii ngo.’ ");
INSERT INTO lwo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Loohnge giih arob Moaje cang kedea giih arob yaa agamloohngjuoge ge mahd yihdh loohnge giih ni ariow.” ");
INSERT INTO lwo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Naa aniid Jeacuue ngo kejea Paarijea mooge rog gen acong gene ka maa acielo e ge apeehnye kea, ");
INSERT INTO lwo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gihn e naa aparu ke nying Ngad Boadh nyoge? Nea maru kobu beehda waahd ngaa?” Kob gene, “Ngo beehda kwaar Deabid.” ");
INSERT INTO lwo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kob Jeacuue, “Nea ngo kwaar Deabid e gihn e naa ameehg Wahy Juoge Deabid cuohn ngo ne Ruohdh naa anaa akoohb Deabide kea, ");
INSERT INTO lwo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Juog arubo yihr Ruohdha kea, “Piihi ukwiihya kan uwahdhe ka uyuga yaa mahni ne gihr thaahdh tieni.” ’ ");
INSERT INTO lwo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Deabid kwaare cahge cuohne ne ruohdhe ke naa diih?” ");
INSERT INTO lwo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Noono e ngaa maa arom lum Jeacuu ke beehro tooro. E thiow, ke wong cahng nu e wudh gen ake ngoadh ne peehny Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Cahng ni e Jeacuu ake rubo yihr jo waahdhe kedea amahr yaa amahdo kea, ");
INSERT INTO lwo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Yaa loohng Juog kedea Paarijea ge ne ngahy yihdh loohng Moaje. ");
INSERT INTO lwo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Caahn e kwaad giih rob gene cang yihru dhiilu kaa lihngo kedea uyugu gen. Abea giih tiihy gene ge keá ngooru ne weey weey, bang gihn ge tiihy giih me be roohm ke luub rob gene. ");
INSERT INTO lwo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ge nhyaar kwaan amahr loohng Juog me thoohdh yi wudh nyoge mooge ne maa kedea unahg gene nyoge ke mag loohnge. Abea kur mar gen, kihd dhaano acielo me kony gene tooro ne mag loohng Juog. ");
INSERT INTO lwo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ge beehda yaa nhyaam. Kwaad gihn tiihy gene cang ge daahd ngo uniide. Coohro maa atuohj wihj wa te ngaag, ke yugo laaj uneehne neehno ka me baahr kedea dhog waare ke yugo baahr ne ywar ywar, beere kaa awuohb gene kii ngo ke niido. ");
INSERT INTO lwo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Thiow ge nhyaar piih kuohn beey beey nea wihj acong, kuohn karaame wale yihdh wuud amaade. ");
INSERT INTO lwo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Dahng ge daahd ngo umaahdh gen ke wuohdo ke cing ariow ke bang yi paajo kedea ge daahd ucuohn gen ne yaa puohny wa mar yaa puohny nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Abea wun, rogu keá cuohnu ne yaa puohny, bang gihn wu nyethen dhaano acielo kedea ngad puohny gihru beehda acielo cog e beehda Ngad Boadh nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","E thiow keá ne ngaan cuohnu naa ‘Abaa’ upiny kan, bang gihn Wuru ge ne Maalo beehda acielo cog. ");
INSERT INTO lwo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Rogu keá meehgu cuohno ne yaa puohny, bang gihn ngad puohny gihru beehda acielo cog, e beehda Ngad Boadh nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ngaan duohng nyumu ree uyoade ne ngad tiihj yihru. ");
INSERT INTO lwo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kwaad ngaan cub cwihnye yi daahd ruohdh ke nying yoad gihn me beer, e ngaan nu ree uyoade ne dhaano now me gihn me ne yihre tooro. Abea ngaan yug ree ne dhaano now e ngaan nu ree uyoade ne ruohdh uyoade gihn me beer. ");
INSERT INTO lwo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Wu yaa loohng Juog maa Paarijea, wu ni yi gihn me raaj ne waany. Yihdhu thuudh ne cohg! Dhe yoohn kedh nyoge yi Dhaahr Juog agahlu yihr nyoge ke dhe yoohn puohny gihru. Ngahyu ngo kejea wu ke ngudu Dhaahr Juog buu uyoadu, wu e gahl yaa daahd mon yi Dhaahr Juog oogo. ");
INSERT INTO lwo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Wu yaa loohng maa Paarijea, wu ni yi gihn me raaj ne waany. Yihdhu thuudh ne cohg. Wu ubuohj duugi ke cej nyoge me padh yaa Judea beere ge udoohng ne yaa buodh wun. Ge beehn dhaano aciele udoohnge ne ngadu e ngo logu logo ke dhe yoohn puohnyu ne ngaa me raaj! Me raahye akaal wiih raahyo gihru ge ukedh Juoge wun paar maaj ke nyinge. ");
INSERT INTO lwo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Yihdhu thuudh ne cohg! Wu neehn coohre me piej coohre mooge! Nyoge puohnyu puohnyo ke luub toohd kobu, ‘Nea ngaa kuohng ree ke Wod Juog, e akoohngo gihre be nieng abea nea ngaa kuohng ree ke dhaahb gihn yi Wod Juog e akoohngo gihre unieng.’ ");
INSERT INTO lwo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wudhu kaa ane thihdh ne weey weey! Maa weehne e ne wiihe ne maalo, beehda dhaahb ne wale Wod Juog e yug dhaahb ne gihr wuor Juog? ");
INSERT INTO lwo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Wu urubo thiow kobu ngaan kuohng ree keehd kar lam giih nyepinye yihr Juog e akoohngo gihre be nieng, abea ngaan kuohng ree ke giih acub piny yi kar lam e akoohngo gihre unieng. ");
INSERT INTO lwo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wudhu kaa ane thihdh ne cohg! Maa weehne en wiihe ne maalo, beehda giih cub yi kar lam ne wale kar lam ke ngude e weehg Juog yiih giih cub yea? ");
INSERT INTO lwo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nea dhaano ree akuohnge ke kar lam e nyoadh ngo kejea dhaano ree akuohnge keehd kar lam kedea giih ne yi kar lam thiow ");
INSERT INTO lwo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","kedea nea dhaano ree akuohnge ke Wod Juog e nyoadh ngo kejea dhaano ree akuohnge ke Wod Juog kedea ke Juog thiow ge beed yi Wod Juog. ");
INSERT INTO lwo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Keehdo thiow nea dhaano ree akuohnge ke koom Dhaahr Juog, e ree akuohnge ke koom gihr Juog kedea Juog ngaa piih wiih koom. ");
INSERT INTO lwo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Wu yaa loohng maa Paarijea, wu nii gihn me raaj ne waany. Yihdhu thuudh ne cohg. Nyepinye koamu ke piny ne koame apaar, keehd cedha kedea kad bey noono ukaabu koam acielo ucubu ngo piny yihr Juog wa kaa ateed loohng Juoge ngo. Abea giih me teeg me rob loohng Juoge me neehn dhe yoohn beehdo me beer naa abiohgrwaal ke rog kedea luu cwihny caahn kedea ne tiihy gihn arob dhaane kea ngo utiihye ge wiiu ke piny. Nea kaa ngo e kwaad giih nu ge ne tiihyu ucubu koam acielo piny thiow keew giih koam naa apaar. ");
INSERT INTO lwo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wu neehn coohre me piej coohre mooge! Kobu alwango kwadhu ke oogo wudh piih maadhu, abea gihn muonyu yi yihdhu beehda gihn me neehn amana ke doohngo! ");
INSERT INTO lwo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Wu yaa loohng maa Paarijea, wu nii gihn me raaj ne waany! Yihdhu thuudh ne cohg. Wu beehda yaa puoge! Kobu wu nyoge me beeye, abea koohdhu apahng ke giih tiel kedea par dhe yoohn kwal giih nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wu Paarijea wu neehn coohre! Wiiu giih tiel piny umodho ce rubu kejea wu nyoge me beeye arumo! ");
INSERT INTO lwo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Wu yaa loohng Juog maa Paarijea wu nii gihn me raaj ne waany. Yihdhu thuudh ne cohg. Wu room kaa leehde maa ageer ke wuohbo! Ge uneehno e ge awuohbo ke oogo, abea cuu nyoge ge naa agaag alongthihn kedea koohm nyoge maa atob. ");
INSERT INTO lwo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wu neehn leehde thiow, bang gihn nyoge wu niid gene wa nyoge maa abiohgrwaal, abea yihdhu alongthihn pahng ke giih thuudh yej kedea anyoohne. ");
INSERT INTO lwo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Wu yaa loohng maa Paarijea, wu nii gihn me raaj ne waany. Yihdhu thuudh ne cohg! Rogu acubu piny ne gwiir kuohn koany yaa agamloohngjuog yea, ubuohju kaa tieng leele me cub wudh leehde giih nyoge maa abiohgrwaale, ");
INSERT INTO lwo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","beere rogu kangu kango thiow kejea nea wu ne naa kar ge kuowu naa coon, e yaa agamloohngjuog ge be nuu naah. ");
INSERT INTO lwo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Athiir ne cohg! Kaa arobu ke dhogu kejea wu beehda kwaay yaa anaa anaahng yaa agamloohngjuog! ");
INSERT INTO lwo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Beer! Baru maalo ke tiihyu ne thaahb gihn anaa athob ge kuowu coon. ");
INSERT INTO lwo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Wu beehda kwaad koohdh nyoge me reje ne cohg! Wu beehda koohdh thoohne, caahn e wu ubodh ke naa diih ne ci Paar Maaj! ");
INSERT INTO lwo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Padh e naa gihn agweed yi kitaab Juog noono kejea Juog arubo kejea, yaa agamloohngjuog giiha kedea yaa ngahy luube ge uoohra yihru, abea wu upahdh rog gen unahgu mooge kiin gen kedea uguru mooge rog yen maa ariihw. Kedea mooge dahng ge upuohdu ke ngeero yi wod amaad e mooge ge ukaahnu ke cing me reje ke bang yihdh geedhe. ");
INSERT INTO lwo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nea wa maano, e rem yaa anahg cang udo rogu ukihm wun. Wu ureehg ke wun giih yaa yihdh ge bahdh naa anahg, ke kaa athube ke wiih Abel, ubeehne rih Jakarya waahd Barcaaya ngaan anaa anahgu wiih abar buud kar lam. ");
INSERT INTO lwo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Athiir e ne roba yihru, ukihm ke nying thon yaa nu upahdh wudhu, wu yaa nud awaahn ni. ");
INSERT INTO lwo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yih geen Jeruucalem! Yaa agamloohngjuog ge anahgi kedea yaa aoohr Juoge yihri ge abahni ke leele! A abuohj tiel me thoohdh kaa a koal yaai thaahdh baahda wa gihr jieno me boab nyethene. Abea kihde now, yih ukweer ke an ne weey weey. ");
INSERT INTO lwo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Maahnyu do! Wod Juog awii piny utoor Juoge yea. ");
INSERT INTO lwo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Awaahn kan, kihda buu ucahgi ke niido keehdo uwahdhe cahng ukoohbi kejea, ‘Juog Cedhree dooj ngaan abeehn ne rob ke nying Juog Ruohdh.’ ” ");
INSERT INTO lwo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kaano e Jeacuu abeehn oogo yi laaro gihr wod Juog upahdhe yooh. Abea nye kaa acaahdhe caahdho e jo waahdhe ge anyiihng bange ne nyoadh kaa ageer Wod Juog ne wuob kii ngo yihre. ");
INSERT INTO lwo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Maa abeehr Jeacuue ngo yihr gen kobe, “Beer wuohbe aniida, abea keehd maano niidu ngo e awuohbo, e roba robo yihru kejea ngo uthuohm piny utoor wong leelo acielo muu doohng wiih wad gen. Ngo ujwang piny ne buohb.” ");
INSERT INTO lwo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Naa abeehn gene wiih Good Ulihbe, e Jeacuu apiih kare keede. Kaano e jo waahdhe rog gen akwany gene ubeehn gene bange maa apeehny gene ngo kejea, “Teed ngo yihr wan unahg cahng weehne e nuu uthuohm Wod Juog piny? Kedea gihn e nuu uyug ree ne nyoadh beehni ge uduui kedea gihn e nuu unyoadh ngo kejea cahng gug piny awahnho?” ");
INSERT INTO lwo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Maa abeehr Jeacuue ngo yihr gen kea, “Cubu cwihnyu piny beer mee ubahnge rogu be meehgu dwaahngo, ");
INSERT INTO lwo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","bang gihn amahr nyoge me dwaahng wun ke nying giih uyug rog gen ge ubeehn ke batiena e ge rubo kaa nyinga e ngaa man ukoohbo kea, ‘A naa Jeacuu Ngad Boadh nyoge.’ Yaan nu, thoohdh nyoge urom gene ke dwaahngo. ");
INSERT INTO lwo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Thiow linye bang gen ulihngu kedea dhog uwahnh bangu ke nying linye mooge me ne kuohn me bahye. Abea yihdhu keá baadh, bang gihn, giih nu rog gen kuong gene kaa tiihyo umodho e cahng gug piny poohd kuu awahnho. ");
INSERT INTO lwo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Paajo yea upaah ne dahg ubeehn yaa tien paajo acielo ukag gene ke rog gen kedea dhaahre giih wiih piny ge ukag naa arwaadh ke rog gen. Deeh kahj me duohng upahdh kedea amahr ayahng ngoom me thoohdh rog gen uyug gene ke bang kuohn me thoohdh. ");
INSERT INTO lwo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Giih nu ge unahg ka uthub giih reje ge ukuong tuohl, abea keehd maano e ge room kaa raahm nyoohdo e thub maahdh batiene e bar maalo ke raahm keraahyo. ");
INSERT INTO lwo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Wu umaan thaahye bang gihn ayiihu luma udoohngu ne jo'a. Noono wu umag ukedh wun ne puohdo kedea unahg wun. ");
INSERT INTO lwo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ke nying naahg e yaa ayiiho me thoohdh wudh gen uwaar gene ukweer gene ke lum Juog. Kedea yaa ayiiho mooge ge upiih ne luom yaa gen kedea ne maan gen. ");
INSERT INTO lwo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Amahr nyoge maa yaa ucahb, kob gene ge agamloohngjuog, ge utuohl udwaahng gene nyoge me thoohdh. ");
INSERT INTO lwo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nhyaahro kiin nyoge me thoohdh udoohng thiin, bang gihn ukuumo adoohng e ngo tooro upiny. ");
INSERT INTO lwo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Abea kwaad ngaan umag aduune beer mee uwahdhe yi gug nihn ubahnge ree be rome dwaahngo, e ngaan nu boadh wahy uyoade. ");
INSERT INTO lwo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Thiow Ciig Beer ke nying Dhaahr Juog upuohny kedea unyaaye ke bang upiny yihr nyoge cang. Batiene e cahng gug piny uwahnh arumo. ");
INSERT INTO lwo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Cahng uniidu giih reje ngo ubeehn, cahng ubeehn Ruohdh atiihb ukeehge ujwaahge Wod Juog gihr Jeruucalem udoohnge ne ka me nyoge Juog be wuor gene yea wa kaa agweed Daaniele agamloohngjuoge ngo. (Kaano e nuu ubeehn ngaa kwaahno upare wiihe beer mee) ");
INSERT INTO lwo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","kedea ubeehn yaa beed piny Judea ugoohd gene ke ngweej ne ci ne pahno yihdh bung yihdh goode. ");
INSERT INTO lwo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ngaa ayuud gihn nu e ngo ne piny kane e ngo keá do wod ne cej gihr nyepiny ");
INSERT INTO lwo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","kedea ngaa me nii puohdhe e ngo keá do paajo ne kaab waahnye. ");
INSERT INTO lwo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Unahg gihn me uraaj keter yihr maahn me yaje kedea maahn dhuohdho bang gihn ge buu urom ngweej ne cohg. ");
INSERT INTO lwo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Abea kwayu Juog beere gihn nu ree be yuge e piny aboar wale yi cahng Cabadh ge mahn tiihj yea. ");
INSERT INTO lwo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bang gihn raahm upahdh cahng nu, unahg raahm me raaj me kuu akuong pahdh upiny ke cahng anaa acag Juoge wiih piny uwahdhe awaahn kedea ree buu ucahge ke bero cahng moogo keehdo. ");
INSERT INTO lwo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nea Juog Ruohdh ngo be ne guoe ke gweehgo ne ngol yihdh nihn nu, e dhaano utaahngo me ne bodh ne tooro. Abea ke nying yaae e nihn nu ge uyuge noog. ");
INSERT INTO lwo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Noono nea ngaa me koohbo yihru yihdh nihn nu kea, ‘Ngad Boadh nyoge ngo ne cuudi ke ca,’ wale ‘E man kan,’ e lume keá yiihu. ");
INSERT INTO lwo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ngaan rubo wa maano lume keá yiihu bang gihn amahr yaa dwaahngo me thoohdh ge utuohl, e kwaad dhaano urubo kejea e naa Ngad Boadh nyoge wale kea e agamloohngjuog. Ge utiihyo keehd giih me thoohdh me gaahy nyoge ne dwaahng nyoge kedea nea kare nud, keehd yaa akwany Juoge ne yaae e ge udwaahng gene. ");
INSERT INTO lwo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Cubu wudhu piny! Wu atoohna awaahn ni kejea giih nu rog gen utiihy gene. ");
INSERT INTO lwo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Thiow nea ngaa me rubo kejea, ‘Ngad Boadh nyoge nud yi ukang kun caadi,’ e wu keá cidho wale ngaa me koohbo kejea, ‘Ngo nii dwaar yi wod,’ e lume keá yiihu. ");
INSERT INTO lwo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bang gihn a ge adoohng ne dhaano utaahngo a ubeehn ne dahr wa maahny kodh ge coohd yea maalo uniid yaa kur nyange ngo kedea uniid yaa kur thiehno ngo thiow. ");
INSERT INTO lwo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Coar maa acudhe wudh gen mad gene ke ka maa athow laahye yea. ");
INSERT INTO lwo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ke batien giih raahm ‘e wong cahng naa lihb kedea dwaahy buu ugeed maa ciehr ge upahdh ne budh budh ke yoohn maalo kedea giih nii maalo rog gen uyahng gene.’ ");
INSERT INTO lwo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Kaano arumo, e gihn nyoadh beehna a ge adoohng ne dhaano utaahngo ngo uniid yi Maalo kedea ubeehn yaa padh yaa ayiiho cang ke bang wiih piny upam gene thaahdh gen ke nying ukihm gihn upahdh wudh gen. Kaano e a ge adoohng ne dhaano utaahngo, a uniid e a ubeehno kii yi lwahd keehd tee mara kedea e wiiha amoar. ");
INSERT INTO lwo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kaano e wuohdjuog ge uoohre e ge koadh baye me doohn gen uyaay keraahyo ne cong jo'a naa akwanya ke bang upiny cang keehd kuohne me baahye. ");
INSERT INTO lwo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Beehna roma ke rih dhuuro. Nea ngo uthubo ke lodho, e ngahj kejea oohro adoohng cahng. ");
INSERT INTO lwo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Thiow neehn gihn nu, cahng niidu ngo e giih ateeda rog gen ayug gene, kea ngahyu ngo kejea beehna adoohng cahng. ");
INSERT INTO lwo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Adiehr e ne roba yihru kejea wu yaa nud awaahn, wu buu uthow cange e giih roba yihru rog gen poohd kuu atiihy gene. ");
INSERT INTO lwo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Maalo kedea upiny kan ge utooro, abea luma ree utiinge kare. ");
INSERT INTO lwo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Abea cahng uduua ngaa me ngahy ngo tooro. Ngo kwihj wuohdjuoge wale keehd an thiow cahng ngo kedea caang ngo ge kwihya. Juog Wura e keede e ne ngahy cahng ngo. ");
INSERT INTO lwo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Beehna a ge adoohng ne dhaano utaahngo, ngo uroom kaa gihn atiihy ree yihdh nihn aboar gihr Nooh. ");
INSERT INTO lwo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yihdh nihn nu, e aboar puud kuu abeehno, e nyoge wudh ge anaa athoohr gene piny ne bahrahj now e ge maadh kuong kedea yug kahnye ke bang yihdh miehr uwahdhe cahng ayedh Noohe yi baabuur keehd joe. ");
INSERT INTO lwo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Gihn me raaj ge adoohng cahng ke pahdh wudh gen ngo akwihy gene uwahdhe kaa athub aboare kedea umoal aboare gen piny. Beehna a ge adoohng ne dhaano utaahngo uneehn gihn nu thiow, bang gihn ngaa me ngahy ngo utooro. ");
INSERT INTO lwo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kiin nyoge ulele ke lel me ne cohg. Ka moogo e cuow ariow ge utiihyo yi puohdho, e dhaano acielo maa ayiiho ukwany, udoohng ngaa kuu ayiiho. ");
INSERT INTO lwo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wale ka mooge e maahn ariow ge uoohdo upany e dhaago acielo maa ayiiho e nuu ukwany. ");
INSERT INTO lwo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Noono jo'a, yabu nyingu beer mee bang gihn cahng ubeehn Ruohdhu ngo kwihyu ne weey weey. ");
INSERT INTO lwo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ngo padh gihn me kwihyu! Nea ngad paajo cahng beehn ngad kahwe ne kahw paare ngo nea ngahyo, e ngaan nu ne ruung e be nen ne koar paare. ");
INSERT INTO lwo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wa gihn nu thiow, wu keá gwaahg bang gihn cahng beehna, a ge adoohng ne dhaano utaahngo, ngo kwihyu. ");
INSERT INTO lwo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kwaad ubaahng me ngihde e ne leej naa ngo ngaa me beer kedea giih nyepinye ngahye kaa gwiiro? Ubaahng me beer wa gihn nu beehda ngaa ateede yihre naa mage baahng mooge beer mee kedea upaahnge caame paahngo yihr gen yi caang arob. ");
INSERT INTO lwo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Unahg gihn me beer keter yihr ubaahng tiihyo wa gihn nu, ge uyuud wur paaje ngo cahng uduue. ");
INSERT INTO lwo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Athiir e ne roba yihru, kejea ngad paajo cwihnye umihno keraahyo udhiile tiihy paajo cang ke cub yi cing ubaahng gihn nu. ");
INSERT INTO lwo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nea ubaahng me raaj e naa awii ngad paaje paare, e ubaahng gihn nu urubo ke cwihnye kejea wur paajo be laar duuo, ");
INSERT INTO lwo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","noono e uthubo ke goj baahng giih awii yi cinge kedea pahdh ne yug giih cam maa maadh kuong keehd gome mooge. ");
INSERT INTO lwo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Gihn nu, e cahng duu ngad paaje ngo ukwihj ubaahnge ne weey weey, noono e ngad paajo naa lwaahd. ");
INSERT INTO lwo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Gihn nu, e ngad paajo cwihnye urahnye ne cohg, ugoje ubaahng, ce made ngo bang yaa waane ka yuog nyoge yea ke lan ngoohng wong e lag gen kaany gene kaanyo ke nying raahm. ");
INSERT INTO lwo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Dhaahr Juog roma ke rih ucaale gihn: Cahng ni nyetheamaahn apaar lame giih gen akaab gene ke thiehno ne ce ne lor wur kaahny me beehn yi kaahnye. ");
INSERT INTO lwo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Nyetheamaahn abiihj ge angahy par ukaahn gene mow moogo ke gihr ukuom, abea abiihj mooge ge akwihy par bang gihn mow moogo maa akaahn gene tooro. ");
INSERT INTO lwo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Wur kaahny agaalo maa akwal niine nying nyetheamaahn uwahdhe kaa anen gene cang. ");
INSERT INTO lwo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“E nahg yi dewaahr e doohn nyoge ake lihngo me koohbo, ‘Wur kaahny abeehno. Cidho ne lore.’ ");
INSERT INTO lwo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Noono e nyetheamaahn giih apaar ge apiih ne gwiir lame giih gen naa atahng gene ");
INSERT INTO lwo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","maa arub nyetheamaahn akwihj pare yihr muu angahy par kob gene, ‘Cedhree! Muoju wan ke nye mow bang gihn lame giih wan ge daahd thoo.’ ");
INSERT INTO lwo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Maa abeehr nyetheamaahne ngo kob gene, ‘Gahng! Mow yea be rom paahngo bang gihn ngo thiin. Cidho ne ngiew yihru ke mow dhe dhukaahn.’ ");
INSERT INTO lwo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Noono e nyetheamaahn giih abiihj ge apahdh yooh ne ci ne ngeew mow. Abea nye kaa a'aay gene e wur kaahny aguo wahnho, umon nyetheamaahn giih angahy pare wod, batiene e dhe wod ake ciehgo ne rihb utoage. ");
INSERT INTO lwo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Nye batien kaa aciehg dhe wod e nyetheamaahn anaa aci ne ngeew mow ge aguo wahnho thiow urub gene kejea, ‘Cedhree! Yab dhe wod yihr wan umon wane wod.’ ");
INSERT INTO lwo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Maa abeehr ngad kaahnye ngo kea, ‘Wu beehda nyoge me kwihya.’ ");
INSERT INTO lwo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Nea maano e wu keá gwaahg bang gihn cahng ubeehn Dhaahr Juoge ngo kwihyu. ");
INSERT INTO lwo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Uneehn kwaad gihr ngad paajo me weel atihnge ucege giihe piny yihr baahng adahg ne log maanyo. ");
INSERT INTO lwo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ngiihny ge apaahnge yihr baahng giih ni adahg, ucube alihbe abiihj yihr ngad umodho maa alihbe ariow yihr ngad yi diehr kedea alihb acielo yihr ngad dhecaahn, beere kwaad dhaano kiin gen cang utiihyo keehd gihre me rome tiihyo. Naa athume ke paahng ngiihny e apahdh yooh uaaye. ");
INSERT INTO lwo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ngaa acub alihbe abiihj yihre agoohd yi cuug ungeehwe keehd giih me beehne ne ngeew oogo. Gihn nu ayuge wa maano ukaar wudh ngiihnye keehd abiihj mooge. ");
INSERT INTO lwo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ngaan akaab alihbe ariow acidho thiow utiihye maa akaar wudh ngiihnye keehd alihbe ariow mooge. ");
INSERT INTO lwo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Abea ngaan akaab alihb acielo acidho ukoanye piny, ukane ngiihny yea. ");
INSERT INTO lwo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Batien dwahde me thoohdh e ngad paajo aduuo ke yoohn kar weel ucuohne baahng upeehnye gen ke dhe yoohn kaa atiihy gene ngiihny giihe kii ngo. ");
INSERT INTO lwo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Noono e ngaan anaa akaab alihbe abiihj abeehno urube kobe, ‘Ngaa Duohng, alihbe abiihj giih akaaba bangi, a atiihyo keehd gen ukaar wudh gene kaa alihbe abiihj mooge. Maany awaahn ni, ge adoohng naa alihbe apaar!’ ");
INSERT INTO lwo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Maa abeehr ngad paajo ngo kea, ‘Yih atiihy gihn me beer, yih beehda ngaa me cwihnyi nud kedea yih gaahna gaahno kaa aromi nye ngiihny noog weehg kaar beer mee. Awaahn ni, giih me thoohdh ge acuba yi cingi beere cwihnyo umihno tiehd!’ ");
INSERT INTO lwo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Batiene e ngaan akaab alihbe ariow abeehno urube kea, ‘Ngaa Duohng, alihbe ariow ge naa awii piny yihra maa aloga tiihj keehd gen, e wudh ge akaar udoohng gene naa alihbe angween.’ ");
INSERT INTO lwo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Maa abeehr ngad paajo ngo kobe, ‘Yih atiihyo beer, yih beehda ngaa me cwihnyi nud kaa aromi nye ngiihny me noog weehg kaar. Awaahn ni, giih me thoohdh ge acuba yi cingi beere cwihnyo umihno!’ ");
INSERT INTO lwo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Batien yaan nu e ngaan akaab alihb acielo abeehno urube kea, ‘Ngaa Duohng, ngahya kejea yih beehda ngad arojo. Bang gihn keehd puohdho me kuu apuuri e yih caa ne kaj yea. ");
INSERT INTO lwo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Noono e ngiihnyi ge anaa akoanya piny ne kano bang gihn a atud. Yiih, alihb acubi yihra e man wa kare.’ ");
INSERT INTO lwo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Maa abeehr ngad paaje ngo kea, ‘Yih ubaahng maa ngad nyaahbo. Cwihnyi tooro adhaahr yih urubo kejea a beehda ngad arojo? ");
INSERT INTO lwo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Beer, naa angahyi ngo kejea a beehda ngad arojo, gihn e bahnge ge kii cubo yihr ngaa moogo me tiihyo ukaar wudh gene, beere ge duua e ngiihnya naa ayoado e wudh ge akaar? ");
INSERT INTO lwo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Nea wa maano kea kaabu ngiihny giih bange ucubu gen yihr ngad alihbe apaar. ");
INSERT INTO lwo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bang gihn kwaad ngaa yihre ne nyepiny e mooge me thoohdh ge udhay wiih man nud yihre. Abea ngaa toor gihr nyepinye yihre keehd gihn anaa yihre ukaab udoohnge ke cinge now. ");
INSERT INTO lwo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Abea, kwaad ubaahng me cwihnye tooro wa mar nyin thoohru ngo oogo yi muudho ka yuog nyoge yea ke lan ngoohng wong e lag gen kaany gene kaanyo ke nying raahm.’ ");
INSERT INTO lwo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Cahng uduua, a ge adoohng ne dhaano utaahngo, maano e a adoohng ne ruohdh me duohng, maa a ucaahdho keehd wuohdjuog ge ke kar gen cang, e naa ka ubeehna ne piih wiih koom ruohdh gihra. ");
INSERT INTO lwo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kaano e tien paajo upiny cang ree uconge nyuma ulela kiin gen naa akuude ariow wa gihr ngad kwaah me poj keew diehge: apeyieme kur gen kedea roohme kur gen. ");
INSERT INTO lwo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yaa beeye wa roohme ge ucuba ukwiihya abea yaa reje wa apeyieme ge nuu ucaam. ");
INSERT INTO lwo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Noono arumo a urubo yihr yaa nuu ukwiihj kejea, ‘Beehnu jo'a, wu adooj Juog Wura. Beehn kedha wun yi Dhaahr Juog naa agwiire yihru ke coon e upiny poohd kuu acag. ");
INSERT INTO lwo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Wu atiihy gihn me beer bang gihn a alwahgu oogo yihr kahj kedea duona ayoru ke piih cahng anahg riowe an. Thiow naa abeehna bangu e a beehda aley kar budo acubu yihra. ");
INSERT INTO lwo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","A akonyu dahng bang gihn a anaa angoohng ke waaro ucubu waaro yihra kedea a anaa atwaany utuugu an kedea uliewu an naa amag an yi thijin.’ ");
INSERT INTO lwo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Gihn nu e yaa beeye a upeehny gene kejea, ‘Ruohdh! Weehne e naa ayoad wane yih anahg kahje ucub wane cam yihri wale yih anahg riowe ucub wane piih yihri? ");
INSERT INTO lwo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Thiow yih abeehn bang wan naa aley weehne ucub wane yih piny yihdh miehy wan kedea weehne e naa angoohngi ke waaro ucub wane waaro yihri? ");
INSERT INTO lwo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kedea yih anaa atwaany kedea umag yihn yi thijin weehne kedea uliew wane yihn?’ ");
INSERT INTO lwo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Noono e ngo ubeehra koba, ‘A rob athiir yihru, giih atiihyu wiih piny kan yihr jo'a, keehn maa atiihyu gen yihr ngaa me ne bihdh now, e giih nu ge atiihyu ke yihra.’ ");
INSERT INTO lwo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Noono arumo e a urubo yihr yaa nuu ucaama kejea, ‘Coohru rogu oogo buuda wu yaa alam Juoge. Kadhu yi deeh maaj gihr Juog naa a'ahbe ke nying ruohdh atiihb ukeehg kedea atiihb reje! ");
INSERT INTO lwo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","A anaa anahg kahje maa akweeru ke muoj an ke cam maa a anahg riowe maa akweeru ke cub piih yihra, ");
INSERT INTO lwo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Thiow a abeehn bangu e a beehda aley uloohru wiiha oogo yihdh miehyu kedea a anaa angoohng ke waaro ukweeru ke cub waaro yihra, maa a anaa amag yi thijin kedea a anaa atwaany ukweeru ke liew an.’ ");
INSERT INTO lwo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Wiih lum nu ubeehr gene kejea, ‘Ruohdh! Weehne e naa ayuud wane yih anahg kahj, wale yih anahg riowe, wale yih beehda aley, wale yih amag yi thijin wale rihi anaa atwaany ukweer wane ke kony yihn?’ ");
INSERT INTO lwo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Abea ngo ubeehra yihr gen kejea, ‘A ateed athiir yihru. Ge anaa akweeru ke kony yaa ne bihdh now, e gihn nu nyoadh ngo kejea wu akweer ke kony an thiow.’ ");
INSERT INTO lwo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kaano arumo e yaa reje ge uriem ne beehdo yi maaj me nyaahm gihre be gug kedea yaa beeye ge caa yi kuowo me guge tooro.” ");
INSERT INTO lwo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Naa athum Jeacuue ke rob giih anaa adaahde ke robo cang yihr jo waahdhe e ngo arubo yihr gen kea, ");
INSERT INTO lwo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ngahyu kejea adoohnge nihn ariow cog ubeehn Yaan Amono. Abea yi yaay gihn nu e nuu uluom an, a ge adoohng ne dhaano utaahngo, kedea ugur gene an rih yaadh maa ariihw.” ");
INSERT INTO lwo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yihdh nihn nu thiow e jo doong yaa lam maa jo doong paajo ge anaa amahdo paar ngaa duohng yaa lam me nyinge Kaaypaj ");
INSERT INTO lwo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ne gweehg dhe yooh me mag gene Jeacuu unahge e kwihj nyoge. ");
INSERT INTO lwo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Naa amad gene dhe yoohn nahg Jeacuu, e wudh gen adog gene ke paro maa akoohb gene, “Ngo keá mago yihdh nihn yaay bang gihn cwihnyo tooro bange ubeehn amahr yaa abeehn Jeruucalem uyug gene ajuohj ke nying gihn amage.” ");
INSERT INTO lwo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Cahng ni arumo Jeacuu anaa yi geen Bathany paar nyin moogo me nyinge Cimoan Udhoobo. ");
INSERT INTO lwo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Noono e Jeacuu cam agwiir yihre upiihe ne cam. Nye kaano e dhaago moogo ake beehno e kaahn udhoohmo me yea ne mow me ngwaahy me ngiene teeg keraahyo. Naa awahnh dhaar ni bang Jeacuu e mown nu awoje wiih Jeacuu cang ne moar wiihe. ");
INSERT INTO lwo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Naa aniid jo waahdhe gihn nu e ngo amaan gene maa arub gene ke rog gen kob gene, “Dhaar ni mow me ngiene teeg nyaahge oogo kaa nying gihn? ");
INSERT INTO lwo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ngahda ngweehn me ne ngeewe oogo, beere ngiihny yoad ge ke paahngo yihr nyoge maa angoohng ne!” ");
INSERT INTO lwo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Gihn arob jo waahdhe ke rog gen ngo angey Jeacuue maa arube kea, “Gihn ge giedu dhaar ni? Beehda gihn me beer ne cohg e naa atiihye yihra. ");
INSERT INTO lwo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yaa angoohng ge nyoge me beehdo kaa wun. Ge uromu ke muojo cahng moogo. Abea an, a buu ukwaay beehdo ke wun. ");
INSERT INTO lwo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Dhaar ni atiihy gihn me beer ne cohg naa amoone piny ne gwiir kuohma cahng ukoany an. ");
INSERT INTO lwo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Awaahn ni, a rob athiir yihru kejea kwaad kuohn upuohny Ciig Beer yihdh gen ke bang upiny cang, e gihn ayug dhaar ni uke robo thiow ne par bang dhaar ni.” ");
INSERT INTO lwo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kaano e dhaano acielo kiin jo waahdh Jeacuu ge apaar wonge ariow me nyinge Juudo Yijkaariod acaa bang jo doong yaa lam ukoohbe kea, ");
INSERT INTO lwo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Gihn e nuu ucubu yihra nea dhe yoohn mag Jeacuu anyoadha yihru?” Maa akwaan gene ngiihny demaro dhaano aduuno wonge apaar yi cinge. ");
INSERT INTO lwo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Noono, ke wong cahng nu, e Juudo ake thubo ke daahd dhe yooh me meehge Jeacuu kwahg piny yihr yaa ni. ");
INSERT INTO lwo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Cahng umodho yihdh nihn Yaan Amono, e jo waahdh abeehn bang Jeacuu upeehy gene kejea, “Ngad puohny! Kee e ne daahdi nuu ugwiir wane ne kar piih yihri ne yug cam cahng Yaan Amono yea?” ");
INSERT INTO lwo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kob Jeacuue, “Ne ngaa me nii buur geew kun caadi, cuu bange uteedu ngo yihre kejea, ‘Arob ngad puohny kea e daahd utiihye Yaan Amono paari tiehd keehd jo waahdhe. Arobe kejea cahng thone adoohng cahng.’ ” ");
INSERT INTO lwo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jo waahdh ge acidho muon ugwiir gene cam wa kaa arob Jeacuue yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ke wong thiehno arumo, e Jeacuu apiih wiih cam keehd joe kar ge apaar wonge ariow. ");
INSERT INTO lwo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nye kaa acahm gene cahmo, e Jeacuu ake rubo kea, “A rob gihn maa adiehr yihru! Dhaano acielo kiinu daahd uluome an.” ");
INSERT INTO lwo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Naa alihng gene lum nu, e cwihny gen kuu amedo maa apeehy gene naa acielo acielo ke rog gen kob gene, “Ngahde padh an nye Ruohdh?” ");
INSERT INTO lwo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Maa abeehr Jeacuue ngo kea, “Ngaa maa areg cinge yi wal keehd an e nuu uluom an. ");
INSERT INTO lwo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A, ge adoohng ne dhaano utaahngo, a uthow wa kaa agweede yi kitaab Juog, abea ngaa luom an, a ge adoohng ne dhaano utaahngo unaa yi gihn me raaj ne waany, adhaahr ngweehn me bahnge ngo be ne nyuol.” ");
INSERT INTO lwo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Noono, e Juudo ngaa uluom ngo ake rubo kea, “Padh an Ruohdh! Ngahda kare ne?” Kob Jeacuue, “Wa yih naa arob ngo ke dhii.” ");
INSERT INTO lwo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kaano acahm gene cahmo, e Jeacuu amono akaabe batiene naa adooje ngo e ngo abanye maa acube ngo yihr jo waahdh e urubo kea, “Kaabu ngo kedea camu ngo. Gihn ni beehda kuohma.” ");
INSERT INTO lwo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Keehdo e kubaayo me yea ne koongo akaabe batiene naa amuohje koohr Juog e ngo acube yihr jo waahdh e urubo kea, “Maadhu ngo wu ke karu cang, ");
INSERT INTO lwo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","bang gihn gihn ni beehda rema. Rem nweehd won ge awoj piny ke nying nyoge me thoohdh ke nying wii adhemuohme piny. ");
INSERT INTO lwo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A teed athiir yihru. Koongo buu ucahga maadha keehdo uwahdhe cahng umaadha koohng nyaahn keehd wun yi Dhaahr Juog wura.” ");
INSERT INTO lwo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Batien kaa awahr gene Wahy Apoong Juog e ge aay ne ci wiih Good Ulihbe. ");
INSERT INTO lwo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kaano e Jeacuu arubo yihr gen kea, “Wu noono cang, wu ugoohd oogo riha uwiiu an piny wa kaa agweede yi kitaab Juog ke nyinga naa, ‘Ngad kwaah unahga, ubeehn diehge ulog gene keedho.’ ");
INSERT INTO lwo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Abea batien ka ucahra yi thoo a umoon wong maalo nyumu yi piny Gaalili.” ");
INSERT INTO lwo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Gihn nu e Piihter arubo kea, “Keehd me paahr nyoge oogo rihi ugoohd gene, e a ke nguda, a be kuong paahr oogo rihi uwiia yihn piny!” ");
INSERT INTO lwo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kob Jeacuue, “Adiehr e ne roba yihri. Tihn noon ni yi dewaahy tihn, maano e uthuonjieno poohd kuu akoohg, e yih ukweer ke an tiel adahg kejea a kwihyi.” ");
INSERT INTO lwo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kob Piihtere, “A be kuong kweer ne weey weey kejea yih kwihya keehd me nahge thoo, e a uthow tiehd ke yihn.” Kedea ubeehn jo waahdhe cang urub gene kejea Jeacuu be kuong gene ke wii yi gihn me raaj. ");
INSERT INTO lwo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kaano e Jeacuu a'aay keehd jo waahdhe ucea ka me cuohn ne Gedhceama. Naa awahdh gene kaa ngo e Jeacuu ake rubo yihr jo waahdhe kea, “Piihu kan ne koar, a bar ne kwaj wong maalo ke me cahng kan.” ");
INSERT INTO lwo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Maa acuohne Piihter kedea waahd Jebeade kar ge ariow: Jeamij kedea Joon. Nye kaano e Jeacuu ree ayoade yi raahy cwihny me duohng kedea raahm aduulo me teeg. ");
INSERT INTO lwo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Noono urube yihr yaan ni adahg kea, “Yaage! Aduuna urahmo cang ke raahm me wa a cej thoo. Doohngu kan ne koar an, abea wu keá neno.” ");
INSERT INTO lwo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Noono arumo, e Jeacuu anyiig wong maalo ka me thiin, upahdhe wudh conge ukuule wiihe piny ne kwaj e urubo kea, “Abaa Wura! Nea kare nud kea kaab raahm gihn ni beehn riha. Abea keehd maano, e keá yugi wa ka daahda abea yug ngo wa kar cwihnyi ne daahdi.” ");
INSERT INTO lwo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Naa aduu Jeacuue bang jo waahdhe, e ge ayuude e ge ane twar ke niine. Maa atahnge Piihter urube yihr ngo kea, “Piihter! Kare tooro yihru ukuru keehd an, keehd ke kar caa acielo cog, e wu be neehne ne? ");
INSERT INTO lwo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Wu keá neno abea kwahyu beere wu be tum atiihb ukeehge. Mare ngo athiir! Aduulo ngo teeg ngo rom guum abea kuohm e naa agoohg.” ");
INSERT INTO lwo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Maa acahge aay keehdo ne kwaj Juog urube kobe, “Abaa Wura, nea kare tooro me kaabi raahm beehn riha kejea ngo dhiil pahdh wiiha kea yug ngo wa ka daahdi.” ");
INSERT INTO lwo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Naa acahg Jeacuue duuo keehdo e yuud jo waahdhe giih adahg ge ane twar ke niine, bang gihn ge anaa agoohg niine ne cohg. ");
INSERT INTO lwo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Maa a'aay Jeacuue uwiie gen piny kaano ucea ne kwaj. Yi dahg kwaj e ngo aber kwaj gihre naa anuu umodho. ");
INSERT INTO lwo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Naa aduue bang jo waahdh e arubo yihr gen kea, “Wu poohd niin gihn? Gihn me nenu ke nyinge keehdo tooro bang gihn caang cub an, a ge adoohng ne dhaano utaahngo yi cing nyoge me reje ngo abeehno. ");
INSERT INTO lwo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yedhu maalo upahdho yooh. Ngaa aluom an e man awahnho!” ");
INSERT INTO lwo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Piow piow kaano apoohde e Jeacuu urubo nu, e Juudo ge beehda dhaano acielo keew jo Jeacuu ge apaar wonge ariow ake wahnho e ngo caahdh kaa nyoge maa aoohr ngaa duohng yaa lame maa jo doong paajo. Yaa ngo ge akaahn pale kedea belunge. ");
INSERT INTO lwo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ngo anaa arob Juudo yihr jo abeehne ke gen kea, “Nea ngaa baahba ree ke maahdho e naa ngaa magu bang gihn e ne daahdu!” ");
INSERT INTO lwo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kaa awahnh Juude e abaahb rih Jeacuu ke maahdho kobe, “Koohri ruohdh!” ");
INSERT INTO lwo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kob Jeacuu, “Laar gihn abeehni ke nyinge ke yugo goma.” Kaano e nyoge ake beehno umag gene Jeacuu utuohj gene ngo. ");
INSERT INTO lwo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Gihn nu e dhaano acielo kiin jo waahdh pahle awuohdhe ke oogo ungole yihdh ubaahng me tiihyo paar ngad duohng yaa lam. Yihdh ngo angole piny ne thihb. ");
INSERT INTO lwo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Maa arub Jeacuue yihr nyin ni kea, “Duog pahli yi wode. Ngaa yuohdh pala oogo rih wad gen, e unahg pala e nuu nahg ngo thiow. ");
INSERT INTO lwo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kwihyi kejea nea an ne daahd ukony Wura an e kare nud yihre uoohre amahr deaj giih wuohdjuog me thoohdh me be kwaan rog gen yihra yi nyenij ne? ");
INSERT INTO lwo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Abea kare tooro uruba kejea beehn wuohdjuoge ne kony an bang gihn, gihn agweed yi kitaab Juog dhiil pahdh kare wa kaa ateede.” ");
INSERT INTO lwo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Anahg kaano e naa alog Jeacuue dhee bang yaa abeehn ne mag ngo ne rob kea, “A abeehdo ke wun kedea a na niidu niido e a caa yi laaro gihr Wod Juog ke nying nihn upuohnya nyoge puohnyo abea a kuu anaa amagu. Awaahn ni gihn ge beehnu banga e wu kaahn pale maa belunge kii cingu udoohnge wa a beehda ngaa maa apaahr oogo ne liny ke ukuumo? ");
INSERT INTO lwo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Gihn ayug ree awaahn ni beehda giih anaa agweed yaa agamloohngjuoge ge ne pahdh kar gen wa kaa agweed gen.” Kaano e jo waahdhe cang ge ake aay ke ngweej uwii gene Jeacuu piny. ");
INSERT INTO lwo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yaa anaa abeehn ne mag Jeacuu ngo abeehn gene ne kedh paar Kaaypaj ngad duohng yaa lam kaa amahd jo doong yaa lame kedea yaa loohng Juog yea. ");
INSERT INTO lwo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piihter thiow anaa ke caahdho e buodh batien Jeacuu ke ka me baahr uwahdhe kaa amone paar Kaaypaj. Gihn nu e apiih buud acaakere giih koar Wod Juog ne maany ka ulug lug Jeacuu kii ngo. ");
INSERT INTO lwo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jo doonge yihr yaa lam kedea yaa Akuud jo doong Judea cang ge ake daahd ke cuud me teed awuohj ayug Jeacuue keehd me nahge toohd, e ngo ke kihmo ke thoo. ");
INSERT INTO lwo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Abea gahng ke cuude maa ayoad gene me luub gen roohm, keehd maa anaa abeehn nyoge me thoohdhe kob gen ge cuude. Batiene arumo e nyoge ariow ge ayedh maalo urub gene kejea, ");
INSERT INTO lwo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Nyin anaa alihng wane e urubo kejea yihre ne tee me thuohme Wod Juog gihr Jeruucalem piny kedea kea ngo geere geero batien nihn adahg.” ");
INSERT INTO lwo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Noono e Kaaypaj ayedh maalo urube yihr Jeacuu kea, “Gihn e bahnge wudh giih rob rihi ge be beehri. Gihn e naa adiehr kiin giih arob yaa ni rihi?” ");
INSERT INTO lwo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Abea Jeacuu aleng ne caaj. Maa acahg Kaaypaje rob kea, “Kuohng rih ke Juog Aciehg nea yih naa Ngad Boadh nyoge ge Waahd Juog Aciehg ni?” ");
INSERT INTO lwo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Maa abeehr Jeacuue ngo kea, “Beehda yihn e naa arob ngo ke dhii. Abea a rob gihn maa athiir yihru, kejea ke wong cahng tihn uwahdhe cahng moogo, e a ge adoohng ne dhaano utaahngo, a uniidu e a apiih ukoom ruohdh ukwiihy Juog kedea a uniidu ge ubeehna wa daahr maaj kii lwahd ke yoohn Paar Maalo.” ");
INSERT INTO lwo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Maa abeehn Kaaypaje urahny cwihnye yi kwaad gihn arob Jeacuue rih Juog. Gihn nu e Kaaypaj ke ngude waahny ree ayieye ke oogo yi ngahye maa aloge dhee ne rob yihr yaa Akuud kobe, “Ngahda ngo alihngu kaa adhahle Juog kea e uroomo keehde. Naa awuohj moogo me cahgo ke daahdo yaage? Ngo alihngu cang kaa arube kea e uroomo ke Juog. ");
INSERT INTO lwo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nea maru e ukihm gihre beehda gihn?” Maa abeehr gene ngo ke kar gen cang, “Kihme ke thoo.” ");
INSERT INTO lwo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nye wong kaano e ge apiih ne nguud yi wonge maa e ngo dhohng gene dhohngo kedea e ngo ke peehnyo naa, ");
INSERT INTO lwo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ngad Boadh nyoge! Caar ngaa adhoohng yihn!” ");
INSERT INTO lwo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Noono ayug giih nu rog gen e Piihter anaa apiih yi laaro paar Kaaypaj maa abeehn nyaakowe maa baahng paan nu ke buude urube kea, “Yih noon ni, yih na ucaahdho keehd Jeacuu ngad Gaalili.” ");
INSERT INTO lwo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Maa apiem Piihtere ngo ne rweej nyum nyoge cang kea, “Gihn nu rubi ke nyinge ngo kwihya.” ");
INSERT INTO lwo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kaano e Piihter a'aj maalo ucea dhe roog, maa aniid nyaakow moogo maa baahng paan nu ngo urube yihr nyoge kea, “Nyin ni beehda ngad Jeacuu ngad Naajaread.” ");
INSERT INTO lwo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","E Piihter ree akuohnge udoge ree ke jaahyo kea, “Ngaan nu rubu ke nyinge ngo kwihya!” ");
INSERT INTO lwo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Batien ka me thiin keehdo, e cuow mooge maa anaa acuunge buud gen ge abeehn bang Piihter urub gene kob gene, “Gihn me piemi tooro, kii robi now e nyoadh ngo kejea yih beehda dhaano acielo kiin yaa Jeacuu!” ");
INSERT INTO lwo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Maa apiem Piihtere ngo ne rweej ukuohnge ree kea, “Yaage! A rob adiehr nyum Juog. Ngadu noono rubu ke nyinge nu ngo kwihya!” Ke nye wong kaano e uthuonjieno ake koohg, ");
INSERT INTO lwo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","maa apar Piihter lum anaa ateed Jeacuue yihre kejea, “Tihn noon ni, yi dewaahy tihn, maano e uthuonjieno poohd kuu akoohg, e yih ukweer ke an tiel adahg kejea a kwihyi.” Gihn nu e Piihter acaa yi kalo ne lalo ke keej yej naa angeye deeh awuohj gihn atiihye. ");
INSERT INTO lwo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yi ruu piny ke nyang coon, e jo doong yaa lam maa jo doong paajo cang amaad ayug gene bang ne gwiir dhe yooh me dhiil gene Jeacuu ke naah. ");
INSERT INTO lwo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Maa atuohj gene cinge ukedh gene ngo bang Poantya Pilaato ge muudiihr piny Judea. ");
INSERT INTO lwo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ge abeehn Juude ngo ne yoad kejea Jeacuu ngo akihm ke thoo ni e cwihnye ake rahnyo bang awuohj gihre naa ayuge ge aluome Jeacuu ni. Noono maa akaabe ngiihny giih anaa cub yihre naa aluome Jeacuu ucea ne duog gen yihr jo doong yaa lam maa jo doong paajo. Naa awahnhe bang gen e arubo kea, ");
INSERT INTO lwo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Gihn me raaj ayuga, dhaano maa abiohgrwaal e naa aluoma.” Maa abeehr gene ngo kob gene, “Tien mar wa gihn! Beehda gihr ngudi.” ");
INSERT INTO lwo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Gihn nu e Juudo ngiihny ge abaahle ke yi wod yi dwaar gihr Wod Juog gihr Jeruucalem kedea ucea ne ngaab ree. ");
INSERT INTO lwo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Maa abeehn jo doong yaa lame ukwany gene ngiihny maa akoohb gene, “Ngiihny ni, ge beehda ngiihny remo, ka me kedh gen yi kajana gihr Wod Juog tooro, bang gihn ngo amahn loohnge ne mad ngiihny remo yi kajana bang ngiihny Wod Juog.” ");
INSERT INTO lwo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Batiene e ge apiih ne mad lubo acielo ke gihn uyug gene keehd ngiihny giih ni. Kaano e ge agwiihro kejea nahge ke piny e ne ngeew gene. Maa angeew puohdh nyin maa ngad cwaahj daahy beere ke yugo ne kar koany aleye. ");
INSERT INTO lwo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","E naa gihn abeehn kaa angeew udoohnge e cuohn uwahdhe tihn ne ‘Puohdh Remo’ ");
INSERT INTO lwo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","kedea e naa kaa abeehn gihn arob Juoge ke leeb ngad agamloohngjuog ge cuohn ne Jermya utiinge ree kare. Anaa akobe kea, “Kedea ukaab gene ngiihny demaro dhaano aduuno wonge apaar anaa ayiih yaa Yijaraele ne ngiihny rom cubo ne luom ngo. ");
INSERT INTO lwo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Maa acub gene ngiihny ne ngeew puohdh ngad cwaahj daahy wa kaa arob Juoge ngo yihra.” ");
INSERT INTO lwo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kaano e Jeacuu akahl yi lug nyum muudiihr maa apeehnye ngo kea, “Yih naa ruohdh Judea ne?” Maa abeehr Jeacuue ngo kea, “Yih naa arob ngo ke dhii.” ");
INSERT INTO lwo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Abea gihn maa adog Jeacuue ke beehro tooro naa abeehn ruohdh jo doong yaa lame kedea jo doong paaje urob gene giih me reje ke nyinge yihr Pilaato. ");
INSERT INTO lwo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Maa arub Pilaate yihre kobe, “Giih reje ge rob gene rihi ge be lihng yihri ne?” ");
INSERT INTO lwo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Maa acwaahng Pilaato keraahyo yi kwaad man bahnge e gihn me robe tooro ne jaahy giih reje ge arob ree. ");
INSERT INTO lwo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ke nying wong, yi Yaan Amono, e Pilaato kwaad maabuuj me daahd paaje kejea ke lonyo, e ngo lonye ke oogo yi thijin. ");
INSERT INTO lwo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ngaa me cuohn ne Barabaj ngo anaa yi thijin, me giih reje naa atiihye ge ngahj keraahyo. ");
INSERT INTO lwo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Naa abeehn nyoge ucong gene rog gen e ge apeehny Pilaate kea, “Ngaa e ne daahdu ulonya ngo oogo yihru: Barabaj wale Jeacuu ge cuohn ne Ngad Boadh nyoge?” ");
INSERT INTO lwo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Apeehyo wa gihn nu bang gihn ngo angahy Pilaate kejea beehda ke nying giih tiel now e naa amag jo doong yaa lame Jeacuu ne kahl nyum lug. ");
INSERT INTO lwo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kaano anaa apiih Pilaate yi lug, e ciihe dhog aoohre yihre ne rob ngo yihre kejea wiie cinge utoor gihn me raaj me tiihye rih ngaa maa abiohgrwaal bang gihn awuohj maa atiihye tooro. Thiow kob ciihe kejea laahg maa alahge ke nying Jeacuu cwihny ngo adage. ");
INSERT INTO lwo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Jo doong yaa lam kedea jo doong paajo yihdh nyoge acoam gene beere Barabaj e ne lony oogo yihr gen kedea unahge Jeacuu e ne nahg. ");
INSERT INTO lwo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gihn nu naa abeehn Pilaate ne peehny nyoge ke ngaa daahd gene ne luny oogo, e arob gene, “Barabaj.” ");
INSERT INTO lwo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Maa arube yihr gen kea, “Abea nea wa maano, yuga gihn keehd Jeacuu ge cuohn ne Ngad Boadh nyoge?” Maa abeehr gene ngo cang kob gene, “Gure rih yaadh.” ");
INSERT INTO lwo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Maa acahg Pilaate piehj keehdo kea, “Abea gihn noono raaj ge awuohye ni?” E ge athubo ke kwaago e doohn ge ne maalo, “Gure rih yaadh.” ");
INSERT INTO lwo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Abea ge aniid Pilaate ngo e gihn me beer me rome yugo tooro ni kedea alyaahb ree miide kaa yugo kiin nyoge, e piih akaabe kaabo uluoge cinge nyum nyoge, e urubo kea, “Yihra baahr! Rem nyin tooro yi cinga. Reme naa yi cingu.” ");
INSERT INTO lwo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","E nyoge cang ngo arob gene yihre kob gene, “Reme unaa yi cing wan kedea yi cing nyethen wan.” ");
INSERT INTO lwo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Noono ubeehn Pilaate, ulonye Barabaj oogo neehn kaa adaahd gene, abea Jeacuu ngo ameehge puohdo umodho ce cube ngo yihr acaakere ne ci ne gur rih yaadh maa ariihw. ");
INSERT INTO lwo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kaano e acaakere giih muudiihr Pilaato, Jeacuu abeehn gene ne kedh yi wod paar muudiihr ge cuohn ne Preetoarya. Kaano e naa abeehn akuud acaakere ucong gene rog gen buud Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Batiene e acaakere waay Jeacuu ge akahl gene oogo rih ngo kedea ungaab gene jalaabya me kwaar mee ree. ");
INSERT INTO lwo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Thiow uyoad gene koadho udol gene ngo naa atahny ruohdh maa acub gene ngo wiihe kedea ucub gene theengo yi cinge ne yaahr ngo, kejea ngo Jaah. Naa athum gene ke yug giih nu e cung gen arung gene piny ne ngier kuohme kob gene, “Maahdh ya Ruohdh yaa Judea.” ");
INSERT INTO lwo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Maa anguud gene yi wonge kedea ukaab gene theengo oogo yi cinge kedea utwang gene wiih ngo twango keehd theengo. ");
INSERT INTO lwo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Naa athum gene ke ngier kuohme, e jalaabya akahl gene oogo ree kedea uduog gene waaye ree, batiene e ge a'aay keehde ne kedh ne gur rih yaadh maa ariihw. ");
INSERT INTO lwo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ge anaa caahdh gene caahdho ni, e ge beehn oogo yi diehr geew, e ge abeehn ne roohmo keehd nyin me nyinge Cimoane ngad Ciriihna. Kaano e ngo amag gene ucube ne bien yaadh gihn ugur Jeacuu ree. ");
INSERT INTO lwo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Naa awahnh gene ka cuohn ne Golgotha lum yea: ‘Paan Wihj’ ");
INSERT INTO lwo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","e koongo maa alyaahb keehd piih yaadh me nahg raahm acub gene yihr Jeacuu kejea maadhe ngo. Abea naa abele ngo e akweer ke maadh ngo. ");
INSERT INTO lwo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Naa athum gene ke gure rih yaadh maa ariihw, e waare giihe ge abeehn gene ne paahngo ke kiin gen ke dhe yoohn gaay e ne thoohr gene bang ne ngahy ngaa upahdh waare yihre. ");
INSERT INTO lwo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Batiene e ge apiih kaano ne koar ngo piny. ");
INSERT INTO lwo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Awuohj gihn akob naa ngo ayuge agweed rih apango wa gihn, “RUOHDH YAA JUDEA.” Noono ukaab apango ungoohne wiihe maalo. ");
INSERT INTO lwo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Maa ayoad gene yaa kahw ariow ugur gene gen ngahdh yen wa kwaad mar Jeacuu, ngaa man nuu ukwiihye kedea ngaa man nuu ucaame. ");
INSERT INTO lwo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Batiene e kwaad yaa ngul piny now e ngo cwiid gene cwiido e wudh gen gihny gene gihnyo kedea e ge uyahdo ");
INSERT INTO lwo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","kob gene, “Yih nyin na koohbo kejea Wod Juog thuohmi ke piny kedea uromi ngo ke geero ucuunge batien nihn adahg, kea noono kony rihi nea yih Waahd Juog uyihnhi piny ke rih yaadh ariihw.” ");
INSERT INTO lwo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ke dhe yoohn nu thiow, jo doong yaa lam maa yaa loohng Juog kedea jo doong paajo, kuohm Jeacuu angier gene ");
INSERT INTO lwo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","kob gene, “Nyoge mooge ge akonye abea wa ree be rome ke konyo! Ngahda e naa ruohdh yaa Yijarael! Kea noono yihnhe piny ngahy yaadh nu agure ree beere lume yiih wane yiiho. ");
INSERT INTO lwo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kea Juog e ne gaahne! Ka noono kony Juoge ngo ne beehn oogo ngahy yaadh nea ngo beehda ngaa maa anhyaar Juoge. Ngahda anaa arubo kea, ‘A waahd Juog ne!’ ” ");
INSERT INTO lwo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Thiow, keehd yaa kahw giih anaa agur maalo buude ngo ayahl gene tiehd. ");
INSERT INTO lwo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kaano maa abeehn deeh muudho umoale piny cang ne cihdh cihdhi. Naa athube e cahng nii diehr wihj uwahdhe kaa alaahnge e gihn me neehn tooro. ");
INSERT INTO lwo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yi laahng cahng e Jeacuu ayuog ke dhe paar gen e duone atihnge maalo, “Eali, Eali lama cabajthaahni.” Lum yea, Juog Ruohdha, Juog Ruohdha gihn ge paahli an oogo wa gihn? ");
INSERT INTO lwo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Naa alihng jo anaa ke cuungo duon Jeacuu e ge arubo kob gene, “Beehda Eliija ge anahg agamloohngjuog naa acoon e ne cuohne.” ");
INSERT INTO lwo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nye wong kaano, e dhaano acielo kiin gen ake goohdo ne kahl koongo me waj maa akaabe bur waaro ucode ngo yi koongo maa atuohye ngo wiih theengo urwaage ngo yi dhe Jeacuu ne maadho. ");
INSERT INTO lwo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Maa arub goan nyoge mooge kob gene, “Maanyo ngo! Ka moogo e Eliija ubeehn ne konye.” ");
INSERT INTO lwo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kaano e Jeacuu acahg lalo e duone atihnge maalo kedea e naa thone noono. ");
INSERT INTO lwo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kaano e waaro gihn apaahng kur Dhe Wod ke kur Dhe Tiel yi Wod Juog yea ayiej ree piny ne dahg naa ariow ke maalo uwahdhe piny kedea ubeehn pinye uyahnge ree ne med medi cang maa leele yihdh ge akeedho ne wer wer. ");
INSERT INTO lwo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Maa beehn wudh leehde giih yaa anaa thow coon ge anahg nyoge me beeye, uyab gene rog gen kedea ucahr thoohdh yaa anaa thow. ");
INSERT INTO lwo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Batiene kaa acahr Jeacuue e jo ni thiow ge apahr oogo yihdh leehde kedea uci gene yi diehr geew maa nyoadh gene rog gen yihr kwaad nyoge mooge. ");
INSERT INTO lwo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Maa abeehn jaabidhe kedea acaakere giih anaa acub piny ne koar Jeacuu, naa niid gene giih atiihy rog gen, ge amed pinye ree ni, e ge ake tudo maa akoohb gene, “Beehda adiehr, nyin ngo beehda Waahd Juog ne cohg.” ");
INSERT INTO lwo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Maahn me thoohdh ge anaa anudo ka me cahng e ge maahnyo kaa ka me baahr. Maahn na caahdh keehd Jeacuu ge anaa Gaalili ge ne tiihy giihe. ");
INSERT INTO lwo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kiin maahn giih ni, anahg Maarya ngad Madaleana, Maarya miih Jeamij kedea Jocebe kedea miih nyethen Jebeade. ");
INSERT INTO lwo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Naa awahnhe yi caang thiehno, e nyin maa alony me nyinge Jocebe ngad Arihmathea, ake beehno. Ngo anahg ngaa maa adoohng ne ngad Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","E nyin abeehn bang Pilaato ne kway kuohm Jeacuu yihre bang ucea ne kan ngo. Maa abeehn Pilaate urobe ngo yihr acaakere kejea cub gene kuohm Jeacuu yihre ne kano. ");
INSERT INTO lwo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Batiene e kuohm Jeacuu akaab Jocebe kaabo, ubahje ngo ke waaro me nyaahn. ");
INSERT INTO lwo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Maa akedhe ngo ne kano yi liel gihre maa akoanye yi leelo ka me cahng. Batiene e deeh leelo abeehne ne loohr dhe wod kaano akane kuohm Jeacuu yi ngo kedea uaaye. ");
INSERT INTO lwo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Abea ge ayuge giih ni e maahn ariow, Maarya ngad Madaleana kedea Maarya moogo ge anaa anudo ka me cahng ke kar liel. ");
INSERT INTO lwo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ruuwow ge aruu piny ke batien cahng gwiihro gihr Cabadh, e jo doong yaa lam maa Paarijea ge aci bang Pilaato. ");
INSERT INTO lwo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Maa arub gene yihr ngo kejea, “Muudiihr! Ngad toohd gihn ni ge anaa apoohde e kuow ngo na urubo kea, ‘A ucahr batien nihn adahg.’ ");
INSERT INTO lwo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nea maano kea rob lubo beere liel gihre koar piny ke nihn adahg, bang gihn ka moogo joe kuohm ngo beehn gene ke ne kwahl oogo caahn e ge urubo kejea ngo acahr naa athowe. Toohd gihn ni ngo uraaj keter ukaale wudh muu anaa umodho.” ");
INSERT INTO lwo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Maa beehr Pilaate ngo kea, “Kahbu keehd acaakere me koar liene wa kwaad ka daahdu.” ");
INSERT INTO lwo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Maa acidh gene kedea ukoar gene liel piny, maa ucub gene leelo dhe wod beer mee kedea acaakere me koar kaano piny. ");
INSERT INTO lwo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cahng ni, kaa akaahg piny batien cahng Cabadh e beehda cahng umodho gihr beriown nihn, e Maarya Madaleana kedea Maarya moogo ge amool uliel. ");
INSERT INTO lwo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Abea thiin kan e piny ree ayahnge yahngo cang, bang gihn wuohnjuog abeehno ne dhihl ke yoohn Paar Maalo ungeehle leelo gihn anaa acub dhe liel oogo upiihe wiih ngo. ");
INSERT INTO lwo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wuohnjuog gihn kuohme ake liel wa maahny kodh kedea waare giihe tar wa bur waaro. ");
INSERT INTO lwo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yaa anaa acub wiih liel ne koar ge ataal lwahre maalo udoohng gene wa nyoge maa athow. ");
INSERT INTO lwo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Naa awahnh maahn giihe kar ge ariow e wuohnjuog ake rubo yihr gen kea, “Wu keá tudo. Ngahya kejea wu abeehn ne maany kuohm Jeacuu Ngad Boadh nyoge e anaa agur ngahy yaadh maa ariihw. ");
INSERT INTO lwo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Jeacuu ngo tooro kan. Ngo ameehg Juoge cahro wa kaa anaa ateede ngo yihru coon umodho kejea e ucahr batien nihn adahg. Beehnu umaanyu kaa anaa apiehle yea! ");
INSERT INTO lwo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Laaru doog ke laahdo uteedo ngo yihr jo waahdh giihe kejea Jeacuu acahr kedea ngo amoon nyum gen ne ce Gaalili, ka uroohm gene yea keehde. Wudhu keá wulo ne par giih ni ateeda yihru cang.” ");
INSERT INTO lwo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ke nye wong kaano, e ge Maarya ngahdh gen ayal gene yalo ke ngweej ne do ne toohn jo waahdh, e nye lwahr poohd nii yihdh gen, keehd maa anaa amed cwihny gene keter ke nying cahro gihr Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Abea nye kaano e Jeacuu anaa lwaahd bang gen urube kea, “Maahdhu rihu ya.” Noono ubar gene bang Jeacuu urung gene cung gen piny ne ciim tiene kedea upuoj gene ngo keraahyo. ");
INSERT INTO lwo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Batiene e Jeacuu ake rubo yihr gen kea, “Wu keá tudo, abea cidhu uteedu ngo yihr jo'a cang kejea cidh gene Gaalili, wa uroohm kun caadi keehd gen ka uniid gene an yea.” ");
INSERT INTO lwo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nye kaa apoohde e maahn giih ge nii yooh ne doog, e yaa koar liel mooge ge aguo goohd bang jo doong yaa lam uteed gene giih ayug rog gen cang yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kaano e amaad aguo gene kaa yugo tiehd keehd jo doong paajo ne gweehg yea lubo. Batien amaad e amahr ngiihny acub gene cubo yihr yaa koar liel. ");
INSERT INTO lwo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ungweel gene ngo piny kejea, “Kwaad ngaan peehny wun now kea teedu ngo kejea jo waahdh Jeacuu ge abeehno ke waahr e wa aneno ukwal gene kuohm ngo. ");
INSERT INTO lwo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Cwihnyu keá ne ngaahj bang gihn, gihn me pahdh wudhu tooro. Keehd me beehn muudiihre ulihnge ngo kejea wu anaa aneno e wu ukony wane.” ");
INSERT INTO lwo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yaa koar liel ngiihny akaab gene kedea ucidh gene ne kiid lubo wa kaa ateede yihr gen. Kedea ke wong cahng nu, uwahdhe cahng tihn, e naa lum rob kiin yaa Judea. ");
INSERT INTO lwo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Noono ubeehn joe ge apaar wonge acielo utihng gene rog gen ne ci wiih good me nii Gaalili kaa akob Jeacuue kea e uroohm yi ngo keehd gen. ");
INSERT INTO lwo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Naa aniid gene Jeacuu, e ngo adoar gene ne cohg, abea keehd maano e nyoge mooge ge apoohdo e cwihny ge udaag. ");
INSERT INTO lwo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kaano e Jeacuu anyiihng buud gen urube kea, “Ruohdh gihr Dhaahr Juog kedea gihr ungoom kan cang ge acub yi cinga. ");
INSERT INTO lwo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Wa maano, cidhu ke bang upiny cang umuoju nyoge ke luogwahy ke nying Wuur, ke Waahd ke Wahy Juog. Yugu ngo wa maano beere yaa ngo ge udoohng ne jo'a. ");
INSERT INTO lwo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Puohnyu gen umag gene loohnge giih aroba yihru beer mee. Ngahyu ngo kejea a nud ke wun uwahdhe yi gug piny.”");
INSERT INTO lwo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1"," Gihn e naa kaa athub Ciig Beere ke nying Jeacuu Kriihjto ge Waahd Juog kii ngo. ");
INSERT INTO lwo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wa kaa agweede yi kitaab gihr agamloohngjuog ge cuohn ne Yicaaya, kejea Juog arubo kea, “Maany! Ngad wuohna uoohra wong maalo nyumi ne gwiir yooh yihri. ");
INSERT INTO lwo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nud ke duol me kwaag yi ukang, ‘Gwiir yooh yihr Ruohdh, gwiir yooh me ne cohg cohg yihre.’ ” ");
INSERT INTO lwo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ke nying gihn nu e Joon Ngad Luogwahy ake tuohl yi ukang e puohny nyoge kejea maan gene anyoohne giih ayug gene kedea umuoj wudh gen ke luogwahy beere anyoohne giih gen wii piny yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nyoge cang ke bang piny Judea maa yi geen Jeruucalem ge anuno bange. Maa abeehn gene urob gene adhemuohme giih atiihy gene oogo, batiene e wudh gen amuoj Joone ke piih Juog Naam Joohrdoan ne cub luogwahy yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Joon na ngaab yiehy amana maa acwaahj kedea deehl e naa atuohje yi badhe. Ngo ne cam caame giih na yoade yi dom. Ngo na bodh kaa kihj kedea baahnyo. ");
INSERT INTO lwo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nyoge apuohnye kobe, “Ngaa me teege akaal wiih teeg mara muu ulog beehno ke batiena nud. Ngaa me wuora wuoro keraahyo me a be rom gong piny ne goony thoon wuoy tiene. ");
INSERT INTO lwo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wudhu muoja kaa piih now, abea mare teeg Wahy Juog, e nuu ucube yihru.” ");
INSERT INTO lwo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yihdh nihn nu e Jeacuu ake beehno ke yoohn geen Naajaread yi piny Gaalili bang umuoj wiihe ke piih Juog ne cub luogwahy yihre. Wiihe amuoj Joone ke piih Juog yi naam Joohrdoan. ");
INSERT INTO lwo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nye kaa abeehne oogo yihdh piih, e niid gihn maa ayab yea maalo ubeehn Wahy Juoge me neehn akuur uluunge piny ne kew yi wiihe. ");
INSERT INTO lwo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","E duol ake lihngo kii lwahd maalo kobe, “Yih naa waahda maa anhyaara kedea cwihnya med rihi.” ");
INSERT INTO lwo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ke kaano e Jeacuu alwaahng Wahy Juoge oogo ukedhe ngo yi ukang kar keede, ");
INSERT INTO lwo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","unahge nihn jiehariow, e atiihb ukeehg e ne buohj ke tume ne dwaahnge. Keehd me ne beed Jeacuue yi ukang keew laahy me reje, e ngo ne kony wuohdjuoge konyo. ");
INSERT INTO lwo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Batien kaa amag Joon Ngad Luogwahy, e Jeacuu aci Gaalili. Kaano e ngo ake thubo ke puohny Ciig Beer gihr Juog. ");
INSERT INTO lwo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Athubo ke puohny nyoge kobe, “Cahng anaa arob Juoge abeehno kedea Dhaahr Juog ree anyoadhe arumo, wiiu yug giih anyoohne kedea yiihu Ciig Beer.” ");
INSERT INTO lwo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Cahng ni e Jeacuu ake caahdho ke bang dieng naam duohng gihr Gaalili, e Cimoane maa Andrya umen ge aniide niido e ge umahyo ke booy bang gihn ge anahg yaa maay. ");
INSERT INTO lwo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kaano e ge acuohn Jeacuue cuohno kobe, “Beehnu unahgu yaa waahdha. A adaahd udoohngu ne yaa kahl nyoge yihra wa kwaad kaano kahlu rej oogo nu.” ");
INSERT INTO lwo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ke wong kaano e booy giih gen awii gene ke piny kedea ubuodh gene batiene. ");
INSERT INTO lwo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ge acidh gene thiin mee ni, e yaaj ariow mooge ge aniide niido yi baabuur e ge kwen booy. Anahg Jeamij waahd Jebeade maa Joon umen. ");
INSERT INTO lwo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Maa acuohn Jeacuue gen, ubuodh gene batien ngo uwii gene Jebeade wur gen yi baabuur maa yaa tiihj giih anaa ajor gene. ");
INSERT INTO lwo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ke batiene e Jeacuu abeehn yi geen Kaparnaam. E anahge Cahng Cabadh (cahng yuohmo) e Jeacuu amon yi wod amaad gihr yaa Judea upuohnye yea. ");
INSERT INTO lwo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Naa athume ke puohny, e nyoge ake gaahy cang yi puohnye, bang gihn apuohnyo wa dhaano me yihre ne teeo, me wa e naa acub loohng Juog giih puohny ke deeh kaa acoon. Ngo kuu apuohnyo wa mar yaa loohng. ");
INSERT INTO lwo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kedea kaano, nyin me wiihe anaa atiihb reje anaa anudo yi wod amaad. ");
INSERT INTO lwo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","E nyin ake thubo ke maahr piny ke kwaago kobe, “Ngahda yih Jeacuu ngad Naajaread e gihn ne? Gihn keree e ne daahdi rog wan? Yih abeehn ne nahg wan ne? Kedea yih ngahya ne cohg yih naa Waahd Juog naa aoohr Juoge.” ");
INSERT INTO lwo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Maa acuow Jeacuue ngo kea, “Lengi! E thiow beehn oogo yi kuohm nyin.” ");
INSERT INTO lwo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Maa apaahj nyine kedea umaahre piny ke lalo e kuohme urihg ni, maa a'aay atiihb reje oogo ree. ");
INSERT INTO lwo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kedea ugaahy yaa anaa anudo cang, uthub gene ke peehny rog gen kob gene, “Beehda gihn e gihn? Puohny me nyaahn me yea ne teeo e naa atuohl ne wale gihn? Keehd atiihb reje e urubo yihr gen ke duol me teeg kedea uwuor gene lume.” ");
INSERT INTO lwo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ke kaano e nyinge awiihj ke bang yi Gaalili. ");
INSERT INTO lwo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yi kaa apahr Jeacuue oogo yi wod amaad e amon paar ge Cimoane e caahdh tiehd kaa Cimoane maa Andrya umen kedea Joon anaa acidho thiow ke gen. ");
INSERT INTO lwo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kaano e miih ciih Cimoane ree anaa jwaahy, ngo abud piny. Nye kaa awahnh Jeacuue wahnho e aguoe kaa arobo yihre. ");
INSERT INTO lwo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Maa abeehn Jeacuue bange umage bad ngo utihnge ngo maalo. Kaano e kuohme ake ngihnyo uaay jwaahye oogo ree kedea upiihe ne goong gen. ");
INSERT INTO lwo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ke wong thiehno e cahng kwaar piny, nyoge me thoohdh me rog gen naa atwaanye maa yaa guohb gen ne atiihb reje ge akahl bange. ");
INSERT INTO lwo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nyoge me thoohdh giih beed geen nu rog gen acong gene dhe wod. ");
INSERT INTO lwo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Maa athiehdh Jeacuue nyoge me rog gen naa atwaanye me thoohdh kedea urieme atiihb reje oogo yi koohm nyoge mooge. Thiow atiihb reje ge kuu ameehg Jeacuue rob bang gihn ngo ngahy gene kejea Jeacuu e naa Ngad Boadh nyoge. ");
INSERT INTO lwo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ke nyango e cahng kuu amoohlo, e Jeacuu ayedh maalo ucea kar keede kedea upiihe ne kwaj. ");
INSERT INTO lwo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Maa abeehn Cimoane maa yaae naa anudo keehde, uthub gene ke cej ka ne Jeacuue yea. ");
INSERT INTO lwo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Maa ayoad gene ngo e ukwahyo, urub gene yihre kob gene, “Nyoge cang ge daahd yihn.” ");
INSERT INTO lwo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Maa akobe ngo yihr gen kea, “Beeh coa yihdh miehr me cahng mee kan, bang a daahd upuohnya kuohn nu thiow. E naa gihn abeehna ke nyinge.” ");
INSERT INTO lwo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Maa acidhe ke bang yi Gaalili e puohny nyoge yihdh wuud amaade kedea atiihb reje ge rieme ke oogo rog nyoge. ");
INSERT INTO lwo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Maa abeehn ngaa me ree ne dhoobo, uthube ke piehj, e cunge arunge piny nyum Jeacuu kobe, “Nea cwihnyi ne bange, e kea yug kuohma udoohnge kwel.” ");
INSERT INTO lwo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Naa aniid Jeacuue ngoohng wonge, e cinge arwaage bang ngo maa agweele nyin maa arube yihre kobe, “Cwihnya ne bange! Beehn kuohmi doohnge kwel.” ");
INSERT INTO lwo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nye wong kaano e kuohme ake doohng kwel mee. ");
INSERT INTO lwo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Maa arob Jeacuue ngo yihre kea, “Lihng gihn roba yihri. Gihn ayug ree rihi awaahn ni kan keá waayi yihr ngaa moogo. Abea aay awaahn ni ucii ne nyoadh rihi yihr ngaa lam giih kweehr umaanye kuohmi. Nea kuohmi amaanye, kea yug giih kweehr wa kaa anaa arob Moaje ngo, bang ne nyoadh ngo yihr nyoge kejea dhoobo tooro rihi.” ");
INSERT INTO lwo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Abea naa a'aay nyine, e ake thubo ke rob gihn ayug ree yihr nyoge. Gihn nu e Jeacuu kuu arom beehdo yihdh geedh nu bang gihn nyoge me daahd uthiehdh gen ngo amoal gene ke piny. Noono uaaye maa awiie geew piny ne beehd kare keede. Abea kihde now, nyoge ge apoohdo e ge beehn bange ke bang yihdh miehr ne dug. ");
INSERT INTO lwo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Batien nihn me noog, e Jeacuu aduu Kaparnaam. Naa alihng bange kejea ngo ne paajo ka beede, ");
INSERT INTO lwo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","e nyoge me thoohdh rog gen acong gene congo ubeehn gene bang Jeacuu. Wod anaa apahng ke dhaano utaahngo uwahdhe yi kala kar tiel tooro. Kaano e Jeacuu ake thubo ke puohny gen ke lum Juog. ");
INSERT INTO lwo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nyoge angween ge abeehno bang Jeacuu e ge bien dhaano maa abab piny. ");
INSERT INTO lwo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Naa aniid gene ngo kejea ka me rom gene wahdh wod bang Jeacuu tooro, e ge ayedh maalo wiih wod maa athub gene ke ngaany ka me rom gene ngaan abab piny lwaay piny kii ngo nyum Jeacuu yi diehr wod. Noono ulwaay gene ngo piny nyum Jeacuu ke belo. ");
INSERT INTO lwo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ge aniid Jeacuue kaa ayiih gene kii ngo, e akobe kobo yihr ngaan abab piny kea, “Waahda! Adhemuohme giihi ge awii piny yihri.” ");
INSERT INTO lwo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kiin nyoge kaano yaa loohng Juog ge anaa anudo yi wod tiehd ke Jeacuu. Naa alihng gene gihn arob Jeacuue yihr nyin ni, e cwihny gen ake thubo ke ngoan kob gene, ");
INSERT INTO lwo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nyin rubo wa maano kaa nying gihn? Daahd urome wiihe ke Juog kejea anyoohne giih ayug ge wiie ke piny! Wa kuohm Juog adhahle!” ");
INSERT INTO lwo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Giih angoan gene ke cwihny gen ge kaa aguo Jeacuue ke ngeyo maa arube yihr gen kea, “Nye yaage! Gihn e ne ngoanu ke nyinge yaa aduunu? ");
INSERT INTO lwo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Maa aweehne e ne teeg ke tiihyo, ne rob ngo yihr ngaan abab piny kejea, ‘Adhemuohme giihi ge awii piny yihri ne,’ wale ne rob ngo yihre kejea, ‘Yedh maalo ucaahdhi?’ ");
INSERT INTO lwo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Awaahn a ge adoohng ne dhaano utaahngo, a utiihyo ke gihr nyepiny kedea uniidu ngo, gihn me be rom ree ke tiihyo yihr dhaano utaahngo ne nyoadh ngo yihru kedea ungahyu ngo kejea yihra ne tee wiih ngoom me wiia adhemuohme giih nyoge piny.” Maa akob Jeacuue ngo yihr ngaan abab piny kea, ");
INSERT INTO lwo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ateeda yihri kaa yedh maalo ukaabi belo gihri ucii paajo.” ");
INSERT INTO lwo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Maa ayedhe maalo umade yea belo gihre kedea uaaye ke waahdh. Nyoge ge agaahy cang kedea upuoj gene Juog e ge muohj koohr Juog kob gene, “Gihn me wa gihn kuu akuong wane ke niido.” ");
INSERT INTO lwo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jeacuu a'aay ucea ne waahdh ke bang dieng naam duohng gihr Gaalili. Gihn nu e nyoge me thoohdh ngo atieg gene piny maa athube ke puohny gen. ");
INSERT INTO lwo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Naa a'aaye kaano e Leabi waahd Alpaawo aniide niido e ngo apiih ne gwaay cuol maa arob Jeacuue ngo yihre kea, “A daahd udoohngi ne ngad waahdha.” Maa ayedhe maalo uaaye tiehd ke Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Cahng man e Jeacuu anaa acuohn Leabe paare. Leabi anahg ngad gwaaj cuol. Naa akahl cam e Jeacuu acahmo tiehd ke yaa gwaay cuol maa nyoge maa yaa adhemuohme ge cuohn Judea ne nyoge me reje. Nyoge me thoohdh me neehn yaa ni ge ne na buodh batien Jeacuu. Jo waahdhe thiow ge anaa ake cahmo keehde maa yaa ni tiehd. ");
INSERT INTO lwo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kaa aniid yaa loohng Juoge giih Paarijea ngo e ucahmo tiehd ke yaa nu, e jo waahdh Jeacuu apeehny gene peehnyo kob gene, “Beehda ke nying gihn e beehn Jeacuue upiihe ne cam ka maa acielo keehd yaa gwaaj cuol maa nyoge me dhahl loohng Moaje? Kwihye kejea ge nyoge maa amaan paajo me gihn me nweehd nyoge ke gen tooro ne?” ");
INSERT INTO lwo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ge alihng Jeacuue rob nu e arobe robo yihr yaa loohng kea, “Padh yaa rog gen tooro atwaanye ge ne daahd akiihm, abea beehda nyoge me tuu ge ne daahd akiihm. A kuu abeehn wiih piny kan kaa nying yaa koohbo kejea ge abiohgrwaale. A abeehno kaa nying yaa ayiih ngo rog gen kejea ge yaa adhemuohm.” ");
INSERT INTO lwo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yihdh nihn nu e jo waahdh Joon Ngad Luogwahy maa Paarijea ge anaa ake kweehro ke caame noono e ge be na cahmo ke nying wuor Juog. Kaano e nyoge abeehn bang Jeacuu upeehny gene ngo kob gene, “Wa yaa waahdh Joon maa yaa Paarijea ge be cahmo ke nying gihn yug gene giih kweehr yihr Juog, abea yaa waahdhi ge be kweehro kaa nying gihn?” ");
INSERT INTO lwo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Maa abeehr Jeacuue ngo yihr gen kea, “Kare nud umeehg yaa acuohn athiehge yi nyuohme kweehr cam abea athiehg nud bang gen ne? ");
INSERT INTO lwo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Abea cahng ukaab athiehg oogo bang gen ubeehn. Cahng nu e nuu ukweehr gene cam. ");
INSERT INTO lwo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Padh kare udhahb dhaane waaro me nyaahn rih jwaahd waaro maa ayiej. Bang gihn nea waahro gihn nu ree cea ke ne juunyo e wong kaa adhahb ree cahge kaa jwaa ");
INSERT INTO lwo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Dhaar weehne e naa akuong koongo me yaahny ke pee yi keej maa acoon maa akuoj? Dhaar yug ngo wa gihn nu udaar ke koongo.” ");
INSERT INTO lwo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Cahng man, Cahng Cabadh, e Jeacuu anaa ake caahdho keehd jo waahdhe e ge cor yi puohdho. Kaano e jo waahdhe ge ake thubo ke jag cwed beel e ge raam gene ke maalo. ");
INSERT INTO lwo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","E yaa Paarijea ge ake rubo yihr Jeacuu kob gene, “Maany kwaad gihn yug jo waahdhi! Ge tiihy gihn maa acier loohng Moaje ke tiihyo cahng Cabadh.” ");
INSERT INTO lwo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Maa abeehr Jeacuue ngo kobe, “Ka moogo e gihn anaa atiihy Deabid Ruohdhe naa anahg kahje en maa joe anaa akwaanu? Deabid anaa abeehn ne ci yi Wod Juog maano e Abithaar e naa anahg ngad duohng yaa lam ucame amune giih lam ne giih kweehr kedea ucube mooge yihr yaae ne camo. Abea beehda amune me be cam dhaane maa now me padh ngad lam giih kweehr.” ");
INSERT INTO lwo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Maa agooye wiih robe piny kea, “Cahng Cabadh ayug Juoge kaa nying dhaano, abea Juog dhaano keá cago ke nying Cahng Cabadh. ");
INSERT INTO lwo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nea neehn maano e kare nud yihra a ge adoohng ne dhaano utaahngo, ugweehga gihn yug jo'a Cahng Cabadh bang gihn a naa ruohdh acub loohng gihr Cabadh yi cinge.” ");
INSERT INTO lwo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Cahng man e Jeacuu anaa aci yi wod amaad gihr Judea. Dhaano me cinge abaahl anaa anudo yi wod. ");
INSERT INTO lwo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Gihn nu, e nyoge mooge maa anaa apiih thiow ge anudo yi wod amaad, nyoge maa alwaay rog gen piny ne maany gihn uyug Jeacuue Cahng Cabadh rih nyin cinge abaahl. Nea ngo thiehdhe thiehdho e Jeacuu luom gene luomo bang gihn loohng Juog adhahle naa athiehdhe dhaano Cahng Cabadh. ");
INSERT INTO lwo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kaano e Jeacuu nyin cinge abaahl acuohne cuohno bange kea, “Beehn wong maalo kan ne cuung yi diehr kiin nyoge.” Maa acidh nyine bange. ");
INSERT INTO lwo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kaano e yaa ni alwaay rog gen piny ge apeehny Jeacuue peehnyo kobe, “Beer gihn aweehne ke tiihyo Cahng Cabadh? Tiihy gihn me beer ne wale tiihy gihn me raaj? Kony wahy dhaano uthiehdhe ne wale paahl dhaano oogo uthowe?” Maa aleng gene ne caaj e gihn arob Jeacuue kuu abeehr gene. ");
INSERT INTO lwo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Keehdo e Jeacuu amaahny bang gen e cwihnye raaj bang gihn aniide e wudh gen teeg maa arobe ngo yihr nyin cinge abaahl kea, “Nyieh! Riihy badi.” E nyin bade ariihye riihyo ubeehn bade udoe kare ne rihb. ");
INSERT INTO lwo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yaa Paarijea naa alwaay rog gen piny ne tudo rog gen akwany gene maalo naa aniid gene gihn atiihy Jeacuue. Maa awaad gene oogo ucong gene wudh gen keehd yaa batien Eroade ne gweehg dhe yooh me nahg gene Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Maa abeehn Jeacuue uaaye ke jo waahdhe uci gene dhe naam duohng. Gihn nu maa awaad nyoge me thoohdhe bange ke yoohn piny Gaalili ");
INSERT INTO lwo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","kedea ke yoohn piny Judea maa geen Jeruucalem maa piny Yiduuma. Nyoge mooge ge abeehno ke yoohn naam Joohrdoan kedea mooge thiow ke yihdh miehy cahng ke geen Taayr maa geen Ciihdoan. Jo ni thoohdh ge abeehn bang Jeacuu naa alihng gene ngo kejea giih me thoohdh ge atiihye. ");
INSERT INTO lwo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kaa aniid Jeacuue ngo kejea nyoge me thoohdh ge waahd bange, e akobe yihr jo waahdhe kea gwiir gene baabuur yihre beere e urubo yihr nyoge ke ka me baahr ke gen. ");
INSERT INTO lwo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nyoge me thoohdh ge athiehdh Jeacuue cahng nu, e naa gihn apoohde e yaaj mooge ge nyiihng bange ne gweel kuohme ke cing gen beere ge thiehdhe thiehdho. ");
INSERT INTO lwo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yaa rog gen naa atiihb ukeehg, ge niid gene Jeacuu, e rog gen riedh gene ke piny thaahdh tiene ne wuor ngo e ge uyuog ke deeh lalo me teeg kob gene, “Yih naa Waahd Juog ke ngude.” ");
INSERT INTO lwo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Abea ge na cuow Jeacuue cuowo teeg mee bang gihn kuu adaahd ngo urob gene ngo yihr nyoge kejea e Waahd Juog. ");
INSERT INTO lwo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Batiene e Jeacuu a'aay ucea wiih good maa acuohne yaae ge daahde ke cwihnye bange. Maa abeehn gene bange ");
INSERT INTO lwo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ukwanye nyoge apaar wonge ariow kiin gen maa acube nying acielo yihr gen kejea ge ucuohn ne jo oohr. Adaahd ngo ubeehd gene buude beere ge oohre ke oogo ne puohny lum Juog yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Thiow ge amuoje ke teego me riem gene atiihb ukeehg oogo rog nyoge. ");
INSERT INTO lwo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yaa anaa akwany Jeacuue ge gen: Cimoan me nying tuode acag Jeacuue ne Piihter, (Lum yea beehda kihdo). ");
INSERT INTO lwo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Maa waahd Jebeade kar ge ariow, Jeamij kedea Joon kedea ucube nying acielo yihr gen kejea ge ucuohn ne Boneargya (Lum yea ge teeg wa maahr kodh). ");
INSERT INTO lwo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Maa Andrya kedea Pihlihb maa Bartholomeao, Matheewo, Thoamaj, Jeamij waahd Alpaawo. Thaadoj, maa Cimoane ");
INSERT INTO lwo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kedea Juudo Yijkaariod ngaan anaa abeehn ne luom Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Batiene e Jeacuu ado paajo abea keehd maano e nyoge rog gen acahg gene ke congo, ubeehn gene bange. Nyoge anaa amahdo thoohdh kedea utoor kar cam ke ngude yihr Jeacuu ke jo waahdhe, bang gihn ge ake rubo yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kaa alihng jo paar ge Jeacuue ngo, e ge abeehn ne maany ngo bang utuu gene en bang gihn nyoge akoohbo kejea, “Wiihe be beer.” ");
INSERT INTO lwo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yaa loohng Juog naa abeehno ke yoohn Jeruucalem ge arubo yihr nyoge kejea Jeacuu ree ne ruohdh atiihb ukeehg ge cuohn ne Beeljebuul. Arob gene yihr nyoge mooge kejea padh ke dhe yooh maa now e ne riem Jeacuue atiihb ukeehg oogo rog nyoge, abea ge rieme oogo kaa tee maa acub Beeljebuule yihre. ");
INSERT INTO lwo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Gihn nu e nyoge acuohn Jeacuue bange upeehnye gen e robe kaa ucaale kobe, “Kare nud ubeehn atiihb ukeehge urieme ree oogo rih dhaano? ");
INSERT INTO lwo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Beer, abea nea tien paajo acielo ree apaahnge udog gene rog gen ke liny, e tien paan nu ngo be taaj ne? ");
INSERT INTO lwo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kedea ne nyethea dhaano acielo ge adog rog gen ke liny, e paan nu be toar ne? ");
INSERT INTO lwo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Wa gihn nu thiow, atiihb ukeehg ka me doge ree tooro. Nea dog ree e wiihe dhiil guuo utoor gihr nyinge. ");
INSERT INTO lwo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ngaa noono rom cidh ne tub paar ngaa me teeg me yihre ne waahd? Paar ngaa nu be rome ke tubo nea padh taajo e naa ataaj gen kedea utuohy gen piny. Kaano arumo e giih paar ngaa me teeg ge rom kaa tubo utoor gihn me doohnge. ");
INSERT INTO lwo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","A rob athiir yihru, adhemuohme giih nyoge cang ge uwii piny kedea kwaad luube me reje giih ateed ke nying Juog ge uwii Juoge piny thiow. ");
INSERT INTO lwo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Abea kwaad ngaa rob luube me reje rih Wahy Juog, adhemuohme be wii piny bang gihn be rom ree ke wuuny oogo.” ");
INSERT INTO lwo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jeacuu yea acoodhe piny ke nying gihn arob ree, naa ree ne atiihb ukeehg. ");
INSERT INTO lwo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Batiene e miih Jeacuu maa ge wuud wahn ge ake beehno ucuung gene yi kala maa aoohr gene dhaano acielo wod bang Jeacuu ne rob ngo yihre kejea ne nyoge me daahd en yi kala. ");
INSERT INTO lwo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nyoge me thoohdh ge anaa wod bang Jeacuu. Maa ateede yihre naa, “Miihu maa wuud wuru gen nii kala yih daahd gene daahdo.” ");
INSERT INTO lwo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Maa abeehr Jeacuue ngo yihr gen kea, “Ngaa e naa miiha? Kedea yaa weehne ge naa wuud wura?” ");
INSERT INTO lwo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Maa amaahnye bang yaa anaa apiih buude batiene e akobe, “Maahnyu kan! Yaa ni ge naa ge miiha maa ge wuud wura! ");
INSERT INTO lwo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kwaad dhaano me tiihy gihn daahd Juoge, e naa nyewura kedea e naa miiha kedea e naa uwura.” ");
INSERT INTO lwo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Cahng man keehdo Jeacuu anaa ne puohny nyoge dieng naam duohng. Nyoge giih anaa amahdo buude ge anaa athoohdho keter. E niide ngo wa gihn nu, e adhiil ci yi baabuur me cahng ke dhe agala beere nyoge puohnye puohnyo. ");
INSERT INTO lwo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kaano e ake thubo ke puohny nyoge ke giih me thoohdh, e ge puohnye kaa ucaale kobe, ");
INSERT INTO lwo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Lengu do! Umodho coon nyin moogo koohdhe anaa akaabe ne ci yi puohdho ne puur. ");
INSERT INTO lwo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Abea naa ayore koohdhe e mooge ge apahdh thaahng yooh maa abeehn winye uted gene gen. ");
INSERT INTO lwo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Koohdhe mooge ge apahdh wong leelo me yea tooro ngoom me beeye. Koohdh nu ge atuuy uyuuj beele maalo piow piow. ");
INSERT INTO lwo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Abea naa alier cahnge, e ge aguo nahro utal gene bang gihn biey gen kuu anieng piny. ");
INSERT INTO lwo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mooge ge apahdh piny yi dhyaay kedea moodho. Abea naa adoong gene, e ge ake juul bang gihn ge ateel dhyaaye piny maa abahnge ge kuu acieg. ");
INSERT INTO lwo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Abea koohdhe mooge ge apahdh ka me yea ne ngoom me beeye maa atuuy gene beer mee kedea ucieg gene, me wiih acielo yea ne cwed beel kar dhaano aduuno wonge apaar kedea mooge yihdh gen ne jiehadahg kedea mooge dahng yihr gen ne jiehabiihj.” ");
INSERT INTO lwo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Maa agooy Jeacuue wiih lume piny kea, “Nea ngaa yihdhe nud me lihngo, e kea lihnge.” ");
INSERT INTO lwo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Naa adoohng Jeacuue keehd joe ge apaar wonge ariow maa yaaj mooge giih caahdh keehde batien kaa a'aay nyoge, e Jeacuu apeehny gene peehnyo ke gihn ne yihdh luub ucaale giih robe yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Maa arobe ngo yihr gen kea, “Ne ngej yihdh luub Dhaahr Juog beehda Juog e naa acub ngo yihru wu jo waahdha. Abea ngo rob yihr nyoge mooge maa now kaa ucaale. ");
INSERT INTO lwo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ngo udoohng wa kaa anaa agweede naa, ‘Nying gen upeeny gene piny ne maahnyo abea gihn muu uniid gene utooro kedea yihdh gen uceg gene piny ne lihng abea gihn muu ulihng gene utooro. Nea be ne nahg wa gihn nu, e giih nyepinye ne niid gene kedea ge ne lihng gene, noono e wudh gen ne waar gene udog gene bang Juog uwiie anyoohne giih ayug gene piny yihr gen.’ ” ");
INSERT INTO lwo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Maa apeehny Jeacuue gen kea, “Abea wun, ucaale gihn yea adeadu ne? Nea yea kuu adeado e ucaale mooge yihdh gen ungeyu ke naa diih? ");
INSERT INTO lwo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ngad yor koohdhe neehn ngad puohny lum Juog. ");
INSERT INTO lwo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nyoge mooge keew yaa alihng lum Juog ge uroomo ke koohdhe giih apahdh thaahng yooh ucam winy gen. Umodho kaano e lum Juog anaa alihng gene beer mee, batien ka me thiin e atiihb ukeehg ake beehno ukahle lum Juog oogo yi cwihny gen. ");
INSERT INTO lwo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wa kwaad maano, koohdhe giih apahdh kiin leele ge nyoge me lum Juog alihng gene umodho ke med cwihny. ");
INSERT INTO lwo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Abea ge nyoge me cwihny gen be teeg yi guum giih me reje. Noono e ge ukweer ke lum Juog. ");
INSERT INTO lwo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yaa neehn koohdhe giih apahdh yi piny dhyaay kedea moodho ni, kwaad yaa nu ge nyoge me lum Juog alihng gene. ");
INSERT INTO lwo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Abea gihn raaj ke gen, beehda gihn poohde e cwihny gen udiiw kedea cwihny gen poohd ne bang giih lonyo maa giih upiny. Kwaad giih nu lum Juog kahl gene ke oogo yi cwihny gen kedea udoohng gene ne nyoge me be bar maalo ke lum Juog. ");
INSERT INTO lwo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Abea nyoge mooge ge neehn koohdhe giih apahdh ka me yea ne ngoom me beey. Yaa nu lum Juog alihng gene kedea uyiih gene ngo ke cwihny gen cang ne jwag giih beeye ge tiihj yihr Juog. Gihn nu e naa arom rih beel maa acieg me wiih acielo yea ne cwed beel kar dhaano aduuno wonge apaar kedea mooge yihdh gen ne jiehadahg kedea mooge dahng yihr gen ne jiehabiihj.” ");
INSERT INTO lwo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jeacuu arubo thiow yihr gen kobe, “Kare nud ukahl lama yea wod ucahge ke wum piny kaa adiido ne? Wale ukaabe ucube thar agreehm? Ngahda ngo cub maalo ka me meenye yi wod cang? ");
INSERT INTO lwo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bang gihn kwaad gihn wiihe wum, wiihe uaal oogo beere ke niido. ");
INSERT INTO lwo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nea ngaa yihdhe nud me lihngo, e kea lihnge.” ");
INSERT INTO lwo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Maa acahge rob yihr gen kea, “Cubu cwihnyu piny udeadu yihdh luube giih alihngu. Kwaad kaa tiihyu kii ngo ");
INSERT INTO lwo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","e ne wiihe uduog Juoge yihru. Ateeda wa maano bang gihn ngaa me yihre ne giih me beeye me thoohdh, giih nu ge udhiil Juoge ke jwaa ke mooge me thoohdh. Abea ngaan yihre tooro nyepiny, keehd gihn anaa yihre ngo udhiil ke twahr oogo yi cinge.” ");
INSERT INTO lwo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Maa acahge rob kea, “Dhaahr Juog ngo neehn koohdhe maa ayor yi puohdho. ");
INSERT INTO lwo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Batien kaa ayor koohdhe e ngaan ayor gen gihn maa acahge ke yugo tooro. Abea keehd maano atoor gihn maa atiihye, e koohdhe ge atuuy ke dhe yooh me kwihye. ");
INSERT INTO lwo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Beehda beey piny keede e naa ameehg beel cieg. Umodho beehlo udoongo batiene e ngo udhahyo kedea uciege. ");
INSERT INTO lwo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Naa aniide beel ge acieg e ngo angeye kejea kar kaj abeehno, noono maa akaje gen.” ");
INSERT INTO lwo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Maa acahge rob kea, “Dhaahr Juog uroma ke rih gihn? ");
INSERT INTO lwo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wale a ucaal gihn ne rome keehde! Ngo uroomo keehd wong jaaro ge thiin maa akaab dhaane upiidhe ngo. ");
INSERT INTO lwo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Abea keehd me thiin kohnho yaadh gihn apiidh, e ngo beehn ne doongo udoohnge ne yaadh me duohng keew yen kedea ukaare ke baahd me thoohdh. Kaano e winy wuud gen geer gene ke wiihe.” ");
INSERT INTO lwo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ke dhe yoohn ucaale me wa giih ge naa apuohny Jeacuue nyoge ne ngahy lum Juog wa kwaad kaa rom gene ngo ke ngahyo. ");
INSERT INTO lwo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nyoge ge keá puohnyo kaa dhe yoohn cuohn loohng, abea ge apuohnye kaa ucaale. Abea ge adoohnge ke jo waahdhe ge keed gen, e yihdh ucaale ge adoge ke kwaano yihr gen beer mee. ");
INSERT INTO lwo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kaa awahdhe ke thiehno cahng nu acielo, e akob Jeacuue yihr jo waahdhe kea, “Ngudo loo naam duohng kun ca.” ");
INSERT INTO lwo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Maa akiiw gene baabuur e Jeacuu ree keá daa kaa anaa apiihe yea. Akuud nyoge ge anaa awii gene ngahdh gen kedea baabuure mooge ge anudo tiehd ke gen. ");
INSERT INTO lwo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kaano e deeh yamo me duohng ree atihnge tihngo maa anahg piihe thaga yi baabuur ka athewo umiid baabuure olo. ");
INSERT INTO lwo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Abea Jeacuu wonge kaa akwal niine. Maa atahng gene ngo kob gene, “Ngad puohny! Gihn keree e bahnge wa be konyi yi thoo? Maany baabuur ka daahde diihr piny ke won.” ");
INSERT INTO lwo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Noono e atahng ucuowe yamo cuowo kobe, “Cuungu.” Maa acuung yame kedea piih ne dihl. ");
INSERT INTO lwo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Maa arub Jeacuue yihr gen kobe, “Gihn e mag lwahre wun? Wa lum Juog poohd kuu ayiihu!” ");
INSERT INTO lwo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Maa ane wudh gene yoam ke lwahr. Kaano e ge ake thubo ke peehny rog gen kob gene, “Kwaad ngaa me ngihde e gihn? Keehd yamo kedea athewo ngo wuor gene wuoro thiow?” ");
INSERT INTO lwo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Batiene e Jeacuu maa jo waahdhe ge awahnh loog naam duohng, yi piny yaa Graaja. ");
INSERT INTO lwo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nye kaa abeehn Jeacuue wiih agala keehd yaae, e ngo ake roohmo ke ngaa me ree naa atiihb ukeehg. Ngaan ngo abeehno kaa yoohn wudh leehde ");
INSERT INTO lwo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ka beede. Abea keehd me tuohy cinge kedea tiene ke gele, ");
INSERT INTO lwo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","e ge coohde coohdo. Noono utoor ngaa me teeg me rom ngo ke mag piny. ");
INSERT INTO lwo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ke nying nihn, decahngo kedea dewaahr, ngo na beehdo kaa ngweej ke lalo ke bang wudh leehde maa wudh goode. Thiow ngo na beehdo kaa thom ree ke leele. ");
INSERT INTO lwo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kaa aniide Jeacuu ke ka me baahr, e agoohd bang ngo upahdhe wudh conge nyume ne wuor ngo wa ka wuor ngaa me duohng. ");
INSERT INTO lwo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kaano e Jeacuu akaange oogo ke rob e ukwaago kea, “Gihri gihn ke an, Jeacuu Waahd Juog Aciehg! Wongi akwaya nyum Juog, a keá joohri keter.” ");
INSERT INTO lwo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wong Jeacuu akwaye bang gihn Jeacuu anaa athubo ke riem atiihb ukeehg oogo rih nyin. ");
INSERT INTO lwo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kaano e Jeacuu atiihb ukeehg apeehnye peehnyo kea, “Nyingi ngaa?” Maa abeehre ngo kea, “Nyinga Amahr, bang gihn wa thoohdh keter.” ");
INSERT INTO lwo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kaano e atiihb ukeehg apiih ne kway wong Jeacuu kejea ge keá rieme piny moogo. ");
INSERT INTO lwo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Abea nye kaano akwaye wong Jeacuue, amahr kudhruue ge anaa ake nyahmo dieng good. ");
INSERT INTO lwo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Maa abeehn atiihb ukeehge, ukwaye wong Jeacuu kobe, “Riem wan yihdh kudhruue giih ca umon wane rog gen.” ");
INSERT INTO lwo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Maa ameehg Jeacuue ge mon rog kudhruue. Ge anahg kudhruue me thoohdh me wahdh kar alihbe ariow. Gihn nu e kudhruue ge ane rudh ke ngweej, e ge loohn piny ke dieng good maa anahg gene thoadh yi naam duohng umud gene. ");
INSERT INTO lwo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kaa aniid yaa kwaahe kwaad gihn nu, e ge ake goohdo ke ngweej ne rob gihn ayug ree yihr nyoge ke bang yi geew kedea miehy cahng ke geew. Kaano e nyoge ake rihngo ne maany gihn ayug ree. ");
INSERT INTO lwo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Naa awahnh nyoge e ge niid ngaan ree anaa atiihb ukeehg e ngo apiih now kedea angahbo beer mee kedea wiihe kwel bekihd gihn me ne ree. Gihn nu e nyoge atud yi deeh tee gihn ariem atiihb ukeehg oogo ree. ");
INSERT INTO lwo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Noono uthub yaa anudo kaa anaa ayug gihn nu ree yea, ke kwaan gihn ayug ree rih nyin ree anaa atiihb ukeehg kedea gihn ayug ree rog kudhruue. ");
INSERT INTO lwo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Naa alihng giih ayug rog gen e wong Jeacuu akway yaa geen nu kwaayo kejea aaye oogo yi geen gen. ");
INSERT INTO lwo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","E naa adoohnge wa Jeacuu yedh yi baabuur, e nyin ree anaa atiihb ukeehg wong Jeacuu akwaye kwayo beere ge ucaahdho tiehd. ");
INSERT INTO lwo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lum nyin kuu ayiih Jeacuue. Noono maa akoohbe yihr ngo kea, “Do paaru bang waahdu ne teed gihn beer atiihy Juoge yihri. Bang gihn Juog cwihnye aluue caahn rihi e naa gihn ayuge gihn me beer yihri.” ");
INSERT INTO lwo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Maa a'aay nyine ucea paar gen kedea uthube ke waaj gihn ayug Jeacuue yihre ke bang wudh geedhe giih cuohn ne Geedhe Apaar. Yaa alihng giih ateed nyine ge adog gaahy yi kwaad gihn me wa gihn nu. ");
INSERT INTO lwo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jeacuu a'aay ke baabuur udoge ngudo loog naam duohng. Kaano e nyoge me thoohdh wiih ngo acong gene piny utoor kar tiele. ");
INSERT INTO lwo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ruohdh wod amaad gihr Judea me nyinge Jearuuj abeehno upahdhe wudh conge nyum Jeacuu ");
INSERT INTO lwo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ne kway wong ngo kobe, “Nyaara, me thiin ne piny kaa atwaany kar wahy tooro ree. Beehni uci ne cub cingi wiihe beere ngo ubodho.” ");
INSERT INTO lwo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Gihn nu e ge apahdh yooh tiehd keehd Jeacuu ne ci paar nyin. Amahr yaa anudo thiow rog gen akwany gene ne waahdh tiehd ke Jeacuu. Ngo anaa atieg piny ne cohg ucaahdh gene e rog gen thiehr gene thiehro maahdh maahdh. ");
INSERT INTO lwo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Keew amahr yaa nu atieg ngo piny, dhaago anudo maa abang atwaanye keter. Dhaago me remo uwuur ree ke run apaar wonge ariow e ngo be cuung. ");
INSERT INTO lwo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Run nu ge anahge kaa raahm. Bekihd ngad theehdho me keá tumo, abea e naa kaa adhal atwaanye. Awaahn ni ngo adoohng ke cinge now bang gihn giih anaa yihre cang ge arwaahnyo ke nying atwaany. ");
INSERT INTO lwo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Dhaar ni, bang Jeacuu alihngo yihre ke coon. Naa aniide Jeacuu e amoal amahr nyoge piny, e abeehno ke ngahy Jeacuu maahdh. Ge awahnhe buud Jeacuu ");
INSERT INTO lwo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","e ngo agweehge ke cwihnye kea, “Keehd me gweela ke waaro gihre now e atwaany uaay oogo riha.” ");
INSERT INTO lwo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nye kaa agweele waahr Jeacuu gweelo e aguoe kaa yoado e wahye aduu ree bang gihn remo acuungo. ");
INSERT INTO lwo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nye kaano acuung reme e naa nye kaa angej Jeacuue ngo kejea tee gihr thiehdh nyoge gihn ree ngaa maa athiehdhe nud! Gihn nu e Jeacuu amaahny ngahye maa apeehye kea, “Yaage! Ngaa e naa agweel an?” ");
INSERT INTO lwo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Maa abeehr jo waahdhe ngo yihre kob gene, “Ngo be niidi e nyoge yih miid gene kaa jwang piny ne? Yih dog gihn ke peehnyo kii, ‘Ngaa e naa agweel an?’ ” ");
INSERT INTO lwo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Abea Jeacuu ake maahnyo ke ngaa agweele. ");
INSERT INTO lwo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","E dhaar ni ngo aguoe ke modho ubeehne wong maalo nyum Jeacuu maa athube ke teed athiir gihn ayug ree. ");
INSERT INTO lwo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Maa akoohb Jeacuue kea, “Nyaara. Cidhi ke yoohm rihi. Yiiho mari yih aboadhe.” ");
INSERT INTO lwo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","E poohd e Jeacuu urubo ke dhaar ni, e dhog awahnho yihr Jearuuj ke yoohn paare kejea atwaany nyaari adoohng ne gihn me raaj, gihn me nahgi ruohdh ke waahdh ke nyinge tooro. ");
INSERT INTO lwo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jeacuu, gihn arob ngo adhaahre maa arube yihr Jearuuj kea, “Yih keá tudo abea yiiho gihri ge nii cwihnyi kejea nyaari thiehdha thiehdho yea ngo keá waari.” ");
INSERT INTO lwo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kaano e Jeacuu Piihter maa Jeamij kedea Joon umen ge anaa akwanye cog ne yaa bar keehde ne ci paar Jearuuj. ");
INSERT INTO lwo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Naa awahnh gene paar ruohdh e ge yuud paajo e ane juj ke lalo. ");
INSERT INTO lwo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kaano e Jeacuu amon wod, maa arube kea, “Wu yuog gihn? Nyethiin kuu athow gihre beehda niine!” ");
INSERT INTO lwo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","E yaa anaa wod ge angiero kejea gihn me ngahy Jeacuue ke nying thoo tooro. Kaano e ge ariem Jeacuue ke oogo yi wod kedea uaaye keehd wur nyethiin maa men kedea joe ge adahg ge anaa acaahdhe keehd gen ne ci wod apiehl nyethiin yea. ");
INSERT INTO lwo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Naa awahnhe wiih nyethiin e bad ngo atihnge ke maalo maa akoohbe kea, “Nyethiin, ateeda yihri kejea tihng rihi uyedhi maalo.” ");
INSERT INTO lwo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ke wong kaano e nyethiin a'aj maalo uthube ke waahdh (Rune anahg apaar wonge ariow.) ");
INSERT INTO lwo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Noono, maa arub Jeacuue kejea muoj nyethiin ke cam. Nyoge acwaahng naa aniid gene gihn ayug ree. Abea arob Jeacuue yihr gen kejea keá them gene piny urob gene gihn ayuge yihr nyoge mooge. ");
INSERT INTO lwo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kaano e Jeacuu abeehn ne aay Kaparnaam ne ci geen paar gen, Naajaread ge anaa akuonge puohny yea. Jo waahdhe ge ake caahdho keehde tiehd. ");
INSERT INTO lwo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ge anahge Cahng Cabadh e Jeacuu nyoge apuohnye puohnyo yi wod amaad. Nyoge me thoohdh ge anaa anudo cahng nu maa alihng giih puohnye. Kaa alihng gene puohny Jeacuu lihngo, e dhog gen ake talo naa agaahy gene yi puohnye. Kaano e ge ake peehyo ke rog gen kob gene, “Naa ceh! Kwaad puohny ni ayoade ke kee? Ngaa e naa amuoj ngo ke teeg wong ngey yihdh luube kedea tee me rome giih me gaahy nyoge ke tiihyo? ");
INSERT INTO lwo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ngahda beehda waahd nejaar ne? Ngahda waahd dhaar cuohn ne Maarya ne? Jeamij maa Jocebe maa Juudo kedea Cimoane ngahda ge beehda wuud wahn ne? Ge nye wahn, ngahda ge nud ke won kan ne?” Noono maa akweer gene ke yiih lume. ");
INSERT INTO lwo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Maa abeehr Jeacuue ngo yihr gen kea, “Keehd me yiih nyoge mooge giih tiihy agamloohngjuoge, e yaa geen gen kedea waahde ge be yiih gene naa athere.” ");
INSERT INTO lwo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Bang gihn akweer yaa paar gene ke yiih ngo kejea e rom tiihy giih me gaahy nyoge, e gihn maa arome ke tiihyo kaano tooro abea anahg nyoge me noog mee ge naa acube cinge wudh gen ne thiehdh atwaany gen. ");
INSERT INTO lwo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Maa agaahy Jeacuue keraahyo ke nying gihn bahnge ngo be yiih gene kejea Juog e naa acub tee ne yug giih me gaahy nyoge kedea dhe yoohn ka apuohnye kii ngo. Kaano e Jeacuu paar gen awiie ke piny ubare wong maalo ke wen keew miehr e ngo upuohnyo. ");
INSERT INTO lwo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Cahng man e Jeacuu joe ge apaar wonge ariow ge acuohne. Naa abeehn gene, e ake rubo yihr gen kea, “Yaage! Wu acuohna bang gihn cwihnya ne oohr wun ke bang yihdh miehr ne puohny nyoge. Tee me riem atiihb ukeehg oogo ngo acuba yihru. ");
INSERT INTO lwo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","“Abea nea wu uaay kea kaahn dhaane kaa goohd kedea nahge ke wuoy nii tiene maa waahr ne ree ge ne kaahne cog. Keá ngaa kaahn cam, ludho wale ngiihny. ");
INSERT INTO lwo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nea wu awahdh yi geew ubeehn dhaano ucuohne wun ne beehdo paare, e kea beehdu paan nu kedea nahge paan nu e ne kwaayu do yea nea wu caa ne puohny. ");
INSERT INTO lwo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nea wu kuu alor kedea nyoge akweer ke puohny gihru kea wiiu kaano piny. Abea yi aay aayu kea teeng dhaane ngoom kaano oogo yi tiene ne nyoadh ngo kejea nea gihn me yoad gen, e maru tooro yi ngo.” Batien kaa athum Jeacuue ke rob e ge aoohre ke bang yihdh miehr naa ariow ariow. ");
INSERT INTO lwo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Noono upahdh gene ke yooh kedea e ge puohny nyoge kejea maan gene anyoohne giih reje naa atiihy gene kedea wii gene gen. ");
INSERT INTO lwo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Atiihb ukeehg me thoohdh ge ariem gene oogo rog nyoge kedea wudh yaa atwaany arej gene ke mow maa athiehdh gene gen. ");
INSERT INTO lwo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Eroade Ruohdh giih tiihy Jeacuue ge alihnge. Nying Jeacuu anaa awiihj noono e akob nyoge mooge naa Jeacuu beehda Joon Ngad Luogwahy e naa acahr e naa gihn nud yihre tee me tiihye giih me gaahy nyoge. ");
INSERT INTO lwo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Abea nyoge mooge kob gene, “Ngo beehda Eliija ngad agamloohngjuog naa acoon ge akob Juoge kea ngo uoohre.” Kob nyoge mooge dahng naa ngo beehda agamloohngjuog me neehn yaa agamloohngjuog giih acoon ge na yug giih me gaahy nyoge. ");
INSERT INTO lwo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Abea mar Eroade cuohne kea Joon Ngad Luogwahy, e ngude anaa angole, e naa acahr. ");
INSERT INTO lwo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Eroade Ruohdh apahro wa gihn nu bang gihn anahg e naa aoohr acaakere ne nahg Joon. Tien kaa anahg Joon athubo ke wa gihn: Ruohdh Eroade yihre anaa umen me nyinge Pihlihb kedea Pihlihb yihre anaa ciihe me nyinge Eroadaj. Eroadaj abeehn Eroade ne tihngo ne ciihe. Cahng man e Joon Ngad Luogwahy Eroade acaye kea, “Gihn e beehdi ke ciih umiihu abea umiihu kuu athow? Ngo amahn loohng Juoge ubeehn dhaane utihnge ciih umen.” ");
INSERT INTO lwo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Dhaar cuohn ne Eroadaj gihn arob Joone ngo amaane maa akwaahdhe Joon. Noono cwihnye anaa bang unahge Joon abea dhe yooh atooro ");
INSERT INTO lwo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","bang gihn Ruohdh Eroade, Joon na wuore wuoro bang gihn ngo ngahye kejea Joon beehda ngaa me beer yi wong Juog. Abea keehd maano e Eroade acaakere aoohre ne mag Joon ukedh gene ngo yi karkoohn. Eroade ke kur mare anhyaar lihng giih rob Joone abea ge lihnge gen e aduune udoal keraahyo. ");
INSERT INTO lwo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Gihn nu e Eroadaj abeehdo e cwihnye raaj keehd Joon. Cahng man e dhe yooh me nahge Joon ayoade. Cahng nu anahg cahng ayug Eroade yaay me duohng gihr par cahng anyuole. Yaa batiene maa jaabidhe kedea jo doong Gaalili ge anudo yi yaay. ");
INSERT INTO lwo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kaano e nyaar Eroadaj, abeehn nyum ruohdhe umiele umihn cwihny ruohdh maa weehle giihe cang. Kaano e Eroade a'aj maalo ke med cwihny nyum nyoge urube yihr nyaar Eroadaj kea, “Peehyi yihra ke kwaad gihn beer yi cwihnyi, ucuba ngo yihri.” ");
INSERT INTO lwo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Maa akuohnge ree nyum nyoge kea, “Gihn daahdi dhiila kaa cubo yihri keehd dhaahra e yea paahngo paahngo ke yihn e uroomo.” ");
INSERT INTO lwo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Gihn nu, e nyaar Eroadaj, agoohd bang men uteede gihn atiihy ree yihre. Kaano e men apeehnye peehnyo kea, “Nahge gihn e ne kwaya?” Maa abeehr men ngo kea, “Teed ngo kejea yi daahd ungol ngud Joon.” ");
INSERT INTO lwo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kaano e nyaan aguo duuo uteede ngo yihr Ruohdh kea, “A daahd wiih Joon ukahle yihra awaahn kan e ne yi caan.” ");
INSERT INTO lwo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Gihn nu e Eroade Ruohdh cwihnye ake rahnyo kedea ukwaahdhe lum nu abea ka maa arome waar yea lum arobe umodho tooro bang gihn ree akuonge nyum nyoge kedea wiihe ulaahyo ne waar yea lume nyum yaa amahdo. ");
INSERT INTO lwo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Noono uguo Ruohdhe acaakere kaa oohro piow piow ne ci ne ngol wiih Joon oogo ne kahlo yihr nyaar Eroadaj. ");
INSERT INTO lwo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Maa a'aay yaa acaakere ucidh gene yi karkoohn. Naa angol wiih Joon oogo e ngo akahl e ne yea caan ucube yihr nyaar Eroadaj. Maa akaab nyaar Eroadaje ngo ucube ngo yihr men. ");
INSERT INTO lwo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Naa alihng jo waahdh Joone thone e ge abeehno ne kaab kuohme ne ci ne kano. ");
INSERT INTO lwo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Cahng man e jo oohr ge anaa amahdo bang Jeacuu naa aduu gene ke yoohn kuohn aoohre gen yihdh gen. Ge anaa ne kwaan giih atiihy gene yihr Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nyoge ge anaa athoohdho ne cohg adhaahr utoor gihn maa arom ree tiihyo yihr Jeacuu kedea jo oohr. Keehd cam e ge kuu arom cam bang gihn yaa muu ge ubeehno uaay gene aay udog yaaj mooge ke beehno wa gihn nu. Naa aniid Jeacuue ngo kejea beehn nyoge bange be thum e arobe robo yihr joe kea, “Aayo oogo kan ucidho karo keedo ne yuohmo.” ");
INSERT INTO lwo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Noono maa athub gene ke aay ke baabuur ne cidh kar keed gen ka me toor nyoge yea. ");
INSERT INTO lwo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Abea ge kaa aniid nyoge me thoohdhe e ge uaay. Naa angej gene kun cidh gene yea, e nyoge ge apahdh yooh e ge kwany yihdh geedh dieng baaw ne ci ne kaang wudh gen. ");
INSERT INTO lwo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ge athub Jeacuue ke beehn oogo yi baabuur ne yedh wiih agala, e niid akuud nyoge me thoohdh rog gen acong gene. Kaano e Jeacuu cwihnye ake yuog yi ngoohng nying gen bang naa aniide gen wa diehg me ngad kwaag gen tooro. Uthube thubo ke puohny gen ke giih me thoohdh. ");
INSERT INTO lwo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Naa awahdhe ke thiehno e jo oohr ge abeehn bang Jeacuu urub gene yihre kob gene, “Ngad puohny kan beehda dom kedea piny ayuudho. ");
INSERT INTO lwo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gihn e bahnge nyoge ge be meehgi aay ne cidho ke bang yihdh miehr ne daahd gihn me cam gene?” ");
INSERT INTO lwo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Maa abeehr Jeacuue ngo yihr gen kea, “Maa cubu gihn me cam yihr gen.” Maa abeehr gene ngo kejea, “Amahr ngiihny ge uyoad wane kee me rom ngeew cam me yaahng amahr jo ni?” ");
INSERT INTO lwo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Maa apeehny Jeacuue gen kea, “Gihn e ne nud yihru ne cam? Cidhu ne maany piny ke gihn me cam.” Naa acidh gene e ge ayoad amune abiihj kedea rej ariow cog. Maa aduu gene ne rob giih ayoad gene yihr Jeacuu kob gene, “Wa ayoad amune abiihj kedea rej ariow.” ");
INSERT INTO lwo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kaano e arobe robo yihr jo waahdhe kejea teed gene ngo yihr nyoge upiih gene piny naa akuude. Kaa ngo yea anaa lum me mar. ");
INSERT INTO lwo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Maa apiih nyoge cang naa akuude. Akuude mooge yihdh ge ne nyoge jiehabiihj kedea mooge yihdh ge naa nyoge jiehariow wonge apaar. ");
INSERT INTO lwo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kaano e Jeacuu amune maa rej ge akaabe kaabo uloge wonge maalo ne muohj koohr Juog ke nying caame giih ni. Maa abanye yihdh amune ucube gen yihr jo oohr ne paahngo yihr nyoge. Yihdh rej ge apaahnge thiow kedea ucube gen yihr jo oohr. ");
INSERT INTO lwo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Maa acahm nyoge cang uyahng gene. ");
INSERT INTO lwo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Naa acong caam adoohng piny e ge arom diide apaar wonge ariow me pahng. ");
INSERT INTO lwo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cuow acahmo ge anahg kar nyoge alihbe abiihj abea maahn kedea nyethen ge kuu akwaan. ");
INSERT INTO lwo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","46","Piow piow batien gihn nu e Jeacuu ngo ateede teedo yihr jo waahdhe kejea paahr gene yi baabuur beere ge caa paan cuohn ne Beadhceada. Batien kaa awiihwe gen e ngo adoohng ne rob ngo yihr nyoge kejea dog gene miehy gen. Kaano e ake aay ucea wiih good ne kwaj. ");
INSERT INTO lwo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ke thiehno e Jeacuu ne wiih agala e keede, e baabuur aniide yi diehr naam duohng. ");
INSERT INTO lwo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ge awahdhe kaa akaahg piny, maano e piny adoohng ne bahr bahr, e Jeacuu niid jo waahdh giihe e ge ubuohj keehd baabuur yi diehr naam duohng. Kiiw baabuur anaa adoohng teeg bang gihn yamo anaa acoohd e beehn kaa kun ci gene yea. Kaano e Jeacuu ake thubo ke waahdh ke wudh piih e caa bang gen udoohnge wa ubar ke buud gen. ");
INSERT INTO lwo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Abea naa aniid gene ngo e ucaahdho ke wudh piih, e ge ke gaahy umaahr gene piny ke lalo cuohn gene kejea beehda atiihb ngaa maa athow e ne caahdh ke wudh piih, ");
INSERT INTO lwo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","bang gihn ngo aniid gene ke kar gen cang kedea umag lwahre gen. Abea Jeacuu aguo rob yihr gen kea, “Deedu cwihnyu! Wu keá tud! Beehda a Jeacuu.” ");
INSERT INTO lwo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Maa amone yi baabuur bang gen kedea uguo yame cuungo thiow. ");
INSERT INTO lwo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Maa agaahy gene cang yi kwaad gihn me wa gihn nu, keehd maa anaa ayaahng Jeacuue amahr nyoge kaa amune abiihj cog. Ge agaahy bang gihn wudh gen aciehg rog gen utoor ka me dead gene yihdh giih tiihy Jeacuue. ");
INSERT INTO lwo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kaa angol gene baaw e ge abeehn yi paajo me cuohn ne Geneajared ");
INSERT INTO lwo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","kedea uyihnh gene oogo yi baabuur. Ke wong kaano e Jeacuu aguo nyoge kaa ngeyo. ");
INSERT INTO lwo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Noono uthub gene ke kahl nyoge me tuu bange ke bang yiehdh miehr beere ge thiehdhe thiehdho. ");
INSERT INTO lwo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kedea kwaad paan wale geen cea yea, e nyoge maa atwaany tihng bange ne piehl piny yi laaro yi cuug. Noono ukway gene wong ngo kwayo kejea keehd waahre kea meehge ngo gweelo yihr ngad atwaany. Amahr yaa agweel waahnye ge athiehdhe cang. ");
INSERT INTO lwo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Cahng man, e jo doong Paarijea kedea yaa loohng Juog maa abeehno ke yoohn Jeruucalem ge abeehn bang Jeacuu ne maany giih tiihye. ");
INSERT INTO lwo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Naa awahnh gene piny Gaalili e aniid gene kejea yaa waahdh Jeacuu cing gen be luog gene, wa ka ne kweehr yaa Judea ngo, nea ge caa ne cam. ");
INSERT INTO lwo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Gihr luog cing gen ke dhe yooh me padh kaa ateed loohnge ngo amaan yaa Judea maa Paarijea bang gihn yaa Judea kedea Paarijea cing gen luog gene luogo ke dhe yoohn arob loohnge. ");
INSERT INTO lwo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nea ngad Paarijea ngo uduuo ke yoohn yi cuug e ngo be kuong cam e cinge keá luogo uwahdhe wong atiehl. Giih kweehr ge ke yugo thiow rog roohd kedea daahy wa kaa apuohny jo doonge ngo yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kaano e yaa Paarijea kedea yaa loohng Juog, Jeacuu acay gene kob gene, “Gihn ge bahnge jo waahdhi yoohn ka beehd nyoge kii ngo yi paajo be wuor gene? Gihn ge cahm gene e cing gen be kuong gene ke luogo uwahdhe wong atiehl?” ");
INSERT INTO lwo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Maa abeehr Jeacuue ngo yihr gen kea, “Wa gihn anaa arob Yicaaye coon umodho ke nyingu wu yaa waal ngo dhiil nahg athiir! Anaa agweede kejea Juog akoohbo kea, ‘Yaa ni a wuor gene kaa leehb gen now abea aduun gen tooro banga. ");
INSERT INTO lwo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Beehda toohd now keehd me koohb gene kejea ge wuor an. Noono ge piih ne puohny loohnge me yoad gene ke bang nyoge abea ge padh loohnge giiha.’ ");
INSERT INTO lwo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Loohnge giih Juog ge alogu ngahdhu unahge ke puohny ge kuowu e naa adeehju yi koohdhu. ");
INSERT INTO lwo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Wu nyoge me nyingu teeg ne cohg. Wu ge alog loohng Juog ngahdhu unahge ke loohnge maa now ge naa adeehju yi koohdhu! ");
INSERT INTO lwo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yihdh loohng Juog acielo anudo maa anaa arob Moaje kejea arob Juoge kea, ‘Wuor wuru ge ke miihu. Ngaa rob gihn me raaj rih wahn wale men e ngo ke naah.’ ");
INSERT INTO lwo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Abea nea dhaano urubo yihr wahn wale yihr men kea, ‘Gihn arob loohnge kejea dhiila ngo ke cubo yihri, ngo acuba piny ke nying lum Juog,’ ");
INSERT INTO lwo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","e ngaan nu lume yiihu yiiho noono e dhe yooh me rome wahn kedea men ke konyo ngo tooro. ");
INSERT INTO lwo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ke dhe yoohn nu, e lum Juog naa arobe kejea wuor dhaane wahn kedea men yea awuoju piih ke nying gihn arobu kedea ke nying kwaad mooge me yugu thiow.” ");
INSERT INTO lwo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Maa adog Jeacuue nyoge ke cuohn bange urube yihr gen kea, “Yaage! Lengu ne caaj ulihngu gihn teeda yihru. ");
INSERT INTO lwo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Beehda aduulo e ne nyoadh ngo kejea dhaano beehdo kaa beehdo me nhyaar Juoge wale beehdo kaa beehdo me maan Juoge. Padh cam ge cam dhaane e ne meehg ngo doohng ne ngaa me raaj yi wong Juog, abea beehda lum beehn oogo yi dhe dhaano kedea gihn tiihye e ne meehg ngo doohng ne ngaa me beer wale ngaa me raaj yi wong Juog. ");
INSERT INTO lwo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Lihngu giih ni nea ngaa yihdhe nud me lihngo e kea lihnge.” ");
INSERT INTO lwo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kaano e abeehn ne aay bang nyoge ucea wod, maa apeehny jo waahdhe ngo ke lum yihdh ucaale giih ateede. ");
INSERT INTO lwo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Maa abeehre ngo yihr gen kea, “Keehd wun thiow, yihdh luube ka ge kuu adeadu wa mar nyoge mooge? Ngo be niidu ne, kejea cam me ci yi yey dhaano, dhaano be yuge udoohnge ne ngaa me raaj yi wong Juog ne? ");
INSERT INTO lwo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bang gihn cam ge cam dhaane, be ci ne beehdo yaa aduulo, abea caa yi yej kedea ubare oogo.” Lume noono arobe ateed ngo kejea kwaad nyepiny cang ngo beer ke camo. ");
INSERT INTO lwo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Maa akoohb Jeacuue kea, “Gihn ne yaa aduun dhaano, ge pare ni kedea urobe ngo, e naa gihn yug dhaano ne ngaa me raaj. ");
INSERT INTO lwo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bang gihn aduulo, e ne beehn kwaad par me raaje oogo yea, wa mahj kedea kahw kedea kaab ciih ngaa moogo maa nahg dhaano. ");
INSERT INTO lwo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Log cwihny rih gihr ngaa moogo, tiihy giih maa cwaahne, maa yug giih waal rog nyoge, maahr, waaj nyoge, beel, kedea yug giih tooy wihj kedea ngaa me wihj awaadh oogo ree. ");
INSERT INTO lwo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Giih nu cang ge aay ke yaa aduulo kedea ge ne meehg dhaano doohng ne ngaa me raaj yi wong Juog.” ");
INSERT INTO lwo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Batiene e Jeacuu ake thubo ke waahdh ne ci yi geen Taayr kedea geen Ciihdoan ubeehde kaano e be daahd ngo ungahy kare. Abea keehd maano e kare adhiil nyoge ke yoado. ");
INSERT INTO lwo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kaano piow piow e dhaago me nyethiine ree naa atiihb raaj, bang Jeacuu abeehne ne lihngo. Gihn nu e ngo ake a'aay ne ci bang Jeacuu. Naa awahdhe e cunge arunge ke piny umuune ne ci bang Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Dhaar ngo anahg nye Griihg maa anyuol yi geen Peaniihcya ge ne yi piny Ciihrya. Kaano e wong Jeacuu akwaje beere atiihb raaj rieme ke oogo rih nyaare. ");
INSERT INTO lwo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Maa arub Jeacuue yihr dhaar ni kea, “Nyethen paajo ge ne kuong ke muojo ke cam umodho, bang gihn ngo be beer ukaab cam nyethen ucube yihr goohy.” ");
INSERT INTO lwo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Maa abeehr dhaar ni ngo kea, “Lumi adiehr Ruohdh! Abea goohy, ngahda giih na doohng piny bang nyethen ge na ke cubo yihr gen ne camo?” ");
INSERT INTO lwo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Maa arub Jeacuue yihre kea, “Ke nying robi noono, doogi e cwihnyi med bang gihn nyethiini atiihb raaj a'aay oogo ree.” ");
INSERT INTO lwo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kaano e dhaar ni ake thubo ke aay ne ci paare maa ayuude nyethiine e uneno beer mee kedea atiihb raaj a'aay oogo yi kuohme. ");
INSERT INTO lwo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kaano e Jeacuu adoog ke Taayr ne ci naam duohng gihr Gaalili. Ngo acidho e ngo kaahn bang Ciihdoan kedea wudh Geedhe Apaar. ");
INSERT INTO lwo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Maa abeehn nyoge ukahl gene ngaa maa amiing me be rubo yihre maa akway gene wong ngo kejea cube cinge wiihe ne thiehdh ngo. ");
INSERT INTO lwo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kaano e Jeacuu ake a'aay ke nyin ucidh gene kar keed gen, ka me nyoge tooro yea. Gihn nu e cinge acube yi yihdh nyin kedea ugweele leeb nyin. ");
INSERT INTO lwo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kaano e amaahny maalo ce yiihe ne puu naa aniide ngoohng wong nyin. Batiene e arubo ke dhog yaa Judea kea, “Ebpata” (lum yea yahb gene). ");
INSERT INTO lwo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ke wong kaano e yihdh nyin ake yahbo ugoony leebe ree uthube ke rob beer mee. ");
INSERT INTO lwo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Maa acuow Jeacuue jo aniid gihn atiihye kejea ngo keá rob gene oogo yihr nyoge. Abea ngo kuu alihng gene, udoohnge wa ateed ngo yihr gen kejea keedh gene gihn atiihye ke bang wiih piny cang. ");
INSERT INTO lwo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Gihn nu e nyoge ge acwaahng keter naa alihng gene gihn atiihy ree. Maa akoohb gene, “Giih tiihye cang ge beeye kedea gihn me riehny yihre tooro. Keehd ngaa maa amiing wale ngaa me kar rob tooro yihre e rome kaa thiehdho ke dhog yiehdhe giihe noono yuge giih me gaahy nyoge.” ");
INSERT INTO lwo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yihdh nihn nu keehdo e amahr nyoge rog gen anaa adog gene ke congo ke batien Jeacuu. Nihn adahg e ge buodh batiene! Gihn nu, e caame giih anaa yihr gen ge ake thumo. Naa aniide kahj rog gen e jo waahdh giihe acuohne bange urube yihr gen kea, ");
INSERT INTO lwo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yaa ni aduuna uyuog ke nying gen bang gihn yihr gen ne nihn adahg awaahn ni e gihn maa agweel gene yi dhog gen ngo tooro. ");
INSERT INTO lwo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Abea nea ge meehgo ke aay ke kahj rog gen, e ge caa ne pahdh yi yooh bang gihn nyoge mooge kiin gen ge beehn ke kuohn me bahye.” ");
INSERT INTO lwo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Maa abeehr jo waahdhe ngo yihre kob gene, “Amune me yaahng amahr jo ni ge uyoado ke kee yi ukang kan?” ");
INSERT INTO lwo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Maa acahge piehj kea, “Yihru naa amune adiih?” Maa abeehr gene ngo kob gene, “Abiihjberiow!” ");
INSERT INTO lwo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Maa arobe ngo yihr gen kejea meehg gene nyoge piih piny. Kaano e amune giih ni ge akaabe kaabo maa amuohje koohr Juog kedea ubanye yihdh gen noono uthube ke cub gen yihr jo waahdhe ne paahngo yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Thiow yihr gen anaa nye rej me noog. Maa acahg Jeacuue gen ke kaabo kedea udooje gen maa ucube gen ne paahngo yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Maa cahm amahr yaa nu cang uyahng gene. Goan caame giih adoohng ge apaahng kar diide abiihjberiow. ");
INSERT INTO lwo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yaa anaa acahmo cang ge anahg kar nyoge alihbe angween. Kaano naa athum nyoge ke cam e ge ameehge ke aay ");
INSERT INTO lwo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","kedea upaahre kii baabuur keehd jo waahdhe ne ci paan cuohn ne Dalmanuudha. ");
INSERT INTO lwo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Yihdh nihn apoohde e Jeacuu nud kaano e yaa Paarijea mooge ge abeehn bang Jeacuu urub gene ke luub waal ne tum ngo kejea yuge gihn me gaahy nyoge ne nyoadh ngo kejea Juog e naa aoohre. ");
INSERT INTO lwo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","E Jeacuu ayiih maalo e atheng maa acoare ukoohbe kea, “Wu yaa ni rubo kan ni, gihn me gaahy nyoge me yuga yihru ngo gihn? A rob athiir yihru, gihn me gaahy nyoge me yuga ke nyingu tooro.” ");
INSERT INTO lwo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Maa awiie gen piny uaaye keehd jo waahdh giihe ucea ne paahr yi baabuur ne ngud loo baaw. ");
INSERT INTO lwo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Gihn nu e jo waahdh ka wudh gen anaa awul ne kaahn amune kedea unahge kaa amono acielo cog e naa anudo yi baabuur. ");
INSERT INTO lwo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kaano e Jeacuu ake thubo ke rob yihr gen ke luub ucaale me toohn gen ubahnge kwaad giih reje ge par yaa Paarijea kedea yaa batien Eroade ge be tiihy gene kobe, “Giih nu reje ge par gene ge uroomo keehd nye kamiira gihn woj yi mog amono uyaahnye.” ");
INSERT INTO lwo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Maa athub gene ke rob ke rog gen cuohn gene kejea ka moogo e ngo rubo kaa nying amono, kob gene, “Ngahda ngo rubo kaa nying gihn toor amune yihro!” ");
INSERT INTO lwo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kaano e gihn rob gene aguo Jeacuue kaa ngeyo uthube ke piehj kea, “Wu rob gihn ke nying tooy amune? Ka poohd e ngo be ngeyu kejea amune roma kaa kahlo ke yooh me gaahy nyoge? Wudhu ka poohd kuu ayahbo ne ngey nyepinye? ");
INSERT INTO lwo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kuu anaa aniidu kedea kuu alihngu, nea padh wul wihj e naa awul wudhu kaa anaa ayaahnga nyoge alihbe abiihj kaa amune abiihj adhaahr ugaahy nyoge?” ");
INSERT INTO lwo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","“Naa abanya yihdh amune abiihj yihr nyoge alihbe abiihj ne camo, wu anaa acong adiide adiih me pahng keehd amune giih adoohng piny?” Maa abeehr gene ngo kob gene, “Apaar wonge ariow.” ");
INSERT INTO lwo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Maa acahge rob kea, “Naa abanya yihdh amune abiihjberiow ne camo yihr nyoge alihbe angween e adiide adiih ge naa apahng kaa amune giih adoohng?” Maa akoohb gene, “Abiihjberiow.” ");
INSERT INTO lwo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kaano e wiih robe agooye piny kobe, “Ngo poohd kuu angeyu kejea a kuu arubo kaa nying amune? A arubo kaa nying dhe yoohn ka pahr yaa Paarijea kedea yaa tiihj giih Eroade kii ngo.” ");
INSERT INTO lwo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Batiene e ge acahg beehn ne duuo yi Bedhceada. Nyoge mooge dhaano maa acoor ngo akahl gene bang Jeacuu, ukwaj gene wong ngo kejea gweele ngo uthiehdhe ngo. ");
INSERT INTO lwo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kaano e bad ucuor amage mago upieye ngo oogo kiin nyoge ucidh gene kar keed gen. Kaano e anguud yi wong nyin batiene e cinge acube wiih ngo ce peehnye nyin kea, “Ne gihn me niidi ne?” ");
INSERT INTO lwo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Maa amaahnye maalo ukoohbe kea, “Ayiih! Nyoge ge uneehno yihra ne yihr yihr e ge ucaahdho abea adoohng wa yen ge ne caahdh.” ");
INSERT INTO lwo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Maa acahge cinge ke wum yi wong nyin, kaano e wonge anaa weehny uneehn nyepinye yihre cang keehd gihn me ne ka me baahr. ");
INSERT INTO lwo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kaano maa arub Jeacuue yihre kea, “Ge aayi kan, yih keá doog ke Bedhceada ne rob gihn ayug ree rihi.” Batiene e ngo aoohre ke paajo. ");
INSERT INTO lwo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Batiene e Jeacuu maa jo waahdhe ge abeehn ne aay Bedhceada, ne ci yihdh miehr giih piny Cejearya Pihlihbi. Kaano acaahdh gene caahdho nu, e jo waahdh giihe ge apeehnye peehnyo kea, “Nyoge wudh ge par gene kejea a ngaa?” ");
INSERT INTO lwo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Maa abeehr gene ngo yihre kob gene, “Nyoge mooge kob gene yih beehda Joon Ngad Luogwahy, e naa acahr, kob nyoge mooge kejea yih beehda Eliija e naa aduuo ke yoohn maalo kedea nyoge mooge thiow naa yih beehda agamloohngjuog maa anaa anudo upiny umodho.” ");
INSERT INTO lwo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Maa acahge gen ke peehnyo kea, “Abea nea maru, kobu a beehda ngaa?” Maa abeehr Piihtere ngo kea, “Yih beehda ngaan aoohr Juoge ne Ngad Boadh nyoge.” ");
INSERT INTO lwo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Maa abeehr Jeacuue ngo kea, “Lumi athiir Piihter. Abea lum nu keá teedu yihr nyoge kejea a beehda Waahd Juog naa aoohre ne boadh nyoge.” ");
INSERT INTO lwo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Batiene e ake thubo ke puohny gen kea, “A ke nguda a ge adoohng ne dhaano utaahngo, giih raahm me thoohdh ge uyoada, jo doonge maa jo doong yaa lam kedea yaa loohng Juog ge ukweer kejea a padh Ngad Boadh nyoge uwahdhe ka unahg an. Abea yi dahg nihn e a ucahr keehdo.” ");
INSERT INTO lwo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Lum nu ngo arobe yihr gen e gihn maa akane tooro. E Piihter bad ngo amage ne nyiig oogo buud nyoge maa arube yihr Jeacuu kea, “Gihn ge rubi wa maan ni?” ");
INSERT INTO lwo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kaano e ngahye aloge umaanye bang jo waahdhe maa acuowe Piihter kea, “Yih atiihb ukeehg coor rihi oogo buuda. Yih keá pahro ke kwaad par gihn nu, bang gihn giih pari ge padh giih par Juoge abea ge beehda giih par dhaano utaahnge.” ");
INSERT INTO lwo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nyoge kedea jo waahdh giihe ge acuohne bange maa arube yihr gen kobe, “Nea ngaa daahd ubuodhe batiena, kea jaahe ree uguume giih raahm kuohm wa mara, ce beehne ubuodhe batiena arumo. ");
INSERT INTO lwo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kwaad ngaan kweer ke buodh batiena bang gihn be daahd uthowe e ngaan nu kuowo me guge tooro buu uyoade. Abea kwaad ngaan be dier ke thoo ke nyinga kedea ke nying Ciig Beer e ngaan nu kuowo me guge tooro uyoade. ");
INSERT INTO lwo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Gihn e ne kony giih wiih piny yihr dhaano utaahngo nea boadh wahy be yoade? ");
INSERT INTO lwo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Gihn muu urom dhaane ke cubo me room ke wahye tooro. ");
INSERT INTO lwo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ngaa beed wiih piny ge yea apahng ke giih anyoohne, nea wiihe ulaahyo riha kedea yih gihn roba e, wiiha ulaahy thiow ree cahng uduua e a kaahn teeg Wura kedea e a kaahn wuohdjuoge kaahno kii diehr.” ");
INSERT INTO lwo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Maa arub Jeacuue yihr gen kea, “A rob athiir yihru. Yaa nud kan ge buu uthow cang, nud ke nyoge kiin gen muu uniid Ruohdh Juog ke nying gen ge ubeehn Waahd Juoge ke tee ne kihm nyoge.” ");
INSERT INTO lwo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Batien nihn abiihjbeciel e Piihter maa Jeamij kedea Joon ge abeehn Jeacuue ne kedh wiih good me duohng mee. Ge awahdh gene wiih good kar keed gen, e ka nahg Jeacuue ngaa me yihre ne tee abeehn gene ne niido. Aniid gene bang gihn kuohm Jeacuu ree abeehne ne loo nyum gen. ");
INSERT INTO lwo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Waaye ge ake liel tar ne weej ke kwaad geed me kuu akuong ke niido wiih piny kan. ");
INSERT INTO lwo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kaano e nyoge ariow, Eliija maa Moaje ge anaa alwaahd ke dhe yooh maa agaahy gen kedea uthub gene ke rob ke Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","E Piihter ake rubo yihr Jeacuu kea, “Ngad puohny. Ngo beer ubeehdo kan. Nea wa gihn nu kea wii wan ugeer wane abuwe adahg. Acielo yihri maa acielo yihr Moaje kedea acielo yihr Eliija.” ");
INSERT INTO lwo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piihter arubo wa maano bang gihn gihn maa angahye me robe ne cohg ngo atooro kedea ge anaa anahg lwahre. ");
INSERT INTO lwo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kaano e deeh lwahd abeehn ne niihm wudh gen kedea e yedh duon Juog ulihngo e ngo urubo kobe, “Gihn e naa Waahda maa anhyaara. Lihngu lume beer mee.” ");
INSERT INTO lwo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ka me thiin kaano, e lwahd anaa aweehny abea ge amaahny gene e ngaa maa acahg gene ke niido me cuung buud Jeacuu tooro. ");
INSERT INTO lwo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Naa aduu gene e ge loohn piny ke wiih good e ngo arob Jeacuue robo yihr jo waahdh giih adahg kea, “Gihn aniidu keá robu yihr nyoge uwahdhe cahng ucahra batien thoo.” ");
INSERT INTO lwo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Adiehr muon gihn nu kuu abeehn gene ne teedo yihr nyoge wa kaa arobe ngo. Abea gihn anaa adhiehdh wudh gen beehda lum ni arobe kea, “Uwahdhe cahng ucahra batien thoo.” ");
INSERT INTO lwo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kaano e Jeacuu abeehn gene ne peehnyo kob gene, “Yaa gweed ge na upuohnyo kejea Eliija e nuu ukuong beehn wiih piny umodho kedea ubeehn Ngad Boadh nyoge ke batiene. Puohny gen noono beehda kare ne cohg?” ");
INSERT INTO lwo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Maa abeehre ngo yihr gen kea, “Athiir muon anaa arob Juoge kejea Eliija ukuong ke oohro ne nyoadh dhe yoohn ka gwiir nyoge rog gen umaan gene anyoohne giih gen ke nying cahng unyoadha riha a ge adoohng ne dhaano utaahngo. Kedea ngo adiehr thiow kejea Eliija ngo abeehno kedea ngo aniidu e kaa akaahne kii ngo uwahdhe kaa anahge wa kaa anaa agweed yaa agamloohngjuoge ngo coon. Kea deadu yi man: agweed yaa gamloohngjuoge thiow kejea jo doonge ge ukweer ke yiih an kejea Juog e naa aoohr an ne ngade me boadh nyoge kedea ge upiih uyug gene giih ajohr riha maa ucwiid gene kuohma.” ");
INSERT INTO lwo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Naa awahnh Jeacuue, tiehd keehd jo waahdh giih acaahdho keehde bang jo waahdh giih anaa adoohng, e ge ayuud gene e ge atieg amahr nyoge piny. Yaa loohng Juog ge anudo thiow, e ge upeehmo ke kiin gen ke nying luube giih arob gene robo. ");
INSERT INTO lwo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nye kaa aniid nyoge Jeacuu e ucaahdho tiehd keehd jo waahdh giihe adahg e apahdh yi cwihny gen kedea uthub gene ke goohd bange ne maahdh ngo. ");
INSERT INTO lwo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Naa awahnh Jeacuue bang jo waahdh giih adoohng e ge apeehnye kea, “Wu peem gihn keehd jo ni atieg wun piny?” ");
INSERT INTO lwo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","E dhaano acielo kiin gen ngo abeehre beehro kea, “Ngad puohny! Nyethiina akahla yihri ne thiehdho bang gihn yihre ne atiihb reje me ngo be meehge rob. ");
INSERT INTO lwo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","E tahnge ree, e ngo riedhe ke piny kedea dhee upahngo kaa aboohyo me ne thug thug maa lage kaanye kaanyo kaano e ngo tal oogo. Maa aroba ngo yihr jo waahdh giihi ge adoohng kan kejea thiehdh gene ngo. Maa ariehnye ke thiehdho yihr gen!” ");
INSERT INTO lwo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Maa abeehr Jeacuue ngo kobe, “Wu kwaad nyoge me yiiho tooro yihru? Wudhu paru paro kejea a ubeehdo ke wun uwahdhe weehne? Kahlu nyethiin ngo yihra kan.” ");
INSERT INTO lwo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kaano e nyethiin akahl yihre. Naa aniid atiihb reje Jeacuu, e nyethiin ariedh gene ke piny e ree urihgi kedea uruj gene ngo ke piny e dhee apahng kaa aboohyo. ");
INSERT INTO lwo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kaano e Jeacuu wur nyethiin apeehnye peehnyo kea, “Gihn ni athubo ree ke weehne?” Maa abeehr wur nyethiine ngo kea, “Ke kaa anyuole nyuolo ");
INSERT INTO lwo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","kedea ngo na thoohre kii maaj maa yihdh piih e miid ngo ke naah! Abea nea kar konye nud yihri kea dhiil ngo ke konyo yihr wan cedhree!” ");
INSERT INTO lwo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kob Jeacuu yihr wur nyethiin kea, “Gihn ge koohbi kejea kar konye nud. Kar konye beehde nud nea yih ayiiho.” ");
INSERT INTO lwo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","E ngo aguo wur nyethiine kaa gamo piow piow maa atihnge duone maalo kea, “Lum Juog ayiiha. Abea kony an beere yiiho gihra yea be lwag ree.” ");
INSERT INTO lwo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jeacuu e niid akuud nyoge beehn bange ke ngweej, e atiihb reje ge anaa yi kuohm nyethiin ni acuowe cuow kobe, “Wu atiihb reje, ge miing nyoge! Pahru oogo yi kuohm nyethiin ni kedea wu keá cahg duuo keehdo.” ");
INSERT INTO lwo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Gihn nu e nyethiin ariedhe ke piny e ree urihgi keter e uyuog keter kedea ree ruye ruyo ke piny. Kaano e atiihb reje ge ake aay uwii gene nyethiin piny wa ngaa maa athow. Mar nyoge mooge cuohn gene e ngo athow. ");
INSERT INTO lwo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Abea ngo abeehn Jeacuue ne maa ke bade utihnge ngo maalo maa ayedhe maalo ucuunge wudh tiene e ngo adoohng beer kedea gihn me ne ree tooro. ");
INSERT INTO lwo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Naa amon Jeacuue wod keehd jo waahdh giihe, e ngo apeehny gene peehnyo kob gene, “Gihn ge toor tee yihr wan ne riem atiihb ukeehg oogo?” ");
INSERT INTO lwo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Maa abeehr Jeacuue ngo yihr gen kobe, “Kwaad man padh gihn me riem ree oogo now nea padh ke dhe yoohn kwaj.” ");
INSERT INTO lwo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Maa a'aay Jeacuue keehd jo waahdh giihe kaano, ucidh gene ke bang Gaalili. Jeacuu kuu adaahd ungahy ka cea yea, ");
INSERT INTO lwo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","bang gihn Jeacuu jo waahdhe ge apuohnye puohnyo. Noono maa arube yihr gen kea, “Beeh teeda ngo yihru yaage. A ge adoohng ne dhaano utaahngo, a uluom ucub an yi cing nyoge me reje ne naah abea yi dahg nihn e a ucahr.” ");
INSERT INTO lwo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Gihn adaahde ke teedo yihr gen yea ngo kuu adead gene abea ge atud ke peehny lum yea. ");
INSERT INTO lwo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kaano, e ge abeehn Kaparnaam. Naa apiih gene yi wod, e Jeacuu jo waahdh giihe ge apeehnye peehnyo kobe, “Wu apeem gihn ge acaahdhu caahdho?” ");
INSERT INTO lwo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Gihn nu ge aleng bang gihn wudh gen alaahyo, bang gihn ge anaa acaahdh gene caahdho, e ge anaa ake peehmo ke kiin gen kejea ngaa e nu nahg ngaa duohng nyum gen. ");
INSERT INTO lwo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Maa akob Jeacuue ngo kejea nyiihng joe ge apaar wonge ariow buude. Noono maa arube yihr gen kea, “Nea ngaa daahd unahge e naa ngaa duohng nyum nyoge kea ngahye ngo kejea e naa ngaa me thiin mee me e ne tiihyo yihr nyoge cang.” ");
INSERT INTO lwo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kaano e nyethiin amage maa ameehge ngo cuungo yi diehr kiin gen, batiene e ngo atihnge yi koohre maa athube ke rob yihr gen kea, ");
INSERT INTO lwo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kwaad ngaa beehdo beer keehd nyethiin me wa nyethiin ni e ngaan nu uroomo wa ngo abeehdo beer kaa an, padh an keede abea ngo uroomo wa ngo abeehdo beer kaa ngaan aoohr an.” ");
INSERT INTO lwo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Joon arubo yihr Jeacuu kea, “Ngad puohny! Ngaa moogo ayoad wane e atiihb ukeehg ge rieme ke oogo yi wudh nyoge e nyingi e ne cuohne. Abea bang gihn padhe ngado e ngo amahn wane kejea atiihb ukeehg keá rieme oogo yi wudh nyoge.” ");
INSERT INTO lwo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Maa abeehr Jeacuue ngo yihre kobe, “Ngo keá mahnu! Bang gihn ngaa maa ayug tiihy gihn me gaahy nyoge me neehn gihn nu ke nyinga kare tooro me cahge gihn me raaj ke robo yihr nyoge ke nyinga ");
INSERT INTO lwo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","bang gihn kwaad dhaano me be yug gihn me raaj rogo, ngo beehda ngado. ");
INSERT INTO lwo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Adiehr e ne roba yihru kejea kwaad dhaano me cub nyepiny keehd me nahge piih maadh yihru ke nyinga bang gihn nahgu jo'a, a ge Ngad Boadh nyoge, e ngaan nu akoohg gihre bang Juog be rwaahny. Arob athiir yihru, ngo dhiile kaa yoado. ");
INSERT INTO lwo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kwaad ngaa meehg nyethiin wii luma maa ayiihe, e ngweehn me tuohj deeh leelo yi ngud ngaan nu uthoohre yi naam duohng. ");
INSERT INTO lwo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nea cingi e ne meehg yihn yug adhemuohm e kea ngol ngo oogo, bang gihn ngo ngweehn ucii Paar Juog ke cing acielo maa atug, yi man cii paar maaj ka me maaj be thow yea ke cing ariow.  ");
INSERT INTO lwo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ka me kuuno gihn cam nyoge yea be thow kedea maaj gihn waang nyoge be lan oogo ");
INSERT INTO lwo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nea tieni e ne kedh yihn yihdh giih me reje, e kea ngol ngo oogo, bang gihn ngo ngweehn ucii kar wahy e tieni atug, yi man cii paar maaj ke tiene ariow.  ");
INSERT INTO lwo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ka me kuuno gihn cam nyoge yea be thow kedea maaj gihn waang nyoge be lan oogo. ");
INSERT INTO lwo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nea wongi e ne meehg yihn yug adhemuohm, kea oohl ngo oogo, bang gihn ngo beer ucii Paar Juog ke wong acielo, yi man thoohr yih yi maaj ke nyingi kar ge ariow. ");
INSERT INTO lwo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ka me kuuno gihn cam nyoge yea be thow kedea maaj gihn waang nyoge be lan oogo. ");
INSERT INTO lwo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","50","“Wa ka yoad melo ge beer uthaale ke maaj, wa gihn thiow e kwaad dhaano cang ngo ucub wiih maaj ne kahl gihn beer oogo ree. Abea nea melo ngo ubahnho e kare tooro ucahge lawo. Nea maano kea beehdu beer ke kiinu kedea ke doohr e kiinu tooro ater.” ");
INSERT INTO lwo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Batiene e Jeacuu ake a'aay keehd jo waahdhe yi geen Kaparnaam, e ge acor yihdh miehy Judea ungud gene loo naam Joohrdoan. Naa aniide ngo e batiene acahg akuud nyoge me thoohdhe ke buodho, e apiih ne puohny gen wa kwaad ka ne puohnye nyoge. ");
INSERT INTO lwo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kaano e yaa Paarijea mooge me daahd ngo ke tumo beere dhee uwaahj ke nying paah ke dhaago, ge abeehn bange maa apeehy gene kob gene, “Dhe yoohn paah ke dhaago maa arob loohng Moaje nud ne?” ");
INSERT INTO lwo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Maa apeehny Jeacuue gen thiow kobe, “Moaje anaa arob gihn yihr ge kuowu ke nying gihn nu?” ");
INSERT INTO lwo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Maa abeehr gene ngo kob gene, “Akob Moaje kea, ‘Nea dhaano warga gihr paah cube cubo yihr ciihe, e nyoadh ngo kejea ge apaah.’ ” ");
INSERT INTO lwo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Batiene e kob Jeacuue yihr gen kea, “Anahg gihn anahgu nyoge me wudhu teeg keraahyo e naa agweed Moaje loohng giih nu yihru. ");
INSERT INTO lwo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Neehn kaa agweede yi kitaab Juog, ‘Juog acag dhecuow kedea dhaago.’ ");
INSERT INTO lwo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘E naa gihn beehn dhe cuowe udage oogo paar gen unweehde ke ciihe ");
INSERT INTO lwo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","udoohng gene ne dhaano acielo.’ ");
INSERT INTO lwo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nyoge maa anweehd Juoge udoohng gene ne dhaano acielo, keá ngaa paahng keew gen.” ");
INSERT INTO lwo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Naa adog gene paajo uci gene yi wod, e Jeacuu acahg jo waahdhe kaa peehnyo ke nying paah ke dhaago. ");
INSERT INTO lwo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Maa arube yihr gen kobe, “Ngaa riem ciihe kedea unyuome dhaago moogo, e ngaan nu ayug adhemuohm rih ciihe ge anaa umodho muu uroomo kaa adhemuohm gihr ngaa maa akaab dhaago maa anyuom. ");
INSERT INTO lwo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kedea ngaa paah ke cuore unyuome dhecuow moogo e awuohj ayuge nyum Juog rih cuore ge anaa umodho ni.” ");
INSERT INTO lwo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Cahng man e nyoge mooge nyethen me thene akahl gene ke bang Jeacuu beere ge beehne ke ne doojo. Maa abeehn jo waahdhe upiih gene ne gahl nyethen oogo beere ge be cidh ne yihny guohb Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Gihn nu e Jeacuu cwihnye ake rahnyo ge aniide nyethen e ge gahl oogo ne beehn bange. Maa akobe ngo yihr gen kea, “Ge keá mahnu! Weehgu gen beehno, bang gihn kwaad nyoge maa ayiiho kedea me gaahn Juog me neehn nyethen ni ge ne wudh gen ne maalo Paar Juog. ");
INSERT INTO lwo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A rob athiir yihru, ngaa me be lor Juog ke cwihnye cang wa ka lore nyethen, e Paar Juog be kuonge ke yoado.” ");
INSERT INTO lwo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Maa atihnge nyethen yi koohre kedea ucube cinge wudh gen ne dooj gen. ");
INSERT INTO lwo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cahng man e Jeacuue ake caahdho ke jo waahdhe ne ci Jeruucalem e dhaano ake rihngo bange urunge cunge piny nyum ngo upeehye kobe, “Yih ngad puohny me beer! Gihn e ne roma ke yugu beere kuowo me ne cohg yoada yoado Paar Juog?” ");
INSERT INTO lwo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Maa abeehr Jeacuue ngo kea, “Gihn ge cuohni an ne ngad puohny me beer? Bekihd ngaa me beer, nea padh Juog keede. ");
INSERT INTO lwo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Loohng Juog naa acube yihr Moaje ngahda ge ngahyi ne? ‘Dhaano keá nahgi, ciih ngaa moogo keá kaabi, gihr ngaa moogo keá kwali, yih keá rubo ke toohd, gihr dhaano keá cami ke waal, wuor wuru ge ke miihu.’ ” ");
INSERT INTO lwo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Maa akoohb nyine kea, “Ngad puohny! Giih nu ge athoba ke yugo e a poohd beehda nyethiin.” ");
INSERT INTO lwo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kaano e Jeacuu amaahny bange e cwihnye med maa akoohbe kea, “Nyepiny acielo cog e naa adoohng e ngo kuu atiihyi. Do paajo ungeewi giihi ne nud yihri oogo cang kedea ukaabi ngiihny ayoadi upaahngi gen yihr nyoge maa angoohng beere giih lonyo ge yoadi ke Paar Juog kedea ubeehni unahgi ngad batiena. Nea giih nu ge atiihyi cang, e kuowo me ne cohg romi kaa ayoado Paar Juog.” ");
INSERT INTO lwo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Abea naa alihng nyine rob nu e ree ane kuohj bang gihn cwihnye atooro upaahe ke lonye. Noono upahdhe yooh ne aay e cwihnye arahnyo bang gihn ngo beehda ngaa maa anaa alony keraahyo. ");
INSERT INTO lwo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kaano e Jeacuu wonge aloge ke bang jo waahdh giihe maa akoohbe yihr gen kea, “Ngahyu ngo kejea ngaa maa alony ci yi Dhaahr Juog teeg yihre ubare.” ");
INSERT INTO lwo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jo waahdhe ge acwaahng yi kwaad lum nu. Maa abeehn Jeacuue ubare maalo ke rob kea, “Yaage! Dhe yoohn Paar Juog ngo diiny keter yihr yaa lonyo ne mon kii ngo. ");
INSERT INTO lwo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Adhaahr ngweehn roab amana yi libra wa mar libra ke keadh yihr mar yaa alony ne mono Paar Juog.” ");
INSERT INTO lwo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Gihn nu, e jo waahdhe ge acahg cwaahng yi kwaad rob nu maa arub gene ke kiin gen kob gene, “Nea neehn maano e unahg ngaa e nuu urom boadho?” ");
INSERT INTO lwo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Maa amaahny Jeacuue bang gen urube kea, “Ngo beehda athiir. Ree be rome ke leehwo yihr dhaano e keede abea nea ke teeg Juog e ngo yoohd bang gihn gihn me goohg yihr Juog tooro. Nyoge muu urom boadho ge unud.” ");
INSERT INTO lwo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kaano e Piihter ake thubo ke rob kobe, “Maany wan! Giih wan ge awii wane piny cang kedea udoohng wane ne jo waahdhi.” ");
INSERT INTO lwo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","E ngo abeehr Jeacuue beehro kobe, “A rob athiir yihru. Yaa wii miehy gen piny, wale wuud meeh gen wale nyemeeh gen wale meeh gen wale weeh gen wale nyethen gen wale puohdh giih gen ke nyinga kedea ke nying puohny Ciig Beer, ");
INSERT INTO lwo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","e giih nu wudh gen ubeehn Juoge ne coalo cang. Wudh gen ucoal Juoge yihr gen awaahn ni kedea cahng moogo keehd mooge me kaal wudh muu nu tiel jiehabiihj uyoad gene miehr kedea wuud meehe kedea nyemiihe kedea miiho maa nyethen kedea puohdh maa guum giih ajohr. ");
INSERT INTO lwo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yaa daahd ngo awaahn ni beere ge cuohn nyoge cuohno ne yaaj me doonge ge naa yaa cuohn Juoge ne nyethen, abea yaa beehda nyethen awaahn ni ge naa yaa ucuohn Juoge ne nyoge me doonge cahng moogo.” ");
INSERT INTO lwo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jeacuu kedea jo waahdh giihe ge anaa yi yooh, e ge caa Jeruucalem. Ge anaa acaahdh gene caahdho, e Jeacuu anaa nyum gen wong maalo. Gihn nu e jo waahdhe ge acwaahng kedea yaa anaa abuodh batien gen ge atud ke nying gihn uyoad ngo kun nu. Kaano e Jeacuu yaae ge apaar wonge ariow ge acuohne kar ge keed gen uthube ke rob gihn utiihy ree yihr gen kobe, ");
INSERT INTO lwo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Wo aman ci Jeruucalem! Abea ge uwahdho e a ge adoohng ne dhaano utaahngo a uluom ucub gene an yi cing jo doohng yaa lam kedea yaa loohng Juog kedea a ukihm gene ke thoo kedea a ucub yi cing aleye. ");
INSERT INTO lwo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kuohma uyaahl gene kedea unguud gene riha. A upuohd gene ke ngeero kedea unahg gene an. Abea yi dahg nihn e a ucahr.” ");
INSERT INTO lwo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Maa abeehn waahd Jebeade Jeamij kedea Joon umuong gene gihn daahd gene yi yihdh Jeacuu kob gene, “Ngad puohny wa daahd ucubi gihn kway wane bangi yihr wan.” ");
INSERT INTO lwo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Maa apeehny Jeacuue gen kea, “Gihn ge daahdu banga ge roma cubo yihru ni.” ");
INSERT INTO lwo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Maa abeehr gene ngo yihre kob gene, “Wa daahd ngo umeehgi wan piih wudh koom ruohdh ucingi. Ngaa man ukwiihyi kedea ngaa man ucaami yi ruohdhi.” ");
INSERT INTO lwo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Abea ngo abeehn Jeacuue ne beehro yihr gen kobe, “Gihn peehnyu lum yea kwihyu. Giih raahm kuohm ge uyug riha, ge neehn giih maa awuoj yea kubaayo ne maadho, ge romu kaa maadho wa ka umaadha gen ne? Wale giih guuma, ge uyoad an ge romu kaa guumo?” ");
INSERT INTO lwo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Maa abeehr gene ngo kob gene, “Ayiih! Ge uguum wane.” Maa arub Jeacuue yihr gen kea, “Giih raahm kuohm ge uyoadu kedea giih guum ge uguumu. ");
INSERT INTO lwo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Abea piih ukwiihya kedea ucaama padh an ne cub kuohn nu. Ge beehda kuohn yaa acub wura gen yihr gen, wa kaa agweehge umodho.” ");
INSERT INTO lwo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Naa alihng goan joe giih apaar wonge ariowe lum nu, e cwihny gen ake rahnyo rog waahd Jebeade Jeamij maa Joon umen. ");
INSERT INTO lwo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Gihn nu e joe ke kar gen cang ge acuohn Jeacuue bange maa arube yihr gen kea, “Ngahyu ne! Yaa daahd unahg gene ruohdhe wiih piny, nyoge kaahn gene kaa dhe yoohn laang ne nyoadh ngo kejea ge beehda ruohdhe me lum gen teeg. ");
INSERT INTO lwo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Abea dhe yoohn ruohdh maru ne keede, bang gihn ngaa daahd udoohnge ne ruohdh e ngo e naa ngaa tiihyo yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kedea ngaa daahd udoohnge ne ngad wong maalo nyumu e ngo dhiil doohng ne baahng me tiihyo yihr nyoge cang. ");
INSERT INTO lwo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bang gihn a ke nguda, ge adoohng ne dhaano utaahngo ge abeehn wiih piny, a kuu abeehno beere nyoge ge utiihyo yihra, a abeehno ne tiihj yihr nyoge kedea ne cub riha ne naah ke nying awuohye giih nyoge ne dug.” ");
INSERT INTO lwo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kaano e Jeacuu maa jo waahdh giihe ge abeehn geen Jeriiko. Kaano a'aay Jeacuue keehd jo waahdh giihe kedea amahr yaa buodh batiene yi geen nu, e dhaano me cuohn ne Bartimoaj ge beehda waahd Timiowj ni, ngo anaa apiih thaahng yooh. Bartimoaj ngo anahg ngaa maa acoor kedea kaano e naa ka piihe yea ne kwaj. ");
INSERT INTO lwo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Naa alihnge bang Jeacuu Ngad Naajaread kejea ngo abeehno, e ake thubo ke kwaago e uyuog e cuohn nying Jeacuu kobe, “Waahd Deabid! Jeacuu! Wongi akwaya, duu cwihnyi caahn banga!” ");
INSERT INTO lwo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","E ngo ake cuowo kejea lenge. Abea e naa kaa abare maalo ke kwaago e cuohn nying Jeacuu kea, “Waahd Deabid! Cedhree! Duu cwihnyi caahn banga!” ");
INSERT INTO lwo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","E Jeacuu ake cuungo kedea urobe ngo kejea, cuohne ubeehne bange. Maa acuohn gene ucuor gihn ni maa arub gene yihre kob gene, “Aj maalo deed cwihnyi! Yih ne ca cuohne nu.” ");
INSERT INTO lwo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Maa akahle athoohr gihre oogo ngahye upaahre ke maalo ne ci bang Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Maa apeehny Jeacuue ngo kea, “Gihn e ne daahdi ge roma yugo yihri?” Maa abeehr ucuore ngo kobe, “Ngad puohny! Yab wonga.” ");
INSERT INTO lwo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Maa akob Jeacuue ngo yihre kea, “Kea noono aayi naa ayiihi ngo kejea yihra ne tee me yaba wongi. Yiiho gihri yih athiehdhe.” Nye kaano e wonge ree ayabe yabo uneehn pinye yihre kedea uguoe doohng ne ngad Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Batien nihn e Jeacuu kedea jo waahdhe ge a'aay ne ci Jeruucalem. Ne ci Jeruucalem e yedha nye good me nyinge Good Ulihbe kedea ucor yihdh geedhe ariow Bedhpeag maa Bathany. Naa awahnh gene yihdh geedh nu e Jeacuu jo waahdhe kar ge ariow ge acuohne, ");
INSERT INTO lwo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","maa akoohbe yihr gen kea, “Cidhu paan cuud nyumu abea ge wahdhu, e akaja me dhaano kuu akuong paahr wiihe uyoadu e ngo amag piny. Goonyu ngo ukahlu ngo yihra kan. ");
INSERT INTO lwo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nea wu ke peehnyo kejea wu tiihy gihn kaa akaja, kea robu ngo kejea, ‘Ruohdh e ne daahd ngo kedea ngo uguoe ke duuo yihru piow piow.’ ” ");
INSERT INTO lwo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kaano e ge acidho maa ayoad gene akaja, e ngo amag piny nyum dhe wod thaahng yooh. Maa agoony gene ngo. ");
INSERT INTO lwo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","E nyoge maa anaa ake cuungo kaano, ge ke peehyo kob gene, “Akaja goonyu kaa nying gihn?” ");
INSERT INTO lwo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Maa abeehr gene ngo wa kaa arob Jeacuue ngo yihr gen maa awii akaja ne goonyo yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Maa akedh gene akaja bang Jeacuu kedea upeedh gene waare giih gen ngahy akaja ne kar piih maa abeehn Jeacuue upaahre maalo wiih akaja. ");
INSERT INTO lwo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gihn nu e nyoge me thoohdh waay gen apeedh gene piny ke bang yi yooh kedea mooge ge jag boog tuuo ke bang yihdh puohdh ne peedh yi yooh ne lor Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nyoge cang yaa ne wong maalo maa yaa buodh batiene ge ake caahdho e ge uwahr kob gene, “Wuoru Juog. Dooj Juoge ngade ge abeehno ke yoohn Paar Maalo. ");
INSERT INTO lwo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Dooj Juoge ruohdh kuowo Deabid ge beehn ni. Wuoro yaa ne Paar Maalo.” ");
INSERT INTO lwo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kaano e Jeacuu awahnh geen Jeruucalem kedea ucea kii laaro gihr Wod Juog. Noono uwene bang yi laaro cang. Abea naa adoohng pinye cahng ke yuudho e en maa joe ge apaar wong ariow ge adog geen Bathany. ");
INSERT INTO lwo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ruuwow batien kaa a'aay gene Bathany maano e ge caa Jeruucalem, e Jeacuu ree ayoade e abang kahje. ");
INSERT INTO lwo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Naa aniide yaadh dhuuro maa alodh me baahr ke dhe yooh e ngo ake cidho beere upuno ke nyethen dhuuro me poohd kuu acieg bang gihn ngo kuu anahg dwaahn cieg dhuure yea. Abea naa awahnhe tien dhuuro e nyethiin maa anaa wiihe atooro. ");
INSERT INTO lwo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Maa arube yihr yaadh ni kea, “Yih uthow ke wiihi utoor ngaa muu ucahg nyetheni ke camo keehdo.” Gihn arob Jeacuue ngo anaa alihng jo waahdhe. ");
INSERT INTO lwo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Gihn nu e ge adog duuo geen Jeruucalem maa abeehn Jeacuue ne mono yi laaro gihr Wod Juog. Naa aniid Jeacuue nyoge me thoohdh ge ngeehw oogo ke giih yug kweehr kedea mooge ge ngeew giih kweehr e cwihnye ake arahnyo ke nying gihn ayug laaro gihr Wod Juog ne cuug. Kaano e ngo athubo ke riem yaa nu oogo. Tharbeaje giih yaa waar ngiihny ge ajwange piny kedea utuge kuohn yaa ngeehw oogo ke winy me nahg ne giih kweehr. ");
INSERT INTO lwo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Thiow nyoge amahne ke ried yi laaro kea, “Kea ngaa ngud ke kan e ngo kaahn giih me ngeew oogo.” ");
INSERT INTO lwo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Maa athube ke puohny nyoge kea, “Ngo beehda gihn maa agweed yi kitaab Juog kejea, ‘Wod Juog beehda kar kwaj yihr nyoge cang.’ Abea e aman ayugu ne kar yaa kahw.” ");
INSERT INTO lwo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Gihn ayug Jeacuue ngo abeehn jo doong yaa lame kedea yaa loohng Juoge ne lihngo. Kaano e ge athubo ke cej dhe yooh me nahg gene ngo, bang gihn puohnye anhyaar nyoge keraahyo. ");
INSERT INTO lwo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ke wong thiehno e ge adog aay oogo yi buur geen Jeruucalem ne ci kar niine. ");
INSERT INTO lwo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yi ruu piny ke nyango maano e ge duu Jeruucalem e ge niid dhuuro gihn alam Jeacuue ngo atal cang uwahdhe yi bieye. ");
INSERT INTO lwo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piihter gihn arob Jeacuue naa alame dhuuro ngo aguoe ke paro maa arube yihr Jeacuu kea, “Ngad puohny! Maahnyi! Dhuuro gihn awaahro ge alami ngo ne ca atal cang.” ");
INSERT INTO lwo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Maa abeehr Jeacuue ngo kejea, “Yih thiow kwaad gihn nu romi kaa tiihyo nea Juog agaahni. ");
INSERT INTO lwo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ateed athiir yihru, ngaa rubo yihr good kea, ‘Good! Daag rihi oogo upahdhi yi naam duohng,’ ke cwihnye cang kedea ngo ayiihe kejea ngo uyug Juoge yihre e ngo dhiil pahdh kare. ");
INSERT INTO lwo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nea neehn maano e ngo aroba yihru kejea kwaad gihn daahdu bang Juog ke dhe yoohn kwaj, ngahyu ngo kejea ucub Juoge yihru kedea udoohnge ne gihru. ");
INSERT INTO lwo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Abea nea yih ukwahyo e kea kuong giih reje ge amaani yi cwihnyi ke nying ngaa maa atiihy gihn me raaj rihi ke wii piny. Ge kuongi kaa awii piny beere Juog Wuru ge ne Maalo ni giih reje ge ayugi ree ge wiie ke piny yihri thiow.  ");
INSERT INTO lwo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nea lubo me raaj maa ayug dhaane rihi be wii ke piny e Juog wuru gihn raaj ge atiihyi ree be wiie piny yihri thiow.” ");
INSERT INTO lwo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Naa awahnh gene Jeruucalem e Jeacuu acaa yi Wod Juog, kaano acaahdhe caahdho e ruohdh yaa lam kedea yaa loohng Juog maa jo doonge, ge abeehn bange ");
INSERT INTO lwo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","maa apeehny gene ngo kob gene, “Teeg mari noono ngaa e naa acube yihri? Teeg gihn riemi yaa angeehw oogo yi laaro gihr Wod Juog?” ");
INSERT INTO lwo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Maa abeehr Jeacuue ngo yihr gen kea, “Adaahd upeehnya wun ke nyepiny acielo. Nea ngo abeehru, e kaa ayoada tee gihn ariema nyoge oogo keehde ngo roba robo yihru arumo. ");
INSERT INTO lwo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Teeg mar Joon, ngad Luogwahy ngo ayoade ke Paar Maalo wale ke bang dhaano utaahngo? Beehru ngo yihra!” ");
INSERT INTO lwo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kaano e ge ake thubo ke rob ke rog gen kob gene, “Awaahn ni, nea wo urubo yihre kejea, ‘Tee ayoade ke bang Juog,’ e ngo duoge duogo kobe, ‘Abea gihn e bahnge lum Joon kuu anaa ayiihu?’ ");
INSERT INTO lwo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Abea ne wo urubo kejea, ‘Tee ayoade ke bang dhaano utaahngo,’ e nyoge ge taahny rogo bang gihn beehde ngahy gene cang kejea Joon anahg agamloohngjuog me duohng.” ");
INSERT INTO lwo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kaa aniid gene ngo e kar beehr ngo ariehnyo yihr gen e arob gene robo kob gene, “Ngo kwihj wane.” Maa aduog Jeacuue wiih lum gen kea, “A thiow, ngaa acub tee yihra ngo be roba yihru.” ");
INSERT INTO lwo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Batiene e Jeacuu ake thubo ke rob yihr yaa daahd ngo ke naah ke ucaale kea, “Anaa anudo ke nyin moogo maa anaa apiidh yen yi puohdho gihre. Gihn nu e puohdho aciele piny ke roog kedea uyuge ka me cong giih acieg yi puohdho. Thiow peehm ne koar puohdho kaa ayaahde ngo akoanye piny. Naa ayuge giih nu cang e nyoge akwanye me tiihyo yi puohdho. Maa arobe ngo yihr gen kejea koog gen unahg giih puohdho ge ucieg. Noono uaaye ucea ne weel. ");
INSERT INTO lwo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ge anaa arome kar cieg nyepinye ni, e baahng gihre aoohre ke bang yaa tiihj ne ci ne kahl kur mare yihdh giih acieg. ");
INSERT INTO lwo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Maa abeehn yaa tiihyo upuohd gene baahng kedea uriem gene ngo udooge ke cinge now. ");
INSERT INTO lwo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Maa acahge baahng moogo ke oohro bang yaa tiihj keehdo. Maa agooje ke loadh yi wiihe kedea ubang gene ngo keraahyo. ");
INSERT INTO lwo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Naa aoohre baahng moogo e ngo aci gene ke ne naah. Ce adoge baahng mooge me thoohdh ke oohro upuohd gen kedea unahg mooge. ");
INSERT INTO lwo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Nyin ni yihre anaa nye waahde acielo cog me nhyaare. Gihn nu e ngo aoohre oohro bang yaa tiihj giih ni. Ngo aoohre bang gihn ngo agweehge ke cwihnye kea, ‘Bang gihn nahge waahda e ngo uwuor gene.’ ");
INSERT INTO lwo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Abea ge aniid yaa tiihje waahd nyin e ge ake rubo ke rog gen kob gene, ‘E naa ngaa udoohng ne lag piny ni e gihn beehn ni. Nahgo ngo beere puohdho gihn udoohngo ne gihro.’ ");
INSERT INTO lwo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ge awahnh nyedhoohge e ge ataahny ree unahg gene ngo kedea uthoohr gene kuohme oogo ke wiih roog. ");
INSERT INTO lwo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Naa aparu wudhu, gihn e nuu uyug ngad puohdhe yihr yaa tiihj giih ni ge apiih ne cam ngo? Ngahda ngo ubeehn ne rwaahny nying gen ucube nyoge mooge ne tiihy yi puohdho? ");
INSERT INTO lwo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nye yaage! Gihn anaa agweed ke nying Ngad Boadh nyoge kuu angeyu yi ucaale gihn! Gihn anaa agweed naa, ‘Kaaw gihn akweer yaa geere keehde e naa adoohng ne meehn wod. ");
INSERT INTO lwo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gihn nu beehda tiihy Juog, e Juog Aciehg tiihy gihn me gaahy nyoge.’ ” ");
INSERT INTO lwo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Lum arob Jeacuue cwihny jo doong lam araanye bang gihn ngo angahy gene kejea ucaale arobe ke rog gen ge yaa yug giih waal rih Juog. Cwihny gen anaa bang mag ngo abea ge atud ke nying thoohdh nyoge, caahn e ge a'aay. ");
INSERT INTO lwo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Batiene e yaa Paarijea me maan Jeacuu kedea yaa batien Eroade ge aoohr bang Jeacuu ne cej dhee beere gihn me maan yaa Judea ngo robe robo. ");
INSERT INTO lwo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Maa abeehn gene bang Jeacuu urub gene kejea, “Ngad puohny ngahy wane kejea yih naa ngaa rob athere kedea yih be tud yihr kwaad dhaano utaahngo. Kedea be ngaa me bad yihn keehd me duohnge wa gihn, bang gihn yih be rubo ke nying dhaano moogo abea beehda lum Juog e ne puohnyi yihr nyoge. Awaahn ni, wa daahd urobi lubo ungahye cang, ke nying cuol gihn cub yihr Jaah Roama, ");
INSERT INTO lwo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","beehda gihn maa arob loohng Juoge yihro kejea gwaaj cuol yihr Jaah Roama ne wale ngo amahne?” Abea gihn raaj agweehg gene kii cwihny gen ngo angeye maa arube yihr gen kobe, “Ngahya kejea wu tum an. Abea kea kahlu wong grihj yihra umaanya ngo.” ");
INSERT INTO lwo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Maa akahl gene wong griihj acielo yihre. Naa amaanye ngo e akobe yihr gen kejea, “Cuuro gihr ngaa kedea nying ngaa e naa agweed ngahy grihj gihn?” Maa abeehr gene ngo kob gene, “Beehda cuuro kedea nying Jaah Roama.” ");
INSERT INTO lwo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Maa akoohb Jeacuue yihr gen kea, “Beer, cubu kwaad gihn beehda gihr Jaah Roama yihr Jaah Roama kedea cubu gihn beehda gihr Juog yihr Juog.” Gihn nu e wudh gen anaa cohd yi lum ateede bang gihn lubo abeehre ke dhe yooh me ka me mage tooro. ");
INSERT INTO lwo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Batiene e yaaj me cuohn ne Caaduucean, e be yiih ngo kejea nyoge maa athow ge ucahro cahng moogo ge abeehn bang Jeacuu maa apeehny gene ngo kejea, ");
INSERT INTO lwo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ngad puohny! Anaa arob loohng Moaje kejea, ‘Nea dhaano umen athow uwiie ciihe piny abea nyethiin tooro yihr gen, e ngaan nu umen athow, ciih umen geere geero beere yea ngo nyuole nyuolo.’ ");
INSERT INTO lwo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Anudo ke wuud meehe abiihjberiow. Ngaa duohng gen anaa abeehn ne nyuohm maa athowe e yihre tooro nyethiin. ");
INSERT INTO lwo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Maa abeehn ngad batiene ugeere ciih umen kedea ucahge thoo e nyethiin tooro kiin gen. Maa acahg umiih gene moogo do wod ke dhaago maa athowe thiow e nyethiin tooro. ");
INSERT INTO lwo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kar ge noono abiihjberiow ge abeehdo ke dhaar ni kedea uthow gene cang e ngaa maa anyuol keehd ngo tooro. Maa abeehn dhaage ne thoo ke batien gen thiow. ");
INSERT INTO lwo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Me neehn kaa rubi kejea nyoge ge ucahro, e dhaar ni unahg ciih ngaa kiin gen? Bang gihn ge ke kar gen noono abiihjberiow ge abeehdo keehde!” ");
INSERT INTO lwo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Maa arub Jeacuue yihr gen kea, “Ngahda e naa gihn koba kaa wu nyoge me gihn me ngahyu tooro ne? Gihn me ngahyu tooro ke nying cahr nyoge ge agweed yi kitaab Juog kedea ke nying teeg Juog e meehg nyoge cahro. ");
INSERT INTO lwo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ngaa muu unahg cuor dhaar nu utooro, bang gihn ge umeehg Juoge nyoge cahro e gihn me nyinge nyuohm utooro, nyoge ge uke beehdo wa kwaad mar wuohdjuog ge be nyoohmo. ");
INSERT INTO lwo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Abea nea ke nying cahro ge ucahg nyoge cahro wiiha para paro kejea kitaab gihn agweed Moaje ngo akwaano, ge rubo ke kar bungo maa awaang. Agweede kejea Juog arubo kea, ‘A naa Juog awuor Abraahme maa Yijaag kedea Jeakob.’ ");
INSERT INTO lwo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yaa athow e ge wuor Juog, yaa nu ge kuow Paar Juog bang gihn beehda Juog e ne cub kuow. Yea lubo abaaju ne cohg.” ");
INSERT INTO lwo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ngad loohng Juog anaa anudo maano e Jeacuu maa yaa Caaduucean ge upeehmo ke rog gen ke nying lum Juog. Naa aniide ngo kejea Jeacuu wonge teeg ne beehr luube e ngo apeehnye kea, “Ngad puohny, loohng aweehne e naa loohng wiihe ne maalo kiin loohng Juog?” ");
INSERT INTO lwo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Maa abeehr Jeacuue ngo kea, “Gihn e naa loohng me wiihe ne maalo kiin loohng Juog cang. Lihngu gihn wu yaa Yijarael! ‘Juog e Ruohdho beehda acielo cog ");
INSERT INTO lwo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","kedea dhiil Juog Ruohdhi ke nhyaaro ke aduuni beehde, ke wahyi beehde kedea ke wiihi beehd maa ke teegi beehde.’ ");
INSERT INTO lwo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Riown gen e man: ‘Nhyaar wadu wa ka nhyaari rihi kii ngo.’ Loohng moogo me yoohm wudh loohng ni ariow ngo tooro.” ");
INSERT INTO lwo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Maa abeehr ngad loohng Juoge ngo yihr Jeacuu kea, “Ngo angahyi ke beehro, ngad puohny! Gihn arobi ngo athiir kejea Juog beehda acielo kedea Juog moogo tooro kedea ");
INSERT INTO lwo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","dhiil kaa wuoro ka aduulo beehde kedea ke wihj beehde maa ke teeg cang kedea thiow dhiil yaa beehd dhaane kiin gen ke nhyaaro wa ka anhyaar dhaane ree. Loohng ni ge ne wudh ge ne maalo nyum Juog yihr ma beehn dhaane ucube giih kweehr yihr Juog abea nhyaahro tooro yi cwihnye.” ");
INSERT INTO lwo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Naa aniid Jeacuue ngo kejea ngo angahy rob e abeehre beehro yihre kea, “Ngo aniida kejea adoohng ka me cahng uyoadi Paar Juog.” Batien rob Jeacuu e ngaa maa adog ngo ke peehnyo ne tume tooro. ");
INSERT INTO lwo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ge apuohny Jeacuue puohnyo yi laaro gihr Wod Juog ni e akobe kea, “Gihn e koohb yaa loohnge kejea, ‘Ngad Boadh nyoge unahg kwaar Deabid?’ ");
INSERT INTO lwo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","“Adiehr muon Ngad Boadh nyoge beehda dhaano utaahngo bang gihn beehda ngad dhe wod paar Deabid. Abea adaahd ucoaru wudhu yi lum anaa agweed Deabide yi kitaab Wahy Poong Juog. Agweede wa kaa arob Wahy Juoge ngo yihre kea, ‘Juog urubo yihr Ruohdha kea: “Piih ukwiihya kan, uwahdhe ka uyuga yaa mahni ne gihr thaahdh tieni.” ’ ");
INSERT INTO lwo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deabid kwaare cahge cuohno ne ruohdhe ke ne diih?” E yaa athoohdho ge anaa ake lihngo cwihny gen amihno yi gihn arobe. ");
INSERT INTO lwo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yi puohnye naa apuohnye puohnyo, e ngo arobe kea, “Cubu wudhu piny beer mee ubahnge giih yug yaa loohng Juoge ge be yugu. Yaa loohng Juog ge nhyaar ngaab waare maa awuob kedea yi yooh ge nhyaar ngo umaahdh gen ke cing ariow. ");
INSERT INTO lwo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ge koag ke mieg kuohn piih giih beeye wong maalo yihdh wuud amaad kedea ukoag gene thiow ke mieg kuohn piih giih beeye yi kuohn amahd nyoge yihdh gen. ");
INSERT INTO lwo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ge nyoge me nhyaar cam giih gule kedea kwaj duug yi Wod Juog ne kang nying nyoge abea toohd now kway gen yea apuogo. Juog ge ukihme ke deeh ukihm me teeg.” ");
INSERT INTO lwo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Cahng man Jeacuu anaa apiih buud caanduug ngiihny yi laaro gihr Wod Juog, e many nyoge me cub piny ke ngiihny ke nying Wod Juog. Nyoge maa alony me thoohdh ge acub piny kaa amahr ngiihny. ");
INSERT INTO lwo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kaano e dhaago maa gulo ake beehno uthoohre wong grihj yi caanduug. ");
INSERT INTO lwo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Maa acuohn Jeacuue jo waahdh giihe urube yihr gen kea, “Maanyu dhaar ca acub ngiihny yi caanduug. Nea gihn maa athiir e ne rob, e dhaar nu e naa amuuyo ke raahyo kiin yaa acub ngiihny piny cang. ");
INSERT INTO lwo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bang gihn yaa nu cang ge amuuyo, keehd maa amuuy gene, e ge ajal wudh ngiihny giih ne yihr gen. Abea dhaar ni beehda dhaago maa angoohng kedea ucube gihre me koare wiihe ke ngo. Gihn acub dhaar nu ngo anhyaar Juoge keraahyo ukaale wudh muu acub yaa alonye.” ");
INSERT INTO lwo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ge athub ge Jeacuue ke beehn oogo yi laar gihr Wod Juog ni e dhaano acielo kiin jo waahdh giihe apiih ne leej Wod Juog yihr Jeacuu kobe, “Ngad Puohny! Wod Juog gihn ageer ke leele maa awuob ne cohg. Maanyu kaa ayug wuude ne wuob kii ngo!” ");
INSERT INTO lwo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Maa abeehr Jeacuue ngo yihre kejea, “Gihn e ne ngahyi! Wuud nu awuob ge niidu ge uthuohm piny utoor wong leelo acielo muu udoohng wiih wad gen.” ");
INSERT INTO lwo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Gihn nu maa a'aay gene ne ci wiih good Ulihbe. Naa awahnh gene e Jeacuu apiih maano e nyume aloge bang Wod Juog. Kaano e Piihter maa Jeamij kedea Joon maa Andrya, ge athubo ke peehny Jeacuu kar gen keed gen kob gene, ");
INSERT INTO lwo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ngad puohny teed ngo yihr wan, unahg cahng aweehne e nuu uthuohm Wod Juog piny kedea gihn e nuu unyoadh ngo kejea cahng utiihy giih ni rog gen ngo abeehno.” ");
INSERT INTO lwo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Noono e Jeacuu ake thubo ke rob yihr gen kea, “Cubu cwihnyu piny beer mee ubahnge rogu be meehgu dwaahngo, ");
INSERT INTO lwo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","bang gihn amahr nyoge me dwaahng wun ke nying giih uyug rog gen ge ubeehn ke batiena e ge rubo kaa nyinga, e ngaa man ukoohbo kea, ‘A naa Jeacuu Ngad Boadh nyoge.’ Yaa nu, thoohdh nyoge urom gene ke dwaahngo. ");
INSERT INTO lwo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Thiow linye bang gen ulihngu kedea dhog uwahnh bangu ke nying linye mooge me ne kuohn me bahye. Abea yihdhu keá baadh, bang gihn giih nu rog gen kuong gene kaa tiihyo umodho e cahng gug piny poohd kuu awahnho. ");
INSERT INTO lwo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Paajo yea upahw ne dahg ubeehn yaa tien paajo acielo ukag gene ke rog gen kedea dhaahre giih wiih piny ge ukag ke rog gen. Amahr ayahng ngoom me thoohdh rog gen uyug gene ke bang kuohn me thoohdh wiih piny kedea kahj nyoge ubange ke bang wiih piny. Giih nu ge unahg ka uthub giih reje ge ukuong tuohl abea keehd maano e ge uroomo kaa raahm nyoohdo e thub maahdh batiene e bar maalo ke raahm keraahyo. ");
INSERT INTO lwo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","10","“Abea Ciig Beer ngo dhiil kaa puohnyo yihr yaa ungoom maano e piny poohd kuu agug. Yugu rogu beere cwihnyu ungahmo ne koar giih reje ge upahdh wudhu. Wu umag ucub wun yi cing ruohdhe giih wuud amaade ke nying gihn nahgu jo'a. Wu upuohd gene yihdh wuud amaade kedea wu ukedh nyum ruohdhe kedea jaah ke nying gihn ayiihu luma. E naa ka uteedu giih alihngu banga yihr gen kedea yihr nyoge me padh yaa Judea. ");
INSERT INTO lwo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Abea nea wu amag kedea ukedh wun yi lug e wu keá diero ke gihn urobu nyum lug, bang gihn rob urobu unahg Wahy Juog e nuu ucub ngo yihru ne robo. ");
INSERT INTO lwo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Dhaano maa akweer ke luma, umen kedea nyethiine maa ayiih luma ge umaane uwahdhe ka uluome gen unahg gen. Thiow nyethiin maa akweer ke luma, wahn ke men maa ayiih luma ge umaane uwahdhe ka uluome gen unahg gen. ");
INSERT INTO lwo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wu thiow, wu umaan nyoge cang ke nyinga. Abea ngaan umag cwihnye teeg uwahdhe guge e ngaan nu e nuu uyoad boadh wahy. ");
INSERT INTO lwo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Cahng uniidu giih reje ngo ubeehn, cahng ubeehn Ruohdh atiihb ukeehg ujwaahge Wod Juog gihr Jeruucalem udoohnge ne ka me nyoge Juog be wuor gene yea. (Kaano e nuu ubeehn ngaa kwaahno upare wiihe beer mee) kedea ubeehn yaa beed piny Judea ugoohd gene ke ngweej ne ci ne pahno yihdh bung yihdh goode. ");
INSERT INTO lwo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ngaa ayuud gihn nu e ngo ne piny kane, e ngo keá do wod ne cej gihr nyepiny ");
INSERT INTO lwo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","kedea ngaa nii puohdhe e ngo keá do paajo ne kaab waahnye. ");
INSERT INTO lwo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Gihn nu unahg gihn me raaj keter yihr maahn me yaje kedea maahn dhuohdho bang gihn ge buu urom ngweej ne cohg. ");
INSERT INTO lwo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Abea kwayu Juog beere gihn nu ree be yuge e piny aboar ");
INSERT INTO lwo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","bang gihn raahm upahdh yihdh nihn nu unahg raahm me raaj me kuu akuong pahdh upiny ke cahng anaa acag Juoge wiih piny uwahnhe awaahn kedea me ree buu ucahge ke bero cahng moogo keehdo. ");
INSERT INTO lwo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nea Juog Ruohdh ngo be ne guoe ke gweehgo ne ngol yihdh nihn nu, e dhaano utaahngo me ne bodh ne tooro. Abea ke nying yaae ge akwanye, e nihn nu ge ayuge noog. ");
INSERT INTO lwo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Teeda teedo yihru thiow kejea nea dhaano ubeehno urube yihru kea, ‘Arob gihn yihru! Ngad Boadh nyoge abeehno ke ca!’ Wale ukoohbe kea, ‘Ngad Boadh nyoge ngo ne ca!’ Giih nu ge keá yiihu ne weey weey naa athere. ");
INSERT INTO lwo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bang gihn unud ke nyoge me thoohdh muu ubeehn ke batiena ne dwaahng wun. Ngaa man ukoohbo kea, ‘A naa Ngad Boadh nyoge’ kedea ngaa moogo ukoohbo kea, ‘A naa agamloohngjuog!’ Yaa nu giih me teeg me gaahy nyoge ge urom tiihyo yihr gen. E naa ka uraany gene wudh nyoge uwii gene luma piny, keehd yaa akwany Juoge ne yaae wudh gen uraany gene nea dhe yooh ayoad gene. ");
INSERT INTO lwo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Giih ni ge aroba yihru beere nea cahng ubeehn giih nu uyug gene rog gen e wu uyuud e rogu agwiiru. ");
INSERT INTO lwo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Yihdh nihn nu, ke batien giih raahm, ‘e wong cahng naa lihb kedea dwaahy buu ugeed maa ");
INSERT INTO lwo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ciehr ge uthub ke pahdho ke yoohn maalo kedea giih yea maalo rog gen uyahng gene.’ ");
INSERT INTO lwo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Batiene e a ge adoohng ne dhaano utaahngo a uniid e a ubeehno kii lwahd keehd tee mara e wiiha amoar. ");
INSERT INTO lwo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kaano e wuohdjuog ge uoohr ne cong jo'a naa akwanya ke bang upiny cang keehd kuohn me baahye. ");
INSERT INTO lwo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Beehna uroma ke rih dhuuro. Nea ngo uthubo ke lodho e ngahj kejea oohro adoohng cahng. ");
INSERT INTO lwo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Beehna ngo udoohng cahng nea wong cahng urwaahnyo. Neehn maano thiow nea giih nu rog gen ayug gene e kea ngahyu ngo kejea beehna adoohng cahng. ");
INSERT INTO lwo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Adiehr e ne roba yihru. Wu yaa nud awaahn ni wu buu uthow cang e giih aroba yihru rog gen poohd kuu atiihy gene. Wu ubodh keehd me yug giih nu ateeda rog gen. ");
INSERT INTO lwo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Maalo kedea upiny kan ge utooro abea luma ree utiinge kare. ");
INSERT INTO lwo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Abea cahng uduua ngaa me ngahy ngo tooro. Ngo kwihj wuohdjuoge ge nii maalo wale an thiow cahng ngo wale caang ngo kwihya. Juog Wura e keede e nuu ungahy cahng ngo. ");
INSERT INTO lwo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Koaru rogu, wu keá neno bang gihn kwihyu cahng ngo ubeehn weehne. ");
INSERT INTO lwo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ngo uneehn ngaa maa aci ne weel ka me baahr uwiie baahng giihe piny e tiihj apaahnge yihr gen cang. Noono maa arobe ngo yihr ngad koar dhe wod kejea ngo keá neno, koare paajo. ");
INSERT INTO lwo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Nea wa maano e wu keá neno bang gihn ngo kwihyu weehne e nuu ubeehn ngad paaje, uduu ke thiehno! Dewaahr! Kaa akaahg piny wale ke nyango? ");
INSERT INTO lwo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wu dhiil koar beere nea ngo guo beehno e wu be yuude e wu aneno. ");
INSERT INTO lwo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gihn roba beehda gihn me roba ke yihru cang. ‘Ngaa keá gwaahg!’ ” ");
INSERT INTO lwo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Anaa adoohng nihn ariow unahge cahng Yaan Amono. Maa abeehn jo doong yaa lame maa yaa loohng Juog udaahd gene dhe yooh ke piny me mag gene Jeacuu unahge. ");
INSERT INTO lwo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Abea ge atud ke mag Jeacuu cahng yaay bang gihn kob gene, “Kuro tudi! Bang gihn nea ngo mago mago awaahn ni e yaa abeehn yi yaay wo maahd gene maahdo ke liny.” ");
INSERT INTO lwo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jeacuu anaa yi geen Bathany e ngo beehda weehno paar Cimoan Udhoobo. Kaano acahme cahmo e dhaago ake beehno e kaahn udhoohmo me yea ne mow me ngwaahy me ngiene teeg. Ngo akahle kedea uwoje ngo wiih Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Naa aniid yaaj mooge maa anudo e mow awuoj dhaar ni wiih Jeacuu, e ge ake rubo ke kiin gen kob gene, “Beehda gihn e yoad mow me ngiene teeg uraany nyaane ngo now? ");
INSERT INTO lwo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gihn keree! Mown nu ne rom ngeew oogo ukahle amahr ngiihny me thoohdh me ne cub yihr nyoge maa angoohng.” Maa acay gene dhaar ni ne cohg. ");
INSERT INTO lwo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Abea ngo abeehr Jeacuue yihr gen kobe, “Wiiu ngo! Gihn ge giedu dhaar ni? Beehda gihn me beer ne cohg e naa atiihye yihra. ");
INSERT INTO lwo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yaa angoohng ge nyoge me beehdo kaa wun ke nying nihn kedea gihn me beer yugu yugo yihr gen wa ka daahdu ke cwihnyu. Abea an, a buu ukwaay beehdo ke wun e naa gihn beere noono ubeehn dhaar ni umoare wiiha e a poohd nud ke wun. ");
INSERT INTO lwo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dhaar ni atiihy gihn me beer naa amoone piny ne wiihr kuohma ke mow ne gwiir kuohma ke nying cahng ukoany an. ");
INSERT INTO lwo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Awaahn ni a rob athiir yihru kejea kwaad kuohn upuohny Ciig Beer yihdh gen ke bang upiny cang, e gihn ayug dhaar ni uke robo thiow ne par bang dhaar ni.” ");
INSERT INTO lwo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Dhaano acielo kiin joe ge apaar wonge ariow, me nyinge cuohn ne Juudo a'aay ucea bang jo doong yaa lam ne luom Jeacuu yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","E cwihny yaa ni ake mihno naa alihng gene kwaad rob nu. Gihn nu e ngo arob gene yihr Juudo kejea ngo umuoj gene ke ngiihny me thoohdh nea Jeacuu luome luomo. Kaano e Juudo athubo ke cej dhe yooh me kahle gen bang Jeacuu beere ngo mag gene mago. ");
INSERT INTO lwo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Cahng umodho yihdh nihn Yaan Amono e jo waahdh Jeacuu apeehny gene kob gene, “Ngad puohny! Kee e ne daahdi nuu ugwiir wane ne kar piih yihro ne yug cam cahng Yaan Amono yea?” ");
INSERT INTO lwo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Maa abeehn Jeacuue uoohre nyoge ariow kiin jo waahdh giihe kea, “Cidhu yi diehr geen Jeruucalem nea wu uroohmo ke dhe cuow me kaahn piih kea buodhu batiene. ");
INSERT INTO lwo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Paan umone yea e kea robu ngo yihr ngad paajo kejea, ‘Arob ngad puohnye kejea nyoadhi wod upiihe yea keehd yaae ne yug giih yaay?’ ");
INSERT INTO lwo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wod unyoadhe yihru maalo maa agwiir beer mee ke nyingo. Yi wod nu gwiiru caame giiho.” ");
INSERT INTO lwo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Maa abeehn jo waahdhe ucidh gene yi diehr geew kedea uyoad gene giih anaa ateed yihr gen wa kar gen. Naa athum gene ke gwiir caam yaay, e ge adog bang Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ke wong thiehno arumo, e Jeacuu ake beehno keehd joe ge apaar wonge ariow yi wod agwiir. ");
INSERT INTO lwo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Naa apiih gene ne cam wiih tharbeajo, e Jeacuu ake rubo yihr jo waahdh kea, “A rob gihn maa adiehr! Dhaano acielo kiinu daahd uluome an keehd maa acahma tiehd keehde.” ");
INSERT INTO lwo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Gihn nu cwihny jo waahdh araanye ne cohg. E ngaa man peehny Jeacuu kea, “Unahg an ne wale gihn?” ");
INSERT INTO lwo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Maa abeehre ngo yihr gen kea, “Unahg ngaa uroohm cing wane yi wal keehde kiinu noono apaar wonge ariow. ");
INSERT INTO lwo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A ge adoohng ne dhaano utaahngo a uthow wa kaa agweede yi kitaab Juog abea ngaa luom an, a ge adoohng ne dhaano utaahngo unaa yi gihn me raaj ne waany adhaahr ngweehn me bahnge ngo be ne nyuol.” ");
INSERT INTO lwo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kaano acahm gene cahmo, e Jeacuu amono akaabe batiene naa adooje ngo e ngo abanye maa acube ngo yihr jo waahdhe e urubo kea, “Kaabu ngo kedea camu ngo. Gihn ni beehda e naa kuohma.” ");
INSERT INTO lwo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Keehdo e kubaayo me yea ne koongo akaabe batiene naa amuohje koohr Juog e ngo acube yihr gen maa amaadh gene ngo. ");
INSERT INTO lwo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Maa arube kea, “Gihn ni beehda rema. Rem nweehd won ge awoj piny ke nying nyoge me thoohdh. ");
INSERT INTO lwo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A teed athiir yihru. Koongo buu ucahga ke maadho keehdo uwahdhe cahng umaadha koohng nyaahn Paar Juog.” ");
INSERT INTO lwo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Batien kaa awahr gene Wahy Apoong Juog, e ge ake aay ne ci wiih Good Ulihbe. ");
INSERT INTO lwo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Maa arub Jeacuue yihr gen kea, “Wu noono cang wu ugoohd oogo riha uwiiu a piny wa kaa agweede yi kitaab Juog ke nyinga naa, ‘Ngad kwaah unahg ubeehn diehge ulog gene keedho.’ ");
INSERT INTO lwo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Abea cahng ucahra ke batien thoo, e a ucidh Gaalili ka ubeehnu banga yea.” ");
INSERT INTO lwo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Maa abeehr Piihtere ngo yihre kobe, “Keehd me paahr nyoge oogo ugoohd gene, e a ke nguda a be kuong paahr oogo uwiia yihn piny.” ");
INSERT INTO lwo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Maa akob Jeacuue ngo yihre kea, “Adiehr e ne roba yihri. Tihn noon ni yi dewaahy tihn maano e uthuonjieno poohd kuu akoohg ne riow e yih ukweer ke an tiel adahg kejea a kwihyi.” ");
INSERT INTO lwo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","E ngo acahg Piihtere kaa beehro kea, “A be kuong kweer ne weey weey kejea yih kwihya keehd me nahge thoo, e a uthoo tiehd ke yihn.” Maa abeehr gene ngo cang wa kaa arob Piihtere. ");
INSERT INTO lwo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Batiene e ge abeehn piny me cuohn ne Gedhceama maa arobe ngo yihr jo waahdh giihe mooge kea, “Piihu kan ne koar, abea wu keá gwaahg. A nyiig wong maalo ne kwaj.” ");
INSERT INTO lwo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Maa acuohne Piihter kedea Jeamij maa Joon ne cidho keehde. Nye kaano e Jeacuu ree ayoade yi rahny cwihny me duohng ke raahm aduulo me teeg. ");
INSERT INTO lwo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kaano e arubo yihr yaa caahdh keehde kea, “Yaage! Aduuna urahmo cang ke raahm me wa a cej thoo. Doohngu kan abea wu keá neno.” ");
INSERT INTO lwo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Maa acidhe wong maalo, ka me thiin mee e apahdh wudh conge ne kwaj kejea nea kare nud kea beehn deeh raahm gihn bare now ke buude. ");
INSERT INTO lwo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Maa arube kea, “Abaa Wura! Giih nyepinye cang ge yoohd yihri. Nea kare nud kea kaab raahm gihn ni beehn riha. Abea keehd maano, e keá yugi wa ka daahda abea yug ngo wa kar cwihnyi.” ");
INSERT INTO lwo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ge aduue bang jo waahdh giihe ni, e ge ayuude e ge uneno. Maa acaye Piihter kea, “Cimoane yih keá neno! Yih ka be rom koar ke kar caa acielo cog ne? ");
INSERT INTO lwo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Wu keá neno, abea kwahyu beere wu be tum atiihb ukeehge. Mare ngo athiir! Aduulo ngo teeg, ngo rom guum abea kuohm e naa agoohg.” ");
INSERT INTO lwo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Maa acahge aay keehdo, ne kway Juog e ber gihn anaa arobe umodho yihr wahn. ");
INSERT INTO lwo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Naa acahge duuo e ayuud jo waahdh giih adahg e ge ane twar ke niine bang gihn ge anaa agoohg niine ne cohg. Noono ulaahy wudh gene utoor gihn maa arob gene. ");
INSERT INTO lwo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Maa aduue keehdo yi dahg gen, urube yihr gen kea, “Wu poohd niin gihn? Gihn me nenu ke nyinge keehdo tooro bang gihn caang cub an, a ge adoohng ne dhaano utaahngo, yi cing nyoge me reje ne naah ngo abeehno. ");
INSERT INTO lwo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yedhu maalo upahdho yooh. Ngaa aluom an e aman awahnho.” ");
INSERT INTO lwo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Piow piow kaano apoohde e Jeacuu urubo nu, e Juudo ge beehdo dhaano acielo keew yaa Jeacuu ge apaar wonge ariow ake wahnho e ngo caahdh kaa nyoge me thoohdh maa aoohr jo doong yaa lame maa yaa loohng Juoge kedea jo doong paajo. Yaa ngo ge akaahn pale kedea belunge. ");
INSERT INTO lwo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ngo anaa arob Juude yihr jo abeehne ke gen kea, “Ngaa baahba ree ke maahdh e naa ngaa magu bang gihn e ne daahdu. Magu ngo uaayu keehde kedea kaahnu ngo e atiegu piny.” ");
INSERT INTO lwo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kaa awahnh Juude, e abaahb rih Jeacuu ke maahdh kobe, “Koohri Ruohdh.” ");
INSERT INTO lwo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","E jo anaa ake caahdho ge ake beehno umag gene Jeacuu utuohj gene ngo. ");
INSERT INTO lwo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Gihn nu e ngaa maa ake cuungo kaano, pala ayuohdhe ke oogo ungole yih baahng me tiihyo paar ngad duohng yaa lam. Yihdh ngo angole piny ne thihb. ");
INSERT INTO lwo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Maa apeehny Jeacuue gen kea, “A abeehdo ke wun kedea a na niidu niido e a caa yi laaro gihr Wod Juog ke nying nihn upuohnya nyoge puohnyo abea a kuu anaa amagu. Awaahn ni gihn ge beehnu banga e wu kaahn pale maa belunge kii cingu udoohnge wa a beehda ngaa maa apaahr oogo ne liny ke ukuuma? Abea awaahn beehda giih anaa agweed yi kitaab Juog ge ne pahdh kar gen wa kaa agweed gen.” ");
INSERT INTO lwo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kaano e jo waahdhe cang ge ake aay ke ngweej uwii gene Jeacuu piny yi cing nyoge me reje. ");
INSERT INTO lwo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Batiene e ngaa maa arihj maa angaab waahny niine kedea caahdh kaa cinge now, apahdh ne buodh batien jo ni amag Jeacuu, e ngo akwahg gene ke piny umag gene ngo. ");
INSERT INTO lwo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kaano e nyin anaa apoj yi cing gen ugoohde ke kuohme now, uwiie waahnye yi cing gen. ");
INSERT INTO lwo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kaano e Jeacuu abeehn gene ne kedh paar ngaa duohng jo doong yaa lam kaa amahd jo doong yaa lame kedea jo doong paaje maa yaa loohnge yea. ");
INSERT INTO lwo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piihter anaa ake caahdho e buodh batien Jeacuu ke ka me baahr mee uwahdhe paar ngaa duohng yaa lam. Gihn nu e ngo apiih buud acaakere giih koar Wod Juog maa anaa buud maaj ne oohyo. ");
INSERT INTO lwo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Abea e jo doong yaa lam kedea yaa Akuud Judea giih acuohn ge apiih ne daahd awuohj rih Jeacuu beere ngo ke kihmo. Abea kihde now awuohj maa ayoad gene rih Jeacuu tooro me rom ngo ke kihmo ke thoo. ");
INSERT INTO lwo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Keehd maa abeehn nyoge me thoohdh upiih gene ne rob giih toohd rih Jeacuu, ne kal dhee, nyum akuud yaa Judea, e gihn maa ayaahng yaa lug yi luub gen tooro, bang gihn luub gen ge kuu aroohmo. ");
INSERT INTO lwo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kaano e nyoge mooge ge ayedh maalo ne rob toohd kob gene, ");
INSERT INTO lwo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ngaan anaa alihng wane e urubo kea, ‘Wod Juog gihn ni ageer dhaane ngo uthuohma piny abea batien nihn adahg e moogo ugeera kare me padh dhaano e naa ageer ngo.’ ” ");
INSERT INTO lwo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Abea keehd maano e luub gen poohd be roohm. ");
INSERT INTO lwo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Naa abahnge awuohj maa ayoad rih Jeacuu tooro, e ngaa duohng yaa lam Jeacuu apeehnye peehnyo kobe, “Gihn e bahnge wudh giih rob rihi ge be duogi? Gihn e naa adiehr kiin giih arob yaa ni rihi?” ");
INSERT INTO lwo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Abea Jeacuu aleng ne caaj ubahnge rob nu keá beehro. Ucahg Kaaypaje piehj keehdo kobe, “Beehr ngo yihra, yih naa Ngad Boadh nyoge ge Waahd Juog Aciehg?” ");
INSERT INTO lwo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Maa ayiih Jeacuue ngo kobe, “Beehda an kedea a ge adoohng ne dhaano utaahngo a uniidu e a apiih ukoom ruohdh ukwiihy Juog wiih koom ruohdh kedea a uniidu ge ubeehna wa daahr maaj kii lwahd ke yoohn maalo Paar Maalo.” ");
INSERT INTO lwo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Maa abeehn ngad duohng yaa lame urahny cwihnye yi kwaad gihn arob Jeacuue rih Juog. Gihn nu e ngaa duohng yaa lam waahny ree ke ngude ayieye ke oogo yi ngahye maa aloge dhee ne rob yihr yaa akuud kobe, “Ngahda ngo alihngu kaa amage ree ke dhee kea e uroomo ke Juog? Naa awuohj moogo me cahgo ke daahdo yaage? ");
INSERT INTO lwo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ngo alihngu cang kaa arube kea e uroomo ke Juog. Nea maru e ukihm gihre beehda gihn?” E yaa akuud Judea cang ge akoohbo kob gene, “Kihme ke thoo.” ");
INSERT INTO lwo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kaano e wong Jeacuu atuohj gene tuohyo kedea uthub gene ke nguud rih ngo kedea ke twang wiihe ne yaahr kuohme kedea e ngo ke peehnyo naa, “Yih nyin akoohbo kii yih Ngad Boadh nyoge caar ngaan nguud rihi kedea ngaan goj yihn!” Noono maa akaab acaakere ngo ne ci ne puohdo. ");
INSERT INTO lwo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Kaano ge apoohde e Piihter ne kiin yaa ni piih buud maaj ne oohyo ni, e nyaakow me beehda baahng paar ngad duohng yaa lam ake beehno. Naa aniide Piihter e bang ngo amaanye keraahyo maa arube yihr ngo kea, “Yih na niida niido thiow kiin yaa ne caahdh keehd Jeacuu Ngad Naajaread?” ");
INSERT INTO lwo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","E Piihter ake kweer kea, “Ngaan nu rubi ke nyinge ngo kwihya kedea gihn robi ni be ci wiiha ne cohg!” Maa aci Piihtere oogo yi kala kedea uguo uthuonjiene ke koohg. ");
INSERT INTO lwo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","E Nyaakow ni aween ni, Piihter acahge ke niido urube yihr yaa anaa ake cuungo oogo kar lug kobe, “Ngaan beehda ngad gen thiow.” ");
INSERT INTO lwo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","E Piihter poohd ukweer keree kea Jeacuu kwihye. Batiene e yaa ake cuungo ge athubo ke rob yihr Piihter kob gene, “Ne cohg yi beehda ngad Jeacuu, bang gihn yih rubo wa ka rub yaa Gaalili kii ngo.” ");
INSERT INTO lwo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Abea ge alihng Piihtere rob nu, e athub ke kuohng ree kea, “Yaage! Arob adiehr nyum Juog. Ngadu noono rubu ke nyinge nu ngo kwihya!” ");
INSERT INTO lwo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nye kaano athume ke rob e uthuonjieno acahg koohg keehdo, maa apar Piihtere gihn anaa arob Jeacuue yihre, “Tihn noon ni yi dewaahy tihn, maano e uthuonjieno kuu akoohg ne riow e yiih ukweer ke an tiel adahg kejea a kwihyi.” Maa athub Piihter ke lalo ke keej yej naa angeye deeh awuohj gihn atiihye. ");
INSERT INTO lwo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yi ruu piny ke nyango coon, e jo doong yaa lam kedea jo doong paajo maa yaa loohng Juog kedea yaa akuud ge apiih ne mad gihn utiihy gene. Gihn nu e ngo amad gene kejea Jeacuu kedh bang Pilaato, Muudiihr Roama ge mag piny Judea beere ngo kihme kihmo yihr gen ke thoo. Kaano e cinge ge atuohj ukedhe bang Pilaato. ");
INSERT INTO lwo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ge awahnh Jeacuue bang Pilaato ni, e Pilaato Jeacuu apeehnye kobe, “Yih naa Ruohdh yaa Judea ne?” Maa abeehr Jeacuue ngo kea, “Yih naa arob ngo ke dhii.” ");
INSERT INTO lwo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kaano maa athub jo doong yaa lame ne rob gihn amag gene ngo ke nyinge e ge rob giih me reje me thoohdh rih Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Noono e Pilaato Jeacuu apeehnye kea, “Gihn me beehri tooro ke nying giih arob rihi? Maany amahr giih ni thoohdh ge arob gene rihi!” ");
INSERT INTO lwo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Abea gihn maa abeehr Jeacuue tooro maa acwaahng Pilaato yi kwaad man bahnge Jeacuu ree be konye ke dhee. ");
INSERT INTO lwo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ke nying wong yi Yaan Amono e Pilaato kwaad maabuuj me daahd paaje kejea ke lonyo, e ngo lonye ke oogo yi thijin. ");
INSERT INTO lwo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ngaa me cuohn ne Barabaj ngo anaa yi thijin keehd yaae naa apaahr oogo ne liny kaa akuum Roama. Nyoge ge anaa anahg gene yi gihn apaahr gene oogo ni. ");
INSERT INTO lwo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Gihn nu e nyoge me thoohdh ge awaahd bang Pilaate ne peehny ngo ulonye dhaano yihr gen wa kwaad ka ne yuge ngo ke nying wong yi Yaan Amono. ");
INSERT INTO lwo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Maa apeehny Pilaate gen kea, “Wu daahd ngo ulonya Jeacuu ge ruohdhu?” ");
INSERT INTO lwo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bang gihn ngo abeehn Pilaate ne ngeyo kejea beehda ke nying giih tiel now e naa amag jo doong yaa lame Jeacuu ne kahl nyum lug. ");
INSERT INTO lwo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Maa abeehn ruohdhe giih ni ucoam gene yihdh nyoge cang kejea nahge ke Barabaj e ne peehny gene yihr Muudiihr Pilaato beere luny oogo yihr gen abea padh Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Batiene e Pilaato ake peehyo keehdo kea, “Abea nea wa maano, yuga gihn keehd Jeacuu ge cuohnu ne ruohdhu ne?” ");
INSERT INTO lwo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","E nyoge cang ge ke athubo ke kwaago kob gene, “Gure rih yaadh.” ");
INSERT INTO lwo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Maa apeehy Pilaato kea, “Abea gihn noono raaj ge awuohye ni?” E ge abar maalo ke kwaago kob gene, “Gure rih yaadh.” ");
INSERT INTO lwo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilaato cwihnye atooro bang urahny cwihny nyoge ree, noono maa ayiihe ngo wa kar dhog gen ulonye Barabaj. Naa athum acaakere ke puohd Jeacuu wa kaa arob Pilaate, e ngo acube yihr acaakere beere ngo caa ne gur rih yaadh maa ariihw. ");
INSERT INTO lwo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kaano e acaakere, Jeacuu abeehn gene ne kedh yi wod paar muudiihr ge cuohn ne Preetoarya. Noono ucuohn gene acaakere giih anudo cang. ");
INSERT INTO lwo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Maa angaab gene ngo ke jalaabya me kwaar kedea uyoad gene koadhe udol gene gen naa atahny ruohdh maa acub gene ngo wiihe ");
INSERT INTO lwo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","kedea uthub gene ke yaahle e ge ukoohbo kejea, “Maahdh ya Ruohdh yaa Judea.” ");
INSERT INTO lwo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Utwang gene wiih ngo twango keehd theengo kedea ge nguud yi wonge maa urung gene cong gen ke piny nyum ngo wa ge wuor ruohdh. ");
INSERT INTO lwo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Naa athum gene ke ngier kuohme e jalaabya akahl gene oogo ree kedea uduog gene waaye ree, batiene e ge a'aay keehde ne kedh ne gur rih yaadh maa ariihw. ");
INSERT INTO lwo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cimoane ngad piny Ciriihna anaa ake kahnho ke kaano e beehn kaa yi yoohn puohdho. Ngo anahg wur ge Alekjander maa Rupuj. Gihn nu e acaakere Cimoane amag gene ne bien yaadh gihn ugur Jeacuu ngahye naa agoohg Jeacuue ke tihng yaadh. ");
INSERT INTO lwo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jeacuu abeehn ne kedh ka me nahg nyoge me reje yea me cuohn ne Golgotha lum yea, “Paan Wiihj.” ");
INSERT INTO lwo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Batiene e ge athubo ke cub koongo maa alyaahb keehd yaadh me cuohn ne mer kejea maadhe ngo ne nahg raahm maa akweere ke maadh ngo. ");
INSERT INTO lwo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kaano e ge apiih ne gur Jeacuu ngahy yaadh maa ariihw kedea upaahng gene waare giihe ke rog gen ke dhe yoohn thalo. ");
INSERT INTO lwo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jeacuu agur ngahy yaadh ke nyango ka ne lony diehg. ");
INSERT INTO lwo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Maa agweed gene awuohj gihn apar gene kejea ngo ayug Jeacuue rih yaadh maalo naa, “RUOHDH YAA JUDEA.” ");
INSERT INTO lwo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Maa uyoad gene yaa kahw ariow ugur gene gen ngahdh yen wa kwaad mar Jeacuu ngaa man nuu ukwiihye kedea ngaa man nuu ucaame.  ");
INSERT INTO lwo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","E naa kaa abeehn gihn agweed yi kitaab Juog ke nying Jeacuu upahdhe kare ge anaa agweede naa, “Anahg wa kwaad ka nahg ngaa me ree naa awuohj.” ");
INSERT INTO lwo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Batiene e kwaad yaa ngul piny now e ngo cwiid gene cwiido e wudh gen gihny gene gihnyo kedea e ge uyahdo kob gene, “Yih nyin ne koohbo kejea Wod Juog thuohmi ke piny kedea uromi ngo ke geero ucuunge batien nihn adahg, kea noono kony rih, ");
INSERT INTO lwo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","uyihnhi piny ke rih yaadh ariihw.” ");
INSERT INTO lwo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Thiow Ruohdh yaa lam kedea yaa loohng Juog ge apiih ne yaahl ngo maa arub gene ke kiin gen kob gene, “Na ukoohbo kejea e ngad kony nyoge! Abea gihn e bahnge ree be rome ke konyo? ");
INSERT INTO lwo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ngahda e naa ruohdh yaa Yijarael! Kea noono yihnhe piny ngahy yaadh nu agure ree beere lume yiih wane yiiho.” Thiow keehd yaa anaa agur maalo buude ngo ayaahl gene tiehd. ");
INSERT INTO lwo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kaano maa abeehn deeh muudho umoale piny cang ne cihdh cihdhi. Naa athube e cahng nii diehr wihj uwahdhe kaa alaahnge e gihn me neehn tooro. ");
INSERT INTO lwo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yi laahng cahng e Jeacuu ake yuog e duone atihnge maalo, “Eloo! Eloo lama cabajthaahni?” Lum yea: Juog Ruohdh, Juog Ruohdh, gihn ge paahli an oogo wa gihn? ");
INSERT INTO lwo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","E yaa anaa ake cuungo duon Jeacuu alihng gene uthub gene ke rob kob gene, “Cegu yihdhu! Adoohng wa cuohn Eliija ge anahg agamloohngjuog naa acoon beere beehn ne kony ngo.” ");
INSERT INTO lwo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","E dhaano acielo kiin yaa ni ake goohdo ne kahl koongo me waj. Maa akaabe bur waaro ucode ngo yi koongo maa atuohje ngo wiih theengo urwaage ngo yi dhe Jeacuu ne maadho e ukoohbo kea, “Maanyo ngo! Ka moogo e Eliija ubeehn ne kahl ngo oogo ngahy yaadh.” ");
INSERT INTO lwo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Gihn nu e Jeacuu acahg lalo kedea e naa thone noono. ");
INSERT INTO lwo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kaano e waaro gihn anaa apaahng kur Dhe Wod ke kur Dhe Tiel yi Wod Juog yea ayiej ree piny ne dahg naa ariow ke maalo uwahdhe piny. ");
INSERT INTO lwo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ge aniid jaabidhe gihn anaa ake kuro kaa athow Jeacuue kii ngo ni, e ake rubo kea, “Beehda adiehr, nyin anahg Waahd Juog ne cohg.” ");
INSERT INTO lwo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Maahn mooge thiow ge anaa anudo ka me cahng e ge maahnyo kaa ka me baahr. Maahn maa a'aay Gaalili keehd Jeacuu ne beehn Jeruucalem. Ge ne tiihy giih daahd Jeacuue kedea jo waahdhe. Maarya Madaleana kedea Caloame maa Maarya miih Jeamij, Jeamij gihn thiin kedea Joacej ge anaa anudo keew maahn nu. ");
INSERT INTO lwo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Anahg cahng gwiihdo bang gihn ruuwow beehda Cahng Cabadh e bahnge nyoge be tiihyo yea. ");
INSERT INTO lwo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ngaa me nyinge Jocebe anudo, ngad geen Arihmathea kedea ngo anahg ngaa me duohng kiin yaa akuud gihr yaa Judea. Jocebe anahg ngaa maa ayiih ngo ke coon kejea Jeacuu Juog e naa aoohr ngo ne Ngad Boadh nyoge gihn koar kejea ngo ubeehn. Naa aniid Jocebe ngo kejea adoohng ka me thub cahng Cabadhe e cwihnye adeede maa acea paar Pilaato beere kuohm Jeacuu ke cub yihre ne koanyo e piny poohd kuu ayuudho. ");
INSERT INTO lwo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Maa abeehn Pilaate ucwaahnge ke kaa aguo Jeacuue thoo kii ngo maa acuohne jaabidh gihn anaa ne koar kedea upeehnye ngo nea ngo beehda adiehr, kejea Jeacuu aguo thoo. ");
INSERT INTO lwo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ge arob jaabidhe ngo yihre kejea ngo beehda athiir, e kuohm Jeacuu abeehne ne cubo yihr Jocebe. ");
INSERT INTO lwo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Maa abeehn Jocebe, ungeewe waaro, gihn me bahye kuohm Jeacuu keehde maa akahle kuohme oogo ngahy yaadh anaa agure yea. Ubahje kuohm ngo ke waaro kedea ucea ne kan ngo yi buur maa akoany coon ne liel batiene e deeh leelo aloohre dhe wod. ");
INSERT INTO lwo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","E maahn kar ge ariow kaa akan kuohm Jeacuu yi ngo abeehn gene ne niido. Maahn ni ge anahg Maarya miih Joacej kedea Maarya Madaleana. ");
INSERT INTO lwo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Naa ayuudh cahng ubar Cahng Cabadhe, e bahnge nyoge be tiihyo yea, e Caloame maa Maarya ge miih Jeamij maa Maarya Madaleana ge acidho ne ngeew mow me ngwaahy me ci gene ne wiihr kuohm Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ruuwow e ge amool oogo e piny kuu aruu ne ci wiih liel. ");
INSERT INTO lwo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Noono caahdh gene e ge upeehyo ke rog gen ke ngaa uloor deeh leen acub dhe wod liel oogo yihr gen. ");
INSERT INTO lwo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Abea ge amaahny gene, e ge niid dhe liel ngo apuogo kedea leelo tooro dhee. ");
INSERT INTO lwo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","E amon gene yi liel, e ge niid wuohnjuog e ngo apiih kur kwiihj. Ngo angaab waare me bahye me tar ne weej. Ge aniid maahne wuohnjuog e ge anahg lwahre kwaade tooro. ");
INSERT INTO lwo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Maa arub wuohnjuoge yihr gen kea, “Wu keá tud! Ngahya kejea wu daahd Jeacuu ge anaa agur ngahy yaadh maa ariihw. Jeacuu ngo tooro kan bang gihn ngo ameehg Juoge cahro. Maanyu kaa anaa apiehle yea. ");
INSERT INTO lwo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Abea cidhu ne robe yihr jo waahdhe maa yihr Piihter kejea Jeacuu amoono nyum gen wong maalo ne ci Gaalili. Nea neehn maano e kea cidh gene kun ca ne roohm keehde neehn kaa anaa arobe ngo e poohd kuow.” ");
INSERT INTO lwo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kaano e maahn arihng oogo kedea ugoohd gene oogo kar loohro bang gihn wudh gen ariihr yi kwaad gihn ayug ree. Noono utud gene ke rob gihn ayug ree yihr kwaad dhaano now ke nying lwahr naa amag gen.  ");
INSERT INTO lwo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Naa acahr Jeacuue yi thoo cahng anaa abeehn maahne uyoad gene loohro apuogo e cahng nu ree anaa abeehne ne nyoadho yihr Maarya Madaleana. Maarya gihn anaa arieme atiihbe abiihjberiow oogo rih ngo coon e Jeacuu poohd kuu anahg. ");
INSERT INTO lwo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Batiene e dhaar ni abeehn ne ci bang yaa anahg gom Jeacuu kedea jo waahdh giihe ge acong wudh gen ka maa acielo ne yuog thone. ");
INSERT INTO lwo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Abea ge alihng gene ngo kejea Jeacuu acahr kedea ngo aniid Maarya Madaleana, e ngo kuu ayiih gene. ");
INSERT INTO lwo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Batien kaano e Jeacuu ree acahge ke nyoadho yihr jo waahdhe ariow maano e ge caa yihdh miehr. ");
INSERT INTO lwo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ge a'aay Jeacuue e naa kaa angey gene ngo kejea ngaan ake rubo keehd gen anahg Jeacuu. Noono udoog gene kuu utien gen ne ci ne rob ngo yihr yaa gen kejea Jeacuu aniid gene. Abea lum gen kuu ayiih naa athiir. ");
INSERT INTO lwo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Batiene arumo e ree abeehne ne nyoadho yihr joe ge apaar wonge acielo, maano e ge piih ne cam. Maa ataahnye yi nying gen, bang gihn kuu ayiih gene naa arobe kejea ngo acahr ke batien thoo. ");
INSERT INTO lwo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Maa arube yihr gen kea, “Cidhu ke bang wiih piny kedea upuohnyu Ciig Beer gihn ni yihr nyoge cang. ");
INSERT INTO lwo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kwaad ngaa yiih luma kedea umuoj wiihe ke piih Juog e ngaan nu wahye uboadh Juoge. Abea ngaan be yiih luma, ngaan nu wahye buu uboadh Juoge. ");
INSERT INTO lwo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yaa uyiih luma ge umuoj Juoge ke tee me tiihy gene giih me be rom dhaan utaahnge ke tiihyo ke teege e keede. Thiow ge umeehge riem atiihb ukeehg oogo rog nyoge kedea ge umeehge rob ke dhog maa anaa akwihy gene. ");
INSERT INTO lwo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Yaa ayiih luma, nea ge akaj thuohle wale ge adwaahng ke cim e gihn muu yoad gen me nahg gen ngo utooro. Nea ge ukwahyo yihr Juog ke nying ngaa maa atwaany e cing acub wiihe e ngaan nu atwaanye uaay.” ");
INSERT INTO lwo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Batien kaa arub Jeacuu Ruohdhe keehd gen, e ngo atihng Juoge ke maalo ne ci ne beehdo yi ruohdh Paare kedea upiihe wiih koom ruohdh ukwiihy Juog. ");
INSERT INTO lwo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Joe ge athubo ke keedho ke bang wiih piny e ge puohny Ciig Beer yihr nyoge kedea e ge kony teeg Juoge konyo kedea unyoadhe tiihye naa adiehr ke dhe yoohn ameehge gen yug giih me gaahy nyoge.");
INSERT INTO lwo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yihr Thiopiihluj. Nyoge me thoohdh ge agweehdo ke nying giih anaa ayug rog gen kiin wan kan. ");
INSERT INTO lwo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Giih agweed gene, ge naa giih anaa arob kwaad yaa anaa nyum wane naa aniid gen ke nying gen kedea gen naa yaa anaa acub piny ne yaa puohny Ciig Beer. ");
INSERT INTO lwo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","E an awaahn ni yih ngaan duohng, wa kwaad kaa aboara gen ne cohg, ungahya kwaad giih ne yihdh gen ke dhe yoohn kaa anaa athub giih ni kedea kaa ayug gene rog gen e wiiha abeehna ne paro kejea moogo e ngo beehda gihn me beer ugweeda gen piny neehn kaa atiihy gene rog gen. ");
INSERT INTO lwo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ngo apara wa maano ugweeda gen piny yihri, beere ather giih yihdh gen ngahyi ngahyo neehn kaa apuohny gen yihri. ");
INSERT INTO lwo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Athubo ke wa gihn, umodho maano e Jeacuu poohd kuu anyuol, ngad lam giih kweehr anaa anudo me nyinge Jakarya. Yihdh nihn nu e ruohdh me nyinge Eroade e naa amag Judea ke kare cang. Jakarya gihn ni anahg ngad goan dhe wod yaa lam giih kweehr ke kur mar Abihja. Abea Elijabedh anaa anahg ciih Jakarya. E thiow anahg ngad dhe wod yaa lam giih kweehr. ");
INSERT INTO lwo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ge noon ni ariow ni ge abeehdo kaa beehdo me beer ne cohg nyum Juog. Umag gene loohng Juog keter beer mee. ");
INSERT INTO lwo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Abea nyethiin maa anudo yihr gen atooro, bang gihn Elijabedh anaa agaahg kedea ge anaa agwag keraahyo. ");
INSERT INTO lwo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Cahng ni arumo e Jakarya anaa ne yug tiihye yi Wod Juog e ngo cub giih kweehr yi wod kwaj gihr Jeruucalem, bang gihn nihn nu anahg nihn tiihy giih dhe wod gihr ge Jakarya. ");
INSERT INTO lwo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Beehda en naa anaa akwany ne ngad cub giih kweehr wong cahng nu. Jakarya anaa akwany kaa dhe yoohn thoohr gaay wa ka yuge paar gen ne waang adung dung wiih abar mar adung dung. Abea ge athub Jakaryae keehd tiihye yi Wod Juog ");
INSERT INTO lwo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","nyoge anaa amahdo yi laaro gihr Wod Juog e ge kway Juog. ");
INSERT INTO lwo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kaano arumo e wuohnjuog anaa celang, ucuunge kur kwiihy abar gihr waang adung dung. ");
INSERT INTO lwo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Naa aniid Jakaryae ngo, e Jakarya apaahw oogo umag lwahre ngo kwaade tooro. ");
INSERT INTO lwo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Muudhe e wuohnjuog ake rubo yihre kea, “Yih keá tudo Jakarya! A akahl dhog me beer yihri! Kwaj gihri alihng Juoge cang kedea Elijabedh ciihi uyihdi keehd nyethiin unyuole yihri keehd nyethiin cuow abea nyinge ucagi ne Joon. ");
INSERT INTO lwo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nea anyuol arumo, e yihn maa ciihi kedea nyoge me thoohdh cwihnyu umihni keter. ");
INSERT INTO lwo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Thiow nyethiin ni unahg ngaa me duohng keter ke nying tiihye gihn agwiir Juoge yihre. Koongo buu ukuonge kaa belo kedea kuohme uyaahng Wahy Juoge ke ka thube e ngo poohd kii yea men. ");
INSERT INTO lwo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Unahg e nuu uduu thoohdh yaa Yijarael bang Juog ge beehda Ruohdh gen ni. ");
INSERT INTO lwo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kedea unahg en nuu umoon wong maalo nyum Ruohdh gihn ubeehn ni. Umoon keehd dhe yoohn teeg cwihny puohny mare, wa kwaad mar Eliija agamloohngjuog naa abeehno umodho. Unahg en nuu uweehg jo doonge nhyaar nyethen gen kedea uweehge yaa wudh gen teeg duog cwihny gen caahn ubeehd gene ne nyoge maa abiohgrwaal, beere rog gen gwiir gene gwiiro ne koar beehn Ruohdh.” ");
INSERT INTO lwo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Naa athum wuohnjuoge ke rob, e Jakarya wiih lum nu abeehre beehro kobe, “Gihn e ne meehg an yiih gihn arobi? Kea maany an do, kaa agwaga kii ngo maa ciiha thiow rune ge acidho!” ");
INSERT INTO lwo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maa abeehr wuohnjuoge ngo yihre kobe, “A naa ngaan cuung nyum Juog. Nyinga Gabriel. Wa ka niidi an awaahn ni, beehda Juog ke ngude e naa aoohr an bangi, ubeehna yihri keehd dhog gihn beer ni. ");
INSERT INTO lwo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Abea naa abahnge luma kii yiiho awaahn ni e kar rob utooro yihri, yih ubeehdo wa miing e dhii atuohj ree uwahdhe ka upahdh giih aroba yihri kar gen. E thiow roba robo yihri kejea kwaad giih aroba yihri ni, ge beehda giih muu udhiil rog gen ke yugo wa kar gen neehn kaano ateeda gen yihri nu.” ");
INSERT INTO lwo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Abea nye wong kaano ayug giih nu rog gen, e nyoge ge anaa yi laaro gihr Wod Juog e ge koar Jakarya. Gihn nu e nyoge anaa agaahy bang gihn agaal Jakaryae yi Wod Juog. ");
INSERT INTO lwo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Naa abeehne oogo, e kar rob maa arube keehd nyoge tooro, e ngo aguo kaa angeyo kejea gihn maa aniide nud yi Wod Juog. Naa atoor ka maa arube yihr nyoge e cinge now e naa atihnge maalo ne rob keehd gen. ");
INSERT INTO lwo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Naa abeehn nihn tiihj giihe yi Wod Juog ne thumo e ngo adoo paare. ");
INSERT INTO lwo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Abea yi dooe paajo e Elijabedh ciihe nyethiin ake ngeyo ree. Noono ubeede ke kar bahbe paajo keehd kar dwaahde abiihj. ");
INSERT INTO lwo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Muudhe e Elijabedh acaa ne rob ke cwihnye kobe, “Ngo ngahya awaahn ni ne cohg kejea Juog a kaa akonye ne! Deeh yaahr guohbo naa ne riha ke bang yea paajo ne dug akahl Juoge oogo yi guohba arumo yihdh nihn ni.” ");
INSERT INTO lwo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Batien dwahde abiihjbeciel arumo naa angej nyethiin rih Elijabedh, e Juog wuohnjuog me cuohn ne Gabriel aoohre geen Gaalili me nyinge Naajaread. ");
INSERT INTO lwo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dhog e naa akahle bang nyaan maa tongo maa anaa atuohj yihr nyin me nyinge Jocebe ne nyuomo. Jocebe gihn ni anahg ngad dhe wod gihr Deabid Ruohdh. Abea nyaan ngo nyinge anahg Maarya. ");
INSERT INTO lwo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Naa abeehn wuohnjuoge bang Maarya e ake rubo yihre kobe, “Maahdh rihi ya! Yih beehda ngaa maa adooj Juoge keter. Juog Ruohdh ke yihn.” ");
INSERT INTO lwo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Gihn nu e Maarya cwihnye ake daag ke nying luub nu kedea kwaad maahdho me wa gihn nu. ");
INSERT INTO lwo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Maa arob wuohnjuoge ngo yihre kejea, “Maarya yih keá tudo! Juog cwihnye amihno rihi keter. ");
INSERT INTO lwo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Awaahn ni yih uyajo unyuoli ke nyethiin cuow, ucagi nyinge ne Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ngo unahg ngaa me duohng keter kedea ngo ucuohn ne Waahd Juog. Uyug Juoge thiow ne ruohdh me duohng ne mag koom gihr dhaahr kway e nyinge Deabid ");
INSERT INTO lwo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ke nying run beehd, e nuu upiih ukoom kway e cuohn ne Jeakob umage joe. Abea ruohdhe noono padh ruohdh muu ugug ne weey weey.” ");
INSERT INTO lwo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Batiene arumo e Maarya ake rubo keehd wuohnjuog kobe, “Gihn nu ree uyuge kaa dhe yooh me ngihde e kihd dhecuow kwihya?” ");
INSERT INTO lwo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maa abeehr wuohnjuoge ngo kea, “Beehda Wahy Juog e nuu ubeehn rihi. Teeg Juog thiow ke ngude ubeehn wiihi, e naa gihn ucuohn nyethiin ne Waahd Juog ke nyinge noono. ");
INSERT INTO lwo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Keehd Elijabedh wadu ge ngahyi kejea beehda dhaago maa agaahg kedea agwag, ngo yaaj awaahn ni adhaahr yihre ne dwahde abiihjbeciel. ");
INSERT INTO lwo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bang gihn, gihn me goohg Juog beehde tooro.” ");
INSERT INTO lwo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Batiene arumo e ngo abeehr Maaryae beehro yihr wuohnjuog kobe, “Gihr nyinga beehde tooro. A beehda nye baahng Juog now. Yuge ree wa kaa arobi.” Kaano e wuohnjuoge ake aay. ");
INSERT INTO lwo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Batiene e Maarya ree alaare kaa agwiiro kaano, ucea ke geew paar Jakarya me nii piny goode yi Judea. ");
INSERT INTO lwo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Abea naa awahnhe paajo e Elijabedhe amaahdhe maahdho. ");
INSERT INTO lwo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Arumo naa alihng Elijabedhe duon Maarya ne ngio e nyethiin ake gweehyo keehd med cwihny. Kaano thiow e kuohm Elijabedh ake miehd naa ayaahng Wahy Juoge kuohme. ");
INSERT INTO lwo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Maa arube yihr Maarya e duone atihnge maalo kobe, “Naa! Yih ke wuoro keew maahn ne dug. Maa me wuor nyethiin gihn unyuoli ni. ");
INSERT INTO lwo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kaa nying gihn ge abeehn kwaad gihn me wa gihn uyuge ree yihra! Adhaahr miih ruohdha ke ngude, e ne abeehn ne liehw an ne? ");
INSERT INTO lwo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kaa alihnga yedh duoni naa amaahdhi an e nyethiin ake buo ne nihg ke med cwihny. ");
INSERT INTO lwo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mihn cwihny yihri, bang gihn ayiihi ngo kejea giih arob Juoge yihri ni ge ubeehn naa ather ne dug.” ");
INSERT INTO lwo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Noono arumo e Maarya ake wahr kobe, “Cwihnya beehde e moar wiih Juog ruohdh. ");
INSERT INTO lwo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Cwihnya med keter ke nying Juog e naa Ngaa Boadh an. ");
INSERT INTO lwo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bang gihn Juog wiihe kuu awul riha, ngaa maa nye baahng me gihr nyinge tooro. Thube ke nye kaa awaahn ni, uwahdhe cahng moogo nyoge cang ke bang upiny a ucuohn gene ne ngaa me yihre ne med cwihny, ");
INSERT INTO lwo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","bang kwaad giih teeg naa ayug Juog Aciehge yihra, Juog ge nyinge leej ka me laaj ni. ");
INSERT INTO lwo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Juog cwihnye aduue caahn bang nyoge me wuor en, ne thube ke rog jo umodho uwahdhe bang jo uluuny. ");
INSERT INTO lwo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Juog bade alwaaye piny ke maalo. Maa ayoade kwaad yaa nhyaam uwere ge piny. ");
INSERT INTO lwo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kwaad thoohn ruohdhe giih doong doong ni, ge akahl Juoge oogo wudh koome giih gen cang maa ayoade ke kwaad yaa gihr nying gen tooro ge naa atihnge maalo. ");
INSERT INTO lwo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Thiow maa ayoade kwaad yaa abang kahje, upaahnge yihdh gen keehd giih me beey. Abea kwaad yaa alony ge urieme ke cing gen now. ");
INSERT INTO lwo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Thiow Juog wiihe kuu abeehn ne wulo rog kwaad giih anaa acege piny yihr ge kuowo naa acoon. Noono ubeehn Juoge ukonye yaa Yijarael ge beehda baahng giihe. ");
INSERT INTO lwo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Juog wiihe kuu awul ne weey weey thiow, bang gihn med cwihny anyoadhe yihr Abraahm kedea yihr kwaay Abraahm cang ne raj wa kaa anaa ateede ngo yihr ge kuowo ni.” ");
INSERT INTO lwo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maa aceng Maaryae paar Elijabedh kaano keehd dwahde adahg batiene e adoo paar gen. ");
INSERT INTO lwo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Naa abeehn kar nyoohdo gihr Elijabedhe, e ngo ake nyuol keehd waahde. ");
INSERT INTO lwo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yaa wong akeew gihr gen maa nyoge maa waahd gen ngo alihng gene kejea Juog cwihnye aduue caahn rog gen. Umihn cwihny gene wa mar Elijabedh thiow. ");
INSERT INTO lwo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yi bedahg nihn, e peen nyethiin ake wedo uthoame thiow. Nyinge adaahd ke caa ke nying wahn Jakarya. ");
INSERT INTO lwo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Maa akweer Elijabedhe kobe, “Kare tooro ucag nyinge ne Jakarya wahn. Cag nyinge ne Joon.” ");
INSERT INTO lwo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","E nyoge ake rubo yihr Elijabedh kob gene, “Ngad tien paaru maa acag ke nying nu tooro.” ");
INSERT INTO lwo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Batiene e nyoge cing gen ayahng gene yahngo ke rob yihr wur nyethiin, upeehnye ke ka daahde ucag nying nyethiin kii ngo. ");
INSERT INTO lwo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kaano e ubango gihr gweed apeehny Jakaryae peehnyo maa agweehd Jakaryae yi ngo wa gihn, “Nyinge ke caa ne Joon.” Yaa wong akeew naa anaa abeehno cang, ge agaahy maa acwaahng gene kwaade tooro. ");
INSERT INTO lwo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Batiene arumo ke wong kaano e Jakarya leebe ree agoonye goonyo, uguoe ke rob maano e ngo puoj Juog. ");
INSERT INTO lwo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Keehdo yaa wong akeew, yihdh ge abeehn lwahre ne pogo maa atud gene ke nying gihn me wa gihn nu. Kwaad giih ni ayug rog gen ni, ge abeehn ne lihngo cang unyaay gene ke bang yihdh miehy ugood gihr Judea ne raj. ");
INSERT INTO lwo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kwaad yaa alihng giih ni, wudh ge acoar gene e ge peehny rog gen kob gene, “Nyethiin ni, unahg kwaad nyethiin me ngihde?” Maa aguo nyoge ngo ke ngeyo thiow kejea teeg Juog ne rih nyethiin gihn ni. ");
INSERT INTO lwo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Gihn nu e naa abeehn Jakaryae wur Joon naa apahng guobe keehd Wahy Juog umiehde maa arube ke kwaad giih adaahd Juoge ke robo kobe, ");
INSERT INTO lwo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Wuor Juog Ruohdh, Juog Yijarael! Juog abeehn ne kony joe ulunye gen oogo. ");
INSERT INTO lwo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Deeh ngad kony me duohng, me teeg keter, acub Juoge yihro adiehr muon kaa bang yaa dhe wod Deabid, ge anahg baahng Juog me ne cohg. ");
INSERT INTO lwo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Gihn nu ree ayuge wa kaa anaa arob Juoge ngo kuu umodho ke dhog yaa agamloohngjuog ");
INSERT INTO lwo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","E naa akoohb gene kejea, ‘Juog won nea konyo ubodho yi cing jo mahn giiho kedea yi cing yaa maan won.’ ");
INSERT INTO lwo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Anaa arob Juoge thiow kejea duu cwihny caahn nea nyoadho yihr ge kuowo naa acoon. E thiow akob Juoge kejea wiihe kuu awul ne par kwaad giih anaa amade keehd gen. ");
INSERT INTO lwo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Naa angweel Juoge ngo piny yihr kuowo Abraahm kejea ");
INSERT INTO lwo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","won nea lwahg oogo yi cing yaa maan won beere dhe yooh ne yoado utiihyo yihre e lwahr tooro rogo. ");
INSERT INTO lwo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kedea udoohngo ne nyoge maa abiohgrwaale nyume yihdh nihn kuowo giiho ne beehdo upiny kan. ");
INSERT INTO lwo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Abea yih nyethiina, yih ucuohn ne agamloohngjuog, Juog ge Duohng. Unahg yihn nuu umoon wong maalo nyum Ruohdh gihn ubeehn ni, ne gwiir yooh yihre beer mee. ");
INSERT INTO lwo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Unahg yihn nuu urob ngo yihr nyoge kejea ge ubodh kaa dhe yoohn ka ubeehn Juoge uwuunye anyoohne giih gen oogo yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Juog maro beehda Juog me cwihnye duue ke caahn. E thiow puol cwihny beehda gihre. Kar kuow me nyaahn me bodho kii ngo unyoadhe yihro umeenye won wa gihn na moohl cahnge. ");
INSERT INTO lwo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kwaad kar kuow gihn nu, une beehd wudh kwaad nyoge me beed yi muudho kedea umeeny wudh nyoge me beed yi tub thoo, thiow tieno ka caahdho kii ngo e nuu ucohg yooh yihro ne ci kar doohr.” ");
INSERT INTO lwo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Batiene arumo e nyethiin ake doongo e wahye beey mee kedea lum Juog ngahye. Muudhe e ngo acaa ne beehdo yi ukang dom, uwahdhe cahng agwiir Juoge ne nyoadh ree yihr yaa Yijarael. ");
INSERT INTO lwo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yihdh nihn nu, e Jaah Agojtiino, amor gihr gweed nying nyoge bang akweehn akahle ke oogo ke bang yi dhaahr Roama cang ke kare ne raj. ");
INSERT INTO lwo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Akweehn gihn ni anaa anahg akweehn mar umodho ge ayug e Kwiihrinoj e naa anahg muudiihr gihr Ciihrya. ");
INSERT INTO lwo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nyoge cang ge abeehn ne gweed nying gen piny, e kwaad dhaano caa yi geen mar paar gen. ");
INSERT INTO lwo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kaano e Jocebe ake aay geen Naajaread yi Gaalili, e caa geen Bedhlehm yi Judea ge anahg geen Deabid ni. Jocebe aci Bedhlehm bang gihn ngo beehda ngad dhe wod Deabid. ");
INSERT INTO lwo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ngo anaa aci Bedhlehm beere nying gen beehn ne gweed piny en maa Maarya, bang gihn Maarya anahg nyaakow maa atuohj yihre. Maarya a'aay Naajaread e yea adag keehd nyethiin. ");
INSERT INTO lwo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ge anahg gene Bedhlehm, e kar nyoohde anaa acahngo. ");
INSERT INTO lwo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kaano e Maarya ake nyuol ke kanye maa nyethiin cuow. Maa abahje ngo keehd waaro upiehle ngo yi kwaad adyaany gihn nyahm laahye yea ke lum ni. Ayuge wa gihn nu bang gihn kar piih anaa atooro yihr gen yi wod weehle geen Bedhlehm. ");
INSERT INTO lwo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Buud kaan ni anyuol Maaryae yea ni, jo kwaah mooge ge anaa anudo maa anaa ne kwaag laahy giih gen naa amaang gene maango nying bare. Nye kaano piny anahg dewaahr. ");
INSERT INTO lwo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","E wuohnjuog acielo abeehn bang gen. Yi beehne noono abeehne nu, e kaano ane jo kwaahe yea nu, ree ameenye meenyo ne dahr keehd daahr gihr Juog. Ubeehn lwahre umage jo kwaahe giih ni kwaade tooro. ");
INSERT INTO lwo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kaano e wuohnjuog ake rubo yihr gen kobe, “Wu keá tudo! A kahl dhog me beer yihru. Ngo beehda dhog muu ukahl med cwihny yihr nyoge ke bang wiih piny cang ne dug. ");
INSERT INTO lwo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ngad Boadh nyoge naa Ruohdh, ge ngad boadh wun ni, ngo anyuol tihn noon ni yi geen Deabid. ");
INSERT INTO lwo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Abea dhe yoohn ka ungey wune ngo e gen: nyepelaal uyoadu e ngo apiehl yi adyaany gihr nyam laahye ke lum yea kedea ngo abahj ke waaro.” ");
INSERT INTO lwo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ke yi reehg acielo ne ngio, wuohdjuog ge ake waahdo ne mor mor kii maalo umahd gene rog gen bang wuohnjuog gihn bang jo kwaah ni. Maa athub gene tiehd e ge wahr wahy puoj Juog kob gene, ");
INSERT INTO lwo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Puoj yihr Juog maalo kedea upiny kan Juog dhaahre acube yihr joe naa amihn cwihnye keehd gen.” ");
INSERT INTO lwo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Batiene naa abeehn wuohdjuog uaay gene udo gene maalo, e yaa kwaah ge adog ne rob ke rog gen kob gene, “Coa Bedhlehm ne maany giih ni ayug rog gen ni, naa arob Juoge ke dhe yoohn wuohdjuog yihro.” ");
INSERT INTO lwo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Uaay gene kaano ke laahdo, uyoad gene Maarya keehd Jocebe kedea nyethiin maano e ngo ne yaa adyaany gihn ni. ");
INSERT INTO lwo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Naa aniid jo kwaahe nyethiin arumo, e gihn anaa arob wuohnjuoge yihr gen ke nying nyethiin, abeehn gene ke ne robo yihr nyoge cang. ");
INSERT INTO lwo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","E nyoge cang naa alihng gene giih nu e ge ake cwaahng kwaade tooro. ");
INSERT INTO lwo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","E Maarya giih ni ayug rog gen ni, ge abeehne ne maa ke wiihe ke kwaan gen cang. Noono ucoare wiihe rog gen kedea upahre keraahyo ke cwihnye. ");
INSERT INTO lwo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Maa abeehn jo kwaahe arumo udoog gene e ge uwahr e ge puoj Juog bang kwaad giih ayug rog gen ni kedea muu alihng gene, uniid gene gen thiow ke nying gen. E thiow, giih ni rog gen atiihy gene ne cohg wa kwaad kaa arob wuohnjuoge yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yi bedahg nihn, naa abeehn cahng thoame yea thiow, e nyinge ake caa ne Jeacuu, anahg nying anaa ateed wuohnjuoge, e poohd tooro yi yej. ");
INSERT INTO lwo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Naa athum dhe yoohn luog rog wa kwaad kaa anaa agweede piny yi loohng Juog ni, e Jocebe kedea Maarya nyethiin akaab gene ucidh gene geen Jeruucalem, beere ngo cub yi cing Juog. ");
INSERT INTO lwo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Gihn ni ayug ree wa kwaad kaa anaa agweede yi kitaab Juog kejea, “Kwaad kayo maa nyethiin cuow dhiil kaa kedh yi wod Juog, ucube yihr Juog.” ");
INSERT INTO lwo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Maarya ge keehd Jocebe ge abeehn geen Jeruucalem thiow beere ge beehn ne nahg kar akuy ariow wale amaame ariow me thene piny yi Wod Juog wa kwaad kaa ateed Loohng Juoge. ");
INSERT INTO lwo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nyin moogo anaa anudo yi Jeruucalem me nyinge anahg Cimon. Ngo anahg dhaano maa abiohgrwaal maa abeehdo e ree anaa agwaaye yihr Juog ke coon. Yihdh rune noono abeehdo e ngo koar ka ubeehn Juoge uoohre Kriihjto ne boadh yaa Yijarael. Thiow Wahy Juog anaa ree, ");
INSERT INTO lwo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","kedea anaa arob Wahy Juoge yihre kuu umodho kejea ngo buu uthow e Ngad Boadh nyoge keá niido. ");
INSERT INTO lwo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kaano e ngo abeehn Wahy Juoge ke ne kedh yi cwihny Cimone, ubeehne yi laaro gihr Wod Juog cahng ni. Anahg cahng nu ke ngude e naa abeehn Maaryae ge keehd Jocebe ukahl gene nyethiin beere kwaad giih anaa arob loohng Juoge, ge beehn gene ke ne tiihyo ke nying nyethiin. ");
INSERT INTO lwo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Muudhe, e Cimone nyethiin akaabe maa aboame ngo yi koohre ukwaye Juog e muohj koohr Juog kobe, ");
INSERT INTO lwo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Juog Ruohdha, me neehn kaa anaa ateedi ngo yihra kea noono wii cingi riha a ge beehda baahngi uthowa arumo. ");
INSERT INTO lwo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Bang gihn awaahn ni, dhe yoohn ka boadhi nyoge kii ngo aniida arumo ke wonga. ");
INSERT INTO lwo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Dhe yoohn nu ngo agwiiri ke nying thaahy cang, ke bang wiih piny ne dug. ");
INSERT INTO lwo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nyethiin gihn e nuu ubeehn ne meeny piny yihr thaay aduuno udoohng wudh yaa Yijaraele mor keehde uyahb wong lwaage ne dug.” ");
INSERT INTO lwo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Wur nyethiin kedea men ge abeehn ne gaahy ke nying giih arob Cimone ke nying nyethiin yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Batiene maa adooj Cimone gen urube thiow yihr Maarya kobe, “Nyethiin gihn, beehd e ngo akwahny Juoge oogo, beere thoohdh nyoge kiin yaa Yijarael ge urwaahny kaa nyinge kedea thoohdh mooge ge ubodh ke bange. Maa thiow nyethiin gihn, beehd e nuu unahg kihd gihn maa abeehno kaa bang Juog. Keehd maano dahng nyoge me thoohdh ge urubo ree keehd kwaad giih me reje. ");
INSERT INTO lwo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","E thiow giih roam gene ke cwihny gen, giih ngo rog gen unyoadh gene oogo uniid gen ne tang gay. Abea yih Maarya ke ngudi, kwaad raahm aduulo me teeg yih uyoade udoohnge wa aduuni akaw piny kaa pala.” ");
INSERT INTO lwo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nyekiihj me nyinge Ana anudo thiow maa anahg ngad agamloohngjuog thiow. Ngo anahg nyaar nyin me nyinge Panwel, ngad tien paar nyoge mooge me cuohn ne yaa Acer. Ngo anaa abeehdo keehd cuore ke kar run abiihjberiow cog kaa anyuom cuore ngo nyuomo. ");
INSERT INTO lwo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Batiene keehdo e cuore noono anaa aguo thoo maa adoohnge piny ne gulo uwahdhe kaa adoohng rune ne jiehangween wonge angween e ngo beed yi laaro gihr Wod Juog keede cog, e kway Juog ke bang decahngo keehd dewaahr. Mare anahg kway Juog kedea kweehr cam. ");
INSERT INTO lwo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Cahng ni abeehn Maaryae keehd Jocebe yi laaro gihr Wod Juog, dhaar ni anaa abeehno thiow. Noono maa amuohje koohr Juog kedea urube ke nying nyethiin yihr yaa anaa ne koar ka beehn Juoge ukahle dhe yoohn boadh wahy yihr yaa Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Naa athum Jocebe ge keehd Maarya ke yug giih daahd loohnge yihr gen, e ge adog geen Naajaread yi piny Gaalili. ");
INSERT INTO lwo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Maa abeehn nyethiine arumo udoonge e teeg mee kedea e nyepinye ge ngahye. Maa adooj Juoge ngo thiow keehd dooj me ne cohg. ");
INSERT INTO lwo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jocebe ge keehd Maarya ge na beehdo e ge caa geen Jeruucalem ke nying wong yi nihn Yaan Amono. ");
INSERT INTO lwo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Cahng Yaan Amono maan ni arumo, e Jeacuu rune ge apaar wonge ariow, e ge ake cidho Jeruucalem wa kwaad ka ne kwaay gene ngo ke yugo. ");
INSERT INTO lwo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Naa athum nihn Yaan Amono, e ge miih Jeacuu maa wahn ge adog paajo udoohnge ke Jeruucalem e kwihy gene. ");
INSERT INTO lwo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wudh gen anaa apar gene kejea moogo e ngo anaa ake caahdho ke yaaj mooge maa yaa akuud gen. Uthum bad decahngo acielo e Jeacuu kuu awahnh bang gen. Gihn nu e ge ake thubo ke daahd ngo keew nyoge maa wad keehd gen kedea keew gome giih gen. ");
INSERT INTO lwo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Naa abahnge ngo kuu ayoad gene, e ge adog Jeruucalem ne daahd ngo. ");
INSERT INTO lwo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yi dahg nihn arumo e naa ayoade gene ngo yi laaro gihr Wod Juog, e ngo apiih keew yaa puohny giih Judea. Anaa apiih now e lihng luub gen naa arob gene robo kedea ge apeehnye peehnyo keehd kwaad luube mooge. ");
INSERT INTO lwo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yaa alihng giihe naa arobe kedea kaa apeehye kii ngo, wale dhe yoohn kwaad kaa aduoge wudh luube kii ngo, ge agaahy. ");
INSERT INTO lwo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kaa ayoad Maaryae ngo ge keehd Jocebe e ge thiow ge acahg gaahy ne cohg. Maa arub Maaryae mene yihre, “Nye waahda gihn! Kwaad gihn noono ayugi rog wan nu? Maahny an kedea wuru kaa abuohj wane ke daahd yihn e wudh wan ane cohd kii ngo!” ");
INSERT INTO lwo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Maa abeehr Jeacuue ngo kea, “Gihn e naa anahgu rogu ke daahd an? Beehde kwihyu kejea an naa yihdh giih wura ne?” ");
INSERT INTO lwo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","E kwaad dhe yoohn ni abeehr Jeacuue ngo yihr gen yea ngo kuu adead gene beer mee ne cohg. ");
INSERT INTO lwo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Batiene, e Jeacuu ake aay keehd gen ubeehn gene Naajaread tiehd. Thiow maa acube wiihe ke ne lihng gihr gen cog. Noono e Maarya men kwaad giih ayug rog gen wudh gen amage mago kii cwihnye. ");
INSERT INTO lwo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Maa abar Jeacuue maalo keehd doohngo ke guohbe kedea ke ngahy luube thiow, e Juog kedea nyoge arumo cwihny gen ake mihno ree keter. ");
INSERT INTO lwo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yihdh nihn nu, e ngaa me nyinge Tiberio e naa anahg Jaah gihr Roama gihn duohng naa amag paajo keehd kar run apaar wonge abiihj. Yihdh run nu thiow e Poantya Pilaato anaa anahg muudiihr gihr muudiihrya mar Judea. Kedea Eroade e anaa anahg ruohdh naa amag Gaalili ke kare maa Pihlihb umen e naa amag Yiturea kedea piny Tracoanitij. E thiow Licanaj e naa amag piny Abilen. ");
INSERT INTO lwo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yi wong nu thiow e naa anahg Anaj kedea Kaaypaj jo doohng yaa lam. Yihdh run nu e naa abeehn Juoge unyoadhe luube yihr Joon waahd Jakarya, maano e Joon anaa yi ukang dom. ");
INSERT INTO lwo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Batiene arumo e Joon ake aay e kaahn yihdh miehy dhe naam Joohrdoan e puohny nyoge kejea maan gene anyoohne giih ayug gene kedea umuoj wudh gen ke luogwahy beere anyoohne giih gen wii piny yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Gihn nu apahdh kare wa kaa anaa agweede yi kitaab mar Yicaaya agamloohngjuog naa, “Nud ke duol me kwaag yi ukang, ‘Gwiiru yooh yihr Ruohdh, gwiir yooh me ne cohg cohg yihre. ");
INSERT INTO lwo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yoadu kwaad kuohn beehda aluungo ni, dhiilu yihdh gen ke paahngo une wudh gene yiiw yiiw. Maa kuohn thoohny ni, kedea kuohn beehda goode ni, laahyu wudh gen piny cang. E thiow dahng yoadu dhog yiehdhe giih ne ngool ngool ni, tienyu gen udoohng gene ne cad cad. E kwaad yiehdhe muu yihdh gen ne cony cony ni, ge dhiilu kaa puuyo udoohng gene nong mee. ");
INSERT INTO lwo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Lwaag cang ke bang upiny, dhe yoohn ka ubeehn Juog ne boadh nyoge kii ngo udhiil gene ke niido ke nying gen.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kaano arumo e naa abeehn amahr nyoge me thoohdh uwaahd gene oogo ubeehn gene bang Joon beere wudh gen ke muojo keehd luogwahy. Noono e Joon ake rubo keehd gen kobe, “Wu nyoge me reje me neehn thoohne maa wu beehda yaa waal. Gihn daahdu ngahj! Wu daahd ukoolu rahny cwihny Juog ge beehn ni, abea cwihnyu kuu arahnyo rog anyoohne giihu! ");
INSERT INTO lwo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","A teed lubo maa athiir yihru: thubu kaa awaahn kan ke tiihy giih me beeye beere ngo ke ngeyo rogu kejea anyoohne giihu ge alogu ngahdhu. Kaano e kare nud umuoja wudhu ke luogwahy. Yaage wudhu keá paru kejea ne nahgu nyethen Abraahm e Juog wu buu ukihme. Wu kihm Juoge kihmo keehd maa akwanye wun ne joe. Kare nud yihr Juog ukaabe wey leele giih ni uloge gen udoohng gene ne kwaay Abraahm. ");
INSERT INTO lwo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ukihm mar Juog muu uroomo wa ley maa apaage me ngod yen piny keehd biey gen agwiire ke nyingu. E kwaad yaadh gihn nyuol keehd nyethen me be cam dhiil kaa ngod piny cang uthoohre yi maaj ne waang.” ");
INSERT INTO lwo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Batiene arumo e nyoge Joon apeehny gene peehnyo kob gene, “Abea yug wane gihn arumo?” ");
INSERT INTO lwo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","E ngo abeehr Joone kobe, “Ngaa yihre ne waare ariow, dhiile acielo ke cubo yihr ngaa yihre tooro waahro. E ngaa yihre ne gihn me cam, nywaage cam nu keehd ngaa yihre tooro cam.” ");
INSERT INTO lwo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yaa gwaay cuol thiow, ge abeehn bang Joon beere wudh gen ke muojo keehd luogwahy. Maa apeehy gene kob gene, “Ngad puohny, yug wane gihn?” ");
INSERT INTO lwo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kob Joone yihr gen kea, “Jwaaru ajweehr gihn daahd akuume cog.” ");
INSERT INTO lwo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kaano thiow e acaakere mooge ge ake peehyo yihre kob gene, “Yug wane gihn?” Kob Joone kea, “Ngiihny nyoge keá peeju ke bad. Gihn maa toohd thiow, keá tahru piny yi kuohm dhaano ke dhieny. Rom dhaane kaa koohg mare cog ne kooge ke ngo.” ");
INSERT INTO lwo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Amahr nyoge me thoohdh thiow ge anaa ake kuro kejea Juog ka oohre Ngad Boadh nyoge yihr nyoge adoohng cahng. Gihn nu arumo e nyoge cang cwihny gen aroam gene roamo kejea ka moogo e buu unahg Joon e nuu unahg Ngad Boadh nyoge keree? ");
INSERT INTO lwo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Maa abeehr Joone ngo yihr gen cang, “Yaage luogwahy mara ge cuba yihru kan ni, beehda luogwahy mar piih now. Ngaa me teege akaal wiih teeg mara muu ulog beehno ke batiena nud. Ngaan nu e naa ngaan duohng riha, gihn me a be rom goony thool giih wuoy tiene. Wahy Juog ke ngude e nuu uwuoje wudh nyoge ne muoj gen ke luogwahy beere nyoge cwihny gen ungahmo kedea uteehng yiiho gihr gene wa ngiihnyo e thaahdh ke maaj. ");
INSERT INTO lwo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ataaj me wa gihr kuor beel nii cinge, noono e nyoge ge kuore kuoro wa beel ukedhe liil yi gala. Abea coang ge ucwinye keehd deeh maaj me waang e ngo be gug.” ");
INSERT INTO lwo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Joon nyoge anaa puohnye keehd Ciig Beer keehd dhog yiehdhe me thoohdh keter uwiide wiih lume piny yihr gen thiow kejea dhiil gene dhe yoohn kar kuowo mar gen ke waaro. ");
INSERT INTO lwo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Eroade, ge anahg maamuur, abeehn Joone ne cayo ke nying Eroadaj ciih umen, bang gihn ngo akedh Eroade wod ne dhaago yihre. Ngo acay Joone ke nying kwaad giih me reje mooge maa atiihye cang. ");
INSERT INTO lwo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Maa abeehn Eroade uyuge deeh awuohj moogo me duohng umage Joon udiile ngo wod yi karkoohn. ");
INSERT INTO lwo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nye kaano amuoj Joone wudh nyoge muojo, e Jeacuu wiihe ake muojo thiow keehd luogwahy. Abea nye kaa anaa apoohde e Jeacuu anaa ake kwahyo, e maalo yea ree ayabe yabo, ");
INSERT INTO lwo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ubeehn Wahy Juoge wa kihd akuur upiihe wiih Jeacuu. Kaano e duol ake lihngo kii maalo kobe, “Yih naa waahda maa anhyaara kedea cwihnya med rihi.” ");
INSERT INTO lwo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ge anaa athub Jeacuue ke tiihy mare ni, e rune ge anahg kar dhaano aduuno wonge apaar. Ngo anaa acuohn kejea ngo beehda waahd Jocebe now. Jocebe ge waahd Ehli ni. ");
INSERT INTO lwo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Abea wur Ehli anahg Mathahd. Mathahd wahn anahg Leabi, wur Leabi anahg Malagi. Malagi wahn anahg Janaa, e wur Janaa anahg Jocebe moogo. ");
INSERT INTO lwo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jocebe gihn anahg waahd Mathiiatyaj. Amoj ge anahg wur Mathiiatyaj. Wur Amoj anahg Nahum, e Nahum wahn anahg Ejli. Nagai wur Ejli. ");
INSERT INTO lwo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","E Nagai waahd Maadh. Maadh waahd Mathiiatyaj moogo, wur Mathiiatyaj gihn ni naa Cemean. Cemean wahn anahg Joceg. Joda wur Joceg. ");
INSERT INTO lwo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","E Joda wahn anahg Joanan. Rehja naa wur Joanan. Jerubaabel wur Rehja. Cealtiel wur Jerubaabel, e wur Cealtiel beehda Neari. ");
INSERT INTO lwo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neari waahd Malagi moogo keehdo. E Malagi gihn wahn beehda Adi. Adi waahd Kojam, e Kojam waahd Elmadam. Elmadam waahd Er. ");
INSERT INTO lwo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","E Jocwa moogo e naa wur Er. Eliejer wur Jocwa. Jorim wur Eliejer. Mathahd moogo keehdo e naa wur Jorim, e Leabi moogo e naa wur Mathahd gihn ni. ");
INSERT INTO lwo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leabi gihn wahn anahg Cimon. E Cimon wahn anahg Juuda. Juuda wahn anahg Jocebe moogo keehdo. Jonam e naa anahg wur Jocebe gihn ni. Elyakihm anahg wur Jonam. ");
INSERT INTO lwo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ubeehn Melea unahge wur Elyakihm. Melea keehdo wahn anahg Mena. Wur Mena Mathaadha moogo dahng. E Mathaadha gihn ni wahn anahg Nathan. Nathan wahn anahg Deabid Ruohdh. ");
INSERT INTO lwo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deabid wahn anahg Jeci. E Obed e naa anahg wur Jeci. Buoj wur Obed. Calmon wur Buoj. Naacohn wur Calmon. ");
INSERT INTO lwo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadaab wur Naacohn. Admin wur Aminadaab. Wur Aminadaab e naa Arini. Ejron wur Arini. Perej wur Ejron. Perej wahn Juuda moogo. ");
INSERT INTO lwo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juuda gihn wahn anahg Jeakob. Jeakob waahd Yijaag. Yijaag waahd Abraahm. Abraahm waahd Tearah. Tearah waahd Noohr. ");
INSERT INTO lwo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Wur Noohr e naa Cerug. E Cerug wahn anahg Rio. Peleg wur Rio. Peleg keehdo wahn anahg Eber. Wur Eber anahg Ceala. ");
INSERT INTO lwo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ngad batien Kaayn wur Ceala. Arpagjad wahn anahg ngad batien Kaayn. Ceam e naa wur Arpagjad. Nooh wur Ceam. Lamej wur Nooh. ");
INSERT INTO lwo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Methucala wur Lamej. Enog wur Methucala. Enog wahn anahg Jared. Maahlaalel wur Jared. Kaayn moogo e naa wur Maahlaalel. ");
INSERT INTO lwo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enoj e naa wur Keanan gihn ni. Cedh naa wur Enoj. Adam e naa wur Cedh. Abea Adam, e naa waahd Juog. ");
INSERT INTO lwo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kaano arumo maa aduu Jeacuue ke yoohn naam Joohrdoan kaa anaa amuoj Joone wiihe yi ngo keehd luogwahy. Ubeehn kuohm Jeacuu ne romo keehd Wahy Juog cang. Maa akaab Wahy Juoge ngo ukedhe ngo kar keede yi ukang, ");
INSERT INTO lwo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kaa atum atiihb ukeehge ngo ke nihn jiehariow. Gihn maa acame tooro yihdh nihn nu maa anahg kahje ngo batien nihn nu. ");
INSERT INTO lwo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Maa arob atiihb ukeehge ngo yihre kobe, “Nea yih beehda Waahd Juog ne cohg, kea log leen ni naa amono.” ");
INSERT INTO lwo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Maa abeehr Jeacuue ngo yihre kea, “Bekihde! Wa ngo agweed yi kitaab Juog naa, ‘Padh amono cog e ne bodh nyoge keehde.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Maa akaab atiihb ukeehge ngo ukedhe ngo maalo ka me baahr mee, unyoadhe kwaad giih nud upiny kan cang yihre ke kwaan gen ke nye wong kaano. ");
INSERT INTO lwo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Urube yihr Jeacuu kobe, “Yih uyuga ne ruohdh yihdh giih nu cang. Giih anyoadha yihri ge beehda giiha maa acub yihra. Caahn e beehda kar cwihnya ucuba gen yihr ngada me daahda me nhyaar cwihnya. ");
INSERT INTO lwo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Awaahn ni nea wiihi kuuli ke piny nyuma kan uwuori an e ge cuba cubo yihri cang.” ");
INSERT INTO lwo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Maa abeehr Jeacuue ngo yihre kea, “Wa ngo agweed yi kitaab Juog naa, ‘Nahge ke Juog keede e ne wuor kedea e ne gihre tiihj.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jeacuu akaab atiihb ukeehge ukedhe ngo geen Jeruucalem ucube ngo alidh Wod Juog. Maa arube yihre kobe, “Nea yih naa Waahd Juog ne cohg, kea thoohr rihi piny ke kan. ");
INSERT INTO lwo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bang gihn ngo agweed yi kitaab Juog naa, ‘Juog Wuohdjuog giihe, e koar yihn, ge uoohre bangi urihng gene ukoal gene yihn beer mee. ");
INSERT INTO lwo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Yih uboam gene uthaang gene yihn kii cing gen beer mee, utoor leelo me cwaany tieni.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Maa abeehr Jeacuue ngo yihre kea, “Wa ngo arob kitaab Juoge kea, ‘Juog e ge naa Juog Ruohdh, ngo keá tum now ke dhieny.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Naa athum atiihb ukeehge ke tum Jeacuu keehd dhog yiehdh ni thoohdh, e ngo awiie ne koar cahng moogo. ");
INSERT INTO lwo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Batien gihn nu, e Jeacuu adoo Gaalili, e teeg Wahy Juog ne ree keter. E dhog ke nying giih atiihye akeedho ke bang yi paajo, ubeehn nyinge uwiihje. ");
INSERT INTO lwo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jeacuu apuohnyo ke bang yihdh kuohn amaade giih yaa Judea maa apuoj nyoge ngo keraahyo. ");
INSERT INTO lwo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Keehdo e Jeacuu acahg aay ucea Naajaread kaa adoonge yea. Batiene yi cahng Cabadh man arumo, e ngo acaa yi wod amaad gihr yaa Judea wa kwaad ka ne kwaaye ngo ke tiihyo. Uyedhe wiih abar maalo ne kwaan kitaab Juog. ");
INSERT INTO lwo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Batiene e kitaab Juog gihn agweed Yicaaya agamloohngjuoge, ake cubo yihre. Maa alare kood warga arumo uyale kaa agweede yea kejea, ");
INSERT INTO lwo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wahy Juog Ruohdha abeehn wiiha ne niihm, bang gihn Juog a akwahnye oogo, beere Ciig Beer ni, kahla kahlo yihr nyoge maa angoohng. Juog thiow a akwahnye oogo, ubeehna ne luny jo amag oogo kedea thiow, a aoohre uyaba nying yaa acoor, uniid gene piny. A aoohr Juoge keehdo thiow, ulunya yaa guum bahng oogo. ");
INSERT INTO lwo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Juog a aoohre keehdo thiow, ne teede yihr nyoge kejea cahng boadh Juoge nyoge yea, adoohng cahng.” ");
INSERT INTO lwo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Noono e Jeacuu kood gihr wargahng kitaab Juog adole dolo, urwaage ngo yihr ngaan cuung buud ngad kwaahno. Ucea ne piih kur yaa puohny. Amahr yaa anaa anudo wod amaad nying ge atal ne many bang Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Noono maa acahge rob yihr gen kobe, “Tihn gihn agweed yi kitaab ni ngo apahdh kare.” ");
INSERT INTO lwo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Noono arumo e nyoge adog cwaahng ke nying luub beey ni naa arobe maa apeehy gene ke rog gen kob gene, “Ngahda beehda waahd Jocebe e gihn ne?” ");
INSERT INTO lwo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Maa arob Jeacuue ngo yihr gen kobe, “Ngo beehda gihn me ngahya ngo urobu yihra ke ucaale kejea, ‘Akiihm kuong rihi ke thiehdho umodho.’ Thiow urobu yihra kejea, ‘Tiihy kwaad giih anaa alihng wane e ge ke robo kejea ge ayugi Kaparnaam yi geen wan!’ ” ");
INSERT INTO lwo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ubar Jeacuue ke maalo ke rob kobe, “Ngahyu ngo jo wan kejea agamloohngjuog beehda ngaa me be kuong ke wuoro yi geen paar gen kaa anyuole yea. ");
INSERT INTO lwo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Teeda teedo yihru kejea yihdh nihn Eliija gule me thoohdh ge anaa anudo tien paar yaa Yijarael ge anaa abeehn kodhe ukweere ke cwii keehd kar run adahg ke nuuj ubeehn kahje me duohng upahdhe paajo. ");
INSERT INTO lwo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Abea keehd maano e Juog Eliija anaa aoohre ke bang gulo acielo maa anaa piny Ciihdoan yi geen Jarepadh. ");
INSERT INTO lwo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Thiow, nyoge mooge ge anaa anudo me rog gen anaa dhoobo yi piny Yijarael, yihdh nihn Elica agamloohngjuog. Abea wong dhaano acielo keew gen maa anaa athiehdhe atooro unahge ke dhoohb Nyaamaan, ngad Ciihrya e naa athiehdhe.” ");
INSERT INTO lwo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Naa alihng yaa anaa amahdo giih ni arob Jeacuue, e yihdh gen ake kuohd ke ngeenyo. ");
INSERT INTO lwo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Noono upaahr gene ke maalo upahdh gene ke rih Jeacuu, ujoob gene ngo joobo, ukedh gene ngo oogo yi diih buur geew, beere ngo kedh gene ke ne thoohr piny ke wiih alidh good. Good ageer geew wiihe. ");
INSERT INTO lwo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Abea Jeacuu ake kahnho ke kiin gen uaaye ke waahdhe. ");
INSERT INTO lwo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Naa a'aay Jeacuue, e ngo abeehn Kaparnaam, geew me nii piny Gaalili, kaa abeehne nyoge ne puohnyo yea yi cahng Cabadh. ");
INSERT INTO lwo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nyoge anaa agaahy cang bang gihn ngo apuohnyo wa ngaa me yihre ne teeo. ");
INSERT INTO lwo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Yi wod amaad gihn anaa apuohny Jeacuue nyoge yea ni, nyin moogo anaa anudo kaano me wiihe anaa atiihb ukeehg. Kaano, e nyin ni amaahr piny keehd lalo, e duone atihnge maalo, abea e ngo urubo kobe, ");
INSERT INTO lwo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Caay! Ngahda yih Jeacuu ngad Naajaread e gihn ne? Gihn keree e ne daahdi rog wan? Yih abeehn ne nahg wan ne? Kedea yih ngahya ne cohg! Yih naa waahd Juog naa aoohr Juoge.” ");
INSERT INTO lwo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Maa acuow Jeacuue ngo kea, “Lengi! E thiow beehn oogo yi kuohm nyin.” Noono e atiihb ukeehg nyin abaahle ke piny nyum nyoge kaano ubeehne ke oogo yi guohb ngo, abea gihn me raaj maa ayuge rih nyin tooro. ");
INSERT INTO lwo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nyoge ge atud kedea ucwaahng gene maa arub gene kob gene, “Beehda puohny me ngihde e gihn? Maahnyu kaa agoohd atiihb ukeehge oogo rog nyoge ge arube yihr gen keehd duol me teeg!” ");
INSERT INTO lwo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Gihn nu arumo e rob ke nying Jeacuu yi paajo amore ke bang yihdh miehy cang. ");
INSERT INTO lwo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Gihn nu e Jeacuu wod amaad gihn ni awiie ke piny ucea paar ge Cimoane. Miih ciih Cimoane anaa amag jwaahy me teeg maa arobe yihr Jeacuu kejea konye ngo. ");
INSERT INTO lwo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Noono e Jeacuu acaa wod bange, ucuunge buude, urube yihr jwaahy kobe, “Kaa aay ree keehdo!” Maa a'aay jwaahye oogo ree. Ubeehn dhaar ni uyedhe ke maalo piny piow piow uthube ke goong gen. ");
INSERT INTO lwo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ge adoohnge e cahng kwaar piny ni, e nyoge yaa rog gen ne kwaad atwaanye me thoohdh ge akahl gene bang Jeacuu. Naa acube cinge wiih ngaa atwaany e ngo athiehdhe thiehdho. ");
INSERT INTO lwo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nyoge me thoohdh thiow atiihb ukeehg abeehn oogo rog gen e ge uyuog kob gene, “Yih beehda Waahd Juog.” E Jeacuu dhog gen adume piny ucuowe gen kedea ge keá meehg rob bang gihn ngo ngahy gene kejea ngo beehda Ngad Boadh nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ke nyang coon e piny adoohng ne waany arumo, e Jeacuu a'aay oogo yi buur geew ucea kar keede. Nyoge ake thubo e ge daahd ngo, naa ayoad gene ngo arumo, e waahdhe adaahd gene kaa areehdho. ");
INSERT INTO lwo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Abea arob Jeacuue yihr gen kejea, “A dhiil cidho wudh geedhe mooge upuohnya Ciig Beer bang gihn e naa tiihy mara naa acub Juoge yihra ne beehn ne tiihyo.” ");
INSERT INTO lwo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Arumo maa abare maalo ke puohny ke bang yihdh wuud amaade giih piny Judea. ");
INSERT INTO lwo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Cahng man Jeacuu anaa ke cuungo dieng agan baaw gihr Geneajared maano e nyoge ge anaa doohng ne yong yong buude e ge lihng lum Juog bange. ");
INSERT INTO lwo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kaano, e naa aniide baabuure ariow maa amag piny dhe waadh abea ge anahg baabuure giih yaa maay me luog booy giih gen. ");
INSERT INTO lwo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Maa apaahre yi baabuur acielo. Baabuun ngo anahg gihr Cimoane. E Jeacuue ake rubo yihre kea, “Kiiw baabuur ka me thiin oogo dhe waadh.” Kaano e apiih upuohnye nyoge e nii baabuur. ");
INSERT INTO lwo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Naa athume ke puohny e arobe robo yihr Cimoane kea, “Kiiw baabuur yi diehr kud, uyoadi booy uthoohri gen yi baaw ne maay.” ");
INSERT INTO lwo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Gihn nu e ngo abeehn Cimoane ke ne beehro yihr Jeacuu kejea, “Ruohdh! Wa abuohj ke maay keraahyo ke bang dewaahr ke kare. Abea kihd wong reehyo acielo now maa amag wane tooro. Abea bang gihn nahge yihn e naa arob ngo wa maano e booy ge uthoohra yi kud.” ");
INSERT INTO lwo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Arumo maa athoohr gene booy maa amag gene amahr rej me thoohdh ne cohg, me booy apud gene ke ne yiey piny. ");
INSERT INTO lwo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Muudhe yaa gen mooge maa anaa ka me lied keehd gen, acuohn gene beere ge ubeehno ne kony gen. Maa apaahng gene baabuure giih ariow ni keehd rej upud baabuure ne diihr piny. ");
INSERT INTO lwo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Naa aniid Cimoane gihn ni arumo, e ngo apahdh wudh conge nyum Jeacuu urube yihre kobe, “Aay oogo buuda kan, Ruohdh! Bang gihn a beehda ngad adhemuohm now.” ");
INSERT INTO lwo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Cimoane keehd yaae naa adiehno ge abeehn ne cwaahng keter ke nying alwaa amahr rej giih amag ni. ");
INSERT INTO lwo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Keehd waahd Jebeade, Jeamij ge keehd Joon umen thiow, ge abeehn ne cwaahng. Ge noono ariow ge anahg yaa Cimoane tiehd. Batiene maa arob Jeacuue ngo yihr Cimoane kobe, “Cimoane gihn me tudi ke nyinge tooro! Ngahy ngo kejea ne thube ke wa awaahn ni, unahg nyoge ge naa giih udaahdi daahdo ukahli gen banga wa kwaad gihr rej ge amagi ni.” ");
INSERT INTO lwo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Batiene e baabuure giih gen ateehl gene ke oogo dhe agala uwii gene giih nyepinye piny cang, ubuodh gene batien Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Maano e Jeacuu anaa yi geew kiin geedhe e nyin me ree anaa dhoobo abeehno. Kaa aniid nyine Jeacuu niido e ree ariedhe ke piny thaahdh tien Jeacuu, uthube ke kwaj wonge e urubo yihre kejea, “Ruohdh nea cwihnyi ne bange kea yug kuohma kwel.” ");
INSERT INTO lwo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kaano e Jeacuu cinge arwaage bang ngo maa agweele nyin kedea urube kea, “Cwihnya ne bange! Beehn kuohmi doohnge kwel.” Nye wong kaano arumo e dhoobo ake aay ree. ");
INSERT INTO lwo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Maa arob Jeacuue ngo yihre kea, “Lihng gihn roba. Gihn ayug ree rihi awaahn ni kan ngo keá waay yihr ngaa moogo. Abea aay awaahn ni ne nyoadho rihi yihr ngad lam giih kweehr umaanye kuohmi. Nea kuohmi amaany, kea yug giih kweehr wa kaa anaa arob loohng Moaje ngo bang ne nyoadh ngo yihr nyoge kejea dhoobo tooro rihi.” ");
INSERT INTO lwo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Abea keehd maano, nying Jeacuu abeehn ne wiihj ubare. Noono e alwaa nyoge ake waahdo bange beere ge beehn ne lihng giihe ne robe kedea beere yaa rog gen naa atwaanye ge thiehdhe thiehdho. ");
INSERT INTO lwo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Abea Jeacuu ne kwaay aay ucea ke kar keede ne kway Juog yea. ");
INSERT INTO lwo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Cahng man, maano e Jeacuu anaa ke puohnyo e nyoge mooge kiin yaa Paarijea kedea yaa loohng, ge anaa apiih thiow ne lihng. Ge anaa abeehno ke wudh miehr mooge giih Gaalili cang kedea bang yi piny Judea maa ke bang yi geen Jeruucalem. Teeg Juog anaa rih Jeacuu ne cohg ne thiehdh amahr yaa atwaanye. ");
INSERT INTO lwo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kaano e nyoge mooge ake beehno e ge bien ngaa maa abab piny maa apiehle yi belo. Yaa ni cwihny ge anaa bange beere nyin kedh gene ke wod bang Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Abea naa atoor dhe yooh yihr gen me kedh gene nyin abab piny wod bang Jeacuu, ke nying thoohdh nyoge, e ge ayedh maalo ungaany gene wiih wod maa alwaay gene nyin piny yi wod ke belo gihre keew nyoge kedea ucub gene ngo ke nye kaa apiih Jeacuue yea. ");
INSERT INTO lwo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Naa aniid Jeacuue kaa ayiih gene kii ngo, e ake rubo kea, “Nyieh! Adhemuohme giihi ge awiia piny yihri.” ");
INSERT INTO lwo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Batien lum nu e yaa loohng kedea yaa Paarijea naa anudo kaano, ge ake thubo ke ngoan kii cwihny gen kob gene, “Beehda ngad gihn noono dhahl Juog wa maan ni? Dhaano utaahngo me rom anyoohne ke wii piny nud ne nea padh Juog keede?” ");
INSERT INTO lwo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Gihn nu angoan gene kii cwihny gen ke nying ngo aguo Jeacuue ke ngeyo maa apeehnye gen kobe, “Nye yaage! Gihn e ne ngoanu ke nyinge yaa aduunu? ");
INSERT INTO lwo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Maa aweehne e ne teeg ke tiihyo, ne rob ngo kejea, ‘Adhemuohme giihi ge awii piny yihri ne,’ wale ne rob ngo kejea, ‘Yedh maalo ucaahdhi!’ ");
INSERT INTO lwo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Awaahn ni, a ge adoohng ne dhaano utaahngo, a utiihyo ke gihr nyepiny kedea uniidu ngo, gihn me be rom ree tiihyo yihr dhaano utaahngo ne nyoadh ngo yihru kedea ungahyu ngo kejea yihra ne tee wiih ngoom me wiia adhemuohme giih nyoge piny.” Batiene urobe ngo yihr nyin abab piny arumo kejea, “Ateeda yihri, kaa yedh maalo ukaabi belo gihri uci paajo!” ");
INSERT INTO lwo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ke wong kaano, e nyin a'aj maalo nyum nyoge cang, ukaabe belo gihre uaaye ne kew e ngo puoj Juog. ");
INSERT INTO lwo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nyoge ge acwaahng maa apuoj gene Juog e ge urubo kob gene, “Wa kwaad giih me teeg ge aniido tihn ne cohg!” ");
INSERT INTO lwo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Batiene e Jeacuu anaa ake caahdho ke waahdhe maa ayoade ngad gwaay cuol me nyinge Leabi e ngo apiih ne gwaay cuol. Maa arob Jeacuue ngo yihre kea, “A daahd udoohngi ne ngad waahdha!” ");
INSERT INTO lwo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Maa ayedhe maalo, uwiie giihe ke kaano, uaay tiehd ke Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kaano e Leabi cam abeehne ke ne gwiiro paare ke nying Jeacuu. Nyoge me thoohdh maa yaa gwaay cuol kedea nyoge mooge maa now ge anudo kar cam. Noono maa apiih Jeacuue ne cam tiehd keehd yaa nu. ");
INSERT INTO lwo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Gihn nu e yaa Paarijea maa yaa loohng me ne kur Paarijea, jo waahdh Jeacuu apeehny gene peehnyo kob gene, “Ke nying gihn e ne cahmu kedea umahdhu keehd yaa gwaay cuol kedea nyoge maa awaadh paaje?” ");
INSERT INTO lwo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Maa abeehr Jeacuue ngo yihr gen kobe, “Padh yaa rog gen tooro atwaany ge ne daahd akiihm abea beehda nyoge me tuu, gen ne daahd akiihm. ");
INSERT INTO lwo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","A kuu abeehno kaa nying yaa koohbo kejea ge abiohgrwaale. A abeehno kaa nying yaa ayiih ngo kejea ge yaa adhemuohm uwii gene tiihy adhemuohme.” ");
INSERT INTO lwo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kaano maa akob gene ngo yihr Jeacuu, “Jo waahdh Joon ge beehde cam kweehr gene kweehro kedea ge ukwahyo. Thiow jo waahdh Paarijea ge utiihyo wa gihn nu abea jo waahdhi ge beehd kaa cam kedea ke maadh.” ");
INSERT INTO lwo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Maa abeehr Jeacuue ngo yihr gen kea, “Kare nud umeehg yaa acuohn athiehge yi nyuohme kweehr cam abea athiehg nud bang gen ne? ");
INSERT INTO lwo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Abea cahng ukaab athiehg oogo bang gen ubeehn. Yihdh nihn nu e nuu ukweehr gene cam.” ");
INSERT INTO lwo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Maa ateede ucaal ni yihr gen, “Kare tooro uyiej dhaane waaro me nyaahn udhahbe ngo rih jwaahd waaro maa ayiej. Nea ngo yug dhaane yugo wa gihn nu, e waahr nyaahn e naa araany kedea waaro gihn nyaahn ge be roohm keehd jwaahd waaro gihn acoon. ");
INSERT INTO lwo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Thiow kare tooro yihr dhaano uyoade koongo me poohd kuu ayaahnyo upege ngo yi keej maa acoon maa akuoj. Bang gihn nea koongo caa ne yaahnyo e yi keej gihn akuoj ucoohdo ubeehn koongo naa tudo uwoje piny cang. ");
INSERT INTO lwo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nea kare ne cohg, e koongo me poohd kuu ayaahnyo dhiil kaa peg yi keej me nyaahn! ");
INSERT INTO lwo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Dhaano maa amahdho ke koongo me keej be cahg yiiho ulyaahbe ngo ke koongo me waj keehdo, bang gihn me keej e ne med yi dhee.” ");
INSERT INTO lwo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Cahng ni arumo e Jeacuu ake caahdho e ngo cor yihdh puohdh maa apuur keehd beel. Cahng ngo anaa anahg cahng Cabadh. Noono e jo waahdh Jeacuu ge ake thubo ke jag cwed beel, udwihny gene gen dwihnyo ke cing gen e ge nyam gene ke maalo. ");
INSERT INTO lwo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Gihn nu yaa Paarijea mooge apeehyo kob gene, “Maany gihn tiihy jo waahdhi. Ge tiihy gihn maa acier loohng Moaje ke tiihyo cahng Cabadh?” ");
INSERT INTO lwo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Maa abeehr Jeacuue ngo yihr gen kejea, “Ka moogo e gihn anaa atiihy Deabid Ruohdhe naa anahg kahje en maa jo waahdhe anaa akwaanu? ");
INSERT INTO lwo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Deabid anaa abeehn ne ci yi wod Juog maa acame amune giih lam ne giih kweehr kedea ucube mooge yihr yaae ne camo. Kwaad gihn ayug Deabide ni, anahg gihn maa anaa amahn loohng paaje ke tiihyo yihr dhaano maa now me padh ngad lam giih kweehr.” ");
INSERT INTO lwo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Maa agooy Jeacuue wiih lume noono piny kejea, “A ge adoohng ne dhaano utaahngo a naa ruohdh acub loohng gihr Cabadh yi cinga.” ");
INSERT INTO lwo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Cahng Cabadh moogo keehdo, e Jeacuu acahg beehn kar amaad gihr yaa Judea maa apuohnye yi ngo. Ngaa moogo anaa anudo kaano thiow me cing kwiihye anaa abaahl. ");
INSERT INTO lwo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yaa Paarijea maa yaa loohng ge adaahd dhe yooh me luom gene Jeacuu. Noono maa apiih gene ne boar ngo beer mee. ");
INSERT INTO lwo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Abea gihn anaa yi cwihny gen ngo angahye maa arobe ngo yihr nyin cinge abaahl kobe, “Yedh maalo ucuungi nyum yaa ni kan cang.” Maa a'aj nyine maalo ucuunge. ");
INSERT INTO lwo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kaano e Jeacuu arubo yihr gen kea, “Yaage, a daahde upeehnya wun! Kwaad gihn me ngihde, e naa gihn rob loohnge yihro kejea tiihye yi cahng Cabadh, tiihy gihn me beer ne, wale tiihy gihn me raaj? Kony dhaano me nii thoo, wale paahle oogo yi thoo?” ");
INSERT INTO lwo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Maa amaahny Jeacuue bang nyoge, e maahny kun ke kun. Noono maa arube yihr nyin cinge abaahl arumo kea, “Nyieh! Riihy badi!” E nyin bade ariihye riihyo, ubeehn bade udoe kare ne rihb. ");
INSERT INTO lwo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Gihn nu e yihdh yaa ni ake kuohd keehd tiel kedea ngeenyo maa athub gene ke gweehg ke keew gen ke gihn urom gene ke yugo rih Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Cahng man yihdh nihn nu e Jeacuu acaa wiih good maalo ne ci ne kway Juog yea. Maa anahge dewaahr e ngo kway Juog. ");
INSERT INTO lwo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Naa aruu piny arumo, e Jeacuu jo waahdhe ge acuohne maa akwanye apaar wonge ariow oogo kiin gen kedea ucuohne gen ne jo oohr. ");
INSERT INTO lwo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yaa ngo ge anahg Cimoane ge acuohn ne Piihter kedea Andrya umen maa Jeamij ke Joon. Pihlihb ge keehd Bartholomeao. ");
INSERT INTO lwo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matheewo maa Thoamaj, Jeamij ge beehda waahd Alpaawo kedea Cimoan moogo. ");
INSERT INTO lwo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Kedea Juudo waahd Jeamij moogo thiow maa Juudo Yijkaariod ngaan anaa abeehn ne luom Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Naa abeehn Jeacuue piny ke wiih good keehd gen e acuungo ka maa alaahy ree piny. Thiow jo waahdhe me thoohdh ge anaa anudo kaano. Kedea amahr nyoge me thoohdh ge anaa awaahdo e ge beehn kaa bang yi Judea cang kedea ke bang yi geen Jeruucalem, e mooge ge abeehno ke bang dieng naam duohng gihr Taayr keehd Ciihdoan. ");
INSERT INTO lwo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jo ni ge abeehn bang Jeacuu beere ge beehn ne lihng luube e thiow beere atwaanye giih gen ge thiehdhe thiehdho. Yaa rog gen anaa atiihb ukeehg, ge athiehdh. ");
INSERT INTO lwo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nyoge cang ge adaahd ngo ke gweelo, bang gihn teeg me thiehdh nyoge abeehn oogo rih Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Gihn nu e Jeacuu amaahny bang jo waahdhe maa athube ke rob kobe, “Mihn cwihnyu, wu yaa nii ngoohngo bang gihn Dhaahr Juog beehda gihru. ");
INSERT INTO lwo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mihn cwihnyu, wu yaa abang kahje awaahn ni, bang gihn Juog gihn me beer ucube yihru. Mihn cwihnyu, wu yaa yuog awaahn ni, bang gihn unahg wun nuu ungeedhi. ");
INSERT INTO lwo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mihn cwihnyu, nea wu amaan nyoge maa ungol wun oogo kiin gen, uyeny gene wun, uraany gene nyingu ke nyinga a ge adoohng ne dhaano utaahngo. ");
INSERT INTO lwo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Cahng nu e kea mihn cwihnyu ne cohg kedea umielu thiow bang gihn akoohg nud yihru Paar Juog. Ngahyu ngo thiow kejea, kwaad giih nu reje yug gene rogu, ge naa dhe yoohn kwaad kaa anaa atiihy weehw gene kii ngo noono rog yaa agamloohngjuog. ");
INSERT INTO lwo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Abea nea maru, wu yaa alony ni, rob teeg ke nyingu jo wan. Gihn me ne wong maalo keehdo ke nyingu tooro, bang gihn wu anaa abeehdo upiny ka me ngej mee now. ");
INSERT INTO lwo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Abea wu yaa ayahng awaahn ni rob teeg keehd wun thiow jo wan! Wu ubang kahje kwaade tooro. E thiow wu kwaad yaa ngeedhi awaahn ni, rob uteeg rogu jo wan, lalo kedea kuumo ge nuu unahg kwaad giih uwul koohmu noono. ");
INSERT INTO lwo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Thiow rob teeg keehd wun, nea nyoge cang wu puoj gene puojo urub gene ke nyingu keehd kwaad giih me beey. Ngahyu ngo ne cohg kejea gen naa kwaad giih anaa atiihy weehw gene noono rog kwaad yaa padh nyoge maa yaa gamloohngjuog. ");
INSERT INTO lwo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Abea roba robo yihru wu yaa ayiih luma: Nhyaaru jo mahnu kedea tiihyu gihn me beer yihr jo maanu. ");
INSERT INTO lwo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yaa lam gihn me raaj rogu kwayu Juog udooje gen, kwayu Juog ke nying jo mahnu. ");
INSERT INTO lwo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nea yih dhoohng ngaa mooge dhoohngo yi thaahngi kun acielo, keá log kun moogo yihre. Nea dhaano athoohr gihri akaabe, e melaayo gihri keá mahni yihre. ");
INSERT INTO lwo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kwaad ngaa peehyo yihri keehd gihr nyepiny, e kea cub gihn ngo yihre. Nea dhaano gihn moogo akaabe yihri, e ngaan nu keá cahg ke peehnyo keehdo kejea duue gihn ngo yihri. ");
INSERT INTO lwo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kwaad gihn daahdu ke cwihnyu kejea yug nyoge mooge ngo yihru, tiihyu kwaad gihn nu thiow yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nea wu nhyaar kwaad yaa nhyaar wun cog, e beehda gihn e nuu uyoadu yea kaano? Keehd yaa adhemuohm ngahda ge nhyaar yaa nhyaar gen ne? ");
INSERT INTO lwo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nea wu yug giih beey yihr yaa yug gen yihru, e gihn e nuu uyoadi yea? Bang gihn keehd yaa adhemuohm e ge utiihyo wa gihn nu ");
INSERT INTO lwo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Abea nea amihdho cubu ke yihr yaa ngahyu keede kejea amihdhe giihu duu gene duuo yihru, e gihn e nuu uyoadu? Keehd yaa adhemuohm, amihdho cub gene cubo beere ngo ke duuo yihr gen thiow. ");
INSERT INTO lwo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Beehda gihn maa ne cohg, nhyaaru jo mahnu. E thiow tiihyu yihr gen keehd kwaad gihn me beer. Cubu amihdho yihr dhaano abea ngo keá gaahnu kejea ngo uduu yihru keehdo. Kwaad akoohg me duohng mee uyoadu kaa dhe yoohn nu. Keehd dhe yooh ni thiow e naa ka uyugu rogu udoohngu ne nyoge maa nyethen Juog Aciehg. Bang gihn Juog beer thiow keehd kwaad yaa cwihny gen tooro ni, ge beehda kwaad nyoge me reje ni. ");
INSERT INTO lwo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yugu ngeer yej bang nyoge mooge, bang gihn Juog Aciehg Wuru beehda ngad ngeer yej thiow. ");
INSERT INTO lwo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Lubo keá ngolu yi koohm nyoge mooge. E Juog thiow lubo buu ungole yi koohmu. Nyoge mooge ge keá kihmu, beere keehd Juog thiow gihn muu ukihme wun ke nyinge tooro. Wiiu luubo piny yihr nyoge mooge, beere keehd Juog thiow lubo wiie ke piny yihru. ");
INSERT INTO lwo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cubu kwaad gihn nud yihru me romu ke cubo, e keehd Juog thiow e wu umuoje ke kwaad gihn acubu ni. Wiihe uduu Juoge yihru keehd amahr mooge me doong keter. Kwaad wan anaa amuuyu keehde, kwaad wal gihn nu thiow e ne wiihe uduu yihru keehd dhe yoohn kaa amuuyu kii ngo.” ");
INSERT INTO lwo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kwaad ucaale mooge thiow ge arob Jeacuue ne caal yihdh kwaad giih apuohnye nyoge keehd gen. Maa arube arumo kobe, “Ngaa maa acuor ka me pieye ngaa moogo maa acuor wa en tooro. Nea ngo tume tumo, e gen ke kar ge ariow, ge dhiil pahdh yi buur. ");
INSERT INTO lwo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","E thiow ngaa puohny, kare tooro yihre uyoohme wiih ngaan puohny ngo. Abea nea ngaa apuohny giih puohny yihre ge athume, e kare nud uroome ke ngad puohny. ");
INSERT INTO lwo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Beehda ater gihn ge kobi nye weehlo gihn thiin apahdh yi wong wadu ni e ne niidi ukwihyi deeh mari ge nii wongi ni. ");
INSERT INTO lwo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Gihn e ne ngahmi ke nyinge adhaahr urubi yihr wadu noono kejea, ‘Nye umiiho! Beeh koda nye weehlo gihn apahdh yi wongi oogo, abea deeh mari nii wongi.’ Nye ngad waane! Kuong deeh mari ge duohng ke kahl oogo yi wongi batiene e mar wadu ge thiin niidi niido ukahli ngo oogo. ");
INSERT INTO lwo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Yaadh me beer be nyuol ke nyethen me be cam. E thiow kwaad yaadh nyuol nyethen me cam be nyuol ke nyethen me be cam. ");
INSERT INTO lwo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kwaad yaadh cang, beehde ngo ngey rog nyethene ne nyuole. Ka me beehn nyoge upon gene nyethen dhuuro wiih alwii nud ne? Wale nyethen akanyo wiih aduohng? ");
INSERT INTO lwo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kwaad ngaa yea apahng ke luube me beeye e luube me beeye ge ne beehn oogo yi yea. Abea ngaa yea apahng ke luube me reje, luube me reje ge ne beehn oogo yi yea. Bang gihn, gihn yaa aduun dhaano e naa gihn beehn oogo kii dhee. ");
INSERT INTO lwo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Beehda ke nying gihn e ne cuohnu an ne ruohdh, abea kwaad giih teeda yihru ge be lihngu, utiihyu keehd gen? ");
INSERT INTO lwo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kwaad dhaano me beehn banga, ulihnge kwaad gihra ne roba utiihye gihn ngo, kwaad ngaan nu, gihn uroma ngo ree unyoadha yihru. ");
INSERT INTO lwo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kwaad ngaan nu uroomo keehd ngaa me daahd geer keehd wod yihre. Umodho, thar wode e naa akuonge ke koanyo piny thuudh mee ne cohg, e ngo koanye ke ka maa kar roohj roohj leelo. Naa aci piny ne boar ubeehn aboare thar wod, e wod ake cuungo ne kihr kihr. Gihn maa ayug aboare tooro rih wod, bang gihn ngo ageer nyine ke wuohbo ka me teeg. ");
INSERT INTO lwo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Abea kwaad ngaan kweer ke lihng luma kedea ukweere thiow ke tiihy kwaad gihn roba kejea tiihye ngo ngaan nu ngo uroomo keehd ngaa maa ageer wode piny e thar wod keá koany piny. Naa aci aboare ne beehno e wod gihre noono anaa abuohb piny ke pahdho ke wong cahng abeehn aboare keehd kwaad deeh pahdho acielo me teeg.” ");
INSERT INTO lwo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Naa athum Jeacuue ke rob giih ni yihr nyoge cang arumo, e ngo abeehn Kaparnaam. ");
INSERT INTO lwo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kaano e jaabidh gihr Roama anudo me yihre anaa ubaahng acielo maa anahg ngad tiihj yihre maa anaa anhyaare keter. Ngo anaa amag atwaany me teege keter maa apude thoo keehd ngo. ");
INSERT INTO lwo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Naa alihng jaabidhe bang Jeacuu, e ukihj yaa Judea mooge ge aoohre ke bang Jeacuu ne kwaj wong ngo ubeehne paajo yihre ne thiehdh ubaahng gihn atwaany. ");
INSERT INTO lwo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Noono arumo e yaa anaa oohr ge abeehn bang Jeacuu maa akwaj gene wong Jeacuu kob gene, “Jaabidh gihn beehda ngaa me beer, nea kare nud e kea dhiil ngo ke konyo. ");
INSERT INTO lwo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Bang gihn yaa paaro ge nhyaare nhyaaro keter, e thiow wod amaad ageere ke nying wan.” ");
INSERT INTO lwo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Noono arumo e Jeacuu ake cidho keehd gen. Abea naa adoohnge cahng ke paajo e jaabidh gihn nyoge mooge maa gome ge acahge kaa oohro bang Jeacuu e ngo poohd kii yooh ne robe yihre kejea, “Ruohdh! Rihi kea laang ke beehn paara. A beehda ngaa uci paara. ");
INSERT INTO lwo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Keehd an thiow kar beehna tooro bangi. Rob lumi uaay atwaany ubaahng gihra. ");
INSERT INTO lwo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","A ge niidi kan a beehda ngaa me duohng nyum acaakere kedea nud ke nyoge me doonge nyuma. Nea maano e lum roba ngo dhiil gene kaa tiihyo. Nea a urubo kejea beehn dhaane e ngo ubeehno, aay dhaane e ngo uaay. Thiow nea a urubo yihr ubaahnga kejea tiihy gihn e gihn ngo tiihye tiihyo.” ");
INSERT INTO lwo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Naa alihng Jeacuue lum ni arob nyine, e ngo ake cwaahng ugaahye ne cohg. Arumo ulog Jeacuue wiihe ke bang amahr nyoge naa awaahdo ke batiene maa akoohbe kejea, “Jo wan! Athiir e ne teeda yihru. Kwaad yiiho me duohng me teeg wa gihr ngaan padh Ujudea kaa kuong ke yoado keew yaa Yijarael.” ");
INSERT INTO lwo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Batiene naa adoog yaa anaa aoohr jaabidhe ni, e ge yuud ngo e atwaany ubaahng adoohng beer. ");
INSERT INTO lwo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Batien ka me thiin kaano e Jeacuu acahg aay keehdo ubeehne geen Nean keehd jo waahdhe tiehd maa nyoge mooge me thoohdh ge anaa anudo thiow. ");
INSERT INTO lwo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nye wong kaano awahnh gene yi geew nu, e Jeacuu ake roohmo keehd nyoge me beehn oogo yi geew e ge kaahn nyedhoohg maa athow. Anahg waahd acielo me men beehda gulo. Amahr nyoge me thoohdh yi geew ge anudo ke dhaar ni. ");
INSERT INTO lwo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kaa aniid Jeacuu Ruohdhe dhaar ni e yea ake ngeero bange ne cohg maa arobe ngo yihr dhaar ni kobe, “Yih keá yuog, mag cwihnyi!” ");
INSERT INTO lwo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Batiene arumo e Jeacuu acaa bang ngaan athow ni umage gihn akaahne keehde maa acuung yaa abiehdo ne dihl. Maa arub Jeacuue kobe, “Ngaa maa rihj, akoba yihri kaa yedh maalo!” ");
INSERT INTO lwo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","E nyedhoohg gihn athow a'aj maalo, uthube ke rob maa acub Jeacuue ngo yihr men. ");
INSERT INTO lwo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Naa aniid nyoge gihn ayug ree, e lwahr me duohng apahdh rog gen urub gene kob gene, “Wa agamloohngjuog me duohng atuohl kiino! Beehda Juog e naa abeehn ne kony joe.” ");
INSERT INTO lwo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Gihn nu e gihn atiihy Jeacuue ake nyaay ke bang Judea ke kare cang uwahdhe miehy wong akeewo. ");
INSERT INTO lwo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jo waahdh Joon ngad luogwahy giih atiihy Jeacuue cang ge arob gene yihr ngo. Kaano e Joon nyoge ariow kiin yaae ge acuohne ke bange ");
INSERT INTO lwo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","uoohre gen bang Jeacuu Ruohdh ne peehny ngo, nea en naa ngaa akob kejea ngo ubeehn wale padh en beere ge bar maalo ke koar ngaa akob naa ngo ubeehn. ");
INSERT INTO lwo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Naa awahnh gene bang Jeacuu, e ge ake rubo yihre kob gene, “Joon ngad luogwahy e naa aoohr wan bangi kejea peehny wane yihn wale yihn naa ngaan anaa rob kejea ubeehn wale ngaa moogo nud me poohd koar?” ");
INSERT INTO lwo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Anahg nye wong kaan ni anaa abeehn yaa aoohr Joone ni, e naa athiehdh Jeacuue nyoge me thoohdh me yihr gen anaa atwaanye kedea atiihb ukeehg kedea nyoge maa acoor me thoohdh nying gen ayabe. ");
INSERT INTO lwo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Batiene arumo maa abeehr Jeacuue ngo yihr yaa aoohr kobe, “Doogu bang Joon, urubo gihn aniidu kedea gihn alihngu yihre. Nyoge maa acoor, nying gen ayahbo yaa adwaany piny ge ucaahdho yaa rog gen ne dhoob ge athiehdh uaay dhoobe oogo rog gen, nyoge maa amiing yihdh gen ayahbo ulihng gene, yaa athow ge acahr batien thoo kedea Ciig Beer ke puohnyo yihr yaa angoohng. ");
INSERT INTO lwo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Med cwihny me duohng yihr ngaa me cwihnye be diiw ke nyinga!” ");
INSERT INTO lwo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Naa a'aay yaa anaa aoohr Joone arumo, e Jeacuu alog rob yihr amahr nyoge ke nying Joon kobe, “Ge anaa cidhu yi ukang, wu anaa acaa ne maany gihn? Anahg ubeej me yahng yame yahngo? ");
INSERT INTO lwo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nea padh ubeej e beehda gihn e naa acidhu ne maanye? Ngo anahg dhaano maa angahbo ke waare me ngien gen teeg? Bekihde! Yaa ngaab waare me ngien gen teeg kedea ge beed yi mow, ge beed yihdh miehy ruohdhe. ");
INSERT INTO lwo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Abea wu anaa acidho ne maany ngaa me ngihde? Agamloohngjuog ne? Ayiih, ngo beehda agamloohngjuog. Ateed gihn maa athiir yihru. Joon duohng rih agamloohngjuog. ");
INSERT INTO lwo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bang gihn anahg en naa arub Juoge ke nyinge kedea ugweed gihn arob yi kitaab naa, ‘Maany! Ngad wuohna uoohra wong maalo nyumi ne gwiir yooh yihri.’ ");
INSERT INTO lwo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Teeda teedo yihru, kejea Joon beehda ngaa me ne wong maalo keter yihr kwaad dhaano utaahngo maa anyuol dhaage. Abea keehd maano e ngaa wiihe ne dhe caahn yi dhaahr Juog e ngaan nu wiihe ne maalo rih Joon.” ");
INSERT INTO lwo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Kaano arumo, e nyoge ke kar ge cang, keehd yaa gwaay cuol naa alihng gene luub Jeacuu e ngo ayiih gene kejea dhe yoohn anyoadh Juoge beehd athiir bang gihn ge anaa amuoj Joone ke luogwahy. ");
INSERT INTO lwo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Abea yaa Paarijea maa yaa apuohny keehd luub yi loohng, ge anaa akweer keehd dhe yoohn agwiir Juoge ke nying gen bang gihn wudh gen kuu anaa amuoj Joone keehd luogwahy.) ");
INSERT INTO lwo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Abea mar yaa upiny awaahn ni kwaad gihn noono e nuu roma gen ree? Ge room kaa gihn? ");
INSERT INTO lwo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Moogo e ge uroma ke rog nyethen me luohng luube ke rog gen kar tuuo kob gene, ‘Cing wan apam wane, beere cwihnyu umihno umielu maa akweeru kedea gumo agooj wane maa akweeru ke meehdo.’ ");
INSERT INTO lwo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kwaad giih nyethen ni ge ne yugu. Maanyu Joon naa abeehne ke puohnye e beehdo e ngaa me cam baahny kedea giih maadh wa kuong ge thihr yi wiihe. Bang gihn giih nu thihr yi wiihe, e ngo akobu kejea beehda atiihb reje ge naa amag ngo. ");
INSERT INTO lwo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A ge adoohng ne dhaano utaahngo, a abeehno ke puohny mara e keew caame maa kuong ge be kwanya maa akoohbu kejea a ngaa maa awaahdh yi cam kedea maadh koongo. Wu arubo thiow kejea gom maga kaa yaa gwaaj cuol kedea nyoge maa awaadh. ");
INSERT INTO lwo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Abea roba robo yihru kejea dhe yoohn adiehj tiihy Juoge keehde niid ke rog yaae ge tiihyo.” ");
INSERT INTO lwo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Gihn nu e ngad Paarijea acielo me nyinge Cimoane Jeacuu acuohne paare ne cam. Noono ubeehn Jeacuue paar nyin ni maa apiih gene ne cam. ");
INSERT INTO lwo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kaano e dhaago maa anudo yi geen ni me beehda ngad adhemuohm, alihnge kejea Jeacuu agoong paar ngad Paarijea. Maa akaabe udhoohmo me yea ne mow me ngwaahy. ");
INSERT INTO lwo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Batien kaa abeehne wod kaa anahg nyoge yea e acuungo buud Jeacuu thaahdh tiene, e ngo uyuog. Piih wonge ge ameehge lwaar wudh tien Jeacuu uwuunye tien Jeacuu ke yiehy wiihe uciime gen, batiene e moan ni ngwaahy awuoje wudh tien Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Naa aniid ngad Paarijea, gihn ayug dhaare rih Jeacuu, e ngo ake rubo ke cwihnye kobe, “Nea nyin ne nahg kwaad dhaano maa agamloohngjuog ne cohg, e dhaar ni agweel tiene nea ngeyo kejea beehda dhaago me beehda ngad adhemuohm!” ");
INSERT INTO lwo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Maa abeehr Jeacuue ngo kobe, “Cimoan! Ne gihra me daahda ke robo yihri!” Maa abeehr Cimoane ngo kea, “Ngad puohny, rob gihri.” ");
INSERT INTO lwo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","E Jeacuu ake thubo ke rob kobe, “Nyoge ariow ge anaa anudo maa akahbo kaa amihdho yihr dhaano acielo maa ngad cub amihdhe yihr nyoge. Dhaano acielo kiin yaa ni, anaa akaab kiihye abiihj naa amihdho keehd ngiihny denaar, e ngaan man anaa akaab jiehariow wonge apaar keede naa amihdho. ");
INSERT INTO lwo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Batiene arumo e kar coal ngiihny nyin agoohg yihr gen. Ubeehn ngad ngiihny arumo uwuunye nying gen oogo yi wargahng yaa akaab amihdhe beere ge be cahg gene ke coalo. Nea yihn e ngaa kiin gen, e nuu unhyaar ngad ngiihny gihn ni keter?” ");
INSERT INTO lwo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Maa abeehr Cimoane ngo kobe, “Nea mara e beehda ngaan awiie amihdho me duohng piny yihre, e nuu unhyaar ngo.” Kob Jeacuue yihre, “Ngo angahyi ke beehro ne cohg.” ");
INSERT INTO lwo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Batiene arumo e Jeacuu wiihe aloge ke bang dhaar anaa bang gen urube keehd Cimoane kobe, “Dhaar kan aniidi ne? Maahny kaa abeehna paajo yihri tihn, a kii goongo ke piih me luoga tiena. Abea tiena ge aluoge ke piih wonge kedea uwuunye gen ke yiehy wiihe. ");
INSERT INTO lwo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A kii naa aloro thiow, naa abeehna, umaahdhi an ke ciimo. Abea maany mar dhaar dhee keá cub piny ke deeh kaa atudo naa abeehna, e tiena ciime ciihmo. ");
INSERT INTO lwo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mow maa acubi yihra tooro, beere wiiha reya reyo keehde, abea maany dhaar, tiena ge areje kaa mow me ngwaahy. ");
INSERT INTO lwo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dhiila kaa arobo yihri ne cohg kejea anyoohne giihe naa atiihye ge awuuny oogo yihre bang gihn nhyaahro gihre duohng keter. Abea ngaan awii gihn me thiin piny yihre, yihre naa nye nhyaahro me thiin mee.” ");
INSERT INTO lwo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Batiene maa arub Jeacuue keehd dhaar ni kobe, “Adhemuohme giihi ge awuuny oogo cang.” ");
INSERT INTO lwo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Muudhe e yaa anaa anudo wod, ge ake rubo ke rog gen kob gene, “Beehda ngaa e gihn ge wuuny adhemuohme oogo ni?” ");
INSERT INTO lwo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Maa arob Jeacuue ngo yihr dhaar kea, “Cidhi ke yoohm rihi. Yiiho mari yih aboadhe.” ");
INSERT INTO lwo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Batien gihn ni arumo e Jeacuu acahg aay kaano, e cor yihdh geedhe kedea yihdh miehr e puohny Ciig Beer ge rubo ke nying Dhaahr Juog yihr nyoge. Jo oohr kar gen apaar wonge ariow ge anudo keehde ");
INSERT INTO lwo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","maa maahn mooge maa anaa athiehdh Jeacuue maa urieme atiihb ukeehg oogo rog gen. Maarya ge ngad geen Madaleana, me ree anaa atiihb ukeehge abiihjberiow maa ariem Jeacuue oogo ree ");
INSERT INTO lwo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","kedea Joana ciih Kuja e beehda wajiihr gihr Eroade ruohdh. Cuujaana maa maahn mooge me thoohdh thiow maa anaa akony Jeacuu keehd jo waahdhe. Ge akony maahn giih kaa dhe yoohn acub gene nyepinye yihr Jeacuu keehd jo waahdhe. ");
INSERT INTO lwo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kaano e amahr nyoge wudh gen acong gene kedea nyoge ake waahdo ke wudh geedhe beehde. Gihn nu e Jeacuu ucaale gihn arobe robo yihr gen kejea, ");
INSERT INTO lwo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Umodho coon nyin moogo koohdhe anaa akaabe ne ci yi puohdho ne puur. Abea naa ayore koohdhe e mooge ge apahdho thaahng yooh, unyon nyoge ge piny ke tien gen maa abeehn winye uted gene gen. ");
INSERT INTO lwo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Abea muu anaa apahdho kar leelo, naa atuuy gene e ge aguo waang bang gihn ngoom me thej atooro thaahdh gen. ");
INSERT INTO lwo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mooge ge apahdho yi piny dhyaay kedea moodho. Abea naa adoong gene e ge ake juul bang gihn ge ateel dhyaaye piny. ");
INSERT INTO lwo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Abea e koohdhe muu anaa apahdho ka me beer ne cohg, ge anaa acieg ke wuohbo beer mee, e beehlo acielo wiihe ne kar cwede me boab keter.” Maa agooy Jeacuue wiih ucaale gihre noon ni piny ke rob kobe, “Nea ngaa yihdhe nud me lihngo e kea lihnge.” ");
INSERT INTO lwo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Batiene e jo waahdh Jeacuu, Jeacuu apeehny gene peehnyo ke lum yea ucaale gihn ni ateede ni. ");
INSERT INTO lwo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","E ngo abeehr Jeacuue yihr gen kobe, “Ne ngej yihdh luub Dhaahr Juog beehda Juog e naa acub ngo yihru wu jo waahdha. Abea ngo rob yihr nyoge maa anow kaa ucaale, ‘beere ngaan maahnyo keew gen, e gihn me nea niido ne tooro, e ngaan ne lihngo ne ngio, e gihn me nea deado ne tooro.’ ");
INSERT INTO lwo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Gihn ne yea lum ucaale gihn aroba e gen. Koohdhe ge ne room keehd lum Juog. ");
INSERT INTO lwo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Koohdhe giih apahdh thaahng yooh, gen ne wa lum Juog yihr nyoge me lihng ngo, abea ge alihng gene ngo ni, e atiihb ukeehg ubeehno ukahle ngo oogo yi cwihny gen. Kaano arumo e kar yiih lum Juog ugahngo yihr gen utoor dhe yooh me boadh gene wahy gen. ");
INSERT INTO lwo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Koohdhe giih apahdho kar piny maa leelo ni, ge ne room keehd lum Juog yihr nyoge maa lihng ngo umodho keehd med cwihny nye wong kaano alihng gene ngo cog. Abea lum Juog kuu amono yi cwihny gen beer mee. Ayiih gene now nye wong kaano alihng gene ngo, abea naa aci kar guume ne beehno, e ge agoohd oogo ugweey gene lum Juog naa alihng gene piny. ");
INSERT INTO lwo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Koohdhe giih apahdho yi piny dhyaay kedea moodho gen ne wa lum Juog yihr nyoge maa alihng ngo ne cohg beer mee. Abea ke nying gihn dier gene keter ke nying giih lonyo ni kedea cwihny ge acub gene rog giih wuohbo keede ni, e thiow, bang gihn nu dier gene keter nu, e lum Juog adeey giih dier gene keehd gene ke maalo wa gihr moodho keehd beel. Muudhe e ka me tiihy lum Juoge yi cwihny gen keehd gihn me beer tooro. ");
INSERT INTO lwo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Abea koohdhe muu apahdh kar piny me beer ge wa lum Juog yihr nyoge me lihng ngo uyiih gene ngo ke cwihny gen beehde beer mee, udeehj gene cwihny gen yi ngo, uwahdhe ka beehn lum Juoge utiihye yi cwihny gen keehd giih me beey. ");
INSERT INTO lwo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Gahng Ke ngaa me ahb lama ne meeny piny ucahge ngo ke wum piny kaa adiido. Wale ukaabe ngo ucube ngo thar agreehm. Nea kare ne cohg, e maaj gihn ahb ni, dhiil kaa cub maalo wiih baaya beere piny meenye meenyo yihr yaa beehn wod. ");
INSERT INTO lwo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wa maano e kwaad gihn tiihj e ngo kan piny ni, gihn nu udhiil ke oohl oogo, ukahle ka me cang uniide ne gay. E thiow kwaad gihn me wiihe awum piny, wiihe dhiil kaa aal maalo uniide. ");
INSERT INTO lwo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Cubu wudhu piny beer mee ne cohg yaage keehd dhe yoohn ka lihngu nyepinye kii ngo. Ateeda wa maano bang gihn ngaa me yihre ne giih me beeye me thoohdh, giih nu ge udhiil Juoge ke jwaa ke mooge me thoohdh. Abea ngaan yihre tooro nyepiny, keehd gihn anaa yihre ngo udhiil ke twahr oogo yi cinge.” ");
INSERT INTO lwo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kaano e miih Jeacuu keehd ge wuud wahn ge abeehn ne maany ngo, abea kar cidh wod bang Jeacuu atooro yihr gen, bang gihn wod anaa apahng keehd nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","E ngaa moogo ake rubo yihr Jeacuu kobe, “Miihu kedea wuud wuru ge nii kala kan. Ge daahd yihn ke niido.” ");
INSERT INTO lwo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Maa abeehr Jeacuue ngo kobe, “Miiha kedea wuud wura ge naa kwaad yaa lihng lum Juog ubahnge yi ngo be dhahl gene.” ");
INSERT INTO lwo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Cahng man keehdo, e Jeacuu arubo yihr jo waahdhe kobe, “Beeh ngudo loo baaw kun caadi.” Noono maa aci gene yi baabuur uthub gene ke ngol baaw. ");
INSERT INTO lwo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Abea ge akiiw gene baabuur kiiwo, e Jeacuu wonge aguo niine kaa kwala unene. E yamo me teeg ree atihnge tihngo kwaade tooro umiide baabuur ke olo. Kaano e aniid gene e ge nii gihn me raaj ne cohg. ");
INSERT INTO lwo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Gihn nu maa agoohd gene bang Jeacuu utahng gene ngo, e ge urubo kob gene, “Ngad puohny, ngad puohny, wo umud!” Kaano e Jeacuu ayedh maalo maa acuowe yamo kedea athewo ke duol me teeg, batiene e yamo ake cuungo maa adog athewo piny unahg piny leng. ");
INSERT INTO lwo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Naa aleng yame, e Jeacuu wiihe aluue ke bang jo waahdhe urube yihr gen kobe, “Yaage! Ka yiiho maa ne cohg tooro yihru ne?” Gihn nu keehdo e jo waahdhe ge ake cwaahng keter umag lwahre gen thiow me keehne maa arub gene ke rog gene kob gene, “Beehda ngad gihn e gihn? Ngaan rubo keehd yamo kedea athewo ulihng gene gihre?” ");
INSERT INTO lwo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Keehdo e Jeacuu abar maalo keehd jo waahdhe maa angol gene baaw ubeehn gene piny cuohn ne Graaja loog baaw gihr Gaalili. ");
INSERT INTO lwo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kaa anyuohn Jeacuue tiene ke wiih agala ne ngio, e ge aroohmo piny keehd nyin moogo me ree anaa atiihb ukeehg. Ke deeh ka me laaj e nyin ngo be ngahbo ke waaro kedea be beehdo paajo abea na beed dom wudh leehde now. ");
INSERT INTO lwo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Gihn nu arumo kaa aniide Jeacuu, e ngo amaahr piny ke lalo me teeg ne cohg. Maa ariedhe ree piny thaahdh tien Jeacuu e ngo urubo yihre kobe, “Jeacuu! Waahd Juog Aciehg ge Maalo! Gihn e ne daahdi riha? Yih akwaya a keá joohri.” ");
INSERT INTO lwo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Gihn ni ateed atiihb ukeehge wa maano, bang gihn nye wong kaano aroohm gene ke Jeacuu nu, e anaa arob Jeacuue kejea beehne oogo yi guohb nyin. Nyin ni kuohme anaa ayihny atiihb ukeehge. Ngo na beehde e mage mago ke nying nihn. Keehd ne kobe kejea nyin toag yi karkoohn, utuohye piny teeg mee ke gele e ge coohde coohdo, ugoohde kii laaro dom kar keede. ");
INSERT INTO lwo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Noono maa apeehny Jeacuue ngo kea, “Nyingi ngaa?” Maa akoohbe kejea, “Nyinga beehda Amahr.” Adiehr nyinge beehda Amahr bang gihn atiihb ukeehg me thoohdh ge anaa ree. ");
INSERT INTO lwo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Arumo maa akway gene wong Jeacuu kejea nea kare nud e ge keá rieme yi buur thuudh cuohn ne Jaeena ni. ");
INSERT INTO lwo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wong Jeacuu akway gene kejea ngweehn urieme gen rog amahr kudhruue maa anaa ake nyahmo dieng good. Maa ayiih Jeacuue ngo yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Naa abeehn gene oogo arumo rih nyin, e ge amon yi koohm kudhruue. Maa abeehn kudhruue unahg gene ke rudh ke ngweej e ge loohn piny ke dieng good maa anahg gene thoadh yi baaw umud gene ne raj. ");
INSERT INTO lwo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Naa aniid yaa kwaahe gihn nu, e ge anaa rudh ke ngweej thiow, ugoohd gene kii buur geew ne kwaan kwaad gihn ayug ree yihr nyoge kedea maa arob gene ngo yihr nyoge me beed buud geew. ");
INSERT INTO lwo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Muudhe e nyoge awaahd oogo beere ge caa ne maany gihn ayug ree ni. Abea naa awahnh gene bang Jeacuu kaa ayug gihn ni ree yi ngo, e nyin ayuud gene e ngo apiih thaahdh tien Jeacuu, e wiihe adoohng kwel kedea angahbo ke waaro thiow. Gihn nu e nyoge ge amag lwahre mago keter. ");
INSERT INTO lwo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Muudhe e gihn ni ayug ree, aci gene ke ne teedo yihr nyoge mooge e ge kwaan dhe yoohn kaa athiehdh Jeacuue nyin kii ngo. ");
INSERT INTO lwo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Batiene arumo e yaa Graaja ge ake rubo yihr Jeacuu kejea dhiile aay, uwiie paar gen piny. Gihn nu arob gene bang naa atud gene ke nying gihn ayug ree. Ubeehn Jeacuue upaahre kii baabuur uaaye. ");
INSERT INTO lwo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Abea nyin anaa ariehme atiihb ukeehg oogo ree ni, anaa meen meeni kea e ucidho keehd Jeacuu maa arob Jeacuue ngo yihre kejea, ");
INSERT INTO lwo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Doog paajo, urobi gihn duohng ayug Juoge rihi ni yihr nyoge.” Noono uaay nyine ucea ne keed gihn ayug Jeacuue yihre ke bang yi geew ne dug. ");
INSERT INTO lwo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Naa adog Jeacuue caahn loo baaw keehdo e ngo acahg nyoge kaa loro ne cohg, bang gihn abeehde e ngo anaa koar gene ke piny. ");
INSERT INTO lwo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nye wong kaano e nyin me nyinge Jearuuj abeehno uthoohre ree thaahdh tien Jeacuu maa akwaye wong Jeacuu kea cidh Jeacuue paare. Nyin ngo beehda ruohdh wod amaad. ");
INSERT INTO lwo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Wong Jeacuu akwaye bang gihn nyaare ge acielo cog ngo atwaany kaa atwaany maa thoo. Nyaare rune ge anahg apaar wonge ariow. Kaano naa acaahdh Jeacuue caahdho nu e nyoge me thoohdh, ge anaa ake caahdho ne yong yong ke batiene e ngo pud gene ke ne jwang piny. ");
INSERT INTO lwo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dhaago moogo anudo keew nyoge giih ni thoohdh ni, me ree anaa atwaany remo me wuur ree ke run apaar wonge ariow e ngo be cuung. Ke run nu e ngaa maa arom atwaany ke thiehdho atooro. ");
INSERT INTO lwo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Muudhe e dhaar ni abeehno ke ngahy Jeacuu ugweele dhe waaro gihr Jeacuu maa abeehn remo unea ke ne thihb ree ke nye wong kaano. ");
INSERT INTO lwo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Maa apeehy Jeacuue kobe, “Ngaa e naa agweel an?” Nyoge cang akweer, e ngaa man ukweer kea padh en. Muudhe e Piihter acaa ne rob yihr Jeacuu kobe, “Abea ruohdh, yih upeehny ngaa, maahny kaa adhihr nyoge yihn kii ngo do!” ");
INSERT INTO lwo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Maa arob Jeacuue ngo kea, “Padh ne maano! Ngahya kejea dhaano maa agweel an nud, bang gihn tee maa a'aay oogo riha nud.” ");
INSERT INTO lwo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ubeehn dhaar ni uguoe ngo kaa ngeyo thiow kejea gihn atiihye ni angej. Noono upahre oogo kiin nyoge e kuohme urihg ni, uthoohre ree ke thaahdh tien Jeacuu maa ateede gihn agweele dhe athoohr gihr Jeacuu ke nyinge nyum nyoge kaano cang kedea kaa a'aay atwaanye ree kii ngo ke wong kaano. ");
INSERT INTO lwo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Maa arob Jeacuue ngo yihr dhaar ni kobe, “Nyaara! Cidhi keehd yoohm rihi. Yiiho mari yihn aboadhe.” ");
INSERT INTO lwo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Abea nye wong kaano apoohde e Jeacuu urubo nu, e ngaa moogo ake beehno ke yoohn paar Jearuuj maa arube yihr Jearuuj kobe, “Ruohdh, nyaari ataaj. Wiih ngad puohny keá raam keehdo.” ");
INSERT INTO lwo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","E gihn ni arob ngaan ni aguo Jeacuue kaa lihngo, urube yihr Jearuuj kobe, “Jearuuj, yih keá tudo! Yiih ngo ke cwihnyi now, e nyaari uthiehdh ree.” ");
INSERT INTO lwo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Naa awahnh Jeacuue paar Jearuuj arumo, e nyoge amahne ke bar wod keehde tiehd. Noono maa ayoade ke Piihter kedea Joon kedea Jeamij maa wur nyethiin ge ke men, ge naa ameehge bar wod keehde. ");
INSERT INTO lwo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","E jo muu anaa ke yuog ke nying nyethiin ge acuow Jeacuue kea, “Lengu do! Nyethiin kuu athow, gihre beehda niine!” ");
INSERT INTO lwo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Maa angier gene Jeacuu, bang gihn angahy gene kejea nyethiin athow muon. ");
INSERT INTO lwo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Batiene maa abeehn Jeacuue umage bad nyethiin maa urube keehd ngo kobe, “Nyethiin! Aj maalo!” ");
INSERT INTO lwo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Maa aduu wahy nyethiine ree, uyedhe ke maalo piny ke wong kaano. Urob Jeacuue ngo yihr nyoge kejea yoad gihn me cam cube yihr nyethiin. ");
INSERT INTO lwo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Batiene e wur nyethiin kedea men thiow ge acahg cwaahng. Maa arob Jeacuue ngo yihr gen kejea gihn atiihy ree, keá teed gene yihr nyoge mooge. ");
INSERT INTO lwo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Naa acuohn Jeacuue yaae kar ge apaar wonge ariow ka maa acielo, e tee acube yihr gen, me riem gene atiihb ukeehg oogo rog nyoge kedea me thiehdh gene atwaanye giih nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Maa aoohre gen oogo beere ge ucidho upuohny gene nyoge keehd dhe yoohn ka nweehd nyoge ke Juog Ruohdh kedea ne thiehdh nyoge me rog gen naa atwaanye. ");
INSERT INTO lwo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Noono urobe ngo yihr gen kobe, “Wu noono oohra nu yaage, cidhu abea aroba kejea keá ngaan kaahdo ke nyepiny kejea beehda gihr bang wod yooh. Keehd goohd, wale joogo wale amono wale ngiihny keá kaahnu kedea waare ariow ge keá kaahnu. Giih nu ge keá kaahnu ke wun. ");
INSERT INTO lwo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kwaad paan toohngu yea kea beehdu yea kaano uwahdhe cahng uaayu. ");
INSERT INTO lwo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Thiow nea nyoge nud me kweer ke goong wun ke nying tiihyu nuu ucuu ne tiihyo yihr gen, kea aayu uwiiu geen gen piny, uteengu ngoom kaano oogo yi tienu ne nyoadh ngo kejea nea gihn me yoad gen, e maru tooro yi ngo.” ");
INSERT INTO lwo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Noono upahdh gene yooh, ucaahdh gene ke bang yihdh miehr, e ge puohny Ciig Beer kedea e ge thiehdh nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Muudhe Eroade naa anahg ruohdh, bang giih ni ayug rog gen ni, ge alihnge lihngo. Noono maa ane wiihe ne cohd ne cohg, bang gihn anaa alihnge bang nyoge mooge kejea ka moogo e Joon e naa acahr batien thoo. ");
INSERT INTO lwo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nyoge mooge kob gene beehda Eliija e naa atuohl keehdo, e nyoge mooge dahng kob gene beehda ngad agamloohngjuog moogo maa acoon e naa atuohl keehdo. ");
INSERT INTO lwo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Gihn nu, Eroade ake rubo ke cwihnye kea, “Abea wa Joon wiihe anaa ameehga ngol oogo uthowe. Beehde ngaa e gihn ni rob nyoge giih ni ke nyinge awaahn ni?” Maa abeehne yi cwihny Eroade kejea ngaan ni arub nyoge ke nyinge cwihnye ne niid ngo thiow. ");
INSERT INTO lwo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Naa aduu jo oohre ke yoohn kaa anaa aoohr Jeacuue gen yi ngo, e kwaad giih thoohdh naa atiihy gene, ge akwaan gene kwaano yihre. Ubeehn Jeacuue ukaabe jo oohr giihe ubeehne keehd gen yi goan geew moogo me cuohn ne Bedhceada. ");
INSERT INTO lwo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Amahr nyoge bang Jeacuu alihng gene maa aluub gene ngo kaano. Gihn nu e ge angahy Jeacuue kaa loro, urube yihr gen ke nying dhe yoohn ka nweehd nyoge ke Juog Ruohdh maa athiehdhe atwaanye giih yaa tuu kiin gen. ");
INSERT INTO lwo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yi laahng cahng ke thiehno e jo oohr ge apaar wonge ariow, ge abeehn bang Jeacuu maa arub gene yihr ngo kob gene, “Ngaan duohng! Rubi keehd nyoge beere ge uaay uci gene ne daahd kar buudo yihr gen ke bang yihdh miehr giih cahng ke kan kedea thiow beere ge udaahd yihr gen keehd gihn me cam gene. Ngahyi thiow kejea nyoge naa yi ukang dom.” ");
INSERT INTO lwo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kaano e ngo abeehr Jeacuue beehro yihr gen kea, “Maa cubu gihn me cam yihr gen.” Maa akoohb gene kejea, “Yihr wan naa amune abiihj cog kedea rej ariow. Nea padh ngiew e ne cidh wane ne ngiew cam yihr amahr yaa ni amahdo ni.” ");
INSERT INTO lwo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yaa anudo cang ge anahg kar cuow alihbe abiihj. Maa arob Jeacuue ngo yihr jo waahdhe kejea, “Kea noono, meehgu nyoge piih piny naa akuude. Cubu kar nyoge jiehariow wonge apaar naa akuud.” ");
INSERT INTO lwo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Gihn nu ayug jo waahdh Jeacuue wa kwaad kaano arobe ngo yihr gen nu maa apiih nyoge piny ne raahj. ");
INSERT INTO lwo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ukaab Jeacuue amune abiihj maa rej ariow naa atudo kedea umaahnye maalo maa umuohye koohr Juog ce thube ke toar amune. Maa acube gen yihr jo waahdhe kejea paahng gene gen yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Arumo maa acahm nyoge cang ne dug, uyahng gene ne cohg. Naa athum nyoge ke cam, e jo waahdh Jeacuu, goan caame giih adoohng piny bang nyoge acong gene congo maa apaahng gene adiide apaar wonge ariow. ");
INSERT INTO lwo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cahng man keehdo e Jeacuu, anaa ne kway Juog kar keede, abea e jo waahdhe ge anaa buude kaano thiow. Upeehnye gen kobe, “Lwaag rob gihn awaahn ni ke nyinga? Kob gene kejea a naa ngaa?” ");
INSERT INTO lwo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","E gihn nu abeehr gene beehro kejea, “Kob nyoge mooge naa yih Joon, Ngad Luogwahy, nyoge mooge naa yih Eliija e nyoge mooge dahng kob gene kejea yih beehda agamloohngjuog keew yaa agamloohngjuog giih acoon e naa acahr.” ");
INSERT INTO lwo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Maa adog Jeacuue gen ke peehnyo kobe, “Abea nea maru, e kobu a naa ngaa?” E ngo abeehr Piihtere kobe, “Yih naa ngaan aoohr Juoge ne boadh nyoge ge beehn ke bang Juog.” ");
INSERT INTO lwo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","E ngo arob Jeacuue yihr gen kejea gihn nu keá teed gene yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ubar Jeacuue ke maalo ke rob kobe, “Ngaa adoohng ne dhaano utaahngo, guohbe dhiil raahm yihdh giih me thoohdh. E thiow jo doong paajo maa yaa doonge nyum yaa lam giih kweehr kedea yaa loohnge ge noono cang, ngaan ni ujaahy gene kedea ubeehn gene ne naah abea yi dahg nihn, e ngo ucahg Juog ke tihng maalo ucahre kar thone.” ");
INSERT INTO lwo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Maa acahge rob yihr gen cang kobe, “Nea ngaa daahd ubuodhe batiena kea jaahye ree maa uguume giih raahm kuohm wa mara ce beehne ubuodhe batiena arumo. ");
INSERT INTO lwo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kwaad ngaa kweer ke buodh batiena bang gihn be daahd uthowe e ngaan nu kuowo me guge tooro buu uyoade. Abea kwaad ngaan be dier ke thoo ke nyinga e ngaan nu kuowo me guge tooro uyoade. ");
INSERT INTO lwo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Gihn e ne kony giih wiih pinye yihr dhaano utaahngo, nea boadh wahy be yoade? ");
INSERT INTO lwo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kwaad dhaano, me tud kejea guohbe uyaahr ke nying luube giiha e an thiow, a ge adoohng ne dhaano utaahngo utud uyaahr guohba ke nyinge cahng ubeehna e wiiha amoar kedea ke dhe yoohn moar wihj mar Juog Wuur kedea wuohdjuog. ");
INSERT INTO lwo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A rob athiir yihru. Yaa nud kan ge buu uthow cang, nud ke nyoge kiin gen muu uniid Ruohdh Juog ke nying gen.” ");
INSERT INTO lwo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kar batien nihn abiihjbedahg kaa arob Jeacuue gihn ni, e Piihter keehd Joon kedea Jeamij umen, ge akaab Jeacuue uci gene wiih good maalo ne kway Juog. ");
INSERT INTO lwo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kaano akwahy Jeacuue nu, e nyinge rog ge alog gene logo, e waaye naa anii guohbe thiow ge ake liel tar ne weej. ");
INSERT INTO lwo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ke wong kaano e Moaje ge keehd Eliija, ");
INSERT INTO lwo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ge anaa celang bang Jeacuu e koohm gen adoohng ne maar maar kwaade tooro naa awuohb gene. Noono uthub gene ke rob tiehd ke Jeacuu ke nying kaa adoohng kar aay gihr Jeacuue cahng kii ngo, ke kur thone nuu uyug ree ge ucea Jeruucalem ni. ");
INSERT INTO lwo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ubeehn Piihter ke jo waahdh Jeacuu ge ariow ni, uguo niine nying gen ke kwala. Ge atahng gene ni e kaa alog kuohm Jeacuue ree kii ngo kedea yaa ariow thiow naa ake cuungo keehd en aniid gene niido. ");
INSERT INTO lwo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nye kaa athub Moaje keehd Eliija ke aay nu, e Piihter ake rubo keehd Jeacuu kobe, “Ngad Puohny! Ngo beer ubeehdo kan! Nea wa gihn nu kea wii wan ugeer wane abuwe adahg. Acielo yihri maa acielo yihr Moaje kedea acielo yihr Eliija.” (Gihn ni arob Piihtere e ree kwihye). ");
INSERT INTO lwo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nye kaa apoohde e Piihter urubo, e deeh lwahd abeehno wudh gen ne niihm, umag lwahre gen ge amoal lwahde gen piny. ");
INSERT INTO lwo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Batiene e duol abeehn oogo kii lwahd gihn ni, e ngo urubo kea, “Gihn e naa Waahda maa akwanya! Lihngu lume beer mee.” ");
INSERT INTO lwo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Naa aleng duole, e Jeacuu e naa aniid gene e adoohng kar keede. Noono e gihn ni ayug ree ni, akan yaa ni ke piny, utoor ngaa maa arob gene ngo yihre. ");
INSERT INTO lwo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ruuwow, naa aduu gene, maano e ge loohn piny kaa wiih good maalo, e Jeacuu ake roohmo keehd akuud nyoge me thoohdh naa abeehn bange. ");
INSERT INTO lwo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kaano e dhaano acielo ake cuohdo keew yaa nu e duone atihnge maalo kobe, “Ngad puohny, cedhree! Yih akwaya! Luu wongi bang nye waahda gen. Beehda nyethiin acielo cog yihra! ");
INSERT INTO lwo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ngo beehd e ree naa atiihb ukeehg. Ngo beehdo e maahr piny ke lalo. E gihn ngo thiow nyethiin wiihdhe wiihdho, uyale nyinge yalo e dhee uthugi keehd aboohyo. Kar yuohmo tooro me yoade. ");
INSERT INTO lwo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jo waahdhi ge anaa akwaya kejea riem gene ngo oogo rih nyethiin, abea agoohg ke riemo yihr gen.” ");
INSERT INTO lwo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","E Jeacuu ake rubo kobe, “Wu kwaad nyoge me yiiho tooro yihru? Wudhu paru paro kejea a ubeehdo keehd wun uwahdhe weehne? Kahl waahdi noono yihra kan!” ");
INSERT INTO lwo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nye kaano anaa akahl nyedhoohg bang Jeacuu nu, e atiihb ukeehg nyedhoohg ariedhe ke piny maa ayule ngo kwaade tooro. E Jeacuu atiihb ukeehg acuowe cuowo uthiehdhe nyethiin arumo, ucube ngo yi cing wahn. ");
INSERT INTO lwo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ucwaahng nyoge ke nying teeg Juog naa aniid gene. Nye wong kaano thiow apoohde e dhog nyoge atal nu, e Jeacuu ake rubo keehd jo waahdhe kobe, ");
INSERT INTO lwo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Meehgu luube giiha gen mon yi cwihnyu, bang gihn a ge adoohng ne dhaano utaahngo a uluom ucub an yi cing nyoge me reje.” ");
INSERT INTO lwo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Abea gihn ni arob Jeacuue, bekihd ngaa maa adead yea beer mee kiin jo waahdhe. Bang gihn yi lum gihn ateede ni akan ubahnge yi ngo kuu adead gene. Thiow ge atud ne peehny Jeacuu ke nying yi lum gihn ni arobe ni. ");
INSERT INTO lwo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Arumo kaano, e nye thar lubo ree acage caa kiin jo waahdh Jeacuu. Ngo acag ree e ngo beehda peehm ke rog gen, kejea ngaa kiin gen e naa ngaa me duohng, wale ngad wong maalo keew gen. ");
INSERT INTO lwo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Bang gihn giih par gene ge ngahy Jeacuue, e nyethiin me thiin akaabe ucube ngo ne cuungo ucinge. ");
INSERT INTO lwo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Maa arube keehd jo waahdhe kobe, “Kwaad ngaa beehdo beer ke nyethiin me wa nyethiin ni, e ngaan nu uroomo wa ngo abeehdo beer kaa an, padh an keeda abea ngo uroomo wa ngo beehdo beer kaa ngaa aoohr an. Kwaad ngaa goong an e beehda ngaan aoohr an, e naa agoonge thiow. Bang gihn ngad dhe caahn kiinu, e noono e naa ngad wong maalo ne duohng yihru cang.” ");
INSERT INTO lwo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","E Joon ake rubo kea, “Ngad puohny, dhaano moogo anaa ayuud wane, e atiihb ukeehg ge rieme ke oogo rog nyoge e rob nyingi maa amahn wane ngo bang gihn padh ngado.” ");
INSERT INTO lwo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Maa abeehr Jeacuue ngo kea, “Keá mahnu. Bang gihn ngaa be yug gihn me raaj rogu, e ngaan nu beehda ngadu.” ");
INSERT INTO lwo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Naa abeehn kar thon Jeacuu udoohnge cahng arumo, e Jeacuu cwihnye acube ne cidh Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Gihn nu maa aoohre wuohde wong maalo. Maa abeehn yaa nu paajo me beehda paar yaa Camaarya, beere kar piih beehn gene ke ne gwiiro yihr Jeacuu yi ngo. ");
INSERT INTO lwo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yaa Camaarya ge abeehn ne kweer yihr yaa aoohr wong maalo kejea Jeacuu keá piih paar gen yi waahdhe gihn cea Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Naa aniid Joone kedea Jeamij umene gihn ni e ge ake rubo keehd Jeacuu kob gene, “Ruohdh, cwihnyi ne bange, uoohr wane maaj wudh gen ke maalo uwaang gene ne?” ");
INSERT INTO lwo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Gihn nu e Jeacuu wiihe aloge ke bang gen maa acuowe gen ");
INSERT INTO lwo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","maa acidh gene paajo moogo. ");
INSERT INTO lwo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kaano anaa acaahdh gene caahdho kii yooh, e ngaa moogo ake rube keehd Jeacuu kobe, “Adaahde unahga ngad waahdhi, beere nea ka cii yea e an ucidho keehd yihn thiow.” ");
INSERT INTO lwo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Maa abeehr Jeacuue ngo yihre kobe, “Thoohe yihr gen ne kuohn beed gene maa winy yihr gen ne wuude me beed gene abea a ge adoohng ne dhaano utaahngo yihra tooro ka me piehla thaahnga yea.” ");
INSERT INTO lwo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kaano e Jeacuu arubo keehd ngaa moogo kea, “Beehni ubuodhi an.” E nyin ake rubo yihr Jeacuu kea, “Ruohdh wura athow, meehga kuong ci ne koany ngo.” ");
INSERT INTO lwo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","E ngo abeehr Jeacuue beehro yihre kobe, “Wii yaa acub wudh gen yihdh giih thunge ukoany gene yaa athow. Abea mari, beehn ne buodh an udoohngi ne ngada, cidhi urubi ke nying dhe yoohn ka roohm nyoge ke Juog Ruohdh kii ngo yihr gen.” ");
INSERT INTO lwo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Keehdo e ngaa moogo acahg rob kea, “Ruohdh meehg an kuong ci paajo uwiihwa yaa paar wan umodho ubeehna bangi arumo.” ");
INSERT INTO lwo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Maa abeehr Jeacuue ngo yihre kea, “Ngaa maa akuong cinge ke mag rih kweer umodho ucahge maahny caahn, ngaan nu padh ngaa me miehr keehd dhe yoohn ka mag Juog Ruohdhe kii ngo kedea be miehr udoohnge ne nyethiine.” ");
INSERT INTO lwo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Batien gihn ni arumo e Jeacuu nyoge kar ge jiehadahg wonge apaar wonge ariow mooge ge akwanye, uoohre gen naa ariow ariow, beere ge ucidho wong maalo nyume ke bang kuohn daahde ucidhe ke yihdh gen. ");
INSERT INTO lwo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Maa ateede ngo yihr gen kobe, “Tiihj puohny lum Juog yihr nyoge ngo adoohng teeg keter, adhaahr ngo uroma ke rih deeh puohdho me puur. Noono e daahd nyoge me thoohdh me tiihy giih acieg yi puohdho. Nea wa gihn nu kea kwayu Juog ge room ke ngad puohdho, umuoje wun keehd yaa tiihj me thoohdh ubeehn gene ne tiihy yi puohdho gihre. ");
INSERT INTO lwo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Cidhu! Wu noono oohra oogo nu, wa gihr nyethen roohme kiin urude. ");
INSERT INTO lwo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Akoba kejea jenaadh wale joogo, wale wuoy tiel ge keá kaahnu. Wu keá cuungo ke bang yi yooh umaahdhu kwaad dhaano me roohmu keehde. ");
INSERT INTO lwo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kwaad paan toohngu yea ne ngio, e kea kuongu rob umodho kejea, ‘Beehdu ke yoohm rogu, wu yaa paan ni!’ ");
INSERT INTO lwo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Gihn nu nea kwaad ngaa me nhyaar doohr nud kiin gen e doohr gihru noono arobu nu uyiih ngaan nu. Abea nea ngaa me nhyaar doohr tooro e doohr maru naa acubu udhiil duu yihru kare cang. ");
INSERT INTO lwo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Thiow, beehdu paan upiihu yea kedea camu kwaad cam muu ucub gene yihru maa maadhu giih ucub gene yihru. Bang gihn ngad tiihj koog dhiil kaa cubo yihre ke nying tiihye. Wu keá dag ke bang yihdh miehr. ");
INSERT INTO lwo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Kwaad geen toohngu yea ne ngio, abea wu angahy nyoge ke loro, kea camu kwaad cam gihn cub gene nyumu ne camo. ");
INSERT INTO lwo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kwaad atwaanye muu uyoadu rog nyoge, thiehdhu gen. Kedea na rubu yihr nyoge kejea, ‘Kar beehn Juog ruohdh ne nahge ruohdh kii ngo awahnh yihru.’ ");
INSERT INTO lwo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Abea kwaad geen toohngu yea, ukwihy wun ke loro beer, kea cidhu ke bang yihdh yiehdh geen gen noono urubu yihr gen kejea, ");
INSERT INTO lwo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Wu yaa geen ni maahnyu now keehd lod gihr geenu naa amahg rog tien wan, dhiil wane kaa teeng rogu. Abea gihn nud gen, dhiilu nyepiny acielo ke ngahyo, kejea beehn Juog ne nahge ruohdh kii ngo awahnh yihru.’ ");
INSERT INTO lwo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Roba roba yihru kejea giih teeg naa ayoad yaa Codom cahng ukihm Juog ge uyoohd yi gihn uyoad yaa geen kwihy wun ke loro. ");
INSERT INTO lwo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Beehda kwaad gihn ge raaj wa gihn ge apahdh wudhu wu yaa geen Korajin maa yaa geen Bedhceada! Alwaa giih teeg ge gaahy nyoge, ge ayug yihdh geedhu ngahda ngweehn me ne yug gen yihdh geedh yaa Taayr kedea Ciihdoan, bang gihr yaa nu cwihny gen ne rahnyo rog anyoohne giih gen naa ayug gene rih Juog. E thiow ge ne piih uthur e cuole angaab gene. ");
INSERT INTO lwo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ngahyu ngo kejea Cahng Lug Juog e yaa geen Taayr kedea yaa geen Ciihdoan ge ungwaahn Juoge yi lug gihre nu uluge gen. Abea wun lug gihre uteeg rogu keter. ");
INSERT INTO lwo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Wu yaa Kaparnaam, wu keá nhyaam kejea paar Juog unahg gihru, Paar Juog be yoadu! Juog wu ukedhe yi buur thuudh cuohn ne Jaeena. ");
INSERT INTO lwo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Ngaa ulihng gihru e ngaan nu gihra e naa alihnge. E kwaad ngaan kweer keehd wun, e ngaan nu akweer kaa an kedea akweer ke ngaan aoohr an.” ");
INSERT INTO lwo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yaa anaa oohr Jeacuue oogo kar ge jiehadahg wonge apaar wongo ariow, ge anaa aduuo e cwihny gen amihno keter. Arumo maa arub gene yihr Jeacuu kob gene, “Ruohdh! Keehd atiihb ukeehg e gihr wan lihng gene lihngo ke nyingi!” ");
INSERT INTO lwo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Maa abeehr Jeacuue ngo yihr gen kobe, “Ruohdh atiihb ukeehg aniida e pahdh kaa maalo e ngo beehn piny ne bliny bliny wa kwaad gihr maahny kodh! ");
INSERT INTO lwo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Teeg acuba yihru beere keehd thoohne kedea yiihdhe thiow ge nyuohnu ke piny ke tienu. Kedea tee gihr ruohdh atiihb ukeehg ge ngad mahn gihru thielu ke piny thiow beere gihn me raaj me rome ke kahl rogu tooro ne weey weey. ");
INSERT INTO lwo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Cwihnyu keá mihno kejea atiihb ukeehg gihru lihnge lihngo, abea mihn cwihnyu bang gihn nyingu agweed piny paar maalo.” ");
INSERT INTO lwo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Cahng ni keehdo arumo, e Jeacuu cwihnye anaa mihno keraahyo ke dhe yoohn Wahy Juog e ake rubo kobe, “Abaa Wura! Yih naa Ruohdh maalo kedea wiih piny cang. Koohri amuohja tihn bang gihn luube ke nying dhaahri ge ngahy ke yihne cog, ge kii nyoadho yihr yaa par wudh gen kejea ge nyoge maa apuohny. Abea ge anyoadhi ke yihr yaa ngahy rog gen kejea ge neehn nyethen gihn me ngahy gene tooro. Ayiih! E naa kaa agweehgi dhe yoohn ka yoad dhaahri kii ngo noono. ");
INSERT INTO lwo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Teeg wong ne ngahy giih nyepinye cang ngo acub Juog wura yihra kedea beehda Juog wura cog e ne ngahy an me neehn man nahge an e ne ngahy Juog wura kedea yaa akwanya ungahy gene Juog wura.” ");
INSERT INTO lwo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Batien gihn nu arumo e Jeacuu wiihe aloge ke bang jo waahdhe maa arube keehd gen kobe, “Mihn cwihny yihr yaa niid giih niidu ke nyingu! ");
INSERT INTO lwo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bang gihn teeda teedo yihru kejea yaa agamloohngjuog kedea ruohdhe giih acoon ge adaahd uniid gene giih niidu, abea ge kuu aniid gene kedea ulihng gene giih lihngu abea ge kuu alihng gene.” ");
INSERT INTO lwo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Muudhe arumo, e ngad loohng acielo ake peehyo e daahd gihn me mage dhe Jeacuu keehde maa apeehye kobe, “Ngad Puohny! Gihn e nuu utiihya beere kar wahy me be gug yoada yoado?” ");
INSERT INTO lwo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Maa abeehr Jeacuue ngo yihre kea, “Gihn e naa agweed yi kitaab Loohng? Giih agweed ge kwaani ke naa diih?” ");
INSERT INTO lwo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Maa abeehr nyine ngo yihr Jeacuu kobe, “Ngo agweed kejea, ‘Nhyaar Juog Ruohdhi ke aduuni beehde, ke wahyi beehde, ke teegi beehde kedea ke wiihi beehde kedea nhyaar wadu wa kwaad ka nhyaari rihi kii ngo.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kob Jeacuue yihre kea, “Wa angahyi ke beehro. Tiihyi wa gihn nu e kar bodh wahyi uyoadi.” ");
INSERT INTO lwo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nyin adaahd unyoadhe ree ne ngaa me beer maa acahge Jeacuu ke peehnyo kea, “Beehda ngaa ne cohg e naa wad wan?” ");
INSERT INTO lwo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ne beehr lume, e Jeacuu ake rubo kobe, “Nyin moogo anaa abeehn ne aay ke yoohn Jeruucalem e ngo caa ne weel geen Jeriiko. Yi yooh e ngo apahdho yi cing yaa kahw. Maa agoony gene waare giihe oogo ree maa upuohd gene ngo keehd kwaad apoohdo me raaj, noono maa a'aay gene uwii gene ngo piny e nyin uluyo. ");
INSERT INTO lwo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ngad lam giih kweehr, akahnho ke yoohn ni acielo. Abea naa awahnhe buud nyin uniide ngo, e nyin agaaje gaajo unaage ke dom, ubare ke yoohne. ");
INSERT INTO lwo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Thiin keehdo e ngad tiihj gihr Wod Juog ake kahnho keehd yoohn ni acielo. Abea naa awahnhe kaa apahdh nyine yea, uniide ngo e ake naag ke dom, ubare ke yoohne. ");
INSERT INTO lwo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Batien yaa nu e nyin maa ngad Camaarya ake beehno ke yoohn ni thiow. Abea naa awahnhe kaa apahdh nyin yea ni, e yea ngad Camaarya gihn ake ngeero maa abaahbe bang nyin. ");
INSERT INTO lwo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Noono maa apiihe ne wuuny nying ka me ledhe giih nyin. Uwoje mow kedea koohng nibiid yihdh nying ka me ledhe maa abahye gen arumo kedea ucube nyin ke wiih akaja gihre ukahle ngo wod weehle ne beehn ne tuu ngo yea. ");
INSERT INTO lwo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ruuwow naa aruu pinye e kar ngiihny dolaare ariow akahle oogo maa acube gen yihr ngad wod weehle, urube keehd ngo kobe, ‘Maany ngo beer mee. Cahng duua e ngiihny arwaahnyo yihri ge ucoala yihri.’ ");
INSERT INTO lwo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Ngaa kiin yaa ni adahg, e naa wad nyin apahdh yi cing yaa kahw ni?” ");
INSERT INTO lwo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","E nyin anahge ngaa maa apuohny keehd dhe yoohn loohng ake rubo kobe, “Beehda ngaan ayug gihr med yej yihr nyin.” Maa ateed Jeacuue ngo yihre kobe, “Cidhi, utiihyi wa gihn nu.” ");
INSERT INTO lwo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Naa a'aay Jeacuue arumo keehd jo waahdhe, e ge awahnh paajo moogo, kaa abeehn dhaago me nyinge Maartha ucube Jeacuu piny ne weehno paare. ");
INSERT INTO lwo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Dhaar ni yihre anaa nyemen me nyinge Maarya. Gihn nu e Maarya anaa apiih buud Jeacuu kun doo thaahdh tiene e lihng giih anaa rob Jeacuue robo yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Abea Maartha anaa ke yano e gwiir giih nyepinye e keede cog. Maa abeehn Maarthae bang Jeacuu ne rob yihre kobe, “Ruohdh! Ka be ledh yi cwihnyi ge beehn nyemiiha ubahnge a be konye ke tiihj ne? Robi yihre, ubeehne ne kony an?” ");
INSERT INTO lwo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Maa abeehr Jeacuue ngo yihr Maartha kobe, “Maartha! Maartha! Yih anahg diere kedea cwihnyi be med ke nying giih me thoohdh. ");
INSERT INTO lwo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ngahy ngo kejea nyepiny acielo keede e naa gihn maa athiir ne daahd. Maarya akwany gihn me e ne beer kedea gihre noono akwanye nu, ngaa muu ucahg ngo ke kahl oogo yi cinge tooro.” ");
INSERT INTO lwo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Cahng man e Jeacuu anaa ka moogo kare keede e kway Juog. Batiene naa thume ke kway Juog e dhaano acielo keew jo waahdhe abeehn bange urube yihr ngo kobe, “Ruohdh, puohny wan ke dhe yooh me ngahy wane Juog kwayo beer mee wa mar Joon naa apuohny jo waahdhe.” ");
INSERT INTO lwo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Maa abeehr Jeacuue ngo yihr gen kobe, “Nea wu daahd ukwayu Juog, kea rubu kejea, ‘Abaa! Nyingi ke wuoro. Beehn neehn Ruohdh wan. ");
INSERT INTO lwo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gihn me cam wane tihn cub yihr wan ke nying nihn. ");
INSERT INTO lwo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Wii adhemuohme piny yihr wan wa ka wii wane muu yaa atiihy gihn me raaj rog wan piny thiow. Wa keá meehg pahdho yihdh giih utum.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Maa abare maalo ke rob yihr gen kobe, “Nea dhaano acielo kiinu, yihre ne gome maa acea paar ngo yi diehr waahr, urube yihre kea, ‘Goma muoja keehd amune adahg, ");
INSERT INTO lwo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","bang gihn goma moogo aweehn paajo yihra, abea gihn me nud yihra tooro me goonga ngo keehde.’ ");
INSERT INTO lwo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Wudhu paru paro nye yaage kejea ngaa nu gome noono uguoe ke jaahyo e dhe wod be yabe yihr ngo kejea, ‘Nyieh wiiha raami ke nying gihn? Abea dhe wod atoaga kedea an maa nyethena nying wan ne niine?’ Noono ukweere kejea kar aj maalo tooro yihre ucube gihn apeehny gome yihre? ");
INSERT INTO lwo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Roba robo yihru, kejea keehd ne kobe kejea gome kuu ayedh maalo ke nying gom gihn ne keew gen abea ke nying teege giih yug nyin e ngo udhiil yedh maalo umuoje ngo ke cam ne cohg. ");
INSERT INTO lwo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Wa gihn nu keehd Juog thiow tiihyo ke wa gihn nu. Nea wu ukwahyo keehd gihr nyepiny e gihn ngo ke cubo yihru. Kwaad gihn daahdu, e ngo dhiilu kaa yoado. Thiow nea dhe wod atuongu, e ke yabo yihru? ");
INSERT INTO lwo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bang gihn kwaad ngaa kwahyo e gihn ngo ke cub yihre, e ngaa daahd gihn daahde ngo dhiile kaa yoado. E ngaa tuong dhe wod, e dhe wod ke yabo yihre. ");
INSERT INTO lwo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Wuro gihn aweehne kiinu, nea nyethiine ukwahyo yihre ke reehyo, e ngo cub thuohl yihre? ");
INSERT INTO lwo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wale nea nyethiine ukwahyo ke tong jieno, e cub yiidh yihre? ");
INSERT INTO lwo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Beer nea wu ge beehda nyoge me reje ni, kare nud yihru umuuyu keehd giih me beey yihr nyethenu maa Juog Wuru ge maalo ni, ngo ukweer ke cub Wahy Juog yihr yaa kwahyo yihre?” ");
INSERT INTO lwo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Arumo e Jeacuu anaa ne riem atiihb ukeehg oogo maa naa rih nyin moogo maa abeehdo e be rubo. Naa a'aay atiihb ukeehge rih nyin ni, e dhee ree ayabe yabo urube. Keehdo e nyoge maa anaa cong rog gen naa nudo kaano ge abeehn ne cwaahng. ");
INSERT INTO lwo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Abea nyoge mooge ake thubo ke rob rih Jeacuu kob gene, “Ke dhe yoohn Beeljebuul ge ruohdh atiihb ukeehge e ne rieme atiihb ukeehg oogo.” ");
INSERT INTO lwo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Keehdo e nyoge mooge keew gen, Jeacuu atum gene maa apeehny gene ngo kejea yuge gihn me gaahy nyoge me beehn ke bang Juog. ");
INSERT INTO lwo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Gihn nu e giih gen naa aroam gene yi cwihny gen nu, ge kaa angey Jeacuue maa arube yihr gen kobe, “Nye yaage beehda kare ne? Ka kwiihyu kejea tien paajo maa paahng ree kare tooro ucuunge keehdo ne tien paajo acielo me teeg ne? Beehde e dhiil pahdho e tien paan nu. E thiow ngo gihn me ngahyu kejea kwaad dhe wod maa paahng yea, e dhe wod gihn nu dhiil pahdho ne? ");
INSERT INTO lwo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Bang gihn wa kaano rubu kejea ruohdh atiihb ukeehge doo ree e keede, e dhaahre noono ucuung teeg ke ne diih? Aroba wa maano bang gihn kobu moogo atiihb ukeehge ge riema oogo rog nyoge kaa teeg mar Beeljebuul ");
INSERT INTO lwo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Beer, nea wu urubo kejea ruohdh atiihb ukeehg e naa acub tee yihra ne riem atiihb ukeehg oogo rog nyoge, abea yaau ge riem atiihb ukeehg oogo rog nyoge ngaa e naa acub tee yihr gen? Yaa nu ge nuu uguo ngo ke robo yihru kejea gihn robu beehda toohd. ");
INSERT INTO lwo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Awaahn ni lihngu gihn teeda yihru beer mee. Tee kaa ayoado ke bang ruohdh atiihb ukeehg, abea beehda Juog Aciehg ke ngude e naa acub ngo yihra ne riem atiihb ukeehg oogo. Gihn nu nyoadh ngo yihru kejea Juog athubo ke tiihj yi dhaahre keewu. ");
INSERT INTO lwo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ngaa me teeg me kwaad giih liny giihe nud, giih paare rome kaa konyo. ");
INSERT INTO lwo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Abea nea ngaa moogo me teeg yihre ubeehno utaaje ngo e ngo uaay keehd giih liny kedea giih paare. ");
INSERT INTO lwo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ngaa tooro kura e ngaan nu padh ngada. Wale thiow kwaad ngaan be tiihyo tiehd keehd an, beehda ngaa me daahd raany giiha.” ");
INSERT INTO lwo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nea atiihb ukeehg caa ne beehn oogo yi kuohm ngaan arieme oogo ree, e ngo caa ne waahdh ke bang kuohn me yihdh gen tooro piih, e ngo daahd kaa me yuohme yea. Naa atoor kaa me beer maa ayoade e wiihe apare ne do kare naa abeehne oogo yea. ");
INSERT INTO lwo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ge cea ne duuo arumo, e kare naa acoon yuude e ngo acwad maa agwiir ree beer mee. ");
INSERT INTO lwo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kaano e ngo do caahn, ucea ne kahl atiihb ukeehge abiihjberiow mooge maa akaal wiihe ke raahyo beere ge beehn ne piih wiih ngaan. Awaahn ni ngaan ayoad gihn me raaje bang gihn kar bodho mare yi dhoar man unahg gihn me teeg keter.” ");
INSERT INTO lwo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Noono kaano apoohde e Jeacuu urubo nu, e dhaago moogo a'aj maalo kiin nyoge ke rob e duone atihnge maalo kea, “Yaahy! Wa dhaar anyuol yihn, beehda dhaago me ree med keter. E thiow thune naa adhoodhi, ge beehda thun me rog gen med ne cohg.” ");
INSERT INTO lwo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","E ngo abeehr Jeacuue abeehro yihr dhaar ni kobe, “Nea kaa ngo ne cohg, e yaa lihng lum Juog umag gene giih yi ngo beer mee, ge naa yaa rog gen med noono.” ");
INSERT INTO lwo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ge abeehn amahr nyoge uthoohnh gene, e akob Jeacuue yihr gen kea, “Yaa upiny awaahn, ge koohdh nyoge me reje. Ge daahd uyoada gihn me gaahy nyoge uyuga ngo yihr gen beere ngo niid gene niido. Abea gihn me gaahy nyoge be yug yihr gen. Gihn yuga yihr gen beehda kihd gihn anaa ayug ree rih Jona e naa gihn ucaala yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Beehd e ngo ucaala ke rih gihn anaa abeehn Jonae unahge kihd gihn anaa anyoadh ngo yihr yaa geen Niineba. Keehd an, ge adoohng ne dhaano utaahngo, a unahg kihd yihr yaa upiny awaahn ni. ");
INSERT INTO lwo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Cahng Lug Juog unahg dhaar anahg ruohdh ukoom ne maang dhaahr Ceaba e nuu ucuung yi lug ne cay wun wu ge yaa piny awaahn ni. Bang gihn dhaar ni anaa abeehno ke kur thar piny ka me baahr keter, ubeehne ne lihng loohnge giih Caloamon ge nyinge anaa awiihj. Abea awaahn kan, ngaa me duohng keter yihr Caloamon e man nyumu. ");
INSERT INTO lwo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Cahng Lug Juog unahg yaa Niineba ge nuu ucuung yi lug ne cay wun, wu ge yaa piny awaahn ni. Bang gihn naa abeehn Jonae ne puohny yaa Niineba e puohnye ayiih gene uwii gene tiihy giih anyoohne. Abea awaahn kan, ngaa me duohng keter yihr Jona e man nyumu. ");
INSERT INTO lwo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Gahng ke ngaa me ahb lama, ucube ngo kaa me ngo be niid yea wale uwume ngo piny kaa adiido. Nea beehda kaa ngo ne cohg, e ngo ngaabe ke maalo wiih baaya, beere kwaad yaa abeehn wod piny niid gene niido e ameeny beer mee. ");
INSERT INTO lwo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nyingu ge naa gihn me wa lama me meeny koohmu. Bang gihn nea dhaano wonge kwel kedea cwihnye cang bang lum Juog e kuohme thiow ree meenye meenyo ke kare cang udoohnge ne cal cal. Abea nea wong dhaano col, e keehd kuohme cang udoohng col mee. ");
INSERT INTO lwo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nea wa gihn nu kea dhiilu rogu ke koaro, beere kwaad daahr maaj gihn ne rogu, be ne bihj udoohngu yi muudho. ");
INSERT INTO lwo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Thiow keehdo, nea kuohm dhaano ree ameenye ke kare cang, e muudho tooro keehdo. Koohmu noono ge udoohng ne giih maa meeny rog gen cang wa kwaad gihr lama.” ");
INSERT INTO lwo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Naa athum Jeacuue ke rob, e ngo acuohn ngad Paarijea paare ne cam. Noono e Jeacuu ake cidho keehd nyin, naa abeehn gene paare e Jeacuu apiih wiih tharbeajo ne cam arumo. ");
INSERT INTO lwo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Batiene e Paarijea gihn ake gaahy bang gihn Jeacuu aniide e cinge keá luogo keehd piih wa ka luog cing kii ngo ge beehn nyoge ne cam ni. ");
INSERT INTO lwo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Maa arub Jeacuu Ruohdhe yihre kobe, “Maru wu yaa Paarijea, wu gwahj ngahdh kubaaye kedea cahne now, abea kii cwihnyu yi dwaar, wu nyoge me cam ngiihny nyoge keehd teeg wong kedea wu nyoge me raahju puudh. ");
INSERT INTO lwo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wu nyoge me wudhu tooro! Ngaan ayug ngahdh kubaaye ni, ngahda e naa ayug yea kubaayo thiow? ");
INSERT INTO lwo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Konyu nyoge maa angoohng, kaano e nuu udoohng ngahdh giih nyepinye cang ne wij wij yihru. ");
INSERT INTO lwo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Wu yaa Paarijea wu nii gihn me raaj ne waany. Nyepinye koamu ke piny ne koame apaar keehd cedha maa aguohm kedea kad bey noono ukaabu koam acielo ucubu ngo piny yihr Juog. Abea giih me ne cohg me neehn dhe yoohn beehdo me beer naa abiohgrwaal ke rog maa dhe yoohn ka nhyaaru rogu kii ngo wa ka daahd Juoge, ge wiiu ke piny. Nea kaa ngo e kwaad giih nu ge ne tiihyu maa ucubu koam piny thiow keew giih koam naa apaar. ");
INSERT INTO lwo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Wu nii gihn me raaj ne waany wu yaa Paarijea, bang gihn maru, wu nhyaar kuohn piih giih beey ni, ke bang yihdh kuohn wuud amaad. Kedea wu nhyaar dhe yoohn ka maahdh wun kii ngo ke bang yihdh kuohn cuug. ");
INSERT INTO lwo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Wu nii gihn me raaj ne waany, bang gihn wu uroomo keehd kwaad leehde, me ngahdh gen kuu agiid. Arumo e nyoge ucaahdho ke wudh leehde giih nu now e kwihy gene kejea leehde ne kaano.” ");
INSERT INTO lwo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Batiene e dhaano acielo kiin yaa apuohny keehd luub yi loohng, ngo arubo yihr Jeacuu kobe, “Ngad puohny! Ge rubi wa maano, yih yeny wan thiow!” ");
INSERT INTO lwo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kob Jeacuue yihre kea, “Wu nyoge me nii gihn me raaj thiow, wu yaa apuohny keehd luub yi loohng, bang gihn koohdh nyoge coohdu kaa amahr giih me thoohdh me wa teehr me peeg, e naa kwaad gihn thielu wudh nyoge maa giih me ge be rom gene ke tihngo. Abea giih ngo ge be yugu beer keehd dhe yooh me konyu gen udoohng gene yoohd yihr gen ke tihngo thiow. ");
INSERT INTO lwo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Wu beehda nyoge maa ayaahr thiow bang gihn wun ne geer leehde giih yaa agamloohngjuog maa anahg ge kuowo naa coon. ");
INSERT INTO lwo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Keehd dhe yoohn nu e ne nyoadhu ngo kejea giih anaa atiihy ge kuowo naa acoon ge ka beehda giih maa anhyaaru thiow, bang gihn anahg ge kuowo ge naa anaahng yaa agamloohngjuog, abea wun naa yaa ageer leehde giih gen. ");
INSERT INTO lwo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ke nying gihn nu e naa ka beehn Juoge noono keehd ka ngahye luube urube kejea, ‘Nyoge muu unahg yaa agamloohngjuog kedea mooge muu unahg jo oohr thiow, ge uoohra yihru, abea mooge kiin gen ge unahgu e mooge keehdo ge ujoohru.’ ");
INSERT INTO lwo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Neehn gihn nu e yaa upiny awaahn ni ge udhiil ke kihmo, ke nying giih anaa ayug ge kuow gen naa acoon rog yaa agamloohngjuog kii kaa acag Juoge ungoom, ");
INSERT INTO lwo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ne thube ke rih rem Abel, uwahdhe rih rem Jakarya, naa abeehn ne naah buud kar lam giih kweehr kedea buud Wod Juog. Ayiih dhiila kaa teedo yihru ne cohg kejea yaa upiny awaahn ni, ge udhiil ke kihmo ke nying giih nu ayug gene cang. ");
INSERT INTO lwo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Wu beehda nyoge me nii gihn me raaj, wu yaa apuohny keehd luub yi loohng bang gihn dhe yoohn ngahy giih nyepinye agahlu oogo. Abea wun ke ngudu gihn muu ungeyu utooro thiow, e kwaad yaa ne rom nyepinye ke ngeyo beere ge caa yi Dhaahr Juog, ge agahlu oogo.” ");
INSERT INTO lwo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Naa a'aay Jeacuue arumo, ke wong kaano e yaa Paarijea maa yaa loohng, ater akahl gene ke rih Jeacuu. Noono uthub gene e ge daahd piny keehd dhe yooh me kwahw gene Jeacuu piny keehd kwaad gihn maa awaahj me robe now. ");
INSERT INTO lwo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ubeehd gene e ge koar Jeacuu piny cog, keehd kwaad gihn me mag gene dhee ke ngo kejea nea gihn muu urobe maa gihn maa awaahj. ");
INSERT INTO lwo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kaano abeehn amahr nyoge alihbe me thoohdh umad gene wudh gen adhaahr upud gene rog gen ke jwang piny e Jeacuu akuong rob keehd jo waahdhe kobe, “Yaage kaa cubu nyingu piny beer mee ne cohg ke nying yaa Paarijea bang gihn dhe yoohn gen ne yug gene giih gen uroomo wa kan na tiihy kamiira kii ngo ni. Dhe yoohn tiihy gene kii ngo, beehda yug giih thudh yej rog nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Abea nea kaa ngo, e kwaad gihn wiihe anaa awum piny, udhiil ke aal maalo, e thiow luube giih anaa arob e ge kan piny, ge urob oogo ne caya ungahy nyoge gen cang. ");
INSERT INTO lwo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kwaad giih anaa arobu kii muudho ge alihng nyoge, ge wa giih maa arob kii diih kahr cahng. Kedea kwaad giih anaa arobu e ge robu kaa muong kar keedu ni ge arob kaa dhe yooh me nyoge ukwaago wa gihr ngaa me rubo ke maalo wiih wod. ");
INSERT INTO lwo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Wu goma, wu dhiila kaa toohno kejea wu keá tudo yihr kwaad dhaano utaahngo ge rom nahg kuohm cog abea batien naa anahge kuohm, e gihn moogo me cahge ke yugo keehdo tooro. ");
INSERT INTO lwo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Abea ngaan dhiilu tudo ree gen: kaa tudu ke rih Juog, ngaan ge nea dhaano anahge, e yihre ne tee thiow uthoohre ngo yi maay Jaeena. Ayiih aroba yihru kejea Juog noono e naa ngaan dhiilu tudo ree. ");
INSERT INTO lwo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ngahda ngahyu kejea adiid pure abiihj ngeew kaa nying ryaale ariow cog ne? Abea keehd maano e Juog wiihe be wul keehd rih acielo now keew gen. ");
INSERT INTO lwo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","E ngahda ngahyu thiow kejea keehd yiehy wudhu ke ngud gen, ge akwaan Juoge cang ne? Kea noono wu keá cahg tudo keehdo, bang gihn gihr nyingu ne maalo keter me yoohm adiid pure me thoohdh! ");
INSERT INTO lwo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Dhiila kaa robo yihru ne cohg kejea kwaad ngaa rubo nyum nyoge cang kejea en beehda ngada, e a ge adoohng ne dhaano utaahngo dhiila kaa robo nyum wuohdjuog kejea ngaan nu beehde ngada. ");
INSERT INTO lwo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Abea ngaa kweer keehd an, ujaahye ree nyum nyoge kejea e padh ngada, e keehd an thiow ke nguda, ukweer keehd ngaan nu nyum wuohdjuog. ");
INSERT INTO lwo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kwaad ngaa maa arob gihn me raaj riha, a ge adoohng ne dhaano utaahngo e ngo rom kaa wii piny yihre. Abea ngaa arob gihn me raaj rih Wahy Juog e adhemuohm gihr ngaan nu be rom wii ree piny yihre ne weey weey. ");
INSERT INTO lwo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Abea cahng moogo nea wu akahl kuohn luwe yihdh wuud amaade nyum ruohdhe, e wu keá nahg diere kejea wu urubo ke ne diih ne beehr luube kedea wu keá diero, kejea rogu ukonyu ke ne diih. ");
INSERT INTO lwo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bang gihn kwaad giih ucuu ne robo beehda Wahy Juog e nuu kwaan gen yi wudhu.” ");
INSERT INTO lwo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kaano e nyin moogo abeehn ne rob kiin nyoge kea, “Rob ngo yihr umiiha gen ruohdh, beere giih anaa awii wur wane piny yihr wan yihdh gen paahng wane paahngo keehde.” ");
INSERT INTO lwo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","E gihn nu abeehr Jeacuue kobe, “Nyieh! Ngaa e naa acub an piny udoohnga ne ruohdh wale ne ngad ngol lug piny kiinu keehd umiihu do?” ");
INSERT INTO lwo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Noono maa arob Jeacuue ngo yihr nyoge cang kobe, “Yaage kaa cubu nyingu piny beer mee ne cohg ke nying giih poodh yej, bang gihn kuowo gihr dhaano utaahngo be naa yihdh kwaad giih ne yihre naa conge. Keehd me kobe kejea ngaan nu alony uneehne gihn e gihn me kony giih lonye yihre tooro.” ");
INSERT INTO lwo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Batiene e Jeacuu ucaale gihn abeehne ke ne robo yihr gen kobe, “Umodho coon nyin moogo anaa nudo maa anahg ngaa maa alony keter. Yihre anaa amahr puohdh maa acieg kaa amahr kwaad caame cang. ");
INSERT INTO lwo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Muudhe e ngo abeehn ne rob ke cwihnye kobe, ‘Yaahy! An noon ni, awaahn ni gihn e nuu utiihya? Maany amahr giiha ge acieg ka me kedha gen yea tooro.’ ");
INSERT INTO lwo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Maa abare maalo ke rob ke cwihnye kobe, ‘Mara naa apara nuu utiihya e gen! Atuoge giiha ge dhiila kaa toar piny ke kar gen cang ne dug. Batiene e ge uduoga piny ke geero ke me nyaahn, ugeera gen doong mee. Noono amahr giiha naa acieg yihdh puohdh kedea giiha mooge thiow me ne yihra ge kana ke yihdh gen. ");
INSERT INTO lwo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kaano e a rom rob ke cwihnya a keeda kejea, “Nyieh! Noono maahny arumo do! Amahr nyepinye ge athoohnho maa ge anyoohr yihri, run me thoohdh unahgi upiny e gihn me cahgi diero ke nyinge tooro. Beer nea wa gihn nu e yih dhiil beehdo kar bahbi now e wiihi daa. Yih ucahmo gihri now umahdhi mahdho thiow keehd kuong ke med cwihnyi wa kar wiihi maa atagi.” ’ ");
INSERT INTO lwo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Muudhe e Juog ake rubo yihr nyin kea, ‘Yih amuohle! Ngahy ngo kejea yi bad dewaahr gihn ni tihn, wahyi ge dhiil kaa kaabo! Abea amahr giih acongi ni, ngaa e nuu udoohng gene yihre?’ ” ");
INSERT INTO lwo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Maa agooy Jeacuue wiih lume noono piny kobe, “E naa kwaad kaa uyuge ree noono thiow yihr ngaa cong amahr giih me thoohdh ukoohbe kejea e alony. Abea e giih lonyo ke dhe yoohn kur Juog ge tooro yihre.” ");
INSERT INTO lwo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Batien gihn nu e Jeacuue arubo yihr jo waahdhe arumo kobe, “E naa gihn roba ngo yihru kejea wu keá diero ke wahyu ke nying giih camu wale ke koohmu ke nying waare giih ngaabu. ");
INSERT INTO lwo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bang gihn wahy dhaano utaahngo wiihe ne maalo yihr giih cam. E thiow kuohm dhaano utaahngo wiihe ne maalo yihr waare giih ngaab. ");
INSERT INTO lwo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Maanyu winy do! Koohdhe me piidh gene tooro kedea giih me kaj gene tooro. Yihr gen tooro gale wale dune. Abea ngahda Juog e naa ngaa muodh gen ne? Ngahda kuowo maru wiihe ne maalo yihr mar winy ne? ");
INSERT INTO lwo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Keehd me nahgu rogu ke diero, e ngaa kiinu e ne rom rune ke jwaa beere be laar thoo. ");
INSERT INTO lwo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Beer, nea kare tooro yihru, me yugu kwaad gihn me thiin wa kwaad gihn nu keehd dhe yoohn diero, e gihn e ne nahg diere wun ke nying gihn me duohng me poohd kuu abeehno? ");
INSERT INTO lwo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Maanyu ka doong thiiwe kii ngo. Ge be tiihyo maa waare me cwaahj gene tooro. Abea roba robo yihru kejea keehd Caloamon ke buur ngude yi deeh ngaab wuohbo gihre naa anaa ngahbe, e kuu anaa angahbo keehd ngaab gihn angaab Juoge thiiw acielo kiin thiiwe cang kii ngo. ");
INSERT INTO lwo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Beehda Juog e naa aruug lum wa gihn nu. Lumo me tihn, e ngo nud yi puohdho abea keroo e ngo waang kii maaj. Gihn e thiin yiiho gihru wa maano. ");
INSERT INTO lwo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Wu ka poohd nahg diere naah adhaahr upeehyu ke rogu kejea gihn e nuu ucamo tihn? Wale upeehyu thiow kejea, gihn e nuu maadho tihn? ");
INSERT INTO lwo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Beehda kwaad yaa beehda nyoge me kwihj Juog, gen naa yaa riem batien kwaad giih nu. Juog Wuru ge maalo ngahye kejea giih nu, ge daahdu daahdo. ");
INSERT INTO lwo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Gihn nud naa adoohng gen, kuongu wudhu ke cub piny rog giih rubo ke nying dhe yoohn ka beehn Juoge unahge ruohdh nyoge kii ngo coadhi. Batiene arumo e Juog kwaad giih daahdu ge ucube yihru piny ka me laahwo now. ");
INSERT INTO lwo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nye jo'a! Gihn me tudu tooro ke nyinge. Bang gihn Juog Wuru ge maalo ni, daahd ngo bang naa amihn cwihnye beere ruohdh cube cubo yihru. ");
INSERT INTO lwo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kaa ngeewu kwaad giih me ne yihru oogo, cubu ngiihny ayoadu yihr nyoge maa angoohng. Wa gihn nu e naa ka uyoadu giih beey ge daahdu Paar Maalo, ge beehda giih me yihdh gen be naar. Kedea thiow ge beehda giih me rog gen be rom gene kwalo yihr ngad kahw. Kedea thiow giih me ge be rom biihe ke camo. ");
INSERT INTO lwo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bang gihn ka ne giih lony dhaane yea e naa ka beed aduune. ");
INSERT INTO lwo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Beehdu thiow e wu angahbo kedea gwiiru rogu keehd dhe yoohn ka tiihyu giihu kii ngo. E thiow dhiilu beehdo e lame giihu ge a'ahb kedea e ge uliel yi cingu. ");
INSERT INTO lwo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Beehdu wa gihr yaa tiihy me koar wur paajo gihr gen piny maa anaa aay ucea kar rob kaahny. Batiene arumo e yaa tiihy yihre ge ake piih e ge koar kar ka uduue paajo, beere nea dhe wod tuonge tuongo, e ngo laar gene kaa yabo yihre piow piow. ");
INSERT INTO lwo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Beehda gihn me beer yihr yaa tiihj giih nu, ge ne yuud wur paaje e ge ne ne koar ngo. Athiir roba robo yihru kejea wur paajo nea ubeehn paajo arumo, e waaro gihr cam ungaabe ree ucuohne yaa tiihj giihe bange ucahm gene tiehd. ");
INSERT INTO lwo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Unahg gihn me beer yihr nyoge thiow wa gihn nu, bang gihn nea ge ubeehn wur paaje ni, e ge yuude e rog gen agwiir gene, keehd ne kobe kejea beehn kii waahr wale e ngo beehn kaa akaahg piny. ");
INSERT INTO lwo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kea noono boaru yi gihn thiow kejea nea wur paajo kar beehn ngad kahw ne kwal giih paare, nea ngahyo, e paare be nea meehg kwalo yihr ngad kahw. ");
INSERT INTO lwo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Thiow beehdu wa kwaad maano e rogu agwiiru, bang gihn a ge adoohng ne dhaano utaahngo a ubeehn kii caa me kar beehna kuu acub yi wudhu.” ");
INSERT INTO lwo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Batien gihn ni arumo e Piihter Jeacuu abeehne ke ne peehnyo kea, “Ruohdh ucaale gihn ni, arobi ke yihr wan, wa keed wane ne wale ngo arobi ke yihr nyoge cang?” ");
INSERT INTO lwo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Maa abeehr Jeacuue ngo kobe, “Kwaad ubaahng me ngihde e ne gaahn naa ngo ngaa me beer kedea giih nyepinye ngahye kaa gwiiro. Ubaahng me gaahn me beer wa gihn nu beehda ubaahng ateede yihre naa mage baahnge mooge beer mee kedea upaahnge caame paahngo yihr gen yi caang arob. ");
INSERT INTO lwo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Unahg gihn me beer keter yihr ubaahng tiihyo wa gihn nu, ge uyuud wur paaje ngo cahng uduue. ");
INSERT INTO lwo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Athiir e ne roba yihru, kejea ngad paajo cwihnye umihno keraahyo udhiile tiihj paajo cang ke cubo yi cing ubaahng nu. ");
INSERT INTO lwo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Abea nea ubaahng awii ngad paaje paare urube ke cwihnye kejea ngad paajo be laar duuo noono uthube ke goj baahng cuow kedea maahn giih awii yi cinge kedea pahdh ne yug giih cam maa giih maadh kuong umuohle muohl. ");
INSERT INTO lwo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Gihn nu, e cahng duu ngad paajo ukwihy ubaahnge ne weey weey, noono e ngad paajo naa lwaahd. Gihn nu e ngad paajo cwihnye urahnyo ne cohg ugooye ubaahng ce ngole ngo oogo kur yaa yihr gen toor yiiho. ");
INSERT INTO lwo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kwaad ngaa tiihyo yihr wur paaje me ngahy gihn daahd wur paaje yihre kejea tiihye ngo, abea kwihye kaa atiihyo ngo udhiil ke puohdo, udhohnge keehd atuuye me teeg. ");
INSERT INTO lwo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Abea nea ngaa tiihyo yihr wur paajo me kwihy gihn daahd wur paaje yihre, atiihy gihn me padh kare e ngo dhiil kaa ngwaahno upuohde now kaa nyaa atuuye me noog. Bang gihn kwaad ngaan acub ka me laaj yihre, beehda deeh ka me laaj thiow e naa gihn me peehny yihre. Lum yea kejea ngaan cub kwaad giih me thoohdh yihre mooge me thoohdh me yoohm muu anaa yihr ngaan acub me noog yihre ni gen nuu ucub yihre. ");
INSERT INTO lwo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“A abeehno beere gihn me wa maaj naa ahbo rog nyoge upiny kan beere maaj gihn a'ahba ni ne maah. ");
INSERT INTO lwo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","E thiow yihra ne raahm aduulo moogo muu uroomo keehd gihn me wa luogwahy. Abea beehda raahm me dhiila cidho kii ngo, udhiil kuohma raahm. Ke dhe yoohn nu e gihn ne yaa aduuna yi dwaar be piih nea padh maay rahmo yaa aduuna en naa ane bihj. ");
INSERT INTO lwo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Wudhu paru paro kejea a abeehn ne kahl doohr kiin nyoge wiih piny kan ne? Gahng! Dhiila kaa robo yihru kejea, gihn abeehna ke nyinge beehda ne paahng kiin nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Arumo thube wa kaa awaahn ni uwahdhe cahng moogo, e nyoge abiihj, me ne paajo acielo, rog gen upaahng gene ne dahg. Nyoge adahg ge upaahr rog nyoge ariow kedea nyoge ariow ge upaahr rog yaa adahg ni. ");
INSERT INTO lwo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Paajo acielo yea upaahnge ubeehn wuro upaahre rih waahde kedea upaahr waahde rih wahn. Dhaar beehda miiho, udog rih nyaare kedea nyaakow udog rih men. E miih dhecuow udog rih ciih waahde e ciih waahd udog rih wong, miih cuore. ");
INSERT INTO lwo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","“Yaage nea poohlo kii maalo aniidu, e ree tihnge kaa goan kun kwaar cahng piny kii ngo, ngahda e ngo guo kaa ngeyo, urub nyoge kejea kodh ucwiie ne? Gihn nu e kodh dhiil cwii. ");
INSERT INTO lwo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Thiow keehdo, nea yamo beehn kaa kun moohl cahng kii ngo ni, ngahda e ke robo kejea piny uleehdho ne? Gihn nu e piny dhiil leehdho. ");
INSERT INTO lwo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jo thuudh yej! Kwaad giih yug rog gen ke bang upiny ni kedea kwaad muu yug rog gen ke bang yi maalo ge ngahyu kaa kwaano beer mee. Abea arumo muu yug rog gen yihru, yi caang awaahn ni, ge goohg yihru ke ngeyo ubahnge ge be kwaanu ke ne diih? ");
INSERT INTO lwo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Gihn keree, e naa agoohg kar ngej gihn maa athiire yihru? ");
INSERT INTO lwo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kaano cidhu keehd ngaa amag wun nyum ruohdh daahdu dhe yooh me doohru keehd ngaan nu, e wu poohd kii yooh beere wu be kedh nyum ruohdh kedea ubeehn ruohdhe ucube wun yihr jaabidh kedea ubeehn jaabidhe keehdo, ukedhe wun yi thijin. ");
INSERT INTO lwo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Roba robo yihru kejea kar beehnu oogo keehdo utooro, nea padh gihn akihm yihru e ne dhiilu ke cub piny utoor gihn me doohng oogo.” ");
INSERT INTO lwo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nyoge mooge anudo maa ateed ngo yihr Jeacuu kejea Pilaato rem yaa Gaalili mooge maa anahg, ge alyaahbe keehd rem giih kweehr naa anaa anahg piny yihr Juog. ");
INSERT INTO lwo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","E gihn nu abeehr Jeacuue yihr gen arumo kobe, “Maru cuohnu kejea pahdho yi gihn me raaj beehda ke nying gihn acier Juog ne? Noono arumo kobu gihn anaa apahdh wudh goan yaa Gaalili ni nyoadh ngo kejea ge anahg nyoge me reje keew yaa Gaalili ne? ");
INSERT INTO lwo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Teeda teedo yihru, ngo padh ne maano. Abea gihn nud nea cwihnyu be duogu ke caahn bang anyoohne giihu naa atiihyu rih Juog e keehd wun thiow e wu dhiil thoo ke karu noono cang. ");
INSERT INTO lwo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Wale ka moogo wudhu aparu thiow kejea, yaa apaar wonge abiihjbedahg giih anaa atoor peehm me baahre wudh gen ni nyoadh ngo kejea ge anahg nyoge me reje ne puudh ukaal gene wudh yaa anaa abeed geen Jeruucalem cang ne? ");
INSERT INTO lwo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Teeda teedo yihru, ngo padh ne maano! Abea gihn nud nea cwihnyu be duogu ke caahn bang anyoohne giihu naa atiihyu rih Juog e keehd wun thiow e wu udhiil thoo ke karu noon cang.” ");
INSERT INTO lwo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Batiene e Jeacuu ucaale gihn abeehne ke ne robo yihr nyoge kobe, “Coon umodho anudo ke dhaano me yihre anaa dhuuro maa anaa yi puohdhe. Cahng ni e ngo acaa yi puohdhe ne maany dhuuro wale ngo anyuol keehd nyethen. Abea naa acea ne cidho e bahng nyethen maa ayoade wiih yaadh gihn ni. ");
INSERT INTO lwo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gihn nu e ngo arobe yihr ngad tiihj gihre kea, ‘Ke kar run adahg, e a beehn yi puohdho ne maany dhuuro wale maa anyuole keehd nyethen. Abea kihde now, nyethen ge be yoada wiihe. Nea wa gihn nu e kea ngod ngo piny, bang gihn ngo nyaahg piny ke dhieny now!’ ");
INSERT INTO lwo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Maa abeehr ngad tiihje ngo yihr wur puohdho kobe, ‘Wii ngo yihra tudi ke wong acielo. A utiihyo ree, thare ukaah, uoja ngoom me beey thare thiow. ");
INSERT INTO lwo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nea ngo unyuol ke caahngo arumo, e ngo poohd unahg gihn me beer. Tooro nea ngo buu unyuol e ungod piny.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Cahng Cabadh man keehdo, e Jeacuu anaa ake puohnyo yi wod amaad. ");
INSERT INTO lwo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Batiene e dhaago moogo anudo thiow kaano maa abaahl me ree naa atiihb ukeehge. Dhaar ni abeehdo e abeehl ke kar run apaar wonge abiihjbedahg. Dhaar nu anaa abeehdo e koohre ree adole. ");
INSERT INTO lwo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Naa aniid Jeacuue ngo e dhaar ni acuohne ke bange maa arube kejea nyiihnge ree wong maalo. Gihn nu naa abeehn dhaar arumo e ngo ake rubo yihre kea, “Dhaare! Yih alunya oogo yi atwaanyi noono!” ");
INSERT INTO lwo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Batiene maa apiehl Jeacuue cinge wiih dhaar arumo. Ke wong kaano e koohre ree ariihye riihyo udoohnge ne cad cad. Maa amuohj dhaar ni koohr Juog keter. ");
INSERT INTO lwo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","E ruohdh wod amaad cwihnye ake rahnyo bang naa niide ngo e Jeacuu dhaano athiehdhe cahng Cabadh ke ngude. Arumo e ngo ake rubo yihr nyoge naa amahdo kobe, “Yaage beehda nihn abiihjbeciel keede ge naa giih tiihy nyoge yihdh gen. Ke nying gihn nu e ke na beehn nyoge ke yihdh nihn giih ni keed gen, beere nea ngaan daahd uthiehdhe e ngo ke thiehdho yihdh gen, abea padh cahng Cabadh.” ");
INSERT INTO lwo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","E abeehr Jeacuue beehro yihr nyin kea, “Kwaad ka me nahgu yaa thuudh yej kii ngo! Wu kang rogu kobu wu naa nyoge me beeye! Ngaa kiin nu e ne be lony tuud gihre wale akaja gihre cahng Cabadh, ukedhe ngo naam ne maadh? ");
INSERT INTO lwo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Abea maanyu dhaar ni beehda nyaar Abraahm ke ngude, anaa atuohy atiihb ukeehge piny keehd kar run apaar wonge abiihjbedahg. Beehda kwaad gihn noono mahne kejea keá luny oogo yi cing ruohdh atiihb ukeehg, keehd ne kobe kejea beehda cahng Cabadh?” ");
INSERT INTO lwo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Naa arob Jeacuue gihn ni, e yaa anahg yaa ater keehde rog gen aniid gene e ge aduoge caahn ke dhe yoohn kaano abeehre ngo. Abea keehd maano e nyoge cwihny ge ake mihno ne cohg ke nying kwaad giih thoohdh beey naa yug Jeacuue. ");
INSERT INTO lwo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kaano arumo e Jeacuu ake rubo e upeehyo kobe, “Dhaahr Juog neehn gihn? Kedea ngo uroma kaa gihn? ");
INSERT INTO lwo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ngo uroma keehd wong jaaro ge thiin maa akaab dhaane upiidhe ngo yi puohdhe. Gihn nu e adoongo duohng mee, ubeehn baahde ukaar gene. Kaano e winy wuud gen geer gene ke wiihe.” ");
INSERT INTO lwo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Keehdo e Jeacuu acahg rob ke piehj kobe, “Dhaahr Juog ucahga rom rih kwaad gihn me ngihde? ");
INSERT INTO lwo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dhaahr Juog neehn thobe maa akaab dhaage ulyaahbe ngo keehd deeh moo ce bihle ngo. Nea wahdh caahn e deeh mog abihl yaahny maalo cang.” ");
INSERT INTO lwo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Batien gihn nu e Jeacuu ake aay e caa geen Jeruucalem e caahdh e cor yihdh geedhe kedea miehr mooge. Anaa acaahdho e ngo upuohnyo. ");
INSERT INTO lwo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kaano keehdo e dhaano moogo Jeacuu apeehnye kobe, “Ruohdh! Unahg nyoge me noog ge naa yaa ubodh cog ne?” E Jeacuu ake rubo kaano keehd nyoge cang kea, ");
INSERT INTO lwo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Dhiila kaa robo yihru kejea beehn dhaane dhiile gihr ameen meeni ke yugo, beere ngaan ngo kare nud yihre ucidhe ke dhe wod gihn diiny ni. Bang gihn beehda athiir e ne roba yihru kejea nyoge me thoohdh, ge daahd cidho keehd dhe wod gihn diiny ni. Gihn nu utum gene abea ugoohg yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ge ubeehn wur paaje ne aj maalo utoage dhe wode, e maru unahg yi kala e nuu ucuungu yea. Noono ubuohju ke tuong dhe wod, e wu kway wonge kejea, ‘Yab dhe wod yihr wan!’ “Abea wur paajo urubo yihru e nii wod alongthihn kobe, ‘Wu nyoge me kwihya. E thiow kun abeehnu kii ngo kwihya.’ ");
INSERT INTO lwo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Batiene keehdo ucahgu ke duogo yihre kobu, ‘Beehda wan ge anaa ne cam ke yihn kedea beehda wan naa anaa ake mahdho tiehd keehd yihn. Wa yih ngaa me ngahy wane, ngahda yihn naa ke puohnyo ke bang yihdh geedhe giih wan ne?’ ");
INSERT INTO lwo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“E ngo ucahge ke beehro yihru kea, ‘Wu nyoge me kwihya ne weey weey. Aayu! Coohru rogu oogo buuda kan. Wu nyoge me reje!’ ");
INSERT INTO lwo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Kaano arumo e wu uyuog ke lan ngoohng wong e lagu kaanyu kaanyo ke nying raahm, ge uniidu Abraahm kedea Yijaag maa Jeakob kedea wuohdjuog, e ge apiih ke med cwihny yi Dhaahr Juog. Abea wu arumo rogu uyoadu e wu athoohr oogo yi kala. ");
INSERT INTO lwo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Thiow nyoge mooge ge ubeehn e ge beehn kaa yoohn kun moohl cahng kii ngo kedea kun kwaar cahng piny kii ngo. E mooge ge ubeehn ke kur nyum piny kedea kur thar piny. Noono e kar piih gihr gen uyoad gene kar cam yaay yi Dhaahr Juog. ");
INSERT INTO lwo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Batiene arumo e yaa anahg nyoge maa yaa dhe caahn now, ge nuu udoohng ne yaa wong maalo. Abea jo muu anahg yaa wong maalo, ge nuu udoohng ne yaa dhe caahn.” ");
INSERT INTO lwo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Cahng ni thiow keehdo e yaa Paarijea mooge ge anaa abeehn bang Jeacuu maa arub gene yihre kob gene, “Nyieh aay oogo kan ucidhi ka moogo! Kwihyi kejea Ruohdh Eroade daahd yihn ke naah ne?” ");
INSERT INTO lwo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","E gihn nu abeehr Jeacuue beehro yihr gen kobe, “Cidhu ucuu ngo ne robo yihr thooh gihn nu kejea, a bar maalo ke riem atiihb ukeehge oogo rog nyoge. E thiow robu ngo yihre dahng kejea, abar maalo ke thiehdh nyoge tihn kedea keroo. Abea nea yi dahw nihn e gihn anaa atiihya ke nyinge kare udoohda. ");
INSERT INTO lwo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Beehda kaa ngo ne cohg, kejea a dhiil bar maalo keehd tiihya tihn kedea keroo, uwahdhe kihr kihnyo thiow. Beehda kare ne cohg kejea ngad agamloohngjuog wa an ka me thowe dom now tooro nea padh yi buur geen Jeruucalem e ne thowe yea.” Gihn nu e Jeacuu ake rubo kobe, ");
INSERT INTO lwo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yih geen Jeruucalem! Yaa agamloohngjuog ge anahgi kedea yaa aoohr Juoge yihri ge abahni ke leele! A abuohj tiel me thoohdh kaa a koal yaai thaahdh baahda wa gihr jieno me boab nyethene. Abea kihde now yih akweer ke an ne weey weey. ");
INSERT INTO lwo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Maahnyu kaa awii wod Juog piny. Awaahn kan, kihda buu ucahgi ke niido keehdo uwahdhe cahng ukoohbi kejea, ‘Juog cedhree dooj ngaan abeehn ne rob ke nying Juog Ruohdh.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Cahng man Jeacuu anaa ne cam paar ngad Paarijea me beehda ngaa moogo thiow me duohng kiin Paarijea. Kaano e Paarijea naa anudo nying gen anaa dihng gene rih Jeacuu ne boar Jeacuu ke gihn utiihye. ");
INSERT INTO lwo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","E nyin moogo anaa apiih nyum Jeacuu me ree anaa atwaany bungbung. ");
INSERT INTO lwo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Batiene e Jeacuu yaa apuohny keehd luub yi loohng kedea yaa Paarijea ge apeehnye peehnyo kejea, “Beehda kare, ke dhe yoohn loohng gihr paaro uthiehdh dhaano cahng Cabadh ne wale padh kare?” ");
INSERT INTO lwo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Gihn nu maa aleng gene ne caaj e gihn maa abeehr gene tooro. Arumo e Jeacuu nyin atwaany ni amage maa uthiehdhe ngo uoohre ngo oogo. ");
INSERT INTO lwo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Keehdo e Jeacuu ge acahge kaa apeehnyo kobe, “Nea dhaano acielo kiinu yihre ne nyethiine wale muore maa apahdho yaa abuulo cahng Cabadh, e ngo be teehle oogo piow piow ke nying gihn nahge cahng Cabadh ne?” ");
INSERT INTO lwo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dahng gihn maa abeehr gene tooro yihr Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Batiene kaano e Jeacuu abar maalo ke rob, bang gihn dhe yoohn kaa anaa piih yaa anaa acuohn kar cam aboare. Bang gihn aniide naa beehn nyoge, e kuohn piih giih beey ni gen naa apeem gene ke rog gen. Arumo maa arobe ngo yihr gen keehd dhe yoohn ucaale kobe, ");
INSERT INTO lwo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Yaage lihngu gihn! Nea ngaa moogo dhaano acuohne paare bang nyuohm naa ayuge paajo yihre, e dhaano keá moon piny ke kwany kuohn piih maa awuobe. Bang gihn kwihy dhaane kejea moogo e ngad paajo dhaano moogo me wiihe ne maalo yihr ngaan nu acuohne thiow. ");
INSERT INTO lwo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","E gihn nu arumo e ngad paajo naa acuohn gen kar gen noon ni ariow ni, caa ne beehno keehd ngade gen arumo, ce rube keehd ngaa man kejea, ‘Cub kar piih gihn apiihi yea, yihr ngada gen.’ Batiene e ngaan nu aj maalo kare noono udae ka moogo ke laahy wihj kedea e guohbe ayaahr thiow. ");
INSERT INTO lwo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Abea nea beehda kaa ngo ne cohg, kejea dhaano nyoge acuohne kar cam naa ayug bang cahng nyuohm e ge beehn dhaane kuonge piih ka me ne bihdh now tudi. Arumo batiene nea ngad paajo caa ne beehno e urubo keehd ngo kejea, ‘Goma! Beehn wong maalo kan ne piih.’ Kaano e wiih ngaan ngo udoohng mor nyum nyoge naa apiih kaano cang. ");
INSERT INTO lwo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bang gihn kwaad ngaan cub cwihnye yi daahd ruohdh ke nying yoad gihn me beer, e ngaan nu ree uyoade ne dhaano now me gihn me ne yihre tooro. Abea ngaan yug ree ne dhaano now, e ngaan nu ree uyoade ne ruohdh uyoade gihn me beer.” ");
INSERT INTO lwo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Gihn nu arumo e Jeacuu adog ne rob ke nying ngad paajo naa agoong nyoge kobe, “Abea yih ngad paajo nea beehda gihn me yih daahde ucuohni nyoge paari wiih cam maa ayugi, e yih keá cuohn gome wale nyoge maa awaahde keehd yihn wale nyoge maa alony. ");
INSERT INTO lwo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Abea nea kare ne cohg, kejea yih daahde uyugi cam paari yihr nyoge e kea cuohni ke nyoge maa angoohng kedea nyoge me tien ge atug, yaa tien ge angool maa kwaad yaa nying ge acoor ni, gen naa yaa dhiili ke cuohno noono. ");
INSERT INTO lwo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nea ngo ayugi wa gihn nu, e yih nuu nahg ngaa maa adooj Juoge. Bang gihn yaa angoohng wa gihn, gihn muu uyoadi bang gen muu ucub gene yihri tooro, ne duu wiih gihri naa agoongi gen. Abea cahng ucahr yaa beey ni, goong gihri noono agoongi gen nu wiihe uduu Juoge.” ");
INSERT INTO lwo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Naa lihng nyin moogo maa anaa apiih kar cam gihn arob Jeacuue, e ake rubo kea, “Mihn cwihny beehda gihr ngaan ucam amono yi dhaahr Juog!” ");
INSERT INTO lwo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jeacuu ake rubo e beehr gihr nyin keehd ucaale kobe, “Coon umodho nyin moogo anaa anudo maa anaa ayug cam me duohng mee paare. Maa acuohne nyoge me thoohdh bang cam naa ayuge kejea beehn gene. ");
INSERT INTO lwo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Naa aniide ngo e cam athum ke gwiiro e ngad tiihj gihre aoohre ke bang yaa anaa acuohne, kejea beehn gene bang gihn cam agwiir ree. ");
INSERT INTO lwo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Gihn nu yaa anaa arob lubo yihr gen, rog gen ajaahy gene jaahyo naa acielo acielo kejea kar beehno tooro yihr gen. Maa arub ngad umodhe yihr ngad tiihj naa oohr kejea, ‘Nyieh, kare tooro yihra me beehna. Puohdho angeewa kedea a dhiil cidho ne maanye. Cedhree! Nea kare nud kea meehga jaahy riha.’ ");
INSERT INTO lwo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ngaa man keehdo acahg rob kejea, ‘Nyieh, kar beehna tooro, bang gihn a angeehwo keehd miohre maa areehg naa riow me teehng ge abiihj giih ywaaj arabya gihn kahg piny keehde. Noono adaahde ucaa ne tum gen yi puohdho. Cedhree! Nea kare nud kea meehga jaahy riha.’ ");
INSERT INTO lwo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Nyin moogo acahg rob keehdo yihr nyin kejea, ‘An noon ni dhaago akahla paajo ke tihn. Nea kare nud e kea meehga jaahy riha.’ ");
INSERT INTO lwo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Batiene arumo maa aduu ngad tiihje ne rob gihn ayug ree yihr ngad paajo. Gihn nu e ngad paajo cwihnye ake rahnyo ke nying gihn ni ayug yaa ni ree. Noono ukobe ngo yihr ngad tiihye kea, ‘Laar cidho piow piow ke bang yihdh acaare kedea ke bang yihdh yiehdhe giih keew miehr, kahl kwaad nyoge maa ngoohng maa ayoadi now, yaa tien gen atug ni kedea muu tien gen angool maa muu nying gen acoor.’ ");
INSERT INTO lwo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Naa beehn ngad tiihje keehd nyoge, e ngo acaa ne rob keehd ngad paajo arumo kobe, ‘Ruohdh! Gihn arobi yihra atiihya wa kaa ngo. Nyoge abeehno abea piny poohd kuu aromo keehd nyoge bang gihn nyoge noog.’ ");
INSERT INTO lwo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Batiene dahng e ngad paajo acahg rob keehd ngad tiihj gihre kobe, ‘Doogi keehdo ucidhi ke bang yihdh acaare kedea ke bang yihdh yiehdhe giih caadh cang kwaad ngaa ayoadi now beehn ke ngo. Bang gihn adaahde upahng paara keehd nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngahyu ngo kejea keew yaa anaa acuohna dhaano acielo kiin gen muu cahg cam mara naa agwiira ke belo utooro.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cahng man e amahr nyoge ge anaa ake caahdho tiehd keehd Jeacuu. Batiene e Jeacuu wiihe aloge ke bang gen maa arube kobe, ");
INSERT INTO lwo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yaage, aroba yihru kejea ngaa daahd udoohnge ne ngad batiena abea wahn, men, ciihe, nyethene, wuud men ke ge nyemen kedea keehd wahye be maane, e kare tooro yihre unahge ngad batiena. ");
INSERT INTO lwo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kwaad dhaano now me cwihnye tooro uthowe ke nyinga wiih yaadh maa ariihw, e ngaan nu padh ngad batiena ne weey weey. ");
INSERT INTO lwo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nea dhaano kiinu cwihnye ne geer wod maalo baahr mee ngahda e ngo kuong piih umodho, umaahnye ka ukaab wode yihre ke geero ne? Kedea kuong piih umodho bang ne ngahy ngo nea giih ne yihre wod rom gene kaa ageero e gihn me daag tooro. ");
INSERT INTO lwo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bang gihn nea ge cea ne thubo keehd geer arumo ni, e ree cea ke ne yoado kejea wod ree be thume ke geero yihre. Gihn nu e kwaad yaa anaa niide e ngo thubo ke geer ni, ngo ngier gene ngiero. ");
INSERT INTO lwo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Batiene e nyoge rom rob ree kejea, ‘Wa nyin wod anaa anahg gihn maa athobe beer mee ke geero abea awaahn ni maahnyu kaa ariehny wod piny yihre ke geero.’ ");
INSERT INTO lwo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Thiow roma kaa robo ke dhe yooh moogo kejea beehda kwaad ruohdh me ngihde noono, ne daahd aay kea e caa ne lor ruohdh moogo me teehng wiihe ke liny, abea wiihe be kuonge ke coaro umodho? Wiihe kuonge kaa coar umodho nea kare nud yihre me rome ruohdh teehng wiihe keehd acaakere kar alihbe dhaano aduuno ge taaye taayo, abea yihre naa acaakere alihbe apaar cog. ");
INSERT INTO lwo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nea kare tooro me rome teehng e ngo ukwahnyo keehd nyoge me oohre bang ruohdh teehng wiihe maano e ngo poohd ne ka me baahr beere ge udoohr. ");
INSERT INTO lwo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Thiow keehd dhe yoohn nu, nea kwaad dhaano now me nud kiinu, me daahd ngo ubeehne batiena, ubahnge kwaad giih ne yihre cang ge be gweeye ke piny cang ke nyinga, e ngaan nu buu unahg ngada. ");
INSERT INTO lwo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Melo beehda gihn me beer. Abea nea ngo abahnho e be rom ke yugo law keehdo. ");
INSERT INTO lwo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gihn me kony melo gihn nu tooro. Keehd puohdho maa ayiide be wele. Ngo ngweehn cog kaa woj dom. Kea noono ya! Yabu yihdhu, nea ngaa me yihdhe nud me lihngo e kea lihnge!” ");
INSERT INTO lwo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Cahng man e yaa gwaay cuol kedea ‘nyoge maa awaadh paaje’ ge anaa abeehn bang Jeacuu ne lihng giih robe. ");
INSERT INTO lwo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Arumo e Paarijea kedea yaa loohng ge ake ngoan ke cwihny gen kob gene, “Nyin mare koag kaa goong yaa anyoohne now kedea nyoge maa awaadh paaje ge naa yaa ayuge ne yaae ne cahme keehd gen.” ");
INSERT INTO lwo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Gihn nu e Jeacuu ucaale gihn abeehne ke ne robo yihr gen: ");
INSERT INTO lwo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Yaage! Nea dhaano acielo kiin nu, yihre ne roome jiehabiihj ubeehn aciele urwaahnye kiin gen, ngahda e goan muu nu ge wiie ke kaano ucea ne daahd acien man arwaahnyo? Ngo dhiile kaa daahdo uwahdhe ka uyoade ngo. ");
INSERT INTO lwo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Abea ge cea ngo ne yoado arumo, ngahda e ngo thoohre kuu utoge ubiene ngo e cwihnye amihno ne? ");
INSERT INTO lwo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Batiene ge beehne paajo keehd ngo, e caa ne cuohn gome kedea yaa wong akeewo kedea urobe ngo yihr gen kea, ‘Yaage! A daahd umihn cwihnyu keehd an tiehd, bang gihn roomo gihra naa arwaahnyo ngo ayoada.’ ");
INSERT INTO lwo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Roba robo yihru, uneehn gihn nu thiow Paar Maalo. Juog cwihnye umihn keter, ke nying dhaano acielo maa aduu cwihnye caahn bang anyoohne giihe. Abea mihn cwihny maa athiir utooro ke nying nyoge jiehangween wonge apaar wonge abiihj bengween maa akweer ke duu cwihny gen caahn rog anyoohne giih gen. ");
INSERT INTO lwo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Thiow dhaago anudo me yihre anaa nying ngiihny apaar giih demaro. Maa abeehn aciele urwaahnye. Batiene e dhaar ni maaj ameenye meenyo maa adhiile yi wod ke cwado beer mee ne cohg e daahd wong demaro gihn ni. Maa ubuohje ke daahd ngo uwahdhe kaa dhiile ngo ke yoado. ");
INSERT INTO lwo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Batiene e gome kedea yaa wong akeew giihe ge acuohne urobe ngo yihr gen kobe, ‘Yaage! A daahd umihn cwihnyu keehd an tiehd bang gihn wong demaro gihra acielo naa arwaahnyo ngo ayoada.’ ");
INSERT INTO lwo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Roba robo yihru, uneehn gihn nu thiow wuohdjuog cwihny gen umihni keter ke nying dhaano acielo maa ngaa me raaj, abea cwihnye aduoge caahn bang anyoohne giihe.” ");
INSERT INTO lwo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Muudhe Jeacuu abar maalo ke rob kea, “Umodho coon dhaano moogo anaa nudo me yihre anaa waahd ariow. ");
INSERT INTO lwo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Cahng man arumo e ngaan thiin ake rubo yihr wahn kobe, ‘Abaa! Paahng yihdh giih paajo yihr wan keehd umiiha ucubi kura yihra.’ Batiene arumo e wur gen yihdh giih paajo ge apaahnge paahngo yihr gen keehd umen. ");
INSERT INTO lwo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Naa apaahng wur gene yihdh giih nyepinye, e batien nihn me noog, e nyedhooh thiin, giihe ge aconge congo cang uaaye ne ci paajo moogo maa anaa ka me baahr. Yi paan nu e ngiihny giihe ge araanye ke dhe yooh me raaj mee. ");
INSERT INTO lwo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Muudhe naa athum ngiihny yihre cang e kahj me duohng apahdh yi paan ni cang maa angoohnge keter. ");
INSERT INTO lwo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kaano e aci ne daahd tiihj bang ngad paan ni. Gihn nu e tiihj kwaag kudhruue e naa acub yihre. ");
INSERT INTO lwo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Maa abang kahje nyedhoohg keter bang gihn ngaa me cub cam yihre tooro. Cam mar kudhruue e naa gihn ne muodhe ree keehd ngo abea e poohd be yahng. ");
INSERT INTO lwo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Gihn nu naa aniide ngo e apiih ne rob ke cwihnye e keede kobe, ‘Amahr yaa tiihy yihr wura caame athooj ke nying gen now, adhaahr caame ge doohng piny. Abea a ge thow dom kan keehd kahj ni! ");
INSERT INTO lwo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ngweehn me dhiila doo bang wura paajo ucaa ne robe yihre kejea Abaa! Gihn me raaj keter e naa ayuga rihi nyum Juog! ");
INSERT INTO lwo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ke nying gihn nu e a keá cahg ke cuohno keehdo ne waahdi, abea yug an ne ngaa me tiihy yihri now.’ ");
INSERT INTO lwo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Batien gihn nu arumo e ree akwanye ke maalo uthube thubo ke waahdh e beehn paajo. “Abea e apoohde e ngo ne ka me baahr mee, e amodh wahne modho maa ayuohd cwihnye ree keter. Noono ugoohde ke bang waahde maa agaahre ngo yi koohre e ngo ciime ciimo. ");
INSERT INTO lwo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“E nyedhoohg ake rubo yihr wahn kobe, ‘Abaa! Gihn me raaj keter e naa ayuga rihi nyum Juog. Gihr nyinga tooro keehdo me cahgi an ke cuohno ne waahdi.’ ");
INSERT INTO lwo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Abea keehd maano e wahn arob ngo yihr yaa tiihj giihe kobe, ‘Yaage laaru goohd paajo piow piow ukahlu kihd waaro gihn awuob keter ni. Beehnu keehd ngo ungaabu ngo ree. Kedea codu joadh yi lweede, ungaabu wuor yi tiene thiow. ");
INSERT INTO lwo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Thiow cidhu, ukahlu muor gihn acwaadh ni. Nahgu ngo bang gihn tihn wo dhiil cam umielo e cwihnyo amihno. ");
INSERT INTO lwo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bang gihn waahda gen anaa ke roomo yihra wa nyethiin maa anaa athow, abea awaahn ni aduu banga e ngo kuow.’ Gihn nu arumo nyoge ake cahmo, umiel gene umihn cwihny gene keter. ");
INSERT INTO lwo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Muudhe nye kaano anaa awahnh nyedhoohge paajo nu, e umen ge duohng yihre ni anaa yi puohdho. Naa awahnhe dhe paajo, e doohn nyoge alihnge lihngo e nyoge ukwaago kedea e nyoge uwahr maa e ge anaa ake miel thiow. ");
INSERT INTO lwo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Gihn nu e ngad tiihj acielo kiin yaa tiihj giih paajo acuohne cuohno maa apeehnye ngo ke gihn yug ree paajo. ");
INSERT INTO lwo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Maa abeehr ngad tiihje ngo yihre kea, ‘Umiihu e naa aduu paajo. Ubeehn wuru unahge muor gihn acwaadh bang gihn kea umiihu aduu paajo ke yoohm ree e gihn me raaj me ne ree tooro thiow.’ ");
INSERT INTO lwo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nyin cwihnye ake rahnyo ukweere ke bar paajo. Maa abeehn wahne oogo bange urub wahne yihre e kway wong ngo thiow. ");
INSERT INTO lwo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Batiene e gihn nu akway wahn wonge nu, e ngo ake rubo yihr wahn arumo kobe, ‘Abaa maahny kaa atiihya yihri ke run ni cang abea bahng cahng acielo maa adhahla yea gihri. Bekihd cahng acielo maa acubi nyethiin diel ucweda ngo keehd goma ubeehn cwihny wan umihne thiow! ");
INSERT INTO lwo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Abea naa aduu waahdi ge araany giihi urwaahnye gen rog ajabe, e muor gihn acwaadh, e naa anahgi ke nyinge!’ ");
INSERT INTO lwo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Maa arub wahne keehd ngo kobe, ‘Nye waahda gihn! Wa yih beed paajo tiehd keehd an. Ngahda giih ne yihra cang kan ge beehda giih cang ne? ");
INSERT INTO lwo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ngahda beehda gihn maa kare ne cohg nye waahda, kejea nyoge ne dhiil miel umihn cwihny gene ne? Bang gihn umiihu gen anaa ake roomo yihra wa nyethiin maa anaa athow, abea awaahn ni aduu banga e kuow e thiow anaa anahg ngaa maa anaa arwaahnyo abea e noono ayoad arumo nu.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jeacuu acahg rob keehd jo waahdhe kobe, “Coon nyin moogo maa anaa alony anaa nudo me yihre anaa ngad maang nyepinye giihe. Maa aluom nyin yihre kejea ngo beehda ngaa muu utuuo ke giihe. ");
INSERT INTO lwo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Batiene e nyin abeehne ne cuohno urube keehd ngo kobe, ‘Nye baa gihn noono lihnga ke nyingi nu? Alihnga kejea yih utuuo ke giiha. Nea wa gihn nu e kea kahl akweehn yihra uniida ka maangi giiha kii ngo. Awaahn ni yih buu cahg bar maalo ke tiihy maang nyepinye giiha keehdo.’ ");
INSERT INTO lwo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Muudhe e nyin adoo ne rob ke cwihnye keede kobe, ‘Awaahn ni dhaano utiihy gihn? Bang gihn aniida awaahn ni kejea tiihya ge nahga ngad maang nyepinye ni, kahl ngaan tiihya yihre ke oogo yi cinga. Abea a padh ngaa me teeg. Tiihj me peeg me wa puur me roma ke leehwo tooro. Thiow nea a tum udoohnga ne ngad kwaj ke bang yihdh miehy nyoge e kuohma uyaahr. ");
INSERT INTO lwo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Gihn daahda ke tiihyo naa apara e gen! Beere nea a beehn oogo yi tiihya arumo, e ge ucaa yihdh miehy nyoge e a ungahy gene kaa kaahno ugoong gene an thiow.’ ");
INSERT INTO lwo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Batiene, e yaa akaab amihdho bang nyin tiihye yihr ngo ge acuohne bange naa acielo acielo maa athube ke peehny gen. Maa apeehnye ngad umodho naa abeehno kobe, ‘Nyieh kar ka me ngihde e naa magi naa amihdho yihr ngaan tiihya yihre ni?’ ");
INSERT INTO lwo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Nyin ake rubo kejea, ‘Yihra ne kar barmiihle jiehabiihje bedahg naa giih amaga naa amihdho.’ “Maa akoohb ngad maang nyepinye yihr nyin kea, ‘Akweehn mari gen, piih buuda kan lay cingi ugweedi gen ne jiehabiihje angween cog.’ ");
INSERT INTO lwo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ngo acahg rob keehd ngad batiene kobe, ‘Yihri naa adiih naa amagi naa amihdho?’ “Kob nyin kea, ‘Yihra ne kar cuole jiehabiihje apaar ke mog gema naa akaaba naa amihdho.’ “Kob ngad maang nyepinye yihre kejea, ‘Akweehn mari gen gweed ngo piny kejea ge jiehabiihje abiihjbedahg cog naa akaabi naa amihdho.’ ");
INSERT INTO lwo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Batien gihn nu arumo naa alihng ngad paaje ngo e nyin aleeye leeyo keehd maano kobe kejea anahg ngaa maa atuug keehd giihe naa araanye umodho nu. Yaa upiny kan yihr gen ne waane keter yihr yaa beehda nyethen Juog. ");
INSERT INTO lwo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Gihn daahda noono ke teedo yihru kejea kony dhaane nyoge mooge keehd giih ungoom kan me ne yihre. Beere nea dhe yoohn gen agug arumo upiny kan, e gihr nying gen, ci dhaane ke ne yoado wong maalo yihre kun caadi paar Juog ka me giih yea ge padh giih me gug. ");
INSERT INTO lwo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Kwaad ngaan cub cwihnye ne mag nye giih ni, me doonge ge rome kaa maango thiow. E keehdo kwaad ngaan gwaay keehd giih thene ni, ugwaay thiow keehd giih doong nuu acub yi cinge. ");
INSERT INTO lwo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Abea noono arumo, nea nye muu ukuom kan ge agoohg yihr dhaano ke maango, e ngaa nu ucub muu beehda adiehr ne cohg yi cing ngaan nu. ");
INSERT INTO lwo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","E thiow nea kwaad man beehda mar ngaa moogo ni, agoohg yihri ke maa beer mee upiny kan, e ngad kee e nuu ucub mare ge poohd ne maalo yihri do? ");
INSERT INTO lwo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kare tooro utiihy kadaahme yihr nyoge ariow ke cwihnye acielo ne cohg. Bang gihn dhaano acielo kiin gen e nuu unhyaare kedea umaane ngaa moogo. Wale dhaano acielo e ne lum ngo wuore kedea ukweere ke wuor lum ngaa moogo. Wa gihn nu thiow kare tooro yihr dhaano unhyaare Juog kedea giih lonyo ke cwihnye acielo muu uroomo ne tog.” ");
INSERT INTO lwo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Muudhe arumo e yaa Paarijea, ge beehda kwaad nyoge thiow me nhyaar ngiihny ni, naa alihng gene gihn arob Jeacuue ni, e Jeacuu acwiid gene cwiido. ");
INSERT INTO lwo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","E Jeacuu ake rubo keehd gen kobe, “Wu beehda nyoge me wu kony rogu ke dhogu ke rob kejea wu beeyo nyum nyoge. Abea Juog keede e ne ngahy kwaad giih nii cwihny. Abea nyoge giih riem batien nyepinye giih tan nying nyoge upiny kan ge beehda giih me cwihny Juog laahm gene laahmo. ");
INSERT INTO lwo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Loohng Juog kedea puohny yaa agamloohngjuog, ge naa giih anaa ake robo noono uwahdhe nye wong kaa anaa abeehn Joone ni. Abea arumo ke kaa athube ke bang Joon kaano, e Ciig Beer e rubo ke nying ka beehn Juoge uyuge nyoge ne joe, ke puohnyo yihr nyoge. E thiow nyoge cang cwihny ge anaa uyuohd bang Ciig Beer ne tiihj ke tiihj me ne cohg beere ge udoohng ne nyoge maa ayug Juoge ne joe thiow. ");
INSERT INTO lwo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nea kare ne cohg e ngo gihn me yoohd keter ubeehn maale kedea piny ugug gene. Abea loohng beehde beed kare noono agweede nu e gihn me thiin me ruy oogo ree tooro udoohnge wa gihn me gihr nyinge tooro. ");
INSERT INTO lwo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kwaad ngaa riem ciihe kedea unyuome dhaago moogo e ngaan nu ayug adhemuohm muu uroomo kaa adhemuohm gihr ngaa maa akaab dhaago maa anyuom. E thiow nea kwaad ngaan kahl dhaago maa ariem paajo ubeehde keehd ngo, e ngaan nu ayug adhemuohm muu uroomo kaa adhemuohm gihr ngaa maa akaab dhaago maa anyuom. ");
INSERT INTO lwo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Dhaano moogo thiow anaa nudo maa anahg ngaa maa alony keter. E ngo anaa abeehdo e ngaab kwaad waare me ne mihl mihl kedea cam e naa mare ne tiihye paare. ");
INSERT INTO lwo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ngaa moogo thiow maa angoohng keter anaa anudo. Anaa abeehdo e ngo beed dhe oaj gihr nyin alony ni. Abea nying nyin anahg Laajoruj. Amahr kuon ka me ledhe ge anaa anyoor ke bang yi guohbe cang. ");
INSERT INTO lwo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Noono e Laajoruj anaa daahd ngo kea beere nye wey weye giih caame, naa apahdho piny thar tharbeajo ge ne cub yihre uguume kahye keehd gen. Thiow goohy pahdh rih Laajoruj unang gene nying ka me ledhe giihe nango. ");
INSERT INTO lwo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kaano arumo e Laajoruj abeehn ne thoo maa akaab wuohdjuoge ngo ukedh gene wahye ka me beer bang Abraahm. Thiin keehdo e nyin alony ake thoo thiow maa akedh wahye ka me raaj kar raahm kuohm paar maaj. ");
INSERT INTO lwo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Batiene arumo maa arahm kuohm nyine kwaade tooro. Abea e thoohr wonge e niid Abraahm e ngo ne ka maa acielo tiehd keehd Laajoruj. ");
INSERT INTO lwo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Gihn nu maa arube e cuohn Abraahm kobe, ‘Abraahm! Abaa Cedhree kony an! Oohr Laajoruj noono yihra ucode lweede acielo yi piih, beere duona yora yoro keehd gen. A adhaan yi kwaad deeh raahm maaj gihn kan ni!’ ");
INSERT INTO lwo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“E Abraahm ake rubo keehd nyin kobe, ‘Waahdo! Par wiihi ne kaa anaa abeehde upiny kii ngo. Mari yih anaa beed kari me beer keehd amahr giih lonyo yihri. Abea Laajoruj mare anahg ngad ngoohngo naa abeehde upiny. Abea awaahn ni, Laajoruj dhiil beehdo kare me ngej mee, abea yihn mari meen yih dhiil beehd kari noono nii yea nu. ");
INSERT INTO lwo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","E thiow wong akeewo me thuudh nud kiino keehd wun. Kare tooro me aay dhaane bang wan kan ucea bangu kun caadi. E kare tooro thiow me aay dhaane bangu kun caadi ubeehne bang wan kan.’ ");
INSERT INTO lwo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“E ngo acahg nyine kaa beehro yihr Abraahm kobe, ‘Cedhree! Nea wa gihn nu, abaa Abraahm, oohr Laajoruj paar wura. ");
INSERT INTO lwo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Bang gihn yihra ne wuud miiha kar ge abiihj kun caadi. Teed ngo yihr Laajoruj ucidhe ne toohn gen ne cohg, beere gen thiow ka me beehn gene kar raahm kan tooro.’ ");
INSERT INTO lwo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Kaano arumo e ngo acahg Abraahme kaa beehro yihr nyin keehdo kobe, ‘Ngahy ngo kejea giih rub kitaab Juoge ke nying gen ge ne bang ge wuud miihu kun caa. Giih rob kitaab Juoge ulihng gene kedea ge utoohn gene. Kare dhiil nudo ubeehn ge wuud miihu ulihng gene giih rob gene yihr gen nea cwihny gen ne bange.’ ");
INSERT INTO lwo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Maa acahg nyine ngo ke beehro keehdo yihr Abraahm kobe, ‘Abaa Abraahm! Gihn nu be rom gene ke yiiho. Daahd dhaano maa athow ucahre ne rob ngo yihr gen e kare nud me lihng gene gihn ngo uduu gene cwihny gen caahn bang anyoohne giih gen.’ ");
INSERT INTO lwo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kob Abraahme kea, ‘Nea giih teed kitaab Juoge naa agweed Moaje be lihng gene lihngo e gihr ngaa maa athow ucahre buu ulihng gene thiow.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kob Jeacuue yihr jo waahdhe, “Giih meehg nyoge pahdho yihdh giih me reje ge padh giih me rom rog gen gahlo. Abea unahg gihn me raaj ne waany yihr ngaa umeehg giih reje pahdho rog nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Adhaahr ngweehn me tuohj deeh leelo yi ngud ngaan nu uthoohre yi naam duohng yihr man meehge nyethiin wii luma maa ayiihe pahdh yi gihn me raaj. ");
INSERT INTO lwo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nea wa gihn nu kea koaru rogu beer mee! “E moogo thiow nea wadu me cahng keehd yihn, ayug gihn me raaj kea cuow ngo. Abea nea anyoohne noono ayiihe ree urahny cwihnye ke nyinge, kea wii ngo piny yihre. ");
INSERT INTO lwo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nea gihn me raaj ayuge rihi, keehd ne kobe kejea ayuge rihi tiel abiihjberiow bad cahng acielo, abea ge tiihye gihn me raaj e ngo beehn bangi uyiihe gihn raaj e ayuge rihi kedea urahny cwihnye ke nyinge, kea dhiili ngo ke wii piny yihre.” ");
INSERT INTO lwo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Maa akoohb jo waahdh Jeacuue, “Ngad Puohny jwag yiiho mar wan yi cwihny wan, udoohnge teeg!” ");
INSERT INTO lwo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","E gihn nu abeehr Jeacuue beehro yihr gen kobe, “Keehd me thiin yiiho gihru wa wong niino, e kare nud me robu ngo yihr yaadh me cuung wa acaag ne ca cuung nu kejea pudhe ree oogo ke bieye upiidhe ree yi diih naam duohng e gihn nu dhiil yaadhe kaa lihngo utiihye ngo. ");
INSERT INTO lwo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nea dhaano acielo kiinu, me yihre ne ngad tiihj me tiihy yi puohdho wale maa ngad kwaag roome aduu paajo arumo ke yoohn yi puohdho, e kare nud me rub ngad tiihye yihre kejea, ‘Nyieh! Beehn arumo ucahmi?’ ");
INSERT INTO lwo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nea kare ne cohg e ngaan tiihye yihre e ne kob ngo kea, ‘Nyieh gwiir cam mara umodho kedea piih ne koar an piny nye ka cahma kedea umahdha ni.’ ");
INSERT INTO lwo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bang gihn padh kare kejea ngaa maa ngad tiihj paajo koohre dhiil kaa muohyo ke nying tiihj gihn tiihye? ");
INSERT INTO lwo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Neehn ka bahnge koohr ngad tiihj paajo be muohj ke nying tiihye e wu thiow nea giih arob Juoge yihru ne tiihyo ge ayugu cang, e kea koohbu kejea, ‘Wa yaa tiihj now, gihr nying wan tooro. Gihn atiihy wane beehda tiihj me wan ne tiihy ngo.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jeacuu anaa wiih waahdhe e beehn geen Jeruucalem abea ngo akaahn kiin piny Camaarya keehd piny Gaalili. ");
INSERT INTO lwo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ge adoohnge cahng keehd paajo moogo ni, e ngo ake roohmo ne tieg keehd cuow apaar me rog gen naa dhoobo. Maa acuung gene ka me baahr ke Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Batiene e Jeacuu aluohng gene luohngo e doohn gen atihng gene maalo kob gene, “Jeacuu Ruohdh wan! Maahny kaa angoohng nying wane kii ngo do!” ");
INSERT INTO lwo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Naa aniid Jeacuue ngoohng nying gen, e ake rubo yihr gen kobe, “Beer kea noono cidhu unyoadhu rogu yihr yaa lam giih kweehr yihr Juog.” Gihn nu ge acaahdh gene caahdho e ngo aci gene ne yoado e dhoobo a'aay oogo rog gen beehde. ");
INSERT INTO lwo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kaano e dhaano acielo kiin gen, naa aniide ngo e dhoohbe a'aay oogo ree, e aduuo bang Jeacuu, e caahdh e muohj koohr Juog e duone atihnge maalo. ");
INSERT INTO lwo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Abea naa awahnhe bang Jeacuu, e ree athoohre ke thaahdh tien ngo. Nyin ngo thiow anahg ngad Camaarya. ");
INSERT INTO lwo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Maa apeehny Jeacuue ngo kobe, “Ngahda wu anahg nyoge apaar wu naa athiehdh ne? Abea nyoge abiihj bengween mooge ge naa kee? ");
INSERT INTO lwo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Keehd dhaano acielo keede now kiin gen me duu ne muohj koohr Juog tooro ne unahge kaa aley gihn e keede e naa aduuo ne muohj koohr Juog ne?” ");
INSERT INTO lwo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Maa arob Jeacuue ngo yihr ngad Camaarya kobe, “Aj maalo. Cidhi ke yoohni, yiiho mari naa nii cwihnyi e naa ayug kuohmi udoohnge cang mee.” ");
INSERT INTO lwo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Cahng man keehdo e Paarijea ge anaa ne peehny Jeacuu kob gene, “Beehn Juog ne Ruohdh beehn ke ne diih?” Maa abeehr Jeacuue ngo kobe, “Beehn Juog ne ruohdh be beehn e ngo uneehno yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wale thiow be beehn keehd dhe yooh me robe kedea unyoadhe kejea, ‘E aman kan ni,’ wale kejea, ‘E ne caad kun ca.’ Ree be yuge wa maano bang gihn beehn Juog naa yi cwihnyu kaano alongthihn.” ");
INSERT INTO lwo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Batiene maa akoohb Jeacuue yihr jo waahdhe kea, “Cahng muu uyuog cwihnyu ne cohg ubeehn. Udwaanu kejea keehd cahng acielo now e ne wii yihru uniidu ngo keew nihn beehna a ge adoohng ne dhaano utaahngo. Abea ngo buu uniidu ke nyingu. ");
INSERT INTO lwo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","E nyoge thiow ge urubo yihru kob gene, ‘Yaage cidhu kun ca e ne caad kun caa nu.’ Wale ‘Beehnu kan e aman kan ni.’ Nea nyoge urubo wa maano e rogu keá laangu ke ngweey dhieny. Beehdu now karu. ");
INSERT INTO lwo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bang gihn cahng beehna a ge adoohng ne dhaano utaahngo uke roomo keehd kwaad gihn na maahny kodh, ne bliny bliny kii diih maalo ni, e ngo kag yi maalo ke kun ke kun. ");
INSERT INTO lwo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Abea kuohma udhiil raahm umodho yihdh giih me thoohdh nyum kwaad giih ni uyug rog gen cang kedea ukweer yaa beed upiny kane ke an. ");
INSERT INTO lwo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Beehna a, ge adoohng ne dhaano utaahngo ngo uroom kaa nihn abeehn aboare gihr Nooh yea. ");
INSERT INTO lwo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Yihdh nihn nu, nyoge wudh gen anaa athoohr gene piny ne bahrahj now e ge yug giih cam, giih maadh kuong kedea yug kahnye ke bang yihdh miehr uwahdhe yi cahng ayedh Noohe yi yaahne keehd joe. Batiene naa abeehn aboare e nyoge ake thoo utoor ngaa maa adoohng. ");
INSERT INTO lwo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Gihn nu, beehda gihn muu uke roomo ke gihn anaa yug ree yi caang Lod. Nyoge ge anaa ke cahmo kedea umahdh gene mahdho now. Mooge ge anaa ayug giih ngiew now. Mooge dahng ge anaa ne puur yihdh puohdh gen. Mooge ge anaa ne ngeew nyepinye oogo. E mooge keehdo ge anaa ne geer wuude yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nyoge wudh gen anaa acub gene ne tiihj giih gen noon ni now, e wudh gen anaa athoohr gene piny. Noono naa awahnh cahng aay Lode, e kwaad maaj moogo me wa maay leelo abeehn ne cwii wudh nyoge ke maalo maa awoje wudh nyoge uwaang nyoge uthow gene cang. ");
INSERT INTO lwo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Aroba kejea beehda gihn muu uneehn giih nu thiow, cahng unyoadh an ge adoohng ne dhaano utaahngo. ");
INSERT INTO lwo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Cahng ubeehna kwaad ngaan ujoae piny e ne wiih wod keá cahg rihng piny ne kaab gihre maa awiie wod. Thiow kwaad ngaan ajooe piny yi puohdho keá rihng paajo ne kaab gihre me ne paajo. ");
INSERT INTO lwo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Paru wudhu ke ne gihn anaa yug ree rih ciih Lod. ");
INSERT INTO lwo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ke nying gihn nu ngaan daahd ukonye wahye, e ngaan nu wahye ge urwaahnyo. Abea ngaan meehg wahye rwaahnyo, e nuu ukony wahye. ");
INSERT INTO lwo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ateed gihn maa athiir yihru kejea, caang duua yea nea nyoge ariow ge abudo ka maa acielo e dhaano acielo e nuu ukaab abea ngaa man uwii piny. ");
INSERT INTO lwo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Maahn ariow thiow ge uyuud e ge uraah wiih paahm acielo, dhaano acielo e nuu ukaab abea ngaa maan uwii piny. ");
INSERT INTO lwo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Thiow cuow ariow, ge uyuud e ge nii puohdho, dhaano acielo ukaab abea ngaa man uwii piny.” ");
INSERT INTO lwo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","E jo waahdh, Jeacuu apeehny gene peehnyo kob gene, “Gihn ni ree uyuge kar piny kee?” Maa abeehr Jeacuue ngo yihr gen kobe, “Coar maa acudhe wudh gen mad gene ke ka maa athow laahye yea.” ");
INSERT INTO lwo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Muudhe e Jeacuu ucaale moogo acahge kaa robo yihr jo waahdhe e puohny gen beere ge be dhaahr yi kway gen. ");
INSERT INTO lwo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Noono maa arobe ngo yihr gen kobe, “Umodho coon, gaadi moogo anaa anudo yi geew, anahg ngaa me be tud rih Juog. Thiow anahg ngaa me wiihe thihr rih dhaano utaahngo. ");
INSERT INTO lwo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Gulo anaa anudo thiow yi geen ni acielo. Gulo na kwaay beehn bang gaadi gihn ni, e daahd dhe yooh me yuge gihn maa ne cohg yihre ke nying ngad ater gihre. Maa arube arumo yihr gaadi kobe, ‘Cedhree, konya! Yih akwaya yug gihn me ne cohg yihra ke nying ngad ater gihra gen joohr an ni.’ ");
INSERT INTO lwo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Ka me laaj keter abar e gaadi wiih dhaar beehde wane wano. Gahng ke gihn maa ayuge yihr ngo. Dhe caahn arumo e gaadi acaa ne par wiihe e keede maa arube ke cwihnye kobe, ‘An noon ni awaahn ni, riha ngahya kejea a padh ngaa me tud rih Juog e thiow riha ngahya kejea wiiha thihr rih kwaad dhaano utaahngo. ");
INSERT INTO lwo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Abea keehd maano thihr wiiha nu, awaahn ni gun ni kuohma acuude. Bang gihn kwaaye ke beehn banga keede e raam wiiha ke yug anyiinyo riha ke deeh ka me laaj. Ke nying gihn nu e gihn maa athiir maa ne cohg dhiila kaa yugo yihre. Bang gihn nea gihn maa athiir ne cohg be yuga yugo yihre, e bar maalo ke cuud kuohma.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Maa abar Jeacuue maalo ke rob kobe, “Boaru yea gihn arob gaadi! Keehd maano kobe kejea beehda dhaano me wiihe thihr ke yug gihn maa athiir yihr nyoge nu ");
INSERT INTO lwo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","wa gihn nu, e Juog thiow kare utoor yihre ugwiire kwaad gihn maa ne cohg yihr kwaad yaa beehda nyoge maa joe naa anhyaare ne? Ngahda gihn ngo cube cubo yihr gen nea ge bar maalo ke peehny Juog ne? Kare tooro ubeehn Juoge ubeehde e ukweer ke cub gihn buohj gene ke kway ngo ke dewaahr kedea decahngo. ");
INSERT INTO lwo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Dhiila kaa robo yihru kejea Juog gihn me ne cohg udhiile ke yugo yihr gen piow piow. Abea keehd maano, e a ge adoohng ne dhaano utaahngo ge uduua piny kan cahng moogo, e nyoge me yihr gen ne yiiho ge uyuud e ge nud ungoom kan ne?” ");
INSERT INTO lwo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Batiene e Jeacuu ucaale moogo acahge kaa kwaano e ngo rubo kaa nying kwaad nyoge maa anahg cwihny gene, keehd dhe yoohn ka pahr gene kii ngo. Bang gihn wudh gen par gene paro kejea ge nyoge me beeye. Arumo, e kwaad dhaano cang ngo cwiid gene cwiido kedea ungier gene koohm nyoge mooge ngiero thiow. Kob Jeacuue kea, ");
INSERT INTO lwo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nyoge ariow ge anaa aci yi Wod Juog ne kway Juog, ngad Paarijea kedea ngad gwaay cuol. ");
INSERT INTO lwo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ngad Paarijea athubo ke kwaj e ucuungo e puoj ree keede kobe, ‘Juog! Koohri udhiila ke amuohjo bang gihn a be neehn nyoge mooge maa yaa maahr kedea acamo. A padh ngad kaab maahn nyoge, e be room keehd ngad gwaay cuol gihn ca. ");
INSERT INTO lwo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Keew nihn cahng Juog e abiihjberiow ni, nihn ariow ge beehde e ge kwahnya ke oogo ukweehra cam yihdh gen kedea giiha cang ne beehn yihra, yihdh ge toga ke piny naa apaar ucuba acielo cubo yihri kiin apaar giih nu.’ ");
INSERT INTO lwo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Abea ngad gwaay cuol acuungo ka me baahr mee, e acuungo e wiihe akuule piny. Noono maa athube e kway Juog, abea e diehl koohre thiow ke cinge e urubo kobe, ‘Juog ngwaahn an. Mara abeehda ngaa me raaj now!’ ");
INSERT INTO lwo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Arob gihn maa athiir yihru, ngad gwaay cuol ado paare e ngaa me Juog cwihnye amihno ree, abea padh ngad Paarijea gihn. Bang gihn kwaad ngaan cub cwihnye yi daahd ruohdh ke nying yoad gihn me beer, e ngaan nu ree uyoade ne dhaano now me gihn me ne yihre tooro. Abea ngaan yug ree ne dhaano now e ngaan nu ree uyoade ne ruohdh uyoade gihn me beer.” ");
INSERT INTO lwo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nyoge thiow nyethen gen anaa akahl gene bang Jeacuu beere cinge cube ke wudh gen udooje gen. Naa aniid jo waahdhe gihn ayug nyoge ni, e nyethen agahl gene ke oogo ne kahl bang Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Gihn nu e Jeacuu jo waahdhe acuowe cuowo maa arube yihr gen kobe, “Ge keá mahnu! Weehgu ge beehno, bang gihn kwaad nyoge maa ayiiho kedea me gaahn Juog me neehn nyethen ge ne wudh gen ne maalo Paar Juog. ");
INSERT INTO lwo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A arob athiir yihru, ngaa me be lor Juog ke cwihnye cang wa ka lore nyethen, e Paar Juog be kuonge ke yoado.” ");
INSERT INTO lwo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ruohdh moogo, Jeacuu apeehnye kobe, “Ngad Puohny me beer, gihn e nuu uyuga beere kar kuowo me guge tooro yoada yoado?” ");
INSERT INTO lwo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Maa abeehr Jeacuue ngo kobe, “Gihn e ne cuohni an ne ngaa me beer ke nyinge? Ngaa me beer tooro upiny kan nea padh Juog keede, e naa ngaan beer cog. ");
INSERT INTO lwo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ngahda loohng Juog ge ngahyi ne? ‘Ciih ngaa moogo keá kaabi. Dhaano keá nahgi. Gihr ngaa moogo keá kwali. Gihn maa toohd keá tahr piny rih ngaa moogo now ke dhieny. Wuor wuru kedea miihu.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","E nyin ake koohbo, “Giih ni ge amaa ke coon kii thihno gihra.” ");
INSERT INTO lwo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Naa alihng Jeacuue kaa abeehr nyine gihre kii ngo, e ngo ake rubo yihre kobe, “Nyepiny acielo cog e naa adoohng e ngo kuu atiihyi. Do paajo ungeewi giih nud yihri oogo cang kedea uyoadi ngiihny ayoadi upaahngi gen yihr nyoge maa angoohng beere giih lonyo ge yoadi ke Paar Juog kedea ubeehni unahgi ngad batiena.” ");
INSERT INTO lwo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Naa alihng nyine gihn ni arob Jeacuue yihre, e cwihnye arahnyo bang gihn anahg ngaa maa alony keter. ");
INSERT INTO lwo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Gihn nu e Jeacuu amaahny bange maa arube kea, “Ngahyu ngo kejea ngaa maa alony ci yi Dhaahr Juog teeg yihre ubare. ");
INSERT INTO lwo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Adhaahr ngweehn roab amana yi libra wa mar libra ke keadh yihr mar yaa alony ne mono Paar Juog.” ");
INSERT INTO lwo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yaa alihng gihn arob Jeacuue, ge apeehyo kob gene, “Unahg kwaad ngaa me ngihde e nuu urom ree ke boadho?” ");
INSERT INTO lwo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Maa abeehr Jeacuue ngo yihr gen kobe, “Kwaad gihn me teeg me goohg dhaano utaahngo ke tiihyo gihn nu Juog be goohge.” ");
INSERT INTO lwo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Arumo e Piihter ake rubo kobe, “Giih wan ge awii wane piny, ubeehn wane batieni.” ");
INSERT INTO lwo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","E ngo arob Jeacuue yihr gen kobe, “Athiir e ne teeda yihru. Dhaano maa awii paare piny wale maa awii ciihe piny wale maa awii wuud men piny wale maa awii wahn piny kedea men wale maa awii nyethene piny udoohngo ne ngaa maa amag Juog, ");
INSERT INTO lwo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","e ngaan nu giih me thoohdh uyoade upiny kan maa gihn me yoohm wudh muu nu cang kedea kuowo yi Dhaahr Juog ke nying run cang ngo uyoade.” ");
INSERT INTO lwo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Maa akaab Jeacuue jo oohr ge apaar wonge ariow ni, urube keehd gen kobe, “Wo aman ci geen Jeruucalem! Kwaad giih anaa agweed yaa agamloohngjuoge piny ke nyinga a ge adoohng ne dhaano utaahngo giih nu ge upahdh kar gen wa kaano agweed gen nu. ");
INSERT INTO lwo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bang gihn a ubeehn gene ne cubo yi cing aleye. Kuohma uyaahl gene kedea ge unguud riha. ");
INSERT INTO lwo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","A upuohd gene ke ngeero kedea unahg gene an. Abea a ucahr yi dahg nihn.” ");
INSERT INTO lwo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Abea giih arobe ni bahng gihn maa aboar gene yihdh gen, bang gihn lum yihdh giih ni kuu anaa arob yihr jo waahdh. Noono e gihn anaa adaahd Jeacuue ke teedo yihr gen yea ngo kuu angey gene ne weey weey. ");
INSERT INTO lwo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Naa adoohng Jeacuue cahng keehd geen Jeriiko, e dhaano maa acoor anaa piih thaahng yooh. Anaa apiih kaano e gihre anahg kwaj e ne na akwahye kwahyo bang nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Naa alihnge doohn nyoge giih thoohdh e ge ubeehno ke bang yi yooh, e ngo ake peehyo kejea beehda gihn e ne yug ree. ");
INSERT INTO lwo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Maa arobe yihre naa, beehda Jeacuu ngad Naajaread e ne kahnh ke kaano. ");
INSERT INTO lwo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Noono e nyin duone atihnge maalo kobe, “Jeacuu! Waahd Deabid ngeer yeyi banga!” ");
INSERT INTO lwo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","E ngo abeehn yaa anaa wong maalo naa ane buude ke ne cuowo kejea lenge. Abea e kaa ajwage duone noono ke tihng maalo maa arube keehdo kobe, “Waahd Deabid ngeer yeyi banga!” ");
INSERT INTO lwo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Batien robe noono e Jeacuu yea waahdhe amage maa ucuunge, urobe ngo kejea kahl nyin bange. Abea ge anaa adoohnge cahng arumo e nyin apeehny Jeacuue peehnyo kobe, ");
INSERT INTO lwo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Yih daahd ngo utiihya gihn yihri?” Maa abeehre ngo yihr Jeacuu kobe, “Ruohdh, a daahde beere nea kare nud yihri kea thiehdh wonga uyahbe.” ");
INSERT INTO lwo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","E ngo abeehr Jeacuue beehro yihre kobe, “Yab wongi ree uniidi piny, bang gihn beehda yiiho gihri e naa aboadh yihn!” ");
INSERT INTO lwo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Noono ke wong kaano e nying nyin ake yahbo maa acidhe ke batien Jeacuu e buodh ngo e wuor Juog. Nyoge thiow naa aniid gene gihn ni, e Juog awuor gene wuoro. ");
INSERT INTO lwo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Batiene arumo e Jeacuu anaa beehno e caahdh kaa waahdhe maa acore yi geen Jeriiko. ");
INSERT INTO lwo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","E nyin moogo me nyinge Jaciihw anahg ngaa maa alony keter bang gihn e naa anahg ruohdh yaa gwaay cuol. ");
INSERT INTO lwo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kedea thiow ngo anaa beehdo e daahd dhe yooh me niide Jeacuu. Abea dhe yooh maa anaa ayoade atooro maa aniide ngo bang gihn nyoge giih anaa ke caahdho tiehd keehd Jeacuu ge anaa thoohdho. E thiow Jaciihw anaa anahg ngaa me cieg. ");
INSERT INTO lwo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Arumo batiene naa amodhe ngo wa gihn nu kejea ka me niide Jeacuu tooro nea e ucuungo kiin nyoge kaano, e amoon wong maalo ke ngweej, uyedhe wiih yaadh maa anaa thaahng yooh beere Jeacuu niid niido beer mee. Bang gihn anaa angahye kejea Jeacuu ukahnho ke thar yaadh gihn ni anaa ayedhe wiih ngo. ");
INSERT INTO lwo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Gihn nu arumo naa awahnh Jeacuue thar yaadh e Jeacuu ke ngude e naa amaahny maalo bang Jaciihw maa arube yihr ngo kobe, “Jaciihw, yih aniida laar beehn piny. A beehda weehno paari tihn noono.” ");
INSERT INTO lwo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Batiene arumo e ngo alaar yihnh piny wiih yaadh ubeehne ke bang Jeacuu e cwihnye amihno ne cohg. ");
INSERT INTO lwo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Gihn nu e angey nyoge ngeyo kejea Jeacuu kaa abeehn paar Jaciihw ne cam. Arumo maa athub nyoge cang ke ngoan ke cwihny gen kob gene, “Nyin abeehn paar ngaa me raaj ke ne gihn, adhaahr unahge weehno gihre ke ne diih?” ");
INSERT INTO lwo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Noono e Jaciihw ayedh maalo maa acuunge urube yihr Jeacuu kobe, “Ruohdh! Goan giiha cang giih ne yihra ni, ge dhiila kaa paahngo ucuba mooge yihr nyoge maa angoohng. Kedea thiow nea kwaad dhaano me gihre anaa cama, e ngo dhiila kaa coalo yihre ukaale wiih gihn acama tiel angween.” ");
INSERT INTO lwo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Maa abeehr Jeacuue ngo yihre kobe, “Kar bodho abeehn wudh yaa paan kan tihn ke kar gen. Beehda kare bang gihn ngad paan ni thiow beehda kwaar Abraahm ke ngude. ");
INSERT INTO lwo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bang gihn a, ge adoohng ne dhaano utaahngo a abeehno upiny kan, a abeehn ne daahd yaa arwaahnyo, uboadha gen thiow.” ");
INSERT INTO lwo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Maano e nyoge ge lihng gihn arob Jeacuue ni, e Jeacuu abar maalo ke rob keehd ucaale naa aniide ngo kejea ngo adoohng cahng ke geen Jeruucalem. E thiow bang gihn nyoge wudh ge anaa apar gene kejea ka beehn Juog ne luny yaa Yijarael oogo yi cing yaa mahn giih gen, ngo adoohng cahng. ");
INSERT INTO lwo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Maa arub Jeacuue kobe, “Yaage! Dhaano maa anahg waahd ruohdh anaa abeehn ne aay e ngo caa paajo moogo beere ngo ke kwanyo ne ruohdh yea. Nea ngo ke kwanyo ne ruohdh e uduuo. ");
INSERT INTO lwo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Abea e poohde e kuu a'aay nu e yaa tiihj giihe apaar ge akuonge ke cuohno bange. Naa abeehn gene bange, e ngiihny ge akwaane yi cing gen kejea na low gene thaajir ke yugo ke ngiihny nu, uwahdhe ka uduue. ");
INSERT INTO lwo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Abea nyin ni anaa abeehde e ngo anaa amaan paaje keter. Arumo e yaa paajo nyoge mooge abeehn gene ke ne oohr batien nyin ne rob ngo kejea ge be daahd uyug nyin ne ruohdh. ");
INSERT INTO lwo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Naa aci nyine ne duuo, e aduuo e ayug ne ruohdh. Batiene e yaa tiihj giihe naa acube ngiihny yihr gen ge acuohne ke bange ne nyoadh ngiihny ayoad gene yi thaajir. ");
INSERT INTO lwo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Gihn nu e ngad umodho abeehn urube yihr ruohdh kejea, ‘Ruohdh a alog tiihj keehd ngiihny awii piny yihra ukaar wudh gene tiel apaar.’ ");
INSERT INTO lwo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Maa abeehr ruohdhe ngo kobe, ‘Yih aniida ne ngad tiihya me beer keter. Yih gaahna gaahno bang naa angahyi gihn thiin naa acuba yihri ke maa. Awaahn ni yih ruohdh wudh geedhe apaar.’ ");
INSERT INTO lwo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Keehdo e ngaa man acahg beehn wong maalo maa arube keehd ruohdh kobe, ‘Ruohdh! Ngiihnyi naa acubi yihra, ge acahg koad keehd abiihj mooge keehdo.’ ");
INSERT INTO lwo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“E ngo acahg ruohdhe kaa beehro yihr nyin kobe, ‘Beer! Yih acuba wudh geedhe abiihj ne ruohdh!’ ");
INSERT INTO lwo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Batiene e dahg yaa tiihj giihe ake beehno maa arube yihr ruohdh kobe, ‘Ruohdh ngiihny giih naa acubi yihra ge gen. Ge anaa abahya keehd jwaahd waaro ugoohla ge piny, ");
INSERT INTO lwo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","bang gihn yih beehda ngaa me raaj, caahn e a atud ke nying gihn ngahya kejea yih beehda ngaa me poodh yeyi akuohng keter. Beehda gihn me ke robo kejea mari, gihn me padh gihri kobi nahge gihri. E kar piny me dhe kweeyi kii com yea, kobi nahge gihri me yihn ne kaj ngo.’ ");
INSERT INTO lwo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Gihn nu maa abeehr ruohdhe ngo yihre kobe, ‘Nyieh! Ngahy ngo kejea yih luga kaa lumi naa abeehn oogo yi dhii. Bang gihn aniida ne cohg kejea yih ka beehda ngaa me raaj ne ciihdh ciihdh! Wa kaano arobi ngo ke dhii upari ngo ke wiihi kejea yeya poodh kedea urobi ngo kejea kwaad gihn me cinga kaa jag ree e naa gihn roaja kejea beehda mara. E thiow kobi puohdho me kaa dooyo beehda e naa mara ne daahda ke kaya. ");
INSERT INTO lwo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Beehda gihn e naa amahn yihn ke cub ngiihnya yihr yaa beeng unyuol gene yihra ke mooge beere ge ukaar yihra unahg gene jwahg?’ ");
INSERT INTO lwo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Maa arobe ngo yihr nyoge naa ake cuung cang kobe, ‘Kahlu ngiihnya noono oogo yi cinge ucub gen yihr ngad tiihya ge wudh ngiihnye akaar tiel apaar.’ ");
INSERT INTO lwo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Muudhe e ngo abeehr yaa anaa ake cuunge yihr ruohdh kob gene, ‘Abea nye ruohdh, wa nyin nu ngiihny giihe wudh ge akaar tiel apaar!’ ");
INSERT INTO lwo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Maa abeehr ruohdhe ngo yihr gen kobe, ‘Kwaad ngaa yihre ne nyepiny e mooge me thoohdh udhay wiih man nud yihre. Abea ngaa toor gihr nyepinye yihre, keehd gihn anaa yihre, ukaab udoohnge ke cinge now.’ ");
INSERT INTO lwo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Maa acahg ruohdhe ngo ke robo keehdo kobe, ‘Kahlu yaa anaa akweer keehd an kob gene ge be daahd an udoohnga ne ruohdh, beehnu keehd gen yihra, unahgu gen nyuma kan.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Batien kaa arob Jeacuue gihn ni, e ngo ake aay umoone wong maalo nyum nyoge e ngo caa geen Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Naa awahnhe buud paan cuohn ne Bedhpeag kedea paan cuohn ne Bathany, wiih good Ulihbe, e nyoge ariow kiin jo waahdhe ge aoohre ke wong maalo nyume kobe, ");
INSERT INTO lwo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Cidhu paan cuudi nyumu abea ge wahdhu, e akaja, me dhaano kuu akuong paahr wiihe uyoadu e ngo amag piny. Goonyu ngo ukahlu ngo yihra kan. ");
INSERT INTO lwo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nea wu ke peehnyo kejea goonyu ke ne gihn, kea rubu kejea, ‘Ruohdh e ne daahd ngo.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Gihn nu arumo e yaa ni ge apahdh yooh maa ayoad gene giih nyepinye wa kwaad ka arob Jeacuue ngo yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kaa athub gene ke goony akaja arumo, e ngad akaja ake rubo yihr gen kobe, “Gihn e ne goonyu nyaa akahnya ke nyinge?” ");
INSERT INTO lwo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","E ngo abeehr gene beehro yihr nyin kob gene, “Beehda ruohdh e ne daahd ngo!” ");
INSERT INTO lwo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Batiene e ngo akahl gene kahlo yihr Jeacuu. Maa apeedh gene waay gen wiih nyaa akahny ni arumo, uthany gene tien Jeacuu ke maalo upaahr Jeacuue ke wiihe. ");
INSERT INTO lwo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Abea nye kaano anaa acaahdh Jeacuue caahdho keehd akaja nu, e nyoge waay gen apeedh gene piny ke bang yi yooh. ");
INSERT INTO lwo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ge awahnh Jeacuue ka me cahng ke kaa beehn yoohe uluunge piny ke wiih good ulihb e amahr jo waahdhe cang ge athubo e doohn gen atihng gene maalo e ge poong Juog ke nying amahr giih teeg thoohdh naa aniid gene ke nying gen. Ge ake wahr ne ngaano, “Juog! ");
INSERT INTO lwo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Dooj Juoge ruohdh ge abeehno ke yoohn Paar Maalo. Juog doohr mare aoohre, yihro ke maalo noono dhiilo nyinge ke wuoro!” ");
INSERT INTO lwo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","E yaa Paarijea naa anudo kiin akuud nyoge ge ake rubo yihr Jeacuu kob gene, “Ngad Puohny cuow jo waahdhi uleng gene!” ");
INSERT INTO lwo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Maa abeehr Jeacuue ngo yihr gen kobe, “Yaage ateed gihn maa athiir yihru kejea nea ge ulengo e leele ge ukwaago!” ");
INSERT INTO lwo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Naa awahnh Jeacuue ka me cahng mee keehd geen Jeruucalem kedea naa amaanye ngo uboare ngo beer mee, e piih wonge ake wojo kaano. ");
INSERT INTO lwo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Noono e ngo ake rubo kobe, “Jeruucalem! Koba nea kwaad giih anaa agwiir Juoge yihri ke nying kar doohr gihri, ge nii ngahyo tihn, e ngo ne nahg gihn me ne beero! Abea maahny kaa kan Juoge giih ngo yihri, dhe yooh me niidi gen tooro keehdo! ");
INSERT INTO lwo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Abea cahng anaa acub Juoge piny ke nyingi ni, ngo ubeehn yihri cahng moogo, ubeehn jo mahn ke yihn uciel gene yihn piny ke ngahy roog. Kedea thiow yih ukoy gene oogo kar keedi, udiehl gene dhog yiehdhe cang oogo yihri. Ka me thiin muu uwii gene naa apuogo yihri utooro. ");
INSERT INTO lwo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Yaa mahn giihi yih uthuohm gene piny cang ne jog jogi, utoor wong leelo acielo muu uwii gene piny e ngo kuu ajog gene. Leel man upahdh wiih wad gen, utoor kihd leelo keehdo me cuung e keede ne weey weey. E joi thiow ge unahg cang, bang gihn yih akweer keehd an, a ngaan anaa aoohr Juoge bang ubeehna ne boadh yihn.” ");
INSERT INTO lwo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kaano e Jeacuu amon yi laaro gihr Wod Juog Jeruucalem, uthube thubo ke riem yaa thaajire oogo yi goan laaro. ");
INSERT INTO lwo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kaano e ge rieme e ngo urubo thiow keehd gen kobe, “Ngo beehda gihn maa agweed yi kitaab Juog kejea, ‘Wod Juog beehda kar kwaj yihr Juog cog, abea e aman ayugu ne kar yaa kahw!’ ” ");
INSERT INTO lwo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ubar Jeacuue ke maalo ke puohny gihre ke nying nihn e puohny nyoge yi laaro gihr Wod Juog. Batiene arumo e jo doong yaa lam kedea yaa loohng kedea jo doonge paajo, ge ake mahdo beere dhe yooh daahd gene daahdo unahg gene Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Abea e dhe yooh maa ayoad gene tooro, bang gihn nyoge wudh ge anaa acub gene piny ne cohg ne lihng giih Jeacuu naa arobe robo. ");
INSERT INTO lwo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Cahng man keehdo, e Jeacuu anaa yi laaro gihr Wod Juog e puohny Ciig Beer yihr nyoge, e jo doong yaa lam kedea yaa loohng kedea jo doong paajo ge abeehn bang Jeacuu. Kob gene, ");
INSERT INTO lwo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Teeg mari noono ngaa e naa acube yihri. Tee gihn riemi yaa ngeehw oogo yi laaro gihr Wod Juog?” ");
INSERT INTO lwo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Maa abeehr Jeacuue ngo yihr gen kea, “Thiow a daahd upeehnya wun. Robu ngo yihra do, ");
INSERT INTO lwo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","luogwahy mar Joon gihn anaa acube yihr nyoge ni, teege noono anaa acube luogwahy anaa ayoade paar maalo wale ke bang dhaano utaahngo?” ");
INSERT INTO lwo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kaano e ge ake thubo ke rob ke rog gen kob gen, “Awaahn ni, nea wo urubo yihre kejea tee ayoade ke bang Juog e ngo duoge duogo kobe, ‘Abea gihn e bahnge lum Joon kuu anaa ayiiho.’ ");
INSERT INTO lwo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Abea nea wo urubo kejea tee ayoade ke bang dhaano utaahngo, e lwaag cahg pahdh rogo ubahn gene won keehd leele, bang gihn beehde ngo ngahy gene kejea Joon anahg agamloohngjuog me duohng.” ");
INSERT INTO lwo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Gihn nu e ngo abeehr gene yihr Jeacuu kob gene, “Ngo kwihj wane.” ");
INSERT INTO lwo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","E ngo abeehr Jeacuue beehro thiow yihr gen kobe, “A thiow ngaa acub tee yihra ngo be roba yihru.” ");
INSERT INTO lwo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Keehdo e Jeacuu ake thubo ke rob yihr nyoge kuu ucaale, “Anaa anudo ke nyin moogo maa anaa apiih yen yi puohdho gihre. Maa acube puohdho yihr nyoge mooge utiihy gene yea. Batiene e ngo abeehn ne aay ucea kar weel kaa me baahr maa acea ne ceng thiow duug. ");
INSERT INTO lwo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Abea ge abeehn pinye ne cieg arumo, e dhaano acielo kiin yaa tiihj giihe aoohre ke bang yaa anaa acube yi puohdho ni. Ngo aoohre beere e caa ne kahno yihre keehd goan caame yihdh giih acieg yi puohdho. Abea yaa anaa yi puohdho ni, ngaan aoohre apuohd gene maa ariem gene ngo oogo ke cinge now. ");
INSERT INTO lwo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","E wur puohdho ngad tiihj gihre moogo acahge kaa oohr bang yaa ni keehdo. E nyin acahg gene kaa joohro maa arieme gene ngo oogo ke cinge now thiow. ");
INSERT INTO lwo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Keehdo dahng e wur puohdho poohd be dhaahr maa aoohre dahw gen keehdo. Abea yi dhoar ni e yaa tiihj ngwiilo akedh gene ke rih ngaa ni anaa aoohr ni. Maa ariem gene ngo oogo thiow kun caadi. ");
INSERT INTO lwo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Kaano arumo naa aniid wur puohdhe ngo e ake pahro ke cwihnye e urubo e keede kobe, ‘Awaahn ni, gihn e nuu utiihya keehd yaa ni! Moogo e waahda ke ngude ge nyethiin yeya ni naa anhyaara e nuu uoohra. Moogo e ke nying gihn nahge waahda, kuohme uwuor gene, ubahnge cing gen buu ujag gene ree.’ ");
INSERT INTO lwo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Abea ge aniid yaa tiihje waahd ngad puohdho, e ge ake rubo ke rog gen kob gene, ‘E naa waahd ngaa udoohng ne lag piny ni e gihn beehn. Nahgo ngo beere puohdho gihn udoohngo ne gihro.’ ");
INSERT INTO lwo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Noono maa aywaay gene ngo toohg puohdho ne naah kun nu. “Nea maru, e gihn e nuu yug wur puohdhe rog yaa ayug kwaad gihn raaj wa maano ree? ");
INSERT INTO lwo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ngo teehng wudh gen unahg gen cang kedea ucube puohdhe yihr nyoge mooge.” Naa alihng nyoge gihn ni arumo e ge ake gaahy maa arub gene kob gene, “Yaahy! Gihn ni ree keá tiihye.” ");
INSERT INTO lwo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","E Jeacuu amaahny bang gen kaano ne cohg maa arube kejea, “Abea yi lum anaa agweed arumo beehda gihn ne cohg? Gihn anaa agweed yi kitaab Juog kejea, ‘Kaaw gihn akweer yaa geere keehde e naa adoohng ne meehn wod!’ ");
INSERT INTO lwo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kwaad ngaa upahdh wiih leen nu, e naa ngaan utoar ne jog jogi. E kwaad ngaan upahdh leen nu wiihe, e naa ngaan unyonge ne kud kudi.” ");
INSERT INTO lwo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kaano e yaa loohng kedea jo doong yaa lam giih kweehr, ge anaa adaahd dhe yooh me mag gene Jeacuu, bang gihn ngo abeehn gene ne ngeyo kejea kwaad ucaale giih arobe, ge arobe kaa nying gen. Abea dhe yooh me mag gene ngo abeehn ne goohg yihr gen, bang gihn ge atud yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ne koar Jeacuu piny e nyoge mooge akoog gene beere ge beehn bang Jeacuu, e rog gen anahg gene piny wa nyoge me beeyo me yihdh gen cang keehd ngo. Ngo agaahn gene kejea Jeacuu urubo ke gihn me meehg ngo mago yihr gen beere ngo luom gene luomo yihr yaa ruohdhe giih geen Jeruucalem kedea yihr muudiihr gihr yaa Roama. ");
INSERT INTO lwo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kaano arumo maa abeehn yaa anahg rog gen piny bang Jeacuu ne peehny ngo kob gene, “Ngad Puohny beehda gihn me ngahy wane kejea yih puohny kedea yih rob giih maa athere. Thiow kiin nyoge ge be kwanyi abea mari puohny lum Juog ke dhe yooh maa adiehr. ");
INSERT INTO lwo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Rob ngo yihr wan do! Beehda gihn maa arob loohng Juoge yihro kejea gwaaj cuol yihr Jaah Roama ne wale ngo amahne?” ");
INSERT INTO lwo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Abea e gihn anaa adaahd gene ne cohg, yi ngo amodh Jeacuue modho piow piow. Noono maa arube yihr gen kobe, ");
INSERT INTO lwo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nyoadhu wong grihj yihra uniida ngo! Cuuro gihr ngaa kedea nying ngaa ge naa agweed ngahy grihj gihn?” ");
INSERT INTO lwo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Maa abeehr gene ngo kejea, “Beehda cuuro kedea nying Jaah Roama.” Kob Jeacuue yihr gen, “Beer cubu kwaad gihn beehda gihr Jaah Roama yihr Jaah Roama kedea cubu gihr Juog yihr Juog.” ");
INSERT INTO lwo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Dhe yooh maa ayoad gene atooro maa amag gene dhe Jeacuu keehd ngo nyum nyoge kaano. Noono e ge ake lengo bang gihn ge acwaahng ke dhe yoohn kaa abeehr Jeacuue gihn apeehny gen. ");
INSERT INTO lwo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Keehdo e yaa Caaduucean, ge na rubo kejea nyoge maa athow ka me cahg gene cahro keehdo tooro, ge anaa abeehn bang Jeacuu maa apeehny gene ngo kob gene, ");
INSERT INTO lwo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ngad Puohny, anaa arob loohng Moaje kejea, ‘Nea dhaano umen athow, uwiie ciihe piny abea nyethiin tooro yihr gen e ngaan umen athow ciih umen geere geero beere yea ngo nyuole nyuolo.’ ");
INSERT INTO lwo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Anudo ke wuud meehe abiihjberiow. Ngaa duohng gen anaa abeehn ne nyuohm maa thowe e yihre tooro nyethiin. ");
INSERT INTO lwo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Maa abeehn ngad batiene ugeere ciih umen ucahge thoo e nyethiin tooro kiin gen. ");
INSERT INTO lwo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Maa acahg dahw gene do wod keehd dhaago maa athowe thiow e nyethiin tooro. Ne naang wa maano uwahdhe kaa athum gene cang ke thoo kar gen noono abiihjberiow, e bahng ngaa maa anyuol keehd nyethiin ke dhaar ni keew gen ne weey weey. ");
INSERT INTO lwo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dhe caahn arumo e dhaago ree acahge kaa mad piny thiow. ");
INSERT INTO lwo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nea ka robe kejea nyoge ge ucahro batien thon gen, e dhaar ni unahg ciih ngaa keew gen noono abiihjberiow bang gihn ge aci wod keehde cang?” ");
INSERT INTO lwo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Noono e ngo abeehr Jeacuue beehro yihr gen kobe, “Ngahyu ngo kejea cuow kedea maahn me poohd kuow upiny kan, ge naa yaa nyoohmo ke rog gen. ");
INSERT INTO lwo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Abea padh cuow kedea maahn giih ucahr keehdo. E thiow gen noono ge naa cuow kedea maahn giih miehr keehd kwaad kar kuowo gihn ne wong maalo ni, nyuohm beehda gihn me tooro ke nying gen keehdo. ");
INSERT INTO lwo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bang gihn ge be cahg thoo, thoo padh gihr gen. Ge beehda nyoge muu uroomo keehd wuohdjuog kedea ge adoohng ne nyoge maa nyethen Juog. ");
INSERT INTO lwo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wa gihn nu anaa anyoadh Moaje kejea, ‘Nyoge maa athow ge dhiil cahro batien thoo.’ Robe noono yoad ke kaa anaa arube ke nying kaa aniide bungo e uwaang. Moaje anaa arubo kejea Juog beehda Juog wuor Abraahme kedea Yijaag kedea Jeakob. ");
INSERT INTO lwo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Juog ge niidu ni yaage padh Juog nyoge me tooro wale nyoge maa athow, bang gihn nea yihr Juog e ngaa maa athow tooro. Nyoge beehda nyoge me kuow cang yihre.” ");
INSERT INTO lwo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Gihn nu arumo e nyoge mooge maa yaa loohng doohn gen atihng gene ke maalo kiin nyoge kun caa e ge arubo kob gene, “Ngad Puohny gihn nu angahyi ke beehro beer mee!” ");
INSERT INTO lwo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gihn nu maa atud gene arumo utoor ngaa maa acahg Jeacuu ke peehnyo keehd piehj gihr waane keehdo. ");
INSERT INTO lwo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kaano e ge apeehny Jeacuue peehnyo kobe, “Beehn ke ne diih kejea ngaan akob kejea e nuu ubeehn ne boadhe nyoge ni, unahg ngaa me beehda kwaar Deabid? ");
INSERT INTO lwo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Bang gihn keehd Deabid ke ngude e ngaan nu arob anaa acuohne kea ngo beehda ruohdh yihre thiow. Wa kwaad kaa anaa arobe ngo yi kitaab wahr kejea, ‘Juog Ruohdha arubo yihr Ruohdha kea, “Piihi ukwiihya kan ");
INSERT INTO lwo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","uwahdhe ka uyuga yaa mahni ne upahm thaahdh tieni.” ’ ");
INSERT INTO lwo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Deabid kwaare cahge cuohno ne ‘ruohdh’ yihre ke ne diih?” ");
INSERT INTO lwo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nye kaano anaa alihng nyoge lihngo nu, e Jeacuu ake rubo keehd jo waahdhe kobe, ");
INSERT INTO lwo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Cubu wudhu piny yaage ukoaru rogu beer mee thiow ke nying yaa loohng ubahnge dhe yoohn gen noono beehd gene kii ngo be ngooru. Bang gihn mar gen ge nhyaar waahdh ke kiin nyoge keehd thoohn waay gen noono bahy nu. E thiow mar gen, ge nhyaar dhe yoohn maahdh nyoge ke bang yi cuug e nyoge wudh gen kuul gene ke piny yihr gen. E thiow keehdo, kwaad kuohn piih giih acub wong maalo yihdh wuud amaade ni, gen naa giih nhyaar gene noono ne kuohn piih yihr gen. E dahng, kwaad kuohn beey kuohn mahd nyoge yihdh gen kar cam, ge naa giih nhyaar gene ke kwanyo upiih gene yihdh gen. ");
INSERT INTO lwo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ge nyoge me nhyaar cam giih gule kedea kwaj duug yi Wod Juog ne kang nying nyoge abea toohd now kway gen noono yea apuogo. Juog ge ukihme ke deeh ukihm me teeg.” ");
INSERT INTO lwo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Noono arumo Jeacuue wiihe atihng maalo maa aniide yaa alony e ge thoohr ngiihny yi caanduug yi wod Juog. ");
INSERT INTO lwo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Dhaago maa gulo maa angoohng aniide thiow e athoohr wong grihj cog. ");
INSERT INTO lwo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kaano e Jeacuu ake rubo kobe, “Gihn maa athiir ne cohg e ne teeda yihru, gulo gihn angoohng ni e naa muuyo keraahyo ukaale muuy amahr yaa nu cang. ");
INSERT INTO lwo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bang gihn yaa ni cang ge amuuyo ke yihdh ngiihny gen me thoohdh, abea gulo gihn mar dhee ke ngude e gihr cahng nu, e naa athoohre yi caanduug.” ");
INSERT INTO lwo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nye kaano keehdo e nyoge mooge ge ake thubo ke rob e ge puoj Wod Juog ke nying dhe yoohn geer naa ageere ke wuohbo, keehd thoohn leele kedea amahr giih acub yea naa amuode keehd gen ne giih muuyo yihr Juog. Maa arub Jeacuue kejea, ");
INSERT INTO lwo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Giih ni kan niidu ni, cahng acielo moogo ubeehn muu uthuohm Wod Juog piny cang utoor wong leelo acielo muu udoohng wiih wad gen!” ");
INSERT INTO lwo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Keehdo maa apeehy gene kejea, “Ngad Puohny! Weehne e nuu ubeehn gihn ni uyuge ree?” ");
INSERT INTO lwo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Maa abeehr Jeacuue ngo yihr gen kobe, “Cubu cwihnyu piny beer mee ubahnge rogu be meehgu dwaahngo. Bang gihn amahr nyoge me dwaahng wun ke nying giih uyug rog gen ge ubeehn ke batiena e ge rubo kaa nyinga e ngaa man ukoohbo kea, ‘A naa en.’ E thiow ge urubo kejea, ‘Cahng ngo awahnho arumo.’ Wu keá cidho ke batien kwaad yaa nu rubo wa kwaad maano. ");
INSERT INTO lwo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Thiow linye bang gen ulihngu kedea dhog awahnh bangu ke nying linye mooge me ne kuohn me bahye. Abea yihdhu keá baadh bang gihn giih nu rog gen kuong gene kaa tiihyo umodho e caang gug piny poohd kuu awahnho. ");
INSERT INTO lwo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Paajo yea upahw ne dahg ubeehn yaa tien paajo acielo ukag gene ke rog gen kedea dhaahre giih wiih piny ge ukag naa arwaadh ke rog gen. ");
INSERT INTO lwo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Amahr ayahng ngoom me thoohdh rog gen uyug gene ke bang kuohn me thoohdh. Kahj me duohng upahdh rog nyoge kedea kwaad atwaanye mooge ge upahdh rog nyoge ke yihdh kuohn me thoohdh. Kwaad giih me teeg yea maalo thiow rog gen uyug gene uniid gen ke bang yi maalo. ");
INSERT INTO lwo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Abea umodho e giih ngo rog gen poohd kuu uyug gene, e cing unaa wudhu uyug giih ajohr rogu keter. E nyoge wu ukedh gene kuohn luwe giih gen kedea ukedh gene wun yi karkoohn. Wu ukedh gene nyum ruohdhe kedea nyum maamuure giih paajo. Giih nu cang ge uyug gene rogu wa maano kaa nying gihn nahgu nyoge maa jo'a ni. ");
INSERT INTO lwo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Cahng nu, e naa ka urubu ke nying Ciig Beer ne cohg. ");
INSERT INTO lwo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nea wa gihn nu e wu keá na guo moon piny kejea wu upahro ke dhe yoohn ka ukonyu rogu ke leehbu kii ngo. ");
INSERT INTO lwo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bang gihn dhe yoohn ka urubu kii ngo kedea ka ungahyu luube beehro kii ngo thiow, unahg a e nuu ucub ngo yihru, beere dhe yooh me beehn yaa ater giihu ucahg gene giih mooge ke robo rogu keehdo tooro. Dhog gen e nuu utal ne kwaad giih urobu. ");
INSERT INTO lwo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Abea dhe yoohn kar luom me duohng e nuu unud ke nyingu. Ge weehgu kedea wuud meehu maa kwaad nyoge maa awaahde keehd wun ge nuu ucahg wun ke luomo. Maa nyoge maa gome keehd wun thiow wu uluom gene. Nyoge mooge kiinu dahng ge unahg gene. ");
INSERT INTO lwo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Wu umaan nyoge cang ke nyinga. ");
INSERT INTO lwo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Abea keehd maano e keehd wong yiehno acielo now buu ne tag piny yihru. ");
INSERT INTO lwo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Dhe yoohn kuow maru me beer, ngo uyoadu kaa dhe yoohn ka guumu kii ngo yihdh giih me teeg. ");
INSERT INTO lwo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Abea nea ge niidu ngo arumo e Jeruucalem atieg yaa deaje piny cang, kea ngahyu ngo kejea kar ka rahny giih geen Jeruucaleme kii ngo awahnho. ");
INSERT INTO lwo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kaano arumo kea beehn yaa beed Judea, goohd gene ke ngweej ne pahno yihdh bung yihdh goode. E thiow beehn kwaad yaa muu beed yi buur geew ni, aay gene. Abea kwaad yaa muu abeehn oogo yi buur geew ni, ge keá cahg do geew. ");
INSERT INTO lwo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bang gihn nihn nu ge nuu unahg nihn ubeehn Juoge ucuowe nyoge wa kwaad kaano anaa arob kitaab Juoge ngo kii ngo nu ke nying giih reje naa ayug gene. ");
INSERT INTO lwo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Abea yihdh nihn nu ngo unahg gihn me teeg rog maahn muu yaje kedea maahn me dhuohdho keehd nyethen. Bang gihn muum wihj upahdh ungoom keter. Maa deeh cuow Juog me teeg upahdh rog nyoge ne cohg. ");
INSERT INTO lwo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nyoge mooge ge unaahng e ge coob kaa pale, e nyoge mooge dahng ge ukedh miehr mooge udoohng gene ne baahng yihdh gen. Noono arumo e kwaad yaa kwihy Juog, Jeruucalem ke buur ngude ngo unyon gene piny ke tien gen. Ge ubeehdo yea uwahdhe ka uthum gene nihn acub piny yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“E thiow kwaad kihd giih mooge rog gen uyug gene kii maalo kii wong cahng kun caadi kedea kii wong dwaahy kedea ke nying ciehr. Wudh nyoge une cohd ke nying kwaad giih ni thoohdh yug rog gen ni, wa kwaad gihn ngoar kedea giih maahr ke bang yi naam duohng. ");
INSERT INTO lwo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nyoge ge amag lwahre utud gene ne joad uluy nyoge luyo bang lwahr naa apahdh rog gen arumo. Nyoge koohm gen une kuohj une gene lwaj ke nying kwaad giih doong ayug rog gen yihr nyoge ke bang wiih piny cang. Giih beed bang yi maalo rog gen udhuohb gene cang ke kar gen ne dug. ");
INSERT INTO lwo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Noono e a ge adoohng ne dhaano utaahngo uniid nyoge arumo e a beehn kaa yi poohlo ke maalo, e a beehn kaa deeh tee kedea e wiiha amoar. ");
INSERT INTO lwo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Arumo kaano nea kwaad giih nu ge uthubo ke yug rog gen, kea maahnyu e wudhu tihngu ke maalo, bang gihn kar ka ukonyu wahyu kii ngo adoohng cahng ke beehno.” ");
INSERT INTO lwo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Maa arobe ucaale gihn yihr gen kobe, “Maahnyu ke rih dhuuro! Kedea rih kwaad yaadh cang, ");
INSERT INTO lwo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","nea ge thub gene ke lodho keehd booge me nyaahn ni, e gihn nu ngo guo kaa angeyo kejea beehn oohro adoohng cahng. ");
INSERT INTO lwo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Neehn gihn nu thiow, nea kwaad giih ateeda yihru kan rog gen yug gen yugo, kea ngahyu ngo kejea ka beehn Juoge ne kony nyoge, uyug Juoge gen ne joe, e naa awahnho arumo. ");
INSERT INTO lwo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Adiehr, e ne roba yihru. Wu yaa nud awaahn ni wu buu uthow e giih aroba yihru rog gen poohd kuu atiihy gene. ");
INSERT INTO lwo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Maalo kedea piny kan ge utooro abea luma ree utiinge kare. ");
INSERT INTO lwo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Abea gihn nud gen, dhiilu wudhu ke koaro ubahnge giih kar kuowo maru wudhu be nyoan gene, ugaalu kaa maadh kuong kedea ke daahd giih adeehju cwihnyu rog gen wiih piny kan. Noono ubeehn nye wong kaano uaahle wun piny e rogu kuu agwiiro ke nyinge. ");
INSERT INTO lwo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bang gihn kwaad ka muu udoohng piny naa apuogo now tooro. Kwaad giih nu ge beehda giih muu ubeehn rog thaahye cang ke bang wiih piny cang ne dug. ");
INSERT INTO lwo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Dhiilu beehdo e rogu agwiiru, ukwayu Juog kwayo, beere Juog wu konye konyo ucube teeg cwihny mare ge beer yihru, beere wu ubodho yihdh kwaad giih ubeehn ne tiihj rog gen wiih ngoom. E thiow keehdo beere wu kony Juoge konyo, ungahyu cuungo keehd dhe yoohn kar kuowo maru maa ne cohg, nyuma a ge adoohng ne dhaano yi beehn mara nuu ubeehna.” ");
INSERT INTO lwo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Noono arumo ke nying nihn e Jeacuu anaa abeehde e kwaay puohny yi laaro gihr Wod Juog. Abea nea ge yuudh cahng ni e ngo beehn oogo geen Jeruucalem, ucea ne daahd kar budo yihdh miehr giih dhe oogo yi geew me ne ka me cahng keehd good Ulihbe. ");
INSERT INTO lwo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Arumo nea ge ruu piny ke nyango keehdo, e ngo duu Jeruucalem. Kaano keehdo, e nyoge ge cahg waahd bange yi laaro gihr Wod Juog gihr Jeruucalem, beere ge beehn ne lihng giih puohnye nyoge keehd gen. ");
INSERT INTO lwo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Keehdo e yaay gihr ka cam amono me bahdh me nyinge Yaan Amono anaa adoohng cahng. ");
INSERT INTO lwo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kaano e jo doong yaa lam giih kweehr kedea yaa loohng dhe yooh anaa adaahd gene beere Jeacuu nahg gene naah. Abea e gihn nu ayug gene kaa piny bang gihn ge atud yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Muudhe e kaano thiow, ruohdh atiihb ukeehge abeehn rih Juudo Yijkaariod ukedhe gihn me raaj yi cwihnye. Juudo anahg dhaano acielo kiin jo oohr giih Jeacuu ge apaar wonge ariow ni. ");
INSERT INTO lwo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Gihn nu arumo e Juudo anaa aloaj ucea ne rob keehd jo doong yaa lam kedea jaabidhe giih acaakere giih koar Wod Juog beere dhe yoohn ka luome Jeacuu kii ngo nyoadhe nyoadho yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Batiene e cwihny yaa ni ake mihno ne cohg. Noono ugwiir gene dhe yoohn kar ngiihny giih cub yihr Juudo ne giih akum thog. ");
INSERT INTO lwo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Maa ayiih Juudoe gihr gen noono, ubeehne ke ne daahd ka unyoadhe kar Jeacuu kii ngo e yuge kaa piny maano e nyoge tooro. ");
INSERT INTO lwo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kaano e cahng ka cam amono me bahdh abeehno ge beehda cahng nahg nye roomo gihr Yaan Amono. ");
INSERT INTO lwo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Gihn nu e Jeacuu, Piihter kedea Joon ge aoohre kobe, “Cidhu ne gwiir cam cahng Yaan Amono yihro ucahmo.” ");
INSERT INTO lwo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Batiene e Jeacuu apeehny gene peehnyo kob gene, “Kee e ne daahdi nuu ugwiir wane cam yea?” ");
INSERT INTO lwo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","E ngo abeehr Jeacuue beehro yihr gen kobe, “Cidhu abea ge wahdhu yi buur geew ne ngio, e dhaano uyoadu, ngaa me kaahn dag piih. Buodhu ngo uwahdhe ka ucidhu keehde tiehd paan cea yea. ");
INSERT INTO lwo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Robu ngo yihr ngad paan nu kejea, ‘Arob ngad puohnye kejea, “Wod weehle naa agwiiri ne kee beere beehn ne cam Yaan Amono yea keehd jo waahdhe?” ’ ");
INSERT INTO lwo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wod cam me laaj maa agwiir unyoadhe yihru wod maalo kun caadi. Gwiiru giih nye pinye yea bang cam yihro.” ");
INSERT INTO lwo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Gihn nu arumo naa acidh gene, e ge yuud giih ni ateed Jeacuue yihr gen wa kwaad kaa anaa ateede gen kii ngo, noono arumo e giih nyepinye ge agwiir gene gwiiro ke nying Yaan Amono. ");
INSERT INTO lwo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Naa abeehn kar came arumo, e Jeacuu ake piih wiih tharbeany cam tiehd keehd jo waahdhe. ");
INSERT INTO lwo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Batiene maa arube yihr gen kejea, “Bange anaa ayuoga keter yaage, beere Yaan Amono gihn ni, naa ayugo umodho keehd wun tiehd nye ka poohde e raahm gihra kuu abeehn riha ni. ");
INSERT INTO lwo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Abea adiehr roba robo yihru kejea Yaan Amono me wa gihn ni muu ucahga camo keehd wun keehdo tooro nea padh cahng ukobe kejea lum gihn ne yi Yaan Amono e naa ayug ree, beere Juog nyoge giih adoohng ne joe ni ge mage mago.” ");
INSERT INTO lwo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Batien robe noono e Jeacuue kubaayo akaabe kaabo maa amuohje koohr Juog urube kejea, “Kaabu gihn, upaahngu ngo ke rogu. ");
INSERT INTO lwo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Awaahn ni ngo roba robo yihru kejea koongo me wa gihn buu ucahga ke maadho keehdo nea padh cahng adoohng Juoge ne ruohdh kii ngo e naa abeehno.” ");
INSERT INTO lwo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Keehdo e Jeacuu amono acahge kaa kaabo, abea naa athume ke muohj koohr Juog, e amono atoye toyo upaahnge ngo yihr gen e urubo kobe, “Gihn ni beehda kuohma maa gihn muu ulam piny ke nyingu. Yugu ngo wa maano uparu an keehd ngo.” ");
INSERT INTO lwo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Dahng keehd dhe yooh ni keehdo naa athum cam, e kubaayo acahg Jeacuue kaa kaabo urube kobe, “Kubaayo gihn beehda e naa dhe yoohn ka beehn Juoge uyuge anweehd me nyaahn keehd nyoge. Dhe yoohn anweehd gihn nu uyug Juoge kaa rema, ge uwoj piny ke nyingu ni. ");
INSERT INTO lwo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Abea be niidu ne! Wa ngaan uluom an nud kan keehd an tiehd wiih tharbeajo. ");
INSERT INTO lwo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A ge adoohng ne dhaano utaahngo, a uthow wa kaa akob naa ree uyuge abea ngaa luom an ge adoohng ne dhaano utaahngo unaa yi gihn me raaj ne waany.” ");
INSERT INTO lwo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Arumo maa athub jo oohr ke rob e ge peehny rog gen kob gene kejea, “Ngaa e nuu uyug kwaad gihn raaj wa gihn nu?” ");
INSERT INTO lwo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Thiow peehm ree anaa ayuge kiin gen kejea ngaa kiin gen e naa ngaa duohng gen. ");
INSERT INTO lwo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Maa arob Jeacuue ngo yihr gen kea, “Yaage ruohdhe giih upiny kan ge nyoge me kwihj lum Juog ni, paajo mag gene yihr nyoge kaa dhe yoohn tiel kedea kaa dhe yoohn bahng now. Abea keehd maan amag gene nyoge keehd dhe yoohn bahng wa maano nu, e ge poohd cuohn nyoge cuohno ne gome giih gen. ");
INSERT INTO lwo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Abea nea maru e padh ne maano. Nea kare ne cohg e ngaan akob kejea e naa ngaan wiih ne maalo, ne duohng yihru cang, yuge ree wa e naa ngad dhe caahn ge thiin kiin nu, e naa acub ne ruohdh nahge en naa ngaa tiihy yihru. ");
INSERT INTO lwo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nea maru, e ngaa e ne duohng? Ngaan apiih kar bahbe ne cam ne? Wale ngaan cub cam nyum ngaa apiih kar bahbe? Ngahda ngaan apiih kar bahbe ne? Abea maanyu an kaa ayuga riha kiinu ne ngaan cub cam nyumu. ");
INSERT INTO lwo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Wu gen naa yaa acuung ngahya ne cohg yihdh giih teeg naa aguuma. ");
INSERT INTO lwo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Abea awaahn ni, teeg mara naa acub Juog Wura yihra ni, ngo acuba yihru. ");
INSERT INTO lwo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yuga yugo wa gihn nu beere cahng moogo, e wu beehn ne piih ucahmu umahdhu keehd an tiehd wiih koom ruohdha ge adoohnga ne ngaa maa ruohdh wiihe. Wu upiih thiow ne ruohdhe wudh koome unahge wun nuu ungol luwe giih dhog wuude giih yaa Yijarael ge apaar wonge ariow piny. ");
INSERT INTO lwo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Cimoan! Atiihb ukeehg wu anaa adaahde beere wu nea kuoro wa gihr ngaa me kuor beel? ");
INSERT INTO lwo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Abea Juog akwaya ke nyingi yih Cimoan, udoohngi teeg ubahnge yiiho gihri yea be duoge caahn. Nea cwihnyi aduui banga kea na cahg cwihny yaai ke ciihmo keehdo udoohng cwihny gene teeg thiow!” ");
INSERT INTO lwo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Gihn nu e ngo abeehr Piihtere beehro yihr Jeacuu kobe, “Ruohdh nea beehda kaa ngo, kea a daahde thiow udhiila cidho keehd yihn yi karkoohn wale nea gihn ngo beehda naahg kejea yih ke naah e a dhiil kaa naah thiow uthowa keehd yihn tiehd.” ");
INSERT INTO lwo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","E gihn nu acahg Jeacuue kaa duogo yihr Piihter kobe, “Piihter, adiehr e ne roba yihri. Tihn noon ni yi dewaahy tihn maano e uthuonjieno poohd kuu akoohg e yih ukweer ke an tiel adahg kejea a kwihyi.” ");
INSERT INTO lwo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Batiene e Jeacuu jo waahdhe ge apeehnye kobe, “Do nye yaage, ge anaa aoohra wun ne cahng, mapade kedea jooge maa wuoy tiel maa anaa akaahnu ge anaa anudo ne? E thiow ne gihn maa anaa adaag yihru ne?” E ngo abeehr gene beehro yihr Jeacuu kob gene, “Bahng gihn maa anaa adaag.” ");
INSERT INTO lwo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kob Jeacuue kea, “Beer kea noono awaahn ni, nea ngaan yihre ne mapada wale yihre ne joogo e kea beehne keehd ngo thiow. Abea ngaa toor pale yihre, ngeewe waahre oogo, ungeehwe yihre keehd pala acielo, ");
INSERT INTO lwo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","bang gihn aroba yihru kejea giih anaa agweed yi kitaab Juog ni, e rubo kejea, ‘Ngaan anaa arob, nyoge utiihy ree keehd dhe yooh me wa e naa ngaa me raaj.’ Gihn nu arob kitaabe ke nyinga nu, ree udhiile kaa ngo wa kaano agweede nu.” ");
INSERT INTO lwo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Noono e jo waahdh Jeacuu ge ake rubo yihre kob gene, “Maahny! Pale ariow amuu yihr wan!” Maa abeehr Jeacuue ngo kobe, “Kea kwihyu loo wa gihn nu yaage.” ");
INSERT INTO lwo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Batiene maa a'aay Jeacuue ucea wiih Good Ulihbe, bang gihn beehda gihre me na kwaaye kaa yugo. Thiow jo waahdhe ge anaa acidho ke batiene. ");
INSERT INTO lwo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Naa awahnh Jeacuue kaa ngo arumo, e ngo ake rubo keehd gen kobe, “Yaage! Kwahyu Juog beere wu be tum atiihb ukeehge.” ");
INSERT INTO lwo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Gihn nu e anyiig wong maalo kar keede, ka me cahng mee keehd gen, me rom doohdo keehd abahdo ke leelo. Noono maa arunge cuunge piny uthube ke kway Juog e urubo kobe, ");
INSERT INTO lwo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Abaa Wura! Nea kare nud, e raahm gihn keá meehg wahnh riha! Mare meen padh wa kwaad ka daahd cwihnya ngo, abea beehda kar cwihnyi me daahdi.” ");
INSERT INTO lwo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","(Noono e wuohnjuog abeehn bange ke maalo beere e beehn ne ciihm cwihny Jeacuu umage cwihnye teeg.) ");
INSERT INTO lwo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kaano anieng raahm aduule ree keter nu, e ngo acahg kwaj keehd leehdh cwihnye maa ne kwahge thuudh ree e toon piny wa remo. ");
INSERT INTO lwo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Naa a'aje maalo piny kar kwaj e ngo abeehn bang jo waahdhe, e ge ayuude e ge aneno, bang gihn keehd gen thiow koohm gen anaa athyaay keter bang gihn ge anaa amag raahm aduule thiow. ");
INSERT INTO lwo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Batiene e Jeacuu ake rubo keehd gen kobe, “Yaage gihn e ne niinu? Yedhu maalo ukwayu Juog ungahyu cuungu teeg mee yihdh giih utum ge beehn wudhu ni.” ");
INSERT INTO lwo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kaano anaa apoohd Jeacuu e urubo keehd jo waahdhe nu, e akuud nyoge anaa acaahj bang gen. Juudo e naa abeehno keehd gen, Juudo anaa kiin jo waahdh Jeacuu ge apaar wonge ariow ni. Noono ubar Juudo ke bang Jeacuu ne kew uciime Jeacuu ciimo yi thaahnge. ");
INSERT INTO lwo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Maa arob Jeacuue ngo yihre kobe, “Juudo! A ge adoohng ne dhaano utaahngo, a ne luomi kaa ciihmo ge aciimi an ne?” ");
INSERT INTO lwo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Abea gihn nu naa aniid jo waahdhe ngo e ree aloge ne gihn me raaj muon, e Jeacuu apeehny gene peehnyo kob gene, “Ruohdh! Wal wane pale giih wan ne?” ");
INSERT INTO lwo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kaano e dhaano acielo kiin gen pahle ayuohdhe ke oogo ungole yih kwiihj gihr ubaahng me tiihyo paar ngaa duohng yaa lam. Yih ngo angole piny ne thihb. ");
INSERT INTO lwo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jeacuu ake rubo yihre kobe, “Athum! Kwaad gihn nu keá tiihj keehdo.” Batiene maa agweele yihy nyin atoohng ni, uthiehdhe ngo ke wong kaano. ");
INSERT INTO lwo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Gihn nu e Jeacuu acaa ne rob keehd jo doong yaa lam giih kweehr piny kedea acaakere giih koar Wod Juog piny ni maa jo doong paajo naa abeehno kobe, “Nye yaage, beehda gihn ne cohg e naa abeehnu banga e wu kaahn pale kedea belunge kii cingu? A beehda ngaa maa apaahr dom rih akuumo yihru ne? ");
INSERT INTO lwo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Wa a na kwaay beehdo keehd wun tiehd yi Wod Juog ke nying nihn, gihn e naa agoohg dhe yoohe yihru maa anaa amagu an? Beer, tihn beehda cahngu utiihyu kwaad gihru ne tiihyu riha, bang gihn piny poohd beehda gihr atiihb ukeehg utiihy gene.” ");
INSERT INTO lwo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Batiene arumo e Jeacuu akaab gene kaabo maa abeehn gene keehd ngo paar ngaan duohng yaa lam giih kweehr e Piihter ake cidho thiow e ge buodhe kaa nye ka me lied mee. ");
INSERT INTO lwo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Abea naa a'ahb maaj yi diehr kala. Kedea ubeehn nyoge upiih gene ne oohyo e Piihter ree amade ke bang gen ne oohyo thiow. ");
INSERT INTO lwo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nyaakow me tiihyo paajo Piihter aniide e apiih. Gihn nu e ngo amaanye beer mee maa arube ke nying Piihter kobe, “Nyin ni beehda ngad Jeacuu thiow!” ");
INSERT INTO lwo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Maa apeehm Piihtere kobe, “Ngadi ge robi ni kwihya!” ");
INSERT INTO lwo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Batien ka me thiin keehdo e nyin moogo Piihter acahge kaa niido maa arube kobe, “Yih beehda ngad gen thiow.” E gihn nu abeehr Piihtere beehro kobe, “Nyieh! A padh ngad gen!” ");
INSERT INTO lwo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Batien caa acielo e nyin moogo keehdo gihn ni acahge kaa niingo kobe, “Adiehr now. Nyin ni beehda ngad gen ne cohg thiow, bang gihn ngo beehda ngad Gaalili ke ngude.” ");
INSERT INTO lwo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Maa acahg Piihtere peehm kobe, “Nyieh! Gihri noono arobi nu kwihya ne weey weey.” Ke wong kaano e uthuonjieno ake koohg adhaahr e Piihter apoohdo e ngo urubo. ");
INSERT INTO lwo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Muudhe e Jeacuu wiihe aloge umaahnye bang Piihter. Noono maa apare gihn anaa arob Jeacuue yihre, “Tihn noon ni, yi dewaahy tihn maano e thuon jieno poohd kuu akoohg e yih ukweer ke an tiel adahg kejea a kwihyi.” ");
INSERT INTO lwo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Maa athub Piihtere ke lalo ke keej yej naa angeye deeh awuohj gihn atiihye. ");
INSERT INTO lwo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Arumo e yaa anaa acub Jeacuu yi cing gen ne koar ngo piny kuohm Jeacuu amaahd gene kaa ngiero udhohng gene ngo dhohngo thiow. ");
INSERT INTO lwo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kaano e wong Jeacuu atuohy gene maa athub gene ke peehny ngo kob gene, “Nyieh! Caar ngaan agooj yihn?” ");
INSERT INTO lwo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Maa arub gene yi kuohm Jeacuu keehd giih mooge me reje e ge yaahl kuohme. ");
INSERT INTO lwo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ke nyango naa aruu piny, e akuud jo doong paajo maa jo doong yaa lam maa yaa loohng wudh ge acong gene congo. Noono maa akahl Jeacuu nyum lug gihr gen arumo. ");
INSERT INTO lwo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Maa apeehy gene kob gene, “Nea yihn naa Kriihjto kea rob ngo yihr wan!” Maa abeehr Jeacuue ngo yihr gen kobe, “Keehd ne roba ngo yihru, e padh gihn muu uyiihu. ");
INSERT INTO lwo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kedea nea wu peehnya peehnyo, e wu ukweer ke beehre yihra. ");
INSERT INTO lwo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Abea keehd maano, thube ke wong kan awaahn ni, a ge adoohng ne dhaano utaahngo, a upiih wiih koom ruohdh ukwiihy Juog.” ");
INSERT INTO lwo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Noono arumo e Jeacuu acahg gene ka peehnyo ke kar gen cang kob gene, “Beehda yih naa Waahd Juog ne?” Maa abeehre ngo kejea, “Ne cohg keree yea kaa ayoadu!” ");
INSERT INTO lwo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Maa arub gene arumo kob gene, “Abea gihn, e ne cahgo ke daahdo keehdo? Wa gihn ngo noono alihngo e beehn oogo kii dhee wa kaano arobe ngo nu!” ");
INSERT INTO lwo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Batiene e amahr dhaano utaahngo gihn anaa amahdo a'aj maalo ukahl gene Jeacuu nyum Pilaato ge muudiihr. ");
INSERT INTO lwo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Batiene e ge athub ke rob kwaad giih aluom gene Jeacuu ke nying gen yihr Maamuur Pilaato e ge urubo kob gene, “Nyin ni ayoad wane e ngo cood wudh jo paajo yihr wan. Ngo ukweer kejea cuol keá gwaaj ucube yihr Jaah Roama. Arubo thiow kejea en ke ngude en naa ruohdh arob naa ubeehn ni.” ");
INSERT INTO lwo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Batiene e Pilaato Jeacuu apeehnye peehnyo kobe, “Yih naa Ruohdh gihr yaa Judea ne?” Maa abeehr Jeacuue ngo yihr Pilaato kobe, “Yih naa arob ngo ke dhii!” ");
INSERT INTO lwo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","E Pilaato ake rubo keehd jo doong yaa lam maa nyoge cang kea, “Yaage! Awuohj maa ayoada rih nyin tooro.” ");
INSERT INTO lwo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kaano e Pilaato ayong gene yongo keter e ge urubo yihre kob gene, “Beehda nyin me wudh nyoge araanye keehd puohny mare ke bang yi Judea cang, thube ke Gaalili ne caadi ubeehne paajo kan yihr wan.” ");
INSERT INTO lwo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","E Pilaato gihr gen naa arob gene abeehne ke ne lihngo arumo. Noono maa apeehnye gen kejea Jeacuu beehda ngad Gaalili ne. ");
INSERT INTO lwo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Maa arob gene ngo yihre kejea Jeacuu beehda ngad dhaahr Eroade. Kaano e Jeacuu abeehn Pilaate ke ne oohr bang Eroade. Yi caang nu thiow ke ngude Eroade kaa anaa abeehn geen Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Naa akahl Jeacuu nyum Eroade arumo e cwihnye ake mihno ne cohg bang gihn aniide Jeacuu ni. Cwihnye amihno bang gihn bang Jeacuu na ulihngo yihre ke deeh ka me laaj kedea ugaahne ngo thiow kejea ka moogo e Jeacuu deeh gihn me gaahy nyoge ne yuge buude kaano. ");
INSERT INTO lwo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Gihn nu maa ayane ke peehny Jeacuu kaano ne cohg. Abea kihde now gihn maa abeehr Jeacuue yihr Eroade tooro ne weey weey. ");
INSERT INTO lwo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Noono e yaa doonge nyum yaa lam kedea yaa loohng ge anaa adhal ke rob giih me doonge me teeg rih Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Keehdo Eroade kedea acaakere giihe, giih ajohr mooge me reje me keehne abeehn gene ke ne yugo rih Jeacuu. Eroade Jeacuu ameehge ngaabo keehd kwaad waaro maa awuob kedea ucahge Jeacuu ke oohr bang Pilaato. ");
INSERT INTO lwo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Cahng nu e naa kaa abeehn gome kiin Pilaato ge keehd Eroade bang gihn ge anaa abeehdo e ge akeehg ke rog gen. ");
INSERT INTO lwo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Batiene e Pilaato wudh jo doong yaa lam kedea ruohdh paajo maa nyoge mooge, ge acongo ");
INSERT INTO lwo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","maa arube yihr gen kobe, “Nyin akahlu yihra kejea ngo beehda ngaa me raaj, me raany wudh yaa paajo yihru. Abea naa amaanya yi gihn akahlu ngo banga ke nyinge, e gihn me raaj maa aniida tooro ree, wa kwaad ka arobu ni kejea ngo ayug gihn me raaj. ");
INSERT INTO lwo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","E thiow keehd Eroade ke ngude, gihn maa ayoade rih Jeacuu tooro maa awuohj. Ke nying gihn nu naa gihn adhiile Jeacuu ke duu banga noono. Maahnyu arumo, awaahn ni gihn me raaj maa ayuge me kihme thoo ke nyinge tooro ne weey weey. ");
INSERT INTO lwo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nea wa gihn nu, e cuow now e nuu ucuowe, abea ngo dhiila kaa lonyo.” ");
INSERT INTO lwo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Naa athum Pilaate ke rob gihn ni, e nyoge ajuohj moogo agooy gene ke piny, e ge urubo keehd Pilaato kob gene, “Nea yih daahde kejea ulunyi dhaano oogo ke nying wan, kea lunyi Barabaj oogo abea nyin keá lonyi kahl cingi oogo ree beere ngo ke naah. Kaano e dhaano acielo ake lony oogo yihr ge ke nying yaay.” ");
INSERT INTO lwo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabaj anahg ngaa maa anaa amag kaa nying kwaad alyaahb maa anaa ayug ree yi buur geew thiow dhaano anaa anahge.) ");
INSERT INTO lwo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Batiene keehdo e Pilaato acahg rob keehd nyoge, mare ngahde kejea gihre ulihng gene ulunye Jeacuu oogo ubahnge be nahg. ");
INSERT INTO lwo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Abea ka gahng. Nyoge acahg kwaago keehdo e ge urubo kob gene, “Meehg nyin naah yihr wan ke dhe yoohn gure wiih yaadh maa ariihw!” ");
INSERT INTO lwo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yi dahg gen keehdo e Pilaato acahg rob keehd gen kobe, “Kaa nying gihn noono koohbu kejea nahge? Gihn noono raaj ge awuohje ne? Gihn me raaj maa atiihye me nahge ke nyinge tooro maa ayoada yi guohbe. Nea wa gihn nu e cuow now e nuu ucuowa ngo abea ngo dhiila kaa lonyo.” ");
INSERT INTO lwo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nyoge wudh ge aciehg gene e ge rubo e doohn gen atihng gene maalo kob gene dhiil Jeacuu ke naah e gur wiih yaadh maa ariihw. Maa agoohg gene Pilaato yi gihn nu arumo keehd dhe yoohn kwaago naa akwaag gene ukaale toohge. ");
INSERT INTO lwo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Noono ubeehn Pilaate ulwaaye lum nu yi cing gen wa ka daahd gene kejea dhiil Jeacuu ke naah. ");
INSERT INTO lwo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Gihn ni e naa kaa abeehn Pilaate, ugoonye cinge rih Jeacuu beere ngo ke naah wa kar cwihny gen naa adaahd gene. Abea Barabaj ngaa raaj naa adaahd gene kejea lunye oogo e naa aluny Pilaate oogo yihr gen neehn kar cwihny gen naa adaahd gene. ");
INSERT INTO lwo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Batien gihn nu e acaakere ge a'aay keehd Jeacuu e ngo piej gene piejo. Abea ge anaa acaahdh gene caahdho ni, e ge ake roohmo keehd Cimoan ngad Ciriihna maa anaa abeehn geen Jeruucalem. Batiene e acaakere yaadh gihn ariihw naa abien Jeacuue bieno alaw gene kuu utog Cimoane, ucaahdh Cimoane caahdho e bien ngo ke batien Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Gihn nu maa abeehn amahr nyoge me thoohdh maa awaahd gene e ge buodh Jeacuu. Maahn me thoohdh thiow ge anaa anudo maa anaa ne yuog bang Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kaano e Jeacuu wiihe aloge ke bang maahn giih anaa ake yuog maa arube yihr gen kobe, “Nyetheamaahn Jeruucalem, gihn keree e ne yuogu, gihn me yuogu tooro ke nyinga, yuogu kaa nyingu wu keedu kedea yuogu kaa nying nyethenu. ");
INSERT INTO lwo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bang gihn cahng moogo ubeehn muu urub nyoge kejea, ‘Dhaar agaahg, maa dhaar kuu anaa akuong nyuol, maahn giih nu ge ne rog gen umed. E thiow maahn giih thun gen kuu akuong nyethiine ke dhoodho ge ne rog gen umed thiow!’ ");
INSERT INTO lwo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Thiow dahng unahg cahng nu, ‘E nuu urub nyoge yihr goode kejea, “Goode, pahdhu wudh wan ukanu wan.” ’ ");
INSERT INTO lwo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Abea nea ge naa giih atiihy nyoge riha noono a ngaan beer neehn kwaad yaadh me thej ni, gihn nuu uyug gene rog yaa beehda nyoge me reje, ge room keehd yen maa atal ni?” ");
INSERT INTO lwo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nyoge ariow mooge ge anaa anudo maa anaa ayug awuohj. Ge anaa apiehj ne naah thiow tiehd keehd Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Batiene e nyoge awahnh kar piny me cuohn ne paan wiih dhaano. Maa abeehn nyoge ugur gene Jeacuu wiih yaadh maa ariihw arumo. Thiow yaa ni ariow ni ge anaa agur wudh yen muu gen ucing Jeacuu, ngaa man ucaame kedea ngaa man ukwiihye. ");
INSERT INTO lwo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kaano e Jeacuu ake rubo kejea, “Abaa Wura wii lubo piny yihr yaa ni apaan an, bang gihn, gihn ni ayug gene ni, lum nii ngo kwihy gene.” Arumo maa abeehn acaakere maa athoohr gene thalo wudh waay Jeacuu upaahng gene gen ke rog gen. ");
INSERT INTO lwo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nyoge me thoohdh anudo maa anaa ake cuungo e ge many Jeacuu. Abea e ruohdhe giih Judea kuohm Jeacuu anaa abuy gene buyo e ge urubo ree kob gene, “Nea mare kea e beehda ngaa me kony nyoge mooge kea noono konye ree nea ngo beehda Ngad Boadh nyoge maa akwany Juoge.” ");
INSERT INTO lwo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Keehdo kaano maa abeehn acaakere ubuy gene kuohm Jeacuu thiow maa acub gene koongo me waj yihr Jeacuu ");
INSERT INTO lwo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","maano e ge urubo yihre kob gene, “Nea yihn naa Ruohdh Judea, kea kony rihi.” ");
INSERT INTO lwo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Gihn moogo maa agweed ucube taahr nyum Jeacuu rih yaadh gihn agure wiihe ni anaa anudo. Ngo anaa gweed naa, “RUOHDH YAA JUDEA.” ");
INSERT INTO lwo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kaano e dhaano acielo kiin yaa ariow ge anaa agur wiih yaadh maa ariihw buud Jeacuu arubo thiow rih Jeacuu kobe, “Nea yihn naa Kriihjto do, kea kony rihi beere keehd wan e wa konyi konyo thiow.” ");
INSERT INTO lwo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Abea e mar ngaa man goan ucing kun arob ngo yihr nyin arubo kobe, “Nyieh! Kuohmi be tud ke ne gihn rih Juog? Ngahda wo nywaag ukihm acielo keehd en tiehd ne? ");
INSERT INTO lwo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Abea tien mare gihn? Nea beehda gihn maa kaa ngo ne cohg, e maro wo akihm kaa nying awuohj maa atiihyo. Abea mare gihn? Beehda ngaa me yea tar now. Gihn maa ayuge me raaj tooro.” ");
INSERT INTO lwo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Keehdo ubeehn nyin ni uloge dhee ke bang Jeacuu urube keehd ngo kobe, “Jeacuu nea yih wahdh kar ruohdhi kea naa konya thiow!” ");
INSERT INTO lwo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Maa abeehr Jeacuue ngo yihr nyin arumo kobe, “Adiehr muon! Roba robo yihri kejea tihn noon ni wo unaa ka maa acielo paar Juog keehd yihn tiehd.” ");
INSERT INTO lwo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kaano maa abeehn deeh muudho umoale wiih paajo piny cang ne cihdh cihdhi. Naa athube e cahng nii diehr wihj uwahdhe kaa alaahng cahnge e gihn me neehn tooro ");
INSERT INTO lwo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","bang gihn cahng kuu anaa ke lier. Kaano e waaro gihn anaa apaahng kur Dhe Wod ke kur Dhe Tiel yi Wod Juog, yea ayiej ree piny ne dahg naa ariow. ");
INSERT INTO lwo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kaano e Jeacuu amaahr piny ke lalo e duone atihnge maalo keter kobe, “Abaa! Wahya ge awiia yi cingi.” Naa arobe gihn ni e ake thoo. ");
INSERT INTO lwo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Naa aniid jaabidhe gihn ni ayug ree ni, e Juog awuore wuoro keter e ngo urubo kobe, “Ngo kaa anaa anahg gihn maa adiehr ne cohg! Nyin kaa anahg ngaa me yea tar athiir muon!” ");
INSERT INTO lwo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Batiene e amahr dhaano utaahngo naa abeehn ne maahnyo, kaa aniid gene kwaad gihn ni ayug ree ni, e ge apahdh yooh e ge aay e ge teeng koohdh gen yih rahny cwihny. ");
INSERT INTO lwo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Abea, amahr yaa angahy Jeacuu kedea maahn giih anaa ake caahdho tiehd keehd Jeacuu, kaa anaa apoohde e ngo ne Gaalili ni, ge noono cang, ge acuungo ka me baahr, e ge maany giih nu atiihy rog gen. ");
INSERT INTO lwo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kaano e nyin moogo anudo me nyinge Jocebe maa abeehno ke geew me cuohn ne geen Arihmathea yi Judea. Ngo anahg ngad Akuud Judea kedea thiow anahg ngaa me beer keter. Tiene anaa tooro yihdh kwaad giih ni anaa ayug yaa Akuud Judea rih Jeacuu ni. ");
INSERT INTO lwo_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","E thiow anahg ngaa maa anaa abeehdo e koar dhe yoohn ka beehn Juoge ukonye nyoge kii ngo. ");
INSERT INTO lwo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Noono e Jocebe, acaa bang Pilaato ne rob keehd Pilaato beere kuohm Jeacuu meehg kaabo yihre ubeehne ngo ne kano. ");
INSERT INTO lwo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Abea naa ayiih Pilaate ngo yihre, e Jocebe kuohm Jeacuu akahle ke piny wiih yaadh atudo naa agure wiihe, ubahje keehd waahr thoo ucea ngo ne piehl yi wod leelo maa abeehdo e agwiir ne kar kan koohm yaa paar gen. Thiow wod gihn akane kuohm Jeacuu yea ni, kihd dhaano maa athow kuu akuong ke kano yea. ");
INSERT INTO lwo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Cahng ni, anahg gwiihdo bang gihn ruuwow beehda Cahng Cabadh e bahnge nyoge be tiihyo yea. ");
INSERT INTO lwo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Maahn giih anaa ake caahdho keehd Jeacuu nye kaa anaa apoohde Gaalili ni, batien Jocebe abeehn gene ne buodho kaano akane kuohm Jeacuu nu. Noono maa aniid gene kaa akan Jocebe kuohm Jeacuu yea. ");
INSERT INTO lwo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Muudhe kaano maa aay gene ne dog miehy gen ne gwiir mahdhe me ngwaahy bang doar kuohm Jeacuu keehd gen. Maahn kuu acahg duu kar liel keehdo bang gihn ruuwow gihr cahng nu anaa anahg cahng Cabadh bang ne yug gihr lum loohng ke nying cahng Cabadh ne cohg. ");
INSERT INTO lwo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ke nyang coon, yi Cahng Juog arumo e maahn rog gen atihng gene tihngo e ge caa ne liew liel e mahdhe me ngwaahy naa agwiir gene kaahn gene kaahno. ");
INSERT INTO lwo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Naa awahdh gene kar liel arumo, e leelo me duohng mee gihn anaa aloohr dhe liel keehd ngo ayuud gene e ngo aloohr oogo. ");
INSERT INTO lwo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kaano umon gene kii loohro. Naa acidh gene yea, e kuohm Jeacuu Ruohdh ayuud gene e ngo tooro kaa naa apiehle yea. ");
INSERT INTO lwo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ucuung gene kaano yi wod loohro, e wudh gen ane dihl ke kwaad gihn ayug ree. Yi wong kaano e nyoge ariow maa angaab waare me ne mihl mihl ge anaa caahj bang gen. ");
INSERT INTO lwo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Keehdo e maahn giih wudh gen akuul gene ke piny, e ge amag lwahre ne cohg. E yaa ni ge ake rubo yihr maahn giih kejea, “Yaage, ke nying gihn e ne daahdu ngaa me kuow kiin nyoge maa athow? ");
INSERT INTO lwo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ngaan daahdu ni tooro kan keehdo! Ngo acahr. Paru wudhu ne giih anaa arobe yihru ge apoohde e ngo ne Gaalili ni. Ngo anaa arobe yihru kejea, ");
INSERT INTO lwo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘A ge adoohng ne dhaano utaahngo, a dhiil kaa cub yi cing yaa anyoohne. Thiow, a ubeehn gene ne gur wiih yaadh maa ariihw. Abea yi dahg nihn arumo, e a ucahro.’ ” ");
INSERT INTO lwo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Muudhe kaano arumo e kwaad giih anaa arobe muon yihr gen, ge abeehn maahn giih ni ke ne paro cang ke kar gen. ");
INSERT INTO lwo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Batiene maa a'aay gene kar liel beere ge caa ne kwaan thaahdh giih aniid gene naa ayug rog gen yihr jo oohr kar ge apaar wonge acielo kedea nyoge mooge maa anudo keehd gen thiow. ");
INSERT INTO lwo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maahn anaa aci kar liel anahg Maarya Madaleana, Joana maa Maarya miih Jeamij. Ge noono kedea maahn mooge maa anudo tiehd keehd gen, gen naa arob giih ayug rog gen kar liel yihr jo waahdh. ");
INSERT INTO lwo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","E jo waahdh ge abeehn ne kweer ke yiih gihn arob maahne yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Abea kaano e Piihter apaahr maalo ugoohde ke kar liel beere caa ne maany gihn ayug ree ne cohg. Naa awahdhe kar loohro e agong piny, ulwaahnge wonge yi loohro e waare me tar now ge naa aniide piny, abea kuohm dhaano naa anaa abahj keehd gen keá niido. Maa a'aay Piihtere e dhee atal ne kwaad gihn ni atiihy ree ni. ");
INSERT INTO lwo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yi cahng ni acielo ni, e nyoge ariow mooge maa anaa anahg jo waahdh giih Jeacuu thiow, rog gen atihng gene ne ci paajo me nyinge Emaaw. Paan ngo thiow keewe keehd Jeruucalem beehda kar meale abiihjberiow. ");
INSERT INTO lwo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ge anaa acaahdho, e ge coar wudh gen ke kwaad luube giih ni atiihy rog gen ni. ");
INSERT INTO lwo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Gihn nu, e Jeacuu ke ngude ree amahde ke keew gen unywaag gene yooh tiehd. ");
INSERT INTO lwo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Abea keehd maano aniid gene Jeacuu nu, e ngo agoohg yihr gen ke ngeyo. ");
INSERT INTO lwo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Noono maa apeehny Jeacuue gen kejea, “Nye yaage, wu caahdhi e wu rob gihn ke bang yi yooh?” Kaano e ge ake cuungo ne ngahg, maano e kaan nying gen rog gen alog gene bang raahj aduulo. ");
INSERT INTO lwo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","E dhaano acielo kiin gen me nyinge Keliopaj Jeacuu apeehnye peehnyo kobe, “Beehda yihn naa aweehno me ngihde yi geen Jeruucalem e kwihj kwaad giih atiihy rog gen yihdh nihn ni?” ");
INSERT INTO lwo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Maa abeehr Jeacuue ngo yihre kobe, “Beehda giih me ngihde noon ni ayug rog gen ge kwihya ni?” Maa abeehr Keliopaje ngo keehdo kee, “Beehde kwaad giih anaa ayug rog gen rih Jeacuu ge ka kwihyi ne? Jeacuu ge beehda ngad Naajaread ni, anaa anahg kwaad ngaa maa ngad lum Juog. E thiow ngo abeehde e ngahy Juoge kedea ungahy nyoge ngo thiow cang bang gihn ngo anahg ngaa me teeg keehd kwaad giih atiihye kedea keehd dhe yoohn puohny mare. ");
INSERT INTO lwo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Abea jo doonge giih paajo yaa lam giih kweehr kedea ruohdh paar wan ge abeehn ne aj maalo umag gene Jeacuu maa acub gene ngo ne kihmo ke thoo, ugur gene ngo wiih yaadh maa ariihw. ");
INSERT INTO lwo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","E thiow anahg ngaan anaa agaahn wane gaahno kejea ne nahg en ke ngude, e ne nahg ngaan ne luny yaa Yijarael oogo yi bahng noono. Abea tihn ke ngude, e naa adahw nihn batien kaa yug giih ni rog gen. ");
INSERT INTO lwo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Thiow, maahn mooge kiin yaa akuude giih wan maa anaa amool kar liene ne ci ne maany ngo cwihny wan ameehg gene baadh ");
INSERT INTO lwo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bang gihn naa aduu gene arob gene yihr nyoge kejea kuohm ngo kuu ayoad gene. Abea wuohdjuog ariow gen naa aniid gene. Maa arub gene yihr maahn kejea Jeacuu adoohng ne ngaa me kuow bang gihn ngo acahr. ");
INSERT INTO lwo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Dahng nyoge mooge kiin yaa akuud wan, ge abeehn ne cidho kar liel ne maany gihn ayug ree. Athiir muon ge anaa awahdh gene thiow e ngo ayuud gene e gihn maa adiehr wa kwaad kaa arob maahne ngo, abea Jeacuu kuu aniid gene.” ");
INSERT INTO lwo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","E Jeacuu ake rubo keehd gen arumo kea, “Wa wu beehda kwaad nyoge maa abeehl ne cohg! Wudhu ka teeg ne cohg wa maano, ge bahnge kwaad giih anaa arob yaa agamloohngjuoge cang ke kwaan gen be laaru ke yiiho wa gihn ne? ");
INSERT INTO lwo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ngahda anaa anahg gihn maa ateed kejea Jeacuu Ngad Boadh nyoge naa arob kejea ngo ubeehn uboadhe nyoge kuohme udhiil raahm yihdh kwaad giih ayug rog gen cang ne dug uthowe ne? Beere ngo udoohngo ne ngaa me yihre ne teeg Juog arumo keehd ruohdh mare ne?” ");
INSERT INTO lwo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Batiene maa athub Jeacuue ke kwaan yihdh kwaad giih anaa agweed piny yi loohng Juog naa arob ke nyinge arumo beehd wa kaa gweed gen yi loohng mar Moaje maa thiow kwaad luube giih anaa agweed yaa loohng Juoge maa akwaane gen piny yihr gen cang ke kwaan gen. ");
INSERT INTO lwo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Muudhe arumo e ge aguo wahnh buud paan anaa abeehn gene yea. Jeacuu kaano keehdo, ree anaa ayuge wa kwaad ngaa muu ubar keehd waahdhe. ");
INSERT INTO lwo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Maa amahn gene ngo e ter gene tero kejea keá bar. Urob gene ngo yihre kejea, “Ka me bari tooro, bang gihn cahng ayuudho beehne uburi keehd wan tiehd.” Kaano arumo e naa abar Jeacuue keehd gen tiehd ne piih. ");
INSERT INTO lwo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kaa apiih Jeacuue wiih tharbeajo keehd gen ni, e amono akaabe maa amuohje koohr Juog, utoye amono maa apaahnge ngo yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Naa apaahnge ngo ne ngio, e wudh gen ake yahbo arumo e naa kaa angey gene Jeacuu. Nye wong kaano thiow e Jeacuu anaa amad yihr gen, ubahnge ngo kuu acahg gene ke niido keehdo. ");
INSERT INTO lwo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Maa arub gene ke rog gen kob gene, “Gihn awaahn ni e naa agoohge yihro ke ngeyo, abea kar ngeye adoohng wa ngo anaa abeehn yi cwihnyo kaano arube rubo yihro e kwaane thaahdh luube yihro yi yooh giih nii kitaab Juog?” ");
INSERT INTO lwo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ke wong kaano uaj gene ke maalo uaay gene aay ke waahdh uduu gene Jeruucalem keehdo. Naa awahnh gene e amahr yaa anaa anudo naa amad wudh gen ka maa acielo keehd jo waahdh Jeacuu e ge ake rubo yihr yaa abeehno kar ge ariow kejea, ");
INSERT INTO lwo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“Ruohdho kaa acahr athiir muon ne cohg! Adhaahr ree anyoadhe yihr Piihter!” ");
INSERT INTO lwo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Maa athub gene ke kwaan gihn ayug ree yi yooh yihr gen kedea ukwaan gene dhe yoohn kaa abeehn gene ne ngeyo ngo ge atoare amono nyum gen. ");
INSERT INTO lwo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nye kaano anaa apoohd gene e ge rob giih ni ke rog gen nu, e Jeacuu anaa lwaahd ucuunge keew gen maa arube yihr gen kobe, “Maahdhu rihu ya! Dooj mar Juog acuba yihru.” ");
INSERT INTO lwo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Maa apahw gene oogo umag lwahre gen kwaade tooro, bang gihn mar gen cuohn gene kejea atiihbe ge naa aniid gene. ");
INSERT INTO lwo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kaano e Jeacuu ake rubo keehd gen kea, “Gihn e naa abuogu yihra ke nyinge? E thiow gihn e ne bahnge ngo be yiihu ke cwihnyu kejea beehda an e gihn niidu ni? ");
INSERT INTO lwo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Maanyu cinga kedea tiena. Beehda an ke nguda e gihn niidu ni! Gweelu cinga beere an ngeyu ngeyo thiow kejea atiihbe me kuohme nud wa dhaano utaahngo beehde tooro.” ");
INSERT INTO lwo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Athiir muon e cinge kedea tiene ge anyoadhe nyoadho yihr gen. ");
INSERT INTO lwo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Abea keehd maano, e cwihny gen apoohdo e udaag ke nying mihn cwihny gen. Maa apeehy Jeacuue kobe, “Ne cam me nud yihru ne?” ");
INSERT INTO lwo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","E nye goan reehyo maa athaal acub gene yihre. ");
INSERT INTO lwo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Maa akaab Jeacuue ngo ucame ngo nyum gen. ");
INSERT INTO lwo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jeacuu arobo yihr gen kobe, “Giih ni rog gen ayug gene wa kwaad kaa anaa aroba yihru umodho ge apoohde e a ubeehdo tiehd keehd wun. Kwaad giih anaa agweed yi kitaab loohng gihr Moaje ni kedea muu anaa agweed yaa agamloohngjuoge ni maa muu ne yihdh kitaabe giih Wahy Apoong Juog. Kwaad giih nu cang ge anaa anahg giih me ne dhiil rog gen ke tiihyo wa kaano anaa agweed gen piny unahg gene athere ne cohg.” ");
INSERT INTO lwo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Muudhe e wudh gen ayab Jeacuue yabo beere luube giih anaa yi kitaab Juog ngey gene ngeyo. ");
INSERT INTO lwo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Maa ateede ngo yihr gen kobe, “Gihn e naa gihn agweed yi kitaab Juog ke nyinga kejea Kriihjto ne thow udhiile cahro yi dahg nihn. ");
INSERT INTO lwo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Thiow anaa agweed ke nyinga kejea dhe yoohn ka ubeehn nyoge urahny cwihny gene bang anyoohne giih gen kedea kar wii anyoohne piny yihr gen thiow, luub nu dhe yoohn gen dhiilu kaa puohnyo yihr kwaad nyoge cang ne dug wiih piny, thube ke geen Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Wun naa cuude giiha ke nying giih ni ayug rog gen ni. ");
INSERT INTO lwo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Abea thiow roba robo yihru kejea ngaan anaa aceg Wura piny, ngo uoohra yihru. E thiow wu keá aay, dhiilu beehdo kan Jeruucalem, uwahdhe ka ubeehn tee gihn roba ni ke yoohn maalo upiihe wudhu.” ");
INSERT INTO lwo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Keehdo arumo e ngo ake aay keehd jo waahdhe, uwahdhe kaa abeehn gene paajo moogo me cuohn ne Bathany. Kaano e Jeacuue cinge ge atihnge ke maalo udooje jo waahdhe cang. ");
INSERT INTO lwo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ge adooje gen doojo e ge awiie piny utihnge Paar Maalo. ");
INSERT INTO lwo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Batien e ngo adoar gene doaro arumo uduu gene Jeruucalem, maano e cwihny gen adoohng med kwaade tooro, ");
INSERT INTO lwo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ubeehd gene e ge kwaay ci yi Wod Juog ne wuor Juog.");
INSERT INTO lwo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1"," Coon umodho e piny poohd kuu acag, Lubo abeehde e nud e ngaa moogo ke rode: Lubo anaa bang Juog kedea ngo Juog. ");
INSERT INTO lwo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Lubo anaa bang Juog kuu umodho coon e piny poohd kuu acag. ");
INSERT INTO lwo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Juog giih nyepinye cang ge acag kaa Lubo. Be gihn maa acage e keede e Lubo tooro yi ngo. ");
INSERT INTO lwo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ngaan nud ke rode e ne cub kuowo yihro. Kuowo gihn nu ke rode e ne meehg won ngahy Juog. ");
INSERT INTO lwo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Daahr meeny yi muudho abea wonge be rom muudhe ke bihjo. ");
INSERT INTO lwo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Juog wuohd gihre aoohre, dhaano me nyinge Joon. ");
INSERT INTO lwo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ngaa maa abeehno e beehda cuud me rubo ke nying daahr beere nyoge cang wuohdo gihn akahle lihng gene lihngo uyiih gene ngo. ");
INSERT INTO lwo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Padh Joon ke ngude e naa daahr maaj me meehg won ngahy Juog. Joon beehda cuud me rubo ke nying daahr. ");
INSERT INTO lwo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Daahr ni e naa daahr me ne cohg. Ngo beehn wiih piny bang nyoge beere Juog ngahy gene ngahyo. ");
INSERT INTO lwo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Lubo e beehda ngaa moogo ke rode abeehdo tiehd ke nyoge wiih piny kan. Abea keehd maa anahge en naa ameehg Juoge cag wiih piny, e yaa wiih piny ngo kuu abeehn gene ne ngeyo wa kaano nahge Lubo. ");
INSERT INTO lwo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ngo abeehn bang yaa paar gen, abea ngo kuu abeehn gene ne loro. ");
INSERT INTO lwo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Abea yaa alor ngo kedea uyiih gene giih arobe ge ameehge doohng ne nyethen Juog. ");
INSERT INTO lwo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ge kuu adoohng ne nyethen Juog ke dhe yoohn nyoohdo, abea ke nying gihn ayiih gene. ");
INSERT INTO lwo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lubo adoohng ne dhaano kedea ngo abeehdo tiehd ke won. Amahr muuny Juog kedea adiehj yoad bang Juog ge giih me ne yihre. Kaa amoar Juoge wiihe ne ngaa me duohng ngo aniido. Moar wihj gihn acub Wahne yihr Waahd Acielo. ");
INSERT INTO lwo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Joon beehda cuud maa arubo ke nyinge yihr nyoge e ukwaago kobe, “Ngaa ni e ne na ruba ke nyinge ge na koohba, ‘Dhaano nud muu ubuodh batiena. Ngaa me wiih tiihye ne maalo rih tiihya bang gihn ngo anudo ke coon e a poohd tooro kedea e a poohd kuu anyuol.’ ” ");
INSERT INTO lwo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Noono umuoje won naa aciel acielo kaa amahr muuny Juog giih ne yihre. ");
INSERT INTO lwo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Loohnge ge acub Juoge yihr Moaje ne cohg wudh nyoge. Abea gihn maa adiehr beehda thon Jeacuu Kriihjto e naa muuny Juog ne meehg won cidh Paar Juog. ");
INSERT INTO lwo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Bekihd ngaa maa akuong wonge ke keehl rih Juog. Ngaa ameehg ngo ngeyo beehda Waahde ge Aciel cog e beehda Juog kedea ge beehdo ke Wahn. ");
INSERT INTO lwo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Apahn yaa Judea ge beed geen Jeruucalem cahng man yaa lam giih kweehr kedea yaa kony yaa lam ge aoohr gene bang Joon. Naa abeehn gene bang Joon e ngo apeehny gene kob gene, “Wad wan! Teed rihi yihr wan. Yih naa ngaa?” ");
INSERT INTO lwo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kaano e Joon lum gen abeehre e gihn maa akane tooro kobe, “Padh an naa Ngad Boadh nyoge ge anaa akob Juoge kejea ngo ubeehn.” ");
INSERT INTO lwo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Maa adog gene ngo ke peehnyo, “Abea yih naa ngaa ne cohg? Ka moogo e yih beehda agamloohngjuog naa arub Moaje ke nyinge yi kitaab Juog, wale yih beehda Eliija ge akob naa ubeehn?” Maa abeehr Joone ngo kobe, “Bekihde! A padh agamloohngjuog kedea a padh Eliija.” ");
INSERT INTO lwo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kob gene, “Kea rob rihi yihr wan beere wa caa ne rob ngo yihr yaa aoohr wan. Teed rihi yihr wan ungahy tiihyi.” ");
INSERT INTO lwo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Maa abeehr Joone ngo e rob lum anaa arob Yicaaye ngad agamloohngjuog naa akoohbe kea, “Nud ke duol me kwaag yi ukang, ‘Gwiir yooh yihr Ruohdh ne cohg cohg.’ ” ");
INSERT INTO lwo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Anahg akuud yaa lum Juog me cuohn ne Paarijea ge naa aoohr yaa ni. ");
INSERT INTO lwo_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Noono maa apeehny gene Joon kob gene, “Nea yih padh Ngad Boadh nyoge kedea upadhi Eliija wale agamloohngjuog naa arub Moaje ke nyinge yi kitaab Juoge e luogwahy cubi yihr nyoge kaa nying gihn?” ");
INSERT INTO lwo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Maa abeehr Joone ngo kea, “Luogwahy mara ge cuba yihru kan, beehda luogwahy mar piih now, abea nud ke dhaano me ne kiino abea kwihyu. ");
INSERT INTO lwo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ngaan nu e nuu ulog beehno ke batiena. Abea ngo unahg ngaa me duohng riha gihn me a be rom goony thool giih wuoy tiene.” ");
INSERT INTO lwo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Luub ni ge arob Joone maano e ge anaa yi paan cuohn ne Bathany loo naam Joohrdoan. Anahg kaano e ne na muoj Joone wudh nyoge ke piih ne cub luogwahy yihr gen. ");
INSERT INTO lwo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ruuwow e Joon niid Jeacuu e beehn bange maa arube kea, “Ngaan nu beehn nu e naa gihr remo naa acub Juoge me nahg ne luog adhemuohm yaa wiih piny oogo. ");
INSERT INTO lwo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","E naa ngaa anaa aruba ke nyinge ge na koohba kaa, ‘Dhaano nud muu ubuodh batiena. Ngaa me tiihye wiihe ne maalo rih tiihya bang gihn ngo abeehdo e nud ke coon e a poohd kuu anyuol!’ ");
INSERT INTO lwo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","A ke nguda ngaa ubuodh batiena ngo kwihya nea ngo unahg ngaa me ngihde. Abea a apiih ne muoj wudh nyoge ke piih Juog bang ungahy Judea ngaan ngo.” ");
INSERT INTO lwo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Kaano e Joon arubo ke nying gihn aniide ke wonge kea, “Ngo akwihya kejea ngo unahg ngaa me ngihde. Abea Juog ngaa aoohr an ne muoj wudh nyoge ke piih arubo yihra kea, ‘Wahy Juog uniidi e luung piny wa aweehr ne beehn ne piih wiih dhaano e nuu unahg ngaa muu umuoj wudh nyoge ke Wahy Juog.’ ");
INSERT INTO lwo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Adiehr muon, Wahy Juog aniida e luung piny ke yoohn Maalo wa aweehr maa upiihe wiih ngo. Kedea ngo teeda teedo yihru kejea ngaan apiihe wiihe e naa waahd Juog e Ngad Boadh nyoge.” ");
INSERT INTO lwo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ruuwow moogo ke batiene gihn nu e Joon anaa ka cuungo ke nyoge ariow kiin jo waahdhe. ");
INSERT INTO lwo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Naa aniide Jeacuu e ukahnho ke buud gen, e ake rubo kea, “Ngaan ca niidu e naa gihr remo naa acub Juoge ne Ngad Boadh nyoge.” ");
INSERT INTO lwo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jo waahdh giih ni ariow naa alihng gene gihn arob Joone, e batien Jeacuu abuodh gene buodho. ");
INSERT INTO lwo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Naa alog Jeacuue wonge, e niid nyoge ariow me buodh batiene, maa apeehye kea, “Gihn e ne daahdu?” Maa abeehr gene ngo kob gene, “Ngad puohny yi beed kee?” ");
INSERT INTO lwo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Maa abeehre ngo kobe, “Beehnu ubeeh niidu kaa ngo.” Maa acidh gene keehde kedea uniid gene ka beede kedea uriih gene bange cahng nu uwahdhe kethiehno. ");
INSERT INTO lwo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Dhaano acielo kiin yaa ariow anahg Andrya ge umiih Cimoane. ");
INSERT INTO lwo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Noono uguoe aay ne cej umen. Naa ayoade ngo e arobe yihr ngo kea, “Ngaan akwany Juoge ne Ngad Boadh nyoge ayoad wane.” ");
INSERT INTO lwo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Noono ukahle ngo bang Jeacuu. Maa amaany Jeacuue bang ngo keraahyo maa arube yihre kea, “Yih Cimoane waahd Joon, awaahn ni, nyingi unahg Ceapaj.” Lum yea beehda leelo neehn Piihter. ");
INSERT INTO lwo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ruuwow keehdo e Jeacuu wiihe apare ne ci yi piny Gaalili. Maa ayoade Pihlihb kedea urube yihr ngo kea, “Mahd rih batiena.” ");
INSERT INTO lwo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pihlihb anahg ngad geen Bedhceada ka beed Andrya kedea Piihtere. ");
INSERT INTO lwo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Naa ayoad Pihlihbe Nathaneel, e kobe yihr ngo kea, “Ngaan akwany Juoge ne Ngad Boadh nyoge naa agweehd Moaje ke nyinge yi kitaab Juog kedea ge agweehd agamloohngjuoge ke nyinge ngo beehda Jeacuu waahd Jocebe e ngad geen Naajaread.” ");
INSERT INTO lwo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Maa apeehy Nathaneele, “Ne gihn me kony nyoge, me beehn oogo ke yoohn Naajaread ne?” Kob Pihlihbe, “Beehn uniidi ngo.” ");
INSERT INTO lwo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Naa aniid Jeacuue Nathaneel ubeehno e rubo kea, “Ngaan e naa ngad Yijarael me ne cohg ge be rubo ke toohd.” ");
INSERT INTO lwo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Maa apeehy Nathaneele kea, “Angeyi ke ne diih kejea a kwaad ngaa me wa gihn nu?” Maa abeehr Jeacuue ngo yihre kobe, “Yih aniida e yih apiih yi tubo thar dhuuro maano e Pihlihb yih poohd keá naa acuohno.” ");
INSERT INTO lwo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kob Nathaneele, “Ngad puohny! Yih beehda Waahd Juog. Yih beehda ruohdh yaa Yijarael.” ");
INSERT INTO lwo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Maa abeehr Jeacuue ngo kea, “Yih ayiiho ke nying gihn aruba kaa yih aniida yi tubo thar dhuuro. Giih mooge me doonge maa ayoohm man ge uniidi.” ");
INSERT INTO lwo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Maa arube yihr gen kea, “Gihn daahda ke robo yihru ngo beehda athiir me ne cohg. Maalo ree uyabe kedea uniidu an. A ge beehda dhe yoohn cidh Paar Maalo.” ");
INSERT INTO lwo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yi dahg nihn e kaahny anaa ke robo yi geen Kana ge yi piny Gaalili ni. Miih Jeacuu anudo thiow yi rob kaahny gihn nu, ");
INSERT INTO lwo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jeacuu maa jo waahdhe ge acuohn yi kaahny thiow. ");
INSERT INTO lwo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Naa abeehn koonge ne thumo e miih Jeacuu ake rubo yihr waahde kea, “Kuong giih gen athum.” ");
INSERT INTO lwo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kob Jeacuue, “Gihn e naa akahli nyinga yi gihn! Cahng tiihya yea ngo poohd kuu abeehno.” ");
INSERT INTO lwo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Maa arub men yihr yaa tiihj giih anaa acub piny ne paahng kuong kea, “Kwaad gihn rob waahda yihru, yugo ngo.” ");
INSERT INTO lwo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yaa Judea yihr gen na naa dhe yoohn luog cing kedea roohd cam ne wuor Juog. Ke nying gihn nu, e daahy abiihjbeciel giih luog rog ge anudo kaano. ");
INSERT INTO lwo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Maa arob Jeacuue ngo yihr yaa tiihj giih ni kea, “Paahngu yihdh daahy ke piih.” Maa apaahng gene daahy cang ne leb leb. ");
INSERT INTO lwo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Batiene e Jeacuu acahg rob yihr gen kea, “Tuomu piih yi dag, ucubu gen yihr ukiihy duohng.” Maa akaab gene piih ukahl gene gen yihr ukiihj. ");
INSERT INTO lwo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Piih giih alog Jeacuue ne koongo amaadhe. Abea kaa abeehn koohng nu kii ngo, ngo akwihye. (Anahg yaa atuom piih, ge ne ngahy dhe yoohn kaa abeehn koonge kii ngo.) Noono ubeehn ukiihje ucuohne ngad paajo urube yihr ngo kea, ");
INSERT INTO lwo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Yihdh kahnye giih yug cang, wong koongo e ne kuong ke cubo yihr weehle umodho, batiene e koongo maa acoom ke cubo yihr gen. Abea mari wong koongo apoohd e kani kano uwahdh pinye wa gihn?” ");
INSERT INTO lwo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Gihn ni e naa gihn me teeg mar umodho me gaahy nyoge maa ayug Jeacuue. Ngo ayuge Kana ge nii Gaalili. E naa kaa anyoadh Jeacuue kaa amoar Juoge wiihe ne ngaa me duohng. Gihn nu e jo waahdhe ngo ayiih gene ne ngaa me dhiil gene kaa gaahno. ");
INSERT INTO lwo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Batien gihn nu, e Jeacuu ke men maa wuud wahn kedea jo waahdhe ge a'aay ne ci geen Kaparnaam ne nahg nihn me noog yea. ");
INSERT INTO lwo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Naa adoohng kar Yaan Amono cahng e Jeacuu abeehn ne aay ucidhe Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yi laaro gihr wod Juog e yuud nyoge ge ngeew dhahg kedea roohme maa jien oogo kedea yaa waar ngiihny ge apiih buud tharbeaje giih gen, ne waar ngiihny. ");
INSERT INTO lwo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Noono ucwaahye thool ne keedo kedea uthube ke kool dhahg maa roohme oogo yi laaro maa ayoade tharbeaje giih yaa waar ngiihny ujwange gen piny kedea uyiere ngiihny ke bang piny. ");
INSERT INTO lwo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Maa aciere ngo yihr yaa ngeew jien oogo kea, “Kaabu giih ni ukedhu gen oogo! Laaro gihr Wod Wura e ne logu ne kar cuug.” ");
INSERT INTO lwo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Gihn ni abeehn jo waahdhe ne paro wa kaa anaa agweede yi kitaab Juog naa, “Gihn adeehja gihn me beer ke nying laaro gihr wod Juog yi cwihnya, umeehg nyoge nahg an.” ");
INSERT INTO lwo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Noono ubeehn yaa Judea, ge apahn Jeruucalem, upeehny gene Jeacuu kob gene, “Gihn noono romi ke yugo ne nyoadh ngo kejea yihri nud teeo me romi yug gihn atiihyi awaahn kan?” ");
INSERT INTO lwo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Maa abeehr Jeacuue ngo yihr gen kea, “Nea Wod Juog gihn toaru ke piny, e ngo doga kaa geero ucuunge batien nihn adahg.” ");
INSERT INTO lwo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Maa acahg yaa Judea ngo ke beehro yihre kob gene, “Wod Juog gihn ageer yi run jiehariow wonge abiihjbeciel kare tooro ugeeri ngo yi nihn adahg!” ");
INSERT INTO lwo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Abea Jeacuu ge arube, kuu anahg Wod Juog e naa arube ke nyinge, beehda kuohme e naa arobe. ");
INSERT INTO lwo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Batiene kaa acahr Jeacuue e ngo abeehn jo waahdhe ne paro kejea ne nahg gihn me na robe robo. Kaano e gihn agweed yi kitaab Juog kedea giih na robe ge abeehn gene ne yiiho. ");
INSERT INTO lwo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ge anahg Jeacuue geen Jeruucalem, yi nihn Yaan Amono, e giih me teeg me thoohdh me gaahy nyoge ge ayuge kedea ubeehn nyoge me thoohdhe uyiih gene ngo, ne ngaa me gaahn gene ke nying giih nu. ");
INSERT INTO lwo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Abea Jeacuu ke kur mare nyoge keá gaahno. Ge keá gaahno bang gihn par dhaano utaahngo ngo ngahye. ");
INSERT INTO lwo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Noono e kuu adaahd dhaano me rubo yihre ke nying nyoge mooge. Jeacuu ke ngude gihn nii cwihny dhaano ngo beehde ngahye. ");
INSERT INTO lwo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Anaa anudo ke Ujudea me duohng me nyinge Nikoadiihmuj. Ngo anahg ngad akuud yaa lum Juog me cuohn ne Paarijea. ");
INSERT INTO lwo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cahng man, e abeehn ka beed Jeacuue yi diehr waahr maa arube yihr Jeacuu, “Ngad puohny, ngo ngahy wane kejea Juog e naa aoohr yihn. Bang gihn giih tiihyi ge gaahy nyoge, ge be ne romi ke tiihyo nea be ne nahg Juog e naa aoohr yihn.” ");
INSERT INTO lwo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Maa abeehr Jeacuue ngo yihre kea, “Athiir gihn daahda ke robo yihri e gen. Nea padh ngaa me cahg ke nyuolo keehdo e dhe yooh tooro yihre me yiih Juoge ngo ne ngade.” ");
INSERT INTO lwo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Maa apeehy Nikoadiihmuje kea, “Dhaano ucahg ke nyuolo ke ne diih? Kare tooro me cahge ke duog yea men beere dog kaa nyuolo!” ");
INSERT INTO lwo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Maa abeehr Jeacuue ngo kobe, “Athiir gihn roba yihri beehda: ngaa me kuong Juoge ke maa ne ngade tooro nea ngaan ngo kuu acahg kaa nyuolo ke dhe yoohn luogwahy ke piih kedea Wahy Juog. ");
INSERT INTO lwo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jo anyuol won ge naa acub wahy yihro. Abea Wahy Juog e naa acub kuowo yihr wahyo. ");
INSERT INTO lwo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Yih keá gaahy yi gihn roba kejea wu cang, wu cahg kaa anyuolo keehdo. ");
INSERT INTO lwo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ka caahdh yame kii ngo ngahda ngo uneehno yihri. Awaahn ni e wiihe log ke kun, batiene e wiihe doge kaa log kun moogo. Abea yih ke ngudi kun beehne kii ngo kwihyi kedea kun cea yea ngo kwihyi. Ngo wa gihn thiow yihr ngaan acub Wahy Juoge kuow wahy yihre.” ");
INSERT INTO lwo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Maa apeehy Nikoadiihmuje kea, “Gihn nu ree yuge ke ne diih?” ");
INSERT INTO lwo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Maa abeehr Jeacuue ngo kea, “Yih beehda ngad puohny yaa Yijarael me duohng, yihdh giih ni ge be romi ke ngeyo ke ne diih? ");
INSERT INTO lwo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Gihn daahda ke robo yihri ngo beehda athiir. Wa rubo kaa nying gihn me ngahj maa aniid wane ke nying wan. Abea kihd dhaano acielo keewu maa ayiih lum arob wane tooro. ");
INSERT INTO lwo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nea giih roba yihru ke nying giih tiihy rog gen wiih piny ge be yiihu, unahg giih roba ke nying giih tiihy rog gen paar Maalo ge nu uyiihu ne? ");
INSERT INTO lwo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Bekihd ngaa maa akuong ci Maalo Paar Juog nea padh an, ge Juog naa adoohng ne dhaano utaahngo, e naa ngaa abeehno ke yoohn Paar Maalo. ");
INSERT INTO lwo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moaje ge anaa yi ukang, demaro maa athaahdh wa thuohl ngo anaa atuohye dhe tala utihnge ngo maalo ne thiehdh nyoge. Ke dhe yoohn nu thiow, a ge adoohng ne dhaano utaahngo a udhiil ke tihng maalo wiih yaadh maa ariihw ne boadh nyoge. ");
INSERT INTO lwo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","A utihng maalo beere kwaad ngaa yiih luma, dhe yoohn boadh wahy me guge tooro yoade yoado. ");
INSERT INTO lwo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Juog yaa wiih piny ge anhyaare wa ka nhyaar wuro nyethene. E naa gihn abeehn Juoge uoohre waahde wiih piny, beere kwaad ngaa yiih lum waahde ngo be dog thoo bang gihn boadh wahy me guge tooro ngo yoade yoado. ");
INSERT INTO lwo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Juog waahde keá oohr wiih piny ne kihm nyoge ke gihn me raaj, abea ngo aoohre beere nyoge boadhe boadho. ");
INSERT INTO lwo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ngaa ayiih lum Waahd, e ngaan nu be kihm. Abea ngaa akweer ke yiih lum Waahd, e ngaan nu ke kihmo bang gihn lum Juog keá ayiiho. ");
INSERT INTO lwo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wa kaano e naa ka kihm Juoge nyoge kii ngo, ne ngey yaa rog gen naa awuohj kedea yaa rog gen tooro awuohj. Daahr ge beehda adiehj Juog yoad ke bang Juog kedea ngo abeehn wiih piny. Nyoge adiehj Juog ngo angey gene. Abea keehd maano e ge nhyaar giih anyoohne ukweer gene kaa adiehj beehn ke bang Juog. ");
INSERT INTO lwo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kwaad ngaa koag ke yug giih anyoohne, adiehj rob ke nying Juog be nhyaare kedea adiehj nu be kuonge ke yiiho. Be yiihe bang gihn ngo utudo kejea anyoohne giihe ge beehn adiehj nu ke ne nyoadho yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kwaad ngaa tiihy gihn maa akob Juoge kea ngo gihn maa adiehr, e tiihye beehn Juoge ke ne niido. Beehn Juoge ke ne niido bang gihn, gihn atiihye nyoadh ngo kejea Juog wuore wuoro.” ");
INSERT INTO lwo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Batiene e Jeacuu kedea jo waahdhe ge a'aay ne cidho ke bang piny Judea. Ge abeehdo kun nu ke nihn me nud keree, maano e ge muoj wudh nyoge ke piih luogwahy. ");
INSERT INTO lwo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Joon thiow ngo anaa ne muoj wudh nyoge ke piih ne cub luogwahy. Wudh nyoge amuoje ke ka me cuohn ne Anon ge cahng ke Calim. Ka maa athoohdh piihe yea e naa kaa awaahd nyoge bang Joon beere ge ke muojo ke luogwahy. ");
INSERT INTO lwo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Gihn nu ree ayuge maano e Joon poohd kuu akedh yi thijin.) ");
INSERT INTO lwo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Gihn nu, e jo waahdh Joon mooge ge ake thubo ke peehm ke Ujudea ke nying dhog yiehdh luog rog ne wuor Juog. ");
INSERT INTO lwo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kaano maa abeehn gene bang Joon urub gene e ge anahg tiele kejea, “Ngad puohny! Ngaan anaa bangi loo naam Joohrdoan, ge ne rubi ke nyinge, ngo ayoad wane e ngo muoj wudh nyoge ke piih luogwahy kedea nyoge me thoohdh ge non bange.” ");
INSERT INTO lwo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Maa abeehr Joone ngo yihr gen kea, “Nea padh Juog e naa arob ngo, e kwaad gihn me wa gihn nu be rom dhaano utaahnge ke tiihyo e keede ubeehn nyoge unon gene bange. ");
INSERT INTO lwo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Keehd wun, e gihn na roba ngo ngahyu ge na koohba kaa, ‘A padh Ngad Boadh nyoge. A beehda ngaa maa aoohr Juoge wong maalo nyum Ngad Boadh nyoge.’ ");
INSERT INTO lwo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A neehn gom athiehg. Nyaakon nyuom beehda gihr athiehg. Abea gom athiehg cwihnye umihno kare noono nea yea buud athiehg. E ne neehn mara, cwihnya med keraahyo gihn me kaal wiihe tooro nea Jeacuu nyinge uwiihj. ");
INSERT INTO lwo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cwihnya med keehd me jwag jo waahdhe rog gen udoohng gene thoohdh kedea jo waahdha ge udoohng noog. ");
INSERT INTO lwo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ngaa ne wiih piny kan, rubo kaa nying giih yug rog gen wiih piny. Abea ngaan abeehno ke yoohn Paar Maalo ge duohng ukaale wudh nyoge cang ");
INSERT INTO lwo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ngo rubo kaa nying gihn aniide kedea gihn alihnge. Abea poohd e ngaa maa yiih lume tooro. ");
INSERT INTO lwo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kwaad ngaa yiih lume nyoadh ngo kejea lum Juog ayoade naa adiehr. ");
INSERT INTO lwo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ngaan aoohr Juoge, rob lum arob Juoge yihre bang gihn Wahy Juog acub yihre utoor gihn me daag. ");
INSERT INTO lwo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Juog Wuro, Waahde anhyaare keter kedea uyoade giih nyepinye cang ucube gen yi cinge. ");
INSERT INTO lwo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kwaad ngaa yiih lum Waahd Juog, yihre ne kuowo me be gug. Ngaa kweer ke lum Waahd Juog e cwihny Juog urahnyo ree, yihre utooro kuowo me be gug.” ");
INSERT INTO lwo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Akuud yaa lum Juog me cuohn ne Paarijea ngo alihng gene kejea Jeacuu wiih Joon ayoohme yi woj piih wudh nyoge ne cub luogwahy yihr gen. ");
INSERT INTO lwo_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Na nahg jo waahdh Jeacuu ge na muoj wudh nyoge, abea padh Jeacuu.) ");
INSERT INTO lwo_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ge anaa alihng Jeacuue lum nu e a'aay oogo Judea udoe Gaalili ");
INSERT INTO lwo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","maano e cor yea piny Camaarya. ");
INSERT INTO lwo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yi Camaarya e ngo atoohng geew me nyinge Ciihcar. Geen ngo cahng ke puohdho gihn anaa acub Jeakobe yihr Jocebe waahde. ");
INSERT INTO lwo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yi puohdh nu naa abuulo me maadh me cuohn ne Abuun Jeakob. Jeacuu naa agoohg yi waahdh, e ngo apiih ne yuohmo wiih abuulo maano e cahng nii diehr wihj. ");
INSERT INTO lwo_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kaano e dhaar Camaarya ake beehno ne tuom ke piih. Maa arub Jeacuue yihre kobe, “Muoja ke piih me mahdha.” ");
INSERT INTO lwo_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Jo waahdh Jeacuu ge anaa yi geew ne ngiew ke cam.) ");
INSERT INTO lwo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Maa abeehr dhaar ni ngo yihre kea, “Yih beehda Ujudea kedea a beehda ngad Camaarya, a peehnyi ke piih maadh ke ne diih?” (Bang gihn Camaarya maa Judea giih nyepinye be laahw gene ke rog gen.) ");
INSERT INTO lwo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kob Jeacuue, “Muuny gihn cub Juoge ngo kwihyi kedea ngaan kwahyo yihri ke piih kwihyi. Nea giih nu ge ni ngahyo, e ne nahg yihn e ne kwahy ke piih kedea yih ne muoja ke piih me cub kuowo yihri.” ");
INSERT INTO lwo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kob dhaare, “Ruohdh! Wa gihn me tuomi piih keehde tooro kedea yi abuulo thuudh! Kee noono e nuu uyoadi piih cub kuowo? Anahg Jeakob kuow wan e naa awii abuun ni piny yihr wan. E ke ngude ke nyethene kedea dhahge maa diehge ge na mahdh kii yea. ");
INSERT INTO lwo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ka moogo e apari kejea yih ne duohng rih Jeakob kuow wan ne!” ");
INSERT INTO lwo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Maa abeehr Jeacuue ngo kea, “Kwaad ngaa maadh piih ni, ngo cahg riowe kaa naah keehdo. ");
INSERT INTO lwo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Abea ngaa maadh piih cuba, ngo be cahg riowe ke naah. Piih cuba ge udoohng wa aloohn piih yi kuohme. Aloohlo me muoj ngo ke piih cub kuowo kedea umuoje ngo tiehd keehd dhe yoohn kuowo me guge tooro.” ");
INSERT INTO lwo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kob dhaar ni, “Ruohdh muoj an ke kwaad piihi noono. Muoj an beere a be cahg riowe ke naah kedea ubahnge an be beehn kan ne tuom ke piih keehdo.” ");
INSERT INTO lwo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kob Jeacuue, “Cidhi ne cuohn cuori kedea ubeehnu tiehd keehde.” ");
INSERT INTO lwo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Maa abeehr dhaare ngo kea, “A beehdo e yihra tooro dhecuow.” Kob Jeacuue, “Lumi athiir ge arobi ngo kejea yihri tooro dhecuow. ");
INSERT INTO lwo_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yihri anaa cuow abiihj maa anyuom yihn kedea ngaan beehdi keehde awaahn ni padh cuori maa anyuom yihn. Lubo maa adiehr e naa arobi yihra.” ");
INSERT INTO lwo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Maa aduog dhaare ngo yihre kea, “Angeya arumo kejea yih beehda agamloohngjuog. ");
INSERT INTO lwo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ge kuow wan, wa yaa Camaarya, Juog na wuor gene ke wiih good ca ge neehn ke kan kedea e naa ka poohde e ngo wuor wane wuoro yea, abea wu yaa Judea kobu nahge ke Jeruucalem e ne cidh wane yea ne wuor Juog?” ");
INSERT INTO lwo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kob Jeacuue, “Nyaakaahy! Lihng gihn roba yihri naa athiir. Nud ke cahng muu ubahnge nyoge Juog Wuur buu ucahg gene ke wuoro wiih good gihn robi wale yi Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Wu yaa Camaarya, Juog kwihyu kedea gihn wuor Juog ke nyinge kwihyu. Abea mar wan, wa Judea Juog e ne wuor wane, ke nying gihn nu e naa gihn aay dhe yoohn boadh nyoge ke bang wan. ");
INSERT INTO lwo_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Cahng arob ngo aguo wahnho. Cahng meehg Wahy Juoge nyoge wuor Juog, wa ka nahge Juog Aciehg. Yaa umeehg Wahy Juoge wuor Juog ge naa yaa adaahd Juoge uwuor gene en. ");
INSERT INTO lwo_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Juog e naa ngaa cub kuowo kedea Juog rom nyoge kaa wuoro wa ka nahge Juog Aciehg nea ge amuoj Wahy Juoge ke kuowo me nyaahn me meehge gen wuor Juog.” ");
INSERT INTO lwo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Maa akoohb dhaare kea, “Ngo ngahya kejea Ngad Boadh nyoge ngo ubeehn. Kedea nea ngo abeehno, e giih nyepinye cang ge urobe yihr wan.” ");
INSERT INTO lwo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kob Jeacuue, “Beehda an e naa Ngad Boadh nyoge. A ge rubo ke yihn!” ");
INSERT INTO lwo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nye kaano e naa kaa aduu jo waahdh Jeacuue ke yoohn geew. Naa aniid gene Jeacuu urubo ke dhaago e ge acwaahng. Abea ngaa maa apeehny dhaar ni tooro kiin gen kejea, “Yih daahd gihn bang Jeacuu?” Thiow ngaa maa apeehny Jeacuu tooro kea, “Yih rob gihn ke dhaar ni?” ");
INSERT INTO lwo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kaano e dhaar nu dag piih gihre awiie ke wiih abuulo udoe geew maa arube yihr nyoge kea, ");
INSERT INTO lwo_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Beehnu ne niid ngaa arob giih reje naa atiihya oogo cang. Ka moogo e ngo unahg Ngad Boadh nyoge.” ");
INSERT INTO lwo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Maa a'aay nyoge ne ci ne maany Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Abea maano e jo waahdh Jeacuu ge nii ne lug ngo kejea cahme kob gene, “Cedhree! Ngad Puohny tum gihn me thiin ke camo.” ");
INSERT INTO lwo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Maa abeehre ngo yihr gen kobe, “A acahmo, abea gihn acama ngo kwihyu.” ");
INSERT INTO lwo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kaano e jo waahdhe ge athubo ke rob ke kiin gen kob gene, “Ka moogo e ngaa maa akahl cam yihre nud!” ");
INSERT INTO lwo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kob Jeacuue yihr gen kea, “Cam mara beehda tiihy gihr ngaa aoohr an uwahdhe ka ukeehla tiihy ngo guge. ");
INSERT INTO lwo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ngahda na ke teedo naa, ‘Adoohng dwahde abiihj ukaj uleela?’ Abea beeh teeda ngo yihru kejea yaa ayiih luma ge ne room ke beel me kaj. Maanyu kaa adoohng uleele kii ngo yi puohdho. Uleela wiihe adoohng kwaar ngo daahd ukaye. ");
INSERT INTO lwo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ngaan kay ngo ke koogo. Kaano e ngaa apuro kedea ngaa akahyo cwihny gen umihno cang. ");
INSERT INTO lwo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","E naa kaa abeehn gihn ne caal naa, ‘Ngaa moogo ngo ngad puur abea ngaa moogo e naa ngad kaj.’ ");
INSERT INTO lwo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wu aoohra ne kaj yi puohdho me padh wun naa apuur ngo. Nyoge mooge ge naa apuro kedea ubeehnu ne yoad gihn me beer yi tiihy gen.” ");
INSERT INTO lwo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Abea kiin yaa Camaarya nyoge me thoohdh lum Jeacuu ayiih gene bang gihn akob dhaage kea, “Kwaad giih atiihya cang ge arobe yihra.” ");
INSERT INTO lwo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Gihn nu e yaa Camaarya ge abeehn bang Jeacuu maa arob gene ngo yihre kejea beehde keehd gen. Maa abeehd Jeacuue keehd gen ke kar nihn ariow. ");
INSERT INTO lwo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Naa alihng gene giih arob Jeacuue e nyoge mooge thiow me thoohdh lum ngo ayiih gene. ");
INSERT INTO lwo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Noono maa akoohb gene yihr dhaar ni kejea, “Awaahn ni lume ayiih wane, padh ke nying gihn arobi yihr wan, abea bang gihn wa keed wan lume alihng wane. Ngo angey wane ne cohg kejea e naa Ngad Boadh yaa wiih piny.” ");
INSERT INTO lwo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Naa anahg Jeacuue nihn ariow e adoog kuu utiene ne ci Gaalili. ");
INSERT INTO lwo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Beehde e gihn maa anaa arob Jeacuue kea, “Ngad agamloohngjuog be kuong yaa paar gene ke yiiho kejea ngo agamloohngjuog.” ");
INSERT INTO lwo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Naa awahnhe Gaalili e ngo alor beer mee. Yaa alor ngo beehd yaa aduuo ke yoohn Jeruucalem kaa aniid gene giih anaa atiihy Jeacuue yihdh nihn Yaan Amono. ");
INSERT INTO lwo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kaano e Jeacuu abeehn ne ci Kana, yi Gaalili, geen anaa aloge piih ne koongo yea. Apahno gihr akuumo, me waahde tuu yi geen Kaparnaam, anaa anudo. ");
INSERT INTO lwo_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Naa alihnge bang Jeacuu kejea ngo abeehno ke yoohn Judea e ngo acidh bang Jeacuu. Acidho ne kway wong ngo beere caa Kaparnaam ne thiehdh waahde ge cahng ke thoo. ");
INSERT INTO lwo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Maa arub Jeacuue yihr gen kea, “Nea padh gihn me gaahy nyoge me teeg e ne niidu ke nyingu, e wu be kuong yiiho.” ");
INSERT INTO lwo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kob apahne, “Ruohdh! Beeh cidho ke yihn piow piow e waahda wonge poohd nud.” ");
INSERT INTO lwo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Maa arob Jeacuue ngo yihre kea, “Cidhi. Waahdi ubodh.” Nyin lum Jeacuu ayiihe kedea uthube ke dog paare. ");
INSERT INTO lwo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yi yooh e ake roohmo keehd yaa tiihj giihe maa ateed gene ngo yihre kob gene, “Waahdi ngo adoohng ne ngaa maa abodh.” ");
INSERT INTO lwo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Maa apeehnye gen kejea weehne e naa angweehn atwaany waahde. Kob gene, “Atwaany abeehn ne ngweehno yi laahng cahng.” ");
INSERT INTO lwo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Maa abeehn apahne ne ngey ngo kejea beehda nye kaa anaa arub Jeacuue yihre kea, “Waahdi ubodh.” Noono e en maa jo paare ge adoohng ne nyoge maa ayiiho. ");
INSERT INTO lwo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Gihn nu e naa riown giih gaahy nyoge naa atiihy Jeacuue yi piny Gaalili naa aduue ke yoohn Judea. ");
INSERT INTO lwo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ke batien gihn nu, e Jeacuu abeehn ne ci Jeruucalem bang gihn yaa Judea yihr gen anaa yaay me ge dhiil ci Jeruucalem ke nyinge. ");
INSERT INTO lwo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Abea buud ka cuohn ne Ciihb Gead nud ke paahl. Buud paahl atieg piny ke pehme abiihj kedea uyoad kaano ucuohne ne Paahl gihr Bedhjadha ke dhog Judea. ");
INSERT INTO lwo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Amahr nyoge maa atwaany ge abudo ke bang thaahdh pehme. Nyoge maa acoor kedea ngoohde kedea nyoge maa abaahl. Ge akoar piih paahl utihng gene rog gen.  ");
INSERT INTO lwo_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bang gihn wuohnjuog na kwaay cidho yi paahl ne ciehr yihdh piih. Nea ge acier, e ngad atwaany ge kuong mono yihdh piih umodho e kwaad atwaany anaa ree ngo uaay. ");
INSERT INTO lwo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Dhaano maa abeehd e atwaany ke kar run dhaano aduuno wonge apaar wonge abiihjbedahg anaa anudo buud paahl. ");
INSERT INTO lwo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jeacuu naa aniide nyin kedea naa angeye ngo kejea abeehdo piny ke twaany ke run me thoohdh, e ngo acidho bang ngo. Noono maa apeehnye ngo kea, “Cwihnyi ne bange uthiehdh yihn ne?” ");
INSERT INTO lwo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Maa abeehr nyine ngo kobe, “Ruohdh, yihra tooro dhaano me tihng an ne kedh yihdh piih kaano tihng piihe rog gen. Noono e thuba kaa a tum cidho yihdh piih, e a guo ngaa mooge kaa yoohmo unahge e ne kuong cidho yihdh piih.” ");
INSERT INTO lwo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kob Jeacuue yihre, “Yedh maalo ukaabi belo gihri ucaahdhi.” ");
INSERT INTO lwo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wong kaano e nyin ree ayoade e athiehdh. Noono ukaabe belo gihre uthube thubo ke waahdh. Gihn ni ree ayuge ke cahng Cabadh ge beehda cahng yuohmo gihr Judea ");
INSERT INTO lwo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","maa abeehn ruohdh Judea giih Jeruucalem urub gene yihr ngaan athiehdh kob gene, “Loohnge mooge ge beehde e yihdh ge adhahli bang gihn belo gihri kaahni kaahno cahng yuohmo.” ");
INSERT INTO lwo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Maa abeehre ngo yihr gen kea, “Ngaa athiehdh an, e naa arob ngo yihra kejea kaaba belo gihra.” ");
INSERT INTO lwo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Maa adog gene piehj, “Beehda ngaa e naa arob ngo yihri kejea kaabi belo gihri uci paajo?” ");
INSERT INTO lwo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Abea ngaan athiehdh en akwihye, bang gihn nyoge ge athoohdho ke raahyo noono e Jeacuu arwaahnyo yihre kiin nyoge. ");
INSERT INTO lwo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Cahng nu e ngaan athiehdh ayoad Jeacuue yi Laaro gihr Wod Juog maa arube yihr ngo kea, “Awaahn ni, yih adoohng ne ngaa maa athiehdh. Wii yug giih adhemuohm beere gihn me raaj me kaal wiih man be pahdh wiihi.” ");
INSERT INTO lwo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kaano e ngo ake aay maa acea ne teed ngo yihr ruohdh yaa Judea kejea beehda Jeacuu e naa athiehdh en. ");
INSERT INTO lwo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Noono arumo, uthub ruohdh yaa Judea ke tiehng ngo ater ke nying gihn athiehdhe dhaano cahng Cabadh. ");
INSERT INTO lwo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Maa abeehr Jeacuue ngo yihr ruohdh Judea ne jaahy gihn arob gene kea, “Juog Wura, uwahdhe yi caang rubo awaahn ni, ngo beehde e utiihyo e naa gihn tiihya thiow.” ");
INSERT INTO lwo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ke nying lum nu, e yaa Judea ge athubo ke daahd dhe yooh me nahg gene Jeacuu. Ge daahd unahg gene ngo, padh ke nying gihn atiihye cahng Cabadh, abea ke nying gihn arome wiihe ke Juog naa acuohne ngo ne wahn. ");
INSERT INTO lwo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Maa abeehr Jeacuue ngo yihr gen kobe, “A rob athiir yihru. A ge adoohng ne dhaano utaahngo ni, gihn me roma tiihyo a keeda tooro. A yug kwaad gihn niida ge tiihy Wura bang gihn kwaad gihn tiihy Wuro e naa gihn tiihy Waahde thiow. ");
INSERT INTO lwo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bang gihn Wuro Waahde anhyaare kedea unyoadhe kwaad giih tiihye yihr Waahde. Adiehr kedea wu ugaahy bang gihn giih me teeg me yoohm muu ni ge unyoadhe yihr Waahde. ");
INSERT INTO lwo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wa kwaad ka beehn Wure utahnge yaa athow kedea ucube kuowo me ne cohg yihr gen, ke dhe yoohn nu thiow e Waahd, kuowo me ne cohg ucube yihr ngaa me daahde. ");
INSERT INTO lwo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Thiow Wura ngaa me cahge ke kihme tooro, bang gihn kihm nyoge awiie yi cing Waahde, ");
INSERT INTO lwo_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","beere nyoge cang Waahd dhiil gene kaa wuoro wa kwaad ka wuor gene Wuro. Nea ngaa be wuor Waahd e Juog Wuur ge aoohr Waahde ni, ngo be wuore thiow. ");
INSERT INTO lwo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Adiehr e ne roba yihru, ngaa lihng luma kedea uyiihe lum Juog ngaa aoohr an, e ngaan nu yihre ne kuowo me ne cohg kedea buu ukihm cahng lug. Buu ukihm cahng lug bang gihn thoo aloge ngahye udoohnge yi yoohn kuowo me ne cohg. ");
INSERT INTO lwo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Athiir e ne roba yihru, cahng arob ge ulihng duona ngo abeehno awaahn ni. Yaa ulihng duona utiihy gene gihn ateeda yihr gen, ge nuu uyoad kuowo me ne cohg. ");
INSERT INTO lwo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Me neehn ka nahge Juog e ne cub kuowo me ne cohg yihr nyoge, ke dhe yoohn nu thiow e Juog Waahde ameehge cub kuowo me ne cohg yihr nyoge, ");
INSERT INTO lwo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","kedea tee ne kihm nyoge acube yihra a ge adoohng ne dhaano utaahngo ne boadh nyoge ke nying gihn nahga Waahd Juog. ");
INSERT INTO lwo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Wu keá gaahy yi gihn daahda ke teedo yihru awaahn ni, bang gihn nud ke cahng muu ubeehn yaa athow ge beed yihdh leehde giih gen ulihng gene duona ke kar gen cang, ");
INSERT INTO lwo_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kedea upahr gene oogo yihdh leehde. Jo ayug giih me beeye ge ucahr kedea uyoad gene kuowo me ne cohg. Abea jo ayug giih me reje ge ucahr kedea ge ukihm. ");
INSERT INTO lwo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“A be rom yug nyepinye ke teeg mara a keeda kedea nyoge ge kihma kaa dhe yoohn arob Juoge yihra. E naa gihn ngahya lug noono bang gihn a be tiihy gihn daahd aduuna abea a tiihy gihn daahd ngaa aoohr an. ");
INSERT INTO lwo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nea a rubo yihru kaa nying mar nguda keede, e gihn roba ngo be kuong ke yiiho wa gihn maa athiir. ");
INSERT INTO lwo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","“Abea Juog Wura e naa arob gihn ngahya ke nyinge kedea ngahya kejea gihn teeda ke nyinge ngo beehda athiir. ");
INSERT INTO lwo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Joon e naa ngaa anaa aoohr dhog yihre kedea maa abeehn Joone urobe gihn maa athiir ke nyinga yihru. ");
INSERT INTO lwo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Gihn rob dhaan utaahnge ke nyinga padh en ne daahd ne nyoadh ngo kejea a beehda ngaa. A rubo kaa nying gihn arob Joone ke nyinga beere Juog wu boadhe boadho. ");
INSERT INTO lwo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Giih atiihy Joone ne kedh nyoge bang Juog ge anaa ake liel wa gihr lamba maa a'ahb kedea ubeehdu ke nye nihn me noog e cwihnyu med ke nying tiihye e liel wa maay lamba ge anaa anhyaaru. ");
INSERT INTO lwo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Abea gihn tiihya nyoadh adiehr me ne cohg ke nyinga, ke dhe yooh me yoohm dhe yoohn mar Joon naa arobe ke nyinga. Giih tiihya beehda Wura e naa acub gen yihra ne tiihyo kedea ge ne rubo ke nyinga maa ge ne nyoadh ngo kejea beehda Wura e naa aoohr an. ");
INSERT INTO lwo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Thiow Wura ke ngude ge aoohr an ngo urubo ke loohnge me nyoadh athiir ke nyinga. Keehd me bahnge duone kuu alihngu kedea kuohme kuu aniidu e gihn maa anyoadhe nud ke nyinga. ");
INSERT INTO lwo_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kedea wu akweer ke meehg luub Wura beehdo yi cwihnyu bang gihn luma a ngaa aoohre ngo be yiihu. ");
INSERT INTO lwo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Wu abuohj ke cej yihdh giih anaa agweed cuohnu kuu e nuu uyoadu dhe yoohn kuowo me ne cohg. Abea ukwihyu ngo kejea giih agweed ge rubo kaa nyinga. ");
INSERT INTO lwo_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kedea wu poohd ukweer ke beehn banga beere wu ukwahnyo ke luube noono e kuowo me ne cohg yoadu yoado. ");
INSERT INTO lwo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Padh leej gihr nyoge e ne daahda bang uleej gene an. ");
INSERT INTO lwo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Wu beehda kwaad nyoge me ngahya ne cohg: Wu nyoge me be nhyaar Juog. ");
INSERT INTO lwo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","A abeehno, bang gihn Juog e naa aoohr an ne rob ke nyinge maa akweeru bang gihn aparu kejea padh e naa aoohr an. Abea nea dhaano beehn bangu ke kar wiihe e kuu aoohr Juoge e lume yiihu yiiho. ");
INSERT INTO lwo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Cwihnyu umihno nea wu piih ne leej rogu. Abea wu be daahd utiihyu ke dhe yooh me mihn cwihny Juoge rogu uleeye wun. Angahya ne cohg kejea wu akweer ke yiih luma. ");
INSERT INTO lwo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Wudhu keá paru kejea a ucidh ne luom wun yihr Wura. Padh an e nuu uluohmo, abea ngaa uluom wun beehda Moaje ge gaahnu, e nuu uluom wun. ");
INSERT INTO lwo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nea giih agweed Moaje ge nuu yiiho, e luma nuu yiihu bang gihn giih agweed Moaje ge agweed kaa nyinga. ");
INSERT INTO lwo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Abea ge bahnge giih agweede kuu ayiihu, e gihn teeda uyiihu kaa naa diih?” ");
INSERT INTO lwo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Cahng man ke batien giih nu e Jeacuu abeehn ne ci loo naam duohng gihr Gaalili. ");
INSERT INTO lwo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Akuud nyoge me thoohdh ge beehdo e ge na buodh batiene bang gihn giih me gaahy nyoge me thoohdh naa athiehdhe nyoge maa ayuge ke tee Juog ge aniid gene. ");
INSERT INTO lwo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Noono e Jeacuu maa jo waahdhe ge ayedh wiih good upiih gene ne puohny nyoge. ");
INSERT INTO lwo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yaan Amono gihr yaa Judea ngo anaa adoohng cahng. ");
INSERT INTO lwo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Naa amaahny Jeacuue, e niid amahr nyoge me beehn ka nea yea. Maa arube yihr Pihlihb kobe, “Kee e nuu ungeewo amune yea yihr yaa ni?” ");
INSERT INTO lwo_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pihlihb apeehnye wa gihn nu bang gihn adaahd utume ngo. Gihre naa adaahde ke tiihyo ngo abeehde e ngo ngahye. ");
INSERT INTO lwo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Maa abeehr Pihlihbe ngo yihre kobe, “Beere e dhaano acielo uyihdo ke nye goan amono e ngo daahd kar ngiihny tiihj cahng acielo me cub yihr nyoge jiehabiihje ariow ge ne rom ngeew amune.” ");
INSERT INTO lwo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ngad oohr acielo me nyinge Andrya ge umiih Cimoane Piihter ni, ayedh maalo urube yihr Jeacuu kea, ");
INSERT INTO lwo_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nyedhoohg nud kan me yihre naa amune abiihj kedea rej ariow cog. Abea rog gen upaahng gene ke ne diih yihr yaa ni thoohdh?” ");
INSERT INTO lwo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Maa arub Jeacuue kea, “Robu ngo yihr yaa nu upiih gene piny cang.” (Anahg ka me yea ne lum). Noono upiih nyoge cang. Cuow anudo ge anahg kar alihbe abiihj. ");
INSERT INTO lwo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Maa akaab Jeacuue amune, umuohye koohr Juog kedea ucube gen ne paahngo yihr nyoge. Thiow rej ge akaabe umuohye koohr Juog ucube gen ne paahngo yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Naa athum nyoge ke cam cang, e Jeacuu arubo yihr jo waahdhe kea, “Congu goan amune giih adoohng cang utoor mooge me doohng piny ne rahnyo.” ");
INSERT INTO lwo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Noono ucong gene goan amune giih adoohng kedea upaahng gene diide apaar wonge ariow. ");
INSERT INTO lwo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Naa aniid nyoge gihn me gaahy nyoge naa atiihye, e ge athubo ke rob kob gene, “Adiehr ngaan beehda Ngad Boadh nyoge naa akob Moaje kejea ngo ubeehn wiih piny.” ");
INSERT INTO lwo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Batien kaa amodh Jeacuue ngo kejea yaa ni ge daahd uroony gene ngo ne ruohdh wa ka daahd gene, e ree aloaye oogo ucea wiih good. ");
INSERT INTO lwo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ke wong thiehno, e jo waahdhe ge aci wiih naam duohng ");
INSERT INTO lwo_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","kedea upaahr gene yi baabuur ne dog naam duohng ke ngolo beere ge caa Kaparnaam. Jeacuu anaa atooro bang gen keehd maa ayuudh pinye. ");
INSERT INTO lwo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yi yuudh piny e deeh yamo me teeg ree anaa atihnge kaa athewo yi naam duohng. ");
INSERT INTO lwo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ge anaa akiiw gene baabuur ke kar meale adahg wale angween, e Jeacuu ree angule ke buud baabuur gihn nahg gene yea, uniid gene ngo e ucaahdho ke wudh piih utud gene. ");
INSERT INTO lwo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Abea Jeacuu akoohbo yihr gen kea, “Beehda an! Wu keá tud.” ");
INSERT INTO lwo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Noono e cwihny gen anaa bange ubeehn Jeacuue bang gen yi baabuur. Kedea kaano piow piow e baabuur aguo wahnh dhe waadh kaa anaa adaahd gene ke cwihny gen. ");
INSERT INTO lwo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ge anaa ayaahng Jeacuue nyoge aliihbe abiihj, e ge anaa aniid yaahy acielo cog kaano acahm gene yea kedea ngo angahy gene kejea Jeacuu kuu anaa a'aay keehd jo waahdhe. ");
INSERT INTO lwo_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ruuwow e baabuure mooge ge anudo kaa anaa amuohj Jeacuue koohr Juog ge ayaahnge nyoge kaa amune. Ge anaa abeehno kaa yoohn Tiberya. ");
INSERT INTO lwo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Naa angey nyoge ngo kejea Jeacuu kedea jo waahdhe ge tooro kaa anahg gene yea, e ge ayedh yihdh baabuure giih ci Kaparnaam ne daahd Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Naa ayoad nyoge Jeacuu loo naam duohng kaa abeehn gene yea, e ge apeehyo kob gene, “Ngad puohny! Yih awahnh kan ke ne diih?” ");
INSERT INTO lwo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Maa abeehr Jeacuue ngo kea, “A rob athiir yihru: A be daahdu kaa nying giih me gaahy nyoge naa atiihya ge niidu ke nyingu ni ne nyoadh ngo kejea a beehda Ngad Boadh nyoge, abea ke nying amono naa acamu kedea uyahngu. ");
INSERT INTO lwo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Wu keá tiihyo cog ke nyinga abea tiihyu keraahyo ne yiih luma ge cub kuowo me ne cohg yihru. E naa cam gihn ucuba yihru, a ge adoohng ne dhaano utaahngo, bang gihn Juog Wuur e naa akoohbo kejea tiihya beer.” ");
INSERT INTO lwo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Maa arub gene yihr ngo kob gene, “Gihn e nuu urom wane ke tiihyo nea wa daahd uyug wane gihn daahd Juoge?” ");
INSERT INTO lwo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Maa abeehr Jeacuue ngo yihr gen, “Gihn daahd Juoge utiihyu ngo beehda uyiihu luma a ge aoohr Juoge.” ");
INSERT INTO lwo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Batiene e ge arubo yihr ngo kob gene, “Kea noono tiihy gihn me gaahy nyoge uniid wane ngo beere lumi yiih wane yiiho. ");
INSERT INTO lwo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ge kuow wan naa acoon ge anaa amuoj Moaje ke cam me cuohn ne maana yi ukang wa kaa anaa agweede yi kitaab, ‘Cam acube yihr gen ke yoohn Paar Maalo.’ ” ");
INSERT INTO lwo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kob Jeacuue yihr gen kea, “Arob adiehr yihru. Cam gihn acub Moaje yihru padh cam me Moaje e naa acub ngo, abeehno kaa yoohn Paar Maalo. Wura e naa ngaa cub cam me ne cohg yihru ke yoohn Paar Maalo. ");
INSERT INTO lwo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","A ge abeehno ke yoohn Paar Maalo kedea a ge cub kuowo me ne cohg yihr nyoge wiih piny kan ni, a naa amono gihn acub Juoge.” ");
INSERT INTO lwo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Maa apeehy gene, “Ruohdh! Kwaay amono gihn nu kaa cubo yihr wan ke cahng cahngo.” ");
INSERT INTO lwo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Maa akob Jeacuue ngo yihr gen kea, “A naa cam ge cub kuowo me ne cohg yihr nyoge ni. Ngaa beehn banga kedea uyiihe luma e ngo be kuong kahje ke naah kedea be nahg riowe thiow. ");
INSERT INTO lwo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Abea a rob athiir yihru kejea keehd maa aniidu an, e luma poohd be yiihu. ");
INSERT INTO lwo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kwaad ngaa acub Wura yihra ngo beehn banga udoohnge ne ngad batiena. Kedea ngaa adoohng ne ngad batiena ngo be kuonga ke riem oogo batiena. ");
INSERT INTO lwo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bang gihn a abeehn wiih piny kan ne yug gihn daahd Juoge ngaa aoohr an, abea a kuu abeehn ne yug mara me daahda. ");
INSERT INTO lwo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","E naa gihn daahd ngaa aoohr an kejea yaa acube yihra ge keá meehga aay oogo batiena kedea meehga gen cahro cahng lug uyoad gene kuow me guge tooro. ");
INSERT INTO lwo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Gihn daahd Wura beehda ubeehn kwaad dhaano ungahye ngo kejea a beehda Waahd Juog kedea uyiihe luma. Kaano arumo e kuowo me ne cohg ke cubo yihre kedea meehga ngo cahro yi gug nihn.” ");
INSERT INTO lwo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yaa Judea ge athubo ke ngoan ke piny ke nying gihn arob Jeacuue kea, “A naa amono gihn abeehno ke yoohn Maalo.” ");
INSERT INTO lwo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Maa akoohb gene, “Ngahda nyin beehda Jeacuu ge waahd Jocebe ni? Wahn kedea men wa ge ngahyo. Ngo rom rob ke naa diih kea e beehn kaa yoohn Maalo Paar Juog?” ");
INSERT INTO lwo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Maa abeehr Jeacuue ngo yihr gen kea, “Cuungu! Wu keá ngoan ke kiin nu. ");
INSERT INTO lwo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ngaa me beehn banga tooro nea padh Wura ge aoohr an ni, e naa akahl ngo banga kedea ngo umeehga cahro cahng gug piny. ");
INSERT INTO lwo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Agweed yihdh kitaabe giih agamloohngjuog naa, ‘Beehda Juog e ne puohny kwaad dhaano utaahngo kedea kwaad ngaa lihngo kedea ukwaye Juog e ngaan nu beehn banga.’ ");
INSERT INTO lwo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Bekihd dhaano maa aniid Juog Wuur nea padh ngaa abeehno ke bang Juog. Beehda a cog, e naa aniid Juog. ");
INSERT INTO lwo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Beehda gihn maa athiir e ne roba yihru, kwaad ngaa ayiih luma yihre ne kuowo me ne cohg. ");
INSERT INTO lwo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","A naa amono gihr kuowo me ne cohg. ");
INSERT INTO lwo_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ge kuowu amono cuohn naa maana anaa acam gene yi ukang kedea uthow gene. ");
INSERT INTO lwo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Abea amono gihn ruba ke nyinge ni, e naa amono gihn abeehn ke yoohn Paar Maalo kedea e naa kwaad amono me nea acam dhaane, e yihre naa kuowo me ne cohg me ngo be thow. ");
INSERT INTO lwo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","A ke nguda a naa amono gihn abeehno ke yoohn Paar Maalo ge cub kuowo me ne cohg! Ngaa cam amono gihn nu e ubeehdo e be thow. Amono gihn ucuba beehda kuohma e ne cuba beere kuowo me ne cohg nud yihr nyoge wiih piny.” ");
INSERT INTO lwo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Noono e yaa Judea cwihny gen arahnyo ke nying gihn arob Jeacuue uthub gene ke peehm ke kiin gen kob gene, “Ngaan kuohme ucube ne camo yihro ke ne diih?” ");
INSERT INTO lwo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kob Jeacuue yihr gen, “A rob athiir yihru: nea padh kuohma a ge adoohng ne dhaano utaahngo e ne camu kedea umaadhu rema, e kuowo me ne cohg tooro yihru. ");
INSERT INTO lwo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ngaa cam kuohma kedea umaadhe rema e ne yihre ne kuowo me ne cohg kedea ngo umeehga cahro cahng gug piny. ");
INSERT INTO lwo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ke nying gihn nu, kuohma e naa cam me ne cohg kedea rema e naa gihn me maadh me ne cohg. ");
INSERT INTO lwo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kwaad ngaa cam kuohma kedea umaadhe rema, e ngaan nu a anweehd keehde. ");
INSERT INTO lwo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Juog ge cub kuowo yihr nyoge ni, e naa aoohr an kedea e naa acub kuowo yihra. Ke dhe yoohn nu acielo nu nea ngaa cam kuohma e kuowo me ne cohg cuba cubo yihre. ");
INSERT INTO lwo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Gihn ni e naa amono gihn abeehno ke yoohn Paar Maalo. Ngo be room kaa amono gihn acam ge kuowu kedea uthow gene keehd maa acam gene ngo. Abea kwaad ngaa abeehdo e cam amono gihn cuba, yihre unaa kuowo me be gug.” ");
INSERT INTO lwo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Giih ni ge arob Jeacuue e upuohnyo yi wod amaad yi paan cuohn ne Kaparnaam. ");
INSERT INTO lwo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yaa buodh batien Jeacuu me thoohdh gihn ni alihng gene kedea urub gene kejea, “Giih robe yihdh gen teeg keter. Ngaa noono rom gen ke yiiho.” ");
INSERT INTO lwo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Keehd ngaa maa arob ngo yihre tooro, e ngo abeehn Jeacuue ne ngeyo kejea yaa ni ge ngoan kaa nying giih apuohnye. Noono urube yihr gen kea, “Gihn ni cwihnyu araanye ne? ");
INSERT INTO lwo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nea a ge adoohng ne dhaano utaahngo niidu niido e a adog kara ge ne beeda coon, e wu urob gihn? ");
INSERT INTO lwo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Wahy Juog e ne cub kuowo, abea kuowo me cub teeg dhaan utaahnge tooro. Luube giih aroba yihru ni, ge ne meehg wun yoad Wahy Juog ge cub kuowo yihru. ");
INSERT INTO lwo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Abea keehd maano, e nyoge mooge kiinu ge poohd be yiih.” (Beehd e ngo ngahy Jeacuue ke coon e yaa ukweer ke yiih lume kedea ngaa uluom ngo.) ");
INSERT INTO lwo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Maa abare maalo ke rob kea, “Ke nying gihn nu, e naa gihn aruba yihru kaa ngaa me beehn banga tooro nea padh Wura e ne meehg ngo beehn banga.” ");
INSERT INTO lwo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ke wong cahng nu e yaa abuodh ngo me thoohdh ge ado yihdh miehy gen kedea ubahnge batiene kuu acahg gene ke buodho. ");
INSERT INTO lwo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Noono e jo waahdhe kar ge apaar wonge ariow ge apeehnye peehnyo kobe, “Wu daahd uaayu thiow?” ");
INSERT INTO lwo_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Maa abeehr Cimoan Piihtere ngo yihre kobe, “Ruohdh ngaa e ne cidh wane bange? Abea yih ne cub kuowo me ne cohg yihr nyoge? ");
INSERT INTO lwo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kedea ngo ayiih wane awaahn ni kejea yih naa ngaa aoohr Juoge ge Ngad Boadh nyoge.” ");
INSERT INTO lwo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Maa abeehr Jeacuue ngo kea, “Ngahda a naa akwany wun ke karu cang ge apaar wonge ariow ni? Abea dhaano acielo nud kiin nu me ree naa atiihb ukeehg?” ");
INSERT INTO lwo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jeacuu anaa arubo kaa nying Juudo ge waahd Cimoane Yijkaariod. Bang gihn Juudo e naa ngaa ubeehn ne luom ngo keehd me anahge kiin jo waahdhe ge akwanye ge apaar wonge ariow ni. ");
INSERT INTO lwo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ke batiene, e Jeacuu abeehn ne aay ucea Gaalili. Bang gihn cwihnye atooro beehd kiin yaa Judea ke nying gihn jo doong Judea giih beed geen nu ge daahd ngo ke naah. ");
INSERT INTO lwo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Abea ge anaa adoohng Yaan Amuoj pinye cahng, e beehd nyoge yihdh abuwe cang ni ");
INSERT INTO lwo_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","e wuud wahn arubo yihre kob gene, “Aayi oogo kan ucii Judea, bang ubeehn jo waahdhi uniid gene giih me teeg me gaahy nyoge ge tiihyi ni. ");
INSERT INTO lwo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ngaa noono mahn nyoge ubahnge gihn tiihyi be ngej nea ngo daahd ubeehn nyinge uwiihje? Me neehn kaano yugi giih me gaahy nyoge e kea meehg gen niido yihr nyoge cang.” ");
INSERT INTO lwo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Keehd wuud wahn e giih tiihy Jeacuue ge kuu ayiih gene.) ");
INSERT INTO lwo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kob Jeacuue yihr gen, “Cahnga poohd kuu abeehno. Abea maru nihn ge uroomo yihru cang. ");
INSERT INTO lwo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yaa wiih piny gihn me maan gene wun ke nyinge ngo tooro. Abea a naa amaan gene bang gihn kwaaya ke rob yihr gen kejea ge tiihy giih me reje. ");
INSERT INTO lwo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cidhu yi yaay, abea mara cahng ucidha yi yaay ngo poohd kuu abeehno.” ");
INSERT INTO lwo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Gihn ni ngo ateede kedea udoohnge ne beehdo yi Gaalili ke nihn me noog. ");
INSERT INTO lwo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Abea ge anaa a'aay wuud wahne ne ci yi yaay, e ngo abeehn ne cidho. Abea naa acidhe e caahdh e ree be nyoadhe beere ngaa me ngey ngo tooro. ");
INSERT INTO lwo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jo doong yaa Judea ge abuohj ke caahyo e ge daahd Jeacuu ke bang yi yaay maa apeehy gene kob gene, “Ngaan ngo naa kee?” ");
INSERT INTO lwo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nyoge me thoohdh ge ake peehmo ke piny ke kiin gen kob nyoge mooge, “Ngo ngaa me beer.” Maa nyoge mooge kob gene, “Ngo ngaa me dwaahng nyoge.” ");
INSERT INTO lwo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Abea ngaa maa arubo e duone atihnge maalo ke nyinge tooro, bang gihn ge atud ke nying ruohdh Judea. ");
INSERT INTO lwo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ge anahge yi diehr nihn yaay arumo, e Jeacuu abeehn ne ci yi laaro gihr Wod Juog uthube ke puohny kaano. ");
INSERT INTO lwo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jo doong yaa Judea ge abeehn ne gaahy ke raahyo yi dhe yoohn puohny gihre ne puohnye nyoge maa akoohb gene, “Kwaad ngaan kuu akuong ke puohnyo. Giih puohnye ni ge ayoade ke kee, abea ngo kuu acidh yi madharaaja!” ");
INSERT INTO lwo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","E ngo abeehr Jeacuue kea, “Gihn puohnya padh gihn me a naa apar ngo. Puohny abeehno ke bang Juog ge aoohr an ni. ");
INSERT INTO lwo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ngaa daahd utiihye gihr Juog e ngo ungahye kejea gihn puohnya beehn ke bang Juog wale ngo beehda gihn maa apara a keeda. ");
INSERT INTO lwo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kwaad ngaa rob luub muue keede kwaad ngaan nu daahd leej ke nying ngud mare. Abea kwaad ngaa daahd uleeye ngaan aoohr ngo, e ngaan nu e ne rob athiir kedea padh ngaa me rubo ke toohd. ");
INSERT INTO lwo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moaje ke ngude wu amuoje ke loohnge abea poohd e ngaa maa atiihyo keehd loohnge giih nu kiinu tooro. A daahdu ke naah kaa nying gihn?” ");
INSERT INTO lwo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Maa abeehr nyoge ngo kob gene, “Yih amuohl kedea rihi naa atiihb ukeehg. Jo aweehne ge ne daahd yihn ke naah?” ");
INSERT INTO lwo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Maa abeehr Jeacuue ngo yihr gen, “Gihr nyepiny acielo me gaahy nyoge ngo atiihya maa agaahyu keter. ");
INSERT INTO lwo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nyedhoohy beehd e ge thoamu thoamo cahng Cabadh neehn kaa arob Moaje kejea thoamu nyethiin cuow. Abea keehd maano, e kuu anaa anahg Moaje e naa ngaa ateed ngo yihru umodho kejea thoamu nyethiin cuowo. Anahg ge kuowu ge naa athob thoam rog nyedhoohg gen. ");
INSERT INTO lwo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nea nyethen thoamu thoamo cahng Cabadh e gihn e naa araany cwihnyu riha ke nying gihn athiehdha dhaano maa abab piny cahng Cabadh? ");
INSERT INTO lwo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Wiiu kihm nyoge ke dhe yoohn loohnge mooge abea kihmu nyoge kaa loohng Juog.” ");
INSERT INTO lwo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kaano e nyoge mooge maa yaa Jeruucalem ge athubo ke piehj kob gene, “Ngahda nyin e naa ngaan daahd jo doong Judea ke naah? ");
INSERT INTO lwo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Maahnyu e ne ca rubo nyum nyoge kedea gihn me rob jo doong yaa Judea ke nyinge tooro. Ne cohg ngo ngahy gene kejea e naa Ngad Boadh nyoge ");
INSERT INTO lwo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Abea ge ubeehn Ngad Boadh nyoge, e ngaa muu ungahy kun abeehne kii ngo utooro. Abea ngaan, kun beehne kii ngo, ngo ngahyo cang.” ");
INSERT INTO lwo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Noono ge apuohny Jeacuue puohnyo yi laaro gihr Wod Juog, e puohnyo e ukwaago keraahyo kea, “Aparu kuu angahyu ne cohg kedea kun abeehna kii ngo, ngo ngahyu. A kuu abeehn wiih piny kan kaa dhe yoohn tee mara. Ngaan aoohr an ngo ngaa me rob athiir kedea ngaan nu gihn me nweehd wun keehde tooro. ");
INSERT INTO lwo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Abea a beehda anweehd keehde, bang gihn a abeehn ke bange kedea e naa aoohr an.” ");
INSERT INTO lwo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ke nying gihn nu e jo doong yaa Judea ge adaahd umag gene Jeacuu abea ngaa maa atihng cinge maalo ree tooro bang gihn cahng umag gene ngo, ngo poohd kuu abeehno. ");
INSERT INTO lwo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Abea nyoge me thoohdh kiin yaa akuud ge yiiho ke lume kedea ukoohb gene, “Nea Kriihjto ubeehn wudhu aparu kejea yihre unaa giih me gaahy nyoge me kaal muu ngaan ne?” ");
INSERT INTO lwo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Paarijea mooge ngo abeehn gene ne lihngo e nyoge ge urubo ke nying Jeacuu, noono e gen kedea jo doong yaa lam maa acaakere giih koar Wod Juog ge aoohr gene ne mag Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Gihn nu e Jeacuu arubo yihr gen kea, “A ubeehdo ke wun ke nihn me noog mee kedea a uaay ne dog bang ngaan aoohr an. ");
INSERT INTO lwo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A udaahdu abea a buu uyoadu bang gihn wu buu uwahnh ka nahga yea.” ");
INSERT INTO lwo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Maa arub yaa Judea ke kiin gen kob gene, “Kee ge daahde ci yea ni, ge bahnge ngo be yoado ni? Ngo ucaa wudh geedh Griihge ge beed jo paaro upuohnye gen ne? ");
INSERT INTO lwo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Arobe kea, ‘A udaahdu abea a buu yoadu,’ kedea, ‘Ka nahga yea wu buu uwahnh yea?’ Ngo daahd gihn ke robo yihro?” ");
INSERT INTO lwo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yi cahng thum yaay kedea e naa cahng duohng yi yaay, cahng rub gene ke nying piih me beehn oogo kii Wod Juog ne boadh nyoge e Jeacuu ayedh maalo urube e duone atihnge maalo kobe, “Nea ngaa maa anahg riowe, e kea beehne banga umuoja ngo ke piih me maadhe. ");
INSERT INTO lwo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Wa kaa anaa agweede yi kitaab Juog kejea a nuu unahg naam me yea ne piih me boadh wahy nyoge mooge.” ");
INSERT INTO lwo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ge arub Jeacuue ke nying piih e gihre anahg rob ke nying Wahy Juog ge uyoad yaa ayiih lume. Ge arob Jeacuue gihn nu e Wahy Juog poohd kuu anaa acub bang gihn Jeacuu apoohdo e kuu aci Maalo Paar Juog kaa umoar wiihe yea. ");
INSERT INTO lwo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ge alihng nyoge mooge kiin yaa akuude lum ni e ge arubo kob gene, “Ngaan beehda agamloohngjuog me ne cohg.” ");
INSERT INTO lwo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nyoge mooge kob gene, “Ngo beehda Kriihjto.” Abea nyoge mooge kob gene, “Kriihjto ngo akuong beehno ke yoohn Gaalili ne? ");
INSERT INTO lwo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ngahda anaa agweed yi kitaab Juog kejea, Kriihjto ubeehn oogo kii dhe wod paar Deabid ge anahg ruohdh ne? Kedea unyuol yi geen Bedhlehm ge anaa abeed Deabide ne?” ");
INSERT INTO lwo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kaano e nyoge luub gen apaah ke nying Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nyoge mooge ge daahd umag gene ngo abea ngaa maa ajag cinge rih ngo tooro. ");
INSERT INTO lwo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Batiene e acaakere giih koar Wod Juog ge abeehn ne doo caahn bang jo doong yaa lam kedea Paarijea. Gihn nu e ge apeehny gene kejea, “Gihn ge bahnge ngo kuu amagu ukahlu ngo ni?” ");
INSERT INTO lwo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Maa abeehr acaakere ngo, “Ngaa maa akuong rob wa kwaad mar nyin nu tooro.” ");
INSERT INTO lwo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Maa apeehy Paarijea, “Rogu ameehgu dwaahngo yihre thiow? ");
INSERT INTO lwo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ne ruohdh Judea wale Paarijea maa akuongu ke yoado e ayiiho ke lum Jeacuu ne? ");
INSERT INTO lwo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Gahng! Abea beehda nyoge me kwihy loohnge ge naa ayiih lume. Nea wa maano kea beehn Juoge lame gen uyoad gene gihn me raaj.” ");
INSERT INTO lwo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikoadiihmuj ngad Paarijea ge naa acidho bang Jeacuu coon, arubo yihr nyoge mooge kea, ");
INSERT INTO lwo_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Yi loohng gihro ngo padh kare ukihm dhaano e ngo kuu akuong ke peehnyo kedea ungey gihn atiihye.” ");
INSERT INTO lwo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Maa angier gene ngo ukoohb gene, “Beer! Ngahda yih beehda ngad Gaalili ne? Kwaan kitaab Juog gihn agweed, nea ngo uyoadi kejea agamloohngjuog maa akuong beehno ke yoohn Gaalili nud?” ");
INSERT INTO lwo_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Noono maa a'aay gene e ngaa man caa paare. ");
INSERT INTO lwo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Abea mar Jeacuu ngo abeehn ne ci wiih good me cuohn ne Ulihbe. ");
INSERT INTO lwo_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yi ruung piny ke nyango e Jeacuu aduu yi laaro gihr Wod Juog. Kaano e nyoge me thoohdh rog ge acong gene buude kedea uthube ke puohny gen. ");
INSERT INTO lwo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nye wong kaano e yaa loohng Juog kedea Paarijea dhaago maa amag ke dhecuow abeehn gene ne kahlo kedea umeehg gene ngo cuung nyum gen. ");
INSERT INTO lwo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Urub gene yihr Jeacuu kob gene, “Ngad puohny, dhaar ni ngo amag ke dhecuow. ");
INSERT INTO lwo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Abea loohng Moaje arubo yihro kejea kwaad ngaa yug awuohj me wa gihn nu e ngo ke bahno ke leele uthowe. Gihn e ne robi ke nyinge?” ");
INSERT INTO lwo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ge apeehyo wa maano bang ne waale beere e urubo ke rob me raaj nyum nyoge, me meehg ngo mago yihr gen. Abea Jeacuu wiihe akuule piny e ugweehdo yi ngoom ke lweede. ");
INSERT INTO lwo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Abea naa apoohde e ge bar maalo ke piehj e wiihe atihnge maalo maa arube yihr gen kea, “Ngaa ree tooro adhemuohm kiinu kare nud unahge en e ne kuong leen umodho ke baahlo ne nahg dhaar ni.” ");
INSERT INTO lwo_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Maa adoge piny ne gweed yi ngoom. ");
INSERT INTO lwo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Naa alihng gene rob gihn ni, e ge athubo ke aay naa acielo acielo. Yaa doonge ge naa akuong aay umodho. Noono udoohng Jeacuue kare keede maa dhaago gihn apoohdo e ucuungo kaano. ");
INSERT INTO lwo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Maa atihng Jeacuue wonge maalo upeehnye dhaar ni kea, “Jo akoohbo kejea yih ayug awuohj, ge ne kee?” ");
INSERT INTO lwo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Maa abeehr dhaar ni ngo kobe, “Ngaa maa adoohng me kihm an tooro Ruohdh.” Maa akoohb Jeacuue kea, “A thiow yih be kihma keehd maa atiihyi adhemuohm. Abea cidhi kedea giih adhemuohm ge keá cahg ke yugo keehdo.” ");
INSERT INTO lwo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Maa adog Jeacuue rob yihr Paarijea kea, “A naa ngaa meehg nyoge ngahy Juog wa gihr maaj ge meeny yi muudho ungahy dhaane ka cea yea. Ngaa buodh batiena yihre unaa kuowo kedea kaa cea yea ngo ungahye.” ");
INSERT INTO lwo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Maa arob Paarijea ngo yihre kob gene, “Wa yih rubo kaa nyingi abea dhaano tooro me koohbo kejea giih robi ke nyingi ge athere. Nea neehn maano e giih robi ngaa me rom gen ke yiiho tooro.” ");
INSERT INTO lwo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","E ngo abeehr Jeacuue yihr gen kobe, “Bekihde! Keehd me toor ngaa me rob ngo kejea giih roba ke nyinga ge athere, ge athere bang gihn a ne ngahy kun abeehna kii yea kedea kun caa yea. ");
INSERT INTO lwo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nyoge ge kihmu kaa dhe yoohn ukihm mar dhaano utaahngo, abea a be kihmo ke dhaano kejea ngo ayug awuohj. ");
INSERT INTO lwo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Abea nea dhaano maa ayug awuohj kihma kihmo e ngo kihma kaa dhe yooh me ne cohg. A ne kihmo ke dhe yooh me ne cohg bang gihn padh a keeda a ne kihmo abea Wura ngaa aoohr an nud ke an. ");
INSERT INTO lwo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nud keehd luube maa agweed yi loohnge giihu kejea nea nyoge ariow ge arob lubo acielo ke nying nyepiny, e lum gen ngo adiehr. ");
INSERT INTO lwo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","A rob gihn maa adiehr ke nyinga kedea Wura ge aoohr an ni e ne rob athiir ke nyinga.” ");
INSERT INTO lwo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Maa apeehny gene ngo kob gene, “Wuru naa kee?” Maa abeehr Jeacuue ngo yihr gen kobe, “A kwihyu kedea Wura kwihyu? Nea a ne ngahyu e Wura nuu angahyu thiow.” ");
INSERT INTO lwo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Luube giih ni ge arobe e puohny nyoge yi laaro gihr Wod Juog, buud kaa acub caanduug gihn thoohr nyoge ngiihny cub ke nying Wod Juog yea. Ngaa maa amag ngo tooro bang gihn padh e naa cahng akob Juoge kejea ngo umag yea. ");
INSERT INTO lwo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Maa adog Jeacuue rob yihr gen kea, “A uaay abea wu uthow kaa anyoohne rogu ke nying gihn bahnge giih anyoohne be wiiu. Wu buu uwahdh ka naa yea.” ");
INSERT INTO lwo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ke nying gihn ni e ruohdh yaa Judea ge athubo ke rob ke rog gen, “Ree unahge naah wale gihn? Gihn ge koohbe kejea ka cea yea wo buu rom wahnh yea?” ");
INSERT INTO lwo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Maa abeehr Jeacuue ngo yihr gen kea, “Wu beehda yaa wiih piny kan abea a abeehno kaa yoohn Paar Maalo. Wu yaa wiih piny kan abea a padh ngad wiih piny kan. ");
INSERT INTO lwo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","E naa gihn aroba ngo yihru kejea wu uthow kaa anyoohne rogu nea wu buu uyiiho kejea A Juog wa ka na roba ngo yihru.” ");
INSERT INTO lwo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","E ngo abeehn gene ne peehnyo kob gene, “Yih naa ngaa?” Maa abeehr Jeacuue ngo kea, “A Juog wa ka na roba ngo yihru coon. ");
INSERT INTO lwo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yihra ne giih me thoohdh me roma ke robo ke nyingu kedea giih me thoohdh me roma wun ke kihmo ke nying gen. Abea giih nu ge be roma tiihyo ke kar wiiha bang gihn arob adiehj gihn alihnga bang ngaa aoohr an yihr yaa wiih piny kan.” ");
INSERT INTO lwo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yaa alihng giih arobe ngo kuu angey gene kejea ngo rubo kaa nying Juog Wuur. ");
INSERT INTO lwo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Noono e ngo arobe yihr gen, “A ge Ngad Boadh nyoge, cahng ugur an maalo rih yaadh maa ariihw e nuu ungeyu ngo kejea a Juog wa ka na roba yihru. Kaano e nu ungahyu ngo kejea a be tiihyo kaa tee mara a keeda bang gihn gihn roba beehda gihn arob Juog Wuure yihra kejea roba ngo yihru. ");
INSERT INTO lwo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kedea wura ngaa aoohr an nud tiehd keehd an. A keá wii kara keeda, ngo nud keehd an ke nying nihn bang gihn gihn tiihya ngo nhyaare nhyaaro.” ");
INSERT INTO lwo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ge arobe giih ni, e nyoge me thoohdh ge abeehn ne yiiho yi lume. ");
INSERT INTO lwo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kob Jeacuue yihr yaa ayiih lume kea, “Nea wu bar maalo ke tiihj keehd luube giih nu apuohnya yihru nu, e wu beehda jo batiena me ne cohg. ");
INSERT INTO lwo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Noono e giih beeye naa anyoadh Juoge ge beehnu ke ne ngeyo kedea giih nu beeye ge nuu ulony wun oogo yi bahng.” ");
INSERT INTO lwo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Maa abeehr gene ngo kob gene, “Wa naa yaa Juog ne cohg bang gihn wa kwaay Abraahm kedea be ngaa maa akuong doohng ne baahng. Gihn ge rubi kejea wa uluny oogo yi bahng?” ");
INSERT INTO lwo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Maa arob Jeacuue ngo yihr gen kea, “A rob athiir yihru! Ngaa koag ke yug adhemuohm ngo beehda baahng adhemuohm. ");
INSERT INTO lwo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Paajo be doohng yi cing ubaahng ne maa, bang gihn beehda waahd ngad paajo e ne wii paajo yi cinge. ");
INSERT INTO lwo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nea waahd ngad paajo e naa aluny wun oogo yi bahng, e wu adoohng ne nyoge me tooro yi bahng ne cohg. ");
INSERT INTO lwo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ngo ngahya kejea wu yaa Judea wu beehda kwaay Abraahm. Abea keehd maano e wu daahd unahgu an bang gihn cwihnyu tooro utiihyu ke dhe yoohn apuohnya yihru. ");
INSERT INTO lwo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","A rob gihn aniida ge anuda buud Wura kedea wu tiihyu gihn alihngu bang weehgu na anahgu yaa agamloohngjuog.” ");
INSERT INTO lwo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Maa abeehr gene ngo yihr Jeacuu kob gene, “Abraahm beehda kuow wan.” Maa aduog Jeacuue ngo kea, “Nea wu ne nahg kwaaye ne cohg, e wu ne ke beehdo ke beehd Abraahme kedea utiihyu giih ne tiihye. Abea awaahn ni wu daahd unahgu an. A ge rub yihru ke nying giih arob Juoge yihru. ");
INSERT INTO lwo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Gihn atiihya beehda gihn ateeda giih alihnga bang Juog yihru. Noono e ne daahdu an ke naah. ");
INSERT INTO lwo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gihn me kuu akuong Abraahme ke tiihyo. Wu tiihy kwaad giih na tiihy ge weehgu yaa na tiihyo yihr atiihb ukeehg.” Maa abeehr gene ngo kob gene, “Ngaa maa anyuol e tuong kiin wan tooro. Yihr wan ne wur wan acielo cog ge beehda Juog ke ngude ni.” ");
INSERT INTO lwo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kob Jeacuue yihr gen kea, “Nea Juog ne nahg wuru ne cohg, e a nuu nhyaaro bang gihn a beehn kaa dhe yoohn bang Juog ke ngude kedea a man kan. A kuu abeehno kaa dhe yoohn mara keeda, abea Wura e naa aoohr an. ");
INSERT INTO lwo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Gihn e bahnge gihn roba yea be deadu ni? Yea be deadu bang gihn wu akweer ke lihng luma. ");
INSERT INTO lwo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Wu beehda nyethea atiihb ukeehg wuru kedea wu daahd utiihyu giih tiihy weehgu. Atiihb ukeehg gihre beehda nahg nyoge kedea gihn maa adiehr me robe tooro bang gihn gihre maa adiehr tooro. Nea atiihb ukeehg urubo, e rubo kaa luub toohd bang gihn rob toohd e naa gihn ngahye. Ngo ngad toohd kedea toohd yoad ke bange. ");
INSERT INTO lwo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Abea mara a rob gihn maa adiehr e naa gihn bahnge luma be yiihu. ");
INSERT INTO lwo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ngaa kiin nu e ne rom rob riha kea a ngad adhemuohm? Nea a urubo yihru kaa athiir e gihn e bahnge ngo be yiihu ni? ");
INSERT INTO lwo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ngaa beehn ke yoohn bang Juog nhyaar lum teed Juoge abea wu ge kuu abeehno ke yoohn bang Juog lum Juog be yiihu.” ");
INSERT INTO lwo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Maa apeehny gene Jeacuu kob gene, “Ngahda beehda adiehr e ne rob wane nea wa ukoohbo kejea yih beehda ngad Camaarya kedea rihi ne atiihb ukeehg?” ");
INSERT INTO lwo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Maa abeehr Jeacuue ngo kea, “Atiihb ukeehg me ne riha tooro. Gihn nud Wura wiihe moara moaro abea wun, wiiha be moaru. ");
INSERT INTO lwo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Cwihnya tooro meehg nyoge moar wiiha ke nying ngud mara. Abea ngaa me daahd nyoge umoar gene wiiha ngo nud kedea ngaan nu e ne rob gihn maa adiehr ke nyinga. ");
INSERT INTO lwo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A rob athiir yihru, ngaa yiih luma e ngo be kuong thoo.” ");
INSERT INTO lwo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Maa aduog gene ngo yihr Jeacuu kob gene, “Awaahn ni ngo angey wane kejea rihi ne atiihb ukeehg! Abraahm athow kedea yaa gamloohngjuog ge athow kedea yih poohd urubo kejea nea ngaa yiih lumi e ngo be kuong thoo! ");
INSERT INTO lwo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yih ne duohng rih Abraahm kuow wan ge athow ne? Abraahm athow kedea yaa agamloohngjuog ge athow. Wiihi apari kejea yih naa ngaa?” ");
INSERT INTO lwo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Maa abeehr Jeacuue ngo kea, “Nea a ne nahg ngaa me moar wiiha a keeda, e gihr nying moar wihj gihn nu ne tooro. Wura ge cuohnu ne Juog gihru ni, e naa Wura ge moar wiiha. ");
INSERT INTO lwo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Keehd maan kwihyu en, e ngo beehda ngaa me ngo ngahya. Nea a urubo kejea ngo kwihya, e a beehda ngad toohd wa wun. Ngo beehda ngaa me ngahya kedea luube ge ne tiihya ke gen. ");
INSERT INTO lwo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraahm ge beehda wuru ni cwihnye anaa amihno ge angahye cahng ubeehna wiih piny kan. Cahng ngo aniide kedea umihn cwihnye.” ");
INSERT INTO lwo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Maa aduog gene wiih lubo yihre kob gene, “Runi puud kuu awahdh yi jiehariow wonge apaar abea yih urubo kejea Abraahm aniidi ne?” ");
INSERT INTO lwo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Kob Jeacuue yihr gen, “Beehda gihn maa adiehr e ne roba yihru. Ge apoohd Abraahme kuu anyuol e a anudo ke Juog neehn Juog.” ");
INSERT INTO lwo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ke nying lum nu arobe e ge athubo ke kwany leele ne bahn ngo. Abea Jeacuu ree aloaye oogo yi laaro gihr Wod Juog. ");
INSERT INTO lwo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ge anaa acaahdh Jeacuue caahdho tiehd keehd jo waahdhe ni, e dhaano maa anyuol e acoor aniide niido. ");
INSERT INTO lwo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Maa apeehny jo waahdhe ngo kob gene, “Ngad puohny beehda adhemuohm gihr ngaa e naa ameehg ngo nyuolo e acoor? Beehda adhemuohme giihe wale adhemuohme giih atiihy ge wahne?” ");
INSERT INTO lwo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Maa abeehr Jeacuue ngo kea, “Padh ke nying adhemuohme giihe wale adhemuohme giih ge wahn ge naa ameehg ngo nyuolo e wonge acoor. Abea ngo acoor beere ka tiihy tee Juoge kii ngo ke niido. ");
INSERT INTO lwo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Wo cang, laaro giih aoohr an ke nying gen ke tiihyo. Laaro ge ke tiihyo e wong cahng nud bang gihn nea piny ayuudho e ngaa me rom tiihj tooro. ");
INSERT INTO lwo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","A naa daahr gihn meeny piny cang yihr nyoge ka poohde e a nud wiih piny kan.” ");
INSERT INTO lwo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ge athume ke robe noon ni, e laaw angoale piny unweene lahbo ugwaahye ngo yi wong ngaan acoor, ");
INSERT INTO lwo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","kedea urube yihr ngo kea, “Cidhi uluogi wongi yi Paahl gihr Ciloam.” Maa abeehn ngaane ucidhe kedea uluoge wonge maa uduue e piny uneehno yihre. ");
INSERT INTO lwo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kaano e waahd gen kedea kwaad jo na niid ngo coon e ukwahyo, ge athubo ke piehj kob gene, “Ngahda e naa ngaan na piih piny kan ne kwaj e gihn ne?” ");
INSERT INTO lwo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nyoge mooge kob gene, “Beehda en.” Kedea nyoge mooge kob gene, “Padh en abea beehda ngaa me room keehde.” Gihn nu e nyin ke ngude arubo kea, “Beehda an ge na kwahyo ni.” ");
INSERT INTO lwo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Noono e ge ake rubo yihre, “Gihn e naa ayab wongi uniidi nyepinye?” ");
INSERT INTO lwo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Maa abeehre ngo kea, “Ngaan cuohn ne Jeacuu e naa anween lahbo ke laaw dhee ugwaahye ngo yi wonga maa arube yihra kea, ‘Cidhi wiih Paahl gihr Ciloam kedea uluogi wongi.’ Gihn nu, naa acidha uluoga wonga e wonga ree ayabe yabo uniida nyepinye.” ");
INSERT INTO lwo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Maa apeehy gene, “Ngaan ngo naa kee?” Maa abeehre ngo kea, “Kaa acea yea ngo kwihya.” ");
INSERT INTO lwo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kaano e arob gene kejea beehn nyine cidhe ke gen bang Paarijea. ");
INSERT INTO lwo_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ngo anahg cahng Cabadh ge anaa abeehn Jeacuue unweene lahbo ne yab wong nyin. ");
INSERT INTO lwo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Noono e Paarijea nyin adog gene ke peehnyo ke dhe yoohn ayab wonge kii ngo. Maa arobe ngo yihr gen kea, “Lahbo e naa agwaahye yi wonga uluoga wonga kedea piny uneehno yihra awaahn ni.” ");
INSERT INTO lwo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kob yaaj mooge kiin Paarijea, “Ngaan atiihy gihn, padh Juog e naa aoohre, bang gihn atiihye cahng Cabadh.” Abea nyoge mooge kob gene, “Ngad adhemuohm giih me gaahy nyoge ge be rome ke tiihyo.” Kaano e luub gen awaahj upaah yihdh gene. ");
INSERT INTO lwo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Noono e Paarijea ngaan acoor adog gene ke peehnyo kob gene, “Kobi yih athiehdhe uniidi nyepinye. Nea yihr mari e ngo beehda ngaa me ngihde?” Maa abeehre ngo kea, “Ngo beehda ngad agamloohngjuog.” ");
INSERT INTO lwo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ruohdh yaa Judea apoohd e be yiih gene kejea ngaan ni abeehdo e wonge anaa acoor kedea wonge ayahbo, noono maa acuohn gene wahn kedea men. ");
INSERT INTO lwo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Maa apeehny gene gen kob gene, “Gihn beehda waahdu ne? Kobu ngo anyuol e ngo acoor, abea wonge abeehn ne yahbo ke ne diih?” ");
INSERT INTO lwo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Maa abeehr ge wahne ngo kob gene, “Adiehr muon, ngo beehda waahd wan abea ngo beehda adiehr thiow kejea anyuol e wonge acoor. ");
INSERT INTO lwo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Abea gihn ayab wonge ngo kwihy wane? Ngo beehda ngaa me duohng. Peehnyu ngo ke ngaa ayab wonge. Kare nud yihre ubeehre lumu.” ");
INSERT INTO lwo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Gihn ni arob gene ke nying gihn ge atud yihr Ruohdh yaa Judea. Ngo beehda gihn maa agweehg Ruohdh yaa Judea coon kejea ngaa yiih ngo kea Jeacuu beehda Ngad Boadh nyoge, e ngaan nu riem oogo yi wod amaad gihr Judea, ");
INSERT INTO lwo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","e naa gihn arub ge wahne kob gene, “Ngo ngaa me duohng peehnyu ngo.” ");
INSERT INTO lwo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Noono maa acahg gene nyin wonge anaa acoor ke cuohno keehdo urub gene yihr ngo kob gene, “Kuohng rihi nyum Juog. Ngahy wane kejea ngaa athiehdh yihn ngo ngad adhemuohm!” ");
INSERT INTO lwo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Noono e ngo abeehr nyine kea, “Kwihya me nahge ngad adhemuohm wale padh ngad adhemuohm. Abea gihr nyepiny acielo e ne ngahya: a anaa acoor kedea piny uneehnu yihra awaahn ni.” ");
INSERT INTO lwo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Batiene e ngo apeehny gene keehdo, “Gihn ne cohg e naa ayuge rihi ge ayahb wongi ni?” ");
INSERT INTO lwo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Maa abeehre ngo yihr gen kea, “Ngo aroba yihru kedea wu be daahd uyiihu gihn aroba. Gihn ge daahdu ngo ke lihngo keehdo? Ka moogo e wu daahd udoohngu ne yaa waahdhe!” ");
INSERT INTO lwo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Noono uyeny gene ngo kob gene, “Yih naa ngad waahdhe abea wa beehda yaa waahdh Moaje. Moaje kuow wan ge acub loohnge yihr wan. ");
INSERT INTO lwo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ngahy wane kejea Juog arubo yihr Moaje. Abea ngaan nu keehd paan abeehne kii ngo kwihy wane.” ");
INSERT INTO lwo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Maa abeehre ngo yihr gen kobe, “Gihn ge adogu wiiha ke lyaahbo ni! Wonga athiehdhe abea paan abeehne ke yoohn yi ngo, kwihyu ne! ");
INSERT INTO lwo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Beehda gihn me ngahj kejea Juog, gihn kway yaa adhemuohme ngo be cube yihr gen. Juog muoj yaa wuor en kedea utiihy gene gihn daahd Juoge. ");
INSERT INTO lwo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kuu umodho coon ge anaa acag piny ni ngaa e naa akuong ke lihngo kejea wong ngaa maa acoor ayabe? ");
INSERT INTO lwo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nea padh Juog e naa aoohr ngo e kwaad gihn be nea rom ke tiihyo.” ");
INSERT INTO lwo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Maa abeehr gene ngo kob gene, “Yih beehda ngad adhemuohm kii yi cahng anyuol yihn. Ngaa noono romi ke puohnyo?” Maa ariem gene ngo oogo yi wod amaad. ");
INSERT INTO lwo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Gihn ayug ree anaa abeehn Jeacuue ne lihngo. Noono naa abeehn Jeacuue uyoade nyin keehdo e apeehnye kea, “Lum ngaan adoohng ne dhaano utaahngo ngo ayiihi?” ");
INSERT INTO lwo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Maa abeehr nyine ngo kobe, “Ngo beehda ngaa Ruohdh beere lume yiiha yiiho?” ");
INSERT INTO lwo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Maa abeehr Jeacuue kea, “Ngo beehde e ngo aniidi awaahn ni kejea a naa ngaan ngo a e gihn rubo ke yihn awaahn ni.” ");
INSERT INTO lwo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Maa akob nyine ngo kea, “Ruohdh! Ayiiha.” Kedea uthube ke rung cunge piny nyum ngo ne wuor ngo. ");
INSERT INTO lwo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kob Jeacuue, “A abeehn wiih piny kan ke nying paahng kiin nyoge, beere yaa kwihy Juog, ge neehn nyoge maa acoor, Juog ngahy gene ngahyo kedea beere yaa kang rog gen kejea Juog ngahy gene ge ubeehdo yi muudho neehn nyoge maa acoor.” ");
INSERT INTO lwo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Paarijea mooge me kuu ayiiho maa anaa buud gen, gihn arob Jeacuu alihng gene maa apeehy gene, “Nea mare e wa beehda coohre ne?” ");
INSERT INTO lwo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kob Jeacuue yihr gen, “Nea wu ne nahg coohre, e adhemuohm ne tooro rogu. Abea naa akoohbu kejea wu padh coohre e naa gihn poohd e adhemuohm ne rogu noono. ");
INSERT INTO lwo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“A rob athiir yihru yaa ge koara koaro wa gihr ngad kwaah. Ngad kwaah e naa ngaan mon yi roog diehg ke dhe wod, abea ngaan mon yi roog ke dhe yooh moogo ngo beehda ngad kahw wale ngad yaahg. ");
INSERT INTO lwo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ngaan mon yi roog ke dhe wod ni e naa ngad kwaah me ne cohg. ");
INSERT INTO lwo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ngad kwaah e ne meehg mon wod kedea duone ngahy diehge. Diehg ge cuohne kaa nying gen naa acielo acielo kedea ukoohle gen oogo. ");
INSERT INTO lwo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nea diehg ge akoohle oogo cang, e caa wong maalo nyum gen kedea ubuodh diehg batiene bang gihn duone ngahy diehge. ");
INSERT INTO lwo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Abea ge be kuong pahdh batien ngaa me kwihj gene. Ge goohd oogo rih ngo bang gihn duon ngaa maa aley kwihy gene.” ");
INSERT INTO lwo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ucaale gihn ni arob Jeacuue yihr gen abea yea ngo kuu angey gene. ");
INSERT INTO lwo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Noono e Jeacuu arubo keehdo kea, “A rob athiir yihru: A uroomo wa dhe roog ge mon diehge kii ngo. ");
INSERT INTO lwo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kwaad yaa umodho cang naa abeehno e a poohd kuu awahnho ge anahg yaa kahw kedea yaa yaahg kedea gihn arob gene be kuong diehg ke lihngo. ");
INSERT INTO lwo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","A uroomo wa dhe wod. Kwaad ngaa mon wod ke dhe yoohn banga e ubodho yi gihn me raaj. Ngo rom beehn wod kedea urome cidh oogo maa uyoade ka me beer wa gihr diel e yoad lum ulemo. ");
INSERT INTO lwo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ngad kahw beehn kaa nying kahw kedea ne naahg maa raahnyo. Abea a abeehno bang uyoad kuowo me ne cohg. ");
INSERT INTO lwo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“A naa ngad kwaah me ne cohg ge gwaay ree yi thoo ke nying diehg. ");
INSERT INTO lwo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ngad kwaah me koog, padh ngad kwaah me ne cohg bang gihn cwihnye naa bang ngiihny. Ge niide uthuohn e beehn bang diehg, e diehg wiie ke piny kedea ugoohde ke ngweej. Noono e uthuohn diehg mage mago kedea ukeedh mooge. ");
INSERT INTO lwo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ngad kwaah me koog ugoohdo ke nying gihn be dier kedea yihre tooro nhyaahro yi cwihnye ke nying diehg. ");
INSERT INTO lwo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“A naa ngad kwaah me beer, wa kwaad ke ngahy Wura an ni kedea ungahya Wura, ke dhe yoohn nu acielo nu, diehga ngahya kedea a ngahy gene. Kedea riha gwaaya ke ne thoo ke nying gen. ");
INSERT INTO lwo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Diehg mooge nud me beehda diehga abea ge poohd tooro yi roog. Ge dhiila kaa mahd yihdh diehg giih thiow. Duona udhiil gene ke lihngo kedea umahd gene rog gen bang diehg muu nud, noono udoohng gene ne lwaag acielo kedea yihr gen unaa ngad kwaah acielo. ");
INSERT INTO lwo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Wura, a anhyaare ke nying gihn agwaaya wahya yi thoo beere wahy ge cahga kaa yoado ucahra. ");
INSERT INTO lwo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ngaa me rom wahya ke kaabo uthowa tooro. Beehda an ke nguda, an ne gwaay riha yi thoo wa kaa apara ngo. Yihra naa adiehja me gwaaya riha yi thoo kedea yihra naa adiehja thiow me duua wahya riha, ucahra. Gihn nu e naa arob Wura kea tiihya ngo.” ");
INSERT INTO lwo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yaa Judea yihdh gen abeehn ne paah ge alihng gene lum nu arob Jeacuue. ");
INSERT INTO lwo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nyoge mooge me thoohdh kiin gen kob gene, “Yaage! Dhaano ree naa atiihb ukeehg e naa gihn amuohle. Giih robe ge keá lihngu.” ");
INSERT INTO lwo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Abea nyoge mooge kob gene, “Luub ni ge padh luub ngaa me ree naa atiihb ukeehg. Ngaa me ree naa atiihb ukeehg wong ngaa maa acoor yabe yabo ne?” ");
INSERT INTO lwo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ngo anahg ruudo kedea nyoge anaa yi Yaan Wod Juog yi geen Jeruucalem, ");
INSERT INTO lwo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","kedea e Jeacuu anaa yi laaro gihr Wod Juog kedea ngo ake caahdho ke thar Aar gihr Caloamon. ");
INSERT INTO lwo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kaano e naa acong yaa Judea rog gen buude maa apeehny gene ngo kob gene, “Wa keá meehg koar ke raahyo. Rob lubo maa adiehr yihr wan. Yih naa Ngad Boadh nyoge?” ");
INSERT INTO lwo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Maa abeehr Jeacuue ngo yihr gen kobe, “Ngo aroba yihru coon abea wu be daahd uyiihu gihn roba. Giih tiihya ke tee Wura ge nyoadh ngo kejea a naa ngaa. ");
INSERT INTO lwo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Abea wu kuu ayiiho bang gihn wu padh diehga. ");
INSERT INTO lwo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Diehg giiha gihn roba lihng gene lihngo kedea ge ngahya maa batiena buodh gene buodho. ");
INSERT INTO lwo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","A ne cub kuowo me ne cohg yihr jo ayiih luma kedea ge be cahg thoo keehdo maa ngaa me rom gen ke yag oogo yi cinga tooro. ");
INSERT INTO lwo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wura ge acub gen yihra ni, e ne duohng rog giih nyepinye cang kedea be ngaa me rom gen ke kaabo oogo yi cing Juog Wura. ");
INSERT INTO lwo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","A kedea Juog Wura wa beehda acielo.” ");
INSERT INTO lwo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kaano e yaa Judea leele acahg gene kaa kwanyo ne bahn Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Abea Jeacuu arubo yihr gen kea, “Giih me gaahy nyoge me teeg me thoohdh ge ayuga yihru ke tee gihn acub Wura yihra maa aweehne kiin gen e ne daahdu an ke bahno ke nyinge?” ");
INSERT INTO lwo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Maa abeehr gene ngo kob gene, “Wa be daahd ubahn wane yihn kaa nying gihn me beer maa atiihyi. Wa daahd ubahn wane yihn kaa nying gihn adhahli Juog kii yih uroomo keehde. Yih beehda dhaano utaahngo now abea yih daahd uyugi rihi ne Juog?” ");
INSERT INTO lwo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","36","Maa abeehr Jeacuue ngo yihr gen, “Ngo agweed yi kitaab Juog giihu kejea, ‘A ge adoohng ne dhaano utaahngo a beehda Juog.’ Nea loohnge giihu ge beehda loohnge maa ather ukoohbo kejea ngaa akahl Juoge lume yihr ngo, ngo beehda Juog e gihn ge koohbu kejea Juog adhahla ge aroma riha keehde. Kare tooro ukoohbu kejea Juog adhahla nea a ukoohbo kaa a waahd Juog kedea Juog wiiha amoare naa aoohre an wiih piny. ");
INSERT INTO lwo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nea padh tiihy Wura e ne tiihya e wu keá yiiho yi luma. ");
INSERT INTO lwo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Abea nea beehda tiihy Wura e ne tiihya e wu dhiil yiiho yi gihn atiihya. Giih tiihya ge dhiilu kaa yiiho beere ngo ngahyu ngahyo ne cohg kejea Juog Wuur beehda anweehd ke an kedea an beehda anweehd ke Juog Wuur.” ");
INSERT INTO lwo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Keehdo e ge adaahd umag gene Jeacuu, abea Jeacuu ree abeehn ne loay oogo uaaye. ");
INSERT INTO lwo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Batiene e Jeacuu abeehn ne dog dieng naam Joohrdoan kaa anaa athub Joone ke muoj nyoge ke luogwahy yea. ");
INSERT INTO lwo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Maa abeehn nyoge me thoohdh bange kedea e ge urubo kob gene, “Keehd me bahnge giih me gaahy nyoge maa atiihy Joone tooro, e giih arobe ke nying nyin ge beehda athere.” ");
INSERT INTO lwo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Maa abeehn nyoge me thoohdh uyiih gene lume. ");
INSERT INTO lwo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Noono e nyin me nyinge Laajoruj anaa abeehn ne twaany. Ngo anahg ngad geen Bathany. Bathany e naa geen beed Maarya ke Maartha nyemen. ");
INSERT INTO lwo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maarya ge anaa abeehn ne loar wiih Jeacuu ke mow kedea uwuunye tien ngo keehd yiehy wiihe. Anahg Laajoruj umiih gen e naa atwaany. ");
INSERT INTO lwo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Noono e ge nyemen lubo aoohr gene bang Jeacuu, kob gene, “Ruohdh gomi ge anhyaari ngo atwaany.” ");
INSERT INTO lwo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Naa alihng Jeacuue ngo e arobe kea, “Atwaany Laajoruj padh gihn me nahg en. Gihn ni ree atiihye beere wiih Juog ke moaro kedea e nuu unahg dhe yoohn ubeehn Juoge unyoadhe ka moare wiiha, a ge Ngad Boadh nyoge.” ");
INSERT INTO lwo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Maartha maa Maarya kedea Laajoruj umiih gen ge anhyaar Jeacuue keraahyo. ");
INSERT INTO lwo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Abea keehd maano, naa alihng Jeacuue lum atwaany Laajoruj e nihn ariow mooge ge adoge ke naah ce thube ke cidho. ");
INSERT INTO lwo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kaano e arobe yihr jo waahdhe kea, “Beehn dogo Judea.” ");
INSERT INTO lwo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Maa abeehr gene ngo yihre kob gene, “Ngad puohny! Wa yaa Judea ge adaahd ubahn gene yihn ke leele ka me cahng kan. Yih poohd daahd dog caahn bang gen ne?” ");
INSERT INTO lwo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Maa abeehr Jeacuue ngo yihr gen kobe, “Ngahda ngahyu kejea bad cahng acielo yea ne caae apaar wonge ariow me romo tiihj yihdh gen ne? Ngaa caahdh ke decahngo kare tooro ucwahnye ke leelo, bang gihn piny cang kedea giih nyepinye ge uneehno yihre. ");
INSERT INTO lwo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Abea nea ngaan ngo caahdh kii diehr waahr e kare nud ucwahnye bang gihn piny beehda muudho, gihn me meeny ngo tooro.” ");
INSERT INTO lwo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Giih ni ge arobe kedea ubare maalo ke rob yihr gen kobe, “Goma Laajoruj ngo aneno abea adaahd ucaa ne tahnge.” ");
INSERT INTO lwo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Maa abeehr jo waahdhe ngo yihre, “Ruohdh! Nea beehda niine e naa anene e atwaanye udoohng beer.” ");
INSERT INTO lwo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Abea Jeacuu anaa arubo kaa nying thon Laajoruj, abea jo waahdhe cuohn gene e ngo rubo kaa nying niin Pe'Dihmo now. ");
INSERT INTO lwo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Gihn nu e ngo abeehne ne robo yihr gen kejea, “Laajoruj beehde athow. ");
INSERT INTO lwo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Abea cwihnya med, ke nying gihn toora buude beere wu uyiiho. Kea noono aayo ucidho ne maanye.” ");
INSERT INTO lwo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Noono e Thoamaj (ge cuohn ne kuoy) ake rubo yihr goan jo waahdh Jeacuu kea, “Cidho thiow, beere wo uthoo keehde tiehd.” ");
INSERT INTO lwo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ge anaa awahnh Jeacuue ni e abeehne ne yoado kejea Laajoruj athow kedea yihre ne nihn angween naa akoanye. ");
INSERT INTO lwo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bathany anahg geew me be baahr ke Jeruucalem, ngo anahg kar meale ariow. ");
INSERT INTO lwo_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kedea yaa Judea me thoohdh ge anaa abeehn bang Maartha kedea Maarya nyemen bang ne ciihm cwihny gen ke nying thon umiih gen. ");
INSERT INTO lwo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kaa alihng Maarthae ngo kejea Jeacuu nii yooh ne beehno e a'aj maalo ucea ne lor ngo. Abea Maarya adoohng paajo. ");
INSERT INTO lwo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maa akoohb Maartha yihr Jeacuu kea, “Ruohdh nea yih ne naa kan e umiiha be ne thow. ");
INSERT INTO lwo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Abea ngo ngahya keehd awaahn ni kan e Juog gihn kwayi ngo cube cubo yihri.” ");
INSERT INTO lwo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Maa abeehr Jeacuue ngo yihre kea, “Umiihu ngo ucahr keehdo.” ");
INSERT INTO lwo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maa abeehr Maarthae ngo yihre kea, “Ngo ngahya kejea ucahr cahng ucahr nyoge yi gug piny.” ");
INSERT INTO lwo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Maa abeehr Jeacuue ngo yihre kea, “A naa ngaa meehg nyoge cahro kedea an ne cub kuowo yihr gen. Ngaa yiih luma e ngo udoohng ne ngaa me kuow keehd maa athowe ");
INSERT INTO lwo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nea ngaa me kuow maa ayiih luma e ngo be kuong thoo. Gihn ni ngo ayiih Maartha.” ");
INSERT INTO lwo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maa abeehr Maarthae ngo kea, “Ayiih Ruohdh. Ngo ayiiha kejea yih naa Ngad Boadh nyoge ge Waahd Juog ge arob naa ubeehn wiih piny kan.” ");
INSERT INTO lwo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Naa athum Maarthae ke rob e acidho ne cuohn Maarya nyemen oogo kiin nyoge. Maa amuonge yi yihdh ngo kea, “Ngad puohny abeehno kedea yih daahde daahdo.” ");
INSERT INTO lwo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Naa alihng Maarya lum nu, e ngo aguo yedh maalo ne ci bang ngo. ");
INSERT INTO lwo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Jeacuu apoohd ke kaa anaa ayoad Maarthae ngo yea, e poohd kuu awahnh yihdh miehr). ");
INSERT INTO lwo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kaano e yaa Judea giih anaa wod ne ciihm cwihny Maarya ge athubo ke buodh batiene naa aniid gene ngo e a'aj maalo ke laahdo ne ci oogo, cuohn gene kejea ngo caa wiih liel ne lalo. ");
INSERT INTO lwo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Naa awahnh Maaryae kaa anahg Jeacuue yea ni kedea naa aniide Jeacuu, e ree ariedhe piny upahdhe thaahdh tien Jeacuu kedea urube kea, “Ruohdh nea yih ne naa kan e umiiha be ne thow.” ");
INSERT INTO lwo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Naa aniid Jeacuue Maarya maa yaa Judea giih abeehno keehde e ge uyuog e cwihnye ake rahnyo kedea uyuog aduune keraahyo. ");
INSERT INTO lwo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Maa apeehy Jeacuue kea, “Kuohme akanu kee?” Maa abeehr gene ngo kejea, “Ruohdh beehn ni uniidi kaa ngo.” ");
INSERT INTO lwo_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kaano e Jeacuu piih wonge ake wojo. ");
INSERT INTO lwo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Maa arub yaa Judea kob gene, “Maahnyu kaa anhyaare ngo kii ngo.” ");
INSERT INTO lwo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Abea nyoge mooge kiin gen kob gene, “Wong ngaa maa acoor ayabe, kare anud yihre ubahnge Laajoruj be ne thoo.” ");
INSERT INTO lwo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jeacuu yea acahg ngeero keehdo ge wahnhe wiih loohro kaa akan kuohm Laajoruj yea. Ngo anahg buur me beehda roony kedea dhee ciehg kaa leelo. ");
INSERT INTO lwo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Maa akoohb Jeacuu kea, “Looru leelo oogo dhe liel.” Maa akoohb Maarthae nyemiih ngaa athow kea, “Ruohdh kuohm dhaano anahg nihn angween yi buur, awaahn ngo ungwaahyo.” ");
INSERT INTO lwo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Maa ataahny Jeacuue rih Maartha kea, “Kaa anaa robo yihri ne kejea nea yih yiiho e kaa amoar wiih Juog kii ngo niidi niido?” ");
INSERT INTO lwo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Maa akahl gene leelo oogo dhe buur. Noono ubeehn Jeacuue umaahnye maalo maa arube kea, “Abaa Wura koohri amuoja bang gihn alihngi luma. ");
INSERT INTO lwo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ngo ngahya kejea luuba ge beehde e ge yiihi yiiho kedea ngo roba kaa nying yaa ni cuung kan bang ungahy gene ngo kejea yih naa aoohr an.” ");
INSERT INTO lwo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ge athume keehd rob e ake cuohdo e duone ne maalo kea, “Laajoruj beehn oogo.” ");
INSERT INTO lwo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Maa abeehne oogo e cinge kedea tiene poohd e ge atuohj ke waaro kedea e wonge abahj ke waaro. Maa arob Jeacuue ngo yihr gen kea, “Kahlu waay thoo oogo yi kuohme umeehgu ngo ci paajo.” ");
INSERT INTO lwo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Noono e amahr yaa Judea giih anaa abeehno keehd Maarya kedea naa aniid gene gihn atiihye, e lum Jeacuu ayiih gene. ");
INSERT INTO lwo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Abea nyoge mooge kiin gen ge abeehn ne ci bang Paarijea urob gene kwaad gihn atiihy Jeacuue ge aniid gene ni. ");
INSERT INTO lwo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Maa abeehn jo doong yaa lam kedea Paarijea ucuohn gene amaad gihr Akuud Judea; noono upiih gene ne peehny rog gen, “Maahnyu ka beehn nyine utiihye giih me gaahy nyoge me thoohdh! ");
INSERT INTO lwo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nea ngo meehgo ke bar maalo ke yug giih ni, e amahr nyoge giih puohnye ge beehn gene ke ne yiiho noono e apahne giih Roama kar kwaj gihro beehn gene ke ne kaabo kedea utoar gene ngo piny.” ");
INSERT INTO lwo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Noono e dhaano acielo kiin gen me nyinge Kaaypaj ge anahg ngaa duohng yaa lam yi wong nu ake rubo kea, “Wu nyoge me gihn me ngahyu tooro. ");
INSERT INTO lwo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ngo kwihyu kejea ngo beer ubeehn dhaano acielo uthowe ke nying nyoge cang yi man beehn paajo ke kare cang uthowe.” ");
INSERT INTO lwo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Gihn ni arobe padh lubo me en naa apar ngo ke robo. Abea bang gihn anahg en naa ruohdh duohng yaa lam yi wong nu, e naa ameehg Juoge ngo rob gihn utiihy ree rih Jeacuu: ge uthowe ke nying tien paar yaa Judea. ");
INSERT INTO lwo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kedea padh ke nying tien paar Judea keede e nuu uthowe abea beehda ke nying nyethen Juog ge akeedho ke bang wiih piny cang beere ge kahle ke ka maa acielo kedea umade yihdh gen. ");
INSERT INTO lwo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ke wong cahng nu, e ge athubo ke gweehg dhe yooh me dhiil gene Jeacuu ke naah. ");
INSERT INTO lwo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Noono e Jeacuu kuu acahg waahdh naa arwaadh ke kiin yaa Judea. Ngo abeehn ne dag paajo me cahng ke dhe ukang. Kaa adag gene ne beehdo yi ngo keehd jo waahdhe anahg geen Eparem. ");
INSERT INTO lwo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ge anaa adoohng Yaan Amono cahng ni, e nyoge me thoohdh ge athubo ke ci yi geen Jeruucalem ne yug giih kweehr ne koar cahng yaay. ");
INSERT INTO lwo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Noono e nyoge ge athubo ke cej ka ne Jeacuue yea kaa anaa acuung gene yi laaro gihr Wod Juog kedea e ge upeehyo ke rog gen kob gene, “Ne ngaa me ngahy ngo kejea Jeacuu ubeehn kar Yaan Amono?” ");
INSERT INTO lwo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Abea ka jo doong yaa lam maa Paarijea amor acub gene kob gene nea ngaa ngahy ka ne Jeacuu yea e kea robe ngo beere ngo mag gene mago. ");
INSERT INTO lwo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jeacuu awahnh geen Bathany maano e adoohng nihn abiihjbeciel unahge cahng Yaan Amono. Laajoruj ngaa anaa atahng Jeacuue ucahre yi thoo ngo abeed Bathany. ");
INSERT INTO lwo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Cam anaa agwiir Maarthae yihre paar ge Laajoruj. Maartha e naa anaa apiih buud gen kaano acahm gene cahmo. Laajoruj anaa apiih tiehd ke gen ne cam. ");
INSERT INTO lwo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maa abeehn Maarya ukaabe udhoohmo me yea ne mow me ngwaahy me ngiene teeg keter uwiihre tien Jeacuu kedea uwuunye tien ngo keehd yiehj wiihe. Maa abeehn mowe upaahnge yea wod ke ngwahje. ");
INSERT INTO lwo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Maa akoohb Juudo Yijkaariod ngad waahdh Jeacuu, ge e nuu ubeehn ne luom ngo kea, ");
INSERT INTO lwo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Gihn ge bahnge mown ni be ne ngeew oogo beere amahr ngiihny me thoohdh ge yoad ge ke paahngo yihr nyoge maa angoohng? Ngiihny ne yoad ge ne nahg kar koog gihr dhaano yi wong acielo.” ");
INSERT INTO lwo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Gihn nu kea robo kaa nying gihn anhyaare nyoge maa angoohng, abea ngo anahg ngad kahw me na ukahbo rog ngiihny na cub yihre ne maa. Anahg en ne mag ngiihny yoad yaa waahdh Jeacuue bang nyoge. ");
INSERT INTO lwo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Maa abeehr Jeacuue lume kobe, “Wiiu dhaahr ni utiihye gihre ne tiihye. Keá ngaa gied ngo! Ngo beehda gihn maa agwiir ke coon kejea mown ngo akan kaa nying cahng thona. ");
INSERT INTO lwo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yaa angoohng ge beehdo e ge nud ke wun ke cahng cahngo. Abea a buu kwaay nudo ke wun.” ");
INSERT INTO lwo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Naa alihng amahr yaa Judea ngo kejea Jeacuu ngo ne Bathany, e ge acidho ne maany Laajoruj ge atahng Jeacuue maalo yi thoo kedea ge acidh thiow ne maany Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Noono e jo doong yaa lam ge athubo ke daahd dhe yooh me nahg gene Laajoruj kedea Jeacuu thiow. ");
INSERT INTO lwo_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ge adaahd unahg gene Laajoruj bang gihn beehda ke nyinge e naa abeehn yaa Judea me thoohdh udoohng gene ne yaa Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ruuwow e amahr akuud yaa Judea ge anaa abeehn yi yaay, ngo alihng gene kejea Jeacuu ngo nii yooh ne beehn Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Maa atoohng gene ageehbe kedea ucidh gene ne lore e ge ukwaago kob gene, “Wuoro Juog. Dooj Juoge ngade ge abeehno ke yoohn Paar Maalo. Juog dooj ruohdh yaa Yijarael.” ");
INSERT INTO lwo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Maa abeehn Jeacuue uyoade akaja maa apaahre wiih ngo wa kwaad kaa anaa agweede yi kitaab Juog, ");
INSERT INTO lwo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Wu keá tudo, wu yaa Jeruucalem, maanyu ruohdh ne ca beehn nu e ne wiih akaja me poohd thiin.” ");
INSERT INTO lwo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Giih nu ayug rog gen yihdh gen kuu anaa aguo jo waahdhe ke deado kejea ge beehda giih maa agweed yi kitaab Juog ke nying Jeacuu. Abea batien kaa acahre ke dhe yooh me gaahy nyoge e naa angey gene ngo kejea giih maa agweed ke nying Jeacuu ge aniid gene e rog gen tiihy gene tiihyo. ");
INSERT INTO lwo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Amahr yaa anudo keehd Jeacuu ge anaa atahnge Laajoruj yi thoo gihn atiihy ree anaa abeehn gene ne nyaay piny yihr nyoge. ");
INSERT INTO lwo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","E naa gihn ameehg amahr nyoge beehn ne lor Jeacuu ke nying gihn teeg e anaa ayuge ni. ");
INSERT INTO lwo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Maa arub Paarijea ke rog gen kob gene, “Gihn me romo ke yugo tooro ne weey weey. Niidu kaa abuodh amahr nyoge me thoohdhe batiene!” ");
INSERT INTO lwo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Anudo ke yaa Griihg maa anaa kiin yaa anaa acidho yi yaay ne wuor Juog. ");
INSERT INTO lwo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Noono e ge abeehn bang Pihlihb. (Pihlihb anahg ngad Bedhceada ge beehda geen Gaalili). Gihn nu e ge arubo yihre kob gene, “Ruohdh! Wa daahd ucidh wane bang Jeacuu.” ");
INSERT INTO lwo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Maa abeehn Pihlihbe urobe lum nu yihr Andrya kedea uaay gene tiehd ucidh gene ne rob gihn ateed yaa Griihge yihr Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Abea ngo abeehr Jeacuue yihr gen kea, “Cahng ngo abeehno ge ubeehnu wu yaa padh Judea uromu doohng ne nyoge maa ayiih Juoge ne yaae thiow. Gihn nu ree uyuge ge ubeehn Juoge umeehge tee gihre niido ke dhe yoohn gihn utiihy ree riha. ");
INSERT INTO lwo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A rob gihn maa athiir yihru. Nea a athow e nyoge me thoohdh Juog beehn gene ke ne ngahyo. Thona uroomo ke wong beehlo nea ke piidho e ngo kuong thoo batiene e ngo utuuyo kedea uciege. ");
INSERT INTO lwo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kwaad ngaa yug gihn nhyaare cog kedea ukoare gihn me pahdh wiihe, e ngaan nu kuowo me guge tooro be yoade. Abea kwaad ngaa nhyaar buodh batiena keehd me padh ngaan ngo Ujudea kedea ubeehn nyoge cang umahd gene rih ngo, e yihre unaa kuowo me be gug. ");
INSERT INTO lwo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kwaad ngaan tiihy yihra dhiile batiena ke buodho beere ngo caa ka nuda yea. Kaano e nuu ubeehn Wura umoare wiih ngaa tiihy yihra keehd me padhe Ujudea. ");
INSERT INTO lwo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Awaahn ni cwihnya urahmo, abea roba gihn? Koohba kaa, ‘Abaa Wura kuohma keá meehg raahm wa ka ngahya raahm gihn uyoada ni?’ Abea utiihya ke ne diih keehdo abea anahg ke nying raahm ngo e naa abeehna wiih piny! ");
INSERT INTO lwo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Abaa Wura nyoadh teegi yihr nyoge wiih piny kan.” Kaano e duol ake lihngo ke yoohn Paar Maalo kobe, “Tee ngo beehde e ngo anyoadha kedea ngo udoga ke nyoadho keehdo.” ");
INSERT INTO lwo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Akuud nyoge giih anudo kaano duol alihng gene ke yoohn Maalo maa akoohb nyoge mooge kejea, “Kodh e naa amaahr.” Abea nyoge mooge kob gene, “Beehda wuohnjuog e naa arubo keehde.” ");
INSERT INTO lwo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Maa abeehr Jeacuue ngo yihr gen kea, “Duol gihn nu ngo kuu arubo kaa nying kony an, abea arubo kaa nying kony wun. ");
INSERT INTO lwo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Awaahn ni e ne beehn Juoge ukihme yaa wiih piny kedea Juog ngad atiihb ukeehg, ge raany wiih ngoom ngo urieme oogo wiih koom. ");
INSERT INTO lwo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Abea cahng ugur an wiih yaadh maa ariihw ne naah, e nyoge ge umeehga beehn banga.” ");
INSERT INTO lwo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Gihn nu arob Jeacuue ne nyoadh dhe yoohn ka unahge kii ngo). ");
INSERT INTO lwo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Noono e ngo abeehr nyoge yihre kob gene, “Wa arob loohng Moaje kejea Kriihjto ubeehdo e ngo be thow. Gihn ge rubi kobi, ‘Ngaa adoohng ne dhaano utaahngo ngo uthow utihnge maalo.’ Beehda ngaa e naa adoohng ne dhaano utaahngo?” ");
INSERT INTO lwo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Noono e ngo arob Jeacuue yihr gen kea, “Daahr meeny piny ngo poohd ubeehdo ke wun ka me thiin mee. Baru maalo ke waahdhu ka poohde daahr nud ke wun beere muudho wu be moale piny. Bang gihn ngaa caahdh kii yi muudho ka cea yea ngo kwihye. ");
INSERT INTO lwo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yiihu luma a ngaa cub daahr yihr nyoge maano e ngo poohd nud ke wun, beere wu udoohng ne nyethen ngaa cub daahr yihr nyoge.” Ge athume ke rob luube giih nu e Jeacuu a'aay ucea ne pahno ka me be yoad ree yihr gen. ");
INSERT INTO lwo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Keehd maano abeehn Jeacuue uyuge amahr giih me thoohdh me gaahy nyoge nyum gen, e poohd e ge ukweer ke lume. ");
INSERT INTO lwo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Giih nu cang rog ge ayug gene beere luube giih agamloohngjuog ge cuohn ne Yicaaya ge dhiil pahdh kar gen naa athere wa kwaad kaa agweede naa, “Juog, bekihd ngaa maa anaa alihng giih arob wane kedea utoor dhaano maa adead giih tee ge atiihy Juoge.” ");
INSERT INTO lwo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ge kuu ayiiho bang gihn arob Yicaaye thiow kea, ");
INSERT INTO lwo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kob Juoge kea, ‘Bang gihn wudh gen aciehg gene ukweer gene ke yiiho, udoohng wa an naa aciehg wudh gen utoor ka maa angey gene yi luma. Ge naa arom ke thiehdho nea wudh gen be ne ciehg gene.’ ” ");
INSERT INTO lwo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Giih ni ge arob Yicaaye bang gihn kaa amoar wiih Jeacuu kii ngo anyoadh yihre yi laahg e naa gihn arube ke nying ngo. ");
INSERT INTO lwo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Abea keehd maano, e Judea me thoohdh maa ruohdh paajo lum Jeacuu ayiih gene. Abea ke nying Paarijea e ge atud ke nyoadh rog gen bang gihn ge beehn gene ke ne riem oogo yi wod amaad. ");
INSERT INTO lwo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bang gihn Judea giih nu, nea yihr gen e leej gihn ayoad gene bang nyoge e ne wiihe ne maalo yihr man yoad gene bang Juog. ");
INSERT INTO lwo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kaano e Jeacuu lubo angweele piny ke duol me teeg kobe, “Kwaad ngaa ayiih luma, kuu ayiih lum mara ke nguda abea beehda lum ngaa aoohr an e naa ayiihe. ");
INSERT INTO lwo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kwaad ngaa alog cwihnye ne maany an, e ngaa aoohr an e naa ayiihe. ");
INSERT INTO lwo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","A beehda daahr gihn abeehn ne meeny wiih piny kedea kwaad ngaa ayiih luma be cahg beehdo yi muudho keehdo. ");
INSERT INTO lwo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Abea ngaa alihng luma kedea akweer ke wuor ngo, e ngo be kihma. A abeehn wiih piny kan ne boadh nyoge. A kuu abeehn ne kihm nyoge. ");
INSERT INTO lwo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kwaad ngaa kweer ke lihng luma kedea luma be yiihe nud ke gihn muu ukihm en. Gihn ukihm en beehda luuba ge ateeda ni ge nuu ukihm en yi cahng gug piny. ");
INSERT INTO lwo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bang gihn, luub roba ge padh luuba abea Wura e aoohr an ni e naa acub tee yihra kedea uteede ngo yihra kejea roba gihn teeda. ");
INSERT INTO lwo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ngo ngahya kejea tee gihn cube yihra ni e naa dhe yoohn boadh wahy me be gug. Neehn maano kwaad gihn roba e naa gihn arob Wura yihra.” ");
INSERT INTO lwo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ke wong thiehno, ge ruuwow e naa cahng Yaan Amono, e ngo angahy Jeacuue kejea cahng aaye oogo wiih piny ne dog bang wahn ngo awahnho. Nhyaahro gihre anyoadhe yihr jo waahdhe ke yoohn thone ge ugure ngahy yaadh maa ariihw. ");
INSERT INTO lwo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","3","Kaano anaa apiih Jeacuue maa jo waahdhe ne cam ke thiehno e atiihb ukeehg lubo arobe coon yihr Juudo Yijkaariod waahd Cimoane kejea dewaahy nu e nu uluome Jeacuu. Ngo beehde e ngo ngahy Jeacuue kejea tee acub Juoge yihre ne yug kwaad giih nyepinye cang kedea ngo ngahye kejea e abeehno ke yoohn bang Juog kedea udo bang Juog. ");
INSERT INTO lwo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Noono e Jeacuu a'aj maalo kedea uthube ke kahl waahny athoohr gihn anaa ree oogo kedea uriiwe waaro moogo yi badhe. ");
INSERT INTO lwo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ke batien gihn nu e Jeacuu athubo ke woj piih yi wal noono maa athube ke luog tien jo waahdhe kedea uwuunye tien gen keehd waaro gihn anaa ariiwe yi badhe ni. ");
INSERT INTO lwo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Naa awahnh Jeacuue bang Cimoane Piihter, e Piihter arubo yihre kea, “Ruohdh! Tiena romi kaa luogo ne!” ");
INSERT INTO lwo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Maa abeehr Jeacuue ngo yihre kea, “Gihn ni tiihya awaahn ni be ngey ree yihru abea ngo ungahyu cahng moogo.” ");
INSERT INTO lwo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Maa abeehr Piihtere ngo yihre kea, “Bekihde! Tiena be kuongi ke luogo ne weey weey!” Maa acahg Jeacuue ngo ke beehro kea, “Nea tieni be luoga luogo e yihri utoor gihn me nweehd an ke yihn.” ");
INSERT INTO lwo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Maa arub Piihtere yihre kea, “Nea wa maano ruohdh e padh tiena cog ge ne luog abea luog cinga kedea wiiha cang.” ");
INSERT INTO lwo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Maa akob Jeacuue ngo yihre, “Kwaad dhaano maa aluog beehda tiene cog ge ne dihd, udoge gen ke luogo. Wu cang, wu aluog udoohngu ne nyoge me nyooro tooro rogu abea dhaano acielo kiinu e ne ree ne nyooro.” ");
INSERT INTO lwo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ngo beehde e ngo ngahy Jeacuue e ngaan uluom en. E naa lum yea gihn akoohbe kea, “Dhaano acielo kiinu e ne ree ne nyooro.” ");
INSERT INTO lwo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Naa athume ke luog tien gen e waahny athoohr gihre angaabe kedea udoge kare ne piih. Maa apeehnye gen kea, “Gihn ayuga rogu ni yea angeyu ne? ");
INSERT INTO lwo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","A cuohnu cuohno ne ngad puohny kedea ne ruohdh. Beehda gihn maa kare ucuohnu an ne ngad puohny kedea ne ruohdh bang gihn a ngad puohny gihru kedea ruohdhu adiehr muon. ");
INSERT INTO lwo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Me neehn kaan ni aluoga tienu abea a beehda ruohdhu kedea ngad puohny gihru kea noono beehn dhaane kiinu luoge tien wad gen. ");
INSERT INTO lwo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Luog tiel anyoadha yihru beere gihn atiihya yugu yugo wa kaano anyoadha ngo yihru. ");
INSERT INTO lwo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Athiir e ne roba yihru. Baahng aweehne e ne wiihe ne maalo rih ngaa nahge baahng paare? Wale ngaa e ne wiihe ne maalo, ngaan aoohr wale ngaa aoohr ngo? ");
INSERT INTO lwo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Awaahn ni adiehj yihdh luub ni ge angeyu. Kea noono tiihyu ke gen beere cwihnyu umihno. ");
INSERT INTO lwo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“A be rubo kaa nyingu cang bang gihn yaa anaa akwanya ge ngahya. Abea gihn agweed yi kitaab Juog ngo dhiil pahdh kare ne rihb wa kaa agweede naa, ‘Ngaa anywaag wane amono keehde, e naa adoohng ne ngad mahna.’ ");
INSERT INTO lwo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Gihn ni ateeda yihru maano e gihn ngo ree poohd keá tiihyo beere nea ree tiihye tiihyo, e ngo uyiihu kejea beehda an e Juog ke nguda, a naa Ngad Boadh nyoge. ");
INSERT INTO lwo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Athiir e ne roba yihru. Ngaan ayiih lum ngaa aoohr an e ngo ayiih luma kedea ngaa ayiih luma ayiih lum ngaa aoohr an.” ");
INSERT INTO lwo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Batiene naa athume ke rob gihn ni e aduune ake ngoan maa arube oogo kea, “Athiir e ne roba yihru, dhaano acielo kiinu a uluome.” ");
INSERT INTO lwo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kaano e jo waahdhe ge agaahy maa athub gene ke maahnyo ke kiin gen ke ngaan robe. ");
INSERT INTO lwo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ngaan nhyaar Jeacuue kiin jo waahdhe anaa apiih buud Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Gihn nu e ngo amun Cimoane Piihtere maa ateede ngo yihre kejea peehnye ngaa kiin gen e ne rub Jeacuue ke nyinge. ");
INSERT INTO lwo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Maa aloge wiih bang Jeacuu maa apeehye kea, “Ruohdh beehda ngaa?” ");
INSERT INTO lwo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Maa abeehr Jeacuue ngo kea, “Beehda ngaan cuba amono gihn cwinya ke kado yihre.” Noono maa acwinye amono ke kado kedea ucube ngo yihr Juudo waahd Cimoane. ");
INSERT INTO lwo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nye wong kaano akaab Juude amono yi cinge nu, e kuohm Juudo abeehn atiihb ukeehg ne yaahngo cang. Maa arub Jeacuue yihr ngo kea, “Gihn daahdi laar ngo ke tiihyo piow piow.” ");
INSERT INTO lwo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yaa anaa anudo wiih cam gihn arub Jeacuue yihre wa gihn nu ngo kuu angey gene. ");
INSERT INTO lwo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Mar gen cuohn gene kejea ngo caa ne cub ngiihny yihr nyoge maa angoohng bang gihn nahge en naa ngad mag ngiihny. ");
INSERT INTO lwo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Maa akaab Juudoe amono gihn acwiny kedea e naa waahdhe noono. Kaano piny anaa adoohng ne dewaahr. ");
INSERT INTO lwo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Batien kaa a'aay Juudo e Jeacuu arubo kea, “Awaahn ni, a ge adoohng ne dhaano utaahngo wiiha amoar kedea wiih Juog amoar thiow ke nyinga ");
INSERT INTO lwo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","kedea Juog wiiha umoare ka me cahng kan. ");
INSERT INTO lwo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Wu jo waahdha, a ubeehdo ke wun ke nihn me noog mee. Kara udaahdu. Abea roba robo yihru wa kaa anaa aroba ngo yihr yaa Judea. Ka caa yea wu be cidh yea. ");
INSERT INTO lwo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Loohng me nyaahn e man cuba yihru: wa kwaad kaa anhyaara wun, kea dhiilu rogu ke nhyaaro naa acielo acielo. ");
INSERT INTO lwo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nea nhyaahro nud kiin nu, e nyoge cang ngo dhiil gene kaa ngeyo kejea wu beehda jo batiena.” ");
INSERT INTO lwo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Maa apeehy Cimoane ge cuohn ne Piihter kea, “Ruohdh yih caa kee?” Maa abeehr Jeacuue ngo kea, “Ka caa yea wu be rom ci yea awaahn ni. Unahg cahng moogo e nuu ubuodhu batiena.” ");
INSERT INTO lwo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Maa apeehy Piihtere kea, “Ruohdh gihn e bahng e batieni be roma ke buodho awaahn ni. Ke nyingi, riha cuba kii thoo.” ");
INSERT INTO lwo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Maa abeehr Jeacuue ngo kea, “Kare tooro yihri uthowi ke nyinga. Gihn maa athiir e ne roba yihri. Maano e uthuonjieno poohd kuu akoohg, e yih upeehmo tiel adahg kejea a kwihyi.” ");
INSERT INTO lwo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Maa akoohb Jeacuue kea, “Wu keá diero. Yiihu lum Juog kedea yiihu luma thiow. ");
INSERT INTO lwo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Paar Wura yea ne wuude me thoohdh kedea a caa ne gwiir kuohn beehdo giihu. Nea ngo be ne naa wa gihn nu, e gihn be naa arobo yihru. ");
INSERT INTO lwo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Abea ge aaya ne cidh ne gwiir kuohn nu, e a uduu bangu ne kaab wun beere wu kedha ke ka beeda. ");
INSERT INTO lwo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kun caa yea yoohn ngo ngahyu.” ");
INSERT INTO lwo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Maa arub Thoamaje yihre kea, “Ruohdh ka ci yea kwihy wane: dhe yoohn cidh bangi ungahy wane ke ne diih?” ");
INSERT INTO lwo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Maa abeehr Jeacuue ngo kea, “A naa yooh a naa gihn maa athiir maa a naa kuowo. Ngaa me rom wahdh bang Wura tooro nea ngo be kahnh kaa banga. ");
INSERT INTO lwo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nea a nuu ngahyu ne cohg e a beehda ngaa, e Wura nuu ngahyo thiow. Kedea me neehn bad cahng tihn ge ngahyu an ne cohg, e Wura ngo ngahyu thiow.” ");
INSERT INTO lwo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Maa akoohb Pihlihbe kea, “Ruohdh meehg wan niid Wuru ke nying wan utoor gihn mooge me daahd wane.” ");
INSERT INTO lwo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Maa abeehr Jeacuue ngo kea, “A dhiilu kaa ngahyo bang gihn a abeehdo ke wun ke ka me laaj. Ngaa aniid an e Wura aniide! Gihn ge dogi rob kejea, ‘Nyoadh Wuru yihr wan?’ ");
INSERT INTO lwo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ngo be yiihi kejea a beehda anweehd ke Wura kedea Wura beehda anweehd ke an ne? Luube giih ni teeda yihru ni ge padh luub muua keeda. Abea ngo beehda Wura ge anweehd keehd an e ne tiihyo. ");
INSERT INTO lwo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Dhiilu luma ke yiiho nea a urubo yihru kejea Wura anweehd keehd an kedea a anweehd keehd Wura. Nea maano be yiihu kea yiihu ke nying giih gaahy nyoge ge niidu e ge tiihya tiihyo. ");
INSERT INTO lwo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Gihn ni roba yihru beehda athiir: kwaad ngaa ayiih luma utiihyo ke kwaad giih me neehn giih teeg ge tiihya ni. Giih me teeg me yoohm wudh muu atiihya ge rome kaa tiihyo, bang gihn a ado bang Wura. ");
INSERT INTO lwo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kedea gihn peehnyu ke nyinga ngo tiihya tiihyo yihru bang umeehga nyoge niid ka teeg Wura kii ngo. ");
INSERT INTO lwo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nea wu apeehyo yihra ke kwaad nyepiny ke nying gihn nahgu yaa batiena ni, e ngo dhiila kaa yugo yihru. ");
INSERT INTO lwo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nea a anhyaaru, kea yiihu luma. ");
INSERT INTO lwo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Noono e a urubo ke Wura beere Wahy Juog e ucwag wun oohre oohro yihru. ");
INSERT INTO lwo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ngaan uoohre ne beehda keehd wun beehda Wahy Juog ge nyoadh gihn maa athiir. Ngad cwaahg, yaa reje wiih piny ge ukweer keehde bang gihn ngo be neehn yihr gen kedea ngo kwihy gene. Abea ke kur maru ngo ngahyu ke nying gihn ngo beehd kaa wun. ");
INSERT INTO lwo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Wu buu uwiia piny wa mar kiihye. A uduu bangu. ");
INSERT INTO lwo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Adoohng kaa me thiin ubahnge a buu ucahg yaa wiih pinye ke niido keehdo. Abea ke kur maru a uke neehn yihru bang gihn a ucahr, e wu ucahr thiow. ");
INSERT INTO lwo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Cahng ucahra, e naa ka ungahyu ngo kejea a beehda anweehd keehd Wura kedea wu anweehd keehd an kedea a beehda anweehd ke wun. ");
INSERT INTO lwo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kwaad ngaa tiihy loohnge giiha e roba yihre ni, e naa ngaa nhyaar an noono. Kedea kwaad ngaa nhyaar an ngo nhyaar Wura nhyaaro kedea ngo nhyaara nhyaaro maa riha nyoadha nyoadho yihre thiow.” ");
INSERT INTO lwo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Maa akoohb Juudo (Padh Juudo Yijkaariod) kea, “Ruohdh gihn ge nahge ke yihr wan cog e ne daahdi rihi ke nyoadho abea padh yihr yaa wiih piny cang?” ");
INSERT INTO lwo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Maa abeehr Jeacuue ngo yihre kea, “Ngaa nhyaar an e luube giiha ge umage yi wiihe kedea ngo unhyaar Wura kedea Wura maa an wa ubeehn ne beehd keehde. ");
INSERT INTO lwo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yaa be nhyaar an luube giiha ge buu umag gene. Kedea luube giih roba ge padh luube me aay ke banga. Ge beehda luub ngaan aoohr an. ");
INSERT INTO lwo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Giih ni cang ge aroba maano e a poohd ubeehdo ke wun. ");
INSERT INTO lwo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Abea ngad cwaahg ge nyinge cuohn ne Wahy Juog ni, ge uoohr Wura, wu upuohnye ke giih nyepinye cang kedea umeehge wun par giih anaa arob yihru cang. ");
INSERT INTO lwo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yoohm rog awiia piny yihru kedea yoohm rog gihra ngo acuba yihru. Ngo kaa acubo yihru wa mar yaa wiih piny kan, wu keá diero kedea wu keá tud. ");
INSERT INTO lwo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“A alihngu e a urubo kaa, ‘A uaay kedea a uduu bangu.’ Nea a nuu nhyaaro, e cwihnyu ne mihno bang gihn a caa bang Wura kedea Wura e ne duohng riha. ");
INSERT INTO lwo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ngo aroba yihru awaahn ni maan e Wahy Juog poohd kuu abeehno beere cahng yuge ree, e gihn aroba ngo uyiihu kejea ngo athiir. ");
INSERT INTO lwo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","A be cahg rob ke wun keehdo bang gihn ruohdh yaa wiih piny ngo abeehno. Abea keehd me beehne, e a be rom leehw yihre. ");
INSERT INTO lwo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Abea yaa wiih piny dhiil gene ngo ke ngahyo kejea Wura ngo nhyaara nhyaaro kedea e naa gihn tiihya nyepinye wa kwaad kaa arobe yihra. “Beeh aayo oogo kan. ");
INSERT INTO lwo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“A uroomo ke yaadh me cuung yea ajeniino, yaadh me wiihe be toohr ke nyethen kedea Wura e naa ngad ajeniino. ");
INSERT INTO lwo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Bad yaadh me nyethen toor wiihe ngole ke oogo abea bad me wiihe ne nyethen ngo gwiire gwiiro beere unyuol ke nyethen me thoohdh. ");
INSERT INTO lwo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Abea ke kur maru, wu kwel, rogu toor adhemuohm bang gihn wu aluog luube giih aroba yihru. ");
INSERT INTO lwo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Madu rogu banga beere riha mada ke bangu. Bad yaadh keede be rom nyuol ke nyethen nea ngo tooro rih yaadh. Keehd wun thiow gihn me romu ke tiihy wu keedu tooro nea wu be mahd banga unahgo anweehd. ");
INSERT INTO lwo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“A ne room ke yaadh kedea wu neehn baahde. Ngaa beehdo naa anweehd tiehd ke an kedea ubeehda naa anweehd tiehd keehde, e naa ngaa me beer wa mar yaadh me nyuol. Ngaa padh anweehd tiehd ke an gihn me rome ke yoado tooro. ");
INSERT INTO lwo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nea ngaa padh anweehd ke an, e ngo uroomo ke bad yaadh maa angol oogo utale. Baahd yen giih ngol oogo ge ne cong uthoohr gen yi maaj ne waang. ");
INSERT INTO lwo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nea wu ubeehdo tiehd ke an umagu wudh luube giiha, e kwaad gihn kwayu ke nyinga ucub Wura yihru. ");
INSERT INTO lwo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kea beehnu udoohngu ne nyoge me beeye wa mar yaadh me nyuol kedea unyoadu ngo ke dhe yoohn nu kejea wu jo'a. Gihn nu thiow beehda nyuudho e naa anyoadhu beey Juog. ");
INSERT INTO lwo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Wa kwaad ka nhyaar Wura an ni, e naa kaa anhyaara wun thiow. Beehdu naa anweehd tiehd ke an beere wu nhyaara nhyaaro. ");
INSERT INTO lwo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nea loohnge giiha ge amagu beer mee, e wu nhyaara nhyaaro wa kwaad ka nhyaar Wura an bang gihn loohnge giihe ge maga mago. ");
INSERT INTO lwo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Giih ni ge aroba yihru, beere kwaad mihn cwihny gihn ne yihra ni ngo yoadu yoado kedea utoor gihn me daag yi mihn cwihny gihru. ");
INSERT INTO lwo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Gihn ni e naa loohng aroba yihru: nhyaaru rogu wa kwaad ka nhyaara wun. ");
INSERT INTO lwo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kwaad nhyaaro gihn nu room kaa nhyaaro gihr ngaa maa acub wahye yi thoo ke nying gome. ");
INSERT INTO lwo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Wu beehda goma nea gihn teeda yihru yugu yugo. ");
INSERT INTO lwo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Wu be cahga ke cuohno ne baahng giiha keehdo, bang gihn baahng me ngahy gihn nii cwihny ruohdhe tooro. Abea wu cuohna e wu goma kaa nying gihn, giih arob Wura yihra ge ateeda yihru cang ungahyu gen. ");
INSERT INTO lwo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Padh wun naa akwany an, abea a naa akwany wun beere gihn me beer tiihyu tiihyo wa mar yaadh me nyuol me wiihe be toohr ke nyethen. Ke nying tiihyu noono, e gihn kwayu yihr Wura ke nyinga ngo ucube yihru. ");
INSERT INTO lwo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Loohng gihra ne roba yihru e man: Nhyaaru rogu. ");
INSERT INTO lwo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nea yaa wiih piny wu maan gene maano kea dhiilu ngo ke ngahyo kejea a naa ngaa akuong gene ke maano umodho. ");
INSERT INTO lwo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nea giih yug yaa wiih pinye ge nuu ke tiihyo e wu ne nhyaar gene kedea wu ne nahg yaa gen. Abea awaahn ni wu be tiihy giih tiihy yaa wiih pinye ke nying gihn nu e wu amaan gene bang gihn nahgu jo'a maa akwanya. ");
INSERT INTO lwo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Paru wudhu rog luub anaa ateeda yihru: ne ngad tiihj me wiihe ne maalo rih ngaan tiihye yihre ne? A utaab yi cing gen wa kwaad ka agweede kedea wu utaab thiow yi cing gen. Nea giih apuohnya yihr gen ge ne mag gene e kare ne nudo yihr gen umag gene giih upuohnyu. ");
INSERT INTO lwo_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Giih nu ge utiihy gene rogu ke nying gihn nahgu yaa batiena kedea Juog, ngaa aoohr an ngo kwihy gene. ");
INSERT INTO lwo_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nea a be ne beehno kedea uruba keehd gen, e adhemuohm me ne naa rog gen ne tooro. Abea awaahn ge aruba keehd gen ni, gihn me kony gen tooro ke nying adhemuohme giih gen. ");
INSERT INTO lwo_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ngaa amaan an, e kea ngahye ngo kejea Wura ge aoohr an ngo amaane thiow. ");
INSERT INTO lwo_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nea giih me teeg me gaahy nyoge ge be naa yugo kiin gen, e adhemuohme me ne naa rog gen ne tooro. Keehd maano aniid gene giih gaahy nyoge ge atiihya e Wura maa an wa poohd maan gene maano. ");
INSERT INTO lwo_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Abea gihn ni ngo beehda bang ubeehn gihn anaa agweed yi kitaab Juog giih gen upahdhe kare. Anaa agweed naa, ‘A amaan gene ke dhieny now.’ ");
INSERT INTO lwo_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Wahy Juog uoohra yihru. Wahy Juog ge ngad athiir kedea ge e naa ngaan cwag wun ubeehn bangu ke yoohn bang Wura. E nuu urubo ke nyinga yihru e gihn me kane tooro. ");
INSERT INTO lwo_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kedea wu thiow wu dhiil rob ke nyinga bang gihn wu anudo ke kaa athuba ke puohny.” ");
INSERT INTO lwo_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Giih ni ge aroba yihru bang ubange yiiho gihru yea be waaru keehd me yug giih me reje rogu. ");
INSERT INTO lwo_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wu riem gene oogo yihdh wuud amaad kejea utooru kiin gen. Cahng ngo adoohng cahng ke beehno. Cahng ukoohb ngaa anahg dhaano kiinu kea e naa ngaa ayiih lum Juog. ");
INSERT INTO lwo_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kwaad giih nu ge utiihy gene bang gihn Wura kwihy gene kedea a kwihy gene thiow. ");
INSERT INTO lwo_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Giih ni ge aroba yihru beere nea rog gen yug gene yugo e ngo uparu kejea wu anaa atoohna. “A kuu arubo yihru ke nying giih raahm umodho, bang gihn a anudo ke wun. ");
INSERT INTO lwo_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Awaahn a caa bang Wura ge anaa aoohr an. Kedea ngaa maa apeehny an kiinu tooro ke kun caa yea. ");
INSERT INTO lwo_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Abea ngo aniida kejea cwihnyu arahnyo ke nying giih aroba yihru. ");
INSERT INTO lwo_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Abea a rob athiir yihru, waahdha ge aaya oogo bangu, e ne kahl gihn me beer yihru. Bang gihn nea a buu ucidho bang Wura e Wahy Juog ge kony wun ni be beehn bangu. Abea nea a ucidho, e ngo oohra oohro yihru. ");
INSERT INTO lwo_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ge ubeehn ngaan kony wun, e ngo unyoadhe yihr yaa wiih piny kejea ge rob giih toohd. Ge rob giih toohd ke nying adhemuohm kedea ke nying beehd naa abiohgrwaal ke Juog maa ke nying cahng Lug Juog. ");
INSERT INTO lwo_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ge rob giih toohd ke nying adhemuohm bang gihn luma be yiih gene. ");
INSERT INTO lwo_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kedea ge rob giih toohd ke nying beehd naa abiohgrwaal ke Juog bang gihn a caa bang Wura ka me a be niidu yea. ");
INSERT INTO lwo_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ge rob giih toohd ke nying cahng Lug Juog bang gihn atiihb ukeehg luue amaany Juoge kedea ukihme ngo. ");
INSERT INTO lwo_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Yihra ne giih me thoohdh me nii cwihnya me daahda ke robo yihru, abea kar rob gen yihru awaahn ngo tooro bang gihn, yihdh gen be romu ke deedo. ");
INSERT INTO lwo_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Abea nea cahng ubeehn Wahy Juoge, ge urob athiir ni, e nuu umeehg wun ngey athiir kiin nyepinye. Kedea buu urubo kaa teeg mare keede, unahg kwaad gihn alihnge e nuu urobe. Kedea urubo kaa nying kwaad gihn muu uyug ree wong maalo. ");
INSERT INTO lwo_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wiiha amoar Wahy Juoge bang gihn kwaad giih urobe yihru cang ge aay ke banga. ");
INSERT INTO lwo_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Giih ne yihr Wura cang ge beehda giiha. E naa gihn koohba kejea Wahy Juog ulihng gihn roba batiene e caa ne rob ngo yihru. ");
INSERT INTO lwo_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Nye ka me cahng kan, e a buu uniidu, abea ke batien ka me thiin e a udogu ke niido keehdo.” ");
INSERT INTO lwo_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Maa abeehn yaaj mooge kiin jo waahdhe maa apeehny gene rog gen kob gene, “Gihn e rube kejea, ‘Nye ka me cahng kan e a buu uniidu’ maa kea, ‘Batien ka me thiin e a udogu ke niido.’ Maa kea, ‘Bang gihn a caa bang Wura?’ ” ");
INSERT INTO lwo_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Noono ubuohj gene ke piehj kob gene, “Lum yea ka me thiin beehda gihn? Gihn rube ke nying ngo yea kuu adeado ne cohg.” ");
INSERT INTO lwo_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Aguo Jeacuue ke ngeyo kejea ge daahd upeehny gene ngo ke nying gihn nu, noono maa akoohbe yihr gen kea, “Wu peehny rogu ke nying yea lum gihn aroba naa akoohba kejea, ‘Nye ka me cahng kan e a buu uniidu,’ kedea, ‘Batien ka me thiin e a udogu ke niido?’ ");
INSERT INTO lwo_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Gihn maa athiir e ne roba yihru. Wu uyuog ungeer yihdhu maano e yaa wiih piny cwihny ge med. Wu uyuog, abea lanu noono e nuu ukahl med cwihny yihru. ");
INSERT INTO lwo_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Raahm yoad dhaage yoado yi nyoohdo bang gihn nyethiin adoohng cahng ke nyuolo. Abea nea nyethiin apahdh piny, e wiihe uwulo rih raahm bang gihn cwihnye med ke nying nyethiin naa anyuole. ");
INSERT INTO lwo_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","E ne neehn maru thiow. Awaahn beehda caang lanu. Abea a uduu uniida wun keehdo kedea kaano e cwihnyu umihn kedea ngaa me dog mihn cwihnyu ke raanyo keehdo utooro. ");
INSERT INTO lwo_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Wong cahng nu, gihn muu udogu ke peehnyo yihra tooro. Athiir e ne roba yihru. Wura gihn kwayu yihre ke nyinga ngo ucube yihru. ");
INSERT INTO lwo_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Peehyu yihr Wura beere gihn daahdu yoadu yoado kedea e naa kaa utoor gihn me daag yi med cwihny gihru. ");
INSERT INTO lwo_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Keehd maa aruba yihru kaa ucaale, e nud ke cahng muu ubeehn me a buu urubo yihru ke ucaale. A urub yihru ke dhog me ne kel kel ne rob ke nying Wura. ");
INSERT INTO lwo_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Yi bad cahng nu wu ukwayu ke gihn daahdu yihr Wura ke nyinga bang gihn wu beehda yaa batiena. Kedea a be daahd ngo unahe ke an e ne kwahyo yihre ke nyingu. ");
INSERT INTO lwo_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bekihde! Wura ke ngude, wu nhyaare nhyaaro ke nying gihn nhyaaru an kedea gihn ayiihu ngo kejea a aay ke bange. ");
INSERT INTO lwo_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","A aay ke bang Wura kedea ubeehna wiih piny kan. Kedea awaahn a uaay wiih piny kedea udoga bang Wura.” ");
INSERT INTO lwo_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Maa arub jo waahdhe yihre kob gene, “Awaahn yih rubo yihr wan ne wag wag kedea padh kuu ucaale. ");
INSERT INTO lwo_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Abea awaahn ngo aniid wane kejea nyepinye ge ngahyi cang kedea yih be daahd ngaa me peehny yihn ke gihre me nii cwihnye. Kedea e naa gihn ayiih wane ngo kejea yih aay ke bang Juog.” ");
INSERT INTO lwo_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Maa abeehr Jeacuue ngo yihr gen kobe, “Wu ayiiho arumo? ");
INSERT INTO lwo_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Abea cahng moogo muu ubeehn nud kedea ngo abeehno awaahn ni. Wu ugoohd oogo riha cang kedea udoohnga a keeda. Kwaad dhaano ngo uci kure keede. A uwiiu piny a keeda. Abea keehd maano e a buu unaa keeda bang gihn Wura unud keehd an. ");
INSERT INTO lwo_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Giih ni ge aroba yihru beere wu ubeehdo e wu be dier bang gihn nahgu anweehd keehd an. Giih ajohr me thoohdh ge uyoadu wiih piny kan. Abea deedu cwihnyu bang gihn tee gihr wiih piny ngo taaya taayo ke dhe yoohn thona ngahy yaadh maa ariihw.” ");
INSERT INTO lwo_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Batien kaa athum Jeacuue ke rob, e ngo amaahny maalo ne kway Juog kea, “Abaa Wura, cahng anaa arobi ngo abeehno arumo. Moar wiiha beere wiihi moara moaro. ");
INSERT INTO lwo_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bang gihn yih naa acub an nyum nyoge cang ne ngaa me duohng kedea umuoja yaa akwanyi yihra ne jo batiena keehd kuowo me guge tooro. ");
INSERT INTO lwo_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Gihn e naa dhe yoohn yoad kuowo me be gug: ubeehn gene ungahy gene yihn, yih ge beehda Juog acielo cog juog moogo tooro. Kedea ubeehn gene ungahy gene Jeacuu Kriihjto naa aoohri. ");
INSERT INTO lwo_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Wiihi amoara wiih piny naa athuma ke tiihy gihn anaa acubi yihra ne tiihyo. ");
INSERT INTO lwo_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Abea awaahn ni, yih Abaa nyoadh kaa amoari wiiha me neehn ka cuunga nyumi kan. Moar wiiha ke moar wihj gihn anaa yihro maano e wiih piny poohd kuu anaa acag. ");
INSERT INTO lwo_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nyingi anyoadha yihr yaa ni acubi yihra wiih piny kan. Ge anahg joi maa acubi gen yihra kedea ubeehn gene uyiih gene lumi. ");
INSERT INTO lwo_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Awaahn, ngo ngahy gene ne cohg kejea kwaad loohnge giih anaa acubi yihra ge beehn ke bangi. ");
INSERT INTO lwo_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bang gihn luube giih arobi yihra ge aroba yihr gen kedea uyiih gene gen. Ngo angahy gene ne cohg kejea a aay ke bangi kedea ngo ayiih gene ke cwihny gen cang kejea beehda yih naa aoohr an wiih piny kan. ");
INSERT INTO lwo_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“A kwahyo kaa nying gen. A be kwahyo kaa nying yaa ni wiih piny cang abea a kwahyo kaa nying yaa acubi yihra ge beehda joi. ");
INSERT INTO lwo_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yaa ne yihri cang ge jo'a kedea yaa ne yihra cang ge joi. Kedea moar wihj gihn ayoada ngo ayoada kaa nying gen. ");
INSERT INTO lwo_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ge poohd ubeehdo wiih piny kan kedea a buu udog beehdo keehdo wiih piny, bang gihn a nii yooh ne ci bangi. Abaa Wura yih ge beehda abiohgrwaal kony gen ke tee gihri bang udoohng gene naa acielo wa kwaad maan nahgo acielo ni. ");
INSERT INTO lwo_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Naa abeehda keehd gen wiih piny kan, na nahg an e ne koar gen utoor gihn me raaj me yoad gen. Ge akoara utoor gihn maa ayoad gen kaa dhe yoohn tee gihri naa acubi yihra. Ge akoara utoor dhaano acielo me wonge arwaahnyo kiin gen nea padh ngaan uluom an ge anaa agweed yi kitaab Juog kejea e nuu urwaahny ucea Paar Maaj. ");
INSERT INTO lwo_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Abea awaahn a ubeehno bangi. Giih me thoohdh ge aroba yihr gen e a ubeehdo ke gen wiih piny kan beere med cwihny gihn nud yihro ngo yoad gene yoado. ");
INSERT INTO lwo_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Giih arobi yihra ge aroba yihr gen kedea ubeehn yaa wiih pinye umaan gene gen bang gihn par gihr gen be room keehd mar yaa wiih piny kan wa ka bahnge para be room ke par yaa wiih piny. ");
INSERT INTO lwo_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Yih be kwaya kaa nying ukaabi gen oogo wiih piny kan abea a kwahyo yihri kaa nying ukoari gen ubahnge ge be pahdh yi boon atiihb ukeehg. ");
INSERT INTO lwo_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Koar gen bang gihn luub gen padh acielo keehd yaa wiih piny wa man padh luuba acielo keehd yaa wiih piny thiow. ");
INSERT INTO lwo_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Yug gen ne joi ke dhe yoohn athiir gihn ayoad gene bangi. Gihn robi e naa lubo maa athiir. ");
INSERT INTO lwo_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ge aoohra wiih piny ne ci ne puohny Ciig Beer wa kwaad kaa anaa aoohri an wiih piny kan. ");
INSERT INTO lwo_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Riha acuba ne tiihj yihri beere ge thiow rog gen cub gene cubo yihri ne tiihy lumi. ");
INSERT INTO lwo_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“A be kwahyo yihri kaa nying gen keede cog, abea thiow a kwahyo kaa nying yaa uyiih luma ke nying puohny gihr gen ne puohny gene Ciig Beer. ");
INSERT INTO lwo_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","A ukwahyo yihri beere ge meehgi ke tiihj ke tiihy dhaano acielo. Abaa Wura wii gen umahd gene naa acielo tiehd wa kwaad maa anweehdo tiehd naa acielo ni. Wii umahd gene tiehd naa acielo beere yaa wiih piny kan ngo yiih gene yiiho kejea beehda yihn e naa aoohr an wiih piny kan. ");
INSERT INTO lwo_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Leej ayuga ke nying gen wa kwaad kaa ayugi leej ke nyinga beere ge udoohngo naa acielo wa kwaad ma nahgo acielo ni. ");
INSERT INTO lwo_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Bang udoohngo naa acielo tiehd keehd gen lum yea beehda: a atiihyo yi koohm gen kedea yih utiihyo yi kuohma beere ge umahdo ne cohg naa acielo. Ke nying beere yaa wiih piny ngo ngey gene ngeyo kejea beehda yih naa aoohr an kedea ge anhyaari wa kwaad maa anhyaari an ni. ");
INSERT INTO lwo_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Abaa Wura! A daahd yaan ni acubi yihra ubeehn gene banga ka nahga yea. Ke nying uniid gene leej gihra ge acubi yihra bang gihn a ngaa maa anhyaari kuu umodho maano e wiih piny poohd kuu acag. ");
INSERT INTO lwo_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Abaa Wura! Yih ngaa maa abiohgrwaal. Yaa wiih piny yih kuu angey gene abea yih beehde yih ngahya ke coon kedea yaan ni ngo abeehn ge ne ngeyo kejea beehda yih naa aoohr an wiih piny kan. ");
INSERT INTO lwo_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Anyoadha yihr gen kejea yih beehda ngaa kedea nhyaahro gihn anhyaari an dhiil ngo ke cubo yihr gen thiow beere a udoohng naa anweehd keehd gen.” ");
INSERT INTO lwo_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ge anaa athum Jeacuue ke kwaj wa gihn nu, e Jeacuu kedea jo waahdhe ge ake aay tiehd kedea ungol gene Oong Kihdron. Piny nu yea anaa puohdho gihr ulihbe. Noono maa abeehn Jeacuue umone yi puohdho keehd jo waahdhe. ");
INSERT INTO lwo_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Juudo ngaan uluom Jeacuu kaano amon ge Jeacuue yi ngo angahye ke coon bang gihn Jeacuu na kwaay roohmo kaa ngo keehd jo waahdhe. ");
INSERT INTO lwo_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jo doong yaa lam kedea Paarijea acaakere acub gene yihr Juudo me caahdh keehde. Noono maa abeehn gene kaa ane Jeacuue yea e ge kaahn redhe muu uliel kedea toong maa belunge. ");
INSERT INTO lwo_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ngo beehd e angahy Jeacuue e gihn ubeehn ne yug ree. Noono maa acuunge nyum gen ce peehye kea, “Wu daahd ngaa?” ");
INSERT INTO lwo_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Maa abeehr gene ngo kob gene, “Jeacuu ngad Naajaread.” Maa arube yihr gen kea, “A naa Jeacuu.” Juudo ngaa aluohmo ake cuungo tiehd keehd gen. ");
INSERT INTO lwo_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Abea ge arub Jeacuue yihr gen kea, “A naa Jeacuu ni,” e ge anaa angaahj dhe caahn upahdh gene piny ne rub. ");
INSERT INTO lwo_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Maa apeehy Jeacuue keehdo kea, “Ngaa e ne daahdu?” Maa akoohb gene kejea, “Wa daahd Jeacuu ngad Naajaread.” ");
INSERT INTO lwo_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Maa abeehr Jeacuue ngo kea, “Aroba yihru kejea a naa Jeacuu. Nea a ne daahdu kea meehgu yaa ni aay.” ");
INSERT INTO lwo_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Gihn nu ngo arobe bang beere giih anaa arobe umodho dhiil pahdh kar gen. “Abaa Wura gahng ke dhaano acielo maa arwaahnyo kiin yaa anaa acubi yihra.” ");
INSERT INTO lwo_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Maa abeehn Cimoan Piihtere uyuohdhe pala oogo kedea ungole yihdh ubaahng ngaa duohng yaa lam oogo. ");
INSERT INTO lwo_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Maa acuow Jeacuue Piihter kea, “Duog pala gihri kare kaa anea yea. Cuohni kii a utudo yi raahm kuohm gihn agwiir Wura ke nyinga ne?” ");
INSERT INTO lwo_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Batiene e acaakere kedea ngaa duohng gen kedea apahn yaa Judea, Jeacuu amag gene maa utuohj gene ngo ");
INSERT INTO lwo_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","kedea ukedh gene ngo nyum Anaj ngaa anahg ngaa duohng yaa lam umodho, ge beehda wur ciih Kaaypaj. Kaaypaj e naa anahg ngaa duohng yaa lam yi wong nu. ");
INSERT INTO lwo_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Anahg Kaaypaj e naa anaa cohg ngo yi cwihny yaa Judea kejea ngo beer ubeehn dhaano acielo uthowe ke nying nyoge cang yihr man beehn nyoge cang uthow gene ke nying dhaano acielo. ");
INSERT INTO lwo_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kaano Cimoane maa dhaano acielo kiin jo waahdh Jeacuu ge anaa apahdh ne buodh batien yaa ni kool Jeacuu. Ngaan ake caahdho keehd Piihter ngo amon yi roog gihr ngaa duohng yaa lam bang gihn ngo anahg ngaa me ngahj. ");
INSERT INTO lwo_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Abea Piihter anaa adoohng oogo dhe roog. Maa abeehn ngad waahdh Jeacuue gihn ni uduue oogo kedea urube keehd ngaa koar dhe roog kedea maa akahle Piihter yi diehr roog. ");
INSERT INTO lwo_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Maa arub nyaakowe yihr Piihter kea, “Ngahda yih beehda ngad batien nyin cuohn ne Jeacuu ne?” Maa abeehr Piihtere ngo kea, “A padh ngad batien Jeacuu.” ");
INSERT INTO lwo_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gihn nu e koohyo anudo maa abeehn kadaahme maa apahne upiih gene buud maaj ne oohyo. Maa amad Piihtere ree bang gen ne oohyo thiow. ");
INSERT INTO lwo_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Maa apeehny ruohdh yaa lame Jeacuu kobe, “Jo waahdhi ge beehda jo kee? Kedea gihn e ne puohnyi?” ");
INSERT INTO lwo_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","E abeehr Jeacuue yihre kejea, “Wa a na upuohnyo ke cahng cahngo kiin nyoge yi wod amaad kedea yi laaro gihr Wod Juog kuohn na kwaay yaa Judea ke roohmo yea. A na upuohnyo yihdh kuohn me neehn ne dahr e gihn me kana tooro. ");
INSERT INTO lwo_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Gihn e peehnyi an? Peehnyi ke yaa alihng puohnya. Giih aroba ge dhiil gene kaa ngahyo.” ");
INSERT INTO lwo_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Naa arob Jeacuue giih ni, e dhaano acielo kiin yaa koar giih yaa lam athubo ke dhoohng Jeacuu kobe, “Ngaa e naa arobe yihri kejea rubi yihr ngad duohng yaa lam neehn maano?” ");
INSERT INTO lwo_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Maa abeehr Jeacuue ngo yihre kea, “Nea a rob gihn me raaj e kea rob ngo yihr yaa ni kan e gihn raaj naa aroba, abea ne beehda gihn maa adiehr e ne roba, e gihn ge oohri dhaano acielo kiin yaa koar riha udhoohnge an ni?” ");
INSERT INTO lwo_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Noono e Jeacuu abeehn Anaje ne oohr nyum Kaaypaj e ngo poohd e atuohj. ");
INSERT INTO lwo_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Abea kaano e Piihter anaa apoohd e ngo uoohyo buud maaj maa apeehnye, “Ngahda yih beehda ngad batien ngaan ni cuohn ne Jeacuu ne?” Maa acahg Piihtere kweer kea, “Bekihde! A padh ngad batiene.” ");
INSERT INTO lwo_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","E dhaano acielo kiin kadaahme giih ngad duohng yaa lam ngo anudo kaano. Ngo anahg waahde keehd ngaan yihdhe anaa angol Piihtere oogo ke pala. Noono maa anyoadhe wong Piihter kobe, “Yih anaa aniida yi puohdho gihr ulihbe keehd Jeacuu tiehd.” ");
INSERT INTO lwo_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Maa acahg Piihtere ngo ke jaahyo kea, “Bekihde!” Kedea ke wong kaano e uthuonjieno ake thubo ke koohg. ");
INSERT INTO lwo_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Batiene e Jeacuu abeehn Judea ne kaabo oogo nyum Kaaypaj kedea ukedh gene ngo paar muudiihr gihr Roama ge nyinge Pilaato. Ngo anahg kaa akaahg piny, noono e ge akweer ke mono yi wod Lug beere Juog ge be niide ne nyoge me reje utoor ka me cam gene cam gihr Yaan Amono. ");
INSERT INTO lwo_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Noono e Pilaato abeehn oogo bang gen kedea upeehnye gen kobe, “Gihn noono raaj ge ayug ngaan ni?” ");
INSERT INTO lwo_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Maa abeehr gene ngo kob gene, “Nea gihn me raaj me nea yugo ne tooro e ngo ne kahl wane nyumi ne?” ");
INSERT INTO lwo_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Maa arub Pilaate kea, “Kaabu ngo ucidhu ne maany luwe ke dhe yoohn loohnge giihu.” Maa akweer yaa Judea kob gene, “Yihdh luue giih wan yihr wan tooro tee me kihm wane dhaano ke thoo.” ");
INSERT INTO lwo_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Gihn nu arob gene beere luub arob Jeacuue ke nying dhe yoohn ka uthowe ge pahdh kar gen. ");
INSERT INTO lwo_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Maa abeehn Pilaate udoe wod kedea urube yihr acaakere kejea kahl Jeacuu yihre. Naa akahl Jeacuu e ngo apeehnye kea, “Yih naa ruohdh gihr yaa Judea?” ");
INSERT INTO lwo_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Kob Jeacuue kea, “Beehda lubo me aay ke bangi wale beehda ngaa moogo e naa awaahny yihn?” ");
INSERT INTO lwo_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Maa abeehr Pilaate ngo kea, “Wiihi apari kejea a beehda Ujudea ne? Wa beehda yaa paaru kedea ruohdhe giihu ge naa akahl yihn nyuma. Gihn e naa atiihyi ne cohg?” ");
INSERT INTO lwo_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Maa akoohbe kea, “A padh ruohdh wiih piny kan, bang gihn nea ruohdha ne nahg ruohdh wiih piny kan e yaa dhaahra ge ne kag ubahnge a be mag Judea.” ");
INSERT INTO lwo_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Noono e acahg Pilaate ke peehnyo kobe, “Yih ka beehda ruohdh boh?” Maa akoohb Jeacuue kea, “Lumi adiehr naa akoohbi kejea a beehda ruohdh kedea e naa ke nying gihn anyuol an wiih piny kan. Kedea a ne rob athiir yihr nyoge. Kwaad ngaa nhyaar gihn maa athiir, gihn roba pahdh yi cwihnye.” ");
INSERT INTO lwo_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Maa akoohb Pilaate kea, “Gihn maa adiehr beehda gihn me ngihde?” Noono e Pilaato ado oogo bang yaa Judea urube yihr gen kea, “Ngaan gihn maa ayoada ree tooro me meehg ngo kihmo ke thoo. ");
INSERT INTO lwo_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Abea beehda gihn me nud ke nying run yi Yaan Amono, e dhaano acielo na luny oogo yi karkoohn yihru. Awaahn ni lonya ruohdh gihr yaa Judea oogo yihru ne?” ");
INSERT INTO lwo_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kaano e ge athubo ke rob e ge ukwaago kob gene, “Padh ngaan nu! Wa daahd ulonyi Barabaj.” (Barabaj ngo anahg ngad kahw). ");
INSERT INTO lwo_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Batiene e Pilaato acaakere ge alonye ne puohd Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Maa abeehn acaakere uriiw gene koadhe wa thaaj ucub gene ngo wiihe naa atahny ruohdh. Thiow ngo angaab gene wa ruohdh ke waaro me wa ukwaaro kedea ngo ne mihl mihl ne ngier kuohme. ");
INSERT INTO lwo_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Noono ucidh gene ke ne cuung nyume e ge urubo kob gene, “Maahdh ya Ruohdh yaa Judea!” Kedea e ngo dhohng gene dhohngo. ");
INSERT INTO lwo_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Maa abeehn Pilaate oogo keehdo urube yihr Judea kea, “E ge akahla oogo yihru beere ngo ngahyu ngahyo kejea awuohj maa ayoada ree tooro me kihme ke nyinge.” ");
INSERT INTO lwo_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Naa akahl Jeacuu oogo e atahny koadho nii wiihe kedea waaro angaab ree e Pilaate arubo yihr gen kea, “Ngaan ngo e man. Ngo akahla oogo yihru.” ");
INSERT INTO lwo_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ge anaa aniid jo doong yaa lame kedea apahne giih gen Jeacuu, e ge amaahr piny ke kwaago kob gene, “Gure rih yaadh, gure rih yaadh.” Maa abeehr Pilaate ngo yihr gen kobe, “Noono kaabu ngo uguru ngo maalo rih yaadh. Nea ke kur mara e awuohj maa ayuge tooro me kihme ke thoo.” ");
INSERT INTO lwo_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Maa ateel yaa Judea yi lubo teeg mee kob gene, “Yihr wan ne loohng kedea ke nying loohng nu e ngo dhiil kaa gur rih yaadh bang gihn kea e Waahd Juog.” ");
INSERT INTO lwo_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Abea ge anaa alihng Pilaate gihn arob gene, e atud keraahyo ke ka ukihme Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Noono ucahge do wod keehdo maa arube yihr Jeacuu kea, “Yih beehda nyethiin paan aweehne?” Abea Jeacuu gihn maa abeehre tooro. ");
INSERT INTO lwo_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Maa akoohb Pilaate kea, “Yih be daahd urubi yihra ne? Kwihyi e yihra ne tee me lonya yihn oogo kedea me roma yihn ke cubo yihr acaakere uci gene ne gur yihn rih yaadh ne?” ");
INSERT INTO lwo_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Maa abeehr Jeacuue ngo kea, “Tee mar ngudi tooro nea padh Juog e ne cub ngo yihri. Abea awuohj me duohng me wiihe ne maalo naa rog yaa akahl an nyumi ne kihmo.” ");
INSERT INTO lwo_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Abea ke nying gihn nu, e Pilaato ake thubo ke daahd dhe yooh me lonye Jeacuu abea yaa Judea ge athubo ke kwaago kob gene, “Nea ngo lonyi lonyo e yih padh gom keehd Jaah Roama. Kwaad ngaa koohbo kea e beehda jaah e ngo apaahr oogo rih Jaah gihn nud Roama.” ");
INSERT INTO lwo_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ge alihng Pilaate luube giih ni, e Jeacuu akahle oogo ke yoohn wod. Noono maa acidh Pilaate ne piih wiih koom Ruohdh gihr lug gihre e cuohn ne Gabadha. ");
INSERT INTO lwo_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ngo anahg ke nyango cahng gwiihro gihr Yaan Amono. Kaano e Pilaato arubo yihr yaa Judea kea, “Ruohdh gihru e man!” ");
INSERT INTO lwo_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","E ge athubo ke kwaago kob gene, “Nahg ngo, nahg ngo, gure rih yaadh.” Maa apeehny Pilaate gen keehdo kobe, “Wu daahd ruohdh gihru ke gur rih yaadh ne?” Maa abeehr ngad duohng yaa lame ngo kobe, “Yihr wan ne ruohdh acielo cog ge beehda Jaah Roama.” ");
INSERT INTO lwo_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Maa abeehn Pilaate ucube ngo yihr acaakere giih Roama bang uci gene ngo ne gur rih yaadh. Batiene e acaakere Jeacuu akool gene ke oogo, ");
INSERT INTO lwo_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","yi diehr yi geew maano e bien yaadh gihre ge ucea ne gur rih ngo. Kedea ubeehne ne wahnh ka me cuohn ne Golgotha ");
INSERT INTO lwo_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Maa agur gene ngo rih yaadh kedea ugur gene nyoge ariow buude kun ke kun kedea Jeacuu nii diehr kiin gen. ");
INSERT INTO lwo_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Batiene e Pilaato arubo kea, “Gweed luube me noog kedea ugur gen te wiih Jeacuu.” Maa agweed luube giih, “RUOHDH YAA JUDEA”. ");
INSERT INTO lwo_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Gihn ni agweed ngo akwaan yaa Judea me thoohdh ke nying gihn kaa anaa agur Jeacuu yea kuu abaahro ke geew. Gihn anaa agweed, agweed ke dhoy adahg. Agweed ke dhog Judea kedea dhe Laatiihn maa dhe Griihg. ");
INSERT INTO lwo_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jo doong yaa lam gihn nu amaan gene maa aweehr gene ngo yihr Pilaato kob gene, “Ngo keá gweedi ne ‘Ruohdh yaa Judea’ abea gweed ngo kii, Ateede kea e beehda Ruohdh yaa Judea.” ");
INSERT INTO lwo_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Maa abeehr Pilaate ngo yihr gen kea, “Gihn agweeda be dog ke waaro.” ");
INSERT INTO lwo_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Batien kaa athum acaakere ke gur Jeacuu rih yaadh e ge apiih ne paahng waare giihe ne akuude angween, acielo yihr goan akuud acaakere acielo kedea ukaab gene waahnye acielo maa aloaj. ");
INSERT INTO lwo_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Maa arub gene ke rog gen kob gene, “Ngo keá yiejo. Gooye ke thalo umaanyo ngaa upahdhe yihre.” Gihn ni ree ayuge bang ubeehn gihn anaa agweed yi kitaab Juog uyuge ree wa kaa agweede, “Waaya apaahng gene ke kiin gen kedea ugooj gene waahnya oogo ke thalo.” ");
INSERT INTO lwo_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Miih Jeacuu kedea mahy kedea Maarya ciih Klewpaj kedea Maarya Madaleana ge anaa anudo thar yaadh gihn agur Jeacuu rih ngo. ");
INSERT INTO lwo_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Naa aniid Jeacuue men kedea ngaan nhyaare kiin jo waahdhe e ge acuungo, e Jeacuu arubo yihr men kea, “Gihn ni e naa waahdi.” ");
INSERT INTO lwo_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kedea ucahge rob yihr ngaan anhyaare kea, “Gihn e naa miihu.” Ke bad cahng nu e miih Jeacuu abeehn ngaan nu ke ne daag paare ne beehdo yea. ");
INSERT INTO lwo_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Batiene e ngo abeehn Jeacuue ne ngeyo kejea giih anaa arob ke nyinge ge atiihy rog gen cang beere giih agweed yi kitaab Juog ge pahdh kar gen ne rihb e ngo arubo kea, “A anahg riowe.” ");
INSERT INTO lwo_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","E koongo me waj anaa anudu. Maa abihle ke bur waaro maa atuohje wiih boohl kedea ucube dhee ne cwiiyo. ");
INSERT INTO lwo_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Naa acwiiye piih koongo e arubo kea, “Tiihya athum keehdo.” Kaano e naa kaa anahg ngude nag kedea e naa thone noono. ");
INSERT INTO lwo_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yaa Judea Pilaato apeehny gene kejea meehg gen toy tien jo agur rih yaadh kedea ukahl koohm gen piny rog yen. Ge adaahd utiihy giih nu bang gihn ngo anahg cahng gwiihro gihr Yaan Amono kedea ge be daahd uriih koohm jo ni rog yen uwahdhe cahng Cabadh, ke nying gihn ngo beehda cahng Cabadh me ke wuoro. ");
INSERT INTO lwo_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Batiene e acaakere ge aci ne toy tien jo ni anaa agur rog yen ni. Ge athubo ke toy tien ngad umodho ge anaa buud Jeacuu kedea ucahg gene tien ngaa man ke toy thiow. ");
INSERT INTO lwo_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Abea ge abeehn gene bang Jeacuu ni, e ge niid ngo e thow, maa abahnge tiene kuu atoy gene. ");
INSERT INTO lwo_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Maa abeehn wa acaakere acielo ucobe Jeacuu te bad ngo ke tong, kaano e remo kedea piih ge athubo ke woj oogo yi kuohme. ");
INSERT INTO lwo_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kedea ngaa aniid giih ni cahng ayug gene rog gen e naa cuud. Kedea gihn aniide ngo arobe beere ngo yiihu yiiho thiow. ");
INSERT INTO lwo_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Gihn ni ree ayuge beere giih anaa agweed yi kitaab Juog dhiil pahdh kar gen wa kaa ngo, “Bekihd coohnge acielo maa atoar.” ");
INSERT INTO lwo_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kedea nud ke moogo maa agweed thiow naa, “Ngaan acob gene bang ngo umaany gene maanyo.” ");
INSERT INTO lwo_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Abea ke batien giih nu cang e ngaa me nyinge Jocebe ge ngad geen Arihmathea, abeehno upeehnye Pilaato kejea, “Kare nud uroma kuohm Jeacuu ke kano ne?” Jocebe anahg ngad batien Jeacuu me ree keá robo oogo bang gihn ngo na utudo yihr yaa Judea. Naa acub Pilaate kuohm Jeacuu yihre e ngo akaabe. ");
INSERT INTO lwo_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ge anaa ake caahdho tiehd ke Nikoadiihmuj. Nikoadiihmuj ge naa akuong weehn bang Jeacuu yi diehr waahr. Nikoadiihmuj akaahn mow me ngwaahy maa alyaahb ke gihn me cuohn ne mihr kedea ke mow moogo me cuohn ne aloay. Ge beehda mahdhe me yor kuohm ngaan athow ke gen. Mow anahg kar kiihe jiehadahg wonge apaar wonge abiihj. ");
INSERT INTO lwo_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Maa akaab gene kuohm Jeacuu kedea ubahj gene ngo ke waaro kedea uyor gene ngo keehd mahdhe me ngwaahy wa ka yug yaa Judea ngaa maa athow. ");
INSERT INTO lwo_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kaa agur Jeacuu rih yaadh yea anaa buud puohdho kedea loohro me beehda liel me dhaano kuu akuong ke koanyo yea anudo buud puohdho. ");
INSERT INTO lwo_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bang gihn ngo anahg cahng gwiihro gihr Judea ge beehn cahng Cabadhe ke batiene ni kedea ke nying gihn nud loohro me cahng mee ke kaano, e kuohm Jeacuu akan gene kano. ");
INSERT INTO lwo_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ke nyango coon ke batien cahng Cabadh, maano e piny poohd kuu aruu, e Maarya Madaleana abeehn ne ci ne maany loohro. Naa abeehne kar loohro e yuud leelo gihn anaa aciehg dhe loohro keehde, e ngo aloor oogo. ");
INSERT INTO lwo_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Maa a'aaye ke ngweej ne beehn bang Cimoan Piihter kedea ngaan nhyaar Jeacuue kiin jo waahdhe. Maa arube yihr gen kea, “Kuohm ruohdh akaab gene kedea kaa adaag gene ngo yea kwihya.” ");
INSERT INTO lwo_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kaano e Piihter kedea ngad waahdh Jeacuu ge na nhyaare ge athubo ke goohd kar loohro. ");
INSERT INTO lwo_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ge agoohdo tiehd ke kar ge ariow abea Piihter anaa ayoohme unahge ngaan anhyaar Jeacuue e naa akuong wahdho kar loohro. ");
INSERT INTO lwo_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Maa agonge piny ulwaahnge wonge maa aniide waanhy thoo yi loohro abea kuu amon yi loohro. ");
INSERT INTO lwo_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","E Piihter ge naa batiene ni ake beehno kedea ubare kii wod loohro maa aniide waay thoo giih anaa akan kuohm Jeacuu keehd gen. ");
INSERT INTO lwo_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Thiow maa aniide waaro gihn anaa ariiw wiihe keehde e ngo adol ucube kar keede yi loohro buud waay thoo. ");
INSERT INTO lwo_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Batiene e ngad waahdh Jeacuu gihn anaa akuong wahnho wiih loohro umodho ni abeehn ne mono thiow yi wod loohro maa aniide waay thoo giih akan kuohm Jeacuu keehd gen e ge ne piny kedea uyiihe ngo kejea Jeacuu acahr. ");
INSERT INTO lwo_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Abea poohd e gihn anaa agweed yi kitaab Juog ngo kuu adead gene, ge agweede naa, “Ngo udhiil cahro ke batien thoo.” ");
INSERT INTO lwo_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Noono e jo waahdhe giih ni ariow ge adog ka beed gene. ");
INSERT INTO lwo_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Abea Maarya anaa adoohng buud loohro e ngo uyuog. Batiene naa amaahnye yi wod loohro, ");
INSERT INTO lwo_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","e niid wuohdjuog ariow maa angaab waare me tar ne yim e ge apiih kaa anaa apiehl kuohm Jeacuu yea. Wuohnjuog acielo ne te wiihe kedea moogo ne kur tiene. ");
INSERT INTO lwo_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Maa apeehy gene kob gene, “Yih dhaar ni, gihn e ne yuogi?” Maa arube yihr gen kobe, “Kuohm ruohdha atihng gene oogo yi loohro kedea kwihya kaa adaag gene ngo yea.” ");
INSERT INTO lwo_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Naa alihnge gihn arob Wuohnjuoge e ngo amaahny ngahye maa aniide Jeacuu acuungo abea ngo keá ngeyo. ");
INSERT INTO lwo_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","E apeehny Jeacuu peehnyo kobe, “Yih yuog gihn? Kedea beehda ngaa e ne daahdi?” Mar Maarya cuohne kea beehda ngad ajeniino e ne peehny en, gihn nu e akob Maarya kea, “Nea yih naa atihng kuohme ne daa ka moogo kea nyoadh kaa ngo yihra beere a caa ne kaab ngo.” ");
INSERT INTO lwo_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Maa acuohn Jeacuue ngo ke nyinge kea, “Maarya.” Maa aloge wonge bang ngo maa amaahre piny ke rob ke dhog yaa Judea kea, “Raboani.” (Lum yea ngad puohny). ");
INSERT INTO lwo_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Maa akoohb Jeacuue yihre kea, “Yih keá baahb riha bang gihn a poohd kuu awahdh bang Wura. Abea aayi ucidhi bang jo paar wura ne teed ngo yihr gen kejea a caa bang Wura ge beehda Wuru kedea bang Juog gihra ge beehda Juog gihru thiow.” ");
INSERT INTO lwo_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Noono ubeehn Maarya Madaleana ucea ke bang jo waahdh maa arobe ngo yihr gen kea, “Ruohdh aniida.” Kedea gihn arob Jeacuue ngo arobe thiow yihr gen. ");
INSERT INTO lwo_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yi bad cahng nu ke thiehno, e jo waahdh Jeacuu ge anaa amahdo yi wod kedea dhog wuude ge anaa atoag cang bang gihn ge abeehdo e ge atud yihr yaa Judea. Noono ubeehn Jeacuu ucuunge kiin gen kobe, “Maahdhu rogu ya.” ");
INSERT INTO lwo_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Batien naa amaahdhe jo waahdhe, e athubo ke nyoadh cinge naa agur kedea koohre naa acob ke tong yihr gen. Gihn nu e cwihny gen amihno keter naa aniid gene ruohdh gen. ");
INSERT INTO lwo_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Maa acahg Jeacuue rob yihr gen keehdo kea, “Beehdu ke yoohm rogu. Wa kwaad kaa anaa aoohr Wura an e a thiow wu oohra oohro.” ");
INSERT INTO lwo_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ge arobe giih nu, e athubo kaa koadh Wahy Juog yi wudh gen kobe, “Beehn Wahy Juoge wudhu. ");
INSERT INTO lwo_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nea adhemuohme giih dhaano ge awiiu piny e ge wiia ke piny thiow. Tooro, ne ge kuu awiiu piny e ge be wiia piny thiow.” ");
INSERT INTO lwo_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ngad waahdh Jeacuu acielo me nyinge Thoamaj ge beehda goan kuoy anaa atooro cahng anaa anyoadh Jeacuue ree yihr jo waahdhe. ");
INSERT INTO lwo_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Noono naa arob jo waahdhe ngo yihre kejea Jeacuu aniid gene e ngo apeehmo ukuohnge ree kea, “Nea padh cinge ge anaa agur kedea koohre ge acob ge ne niida kedea ucuba cinga yihdh kuohn ledh, e ngo be kuonga ke yiiho naa adiehr.” ");
INSERT INTO lwo_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Batien nihn abiihj beriow, e jo waahdh Jeacuu ge anaa amahdo cang ka maa acielo kedea Thoamaj anaa anudo tiehd ke gen kedea dhog wuude ge anaa atoag. Kaano e Jeacuu abeehn ne cuungo kiin gen kobe, “Beehdu ke yoohm rogu.” ");
INSERT INTO lwo_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Maa arube yihr Thoamaj kea, “Kahl cingi ucubi ngo kuohn anaa agur yi cinga kedea dog cingi ke cub yi koohra kaa anaa acob. Wii piem gihn maa adiehr.” ");
INSERT INTO lwo_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Maa abeehr Thoamaje ngo yihre kea, “Yih naa ruohdha kedea yih naa Juog wuora.” ");
INSERT INTO lwo_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kob Jeacuue kea, “Adiehr muon! Yih ayiiho ke nying gihn aniidi an: Mihn cwihny yihr yaa ayiiho e gihn maa aniid gene tooro.” ");
INSERT INTO lwo_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jeacuu naa acahre e giih mooge me gaahy nyoge me thoohdh ge ayuge nyum jo waahdhe, abea ge kuu agweed yi kitaab gihn. ");
INSERT INTO lwo_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Abea muu ge agweed piny beere yiihu yiiho kejea Jeacuu e naa Ngad Boadh nyoge kedea e naa Waahd Juog kedea ge agweed thiow beere boadh wahy yoadu yoado ke nyinge. ");
INSERT INTO lwo_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ke batien nihn mooge e Jeacuu ree acahge ke nyoadho yihr jo waahdhe dieng naam duohng gihr Tiberya. Ree anaa anyoadhe ke wa gihn: ");
INSERT INTO lwo_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jo waahdhe giih anaa anudo anahg: Cimoane Piihter, Thoamaj goan kuoy, Nathaneel ngad Kana ge nii piny Gaalili kedea waahd Jebeade maa jo waahdh ariow mooge. ");
INSERT INTO lwo_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Kaano e Cimoane Piihter ake rubo kea, “A caa ne maay.” Maa akoohb gene, “Wa ucidho tiehd ke yihn ne maay.” Noono maa atihng gene rog gen uyedh gene yi baabuur ne maay. Ge abuohj ke waahr ke maay duug abea reehyo maa amag gene tooro. ");
INSERT INTO lwo_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Abea ge athub cahnge ke moohlo ni, e Jeacuu ake cuungo dieng naam wiih agala, abea ngo kuu angey jo waahdhe kejea beehda e naa acuungo wiih agala. ");
INSERT INTO lwo_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Maa arube yihr gen kea, “Goma maa anhyaara! Ne rej maa amagu ne?” Maa abeehr gene ngo kob gene, “Kihd wong acielo maa amag wane tooro.” ");
INSERT INTO lwo_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Maa akoohbe kea, “Kea thoohru booy gihru ukwiihy baabuur, nea wu buu umaah ke rej.” Noono ge anaa athoohr gene booy, e ngo kuu arom gene ke teehl yi baabuur bang gihn booy ane kahn kahn ke rej. ");
INSERT INTO lwo_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","E ngaan nhyaar Jeacuue kiin jo waahdhe ake rubo yihr Piihter kea, “Wa ruohdho e gihn ca!” Ge anaa alihng Piihtere ngo kejea beehda ruohdh gen e ne rubo, e waaro gihre e anaa akahle oogo, angaabe ke ree. Noono upaahre yea naam duohng. ");
INSERT INTO lwo_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jo waahdh giih anaa adoohng yi baabuur, ge alahbo ke batiene e ge kiiw baabuur kedea ge ywaay booy wiih agala. Agala anahg kar akaahdhe jiehabiihj ke kaa anahg baabuure yea. ");
INSERT INTO lwo_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Naa awahnh gene wiih agala e ge yuud rej wiih cug kedea amune ge anudo thiow. ");
INSERT INTO lwo_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Maa arub Jeacuue yihr gen kea, “Kahlu rej giih amagu awaahn kan.” ");
INSERT INTO lwo_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Maa abeehn Cimoane Piihter uyedhe yi baabuur ne kony yaa nii baabuur ke teel booy. Booy yea anaa apahng ke rej. Maa akwaan gen unahg gene jiehabiihj wonge jiehariow wonge apaar wonge adahg. Keehd maano amahg booye keehd rej me thoohdh mee nu, e kihd wong booy acielo maa acoohd tooro. ");
INSERT INTO lwo_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Maa arub Jeacuue yihr gen kobe, “Beehnu ne cam.” Ngaa maa arom piehj kiin jo waahdh kejea, “Yih naa ngaa?” tooro bang gihn ngo angey gene e beehda ruohdh gen. ");
INSERT INTO lwo_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Noono e Jeacuu ake beehno ukaabe amono kedea ucube ngo yihr gen kedea ucahge reehyo ke kaabo ucube ngo yihr gen thiow. ");
INSERT INTO lwo_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Gihn ni anahg yi dahg gen ge anyoadhe ree yihr jo waahdhe batien cahre yi thoo. ");
INSERT INTO lwo_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Batien naa athum gene ke cam, e Jeacuu Piihter apeehnye peehnyo kobe, “Cimoane waahd Joon! A anhyaari ne cohg ukaale kaa nhyaar yaa ni an ne?” Maa abeehr Piihtere ngo kobe, “Ayiihi Ruohdh! Keehd yihn e ngo ngahyi kejea yih anhyaara.” Maa akoohb Jeacuue kea, “Kwaag roohme giiha noono.” ");
INSERT INTO lwo_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Maa acahge piehj kea, “Cimoane waahd Joon, a anhyaari ne cohg ukaale wiih kaa anhyaar yaa ni an ne?” E ngo acahg Piihtere ke beehro kea, “Ayiihi ruohdh! Keehd yihn e ngo ngahyi kejea yih anhyaara.” Maa akoohb Jeacuue kea, “Kwaag roohme giiha noono.” ");
INSERT INTO lwo_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Maa acahge piehj kea, “Cimoane waahd Joon, a anhyaari ne cohg ukaale wiih kaa anhyaar yaa ni an ne?” E Piihter cwihnye arahnyo ke nying gihn apeehnye tiel adahg ke piehj acielo, e ber, “A anhyaari ne cohg ukaale wiih kaa anhyaar yaa ni an ne?” E arobe yihr ngo kea, “Ruohdh! Yih ne ngahy giih nyepinye cang. Kedea ngo ngahyi kejea yih nhyaara nhyaaro.” Maa akoohb Jeacuue kea, “Kwaag roohme giiha noono. ");
INSERT INTO lwo_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Athiir e ne roba yihri, ge anaa apoohde e yih beehda rihj ni kwaad gihri ne pari e ne na tiihyi cog. Yih ungahbo kedea uci kwaad ka daahdi. Abea ge doongi, e baahdi ge utihngi maalo kedea nyoge yih utuohj gene ukedh gene yihn ka me cwihnyi toor cidh yea.” ");
INSERT INTO lwo_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Gihn ni ngo rob Jeacuue bang ne nyoadh kwaad thoo gihn ubeehn Piihtere umoare wiih Juog keehde. Noono urube kea, “Buodh batiena.” ");
INSERT INTO lwo_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ge alog Piihtere wonge ni e niid ngaan nhyaar Jeacuue kiin jo waahdhe e buodh batien gen. (Ngo beehda nyin anaa anyiig buud Jeacuu cahng acam gene amono Yaan Amono, upeehye kea, “Ruohdh ngaa e nuu uluom yihn?”) ");
INSERT INTO lwo_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ge anaa aniid Piihtere ngo, e Jeacuu apeehnye kea, “Ruohdh ngaan ni mare unahg gihn?” ");
INSERT INTO lwo_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Maa abeehr Jeacuue ngo yihre kea, “Nea a daahd ngo ubeehde e kuow, uwahdhe cahng uduua, e lum mari gihn? Dhiil batiena ke buodho.” ");
INSERT INTO lwo_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Rob gihn ni ngo abeehn ne nyaay kiin jo waahdhe kejea ngaan anhyaar Jeacuue kiin jo waahdhe ngo buu uthow. Abea padh e naa gihn arob Jeacuue. Jeacuu arubo kea, “Nea a daahd ubeehde e kuow uwahdhe cahng uduua e lum mari gihn?” ");
INSERT INTO lwo_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ngad waahdh Jeacuu gihn nu, e naa cuud kedea ugweede giih aniide piny. Ngo ngahyo kejea giih agweede ge beehda giih maa adiehr bang gihn ngo beehda cuud. ");
INSERT INTO lwo_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Giih me thoohdh mooge ge ayug Jeacuue. Nea ge ne gweed piny cang wiiha para paro kejea piny ne pahng keehd wargag agweed utoor ka me laahw.");
INSERT INTO lwo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1"," Yih Thiopiihluj, kitaab gihn anaa agweeda umodho yihri ni, a anaa arubo yea ke nying giih anaa atiihy Jeacuue kedea giih anaa apuohnye naa athube ke tiihy puohny nyoge. ");
INSERT INTO lwo_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Jeacuu ree anaa abeehne ne nyoadho yihr jo oohr, ge anaa akwanye batien thone tiel me thoohdh mee kedea ubeehde keehd gen ke nihn jiehariow beere ngo ngahy gene ngahyo ne cohg kejea ngo ngaa me kuow. Luube ge anaa aceg Jeacuue piny yihr jo oohr kaa tee Wahy Juog ke ngude. Arobe yihr gen beere ge urubo yihr nyoge kejea Juog daahd nyoge unahg gene yaa Dhaahre. Batiene e ngo atihng Juoge ke Maalo. ");
INSERT INTO lwo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Cahng anaa atihng Jeacuu Paar Juog, e en maa jo oohr ge anaa amahd ka maa acielo. Cahng nu e Jeacuu lubo arobe yihr jo waahdhe. Arobe yihr gen kea, “Yaage, wu keá aay yi geen Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Wura, Wahy Juog, e anaa aruba ke nyinge, uoohre yihru.” ");
INSERT INTO lwo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Cahng moogo dahng e Jeacuu anaa apeehny jo waahdhe kob gene, “Ngad puohny, unahg weehne e nu ubeehno, yihn maa wan, unahgo ruohdh doonge yi dhaahr Yijarael?” ");
INSERT INTO lwo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Maa beehre ngo yihr gen, “Juog Wura e keede e ne ngahy cahng ngo maa ka uyug giih ni rog gen kii ngo. Padh tiihyu ungahyu gen. ");
INSERT INTO lwo_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Abea gihn utiihyu beehda cidh ne rob giih apuohnya yihr nyoge. Tee ucub yihru nea Wahy Juog beehn wudhu, kaano arumo e giih ngahyu ke nyinga ge uteedu yihr yaa beehd Jeruucalem kedea cidhu ne teed gen yihr yaa beed wudh geedh piny Judea maa piny Camaarya kedea yihr yaa wudh geedh ungoom cang.” ");
INSERT INTO lwo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Naa athum Jeacuue ke rob yihr gen e ge awiihwe wiihwo, noono utihnge Maalo Paar Juog e ngo uneehno yihr gen ");
INSERT INTO lwo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","uwahdhe kaa arwaahnye yi lwahd. Abea ge apoohde e nying gen atal maalo ne maahnyo, e wuohdjuog ariow maa angaab waare me tar ne yim, ge anaa ne celang ucing gen ");
INSERT INTO lwo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","urub gene kob gene, “Wu yaa Gaalili! Beeh teed wane yi lum atihng Juoge Jeacuu Maalo ne do Paar Juog. Jeacuu uduu wa kwaad kaano aniidu ngo e caa Maalo nu. Abea awaahn ni nyingu keá ngahn maalo ne maahnyo, bang gihn cahng uduue ngo poohd.” ");
INSERT INTO lwo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kaano arumo e jo oohr ge adog geen Jeruucalem, e ge duu kaa wiih good Ulihbe. Kaa ngo thiow, cahng keehd geew. ");
INSERT INTO lwo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ubeehn gene yi buur geew uyedh gene yi wod maalo naa abeehd gene yea. Yaa anaa yi wod anahg ge Piihter, Joon, Jeamij maa Andrya kedea Pihlihb maa Thoamaj, Bartholomeao kedea Matheewo, Jeamij waahd Alpaawo, Cimoane, kedea Juudo waahd Jeamij. ");
INSERT INTO lwo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yaa nu cang ge ne koag ke kway Juog ke cwihny ge acielo. Maahn mooge maa Maarya miih Jeacuu kedea wuud wur Jeacuu ge na ukwahyo keehd jo oohr tiehd. ");
INSERT INTO lwo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","19","Juudo Yijkaariod, naa angeye ngo kejea e tiihy gihn me raaj naa akahle nyoge maa amag Jeacuu, e ree angaabe ngaabo. Gihn nu e kuohme apahdho piny unahg ciihn yeye ne way oogo. Yaaj mooge, naa ayoad gene ngiihny anaa akaabe naa aluome Jeacuu, e puohdho kaa athowe yea ngo angeew gene ke ngiihny nu. Naa abeehn nyoge ne lihng gihn atiihy ree, e puohdho gihn angeew ngo acuohn gene ne ‘Akeldaama’, lum yea ke dhe paar gen: “Kaa awoj reme piny yea.” Batien nihn me noog, naa aduu jo oohre ke yoohn good Ulihbe e amaad gihr yaa ayiiho ake piih. Yaa anaa kar amaad ge anahg kar nyoge jiehabiihj ke dhaano aduuno. Maa ayedh Piihtere maalo maa arube kea, “Yaage, yihra ne gihn me daahda ke robo yihru. Gihn raaj e atiihy Juudo Yijkaariod ngo beehde e ngo ngahyu. Jeacuu e naa anaa akwany ngo keehd won yi tiihj gihn tiihyo. Abea wiihe anaa abeehne ne waaro upaahre oogo rih Jeacuu kedea ubeehne ke nyoge ne nyoadh ngad puohny beere mag gene maa. Awaahn ni Juudo ngo tooro bango, ngo athow. Abea Wahy Juog, gihn beere rom tiihyo yihru ngo anaa arobe coon yihr Deabid ruohdh kedea urob Deabide ngo. Wo dhiil tiihj ke luub anaa agweed yi kitaab Juog ke nying ngaa uluuny kar Juudo. ");
INSERT INTO lwo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Ngahda ngo ngahyu e gihn agweed yi kitaab Wahy Apoong Juog naa agweede naa, ‘Beehn tiihye wiie wa kaa araanye ngo.’ Kedea gihn anaa agweed naa, ‘Beehn puohdhe yiide,’ ngahda ngo ngahyu thiow! ");
INSERT INTO lwo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Beer nea neehn gihn nu e kea dhiilo dhaano acielo ke kwanyo me puohny yi lum gihn acahr Jeacuue yihr nyoge. Dhaano maa anudo ke won yi waahdh Jeacuu Ruohdh naa athube ke cahng anaa abeehn Joone ucube piih luogwahy yihr Jeacuu uwahdhe cahng anaa atihng Juoge ngo Maalo.” ");
INSERT INTO lwo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Batiene e nyoge ariow akwahny gene ke oogo, Jocebe Barcaabaj, kedea Mathiia. ");
INSERT INTO lwo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Maa akwaj gene Juog kob gene, “Juog yih ge Ruohdh wan ni, ge ngahy giih nii cwihny nyoge beehd, nyoadh ngaan akwanyi kiin yaa ni ariow yihr wan. ");
INSERT INTO lwo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Beere ngaan ngo mahd yihdh jo oohr kar Juudo naa a'aay bang wan uyoade gihr wiihe.” ");
INSERT INTO lwo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Maa athoohr gene gaay ne kwany dhaano acielo kiin yaa ni ariow. E Mathiia e naa akwany ke gaay umade ke bang jo oohr ge anahg apaar wonge acielo, udoohng gene naa apaar wonge ariow. ");
INSERT INTO lwo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Batien nihn apaar naa atihng Jeacuu Maalo, e jo waahdh Jeacuu ke kar gen cang ge anaa ka maa acielo yi wod me duohng. Cahng ngo anahg yaan Cahng Wahy Juog ge cuohn gene ne Paajkwa. ");
INSERT INTO lwo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Yi cahng nu, ke nyango, e duol ake lihngo wa ngoar deeh yamo me duohng. Maa abeehn duole upaahnge yi wod ne peg. ");
INSERT INTO lwo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kaano e gihn me wa leeb maaj aniid gene niido e wudh gen akiire ne kar naa acielo acielo. ");
INSERT INTO lwo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ubeehn Wahy Juoge uyaahnge gen ke tee gihre. Noono ubeehn gene oogo yi wod ne ci bang nyoge, uthub gene ke kaano ke rob keehd dhow me thoohdh, e ngaan rob kwaad kaa acub Wahy Juoge yihre. ");
INSERT INTO lwo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","11","Yi geen Jeruucalem, ge beehda geen Judea, Judea maa amag lum Juog ne cohg ge anudo. Ge anaa abeehn Jeruucalem ke bang wudh geedh ungoom ne yug giih kweehr yihr Juog. Ge abeehno kaa wudh pinye mooge. Mooge ge abeehno kaa yoohn Paarthyan maa Mede kedea Elamaad maa Mecopotaamya. Mooge ke yoohn Judea maa Kapadoacya kedea Poantuj maa Aacya. Mooge ge abeehno kaa yoohn Priigya kedea Pampiihlya. Nyoge mooge keew gen ge abeehno kaa yoohn Micihr kedea kuohn Liihbya ge cahng ke Ciriihna maa Roama. Nyoge me thoohdh thiow ge anaa abeehno naa alihng gene doohn nyoge. Abea naa awahdh gene, e wudh ge ake riihr bang gihn kwaad dhaano giih rob jo waahdh Jeacuue ge lihng yihre wa ge rob kaa dhe paar gen. Noono maa agaahy gene uteeng gene thaahdh gen teengo kob gene, “Wa yaa ni rub kan ge yaa dom Gaalili! Ge kuu akuong beehdo wudh geedhe giih abeehno ke yihdh gen! Dhe paaro ayoad gene ke kee? Dhogo, wo yaa Judea! Kedea dhog yaa alog rog gen udoohng gene ne Judea ke yoohn ka wuor gene Juog!” ");
INSERT INTO lwo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wa kwaad kaano ariihr wudh nyoge nu, e ge ake thubo ke piehj ke rog gen kob gene, “Juog daahd gihn ke tiihyo yihr nyoge?” ");
INSERT INTO lwo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Abea nyoge mooge ge ake rubo, e ge ngier jo waahdh kob gene, “Ge beehda nyoge maa amuohl koonge.” ");
INSERT INTO lwo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kaano e Piihter anyiig buud nyoge, en maa joe ge apaar wonge acielo ni. Utihnge duone maalo uthube ke rob kobe, “Wu yaa Judea giih abeehno ke kuohn mooge maa wu yaa beed geen Jeruucalem ni, lihngu gihn. Beeh teeda yi lum gihn ni atiihy ree yihru. ");
INSERT INTO lwo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wa ge niidu kan ni, padh muohl e naa amuohl wane keehd kuong, wa kwaad ka rob nyoge mooge ngo keewu. Wa piny poohd ngej kedea cahng kuu aleehdho! ");
INSERT INTO lwo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wa kuu amuohl. Gihn ayug ree rog wan beehda Wahy Juog e naa ayaahng wan ke tee gihre. Gihn acoon ge anaa arob Juoge yihr nyoge ke duon ngad agamloohnge me nyinge Jooel ngo ngahyu. Gihn nu e naa athob ree ke yugo tihn noon ni. Juog anaa koohbo yihr Jooel kea, ");
INSERT INTO lwo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Gihn e naa gihn uyuga nea Ngad Boadh nyoge beehne acahngo. Wahy Juog ucuba yihr nyoge cang. Nyedhoohy kedea nyetheamaahn giihu lum Juog uteed gene wa mar yaa agamloohngjuog. Yaa rihj maa ukiihye giihu Juog lume unyoadhe yihr gen yihdh laahg. ");
INSERT INTO lwo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Adiehr muon keehd yaa ayiih luma, cuow kedea maahn teega ucuba yihr gen thiow yi nihn nu beere giih aroba ge teed gene teedo yihr nyoge wa mar yaa agamloohngjuog. ");
INSERT INTO lwo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kwaad giih me gaahy nyoge uyuga yey maalo uniid gen. ");
INSERT INTO lwo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wong cahng ke ngude ree uloge udoohnge ne muudho. E wong dwaahy thiow ree uloge kwaar udoohnge wa remo. Giih ni rog gen uyug gene umodho nyum Cahng Duohng e beehda Cahng Juog, cahng gug piny. ");
INSERT INTO lwo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Abea umodho e nyoge me reje ge poohd kaa kihmo, e Wahy Juog uoohra beere yaa ukahl Wahy Juoge banga kar boadh wahy gen yoad gene yoado.’ Giih nu ge naa ateed Jooele. ");
INSERT INTO lwo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Wu yaa Yijarael, lihngu giih teeda. Wa yaa rubo yihru ke dhogu wa daahd ngo udoohngu ne yaa batien Jeacuu. Ngo ngahyu kejea Juog e naa aoohr Jeacuu yihro. Ngo ngahyu thiow kejea Jeacuu abeehno kaa yoohn bang Juog bang gihn Juog en naa ameehg Jeacuu thiehdh nyoge kedea e naa ameehg ngo tahng nyoge maa thow. Giih doong ge gaahy nyoge ge ayug Jeacuue kan yi geen Jeruucalem e ge uneehno yi nyingu. ");
INSERT INTO lwo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Anahg Juog e naa aoohr Jeacuu bangu maa akweer jo doong Judea keehde kedea ubeehn gene udog gene ngo ke cubo yi cing aleye maa abeehne ne gur ngahy yaadh maa ariihw ne thoo. Gihn raaj e tiihy gene ngo angahy Juoge bang gihn e naa agwiir ngo coon wa kaa agweehge. Agweehge kejea Jeacuu uthow ke dhe yoohn nu beere gihn me beer ke yoado. ");
INSERT INTO lwo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Abea Juog Jeacuu abeehne ne tahngo naa athowe bang gihn Juog adaahd uduu wahye ree beere ngo be doohng ne maabuuj gihr thoo, thoo e raaj. ");
INSERT INTO lwo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Luub arob Jeacuue ke nying thone ge anaa agweed Deabide coon yi kitaab Wahy Apoong Juog. Agweed Deabide kea, ‘Ngahyo kejea Juog ngad boadh won ngo utahnge nea athow. Bang gihn ateed Jeacuue kea Juog be baahr ke buude. ");
INSERT INTO lwo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","En naa gihn beehde e cwihnye med kedea e lwahr tooro ree. Abeehdo e ngo ngahy Jeacuue kejea keehd me thowe e ngo umeehg Juoge cahro. ");
INSERT INTO lwo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bang gihn kare tooro umeehg Juoge kuohme tobo yi liel. Kuohm ngaa maa amag lume ne cohg be weehge kwaahl. ");
INSERT INTO lwo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Adiehr muon, Juog gaahn Jeacuue gaahno kejea ngo umeehg Juog cahro keehdo kedea ukedhe ngo Paare ka ubeehd Jeacuue ke mihn cwihny me duohng.’ Ge naa giih arob Jeacuue ge agweed Deabide yi Wahy Apoong Juog. ");
INSERT INTO lwo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Jo paar wan, adiehr dhiila kaa teedo. Deabid kuowo naa acoon athow ukoanye piny yi ngoom. Liene poohd nud kan keehd won uwahdhe cahng tihn. ");
INSERT INTO lwo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Deabid anaa anahg agamloohngjuog naa apoohde e kuow, abeehdo e giih anaa arob Juoge yihre ngahye. Anaa arob Juoge kejea, ngad dhe wod paare uyuge ne ruohdh alaam kwaar neehn mar Deabid. ");
INSERT INTO lwo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Deabid anaa arubo ke nying gihn utiihy ree wong maalo ke nying cahr Ngad Boadh nyoge kejea, ‘Jeacuu buu uwii Juog kur nyoge maa athow, e kuohme buu meehge tobo.’ ");
INSERT INTO lwo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Jo paar wan, kaa ya, ngaan atahng Juoge yi thoo beehda Jeacuu. Ateeda yihru kejea Jeacuu ngo acahr, bang gihn ngo aniid wane ke nying wan batien kaa acahre. ");
INSERT INTO lwo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jeacuu bade atihng Juog Wahne maalo maa acube ngo ukwiihye kedea ucube Wahy Juog yihre wa kaa anaa akobe ngo coon umodho. Giih niidu ke nyingu kan awaahn ni kedea kwaad giih alihngu ke yihdhu thiow, beehda Wahy Juog e naa awuoj Jeacuue wudh wan, e naa meehg wan rob ke dhow thoohdh. ");
INSERT INTO lwo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Deabid kuu anaa aci Maalo, abea ngo ateede kejea yi laahg, Juog aniide e urubo yihr Jeacuu kejea, ‘Piihi ukwiihya kan, ");
INSERT INTO lwo_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","uyuga yihn ne ruohdh lug yaa wiih ngoom.’ ");
INSERT INTO lwo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Yaage, adaahd ungahyu ngo beer mee kejea Jeacuu Ruohdh e naa ngaa aoohr Juoge ne boadh won kedea adaahde ungahyu ngo kejea gihn me raaj atiihy jo doonge giiho naa anahg gene ngo. Abea Juog kuu atiihyo ke tiihy jo doonge giiho. Juog Jeacuu acube wiih koom ne ruohdh yaa ungoom.” ");
INSERT INTO lwo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Naa lihng nyoge giih ni arob Piihtere, e wudh gen anaa acohd maa apeehny gene Piihter maa jo oohr kejea, “Jo wan lumu alihng wane abea yug wane gihn?” ");
INSERT INTO lwo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","E ngo abeehr Piihtere beehro kea, “Beehn dhaane rahny cwihnye bang anyoohne giihe naa atiihye beere piih luogwahy ke cubo yihre udoohnge ne ngad Jeacuu Ngad Boadh nyoge. Arumo e anyoohne giihe cang ge wii Juoge ke piny yihre. E thiow beere muuny Juog ge beehda Wahy Juog yoade yoado. ");
INSERT INTO lwo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Juog coon umodho anaa arubo kejea Wahy Juog ucube yihr yaa acuohne bange. Juog awaahn ni, wu acuohne kejea beehnu bange, wun maa nyethenu kedea keehd yaa beed wudh geedh bahye.” ");
INSERT INTO lwo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kaano arumo, e Piihter giih me thoohdh ge arobe yihr nyoge ke nying Jeacuu. Ateede kejea Jeacuu e naa Ngad Boadh nyoge. Batiene e ngo arubo thiow yihr gen teeg mee kejea tiihy gene kaa lum Jeacuu. Noono maa agooye wudh luube piny kea, “Konyu rogu ubahnge gihn me raaj wu be yoade neehn mar yaa tiihy giih anyoohne.” ");
INSERT INTO lwo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nyoge me thoohdh lum Piihter abeehn gene ne yiiho, noono maa acub piih luogwahy yihr gen. Cahng nu nyoge alihbe adahg wudh gen awuoj piih luogwahy. ");
INSERT INTO lwo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ubeehd gene beehdo e ge puohny jo oohre puohnyo maa e ge ubeehdo beer mee ke rog gen ke nywaag amono wa kaa anyoadh Jeacuue ngo yihr gen maa ne cong wudh gen ka maa acielo ne kway Juog. ");
INSERT INTO lwo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yihdh nihn nu, jo oohr nyoge na thiehdh gene thiehdho kedea kwaad giih mooge maa agaahy nyoge ge na tiihy gene tiihyo. Ke nying gihn nu e Judea mooge ge adoohng e jo waahdh Jeacuu ge be dhahl gene. ");
INSERT INTO lwo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yaa ayiiho cang ge na ubeehdo tiehd maa giih ne yihr gen ge na nywaag gene nywaago. ");
INSERT INTO lwo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Noono nyoge mooge kiin gen giih anaa yihr gen, ge na ngeew gene ke oogo upaahng gene ngiihny ke rog gen ubeehn dhaane ukaabe ke nye kar mare naa adaag yihre. ");
INSERT INTO lwo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Noono ubeehde e ge uroohmo ke nying nihn yi diih laaro mar Wod Juog gihr Jeruucalem. Kedea ke nywaag amono tiehd ke bang yihdh miehy gen ke mihn cwihny yi koohdh gen. ");
INSERT INTO lwo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Thiow e ge ubeehdo e ge muohj koohr Juog maa nyoge cwihny gen med rog gen thiow. Wa maano e nyoge me thoohdh maa ayiiho ge mahd bang gen ke nying nihn. ");
INSERT INTO lwo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Cahng man e cahng alaahngo kar caang kwaj, Piihter kedea Joon ge anaa acaa yi laaro gihr Wod Juog gihr Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Naa awahnh gene buud Wod Juog e dhaano maa anyuol e tiene adwaany aniid gene niido dhe baab oaj me ne yi dwaar, e ngo apiih. Anahg kare me na kwaaye kaa cub yea beere ngo ukwahyo yihr yaa beehn yi laaro gihr Wod Juog Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Naa aniide Piihter maa Joon e ge caa yi laaro gihr Wod Juog, e cinge athaange thaango yihr gen e kwaj gen. ");
INSERT INTO lwo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Maa atal nying gene ne maany nyin, noono maa akoohb Piihtere yihre kejea, “Luu wongi bang wan.” ");
INSERT INTO lwo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","E nyin wonge aloge ke bang gen ne maany gihn ucub gene yihre. ");
INSERT INTO lwo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Maa acahg Piihtere rob yihre, “Ngiihny me cuba yihri tooro. Abea gihn nud yihra ucuba yihri. Ke teeg Jeacuu Kriihjto, ateeda yihri kejea aj maalo ucaahdhi.” ");
INSERT INTO lwo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Umag Piihtere bad kwiihye ukonye ngo ke yedh maalo wudh tiene. Ke wong kaano e tiene naa anaa abaahl ge ake doohng teeg urome waahdh. ");
INSERT INTO lwo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Noono ucuunge wudh tiene ne cohg kedea uthube thubo ke waahdh. Ucidhe yi laaro gihr Wod Juog keehd gen e ngo muohj koohr Juog kedea e caahdh kaa waahdh ngaa me cwihnye med. ");
INSERT INTO lwo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Amahr yaa anudo nyin aniid gene e ngo ucaahdho e ngo muohj koohr Juog. ");
INSERT INTO lwo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Naa angey gene ngo kejea beehda nyin na piih dhe baab, e ge ake gaahy kedea uriihr wudh gene yi kwaad gihn ayug ree rih nyin. ");
INSERT INTO lwo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","E nyin angeehr batien Piihter maa Joon ucidhe ke gen kar Aar Caloamon ka kwahy yaa yiihoe yea. Naa aniid nyoge gen, e ge ake gaahy keraahyo maa agoohd gene kaa amahd yaa ayiihoe yea e thaahdh gen teeng gene teengo. ");
INSERT INTO lwo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Naa aniid Piihtere nyoge e ake thubo ke rob yihr gen kea, “Jo wan, wa wu agaahy yi gihn atiihy ree ni! Gihn e ne tal nyingu ne maany wan! Nea maru e ngahdu kejea beehda wan cog wa naa athiehdh ngaan anaa abaahle ne! Ka moogo thiow wudhu aparu kejea tee ayoad wane ke nying gihn nahg wane nyoge maa acub rog wan yihr Juog ne! ");
INSERT INTO lwo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Adiehj yi gihn atiihy ree e man: padh wan, wa naa athiehdh nyin. Ngaa athiehdh ngo beehda Jeacuu ke ngude. Ngo athiehdh bang gihn Juog, ge kuow, bad Waahde atihnge maalo naa acube teeg tiihy giih me gaahy nyoge yihre. Abea jo doong Judea ge akweer ke Waahd Juog maa apahdh gene rih ngo uteel gene ngo nyum Paantuj Pilaato ruohdh. Naa akoohb Pilaate kea Jeacuu lonye lonyo bang gihn awuohj maa ayoade rih ngo tooro, e lum Pilaato amaan gene kob gene Jeacuu be daahd gene. ");
INSERT INTO lwo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jo doonge ge adaahd ubeehn Pilaate unahge Jeacuu! Jeacuu ge Juog ke ngude e naa aoohr ngo ni! Ngaa me kihd awuohj maa atiihye tooro! Naa akoohb Pilaate kea Jeacuu lunye ke oogo, e ge ake kweer kob gene nahge ke Jeacuu e ne nahg abea ngaa me raaj maa anahg dhaano e ne luny Pilaate oogo. ");
INSERT INTO lwo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Beehda jo doonge giihu ge naa anahg ngaan nyoadh dhe yoohn kuowo yihr nyoge. Abea Juog kuu atiihyo ke kwaad tiihy gen noono. Ngo ameehg Juoge cahro naa athowe. Wa naa cuude giih aniid Jeacuu ke nying wan batien kaa acahre. ");
INSERT INTO lwo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Lum teed wane yihru e aman: nyin ni, beehda Jeacuu e naa athiehdh ngo. ");
INSERT INTO lwo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Jo wan, gihn atiihyu naa anahgu Jeacuu gihn ni yea ngo kwihyu. Abea jo doonge giihu nahg Jeacuu anaa acub gene yi cwihny gen. ");
INSERT INTO lwo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Juog coon umodho ngo anaa ateede yihr yaa agamloohngjuog kejea, ‘Ngad Boadh nyoge udhiil thoo.’ E naa kaa abeehn lum Juog upahdhe kare wa kaa adaahde. ");
INSERT INTO lwo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jo paar wan, nea neehn maano e kea maanu anyoohne giihu naa ayugu maa yiihu ngo kejea Jeacuu e naa ngaa aoohr Juoge. Noono e anyoohne giihu ge uwii Juoge piny yihru. ");
INSERT INTO lwo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Wa gihn nu e kaa ugwiiru rogu ne koar beehn Jeacuu Kriihjto. Ngo uduu bang gihn e naa ngaa akwany Juoge coon ne Ngad Boadh wun. ");
INSERT INTO lwo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jeacuu dhiil beehdo Maalo kun ca, uwahdhe yi cahng ubeehn nyepinye cang uduog Jeacuue gen kar gen ne dug, wa kaa anaa ateede ngo coon keehd leehb yaa agamloohngjuog. ");
INSERT INTO lwo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moaje anaa arubo thiow kejea, ‘Juog ge Ruohdhu ni, ngad paaru uoohre naa agamloohngjuog wa kaa aoohre an. Dhiilu luub urobe yihru ke lihngo. ");
INSERT INTO lwo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kwaad ngaan ukweer ke yiih lume ukoy oogo kiin yaa Juog urwaahny wonge.’ ");
INSERT INTO lwo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ngahda yaa agamloohngjuog cang uwahdhe Camweel maa yaa abeehno ke batiene ge anaa arubo kaa nying beehn Jeacuu ge beehne ne boadh won ne? Dhiilu lum gen ke lihngo. ");
INSERT INTO lwo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Yaage kaa ya, beehda gihr ngudu awaahn ni, uyiihu lum Juog bahng gihn giih ateed Juoge yihr yaa agamloohngjuog ge ngahyu kedea bang gihn anahg yaa tien paaru ge naa amad lubo ke Juog. Paru wudhu yi gihn anaa arob Juoge yihr Abraahm naa akoohbe kea, ‘Nyoge cang ne dug ungoom kan ge udooja kaa dhe yoohn kwaayi.’ ");
INSERT INTO lwo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","En naa kaa abeehn Juoge ukwanye ngaa na tiihyo yihre noono maa aoohre ngo yihru umodho ne dooj wun nea kwaad dhaano giih anyoohne ge wiie wiio.” ");
INSERT INTO lwo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Kaano arub ge Piihter maa Joone yihr nyoge, e yaa lam giih kweehr giih nyoge yihr Juog ge abeehn bang gen. Ge abeehno e ge caahdh kaa Caaduucean kedea kapten gihr acaakere giih Wod Juog beer ge Piihter ge kwahg gene ke piny. Cwihny gen arahnyo rog jo oohr bang gihn ge urubo yihr nyoge kejea, “Jeacuu acahr adiehr muon.” ");
INSERT INTO lwo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Maa abeehn gene umag gene Piihter maa Joon unyoal gen yi karkoohn uwahdhe kaa aniihn gene yi ngo bang gihn cahng anaa yuudho. ");
INSERT INTO lwo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Abea keehd maano amag gen nu e nyoge me thoohdh luub Piihter naa arobe, ge alihng gene beer mee maa ayiih gene lum Juog. Noono udoohng akuud cuowe naa ayiiho ne kar nyoge alihbe abiihj. ");
INSERT INTO lwo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Ruuwow e Anaj kedea Kaaypaj, ge beehda jo doong yaa lam, wiih amaad gihr Akuud Judea ngo ayab gene. Joon maa Alekjander ge anudo thiow. Ge anaa anahg jo doong yaa lam coon. Waahd Kaaypaj maa Joon kedea Alekjander ge anudo. ");
INSERT INTO lwo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Maa akahl Piihter maa Joon nyum gen maa peehny gen duug naa, “Wun! Kobu wu naa athiehdh nyin abaahl ne! Kobu dhaano nud maa acub tee me thiehdh nyoge yihru! Beehda ngaa e naa arom tee nu ke cubo yihru?” ");
INSERT INTO lwo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Gihn nu arumo e Piihter dhog gen abeehre beehro beer mee ke nying tee gihn acub Wahy Juoge yihre kea, “Wu ruohdhe kedea wu jo doong paajo ");
INSERT INTO lwo_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ngahda wa peehnyu kaa nying kwaad gihn beer atiihy ree rih nyin tiene abaahl ni kedea ke dhe yoohn athiehdh wane ngo kii ngo? ");
INSERT INTO lwo_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nea wa peehnyu kaa nying giih nu e kea beeh teeda ngo yihru kejea, nyin athiehdh kaa tee maa abeehno kaa bang Jeacuu Kriihjto! Cwihnya ne bange ungahyu ngo wu yaa Yijarael ke karu cang kejea nyin beehda Jeacuu e naa athiehdh ngo. Wu jo doong paar wan, Jeacuu Kriihjto ngad Naajaread ngo kuu anaa anhyaaru ne weey weey, ubaru maalo ke tiihy gihn me raaj ree naa aguru ngo ngahy yaadh maa ariihw ne thoo. Abea Jeacuu kuu awii Juoge yi thoo wa kar cwihnyu. Teeda teedo yihru ke lubo maa athiir kejea Juog Jeacuu ameehge cahro ukuowe batien kaa athowe. ");
INSERT INTO lwo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","E naa kaaw gihn akweer yaa geere keehde e naa adoohng ne meehn wod. ");
INSERT INTO lwo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“E thiow yaa beed bang upiny kan cang boadh wahy gen yoad gene kaa nyinge, bang gihn ngaa moogo me nud tooro maa acub Juoge piny ne Ngad Boadh nyoge.” ");
INSERT INTO lwo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Naa aboar yaa akuud Judea Piihter maa Joon beer mee e ngo aniid gene niido kejea ge rubo e lwahr tooro rog gen. Gihn nu e ge ake cwaahng. Abeehdo e ngo ngahy gene kejea Piihter maa Joon ge nyoge me kuu angiiho ke rob nyum nyoge. Abea anaa angahy gene thiow kejea Piihter maa Joon puohny lum Jeacuu ngo acub gene yi cwihny gen ne cohg. ");
INSERT INTO lwo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yaa akuud ge anaa adaahd ukihm gene ge Piihter ke gihn me raaj beere ge be dog rob ke nying tee gihr Jeacuu. Abea angahy gene kejea ngaa athiehdh nud kedea uneehno yihr nyoge maa angahy nyoge thiow kejea tee gihr Jeacuu e naa athiehdh ngo. ");
INSERT INTO lwo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kaano e ngo arob gene kejea beehn yaa ni ci gene oogo udoohng gene ne gweehg ke rog gen. ");
INSERT INTO lwo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","17","Maa aroam gene cwihny gen kejea, “Ngo be daahdo ubeehn rob ke nying Jeacuu unyaaye ke kiin nyoge. Abea ne cohg gihn e ne rom ree ke tiihyo yihro! Gihn e nuu mahn yaa ni ubahnge nyoge be puohny gene ke nying Jeacuu! Kedea beehda ngaa noono e nuu urom ngo ke yiiho yihro kejea yaa ni yihr gen tooro teeg Jeacuu! Ngaa e ne kwihj ngo kejea dhaano athiehdh gene! Nea neehn maano kea ciero ngo yihr gen teeg mee kejea ge keá cahg rob keehdo ke nying Jeacuu.” ");
INSERT INTO lwo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Naa athum gene ke gweehg e Piihter ge ke Joon ge acahg gene kaa cuohno maa teed gene ngo yihr gen kejea, “Keá cahgu ke tumo keehdo kejea wu upuohnyo maa wu urubo ke nying Jeacuu.” ");
INSERT INTO lwo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Maa abeehr Piihtere maa Joone ngo yihr gen, “Wu ne rob gihn athiir nyum Juog yihr wan: lihng wane lum maru ubahnge lum Juog be lihng wane ne? ");
INSERT INTO lwo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kare tooro yihr wan ubahnge wa be rubo ke nying kwaad giih aniid wane ke nying wan kedea kwaad giih alihng wane ke yihdh wan.” ");
INSERT INTO lwo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kob yaa akuude yihr Piihter maa Joon naa lony gen, “Awaahn, wu alony wane. Abea ne dog wane wun ke maa e wu urubo ke nying ngadu noono, e gihn nii ngo uniidu!” Yaa akuud ngo angahy gene kejea nyoge cwihny ge amihno maa ge apiih ne wuor Juog bang gihn aniid gene nyin e ngo athiehdh beer mee. ");
INSERT INTO lwo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Thiow nyoge cwihny gen amihno upuoj gene Juog bang gihn nyin athiehdh anahg ngaa me duohng me rune jiehariow ubar wonge. ");
INSERT INTO lwo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Batien kaa alony Piihter ge ke Joon e ge adog bang yaa gen, uteed gene gihn arob yaa akuude yihr gen ");
INSERT INTO lwo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kaa alihng jo yiihoe giih arob Piihtere maa Joon, e ge apiih ne kway Juog ke cwihny gen acielo kob gene, “Juog Ruohdh, teegi e ne kaal wudh giih nyepinye cang, bang gihn yih naa acag maalo ke piny maa nahme kedea giih ne yihdh gen cang. ");
INSERT INTO lwo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wa e niidi kan ni wa ne yi gihn me teeg bang gihn yaa akuud ge daahd upuohd gene wan. Gihn teeg e yoad wan ngo uroomo ke gihn teeg ge anaa ayoad ngadi Deabid ge beehda kuow wan me duohng. Lume naa arobe ngo ngahyi naa akoohbe kea, ‘Amahr tien paajo cwihny gen arahnyo rih Juog kedea ge daahd umaahd gene ngo. Ngahda ge nyoge me wudh gen tooro ne cohg! ");
INSERT INTO lwo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ngo apar amahr ruohdhe giih tien paajo kejea Juog rom gene kaa taayo yi liny. Ge daahd unahg gene Ngad Boadh nyoge.’ ");
INSERT INTO lwo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","E naa gihn koohb wane kejea gihn ayoad wane wa gihn arob Deabide. Bang gihn, gihn arob Deabide ngo anaa apahdh kare yi geen Jeruucalem naa abeehn Eroade ruohdh maa Pilaato ubeehn gene keehd acaakere ne mag Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yaa akuud ge adaahd unahg gene Jeacuu ne daahd dhe yoohn liny ke yihn. Abea keehd maano atiihy gene gihn nu raaj nu, e ngo anahg yihn naa agwiir ngo wa gihn nu coon beere gihn daahdi yug gene yugo. ");
INSERT INTO lwo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Juog beehn ne kony wan. Giih reje ge daahd yaa akuude ke tiihyo rog wan, nea wa urubo ke nying Jeacuu, ge ngahyi. Wa beehda yaai maa aoohri, cub teeg aduulo yihr wan beere wa urubo e lwahr tooro rog wan. ");
INSERT INTO lwo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Cub tee yihr wan uthiehdh wane nyoge kedea cub ngo yihr wan beere kwaad giih ni teeg ge gaahy nyoge rog ge yug gene yugo beere ngo ngahy nyoge ngahyo kejea yih naa akwany Jeacuu.” ");
INSERT INTO lwo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Naa athum gene ke kway Juog arumo e kaa anaa apiih gene yea ni ree ayahnge yahngo une piny med medi upahng koohm gene keehd Wahy Juog. Noono e ge ake thubo ke puohny lum Juog keehd teeg cwihny, e lwahr tooro rog gen. ");
INSERT INTO lwo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jo yiiho cang ge abeehdo e rog gen nhyaar gene nhyaaro. Maa ge abeehdo e ge nyoge me lum gen acielo. Keehd maa anahg gene amahr nyoge, e ngaa maa ngad wahro me cwihnye diiw atooro. Bekihd ngaa me rubo kea, “Giih ne yihra ge beehda giiha a keeda.” Bang gihn kwaad giih gen naa anudo yihr gen ge na nywaag gene nywaago ke rog gen. ");
INSERT INTO lwo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Noono e jo oohr ge adoohng ne nyoge me teed ngo kejea, “Jeacuu anaa acahr naa athowe.” Maa abeehn Juoge thiow maa adooje gen cang keter. ");
INSERT INTO lwo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Gihn maa acahg daag yihr gen atooro. Bang gihn kwaad yaa yihr gen anaa giih nyepinye ni, keehd wuude ge na ngeew gene ke oogo ukahl gene ngiihny kahlo yihr jo oohr giih Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Noono upaahng jo oohre ngiihny paahngo yihr nyoge cang, e ngaa man kaab nye kaa adaag yihre. ");
INSERT INTO lwo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Dhaano acielo anudo me nyinge Jocebe ngad dhe wod Leabi. Tiene aay ke dom Caaypruj. ");
INSERT INTO lwo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","E Barnaba puohdh mare ke ngude angeewe oogo maa ayoade ngiihny ayoade ucube gen yihr jo oohr. ");
INSERT INTO lwo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nyin moogo anaa anudo me nyinge Anaanya maa ciihe Capiira. Naa aniid gene nyoge mooge e giih gen ngeew gene ke oogo ne kahl ngiihny yihr jo oohr, e puohdh gen angeew gene oogo thiow. ");
INSERT INTO lwo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Goan ngiihny mooge akan Anaanya e ngo ngahy ciihe. Naa abeehne ne cub ngiihny e akobe kobo yihr jo oohr kea, “Puohdha angeewa oogo. Ngiihny ni ge naa ayoada cog naa angeewa puohdho oogo. Kaabu gen ne kony nyoge.” ");
INSERT INTO lwo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Naa alihng Piihtere rob Anaanya e ake rubo yihre kobe, “Anaanya! Yih ngad toohd! Gihn e meehgi rihi dwaahngo yihr atiihb ukeehg adhaahr urobi toohd nyum Wahy Juog? Nea yihn kii kwihj Wahy Juoge e goan ngiihny ge akani! ");
INSERT INTO lwo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","E anaa apoohde puohdho kii ngeew oogo ngahda puohdho anahg gihri ne? E thiow naa angeewi ngo oogo ngahda ngiihny ayoadi ge anahg giihi? Awuoj gihn atiihyi beehda gihn apari ngo kejea Juog romi kaa waalo wa mar dhaano utaahngo me neehn wan!” ");
INSERT INTO lwo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nye kaa alihng Anaanyae gihn arob Piihtere e ngo ake pahdho ne wad uthowe. Yaa aniid gihn atiihy ree ge atud yi tiihy Juog. ");
INSERT INTO lwo_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Noono ubeehn yaa rihje ubahj gene kuohm Anaanya keehd waaro ukedh gene ngo ne koanyo. ");
INSERT INTO lwo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Batien caae adahg e ciih Anaanya acaa ne beehno, abea e gihn ayug ree anaa akwihye. ");
INSERT INTO lwo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Maa apeehny Piihtere ngo kobe, “Capiire, teed gihn maa athiir yihra ne cohg. Beehda ngiihny ni ge naa ngiihny ayoadu naa angeewu puohdho oogo?” Maa abeehr Capiire ngo kobe, “Ayiih, ge naa kar gen noono cang.” ");
INSERT INTO lwo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kaano e Piihter acahg rob yihre kobe, “Gihn ne cohg uyoadu Wahy Juog upelu yea wu ke cuori? Yaa rihj naa anaa aci ne koany cuori ge aman aduuo. Yih kedh gene ke ne koanyo awaahn ni thiow!” ");
INSERT INTO lwo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ke wong kaano e ngo anaa buohb piny ke pahdho nyum Piihter, abea e naa thone noono. Ucahg yaa rihj giih atudo ngo kaa tihngo ne koanyo buud cuore. ");
INSERT INTO lwo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Naa alihng gihn atiihy ree, e deeh lwahr me duohng ke nying gihn ayug Juoge ngo apahdh rog nyoge cang, yaa ayiiho kedea nyoge me padh yaa ayiiho. ");
INSERT INTO lwo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","14","Yihdh nihn nu e yaa ayiiho cang ge na kwaay mahdo ka maa acielo yi Aar Caloamon kar kwaj gihr gen. Yihdh nihn nu thiow e jo oohr kwaad giih mooge me thoohdh me gaahy nyoge ge na tiihy gene tiihyo. Jo oohr keehd me na puoj nyoge gen, e bekihd ngaa me tahr ngo ke toohd kea e beehda ngad gen. Noono unahge ke ngaa ayiih lum Jeacuu e ne mad gene bang gen. E naa kaa abeehn cuow maa maahn me thoohdh udoohng gene ne yaa ayiiho yihdh nihn nu thiow. E jo oohr kwaad giih mooge me thoohdh me gaahy nyoge ge na tiihy gene tiihyo. ");
INSERT INTO lwo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Bang gihn jo oohr giih me gaahy nyoge na yug gene yugo, e naa gihn abeehn nyoge ukahl gene yaa atwaany dhog yiehdhe ne piehl piny. Nyoge apiehl yihdh yiehdhe beere nea Piihter ukahnho ke kaa ngo e tube ucidho ke wudh yaa atwaany. ");
INSERT INTO lwo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nyoge me thoohdh me beed ka me cahng ke geen Jeruucalem ge anuno e ge bien nyoge maa atwaany kedea e ge piej yaa rog gen anaa atiihb ukeehg. Jo nu cang ge athiehdh. ");
INSERT INTO lwo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kaaypaj kedea yaae ge cuohn ne Caaduucean cwihny gen arahnyo ke nying gihn abeehn nyoge me thoohdh uyiih gene puohny jo oohr. ");
INSERT INTO lwo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Noono umag gene jo aoohr ukedh gene gen yi karkoohn kar nyoge maa now. ");
INSERT INTO lwo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Abea yi diehr waahr, e wuohnjuog dhog wuude giih karkoohn ayabe ukoole jo oohr naa amag oogo. Maa arube yihr gen, ");
INSERT INTO lwo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Cidhu yi laaro gihr Wod Juog ubaru maalo ke puohny wa kwaad kaa acoon. Rubu ke nying Jeacuu ngaa cub kuowo me guge tooro yihr nyoge.” ");
INSERT INTO lwo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Lum wuohnjuog ayiih jo oohre. Ke nyango coon e ge acaa yi laaro ne puohny nyoge. Kaaypaj maa yaae, jo doong Judea yaa akuud ge acuohn gene beere ge umahdo. Batiene e lubo arob kejea kahl jo oohr nyum gen. ");
INSERT INTO lwo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Abea naa awahnh acaakere giih aoohr yi karkoohn e jo oohr ge kuu ayoad gene. Noono udog gene ne teed gihn atiihy ree kob gene, ");
INSERT INTO lwo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Naa acidh wane, e dhog wuud karkoohn cang ge ayuud wane e ge atoag ne dihng dihng kedea yaa koar ge ayoad wane ke kuohn gen. Abea naa ayab wane dhog wuude, e gahng ke dhaano acielo kiin jo oohr maa ayoad wane.” ");
INSERT INTO lwo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Naa alihng jo doong yaa lame ngo e wudh ge anaa cohd ke gihn atiihy ree. Kapten ge wiihe ne karkoohn ngo agaahy thiow ke kaa a'aay jo oohre kii ngo. ");
INSERT INTO lwo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nye wong kaano e naa arub dhaano mooge yihr gen kobe, “Yaa anaa amagu ne waahro, ge anaa akedhu yi karkoohn, ge ne cuudi puohny nyoge yi laaro ke kwaad giih gen noono.” ");
INSERT INTO lwo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kaano e kapten ake cidho keehd acaakere ne kahl jo oohr nyum jo doonge. Ge akahl gene e cingo kuu ajag rog gen, bang gihn kapten ngo atud ke wahye maa wahy acaakere giihe ka moogo e ge maahd nyoge maahdo. ");
INSERT INTO lwo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Naa akahl gen ne cuungo nyum yaa akuud, e ge apeehny Kaaypaje kea, ");
INSERT INTO lwo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ngahda anaa amahn wane yihru kejea wu keá cahg puohny ke nying Jeacuu? Awaahn ni yi geen Jeruucalem ngo amoru ke puohny gihru kedea ngo akedhu yi wudh nyoge kejea rem Jeacuu naa yi cing wan!” ");
INSERT INTO lwo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Batiene e Piihter arubo ne jaahy giih arob rog gen kobe, “Jo doonge, adiehr muon ateedu yihr wan kejea wii wane puohny lum Juog. Abea ateed Juoge yihr wan kea puohny wane lume. Nea maru, e lum ngaa e ne tiihj! Lumu wale lum Juog? Nea mar wan e lum Juog e ne tiihy wane keehde abea padh lum dhaano utaahngo. ");
INSERT INTO lwo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Anahg wun naa anaa amag Jeacuu uguru ngo ngahy yaadh maa ariihw. Wu naa anahg ngo. Abea Juog e naa anaa atahng ngo naa athowe. ");
INSERT INTO lwo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wiihe atihng Juoge maalo ucube ngo ukwiihye ne ruohdh me e ne boadh nyoge, beere wo yaa Yijarael dhe yooh yoado yoado me maano anyoohne giiho. Noono e Juog anyoohne giiho ge wiie ke piny yihro. ");
INSERT INTO lwo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Giih nu ge aniid wane ke nying wan kedea uthub wane ke teed gen yihr nyoge. Juog thiow Wahy Juog awuoje wudh wan ne muoj wan ke tee me thiehdh nyoge bang lum Juog ayiih wane. Tee ngo aay ke bang Juog ke ngude. Nea neehn maano kea dhiilu lum Juog ke yiiho.” ");
INSERT INTO lwo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Naa alihng yaa akuude lum arob Piihtere e cwihny gen ake rahnyo ne cohg ukoohb gene kejea nahg jo oohr. ");
INSERT INTO lwo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Abea dhaano acielo kiin gen me nyinge Gamaliel a'aj maalo. Ngo anahg ngad Paarijea kedea anahg ngad puohny loohng Moaje. Gamaliel anahg ngaa me lume ke wuoro. Gamaliel a'aj maalo maa arobe ngo kejea meehg jo oohr ci oogo beere ngo urubo. Naa aci gene oogo ");
INSERT INTO lwo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","e ake thubo ke rob kobe, “Wu ruohdhe maa yaa Yijarael, coaru wudhu beer mee, e gihn daahdu ke tiihyo puud kuu atiihyu. ");
INSERT INTO lwo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yi run maa abar nyin me nyinge Thoadaj anaa apaahr maalo kea e ngaa moogo me teeg. Nyoge kar jiehabiihje angween rog gen anaa ayug gene ne yaa batiene. Abea naa abeehne ne naah e yaa batiene ge akeedho cang utoor gihn maa acahg ke lihngo ke nyinge. ");
INSERT INTO lwo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Batien Thoadaj, e ngaa moogo adog tuohl me nyinge Juudo ngad dom Gaalili. Nyin anaa atuohl yi wong anaa ayug akweehn gihr nyoge. Yihre anaa nyoge thiow maa yaa batiene. Abea naa anahge e yaa batiene ge akeedho. ");
INSERT INTO lwo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Abea yi gihn nahgo yea awaahn ni, teeda teedo yihru kejea wiiu gen uaay gene. Bang gihn nea gihr gen noon ni tahr gene beehda tiihy ngaan cuohn ne Jeacuu e gihr nyinge utooro. ");
INSERT INTO lwo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Abea nea beehda tiihy Juog e ngo buu urom ree ke leehwo yihru. Adhaahr e rogu e nuu uyoadu e wu keehg kaa Juog.” Kaano e lum Gamaliel alihng gene abea padh ke cwihny gen cang. ");
INSERT INTO lwo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Noono e ngo amad gene kejea puohd jo oohr abea gihn maa arob ke nying naahg tooro. Kaano e jo oohr ge adog ke cuohno maa apuohd gen kedea urobe yihr gen kejea ge keá cahg puohny ke nying Jeacuu keehdo. Batiene e ge ake lonyo. ");
INSERT INTO lwo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Naa a'aay jo oohre kar amaad e ge a'aay e cwihny gen amihno. Cwihny gen amihno bang gihn ge aniid Juoge ne nyoge me rom giih ajohr ke guumo ke nying Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Noono arumo ubar gene ke maalo ke puohny nying Jeacuu ge Ngad Boadh nyoge, ke nying nihn ke bang yihdh miehr maa yi laaro gihr Wod Juog. ");
INSERT INTO lwo_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Yi nihn nu, e nyoge me thoohdh mee ge adoohng ne yaa yiiho. Noono e caame ge na paahng jo oohre paahngo yihr gule giih anudo. Kaano e lubo ake thubo ne moar moar ke piny. Judea giih rubo ke dhog Griihge kiin yaa ayiiho ge ake ngoan kejea gule giih gen giih agunyo ke yugo rog gen. Kob gene yi paahng caame e gule giih gen muoj kaa giih me noog abea gule giih Judea ge abeed Jeruucalem muu gen ge ke cubo beer mee. ");
INSERT INTO lwo_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Gihn nu arumo e jo oohr, amaad abeehn gene ne yugo keehd yaa yiiho cang. Maa arub gene kejea, “Yaage yihdh nihn ni, gule me thoohdh yihr gen tooro gihn me cam gene. Tiihy wane gihn? Wii wane puohny lum Jeacuu kedea unahge caame ge ne paahng wane ne! Ree be rome yugo wa gihn nu. Ngweehn ubar wane maalo ke yug tiihj gihn acub Jeacuue yihr wan. ");
INSERT INTO lwo_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nea neehn maano e wa daahd ngo ukwahnyu ke nyoge kiin nu. Nyoge me ne cohg me beey yi paajo kedea me ngahy yihdh luube beer mee maa me ngahj kejea Wahy Juog ne rog gen. Kwanyu nyoge abiihjberiow beere tiihy paahng caame cub wane kii cing gen. ");
INSERT INTO lwo_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kedea beere wudh wan cub wane ke ne kway Juog kedea tiihy puohny lum Juog yihr nyoge.” ");
INSERT INTO lwo_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yaa yiiho cwihny gen amihno bang lum ni arob jo oohre. Noono ukwany gene nyoge abiihjberiow. Yijtepen anaa kiin yaa abeehn ne kwanyo. Ngo anahg ngaa maa ayiih lum Juog ke cwihnye acielo kedea ree apahng ke Wahy Juog. Thiow maa akwany gene nyoge me ne cohg me wa Yijtepen. Yaa akwany nying gen anahg Pihlihb maa Prokoruj kedea Nihkanoara, Timon, Paarmenaj kedea Nikoala maa adoohng ne ngad Judea ke dhe yoohn wuor Juog. ");
INSERT INTO lwo_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Batiene e ge akahl nyum jo oohr ukway Juog ke nying gen, batiene e cing apiehl wudh gen ne cub gen yi tiihy akwany gen ke nyinge. ");
INSERT INTO lwo_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","E naa kaa abeehn lum Juoge unyaaye kii ngo naa ayiih nyoge me thoohdhe kedea e naa kaa ajwag yaa yiihoe rog gen kii ngo noono. Thiow nyoge mooge kiin yaa lam nyum nyoge yihr Juog Jeacuu abeehn gene ne yiiho. ");
INSERT INTO lwo_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Yijtepen anahg ngaa me yihre anaa muuny Juog ne cohg kedea Juog teeg tiihy giih me gaahy nyoge ngo acube yihre. Noono e giih me doonge me gaahy nyoge ge na tiihye tiihyo ");
INSERT INTO lwo_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Abea Judea maa amag lum Juog ke dhe yoohn Moaje ge akweer ke yiih giih puohnye kejea ge giih toohd. Noono ge na ubuohj ke peehm keehd Yijtepen e ge piem giih puohnye. Yijtepen na koag ke puohny kuohn me thoohdh e upeehmo ke gen. ");
INSERT INTO lwo_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Abea Wahy Juog teeg wong kedea ngahy teed yihdh luube ge acube yihr Yijtepen. Noono e kar piem luube yaa ni ariehnye. ");
INSERT INTO lwo_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Keehd maa ataay Yijtepene gen ke luube, e kihde now, batien Yijtepen kuu awii gene. Noono udhiil gene yihdh nyoge ke coamo beere ge caa ne rob giih toohd rih Yijtepen kejea: “Yijtepen rob giih me reje ke nying Moaje kedea ke nying Juog thiow.” ");
INSERT INTO lwo_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Gihn nu yihdh nyoge acoam gene uwahdhe kaa arahny cwihny gene rih Yijtepen. Noono ucidh gene thiow ne luom ngo nyum Akuud Judea kedea yaa loohng Juog. Gihn nu naa ayoad gene Yijtepen e ngo akwahg gene piny maa akahl gene ngo nyum Akuud Judea ");
INSERT INTO lwo_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","kedea maa akahl gene nyoge ne teed toohd. Noono maa arob yaa ni ngo kob gene, “Nyin dhee be yuohm ke rob ke nying Wod Juog maa ke nying loohnge giih acub Juoge yihr Moaje ne kahlo yihr Judea. ");
INSERT INTO lwo_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ngo alihng wane e ngo urubo yihr nyoge kejea ngad gen ge cuohn ne Jeacuu arubo kea wod Juog ngo utoare piny kedea uwaare ciehng paaro ge anyoadh loohnge giih akahl Moaje yihr ge kuowo. Ngaa me rob kwaad giih ni ngo tiihyo ke ne diih?” ");
INSERT INTO lwo_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Gihn nu e lwaag ke kare naa amahdo nying gen alog gene ke bang Yijtepen. Abea yi maahny amaany gene Yijtepen e nying gen atal ree bang gihn kaan nyinge ake liel wa kaan nying wuohnjuog. ");
INSERT INTO lwo_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Batiene e Ngaa duohng yaa lam Yijtepen apeehnye peehnyo kejea, “Ngo adiehr kejea yih arubo kii Wod Juog utoar Jeacuue maa loohng Moaje ge uwaare ne?” ");
INSERT INTO lwo_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Maa athub Yijtepene ke duog wudh giih arob ree kea, “Yih ngaan duohng kedea wu jo doonge maa wu ge weehw wan, giih arob riha ge beehda toohd. Abea nyingu akwaya ne lihng giih roba yihru ni. Giih ngo ge beehde e ge ngahyu thiow. Juog ge duohng kedea e poong ni be beehdo kii Wod Juog cog. Bang gihn ree keá naa nyoadho yihr Abraahm kii wod kedea ree keá naa anyoadho kii piny ni beedo awaahn ni. Juog ree anyoadhe yihr Abraahm ke piny Mecopotaamya maano e Abraahm poohd kuu anaa abeehn geen Ahran. ");
INSERT INTO lwo_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kob Juoge yihr Abraahm kea, ‘Wii paari maa waahdu piny uaayi. Piny moogo unyoadha yihri.’ ");
INSERT INTO lwo_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Adiehr muon, Abraahm abeehn ne aay Kahldea ubeehne piny Ahran. Ahran e naa kaa athow wur Abraahme yea. Batien kaa athow wahne e ngo abeehn Juoge ne kaabo udaage Abraahm piny gihn beehdo yea awaahn ni. Piny gihn cuohn ne Kanaan. ");
INSERT INTO lwo_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","E naa abeehn Abraahme ne beehdo yi piny ni, e yihre atooro nyethen. Keehd maa atoor yihre nyethen, e ngo anaa arob Juoge yihre kejea piny ucube yihr Abraahm, batiene nea ngo uthoo e piny ngo udoohng yihr nyethene. Piny me buu cahg ke kaab oogo yihr gen. Thiow ge anaa abeehd Abraahme kaano e yihre atooro keehd nye piny me thiin maa acub Juoge yihre ne pinye. ");
INSERT INTO lwo_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Anaa arob Juoge yihre kea, ‘Kwaayi ge uci ne beehdo piny nyoge mooge naa aleye ke kar run jiehabiihje angween. Yaa beed piny nu ge uyedh maalo uyug gene kwaayi ne baahng. ");
INSERT INTO lwo_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Abea a uyedh maalo thiow rog gen uyuga gihn me raaj keraahyo ne lwahg kwaayi. Ge ukahla oogo paan nu ne beehn piny ni ucuba. Unahg piny nu e nuu uwuor gene an yea.’ ");
INSERT INTO lwo_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Juog thoam abeehne ne yugo wa gihr nyoge maa amaadh remo ne nweehd Abraahm maa nyethene ke Juog. Noono e naa kaa abeehn Abraahme uthoame Yijaag waahde batien nihn abiihjbedahg naa anyuole. Ubeehn Yijaage uthoame Jeakob waahde. Jeakob thiow waahde apaar wong ariow, ge beehda ge kuowo, ge athoame. ");
INSERT INTO lwo_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jeakob yihre anaa waahde me nyinge Jocebe. Naa adoohnge ne nyedhoohg maa adoongo e wuud wahn ngo abeehn gene ne tiilo bang gihn kwaad giih teed Jocebe ge kuu apahdh yi cwihny gen. Cahng man, Jocebe akwahg gene piny ungeew gene ngo oogo ne baahng yihr nyoge me caa Micihr. Jocebe adog ke ngeew oogo ne baahng yihr ngad Micihr. ");
INSERT INTO lwo_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Abea Juog wonge keá log oogo rih Jocebe, e beehde kar bahng. Maa abeehn Juoge umeehge Jaah gihr Micihr nhyaar Jocebe ke nying teeg wonge maa ngahy luube naa acub Juoge yihre. Noono uyug Jaahe Jocebe ne ngaan duohng yaa batiene me e ne cong caame me kan ne kony nyoge yi kahj gihn ubeehn ni. Anahg Jocebe e naa anaa teed ngo yihr Jaah kejea deeh kahj me duohng upahdh yi paajo. Kahj muu ubang nyoge ke run me thoohdh. ");
INSERT INTO lwo_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Naa abeehn deeh kahy ngo, e nyoge abange ke bang Micihr kedea piny Kanaan ka beedo awaahn ni. Noono ubang kahje ge kuowo naa abeed Kanaan keraahyo, utoor ka maa ayoad gene cam yea. Abea caame giih acong Jocebe ge anudo Micihr keehd maa atoor gihn maa acieg ke run me thoohdh. ");
INSERT INTO lwo_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Naa abeehn Jeakobe ngo ne lihngo kejea caame ge nud Micihr e waahde, ge beehda ge kuowo naa acoon, ge aoohre Micihr. Naa awahnh wuud mene Micihr, e Jocebe giih waal ayuge ubahnge ree keá teedo yihr gen. Naa ayoad wuud mene caam adaahd gene, e ge ake doog. Caam akahl gene ge e caa ne thumo, e ge adog kahj ke naah. ");
INSERT INTO lwo_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Noono udog Jeakobe waahde ke oohr Micihr keehdo. Yi riown waahdh gen, e naa abeehn Jocebe upahe gen oogo, naa ateede ree. Kaano arumo, e naa beehn Jaahe ne ngahy ngo kejea Jocebe yihre ne wuud men Kanaan. ");
INSERT INTO lwo_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Maa aoohr Jocebe dhog bang wahn kejea, ‘Robu ngo yihr wura kejea beehne en maa yaa paare cang.’ Noono uaay Jeakobe ke nyoge jiehadahg wonge apaar wonge abiihj ne ci Micihr. ");
INSERT INTO lwo_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","E naa kaa anaa abeehn Jeakobe maa waahde ne beehdo piny Micihr noono. Ge abeehdo Micihr ke run me thoohdh uwahdhe kaa agwag gene uthow gene. ");
INSERT INTO lwo_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Batiene e Jeakob abeehn ne thoo naa agwage maa akoany waahde ngo yi piny maa naa angeew Abraahme bang waahd Ahmor. Naa abeehn waahd Jeakobe ne thoo thiow, e ge anaa akoany piny moogo me nyinge Ceacehm. ");
INSERT INTO lwo_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ge kuowo ge abeehdo Micihr ke run me thoohdh mee maa akoad gene keraahyo. ");
INSERT INTO lwo_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Anahg kaano akoad gene keraahyo, e naa aluuny Jaahe mooge wiih koom. Giih beeye ge anaa atiihy Jocebe ge keá lihngo naa athere bang gihn cwihnye atooro ne yug gihn me beer yihr ge kuowo ge beehda kwaay Jocebe maa kwaay ge wuud men. ");
INSERT INTO lwo_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Jaah gihn aluuny wiih koom, giih me reje ne cohg ge atiihye rog ge kuowo. Ge ayuge ne baahng me tiihyo yihre. Thiow cwihnye kuu amedo ke nying gihn athoohnh ge kuowo. Noono maa ateede lubo kejea nea nyethiin cuow me nyuol, e kea thoohre yi naam duohng. Giih rog gen ayug gene wa kaa anaa agweehg Juoge. Anaa agweehg Juoge kedea urobe ngo yihr Abraahm kejea e ubeehn ne lwahg kwaay Abraahm ukahle gen oogo kar bahng. ");
INSERT INTO lwo_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Kaano anaa athoohr nyedhoohy yi naam nu, e naa kaa anaa anyuol kuowo gihn duohng, e nyinge Moaje. Ngo anaa abeehn Juoge ne kwanyo ne gome. Moaje anahg nyedhoohg maa awuob ne cohg, e naa gihn akan ge wahne ngo paajo ke dwahde adahg e ngo be nyoadh gene beere e be thoohr yi naam. “Batien dwahde adahg e ngo agweehg gene maa akedh gene ngo ne kano yaa apaaj dhe naam. ");
INSERT INTO lwo_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kaano e naa abeehn nyaar Jaahe ne yoad Moaje maa akaabe ngo bang gihn ngo anhyaare maa apiidhe ngo ne nyethiine. ");
INSERT INTO lwo_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","E naa kaa abeehn Moaje ucuohne ne kwaar Jaah kii ngo kedea upuohnye wa ka puohny nyethiin ngaa me duohng yi paajo. Noono udoohnge ne dhaano me lume ke wuoro ke nying teeg wonge kedea ke nying ngahy rob. ");
INSERT INTO lwo_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Naa anahg run Moaje jiehariow, e wiihe apare ne liew jo paar gen yaa Yijarael. ");
INSERT INTO lwo_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Naa awahnh Moaje e dhaano acielo ayuude e ngo bang ngad Micihre bango maa abeehn Moaje ne coal kar ngad paar gen uwahdhe kaa anahge Umicihr. ");
INSERT INTO lwo_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ngahda ngo dhiilu kaa ngahyo kejea ngo abeehn Moaje ne ngeyo kejea Juog daahd dhe yooh ke gwiiro unahge en nuu uluny yaa Yijarael oogo kar bahng. ");
INSERT INTO lwo_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ruuwow e Moaje yaa Yijarael kar ge ariow ge ayuude e ge ukag. Noono utume gen ke joago e urubo yihr gen kea, ‘Gihn e ne bangu rogu abea wu beehda nyethea yej.’ ");
INSERT INTO lwo_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“E nyin anaa ne bang wad gen ake kweer ke lum Moaje maa ajwange ngo kobe, ‘Ngaa ne cohg e naa acub yihn nyum wan ne ngaa duohng yaa lam? ");
INSERT INTO lwo_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Yih daahd unahgi an wa kwaad gihn awaahro naa anahgi Umicihr ne?’ ");
INSERT INTO lwo_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Naa angey Moaje ngo kejea gihn anahge Umicihr piny amore, e ngo agoohd piny Midyan ne beehdo keew aleye. Moaje abeehdo kun nu ke kar run me thoohdh uwahdhe kaa anyoohme unyuol ciihe ke waahd ariow. ");
INSERT INTO lwo_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Cahng man, maano e Moaje rune ge jiehariow Midyan e ngo anaa buud good Ciihna yi ukang. Cahng nu e Juog ake beehno umeenye yi bungo me ne buud good wa maaj e ne waang ngo. ");
INSERT INTO lwo_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moaje wiihe amuum naa aniide kwaad gihn nu. Abea gihn kea e daahd nyiigo beere kwaad gihn ngo beehne ke ne niido ke ka me cahng ni, e duon Juog alihnge lihngo e urubo yihre kea, ");
INSERT INTO lwo_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Moaje, a naa Juog gihn wuor Abraahme maa Yijaag kedea Jeakob kedea ge kuow mooge.’ Maa amag lwahre Moaje ubahnge wonge keá cahg tihng maalo ne maahnyo keehdo. ");
INSERT INTO lwo_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Maa abar Juoge maalo ke rob yihr Moaje kea, ‘Kahl wuor giihi noono oogo yi tieni bang gihn ka cuungi yea, beehda Piny Juog.’ ");
INSERT INTO lwo_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ubare ke maalo ke rob kobe, ‘Lihng gihn roba yihri ni beer mee. Giih ajohro naa ayoad jo'a, yaa Yijarael, piny Micihr ge aniida ke wonga. Kaa akaahn yaa Micihre gen ke cing nyooro aniida thiow. Lan gen e naa alihnga e naa gihn abeehna wiih piny beere ge lunya ke oogo kar bahng. Awaahn ni, yih oohra ne kahl jo'a oogo Micihr.’ ");
INSERT INTO lwo_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moaje e naa akweer yaa Yijaraele keehde ni, ge anaa arub gene kejea, ‘Ngaa e naa acub yihn nyum wan ne ngaa duohng yaa lam,’ e naa ngaa akwany Juoge ne ngaa duohng yaa lam yihr gen: ngaa me lwahg gen oogo kar bahng piny Micihr. Ge arom Moaje ke lwahg oogo ke kuny mar wuohnjuog gihn abeehn ne meeny yi bungo wa maaj e ne waang ngo. ");
INSERT INTO lwo_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Anahg Moaje e naa akahl gen oogo Micihr, e tiihy giih me thoohdh me teeg me gaahy nyoge ke bang koohr Naam Kwaar kedea ke kar run jiehariow e ge cor yea ukang. ");
INSERT INTO lwo_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Anahg Moaje e naa arubo yihr ge kuowo ke nying Jeacuu kea, ‘Juog arubo kejea agamloohngjuog uoohre yihru cahng moogo. Agamloohngjuog maa ngad tien paaru muu uroomo ke an.’ ");
INSERT INTO lwo_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Anahg Moaje e naa ngaa anaa arob Juoge loohnge yihre wiih good Ciihna. Loohnge giih dhiilo tiihj ke gen. Ngahyu thiow kejea ge kuowo ge anaa thar good Ciihna ne koar Moaje. ");
INSERT INTO lwo_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Anahg Moaje gihn ni e naa adhaahr ge kuowo ke koar ngo kedea ukweer gene keehde kaano apoohde e ne wiih good. Ge akweer kejea Moaje padh ruohdh gen kedea ge daahd udo gene Micihr. ");
INSERT INTO lwo_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Gihn nu e ge arubo yihr Aaron kob gene, ‘Moaje umiihu, gihn ayug ree yihre maalo wiih good ngo kwihy wane. Nea neehn maano kea doohngi ne ruohdh wan kedea thaahdh gihn me wa muor unahge e naa juog wuor wane.’ ");
INSERT INTO lwo_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kaano e naa ayoad gene gihn me room ke muor uthaahdh gene ngo. Maa anahg gene gihr remo piny ne kweehr muor gihn athaahdh gene ne juog gihr gen. Maa uyoad gene deeh yaay me duohng keter maa ayug gene ngo ke nying gihn athaahdh gene ke cing gen naa amihn cwihny gene rih ngo. ");
INSERT INTO lwo_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Naa aniid Juoge ngo kejea ge kuowo ge daahd wuor yiehdhe giih wuor aleye e cwihnye arahnyo. Cwihnye arahnyo uloge wonge oogo rog gen uwiie gen ne wuor kwaad giih gen noono wa ciehr kedea kwaad giih mooge me nii maalo. Juog coon anaa arubo ke nying gihn atiihy ge kuowo ree yi kitaab gihn agweed agamloohngjuog me nyinge Amoje. Gihn akweer gene ke wuor Juog unahge yiehdhe giih aleye ge ne wuor gene. Anaa akob Juoge kea, ‘Wu yaa Yijarael, wu yug giih waal wa mar ge kuowu. Ge kuowu ge ayug giih waal riha kejea ge wuor an. ");
INSERT INTO lwo_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Abea ka beehda toohd. Ge akweer ke luma noono unahg gene gihr remo ke yihr yiehdhe giih wuor aleye. Yiehdhe giih nu ge naa adoohng ne joohy wuor gene. Wun thiow, wu tiihy kwaad giih na tiihy ge kuowu. Kobu wu nyoge me wuor an abea wu kaahn coohre bang gihn wu poohd wuor yiehdhe me gihr nying gen tooro. Bang gihn adoohngu ne nyoge me be wuor an kedea wu urubo ke toohd kejea a wuoru wuoro, e naa gihn uriema wun ka me baahr, piny aleye, wa mar nyoge maa ataaj yi liny.’ ");
INSERT INTO lwo_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ngahyu cang kejea ge kuowu giih wuor Juog ge na yug gene ke ka na cub abug yea. Ngo anahg abug me duohng me nyoadh ngo kejea Juog nud keehd yaa Yijarael. Juog e naa anyoadh kaa ageer abug gihn nu kii ngo yihr Moaje. ");
INSERT INTO lwo_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ngahyu thiow kejea keehd ge kuowo, e ngaa duohng gen anahg Jocwa, Juog puud ne wuor gene ke kar abug. ");
INSERT INTO lwo_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Deabid kuowo anaa adaahd ugeere wod me wuor Juog yea. ");
INSERT INTO lwo_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Abea anahg Caloamon e naa abeehn ne geer wod me wuor Juog yea: wod anaa daahd Deabide ke geero. ");
INSERT INTO lwo_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Giih nu cang ge beehda athere me ngahyu. Abea a adaahd uteeda ngo yihru ne cohg kejea Juog gihn wuoro, e beehd yi Maalo Paare, be beehd yihdh wuude me geer ke cing dhaano utaahngo wa kwaad wuud ageer ge kuowo. Anaa arob agamloohngjuoge kejea Juog arubo kobe, ");
INSERT INTO lwo_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Maalo e naa koom me piiha wiihe maa piny e naa gihn cuba tiena wiihe. Beehda kwaad wod me duohng wa gihn e nuu geeru uroma yuohmo yea? ");
INSERT INTO lwo_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ngahda an naa ayug kwaad giih nud upiny kan cang! Wod me ngihde e ne romu ke geero yihra!’ ” ");
INSERT INTO lwo_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Maa abar Yijtepene maalo ke rob, “Gihn nye yaage e teeg wudhu ubahnge wu be lihngo ke luube? Loohng Juog ge be cubu yi cwihnyu. Wu uroomo keehd ge kuowo naa akweer ke yiih lum Juog. Wu akweer thiow ke lihng luub Wahy Juog wa kwaad kaa anaa akweer ge kuowu naa coon. ");
INSERT INTO lwo_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wu gweehg tiihy giih me reje wa kwaad giih na gweehg ge kuowu. Riem batien yaa gamloohngjuog kedea kaahn gen ke cing nyooro e naa tiihj anaa acub ge kuowu yi wudh gen. Yaa gamloohngjuog me thoohdh maa arubo ke nying beehn Ngad Boadh nyoge, ge anahg gene. Wun thiow, naa ayoadu Ngad Boadh nyoge e ngo amagu unahgu ngo. ");
INSERT INTO lwo_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Keehd maa angahyu ngo kejea Juog e naa acub loohng yihr Moaje, e wu akweer ne ped ke tiihj ke gen.” ");
INSERT INTO lwo_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","E yaa anaa yi lug ge lihng gene giih arob Yijtepene robo ni, e cwihny gen anaa ngwedh piny kedea ukaany gene lag gen kaanyo rih Yijtepen. ");
INSERT INTO lwo_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kaano e Yijtepen amaahny maalo maa anyoadh dhaahr Juog yihre. Noono uniide kaa amiihr paar Juoge kii ngo maa e Jeacuu ucuungo ukwiihy Juog. ");
INSERT INTO lwo_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Urub Yijtepene kobe, “Maahnyu do yey Maalo uneehno yihra e ayab ree maa Jeacuu Waahd Juog apiih ukwiihy wahn.” ");
INSERT INTO lwo_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kaano e yaa anaa yi lug ge anaa juuj ke kwaago maa e yihdh gen aciehg gene ke cing gen. Noono ugoohd gene rih Yijtepen. ");
INSERT INTO lwo_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Maa akwahg gene ngo piny kedea uywaay gene ngo ke oogo yi buur geew kaa aci gene ne bahn ngo ke leele. ");
INSERT INTO lwo_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kaano abahn gene Yijtepen bahno, e ngo ake kwahyo e urubo kobe, “Wahya ge acuba yi cing Jeacuu Ruohdha.” ");
INSERT INTO lwo_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Noono upahdhe ke wudh conge urube kobe, “Wii lubo piny yihr gen Juog.” Kaano e ake thoo. Yaa anaa aci ne bahn Yijtepen ge anaa akony ngaa me nyinge Coale. ");
INSERT INTO lwo_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Yaaj me wuor Juog ne cohg kuohm Yijtepen akan gene kedea uyuog gene bang ngo keter. Ke wong cahng nu anahge nu, e naa kaa anaa thub nyoge ke yug giih ajohr me reje ne cohg rog yaa ayiiho giih anaa Jeruucalem. Noono ugoohd thoohdh gene oogo Jeruucalem ukeedh gene ke bang wudh geedh Camaarya. Anahg jo oohr ge naa anaa adoohng Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Abea Coal, ngaa anaa adoohng waay nyoge bange nye kaa anahg Yijtepen, adhal ke yug giih me reje rog yaa ayiiho. Yug giih reje anaa adeehje yi cwihnye ne cohg adhaahr ucaahdhe caahdho e ngo wen miehr giih yaa ayiiho e daahd gen. Noono e kwaad ngaa ayiih lum Juog maa ayoade now, dhe cuow kedea dhaago e ngo kedhe kii karkoohn. ");
INSERT INTO lwo_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yaa anaa akeedho ke bang Camaarya ge ake caahdho e ge puohny lum Juog ke yihdh geedhe. ");
INSERT INTO lwo_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pihlihb ge anaa kwany ke nyoge abiihjberiow ne kony jo oohr, ngo anaa acidho geen Camaarya. Yi geen nu ngo arubo ke nying Ngad Boadh nyoge gihn akwany Juoge. ");
INSERT INTO lwo_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nyoge me thoohdh ge abeehn bang Pihlihb ne lihng giih puohnye. Wudh gen acub gene ne lihng giih arobe ne cohg bang gihn, bang Pihlihb alihngo yihr gen ke coon kejea giih me gaahy nyoge ge yuge yugo. Kedea awaahn ni giih nu na yuge ge aniid gene ke nying gen. ");
INSERT INTO lwo_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pihlihb nyoge maa adwaany kedea maa ngoohde ge athiehdhe. Atiihb ukeehg ge arieme oogo yi koohm nyoge. Noono ugoohd gene oogo e ge ungoan bang gihn ariem Pihlihbe ge oogo. ");
INSERT INTO lwo_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ubeehn yaa yi geew umihn cwihny gene keter. ");
INSERT INTO lwo_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Yi geen ni thiow ngad yiehdhe moogo anudo me nyinge Cimoane. Atahre kea e ngaa me teeg. Yi nihn nu e Cimoane anaa ke theehdho ke nyoge kedea ugaahy gene yi giih tiihye. ");
INSERT INTO lwo_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Yaa anaa yi geen ni cang cuow kedea maahn ge anaa abeehn ne cub wudh gen rog giih yug Cimoane. Noono urub gene kob gene, “Juog gihn duohng ke ngude e ne meehg Cimoane yug kwaad giih nu.” ");
INSERT INTO lwo_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Adiehr muon nyoge ge anaa acwaahng kedea wudh gen anaa acub gene rog giihe noon ni bang gihn ge atiihye ke ka me bange baahr. ");
INSERT INTO lwo_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Abea naa abeehn nyoge ne lihng puohny mar Pihlihb, naa apuohnye nyoge ke dhe yoohn mag Juoge nyoge ne yaae kedea naa arube ke nying Jeacuu Kriihjto, e lum Pihlihb ayiih gene yiiho. Maa abeehn Pihlihbe umuoje gen ke luogwahy, cuow kedea maahn cang. ");
INSERT INTO lwo_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Cimoane thiow, e anahg ngad yiehdhe, amuoj ke luogwahy naa adoohnge ne ngaa maa ayiiho. Noono ucaahdhe caahdho ke batien Pihlihb bang gihn en thiow agaahy yi kwaad giih teeg naa ayug Pihlihbe. ");
INSERT INTO lwo_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Batien gihn nu e dhog awahnh Jeruucalem bang jo oohr kejea yaa Camaarya thiow lum Juog ayiih gene. E Piihter keehd Joon ge ake oohro bang gen. ");
INSERT INTO lwo_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","17","Naa awahnh Piihtere maa Joon yi geen ngo e alihng gene lihngo kejea Wahy Juog poohd kuu abeehn wudh yaa ayiiho keehd maa anaa amuoj Pihlihbe gen ke luogwahy ke teeg Jeacuu Ruohdh. Naa angahy gene ngo e Wahy Juog kuu abeehn wudh yaa ni e cing gen acub gene ke wudh gen cang maa akwaj gene Juog beere Wahy Juog cube cubo. Noono maa abeehn Wahy Juoge wudh gen. ");
INSERT INTO lwo_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Naa aniid Cimoane ngo e Wahy Juog abeehn wudh yaa ayiiho naa apiehl jo oohre cing gen wudh gen, e ngiihny ge atume ke cubo yihr Piihter maa Joon kobe, ");
INSERT INTO lwo_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Cubu kwaad tee gihru noono yihra beere kwaad ngaa cuba cinga wiihe, e Wahy Juog yoade yoado thiow.” ");
INSERT INTO lwo_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","21","Maa abeehr Piihtere ngo yihre kea, “Kadhi ke ngiihnyi noono, Juog yih be wiie! Yih dhiile kaa kihmo. Ngaa e naa akob ngo yihri kejea Wahy Juog ke ngeewo ke ngiihny. Yih abeehdo e yih kuu anahg ngad wan kuu umodho. Gihn me beer me cahgi ke yoado tooro, bang gihn Juog cwihnye angol rihi bang gihn apari ngo kejea tee gihre ngeewi ngeewo ke ngiihny. Gihn me cahgi ke yoado bange tooro. ");
INSERT INTO lwo_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Yih aniida arumo ne ngad anyoohne me thoohdh! Kea noono maan anyoohne giihi! Kway Juog beere lubo wiie ke piny yihri.” ");
INSERT INTO lwo_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","E Cimoane ake rubo yihr Piihter kea, “Cedhree! Kwahyi ke nyinga yihr Juog beere giih nu arobi ge be tiihy Juog riha.” ");
INSERT INTO lwo_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yaa ayiiho ge na puohny Piihtere maa Joone puohnyo batien gihn nu ayug ree nu. Ge apuohny gene kejea caahdh gene kaa dhe yoohn anyoadh Jeacuue. Naa athum waahdh gene ne do Jeruucalem, e ge acaahdho e ge puohny Ciig Beer yihr nyoge ke bang yihdh miehy akaahn gene. ");
INSERT INTO lwo_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Cahng ni e wuohnjuog ake rubo yihr Pihlihb kea, “Gwiir rihi ucidhi e yih kaahn yoohn aay Jeruucalem ne ci te bur Gaja.” ");
INSERT INTO lwo_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Noono ugwiir Pihlihbe ree upahdhe yooh. Wajiihr me duohng gihr dhaahr Cuudaahn anaa yi yoohn nu ne do Cuudaahn naa athume ke yug giih kweehr yihr Juog Jeruucalem. Anahg wajiihr ngad mag ngiihny yi dhaahr me dhaago e naa anahg ruohdh yi paajo. Anaa abeehn Jeruucalem ne yug giih kweehr yihr Juog. ");
INSERT INTO lwo_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Kaa anaa acaahdh arbieng cieny gihre caahdho, e ngo anaa ke kwaahno yi kitaab gihn agweed Yicaaya agamloohngjuog. ");
INSERT INTO lwo_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","E Wahy Juog ake rubo yihr Pihlihb kejea, “Lay tieni! Cidhi ucaahdhi ke buud arbieng ca.” ");
INSERT INTO lwo_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Gihn nu e Pihlihb tiene alaye layo udoohde arabya, ulihnge wajiihr e ngo ukwaahno yi kitaab gihn agweed Yicaaya agamloohngjuog ni. Maa apeehny Pihlihbe ngo kobe, “Giih nu kwaani awaahn ni yi lum yihdh gen romi kaa ngeyo beer mee ne?” ");
INSERT INTO lwo_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Maa abeehre ngo yihr Pihlihb kobe, “Yihdh gen roma ke ngeyo ke naa diih nea padh ngaa moogo e ne rob giih yihdh gen yihra.” Maa arob Pihlihbe ngo yihr wajiihr kejea yihdh gen rome kaa kwaano yihre. Noono e Pihlihb acuohne cuohno bange yaa arabya beere ge ucaahdho tiehd. ");
INSERT INTO lwo_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Anahg ngol gihn e naa anaa akwaan wajiihre kwaano, “Ngaa me wa kwaad roomo me piey ne naah. Wa kwaad roomo me be yuog ka giihdh yiehy ree oogo. Dhee kuu akuong ne kweg ke lalo. ");
INSERT INTO lwo_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kwaad deeh ajohr me duohng atiihj ree kedea ngo aroaj wiih adiehje. Ne nyoge me reje wiih piny me kaal wiih raahy yaa anahg ngo? Be ngaa me kaal wiih raahy gen! Ngo anahg gene ke naah ajohr.” ");
INSERT INTO lwo_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","E wajiihr Pihlihbe apeehnye peehnyo kobe, “Teed ngo yihra, giih ni agweed agamloohngjuoge ge rubo kaa nying ngaa? Beehda ke nying ngud mare ne wale ke nying ngaa moogo?” ");
INSERT INTO lwo_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pihlihb arubo yihr wajiihr ke nying Ciig Beer ge rubo ke nying Jeacuu Ngad Boadh nyoge. Athubo ke rob e thobe kaa ngol gihn anaa akwaan wajiihre kwaano. Arobe kea ngol gihn nu rubo kaa nying Jeacuu ge ulog beehno cahng moogo ke batien agamloohngjuog. ");
INSERT INTO lwo_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Naa awahdh gene buud kar piih e wajiihr ake rubo yihr Pihlihb kobe, “Giih ateedi ke nying Jeacuu ge ayiiha. Cwihnya acuba ne wuor ngo. Muoj wiiha ke piih luogwahy.” Maa abeehr Pihlihbe ngo yihre kea, “Piih luogwahy ge uwoja wiihi nea yih ayiiho ke cwihnyi cang.” Maa aduoge ngo kea, “Ngo ayiiha ke cwihnya cang kejea Jeacuu Ngad Boadh nyoge beehda Waahd Juog ke ngude.” ");
INSERT INTO lwo_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ubeehn wajiihre maa arobe ngo yihr ngaa doang arabya gihr ciehnye doango kejea mage yaa arabya ucuunge. Noono ucidh Pihlihbe maa wajiihre yihdh piih uwoje piih wiihe ne cub luogwahy yihre. ");
INSERT INTO lwo_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Naa abeehn gene oogo yihdh piih, e Wahy Juog Pihlihb akaabe kaabo ukedhe ngo ka me kuu acahg wajiihre ke niido keehdo. Ubeehn wajiihre ubare maalo keehd waahdhe e cwihnye med kwaade tooro. ");
INSERT INTO lwo_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Batien gihn nu e Pihlihb ree ayoade ke ka me cuohn naa Ajotoj. Uaay Pihlihbe ne ci Cejearya, e caahdhe e ngo puohny Ciig Beer yihr nyoge ke bang yihdh geedhe giih toohnge yihdh gen. ");
INSERT INTO lwo_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kaa anahg Pihlihbe Cejearya e Coal anaa beed Jeruucalem. Coal cwihnye apoohde e ngo raaj rog yaa ayiiho kedea ree akuohnge ke maalo maa piny ne nahg yaa ayiih lum Jeacuu. ");
INSERT INTO lwo_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Naa alihnge ngo kejea yaa ayiiho mooge ge agoohdo uwahdh gene geen Damajko, e wiihe apare ne buodh batien gen beere caa ne mag gen kun ca. Noono maa arobe ngo yihr ngaa duohng yaa lam kejea muoje ke warga me cube yihr Judea beed Damajko, warga me kony gene en ke daahd yaa ayiiho beere kihd ngaa ayoade mage maa ukahle ngo Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Naa awahnh ge Coale ka me cahng keehd Damajko, e gihn me wa maahny kodh piny ameenye meenyo ne beehd udoohng buude ne weehny. ");
INSERT INTO lwo_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Maa apahdh Coale piny ne riehb. Kaano anea piny nu, e lihng ngaa me rubo yihre kea, “Coal, gihn ke ree e tiehngi a ater?” ");
INSERT INTO lwo_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","E ngo abeehr Coale kobe, “Ruohdh, yih beehda ngaa?” Maa aduoge ngo yihre kea, “Beehda a Jeacuu gihn atiehngi ater. Keehd maa atiihyi giih me reje riha, e awaahn ni yih aloga ne ngaa me tiihyo yihra. ");
INSERT INTO lwo_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Aj maalo uci yi buur geew, gihn daahd utiihyi ngo, urob yihri Damajko.” ");
INSERT INTO lwo_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yaa anaa ke caahdho keehd Coal, ge anaa acuungo ne dihl e dhog ge atal naa acwaahng gene, bang gihn yedh duol alihng gene abea kihd ngaan arubo kuu aniid gene. ");
INSERT INTO lwo_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Batiene e Coal a'aj maalo, abea gihn kea e tum wonge ke yabo e piny keá rom ke niido ne weey weey. Noono e cinge amag yaae maa upiey gene ngo Damajko. ");
INSERT INTO lwo_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Maa abeehd Coale keehd kar nihn adahg e piny be niide ne weey weey. Thiow kihd piih maa cam maa akedhe dhee tooro bang gihn giih nu ge akweehre kweehro ke nying kway Juog. ");
INSERT INTO lwo_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yi Damajko, ngad yiiho anudo me nyinge Anaanya. Nyin nu Jeacuu abeehn wiihe yi laahg ucuohne ngo kobe, “Anaanya.” Maa ayiih Anaanya kea, “A aman kan Ruohdh.” ");
INSERT INTO lwo_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Batiene e Jeacuu ake rubo yihre kea, “Anaanya, a daahd uoohra yihn. Aj maalo ukwanyi yoohn nyinge Yooh Ne Kew ucii paar nyin me nyinge Juudo. Nea yih awahdh paar Juudo, e kea koohbi kii yih daahd ngaa me nyinge Coal, ngad geen Tarcuj. Coal gihn nii kway Juog awaahn ni ");
INSERT INTO lwo_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","kedea yih uneehno yihre awaahn ni wa yi laahg e yih beehn bange ne cub cingi wiihe beere nyinge ge uyahbo keehdo.” ");
INSERT INTO lwo_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Maa abeehr Anaanaye ngo yihr Jeacuu kea, “Ruohdh ngaan nu robi kaano bange beehde e ngo alihnga coon bang nyoge me thoohdh. Bange alihnga kejea ngo ngaa me raaj. Giih reje naa atiihye rog yaai ge beed Jeruucalem ge alihnga. ");
INSERT INTO lwo_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ngo alihnga thiow kejea ngo abeehn Damajko kan e ngo kaahn warga maa agweed ngaa duohng yaa lame beere wa mage maa.” ");
INSERT INTO lwo_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kaano e ngo acahg Jeacuue kaa robo yihr Anaanya kea, “Cidhi bange bang gihn ngo akwanya ne ngaa me tiihy yihra. E nuu meehg nyinga wiihj ke bang upiny cang maa ke bang ruohdhe giih upiny cang kedea ke bang yaa Judea cang. ");
INSERT INTO lwo_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Giih ujoohre yihdh gen ke nyinga ge unyoadha yihre. Tihng rihi ucidhi.” ");
INSERT INTO lwo_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kaano arumo e Anaanya ake aay ne cej paar Juudo. Naa ayoade ngo e amon wod ucube cinge wiih Coal e ngo urubo yihr Coal kea, “Coal umiiha, Jeacuu Ruohdh, ge anyoadh ree yihri yi yooh ni, e naa aoohr an bangi. A aoohre beere nyingi ge uyahbo ucahgi piny ke niido keehdo e thiow beere Wahy Juog beehn rihi.” ");
INSERT INTO lwo_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ke wong kaano e Coal kwaad giih me wa kwaaje ge aniide e ge naa pag oogo yihdh nyinge. Noono uyahb nyinge yahbo ucahge piny kaa aniido. Maa abeehn Coale uyedhe maalo noono maa amuoj Anaanyae wiihe ke piih luogwahy. ");
INSERT INTO lwo_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Naa acahm Coale, e kuohme anaa war, uyoade tee. Batien gihn nu, e Coal aceng bang yaa ayiiho. ");
INSERT INTO lwo_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","21","Noono uthub Coale ke puohny nyoge ke bang kuohn amaade giih Damajko kejea Jeacuu beehda Waahd Juog ke ngude. Apuohnyo ne cohg e rob luube me meehg nyoge yiih ngo kejea Ngad Boadh nyoge gihn akoar gene koaro e naa Jeacuu. Yaa alihng kaa arube kii ngo ge adog cwaahng ke nying teeg lume. Ge acwaahng bang gihn angahy gene kejea yaa na rob kwaad giih puohnye ge na maane maano. Maa apeehy nyoge ke rog gen. “Padh nyin na nahg yaa ayiiho e gihn ne? Ngahda anaa abeehn kan beere ge mage maa ukedhe gen Jeruucalem bang ngaa duohng yaa lam ne?” ");
INSERT INTO lwo_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Abea e naa kaa abeehn Coale ubare maalo ke puohny ne cohg uwahdhe kaa adaare yaa Judea kedea maa abeehn Judea mooge uyiih gene puohnye. Ge ayiiho bang gihn dhe yoohn kaa anyoadhe ngo kejea Jeacuu e naa ngaan anaa aoohr Juoge upiny ne Ngad Boadh nyoge, ngo apahdh yi cwihny gen naa adiehr. ");
INSERT INTO lwo_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Batien nihn e yaa Judea giih cwihny gen reje rih Coal, amaad ayug gene beere dhe yooh me nahg gene Coal daahd gene daahdo. ");
INSERT INTO lwo_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Abea nyoge Coal atoohn gene kejea yaa Judea ge daahd ngo ke naah. Yaa Judea thiow nyoge acub gene dhog oaye giih atieg geew piny keehd gen ne koar Coal ke bang decahngo maa dewaahr beere ngo mag gene maa unahg gene ngo nea daahd ree ke kwala. ");
INSERT INTO lwo_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Abea yaa ayiiho dhe yooh moogo abeehn gene ne yoado maa arom gene Coal ke kwal oogo. Noono maa acea Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Naa abeehn Coale Jeruucalem, e dhe yooh maa ayoade tooro naa atume ree ke mad bang yaa ayiiho. Dhe yooh keá yoado bang gihn yaa ayiiho giih Jeruucalem ge apoohdo e cwihny gen udiiwo ke nying Coal kejea ngo poohd e ngaa me riem batien yaa ayiiho. ");
INSERT INTO lwo_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Noono maa anahge Barnaba e naa abeehn ngo ne konyo ukedhe ngo bang jo oohr. Gihn nu maa akwaan Barnabe dhe yoohn kaa abeehn Coale uniide Jeacuu yi yooh e ngo caa geen Damajko kedea kaa arub Jeacuue yihr Coal. Uteed Barnabe kaa apuohny Coale nyoge Damajko thiow ke nying Jeacuu Ruohdh e lwahr me ne ree tooro. ");
INSERT INTO lwo_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","E naa kaa abeehn Coale upiihe bang yaa ayiiho kedea ubeehde e ngo puohny Ciig Beer ke nying Jeacuu ke bang yi geew e urubo yihr Judea e kihd lwahr me ne ree tooro. ");
INSERT INTO lwo_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Thiow Coal na urubo keehd Judea giih ne beehd miehy bahye. Yaaj mooge kiin gen cwihny gen arahnyo rih Coal maa adaahd gene dhe yooh me nahg gene Coal. ");
INSERT INTO lwo_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kaa amodh yaa ge Coale gihn daahd yaa Judea ke yugo, e Coal arwaay gene ke Cejearya uoohr gene ngo geen Tarcuj. ");
INSERT INTO lwo_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Anahg yihdh nihn nu thiow e naa abeehn yaa ayiiho giih Gaalili kedea Camaarya uyoad gene laahw wihj kedea ukoad gene. Thiow ge na ubeehdo ke med cwihny e ge tiihy giih daahd Juoge, bang gihn Wahy Juog anaa anudo ke gen. Anahg yihdh nihn alaahw wihj e naa atiihy giih ni rog gen. ");
INSERT INTO lwo_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kaano thiow Piihter na ucaahdho ke bang wudh geedhe. E nahg cahng ni, e acaa paajo me cuohn ne Lida ne liew yaa ayiiho, ");
INSERT INTO lwo_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","e Piihter atoohng wiih nyin me cuohn ne Aniihj maa abeehdo e ngo abab piny ke run abiihjbedahg e kar waahdh tooro yihre. ");
INSERT INTO lwo_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Maa acuohn Piihtere ngo ke nyinge kea, “Aniihj, Jeacuu yih athiehdhe. Aj maalo maa dol gihr budo gihri.” Ke wong kaano e Aniihj a'aj maalo. ");
INSERT INTO lwo_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Yaa beed geen Lida kedea yaa piny Caaron lum Juog abeehn gene ne yiiho bang gihn, gihn ayug ree alihng gene kedea ngaa athiehdh anaa beehn gene ne niido. ");
INSERT INTO lwo_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Thiow, dhaago moogo anaa anudo yi geen Jopa. Dhaar ni nyinge Taabidha. Ngo anahg ngaa maa ayiih lum Jeacuu. Thiow anahg ngaa maa acub wiihe yi tiihy giih me beeye kedea kony nyoge maa angoohng. ");
INSERT INTO lwo_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Yi nihn nu e Taabidha abeehn ne twaany uthowe. Noono e kuohme ake luogo upiehle yi wod maalo. ");
INSERT INTO lwo_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopa beehda geew me ngo be baahr keehd Lida. Naa alihng yaa ayiiho giih Jopa ngo kejea Piihter ne Lida, e nyoge ariow aoohr gene ke bange ne robe yihre kejea laare beehn Jopa. ");
INSERT INTO lwo_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Noono ubeehn Piihtere utihnge ree tihngo ulaare ke cidho keehd gen Jopa. Naa awahnh gene paajo e ngo akedh wod maalo kaa apiehl kuohm Taabidha yea. Maa abeehn gihn anaa anahg alwaa gule umahd gene buud Piihter e ge uyuog maa e ge nyoadh waay anaa ayug Taabidhae yihr gen. ");
INSERT INTO lwo_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Maa abeehn Piihtere maa arieme nyoge oogo udoohnge yi wod. Gihn nu e cunge arunge piny ukwahye kwahyo. Batiene maa aloge wonge bang Taabidha goan kun anaa apiehle yea kedea ucuohne ngo ke nyinge kea, “Taabidha! Aj maalo.” Maa abeehn Taabidhae uyabe wonge. Abea naa aniide Piihter, e ngo ayedho maalo upiihe uthare kaa anaa apiehle yea. ");
INSERT INTO lwo_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Maa anyiig Piihtere buude umage ngo keehd bade utihnge ngo maalo wudh tiene ucuunge. Maa acuohn Piihtere nyoge wod, gule maa yaa ayiiho naa mahdo, unyoadhe Taabidha yihr gen e ngo kuow. ");
INSERT INTO lwo_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Maa abeehn gihn ayug ree ulihnge ke bang yi geen Jopa ke kare cang. Noono ubeehn nyoge me thoohdh maa ayiih gene lum Juog. ");
INSERT INTO lwo_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Maa aceng Piihtere keehd kar nihn me thoohdh keehd yaa Jopa, paar nyin me nyinge Cimoane. ");
INSERT INTO lwo_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","2","Yi geen Cejearya ka me cahng keehd Jopa nyin moogo anudo me nyinge Kornealio. Kornealio kuu anahg Ujudea abea anahg ngaa maa amag lum Juog ne cohg, en maa jo paare cang. Kornealio anahg ngaa me koag ke kwaj yihr Juog kedea ke kony nyoge maa angoohng. Ngo anahg jaabidh yi ketiihba gihr deaj Roama ge cuohn ne ‘Kaahy Liny Itaalya.’ ");
INSERT INTO lwo_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Cahng man e Kornealio ukwahyo, yi laahng cahng, e wuohnjuog aniide niido wa yi laahg e ngo beehn bange kedea e ngo cuohn nyinge kea, “Maahdh yaa Kornealio.” ");
INSERT INTO lwo_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Maa amaahny Kornealio bang wuohnjuog e ngo amag lwahre ukoohbe kea, “Gihn ngaa me duohng!” E ngo abeehr wuohnjuoge beehro yihre kea, “Juog cwihnye amihno rihi ke nying kwaj gihri maa ke nying gihn konyi nyoge maa angoohng konyo. Awaahn ni Juog cwihnye ne bang uyuge gihn me beer yihri. ");
INSERT INTO lwo_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Juog daahd ngo unyoadhe dhe yooh gihn nyaahn e wuore kii ngo. Ke nying gihn nu kea oohr nyoge kiin yaai awaahn kan geen Jopa bang ngaa me nyinge Piihter. ");
INSERT INTO lwo_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Piihter beehda weehno paar nyin me nyinge Cimoane. Paare ne dieng naam duohng.” ");
INSERT INTO lwo_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Naa a'aay wuohnjuoge e Kornealio yaa tiihj giihe ge acuohne bange: yaa tiihj kar ge ariow kedea wa acaaker acielo maa anahg ngaa me wuor lum Juog. ");
INSERT INTO lwo_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Batiene naa akwaan Kornealio gihn ayug ree yihr yaa ni, e ge aoohre ke Jopa bang Piihter. ");
INSERT INTO lwo_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ruuwow, e jo aoohr Kornealio ge adoohng cahng keehd Jopa e Piihter kaa anaa ayedh maalo wiih wod decahngo ne kway Juog ");
INSERT INTO lwo_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Maa athub kahje ke raahm rih Piihter maa ayuohd cwihnye bang cam keraahyo. Abea nye kaa apoohde e cam ke gwiiro, e gihn moogo anaa niihm yi wonge ");
INSERT INTO lwo_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","maa aniide yi maalo e ree ayabe ne wahng kedea e gihn me wa deeh athoohr alwaay piny ke baahde angween. ");
INSERT INTO lwo_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yi athoohr ngo anaa apahng keehd kwaad laahy kedea kwaad giih me muun ke piny maa kwaad winy me kweehr Judea. ");
INSERT INTO lwo_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Maa alihnge Juog e urubo yihre kea, “Yedh maalo Piihter. Nahg giih ne yi athoohr ucwihdi. A naa acub gen yihri ne camo bang gihn ge caame me beeye.” ");
INSERT INTO lwo_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Maa abeehr Piihtere ngo kobe, “Kare tooro Juog Ruohdha! Kare tooro ucama caame me kweehr Judea! Wa a ngahyi! A kuu akuong cam keehd kwaad giih me koohb jo paar wane kejea ge reje, ge be cam.” ");
INSERT INTO lwo_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Maa adog duole rob yihre kea, “Ateeda yihri, yih keá kweer ke cam me beer maa acuba yihri ne camo. Ngo keá them piny udogi ngo ke cuohno ne cam me raaj me kweehr Judea.” ");
INSERT INTO lwo_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Gihn nu ree abere tiel adahg uyoay athoohr maalo. ");
INSERT INTO lwo_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nye kaano anaa apoohde e Piihter daahd yi lum gihn aniide ni, e naa nye kaa anaa awahnh jo aoohr Kornealioe dhe kala paar Cimoane. ");
INSERT INTO lwo_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Maa apeehy gene, “Ne weehno me ne kan me nyinge Piihter ne?” ");
INSERT INTO lwo_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","E Piihter anaa apoohdo e ngo daahd yi lum gihn aniide ke ngeyo e Wahy Juog aguo beehno urube yihre kobe, “Cuow adahg ge ne dhe kala me daahd yihn. ");
INSERT INTO lwo_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gwiir rihi, ucii piny bang gen. Yih keá tudo ne aay keehd gen bang gihn a naa akoohbo kejea beehn gene bangi.” ");
INSERT INTO lwo_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Noono ubeehn Piihtere piny bang gen urube ke gen kobe, “A naa ngaan daahdu. Wu wag waahdh ne?” ");
INSERT INTO lwo_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Maa abeehr gene ngo yihre kejea, “Kornealio, jaabidh gihn duohng e naa aoohr wan bangi. Ngo beehda ngaa me beer keter me wuor lum Juog maa ngaa me lume wuor Judea wuoro. Ateed wuohnjuoge yihre kejea cuohne yihn paare beere gihn daahd Juoge, teedi teedo yihre.” ");
INSERT INTO lwo_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Maa akoohb Piihtere yihr gen kea, “Wu daahd ucaahdha ke wun tiehde? Nea wa gihn nu, e wo uaay keroo. Awaahn ni kar budo ucub yihru.” Ruuwow e Piihter ree agwiire gwiiro uaaye ke gen ne ci paar Kornealio. Yaa ayiiho mooge maa anaa Jopa ge acidho thiow ke Piihter. ");
INSERT INTO lwo_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","27","Ge abud yooh ne cielo ne ci Cejearya. Naa awahnh gene paar Kornealio e ngo ayuud gene ke dhe kala ne lor gen. Maa arihng Kornealioe ne rung cunge piny nyum Piihter ne maahdh ngo. Maa amag Piihtere cinge ne yedh maalo wudh tiene e ngo urubo yihr Kornealio kobe, “Yedh maalo a padh Juog. A beehda dhaano now muu uroomo wa yihn.” Piihter ake caahdho e ngo urubo yihr Kornealio uwahdhe kaa awahnh gene wod kaa anaa amahd amahr nyoge yea. Yaa anudo ge anahg jo paare maa gome naa acuohne. ");
INSERT INTO lwo_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Maa arub Piihtere yihr gen kobe, “Keehd wun e ngo ngahyu thiow kejea ngad Judea wa an kare tooro yihre upiihe ka maa acielo keehd ngaa me padh Ujudea. Bang gihn beehn yihdh miehyu amahn loohnge giih Judea. Abea anyoadh Juoge yihra kejea rog be poj bang gihn nyoge ge uroomo yi wong Juog. A thiow ka me poja kiin nyoge tooro. ");
INSERT INTO lwo_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","E naa gihn abahnge a kuu akweer ke beehno naa aoohri nyoge banga. Awaahn ni a adaahd ulihnga ngo yi dhii, gihn ateed Juoge yihri yih Kornealio.” ");
INSERT INTO lwo_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","E Kornealio ake thubo ke rob kobe, “Nihn adahg abar awaahn ni e piny neehn gihn ni, maano e a kway Juog paara yi laahng cahng. Kaano e ngaa maa angaab waare muu uliel ake cuungo nyuma ");
INSERT INTO lwo_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Maa arube yihra kea, ‘Kornealio Juog kwaj gihri alihnge kedea giih beey naa atiihyi ge aniide thiow. ");
INSERT INTO lwo_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Awaahn kan oohr dhaano Jopa ne cuohn nyin me nyinge Piihter. Ngo beehda weehno paar nyin me nyinge Cimoane. Paare ne dieng naam duohng.’ ");
INSERT INTO lwo_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","E naa gihn aoohra nyoge bangi piow piow e a kuu agaalo. Abea beeye noono abeehni nu. Awaahn ni wo nud kan cang maa Juog nud ke won tiehd. Rob gihn akob Juoge kejea teedi ngo yihr wan beere ngo lihng wane lihngo.” ");
INSERT INTO lwo_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Uthub Piihter ke rob yihr gen kobe, “Aniida awaahn ni kejea Juog daahd uboadhe nyoge cang bekihd tien paajo me kweere ke ngo. ");
INSERT INTO lwo_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kwaad ngaa tud yihr Juog maa utiihye gihn me beer thiow, e ngaan nu yiih Juoge yiiho bang gihn Juog nyoge ge be kwanye kaa tien paajo. ");
INSERT INTO lwo_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ngo dhiilu kaa ngahyo kejea Juog Jeacuu aoohre bang Judea ne nyoadh dhe yoohn nyaahn kedea ne nyoadh ka doohr nyoge ke Juog kii ngo. ");
INSERT INTO lwo_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Gihn duohng e naa ayug ree ngo ngahyu. Kaa anaa athub Jeacuue ke puohny Gaalili batien kaa anaa awoj Joone piih luogwahy wiihe. ");
INSERT INTO lwo_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Giih arob ke nying Jeacuu ge ngahyu cang. Kaa akwany Juoge Jeacuu kedea ucube Wahy Juog maa tee gihre yihr ngo ne tiihy giih beey yihr nyoge. Noono uwene bang upiny e ngo tiihy giih beey maa e ngo thiehdh yaa rog ge anaa atiihb ukeehg. Giih nu ge arom Jeacuue ke tiihyo bang gihn Juog anaa kure kedea teeg Juog anaa yihre. ");
INSERT INTO lwo_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Wa jo oohr, wa anaa anudo naa atiihy giih nu rog gen ke bang wiih piny Judea. Jeacuu abeehn ne naah naa agure ngahy yaadh maa ariihw. ");
INSERT INTO lwo_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Abea keehd maano anaa anahg gene Jeacuu nu, e wahye anaa beehn Juoge ne duu ree noono ucahre batien nihn adahg kedea umeehg Juoge ngo niido. ");
INSERT INTO lwo_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Abea kuu anaa anahg nyoge cang ge naa aniid ngo batien kaa acahre. Anahg wan cog wa yaa anaa akwany Juoge wa naa aniid ngo kedea ucahm wane keehde tiehd. ");
INSERT INTO lwo_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Arob Jeacuue yihr wan kejea puohny wane Ciig Beer yihr nyoge cang ke bang upiny. E thiow, ateede yihr wan kejea nyoadh wane ngo yihr nyoge kejea e naa ngaan acub Juoge piny ne ngaa maany luue giih nyoge cang, nyoge me kuow maa nyoge maa athow. ");
INSERT INTO lwo_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Amahr yaa agamloohngjuog ge arubo ke nying Ngad Boadh nyoge naa akob Juoge kea ngo uoohre. Awaahn ni a teed ngo yihru kejea Ngad Boadh nyoge ngo abeehno kedea teeda teedo yihru thiow kejea Juog anyoohne giih dhaano ge wiie ke piny nea ngaan nu lum Juog ayiihe.” ");
INSERT INTO lwo_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kaano anaa apoohde e urubo nu, e Wahy Juog abeehn rog yaa anaa alihng lum Juog naa arub Piihtere rubo. ");
INSERT INTO lwo_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yaa anaa abeehno keehd Piihter tiehd ge acahg cwaahng ke nying gihn acub Wahy Juog thiow yihr nyoge me padh Judea, ");
INSERT INTO lwo_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","bang gihn ge ake rubo ke dhoy me padh me be lihng e ge poong tee Juog. Maa arub Piihtere yihr yaa abeehno keehde kobe, ");
INSERT INTO lwo_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Yaa ni niidu kan, Wahy Juog ayoad gene neehn kaa anaa ayoado ngo. Nea neehn maano e gihn me mahn ngo tooro umuoj gen ke piih luogwahy.” ");
INSERT INTO lwo_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Noono urobe ngo kejea muoj wudh gen keehd piih luogwahy ke nying Jeacuu Ngad Boadh nyoge. Batiene e Piihter amahn gene kejea keá guo aay abea beehde keehd gen tudi ke kar nihn me noog. Gihn nu e abeehdo ke gen neehn kaa arob gene. ");
INSERT INTO lwo_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jo oohr kedea yaa ayiiho naa anudo ke bang yi Jeruucalem alihng gene kejea yaa padh Judea lum Juog awahdh yihr gen thiow. ");
INSERT INTO lwo_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Naa adog Piihtere Jeruucalem e yuud ngo kejea gihn awuoje piih luogwahy wudh nyoge Cejearya ngo amaan Judea me mag lum Juog ke dhe yoohn loohng Moaje. Kob gene nea yaa padh Judea ge daahd udoohng gene ne yaa batien Jeacuu e ge dhiil kaa thoamo. Noono ucay gene Piihter kob gene ");
INSERT INTO lwo_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Yih beehdo Ujudea, gihn e naa acidhi ne weel paar ngaa ma padh Ujudea maa ngo kuu athoam adhaahr ucahmi keehde thiow?” ");
INSERT INTO lwo_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Maa athub Piihtere ke kwaan kaa athob giih ni rog gen kii ngo kobe, ");
INSERT INTO lwo_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Beeh roba gihn ameehg an woj piih luogwahy wudh yaa nu. A anaa yi geen Jopa ne liew yaa ayiiho. Cahng man e a ukwahyo e gihn moogo anaa niihm yi wonga uniida gihn me wa athoohr me yea laaj e ngo alwaay piny ke yoohn maalo ke baahde angween. Naa awahnhe buuda e ake cuungo. ");
INSERT INTO lwo_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Naa amaanya yi gihn wa athoohr ni, e a niid kwaad laahy maa kwaad giih muun ke piny kedea winy. ");
INSERT INTO lwo_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Batiene e duon Juog alihnga lihngo e ngo urubo yihra kobe, ‘Yedh maalo Piihter, nahg giih ni yi athoohr ucwihdi.’ ");
INSERT INTO lwo_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Maa abeehra ngo kejea kare tooro Ruohdh. A kuu akuong cam keehd kwaad giih nu, bang gihn ge giih me kweehr yaa paar wane kweehro! ");
INSERT INTO lwo_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Keehdo e Juog acahg rob kobe, ‘Gihn maa aroba kejea ngo ke camo yih keá kweer ke cam ngo kejea ngo kweehru kweehro!’ ");
INSERT INTO lwo_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Gihn nu ree abere tiel adahg uyoay athoohr gihn ni ke maalo. ");
INSERT INTO lwo_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Abea e naa nye kaa anaa awahnh nyoge adahg maa aoohr banga paan beeda. Ngaa me nyinge Kornealio e naa aoohr gen. Kornealio beehda jaabidh yi deaj gihr Itaalya kedea beehda ngaa me beer ke nyoge. ");
INSERT INTO lwo_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","E thiow e naa nye kaa arob Wahy Juoge ngo yihra kejea a keá tud ne aay ke yaa ni aoohr banga. Yaa ayiiho abiihjbeciel giih Jopa ge acaahdho keehd an ne ci Cejearya kedea umon wane cang yi wod Kornealio. ");
INSERT INTO lwo_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Arob Kornealioe yihr wan wa yaa anudo kaa aniide wuohnjuog paare ukoohbe yihre kea, ‘Oohr nyoge geen Jopa ne cuohn ngaa me nyinge Piihter. ");
INSERT INTO lwo_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Lubo muu urobe yihru nud beere yihn maa jo paari wu uboadh Juoge.’ ");
INSERT INTO lwo_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Naa aruba yihr gen, e Wahy Juog abeehn rog gen wa kwaad kaa anaa abeehne rogo. ");
INSERT INTO lwo_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Maa apara gihn anaa arob Jeacuue naa akoohbe kea, ‘Joon wudh nyoge anaa amuoje kaa piih now naa acube luogwahy, abea Juog wudhu umuoje kaa Wahy Juog.’ ");
INSERT INTO lwo_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ngo adiehr kejea Juog Wahy Juog acube yihr nyoge me padh Judea wa kaa anaa acube ngo yihro naa anaa ayiiho lum Jeacuu Ngad Boadh Nyoge. A beehda ngaa ne mahn piih luogwahy ke woj wudh gen!” ");
INSERT INTO lwo_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kaa alihng yaa anaa acay Piihter luub ni, e ngo kuu acahg gene ke cayo keehdo. Abea ge apiih ne leej Juog kob gene, “Juog kar boadh nyoge me padh Judea ngo acube nea anyoohne giih gen maan gene maano.” ");
INSERT INTO lwo_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","20","E Piihter poohd kuu anaa aay ne ci Jopa, yaa ayiiho ge anudo maa anaa agoohd oogo geen Jeruucalem ke nying giih ajohr naa anaa ayug rog gen batien kaa anahg Yijtepen. Goan gen ge awahdh wudh geedhe me bahye. Yihdh kuohn mooge lum Juog na puohny gene cog ke yihr Judea giih anaa adag kuohn nu ne beehdo. Abea goan mooge naa awahnh gene yi geen duohng cuohn naa Antiog e ge athubo ke puohny yaa beed geen nu ke lum Juog. Wudh gen kuu acub gene ne cej Judea beere ge ne puohny gene cog. ");
INSERT INTO lwo_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","E Juog thiow tee mare acube yihr gen ubeehn yaa piny nu me thoohdh maa ayiih gene lum Juog. ");
INSERT INTO lwo_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ngo abeehn ne lihngo Jeruucalem kejea yaa padh Judea me thoohdh lum Juog ayiih gene. Noono uoohr yaa Jeruucaleme Barnaba ne ci geen Antiog. ");
INSERT INTO lwo_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Naa awahnh Barnabe Antiog e cwihnye ake mihno bang naa aniide kaa abeehn yaa ayiiho umag gene lum Juog teeg kii ngo. Noono urob Barnabe giih tee aduulo yihr gen ne mag lum Juog ke cwihny gen acielo. ");
INSERT INTO lwo_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnaba anahg ngaa maa ayiih lum Juog ke cwihnye acielo kedea Wahy Juog anaa yi kuohme maa ngo anahg ngaa me beer keter. Ke nying gihn nu e nyoge mooge me thoohdh ge adoohng ne yaa yiiho. ");
INSERT INTO lwo_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kaano e Barnaba adaahd dhaano me kony ngo ke puohny nyoge. Gihn nu e kaa apuohny Coale kii ngo apare paro. Noono uaaye Antiog ne ci bang Coal Tarcuj ka me baahr. ");
INSERT INTO lwo_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Naa ayoade Coal e ngo akwaye ne beehn ne kony ngo ke puohny Antiog. Naa ayiih Coale e ge abeehn Antiog tiehd maa abeehd gene yea ke wong acielo e ge umahdo keehd yaa ayiiho kedea e ge upuohnyo ke nyoge me thoohdh. Anahg yi geen Antiog e naa kaa acag nying yaa ayiiho ne ‘Kriihjtyaane’ lum yea, yaa aboadh ke nying Jeacuu Ngad Boadh nyoge. ");
INSERT INTO lwo_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Anahg nye kaano thiow e naa a'aay nyoge mooge maa yaa agamloohng Jeacuu ke yoohn Jeruucalem ubeehn gene Antiog. ");
INSERT INTO lwo_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","E dhaano acielo kiin gen me nyinge Agabo maa arub Wahy Juoge yihre, ngo a'aj maalo maa ateede gihn muu uyug ree cahng moogo. Arobe kejea deeh kahj me duohng upahdh wudh nyoge ka me cahng. (Kahy ngo anaa apahdho maano e Klaawdio e naa jaah ne mag paajo) ");
INSERT INTO lwo_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kaano e yaa ayiiho lubo agwiir gene gwiiro ujwaar gene ngiihny me oohr bang yaa ayiiho giih beed Judea ne kony gen yi kahj. ");
INSERT INTO lwo_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Naa ajwaar gene ngiihny e Barnaba kedea Coal ge ake oohro Jeruucalem ne kahl ngiihny acong. ");
INSERT INTO lwo_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ge anaa puohny Barnabae maa Coale Antiog e naa kaa abeehn Eroade ruohdh uyuge giih ajohr me reje mee rog yaa ayiiho mooge. ");
INSERT INTO lwo_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Maa ateede ngo yihr acaakere kejea nahg Jeamij umiih Joon Jebeade. Noono ungol wiihe oogo ke pala uthowe. ");
INSERT INTO lwo_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Naa aniid Eroade ngo e gihn atiihye apahdh yi cwihny jo doong Judea, e bar maalo umage Piihter thiow. ");
INSERT INTO lwo_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Naa amag Piihtere e ngo akedh yi karkoohn maa awiie yi cing akuude angween giih acaaker karkoohn ne koaro. Akuud acielo yea anaa acaakere angween. Bang gihn anaa agweehg Eroade beere Piihter kahle ke nyum nyoge ne kihmo ke thoo batien Yaan Amono. ");
INSERT INTO lwo_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Abea e ane Piihtere yi karkoohn nu e yaa ayiiho ge anaa yi kway Juog keraahyo ke nyinge. ");
INSERT INTO lwo_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Piihter anaa abudo kiin acaakere ariow giih atuohye rog gen ke gele yi diih waahy cahng akoohb Eroade kejea ngo kahle ke nyum nyoge ne kihmo. Thiow acaakere mooge ge anaa ke kuro dhe baab duohng gihr karkoohn. ");
INSERT INTO lwo_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Yi diih waahy nu e wuohnjuog abeehn ne cuungo buud Piihter maa amage utog ngo ne tahng ngo. Naa atahng Piihter, e niid wuohnjuog kedea e piny ree ameenye. Maa adog Piihtere cwaahng. Maa arub wuohnjuoge yihre kobe, “Aj maalo piow piow.” Nye kaano e gele ge anaa lwang piny. ");
INSERT INTO lwo_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Batiene e wuohnjuog acahg rob kea, “Ngaab waaro gihri maa ngaab wuor yi tieni ubuodhi batiena.” Ungaab Piihtere waaro gihre kedea ungaabe wuor yi tiene ubuodhe batien wuohnjuog. ");
INSERT INTO lwo_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Noono e Piihter ake caahdho ke batien wuohnjuog ne ci oogo yi karkoohn uwahdhe kaa awii gene karkoohn piny. Mar Piihter cuohne kea ngo beehda laahg. ");
INSERT INTO lwo_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ge akahnho ke wudh akuud acaakere giih umodho kedea ucahg gene kahnho ke wudh riown akuude giih acaakere uwahdhe kaa atoohng gene dhe baab gihr ngiihnyo naa aciehg dhe oaj keehde. Baab ngo beehda baab me yahb yi geew. Noono uyab baabe ree e keede yihr gen. Uci gene oogo ne loony loony kedea ukwany gene bang acaar kwanyo uwahdhe kaa a'aay wuohnjuoge udoohng Piihtere e keede. ");
INSERT INTO lwo_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kaano e ngo angey Piihtere ngeyo naa adiehr kejea ngo abeehn oogo yi karkoohn. Maa akoohbe kea, “Wa gihn padh laahg! A kaa abeehn oogo yi karkoohn ne! Juog a akahle oogo yi cing Eroade maa jo doonge giih wan naa adaahd unahg gene an.” ");
INSERT INTO lwo_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Naa angey Piihtere ngo arumo kejea e tooro yi karkoohn, e ngo acaa paar miih Joon Maarko. Paan ngo nyoge me thoohdh ge anaa amahdo yea ne kway Juog ke nying Piihter. ");
INSERT INTO lwo_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Naa atuong Piihtere dhe baab oaj e nyaakow me nyinge Roada maa ngad tiihj paajo ake rihngo dhe baab. ");
INSERT INTO lwo_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Maa apeehye ke ngaa ne dhe baab. Abea naa angeye duon Piihter e cwihnye ake mihno keraahyo udooge doog ke ngweej ne rob ngo yihr nyoge kejea Piihter ne dhe baab yi kala. ");
INSERT INTO lwo_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Maa abeehr gene ngo yihre kob gene, “Yih ake muohle nya!” E ngo poohd e ngo niing Roada niingo kea, “Nye yaage! Beehda Piihter adiehr muon e ne cuung yi kala.” E ngo acahg gene ke beehro, “Ka moogo e beehda atiihbe giihe.” ");
INSERT INTO lwo_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","E Piihter adhal ke tuohng baab oaj. Noono ubeehn nyoge ne yab dhe baab. Naa aniid gene Piihter e ge ake cwaahng ne cohg unahg gene ne juuj ke rob. ");
INSERT INTO lwo_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Maa abeehn Piihtere utihnge cinge maalo kejea leng gene. Noono uteede gihn ayug ree naa abeehn Juoge uoohre wuohnjuog ne luny ngo oogo yi karkoohn. Maa arobe ngo yihr gen kejea rob gene gihn ayug ree yihr Jeamij maa yihr yaa ayiiho cang. Ubeehn Piihtere uaaye ucea ka moogo. ");
INSERT INTO lwo_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","E anahge ke nyango arumo e acaakere giih koar wudh gen anaa cohd ke gihn ayug ree rih Piihter. Maa atud gene ke gihn uyug rog gen. ");
INSERT INTO lwo_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ubeehn Eroade urobe ngo kejea daahd gene Piihter. Ngo acej abea kuu ayoad. Naa abahnge Piihter kuu ayoad e Eroade arubo kejea yoad acaakere giih anaa ke kuro cahng nu nahg gen. Batien gihn nu, e Eroade ake aay ubeehne Cejearya ne beehdo yea tudi. ");
INSERT INTO lwo_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Eroade yihre anaa mahn keehd yaa geen Taayr kedea yaa geen Ciihdoan. Maa abeehn yaa wudh geedhe giih ni arumo umad gene lubo beere ge beehn bang Eroade tiehd. Ge akuong ci bang Blaajtuj umodho beere ge konye konyo ke rob yihr ruohdh. Noono ucidh gene bang Eroade ne rob ke nying doohr bang gihn caame ge ngeew gene kii dhaahr Eroade. ");
INSERT INTO lwo_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Yi cahng akob naa Eroade urubo ke nying doohr, e ngo ake ngahbo keehd waay ruohdhe. Noono upiihe wiih koom gihre urube yihr yaa anaa abeehn bange. ");
INSERT INTO lwo_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Naa athume ke rob arumo, e nyoge cang naa anudo wiih ngo aweng gene oogo ke giih toohd e ge teeng koohdh gen kob gene, “Yaahy! Wa gihn padh duon dhaano! Wa ngo beehda Juog ke ngude e naa arubo!” ");
INSERT INTO lwo_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nye kaano e Eroade angol wuohnjuoge ke maalo kaa atwaany bang gihn abahnge ngo keá jaahyo yihr nyoge kejea e be rom ke Juog. Maa athub tuohnge ke cam yeye batiene e thow. ");
INSERT INTO lwo_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Maa abeehn nyoge me thoohdhe ulihng gene lum Juog kedea uyiih gene ngo. ");
INSERT INTO lwo_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Naa abeehn Barnabe ge ke Coal uthum tiihy gene naa abeehn gene ke nyinge Jeruucalem, e ge ake aaye tiehd keehd Joon Maarko, ne ngaa me kony gen ke tiihj. ");
INSERT INTO lwo_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kiin yaa ayiiho giih anaa Antiog, nyoge maa yaa agamloohngjuog kedea yaa puohny lum Juog ge anaa anudo. Yaan nu ge anahg ge Barnaba kedea Cimon Macaahr, Lucio ngad Ciriihna maa Manem gom Eroade e nahg muudiihr kedea Coal arumo. ");
INSERT INTO lwo_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Yi nihn maa anaa abahnge yaa ayiiho ge be cahmo ke nying cub wudh gen ne kway Juog cog, e Wahy Juog ake rubo yihr gen kea, “Barnaba maa Coal ge daahda daahdo ne waahdh ke wudh miehr beere lum Juog puohny gene puohnyo yihr nyoge. Gwiiru gen yihr Juog ke nying tiihy nu.” ");
INSERT INTO lwo_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Naa ateed Wahy Juoge gihn nu yihr gen, e ge abar maalo ke kwaj ke nying Barnaba maa Coal. Batiene e cing gen acub gene ke wiih Barnaba kedea wiih Coal ne cub gen yi tiihy Juog kedea ne wiihw gen. ");
INSERT INTO lwo_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnaba ge keehd Coal maa Joon Maarko ge aci Celuucya neehn kaa aoohr Wahy Juoge gen. Noono uaay gene keehd baabuur Celuucya ne beehn wiih thuur Caaypruj. ");
INSERT INTO lwo_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Naa abeehn gene paajo me nyinge Calamij, e ge acaa yi wuud amaad giih yaa Judea ge nii geen nu ne puohny lum Juog. ");
INSERT INTO lwo_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Maa acaahdh gene ke bang yi thuur uwahdhe kaa awahnh gene geen Papoj. Yi geen ni e naa anaa aroohm gene keehd Ujudea me nyinge Elimaj Waahd Jocwa. Ngo anahg ngad yaadh me teed toohd kea e agamloohngjuog. ");
INSERT INTO lwo_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Elimaj anahg gom maamuur gihr thuur gihn abeehn gene yea ni. Maamuur me nyinge Cerjo Paaulo. Ngo anahg ngaa me wonge teeg keter. E nahg cahng ni arumo e maamuur Barnaba ge ke Coal ge acuohne cuohno paare beere lum Juog lihnge lihngo. ");
INSERT INTO lwo_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Abea Elimaj acuungo yi yoohn Barnaba maa Coal beere Cerjo lum Juog be yiihe. ");
INSERT INTO lwo_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Noono maa amaahny Coale bang ngad tiehd gihn teeg mee bang gihn rob me teeg daahd Wahy Juoge kaa cubo yihre. ");
INSERT INTO lwo_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Maa arube kea, “Ngad toohde! Yih ngaa maa gihn e yeyi apahng ke giih waane! Adhaahr yih daahd umedi Juog! Yih ka daahd ngo beere luub arob Jeacuue ge uwulo ne! Adoohng e yih urubo yihr ngaa daahd ulihnge lum Juog kejea giih toohd keá lihnge! ");
INSERT INTO lwo_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Beehda gihn e nuu ukony yihn yi cing Juog tihn! Me neehn awaahn kan e wongi ucoor uwahdhe ka ubeehn Juoge uyabe ngo.” E Elimaj deeh gihn me col aguo ne niihm yi wonge. Uthube thubo kaano keehd waahdh e ngo man piny e daahd ngaa me piej en. ");
INSERT INTO lwo_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Maamuur naa aniide giih ayug rog gen e lum Juog abeehne ke ne yiiho ke cwihnye cang ke nying kaa arub Poale ke nying Jeacuu kii ngo. (Nying Coal moogo anahg Poal). ");
INSERT INTO lwo_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Poal keehd jo waahdhe ge aay ke baabuur Papoj ubeehn gene geen Pearga yi muudiihrya gihr Pampiihlya. Kaano e naa abeehn Joon Maarko udoge Jeruucalem. ");
INSERT INTO lwo_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Maa a'aay Poale keehd Barnaba ubar gene geen Antiog gihr Piciihdya. Naa anahge Cahng Juog, e ge acaa yi wod amaad maa apiih gene. ");
INSERT INTO lwo_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Batiene kaa athum ngaa kwaahno yi kitaab loohng Moaje kedea giih agweed yaa agamloohngjuoge, e yaa doonge giih wod amaad lubo aoohr gene oohro yihr Poal maa Barnaba kob gene, “Jo paar wan, cwihny wan ne bange urubu yihr nyoge ke luub tee aduulo.” ");
INSERT INTO lwo_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Maa abeehn Poale uaje maalo kare kedea utihnge cinge maalo kejea leng gene. Maa arube kobe, “Wu jo paar wan, wu yaa Yijarael maa wu yaa padh Judea ni, wu cang ge abeehn kan ne wuor Juog tihn, lihngu gihn roba. Juog gihn wuor wane, wa yaa Yijarael ngo ngahyu. ");
INSERT INTO lwo_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ngo ngahyu thiow kejea e naa akwany ge kuow wan naa acoon. Noono ubeehn Juoge umeehge ge thoohnho kaa anahg gene aleye yi piny Micihr. Abea ge akahl Juoge oogo Micihr ke teeg mare. ");
INSERT INTO lwo_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ubuohje ke gen ke run jiehariow yi ukang, keehd maano abahnge Juog kuu anaa cub gene yi cwihny gen nu. ");
INSERT INTO lwo_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Thiow thaahy abiihjberiow ge ameehg Juoge taayo ukeedh gene kedea uluuny yaa Yijaraele piny gen ge cuohn ne Kanaan. ");
INSERT INTO lwo_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Na nahg Juog e ne kwany ngaa duohng nyum Judea ke run me thoohdh naa athube kii cahng ataaye thaahy nu abiihjberiow. Naa akwanye Camweel agamloohngjuog ne ngaa duohng, e anahg run jiehabiihje angween ke jiehariow wonge apaar batien kaa athub Juoge ke kwany ngad nyum Judea. ");
INSERT INTO lwo_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Kwaad ngaan na kwany Juoge e naa ngaan na lug giih paar Judea. Kaano e yaa Yijarael wong Camweel akway gene beere ngo ukwahnyo kiin gen ke ngaa duohng yaa lam. Gihn nu e Coal ge waahd Kij, e ngad dhe wod Benjamin, e naa ameehg Juoge kwanyo yihr Camweel ne ngaa duohng yaa lam mar umodho gihr yaa Yijarael. Coal abeehdo yi ruohdh ke run jiehariow. ");
INSERT INTO lwo_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Coal akahle oogo yi ruohdh naa abeehn Coale udhahle lum Juog. Noono ucube Deabid kuowo wiih koom bang gihn ngo anahg ngaa maa anhyaar Juoge. Gihn anaa arob Juoge ke nying Deabid ngo ngahyu naa akoohbe kea, ‘Deabid, waahd Jeci e naa ngaa me nhyaara, e naa ngaa tiihy kwaad gihn daahda.’ ");
INSERT INTO lwo_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Yaage, cwihnya ne rob ke nying kwaar Deabid ge nyinge awiihj. Ngaan nyinge Jeacuu. Jeacuu Juog e naa aoohr ngo ne boadh wan wa Judea wa kaa arobe ngo kuu umodho. ");
INSERT INTO lwo_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","E poohde e Jeacuu kuu athubo ke tiihye, e Joon yaa Yijarael me thoohdh ge abeehne ne puohnyo kejea maan gene anyoohne giih ayug gene kedea wii gene ge piny beere wudh gen ke muojo ke piih luogwahy. ");
INSERT INTO lwo_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Naa acahng kaa athum tiihy Joone, e Joon anaa arubo kea, ‘A padh ngaan anaa arob kejea ngo ubeehn ke nying boadh nyoge. Ngaan ngo ubeehn kaa batiena. Ngo ngaa me duohng nyuma me kwaad gihre me koohbe kea tiihya ngo e ngo tiihya tiihyo yihre. Keehd wuoy tiene ge be roma cod yi tiene ke nying gihn duohnge nyuma.’ ");
INSERT INTO lwo_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Wu jo paar wan, yaa Yijarael ge kwaay Abraahm kedea wu yaa padh yaa Yijarael, wu ge wuor Juog, Juog dhaano anaa aoohre yihro ne nyoadh ka uboadhe won kii ngo. ");
INSERT INTO lwo_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","29","Yaage, modhu ubahnge giih apar jo doonge maa yaa beed Jeruucalem ge be paru. Ke nying cahng kway Juog, cahng becien nihn, e ge umahdo ne kwaan giih agweed yaa agamloohngjuoge coon. Abea poohd dahng e gihn me yoad gene yihdh giih nu agweed tooro, e naa gihn bahnge ngo be yiih gene kejea Jeacuu e naa Ngad Boadh nyoge. Noono uteed gene ngo yihr Pilaato kejea gure Jeacuu ngahy yaadh maa ariihw abea kihd awuohj me thiin maa atiihye tooro me nahge ke nyinge. Pilaato anaa akweer abea naa ateel gene yea lubo e gihn adaahd gene ayiih Pilaate yihr gen. Naa athum Judea ke tiihy giih daahd gene ke tiihyo rih Jeacuu, e ngo akahl yaae ge na caahdhe keehd gen oogo wiih yaadh ukoany gene ngo. E naa kaa abeehn giih anaa agweed yaa gamloohngjuoge kejea ge utiihy rog gen yi thon Ngad Boadh Nyoge utiing gene rog gen kar gen. ");
INSERT INTO lwo_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Abea wahye anaa abeehn Juoge ne duog ree ucahre. ");
INSERT INTO lwo_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Batien cahro e ree na nyoadhe nyoadho ke kar nihn me thoohdh yihr yaa na caahdhe keehd gen ke bang Gaalili maa ke bang Jeruucalem. Yaa nu ge naa yaa arob adiehj cahr Jeacuu yi thone kedea gen naa arob leebe yihr yaa Yijarael. ");
INSERT INTO lwo_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Wa abeehn ne rob Ciig Beer yihru. Ciig Beer ge anaa arob Juoge kejea ngo uyuge yihr ge kuowo wo yaa Yijarael. Giih nu ayug Juoge wa kaa ateede ngo yihro wo nyethen Yijarael kedea ngo ayuge thiow yihr nyethen nyoge me padh yaa Yijarael. Ngo ayug Juoge naa abeehne umeehge Jeacuu cahro yi thone neehn kaa anaa agweede yi kitaab mar Wahy Apoong Juog kejea, ‘Ke tihn ungahy nyoge cang, e yihn naa ngaa acuba ne rob leeba neehn nyethiin yeya.’ ");
INSERT INTO lwo_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kedea gihn e naa gihn arob Juoge ke nyinge ne nyoadh ngo kejea Jeacuu ngo buu ucahg thoo keehdo, ‘Wu umuoja keehd ruohdh me beer ne cohg unahge e naa ruohdhu cog, ruohdh moogo tooro. Wu uneehn en e be thow bang gihn ngo ubeehdo tiehd keehd wun. Gihn utiihya bang gihn beehda leeb maa ateeda yihr Deabid ree be rome waaro.’ ");
INSERT INTO lwo_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Thiow coon Ngad Boadh nyoge anaa arubo ke nyinge yi Wahy Apoong Juog naa akoohbe kea, ‘Ngo ngahya kejea Juog kuohma buu umeehge tobo bang gihn a beehda Waahde maa anhyaare!’ ");
INSERT INTO lwo_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Adiehr muon Deabid yaa dhaahre ge akaahne beer mee. Naa athum tiihye yihr Juog e ngo athow, ukoanye kedea kuohme atob yi buur. ");
INSERT INTO lwo_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Abea naa anahge mar Jeacuu e ngo atahng Juoge naa athowe ubahnge kuohme be tob yi buur. ");
INSERT INTO lwo_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“Wu yaa nud kan cang, ngo ateed wane yihru kejea anyoohne giihu naa ayugu nyum Juog ge wii piny yihru nea lum Jeacuu ayiihu. Keá paru ke wudhu kejea loohng Moaje anyoohne giihu ge wuunye ke oogo. Gihn wuuny gen oogo beehda yiiho gihru ne yiihu Jeacuu ne Ngad Boadh Nyoge. ");
INSERT INTO lwo_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Cubu nyingu piny beer mee ubahnge kwaad giih arob yaa agamloohngjuoge wu be yoad gene. Anaa arob Juoge yihr gen kea, ");
INSERT INTO lwo_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Lihngu gihn wu yaa adhaahr gihn arob Juoge, liihdhu ne naang uwahdhe kaa thowu! Bang gihn kwaad gihn utiihya e wu poohd kuow padh gihn muu uyiihu keehd me rob ngaa mooge lum yea yihru.’ ” ");
INSERT INTO lwo_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","43","Naa athum nyoge ke kwaj, e nyoge me thoohdh ge adaahd udog gene puohny ge Poal ke lihngo maa ateed gene ngo yihr ge Poal kejea dog gene duuo Cahng Juog gihn beehn ni. Kaano a'aay ge Poale maa Barnaba, e batien gen abuodh nyoge mooge. Maa apuohny gene gen ke yihdh nihn nu kejea nhyaahro gihr Juog yoad kaa dhe yoohn yiih lum Jeacuu. Goan yaa apuohny yihdh nihn nu ge anahg Judea kedea goan mooge ge anahg yaa beed geen nu abea rog gen alog gene ne Judea ke dhe yoohn ka wuor gene Juog kii ngo. ");
INSERT INTO lwo_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Naa anahge Cahng Juog arumo, e nyoge me thoohdh ge ake waahdo ke bang yi buur geew ne lihng lum Juog bang ge Poal. ");
INSERT INTO lwo_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Naa aniid jo doong Judea ngo e nyoge me thoohdh amahdo, e cwihny gen arahnyo urob gene giih me reje rog ge Poal kedea ukob gene ngo kejea Poal rob giih toohd. ");
INSERT INTO lwo_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Abea naa abeehn Poale maa Barnabe ungahy gene ngo kejea yaa ni ge akweer ke yiih lum gen e ge arub oogo e kihd lwahr tooro rog gen kob gene, “Wu Judea giih dhahl lum wan, nea ne nahg kare ne cohg, e ne nahg wun ne ne kuong lum Juog ke lihngo umodho bang wan. Abea naa akweeru kweer ke yiih lum Juog, e wu keedu wu naa ayug rogu ne kwaad nyoge me boadh wahy be yoadu. Wu uwii wane ucidh wane ne puohny yaa beed geen ni. ");
INSERT INTO lwo_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Lum arob Juoge yihr wan teeg mee yea be woj wane piih. Ateede kea, ‘Lubo aroba yihru ne cidho ke bang wudh geedhe me bahye. Teedu ngo yihr yaa yihdh geedh nu kejea kihd ngaa uyiih luma ngo uboadha.’ ” ");
INSERT INTO lwo_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Naa alihng yaa padh Judea giih arob ge Poale, e cwihny gen ake mihno maa arub gene kejea, “Lum ni beer ne cohg.” Noono udoohng yaa akwany Juoge bang uboadhe wahy gen ne nyoge maa ayiiho. ");
INSERT INTO lwo_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Gihn nu e nyoge me thoohdh lum Juog abeehn gene ne lihngo. ");
INSERT INTO lwo_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Abea yaa Judea giih alyaahb ayug gene naa acoam gene yihdh jo doong paajo maa yihdh maahn yaa padh Judea, maahn me doonge me ngahy paaje kedea maa yaa wuor Juog. Yihdh yaa ni acoam gene noono ubeehn nyoge utaahny gene rog ge Poal maa Barnaba uwahdhe kaa adhiil gene aay. ");
INSERT INTO lwo_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Maano e ge Poal maa Barnaba ge a'aay e dhab tien gen adhoohng gene ne nyoadh ngo yihr Judea akweer ke lihng lum Juog, kejea ge wag kaa cuohno ne Judea. Kaano e ge a'aay ucidh gene Yikoohnya. ");
INSERT INTO lwo_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Keehd maa anaa a'aay ge Poale, e yaa ayiih lum Jeacuu ge abeehdo e cwihny gen med bang gihn ge amuoj Wahy Juoge ke med cwihny kedea kar beehd beer ke rog anyoadhe yihr gen. ");
INSERT INTO lwo_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Naa awahnh Poale maa Barnaba yi geen Yikoohnya, e ge acaa yi wod amaad gihr Judea ne puohny nyoge. Ge apuohnyo e ge rubo kaa nying Jeacuu kedea maa abeehn nyoge me thoohdh uyiih gene lum ge Poal. ");
INSERT INTO lwo_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Abea Judea maa akweer ke lum Jeacuu neehn yaa anaa akweer Antiog gihr Piciihdya ge anudo. Noono uthub gene ke maahd ge Poal maa yaa ayiih lum gen. Thiow yihdh yaa yi geew mooge ge acoam gene udhiil cwihny gene rahnyo rog ge Poal maa yaa ayiih lum gen. Gihn nu e yaa ni thiow ge Poal amaahd gene maahdo. ");
INSERT INTO lwo_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Abea keehd maano acoam yihdh nyoge nu, e ge Poal anaa aceng yi geen nu keree e ge rob lum Jeacuu yihr nyoge e lwahr tooro rog gen. E Juog thiow tee acube yihr gen ne tiihy giih me gaahy nyoge ne nyoadh ngo kejea giih rub gene ke nying gen ge beehda adiehr. ");
INSERT INTO lwo_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Gihn nu e geew ree apaahnge paahngo ne dahg, yaa ne kur Judea naa akweer ke puohny ge Poal kedea yaa ayiih puohny ge Poal. ");
INSERT INTO lwo_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Abea kihde now, yaa Judea maa yaa padh Judea, e kuu ayiih lum ge Poal, lubo amad gene ke piny. Lubo amad gene maa jo doong gen beere Poal maa Barnaba ge ke bahno ukedh ngwiilo rog gen. ");
INSERT INTO lwo_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Kaa angey ge Poale gihn adaahd ke yugo rog gen, e ge agoohd yi muudiihrya gihr Liikoanya e nahg geedh Lijtera maa Derba yea. Noono maa apuohny gene Ciig Beer ge rubo ke nying Jeacuu ni yihdh geedh Lijtera maa Derba kedea ke bang yihdh miehy cahng ke gen. ");
INSERT INTO lwo_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yi geen Lijtera, nyin moogo maa abab piny anaa anudo me kuu akuong waahdh ke kaa anyuole nyuolo. ");
INSERT INTO lwo_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ngo anaa apiih ne lihng luub Poal. Maa aniid Poale ngo ne ngaa maa ayiiho ke cwihnye beehd kedea rom kaa thiehdho. E Poal nyin amaanye duugi ");
INSERT INTO lwo_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","maa arube yihr ngo e duone atihnge maalo kea, “Aj maalo ucuungi wudh tieni ne cohg.” E nyin ni apaahr maalo ucuunge wudh tiene uthube ke wen piny. ");
INSERT INTO lwo_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Naa aniid gihn ayug Poale ni, e nyoge anaa juuj ke rob ke dhe Liikoanya kob gene, “Niidu gihn ayug yaa ni! Wa ge tiihy giih yug Juoge! Nye yaage pahdh joohy giih beed maalo ge naa alog rog gen ne nyoge ubeehn gene piny ne!” ");
INSERT INTO lwo_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Noono arumo maa acag gene nying Barnaba ke nying yaanh gihr gen e cuohn ne Jaayo, e nying Poal ke nying yaanh gen e cuohn ne Ehrmej, bang gihn anahg Poal e ne rubo. ");
INSERT INTO lwo_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kaano e ngaa wiihe ne yaanh cuohn ne Jaayo maa yaa batiene ge adaahd nahg miehre ke nying jo oohr neehn ka na yug gene ngo ke nying Jaayo. Gihn nu e miehre kedea thiiw ge akedh gene dhe wod wuor yaanh Jaayo yea. Wod ngo anaa ageer dhe geew. ");
INSERT INTO lwo_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kaano e nyoge aoohr bang ge Barnaba ne cuohn gen kar yaay. Naa alihng ge Poale gihn daahd nyoge ke tiihyo ke nying gen, e ngo amaan gene. Noono ugoohd gene kaa amahd nyoge yea e ge ukwaago kob gene, “Cuungu do! Gihn nu keá themu piny!” Kaa awahdh gene e ge arubo yihr nyoge kob gene, ");
INSERT INTO lwo_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Yaage, gihn daahdu ke yugo keá themu piny. Ngaa maa Juog tooro kiin wan. Wa nyoge now me neehn wun. Wa abeehn kan ne puohny wun ke lum Juog Aciehg. Juog gihn acag maalo ke piny maa laahy kedea nahme maa giih beed yihdh gen. Wa daahd unyoadh wane kaa anhyaar Juog Aciehge wun kii ngo. Noono unahge ke en ne wuoru kedea beere yiehdhe giih gihr nying gen tooro ge be cahgu ke wuoro. Thiow beere giih remo be cahgu ke naah yihr yiehdhe giih gihr nying gen tooro ni. ");
INSERT INTO lwo_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Umodho coon Juog wu anaa wiie uyugu kwaad giih daahdu ke cwihnyu. ");
INSERT INTO lwo_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Abea keehd maano e Juog beeye na nyoadhe nyoadho ke yoohn kwaad giih beey naa atiihye. Kodh cube cubo yihru maa alwaa giih nyepinye ucieg yihdh puohdhu. Juog e ne cub cam yihru uyahngu kedea e ne cub med cwihny yihru. Juog gihn yug kwaad giih nu e ne dhiilu ke wuoro.” ");
INSERT INTO lwo_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Abea keehd maano arub ge Poale yihr gen wa maano nu, e nyoge poohd dahng e ge adaahd ngo unahg gene gihr remo piny rog jo oohr ne wuor gen wa yiehdhe. Abea naa abuohj ge Poale ke rob yihr gen duugi e wudh gen adhiil gene ke waaro. ");
INSERT INTO lwo_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kaano e Judea maa abeehno ke yoohn Yikoohnya maa Antiog gihr Piciihdya wudh nyoge alog gene ne maan Poal maa Barnaba. Maa ataahny gene ke rih Poal arumo ubahn gene ngo keehd leele, uywaay gene ngo oogo loo geew cuohn gene e ngo athow. ");
INSERT INTO lwo_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Abea naa abeehn yaa ayiiho bang Poal ne maanye, e Poal a'aj maalo piny kaa aywaaye yea. Noono udo Poale kii buur geew keehd gen. Naa aruu pinye, e Poal maa Barnaba ge a'aay uci gene Derba. ");
INSERT INTO lwo_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Yaa geen Derba ge apuohny Poale maa Barnaba ke Ciig Beer maa ayiih nyoge me thoohdhe lum Juog. Thiow ge ake rubo ke luub tee aduulo yihr yaa ayiiho. Batiene e ge ake doog kuu wudh tien gen udog gene Lijtera kedea Yikoohnya maa Antiog gihr Piciihdya. ");
INSERT INTO lwo_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Noono e ge acaahdho e ge urubo yihr yaa ayiiho kejea mag gene lum Juog ke cwihny gen me teeg mee bang gihn ngaa ayiih lum Juog giih ajohr me teeg ge dhiile kaa guumo beere Dhaahr Juog yoade yoado. ");
INSERT INTO lwo_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ke bang wudh geedh acaadh gene e ge Poal nyoge na kwany gene kwanyo me wiie gene akuud yaa ayiiho yi cing gen. Batien ka akwany gen, e ge akwahyo kedea ukweehr gene cam ne cub gene yi cing Juog. Juog gihn nhyaar gene beere ge dooje doojo. ");
INSERT INTO lwo_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","26","Batiene e ge ake thubo ke do Antiog geen anaa acub jo oohre gen yi cing Juog. Yi waahdh doog gihr gen noono, e ge caahdh e ge puohny nyoge. ");
INSERT INTO lwo_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Naa abeehn gene Antiog, e yaa ayiiho acong gene ne dug. Noono uyoad gene kwaad giih doong naa atiihy Juoge ke nying gen yihr yaa wudh geedh akaahn gene ukwaan gene gen yihr gom gen. Ge arubo thiow ke nying kaa abeehn Juoge uyabe dhe yooh yihr yaa padh Judea ubeehn gene uyiih gene Ciig Beer. ");
INSERT INTO lwo_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Poal maa Barnaba ge anaa aceng keree keehd yaa ayiiho giih Antiog gihr Ciihrya. ");
INSERT INTO lwo_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nyoge mooge ge anaa abeehn Antiog ke yoohn Jeruucalem. Noono uthub gene thubu ke puohny akuud yaa ayiiho ke kwaad puohny me ne keede kob gene, “Wu yaa kuu athoam nea wu be ke thoamo wa kaa arob loohng Moaje ngo e ka me boadh Juoge wahyu tooro.” ");
INSERT INTO lwo_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Puohny ni deeh peehm akahle kiin yaa ni keehd ge Poal maa Barnaba. Naa adoohng peehme duohng kiin gen, e Poal maa Barnaba kedea yaa Antiog mooge ge akwany ne ci Jeruucalem bang jo oohr maa jo doonge ne rob ke nying lum ni kob naa thoam yaa padh Judea beere ge boadh Juoge boadho. ");
INSERT INTO lwo_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Gihn nu e akuud yaa ayiiho gihr Antiog Poal maa Barnaba ge awiihw gene naa a'aay gene. Abea naa acaahdh gene caahdho e ge cor yihdh geedh Peaniihcya maa Camaarya nu, e ge caahdh e ge teed dhe yoohn kaa abeehn nyoge me padh Judea uyiih gene lum Juog. Naa alihng akuud yaa ayiihoe luub ni, e cwihny gen ake mihno ne cohg. ");
INSERT INTO lwo_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Naa awahnh gene Jeruucalem, e ge alor akuud yaa ayiihoe maa jo doonge beer me. Noono ukwaan gene giih ayug gene yihr yaa anaa Jeruucalem. Giih ayug gene ke tee gihn acub Juoge yihr gen. ");
INSERT INTO lwo_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Abea e yaa Paarijea maa adoohng ne yaa ayiiho ge a'aj maalo ungweel gene ngo piny kob gene, “Nyoge me padh Judea ge dhiil ka thoamo kedea ke robo yihr gen kejea yug gene kwaad giih arob loohng Moaje cang.” ");
INSERT INTO lwo_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kaano arumo, e jo oohr keehd jo doonge cang, wudh gen amad gene mado beere yi lum ni maany gene maanyo ne cohg. ");
INSERT INTO lwo_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Batien kaa arub nyoge ke deeh ka me laaj, e Piihter a'aj maalo urube kobe, “Jo paar wan, ngahyu thiow kejea coon umodho Juog a naa akwanye kiin wun ne ci ne puohny Ciig Beer yihr nyoge me padh Judea beere lum Juog beehn gene ke ne lihngo maa uyiih gene ngo thiow. ");
INSERT INTO lwo_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","E Juog ngaa ngahy giih yihdh aduun nyoge cang Wahy Juog acube yihr yaa padh Judea neehn kaa acube ngo yihro ne nyoadh ngo kejea ge thiow, ge adoohng ne nyoge maa ayiih lum Juog neehn won. ");
INSERT INTO lwo_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Juog kiino keá pojo keehd gen, bang gihn anyoohne giih gen ge awiie piny thiow ke nying gihn ayiih gene lum Juog. ");
INSERT INTO lwo_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Juog atumu ne cohg kedea dhee akalu naa acubu adoohdo wudh yaa padh Judea. Adoohdo me kuu anaa arom ree ke tiehdo yihr ge kuowo naa acoon kedea keehd won e nud awaahn ni. ");
INSERT INTO lwo_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Abea yiiho gihro e naa aboadh won ke nying Muuny Juog naa ayoado bang Jeacuu Ruohdh. Wa gihn nu thiow e yaa padh Judea ge aboadh Juoge ke nying Muuny Juog naa ayoad gene bang Jeacuu Ruohdh.” ");
INSERT INTO lwo_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nyoge anaa aleng ne caaj ne lihng rob Poal maa Barnaba naa akwaan gene kaa ayiih yaa padh Judea lum Jeacuu kedea ge arubo thiow ke nying thoohn giih me gaahy nyoge naa ayug gene kiin yaa padh Judea ke teeg mar Juog. ");
INSERT INTO lwo_vpl VALUES ("AC15_13","074_1