﻿USE sofia;
DROP TABLE IF EXISTS sofia.luo_vpl;
CREATE TABLE luo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES luo_vpl WRITE;
INSERT INTO luo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Kar chakruok Nyasaye nochweyo polo gi piny. ");
INSERT INTO luo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Koro piny ne onge kido kendo ne onge gimoro amora e iye. Mudho mandiwa noimo ataro mangʼongo kendo Roho mar Nyasaye ne wuotho ewi atarono. ");
INSERT INTO luo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Eka Nyasaye nowacho niya, “Ler mondo obedie,” mi ler nobetie. ");
INSERT INTO luo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nyasaye noneno ni ler ber, kendo ne opogo ler kuom mudho. ");
INSERT INTO luo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nyasaye noluongo ler ni “odiechiengʼ” kendo mudho noluongo ni “otieno.” Piny noyuso, kendo noru ma en chiengʼ mokwongo. ");
INSERT INTO luo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Eka Nyasaye nowacho niya, “Gima pogo pi mondo obedie mondo opog pi gi pige.” ");
INSERT INTO luo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Omiyo Nyasaye noketo gima pogo pi mamalo gi pi ma piny. Kendo nobedo kamano. ");
INSERT INTO luo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nyasaye noluongo gima nopogo pigno ni “polo.” Piny noyuso kendo noru, ma en chiengʼ mar ariyo. ");
INSERT INTO luo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kendo Nyasaye nowacho niya, “Pi manie bwo polo mondo ochokre kaachiel, kendo lowo motwo obedie.” Kendo notimore kamano. ");
INSERT INTO luo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nyasaye nochako lowo ni “piny” kendo pige mane ochokore nochako ni “nembe.” Kendo Nyasaye noneno ni mano ber. ");
INSERT INTO luo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Eka Nyasaye nowacho niya, “Buya nyaka nyag e piny, kothe manyago cham kod yiende manyago olembe man-gi kuthe eigi kaka kitgi obet kendo nobedo kamano. ");
INSERT INTO luo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Buya nonyak e piny: Cham nonywolo kothegi kaka kitgi nobet kendo yiende nonywolo olembe man-gi kodhi kaka kitgi nobet. Kendo Nyasaye noneno ni mano ber. ");
INSERT INTO luo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Piny noyuso kendo noru, ma en chiengʼ mar adek.” ");
INSERT INTO luo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Bangʼe Nyasaye nowacho niya, “Ler mondo obedie e kor polo mondo opog odiechiengʼ gi otieno, kendo gibed kaka ranyisi mag lokruok ndalo kod odiechienge, kod higni, ");
INSERT INTO luo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","kendo ginibedi ler mae kor polo mondo gi chiw ler e piny.” Kendo nobedo kamano. ");
INSERT INTO luo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nyasaye noloso gik moko ariyo madongo makelo ler; ler maduongʼ ne rito odiechiengʼ, to ler matin ne rito otieno. Sulwe bende noloso. ");
INSERT INTO luo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nyasaye noketogi e kor polo mondo gi chiw ler e piny, ");
INSERT INTO luo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","mondo girit odiechiengʼ gotieno, kendo gipog ler koa kuom mudho. Nyasaye noneno ni mano ber. ");
INSERT INTO luo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Piny noyuso kendo noru, ma en chiengʼ mar angʼwen. ");
INSERT INTO luo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kendo Nyasaye nowacho niya, “Pi mondo opongʼ gi gik mangima, kendo winy mondo ofu ewi piny e kor polo.” ");
INSERT INTO luo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kamano Nyasaye nochweyo gik madongo mag nam kod gik mangima duto kod gik malak mag pi, kaka kitgi obet kod winy duto man-gi bwombegi kaka kitgi obet. Nyasaye noneno ni mano ber. ");
INSERT INTO luo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nyasaye nogwedhogi kendo owacho niya, “Nywolreuru kendo umedru kuom kwan kendo upongʼ pi mag nembe kendo winy bende omedre e piny.” ");
INSERT INTO luo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kendo piny noyuso, kendo noru, ma en chiengʼ mar abich. ");
INSERT INTO luo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kendo Nyasaye nowacho niya, “Piny mondo onywol gik mangima kaka kitgi obet: Jamni, kod gik moko duto mamol e lowo, kod le mag bungu, mana kaka kit moro ka moro obet.” Kendo nobet kamano. ");
INSERT INTO luo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nyasaye noloso le mag bungu kaka kitgi obet; jamni kaka kitgi obet kendo gi gik mamol e lowo kaka kitgi obet. Nyasaye noneno ni mano ber. ");
INSERT INTO luo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Eka Nyasaye nowacho niya, “We wachwe dhano e kido machal kodwa kendo gibed gi teko ewi rech mae nam kendo gi winy mae kor polo, ewi jamni, ewi piny duto kendo ewi chwech duto mawuotho ewi lowo.” ");
INSERT INTO luo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kuom mano Nyasaye nochweyo dhano e kite owuon, e kit Nyasaye nochweye; nochweyogi dichwo gi dhako. ");
INSERT INTO luo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nyasaye nogwedhogi mi owachonegi niya, “Nywolreuru kendo kwanu omedre; pongʼuru piny kendo urite. Beduru gi teko ewi rech ma e nam kod winy mae kor polo kendo ewi gik mangima duto mawuotho ewi lowo.” ");
INSERT INTO luo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Eka Nyasaye nowacho niya, “Amiyou kothe duto manyago cham e wangʼ piny duto kod yiende duto man kod olemo gi kodhi eigi. Ginibed magu kuom chiemo. ");
INSERT INTO luo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","To ne le duto mag piny kod winy duto mafuyo e kor polo kod gik moko duto mawuotho e piny, gimoro amora mangima; amiyo lum duto mondo obed chiembgi.” Kendo nobedo kamano. ");
INSERT INTO luo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nyasaye nongʼiyo gik moko duto mane osechweyo kendo noneno ni gibeyo ahinya. Piny noyuso kendo noru, ma en chiengʼ mar auchiel. ");
INSERT INTO luo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kuom mano chwech polo gi piny norumo gi gik mane ni eigi duto ka moro ka moro oket kare. ");
INSERT INTO luo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","E odiechiengʼ mar abiriyo Nyasaye nosetieko tichne mane osebedo ka otimo; omiyo odiechiengʼ mar abiriyo noyweyo kuom tijene duto. ");
INSERT INTO luo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kendo Nyasaye nogwedho odiechiengʼ mar abiriyo mi owale obedo maler, nimar odiechiengno ema noyweyoe bangʼ tieko duto. ");
INSERT INTO luo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ma e nonro mar polo kod piny kane ochwegi. Kane Jehova Nyasaye ochweyo piny kod polo; ");
INSERT INTO luo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ne onge buya mane osetwi e piny kendo ne onge yien mane osedongo nikech Jehova Nyasaye ne pok ooro koth e piny kendo ne onge dhano mawuotho ewi lowo, ");
INSERT INTO luo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","kata kamano achiya mar pi ne wuok koa ei lowo kendo ne omiyo piny duto obedo mangʼich. ");
INSERT INTO luo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Eka Jehova Nyasaye nochweyo dhano gi lowo kendo nokudho muya mar ngima ei ume, mi dhano nobedo mangima. ");
INSERT INTO luo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Eka Jehova Nyasaye noloso puodho ma yo wuok chiengʼ mar Eden, kendo noketoe dhano mane osechweyo. ");
INSERT INTO luo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Eka Jehova Nyasaye noketo kit yien duto mondo onyagi ewi lowo, ne gin yiende malombo wangʼ kendo mag chiemo. E dier puodho ne nitie yath machiwo ngima kendo yath mamiyo ngʼato ngʼeyo ber gi rach. ");
INSERT INTO luo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Aora mamiyo puodho bedo mangʼich ne mol koa Eden; kendo koa kanyo to aorano ne pogore nyadingʼwen. ");
INSERT INTO luo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Bath aorano mokwongo iluongo ni Pishon; en omol koluwo piny Havila duto kama ne nitiere gi dhahabu mangʼeny. ");
INSERT INTO luo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Dhahabu mar pinyno ber; duogo manyilni maber kod kite mabeyo miluongo ni oniks bende yudoree.) ");
INSERT INTO luo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Bath aorano mar ariyo iluongo ni Gihon; en omol koluwo piny Kush duto. ");
INSERT INTO luo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Bath aorano mar adek iluongo ni Tigris; en omol koluwo yo wuok chiengʼ mar Ashur. To bath aorano mar angʼwen iluongo ni Yufrate. ");
INSERT INTO luo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Eka Jehova Nyasaye nokawo Adam kendo nokete e puoth Eden mondo olose kendo orite. ");
INSERT INTO luo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kendo Jehova Nyasaye nomiyo Adam chik niya, “In thuolo mar chamo olemb yien moro amora e puodho; ");
INSERT INTO luo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","to kik icham olemb yath mamiyo ngʼato ngʼeyo ber gi rach, nimar chiengʼ ma inichame to initho.” ");
INSERT INTO luo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Jehova Nyasaye nowacho niya, “Ok ber mondo Adam obed kende, abiro losone jakony mowinjore kode.” ");
INSERT INTO luo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kuom mano, Jehova Nyasaye nokawo lowo ma ochweyogo le mae thim kod winy duto mafuyo e kor polo. Eka nokelogi ne Adam mondo ochakgi nying kendo nying mane Adam omiyo gik mangimago ema nobedo nying-gi. ");
INSERT INTO luo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Omiyo Adam nochako jamni duto nying, gi winy manie kor polo kod le duto manie thim. Kata kamano Adam ne onge gi jakony mowinjore kode. ");
INSERT INTO luo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kuom mano Jehova Nyasaye nomiyo nindo matut otero Adam; kendo kane onindo, nogolo achiel kuom ngʼedene mi nodino kanyo gi ringʼo. ");
INSERT INTO luo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Eka Jehova Nyasaye noloso dhako koa kuom ngʼet mane ogolo kuom Adam kendo nokele ni Adam. ");
INSERT INTO luo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Adam nowacho niya, “Ma koro en chogo mar choka kendo ringʼo mar ringra; ibiro luonge ni ‘dhako,’ nikech nogole koa kuom dichwo.” ");
INSERT INTO luo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kuom mano, dichwo nowe wuon kod min kendo nopadre gi chiege; mi gidok ringruok achiel. ");
INSERT INTO luo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Adam kod chiege ne niduge, to ne gionge wichkuot. ");
INSERT INTO luo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","To thuol ne riek moloyo le duto mag bungu mane Jehova Nyasaye ochweyo. Omiyo nopenjo dhako niya, “Bende en adier ni Nyasaye nowacho ni, ‘Kik ucham olemb yien moro amora manie puodho?’ ” ");
INSERT INTO luo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Dhako nodwoko thuol niya, “Wanyalo chamo olembe mag yiende manie puodho duto, ");
INSERT INTO luo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","makmana Nyasaye nosiemowa ni, ‘Kik ucham olemo mar yien man e dier puodhono, kendo kik umule nono to ubiro tho.’ ” ");
INSERT INTO luo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Thuol nowacho ne dhako niya, “Adier ok unutho. ");
INSERT INTO luo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nikech Nyasaye ongʼeyo ni sa ma unuchame wengeu noyepi kendo unubed machal gi Nyasaye, kungʼeyo ber gi rach.” ");
INSERT INTO luo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kane dhako oneno ni olemb yien-no ne ber kuom chiemo kendo moro wangʼ kendo nyalo miyo ibed gi rieko, nokawo moko mochamo, to bangʼe nomiyo chwore ma en bende nochame. ");
INSERT INTO luo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Eka wengegi noyepo kendo negifwenyo ni gin duge; kuom mano negikawo it ngʼowu kendo giumogo dugegi. ");
INSERT INTO luo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Eka Adam kod chiege nowinjo dwond Jehova Nyasaye kawuotho e puodho e seche mag angʼich welo kendo ne gipondo ne Jehova Nyasaye e kind yiende manie puodho. ");
INSERT INTO luo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","To Jehova Nyasaye noluongo Adam mopenje niya, “In kanye?” ");
INSERT INTO luo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nodwoko niya, “Ne awinji e puodho kendo luoro nomaka nikech ne an duk, koro ne apondo.” ");
INSERT INTO luo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kendo Jehova Nyasaye nowachone niya, “En ngʼa manonyisi ni in duk? Dibed ni isechamo olemb yien mane akweri ni kik icham?” ");
INSERT INTO luo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adam nodwoke niya, “Dhako mane imiya ema nomiya olemo moko moa e yien-no kendo achamo.” ");
INSERT INTO luo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Eka Jehova Nyasaye nopenjo dhako niya, “Ma en angʼo ma isetimo?” Dhako nodwoke niya, “Thuol nowuonda, mi achamo olemo.” ");
INSERT INTO luo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kuom mano Jehova Nyasaye nowacho ne thuol niya, “Nikech isetimo ma, “Okwongʼi moloyo le duto kendo gige buya duto! Ibiro lak gi bund iyi kendo ibiro chamo buru, ndalo duto mag ngimani. ");
INSERT INTO luo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kendo anaket sigu e kindi gi dhako, kendo e kind kothe gi kothi; en noto wiyi, to in to nika ofunj tiende.” ");
INSERT INTO luo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Dhako to ne owachone niya, “Anamedni rem malich e kindeni mag nywol; adier ininywol nyithindo gi rem. Dwaroni nobed mana kuom chwori bende enobed gi teko kuomi.” ");
INSERT INTO luo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","To Adam to ne owachone niya, “Nikech ne iwinjo chiegi kendo ichamo olemb yath mane akweri ni, ‘Kik icham olembe,’ “Okwongʼ lowo nikech in, kuom tich matek, ibiro chiemo koa kuom lowo, ndalo duto mag ngimani. ");
INSERT INTO luo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Enonyagni kit kuthe mopogore opogore kendo ibiro chamo alode manie thim. ");
INSERT INTO luo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Inicham chiembi mana kuom luchi, nyaka idog e lowo nikech kanyo ema ne ogolie, nimar in lowo kendo lowo ema nidogie.” ");
INSERT INTO luo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam nochako chiege ni Hawa nikech nobiro bedo min ji duto. ");
INSERT INTO luo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Jehova Nyasaye noloso lewni mag pien ne Adam kod chiege kendo noumogi. ");
INSERT INTO luo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Kendo Jehova Nyasaye nowacho niya, “Dhano koro osebedo machal kodwa, kongʼeyo ber kod rach. Kik yiene mondo oter lwete kendo okaw olemb ngima kendo ocham madimi odag nyaka chiengʼ.” ");
INSERT INTO luo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Omiyo Jehova Nyasaye noriembe e Puodho mar Eden mondo opur lowo kamane ogole. ");
INSERT INTO luo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Bangʼ kane oseriembo Adam oko, ne oketo kerubi gi ligangla mamil koni gi koni yo wuok chiengʼ mar Puodho Mar Eden mondo orit yo mochomo yadh ngima. ");
INSERT INTO luo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam nobedo e achiel gi chiege Hawa kendo nomako ich mi nonywolo Kain mowacho niya, “Kuom ngʼwono mar Jehova Nyasaye asenywolo wuowi.” ");
INSERT INTO luo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Bangʼe nonywolo owadgi miluongi ni Abel. Abel ne en jakwadh jamni to Kain ne en japur. ");
INSERT INTO luo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Bangʼ ndalo moko Kain nokelo nyak mag lowo kaka misango ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","To Abel nokelo ringʼo machwe koa kuom achiel mag jambe makayo. Jehova Nyasaye noyie gi Abel kod misango mare, ");
INSERT INTO luo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","to Kain kod misango mare to ne ok oyiego. Kuom mano Kain mirima nomako kendo wangʼe nojuol. ");
INSERT INTO luo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Eka Jehova Nyasaye nopenjo Kain niya, “Angʼo ma omiyo in-gi mirima? Angʼo ma omiyo wangʼi ojuol? ");
INSERT INTO luo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kitimo maber donge diyieni? To ka itimo marach to richo okichore e dhoodi, kendo ogomboni mondo okawi, to in nyaka iloye.” ");
INSERT INTO luo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Eka Kain nowacho ne owadgi Abel niya, “Wadhi waba e pap oko.” To kane gin e pap, Kain nogoyo owadgi ma Abel mi onege. ");
INSERT INTO luo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Eka Jehova Nyasaye nopenjo Kain niya, “Ere owadu Abel?” Nodwoke niya, “Ok angʼeyo. An jakwadhe?” ");
INSERT INTO luo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Jehova Nyasaye nowachone niya, “Isetimo angʼoni? Winji! Remb owadu ywakna koa e lowo. ");
INSERT INTO luo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Omiyo koro in e bwo kwongʼ kendo oseriembi e piny mosengʼamo dhoge mondo omwony remb owadu koa e lweti. ");
INSERT INTO luo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ka ipuro lowo, to ok obi nyagoni cham. Ibiro bedo ngʼat maonge kar dak mabayo abaya e piny.” ");
INSERT INTO luo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain nowacho ne Jehova Nyasaye niya, “Kum mi miyano ohinga. ");
INSERT INTO luo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Kawuono iseriemba e lowo kendo ibiro pandona wangʼi; abiro bet ngʼat maonge kar dak mabayo abaya e piny kendo ngʼato angʼata moyuda nonega.” ");
INSERT INTO luo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","To Jehova Nyasaye nowachone niya, “Ok kamano, ka ngʼato onegi, nochul ne kuor nyadibiriyo moloyo.” Eka Jehova Nyasaye noketo ranyisi kuom Kain mondo ngʼato moromo kode kik nege. ");
INSERT INTO luo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Omiyo Kain noa e nyim Jehova Nyasaye kendo nodak e piny Nod, mantie yo wuok chiengʼ mar Eden. ");
INSERT INTO luo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain nobedoe achiel gi chiege mi chiege nomako ich kendo nonywolo Enok. Noyudo Kain gero dala maduongʼ kendo nochako dalano nying wuode ma Enok. ");
INSERT INTO luo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok nonywolo Irad: Kendo Irad ema ne wuon Mehujael, kendo Mehujael nonywolo Methushael kendo Methushael nonywolo Lamek. ");
INSERT INTO luo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek nokendo mon ariyo, achiel ne nyinge Ada to machielo Zila. ");
INSERT INTO luo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada nonywolo Jabal, mane wuon jokwath mane odak e hembe kendo ne nigi jamni. ");
INSERT INTO luo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Owadgi ne nyinge Jubal, ma en ema nokwongo chako goyo thumbe mag nyatiti gi asili. ");
INSERT INTO luo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila bende nonywolo wuowi ma nyinge Jubal-Kain, mane jatheth chumbe duto mag mula kod nyinyo. Nyamin Tubal-Kain nyinge ne Naama. ");
INSERT INTO luo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek nowachone monde ariyo-ka niya, “Ada kod Zila, winjauru, un monda winjuru wechena. Asenego ngʼato, nikech nogoya, wuowi matin nikech nohinya. ");
INSERT INTO luo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ka Kain ochulne kuor nyadibiriyo to kara Lamek to nochul ne kuor nyadi piero abiriyo gabiriyo.” ");
INSERT INTO luo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam nobedoe achiel gi chiege, kendo chiege nonywolo wuowi mi nochake ni Seth, mowacho niya, “Nyasaye osemiya nyathi machielo kar Abel mane Kain onego.” ");
INSERT INTO luo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seth bende nonywolo wuowi, kendo nochake ni Enosh. E ndalono ema ne ji ochako luongo nying Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ma e chenro mar tienge nyikwa Adam. Ka Nyasaye nochweyo dhano, nochweye e kite owuon. ");
INSERT INTO luo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Nochweyogi dichwo gi dhako kendo ogwedhogi kendo kane ochwegi, nochakogi ni “dhano.” ");
INSERT INTO luo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ka Adam nosedak kuom higni mia achiel gi piero adek, nonywolo wuowi machal kode, kendo nochake ni Seth. ");
INSERT INTO luo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Bangʼ kosenywolo Seth, Adam nodak higni mia aboro kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam notho ka en ja-higni mia ochiko gi piero adek. ");
INSERT INTO luo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ka Seth ne ja-higni mia achiel gabich, nonywolo Enosh. ");
INSERT INTO luo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Bangʼ kane osenywolo Enosh, Seth nodak kuom higni mia aboro gabiriyo kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seth notho ka en ja-higni mia ochiko gi apar gariyo. ");
INSERT INTO luo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosh nonywolo Kenan kane en ja-higni piero ochiko. ");
INSERT INTO luo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Bangʼ Kenan, Enosh nodak higni mia aboro kod apar gabich kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosh notho ka en ja-higni mia ochiko gabich. ");
INSERT INTO luo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ka Kenan ne ja-higni piero abiriyo nonywolo Mahalalel. ");
INSERT INTO luo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kendo bangʼ ka Kenan noseyuolo Mahalalel nodak higni mia aboro kod piero angʼwen kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan notho ka en ja-higni mia ochiko gapar. ");
INSERT INTO luo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ka Mahalalel ne ja-higni piero auchiel gabich, nonywolo Jared. ");
INSERT INTO luo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Kendo bangʼ kane osenywolo Jared, Mahalalel nodak higni mia aboro gi piero adek kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel notho kane en ja-higni mia aboro gi piero ochiko gabich. ");
INSERT INTO luo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ka Jared ne ja-higni mia achiel gi piero auchiel gariyo, nonywolo Enok. ");
INSERT INTO luo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Kendo bangʼ nywolo Enok, Jared nodak higni mia aboro kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared notho kane en ja-higni mia ochiko gi piero auchiel gariyo. ");
INSERT INTO luo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ka Enok ne ja-higni piero auchiel gabich, nonywolo Methusela. ");
INSERT INTO luo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Kendo bangʼ nywolo Methusela, Enok nowuotho gi Nyasaye kuom higni mia adek kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enok nodak kuom higni mia adek gi piero auchiel gabich. ");
INSERT INTO luo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok nowuotho gi Nyasaye; bangʼe nobedo maonge, nikech Nyasaye nokawe. ");
INSERT INTO luo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ka Methusela ne ja-higni mia achiel gi piero aboro gabiriyo, nonywolo Lamek. ");
INSERT INTO luo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Kendo bangʼ kane osenywolo Lamek, Methusela nodak higni mia abiriyo gi piero aboro gariyo kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methusela nodak kuom higni mia ochiko gi piero auchiel gochiko kendo bangʼe notho. ");
INSERT INTO luo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ka Lamek ne ja-higni mia achiel gi piero aboro gariyo, nonywolo wuowi moro. ");
INSERT INTO luo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Nochake ni Nowa mi owacho niya, “Wuowini biro hoyowa kuom tich kendo kuom tich malit mar lwetwa mobet nikech lowo ma Jehova Nyasaye osekwongʼo.” ");
INSERT INTO luo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Bangʼ kane osenywol Nowa, Lamek nodak higni mia abich gi piero ochiko gi abich kendo nonywolo yawuowi kod nyiri moko. ");
INSERT INTO luo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamek notho kane ja-higni mia abiriyo gi piero abiriyo gabiriyo. ");
INSERT INTO luo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ka Nowa ne ja-higni mia abich nonywolo Shem, Ham kod Jafeth. ");
INSERT INTO luo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Kane dhano ochako medore e piny, kendo onywolonegi nyiri, ");
INSERT INTO luo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","yawuot Nyasaye noneno ni nyi dhano beyo kendo negikendo moro amora mane chunygi ogombo. ");
INSERT INTO luo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Eka Jehova Nyasaye nowacho niya, “Mucha machiwo ngima ok nodag kuom dhano nyaka chiengʼ, nikech en ringruok matow, ndalone nobed higni mia achiel gi piero ariyo.” ");
INSERT INTO luo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Jo-Nefilim ma gin joma robede miwuoro ne nitie e piny e ndalogo kendo kod ndalo maluwe, e kindeno ma yawuot Nyasaye kod nyi dhano nonywomore monywolo nyithindo. Nyithindogo ne thuondi kendo joma ne nigi huma e ndalogo. ");
INSERT INTO luo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Jehova Nyasaye noneno kaka richo dhano ogundho e piny kendo kaka paro duto mag chunye ne mana timo richo seche duto. ");
INSERT INTO luo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Jehova Nyasaye chunye nodoko malit kuom keto dhano e piny kendo chunye nopongʼ gi lit. ");
INSERT INTO luo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kuom mano Jehova Nyasaye nowacho niya, “Abiro nego dhano duto masechweyo e wangʼ piny kaachiel gi le kod gik mamol duto kod winy mafuyo e kor polo nimar dine ber ka dine ok achweyogi.” ");
INSERT INTO luo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","To Nowa noyudo ngʼwono e wangʼ Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ma e nonro mar Nowa. Nowa ne ngʼama kare, kendo malongʼo e kind oganda mane nitie kendo nowuotho gi Nyasaye. ");
INSERT INTO luo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowa ne nigi yawuowi adek: Shem, Ham kod Jafeth. ");
INSERT INTO luo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Koro piny nokethore e nyim Nyasaye kendo opongʼ gi timbe mahundu. ");
INSERT INTO luo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nyasaye noneno kaka piny nosekethore, nikech ji duto mae piny nodak e richo. ");
INSERT INTO luo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kuom mano, Nyasaye nowacho ne Nowa niya, “Abiro tieko dhano duto nikech piny opongʼ gi timbe maricho nikech gin. Adier abiro tiekogi kaachiel gi piny. ");
INSERT INTO luo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Omiyo los yie gi yien motegno, pog iye mondo owuog udi matindo kendo muone gi duogo, iye gi oko. ");
INSERT INTO luo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ma e kaka ibiro gere: Borne en fut mia angʼwen gi piero abich, lachne en fut piero abiriyo gabich kendo tutne fut piero angʼwen gabich. ");
INSERT INTO luo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ketne tado kiweyo thuolo mar fut achiel gi nus e kind tado kod kore. Ketne dhoot kendo ipog iye gorofa adek. ");
INSERT INTO luo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Abiro kelo pi mar nam e piny mondo oketh gik mangima modak e bwo polo, gimoro amora man kod muya mar ngima e iye. Gimoro amora mae piny biro tho. ");
INSERT INTO luo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","To abiro timo singruokna kodi, kendo ibiro donjo e yie, in kaachiel gi yawuoti kod chiegi, kod mond yawuoti. ");
INSERT INTO luo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ibiro kawo gik mangima duto, machwo kod mamon mondo gidonji kodi ei yie kendo iritgi gibed mangima. ");
INSERT INTO luo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Kuom kido duto mag winy, gi mag le, kod mag gik mamol e lowo ariyo ariyo nodonj kodi ei yie mondo ores ngimagi. ");
INSERT INTO luo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kaw kit chiemo duto monego cham kendo ikan-gi kaka chiembi kod mag-gi.” ");
INSERT INTO luo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nowa notimo gik moko duto mana kaka Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Eka Jehova Nyasaye nowacho ne Nowa niya, “Donj ei yie, in kaachiel gi joodi, nikech aseyudo ni in ngʼat makare e kind ogandani. ");
INSERT INTO luo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kaw kit le duto maler michamo machwo abiriyo kod mamon abiriyo kod kit le duto mochido ma ok cham machwo ariyo kod mamon ariyo, ");
INSERT INTO luo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","kendo gi kit winy duto machwo abiriyo kod mamon abiriyo mondo okan kitgi e piny ngima. ");
INSERT INTO luo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Bangʼ ndalo abiriyo koa sani abiro kelo koth e piny kuom ndalo piero angʼwen odiechiengʼ gi otieno, kendo abiro tieko gik moko duto mangima mane achweyo.” ");
INSERT INTO luo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Kendo Nowa notimo duto ma Jehova Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowa ne ja-higni mia auchiel kane pi opongʼo piny. ");
INSERT INTO luo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Kendo Nowa gi yawuote gi chiege kod mond yawuote nodonjo ei yie mondo otony ne pi mar ataro. ");
INSERT INTO luo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Le ka le madichwo kod madhako maler kod mochido, michamo kod ma ok cham, kaachiel gi winy kod gik mamol ariyo ariyo, ");
INSERT INTO luo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","nobiro ir Nowa kendo nodonjo kodgi ei yie mana kaka Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Kendo bangʼ ndalo abiriyo pi mar ataro nobiro e piny. ");
INSERT INTO luo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Tarik apar gabiriyo mar dwe mar ariyo noyudo ka Nowa ja-higni mia auchiel kendo sokni duto manie nam mangʼongo manie bwo piny nomuoch kendo dirisni mag polo noyawore. ");
INSERT INTO luo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Kendo koth nochwe e piny ndalo piero angʼwen odiechiengʼ gotieno. ");
INSERT INTO luo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Odiechiengʼno Nowa gi yawuote, Shem, Ham, kod Jafeth, kaachiel gi chiege kod mond yawuote adek, nodonjo e yie. ");
INSERT INTO luo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Negidonjo gi le duto mag buya kaka kitgi obet, jamni duto kaka kitgi obet, gik mangima duto mamol e lowo kaka kitgi obet, kod kit winy duto kaka kitgi obet, gimoro amora man-gi bwombene. ");
INSERT INTO luo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Gik moko duto mangima ariyo ariyo nobiro ir Nowa kendo negidonjo ei yie. ");
INSERT INTO luo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Gik moko duto mangima machwo kod mamon nodonjo ei yie mana kaka Nyasaye nochiko Nowa. Eka Jehova Nyasaye noloronegi ei yie. ");
INSERT INTO luo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kuom ndalo piero angʼwen pi nomedo pongʼo piny kendo kaka pi ne medore, motingʼo yie kalewore ewi pi. ");
INSERT INTO luo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Pi nogingore kendo omedore ahinya e piny kendo yie ne lewore ewi pi. ");
INSERT INTO luo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Pi nomedo gingore ahinya e piny, kendo gode maboyo duto man e bwo polo noimore. ");
INSERT INTO luo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Pi noimo gode kendo omedo gingore moloyo fut piero ariyo ");
INSERT INTO luo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Gik moko duto mangima mane ni e piny kaka winy, jamni, le mag bungu, gik mamol duto e piny kod ji duto notho. ");
INSERT INTO luo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Gimoro amora mangima mane odak e lowo motwo kendo mayweyo gi ume notho. ");
INSERT INTO luo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Gik moko duto mangima mane ni e piny notho duto; dhano, jamni gi le, gik moko duto mamol e lowo kod winy mafuyo e kor polo notiek e piny. Nowa kende ema nodongʼ kod joma ne ni kode e yie. ");
INSERT INTO luo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Pi nopongʼo piny kuom ndalo mia achiel kod piero abich. ");
INSERT INTO luo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","To Nyasaye noparo Nowa gi le mag bungu kod jamni mane ni kode ei yie, kendo notugo yamo mokudho e piny mi pi nochako dwono. ");
INSERT INTO luo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Koro sokni manie bwo lowo kod dirise mag ataro moa e polo nolor, kendo koth moa e polo nochok. ");
INSERT INTO luo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Pi noduono e piny mos mos. Bangʼ ndalo mia achiel gi piero abich pi noduono, ");
INSERT INTO luo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","kendo odiechiengʼ mar apar gabiriyo mar dwe mar abiriyo yie nobiro mochungʼ ewi gode mag Ararat. ");
INSERT INTO luo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Pi nomedo dwono nyaka dwe mar apar, to chiengʼ mokwongo mar dwe mar aparno wi gode nochako neno. ");
INSERT INTO luo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Bangʼ ndalo piero angʼwen Nowa noyawo dirisa mane oloso ei yie, ");
INSERT INTO luo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","kendo nooro agak kendo nosiko kohuyo koni gi koni nyaka pi notwo e piny. ");
INSERT INTO luo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Eka nooro akuru mondo ofweny ka pi osedok chien e piny. ");
INSERT INTO luo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","To akuru ne ok nyal yudo kama opiyoe nikech pi ne pod okwako piny duto; omiyo noduogo ir Nowa ei yie. Nowa notero lwete oko kendo ogame mine odwoge ire ei yie. ");
INSERT INTO luo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Norito bangʼ ndalo abiriyo moko kendo nooro akuru koa ei yie. ");
INSERT INTO luo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kane akuru odwogo ire godhiambo, notingʼo it yiend zeituni mangʼich mopon e dhoge. Mano nomiyo Nowa ongʼeyo ni koro pi oseduono e piny. ");
INSERT INTO luo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Norito ndalo abiriyo moko kendo nochako ooro akuruno, to ne ok odwogo ire kendo. ");
INSERT INTO luo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Chiengʼ mokwongo mar dwe mokwongo ka Nowa ne ja-higni mia auchiel gachiel, pi noduono e piny. Eka Nowa noelo wi yie kendo noneno ni piny osetwo. ");
INSERT INTO luo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Kane ochopo tarik piero ariyo gabiriyo ema ne piny otuoe. ");
INSERT INTO luo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Eka Nyasaye nowacho ne Nowa niya, ");
INSERT INTO luo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Wuog oko ei yie, in kaachiel gi chiegi, kod yawuoti kod mond yawuoti. ");
INSERT INTO luo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Gol oko kit gik mangima duto man kodi kaka winy, le kod gik moko duto mamol e lowo mondo ginywolre e piny kendo ginyaa kendo kwan-gi omedre e piny.” ");
INSERT INTO luo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Omiyo Nowa nowuok oko, kaachiel gi yawuote kod chiege kod mond yawuote. ");
INSERT INTO luo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Le duto kod gik moko duto mamol e lowo kod winy duto; gimoro amora mawuotho e piny, nowuok ei yie moro ka moro kaka kitgi obet. ");
INSERT INTO luo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Eka Nowa nogero kendo mar misango ne Jehova Nyasaye kendo nokawo le maler kod winy maler moko michamo, motimogo misango miwangʼo pep ewi kendono. ");
INSERT INTO luo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Jehova Nyasaye nowinjo suya madungʼ tik mangʼwe ngʼar kendo nowacho e chunye niya, “Ok anachak akwongʼ piny kendo nikech dhano, kata obedo ni paro ma aye chunye opongʼ gi richo nyaka aa e tin-ne. Bende ok anachak atiek gik mangima kendo kaka asetimoni. ");
INSERT INTO luo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Chwoyo gi keyo, ngʼich kod liet, oro kod chwiri, odiechiengʼ kod otieno ok nobed maonge nyaka giko piny.” ");
INSERT INTO luo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Eka Nyasaye nogwedho Nowa gi yawuote kowachonegi niya, “Nywolreuru kendo umedru mi upongʼ piny. ");
INSERT INTO luo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Luoro kod kihondko nomak le duto manie piny kod winy ma huyo e kor polo, gik moko duto mamol e lowo kod rech duto modak e nam nikech ochiwgi duto e lwetu. ");
INSERT INTO luo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Gimoro amora mangima kendo wuotho nobed chiembu. Mana kaka asemiyou alode, koro amiyou gik moko duto.” ");
INSERT INTO luo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","To kik ucham ringʼo ma pod nigi remo kuome. ");
INSERT INTO luo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kendo kuom remb ngimau to anachul kuor. Anachul kuor ne le duto kendo ne ngʼato ka ngʼato anachul kuor nikech ngima wadgi. ");
INSERT INTO luo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Ngʼato angʼata mochwero remb dhano, en bende nyaka rembe chwer koa e lwet dhano; nikech e kit Nyasaye nochweyo dhano. ");
INSERT INTO luo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","To un, nyaguru kendo umedru; nywolreuru e piny kendo upongʼe.” ");
INSERT INTO luo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Eka Nyasaye nowacho ne Nowa gi yawuote niya, ");
INSERT INTO luo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Koro aketo singruokna kodu gi nyikwau, ");
INSERT INTO luo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kod gik mangima mane ni kodu kaka winy, jamni kod le mag bungu; kod mago duto mane owuok ei yie ma gin gik moko duto mangima modak e piny. ");
INSERT INTO luo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Atimo singruok kodi ni: Ok nachak atiek gik mangima kod pi bende ok nachak aketh piny kuom pi.” ");
INSERT INTO luo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Kendo Nyasaye nowacho niya, “Ma e ranyisi mar singruok ma atimo e kinda kodi kod gik mangima duto maun-go nyaka tiengʼ mabiro. ");
INSERT INTO luo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Aseketo lihudu mara e boche polo, kendo obiro bedo ranyisi mar singruok e kinda kod piny. ");
INSERT INTO luo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","E kinde moro amora ma amiyo piny odudo kendo lihudu ochungʼ e boche polo, ");
INSERT INTO luo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","anapar singruok e kinda kodi kaachiel gi gik mangima duto, tiengʼ ka tiengʼ. Pi ok nochak oketh gik mangima duto. ");
INSERT INTO luo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","E kinde moro amora ma lihudu nochungʼ e boche polo, ananene kendo napar singruok mosiko e kind Nyasaye kod gik mangima duto manie piny kaka kitgi obet.” ");
INSERT INTO luo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kuom mano, Nyasaye nowacho ne Nowa niya, “Ma e ranyisi mar singruok ma asetimo e kinda kod gik mangima duto manie piny.” ");
INSERT INTO luo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Yawuot Nowa mane owuok e yie ne gin: Shem, Ham kod Jafeth. (Ham ne wuon Kanaan.) ");
INSERT INTO luo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Yawuot Nowa adekgi ema oganda duto manie piny owuokie. ");
INSERT INTO luo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa, ne en japur kendo en ema nokwongo pidho mzabibu mi olosogo divai. ");
INSERT INTO luo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Kane omadho divai moko mowuok e mzabibuno, nomer kendo nonindo duk ei hembe. ");
INSERT INTO luo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham wuon Kanaan noneno dug wuon kendo nodhi mowachone owetene ariyo mane ni oko. ");
INSERT INTO luo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","To Shem kod Jafeth nokawo nanga mi oketo e gokgi; eka negidonjo ei hema ka giwuotho gi ka ngʼegi mi giumo dug wuon-gi. Wengegi ne ngʼiyo komachielo mondo omi kik gine dug wuon-gi. ");
INSERT INTO luo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kane Nowa kongʼo orumo e wangʼe, mi ofwenyo gima wuode matin notimone, ");
INSERT INTO luo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","nowacho niya, “Okwongʼ Kanaan! Enobed misumba, e bwo wasumbini mag owetene.” ");
INSERT INTO luo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nomedo wacho niya, “Jehova Nyasaye ma Nyasach Shem mondo opaki! Kanaan obed misumba Shem. ");
INSERT INTO luo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nyasaye mondo omed Jafeth; Jafeth mondo odag e hembe mag Shem, kendo Kanaan obed misumbane.” ");
INSERT INTO luo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Bangʼ ataro mangʼongono, Nowa nodak higni mia adek gi piero abich. ");
INSERT INTO luo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Duto Nowa nodak kuom higni mia ochiko gi piero abich kendo bangʼe notho. ");
INSERT INTO luo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ma e nonro mar Shem, Ham kod Jafeth ma yawuot Nowa ma bende nonywolo yawuowi bangʼ ataro mangʼongo. ");
INSERT INTO luo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yawuot Jafeth ne gin: Gomer, Magog, Madai, Javan, Tubal, Meshek kod Tiras. ");
INSERT INTO luo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Yawuot Gomer ne gin: Ashkenaz, Rifath, kod Togarma. ");
INSERT INTO luo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawuot Javan ne gin: Elisha, Tarshish, jo-Kitim kod jo-Rodan. ");
INSERT INTO luo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Kuomgi ema ogendini modak e dho nembe nowuokie kadhi e pinjegi, dhoot ka dhoot, e pinjegi ka moro ka moro wacho dhogi.) ");
INSERT INTO luo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Yawuot Ham ne gin: Kush, Mizraim, Put kod Kanaan. ");
INSERT INTO luo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Yawuot Kush ne gin: Seba, Havila, Sabta, Rama kod Sabteka. Yawuot Rama ne gin: Sheba kod Dedan. ");
INSERT INTO luo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kush ne en wuon Nimrod, mane en jalweny maratego e piny. ");
INSERT INTO luo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ne en jadwar maratego e nyim Jehova Nyasaye. Mano ema omiyo iwacho “Jadwar maratego e nyim Jehova Nyasaye ka Nimrod.” ");
INSERT INTO luo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Pinje mokwongo mag pinyruodhe ne gin Babulon, Erek, Akad kod Kalne e piny Shinar. ");
INSERT INTO luo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nowuok kuno modhi e piny Asuria kuma nogeroe Nineve, Rehoboth-Ir, gi Kala, ");
INSERT INTO luo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","kod Resen, dala maduongʼ, man e kind Nineve kod Kala. ");
INSERT INTO luo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim ne en wuon jo-Lud, jo-Anam, jo-Lehab, jo-Naftu, ");
INSERT INTO luo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Jo-Pathrus, jo-Kaslu (ma jo-Filistia nowuok kuomgi) kod jo-Kaftor. ");
INSERT INTO luo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan nonywolo Sidon wuode makayo kendo jo-Hiti, ");
INSERT INTO luo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","jo-Jebus, jo-Amor, jo-Girgash, ");
INSERT INTO luo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","jo-Hivi, jo-Arki, jo-Sini, ");
INSERT INTO luo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","jo-Arvad, jo-Zemar kod jo-Hamath. (Bangʼe anywola mar jo-Kanaan noke e piny, ");
INSERT INTO luo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","kendo tongʼ piny mar Kanaan nochakore Sidon kadhi Gerar nyaka Gaza kendo kadhi Sodom, Gomora, Adma kod Zeboim nyaka Lasha.) ");
INSERT INTO luo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Magi e yawuot Ham kuom dhoutgi, kod dhogi e pinjegi kod ogandagi. ");
INSERT INTO luo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shem mane owadgi Jafeth matin ma bende en kwar jo-Eber bende nonywolo yawuowi. ");
INSERT INTO luo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shem nonywolo: Elam, Ashur, Arfaksad, Lud kod Aram. ");
INSERT INTO luo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram nonywolo: Uz, Hul, Gether kod Meshek. ");
INSERT INTO luo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaksad nonywolo Shela, to Shela nonywolo Eber. ");
INSERT INTO luo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber nonywolo yawuowi ariyo: Achiel nochak ni Peleg, nikech e ndalono ema nopogie piny; owadgi to ne nyinge Joktan. ");
INSERT INTO luo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan nonywolo: Almodad, Shelef, Hazarmaveth, gi Jera, ");
INSERT INTO luo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO luo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, gi Sheba ");
INSERT INTO luo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila kod Jobab. Jogo duto ne gin yawuot Joktan. ");
INSERT INTO luo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","(Pinygi mane gi dakie nochakore Mesha kochomo Sefar e gode man yo wuok chiengʼ.) ");
INSERT INTO luo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Magi e yawuot Shem kuom dhoutgi ka moro ka moro wacho dhogi giwegi. ");
INSERT INTO luo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Magi e yawuot Nowa kaluwore gi anywolagi e pinjegi. Kuomgi ema ogendini mopogore opogore nochakore bangʼ ataro. ");
INSERT INTO luo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","E kindeno ogendini duto manie piny ne wacho dhok achiel kod weche machal. ");
INSERT INTO luo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kane gidhi yo wuok chiengʼ, negiyudo pap moro e piny Shinar mine gidak kanyo. ");
INSERT INTO luo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Negiwacho e kindgi giwegi niya, “Biuru walosuru matafare kendo wawangʼ-gi mochiek maber.” Negitiyo gi matafare kar kite kendo lowo kar simiti. ");
INSERT INTO luo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Eka negiwacho niya, “Biuru wager dala maduongʼ man-gi ohinga mabor machopo nyaka e polo mondo omi walos nyingwa kendo kik wabed moke e kor piny.” ");
INSERT INTO luo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","To Jehova Nyasaye nolor piny mondo one dala maduongʼ kod ohinga mabor mane dhano gero. ");
INSERT INTO luo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Jehova Nyasaye nowacho niya, “Ka gin oganda achiel, mawacho dhok achiel ema gisechako timo ma, kara gimoro amora ma gichano timo ok nyal tamogi. ");
INSERT INTO luo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Biuru, kendo wadhi mondo wapog dhogi mondo kik giwinjre dhok ngʼato gi ngʼato.” ");
INSERT INTO luo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Omiyo Jehova Nyasaye nokeyogi koa kanyo nyaka e piny duto kendo ne giweyo gero dalano. ");
INSERT INTO luo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Mano emomiyo ne iluongo dalano ni Babel, nikech kanyo ema Jehova Nyasaye nopogoe dho ogendini kendo okeyogi e pinje duto. ");
INSERT INTO luo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ma e nonro mar joka Shem. Higni ariyo bangʼ ataro ka Shem ja-higni mia achiel nonywolo Arfaksad. ");
INSERT INTO luo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Bangʼ ka Shem nosenywolo Arfaksad, nodak higni mia abich mi onywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ka Arfaksad ne ja-higni piero adek gabich nonywolo Shela. ");
INSERT INTO luo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Kendo bangʼ kane osenywolo Shela, Arfaksad nodak kuom higni mia angʼwen gadek kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Kane Shela ja-higni piero adek, nonywolo Eber. ");
INSERT INTO luo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Kendo bangʼ kane osenywolo Eber, Shela nodak higni mia angʼwen gadek kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Kane Eber ja-higni piero adek gangʼwen, nonywolo Peleg. ");
INSERT INTO luo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Bangʼ kane osenywolo Peleg, Eber nodak kuom higni mia angʼwen gi piero adek kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Kane Peleg ja-higni piero adek, nonywolo Reu. ");
INSERT INTO luo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Bangʼ kane osenywolo Reu, Peleg nodak higni mia ariyo gochiko kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Kane Reu ja-higni piero adek gariyo nonywolo Serug. ");
INSERT INTO luo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Kendo bangʼ nywolo Serug, Reu nodak higni mia ariyo gabiriyo kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Kane Serug ja-higni piero adek, nonywolo Nahor. ");
INSERT INTO luo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Kendo bangʼ kane osenywolo Nahor, Serug nodak higni mia ariyo kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Kane Nahor ja-higni piero ariyo gochiko nonywolo Tera. ");
INSERT INTO luo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Kendo bangʼ kane osenywolo Tera, Nahor nodak higni mia achiel gapar gochiko kendo nonywolo yawuowi kod nyiri mamoko. ");
INSERT INTO luo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Bangʼ ka Tera nosedak higni piero abiriyo nonywolo Abram, Nahor kod Haran. ");
INSERT INTO luo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ma e nonro mar Tera. Tera nonywolo Abram, Nahor kod Haran. Kendo Haran nonywolo Lut. ");
INSERT INTO luo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran notho e dalagi miluongo ni Ur manie piny Kaldea kane Tera wuon mare pod ngima. ");
INSERT INTO luo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram kod Nahor nokendo. Nying chi Abram ne Sarai kendo nying chi Nahor ne Milka; mane nyar Haran; wuon Milka kod Iska. ");
INSERT INTO luo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","To Sarai ne en migumba; nikech ne ok onywol. ");
INSERT INTO luo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera nokawo Abram wuode, gi Lut nyakware ma ka wuode Haran kod Sarai, chi Abram mi giwuok Ur e piny Kaldea ka gidhi Kanaan. To kane gichopo Haran, negidak kanyo. ");
INSERT INTO luo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera nodak higni mia ariyo gabich kendo notho Haran. ");
INSERT INTO luo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Jehova Nyasaye nowacho ne Abram niya, “Dar iwe pinyu gi jou kod joodu mondo idhi e piny ma abiro nyisi. ");
INSERT INTO luo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Anaketi oganda maduongʼ kendo anagwedhi; anami nyingi bed gi huma, kendo anami ibed gweth ne ji. ");
INSERT INTO luo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Anagwedh jogo ma gwedhi kendo anakwongʼ jogo makwongʼi, kendo ogendini duto manie piny nogwedhi nikech in.” ");
INSERT INTO luo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Omiyo Abram nowuok kaka Jehova Nyasaye nosenyise kendo Lut nodhi kode. Abram ne ja-higni piero abiriyo gabich kane owuok Haran. ");
INSERT INTO luo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Nokawo chiege Sarai, gi Lut wuod owadgi, gi mwandu duto mane gisechoko kod wasumbini duto mane gin-go Haran, kendo negichako wuoth mar dhi Kanaan mi negichopo kuno. ");
INSERT INTO luo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram nowuotho e piny mochopo Shekem e tiend yath maduongʼ mar More. E kindego jo-Kanaan nodak e pinyno. ");
INSERT INTO luo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Jehova Nyasaye nofwenyore ne Abram mi owachone niya, “Anami kothi pinyni.” Omiyo Abram nogero kendo mar misango kanyo ne Jehova Nyasaye mane osefwenyorene. ");
INSERT INTO luo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Noa kanyo modhi e piny gode ma yo wuok chiengʼ mar Bethel kendo nogero hembe e kind Bethel man yo podho chiengʼ to gi Ai man yo wuok chiengʼ. Kanyo nogeroe kendo mar misango ne Jehova Nyasaye kendo nolamo Jehova Nyasaye kanyo. ");
INSERT INTO luo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Eka Abram nochako wuoth kendo odhi nyime giwuoth kochomo Negev. ");
INSERT INTO luo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Koro kech nomako pinyno kendo Abram nodhi Misri mondo odhi odag kuno kuom kinde matin nikech kech ne duongʼ. ");
INSERT INTO luo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kane ochiegni donjo Misri, nowacho ne Sarai chiege niya, “Angʼeyo kaka in dhako ma jaber. ");
INSERT INTO luo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ka jo-Misri oneni, gibiro wacho, ‘Ma en chiege.’ Mi gininega to inires ngimani. ");
INSERT INTO luo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Wach ni in nyamera, mondo mi gitimna maber kendo ngimana obedie nikech in.” ");
INSERT INTO luo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Kane Abram ochopo Misri, jo-Misri noneno Sarai kaka ne en dhako ma jaber miwuoro. ");
INSERT INTO luo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kendo kane jodong Farao oneno Sarai, negiwuoro berne ne Farao kendo nokawe motere kar dak ruoth. ");
INSERT INTO luo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Farao nomiyo Abram rit maber nikech Sarai, kendo nomiyo Abram rombe, dhok, pundane machwo gi mamon, wasumbini machwo gi mamon kod ngamia. ");
INSERT INTO luo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","To Jehova Nyasaye nosando Farao gi joode gi tuoche madongo nikech Sarai chi Abram. ");
INSERT INTO luo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Omiyo Farao noluongo Abram kendo nopenje niya, “Angʼo ma isetimonani? Ere gima omiyo ne ok inyisa ni Sarai en chiegi? ");
INSERT INTO luo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mara angʼo ne iwuonda ni Sarai en nyameru momiyo akawe mondo obed chiega? Chiegi eri, kawe mondo udhi.” ");
INSERT INTO luo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Eka Farao nogolo chik ne joge mondo ogol Abram, chiege gi gige duto kendo gikowogi oko mar pinyno. ");
INSERT INTO luo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Omiyo Abram nowuok Misri gi chiege kod Lut kod gik moko duto mane en-go kochomo Negev. ");
INSERT INTO luo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram koro nosebedo ja-mwandu ahinya mar jamni gi fedha kod dhahabu. ");
INSERT INTO luo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Nodhi nyime kod wuoth koa Negev kobuoro e yo nyaka nochopo Bethel, kumane okwongo geroe hembe e kind Bethel kod Ai, ");
INSERT INTO luo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","kendo kama nokwongo geroe kendo mar misango. Kanyo Abram nolamoe Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","To Lut ma bende ne wuotho kod Abram neni kod jamni matindo mathoth, gi kweth mag dhok kod hembe. ");
INSERT INTO luo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kuonde mag kwath ne tin mane ok nyal romogi ka gidak kanyakla, nimar mwandu mane gin-go nomedore mane ok ginyal dak kaachiel. ");
INSERT INTO luo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kendo dhawo nowuok e kind jakwadh Abram kod jokwadh Lut. E kindeno jo-Kanaan kod jo-Perizi ne pod odak e pinyno. ");
INSERT INTO luo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Omiyo Abram nowacho ne Lut niya, “Kik dhawo bed e kindwa kata e kind jokwadhi kod jokwadha nikech wan wede. ");
INSERT INTO luo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Donge piny duto ni e lweti? Ber wapogre, kidhi koracham to adhi korachwich; to kidhi korachwich to adhi koracham.” ");
INSERT INTO luo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lut notingʼo wangʼe moneno paw Jordan duto ka nitie gi pi maber mana ka puoth Jehova Nyasaye, machalo gi piny Misri kochiko Zoar. (Mano notimore kane pok Jehova Nyasaye oketho Sodom kod Gomora.) ");
INSERT INTO luo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Omiyo Lut noyiero pewe duto mag Jordan kendo nowuok kochomo yo wuok chiengʼ. Mano e kaka ji ariyogi nopogore. ");
INSERT INTO luo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram nodak e piny Kanaan, to Lut nodak e kind mier madongo manie paw Jordan kendo nogero hembene machiegni gi Sodom. ");
INSERT INTO luo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Koro jo-Sodom ne gin joma okethore kendo matimo richo mag wangʼ teko e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Jehova Nyasaye nowacho ne Abram kane Lut osepogore kode niya, “Tingʼ wangʼi gi kuma in tiere kendo ingʼi yo nyandwat gi yo milambo, yo wuok chiengʼ kod yo podho chiengʼ. ");
INSERT INTO luo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Piny duto ma inenono abiro miyi gi nyikwayi nyaka chiengʼ. ");
INSERT INTO luo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Anami nyikwayi bed mangʼeny mana ka buru mae lowo; ma ka ngʼato nyalo kwano buru, to nyikwayi bende inyalo kwan. ");
INSERT INTO luo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Aa malo kendo iwuothi e tungʼ piny koni gi koni, nikech amiyigo.” ");
INSERT INTO luo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Omiyo Abram nopudho hembene mi odhi odak but yiende madongo mag Mamre ei Hebron, kamane ogeroe kendo mar misango ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","E kindeno Amrafel ruodh Shinar, Ariok ruodh Elasar, Kedorlaomer ruodh Elam kod Tidal ruodh Goyim ");
INSERT INTO luo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","nodhi kedo gi Bera ruodh Sodom, Birsha ruodh Gomora, Shinab ruodh Adma, Shemeber ruodh Zeboim kod ruodh Bela (ma tiende ni Zoar). ");
INSERT INTO luo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ruodhi abichgi duto noriwo jolwenjgi ne kedo e Holo mar Sidim (miluongo ni Nam chumbi). ");
INSERT INTO luo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kuom higni apar gariyo negisebedo e bwo loch Kedorlaomer, to e higa mar apar gadek ne gingʼanyo. ");
INSERT INTO luo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","E higa mar apar gangʼwen, Kedorlaomer kod ruodhi mane oriwore kode nodhi omonjo kendo oloyo jo-Refai man Ashteroth Karnaim, jo-Zuzim e Ham gi jo-Emi man Shave Kiriathaim, ");
INSERT INTO luo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","kendo jo-Hori manie gode mag Seir, mane ochwe nyaka El-Paran machiegni gi piny motimo ongoro. ");
INSERT INTO luo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Eka negidwogo chien kendo gidhi nyaka En Mishpat (ma tiende ni Kadesh), kendo negikawo piny jo-Amalek duto gi piny jo-Amor manodak Hazazon Tamar. ");
INSERT INTO luo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Eka ruodh Sodom, ruodh Gomora, ruodh Adma, ruodh Zeboim kod ruodh Bela (ma tiende ni Zoar) nowuok kendo oikore kedo moriedo jolwenjgi e Holo mar Sidim, ");
INSERT INTO luo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","mondo oked gi Kedorlaomer ruodh Elam, Tidal ruodh Goyim, Amrafel ruodh Shinar kod Ariok ruodh Elasar mi ruodhi angʼwen-go nokedo gi ruodhi abich. ");
INSERT INTO luo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Holo mar Sidim nopongʼ gi buche mag chwodho, kendo kane ruodhi mag Sodom kod Gomora ringo, moko nopodho e buchego to moko noringo otony e gode. ");
INSERT INTO luo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ruodhi angʼwen-go noyako gik moko duto mag Sodom kod Gomora kod chiembgi duto mi gidhi. ");
INSERT INTO luo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Bende negikawo Lut, wuod owadgi Abram kod mwandune duto nikech noyudo odak Sodom. ");
INSERT INTO luo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ngʼat achiel mane oyudo otony nobiro kendo onyiso Abram ja-Hibrania wachni. E ndalogo Abram nodak e tiend yiende madongo mag Mamre ja-Amor mane omin Eshkol kod Aner, osiepe Abram. ");
INSERT INTO luo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kane Abram owinjo ni watne oseter e twech, noluongo jotichge machwo motiegore mia adek gapar gaboro kendo olawogi nyaka Dan. ");
INSERT INTO luo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Gotieno Abram nopogo jotichnego e migepe mondo omonj ruodhigo kendo negiriembogi mi gilawogi nyaka Hoba, ma yo nyandwat mar Damaski. ");
INSERT INTO luo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram nodhi moomo gik moko duto mane joka odhigo kendo noreso Lut wuod owadgi kod mwandune duto kaachiel gi mon kod ji mamoko. ");
INSERT INTO luo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Bangʼ ka Abram noduogo koseloyo Kedorlaomer kod ruodhi mane oriwore kode, ruodh Sodom nobiro mondo orom kode ei Holo mar Shave (ma tiende ni Holo mar Ruoth). ");
INSERT INTO luo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Eka Melkizedek ruodh Salem nokelo makati gi divai. Ne en jadolo mar Nyasaye Man Malo Moloyo, ");
INSERT INTO luo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","kendo nogwedho Abram kowacho niya, “Nyasaye Man Malo Moloyo, Jachwech polo kod piny ogwedhi, in Abram. ");
INSERT INTO luo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kendo ogwedh Nying Nyasaye Man Malo Moloyo mane oketo wasiki e lweti.” Eka Abram nomiye achiel kuom apar mar gik moko duto. ");
INSERT INTO luo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ruodh Sodom nowacho ne Abram niya, “Miya ji to idongʼ gi gik moko duto.” ");
INSERT INTO luo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","To Abram nowacho ne ruodh Sodom, “Asetingʼo lweta ne Jehova Nyasaye, ma en Nyasaye Man Malo Moloyo, Jachwech polo gi piny kendo asekwongʼora ");
INSERT INTO luo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ni ok nakaw giri moro, kata mana tol kata pat kira, mondo kik chiengʼ moro iwachi ni, ‘An ema ne amiyo Abram obedo jamoko.’ ");
INSERT INTO luo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ok abi kawo gimoro to mana ma joga osechamo kod pok ma joga kaka Aner, Eshkol kod Mamre onego oyudi. Onego giyud pokgi.” ");
INSERT INTO luo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bangʼ ma, wach Jehova Nyasaye nobiro ne Abram e fweny ni, “Abram, kik iluor. An e okumbani, kendo pokni maduongʼ moloyo.” ");
INSERT INTO luo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","To Abram nowacho niya, “Yaye Jehova Nyasaye Manyalo Gik Moko Duto, en angʼo ma dimiya to pod asiko ka aonge nyathi kendo jacham mwanduna en mana Eliezer ja-Damaski?” ");
INSERT INTO luo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Kendo Abram nowacho niya, “Pod ok imiya nyithindo; omiyo achiel kuom wasumbini maga ema nobed jacham girkeni maga.” ");
INSERT INTO luo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Eka wach Jehova Nyasaye nobirone kawacho niya, “Ngʼatni ok nobed jacham girkeni magi, to wuowi ma owuok e ringri iwuon ema nobed jacham girkeni magi.” ");
INSERT INTO luo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Nogole oko mowachone niya, “Rang polo malo kendo kwan sulwe ka dipo ni inyalo kwanogi.” Eka nowachone niya, “Omiyo mano e kaka nyikwayi nobedi.” ");
INSERT INTO luo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram noyie kuom Jehova Nyasaye, mi Jehova Nyasaye nokwane kaka ngʼama kare. ");
INSERT INTO luo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kendo nowachone niya, “An e Jehova Nyasaye manogoloi Ur piny jo-Kaldea mondo amiyigo obed girkeni mari.” ");
INSERT INTO luo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","To Abram nopenje niya, “Yaye Jehova Nyasaye Manyalo Gik Moko Duto, ere kaka anyalo ngʼeyo ni obiro bedo girkeni mara?” ");
INSERT INTO luo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Omiyo Jehova Nyasaye nonyise niya, “Kelna roya bwongʼ, diel kod im mahikgi adek, adek kaachiel gi akuch odugla kod nyathi akuru.” ");
INSERT INTO luo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram nokelone magi duto, nongʼadogi diriyo moro ka moro kendo okelo nusegi moro ka moro omanyore gi wadgi, to kata kamano, winy ne ok ongʼado. ");
INSERT INTO luo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Eka achudhe nopiyo e ringʼogo, to Abram noriembogi. ");
INSERT INTO luo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Kane chiengʼ podho, Abram nogore e nindo matut kendo mudho mandiwa noime. ");
INSERT INTO luo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Eka Jehova Nyasaye nowachone niya, “Ngʼe malongʼo ni nyikwayi nobed jodak e piny moro ma ok margi, kendo nolokgi wasumbini mi nosandgi malit kuom higni mia angʼwen. ");
INSERT INTO luo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","To anakum piny ma noketgi wasumbini, bangʼe giniwuogi gia gi mwandu mogundho. ");
INSERT INTO luo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","To kata kamano, inidag amingʼa mi itho gi kwe kiluwo kwereni. ");
INSERT INTO luo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","E tiengʼ mar angʼwen nyikwayi nodwogi ka, nikech e ndalogo ema noyud ka richo jo-Amor osemedore moromo kum.” ");
INSERT INTO luo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kane chiengʼ osepodho kendo piny oyuso, tago mar mach madum iro kod chuk mach maliel nothinyore mi okadho e kind lemo mag gik manoyangʼ ka. ");
INSERT INTO luo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Odiechiengno Jehova Nyasaye notimo singruok gi Abram mowachone niya, “To ne nyikwayi, amiyogi pinyni, koa e aora mar Misri nyaka aora maduongʼ mar Yufrate. ");
INSERT INTO luo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Bende amiyogi pinje kaka piny jo-Keni, jo-Kenizi, jo-Kadmon, ");
INSERT INTO luo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","jo-Hiti, jo-Perizi, jo-Refai, ");
INSERT INTO luo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","jo-Amor, jo-Kanaan, jo-Girgash, kod jo-Jebus.” ");
INSERT INTO luo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Koro Sarai chi Abram ne pok onywolone nyithindo. To ne en gi misumba ma nyako ma nyar Misri, ma nyinge ne Hagar; ");
INSERT INTO luo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","omiyo Sarai nowacho ne Abram niya, “Jehova Nyasaye ok osemiya nyithindo. Dhiyo mondo iriwri gi jatichna ma nyako; dipoka ayudo joga koa kuome.” Abram noyie gi wach Sarai. ");
INSERT INTO luo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Kane oyudo Abram osedak Kanaan kuom higni apar, Sarai chiege nokawo misumbane ma nyako Misri, ma nyinge Hagar kendo nochiwe ne chwore mondo obed chiege. ");
INSERT INTO luo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram noriwore gi Hagar kendo nomako ich. Kane ofwenyo ni en gi ich, nochako chayo ruodhe madhako. ");
INSERT INTO luo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Eka Sarai nowacho ne Abram niya, “In ema ikelona achayani. Ne aketo jatichna e lweti, kendo ka koro ongʼeyo ni osemako ich to ochaya mad Jehova Nyasaye bed jangʼad bura e kinda kodi.” ");
INSERT INTO luo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram nodwoke niya, “Jatichni ni e lweti, tim kode gima iparo ni ber.” Eka Sarai nosando Hagar; mi noringo oa e wangʼe. ");
INSERT INTO luo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malaika mar Jehova Nyasaye noyudo Hagar machiegni gi soko e thim; ne en soko manie bath yo madhi Shur. ");
INSERT INTO luo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Kendo nopenjo niya, “Hagar jatich Sarai, ia kanye to idhi kanye?” Hagar nodwoke niya, “Aringo aa e wangʼ Sarai matiyone.” ");
INSERT INTO luo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Eka malaika mar Jehova Nyasaye nowachone niya, “Dogi ir ngʼat ma itiyone kendo ichiwri e lwete.” ");
INSERT INTO luo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Malaika nomedo wachone niya, “Abiro medo ogandani mabed mangʼeny ma ok nyal kwan.” ");
INSERT INTO luo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Malaika mar Jehova Nyasaye nomedo wachone niya, “Koro in gi ich kendo ibiro nywolo nyathi ma wuowi, mi inichake Ishmael, nikech Jehova Nyasaye osewinjo chandruokni. ");
INSERT INTO luo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Obiro bedo ngʼama kwiny ka kanyna mapok obo; nobed mamon gi ji duto, kendo ji duto bende nobed mamon kode, mi nodag komon gi owetene duto.” ");
INSERT INTO luo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Bangʼeno Hagar nochako Nyasaye mane osewuoyo kode nying ni El-roi (ma tiende ni Jehova Nyasaye Maneno); nimar nowacho niya, “Koro aseneno Jalno manena.” ");
INSERT INTO luo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Mano emomiyo sokono nochaki ni Beer-Lahai-Roi; kendo pod entiere nyaka chil kawuono, e kind Kadesh kod Bered. ");
INSERT INTO luo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kuom mano Hagar nonywolone Abram nyathi ma wuowi kendo nochako nyinge ni Ishmael. ");
INSERT INTO luo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram ne ja-higni piero aboro gauchiel kane Hagar onywolone Ishmael. ");
INSERT INTO luo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Kane Abram ne ja-higni piero ochiko gochiko, Jehova Nyasaye nofwenyorene mi nowachone niya, “An Nyasaye Maratego; bed ngʼama odimbore e nyima kendo maonge ketho. ");
INSERT INTO luo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Abiro guro singruokna e kinda kodi kendo anamed kothi obed mangʼeny.” ");
INSERT INTO luo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram nopodho auma e nyim Nyasaye kendo Nyasaye nowachone niya, ");
INSERT INTO luo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Singruok matimo kodi ema: Inibed wuon ogendini mangʼeny. ");
INSERT INTO luo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ok nochak oluongi ni Abram; to enoluongi ni Ibrahim, nimar aseketi ibedo wuon ogendini mangʼeny. ");
INSERT INTO luo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Anamiyi nyikwayo mathoth; ginidog ogendini madongo kendo ruodhi nowuog kuomgi. ");
INSERT INTO luo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Anagur singruokna manyaka chiengʼ e kinda kodi gi nyikwayi kod tienge mabiro, mi anabed Nyasachi kendo Nyasach nyikwayi nyaka chiengʼ. ");
INSERT INTO luo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Piny Kanaan duto makoro udakieni anamiyi kaachiel gi nyikwayi mondo obed girkeni manyaka chiengʼ kendo anabed Nyasachgi.” ");
INSERT INTO luo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Eka Nyasaye nowacho ne Ibrahim niya, “In kaachiel gi nyikwayi kod tienge mabiro nyaka rit singruokna. ");
INSERT INTO luo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Singruokna manyaka iriti, in kaachiel gi nyikwayi ema: Ngʼato ka ngʼata madichwo e kindu nyaka ter nyangu. ");
INSERT INTO luo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Nyaka teru nyangu kendo ma nobed ranyisi mar singruokna e kinda kodu. ");
INSERT INTO luo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kuom tienge mabiro ngʼato angʼata madichwo monywol e uteu kata ongʼiew gi pesa ma ok kothu nyaka ter nyangu, e odiechiengʼ mar aboro bangʼ nywolne. ");
INSERT INTO luo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Nyaka tergi nyangu bedni onywolgi e uteu kata ongʼiewogi gi pesa. Singruokna man kuom ringreu nyaka bed mosiko. ");
INSERT INTO luo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ngʼato angʼata madichwo, mane ok oter nyangu e ringruok, nogol oko kuom jogi; nikech oseketho singruokna.” ");
INSERT INTO luo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nyasaye nomedo wachone Ibrahim niya, “Koro ok inichak iluong Sarai chiegi ni Sarai, to iniluonge ni Sara. ");
INSERT INTO luo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Anagwedhe kendo anamiyi nyathi ma wuowi koa kuome. Anagwedhe mi nobed min ogendini; kendo ruodhi mag ogendini noa kuome.” ");
INSERT INTO luo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibrahim nopodho auma; monyiero kowacho e chunye niya, “Bende ngʼama ja-higni mia achiel nyalo nywolo wuowi? Bende Sara ma ja-higni piero ochiko nyalo nywolo nyathi?” ");
INSERT INTO luo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Kendo Ibrahim nowacho ne Nyasaye niya, “Mano nyalo mana timore kaponi Ishmael odak e bwo ngʼwono mari!” ");
INSERT INTO luo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Eka Nyasaye nodwoke niya, “Ooyo, en mana Sara chiegi ema nonywolni wuowi, kendo iniluong nyinge ni Isaka. Anaket singruokna kode kaka singruok manyaka chiengʼ ne nyikwaye. ");
INSERT INTO luo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","To bende asewinjo kwayo mikwayo nikech Ishmael, omiyo anagwedhe, kendo anamiye nyithindo gi nyikwayo mangʼeny. ");
INSERT INTO luo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Makmana singruokna abiro chopo gi Isaka ma Sara biro nywolone e kinde maka ma e higa mabiro.” ");
INSERT INTO luo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kane Nyasaye osetieko wuoyo kod Ibrahim, noweye modhi. ");
INSERT INTO luo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","E odiechiengno Ibrahim nokawo wuode Ishmael kod jogo duto machwo monywol e ode kata mane ongʼiewo gi pesa, kendo noterogi nyangu, mana kaka Nyasaye nonyise. ");
INSERT INTO luo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibrahim ne ja-higni piero ochiko gochiko kane otere nyangu, ");
INSERT INTO luo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","to wuode Ishmael ne ja-higni apar gadek. ");
INSERT INTO luo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ibrahim kod wuode Ishmael noter nyangu odiechiengno. ");
INSERT INTO luo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Kendo chwo duto mane ni e od Ibrahim, kaachiel gi monywol e ode kata ma ongʼiewo, bende noter nyangu kode. ");
INSERT INTO luo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Jehova Nyasaye nofwenyore ne Ibrahim machiegni kod yiende madongo mag Mamre kane obet e dho hembe kar odiechiengʼ tir. ");
INSERT INTO luo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ibrahim notingʼo wangʼe malo kendo noneno ji adek machwo kochungʼ bute. Kane onenogi, noringo matek koa e dho hema mondo oromnegi kendo nopodho piny auma e nyimgi. ");
INSERT INTO luo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Nowacho niya, “Ruodha ka ayudo ngʼwono e wangʼi, to kik ikadh jatichni. ");
INSERT INTO luo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Rituru mondo okel pi matin, mondo uluokgo tiendu eka uywe e tiend yien-ni. ");
INSERT INTO luo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","We ayudnue chiemo moro matin mondo ucham omednu teko eka udhi nyime gi wuodhu mosekelou ir misumbauni.” Negidwoke niya, “Mano ber, tim kamano.” ");
INSERT INTO luo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Omiyo Ibrahim noreto kadhi ir Sara ei hema mowachone niya, “Kaw mogo mayom gorogoro adek, idwale kendo itedgo makati piyo piyo.” ");
INSERT INTO luo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Eka noringo odhi e dipo kendo noyiero nyarwath mopugno kendo nomiyo jatich molose piyo. ");
INSERT INTO luo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Eka Ibrahim nokawo mo gi chak mar adila kod ring nyarwath mane osetedi maber mi oketogi e nyimgi. Kane gichiemo, Ibrahim nochungʼ butgi e tiend yath. ");
INSERT INTO luo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Negipenjo Ibrahim niya, “Ere Sara chiegi?” Ibrahim nodwokogi niya, “En ei hema.” ");
INSERT INTO luo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Eka achiel kuomgi nowacho niya, “Adier anaduog iri e kinde maka ma higa mabiro kendo Sara chiegi biro nywolo nyathi ma wuowi.” To kara Sara ne winjo wachno kobet e dho hema e ngʼe welogo. ");
INSERT INTO luo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ibrahim kod Sara nosebedo moti kendo hikgi noniangʼ kendo ndalo Sara mag nywol nosekadho. ");
INSERT INTO luo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Omiyo Sara nohum kanyiero gie chunye niya, “Bende ma ditimre adier ka an kod ruodha wasedoko joma oti ka ma?” ");
INSERT INTO luo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Eka Jehova Nyasaye nopenjo Ibrahim niya, “Angʼo momiyo Sara nonyiero kawacho ni, ‘Bende danywol nyathi kaka asetini?’ ");
INSERT INTO luo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Bende nitie gimoro amora matek ne Jehova Nyasaye? Abiro duogo iri e kinde mowinjore e higa mabiro kendo Sara biro nywolo nyathi ma wuowi.” ");
INSERT INTO luo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Omiyo Sara noluor mokwer niya, “Ne ok anyiero.” To kata kamano Jehova Nyasaye nowachone niya, “En adier ni ninyiero.” ");
INSERT INTO luo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kane jogo owuok mondo odhi, Ibrahim nowuok kodgi ka kowogi ka gichomo Sodom. ");
INSERT INTO luo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Eka Jehova Nyasaye nowacho niya, “Bende dapand ne Ibrahim gima adwaro timo? ");
INSERT INTO luo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Adieri Ibrahim biro bedo oganda maduongʼ kendo maratego, kendo ogendini duto manie piny nogwedhi nikech en. ");
INSERT INTO luo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nimar aseyiere mondo ochik nyithinde kod nyikwaye mondo oluw yore Jehova Nyasaye ka gitimo timbe mabeyo kendo makare. Kamano Jehova Nyasaye biro timo ne Ibrahim gik moko duto mane osingone.” ");
INSERT INTO luo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Eka Jehova Nyasaye nowacho niya, “Ywak mi ywaknego Sodom gi Gomora duongʼ kendo richogi ngʼeny, ");
INSERT INTO luo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","kuom mano abiro dhi mondo ane ka gik magisetimo richo kaka ywak osechopo ira, eka abiro ngʼeyo adiera.” ");
INSERT INTO luo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Jogo nowuok kendo negiluwo yo madhi Sodom, to Jehova Nyasaye nodongʼ kochungʼ e nyim Ibrahim. ");
INSERT INTO luo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Eka Ibrahim nosudo machiegni kode kendo openjo niya, “Bende ditiek joma kare machal gi joma timbegi richo? ");
INSERT INTO luo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kaponi nitie ji piero abich maonge ketho e dalano? Dikethe koso diweye nikech ngima ji makare piero abichgo? ");
INSERT INTO luo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ok dineg joma onge ketho machal gi joma oketho, adier ok inyal timo kamano nikech kaponi itimo kamano to joma onge ketho diyud kum mana maromre gi joma nigi ketho. To mano ok nyalre nikech jangʼad bura nyaka ngʼad bura kare?” ");
INSERT INTO luo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Eka Jehova Nyasaye nowacho niya, “Ka ayudo ji piero abich maonge ketho e dala mar Sodom, to abiro reso dalano nikech joma onge kethogo.” ");
INSERT INTO luo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Eka Ibrahim nowacho kendo niya, “Kaka koro asebedo gichir ma awuoyo gi Ruoth Nyasaye, kata obedo ni ok an gimoro to makmana lowo kod buru. ");
INSERT INTO luo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","To ka dipo ni kwan joma onge ketho oromo mana ji piero angʼwen gabich, dikech dalano nikech ji abich kende?” Jehova Nyasaye nodwoke niya, “Kayudo ji piero angʼwen gabich kanyo, to ok nakethe.” ");
INSERT INTO luo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibrahim nomedo wuoyo kode kendo niya, “To ka dipo ni ji piero angʼwen kende ema oyudore kanyo?” Ruoth Nyasaye nodwoke niya, “Kayudo ji piero angʼwen kanyo, to ok nakethe.” ");
INSERT INTO luo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Eka Ibrahim nomedo wachone niya, “Kik isin koda, to weya aweya awuo. To ka dipo ni ji piero adek ema oyudi e dalano?” Jehova Nyasaye nodwoke niya, “Ok nakethi ka ayudo ji piero adek maonge ketho kanyo.” ");
INSERT INTO luo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ibrahim nowacho niya, “Kaka koro asebedo gi chir ma wuoyo gi Ruoth Nyasaye, angʼoma ditim ka ji piero ariyo ema oyudore e dalano?” Jehova Nyasaye nodwoke niya, “Nikech ji piero ariyo maonge ketho ok anakethe.” ");
INSERT INTO luo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Eka Ibrahim nowacho niya, “Mad Jehova Nyasaye kik sin koda, to oyie awach wach achiel mogik. Ka dipo ni ji apar kende ema oyudi e dalano?” Ruoth Nyasaye nodwoke niya, “Nikech ji apar maonge ketho ok natiek dalano.” ");
INSERT INTO luo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kane Jehova Nyasaye osetieko wuoyo kod Ibrahim, nowuok kendo Ibrahim nodok dala. ");
INSERT INTO luo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Malaika ariyogo nochopo Sodom kar angʼich welo kendo Lut noyudo obet e dhoranga dalano. Kane onenogi, noa malo mondo mi opodho auma e nyimgi. ");
INSERT INTO luo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Nowachonegi niya, “Jodongo, yieru uraw e od jatichu mondo ulwok tiendeu kendo unindi eka kiny unyalo dhi gokinyi.” To negiwacho niya, “Ooyo, wabiro nindo mana e laru kae.” ");
INSERT INTO luo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","To Lut nonano ni nyaka ginind e ode. Eka ne olosonegi chiemo, kendo notedonigi makati ma ok oketie thowi mi gichiemo. ");
INSERT INTO luo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kane pok gidhi e nindo, chwo madongo kod matindo moa kuonde duto mag dala maduongʼ mar Sodom, nobiro molworo odno. ");
INSERT INTO luo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Negiluongo Lut ka gipenje niya, “Ere chwo mane obiro iri ka gotieno? Golnwagi oko kae wadwa terore kodgi.” ");
INSERT INTO luo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kuom mano, Lut noloro dhoot mowuok odhi irgi, ");
INSERT INTO luo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","kendo nowachonegi niya, “Ooyo jowadwa, kik utim tim makweroni! ");
INSERT INTO luo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Koro neuru, an kod nyiri ariyo mapok ongʼeyo chwo; weuru agolnugi oko mondo utim kodgi kaka uhero; to kik utim marach ni jogi, nimar gin wenda.” ");
INSERT INTO luo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Negidwoke niya, “Wuogi e nyimwa, in nibiro ka kaka jadak kendo koro idwaro ketori kaka jangʼad bura!” Wabiro timoni marach moloyogi, omiyo ne gidhiro Lut giteko mondo gi muk dhoot. ");
INSERT INTO luo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","To jogo mane ni e otgo noywayo Lut mi odwoko e ot kendo giloro dhoot. ");
INSERT INTO luo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Eka negimiyo jomanenie dhoot oko-go obedo muofni, jomatindo gi jomadongo, mane ok ginyal yudo dhoot. ");
INSERT INTO luo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ji ariyogo nowacho ni Lut niya, “Bende in gi ngʼato moro kae kaka chwo nyigi, yawuoti kata nyigi, kata ngʼat moro amora e dala maduongʼni ma watni? Golgi oko kae, ");
INSERT INTO luo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","nikech wadhi ketho dalani. Ywak ma iywak nego dalani osebedo malich e nyim Jehova Nyasaye, omiyo oseorowa mondo wakethe.” ");
INSERT INTO luo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kuom mano Lut nodhi mowuoyo gi chwo nyige mane osetimo winjruok mar kend gi nyige. Nowachonegi niya, “Timuru piyo piyo mondo uwuog oko e dalani, nikech Jehova Nyasaye oseikore mar ketho dala maduongʼni!” To chwo nyige ne paro ni otugo. ");
INSERT INTO luo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kane ochopo kogwen, malaika nojiwo Lut, kawacho niya, “Tim piyo kaw chiegi gi nyigi ariyo man kae, nono to ubiro rumo ka dala maduongʼni iketho.” ");
INSERT INTO luo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Kane pod gidigni, malaika ariyogo nomako lwete gi lwet chiege kod lwet nyige ariyo ma gigologi oko mar dala maduongʼni, nikech Jehova Nyasaye nokechogi. ");
INSERT INTO luo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Piyo piyo nono kane gisegologi oko, achiel kuom malaikago nowacho niya, “Ring utony ne ngimau! Kik ungʼi chien, kendo kik uchung kamoro amora e pap; tonyuru udhi e gode nono, to ubiro lal!” ");
INSERT INTO luo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","To Lut nowachonegi niya, “Ooyo, Ruodha, asayou! ");
INSERT INTO luo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Jatichu oseyudo kech e wangʼu, kendo usenyisa ngʼwono maduongʼ kuom reso ngimana. To kata kamano ok anyal ringo nyaka e gode; nono to chandruogni ojuka mi anyalo atho. ");
INSERT INTO luo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ne, nitie dala moro matin machiegni manyalo ringo mondo atonyie. En mana dalano omiyo yienwauru mondo omi wachop kuno kendo wares ngimawa.” ");
INSERT INTO luo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nowachone niya, “Mano ber, kwayonino bende abiro rwako; kendo ok naketh dala miwachono. ");
INSERT INTO luo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kuom mano ring idhi kuno piyo, nikech ok anyal timo gimoro nyaka ichop kuno.” (Mano ema omiyo noluong dalano ni Zoar.) ");
INSERT INTO luo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lut nochopo Zoar gokinyi kar onyango. ");
INSERT INTO luo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Eka Jehova Nyasaye noolo kite maliel makakni koa e polo mowangʼo Sodom gi Gomora. ");
INSERT INTO luo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kamano noketho mier madongogo gi pawno duto, kaachiel gi ji duto manodak e miergo kod gik moko duto manyak e lowo. ");
INSERT INTO luo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","To chi Lut nolokore mongʼiyo chien, kendo nolokore siro mar chumbi. ");
INSERT INTO luo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kinyne gokinyi, Ibrahim nomondo kama ne ochungʼie nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Nongʼiyo mwalo yo Sodom gi Gomora, kod pewege duto kendo noneno iro maduongʼ koa e pinyno, mana ka iro mar mach maduongʼ. ");
INSERT INTO luo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kuom mano ka Nyasaye noketho mier mag pap, noparo Ibrahim kendo nogolo Lut oko mar masirano mane oketho mier mane odakie. ");
INSERT INTO luo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lut kod nyige ariyo nowuok Zoar kendo negidhi gidak e gode nikech noluor dak Zoar. En kod nyige ariyo negidak e rogo. ");
INSERT INTO luo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Chiengʼ moro achiel nyar Lut maduongʼ nowacho ne nyamin matin niya, “Wuonwa koro oseti, kendo onge ngʼama nyalo kendowa kaka chik mar piny duto dwaro. ");
INSERT INTO luo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","We wami wuonwa kongʼo omadhi kendo ka osemer, to wariwre kode kendo wanywol nyithindo mondo kik ogandawa lal.” ");
INSERT INTO luo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Gotienono negimiyo wuon-gi kongʼo mi omer, kendo nyare maduongʼ nodonjo moriwore kode. Lut nomer mane ok ongʼeyo seche mano ochako kata tieko riwore gi nyare. ");
INSERT INTO luo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kinyne nyako maduongʼ ne owacho ne nyako matin niya, “Otieno mokadho ne ariwora gi wuonwa. Omiyo we wamiye kongʼo kendo kawuono mi omer mondo idhi iriwri kode kendo wanywol nyithindo mondo kik ogandawa lal.” ");
INSERT INTO luo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kuom mano negimiyo wuon-gi kongʼo momer gotieno kendo nyako matin nodonjo ma oriwore kode. Kendo ne ok ongʼeyo seche mane nyare matin-no ochako kata otieko riwore kode. ");
INSERT INTO luo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kuom mano nyi Lut ariyogo nomako ich kod wuon-gi. ");
INSERT INTO luo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nyako maduongʼ nonywolo wuowi, kendo nochake ni Moab, en e kwar jo-Moab ma kawuono. ");
INSERT INTO luo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nyako matin bende nonywolo wuowi kendo nochake ni Ben-Ami; en e kwar jo-Amon. ");
INSERT INTO luo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ibrahim nowuotho moa kanyo modhi e gwenge mag Negev kendo odak e kind Kadesh kod Shur. Nodak Gerar kuom kinde matin, ");
INSERT INTO luo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","kendo kanyo ema Ibrahim nowachonegi niya, “Sara en nyaminwa.” Eka Abimelek ruodh Gerar nooro joote moomone Sara kendo nokawe kaka chiege. ");
INSERT INTO luo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","To Nyasaye nofwenyore ne Abimelek e lek gotieno kendo owachone niya, “Dine ber ka itho nikech dhako ma ikawono; en chi ngʼato.” ");
INSERT INTO luo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","To ne oyudo Abimelek pok oriwore kode. Eka nowacho niya, “Jehova Nyasaye bende dineg joma onge ketho? ");
INSERT INTO luo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Donge ne onyisa ni ma nyaminwa; kendo donge Sara ema nowachona ni ma owadwa? Asetimo ma giparo malongʼo kod lwedo maler.” ");
INSERT INTO luo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Eka Nyasaye nowachone e lek niya, “Ee angʼeyo ni nitimo ma kod paro malongʼo omiyo aseriti mondo kik iketh e nyima. Mano ema nomiyo ok ayieni mondo iriwri kode. ");
INSERT INTO luo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Koro dwokne Ibrahim chiege, nimar en janabi, kendo obiro lamoni mi ok initho. To ka ok idwoke, to bed gadiera ni in gi jogi duto ubiro tho.” ");
INSERT INTO luo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kinyne gokinyi mangʼich Abimelek noluongo jotichne duto kendo kane onyisogi gik moko duto mane osetimore, negibedo maluor ahinya. ");
INSERT INTO luo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Eka Abimelek noluongo Ibrahim ire mi openje niya, “Angʼo ma isetimonwani? Ere gima rach ma asetimoni ma omiyo isekelo richo maduongʼni kuoma kod pinyruodha? Isetimona gik moko ma ok onego tim ne ngʼato.” ");
INSERT INTO luo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Kendo Abimelek nopenjo Ibrahim niya, “En angʼo miparo momiyo itimo gini?” ");
INSERT INTO luo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibrahim nodwoke niya, “Ne awacho e chunya ni, ‘Adier luor mar Nyasaye onge ka, kendo gibiro nega nikech chiega.’ ");
INSERT INTO luo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","To bende, kuom adier en nyaminwa, ma nyar wuora, to minewa ema opogore; kendo ne akende obedo chiega. ");
INSERT INTO luo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kendo kane Nyasaye ochika mondo awuog e od wuora mondo awuoth e pinje mamoko, nawachone Sara ni, ‘Mae kaka inyalo nyisa ni ihera: Kamoro amora ma wadhiye wach niya, “An owadu.” ’ ” ");
INSERT INTO luo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Eka Abimelek nokelo rombe gi dhok kod wasumbini mamon kod machwo kendo nomiyogi Ibrahim kendo Abimelek nodwokone Ibrahim Sara chiege. ");
INSERT INTO luo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Kendo Abimelek nowacho niya, “Pinya duto ni e lweti; dag kamoro amora ma ihero.” ");
INSERT INTO luo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Nonyiso Sara bende niya, “Asemiyo owadu shekel mar fedha maromo alufu achiel mondo obed ranyisi ne jou duto ni ionge gi ketho; nikech ok isetimo gimoro amora marach.” ");
INSERT INTO luo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Eka Ibrahim nolamo Nyasaye, kendo Nyasaye nochango Abimelek, chiege kod jotichne ma nyiri mondo omi ginywol nyithindo kendo, ");
INSERT INTO luo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","nimar noyudo ka Jehova Nyasaye osedino ii mon man e od Abimelek nikech Sara chi Ibrahim. ");
INSERT INTO luo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Koro Jehova Nyasaye notimo ngʼwono ne Sara kaka nosewacho kendo Jehova Nyasaye nochopo kare singruok mane osenyiso Sara. ");
INSERT INTO luo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara nomako ich kendo nonywolone Ibrahim wuowi ka Ibrahim hike oniangʼ, mana e kinde mane Nyasaye osingore. ");
INSERT INTO luo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibrahim nochako wuowi mane Sara onywolone ni Isaka. ");
INSERT INTO luo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Kane wuode Isaka nigi ndalo aboro, Ibrahim notere nyangu kaka Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ibrahim ne ja-higni mia achiel kane onywol Isaka wuode. ");
INSERT INTO luo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara nowacho niya, “Nyasaye osekelona mor kendo ji duto mowinjo ma biro bedo mamor koda.” ");
INSERT INTO luo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kendo nomedo wacho niya, “Ngʼama dine nyis Ibrahim ni Sara didhodh nyathi? To koro asenywolone wuowi ka en ngʼama oti.” ");
INSERT INTO luo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nyathino nodongo kendo nowe dhoth, kendo chiengʼ mane Isaka oweyoe dhoth Ibrahim notimo nyasi maduongʼ. ");
INSERT INTO luo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Chiengʼ moro Sara noneno ka Ishmael mane Hagar nyar Misri onywolo ne Ibrahim ka jotugo gi Isaka kendo jare. ");
INSERT INTO luo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Omiyo Sara nowacho ne Ibrahim niya, “Riemb dhako ma misumbani kod wuode, nimar wuod dhako ma misumbani ok nobed jacham girkeni kaachiel gi wuoda Isaka.” ");
INSERT INTO luo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Gino nochwanyo Ibrahim ahinya nikech wachno neni kuom wuode. ");
INSERT INTO luo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","To Nyasaye nowacho ne Ibrahim niya, “Kik chunyi bed gi chwanyruok nikech wuodi Ishmael kod jatichni madhako, Hagar. Winj gimoro amora ma Sara jaodi wachoni; nikech kuom wuodi Isaka ema kothi duto nowuogie. ");
INSERT INTO luo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Abiro miyo wuod jatichni madhako bed oganda maduongʼ nikech en bende en rembi.” ");
INSERT INTO luo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kinyne gokinyi mangʼich Ibrahim nokawo chiemo kod puga mar pi kendo nomiyo Hagar. Noketonegi e goke kendo ogole odhi gi wuode. Hagar nowuok modhi kendo nobayo abaya e thim mar Bersheba. ");
INSERT INTO luo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ka pi mane ni e puga norumo, noketo nyathi e tiend bungu. ");
INSERT INTO luo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Eka nowuotho odhi nyime kama dirom fut adek kendo nobedo piny kanyo, mi nowacho e chunye niya, “Ok anyal rango nyathi katho.” Kendo kane obet machiegni kanyo, nyathi nochako ywak. ");
INSERT INTO luo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nyasaye nowinjo nyathi kaywak kendo malaika mar Nyasaye noluongo Hagar gie polo kendo owachone niya, “Angʼo marach, Hagar? Kik iluor; Nyasaye osewinjo nyathi kaywak kama onindeno. ");
INSERT INTO luo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kaw nyathi kendo itingʼe, nikech anami nyikwaye obed oganda maduongʼ.” ");
INSERT INTO luo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Eka Nyasaye noyawo wengene kendo oneno soko mar pi. Kuom mano nodhi mopongʼo puga gi pi kendo nomiyo nyathi omodho. ");
INSERT INTO luo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nyasaye ne ni kod wuowino kane odongo kendo nodak e thim mobedo jadwar molony. ");
INSERT INTO luo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Kane odak e thim mar Paran, min mare noyudone nyako mokendo koa e piny Misri. ");
INSERT INTO luo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","E kindeno Abimelek kod Fikol jatend jolweny mar Abimelek nowacho ne Ibrahim niya, “Nyasaye ni kodi e gimoro amora mitimo. ");
INSERT INTO luo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Koro kwongʼrina e nyim Nyasaye kawuono ni ok nitimna gimoro marach kata ne nyithinda kata ne nyikwaya. Emomiyo koro timna ngʼwono kaachiel gi pinyni ma intie kaka jadak mana kaka an bende ne atimoni maber.” ");
INSERT INTO luo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibrahim nodwoke niya, “Asingora ni anatim kamano.” ");
INSERT INTO luo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ibrahim nonyiso Abimelek chandruok mar soko mar pi ma jotich Abimelek nomaye githuon. ");
INSERT INTO luo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","To Abimelek nowacho niya, “Ok angʼeyo ngʼama osetimo mae. Ne ok inyisa, ma kawuono ema akwongo winje.” ");
INSERT INTO luo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kuom mano Ibrahim nokelo rombe kod dhok mi omiyogi Abimelek, kendo ji ariyogi notimo singruok. ");
INSERT INTO luo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ibrahim nowalo rombe ma sibini abiriyo mag kwethge, ");
INSERT INTO luo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","kendo Abimelek nopenjo Ibrahim niya, “Ere tiend rombe ma sibini abiriyo ma isewalogi?” ");
INSERT INTO luo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ibrahim nodwoke niya, “Kaw nyirombe abiriyogi kaka ranyisi ni nakunyo sokoni.” ");
INSERT INTO luo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Mano emomiyo kanyo iluongo ni Bersheba nikech ji ariyogo notimo singruok kanyo. ");
INSERT INTO luo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Bangʼ ka winjruok nosetim Bersheba, Abimelek kod Fikol ma jatend jolwenje nodok e piny jo-Filistia. ");
INSERT INTO luo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibrahim nopidho yien moro Bersheba, kendo kanyo noluongo nying Jehova Nyasaye, Nyasaye manyaka chiengʼ. ");
INSERT INTO luo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Kendo Ibrahim nodak e piny jo-Filistia kuom kinde mangʼeny. ");
INSERT INTO luo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bangʼ kinde moko Nyasaye notemo Ibrahim. Noluonge niya, “Ibrahim!” Eka nodwoke niya, “Eri an ka.” ");
INSERT INTO luo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Eka Nyasaye nowacho niya, “Kaw wuodi, wuodi ma miderma Isaka, kendo mi ihero mondo idhigo e gwengʼ mar Moria. Chiwe kanyo kaka misango miwangʼo pep ewi got moro ma abiro nyisi.” ");
INSERT INTO luo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kinyne gokinyi mangʼich Ibrahim noa malo kendo noiko pundane ne wuoth. Nodhi kod jotijene ariyo kaachiel gi Isaka wuode. Kane osengʼado yien moromo tiyogo e misango miwangʼo pep, nochako wuoth madhi kamane Nyasaye osenyise. ");
INSERT INTO luo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","E odiechiengʼ mar adek Ibrahim notingʼo wangʼe moneno kanyo gi kuma bor. ");
INSERT INTO luo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Nowacho ne jotije niya, “Dongʼuru kae gi punda ka an kod Isaka wadhi kucha. Wadhi lemo kendo eka wabiro duogo iru.” ");
INSERT INTO luo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibrahim nokawo yien mar misango miwangʼo pep kendo nomiyo Isaka, to en owuon notingʼo mach kod pala ka ji ariyogo ne wuotho. ");
INSERT INTO luo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaka notingʼo dwonde mopenjo wuon-gi Ibrahim niya, “Wuora?” Ibrahim nodwoke niya, “En angʼo wuoda?” Eka Isaka nopenje niya, “Mach kod yien nikae, to ere nyaim mar misango miwangʼo pep?” ");
INSERT INTO luo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibrahim nodwoke niya, “Wuoda, Nyasaye owuon ema biro chiwo nyaim mar misango miwangʼo pep.” Bangʼ mano negidhi nyime giwuodhgi kanyakla. ");
INSERT INTO luo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kane gichopo kumane Nyasaye osenyiso Ibrahim, Ibrahim nogero kendo mar misango kanyo kendo nopango yien e wiye motweyo Isaka wuode kendo nopiele ewi kendo mar misango, ewi yien. ");
INSERT INTO luo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Eka notero lwete kendo okawo pala mondo oneg-go wuode. ");
INSERT INTO luo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","To malaika mar Jehova Nyasaye noluonge gie polo niya, “Ibrahim! Ibrahim!” Eka nodwoke niya, “Eri an ka.” ");
INSERT INTO luo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malaika nowachone niya, “Kik iket lweti kuom wuodi, kendo kik itimne gimoro amora. Koro asengʼeyo ni iluoro Nyasaye, nikech ok isetama e wuodi ma miderma.” ");
INSERT INTO luo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibrahim notingʼo wangʼe mopo koneno im komoko gitungene e bungu. Nodhi mokawo im kendo ochiwo kaka misango miwangʼo pep kar wuode. ");
INSERT INTO luo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Omiyo Ibrahim nochako kanyo ni Jehova Nyasaye ma Jachiwo kendo nyaka chil kawuono iwacho niya, “E God Jehova Nyasaye ema nochiwe.” ");
INSERT INTO luo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Malaika mar Jehova Nyasaye nochako luongo Ibrahim gie polo, ");
INSERT INTO luo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","mi Jehova Nyasaye owacho niya, “Akwongʼora gi nyinga awuon, ni nikech isetimona ma kendo ok isetama e wuodi ma miderma, ");
INSERT INTO luo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","abiro gwedhi adier kendo anami nyikwayi bed mangʼeny ka sulwe mae polo kendo ka kuoyo manie dho nam. Nyikwayi nokaw mier mag jowasikgi mondo obed margi, ");
INSERT INTO luo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","kendo ogendini duto manie piny nogwedhi kokalo e kothi, nikech isewinjo wachna.” ");
INSERT INTO luo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Eka Ibrahim nodok ir jotije, kendo giduto negiwuok ka gidok Bersheba. Kendo Ibrahim nodak Bersheba. ");
INSERT INTO luo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Bangʼ kinde moko, Ibrahim noyudo wach niya, “Milka bende koro osenywolone owadu Nahor yawuowi ma gin: ");
INSERT INTO luo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz wuowi makayo, Buz owadgi, Kemuel (wuon Aram), ");
INSERT INTO luo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazo, Pildash, Jidlaf kod Bethuel.” ");
INSERT INTO luo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel nonywolo Rebeka. Yawuowi aborogo ema Milka nonywolone Nahor owadgi Ibrahim. ");
INSERT INTO luo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Jatichne ma nyako ma nyinge Reuma bende nonywolone yawuowi, ma gin: Teba, Gaham, Tahash kod Maaka. ");
INSERT INTO luo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara nodak kuom higni mia achiel gi piero ariyo gabiriyo. ");
INSERT INTO luo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Notho Kiriath Arba (ma tiende ni Hebron) e piny Kanaan, kendo Ibrahim noywago Sara kendo nodengo ahinya. ");
INSERT INTO luo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Eka Ibrahim noa malo e but ringre chiege kendo owuoyo gi jo-Hiti kowachonegi niya, ");
INSERT INTO luo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“An mana jadak kendo wendo e kindu. Miyauru kamoro angʼiew moromo kar yiko.” ");
INSERT INTO luo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Jo-Hiti nodwoko Ibrahim niya, ");
INSERT INTO luo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Jaduongʼ, winjwa in jatelo maduongʼ e kindwa. Ik aika ngʼati e bur-wa moro amora miyiero. Onge ngʼato e dierwa mabiro tami yiko ngʼati e bure.” ");
INSERT INTO luo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Eka Ibrahim nochungʼ mokulore e nyim jo-Hiti. ");
INSERT INTO luo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Nowachonegi niya, “Ka uyie mondo aik ngʼata, to winjauru kendo ukwana Efron wuod Zohar ");
INSERT INTO luo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","mondo mi ousna bure man Makpela manie giko puothe. Kwayeuru mondo ousnago e nengo mowinjore mondo obed kara mar yiko.” ");
INSERT INTO luo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron ja-Hiti noyudo obet piny e kind jog-gi kendo nodwoko Ibrahim ka jo-Hiti duto ma nobiro e dhoranga dalano winjo. ");
INSERT INTO luo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Nowachone niya, “Ooyo ruodha, winja, amiyi puodho, kendo amiyi bur man kanyo. Amiyigo e nyim jowagi duto mondo iyikie ngʼati motho.” ");
INSERT INTO luo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ibrahim nochako okulore e nyim jo-Hiti, ");
INSERT INTO luo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","kendo nowacho ne Efron ka giwinjo niya, “Ka iyie to winja. Abiro chulo nengo mar puodhono. Yie achuli mondo mi aik ngʼata kanyo.” ");
INSERT INTO luo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron nodwoko Ibrahim niya, ");
INSERT INTO luo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Winja ruodha; nengo lowono oromo kilo angʼwen gi nus mar fedha. To en angʼo mathagowa; ik ngʼati.” ");
INSERT INTO luo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibrahim noyie gi dwaro mar Efron kendo nomiye nengo mar puodho mane osewacho ka jo-Hiti winjo: ma en kilo angʼwen gi nus mar fedha kaluwore gi rapim mane jo-ohala tiyogo. ");
INSERT INTO luo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Omiyo puoth Efron man Makpela machiegni gi Mamre kaachiel gi lowo kod bur mosekuny gi yien duto mane ni e puodhono, ");
INSERT INTO luo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","nodoko mwandu mag Ibrahim e nyim jo-Hiti duto mane obiro kaka joneno e dhoranga dala. ");
INSERT INTO luo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Bangʼe Ibrahim noiko chiege Sara e bur mane ni e puodho ma Makpela machiegni gi Mamre (man Hebron) e piny Kanaan. ");
INSERT INTO luo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kuom mano puodhono gi bur mane nitie jo-Hiti nomiyo Ibrahim kaka kare mar yiko. ");
INSERT INTO luo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibrahim noseti kendo hike noniangʼ, kendo Jehova Nyasaye nosegwedhe e yore duto. ");
INSERT INTO luo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Nowacho ne jatichne maduongʼ mane rito gige ode duto niya, “Ket lweti e kind ema. ");
INSERT INTO luo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Adwaro mondo ikwongʼrina gi nying Jehova Nyasaye, Nyasach polo kod piny ni ok ibi yudone wuoda dhako koa kuom nyi Kanaan ma an jadak e kindgini, ");
INSERT INTO luo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","to ibiro dhi thurwa kendo ir wedena mondo iyudne wuoda Isaka dhako.” ");
INSERT INTO luo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Jatichne nopenje niya, “Datim angʼo ka nyakono ok oyie biro koda e pinyni? Dadwok wuodi thuru kumane iayeno?” ");
INSERT INTO luo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibrahim nowachone niya, “Nyaka ine ni ok idwoko wuoda kuno. ");
INSERT INTO luo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jehova Nyasaye, ma Nyasach polo mane ogola thurwa e dala wuora kendo nowuoyo koda kotimo koda singruok ni, ‘To ne nyikwayi nami pinyni’ kendo en owuon ema obiro oro malaikane nyimi mondo mi iyudne wuoda dhako kuno. ");
INSERT INTO luo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","To ka nyakono ok dwar biro kodi, eka inibed thuolo kuom singruok ma atimo kodini. Ne mana ni ok idwoko wuoda kuno.” ");
INSERT INTO luo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Omiyo jatijeno noketo lwete e kind em ruodhe Ibrahim kendo notimo singruok kode e wachni. ");
INSERT INTO luo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Eka jatijeno nokawo ngamia apar mag ruodhe, kod chiwo duto mabeyo mochako wuoth kodhi Aram-Naharaim (tiende ni, Mesopotamia) koluwo yo madhi dala matin mar Nahor. ");
INSERT INTO luo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Noketo ngamia onindo piny machiegni gi soko but dala; ne en kar angʼich welo, seche mamon dhi umbo. ");
INSERT INTO luo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Eka nolemo niya, “Yaye Jehova Nyasaye Nyasach ruodha Ibrahim, gwedha kawuono, kendo nyis ngʼwononi ne ruodha Ibrahim. ");
INSERT INTO luo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ne, koro eri achungo e bath sokoni, kama nyi dalani biro umboe pi. ");
INSERT INTO luo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Mad timreni ka awachone nyako moro ni, ‘Asayi, yie dapigi piny mondo mi amodhie,’ kendo ka dowachna ni, ‘modhi kendo abiro chiwo pi ni ngamia-gi duto’ to en ema mondo obed nyako ma iseyierone Isaka jatichni. Kamano anangʼe ni isenyiso ngʼwononi ne ruodha.” ");
INSERT INTO luo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Kane pok otieko lemo, Rebeka notucho kotingʼo dapige e goke. Ne en nyar Bethuel wuod Milka, mane chi Nahor owadgi Ibrahim. ");
INSERT INTO luo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nyakoni ne en jaber man-gi chia, mapok ongʼeyo dichwo! Nolor e soko, motwomo pi eka odwogo. ");
INSERT INTO luo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Jatich Ibrahim noringo kadhi romone mi owachone niya, “Akwayi, yie imiyae pi mondo amodhi.” ");
INSERT INTO luo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Eka nowacho niya, “Modhi, ruodha” kendo mapiyo nono noloro dapi e lwete momiye pi omodho. ");
INSERT INTO luo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Bangʼ kane osemiye pi modho, nowachone niya, “Abiro dhi umbo pi ne ngamia magi bende, nyaka gitiek modho.” ");
INSERT INTO luo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Omiyo noloko pi mapiyo nono e besen, moringo odok e soko omo pi kendo noomo moromo ngamiagego duto. ");
INSERT INTO luo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Jatich Ibrahim nolingʼ thi ma ok owuoyo, karange lingʼ-lingʼ mondo one ane ka Jehova Nyasaye osegwedho wuodhe. ");
INSERT INTO luo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kane ngamia-go osetieko modho, ngʼatno nogolo tere mar um mar dhahabu ma pekne romo achiel kuom apar mar kilo kod bangli ariyo mag dhahabu mapekgi oromo nus kilo. ");
INSERT INTO luo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Eka nopenje niya, “In nyar ngʼa? Yie inyisa bende dwayudie kar nindo dalau?” ");
INSERT INTO luo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nodwoke niya, “An nyar Bethuel, ma wuod Nahor gi Milka.” ");
INSERT INTO luo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kendo nomedo wacho niya, “Wan kod lum kod chiemb ngamia mangʼeny kaachiel gi ot ma unyalo nindoe.” ");
INSERT INTO luo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ngʼatno nopodho auma molamo Jehova Nyasaye, ");
INSERT INTO luo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","kowacho niya, “Duongʼ odogne Jehova Nyasaye, ma Nyasach ruodha Ibrahim, ma ok oseweyo nyiso adierane gi ngʼwonone ne ruodha. To an, Jehova Nyasaye osetelona e wuoth nyaka e od wede ruodha.” ");
INSERT INTO luo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nyakono noringo modhi onyiso joodgi duto gik mane osetimorene. ");
INSERT INTO luo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka ne nigi owadgi miluongo ni Laban, kendo Laban noringo matek ka dhi ir ngʼatno mane ni e sokono. ");
INSERT INTO luo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Kane Laban oseneno tere e um nyamin kod bangli ka ni e lwet nyamin kendo kane owinjo gima Rebeka wacho ni ngʼatno onyise, Laban nodhi ir ngʼatno moyude ka ochungʼ e bath ngamia-go machiegni gi soko. ");
INSERT INTO luo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban nowachone niya, “Bi, in ngʼama Jehova Nyasaye ogwedho. Angʼo ma omiyo ichungʼ oko ka? Aseikoni ot kendo nitie kar ngamia bende.” ");
INSERT INTO luo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kuom mano ngʼatno nodonjo e ot kendo misike mane ngamia otingʼo nogol kuomgi. Nomigi lum kod chiembgi mi nokelo pi ne jatich Ibrahim kod joge mondo olwokgo tiendegi. ");
INSERT INTO luo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Eka nokel chiemo ne jatich Ibrahim to nowachonegi niya, “Ok abi chiemo kapok anyisou gima onego awachnu.” Laban nowachone niya, “Kara nyiswa.” ");
INSERT INTO luo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kuom mano nowacho niya, “An jatich Ibrahim. ");
INSERT INTO luo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Jehova Nyasaye osegwedho ruodha ahinya kendo osebedo jamoko. Osemiye rombe kod dhok, fedha kod dhahabu, jotich machwo kod mamon gi ngamia kod punde. ");
INSERT INTO luo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, jaod ruodha osenywolone wuowi ka hike oniangʼ kendo ruodha osemiyo wuodeno mwandune duto. ");
INSERT INTO luo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ruodha nomiyo akwongʼora kowacho ni, ‘Kik iyudne wuoda nyako kuom nyi Kanaan ma adakie lopgini, ");
INSERT INTO luo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","to dhi e dala wuora kendo ir anywolana kendo iyudne nyako ne wuoda.’ ");
INSERT INTO luo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Eka ne apenjo ruodha ni, ‘Datim nangʼo ka nyakono ok oyie biro koda?’ ");
INSERT INTO luo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Nodwoke ni, ‘Jehova Nyasaye, ma asebedo ka awuotho e nyime biro ori gi malaikane kendo obiro gwedho wuodhi, mondo mi iyudne wuoda nyako moa kuom anywolana kendo e od wuora. ");
INSERT INTO luo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ka idhi michopo ir jowa to singruogni ok nomaki, to bende ka gitamore miyi nyakono mondo ibigo, to kwongʼruokni ok nobed e wiyi.’ ");
INSERT INTO luo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Kane abiro e soko kawuono, nawacho ni, ‘Yaye Jehova Nyasaye, Nyasach ruodha Ibrahim, kalongʼoni, to gwedh wuodhani. ");
INSERT INTO luo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ne, koro eri achungo e bath sokoni, ka jatich ma nyako obiro omo pi kendo awachone niya, “Yaye miyae pi amodhi,” ");
INSERT INTO luo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","kendo ka owachona niya, “Modhi, kendo abiro omo pi nyaka ne ngamia-gi bende,” to en ema mondo obed nyako ma Jehova Nyasaye oseyiero ne wuod ruodha.’ ");
INSERT INTO luo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Kane pok atieko lemo e chunya, Rebeka nochopo ka otingʼo dapi e goke. Nolor e soko mondo otuom pi kendo nawachone ni, ‘Yaye miyae pi amodhi.’ ");
INSERT INTO luo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Piyo piyo nono noyieyo pi piny mi owacho ni, ‘Modhi kendo abiro miyo ngamia magi bende pi.’ Kuom mano namodho, kendo ngamia bende nomodho. ");
INSERT INTO luo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Napenje ni, ‘In nyar ngʼa?’ “En to nodwoka ni, ‘An nyar Bethuel, wuod Nahor gi Milka.’ “Eka ne aketo tere e ume gi bangli e lwete, ");
INSERT INTO luo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","kendo napodho auma kalamo Jehova Nyasaye. Namiyo Jehova Nyasaye ma Nyasach ruodha Ibrahim duongʼ, mane telona e yo maber mayudo nyako ma nyakwar owad gi ruodha ne wuode. ");
INSERT INTO luo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Koro nyisauru kuyie timo ngʼwono kod adieri ne ruodha; to ka ok kamano to nyisa mondo mi angʼe kuma achomo.” ");
INSERT INTO luo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban kod Bethuel nodwoke niya, “Ma-oa kuom Jehova Nyasaye ok wanyal wachoni gimoro amora. ");
INSERT INTO luo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka eri; kawe mondo udhi, kendo obed chi wuod ruodhi, mana kaka Jehova Nyasaye osechiko.” ");
INSERT INTO luo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kane jatich Ibrahim owinjo gima negiwacho, nopodho auma e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Eka jatich Ibrahim nogolo gik moko mag dhahabu kod mag fedha kod lewni mi nomiyogi Rebeka; kendo nochiwo mich ma nengogi tek ne owadgi kod min-gi. ");
INSERT INTO luo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Eka jatich Ibrahim kod jogo mane ni kode nochiemo kendo ometho kendo ne ginindo kanyo. Kane gichiewo kinyne gokinyi nowacho niya, “Weuru adog ir ruodha.” ");
INSERT INTO luo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","To owad gi Rebeka kod min-gi nodwoke niya, “We nyakoni odongʼ kodwa kuom ndalo apar kata moloyo kanyo; eka udhi.” ");
INSERT INTO luo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","To jatich Ibrahim nowachonegi niya, “Kik ugengʼna, to weyauru adog ir ruodha, nikech Jehova Nyasaye osegwedho wuodha.” ");
INSERT INTO luo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Eka negiwacho niya, “We waluong nyako mondo wapenje kuom wachni.” ");
INSERT INTO luo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kuom mano negiluongo Rebeka kendo gipenje niya, “Inyalo dhi gi ngʼatni?” Rebeka nodwokogi niya, “Abiro dhi.” ");
INSERT INTO luo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kuom mano ne giweyo Rebeka odhi kaachiel gi nyako mane opire kod jatich Ibrahim gi joge. ");
INSERT INTO luo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Kendo negigwedho Rebeka kagiwachone niya, “Nyathiwa, bed min ji gana gi gana; mad nyikwayi medre ma kaw mier madongo mag wasikgi.” ");
INSERT INTO luo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Eka Rebeka kod jotije ma nyiri noikore moidho ngamia-gi mi gidhi gi jatich Ibrahim. Kuom mano jatich Ibrahim nokawo Rebeka kendo gidhi. ");
INSERT INTO luo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Noyudo ka koro Isaka oa Beer-Lahai-Roi, nikech noyudo odak Negev. ");
INSERT INTO luo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ka noyudo owuotho e pap godhiambo chiengʼ moro ka owuoyo gi Nyasaye, kendo kane orango malo, noneno ngamia kabiro. ");
INSERT INTO luo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka bende norango malo moneno Isaka. Nolor piny koa ewi ngamia ");
INSERT INTO luo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","kendo nopenjo jatich Ibrahim niya, “Macha en ngʼa manie pap mabiro romonwa cha?” Jatich nodwoke niya, “En ruodha.” Eka nokawo nanga ma oumogo wangʼe. ");
INSERT INTO luo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Eka jatich nonyiso Isaka gik moko duto mane osetimo. ");
INSERT INTO luo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaka notero Rebeka e hemb Sara min-gi, kendo Isaka nokendo Rebeka. Kuom mano Rebeka nobedo chi Isaka, kendo Isaka nohero Rebeka gihera mamalo; kendo Isaka ne ok obedo gi parruok bangʼ tho min mare. ");
INSERT INTO luo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrahim nokendo dhako machielo mane nyinge Ketura. ");
INSERT INTO luo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura nonywolone Ibrahim, Zimran, Jokshan, Medan, Midian, Ishbak kod Shua. ");
INSERT INTO luo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan nonywolo Sheba kod Dedan; nyikwa Dedan ne gin jo-Ashur, jo-Letush kod jo-Leum. ");
INSERT INTO luo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian nonywolo Efa, Efer, Hanok, Abida kod Elda. Magi duto ne gin nyikwa Ketura. ");
INSERT INTO luo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahim nomiyo Isaka mwandune duto mane en-go. ");
INSERT INTO luo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","To kane pod ongima, nochiwo mich ne yawuot monde ma jotichge kendo nodarogi mondo gia kuom Isaka koterogi e piny man yo wuok chiengʼ. ");
INSERT INTO luo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ibrahim nodak kuom higni mia achiel gi piero abiriyo gabich ");
INSERT INTO luo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Eka Ibrahim notho koluwo kwerene ka en gi higni mathoth ka en ngʼama oti kendo hike ngʼeny. ");
INSERT INTO luo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Yawuot, Isaka kod Ishmael noyike e rogo man Makpela machiegni gi Mamre e puoth Efron ma wuod Zohar ja-Hiti, ");
INSERT INTO luo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ma en puodho ma Ibrahim nongʼiewo kuom jo-Hiti. Kanyo ema Ibrahim gi Sara chiege noyikie. ");
INSERT INTO luo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Bangʼ tho Ibrahim, Nyasaye nogwedho wuode Isaka, mane kindeno odak Beer-Lahai-Roi. ");
INSERT INTO luo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ma e nonro mar Ishmael wuod Ibrahim mane Hagar jatich Sara ma nyar Misri onywolone. ");
INSERT INTO luo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Magi e nying yawuot Ishmael kaluwore gi nywolgi: Nebayoth, wuod Ishmael makayo, Kedar, Adbel, Mibsam, ");
INSERT INTO luo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Masa, ");
INSERT INTO luo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafish kod Kedema. ");
INSERT INTO luo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Magi e nying yawuot Ishmael ma nying-gi nochak miechgi kod kuonde mane gibworoe, ne gin ruodhi apar gariyo ngʼato ka ngʼato gi ogandane. ");
INSERT INTO luo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael nodak kuom higni mia achiel kod piero adek gabiriyo. Eka notho kendo oluwo kwerene. ");
INSERT INTO luo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Nyikwaye nodak e gwengʼ manie kind Havila nyaka Shur, machiegni gi tongʼ Misri kochomo yo Ashur kendo negidak kagimonre gowetene. ");
INSERT INTO luo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Mae nonro Isaka wuod Ibrahim. Ibrahim nonywolo Isaka, ");
INSERT INTO luo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","kendo Isaka ne ja-higni piero angʼwen kane okendo Rebeka nyar Bethuel ja-Aram mane odak e piny Padan Aram, kendo ma nyamin Laban. ");
INSERT INTO luo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaka nolamo Jehova Nyasaye ne chiege, nikech en migumba. Jehova Nyasaye nodwoko lamone, kendo chiege Rebeka nomako ich. ");
INSERT INTO luo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Nyithindo ne olarore e iye mi nowacho niya, “Angʼo momiyo ma timorena?” Omiyo nodhi mondo openj Jehova Nyasaye wachni. ");
INSERT INTO luo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Jehova Nyasaye nowacho niya, “Ogendini ariyo ni e iyi, kendo ogendini ariyogo biro pogore; oganda moro biro bedo motegno moloyo machielo kendo wuowi maduongʼ noti ne wuowi matin.” ");
INSERT INTO luo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kane kinde mar nywol ochopo, to ne nitie rude ma yawuowi e iye. ");
INSERT INTO luo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mano mane okwongo wuok ne kwar, kendo dende duto ne chalo motimo yier; kuom mano negichake ni Esau. ");
INSERT INTO luo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Bangʼ ma owadgi nowuok kod lwete komako ofunj tiend Esau; kuom mano negichako Jakobo. Isaka ne ja-higni piero auchiel kane Rebeka onywolo yawuowigo. ");
INSERT INTO luo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Yawuowigo nodongo, kendo Esau nobedo jadwar molony, ngʼat ma jathim, to Jakobo to ne ngʼama muol madak ei hema. ");
INSERT INTO luo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaka ma nohero ring le nohero Esau to Rebeka nohero Jakobo. ");
INSERT INTO luo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Chiengʼ moro kane Jakobo tedo ogira, Esau nodonjo koa e dwar kodenyo. ");
INSERT INTO luo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau nowacho ne Jakobo niya, “Asayi miya ogira makwarno adenyo!” (Mano emomiyo bende iluonge ni Edom.) ");
INSERT INTO luo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jakobo nodwoke niya, “Kuong iusna duongʼni mar nywol.” ");
INSERT INTO luo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau nowachone niya, “Ne achiegni tho. Ere ohala ma ayudo kuom duongʼ mar nywolna?” ");
INSERT INTO luo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","To Jakobo nowachone niya, “Kwongʼrina mokwongo.” Kuom mano Esau nokwongʼore ne Jakobo, ma ousone duongʼne mar nywol. ");
INSERT INTO luo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Eka Jakobo nomiyo Esau kuon gi ogich ngʼor. Nochiemo kendo ometho, eka ne ochungʼ mi odhi. Kuom mano Esau, nojwangʼo duongʼne mar nywol. ");
INSERT INTO luo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Koro ne nitie kech maduongʼ e piny; bangʼ kech mokwongo mane obedo e ndalo Ibrahim kendo Isaka nodhi Gerar ir Abimelek ruodh jo-Filistia. ");
INSERT INTO luo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Jehova Nyasaye nofwenyore ni Isaka kendo owachone niya, “Kik idhi Misri; to dag mana e piny kama abiro nyisi. ");
INSERT INTO luo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Dag kae matin, kendo abiro bedo kodi mi agwedhi. Nimar in kod nyikwayi abiro miyou pinyni kendo nachop singruok mane atimo gi wuonu Ibrahim. ");
INSERT INTO luo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Anami nyikwayi bed mangʼeny ka sulwe mae polo kendo abiro miyogi pinyni duto, kendo kokadho kuom nyikwayi, ogendini duto mag pinyni nogwedhi. ");
INSERT INTO luo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Anagwedhgi kamano nikech Ibrahim noluora kendo norito dwarona, chikena, buchena kod wechena.” ");
INSERT INTO luo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kuom mano Isaka nomedo dak Gerar. ");
INSERT INTO luo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kane jo-Gerar openje kuom chiege, nowachonegi niya, “En nyamera, nikech noluoro wachonegi ni en chiega. Nowachonegi kamano nikech noparo ni jo-Gerar nyalo nege nikech Rebeka ne en dhako ma jaber.” ");
INSERT INTO luo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Kane Isaka osedak kuno kuom kinde mangʼeny, Abimelek ruodh jo-Filistia nongʼicho gie dirisa moneno ka Isaka gi Rebeka chiege jotugo. ");
INSERT INTO luo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kuom mano Abimelek noluongo Isaka mopenje niya, “Kwerie ka dhakoni ok chiegi! Angʼo ma omiyo niwacho, ‘Ni en nyaminu’?” Isaka nodwoke niya, “Nikech ne aparo ni anyalo wito ngimana nikech en.” ");
INSERT INTO luo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Eka Abimelek nowacho niya, “Ma en angʼo ma itimonwa ni? Ka dipo ni ngʼatwa moro dine oseriwore gi chiegi, donge dikelonwa richo maduongʼ.” ");
INSERT INTO luo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Omiyo Abimelek nogolo chik ne ji duto niya, “Ngʼato angʼata ma omulo ngʼatni kata chiege to nyaka negi.” ");
INSERT INTO luo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaka nopidho cham e pinyno kendo Jehova Nyasaye nogwedhe e higano moyudo cham moloyo manochwoyo nyadi mia achiel. ");
INSERT INTO luo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isaka nomedo bedo gi mwandu ahinya kendo mwandune nomedore mobedo jamoko marahuma. ");
INSERT INTO luo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ne en kod pith mag jamni kod pith mag dhok kod jotich mangʼeny mi nyiego nomako jo-Filistia kode. ");
INSERT INTO luo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Omiyo jo-Filistia nodino sokni mane wasumbini Ibrahim wuon Isaka okunyo. ");
INSERT INTO luo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Eka Abimelek nowacho ne Isaka niya, “Dar ia ira ka nikech in giteko moloyowa.” ");
INSERT INTO luo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Omiyo Isaka nodar kanyo modhi e Holo mar Gerar kendo nodak kanyo. ");
INSERT INTO luo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaka nochako oyawo sokni mane osekuny e ndalo Ibrahim wuon mare, mane jo-Filistia odino bangʼ tho Ibrahim, kendo nochakogi nying mane oyudo wuon-gi Ibrahim osechakogi chon. ");
INSERT INTO luo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Jotich Isaka nokunyo holo kendo negiyudo soko man-gi pi machwer maliw. ");
INSERT INTO luo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","To jokwath mag Gerar nolaro pig-no gi jokwadh Isaka kagiwacho niya, “Pigni en marwa.” Kuom mano Isaka nochako sokono ni Esek (tiende ni kar dhawo) nikech ne gilare kode ");
INSERT INTO luo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Eka jotich Isaka nokunyo soko moro kendo, to ne gilarore kuom mano bende; kuom mano nochake ni Sitna (tiende ni sadha). ");
INSERT INTO luo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Nodar kanyo modhi kendo odhi okunyo soko machielo, kendo onge ngʼama nolaro kode. Nochake ni Rehoboth (tiende ni thuolo moromowa), kowacho niya, “Koro Jehova Nyasaye osemiyowa thuolo kendo wabiro medore e piny.” ");
INSERT INTO luo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Noa kuno modhi nyaka Bersheba, ");
INSERT INTO luo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Jehova Nyasaye nofwenyore ne gotieno mowachone niya, “An e Nyasach wuonu Ibrahim. Kik iluor nikech an kodi; abiro gwedhi kendo abiro medo nyikwayi nikech singruok mane atimo gi Ibrahim jatichna.” ");
INSERT INTO luo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaka nogero kendo mar misango kuno kendo noluongo nying Jehova Nyasaye. Nogero hembe kanyo mi jotichne nokunyo soko moro kanyo. ");
INSERT INTO luo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Eka Abimelek nobiro ire koa Gerar, ka gin gi Ahuzath jangʼadne rieko kod Fikol ma jatend jolwenje. ");
INSERT INTO luo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaka nopenjogi niya, “Angʼo momiyo ubiro ira to ne ok udwara mi uriemba?” ");
INSERT INTO luo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Negidwoke niya, “Koro wasefwenyo ratiro ni Jehova Nyasaye neni kodi, omiyo wadwaro mondo watim kodi winjruok kwakwongʼore. Yie watim winjruok kodi ");
INSERT INTO luo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ni ok initimnwa marach mana kaka wan bende ne ok watimoni marach to ne wariti maber mi wagoli gi kwe mondo idhi. To koro Jehova Nyasaye osegwedhi.” ");
INSERT INTO luo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kuom mano Isaka nolosonegi nyasi mi gichiemo kendo gimetho. ");
INSERT INTO luo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kinyne gokinyi mangʼich negisingore ka gikwongʼore ngʼato gi ngʼato. Eka Isaka nogonyogi ma gidhi gi kwe. ");
INSERT INTO luo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Chiengʼ onogo jotich Isaka nobiro ire monyise kuom soko mane gisekunyo. Negiwachone niya, “Waseyudo pi!” ");
INSERT INTO luo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Noluongo kanyo ni Shiba (tiende ni kar singruok) nyaka chil kawuono dalano osebed kiluongo ni Bersheba. ");
INSERT INTO luo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Kane Esau ja-higni piero angʼwen, nokendo Judith nyar Beeri ma ja-Hiti, kod Basemath nyar Elon ma ja-Hiti. ");
INSERT INTO luo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Mon-go nomiyo Isaka kod Rebeka chuny lit. ");
INSERT INTO luo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Kane Isaka oseti kendo wengene noseimore makoro ok nyal neno, noluongo Esau wuode makayo kendo owachone niya, “Wuoda.” Eka Esau nodwoke niya, “An ka.” ");
INSERT INTO luo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaka nowacho niya, “Koro asedoko moti kendo ok angʼeyo ndalo thona. ");
INSERT INTO luo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Omiyo koro sani kaw gigi mag lweny kaka atungʼ kod asere kendo idhi e thim ikelna ring le. ");
INSERT INTO luo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Tedna ringʼo mamit mana kaka ahero cha kendo ikelna mondo acham mondo mi amiyi gwethna kapok atho.” ");
INSERT INTO luo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","To Rebeka nochiko ite ka Isaka wuoyo gi wuode Esau. Kane Esau osewuok odhi e thim mondo odhi oneg le kendo okel, ");
INSERT INTO luo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka nowacho ne Jakobo wuode niya, “Nawinjo ka wuonu wacho ni owadu Esau niya, ");
INSERT INTO luo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Kelna ring le kendo ilosna mamit mondo acham mondo agwedhi e nyim Jehova Nyasaye kapok atho.’ ");
INSERT INTO luo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Koro wuoda chik iti malongʼo kendo tim gima awachoni. ");
INSERT INTO luo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Dhiyo e kweth mag jamni kendo ikelna nyidiek ariyo mopugno, mondo mi atedne wuonu ringʼo mamit kaka ohero-cha. ");
INSERT INTO luo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Bangʼ mano iterne wuonu mondo ocham bangʼe ogwedhi kapok otho.” ");
INSERT INTO luo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakobo nowacho ne Rebeka min mare niya, “Esau omera en ngʼat ma rayier an to an gi del mapoth ");
INSERT INTO luo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Datim nangʼo ka diponi wuora omula? Donge abiro nenora ngʼama wuonde kendo biro kelona kwongʼ kar gweth.” ");
INSERT INTO luo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Min Jakobo nonyise niya, “Wuoda, we mondo kwongʼno omaka, in to tim mana gima awacho; dhiyo kendo ikelnagi.” ");
INSERT INTO luo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Omiyo Jakobo nodhi mokelo nyidiek mopugno ne min mare kendo noloso chiemo mamit mana kaka wuon-gi ohero. ");
INSERT INTO luo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Eka Rebeka nokawo lewni mabeyo mag Esau wuode maduongʼ mane oyudo en-go e ot kendo ne orwako ne Jakobo wuode matin. ");
INSERT INTO luo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Kendo Rebeka nokawo piende diego moumogo bede Jakobo kod ngʼute kuonde maonge yier. ");
INSERT INTO luo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Eka nomiyo Jakobo wuode chiemo molos mamit kod kuon mane osetedo. ");
INSERT INTO luo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jakobo nodhi ir wuon mare kendo owachone niya, “Wuora.” Eka Isaka nopenje niya, “Wuoda, to in ngʼa?” ");
INSERT INTO luo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakobo nodwoko wuon mare niya, “An Esau wuodi makayo. Asetimo kaka ne inyisa. Yie ia malo ibed piny kendo icham ring le ma akeloni mondo mi igwedha.” ");
INSERT INTO luo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaka nopenje niya, “To ne iyude piyo nade wuoda?” Nodwoke niya, “Jehova Nyasaye ma Nyasaye nogwedha.” ");
INSERT INTO luo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Eka Isaka nowacho ne Jakobo niya, “Sud machiegni mondo mi amuli, wuoda, mondo mi angʼe adier ka in wuoda Esau koso.” ");
INSERT INTO luo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakobo nobedo machiegni gi wuon mare Isaka, mano mule kendo owachone niya, “Dwol to mar Jakobo, to lwedo to gin lwet Esau.” ");
INSERT INTO luo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaka ne ok nyal fwenye nikech lwetene ne rayier ka mag Esau owadgi, kuom mano nogwedhe. ");
INSERT INTO luo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“Bende in wuoda ma Esau adier?” Isaka nopenje. Eka Jakobo nodwoke ni, “Ee en an.” ");
INSERT INTO luo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Eka nowacho niya, “Wuoda, koro kelna ring le mondo acham, mondo mi agwedhi.” Jakobo nokelone ringʼo mi ochamo bende nokelone divai mi omadho. ");
INSERT INTO luo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Eka Isaka wuon mare nowachone niya, “Bi ka wuoda mondo inyodha.” ");
INSERT INTO luo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kuom mano nodhi ire ma onyodhe. Kane Isaka owinjo tik lepe, nogwedhe kendo owachone niya, “Ee, tik mar wuoda dungʼ mamit machalo gi tik mar puodho, ma Jehova Nyasaye osegwedho. ");
INSERT INTO luo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mad Nyasaye miyi koth moa e polo kod piny ma omewo kod cham mogundho, kod divai manyien. ");
INSERT INTO luo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Mad oganda duto bed jotichni kendo ji duto omiyi duongʼ. Bed ruoth ewi oweteni duto kendo mad yawuot minu omiyi duongʼ. Ngʼato angʼata mokwedi mondo okwede kendo ngʼato angʼata mogwedhi nogwedhi.” ");
INSERT INTO luo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Bangʼ ka Isaka nosetieko gwedho Jakobo kendo Jakobo ne pok odhi mabor, to gikanyono Esau nochopo koa dwar. ");
INSERT INTO luo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","En bende noloso chiemo mamit kendo nokelo ne wuon mare. Eka Esau nowacho ne wuon mare niya, “Wuora, aa malo ibed piny mondo mi icham ringʼo malosoni kendo igwedha.” ");
INSERT INTO luo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaka wuon-gi nopenjo niya, “In ngʼa?” Nodwoke niya, “An Esau, wuodi makayo.” ");
INSERT INTO luo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaka nobwok matek ahinya kendo owacho niya, “To kara macha ne en ngʼa, mane onego le kendo okelona? Nende achamo ringʼono kapok ibiro kendo agwedhe; kendo kuom adier asegwedhe.” ");
INSERT INTO luo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Kane Esau owinjo weche wuon mare, noywak malit ka en-gi mirima mager kowachone wuon mare niya, “Wuora, gwedha an bende!” ");
INSERT INTO luo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","To nowachone niya, “Owadu nobiro mowuonda mi okawo gwethni.” ");
INSERT INTO luo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau nowacho niya, “Kara ma emomiyo nochake ni Jakobo? Osewuonda koro nyadiriyo: Nokawo duongʼ mar nywolna kendo koro okawo gwethna!” Eka Esau nopenjo wuon mare niya, “Bende gweth moro didongʼna?” ");
INSERT INTO luo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaka nodwoko Esau niya, “Asekete ruodhi kendo wedene duto aseketo obed jotichne bende asegwedhe gi cham kod divai. Koro ere gima anyalo timoni wuoda?” ");
INSERT INTO luo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau nowacho ne wuon mare niya, “In mana kod gweth achiel kende wuora? Yie igwedha an bende!” Eka Esau noywak matek gi dwol maduongʼ. ");
INSERT INTO luo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Wuon mare Isaka nodwoke niya, “Inidag e piny maonge mwandu, kendo motwo ma ok yud koth. ");
INSERT INTO luo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ligangla ema nomiyi chiemo kendo inibed jatij owadu. To ka iyudo loch to iningʼanyne, kendo nia e bwo lochne.” ");
INSERT INTO luo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau nomako sadha gi Jakobo nikech gweth mane wuon-gi osemiyo Jakobo. Nowacho e chunye niya, “ndalo mag tho wuora chiegni, bangʼe abiro nego Jakobo owadwa.” ");
INSERT INTO luo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Kane Rebeka onyisi gima Esau wuode makayo paro timo, noluongo Jakobo wuode ma chogo kendo owachone niya, “Esau owadu nigi paro mar negi.” ");
INSERT INTO luo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Koro wuoda, tim gima awachoni: Ring idhi Haran ir Laban owadwa. ");
INSERT INTO luo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Dak kode kuno mondi nyaka mirimb owadu dog chien. ");
INSERT INTO luo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ka mirimb owadu oserumo kuomi kendo wiye osewil gi gima ne itimone, to abiro oroni wach mondo iduog ia kuno. Ere gima omiyo yawuota ariyo ditho odiechiengʼ achiel? ");
INSERT INTO luo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Eka Rebeka nowacho ne Isaka niya, “ajok gi ngima nikech nyi jo-Hiti-gi. Ka Jakobo bende nyalo kawo dhako mana kuom nyi jo-Hiti-gi, to owinjore atho.” ");
INSERT INTO luo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kuom mano Isaka noluongo Jakobo mogwedhe kendo osieme konyise niya, “Kik ikend nyar jo-Kanaan. ");
INSERT INTO luo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Chak wuoth idhi Padan Aram, e od Bethuel ma kwaru. Kend achiel kuom nyi Laban ma neru. ");
INSERT INTO luo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mad Nyasaye Maratego gwedhi kendo inyaa mi kwanu medre nyaka ubed oganda mathoth. ");
INSERT INTO luo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Mad ogwedhi kod nyikwayi kaka nogwedho Ibrahim mondo ikaw piny makoro idakieni kaka jadak, ma en piny mane Nyasaye omiyo Ibrahim.” ");
INSERT INTO luo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Eka Isaka nogolo Jakobo modhi kendo Jakobo nodhi Padan Aram, ir Laban wuod Bethuel ja-Aram, owad gi Rebeka, mane min Jakobo kod Esau. ");
INSERT INTO luo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Koro Esau nofwenyo ni Isaka osegwedho Jakobo kendo oseore Padan Aram mondo odhi okend kuno. Nowinjo bende ni kane Isaka gwedho Jakobo, nochike niya, “Kik ikend nyar jo-Kanaan.” ");
INSERT INTO luo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Mi Jakobo nowinjo wach min gi wuon modhi Padan Aram. ");
INSERT INTO luo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau nofwenyo kaka Isaka wuon mare ne ok mor gi nyi jo-Kanaan. ");
INSERT INTO luo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Kuom mano Esau nodhi ir Ishmael mi okendo Mahalath nyamin Nebayoth mane nyar Ishmael wuod Ibrahim, mondo obed chiege ewi monde mane okwongo kendo. ");
INSERT INTO luo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakobo nowuok Bersheba kendo nodhi Haran. ");
INSERT INTO luo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kane ochopo kamoro, nobworo gotieno nikech chiengʼ nosepodho. Nonindo kanyo moteno wiye gi kidi moro mane okwanyo kanyo. ");
INSERT INTO luo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Noleko ni oneno ngas konyono piny to wiye ochopo e polo kendo malaika mag Nyasaye ne luwe kadhi malo kendo lor piny. ");
INSERT INTO luo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","To ewi ngasno gi malo Jehova Nyasaye nochungʼie kawacho niya, “An Jehova Nyasaye Nyasach wuonu Ibrahim kendo Nyasach Isaka. Piny minindoeni abiro miyi gi nyikwayi. ");
INSERT INTO luo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nyikwayi nobed mangʼeny ka kwoyo, kendo unudag koa yo podho chiengʼ nyaka wuok chiengʼ, bende koa yo nyandwat nyaka yo milambo. Ogendini duto manie piny nogwedh kokadho kuomi kod nyikwayi. ");
INSERT INTO luo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Anabed kodi kendo anariti kamoro amora ma idhiye nyaka adwoki e pinyni. Ok anaweyi nyaka chop atim mana ma asesingorani.” ");
INSERT INTO luo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kane Jakobo ochiewo oa e nindo, noparo niya, “Adier Jehova Nyasaye nika kendo ne ok angʼeyo.” ");
INSERT INTO luo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Luoro nomake mi owacho niya, “Ma kama lich manade! Nyaka bedni ma en od Nyasaye; ma en dhoranga polo.” ");
INSERT INTO luo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kinyne gokinyi mangʼich Jakobo nokawo kidi mane otenogo wiye kendo nochunge ka siro mi oolo mo e wiye. ");
INSERT INTO luo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Nochako kanyo ni Bethel to kinde mokwongo nying dalano niluongo ni Luz. ");
INSERT INTO luo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Eka Jakobo nokwongʼore kawacho niya, “Ka Nyasaye nobed koda kendo norita e wuodhani ma adhiye kendo miya chiemo ma achamo kod lewni ma arwako, ");
INSERT INTO luo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","mi anadogi maber e od wuora eka Jehova Nyasaye nobed Nyasacha, ");
INSERT INTO luo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","kendo kidi ma asechungo kaka sironi, nobed od Nyasaye kendo duto ma imiya, namiyi achiel kuom apar.” ");
INSERT INTO luo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Eka Jakobo nodhi nyime gi wuoth kendo nochopo e piny ogendini man yo wuok chiengʼ. ");
INSERT INTO luo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Nopo koneno soko ei pap kod kweth adek mag rombe konindo machiegni kanyo nikech kwethgo ne modho e sokono. To kidi mane nitie e dho sokono ne duongʼ. ");
INSERT INTO luo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Jokwath nengʼielo kidi kane jamni osechokore kanyo mondo gimodhi. Bangʼ ka jamni duto osemodho, to ne gingʼielo kidino mondo odog oum dho soko. ");
INSERT INTO luo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakobo nopenjo jokwath niya, “Owetena ua kanye?” Negidwoke niya, “Waa Haran.” ");
INSERT INTO luo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Nowachonegi niya, “Bende ungʼeyo Laban nyakwar Nahor?” Negidwoke niya, “Ee, wangʼeye.” ");
INSERT INTO luo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Eka Jakobo nopenjogi niya, “Ongima?” Negidwoke niya, “Ee, ongima, kendo mabiro gi rombe cha en Rael ma nyare.” ");
INSERT INTO luo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Nowachonegi niya, “Neuru, piny pod chon, sa michokoe jamni podi. Weuru rombe omodhi bangʼe uduokgi e lek.” ");
INSERT INTO luo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Negidwoke niya, “Ok wanyal timo kamano kapok jokwath duto ochokore ma wangʼielo kidi manie dho soko oko mondo jamni omodhi.” ");
INSERT INTO luo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Kane pod oyudo owuoyo kodgi, Rael nochopo gi romb wuon-gi nikech en ema nokwayogi. ");
INSERT INTO luo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kane Jakobo oneno Rael, nyar Laban ner mare kod romb Laban, nodhi mongʼielo kidi oko e dho soko kendo omiyo romb ner mare omodho. ");
INSERT INTO luo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Eka Jakobo nonyodho Rael kendo noywak gi dwol maduongʼ. ");
INSERT INTO luo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Noyudo osenyiso Rael ni en wat wuon Rael kendo ni en wuod Rebeka. Kuom mano Rael nodhi monyiso wuon mare. ");
INSERT INTO luo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","To kane Laban owinjo wach mar Jakobo, wuod nyamin noringo mondo odhi oromne. Nokwake kendo omose gimor mi orwake dalane kendo Jakobo nonyise gik moko duto. ");
INSERT INTO luo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Eka Laban nowachone niya, “In ringra awuon kendo remba.” Kane Jakobo ne osedak kod Laban kuom dwe achiel, ");
INSERT INTO luo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban nowachone niya, “Mana nikech in watna, bende en gima ber tiyona maonge chudo? Nyisa gima dachul.” ");
INSERT INTO luo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","To Laban ne nigi nyiri ariyo: nyako maduongʼ ne nyinge Lea kendo nyako matin ne nyinge Rael. ");
INSERT INTO luo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea ne nigi wangʼ ma ok nenre maber, to Rael ne nigi chia kendo jaber. ");
INSERT INTO luo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakobo nohero Rael, kendo nowacho ni Laban niya, “Abiro tiyoni kuom higni abiriyo kuom Rael nyari matin.” ");
INSERT INTO luo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban nowacho niya, “Ber mondo amiyi godo moloyo chiwe ni jomoko. Koro dag mana koda ka.” ");
INSERT INTO luo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Omiyo Jakobo notiyone Laban higni abiriyo mondo oyud Rael, to hignigo nonenorene mana ka ndalo matin nikech hera manoherogo Rael. ");
INSERT INTO luo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Eka Jakobo nowacho ne Laban, “Asetieko ndalo mane iketona, omiyo koro miya nyari mondo obed chiega.” ");
INSERT INTO luo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kuom mano Laban noloso nyasi kendo nogwelo ji duto mae pinyno. ");
INSERT INTO luo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","To kane ochopo odhiambo, Laban nokawo nyare ma Lea mi omiyo Jakobo mondo obed chiege. ");
INSERT INTO luo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Kendo Laban nochiwo Zilpa jatichne ma nyako ne nyare, Lea, mondo obed jatichne. ");
INSERT INTO luo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kane piny oru, Jakobo nofwenyo mana ni en Lea! Omiyo nopenjo Laban niya, “Angʼo momiyo isetimona kama? Donge natiyoni mondo imiya Rael? To angʼo momiyo isewuonda?” ");
INSERT INTO luo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban nodwoke niya, “Ok en timwa mondo nyako matin okuong odhi tedo ne nyako maduongʼ. ");
INSERT INTO luo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Rit nyaka watiek juma achiel mar nyasi mar nyakoni; eka abiro miyi Rael kiyie tiyona kuom higni abiriyo mamoko.” ");
INSERT INTO luo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Kendo Jakobo notimo kamano. Notieko jumb kend mar Lea. Eka Laban nomiye Rael nyare mondo obed chiege. ");
INSERT INTO luo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban nochiwo Bilha jatichne ma nyako ne Rael nyare kaka jatichne. ");
INSERT INTO luo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jakobo nobedoe achiel gi Rael bende kendo nohero Rael moloyo Lea. Kendo notiyone Laban higni abiriyo moko kendo. ");
INSERT INTO luo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Kane Jehova Nyasaye oneno ni Lea ne ok oher, ne oyawo iye to Rael noketo obedo migumba. ");
INSERT INTO luo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea nomako ich kendo nonywolo wuowi. Nowacho niya, “Jehova Nyasaye oseneno chandruokna, kendo koro chwora biro hera.” Omiyo nochake ni Reuben. ");
INSERT INTO luo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Nochako omako ich, monywolo wuowi moro. Nowacho niya, “Jehova Nyasaye osemiya wuowi machielo nimar nowinjo ka chwora ok ohera.” Omiyo nochake ni Simeon. ");
INSERT INTO luo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nochako omako ich, kendo ochako onywolo wuowi. Nowacho niya, “Koro chwora biro padore kuoma nikech asenywolone yawuowi adek.” Omiyo nochake ni Lawi. ");
INSERT INTO luo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nochako omako ich, kendo kane ochako onywolo wuowi nowacho niya, “Koro abiro pako Jehova Nyasaye.” Omiyo nochake ni Juda. Bangʼ mano noweyo nywolo nyithindo. ");
INSERT INTO luo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Kane Rael oneno nine ok nywolne Jakobo nyithindo, nyiego nomake gi nyamin mare. Kuom mano nowacho ne Jakobo niya, “Miya nyithindo, nono to abiro tho!” ");
INSERT INTO luo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakobo nokecho gi Rael kendo nowachone niya, “Iparo ni an e Nyasaye mosetami nywolo nyithindo?” ");
INSERT INTO luo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Eka Rael nowacho ne Jakobo niya, “Eri amiyi Bilha ma jatichna ma nyako. Kawe ibed kode e achiel mondo mi onywolna nyithindo mondo omi kokadho kuome an bende abed gi joga.” ");
INSERT INTO luo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Omiyo nomiye Bilha jatichne obedo chiege. Jakobo nobedo kode achiel, ");
INSERT INTO luo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","mi Bilha nomako ich kendo nonywolone Jakobo wuowi. ");
INSERT INTO luo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Eka Rael nowacho niya, “Nyasaye osengʼadona bura; osewinjo kwayona mi omiya nyathi ma wuowi.” Omiyo nochake ni Dan. ");
INSERT INTO luo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha ma jatich Rael nochako omako ich kendo nonywolo ne Jakobo wuowi mar ariyo. ");
INSERT INTO luo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Eka Rael nowacho niya, “Asebedo gi chandruok maduongʼ gi nyamera, kendo koro aseloyo.” Omiyo nochako nyathini ni Naftali. ");
INSERT INTO luo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Kane Lea ofwenyo ni ok onyal nywolo nyithindo kendo nokawo Zilpa jatichne ma nyako, nomiye Jakobo mondo okawe kaka chiege. ");
INSERT INTO luo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa ma jatich Lea nonywolo ne Jakobo wuowi. ");
INSERT INTO luo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Eka Lea nowacho niya, “An jahawi.” Omiyo nochako nyathino ni Gad. ");
INSERT INTO luo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa jatich Lea nonywolo ne Jakobo wuowi mar ariyo. ");
INSERT INTO luo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Eka Lea nowacho niya, “Amor manade! Mon biro luonga ni jahawi.” Omiyo nochake ni Asher. ");
INSERT INTO luo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","E ndalo kayo ngano, Reuben nodhi e puothe kendo noyudo olembe mag mandrake, mi nokelo ne Lea min mare. Rael nowacho ne Lea niya, “Kiyie to miya olemb mandrake ma wuodi Reuben okelonino.” ");
INSERT INTO luo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","To nowachone niya, “Iparo ni kawo chwora en gima tin koso? Kendo pod idwaroe mandrake mag wuoda bende?” Rael nodwoke niya, “Mano ber, to kimiya mandrake mar wuodi to Jakobo wangʼ nonindo e odi kawuono otieno.” ");
INSERT INTO luo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kane Jakobo odwogo koa e puodho godhiambono, Lea nodhi moromone. Lea nowachone niya, “Nyaka ibed koda e achiel kawuono, nikech asechulo nengo mar nindoni e oda gi mandrake mar wuoda.” Kuom mano Jakobo nobedoe achiel gi Lea otienono. ");
INSERT INTO luo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nyasaye nowinjo Lea kendo Lea nomako ich mi onywolone Jakobo wuowi mar abich. ");
INSERT INTO luo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Eka Lea nowacho niya, “Nyasaye osemiya pokna nikech nachiwo jatichna ma nyako ne chwora, omiyo nochake ni Isakar.” ");
INSERT INTO luo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea nochako omako ich kendo nonywolone Jakobo wuowi mar auchiel. ");
INSERT INTO luo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Eka Lea nowacho niya, “Nyasaye osedhiala gi mich ma nyangafu. Koro chwora biro gena nikech asenywolone yawuowi auchiel.” Omiyo nachake ni Zebulun. ");
INSERT INTO luo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Bangʼ kinde moko nonywolo nyako kendo nochake ni Dina. ");
INSERT INTO luo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Eka Nyasaye noparo Rael, mi odwoko kwayone kendo ogwedhe gi nyathi. ");
INSERT INTO luo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rael nomako ich kendo nonywolo wuowi kendo nowacho niya, “Nyasaye osegolona wichkuot.” ");
INSERT INTO luo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Nochako wuodeno ni Josef kendo owacho niya, “Mad Jehova Nyasaye meda wuowi machielo.” ");
INSERT INTO luo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Bangʼ ka Rael nosenywolo Josef, Jakobo nowacho ne Laban, “We adhi mondo adogi thurwa. ");
INSERT INTO luo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Miya monda kod nyithinda ma asebedo ka atiyonigo kendo weya adhi. Ingʼeyo tichna ma asetiyonigo.” ");
INSERT INTO luo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","To Laban nowachone niya, “Kapo ni ayudo ngʼwono e wangʼi to yie imed dak koda ka. Asefwenyo ma lingʼ-lingʼ ni Jehova Nyasaye osegwedha nikech in.” ");
INSERT INTO luo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Laban nomedo wachone niya, “Nyisa pok monego amiyi kendo abiro chuligi.” ");
INSERT INTO luo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakobo nowachone niya, “Ingʼeyo kaka asetiyoni kendo kaka aserito jambi. ");
INSERT INTO luo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Jamni matin mane in-go kapok abiro osemedore ahinya, kendo Jehova Nyasaye osegwedhi e gik moko duto ma asetimo. To koro anatine oda awuon karangʼo?” ");
INSERT INTO luo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban nopenje, “Angʼo ma damiyi.” Jakobo nodwoke niya, “Kik imiya gimoro amora. To ka ihero to timna gimoro achiel, abiro dhi nyime gi kwayo kendo rito jambi. ");
INSERT INTO luo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Kawuono abiro wuotho ei jambi duto kendo abiro walo diek gi rombe ma kitgi rabok kod mago ma angʼech gi mago maratengʼ. Magi ema nobed chudo maga. ");
INSERT INTO luo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Timna makare nobed janeno e ndalo mabiro kendo, e sa asaya ma ibiro rango pok ma isechula. Diel moro amora ma ok angʼech kata dibo kata nyarombo ma ok ratengʼ manoyud e kindgi nokwan ka gima okwal.” ");
INSERT INTO luo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban nodwoke niya, “Ayie, obed kaka iwachono.” ");
INSERT INTO luo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Odiechiengʼno Laban nowalo nywogi duto ma kitgi rabok kod mago ma angʼech, gi diek mamon (ma dikiyo) kod nyirombe marotenge mine oketogi e lwet yawuote mondo oritgi. ");
INSERT INTO luo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Eka Laban noketo thuolo e kinde gi Jakobo madirom wuodh ndalo adek Jakobo to ne odongʼ kakwayo romb Laban mane odongʼ. ");
INSERT INTO luo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kata kamano, Jakobo nokawo kete moko mag omburi, gi oyungu kod yiende makorgi poth mi nopoko kuonde moko e korgi mondo igi marachar onen. ");
INSERT INTO luo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Eka noketo ketego ei karaya kama ne jamnigo modhoe, mondo omi ka jamnigo modho to gineno ketego ei pi. E kindego ema thuondi ne luwogie, ");
INSERT INTO luo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","e nyim ketego. Kendo neginywolo nyithindo ma kitgi rabok kod mago ma angʼech gi mago maratengʼ. ");
INSERT INTO luo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jakobo nopogo imbe mi oweyo mana mago ma kitgi rabok kod mago ma angʼech gi mago maratengʼ mondo oluw romb Laban. Mano e yo mane omedogo kwan jambe owuon bende ne ok oriwogi gi mek Laban. ");
INSERT INTO luo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Sa asaya mane iluwo chiayo madhako, Jakobo ne keto ketego ei karaya mane gimodhoe mondo omi imbe oluwgi kanyo mi gimak ich, ");
INSERT INTO luo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","to jamni mayom yom ne ok oket ochungʼ e nyim ketego. Omiyo jamni mayom yom ne gin mag Laban to mago motegno ne gin mag Jakobo. ");
INSERT INTO luo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ma nomiyo mwandu Jakobo omedore piyo ahinya kendo nobedogi kweth mag jamni mangʼeny gi jotich mamon, machwo, kod ngamia gi punde. ");
INSERT INTO luo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jakobo nowinjo ni yawuot Laban ne wacho niya, “Jakobo osekawo gik ma wuonwa nigo duto kendo oseyudo mwandugi duto koa kuom wuonwa.” ");
INSERT INTO luo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Kendo Jakobo noneno ni pach Laban ok nikode kaka chon. ");
INSERT INTO luo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Eka Jehova Nyasaye nowacho ne Jakobo niya, “Dogi e pinyu ir oweteni kendo abiro bet kodi.” ");
INSERT INTO luo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kuom mano Jakobo nooro wach ne Rael kod Lea mondo gibi e lek kumane okwayoe. ");
INSERT INTO luo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Nowachonegi niya, “Aneno ni paro ma wuonu nigo koda ok en paro mane en-go mokwongo, kata kamano Nyasach wuora osebedo koda. ");
INSERT INTO luo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ungʼeyo kaka asetiyo ne wuonu gi tekra duto. ");
INSERT INTO luo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","To wuonu osewuonda ka oloko chudona nyadipar. To kata kamano, Nyasaye ok oseweyo otimona marach. ");
INSERT INTO luo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Wuonu nowacho ni, ‘Mago ma kitgi angʼech nobed pokni;’ eka jamni duto nonywolo mago ma kitgi angʼech kende, to bende kane owacho ni, ‘Mago ma kitgi rabok nobed pokni,’ eka jamni duto nonywolo mana mago ma kitgi rabok. ");
INSERT INTO luo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kuom mano Nyasaye osekawo kweth mag jamni mag wuonu kendo osemiyagi. ");
INSERT INTO luo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“E kinde mane jamni mathuondi dwaro luwo jamni mamon, naleko ni nywogi duto mane oluwo jamni mamon ne gin mago man-gi kido marabok gi mago man-gi kido marangʼech kod mago man-gi kido mopogore opogore. ");
INSERT INTO luo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Malaika mar Nyasaye noluonga e lek ni, ‘Jakobo.’ Eka nadwoke ni, ‘An ka.’ ");
INSERT INTO luo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Eka malaika nomedo wachona ni, ‘Tingʼ wangʼi kendo ineye kaka nywogi duto maluwo diek gin rabok, angʼech kod ma dikiyo, nimar aseneno gik moko duto ma Laban osebedo katimoni. ");
INSERT INTO luo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","An e Nyasaye mane ofwenyoreni Bethel kamane iwiroe siro gi mo kendo kama ne isingori kikwongʼori ne an. Koro wuogi ia e pinyni kendo idog thuru.’ ” ");
INSERT INTO luo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Eka Rael kod Lea nodwoke niya, “Bende pod wadongʼ gi pok moro amora e mwandu wuonwa? ");
INSERT INTO luo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Donge tinde okwanowa mana kaka jomoko nono? Ok en mana ni osechiwowa kende, to osechano nyaka mwandu duto mane okendwa. ");
INSERT INTO luo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Adier mwandu duto ma Nyasaye osegolo kuom wuonwa gin mawa kod nyithindwa. Omiyo tim gimoro amora ma Nyasaye osenyisi.” ");
INSERT INTO luo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Eka Jakobo nokawo nyithinde kod monde mi oketo ewi ngamia, ");
INSERT INTO luo_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","kendo nosembo jambe duto e nyime kaachiel gi gik moko duto mane osechoko e piny Padan Aram, mondo odhi ir Isaka wuon-gi e piny Kanaan. ");
INSERT INTO luo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kane Laban osedhi ngʼado yie rombe, Rael nokwalo nyiseche mag wuon-gi. ");
INSERT INTO luo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","To kata kamano, Jakobo nowuondo Laban ja-Aram ka ok onyise ni odok thurgi. ");
INSERT INTO luo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Kuom mano noringo gi mago mane en-go duto, kendo nongʼado Aora koluwo yo mochomo piny gode mag Gilead. ");
INSERT INTO luo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","E odiechiengʼ mar adek Laban nowinjo ni Jakobo osepondo modhi. ");
INSERT INTO luo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Nokawo wedene molawo Jakobo; kuom ndalo abiriyo; kendo nojuke e piny gode mag Gilead. ");
INSERT INTO luo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Eka Nyasaye nofwenyore ne Laban ja-Aram gotieno e lek mi owachone niya, “Ne ni ok iwachone Jakobo gimoro amora, maber kata marach.” ");
INSERT INTO luo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ka Laban nojuko Jakobo noyudo ka oseguro hembe e piny gode mag Gilead kendo mi en bende gi wedene noguro hembe kanyo. ");
INSERT INTO luo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Eka Laban nopenjo Jakobo niya, “En angʼo ma isetimoni? Isewuonda kendo iseringa gi nyiga mana ka joma omak e lweny. ");
INSERT INTO luo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ere gima nomiyo iringo lingʼ-lingʼ ka akia? Angʼo ma nomoni nyisa, mondo omi asewi gi mor kiwerni kendo igoni thum? ");
INSERT INTO luo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Bende ne ok iweyo agoyoni oriti gi nyiga gi nyikwaya. Kuom mano isetimo gima ofuwo. ");
INSERT INTO luo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ngʼe ni an-gi teko mar hinyi, to Nyasach wuonu ne onyisa otieno manyoro ni, ‘Ne ni ok iwachone Jakobo gimoro amora, maber kata marach.’ ");
INSERT INTO luo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Angʼeyo ni nyoro iwuok nikech siso ma in-go mar dok ir joodu. To angʼo momiyo nyoro ikwalo nyisechena?” ");
INSERT INTO luo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakobo nodwoko Laban niya, “Ne aluor nikech nyo aparo ni dipo ka imaya nyigi githuon. ");
INSERT INTO luo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","To ngʼato angʼata ma iyudo gi nyisechegi ok nokwo. E nyim jowagi, rang in iwuon giri moro amora madabedgo kendo ka iyudo to kaw.” To Jakobo ne ok ongʼeyo ni Rael nosekwalo nyisechego. ");
INSERT INTO luo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Eka Laban nodonjo ei hemb Jakobo kendo ei hemb Lea kendo ei hemb jotichgi ariyo ma nyiri to ne ok oyudo gimoro. Bangʼ kane osea ei hemb Lea nodonjo ei hemb Rael. ");
INSERT INTO luo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Noyudo ka Rael osekawo nyisechego mopando e bwo kom ngamia mobetie. Laban nodwaro gik moko duto mane ni ei hema to ne ok oyudo gimoro. ");
INSERT INTO luo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rael nowacho ni wuon-gi niya, “Yaye ruodha, kik mirima maki koda ni atamora chungʼ e nyimi nikech an e kindena mag neno malo.” Kuom mano Laban nomanyo nyisechenego to ne ok oyudo. ");
INSERT INTO luo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jakobo mirima nomako mi odhawo gi Laban. Nopenje niya, “En richo mane masetimo momiyo ilawa matek kama? ");
INSERT INTO luo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Koro ero isemanyo giga duto, angʼo ma iyudo ma mari? Kete e lela e nyim oweteni kod owetena kendo we gingʼad bura e kindwa. ");
INSERT INTO luo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Asebedo kodi koro higni piero ariyo, to rombi kata dieki pok obwogo bende achamo imi kata achiel. ");
INSERT INTO luo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ne ok akeloni chiayo ma ondiek ochamo; to ne achulo chiayo mangima an awuon. Bende ne iketo ni achuli kuom gimoro amora mane okwal gotieno kata godiechiengʼ. ");
INSERT INTO luo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Kamano e kaka ne abet; chiengʼ nochama godiechiengʼ kendo koyo nochama gotieno, kendo nindo noringo oa e wangʼa. ");
INSERT INTO luo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ne en kama kuom higni piero ariyo kane an e odi. Ne atiyoni kuom higni apar gangʼwen ne nyigi ariyo, kendo higni auchiel ne jambi, kendo ne imaya pokna nyadipar. ");
INSERT INTO luo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ka dine ni Nyasach wuora, Nyasach Ibrahim, kod luor mane Isaka nigo, ne ok ni koda, adier dine iriemba gi lweta nono. To Nyasaye oseneno chandruokna gi tich matek mar lweta, kendo nyo okweri otieno manyoro ni kik itimna gimoro marach.” ");
INSERT INTO luo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban nodwoko Jakobo niya, “Mon-go gin nyiga, nyithindogo gin nyithinda, kendo kwethgo gin kwethga. Gik moko duto minenogo gin maga. To koro en angʼo marach madatimne nyigagi, kata ne nyithindo ma ginywolo? ");
INSERT INTO luo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Bi, mondo watim singruok, in kod an, kendo we obed kaka ranyisi e kindwa kodi.” ");
INSERT INTO luo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Omiyo Jakobo nokawo kidi mochunge ka siro. ");
INSERT INTO luo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Nowacho ne wedene niya, “Chokuru kite moko.” Kuom mano negikawo kite kendo negichokogi pith mine gichiemo but pidhno. ");
INSERT INTO luo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban nochako nying kanyo ni Jegar-Sahadutha; kendo Jakobo nochake ni Galeed. ");
INSERT INTO luo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban nowacho niya, “Pidhni en janeno e kinda kodi kawuono!” Mano emomiyo iluonge ni Galeed. ");
INSERT INTO luo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Bende kanyo nochak ni Mizpa (tiende ni kar ngʼicho), nikech Laban nowacho niya, “Mad Jehova Nyasaye bed jarit e kinda kodi ka wan mabor. ");
INSERT INTO luo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ka isando nyiga kata ikendo nyiri mamoko bangʼ nyigagi, kata obedoni onge janeno kae, to ngʼe malongʼo ni Nyasaye e janeno e kindwa.” ");
INSERT INTO luo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban nomedo wacho ne Jakobo niya, “Ne pidhni kendo ne sironi maseketo e kinda kodi. ");
INSERT INTO luo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Pidhni kata sironi gin joneno ni ok nakadh pidhni mondo amonji kendo in bende ok nikadh pidhni kata sironi mondo imonja. ");
INSERT INTO luo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Mad Nyasach Ibrahim, kod Nahor, gi Nyasach kwereni obed jangʼad bura e kindwa.” Omiyo Jakobo notimo kwongʼruok e nying Nyasach Isaka wuon-gi. ");
INSERT INTO luo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Notimo misango e godno kendo noluongo wedene e nyasino. Bangʼ kane gisechiemo, ne ginindo kanyo. ");
INSERT INTO luo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Kiny ne gokinyi mangʼich, Laban nogone nyige gi nyikwaye oriti kendo nogwedhogi. Eka nowuok modok dala. ");
INSERT INTO luo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jakobo nodhi nyime gi wuodhe, kendo malaike mag Nyasaye noromo kode. ");
INSERT INTO luo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kane Jakobo onenogi, nowacho niya, “Ma en kambi mar Nyasaye!” Kuom mano nochako kanyo ni Mahanaim (tiende ni kembni ariyo). ");
INSERT INTO luo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jakobo nooro joote nyime ir owadgi Esau e piny Seir, gwengʼ mar Edom. ");
INSERT INTO luo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Jakobo nomiyogi chik niya, “Ma e gima onego udhi uwach ne ruodha Esau: Misumbani Jakobo wacho ni, ‘Asebedo ka adak gi Laban kendo asebedo kuno nyaka chil kawuono. ");
INSERT INTO luo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","An kod dhok kod punde, rombe gi diek, jotich machwo kod jotich mamon. Omiyo koro aoro oteni ne ruodha, mondo ayud ngʼwono e wangʼe.’ ” ");
INSERT INTO luo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kane jootego odwogo ir Jakobo negiwachone niya, “Ne wadhi ir owadu Esau kendo koro obiro mondo orom kodi, to ji mia angʼwen bende ni kode.” ");
INSERT INTO luo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Kane Jakobo owinjo mano luoro kod kibaji nogoye mangʼeny mi nopogo jambe, gi dhoge kod ngamia e migepe ariyo. ");
INSERT INTO luo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Noparo e chunye niya, “Ka Esau omonjo migawo achiel, to migawo machielo modongʼ nyalo tony.” ");
INSERT INTO luo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Eka Jakobo nolamo kawacho niya, “Yaye Nyasach kwara Ibrahim, Nyasach wuora Isaka, Jehova Nyasaye mane owachona ni, ‘Dogi thuru ir jou, kendo abiro miyo inyaa,’ ");
INSERT INTO luo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ok awinjora gi kech kod adieragi duto misenyiso jatichni. Ne an mana gi ludha kende kane angʼado aora Jordan, to koro aseduogo gi ogendini ariyo. ");
INSERT INTO luo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Alamo ni mondo iresa e lwet owadwa Esau nikech aluor ni obiro biro ma omonja kaachiel gi mon kod nyithindgi. ");
INSERT INTO luo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","To isewachona ni, ‘Adier abiro miyo inyaa kendo abiro miyo nyikwayi bedo mathoth ka kuoyo man e dho nam, ma ok nyal kwan.’ ” ");
INSERT INTO luo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jakobo nonindo kanyo, kendo kuom gik mane en-go ne oyiero mich ne owadgi Esau kaka: ");
INSERT INTO luo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Diek mamon mia ariyo kod nywogi piero ariyo, rombe mamon mia ariyo gi imbe piero ariyo, ");
INSERT INTO luo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ngamia mamon piero adek gi nyithindgi, dhok mamon piero angʼwen kod rwedhi apar, kod punde mamon piero ariyo kod punde machwo apar. ");
INSERT INTO luo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Noketogi e lwet jotichne ka moro ka moro otelone kweth ka kweth kendo nowachonegi niya, “Teluru nyima kuweyo thuolo e kind kweth ka kweth.” ");
INSERT INTO luo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Nomiyo ngʼat mane otelo chik niya, “Ka owadwa Esau oromo kodi mopenji ni, ‘In jatich ngʼa, to idhi kanye kendo ni jamni duto misembogi gin mag ngʼa?’ ");
INSERT INTO luo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Eka iwachne ni, ‘Magi gin mag jatichni Jakobo. Gin mich ma oor ne ruodha Esau, Jakobo bende biro bangʼwa.’ ” ");
INSERT INTO luo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Bende nomiyo ngʼat mar ariyo, gi ngʼat mar adek kod jogo duto mane luwo bangʼ kweth chik niya, “Un duto wachuru ne Esau mana gima chalre kuromo kode. ");
INSERT INTO luo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kendo une ni uwacho ni, ‘Jatichni Jakobo biro bangʼwa.’ ” Nikech noparo niya, “Obiro hoye gi mich ma ooroneni kendo ka oneno to ponono obiro rwaka.” ");
INSERT INTO luo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kuom mano mich Jakobo noter motelo, ka en to nodongʼ ei kambi. ");
INSERT INTO luo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Otienono Jakobo nochungʼ mokawo monde ariyo, jotichne mamon ariyo kod yawuote apar gachiel kendo negikadho aora mar Jabok. ");
INSERT INTO luo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Jakobo nokawo joge kaachiel gi gige mi nokowogi nyaka loka aora Jabok. ");
INSERT INTO luo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Bangʼ mano Jakobo nodongʼ kende, kendo ngʼato noi kode otieno duto nyaka okinyi. ");
INSERT INTO luo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Kane ngʼatno oneno ni ok onyal goye piny, nomulo fuoni mar bamne, kuom mano chieke nowil. ");
INSERT INTO luo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ngʼatno nowacho niya, “We adhi, nikech en odiechiengʼ.” To Jakobo nodwoke niya, “Ok abi weyi idhi nyaka igwedha.” ");
INSERT INTO luo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ngʼatno nopenje niya, “Nyingi ngʼa?” Nodwoke niya, “Jakobo.” ");
INSERT INTO luo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Eka ngʼatno nowacho niya, “Nyingi ok nochak oluongi ni Jakobo, to noluongi ni Israel nikech ise ii gi Nyasaye kod ji mi iseloyo.” ");
INSERT INTO luo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jakobo nowachone niya, “Asayi nyisa nyingi.” To nodwoko Jakobo niya, “Angʼo momiyo ipenjo nyinga?” Eka nogwedho Jakobo kanyo. ");
INSERT INTO luo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kuom mano Jakobo nochako kanyo ni Peniel (tiende ni wangʼ Nyasaye) kowacho niya, “Nikech aseneno Nyasaye wangʼ gi wangʼ kendo ngimana oresi.” ");
INSERT INTO luo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Chiengʼ notuchne ka okadho Peniel kendo nowuotho kolingʼo nikech bamne nowil. ");
INSERT INTO luo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Mano emomiyo nyaka kawuono jo-Israel ok cham ringʼo moriwo fuond bam ka giparogo wil mar fuond bam Jakobo. ");
INSERT INTO luo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakobo notingʼo wangʼe moneno Esau kabiro ka en gi ji mia angʼwen. Kuom mano nopogo nyithindo e kind Lea gi Rael kod jotichne mamon ariyo. ");
INSERT INTO luo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Noketo jotichne mamon ariyo kod nyithindgi nyime, kiluwogi gi Lea kod nyithinde, to Rael gi Josef ema noketo chien. ");
INSERT INTO luo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jakobo owuon notelo nyimgi mi opodho auma nyadibiriyo e nyim Esau owadgi. ");
INSERT INTO luo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","To Esau noringo oromone Jakobo mokwake; nokwako ngʼute kendo onyodhe mine giywak giduto. ");
INSERT INTO luo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Eka Esau notingʼo wangʼe malo moneno mon kod nyithindo. Nopenjo niya, “Magi gin ngʼa gini man kodigi?” Jakobo nodwoke niya, “Gin nyithindo ma Nyasaye osemiyo jatichni kuom ngʼwonone.” ");
INSERT INTO luo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Eka jotichne mamon kod nyithindgi nochopo mopodho auma e nyime. ");
INSERT INTO luo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Bangʼe Lea kod nyithinde nobiro mopodho auma e nyime. Josef gi Rael bende nochopo mopodho auma e nyime. ");
INSERT INTO luo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau nopenjo niya, “Kweth maduongʼ mane aromogo cha tiendgi angʼo?” Jakobo nodwoke niya, “Ne aorogi mondo gibi gi kwana ngʼwono kuom ruodha.” ");
INSERT INTO luo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","To Esau nowacho niya, “An gi gik mathoth owadwa. Magi-gi bedgo abeda.” ");
INSERT INTO luo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakobo nowachone, “Ooyo, asayi! Ka isengʼwonona to yie ikaw michgi. Nikech neno wangʼi chalo mana gi neno wangʼ Nyasaye, ka koro iserwaka gi ngʼwono kama. ");
INSERT INTO luo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Asayi kaw mich manokelnigo, nikech Nyasaye osebedona mangʼwon kendo an gi gik moko duto madwaro.” Nikech Jakobo noramo, Esau nokawo. ");
INSERT INTO luo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Bangʼ mano Esau nowacho ne Jakobo niya, “Waikreuru mondo wadhi kanyakla.” ");
INSERT INTO luo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","To Jakobo nodwoke niya, “Ruodha, ingʼeyo ni nyithindogi pod tindo to bende nyaka wapar nyithi rombe kod nyiroye ma pod dhoth. Kaponi osembgi matek odiechiengʼ achiel to jamni duto nyalo tho. ");
INSERT INTO luo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kuom mano ruodha akwayi ni tel e nyim misumbani, to aluwi mos mos gi nyithindo kod jamni nyaka achop iri Seir.” ");
INSERT INTO luo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Eka Esau nowachone niya, “We awe joga moko kodi ka.” Jakobo nopenje niya, “Angʼo momiyo idwaro timo kamano? Mad iyiena ayieya ayud ngʼwono e nyim ruodha.” ");
INSERT INTO luo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kuom mano odiechiengʼno Esau nochako wuodhe ka odok Seir. ");
INSERT INTO luo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kata kamano Jakobo nodhi Sukoth, kama nogeroe dalane kendo oloso dipo ne kweth mage mag jamni. Mano ema omiyo iluongo kanyo ni Sukoth (tiende ni abilni). ");
INSERT INTO luo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Bangʼ ka Jakobo nosea Padan Aram, nochopo maber e dala maduongʼ mar Shekem manie piny Kanaan kendo nodak momanyore gi dalano. ");
INSERT INTO luo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Lowo mano gedoe nongʼiewo kuom yawuot Hamor ma wuon Shekem gi fedha madirom mia achiel. ");
INSERT INTO luo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kanyo ema nogeroe kendo mar misango kendo nochake ni El-Elohe-Israel (tiende ni Nyasaye ma Nyasach Israel). ");
INSERT INTO luo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Chiengʼ moro Dina, nyar Jakobo mane Lea onywolone nodhi limo nyi pinyno. ");
INSERT INTO luo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kane Shekem wuod Hamor ja-Hivi ma jatend gwengʼno, nonene, nomake moterore kode. ");
INSERT INTO luo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Chunye nokete kuom Dina nyar Jakobo omiyo nohere kendo nowuoyo kode gi ngʼwono mathoth. ");
INSERT INTO luo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Kendo Shekem nowacho ni wuon mare Hamor niya, “Nyuomna nyakoni obed chiega.” ");
INSERT INTO luo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Kane Jakobo owinjo ni Dina nyare osedwany to ne ok owacho gimoro nyaka yawuote noduogo dala koa kwayo jambe. ");
INSERT INTO luo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Eka Hamor ma wuon Shekem nodhi mowuoyo gi Jakobo. ");
INSERT INTO luo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Kane yawuot Jakobo owinjo gima nosetimore, negidwogo dala mapiyo nono ka gia kuonde mag kwath. Igi nowangʼ ahinya kendo negikuyo, nikech tim anjawo mane Shekem osetimo ni Dina nyamin-gi e piny Israel, tim mamono ma ok owinjore. ");
INSERT INTO luo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","To Hamor nowacho ne Jakobo niya, “Wuoda Shekem chunye oseketo kuom nyari. Asayi yie ichiw nyari obed jaod Shekem. ");
INSERT INTO luo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Wakend nyiu to un bende ukend nyiwa. ");
INSERT INTO luo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Unyalo dak e dierwa; pinyni en maru dagieuru, timeuru ohala kendo uyudieuru giu uwegi.” ");
INSERT INTO luo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Eka Shekem nowacho ne wuon Dina kod owete Dina niya, “timnauru ngʼwono kendo abiro miyou gimoro amora ma ukwayo.” ");
INSERT INTO luo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Nyisauru gik ma onego anyuomnu kata ma onego amiu kaka uhero, kendo abiro chulou gimoro amora ma ukwaya ka uyie miye nyaminu. ");
INSERT INTO luo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yawuot Jakobo nodwoko Shekem gi Hamor wuon mare ka giwuondore nikech Shekem nosedwanyo Dina nyamin-gi. ");
INSERT INTO luo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Negiwachonegi niya, “Ok wanyal timo gima kamano; ok wanyal chiwo nyaminwa ne ngʼama ok oter nyangu, mano dibed wichkuot ne wan. ");
INSERT INTO luo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Wabiro yienu mana ka utimo gimoro achielni: mondo ubed kaka wan ka utero yawuotu duto nyangu. ");
INSERT INTO luo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Eka wabiro miyou nyiwa kendo wan bende wabiro kawo nyiu. Wabiro dak kodu kendo wabiro bedo oganda achiel. ");
INSERT INTO luo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","To ka ok unyal yie mondo oteru nyangu to wabiro kawo nyaminwa mi wadhigo.” ");
INSERT INTO luo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Gima negiwachono nonenore maber ne Hamor kod wuode Shekem. ");
INSERT INTO luo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Omiyo Shekem mane omi duongʼ e od wuon-gi, ne ok odeko timo gima ne yawuot Jakobo owacho, nikech nomor gi Dina nyar Jakobo. ");
INSERT INTO luo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Kuom mano Hamor gi wuode Shekem nodhi e dhoranga dalagi mondo giwuo gi jothurgi. ");
INSERT INTO luo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Negiwachonegi niya, “Jogi gin osiepewa. We gidag e pinywa kendo gilokie; pinywani duongʼ moromogi. Wanyalo kendo nyigi kendo gin bende ginyalo kendo nyiwa. ");
INSERT INTO luo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ok ginyal yie dak kodwa mondo wabed oganda achiel kodgi makmana ka chwo duto oter nyangu mana kaka gin. ");
INSERT INTO luo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Donge kwethgi, gi gigegi kod jambgi duto biro bedo mawa? Omiyo ka wayie timo kamano eka giniyie dak kodwa.” ");
INSERT INTO luo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ji duto mane odhi e dhoranga dala noyie gi Hamor kod Shekem wuode kendo chwo duto mane ni e dalano noter nyangu. ");
INSERT INTO luo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Bangʼ ndalo adek kane pod gin kod rem, yawuot Jakobo ariyo, Simeon kod Lawi mowete Dina, nokawo gigegi mag lweny mi gidonjo e dala jogo apoya kendo ginego joma chwo duto. ");
INSERT INTO luo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Neginego Hamor gi Shekem wuode, eka negigolo Dina e od Shekem mi giago. ");
INSERT INTO luo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yawuot Jakobo mamoko nomonjo joma ne owetegi osenego mi giyako dala maduongʼni nikech jogo nosekuodo wi nyamin-gi. ");
INSERT INTO luo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Negipeyo kwethgi gi dhogi gi pundegi kod gigegi duto mane ni e dala kod mago mane ni oko e pap. ");
INSERT INTO luo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Negikawo mwandugi duto, mondgi duto, nyithindgi duto kod gik moko duto mane ni e udi. ");
INSERT INTO luo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Eka Jakobo nowacho ne Simeon gi Lawi niya, “Usekelona chandruok maduongʼ ka umiya nying marach e kind jo-Kanaan kod jo-Perizi, ma weg pinyni. Wan ji manok, kendo kagiriworenwa mondo giked kodwa e lweny, to an kod oda ibiro tieka.” ");
INSERT INTO luo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","To negidwoko wuon-gi niya, “Bende en gima ber mondo timne nyaminwa tim marach mane otimne cha?” ");
INSERT INTO luo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Eka Nyasaye nowacho ne Jakobo niya, “Aa malo idhi Bethel kendo idag kuno mi iger kendo mar misango ne Nyasaye, mane ofwenyoreni kane iringo ia kuom Esau owadu.” ");
INSERT INTO luo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kuom mano Jakobo nowacho ne joode duto kod ji mane ni kode niya, “Wituru nyiseche mag pinje mamoko ma un-go kendo upwodhru mi urwak lewni maler. ");
INSERT INTO luo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Eka ubi mondo wadhiuru Bethel, kuma abiro dhi geroe kendo mar misango ne Nyasaye, mane odwoka e kinde mane an e chandruok malich kendo ma osebedo koda kamoro amora ma asedhiyoe.” ");
INSERT INTO luo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kuom mano negimiyo Jakobo nyiseche mag pinje mamoko mane gin-go kod stadi mane ni e itgi kendo Jakobo noyikogi e tiend yiend ober man Shekem. ");
INSERT INTO luo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Eka negichako wuoth kendo luoro mar Jehova Nyasaye nomako mier duto mane okiewo kodgi maonge ngʼama nolawo bangʼ-gi. ");
INSERT INTO luo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakobo kod ji duto mane ni kode nochopo Luz (ma tiende ni Bethel) e piny Kanaan. ");
INSERT INTO luo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Kanyo Jakobo nogero kendo mar misango kendo noluongo kanyo ni El Bethel, nikech kanyo ema ne Nyasaye ofwenyorene kane oringo owadgi. ");
INSERT INTO luo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debora, ma japit Rebeka notho kendo noyike e tiend yiend ober machiegni gi Bethel. Kuom mano nochak kanyo ni Allon Bakuth. ");
INSERT INTO luo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Bangʼ ka Jakobo nosea Padan Aram, Nyasaye nochako ofwenyorene kendo nogwedhe. ");
INSERT INTO luo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Nyasaye nowachone niya, “Kata obedo ni nyingi en Jakobo to ok nochak oluongi kamano to koro ibiro luongi ni Israel.” Omiyo nochake ni Israel. ");
INSERT INTO luo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Kendo Nyasaye nowachone niya, “An Nyasaye Maratego, nywolri kendo imedri. Ogendini kod dhout ogendini noa kuomi kendo ruodhi nowuog kuomi. ");
INSERT INTO luo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Piny mane amiyo Ibrahim kod Isaka bende abiro miyi kaachiel gi nyikwayi.” ");
INSERT INTO luo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Eka Nyasaye nodhi e polo moweye kama ne giwuoyoe kodeno. ");
INSERT INTO luo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakobo nochungo siro mar kidi kanyono mane Nyasaye owuoyoe kode, kendo noolo ewi sirono misango miolo piny bende noolo misango mar mo ewi siro. ");
INSERT INTO luo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jakobo nochako kanyo mane Nyasaye owuoyoe kodeno ni Bethel. ");
INSERT INTO luo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Eka negiwuok gia Bethel. Kane gisedhi mochwalore gi Efrath, muoch nochako kayo Rael kendo nochandore ahinya. ");
INSERT INTO luo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","E kinde mane muoch kayeno, jacholo nowachone niya, “Kik iluor nikech inywolo wuowi machielo.” ");
INSERT INTO luo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Kane chunye chiegni chot nochako wuodeno ni Ben-Oni. To wuon mare to nochake ni Benjamin. ");
INSERT INTO luo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Kuom mano Rael notho kendo nokunye e yo madhi Efrath (ma tiende ni Bethlehem). ");
INSERT INTO luo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jakobo noketo siro ewi liend Rael kendo nyaka chil kawuono sirono obet kar liend Rael. ");
INSERT INTO luo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel nochako odhi nyime giwuoth kendo noguro hembe tok oinga mar Migdal Eder. ");
INSERT INTO luo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Kane oyudo Israel dak kuno, Reuben nodhi moterore gi Bilha jatich ma nyako mar wuon-gi mi Israel nowinjo wachno. Jakobo ne nigi yawuowi apar gariyo: ");
INSERT INTO luo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Yawuot Lea ne gin: Reuben wuod Jakobo makayo, Simeon, Lawi, Juda, Isakar kod Zebulun. ");
INSERT INTO luo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Yawuot Rael ne gin: Josef kod Benjamin. ");
INSERT INTO luo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Yawuot Bilha, jatich Rael madhako ne gin: Dan kod Naftali. ");
INSERT INTO luo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Yawuot Zilpa jatich Lea madhako ne gin: Gad kod Asher. Magi ema ne yawuot Jakobo mane onywolone Padan Aram. ");
INSERT INTO luo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakobo noduogo dala ir wuon-gi Isaka Mamre machiegni gi Kiriath Arba (ma tiende ni Hebron), kumane Ibrahim kod Isaka odakie. ");
INSERT INTO luo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaka nodak higni mia achiel gi piero aboro. ");
INSERT INTO luo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Eka Isaka notho kendo noluwo kwerene ka oti kendo hike ngʼeny. Kendo yawuot Esau kod Jakobo noyike. ");
INSERT INTO luo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Magi e joka Esau (ma tiende ni Edom). ");
INSERT INTO luo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau nokendo nyi Kanaan: Ada nyar Elon ja-Hiti, kod Oholibama nyar Ana ma nyakwar Zibeon ja-Hivi, ");
INSERT INTO luo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","gi Basemath nyar Ishmael kendo ma nyamin Nebayoth. ");
INSERT INTO luo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada nonywolone Esau Elifaz, to Basemath nonywolo Reuel, ");
INSERT INTO luo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","kendo Oholibama nonywolo Jeush, Jalam kod Kora. Magi ema ne yawuot Esau, mane onywol Kanaan. ");
INSERT INTO luo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau nokawo monde, yawuote, nyige kod joode duto kaachiel gi jambe duto kod mwandu duto mane oyudo Kanaan, kendo nodhi e piny moro mabor gi Jakobo owadgi. ");
INSERT INTO luo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Mwandugi ne ngʼeny makoro ne ok ginyal dak kamoro achiel; piny mane gidakie ne tin ma ok nyal romogi nikech kwethgi. ");
INSERT INTO luo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kuom mano Esau (ma tiende ni Edom) nodhi odak e piny gode man Seir. ");
INSERT INTO luo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ma e nonro mar joka Esau ma kwar jo-Edom manodak e piny gode mar Seir. ");
INSERT INTO luo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Magi e nying yawuot Esau: Elifaz wuod Esau mane Ada onywolone, kod Reuel wuod Esau mane Basemath onywolone. ");
INSERT INTO luo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifaz nonywolo: Teman, Omar, Zefo, Gatam kod Kenaz. ");
INSERT INTO luo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaz wuod Esau bende ne nigi jatich madhako miluongo ni Timna mane onywolone Amalek. Magi ema ne nyikwa Ada chi Esau. ");
INSERT INTO luo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Yawuot Reuel ne gin: Nahath, Zera, Shama kod Miza. Magi ema ne nyikwa Basemath chi Esau. ");
INSERT INTO luo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Yawuot Oholibama, chi Esau ma nyar Ana kendo nyakwar Zibeon mane onywolone Esau ne gin: Jeush, Jalam kod Kora. ");
INSERT INTO luo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Magi ema ne jodong joka Esau: Yawuot Elifaz ma wuod Esau makayo gin: Jaduongʼ Teman, Omar, Zefo, Kenaz, ");
INSERT INTO luo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam kod Amalek magi e jodongo ma nyikwa Elifaz mane odak Edom; bende ne gin nyikwa Ada. ");
INSERT INTO luo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Yawuot Reuel wuod Esau ne gin: Jaduongʼ Nahath, Zera, Shama kod Miza. Magi e jodongo ma nyikwa Reuel mane odak Edom; bende ne gin nyikwa Basemath chi Esau. ");
INSERT INTO luo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Yawuot Oholibama ma chi Esau gin: Jaduongʼ Jeush, Jalam kod Kora. Magi ema ne jodongo mowuok kuom Oholibama ma chi Esau nyar Ana. ");
INSERT INTO luo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Magi ema ne yawuot Esau (ma tiende ni Edom), kendo magi ema ne jodong-gi. ");
INSERT INTO luo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Magi ema ne yawuot Seir ja-Hori, mane odak e gwengʼno: Lotan, Shobal, Zibeon, Ana, ");
INSERT INTO luo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, kod Dishan. Yawuot Seir gi, mane odak Edom ema ne jodong jo-Hori. ");
INSERT INTO luo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan nonywolo: Hori kod Homam. Timna ne en nyamin Lotan. ");
INSERT INTO luo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobal nonywolo: Alvan, Manahath, Ebal, Shefo kod Onam. ");
INSERT INTO luo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon nonywolo: Aiya, kod Ana. (Ma e Ana mane ofwenyo thidhna mar pi maliet e thim kane oyudo okwayo punde wuon mare Zibeon.) ");
INSERT INTO luo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana nonywolo: Dishon, kod Oholibama nyar Ana. ");
INSERT INTO luo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishon nonywolo: Hemdan, Eshban, Ithran kod Keran. ");
INSERT INTO luo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer nonywolo: Bilhan, Zavan kod Akan. ");
INSERT INTO luo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan nonywolo: Uz kod Aran. ");
INSERT INTO luo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Magi ema ne jodong jo-Hori: Lotan, Shobal, Zibeon, Ana, ");
INSERT INTO luo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer kod Dishan. Magi ema ne jodong jo-Hori, kaluwore gi dhoutgi e piny mar Seir. ");
INSERT INTO luo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Magi e ruodhi mane orito piny Edom kane jo-Israel ne pod onge kod ruodhi: ");
INSERT INTO luo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela wuod Beor nobedo ruodh Edom. Dalane maduongʼ niluongo ni Dinhaba. ");
INSERT INTO luo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Kane Bela otho, Jobab wuod Zera mane ja-Bozra nobedo ruoth kare. ");
INSERT INTO luo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Kane Jobab otho, Husham mane oa e piny jo-Teman nobedo ruoth kare. ");
INSERT INTO luo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kane Husham otho, Hadad wuod Bedad, mane oloyo jo-Midian e piny jo-Moab nobedo ruoth kare. Dalane maduongʼ niluongo ni Avith. ");
INSERT INTO luo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kane Hadad otho, Samla ja-Masreka nobedo ruoth kare. ");
INSERT INTO luo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Kane Samla otho, Shaul ja-Rehoboth man but aora nobedo ruoth kare. ");
INSERT INTO luo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Kane Shaul otho, Baal-Hanan wuod Akbor nobedo ruoth kare. ");
INSERT INTO luo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Kane Baal-Hanan wuod Akbor otho, Hadad nobedo ruoth kare. Dalane maduongʼ niluongo ni Pau, kendo chiege niluongo ni Mehetabel nyar Matred, ma nyar Me-Zahab. ");
INSERT INTO luo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Koro magi e jodong joka Esau gi nying-gi, kaluwore gi dhoutgi kod pinjegi: Timna, Alva, Jetheth, ");
INSERT INTO luo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO luo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO luo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel kod Iram. Magi ema ne jodong Edom, kaluwore gi dakgi e piny mane gikawo kaka margi. Ma e chal Esau, kwar jo-Edom. ");
INSERT INTO luo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakobo nodak e piny Kanaan, kuma ne wuon-gi odakie. ");
INSERT INTO luo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ma e nonro mar joka Jakobo. Kane Josef ja-higni apar gabiriyo, nohero kwayo jamb wuon-gi ka en kaachiel gi owetene ma yawuot Bilha kod yawuot Zilpa ma magi gin monde wuon-gi. To Josef nonyiso wuon-gi timbe moko maricho ma owetene ne timo. ");
INSERT INTO luo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Koro Israel nohero Josef moloyo yawuote mamoko, nikech en nyathi mane onywolne ka oseti, kendo nolosone law mar kandho maber. ");
INSERT INTO luo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kane owetene oneno ni wuon-gi ohero Josef moloyogi, negidoko mamon kode kendo ne ok ginyal wuoyo kode maber. ");
INSERT INTO luo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Chiengʼ moro Josef noleko, kendo kane onyiso owetene lekno, to owetene nomedo bedo mamon kode. ");
INSERT INTO luo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Nowachonegi niya, “Winjeuru kaka nende aleko: ");
INSERT INTO luo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ne watweyo cham manie puodho eka apoya nono wi cham mane asetweyo nochungʼ tir, ka wiye chambu olworo wi chamba kendo okulorene.” ");
INSERT INTO luo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Owetene nowachone niya, “Iparo ni inyalo telonwa? Bende inyalo telonwa adier?” Kendo negimedo bedo mamon kode nikech lekneno kod gimane owachonegi. ");
INSERT INTO luo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Eka Josef nochako oleko lek machielo, kendo nowacho ne owetene lekno. Nowachonegi niya, “Winjuru lek machielo manyoro aleko ni wangʼ chiengʼ gi dwe kod sulwe apar gachiel kulorena.” ");
INSERT INTO luo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kane onyiso wuon-gi kaachiel gi owetene, wuon-gi nokwede kendo owachone niya, “Ma en lek manade manyoro ilekoni? Iparo ni minu kod an kod oweteni nyalo biro kuloreni mondo omiyi duongʼ?” ");
INSERT INTO luo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Owetene ne nyiego omako kode, to wuon-gi to ne okano wechego e chunye. ");
INSERT INTO luo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Koro noyudo owete Josef kwayo jamb wuon-gi machiegni gi Shekem, ");
INSERT INTO luo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","eka Israel nowacho ne Josef niya, “Kaka ingʼeyo ni oweteni kwayo jamni machiegni gi Shekem; koro bi mondo aori irgi.” Josef nodwoke niya, “Mano ber.” ");
INSERT INTO luo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Kuom mano nowachone niya, “Dhiyo kendo ineane ka oweteni dhi maber kod jamni, kendo iduogna wach.” Kamano nooro Josef koa e Holo mar Hebron. Kane Josef otundo Shekem, ");
INSERT INTO luo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ngʼat moro noromo kode ka owuotho awuotha e thim mi openje niya, “Imanyo angʼo?” ");
INSERT INTO luo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Nodwoke niya, “Adwaro owetena. Kinyisa kuma gikwayoe jambgi?” ");
INSERT INTO luo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ngʼatno nodwoke niya, “Gisewuok ka. Ne awinjo kagiwacho ni gidhi Dothan.” Kuom mano Josef noluwo bangʼ owetene kendo noyudogi machiegni gi Dothan. ");
INSERT INTO luo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","To ne ginene kapod en mabor, kendo kane pok ochopo irgi, negichano mondo ginege. ");
INSERT INTO luo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Negiwacho e kindgi giwegi niya, “Neuru jalek lek cha biro! ");
INSERT INTO luo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Biuru mondo wanege kendo wawite e bungu moro achiel kendo wawach ni le moro mager nyonege. Eka mondo wane gima lekne biro timone.” ");
INSERT INTO luo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kane Reuben owinjo ma notemo mondo ores Josef e lwet owetene. Nowachonegi niya, “Kik wanege. ");
INSERT INTO luo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kik uchwer remo moro amora, witeuru e bugo manie thim kaeni, to kik uket lwetu kuome.” Reuben nowacho mondo ores Josef kendo odwoke ir wuon-gi. ");
INSERT INTO luo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kuom mano kane Josef ochopo ir owetene ne gilonyo kandhone mane olos gi law maber kendo ma nengone tek, ");
INSERT INTO luo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","kendo ne gikawe mi giwite e bugo. Bugono ne ninono kendo pi ne onge e iye. ");
INSERT INTO luo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Kane gibet gichiemo negineno oganda mar jo-Ishmael koa Gilead. Ngamia notingʼo gik mangʼwe ngʼar, gi mane-mane kod yiende moko, kendo negiterogi Misri. ");
INSERT INTO luo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Juda nowacho ne owetene niya, “Ere ohala ma wabiro yudo ka wanego owadwa kendo wapando rembe? ");
INSERT INTO luo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Biuru mondo wause ne jo-Ishmael kendo kik waket lwetwa kuome; nikech en owadwa, ringrewa kendo rembwa.” Owetege noyie giwachno. ");
INSERT INTO luo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Kuom mano kane jo-ohala ma jo-Midian ochopo machiegni, owete Josef noywaye oko e bugo kendo nouse kuom shekel piero ariyo mar fedha ne jo-Ishmaelgo, mane otere Misri. ");
INSERT INTO luo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Kane Reuben odok e bugo mane owit e Josef kendo oyudo ni Josef onge kanyo, noyiecho lepe. ");
INSERT INTO luo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nodok ir owetene mowachonegi niya, “Rawera cha onge kacha! Koro anyalo timo angʼo?” ");
INSERT INTO luo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Eka negikawo kandho Josef, mi giyangʼo diel kendo ginyumo kandho Josef e remb diel. ");
INSERT INTO luo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ne gitero ne wuon-gi kandho Josef mane olos maber kendo ma nengone tek kagiwacho niya, “Ne wayudo kandhoni. Range ane maber ka en mar wuodi.” ");
INSERT INTO luo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Israel nofwenyo kendo owacho niya, “Ma en kandho wuoda! Le moro mager nonege. En adier ni le mager onego Josef mokidhe matindo tindo.” ");
INSERT INTO luo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Eka Jakobo noyiecho lepe, morwako pien gugru kendo noywago Josef wuode kuom ndalo mangʼeny. ");
INSERT INTO luo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Yawuote kod nyige duto nobiro mondo ohoye, to notamore ahoya. Nowacho niya, “Ooyo, abiro ywago wuoda nyaka atho aluw bangʼe.” Kuom mano wuon-gi noywage. ");
INSERT INTO luo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","To jo-Midian nouso Josef e piny Misri ne Potifa, achiel kuom jotich mag Farao, jaduongʼ jorit od ruoth. ");
INSERT INTO luo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","E kindeno, Juda noweyo owetene kendo nodhi odak gi ja-Adulam ma nyinge Hira. ");
INSERT INTO luo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Kuno Juda noromo gi nyar Shua ja-Kanaan mokendo kendo oriwore kode. ");
INSERT INTO luo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nomako ich kendo onywolo wuowi manochaki ni Er. ");
INSERT INTO luo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nochako omako ich kendo onywolo wuowi kendo nochake ni Onan. ");
INSERT INTO luo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nochako onywolo wuowi machielo kendo nochake ni Shela. Wuowini nonywolo ka en Kezib. ");
INSERT INTO luo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda nokendone Er, wuode maduongʼ dhako kendo niluonge ni Tamar. ");
INSERT INTO luo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","To kata kamano, Er wuod Juda maduongʼ ne ngʼama timbene richo ahinya e nyim Jehova Nyasaye; kuom mano Jehova Nyasaye nonege. ");
INSERT INTO luo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Eka Juda nowacho ne Onan wuode niya, “Kaw chi owadu kendo ibed kode kaka yuori mondo inywol kode nyithindo ichung godo wi owadu.” ");
INSERT INTO luo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","To Onan nongʼeyo ni nyithindogo ok bi bedo mage, kuom mano e sa asaya mane oriwore kod chi owadgino; ne oolo kothe oko e lowo mondo ne mi kik onywol nyathi ne owadgi. ");
INSERT INTO luo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Gimane otimono ne gima kwero e nyim Jehova Nyasaye; kuom mano en bende Jehova Nyasaye nonege. ");
INSERT INTO luo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Eka Juda nowacho ne Tamar chi wuode niya, “Dhi dag e od wuonu kaka dhako ma chwore otho nyaka chop Shela wuoda bed maduongʼ.” Nikech noparo niya, “En bende onyalo tho mana kaka owetene.” Kuom mano Tamar nodhi odak gi wuon mare. ");
INSERT INTO luo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bangʼ kinde moko, nyar Shua ma chi Juda notho. Kane Juda osetieko weche mag liel, nodhi nyaka Timna ir joma ne lielo yie rombege kendo nodhi gi Hira ja-Adulam ma osiepne. ");
INSERT INTO luo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kane owach ne Tamar ni kwar mare owuok dhi Timna ngʼado yie rombe, ");
INSERT INTO luo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","nolonyo lawe mar chola oko, moumore gi suka mondo olok kite eka ne odhi mobet e dhorangach madonjo Enaim, mantie e yo madhi Timna. Nikech noneno ni kata obedo ni Shela koro osebedo ngʼama duongʼ, to ne ok omiyego mondo obed chwore. ");
INSERT INTO luo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kane Juda onene, noparo ni en ochot nikech noumo wangʼe. ");
INSERT INTO luo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ka ok ongʼeyo ni mano chi wuode Juda nodhi ire kamane obetie bath yo kendo owachone niya, “Koro bi mondo wabed kodi e achiel.” To Tamar nopenje niya, “Ibiro miya angʼo ka wabedo kodi e achiel?” ");
INSERT INTO luo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","To Juda nodwoke niya, “Abiro oroni nyadiel magolo e kwethna.” To Tamar nomedo penje niya, “Ibiro singona angʼo kapok ioro nyadiendno?” ");
INSERT INTO luo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","To Juda nodwoke niya, “Singo mar angʼo ma idwaro?” To Tamar nodwoke niya, “Miya banglinino gi tonde kod luth manie lwetino.” Kuom mano Juda nomiyo Tamar chi wuode gigo kendo noriwore kode mi Tamar nomako ich kod Juda kwar mare. ");
INSERT INTO luo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Bangʼ ka Tamar nosedhi, nogolo law mane oumore godo kendo ochako orwako lawe mar chola. ");
INSERT INTO luo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Eka bangʼe Juda nooro osiepne ma ja-Adulam gi nyadiel mondo mi oduogne gige mane Tamar odhigodo, to osiepne ne ok oyudo Tamar. ");
INSERT INTO luo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Nopenjo ji mane odak kanyo niya, “Ere ochot madhako mane obet e akek yo madhi Enaim cha?” To negidwoke niya, “Onge ochot ma dhako ka.” ");
INSERT INTO luo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Eka nodok ir Juda kendo owachone niya, “Ok ayude. To ji modak kanyo ne owachona ni, ‘Onge ochot madhako ka.’ ” ");
INSERT INTO luo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Eka Juda nowacho niya, “We obed gi gik mane asingonego, nono to ji biro nyierowa. To bende aseorone nyadiendno, to ok inyal yude.” ");
INSERT INTO luo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Bangʼ dweche adek Juda noyudo wach niya, “Tamar chi wuode tim chode osemiyo wichkuot kendo kuom mano koro en gi ich.” Juda nowacho niya, “Goleuru oko kendo uwangʼe nyaka otho!” ");
INSERT INTO luo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","E kinde mane igolo Tamar oko, noorone kwar mare wach niya, “Wuon banglini gi tonde kod ludhni ema nomiya ich rang ane ka inyalo yudo wuon-gi.” ");
INSERT INTO luo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda nofwenyo gigo, kendo owacho niya, “Dhakoni ja-adiera maloya, nikech ne ok amiye Shela wuoda mondo okende.” Kendo Juda ne ok ochako oriwore kode. ");
INSERT INTO luo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kane sa ochopo mondo onywolie, nofwenyo ni en kod rude ma yawuowi e iye. ");
INSERT INTO luo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Kane oyudo onywol, lwet nyathi achiel nowuok oko; kuom mano jacholo nokawo usi makwar kendo otweyo e ngʼut lwedono ka owacho niya, “Ma ema ne okwongo owuok.” ");
INSERT INTO luo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","To kane nyathino odwoko lwete iye, owadgi machielo nowuok mi owacho niya, “Kama e kaka ithinyori oko!” Omiyo nochake ni Perez. ");
INSERT INTO luo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Eka owadgi mane otwe usi e ngʼut lwete nowuok mi nochake nying ni Zera. ");
INSERT INTO luo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Koro Josef noseter Misri. Potifa ma ja-Misri mane en achiel kuom jatend Farao, kendo jaduongʼ od ruoth nongʼiewe kuom jo-Ishmael mane okele kanyo. ");
INSERT INTO luo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Jehova Nyasaye ne ni kod Josef kendo nogwedhe, kendo nodak e od ruodhe ma ja-Misri. ");
INSERT INTO luo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kane ruodhe oneno ni Jehova Nyasaye ne ni kode kendo ni Jehova Nyasaye nogwedho gik moko duto ma otimo, ");
INSERT INTO luo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","nobedo mamor gi Josef kendo Josef notiyone, Potifa nokete jarit ode kod mwandu duto mane en-go. ");
INSERT INTO luo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Chakre ndalo mane okete jarit ode kendo jarit gik moko duto ma en-go, Jehova Nyasaye nogwedho gik moko duto mane ni e od ja-Misri nikech Josef. Jehova Nyasaye nogwedho gimoro amora mane Potifa nigo e ot kod e puodho. ");
INSERT INTO luo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Omiyo noweyo gik moko duto mane en-go e lwet Josef kaka jarit; makoro Potifa ne ok odewo rango gimoro amora makmana chiemo mane ochamo. Josef ne nigi chia kendo jaber. ");
INSERT INTO luo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kendo bangʼ kinde manok, chi ruodh Josef norange kagombe kendo nowachone niya, “Bi e kitanda ka mondo iriwri koda.” ");
INSERT INTO luo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","To Josef nodagi mowachone niya, “Ruodha ongʼeyo gimoro amora manie odni, gimoro amora ma en-go oseketo e lweta. ");
INSERT INTO luo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Onge ngʼama nigi teko e odni moloya. Ruodha ok osetama gimoro amora manie odni makmana in, nikech in chiege. Koro ere kaka anyalo timo tim richo kendo makwero ma Nyasaye odagi?” ");
INSERT INTO luo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","To nodhi nyime kowachone Josef wechego odiechiengʼ kodiechiengʼ, to notamore riwore kode kata bedo bute. ");
INSERT INTO luo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Chiengʼ moro achiel Josef nodhi e od ruodhe mondo otim tije kaka pile kendo ne onge jatich moro amora e ot. ");
INSERT INTO luo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Chi Potifa ne omake gilawe kendo owachone niya, “Bi mondo ibed koda e achiel!” To Josef noringo mowuok oko mar odno kendo noweyo lawe e lwet chi Potifa. ");
INSERT INTO luo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Kane dhakono oneno ni Josef oweyo lawe e lwete kendo oringo owuok oko mar ot, ");
INSERT INTO luo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","noluongo jotichge mag ot mowachonegi niya, “Neuru, ja-Hibraniani osekelnwa mondo okuod wiwa! Nodonjo ira ka mondo oriwre koda, to ne agoyo uwi matek. ");
INSERT INTO luo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kane owinjo ka agoyo uwi matek mondo okonya, noringo moweyo lawe sa ma noringo owuok oko mar ot.” ");
INSERT INTO luo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Dhakono nokano lawno nyaka chwore noduogo dala. ");
INSERT INTO luo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Eka nowacho ne chwore wachni niya, “Jatich ma ja-Hibrania manyocha ikelonwa nobiro ira mondo okuod wiya. ");
INSERT INTO luo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","To ka ne agoyo uwi mondo okonya, noweya gi nangane, kendo oringo owuok oko.” ");
INSERT INTO luo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ka ruodhe nowinjo gima chiege owachone kuom gima jatichne osetimone, iye nowangʼ matek. ");
INSERT INTO luo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ruodh Josef nomako Josef mokete e od twech, kamane ikanoe joma otwe mag ruoth. To kane Josef ni e od twech, ");
INSERT INTO luo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Jehova Nyasaye ne ni kode; notimone kech kendo nomiyo oyudo ngʼwono e nyim jorit joma ne otwe. ");
INSERT INTO luo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kuom mano jaduongʼ mar od twech noketo Josef jatend joma otwe duto e od twech kendo Josef ema norito gik moko duto mane itimo kanyo. ");
INSERT INTO luo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Jarit joma ni e od twech ne ok odewo rango gimoro amora mane oseketo e lwet Josef, nikech Jehova Nyasaye ne ni kod Josef kendo nogwedhe e gimoro amora mane otimo. ");
INSERT INTO luo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Bangʼ ndalo moko jagam divai kod jated makati mar Farao ruodh Misri nochwanyo ruoth. ");
INSERT INTO luo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Mirima nomako Farao gi jotichge ariyogo, ma gin jotend jagam divai kod jatend joma tedo makati. ");
INSERT INTO luo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Kendo noketogi e od twech kama jatend askeche mar od twech notweyoe Josef. ");
INSERT INTO luo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Jatend askeche noketogi e lwet Josef mondo oritgi. Bangʼ kane gisebedo e od twech kuom kinde moko, ");
INSERT INTO luo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","moro ka moro kuom ji ariyogi mane gin jatend jogam divai kod jatend joted makati mar ruodh Misri mane oyudo otwe, noleko lek otienono moro ka moro, kendo lek ka lek ne nigi tiende mopogore gi machielo. ");
INSERT INTO luo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kane Josef obiro irgi kinyne gokinyi, noneno ka chunygi ool. ");
INSERT INTO luo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Kuom mano nopenjo jatich Farao mane ni kode e od twechgo niya, “Angʼo ma omiyo uol kawuono?” ");
INSERT INTO luo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Negidwoke niya, “Waduto nyoro waleko lek mopogore opogore, to onge ngʼama nyalo lokonwa tiendgi.” Eka Josef nowachonegi niya, “Donge fwenyo tiend lek aa mane kuom Nyasaye? Emomiyo yieuru unyisa lekugo.” ");
INSERT INTO luo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kuom mano jatend jogam Divai nonyiso Josef lek mane oleko. Nowachone niya, “E lekna nende aleko ni aneno yadh mzabibu e nyima, ");
INSERT INTO luo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","kendo e yadh mzabibuno ne nitie bede adek. Kane ochako loth, nogolo thiepene kendo neginyago mzabibu mochiek mana gikanyono. ");
INSERT INTO luo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kikombe Farao ne ni e lweta, kendo nakawo olembe mag mzabibu mi abiyogi e kikombe mar Farao kendo aketo kikombe e lwete.” ");
INSERT INTO luo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josef nowachone niya, “Ma e tiend lek mane ilekono. Bede yadh mzabibu adekgo nyiso ndalo adek. ");
INSERT INTO luo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Bangʼ ndalo adek Farao biro gonyi kendo dwoki e tiji, kendo ibiro keto kikombe Farao e lwete mana kaka yande kitimo kane in jatingʼ divai mare. ");
INSERT INTO luo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","To ka gik moko duto otimoreni maber, ipara kendo itimna ngʼwono; iwuona gi Farao mondo ogola e od twech. ");
INSERT INTO luo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nikech nomaka githuon ka igola e piny jo-Hibrania, kendo kata mana kaonge gima rach ma asetimo manyalo miyo abedie od twech ka.” ");
INSERT INTO luo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kane jatend joted makati oneno ni Josef oloko tiend lek maber, nowachone Josef niya, “An bende ne aleko kama: Atonge adek mag makati ne ni e wiya. ");
INSERT INTO luo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ei atonga mamalo ne nitie chiemo duto motedi ni Farao, to winy ne chamogi ei atonga mamalono.” ");
INSERT INTO luo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Josef nowachone niya, “Ma e tiend leknino. Atonge adek nyiso ndalo adek. ");
INSERT INTO luo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Kapok okadho ndalo adek Farao biro golie od twech, kendo obiro ngʼado wiyi oko manolieri e yath kendo winy biro chamo ringri.” ");
INSERT INTO luo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Koro odiechiengʼ mar adek ne en odiechieng rapar mar nywol Farao, kendo noloso nyasi ne jotije duto. Nogonyo jatend jogam divai kod jatend joted makati moketogi e nyim jodonge. ");
INSERT INTO luo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Nodwoko jatend jogam divai e tije, mondo omi ochak oket kikombe e lwet Farao, ");
INSERT INTO luo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","to jatend joted makati nonego, mana kaka Josef noselokonegi tiend lekgi. ");
INSERT INTO luo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","To kata kamano jatend jogam divai ne ok oparo Josef; wiye nowil kode. ");
INSERT INTO luo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Kane higni ariyo osekadho, Farao noleko lekni ochungʼ e bath aora Nael, ");
INSERT INTO luo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","kendo noneno dhok abiriyo mabeyo machwe kawuok ei aora kakwayo e kind odundu. ");
INSERT INTO luo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Bangʼ mano noneno dhok abiriyo mamoko maricho modhero kowuok ei aora Nael, kendo kochungʼ e bath mago mabeyo. ");
INSERT INTO luo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","To dhok maricho kendo modherogo nochamo dhok mabeyo machwego. Eka Farao nochiewo. ");
INSERT INTO luo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nindo nochako otere mi ochako oleko lek machielo ni noneno wiye abiriyo mag cham machwe kendo beyo kochiek e tiangʼ achiel. ");
INSERT INTO luo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Bangʼ mano wi cham moko abiriyo motho kendo ma yamb oro otwoyo nowuok ewi tiangʼno. ");
INSERT INTO luo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Wiye cham abiriyo mothogo nomwonyo wiye cham abiriyo machwe ka. Eka Farao nochiewo, moyudo ni en mana lek. ");
INSERT INTO luo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kinyne gokinyi pache nochandore, kuom mano nooro mondo oluongne ajuoke duto kod jorieko duto mag Misri. Farao nonyisogi lekne, to onge ngʼato angʼata mane nyalo lokone tiend lekgo. ");
INSERT INTO luo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Eka jatend jogam divai nowacho ne Farao niya, “Aparo kethona kawuono. ");
INSERT INTO luo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Chiengʼ moro kane iyi owangʼ kod wan ma jotichni, kendo ne irwakowa e od twech kaachiel gi jatend joted makati e od jatend askeche. ");
INSERT INTO luo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Waduto ne waleko lek otieno moro achiel, kendo lek ka lek ne nigi tiende. ");
INSERT INTO luo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","To ne nitie ja-Hibrania moro matin kodwa, jatich jaduongʼ askeche. Ne wanyise lekwa, kendo nolokonwa tiendgi, ka omiyo ngʼato ka ngʼato tiend lekne. ");
INSERT INTO luo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Kendo notimore mana kaka ne olokonwa tiendgi kama: An niduoka e tija, to jatend joted makati nolierie yath.” ");
INSERT INTO luo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kane Farao owinjo kamano nooro wach mondo okelne Josef, kendo nokel Josef mapiyo nono koa e od twech. Kane Josef oselielo yie wiye kendo oloko lepe, nobiro e nyim Farao. ");
INSERT INTO luo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao nowacho ne Josef niya, “Nende aleko lek, kendo onge ngʼama nyalo loko tiende. To asewinjo ka iwacho ni ka iwinjo lek to inyalo loko tiend lek moro amora.” ");
INSERT INTO luo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josef nodwoko Farao niya, “Ok anyal time, to Nyasaye biro dwoki kaka odwaro.” ");
INSERT INTO luo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Eka Farao nowacho ne Josef niya, “Ne aleko nine achungʼ e bath aora Nael, ");
INSERT INTO luo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","kendo dhok abiriyo mabeyo kendo machwe nowuok ei aora ka gikwayo e kind odundu. ");
INSERT INTO luo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Bangʼ-gi dhok abiriyo mamoko maricho kendo odhero nowuok. Ne pok anenoe dhok maricho kendo modhero kamano e piny Misri duto. ");
INSERT INTO luo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Dhok abiriyo maricho kendo odherogo nochamo dhok abiriyo machwe kendo mabeyo mane okwongo wuok. ");
INSERT INTO luo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","To kata bangʼ kane gisechamogi, to onge ngʼato angʼata mane nyalo yie ni gin ema gichamo dhogo; ne ginenore modhero moloyo kaka ne gin mokwongo. Bangʼe ne achiewo. ");
INSERT INTO luo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Nachako aneno e lek wiye cham abiriyo mochiek maber kadongʼ e tiangʼ achiel. ");
INSERT INTO luo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Bangʼ-gi ne achako aneno wi cham abiriyo motho kendo yamb oro otwoyo. ");
INSERT INTO luo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Wiye cham abiriyo mothogo nomwonyo wiye cham abiriyo mochiek. Ne anyiso ajuoke, to onge ngʼato mane nyalo lokona tiendgi.” ");
INSERT INTO luo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Eka Josef nowacho ne Farao niya, “Leknigo tiendgi achiel kendo gichalre. Nyasaye osenyiso gima oikore timo. ");
INSERT INTO luo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Dhok abiriyo mabeyogo gin higni abiriyo, kendo wiye cham abiriyo mochiek mabeyogo bende gin higni abiriyo; giduto gin lek achiel kendo nyiso wach achiel. ");
INSERT INTO luo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Dhok abiriyo maricho modhero mane obiro bangʼe nyiso higni abiriyo, kendo kamano e kaka wiye cham abiriyo motho ma yamb oro otwoyo; gin higni abiriyo mag kech. ");
INSERT INTO luo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“En mana kaka awachoni ni Nyasaye osenyiso Farao gima obiro timo. ");
INSERT INTO luo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Higni abiriyo biro betie ma piny Misri duto nobedie gi yiengʼo ahinya, ");
INSERT INTO luo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","to bangʼ mano higni abiriyo moko nobedie mag kech kendo wi ji nowil gi higni abiriyo mag yiengʼo e piny Misri, kendo kech noketh piny. ");
INSERT INTO luo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Higni abiriyo mag yiengʼo ok nopar, nikech kech mano luweno nobed malich miwuoro. ");
INSERT INTO luo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Gima omiyo lek nobiro ne Farao nyadiriyo en nikech Nyasaye osechano ratiro mar timo kamano. Kendo Nyasaye biro chope mapiyo. ");
INSERT INTO luo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Koro mondo Farao oyier ngʼat mariek kendo molony e gik moko duto motimo mondo okete jatend piny Misri. ");
INSERT INTO luo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Farao nyaka ket jotend gwenge e piny Misri duto mondo ochoki achiel kuom abich mag chamb Misri kuom higni abiriyo mag yiengʼo. ");
INSERT INTO luo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Nyaka gichok kendo gikan e mier madongo chiemo duto moyudi e higni abiriyo mag yiengʼogo e bwo chik Farao. ");
INSERT INTO luo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Cham-go onego okan e kuonde keno mag pinyni, mondo obi otigo e higni abiriyo mag kech mabiro mako piny Misri, mondo mi kik kech keth piny.” ");
INSERT INTO luo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Parono nonenore maber ni Farao kod jodonge duto. ");
INSERT INTO luo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kuom mano Farao nopenjo jodonge niya, “Bende wanyalo yudo ngʼato moro machal gi ngʼatni, ma Roho mar Nyasaye ni kuome?” ");
INSERT INTO luo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Eka Farao nowacho ne Josef niya, “Nikech Nyasaye osenyisi wechegi duto, onge ngʼat man-gi ngʼeyo matut kendo riek ka in. ");
INSERT INTO luo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Abiro keti jatend od ruoth kendo joga duto biro winjo chikni kendo kom duongʼ mar ruoth ema nobed maduongʼ moloyi.” ");
INSERT INTO luo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kuom mano Farao nowacho ne Josef niya, “Ne, koro aseketi jatend piny Misri duto.” ");
INSERT INTO luo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Eka Farao nogolo tere mar loch e lwete morwako e lwet Josef. Ne orwako ne Josef law mayom mar duongʼ miluongo ni bafta kendo orwako ne tigo mar dhahabu e ngʼute. ");
INSERT INTO luo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Nomiyo oidho gach ruoth mar ariyo mar loch, kendo joritne nogoyo koko nyime kawacho niya, “Yawneuru e yo!” Kuom mano Josef noket jatend piny Misri duto. ");
INSERT INTO luo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Eka Farao nomiyo Josef teko kowachone niya, “An e ruoth, kendo onge ngʼama notim gimoro kata nodonji e piny Misri ma ok in ema iyiene.” ");
INSERT INTO luo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao nochako Josef ni Zafenath-Panea kendo nomiye Asenath nyar Potifera jadolo mar On (ma nyinge machielo en Eliopolis), mondo obed chiege. Kendo Josef nowuotho e piny Misri duto. ");
INSERT INTO luo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josef ne en ja-higni piero adek kane ochako tich mane Farao ruodh Misri omiye. Kendo Josef nowuok ir Farao mowuotho e piny Misri duto. ");
INSERT INTO luo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","E kinde mag higni abiriyo mag yiengʼo, piny nochiek ahinya. ");
INSERT INTO luo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Josef nochoko chiemo duto mane ochiek e higni abiriyo mag yiengʼo e piny Misri kendo okanogi e mier madongo. Nokano cham mochiek e puothe molworogi e dala ka dala maduongʼ. ");
INSERT INTO luo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Josef nokano cham mathoth mana ka kuoyo mane dho nam; ne githoth mane ok onyal kwano nikech negikadho akwana. ");
INSERT INTO luo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kane pok higni mag kech ochopo, Asenath nyar Potifera ma jadolo mar On nonywolone Josef yawuowi ariyo. ");
INSERT INTO luo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josef nochako wuode makayo ni Manase kendo nowacho niya, “Ma en nikech Nyasaye osemiyo wiya owil gi chandruokna duto kod jood wuora duto.” ");
INSERT INTO luo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Wuowi mar ariyo nochako ni Efraim kendo nowacho niya, “Ma en nikech Nyasaye osemiyo anya e piny mar chandruokna.” ");
INSERT INTO luo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Higni abiriyo mag yiengʼo e piny Misri norumo, ");
INSERT INTO luo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","kendo higni abiriyo mag kech nochakore, mana kaka Josef nosewacho. Ne nitie kech e pinje mamoko, to piny Misri duto ne nitie chiemo. ");
INSERT INTO luo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ka kech nodonjo e piny Misri duto, ji noywak ne Farao mondo omigi chiemo. Eka Farao nonyiso jo-Misri duto niya, “Dhiuru ir Josef kendo utim gima owachonu.” ");
INSERT INTO luo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kane kech koro oselandore e piny duto, Josef noyawo deche duto kendo nouso cham ne jo-Misri, nikech kech ne lich ahinya e pinyno Misri duto. ");
INSERT INTO luo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Kendo pinje duto nobiro Misri mondo ongʼiew chiemo kuom Josef, nikech kech ne ngʼeny ahinya e piny mangima. ");
INSERT INTO luo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kane Jakobo owinjo ni cham yudore e piny Misri, nowacho ne yawuote niya, “Angʼo ma omiyo ubet urangoru aranga?” ");
INSERT INTO luo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nodhi nyime kowachonegi niya, “asewinjo ni nitie cham e piny Misri. Dhiuru kuno kendo ungʼiewnwa cham, mondo mi wabed mangima kendo kech kik negwa.” ");
INSERT INTO luo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Eka owete Josef apar nodhi Misri mondo odhi ongʼiew cham. ");
INSERT INTO luo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","To Jakobo ne ok ooro Benjamin mowadgi Josef hie kodgi nikech noluor ni dipo ka gimoro ohinye. ");
INSERT INTO luo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kuom mano yawuot Jakobo kaachiel gi jo-Kanaan nodhi ngʼiewo cham nikech kech momako pinygi. ");
INSERT INTO luo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","To Josef ma jatend pinyno ema ji moa e pinje duto ne biro rundo kuome. Kuom mano, kane owete Josef ochopo, negikulore ne Josef nyaka e lowo. ");
INSERT INTO luo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Kane Josef oneno owetene, nofwenyogi to nowuondore mondo kik gingʼeye. Kendo nowuoyo kodgi gi gero kopenjogi niya, “Ua kanye?” To negidwoke niya, “Waa e piny Kanaan mondo wabi warund chiemo.” ");
INSERT INTO luo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Kata obedo ni Josef nofwenyo owetene, gin to ne ok gifwenye. ");
INSERT INTO luo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Eka noparo lek mane oleko kuomgi kendo nowachonegi niya, “Un okwach kich! Kendo usebiro mondo une-ane kama pinywa nyapgodo.” ");
INSERT INTO luo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","To negidwoke niya, “Ooyo ruodha. Jotichgi obiro mana mondo orund chiemo. ");
INSERT INTO luo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Waduto wan yawuot ngʼat achiel. Jotichgi gin joma kare, ma ok okwach kich.” ");
INSERT INTO luo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","To Josef nomedo wachonegi niya, “Ooyo! Usebiro mana ni mondo ungʼe kama pinywa nyapgodo.” ");
INSERT INTO luo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","To negiwacho niya, “Ruoth, jotichni ne yawuowi apar gariyo, yawuot ngʼat achiel, wadak e piny Kanaan. Owadwa ma chogo nyo odongʼ gi wuonwa, to achiel to ne olal.” ");
INSERT INTO luo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Josef nowachonegi niya, “En mana kaka ne awachonu: Un okwach kich! ");
INSERT INTO luo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Kendo ma e kaka ibiro temu: Akwongʼora e nying Farao ni ok unuwuok ka makmana ka ukelo owadu ma chogo ka. ");
INSERT INTO luo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Oruru achiel kuom oweteu mondo odhi oom owadu; to joma odongʼ ibiro kano e od twech, mondo mi wane anena ka weche ma uwacho gin adier. To ka ok gin adier, to akwongʼora gi nying Farao, ni un okwach kich!” ");
INSERT INTO luo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kendo noketogi duto e od twech kuom ndalo adek. ");
INSERT INTO luo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Odiechiengʼ mar adek, Josef nowachonegi niya, “Timuru ma mondo mi udagi, nikech aluoro Nyasaye: ");
INSERT INTO luo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ka un joma kare, weuru achiel kuomu odongʼ ka, to joma odongʼ to odhiyo kendo oter cham ne joodu makoro chandore ka. ");
INSERT INTO luo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","To nyaka ukel owadu ma chogo ira, mondo omi angʼe ni uwacho adieri kendo mondo owaduni kik tho.” Kendo negitimo kamano. ");
INSERT INTO luo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Negiwacho e kindgi giwegi niya, “Adier kum ni waseyudo nikech owadwa. Ne waneno ka chunye chandore kane osayowa mondo wares ngimane to ne ok wanyal winje. Ma ema omiyo chandruogni osebironwa.” ");
INSERT INTO luo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben nodwokogi niya, “Donge ne akwerou ni kik utimne rawerano marach? To ne ok unyal winja! Koro nyaka chulnwa kuor nikech rembe.” ");
INSERT INTO luo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","To ne ok gingʼeyo ni Josef owinjo gima giwacho nikech Josef noketo ngʼama lokone wach. ");
INSERT INTO luo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Kane Josef owuok irgi, noywak ahinya, bangʼe noduogo irgi mochako wuoyo kodgi. Nokawo Simeon mi otweye e nyimgi ka gineno. ");
INSERT INTO luo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Josef nogolo chik mondo oket cham e ogundegi, odwokne ngʼato ka ngʼato pesane mane obirogo e ogunde, kendo mondo omigi gima ginyalo chamo e wangʼ yo ka gidok. Bangʼ kane osetimonegi ma, ");
INSERT INTO luo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","negiketo cham e ngʼe pundegi kendo gidhi. ");
INSERT INTO luo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Kamane gibuore gotieno, achiel kuomgi nogonyo gunde mondo omi pundane chiemo, kendo noneno pesane ka otwe e dho ogunde. ");
INSERT INTO luo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Nowacho nowetene niya, “Osedwokna pesana, eri go en e dho ogunda.” Chunygi nobwok ma gibedo moluor kagiwacho niya, “Angʼo ma Nyasaye osetimonwa ni?” ");
INSERT INTO luo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kane gibiro ir Jakobo wuon-gi e piny Kanaan, neginyise duto mane osetimorenegi. Negiwacho niya, ");
INSERT INTO luo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ngʼat ma ruodh pinyno nowuoyo kodwa mager kendo nokawowa mana ka okwach kich modhi nono pinygi. ");
INSERT INTO luo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","To ne wawachone ni, ‘Wan joma kare; ok wan okwach kich. ");
INSERT INTO luo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ne wan yawuowi apar gariyo, yawuot ngʼat achiel. Achiel kuomwa nolal, kendo ma chogo to odongʼ gi wuonwa e piny Kanaan.’ ");
INSERT INTO luo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Eka ruodhno nowachonwa ni, ‘Ma e kaka abiro ngʼeyo kata ka un joma kare: Achiel kuomu odongʼ ka kendo joma odongʼ oter chiemo ne joodu makoro chandore ka. ");
INSERT INTO luo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","To kelnauru omeru ma chogo mondo mi abed gadiera ni ok un okwach kich to un joma kare. Eka anaduoknu owadu kendo ulok ohala e pinyni.’ ” ");
INSERT INTO luo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Kane gigonyo ogundegi, ngʼato ka ngʼato noyudo ofuku mar pesane e dho gunde! Kane gineno pesago, giduto ne gibuok ahinya kaachiel gi wuon-gi. ");
INSERT INTO luo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jakobo wuon-gi nowachonegi niya, “Usemaya nyithinda. Josef onge, kendo Simeon bende onge, kendo koro Benjamin bende udwaro maya. Gik moko duto ok nikare koda!” ");
INSERT INTO luo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Eka Reuben nowacho ne wuon-gi niya, “Inyalo nego yawuota ka ok aduogoni Benjamin. Weye e lweta kendo abiro duoge.” ");
INSERT INTO luo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","To Jakobo nodwoke niya, “Wuoda ok nyal dhi kuno kodu; owadgi osetho kendo en kende ema odongʼ, ka gimoro marach otimorene e wuodhno, to ubiro miyo atho gi kuyo.” ");
INSERT INTO luo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Koro kech ne pod ger ahinya e piny. ");
INSERT INTO luo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Bangʼ kane gisechamo cham duto mane gia godo Misri, wuon-gi nowachonegi niya, “Doguru mondo udhi ungʼiewnwae chiemo moko.” ");
INSERT INTO luo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","To Juda nowachone niya, “Ngʼat cha nosiemowa matek ni, ‘Ok nachak awuo kodu ka ok ubiro gi owadu.’ ");
INSERT INTO luo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kinyalo yie mondo Benjamin odhi kodwa, to wabiro dhi mondo wadhi warund cham. ");
INSERT INTO luo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","To ka ok iore, to ok wabi dhi, nikech ngʼatno nowachonwa ni, ‘Ok abi chak awuo kodu ka ok ubiro gi owadu.’ ” ");
INSERT INTO luo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel nopenjogi niya, “Angʼo ma omiyo ukelona chandruogni ka unyiso ngʼatno ni un kod owadu moro?” ");
INSERT INTO luo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","To negidwoke niya, “Ngʼatno nopenjowa ahinya kuomwa wawegi kendo kuom joodwa. Nopenjowa ni, ‘Bende wuonu pod ngima? Bende un gi owadu machielo?’ Ne wadwoke mana gik mane openjowa. Ere kaka dine wangʼe ni obiro wachonwa ni, ‘Dhi ukel owaduno ka’?” ");
INSERT INTO luo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Eka Juda nowacho ne Israel wuon mare niya, “We wawuogi kendo adhi gi wuowini, mondo omi wan kod in kod nyithindwa kik kech negwa. ");
INSERT INTO luo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","An awuon asingora ni abiro rite kendo en e lweta. Ka ok aduoge iri ka, to ikwana kaka jaketho e ndalo duto mag ngimana. ");
INSERT INTO luo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ka debed ni ok waseketho kinde, dine wasedhi ma waduogo diriyo.” ");
INSERT INTO luo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Eka Israel wuon-gi nowachonegi niya, “Ka en ni nyaka obed kamano, to timuru kama. Keturu gik moko mabeyo mag pinyni e ogundeu kendo utergi ne ngʼatno kaka mich; ma gin yiende moko, gi mor kich gi gik mangʼwe ngʼar gi mane-mane kod oyungu. ");
INSERT INTO luo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kawuru pesa moromo rundo nyadiriyo, nikech nyaka uduoki pesa mane oket ei ogundeu. Nyalo bedo ni mano nobothnigi. ");
INSERT INTO luo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kawuru owadu kendo udhi ir ngʼatno piyo. ");
INSERT INTO luo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kendo mad Nyasaye Maratego timnu ngʼwono e nyim ngʼatno mondo mi owe owadu kod Benjamin mondo oduog kodu. To an to kochuno ni nyaka abed mokuyo to abiro kuyo.” ");
INSERT INTO luo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kuom mano jogo nokawo mich kod pesa moromo rundo nyadiriyo, kod Benjamin bende. Negireto mapiyo nono ka gidhi Misri kendo negidhi ir Josef. ");
INSERT INTO luo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kane Josef oneno Benjamin kani kodgi, nowacho ne jarit ode niya, “Kaw jogi iter oda, yangʼnegi chiayo kendo ilosnegi chiemo mondo gichiem koda sa auchiel.” ");
INSERT INTO luo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Jarit notimo mana kaka Josef nokone kendo notero jogo nyaka e od Josef. ");
INSERT INTO luo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","To jogo ne luoro omako kane otergi e od Josef. Negiparo niya, “Osekelwa ka nikech pesa ma wayudo koduok e ogundewa, chiengʼ mane wabiro kae mokwongo. Odwaro ni mondo oichwa kendo olowa mondo mi oketwa wasumbini, bangʼe okaw pundewa.” ");
INSERT INTO luo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kuom mano negidhi ir jarit od Josef kendo giwuoyo kode e dhoot. ");
INSERT INTO luo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Negiwachone niya, “Jaduongʼ ne wabiro ka mokwongo ngʼiewo cham. ");
INSERT INTO luo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","To kamane wabuoroe gotieno ne wagonyo gundewa kendo ngʼato ka ngʼato kuomwa noyudo pesane mana kaka ne wabiro kodgi e dho ogunde. Kuom mano waseduogogi. ");
INSERT INTO luo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Bende wasebiro gi pesa moko mondo wangʼiew godo chiemo. Ok wangʼeyo ngʼama noketo pesa e gundewa.” ");
INSERT INTO luo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Nowacho niya, “Mano ber. Kik uluor. Nyasaye ma Nyasach wuonu, osedwokonu pesau e gundeu; to pesa mane ungʼiewgo cham ira, an godo.” Eka ne okelonegi Simeon. ");
INSERT INTO luo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Jarit notero jogo e od Josef, nomiyogi pi mondo giluokgo tiendgi kendo pundegi bende nomiyo chiemo. ");
INSERT INTO luo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Negiiko mich mane gibiro godo mondo gi dhi gimi Josef sa auchiel, nikech negisewinjo ni gidhi chiemo kode. ");
INSERT INTO luo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Kane Josef odwogo dala, negimiye mich mane gikelone, kendo negikulore e nyime nyaka e lowo. ");
INSERT INTO luo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Josef nopenjogi kaka gidhi eka nowachonegi niya, “Jaduongʼ ma wuonu mane uwachona wach kuome ni nade? Bende pod ongima?” ");
INSERT INTO luo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Negidwoke niya, “Jatichni ma wuonwa pod ngima kendo odhi maber.” Kendo negikulorene ka gimiyogo duongʼ. ");
INSERT INTO luo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kane orango ma oneno owadgi Benjamin, wuod min-gi hie, nopenjogi niya, “Ma e owadu ma chogo, mane uwachona wachne?” Kendo nomedo wacho niya, “Nyasaye mad gwedhi wuoda.” ");
INSERT INTO luo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ne mirima omake ka oneno Benjamin owadgi. Josef noreto kadhi oko kendo orango kamane onyalo pondoe ka oywak. Nodonjo e kachiende kendo ne oywak kuno. ");
INSERT INTO luo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Bangʼ kane oseluoko wangʼe, noduogo kendo ka otemo oore nowacho niya, “Chiemuru.” ");
INSERT INTO luo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Negitokone chiembe kende, owetene kendgi, kendo jo-Misri mane chiemo kode bende nomi chiembgi kendgi, nikech jo-Misri ne ok nyal chiemo gi jo-Hibrania, nimar mano en gima kwero ne jo-Misri. ");
INSERT INTO luo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Owete Josef nobet e mesa e nyime kaluwore kaka nywolgi nobet, chakre wuowi maduongʼ nyaka wuowi matin kendo e kinde mane gibet kamano chunygi noparore. ");
INSERT INTO luo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Kane omigi chiemo koa e mesa mar Josef, chiemb Benjamin ne ngʼeny moloyo mar ngʼato angʼata nyadibich. Kuom mano negichiemo kendo gimetho ka gin thuolo kode. ");
INSERT INTO luo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Josef nomiyo jarit ode chik niya, “Ket cham mathoth e gunde jogo ma ginyalo tingʼo, kendo itwe pesa e dho ogund ngʼato ka ngʼato. ");
INSERT INTO luo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Bangʼe to iso kikombena mar mula ei ogund wuowi matin kaachiel gi pesa mar rundo.” Kendo jarit od Josef notimo kaka Josef nowachone. ");
INSERT INTO luo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kinyne kogwen, jogo nokawo pundegi kendo negiwuok. ");
INSERT INTO luo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Kane pok gidhi mabor gi dala Josef nowacho ne jatichne niya, ring ilaw joka piyo, kendo ka imakogi, wachnegi niya, “Angʼo ma omiyo uchulo rach kar ber? ");
INSERT INTO luo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Donge ma e okombe ma ruodha metho godo kendo otiyogo kuom koro wach? Gima utimoni en gima rach.” ");
INSERT INTO luo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","E kinde manochopo irgi, nonuoyonegi wechegi. ");
INSERT INTO luo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","To negiwachone niya, “Angʼo ma omiyo ruodha wacho gigo? Jotichgi bor gi tim ma kamano! ");
INSERT INTO luo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Donge ne waduogonu kata mana pesa mane wayudo e ogundewa kane waa e piny Kanaan. Koro ere gima dimi wakwal fedha kata dhahabu e od ruodhi? ");
INSERT INTO luo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ka diyude kuom jatichni moro amora, to obiro tho; kendo joma odongʼ biro bedo wasumb ruodha.” ");
INSERT INTO luo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Nowacho niya, “Mano ber, obed mana kaka uwachono. Ngʼato angʼata manoyud kode nobed misumbana, to joma odongʼ nobed thuolo.” ");
INSERT INTO luo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ngʼato ka ngʼato noyieyo ogunde piny e ngʼe pundegi kendo ogonyo. ");
INSERT INTO luo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Eka ne jarit ochako menyo kochako gi wuowi maduongʼ kendo otieko gi wuowi matin kendo kikombe noyudi ei ogund Benjamin. ");
INSERT INTO luo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kane gineno mano ne giyiecho lepgi, eka ne giyieyo pundegi kendo gidok dala Josef. ");
INSERT INTO luo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Josef pod ne ni e ot kane Juda kod owetene odonjo, kendo negipodho auma e nyime. ");
INSERT INTO luo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Josef nowachonegi niya, “Ma en angʼo ma usetimoni? Donge ungʼeyo ni ngʼato kaka an nyalo fwenyo gimoro gi yor koro?” ");
INSERT INTO luo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda nodwoke niya, “Dwa wach angʼo ne ruodha? Dwa wach angʼo? Ere kaka wanyalo nyiso jatichwa? Nyasaye oseelo richo jatichni. Koro wan wasumbi ruodha; wan wawegi kod ngʼatno moseyud kikombeni kuome.” ");
INSERT INTO luo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","To Josef nowacho niya, “Abor gi timo gima kamano! Mana ngʼatno mane oyudi gi kikombena ema biro bet misumbana. Ji modongʼ duto doguru ir wuonu gi kwe.” ");
INSERT INTO luo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Eka Juda nodhi ire kendo owachone niya, “Yaye ruodha, yie mondo jatichni owuo kodi. Kik ikech gi jatichni kata obedo ni tekoni mar loch romre gi mar Farao owuon. ");
INSERT INTO luo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ruodha nopenjo jotichne ni, ‘Bende un gi wuonu kata owadu?’ ");
INSERT INTO luo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kendo ne wadwoke ni, ‘Wan kod wuonwa to oti, kendo nitie wuowi matin mane onywolo ka oti. Owadgi wuowino ne osetho kendo en e wuod min-gi kende modongʼ, kendo wuon-gi ohere.’ ");
INSERT INTO luo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“To ne iwacho ni jotichni ni, ‘Keleuru ka mondo anene an awuon.’ ");
INSERT INTO luo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Kendo ne wawachone ruodha ni, ‘Rawerano ok nyal weyo wuon-gi! Ka oweye to wuon-gi biro tho.’ ");
INSERT INTO luo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","To ne iwachone jotichni ni, ‘Ka ok ubiro gi owadu matin, to ok unuchak une wangʼa kendo.’ ");
INSERT INTO luo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kane wadok ir wuonwa ma jatichni, ne wanyise gima ruodha osewacho. ");
INSERT INTO luo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Eka wuonwa nowacho ni, ‘Doguru mondo udhi ungʼiew chiemo moko kendo.’ ");
INSERT INTO luo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","To ne wawachone ni, ‘Ok wanyal dhi. Wanyalo mana dhi ka owadwa matin dhi kodwa. Ok wanyal neno wangʼ ngʼatno makmana ka owadwa matin ni kodwa.’ ");
INSERT INTO luo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Jatichni ma wuonwa nowachonwa ni, ‘Ungʼeyo ni chiega nonywolona yawuowi ariyo. ");
INSERT INTO luo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Achiel ne olal, kendo ne awacho niya, “Adier osekidhe matindo tindo.” Kendo pok achak anene. ");
INSERT INTO luo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ka ukawo owadgi bende ma gimoro dhi ohinye, to di umi chunya chandruok ma atho ka an gi kuyo to aseti.’ ");
INSERT INTO luo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Koro ka wadok ir wuonwa ma misumbani ka wuowini mangimane omakore kode onge to obiro tho, ");
INSERT INTO luo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","kendo dimi jotichni mi wuon-gi chuny lit ma otho ka en gi kuyo to oseti. ");
INSERT INTO luo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Jatichni nosingore ne wuon-gi ni nodwok wuowino kangima. Ne awacho ni, ‘Ne akwongʼora ni ka ok aduogo wuowini iri kangima to anabed jaketho e nyimi ndalo duto mag ngimana!’ ");
INSERT INTO luo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Koro asayi, we jatichni odongʼ ka kaka misumba ruoth kar wuowini kendo iwe wuowini odogi gowetene. ");
INSERT INTO luo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ere kaka dadog ir wuora ka wuowini ok ni koda? Ooyo! Kik iwe ane chandruok ma dimak wuora.” ");
INSERT INTO luo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Josef ne ok nyal gengʼo mirima mane en-go e nyim joma ne tiyone. Kendo noywak matek niya, “Goluru ngʼato angʼata oko e nyima!” Kuom mano ne onge ngʼato angʼata mane nigi Josef kane ohulore ne owetene. ");
INSERT INTO luo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Kendo noywak matek ma jo-Misri nowinje, kendo jood Farao bende nowinjo wachno. ");
INSERT INTO luo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josef nowacho ne owetene niya, “An Josef! Bende wuora pod ngima?” To owetene ne ok nyal dwoke, nikech luoro nomakogi ahinya e nyim Josef. ");
INSERT INTO luo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Eka Josef nowacho ne owetene niya, “Biuru machiegni buta.” Kane gisetimo kamano, nowachonegi niya, “An owadu Josef mane uuso e piny Misri! ");
INSERT INTO luo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","To koro, kik chunyu chandre kendo kik ucharu nine uusa ka nikech Nyasaye noora motelonu mondo ares ngimau.” ");
INSERT INTO luo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kuom higni ariyo kech osebedo e piny, kendo kuom higni abich mabiro pur kata keyo ok nobedie. ");
INSERT INTO luo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Nyasaye noora motelonu mondo arit kothu modongʼ e piny kendo mondo ores ngimau gi resruok maduongʼ. ");
INSERT INTO luo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Kuom mano, ok un ema ne uora ka to Nyasaye ema ne oora. En ema noketo abedo wuon Farao, ruoth mar ode duto kendo jatelo mar jo-Misri duto. ");
INSERT INTO luo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Koro returu piyo udog ir wuora kendo uwachne ni, ‘Ma e gima Josef wuodi owacho: Nyasaye oseketa ruoth mar piny Misri duto. Bi ira; kendo kik ideki. ");
INSERT INTO luo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ibiro dak e piny Goshen kendo machiegni koda; ma en in gi nyithindi, nyikwayi, jambi, dhogi kod gik moko duto ma in-go. ");
INSERT INTO luo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Abiro pidhi kanyo, nikech pod nitiere higni abich mag kech mabiro. To ka ok kamano, in kod joodi duto kod giwu duto ubiro chanduru.’ ");
INSERT INTO luo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Unyalo neno un uwegi, kaachiel gi Benjamin owadwa bende, ni adier an Josef ema awuoyo kodu. ");
INSERT INTO luo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Nyisuru wuora luor ma omiya e piny Misri duto kod gik moko duto ma useneno. Kendo keluru wuora kae piyo.” ");
INSERT INTO luo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Eka Josef nokwako owadgi Benjamin, kendo noywak kendo Benjamin bende nokwake kaywak. ");
INSERT INTO luo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kendo nonyodho owetene duto kendo noywak kokwakogi. Bangʼe owetene nowuoyo kode. ");
INSERT INTO luo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Kane wach ochopo e kar dak ruoth Farao ni owete Josef osebiro, Farao kaachiel gi jotije nomor. ");
INSERT INTO luo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farao nowacho ne Josef niya, “Nyis oweteni, oyie misikegi kuom pundegi mondo gidog Kanaan, ");
INSERT INTO luo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","eka gidhi gikel wuonu kod joode duto mondo gidwog ira. Abiro miyogi kama ber moloyo e piny Misri kendo ginicham gik machiek e lopni.” ");
INSERT INTO luo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Bende asemiyi chik mondo inyisgi niya, “Kawuru geche miywayo gi punde e piny Misri mondo udhi uomgo nyithindeu gi mondeu kod wuonu kendo ubi kodgi ka. ");
INSERT INTO luo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kik uparru kuom gik maun-go e pinyu, nikech gik mabeyo mag Misri duto nobed mau.” ");
INSERT INTO luo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Omiyo yawuot Israel notimo kamano. Josef nomiyogi geche miywayo gi punde, mana kaka Farao nowachone kendo en bende nomiyogi gik mane ginyalo konyore godo e yo. ");
INSERT INTO luo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Nomiyo moro ka moro kuomgi law manyien to Benjamin nomiyo fedha mapekgi oromo kilo mia adek kod lewni mopogore opogore abich. ");
INSERT INTO luo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Kendo magi e gik mane ooro ni wuon-gi: punde apar motingʼo gik mabeyo mag Misri kod punde apar mamon motingʼo cham kod makati kod chiemo mane onyalo konyorego e wuoth ka obiro Misri. ");
INSERT INTO luo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Eka Josef nokowo owetene modhi, kendo kane koro giwuok gidhi nowachonegi niya, “Kik udhaw kendu e wangʼ yo!” ");
INSERT INTO luo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kuom mano negiwuok Misri kendo gibiro Kanaan ir Jakobo wuon-gi. ");
INSERT INTO luo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Neginyiso Jakobo niya, “Josef pod ngima kendo koro en e ruodh Misri duto.” Jakobo ne dhoge omoko, mi ok noyie gi wachgino. ");
INSERT INTO luo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","To kane giwachone gik moko duto mane Josef osewachonegi kendo kane oneno geche mane Josef oseoro mondo odhi otere ire, chuny Jakobo wuon-gi noduogo. ");
INSERT INTO luo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Kendo Israel nowacho niya, “Ayie ni Josef wuoda pod ngima. Abiro dhi mondo anene kapok atho.” ");
INSERT INTO luo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Kuom mano Israel nowuok kod gige duto, kendo kane ochopo Bersheba, notimo misango ne Nyasach Isaka wuon-gi. ");
INSERT INTO luo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kendo Nyasaye nowuoyogi Israel e fweny gotieno kendo owachone niya, “Jakobo! Jakobo!” Nodwoke niya, “Antie.” ");
INSERT INTO luo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Nyasaye nowachone niya, “An Nyasaye ma Nyasach wuonu. Kik iluor dhi Misri, nikech anami ibedi oganda maduongʼ kuno. ");
INSERT INTO luo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Abiro dhi kodi Misri kendo nachak aduogi ka adier kendo Josef ema noyuo wangʼi sa thoni.” ");
INSERT INTO luo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Eka Jakobo nowuok Bersheba, kendo yawuot Israel noketo wuon-gi kod nyithindgi, kod mondgi e geche mane Farao oseorone. ");
INSERT INTO luo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Negikawo jambgi kod mwandugi mane giseyudo e piny Kanaan, kendo Jakobo kod nyikwaye duto nodhi Misri. ");
INSERT INTO luo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Nodhi Misri gi yawuote gi nyige kod nyikwaye ma yawuowi kod ma nyiri. ");
INSERT INTO luo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Magi e nying yawuot Israel (ma tiende ni Jakobo kod nyikwaye) mane odhi Misri. Reuben ema ne wuod Jakobo makayo. ");
INSERT INTO luo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Yawuot Reuben ne gin: Hanok, Palu, Hezron kod Karmi. ");
INSERT INTO luo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Yawuot Simeon ne gin: Jemuel, Jamin, Ohad, Jakin, Zohar kod Shaul mane wuod nyar Kanaan. ");
INSERT INTO luo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Yawuot Lawi ne gin: Gershon, Kohath kod Merari. ");
INSERT INTO luo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yawuot Juda ne gin: Er, Onan, Shela, Perez kod Zera (to Er kod Onan ne otho e piny Kanaan). Yawuot Perez ne gin: Hezron kod Hamul. ");
INSERT INTO luo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Yawuot Isakar ne gin: Tola, Pua, Jashub kod Shimron. ");
INSERT INTO luo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Yawuot Zebulun ne gin: Sered, Elon kod Jalel. ");
INSERT INTO luo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Magi e yawuowi mane Lea onywolo ne Jakobo e piny mar Padan Aram, ka ok okwan Dina nyare. Yawuote kod nyige duto ne piero adek gadek. ");
INSERT INTO luo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Yawuot Gad ne gin: Zefon, Hagi, Shuni, Ezbon, Eri, Arodi kod Areli. ");
INSERT INTO luo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Yawuot Asher ne gin: Imna, Ishva, Ishvi kod Beria. Nyamin-gi ne en Sera. Yawuot Beria ne gin: Heber kod Malkiel. ");
INSERT INTO luo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Magi e nyithindo mane Zilpa, jatich mane Laban omiyo nyare Lea onywolo ne Jakobo. Giduto ne gin nyithindo apar gauchiel. ");
INSERT INTO luo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yawuot Rael chi Jakobo ne gin: Josef kod Benjamin. ");
INSERT INTO luo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Asenath nyar Potifera, jadolo mar On nonywolone Josef Manase kod Efraim e piny Misri. ");
INSERT INTO luo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Yawuot Benjamin ne gin: Bela, Beker, Ashbel, Gera, Naaman, Ehi, Rosh, Mupim, Hupim kod Ard. ");
INSERT INTO luo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Magi e yawuowi mane Rael onywolone Jakobo. Giduto ne gin ji apar gangʼwen. ");
INSERT INTO luo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Wuod Dan ne en Hushim. ");
INSERT INTO luo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Yawuot Naftali ne gin: Jaziel, Guni, Jezer kod Shilem. ");
INSERT INTO luo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Magi e yawuowi mane Bilha, jatich mane Laban omiyo Rael nyare onywolone Jakobo. Giduto ne gin ji abiriyo. ");
INSERT INTO luo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ji duto mane odhi gi Jakobo Misri, tiende ni nyithinde hie ka ok okwan mond yawuote ji piero auchiel gi auchiel. ");
INSERT INTO luo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Joka Jakobo duto mane odhi Misri ne gin ji piero abiriyo koriwore gi yawuowi ariyo mane Josef onywolo Misri. ");
INSERT INTO luo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Omiyo Jakobo nooro Juda mondo odhi ir Josef mondo obi oromnegi ka gidhi Goshen. Kane gichopo e gwengʼ mar Goshen, ");
INSERT INTO luo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josef noiko gache kendo oikore mar dhi Goshen mondo odhi oromne wuon-gi Israel. Kane Josef ochopo ire, nokwako wuon-gi kendo oywak kuom kinde malach. ");
INSERT INTO luo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel nowacho ne Josef niya, “Koro kata ka atho, to onge wach, nikech aseneno an awuon ni kara pod ingima.” ");
INSERT INTO luo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Eka Josef nowacho ne owetene kod jood wuon mare duto niya, “Abiro dhi mondo awuo gi Farao kendo abiro wachone ni, ‘Owetena kod jood wuora duto mane odak e piny Kanaan osebiro ira. ");
INSERT INTO luo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Jogi gin jokwath; gikwayo jamni, kendo gisebiro kod kwethgi kod dhogi kod gigegi duto.’ ");
INSERT INTO luo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ka Farao oluongou kendo openjou ni, ‘Utiyo angʼo?’ ");
INSERT INTO luo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","to nyaka uwachne ni, ‘Jotichgi osebedo jokwath chakre tindowa, mana kaka kwerewa notimo.’ Eka ibiro yienu mondo udag e gwengʼ Goshen, nikech jo-Misri ok ohero jokwath.” ");
INSERT INTO luo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Josef nodhi monyiso Farao niya, “Wuora kod owetene osebiro koa e piny Kanaan kod kwethgi kod dhogi kod gik moko duto ma gin-go kendo koro gidak e piny Goshen.” ");
INSERT INTO luo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Josef nokawo owetene abich kendo okelo e nyim Farao. ");
INSERT INTO luo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao nopenjo owete Josef-go niya, “Utiyo angʼo?” Negidwoko Farao niya, “Jotichgi gin jokwath.” ");
INSERT INTO luo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Negimedo wachone niya, “Wasebiro mondo wadag e pinyni matin, nikech kech ger e piny Kanaan maonge kata mana lum ma jamb jotichni dikwae. Kuom mano, koro yie jotichgi odag e gwengʼ Goshen.” ");
INSERT INTO luo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Farao nowacho ne Josef niya, “Wuonu kod oweteni osebiro iri, ");
INSERT INTO luo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","kendo piny Misri ni e lweti, ket wuonu kod oweteni odag kama berie moloyo. We gidag Goshen kendo ka ingʼeyo moko kuomgi man kod mich mar kwath ketgi mondo gibed jorit jamba.” ");
INSERT INTO luo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Eka Josef nokelo Jakobo wuon mare kendo okete e nyim Farao. Ka Jakobo nosegwedho Farao, ");
INSERT INTO luo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao nopenje niya, “In ja-higni adi?” ");
INSERT INTO luo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Kendo Jakobo nodwoko Farao niya, “Higni ma asewuothogo e piny gin higni mia achiel kod piero adek. Gisebedo manok kendo matek kendo ok ginyal romo gi higni mane wuora odak godo e piny.” ");
INSERT INTO luo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Eka Jakobo nogwedho Farao kendo owuok modhi. ");
INSERT INTO luo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Kuom mano Josef nomiyo wuon-gi kod owetene kuonde mabeyo e piny Misri e gwengʼ mar Rameses mana kaka Farao nochike. ");
INSERT INTO luo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Bende Josef nomiyo wuon-gi kod owetene kod jood wuon-gi duto gi chiemo kaluwore gi kar romb nyithindgi. ");
INSERT INTO luo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kata kamano, ne onge chiemo e piny duto nikech kech ne ger; piny Misri kaachiel gi piny Kanaan nobedo gi dhier malich. ");
INSERT INTO luo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Josef nochoko pesa duto mane yudore e piny Misri kod piny Kanaan kuom cham mane gingʼiewo kuome kendo noterogi e od keno mar Farao. ");
INSERT INTO luo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kane pesa jo-Misri kod jo-Kanaan orumo, jo-Misri duto nobiro ir Josef kendo owachone niya, “Miwa chiemo, dangʼ watho e nyimi nangʼo to pesawa orumo?” ");
INSERT INTO luo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Eka Josef nowachonegi niya, “Nikech pesau oserumo, keluru jambu mondo uwilgo cham mabiro miyou.” ");
INSERT INTO luo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kuom mano negikelo jambgi ne Josef kendo nomiyogi chiemo kar farese, gi rombe gi diek gi dhok kod punde. Kendo e higano, nopidhogi gi chiemo kar jambgi duto. ");
INSERT INTO luo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kane higano orumo, negidok ire e higa moluwo mano mi giwachone niya, “Ruoth ok wanyal wuondoreni nikech pesawa oserumo kendo jambwa bende osedoko magi, koro onge gima wanyalo miyi makmana ringrewa kod lopewa. ");
INSERT INTO luo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Angʼo momiyo diwatho kendo lopewa bende kethore to ineno? Ngʼiewa-wa wabed wasumbinini kaachiel gi puothewa kuom chiemo mondo mi wan kaachiel gi puothewa wabed mag Farao. Miwa kodhi mipidho mondo kik watho kendo puothewa kik kethre.” ");
INSERT INTO luo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kuom mano Josef nongʼiewo lope duto mag Misri ne Farao. Jo-Misri noloko puothegi duto pesa nikech kech ne duongʼ ahinya. Piny Misri duto nobedo mar Farao, ");
INSERT INTO luo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","kendo Josef nodaro jo-Misri e miechgi koa koni nyaka komachielo. ");
INSERT INTO luo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","To kata kamano ne ok ongʼiewo puothe jodolo nikech negiyudo pokgi mapile pile koa kuom Farao kendo ne gin gi chiemo moromogi kuom pok mane Farao miyogi. Mano ema omiyo jodolo ne ok ouso puothegi. ");
INSERT INTO luo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Josef nowacho ne jo-Misri-go niya, “Koro kaka asengʼiewou kawuononi ne Farao kaachiel gi puotheu, kodhi eri dhi ukom. ");
INSERT INTO luo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","To e ndalo mag keyo, nyaka umi Farao achiel kuom abich. To angʼwen ewi abich modongʼ unyalo kano kaka kodhi kendo kaka chiembu gi nyithindu kod joodu duto.” ");
INSERT INTO luo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Negiwachone Josef niya, “Ruoth isekonyo ngimawa, omiyo ka ineno ni mano ber to wabiro bedo wasumb Farao.” ");
INSERT INTO luo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Kuom mano Josef nokete kaka chik e piny Misri nyaka chil kawuono, ni achiel kuom abich mar cham nyaka bed mar Farao. Puothe jodolo kende ema ne ok Farao okawo. ");
INSERT INTO luo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Jo-Israel nodak Misri e gwengʼ Goshen. Negiyudo mwandu mangʼeny kuno kendo ne ginyaa mi kwan-gi omedore ahinya. ");
INSERT INTO luo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakobo nodak Misri kuom higni apar gabiriyo kendo ndalo hike duto noromo higni mia achiel gi piero angʼwen gabiriyo. ");
INSERT INTO luo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kane kinde mar tho Israel ochopo machiegni, noluongo Josef wuode kendo owachone niya, “Ka itimona ngʼwono, to yie iket lweti e kind ema kendo ikwongʼrina ni nikecha kendo ibedna ja-adiera. Kik iika e piny Misri ");
INSERT INTO luo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","to ka anindo maluwo kwerena, to gola Misri kendo idhi iyika kuma oikie kwerena.” Josef nodwoke ni, “Abiro timo kaka iwacho.” ");
INSERT INTO luo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Nowacho ne Josef niya, “Kwongʼrina.” Eka Josef nokwongʼorene, kendo Israel nolemo koyiengore e ludhe mar wuoth. ");
INSERT INTO luo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Bangʼ kinde moko Josef nowinjo wach ni wuon mare tuo, kuom mano nokawo yawuote ariyo Manase kod Efraim mondo odhi onene. ");
INSERT INTO luo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kane Jakobo owinjo wach ni Josef wuode obiro nene, nochukore mobet e kitandane. ");
INSERT INTO luo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakobo nowacho ne Josef, “Nyasaye Maratego nofwenyorena Luz e piny Kanaan, kendo kanyo ema nogwedha. ");
INSERT INTO luo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Kendo nowachona niya, ‘Abiro miyo inyaa kendo ibed gi nyithindo mangʼeny. Abiro timi oganda mar ji, kendo abiro miyo nyikwayi pinyni mondo obed girkeni manyaka chiengʼ.’ ");
INSERT INTO luo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Eka yawuoti ariyo mane inywolo e piny Misri kane pok abiro iri ka ibiro kwan kaka nyithinda; Efraim kod Manase biro bedo nyithinda mana kaka Reuben kod Simeon. ");
INSERT INTO luo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Nyithindo ma ibiro nywolo bangʼ-gi ema nobed magi; to kar chamo girkeni, nokwan-gi mana kaka joka Efraim kod Manase. ");
INSERT INTO luo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kane aduogo aa Padan, nabuok malich ka Rael minu otho e piny Kanaan kane pok wachopo Efrath. Kuom mano ne aike e bath yo madhi Efrath” (ma tiende ni Bethlehem). ");
INSERT INTO luo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Kane Israel oneno yawuot Josef nopenjo niya, “Magi ngʼa gini?” ");
INSERT INTO luo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josef nowacho ne wuon mare niya, “Gin yawuowi ma Nyasaye osemiya ka.” Eka Israel nowacho niya, “Kelgi ira ka mondo agwedhgi.” ");
INSERT INTO luo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Koro wenge Israel ne ok nyal neno maber nikech hike noniangʼ. Kuom mano Josef nosudo nyithindo machiegni kendo Israel nokwakogi monyodhogi. ");
INSERT INTO luo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel mowachone Josef niya, “Ne ok apar mar neno wangʼi kendo to koro Nyasaye oseyiena maneno nyaka nyithindi bende.” ");
INSERT INTO luo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Eka Josef nogolo nyithindogo e chong Israel kendo nokulore nyaka e lowo. ");
INSERT INTO luo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Kendo Josef nomako lwet nyithindo ariyogo, Efraim e bade korachwich kochomo bad Israel koracham, kendo Manase koracham kochomo bad Israel korachwich kendo nokelogi machiegni gi Israel. ");
INSERT INTO luo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","To Israel norieyo bade ma korachwich moketo ewi Efraim wuowi ma chogo, kendo bade ma koracham ewi Manase kata obedo ni en ema ne en wuowi maduongʼ. ");
INSERT INTO luo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Eka nogwedho Josef mowachone niya, “Mad Nyasaye ma wuonena Ibrahim kod Isaka nowuothogo, Nyasaye ma osebedo jakwadh ngimana nyaka ndaloni, ");
INSERT INTO luo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Malaika ma oseresa e chandruok duto mad gwedh raweregi. Mad nyinga kod nying Ibrahim kwara kod Isaka wuora sik kuomgi, kendo gimedre gibed oganda maduongʼ e piny.” ");
INSERT INTO luo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Kane Josef oneno ka wuon mare keto lwete ma korachwich ewi Efraim ne ok obedo mamor; kuom mano, nogolo lwet wuon-gi ewi Efraim moketo ewi Manase. ");
INSERT INTO luo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Josef nowachone niya, “Ooyo, wuora ma e wuowi ma kayo: ket lweti ma korachwich e wiye.” ");
INSERT INTO luo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","To wuon-gi nodagi mowachone niya, “Angʼeyo mano nyathina. Manase bende biro bedo oganda maduongʼ. To kata kamano owadgi matin nobed giduongʼ moloye kendo nyikwaye nobed ogendini mangʼeny.” ");
INSERT INTO luo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Nogwedhogi chiengʼno, kendo owachonegi niya, “Ka Israel dwaro gwedho ngʼato to nokonyre gi nyingu kowacho kama, ‘Mad Nyasaye gwedhi kaka osegwedho Efraim kod Manase.’ ” Kuom mano noketo Efraim obedo maduongʼ ne Manase. ");
INSERT INTO luo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Eka Israel nowacho ne Josef niya, “Koro achiegni tho, to Nyasaye biro bedo kodu kendo nodwoku e piny kwereu. ");
INSERT INTO luo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","To in, kendo kaka ngʼama duongʼne owetene, amiyi lowo mane akawo kuom jo-Amor gi ligangla kod atungʼ.” ");
INSERT INTO luo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Eka Jakobo noluongo yawuote mowachonegi niya, “Biuru machiegni mondo anyisu gima biro timorenu e ndalo mabiro. ");
INSERT INTO luo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Un yawuot Jakobo chokreuru buta kendo uchik itu; winjuru Israel wuonu. ");
INSERT INTO luo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reuben, in e wuoda makayo, kendo in e tekona kendo in e ranyisi mokwongo mar tekra, bende in giluor mangʼeny kod teko mangʼeny. ");
INSERT INTO luo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ijamuomri ka pi aora, to ok inibed gi duongʼ, nikech isedonjori, gi kitanda wuonu ma ichido. ");
INSERT INTO luo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon gi Lawi gin owete, gisetimo timbe mag lweny gi liganglagi. ");
INSERT INTO luo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ok nariwra kodgi e buchegi, ok nariwra kodgi e chokruogegi, nikech ka mirima omakogi to ginego ji kendo gingʼado odond dhok sa asaya ka gihero. ");
INSERT INTO luo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Okwongʼ mirimbgi nikech en mirima mager kendo makwiny. Anakegi e kind joka Jakobo kendo akegi e piny Israel duto. ");
INSERT INTO luo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Juda, oweteni biro paki; bende inimak wasiki gi ngʼutgi, kendo oweteni biro kuloreni. ");
INSERT INTO luo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yaye Juda nyathina, ichalo nyathi sibuor, modwogo koa dwar. Obuto ka sibuor madhako monindo piny, maonge ngʼama nyalo chiewo. ");
INSERT INTO luo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ludh duongʼ ok noa e lwet Juda kata odunga mar teko ok noa e tiende, nyaka wuon loch ma biro rito ogendini duto chopi kendo luor mar ogendini nobed kuome. ");
INSERT INTO luo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Obiro tweyo pundane e kor mzabibu, enotue nyathi pundane e mzabibu moyier; kendo obiro luoko lepe gi divai makwar. ");
INSERT INTO luo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Wangʼe nobed makwar moloyo divai kendo lake nobed matar ka chak. ");
INSERT INTO luo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulun nodag e dho nam kama yiedhi gowe, kendo tongʼ mare nodhi nyaka Sidon. ");
INSERT INTO luo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakar en punda maratego ma nindo piny e dier misikene. ");
INSERT INTO luo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kane oneno kaka dalane ber, kendo kaka pinyno ber, noyie tingʼo misigo modoko misumba matiyo tich matek. ");
INSERT INTO luo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan nobed jangʼad bura ne joge mana kaka achiel kuom oganda Israel. ");
INSERT INTO luo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan nobed ka thuol man e dir yo, thuol man-gi kwiri mager e yo, ma kayo ombongʼ Faras mondo ngʼama oidhe ochwanyre magore piny gi kangʼeye. ");
INSERT INTO luo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Aserito warruok yaye Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gad to nomonj gi jomecho, to noriembgi kolawogi matek. ");
INSERT INTO luo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asher nobed gi chiemo mamit; nobed gi chiemo moromo ruoth chamo. ");
INSERT INTO luo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali to en mwanda mogony, ma nywolo nyithindo mabeyo. ");
INSERT INTO luo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Josef en mzabibu manyago olemo mopidh e bath thidhna, ma bedene ogawore e kor ot. ");
INSERT INTO luo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Jodir asere nolawe matek kokecho, ne gibaye gi asere ka igi owangʼ. ");
INSERT INTO luo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Kata kamano, Nyasaye Maratego ma Nyasach Jakobo noturo atungegi, kendo Jakwath, ma Lwanda mar Israel, nochodo leche mag ogich bedegi. ");
INSERT INTO luo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Nyasach wuonuno ma en Nyasaye Maratego, mondo ogwedhi gi gweth mag polo gi gweth mag nyak mag lowo, gi gweth mag nyithindo. ");
INSERT INTO luo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Gweth mag wuoro dongo moloyo gweth mag gode madongo machon, kendo moloyo gik mabeyo duto mag gode mosiko. Gwethgi mondo obi ne Josef, ngʼat mane opog gi jowetene. ");
INSERT INTO luo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin en ondiek ma kech kayo; gima osenego ochamo gokinyi, kendo godhiambo okidho matindo tindo gima osemako.” ");
INSERT INTO luo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Magi e dhout Israel apar gariyo duto kendo mae gima ne wuon-gi owachonegi kane ogwedhogi, ka omiyo moro ka moro gweth moromore kode. ");
INSERT INTO luo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Eka Jakobo nochiko yawuote kowachonegi niya, “An koro achiegni tho mondo adhi ariwra gi jowetena, yikauru but kwerena e rogo man e puoth Efron ja-Hiti. ");
INSERT INTO luo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Rogo man e puodho man Makpela, machiegni gi Mamre e piny Kanaan, ema ne Ibrahim ongʼiewo kaka kar yiko kaachiel gi puodhono duto koa kuom Efron ja-Hiti. ");
INSERT INTO luo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Kanyo ema ne oike Ibrahim kod Sara chiege, kanyo bende ema ne oikie Isaka kod Rebeka chiege, kendo kanyo ema ne aikoe Lea. ");
INSERT INTO luo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Puodhono kod rogo duto mane ni e iye nongʼiew koa kuom jo-Hiti.” ");
INSERT INTO luo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Kane Jakobo osetieko wacho wechegi ni yawuote kamano nodwoko tiende e kitanda, mi chunye nochot kendo noluwo kwerene. ");
INSERT INTO luo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Josef nogore kuom wuon-gi kendo noywak kuome monyodhe. ");
INSERT INTO luo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Eka Josef nochiko jotichne ma jothieth mondo olos ringre wuon-gi, Israel gi yath. Kuom mano jothiethgo noloso ringre Jakobo. ");
INSERT INTO luo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Notieko ndalo piero angʼwen nikech mano e kaka kitundu molos gi yath idwaro mondo otieki. Jo-Misri noywage kuom ndalo piero abiriyo. ");
INSERT INTO luo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ka ndalo mag ywak noserumo, Josef nowuoyo gi jood Farao niya, “Ka unyalo timona ngʼwono, to nyisnauru Farao niya, ");
INSERT INTO luo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Kane wuora chiegni tho, nomiyo asingorane ni abiro yike e bur mane okunyo e piny Kanaan. Kuom mano yie adhi aike eka abiro duogo.’ ” ");
INSERT INTO luo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao nowachone niya, “Dhiyo mondo iyik wuonu mana kaka nomiyo isingorine.” ");
INSERT INTO luo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kuom mano Josef nodhi moyiko wuon mare. Jotich Farao duto nodhi kode, ma gin jok midewo mane tiyo e dalane kendo e piny Misri duto, ");
INSERT INTO luo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","kaachiel gi joode gi jood owetene kod jood wuon-gi. Nyithindo kod jamni gi dhok kende ema ne owe Goshen. ");
INSERT INTO luo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Joriemb geche gi Farese bende nodhi kode. Ne en gi oganda maduongʼ. ");
INSERT INTO luo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kane gichopo kar dino cham man Atad, machiegni gi Jordan, negiywago wuon-gi matek kendo malit ahinya; kendo Josef nokawo ndalo abiriyo koywago wuon-gi. ");
INSERT INTO luo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kane jo-Kanaan modak kuno oneno ywak man kar dino cham man Atad, negiwacho niya, “Jo-Misri nigi kuyo mar ywak.” Mano ema omiyo iluongo loka Jordan kono ni Abel Mizraim. ");
INSERT INTO luo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Kuom mano yawuot Jakobo notimo mana kaka nochikogi: ");
INSERT INTO luo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Negitingʼo ringre nyaka Kanaan kendo giike e rogo man e puodho man Makpela, machiegni gi Mamre, mane Ibrahim ongʼiewo kaka kar yiko kaachiel gi puodhono koa kuom Efron ja-Hiti. ");
INSERT INTO luo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Bangʼ yiko wuon-gi, Josef nodok Misri kaachiel gi owetene kod ji mamoko mane odhi kode yiko wuon-gi. ");
INSERT INTO luo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Kane owete Josef oneno ni wuon-gi osetho, negiwacho niya, “Mit ka Josef iye nowangʼ kodwa, mi ochulnwa kuor kuom richo duto mane watimone?” ");
INSERT INTO luo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kuom mano negioro wach ne Josef kagiwacho niya, “Kane pok wuonu otho noweyonwa wach niya, ");
INSERT INTO luo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Akwayi mondo iwene owetegi richogi kod gima mono mane gitimoni.’ Kuom mano yie iwenwa timbewa duto ma wasetimoni nikech wan jotich Nyasach wuonu.” To kane Josef owinjo wechego, pi wangʼe noton. ");
INSERT INTO luo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Eka owetene nobiro ire kendo ogoyo chongegi piny e nyime: Negiwachone niya, “Wan wasumbinigi.” ");
INSERT INTO luo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","To Josef nowachonegi niya, “Kik ubed maluor. An dakaw kar Nyasaye? ");
INSERT INTO luo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Un ne udwaro mondo utimna marach, to Nyasaye nodwaro mondo obed gima ber; mondo oresgo ngima ji mangʼeny, makoro ngima mana nikech wachno. ");
INSERT INTO luo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Omiyo koro kik uluor. Abiro ritou kaachiel gi nyithindu.” Kamano nokweyo chunygi kendo owuoyo kodgi gi muolo. ");
INSERT INTO luo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josef nodak Misri, kaachiel gi jood wuon-gi. Nodak higni mia achiel kod apar. ");
INSERT INTO luo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Kendo noneno nyikwa Efraim nyaka tiengʼ mar adek. Bende noneno nyithind Makir wuod Manase kinywolo mokwanogi ka nyithinde. ");
INSERT INTO luo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Eka Josef nowacho ne owetene niya, “Koro achiegni tho. To Nyasaye biro resou kendo golou e pinyni mi oteru e piny mane osingore ka okwongʼore ne Ibrahim, Isaka kod Jakobo.” ");
INSERT INTO luo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kendo Josef nomiyo yawuot Israel okwongʼore kendo owachonegi niya, “Nyasaye biro resou, kendo nyaka une ni ukawo chokena ka udhigo.” ");
INSERT INTO luo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kamano Josef notho ka en ja-higni mia achiel kod apar. Kendo bangʼ kane gisewiro ringre gi yath, negikete e sanduku e piny Misri kuno.");
INSERT INTO luo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Magi e nying jo-Israel mane odhi e piny Misri gi Jakobo, moro ka moro gi joode: ");
INSERT INTO luo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Lawi, kod Juda; ");
INSERT INTO luo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakar, Zebulun kod Benjamin; ");
INSERT INTO luo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan kod Naftali; Gad kod Asher. ");
INSERT INTO luo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Joka Jakobo duto noromo ji piero abiriyo, nikech Josef to noyudo osechopo e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Koro Josef gi owetene duto kod tiengʼno duto notho, ");
INSERT INTO luo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","to jo-Israel nonyaa kendo gimedore ahinya mi gimedo bedo oganda mathoth moloyo mane gipongʼo pinyno duto. ");
INSERT INTO luo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Bangʼe ruoth manyien mane ok ongʼeyo wach Josef nobedo e loch e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Nonyiso joge niya, “Neuru, jo-Israel osenyaa moloyowa. ");
INSERT INTO luo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Watangʼuru, nono to gibiro medore ahinya kendo bedo maratego, ma ka lweny owuok ginyalo dok ne wasikwa mondo giked kodwa, mi giring gia e pinywa.” ");
INSERT INTO luo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kuom mano, jo-Misri noketo nyipeche mondo ochun jo-Israel gi tich matek, kendo negigero Pithom gi Rameses kaka miech keno mag ruoth Farao. ");
INSERT INTO luo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","To kaka ne imedo sandgi, e kaka negimedo nyaa kendo gimedore; omiyo jo-Misri nomedo luoro jo-Israel, ");
INSERT INTO luo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","kuom mano jo-Misri nobembo jo-Israel gi tich mapek mar wasumbini. ");
INSERT INTO luo_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Negimiyo ngimagi odoko matek gi tije achuna mag nyono lowo mar matafare; e tijegi duto jo-Misri noketogi gi tich mapek mar wasumbini. ");
INSERT INTO luo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Bangʼe ruodh jo-Misri nogolo chik mondo mond jo-Hibrania ma jocholo miluongo ni Shifra kod Pua niya, ");
INSERT INTO luo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Ka ucholo mond jo-Hibrania mi uneno ka onywolo nyathi ma wuowi, to negeuru, to ka en nyathi ma nyako, to kik unege.” ");
INSERT INTO luo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","To kata kamano, jochologo noluoro Nyasaye kendo ne ok gitimo gima ruodh jo-Misri nonyisogi mondo gitim, mine ok ginego nyithindo ma yawuowi. ");
INSERT INTO luo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ruodh jo-Misri noluongo jochologo mi openjogi niya, “En angʼo momiyo utimo kama? Angʼo momiyo ok uneg nyithindo ma yawuowi?” ");
INSERT INTO luo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Jochologo nodwoko Farao niya, “Mond jo-Hibrania ok chal gi mond jo-Misri, gin giteko kendo ginywol kapok jocholo ochopo irgi.” ");
INSERT INTO luo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Kuom mano Nyasaye nogwedho jochologo, kendo jo-Israel nomedo nyaa mi odoko oganda maduongʼ. ");
INSERT INTO luo_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Nikech jochologo noluoro Nyasaye, Nyasaye nogwedhogi gi nyithindo. ");
INSERT INTO luo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Bangʼe Farao nogolo chik ne joge kowacho niya, “Nyathi ma wuowi moro amora monywol nyaka udir e aora Nael, to nyithindo ma nyiri to uwe odongi.” ");
INSERT INTO luo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ja-Lawi moro nokendo nyar ja-dhoodgi, ");
INSERT INTO luo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","mi nomako ich monywolo nyathi ma wuowi. Ka noneno ni en nyathi ma jaber, nopande kuom dweche adek. ");
INSERT INTO luo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","To ka koro ne ok onyal medo pande, nokawo osera mochwe gi togo momuono gi lowo kod odok. Bangʼe noketo nyathino ei oserano kendo noketo oserano ei odundu e tiend aora Nael. ");
INSERT INTO luo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nyamin nyathino nochungʼ gichien mondo one ane gima biro timore ni nyathino. ");
INSERT INTO luo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Eka nyar Farao nodhi e aora Nael mondo olwokre, ka jotichne to ne wuotho e geng aora. Nyar Farao noneno oserano ka ni e kind odundu, mine ooro jatichne ma nyako mondo ogeme. ");
INSERT INTO luo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ne oele mi oyudo nyathi. Nyathino ne ywak, kendo nokeche mowacho niya, “Ma en achiel kuom nyithind jo-Hibrania.” ");
INSERT INTO luo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Eka nyamin nyathino nopenjo nyar Farao niya, “Bende anyalo dhi mondo aluongni achiel kuom mond jo-Hibrania mondo opirni nyathini.” ");
INSERT INTO luo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Nyar farao nodwoke niya, “Ee, dhiyo.” Kuom mano nyakono nodhi mokelo mana min nyathino. ");
INSERT INTO luo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Nyar Farao nowachone niya, “Kaw nyathini mondo ipidhna bangʼe abiro chuli.” Omiyo dhakono nokawo nyathino kendo norite. ");
INSERT INTO luo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ka nyathino nosedongo mobedo maduongʼ nokawe motere ne nyar Farao kendo nyathino nodoko wuod nyar Farao. Nochake ni Musa kowacho niya, “Ne agole e pi.” ");
INSERT INTO luo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Kane Musa osedoko ngʼat maduongʼ, chiengʼ moro nodhi ir owetene ma jo-Israel kendo noneno kaka negitiyo tich matek. Noneno achiel kuom jo-Hibrania wetene, ka igoyo kod ja-Misri. ");
INSERT INTO luo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Nogoyo machiemo koni gi koni, kendo kane ok oneno ngʼato, nonego ja-Misrino mi oike ei kuoyo. ");
INSERT INTO luo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kinyne nodok mi oneno jo-Hibrania ariyo ka dhawo. Nopenjo ngʼat ma nokwinyo nyawadgino niya, “Marangʼo igoyo ja-Hibrania wadu?” ");
INSERT INTO luo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ngʼatno nodwoke niya, “En ngʼa ma oketi ruoth kendo jangʼadnwa bura? Iparo mar nega kaka nyoro inego ja-Misri cha?” Ka Musa nowinjo kamano, kibaji nogoye mobedo maluor koparo niya, “Gima nyoro atimo nyaka bed ni osengʼere.” ");
INSERT INTO luo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kane Farao owinjo wachno notemo mondo oneg Musa, kata kamano Musa noringo modhi odak e piny Midian, mi obet e bath soko moro. ");
INSERT INTO luo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Jadolo moro mar jo-Midian ne nigi nyiri abiriyo, negibiro tuomo pi ka giolo e karaya mondo jamb wuon-gi omodhi. ");
INSERT INTO luo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Jokwath moko nobiro mondo oriembgi, to Musa noa malo moresogi kendo nomiyo jambgi pi omodho. ");
INSERT INTO luo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Bangʼe kane nyirigo odok ir Reuel wuon-gi, nopenjogi niya, “Angʼo momiyo udwogo chon kawuono?” ");
INSERT INTO luo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Negidwoke niya, “Ja-Misri moro noresowa e lwet jokwath, mi otuomonwa pi kendo omiyo jamni pi omodho.” ");
INSERT INTO luo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Reuel nopenjo nyige niya, “En kanye? Marangʼo uweye? Luongeuru mondo oyud gimoro ocham.” ");
INSERT INTO luo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa noyie mondo odag gi ngʼatno, mi Reuel nomiye nyare miluongo ni Zipora mondo obed chiege. ");
INSERT INTO luo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipora nonywolo wuowi mi Musa nochako nyinge ni Gershom, kowacho niya, “Asedoko jadak e piny ma ok marwa.” ");
INSERT INTO luo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","E kinde mane Musa pod odak Midian, Farao ruodh Misri notho. Jo-Israel ne ngʼur ahinya kuom tichgi mar wasumbini mi giywak malit, kendo ywakgi mondo oresgi e tich mar bedo misumba nochopo ir Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nyasaye nowinjo ngʼurgi mi oparo singruokne gi Ibrahim gi Isaka kod Jakobo. ");
INSERT INTO luo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Kuom mano Nyasaye noneno kaka jo-Israel thagore mi wachno ne odonjo e chunye. ");
INSERT INTO luo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Chiengʼ moro Musa ne kwayo jamb Jethro jaduongʼne ma Jadolo mar jo-Midian, mi nongʼado thim gi jamni nyaka Horeb got mar Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Malaika mar Jehova Nyasaye nofwenyorene kanyo e ligek mach maliel e dier bungu. Musa noneno ni kata obedo ni mach nomako bunguno, bunguno to ne ok wangʼ. ");
INSERT INTO luo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Kuom mano Musa noparo e chunye owuon niya, “Abiro sudo machiegni mondo ane hono maduongʼni. Angʼo momiyo bunguni ok wangʼ kata obedo ni mach lielie.” ");
INSERT INTO luo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Kane Jehova Nyasaye oneno kosudo machiegni mondo one ane, Nyasaye noluonge gi e dier bungu niya, “Musa! Musa!” Eka Musa nodwoke niya, “An ka.” ");
INSERT INTO luo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nyasaye nowachone niya, “Kik imed sudo machiegni, to lony wuoche e tiendi, nikech kama ichungoeni en Kama Ler.” ");
INSERT INTO luo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Bangʼe Jehova Nyasaye nowachone niya, “An e Nyasach kwereni, Nyasach Ibrahim gi Nyasach Isaka kendo Nyasach Jakobo.” Kane Musa owinjo wachno to nopando wangʼe, nikech noluoro rango wangʼ Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Eka Jehova Nyasaye nowacho niya, “Chutho aseneno thagruok mar joga e piny Misri. Asewinjo ywakgi nikech joma chunogi e tich mar wasumbini kendo angʼeyo thagruokgi. ");
INSERT INTO luo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Omiyo aselor mondo aresgi e lwet jo-Misri kendo agolgi e pinyno mondo akelgi e piny maber kendo malach, ma en piny mopongʼ gi chak kod mor kich. En piny jo-Kanaan gi jo-Hiti gi jo-Amor gi jo-Perizi gi jo-Hivi kod jo-Jebus. ");
INSERT INTO luo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Koro ywak jo-Israel osechopona, kendo aseneno kaka jo-Misri sandogi. ");
INSERT INTO luo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Koro dhiyo. Aori ir Farao mondo igol joga ma jo-Israel e piny Misri.” ");
INSERT INTO luo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","To Musa nodwoko Nyasaye niya, “An to an ngʼa, ma dadhi ir Farao kendo golo jo-Israel e piny Misri?” ");
INSERT INTO luo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Nyasaye nodwoke niya, “Abiro bedo kodi. Ranyisi ma ibiro neno ni An ema aori ema: Ka isegolo ogandani e piny Misri, to ubiro lamo Nyasaye ewi godni.” ");
INSERT INTO luo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa nodwoko Nyasaye niya, “Ka dipo ni adhi ir jo-Israel mi awachonegi ni, ‘Nyasach kwereu oseora iru,’ mi gipenja ni, ‘Nyinge en ngʼa?’ Koro to ananyisgi nangʼo?” ");
INSERT INTO luo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nyasaye nowacho ne Musa niya, “AN MANTIE. Ma e gima onego iwach ni jo-Israel, ‘AN MANTIE oseora iru.’ ” ");
INSERT INTO luo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Nyasaye nowacho ne Musa kendo niya, “Nyis jo-Israel kama, ‘Jehova Nyasaye ma Nyasach kwereu, kendo ma Nyasach Ibrahim gi Nyasach Isaka kendo Nyasach Jakobo; oseora iru.’ “Ma e nyinga manyaka chiengʼ, ma en nying manyaka parago, kuom tiengʼ ka tiengʼ. ");
INSERT INTO luo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Dhiyo, ichok jodong jo-Israel mondo iwachnegi kama. ‘Jehova Nyasaye, ma Nyasach kwereu; ma en Nyasach Ibrahim gi Isaka kod Jakobo; nofwenyorena mi owachona kama: Aserangou mi aseneno gino mosetimnu e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Kuom mano asesingora ni nyaka agolu e thagruok e piny Misri mi akelu e piny jo-Kanaan gi jo-Hiti gi jo-Amor gi jo-Perizi gi jo-Hivi kod jo-Jebus, ma en piny mopongʼ gi chak kod mor kich.’ ");
INSERT INTO luo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Jodong jo-Israel biro winjo gima iwacho. Bangʼ mano in kaachiel gi jodongo unudhi ir ruodh Misri mi uwachne kama: ‘Jehova Nyasaye, ma Nyasach jo-Hibrania oseromo kodwa. Omiyo yie iwe wadhi e thim kama kawo wuodh ndalo adek mondo wachiwne Jehova Nyasaye ma Nyasachwa misengini.’ ");
INSERT INTO luo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","To angʼeyo ni ruodh Misri ok noyienu mondo udhi makmana kochune gi bat maratego. ");
INSERT INTO luo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Kuom mano, abiro rieyo bada mi agoo jo-Misri gi kit masiche duto ma anakel e diergi. Bangʼ mano, to enoyienu mondo udhi. ");
INSERT INTO luo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Bende anami jo-Misri bed gi ngʼwono kuom jogi, mondo ka uwuok to ok unua gi lwetu nono. ");
INSERT INTO luo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Dhako ka dhako nyaka kwa jabathe kod joma odakgo e ode mondo omiye gik molos gi fedha gi dhahabu kod lewni, ma unuket kuom yawuotu gi nyiu. Kuom mano unuyak gige jo-Misri.” ");
INSERT INTO luo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa nodwoko niya, “To kapo ni ok giyie kata winjo wachna mi giwacho ni, ‘Jehova Nyasaye ne ok ofwenyoreni’?” ");
INSERT INTO luo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Eka Jehova Nyasaye nopenje niya, “Mano en angʼo mantie e lwetino?” Musa nodwoko niya, “En luth.” ");
INSERT INTO luo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Jehova Nyasaye nowachone niya “Bole piny kanyo.” Musa nobole piny e lowo kendo nolokore thuol mi Musa noringe. ");
INSERT INTO luo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Bangʼe Jehova Nyasaye nowachone niya, “Rie badi mondo imake gi yo ka iwe.” Kuom Mano Musa norieyo bade kendo nomake gi yo ka iwe mi nochako olokore luth e lwete. ");
INSERT INTO luo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Jehova Nyasaye nowachone niya, “Ma en kamano mondo mi giyie ni Jehova Nyasaye ma Nyasach kweregi; Nyasach Ibrahim gi Isaka kod Jakobo osefwenyoreni.” ");
INSERT INTO luo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Eka Jehova Nyasaye nowachone niya, “So lweti ei lawi.” Kuom mano, Musa nosoyo lwete ei lawe kendo kane ogole oko, to lwete nolokore dhoho, marachar ka pe. ");
INSERT INTO luo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Bangʼe nonyise niya, “Koro dwok lweti ei law.” Kuom mano, Musa nodwoko lwete ei law, kendo kane ogole, lwete nochango modoko machal gi dende duto. ");
INSERT INTO luo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Eka Jehova Nyasaye nowacho niya, “Kapo ni ok giyie gi wachni kata kuom ranyisi mokwongo, to ginyalo yie mar ariyo. ");
INSERT INTO luo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","To kapo ni ok giyie gi ranyisi ariyogo kata winjo wachni, to kaw pi mar aora Nael, kendo iole e lowo motwo. Pi migolo e aorano biro lokore remo e lowo motwo.” ");
INSERT INTO luo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa nodwoko Jehova Nyasaye niya, “Yaye Ruoth Nyasaye, ok asebedo ngʼat ma wuoyo kalewe yot chakre chon kata e sa misebedo ka iwuoyo kod misumbani. Lewa pek kendo aywayo wach.” ");
INSERT INTO luo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Eka Jehova Nyasaye nowachone niya, “En ngʼa manochweyo dho dhano? En ngʼa mamiyo odoko momo kata ite odino? Koso en ngʼa mamiyo oneno kata obedo muofu? Donge en an Jehova Nyasaye? ");
INSERT INTO luo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Omiyo koro dhiyo, abiro konyi e wuoyo bende abiro puonji gima onego iwachi.” ");
INSERT INTO luo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","To Musa nodwoke niya, “Yaye Ruoth Nyasaye, ka iyie to or ngʼat machielo.” ");
INSERT INTO luo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Eka Jehova Nyasaye ne mirima omako gi Musa mowachone niya, “Donge owadu Harun ma ja-Lawi nitie? Angʼeyo ni onyalo wuoyo maber. Osechako wuoth obiro romoni bende chunye biro bedo mamor ka oneni. ");
INSERT INTO luo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ibiro wuoyo kode mi iket weche e dhoge; abiro konyou un ji ariyo mondo uwuo bende abiro puonjou gima onego utim. ");
INSERT INTO luo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Obiro wuoyo gi ji kari kendo obiro bedo kaka dhogi bende ibiro bedone kaka Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","To kaw ludhni e lweti nimar ibiro timo kode honni gi ranyisi.” ");
INSERT INTO luo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Eka Musa nodok ir Jethro jaduongʼne mowachone niya “Yie iweya adog Misri ir joga mondo ane kapo ni nitie moro kuomgi ma pod ngima.” Jethro nodwoke niya, “Dhiyo kendo ibed gi gweth.” ");
INSERT INTO luo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Noyudo Jehova Nyasaye osewuoyo gi Musa e piny Midian kowachone niya, “Dog Misri, nikech jogo duto mane dwaro negi osetho.” ");
INSERT INTO luo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Omiyo Musa nokawo chiege kod yawuote, mi oketogi e punda kendo nochako wuoth mar dok Misri. Bende nokawo ludh Nyasaye e lwete. ");
INSERT INTO luo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Jehova Nyasaye nowacho ne Musa niya, “Ka idok Misri nyaka ine ni itimo e nyim Farao honni duto ma asemiyi teko mondo itim. Makmana abiro miyo chuny Farao doko matek ma ok onyal weyo jo-Israel mondo oa. ");
INSERT INTO luo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Eka iniwach ni Farao kama, ‘Ma e gima Jehova Nyasaye wacho: Israel e wuoda makayo, ");
INSERT INTO luo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","kendo ne anyisi niya, “Yie iwe wuoda odhi, mondo olama.” To nikech nidagi weye mondo odhi; koro abiro nego wuodi makayo.’ ” ");
INSERT INTO luo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","E kinde mane Musa obuoro kamoro e kor yo, Jehova Nyasaye noromo kode kendo nochiegni nege. ");
INSERT INTO luo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","To Zipora nokawo pala modingli mi ongʼadogo pien mantie e dho duongʼ wuode kendo nokawo pien-no momulogo tiend Musa. Nowacho niya, “Adier ibedona wuon kisera mar remo.” ");
INSERT INTO luo_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Eka Jehova Nyasaye noweye. (E kindeno ema Zipora nowachoe niya, “Wuon kisera mar remo,” ma tiende ni tero nyangu.) ");
INSERT INTO luo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Jehova Nyasaye nowacho ni Harun niya, “Dhiyo e thim mondo irom gi Musa.” Omiyo nodhi moromo gi Musa e got mar Nyasaye kendo nonyodhe. ");
INSERT INTO luo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Eka Musa nonyiso Harun weche duto mane Jehova Nyasaye oore mondo owachi, kendo nonyise honni duto mane Jehova Nyasaye oore mondo otim. ");
INSERT INTO luo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Eka Musa gi Harun nochoko jodong jo-Israel duto kanyakla, ");
INSERT INTO luo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","kendo Harun nonyisogi gik moko duto mane Jehova Nyasaye onyiso Musa. Bende notimo honni duto e nyim ji, ");
INSERT INTO luo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","kendo ne giyie. Kendo kane giwinjo ni Jehova Nyasaye oseneno chandruokgi kendo ni odwaro resogi, negikulore mi gilame. ");
INSERT INTO luo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Bangʼe Musa gi Harun nodhi ir Farao mi giwachone niya, “Jehova Nyasaye, ma Nyasach jo-Israel wacho kama: ‘We joga odhi, mondo gilosna sawo e thim.’ ” ");
INSERT INTO luo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","To Farao nodwokogi niya, “Jehova Nyasaye to en ngʼa, ma dimi awinj dwonde mi awe jo-Israel dhi? Ok angʼeyo Jehova Nyasaye kendo ok anawe jo-Israel dhi.” ");
INSERT INTO luo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Negiwachone niya, “Nyasach jo-Hibrania oseromo kodwa. Omiyo koro yie iwe wadhi e thim kama kawo e wuodh ndalo adek mondo wachiw misengini ne Jehova Nyasaye ma Nyasachwa, nono to dipo ka okelonwa masiche kata tho.” ");
INSERT INTO luo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","To ruodh Misri nowachonegi niya, “Musa gi Harun, en angʼo momiyo ugolo ji kuom tijegi ma gitimo? Doguru e tiju!” ");
INSERT INTO luo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Eka Farao nomedo wacho niya, “Neuru, ogandani koro osenyaa momedore to pod udwaro chungogi e tich.” ");
INSERT INTO luo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Chiengʼ onogo Farao nogolo chik ni jorit wasumbini kod nyipeche kowachonegi niya, ");
INSERT INTO luo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Kik uchak umi jo-Israel lum magilosogo matafare; to nyaka une ni giomo lum kendgi giwegi. ");
INSERT INTO luo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","To nyaka une ni giloso matafare ma kwan-gi romre gi mano ma gisebedo ka giloso, kik uwe kwan-go dog chien. Gin jonyawo, emomiyo gigoyo koko ni, ‘Yie iwewa wadhi kendo wachiw misango ni Nyasachwa.’ ");
INSERT INTO luo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Keturu tich obed matekie moloyo ni jogi mondo gisiki ka gitiyo kendo kik uchik itu ne miriambogi.” ");
INSERT INTO luo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Eka jorit wasumbini kod nyipeche ne odhi mowachone jo-Israel niya, “Ma e gima Farao wacho, ‘Ok abi miyou lum kendo. ");
INSERT INTO luo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Dhiuru mondo udwar lumbu kamoro amora ma unyalo yude, to ngʼeuru ni tiju to ok nodwok chien kata matin.’ ” ");
INSERT INTO luo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Omiyo jo-Israel nokee e piny Misri duto ka gichoko lum. ");
INSERT INTO luo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Jorit wasumbini ne kasogi kawachonegi niya, “Tiekuru tich momiu odiechiengʼ ka odiechiengʼ, mana machal kaka ne utimo kane un gi lum.” ");
INSERT INTO luo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Nyipeche ma jo-Israel mane jotich Farao oyiero nigoyo kipenjogi niya, “En angʼo mosemonou loso matafare ndalo ariyogi kaka uloso pile?” ");
INSERT INTO luo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Eka nyipeche ma jo-Israel nodhi modonjo ir Farao kagiwacho niya, “Ere gima omiyo isetimone jotichni kama? ");
INSERT INTO luo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Jotichni ok mi kata mana lum, to eka pod inyisowa kama: ‘Losuru matafare!’ Jotichni igoyo, to jogi ema nigi ketho.” ");
INSERT INTO luo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Eka Farao nowacho niya, “Jonyawogi un mana jonyawo! Mano e gima omiyo usiko kuwacho ni, ‘Yie wadhi mondo wachiw misango ni Jehova Nyasaye.’ ");
INSERT INTO luo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Koro doguru e tich, ok nomiu lum moro amora, to nyaka ulos matafare ma kar kwan-gi rom gi ma usebedo kuloso pile.” ");
INSERT INTO luo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Eka nyipeche ma jo-Israel nofwenyo ni gin e chandruok ka nonyisogi niya, “Ok unyal dwoko kar kwan matafare musebedo kuloso pile.” ");
INSERT INTO luo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Bangʼ kane gisea ir Farao, negiyudo Musa gi Harun karitogi mondo orom kodgi, ");
INSERT INTO luo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","kendo negiwachonegi niya, “Mad Jehova Nyasaye neu mi ngʼadnu bura! Usemiyo wadoko gima dungʼ mangʼwe ni Farao kod jodonge kendo useketo ligangla e lwetgi mondo ginegwago.” ");
INSERT INTO luo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Eka Musa nodok ir Jehova Nyasaye mowachone niya, “Yaye Ruoth Nyasaye, en angʼo momiyo isekelo chandruok ni ogandani? Koso ma emomiyo ni ora? ");
INSERT INTO luo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Nyaka nachak dhi ir Farao mondo awuo e nyingi, osekelo chandruok ni ogandani bende ok isereso ogandani ngangʼ.” ");
INSERT INTO luo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Eka Jehova Nyasaye nowacho ne Musa niya, “Koro ibiro neno gino ma abiro timo ne Farao: Nikech bada man-gi teko, obiro weyogi mondo gidhi; kendo nikech tekona maduongʼ obiro riembogi mi gia e pinye.” ");
INSERT INTO luo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nyasaye bende nonyiso Musa kama, “An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ne afwenyora ne Ibrahim gi Isaka kod Jakobo kaka Nyasaye Maratego, to ne ok afwenyoranegi gi nyinga ma ungʼeyago ma en Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Bende ne aguro singruokna kodgi ni anamigi piny Kanaan, kama negidakie kaka jodak. ");
INSERT INTO luo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","To bende asewinjo ngʼur, mar jo-Israel ma jo-Misri oseloko wasumbinigi mi aparo singruokna. ");
INSERT INTO luo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Emomiyo nyis jo-Israel kama: ‘An e Jehova Nyasaye kendo abiro golou e tije mapek ma jo-Misri oketo kuomu. Abiro miyo ubed thuolo e tij bedo wasumbini mag-gi kendo abiro resou kakumogi malit mondo awaru. ");
INSERT INTO luo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Abiro kawou kaka joga awuon, bende abiro bedo Nyasachu eka ubiro ngʼeyo ni An e Jehova Nyasaye ma Nyasachu, manogolou ka uwuok e bwo tich matek mar jo-Misri. ");
INSERT INTO luo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Kendo abiro kelou e piny mane akwongʼora ka atingʼo bada malo ni anami Ibrahim, Isaka kod Jakobo. Abiro miyougo kaka girkeni. An e Jehova Nyasaye.’ ” ");
INSERT INTO luo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa nodwoko ni jo-Israel wechegi, to kata kamano ne ok giwinje nimar chunygi nonyosore nikech tich mapek mar bedo wasumbini. ");
INSERT INTO luo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Eka Jehova Nyasaye nonyiso Musa niya, ");
INSERT INTO luo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Dhiyo, inyis Farao ruodh jo-Misri mondo owe jo-Israel owuogi e pinye.” ");
INSERT INTO luo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","To Musa nodwoko Jehova Nyasaye niya, “Ka jo-Israel ema ok nyal winja, en angʼo manyalo miyo Farao winja mi dewa nimar an radwal?” ");
INSERT INTO luo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Jehova Nyasaye nowuoyo gi Musa kod Harun kochikogi mondo gidhi ir Farao ruodh Misri, mondo gigol jo-Israel e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Magi e jotelo mag anywolagi: Yawuot Reuben ma kach Israel ne gin: Hanok, Palu, Hezron kod Karmi. Mago e jo-Reuben. ");
INSERT INTO luo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Yawuot Simeon ne gin: Jemuel, Jamin, Ohad, Jakin, Zohar kod Shaul mane en wuod nyar ja-Kanaan. Mago e joka Simeon. ");
INSERT INTO luo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Magi e nying joka Lawi kaluwore gi anywolagi: Gershon, Kohath gi Merari. (Lawi nodak kuom higni mia achiel gi piero adek gabiriyo.) ");
INSERT INTO luo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Yawuot Gershon kaluwore gi dhoodgi ne gin: Libni kod Shimei. ");
INSERT INTO luo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Yawuot Kohath ne gin: Amram, Izhar, Hebron kod Uziel. (Kohath nodak kuom higni mia achiel gi piero adek gadek.) ");
INSERT INTO luo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Yawuot Merari ne gin: Mali kod Mushi. Magi ema ne dhout jo-Lawi kaluwore gi anywolagi. ");
INSERT INTO luo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram wuod Kohath nokendo nyamin wuon-gi ma nyinge Jokebed, mane onywolone Harun kod Musa. (Amram nodak kuom higni mia achiel gi piero adek gabiriyo.) ");
INSERT INTO luo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yawuot Izhar ne gin: Kora, Nefeg kod Zikri. ");
INSERT INTO luo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Yawuot Uziel ne gin: Mishael, Elzafan kod Sithri. ");
INSERT INTO luo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Harun nokendo Elisheba nyar Aminadab ma bende nyamin Nashon, kendo nonywolone Nadab, Abihu, Eliazar kod Ithamar. ");
INSERT INTO luo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Yawuot Kora ne gin: Asir, Elkana kod Abiasaf. Magi ema ne dhout joka Kora. ");
INSERT INTO luo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eliazar wuod Harun nokendo achiel kuom nyi Putiel, kendo nonywolone Finehas. Magi ema ne jotend dhout joka Lawi. ");
INSERT INTO luo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ma e Harun nogo kod Musa mane Jehova Nyasaye owachonegi niya, “Gol jo-Israel oa e piny Misri kaluwore gi dhoutgi” ");
INSERT INTO luo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Gin giwegi ema ne giwuoyo gi Farao ruodh jo-Misri mondo ogol jo-Israel e piny Misri. Ne en mana Musa kod Harun. ");
INSERT INTO luo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Kane Jehova Nyasaye owuoyo gi Musa e piny Misri, ");
INSERT INTO luo_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","nowachone niya, “An Jehova Nyasaye. Nyis Farao ruodh jo-Misri gik moko duto manyisi.” ");
INSERT INTO luo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","To Musa nodwoko Jehova Nyasaye niya, “Nikech an radwal, en angʼo manyalo miyo Farao winja?” ");
INSERT INTO luo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Eka Jehova Nyasaye nowacho ne Musa niya, “Ne, aseketi kaka Nyasaye ni Farao, kendo Harun owadu biro bedoni janabi. ");
INSERT INTO luo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Nyaka iwach gik moko duto ma achiki, kendo Harun owadu nonyis Farao mondo owe jo-Israel owuog e pinye. ");
INSERT INTO luo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Abiro keto chuny Farao bedo matek, ma kata obedo ni abiro nwoyo honni kod ranyisi e piny Misri, ");
INSERT INTO luo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","to Farao ok nowinju. Omiyo anasand jo-Misri gi masiche madongo kakumogi malich mi anagol joga ma jo-Israel e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Kendo jo-Misri nongʼe ni an Jehova Nyasaye e kinde ma anakumgi ka agolo jo-Israel kuomgi.” ");
INSERT INTO luo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa kod Harun notimo mana kaka Jehova Nyasaye nochikogi. ");
INSERT INTO luo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","E kinde mane giwuoyo gi Farao, Musa ne ja-higni piero aboro to Harun to ne ja-higni piero aboro gadek. ");
INSERT INTO luo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Jehova Nyasaye nowacho ne Musa kod Harun niya, ");
INSERT INTO luo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ka Farao onyisou ni mondo utim hono moro, to in Musa nyis Harun ni, ‘Kaw ludhi kendo dire piny e nyim Farao,’ kendo obiro lokore thuol.” ");
INSERT INTO luo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kuom mano, Musa kod Harun ne odhi ir Farao mi gitimo mana kaka Jehova Nyasaye nochikogi. Harun nodiro ludhe piny e nyim Farao kod jodonge mi nolokore thuol. ");
INSERT INTO luo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Farao noluongo jorieko kod ajuoke mag Misri mine gitimo gik machal gi mane Harun otimo ka gitiyo gi teko mag yedhegi mopondo. ");
INSERT INTO luo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ngʼato ka ngʼato kuomgi nodiro ludhe piny kendo nolokore thuol. To ludh Harun nomwonyo ludhegigo. ");
INSERT INTO luo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","To kata kamano, chuny Farao ne odoko matek kendo ne ok onyal winjogi mana kaka Jehova Nyasaye ne osewacho. ");
INSERT INTO luo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Eka Jehova Nyasaye nowacho ne Musa niya, “Chuny Farao pod tek, odagi weyo joga mondo odhi. ");
INSERT INTO luo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Dhi ir Farao gokinyi ka odhi e aora. Rite e bath aora Nael mondo irom kode, bende kaw luth mane olokore thuol cha e lweti. ");
INSERT INTO luo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Eka inyise ni, ‘Jehova Nyasaye, ma Nyasach jo-Hibrania, oseora mondo anyisi niya: We joga odhi, mondo gilama e thim. To nyaka chop koroni pok iwinjo. ");
INSERT INTO luo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ma e gima Jehova Nyasaye wacho: Ranyisini biro miyo ingʼe ni an Jehova Nyasaye: Abiro chwado pi aora Nael gi luth mantie e lwetani kendo pigno biro lokore remo. ");
INSERT INTO luo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Rech manie aora Nael biro tho, kendo aora biro dungʼ, jo-Misri ok nomodh pigno.’ ” ");
INSERT INTO luo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Jehova Nyasaye nowacho ne Musa niya, “Nyis Harun ni, ‘Kaw ludhi mondo irie badi ewi pige mag Misri, ma gin aore matindo kod madongo, yewni kod kuonde duto mag kano pi, kendo gibiro lokore remo.’ Remo biro bedo kamoro amora e piny Misri nyaka ei agulni molos gi kite.” ");
INSERT INTO luo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa kod Harun notimo mana kaka Jehova Nyasaye nochikogi. Notingʼo ludhe e nyim Farao kod jodonge duto mi ochwado aora Nael kendo pige duto nolokore remo. ");
INSERT INTO luo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Rech manie aora Nael notho, kendo aora nodungʼ marach ma jo-Misri ne ok nyal modho pige. Remo ne nitie kamoro amora e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","To ajuoke mag Misri notimo mana gik machal kamano gi tijegi mag ajuoke mi chuny Farao nomedo doko matek; ne ok onyal winjo wach Musa kod Harun mana kaka Jehova Nyasaye nosewacho. ");
INSERT INTO luo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","To kata kamano nodok e kare mar dak, kendo ne ok odewo wechegi. ");
INSERT INTO luo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Jo-Misri duto nokunyo bath aora Nael mondo giyud pi modho, nikech ne ok ginyal modho pi aorano. ");
INSERT INTO luo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ndalo abiriyo norumo bangʼ ka Jehova Nyasaye nosechwado aora Nael. ");
INSERT INTO luo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Eka Jehova Nyasaye nowacho ne Musa mondo odhi ir Farao kendo onyise niya, Ma e gima Jehova Nyasaye wacho: “We joga odhi mondo gilama. ");
INSERT INTO luo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ka idagi weyo joga mondo odhi, to abiro kelo masira mar ogwende e pinyni duto. ");
INSERT INTO luo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ogwende nopongʼ aora Nael kendo giniwuogi ka gidhi e odi nyaka kor nindo. Bende ginipongʼ nyaka kitandani, ute jodongi kod mag jogi, kaachiel gi kuonde tedo gi dwalo makati. ");
INSERT INTO luo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ogwendego nochikre kuomi, kuom jogi kendo kuom jodongi duto.” ");
INSERT INTO luo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Eka Jehova Nyasaye nowacho ne Musa niya; “Nyis Harun kama: ‘Rie ludhi ewi aore, sokni kod yewni, kendo ogwende nowuog maim piny Misri duto.’ ” ");
INSERT INTO luo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Omiyo Harun norieyo lwete ewi pige mag Misri, kendo ogwende nowuok mopongʼo pinyno. ");
INSERT INTO luo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","To ajuoke bende notimo mana kamano gi tijegi mochido kendo negimiyo ogwende owuok e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Farao noluongo Musa kod Harun mi owachonegi niya, “Kwauru Jehova Nyasaye mondo ogol ogwendegi kuoma kod joga, eka anawe jogi mondo odhi otim misengini ni Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa nodwoko Farao niya, “Aweyoni mondo iket kinde mowinjore alemnie kod jodongi gi jogi mondo in kod joodi ogol ogwende kuomu, to mago manie aora Nael to nodongʼ.” ");
INSERT INTO luo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Farao nodwoke niya, “Obed kiny.” Musa nodwoke niya, “We obed mana kaka isewachono mondo ingʼe ni onge ngʼat machal kod Jehova Nyasaye ma Nyasachwa. ");
INSERT INTO luo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ogwende nodar kawuok e uteni, e ute jodongi kod ute mag jogi; to e aora Nael ok giniwuogie.” ");
INSERT INTO luo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Bangʼ ka Musa kod Harun noseweyo Farao, Musa noywak ni Jehova Nyasaye nikech ogwende mane osekelo kuom Farao. ");
INSERT INTO luo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Kendo Jehova Nyasaye notimo mana kaka Musa nokwaye. Ogwende notho ei udi kod laru gi pewe. ");
INSERT INTO luo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Negichokore pidhe pidhe kendo negipongʼo piny. ");
INSERT INTO luo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Kane Farao oneno ni oseyudo thuolo, noketo chunye matek mine ok onyal winjo Musa kod Harun, mana kaka Jehova Nyasaye nowacho. ");
INSERT INTO luo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Eka Jehova Nyasaye nowacho ne Musa niya, “Nyis Harun kama: ‘Rie ludhi mondo ichwadgo buru ma e lowo,’ kendo buru ma e lowo mar piny Misri duto biro lokore kikun.” ");
INSERT INTO luo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Negitimo mano kendo ka Harun norieyo bade mane otingʼogo luth mi ochwado buru ma e lowo, kikun nopor kuom ji kod jamni. Buru ma e piny Misri duto nolokore kikun. ");
INSERT INTO luo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","To ka ajuoke notemo mondo gin bende gihon kikun kuom tichgi mochido, to ne ok ginyal, kendo kikun nopor kuom ji gi jamni. ");
INSERT INTO luo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ajuoke nowacho ne Farao niya, “Ma en lwet Nyasaye!” To kata kamano chuny Farao ne tek kendo ne ok onyal winjo wach Musa gi Harun mana kaka Jehova Nyasaye nowacho. ");
INSERT INTO luo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Eka Jehova Nyasaye nowacho ne Musa niya, “Chiew gokinyi ahinya mondo irom gi Farao ka odhi e aora Nael mondo inyise kama: Ma e gima Jehova Nyasaye wacho: We joga odhi mondo gilama. ");
INSERT INTO luo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","To ka ok iweyo joga mondo odhi, to abiro kelo lwangʼni kuomi, kuom jodongi, kuom jogi kod ei uteu duto. Ute jo-Misri biro pongʼ gi lwangʼni kata mana e lowo kama gintie bende biro pongʼ. ");
INSERT INTO luo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘To chiengʼno ok anahon lwangʼni e piny Goshen kama joga odakie, mi iningʼe ni an Jehova Nyasaye kare anie pinyni. ");
INSERT INTO luo_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Abiro keto pogruok e kind joga kod jogi. Hononi kiny notimre kiny.’ ” ");
INSERT INTO luo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Kendo Jehova Nyasaye notimo mano. Kweth mag lwangʼni mopoto noolore e od Farao, kendo ei ut jodonge bende piny Misri duto ne lwangʼnigo oketho. ");
INSERT INTO luo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Eka Farao noluongo Musa kod Harun mowachonegi niya, “Dhiuru utim misango ni Nyasachu e piny Misri ka.” ");
INSERT INTO luo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","To Musa nodwoko niya, “Mano ok nyal bedo kare. Misengini ma wachiwo ni Jehova Nyasaye ma Nyasachwa nyalo bedo gima kwero ni jo-Misri. To ka wachiwo misengini makwerogo e wangʼ-gi, donge gibiro goyowa gi kite? ");
INSERT INTO luo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nyaka wakaw wuodh ndalo adek e thim mondo wachiw misengini ni Jehova Nyasaye ma Nyasachwa mana kaka ochikowa.” ");
INSERT INTO luo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farao nodwoko niya, “Abiro yienu mondo udhi uchiw misengini ni Jehova Nyasaye ma Nyasachu e thim to mana ka ok udhi mabor. Omiyo lamnauru.” ");
INSERT INTO luo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa nodwoko niya, “Bangʼ kinde matin ka asewuok, to abiro lamoni Jehova Nyasaye, kendo kiny lwangʼni nowe Farao, jodonge kod joge. Makmana ni Farao kik chak riambi kotamo jo-Israel dhi timo misengini ni Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Bangʼe Musa noweyo Farao mi olamo Jehova Nyasaye, ");
INSERT INTO luo_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","kendo Jehova Nyasaye notimo kaka Musa nokwayo: Lwangʼni noweyo Farao kod jodonge kaachiel gi joge: Kata lwangʼni achiel ne ok odongʼ. ");
INSERT INTO luo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","To kata mana e kindeni Farao nomedo bedo gi tok teko kendo ne ok onyal weyo jo-Israel mondo odhi. ");
INSERT INTO luo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Eka Jehova Nyasaye nowacho ne Musa niya, “Dhi ir Farao mondo iwachne kama: ‘Ma e gima Jehova Nyasaye ma Nyasach jo-Hibrania wacho: “We joga odhi mondo olama!” ");
INSERT INTO luo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","To ka itamori weyogi mondo gidhi kendo isiko kiketogi e tich misumba, ");
INSERT INTO luo_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","to lwet Jehova Nyasaye biro kelo tho ne jamni mantiere lek kaka fareseni kod pundeni, ngamia magi kaachiel gi dhogi, rombegi kod dieki. ");
INSERT INTO luo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","To Jehova Nyasaye biro keto pogruok kuom jamb jo-Israel kod mago mag jo-Misri mi onge chiach ja-Israel moro amora ma biro tho.’ ” ");
INSERT INTO luo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Jehova Nyasaye noketo odiechiengʼ ma gigo notimre kowacho kama: “Kiny Jehova Nyasaye notim ma e pinyni.” ");
INSERT INTO luo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kendo kinyne Jehova Nyasaye notimo kamano. Jamni duto mag jo-Misri notho, to onge jamb ja-Israel kata achiel mane otho. ");
INSERT INTO luo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kane Farao ooro ji mondo onon wachno, to negiyudo kaonge kata achiel kuom jamb jo-Israel mane otho. To kata kamano wi Farao nomedo bedo matek mine ok onyal weyo ogandano mondo odhi. ");
INSERT INTO luo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Eka Jehova Nyasaye nowacho ne Musa kod Harun niya, “Jukuru buch kendo mopongʼo lwetu mondo Musa okire e kor yamo e nyim Farao. ");
INSERT INTO luo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Obiro lokore buru mayom e piny Misri duto kendo buche malokore adhola biro gore kuom ji kaachiel gi jamni e piny duto.” ");
INSERT INTO luo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Kuom mano ne gijuko buch kendo mi gichungʼ e nyim Farao. Musa nokiro buru e kor yamo kendo buche malokore adhola nogore kuom ji kod jamni. ");
INSERT INTO luo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ajuoke ne ok nyal chungʼ e nyim Musa nikech buche mane ni kuomgi kaachiel gi jo-Misri duto. ");
INSERT INTO luo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","To Jehova Nyasaye nomiyo chuny Farao omedo bedo matek mine ok nonyal winjo wach Musa kod Harun, mana kaka Jehova Nyasaye nosewacho ne Musa. ");
INSERT INTO luo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Eka Jehova Nyasaye nowacho ne Musa niya, “Chiew okinyi mangʼich, idhi ir Farao kendo inyise kama: ‘Ma e gima Jehova Nyasaye ma Nyasach jo-Hibrania wacho: We joga odhi olama. ");
INSERT INTO luo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ka ok kamano to wangʼni abiro oro masichena madongo dongo kuomi, kuom jodongi kod kuom jogi mondo ingʼe ni onge ngʼat machal koda e piny ngima. ");
INSERT INTO luo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ka dine arie bada mi agoyi gi tuo moro kaachiel gi jogi, to dikoro asetieki e wangʼ piny. ");
INSERT INTO luo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Makmana asetingʼi malo mana ne wachni, ni mondo anyisigo tekona kendo mondo nyinga olandi e piny duto. ");
INSERT INTO luo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","To kaka pod ithago joga kendo itamori weyogi mondo gidhi, ");
INSERT INTO luo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","kiny sa machal kama anaor pe malich mapok none e piny Misri, nyaka nene. ");
INSERT INTO luo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Chiw chik mondo jambu kaachiel gi gimoro amora ma un-go e pap okel kar tony, nikech pe biro chwer kuom ngʼato angʼata kata le moro amora ma pod ni oko ma ok odonjo e kar tony mi githo.’ ” ");
INSERT INTO luo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Jodong Farao-go ma noluoro wach Jehova Nyasaye noreto mondo okel wasumbinigi kaachiel gi jambgi e kar tony. ");
INSERT INTO luo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","To mago mane ok odew wach Jehova Nyasaye ne oweyo wasumbinigi gi jambgi e pap. ");
INSERT INTO luo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Eka Jehova Nyasaye nowacho ne Musa niya, “Rie badi kochomo polo mondo pe ochwe e piny Misri duto; kochwe kuom ji, le kod gimoro amora madongo e puothe mag Misri.” ");
INSERT INTO luo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ka Musa norieyo ludhe kochomo polo, Jehova Nyasaye nooro mor polo gi pe kendo polo nomil koni gi koni, kuom mano Jehova Nyasaye noolo pe e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Pe nochwe kendo polo nomil koni gi koni. Ne en masich pe marachie moloyo nyaka piny Misri ne chakre. ");
INSERT INTO luo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","E piny Misri duto pe nogoyo gimoro amora mantie e pewe; obed ji kata le. Nogoyo gimoro amora matwi e puothe kendo nolwero it yiende duto. ");
INSERT INTO luo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Makmana piny Goshen kende ema pe ok ochwee, kama piny ma jo-Israel nodakie. ");
INSERT INTO luo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Eka Farao noluongo Musa gi Harun. Nowachonegi niya, “Koro aseketho. Jehova Nyasaye ni kare, to an kaachiel gi joga wasetimo richo. ");
INSERT INTO luo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Kwanwa Jehova Nyasaye nimar mor polo gi pe oromowa. Abiro weyou mondo udhi, nimar onge tiende mondo umed bedo ka.” ");
INSERT INTO luo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa nodwoko niya, “Ka asewuok oko mar dala, abiro yaro bada ka akwayo Jehova Nyasaye. Polo mamor biro rumo bende pe ok nochak ochwe kendo, mondo ingʼe ni piny en mar Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","To kata kamano angʼeyo ni in kaachiel gi jodongi pod ok uluoro Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Tworo gi shairi nokethore chuth, nimar noyudo ka shairi oseketo wangʼe, to tworo nosethiewo. ");
INSERT INTO luo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ngano to ne ok okethore nimar ne pok gimoyo.) ");
INSERT INTO luo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Eka Musa noweyo Farao mi gidhi oko mar dala. Noyaro bade ni Jehova Nyasaye, mi mor polo kod pe norumo kendo koth bende ne ok ochwe e piny. ");
INSERT INTO luo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kane Farao oneno ka koth, pe gi mor polo orumo, to nomedo timo richo. Nomedo bedo gi chuny matek en kaachiel gi jodonge. ");
INSERT INTO luo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Kuom mano chuny Farao nomedo bedo matek kendo ne ok oyie ni jo-Israel mondo odhi kaka ne Jehova Nyasaye osewacho kokalo kuom Musa. ");
INSERT INTO luo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Eka Jehova Nyasaye nowacho ne Musa niya, “Dhi ir Farao, nikech asemiyo chunye kaachiel gi chunje jodonge odoko matek mondo mi atim honnigi mag ranyisina e kindgi; ");
INSERT INTO luo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","eka ununyis nyithindu kod nyikwau kaka ne adoko makwiny gi jo-Misri bende kaka ne atimo ranyisina e kindgi, eka mondo ungʼe ni an Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kuom mano Musa gi Harun nodhi ir Farao mi owachone niya, “Ma e gima Jehova Nyasaye, ma Nyasach jo-Hibrania wacho: ‘Nyaka karangʼo ma ibiro tamori bolori e nyima? We joga odhi mondo gilama. ");
INSERT INTO luo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ka itamori weyo joga mondo odhi, to abiro kelo ongogo e pinyi kiny. ");
INSERT INTO luo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Gibiro poto ma gium lowo ma ok nen. Gibiro chamo gimoro amora matin mane pe oweyo kaachiel gi kit yien duto matwi e lowo. ");
INSERT INTO luo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Gibiro pongʼo uteni gi ut jodongi kod mag jo-Misri duto; enobed gimoro ma wuoneu kata kwereu pok noneno chakre odiechiengʼ mane gichako dak e pinyni nyaka sani.’ ” Eka Musa nolokore mowuok e nyim Farao. ");
INSERT INTO luo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Jodong Farao nowachone niya, “Ngʼatni nobednwa obadho nyaka karangʼo? We ogandani odhi mondo mi gidhi gilam Jehova Nyasaye ma Nyasachgi. Dibed ni pok ifwenyo ni Misri kethore?” ");
INSERT INTO luo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Eka Musa gi Harun noduogo ir Farao. Farao nowachonegi niya, “Dhi, ulam Jehova Nyasaye ma Nyasachu, makmana ni en ngʼa gini madhi kodu?” ");
INSERT INTO luo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa nodwoke niya, “Wabiro dhi gi jowa duto jomatindo kuom jomadongo gi yawuotwa gi nyiwa kaachiel gi jambwa kod dhowa duto, nimar nyaka watim nyasi ni Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farao nowacho niya, “Mad Jehova Nyasaye bed kodu ka dipo ni aweyou udhi gi mondu kod nyithindu! Nenore ni udwaro kelo chandruok! ");
INSERT INTO luo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ooyo! Chwo kende ema mondo odhi kendo olam Jehova Nyasaye nimar mano ema isebedo ka ikwayo.” Eka Musa gi Harun noriembi oko e nyim Farao. ");
INSERT INTO luo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Eka Jehova Nyasaye nowacho ne Musa niya, “Rie badi e piny Misri mondo bonyo opoti e piny kendo mondo ocham gimoro amora matwi e puothe gi gimoro amora ma pe oweyo.” ");
INSERT INTO luo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kuom mano Musa norieyo ludhe e piny Misri, kendo Jehova Nyasaye nomiyo yamb wuok chiengʼ okudho matek e pinyno odiechiengno kod otienono duto. Kane ochopo gokinyi, yamono nokelo bonyo; ");
INSERT INTO luo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","omiyo negimonjo piny Misri duto ma gipoto kamoro amora man thuolo e pinyno. Nyaka nene masira machal kamano mar bonyo ne pok obetie kendo ok nochak obedie kendo. ");
INSERT INTO luo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ne giumo lowo mi piny olokore maratengʼ. Negichamo gimoro amora ma pe noweyo, mane gin gimoro amora matwi e puothe gi olembe ma nitie ewi yien. Onge kata it oboke manodongʼ e yien kata yath moro e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Farao noluongo Musa gi Harun mapiyo nono mi owachonegi niya, “Asetimo richo e nyim Jehova Nyasaye ma Nyasachi kaachiel gi nyimu bende, ");
INSERT INTO luo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","koro yie ichak iwena richona kendo lam ni Jehova Nyasaye ma Nyasachi mondo ogol masira marachni kuoma.” ");
INSERT INTO luo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa noweyo Farao mi olamo Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Kendo Jehova Nyasaye noloko kudho mar yamo mi yamb podho chiengʼ nokudho matek, bende yamono nochoko bonyo duto mi otero e Nam Makwar. Onge bonyo moro amora mane odongʼ e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","To Jehova Nyasaye noketo chuny Farao odoko matek kendo ne ok onyal weyo jo-Israel mondo odhi. ");
INSERT INTO luo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Eka Jehova Nyasaye nowacho ne Musa niya, “Rie badi kochomo polo mondo mudho olandre e piny Misri; ma en mudho mandiwa.” ");
INSERT INTO luo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Kuom mano Musa norieyo bade kochomo polo kendo mudho mandiwa nokwako piny Misri duto kuom ndalo adek. ");
INSERT INTO luo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Onge ngʼato mane nyalo neno wadgi kata wuok oko kuom ndalo adek, kata kamano piny Israel to ne nigi ler kama negidakie. ");
INSERT INTO luo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Eka Farao noluongo Musa mi owachone niya, “Dhiuru, ulam Jehova Nyasaye. Mondu kod nyithindu nyalo dhi kodu; makmana dhou gi jambu ema nyaka dongʼ.” ");
INSERT INTO luo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","To Musa nowacho niya, “Nyaka imiwa thuolo mar timo misengini gi misango miwangʼo pep ni Jehova Nyasaye ma Nyasachwa. ");
INSERT INTO luo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Jambwa duto bende nyaka dhi kodwa; kendo onge moro amora madongʼ chien. Moko kuomgi nyaka watigo e lamo Jehova Nyasaye ma Nyasachwa, nikech kapok wachopo kuno to ok wabi ngʼeyo ni mane monego watigo kuom lamo Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","To Jehova Nyasaye noketo chuny Farao obedo matek kendo ne ok oyie mondo owegi gidhi. ");
INSERT INTO luo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao nowacho ne Musa niya, “Wuogi ia e nyima! Ne ni ok ichako ibiro e nyima kendo! Nimar odiechiengʼ ma inine wangʼa kendo to ibiro tho!” ");
INSERT INTO luo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa nodwoke niya, “Mana kaka iwachono, ok anachak abi iri kendo.” ");
INSERT INTO luo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Noyudo ka Jehova Nyasaye osewacho ne Musa niya, “Pod abiro kelo masira achiel kuom Farao gi jo-Misri. Bangʼ masirano, obiro weyou mondo uwuog kae udhi, to ka otimo kamano, to obiro mana riembou chutho. ");
INSERT INTO luo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Nyis oganda ni chwo kaachiel gi mon mondo omi jobathgi gik molos gi fedha kod dhahabu.” ");
INSERT INTO luo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Jehova Nyasaye nomiyo jo-Misri otimo ngʼwono ne jo-Israel, kendo Musa owuon nomi luor gi jodong Farao e piny Misri kaachiel gi jo-Misri.) ");
INSERT INTO luo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Omiyo Musa nowacho niya, “Ma e gima Jehova Nyasaye wacho: ‘Kochopo dier otieno tir, to abiro dhi e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Nyithindo duto makayo ma yawuowi mag Misri biro tho, kochakore gi wuod Farao makayo mobet e kom duongʼ nyaka wuod nyako ma jatich makayo ma jarego, kaachiel gi nyithind jamni mokwong nywol. ");
INSERT INTO luo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ywak nobedie piny Misri duto, ma en ywak moloyo moro amora mosebedo kata mabiro bedo. ");
INSERT INTO luo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","To jo-Israel nobed gi kwe ma kata mana guok ok nogwe dhano kata chiayo.’ Bangʼ mano eka unungʼe ni Jehova Nyasaye keto pogruok e kind Misri gi Israel. ");
INSERT INTO luo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Jodong-gi duto biro biro ira ka gikulorena kendo kagiwacho ni, ‘Dhiyo, in kaachiel gi jogo maluwi!’ Bangʼ mano to anadhi.” Eka Musa nowuok e nyim Farao ka en gi mirima. ");
INSERT INTO luo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Jehova Nyasaye nosewacho ni Musa niya, “Farao biro tamore winji mondo honnina omedre piny e Misri.” ");
INSERT INTO luo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa gi Harun notimo honnigi duto e nyim Farao, to Jehova Nyasaye noketo chunye omedo bedo matek mine ok onyal weyo jo-Israel dhi koa e pinye. ");
INSERT INTO luo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Jehova Nyasaye nowacho ne Musa gi Harun ka gin Misri niya, ");
INSERT INTO luo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Dweni ema biro bedonu dwe mokwongo, ma en dwe mokwongo mar hiku. ");
INSERT INTO luo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Nyis oganda duto mar Israel ni odiechiengʼ mar apar mar dweni, ngʼato ka ngʼato nyaka gol achiel kuom nyirombe ne joode, nyarombo achiel ne ot ka ot. ");
INSERT INTO luo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","To ka nitie joot matin ma nyarombo achiel ohingo, to nyaka giriwre e nyarombo achiel gi joot machiegni kodgi, bangʼ ka gisekawo kwan joma ni kanyo. Nyaka ongʼe kar nyirombe madwarore kaluwore gi gima ngʼato ka ngʼato biro chamo. ");
INSERT INTO luo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Chiayo ma uyiero nyaka bed madichwo ma ja-higa achiel maonge songa kendo unyalo yierogi kuom rombe kata diek. ");
INSERT INTO luo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Neni urito chiayogo nyaka odiechiengʼ mar apar gangʼwen mar dwe, eka oganda jo-Israel duto noyangʼ-gi ka chiengʼ wuok. ");
INSERT INTO luo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Eka bangʼe to gikaw remo moko kendo giwirgo sirni mag dhoudi kod wi dhoudi. ");
INSERT INTO luo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","E otieno nogo nyaka gicham ringʼo mobul kaachiel gi alode makech kod makati ma ok oketie thowi. ");
INSERT INTO luo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kik ucham ringʼo manumu kata motedi gi kado to nyaka ubul lemb chiayogo; wich, tielo kaachiel gi jamb-ich. ");
INSERT INTO luo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kik uwe lemo moro dongʼ ma ok uchamo nyaka okinyi; to kapo nono moro odongʼ to nyaka wangʼe e mach chuth. ");
INSERT INTO luo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ma e kaka onego uchame: Ka utweyo okanda enungou, ka urwako wuoche e tiendu kendo umako luth e lwetu; nyaka une ni uchame piyo nikech en sawo mar Pasaka mar Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“E otienono abiro wuotho e piny Misri duto kendo naneg nyathi ka nyathi madichwo makayo mar dhano kod chiayo, bende nakum nyiseche duto mag jo-Misri, an Jehova Nyasaye ema awacho kamano. ");
INSERT INTO luo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Remono nobed kido mar ranyisi makende manyiso kuma udakie kendo ka aneno remogo to anakadhu. Masiche ma agoyogo piny Misri ok nomaku. ");
INSERT INTO luo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ma en odiechiengʼ manyaka upar ne tiengeu duto mabiro kendo nyaka urite ka sawo mochwere ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Kuom ndalo abiriyo nyaka ucham makati ma ok oketie thowi. Odiechiengʼ mokwongo nyaka ugol oko thowi ma ukano e ute, nikech ngʼato angʼata ma ochamo gimoro amora ma oted gi thowi chakre chiengʼ mokwongo nyaka chiengʼ mar abiriyo to nongʼad kare oko kuom oganda jo-Israel. ");
INSERT INTO luo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Chiengʼ mokwongo kod chiengʼ mar abiriyo nyaka ubed gi chokruok mowal. Kik utim tich moro amora kuom odiechiengego makmana loso chiemo ma ji duto chamo; mano kende e gima unyalo timo. ");
INSERT INTO luo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Nyaka utim Sawo mar makati ma ok oketie thowi, nikech chiengʼno ema ne agoloue piny Misri. Timuru nyasini odiechiengni kaka sawo mochwere ne tiengeu duto mabiro. ");
INSERT INTO luo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Chakre odhiambo mar tarik apar gangʼwen nyaka odhiambo mar tarik piero ariyo gachiel mar dwe mokwongo nyaka ucham makati ma ok oketie thowi. ");
INSERT INTO luo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Kuom ndalo abiriyo thowi moro amora kik yud e uteu, kendo ngʼato angʼata mochamo gimoro amora moketie thowi nyaka ngʼad kare oko kuom oganda jo-Israel, bed ni en japiny moro kata ja-Israel. ");
INSERT INTO luo_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Kik ucham gima olos gi thowi. Kamoro amora mudakie nyaka une ni uchamo makati ma ok oketie thowi.” ");
INSERT INTO luo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Eka Musa noluongo jodong Israel duto mowachonegi niya, “Dhiuru mondo ngʼato ka ngʼato oyier nyarombo kata nyadiel ne joode kendo uyangʼ-gi ka utimogo Pasaka. ");
INSERT INTO luo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Eka ukaw oboke mag raywechi ulute remo mar chiayono manie karaya kendo ukir moko ewi sirni mag dhoudi, to moko ukir e sirni mag dhoutu koni gi koni. Kik ngʼato angʼata kuomu wuog oko mar dhoot nyaka okinyi. ");
INSERT INTO luo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ka Jehova Nyasaye biro wuotho e piny Misri duto mondo oneg jo-Misri, to obiro neno remo ewi reru kod e bath dhoutu kendo nokal dhoudigo, ok noyie ne janek mondo odonj e uteu mondo onegu. ");
INSERT INTO luo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Rituru wechegi kaka chike mochwere nyaka ne tienge mabiro. ");
INSERT INTO luo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ka udonjo e piny ma Jehova Nyasaye biro miyou kaka ne osingorenu, to neuru ni utimo nyasi mar sawoni. ");
INSERT INTO luo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kendo ka nyithindu nopenju gima tiend sawoni en, ");
INSERT INTO luo_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","to nyisgiuru ni, ‘En misango mar Pasaka mitimo ni Jehova Nyasaye, nikech nokadho ut jo-Israel e piny Misri konego jo-Misri to oweyo miechwa.’ ” Eka ji nopodho auma molamo Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Jo-Israel notimo mana kaka Jehova Nyasaye nochiko Musa kod Harun. ");
INSERT INTO luo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","E dier otieno tir Jehova Nyasaye nonego nyithindo ma yawuowi makayo duto mag jo-Misri, kochakore gi kach ruoth Farao mane ni e kom duongʼ nyaka kach joma ni e od twech, kaachiel gi nyithindo makayo duto mag jamni. ");
INSERT INTO luo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Farao kaachiel gi jodonge kod jo-Misri duto nochiewo e dier otieno kendo ne nitie ywak maduongʼ e piny Misri, nikech ne onge ot moro amora e piny Misri mane ngʼato ok othoe. ");
INSERT INTO luo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","E otienono Farao ne oluongo Musa kod Harun mowachonegi niya, “Wuoguru gi jo-Israel piyo mondo uwe joga mondo udhi ulam Jehova Nyasaye ma Nyasachu kaka usekwayo. ");
INSERT INTO luo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Kawuru jambu kod kweth mag dhou mondo udhigo kaka usewacho kendo an bende lemnauru mondo ayud gweth.” ");
INSERT INTO luo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Jo-Misri nokwayo jo-Israel mondo owuog owe pinygi piyo kagiwacho niya, “Ka ok uwuok to waduto wabiro tho!” ");
INSERT INTO luo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kuom mano jo-Israel nokawo mogo modwal mapok oketie thowi kendo negitingʼogi e gokgi e sufuriache ka giboyogi gi sukni. ");
INSERT INTO luo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Jo-Israel notimo kaka Musa ne ochikogi kendo ne gikwayo jo-Misri lewni kod gik molos gi fedha kod dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Jehova Nyasaye nomiyo jo-Misri otimo ngʼwono ne jo-Israel kendo ne gimiyogi gimoro amora mane gikwayogi; kamano e kaka jo-Israel noyako gige jo-Misri. ");
INSERT INTO luo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Jo-Israel nowuok Rameses kochomo Sukoth; ne gin ji madirom alufu mia auchiel ka ok okwan mon kod nyithindo. ");
INSERT INTO luo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Oganda mamoko mathoth bende nodhi kodgi kaachiel gi kweth mangʼeny mag chiayo ma gin jamni kod kweth mangʼeny mag dhok. ");
INSERT INTO luo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ne gitedo makati ma ok oketie thowi gi mogo modwal mane giago e piny Misri. Ne ok oketie thowi nikech ne oriembgi gia e piny Misri apoya kendo ne ok giyudo thuolo kata mar tedo chiemo mane ginyalo chamo e kor yo. ");
INSERT INTO luo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Jo-Israel nodak e piny Misri kuom higni mia angʼwen gi piero adek. ");
INSERT INTO luo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Chiengʼ mane higni mia angʼwen gi piero adekgo orumo ema ne oganda Jehova Nyasaye duto owuokie piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ne en otieno mane Jehova Nyasaye oritogie mondo ogolgie piny Misri. Otieno onogono en otieno moket mondo jo-Israel duto obed kaparo Jehova Nyasaye nyaka ne tienge mabiro. ");
INSERT INTO luo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Jehova Nyasaye nowacho ne Musa gi Harun niya, “Magi e chike monego urit ka utimo Pasaka. “Jopinje mamoko kik chame. ");
INSERT INTO luo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Misumba moro amora mungʼiewo nyalo chame to mana bangʼ kusetere nyangu, ");
INSERT INTO luo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","to wendo moro mobuoro iru kata jatichu ok onego chame. ");
INSERT INTO luo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Ring chiayo mar misango nyaka cham mana e ot achiel, kik lemo kata achiel gol oko mar odno kendo kik utur choke moro amora. ");
INSERT INTO luo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Oganda duto mar jo-Israel nyaka tim sawoni. ");
INSERT INTO luo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Koponi nitie japiny moro modak e dieru modwaro timo ne Jehova Nyasaye Pasaka, to en kaachiel gi joge machwo nyaka tergi nyangu, eka onyalo riwore kodu e timo sawoni bangʼe nokwane kaka achiel kuom jo-Israel. Onge ngʼato angʼata madichwo ma ok oter nyangu ma oyiene chamo sawo mar Pasakani. ");
INSERT INTO luo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Chikni oket ne jo-Israel duto gi jopinje mamoko duto machalre.” ");
INSERT INTO luo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Jo-Israel duto notimo gik moko duto mane Jehova Nyasaye ochiko Musa gi Harun, ");
INSERT INTO luo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","mi chiengʼno ema Jehova Nyasaye nogolo jo-Israel e piny Misri kochan-gi e dhoutgi. ");
INSERT INTO luo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Nyathi ka nyathi madichwo makayo nyaka walna. Nyak mokwongo mar nyodo e kind jo-Israel en mara, bed ni en dhano kata chiayo.” ");
INSERT INTO luo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Eka Musa nowacho ne ogandano niya, “Paruru odiechiengni, chiengʼ mane uwuokie piny Misri, piny mane ubedoe wasumbini, nikech Jehova Nyasaye nogolou e pinyno gi lwedo maratego. Kik ucham gimoro amora moketie thowi. ");
INSERT INTO luo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Kawuono e dwe mar Abib, ema uwuokie. ");
INSERT INTO luo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ka Jehova Nyasaye okelou e piny jo-Kanaan gi jo-Hiti gi jo-Amor gi jo-Hivi kod jo-Jebus, piny ma nosingore ne kwereu ni nomiu, piny mopongʼ gi chak kod mor kich; to nyaka utim sawoni e dweni: ");
INSERT INTO luo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Kuom ndalo abiriyo chamuru Makati ma ok oketie thowi kendo chiengʼ mar abiriyo timuru nyasi ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Chamuru makati ma ok oketie thowi kuom ndalo abiriyogo; gimoro amora man-gi thowi kik yudi e kindu kata e pinyu duto. ");
INSERT INTO luo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Chiengʼno wachne wuodi ni, ‘Atimo ma nikech gima Jehova Nyasaye notimona kane awuok e piny Misri.’ ");
INSERT INTO luo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Raparni biro bedonu kaka ranyisi e lwetu kendo e lela wangʼu ni chik Jehova Nyasaye nyaka bed e dhou kinde duto, Jehova Nyasaye nogolou e piny Misri gi lwete maratego. ");
INSERT INTO luo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Rit chikni e ndalo mowal higa ka higa. ");
INSERT INTO luo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Bangʼ ka Jehova Nyasaye osekelou e piny jo-Kanaan mi omiyougo, kaka ne osingo ka okwongʼorenu kaachiel gi kwereu, ");
INSERT INTO luo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","to nyaka uchiw ni Jehova Nyasaye nyak mokwongo mar nyodo. Chiayo ka chiayo madichwo makayo gin mag Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Nyaka uwar nyathi punda ka nyathi punda mokwong nywol ka uchiwo nyarombo kare, to ka ok iware, to tur ngʼute. Waruru kayo duto mag yawuotu. ");
INSERT INTO luo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“E kinde mabiro, ka wuodi nopenji ni, ‘Ma to nyiso angʼo?’ To nyise ni, ‘Jehova Nyasaye nogolowa e piny Misri gi lwete maratego kama ne wabede wasumbini. ");
INSERT INTO luo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Kane Farao kuom wich teko mare otamore weyowa mondo wadhi, Jehova Nyasaye nonego nyithindo makayo duto mag dhano gi mag jamni, e piny Misri. Ma emomiyo atimo ne Jehova Nyasaye misango gi nyithind jamni machwo makayo, to wawaro yawuotwa kwachiwo gik moko kargi.’ ");
INSERT INTO luo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Kendo obiro bedoni kaka ranyisi e lweti kendo kido e lela wangʼi ni Jehova Nyasaye nogolowa e piny Misri gi lwete maratego.” ");
INSERT INTO luo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Kane Farao oweyo ogandano odhi, Nyasaye ne ok oweyogi giluwo yo mangʼado e piny jo-Filistia, kata obedo ni yorno ne ngʼado machiegni. Nimar Nyasaye nowacho niya, “Ka jogi oromo gi lweny, to ginyalo loko pachgi mi gidog e piny Misri.” ");
INSERT INTO luo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Omiyo Nyasaye notelonegi ma giluwo yo malworo thim mochomo Nam Makwar. Jo-Israel nowuok e piny Misri ka oikore ne lweny. ");
INSERT INTO luo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa nokawo choke Josef ka nowuok nimar Josef noketo yawuot Israel osingore ka kwongʼore. Nowacho niya, “Nyasaye biro resou adier, bangʼe nyaka utingʼ chokena ka ua ka.” ");
INSERT INTO luo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Kane gisewuok Sukoth, ne gibworo Etham e lak thim. ");
INSERT INTO luo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Godiechiengʼ Jehova Nyasaye netelonegi gi bor polo mondo otelnegi e yorgi kendo gotieno notelonegi gi ligek mach mondo omigi ler, mondo mi negiwuothi odiechiengʼ kata otieno. ");
INSERT INTO luo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Boche mag polo mane otelonegi godiechiengʼ kata ligek mach mane otelonegi gotieno ne ok owuok kama ne entiere e nyim ogandano. ");
INSERT INTO luo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Eka Jehova Nyasaye nowacho ne Musa niya; ");
INSERT INTO luo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Nyis jo-Israel oduogi mondo gibuor machiegni gi Pi Hahiroth mantie e kind Migdol gi nam. Gibiro bworo machiegni gi nam, mochomore gi Baal Zefon. ");
INSERT INTO luo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farao biro paro kowacho ni, ‘Jo-Israel digni e piny korwenyo e thim.’ ");
INSERT INTO luo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Abiro miyo chuny Farao bedo mapek, mi owuogi kolawo jo-Israel. To abiro yudo duongʼ ne an awuon kuom Farao kaachiel gi jolwenje duto, eka jo-Misri nongʼe ni an Jehova Nyasaye.” Eka jo-Israel notimo kamano. ");
INSERT INTO luo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kane onyis ruodh Misri ni jogo osedhi, Farao gi jodonge noloko pachgi kuom jo-Israel mi giwacho niya, “Angʼo ma wasetimoni? Waseweyo jo-Israel odhi kendo tije ma yande gitiyonwa orumo!” ");
INSERT INTO luo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Eka ne oikne geche mar jolweny, bangʼe nokawo jolweny mage. ");
INSERT INTO luo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Nokawo geche mia auchiel mabeyo mag lweny, kod geche mamoko mag jo-Misri ka moro ka moro nigi jatend lweny. ");
INSERT INTO luo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Jehova Nyasaye nomiyo chuny Farao ma ruodh Misri odoko matek, mi nolawo jo-Israel mane wuotho ka gin gi chir. ");
INSERT INTO luo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Jo-Misri kod farese Farao gi gechegi, gi joidh farese kod jolweny nolawo jo-Israel mi gijukogi ka gibworo e bath nam machiegni gi Pi Hahiroth mochomore gi Baal Zefon. ");
INSERT INTO luo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kane Farao ochopo machiegni kodgi, jo-Israel notingʼo wangʼ-gi mi gineno ka jo-Misri lawogi. Luoro nomakogi mi giywakne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Negiwacho ni Musa niya, “Ne onge kuonde yiko mane inyalo yikwae e piny Misri momiyo ikelowa e thim ka mondo wathoe? En angʼo ma isetimonwani kuom golowa e piny Misri? ");
INSERT INTO luo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Donge ne wanyisi e piny Misri ni, ‘Wewa, mondo watine jo-Misri?’ Dine bernwa tiyo ni jo-Misri moloyo tho e thim!” ");
INSERT INTO luo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa nodwoko ogandano niya, “Kik ubed maluor. Chungʼuru motegno eka ubiro neno resruok ma Jehova Nyasaye biro kelonu kawuono. Jo-Misri ma uneno kawuononi ok unuchak une kendo. ");
INSERT INTO luo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Jehova Nyasaye biro kedonu; owinjore ubed gi kwe.” ");
INSERT INTO luo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Eka Jehova Nyasaye nowacho ne Musa niya, “Angʼo momiyo uywakna? Nyis jo-Israel mondo odhi nyime giwuoth. ");
INSERT INTO luo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Tingʼ ludhi malo kendo irie badi ewi nam mondo ipog pige eka jo-Israel ongʼad nam kawuotho e lowo motwo. ");
INSERT INTO luo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Abiro keto chuny jo-Misri doko matek mondo gilaw bangʼ-gi nyaka ei nam. Kendo abiro yudo duongʼ kuom Farao kaachiel gi jolweny gi geche lwenje kod joidh faresene. ");
INSERT INTO luo_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Jo-Misri biro ngʼeyo ni an Jehova Nyasaye ka ayudo duongʼ kuom Farao gi gechene kod joidh faresene.” ");
INSERT INTO luo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Eka Malaika mar Nyasaye, mane osebedo kotelo e nyim jolwenj jo-Israel, nodok chien bangʼ jo-Israel. Bor polo bende ne osudo machiegni e nyim jo-Israel mi odok ka ngʼegi, ");
INSERT INTO luo_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ka ochungʼ e kind jolwenj jo-Misri kod jo-Israel. Otienono duto bor polono nokelo mudho ne konchiel to komachielo nokelo ler; omiyo onge oganda mane osudo machiegni gi machielo otienono duto. ");
INSERT INTO luo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Eka Musa norieyo bade ewi nam, kendo otienono duto Jehova Nyasaye notugo yamo ma aa yo wuok chiengʼ mopogo pi nyadiriyo mi kanyo olokore lowo motwo. Pige nopogore, ");
INSERT INTO luo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","kendo jo-Israel nongʼado nam kawuotho e lowo motwo, ka pi ogingore e bathgi korachwich gi koracham. ");
INSERT INTO luo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Jo-Misri nolawogi kendo farese Farao duto gi gechene kaachiel gi joidh gechene nolawogi nyaka ei nam. ");
INSERT INTO luo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Kane piny dwaro yawore Jehova Nyasaye nonenogi gie ligek mach, mine omiyo jolwenj jo-Misri odigni. ");
INSERT INTO luo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Nomiyo tiende gechegi owuok mine ok ginyal riembogi. Eka jo-Misri nowacho niya, “Waringuru waa kuom jo-Israel! Jehova Nyasaye ema kedonegi kod jo-Misri.” ");
INSERT INTO luo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Eka Jehova Nyasaye nowacho ne Musa niya, “Rie badi e nam mondo pi oum jo-Misri gi gechegi kod joidh faresegi.” ");
INSERT INTO luo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa norieyo bade e nam kendo ka piny ne oyawore, to nonwangʼo ka pi osedok e wangʼe. Jo-Misri ne ringo kochomo dier nam, kendo Jehova Nyasaye noywerogi gi pi nyaka ei namno. ");
INSERT INTO luo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Pi nogingore kadok kare kendo noimo geche gi joidh farese gi jolweny Farao duto mane olawo jo-Israel nyaka e nam. Onge kata achiel kuomgi mane otony. ");
INSERT INTO luo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Jo-Israel to nongʼado nam kawuotho e lowo motwo, ka pi ogingore e bathgi korachwich gi koracham. ");
INSERT INTO luo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Chiengʼno Jehova Nyasaye noreso Israel e lwet jo-Misri, kendo Israel noneno ka jo-Misri otho e dho nam. ");
INSERT INTO luo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Bangʼ ka jo-Israel noseneno teko maduongʼ mane Jehova Nyasaye onyiso kokedo gi jo-Misri, oganda noluoro Jehova Nyasaye kendo negiketo genogi kuome kaachiel gi kuom Musa jatichne. ");
INSERT INTO luo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Eka Musa gi jo-Israel nowero wendni ni Jehova Nyasaye: “Abiro wer ni Jehova Nyasaye, nimar nyinge oromo mi duongʼ. Oseumo faras kod jariembne ei nam. ");
INSERT INTO luo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Jehova Nyasaye e tekrena bende en e wenda; kendo osebedo warruokna. Anapake nimar en Nyasacha, ma Nyasach wuora, kendo abiro miyo nyinge duongʼ. ");
INSERT INTO luo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Jehova Nyasaye en jalweny; Jehova Nyasaye e nyinge. ");
INSERT INTO luo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Noimo geche Farao kod jolwenje ei Nam Makwar. Jodong Farao mogen duto noimo e nam makwar. ");
INSERT INTO luo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Pige matut oseimogi duto, kendo gisenimo nyaka e bwo pi mana ka kidi. ");
INSERT INTO luo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Yaye Jehova Nyasaye, lweti ma korachwich ne nigi teko maduongʼ. Yaye, Jehova Nyasaye lweti ma korachwich ema isetiekogo wasigu. ");
INSERT INTO luo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“Kuom tekoni maduongʼ, ne iloyo jogo mane opiem kodi. Ne inyiso mirimbi mager mi nomwonyogi kaka lum. ");
INSERT INTO luo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Muya mawuok e umi nomiyo pige ogingore malo. Apaka mar pi nogingore mochungʼ ka kor ot; pige man kuonde matut nochokore e chuny nam.” ");
INSERT INTO luo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Jawasigu nosungore kawacho niya, “Abiro lawogi, abiro jukogi. Abiro pogo mwandugi; abiro yako gimoro amora. Abiro golo liganglana kendo lweta biro tiekogi. ");
INSERT INTO luo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Kane ikudho muchi kende, to nam noimogi. Ne ginimo ka chuma e apaka maduongʼ. ");
INSERT INTO luo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“En ngʼa machal kodi e kind nyiseche, yaye Jehova Nyasaye? En ngʼa machalo kodi: in miler moloyo, in ma in-gi duongʼ moloyo kendo matimo honni? ");
INSERT INTO luo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ne irieyo badi ma korachwich ma piny omwonyogi. ");
INSERT INTO luo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Kuom herani ma ok rum, ibiro telone oganda ma isereso. Kuom tekoni ibiro telonegi nyaka kar dakni maler. ");
INSERT INTO luo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Pinje biro winjo mi tetni, kihondko biro mako jo-Filistia. ");
INSERT INTO luo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Jodong Edom kibaji biro goyo, bende jotend Moab biro tetni, to jo-Kanaan chunygi biro nyosore; ");
INSERT INTO luo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","kibaji kod kihondko biro biro kuomgi. Kuom teko mar lweti gibiro lingʼ thi ka kidi, nyaka ogandani kadhi, yaye Jehova Nyasaye, nyaka jogi mane ichweyo kadhi. ");
INSERT INTO luo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Yaye Jehova Nyasaye, ibiro kelogi mi gidonji kendo ibiro miyo gibedi ewi godi mar girkeni, ma en kama ne iloso kaka kar dakni, kendo kama ler mar lemo mane iloso gi lweti, yaye Ruoth Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Jehova Nyasaye biro locho nyaka chiengʼ.” ");
INSERT INTO luo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ka farese Farao gi gecheni kod joidh faresene ne odhi e nam, Jehova Nyasaye nomiyo pi nam odok e wangʼe mi oimogi, to jo-Israel nongʼado nam kawuotho ewi lowo motwo. ");
INSERT INTO luo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Eka Miriam janabi madhako ma nyamin Harun, nokawo oyieke e lwete kendo mon duto noluwo bangʼe ka gin gi oyieke kendo ka gimiel. ");
INSERT INTO luo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam nowernegi niya, “Weruru ni Jehova Nyasaye, nimar otingʼe malo ahinya. Oseimo faras gi jaithne ei nam.” ");
INSERT INTO luo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Eka Musa notelo ni Israel kagiwuok e Nam Makwar kendo negidhi ei thim mar Shur. Kuom ndalo adek ne giwuotho e thim ma ok giyudo pi. ");
INSERT INTO luo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Kane gichopo Mara, ne ok ginyal modho pi makanyo nikech nokech. (Mano emomiyo kanyo iluongo ni Mara.) ");
INSERT INTO luo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Kuom mano ogandano nongʼur ne Musa kawacho niya, “Wabiro modho angʼo?” ");
INSERT INTO luo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Eka Musa noywak ne Jehova Nyasaye kendo Jehova Nyasaye nonyise yien moro. Nobole ei pi mi pi obedo mamit. Kanyo ema Jehova Nyasaye nomiyogie buche kod chike kendo notemogi. ");
INSERT INTO luo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Nowachonegi niya, “Ka uchiko itu maber ne wach Jehova Nyasaye ma Nyasachu ma utimo gima kare e nyim wangʼe, ka urito chikene kendo umako buchene duto, to ok anakel kuomu tuo moro amora mane akelo ne jo-Misri, nimar an Jehova Nyasaye machangou.” ");
INSERT INTO luo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Eka negichopo Elim, kama ne nitie sokni apar gariyo kod yiende mag othidhe piero abiriyo mine gibworo kanyo machiegni gi pi. ");
INSERT INTO luo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Oganda jo-Israel duto nochako wuoth kawuok Elim mi gidhi e thim mar Sin mantie e kind Elim gi Sinai, chiengʼ mar apar gabich mar dwe mar ariyo bangʼ kane gisewuok Misri. ");
INSERT INTO luo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","E thim kanyo oganda jo-Israel duto nongʼur ne Musa gi Harun. ");
INSERT INTO luo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Jo-Israel nowachonegi niya, “Mad ne Jehova Nyasaye negwa e piny Misri! Kuno ne wabet kwalworo agulni mopongʼ gi ringʼo, kendo ne wachamo kit chiemo moro amora mane wadwaro, to isekelowa e thim ka mondo kech oneg ogandani duto.” ");
INSERT INTO luo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Eka Jehova Nyasaye nowacho ne Musa niya, “Abiro lwaronu makati koa e polo malo. Ji nyaka wuogi pile pile mondo ochok moromogi odiechiengno. Kuom yorni abiro temogigo mondo ane kata ka gibiro luwo chikena.” ");
INSERT INTO luo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Chiengʼ mar auchiel nyaka gitedi gima gichoko, mano nyaka bed marom nyadiriyo kuom gima gisebedo ka gichoko odiechienge moko odiechiengʼ kodiechiengʼ. ");
INSERT INTO luo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Kuom mano Musa gi Harun nowacho ne jo-Israel duto kama: “Godhiambo ubiro ngʼeyo ni ne en Jehova Nyasaye ema noresou Misri, ");
INSERT INTO luo_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","kendo gokinyi ubiro neno duongʼ mar Jehova Nyasaye, nikech osewinjo ngʼur ma ungʼurnego. Wan to wan ngʼa gini ma dimi ungʼurnwa?” ");
INSERT INTO luo_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Bende Musa nowachonegi niya, “Ubiro ngʼeyo ni ne en Jehova Nyasaye ka omiyou ringʼo mondo ucham godhiambo kendo gi Makati duto ma udwaro gokinyi nimar osewinjo ngʼur ma ungʼurnego. Wan to wan ngʼa? Ok wan ema ungʼurnwa to ungʼurne mana Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Eka Musa nowacho ni Harun niya, “Nyis oganda jo-Israel duto ni, ‘Biuru e nyim Jehova Nyasaye, nimar osewinjo ngʼur ma ungʼurgo.’ ” ");
INSERT INTO luo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ka pod Harun ne wuoyo ni oganda jo-Israel duto, negingʼiyo yo thim kendo duongʼ mar Jehova Nyasaye ne othinyore e boche polo. ");
INSERT INTO luo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Asewinjo ngʼur mar jo-Israel. Nyisgi kama, ‘Ka piny yuso ubiro chamo ringʼo kendo gokinyi ubiro chamo Makati muyiengʼ. Eka ubiro ngʼeyo ni an Jehova Nyasaye ma Nyasachu.’ ” ");
INSERT INTO luo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Odhiambono, aluru nobiro moimo kambi kendo gokinyi ne nitie thoo momoko koluoro kambi. ");
INSERT INTO luo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Kane thoo oserumo, gik marochere mongʼinore ongʼinore momoko ewi lowo nonenore. ");
INSERT INTO luo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ka jo-Israel nonene, negipenjore kendgi niya, “Ma en angʼo?” Nimar ne ok gingʼeyo gima ne en. Musa nowachonegi niya, “En e Makati ma Jehova Nyasaye osemiyou mondo ucham. ");
INSERT INTO luo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ma e gima Jehova Nyasaye osechiko, ‘Ngʼato ka ngʼato nyaka chok mangʼeny kaka odwaro. Kaw moromo ngʼato ka ngʼato ma udakgo.’ ” ");
INSERT INTO luo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Jo-Israel notimo kaka nonyisgi; jomoko nochoko mangʼeny, to jomoko nochoko matin. ");
INSERT INTO luo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","To kane gipimogi gi gir pimo mar omer, ngʼat mane ochoko mangʼeny ok ne nigi mangʼeny bende ngʼat mane ochoko matin ok ne nigi matin ahinya. Ngʼato ka ngʼato nochoko mana mangʼeny moromo gi dwarone. ");
INSERT INTO luo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Eka Musa nowachonegi niya, “Onge ngʼato manokan chiemono kata matin nyaka okinyi.” ");
INSERT INTO luo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Kata kamano, jomoko kuomgi ne ok odewo wach Musa, negikano moko nyaka okinyi, to negiyudo ka kudni opongʼo chiemono kendo negichako dungʼ. Kuom mano Musa ne iye owangʼ kodgi. ");
INSERT INTO luo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Okinyi ka okinyi ngʼato ka ngʼato ne choko moromo gi dwarone to ka chiengʼ nobedo makech to chiemono ne oleny. ");
INSERT INTO luo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Chiengʼ mar auchiel, ngʼato ka ngʼato nochoko morome nyadiriyo, bangʼe to jotend dhoudi nobiro mokelo ne Musa wachni. ");
INSERT INTO luo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Eka nowachonegi kama, “Ma e gima Jehova Nyasaye ochiko, ‘Kiny en odiechieng yweyo, ma en Sabato maler mowal ne Jehova Nyasaye. Teduru mago mudwaro tedo kendo bokuru mago mudwaro boko, to modongʼ to ukan nyaka kiny.’ ” ");
INSERT INTO luo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kuom mano negikano chiemo nyaka okinyi mana kaka Musa nochikogi kendo chiemono ne ok owichore kata timo kudni. ");
INSERT INTO luo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa nowachonegi niya, “Mano ema ucham kawuono nikech kawuono en Sabato ni Jehova Nyasaye. Ok unuyud chiemo munyalo kwanyo kawuono. ");
INSERT INTO luo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Chokuru chiemo kuom ndalo auchiel, nimar odiechiengʼ mar abiriyo ma en Sabato ok nonwangʼ chiemono.” ");
INSERT INTO luo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Kata kamano, jomoko nodhi mondo ochok chiemo chiengʼ mar abiriyo, to ne ok giyudo. ");
INSERT INTO luo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Eka Jehova Nyasaye nowacho ne Musa niya, “Ubiro tamoru rito chikena kod puonjna nyaka karangʼo?” ");
INSERT INTO luo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Beduru kungʼeyo ni Jehova Nyasaye osemiyou Sabato, mano emomiyo chiengʼ mar auchiel omiyou Makati moromo ndalo ariyo. Ngʼato ka ngʼato nyaka sik kama entie chiengʼ mar abiriyo, kendo onge ngʼama nodhi oko. ");
INSERT INTO luo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kuom mano oganda noyweyo chiengʼ mar abiriyo. ");
INSERT INTO luo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Oganda jo-Israel noluongo makatino ni manna nikech nochalo gi kodhi matindo tindo marachere, kendo ne en gi ndhandhu machal gi kek moted gi mor kich. ");
INSERT INTO luo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa nowacho niya, “Ma e gima Jehova Nyasaye osechiko, ‘Kaw mana moromo ngʼato achiel chamo kendo kane ni tienge mabiro mondo gine Makati mane amiyou uchamo e thim kane agolou e piny Misri.’ ” ");
INSERT INTO luo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Kuom mano Musa nonyiso Harun kama, “Kaw manna madirom ngʼato achiel chamo mondo iket e agulu. Bangʼe kete e nyim Jehova Nyasaye mondo okane ne tienge mabiro.” ");
INSERT INTO luo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kaka Jehova Nyasaye nochiko Musa, Harun noketo manna e nyim Sandug Muma mondo mi okane. ");
INSERT INTO luo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Jo-Israel nochamo manna kuom higni piero angʼwen nyaka negichopo e piny mane ji odakie, negichamo manna nyaka negichopo e tongʼ mar piny Kanaan. ");
INSERT INTO luo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Omer en achiel kuom apar mar efa.) ");
INSERT INTO luo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Oganda jo-Israel duto nochako wuoth kawuok e thim mar Sin, ka giwuotho ka gi kacha mana kaka Jehova Nyasaye nochikogi. Ne gibworo Refidim, to ne onge pi mane ji nyalo modho. ");
INSERT INTO luo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kuom mano negidhawo gi Musa kagiwacho niya, “Miwa pi wamodhi.” To Musa nodwokogi niya “En angʼo momiyo udhawo koda? En angʼo momiyo uketo Jehova Nyasaye e tem?” ");
INSERT INTO luo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","To kata kamano ji ne riyo mar pi oloyo kanyo, kendo ji nongʼur ni Musa. Negiwachone niya, “En angʼo momiyo nigolowa Misri mondo nyithindwa kaachiel gi jambwa otho?” ");
INSERT INTO luo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Eka Musa noywak ni Jehova Nyasaye niya, “En angʼo mowinjore atim kod jogi? Gichiegni kata mana goya gi kite.” ");
INSERT INTO luo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Jehova Nyasaye nowacho ne Musa niya, “Wuothi idhi e nyim oganda. Kaw jodong jo-Israel moko mondo odhi kodi kendo kaw luth mane ichwadogo aora Nael mondo idhigo. ");
INSERT INTO luo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Abiro chungʼ e nyimi e bath lwanda mantie Horeb. Chwad lwanda to pi nowuog kuome mi oganda nomodhi.” Kuom Mano Musa notimo kamano e nyim jodong jo-Israel duto. ");
INSERT INTO luo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Eka nochako kanyo ni Masa kod Meriba nikech jo-Israel nogwandore kanyo to bende nikech ne gitemo Jehova Nyasaye kagiwacho niya, “Bende Jehova Nyasaye ni e dierwa koso?” ");
INSERT INTO luo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Jo-Amalek nobiro momonjo jo-Israel Refidim. ");
INSERT INTO luo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Eka Musa nonyiso Joshua niya, “Yier jomoko kuom jowa mondo idhi iked gi jo-Amalek. Kiny anachungʼ ewi got gi ludh Nyasaye e lweta.” ");
INSERT INTO luo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Kuom mano Joshua nokedo gi jo-Amalek mana kaka Musa nochiko, kendo Musa gi Harun kod Hur nodhi ewi got. ");
INSERT INTO luo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","E kinde duto mane Musa osiko kotingʼo bedene malo, to jo-Israel ne loyo, to kane Musa odwoko bedene piny, to jo-Amalek ema ne loyo. ");
INSERT INTO luo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ka bede Musa nojony, to negikawo kidi mi giketone mondo obedie. Harun gi Hur ne ojuko bedene kotingʼo malo, ka ngʼato achiel omako bade konchiel, to machielo omako komachielo, omiyo bedene nosiko kochungʼ tir nyaka podho chiengʼ. ");
INSERT INTO luo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Kuom mano Joshua noloyo jolwenj jo-Amalek mana gi ligangla. ");
INSERT INTO luo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Eka Jehova Nyasaye nowacho ne Musa niya, “Ndik wachni e kitap ndiko kaka gima ibiro par bende nyaka ine ni Joshua owinje, nimar abiro tieko jo-Amalek duto e piny ka.” ");
INSERT INTO luo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa nogero kendo mar misango mochake ni “Jehova Nyasaye en banderana.” ");
INSERT INTO luo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Nowacho kama, “Nimar bede notingʼ malo e nyim kom duongʼ mar Jehova Nyasaye. Kendo Jehova Nyasaye noked gi jo-Amalek e tienge duto.” ");
INSERT INTO luo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Koro Jethro, jadolo mar Midian kendo jaduongʼ Musa, nowinjo gik moko duto mane Nyasaye osetimo ni Musa, kaachiel gi joge ma jo-Israel, bende kaka Jehova Nyasaye nosegolo jo-Israel kawuok e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Bangʼ ka Musa ne oseriembo chiege ma Zipora, jaduongʼne Jethro norwake ");
INSERT INTO luo_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","kaachiel gi yawuote ariyo. Wuowi achiel niluongo ni Gershom nimar Musa nowacho niya, “Asebedo jadak e piny ma ok marwa,” ");
INSERT INTO luo_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","to machielo nochako ni Eliezer nimar nowacho niya, “Nyasach wuonwa ema ne jakonyna, ne oresa kane Farao dwaro nega gi ligangla.” ");
INSERT INTO luo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jethro, jaduongʼ Musa, kaachiel gi yawuot Musa gi chi Musa, ne jobiro ire e thim kama ne ojotie but got mar Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Noyudo ka Jethro oseorone wach niya, “An, jaduongʼni Jethro abiro iri gi chiegi kaachiel gi nyithindi ariyo.” ");
INSERT INTO luo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Kuom mano Musa nowuok mondo orom ni jaduongʼne mi nokulore piny kendo onyodhe. Ne gimosore eka bangʼe gidonjo ei hema. ");
INSERT INTO luo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa nonyiso jaduongʼne gik moko duto ma Jehova Nyasaye notimone Farao kaachiel gi jo-Misri, nikech jo-Israel. Bende nonyise chandruok duto mane giseyudo e yo kendo kaka Jehova Nyasaye noseresogi. ");
INSERT INTO luo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro ne mor mar winjo gik mabeyo duto ma Jehova Nyasaye nosetimo ne jo-Israel kuom resogi e lwet jo-Misri. ");
INSERT INTO luo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Nowacho niya, “Opak Jehova Nyasaye, ma noresoi e lwet jo-Misri bende e lwet Farao kendo oreso oganda e lwet jo-Misri. ");
INSERT INTO luo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Koro angʼeyo ni Jehova Nyasaye duongʼ moloyo nyiseche moko duto, nimar notimo kamano ne joma nosando jo-Israel marach.” ");
INSERT INTO luo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Eka Jethro, jaduongʼ Musa, nokelo misango miwangʼo pep kod misengni mamoko bende ne Nyasaye, kendo Harun nobiro kod jodongo duto mag jo-Israel mondo gichiem gi jaduongʼ Musa e nyim Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Kinyne, Musa nobet e kome mondo obed jangʼad bura ne ogandano, kendo negichungʼ ka gilwore chakre okinyi nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Kane jaduongʼne oneno gik moko duto mane Musa timo ne oganda, nowacho ne kama, “En angʼo ma itimo ne ogandani? En angʼo momiyo in kendi ema ibedo kaka jangʼad bura, ka jogi olwori chakre okinyi nyaka odhiambo?” ");
INSERT INTO luo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa nodwoke niya, “Nikech ji biro ira mondo omany dwach Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ka gin gi larruok moro amora e kindgi, to ikelona kendo athego joma ochwanyorego mi anyisgi buche kod chike mag Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Jaduongʼ Musa nodwoko kawacho niya, “Gima itimoni ok ber. ");
INSERT INTO luo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","In kaachiel gi joma osebiro irigi ubiro mana ool. Tijni pek mohewi; ok inyal time kendi. ");
INSERT INTO luo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Chik iti mondo angʼadni rieko kendo Nyasaye obed kodi. Onego ibed jachungʼ jogi e nyim Nyasaye kendo iter larruokgi e nyime. ");
INSERT INTO luo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Puonjgi buche kod chike duto kendo nyisgi kaka onego gidagi kod tije monego gitim. ");
INSERT INTO luo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","To nyaka iyier joma niginyalo ma gin ji moluoro Nyasaye, joma ogen ma ok kaw asoya, kendo iketgi gibed jotend ji maromo alufu alufu, mia mia, piero abich abich, kod apar apar. ");
INSERT INTO luo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ketgi mondo gibedi jongʼad bura ni oganda kinde duto, to buche matek kende ema ginyalo keloni. Buche mayot ginyalo ngʼado giwegi, nimar mano biro miyo tingʼ ma in-go bedo mayot, nimar gibiro lawe kodi. ");
INSERT INTO luo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ka itimo kama kaka Nyasaye dwaro, to ok ibi ol kendo jogi biro dok e miechgi kamor.” ");
INSERT INTO luo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa nowinjo jaduongʼne mi notimo gik moko duto mane owacho. ");
INSERT INTO luo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Noyiero joma riek kuom jo-Israel duto mi noketogi jotelo mag ji alufu alufu, mia mia, piero abich abich, kod apar apar. ");
INSERT INTO luo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Negitiyo kaka jongʼad bura mar oganda kinde duto. Buche matek negikelo ne Musa, to buche mayot negitieko giwegi. ");
INSERT INTO luo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Eka Musa nokowo jaduongʼne e yo kendo Jethro nodok e pinygi. ");
INSERT INTO luo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","E dwe mar adek bangʼ ka jo-Israel nosewuok Misri, negichopo e thim Sinai e odiechiengʼno. ");
INSERT INTO luo_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Bangʼ kane gisewuok Refidim, negidonjo thim Sinai, kendo Israel nojot e nyim got e thimno. ");
INSERT INTO luo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Eka Musa noidho got mondo odhi owuo gi Nyasaye kendo Jehova Nyasaye noluonge gi ewi got mowachone kama: “Ma e gima iwachne od Jakobo to gi jo-Israel. ");
INSERT INTO luo_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Un uwegi useneno gima ne atimone piny Misri kendo kaka ne atingʼou mana kaka ongo tingʼo nyithinde mi akelou ira awuon. ");
INSERT INTO luo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Koro, ka uwinja chuth mi urito singruokna, to kuom ogendini duto ubiro bedo mwanduna awuon. Kata obedo ni piny duto en mara, ");
INSERT INTO luo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","un to ubiro bedona oganda mar jodolo kendo oganda maler.’ Magi e weche manyaka iwachne jo-Israel.” ");
INSERT INTO luo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Kuom mano Musa nodok moluongo jodongo duto mag oganda mi oketo e nyimgi weche duto mane Jehova Nyasaye ochike mondo owachi. ");
INSERT INTO luo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Oganda duto nodwoko kanyakla kawacho niya, “Wabiro timo gik moko duto ma Jehova Nyasaye ochiko.” Kuom mano Musa nodwoko wachgi ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Jehova Nyasaye nowacho ne Musa niya, “Abiro biro iru e boche polo mondo omi oganda owinj kaka awuoyo kodi kendo mano biro miyo giket genogi kuomi ndalo duto.” Eka Musa nonyiso Jehova Nyasaye gima oganda nowacho. ");
INSERT INTO luo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Kendo Jehova Nyasaye nowacho ne Musa niya, “Dhi ir oganda mondo ipwodhgi kawuono gi kiny. Ketgi giluok lepgi ");
INSERT INTO luo_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","mondo gibed moikore e odiechiengʼ mar adek, nimar chiengʼno Jehova Nyasaye biro lor ewi Got Sinai ka ji duto nene. ");
INSERT INTO luo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ket tongʼ ne oganda molworo got kendo nyisgi ni, ‘Beduru motangʼ mondo kik ngʼato idh got kata mulo tie got, nimar ngʼato angʼata mochopo e tiend godni to nyaka negi. ");
INSERT INTO luo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ngʼatno nyaka chiel gi kite, kata chwowe gi asere; to kik ngʼato angʼata ket lwete kuome. Bed ni en dhano kata le, ok noweye mondo obed mangima.’ To ji nyalo idho godno mana ka tungʼ oywak kuom thuolo malach.” ");
INSERT INTO luo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Bangʼ ka Musa noselor e got modhi ir oganda, nopwodhogi mine gilwoko lepgi. ");
INSERT INTO luo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Eka nowacho ne oganda niya, “Ikreuru ne odiechiengʼ mar adek kendo kik ngʼato riwre gi chiege.” ");
INSERT INTO luo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Chiengʼ mar adek gokinyi, polo nomil kamor, ka boche polo okwako wi got kendo turumbete noywag matek, ma ji duto mane ni e kambi notetni. ");
INSERT INTO luo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Eka Musa notelo ne oganda kawuok e kambi mondo orom gi Nyasaye, kendo negichungʼ e tiend got. ");
INSERT INTO luo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Iro noimo Got Sinai nikech Jehova Nyasaye nolor kanyo ei mach. Iro ne dhwolore kawuok ewi godno mana ka iro mawuok e kendo, mi got duto noyiengni, ");
INSERT INTO luo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","kendo turumbete nomedo ywak matek. Eka Musa nowuoyo kendo Nyasaye nodwoke. ");
INSERT INTO luo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Jehova Nyasaye nolor ewi Got Sinai mi oluongo Musa nyaka ewi godno. Omiyo Musa noidho e got ");
INSERT INTO luo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","mi Jehova Nyasaye nowachone niya, “Dhiyo kendo isiem ji mondo kik girire ni gidwaro neno Jehova Nyasaye nimar thothgi nyalo tho. ");
INSERT INTO luo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Kata mana jodolo ma osudo ir Jehova Nyasaye nyaka pwodhre ka ok kamano to Jehova Nyasaye nomwomre kuomgi.” ");
INSERT INTO luo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa nowacho ne Jehova Nyasaye niya, “Ji ok nyal biro ewi Got Sinai nimar in iwuon ema ne isiemowa ni mondo waket kiewo molworo got mondo owale obed maler.” ");
INSERT INTO luo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Jehova Nyasaye nodwoke niya, “Lor piny iom Harun ibigo ira. To jodolo gi ji kik rire mondo one Jehova Nyasaye, nono to abiro mwomora kuomgi.” ");
INSERT INTO luo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Kuom mano Musa nolor piny ir ji monyisogi gik mane Jehova Nyasaye owachone. ");
INSERT INTO luo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Eka Nyasaye nowuoyo kowacho niya, ");
INSERT INTO luo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“An e Jehova Nyasaye ma Nyasachu mane ogolou e piny Misri, ka uwuok e piny mane unie wasumbini. ");
INSERT INTO luo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Kik ubed gi nyiseche mamoko e nyima. ");
INSERT INTO luo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Kik ulos nyasaye milamo maket gi kido moro amora e polo malo kata e piny mwalo, kata e bwo pi. ");
INSERT INTO luo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Kik ukulrunegi piny; bende kik ulamgi; nimar An, Jehova Nyasaye ma Nyasachu, An Nyasaye ma janyiego, kendo akumo nyithindo nikech richo mar wuonegi chakre tiengʼ mar adek nyaka tiengʼ mar angʼwen mar jogo mamon koda, ");
INSERT INTO luo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","to anyiso hera ni tienge gana gi gana mar jogo mohera kendo morito chikena. ");
INSERT INTO luo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Kik uti gi nying Jehova Nyasaye ma Nyasachu e yo ma ok owinjore, nimar Jehova Nyasaye ok nongʼwon ne ngʼato angʼata matiyo gi nyinge e yo marach. ");
INSERT INTO luo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Rituru chiengʼ Sabato kendo ukete obed maler. ");
INSERT INTO luo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Tiuru kuom ndalo auchiel kendo uti tijeu duto, ");
INSERT INTO luo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","to chiengʼ mar abiriyo en Sabato ne Jehova Nyasaye ma Nyasachu. Chiengʼno ok unutim tich moro amora, bed ni un kata yawuotu kata nyiu kata jotiju machwo kata jotiju mamon kata jambu kata jodak manie dieru. ");
INSERT INTO luo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Nimar kuom ndalo auchiel Jehova Nyasaye nochweyo polo gi piny, gi nembe kaachiel gi gik moko duto manie igi, to noyweyo chiengʼ mar abiriyo. Kuom mano Jehova Nyasaye nogwedho chiengʼ Sabato mi okete maler. ");
INSERT INTO luo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Luor wuonu gi minu mondo udagi amingʼa e piny ma Jehova Nyasaye ma Nyasachu miyou. ");
INSERT INTO luo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Kik ineki. ");
INSERT INTO luo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Kik iterri. ");
INSERT INTO luo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Kik ikwal. ");
INSERT INTO luo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Kik ihang wach ne wadu. ");
INSERT INTO luo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Kik igomb od wadu. Kik igomb chi wadu kata jatije ma wuowi kata jatije ma nyako, kata rwadhe kata pundane kata gire moro amora.” ");
INSERT INTO luo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Kane oganda oneno mil polo gi mor polo kendo owinjo ywak turumbete mi gineno ka got otimo iro, luoro nomakogi. Negisudo gichien ");
INSERT INTO luo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","mi giwachone Musa niya, “Wuo kodwa in iwuon to wabiro winjo. Kik iwe Nyasaye wuo kodwa nono to wabiro tho.” ");
INSERT INTO luo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa nowacho ne oganda niya, “Kik ubed maluor. Nyasaye osebiro mondo otemu mondo omi usik kuluore kendo mondo kik utim richo.” ");
INSERT INTO luo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ogandano nochungʼ gichien ka Musa to ne ochomo bor polo kama Nyasaye ne nitie. ");
INSERT INTO luo_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Eka Jehova Nyasaye nowacho ne Musa niya, “Nyis jo-Israel kama: ‘Useneno un uwegi ni asewuoyo kodu ka aa e polo. ");
INSERT INTO luo_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kik ulos nyiseche manono mondo opiem koda; bende kik ulos nyiseche mag kido mag fedha kata dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Losnauru kendo mar misango mochwe gi lowo kendo timieuru misenginiu miwangʼo pep kod mag lalruok gi rombeu gi dieu kod dhou. Kinde moro amora ma amiyo nyinga oyudo duongʼ, to anabi iru mi agwedhu. ");
INSERT INTO luo_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ka ulosona kendo mar misango mar kite, to kik ugere gi kite mopa, nimar ubiro miyo kendono bedo mogak ka utiyoe gi gige payo kite. ");
INSERT INTO luo_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Kendo kik udhi e kendona mar misango ka uwuotho e kuonde motingʼore ma iidhogo malo, dipo ka dugu onenorene.’ ");
INSERT INTO luo_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Magi e chike manyaka iketi e nyimgi. ");
INSERT INTO luo_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Ka ingʼiewo ja-Hibrania ma misumba, to enotini kuom higni auchiel. To e higa mar abiriyo, enobed thuolo, ka ok ochulo gimoro. ");
INSERT INTO luo_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kane obiro kapok okendo, to nodog kende; to kane obiro ka osekendo, to nodog gi chiegeno. ");
INSERT INTO luo_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ka ruodhe omiye dhako kendo onywolone yawuowi gi nyiri, dhakono kaachiel gi nyithinde nobed mwandu ruodhe kendo mana misumbano kende ema nobed thuolo. ");
INSERT INTO luo_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“To ka misumba owacho ni, ‘Ahero ruodha kod chiega gi nyithinda kendo ok adwar bedo thuolo,’ ");
INSERT INTO luo_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","to ruodhe nyaka tere e nyim jongʼad bura. Notere e dhoot kata e siro mar dhoot kendo notuch ite gi riwi. Bangʼe obiro bedo misumbane nyaka chiengʼ. ");
INSERT INTO luo_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ka ngʼato ouso nyare kaka misumba, to ok noweye obed thuolo kaka iweyo misumba madichwo. ");
INSERT INTO luo_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","To ka ruoth mongʼieweno chunye ok mor kode; to ruodheno noweye mondo oware. Oonge gi thuolo mar use ne jopinje mamoko, nikech oseketho singruokne kode. ");
INSERT INTO luo_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ka oyiere ni wuode, to nyaka omiye duongʼ kaka nyare. ");
INSERT INTO luo_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ka wuowino onywomo dhako machielo, to nyaka omi dhako mokwongo chiemo, lewni kendo nyaka obed kode e achiel. ");
INSERT INTO luo_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","To ka ok ochiwone gik moko adekgi, to dhakono, ni thuolo mar dhi, maonge chudo moro amora mar pesa. ");
INSERT INTO luo_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Ngʼato angʼata mogoyo ngʼato kendo onego to adier nyaka negi. ");
INSERT INTO luo_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","To kata kamano, ka gima otimono obothne, ma en dwach Nyasaye mondo mi otimre; to Nyasaye nomiye kar tony moseikone. ");
INSERT INTO luo_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","To ka ngʼato ochano kendo onego ngʼat machielo kuom wangʼ teko, to goleuru oko mabor gi kar kendona mar misango kendo negeuru. ");
INSERT INTO luo_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ngʼato angʼata ma omonjo wuon kata min nyaka negi. ");
INSERT INTO luo_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ngʼato angʼata mokawo nyawadgi githuon mi omiye ngʼat machielo kuom chudo kata bed ni pod opande e kindeno moyude gi ngʼatno, to nyaka nege. ");
INSERT INTO luo_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ngʼato angʼata ma okwongʼo wuon kata min nyaka negi. ");
INSERT INTO luo_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Ka chwo gore kendo achiel kuomgi ogoyo nyawadgi gi kidi kata gi adhongʼ to ok otho, to obedo mana matuo kosiko e pien, ");
INSERT INTO luo_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","to ngʼatno mane ogocho ok nomok e wachno ka machielono ochungo mi owuotho oko gi ludhe; to kata kamano, nyaka ochul ngʼat mohinyoreno kuom thuolone mokethore kendo one ni ochango chutho. ");
INSERT INTO luo_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Ka ngʼato ogoyo dichwo kata dhako ma misumba gi luth kendo misumbano otho kaluwore gi gochono, nyaka kume. ");
INSERT INTO luo_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","To ok enokume ka misumbano ochungo oa malo bangʼ ndalo achiel kata ariyo, nimar misumbano en mwandune. ");
INSERT INTO luo_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ka chwo magore ogoyo dhako man-gi ich kendo onywol ka kinde nywol pok ochopo to onge hinyruok moro malich, ngʼat motimo marachno nyaka gol chudo moro amora ma chwor dhakono okwayo kendo jangʼad bura oyiego. ");
INSERT INTO luo_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","To ka nitie hinyruok marach to nyaka ukaw ngima kar ngima kendo ");
INSERT INTO luo_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","wangʼ kar wangʼ, kendo lak kar lak, kendo lwedo kar lwedo kendo tielo kar tielo, ");
INSERT INTO luo_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","del mowangʼ kar del mowangʼ kendo adhola kar adhola, kendo kama ogwar kar kama ogwar. ");
INSERT INTO luo_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Ka ngʼato ogoyo wangʼ misumba madichwo kata madhako ma wangʼeno okethore, to nyaka owene misumbaneno thuolo kaka chudo mar wangʼeno. ");
INSERT INTO luo_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kendo ka omuko lak misumba madichwo kata madhako, to nyaka owene misumbaneno thuolo kaka chudo mar lakeno. ");
INSERT INTO luo_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ka rwath ochwoyo dichwo kata dhako monego, rwadhno nyaka go gi kite ma tho, kendo ringe kik cham. To wuon rwadhno wachno ok nomake. ");
INSERT INTO luo_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","To kata kamano, ka rwadhno osebedo gi kido mar chwopo kendo wuon-gi osesiem to ok osetweye e dipo mi onego dichwo kata dhako, rwadhno nyaka go gi kite kendo wuon-gi bende nyaka negi. ");
INSERT INTO luo_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kata kamano, ka buch tho oloki, moketne chudo, to nyaka ochul nengo moro amora moketne mondo oresgo ngimane. ");
INSERT INTO luo_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Chik achielno ema nyaka tigo ka rwadh ochwowo nyathi ma wuowi kata ma nyako ");
INSERT INTO luo_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ka rwath ochwowo dichwo kata dhako ma misumba, to wuon rwadhno nyaka chul ruodh misumbano fedha ma pekne romo nus kilo, kendo rwadhno nyaka negi. ");
INSERT INTO luo_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Ka ngʼato oelo dho bur kata okunyo moro kendo oweyo dhoge nono mi rwadh pur kata punda onyumoree, ");
INSERT INTO luo_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","to wuon burno nyaka chul kuom lalno; kendo nyaka ochul wuon gigi kendo jamni mothogo nobed mage. ");
INSERT INTO luo_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Ka rwadh ngʼato ohinyo rwadh ngʼat machielo mi otho, to ginius rwath mangimano kendo ginipog pesa kaachiel gi ring rwath mothono marom. ");
INSERT INTO luo_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","To kata kamano, kane ongʼere ni rwadhno ne nigi kido mar chwopo, kendo wuon-gi ne osesiem to ne ok otweye, wuon-gi nyaka chul, chiayo kar chiayo kendo chiayo mothono nobed mare. ");
INSERT INTO luo_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Ka ngʼato okwalo rwath kata rombo kendo onege kata ouse, nyaka ochul dhok abich kuom rwath kendo kweth rombe angʼwen kuom rombo. ");
INSERT INTO luo_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Ka jakuo ojuk kakwelo kendo ogoye mi otho, ngʼatno mogoye remo ok nodongʼ e wiye kuom remo mochwer; ");
INSERT INTO luo_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","to ka otimore bangʼ ka chiengʼ osetuch, to remo nodongʼ e wiye. “Jakuogno nyaka chul gima rom gi gima nokawono, to ka oonge gi gimoro, to nyaka use mondo ochulgo kuo mokwalono. ");
INSERT INTO luo_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Ka chiayo mokwalno oyudego kangima bed ni en rwath kata punda kata rombo, nyaka ochul nyadiriyo. ");
INSERT INTO luo_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Ka ngʼato okwayo jambe e puodho kata e puoth mzabibu kendo oweyogi ma gi chodo kendo gikwayo e puoth ngʼato, nyaka ochul kawuok kuom puothe kata puothene mag olembe mabeyo. ");
INSERT INTO luo_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Ka mach omuoch mi olandore e bungu kendo owangʼo cham ma pod ochungʼ kata cham mobeti kata puodho duto, to ngʼatno mane omoko majno nyaka chul. ");
INSERT INTO luo_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ka ngʼato omiyo wadgi fedha kata mwandu mondo okanne kendo okwalgi e od wadgino, to ka omak jakuogno, to nyaka chul nyadiriyo. ");
INSERT INTO luo_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","To ka jakuo ok oyudi, wuon ot nyaka chopi e nyim jongʼad bura mondo gifweny ka dipo ni lwete omulo mwandu nyawadgi ");
INSERT INTO luo_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","E weche duto mag bedo gi rwath, e yo ma ok owinjore kata punda kata rombo kata law, kata gimoro amora molal ma ngʼato diwachie ni, ‘Ma en mara,’ jogo duto nyaka kel wechegigo e nyim jongʼad bura. Ngʼat ma jongʼad bura oyudo ni nigi ketho, nyaka chul wadgino nyadiriyo. ");
INSERT INTO luo_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ka ngʼato omiyo wadgi punda kata rwath kata rombo kata chiayo moro amora mondo oritne maber to chiayono otho kata ohinyore kata okwal, ");
INSERT INTO luo_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","to wach mantie e kindgi ibiro losi kuom kwongʼruok e nyim Jehova Nyasaye ne wadgino nine ok omulo mwandu wadgi. Wuon chiayono nyaka yie gi wachno, kendo onge chudo manochiw. ");
INSERT INTO luo_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","To ka chiayono ne okwal koa kuom wadgi, to nyaka wadgino chule nengo moromo gi chiayono. ");
INSERT INTO luo_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ka chiayono ne okidhi gi le mager, to enokel choke modongʼ kaka ranyisi kendo ok enochune mondo ochul chiayo mokidhino. ");
INSERT INTO luo_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Ka ngʼato oholo chiayo koa kuom wadgi kendo chiayono ohiny kata otho ka wuon-gi onge, nyaka ochul. ");
INSERT INTO luo_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","To ka wuon chiayo nigi chiayono, to jaholono ok nochun mondo ochul. Ka chiayono ne ichuloe gimoro, to pesa mochulno norom nyaka lalno. ");
INSERT INTO luo_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Ka ngʼato osero nyako mapok osingi ne kend kendo oriwore kode nyaka ochul gir keny kendo nyakono nobed chiege. ");
INSERT INTO luo_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ka wuon-gi otamore chiwe ne ngʼatno, to ngʼatno pod nyaka chul mana gir keny. ");
INSERT INTO luo_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Kik uwe jajwok madhako bed mangima. ");
INSERT INTO luo_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Ngʼato angʼata moriwore gi chiayo nyaka negi. ");
INSERT INTO luo_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Ngʼato angʼata motimo misango ni nyasaye moro makmana Jehova Nyasaye nyaka negi. ");
INSERT INTO luo_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Kik sand jadak kata loke misumba, nikech ne un jodak Misri. ");
INSERT INTO luo_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Kik uthir dhako ma chwore otho kata nyathi kich. ");
INSERT INTO luo_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ka utimo kamano ma giywakna, adier anawinj ywakgi ");
INSERT INTO luo_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Mirimba biro bedo mager kodu kendo abiro negou gi ligangla mondeu biro bedo monde liete kendo nyithindu biro bedo nyithi kiye. ");
INSERT INTO luo_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ka iholo pesa ni achiel kuom joga ma jachan mantie e dieru, to kik uchal gi ji mamoko ma holo ji pesa kendo kik ukaw ohala kuomgi. ");
INSERT INTO luo_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ka ikawo law wadu kaka gir singo, to duoknego kapok chiengʼ opodho, ");
INSERT INTO luo_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","nikech laweno kende ema oumorego. Ere gima donindie? Ka oywakna, to abiro winjo, nimar an Nyasaye ma jangʼwono. ");
INSERT INTO luo_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Kik iyany Nyasaye kata kwongʼo jatend jou. ");
INSERT INTO luo_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Kik utamru golo chiwo mowuok e decheu kata kuonde kenou. “Nyaka umiya yawuotu makayo. ");
INSERT INTO luo_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Timuru machal kamano ni rwethu kod rombeu. Weuru gibed gi minegi kuom ndalo abiriyo, to chiengʼ mar aboro miyagiuru. ");
INSERT INTO luo_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Unubed joga maler. Kuom mano kik ucham ring chiayo mondiek onego; direuru ne guogi. ");
INSERT INTO luo_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Kik iland wach ma ok adiera. Kik ikony ngʼat marach kidoko janeno mar miriambo. ");
INSERT INTO luo_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Kik itim gima rach nikech ji mangʼeny time. Ka in janeno e bura, to kik iketh bura mana nikech idwaro chwako koma ji ngʼenyie, ");
INSERT INTO luo_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","kendo kik ichwak ngʼato e bura nikech odhier. ");
INSERT INTO luo_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ka irodhno gi rwadh jasiki kata pundane ka bayo abaya molal, nyaka idwoke ne wuon-gi. ");
INSERT INTO luo_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ka ineno punda jasiki ka lodi motingʼo ogoye piny, to kik iweye kanyo; nyaka ine ni ikonye. ");
INSERT INTO luo_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Kik iketh buch jou modhier. ");
INSERT INTO luo_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kik ibed gi wach e bura mar miriambo kendo kik umi ngʼat maonge ketho ngʼadne buch tho, nimar ok anangʼwon ne ngʼat ma bura oloyo. ");
INSERT INTO luo_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Kik iyie kawo asoya, nikech asoya dino wenge jogo maneno kendo omiyo ngʼat makare bedo ngʼama rach. ");
INSERT INTO luo_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Kik usand japiny moro modak e dieru; un uwegi ungʼeyo kaka bedo jadak chalo, nikech ne un jodak e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Kuom higni auchiel unupur puotheu kendo unuka cham monyakie, ");
INSERT INTO luo_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","to e higa mar abiriyo weuru puothe onind ma ok opur kendo ma ok okomie cham. Eka joma odhier mantie e kind jou nyalo yudo chiemo, kendo le mag thim nyalo chamo gima giweyo. Timuru kamano bende ne puotheu mag mzabibu kod zeituni. ");
INSERT INTO luo_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Tiuru tijeu kuom ndalo auchiel, to e odiechiengʼ mar abiriyo kik uti tich moro amora mondo omi rwethu kod pundeu oyud yweyo kendo misumba monywol e uteu kaachiel gi jodak bende nyalo yudo yweyo. ");
INSERT INTO luo_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Nyaka une ni utimo gik moko duto ma asenyisou. Kik uluong nying nyiseche mamoko; bende kik uwe winjgi kata mana e dhou. ");
INSERT INTO luo_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Unutimna nyasi mar sawo nyadidek e higa. ");
INSERT INTO luo_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Timuru nyasi mar sawo mar makati ma ok oketie thowi; kuom ndalo abiriyo chamuru Makati ma ok oketie thowi, kaka nachikou. Timuru ma e kinde moketi e dwe mar Abib, nimar mano e dwe mane uwuokgo e piny Misri. “Kik ngʼato bi e nyima gi lwete nono. ");
INSERT INTO luo_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Timuru nyasi mar Sawo mar Keyo mar cham mane ukwongo komo e puotheu. “Timuru nyasi mar Sawo mar Keyo e giko higa, ka uchoko chambu koa e puotheu. ");
INSERT INTO luo_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Joma chwo duto nobi e nyim Jehova Nyasaye Manyalo Gik Moko Duto nyadidek e higa. ");
INSERT INTO luo_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Kik uchiwna remo motimgo misango kaachiel gi gimoro amora moketie thowi. “Bor chiayo modongʼ motimnago misango kik chop nyaka okinyi. ");
INSERT INTO luo_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Keluru cham mabeyo mokwongo nyaknu e lowo e od Jehova Nyasaye ma Nyasachu. “Kik uted nyadiel ma pod dhodho cha min. ");
INSERT INTO luo_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Neuru, aoro malaika nyimu mondo oritu e yo kendo mondo okelu kama aseikonu. ");
INSERT INTO luo_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Chikuru itu kendo winjuru gima owacho. Kik ungʼanyne; nimar Nyinga ni kuome, nikech ka utimo kamano to ok enowenu. ");
INSERT INTO luo_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ka uwinjo maber gima owacho kendo utimo gik moko duto mawacho, to abiro bedo jasik jowasiku kendo anakwed jogo makwedou. ");
INSERT INTO luo_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Malaikana biro telonu materu e piny jo-Amor, jo-Hiti, jo-Perizi, jo-Kanaan, jo-Hivi kod jo-Jebus kendo anatiekgi duto. ");
INSERT INTO luo_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Kik ukulru e nyim nyisechegi kata lamogi kata luwo timbegi. Nyaka une ni umukogi kendo utoyo kite ma gilamo matindo tindo. ");
INSERT INTO luo_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Lamuru Jehova Nyasaye ma Nyasachu, kendo anagwedhu gi chiemo kod pi. Anatiek tuoche kuomu, ");
INSERT INTO luo_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","kendo onge dhako ma iye no-oo piny, kata manobed migumba e pinyu. Abiro miyou ngima moromo chuth. ");
INSERT INTO luo_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Abiro oro kihondkona otel nyimu kendo anami piny ka piny ma uromogo bagni. Anami wasiku duto ringu. ");
INSERT INTO luo_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Abiro oro masiche mondo otel nyimu kendo masichego noriemb jo-Hivi, jo-Kanaan kod jo-Hiti. ");
INSERT INTO luo_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","To ok anariembgi oko dichiel e higa, nikech piny nyalo bedo gunda kendo le mag thim nyalo bedonu mathoth mokalo akwana. ");
INSERT INTO luo_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Abiro bedo kagologi matin tin e nyimu, nyaka chop umedru moromo kawo pinyno. ");
INSERT INTO luo_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Abiro keto tongʼ mar pinyu kochakore Nam Makwar nyaka e tongʼ Nam mar Mediterania, kendo chakre e thim nyaka e Aora mar Yufrate. ");
INSERT INTO luo_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Kik utim winjruok kodgi kata kod nyisechegi. ");
INSERT INTO luo_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Kik uwegi gidagi e pinyu, ka ok kamano to ginimi utim richo e nyima, nikech lamo nyisechegi nobednu obadho.” ");
INSERT INTO luo_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Eka Jehova Nyasaye nowacho ne Musa niya, “Bi ira, in kaachiel gi Harun, Nadab, Abihu kod jodongo piero abiriyo mag Israel. Un to unudongʼ kulemo mochwalore matin, ");
INSERT INTO luo_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","makmana Musa kende ema nobi machiegni gi Jehova Nyasaye. Oganda modongʼ kik bi kode.” ");
INSERT INTO luo_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Kane Musa odhi kendo onyiso oganda weche duto kod chike Jehova Nyasaye, negidwoko gi dwol achiel niya, “Gik moko duto ma Jehova Nyasaye osewacho wabiro timo.” ");
INSERT INTO luo_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Eka Musa nondiko gik moko duto mane Jehova Nyasaye osewachone. Kinyne gokinyi ne ochiewo mi ogero kendo mar misango e tiend got kendo ochungo kite apar gariyo mochungʼ kar ogendini apar gariyo mag Israel. ");
INSERT INTO luo_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Eka nooro yawuot Israel matindo kendo negichiwo misango miwangʼo pep kod misango mag rwedhi matindo kaka misango mag lalruok ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa nokawo nus remo kendo oketo e tewni, kendo nus modongʼ nokiro kuom kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Eka nokawo Kitabu mar Singruok mi osomo ni oganda. Negidwoko niya, “Wabiro timo gik moko duto ma Jehova Nyasaye osewacho; kendo wabiro rito chikego.” ");
INSERT INTO luo_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Eka Musa nokawo remono mi okiro kuom ji kendo owacho niya, “Ma e remo mar singruok ma Jehova Nyasaye osetimo kodu kaluwore gi wechegi duto.” ");
INSERT INTO luo_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musa kod Harun gi Nadab kod Abihu kaachiel gi jodong Israel piero abiriyo nodhi e got ");
INSERT INTO luo_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","moneno Nyasach Israel. E bwo tiend Nyasaye ne nitie gima chalo gi laru molos gi kit ombo, marieny ka polo. ");
INSERT INTO luo_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","To Nyasaye ne ok okumo jodong Israel-go, negineno Nyasaye kendo negichiemo mi gimetho. ");
INSERT INTO luo_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Jehova Nyasaye nonyiso Musa niya, “Bi ira ewi got mondo ibed ka kendo anamiyi kite mopa masendikoe chike kod buche mondo ipuonj oganda.” ");
INSERT INTO luo_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Eka Musa nochako wuoth gi Joshua jakonyne, kendo Musa nodhi malo e got mar Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Nowacho ne jodongo niya, “Ritwauru ka nyaka chop waduog iru. Harun kod Hur ni kodu kendo ngʼato angʼata man-gi wach madwaro loso mondo odhi irgi.” ");
INSERT INTO luo_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Kane Musa odhi ewi got, boche polo noumo godno, ");
INSERT INTO luo_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","kendo duongʼ mar Jehova Nyasaye nopongʼo wi Got Sinai. Kuom ndalo auchiel boche polo noimo godno kendo e odiechiengʼ mar abiriyo Jehova Nyasaye noluongo Musa ka en ei bor polo. ");
INSERT INTO luo_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Duongʼ mar Jehova Nyasaye ne chalo gi mach maliel ewi got ne jo-Israel. ");
INSERT INTO luo_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Eka Musa nodonjo ei bor polono kane odhi ewi got, kendo nobedo ewi got kuom ndalo piero angʼwen odiechiengʼ gotieno. ");
INSERT INTO luo_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Nyis jo-Israel mondo okelna chiwo. Inichokna chiwogo moro amora kuom ji duto moyie golo kuom herogi. ");
INSERT INTO luo_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Chiwo manyaka ikaw kuomgi e magi: “dhahabu, fedha kod mula; ");
INSERT INTO luo_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","law marambulu, maralik, marakwaro, law mayom, kod law mar yie diek, ");
INSERT INTO luo_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","piende rombe molok gi range makwar, piende monyongʼ mayom mag le mag nembe; yiend siala, ");
INSERT INTO luo_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mor zeituni miolo e taya mondo okel ler, gik milosogo mor pwodhruok kod ubani mangʼwe ngʼar, ");
INSERT INTO luo_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","gi oniks kod kite moko miketo kuom law mayom mar dolo miluongo ni efod kod law akor. ");
INSERT INTO luo_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Bangʼ mano gigerna kama ler mar lemo kendo anadag kodgi. ");
INSERT INTO luo_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ger Hemb Romoni gi gigene duto machalre mana gi kido ma abiro nyisi. ");
INSERT INTO luo_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Ketgi gilos sanduku maber molos gi yiend siala ma borne romo fut angʼwen gi nus to lachne romo fut achiel gi nus kendo borne madhi malo romo fut achiel gi nus. ");
INSERT INTO luo_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Bawe gi dhahabu maler oko gi iye kendo nochwene ndiga mar dhahabu mothedhi molwore. ");
INSERT INTO luo_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Thedhne ratege angʼwen molworore mag dhahabu machalo gi bangli kendo twegi e tiendene angʼwen-go, ka ratege ariyo bedo e bathe konchiel to ariyo mamoko e bathe komachielo. ");
INSERT INTO luo_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Bangʼ mano los ludhe mag yiend siala kendo ibawgi gi dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Rwak ludhego ei ratege mantie e bethe Sandug Muma mondo otingʼego. ");
INSERT INTO luo_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ludhego nyaka siki ei rategego mag sanduku; ok owinjore golgi. ");
INSERT INTO luo_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Eka iket ei Sandug Muma kite mopa mag chike ma abiro miyi. ");
INSERT INTO luo_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Losne raum mar pwodhruok gi dhahabu maler ma borne romo fut angʼwen gi nus kendo lachne romo fut achiel gi nus. ");
INSERT INTO luo_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Kendo e giko mar raumno los kido mar malaika ariyo miluongo ni kerubi gi dhahabu mothedhi. ");
INSERT INTO luo_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Los kido mar malaika mar kerubi achiel e giko raumno kendo malaika mar ariyo e giko komachielo; bende los kido mar malaika mar kerubigo e gimoro achiel gi raumno, e giko raumgo. ");
INSERT INTO luo_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kido mar malaika mar kerubigo noyaro bwombegi kochomo malo mondo giumgo raumno. Kerubigo nochungʼ momanyore ka ngʼiyore gi wi raumno. ");
INSERT INTO luo_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ket raumno ewi Sandug Muma, bangʼe iket kite mopa ariyo mar chike ma abiro miyi. ");
INSERT INTO luo_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ewi raum kanyo e kind kerubi ariyo manie wi Sandug Muma, ema abiro romoe kodi kendo kanyo ema namiyie chikena mondo iterne jo-Israel. ");
INSERT INTO luo_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Los mesa mar yiend siala ma borne romo fut adek to lachne romo fut achiel gi nus kendo borne madhi malo romo fut ariyo gi robo. ");
INSERT INTO luo_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Bawe gi dhahabu maler kendo lwor bethene gi dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Bende chwe bathe ma lachne romo gi pat lwedo achiel kendo ichwe dir batheno gi dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Los ratege molworore angʼwen mag dhahabu ne mesano kendo twegi e konde angʼwen mag mesa kama tiende angʼwen-go nitie. ");
INSERT INTO luo_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ratege molwororego nobed machiegni gi bethe mesano mondo omak ludhego mitiyogo kuom tingʼo mesa. ");
INSERT INTO luo_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Los ludhego gi yiend siala kendo bawgi gi dhahabu kendo iti kodgi kuom tingʼo mesa. ");
INSERT INTO luo_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Kendo los sende, bakunde kaachiel gi agulnine kod tewnine mitiyogo kitimogo misengini miolo piny, to gigo duto nyaka losi gi dhahabu maler. ");
INSERT INTO luo_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ket Makati miketo e nyima pile ewi mesano ndalo duto. ");
INSERT INTO luo_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Los rachungi mar taya gi dhahabu maler kendo ithedh tiende gi kore gi kikombege machalo maua gi thiepege kod obokege obed gimoro achiel kode. ");
INSERT INTO luo_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Bedene auchiel noa e bath rachungi tayano, ka adek nitie e bathe konchiel kendo adek nitie komachielo. ");
INSERT INTO luo_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kikombe adek molos kaka maupe mag oyungu gi thiepene kod obokene nobed e bade achiel kendo adek e bade maluwe kendo bedene auchielgo nochwogore kawuok e rachungi taya. ");
INSERT INTO luo_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Kendo kuom rachungi taya enobedie kikombe angʼwen molos machal gi maupe mag oyungu mathiewo kendo golo thuoke. ");
INSERT INTO luo_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Maua achiel nobedi e bwo bede ariyo mokwongo mar rachungino, mar ariyo nobed e bwo mar ariyo, to mar adek nobed e bwo bede mar adek, giduto gin bede auchiel. ");
INSERT INTO luo_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Maupego kod bede yien-go duto gi rachungi taya nobed gimoro achiel mothedh gi dhahabu maler. ");
INSERT INTO luo_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Bangʼ mano los techene abiriyo kendo iketgi ewi rachungi mondo giliel ka gimenyo nyime. ");
INSERT INTO luo_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Gima ingʼadogo otambi kod kama otambino betie nyaka los gi dhahabu maler. ");
INSERT INTO luo_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Kilo piero adek gangʼwen mar dhahabu maler ema notigo kuom loso rachungi mar taya kod gigene duto. ");
INSERT INTO luo_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Nyaka ine ni igerogi machal gi kido mane onyisi ewi got. ");
INSERT INTO luo_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Los Hemb Romo gi pasia apar mar law mayom momin man-gi rangi marambulu gi maralik kod marakwaro ka ogorie kido mar malaika mar kerubi gi jagoro molony. ");
INSERT INTO luo_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Pasiago duto nyaka bed maromre ka borne romo fut piero angʼwen gariyo to lachne romo fut auchiel. ");
INSERT INTO luo_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Riw pasia abich kanyakla kendo abich modongʼ bende iriw ");
INSERT INTO luo_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Los tonde milierogo pasia e riak pasia man-gi range marambulu kendo itim kamano e riak pasia matungʼ komachielo. ");
INSERT INTO luo_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Los tonde piero abich e riak pasia achiel kendo tonde piero abich mamoko e riak pasia komachielo ka tonde moliergo pasiago omanyore. ");
INSERT INTO luo_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Eka ilosi ramaki piero abich mag dhahabu kendo ti kodgi kuom riwo pasia ariyogo kanyakla mondo omi Hemb Romo obed gimoro achiel. ");
INSERT INTO luo_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Los pasia apar gachiel mag yie diek ne hema mondo oumgo Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Pasia apar gachielgo duto nyaka romre ka bor moro ka moro romo fut piero angʼwen gabich to lachgi romo fut auchiel. ");
INSERT INTO luo_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Riw pasia abich kanyakla mondo obed gimoro achiel kendo auchiel modongʼ riw obed achiel. Ban pasia mar auchiel nyadiriyo e nyim hema. ");
INSERT INTO luo_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Los tonde milierogo pasia piero abich e giko riak pasia konchiel kendo tonde milierogo pasia e giko riak pasia komachielo. ");
INSERT INTO luo_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Eka ilos ramaki mag mula piero abich kendo iketgi e tonde mitweyogo hema mondo oriwgi kaka gimoro achiel. ");
INSERT INTO luo_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Kuom bath pasia momedore, nus pasia momedoreno enolier e tok Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Pasia mag hemano nobed fut achiel gi nus e bathe koni gi koni; to bathe modongʼ nolier e bath Hemb Romo mondo oume. ");
INSERT INTO luo_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Losne hemano raum mar pien rombe molok gi range makwar kendo iniume gi piende monyongʼ mayom mag le mag nam. ");
INSERT INTO luo_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Los sirni mochungʼ mag yiend siala ne Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Siro ka siro borne nobed fut apar gabich to lachne nobed fut ariyo gi nus, ");
INSERT INTO luo_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","kipimo siro ka siro maromre gi nyawadgi. Los sirni duto mag Hemb Romo machalre. ");
INSERT INTO luo_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kiloso sirnigo, to nyaka ilos sirni piero ariyo migerogo bath Hemb Romo mochomo yo milambo ");
INSERT INTO luo_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","kendo ilos rachungi mar taya piero angʼwen mag fedha miketo e bwogi, ka rachungi ariyo iketo e bwo sirni ariyo momanyore. ");
INSERT INTO luo_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Kuom bath Hemb Romo komachielo man koma ochomo yo nyandwat, bende ilosne sirni piero ariyo ");
INSERT INTO luo_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","kod rachungi piero angʼwen mag fedha, ka siro ka siro otingʼo rachungi ariyo ariyo. ");
INSERT INTO luo_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Los sirni auchiel ne bathe mochwalore mochomo yo podho chiengʼ mar Hemb Romo, ");
INSERT INTO luo_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","kendo ilos sirni ariyo mibiro ketoe konde ariyo man yo tok Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","E konde ariyogi nyaka riw sirni ariyo chakre e tiende nyaka e wiye malo, kendo oriwgi gi nyange modol, giduto ariyogo ginibed machal kamano. ");
INSERT INTO luo_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Omiyo sirni duto nobed aboro, to rachungi duto mag fedha nobed apar gauchiel ka siro ka siro otingʼo rachungi ariyo ariyo. ");
INSERT INTO luo_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Bende losuru yiende miriwo mag yiend siala; ka abich oket ne sirni mantie bathe konchiel mar Hemb Romo, ");
INSERT INTO luo_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","kendo abich mamoko oketi e bathe komachielo kendo sirni abich modongʼ omak sirni mane omakgo katoke mochomo yo podho chiengʼ mar Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Raidhi madiere noa tungʼ nyaka tungʼ e dier sirnigo. ");
INSERT INTO luo_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Baw sirnigo gi dhahabu kendo los ratege mag dhahabu mondo omak raidhi miriwogo. Bende baw raidhigo gi dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Gur Hemb Romono kaluwore gi kaka ne anyisi ewi got. ");
INSERT INTO luo_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Los pasia mar law mayom momin mar range marambulu, maralik kod marakwaro, moketie kido mar malaika mar kerubi mondo ogorie gi jagoro molony. ");
INSERT INTO luo_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Liere gi rangʼaw molos gi dhahabu e sirni angʼwen mag siala mobaw gi dhahabu kendo mochungi ewi rachungi angʼwen mag fedha. ");
INSERT INTO luo_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Lier pasiano gi ramaki kendo ket Sandug Rapar e tok pasiano. Pasiano biro pogo Kama Ler gi Kama Ler Moloyo. ");
INSERT INTO luo_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ket raum mar pwodhruok ewi Sandug Rapar ei Kama Ler Moloyo. ");
INSERT INTO luo_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ket mesa oko mar pasiano koma ochomo yo nyandwat mar Hemb Romo kendo ket rachungi taya kochomore kode e yo milambo mar Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Los pasia mar law mayom momin mar range marambulu, maralik kod marakwaro ma en tich mar jachwecho molony mondo ongʼaw e dhoranga Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Los ramaki mag dhahabu kod sirni abich mag yiend siala mobaw gi dhahabu. Bende ilosi rachungi mag mula abich ni sirnigo. ");
INSERT INTO luo_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Ger kendo mar misango gi yiend siala, ma borne madhi malo romo fut angʼwen gi nus, lachne kod borne mondo obed fut abiriyo gi nus maromre. ");
INSERT INTO luo_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Los tungʼ e konde angʼwen mag kendono, mondo omi tungego kod kendo mar misango obed gimoro achiel ka kendono omuon wiye gi mula. ");
INSERT INTO luo_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Gik moko duto mitiyogo e kendo mar misango los gi mula. Gigo ne gin agulni ma ijowogo buru, opawo, bakunde mikirogo remo, gi uma michiwogo ringʼo kod tegni mag mach. ");
INSERT INTO luo_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Losne singʼenge mar mula kendo ilos nyange mag mula kendo iketgi achiel achiel e kondene angʼwen-go. ");
INSERT INTO luo_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Kete e bwo ndiri molworo kendo mar misango kendo ochopi nyaka e kor kendo mar misangono. ");
INSERT INTO luo_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Los ludhe mag yiend siala ni kendo mar misangono kendo ibawgi gi mula. ");
INSERT INTO luo_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ludhego noso e nyangeyego mondo gibedi e bath kendo mar misangono kitingʼego. ");
INSERT INTO luo_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Los kendo mar misangono gi bao mayom, to ituch bugo e chuny sandukuno mondo iwe iye obed thuolo, kendo lose mana kaka nonyisi ewi got. ");
INSERT INTO luo_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Los laru ne Hemb Romono. Yo milambo mar laruno borne norom mita piero angʼwen gauchiel kendo onego obed gi pasia momin molos gi law mayom, ");
INSERT INTO luo_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","bende obed gi sirni piero ariyo gi rachungi piero ariyo mag mula kod ramaki mag fedha kod rangʼaw miriwogo sirnigo. ");
INSERT INTO luo_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Koma odok yo nyandwat mar laruno nobed maromo mita piero angʼwen gauchiel kendo nobed gi pasia mongʼaw e sirni piero ariyo kendo morwak e rachungi piero ariyo mag mula; ramaki kod rangʼaw miriwogo kor sirni molos gi fedha. ");
INSERT INTO luo_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Koma odok yo podho chiengʼ mar laruno lachne norom mita piero ariyo gadek kendo nobed gi pasia mongʼaw e sirni apar morwakie rachungi apar. ");
INSERT INTO luo_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Koma odok yo wuok chiengʼ mar laruno lachne norom mita piero ariyo gadek. ");
INSERT INTO luo_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Pasia ma borgi romo mita abiriyo nobed e dir rangach konchiel, ka pasiago ongʼaw ewi sirni adek man-gi rachungi adek; ");
INSERT INTO luo_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","kendo pasia ma borgi romo mita abiriyo nobedi e dir rangach komachielo kongʼawgi e sirni adek man-gi rachungi adek. ");
INSERT INTO luo_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“To e dhoranga laruno, ketie pasia mar law mayom momin ma borne romo mita ochiko kendo man-gi rangi marambulu gi maralik kod makwar duto molos gi jachwecho molony koketgi ewi sirni angʼwen man-gi rachungi angʼwen. ");
INSERT INTO luo_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Sirnigo duto molworo laruno nobed gi ramaki gi rangʼaw molos gi fedha kaachiel gi rachungi mag mula. ");
INSERT INTO luo_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Laruno borne norom fut mia achiel gi piero abich, to lachne norom fut piero abiriyo gabich kendo borne modhi malo en fut abiriyo gi nus gi pasia molos gi law mayom kendo rachungi duto nyaka bed mag mula. ");
INSERT INTO luo_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Gik moko duto mag tich e Hemb Romo, bed ni gin gik ma itiyogo tich moro amora, to gi loye duto mag hema kaachiel gi loye mag laru nyaka losgi gi mula. ");
INSERT INTO luo_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Chik jo-Israel mondo gikelni mo maliw mar zeituni mobi mondo omi teyni osik kaliel ma ok otho. ");
INSERT INTO luo_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Harun gi yawuote nyaka neni teynigo osiko kaliel e nyim Jehova Nyasaye chakre odhiambo nyaka okinyi, ka gikete e Hemb Romo oko mar pasia mantiere e nyim Sandug Muma. Ma en chik mosiko nyaka chiengʼ ne jo-Israel nyaka ne tienge duto mabiro. ");
INSERT INTO luo_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Luong Harun owadu kaachiel gi yawuote ma gin Nadab, Abihu, Eliazar kod Ithamar kowuok kuom jo-Israel mondo gitina kaka jodolo. ");
INSERT INTO luo_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Twangʼne Harun owadu lewni mopwodhi mag dolo mondo omi omiye duongʼ gi luor. ");
INSERT INTO luo_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Nyis jotich molony duto ma asemiyo rieko e yore machalo kamago ni mondo gilos ne Harun lewnigo mag pwodhruok mondo otinago kaka jadolo. ");
INSERT INTO luo_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Lewni manyaka gitwangʼ e magi: law akor, law mayom mar dolo miluongo ni efod, kandho, law akor mogor, kilemba mar wich kod okanda. Nyaka gilos lewni mowal mag dologi ne owadu Harun kod yawuote mondo gitina kaka jodolo. ");
INSERT INTO luo_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Lewnigo nyaka gilosi gi dhahabu, gi law man-gi range marambulu gi maralik kod marakwaro. ");
INSERT INTO luo_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Los law mayom mar dolo miluongo ni efod gi dhahabu, gi law man-gi range marambulu gi maralik kod marakwaro momin gi law mayom, ma en tich jatwengʼo molony. ");
INSERT INTO luo_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Nyaka obed gi okanda ariyo mag gok mitweyego e gok chien gi nyime ");
INSERT INTO luo_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Okandane mochwe maber nyaka bed machal kode kendo obed gimoro achiel gi law mayom mar dolo miluongo ni efod bende nyaka lose gi dhahabu kod law momin mayom man-gi range marambulu gi maralik kod marakwaro. ");
INSERT INTO luo_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Kaw kite ariyo mag oniks kendo ikedgi kaka ikedo kido ka indiko nying yawuot Israel, ");
INSERT INTO luo_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","kaluwore gi nywolgi ka nying yawuowi auchiel ondikie kidi achiel, to auchiel modongʼ ondikie kidi machielo. ");
INSERT INTO luo_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Iked nying yawuot Israel mana kaka jaked kidi molony kedo kido. Bangʼ mano ru kitego e tond dhahabu, ");
INSERT INTO luo_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","kendo twegi e lep akor mag law mayom mar dolo miluongo ni efod mondo gibed kaka kite rapar ne nyithind Israel. Harun enotingʼ kitego e goke kaka rapar e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ruwgi kaka thiwni mag dhahabu, ");
INSERT INTO luo_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","kendo e nyoroche ariyo mokedi gi dhahabu maler kaka tol mondo itwe nyorochego e thiwni. ");
INSERT INTO luo_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Jatwengʼo molony ema nyaka los law akor mar ngʼado bura, kolose gi dhahabu gi usi marambulu gi maralik kod marakwaro kod law mayom mar katana kendo momin maber ka law mayom mar dolo miluongo ni efod. ");
INSERT INTO luo_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Onego oromre duto ka borne gi lachne romo bat achiel kendo nobane nyadiriyo. ");
INSERT INTO luo_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Bangʼ mano, chan laini angʼwen mag kite ma nengogi tek kuom lawno. Laini mokwongo chanie kite kaka rubi, topaz gi beril; ");
INSERT INTO luo_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","to e laini mar ariyo chanie kite kaka tarkus gi safir kod emerald; ");
INSERT INTO luo_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","e laini mar adek chanie kite kaka jasinth gi agat kod amethist; ");
INSERT INTO luo_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","e laini mar angʼwen chanie kite kaka krisolit gi oniks kod jaspa. Kidigo duto mondo ochan kaka thiwni mag dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Kitego duto nondikie nying yawuot Israel apar gariyo, ka okedgi kaka kido ka moro ka moro ochungʼ ne nying dhout Israel apar gariyogo. ");
INSERT INTO luo_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Losne law akor thiwni mag dhahabu maler mokadi ka tol. ");
INSERT INTO luo_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Losne thiwni ariyo mag dhahabu kendo itwegi e riak law agoko. ");
INSERT INTO luo_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Twe thiwni ariyogo mag dhahabu e ratege mantie e riak law akor, ");
INSERT INTO luo_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","kendo itwe lak thiwnigo komachielo e laini ariyo mochan kaka dhahabu ka ochome e tond law akor kuom law mayom mar dolo miluongo ni efod gi yo ka nyime. ");
INSERT INTO luo_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Los ratege ariyo mag dhahabu kendo ichomgi e konde ariyo mamoko mag law akor gi yo ka iye e riak law mayom mar dolo miluongo ni efod. ");
INSERT INTO luo_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Los ratege ariyo mag dhahabu kendo ichomgi e riak tonde ariyo mag gok yo ka nyime mar law mayom mar dolo miluongo ni efod machiegni gi kama oriwego but nungone. ");
INSERT INTO luo_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ratege mag law akor nyaka twe e ratege mag law mayom mar dolo miluongo ni efod gi tol marambulu, kiriwe gi okanda manie nungone mondo law akor kik gonyre. ");
INSERT INTO luo_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Kinde duto ma Harun donjo e Kama Ler, notingʼ nying yawuot Israel e kore kondikgi e law akor mar ngʼado bura mondo obed kaka Rapar mochwere e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ket Urim gi Thumim bende kuom law akor mondo omi gibed kondikgi e agog Harun kinde duto ma odonjo e nyim Jehova Nyasaye. Kuom mano kinde duto ma Harun ni e nyim Jehova Nyasaye notingʼ gir ngʼado bura ne jo-Israel e agoge.” ");
INSERT INTO luo_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Los kandho mar law mayom mar dolo miluongo ni efod gi law marambulu, ");
INSERT INTO luo_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ka en gi kama otuch e diere ma wich wuokie. Kama otuch ma wich wuokieno nyaka twangʼ gi pien mondo kik oyiechi. ");
INSERT INTO luo_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Twangʼ gik mongʼinore kaka olemo molos gi usi marambulu gi maralik kod makwar kendo ket gara mar dhahabu e kindgi ");
INSERT INTO luo_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Gara mag dhahabugo kod gik mongʼinore kolemogo nobed kokikore molworo riak law. ");
INSERT INTO luo_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Harun nyaka rwak lawno kotiyo tich dolo. Ywak garago nowinji kodonjo e Kama Ler e nyim Jehova Nyasaye kendo kowuok mondo kik otho. ");
INSERT INTO luo_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Los san mopamore gi dhahabu maler kendo indikie wechegi: Kama owal ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Twe gima ondikie wechego gi tol marambulu e kilemba mar jadolo gi yo ka nyime. ");
INSERT INTO luo_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Noliere e lela wangʼ Harun kendo notingʼ ketho duto ma dipo kobetie kuom mich maler ma jo-Israel chiwo ni Jehova Nyasaye. Kamano e kaka nobedi e lela wangʼ Harun kinde duto mondo Jehova Nyasaye oyie gi chiwogo. ");
INSERT INTO luo_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Twangʼ law kandho mar law mayom mar katana kendo ilos kilemba gi law mayom mar katana. Okanda to mondo ogor gi ngʼama olony. ");
INSERT INTO luo_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Mondo omi yawuot Harun oyud duongʼ kod luor, losnigi lewni mag akor, okanda kod kilemba. ");
INSERT INTO luo_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Bangʼ ka iserwako lewnigi kuom owadu Harun gi yawuote, to wirgi gi mo kendo ipwodhgi. Walgi mondo gitina kaka jodolo. ");
INSERT INTO luo_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Ilosnegi sirweche matindo mar law katana mondo giumgo dug-gi, chakre nungogi nyaka thochgi. ");
INSERT INTO luo_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Harun gi yawuote nyaka rwak lewnigo kinde duto ma gidonjo e Hemb Romo, kata ka gidhi e kendo mar misango mondo giti tich dolo e Kama Ler mondo kik gibed giketho mi githo. “Ma nobed singruok mosiko ne Harun gi nyikwaye duto. ");
INSERT INTO luo_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Ma e gima nyaka itim e kinde miwalogi mondo gitina kaka jodolo: Kaw nyarwath kod imbe ariyo maonge songa. ");
INSERT INTO luo_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Bende kaw mogo mar ngano mayom ma ok oketie thowi modwal gi mo mondo ilosgo makati kod kek kaachiel gi chapat mowir gi mo. ");
INSERT INTO luo_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ketgi ei adita kendo ikel gigo, kaachiel gi nyarwath kod imbe ariyo-ka. ");
INSERT INTO luo_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Eka ikel Harun gi yawuote e dhoranga Hemb Romo kendo ilwokgi gi pi. ");
INSERT INTO luo_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Kaw lewnigo magin kandho gi kandho moumo law akor miluongo ni efod, gi kandho mar law mayom mar dolo miluongo ni efod kod law akor mondo irwakne Harun. Twe law mayom mar dolo miluongo ni efod kuome gi okandane motwangʼ maber. ");
INSERT INTO luo_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Rwakne kilemba e wiye kendo itwene san mopamorecha e lela wangʼe kaka osimbo maler. ");
INSERT INTO luo_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Kaw mor pwodhruok kiolo e wiye mondo ipwodhego. ");
INSERT INTO luo_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Kel yawuote kendo irwaknegi kandho ");
INSERT INTO luo_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","kendo isidhnegi kilemba e wiyegi. Bangʼe twe okanda kuom Harun gi yawuote. Tich dolo en margi kaluwore gi singruok mochwere. “Mano e kaka inipwodh Harun gi yawuote. ");
INSERT INTO luo_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Kel rwadh-cha yo ka nyim Hemb Romo kendo Harun gi yawuote noyie lwetgi e wiye. ");
INSERT INTO luo_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Yangʼe e nyim Jehova Nyasaye e dhoranga Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Kaw remb rwadhno moko kendo iwirie tunge kendo mar misango gi lith lweti to modongʼ to ipuk e bwo kendo mar misangono. ");
INSERT INTO luo_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Eka ikaw boche duto mogawo jamb-ich gi moumo chuny gi nyiroke ariyo kod boche mogawogi kendo iwangʼ-gi e kendo mar misango ");
INSERT INTO luo_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","To wangʼ ring rwadhno gi piene kaachiel gi wen oko mar kambi. En misango mar golo richo. ");
INSERT INTO luo_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Kaw achiel kuom imbego kendo Harun kaachiel gi yawuote noyie lwetgi e wiye. ");
INSERT INTO luo_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Yangʼe kendo ikaw rembe ikir e bethe kendo mar misango koni gi koni. ");
INSERT INTO luo_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Pog ring imno lemo lemo kendo ilwok jamb-ich gi tiendene kichokogi kaachiel gi wich kod lemo mamoko. ");
INSERT INTO luo_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Bangʼe wangʼ imno duto ewi kendo mar misango. En misango miwangʼo pep ne Jehova Nyasaye madungʼ tik mangʼwe ngʼar, ma en misango motim ni Jehova Nyasaye gi mach. ");
INSERT INTO luo_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Kaw im machielo kendo Harun gi yawuote noyie lwetgi e wiye. ");
INSERT INTO luo_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Yangʼ imno kendo ikaw rembe moko mi imien e it Harun ma korachwich kod it yawuote ma korachwich kod lith lwetgi mathuon ma korachwich kod lith tiendegi ma korachwich, to remo modongʼ to ikir e bath kendo mar misango moluoro. ");
INSERT INTO luo_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kaw remo moko mantie e kendo mar misango gi mor pwodhruok moko kendo kire kuom Harun gi lepe kendo kuom yawuote gi lepgi. Eka en gi yawuote gi lepgi nobed maler. ");
INSERT INTO luo_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Kaw boche im, gi boche mag sembe gi boche mogawo jamb-ich gi boche moimo chuny gi nyiroke ariyo kod boche mogawogi kaachiel gi bam ma korachwich (ma e im miwalogo jodolo). ");
INSERT INTO luo_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Bende kaw achiel kuom makati ma ok oketie thowi moketi ei okapu e nyim Jehova Nyasaye gi kek molos gi mo kod chapat. ");
INSERT INTO luo_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ketgi duto e lwet Harun gi yawuote kendo ofwagi e nyim Jehova Nyasaye kaka misango mifwayo. ");
INSERT INTO luo_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Bangʼe kawgi oko e lwetgi kendo iwangʼ-gi e kendo mar misango kaachiel gi misango miwangʼo pep kaka misango madum tik mangʼwe ngʼar ne Jehova Nyasaye, ma en misango miwangʼone Jehova Nyasaye gi mach. ");
INSERT INTO luo_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Bangʼ ka isekawo agoko mar im mitimogo nyasi mar walo Harun, fwaye e nyim Jehova Nyasaye kaka misango mifwayo kendo mano nobed lemo ma kori. ");
INSERT INTO luo_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Pwodh lemo mag im mane otimgo misango mar walo Harun kod yawuote ma gin agoko kaka misango mifwayo gi em mane ochiw. ");
INSERT INTO luo_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Magi ema nobed lemo ma Harun gi yawuote yudo kuom jo-Israel. En e chiwo ma jo-Israel nochiw ni Jehova Nyasaye kawuok e misengini mag lalruok. ");
INSERT INTO luo_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Lep Harun mopwodhi mag dolo nyaka dongʼ ni yawuote gi nyikwaye bangʼ thone mondo mi owirgi gi mo kiketogi kaka jodolo. ");
INSERT INTO luo_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Wuod Harun manoket kare kaka jadolo kendo ma nobi e Hemb Romo mondo oti tij dolo e Kama Ler norwak lewnigo kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Kaw im miwalogo ngʼato kiketo jadolo kendo ited ringe kama ler. ");
INSERT INTO luo_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Harun gi yawuote nyaka cham ring imno kaachiel gi makati manie okapu e dhoranga Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Nyaka gicham chiwogo mane otimnegigo pwodhruok kiwalogi kaka jodolo. To onge ngʼat machielo moyiene chamo chiemono nikech gin gik mopwodhi. ");
INSERT INTO luo_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","To ka ringʼo kata makati mopwodhgigo odongʼ nyaka okinyi, to nyaka wangʼe. Ok owinjore chame nikech en gima ler. ");
INSERT INTO luo_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Tim ne Harun kod yawuote gik moko duto masechiki, ka ikawo ndalo abiriyo mondo iwalgi kaka jodolo. ");
INSERT INTO luo_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kuom ndalogo odiechiengʼ ka odiechiengʼ nyaka itim misango mar golo richo gi rwath mondo pwodhgigo kuom richo, kamano inipwodh kendo mar misango, kiwire gi mo kendo iwalego ne tich Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Kuom ndalo abiriyo pwodh kendo mar misango kendo kete obed maler. Eka kendo mar misango biro bedo maler moloyo kendo gimoro amora morere kuome nobed maler. ");
INSERT INTO luo_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Gima nyaka ichiw e kendo mar misango pile ka pile ema: nyirombe ariyo mahikgi achiel achiel. ");
INSERT INTO luo_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Chiw achiel gokinyi to machielo godhiambo. ");
INSERT INTO luo_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Chiw nyarombo mokwongono gi mogo mayom moromo gorogoro achiel gi nus moruw gi mo mobi e olemb zeituni moromo lita achiel, kendo ichiw divai moromo lita achiel kaka misango miolo piny ");
INSERT INTO luo_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Chiw nyarombo machielo godhiambo kendo ichiwe kaachiel gi chiwo mar cham kod misango miolo piny mana kaka chiwo mokwongo, ma en misango madungʼ tik mangʼwe ngʼar, miwangʼo pep ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Ne tienge duto, misango miwangʼo pep ni nyaka chiw ndalo duto e dhoranga Hemb Romo e nyim Jehova Nyasaye. Kanyo ema abiro romoe kodu kendo wuoyoe kodu; ");
INSERT INTO luo_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","bende kanyo ema abiro romoe gi jo-Israel, mi duongʼna nomi kanyo bed maler. ");
INSERT INTO luo_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Kuom mano abiro puodho Hemb Romo gi kendo mar misango mondo obed maler kendo abiro puodho Harun gi yawuote mondo otina kaka jodolo. ");
INSERT INTO luo_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Bangʼ mano abiro dak kod jo-Israel kendo abiro bedo Nyasachgi. ");
INSERT INTO luo_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Gibiro ngʼeyo ni an Jehova Nyasaye ma Nyasachgi ema ne agologi e piny Misri mondo omi adag kodgi. An e Jehova Nyasaye ma Nyasachgi. ");
INSERT INTO luo_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Los kendo mar misango miwangʼoe ubani gi yiend siala. ");
INSERT INTO luo_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Borne gi lachne nyaka bed maromre ma gin nus mita moro ka moro, to borne madhi malo nyaka bed mita achiel, kendo tungene nyaka bed gimoro achiel kode. ");
INSERT INTO luo_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Baw wiye kod bethene duto kod tungene gi dhahabu maler bende losne ndiri mar dhahabu molwore. ");
INSERT INTO luo_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Los ratege ariyo mag dhahabu ne kendono mar misangono e bwo ndiri ka gimanyore ariyo koni gi koni mondo omak ludhe mitingʼego. ");
INSERT INTO luo_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Los yiend siala kendo ibawgi gi dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ket kendono mar misango e nyim pasia molier e nyim Sandug Muma man e nyim Sandug Raparno kama abiro romoe kodu. ");
INSERT INTO luo_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Harun nyaka wangʼ ubani mangʼwe ngʼar e kendono mar misango okinyi kokinyi koiko teyni. ");
INSERT INTO luo_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Nyaka owangʼ ubani kendo e seche momokoe teyni godhiambo mondo ubanigo owangʼ kinde duto e nyim Jehova Nyasaye nyaka ne tienge mabiro. ");
INSERT INTO luo_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Kik ichiw kit ubani moro amora e kendono mar misango kata misango miwangʼo pep kata chiwo mar cham kendo kik ichiw misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Harun nochiw misango mar pwodho tunge kendono dichiel e higa. Chiwo mar higa ka higa mar pwodhruok nyaka tim gi remb misango mar golo richo ni tienge duto mabiro. Kendono nobed maler moloyo ni Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Ka ikwano jo-Israel, to ngʼato ka ngʼato nyaka chul nengo ne Jehova Nyasaye mowarogo ngimane e sa ma ikwane. Eka onge masira mane ogore kuomgi ka ikwanogi. ");
INSERT INTO luo_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ngʼato angʼata moriwore gi joma osekwan nyaka chiw nus shekel kaluwore gi kweno mar shekel manie kama ler mar lemo, ma pekne romo kilo auchiel. Nus shekel mochiwo nobed mar Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Jogo duto moriwore gi joma osekwan ma jo-higni piero ariyo kadhi nyime nyaka kel chiwono ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ka uchulo Jehova Nyasaye chiwo ma upwodhorugo, jo-mwandu kik kel mangʼeny moloyo midwaro, to jachan bende kik kel matin moremo kar midwaro. ");
INSERT INTO luo_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Kaw pesa mar pwodhruokno kuom jo-Israel kendo kete e tich mar Hemb Romo. Enobed Rapar ni jo-Israel e nyim Jehova Nyasaye ka utimogo pwodhruok ni ngimau.” ");
INSERT INTO luo_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Los karaya mar luok molos gi mula to gi rachungi miketoe karayano bende olos gi mula. Kete e kind Hemb Romo kod kendo mar misango bangʼe iol pi e iye. ");
INSERT INTO luo_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Harun gi yawuote noluok tiendegi kod lwetegi gi pi mogol e iye. ");
INSERT INTO luo_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Kinde ka kinde ka gidonjo e Hemb Romo, to nyaka giluokre gi pigno mondo kik githo. Bende kinde ka kinde ma gidhi kar kendo mar misango mondo gichiw misango miwangʼo pep ni Jehova Nyasaye, ");
INSERT INTO luo_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","to nyaka giluok lwetgi gi tiendgi mondo kik githo. Mano nobedi chik mochwere momako Harun gi nyikwaye nyaka ni tienge duto mabiro.” ");
INSERT INTO luo_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Gik mangʼwe ngʼar monego ikaw gin: kilo auchiel mar mane-mane, kilo adek mar dalasini, gi obala ndago maromo kilo adek, ");
INSERT INTO luo_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","kasia maromo kilo auchiel, kendo giduto nyaka pimgi gi rapim ma itiyogo e kama ler mar lemo, to bende ikel lita angʼwen mar mo zeituni. ");
INSERT INTO luo_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Riw gigi duto mondo ilos mor pwodhruok maler madungʼ tik mangʼwe ngʼar mana kaka ngʼat molony e loso gik mangʼwe ngʼar loso. Enobed mor pwodhruok maler. ");
INSERT INTO luo_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Bangʼe ti kode ka iwirogo Hemb Romo, Sandug Muma mar Singruok, ");
INSERT INTO luo_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","mesa gi gigene duto mag tije, rachungi taya gi gigene duto mag tich, kendo mar misango miwangʼoe ubani, ");
INSERT INTO luo_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","kendo mar misango miwangʼo pep gi gik moko duto mitiyogo e kendono, gi karaya kod rachungi mare. ");
INSERT INTO luo_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Nyaka ipwodhgi mondo gibed maler moloyo kendo gimoro amora morere kuomgi nobed maler. ");
INSERT INTO luo_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Wir Harun gi yawuote kendo pwodhgi mondo gitina kaka jodolo. ");
INSERT INTO luo_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Nyis jo-Israel kama, ‘Ma ema nobed mor pwodhruok maler ne tienge duto mabiro. ");
INSERT INTO luo_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Kik iole e dend ji bende kik ilos mo moro amora machal kaka olos mono. En gima owal kendo nyaka ikawe kaka gima owal. ");
INSERT INTO luo_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ngʼato angʼata manolos mo machal kamano kata manowir ngʼato angʼata ma ok jadolo nongʼad kare oko.’ ” ");
INSERT INTO luo_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Eka Jehova Nyasaye nowacho ne Musa niya, “Kaw gik madum mangʼwe ngʼar kaka duogo, sare, mieny kod ubani maler, kendo pekgi nyaka bed maromre, ");
INSERT INTO luo_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","kendo riwgi milosgo ubani mangʼwe ngʼar ma en tich jalos gik mangʼwe ngʼar. Ketie chumbi mondo obed gima ler mowal. ");
INSERT INTO luo_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Kawe moko matin kuom gigo mondo ireg mayom kendo iketie Sandug Muma manie nyim Hemb Romo, kama abiro romoe kodu, kendo nobednu maler moloyo. ");
INSERT INTO luo_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Kik ulos ubani moro amora e yo machal kama ne un uwegi, nikech en gima ler mowalne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ngʼato angʼata manolos ubani e yo machal kamano mondo owinj tik mamit ma aa kuome nyaka ngʼad kare oko kuom ogandane.” ");
INSERT INTO luo_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ngʼe ni aseyiero Bezalel wuod Uri, ma wuod Hur, maa e dhood Juda, ");
INSERT INTO luo_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","kendo asepongʼe gi Roho mar Nyasaye mondo obed gi lony, gi rieko, gi nyalo kod ngʼeyo tije duto mag lwedo; ");
INSERT INTO luo_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","mondo omi ogor kido mabeyo mag dhahabu gi fedha kod mula, ");
INSERT INTO luo_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","kendo ongʼad kite duto gi payo bao kendo mondo otim kit tije duto mag lwedo. ");
INSERT INTO luo_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Kata kamano aseyiero Oholiab wuod Ahisamak bende, maa e dhood Dan mondo okonye. “Bende asechiwo rieko ni jotich lwedo duto molony mondo olos gik moko duto masechiki kaka: ");
INSERT INTO luo_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Hemb Romo, Sandug Rapar mar pwodhruok gi raumne, kod gik moko duto mag hema kaka: ");
INSERT INTO luo_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","mesa gi gigene mag tich, gi rachungi taya gi gigene mag tich, gi kendo mar misango miwangʼoe ubani, ");
INSERT INTO luo_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kod kendo mar misango miwangʼo pep gi gik moko duto mitiyogo e kendono, gi karaya kod rachungi mare, ");
INSERT INTO luo_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","kaachiel gi lewni motwangʼ, ka lewni mopwodhi mag Harun jadolo kod lep yawuote kane gitiyo kaka jodolo; ");
INSERT INTO luo_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","kod mor pwodhruok gi ubani madungʼ tik mangʼwe ngʼar mar Kama Ler. “Nyaka gilose mana kaka nachiki.” ");
INSERT INTO luo_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Nyis jo-Israel kama: ‘Nyaka urit sabatona duto. Ma nobed ranyisi e kinda kodu nyaka ni tienge duto mabiro, mondo omi ungʼe ni An e Jehova Nyasaye mamiyo ubedo maler. ");
INSERT INTO luo_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Rituru Sabato nikech enobednu odiechiengʼ maler. Ngʼato angʼata ma ok orito odiechiengno nyaka negi bende ngʼato angʼata motiyo chiengʼ Sabato nyaka ngʼad kare oko kuom ogandane. ");
INSERT INTO luo_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Kuom ndalo auchiel nyaka uti, to odiechiengʼ mar abiriyo en Sabato mar yweyo ma en chiengʼ maler ni Jehova Nyasaye. Ngʼato angʼata ma otimo tich moro amora chiengʼ Sabato nyaka negi. ");
INSERT INTO luo_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Jo-Israel nyaka rit Sabato ka gitimoe nyasi kuom tienge duto mabiro kaka singruok mosiko. ");
INSERT INTO luo_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Enobed ranyisi e kinda kod jo-Israel nyaka chiengʼ nimar kuom ndalo auchiel Jehova Nyasaye nochweyo polo gi piny kendo e odiechiengʼ mar abiriyo noweyo tich moyweyo.’ ” ");
INSERT INTO luo_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Kane Jehova Nyasaye otieko wuoyo gi Musa ewi Got Sinai nomiye kite ariyo mopa mag rapar mane gin kite mopa ariyo ma Nyasaye nondikoe gi lwete owuon. ");
INSERT INTO luo_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Kane ji oneno ni Musa osedeko ewi got, negichokore ma gilworo Harun kendo giwachone niya, “Bi mondo ilosnwa nyiseche ma biro dhi nyimwa, nimar ok wangʼeyo gima osetimore ne Musa mane ogolowa ka waa e piny Misri.” ");
INSERT INTO luo_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Harun nodwokogi niya, “Kawuru sitadi mag dhahabu ma yawuotu kod nyiu orwako mondo ukelna.” ");
INSERT INTO luo_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kuom mano, ji duto nokawo sitadigi mi gikelogi ne Harun. ");
INSERT INTO luo_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Nokawo gik mane omiyego monywaso kendo olosogo kido machalo gi mar nyaroya. Eka nowachonegi niya, “Magi e nyisecheu mane ogolou e piny Misri, yaye Israel.” ");
INSERT INTO luo_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Kane Harun oneno kamano, nogero kendo mar misango e nyim nyaroyano kendo nolando niya, “Kiny notim sawo ne Jehova Nyasaye” ");
INSERT INTO luo_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kuom mano, ji nochiewo kinyne kogwen mochiwo misango miwangʼo pep kendo negichiwo misango mag lalruok. Bangʼe negibedo piny mondo gichiem kendo gimethi kendo negia malo mondo gimiel miende dwanyruok. ");
INSERT INTO luo_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Eka Jehova Nyasaye nowacho ne Musa niya, “Lor piny idog ir jogi mane igolo kawuok e piny Misri nikech gisekethore” ");
INSERT INTO luo_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Giselokore mapiyo nono ka giweyo chike mane amiyogi kendo giseloso nyasaye maket gi nyaroya. Gisekulorene piny kendo gisechiwone misango mi giwacho niya, “Magi e nyisecheu mane ogolou e piny Misri, yaye Israel.” ");
INSERT INTO luo_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Jehova Nyasaye nowacho ne Musa niya, “Aseneno jogi kendo gin joma tokgi tek. ");
INSERT INTO luo_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Kuom mano, koro weya mondo mirimba mager otiekgi. Bangʼe to anaketi ibed oganda maduongʼ.” ");
INSERT INTO luo_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","To Musa nokwayo Jehova Nyasaye, ma Nyasache kowachone niya, “Yaye Jehova Nyasaye, en angʼo momiyo mirimbi mager ditiek jogi mane igolo gi teko maduongʼ kod lweti maratego kawuok e piny Misri? ");
INSERT INTO luo_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Angʼo momiyo dimi jo-Misri wuo gi ngʼayi kawacho ni, ‘Nogologi gi chuny marach mondo otiekgi ewi gode kendo mondo otiekgi e wangʼ piny?’ Kuom mano, we mirimbi mager, mondo ilok chunyi kik ikel kethruok ni jogi. ");
INSERT INTO luo_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Par jotichni Ibrahim, Isaka kod Jakobo mane ikwongʼorini in iwuon kiwacho ni, ‘Abiro keto nyikwayi mondo obed mangʼeny kaka sulwe mar kor polo bende abiro miyo nyikwayi pinyni duto mane asingonegi ni nobed mwandugi nyaka chiengʼ.’ ” ");
INSERT INTO luo_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Kuom mano Jehova Nyasaye noloko pache mine ok okelone joge masira mane osewacho. ");
INSERT INTO luo_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa nolor koa e got kotingʼo kite ariyo mag Rapar e lwete kendo kitego nondik koni gi koni. ");
INSERT INTO luo_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Kitego ne gin tich Nyasaye; kendo ndiko mane ni kuomgi ne mar Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Kane Joshua owinjo koko mane ji goyo nowacho ne Musa niya, “Mahu mar lweny wuok e kambi.” ");
INSERT INTO luo_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","To Musa nodwoke niya, “Ok en mahu mar loch kata ywak mar joma olo e lweny; to en mana koko mar wer ema awinjo.” ");
INSERT INTO luo_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Kane Musa ochopo machiegni gi kambi koa e tiend got noneno ji kamiel e nyim nyaroya, kendo iye nowangʼ mi nodiro kite mopa mane ni e lwete piny ma gitore matindo tindo. ");
INSERT INTO luo_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Bangʼe nokawo nyaroya mane giseloso mi owangʼe e mach kendo norege mayom kaka mogo mi noruwe gi pi momiyo jo-Israel mondo omodhi. ");
INSERT INTO luo_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Nopenjo Harun niya, “Angʼo mane jogi otimoni momiyo irwakogi e richo maduongʼ kamano?” ");
INSERT INTO luo_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Harun nodwoke niya, “Kik ibed gi ich wangʼ ruodha nimar ingʼeyo kaka chuny jogi osiko kopongʼ gi richo. ");
INSERT INTO luo_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ne giwachona kama, ‘Losnwa nyiseche mabiro telonwa, nimar ok wangʼeyo gima otimo ngʼat ma Musa-ni mane ogolowa e piny Misri.’ ");
INSERT INTO luo_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Kuom mano nawachonegi ni, ‘Ngʼato ka ngʼato man-gi bangli mag dhahabu okaw mondo okel.’ Eka negimiya dhahabu kendo nakete e mach mi aloso nyaroyani!” ");
INSERT INTO luo_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa noneno ka ji osenjawni kendo kaka Harun noketogi mi gibedo joma wigi tek ma ijaro gi wasikgi. ");
INSERT INTO luo_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Kuom mano nochungʼ e dhoranga kambi mowacho niya, “Ngʼato angʼata man kor Jehova Nyasaye obi ira.” Kendo jo-Lawi duto nochungʼ e ngʼeye. ");
INSERT INTO luo_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Eka nowachonegi niya, “Ma e gima Jehova Nyasaye, ma Nyasach Israel wacho: ‘Ngʼato ka ngʼato okaw liganglane. Wuothuru ei kambi duto koni gi koni ka ngʼato ka ngʼato nego owadgi, osiepne kod ngʼat modak bute.’ ” ");
INSERT INTO luo_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Jo-Lawi notimo kaka Musa nochikogi kendo chiengʼno ji madirom alufu adek nonegi. ");
INSERT INTO luo_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Eka Musa nowacho niya, “Un osewalu ni Jehova Nyasaye kawuono nimar ne ulokoru gi oweteu gi yawuotu kendo Jehova Nyasaye osegwedhou kawuono.” ");
INSERT INTO luo_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Kinyne Musa nowacho ni ji niya, “Usetimo richo maduongʼ to koro abiro dhi ir Jehova Nyasaye nimar dipoka akwayonu Jehova Nyasaye mondo owenu richou.” ");
INSERT INTO luo_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Kuom mano Musa nodok ir Jehova Nyasaye mowacho niya, “Yaye, mano kaka jogi osetimo richo malich, ma giseloso nyisechegi mag dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","To koro kiyie, to wenegi richogi, to ka ok kamano, to ruch nyinga oko e kitabu misendikono.” ");
INSERT INTO luo_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Eka Jehova Nyasaye nodwoko Musa niya, “Ngʼato angʼata motimo richo e nyima ema anaruch nyinge oko e kitabu mara. ");
INSERT INTO luo_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","To koro, dhiyo mondo itelne ji kiterogi kama ne awacho kendo malaikana biro telo nyimu. To kata kamano, ka kindena mar kum ochopo to anakumgi nikech richogi.” ");
INSERT INTO luo_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Kuom mano, Jehova Nyasaye nogoyo jogo gi tuoche kuom lamo nyaroya mane Harun oloso. ");
INSERT INTO luo_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Eka Jehova Nyasaye nowacho ne Musa niya, “Wuoguru ka in kaachiel gi jok mane igolo e piny Misri kendo dhiuru e piny mane asingo ka akwongʼora ne Ibrahim, Isaka kod Jakobo kawachonegi ni, ‘Anamiye nyikwau.’ ");
INSERT INTO luo_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Abiro oro Malaika mondo otel e nyimu kendo obiro riembo jo-Kanaan gi jo-Amor gi jo-Hiti gi jo-Perizi gi jo-Hivi kod jo-Jebus. ");
INSERT INTO luo_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Dhiuru e piny mopongʼ gi chak kod mor kich. To ok anadhi kodu nikech un oganda ma tokgi tek kendo dipo ka atiekou e wangʼ yo.” ");
INSERT INTO luo_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kane oganda owinjo weche manyoso chunygo negichako ywak maonge ngʼama nolichore gi gimoro amora e dende. ");
INSERT INTO luo_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Nimar Jehova Nyasaye nosewacho ni Musa niya, “Nyis jo-Israel kama, ‘Un oganda ma tokgi tek. Ka anyalo dhi kodu kata matin, to anyalo tiekou. Koro goluru oko gik mulichogo dendu eka anane gima anyalo timo kodu.’ ” ");
INSERT INTO luo_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Kuom mano jo-Israel nogolo oko gik mane gilichogo dendgi ka gin e tiend Got Horeb. ");
INSERT INTO luo_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Koro Musa nohero kawo Hema kendo gure oko mar Kambi mochwalore matin koluonge ni “Hemb Romo.” Ngʼato angʼata mane dwaro penjo Jehova Nyasaye wach ne dhi e Hemb Romo oko mar kambi. ");
INSERT INTO luo_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Kinde moro amora mane Musa odhi oko e Hema to ji duto ne wuok kendo chungʼ e dhoutgi mag hema ka gingʼiyo Musa nyaka chop odonji. ");
INSERT INTO luo_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Kane Musa dhi e Hema to bor polo ne lor piny kendo siko e dhoot ka Jehova Nyasaye wuoyo gi Musa. ");
INSERT INTO luo_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kinde mane oganda oneno bor polono kochungʼ e dho Hema gin bende negichungʼ mi gilam ka ngʼato ka ngʼato nitie e dho Hembe. ");
INSERT INTO luo_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Jehova Nyasaye ne wuoyo gi Musa wangʼ gi wangʼ mana ka ngʼato ma wuoyo gi osiepne. Bangʼ mano Musa noduogo e kambi, to Joshua wuod Nun, ma en wuowi mane konye nodongʼ mana e Hema. ");
INSERT INTO luo_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa nowacho ne Jehova Nyasaye niya, “Isebedo ka iwachona ni, ‘Telne jogi,’ to pok imiya ngʼeyo ngʼatno ma ibiro oro koda. Isewacho niya, ‘Angʼeyi gi nyingi kendo amor kodi.’ ");
INSERT INTO luo_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ka imor koda to puonja yoreni mondo angʼeyi kendo mondo asik ka amori. Par ni ogandani gin jogi.” ");
INSERT INTO luo_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Jehova Nyasaye nodwoke niya, “An awuon abiro dhi kodi kendo kwe mara nobed kodi.” ");
INSERT INTO luo_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Eka Musa nowacho niya, “Ka in iwuon ok idhi kodwa, to kik igolwa ka. ");
INSERT INTO luo_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ere kaka ngʼato dingʼe ni imor koda kaachiel gi jogigi makmana ka idhi kodwa? Koso en angʼo ma dipoga gi jogigi kod ogendini mamoko mantie e piny?” ");
INSERT INTO luo_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Eka Jehova Nyasaye nowacho ne Musa niya, “Abiro timo mana gino ma isekwayo nimar amor kodi kendo angʼeyi gi nyingi.” ");
INSERT INTO luo_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Eka Musa nowachone niya, “Koro nyisa duongʼni.” ");
INSERT INTO luo_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Kendo Jehova Nyasaye nowachone niya, “Abiro miyo duongʼna duto kadho e nyimi kendo abiro hulo nyinga ma en Jehova Nyasaye e nyimi. Anakech ngʼama adwaro kecho kendo anangʼwon-ne ngʼama adwaro ngʼwonone.” ");
INSERT INTO luo_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Nowacho bende niya “Ok inyal neno wangʼa, nimar onge ngʼama nyalo nena mi dok mangima.” ");
INSERT INTO luo_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Eka Jehova Nyasaye nowacho niya, “Nitie wi lwanda moro buta ka ma inyalo chungʼie. ");
INSERT INTO luo_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ka duongʼna kadho to abiro pandi e rogo mar lwanda kendo abiro umi gi lweta nyaka chop akadhi. ");
INSERT INTO luo_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Eka abiro golo lweta kuomi mi inine mana ngʼeya, to wangʼa to ok nine.” ");
INSERT INTO luo_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Jehova Nyasaye nowacho ne Musa niya, “Paa kite ariyo machal gi mane okwongo ka kendo anandikie weche mane ni e kite mokwongo mane itoyo. ");
INSERT INTO luo_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Bed moikore gokinyi kendo ibi ira ewi Got Sinai kendo kanyo ema anaromie kodi. ");
INSERT INTO luo_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Onge ngʼato angʼata manobi kodi kata manobed machiegni ewi got kata mana chiayo kod kweth mag dhok kik kwaa e alwora mar godno.” ");
INSERT INTO luo_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Kuom mano Musa nopayo kite ariyo machal gi mane okwongo ka kendo nodhi ewi Got Sinai gokinyi kotingʼogi e lwete mana kaka Jehova Nyasaye nosechike. ");
INSERT INTO luo_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Eka Jehova Nyasaye nolor koa ei boche kendo nochungʼ kanyo kod Musa kohulone nyinge mar Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Kendo nokadho e nyim Musa kohulo niya, Jehova Nyasaye, Jehova Nyasaye, ma jangʼwono kendo ma kecho ji, ahora mos bende agundho gihera kod adiera, ");
INSERT INTO luo_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ka anyiso hera ne ji gana gi gana kendo aweyo ni ji timbegi maricho, wich teko kod richo. To kata kamano, ok akwan joricho kaka joma kare; to akumo nyithindo gi nyikwayo nyaka tiengʼ mar adek kod mar angʼwen nikech richo kweregi. ");
INSERT INTO luo_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa nokulore nyaka e lowo mapiyo nono mi olamo. ");
INSERT INTO luo_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Nowacho niya, “Yaye Ruoth Nyasaye, ka ayudo ngʼwono e nyim wangʼi, to yie idhi kodwa. Kata obedo ni jogi gin joma tokgi tek kamano, to wenwa kuom timbewa mamono kod richowa kendo kwan-wa kaka mwanduni.” ");
INSERT INTO luo_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Eka Jehova Nyasaye nowacho niya, “Atimo kodi singruok. E nyim jogi duto abiro timo honni madongo mapok otimie oganda moro amora e piny. Jogo mudak e kindgi biro neno kaka timbe ma an Jehova Nyasaye abiro timo dongo. ");
INSERT INTO luo_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Rituru chike ma amiyou kawuono. Abiro riembo oko e nyimu jo-Amor, jo-Kanaan, jo-Hiti, jo-Perizi, jo-Hivi kod jo-Jebus. ");
INSERT INTO luo_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Beduru motangʼ ne timo winjruok gi jogo modak e pinyno ma udhiyoe, nono to ginibednu obadho. ");
INSERT INTO luo_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mukuru kendegi mag misengini, touru kitegi mopa milamo kendo tongʼuru sirnigi mag Ashera. ");
INSERT INTO luo_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Kik ulam nyasaye moro amora nikech Jehova Nyasaye en Nyasaye ma janyiego. ");
INSERT INTO luo_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Beduru motangʼ ne timo winjruok gi jogo modak e pinyno; nimar ka gilamo nyisechegi e yor dwanyruok kendo gitimo misengini gibiro luongou kendo ubiro chamo chiembgi mag misengini. ");
INSERT INTO luo_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","To bende ka ukawo nyigi moko mondo obed mond yawuotu mi nyigigo odwanyore kendgi gi nyisechegigo, to gibiro miyo yawuotu timo kamano. ");
INSERT INTO luo_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Kik ulos nyiseche mothedhi mag mula mondo ulam. ");
INSERT INTO luo_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Timuru nyasi mar Sawo mar makati ma ok oketie thowi kuom ndalo abiriyo kaka nachikou. Timuru mano e kinde moketi e dwe mar Abib, nimar e dweno ema ne agoloue e piny Misri. ");
INSERT INTO luo_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Nyak mokwongo mar nyodo e kind jo-Israel en mara, bed ni en dhano kata jamni. ");
INSERT INTO luo_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Waruru nyodo mokwongo mar punda gi nyarombo, to ka ok unyal ware, to tururu ngʼute. Waruru yawuotu makayo. “Onge ngʼama onego obi e nyima gi lwete nono. ");
INSERT INTO luo_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Kuom ndalo auchiel unutim tijeu to odiechiengʼ mar abiriyo unuywe; kata mana e kinde mag pur kod keyo bende nyaka uywe. ");
INSERT INTO luo_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Timuru nyasi mar Sawo mar Jumbe gi keyo mar nyak mokwongo mar ngano kod Sawo mar Pono Olembe e rumb higa. ");
INSERT INTO luo_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Jou machwo duto nyaka chopi e nyim Jehova Nyasaye Manyalo Gik Moko Duto, ma Nyasach Israel nyadidek e higa. ");
INSERT INTO luo_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Abiro riembo oko ogendini bende abiro yaro tongʼ mar pinyu kendo onge ngʼat manobed gi gombo kuom pinyu e kinde ma udhi ir Jehova Nyasaye ma Nyasachu ngʼato ka ngʼato nyadidek e higa. ");
INSERT INTO luo_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Kik uchiwna remo motimgo misango kaachiel gi gimoro amora moketie thowi, kendo misango moro amora mochiw chiengʼ nyasi mar Pasaka kik dongʼ nyaka okinyi. ");
INSERT INTO luo_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Keluru cham mabeyo mokwongo nyaknu e lowo e od Jehova Nyasaye ma Nyasachu. “Kik uted nyadiel ma pod dhodho cha min.” ");
INSERT INTO luo_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Eka Jehova Nyasaye nowacho ne Musa niya, “Ndik wechegi piny nimar kaluwore gi wechegi asetimo singruok kodi kaachiel gi jo-Israel.” ");
INSERT INTO luo_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa nobedo gi Jehova Nyasaye kuno kuom ndalo piero angʼwen odiechiengʼ gotieno, ka ok ocham makati kata modho pi. Kendo nondiko weche mag singruokgi e kite mopa miluongi ni Chike Apar. ");
INSERT INTO luo_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Kane Musa olor koa e Got Sinai gi kite ariyo mopa mag Sandug Muma kotingʼo e lwete to ne ok ongʼeyo ni lela wangʼe ne rieny nikech nosewuoyo gi Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Kane Harun kod jo-Israel duto oneno ka lela wangʼ Musa rieny, negiluoro biro bute machiegni. ");
INSERT INTO luo_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","To Musa noluongogi; omiyo Harun kod jodongo duto mag oganda Israel noduogo ire mi owuoyo kodgi. ");
INSERT INTO luo_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Bangʼe jo-Israel duto nobiro machiegni kode kendo ne omiyogi chike duto ma Jehova Nyasaye nosemiye e Got Sinai. ");
INSERT INTO luo_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Kane Musa otieko wuoyo kodgi, noketo ragengʼ e wangʼe. ");
INSERT INTO luo_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","To e kinde moro amora mane odhi e nyim Jehova Nyasaye mondo owuo kode, to nogolo ragengʼno nyaka owuog e nyime. Kane owuok oko mi onyiso jo-Israel gima Jehova Nyasaye osewachone, negineno wangʼe karieny. ");
INSERT INTO luo_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Eka Musa ne gengʼo wangʼe kendo nyaka chop ochak odhi owuo gi Jehova Nyasaye kendo. ");
INSERT INTO luo_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa noluongo ogendini mag jo-Israel duto kanyakla mi owachonegi niya, “Gik ma Jehova Nyasaye ochikou mondo utim e magi: ");
INSERT INTO luo_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Kuom ndalo auchiel nyaka uti to odiechiengʼ mar abiriyo nobed odiechiengu maler, ma en Sabato mar yweyo ni Jehova Nyasaye. Ngʼato angʼata motimo tich chiengʼ Sabato nyaka negi. ");
INSERT INTO luo_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Kik umok mach e kar daku moro amora chiengʼ Sabato.” ");
INSERT INTO luo_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa nowacho ni oganda jo-Israel duto niya, “Ma e gima Jehova Nyasaye ochiko: ");
INSERT INTO luo_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Teruru chiwo ne Jehova Nyasaye kuom gik moko duto ma un-go. Ngʼato angʼata ma chunye oyie nyaka kel ne Jehova Nyasaye chiwo mag: “dhahabu, fedha kod mula; ");
INSERT INTO luo_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","law marambulu, maralik, marakwaro, law mayom kod law mar yie diek; ");
INSERT INTO luo_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","piende rombe molok gi range makwar, piende monyongʼ mayom mag le mag nembe, yiend siala; ");
INSERT INTO luo_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mor zeituni miolo e taya mondo okel ler, gik mangʼwe ngʼar milosogo mor pwodhruok kod ubani mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","gi oniks kod kite moko miketo kuom law mayom mar dolo miluongo ni efod kod law akor. ");
INSERT INTO luo_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Jotich duto molony mantie e kindu nyaka bi mondo olos gik moko duto ma Jehova Nyasaye osechiko kaka: ");
INSERT INTO luo_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“Hemb Romo kod hembene ma oko, gi raumne, gi ramakine, gi sirnine gi bepene miriwo kod sirni gi rachungigi, ");
INSERT INTO luo_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","gi Sandug Muma, gi ludhene, gi raum mar kar pwodhruok kod pasia mogengʼe; ");
INSERT INTO luo_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","gi mesa kod ludhene kaachiel gi gigene duto mag tich kod makati miketo e nyim Jehova Nyasaye; ");
INSERT INTO luo_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","bende gilos rachungi taya kod gigene duto kaka techene gi mo milielgo; ");
INSERT INTO luo_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","gi kendo mar misango miwangʼoe ubani, kaachiel gi ludhene, kod mor pwodhruok gi ubani mangʼwe ngʼar, gi pasia molier e dhood Hemb Romo, ");
INSERT INTO luo_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","kod kendo mar misango miwangʼo pep, gi singʼengene molos gi mula man kod ludhene gi gik moko duto mitiyogo e kendono kaachiel gi karaya kod rachungine, ");
INSERT INTO luo_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","kod pasia mag laru gi sirnine kod rachungigi kod pasia moumo kar donjo mar laru, ");
INSERT INTO luo_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","loye mag hema gi loye mag laru gi tonde motwegigo, ");
INSERT INTO luo_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","kaachiel gi lewni mochwe mag tij dolo mitiyogo e kama ler mar lemo ma gin lewni mag Harun jadolo kod lep yawuote ka gitiyogo kaka jodolo.” ");
INSERT INTO luo_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Eka oganda mar jo-Israel duto noa e nyim Musa, ");
INSERT INTO luo_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","kendo ji duto mane oyie kendo chunygi oelore nobiro mokelo mich ni Jehova Nyasaye kuom tich mar Hemb Romo gi tijene duto gi lewni mopwodhi mag dolo. ");
INSERT INTO luo_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ji duto mane oyie, chwo kod mon, nobiro mokelo bangli gi sitadi mag dhahabu. Ji duto nokelo ne Jehova Nyasaye misango mifwayo mar dhahabu, ");
INSERT INTO luo_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","to jomoko to nokelo law marambulu, kata maralik, kata marakwaro, kata yie diek, kata piende rombe molok makwar, kata piende monyongʼ mayom mag le mag nembe. ");
INSERT INTO luo_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Jogo mane kelo chiwo mar dhahabu kata fedha kata mula nokelogi kaka chiwo ni Jehova Nyasaye kendo ngʼato angʼata mane nigi yiend siala ne tich moro amora nokelo. ");
INSERT INTO luo_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Dhako moro amora molony e twengʼo kod chwecho nokelo law marambulu, maralik kod marakwaro. ");
INSERT INTO luo_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Kendo mon duto mane chunygi oyie kendo olony e twengʼo nokelo yie diek. ");
INSERT INTO luo_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Jotelo nokelo kite mag oniks kod kite mamoko miketo e law mayom mar dolo miluongo ni efod kendo kuom law akor. ");
INSERT INTO luo_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Bende negikelo gik madum mangʼwe ngʼar gi mor zeituni miolo e taya to gi mor pwodhruok kod ubani mangʼwe ngʼar. ");
INSERT INTO luo_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Jo-Israel duto machwo gi mamon mane chunygi oyie nokelo ni Jehova Nyasaye chiwo mar hera ne tich duto mane Jehova Nyasaye ochiko Musa mondo otim. ");
INSERT INTO luo_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Eka Musa nowacho ne jo-Israel niya, “Winjuru, Jehova Nyasaye oseyiero Bezalel wuod Uri, ma wuod Hur, maa e dhood Juda, ");
INSERT INTO luo_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","kendo osepongʼe gi Roho mar Nyasaye, mondo obed gi lony, gi rieko, gi nyalo kod ngʼeyo tije duto mag lwedo; ");
INSERT INTO luo_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","mondo omi ogor kido mabeyo mag dhahabu gi fedha kod mula, ");
INSERT INTO luo_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","kendo ongʼad kite duto gi payo bao kendo mondo otim kit tije, duto mag lwedo. ");
INSERT INTO luo_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Kendo osemiyo Bazalel, wuod Uri, ma wuod Hur, maa e dhood Juda kaachiel gi Oholiab wuod Ahisamak maa e dhood Dan rieko mar puonjo jomoko. ");
INSERT INTO luo_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Osemiyogi rieko mar tiyo tije machalo kaka pecho, goro, chweyo lewni marambulu, maralik, marakwaro kod lewni mayom, ma gin tich joma nigi lony. ");
INSERT INTO luo_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Kuom mano Bezalel, Oholiab kod jotich duto molony mane Jehova Nyasaye omiyo rieko gi nyalo mar ngʼeyo kaka itiyo tich duto mar gero kama ler mar lemo nyaka ti mana kaka Jehova Nyasaye osechiko.” ");
INSERT INTO luo_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Eka Musa noluongo Bezalel gi Oholiab kod jotich duto molony mane Jehova Nyasaye omiyo rieko gi nyalo kendo mane oyie biro mondo oti. ");
INSERT INTO luo_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Musa nomiyogi chiwo duto mane jo-Israel osekelo kuom gero kama ler mar lemo, kendo ji nomedo kelo chiwo mar hera okinyi kokinyi. ");
INSERT INTO luo_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Omiyo jotich duto molony e tije mag lwedo mane timo tije ei kama ler mar lemo noweyo tijegi ");
INSERT INTO luo_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","mi ginyiso Musa niya, “Ji kelo gik mangʼeny moloyo kar midwaro moloyo kuom tich mane Jehova Nyasaye ochiko ni mondo otim.” ");
INSERT INTO luo_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Eka Musa nogolo chik mine gilando wachni e kambi duto kagiwacho niya, “Onge dichwo kata dhako manochak okel chiwo moro amora ne tich gero kama ler mar lemo.” Kuom mano notam ji mondo kik gimed kelo gige tich, ");
INSERT INTO luo_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","nikech gik mane osekel ne ngʼeny moloyo tieko tich duto mar gero kama ler mar lemo. ");
INSERT INTO luo_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Jotich molony duto mane nigi jotich mamoko nogero Hemb Romo gi pasia apar mar law mayom momin man-gi rangi marambulu gi maralik kod marakwaro ka ogorie kido mar malaika mar kerubi gi jagoro molony. ");
INSERT INTO luo_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Pasiago duto ne romre ka borne romo fut piero angʼwen gariyo to lachne romo fut auchiel. ");
INSERT INTO luo_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Negiriwo pasia abich kanyakla kendo abich modongʼ bende negiriwo. ");
INSERT INTO luo_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Eka negiloso tonde milierogo pasia e riak pasia man-gi range marambulu kendo negitimo kamano e riak pasia matungʼ komachielo. ");
INSERT INTO luo_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Bende negiloso tonde piero abich e riak pasia achiel kendo tonde piero abich mamoko e riak pasia komachielo ka tonde moliergo pasiago omanyore. ");
INSERT INTO luo_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Eka negiloso ramaki piero abich mag dhahabu kendo negitiyo kodgi kuom riwo pasia ariyogo kanyakla mondo omi Hemb Romo obed gimoro achiel. ");
INSERT INTO luo_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Negiloso pasia apar gachiel mag yie diek ne hema mondo oumgo Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Pasia apar gachielgo duto ne romre ka bor moro ka moro romo fut piero angʼwen gabich to lachgi romo fut auchiel. ");
INSERT INTO luo_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Negiriwo pasia abich obedo gimoro achiel kendo auchiel modongʼ bende negiriwo kamano. ");
INSERT INTO luo_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Eka negiloso tonde milierogo pasia piero abich e giko riak pasia konchiel kendo tonde piero abich e giko riak pasia komachielo. ");
INSERT INTO luo_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Negiloso ramaki mag mula piero abich mondo gitwego hemano kanyakla mondo obed gimoro achiel. ");
INSERT INTO luo_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Eka negilosone hemano raum mar pien rombe molok gi range makwar kendo negiume gi piende monyongʼ mayom mag le mag nam. ");
INSERT INTO luo_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Negiloso sirni mochungʼ mag yiend siala ne Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Bor siro ka siro ne en fut apar gabich, to lachne ne en fut ariyo gi nus; ");
INSERT INTO luo_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ka siro ka siro ochungʼ momanyore gi nyawadgi. Negiloso sirni duto mag Hemb Romo machalre kamano. ");
INSERT INTO luo_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Negiloso sirni piero ariyo migerogo bath Hemb Romo mochomo yo milambo, ");
INSERT INTO luo_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","kendo negiloso rachungi mar taya piero angʼwen mag fedha miketo e bwogi, ka rachungi ariyo iketo e bwo sirni ariyo momanyore. ");
INSERT INTO luo_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Kuom bathe komachielo man koma ochomo yo nyandwat, negiloso sirni piero ariyo, ");
INSERT INTO luo_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","kod rachungi piero angʼwen mag fedha, ka siro ka siro otingʼo rachungi ariyo ariyo. ");
INSERT INTO luo_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Negiloso sirni auchiel ne bathe mochwalore mochomo yo podho chiengʼ mar Hemb Romo, ");
INSERT INTO luo_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","kendo sirni mamoko nokete e konde man yo tok Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","E konde ariyogi noriw chakre e tiende nyaka e wiye malo kendo sirnigo noriw machalre. ");
INSERT INTO luo_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Omiyo ne nitie sirni aboro gi rachungi mag fedha apar gauchiel mag fedha, ka siro ka siro otingʼo rachungi ariyo ariyo. ");
INSERT INTO luo_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Bende negiloso bepe miriwo mag yiend siala ka abich oket ne sirni mantie bathe konchiel mar Hemb Romo, ");
INSERT INTO luo_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","to abich modongʼ oketi e bathe komachielo, to abich modongʼ nomako sirni mane omakgo katoke mochomo yo podho chiengʼ mar Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Negiloso raidhi madiere mane ochakore tungʼ nyaka tungʼ e dier sirnigo. ");
INSERT INTO luo_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ne gibawo sirnigo gi dhahabu kendo negiloso ratege mag dhahabu mondo omak raidhi miriwogo. Bende ne gibawo raidhigo gi dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Negiloso pasiago gi law mayom momin mar range marambulu, maralik kod marakwaro moketie kido mar malaika mar kerubi kogorie gi jagoro molony. ");
INSERT INTO luo_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Negiloso ludhe angʼwen mag yiend siala mobaw gi dhahabu. Ne gilosonegi rangʼaw mag dhahabu kendo ne girwakonegi rachungigi angʼwen mag fedha. ");
INSERT INTO luo_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Negilosone dhoranga Hemb Romo law mayom momin mar range marambulu, maralik kod marakwaro, ma en tich jachwecho molony; ");
INSERT INTO luo_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","kendo ne gilosonegi ludhe abich man-gi ramaki. Ne giumo wi ludhego kod ratege molworogi gi dhahabu, to rachungi abich mirwako ewi sirnigo nolos gi mula. ");
INSERT INTO luo_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel noloso Sandug Muma gi yiend siala ma borne romo fut angʼwen gi nus to lachne romo fut achiel gi nus kendo borne madhi malo romo fut achiel gi nus. ");
INSERT INTO luo_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Nobawe gi dhahabu maler oko gi iye kendo nochwene ndiga mar dhahabu mothedhi molwore. ");
INSERT INTO luo_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Nothedhne ratege angʼwen molworore mag dhahabu machalo gi bangli kendo notwegi e tiendene angʼwen-go, ka ratege ariyo bedo e bathe konchiel to ariyo mamoko e bathe komachielo. ");
INSERT INTO luo_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Eka noloso ludhe mag yiend siala mi obawogi gi dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Kendo norwako ludhego ei ratege mantie e bethe Sandug Muma mondo otingʼego. ");
INSERT INTO luo_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Noloso raum mar pwodhruok gi dhahabu maler ma borne romo fut angʼwen gi nus kendo lachne romo fut achiel gi nus. ");
INSERT INTO luo_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Eka noloso kido mar malaika ariyo miluongo ni kerubi gi dhahabu mothedhi. ");
INSERT INTO luo_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Noloso kido mar malaika mar kerubi achiel e giko raumno kendo malaika mar ariyo e giko komachielo; kendo noriwogi ma gibedo gimoro achiel ewi raumno. ");
INSERT INTO luo_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kido mar malaika mar kerubigo noyaro bwombegi kochomo malo mondo giumgo raumno. Kerubigo nochungʼ momanyore ka ngʼiyore gi wi raumno. ");
INSERT INTO luo_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Negiloso mesa gi yiend siala ma borne romo fut adek to lachne romo fut achiel gi nus kendo borne madhi malo romo fut ariyo gi robo. ");
INSERT INTO luo_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Eka ne gibawe gi dhahabu maler kendo gilworo bethene gi dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Bende negiloso bethene molwore ma lachne romo gi pat lwedo achiel kendo ne gichweyo bethenego gi dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Negilosone ratege molworore angʼwen mag dhahabu kendo ne gitweyogi e konde angʼwen mag mesa kama ne nitie tiendene. ");
INSERT INTO luo_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ratege molwororego noket machiegni gi bethe mesano mondo omak ludhego mitiyogo kuom tingʼo mesa. ");
INSERT INTO luo_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ludhe mitingʼogo mesano nolos gi yiend siala kendo nobawgi gi dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Gik mitiyogo e mesano mane olosi gi dhahabu maler ne gin, sende, bakunde, tewni kod agulnine mitiyogo kuom chiwo misengini miolo piny. ");
INSERT INTO luo_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Negiloso rachung taya gi dhahabu maler kendo ne othedh tiende gi kore gi kikombege machalo maua gi thiepege kod obokege kaka gimoro achiel. ");
INSERT INTO luo_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Bedene auchiel nochwogore gi e kore ka adek nitie konchiel kendo adek nitie komachielo. ");
INSERT INTO luo_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Kikombe adek molos kaka maupe mag oyungu gi thiepene kod obokene nobedo e bade achiel, kendo adek e bade maluwe kendo bedene auchielgo nochwogore kawuok e rachungi taya. ");
INSERT INTO luo_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Kendo kuom rachungi taya ne nitie kikombe angʼwen molos machal gi maupe mag oyungu mathiewo kendo golo thuoke. ");
INSERT INTO luo_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Maua achiel noketi e bwo bede ariyo mokwongo mar rachungino, mar ariyo noketi e bwo mar ariyo, to mar adek noketi e bwo bede mar adek, giduto gin bede auchiel. ");
INSERT INTO luo_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Maupego kod bedego duto nobedo gimoro achiel gi rachungi taya mothedh gi dhahabu maler. ");
INSERT INTO luo_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Negilosone rachungino teyni abiriyo, kaachiel gi gik mingʼadogo otambi kod gigene mag jowo buru molos gi dhahabu maler. ");
INSERT INTO luo_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Negiloso rachung tayano kod gigene duto gi dhahabu maler maromo kilo piero adek gangʼwen. ");
INSERT INTO luo_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Negiloso kendo mar misango miwangʼoe ubani gi yiend siala. Ne oromre bathe duto koni gi koni ka borne gi lachne en fut achiel gi nus, to borne madhi malo ne gin fut adek, kendo tungene nyaka bed gimoro achiel kode. ");
INSERT INTO luo_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ne gibawo wiye kod bethene duto kod tungene gi dhahabu maler bende nolosne ndiri mar dhahabu molwore. ");
INSERT INTO luo_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Negiloso ratege ariyo mag dhahabu e bwo ndiri ka gimanyore ariyo koni gi koni mondo omak ludhe mitingʼego. ");
INSERT INTO luo_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Negiloso ludhego gi yiend siala kendo ne gibawogi gi dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Bende negiloso mor pwodhruok maler kod ubani maliw madungʼ tik mangʼwe ngʼar, ma en tich jalos mo madungʼ tik mangʼwe ngʼar. ");
INSERT INTO luo_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Negigero kendo mar misango miwangʼo pep gi yiend siala ka borne madhi malo romo fut angʼwen gi nus; to lachne kod borne romo fut abiriyo gi nus maromre. ");
INSERT INTO luo_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Negiloso tungʼ e konde angʼwen mag kendono, mondo omi tungego kod kendo mar misango obed gimoro achiel, kendo ne gimuono kendo mar misangono gi mula. ");
INSERT INTO luo_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Gik moko duto mitiyogo e kendo mar misango nolos gi mula. Gigo ne gin agulni, opawo, bakunde mikirogo remo, gi uma michiwogo ringʼo kod tegni mag mach. ");
INSERT INTO luo_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Negiloso singʼenge ne kendo mar misango gi mula mondo oketi e bwoye nyaka chopi e kore gi yo ka malo ");
INSERT INTO luo_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Negiloso chuma molworore mag mula mondo omak ludhe ma itingʼego e kondene angʼwen-go. ");
INSERT INTO luo_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Negiloso ludhego gi yiend siala mi gibawe gi mula ");
INSERT INTO luo_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Negirwako ludhego ei nyangeyego mondo gibedi e bath kendo mar misangono kitingʼego, bende ne gitucho bugo e chunye mondo owe iye thuolo ka gitiyo gi bao mayom. ");
INSERT INTO luo_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Negiloso karaya mar mula gi rachungi miketoe karayano mag mula ka gitiyo gi kiyo mag mon mane tiyo e dho Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Bangʼe negiloso laru. Yo milambo mar laruno borne ne romo fut mia achiel gi piero abich gachiel kendo ne en gi pasia momin molos gi law mayom, ");
INSERT INTO luo_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","pasiani nolierie sirni piero ariyo gi rachungi piero ariyo mag mula, kod ramaki mag fedha kod rangʼaw miriwogo sirnigo. ");
INSERT INTO luo_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Koma odok yo nyandwat mar laruno nobed maromo fut mia achiel piero abich gachiel kendo nobed gi sirni piero ariyo gi rachungi piero ariyo mag mula man-gi ramaki kod rangʼaw miriwogo kor sirni molos gi fedha. ");
INSERT INTO luo_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Kochomo yo podho chiengʼ mar laruno lachne ne romo fut piero ochiko gaboro kendo ne en gi pasia mongʼaw e sirni apar morwakie rachungi apar kaachiel gi ramaki molos gi fedha kod rangʼaw miriwogo sirnigo. ");
INSERT INTO luo_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Kochomo yo wuok chiengʼ mar laruno bende lachne ne romo fut piero abiriyo gabich. ");
INSERT INTO luo_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Pasia ma borgi romo fut piero ariyo gadek ne nitie e bath rangach konchiel ka pasiago ongʼaw ewi sirni adek man-gi rachungi adek, ");
INSERT INTO luo_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","kendo pasia mamoko ma borgi romo fut piero ariyo gadek ne nitie e bath rangach komachielo kongʼawgi e sirni adek man-gi rachungi adek. ");
INSERT INTO luo_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Pasiago duto molworo laruno molos gi law mayom momin. ");
INSERT INTO luo_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Rachungi mag sirnigo nolos gi mula. Ramaki gi rangʼaw mag sirnigo nolos gi fedha, kendo nobaw wi sirnigo gi fedha; rangʼaw mag sirnigo duto mag laru nolos gi fedha. ");
INSERT INTO luo_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Pasia duto mag dhorangach nolos gi law mayom momin marambulu gi maralik kod makwar molos gi jatwengʼo molony. Borne ne romo fut piero adek kendo kaka pasia mag laru borne ne romo fut aboro, ");
INSERT INTO luo_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","gi sirni angʼwen kod rachungi mag mula angʼwen. Ramekigi gi rangʼawgi nolos gi fedha. ");
INSERT INTO luo_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Loye duto mag Hemb Romo kod loye mag alwora mar laru nolos gi mula. ");
INSERT INTO luo_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Magi e kar romb gik moko duto mane otigo kigero Hemb Romo, ma en Hema mar singruok kaka nokwan-gi gi chik mane Musa ogolo ne jo-Lawi kotelnegi gi Ithamar wuod Harun jadolo. ");
INSERT INTO luo_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(Bezalel wuod Uri ma wuod Hur ja-dhood Juda noloso gik moko duto kaka Jehova Nyasaye nochiko Musa; ");
INSERT INTO luo_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ne en gi Oholiab wuod Ahisamak ma ja-dhood Dan ma jatich lwedo kendo jagoro kendo jatwangʼ lewni marambulu gi maralik kod marakwaro.) ");
INSERT INTO luo_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Kar dhahabu duto mane okel kawuok e misango mifwayo mane otigo e tich duto mar kama ler mar lemo ne romo kilo alufu achiel (1,000) kaluwore gi rapim mar kama ler mar lemo. ");
INSERT INTO luo_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Fedha mane oyudi koa kuom oganda duto mane okwan e kweno maduongʼ ne romo kilo alufu adek mia angʼwen (3,400) kaluwore gi rapim mar kama ler mar lemo, ");
INSERT INTO luo_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","fedhago ema nochok kane ngʼato ka ngʼato mane okwan ogolo nus shekel kaluwore gi rapim mar kama ler mar lemo nimar kar romb joma nokwan machwo mahikgi oromo piero ariyo kadhi nyime ne gin ji alufu mia auchiel gadek mia abich gi piero abich (603,550). ");
INSERT INTO luo_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Fedha maromo kilo alufu adek mia angʼwen-go (3,400) notigo kuom loso rachungi mag kama ler mar lemo kod mag pasia, ka rachungi ka rachungi kawo kilo piero adek gangʼwen (34,000). ");
INSERT INTO luo_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","To kilo piero ariyo negitiyogo kuom loso ramaki mag sirni kendo bawo wi sirnigo kod loso rangʼepegi. ");
INSERT INTO luo_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Mula mane oyudi e misango mifwayo ne romo kilo alufu ariyo mia angʼwen (2,400). ");
INSERT INTO luo_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Negitiyo kode kuom loso rachungi mag dho Hemb Romo gi kendo mar misango mar mula gi singʼengene gi gik moko duto mitiyogo e kendono, ");
INSERT INTO luo_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","kaachiel rachungi mag laru kod mag dhorangach kod sigingigi mag Hemb Romo kod laru molwore. ");
INSERT INTO luo_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Negiloso lep dolo momin gi law mayom marambulu gi maralik kod marakwaro ma itiyogo e kama ler mar lemo. Bende negiloso lewni mopwodhi ne Harun kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Negiloso law mayom mar dolo miluongo ni efod gi dhahabu kod usi marambulu gi maralik kod marakwaro momin gi law mayom. ");
INSERT INTO luo_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ne githedho dhahabu marep-rep kendo ne gilire matindo tindo mondo olosgo law marambuluno gi maralik kod marakwaro kolose gi jatwengʼo molony. ");
INSERT INTO luo_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Negiloso okanda ariyo mag gok mitweyogo law efodno e kondene gi yo ka nyime kod yo kangʼeye. ");
INSERT INTO luo_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Okandane mochwe maber ne chalo kode kolose obedo gimoro achiel gi law mayom mar dolo miluongo ni efod bende nyaka lose gi dhahabu kod law momin mayom man-gi range marambulu gi maralik kod marakwaro kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ne giketone kite mag oniks e yo michanogo dhahabu kendo negikedogi kaka ikedo kido ka gindiko nying yawuot Israel kuome. ");
INSERT INTO luo_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Eka negitweyo kitego e lep akor mag law mayom mar dolo miluongo ni efod mondo gibed kaka kite mag rapar ne nyithind Israel kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ne gitwangʼo law akor e yo ma jatwengʼo molony twengʼogo ka olose gi dhahabu kod usi marambulu, gi maralik kod marakwaro kod law mayom mar katana kendo momin maber ka law mayom mar dolo miluongo ni efod. ");
INSERT INTO luo_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Noromre duto ka borne gi lachne romo bat achiel kendo nobane nyadiriyo. ");
INSERT INTO luo_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Eka negichano laini angʼwen mag kite ma nengogi tek kuom lawno. Laini mokwongo ne gichane kite kaka rubi, topaz gi beril; ");
INSERT INTO luo_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","e laini mar ariyo ne ochanie kite kaka tarkus, gi safir kod emerald, ");
INSERT INTO luo_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","to e laini mar adek ne gichane kite kaka jasinth, gi agat kod amethist ");
INSERT INTO luo_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","kendo e laini mar angʼwen ne gichane kite kaka krisolit gi oniks kod jaspa. Kidigo duto negichano kaka thiwni mag dhahabu. ");
INSERT INTO luo_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kitego duto nondikie nying yawuot Israel apar gariyo, ka okedgi kaka kido ka moro ka moro ochungʼ ne nying dhout Israel apar gariyogo. ");
INSERT INTO luo_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Bende negilosone law akor thiwni mokedi mag dhahabu maler machalo kaka tol. ");
INSERT INTO luo_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ne gilose kaka ichano dhahabu kod chumbe molworore ariyo mag dhahabu mi gitweyo chumbe molwororego e riak law mar law akor. ");
INSERT INTO luo_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Negitweyo thiwni ariyogo mag dhahabu e ratege mantie e riak law akor, ");
INSERT INTO luo_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","kendo negitweyo lak thiwnigo komachielo e laini ariyo mochan kaka dhahabu ka gichomego e tond law akor kuom law mayom mar dolo miluongo ni efod gi yo ka nyime. ");
INSERT INTO luo_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Negiloso ratege ariyo mag dhahabu mi gichomogi e konde ariyo mamoko mag law akor gi yo ka iye e riake kama otwangʼ-go law mayom mar dolo miluongo ni efod. ");
INSERT INTO luo_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Eka negiloso ratege ariyo mag dhahabu mi gichomogi e riak tonde ariyo mag gok yo ka nyime mar law mayom mar dolo miluongo ni efod machiegni gi kama oriwego but nungone. ");
INSERT INTO luo_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Negitweyo ratege mag law akorno kuom ratege mag law dolo miluongoni efod gi tol e yo nungone mondo law kik gonyre kuom law efod kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Negiloso kandho marambulu mirwakogo law dolo mar efod, ma en tij jatwengʼo molony, ");
INSERT INTO luo_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ka en gi otuchi e diere kaka ngʼut law kendo notwangʼ ngʼuteno gi pien mondo kik oyiechi. ");
INSERT INTO luo_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Negiloso gik mongʼinore kaka olemo molos gi usi marambulu gi maralik, law momin mayom e riak lawno. ");
INSERT INTO luo_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Bende negiloso gara kaka okode mag dhahabu maler mi gilierogi e riak aroyano ka gikikore gi gik mongʼinore kolemo. ");
INSERT INTO luo_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Garago gi gik mongʼinore kolemogo nokikore e riak lawno alwora mondo orwake kitimo tich dolo kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","To negilosone Harun kod yawuote kandho mar law mayom mar katana, ma en tij jatwengʼo molony, ");
INSERT INTO luo_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","kendo ne gilosonegi kilemba motwangʼ gi law mayom mar katana gi ogute kaachiel gi sirwaru maiye, ");
INSERT INTO luo_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","kod okanda mayom mitweyo marambulu gi maralik kod marakwaro kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Negiloso gima opadore ka san gi dhahabu maler mondo obed osimbo maler mi gindiko kuome ni: Kama owal ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Eka ne gitweye gi tol marambulu e kilemba kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Koro tich duto mar Hemb Romo norumo. Jo-Israel notimo gik moko duto mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Eka negikelo hemb romono ir Musa: Ne en hema kod gigene duto gi ramakine gi sirnine gi bepene miriwo kod sirni gi rachungigi; ");
INSERT INTO luo_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","kod raum mag pien rombo molok makwar gi raum mar piende monyongʼ mayom mag le mag nembe kod pasia migengʼego; ");
INSERT INTO luo_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","kod Sandug Muma gi ludhene gi raum mar kar pwodhruok; ");
INSERT INTO luo_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","gi mesa kod gigene duto mag tich kod makati miketo e nyim Jehova Nyasaye; ");
INSERT INTO luo_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","gi rachungi mar taya molos gi dhahabu maler gi gigene duto kaka techene gi mo milielgo; ");
INSERT INTO luo_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","gi kendo mar misango mochwe gi dhahabu, gi mor pwodhruok, gi ubani mangʼwe ngʼar gi pasia molier e dhood hema; ");
INSERT INTO luo_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","kod kendo mar misango molos gi mula kaachiel gi singʼengene man kod ludhene, gi gik moko duto mitiyogo e kendono; gi karaya molos gi mula, kod rachungine; ");
INSERT INTO luo_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","kod pasia mag laru, gi sirnine kod rachungigi, kod pasia moumo kar donjo mar laru; loye mag laru gi tonde motwegigo, gi gik moko duto mar kar lemo ma en Hemb Romo; ");
INSERT INTO luo_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","gi lewni mochwe mag tij dolo mitiyogo e kama ler mar lemo ma gin lewni mag Harun jadolo kod lep yawuote ka gitiyogo kaka jodolo. ");
INSERT INTO luo_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Jo-Israel nosetimo tije duto mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa ne onono tijno mi oneno ni negisetimo mana kaka Jehova Nyasaye nochiko. Omiyo Musa nogwedhogi. ");
INSERT INTO luo_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Chiel laru mar Hemb Romo, ma en Hemb Lemo maler chiengʼ mokwongo mar dwe mokwongo. ");
INSERT INTO luo_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ket Sandug Muma e iye kendo igengʼe gi pasia. ");
INSERT INTO luo_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Kel mesa kendo ichanie gik moko duto monego bedi e wiye. Bangʼe ikel rachungi taya kendo imok teynige. ");
INSERT INTO luo_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ket kendo mar misango miwangʼoe ubani molos gi dhahabu e nyim Sandug Muma kendo iket pasia e dhood Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ket kendo mar misango miwangʼo pep e nyim dhood hekalu mar Hemb Romo; ");
INSERT INTO luo_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","bende ket karaya e kind Hemb Romo gi kendo mar misango mi iolie pi. ");
INSERT INTO luo_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Bangʼe chielne laru alwora pasia bangʼe ilier pasia moro mondo ogengʼ dhoranga laru. ");
INSERT INTO luo_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Kaw mor pwodhruok mondo ipwodhgo Hemb Romo kod gik moko duto mantie; iwale kod gigene duto kendo obiro bedo maler. ");
INSERT INTO luo_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Eka iwir kendo mar misango miwangʼo pep kod gik moko duto mitiyogo e kendono, iwal kendo mar misangono to obiro bedo maler. ");
INSERT INTO luo_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Wir karaya kod rachungine kendo iwalgi. ");
INSERT INTO luo_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Kel Harun kod yawuote e dho Hemb Romo kendo ilwokgi gi pi. ");
INSERT INTO luo_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Bangʼe rwak Harun gi lepe maler mag dolo, wire kendo wale mondo otina kaka jadolo. ");
INSERT INTO luo_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Kel yawuote kendo irwaknegi kandho moro ka moro. ");
INSERT INTO luo_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Wirgi mana kaka ne iwiro wuon-gi mondo mi gitina kaka jodolo. Wir margi biro miyo gibedo jodolo maga kuom tiengegi duto manyaka chiengʼ ");
INSERT INTO luo_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Omiyo Musa notimo gik moko duto mana kaka ne Jehova Nyasaye ochike. ");
INSERT INTO luo_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Kuom mano Hemb Romo nochungi chiengʼ mokwongo mar dwe mokwongo e higa mar ariyo. ");
INSERT INTO luo_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Kane Musa ochungo Hema noketo rachungi kargi morwako bepe kendo ochungo sirni. ");
INSERT INTO luo_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Eka noyaro hema ewi Hemb Romo mi oketo raum e wiye kaka Jehova Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Nokawo Kite mag Rapar moketo ei Sanduk Muma; norwako ludhe e chumbe molworore mag Sanduk eka noyieyo raum e wiye. ");
INSERT INTO luo_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Eka nokelo Sandug Muma ei Hemb Romo mogengʼe gi pasia kendo nogengʼo Sandug Muma kaka Jehova Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Noketo rachungi taya ei Hemb Romo kochomo yo nyandwat mar oko mar laru, ");
INSERT INTO luo_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","kendo noketo makati miketo e nyim Jehova Nyasaye kaka Jehova Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Noketo rachungi taya ei Hemb Romo komanyore gi mesa man yo milambo mar Hemb Romo ");
INSERT INTO luo_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","kendo noketo teyni kuome e nyim Jehova Nyasaye mana kaka Jehova Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Musa noketo kendo mar misango molos gi dhahabu ei Hemb Romo e nyim pasia ");
INSERT INTO luo_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","mi nowangʼo ubani madum mangʼwe ngʼar kaka Jehova Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Eka noketo pasia e dho Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Noketo kendo mar misango miwangʼo pep machiegni gi dhood Hemb Romo mi nochiwoe misengni miwangʼo gi chiwo mag cham kaka Jehova Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Noketo karaya mar logo e kind Hemb Romo gi kendo mar misango mi noolo pi e iye. ");
INSERT INTO luo_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Kendo Musa gi Harun kod yawuote notiyo kode kaluoko lwetegi gi tiendegi. ");
INSERT INTO luo_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Sa moro amora mane gidonjo e Hemb Romo kata kane gidhi machiegni gi kendo mar misango to ne gilwoko lwetgi gi tiendegi mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Eka Musa nochungo laru molworo Hemb Romo kod kendo mar misango mi noketo pasia e dhoranga laru. Omiyo Musa notieko tich. ");
INSERT INTO luo_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Eka bor polo noumo Hemb Romo kendo duongʼ mar Jehova Nyasaye nopongʼo Hemb Romono. ");
INSERT INTO luo_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa ne ok nyal donjo ei Hemb Romo nikech bor polo ne nitie kendo duongʼ mar Jehova Nyasaye nopongʼo kar lemo. ");
INSERT INTO luo_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","E wuodhe duto mag jo-Israel, e kinde moro amora ma bor polo ne oa ewi Hemb Romo negichako wuoth, ");
INSERT INTO luo_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","to ka bor polo ne ok otingʼore malo ne ok gichak wuoth nyaka chop odiechiengʼ motingʼore. ");
INSERT INTO luo_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kuom mano bor polo mar Jehova Nyasaye ne nitie ewi Hemb Romo godiechiengʼ, to mach ne nitie ei bor polono gotieno e nyim jo-Israel duto e wuodhegi.");
INSERT INTO luo_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Eka Jehova Nyasaye noluongo Musa mowuoyo kode gie Hemb Romo. Nowachone niya, ");
INSERT INTO luo_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Wachne nyithind Israel kiwacho kama: Ka ngʼato kuomu kelo chiwo ne Jehova Nyasaye, to onego okel chiwo mag chiayo kaka dhok kata rombe. ");
INSERT INTO luo_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ka chiwo en misango miwangʼo pep mar dhiangʼ, to nyaka obed mana mano madichwo maonge songa. Nyaka to ochiwe e dho Hemb Romo mondo omi Jehova Nyasaye oyie kode. ");
INSERT INTO luo_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Nyaka oket lwete ewi misango miwangʼo pep, mi Jehova Nyasaye noyie gi misangono mondo obed gima opwodhgo richone. ");
INSERT INTO luo_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Kendo enoyangʼ nyarwath e nyim Jehova Nyasaye, eka yawuot Harun ma bende gin jodolo nokel remo, kendo ginikir remo molworo kendo mar misango kendo mochomore gi dho Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Eka noyangʼ rwadhno kaka misango miwangʼo pep kendo enopoge matindo tindo. ");
INSERT INTO luo_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Eka yawuot Harun jadolo nomok mach e kendo mar misango, kendo ginichan yien ewi mach. ");
INSERT INTO luo_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Bangʼe yawuot Harun ma jodolo nochan lemo duto kaka wich gi boche ewi yien manie mach mar kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Enoluoki jamb-ich gi tiendene gi pi, kendo jadolo nowangʼ-gi duto ewi kendo mar misango. En misango miwangʼo pep, madungʼ tik mangʼwe ngʼar ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","To ka chiwono en misango miwangʼo pep nowuogi kuom jamni kata kuom rombe kata diek, to nyaka ochiw mano madichwo maonge songa. ");
INSERT INTO luo_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Kendo mondo onege e bath kendo mar misango yo nyandwat nyim Jehova Nyasaye, eka jodolo magin yawuot Harun nokir rembgi ewi kendo mar misango bathe koni gi koni. ");
INSERT INTO luo_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Kendo nongʼade matindo tindo, eka jadolo nochan-gi ewi yien manie wi kendo mar misango wich kod boche. ");
INSERT INTO luo_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","To noluok jamb-ich gi tiendene kod pi, eka jadolo nokelgi duto mi nowangʼ-gi ewi kendo mar misango. En misango miwangʼo pep, madungʼ tik mangʼwe ngʼar e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","To ka misango miwangʼo pep michiwone Jehova Nyasaye gin mana winy, to koro nyaka okel mana akuch odugla kata nyathi akuru. ");
INSERT INTO luo_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Jadolo nokele e kendo mar misango, kendo nochod wiye, eka owangʼe ewi kendo mar misango, kendo rembe nobii michwer e bath kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Enogol oswakone gi gik moko manie i oswakone mowitgi oko e bath kendo mar misango, yo wuok chiengʼ kama otimo buru. ");
INSERT INTO luo_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Eka enobare gi e bwombe, to ok nopoge chuth, kendo bangʼe jadolo nowangʼe ewi kendo mar misango, kokete ewi yien manie mach. Ma en misango miwangʼo pep, ma en misango miwangʼo gi mach, madungʼ tik mangʼwe ngʼar ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Ka ngʼato okelone Jehova Nyasaye chiwo mar cham, to nyaka obed mogo mayom. Onego ool mo kuom mogono kendo ochwo ubani kuome, ");
INSERT INTO luo_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","eka otere ne yawuot Harun ma jodolo. Jadolo nokaw mogo mayom moru gi sanja achiel kaachiel gi ubani duto kendo nowangʼe kaka pok mar rapar ewi kendo mar misango, ma en misango miwangʼo pep, madum tik mangʼwe ngʼar ne ma Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Cham mar misango mane odongʼ koro nobedi mar Harun gi yawuote, ma en gima ler moloyo kuom misengini mag Jehova Nyasaye miwangʼo gi mach. ");
INSERT INTO luo_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Ka ikelo chiwo mar cham motedie kendo, nyaka obed kek molosi gi mogo mayom ma ok oketie thowi modwal gi mo kata chapat mowir gi mo. ");
INSERT INTO luo_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","To ka chiwo mari mar cham en gima otedi e tawo, to enobedi mogo mayom ma ok oketie thowi, kendo moru gi mo. ");
INSERT INTO luo_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Poge matindo tindo, ol mo kuome, nikech en misango mar cham. ");
INSERT INTO luo_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","To ka chiwo mari mar cham en gima otedi e tawo, inilose gi mogo mayom kod mo. ");
INSERT INTO luo_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Kel misango mar cham molos gi gigi ne Jehova Nyasaye, kele ne jadolo, mabiro chiwe e kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Enopog moko kaka pok mar rapar kendo chiw moko e kendo mar misango kaka misango miwangʼo pep madum tik mangʼwe ngʼar ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","To gima nodongʼ kuom chiwo mari mar cham nobed mar Harun gi yawuote, en gima ler moloyo nikech ogole kuom misango miwangʼo gi mach ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Misengini duto mag cham ma uchiwo ni Jehova Nyasaye nyaka bed ma ok oketie thowi, nimar misango ma uwangʼo gi mach ni Jehova Nyasaye kik ketie mor kich kata thowi. ");
INSERT INTO luo_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","To gigo unyalo chiwo ni Jehova Nyasaye kaka misango mar cham mokwongo, makmana kik uwangʼ-gi e kendo mar misango kaka iwangʼo misango madum tik mangʼwe ngʼar. ");
INSERT INTO luo_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","To chiwo duto mag cham mondo ituonie chumbi. Kik iwe mak ituone chumbi e misengini magi duto mag mogo kaka nisingori ni Nyasachi; mano emomiyo chumbi nyaka tuonie misengini duto mutimo. ");
INSERT INTO luo_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ka ukelone Jehova Nyasaye misango mar cham kod cham mokwongo nyak, to nyaka uchiw wiye cham manyien mobul e mach kendo moyoki. ");
INSERT INTO luo_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Keturu mo gi ubani nikech en misango mar cham. ");
INSERT INTO luo_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Jadolo nokaw cham moko mondo oru gi mo kendo enowangʼ-gi kaachiel gi ubani kaka rapar, nikech en misango miwangʼo ni Jehova Nyasaye gi mach. ");
INSERT INTO luo_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","To ka ngʼato ochiwo ne Jehova Nyasaye misango mar lalruok mogolo e kweth jambe bed ni en rwath kata roya to nyaka obed maonge songa. ");
INSERT INTO luo_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ngʼatno nyaka ket lwete ewi misango mar dherno, kendo oyangʼe e dho Hemb Romo. Eka jodolo ma yawuot Harun nokaw remo, kendo ginikire e bathe kendo mar misango koni gi koni. ");
INSERT INTO luo_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Koa kuom chiwo mar lalruok nyaka otimne Jehova Nyasaye misango miwangʼo gi mach ma gin: boche moimo jamb-ich, gi kuonde machiegni kode, ");
INSERT INTO luo_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","gi nyiroke kaachiel gi boche mogawogi man but oguro, kod jwala mabor man ewi chuny nogol oko kaachiel gi nyiroke. ");
INSERT INTO luo_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Eka yawuot Harun nowangʼ-gi e kendo mar misango koketgi ewi misango miwangʼo pep man e yien moket e mach mondo obed misango miwangʼo madum tik mangʼwe ngʼar ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Ka ngʼato ochiwo chiayo mondo otim-go misango mar lalruok ni Jehova Nyasaye, to nyaka ochiw chiayo madhako kata madichwo maonge songa. ");
INSERT INTO luo_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","To ka ochiwo nyarombo, to nyaka ochiwe e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Eka nyaka oket lwete ewi chiayono kendo oyangʼe e dho Hemb Romo. Yawuot Harun nokaw remo, kendo ginikire e bethe kendo mar misango koni gi koni. ");
INSERT INTO luo_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Koa kuom chiwo mar lalruok nyaka timne Jehova Nyasaye misango miwangʼo gi mach ma gin: bochene gi sembe duto mogol koa e lumbru gi bor moumo jamb-ich kaachiel gi boche man kuom jamb-ich, ");
INSERT INTO luo_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","gi nyiroke ariyo kod bor man kuomgi man but oguche kod jwala mabor manie wi chuny nogol oko kaachiel gi nyiroke. ");
INSERT INTO luo_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Jadolo nowangʼ gigi duto ewi kendo mar misango kaka chiemo, ma en chiwo miwangʼo pep ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ka chiwo mare en diel, to nyaka ochiwe e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Eka nyaka oket lwete ewi chiayono kendo oyangʼe e dho Hemb Romo. Yawuot Harun nokaw remo, kendo ginikire e bethe kendo mar misango koni gi koni. ");
INSERT INTO luo_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Koa kuom chiwo mar lalruok nyaka tim ne Jehova Nyasaye misango miwangʼo pep ma gin: boche moimo jamb-ich gi kuonde machiegni kode, ");
INSERT INTO luo_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","gi nyiroke kaachiel gi boche mogawogi man but oguro, kod jwala mabor man ewi chuny nogol oko kaachiel gi nyiroke. ");
INSERT INTO luo_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Jadolo nowangʼ gigi duto ewi kendo mar misango kaka chiemo, ma en chiwo miwangʼo pep ne Jehova Nyasaye kendo madum tik mangʼwe ngʼar. Boche duto gin mag Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Mano nobed chik mochwere ne tienge duto mabiro e kamoro amora manudagie; kendo kik ucham bor kata remo. ");
INSERT INTO luo_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Wachne jo-Israel ni, ‘Magi e chike mabiro mako ngʼato ka odonjo e richo ka ok ongʼeyo kendo otimo gima chik Jehova Nyasaye okwero: ");
INSERT INTO luo_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Ka jadolo mowal oketho mi omiyo joga obedo mogak, to ochune ni nyaka ochiw ni Jehova Nyasaye nyarwath maonge songa kendo otim-go misango mar golo richo, ne richo mosetimono. ");
INSERT INTO luo_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","To nyaka ochiw rwadhno e dho Hemb Romo e nyim Jehova Nyasaye. Kendo oyie lwete e wiye mi oyangʼe e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Eka jadolo mowal nokaw remb rwadhno moko, mi nokele e Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Kendo enolut lwete ei remono, mi okir moko nyadibiriyo e nyim pasia mar kama ler mar lemo mar Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Bangʼ mano jadolono nomien remo moko e tunge kendo mar misango miwangʼoe ubani e nyim Jehova Nyasaye manie Hemb Romo. To remb rwadhno modongʼ nopuki e tiend kendo mitimoe misango miwangʼo pep manie dho Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","To boche duto mogol kuom rwath mochiw kaka misango mar golo richo noket tenge gi boche moumo jamb-ich kod boche mamoko molwore, ");
INSERT INTO luo_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","kaachiel gi nyiroke gi boche mogawogi manie bath oguro kod jwala mabor manie wi chuny kod nyiroke, ");
INSERT INTO luo_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","mago duto noket tenge mana kaka iketo boche mogol kuom rwedhi mitimogo misengini mag lalruok. Eka jadolo nowangʼ-gi pep ewi kendo mar misango miwangʼo pep. ");
INSERT INTO luo_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Pien nyarwadhno gi ringe duto, kaachiel gi wiye kod tiendene, jamb-iye kod wen, ");
INSERT INTO luo_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ma tiende ni nyarwadhno duto, notingʼ kendo noter oko mar pacho kama ler ma en kama oket tenge ne puko buch kendo mar misango, kendo mondo owangʼe kanyo pep gi mach mar yien ewi pidh buruno. ");
INSERT INTO luo_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Ka oganda mar jo-Israel duto otimo richo ka ok gingʼeyo maponi gitimo gimoro ma chik Jehova Nyasaye okwero, kata obedo ni gikia, to gin joricho. ");
INSERT INTO luo_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Ka achien richono ofwenyore, to nyaka gichiw nyarwath mitimogo misango mar golo richo, kendo gikel nyarwath e nyim Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Jodong oganda mar Israel noket lwetgi ewi nyarwadhno e nyim Jehova Nyasaye kendo enoyangʼe mana kanyo. ");
INSERT INTO luo_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Jadolo mowal to nokaw remo moko mag rwadhno kendo nokel ei Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Nolut lith lwete ei remono, mi nokire nyadibiriyo e nyim pasia mar kama ler mar Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Bangʼ mano to mondo omien remo moko e tunge kendo mar misango manie nyim Jehova Nyasaye ei Hemb Romo. To remo modongʼ nopuki e tiend kendo mar misango miwangʼo pep manie dho Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Nokaw boche duto mi nowangʼ-gi ewi kendo mar misango, ");
INSERT INTO luo_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","kendo nochiw rwadhno mana kaka nochiwo rwath mitimogo misango mar golo richo. Kamano e kaka jadolo nopwodhnigi kethogi mi nowenegi. ");
INSERT INTO luo_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","“ ‘Eka enogol nyarwadhno oko mar kambi mi ochiwe kaka misango miwangʼo mana kaka mochiwo mokwongo-cha. Mano en misango mar golo richo ni oganda. ");
INSERT INTO luo_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Ka jatelo moro odonjo e richo ka ok ongʼeyo kendo otimo gima chik ma Jehova Nyasaye ma Nyasache okwero to obedo jaketho. ");
INSERT INTO luo_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","To ka onyise kit richo ma osetimo, to nyaka okel nywok maonge songa mondo otimnego misango kuom ketho chik. ");
INSERT INTO luo_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Enoket lwete ewi chiayono, kendo enoyangʼe kama itimoe misango miwangʼo pep e nyim Jehova Nyasaye. En misango mar golo richo. ");
INSERT INTO luo_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Eka jadolo nokaw remo moko mar golo richo gi lith lwete mi nomiene e tunge kendo mar misango miwangʼo pep, eka bangʼe remo duto modongʼ to nopuk e tiend kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Nowangʼ boche duto ewi kendo mar misango kaka nowangʼo mo mar misango mar lalruok. Kamano e kaka jadolo nopwodh ketho mar ngʼatno kendo nowene richone. ");
INSERT INTO luo_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Ka ngʼato moro ei oganda odonjo e richo ka ok ongʼeyo kendo otimo gima chik Jehova Nyasaye ok oyiego, to en jaketho. ");
INSERT INTO luo_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","To ka onyise kit richo ma osetimo to nyaka okel diel maonge songa mondo otimnego misango kuom ketho chik. ");
INSERT INTO luo_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Enoket lwete ewi chiayono mitimogo misango mar golo richo, kendo enoyangʼe kama itimoe misango miwangʼo pep. ");
INSERT INTO luo_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Eka jadolo nokaw remo moko gi lith lwete kendo nomiene tunge kendo mar misango miwangʼo pep, eka remo modongʼ to nopuki e tiend kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Nowangʼ boche duto ewi kendo mar misango mana kaka nowangʼo mo mar misango mar lalruok ma en tik madungʼ tik mangʼwe ngʼar ni Jehova Nyasaye. Kamano e kaka jadolo nopwodh ketho mar ngʼatno kendo nowene richone. ");
INSERT INTO luo_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘To ka ngʼato ochiwo rombo mondo otim-go misango mar golo richo, to nyaka obed mana rombo maonge songa. ");
INSERT INTO luo_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Enoket lwete ewi chiayono, kendo enoyangʼe kaka misango mar golo richo kama itimoe misango miwangʼo pep. ");
INSERT INTO luo_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Eka jadolo nokaw remo moko mar misango mar golo richo gi lith lwete kendo nomiene tunge kendo mar misango miwangʼo pep, eka remo duto modongʼ to nopukie tiend kendo mar misango miwangʼo. ");
INSERT INTO luo_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Nowangʼ boche duto kendo nowangʼ-gi ewi kendo mar misango mana kaka iwangʼo mo mar rombo mar lalruok, kendo jadolo nowangʼ bochego ewi misengini miwangʼo ni Jehova Nyasaye gi mach. Kamano e kaka jadolo nopwodh ketho mar ngʼatno kendo nowene richone. ");
INSERT INTO luo_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Ngʼato angʼata ma nokwongʼre kata ma notamre mar hulo wach moro mosewinjo kata moseneno, en bende nobed jaketho, kendo nyaka kume mi ochul. ");
INSERT INTO luo_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Kata ka ngʼato omulo gimoro makwero, bed ni en le mar bungu motho kata gik mamol motho, ka ok ongʼeyo, mi ofwenye achien, to enodok jaketho. ");
INSERT INTO luo_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Kata ka orere kuom gimoro makwero moa kuom dhano ka ok ongʼeyo, mi ofwenyo achien, to enodok jaketho. ");
INSERT INTO luo_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ka ngʼato ohedhore ma okwongʼore mar timo gimoro, maber kata marach ka ok ongʼeyo, (e wach moro ma ngʼato thoro hedhore ka kwongʼore) mi bangʼe achien ofwenyo, to enodok jaketho. ");
INSERT INTO luo_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Ka ngʼato angʼata en jaketho e achiel kuom wechegi, to nyaka ohul kaka oseketho, ");
INSERT INTO luo_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","kendo nyaka okel ni Jehova Nyasaye rombo kata diel madhako kaka misango mar golo richo kuom ketho mosetimo; bangʼe jadolo nopwodhnego kethoneno. ");
INSERT INTO luo_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘To ka ok onyal chiwo nyarombo, to nokel akuche odugla ariyo kata nyithi akuru ariyo ni Jehova Nyasaye kuom richo mosetimono. Kuom mano, akuru achiel notimnego misango mar golo richo, to machielo to notimnego misango miwangʼo pep. ");
INSERT INTO luo_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Enokelgi ne jadolo, eka jadolo nokwong ochiw winyo mar misango mar golo richo. Enomak wiye komino ngʼute, to ok nochode chuth, ");
INSERT INTO luo_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","kendo nokir remb winyono moko e kor kendo mar misango, to remo modongʼ to mondo ochwer e tiend kendono, nikech en misango mar golo richo. ");
INSERT INTO luo_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Jadolo nochiw winyo machielo modongʼ kaka misango miwangʼo pep e yo ma chik dwaro kendo mondo opwodhego kuom richo mosetimo mi nowene. ");
INSERT INTO luo_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘To ka ok onyal yudo kata mana akuche odugla ariyo kata nyithi akuru ariyo, to chunoni nyaka ochiw kilo angʼwen mar mogo mayom kaka misango mar golo richo. Kik oolie mo kata kik oketie ubani, nikech en misango mar golo richo. ");
INSERT INTO luo_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Eka enokel mogono ni jadolo eka jadolo nojuke sanja kaka rapar, mi nowangʼe e kendo mar misango ewi misengini miwangʼo gi mach ni Jehova Nyasaye. Mano en misango mar golo richo. ");
INSERT INTO luo_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Kamano e kaka jadolo notimne pwodhruok kuom richo mosetimo kendo nowene. Mana kaka chiwo mag cham, chiwo mamoko nobed mag jadolo.’ ” ");
INSERT INTO luo_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Ka ngʼato oketho mi otimo richo mar oyiem kaluwore gi chike maler mag Jehova Nyasaye, to nyaka okel ne Jehova Nyasaye im maonge songa kendo man-gi nengo kaluwore gi rapim mar shekel mar kama ler mar lemo. En misango michiwo mar pwodhruok e ketho. ");
INSERT INTO luo_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Nyaka ochul nengo mar gima ne ok ochiwo kaluwore gi chike maler, kendo bende omedi achiel kuom abich mar nengono kendo ochiwe duto ne jadolo, mabiro kawo imno kendo otimnego misango mar pwodhruok e ketho eka nowene richone. ");
INSERT INTO luo_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Ka ngʼata otimo richo kendo otimo gima okwer e chik moro amora mar Jehova Nyasaye, kata obedo ni ok ongʼeye, to en richo kendo en okwane jaketho. ");
INSERT INTO luo_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Nyaka okelne jadolo im man-gi nengo kendo maonge songa kaka misango mipwodhogo ketho. Kamano jadolo nopwodhe kuom ketho mosetimo kokia kendo nowene. ");
INSERT INTO luo_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","En misango mar pwodhruok e ketho; nikech osetimo marach e nyim Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Ka ngʼato otimo richo kendo ok obedo ja-ratiro e nyim Jehova Nyasaye ka owuondo nyawadgi kuom gima osingne kata gima owene mondo oriti kata gima okwal, ");
INSERT INTO luo_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","kata ka okwanyo gima olal bangʼe oriambo kendo oriyo dhoge, kata ka otimo richo ma ngʼato angʼata nyalo timo; ");
INSERT INTO luo_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","kuom mano ka otimo richo kendo odoko jaketho, to nyaka odwok gima osekwalo kata mochamo malangʼ, kata gima ne osingne, kata gima ne okwanyo molal, ");
INSERT INTO luo_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","kata gimoro amora mane okwongʼoree gi miriambo. Nyaka ochul gigo duto mi omedie achiel kuom abich mar nengogi kendo mondo ochiwgi duto ne wuon-gi chiengʼ mochiwoe misango mipwodhego e kethoneno. ");
INSERT INTO luo_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Bende nyaka okel ni jadolo misango mar pwodhruok e richo ni Jehova Nyasaye im maonge songa ma nengone oromo timo misango mipwodhego e kethoneno. ");
INSERT INTO luo_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Mano e kaka jadolo notimnego misango mipwodhogo kethoneno e nyim Jehova Nyasaye, kendo enowene kuom ketho duto ma osetimo, mane omiyo obedo jaricho.” ");
INSERT INTO luo_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Mi Harun gi yawuote chikni: ‘Magi e chike mag misango miwangʼo pep: Misango miwangʼo pep nyaka nind e kendo mar misango otieno duto nyaka okinyi, bende mach kik tho e kendo mar misangono. ");
INSERT INTO luo_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Eka jadolo norwak lepe mayom mag dolo ma oko gi maiye, kendo nojow buru mar misango miwangʼo pep kogolo e kendo mar misango mi oolgi oko e bath kendono. ");
INSERT INTO luo_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Eka nogol lewnigo kendo norwak mamoko, bangʼe notingʼ buru kotero oko mar kambi kama ler mar pwodhruok. ");
INSERT INTO luo_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Mach manie kendo mar misango to nyaka sik kaliel. Jadolo nyaka med yien e kendono okinyi kokinyi kendo ochanie misango miwangʼo pep eka owangʼe boche mag misengini mag lalruok. ");
INSERT INTO luo_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Mach nyaka sik kaliel e kendo mar misango ma ok tho. ");
INSERT INTO luo_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Magi e chike mag misengini mag cham: Yawuot Harun nochiwe ne Jehova Nyasaye e nyim kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Jadolo nojuk mogo mayom sanja gi mo kaachiel gi ubani mi oriwgi gi misango mar cham, kendo nowangʼ sanja ma ojukono kaka rapar e kendo mar misango mondo odungʼ tik mangʼwe ngʼar ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Harun gi yawuote nocham modongʼ, to nyaka gichame ma ok oketie thowi e kama ler mar lemo; kendo ginichame e laru mar Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Mogono ok onego ru gi thowi; nikech asemiyogigo kaka migapgi kuom misengini michiwona miwangʼo gi mach. En gima ler ka misango mar golo richo kod misango mar pwodhruok e ketho. ");
INSERT INTO luo_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Nyakwar Harun moro amora madichwo nyalo chame. Ma en migapgi mapile pile mar misengini miwangʼo ne Jehova Nyasaye gi mach kuom tiengʼ ka tiengʼ mabiro. Gimoro amora morere kuome nodok maler.’ ” ");
INSERT INTO luo_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Jehova Nyasaye nowacho kendo ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Chiwoni ema Harun gi Yawuote nokelne Jehova Nyasaye chiengʼ ma iwalogi: Mogo mayom moromo kilo angʼwen kaka chiwo mar cham mapile pile, nus mar mogono ginichiw gokinyi, to nus modongʼ ginichiw godhiambo. ");
INSERT INTO luo_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Tedeuru gi mo e tawo, eka ukele koseruwore maber, kendo chiwe kongʼinjore matindo tindo, kendo otimgo misango mar cham madungʼ tik mangʼwe ngʼar ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Wuode manokaw kare kaka jadolo mowal ema nolos misangono. Nyaka wangʼe pep nimar en migawo mapile pile mar Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kuom misango mar cham moro amora ma jadolo ogolo nyaka wangʼ pep kendo kik chamgi.” ");
INSERT INTO luo_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Nyis Harun gi yawuote kama: Magi e chike mag misango mar golo richo: Chiach misango mar golo richo nyaka yangʼ e nyim Jehova Nyasaye mana kama iyangʼoe chiach misango miwangʼo pep nikech en gima ler moloyo. ");
INSERT INTO luo_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Jadolo mochiwo misangono nyaka chame kama ler mar lemo, ma nitie e laru mar Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Gimoro amora morere e misangono nobed gima owal ni Jehova Nyasaye. Ka diponi remb misangono okirore e nanga, to nyaka lwoke e kama ler mar lemo. ");
INSERT INTO luo_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Chunoni agulu motedie ringʼo mar misango mar golo richo nyaka too; to ka aguch mula ema otedee, to nyaka rudhe maler mi bangʼe lawe gi pi. ");
INSERT INTO luo_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ngʼato angʼata madichwo ma jaodgi jodolo oyiene chamo misangono, nikech en gima ler moloyo. ");
INSERT INTO luo_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ka remb chiayo motimgo misango miwangʼo mar golo richo okel ei Hemb Romo mondo pwodhgo richo ei Kama Ler mar lemo, to misangono kik cham; nyaka wangʼe gi mach. ");
INSERT INTO luo_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Magi e chike mag misango ma ipwodhruokgo e ketho, ma en misango maler moloyo: ");
INSERT INTO luo_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Chiayo mar misango mipwodhruokgo e ketho nyaka yangʼ mana kama iyangʼoe chiayo mar misango miwangʼo pep kendo rembe nyaka kir e bethe kendo mar misango koni gi koni. ");
INSERT INTO luo_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Eka jadolo nokaw bochene duto, kaka sembe gi boche moumo jamb-ich, ");
INSERT INTO luo_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","kod nyiroke kaachiel gi boche mogawe gi man but oguro kendo inigol jwala mabor manie wi chuny kod nyiroke. ");
INSERT INTO luo_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Jadolo nochiwgi ka wangʼogi ewi kendo mar misango, mondo obed misango miwangʼo gi mach ni Jehova Nyasaye, nikech en misango mipwodhruokgo e ketho. ");
INSERT INTO luo_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ngʼato angʼata madichwo ma jaodgi jodolo oyiene chame, to nyaka chame mana e kama ler mar lemo mowal ni Jehova Nyasaye, nikech en gima ler moloyo. ");
INSERT INTO luo_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Chik achielni ema oriwo misango mar golo richo kod misango mipwodhruokgo e ketho. Misenginigo nodongʼ ni jadolo motimogi, kopwodhogo richo. ");
INSERT INTO luo_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Jadolo matimo misango miwangʼo pep ma ngʼato ochiwo nodongʼ gi pien chiayono kaka mare owuon. ");
INSERT INTO luo_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Misango duto mag cham mobul e kendo kata motedi e sufuria, kata e dakuon, nodongʼne jodolo motime; ");
INSERT INTO luo_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","makmana misengini mamoko mag cham moruw gi mo kata ma ok oruw, ema nopog maromre ne yawuot Harun duto. ");
INSERT INTO luo_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Magi e chike mag misango mar lalruok ma ngʼato nyalo chiwo ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Ka ochiwe ka gir goyo erokamano, to ochiwe kaachiel gi makati ma ok oketie thowi moted gi mo, kod chapat ma ok oketie thowi mowir gi mo, gi kek moted gi mogo mayom kendo modwal gi mo. ");
INSERT INTO luo_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Bende enokel misango mar lalruok mar goyo erokamano kaachiel gi makati moted gi thowi. ");
INSERT INTO luo_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Enokel achiel kuom moro ka moro kaka misango mochiwe ne Jehova Nyasaye, nikech en mar jadolo makiro remb misengini mag lalruok. ");
INSERT INTO luo_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ring misango mar goyo erokamano nyaka cham mana odiechiengno mochiwe ma ok oriyo nyaka okinyi. ");
INSERT INTO luo_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Ka misango motimo en mar kwongʼruok, chiwo mar hera, to misangono nyaka cham e odiechiengno mochiwe, to ka moro odongʼ to inyalo chame kinyne. ");
INSERT INTO luo_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ka ringʼo moro mar misango odongʼ nyaka chiengʼ mar adek, to nyaka wangʼe e mach. ");
INSERT INTO luo_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ka ring misango mar lalruok ocham chiengʼ mar adek, to misangono ok noyiego. Bende Nyasaye ok nokwan misangono ka gima ber, nimar en gima kwero, kendo ngʼama ochame nobed jaricho. ");
INSERT INTO luo_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Ringʼo morere e gimoro amora mogak, kik cham, to nyaka wangʼ e mach. To ringʼo mamoko modongʼ to inyalo cham gi ngʼato angʼata maler. ");
INSERT INTO luo_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","To ka ngʼat mogak ochamo ring misango mar lalruok mochiwne Jehova Nyasaye, ngʼatni nyaka ngʼad kare oko kuom ogandagi. ");
INSERT INTO luo_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ngʼato angʼata momulo gimoro mogak, bedni en dhano kata le, kata gimoro amora makwero, eka bangʼe ochamo ring misango mar lalruok mochiw ni Jehova Nyasaye, en bende nyaka ngʼad kare oko kuom ogandagi.’ ” ");
INSERT INTO luo_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Nyis jo-Israel kama: ‘Kik ucham bor moro amora mar dhok, rombe, kata diek. ");
INSERT INTO luo_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Chiayo moyud kotho kende kata ma ondiegi onego kik gicham bore to boreno inyalo tigo e yo moro amora. ");
INSERT INTO luo_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ngʼato angʼata kuomu manocham bor chiayo ma lembe moko osetimgo misango miwangʼo pep ni Jehova Nyasaye, to nyaka ngʼad kare kuom ogandane. ");
INSERT INTO luo_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ka moro amora mudakie, kik ucham remo moro amora bed ni en mar winy kata en mar le. ");
INSERT INTO luo_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ngʼato angʼata mochamo remo nyaka ngʼad kare kuom ogandane.’ ” ");
INSERT INTO luo_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Nyis jo-Israel kama: ‘Ngʼato angʼata mochiwo misango mar lalruok ne Jehova Nyasaye, nyaka kel migawo mar misango kaka chiwo mare ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Enokelne Jehova Nyasaye gi lwete owuon boche miwangʼo gi mach kaachiel gi agoke kendo enolier agokono kofwaye e nyim Jehova Nyasaye kaka misango mifwayo. ");
INSERT INTO luo_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Jadolo nowangʼ bochego e kendo mar misango, makmana ni agoko to nodongʼ ni Harun gi yawuote. ");
INSERT INTO luo_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Unuchiwne jadolo bam ma korachwich mar chiayo kaka misango mar lalruok. ");
INSERT INTO luo_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","To wuod Harun mano kir remo kendo wangʼ boche mar misango mar lalruok nyaka kaw bam korachwich kaka pokne. ");
INSERT INTO luo_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","To kuom misango mar lalruok ma jo-Israel golo, asekawo agoko miliero kendo ifwayo kod bam michiwo kaka pok kendo asemiyogi Harun jadolo kod yawuote kaka pokgi mapile pile kuom jo-Israel.’ ” ");
INSERT INTO luo_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Ma e migawo mar chiwo miwangʼo pep ne Jehova Nyasaye mane opogone Harun gi yawuote e odiechiengʼ mane owalgi mondo gitine Jehova Nyasaye kaka jodolo. ");
INSERT INTO luo_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","E odiechiengʼ mane opwodhgi, Jehova Nyasaye nochiwo chik ni jo-Israel mondo omigi ma kaka pokgi mapile ne tienge mabiro. ");
INSERT INTO luo_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Magi koro e chike mag misango miwangʼo pep, misango mar cham, misango mar golo richo, misango ma ipwodhruokgo e ketho gi misengini mitimo chiengʼ miketo jadolo e tich kaachiel gi misengini mag lalruok. ");
INSERT INTO luo_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Chikegi Jehova Nyasaye nomiyo Musa e Got Sinai, chiengʼ mane ochoko jo-Israel mondo ochiwne Jehova Nyasaye misengini mag-gi, ka gin e Thim mar Sinai. ");
INSERT INTO luo_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Kel Harun gi yawuote gi lepgi mag dolo, gi mor pwodhruok, gi rwadh misango mar golo richo gi imbe ariyo, kod odheru motingʼo makati ma ok oketie thowi, ");
INSERT INTO luo_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","kendo ichok oganda duto e dho Hemb Romo.” ");
INSERT INTO luo_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa notimo mana kaka Jehova Nyasaye nochike, kendo oganda jo-Israel duto nochokore e dho Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa nowachonegi niya, “Ma e gima Jehova Nyasaye osechiko mondo otim.” ");
INSERT INTO luo_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Eka Musa nogolo Harun gi yawuote e dier oganda mi olwokogi gi pi. ");
INSERT INTO luo_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Bangʼ mano norwako ne Harun kandho, eka notweyone okanda e nungone, kendo norwakone law mayom mar dolo miluongo ni efod, bangʼe notweyone law dolono miluongo ni efodno gi okandane motwangʼ maber. ");
INSERT INTO luo_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Norwakone law akor, moketo ombulu miluongo ni Urim gi Thumim e law akorno. ");
INSERT INTO luo_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Eka nosidhone Harun kilemba e wiye, kendo oketone san mar dhahabu mopamore, ma en osimbo maler e nyim kilemba kaka ne Jehova Nyasaye ochike. ");
INSERT INTO luo_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Eka Musa nokawo mor pwodhruok mowirogo Hema kod gik moko duto manie iye, kendo nopwodhogi. ");
INSERT INTO luo_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Nokiro mo moko ewi kendo mar misango nyadibiriyo, mowire kaachiel gi gik moko duto mitiyogo e kendono gi karaya mar luokruok gi rachungine, kendo nopwodhogi. ");
INSERT INTO luo_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Noolo mor pwodhruok moko ewi Harun, kowire kendo kopwodhe ne tich dolo. ");
INSERT INTO luo_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Bangʼe nokelo yawuot Harun morwakonegi kandho, eka otweyonigi okanda e nungogi kendo osidhonegi kilemba mana kaka Jehova Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Eka Musa nokelo rwath mane ibiro timgo misango mar golo richo, Harun kod yawuote noyie lwetgi e wiye. ");
INSERT INTO luo_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa noyangʼo rwadhno kendo rembe moko nokawo gi lith lwete momieno e tunge kendo mar misango mondo opwodhgo kendo mar misango. Remo modongʼ to ne opuko e bwo kendo mar misango. Kamano nowalo kendo mar misangono mondo opwodhego. ");
INSERT INTO luo_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Bangʼe Musa nokawo boche duto mogawo jamb-ich gi moumo chuny gi nyiroke ariyo kod boche mogawogi mi nowangʼogi e kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","To ring rwadhno gi piene kaachiel gi wen, nogolo oko mar kambi mowangʼogi duto kaka Jehova Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Eka Musa nokelo im mane ibiro timgo misango miwangʼo pep mar golo richo, kendo Harun kaachiel gi yawuote noyieyo lwetgi e wiye. ");
INSERT INTO luo_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Eka Musa noyangʼo imno, kendo nokawo remo mi okiro e bath kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ne opogo ring imno lemo ka lemo kendo nowangʼo wiye gi lemogo duto kod bochene. ");
INSERT INTO luo_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Bangʼe nolwoko jamb-ich kod tiende imno gi pi, kendo nowangʼo imno pep e kendo mar misango kaka misango miwangʼo pep, ma en misango miwangʼo gi mach ne Jehova Nyasaye kendo madungʼ tik mangʼwe ngʼar kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Bangʼ mano Musa nokelo im machielo, ma en im miwalogo jodolo ne tich kendo Harun gi yawuote noyieyo lwetgi e wiye. ");
INSERT INTO luo_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa moyangʼo imno kendo nokawo remb imno moko momieno e it Harun ma korachwich, gi lith lwete mathuon ma korachwich kod lith tiende mathuon ma korachwich. ");
INSERT INTO luo_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Eka bangʼe Musa nochungo yawuot Harun, kendo nomieno remo e itgi ma korachwich gi lith lwetgi mathuon ma korachwich kod lith tiendegi mathuon ma korachwich. Remo modongʼ to ne okiro e bath kendo mar misango moluoro. ");
INSERT INTO luo_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Nokawo boche gi boche mag sembe, kod boche duto mogawo jamb-ich gi boche moimo chuny gi nyiroke ariyo kod boche mogawogi, kaachiel gi bam ma korachwich. ");
INSERT INTO luo_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Kuom okapu mar makati ma ok oketie thowi mane ni e nyim Jehova Nyasaye, nokawo makati gi kek molos gi mo kod chapat achiel mi oketogi ewi boche kod bam ma korachwich. ");
INSERT INTO luo_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Gigi duto noketo e lwet Harun gi yawuote mondo gifwagi e nyim Jehova Nyasaye kaka misango mifwayo. ");
INSERT INTO luo_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Bangʼe Musa nokawogi e lwetgi kendo nowangʼogi kaachiel gi misango miwangʼo pep e kendo mar misango kaka misango miwalogo jodolo. En misango miwangʼo pep ne Jehova Nyasaye kendo madum tik mangʼwe ngʼar ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musa nokawo agoko mi ofwaye e nyim Jehova Nyasaye kaka misango mifwayo; ma ne pok mar misango mar im miwalogo Harun, mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Eka Musa nokawo mor pwodhruok kod remo mane nitiere e kendo mar misango mi okiro kuom Harun gi yawuote kod lepgi mag dolo. Omiyo nopwodho Harun gi yawuote kod lepgi mag dolo. ");
INSERT INTO luo_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Eka Musa nokone Harun gi yawuote niya, “Teduru ringʼono e dho Hemb Romo, kendo kanyo ema uchame gi makati manie okapu kama nitie gik mipwodhogo jodolo ne tich, mana kaka Jehova Nyasaye nochika, kawacho ni, ‘Harun gi yawuote ema nyaka cham ringʼono.’ ");
INSERT INTO luo_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ringʼo kod makati modongʼ to nyaka une ni uwangʼo. ");
INSERT INTO luo_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Kik uwuog e dho Hemb Romo kuom ndalo abiriyo, nyaka kinde ma iwalougo rum nikech walou biro kawo ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Pwodhruok ma otimore kawuononi kuomu e kaka Jehova Nyasaye nochika ni atimnu. ");
INSERT INTO luo_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Nyaka ubedi e dho Hemb Romo odiechiengʼ gotieno kuom ndalo abiriyo ka utimo gima Jehova Nyasaye dwaro, mondo kik utho nikech mano e gima Jehova Nyasaye osechika mondo awachnu.” ");
INSERT INTO luo_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Omiyo Harun gi yawuote notimo gik moko duto mane Jehova Nyasaye ochikogi gi dwond Musa. ");
INSERT INTO luo_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Chiengʼ mar aboro Musa noluongo Harun gi yawuote kaachiel gi jodong Israel. ");
INSERT INTO luo_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Nowacho ne Harun niya, “Kaw nyarwath mondo itimgo misango mar golo richo kendo ikaw im mondo itimgo misango miwangʼo pep, jamnigo nyaka bed maonge songa kendo ichiwgi e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Nyis jo-Israel kama: ‘Kawuru nywok maonge songa mondo utimgo misango mar golo richo, to nyaroya gi nyarombo mahikgi achiel kendo maonge songa mondo uchiw kaka misango miwangʼo pep. ");
INSERT INTO luo_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Kendo uchiw rwath kod im kaka misango mar lalruok kaachiel gi misango mar cham moruw gi mo e nyim Jehova Nyasaye nikech tinendeni Jehova Nyasaye nofwenyrenu.’ ” ");
INSERT INTO luo_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Negikelo gik moko duto mane Musa ochikogi e dho Hemb Romo, kendo oganda duto mar Israel nosudo mochungʼ e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Eka Musa nowachonegi niya, “Ma e gima Jehova Nyasaye osechikou mondo utim, mondo duongʼne maler ofwenyrenu.” ");
INSERT INTO luo_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musa nowacho ne Harun niya, “Sud machiegni gi kendo mar misango, kendo itim misango mar golo richo, gi misango miwangʼo pep, mondo ipwodhrigo kaachiel gi oganda; eka ichiw misango kipwodhogo oganda kaka Jehova Nyasaye osechiko.” ");
INSERT INTO luo_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Kuom mano, Harun nosudo machiegni but kendo mar misango, kendo noyangʼo nyarwath mane obiro gologo richone owuon. ");
INSERT INTO luo_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Bangʼe yawuote nokelone remo, mi onyumoe lith lwete, nomienogo tunge mag kendo mar misango, eka remo modongʼ to ne opuko e tiend kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Nokawo boche gi nyiroke kod jwala mabor manie wi chuny mag chiayo mane itimogo misango mar golo richo, kendo nowangʼogi pep ewi kendo mar misango mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","To ringʼo kod piem to ne otero oko mar kambi mowangʼogi. ");
INSERT INTO luo_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Bangʼ mano Harun noyangʼo chiayo mar misango miwangʼo pep. Yawuote nogamone remo kendo nokiro e bethe duto mag kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Eka negimiye lemo ka lemo mar chiayo mar misango miwangʼo pep kaachiel gi wich kendo owangʼogi e kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Nolwoko jamb-ich kaachiel gi tielo kendo nowangʼogi kuom misango miwangʼo pep ewi kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Eka Harun nokelo misango mane ji ochiwo. Nokawo nywok mane ibiro timgo misango mar golo richo ni oganda, noyangʼe kendo nopwodhogo richogi mana kaka notimo gi misango mokwongo. ");
INSERT INTO luo_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Bangʼ mano nokawo chiayo mar timo misango miwangʼo pep kendo nochiwe mana kaka ne chik dwaro. ");
INSERT INTO luo_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Eka nokelo misango mar cham kendo nojuko sanja mowangʼo e kendo mar misango kaachiel gi misango miwangʼo pep mar okinyi. ");
INSERT INTO luo_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Eka Harun noyangʼo rwath kod im mane itimogo misango mar lalruok ni oganda. Yawuote nogamone remo mokiro e bethe duto mag kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","To boche mag rwadhno kod imno kaka sembe, gi boche mogawo jamb-ich gi nyiroke kaachiel gi jwala mabor manie wi chuny, ");
INSERT INTO luo_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","duto negiketo ewi agoko, eka Harun nowangʼogie kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Harun noliero agoko kod bam korachwich e nyim Jehova Nyasaye kaka misango miliero kendo ifwayo mana kaka Musa nochiko. ");
INSERT INTO luo_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Eka Harun notingʼo lwete malo kochomo oganda mi nogwedhogi. Bangʼe nolor piny oa kama notimoe misengini mag golo richo gi misengini miwangʼo pep, kod misengini mag lalruok. ");
INSERT INTO luo_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Eka Musa gi Harun nodonjo e Hemb Romo, to kane giwuok oko to negigwedho ji, kendo duongʼ maler mar Jehova Nyasaye nofwenyore ni oganda duto. ");
INSERT INTO luo_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Mach nomuoch e nyim Jehova Nyasaye kendo nowangʼo misango miwangʼo pep kaachiel gi migepe mag boche manie wi kendo mar misango. Kane ji oneno gima notimoreno, negipongʼ gimor mi gipodho auma. ");
INSERT INTO luo_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadab gi Abihu ma yawuot Harun nokawo tewnigi mag mach mi giketoe mach, kendo ne gioloe ubani, kendo ne gimoko makwero e nyim Jehova Nyasaye ma chik Jehova Nyasaye ok oyie. ");
INSERT INTO luo_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Kuom mano mach nomuoch e nyim Jehova Nyasaye mowangʼogi kendo ne githo mana kanyo. ");
INSERT INTO luo_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Eka Musa nowacho ni Harun niya, “Ma e gima Jehova Nyasaye nowuoyoe kawacho kama, “ ‘Ananyis kaka an Nyasaye Maler ne jogo masudo buta, kendo nyaka miya luor e nyim ogendini duto.’ ” Wachni nomako dho Harun. ");
INSERT INTO luo_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa noluongo Mishael gi Elzafan yawuot Uziel ma en owadgi wuon Harun, mowachonegi niya, “Biuru ka mondo utingʼ ringre oweteu ugol oko mar kambi oa e dho kama ler mar lemo.” ");
INSERT INTO luo_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Kuom mano negibiro ma gitingʼogi kendo gigologi oko mar kambi kaka Musa nochiko kapod girwako lepgi mag dolo miluongo ni tunik. ");
INSERT INTO luo_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Eka Musa nowacho ne Harun kod yawuote ma Eliazar gi Ithamar niya, “Kik uwe wiu bed mogar, bende kik uyiech lepu, nono to ubiro tho kendo Jehova Nyasaye iye biro wangʼ gi ogandani duto. To wedeu kaachiel gi jo-Israel duto to nyalo ywago joma Jehova Nyasaye osetieko gi mach. ");
INSERT INTO luo_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Un to kik uwuogi ua e dho Hemb Romo, nono to ubiro tho, nikech un Jehova Nyasaye osewalou.” Omiyo negitimo mana kaka Musa nosewachonegi. ");
INSERT INTO luo_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Eka Jehova Nyasaye ne owuoyo gi Harun kowachone niya, ");
INSERT INTO luo_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","In kaachiel gi yawuoti kik umadh kongʼo kata gima mero ji e kinde ma udhi e Hemb Romo, nono to ubiro tho. Mano en chik momako nyikwau nyaka tiengʼ mabiro. ");
INSERT INTO luo_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Nyaka uket pogruok e kind gik mowal ne Jehova Nyasaye kod gik ma ok mowal, bende gik ma ok ler gi gik maler, ");
INSERT INTO luo_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","kendo nyaka ipuonj jo-Israel chike duto mane Jehova Nyasaye omiyogi koa e dho Musa. ");
INSERT INTO luo_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa nowacho ne Harun gi yawuote mane odongʼ magin Eliazar gi Ithamar niya, “Kawuru misango mar cham mane odongʼ kuom misengini mane ochiwne Jehova Nyasaye gi mago miwangʼo gi mach kendo uchame ka ok oketie thowi but kendo mar misango, nikech en gima ler moloyo, ");
INSERT INTO luo_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","kendo nyaka uchame e kama ler mar lemo nikech en pokni kaachiel gi yawuoti. Ma en pok mogol kuom misengini miwangʼo gi mach ne Jehova Nyasaye nikech kamano e kaka nochika. ");
INSERT INTO luo_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","To in kaachiel gi yawuoti gi nyigi unyalo chamo agoko mane olier mifwayo kaachiel gi bam mane ochiw e nyim Jehova Nyasaye. Chamgiuru kama owal ni Jehova Nyasaye, nimar osemiyigi in kaachiel gi nyithindo kaka pokni mar misango mar lalruok ne jo-Israel. ");
INSERT INTO luo_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Bam mane osechiw kod agoko mane oselier nyaka kel kaachiel gi boche mag misengini miwangʼo gi mach nobed misango mifwayo e nyim Jehova Nyasaye. Ma nobed pokni mapile pile in kaachiel gi nyithindi kaka Jehova Nyasaye nochiko.” ");
INSERT INTO luo_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Kane Musa openjo wach diel mane otimgo misango mar golo richo, kendo kane onyise ni ne osewangʼe, mirima nomake gi Eliazar kod Ithamar magin yawuot Harun mane odongʼ. ");
INSERT INTO luo_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Eka nopenjogi niya, “Marangʼo ne ok uchamo misango mar golo richo e kama ler mar lemo? En misango maler mane omiu mondo upwodhgo oganda kuom richogi e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Nikech remb diendno ne ok oter e Kama Ler mar lemo, mano emomiyo ne onego uchame ei hekalu kaka nachikou.” ");
INSERT INTO luo_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Harun to nodwoko Musa niya, “Kawuono yawuota osetimo ni Jehova Nyasaye misango mar golo richogi giwegi kod misango miwangʼo pep, to kata kamano to koro neye gima osetimorena! To ka dine acham misango mar golo richoni kawuono, bende dine atimo maber e nyim Jehova Nyasaye?” ");
INSERT INTO luo_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Bangʼ kane Musa osewinjo mae to ne oneno ni Harun ni kare. ");
INSERT INTO luo_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Jehova Nyasaye nowacho ni Musa gi Harun niya, ");
INSERT INTO luo_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Nyis jo-Israel niya, ‘Kuom le duto manie piny, magi ema unyalo chamo: ");
INSERT INTO luo_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Unyalo chamo kit le moro amora ma ombongʼ tiendegi opogore ariyo kendo manyamo kambula. ");
INSERT INTO luo_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Nitie moko manyamo kambula kende kata moko ma ombongʼ tiendegi kende ema opogore ariyo, mago to kik ucham. Ngamia kata obedo ni onyamo kambula kamano, to nikech ombongʼ tiende ok opogore, chik ok oyieni mondo uchame nikech ogak. ");
INSERT INTO luo_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Aidha kata obedo ni onyamo kambula to ombongʼ tiende ok opogore, kik uchame nikech ok oler. ");
INSERT INTO luo_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Apwoyo kata obedoni onyamo kambula kamano, to ombongʼ tiende ok opogore, chik ok oyienu mondo uchamgi nikech gin gik makwero. ");
INSERT INTO luo_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Kata obedo ni ombongʼ tiend anguro opogore ariyo kamano, to ok onyam kambula; chik ok oyienu mondo uchamgi nikech gin gik makwero. ");
INSERT INTO luo_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Kik ucham ring-gi kata kik umul ringregi motho. Gin gik makwero ne un. ");
INSERT INTO luo_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘To kuom gik moko duto modakie nam gi aore to unyalo chamo mana mago man kod thuokgi kod kalagakla. ");
INSERT INTO luo_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","To gik moko duto manie nam gi aore maonge gi thuokgi kata kalagakla, bed nigimol kata gin achiel kuom gik mangima modak ei pi nyaka ukwer. ");
INSERT INTO luo_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Nikech gin gik makwero, kik ucham ring-gi bende kik umul motho kendgi. ");
INSERT INTO luo_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Gimoro amora modak ei pi to gionge thuokgi kata kalagakla nyaka gibednu gik makwero. ");
INSERT INTO luo_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Winy manyaka ukwer kendo kik ucham e magi: Ongo, achuth gi olith ");
INSERT INTO luo_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","gi otenga kod kit otenga duto, ");
INSERT INTO luo_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","gi kit agak duto, ");
INSERT INTO luo_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","tula, nyatawo gi okok kod kit olith duto ");
INSERT INTO luo_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","tula matin, gi osou, gi tula maduongʼ, ");
INSERT INTO luo_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","gi tula marachar gi tula modak e thim gi mbusi, ");
INSERT INTO luo_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","gi nyamnaha gi ngʼangʼa, tula kod olik tiga. ");
INSERT INTO luo_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Kute duto mafuyo kendo mawuotho gi tiende angʼwen nobednu gik makwero. ");
INSERT INTO luo_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Kata kamano, nitiere kute moko ma unyalo chamo man-gi tiende angʼwen kod mago ma gichikorego. ");
INSERT INTO luo_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Kuom mano unyalo chamo kit bonyo, osialo gi kit onjiri kaachiel gi kit ongogo duto. ");
INSERT INTO luo_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","To gik moko duto mafuyo kod mago man-gi tiende angʼwen, nobednu gik makwero. ");
INSERT INTO luo_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Gik makamagi biro miyo ubed mogak, kendo ngʼato angʼata momulo ring chiayo motho kendeno nobed mogak nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ngʼata angʼata motingʼo ring chiayo mothono nyaka luok lepe, kendo en bende obiro bedo mogak nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Le moro amora ma ombongʼne ok obarore duto kata ma ok nyam kambula nobednu gima kwero, kendo ngʼato angʼata momulo ring-gino nobed mogak. ");
INSERT INTO luo_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","To kuom le duto mawuotho gi tiende angʼwen, mago mawuotho kanyono piny gi kokegi nobednu mogak, kendo ngʼato angʼata momulo ring-gi nobed mogak nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ngʼato angʼata motingʼo ring chiayogo motho nyaka luok lepe kendo nobed mogak nyaka odhiambo. Nikech le ma kamago gin le mogak. ");
INSERT INTO luo_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Le mogak manyaka ukwer e magi: oyieyo, oyiech gudhugudhu, ngʼech moro amora maduongʼ kata matindo, ");
INSERT INTO luo_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","gi ogwe gi kalagwena gi olele gi obongo-bongo kod ongʼongruok. ");
INSERT INTO luo_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Gigi duto nobednu makwero kendo ngʼato angʼata ma omulogi ka gisetho nobed mogak nyaka chop seche mag odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Kaponi achiel kuom legi otho kendo molwar kuom gimoro amora mwakonyorego pile, to gino koro nobed mogak, bedni en gima olos gi yien, kata en law, kata pien kata ogunia. Gino koro nyaka nyum ei pi kendo nobed mogak nyaka chop seche mag odhiambo, eka bangʼe nobed maler. ");
INSERT INTO luo_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kaachiel kuomgi olwar ei agulu, gik moko duto man ei aguluno nobed mogak, kendo nyaka uto aguluno. ");
INSERT INTO luo_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Chiemo moro amora minyalo cham moole pi moaye aguluno nobed mogak, kendo gimoro amora mimadho mowuok ei aguluno nobed mogak. ");
INSERT INTO luo_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Gimoro amora ma gima othono orere nobed mogak; ka orere kuom kendo kata kuom aguch kendo, to nyaka mukgi oko nikech gin gik mogak kendo nyaka kwan-gi kamano. ");
INSERT INTO luo_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Kata kamano soko kata yawo motingʼo pi nosik ka ler, to ngʼato angʼata momulo gimoro amora motho nobed mogak. ");
INSERT INTO luo_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kaponi achiel kuom gik mothogo olwar kuom kodhi mipidho, to kodhigo nosik ka ler, ");
INSERT INTO luo_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","to ka kodhigo gin mosebudi e pi, mi gimoro amora motho olwarie, to nobed mogak. ");
INSERT INTO luo_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Ka le moyienu chamo otho, to ngʼato angʼata momule nobed mogak nyaka chop seche mag odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ngʼato angʼata mochamo ringʼono nyaka luok lepe, kendo enobed mogak nyaka chop seche mag odhiambo. Kata ngʼato angʼata motingʼo chiayono bende nyaka luok lepe, bende nosik mogak nyaka chop seche mag odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Gimoro amora mamol kik ucham nikech gin gik makwero. ");
INSERT INTO luo_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Kik ucham gimoro amora malak gi bund-igi kata mawuotho gi tiende angʼwen kata man-gi tiende mathoth nikech gin gik makwero. ");
INSERT INTO luo_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Kik gigi mi ubed mogak. Kik gik ma kamago mi ubed mogak kata mochido. ");
INSERT INTO luo_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","An Jehova Nyasaye ma Nyasachu, kuom mano pwodhreuru kendo ubed jomaler, nikech an aler. Kik uchidru gi gimoro amora mamol kata malak e lowo. ");
INSERT INTO luo_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","An e Jehova Nyasaye mane ogolou e piny Misri mondo abed Nyasachu, kuom mano beduru maler nikech an aler. ");
INSERT INTO luo_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Magi e chike mag le gi mag winy, kod gik mangima mamol ei pi, kod mago malak ewi lowo. ");
INSERT INTO luo_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Nyaka uket pogruok e kind gik makwero kod gik ma ok kwero, kendo mondo upog gik mangima michamo kod mago ma ok cham.’ ” ");
INSERT INTO luo_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Jehova Nyasaye nowacho ne Musa kowacho niya, ");
INSERT INTO luo_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Wachne nyithind Israel kama: Ka dhako omako ich ma onywolo nyathi ma wuowi, to enobed mogak bangʼ ndalo abiriyo, machalre kaka obedo mogak e ndalone mar neno malo. ");
INSERT INTO luo_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Chiengʼ mar aboro, nyathino nyaka ter nyangu. ");
INSERT INTO luo_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Bangʼ mae to dhakono nyaka rit kuom ndalo piero adek gadek, mondo pwodhe kuom rembe. E kindeno ok oyiene mulo gimoro amora mowal ni Jehova Nyasaye, kata donjo e kama ler mar lemo, nyaka ndalone mag pwodhruok rum. ");
INSERT INTO luo_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","To ka onywolo nyathi ma nyako, to nobed mogak kuom ndalo apar gangʼwen, mana kaka obedo mogak e ndalone mar neno malo. Bangʼ mano to nyaka orit kuom ndalo piero auchiel gauchiel mondo opwodhe kuom rembe. ");
INSERT INTO luo_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘E ndalo ma pwodhruokne kuom nyathi ma wuowi kata ma nyako oserumo, to enokel nyaim ma hike achiel mitimogo misango miwangʼo pep Jehova Nyasaye, kaachiel kata nyathi akuru gi akuch odugla, mondo otimgo misango mar golo richo, kendo enochiwe ni jadolo e dho Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Eka jadolo nochiwe ni Jehova Nyasaye mondo opwodhgo dhakono, kendo dhakono nodok maler kuom rembe mosechwer. “ ‘Magi e chike momako dhako monywolo nyathi ma wuowi kata ma nyako. ");
INSERT INTO luo_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ka en dhako modhier ma ok nyal yudo nyaim, to oyiene mondo okel akuch odugla ariyo kata nyithi akuru ariyo. Achiel kuomgi notim godo misango miwangʼo pep, to machielo notimgo misango mar golo richo. Jadolo notim misenginigo, ka opwodhogo dhakono, kendo dhakono nobed maler.’ ” ");
INSERT INTO luo_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Jehova Nyasaye nowacho ne Musa gi Harun niya, ");
INSERT INTO luo_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Ka ngʼato dende okuot kata oluro kata en-gi mbala marieny e dende manyalo bedo tuo malandore mar del, nyaka kele ir Harun jadolo kata ir achiel kuom yawuote ma en jadolo. ");
INSERT INTO luo_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Jadolo nyaka non kama lit manie dende, kendo ka yier mantiere kama litno oselokore rachar kendo kama litno nenore ni odonjo ei ringʼo ahinya, to kare en tuo malandore mar del. Ka jadolo onone, to enolande ni ogak. ");
INSERT INTO luo_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ka kido mantiere e piene en rachar to ok onenre ni odonjo ei ringʼo kendo yier manie iye pok olokore rachar, to jadolo nyaka ket ngʼat man-gi tuono kar kende kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","E odiechiengʼ mar abiriyo jadolo nyaka none, bende ka oneno ni pod onge pogruok kendo pok olandore e del, to nyaka okete kar kende kuom ndalo abiriyo mamoko. ");
INSERT INTO luo_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","E odiechiengʼ mar abiriyo jadolo nyaka none kendo, to ka kama litno oserumo kendo pod ok olandore e del, to jadolo noland ni oler; en mana kama oluro. Ngʼatno nyaka luok lepe, kendo enobed maler. ");
INSERT INTO luo_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","To ka kama olurono ok olandore e dende ka bangʼ ka osedhi ir jadolo mondo olande ni oler, to nyaka onyisre e nyim jadolo kendo. ");
INSERT INTO luo_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Jadolo nyaka none, kendo ka kama olurono oselandore e del, to enolande kaka ngʼama ogak; nikech en tuo malandore. ");
INSERT INTO luo_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Ka ngʼato angʼata nigi tuo malandore mar del, to nyaka kele ir jadolo. ");
INSERT INTO luo_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Jadolo nyaka none, kendo ka nitie kido marachar kama litni mi yier man kanyo olokore marachar, kendo kanyo onogo otimo adhola, ");
INSERT INTO luo_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","to mano nyiso ni en tuo malandore mosedak mar del kendo jadolo noland ngʼatno ni ogak. Kik okete kar kende nikech osebedo mogak. ");
INSERT INTO luo_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ka tuono olandore e dende duto, kaka jadolo nene, kendo ka tuono olandore e dende duto chakre e wiye nyaka tiende, ");
INSERT INTO luo_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","to jadolo nyaka none, to ka tuono olandore e dende duto, to enowach ni ngʼatno ler. Nikech dende duto oselokore rachar, en ngʼat maler. ");
INSERT INTO luo_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","To ka dende ochako dholore, to enobed mogak. ");
INSERT INTO luo_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Ka jadolo oneno dende modholore, to nowach ni ogak. Dende modholoreno ogak; en gi tuo malandore. ");
INSERT INTO luo_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ka dipo ni dende modholoreno olokore rachar, to nyaka odhi ir jadolo. ");
INSERT INTO luo_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Jadolo nyaka none, kendo ka kuonde malit olokore rachar, to jadolo noland ni ngʼama ogakno ler; eka enobed maler. ");
INSERT INTO luo_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Ka bur omako ngʼato mi ochango, ");
INSERT INTO luo_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","kendo kama bur ne nitiereno, kido marachar mokuot kata mobokore mamarmar onenore, to nyaka odhi ir jadolo. ");
INSERT INTO luo_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Jadolo nyaka non kama burno ne nitie kendo ka onenore ni odholore ahinya kendo yier manie iye oselokore rachar, to jadolo noland ni ngʼatno ogak. En tuo malandore mar del ma osewuok kama bur ne netie. ");
INSERT INTO luo_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","To ka dipo, ni sa ma jadolo nonene oyudo kaonge yier marachar kuome, to bende ok odholore kendo oselal, to jadolo nyaka kete tenge kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ka tuono landore e del, to jadolo noland ni ngʼatno ogak; nikech en tuo malandore. ");
INSERT INTO luo_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","To ka kidono ok lokre kendo ok landre, to jadolo nowach ni oler nikech en mana mbala moa e bur. ");
INSERT INTO luo_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ka ngʼato dende kamoro owangʼ kendo kido mamarmar kata marachar owuok e adhola mar kama owangʼno, ");
INSERT INTO luo_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","to jadolo nyaka non adholano, kendo ka yier mane iye olokore rachar, kendo onenore ni odholore, to en tuo malandore mowuok kama owangʼno. Jadolo noland ni ngʼatno ogak; nikech en tuo malandore mar del. ");
INSERT INTO luo_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","To ka jadolo onone kendo onge yier marachar e adholano kendo ka ok odholore kendo oselal, eka jadolo nokete kar kende kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","E odiechiengʼ mar abiriyo jadolo nyaka non ngʼatno, to ka tuono landore e dende, to jadolo noland ni ngʼatno ogak; nikech en tuo malandore mar del. ");
INSERT INTO luo_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","To kata ka kama odholoreno ok olokore kendo ok olandore e del to oselal, en kama okuot moa kuom kama owangʼ, omiyo jadolo noland ni ngʼatno ler; nikech en mbala mowuok kama owangʼ. ");
INSERT INTO luo_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ka dichwo kata dhako nigi adhola e wiye kata e tike, ");
INSERT INTO luo_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","jadolo nyaka non adholano, to ka onenore ni odholore kendo yier manie iye ratongʼ kendo ongelore, jadolo noland ni ngʼatno ogak; nikech en kama ilni, ma en tuo malandore e wich kata e tik. ");
INSERT INTO luo_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","To ka dipo ni e sa ma jadolo nono adhola makamano, ok onenore ni odholore kendo onge yier maratengʼ kuome, eka jadolo noket ngʼama tuoni kar kende kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","E odiechiengʼ mar abiriyo jadolo nyaka non adholano, kendo ka ilni ok omedore kendo onge yier maratongʼ e iye kendo ok onenre ni odhe, ");
INSERT INTO luo_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","to nyaka liele makmana kama tuo nitiereno, kendo jadolo nyaka kete kare kende kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","E odiechiengʼ mar abiriyo jadolo nyaka non kama ilnino, kendo ka pod ok omedore kendo odholore, to jadolo nowach ni ngʼatno ler. Ngʼatno nyaka luok lepe eka nobed maler. ");
INSERT INTO luo_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","To ka kama ilnino omedore e del bangʼ ka oseland ni oler, ");
INSERT INTO luo_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","to jadolo nyaka none, kendo ka ilni omedore e del, to onge tiende mondo jadolo omany yier maratongʼ, nimar ngʼatno ogak. ");
INSERT INTO luo_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ka dipo ni e ngʼado bura mar jadolo oneno ni kanyo olokore kendo yier maratengʼ oseti kanyo, to mano nyiso ni osechango. Ngʼatno osedoko maler kendo jadolo nolande ni oler. ");
INSERT INTO luo_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Ka dichwo kata dhako nigi kido marachar e dende, ");
INSERT INTO luo_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","to jadolo nyaka non-gi, kendo ka kidogo nenore marachar ma tangʼ-tangʼ, to en kama roch mawuok e del ma ok nyal hinyo ngʼato; kendo ngʼatno ler. ");
INSERT INTO luo_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Ka yie wi ngʼato oluny duto kendo odongʼ rabondo, to oler. ");
INSERT INTO luo_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Chuny wiye oluny mi odongʼ rabondo, to oler. ");
INSERT INTO luo_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","To ka en-gi kama lit molokore mamarmar e bondone kata e thur wiye, to en tuo malandore moa e wiye kata e thur wiye. ");
INSERT INTO luo_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Jadolo nyaka none, kendo ka kama lit mokuot e wiye kata e thur wiye olokore mamarmar ka tuo del malandore, ");
INSERT INTO luo_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","to ngʼatno tuo kendo ogak. Jadolo noland ni ogak nikech kama lit manie wiye. ");
INSERT INTO luo_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Ngʼat man-gi dhoho nyaka rwak lewni moyiech, owe wiye nono, oum lend wangʼe gi piny kendo oywag kokok ni, ‘Ok aler! Ok aler!’ ");
INSERT INTO luo_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ka dipo ni pod en-gi tuono pod ogak. Nyaka odag kende; kendo odag oko mar kambi. ");
INSERT INTO luo_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Ka law moro amora opur; bed ni en mar pamba kata mar usi, ");
INSERT INTO luo_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","moro amora mochwe kata motwangʼ, pien moro amora kata gimoro amora molos gi pien ");
INSERT INTO luo_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","kendo ka lewni mopur, kata pien, kata mochwe kata mano motwangʼ, kata gir pien moro amora, mano maratiglo kata marakwaro, en pur malandore kendo nyaka nyis jadolo. ");
INSERT INTO luo_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Jadolo nyaka non kama opurno kendo oket gik mopurgo tenge kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","E odiechiengʼ mar abiriyo nyaka onone, kendo ka purno olandore e law, kata e njora mochwe kata motwangʼ, bedni itiyo kode e yo moro amora, to en pur maketho gik moko; kuom mano gima kamano ogak. ");
INSERT INTO luo_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Jadolo nyaka wangʼ lawno, kata mano mochwe kata motwangʼ kata gir pien moro amora mane osepur, nikech pur osekethe; gino nyaka wangʼ. ");
INSERT INTO luo_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“To ka diponi jadolo oneno kama opurno ka ok olandore e lawno, kata e law mochwe kata motwangʼ, kata e pien, ");
INSERT INTO luo_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","to enochiw chik mondo luok mochidono. Eka nyaka okete tenge kuom ndalo abiriyo mamoko. ");
INSERT INTO luo_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Bangʼ ka oseluok law mopurno, jadolo nyaka none, kendo kapok lawno oloko kite obedo ni pok olandore, en gima ogak. Nyaka wangʼe gi mach kata obedo ni kama opurno ni yo ka oko kata yo ka iye. ");
INSERT INTO luo_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ka sa ma jadolo onone, to oyudo ni pur oselal ka gino oselwoki, to nyaka oyiech kama opurno oko, bedni en kuom law, kata kuom pien, kata kuom usi mochwe kata law motwangʼ. ");
INSERT INTO luo_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","To ka kama opurno ochako othinyore e lawno, kata e usino mochwe kata e lawno motwangʼ, kata e pien, kolandore, kendo gima kamano mopur nyaka wangʼ e mach. ");
INSERT INTO luo_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","To ka oseluok law kata usi mochwe, kata law motwangʼ, kata pien ma chilono orumo, to nyaka chak lwoke kendo eka enobed maler.” ");
INSERT INTO luo_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Magi e chike mag gik mopur man kuom law pamba kata law kaki mochwe kata motwangʼ kata pien moro amora mondo ongʼe ni gigak kata ok gigak. ");
INSERT INTO luo_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Magi e chike marito ngʼama tuo e kinde mag nyasi mag pwodhruok kokele e nyim jadolo: ");
INSERT INTO luo_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Jadolo nodhi oko mar kambi kendo nonon ngʼatno. Ka osechango kuom tuone malandore mar del, ");
INSERT INTO luo_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","to jadolo nyaka gol chik mondo ngʼat matuono okelne winy ariyo maler mangima michamo gi yiend sida, gi usi makwar kod bad owino. ");
INSERT INTO luo_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Bangʼe jadolo biro golo chik mondo winyo achiel onegi ei agulu motingʼo pi soko. ");
INSERT INTO luo_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Eka jadolo nokaw winyo ma pod ngima gi yiend sida, gi usi makwar kod bad owino, kendo lutogi duto e remb winyo mane osenegno. ");
INSERT INTO luo_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Kendo nokir remono nyadibiriyo kuom ngʼat man-gi tuo malandoreno, kowachoni ngʼatni koro ler, eka gikone nowe winyo mangima-cha kendo dire mondo odhi e pap. ");
INSERT INTO luo_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Ngʼat ma ipwodhono nyaka luok lepe, kendo noliel yie dende duto, bangʼe nolwokre gi pi, eka nobed ngʼama opwodhore. Bangʼ mae eka oyiene mar donjo ei kambi to ok oyiene mondo onindi ei hema nyaka chop bangʼ ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Chiengʼ mar abiriyo nyaka oliel yie dende duto kaka yie wiye, gi yie tike kod yie wangʼe, kaachiel gi yie dende mamoko duto. Bangʼe nyaka olwok lepe kendo olwokre gi pi, eka koro nobed ngʼama opwodhore chuth. ");
INSERT INTO luo_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Chiengʼ mar aboro nyaka okel nyiimbe ariyo kod rombo sibini ma jo-higa achiel. Jamnigo duto nyaka bed maonge songa kendo nyaka kelgi kaachiel gi mogo mayom moromo kilo apar moru gi mo mondo timgo misango mar cham kod mo maliw moromo nus lita. ");
INSERT INTO luo_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Jadolo matimone pwodhruok nokel ngʼat mipwodhono kaachiel gi misenginine mag pwodhruok e nyim Jehova Nyasaye e dho Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Bangʼ mae Jadolo nokaw achiel kuom nyiimbego kendo nochiwe kaachiel gi mo kaka misango mipwodhruokgo e ketho bende nochiwgi e nyim Jehova Nyasaye kaka misango mifwayo. ");
INSERT INTO luo_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Enoyangʼ nyaimno e kama ler mar lemo ma bende iyangʼoe misango mar golo richo kaachiel gi misango miwangʼo pep. Mana kaka misango mar golo richo en mar jadolo, misango mar pwodhruok e ketho bende en mar jadolo nikech en gima ler moloyo. ");
INSERT INTO luo_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Jadolo nokaw remo moko kuom remo mipwodhruokgo e ketho, kendo nomien remono e dho it ma korachwich mar ngʼat mipwodhono kaachiel gi lith lwete mathuon ma korachwich, kod lith tiende mathuon ma korachwich. ");
INSERT INTO luo_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Bangʼe jadolo nokaw mo, kendo ool moko e pat lwete owuon ma koracham, ");
INSERT INTO luo_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","eka enolut lith lwete ma korachwich e mo manie pat lwete ma koracham, kendo kire nyadibiriyo e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Bangʼ mae Jadolo nokaw mo moko modongʼ e pat lwete, kendo wire e dho it ma korachwich mar ngʼat mipwodhono, gi lith lwete mathuon ma korachwich gi lith tiende mathuon ma korachwich, ewi kuonde mane omienie remb misango mar pwodhruok e ketho. ");
INSERT INTO luo_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Mo modongʼ e pat lwet jadolo, nyaka ool ewi ngʼat mipwodhono. Mano e kaka notimne pwodhruok e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Eka jadolo notim misango mar golo richo mondo otimgo pwodhruok ne ngʼat midwa pwodho kuom gakne. Bangʼ mano jadolo noyangʼ chiayo mitimogo misango miwangʼo pep, ");
INSERT INTO luo_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","kendo chiwe e kendo mar misango kaachiel gi misango mar cham mitimonego pwodhruok eka enobed maler. ");
INSERT INTO luo_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“To ka diponi ni en jachan kendo ok onyal yudo gigi, to nyaka okel nyaim kaka misango mar pwodhruok e ketho michiwo mondo pwodhego kaachiel gi mogo mayom madirom gorogoro ariyo moruw gi mo mondo timgo misango mar cham kod mo maliw moromo nus lita, ");
INSERT INTO luo_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","gi akuch odugla ariyo kata nyithi akuru ariyo kaka onyalo yudo. Winyo achiel nobed mar timo misango mar golo richo, to machielo nobed mar timo misango miwangʼo pep. ");
INSERT INTO luo_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Kochopo chiengʼ mar aboro nyaka okel gigo duto ne jadolo mondo opwodhi e nyim Jehova Nyasaye e dho Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Jadolo nokaw nyaim mar misango mipwodhruokgo e ketho kaachiel gi morno, kendo nochiwgi e nyim Jehova Nyasaye kaka misango mifwayo. ");
INSERT INTO luo_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Kendo noyangʼ nyaim mitimogo misango mar pwodhruok e ketho, mi nokaw rembe moko, kendo nomien e dho it ngʼat mipwodhono ma korachwich, kod e lith lwete mathuon ma korachwich, kendo e lith tiende mathuon ma korachwich. ");
INSERT INTO luo_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Bangʼe jadolo nool mo moko e pat lwete owuon ma koracham, ");
INSERT INTO luo_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","to mo moko to nokir nyadibiriyo e nyim Jehova Nyasaye gi lith lwete ma korachwich. ");
INSERT INTO luo_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","To mo moko manie pat lwete, nowir kuonde mane oseminie remb misango mar pwodhruok e ketho kaka dho it ma korachwich mar ngʼama ipwodhono gi lith lwete mathuon ma korachwich, kod lith tiende mathuon ma korachwich. ");
INSERT INTO luo_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Mo modongʼ e pat lwet jadolo nyaka ool ewi ngʼat mipwodhono mondo otimnego pwodhruok e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Eka jadolo nochiw akuch oduglago kata nyithi akuru, ma ngʼat mipwodhono okelo kaka misango, ");
INSERT INTO luo_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","achiel nochiw kaka misango mar golo richo, to machielo to notimgo misango miwangʼo pep, kaachiel gi misango mar cham. Kamano e kaka jadolo nopwodh ngʼatno e nyim Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Magi e chike moketi ni ngʼatno man-gi tuo malandore mar del, kendo ma ok nyal yudo chiwo mitimogo misengini mipwodhego. ");
INSERT INTO luo_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Jehova Nyasaye nowacho ni Musa gi Harun niya, ");
INSERT INTO luo_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Ka udonjo e piny Kanaan, ma amiyou kaka girkeni maru, mi akelo gimoro marach mamiyo kor ot pur, ");
INSERT INTO luo_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","to wuon odno nyaka dhi ir jadolo manyise niya, ‘Aseneno gimoro marach machalo pur e oda.’ ");
INSERT INTO luo_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Jadolo nyaka gol chik mondo gik moko duto manie odno ogol oko kapok odhi onono kama opurno mondo gimoro amora manie odno kik bed mogak. Bangʼ ma, jadolo nigi thuolo mar donjo kendo nono odno. ");
INSERT INTO luo_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Enonon kuonde ma opur e kor odno kendo ka dipo nitie kuonde mopudhore molokore ratiglo kata Rakwaro manenore nodonjo matut e kor ot, ");
INSERT INTO luo_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","to jadolo nyaka wuogi oko mar odno kendo olor odno kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Chiengʼ mar abiriyo nyaka jadolo duog manon odno. Kaponi purno olandore e kor ot, ");
INSERT INTO luo_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","to nyaka ogol chik mondo omuk kite duto ma gino osemako mi owitgi oko e tok pacho kama ok ler. ");
INSERT INTO luo_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Bangʼ mano to nyaka ogol chik mondo kor odno ochwer maler, kendo gik magisechwero opuk kama ok ler e tok pacho. ");
INSERT INTO luo_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Eka giniket kite manyien kuonde duto mane gisegoloe moko-ka, kendo gimwon odno manyien. ");
INSERT INTO luo_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“To kapo ni gima rach makelo pur ochako othinyore e odno kendo bangʼ ka kitego osegol oko mi ochwer kor odno kendo omuon, ");
INSERT INTO luo_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","to jadolo nyaka duogi mondo onon odno kendo. Kapo ni gima rach makelo purno olandore e odno, to mano nyiso ni en gima rach makelo kethruok, kuom mano odno en gima ogak. ");
INSERT INTO luo_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Koro odno nyaka muki, kendo kitene gi yiendene, kod lope duto nyaka ter e tok pacho mondo owitgi kama ok ler. ");
INSERT INTO luo_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Ngʼato angʼata manodonji e odno e kinde ma pod olore nobed ngʼama ogak nyaka chop odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","To ngʼato angʼata ma nindo e odno kata chiemo e odno, nyaka luok lepe. ");
INSERT INTO luo_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Kapo ni jadolo odhi mondo onon odno mi oyudo ni gima rach makelo purno ok oselandore bangʼ kane osemwone, to jadolo nongʼad wach ni odno ler nikech gima rach makelo purno oserumo. ");
INSERT INTO luo_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Mondo jadolo opwodh odno, nyaka okaw winy ariyo, yiend sida moko gi usi makwar kod owino. ");
INSERT INTO luo_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Nyaka oneg winyo achiel ei dapi motingʼo pi soko, ");
INSERT INTO luo_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","bangʼe okaw yiend sida gi owino gi usi makwar, kaachiel gi winyo machielo ma pod ngimacha, kendo olutgie remb winyo mosenegno, kod pi soko, eka kendo okirgie odno nyadibiriyo. ");
INSERT INTO luo_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Nyaka opwodh odno gi remb winyo, pi soko gi winyo mangima, gi yiend sida gi owino kod usi makwar. ");
INSERT INTO luo_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Eka enowe winyo mangima mondo ofu odogi e pap mar dala matin. Mae e kaka nopwodh ot kendo nobed maler.” ");
INSERT INTO luo_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Magi e chike kuom tuoche malandore mag del, kod tuoche mailo del, ");
INSERT INTO luo_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","kaachiel gi pur mamako nanga gi mamako kor ot, ");
INSERT INTO luo_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","kod kuonde mobokore e del gi kuonde moluro kata mamarmar. ");
INSERT INTO luo_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Chikno biro puonji kuom gima ler kod gima ogak. Magi e chike mag tuoche malandore e del kod mag gik mopur. ");
INSERT INTO luo_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Jehova Nyasaye nowacho ne Musa gi Harun niya, ");
INSERT INTO luo_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Wuo gi nyithind Israel kendo unyisgi kama: Ka ngʼato dende chwer bedni en nyach, remo, tutu, kata nyodo, to gik machwer kawuok e dendego ogak. ");
INSERT INTO luo_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Kata ka pod odhi nyime gichwer kata kodinore, to gino biro miyo obedo mogak. Ma e kaka gik machwergo biro miyo obedo mogak. ");
INSERT INTO luo_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Kitanda moro amora ma ngʼatni onindoe kata moro amora ma ngʼatni obetie ka dende chwer bedo mogak. ");
INSERT INTO luo_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ngʼato angʼata momulo kitandono nyaka neni olwoko lepe, kaachiel gi dende, kendo enobed mogak nyaka chop odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ngʼato angʼata mobet kama ngʼama dende chwer osebetie, nyaka luok lepe kendo luokre, kendo nosik kogak nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Ngʼato angʼata momulo ngʼato ma dende chwerno nyaka luok lepe kod dende, kendo nobed mogak nyaka chop odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Ka ngʼama dende chwer ongʼulo olawo kuom ngʼama ler, ngʼatni nyaka luok lepe kendo olwokre, kendo nobed mogak nyaka chop odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Gimoro amora ma ngʼat ma dende chwerno oidho kadhi wuoth bedo mogak, ");
INSERT INTO luo_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","kendo ngʼato angʼata momulo gima ngʼatno osebetie nobed mogak nyaka odhiambo, kendo ngʼato angʼata mokawo gigo nyaka luok lepe kendo olwokre, kendo nobed mogak nyaka chop odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Ngʼato angʼata ma ngʼama ogakni omulo kapok ologo lwete to nyaka olwok lepe kendo olwokre kendo nobed mogak nyaka chop odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Gimoro amora mochwe gi lowo nyaka to, kendo gimoro amora molos gi bao ma ngʼatno omulo nyaka luok gi pi. ");
INSERT INTO luo_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Ka ngʼato opwodhi kuom gima chwer e dende, to nyaka oketre tenge kuom ndalo abiriyo mar nyasi mar pwodhruok; mi olwok lepe kod dende kendo obiro bedo mapoth. ");
INSERT INTO luo_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","E odiechiengʼ mar aboro nyaka okaw akuch odugla ariyo kata nyithi akuru ariyo mondo okelgi e nyim Jehova Nyasaye e dho Hemb Romo kendo ochiwgi ne jadolo. ");
INSERT INTO luo_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Bangʼe jadolo biro chiwogi kaka misango, achiel kuomgi mar misango migologo richo to machielo to mar misango miwangʼo pep. E yo machalo kama obiro tero kwayo mar weyo richo e nyim Jehova Nyasaye ne ngʼatno ma dende chwer mondo opwodhe. ");
INSERT INTO luo_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Ka ngʼat madichwo kothe mar nyodo owuok, nyaka olwokre, kendo nobed mogak nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Nanga kata pien moro amora ma koth nyodono dilwarie nyaka luok gi pi, kendo nobed mogak nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ka ngʼat ma dichwo obedoe achiel gi dhako mi kodhi mar nyodo owuok e diergi, nyaka giduto giluokre, kendo ginibed mogak nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Ka dhako ni e kindene mar neno malo, to dhakono nobed mogak nyaka otiek ndalo abiriyo, kendo ngʼato angʼata momule nobed mogak nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Gimoro amora manonindie e kinde moneno malo nobed mogak, kendo gimoro amora manobedie nobed mogak. ");
INSERT INTO luo_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ngʼato angʼata momulo kitandane nyaka luok lepe, kendo olwokre, kendo en bende nobed mogak nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ngʼato angʼata manomul gima obetie, nyaka luok lepe, kendo olwokre, en bende nobed mogak nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Kata bed ni en kitanda, kata bed ni en gima nyocha obete, to ngʼato angʼata manomul gigi, en bende nobed mogak nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Dichwo moro amora mane obet e achiel gi dhakono e kinde moneno malo nobed mogak kuom ndalo abiriyo, kendo nyaka kitanda monindoe bende nobed mogak. ");
INSERT INTO luo_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Ka dhako chwer ndalo mogwarore e kinde ma ok one malo, kata ka ochwer mokadho ndalo ma ojanene malo, to enobed mogak kuom ndalo duto ma pod ochwerieno mana machalre kaka ndalone monenoe malo. ");
INSERT INTO luo_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Kitanda moro amora moninde e ndalo ma pod oneno malo nobed mogak mana kaka kitanda monindoe mapile kendo gimoro amora mobetie nobed mogak mana machal gi kinde monenoe malo. ");
INSERT INTO luo_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ngʼato angʼata momulo gigi nobed mogak, kendo nyaka olwok lepe kendo olwokre, kendo nobed mogak nyaka odhiambo. ");
INSERT INTO luo_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Ka dhakono osepwodhore kuom chwerneno, to nyaka okwan ndalo abiriyo, eka koro obiro bedo maler. ");
INSERT INTO luo_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Kochopo odiechiengʼ mar aboro to okaw akuch odugla ariyo kata nyithi akuru ariyo, kendo okelne jadolo e dho Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Jadolo biro kawo akuru achiel otimgo misango mar golo richo to machielo to otimgo misango miwangʼo pep. Kamano jadolo biro pwodho dhakono e nyim Jehova Nyasaye kuom gakne kaluwore gi dende machwerno. ");
INSERT INTO luo_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Nyaka usiem jo-Israel kuom gik mamiyo ji bedo mogak, mondo kik gidwany kar dakna maler manie kindgi, manyalo kelonegi tho ka gigak.’ ” ");
INSERT INTO luo_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Magi e chike momako dichwo ma dende chwer kata mobet mogak nikech wuok mar nyote, ");
INSERT INTO luo_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","kata dhako manie kindeno mar neno malo kaachiel gi dichwo kata dhako machwer kod dichwo moriwore gi dhako mogak. ");
INSERT INTO luo_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Jehova Nyasaye nowuoyo gi Musa bangʼ tho yawuot Harun ariyo ka gibiro e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Jehova Nyasaye nowacho ne Musa niya, “Nyis Harun owadu ni kik thor donjo e Kama Ler Moloyo manie nyim Sandug Muma miluongo ni kar ngʼwono, nono to enotho, nikech afwenyora gi e bor polo manie ewi raum. ");
INSERT INTO luo_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Ma e kaka Harun nodonj e Kama Ler Moloyo: Enokaw nyarwath mar misango mar golo richo kod im mar misango miwangʼo pep. ");
INSERT INTO luo_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Nyaka orwak kandhone mopwodhi mar dolo miluongo ni tunik gi sati maiye, bangʼe to otwe okanda kendo otwe kilemba e wiye. Magi gin lep dolo; kuom mano nyaka olwokre kapod orwakogi. ");
INSERT INTO luo_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Koa kuom oganda jo-Israel nyaka okaw nywogi ariyo kaka misango mar golo richo kod im mar misango miwangʼo pep. ");
INSERT INTO luo_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Harun nochiw rwath mondo otimgo misango mar golo richone owuon kopwodhorego kaachiel gi joode. ");
INSERT INTO luo_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Eka enokaw diek ariyo kendo ochiwgi e nyim Jehova Nyasaye e dho Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Harun nogo ombulu e kind diek ariyogo, kendo diel achiel biro bedo mar Jehova Nyasaye to machielo nobed mar bungu. ");
INSERT INTO luo_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Harun nokaw diel ma ombulu oyiero kaka mar Jehova Nyasaye, kendo otimgo misango mar golo richo. ");
INSERT INTO luo_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","To diel ma ombulu oyiero kaka diend bungu nyaka kel kangima e nyim Jehova Nyasaye mondo ti godo kaka gir pwodhruok kiweye odhi e pap kaka diend bungu. ");
INSERT INTO luo_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Harun nyaka chiw rwath mondo otimgo misango mar golo richone owuon kopwodhorego kaachiel gi joode, kendo noyangʼ rwadhno mondo obed kaka misango mar golo richone owuon. ");
INSERT INTO luo_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Enokaw tap mach moketie mach mogol e kendo mar misango manie nyim Jehova Nyasaye kaachiel gi ubani mangʼwe ngʼar madirom lwedo ariyo, kendo nokelgi kama ogengʼ gi pasia. ");
INSERT INTO luo_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Eka nool ubani mangʼwe ngʼarno e majno e nyim Jehova Nyasaye kendo ich ubanino oim raum mar Sandug Rapar mondo kik otho. ");
INSERT INTO luo_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Enokaw remb rwadhno kendo okir gi lith lwete e bath raum mar misango koma ochomo yo wuok chiengʼ kendo okir remono nyadibiriyo gi lith lwete e nyim raum mar misango. ");
INSERT INTO luo_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Nyaka oyangʼ diel mitimogo misango mar golo richo ni oganda jo-Israel, mi noter rembe ei kama ogengʼ gi pasia, kendo nokir remono ewi raum mar misango, kendo e nyim raumno bende, mana kaka nokiro remb rwadh-cha. ");
INSERT INTO luo_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Mano e kaka nopwodh Kama Ler Moloyo nikech timbe mogak kod ngʼanyo mar oganda jo-Israel, bed ni gisetimo richo moro mora. Mano bende e kaka nopwodhi Hemb Romo manie diergi kuom timbegi mogak. ");
INSERT INTO luo_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ok oyiene ngʼato angʼata bedo ei Hemb Romo chakre e kinde ma Harun odonjo ei Kama Ler Moloyo kopwodhore owuon, kopwodho joode, kopwodho nyithind Israel duto, nyaka sa ma owuokie, kosetieko tij pwodhruok duto. ");
INSERT INTO luo_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Bangʼ tieko magi to nowuogi oko mar kendo mar misango manie nyim Jehova Nyasaye, kendo nopwodh kendono. Enokaw remb rwath moko gi remb diel moko, kendo mienogi e tunge kendo duto mar misango. ");
INSERT INTO luo_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Enokir remo moko gi lith lwete nyadibiriyo e kendo mar misango kendo nopwodhe e timbe mogak mag jo-Israel mi nobed maler. ");
INSERT INTO luo_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Bangʼe ka Harun osetieko pwodho Kama Ler Moloyo gi Hemb Romo kod kendo mar misango, to nokel diel mangima. ");
INSERT INTO luo_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Harun noket lwetene duto ewi diendno mangima, kohulo richo kod ngʼanyo mar jo-Israel, tiende ni richogi duto kendo enowe richogo duto ewi diendno. Eka enomiye ngʼatno moseyier ne tijno mondo okaw diendno oter e pap. ");
INSERT INTO luo_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Diendno notingʼ kuome owuon richo mar jo-Israel nyaka kar kende kendo ngʼatno nyaka gony diendno kosechopo e thim kuno. ");
INSERT INTO luo_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Eka Harun nodonj ei Hemb Romo, kendo nolony lepe mag katana mane orwako e kinde mane odonjo e Kama Ler Moloyo kendo enowegi mana kanyo. ");
INSERT INTO luo_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Bangʼe nolwokre gi pi e kama ler mar lemo kendo norwak lepe mag dolo, eka enochiw misango miwangʼo pep mondo otimgo pwodhruok ni en owuon kod oganda jo-Israel duto. ");
INSERT INTO luo_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Bangʼ mano nowangʼ boche chiayo motimgo misango mar golo richo e kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“To ngʼat matero diend bungu e pap nyaka luok lepe kendo olwokre; eka bangʼe to onyalo donjo ei kambi. ");
INSERT INTO luo_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Rwath gi diel mane otimgo misengini mag golo richo, kendo ma rembgi noseter ei Kama Ler Moloyo mar pwodho richo, nyaka gol ring-gi gi piendegi kod wen mag-gi oko mar kambi, mondo owangʼ-gi pep. ");
INSERT INTO luo_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ngʼatno ma owangʼogi nyaka luok lepe kendo olwokre, bangʼe to onyalo donjo e kambi. ");
INSERT INTO luo_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Koro chik momakou nyaka chiengʼ ema: E odiechiengʼ mar apar mar dwe mar abiriyo higa ka higa, un nyithind Israel, kaachiel gi jopinje mamoko modak kodu, nyaka ubed gilamo mar tweyo chiemo kendo kik uti tich moro amora, ");
INSERT INTO luo_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","nikech ma en odiechiengʼ manotimnue pwodhruok mondo ubed maler, eka unubed maler kuom richou duto e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Odiechiengno en Sabato mowal manyaka ubedie gi yweyo, kulemo kendo utweyo chiemo. Mano en chik momakou nyaka chiengʼ. ");
INSERT INTO luo_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Jadolo mowir kendo mowal moketi kar wuon mare ema notimnu pwodhruokni, kendo nyaka orwak lep dolo mag katana maber, ");
INSERT INTO luo_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","kendo enopwodhi Kama Ler Moloyo kaachiel gi Hemb Romo kod kendo mar misango, eka enopwodh jodolo kaachiel gi oganda jo-Israel. ");
INSERT INTO luo_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Koro chik momakou nyaka chiengʼ ema: Pwodhruok kuom richo duto mag jo-Israel nyaka tim dichiel e higa.” Kendo notim kamano mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Jehova Nyasaye nowacho ne Musa niya: ");
INSERT INTO luo_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Wuo gi Harun gi yawuote kaachiel gi nyithind Israel duto kendo iwachnegi kama: ‘Ma e chik ma Jehova Nyasaye ochiwo ");
INSERT INTO luo_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ja-Israel moro amora motimo misango gi rwath kata nyaim, kata diel ei kambi kata oko mar kambi, ");
INSERT INTO luo_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","to ok okele e dho Hemb Romo mondo otimgo ni Jehova Nyasaye misango e nyim Hema Maler mar Jehova Nyasaye, to ngʼatno nokwan mana kaka ngʼama oneko nikech osechwero remo, omiyo nongʼad kare oko kuom ogandagi. ");
INSERT INTO luo_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Chikni oketi mondo omi jo-Israel okelne Jehova Nyasaye misengini makoro gitimo e pewe. Nyaka gikelgi ne jadolo manochiwgi e dho Hemb Romo kaka misango mar lalruok. ");
INSERT INTO luo_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Jadolo nokir remo e kendo mar misango mar Jehova Nyasaye manie dho Hemb Romo, kendo owangʼ boche madum tik mangʼwe ngʼar ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ok gichak gichiw misengini ne jochiende ma gisebedo ka gidwanyorego. Koro ma en chik momakou nyaka chiengʼ kaachiel gi tienge mabiro.’ ");
INSERT INTO luo_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Wachnegi kama: ‘Ka ja-Israel moro amora kata jadak manie diergi otimo misango miwangʼo pep, kata misango moro amora, ");
INSERT INTO luo_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","kendo ok okele e dho Hemb Romo mondo otimgo ni Jehova Nyasaye misango, to ngʼatno nyaka ngʼad kare oko kuom ogandagi. ");
INSERT INTO luo_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Ka ja-Israel moro amora kata japiny moro modak e diergi ochamo remb chiayo moro amora to anabed jasike, kendo anangʼade oko kuom ogandani. ");
INSERT INTO luo_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Nimar gima ochwe ngimane nitie e remo, omiyo asemiyougo mondo utim-go misango e kendo mar misango mondo upwodhrugo nikech remo ema itimogo misango mar pwodho ngima ngʼato. ");
INSERT INTO luo_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Kuom mano, anyiso jo-Israel kama: “Ngʼato angʼata kuomgi kik cham remo kendo jodak manie dieru bende kik cham remo.” ");
INSERT INTO luo_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Ja-Israel moro amora kata jadak manie dieru modhi dwar, momako le kata winyo mondo ocham, nyaka ol rembe piny mi oik kod lowo, ");
INSERT INTO luo_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","nikech gik mangima duto ngimagi ni e rembgi. Mano emomiyo asewacho ne jo-Israel niya, “Kik ucham remb gimoro amora, nikech gima ochwe ngimane ni e rembe, kendo ngʼato angʼata mochame nongʼad kare oko.” ");
INSERT INTO luo_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Ngʼato angʼata ma ja-Israel kata jadak manie dieru mochamo gima otho kende, kata mondiek onego nyaka luok lepe kende olwokre, kendo nobed mogak nyaka odhiambo, eka bangʼe nobed maler. ");
INSERT INTO luo_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","To ka ok olwoko lepe kendo ok olwokore, to nyaka oyud kum kuom kethone.’ ” ");
INSERT INTO luo_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Jehova Nyasaye nowacho ne Musa niya: ");
INSERT INTO luo_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Wuo gi jo-Israel kendo iwachnegi ni, ‘An e Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Kik utim timbe ma jo-Misri mane udak e diergi timo kendo kik timbe moko mag jo-Kanaan makoro aterou e diergi yudre kuomu. Bende kik uluw timbe ma gitimo. ");
INSERT INTO luo_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Nyaka urit chikena kendo luwuru yorena, nikech an Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Rituru yorena kod chikena, nimar ngʼat moluwogi nobed mangima kuomgi. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Kik ngʼato terre gi dhako moluongo ni watne. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Kik ikuod wi wuonu kuom terruok gi chiege, nikech en minu. ");
INSERT INTO luo_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Kik iterri gi chi wuonu, nikech kitimo kamano to ikelone wuonu wichkuot. ");
INSERT INTO luo_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Kik iterri gi nyaminu mahie, kata nyameru maka wuonu machielo kata maka minu machielo, bedni onywole e dala kae, kata kamoro machielo. ");
INSERT INTO luo_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Kik iterri gi nyakwari maka wuodi kata maka nyari, nikech kitimo kamano to ikelo wichkuot ni in iwuon. ");
INSERT INTO luo_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Kik iterri gi nyaminu moa e ot machielo, nikech en nyaminu. ");
INSERT INTO luo_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Kik iterri gi nyamin wuonu nikech en wayu. ");
INSERT INTO luo_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Kik iterri gi nyamin mamau nikech en bende en mamau. ");
INSERT INTO luo_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Kik igomb terori gi chi owadgi wuonu nikech en minu, kendo mano kelo wichkuot ne wuonuno. ");
INSERT INTO luo_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Kik iterri gi chi wuodi nikech en maru, ok oyieni mondo itim kamano. ");
INSERT INTO luo_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Kik iterri gi chi owadu nikech mano nyalo kelo wichkuot ne owaduno. ");
INSERT INTO luo_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Kik iterri gi nyako kaachiel gi min-gi. Kik iterri gi nyakware ma ka wuode kata maka nyare, nikech gin wede dhakono. Mano en tim anjawo. ");
INSERT INTO luo_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Kik ikend nyamin chiegi mondo obed nyieke ma iriwri kode ka nyamin pod ngima. ");
INSERT INTO luo_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Kik iterri gi dhako manie kindene mar neno malo. ");
INSERT INTO luo_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Kik iterri gi chi ngʼama udakgo mokiewo, dipo ka omiyo ibedo mogak. ");
INSERT INTO luo_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Kik ichiw nyathini moro amora ni nyasaye manono miluongo ni Molek, nimar ok onego iketh nying Nyasaye. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Kik iterri gi dichwo wadu nikech mano en tim makwero. ");
INSERT INTO luo_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Kik iterri gi chiayo nikech mano miyo ibedo mogak. Dhako bende kik yie mondo chiayo oterre kode, nikech mano en gima kwero. ");
INSERT INTO luo_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Kik udwanyru kutimo timbe ma kamago nikech timbego ema ogendini mabiro riembo e nyimu ne timo. ");
INSERT INTO luo_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Kata mana piny bende nobedo mogak, omiyo ne akumogi nikech richo mag-gi, kendo piny nongʼogo joma nodakie iye. ");
INSERT INTO luo_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","To nyaka urit yorena kod chikena. Onge ngʼato kuomu manotim timbe makwerogo kata obed ja-Israel kata jadak e dieru, ");
INSERT INTO luo_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","nikech magi e timbe ma joma nodak e pinyni kapok ubiro notimo kendo negiketho pinyni. ");
INSERT INTO luo_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","To ka udwanyo pinyno, to ngʼeuru ni onyalo ngʼogou oko mar oganda mane okwongonu dake kane gidwanye. ");
INSERT INTO luo_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Jogo duto matim makwerogo noyud e ngimagi, ginto nyaka golgi oko ei ogandagi. ");
INSERT INTO luo_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Emomiyo luwuru chikena kendo ritreuru ma kik uluw timbe makwero mane joma odak e pinyni otimo kapok ubiro, mondo kik ubed mogak. An e Jehova Nyasaye ma Nyasachu.’ ” ");
INSERT INTO luo_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Wuo gi kanyakla mar Israel duto kendo inyisgi ni: ‘Beduru maler nikech an Jehova Nyasaye ma Nyasachu aler. ");
INSERT INTO luo_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Ngʼato ka ngʼato kuomu nyaka luor min gi wuon kendo nyaka urit Sabato maga. An e Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Kik uluw bangʼ nyiseche manono, kendo kik ubed gi nyiseche mothedhi mag nyinyo. An e Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Ka uchiwo misango mar lalruok ne Jehova Nyasaye, to timeuru e yo mowinjore ma Jehova Nyasaye oyiego. ");
INSERT INTO luo_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Misangono ibiro chame e odiechiengno muchiwee kata kinyne, to ringʼo mane odongʼ nyaka chiengʼ mar adek nyaka wangʼ e mach. ");
INSERT INTO luo_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ka lemo moro amora kuom ringʼoni ocham chiengʼ mar adek, to Jehova Nyasaye ok noyie kodu nikech en gima kwero. ");
INSERT INTO luo_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ngʼato angʼata manocham ringʼono nokwan ka jaketho nikech osedwanyo kama ler mar Jehova Nyasaye, kendo ngʼatno nyaka ngʼad kare oko kuom ogandane. ");
INSERT INTO luo_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Ka ukayo cham manie puotheu, to kik ugol cham duto nyaka manie giko puodho, kata kik uhul nyaka cham modongʼ. ");
INSERT INTO luo_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Kupono olembeu mag mzabibu, to kik upon-gi duto, bende mago molwar piny kik ukwany. Mago weuru ni joma odhier kod jodak manie dieru. An e Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Kik ikwal. “ ‘Kik iriambi. “ ‘Kik iwuond nyawadu. ");
INSERT INTO luo_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Kik ikwongʼri gi miriambo ni ngʼato gi nyinga nimar kitimo kamano to ichayo Jehova Nyasaye ma Nyasachu. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Kik ima wadu e yor wuond kata kik imaye gire. “ ‘Kik itamri chulo ngʼato kuom tich motiyoni kendo nyaka ichule mana godiechiengno. ");
INSERT INTO luo_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Kik ikwongʼ ngʼama ite odino, kata kik iket gimoro e nyim muofu monyalo chwanyoree, luoruru Nyasachu. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Kik iketh buch ngʼato, to ngʼad bura kare ma kik idogne jachan kata luoro wangʼ ngʼama duongʼ, to ngʼadne wadu bura makare kichungʼ e adiera. ");
INSERT INTO luo_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Kik iketh nying jowadu koni gi koni e yor kuoth, kendo kik ihangne jowadu wach ma ok nikare. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Kik ibwon owadu gi chunyi. Nyis wadu kethone e wangʼe, mondo kik iriwri kode e richone. ");
INSERT INTO luo_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Kik idwar chulo kuor, kendo kik ibed ngʼama mon gi jowadgi, to her wadu kaka iherori iwuon. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Rituru yorena. “ ‘Kik uwe jamni mopogore opogore luwre ma nywol nyithindo. “ ‘Kik uriw kodhi e puodho achiel, kendo kik urwak nanga motwangʼ gi usi ariyo mopogore opogore. ");
INSERT INTO luo_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Ka ngʼato oterore gi misumba ma nyako mapok okendi mosewinjore gi ngʼama onego kende, kata mapok omi thuolo mar dhi, to wachno nyaka none maber. Kik neg nyakono gi ngʼat moterore kodeno nikech pod en misumba. ");
INSERT INTO luo_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ngʼat motimo kode tim makamanono nyaka kel im e nyim Jehova Nyasaye e dho Hemb Romo mondo timgo misango mar pwodhruok e ketho. ");
INSERT INTO luo_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Jadolo notim misango mar golo richo e nyim Jehova Nyasaye gi imno kuom pwodho ngʼatno e kethone, eka richo mosetimo nowene. ");
INSERT INTO luo_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Ka udonjo e pinyno kendo upidho kit yiend olemo moro amora to ukwan olembene ka gik makwero. Kuom higni adek kik umul olembego kendo kik uchamgi. ");
INSERT INTO luo_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","E higa mar angʼwen to olembege duto nobed maler, ma en chiwo mar pak ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","To e higa mar abich, unyalo chamo olembege. Kuom mano keyo magu nomedre. An e Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Kik ucham ringʼo motimo remo. “ ‘Kik ukor wach kata kik ubed ajuoke mag nyakalondo. ");
INSERT INTO luo_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Kik utit yie wiu kata kik utit yie tiku. ");
INSERT INTO luo_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Kik usar dendu kuywago ngʼama otho, kendo kik usar kido moro amora e dendu. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Kik utime timbe manyalo miyo nyiu bed jochode, nikech mano nyalo kethonu piny makel richo mangʼeny. ");
INSERT INTO luo_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Rituru Sabato maga kendo kama ler mar lemo mara nyaka umi luor mowinjore. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Kik udhi upenj wach kuom jo-nyakalondo kata kuom ajuoke mamoko, nikech timo kamano biro miyo ubedo mogak. An e Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Nyaka ichiw luor kichungone jaduongʼ ma wiye oti lwar kendo uluor Nyasachu. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Ka japiny moro odak e dieru, to kik usande. ");
INSERT INTO luo_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Japiny moro modak e dieruno nyaka udag kode mana kaka wuodu. Hereuru mana kaka uheroru uwegi nikech ne un jodak e piny Misri. An Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Kik uti gi rapim ma ok nikare ka upimo bor kata pek mar gimoro kata kupimo ngʼeny mare. ");
INSERT INTO luo_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Tiuru gi rapim ma ok riambi kendo mapimo gimoro makare. An e Jehova Nyasaye ma Nyasachu mane ogolou e piny Misri. ");
INSERT INTO luo_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Rituru yorena duto kod chikena kendo uluwgi. An e Jehova Nyasaye.’ ” ");
INSERT INTO luo_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Jehova Nyasaye nowacho ne Musa niya ");
INSERT INTO luo_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Nyis jo-Israel ni: Ja-Israel moro amora kata jadak moro amora manie dieru manochiw nyathine moro amora ni nyiseche manono miluongo ni Molek, nyaka negi. Oganda jo-Israel duto mondo ogoye gi kite nyaka otho. ");
INSERT INTO luo_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Anabed jasik ngʼatno kendo anangʼad nyinge oko kuom ogandane; kuom chiwo nyathine ni nyasaye manono miluongo ni Molek, osedwanyo kama ler mar lemo, kendo osechayo nyinga maler. ");
INSERT INTO luo_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","To kapo ni oganda jo-Israel ok odewo wach ngʼat mochiwo achiel kuom nyithinde ne Molek, ma ok ginege, ");
INSERT INTO luo_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","to an awuon ema nabed jasik ngʼatno gi dhoodgi duto. Kargi anangʼad oko kuom ogandagi, kaachiel gi jogo duto maluwe kendo madwanyore kalamo Molek. ");
INSERT INTO luo_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Anabed jasik ngʼama oweya modhi odwanyore gi jo-nyakalondo kod lang chunje maricho; kendo anangʼad kare oko kuom ogandagi. ");
INSERT INTO luo_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Pwodhreuru ubed maler nikech An e Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Rituru buchena kendo uluwgi, nimar An e Jehova Nyasaye mapwodhou. ");
INSERT INTO luo_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ngʼato angʼata mokwongʼo wuon kata min, nyaka negi; nikech timneno; rembe nodongʼ e wiye owuon. ");
INSERT INTO luo_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Ka ngʼato oterore gi chi wadgi ma gidakgo, to jochode ariyogo nyaka neg-gi duto. ");
INSERT INTO luo_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ka ngʼato oterore gi chi wuon mare, to oseelo dug wuon-gi. Ji ariyogi nyaka neg-gi kendo rembgi nobedi e wigi giwegi. ");
INSERT INTO luo_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ka ngʼato oterore gi chi wuode to giduto nyaka neg-gi. Gima gitimono en tim makwero to rembgi nobedi e wigi giwegi. ");
INSERT INTO luo_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ka dichwo oterore gi dichwo wadgi. Giduto ji ariyogi gitimo gima kwero kendo giduto nyaka neg-gi to rembgi nobedi e wigi giwegi. ");
INSERT INTO luo_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Ka ngʼato okendo nyako kaachiel gi min-gi bende okendo, to ma en anjawo. Kargi ji adekgo nyaka wangʼ-gi kod mach, mondo tim marach kik dongʼ e dieru. ");
INSERT INTO luo_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Ka ngʼato oterore gi chiayo, ngʼatni nyaka nege, to chiayono bende nyaka negi. ");
INSERT INTO luo_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ka dhako osudo machiegni gi chiayo mondo oterre kode, giduto nyaka neg-gi kendo rembgi obed e wigi giwegi. ");
INSERT INTO luo_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Ka ngʼato okendo nyamin mare ma nyar wuon kata ma nyar min, ma giterore kode, to otimo gima kwero. Nyaka neg-gi ka ji duto neno nikech oterore gi nyamin, koro nyaka oyud kum. ");
INSERT INTO luo_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Ka ngʼato oterore gi dhako manie dwe, mano okuodo wi dhakono, nikech oele nyaka kama rembe wuokie, dhakono bende oseyie moel nyaka kama rembe wuokie. Giduto nyaka riembgi gia e dier ogandagi. ");
INSERT INTO luo_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Ok oyieni mondo iterri gi nyamin mamau, nikech mano en tim maketho wat. Joma timo timbegi nyaka migi kum. ");
INSERT INTO luo_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Ka ngʼato oterore gi nyamin wuon, ngʼatni okuodo wi wuon mareno, omiyo nyaka giyud kum, kendo mondo oneg-gi ma nying-gi lal chuth e dier ogandagi. ");
INSERT INTO luo_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ka ngʼato oterore gi chi owadgi, to mano en dwanyruok nikech oelo dug owadgi, kendo ok giniyud nyithindo. ");
INSERT INTO luo_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Un nyaka koro urit chikena gi buchena kendo umak-gi, mi uluwgi duto, eka piny mamiyou mondo udagieno ok nongʼogu oko. ");
INSERT INTO luo_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Kik uluw timbe oganda mudak e diergi madhi riembonu oko-gi. Nikech gigi mane gitimo nomiyo aol kodgi. ");
INSERT INTO luo_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Kendo ne awachonegi niya, “Abiro kawo pinygi kendo abiro miyougo kaka girkeni, ma en piny mopongʼ gi chak kod mor kich.” An e Jehova Nyasaye ma Nyasachu mosepogou gi ogendini mamoko. ");
INSERT INTO luo_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Nyaka uket pogruok e kind le michamo gi ma ok cham, kendo e kind winy michamo to gi ma ok cham. Kik udok mogak nikech le moro amora kata winyo kata gimoro amora mamol e lowo ma gin gik masewalo tenge nochido. ");
INSERT INTO luo_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Nyaka ubed maler e nyima nikech an Jehova Nyasaye aler, kendo asewalou e kind ogendini mondo ubed joga awuon. ");
INSERT INTO luo_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Ngʼato angʼata kuomu madichwo kata madhako ma en ajuok nyakalondo kata ma ajwoga moro amora, to ugo gi kite nyaka otho. Giduto nyaka ugogi gi kite kendo rembgi nobedi e wigi giwegi. ");
INSERT INTO luo_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Jehova Nyasaye nowacho ne Musa niya, “Wuo kod jodolo ma yawuot Harun, kendo iwachnegi ni: ‘Kik jadolo tim gimoro ne ringre jadhodgi moro amora motho ma dimi obed mogak, ");
INSERT INTO luo_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","makmana kaponi ngʼat ma othoni en watne manie ot kaka min kata wuon kata wuode kata nyare kata owadgi, ");
INSERT INTO luo_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","kata nyamin-gi manie lwete mapok okendi. Nyamin-gi mapok okendino kende ema nyalo miyo obed mogak. ");
INSERT INTO luo_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Kik obed mogak kuom mulo ringre joma otho ma gin wedene kuom kend. ");
INSERT INTO luo_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Jodolo ok oyienegi mondo giliel wigi, kata tito yie tikgi bende kik gisar dendgi. ");
INSERT INTO luo_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Nyaka gibed jomaler e nyim Nyasachgi, kendo kik gicha nying Nyasachgi. Nikech gin ema gichiwo misengini miwangʼo e mach ni Jehova Nyasaye, ma en chiemb Nyasachgi, omiyo nyaka gibed maler. ");
INSERT INTO luo_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Jodolo ok oyienegi kendo nyako mochot kata nyako mosewere gi chwore, nikech jodolo nyaka bed maler e nyim Nyasachgi. ");
INSERT INTO luo_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Kwan-giuru kaka jomaler, nikech gin ema gichiwo chiemo ni Nyasachu. Kawgiuru kaka jomaler nikech an Jehova Nyasaye aler; an mamiyo ubedo maler. ");
INSERT INTO luo_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Ka nyar jadolo olokore ochot, to nyakoni okuodo wi wuon-gi, omiyo nyaka wangʼe gi mach. ");
INSERT INTO luo_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Jadolo maduongʼ e kind owetene, kendo moseol mor pwodhruok e wiye, kendo owal mondo orwak lep dolo, kik owe wiye obed mogar, kata kik orwak law moyiech. ");
INSERT INTO luo_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Jadolono ok oyiene donjo e ot ma ngʼato othoe. Kik obed mogak kata bedni ngʼatno en wuon mare kata min mare, ");
INSERT INTO luo_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","kata kik owuogi koa kama ler mar lemo mar Nyasache, kata miyo kanyo bedo mogak, nikech en ngʼama owal kendo owir gi mor pwodhruok mar Nyasache. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Nyako mokendo nyaka bed nyako ngili. ");
INSERT INTO luo_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Kik okend dhako ma chwore otho, kata dhako mowere gi chwore, kata dhako mochot, makmana nyako ngili, ");
INSERT INTO luo_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","mondo omi kik onywol nyithindo mogak e kind ogandane. An e Jehova Nyasaye mamiyo obedo maler.’ ” ");
INSERT INTO luo_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Nyis Harun ni: ‘Kuom tiengeu duto, onge ngʼama ongʼol ma oyiene mondo ochiw chiemo ni Nyasache. ");
INSERT INTO luo_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ngʼato angʼata man-gi songa kik sud machiegni gi Nyasaye, obed ni en muofu kata rangʼol, kata ma dende kamoro otimo mbala, ");
INSERT INTO luo_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","kata ka tiende kata bade ongʼol, ");
INSERT INTO luo_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","kata ka en rakuom kata othwogo, kata ka en rachiero, kata ka wangʼe chwero pi, kata ka en gi adhola monyaa kata ka en bwoch. ");
INSERT INTO luo_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Nyakwar Harun moro amora man-gi songa kik sud machiegni mar timo ne Jehova Nyasaye misango miwangʼo. Nikech en gi songa ok onego osud machiegni mondo ochiw chiemo ne Nyasache. ");
INSERT INTO luo_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Onyalo chamo chiemb Nyasache, bedni ogol chiemono kuom gik maler kata kuom gik maler moloyo; ");
INSERT INTO luo_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","to nikech ngʼol mare ok onego osud machiegni gi Pasia kata gi kendo mar misango, nikech dipo ka omiyo kara maler mar lemo obedo mogak nimar en gi songa. An e Jehova Nyasaye mapwodhogi.’ ” ");
INSERT INTO luo_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Kuom mano Musa nonyiso Harun gi yawuote kod jo-Israel duto wachno. ");
INSERT INTO luo_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Nyis Harun gi yawuote ni nyaka giritre ahinya ka gitiyo gi mich maler ma nyithind Israel kelona mar chiwo, nono to dipo ka gichayo nyinga. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Wachnegi ni: Ka ngʼato moro mogak osudo machiegni kod kama jo-Israel chiwoe chiwo maler ni Jehova Nyasaye, to nangʼad kare oko kendo ok nobed gimoro e nyima. Mano en chik manyaka uriti chakre sani kod tiengʼ mabiro. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Koth Harun moro amora matuo mar dhoho nogore kuome kata man-gi tuo machwer, ok onego cham chiemo mowal mochiwne Jehova Nyasaye kapok opwodhe. Enobed ngʼama ogak ka omulo gima orere kuom ngʼama otho kata orere kuom ngʼama kothe mar dichwo owuok, ");
INSERT INTO luo_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","kata ka omulo gimoro mamol manyalo miyo obed mogak, kata ngʼato angʼata mamiyo obedo mogak, bedni ogak manade. ");
INSERT INTO luo_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ngʼato angʼata momulo gik mogakgo nobed mogak nyaka chiengʼ podhi. Ok onego ocham chiemo mowal moro amora motimgo misango nyaka chop olwokre. ");
INSERT INTO luo_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Bangʼ podho chiengʼ, ngʼatno nobed maler, kendo bangʼ mano oyiene mondo ocham chiwogo nikech en chiembe. ");
INSERT INTO luo_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ok oyiene mondo ocham chiayo moro amora motho kende, kata ma ondiek onego, nikech timo kamano biro miyo obedo mogak. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Jodolo to nyaka rit chikena mondo kik gibed joketho mi githo kuom richono. An e Jehova Nyasaye mapwodhogi. ");
INSERT INTO luo_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Ngʼato angʼata ma ok oaye oganda jadolo kik cham chiwo maler, kata bedni en wendo molimo jadolo, kata obed jatich jadolo ma ondiko kaka jotich. ");
INSERT INTO luo_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","To ka jadolo ongʼiewo jatich kod pesa to oyiene chiemo kaachiel gi wasumbini monywol e dalane. ");
INSERT INTO luo_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ka ngʼat ma ok jadolo okendo nyar jadolo, nyakoni ok oyiene mondo ocham mich moyiedhi mogol kuom chiwo maler. ");
INSERT INTO luo_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","To ka nyar jadolo chwore otho, kata ka owere gi chwore kapok onywol mi odok dalagi mondo odag kanyo ka nyako mapok okendi, to oyiene chamo chiemb wuon mare. Makmana ni ngʼat ma ok jadolo, to kik cham chiemono. ");
INSERT INTO luo_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Ngʼato angʼata manyalo ponono kochamo chiemo mowal kokia ni en gima ochiw ni Jehova Nyasaye, to nyaka ochul jadolo ka omedo gi achiel kuom abich mar nengo mar gima ochamo cha. ");
INSERT INTO luo_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Jodolo nyaka tangʼ mondo kik giketh chiwo maler ma jo-Israel osewalo ni Jehova Nyasaye, ");
INSERT INTO luo_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ka gichiwo thuolo ni joma gingʼeyo ni ok jodolo chamo chiemo mowalgo, nikech mano miyo jogo bedo joketho kendo gidonjo e kum mowinjore gi chudo. An Jehova Nyasaye mapwodhogi.’ ” ");
INSERT INTO luo_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Jehova Nyasaye nowacho ni Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Nyis Harun gi yawuote kod jo-Israel duto kiwachonegi ni: ‘Ka ngʼato moro amora kuomu, bed ni en ja-Israel kata jadak manie dieru okelo misango miwangʼo pep ni Jehova Nyasaye, bedni en mar chopo singo kata chiwo mar hera, ");
INSERT INTO luo_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","to nyaka ichiw chiayo maonge songa, obedni en rwath, kata diel kata rombo, eka Jehova Nyasaye noyiego. ");
INSERT INTO luo_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Kik uchiw chiayo man-gi songa nikech Jehova Nyasaye ok bi yie kode. ");
INSERT INTO luo_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ka ngʼato okelone Jehova Nyasaye misango mar lalruok mar dhiangʼ kata rombo mondo ochopgo singruokne, kata obed ni en chiwo mar hera, to nyaka obed chiayo maler maonge songa eka Jehova Nyasaye noyie kode. ");
INSERT INTO luo_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kik ichiwne Jehova Nyasaye chiayo ma muofu, ma rangʼol kata man-gi songa, kata man-gi kalanga, kata motimo aluny kata man-gi adhola machwer. Chiayo makamagi kik ket ewi kendo mar misango mondo obed misango miwangʼo pep gi mach ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","To kuom chiwo mar hera unyalo chiwo rwath kata rombo man-gi songa, to chiwogi ok noyiego kuom timo misango mar singruok. ");
INSERT INTO luo_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Kik ichiwne Jehova Nyasaye chiayo mopwodi kata moroo. Kik utim tim maka ma e pinyu, ");
INSERT INTO luo_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","kendo kik uyie kawo chiayo machal kamano kuom jadak manie pinyu mondo uchiwe ni Nyasachu ka chiembe. Jehova Nyasaye ok bi yie kodgi nikech gin-gi songa kendo gingʼol.’ ” ");
INSERT INTO luo_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Jehova Nyasaye nowacho ni Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Ka onywol nyarombo, nyaroya kata nyadiel, to kik upoge gi min mare nyaka bangʼ ndalo abiriyo. Kochiwe ne Jehova Nyasaye bangʼ ndalo aboro kaka misango miwangʼo gi mach to Jehova Nyasaye noyie kode. ");
INSERT INTO luo_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Kik uneg dhiangʼ gi nyathine, kata rombo gi nyathine odiechiengʼ achiel. ");
INSERT INTO luo_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Ka uchiwo misango mar goyo erokamano ni Jehova Nyasaye, to chiweuru kaka chik dwaro eka Jehova Nyasaye noyie kodu. ");
INSERT INTO luo_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Nyaka chame duto maonge modongʼ mana godiechiengno. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Rituru chikena kendo uluwgi maber. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Kik udwany nyinga maler. An kenda ema jo-Israel nyaka miya luor kaka ngʼama ler. An e Jehova Nyasaye mapwodhogi, ");
INSERT INTO luo_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","kendo manogolou e piny Misri mondo abed Nyasachu. An e Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Wuo gi jo-Israel kendo inyisgi ni: ‘Magi e sewni moyier mag Jehova Nyasaye, magin chokruok mage maler, ma onego ulandi kuonde duto ma uchokorue. ");
INSERT INTO luo_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Nitie ndalo auchiel munyalo tiyoe tijeu; to chiengʼ mar abiriyo en odiechieng Sabato mar yweyo, ma en odiechiengʼ mowal mar chokruok. Ok oyienu timo gimoro amora, kamoro amora mudakie, nikech en Sabato mar Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Magi e sewni moyier mag Jehova Nyasaye, ma gin chokruok maler, manyaka ulandi e kindegi mowinjore. ");
INSERT INTO luo_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Pasaka mar Jehova Nyasaye chakore godhiambo tarik apar gangʼwen mar dwe mokwongo. ");
INSERT INTO luo_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","To tarik apar gabich mar dweno en Sap Makati ma ok oketie Thowi mar Jehova Nyasaye kendo nyaka ucham makati motedi ma ok oketie thowi kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Chiengʼ mokwongo mar jumano nyaka ubed gi chokruok mowal, kendo kik uti tich moro amora ma utiyo pile. ");
INSERT INTO luo_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Kuom ndalo abiriyo, chiwuru ne Jehova Nyasaye misengini miwangʼo pep. Chiengʼ mar abiriyo beduru gi chokruok mar jomaler, kendo kik uti tich moro amora ma utiyo pile.’ ” ");
INSERT INTO luo_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Wuo gi jo-Israel kendo inyisgi ni: ‘Ka uchopo e piny ma asesingonu mi ukayo cham, to nyaka ukelne jadolo cham ma ukwongo kayo. ");
INSERT INTO luo_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","E odiechiengʼ mokwongo bangʼ Sabato, jadolo biro fwayo e nyim Jehova Nyasaye cham mukwongo kayo kaka mich moyiedhi, eka Jehova Nyasaye noyie kodu. ");
INSERT INTO luo_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","To chiengʼono muchiewoe cham mifwayo to nyaka uchiwe ne Jehova Nyasaye gi nyaim ma pod hike achiel kendo maonge songa mondo timgo misango miwangʼo pep, ");
INSERT INTO luo_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","kaachiel gi misango mar cham gi mogo mayom madirom kilo abiriyo moruw gi mo. Kendo misangono mondo owangʼe modungʼ tik mangʼwe ngʼar ni Jehova Nyasaye. Misango miolo piny to obed divai maromo lita achiel. ");
INSERT INTO luo_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Kik ucham makati, kata makati mowangʼ kata cham manyien ma pod numu, kapok ochopo chiengʼ ma uchiwone Nyasachu michni. Kendo mae en chik momakou kaachiel gi nyikwau nyaka chiengʼ kamoro amora manudagie. ");
INSERT INTO luo_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Chakre odiechiengʼ moluwo Sabato, mane ukeloe mich mar cham moyiedhi, to nyaka ukwan ma une ni oromo jumbe abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Kwanuru ndalo piero abich bangʼ Sabato mar abiriyo, kendo chiengʼno unutim misango ni Jehova Nyasaye gi cham manyien. ");
INSERT INTO luo_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Keluru makati ariyo mugolo e miechu kaka misango mifwayo, kendo ulosgi gi mogo mayom moromo kilo abiriyo moketie thowi, mondo uchiwgi ne Jehova Nyasaye kaka chiwo mar cham mokwongo. ");
INSERT INTO luo_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Kaachiel gi makatino chiwne Jehova Nyasaye nyirombe abiriyo machwo maonge songa mahikgi en achiel, gi nyarwath matin kod imbe ariyo. Ginibed misango miwangʼo pep ni Jehova Nyasaye kaachiel gi misango mar cham gi misango miolo piny mondo obed misango miwangʼo pep madungʼ tik mangʼwe ngʼar ni Jehova. ");
INSERT INTO luo_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Bangʼe chiw nywok achiel mitimogo misango mar golo richo, kaachiel gi nyiimbe ariyo ma jo-higa achiel mitimogo misango mar lalruok. ");
INSERT INTO luo_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Jadolo nyaka chiw nyiimbe ariyogo e nyim Jehova Nyasaye kaka misango mifwayo, kaachiel gi makati mag cham mokwongo. Magi nobed mich mowal michiwo e nyim Jehova Nyasaye, kendo ginidongʼ ni jadolo. ");
INSERT INTO luo_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","To odiechiengʼno unugo tungʼ kulando chokruok maler, kendo kik uti tijeu mapile. Maeni en chik momakou kaachiel gi nyikwau kamoro amora manudagie. ");
INSERT INTO luo_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Ka ukeyo e puotheu, to kik uka nyaka cham manie giko puodho, kata kik uhul cham modongʼ, mago weuru ni joma odhier kod jodak. An e Jehova Nyasaye ma Nyasachu.’ ” ");
INSERT INTO luo_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Wach ni jo-Israel ni: ‘E odiechiengʼ mokwongo mar dwe mar abiriyo, nyaka ubed gi odiechieng yweyo; ma en odiechieng chokruok mowal kaka rapar kugoyo turumbete. ");
INSERT INTO luo_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Chiengʼni kik utim tijeu mapile, to chiwuru misango miwangʼo pep ni Jehova Nyasaye.’ ” ");
INSERT INTO luo_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“E odiechiengʼ mar apar mar dwe mar abiriyo nobednu Chiengʼ Pwodhruok. Beduru gi chokruok maler ka uriyo kech, kendo uchiw ni Jehova Nyasaye misango miwangʼo pep. ");
INSERT INTO luo_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Odiechiengʼno kik ngʼato kuomu mul tich moro amora nikech en Chiengʼ Pwodhruok, migolonue richo e nyim Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ngʼato angʼata ma ok nyal riyo kech odiechiengʼno to nongʼad kare oko chuth e kind ogandane. ");
INSERT INTO luo_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Kendo anatiek ngʼato angʼata momulo tich moro amora chiengʼno, kendo anagole e kind ogandane. ");
INSERT INTO luo_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Kik umul tich moro amora. Ma en chik ma omakou nyaka nyikwau duto kamoro amora ma unudagie. ");
INSERT INTO luo_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Chiengʼno nobednu Sabato mar yweyo, kendo nyaka une ni uriyo kech. Chakre odhiambo mar odiechiengʼ mar ochiko mar dwe nyaka kinyne godhiambo, nyaka urit Sabato maru.” ");
INSERT INTO luo_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Wach ni jo-Israel ni: ‘Chakre tarik apar gabich e dwe mar abiriyo en Sawo mar Kiche mar Jehova Nyasaye kendo nobedi kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Odiechiengʼ mokwongo nobed chokruok maler ma kik uti tijeu mapile. ");
INSERT INTO luo_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Kuom ndalo abiriyo chiwuru ni Jehova Nyasaye misengini miwangʼo pep, eka chiengʼ mar aboro to ubedi gi chokruok maler kendo chiengʼno uchiwni Jehova Nyasaye misango miwangʼo pep. En chokruok mitiekogo nyasi, omiyo kik uti tijeu mapile. ");
INSERT INTO luo_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘Magi e sewni moyier mag Jehova Nyasaye manyaka ulandi ni gin e chokruok maler michiwone Jehova Nyasaye gi mach kaka misengini miwangʼo pep, gi misengini mag cham gi misengini miolo piny kendo moro ka moro nigi odiechienge mowinjore. ");
INSERT INTO luo_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","To ewi mago nitie Sabato mag Jehova Nyasaye gi chiwo mamoko to gi gimoro amora misesingori kaachiel gi chiwo mar hera michiwo ni Jehova Nyasaye.) ");
INSERT INTO luo_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Omiyo kochakore e odiechiengʼ mar apar gabich mar dwe mar abiriyo bangʼ keyo to nyaka utim Sap Jehova Nyasaye kuom ndalo abiriyo. Chiengʼ mokwongo en odiechiengʼ mowal mar yweyo, kendo chiengʼ mar aboro bende en kamano. ");
INSERT INTO luo_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Chiengʼ mokwongo kawuru olembe yien mabeyo gi bede othidhe, gi bede yien motimo otiep, gi omburi, kendo ubed mamor e nyim Jehova Nyasaye ma Nyasachu kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Timuru sawoni ni Jehova Nyasaye kuom ndalo abiriyo higa ka higa. Mae en chik momakou gi nyikwau nyaka chiengʼ. Paruru ni kochopo dwe mar abiriyo to nyaka ubed gi sawoni. ");
INSERT INTO luo_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Un jo-Israel nyaka udagi e kiche kuom ndalo abiriyo, ");
INSERT INTO luo_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","mae ema biro miyo nyikwau nopar kaka namiyo jo-Israel odak e kiche kinde mane agologi e piny Misri. An e Jehova Nyasaye ma Nyasachu.’ ” ");
INSERT INTO luo_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Kamano e kaka Musa nolando ni jo-Israel sewni moyier mag Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Chik jo-Israel mondo gikelni mo maliw mar zeituni mobi mondo omi teyni osik kaliel pile. ");
INSERT INTO luo_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Harun nyaka ne ni teynigo osiko kaliel oko mar pasia moumo Sandug Muma mar Hemb Romo manie nyim Jehova Nyasaye chakre odhiambo nyaka okinyi. Ma en chik mosiko nyaka chiengʼ ne tienge duto mabiro. ");
INSERT INTO luo_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Teyni manie rachung taya maler molos gi dhahabu nyaka rit pile ka pile e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Kawuru mogo mayom kendo utedgo makati apar gariyo, ma moro ka moro oted gi mogo moromo kilo abiriyo. ");
INSERT INTO luo_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Chan uru makatigi laini ariyo e mesa maler molos gi dhahabu mochungʼ e nyim Jehova Nyasaye kendo e laini ka laini obed gi auchiel. ");
INSERT INTO luo_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","To e laini ka laini mondo ukete ubani maler, mondo obed kaka rapar mar makati ma ichiwo ni Jehova Nyasaye kaka misango miwangʼo pep. ");
INSERT INTO luo_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Makatini nyaka kete e nyim Jehova Nyasaye pile ka pile chiengʼ Sabato ka chiengʼ Sabato. Gin mich ma ichiwo e lo jo-Israel kaka singruok manyaka chiengʼ. ");
INSERT INTO luo_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Makatigo mondo odongʼ ni Harun gi yawuote, kendo nyaka gichamgi kama ler mar lemo, nikech en migawo mar pok maler moloyo ma gichiwo kinde ka kinde kaka misengini miwangʼo ni Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Wuowi moro ma min mare ja-Israel to wuon mare ja-Misri nowuok e dier jo-Israel kendo dhawo nowuok e kambi e kinde gi ja-Israel moro. ");
INSERT INTO luo_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Wuod dhako ma ja-Israel noyanyo Nying Jehova Nyasaye mi ojare; omiyo negikele e nyim Musa. (Min-gi ne nyinge Shelomith, nyar Dibri mane oa e dhood Dan.) ");
INSERT INTO luo_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Negikete e od twech ka girito gima Jehova Nyasaye biro nyisogi. ");
INSERT INTO luo_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Gol ngʼat moseyanyano oko mar kambi. Ji duto mane nitie koyenyo mondo giket lwetgi e wiye kendo kanyakla mar jo-Israel duto okaw kite ochielego.” ");
INSERT INTO luo_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Wachne jo-Israel niya, Ka ngʼato okwongʼo Nyasache, to oyud kum moromo gi kethono, ");
INSERT INTO luo_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","to ngʼato angʼata moyanyo nying Jehova Nyasaye nyaka negi. Oganda duto nyaka chiele gi kite, bed ni en ja-Israel kata jadak, to koseyanyo nying Jehova Nyasaye to nyaka nege. ");
INSERT INTO luo_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Ngʼato angʼata monego wadgi, en bende nyaka nege. ");
INSERT INTO luo_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Ngʼato angʼata monego chiayo nyaka chul chiayo, to ngʼato angʼata monego nyawadgi nyaka negi. ");
INSERT INTO luo_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ngʼato angʼata mohinyo wadgi, nyaka timne gima otimono. ");
INSERT INTO luo_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Lero kar lero, wangʼ kar wangʼ, lak kar lak. Nyaka hiny ngʼatno mana kaka osehinyo nyawadgi. ");
INSERT INTO luo_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ngʼato angʼata monego chiayo nyaka chul chiayo, to ngʼato angʼata monego nyawadgi nyaka negi. ");
INSERT INTO luo_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Kaka ikumo jadak e kaka ikumo ja-Israel. An e Jehova Nyasaye ma Nyasachu.’ ” ");
INSERT INTO luo_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Eka Musa nowuoyo gi jo-Israel mi gigolo ngʼat mane oyenyocha oko mar kambi kendo negichiele gi kite. Jo-Israel notimo mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Jehova Nyasaye nowacho ne Musa ewi Got Sinai niya, ");
INSERT INTO luo_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Wuo gi jo-Israel kendo inyisgi ni: Ka gichopo e piny mabiro miyogi, to pinyno nyaka rit Sabato mar Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Kuom higni auchiel oyienu pidho cham e puotheu, gi loso tiend yiendeu mag mzabibu kendo oyienu kayo chambu kendo pono olembeu. ");
INSERT INTO luo_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","To kochopo higa mar abiriyo to puodho nyaka yud yweyo mar Sabato, ma en Sabato mar Jehova Nyasaye. E higano lowo nyaka yud yweyo ma kik upidh gimoro amora e puotheu mag cham gi mag mzabibu. ");
INSERT INTO luo_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","E higano kik uka orowe kata kik upon mzabibu monyak kendgi e yien mane ok uloso, nikech en higa ma piny yweyoe. ");
INSERT INTO luo_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","To gimoro amora ma piny nochiegnu e hik Sabato nobed mar chiembu, chiemb jotichu machwo gi mamon kaachiel gi jotichu mamoko, kod welo molimou kuma udakie kuom ndalo machwok, ");
INSERT INTO luo_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","kendo nobed mar jambu gi le manie pinyu. Gimoro amora ma piny ochiego inyalo cham. ");
INSERT INTO luo_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Waluru Sabato abiriyo mag higni abiriyo nyadibiriyo, tiendeni higni piero angʼwen gochiko. ");
INSERT INTO luo_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Eka gouru turumbete kamoro amora e odiechiengʼ mar apar mar dwe mar abiriyo, kendo Odiechieng Pwodhruokno gouru turumbete e gwengeu duto. ");
INSERT INTO luo_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Waluru higa mar piero abich, kendo ugo milome e piny duto ni en higa ma joma otwe igonyo iweyogi gibedo thuolo. Enobed hiku mar mor; ngʼato ka ngʼato nodog thurgi ir joode kendo ir anywolane. ");
INSERT INTO luo_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Higa mar piero abichno nobednu uduto hik mor, kik upidhe cham, kendo kik ukaye orowe, kata kik uponie mzabibu monyak kende e yien mane ok uloso. ");
INSERT INTO luo_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Nimar en higa mar piero abich, kendo mosewalnu maler ni Jehova Nyasaye, nyaka ucham gik monyak e puothe. ");
INSERT INTO luo_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","E higani mar piero abich nyaka ngʼato ka ngʼato odog thurgi. ");
INSERT INTO luo_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","E higani ka ngʼato ongʼiewo lop wadgi to kik wuond moro bedie kindgi. ");
INSERT INTO luo_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ka ingʼiewo lop wadu nyaka ikwan higni kochakore e higa mar piero abich mokadho. Nyaka oket nengo lopno mana maromre gi higni ma pod ibiro keyoe. ");
INSERT INTO luo_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ka hignigo ngʼeny to nyaka imed nengo, to ka higni nok, to nyaka idwok nengo piny, nikech gima ingʼiewo kuome en mana cham mibiro kayo. ");
INSERT INTO luo_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Kik ngʼat maa nyawadgi, to luoruru Nyasachu. An e Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Rituru buchena kendo une ni uluwo chikena, eka mondo udag gi kwe e pinyno. ");
INSERT INTO luo_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Mano eka lowo nochiegnu cham kendo nuchiem ma uyiengʼ mi unudagi gi kwe. ");
INSERT INTO luo_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Kapo upenjo niya, “Angʼo ma wabiro chamo e higa mar abiriyo ka ok wachwoyo, kata ka ok wakeyo?” ");
INSERT INTO luo_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","To anadwoku kama: Anaolnu gweth mogundho e higa mar auchiel, kendo puotheu nochieg cham moromou chamo nyaka bangʼ higni adek. ");
INSERT INTO luo_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","E kinde ma uchwoyo e higa mar aboro to unubed mana kapod uchamo cham machon nyaka chop ubed gi keyo e higa mar ochiko. ");
INSERT INTO luo_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Kik ngʼato usne wadgi lowo chuth, nikech lowo en mara, un to un mana joma amiyo lowo kaka wenda kendo jodak. ");
INSERT INTO luo_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","E pinyu kamoro amora mudakie, nyaka uyie mondo puodho mane oseusi mondo owar. ");
INSERT INTO luo_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Ka wadu moro dhier omako ma ouso lope, to nyaka wadgi moro tem matek kendo owarne lopeno. ");
INSERT INTO luo_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","To ka ngʼato onge gi watne manyalo warone lowo, to kata en owuon ndalo moyudo pesa onyalo ware, ");
INSERT INTO luo_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","kendo enokwan chakre higni mane ouse lopeno, kendo chulo ngʼatno pesa moromo gi higni ma pod odongʼ nyaka chop higa mar mor, eka koro oyiene kawo lopno obed mare kendo. ");
INSERT INTO luo_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","To ka ok onyal waro lopeno, to lopno nosik e lwet ngʼat mane ongʼiewocha nyaka chop higa mar piero abich. To kochopo higa mar morno to nowe lowo odogni wuon mare machon, kendo wuon-gi nokawe. ");
INSERT INTO luo_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Ka ngʼato oyie mi wadgi ongʼiewo ode mar dak manie dala mochiel motegno gi ohinga, to oyiene mana mar ware ka higa achiel pok orumo nyaka ne ngʼiewe. Higano mangima en gi thuolo mar ware. ");
INSERT INTO luo_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ka ok oware ka higa pok orumo, to odno mantiere ei ohinga mochiel motegnono mar dala maduongʼ nosik mana kobedo mar ngʼat mane ongʼiewecha, kaachiel gi nyikwaye kod kothe duto nyaka chiengʼ. Kata kochopo higa mar piero abich to ok nodwoke e lwet wuon machon. ");
INSERT INTO luo_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","To udi moger e mier ma ok ochiel gi ohinga nokwan mana kaka ikwano lowo. Ginto gin gik minyalo waro, maka ochopo higa mar piero abich to nyaka dwokgi e lwet wegi. ");
INSERT INTO luo_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Jo-Lawi nigi thuolo kinde duto mar waro utegi manie miechgi. ");
INSERT INTO luo_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ka ja-Lawi moro ok owaro ode manie dalagi, to odni nyaka duogne e higa mar piero abich, nikech udi manie miech joka Lawi e mwandu kende ma gin godo e piny Israel. ");
INSERT INTO luo_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","To puothe mag lek mag joka Lawi ok nyal usi, nikech mano en mwandugi nyaka chiengʼ. ");
INSERT INTO luo_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Ka ja-Israel wadu moro obedo modhier e dieru, to nyaka ukonye mana kaka ukonyo jadak kata wendo molimou kuma udakie kuom ndalo machwok mondo omi osik kodak kodu. ");
INSERT INTO luo_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Kik ukaw ohala moro amora kuome, to daguru kode kuluoro Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Kik uhole pesa mondo uyudie ohala, kendo kik ukaw ohala kuom chiemo ma uhole. ");
INSERT INTO luo_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","An e Jehova Nyasaye ma Nyasachu, mane ogolou e piny Misri momiyou piny Kanaan kendo mondo abed Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Ka wadu odhier kendo ochiwore mondo ingʼiewe, to kik ikete otini ka misumba. ");
INSERT INTO luo_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","To dag kode kaka jatich michulo kata kaka wendo modak kodi, kendo obiro tiyoni nyaka chop higa mar piero abich. ");
INSERT INTO luo_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Eka bangʼe noa iri en kaachiel gi nyithinde, kendo odogi ir joodgi owuon kendo e lop kwerene. ");
INSERT INTO luo_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Nikech jo-Israel gin wasumbiniga mane agolo an awuon e piny Misri, ok onego ngʼiewgi kaka wasumbini. ");
INSERT INTO luo_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Kik isand ja-Israel wadu kata matin, to iluor Nyasachi. ");
INSERT INTO luo_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Wasumbini magu machwo kata mamon, unyalo mana ngʼiewo koa ir ogendini mukiewogo. ");
INSERT INTO luo_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","To bende un gi thuolo mar ngʼiewo nyithind jodak manie dieru, kaachiel gi joma ginywolo e dieru, makoro ginibed mwandu magu uwegi, ");
INSERT INTO luo_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Bangʼ ka usetho to unuwegi ni yawuotu kaka girkeni kendo ginibed wasumbini mag-gi nyaka chiengʼ, makmana ni jo-Israel weteu to kik usandi. ");
INSERT INTO luo_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Ka jadak moro manie dieru kata wendo oyudo mwandu mi obedo jamoko, to wadu moro to obedo modhier, mi ongʼiewe gi jadak modak e dieru kata anywola jadakno, ");
INSERT INTO luo_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","to en giratiro mondo oware bangʼ ka osengʼiewe. Achiel kuom wedene nyalo ware. ");
INSERT INTO luo_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Ngʼatni nyalo bedo owad gi wuon, kata wuod wuon kata mana watne moro amora e anywolane. To en bende kobedo ja-mwandu to onyalo warore owuon. ");
INSERT INTO luo_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","En kaachiel gi ngʼat mane ongʼieweno nyaka kwan kar romb higni chakre chiengʼ mane ongʼiewe nyaka chop higa mar piero abich. Pesa monego dwokne ngʼat mane ongʼieweno nyaka bed maromre gi pok ma dine ngʼatno ondikogo jatich kuom higni ma ngʼatno osetiyogo. ");
INSERT INTO luo_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","To ka higni modongʼ ngʼeny, to noware gi chudo mamalo. ");
INSERT INTO luo_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","To kodongʼ gi higni manok mondo ochop e higa mar piero abich, to noware gi chudo ma piny. ");
INSERT INTO luo_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ngʼatni nyaka riti kaka jatich mondiki kendo ngʼat mane ongʼiewe ok oyiene mondo osande. ");
INSERT INTO luo_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ka ngʼatno ok owar e achiel kuom yorego, to en kaachiel gi nyithinde noweye thuolo e higa mar piero abich, ");
INSERT INTO luo_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","nikech jo-Israel gin wasumbini maga. Gin wasumbini maga mane agolo e piny Misri. An e Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Kik ulos kido moro amora mopa kata chungo siro moro milamo bende kidi moro amora mopa kik yud e pinyu kukulorune kulame. An e Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Rituru Sabato maga, kendo luoruru kara maler mar lemo. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Ka urito buchena kendo urito chikena, ");
INSERT INTO luo_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","to abiro kelonu koth e kinde mowinjore, kendo pinyu nochieg cham mi yiendeu nonyag olembe. ");
INSERT INTO luo_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ubiro dino cham nyaka chop kinde muponoe mzabibu kendo ubiro pono mzabibu nyaka chop kinde muchwoyoe bende ubiro bedo gi chiemo moromou kendo ubiro dak gi kwe e pinyu. ");
INSERT INTO luo_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Anamiu kwe e pinyu, mi ununindi maonge ngʼama nomiu luoro. Anatieki ondiegi duto e dieru kendo ligangla ok nomonju kata matin. ");
INSERT INTO luo_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Unuriemb jowasiku duto e dieru kendo ununeg-gi. ");
INSERT INTO luo_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Jou abich nobed gi teko mar riembo ji mia achiel, kendo jou mia achiel nobed gi teko mar riembo ji gana apar, kendo ununeg wasiku. ");
INSERT INTO luo_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Abiro olonu gweth, kendo abiro miyo unywol mi ununyaa mathoth, kendo abiro chopo singruok duto mane atimo kodu. ");
INSERT INTO luo_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Cham mag higa makadho manie decheu noromu chamo nyaka chop kinde ma ugologie oko mondo uyud thuolo mar rwako cham manyien. ");
INSERT INTO luo_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Abiro loso kar dakna e dieru kendo ok anajwangʼu kata matin. ");
INSERT INTO luo_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Anawuoth e dieru mi nabed Nyasachu, kendo unubed joga. ");
INSERT INTO luo_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","An e Jehova Nyasaye ma Nyasachu mane ogolou e piny Misri, mondo kik ubed wasumb jo-Misri kendo ne aturo lodi mane otwenu mi koro sani uwuotho tir. ");
INSERT INTO luo_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","To ka unutamru winja ma ok urito chikenago duto, ");
INSERT INTO luo_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ma udagi buchena kendo uchayo chikena, ma ok urito chikena duto ma uketho singruok mara mane atimo kodu, ");
INSERT INTO luo_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","to koro ngʼeuru chuth ni mae e kaka abiro timonu: Anapou gi masira kod tho marach, gi tuo mayuyo wangʼ gi tuo mamiyo del dhe. Cham ma upidho ok nokonyu kata matin nikech jowasiku ema nochamgi. ");
INSERT INTO luo_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Anabed ka asin kodu mi wasiku nolou e lweny kendo gininegu; unubed e bwo loch jowasiku, kendo unubwogru gi ngʼwech kata kaonge joma lawou. ");
INSERT INTO luo_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Kata bangʼ timo magi duto kapod ok unyal winja, to anakumu nyadibiriyo kuom richo duto. ");
INSERT INTO luo_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Anatiek sunga mar wich teko ma un-go, kendo anami polo rieny ka chuma, kendo piny mwalo nodog matek ka mula. ");
INSERT INTO luo_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ubiro ketho tekreu kayiem nono, kuchwoyo cham nimar chambu ok nochiegi, kata yedheu bende ok nonyag olembe. ");
INSERT INTO luo_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Kapod usikona mana gi wich teko kendo udagi winja, to anakelnu masiche moloyo nyadibiriyo maromre gi richou. ");
INSERT INTO luo_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Abiro oronu le mag bungu mondo oked kodu kendo ginineg nyithindo kaachiel gi jambu mi unudongʼ manok kendo yoreu nodongʼ nono maonge joma wuothoe. ");
INSERT INTO luo_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Kobedo ni pod ok udwogo ira kata bangʼ timonu magi duto, kendo udhi mana nyime gi wich teko, ");
INSERT INTO luo_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","to an bende nanyisu wich teko, mi anamiu kum moloyo nyadibiriyo nikech richou. ");
INSERT INTO luo_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Kendo anakel lweny e dieru mondo achulgo kuor kuom ketho singruok mane atimo kodu, kendo kinde duto manuchokru e miechu to nagou gi tuoche kendo wasiku nomaku. ");
INSERT INTO luo_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Anami chiembu doko manok kendo mon apar notedi e agulu achiel. Ginipimnu chiemo e rapim, kendo kata kuchiemo to onge ngʼama noyiengʼ. ");
INSERT INTO luo_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Kobedo ni pod ok udwogo ira kata bangʼ timonu magi duto, kendo udhi mana nyime gi wich teko, ");
INSERT INTO luo_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","to an bende nasik kodu gi wich teko gi mirimba mager, kendo anakumu moloyo nyadibiriyo gi mirimba mager nikech richou. ");
INSERT INTO luo_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Unucham ring yawuotu kod nyiwu. ");
INSERT INTO luo_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Anaketh kuondeu motingʼore gi malo, kendo anamuki kendeu muwangʼoe ubani. Anaket ringreu motho kuom nyiseche manono kendo anajwangʼu chuth. ");
INSERT INTO luo_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Miechu madongo biro bedo gundni, kuondeu maler mag lemo abiro ketho, kendo ok anayie winjo tik mangʼwe ngʼar mag misengini mau. ");
INSERT INTO luo_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Anaketh pinyu kendo jowasiku mabiro dakie nohum nono. ");
INSERT INTO luo_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Abiro keyou e kind ogendini, anagol ligangla mi alawu. Pinyu nodongʼ gunda, kendo miechu madongo nokethi chuth. ");
INSERT INTO luo_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","E kinde duto ma pinyu nodongʼ gunda, ka un to asekeyou udak e kind wasiku; pinyu nobed ma ok opur mondo ochulgo Sabato maga duto mane ok urito. ");
INSERT INTO luo_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","E kinde duto ma pinyu nodongʼ gunda kamano, enobed ma ok opure, ka oritogo Sabato duto mane ok oyweyoe e kinde mane udak kuno. ");
INSERT INTO luo_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","To kuom jou modongʼ ka ngima e piny wasikgi, ginto anagogi kod kihondko e piny wasikgi, ma kata ka yamo okwadho it oboke maponi giwinjo, to giniwuog gi ngʼwech. Giniringi mana ka joma wasigu lawo gi ligangla mi gipodh piny kata obedo ni onge ngʼama lawogi. ");
INSERT INTO luo_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ginituomre kendgi giwegi mana ka joma wasigu lawo gi ligangla, kata obedo ni onge ngʼama lawogi. Omiyo ok unuyud teko mar kedo gi wasiku. ");
INSERT INTO luo_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Unulal nono e kind ogendini, kendo wasiku notieku. ");
INSERT INTO luo_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Joma otony e dieru mane odongʼ kangima e pinje mag wasiku nobed ka dendgi dhi adhiya nikech richogi kendo nikech richo mag kweregi, mana machal kaka notimore ni kweregi. ");
INSERT INTO luo_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Bangʼ mae gibiro hulo richogi gi richo kweregi mane omiyo giweya kaachiel gi richo mane omiyo gibedo wasika, ");
INSERT INTO luo_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","mane omiyo abedo kodgi mamon kendo mane omiyo aterogi e piny wasikgi, eka bangʼe chunygi ma ok oyie kaka adwaro nobolre, mi giniyud kum kuom richogi, ");
INSERT INTO luo_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","eka abiro paro singruok mane atimo gi Jakobo kendo gi Isaka kendo gi Ibrahim, kendo anapar pinyu. ");
INSERT INTO luo_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Piny to nodongʼ gunda nikech joma odakie osea, kendo obiro nindo ka ok opure mondo ochulgo Sabato duto mane ok oyweyoe. Giniyud kum kuom richogi nikech ne gichayo chikena kod buchena. ");
INSERT INTO luo_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","“Kata kamano, kata obedo ni gin e piny wasikgi, to ka anawitgi kendo ok anajwangʼ-gi kata tiekogi chuth, mi aketh singruok mane atimo kodgi. An Jehova Nyasaye ma Nyasachgi. ");
INSERT INTO luo_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Nikech aherogi, omiyo anapar singruok mane atimo gi kweregi, mane agolo e piny Misri mana kane ogendini neno mondo an Jehova Nyasaye abed Nyasachgi.” ");
INSERT INTO luo_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Magi e buche, chike kod yore mane Jehova Nyasaye omiyo jo-Israel e Got Sinai kokadho kuom Musa. ");
INSERT INTO luo_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Wuo gi jo-Israel kendo inyisgi ni: ‘Ka ngʼato ochiwo singo makende ni obiro chiwo ngʼato ni Jehova Nyasaye, eka bangʼe oyudo ni ok onyal chopo singruokneno, to nengo monego wargo ngʼatno ema: ");
INSERT INTO luo_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ngʼama dichwo ma hike chakore piero ariyo nyaka piero auchiel, en to noware mana gi shekel piero abich mag fedha, ma gin shekel mitiyogo e kama ler mar lemo. ");
INSERT INTO luo_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","To dhako ma bende hike romo kamano to nowar gi shekel piero adek. ");
INSERT INTO luo_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","To ka ngʼatno hike chakre abich nyaka piero ariyo, to noware gi shekel piero ariyo ka en dichwo, to ka en dhako to noware gi shekel apar. ");
INSERT INTO luo_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","To ka ngʼatno hike pok ochopo abich to osekadho dwe achiel, to noware gi shekel abich mar fedha ka en nyathi ma wuowi, to ka en nyako to noware gi shekel adek. ");
INSERT INTO luo_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","To ka ngʼatno hike chakore piero auchiel kadhi malo, to nochul shekel apar gabich ka en dichwo, to ka en dhako to noware gi shekel apar. ");
INSERT INTO luo_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Kaponi ngʼat mane osingoreno odhier ma ok nyal chulo nengo ma oketneno, to nokaw ngʼatni mondo otere e nyim jadolo, kendo jadolo noyiene mondo ochul mana gima nokwongʼore ni onyalo. ");
INSERT INTO luo_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Ka ngʼato osingore ni obiro chiwo ne Jehova Nyasaye chiayo minyalo timgo misango, to gima ochiwono nobed mowal ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ok oyiene wilo chiayono mondo oket moro kare, bedni orach kata ober, bende ok onyal wile gi gimoro amora. To kaponi otimo kamano, to nyaka ongʼe ni chiayono kod mokwongo giduto koro ginibed mowal ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ka chiayo mane osingono obedo mogak ma ok nyal timgo misango ni Jehova Nyasaye, to chiayono chuno ni nyaka kele e nyim jadolo, ");
INSERT INTO luo_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","mondo jadolo onon ka ober kata ka orach. Nengo moro amora ma jadolo oketo ema nobed nengo chiayono. ");
INSERT INTO luo_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","To ka wuon chiayono dwaro waro chiacheno, to nyaka omed achiel ewi abich mar nengone. ");
INSERT INTO luo_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Ka ngʼato ochiwo ode mondo obed gima owal ni Jehova Nyasaye, to jadolo mondo onon odno kober kata korach. To nengo moro amora ma jadolo oketo ema nobed nengo odno. ");
INSERT INTO luo_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","To ka wuon odno dwaro waro odeno, to nyaka omed achiel ewi abich mar nengone, eka odno noduogne. ");
INSERT INTO luo_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Ka ngʼato ochiwo ne Jehova Nyasaye bath lope moro, to nyaka nengone romre gi nengo kodhi ma inyalo chwo e puodhono. Nengo kodhi mar shairi midhi chwo e lowono nyaka rom abiriyo ma en shekel piero abich mar fedha. ");
INSERT INTO luo_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kaponi ochiwo lopeno e Higa mar Piero Abich, to nengone osiki mana kamano. ");
INSERT INTO luo_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Kaponi ochiwe ka Higa mar Piero Abich oserumo, to jadolo mondo okwan higni modongʼ nyaka chop ndalo mar Higa mar Piero Abich, kendo nengone obed mana maromo gi higni modongʼ-go. ");
INSERT INTO luo_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Kaponi ngʼat mane ochiwo lopeno nigi chuny mar ware, to nyaka ochul achiel ewi abich mar nengone, eka puodhono nobed mare. ");
INSERT INTO luo_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","To kaponi ok odwar waro lopeno, kata ka oseuse ni ngʼato machielo, to koro ok oyiene ware. ");
INSERT INTO luo_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ka ochopo Higa mar Piero Abich mi oweyo puodhono, to nobed gima ler kaka puodho moyangne Jehova Nyasaye chuth, kendo puodhono nodongʼne jadolo kaka mwandune chuth. ");
INSERT INTO luo_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Ka ngʼato ochiwo ni Jehova Nyasaye puodho mosengʼiewo, ma ok en lop anywola, ");
INSERT INTO luo_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","to jadolo nigi thuolo mondo ogo nengo maromre kode nyaka chop e Higa mar Piero Abich, kendo ngʼatno nochul nengono mana godiechiengno, kaka gima owal ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ka Higa mar Piero Abich osechopo, to puodho nodwok ir ngʼat mane ongʼiewe kuome, ma en wuon lowo hie. ");
INSERT INTO luo_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Nengo ka nengo nopim gi nengo shekel mitiyogo e kama ler mar lemo ma shekel achiel romre gi gera piero ariyo. ");
INSERT INTO luo_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Gimoro amora mokwong nywol kuom jambi gin mag Jehova Nyasaye, bedni gin dhok, kata rombe, omiyo kik ichiwgi kaka gima iwalo ni Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kaponi en chiayo mogak ma ok nyal timgo misango ni Jehova Nyasaye, to noware e nengo mogone, komedo achiel ewi abich mar nengone. Kaponi ok oware to nyaka ngʼiewe mana e nengo moketi. ");
INSERT INTO luo_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Gimoro amora ma ngʼato angʼata osechiwo ni Jehova Nyasaye chuth kuom mwandune ma en godo, bedni en dhano kata chiayo kata lop anywola ok onego ngʼiew kata waro nikech gima osechiw ne Jehova Nyasaye ler moloyo. ");
INSERT INTO luo_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Ngʼato angʼata mochiwne Jehova Nyasaye mondo okum ok nyal war, to nyaka nege anega. ");
INSERT INTO luo_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Achiel kuom apar mar gik moko duto ma lowo onyago bedni gin cham, kata olembe duto gin mag Jehova Nyasaye, kendo gin gik maler mowalne. ");
INSERT INTO luo_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ka ngʼato owaro achiel kuom apar mar gige, to nyaka omedie achiel ewi abich mar nengogi. ");
INSERT INTO luo_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Chiayo mar apar mokadho e bwo ludh jakwath e kinde ma okwanogi, nobed mowal ni Jehova Nyasaye, bedni gin dhok kata rombe. ");
INSERT INTO luo_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ok oyiene pogo mabeyo gi maricho kata wilogi. To kaponi owilo chiayo moro gi machielo, to chiayono kaachiel gi mowilegono, giduto ginibed gik maler e nyim Jehova Nyasaye kendo ok nyal wargi.’ ” ");
INSERT INTO luo_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Magi e chike mane Jehova Nyasaye omiyo Musa ewi Got Sinai ne jo-Israel.");
INSERT INTO luo_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Chiengʼ mokwongo mar dwe mar ariyo e higa mar ariyo Jehova Nyasaye nowuoyo gi Musa e Hemb Romo e Thim mar Sinai ka jo-Israel nosewuok Misri. Nowachone niya, ");
INSERT INTO luo_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Kaw kwan dhout oganda mar jo-Israel duto kaluwore gi gwengegi kod anywolagi, kindiko nying joma chwo duto moro ka moro. ");
INSERT INTO luo_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","In kod Harun mondo ukwan jo-Israel kuketogi e migepegi, ma mago jo-higni piero ariyo kadhi nyime nyalo tiyo e lweny. ");
INSERT INTO luo_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Kaw ngʼato achiel koa e dhoot ka dhoot, ka moro ka moro otelo ne jog-gi mondo okonyi kweno. ");
INSERT INTO luo_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Magi e nying joma chwo mabiro konyi kweno: “koa kuom joka Reuben, kaw Elizur wuod Shedeur; ");
INSERT INTO luo_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","koa kuom joka Simeon, kaw Shelumiel wuod Zurishadai; ");
INSERT INTO luo_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","koa kuom joka Juda, kaw Nashon wuod Aminadab; ");
INSERT INTO luo_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","koa kuom joka Isakar, kaw Nethanel wuod Zuar; ");
INSERT INTO luo_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","koa kuom joka Zebulun, kaw Eliab wuod Helon. ");
INSERT INTO luo_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Magi e joma chwo mane okaw koa kuom yawuot Josef: koa kuom Efraim, kaw Elishama wuod Amihud; koa kuom Manase, kaw Gamaliel wuod Pedazur; ");
INSERT INTO luo_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","koa kuom joka Benjamin, kaw Abidan wuod Gideoni; ");
INSERT INTO luo_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","koa kuom joka Dan, kaw Ahiezer wuod Amishadai; ");
INSERT INTO luo_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","koa kuom joka Asher, kaw Pagiel wuod Okran; ");
INSERT INTO luo_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","koa kuom joka Gad, kaw Eliasaf wuod Dewel; ");
INSERT INTO luo_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","koa kuom joka Naftali, kaw Ahira wuod Enan.” ");
INSERT INTO luo_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Magi e joma chwo mane oyier koa e dhoudi, mane gin jotend dhoudigo. Gin ema ne gin jotend dhout Israel. ");
INSERT INTO luo_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musa gi Harun nokawo nying joma nomigi, ");
INSERT INTO luo_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","kendo negiluongo jogwengʼno duto kanyakla e odiechiengʼ mokwongo mar dwe mar ariyo. Ji nonyiso nonro margi kaluwore gi gwengegi kod anywola mag-gi, kendo joma hikgi piero ariyo kadhi nyime nondik nying-gi, moro ka moro, ");
INSERT INTO luo_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","mana kaka Jehova Nyasaye nochiko Musa. Kuom mano ma e kaka Musa nokwanogi e Thim mar Sinai. ");
INSERT INTO luo_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Koa kuom nyikwa Reuben ma en wuowi makayo mar Israel: Chwo duto mahikgi piero ariyo kadhi nyime moromo tiyo e lweny nondik nying-gi, achiel ka achiel, kaluwore gi nonro mar dhoodgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Kar romb joka Reuben ne gin ji alufu piero angʼwen gauchiel gi mia abich (46,500). ");
INSERT INTO luo_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Koa kuom nyikwa Simeon: Chwo duto mahikgi piero ariyo kadhi nyime moromo tiyo e lweny nondik nying-gi, achiel kaachiel, kaluwore gi nonro mar dhoodgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Kar romb joka Simeon ne gin ji alufu piero abich gochiko gi mia adek (59,300). ");
INSERT INTO luo_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Koa kuom nyikwa Gad: Chwo duto mahikgi piero ariyo kadhi nyime moromo tiyo e lweny nondik nying-gi, kaluwore gi nonro mar dhoodgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Kar romb joka Gad ne gin ji alufu piero angʼwen gabich, mia auchiel gi piero abich (45,650). ");
INSERT INTO luo_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Koa kum nyikwa Juda: Chwo duto mahikgi piero ariyo kadhi nyime moromo tiyo e lweny nondik nying-gi, kaluwore gi nonro mar dhoodgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Kar romb joka Juda ne gin ji alufu piero abiriyo gangʼwen gi mia auchiel (74,600). ");
INSERT INTO luo_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Koa kuom nyikwa Isakar: Chwo duto mahikgi piero ariyo kadhi nyime moromo tiyo e lweny nondik nying-gi, kaluwore gi nonro mar dhoodgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Kar romb joka Isakar ne gin ji alufu piero abich gangʼwen gi mia angʼwen (54,400). ");
INSERT INTO luo_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Koa kuom nyikwa Zebulun: Chwo duto mahikgi piero ariyo kadhi nyime moromo tiyo e lweny nondik nying-gi, kaluwore gi nonro mar dhoodgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Kar romb joka Zebulun ne gin ji alufu piero abich gabiriyo gi mia angʼwen (57,400). ");
INSERT INTO luo_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Kuom yawuot Josef: Koa e dhood Efraim: Chwo duto mahikgi piero ariyo kadhi nyime moromo tiyo e lweny nondik nying-gi, kaluwore gi nonro mar dhoodgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Kar romb joka Efraim ne gin ji alufu piero angʼwen gi mia abich (40,500). ");
INSERT INTO luo_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Koa e dhood Manase: Chwo duto mahikgi piero ariyo kadhi nyime moromo tiyo e lweny nondik nying-gi, kaluwore gi nonro mar dhoodgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Kar romb joka Manase ne gin ji alufu piero adek gariyo gi mia ariyo (32,200). ");
INSERT INTO luo_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Koa kuom nyikwa Benjamin: Chwo duto mahikgi piero ariyo kadhi nyime moromo tiyo e lweny nondik nying-gi, kaluwore gi nonro mar dhoodgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Kar romb dhood Benjamin ne gin ji alufu piero adek gabich gi mia angʼwen (35,400). ");
INSERT INTO luo_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Koa kuom nyikwa Dan: Chwo duto mahikgi piero ariyo kadhi nyime moromo tiyo e lweny nondik nying-gi, kaluwore gi nonro mar dhoodgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Kar romb dhood Dan ne gin ji alufu piero auchiel gariyo gi mia abiriyo (62,700). ");
INSERT INTO luo_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Koa kuom nyikwa Asher: Chwo duto mahikgi piero ariyo kadhi nyime moromo tiyo e lweny nondik nying-gi, kaluwore gi nonro mar dhoodgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Kar romb dhood Asher ne gin ji alufu piero angʼwen gachiel gi mia abich (41,500). ");
INSERT INTO luo_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Koa kuom nyikwa Naftali: Chwo duto mahikgi piero ariyo kadhi nyime moromo tiyo e lweny nondik nying-gi, kaluwore gi nonro mar dhoodgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Kar romb dhood Naftali ne gin ji alufu piero abich gadek gi mia angʼwen (53,400). ");
INSERT INTO luo_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Magi e joma Musa gi Harun kod jotend Israel apar gariyo nokwano, ka moro ka moro ochungʼ ne anywolane. ");
INSERT INTO luo_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Jo-Israel duto ma jo-higni piero ariyo kadhi nyime mane nyalo tiyo e lwenj Israel nokwan kaluwore gi anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Kar rombgi ne gin ji alufu mia auchiel gadek mia abich gi piero abich (603,550). ");
INSERT INTO luo_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Anywola mar jo-Lawi, kata kamano, ne ok okwan gi joma moko. ");
INSERT INTO luo_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Kik ikwan dhood Lawi kata riwogi e kweno mar jo-Israel mamoko. ");
INSERT INTO luo_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Kuom mano, yier jo-Lawi mondo obed jorit Hemb Romo mar Rapar kaachiel gi gik moko duto manie iye. Gin ema nyaka gitingʼ Hemb Romo gi gige; kendo girite maber ka gilwore kod hembegi koni gi koni. ");
INSERT INTO luo_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kamoro amora ma itero e Hema, jo-Lawi ema nyaka gole oko, kendo kamoro amora midhi gure Hema, jo-Lawi ema nyaka gure. Ngʼato angʼata mosudo machiegni kode nyaka negi. ");
INSERT INTO luo_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Jo-Israel nyaka gur hembegi e migepe, ka ngʼato ka ngʼato nitiere kare owuon kaluwore gi rangʼiny moketi. ");
INSERT INTO luo_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Jo-Lawi, kata kamano, nyaka gur hembegi e alwora mar Hemb Romo mar Rapar mondo omi mirimb Jehova Nyasaye kik lwar kuom oganda mar jo-Israel. Jo-Lawi nobed karito Hemb Romo mar Rapar.” ");
INSERT INTO luo_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Jo-Israel notimo gigi duto mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Jehova Nyasaye nowacho ne Musa gi Harun niya, ");
INSERT INTO luo_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Jo-Israel nyaka chokre kolworo Hemb Romo kochwalore matin kode, ka ngʼato ka ngʼato ni e bwo jatendgi kod gima ondikie nying dhoodgi.” ");
INSERT INTO luo_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Koa yo wuok chiengʼ, migepe mag joka Juda nodag kanyo kaluwore gi rangʼiny moketi. Jatend Juda ne en Nashon wuod Aminadab. ");
INSERT INTO luo_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Migawo mar dhood Juda ne romo ji alufu piero abich gangʼwen gi mia angʼwen (74,600). ");
INSERT INTO luo_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Dhood Isakar nodag butgi. Jatend dhood Isakar ne en Nethanel wuod Zuar. ");
INSERT INTO luo_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Migawo mar dhood Isakar ne romo ji alufu piero abich gangʼwen gi mia angʼwen (54,400). ");
INSERT INTO luo_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Dhood Zebulun noluwogi. Jatend dhood Zebulun ne en Eliab wuod Helon. ");
INSERT INTO luo_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Migawo mar dhood Zebulun ne romo ji alufu piero abich gabiriyo gi mia angʼwen (57,400). ");
INSERT INTO luo_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Jogo duto mane odak e dala Juda, kaluwore gi migepegi, ne romo ji alufu mia achiel gi piero aboro gauchiel gi mia angʼwen (186,400). Gin e joma biro wuok motelo. ");
INSERT INTO luo_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Koa yo milambo nobedie migepe mag Reuben kaluwore gi rangʼiny moketi. Jatend dhood Reuben ne en Elizur wuod Shedeur. ");
INSERT INTO luo_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Migawo mar dhood Reuben ne romo ji alufu piero angʼwen gauchiel gi mia abich (46,500). ");
INSERT INTO luo_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Dhood Simeon nodag butgi. Jatend dhood Simeon ne en Shelumiel wuod Zurishadai. ");
INSERT INTO luo_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Migawo mar dhood Simeon ne romo ji alufu piero abich gochiko gi mia adek (59,300). ");
INSERT INTO luo_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Maluwogi ne en dhood Gad. Jatend dhood Gad ne en Eliasaf wuod Reuel. ");
INSERT INTO luo_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Migawo mar dhood Gad ne romo ji alufu piero angʼwen gabich gi mia auchiel gi piero abich (45,650). ");
INSERT INTO luo_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Jogo duto mane odak e dala Reuben, kaluwore gi migepe mag-gi, noromo ji alufu mia achiel gi piero abich gachiel, mia angʼwen gi piero abich (151,450). Gin ema giniwuogi mar ariyo. ");
INSERT INTO luo_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Bangʼe Hemb Romo kod kar dak mar jo-Lawi noket e dier kambe mamoko. Ginichanre mana kaka kuondegi mag bworo ochanore ka jomoko ka jomoko ni kargi giwegi. ");
INSERT INTO luo_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Koa yo podho chiengʼ nobedie migepe mag Efraim kaluwore gi rangʼiny moketi. Jatend dhoodno ne en Elishama wuod Amihud. ");
INSERT INTO luo_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Migawo mar dhood Efraim noromo ji alufu piero angʼwen gi mia abich (40,500). ");
INSERT INTO luo_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Dhood Manase ema nobed butgi. Jatend dhoodno ne en Gamaliel wuod Pedazur. ");
INSERT INTO luo_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Migawo mar dhood Manase noromo ji alufu piero adek gariyo gi mia ariyo (32,200). ");
INSERT INTO luo_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Maluwogi ne en dhood Benjamin. Jatend dhood Benjamin ne en Abidan wuod Gideoni. ");
INSERT INTO luo_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Migawo mar dhood Benjamin noromo ji alufu piero adek gabich gi mia angʼwen (35,400). ");
INSERT INTO luo_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Jogo duto mane odak e dala Efraim, kaluwore gi migepe mag-gi noromo ji alufu mia achiel gaboro gi mia achiel (108,100). Gin ema ne giwuok mar adek. ");
INSERT INTO luo_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Koa yo nyandwat nobedi migepe mag kuonde dak mag Dan, kaluwore gi rangʼiny moketi. Jatend dhood Dan en Ahiezer wuod Amishadai. ");
INSERT INTO luo_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Migawo mar dhood Dan noromo ji alufu piero auchiel gariyo gi mia abiriyo (62,700). ");
INSERT INTO luo_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Maluwogi ne en dhood Asher. Jatend dhood Asher ne en Pagiel wuod Okran. ");
INSERT INTO luo_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Migawo mar dhood Asher noromo ji alufu piero angʼwen gachiel gi mia abich (41,500). ");
INSERT INTO luo_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Maluwogi ne en dhood Naftali. Jatend dhood Naftali ne en Ahira wuod Enan. ");
INSERT INTO luo_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Migawo mar dhood Naftali noromo ji alufu piero abich gadek gi mia angʼwen (53,400). ");
INSERT INTO luo_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Jogo duto mane odak e dala Dan noromo ji alufu mia achiel gi piero abich gabiriyo, gi mia auchiel (157,600). Gin ema giniwuogi mogik kaluwore gi rangʼiny moketi. ");
INSERT INTO luo_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Magi e jo-Israel, mane okwan kaluwore gi dhoutgi. Jogo duto mane nitie kar dak, kaluwore gi migepe mag-gi noromo ji alufu mia auchiel gadek, mia abich gi piero abich (603,550). ");
INSERT INTO luo_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Kata kamano, jo-Lawi ne ok okwan gi jo-Israel mamoko, mana kaka Jehova Nyasaye nosechiko Musa. ");
INSERT INTO luo_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Omiyo jo-Israel notimo gik moko duto mane Jehova Nyasaye ochiko Musa; mano e yo mane gichokore godo e rangʼiny mag-gi giwegi, kendo mano e kaka negichokore, moro ka moro gi dhoodgi kod joge. ");
INSERT INTO luo_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ma e nonro mar joka Harun kod Musa e kinde mane Jehova Nyasaye owuoyo gi Musa e Got Sinai. ");
INSERT INTO luo_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Nying yawuot Harun ne gin Nadab ma wuowi makayo kod Abihu, Eliazar kod Ithamar. ");
INSERT INTO luo_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Mago ema ne nying yawuot Harun, mane gin jodolo mowir kendo mopwodhi mondo obed jodolo. ");
INSERT INTO luo_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Kata kamano Nadab kod Abihu, notho e nyim Jehova Nyasaye e kinde mane gichiwo misango ma ok opwodhi e Thim mar Sinai. Ne gionge yawuowi; omiyo Eliazar gi Ithamar kende ema nobedo jodolo e ndalo mane Harun wuon-gi pod ngima. ");
INSERT INTO luo_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Kel dhood jo-Lawi kendo ichiwgi e nyim jadolo Harun mondo gikonye tich. ");
INSERT INTO luo_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Nyaka gitine kaachiel gi oganda duto e nyim Hemb Romo ka gitiyo tije mag kama ler. ");
INSERT INTO luo_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Nyaka girit malongʼo gige Hemb Romo duto, ka gichopo chike duto mag jo-Israel monego gitim e Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Chiw jo-Lawi e lwet Harun gi yawuote nikech gin e joma owal e dhood Israel mondo okonye tich. ");
INSERT INTO luo_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Yier Harun kod yawuote mondo obed jodolo; ngʼato angʼata mosudo machiegni gi kama ler mar lemo nyaka negi.” ");
INSERT INTO luo_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Jehova Nyasaye nomedo wachone Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Asekawo jo-Lawi koa ei jo-Israel e lo wuowi makayo mar chi ja-Israel moro ka moro. Jo-Lawi gin meka, ");
INSERT INTO luo_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","nimar yawuowi makayo duto gin meka. Kane anego yawuowi makayo duto e piny Misri, ne awalo ne an awuon kayo moro amora e Israel, obed mar dhano kata mar le mondo gibed maga. An e Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Jehova Nyasaye nowacho ne Musa e Thim mar Sinai niya, ");
INSERT INTO luo_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Kwan jo-Lawi kaluwore gi joutgi kod anywolagi. Kwan chwo duto chakre ja-dwe achiel kadhi nyime.” ");
INSERT INTO luo_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Omiyo Musa nokwanogi, mana kaka Jehova Nyasaye nomiye chik. ");
INSERT INTO luo_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Magi ema ne nyinge yawuot jo-Lawi: Gershon, Kohath gi Merari. ");
INSERT INTO luo_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Magi ema ne nying joka Gershon: Libni gi Shimei. ");
INSERT INTO luo_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Joka Kohath ne gin: Amram, Izhar, Hebron gi Uziel. ");
INSERT INTO luo_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Joka Merari ne gin: Mali gi Mushi. Magi ema ne anywola jo-Lawi, kaluwore gi dhoutgi. ");
INSERT INTO luo_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Koa e dhood Gershon, ne nitiere jo-Libni gi Shimei; mago ema ne joka Gershon. ");
INSERT INTO luo_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Kar romb chwo duto kochakore ja-dwe achiel kadhi nyime noromo ji alufu abiriyo mia abich (7,500). ");
INSERT INTO luo_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Dhout jo-Gershon nonego dag yo podho chiengʼ mar kama ler. ");
INSERT INTO luo_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Jatend Gershon ne en Eliasaf wuod Lael. ");
INSERT INTO luo_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Tij jo-Gershon e Kar Hemb Romo ne en rito Kama Ler mar Lemo kod hema, kaachiel gi gik moumego, kaka pasia mantiere e dhorangach mar Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Bende negirito pasia mag laru, pasia mar dhorangach mar laru molworo kama ler gi kendo mar misango kod tonde, kaachiel gi gik moko duto mitwechogo. ");
INSERT INTO luo_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","E dhood Kohath ne nitiere jo-Amram, jo-Izhar, jo-Hebron, jo-Uziel; magi ema ne anywola joka Kohath. ");
INSERT INTO luo_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Kar romb chwo duto kochakore ja-dwe achiel kadhi nyime ne romo ji alufu aboro mia auchiel (8,600). Tij jo-Kohath ne en rito kama ler mar lemo. ");
INSERT INTO luo_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Dhood Kohath nonego dagi yo milambo mar kama ler. ");
INSERT INTO luo_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Jatend dhout jo-Kohath ne en Elizafan wuod Uziel. ");
INSERT INTO luo_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Tijgi ne en rito Sandug Muma, mesa, rachungi mar taya, kende mag misengini, gige kama ler mar lemo mitiyogo tije dolo, pasia, kod gik moko duto mitiyogo tijego. ");
INSERT INTO luo_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Jatelo maduongʼ mar jo-Lawi ne en Eliazar wuod Harun jadolo. En ema ne oyiere bedo jatelo mag joma rito kama ler mar lemo. ");
INSERT INTO luo_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","E dhood Merari ne nitiere jo-Mali kod jo-Mushi; magi ema anywola joka Merari. ");
INSERT INTO luo_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Kar romb chwo duto kochakore ja-dwe achiel kata moloyo dwe achiel mane okwan ne romo ji alufu auchiel mia ariyo (6,200). ");
INSERT INTO luo_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Jatend dhout Merari ne en Zuriel wuod Abihail. Nonego gidagi yo nyandwat mar kama ler. ");
INSERT INTO luo_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Joka Merari noyier mondo orit sirni mag kama ler mar lemo, yiend reru, sirni mamoko, mise, kaachiel gi gige duto kod gik moko duto mitiyogo kanyo, ");
INSERT INTO luo_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","kaachiel gi sirni mochungʼ molworo laru man-gi mise, sigingi mag hema kod tonde. ");
INSERT INTO luo_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa kod Harun gi yawuote nonego dagi yo wuok chiengʼ mar Hemb Romo. Tijgi ne en rito kama ler mar lemo e lo jo-Israel. Ngʼato angʼata mane osudo machiegni gi kama ler mar lemo nyaka ne negi. ");
INSERT INTO luo_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Kar romb jo-Lawi duto mane okwan kaluwore gi chik mane Jehova Nyasaye ogolo kokadho kuom Musa kod Harun kaluwore gi anywolagi ne gin ji alufu piero ariyo gariyo (22,000), magi ne gin kaachiel gi nyithindo duto ma yawuowi kochakore ja-dwe achiel kadhi nyime. ");
INSERT INTO luo_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Jehova Nyasaye nowacho ne Musa niya, “Kwan nyithindo ma yawuowi makayo duto mag Israel kochakore ja-dwe achiel kadhi nyime kendo indik nyingegi piny. ");
INSERT INTO luo_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ket jo-Lawi obedna kaka kayo e lo kayo duto mag jo-Israel, kendo kaw jamb jo-Lawi obed e lo kweth makayo mag jamb jo-Israel. An e Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Omiyo Musa nokwano nyithindo makayo duto mag jo-Israel, mana kaka Jehova Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Kar romb nyithindo ma yawuowi duto makayo ma ja-dwe achiel kadhi nyime, kondik nying-gi moro ka moro ne romo ji alufu piero ariyo gariyo, mia ariyo gi piero abiriyo gadek (22,273). ");
INSERT INTO luo_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Jehova Nyasaye nochako owachone Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Ket jo-Lawi mondo obedna kaka kayo e lo jo-Israel, kendo jamni mag jo-Lawi e lo jambgi. Jo-Lawi nyaka bed maga. An e Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Mondo omi ires jo-Israel makayo ji mia ariyo piero adek gabiriyo ma kwan-gi ohewo kwan midwaro mar jo-Lawi, ");
INSERT INTO luo_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","chok shekel abich ne ngʼato ka ngʼato, kaluwore gi shekel mar kama ler mar lemo, ma pekne romo gera piero ariyo. ");
INSERT INTO luo_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Mi Harun kod yawuote pesa miwarogo jo-Israel momedore.” ");
INSERT INTO luo_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Omiyo Musa nochoko pesa kuom joma ne omedore e kwan mane jo-Lawi oreso. ");
INSERT INTO luo_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Koa kuom kayo mag jo-Israel nochoko fedha ma pekne en shekel alufu mia achiel mia adek gi piero auchiel gabich (1,365), kaluwore gi shekel mar kama ler mar lemo. ");
INSERT INTO luo_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Musa nochiwo ne Harun kod yawuote pesa miwarogo jo-Israel momedore mana kaka Jehova Nyasaye nochike. ");
INSERT INTO luo_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Jehova Nyasaye nowacho ne Musa gi Harun niya, ");
INSERT INTO luo_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Kwan jo-Kohath ma gin bad jo-Lawi kaluwore gi gwengegi kod dhoutgi. ");
INSERT INTO luo_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Kwan chwo duto mahikgi chakore piero adek nyaka piero abich mabiro tiyo e Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Tij jo-Kohath e Hemb Romo en rito gik maler moloyo. ");
INSERT INTO luo_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ka udar kama ujote, to Harun kod yawuote nyaka donji ei hema mi gigol pasia kendo giumgo Sandug Muma. ");
INSERT INTO luo_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Bangʼe gium nangani gi piende monyongʼ mayom mag le mag nembe, kendo giyar suka marambulu bangʼe giket sirni mitingʼego. ");
INSERT INTO luo_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Nyaka gipedh mesa manie Nyim Nyasaye gi kitamba marambulu, bangʼe giket sende e wiye, gi dise kod bakunde, gi njage mar chiwo misango miolo piny; bende gine ni makati man kanyo seche duto kik rum. ");
INSERT INTO luo_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Nyaka gipedh nanga ewi gigi duto kendo giumgi gi piende monyongʼ mayom mag le mag nembe bangʼe giket sirni mitingʼego. ");
INSERT INTO luo_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Nyaka gikaw nanga marambulu kendo gium rachungi taya ma en kar keto gima chiwo ler, kaachiel gi techene, gi gima ingʼadogo otambi kod odheru, kod njage duto mikanoe mo. ");
INSERT INTO luo_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Bangʼe to nyaka giume gi piende monyongʼ mayom mag le mag nembe kaachiel gi gige duto kendo gikete e sirni mitingʼego. ");
INSERT INTO luo_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Nyaka gipedh nanga marambulu ewi kendo mar misango mar dhahabu bangʼe giume gi piende monyongʼ mayom mag le mag nembe kendo giket sirni mitingʼego kuonde mowinjore. ");
INSERT INTO luo_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Nyaka gikaw gik moko duto motiyogo e tij dolo e kama ler mar lemo, kendo gibogi gi suka marambulu, kod piende monyongʼ mayom mag le mag nembe, bangʼe giketgi e sirni mitingʼego oliero liero. ");
INSERT INTO luo_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Nyaka gigol buru oko e kendo mar misango mar mula bangʼe gipedh suka maralik e wiye. ");
INSERT INTO luo_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Bangʼ mano giniket gik michiemogo mag dolo e kar kendo mar misango, kaachiel gi gige chiedo, uma mar chwoyo ringʼo, opawo kod bakunde mikirogo remo. Nyaka gipedh raum mar piende monyongʼ mayom mag le mag nembe e wiye kendo giket sirni mitingʼego kuonde mowinjore. ");
INSERT INTO luo_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Bangʼ ka Harun gi yawuote osetieko umo gik maler mitiyogo kod gik maler duto mamoko, kendo ka kambi oseikore mar wuok, to jo-Kohath koro nyaka bi mondo oti tij tingʼo. Kik gimul gik maler, nimar ka gitimo kamano to ginitho. Jo-Kohath nyaka tingʼ gigo mantiere ei Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eliazar wuod Harun, jadolo, nochungʼne mo mar taya, ubani mangʼwe ngʼar, chiwo mar cham michiwo kinde ka kinde, kod mor pwodhruok. Nyaka obed jarit mar kar lemo duto kod gik moko duto manie iye, kaachiel gi gik maler molosego kod gik moko duto mokan kanyo.” ");
INSERT INTO luo_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Jehova Nyasaye nowacho ne Musa gi Harun niya, ");
INSERT INTO luo_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Neuru ni dhout jo-Kohath ok ogol oko kuom jo-Lawi, ");
INSERT INTO luo_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","mondo omi gibed mangima kendo kik githo ka gibiro machiegni gi gik maler moloyo. Timnegiuru kama: Harun gi yawuote mondo odhi ei kama ler mar lemo kendo gimi ngʼato ka ngʼato tije kod gima onego otingʼ. ");
INSERT INTO luo_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","To dhout jo-Kohath kik donji nikech dipo ka gigoyo wangʼ-gi kuom gik maler mi githo.” ");
INSERT INTO luo_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Kwan joka Gershon kaluwore gi anywolagi kod dhoutgi. ");
INSERT INTO luo_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Kwan chwo duto mahikgi en piero adek nyaka piero abich, ma gin joma obiro konyo tich mar Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Ma e tich ma joka Gershon biro timo ka gitiyo kendo ka gitingʼo misigo: ");
INSERT INTO luo_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Gibiro tingʼo pasia moumgo kar lemo, Hemb Romo, gik moumego kod piende monyongʼ mayom mag le mag nam moumgo wiye, moumgo dhoranga Hemb Romo, ");
INSERT INTO luo_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","pasia mag laru molworo kar lemo kod kendo mar misango, pasia mar dhorangach, tonde kod gik moko duto mitiyogo kanyo. Joka Gershon nyaka ti tije duto madwarore mondo oti kanyo. ");
INSERT INTO luo_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Tijegi duto, bedni en tingʼo kata tich moro amora nyaka tim ka Harun kod yawuote ema oteloe. Unupog-gi tich monego gitim. ");
INSERT INTO luo_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ma e tich ma dhout Gershon onego tim e Hemb Romo. Ithamar wuod Harun jadolo ema notelne tijegi. ");
INSERT INTO luo_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Kwan jo-Merari kaluwore gi dhoutgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Kwan joma chwo duto mahikgi piero adek nyaka piero abich mabiro konyo e tich mar Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ma e tich ma gibiro tiyo e Hemb Romo: ginitingʼ yiende moten-go kar lemo, fito mage, sirni kod mise, ");
INSERT INTO luo_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","kaachiel gi sirni molworo laru man-gi mise, sigingi mag hema, tonde, gi gik moko duto mitiyogo kanyo kendo ngʼato ka ngʼato nyaka mi gik monego otingʼ. ");
INSERT INTO luo_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ma e tich ma dhood Merari onego ti e Hemb Romo kotelnegi gi Ithamar wuod Harun jadolo.” ");
INSERT INTO luo_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa, Harun kod jotend oganda mar jo-Israel nokwano jo-Kohath kaluwore gi dhoutgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Chwo duto mahikgi piero adek nyaka piero abich mane obiro tiyo e tij Hemb Romo, ");
INSERT INTO luo_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","kokwan kaluwore gi dhoutgi, ne romo ji alufu ariyo mia abiriyo gi piero abich (2,750). ");
INSERT INTO luo_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Mano e kar romb jogo duto mane oa e dhout jo-Kohath mane otiyo e Hemb Romo. Musa kod Harun nokwanogi kaluwore gi chik mane Jehova Nyasaye ogolo kokalo kuom Musa. ");
INSERT INTO luo_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Jo-Gershon nokwan kaluwore gi dhoutgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Chwo duto mahikgi piero adek nyaka piero abich mane obiro tich e Hemb Romo, ");
INSERT INTO luo_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","kokwan kaluwore gi dhoutgi kod anywolagi, ne romo ji alufu ariyo mia auchiel gi piero adek (2,630). ");
INSERT INTO luo_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Mano e kar romb jogo mane oa e dhout anywola mar Gershon mane otiyo e Hemb Romo. Musa kod Harun nokwanogi kaluwore gi chik Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Jo-Merari nokwan kaluwore gi dhoutgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Chwo duto mahikgi piero adek nyaka piero adek gabich mane obiro chiwo kony e tich mar Hemb Romo, ");
INSERT INTO luo_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","kokwan kaluwore gi dhoutgi ne romo ji alufu adek gi mia ariyo (3,200). ");
INSERT INTO luo_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ma e kar kwan joka Merari duto. Musa kod Harun nokwanogi kaluwore gi chik mane Jehova Nyasaye ochiwo kokalo kuom Musa. ");
INSERT INTO luo_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Omiyo Musa, Harun kod jotend Israel nokwano jo-Lawi duto kaluwore gi dhoutgi kod anywolagi. ");
INSERT INTO luo_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Chwo duto mahikgi piero adek nyaka piero abich mane obiro tiyo e Hemb Romo ");
INSERT INTO luo_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ne romo ji alufu aboro mia abich gi piero aboro (8,580). ");
INSERT INTO luo_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Kaluwore gi chik Jehova Nyasaye mane omiyo Musa, ngʼato ka ngʼato nomi tije. Kuom mano nokwan-gi, mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Mi jo-Israel chik mondo oriemb ngʼato angʼata man-gi tuo mar del kata man-gi tuo magolo tutu kata ngʼat ma ok ler nikech osemulo ringre ngʼama otho. ");
INSERT INTO luo_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Riemb chwo kod mon duto mondo giwuok oko mar kambi; kik ginjaw kambi nikech adak e diergi.” ");
INSERT INTO luo_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Jo-Israel notimo kamano; mine giriembogi oko mar kambi. Negitimo mana kaka Jehova Nyasaye nosechiko Musa. ");
INSERT INTO luo_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Wachne jo-Israel kama: ‘Ka dichwo kata dhako okwinyo wadgi e yo moro amora kendo obedo ngʼama ok ja-ratiro ne Jehova Nyasaye, ngʼatno oketho ");
INSERT INTO luo_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","kendo nyaka ohul richo mosetimono. Nyaka ochiw chudo duto mar kethone, omed achiel kuom abich ewi chudono bangʼe ochiwe duto ne ngʼat mosekethone. ");
INSERT INTO luo_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ka ngʼat ma okethneno onge gi watne moro amora ma inyalo mi chudono, to chudono en mar Jehova Nyasaye kendo nyaka chiwe ne jadolo, ka itere gi im ma ikwayonego pwodhruok kuom richo. ");
INSERT INTO luo_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Chiwo duto mowal ma jo-Israel kelo gin mek jadolo. ");
INSERT INTO luo_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Chiwo mowal mar ngʼato ka ngʼato en mare owuon, ka osechiwe ne jadolo nobed mar jadolo.’ ” ");
INSERT INTO luo_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Wuo gi jo-Israel kendo iwachnegi kama: ‘Ka chi ngʼato ok obedo ja-adiera kendo ok obedo ja-ratiro ");
INSERT INTO luo_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","mi oterore gi dichwo moro, kendo timni opandore ne chwore ma ok ongʼere (nikech onge janeno mane onene kendo ne ok omake randoo), ");
INSERT INTO luo_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","kendo ka nyiego omako chwor dhakono mi ochich kode, to chiegeno ochido, kata kapo ni nyiego omake kode kendo ochich kode kata obedo ni ok ochido, ");
INSERT INTO luo_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","to chworeno nyaka tere ir jadolo bed ni dhakono osedwanyore adier kata chwore chich mana kode kayiem. Bende nyaka oter chiwo mar achiel kuom apar mar efa mar mogo mar shairi e lo jaode. Ok onego ool mo kuome kata keto gima dungʼ tik mangʼwe ngʼar kuome, nikech en chiwo mar cham mar ketho chich, tiende ni en chiwo mifwenyogo adiera. ");
INSERT INTO luo_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Jadolo nokel dhakono mochungʼ e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Eka notuom pi maler e agulu kendo nojow buru moa e dier kama ler mar lemo mi okwo e pigno. ");
INSERT INTO luo_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Bangʼ ka jadolo osekelo dhakono mochungʼ e nyim Jehova Nyasaye, enogony yie wiye eka noket chiwo mifwenyogo adiera e lwete ma en chiwo mar cham mitiekogo chich. Jadolo to notingʼ pi mar muma mifwenyogo adiera e lwete owuon. ");
INSERT INTO luo_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Eka jadolo noket dhakono kwongʼre kowacho niya, “Kaonge dichwo moseterore kodi kendo pod ok ibedo ja-adiera mibedo modwanyore kendo weyo yo ma ibedo mogak ka ingʼeyo ni in dhako man kod chwore, to mad pi makechni makelo kwongʼ kik hinyi. ");
INSERT INTO luo_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","To ka en adier ni isedwanyori, mi ngʼato oterore kodi, kingʼeyo ni in chi ngʼato,” ");
INSERT INTO luo_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","to jadolo nokwongʼ dhakono niya, “Jehova Nyasaye mondo omi iyi ogore piny, kata omi ibwog nyathi ka kindene mar nywol pok ochopo, kibedogo ranyisi ne jou kuom wach kwongʼruok. ");
INSERT INTO luo_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Mad pigni donj e iyi kendo omi iyi kirre kata omi ibwog nyathi ka kinde mar nywolne pok ochopo.” “ ‘Bangʼe dhakono nodwok kawacho niya, “Amin. Mad obed kamano.” ");
INSERT INTO luo_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Nyaka jadolo ndik kwongʼ-gi e Kitabu bangʼe olingʼ-gi ei pi makechno. ");
INSERT INTO luo_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Enoket dhakono mondo omodh pi makech makelo kwongʼ, kendo pigni nodonj e iye mi kelne sand mager. ");
INSERT INTO luo_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Jadolo nokaw chiwo mar cham mar golo chich koa e lwet dhakono, mi nofwaye e nyim Jehova Nyasaye kendo okele e kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Eka jadolo nojuk chiwo mar cham mopongʼo lwete kaka chiwo mar rapar kendo nowangʼe ewi kendo mar misango; bangʼ mano, noket dhakono omodh pigno. ");
INSERT INTO luo_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ka dipo ni osedwanyore en owuon kendo ok osebedo ja-ratiro ne chwore, to nokete omodh pigno makelo kwongʼ, kendo ma nomi obed gi sand mager; ma mi obwog nyathi ka ndalone pok ochopo kendo ngʼama okwongʼ e kind ogandane. ");
INSERT INTO luo_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","To ka dipo ni dhakono ok odwanyore kendo ok ochido, nokete thuolo mi ochak onywol nyithindo kendo. ");
INSERT INTO luo_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Ma e chik mar tieko chich ka dhako ok ja-adiera kendo odwanyore, kongʼeyo ni pod en dhako man-gi chwore, ");
INSERT INTO luo_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","kata ka gimoro otimore ma chwore ochich kode. Jadolo nokete ochungʼ e nyim Jehova Nyasaye kendo nyaka oket chikni ne dhakoni. ");
INSERT INTO luo_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Dichwo nobed maonge ketho moro amora, to dhakono ibiro kum ne richo mage.’ ” ");
INSERT INTO luo_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Wuo kod jo-Israel kendo inyisgi kama: ‘Ka dichwo kata dhako dwaro chiwo singruok makende, ma en singruok makende ne Jehova Nyasaye kaka ja-Nazir, ");
INSERT INTO luo_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","to nyaka owe madho divai kod math mamoko moket e thowi kendo ok onego omadh kongʼo kata kongʼo moa kuom math mamoko moket e thowi. Ok onego omadh gimoro amora molos gi olemb mzabibu, kata chamo olemb mzabibu manumu kata motwo. ");
INSERT INTO luo_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","E kinde duto ma en ja-Nazir, ok onego ocham gimoro amora mowuok kuom olemb mzabibu, bed ni en kothe kata opokone. ");
INSERT INTO luo_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘E thuoloni duto ma en e bwo singruok mar bedo tenge, wiye ok noliel gi wembe. Enorite maler ne Jehova Nyasaye nyaka ndalone mag kwongʼruok norum; kendo enopidh yie wiye maboyo. ");
INSERT INTO luo_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘E thuoloni duto ma en e bwo singruok mar bedo tenge ne Jehova Nyasaye, ok onego osud machiegni gi ringre ngʼama otho. ");
INSERT INTO luo_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Bed ni wuon-gi kata min-gi kata owadgi kata nyamin-gi ema otho, to ok onego obed mogak, nikech ranyisi mar bedo ngʼat mowal ne Nyasaye ni e wiye. ");
INSERT INTO luo_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","E kindeno duto ma okete tenge, en ngʼama owal ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘Ka dipo ni ngʼato otho bute, mi yie wiye mosewal ogak, to nyaka oliel yie wiyeno chiengʼ mar abiriyo mipwodhee. ");
INSERT INTO luo_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","To chiengʼ mar aboro nyaka okel akuch odugla ariyo kata nyithi akuru ne jadolo e dhoranga Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Jadolo nochiw achiel kaka misango mar golo richo to machielo kaka misango miwangʼo pep mar kwayone ngʼwono nikech notimo richo kuom bedo kama ringre ngʼama otho nitie. E odiechiengno nyaka opwodh wiye. ");
INSERT INTO luo_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","E kindeno duto mokete tenge nyaka ochiwre ne Jehova Nyasaye kendo okel nyaim ma hike achiel kaka misango michiwo mar pwodhruok e ketho. To kinde mane osetieko kowale ok nokwan nikech yie wiye mane nyiso ni owaleno ne odoko mogak. ");
INSERT INTO luo_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Koro mano e chik momi ja-Nazir ka kinde mokete tenge orumo kendo nyaka kele e dhoranga Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","E dhorangach kanyo ema nyaka ochiwe misangone ne Jehova Nyasaye ma gin: nyaim ma hike achiel maonge songa kaka misango miwangʼo pep, sibini ma hike achiel maonge songa kaka misango migologo richo; im maonge songa kaka chiwo mar lalruok, ");
INSERT INTO luo_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","kaachiel gi chiwo mar cham kod misango miolo piny, kod okapu mopongʼ gi makati ma ok oketie thowi kaka kek molos gi mogo mayom moru gi mo, kod chapat mowir gi mo. ");
INSERT INTO luo_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Jadolo nochiwgi e nyim Jehova Nyasaye kaka misango mar pwodhruok e richo kod misango miwangʼo pep. ");
INSERT INTO luo_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Bende nochiw okapu man-gi makati ma ok oketie thowi kod im kaka misango mar lalruok ne Jehova Nyasaye, kaachiel gi chiwo mar cham kod misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Bangʼe e dhoranga Hemb Romo, ja-Nazirno nyaka liel yie wiye mane osewal tenge. Enokaw yie wiyeno mi olute e mach mantiere e bwo misango mar chiwo mar lalruok. ");
INSERT INTO luo_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Bangʼ ka ja-Nazirno oselielo yie wiye mane osewal tenge, jadolo nomiye bad im mosechwaki, kod kek kod chapat mogoloe okapu, mago molos ma ok oketie thowi. ");
INSERT INTO luo_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Bangʼ mano jadolo noliergi e nyim Jehova Nyasaye kaka misango mifwayo; kaachiel gi agoko kod em mane olier nimar gin gik mopwodhi kendo gin mek jadolo. Bangʼ timo kamano, ja-Nazir koro nyalo mana madho divai. ");
INSERT INTO luo_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Mano e chik momako ja-Nazir mosekwongʼore kaluwore gi pwodhruok mare kendo mano e misango manyaka otimne Jehova Nyasaye kaachiel gi gimoro monyalo chiwo. Nyaka ochop singo mar kwongʼruok mane ochiwo, kaluwore gi chik mar ja-Nazir.’ ” ");
INSERT INTO luo_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Nyis Harun kod yawuote ni, ‘Ma e kaka onego ugwedh jo-Israel. Wachnegi kama: ");
INSERT INTO luo_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Jehova Nyasaye mondo ogwedhu kendo oritu; ");
INSERT INTO luo_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Wangʼ Jehova Nyasaye mondo orieny kuomu kendo omiu ngʼwono mogundho; ");
INSERT INTO luo_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Jehova Nyasaye orangu maber kendo omiu kwe.’ ");
INSERT INTO luo_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Kamano e kaka ginihul nyinga kuom jo-Israel, kendo anagwedhgi.” ");
INSERT INTO luo_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Kane Musa osetieko gero hekalu, nogwedhe, kendo owale gi gik moko duto manie iye. Bende nogwedho kendo owalo kar kendo mar misango kod gik moko duto mitiyogo e kendono. ");
INSERT INTO luo_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Eka jotelo mag Israel, ma gin jotelo mag anywola ma bende ema jotend dhoudi mane ochungʼ ne jogo mane okwan, nochiwo misengini. ");
INSERT INTO luo_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Chiwo mane gikelo e nyim Jehova Nyasaye ne gin geche auchiel moum wiye gi rwedhi mabwoch apar gariyo. Jatelo ka jatelo nogolo rwadh bwoch achiel bende jotelo ariyo noriwore mochiwo gari achiel moum wiye. Gigi duto negikelo e nyim hekalu. ");
INSERT INTO luo_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Kaw gigi koa kuomgi, mondo iti kodgi e tij Hemb Romo. Migi jo-Lawi kaluwore gi tich ngʼato ka ngʼato.” ");
INSERT INTO luo_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Omiyo Musa nokawo gechego kod rwedhi ma buochgo mi ochiwogi ne jo-Lawi. ");
INSERT INTO luo_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Nomiyo jo-Gershon geche ariyo kod rwedhi mabwoch angʼwen, kaluwore gi tijgi, ");
INSERT INTO luo_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","kendo nomiyo jo-Merari geche angʼwen kod rwedhi mabwoch aboro, kaluwore gi tijgi. Giduto ne gin e bwo loch Ithamar ma wuod Harun jadolo. ");
INSERT INTO luo_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","To joka Kohath, Musa ne ok omiyogi gimoro amora nikech tich mane omigi ne en mar tingʼo gik maler. ");
INSERT INTO luo_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Kane osegwedh kendo mar misango, jotelo nokelo chiwo mag-gi mag gweth kendo nochiwgi e nyim kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Nimar Jehova Nyasaye nosewacho ne Musa niya, “Odiechiengʼ ka odiechiengʼ jatelo achiel nyaka kel misango mare mar gwedho kendo mar misango.” ");
INSERT INTO luo_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Ngʼatno mane okelo misango mare e odiechiengʼ mokwongo ne en Nashon wuod Aminadab moa e dhood Juda. ");
INSERT INTO luo_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Chiwo mare ne en san achiel mar fedha ma pekne en shekel mia achiel gi piero adek, kod bakul achiel mar fedha mokuoyogo pi ma pekne en shekel piero abiriyo. Magi nokel kaluwore gi shekel mar kama ler mar lemo, ka moro ka moro opongʼ gi mogo mayom moru gi mo kaka chiwo mar cham; ");
INSERT INTO luo_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","bakul achiel mar dhahabu ma pekne en shekel apar, mopongʼ gi mo mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","rwath matin achiel, im achiel kod nyaim achiel matin ma hike achiel, nochiw misango miwangʼo pep; ");
INSERT INTO luo_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","nywok achiel mar kaka misango mar golo richo; ");
INSERT INTO luo_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","kod rwedhi ariyo, imbe abich, nywogi abich kod nyiimbe abich mahikgi oromo higa achiel, nochiw kaka misango mar lalruok. Magi e misengini mane Nashon wuod Aminadab ogolo. ");
INSERT INTO luo_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Nethanel wuod Zuar, ma jatend Isakar nokelo misango mare e odiechiengʼ mar ariyo. ");
INSERT INTO luo_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Misango mane okelo ne en san achiel mar fedha ma pekne ne en shekel mia achiel gi piero adek, kod bakul achiel mar kwoyo pi mar fedha ma pekne en shekel piero abiriyo. Magi nokel kaluwore gi shekel mar kama ler mar lemo, ka moro ka moro opongʼ gi mogo mayom moru gi mo kaka chiwo mar cham; ");
INSERT INTO luo_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","bakul achiel mar dhahabu ma pekne en shekel apar, mopongʼ gi mo mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","nyarwath achiel, im achiel kod nyaim achiel ma hike achiel, kaka misango miwangʼo pep; ");
INSERT INTO luo_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","nywok achiel kaka misango mar golo richo; ");
INSERT INTO luo_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","kod rwedhi mabwoch ariyo, imbe abich, nywogi abich kod nyiimbe abich mahikgi achiel, nochiw kaka misango mar lalruok. Magi e misengini mane Nethanel wuod Zuar ogolo. ");
INSERT INTO luo_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Eliab wuod Helon, ma jatend jo-Zebulun nokelo misango mare e odiechiengʼ mar adek. ");
INSERT INTO luo_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Misango mane okelo ne en san achiel mar fedha ma pekne ne en shekel mia achiel gi piero adek, kod bakul achiel mar fedha mar kwoyo pi ma pekne en shekel piero abiriyo. Giduto nokel kaluwore gi shekel mar kama ler mar lemo, ka moro ka moro opongʼ gi mogo moru gi mo kaka misango mar cham; ");
INSERT INTO luo_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","bakul achiel mar dhahabu ma pekne ne en shekel apar, mopongʼ gi mo mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","nyarwath achiel, im achiel kod nyaim achiel ma hike achiel kaka misango miwangʼo pep; ");
INSERT INTO luo_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","nywok achiel kaka misango mar golo richo; ");
INSERT INTO luo_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","kod rwedhi mabwoch ariyo, imbe abich, nywogi abich gi nyiimbe abich ma jo-higa achiel, nochiw misango mar lalruok. Magi e misengini mane Eliab wuod Helon ogolo. ");
INSERT INTO luo_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Elizur wuod Shedeur, ma jatend joka Reuben nokelo misango mare e odiechiengʼ mar angʼwen. ");
INSERT INTO luo_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Misango mane okelo ne en san achiel mar fedha ma pekne ne en shekel mia achiel gi piero adek, kod bakul achiel mar fedha mar kwoyo pi ma pekne en shekel piero abiriyo. Mago nokel ka giluwore gi shekel mar kama ler mar lemo, ka moro ka moro opongʼ gi mogo mayom moru gi mo kaka misango mar cham; ");
INSERT INTO luo_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","bakul achiel mar dhahabu ma pekne en shekel apar, mopongʼ gi mo mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","rwath matin achiel, im achiel kod nyaim achiel matin ma hike achiel, nochiw kaka misango miwangʼo pep; ");
INSERT INTO luo_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","nywok achiel kaka misango mar golo richo; ");
INSERT INTO luo_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","kod rwedhi ariyo, imbe abich, nywogi abich kod nyiimbe mahikgi oromo higa achiel, nochiw kaka misango mar lalruok. Magi e misengini mane Elizur wuod Shedeur ochiwo. ");
INSERT INTO luo_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Shelumiel wuod Zurishadai, ma jatend joka Simeon nokelo misango mare e odiechiengʼ mar abich. ");
INSERT INTO luo_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Misango mane okelo ne en san achiel mar fedha ma pekne ne en shekel mia achiel gi piero adek, kod bakul achiel mar fedha mar kwoyo pi ma pekne en shekel piero abiriyo. Mago nokel kaluwore gi shekel mar kama ler mar lemo, ka moro ka moro opongʼ gi mogo mayom moru gi mo kaka misango mar cham; ");
INSERT INTO luo_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","bakul achiel mar dhahabu ma pekne en shekel apar, mopongʼ gi mo mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","rwath matin achiel, im achiel kod nyaim matin achiel ma hike achiel, nochiw kaka misango miwangʼo pep; ");
INSERT INTO luo_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","nywok achiel kaka misango mar golo richo; ");
INSERT INTO luo_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","gi rwedhi ariyo, imbe abich, nywogi abich kod nyiimbe mahikgi oromo higa achiel, nochiw kaka misango mar lalruok. Magi e misengini mane Shelumiel wuod Zurishadai ochiwo. ");
INSERT INTO luo_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Eliasaf wuod Dewel, ma jatend joka Gad nokelo misango mare e odiechiengʼ mar auchiel. ");
INSERT INTO luo_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Misango mane okelo ne en san achiel mar fedha ma pekne ne en shekel mia achiel gi piero adek, kod bakul achiel mar fedha mar kwoyo pi ma pekne en shekel piero abiriyo. Mago nokel kaluwore gi shekel mar kama ler mar lemo, ka moro ka moro opongʼ gi mogo mayom moru gi mo kaka misango mar cham; ");
INSERT INTO luo_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","bakul achiel mar dhahabu ma pekne en shekel apar, mopongʼ gi mo mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","rwath matin achiel, im achiel kod nyaim matin achiel ma hike achiel, nochiw kaka misango miwangʼo pep; ");
INSERT INTO luo_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","nywok kaka misango mar golo richo; ");
INSERT INTO luo_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","gi rwedhi mabwoch ariyo, imbe abich, nywogi abich kod nyiimbe abich ma jo-higa achiel, nochiw kaka misango mar lalruok. Magi e misengini mane Eliasaf wuod Dewel ochiwo. ");
INSERT INTO luo_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Elishama wuod Amihud, ma jatend joka Efraim nokelo misango mare e odiechiengʼ mar abiriyo. ");
INSERT INTO luo_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Misango mare mane okelo ne en san achiel mar fedha ma pekne ne en shekel mia achiel gi piero adek, kod bakul achiel mar fedha mar kwoyo pi ma pekne en shekel piero abiriyo. Mago nokel kaluwore gi shekel mar kama ler mar lemo, ka moro ka moro opongʼ gi mogo mayom moru gi mo kaka misango mar cham; ");
INSERT INTO luo_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","bakul achiel mar dhahabu ma pekne ne en shekel apar, mopongʼ gi mo mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","rwath matin achiel, im achiel kod nyaim matin achiel ma hike achiel, nochiw kaka misango miwangʼo pep; ");
INSERT INTO luo_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","nywok achiel kaka misango mar golo richo; ");
INSERT INTO luo_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","gi rwedhi mabwoch ariyo, imbe abich, nywogi abich kod nyiimbe abich ma jo-higa achiel, nochiw kaka misango mar lalruok. Mago e misengini mane Elishama wuod Amihud ochiwo. ");
INSERT INTO luo_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Gamaliel wuod Pedazur, ma jatend joka Manase, nokelo misango mare e odiechiengʼ mar aboro. ");
INSERT INTO luo_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Misango mane okelo ne en san achiel mar fedha ma pekne en shekel mia achiel gi piero adek, kod bakul achiel mar fedha mar kwoyo pi ma pekne en shekel piero abiriyo. Mago nokel kaluwore gi shekel mar kama ler mar lemo, ka moro ka moro opongʼ gi mogo mayom moru gi mo kaka misango mar cham; ");
INSERT INTO luo_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","bakul achiel mar dhahabu ma pekne en shekel apar, mopongʼ gi mo mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","rwath matin achiel, im achiel kod nyaim matin achiel ma hike achiel, nochiw kaka misango miwangʼo pep; ");
INSERT INTO luo_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","nywok achiel kaka misango mar golo richo; ");
INSERT INTO luo_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","gi rwedhi mabwoch ariyo, imbe abich, nywogi abich, kod nyiimbe abich ma jo-higa achiel, nochiw kaka misango mar lalruok. Mago e misengini mane Gamaliel wuod Pedazur ochiwo. ");
INSERT INTO luo_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Abidan wuod Gideoni, ma jatend joka Benjamin, nokelo misango mare e odiechiengʼ mar ochiko. ");
INSERT INTO luo_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Misango mane okelo ne en san achiel mar fedha ma pekne ne en shekel mia achiel gi piero adek, kod bakul mar fedha mar kwoyo pi ma pekne ne en shekel piero abiriyo. Mago nokel kaluwore gi shekel mar kama ler mar lemo, ka moro ka moro opongʼ gi mogo mayom moru gi mo kaka misango mar cham; ");
INSERT INTO luo_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","bakul achiel mar dhahabu ma pekne en shekel apar, mopongʼ gi mo mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","rwath matin achiel, im achiel kod nyaim achiel ma hike achiel, nochiw kaka misango miwangʼo pep; ");
INSERT INTO luo_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","nywok achiel kaka misango mar golo richo; ");
INSERT INTO luo_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","gi rwedhi mabwoch ariyo, imbe abich, nywogi abich gi nyiimbe abich ma jo-higa achiel, nochiw kaka misango mar lalruok. Mago e misengini mane Abidan wuod Gideoni ochiwo. ");
INSERT INTO luo_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ahiezer wuod Amishadai, ma jatend joka Dan, nokelo misango mare e odiechiengʼ mar apar. ");
INSERT INTO luo_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Misango mane okelo ne en san achiel mar fedha ma pekne ne en shekel mia achiel gi piero adek, kod bakul achiel mar fedha mar kwoyo pi ma pekne ne en shekel piero abiriyo. Mago nokel kaluwore gi shekel mar kama ler mar lemo, ka moro ka moro opongʼ gi mogo mayom moru gi mo kaka misango mar cham; ");
INSERT INTO luo_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","bakul achiel mar dhahabu ma pekne ne en shekel apar, mopongʼ gi mo mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","rwath matin achiel, im achiel kod nyaim matin achiel ma hike achiel, nochiw kaka misango miwangʼo pep; ");
INSERT INTO luo_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","nywok achiel kaka misango mar golo richo; ");
INSERT INTO luo_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","gi rwedhi mabwoch ariyo, imbe abich, nywogi abich gi nyiimbe abich ma jo-higa achiel, nochiw kaka misango mar lalruok. Mago e misengini mane Ahiezer wuod Amishadai ogolo. ");
INSERT INTO luo_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Pagiel wuod Okran, ma jatend joka Asher, nokelo misango mare odiechiengʼ mar apar gachiel. ");
INSERT INTO luo_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Misango mane okelo ne en san achiel mar fedha ma pekne ne en shekel mia achiel gi piero adek, kod bakul achiel mar fedha mar kwoyo pi ma pekne ne en shekel piero abiriyo. Mago nokel kaluwore gi shekel mar kama ler mar lemo, ka moro ka moro opongʼ gi mogo mayom moru gi mo kaka misango mar cham; ");
INSERT INTO luo_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","bakul achiel mar dhahabu ma pekne ne en shekel apar, mopongʼ gi mo mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","rwath matin achiel, im achiel kod nyaim achiel ma hike achiel, nochiw kaka misango miwangʼo pep; ");
INSERT INTO luo_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","nywok achiel kaka misango mar golo richo; ");
INSERT INTO luo_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","gi rwedhi mabwoch ariyo, imbe abich, nywogi abich gi nyiimbe abich ma jo-higa achiel, nochiw kaka misango mar lalruok. Mago e misengini mane Pagiel wuod Okran ochiwo. ");
INSERT INTO luo_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ahira wuod Enan, ma jatend joka Naftali, nokelo misango mare e odiechiengʼ mar apar gariyo. ");
INSERT INTO luo_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Misango mare mane okelo ne en san achiel mar fedha ma pekne ne en shekel mia achiel gi piero adek, kod bakul achiel mar fedha mar kwoyo pi ma pekne ne en shekel piero abiriyo. Mago nokel kaluwore gi shekel mar kama ler mar lemo, ka moro ka moro opongʼ gi mogo mayom moru gi mo kaka misango mar cham; ");
INSERT INTO luo_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","bakul achiel mar dhahabu ma pekne ne en shekel apar, mopongʼ gi mo mangʼwe ngʼar; ");
INSERT INTO luo_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","nyarwath achiel, im achiel kod nyaim achiel ma hike achiel, nochiw misango miwangʼo pep; ");
INSERT INTO luo_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","nywok achiel kaka misango mar golo richo; ");
INSERT INTO luo_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","gi rwedhi mabwoch ariyo, imbe abich, nywogi abich kod nyiimbe abich ma jo-higa achiel, nochiw kaka misango mar lalruok. Mago e misengini mane Ahira wuod Enan ochiwo. ");
INSERT INTO luo_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Misengini mane jotend jo-Israel okelo e kinde mane ogwedh kendo mar misango e magi: sende mag fedha apar gariyo, bakunde mag fedha mag kwoyo pi apar gariyo kod dise mag dhahabu apar gariyo. ");
INSERT INTO luo_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","San ka san mar fedha pekne ne en shekel mia achiel gi piero adek, kendo bakul ka bakul mar kwoyo pi pekne ne en shekel piero abiriyo. Dise duto mag fedha pekgi noromo shekel alufu ariyo gi mia angʼwen (2,400), kaluwore gi shekel mar kama ler mar lemo. ");
INSERT INTO luo_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Dise apar gariyo mag dhahabu mane opongʼ gi mo mangʼwe ngʼar pekgi noromo shekel apar moro ka moro, kaluwore gi shekel mar kama ler mar lemo. Dise duto mag dhahabu pekgi noromo shekel mia achiel gi piero ariyo. ");
INSERT INTO luo_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Kar kwan mar jamni mane ochiw kaka misango miwangʼo pep noromo nyirwedhi apar gariyo, imbe apar gariyo kod nyiimbe apar gariyo mahikgi achiel, kaachiel gi misango mag cham. Nywogi apar gariyo notigo kaka misango mar golo richo. ");
INSERT INTO luo_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Kar kwan jamni duto mane ochiw kaka misango mar lalruok noromo rwedhi mabwoch piero ariyo gangʼwen, imbe piero auchiel, nywogi piero auchiel kod nyiimbe piero auchiel ma jo-higa achiel. Magi e misengini mane ochiw e kendo mar misango kane osepwodhe. ");
INSERT INTO luo_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Kane Musa odonjo e Hemb Romo mondo owuo gi Jehova Nyasaye, nowinjo dwond Jehova Nyasaye kawuoyo kode koa e kind kerubi ariyo manie wi raum mar Sandug Muma mar Singruok. Kendo Musa nowuoyo kode. ");
INSERT INTO luo_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Wuo gi Harun kendo iwachne kama: ‘Ka iketo teyni abiriyo kuonde mowinjore, to nyaka ler margi meny nyim rachung taya.’ ” ");
INSERT INTO luo_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Harun notimo kamano; noketo teyni kuonde mowinjore ka gimenyo nyim rachung taya, mana kaka Jehova Nyasaye nosechiko Musa. ");
INSERT INTO luo_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ma e kaka rachung taya nolosi: Nolose gi dhahabu mothedhi chakre e bwoye nyaka wiye malo. Rachung taya nolosi mana kaka ranyisi mane Jehova Nyasaye osenyiso Musa. ");
INSERT INTO luo_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Wal jo-Lawi e kind jo-Israel mamoko kendo pwodhgi gibed maler. ");
INSERT INTO luo_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Kipwodhogi, to itim kama: Kwo pi mipwodhogigo kuomgi; bangʼe giliel yie dendgi duto kendo giluok lepgi, eka gibed joma opwodhi. ");
INSERT INTO luo_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Nyisgi gikaw nyarwath kaachiel gi misango mar cham mar mogo mayom moru gi mo; bangʼe ikaw nyarwath matin mar ariyo kaka misango mar golo richo. ");
INSERT INTO luo_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Kel jo-Lawi e nyim Hemb Romo kendo ichok oganda duto mar dhood Israel. ");
INSERT INTO luo_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Nyaka ikel jo-Lawi e nyim Jehova Nyasaye, mondo jo-Israel nyaka oyie lwetgi kuomgi. ");
INSERT INTO luo_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Harun nyaka kel jo-Lawi e nyim Jehova Nyasaye kaka misango mifwayo koa kuom jo-Israel, mondo omi gibed moikore ne tij Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Bangʼ ka jo-Lawi oseketo lwetgi ewi rwedhigo, to chiw achiel kuomgi ne Jehova Nyasaye kaka misango mar golo richo, to machielo chiw kaka misango miwangʼo pep mipwodhogo jo-Lawi mondo ngʼwon-nigi. ");
INSERT INTO luo_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ket jo-Lawi ochungʼ e nyim Harun kod yawuote bangʼe ichiwgi kaka misango mifwayo ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ma e kaka onego iwal jo-Lawi e kind jo-Israel mamoko mondo obed maga. ");
INSERT INTO luo_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Bangʼ ka isepwodho jo-Lawi kendo ichiwogi kaka misango mifwayo, to nyaka gibi mondo gitim tijgi e Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Gin e jo-Israel manyaka chiw chuth ne an. Asekawogi kaka meka awuon e lo kayo ma en nyodo mokwongo ma wuowi mar ja-Israel. ");
INSERT INTO luo_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Nyathi moro amora ma wuowi mokwongo ma ja-Israel bed ni en dhano kata chiayo, en mara. Kane anego kayo duto man Misri, ne awalogi gibedo maga. ");
INSERT INTO luo_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Bende aseketo jo-Lawi duto obedo e lo yawuowi makayo e Israel. ");
INSERT INTO luo_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Kuom jo-Israel duto, asechiwo jo-Lawi kaka mich ne Harun gi yawuote mondo giti tij lemo e Hemb Romo e lo jo-Israel kendo mondo gikelnegi resruok kuom masira manyalo mako jo-Israel ka gisudo machiegni gi kama ler mar lemo.” ");
INSERT INTO luo_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa gi Harun kod oganda jo-Israel duto notimone jo-Lawi gigo duto mane Jehova Nyasaye ochiko Musa. ");
INSERT INTO luo_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Jo-Lawi nopwodhore giwegi kendo negiluoko lepgi. Bangʼ mano Harun nochiwogi e nyim Jehova Nyasaye kaka misango mifwayo mi notimonegi misango mondo opwodhgigo. ");
INSERT INTO luo_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Bangʼ mano, jo-Lawi nobiro tiyo tijgi e Hemb Romo kotelnegi gi Harun kod yawuote. Negitimone jo-Lawi mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Ma e kaka jo-Lawi biro tiyo: Joma chwo mahikgi piero ariyo gabich kata moloyo kanyo nobi mondo obed achiel kuom jotich e Hemb Romo, ");
INSERT INTO luo_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","to ka giromo higni piero abich, to giniwe tich. ");
INSERT INTO luo_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ginyalo konyo owetegi e tije mag Hemb Romo, to gin giwegi ok onego gimul tich moro amora. Ma e kaka ibiro pogo tije ne jo-Lawi.” ");
INSERT INTO luo_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Jehova Nyasaye nowuoyo gi Musa e Thim mar Sinai e dwe mokwongo mar higa mar ariyo bangʼ kane gisewuok Misri. Nowachone niya, ");
INSERT INTO luo_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Ket jo-Israel otim nyasi mar Pasaka e kinde moketne mowinjore. ");
INSERT INTO luo_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Tim nyasini e kinde moketne, ma en kinde mag odhiambo mar odiechiengʼ mar apar gangʼwen mar dweni, kaluwore gi chikene kod buchene duto.” ");
INSERT INTO luo_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Omiyo Musa nowacho ne jo-Israel mondo otim nyasi mar Pasaka, ");
INSERT INTO luo_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","kendo negitimo kamano e Thim mar Sinai e kinde mag odhiambo mar odiechiengʼ mar apar gangʼwen mar dwe mokwongo. Jo-Israel notimo gik moko duto mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","To jomoko kuomgi ne ok obedo e nyasi mar Pasaka e odiechiengʼno nikech negibedo mogak bangʼ mulo ringre joma otho. Omiyo negibiro ir Musa kod Harun mana godiechiengno ");
INSERT INTO luo_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","mi giwachone Musa niya, “Wasebedo mogak nikech wamulo ringre joma otho, to en angʼo momiyo ditamwa chiwo misango ne Jehova Nyasaye kaka jo-Israel mamoko e kinde moketne?” ");
INSERT INTO luo_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa nodwokogi niya, “Horeuru nyaka angʼe gima Jehova Nyasaye wacho kuomu.” ");
INSERT INTO luo_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Eka Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Nyis jo-Israel kama: ‘Ka ngʼato angʼata kuomu kata nyikwau obedo mogak nikech ringruok motho kata ka gidhi wuoth, to pod ginyalo mana timo nyasi mar Pasaka mar Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Nyasini ginitim chiengʼ mar apar gangʼwen mar dwe mar ariyo e seche mag odhiambo. Ginicham nyarombo, kaachiel gi makati ma ok oketie thowi kod alode makech. ");
INSERT INTO luo_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Kik giwe chiemogo machop okinyi bende kik gitur choke rombono. E kinde ma gitimo nyasi mar Pasaka nyaka gine ni giluwo chike duto. ");
INSERT INTO luo_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","To ka ngʼat ma ok ogak kendo ma ok odhi wuoth otamore timo nyasi mar Pasaka, ngʼatno nyaka gol oko kuom jogi nikech ne ok ochiwo misango ne Jehova Nyasaye e kinde moketne. Ngʼat ma kamano noyud kum moromore gi richone. ");
INSERT INTO luo_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Japiny moro modak kodu madwaro timo nyasi mar Pasaka mar Jehova Nyasaye nyaka tim kamano kaluwore gi chikene kod buchene. Nyaka ubed gi chike machalre ne japiny moro kod ngʼat monywol e gwengʼno.’ ” ");
INSERT INTO luo_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","E odiechiengʼ mane osetiek gero kar lemo, ma en Hema mar Singruok, bor polo noume. Chakre odhiambo nyaka okinyi bor polo mane oumo kar lemo ne chalo ka mach. ");
INSERT INTO luo_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Mano e kaka nochalo ka bor polo oume godiechiengʼ to gotieno ochalo ka mach. ");
INSERT INTO luo_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","E kinde moro amora ma bor polo ne oa ewi Hema, jo-Israel ne chako wuoth; to e kinde ma bor polo nopiyo ewi Hema, jo-Israel ne goyo kambi. ");
INSERT INTO luo_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Kane Jehova Nyasaye ogolo chik, to jo-Israel ne chako wuoth, kendo kane ogolo chik to negigoyo kambi. E kinde duto ma bor polo nosiko ewi kar lemo, negisiko e kambi. ");
INSERT INTO luo_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Kane bor polo osiko koumo kar lemo kuom thuolo malach, jo-Israel norito buche Jehova Nyasaye kendo ne ok giwuok. ");
INSERT INTO luo_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Seche moko bor polo neumo kar lemo kuom ndalo manok kende; to ka Jehova Nyasaye nogolo chik to negidak, bangʼe kochako ogolo chik to gichako wuoth. ");
INSERT INTO luo_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Seche moko bor polo ne ni kanyo chakre odhiambo nyaka okinyi kende, to kane oyawore gokinyi to negichako wuoth. Bed ni en odiechiengʼ kata otieno, to e kinde ma bor polo noyawore, negichako wuoth. ");
INSERT INTO luo_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Bed ni bor polo nosiko koumo kar lemo kuom ndalo ariyo, dwe achiel kata higa achiel, to jo-Israel ne siko e kambi kendo ne ok gichak wuoth; to ka bor polono ne oyawore, to negichako wuoth. ");
INSERT INTO luo_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Kane Jehova Nyasaye ogolo chik negibet e kambi, kendo kane ochako ogolo chik to negichako wuoth. Negirito weche Jehova Nyasaye, kaluwore gi chik mane ochiwo kokalo kuom Musa. ");
INSERT INTO luo_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Los turumbete ariyo mag fedha mothedhi, kendo ti kodgi kuom choko oganda duto kanyakla mondo mi gichak wuoth. ");
INSERT INTO luo_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ka turumbete ariyogi oywak, to ogandagi mondo ochokre e nyimi e dhoranga Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ka turumbete achiel kende ema oywak, to jotelo mag oganda, jo-Israel nyaka chokre e nyimi. ");
INSERT INTO luo_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ka turumbete oywak, to dhoudi mantie yo wuok chiengʼ nyaka chak wuoth. ");
INSERT INTO luo_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ka turumbete mar ariyo oywak, to dhoudi mantie yo milambo nyaka chak wuoth. Ywak mar turumbeteno ema nobed ranyisi mar chako wuoth. ");
INSERT INTO luo_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ka ichoko ji kanyakla, to ywak turumbetego nyaka pogre. ");
INSERT INTO luo_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Yawuot Harun, ma gin jodolo, ema nogo turumbete. Ma en chik mosiko ne un kod tiengʼ mabiro. ");
INSERT INTO luo_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ka udhi kedo gi wasiku ma thirou e pinyu owuon, to nyaka ugo turumbete. Bangʼe Jehova Nyasaye ma Nyasachu noparu kendo noresu e lwet wasiku. ");
INSERT INTO luo_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Bende e kinde ma un gi mor, ma gin kinde sewni moyier kaka nyasi mar Dwe Manyien, nyaka ugo turumbete e kinde muchiwoe misengini miwangʼo pep kod misengini mag lalruok, nikech ginibednu rapar e nyim Nyasachu nimar An e Jehova Nyasaye ma Nyasachu.” ");
INSERT INTO luo_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","E odiechiengʼ mar piero ariyo mar dwe mar ariyo e higa mar ariyo, bor polo nowuok ewi Hemb Romo mar Sandug Muma mar Singruok. ");
INSERT INTO luo_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Eka jo-Israel nowuok koa e Thim mar Sinai kendo ne giwuotho kuonde duto nyaka bor polo nopie e Thim mar Paran. ");
INSERT INTO luo_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Chako wuodhgi mokwongo notimore bangʼ ka Jehova Nyasaye nosegolo chik kokalo kuom Musa. ");
INSERT INTO luo_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Jo-Juda ema ne okwongo wuok ka gin e bwo bandechgi, kotelnegi gi Nashon wuod Aminadab. ");
INSERT INTO luo_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Dhood Isakar notelnegi gi Nethanel wuod Zuar, ");
INSERT INTO luo_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","to Eliab wuod Helon notelo ne dhood Zebulun. ");
INSERT INTO luo_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Bangʼe ne gibano Hemb Romo, kendo joka Gershon kod joka Merari mane otingʼe, nochako wuoth. ");
INSERT INTO luo_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Dhood joka Reuben nowuok bangʼ-gi ka gin e bwo bandechgi, kotelnegi gi Elizur wuod Shedeur. ");
INSERT INTO luo_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Dhood Simeon notelnegi gi Shelumiel wuod Zurishadai, ");
INSERT INTO luo_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","to Eliasaf wuod Dewel notelo ne dhood Gad. ");
INSERT INTO luo_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Bangʼe jo-Kohath nochako wuoth ka gitingʼo gik maler nikech Hemb Romo nyaka ne gur kapok gichopo. ");
INSERT INTO luo_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Bangʼe jo-Efraim nochako wuoth ka gin e bwo bandechgi kotelnegi gi Elishama wuod Amihud. ");
INSERT INTO luo_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Dhood Manase notelnegi gi Gamaliel wuod Pedazur, ");
INSERT INTO luo_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","to Abidan wuod Gideoni notelo ne dhood Benjamin. ");
INSERT INTO luo_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Dhood Dan ema ne ochako wuoth mogik e bwo bandechgi kotelnegi gi Ahiezer wuod Amishadai. ");
INSERT INTO luo_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Dhood Asher notelne gi Pagiel wuod Okran, ");
INSERT INTO luo_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","to Ahira wuod Enan notelo ne dhood Naftali. ");
INSERT INTO luo_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ma e kaka chenro mar jo-Israel nobet kane gichako wuoth. ");
INSERT INTO luo_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa nowacho ne Hobab wuod Reuel ja-Midian, ma en jaduongʼne niya, “Wawuok wadhi kama Jehova Nyasaye nowacho ni obiro miyowa. Kuom mano bi kodwa mondo wadhi e piny maber mane Jehova Nyasaye osingo ne jo-Israel kendo wabiro miyi kar dak.” ");
INSERT INTO luo_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Nodwoke niya, “Ooyo, ok anadhi kodu; to adok thurwa ir jowa.” ");
INSERT INTO luo_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa to nowachone niya, “Ka iyie to kik iwewa. In ema ingʼeyo kambi monego wadhi wadagie thimni, kendo in e wangʼwa. ");
INSERT INTO luo_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ka idhi kodwa, to wabiro pogoni gimoro amora maber ma Jehova Nyasaye omiyowa.” ");
INSERT INTO luo_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Omiyo ne giwuok ka gia e got mar Jehova Nyasaye kendo ne giwuotho kuom ndalo adek. Sandug Muma mar Jehova Nyasaye nodhi nyimgi e ndalo adekgo mondo oiknegi kama ginyalo yweyoe. ");
INSERT INTO luo_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Bor polo mar Jehova Nyasaye noumogi godiechiengʼ kane giwuok e kargi mar bworo. ");
INSERT INTO luo_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Pile kane gisechako wuoth gi Sandug Muma, Musa ne wacho niya, “Yaye Jehova Nyasaye, aa malo! Mad wasiki okee; kendo jomamon kodi oringi oa e nyimi!” ");
INSERT INTO luo_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Kinde duto mane oyie Sandug Muma piny, Musa ne wacho niya, “Yaye Jehova Nyasaye, duogi ir oganda jo-Israel mangʼenygi.” ");
INSERT INTO luo_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Kane koro ji ngʼur ne Jehova Nyasaye kuom chandruok mane gineno, kendo kane owinjo ngʼurgino mirimbe nomedore. Kuom mano mach mane oa kuom Jehova Nyasaye noliel e kindgi mi owangʼo bath kambi konchiel. ");
INSERT INTO luo_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Kane ji oywak ne Musa, ne olamo Jehova Nyasaye mi mach notho. ");
INSERT INTO luo_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Omiyo kanyo noluong ni Tabera (tiende ni Kama Mach osewangʼo) nikech mach moa kuom Jehova Nyasaye nosewangʼo bath kambi konchiel e kindgi. ");
INSERT INTO luo_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Joma yoreyore mane obiro kodgi nochako dwaro chiemo mamoko, kendo jo-Israel nochako ywak kawacho niya, “Mad debed ni wan gi ringʼo ma wanyalo chamo! ");
INSERT INTO luo_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Mano kaka waparo rech mane wachamo Misri maonge chudo moro amora, bende waparo olembe mopogore opogore, kitungu kod kitungu marachar. ");
INSERT INTO luo_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Koro sani waonge gi ndhandhu mar chiemo; kendo ok wane gimoro amora makmana manna-gi!” ");
INSERT INTO luo_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna-no ne chalo gi kothe matindo tindo marachere kendo ma kitgi ne chalo gi duogo. ");
INSERT INTO luo_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Ji ne wuok gokinyi michok manna-go bangʼe giregogi e pongʼ lwedo kata yokogi e pany. Ne gitedogi e agulu kata dwalogi ka ngʼama dwalo makati. Bende ne gichalo gimoro molos gi mo zeituni. ");
INSERT INTO luo_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Kane thoo omako kambi gotieno, to manna bende ne lwar piny. ");
INSERT INTO luo_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa nowinjo ji duto moa e anywola ka anywola kaywak, ka moro ka moro ochungʼ e dho hembe. Jehova Nyasaye iye nomedo owangʼ kendo kihondko nomako Musa. ");
INSERT INTO luo_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Nopenjo Jehova Nyasaye niya, “En angʼo momiyo isekelo chandruok ma kama ne jatichni? En angʼo ma asetimo ma ok mori momiyo imiya tingʼ mapek mar jogi duto? ");
INSERT INTO luo_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Bende ne amako ich mar jogi duto? Bende ne anywologi? Angʼo momiyo iwachona mondo akaw tingʼ-gi ka atingʼogi e kora mana kaka japidi tingʼo nyithindo matindo, mondo atergi e piny mane isingori ne kweregi ni nitergie. ");
INSERT INTO luo_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Dayud ringʼo madirom jogi kanye? Gisiko ka giywakna ni, ‘Miwa ringʼo mondo wacham!’ ");
INSERT INTO luo_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ok anyal tingʼo jogi duto kenda awuon; gipek mohewa. ");
INSERT INTO luo_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ka mano e kaka idwaro tiyo koda, to nega sani, to ka dipo ni ikecha, to yie iwe miya chandruok ma kama.” ");
INSERT INTO luo_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Omiyo Jehova Nyasaye nowacho ne Musa kama: “Kelna jodong Israel piero abiriyo ma ingʼeyo ni jotelo kendo ruodhi. Kelgi e Hemb Romo kendo gichungʼ kodi kanyo. ");
INSERT INTO luo_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Abiro lor mondo awuo kodi kanyo, kendo abiro kawo teko mar loch moko kuomi mane amiyi kendo ami jogo. Gibiro konyi rito ogandano makoro tingʼno ok noturi kendi. ");
INSERT INTO luo_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Nyis jo-Israel kama: ‘Pwodhreuru ka uikoru ne kiny ma ubiro chamoe ringʼo; nimar Jehova Nyasaye osewinjo ywak maru niya, “Mad dibed ni nitie kama wanyalo yudoe ringʼo mwachamo! Ne wawinjo maber e piny Misri!” Omiyo koro Jehova Nyasaye nomiu ringʼo, ma ubiro chamo. ");
INSERT INTO luo_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ok unuchame mana kuom ndalo achiel kende, kata ndalo ariyo, kata ndalo abich, kata apar kata piero ariyo, ");
INSERT INTO luo_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","to unuchame kuom dwe achiel, manyaka othingʼu mi ungʼogi nikech usedagi Jehova Nyasaye modak e kindu kendo useywak e nyima, kuwacho niya, “Angʼo momiyo ne waa Misri?” ’ ” ");
INSERT INTO luo_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","To Musa nodwoko niya, “Antie gi ji alufu mia achiel mawuotho gi tiendgi, to in to iwacho ni, ‘Abiro miyogi ringʼo moromogi chamo kuom dwe achiel mangima!’ ");
INSERT INTO luo_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Bende ginyalo yiengʼ ka kweth mag jamni kod kweth mag dhok oyangʼ duto? Bende ginyalo yiengʼ ka rech duto manie nam omaknegi?” ");
INSERT INTO luo_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Jehova Nyasaye nopenjo Musa niya, “Bende nitie gima nyalo tamo Jehova Nyasaye? Kawuononi ibiro ngʼeyo ka wechena gin adier kata ok adier.” ");
INSERT INTO luo_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Omiyo Musa nowuok kendo nonyiso ji gima Jehova Nyasaye nowacho. Nokelo jodong-gi piero abiriyo ma gichokore kanyakla kendo noketogi duto gichungʼ ka gilworo Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Eka Jehova Nyasaye nolor e bor polo mi owuoyo kode, kendo nokawo teko moko mane osemiye mi omiyo jodongo piero abiriyogo. Kane Roho odonjo kuomgi, ne gikoro wach, to bangʼ mano ne ok gichako gitimo kamano kendo. ");
INSERT INTO luo_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Kata kamano, ji ariyo ma nying-gi Eldad kod Medad, mane osekwan kaachiel gi jodongo piero abiriyo-ka nodongʼ e kambi. To kata kane ok gidhi e Hemb Romo kamano, Roho nobiro kuomgi mi gikoro wach e kambi. ");
INSERT INTO luo_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Rawera moro noringo mi odhi ir Musa mowachone niya, “Eldad kod Medad koro wach e kambi.” ");
INSERT INTO luo_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joshua wuod Nun, mane jakony Musa chakre tin-ne, nowacho ne Musa niya, “Ruodha, kwergi!” ");
INSERT INTO luo_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","To Musa nodwoko niya, “Nyiego omaki nikech wachna? Mad ne oganda duto mag Jehova Nyasaye bed jonabi mi oket Roho mare kuomgi!” ");
INSERT INTO luo_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Eka Musa kod jodong Israel nodok e kambi. ");
INSERT INTO luo_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Eka Jehova Nyasaye notugo yamo mokelo aluru koa e nam. Yamo nokelogi ma gichokore e alwora mar kambi madirom fut adek koa piny, kendo kama ne gichokoreno ne nyalo romo wuoth mar ndalo achiel. ");
INSERT INTO luo_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Odiechiengno duto kod otieno gi odiechiengʼ maluwe duto ji nowuok kendo nochoko aluru. Onge ngʼama nochoko aluru matin ne atonge apar. Bangʼe ne gimoyogi e kambi mondo gituo. ");
INSERT INTO luo_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","To kane pok gimuonyo ring alurugo, mirimb Jehova Nyasaye nomedore kuomgi, kendo nonegogi gi masira malich. ");
INSERT INTO luo_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Omiyo kanyo noluongi ni Kibroth Hatava, nikech kanyo ema ne giyikoe joma ne wuoch ringʼo omako. ");
INSERT INTO luo_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Koa Kibroth Hatava, ji nodhi nyaka Hazeroth kendo negidak kanyo. ");
INSERT INTO luo_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriam kod Harun nochako wuoyo marach kuom Musa nikech jaode ma nyar jo-Kush, nimar ne onywomo nyar Kush. ");
INSERT INTO luo_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Negipenjore niya, “Bende Jehova Nyasaye osewuoyo kokalo kuom Musa kende? Donge osewuoyo kokalo kuomwa bende?” Kendo Jehova Nyasaye nowinjo ma. ");
INSERT INTO luo_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Musa ne en ngʼama obolore, ngʼat mobolore moloyo ngʼato angʼata manie wangʼ piny.) ");
INSERT INTO luo_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Gikanyono Jehova Nyasaye nowacho ne Musa, Harun kod Miriam niya, “Wuoguru oko e Hemb Romo karu ji adekgo.” Omiyo giduto ne giwuok oko. ");
INSERT INTO luo_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Eka Jehova Nyasaye nolor e bor polo; mochungʼ e dho Hemb Romo kendo noluongo Harun gi Miriam. Kane gibiro kargi ji ariyogo, ");
INSERT INTO luo_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","nowachonegi niya, “Winjuru wechena: “Ka janabi mar Jehova Nyasaye nitie e dieru, to abiro afwenyorane, kendo awuoyo kode e lek. ");
INSERT INTO luo_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","To ma ok en adiera kuom jatichna Musa; nikech en ja-ratiro e oda duto. ");
INSERT INTO luo_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","En awuoyo kode wangʼ gi wangʼ, awuoyo kode maler ma ok gi ngeche; kendo oneno tich Jehova Nyasaye. Angʼo momiyo ne ok uluor ka uwuoyo kuom jatichna Musa?” ");
INSERT INTO luo_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Mirimb Jehova Nyasaye nomedore kuomgi, kendo no-aa oweyogi. ");
INSERT INTO luo_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Kane bor polo owalore oa ewi Hemb Romo, Miriam noa malo ka dende obawore gi dhoho mobedo marachar ka pe. Harun nolokore mongʼiye kendo noneno ka en-gi dhoho, ");
INSERT INTO luo_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","kendo nowacho ne Musa niya, “Yaye, ruodha, kik iwe wachul gowi mar richo kata obedo ni wasetimo gima ofuwoni. ");
INSERT INTO luo_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Kik iweye ochal gi nyathi mobwogi ma aa ei min-gi ka en-gi ringruok mokethore.” ");
INSERT INTO luo_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Omiyo Musa noywak ne Jehova Nyasaye niya, “Yaye Nyasaye, yie ichange!” ");
INSERT INTO luo_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Jehova Nyasaye nodwoko Musa niya, “Ka wuon-gi ne nyalo ngʼudho olawo e wangʼe, donge dine obedo gi wichkuot kuom ndalo abiriyo? Wale obed tenge kuom ndalo abiriyo; bangʼ mano inyalo duoge e kambi.” ");
INSERT INTO luo_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Omiyo Miriam nobedo oko mar kambi kuom ndalo abiriyo, kendo ji nochungʼ kar tiendgi nyaka ne odwogo. ");
INSERT INTO luo_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Bangʼ mano, ji nowuok Hazeroth kendo negigoyo kambi e Thim mar Paran. ");
INSERT INTO luo_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Or jomoko odhi onon piny Kanaan, ma onego ami jo-Israel. Koa e dhoot ka dhoot manie oganda inior achiel kuom jotendgi.” ");
INSERT INTO luo_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Kaluwore gi dwond Jehova Nyasaye, Musa noorogi ka gia e Thim mar Paran. Jogi duto ne gin jotend jo-Israel. ");
INSERT INTO luo_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Magi e nying-gi, koa e dhood Reuben ne en Shamua wuod Zakur; ");
INSERT INTO luo_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","koa e dhood Simeon, ne en Shafat wuod Hori; ");
INSERT INTO luo_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","koa e dhood Juda, ne en Kaleb wuod Jefune; ");
INSERT INTO luo_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","koa e dhood Isakar, ne en Igal wuod Josef; ");
INSERT INTO luo_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","koa e dhood Efraim, ne en Hoshea wuod Nun; ");
INSERT INTO luo_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","koa e dhood Benjamin, ne en Palti wuod Rafu; ");
INSERT INTO luo_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","koa e dhood Zebulun, ne en Gadiel wuod Sodi; ");
INSERT INTO luo_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","koa e dhood Manase (ma en dhood Josef), ne en Gadi wuod Susi; ");
INSERT INTO luo_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","koa e dhood Dan, ne en Amiel wuod Gemali; ");
INSERT INTO luo_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","koa e dhood Asher, ne en Sethur wuod Mikael; ");
INSERT INTO luo_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","koa e dhood Naftali, ne en Nabi wuod Vofsi; ");
INSERT INTO luo_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","koa e dhood Gad, ne en Geuel wuod Maki. ");
INSERT INTO luo_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Magi e nying chwo mane Musa ooro mondo onon piny Kanaan. (Musa nomiyo Hoshea wuod Nun nying ni Joshua.) ");
INSERT INTO luo_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Kane Musa oorogi mondo gidhi ginon piny Kanaan, nowachonegi niya, “Luwuru Negev kendo udhi nyaka piny manie got. ");
INSERT INTO luo_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Nonuru ane pinyno kaka chalo, mondo ungʼego ni joma odak kanyo gin thuondi koso ngoche, gingʼeny koso ginok? ");
INSERT INTO luo_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Nonuru ane kaka piny ma gidakieno chalo, ka ober kata orach? Nonuru ane mier ma gidakie nichalo nade, ochielgi koso ok ochielgi? ");
INSERT INTO luo_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Lopno, to chalo nade? En lowo mamiyo koso motwo? Bende en gi yiende koso oongego? Temuru beru mondo ukel olembe moko mag pinyno.” (Ndalono ne en kinde keyo mokwongo mar mzabibu.) ");
INSERT INTO luo_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Omiyo ne giwuok kendo neginono pinyno kochakore Thim mar Zin nyaka Rehob, kagichomo Lebo Hamath. ");
INSERT INTO luo_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ne giwuotho mi gikadho piny Negev nyaka gichopo Hebron, kama Ahiman, Sheshai kod Talmai, ma nyikwa Anak nodakie. (Hebron noger higni abiriyo motelone Zoan manie piny Misri.) ");
INSERT INTO luo_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Kane gichopo e Holo mar Eshkol, ne gitongʼo bad yath achiel motingʼo pumbi mar olemb mzabibu. Ji ariyo kuomgi notingʼe e luth kaachiel gi gik mongʼinore kod ngʼowu. ");
INSERT INTO luo_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Kanyo niluongo ni Holo mar Eshkol nikech negingʼado bad olemb mzabibu mochiek. ");
INSERT INTO luo_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Bangʼ ndalo piero angʼwen negidwogo ka gia nono pinyno. ");
INSERT INTO luo_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Negidwogo ir Musa gi Harun kod oganda jo-Israel duto e dala Kadesh manie Thim Paran. Kanyo ema ne gimiyogi dwoko kaachiel gi chokruok duto kendo neginyisogi olemo machiek e pinyno. ");
INSERT INTO luo_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Negimiyo Musa nonro machalo kama: “Ne wadhi e piny mane iorowae, kendo en piny mopongʼ gi chak kod mor kich! Olemo moa kuno eri. ");
INSERT INTO luo_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Joma odak kuno nigi teko mangʼeny, kendo gidakie mier madongo mochiel motegno kendo malich. Bende ne waneno nyikwa Anak kuno. ");
INSERT INTO luo_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Jo-Amalek odak Negev; jo-Hiti, jo-Jebus kod jo-Amor odak e piny manie got; to jo-Kanaan odak machiegni gi dho nam e alwora mar Jordan.” ");
INSERT INTO luo_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Eka Kaleb nokwero ji mondo olingʼ e nyim Musa kendo nowacho niya, “Wadhiuru kendo wakaw pinyno, nimar wanyalo kawe.” ");
INSERT INTO luo_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","To joma nodhi kode kuno nowacho niya, “Ok wanyal monjo jogo; gitek moloyowa.” ");
INSERT INTO luo_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Omiyo ne gilandone jo-Israel dwoko marachni kuom piny mane gidhi nono. Negiwacho niya, “Piny mane wadhi nono nego joma odak eigi. Ji mane waneno kuno gin joma robede. ");
INSERT INTO luo_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ne waneno Nefilim kuno (nyikwa Anak aa kuom jo-Nefilim). Ne wanenore mana ka ongogo, to bende mano e kaka ne wachalo e nyimgi.” ");
INSERT INTO luo_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Otienono oganda duto mag gwengʼ notingʼo dwondgi malo mi giywak matek. ");
INSERT INTO luo_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Jo-Israel duto nongʼur ne Musa kod Harun, kendo chokruok mar oganda duto nowachonegi niya, “Donge dine ber ka watho Misri? Kata mana e thim ka! ");
INSERT INTO luo_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Angʼo momiyo Jehova Nyasaye kelowa e pinyni mondo negwa gi ligangla? Mondewa kod nyithindwa ibiro kaw mana kaka gik moyaki. Donge deber ka wadok Misri?” ");
INSERT INTO luo_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Kendo negiwacho e kindgi giwegi niya, “Onego wayier jatelo mondo wadog Misri.” ");
INSERT INTO luo_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Eka Musa kod Harun nopodho auma e nyim chokruok mar oganda Israel duto mane ochokore kanyo. ");
INSERT INTO luo_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Joshua wuod Nun kod Kaleb wuod Jefune, ma gin achiel kuom joma ne odhi nono piny Kanaan, noyiecho lepgi ");
INSERT INTO luo_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","mi owacho ne chokruok mar oganda jo-Israel duto niya, “Piny mane wakalo e iye kendo wanono ber miwuoro. ");
INSERT INTO luo_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ka dipo ni Jehova Nyasaye mor kodwa, to obiro telonwa nyaka e pinyno, piny mopongʼ gi chak kod mor kich, kendo obiro miyowa pinyno. ");
INSERT INTO luo_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Gima utim en ni kik ungʼanyne Jehova Nyasaye. Kik uluor jopinyno, nikech wabiro mwonyogi duto. Jarit mag-gi osea, to wan to Jehova Nyasaye nikodwa kendo kik uluorgi.” ");
INSERT INTO luo_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","To chokruok mar oganda duto nowuoyo e kindgi giwegi mondo gichielgi gi kite. Eka duongʼ mar Jehova Nyasaye nothinyore ne jo-Israel duto e Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Jehova Nyasaye nowacho ne Musa niya, “Nyaka karangʼo ma jogi biro jarae? Nyaka karangʼo ma jogi biro tamore yie kuoma, kata bangʼ timo honni mopogore opogore e kindgi? ");
INSERT INTO luo_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Abiro negogi gi masira mi atiekgi chuth, to un to abiro miyou ubed oganda maduongʼ kendo motegno moloyogi.” ");
INSERT INTO luo_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musa noywak ne Jehova Nyasaye niya, “Jo-Misri ongʼeyo wachni malongʼo ni in ema nigolo jo-Israel oa kuomgi gi tekoni iwuon. ");
INSERT INTO luo_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Kendo gibiro nyiso jopinyni wachni. To bende gisewinjo ni in, yaye Jehova Nyasaye, oseneni kitelonegi godiechiengʼ gi boche mag polo, to gotieno itelonegi gi pilni mar mach. ");
INSERT INTO luo_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ka inego jogi duto dichiel, to oganda mabiro winjo wach machalo kama kuomi biro wacho niya, ");
INSERT INTO luo_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Jehova Nyasaye ne ok nyal chopo gi jogi e piny mane osingorenegi kokwongʼore, momiyo ne onegogi e thim.’ ");
INSERT INTO luo_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Mad koro teko Jehova Nyasaye oyangre malongʼo, mana kaka isewacho: ");
INSERT INTO luo_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Jehova Nyasaye ok kech piyo, to en gihera mogundho kendo oweyo ne ji richogi kendo ongʼwono ne joma ongʼanyo. To kata kamano, joma oketho ok nyal we ma ok okum; okumo nyithindo kuom richo mag wuonegi nyaka tiengʼ mar adek kata nyaka tiengʼ mar angʼwen.’ ");
INSERT INTO luo_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Kaluwore gihera mari maduongʼ, yie iwene jogi richo mag-gi, mana kaka isebedo ka ingʼwononegi chakre gia Misri nyaka sani.” ");
INSERT INTO luo_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Jehova Nyasaye nodwoko niya, “Aseweyonegi richogi mana kaka ne ikwayo. ");
INSERT INTO luo_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Kata kamano, akwongʼora gi nyinga awuon kod duongʼ mara mopongʼo piny, ");
INSERT INTO luo_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ni onge kata mana ngʼato achiel kuomgi mane oneno duongʼ mara kod ranyisi mag honni mane atimo Misri kendo e thim, to ne ok owinja kendo otema nyadipar; ma nochopi e piny mane asingonegi. ");
INSERT INTO luo_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Bende onge kata mana ngʼato achiel kuomgi mabiro neno piny mane asingone kweregi ka akwongʼora. Ngʼato angʼata ma osenyisa achaya ok none pinyno. ");
INSERT INTO luo_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","To nikech jatichna Kaleb nigi chuny mopogore kod mag-gi kendo ma luwa gi chunye duto, abiro tere e piny mane odhiyoeno, kendo nyikwaye nokaw pinyno kaka girkeni margi. ");
INSERT INTO luo_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","To nikech jo-Amalek kod jo-Kanaan odak e kuonde mag holo, dwoguru kiny kendo udhi e thim mantiere e yo mochiko Nam Makwar.” ");
INSERT INTO luo_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Jehova Nyasaye nowacho ne Musa kod Harun niya, ");
INSERT INTO luo_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Nyaka karangʼo ma oganda ma timbegi richogi biro ngʼur koda? Asewinjo ngʼur mar jo-Israel ma jo-mibadhigi. ");
INSERT INTO luo_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Omiyo nyisgiuru ni Jehova Nyasaye owacho ni, ‘Akwongʼora gi nyinga awuon, ni abiro timonu mana gigo mane awinjo kuwacho: ");
INSERT INTO luo_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ringreu nolwar mana e thimni; ngʼato angʼata kuomu ma hike piero ariyo ka dhi nyime mane okwan e ndalo kweno kendo mosengʼur koda. ");
INSERT INTO luo_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Onge ngʼato angʼata kuomu manodonji e piny mane asingone katingʼo bada malo mondo obed dalau, makmana Kaleb wuod Jefune kod Joshua wuod Nun. ");
INSERT INTO luo_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","To kuom nyithindu mane uwacho ni ibiro kaw kaka gik moyaki, gin to abiro kelogi mondo giyud mor mar piny mane udagi. ");
INSERT INTO luo_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","To un, ringreu nodongʼ e thim. ");
INSERT INTO luo_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Nyithindu nobed jokwath e pinyni kuom higni piero angʼwen, ka giyudo thagruok nikech bedou maonge gi ratiro, nyaka ane ni ringre ngʼama ogik odongʼ e thim. ");
INSERT INTO luo_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ne ubet ka unono pinyno kuom ndalo piero angʼwen, omiyo unuchul richou kuom higni piero angʼwen, ka higa achiel ikwano kar ndalo achiel, mi unufweny malongʼo gima omiyo akwedou.’ ");
INSERT INTO luo_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","An, Jehova Nyasaye, asewacho, kendo abiro timo gigi adieri ne oganda ma timbegi richogi, moseriwore mar kweda. Giko mar ngimagi notimre e thim; kendo kae ema gibiro thoe.” ");
INSERT INTO luo_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Omiyo joma Musa ne oseoro mondo odhi onon pinyno, mi odwogo kendo omiyo oganda duto ma timbegi richogi ongʼur kode kaluwore gi wach marach mane gikelo kuom pinyno; ");
INSERT INTO luo_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","jogi mane okelo wach marachni kuom pinyno noneg-gi gi masira e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Kuom joma nodhi nono pinyno, Joshua wuod Nun kod Kaleb wuod Jefune kende ema notony. ");
INSERT INTO luo_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ka Musa nowacho ne jo-Israel duto wachni kendo ne giywak gi lit ahinya. ");
INSERT INTO luo_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Kiny gokinyi mangʼich ne giwuok mi gidhi e piny manie got. Negiwacho niya, “Wasetimo richo. Wabiro dhi nyaka kama Jehova Nyasaye nosingo.” ");
INSERT INTO luo_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","To Musa nowachonegi niya, “Angʼo momiyo utamoru winjo chik Jehova Nyasaye? Mano ok bi timore! ");
INSERT INTO luo_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Kik udhi kuno, nikech Jehova Nyasaye oseweyou. Wasiku biro lou, ");
INSERT INTO luo_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","nimar jo-Amalek kod jo-Kanaan noked kodu kuno. Nikech useweyo Jehova Nyasaye, ok enodhi kodu kendo nonegu gi ligangla.” ");
INSERT INTO luo_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","To kata kamano, ne ok gidewo wachno, mi gichako dhi malo e piny got, to Musa kata Sandug Muma mar Jehova Nyasaye ne ok owuok e kambi. ");
INSERT INTO luo_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Eka jo-Amalek kod jo-Kanaan mane odak e piny got nolor mwalo mi omonjogi kendo neginegogi duto ma gichopo nyaka Horma. ");
INSERT INTO luo_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Wuo gi jo-Israel kendo iwachnegi ni, ‘Bangʼ ka usedonjo e piny mamiyouni kaka kar dak ");
INSERT INTO luo_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","kendo uchiwone Jehova Nyasaye misengini miwangʼo pep koa kuom kweth mag dhok kata mag jamni, kaka gima dungʼ tik mangʼwe ngʼar mamoro Jehova Nyasaye bed ni gin misengini miwangʼo pep, chiwo mar hera, chiwo mag kwongʼruok kata mago mag nyasi. ");
INSERT INTO luo_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Bangʼe ngʼama kelo chiwo mare nokelne Jehova Nyasaye chiwo mar cham maromo achiel kuom apar mar efa mar mogo mayom moruw gi achiel kuom angʼwen mar lita mar mo. ");
INSERT INTO luo_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Bende nyaka uchiw achiel kuom angʼwen mar lita mar divai mondo obed misango miolo piny kuom nyarombo ka nyarombo mutimogo misango miwangʼo pep kata misango mar nyasi. ");
INSERT INTO luo_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Ka chiayo mitimogo misangono en im, to mogo mitimogo misango mar cham nyaka bed kilo angʼwen gi nus moruw gi mo moromo lita achiel gi nus, ");
INSERT INTO luo_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","kendo uchiw lita achiel gi nus mar divai kaka misango miolo piny. Kamano e kaka unuchiwne Jehova Nyasaye misango madungʼ tik mangʼwe ngʼar ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘To ka en nyarwath ema utimogo ne Jehova Nyasaye misango miwangʼo pep, kata misango mar sawo, kaka singruok mowal kata chiwo mar lalruok ne Jehova Nyasaye, ");
INSERT INTO luo_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","to ukel rwath kaachiel gi chiwo mar cham maromo kilo ariyo mar mogo mayom moru gi nus mar lita mar mo. ");
INSERT INTO luo_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Bende ukel nus mar lita mar divai kaka misango miolo piny. Obiro bedo chiwo mowangʼ miwangʼo, ma en gima dungʼ tik mangʼwe ngʼar mamoro Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Rwath ka rwath, im ka im, rombo ka rombo, kata nyadiel ka nyadiel, nyaka losi e yo machal kamano. ");
INSERT INTO luo_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Timuru ma ne misengini duto mag jamni moro ka moro. ");
INSERT INTO luo_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Ngʼato angʼata monywol e pinyni ma ja-Israel nyaka tim gigi, ka okelo chiwo molos gi mach kaka gima dungʼ tik mangʼwe ngʼar mamoro Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","To ne tiengʼ mabiro, kinde duto ma japiny moro kata ngʼato angʼata modak e kindu okelo misango molos gi mach kaka gima dungʼ tik mangʼwe ngʼar mamoro Jehova Nyasaye, nyaka otim mana kaka utimo. ");
INSERT INTO luo_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Oganda jo-Israel nyaka bed gi chike machalre ne tiengʼ mabiro kod jopinje mamoko; ma en singo mochwere ne tiengʼ mabiro. Un kod jopinje mamoko nubed machalre e nyim Jehova Nyasaye: ");
INSERT INTO luo_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Chik achiel ema omakou machalre gi jopinje mamoko modak e dieru.’ ” ");
INSERT INTO luo_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Wuo gi jo-Israel kendo iwachnegi kama: ‘Ka udonjo e piny ma ateroue, ");
INSERT INTO luo_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","kendo uchamo chiemb pinyno, to uchiw bathe moko kaka misango ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Chiw cham moa e nyak mokwongo mar lopi kendo ichiwe kaka misango moa e laru mar dino cham. ");
INSERT INTO luo_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","E tienge duto mabiro nyaka ugol misangoni ne Jehova Nyasaye koa e nyak mokwongo mar lopi. ");
INSERT INTO luo_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Ka e kia maru ok urito chike mane Jehova Nyasaye omiyo Musa, ");
INSERT INTO luo_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ma gin chike mane omiyou kokalo kuome, chakre e kinde mane Jehova Nyasaye ochiwogie kendo ka gidhi nyime nyaka e tienge mabiro; ");
INSERT INTO luo_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","to ka ma otim maonge chenro ka oganda ok ongʼeyo, to oganda duto nochiw nyarwath matin kaka misango miwangʼo pep ma en gima dungʼ tik mangʼwe ngʼar mamoro Jehova Nyasaye, kaachiel gi chiwo mar cham kod misango miolo piny, kod nywok kaka misango mar golo richo. ");
INSERT INTO luo_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Jadolo notim pwodhoruok ne oganda duto mag jo-Israel, kendo nowenegi richogi, nimar ne ok gingʼeyo gima negitimo kendo gisekelone Jehova Nyasaye misango mowangʼ pep kuom ketho margi kod misango mar golo richo. ");
INSERT INTO luo_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Oganda duto mag jo-Israel kod jopinje mamoko manie dieru nowenegi richogi, nikech ji duto notimo richo ka ok gingʼeyo. ");
INSERT INTO luo_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘To ka ngʼato achiel ema otimo richo ka ok ongʼeyo, to nyaka ochiw diel madhako ma ja-higa achiel kaka misango mar golo richo. ");
INSERT INTO luo_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Jadolo notim pwodhruok e nyim Jehova Nyasaye ne ngʼatno motimo richo ka ok ongʼeyo, kendo ka osetimne pwodhruok, nowene richo. ");
INSERT INTO luo_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Chik achielno ema oket ne ngʼato angʼata motimo richo ka ok ongʼeyo, bed ni en jakanyo ma ja-Israel kata japiny moro. ");
INSERT INTO luo_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘To ka ngʼato otimo richo gi wangʼ matek, bed ni en japinyno kata japiny moro, to ojaro Jehova Nyasaye, kendo ngʼat makamano onego ogol oko e dier jogi. ");
INSERT INTO luo_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Nikech osejaro wach Jehova Nyasaye kendo oketho chikene, ngʼatno nyaka gol oko; kendo richo mare nodongʼ e wiye.’ ” ");
INSERT INTO luo_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Kane jo-Israel ne nitie e thim, ngʼat moro noyud ka modo yien chiengʼ Sabato. ");
INSERT INTO luo_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Joma ne oyude ka omodo yien nokele ir Musa gi Harun kod chokruok duto, ");
INSERT INTO luo_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","kendo ne gikane e od twech, nikech ne ok ongʼere malongʼo gima onego timne. ");
INSERT INTO luo_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Eka Jehova Nyasaye nowacho ne Musa niya, “Ngʼatno nyaka negi. Chokruok duto nyaka chiele gi kite e oko mar kambi.” ");
INSERT INTO luo_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Omiyo ogandago nogole oko mar kambi kendo negichiele gi kite motho, mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Wuo gi jo-Israel kendo iwachnegi kama: ‘Ne tiengʼ duto mabiro nyaka umin usi e riak lepu ka usi moro ka moro olwor gi kido marambulu. ");
INSERT INTO luo_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Usi momin molier e riak lepugo nomi unupar chike duto mag Jehova Nyasaye, mondo omi uritgi ma ok uteroru gi gombo mag chunjeu kod wengeu uwegi. ");
INSERT INTO luo_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Bangʼ mano unupar mar rito chikena duto kendo nowalu tenge ne Nyasachu. ");
INSERT INTO luo_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","An e Jehova Nyasaye ma Nyasachu, mane ogolou Misri mondo obed Nyasachu. An Jehova Nyasaye ma Nyasachu.’ ” ");
INSERT INTO luo_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora wuod Izhar, ma wuod Kohath, ma wuod Lawi, kod joka Reuben moko kaka Dathan gi Abiram, ma yawuot Eliab kod On wuod Peleth noriwore kaachiel ");
INSERT INTO luo_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","kendo negichokore mondo giked gi Musa. Kaachiel kodgi ne nitiere jo-Israel mia ariyo gi piero abich, ma jotend oganda mongʼere mane oseyier kaka jakanyo mar bura. ");
INSERT INTO luo_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Negibiro kaka oganda achiel mochokore mondo giked gi Musa kod Harun kendo negiwachonegi niya, “Usetimo mokalo tongʼ! Oganda duto ler, ngʼato ka ngʼato kuomgi, kendo Jehova Nyasaye ni kodgi. En angʼo momiyo koro uketoru malo moloyo oganda mar Jehova Nyasaye?” ");
INSERT INTO luo_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Kane Musa owinjo wachno, nopodho piny auma. ");
INSERT INTO luo_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Eka nowacho ne Kora kod jolupne duto niya, “Kochopo gokinyi Jehova Nyasaye noyier joma oyie kuome kendo maler, kendo norwak ngʼatno obi bute. ");
INSERT INTO luo_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","To in, Kora, kod joma luwou duto nyaka tim ma: Kawuru ubani ");
INSERT INTO luo_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","kendo kiny umok mach kod gima dungʼ tik mangʼwe ngʼar e nyim Jehova Nyasaye. Ngʼatno ma Jehova Nyasaye oyiero ema nobed ngʼama ler. Un jo-Lawi usekalo tongʼ!” ");
INSERT INTO luo_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa bende nowacho ne Kora niya, “Koro Winjuru, un jo-Lawi! ");
INSERT INTO luo_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ok lichnu ni Nyasach Israel osegolou oko mar oganda jo-Israel mamoko kendo okelou bute owuon mondo uti e hekalu mar Jehova Nyasaye kendo mondo uchung e nyim oganda kendo utinegi? ");
INSERT INTO luo_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Osekelou kod jo-Lawi weteu duto bute, to koro sani utemo bedo jodolo bende. ");
INSERT INTO luo_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Un kaachiel gi joma luwou duto usengʼanyo ni Jehova Nyasaye. Harun to en ngʼa ma ungʼurne?” ");
INSERT INTO luo_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Eka Musa noluongo Dathan kod Abiram, ma yawuot Eliab. To negiwacho niya, “Ok wanabi! ");
INSERT INTO luo_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ok lichni ni isegolowa e piny mopongʼ gi chak kod mor kich mondo inegwa e thim? Kendo sani koro idwaro miyowa tingʼ mapek? ");
INSERT INTO luo_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Kata kamano, pod ok ikelowa e piny mopongʼ gi chak kod mor kich kata miyowa girkeni mag puothe kod puothe mag mzabibu. Ubiro lodho wenge jogi oko? Ngangʼ, ok wanabi!” ");
INSERT INTO luo_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Eka Musa iye nowangʼ matek mi owachone Jehova Nyasaye niya, “Kik iyie gi misengini mag-gi. Pod ok akawo kata mana punda achiel koa kuomgi, kata mana kethone ngʼato angʼata kuomgi.” ");
INSERT INTO luo_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa nowacho ne Kora niya, “In kaachiel gi jolupni duto kod Harun bende nyaka ubi e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ngʼato ka ngʼato nyaka kaw tape owuon ma mach ni e yie kendo oketie ubani mangʼwe ngʼar madirom mia ariyo gi piero abich mi uchiwe e nyim Jehova Nyasaye in kaachiel gi Harun.” ");
INSERT INTO luo_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Omiyo ngʼato ka ngʼato nokawo tape owuon ma mach nitie iye kendo oketoe ubani mangʼwe ngʼar mine gichungʼ kod Musa gi Harun e dhoranga Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kane Kora osechoko joge duto mondo okwedgo Musa gi Harun e dhoranga Hemb Romo, duongʼ Jehova Nyasaye ne onyisore ayanga ne oganda mane ochokore duto. ");
INSERT INTO luo_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Jehova Nyasaye nowacho ne Musa kod Harun niya, ");
INSERT INTO luo_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Pogreuru gi kanyakla mar ogandani mondo omi atiekgi chuth.” ");
INSERT INTO luo_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","To Musa kod Harun nopodho auma moywak niya, “Yaye Nyasaye, mongʼeyo chunje duto mag dhano, iyi diwangʼ gi kanyakla mar ogandagi duto ka en mana ngʼato achiel ema otimo richo?” ");
INSERT INTO luo_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Eka Jehova Nyasaye nowacho ne Musa ni, ");
INSERT INTO luo_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Wachne kanyakla mar oganda kama: ‘Daruru uwuog machiegni gi hembe Kora, Dathan kod Abiram.’ ” ");
INSERT INTO luo_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musa noa malo modhi ir Dathan kod Abiram, kendo jodong Israel noluwe. ");
INSERT INTO luo_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Nochiwo siem ne kanyakla mar oganda niya, “Suduru mabor gi hembe jogo ma timbegi richo! Kik umul girgi moro amora, ka ok kamano to ubiro lal nono nikech richo mag-gi.” ");
INSERT INTO luo_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Omiyo negisudo mabor gi hembe mag Kora, Dathan kod Abiram. Dathan kod Abiram nosewuok oko kendo negichungo gi mondegi, nyithindgi kod rowere mag-gi e dhoranga hembegi. ");
INSERT INTO luo_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Eka Musa nowacho niya, “Ma e kaka ubiro ngʼeyo ni Jehova Nyasaye ema noora mondo atim gigi duto kendo ni ne ok en pacha awuon: ");
INSERT INTO luo_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ka dipo ni jogi otho mana kaka ji duto nyalo tho, to kare Jehova Nyasaye ne ok oora. ");
INSERT INTO luo_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","To ka Jehova Nyasaye okelo gima nyien mopogore gi mago duto mapile, kendo ma piny oyawo dhoge mi omwonyogi, gi gik moko duto ma mekgi, kendo ma gidhi ei bur ka gingima, eka unungʼe ni jogi osewuotho e nyim Jehova Nyasaye gi achaya.” ");
INSERT INTO luo_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Mana gi sa mane otieko wacho gigi, lowo mane ni e bwo tiendgi nobarore, ");
INSERT INTO luo_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","kendo piny noyawo dhoge mi omwonyogi, gi joodgi duto kod joka Kora duto kod mwandugi duto. ");
INSERT INTO luo_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Negidhi e bur kagingima mi lowo uomogi kod mwandugi kendo negilal nono ei oganda Israel. ");
INSERT INTO luo_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","E kinde mane giywak, jo-Israel duto mane ni machiegni kodgi noringo, kaywak niya, “Wan bende piny dhi mwonyowa!” ");
INSERT INTO luo_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Kendo mach nowuok koa kuom Jehova Nyasaye mi owangʼo ji mia ariyo gi piero abich mane oyudo chiwo misango mangʼwe ngʼar. ");
INSERT INTO luo_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Nyis Eliazar wuod Harun, ma jadolo, mondo ogol tawo miwangʼo ubani kendo okee mirni mar mach mabor, nimar tawono ler ");
INSERT INTO luo_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","nimar gin tawo mag joma otimo richo ewi ngimagi giwegi. Los tawono moriere kendo iketgi ewi kendo mar misango, nimar nochiwgi e nyim Jehova Nyasaye kendo gisebedo maler. We gibed ranyisi ne jo-Israel.” ");
INSERT INTO luo_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Omiyo Eliazar jadolo nochoko tawo mar mula mane okel gi jogo mane osewangʼ, kendo nochokogi kanyakla monywasogi mondo muon-go kendo mar misango, ");
INSERT INTO luo_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","mana kaka Jehova Nyasaye nochike kokalo kuom Musa. Ma ne parone jo-Israel ni onge ngʼato angʼata makmana nyikwa Harun ema onego bi mondo owangʼ gima dungʼ tik mangʼwe ngʼar e nyim Jehova Nyasaye, ka ok kamano to obiro chalo kaka Kora kod jolupne. ");
INSERT INTO luo_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Kinyne oganda mar jo-Israel duto nongʼurne Musa kod Harun. Negiwachonegi niya, “Usenego jo-Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","To ka ogandano nochokore mar kwedo Musa kod Harun kendo gilokore ka gingʼiyo Hemb Romo, apoya nono boche polo noume kendo duongʼ mar Jehova Nyasaye noyangore. ");
INSERT INTO luo_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Eka Musa kod Harun nodhi e nyim Hemb Romo, ");
INSERT INTO luo_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","kendo Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Wuogi e kanyakla mondo omi atiekgi chuth.” Kendo Musa gi Harun nopodho auma e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Eka Musa nowacho ne Harun niya, “Kaw tawo mar ubani mari kendo iket gima dungʼ tik mangʼwe ngʼar e iye, kaachiel gi mach moa e kendo mar misango, kendo iret idhi e chokruokno mondo itimnegi misango mar pwodhruok e richo. Mirima osebiro koa ir Jehova Nyasaye; masiche osechakore.” ");
INSERT INTO luo_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Omiyo Harun notimo kaka Musa nowachone, kendo noringo modhi e dier chokruok. Masira ne osechakore e dier ji, to Harun nochiwo gima dungʼ tik mangʼwe ngʼar kendo nokwayonegi ngʼwono kuom gima gisetimo. ");
INSERT INTO luo_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Nochungʼ e kind joma ngima gi joma otho, mi masiche norumo. ");
INSERT INTO luo_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Makmana ji alufu apar gangʼwen gi mia abiriyo (14,700) nosetho nikech masichego, komedore gi jogo mane osetho nikech Kora. ");
INSERT INTO luo_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Eka Harun noduogo ir Musa e dhoranga Hemb Romo, nimar masiche noserumo. ");
INSERT INTO luo_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Wuo gi jo-Israel kendo ichok odunga apar gariyo koa kuomgi, achiel ka achiel koa kuom jatelo moro ka moro mar dhoutgi. Ndik nying ngʼato ka ngʼato kuom odungane. ");
INSERT INTO luo_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","E odunga mar Lawi ndike nying Harun, nimar nyaka bedi odunga achiel mar jatelo mar dhoot ka dhoot. ");
INSERT INTO luo_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ketgi e Hemb Romo e nyim Sandug Rapar, kama aromoe kodi. ");
INSERT INTO luo_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Odunga mar ngʼat mayiero biro loth, kendo abiro tieko chuth ngʼur ma jo-Israel ngʼurnigo maonge giko.” ");
INSERT INTO luo_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Omiyo Musa nowuoyo gi jo-Israel, kendo jotendgi nomiye odunga apar gariyo, ka moro ka moro en mar dhoutgi, kendo odunga mar Harun ne achiel kuomgi. ");
INSERT INTO luo_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa noketo odungago e nyim Jehova Nyasaye e Hema e nyim Sandug Rapar. ");
INSERT INTO luo_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Kinyne Musa nodonjo ei Hemb Rapar kendo noneno odunga mar Harun, mane ochungʼ e lo Lawi, ne pok ochako loth kende to thuokene bende nosechako dongo, ka gingʼich mamoro wangʼ kendo gigolo olembe mag oyungu. ");
INSERT INTO luo_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Eka Musa nogolo odunga duto e nyim Jehova Nyasaye mi okelone jo-Israel duto. Ne gingʼiyogi, kendo ngʼato ka ngʼato nokawo odungane owuon. ");
INSERT INTO luo_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Jehova Nyasaye nowacho ne Musa niya, “Dwok odunga mar Harun e nyim Sandug Rapar, mondo kane kaka ranyisi ne joma ongʼanyo. Mano biro tieko chuth kitgi mar ngʼur koda, mondo omi kik githo.” ");
INSERT INTO luo_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa notimo mana kaka Jehova Nyasaye nonyise. ");
INSERT INTO luo_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Jo-Israel nowacho ne Musa niya, “Wabiro tho! Waserwenyo, kendo wan duto waselal! ");
INSERT INTO luo_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ngʼato angʼata mosudo machiegni gi hekalu mar Jehova Nyasaye biro tho. Dibed ni wan duto wabiro tho?” ");
INSERT INTO luo_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Jehova Nyasaye nowacho ne Harun niya, “In gi yawuoti kod od wuonu nyaka ukaw tingʼ mag richo motimne kama ler mar lemo, kendo in-gi yawuoti kende ema nyaka ukaw tingʼ richo motimne jodolo. ");
INSERT INTO luo_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Kel jo-Lawi weteu koa e dhoutu mag anywola mondo oriwre kodi kendo gikonyu ka in kod yawuote tiyo e nyim Hema mar Sandug Rapar. ");
INSERT INTO luo_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Nyaka giwinju kendo giti tije duto mag Hema, to kik gidhi machiegni gi gig kama ler mar lemo kata mag kendo mar misango, ka ok kamano to gin kod un duto ubiro tho. ");
INSERT INTO luo_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Nyaka giriwre kodi kendo gikaw tich mar rito Hemb Romo kaachiel gi tije duto manie Hema, kendo onge ngʼat machielo moyiene biro machiegni gi kama intie. ");
INSERT INTO luo_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Nyaka ikaw tich mar rito kama ler mar lemo kod kendo mar misango, mondo mi masira kik lwar kuom jo-Israel kendo. ");
INSERT INTO luo_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","An awuon aseyiero jo-Lawi weteni koa kuom jo-Israel kaka chiwo ne un, mowal ne Jehova Nyasaye mondo oti e Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","To in kod yawuoti kende ema onego bed jodolo kaluwore gi gik moko duto manie kendo mar misango kod mago mantiere ei pasia. Amiyou tich mar bedo jodolo kaka chiwo. Ngʼato angʼata ma osudo machiegni gi kama ler mar lemo nyaka negi.” ");
INSERT INTO luo_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Eka Jehova Nyasaye nowacho ne Harun niya, “An awuon aseketi jarit mar chiwo duto mokelna; chiwo maler duto ma jo-Israel omiya amiyi kod yawuoti kaka pok maru kendo mano ema unuyud pile. ");
INSERT INTO luo_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Nyaka ikaw thoth bath chiwo duto maler ma ok owangʼ e mach. Koa kuom mich duto ma gikelona kaka chiwo maler moloyo, bedni en chiwo mar cham, kata mar misango mar golo richo kata mar pwodhruok, pokno en mari kod yawuoti. ");
INSERT INTO luo_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Chame kaka gima ler moloyo; chwo duto nochame. Nyaka ikawe kaka gima ler. ");
INSERT INTO luo_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Gimoro amora mowal tenge koa e mich mag misango mifwayo mar jo-Israel bende nobed mari. Achiwo ma ne in kod yawuoti gi nyigi kaka pok maru mapile pile. Ngʼato angʼata mantiere e odi mopwodhore maler nyalo chame. ");
INSERT INTO luo_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Amiyou mo zeituni mayom duto kod divai manyien mayom duto kod cham ma gichiwone Jehova Nyasaye kaka olemo mokwongo mar keyo margi. ");
INSERT INTO luo_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Olembe mokwongo duto moa e puodho ma gikelone Jehova Nyasaye nobed mari. Ngʼato angʼata mantiere e odi mopwodhore maler nyalo chame. ");
INSERT INTO luo_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Gimoro amora mochiwne Jehova Nyasaye chuth nobed magu. ");
INSERT INTO luo_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Nyodo mokwongo mar ich, obed dhano kata chiayo, mochiwne Jehova Nyasaye en mari. To nyaka uwar wuowi makayo moro amora kod kayo madichwo moro amora mar jamni ma ok ler. ");
INSERT INTO luo_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ka giromo dwe achiel, nyaka iwargi e nengo mar wero ma en shekel abich mar fedha, kaluwore gi shekel mar kama ler mar lemo, ma pekne romo gera piero ariyo. ");
INSERT INTO luo_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“To kik iwar kayo ma rwath, rombo kata diel; nikech giler. Kir rembgi e kendo mar misango kendo iwangʼ mo mawuok kuomgi kaka misango miwangʼo gi mach, ma en gima dungʼ tik mangʼwe ngʼar mamoro Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ring jamnigo gin magu, mana kaka misango mifwayo mar agoko kod em korachwich bende maru. ");
INSERT INTO luo_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Gimoro amora mowal tenge koa kuom misengini maler ma jo-Israel ochiwo ne Jehova Nyasaye, amiyoi gi yawuoti kod nyigi kaka pok maru mapile. En singruok ma ok rum e nyim Jehova Nyasaye ne in kaachiel gi nyikwayi.” ");
INSERT INTO luo_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Jehova Nyasaye nowacho ne Harun niya, “Ok iniyud girkeni mora amora e piny jogi, kata pok moro amora ok inibedgo e kindgi nimar an e pok maru kendo girkeni maru e kind jo-Israel. ");
INSERT INTO luo_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Amiyo jo-Lawi achiel kuom apar duto mantiere e Israel kaka girkeni margi ka achulogigo kuom tich ma gitiyo e Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Chakre kawuono jo-Israel ok onego dhi machiegni gi Hemb Romo, ka ok kamano to ibiro kumogi kuom richo mag-gi kendo gibiro tho. ");
INSERT INTO luo_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","En mana jo-Lawi ema oyienegi mar tiyo tij Hemb Romo kendo kaw tingʼ duto mag richo motimie Hemb Romo. Ma en chik mogik makende ne tiengʼ mabiro. Ok giniyud girkeni moro amora kuom jo-Israel. ");
INSERT INTO luo_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Kata kamano, amiyo jo-Lawi kaka girkeni margi achiel kuom apar ma jo-Israel ochiwo kaka misango ne Jehova Nyasaye. Mano emomiyo ne awacho kama kuomgi: ‘Ok giniyud girkeni e dier jo-Israel.’ ” ");
INSERT INTO luo_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Wuo gi jo-Lawi kendo iwachnegi kama: ‘Ka uyudo koa kuom jo-Israel achiel kuom apar ma amiyou kaka girkeni magu, to nyaka un bende ugol achiel kuom apar mar achiel kuom aparno kaka chiwo ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Chiwouno nokwan kaka cham moa kar dino kata kaka divai mimadho moa kar biyo divai. ");
INSERT INTO luo_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","E yo machalo kama ema un bende ubiro chiwoe chiwo ne Jehova Nyasaye koa kuom achiel kuom apar duto muyudo koa kuom jo-Israel. E achiel kuom apargo, nyaka ichiw pok mar Jehova Nyasaye ne Harun, jadolo. ");
INSERT INTO luo_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Nyaka ichiw pok mar Jehova Nyasaye gino maber kendo maler moloyo mar gik moko duto ma omiu.’ ");
INSERT INTO luo_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Wachne jo-Lawi kama: ‘Ka ichiwo mano maber, to ibiro kwane ne in kaka gima oa e kar dino cham kata kar biyo divai. ");
INSERT INTO luo_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Un kod jouteu duto unyalo chamo bathe moko kamoro amora, nimar en pok maru ne tich mutiyo e Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ka usegolone Jehova Nyasaye gik mabeyo moloyo kamano, to ok unubed joketho kuom wachno, kendo ok nobed ni udwanyo gik maler ma jo-Israel ochiwo kendo ok ubi tho.’ ” ");
INSERT INTO luo_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Jehova Nyasaye nowacho ne Musa gi Harun niya, ");
INSERT INTO luo_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Ma e dwaro mar chik ma Jehova Nyasaye osechiko: Nyis jo-Israel mondo okel nyaroya ma silwal maonge songa kata ma ok ongʼol kendo mapok otwe e jok. ");
INSERT INTO luo_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Chiwe ne Eliazar jadolo; kendo nyaroyano nyaka gol oko mar kambi mi yangʼe ka oneno. ");
INSERT INTO luo_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Bangʼe Eliazar jadolo nyaka kaw rembe moko e lith lwete kendo okwoye nyadibiriyo kochiko nyim Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","E kinde ma pod ongʼicho nyaroyano nyaka wangʼ piende, ringe, rembe kod wen. ");
INSERT INTO luo_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Jadolo nokaw yiende moko mag sida, owino gi usi marakwaro kendo owitgi kuom nyaroya ma wangʼno. ");
INSERT INTO luo_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Bangʼ mano, jadolo nyaka luok lepe kendo olwokre gi pi. Bangʼe onyalo donjo e kambi, makmana ni obiro bedo mochido nyaka chop odhiambo. ");
INSERT INTO luo_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ngʼatno mowangʼo nyaroyano bende nyaka luok lepe, kendo olwokre, en bende nobed mochido nyaka chop odhiambo. ");
INSERT INTO luo_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Ngʼat maler nochok buru mag nyaroyano kendo oketgi kar misango maler e oko mar kambi. Ginikan-gi gi dhout oganda mar jo-Israel mondo ti kodgi e pi pwodhruok; nikech en mar pwodho ji aa e richo. ");
INSERT INTO luo_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ngʼatno mochoko buch nyaroyano nyaka luok lepe bende, to en bende nobed mochido nyaka chop odhiambo. Ma nobedi chik mosiko ne jo-Israel kaachiel gi jopinje mamoko modak kodgi. ");
INSERT INTO luo_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Ngʼato angʼata momulo ringre ngʼama otho biro bedo mochido kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Nyaka opwodhre owuon gi pi chiengʼ mar adek kod chiengʼ mar abiriyo; eka obiro bedo maler. To ka ok opwodhore owuon chiengʼ mar adek gi chiengʼ mar abiriyo, to ok obi bedo maler. ");
INSERT INTO luo_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ngʼato angʼata momulo ringre ngʼama otho kendo ma ok opwodhore owuon ochido hekalu mar Jehova Nyasaye. Ngʼatno nyaka gol oko mar Israel. Nikech pi mar pwodhruok pod ok okir kuome, ochido; kendo chidono odongʼ kuome. ");
INSERT INTO luo_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Chik momako ngʼama otho e hema ema: Ngʼato angʼata modonjo ei hema kendo ngʼato angʼata mantiere e iye nobed mochido kuom ndalo abiriyo, ");
INSERT INTO luo_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","kendo mikebe moro amora maonge raum moumego nobed mochido. ");
INSERT INTO luo_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Ngʼato angʼata man oko momulo ngʼatno mane onegi gi ligangla kata ngʼat motho kende, kata ngʼatno momulo chok dhano, kata liel, nobedi mochido kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Ne ngʼatno mochido, ket buru moko moa e misango mar pwodhruok kendo uruw gi pi maler mi uol e wigi. ");
INSERT INTO luo_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Eka ngʼatno maler nokaw owino, gilute e pi kendo gikuo pi e hema kod e gik moko duto molosgo ii hekalu gi ji man kanyo. Bende nyaka okwo pi kuom ngʼato angʼata mabed ni osemulo chok ngʼama osetho kata liel kata ngʼato ma osenegi kata ngʼato motho athoya. ");
INSERT INTO luo_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Ngʼat maler ema nyaka kir pi kuom ngʼat mochidono chiengʼ mar adek gi mar abiriyo, to kochopo e odiechiengʼ mar abiriyo nyaka opwodhe. Ngʼama ipwodhono nyaka luok lepe kendo luokre gi pi, kendo odhiambono nobed mapoth. ");
INSERT INTO luo_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","To ka ngʼat mochido ok opwodhore owuon, nyaka gole oko e dier oganda, nikech osemiyo kama ler mar lemo mar Jehova Nyasaye ochido. Pi pwodhruokgo pod ok okir kuome, omiyo ochido. ");
INSERT INTO luo_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Chik mosiko ne gin ema. “Ngʼat mokiro pi mar pwodhruok nyaka luok lepe bende, kendo ngʼato angʼata momulo pi mar pwodhruok nobed mochido nyaka chop odhiambo. ");
INSERT INTO luo_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Gimoro amora ma ngʼat mochido omulo nobed mochido, kendo ngʼato angʼata momule nobed mochido nyaka chop odhiambo.” ");
INSERT INTO luo_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","E dwe mokwongo oganda jo-Israel duto nochopo e Thim mar Zin, kendo negidak Kadesh. Kanyo ema Miriam nothoe moike. ");
INSERT INTO luo_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Koro ne onge pi mane ogandani nyalo modho, kendo ji nochokore mondo okwed Musa gi Harun. ");
INSERT INTO luo_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Negidhawo gi Musa kagiwacho niya, “Mad ne bed ni watho e kinde mane owetewa otho e nyim Jehova Nyasaye! ");
INSERT INTO luo_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Angʼo momiyo ikelo oganda Jehova Nyasaye e thimni, mondo mi wan kod jambwa watho kaye? ");
INSERT INTO luo_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Angʼo momiyo ne igolowa Misri mondo ikelwa e piny malichni? Pinyni onge gi cham kata ngʼowu, mzabibu kata olembe mongʼinore to bende onge kata mana pi modho!” ");
INSERT INTO luo_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa kod Harun nowuok koa e chokruok kochiko dhoranga Hemb Romo mi gipodho auma, kendo duongʼ mar Jehova Nyasaye nofwenyorenegi. ");
INSERT INTO luo_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Kaw odunga, kod owadu Harun mondo uchok jo-Israel kaachiel. Wuo kod lwanda ka gineno kendo pi biro chwer koa kuome. Ibiro golo pi kowuok e lwandano ne oganda mondo gin kod jambgi gimodhi.” ");
INSERT INTO luo_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Omiyo Musa nokawo odunga e nyim Jehova Nyasaye mana kaka ne ochike. ");
INSERT INTO luo_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","En kod Harun nochoko chokruok kanyakla e nyim lwanda kendo Musa nowachonegi niya, “Winjuru, un jongʼanyogi, bende ochuno ni nyaka wamiu pi kowuok e lwandani?” ");
INSERT INTO luo_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Eka Musa norieyo bade malo mi ochwado lwandano nyadiriyo gi odunga mare. Pi nobubni oko, kendo ogandago gi jambgi nomodho. ");
INSERT INTO luo_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","To Jehova Nyasaye nowacho ne Musa kod Harun niya, “Nikech ne ok uketo genou kuoma chuth mondo umiya duongʼ kaka ngʼama ler e nyim jo-Israel, ok unuter ogandani e piny ma amiyogi.” ");
INSERT INTO luo_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Magi ne gin pige mag Meriba, kama jo-Israel nongʼurie gi Jehova Nyasaye kendo mano e kama nonyisore owuon kaka ngʼama ler e kindgi. ");
INSERT INTO luo_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa nooro joote moa Kadesh ir ruodh Edom, kowacho kama: “Ma e gima owadu Israel wacho: Ingʼeyo tije matek duto ma wasebedo godo. ");
INSERT INTO luo_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Kwerewa nodhi Misri, kendo negidak kuno kuom higni mathoth. Jo-Misri nosandowa kod wuonewa, ");
INSERT INTO luo_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","to kane waywakne Jehova Nyasaye, nowinjo ywakwa kendo nooro malaika mi ogolowa waa Misri. “Koro wan Kadesh ka, ma en dala mantiere but piny ma irito. ");
INSERT INTO luo_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Yienwa wakal e pinyi. Ok wananyon puodho moro amora kata puoth mzabibu, kata modho pi moa e soko moro amora. Wabiro mana luwo yor ruoth tir kendo ok wanagom yo korachwich kata koracham nyaka wakal pinyi duto.” ");
INSERT INTO luo_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","To Edom nodwoko niya, “Ok unyal luwo ka; ka utemo, to wabiro wuok riat kendo wamonju gi ligangla.” ");
INSERT INTO luo_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Jo-Israel nodwoko niya, “Wabiro luwo yo maduongʼ tir, kendo ka wan kata jambwa omodho piu mora amora, to wabiro chulo. Wadwaro mana kalo kanyo ka wawuotho gi tiendwa; maonge gimoro amora machielo mwadwaro timo.” ");
INSERT INTO luo_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Negidwoko kendo niya, “Ok unyal luwo kae.” Eka Edom nochodo mar kedo kodgi gi jolweny mangʼeny kendo mager. ");
INSERT INTO luo_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Nikech Edom notamore ni ok gikal e pinye, Israel nowere kodgi. ");
INSERT INTO luo_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Oganda duto mar Israel nowuok Kadesh mi gibiro Got Hor. ");
INSERT INTO luo_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","E Got Hor machiegni gi tongʼ mar Edom, Jehova Nyasaye nowacho ne Musa gi Harun niya, ");
INSERT INTO luo_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Harun nochokre gi joge. Ok enodonji e piny mamiyo jo-Israel, nikech un ji ariyogi nungʼanyo ne chikena e pige mag Meriba. ");
INSERT INTO luo_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Kaw Harun kod wuode Eliazar mondo itergi e Got Hor. ");
INSERT INTO luo_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Lony lep Harun kendo irwakne wuode ma Eliazar, nimar Harun biro riwore gi jogi; mi otho kanyo.” ");
INSERT INTO luo_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa notimo kaka Jehova Nyasaye nowachone: Negidhi e Got Hor ka oganda duto neno. ");
INSERT INTO luo_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa nogolo lep Harun mi orwako ne wuode ma Eliazar. Kendo Harun notho ewi godno. Eka Musa kod Eliazar nolor oa ewi got, ");
INSERT INTO luo_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","kendo ka oganda duto nowinjo ni Harun osetho, to jo-Israel noywage kuom ndalo piero adek. ");
INSERT INTO luo_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kane ruodh Arad ma ja-Kanaan, mane odak Negev, nowinjo ni Israel ne wuotho e yo kochiko Atharim, nomonjo jo-Israel mi omako moko. ");
INSERT INTO luo_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Eka Israel nosingore ne Jehova Nyasaye kama: “Ka ichiwonwa jogi e lwetwa, to wabiro tieko miechgi madongo duto.” ");
INSERT INTO luo_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Jehova Nyasaye nochiko ite ne kwayo Israel kendo nochiwo jo-Kanaan ne gin. Negitiekogi duto kod miechgi; omiyo kanyo negichako ni Horma. ");
INSERT INTO luo_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Negiwuotho ka gia Got Hor ka giluwo yo mochiko Nam Makwar, mondo giluor Edom. To ji chunygi nojok ka gin e yo; ");
INSERT INTO luo_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","omiyo negikwedo Nyasaye kod Musa, mi giwacho niya, “En angʼo momiyo ne igolowa Misri mondo watho e thimni? Waonge chiemo, waonge pi! Ok wadwar chiemo marachni!” ");
INSERT INTO luo_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Eka Jehova Nyasaye noolo thuonde man-gi kwiri mager kuomgi; negikayo ji kendo jo-Israel mathoth notho. ");
INSERT INTO luo_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ji nobiro ir Musa mi giwachone niya, “Ne watimo richo e kinde mane wakwedo Jehova Nyasaye kod in. Lamnwa mondo Jehova Nyasaye ogol thuondegi oa kuomwa.” Omiyo Musa nolamone jogo. ");
INSERT INTO luo_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Jehova Nyasaye nowacho ne Musa niya, “Los thuond mula kendo ikete ewi luth; ma ngʼato angʼata ma thuol okayo kongʼiye to chango.” ");
INSERT INTO luo_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Omiyo Musa noloso thuol mar mula mi okete ewi luth. Kane ngʼato thuol okayo mi bangʼe ongʼiyo thuond mulano to nochango. ");
INSERT INTO luo_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Jo-Israel nodhi nyime giwuoth mi gigo kambi kama iluongo ni Oboth. ");
INSERT INTO luo_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Eka ne giwuok Oboth mi gigo kambi kama iluongo ni Iye Abarim, mantiere e thim mochomo piny Moab kochiko yo wuok chiengʼ. ");
INSERT INTO luo_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kane giwuok kanyo negidhi nyime gi wuoth mi gigo kambi Holo mar Zered. ");
INSERT INTO luo_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Negiwuok kanyo mi gigo kambi e bath aora Arnon, ma en thim molawore nyaka e piny jo-Amor. Arnon en kiewo mar Moab, mantiere e kind Moab kod jo-Amor. ");
INSERT INTO luo_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Mano emomiyo Kitabu mar Lweny mar Jehova Nyasaye wacho niya, “Waheb mantiere Sufa kod holo mar aora Arnon, ");
INSERT INTO luo_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","kod kuonde mopie mag holo matut, kendo diny mochiko kar tich mar Ar kendo manie e kiewo mar Moab.” ");
INSERT INTO luo_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Koa kanyo negidhi nyime nyaka Beer, ma en soko kama Jehova Nyasaye nonyisoe Musa niya, “Chok ji obed kanyakla kendo abiro miyogi pi.” ");
INSERT INTO luo_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Eka Israel nower wendni: “Yaye soko, bubni oko! Werne soko, ");
INSERT INTO luo_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","wer kuom soko mane rawera matin okunyo, mano mane joka ruoth okunyo; joka ruoth molony e chike kendo man-gi odunga.” Eka negiwuok e thimno ka gidhi Matana, ");
INSERT INTO luo_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ka gia Matana negidhi Nahaliel, ka gia Nahaliel negidhi Bamoth, ");
INSERT INTO luo_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","kendo kane gia Bamoth negidhi e holo mar Moab kama omanyore gi wi got Pisga minyalo nenogo kama otwo. ");
INSERT INTO luo_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israel nooro joote mondo owach ne Sihon ma ruodh jo-Amor kama: ");
INSERT INTO luo_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Yienwauru wakal e pinyu. Ok wanabar tenge e puothu moro amora kata e mago mag mzabibu, kata modho pi moa e soko moro amora. Wabiro wuotho e yor ruoth moriere tir nyaka wakal pinyruodhi.” ");
INSERT INTO luo_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","To Sihon notamo jo-Israel kalo e pinye. Nochoko ogandane mar lweny duto kendo negidhi e thim mondo giked gi Israel. Kane ochopo Jahaz, nokedo gi Israel. ");
INSERT INTO luo_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Kata kamano jo-Israel nonege gi ligangla kendo gikawo puothe koa aora Arnon nyaka Jabok, ma en tongʼ mar jo-Amon kendo ne giyudo e pinyno ka jogo roteke. ");
INSERT INTO luo_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israel nomako mier madongo duto mag jo-Amor kendo negidak kuondego, kaachiel gi Heshbon kod kuonde dak duto molwore. ");
INSERT INTO luo_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshbon ne en dala maduongʼ mar Sihon ruodh jo-Amor mane osekedo gi ruoth machon mar Moab kendo nosemayo lopene duto mochopo nyaka aora Arnon. ");
INSERT INTO luo_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Mano emomiyo jochuog wer nowero niya, “Bi Heshbon mondo mi ogere kendo; mad dala maduongʼ mar Sihon ochal kaka chon. ");
INSERT INTO luo_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Mach nowuok Heshbon, en mach makakni moa e dala maduongʼ mar Sihon. Nowangʼo Ar man Moab, ma gin jokanyo mag kuonde motingʼore malo mag Arnon. ");
INSERT INTO luo_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Okwongʼi, yaye Moab, otieku duto, yaye jo-Kemosh! Oseweyo yawuote e lwet nono mobedo jonjore kendo nyige obedo joma oter e twech, ir Sihon ruodh jo-Amor. ");
INSERT INTO luo_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“To waseloko loch margi; Heshbon osetieki duto nyaka ochopo Dibon. Wasemukogi nyaka chopi Nofa, modhi nyaka Medeba.” ");
INSERT INTO luo_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Omiyo Israel nodak e piny jo-Amor. ");
INSERT INTO luo_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Bangʼ ka Musa noseoro jonon piny Jazer, jo-Israel nokawo kuonde dak molwore kendo ne giriembo jo-Amor mane ni kanyo. ");
INSERT INTO luo_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Eka negigomo ma giluwo yo madhi Bashan, kendo Og ruodh Bashan gi jolweny mage duto nowuok riat mokedo kodgi e lweny Edrei. ");
INSERT INTO luo_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Jehova Nyasaye nowacho ne Musa niya, “Kik iluore, nimar asechiwe e lweti, en kaachiel gi jolweny mage duto kod pinye. Timne kaka ne itimone Sihon ruodh jo-Amor, mane obedo gi loch e piny Heshbon.” ");
INSERT INTO luo_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Omiyo neginege, en kaachiel gi yawuote kod jolweny mage duto, maonge ngʼama otony mane odongʼ. Kendo negikawo pinye. ");
INSERT INTO luo_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Eka jo-Israel nowuotho e pewe mag Moab mi gibworo e dho Aora Jordan momanyore gi Jeriko. ");
INSERT INTO luo_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak wuod Zipor noneno gigo duto mane jo-Israel osetimo ni jo-Amor, ");
INSERT INTO luo_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","kendo Moab ne nigi bwok maduongʼ nikech jogo ne ngʼeny ahinya. Adiera, Moab luoro nomako ahinya nikech jo-Israel. ");
INSERT INTO luo_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Jo-Moab nowacho ne jodong Midian niya, “Oganda mangʼenyni biro tieko gimoro amora ma wan-go, mana kaka rwath tieko lum manie pap.” Omiyo Balak wuod Zipor, mane ruodh Moab e kindeno, ");
INSERT INTO luo_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","nooro joote mondo oluong Balaam wuod Beor, mane ni Pethor but Aora Yufrate, mantiere e piny mane onywole. Balak nowacho kama: “Ogandagi oa Misri; gipongʼo wangʼ piny kendo gidak machiegni koda. ");
INSERT INTO luo_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Koro bi mondo ikwongʼ jogi, nikech tekregi thoth. Dibed ni bangʼ ma anyalo loyogi mi ariembgi gia e pinyni. Nimar angʼeyo ni joma igwedho ogwedhi, kendo joma ikwongʼo okwongʼ.” ");
INSERT INTO luo_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Jodong Moab kod Midian nowuok, ka gikawo chudo mar koro. Kane gichopo ir Balaam, neginyise gima Balak nowacho. ");
INSERT INTO luo_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam nowachonegi niya, “Ninduru ka kawuono kendo abiro miyou dwoko ma Jehova Nyasaye omiya.” Omiyo jotend jo-Moab nobedo kode. ");
INSERT INTO luo_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Nyasaye nofwenyore ne Balaam mopenje niya, “Magi ngʼa gini man kodigi?” ");
INSERT INTO luo_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","To Balaam nonyiso Nyasaye niya, “Balak wuod Zipor, ma ruodh Moab, noorona ote ni: ");
INSERT INTO luo_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Joma oa Misri opongʼo wangʼ piny. Koro bi kendo ikwongʼnagi. Dibed ni bangʼe anyalo kedo kodgi mi ariembgi.’ ” ");
INSERT INTO luo_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","To Nyasaye nowacho ne Balaam niya, “Kik idhi kodgi. Kik ikwongʼ jogo, nikech gin joma ogwedhi.” ");
INSERT INTO luo_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Kinyne gokinyi Balaam noa malo mi owachone jotend Balak niya, “Doguru e pinyu, nimar Jehova Nyasaye osedagi weya mondo adhi kodu.” ");
INSERT INTO luo_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Omiyo jotend jo-Moab nodok ir Balak mi owacho niya, “Balaam nodagi biro kodwa.” ");
INSERT INTO luo_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Eka Balak nooro jotelo mamoko mangʼeny moloyo kendo mongirore moloyo mokwongo ka. ");
INSERT INTO luo_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Negidok ir Balaam mi giwachone kama: “Ma e gima Balak wuod Zipor wacho: Kik iwe gimoro amora tami biro ira, ");
INSERT INTO luo_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","nikech abiro chuli maber kendo timoni gimoro amora miwacho. Bi mondo ikwongʼna ogandani.” ");
INSERT INTO luo_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","To Balaam nodwoko jotij Balak niya, “Kata ne bed ni Balak ne omiya kar dakne mopongʼ gi fedha gi dhahabu, to ok anyal timo gimoro amora maduongʼ kata matin makalo chik mar Jehova Nyasaye ma Nyasacha. ");
INSERT INTO luo_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Koro ninduru ka otienoni kaka jowadu mamoko ka notimo, mondo abi awinjiane gima nyien ma Jehova Nyasaye biro nyisa kuom wachni.” ");
INSERT INTO luo_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Nyasaye nofwenyore ne Balaam otienono mowachone niya, “Nikech jogi obiro luongi, yie idhi kodgi, to kata kamano itim mana gima anyisi.” ");
INSERT INTO luo_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam nochiewo gokinyi, moidho pundane kendo nodhi gi jotelo mag Moab. ");
INSERT INTO luo_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","To mirima nomako Nyasaye ahinya kane odhi, kendo malaika mar Jehova Nyasaye nochungʼ e yo mondo ogengʼne. Balaam noidho pundane, kendo jotijene ariyo bende ne ni kode. ");
INSERT INTO luo_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Kane pundano oneno malaika mar Jehova Nyasaye kochungʼ e chuny yo kotingʼo ligangla e lwete, nobaro oko mar yo modhi e puodho. Balaam nogoye mondo oduog e wangʼ yo. ");
INSERT INTO luo_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Eka malaika mar Jehova Nyasaye nodhi mochungʼ kamoro ma yo dinygo e kind puothe ariyo mag mzabibu kama ochiel gohinga koni gi koni. ");
INSERT INTO luo_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Kane pundano oneno malaika mar Jehova Nyasaye, nosudo machiegni gohingano moreyo tiend Balaam gohingano. Omiyo nogoyo pundano kendo. ");
INSERT INTO luo_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Eka malaika mar Jehova Nyasaye nosudo nyime mi ochungʼ kama diny maonge thuolo mar lokruok, korachwich kata koracham. ");
INSERT INTO luo_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Kane pundano oneno malaika mar Jehova Nyasaye, nonindo piny e tiend Balaam, kendo ii Balaam nowangʼ mi ochwade gi luth. ");
INSERT INTO luo_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Eka Jehova Nyasaye noyawo dho pundano, kendo nowacho ne Balaam niya, “En angʼo masetimoni momiyo isegoya nyadidek?” ");
INSERT INTO luo_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam nodwoko pundano niya, “Isemiya achalo ngʼama ofuwo! Kane bed ni an-gi ligangla e lweta, to dikoro asenegi.” ");
INSERT INTO luo_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Pundano nopenjo Balaam niya, “Donge an mana pundani owuon, ma isebedo ka iidho, nyaka kawuononi? Bende iseneno ka an gi kido mar timoni gima chalo kama?” Nodwoke niya, “Ooyo.” ");
INSERT INTO luo_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Bangʼe Jehova Nyasaye noyawo wenge Balaam, mi noneno malaika mar Jehova Nyasaye kochungʼ e wangʼ yo korieyo ligangla mare. Omiyo nokulore piny kendo nopodho auma e lowo. ");
INSERT INTO luo_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Malaika mar Jehova Nyasaye nopenje niya, “Angʼo momiyo isechwado pundani nyadidek? Abiro mondo agengʼi nikech yoreni obam e nyima. ");
INSERT INTO luo_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Punda nonena nyadidek mobaro oa yo. To ka dine ok obaro, to dine asenegi, to en to aweye odhi.” ");
INSERT INTO luo_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam nowacho ne malaika mar Jehova Nyasaye niya, “Asetimo richo. Ne ok angʼeyo nine ichungʼ e wangʼ yo mondo igengʼna. Koro ka ok imor, to abiro dok dala.” ");
INSERT INTO luo_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Malaika mar Jehova Nyasaye nowacho ne Balaam niya, “Dhiyo adhiya gi jogi, to iwach mana gima awachoni.” Omiyo Balaam nodhi gi jodong Balak. ");
INSERT INTO luo_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Kane Balak owinjo ni Balaam biro, nowuok mondo oromne e dala jo-Moab mokiewo gi aora Arnon, e giko mar pinye. ");
INSERT INTO luo_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak nowacho ne Balaam niya, “Donge ne aoroni joote mondo ibi ira piyo? Angʼo ma nomoni biro ira? Koso iparo ni ok anyal chuli?” ");
INSERT INTO luo_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam nodwoko niya, “Mano ber, eri asebiro. Koso iparo ni anyalo wacho gimoro amora? Ooyo, nyaka awach mana gima Nyasaye oketo e dhoga.” ");
INSERT INTO luo_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Eka Balaam nodhi gi Balak nyaka Kiriath Huzoth. ");
INSERT INTO luo_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak nochiwo misango mar dhok kod rombe, kendo nochiwo moko ne Balaam kod jodongo mane ni kode. ");
INSERT INTO luo_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Kinyne gokinyi Balak nokawo Balaam motero Bamoth Baal, kendo kanyo noneno bath oganda. ");
INSERT INTO luo_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam nowacho niya, “Gerna kende abiriyo mag misango ka, kendo ikna rwedhi abiriyo kod imbe abiriyo.” ");
INSERT INTO luo_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak notimo kaka Balaam nowacho, kendo negichiwo rwath gi im ewi kendo ka kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Eka Balaam nowacho ne Balak niya, “Bed but misango ka, ka an to alengʼora e bathe ka; nimar sa moro dipo ka Jehova Nyasaye ofwenyorena. Gimoro amora monyisa to abiro nyisi.” Eka nowuok modhi kama otingʼore gi malo motwo. ");
INSERT INTO luo_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Nyasaye nofwenyore ne Balaam kendo Balaam nowachone niya, “Aseloso kende abiriyo mag misango, kendo ewi kendo ka kendo asechiwe misango mar rwath kod im.” ");
INSERT INTO luo_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Jehova Nyasaye nomiyo Balaam ote kowachone niya, “Dog ir Balak kendo imiye wachni.” ");
INSERT INTO luo_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Omiyo nodok moyudo Balak kochungʼ but misango mane osechiwo ka en gi jodong Moab duto. ");
INSERT INTO luo_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Eka Balaam nohulo ote moa kuom Nyasaye kama: “Balak ruodh Moab manie piny gode man yo wuok chiengʼ nooma Aram. Nowacho ni, ‘Bi mondo ikwongʼna Jakobo; bi mondo ikwedna jo-Israel.’ ");
INSERT INTO luo_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ere kaka anyalo kwongʼo joma Nyasaye pok okwongʼo? Ere kaka anyalo kwedo joma Jehova Nyasaye pok okwedo? ");
INSERT INTO luo_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Anenogi ka achungʼ ewi kite mabeyo; kendo arangogi gi ewi gode. Aneno oganda modak kar kendgi ma ok oseriwore gi ogendini mamoko. ");
INSERT INTO luo_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ere ngʼama nyalo kwano kar romb oganda joka Jakobo machalo gi buru kata ngʼama nyalo kwano migawo mar angʼwen mar Israel? Weuru atho kaka joma kare tho, kendo mad giko mara ochal kod margi!” ");
INSERT INTO luo_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak nopenjo Balaam niya, “En angʼo ma isetimona? Ne aomi mondo ikwongʼ wasika, to onge gima isetimo makmana gwedhogi!” ");
INSERT INTO luo_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Nodwoke niya, “Ok anyal wacho gima Jehova Nyasaye ne ok onyisa?” ");
INSERT INTO luo_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Eka Balak nowachone niya, “Bi wadhi kamoro machielo kama inyalo nenogie; ibiro mana neno moko kuomgi to ok giduto. To ka isenenogi, to ikwongʼnagi.” ");
INSERT INTO luo_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Omiyo notere e pap mar Zofim mantiere ewi Got Pisga, kendo kanyo nogero kende mag misango abiriyo mi nochiwo misango mar rwath kod im ewi kendo ka kendo. ");
INSERT INTO luo_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaam nowacho ne Balak niya, “Bed but misangoni ka, ka anto adhi romo gi Nyasaye bathe kocha.” ");
INSERT INTO luo_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Jehova Nyasaye nofwenyore ne Balaam kendo nomiyo Balaam ote kowachone niya, “Dog ir Balak kendo imiye wachni.” ");
INSERT INTO luo_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Omiyo nodok moyudo Balak kochungʼ but misangone, ka en-gi jodong Moab. Balak nopenje niya, “Angʼo mane Jehova Nyasaye owacho?” ");
INSERT INTO luo_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Eka Balaam nohulo ote moa kuom Nyasaye kama: Aa malo, Balak, kendo ichik iti; winja, wuod Zipor. ");
INSERT INTO luo_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Nyasaye ok en dhano, mondo omi oriambi, kata ok en wuod dhano, mondo omi olok pache. Bende onyalo wuoyo to ok otim kaka owacho? Bende onyalo chiwo singo, to ok ochop singruokno? ");
INSERT INTO luo_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ne ayudo chik mondo achiw gweth; osegwedhogi, kendo ok anyal loko mano. ");
INSERT INTO luo_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Onge kido magalagala moyud kuom Jakobo, kata tim moro marach moyud kuom Israel. Jehova Nyasaye ma Nyasachgi ni kodgi; teko mar Ruoth ni kodgi. ");
INSERT INTO luo_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Nyasaye nogologi Misri; tekogi chalo gi teko jowi. ");
INSERT INTO luo_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Onge tim jwok manyalo mako joka Jakobo, kendo timbe ndagla ok nyal mako Israel. Ibiro goyo ngero kuom joka Jakobo ma Israel ni, ‘Ne gima Nyasaye osetimo!’ ");
INSERT INTO luo_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ogandani ger mana ka sibuor madhako; kendo gijuol ka sibuor madichwo, ma ok nyal nindo piny nyaka ocham gima onego momadh rembe.” ");
INSERT INTO luo_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Eka Balak nowacho ne Balaam niya, “Kare koro kik ikwongʼ-gi kata kik igwedhgi!” ");
INSERT INTO luo_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaam nodwoke niya, “Donge ne anyisi ni nyaka atim mana gima Jehova Nyasaye onyisa?” ");
INSERT INTO luo_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Eka Balak nowacho ne Balaam niya, “Bi wadhi kamachielo. Dibed ni biro bedo maber ne Nyasaye mondo ikwongʼnagi kanyo.” ");
INSERT INTO luo_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Kendo Balak nokawo Balaam nyaka ewi Peor, momanyore gi kama otwo. ");
INSERT INTO luo_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam nowacho niya, “Gerna kende abiriyo mag misango kae, kendo ikna rwedhi abiriyo kod imbe abiriyo.” ");
INSERT INTO luo_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak notimo kaka Balaam nonyise kendo nochiwo misango mar rwath kod im ewi kendo ka kendo mar misango. ");
INSERT INTO luo_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Omiyo kane Balaam oneno ni berne Jehova Nyasaye mondo ogwedh Israel, ne ok otimo tim jwok kaka ne osetimo e kinde mokalo, to nolokore kongʼiyo yo thim. ");
INSERT INTO luo_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Kane Balaam ongʼiyo oko mi oneno jo-Israel kochokore e dhoot ka dhoot, Roho mar Nyasaye nobiro kuome ");
INSERT INTO luo_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","mi nochiwo ote mare kama: “Ote Balaam wuod Beor, ote mar ngʼat ma wengene neno maber, ");
INSERT INTO luo_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ote mar ngʼat mawinjo weche Nyasaye, ngʼat maneno fweny moa kuom Nyasaye Maratego, ngʼat mopodho piny auma, kendo ma wengene oyawore. ");
INSERT INTO luo_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Mano kaka hembe magi ber neno, yaye Jakobo, kuondeni mag dak, yaye Israel! ");
INSERT INTO luo_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Gilandore ka holni, mana ka puothe mantiere e bath aora, mana ka mane-mane ma Jehova Nyasaye opidho, bende mana ka yiend sida mopidh but pi. ");
INSERT INTO luo_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Pi ma aa e dapigeni biro pongʼ mao oko; kendo kothgi nochal gi pi mabubni. “Ruodhgi nobed gi teko moloyo Agag; pinyruodhgi notingʼ malo. ");
INSERT INTO luo_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Nyasaye nogologi Misri; kendo gin gi teko machalo mar jowi. Gikidho oganda jowasikgi kendo gituro chokegi matindo tindo; kendo gichwowogi gi aserni mag-gi. ");
INSERT INTO luo_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Gilidho ka ginindo piny mana ka sibuor madichwo, bende mana ka sibuor madhako maonge ngʼama nyalo chiewo? “Mad joma ogwedhi gwedhi to joma kwongʼi mondo okwongʼ!” ");
INSERT INTO luo_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Eka Balak nobedo gi mirima mager gi Balaam. Noriwo lwetene kanyakla mi owachone niya, “Ne aomi mondo ikwongʼna wasika, to isemana gwedhogi ndalo adekgi. ");
INSERT INTO luo_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Koro aa sani sani mondo idhi dala! Ne awachoni ni abiro miyi chudo maber, to Jehova Nyasaye osetami yudo chudono.” ");
INSERT INTO luo_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam nodwoko Balak niya, “Donge ne anyiso joote mane ioro ira niya, ");
INSERT INTO luo_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Kata bed ni Balak ne miya ode mar ruoth mopongʼ gi fedha gi dhahabu, to ne ok anyal timo gimoro amora gi pacha awuon mopogore gi chik Jehova Nyasaye bed ni ber kata rach?’ ");
INSERT INTO luo_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Koro adok ir jowa, to kapok adhi to we anyisi gima jo-Israel biro timo, asiemi kuom gik ma jogi biro timo ne jogi e ndalo mabiro.” ");
INSERT INTO luo_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Eka Balaam nohulo ote moa kuom Nyasaye kama: “Ote mar Balaam wuod Beor, ote mar ngʼat man-gi wangʼ maneno ler, ");
INSERT INTO luo_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ote mar ngʼat mawinjo weche Nyasaye, ngʼat man-gi rieko moa kuom Nyasaye Man Malo Moloyo, ngʼat maneno fweny moa kuom Nyasaye Maratego, ngʼat moriere piny auma, kendo ma wengene oyawore. ");
INSERT INTO luo_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Anene, to ok sani; asudo machiegni, to ok bute. Sulwe biro wuok koa kuom Jakobo; ludh loch biro wuok ei Israel. Obiro toyo wiye jo-Moab, kod wiye yawuot Sheth duto. ");
INSERT INTO luo_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Obiro loyo piny jo-Edom e lweny mi okaw; kendo Seir ma wasike, nokaw, to Israel nomed bedo motegno. ");
INSERT INTO luo_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Jatelo noa e oganda joka Jakobo, kendo enotiek joma otony mag dala maduongʼ.” ");
INSERT INTO luo_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Eka Balaam noneno Amalek kendo nowachone ote mar Nyasaye kama: “Amalek ema ne okwongo kuom ogendini, to gikone ibiro tieke.” ");
INSERT INTO luo_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Eka noneno jo-Keni kendo ochiwo oteneni: “Kar dak mari nigi kwe, kari mar pondo ni e bwo lwanda; ");
INSERT INTO luo_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","kata kamano un jo-Keni ibiro negu ndalo ma Ashur oterou e twech.” ");
INSERT INTO luo_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Eka nochiwo otene niya, “Yaye, en ngʼa manyalo bedo mangima ka Nyasaye otimo ma? ");
INSERT INTO luo_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Yiedhi madongo mathoth nobi koa e dho nam mar Kitim; gibiro mako Ashur kod Eber, to kata gin bende ibiro tiekgi.” ");
INSERT INTO luo_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Eka Balaam noa malo mi odok dala kendo Balak bende nodhi e yore owuon. ");
INSERT INTO luo_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Kane oyudo jo-Israel odak Shitim, chwo nochako terore gi monde jo-Moab, ");
INSERT INTO luo_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","mane ogwelogi e chiwo misengini ne nyisechegi. Ji nochiemo moyiengʼ kendo negipodho auma ka gilamo nyisechegi. ");
INSERT INTO luo_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Omiyo Israel noriwore kodgi e yor lamo Baal mar Peor. Kendo mirima nomako Jehova Nyasaye ahinya kodgi. ");
INSERT INTO luo_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Jehova Nyasaye nowacho ne Musa niya, “Kaw jotend jogi duto, neg-gi kendo dhurgi e lela e nyim Jehova Nyasaye, mondo omi mirimb Jehova Nyasaye owuog kuom Israel.” ");
INSERT INTO luo_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Omiyo Musa nowacho ne jongʼad bura mag Israel niya, “Ngʼato ka ngʼato kuomu nyaka neg jou machwo ma oseriwore e lamo Baal mar Peor.” ");
INSERT INTO luo_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Eka ja-Israel moro nobiro gi nyar jo-Midian e hembe ka Musa neno kaachiel gi oganda jo-Israel duto mane oyudo ywak e dho Hemb Romo. ");
INSERT INTO luo_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Kane Finehas wuod Eliazar, ma wuod Harun jadolo, noneno ma, nowuok e chokruokno, mokawo tongʼ e lwete, ");
INSERT INTO luo_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","kendo noluwo bangʼ ja-Israelno nyaka e hema. Nochwowogi duto moriwogi gi tongʼ. Eka tho mane osenego jo-Israel norumo; ");
INSERT INTO luo_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","to ji mane tho ma kamano onego ne gin ji alufu piero ariyo gangʼwen (24,000). ");
INSERT INTO luo_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehas wuod Eliazar, ma wuod Harun jadolo, osetieko mirimba kuom jo-Israel; nimar en gi nyiego machal gi mara; mano emomiyo ne ok atiekogi kata obedo nine an kod mirima kodgi kamano. ");
INSERT INTO luo_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Emomiyo nyise ni aloso singruok mar kwe kode. ");
INSERT INTO luo_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Asingorane ni en kod nyikwaye ginibed jodolo maga nyaka chiengʼ, nikech ne en jasinani kuom miyo Nyasache duongʼ kendo negichiwo misango mar pwodho jo-Israel e richo.” ");
INSERT INTO luo_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Nying ja-Israel mane onegi gi nyar jo-Midian ne en Zimri wuod Salu, mane en jatend dhood Simeon. ");
INSERT INTO luo_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","To nying nyar jo-Midian mane onegi ne en Kozbi ma nyar Zur, ma wuon-gi ne en jatend dhood jo-Midian. ");
INSERT INTO luo_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Sanduru jo-Midian kendo uneg-gi, ");
INSERT INTO luo_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","nikech ne githagou gi timbegi maricho mane gitimo Peor kendo kuom wach Kozbi ma nyar jatend Midian mane onegi ndalo mane yamb tho obiro nikech gima notimore Peor.” ");
INSERT INTO luo_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Bangʼ masirano Jehova Nyasaye nowacho ne Musa kod Eliazar wuod Harun jadolo niya, ");
INSERT INTO luo_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Kwan ogendini mag jo-Israel duto kaluwore gi anywolagi, mago mahikgi piero ariyo kadhi nyime manyalo bedo jolweny e Israel.” ");
INSERT INTO luo_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musa kod Eliazar jadolo nowuoyo kod jo-Israel e pewe mag Moab mantiere e loka Jordan kod Jeriko mowachonegi niya, ");
INSERT INTO luo_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Kwanuru jogo mahikgi romo piero ariyo kadhi nyime, mana kaka Jehova Nyasaye nochiko Musa.” Jo-Israel mane owuok Misri e magi: ");
INSERT INTO luo_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Nyikwa Reuben, ma en wuod Israel makayo, ne gin: kokadho kuom Hanok, ne gin joka Hanok; kokadho kuom Palu, ne gin joka Palu; ");
INSERT INTO luo_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","kokadho kuom Hezron, ne gin joka Hezron; kokadho kuom Karmi, ne gin joka Karmi. ");
INSERT INTO luo_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Magi ema ne joka Reuben; ma kar kwan-gi ne romo ji alufu piero angʼwen mia abiriyo gi piero adek (43,730). ");
INSERT INTO luo_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Wuod Palu ne en Eliab, ");
INSERT INTO luo_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","to yawuot Eliab ne gin Nemuel, Dathan kod Abiram. Dathan-no kod Abiram ne jotend oganda, to kata kamano negikwedo Musa kod Harun kendo gijiwo joma ne luwo Kora kuom kwedo Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Piny nongʼamo dhoge mi omwonyogi kaachiel gi Kora, ma joma ne luwo bangʼe ji mia ariyo gi piero abich notho e mach. Jogi nobedo kaka ranyisi mar siemo ji. ");
INSERT INTO luo_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","To kata kamano, joka Kora ne ok orumo. ");
INSERT INTO luo_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Nyikwa Simeon kaluwore gi anywola margi ne gin: koa kuom Nemuel, joka Nemuel; koa kuom Jamin, joka Jamin; koa kuom Jakin, joka Jakin; ");
INSERT INTO luo_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","koa kuom Zera, joka Zera; koa kuom Shaul, joka Shaul. ");
INSERT INTO luo_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Magi ema ne joka Simeon; ma kar kwan-gi ne romo ji alufu piero ariyo gariyo mia ariyo (22,200). ");
INSERT INTO luo_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Nyikwa Gad kaluwore gi anywola margi ne gin: koa kuom Zefon, joka Zefon; koa kuom Hagai, joka Hagi; koa kuom Shuni, joka Shuni; ");
INSERT INTO luo_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","koa kuom Ozni, joka Ozni; koa kuom Eri, joka Eri; ");
INSERT INTO luo_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","koa kuom Arodi, joka Arodi; koa kuom Areli, joka Areli. ");
INSERT INTO luo_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Magi ema ne joka Gad; ma kar kwan-gi ne romo ji alufu piero angʼwen mia abich (40,500). ");
INSERT INTO luo_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Yawuot Juda ma Er kod Onan notho Kanaan. ");
INSERT INTO luo_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Nyikwa Juda kaluwore gi anywola margi ne gin: koa kuom Shela, joka Shela; koa kuom Perez, joka Perez; koa kuom Zera, joka Zera. ");
INSERT INTO luo_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Nyikwa Perez ne gin: koa kuom Hezron, joka Hezron; koa kuom Hamul, kod joka Hamul. ");
INSERT INTO luo_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Magi ema ne joka Juda; ma kar kwan-gi ne romo ji alufu piero abiriyo gauchiel gi mia abich (76,500). ");
INSERT INTO luo_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Nyikwa Isakar kaluwore gi anywola margi ne gin: koa kuom Tola, joka Tola; koa kuom Pua, joka Pua; ");
INSERT INTO luo_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","koa kuom Jashub, joka Jashub; koa kuom Shimron, joka Shimron. ");
INSERT INTO luo_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Magi ema ne joka Isakar, ma kar kwan-gi ne romo ji alufu piero auchiel angʼwen gi mia adek (64,300). ");
INSERT INTO luo_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Nyikwa Zebulun kaluwore gi anywola margi ne gin: koa kuom Sered, joka Sered; koa kuom Elon, joka Elon; koa kuom Jalel, joka Jalel. ");
INSERT INTO luo_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Magi ema ne joka Zebulun, ma kar kwan-gi ne romo ji alufu piero auchiel gi mia abich (60,500). ");
INSERT INTO luo_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Nyikwa Josef kaluwore gi anywola margi kokalo kuom Manase kod Efraim ne gin: ");
INSERT INTO luo_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Nyikwa Manase ne gin: koa kuom Makir, joka Makir (Makir ne en wuod Gilead); koa kuom Gilead, joka Gilead. ");
INSERT INTO luo_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Nyikwa Gilead e magi: koa kuom Iezer, joka Iezer; koa kuom Helek, joka Helek; ");
INSERT INTO luo_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","koa kuom Asriel, joka Asriel; koa kuom Shekem, joka Shekem; ");
INSERT INTO luo_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","koa kuom Shemida, joka Shemida; koa kuom Hefer, joka Hefer. ");
INSERT INTO luo_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Kata kamano Zelofehad wuod Hefer ne onge yawuowi; to ne en mana gi nyiri kende, ma nyingegi ne gin Mala, Nowa, Hogla, Milka gi Tirza.) ");
INSERT INTO luo_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Magi ema ne joka Manase; ma kar kwan-gi ne romo ji alufu piero abich gariyo mia abiriyo (52,700). ");
INSERT INTO luo_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Nyikwa Efraim kaluwore gi anywola margi e magi: koa kuom Shuthela, joka Shuthela; koa kuom Beker, joka Beker; koa kuom Tahan, joka Tahan. ");
INSERT INTO luo_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Magi ema ne nyikwa Shuthela: kokadho kuom Eran, ne gin joka Eran. ");
INSERT INTO luo_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Magi ema ne joka Efraim; ma kar kwan-gi ne romo ji alufu piero adek mia abich. Magi duto ne gin nyikwa Josef kaluwore gi anywola mag-gi. ");
INSERT INTO luo_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Nyikwa Benjamin kaluwore gi anywola margi ne gin: koa kuom Bela, joka Bela; koa kuom Ashbel, joka Ashbel; koa kuom Ahiram, joka Ahiram; ");
INSERT INTO luo_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","koa kuom Shufam, joka Shufam; koa kuom Hufam, joka Hufam. ");
INSERT INTO luo_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Nyikwa Bela kokalo kuom Ard gi Naaman ne gin: koa kuo Ard, joka Ard; koa kuom Naaman, joka Naaman. ");
INSERT INTO luo_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Magi ema ne joka Benjamin; ma kar kwan-gi ne romo ji alufu piero angʼwen gabich mia auchiel (45,600). ");
INSERT INTO luo_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Nyikwa Dan kaluwore gi anywolagi ne gin: koa kuom Shulam, joka Shuham. Magi ema ne anywola mag Dan: ");
INSERT INTO luo_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Anywola jo-Shuham duto kar kwan-gi ne romo ji alufu piero auchiel gangʼwen mia angʼwen (64,400). ");
INSERT INTO luo_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Nyikwa Asher kaluwore gi anywola margi ne gin: koa kuom Imna, joka Imna; koa kuom Ishvi, joka Ishvi; koa kuom Beria, joka Beria; ");
INSERT INTO luo_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","kendo koa kuom nyikwa Beria ne gin: joka Heber; kod joka Malkiel. ");
INSERT INTO luo_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","To Asher ne nigi nyako ma nyinge Sera. ");
INSERT INTO luo_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Magi ema ne joka Asher; ma kar kwan-gi ne romo ji alufu piero abich gadek mia angʼwen (53,400). ");
INSERT INTO luo_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Nyikwa Naftali kaluwore gi anywola margi ne gin: koa kuom Jazel, joka Jazel; koa kuom Guni, joka Guni; ");
INSERT INTO luo_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","koa kuom Jezer, joka Jezer; koa kuom Shilem, joka Shilem. ");
INSERT INTO luo_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Magi ema ne joka Naftali; ma kar kwan-gi ne romo ji alufu piero angʼwen gabich mia angʼwen (45,400). ");
INSERT INTO luo_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Kar kwan jo-Israel duto ne romo ji alufu mia auchiel gachiel, mia abiriyo gi piero adek (601,730). ");
INSERT INTO luo_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Nyaka pog jo-Israel pinyni kaka girkeni kaluwore gi kar kwan-gi. ");
INSERT INTO luo_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Dhoot maduongʼ imi lowo maduongʼ to dhoot matin to imi lowo matin; dhoot ka dhoot mondo oyud pok maromre gi kar kwan-gi. ");
INSERT INTO luo_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Nyaka ine ni lopegi opog gi ombulu. Pok mar oganda ka oganda biro bedo kaluwore gi nying kweregi. ");
INSERT INTO luo_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Pok moro ka moro nyaka pog gi ombulu e kind dhoudi madongo gi matindo.” ");
INSERT INTO luo_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Jo-Lawi mane okwan kaluwore gi anywola ne gin: koa kuom Gershon, joka Gershon; koa kuom Kohath, joka Kohath; koa kuom Merari, joka Merari. ");
INSERT INTO luo_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Jo-Lawi mamoko mane okwan ne gin: joka Libni, joka Hebron, joka Mali, joka Mushi, joka Kora. (Kohath ne kwar Amram; ");
INSERT INTO luo_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","kendo jaod Amram ne nyinge Jokebed, ma nyakwar Lawi, mane onywol ne jo-Lawi e Piny Misri. Amram nonywolo Harun, Musa kod nyamin-gi Miriam. ");
INSERT INTO luo_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Harun ne en wuon Nadab gi Abihu, Eliazar kod Ithamar. ");
INSERT INTO luo_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","To kata kamano Nadab gi Abihu notho kane gichiwo misango e nyim Jehova Nyasaye gi mach ma ok oyiego.) ");
INSERT INTO luo_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Kar kwan jo-Lawi machwo ma ja-dwe achiel kadhi nyime kwan-gi ne romo ji alufu piero ariyo gadek (23,000). Ne ok okwan-gi gi jo-Israel mamoko nikech ne ok opog-gi lowo. ");
INSERT INTO luo_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Magi e joma ne okwan gi Musa kod Eliazar jadolo e kinde mane okwan jo-Israel e paw Moab mantiere e loka Jordan koa Jeriko. ");
INSERT INTO luo_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Onge moro amora kuomgi mane okwan gi Musa kod Harun jadolo e kinde mane gikwano jo-Israel e Thim mar Sinai. ");
INSERT INTO luo_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Nimar Jehova Nyasaye ne owachone jo-Israelgo ni nyaka githo e thim, kendo onge kata ngʼata achiel kuomgi mane otony makmana Kaleb wuod Jefune kod Joshua wuod Nun. ");
INSERT INTO luo_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Nyi Zelofehad wuod Hefer, ma wuod Gilead, ma wuod Makir, ma wuod Manase, ne gin joka Manase wuod Josef. Nyirigo ne gin Mala, Nowa, Hogla, Milka kod Tirza. Negisudo machiegni gi ");
INSERT INTO luo_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","kar donjo mar Hemb Romo mi gichungʼ e nyim Musa, Eliazar jadolo, jotelo kod chokruok mar oganda duto, mi giwacho niya, ");
INSERT INTO luo_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Wuonwa notho e thim. Ne ok en achiel kuom jolup Kora, mane okwedo Jehova Nyasaye, to notho nikech richone owuon kendo ne ok onywolo yawuowi. ");
INSERT INTO luo_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Angʼo ma dimi nying wuonwa lal nono e anywolagi nikech ne ok onywolo wuowi? Yie upognwa kamoro e kind wede wuonwa.” ");
INSERT INTO luo_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Omiyo Musa nokelo wachgini e nyim Jehova Nyasaye ");
INSERT INTO luo_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","kendo Jehova Nyasaye nowachone niya, ");
INSERT INTO luo_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Gima nyi Zelofehad owacho nikare. Nyaka ipog-gi gimoro kaka girkeni ei wede wuon-gi kendo girkeni mag wuon-gi imigi. ");
INSERT INTO luo_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Wachne jo-Israel ni, ‘Ka dichwo otho ma ok onywolo wuowi, to ipog nyathine ma nyako girkeni mare. ");
INSERT INTO luo_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","To ka oonge gi nyako, to ipog owetene girkeni mare. ");
INSERT INTO luo_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","To ka oonge gi owete, to ipog owete gi wuonene girkeni mare. ");
INSERT INTO luo_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","To ka wuon-gi onge gi owetene, to ipog watne moro amora machiegni kode e anywolagi, mondo oyud girkenino. Mae nobed chik ne jo-Israel, mana kaka Jehova Nyasaye nosechiko Musa.’ ” ");
INSERT INTO luo_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Eka Jehova Nyasaye nowacho ne Musa niya, “Dhi malo e Got Abarim kendo ingʼi piny ma asemiyo jo-Israel. ");
INSERT INTO luo_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Bangʼ ka isenene, to in bende ibiro tho miluw kwereni, mana kaka owadu Harun notho, ");
INSERT INTO luo_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","nimar e kinde mane oganda ongʼanyo e sokni mantiere e Thim mar Zin, un duto ne ok urito chikna kendo nyiso oganda ni an Ngʼama Ler.” (Magi ne sokni mag Meriba Kadesh, mantiere e Thim mar Zin.) ");
INSERT INTO luo_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa nowacho ne Jehova Nyasaye ni, ");
INSERT INTO luo_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Mad Jehova Nyasaye, ma Nyasach chunje duto mag dhano, oyier jatelo manyalo rito ogandani ");
INSERT INTO luo_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","mondo otelnegi e gik moko duto ma gitimo kendo oritgi kagiwuok kendo ka gidwogo dala mondo oganda Jehova Nyasaye kik chal gi rombe maonge jokwath.” ");
INSERT INTO luo_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Omiyo Jehova Nyasaye nowacho ne Musa niya, “Kaw Joshua wuod Nun, ngʼat man-gi Roho, kendo yie lweti kuome. ");
INSERT INTO luo_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Kete ochungʼ e nyim Eliazar jadolo kod chokruok duto mar oganda kendo ipwodhe e nyimgi. ");
INSERT INTO luo_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Miye tekoni moko mondo mi oganda jo-Israel duto omiye luor. ");
INSERT INTO luo_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Nyaka ochungʼ e nyim jadolo Eliazar, mabiro ngʼadone rieko kopenjo Urim e nyim Jehova Nyasaye. Kogolo chik, to en kod oganda jo-Israel duto nowuog oko, kendo kogolo chik to gibiro donjo iye.” ");
INSERT INTO luo_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa notimo kaka Jehova Nyasaye nochike. Nokawo Joshua mi otero e nyim Eliazar jadolo gi chokruok duto. ");
INSERT INTO luo_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Eka noyieyo lwete kuome mi opwodhe, mana kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Mi jo-Israel chikni kiwachonegi kama: ‘Kelnauru chiwo mitimonago misengini miwangʼo pep mondo obed chiemba madum tik mangʼwe ngʼar e kinde mowinjore.’ ");
INSERT INTO luo_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Wachnegi niya, ‘Misengini miwangʼo ne Jehova Nyasaye e magi: nyirombe ariyo ma jo-higa achiel maonge songa, kaka chiwo mapile mowangʼ odiechiengʼ kodiechiengʼ. ");
INSERT INTO luo_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Chiw nyarombo achiel gokinyi to machielo godhiambo, ");
INSERT INTO luo_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","kaachiel gi chiwo mar cham moromo gorogoro achiel gi nus mar mogo mayom moruw gi mo mobi e olemb zeituni moromo lita achiel. ");
INSERT INTO luo_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ma e chiwo mapile mowangʼ mopwodhi e Got Sinai kaka gima dungʼ tik mangʼwe ngʼar mamoro Jehova Nyasaye, en misango miwangʼo pep mochiwne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Nyarombo ka nyarombo nokel gi misango miolo piny maromo divai lita achiel. Nyaka uol divaino ei kama ler mar lemo ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Chiw nyarombo mar ariyo godhiambo, kaachiel gi chiwo mar cham machalo kamano kod misango miolo piny ma iloso gokinyi. Ma en chiwo miwangʼo pep, misango madungʼ tik mangʼwe ngʼar mamoro Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Chiengʼ Sabato, chiwuru misango mar nyiimbe ariyo maonge songa mahikgi achiel, kaachiel gi misango miolo piny kod chiwo mar cham maromo kilo abiriyo mar mogo mayom moru gi mo. ");
INSERT INTO luo_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Ma en misango miwangʼo pep Sabato ka Sabato, komedi ewi chiwo mapile mar misango miwangʼo pep kod misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘Odiechiengʼ mokwongo mar dwe ka dwe, chiwne Jehova Nyasaye misango miwangʼo pep mar nyirwedhi ariyo, im achiel kod nyiimbe abiriyo moromo higa achiel, duto maonge songa. ");
INSERT INTO luo_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Rwath ka rwath nyaka chiw gi chiwo mar cham maromo kilo apar mar mogo mayom moru gi mo; im to chiw gi chiwo mar cham maromo kilo abiriyo mar mogo mayom moru gi mo; ");
INSERT INTO luo_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","to nyaim ka nyaim, to chiw gi cham maromo kilo adek mar mogo mayom moru gi mo. Ma en misango miwangʼo pep, gima dungʼ tik mangʼwe ngʼar mamoro Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Rwath ka rwath nyaka chiw gi misango miolo piny mar divai maromo lita angʼwen; im to chiw gi lita achiel mar divai; to nyaim ka nyaim, to chiw gi lita achiel mar divai. Ma en misango miwangʼo pep mar dwe ka dwe ma onego chiw e higa mangima sa moro amora ma dwe manyien opor. ");
INSERT INTO luo_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Nywok achiel chiwne Jehova Nyasaye kaka misango mar pwodhruok kimedo gi misango miwangʼo pep mapile pile kod misango miolo piny michiwego. ");
INSERT INTO luo_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Nyaka utim Pasaka mar Jehova Nyasaye e odiechiengʼ mar apar gangʼwen mar dwe mokwongo. ");
INSERT INTO luo_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","E odiechiengʼ mar apar gabich mar dweno nyaka ulos sawo; kuom ndalo abiriyo chamuru makati motedi ma ok oketie thowi. ");
INSERT INTO luo_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Chiengʼ mokwongo mar jumano nyaka ubed gi chokruok mowal kendo kik uti tich moro amora mutiyo pile. ");
INSERT INTO luo_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Chiwuru ne Jehova Nyasaye misango miwangʼo pep, misango mowangʼ mar nyirwedhi ariyo, im achiel kod nyiimbe abiriyo mahikgi achiel kendo maonge songa. ");
INSERT INTO luo_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Rwath ka rwath nyaka chiw gi chiwo mar cham mar mogo mayom maromo kilo adek gi nus moru gi mo; im to ichiw gi mogo mayom maromo kilo ariyo moru gi mo; ");
INSERT INTO luo_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","to nyiimbe abiriyogo, to ichiw gi mogo mayom maromo kilo achiel moru gi mo. ");
INSERT INTO luo_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Umed nyanywok achiel mar chiwo mar pwodhruok e richo. ");
INSERT INTO luo_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Chiwuru magi kumedo ewi misango miwangʼo pep mapile pile gokinyi. ");
INSERT INTO luo_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Kamano bende kelnauru chiwo mitimogo misengini miwangʼo pile pile kuom ndalo abiriyo mondo chiemba odungʼ tik mangʼwe ngʼar ni Jehova Nyasaye; kendo nyaka ulose kumedo gi misango miwangʼo pep mapile pile kod misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","E odiechiengʼ mar abiriyo losuru chokruok mowal kendo kik uti tich moro amora mutiyo pile. ");
INSERT INTO luo_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘E odiechiengʼ mokwongo mar keyo mokwongo, kinde ma uchiwoe misango mar cham manyien ne Jehova Nyasaye e Sawo mar Jumbe, losuru chokruok maler kendo kik uti tijeu mapile. ");
INSERT INTO luo_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Chiwuru misango miwangʼo pep mag nyirwedhi ariyo, im achiel gi nyirombe abiriyo mahikgi en achiel kaka gima dungʼ tik mangʼwe ngʼar mamoro Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Rwath ka rwath nyaka chiw gi chiwo mar cham maromo kilo apar mar mogo mayom moru gi mo; im to uchiw gi kilo abiriyo; ");
INSERT INTO luo_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","to imbe abiriyogo moro ka moro to chiw gi kilo adek. ");
INSERT INTO luo_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Ewi mago meduru nywok achiel kaka chiwo mar pwodhruok e richo. ");
INSERT INTO luo_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Chiwuru magi kaachiel gi misango miolo piny, kumedo gi misango miwangʼo pep mapile pile kod chiwo mar cham. Neuru ni jamnigo onge songa. ");
INSERT INTO luo_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘E odiechiengʼ mokwongo mar dwe mar abiriyo losuru chokruok mowal kendo kik uti tijeu mapile. En odiechiengʼ mugoyoe turumbete. ");
INSERT INTO luo_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Chiwuru misango miwangʼo pep mar nyarwath achiel, im achiel kod nyiimbe abiriyo moromo higa achiel, ma duto onge songa mondo obed kaka misango madungʼ tik mangʼwe ngʼar mamoro Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Rwath ka rwath nyaka chiw gi chiwo mar cham maromo kilo apar mar mogo mayom moru gi mo; im to chiw gi kilo abiriyo; ");
INSERT INTO luo_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","nyiimbe abiriyogo moro ka moro uchiw gi kilo adek. ");
INSERT INTO luo_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Ewi mago meduru nywok achiel kaka chiwo mar pwodhruok e richo. ");
INSERT INTO luo_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Magi imedo ewi misango miwangʼo pep mar dwe ka dwe kod mago michiwo pile ka pile kaachiel gi chiwo mar cham kod misango miolo piny mana kaka owinjore. Gin chiwo miwangʼo pep ne Jehova Nyasaye, madungʼ tik mangʼwe ngʼar mamoro Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘E odiechiengʼ mar apar mar dwe mar abiriyo beduru gi chokruok mowal. Nyaka utwe chiemo kulamo kendo kik uti tich moro amora. ");
INSERT INTO luo_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Kelneuru Jehova Nyasaye chiwo madungʼ tik mangʼwe ngʼar mar misango miwangʼo pep mar nyarwath, im achiel kod nyiimbe abiriyo ma jo-higa achiel, mago maonge songa. ");
INSERT INTO luo_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Rwath ka rwath nyaka chiw gi chiwo mar cham maromo kilo apar mar mogo mayom moruw gi mo; im to uchiw gi kilo abiriyo; ");
INSERT INTO luo_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","to nyiimbe abiriyo-ka, to uchiw gi kilo adek. ");
INSERT INTO luo_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Ewi mago meduru nywok achiel kaka chiwo mar pwodhruok e richo, kumedo gi chiwo mar pwodhruok e richo kod misango miwangʼo pep mapile pile mikelo gi chiwo mar cham, kod misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘E odiechiengʼ mar apar gabich e dwe mar abiriyo, losuru chokruok mowal kendo kik uti tijeu mapile. Losneuru Jehova Nyasaye sawo kuom ndalo abiriyo. ");
INSERT INTO luo_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Kelnauru Jehova Nyasaye chiwo madungʼ tik mangʼwe ngʼar mar misango miwangʼo pep mar rwedhi apar gadek, imbe ariyo kod nyiimbe apar gangʼwen mahikgi achiel, maonge songa. ");
INSERT INTO luo_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Kuom rwedhi apar gadekgo kelnauru chiwo mar cham maromo kilo apar mar mogo mayom moru gi mo; kuom imbe ariyogo, chiwuru kilo abiriyo ne moro ka moro; ");
INSERT INTO luo_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","to kuom nyiimbe apar gangʼwen-ka, to uchiw kilo adek. ");
INSERT INTO luo_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Ewi mago meduru nywok achiel kaka misango mar pwodhruok e richo, kumedo ewi misango miwangʼo pep mapile kod chiwo mar cham gi misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘E odiechiengʼ mar ariyo chiwuru nyirwedhi apar gariyo, imbe ariyo kod nyiimbe apar gangʼwen mahikgi achiel, ma duto onge songa. ");
INSERT INTO luo_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Chiwo mag cham kod misango miolo piny nyaka keti kaka chik dwaro maromre gi rwedhigo, imbego kod nyiimbego. ");
INSERT INTO luo_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Ewi mago meduru nywok achiel kaka chiwo mar pwodhruok e richo, kumedo ewi misango miwangʼo pep mapile kod chiwo mar cham, kaachiel gi misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘E odiechiengʼ mar adek chiwuru rwedhi apar gachiel, imbe ariyo kod nyiimbe apar gangʼwen ma jo-higa achiel, ma duto onge songa. ");
INSERT INTO luo_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Chiwo mag cham kod misango miolo piny nyaka keti kaka chik dwaro maromre gi rwedhigo, imbego kod nyiimbego. ");
INSERT INTO luo_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Ewi mago meduru nywok achiel kaka chiwo mar pwodhruok e richo, kumedo ewi misango miwangʼo pep mapile kaachiel gi misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘E odiechiengʼ mar angʼwen chiwuru rwedhi apar, imbe ariyo kod nyiimbe apar gangʼwen ma jo-higa achiel, ma duto onge songa. ");
INSERT INTO luo_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Chiwo mag cham kod misango miolo piny nyaka keti kaka chik dwaro maromre gi rwedhigo, imbego kod nyiimbego. ");
INSERT INTO luo_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Ewi mago meduru nywok achiel kaka chiwo mar pwodhruok e richo, kumedo ewi misango miwangʼo pep mapile kaachiel gi chiwo mar cham kaachiel gi misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘E odiechiengʼ mar abich chiwuru rwedhi ochiko, imbe ariyo kod nyiimbe apar gangʼwen ma jo-higa achiel, ma duto onge songa. ");
INSERT INTO luo_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Chiwo mag cham kod misango miolo piny nyaka keti kaka chik dwaro maromre gi rwedhigo, imbego kod nyiimbego. ");
INSERT INTO luo_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Ewi mago meduru nywok achiel kaka chiwo mar pwodhruok e richo, kumedo ewi misango miwangʼo pep mapile kaachiel gi chiwo mar cham kaachiel gi misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘E odiechiengʼ mar auchiel chiwuru rwedhi aboro, imbe ariyo kod nyiimbe apar gangʼwen ma jo-higa achiel, ma duto onge songa. ");
INSERT INTO luo_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Chiwo mag cham kod misango miolo piny nyaka keti kaka chik dwaro maromre gi rwedhigo, imbego kod nyiimbego. ");
INSERT INTO luo_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Ewi mago meduru nywok achiel kaka chiwo mar pwodhruok e richo, kumedo ewi misango miwangʼo pep mapile kaachiel gi chiwo mar cham kaachiel gi misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘E odiechiengʼ mar abiriyo chiw rwedhi abiriyo, imbe ariyo kod nyiimbe apar gangʼwen ma jo-higa achiel, ma duto onge songa. ");
INSERT INTO luo_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Chiwo mag cham kod misango miolo piny nyaka keti kaka chik dwaro maromre gi rwedhigo, imbego kod nyiimbego. ");
INSERT INTO luo_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Ewi mago meduru nywok achiel kaka chiwo mar pwodhruok e richo, kumedo ewi misango miwangʼo pep mapile kaachiel gi chiwo mar cham kaachiel gi misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘E odiechiengʼ mar aboro chok oganda kanyakla kendo kik uti tije mapile. ");
INSERT INTO luo_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Kelneuru Jehova Nyasaye chiwo madungʼ tik mangʼwe ngʼar mar misango miwangʼo pep mar rwath achiel, im achiel kod nyiimbe abiriyo ma jo-higa achiel, ma duto onge songa. ");
INSERT INTO luo_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Chiwo mag cham kod misango miolo piny nyaka keti kaka chik dwaro maromre gi rwadhno, imno kod nyiimbego. ");
INSERT INTO luo_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Ewi mago meduru nywok achiel kaka chiwo mar pwodhruok e richo, kumedo ewi misango miwangʼo pep mapile mar cham kaachiel gi misango miolo piny. ");
INSERT INTO luo_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Kuom chiwo mar kwongʼruok kod chiwo mar hera, losneuru Jehova Nyasaye sewni moyier kaka: misango miwangʼo pep, chiwo mag cham, misango miolo piny kod chiwo mag lalruok.’ ” ");
INSERT INTO luo_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Musa nonyiso jo-Israel gigo duto mane Jehova Nyasaye ochike. ");
INSERT INTO luo_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musa nowacho ne jotend dhout Israel niya, “Jehova Nyasaye ochiko kama: ");
INSERT INTO luo_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Ka ngʼato osingore ne Jehova Nyasaye kata kokwongʼore mar timo gimoro to kik olokre, to nyaka one ni ochopo singruokneno. ");
INSERT INTO luo_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Ka nyako ma rawera ma pod odak e od wuon mare osingore ne Jehova Nyasaye kata okwongʼore mar timo gimoro ");
INSERT INTO luo_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","mi wuon mare owinjo singruokneno to ok owacho gimoro, to kwongʼruokneno nyaka siki. ");
INSERT INTO luo_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","To ka wuon mare okwero e kinde mosingoreno, to onge kwongʼruok kata singruok mare ma osingorego manitimre; Jehova Nyasaye noweye thuolo nikech wuon mare osedagi. ");
INSERT INTO luo_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Ka onywome bangʼ ka osekwongʼore kata orikni ochiwo singruok motweye ");
INSERT INTO luo_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","mi chwore owinje to olingʼ alingʼa, to kwongʼruokneno nobed kamano. ");
INSERT INTO luo_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","To ka chwore owinjo wachni mokwere, to oketho kwongʼruok motweye kata singruok mane orikni chiwo, kendo Jehova Nyasaye kete thuolo. ");
INSERT INTO luo_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Kwongʼruok kata singruok moro amora ma dhako ma chwore otho kata dhako ma mowere gi chwore otimo nosiki. ");
INSERT INTO luo_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Ka dhako modak gi chwore okwongʼore kata otwere gi kwongʼruok ");
INSERT INTO luo_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","mi chwore owinjo wachni to ok owachone gimoro kendo ok okwere, to kwongʼruokno nyaka siki. ");
INSERT INTO luo_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","To ka chwore odagi kwongʼruokneno, to onge gimoro amora mane chiege owacho manyalo make. Chwore osekethogi, kendo Jehova Nyasaye nokete thuolo. ");
INSERT INTO luo_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Chwor dhako nyalo guro kata ketho singruok kata kwongʼruok ma chiege dwaro sandorego. ");
INSERT INTO luo_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","To ka chwore ok owacho gimoro kuom wachno odiechiengʼ ka odiechiengʼ, to nochop kwongʼruok mage kod singruok mage duto motwerego. Kwongʼruokgo nosiki nikech kane owinjogi to nolingʼ. ");
INSERT INTO luo_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","To ka dipo ni olokore bangʼe modagi kosewinjogi, to ketho mar chiege nobed e wiye owuon.” ");
INSERT INTO luo_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Magi e chike mane Jehova Nyasaye omiyo Musa kaluwore gidak manie kind dichwo gi dhako, kendo e kind wuoro gi nyare ma pod tin modak e odgi. ");
INSERT INTO luo_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“In kaachiel gi jo-Israel dhi uked gi jo-Midian, eka bangʼe ibiro tho miluw bangʼ kwereni.” ");
INSERT INTO luo_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Omiyo Musa nowacho ne jo-Israel niya, “Yieruru jou moko mondo odhi oked gi jo-Midian kendo gitiek mirimb Jehova Nyasaye kuomgi. ");
INSERT INTO luo_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Goluru ji alufu achiel achiel (1,000) moa e dhoot ka dhoot mar Israel.” ");
INSERT INTO luo_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Omiyo ji alufu apar gariyo (12,000) noikore ne lweny, kowuok e dhout Israel duto ka gigolo ji alufu achiel achiel (1,000). ");
INSERT INTO luo_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa noorogi e lweny ji alufu achiel (1,000) e dhoot ka dhoot, ka gin gi Finehas wuod Eliazar, ma jadolo, mane otingʼo gik moa ei kama ler mar lemo kod turumbete michiwogo ranyisi. ");
INSERT INTO luo_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Negikedo gi Midian, mana kaka Jehova Nyasaye nochiko Musa, kendo neginego chwo duto. ");
INSERT INTO luo_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Moko kuom joma nonegi ne gin Evi, Rekem, Zur, Hur kod Reba mane gin ruodhi abich mag Midian. Bende neginego Balaam wuod Beor gi ligangla. ");
INSERT INTO luo_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Jo-Israel nomako mond jo-Midian kod nyithindo kendo ne giyako kweth mag jamni, dhok, kod gik moko duto mag jo-Midian. ");
INSERT INTO luo_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Ne giwangʼo miech jo-Midian mane gidakie, kaachiel gi kuondegi mag bworo. ");
INSERT INTO luo_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Negikawo gik moko duto ma oyaki kod mane ope, kaachiel gi ji kod jamni, ");
INSERT INTO luo_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","kendo negikelo joma ne omaki, gik mane ope kod mane oyaki ne Musa gi Eliazar ma jadolo kod oganda jo-Israel e kargi mar bworo mantiere e pewe Moab, man but Jordan loka mar Jeriko. ");
INSERT INTO luo_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa gi Eliazar jadolo kod jotend oganda duto nodhi mondo orom kodgi e oko mar kambi. ");
INSERT INTO luo_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musa nokecho gi jotend lweny duto; mago mane otelo ne migawo mar lweny mar alufe alufe kod mag miche miche mane odwogo koa e lweny. ");
INSERT INTO luo_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Nopenjogi niya, “Angʼo momiyo useyiene mon mondo obed mangima?” ");
INSERT INTO luo_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Gin e joma noluwo puonj Balaam kendo gin ema negimiyo oganda mar jo-Israel oweyo Jehova Nyasaye kuom gima notimore Peor, mane omiyo masira onego jo-Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Omiyo neguru yawuowi duto. Kendo uneg dhako moro amora moseriwore gi dichwo, ");
INSERT INTO luo_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","to uwe nyiri duto mapok ongʼeyo chwo. ");
INSERT INTO luo_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Un duto ma usenego ngʼato angʼata kata mulo ngʼato angʼata motho nyaka ubed oko mar kambi kuom ndalo abiriyo. To e odiechiengʼ mar adek kod mar abiriyo nyaka upwodhru uwegi kendo upwodh jogo mumako. ");
INSERT INTO luo_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Pwodhuru lewni duto kaachiel gi gimoro amora molos gi pien, molos gi yie diel kata mago molos gi bao.” ");
INSERT INTO luo_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eka Eliazar jadolo nowacho ne jolweny mane odhi e lweny niya, “Chik mane Jehova Nyasaye omiyo Musa ema: ");
INSERT INTO luo_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Gik machalo gi dhahabu, fedha, mula, nyinyo, chuma ");
INSERT INTO luo_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","kod gimoro amora ma mach ok nyal wangʼo noleny e mach, eka enopwodhgi mi gibed maler. To bende nyaka luokgi gi pi mondo gibed maler. Omiyo gimoro amora ma mach ok nyal lenyo nyaka luok gi pigno. ");
INSERT INTO luo_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Kochopo odiechiengʼ mar abiriyo to ulwok lepu kendo ubiro bedo maler. Bangʼe unyalo biro e kambi.” ");
INSERT INTO luo_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“In gi Eliazar jadolo kod jotend anywola mag oganda nyaka kwan ji duto kod jamni mane ope. ");
INSERT INTO luo_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Nyaka upogi gik mane ope maromre ne joma nodhi e lweny kod joma nodongʼ. ");
INSERT INTO luo_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Kuom mago mopogne jolweny mano kedo, goluru ni Jehova Nyasaye achiel kuom mia abich bed ni gin ji, dhok, punde, rombe kata diek. ");
INSERT INTO luo_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Kawuru nus mar pokni kendo umi Eliazar jadolo kaka chiwo ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Kuom nus mar pok jo-Israel kawuru achiel kuom piero abich, bed ni gin ji, dhok, punde, rombe, diek kata jamni mamoko. Chiwgi ne jo-Lawi ma tijgi en rito hekalu mar Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Omiyo Musa kod Eliazar jadolo notimo kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Kuom gik mane ope, jolweny nokawo rombe alufu mia auchiel gi piero abiriyo gabich (675,000), ");
INSERT INTO luo_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","dhok alufu piero abiriyo gariyo (72,000), ");
INSERT INTO luo_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","punde alufu piero auchiel gachiel (61,000), ");
INSERT INTO luo_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","kod nyiri alufu piero adek gariyo (32,000) mane pok ongʼeyo chwo. ");
INSERT INTO luo_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Nus mar gik mane ope mane omi joma ne odhi kedo e lweny ne gin: rombe alufu mia adek gi piero adek gabiriyo gi mia abich (337,500), ");
INSERT INTO luo_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","pok mar Jehova Nyasaye ne gin rombe mia auchiel gi piero abiriyo gabich (675); ");
INSERT INTO luo_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","kuom dhok alufu piero adek gauchiel (36,000), pok mar Jehova Nyasaye ne gin dhok piero abiriyo gariyo (72); ");
INSERT INTO luo_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","kuom punde alufu piero adek gi mia abich (30,500), pok mar Jehova Nyasaye ne gin punde piero auchiel gachiel (61); ");
INSERT INTO luo_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","kuom ji alufu apar gauchiel (16,000), pok mar Jehova Nyasaye ne gin ji piero adek gariyo (32). ");
INSERT INTO luo_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Musa nomiyo Eliazar jadolo ma kor Jehova Nyasaye, kaka Jehova Nyasaye nochiko Musa. ");
INSERT INTO luo_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Nus mar pok mar jo-Israel mane Musa ogolo kuom joma nodhi e lweny ne chalo kama: ");
INSERT INTO luo_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","nus mar pok mar oganda ne gin rombe alufu mia adek gi piero adek gabiriyo gi mia abich (337,500), ");
INSERT INTO luo_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","dhok alufu piero adek gauchiel (36,000), ");
INSERT INTO luo_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","punde alufu piero adek gi mia abich (30,500), ");
INSERT INTO luo_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","kod ji alufu apar gauchiel (16,000). ");
INSERT INTO luo_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Kuom nus pok mar jo-Israel, Musa noyiero achiel kuom piero abich mar ji kod jamni, mana kaka Jehova Nyasaye nochike, mi nomiyogi jo-Lawi, ma tijgi ne en rito hekalu mar Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Eka jotelo mane orito migepe mag jolweny, jotelo mag alufe alufe kod jotelo mag miche miche, nodhi ir Musa ");
INSERT INTO luo_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","mi owachone niya, “Jotichni osekwano kar romb jolweny man e lwetwa, kendo onge kata achiel kuomgi molal. ");
INSERT INTO luo_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Omiyo wasekelo mich ne Jehova Nyasaye kuom gik molos gi dhahabu mane wayako kaka; thiwni, manyonge, tere, stadi kod tigo mondo omi wapwodhrego e richo e nyim Jehova Nyasaye.” ");
INSERT INTO luo_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa kod Eliazar jadolo noyie okawo dhahabugo irgi, ma gin gik mothedhi maber. ");
INSERT INTO luo_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Dhahabu duto mane oa ir jotend lweny mag alufe alufe kod mago mag miche miche mane Musa kod Eliazar jadolo ochiwo kaka mich ne Jehova Nyasaye pekgi ne romo kilo mia ariyo. ");
INSERT INTO luo_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Jalweny ka jalweny noyako mana gima orome. ");
INSERT INTO luo_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Musa kod Eliazar jadolo nokawo dhahabu koa kuom jotend jolweny mag alufe alufe kod mago mag miche miche mi negiterogi e Hemb Romo kaka rapar mar jo-Israel e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Jo-Reuben gi jo-Gad, mane nigi kweth mag rombe kod dhok, noneno ni piny Jazer kod piny Gilead ne nigi lek maber mar pidho jamni. ");
INSERT INTO luo_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Omiyo negibiro ir Musa gi Eliazar jadolo kod jotend oganda mar jo-Israel, mi giwachonegi niya, ");
INSERT INTO luo_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Piny motingʼo Ataroth, Dibon, Jazer, Nimra, Heshbon, Eleale, Sebam, Nebo kod Beon ");
INSERT INTO luo_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ma Jehova Nyasaye osekawo ka oganda mar jo-Israel neno en piny man-gi lek maber mar pidho jamni kendo ungʼeyo ni wan jotichu wan jopidh jamni. ");
INSERT INTO luo_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Negiwachonegi niya, “Ka uyie kodwa, to miwauru pinyni wasumbiniu obed marwa mondo kik wakadh wadhi loka Jordan.” ");
INSERT INTO luo_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa nowacho ne jo-Gad kod jo-Reuben niya, “Bende jou nyalo dhi e lweny ka un to udongʼ ka? ");
INSERT INTO luo_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Angʼo momiyo unego chuny jo-Israel mondo kik dhi e piny ma Jehova Nyasaye osemiyogi? ");
INSERT INTO luo_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Ma e gima kwereu notimo kane aorogi kane wan Kadesh Barnea mondo gidhi ginon pinyno. ");
INSERT INTO luo_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Kane gisechopo e Holo mar Eshkol mi giringo pinyno, negimiyo chuny jo-Israel onyosore mar dhi e piny mane Jehova Nyasaye osemiyogi. ");
INSERT INTO luo_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Negitugo mirimb Jehova Nyasaye chiengʼno mi nokwongʼore kama: ");
INSERT INTO luo_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Nikech ok giseluwa gi chunygi duto, onge kata ngʼato achiel ma ja-higa piero ariyo kadhi nyime mane oa Misri mabiro neno piny mane asingora ka akwongʼora ne Ibrahim, Isaka kod Jakobo; ");
INSERT INTO luo_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","onge ngʼato angʼata kuomgi manone pinyno makmana Kaleb wuod Jefune ma ja-Kenizi kod Joshua wuod Nun, nimar negiluwo bangʼ Jehova Nyasaye gi chunygi duto.’ ");
INSERT INTO luo_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Jehova Nyasaye nokecho gi jo-Israel kendo nomiyo giwuotho alanda e thim kuom higni piero angʼwen, nyaka ogandani duto mane otimo marach e nyim Jehova Nyasaye notho. ");
INSERT INTO luo_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Un koth jorichogi, koro ubiro ira, kuchungʼ kar kwereu kendo umiyo mirimb Jehova Nyasaye medore kuom Israel. ");
INSERT INTO luo_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ka uweyo luwo Jehova Nyasaye, to obiro jwangʼo ogandani duto e thim kendo un ema ubiro miyo jogi rum.” ");
INSERT INTO luo_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Bangʼ kinde matin negidwogo ir Musa mi giwachone niya, “Dwaher gero dipo ne jambwa kod mier madongo mondo mondwa kod nyithindwa odagie. ");
INSERT INTO luo_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","To kata kamano waikore mar manore gi gige lweny kendo dhi gi jo-Israel wetewa e piny mane osingnegi. To mokwongo nyaka wager ne mondwa gi nyithindwa mier madongo mochiel motegno mondo ogengʼ-gi kuom wasigu. ");
INSERT INTO luo_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Ok wanaduogi e miechwa nyaka wane ni jo-Israel duto oseyudo pinyno kaka pok margi. ");
INSERT INTO luo_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Wan ok wanadwar mondo opognwa piny kodgi loka machielo mar aora Jordan nimar osepognwa lopwa yo wuok chiengʼ mar Jordan lokani.” ");
INSERT INTO luo_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Eka Musa nowachonegi niya, “Ka utimo kamano ma umanoru gi gige lweny e nyim Jehova Nyasaye, ");
INSERT INTO luo_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","kendo ka un duto unudhi ka utingʼo gige lweny loka Jordan e nyim Jehova Nyasaye mi ubed kuno nyaka chop Jehova Nyasaye riemb wasike duto e nyime, ");
INSERT INTO luo_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ka uloyo pinyno e nyim Jehova Nyasaye, eka unuduogi kendo unubedi maonge ketho e nyim Jehova Nyasaye gi Israel. Kendo pinyni biro bedo pok maru e nyim Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“To ka ok utimo kamano, to ubiro timo richo e nyim Jehova Nyasaye; kendo bed ka ungʼeyo ni richou nofwenyre e lela. ");
INSERT INTO luo_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Geruru mier madongo ne mondu gi nyithindu, kod dipo ne jambu, kendo nyaka utim kaka usesingoru.” ");
INSERT INTO luo_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Jo-Gad kod jo-Reuben nowacho ne Musa niya, “Wan jotichni, wabiro timo gima ruodhwa osechikowa. ");
INSERT INTO luo_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nyithindwa kod mondewa, rombwa kod dhowa biro dongʼ e miech Gilead ka. ");
INSERT INTO luo_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","To wan jotichni, ngʼato ka ngʼata ma jalweny biro ngʼado loka Jordan mondo oked e nyim Jehova Nyasaye mana kaka ruodhwa osechiko.” ");
INSERT INTO luo_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Omiyo Musa nomiyogi chik ka oorogi ir Eliazar jadolo, kod Joshua wuod Nun kaachiel gi jotend dhout Israel. ");
INSERT INTO luo_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Nowachonegi niya, “Ka jo-Gad kod jo-Reuben noidh kaachiel kodu Jordan e nyim Jehova Nyasaye, ka ngʼato ka ngʼato omanore mar kedo, to bangʼ ka useloyo piny, to unumigi piny Gilead kaka pok margi. ");
INSERT INTO luo_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","To ka ok giidho kaachiel kodu ka gimanore gi gige lweny, to nyaka gikaw pok mag-gi kaachiel kodu Kanaan.” ");
INSERT INTO luo_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Jo-Gad kod jo-Reuben nodwoko niya, “Jotichni biro timo kaka Jehova Nyasaye osewacho. ");
INSERT INTO luo_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Wabiro ngʼado ka wadhi loka Kanaan e nyim Jehova Nyasaye ka wamanore gi gige lweny, to pok ma wabiro yudo biro bedo loka koni mar Jordan.” ");
INSERT INTO luo_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Eka Musa nomiyo jo-Gad, jo-Reuben kod nus mar dhood Manase wuod Josef pinyruodh Sihon ma ruodh jo-Amor kod pinyruodh Og ma ruodh Bashan; pinyno duto kaachiel gi miechgi kod gwenge molworogi. ");
INSERT INTO luo_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Jo-Gad nogero mier madongo motegno kaka Dibon, Ataroth, Aroer, ");
INSERT INTO luo_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth Shofan, Jazer, Jogbeha, ");
INSERT INTO luo_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth Nimra kod Beth Haran, kendo negigero dipo ne jambgi. ");
INSERT INTO luo_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Joka Reuben nogero Heshbon, Eleale kod Kiriathaim, ");
INSERT INTO luo_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","kaachiel gi Nebo kod Baal Meon (nyingegi noduog oloki achien) kod Sibma. Mier madongo mane gigero negimiyo nying mamoko. ");
INSERT INTO luo_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Nyikwa Makir wuod Manase nodhi Gilead, moloyo dalano mi giriembo jo-Amor mane oyudo odak kanyo. ");
INSERT INTO luo_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Omiyo Musa nochiwo Gilead e lwet jo-Makir, ma nyikwa Manase, kendo negidak kanyo. ");
INSERT INTO luo_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair ma nyakwar Manase nodhi mokawo mier madongo mane ni kanyo, kendo nochako kanyo ni Havoth Jair. ");
INSERT INTO luo_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba nomonjo Kenath kod mier molwore kendo nochake nyinge owuon miluongo ni Noba. ");
INSERT INTO luo_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ma e chenro mar wuodh jo-Israel e kinde mane gia Misri kopog-gi e migepe mopogore opogore kendo kotelnegi gi Musa kod Harun. ");
INSERT INTO luo_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Kaluwore gi chik mar Jehova Nyasaye, Musa nondiko nonro maber mar migepe mag wuodhgi. Ma e kaka ne giwuotho e migawo ka migawo: ");
INSERT INTO luo_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Jo-Israel nochako wuoth koa Rameses e odiechiengʼ mar apar gabich mar dwe mokwongo, ma en odiechiengʼ mokwongo bangʼ Pasaka. Negiwuok ayanga ka jo-Misri nenogi to ne ok gidewo, ");
INSERT INTO luo_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","nikech jo-Misri noyudo yiko nyithindgi makayo mane Jehova Nyasaye onego ka ngʼadogo bura ne nyisechegi. ");
INSERT INTO luo_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Jo-Israel nowuok Rameses kendo negibuoro Sukoth. ");
INSERT INTO luo_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Negiwuok Sukoth mi gibworo Etham, mantiere e bath thim. ");
INSERT INTO luo_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Negiwuok Etham, mi gidok chien Pi Hahiroth, man yo wuok chiengʼ mar Baal Zefon, mi gibworo but Migdol. ");
INSERT INTO luo_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Negiwuok Pi Hahiroth mi gingʼado nam nyaka e thim, kendo kane gisewuotho kuom ndalo adek e Thim mar Etham, negibuoro Mara. ");
INSERT INTO luo_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Negiwuok Mara mi gidhi Elim, kuma ne nitie sokni apar gariyo kod yiend othidhe piero abiriyo, kendo negibuoro kanyo. ");
INSERT INTO luo_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Negiwuok Elim mi gibworo but Nam Makwar. ");
INSERT INTO luo_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Negiwuok Nam Makwar mi gibworo e Thim mar Sin. ");
INSERT INTO luo_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Negiwuok e Thim mar Sin mi gibworo Dofka. ");
INSERT INTO luo_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Negiwuok Dofka mi gibworo Alush. ");
INSERT INTO luo_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Negiwuok Alush mi gibworo Refidim, kama ne onge pi ma ji ne nyalo modho. ");
INSERT INTO luo_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Negiwuok Refidim mi gibworo e Thim mar Sinai. ");
INSERT INTO luo_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Negiwuok e Thim mar Sinai mi gibworo Kibroth Hatava. ");
INSERT INTO luo_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Negiwuok Kibroth Hatava mi gibworo Hazeroth. ");
INSERT INTO luo_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Negiwuok Hazeroth mi gibworo Rithma. ");
INSERT INTO luo_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Negiwuok Rithma mi gibworo Rimon Perez. ");
INSERT INTO luo_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Negiwuok Rimon Perez mi gibworo Libna. ");
INSERT INTO luo_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Negiwuok Libna mi gibworo Risa. ");
INSERT INTO luo_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Negiwuok Risa mi gibworo Kehelatha. ");
INSERT INTO luo_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Negiwuok Kehelatha mi gibworo e Got Shefa. ");
INSERT INTO luo_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Negiwuok Got Shefa mi gibworo Harada. ");
INSERT INTO luo_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Negiwuok Harada mi gibworo Makheloth. ");
INSERT INTO luo_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Negiwuok Makheloth mi gibworo Tahath. ");
INSERT INTO luo_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Negiwuok Tahath mi gibworo Tera. ");
INSERT INTO luo_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Negiwuok Tera mi gibworo Mithka. ");
INSERT INTO luo_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Negiwuok Mithka mi gibworo Hashmona. ");
INSERT INTO luo_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Negiwuok Hashmona mi gibworo Moseroth. ");
INSERT INTO luo_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Negiwuok Moseroth mi gibworo Bene Jaakan. ");
INSERT INTO luo_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Negiwuok Bene Jaakan mi gibworo Hor Hagidgad. ");
INSERT INTO luo_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Negiwuok Hor Hagidgad mi gibworo Jotbatha. ");
INSERT INTO luo_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Negiwuok Jotbatha mi gibworo Abrona. ");
INSERT INTO luo_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Negiwuok Abrona mi gibworo Ezion Geber. ");
INSERT INTO luo_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Negiwuok Ezion Geber mi gibworo Kadesh, mantiere e Thim mar Zin. ");
INSERT INTO luo_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Negiwuok Kadesh mi gibworo e Got Hor, mantiere e tongʼ mar Edom. ");
INSERT INTO luo_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Kaluwore gi chik mar Jehova Nyasaye, Harun jadolo nodhi e Got Hor, kama nothoe odiechiengʼ mokwongo mar dwe mar abich, e higa mar piero angʼwen bangʼ wuok jo-Israel e piny Misri. ");
INSERT INTO luo_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Harun ne ja-higni mia achiel gi piero ariyo gadek eka ne otho e Got Hor. ");
INSERT INTO luo_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Ruoth Arad ma ja-Kanaan, mane odak Negev mar Kanaan, nowinjo ni jo-Israel biro. ");
INSERT INTO luo_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Kane giwuok e Got Hor negibuoro Zalmona. ");
INSERT INTO luo_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Negiwuok Zalmona mi gibworo Punon. ");
INSERT INTO luo_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Negiwuok Punon mi gibworo Oboth. ");
INSERT INTO luo_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Negiwuok Oboth mi gibworo Iye Abarim, mantiere e tongʼ piny Moab. ");
INSERT INTO luo_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Negiwuok Iye Abarim mi gibworo Dibon Gad. ");
INSERT INTO luo_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Negiwuok Dibon Gad mi gibworo Almon Diblathaim. ");
INSERT INTO luo_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Negiwuok Almon Diblathaim mi gibworo e gode mag Abarim, man but Nebo. ");
INSERT INTO luo_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Bangʼ kane giwuok e gode mag Abarim negibuoro e pewe mag Moab mokiewo gi Jordan momanyore gi Jeriko. ");
INSERT INTO luo_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Negibuoro e pewe mag Moab mokiewo gi Jordan chakre Beth Jeshimoth nyaka Abel Shitim. ");
INSERT INTO luo_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Jehova Nyasaye nowuoyo gi Musa e pewe mag Moab momanyore gi Jeriko mokiewo gi Jordan kowachone niya, ");
INSERT INTO luo_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Wuo gi jo-Israel kendo iwachnegi kama: Ka ungʼado Jordan mi udonjo Kanaan, ");
INSERT INTO luo_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","to uriemb ji duto modak e pinyno. Kethuru gigegi duto mopa milamo bende uwit kido duto milamo ma giloso, kendo umuki kuondegi magiloso motingʼore gi malo mar lemo. ");
INSERT INTO luo_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Kawuru pinyno mi udagie, nimar asemiyougo mondo obed maru. ");
INSERT INTO luo_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Poguru pinyno e kugoyo ombulu e kindu, kaluwore gi dhoutu. Dhoot maduongʼ opog lowo maduongʼ, to dhoot matin opog lowo matin. Gimoro amora mopogne dhoutu gombulu nobed margi. Pog-gi kaluwore gi dhout kweregi. ");
INSERT INTO luo_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘To ka ok uriembo joma odak e pinyno, to joma uweyo modongʼ biro bedonu ka cha bondo e wangʼu kendo ka kudho machwoyo dendu koni gi koni. Ginimiu chandruok e piny ma ubiro dakieno. ");
INSERT INTO luo_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Bangʼ mano anatimnu gima ne achano mondo atimnegi.’ ” ");
INSERT INTO luo_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Chik jo-Israel kiwachonegi kama: Ka usedonjo e piny Kanaan, ma en piny manomiu kaka poku, tongʼne nochal kama: ");
INSERT INTO luo_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘Pinyu ma yo milambo nochakre e Thim Zin manie tongʼ piny Edom. Tongʼu ma yo milambo mogik yo wuok chiengʼ nochakre e giko mar Nam Chumbi ");
INSERT INTO luo_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","kongʼado yo milambo mar Akrabim, modhi nyime nyaka Zin kendo ochopo yo milambo mar Kadesh Barnea. Eka nodhi nyaka Hazar Adar mi okal nyaka Azmon, ");
INSERT INTO luo_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","kama Azmon ogomoe, moriwre gi Wadi mar Misri kendo gikone en Nam Mediterania. ");
INSERT INTO luo_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Tongʼu man yo podho chiengʼ nobed Nam Mediterania. Ma ema nobed tongʼu man yo podho chiengʼ. ");
INSERT INTO luo_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Tongʼu man yo nyandwat nochakre e dho Nam Mediterania nyaka e Got Hor ");
INSERT INTO luo_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","kendo koa e Got Hor nyaka Lebo Hamath. Eka tongʼno nodhi nyaka Zedad, ");
INSERT INTO luo_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","kodhi nyime nyaka Zifron mi ogik Hazar Enan. Ma ema nobed tongʼu man yo nyandwat. ");
INSERT INTO luo_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Tongʼu man yo wuok chiengʼ, nochakre Hazar Enan nyaka Shefam. ");
INSERT INTO luo_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Tongʼno nodhi nyime koa Shefam nyaka Ribla mantiere yo wuok chiengʼ mar Ain kendo nomed dhi nyaka kuonde moridore mantiere yo wuok chiengʼ mar Nam Kinereth. ");
INSERT INTO luo_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Eka tongʼno nodhi nyime koluwo Jordan kendo nogigi e Nam Chumbi. “ ‘Magi ema nobed tongʼ pinyu koni gi koni.’ ” ");
INSERT INTO luo_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Musa nomiyo jo-Israel chik kama: “Ma e piny ma ubiro kawo kaka poku kokalo kuom goyo ombulu. Jehova Nyasaye osechiwo chik mondo pinyno opogi ne dhoudi ochiko gi nus, ");
INSERT INTO luo_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","nimar anywola mag dhood Reuben, dhood Gad, kod nus mar dhood Manase oseyudo pok margi. ");
INSERT INTO luo_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Dhoudi ariyo gi nusgo oseyudo pokgi loka Aora Jordan man yo wuok chiengʼ mar Jeriko.” ");
INSERT INTO luo_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Jehova Nyasaye nowacho ne Musa niya, ");
INSERT INTO luo_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Magi e nyinge joma chwo monego pogu pinyni kaka pok maru: Eliazar jadolo kod Joshua wuod Nun. ");
INSERT INTO luo_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Bende nyaka ikaw jatend dhoot ka dhoot mondo okonyi e tijno. ");
INSERT INTO luo_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“Kendo magi e nying-gi: “e dhood Juda, en Kaleb wuod Jefune; ");
INSERT INTO luo_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","e dhood Simeon, en Shemuel wuod Amihud; ");
INSERT INTO luo_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","e dhood Benjamin, en Elidad wuod Kislon; ");
INSERT INTO luo_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","jatelo mowuok e dhood Dan, en Buki wuod Jogli; ");
INSERT INTO luo_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","jatelo mowuok e dhood Manase wuod Josef, en Haniel wuod Efod; ");
INSERT INTO luo_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","jatelo mowuok e dhood Efraim wuod Josef, en Kemuel wuod Shiftan; ");
INSERT INTO luo_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","jatelo mowuok e dhood Zebulun, en Elizafan wuod Parnak; ");
INSERT INTO luo_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","jatelo mowuok e dhood Isakar, en Paltiel wuod Azan; ");
INSERT INTO luo_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","jatelo mowuok e dhood Asher, en Ahihud wuod Shelomi; ");
INSERT INTO luo_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","jatelo mowuok e dhood Naftali, en Pedahel wuod Amihud.” ");
INSERT INTO luo_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Magi e joma Jehova Nyasaye nochiko mondo opog jo-Israel girkeni e piny Kanaan. ");
INSERT INTO luo_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Jehova Nyasaye nowuoyo gi Musa e pewe mag Moab momanyore gi Jeriko mokiewo gi Jordan kowacho niya, ");
INSERT INTO luo_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Chik jo-Israel mondo gimi jo-Lawi mier ma gibiro dakie kuom pok ma jo-Israel biro yudo. Kendo umigi lege mag kwath molworo miergo. ");
INSERT INTO luo_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Eka ginibed gi mier ma ginyalo dakie kod lege mag kwath ne dhog-gi, rombegi kod jambgi mamoko duto. ");
INSERT INTO luo_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Kuonde mag kwath molworo mier ma umiyo jo-Lawi nopim maromo fut alufu achiel mia angʼwen gi piero abiriyo gauchiel koa e kor ohinga. ");
INSERT INTO luo_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","To oko mar dala, pimuru fut alufu angʼwen mia abich kod piero ochiko gadek koa yo wuok chiengʼ, fut alufu angʼwen mia abich kod piero ochiko gadek koa yo milambo, fut alufu angʼwen mia abich kod piero ochiko gadek koa yo podho chiengʼ, kod fut alufu angʼwen mia abich kod piero ochiko gadek koa yo nyandwat, ka dala oger e dier lowono tir. Ginikaw kanyo kaka lek mar kwath ne joma odak e miergo. ");
INSERT INTO luo_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Mier auchiel ma umiyo jo-Lawi nobed mier mag tony, ma ngʼat moneko nyalo ringo mondo opondie. Ewi mago medgi mier piero angʼwen gariyo mamoko. ");
INSERT INTO luo_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Koriwore duto nyaka umi jo-Lawi mier piero angʼwen gaboro, kaachiel gi lege mag kwath. ");
INSERT INTO luo_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Mier ma umiyo jo-Lawi koa kuom piny ma jo-Israel okawo kaka pok margi nyaka pog matindo tindo kaka pok mar dhoot ka dhoot: Kawuru mier mangʼeny kuom dhoot man-gi mangʼeny, to kawuru manok kuom jogo man-gi manok.” ");
INSERT INTO luo_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Eka Jehova Nyasaye nowacho ne Musa kama: ");
INSERT INTO luo_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Wuo gi jo-Israel kendo iwachnegi ni: ‘Ka ungʼado Jordan mi uchopo Kanaan, ");
INSERT INTO luo_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","to yieruru mier moko mondo obed miechu mag tony, ma ngʼat monego ngʼato kobothne nyalo ringo dhiye. ");
INSERT INTO luo_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Gibiro bedo mier mag tony kua e nyim ngʼama dwaro chulo kuor, mondo omi ngʼat miparo kuome ni oneko kik negi kapok oyale e nyim oganda. ");
INSERT INTO luo_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Mier auchiel muchiwogi nobed mier mag tony. ");
INSERT INTO luo_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Chiwuru mier adek mag tony ni yo wuok chiengʼ mar Jordan to adek nobed Kanaan. ");
INSERT INTO luo_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Mier auchielgo nobed kuonde tony ne jo-Israel, jodak kod ngʼato angʼata modak kodgi, mondo omi ngʼato angʼata monego ngʼat machielo kobothne nyalo ringo dhiye. ");
INSERT INTO luo_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘Ka ngʼato ogoyo wadgi gi gima olos gi chuma, motho, to en janek; omiyo janekno nyaka negi. ");
INSERT INTO luo_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Kata ka ngʼato nigi kidi e lwete manyalo nego ngʼato, mi ogoyogo wadgi motho, to en janek; omiyo janekno nyaka negi. ");
INSERT INTO luo_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Kata ka ngʼato otingʼo gimoro molos gi yien e lwete, mi ogoyogo wadgi motho, en janek; omiyo janekno nyaka negi. ");
INSERT INTO luo_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Owad gi ngʼat monegno noneg janekno; koromo kode to nonege. ");
INSERT INTO luo_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Ka ngʼato obwono wadgi gi chunye kata odiro gimoro kuome kongʼeyo motho, ");
INSERT INTO luo_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","kata ka en gi mirima mi ogoye adhongʼ motho, to ngʼatno nonegi; nimar en janek. Owad gi ngʼat monegno noneg janekno koromo kode. ");
INSERT INTO luo_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘To kaponi odhiro wadgi ma ok gimonrego kata kochiele gi gimoro kobothne ");
INSERT INTO luo_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","kata ka olwaro kidi manyalo nege kuome motho; to ne ok en jasike kendo noonge gi paro mar hinye, ");
INSERT INTO luo_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","to oganda nokel thek e kind janekno kod owadgi ngʼat monegi kaluwore gi chik. ");
INSERT INTO luo_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Oganda nyaka res janekno kuom owad gi ngʼat monegi mi gidwoke e dala mar tony mane oringo odhiye. Enodag kanyo nyaka chop jadolo mane owir gi mo maler tho. ");
INSERT INTO luo_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘To ka ngʼat monekono owuok oko mar dala mar tony mane odhiyoe, ");
INSERT INTO luo_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","kendo owad gi ngʼat mane onegocha oyude oko mar dala mar tony, to onyalo nege ma ok obedo gi richo mar nek. ");
INSERT INTO luo_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Janek nyaka sik e dalane mar tony nyaka jadolo maduongʼ tho; to en mana bangʼ tho mar jadolo maduongʼno ema onyalo dok chamo mwandune. ");
INSERT INTO luo_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘Mago ema nobednu chike mosiko e tienge duto, kamoro amora ma unudagie. ");
INSERT INTO luo_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘Ngʼato angʼata ma onego ngʼato nyaka negi kaka janek mana ka nitie joneno manyalo wacho ni notimore kamano. To onge ngʼama inyalo negi kuom wach janeno achiel kende. ");
INSERT INTO luo_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘Kik ikaw asoya kuom ngʼatno moneko, nikech owinjore gi tho. Nyaka ngʼatno negi. ");
INSERT INTO luo_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘Kik ikaw asoya kuom ngʼato angʼata moringo odhi e dala mar tony koparo ni inyalo weye mondo odog e lope owuon kapok jadolo maduongʼ otho. ");
INSERT INTO luo_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘Kik udwany piny mudakie. Chwero remo dwanyo piny, kendo pwodhruok ok nyal tim ne piny modwany kuom chwero remo, makmana kokadho kuom remb ngʼatno mane ochwero remo. ");
INSERT INTO luo_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Kik udwany piny mudakie gi remo kod kama adakie, nimar an, Jehova Nyasaye, adak e kind jo-Israel.’ ” ");
INSERT INTO luo_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Jatend anywola mar joka Gilead wuod Makir, ma wuod Manase, mane oa e dhout nyikwa Josef, nobiro mi owuoyo e nyim Musa kod jotelo, ma gin jotend anywola mag jo-Israel. ");
INSERT INTO luo_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Negiwacho niya, “Kane Jehova Nyasaye omiyo ruodha chik mondo opog piny ne jo-Israel kigoyo ombulu, nomiyi chik mondo pok mag owadwa Zelofehad mi nyige. ");
INSERT INTO luo_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Koro parane ni onywomgi gi chwo moa e dhout jo-Israel mamoko; to pokgi nogol kuom pok mar kwerewa, mi med libamba mane onywomogi. Omiyo bath pok marwa nomawa. ");
INSERT INTO luo_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Ka Higa mar Piero Abich mar jo-Israel ochopo (tiende ni Jubli), to nokaw girkeni mag-gi kigolo kuom gikeni mar dhoodgi kimedo e dhood joma onywomogi.” ");
INSERT INTO luo_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Eka Musa nomiyo jo-Israel wach machalo kama kaluwore gi chik mane Jehova Nyasaye omiye: “Gima dhood nyikwa Josef wacho nikare. ");
INSERT INTO luo_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ma e chik ma Jehova Nyasaye chiwo kuom nyi Zelofehad: Inyalo nywomgi gi ngʼato angʼata ma gihero moa e dhoodgi. ");
INSERT INTO luo_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Onge pok mar Israel maa e dhoodni to dhi e dhoot machielo, nimar ja-Israel moro ka moro norit lowo mane oyudo koa kuom kwerene. ");
INSERT INTO luo_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Nyako moro amora ma oyudo pok mar lowo kaka girkeni e dhood Israel moro amora nyaka nyuom gi ngʼato moa e dhood wuon mare, mondo omi ja-Israel moro amora oyud pok mar wuon mare. ");
INSERT INTO luo_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Onge pok mano kadhi koa e dhoodni kadhi e dhoot machielo, nimar ja-Israel moro amora nyaka rit lop kwerene.” ");
INSERT INTO luo_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Omiyo nyi Zelofehad notimo mana kaka Jehova Nyasaye nosemiyo Musa chik. ");
INSERT INTO luo_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Nyi Zelofehad miluongo ni Mala, Tirza, Hogla, Milka kod Nowa nonywom gi ominegi ma yawuot owadgi wuon-gi. ");
INSERT INTO luo_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Nonywomgi ei anywola mar nyikwa Manase wuod Josef, kendo pok margi nosiko e anywola gi wuon-gi kendo e dhood gi wuon-gi. ");
INSERT INTO luo_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Magi e chike kod buche mane Jehova Nyasaye ochiwo kokalo kuom Musa mondo omi jo-Israel e pewe mag Moab e bath Aora Jordan kama omanyore gi Jeriko.");
INSERT INTO luo_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Magi e weche mane Musa owacho ne jo-Israel duto e piny motwo man wuok chiengʼ mar Jordan, mano man Araba mochomore gi Suf e kind Paran kod Tofel; Laban, Hazeroth kod Dizahab. ");
INSERT INTO luo_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(En wuodh ndalo apar gachiel kia Horeb nyaka Kadesh Barnea kiwuok e got maluwo yo Seir.) ");
INSERT INTO luo_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","E higa mar piero angʼwen e odiechiengʼ mokwongo mar dwe mar apar gachiel, Musa ne owacho ne jo-Israel gik moko duto mane Jehova Nyasaye ochike mondo owachnegi. ");
INSERT INTO luo_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Ma ne bangʼ kane oseloyo Sihon ruodh jo-Amor mane ruodh Heshbon kendo noloyo Og ruodh Bashan, ma bende nosebedo gi loch e piny Edrei gi Ashtaroth. ");
INSERT INTO luo_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Musa nochako puonjo weche mag chik koa yo wuok chiengʼ mar Jordan nyaka tongʼ Moab kowachona niya, ");
INSERT INTO luo_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Jehova Nyasaye ma Nyasachwa nowachonwa ka en Horeb niya, “Isedak mangʼeny ahinya e godni. ");
INSERT INTO luo_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Wuogi e kambi kendo iwuoth kichomo bungu man e gode mag jo-Amor, dhi e miech ji duto mokiewo gi Araba, jogo modak e gode, jogo modak e tie gode man yo podho chiengʼ, jogo modak Negev kod mago modak e dho nam, kaachiel gi jogo modak e piny Kanaan kod Lebanon, nyaka chop e aora maduongʼ mar Yufrate. ");
INSERT INTO luo_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ne, asemiyoi pinyni. Dhiuru kendo ukaw piny mane Jehova Nyasaye ne okwongʼore ni nomi Ibrahim, Isaka kod Jakobo kaachiel gi nyikwagi.” ");
INSERT INTO luo_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","E odiechiengno ne awachonu niya, “Un joma tekogi ohinga ma ok anyal tingʼo kenda. ");
INSERT INTO luo_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Jehova Nyasaye ma Nyasachu osemiyo kwan maru omedore ma kawuono ungʼeny mana ka sulwe manie kor polo. ");
INSERT INTO luo_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Mad Jehova Nyasaye ma Nyasach kwereu mi unyaa moromo alufu gi alufu kendo enogwedhu mana kaka nosingore. ");
INSERT INTO luo_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","To ere kaka anyalo tingʼo chandruoku, tingʼ magu mapek kod dondruokgo kenda awuon. ");
INSERT INTO luo_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Yier jomariek man-gi winjo kod joma nigi luor mowuok e dhoudi duto kendo naketgi jotendu.” ");
INSERT INTO luo_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Ne udwoka niya, “Gima iparo mar timono nikare.” ");
INSERT INTO luo_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Omiyo nakawo joma otelo ne dhoutu, ma gin joma riek momi luor kendo naketogi mondo gibed loch kuomu kaka jotend oganda. Moko kuomgi naketo jotend ji alufu alufu, to moko jotend mia mia, to moko jotend ji piero abich abich, bangʼe moko jotend ji apar apar kendo moko naketo jotelo mopogore opogore e dhoutgi duto. ");
INSERT INTO luo_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","E kindeno nachiko jongʼad bura mau niya, Winjuru weche manie kind oweteu kendo ungʼad bura kare poni nitie bura e kind jo-Israel kendgi kata e kind ja-Israel kod japiny moro. ");
INSERT INTO luo_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Kik udew wangʼ ka ungʼado bura, winj ngʼat matin kod maduongʼ mana machal. Kik uluor wangʼ ngʼato nimar bura makare en mar Nyasaye. Kelnauru bura moro amora matek ma ok unyal kendo abiro winjo. ");
INSERT INTO luo_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Kendo kanyo ema ne anyisue gik moko duto mane onego utim. ");
INSERT INTO luo_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Mana kaka Jehova Nyasaye ma Nyasachwa nochikowa, ne wachako wuoth ka wawuok Horeb kendo ne wachomo pinje mag gode mar jo-Amor, kwakalo e dier bungu malich ma useneno kendo ne wachopo Kadesh Barnea. ");
INSERT INTO luo_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Eka ne awachonu niya, “Usechopo e pinje mag gode mar jo-Amor ma Jehova Nyasaye ma Nyasachwa miyowa. ");
INSERT INTO luo_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","To ne, Jehova Nyasaye, ma Nyasachu osemiyou piny. Dhiuru mondo ukawe mana kaka Jehova Nyasaye, ma Nyasach kwereu nowacho niya. Kik ubed maluor, chunyu bende kik nyosre.” ");
INSERT INTO luo_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Eka un duto nubiro ira muwachna niya, “Waor jomoko nyimwa mondo odhi onon-nwa piny kendo odwoknwa wach e yo ma onego walu gi dala ma wabiro chopoe.” ");
INSERT INTO luo_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Parono ne aneno kaber omiyo ne ayiero ji apar gariyo kuomu ka ngʼato ka ngʼato oa e dhoodgi. ");
INSERT INTO luo_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Ne giwuok ka gidhi e pinje mag gode ma gichopo e Holo mar Eshkol mondo ginon kaka pinyno obet. ");
INSERT INTO luo_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Negikawo gik monyak e pinyno, mi gikelonwa, kagiwacho niya, “En piny maber ma Jehova Nyasaye ma Nyasachwa biro miyowa.” ");
INSERT INTO luo_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Ne ok giyie dhi e pinyno, kendo ne gingʼanyo mi gidagi winjo chike Jehova Nyasaye ma Nyasachgi. ");
INSERT INTO luo_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Ne ungʼur e hembeu ka uwacho niya, Jehova Nyasaye ok dwarwa, omiyo nogolowa e piny Misri mondo ochiw-wa e lwet jo-Amor mondo otiekwa. ");
INSERT INTO luo_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Ere kuma wanyalo dhiyoe? Owetewa osechido chunywa, ka giwachonwa niya, “Jogo tek kendo boyo moloyowa, mier madongo lach kendo nigi ohinga, bende ne waneno jo-Anak.” ");
INSERT INTO luo_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Eka ne awachonu niya, “Kik ubwogi, kik uluorgi ");
INSERT INTO luo_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Jehova Nyasaye ma Nyasachu, ma otelo e nyimu, biro kedonu mana kaka ne okedonu e piny Misri kod e thim ka uneno gi wengeu uwegi. ");
INSERT INTO luo_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Kuno bende ne uneno kaka Jehova Nyasaye ma Nyasachu okawo tingʼu mana kaka wuoro kawo tingʼ wuode, kotelonu e wuodhu duto nyaka uchopo ka.” ");
INSERT INTO luo_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Ei magi duto ne ok uketo genou kuom Jehova Nyasaye ma Nyasachu, ");
INSERT INTO luo_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","mane otelo nyimu e wuodhu, gotieno notelonu gi mach to godiechiengʼ notelonu gi rumbi mondo umany kuonde monego ubworie kendo onyisu yo monego uluw. ");
INSERT INTO luo_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Kane Jehova Nyasaye owinjo gima ne uwacho, mirima nomake mi okwongʼore niya, ");
INSERT INTO luo_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Onge ngʼama nitiere e tiengʼ mobamni manone piny maberni mane asingora ni nami kweregi, ");
INSERT INTO luo_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","makmana Kaleb wuod Jefune. En ema none pinyno kendo anamiyego kaachiel gi nyikwaye kamoro amora ma tiende nonyon nikech osebedo koluwo Jehova Nyasaye gi chunye duto.” ");
INSERT INTO luo_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Nikech un, Jehova Nyasaye ne okecho koda mi owachona niya, “Ok inidonji e pinyno.” ");
INSERT INTO luo_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","To jalupni ma en Joshua wuod Nun ema nodonji e pinyno. Omiyo jiwe nikech en ema notelne jo-Israel duto ka kawo pinyno. ");
INSERT INTO luo_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","To jomatindo mane uwacho ni biro ter e twech, ma gin nyithindo ma ok ongʼeyo pogo ber kod rach, gin ema ginidonji e pinyno. Anamigi pinyno kendo ginikawe mi gidagie. ");
INSERT INTO luo_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","To un chakuru wuoth kudok chien e thim kuchomo Nam Makwar. ");
INSERT INTO luo_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Eka ne udwoko niya, “Wasetimo richo e nyim Jehova Nyasaye. Wabiro aa malo kendo kedo mana kaka Jehova Nyasaye ma Nyasachwa ochikowa.” Omiyo ji duto norwako gige lweny ka giparo ni en gima yot monjo piny godeno. ");
INSERT INTO luo_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","To Jehova Nyasaye nowachona niya, Kwergi ni kik gidhi gikedi nimar ok anabed kodgi. Ibiro lowu gi wasiku. ");
INSERT INTO luo_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Ne awachonu kamano to ne ok unyal winjo. Ne ungʼanyo ne Jehova Nyasaye mi ok uluwo chikene, kendo gi wich teko maru ne uwuotho ka udhi e piny mar gode. ");
INSERT INTO luo_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Jo-Amor mane odak e pinje godego ne omonjou, mi gilawou ka kich ma ogodak kagi goyou chakre Seir nyaka Horma. ");
INSERT INTO luo_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Ne udwogo ma uywak e nyim Jehova Nyasaye to ne ok ochiko ite ne ywaku kendo ne ok owinjo kwayou. ");
INSERT INTO luo_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Omiyo ne udak Kadesh kuom kinde mangʼeny, adier kuom kinde mangʼeny ne udak kuno. ");
INSERT INTO luo_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Eka ne wachako wuoth kwangʼado thim kwachomo Nam Makwar mana kaka Jehova Nyasaye nochika. Kuom kinde mangʼeny ne wadigni e piny gode mag Seir. ");
INSERT INTO luo_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Eka Jehova Nyasaye ne owachona niya, ");
INSERT INTO luo_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Usedigni bangʼ kinde mangʼeny kulwororu e pinyni, omiyo wuothuru kuchomo yor nyandwat. ");
INSERT INTO luo_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Nyis ji wechegi kiwachonegi ni, ‘Uchiegni kalo e piny joweteu ma nyikwa Esau modak Seir. Gibiro bedo gi kibaji nikech un, to beduru motangʼ. ");
INSERT INTO luo_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Kik udwar kodgi lweny nimar ok anamiu pinygi kata mana kama uketo e tiendu kende. Asemiyo Esau pinje mag gode man Seir kaka girkeni mare. ");
INSERT INTO luo_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Ubiro chulogi fedha kuom chiemo ma uchamo kod pi ma umodho.’ ” ");
INSERT INTO luo_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Jehova Nyasaye ma Nyasachu osegwedho tich lwetu. Oseritou ka uwuotho e thim malichni kendo kuom higni piero angʼwen-gi duto Jehova Nyasaye ma Nyasachu osebedo kodu mi ok uchando gimoro. ");
INSERT INTO luo_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Eka ne wakalo Seir kama jowetewa ma nyikwa Esau nodakie. Bangʼe ne waa Araba kwachomo Elath kod Ezion Geber mi wawuotho kwachomo thim Moab. ");
INSERT INTO luo_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Eka Jehova Nyasaye ne owachona niya, “Kik umonj jo-Moab kata kwinyogi mondo gitug lweny kodu, nimar ok anamiu dir pinygi moro amora. Kanyo asemiyo joka Ar ma nyikwa Lut kaka girkeni margi.” ");
INSERT INTO luo_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Jo-Emi osebedo ka odak kanyo, ma gin joma rateke, mangʼeny kendo ma roboche mana ka jo-Anak. ");
INSERT INTO luo_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Jo-Emi kod jo-Anak ji ne luongogiga ni jo-Refai, to jo-Moab to ne luongogi ni jo-Emi. ");
INSERT INTO luo_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Chon jo-Hori nodak e piny Seir, to nyikwa Esau noriembogi oko. Negitieko jo-Hori mane ni kanyo mi gidak kuondegi mana kaka jo-Israel notimo e piny mane Jehova Nyasaye omiyogi kaka girkeni.) ");
INSERT INTO luo_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Kendo Jehova Nyasaye nowacho niya, “Koro chungi mondo ingʼad Holo mar Zered.” Omiyo ne wangʼado holono. ");
INSERT INTO luo_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","E kinde mane wawuok Kadesh Barnea nyaka wangʼado Holo mar Zered nokawowa higni piero adek gaboro. E kindeno tiengʼ mar jolweny duto notho e kambi, mana kaka Jehova Nyasaye ne osesingorenegi. ");
INSERT INTO luo_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Lwet Jehova Nyasaye ne mon kodgi nyaka ne otiekogi duto e kambi. ");
INSERT INTO luo_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Kane joma odongʼ ma jolweny osetho, ");
INSERT INTO luo_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Jehova Nyasaye ne owachona niya, ");
INSERT INTO luo_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Kawuononi ubiro kalo e gwenge mag Moab manie piny Ar. ");
INSERT INTO luo_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Ka ubiro ir jo-Amon, to kik uchandgi kata dwaro tugo kodgi lweny, nimar ok anamiu gimoro amora e piny jo-Amon. Asechiwe kaka girkeni ne nyikwa Lut.” ");
INSERT INTO luo_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Pinyno bende ne okwan kaka piny jo-Refai mane osebedo kodak kuno, to jo-Amon to ne luongogi ni jo-Zamzumi. ");
INSERT INTO luo_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Gin oganda marateke, mangʼeny kendo ma roboche mana ka jo-Anak. Jehova Nyasaye ne otiekogi e nyim jo-Amon, mane oriembogi mi gidak kuondegigo. ");
INSERT INTO luo_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Jehova Nyasaye ne osetimo mano ne nyikwa Esau, mane odak Seir, e kinde mane otieko jo-Hori ka gineno. Negiriembogi oko kendo gidak kanyo nyaka chil kawuono. ");
INSERT INTO luo_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","To jo-Kaftor mane oa Kaftor noriembo jo-Avi mabor nyaka e gwenge mag Gaza, mi koro gidak kanyo.) ");
INSERT INTO luo_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Koro ikreuru kendo ukadh holo mar Arnon. Neuru, asechiwo e lwetu Sihon ja-Amor ma ruodh Heshbon kod pinye. Chakuru kedo kodgi mondo ukawe. ");
INSERT INTO luo_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Kochakore odiechiengni abiro kelo luoro kod kibaji ne ogendini duto modak e piny. E kinde ma giniwinjie humbu, gibiro kirni kendo kihondko biro makogi.” ");
INSERT INTO luo_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Koa e thim mar Kedemoth, ne aoro joote ne Sihon ma ruodh Heshbon kakwaye mondo kwe obedie kawachone niya, ");
INSERT INTO luo_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Yienwauru wakal e pinyu nikech wabiro luwo yo tir kendo ok wanabar e bat korachwich kata koracham. ");
INSERT INTO luo_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Yie iusnwa chiemo mwachamo kod pi mwamodho nikech nengogi romre gi fedha, kendo iwewa aweya wakadhi kwawuotho gi tiendwa, ");
INSERT INTO luo_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","mana kaka nyikwa Esau mane odak Seir kod jo-Moab modak Ar ne jotimonwa, negiweyo wangʼado Jordan miwadonjo e piny ma Jehova Nyasaye ma Nyasachwa miyowa.” ");
INSERT INTO luo_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","To Sihon ruodh Heshbon ne otamowa kadho e pinygi nimar Jehova Nyasaye ma Nyasachwa nosemiye wich teko, kendo chunye odoko matek mondo ochiwe e lwetu mana kaka osetimo. ");
INSERT INTO luo_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Jehova Nyasaye nowachona niya, “Neuru, koro achiwo Sihon kod pinye e lwetu, koro monjeuru mondo ukaw pinyeno.” ");
INSERT INTO luo_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Kane Sihon kod jolwenje duto nobiro mondo ochak kodwa lweny e piny Jahaz, ");
INSERT INTO luo_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Jehova Nyasaye ma Nyasachwa nochiwe e lwetwa kendo ne watieke gi nyithinde kod jolwenje duto. ");
INSERT INTO luo_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","E kindeno ne wakawo mieche duto, mi wanego, chwo, mon kod nyithindo duto, kendo onge ngʼama ne waweyo kangima. ");
INSERT INTO luo_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","To jamni kod gik moyaki mane oa e miechgi mane wakawo ne wadhi godo. ");
INSERT INTO luo_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Onge dala mane nyalo sirowa e lweny chakre Aroer, e dho holo mar Arnon kod dala manie holo hie nyaka chop Gilead kendo onge kata mana dala achiel mane ok wanyal kawo. Jehova Nyasaye ma Nyasachwa nochiwogi duto e lwetwa. ");
INSERT INTO luo_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","To kaluwore gi chik Jehova Nyasaye ma Nyasachwa, ne ok ukawo piny jo-Amon moro amora kata mana piny mokiewo gi Jabok kata mago molworo dalane manie gode. ");
INSERT INTO luo_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Bangʼe negigomo ma giluwo yo madhi Bashan, kendo Og ruodh Bashan gi jolweny mage duto nowuok riat mokedo kodwa e lweny Edrei. ");
INSERT INTO luo_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Jehova Nyasaye nowachona niya, “Kik iluore nimar asechiwe e lweti, en kaachiel gi jolweny mage duto kod pinye. Timne kaka ne itimone Sihon ruodh jo-Amor, mane obedo gi loch e piny Heshbon.” ");
INSERT INTO luo_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Omiyo Jehova Nyasaye ma Nyasachwa nochiwo Og ruodh Bashan gi jolwenje duto e lwetwa, kendo ne watiekogi mi wanegogi duto maonge ngʼama nodongʼ. ");
INSERT INTO luo_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","E kindeno ne wakawo mier madongo mage duto. Onge kata mana dala maduongʼ kuom mier piero auchiel madongo mag-gi mane ok wakawo, tiende ni gwenge duto man Argob, ma en pinyruodh Og man Bashan. ");
INSERT INTO luo_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Mier madongogi duto ne ochiel gi ohinga kod rangeye mag chumbe, to bende ne nitie mier moko matindo mangʼeny mane ok ochiel. ");
INSERT INTO luo_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Dala ka dala ne wanegoe ji duto modakie, kaka chwo, mon kod nyithindo mana kaka ne watimo ne Sihon ruodh Heshbon. ");
INSERT INTO luo_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","To jamni duto kod gik moyaki moa e mier madongo mag-gi, ne watingʼo wadhigo. ");
INSERT INTO luo_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Omiyo e kindeno ne wakawo pinje mag ruodhi ariyo mag jo-Amor, mantie yo wuok chiengʼ mar Jordan, kochakore e holo mar Arnon mochopo nyaka Got Hermon. ");
INSERT INTO luo_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Hermon iluongo ni Sirion gi jo-Sidon, to jo-Amor luonge ni Senir). ");
INSERT INTO luo_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Ne wakawo dalane duto manie got mesa Gilead duto, kod Bashan duto chakre Saleka, Edrei, dalane mag pinyruodh Og man Bashan. ");
INSERT INTO luo_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Og ruodh Bashan kende e ngʼama ne odongʼ e dier jomane otony kuom jo-Refai. Otandane ne olos gi nyinyo; borne ne oyombo fut apar gadek kendo lachne fut auchiel. Otandaneno pod ni Raba piny jo-Amon nyaka chil kawuono). ");
INSERT INTO luo_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Kuom pinje moko mane wakawo e kindeno, ne amiyo joka Reuben kod joka Gad tongʼ mokiewo gi Aroer man e bath holo mar Arnon, komedi gi nus mar piny gode manie Gilead kod miechgi duto. ");
INSERT INTO luo_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Pinje Gilead modongʼ duto kod Bashan, pinyruodh Og, ne amiyo nus mar dhood jo-Manase. (E gwenge duto mag Argob man Bashan, nosebedo kiluongo ni piny jo-Refai. ");
INSERT INTO luo_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jair mawuok e dhood Manase ne okawo gwenge duto mag Argob ma ochopo nyaka e tongʼ man e kind jo-Geshur kod jo-Maakath; ne ochake nyinge owuon, manyaka kawuononi Bashan pod iluongo ni Havoth Jair.) ");
INSERT INTO luo_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Kendo ne achiwo Gilead ne Makir. ");
INSERT INTO luo_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","To ne jo-Reuben kod jo-Gad, ne amiyogi kochakore Gilead nyaka e holo mar Arnon (e dier holono tir nobedo tongʼ) kendo koa Aora Jabok ma en tongʼ mar jo-Amon. ");
INSERT INTO luo_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Bende nomi jo-Reuben kod jo-Gad piny ma yo podho chiengʼ mar Jordan man Araba nyaka Kinereth mochopo dho Nam mar Araba (ma tiende ni Nam Chumbi), man e bwo gode mag Pisga. ");
INSERT INTO luo_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","E kindeno ne amiyou chik kawacho niya, “Jehova Nyasaye ma Nyasachu osemiyou pinyni mondo ukaw, to jolwenju duto machwo motegno moikore ne lweny nyaka kadh dhi loka e nyim oweteu ma jo-Israel. ");
INSERT INTO luo_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Makmana mondeu, nyithindu kod jambu (angʼeyo ni un gi jamni mangʼeny), mondo odag e dalane ma asemiyou, ");
INSERT INTO luo_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","nyaka chop Jehova Nyasaye mi oweteu kwe, mana kaka osemiyou kendo gin bende gikaw piny ma Jehova Nyasaye ma Nyasachu miyou, loka mar Jordan. Bangʼ mano ngʼato ka ngʼato kuomu odogi kare ma asemiye kaka girkeni.” ");
INSERT INTO luo_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","E kindeno ne achiko kawachone Joshua niya, “Iseneno gi wangʼi gik ma Jehova Nyasaye ma Nyasachi osetimo ni ruodhi ariyogi. Jehova Nyasaye biro timo mana machal kamano ne pinjeruodhi duto kuma udhiyoeno. ");
INSERT INTO luo_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Kik uluorgi; nikech Jehova Nyasaye ma Nyasachu owuon nokednu.” ");
INSERT INTO luo_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","E kindeno ne akwayo Jehova Nyasaye niya, ");
INSERT INTO luo_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Yaye Jehova Nyasaye Manyalo Gik Moko Duto, isechako nyiso jatichni badi mar loch kod tekoni maduongʼ. Nimar en nyasaye mane manie piny kata e polo manyalo timo gik marateke kaka misetimo? ");
INSERT INTO luo_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","We angʼadi adhi ane piny maber loka Jordan piny gode kod Lebanon.” ");
INSERT INTO luo_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","To nikech un, Jehova Nyasaye ne okecho koda kendo ne ok onyal chiko ite ne wechena. Jehova Nyasaye nowacho niya, “Mano oromo, kik ichak iwuo koda kuom wachno. ");
INSERT INTO luo_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Dhiyo ewi got Pisga mondo ine piny koa wuok chiengʼ nyaka podho chiengʼ kendo koa nyandwat nyaka milambo. Rang piny gi wengeni owuon, nimar ok iningʼad aora Jordan. ");
INSERT INTO luo_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Ket Joshua mondo okaw kari kijiwe kendo imiye teko, nimar en ema obiro telo ne jogi koterogi loka cha mondo gikaw piny ma ibiro nenono.” ");
INSERT INTO luo_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Omiyo wan ne wadongʼ e bath holo machiegni gi Beth Peor. ");
INSERT INTO luo_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Yaye, jo-Israel, winjuru buche kod chike ma amiyou, luwgi mondo udagi kendo mondo ukaw piny ma Jehova Nyasaye, ma Nyasach kwereu miyou. ");
INSERT INTO luo_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Kik umedi kata ugol gimoro amora kuom chik ma amiyou, to rituru chike ma amiyou mag Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Ne uneno gi wengeu uwegi gima Jehova Nyasaye ne otimo Baal Peor. Jehova Nyasaye ma Nyasachu notieko koa kuomu jogo duto mane oluwo Baal mar Peor, ");
INSERT INTO luo_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","to ne un uduto mane usiko kupadoru kuom Jehova Nyasaye ma Nyasachu pod ungima nyaka chil kawuono. ");
INSERT INTO luo_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Ne, asepuonjou buche kod chike kaka ne Jehova Nyasaye ma Nyasacha nochika, mondo uluw chikenego e piny mudhidonjoe kendo kawo. ");
INSERT INTO luo_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Ritgiuru maber, nimar mano ema biro nyiso riekou gi ngʼeyou ni ogendini mamoko mabiro winjo buchegi duto wach niya, “Adier, onge oganda mariek kendo man-gi ngʼeyo koganda maduongʼni.” ");
INSERT INTO luo_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Ere oganda machielo ma ogen man kod nyasachgi machiegni e yo ma Jehova Nyasaye ma Nyasachwa chiegnigo kodwa e yo moro amora ma walame? ");
INSERT INTO luo_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Kara ere oganda machielo maduongʼ man kod buche gi chike makare machal gi chike mamiyou kawuononi? ");
INSERT INTO luo_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Beduru motangʼ kendo neuru ni wiu ok owil gi gik museneno gi wangʼu kendo kik uwegi gia e chunyu ka pod ungima. Puonjuru nyithindu kod nyikwau wechegi. ");
INSERT INTO luo_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Paruruane chiengʼ mane uchungʼ e nyim Jehova Nyasaye ma Nyasachu e Horeb, kane owachona niya, “Chok ji e nyima ka mondo giwinj wechena mondo mi gipuonjre luora ndalo duto mag ngimagi kendo bende gipuonj nyithindgi wechegi.” ");
INSERT INTO luo_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Ne ubiro machiegni ma uchungʼ e tiend got. Godno mach ne liele mochopo nyaka e polo, ka en-gi rumbi maratengʼ kod mudho mandiwa. ");
INSERT INTO luo_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Eka Jehova Nyasaye ne owuoyonu kokalo ei mach. Ne uwinjo dwol kawuok ei mach, to ne ok uneno ngʼat mane wuoyono, to makmana dwol kende ema nuwinjo. ");
INSERT INTO luo_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Ne owachonu singruokne, ma gin Chike Apar, mane ochikou mondo uluw kendo ne ondikogi e kite mopa ariyo. ");
INSERT INTO luo_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Kendo Jehova Nyasaye ne owachona e kindeno mondo apuonju buche kod chike ma onego uluw e piny ma udhiye loka Jordan mondo ukaw. ");
INSERT INTO luo_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Ne ok uneno Jehova Nyasaye gi wangʼu e kinde mane uwinjo dwonde koa e mach e got Horeb. Omiyo beduru motangʼ ahinya, ");
INSERT INTO luo_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","mondo kik ubed jo-mibadhi ka uloso nyisecheu uwegi, kata kido moro amora mochwe ka dichwo kata ka dhako, ");
INSERT INTO luo_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","kata ka chiayo moro e piny kata ka winyo mafuyo e kor polo, ");
INSERT INTO luo_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","kata ka gimoro amora mochwe mamol e lowo kata ka rech manie pi. ");
INSERT INTO luo_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ka ungʼiyo polo ma uneno chiengʼ, dwe kod sulwe karieny (ma gin gigo manyiso duongʼ mar polo), to kik gimak pachu mi ukulrunegi ka ulamo. Gin gigo ma Jehova Nyasaye ma Nyasachu osemiyo jopinje duto manie piny bwo polo. ");
INSERT INTO luo_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","To un, Jehova Nyasaye noresou mogolou e mach mager kuwuok e piny Misri mondo ubed kaka girkeni mare nyaka chiengʼ, mana kaka un sani. ");
INSERT INTO luo_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Jehova Nyasaye nokecho koda nikech un, kendo ne okwongʼoreni ok anangʼad aora Jordan mondo adonji e piny maber ma Jehova Nyasaye ma Nyasachu miyou ka girkeni. ");
INSERT INTO luo_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Abiro tho e pinyni, ok anangʼad aora Jordan, to un uchiegni ngʼado mondo udhi ukaw kereu e piny maberno. ");
INSERT INTO luo_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Beduru motangʼ mondo kik wiu wil gi singruok mane Jehova Nyasaye ma Nyasachu otimo kodu, kik ulos ne un uwegi kido moro amora milamo ma Jehova Nyasaye ma Nyasachu okwero. ");
INSERT INTO luo_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Nimar Jehova Nyasaye ma Nyasachu en mach matieko gik mowangʼo kendo en Nyasaye ma janyiego. ");
INSERT INTO luo_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Bangʼ ka usedak e pinyno kuom higni mangʼeny mi ubedo gi nyithindo kod nyikwau, bangʼe ubedo jo-mibadhi ma uloso kido mopa kendo utimo gik mamono e wangʼ Jehova Nyasaye ma Nyasachu, ka umiye mirima; ");
INSERT INTO luo_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","to aluongo polo gi piny mondo obed joneno kuomu kawuono, ni ubiro rumo mapiyo nono e piny ma ubiro kawo loka Jordan. ");
INSERT INTO luo_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Jehova Nyasaye biro keyou e dier ogendini kendo ji manok kuomu ema notony e kind pinje ma Jehova Nyasaye noterue. ");
INSERT INTO luo_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Kuno unulamie gik ma dhano oloso gi lwetgi, ma gin nyiseche molos gi bao kata gi kite mopa, gin gik ma ok nyal neno, winjo, chiemo kata winjo tik gimoro. ");
INSERT INTO luo_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","To ka udwaro Jehova Nyasaye ma Nyasachu kanyo, to unuyude ka umanye gi chunyu duto kod ngimau duto. ");
INSERT INTO luo_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Bangʼ ka gigi duto osetimorenu mi ubedo gi chuny mool, eka unuduog ir Jehova Nyasaye ma Nyasachu kendo uluore. ");
INSERT INTO luo_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Nimar Jehova Nyasaye ma Nyasachu en Nyasaye ma jangʼwono ok enojwangʼu kata tiekou kata wiye wil kod singruok mane otimo gi kwereu kokwongʼore. ");
INSERT INTO luo_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Penj ane sani gik mane timore chon, ndalo mane pok onywolu, kochakore e ndalo mane Nyasaye ochweyo dhano e piny; penj ane koa e bath polo konchiel nyaka komachielo. Bende gima duongʼ kama osetimore kata gima chal kama osewinji? ");
INSERT INTO luo_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Bende nitie oganda moro mosewinjo dwond Nyasaye kawuoyo e mach kaka usewinjoni ma obedo mangima? ");
INSERT INTO luo_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Bende nitiere nyasaye moro mosegolo oganda kuom oganda machielo moselok wasumbini? Koso bende nitiere moro mosetemo timo timbe madongogi gi ranyisi, honni gi lweny kendo gi teko maduongʼ kod bat morie kaka Jehova Nyasaye notimonu e piny Misri e wangʼu kuneno. ");
INSERT INTO luo_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Osenyisu gigi duto mondo ungʼe ni Jehova Nyasaye en Nyasaye; onge Nyasaye moro ma ok en. ");
INSERT INTO luo_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Noyie uwinjo dwonde gie polo mond opuonjugo. Bende noyienu ma uneno mach makakni e piny, kendo nuwinjo dwonde ei majno. ");
INSERT INTO luo_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Nikech ne ohero kwereu mi oyiero nyikwagi bangʼ-gi, ne ogolou Misri en owuon kod tekone maduongʼ, ");
INSERT INTO luo_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","mondo ogol oko ogendini maroteke moloyou, kokelou e pinygi mondo omiu bedo girkeni kaka en kawuononi. ");
INSERT INTO luo_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Yie kendo ikaw odiechiengni obed ei chunyi ni Jehova Nyasaye en Nyasaye e polo malo kendo e piny mwalo. Onge Nyasaye moro machielo. ");
INSERT INTO luo_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Emomiyo rituru buchene kod chikene ma amiyou kawuono, mondo gik moko odhi maber kodu gi nyithindu kendo mondo udag amingʼa e piny ma Jehova Nyasaye ma Nyasachu miyou e kinde duto e piny. ");
INSERT INTO luo_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Eka Musa noketo tenge mier adek madongo man yo wuok chiengʼ mar aora Jordan, ");
INSERT INTO luo_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ma gin kuonde ma ka ngʼato onego wadgi ka ok ochano, to onyalo ringo dhi pondo kuondego mantie e miechgi madongo mondo ores ngimane. ");
INSERT INTO luo_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Mier madongo-go gin magi: Bezer manie pinje gode motwo, mano ne jo-Reuben; Ramoth ei Gilead, obed kar jo-Gad; kendo Golan ei Bashan obed mar jo-Manase. ");
INSERT INTO luo_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Ma e chik mane Musa omiyo jo-Israel. ");
INSERT INTO luo_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Magi e weche, buche kod chike mane Musa omiyogi kane giwuok Misri, ");
INSERT INTO luo_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","kane gin e holo machiegni gi Beth Peor man yo wuok chiengʼ mar Jordan, e piny Sihon ruodh jo-Amor mane nigi loch Heshbon kendo ne oloye gi Musa kod jo-Israel kane giwuok Misri. ");
INSERT INTO luo_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Negikawo pinye gi piny Og ruodh Bashan, mane gin gi ruodhi ariyo mag jo-Amor man loka yo wuok chiengʼ mar Jordan. ");
INSERT INTO luo_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Pinyni nochakore Aroer koa e dier holo mar Arnon mochopo nyaka Got Siyon (tiende ni, Hermon), ");
INSERT INTO luo_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","kendo nokawo gwenge mag Araba man yo wuok chiengʼ mar Jordan, mochopo nyaka Nam mar Araba mantiere e tiend gode mag Pisga. ");
INSERT INTO luo_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Musa noluongo jo-Israel duto ma owachonegi kama: Yaye, jo-Israel winjuru buche kod chike ma awachonu kawuono. Puonjreuru wechego kendo une ni umakogi. ");
INSERT INTO luo_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Jehova Nyasaye ma Nyasachwa notimo kodwa singruok e got Horeb. ");
INSERT INTO luo_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Singruogni ne Jehova Nyasaye ok otimo gi wuonewa, to notime gi wan wawegi, ma kawuono nika kangima. ");
INSERT INTO luo_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Jehova Nyasaye nowuoyo kodu wangʼ gi wangʼ gi ei mach ewi godno. ");
INSERT INTO luo_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","(E kindeno ne achungʼ e kindu gi Jehova Nyasaye ka asomoneu wach Jehova Nyasaye, nikech ne uluoro mach kendo ne ok uidho got.) Eka nowacho niya, ");
INSERT INTO luo_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“An e Jehova Nyasaye ma Nyasachu, mane ogolou piny Misri, ka uwuok e piny mane unie wasumbini. ");
INSERT INTO luo_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Kik ubed gi nyiseche mamoko e nyima. ");
INSERT INTO luo_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Kik ulos nyasaye milamo maket gi kido moro amora, e polo malo kata e piny mwalo kata e bwo pi. ");
INSERT INTO luo_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Kik ukulrunegi piny; bende kik ulamgi, nimar an Jehova Nyasaye ma Nyasachu, an Nyasaye ma janyiego kendo akumo nyithindo nikech richo mar wuonegi chakre tiengʼ mar adek nyaka mar angʼwen mar jogo mamon koda, ");
INSERT INTO luo_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","to anyiso hera ni tienge gana gi gana mar jogo mohera kendo morito chikena. ");
INSERT INTO luo_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Kik uti gi nying Jehova Nyasaye ma Nyasachu e yo ma ok owinjore, nimar Jehova Nyasaye ok nongʼwon ne ngʼato angʼata matiyo gi nyinge e yo marach. ");
INSERT INTO luo_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Rituru chiengʼ Sabato kendo ukete obed maler, kaka Jehova Nyasaye ma Nyasachu osechikou. ");
INSERT INTO luo_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Tiuru kuom ndalo auchiel kendo uti tijeu duto, ");
INSERT INTO luo_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","to chiengʼ mar abiriyo en Sabato ne Jehova Nyasaye ma Nyasachu. Chiengʼno ok unutim tich moro amora, bed ni un kata yawuotu kata nyiu kata jotiju machwo kata mamon, kata rwethu, pundau kata jambu moro amora, kata jodak manie dieru mondo jotiju ma yawuowi kata ma nyiri oyudie thuolo mar yweyo kaka in. ");
INSERT INTO luo_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Paruru ni ne un wasumbini e piny Misri kendo Jehova Nyasaye ma Nyasachu nogolou kuno gi teko maduongʼ korieyo bade. Kuom mano Jehova Nyasaye ma Nyasachu osechikou mondo urit chiengʼ Sabato. ");
INSERT INTO luo_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Luor wuonu gi minu mana kaka Jehova Nyasaye ma Nyasachu osechikou, mondo udagi amingʼa kendo mondo udhi maber e piny ma Jehova Nyasaye ma Nyasachu miyou. ");
INSERT INTO luo_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Kik ineki. ");
INSERT INTO luo_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Kik iterri. ");
INSERT INTO luo_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Kik ikwal. ");
INSERT INTO luo_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Kik ihang wach ne wadu. ");
INSERT INTO luo_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Kik igomb chi wadu. Kik igomb od wadu kata lope kata jatije ma wuowi kata jatije ma nyako, kata rwadhe, kata pundane kata gire moro amora.” ");
INSERT INTO luo_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Magi e chike mane Jehova Nyasaye owachone chokruok gi dwol maduongʼ e got koa e mach, rumbi kod mudho mandiwa kendo ne ok omedo gimoro. Eka ne ondikogi e kite ariyo mopa mi omiyagi. ");
INSERT INTO luo_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Kane uwinjo dwol kawuok e mudho, to got bende wangʼ gi mach, jotend dhoutu gi jodongu nobiro ira. ");
INSERT INTO luo_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Kendo nuwachona niya, “Jehova Nyasaye ma Nyasachwa osenyisowa duongʼne kod tekone kendo wasewinjo dwonde koa e mach. Kawuononi koro wasefwenyo ni ngʼato nyalo bedo abeda mangima kata obedo ni Nyasaye owuoyo kode. ");
INSERT INTO luo_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","To koro ere gima omiyo nyaka watho? Mach malichni biro tiekowa kendo wabiro tho ma ok wawinjo dwond Jehova Nyasaye ma Nyasachwa kendo. ");
INSERT INTO luo_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Nimar ere dhano mosewinjo dwond Jehova Nyasaye mangima kawuoyo koa e mach, kaka wasewinjo to pod wantie. ");
INSERT INTO luo_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Dhi machiegni mondo iwinji gik moko duto ma Jehova Nyasaye ma Nyasachwa wacho. Eka iwachnwa gik moko duto ma Jehova Nyasaye ma Nyasachwa owachoni, wabiro winjo kendo timo.” ");
INSERT INTO luo_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Jehova Nyasaye nowinjou kane uwuoyo koda ka uwacho niya, “Asewinjo gima jogi osewachoni, gik moko duto magiwacho beyo. ");
INSERT INTO luo_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Yaye, dine ber ka chunygi osiko koluora kendo orito chikena duto mondo omi gidhi maber kaachiel gi nyithindgi nyaka chiengʼ! ");
INSERT INTO luo_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“Dhiyo mondo inyisgi gidogi e hema mag-gi. ");
INSERT INTO luo_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","To in dongʼ koda ka mondo amiyi chike gi buche duto manyaka ipuonjgi giriti e piny mamiyogi mondo gidagie.” ");
INSERT INTO luo_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Omiyo beduru motangʼ kutimo gik moko duto ma Jehova Nyasaye ma Nyasachu ochikou, ka ok udok korachwich kata koracham. ");
INSERT INTO luo_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Wuothuru e yore duto ma Jehova Nyasaye ma Nyasachu osechikou mondo ubed mangima kendo ubed gi mwandu mondo omi ngimau omedre e piny ma ubiro kawo. ");
INSERT INTO luo_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Magi e chike, buche kod weche ma Jehova Nyasaye ma Nyasachu ochika mondo apuonju kendo uritgi e piny ma ungʼado aora Jordan mondo ukaw. ");
INSERT INTO luo_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Chikegi omiu mondo un, nyithindu kod nyikwau oluor Jehova Nyasaye ma Nyasachu e ndalo duto mag ngimau kurito buchene gi chikene ma amiyou mondo omi udag amingʼa gi mor. ");
INSERT INTO luo_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Winjuru, yaye Israel, kendo beduru motangʼ kurito chikena mondo omi umedru e piny ma opongʼ gi chak kod mor kich, mana kaka Jehova Nyasaye ma Nyasach kwereu nosingorenu. ");
INSERT INTO luo_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Winjuru, yaye jo-Israel, Jehova Nyasaye ma Nyasachwa, en Jehova Nyasaye achiel. ");
INSERT INTO luo_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Her Jehova Nyasaye ma Nyasachi gi chunyi duto kendo gi ngimani duto kendo gi tekoni duto. ");
INSERT INTO luo_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Chike mamiyou kawuono onego bed e chunyu. ");
INSERT INTO luo_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Ketgi e chuny nyithindu, wuo e wechego ka un e dala, ka uwuotho e bath yo, ka unindo kata ka uchungʼ. ");
INSERT INTO luo_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Twegiuru e ngʼut lweteu kaka ranyisi kendo bawgiuru e lela wengeu. ");
INSERT INTO luo_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Ndikgiuru ewi dhoutu kendo e rangeyeu. ");
INSERT INTO luo_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Ka Jehova Nyasaye ma Nyasachu okelou e piny mane osingore ne kwereu, ma Ibrahim, Isaka kod Jakobo ni nomiu. En piny maduongʼ, man-gi mier madongo mane ok ugero, ");
INSERT INTO luo_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","udi mopongʼ kod gik moko duto mabeyo, mane ok uloso, sokni ma ne ok ukunyo kod puothe mag mzabibu gi yiend zeituni mane ok upidho. Ka usechiemo muyiengʼ ");
INSERT INTO luo_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","to beduru motangʼ mondo kik wiu wil kod Jehova Nyasaye mane ogolou Misri; e piny mane unie wasumbini. ");
INSERT INTO luo_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Luor Jehova Nyasaye ma Nyasachi, en kende ema itine ka ikwongʼori mana gi nyinge owuon. ");
INSERT INTO luo_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Kik uluw nyiseche mamoko ma gin nyiseche joma odak e dieru; ");
INSERT INTO luo_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","nimar Jehova Nyasaye ma Nyasachu modak e dieru en Nyasaye ma janyiego kendo mirimbe ochomou kendo obiro tiekou e wangʼ piny. ");
INSERT INTO luo_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Kik utem Jehova Nyasaye ma Nyasachu kaka ne uteme ka un Masa. ");
INSERT INTO luo_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Beduru gi adieri mar rito chike Jehova Nyasaye ma Nyasachu, kaka omiyou e chikene kod buchene. ");
INSERT INTO luo_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Timuru gima nikare e wangʼ Jehova Nyasaye mondo udhi maber e yoreu, mi udonji kendo kaw piny maber mane Jehova Nyasaye osingore ne kwereu kokwongʼore, ");
INSERT INTO luo_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","ni obiro riembonu wasiku duto e dieru mana kaka ne Jehova Nyasaye owacho. ");
INSERT INTO luo_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","E kinde mabiro ka wuodi openji niya, “Weche, buche kod chike mane Jehova Nyasaye ma Nyasachwa omiyi, tiendgi en angʼo?” ");
INSERT INTO luo_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","To iwachne niya, “Ne wan wasumb Farao e piny Misri, to Jehova Nyasaye ne ogolowa Misri gi teko maduongʼ. ");
INSERT INTO luo_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Ne waneno gi wengewa kaka Jehova Nyasaye notimo honni kod ranyisi madongo ne jo-Misri kod Farao gi ode duto. ");
INSERT INTO luo_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","To ne ogolowa kuno kokelowa e piny mane osingore ne kwerewa kokwongʼore ni nomiwa. ");
INSERT INTO luo_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Jehova Nyasaye ne ochikowa mondo warit buchene duto kendo waluor Jehova Nyasaye ma Nyasachwa mondo wadhi maber ndalo duto mag ngimawa, mana kaka timorenwa kawuononi. ");
INSERT INTO luo_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Kendo ka warito chikegi adimba ma Jehova Nyasaye ma Nyasachwa miyowa kaka osechikowa, mano nobednwa kaka tim makare.” ");
INSERT INTO luo_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Ka Jehova Nyasaye ma Nyasachu okelou e piny ma udhi donjoe mondo ukaw obed maru, mi oriembonu ogendini mangʼeny kaka jo-Hiti, jo-Girgash, jo-Amor, jo-Kanaan, jo-Perizi, jo-Hivi kod jo-Jebus, ma gin pinje abiriyo madongo kendo maroteke moloyou. ");
INSERT INTO luo_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Kendo ka Jehova Nyasaye ma Nyasachu osechiwo gi e lwetu mi uloyogi, to une ni utiekogi duto. Kik ulos winjruok kodgi bende kik utimnegi ngʼwono. ");
INSERT INTO luo_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Kik ukendru kodgi. Kik uchiw nyiu ni yawuotgi kata kik yawuotu okend nyigi, ");
INSERT INTO luo_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","nimar ginimi yawuotu weya mitine nyiseche mamoko kendo mano dimi mirima mak Jehova Nyasaye mitieku mapiyo nono. ");
INSERT INTO luo_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Ma e gima onego utimnegi: Mukuru kendegi mag misengini, touru kitegi mopa milamo, tongʼuru sirnigi mag Ashera kendo wangʼuru kido mag-gi milamo e mach. ");
INSERT INTO luo_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Nimar un oganda mowal ne Jehova Nyasaye ma Nyasachu. Jehova Nyasaye ma Nyasachu oseyierou kuom ogendini duto manie piny mondo ubed joge, joge owuon mogeno. ");
INSERT INTO luo_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Jehova Nyasaye ne ok oherou mi oyierou nikech ne ungʼeny moloyo ogendini mamoko, nimar un e oganda matinie moloyo, ");
INSERT INTO luo_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","to Jehova Nyasaye noyierou nikech noherou kendo orito singruok mane otimo gi kwereu kane ogolou gi tekone maduongʼ kendo warou e piny mane unie wasumbini, e lwet Farao ruodh Misri. ");
INSERT INTO luo_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Ngʼeuru ni Jehova Nyasaye ma Nyasachu en Nyasaye. En Nyasaye ma ja-adiera; marito singruokne mar hera ne tienge gana gi gana mohere kendo rito chikene. ");
INSERT INTO luo_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","To jogo mochaye obiro kumo motiekgi mana ka gineno, adier ok obi deko ma ok okumo jogo mochaye. ");
INSERT INTO luo_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Kuom mano rituru yorene, buchene kod chikene adimba ma amiyou kawuono. ");
INSERT INTO luo_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Ka uchiko itu ne chikegi kendo uritogi adimba, eka Jehova Nyasaye ma Nyasachu norit singruokne mar hera kodu kaka ne osingore ne kwereu. ");
INSERT INTO luo_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Obiro herou, gwedhou kendo miyo unyaa mangʼeny, obiro gwedho nyithindo munywolo, cham manie puotheu, decheu, divai manyien, mo, nyiroye ma dhou onywolo kod nyithi jambu e piny mane osingore ne kwereu ni nomigi. ");
INSERT INTO luo_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Ibiro gwedhou moloyo ogendini duto; onge ngʼato kuomu madichwo kata madhako ma ok nobed maonge nyathi, kata jambu manobed maonge nyithindo. ");
INSERT INTO luo_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Jehova Nyasaye notiek tuoche duto kuomu; bende ok nokelnu tuoche maricho mane uneno ka un Misri, to tuochego nomak mana wasiku mochayou. ");
INSERT INTO luo_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Nyaka utiek ji duto ma Jehova Nyasaye ma Nyasachu keto e lwetu. Kik ukechgi bende kik ulam nyisechegi, nimar mano nobednu obadho. ");
INSERT INTO luo_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Unyalo wacho kendu niya, “Ogendinigi tek moloyowa. Ere kaka wanyalo riembogi oko?” ");
INSERT INTO luo_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","To kik uluorgi; paruru malongʼo gima ne Jehova Nyasaye ma Nyasachu otimone Farao gi piny e Misri duto. ");
INSERT INTO luo_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Ne uneno kod wengeu tem malich, honni madongo tekone kod bat morie mane Jehova Nyasaye ma Nyasachu ogolougo oko. Jehova Nyasaye ma Nyasachu biro timo mano bende ne oganda makoro uluoro. ");
INSERT INTO luo_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","To bende Jehova Nyasaye ma Nyasachu biro miyo kihondko omakgi ma kata ngʼato pond e dieru manade to ok notony. ");
INSERT INTO luo_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Kik gimiu luoro nimar Jehova Nyasaye ma Nyasachu manie dieru duongʼ kendo en Nyasaye man-gi teko. ");
INSERT INTO luo_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Jehova Nyasaye ma Nyasachu biro riembo ogendinigo kuomu matin tin mana ka uneno. Ok noyienu mondo utiekgi dichiel nimar dipo ka ondiegi onywolore mangʼeny mathagu. ");
INSERT INTO luo_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","To Jehova Nyasaye ma Nyasachu nochiwgi e lwetu, kowito riekogi nyaka ginirum duto. ");
INSERT INTO luo_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Obiro chiwo ruodhi mag ogendinigo e lwetu kendo unutiek nyingegi e bwo polo. Onge ngʼama nochungʼ masiru kendo unutiekgi duto. ");
INSERT INTO luo_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Kido mag nyisechegi nyaka uwangʼ e mach. Kik ugomb fedha kod dhahabu ma gin-go, bende kik ukawgi. Ka utimo kamano, to ginibednu obadho nimar gigo gin gigo makwero ne Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Kik ukel gimoro makwero e uteu, nimar un kod gima ukelono nokethi. Kik ubed gi gik machalo kamano nimar enokethgi. ");
INSERT INTO luo_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Beduru motangʼ kurito chike duto ma amiyou kawuononi, mondo omi ubed mangima kendo unyaa mi udonji e piny ma Jehova Nyasaye nosingore ni nomi kwereu. ");
INSERT INTO luo_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Parieuru kaka Jehova Nyasaye ma Nyasachu ne otelonu ka ukalo e piny motwo kuom higni piero angʼwen-gi duto, mondo opuonju bolruok, kopimo paro ma un-godo e chunyu ka bende unyalo rito chikene. ");
INSERT INTO luo_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Nodwokou piny momiyo kech okayou, eka bangʼe nomiyou manna mondo ucham ma en chiemo mane pok uneno ma kata mana kwereu bende ne pok oneno. Notimonu kamano mondo opuonjugo ni dhano ok bed mangima nikech chiemo kende to nikech wach ka wach moa e dho Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Lepu ne ok oti kendo tiendeu ne ok opudhore kata okuot kuom higni piero angʼwen-go duto. ");
INSERT INTO luo_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Ngʼeuru e chunyu ni kaka ngʼato kumo wuode, omiyo Jehova Nyasaye ma Nyasachu bende koro kumou. ");
INSERT INTO luo_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Rituru chike duto mag Jehova Nyasaye ma Nyasachu, kuwuotho e yorene bende ka umiye luor. ");
INSERT INTO luo_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Nimar Jehova Nyasaye ma Nyasachu kelou e piny maber, piny man-gi aore kod pi maber, man-gi thidhna mamol e holo koa e gode; ");
INSERT INTO luo_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","ma en piny machiego ngano kod shairi, mzabibu kod ngʼowu, olemo mongʼinore, zeituni kod mor kich. ");
INSERT INTO luo_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Pinyno nobed gi chiemo mangʼeny, bende ok unuchand gimoro; en piny ma kite mayudore gin nyinyo kendo en piny ma mula unyalo kunyo e godene. ");
INSERT INTO luo_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Ka usechiemo ma uyiengʼ, to pakuru Jehova Nyasaye ma Nyasachu kuom piny maber ma osemiyou. ");
INSERT INTO luo_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Beduru motangʼ mondo kik wiu wil kod Jehova Nyasaye ma Nyasachu, ka uweyo luwo yorene, chikene kod buchene ma amiyou kawuononi. ");
INSERT INTO luo_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Ka ok kamano, ka usechiemo ma uyiengʼ, ka usegero ute mabeyo ma udakie ");
INSERT INTO luo_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ka dhou kod jambu omedore, fedha kod dhahabu bende omedore ma gik ma un-godo duto omedore ");
INSERT INTO luo_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","to chunyu biro donjo e sunga ma wiu nowil kod Jehova Nyasaye ma Nyasachu, mane ogolou Misri, e piny mane unie wasumbini. ");
INSERT INTO luo_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Ne otelonu kokalo piny malach mar ongoro piny motwo maonge kata pi, motingʼo thuonde kwiri kod thomoni, ne omiyou pi koa e lwanda matek. ");
INSERT INTO luo_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Ne omiyou manna ma uchamo e thim gimane kwereu ne ok ongʼeyo, mondo omi ubed ka uboloru kendo ka otemou mondo giko udhi maber. ");
INSERT INTO luo_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Unyalo wacho e chunyu niya, “Tekona kod lucha kod tich lweta ema omiyo ayudo mwandugi.” ");
INSERT INTO luo_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","To par Jehova Nyasaye ma Nyasachi, nimar en ema omiyi teko mar loso mwandu, kochopogo singruok mare mane osingore gi kwereu mana kaka en kawuononi. ");
INSERT INTO luo_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Kapo ni wiu owil gi Jehova Nyasaye ma Nyasachu ma uluwo nyiseche moko, ulamo kendo ukulorunegi, to akwongʼora kawuononi ni notieku maonge kiawa. ");
INSERT INTO luo_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Mana kaka ogendini mane Jehova Nyasaye otieko e wangʼu kuneno, omiyo un bende ibiro tieku nikech ok uluoro Jehova Nyasaye ma Nyasachu. ");
INSERT INTO luo_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Yaye Israel, winjuru, uchiegni ngʼado Jordan ka udhi riembo oganda maduongʼ kendo maroteke moloyou, man-gi mier madongo ma ohingagi chopo nyaka e kor polo. ");
INSERT INTO luo_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Jo-Anak gin joma roteke kendo roboche! Usewinjo kiwuoyo kuomgi kiwacho niya, “Ere joma dichungʼ e nyim jo-Anak?” ");
INSERT INTO luo_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","To beduru gigeno kawuono ni Jehova Nyasaye ma Nyasachu ema dhi telo nyimu mana ka mach mawengʼo. Obiro tiekogi kendo obiro nyonogi mana ka uneno, kendo unuriembgi mi girum chutho mapiyo nono mana kaka Jehova Nyasaye osechiko. ");
INSERT INTO luo_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Ka Jehova Nyasaye ma Nyasachu oseriembogi oko e wangʼu ka uneno, to kik uwach e chunyu niya, “Jehova Nyasaye osekelowa ka mondo wakaw pinyni nikech timwa makare.” Ooyo en mana nikech timbe maricho mag ogendinigo emomiyo Jehova Nyasaye dhi riembogi ka uneno. ");
INSERT INTO luo_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Ok nikech timu mabeyo kata lony maru emomiyo udhi kawo pinyno mondo obed maru; to mana nikech timbe maricho mag ogandagi ema miyo Jehova Nyasaye ma Nyasachu biro riembogi oko e wangʼu mondo ochop gima nowachone kwereu ma Ibrahim, Isaka kod Jakobo. ");
INSERT INTO luo_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Ngʼeuru ni ok en nikech timu makare emomiyo Jehova Nyasaye ma Nyasachu miyou piny maberni mondo ukaw, nimar kadier to un joma tokgi tek. ");
INSERT INTO luo_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Paruru wachni kendo kik wiu wil kaka ne ujimbo mirimb Jehova Nyasaye e thim. Kochakore chiengʼ mane uwuok Misri ma uchopo ka, usebedo mana ka ungʼanyo ne Jehova Nyasaye. ");
INSERT INTO luo_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Kane un Horeb ne ujimbo mirimb Jehova Nyasaye mane iye owangʼ modwaro tiekou. ");
INSERT INTO luo_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Kane adhi e got mondo akaw chike mane ondiki e kite mopa, chike mag singruok mane Jehova Nyasaye otimo kodu, ne abet e got odiechienge piero angʼwen kod otieno piero angʼwen; kendo ne ok achiemo kata modho pi. ");
INSERT INTO luo_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Jehova Nyasaye ne omiya kite ariyo ma ondiki gi lwet Nyasaye. Kuomgi ne ondiki e chike duto mane Jehova Nyasaye owachonu koa e mach mawuok e got, e odiechieng chokruok. ");
INSERT INTO luo_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Kane odichienge piero angʼwen kod otieno piero angʼwen oserumo, Jehova Nyasaye nomiya kite mopa ariyo, ma gin kite mag singruok. ");
INSERT INTO luo_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Eka Jehova Nyasaye nowachona niya, “Lor piny piyo piyo ia e got, nikech jogi mane igolo oa e piny Misri oselokore jo-mibadhi. Giseweyo mapiyo gik mane achikogi, kendo giseloso nyiseche mag kido.” ");
INSERT INTO luo_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Kendo Jehova Nyasaye ne owachona niya, “Aseneno jogi, kendo gin joma tokgi tek adier! ");
INSERT INTO luo_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","We mondo atiekgi duto mondo agol nying-gi oko e wangʼ piny kae. Abiro miyo idok oganda maratego kendo mangʼeny moloyogi.” ");
INSERT INTO luo_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Omiyo nalokora kendo alor kaa e got mane oyudo wangʼ. Kite mopa ariyo motingʼo winjruok ne nitie e lweta. ");
INSERT INTO luo_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Kane angʼiyo ne aneno ni usetimo ketho e nyim Jehova Nyasaye ma Nyasachu; kendo useloso nyasaye mar kido ma olos ka nyaroya. Uselokoru piyo ma uweyo yo ma Jehova Nyasaye ne ochikou. ");
INSERT INTO luo_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Omiyo ne akawo kite mopa mane ni e lweta mi adiro piny ma gitore matindo tindo e nyimu. ");
INSERT INTO luo_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Eka ne achako ariera piny e nyim Jehova Nyasaye kuom ndalo piero angʼwen odiechiengʼ gotieno; ne ok achiemo kata modho pi, nikech richo duto mane utimo, ka utimo gik mamono e nyim Jehova Nyasaye, kendo ka ujimbo mirimbe. ");
INSERT INTO luo_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Ne aluoro mirima kod kum mager mar Jehova Nyasaye, nimar mirima nomake ahinya mar tiekou. To kata kamano nowinjo ywakna kendo. ");
INSERT INTO luo_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Jehova Nyasaye ne iye owangʼ gi Harun mi odwaro tieke, to e kindeno ne alemone Harun bende. ");
INSERT INTO luo_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Bende ne akawo giru mar kethono, ma en kido mar nyaroya mane uloso, mine awangʼe e mach. Bangʼe ne atoye matindo tindo narege mayom kaka mogo, eka ne akire e aora mamol koa e got. ");
INSERT INTO luo_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Bende ne umiyo Jehova Nyasaye mirima ka un Tabera, Masa, kod Kibroth Hatava. ");
INSERT INTO luo_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Kendo kane Jehova Nyasaye ogolou Kadesh Barnea nowacho niya, “Dhiuru mondo ukaw piny ma asemiyou.” To ne ungʼanyo ne chike mag Jehova Nyasaye ma Nyasachu, ne ok ugeno kuome kata miye luor. ");
INSERT INTO luo_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Usebedo ka ungʼanyo ne Jehova Nyasaye ndalo duto ma asengʼeyoue. ");
INSERT INTO luo_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Ne ariera piny ndalo piero angʼwen odiechiengʼ gotieno nikech Jehova Nyasaye nowacho ni obiro tiekou. ");
INSERT INTO luo_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Ne alamo Jehova Nyasaye kawacho niya, “Yaye Nyasaye Manyalo Gik Moko Duto, kik itiek jogigi, ma gin girkeni mari iwuon mane ireso gi badi maratego e piny Misri. ");
INSERT INTO luo_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Par jotichni ma gin Ibrahim, Isaka kod Jakobo kendo kik ine wich teko margi, timbegi maricho kod richo mag-gi ");
INSERT INTO luo_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Ka ok kamano to piny mane igolowa biro wacho ni, ‘Nikech Jehova Nyasaye ne ok nyal kawogi matergi e piny mane osesingonegi kendo nikech ne ok oherogi, to Jehova Nyasaye osetero joge e thim mondo otho kuno nikech osin kodgi.’ ");
INSERT INTO luo_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","To ngʼe ni gin jogi owuon kendo ma girkeni mari mane igolo gi tekoni maduongʼ kod bat morie.” ");
INSERT INTO luo_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","E kindeno Jehova Nyasaye nowachona niya, “Paa kite ariyo machal gi mane okwongo ka, mondo ibi ira e got kendo ilos Sanduk bao. ");
INSERT INTO luo_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Abiro ndiko e kitego weche mane ni e kite mopa mokwongo mane itoyo, eka iketgi e sandugno.” ");
INSERT INTO luo_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Omiyo ne aloso Sandug Muma gi yiend siala, mine apayo kite ariyo machal gi mane okwongo ka, eka ne adhi e got gi kite ariyogo katingʼo e lweta. ");
INSERT INTO luo_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Jehova Nyasaye ne ondiko e kite mopagi weche mane ondikoe mokwongo, mane gin Chike Apar, mane owuoyogo kodu e got gi ei mach, e chiengʼ chokruok maler. Bangʼe Jehova Nyasaye nomiyagi. ");
INSERT INTO luo_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Eka ne alor kaa e got mi aketo kite mopa mag chikego e sanduku mane aseloso mana kaka Jehova Nyasaye ne osechiko kendo gin kanyo nyaka chil kawuono. ");
INSERT INTO luo_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(Jo-Israel nowuotho koa e sokni mag Jaakan nyaka Mosera; kanyo ema ne Harun othoe mi oike kendo Eliazar wuode nokawo tichne kaka jadolo. ");
INSERT INTO luo_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Koa kanyo ne giwuotho ka gidhi Gudgoda ma gichopo nyaka Jotbatha, piny aore. ");
INSERT INTO luo_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","E kindeno Jehova Nyasaye ne oketo tenge oganda joka Lawi mondo otingʼ Sandug Muma mar singruok mar Jehova Nyasaye, mondo omi gichungʼ e nyim Jehova Nyasaye ka gitiyo tijene kendo ka gigwedho e nying Jehova Nyasaye nyaka chil kawuono. ");
INSERT INTO luo_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Mano ema omiyo joka Lawi ok yud pokgi e kind jowetegi; nimar Jehova Nyasaye e pokgi mana kaka Jehova Nyasaye ma Nyasachu nowachonegi.) ");
INSERT INTO luo_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Koro ne asebet e got kuom ndalo piero angʼwen odiechiengʼ gotieno mana kaka ne atimo mokwongo mi Jehova Nyasaye ne ochako owinja kendo ok ne en dwarone mondo otieku. ");
INSERT INTO luo_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Jehova Nyasaye ne owachona niya, “Dhiyo mondo itelne ji e yo mondo ukaw piny mane asesingora ni kweregi ni anamigi.” ");
INSERT INTO luo_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","To koro sani, yaye Israel, en angʼo ma Jehova Nyasaye ma Nyasachu dwaro makmana miye luor kendo wuotho e yorene kendo hero tiyone gi chunyu duto kod ngimau duto. ");
INSERT INTO luo_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","Bende Jehova Nyasaye dwaro ni mondo urit buchene gi chikene ma amiyou kawuononi mondo okonyu. ");
INSERT INTO luo_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Jehova Nyasaye ma Nyasachu e wuon polo kata polo man malo manade kaachiel gi piny kod gik moko duto manie iye. ");
INSERT INTO luo_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Kata kamano Jehova Nyasaye norito kwereu nimar noherogi mi bangʼe noyiero mana un, nyikwagi e dier ogendini mamoko duto mondo ubed joge mana kaka pod un nyaka chil kawuono. ");
INSERT INTO luo_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Chunyu mondo oter nyangu, kendo weuru wich teko. ");
INSERT INTO luo_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Nimar Jehova Nyasaye ma Nyasachu en Nyasach nyiseche kendo Ruoth mar ruodhi; Nyasaye maduongʼ malich kendo ratego, ma ok dew wangʼ ngʼato kata kawo asoya. ");
INSERT INTO luo_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Orito nyithind kiye kod mon ma chwogi otho kendo ohero jodak komiyogi chiemo kod lewni. ");
INSERT INTO luo_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Nyaka uher jodak manie dieru nimar un bende ne un jodak e piny Misri. ");
INSERT INTO luo_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Luoruru Jehova Nyasaye ma Nyasachu kendo utine. Rituru adiera mare ka ukwongʼoru e nyinge. ");
INSERT INTO luo_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","En ema nyaka umiye pak, nimar en Nyasachu ma osetimo timbe madongo kendo malich ma useneno gi wengeu. ");
INSERT INTO luo_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Kwereu duto mane odhi e piny Misri noromo ji piero abiriyo, to koro Jehova Nyasaye ma Nyasachu osemiyo unyaa mangʼeny mana ka sulwe manie kor polo. ");
INSERT INTO luo_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Heruru Jehova Nyasaye ma Nyasachu kendo urit dwarone, buchene, kod chikene ndalo duto. ");
INSERT INTO luo_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Paruru kawuononi puonj mane uyudo kuom Jehova Nyasaye ma Nyasachu nimar kata obedo ni nyithindu pok ongʼeyo kata neno puonjno, to un to ungʼeye. Bende paruru duongʼ mar Jehova Nyasaye gi tekone kod bat morie; ");
INSERT INTO luo_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","kaachiel gi ranyisi mane otimo kod honni mane onyiso e dier jo-Misri, ne Farao ruodh Misri kod pinye duto. ");
INSERT INTO luo_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","Bende nuneno gima notimone jolwenj Misri, faresegi kod gechegi kane gilawou mi Nam Makwar oimogi kendo mi Jehova Nyasaye otiekogi pep. ");
INSERT INTO luo_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Nyithindu ne ok oneno gima Jehova Nyasaye notimonu e thim nyaka ne uchopo kama untiereni. ");
INSERT INTO luo_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","Kendo gima ne otimone Dathan kod Abiram yawuot Eliab mawuok e dhood Reuben kane piny oyawo dhoge e dieru tir e kind jo-Israel duto ma omwonyogi duto kod joutgi, hembegi kod gik moko duto ma mekgi. ");
INSERT INTO luo_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","To un ema ne uneno giwengeu gik madongo duto mane Jehova Nyasaye otimo. ");
INSERT INTO luo_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Rituru chike duto ma amiyou kawuononi mondo ubed gi teko kendo ukaw piny man loka mar Jordan mudhi kawono; ");
INSERT INTO luo_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","kendo mondo udagi amingʼa e piny mane Jehova Nyasaye osingo ne kwereu ni nomigi kod nyikwagi ma en piny maber mopongʼ gi chak kod mor kich. ");
INSERT INTO luo_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Piny ma udonjoe mondo ukaw ok chal gi piny Misri muwuokie, ma en kama nuchwoyoe kothe ka uolonegi pi mana kaka iolone puoth alot. ");
INSERT INTO luo_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","To piny ma ungʼado Jordan mondo udhi ukaw en piny gode kod holo ma mwonyo pi moa e polo. ");
INSERT INTO luo_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","En piny ma Jehova Nyasaye ma Nyasachu biro ritoue; kendo orange pile ka pile higa ngima. ");
INSERT INTO luo_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Koro ka urito chike mamiyou adimba kawuono, ka uhero Jehova Nyasaye ma Nyasachu kendo tiyone gi chunyu duto kod ngimau duto, ");
INSERT INTO luo_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","to abiro oro koth e pinyu e ndalo mowinjore e ndalo oro kod ndalo chwiri, mondo uyud cham, gi mzabibu kod mo. ");
INSERT INTO luo_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Abiro chiwo lum ne jamni mau kendo unuchiem ma uyiengʼ. ");
INSERT INTO luo_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Beduru motangʼ mondo pachu kik maki gi gik ma kamago ma ulam nyiseche mamoko ka ukulorenegi. ");
INSERT INTO luo_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Mirimb Nyasaye nyalo lwar kuomu, ma olor ranga polo, mi koth bed maonge kendo puothe ok nochieg cham, ma uduto utho e piny maber ma Jehova Nyasaye miyou. ");
INSERT INTO luo_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Kanuru wechenagi e chunyu kod pachu, twegiuru e bedeu ka ranyisi kendo e pat wengeu. ");
INSERT INTO luo_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Puonjuru nyithindu wechegi, ka uwuoyo kuomgi ka ubet e dala, ka uwuotho e yo, ka unindo kata ka uchiewo. ");
INSERT INTO luo_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Ndikgiuru ewi dhoutu kendo e rangeyeu, ");
INSERT INTO luo_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","mondo ndalo magu kod mag nyithindu omedre e piny mane Jehova Nyasaye osingore ni nomi nyithindu, mondo obed maru nyaka chiengʼ. ");
INSERT INTO luo_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Ka urito adimba chike duto ma amiyou mondo uluw mi uhero Jehova Nyasaye ma Nyasachu ka uwuotho e yorene kendo ka urito wechene, ");
INSERT INTO luo_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","to Jehova Nyasaye biro riembo ogendinigi duto e nyimu, kendo ubiro kawo pinje madongo kendo maroteke moloyou. ");
INSERT INTO luo_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Kamoro amora ma unyono, nobed maru, tongʼ maru noyarre koa e thim mar Lebanon kokalo Aora mar Yufrate nyaka nam man yo podho chiengʼ. ");
INSERT INTO luo_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Onge ngʼama nosiru. Jehova Nyasaye ma Nyasachu mana kaka osechikou, biro kelo luoro kod kibaji e piny duto kamoro amora ma udhiyoe. ");
INSERT INTO luo_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Winjuru, kawuononi aketo gweth kod kwongʼ e nyimu. ");
INSERT INTO luo_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Ka urito chike Jehova Nyasaye ma Nyasachu ma amiyou kawuononi, to unuyud gweth. ");
INSERT INTO luo_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Ka ok uluwo chike Jehova Nyasaye ma Nyasachu mi ulokoru uweyo yore ma amiyou kawuono, kendo ka uluwo nyiseche mamoko ma ok usengʼeyo, to unuyud kwongʼ. ");
INSERT INTO luo_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Ka Jehova Nyasaye ma Nyasachu osekelou e piny mudhiye mondo ukaw obed maru, to nyaka uhul weche gweth e got Gerizim, to weche mag kwongʼ to uhul e got Ebal. ");
INSERT INTO luo_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Kaka ungʼeyo, godegi ni yo podho chiengʼ mar holo mar Jordan kama jo-Kanaan odakie. Gin gode mantiere Araba but Gilgal kama yiende madongo mag More nitie. ");
INSERT INTO luo_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Uchiegni ngʼado Jordan mondo ukaw piny ma Jehova Nyasaye ma Nyasachu miyou. Ka usekawe ma udakie, ");
INSERT INTO luo_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","to neuru ni uluwo chike duto kod buche ma amiyou kawuononi. ");
INSERT INTO luo_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Magi e buche kod chike manyaka une ni uluwo e piny ma Jehova Nyasaye ma Nyasach kwereu, osemiyou mondo ukaw obed maru ka pod udak e pinyni. ");
INSERT INTO luo_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Kethuru kuonde duto manie gode, thuche kendo kuonde duto manie tipo yiende madongo mane ogendini makoro uriembo ne lamoe nyisechegi. ");
INSERT INTO luo_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Mukuru kendegi mag misango, 