﻿USE sofia;
DROP TABLE IF EXISTS sofia.lug_vpl;
CREATE TABLE lug_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lug_vpl WRITE;
INSERT INTO lug_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ku lubereberye Katonda yatonda eggulu n’ensi. ");
INSERT INTO lug_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ensi yali njereere nga yeetabuddetabudde, ekizikiza nga kibisse kungulu ku buziba, n’Omwoyo wa Katonda ng’atambulira ku mazzi. ");
INSERT INTO lug_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Awo Katonda n’agamba nti, “Wabeerewo obutangaavu,” ne waba obutangaavu. ");
INSERT INTO lug_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Katonda n’alaba obutangaavu nga bulungi; n’ayawula obutangaavu n’ekizikiza. ");
INSERT INTO lug_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Katonda obutangaavu n’abuyita emisana, n’ekizikiza n’akiyita ekiro. Ne wabaawo akawungeezi ate ne buba enkya. Olwo lwe lunaku olw’olubereberye. ");
INSERT INTO lug_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Era Katonda n’agamba nti, “Wabeewo ebbanga lyawule olufu n’amazzi.” ");
INSERT INTO lug_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Bw’atyo Katonda n’akola ebbanga okwawula wansi n’amazzi agali waggulu. Ne kiba bwe kityo. ");
INSERT INTO lug_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Katonda ebbanga n’aliyita eggulu. Ne buba akawungeezi, ate ne buba enkya, olwo lwe lunaku olwokubiri. ");
INSERT INTO lug_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Awo Katonda n’ayogera nti, “Amazzi agali wansi w’eggulu gakuŋŋaanire mu kifo kimu, wabeewo olukalu.” Ne kiba bwe kityo. ");
INSERT INTO lug_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Katonda olukalu n’aluyita ensi, amazzi agakuŋŋaanye go n’agayita ennyanja. Katonda n’alaba nga ky’akoze kirungi. ");
INSERT INTO lug_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Awo Katonda n’agamba nti, “Ensi ereete ebimera: emiti egizaala ensigo mu ngeri yaagyo, emiti egy’ebibala ebibaamu ensigo mu ngeri yaagyo, gibeere ku nsi.” Ne kiba bwe kityo. ");
INSERT INTO lug_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ensi n’ereeta ebimera: ebimera eby’ensigo ebya buli ngeri, n’emiti egy’ebibala ebya buli ngeri n’ebijja ku nsi. Katonda n’alaba nga ky’akoze kirungi. ");
INSERT INTO lug_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ne buba akawungeezi ate ne buba enkya. Olwo lwe lunaku olwokusatu. ");
INSERT INTO lug_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Awo Katonda n’agamba nti, “Wabeewo ebyaka mu bbanga ly’eggulu, okwawula emisana n’ekiro; bibeerenga obubonero okwawulanga ebiro, n’ennaku, n’emyaka. ");
INSERT INTO lug_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Bibeere ebyaka ku ggulu, bireetere ensi obutangaavu.” Ne kiba bwe kityo. ");
INSERT INTO lug_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Katonda n’akola ebyaka ebinene bibiri, ekyaka ekisinga obunene kifugenga emisana, n’ekitono kifugenga ekiro, n’akola n’emmunyeenye. ");
INSERT INTO lug_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Awo Katonda n’abiteeka mu bbanga ly’eggulu byakenga ku nsi, ");
INSERT INTO lug_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","enjuba efugenga emisana, omwezi gufugenga ekiro, era byawulenga obutangaavu n’ekizikiza. Katonda n’alaba ng’ekyo kirungi. ");
INSERT INTO lug_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ne buba akawungeezi, ate ne buba enkya. Olwo lwe lunaku olwokuna. ");
INSERT INTO lug_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Katonda n’ayogera nti, “Amazzi galeete ebibinja by’ebiramu, n’ebinyonyi bibuukenga waggulu mu bbanga.” ");
INSERT INTO lug_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Bw’atyo Katonda n’akola ebitonde eby’omu nnyanja ebinene ennyo, na buli kiramu ekya buli ngeri eky’omu nnyanja, na buli kinyonyi ekibuuka. Katonda n’alaba nga ky’akoze kirungi. ");
INSERT INTO lug_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Bw’atyo Katonda n’abiwa omukisa n’agamba nti, “Muzaale mwale, mujjuze amazzi g’ennyanja, n’ebinyonyi byale ku nsi.” ");
INSERT INTO lug_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ne buba akawungeezi, ate ne buba enkya; olwo lwe lunaku olwokutaano. ");
INSERT INTO lug_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Katonda n’ayogera nti, “Ensi ereete ebiramu ebya buli ngeri: ente, n’ebyewalula, n’ensolo ez’omu nsiko eza buli ngeri.” Bwe kityo bwe kyali. ");
INSERT INTO lug_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Katonda n’atonda ensolo ez’oku nsi eza buli ngeri, n’ente eza buli ngeri, na buli ekyewalula ku ttaka ekya buli ngeri. Katonda n’alaba nga ky’akoze kirungi. ");
INSERT INTO lug_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Awo Katonda n’agamba nti, “Tukole omuntu mu kifaananyi kyaffe mu ngeri yaffe. Bafugenga ebyennyanja eby’omu nnyanja, n’ebinyonyi eby’omu bbanga, n’ensolo zonna, n’ensi yonna, era bafugenga na buli ekyewalulira ku nsi kyonna.” ");
INSERT INTO lug_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Bw’atyo Katonda n’atonda omuntu mu kifaananyi kye, mu kifaananyi kya Katonda mwe yamutondera; n’abatonda omusajja n’omukazi. ");
INSERT INTO lug_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Katonda n’abawa omukisa, n’abagamba nti, “Mwale mujjuze ensi, mugifugenga. Mufugenga ebyennyanja ebiri mu nnyanja, n’ebinyonyi eby’omu bbanga na buli kiramu ekitambula ku nsi.” ");
INSERT INTO lug_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Awo Katonda n’agamba nti, “Laba mbawadde buli kimera eky’ensigo ekiri ku nsi na buli muti ogw’ensigo mu kibala kyagwo. Munaabiryanga. ");
INSERT INTO lug_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Mbawadde na buli nsolo ey’oku nsi, na buli kinyonyi eky’omu bbanga na buli ekyewalula, na buli ekissa omukka mbiwa buli kimera, okuba emmere yaabyo.” Bwe kityo bwe kyali. ");
INSERT INTO lug_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Awo Katonda n’alaba byonna by’akoze nga birungi nnyo. Ne buba akawungeezi, ate ne buba enkya, olwo lwe lunaku olwomukaaga. ");
INSERT INTO lug_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Bwe bityo eggulu n’ensi awamu ne byonna ebigirimu ne biggwa okukolwa. ");
INSERT INTO lug_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ku lunaku olw’omusanvu Katonda yali amaze ebyo byonna bye yali akola; n’awummulira ku lunaku olwo ng’ava ku mirimu gye gyonna gye yakola. ");
INSERT INTO lug_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Bw’atyo Katonda olunaku olw’omusanvu n’aluwa omukisa n’alutukuza; kubanga ku olwo Katonda kwe yawummulira emirimu gye yakola mu kutonda. ");
INSERT INTO lug_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ebyo bye bifa ku ggulu n’ensi nga bwe byatondebwa, Mukama Katonda we yamalira okutonda eggulu n’ensi. ");
INSERT INTO lug_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Tewaaliwo muddo gwonna ku nsi wadde ekimera kyonna, kubanga Mukama Katonda yali tannatonnyesa nkuba ku nsi era nga tewali muntu ow’okulima ettaka. ");
INSERT INTO lug_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Naye ensulo n’eva mu ttaka n’efukirira ensi yonna. ");
INSERT INTO lug_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Mukama Katonda n’akola omuntu okuva mu nfuufu ey’oku nsi n’amufuuwa mu nnyindo omukka ogw’obulamu. Omuntu n’aba omulamu. ");
INSERT INTO lug_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mukama Katonda yali asimbye ennimiro Adeni ku luuyi olw’ebuvanjuba, omuntu gwe yabumba n’amuteeka omwo. ");
INSERT INTO lug_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mukama Katonda n’ameza mu ttaka buli muti ogusanyusa amaaso era omulungi okulya. N’ateeka omuti ogw’obulamu, n’omuti ogw’okumanya ekirungi n’ekibi wakati mu nnimiro. ");
INSERT INTO lug_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Omugga ne gusibuka mu nnimiro Adeni ne gukulukuta okulufukirira, ne gwanjaalira omwo ne guvaamu emigga ena. ");
INSERT INTO lug_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Erinnya ly’ogusooka Pisoni, gwe gwo ogukulukuta okwetooloola ensi ya Kavira, awali zaabu; ");
INSERT INTO lug_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ne zaabu y’ensi eyo nnungi; mulimu bideriamu n’amayinja onuku. ");
INSERT INTO lug_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Omugga ogwokubiri ye Gikoni, gwe gukulukuta okwetooloola ensi ya Kuusi. ");
INSERT INTO lug_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","N’erinnya ly’ogwokusatu ye Tigiriisi ogukulukutira ku buvanjuba bwa Bwasuli. Ogwokuna ye Fulaati. ");
INSERT INTO lug_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Mukama Katonda n’ateeka omuntu mu nnimiro Adeni agirimenga era agikuumenga. ");
INSERT INTO lug_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mukama Katonda n’alagira omuntu nti, “Emiti gyonna egy’omu nnimiro olyangako, ");
INSERT INTO lug_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","naye omuti ogw’okumanya ekirungi n’ekibi ogwo togulyangako, kubanga lw’oligulyako tolirema kufa.” ");
INSERT INTO lug_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Mukama Katonda n’ayogera nti, “Si kirungi omuntu okuba yekka, nnaamukolera omubeezi amusaanira.” ");
INSERT INTO lug_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Naye olwo Mukama Katonda yali amaze okukola ensolo zonna ez’omu nsiko n’ebinyonyi eby’omu bbanga. N’abireeta eri omuntu abituume amannya. Buli kiramu omuntu nga bwe yakiyita, lye lyabeera erinnya lyakyo. ");
INSERT INTO lug_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Bw’atyo omuntu n’atuuma buli nsolo ey’awaka, n’ebinyonyi eby’omu bbanga n’ensolo ez’omu nsiko amannya. Adamu yali tannaba kufunirwa mubeezi. ");
INSERT INTO lug_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Mukama Katonda n’aleetera omusajja otulo tungi nnyo ne yeebaka; bwe yali nga yeebase n’amuggyamu olubirizi lumu, n’azzaawo ennyama. ");
INSERT INTO lug_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Mukama Katonda n’atonda omukazi okuva mu lubiriizi lwe yaggya mu musajja n’amumuleetera. ");
INSERT INTO lug_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Omusajja n’agamba nti, “Lino lye ggumba ery’omu magumba gange, ye nnyama ey’omu nnyama yange, anaayitibwanga mukazi; kubanga aggyibbwa mu musajja.” ");
INSERT INTO lug_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Noolwekyo omusajja ky’anaavanga aleka kitaawe ne nnyina ne yeegatta ne mukazi we, ne bafuuka omubiri gumu. ");
INSERT INTO lug_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Omusajja n’omukazi baali tebambadde, naye nga tewali akwatirwa munne nsonyi. ");
INSERT INTO lug_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kale nno omusota gwali mukalabakalaba okukira ensolo zonna ez’omu nsiko, Mukama Katonda ze yatonda. Ne gugamba omukazi nti, “Kazzi Katonda yagamba nti, ‘Temulyanga ku muti gwonna ogw’omu nnimiro!’ ” ");
INSERT INTO lug_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Omukazi n’addamu omusota nti, “Tulya ku buli muti ogw’omu nnimiro, ");
INSERT INTO lug_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","kyokka Katonda yatulagira nti, ‘Temulyanga ku kibala ky’omuti oguli wakati mu nnimiro, wadde okugukwatako, muleme okufa.’ ” ");
INSERT INTO lug_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Naye omusota ne gugamba omukazi nti, “Temugenda kufa. ");
INSERT INTO lug_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kubanga Katonda amanyi nga lwe muligulyako amaaso gammwe lwe galizibuka, era mulifaanana nga ye, okumanyanga ekirungi n’ekibi.” ");
INSERT INTO lug_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Awo omukazi bwe yalaba ng’omuti mulungi nga gusanyusa okutunulako era gwegombebwa okuleeta amagezi, n’anoga ekibala kyagwo n’alya; n’awaako ne bba naye n’alya. ");
INSERT INTO lug_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Awo amaaso gaabwe bombi ne gazibuka, ne bategeera nga baali bwereere; ne baluka amalagala g’emiti ne beekolera ebyokwambala. ");
INSERT INTO lug_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Awo ne bawulira eddoboozi lya Mukama Katonda ng’atambula mu nnimiro, mu budde obuweeweevu. Omusajja n’omukazi ne beekweka mu miti Mukama Katonda aleme okubalaba. ");
INSERT INTO lug_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Naye Mukama Katonda n’ayita omusajja nti, “Oli ludda wa?” ");
INSERT INTO lug_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","N’addamu nti, “Mpulidde eddoboozi lyo mu nnimiro, ne ntya, kubanga mbadde bwereere; ne nneekweka.” ");
INSERT INTO lug_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","N’amubuuza nti, “Ani akubuulidde nti oli bwereere? Olidde ku muti gwe nakulagira obutagulyangako?” ");
INSERT INTO lug_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Omusajja n’addamu nti, “Omukazi gwe wampa okubeeranga nange y’ampadde ekibala ne ndya.” ");
INSERT INTO lug_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mukama Katonda kwe kubuuza omukazi nti, “Kiki kino ky’okoze?” Omukazi n’addamu nti, “Omusota gwe gunsenzesenze ne ndya.” ");
INSERT INTO lug_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Mukama Katonda n’agamba omusota nti, Kubanga okoze kino okolimiddwa okukira ensolo zonna ez’awaka n’ez’omu nsiko, oneekululiranga ku lubuto lwo era onoolyanga nfuufu ennaku zonna ez’obulamu bwo. ");
INSERT INTO lug_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nteeka obulabe wakati wo n’omukazi, ne wakati w’ezzadde lyo n’ezzadde ly’omukazi; ezzadde lye linaakubetentanga omutwe, naawe onoolibojjanga ekisinziiro. ");
INSERT INTO lug_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","N’agamba omukazi nti, “Nnaayongeranga nnyo ku bulumi bwo ng’oli lubuto, onoozaaliranga mu bulumi; musajja wo anaakukoleranga bye weetaaga kyokka anaakufuganga.” ");
INSERT INTO lug_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","N’agamba Adamu nti, “Kubanga owulidde eddoboozi lya mukazi wo, n’olya ku muti gwe nakulagira obutagulyangako, “ensi ekolimiddwa ku lulwo; mu ntuuyo zo mw’onoofuniranga ekyokulya ennaku zonna ez’obulamu bwo. ");
INSERT INTO lug_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ensi eneekumerezanga amaggwa n’amatovu, onoolyanga ebibala eby’omu nnimiro. ");
INSERT INTO lug_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mu ntuuyo zo mw’onoggyanga ekyokulya, okutuusa lw’olidda mu ttaka mwe wava, kubanga oli nfuufu ne mu nfuufu mw’olidda.” ");
INSERT INTO lug_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Omusajja n’atuuma omukazi erinnya Kaawa, oyo ye nnyina w’abalamu bonna. ");
INSERT INTO lug_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mukama Katonda n’akolera Adamu ne mukazi we ebyambalo eby’amaliba n’abambaza. ");
INSERT INTO lug_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Awo Mukama Katonda n’agamba nti, “Laba omuntu afuuse ng’omu ku ffe okumanyanga ekirungi n’ekibi; kale kaakano talwa kugolola mukono gwe n’anoga ku muti ogw’obulamu n’alya, n’awangaala emirembe gyonna.” ");
INSERT INTO lug_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Bw’atyo Mukama Katonda n’agoba omuntu mu nnimiro Adeni agende alimenga ettaka mwe yaggyibwa. ");
INSERT INTO lug_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Bwe yamala okugobamu omuntu, n’ateekamu Bakerubi n’ekitala ekimyansa eky’obwogi ku buli ludda okukuuma ekkubo erigenda ku muti ogw’obulamu. ");
INSERT INTO lug_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu n’amanya Kaawa, mukazi we, n’aba olubuto n’azaala Kayini n’agamba nti, “Mukama annyambye nzadde omuntu.” ");
INSERT INTO lug_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Oluvannyuma n’azaala muganda we Aberi. Aberi n’aba mulunzi, ye Kayini n’abeera mulimi. ");
INSERT INTO lug_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Awo ennaku bwe zaayitawo Kayini n’alyoka aleeta ebibala by’ebimera ebyava mu ttaka okubiwaayo eri Mukama. ");
INSERT INTO lug_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Aberi naye n’aleeta ku baana b’endiga ze ababereberye n’amasavu gaazo. Mukama n’asiima Aberi n’ekiweebwayo kye. ");
INSERT INTO lug_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Naye teyasiima Kayini wadde ekiweebwayo kye. Awo Kayini n’asunguwala nnyo, n’endabika y’amaaso ge n’ewaanyisibwa. ");
INSERT INTO lug_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Mukama n’abuuza Kayini nti, “Osunguwalidde ki? Era n’endabika y’amaaso go lwaki ewaanyisiddwa? ");
INSERT INTO lug_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Bw’onookolanga obulungi tokkirizibwenga? Naye bw’otokole bulungi ekibi, kiri kumpi naawe, nga kikulindiridde, naye oteekwa okukiwangula.” ");
INSERT INTO lug_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kayini n’agamba Aberi muganda we nti, “Tulageko mu nnimiro.” Bwe baali nga bali mu nnimiro Kayini n’agolokokera ku muganda we Aberi, n’amutta. ");
INSERT INTO lug_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Awo Mukama n’abuuza Kayini nti, “Muganda wo Aberi ali ludda wa?” N’amuddamu nti, “Ssimanyi; nze mukuumi wa muganda wange?” ");
INSERT INTO lug_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mukama n’amugamba nti, “Okoze ki? Eddoboozi ly’omusaayi gwa muganda wo oguyiyiddwa ku ttaka linkaabirira. ");
INSERT INTO lug_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ne kaakano okolimiddwa, era ettaka lyasamye okumira omusaayi gwa muganda wo gwe wasse. ");
INSERT INTO lug_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Bw’onoolimanga ettaka teriikuwenga bibala byalyo; onoobanga momboze ku nsi.” ");
INSERT INTO lug_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayini n’agamba Mukama nti, “Ekibonerezo kyange kinzitooweredde sikisobola. ");
INSERT INTO lug_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Laba, ongobye okuva ku nsi ne mu maaso go; era nnaabanga momboze ne buli anandaba ananzita.” ");
INSERT INTO lug_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Awo Mukama n’amugamba nti, “Nedda si bwe kiri. Buli alitta Kayini ndimuwalana emirundi musanvu.” Awo Mukama n’ateeka akabonero ku Kayini, buli amulaba aleme okumutta. ");
INSERT INTO lug_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kayini n’alyoka ava mu maaso ga Mukama, n’abeera mu nsi ya Enodi ku luuyi olw’ebuvanjuba olwa Adeni. ");
INSERT INTO lug_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayini n’amanya mukazi we, n’aba olubuto n’azaala Enoka. Kayini n’azimba ekibuga n’akituuma erinnya lyerimu erya mutabani we Enoka. ");
INSERT INTO lug_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoka n’azaalirwa Iradi ne Iradi n’azaala Mekujeeri, ne Mekujeeri n’azaala Mesuseera, ne Mesuseera n’azaala Lameka. ");
INSERT INTO lug_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameka n’awasa abakazi babiri: omu yali Ada n’omulala nga ye Zira. ");
INSERT INTO lug_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada n’azaala Yabali. Ono ye yali kitaawe w’abo ababeera mu weema nga balunda. ");
INSERT INTO lug_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Muganda we Yubali, ye yazaala abo abakuba ennanga n’okufuuwa omulere. ");
INSERT INTO lug_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zira n’azaala Tubalukayini omuweesi w’eby’ekikomo n’eby’ekyuma. Ne mwannyina wa Tubalukayini nga ye Naama. ");
INSERT INTO lug_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameka n’agamba bakazi be nti, “Ada ne Zira, muwulire eddoboozi lyange; mwe bakazi ba Lameka, muwulirize kye ŋŋamba; nzise omusajja olw’okunfumita, nga muvubuka, olw’okunkuba. ");
INSERT INTO lug_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Obanga Kayini yawalanirwa emirundi musanvu, mazima Lameka wa kuwalanirwa emirundi nsanvu mu musanvu.” ");
INSERT INTO lug_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Awo Adamu n’amanya mukazi we, n’azaala omwana wabulenzi n’amutuuma Seezi, kubanga yayogera nti, “Katonda ampadde omwana omulala mu kifo kya Aberi, Kayini gwe yatta.” ");
INSERT INTO lug_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seezi n’azaala omwana owoobulenzi n’amutuuma Enosi. Mu kiseera ekyo abantu ne batandika okukoowoola erinnya lya Mukama. ");
INSERT INTO lug_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Luno lwe lulyo lwa Adamu. Katonda bwe yatonda omuntu, yamukola mu kifaananyi kya Katonda. ");
INSERT INTO lug_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Yabatonda omusajja n’omukazi, n’abawa omukisa n’abatuuma, “abantu.” ");
INSERT INTO lug_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu bwe yaweza emyaka kikumi mu asatu, n’azaala omwana owoobulenzi amufaanana, mu kifaananyi kye, n’amutuuma Seezi. ");
INSERT INTO lug_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seezi bwe yamala okuzaalibwa, Adamu n’amala emyaka lunaana, n’azaaliramu abaana aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Emyaka gyonna Adamu gye yamala gyali lwenda mu asatu, n’afa. ");
INSERT INTO lug_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seezi bwe yaweza emyaka kikumi mu etaano n’azaala Enosi. ");
INSERT INTO lug_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seezi bwe yamala okuzaala Enosi n’awangaala emyaka emirala lunaana mu musanvu n’azaaliramu abaana aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Bwe gityo emyaka gyonna egya Seezi ne giba lwenda mu kkumi n’ebiri n’alyoka afa. ");
INSERT INTO lug_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosi bwe yaweza emyaka kyenda n’azaala Kenani. ");
INSERT INTO lug_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosi bwe yamala okuzaala Kenani n’awangaala emyaka emirala lunaana mu kkumi n’etaano, omwo n’azaaliramu abaana aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Bwe gityo emyaka gyonna Enosi gye yamala ne giba lwenda mu etaano; n’alyoka afa. ");
INSERT INTO lug_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani bwe yaweza emyaka nsanvu n’azaala Makalaleri. ");
INSERT INTO lug_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenani n’awangaala emyaka emirala lunaana mu ana, n’azaaliramu abaana aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Emyaka gyonna Kenani gye yamala ne giba lwenda mu kkumi. ");
INSERT INTO lug_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Makalaleri bwe yaweza emyaka nkaaga mu etaano n’azaala Yaredi. ");
INSERT INTO lug_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Bwe yamala okuzaala Yaredi n’awangaala emyaka emirala lunaana mu asatu n’azaaliramu abaana abalala aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ennaku zonna eza Makalaleri ne ziba emyaka lunaana mu kyenda mu etaano, n’afa. ");
INSERT INTO lug_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaredi bwe yaweza emyaka kikumi mu nkaaga mu ebiri n’azaala Enoka. ");
INSERT INTO lug_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yaredi bwe yamala okuzaala Enoka n’awangaala emyaka emirala lunaana, omwo n’azaaliramu abaana abalala aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Bwe gityo emyaka gyonna Yaredi gye yamala ne giba lwenda mu nkaaga mu ebiri, n’afa. ");
INSERT INTO lug_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoka bwe yaweza emyaka nkaaga mu etaano n’azaala Mesuseera. ");
INSERT INTO lug_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enoka n’atambulira wamu ne Katonda, okumala emyaka ebikumi bisatu nga Mesuseera amaze okuzaalibwa, n’azaala abaana abalala aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Bwe gityo emyaka gyonna egya Enoka ne giba ebikumi bisatu mu nkaaga mu etaano. ");
INSERT INTO lug_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoka yatambula ne Katonda, n’ataddamu kulabika, kubanga Katonda yamutwala. ");
INSERT INTO lug_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mesuseera bwe yali nga yaakamala emyaka kikumi mu kinaana mu musanvu n’azaala Lameka. ");
INSERT INTO lug_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Bwe yamala okuzaala Lameka n’awangaala emyaka emirala lusanvu mu kinaana mu ebiri, n’azaala abaana abalala aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Bwe gityo emyaka gyonna Mesuseera gye yamala ne giba lwenda mu nkaaga mu mwenda; n’afa. ");
INSERT INTO lug_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameka bwe yali nga wa myaka kikumi mu kinaana mu ebiri n’azaala omwana owoobulenzi ");
INSERT INTO lug_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","n’amutuuma Nuuwa, ng’agamba nti, “Okuva mu ttaka Mukama lye yakolimira, ono yalituweezaweeza mu mulimu gwaffe, ne mu kutegana kw’emikono gyaffe.” ");
INSERT INTO lug_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lameka n’awangaala emyaka emirala bitaano mu kyenda mu etaano ng’amaze okuzaala Nuuwa, mu gyo n’azaaliramu abaana abalala aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Bwe gityo emyaka gyonna Lameka gye yawangaala ne giba lusanvu mu nsanvu mu musanvu. ");
INSERT INTO lug_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuuwa bwe yaweza emyaka ebikumi bitaano n’azaala Seemu, ne Kaamu ne Yafeesi. ");
INSERT INTO lug_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Abantu bwe beeyongera obungi ku nsi ne bazaalirwa abaana aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Abaana ba Katonda ne balaba ng’abawala abo balungi ne bawasa buli gwe beerondera. ");
INSERT INTO lug_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Awo Mukama n’agamba nti, “Omwoyo wange taawakanenga na muntu emirembe gyonna, kubanga muntu buntu; n’ennaku ze ziriba emyaka kikumi mu abiri.” ");
INSERT INTO lug_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mu nnaku ezo, abaana ba Katonda bwe beegatta n’abawala b’abantu abo, ne babazaalamu abaana; be Banefuli abaali abatutumufu ennyo era abalwanyi abeekitalo mu biseera ebyo era ne mu biro ebyaddirira. ");
INSERT INTO lug_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mukama n’alaba ng’ekibi ky’omuntu kiyinze nnyo ku nsi; nga buli ndowooza y’omutima gw’omuntu mbi njereere ebbanga lyonna. ");
INSERT INTO lug_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mukama n’anakuwala nnyo kubanga yatonda omuntu ku nsi, n’alumwa nnyo mu mutima gwe. ");
INSERT INTO lug_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Awo Mukama n’agamba nti, “Ndiggya ku nsi omuntu gwe natonda, ndisaanyaawo omuntu, n’ensolo n’ebinyonyi, kubanga nejjusizza olw’okubitonda.” ");
INSERT INTO lug_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kyokka ye Nuuwa n’alaba ekisa mu maaso ga Mukama. ");
INSERT INTO lug_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Bino bye bifa ku Nuuwa n’ab’omu nju ye: Nuuwa yali muntu mutuukirivu, nga taliiko kya kunenyezebwa mu bantu b’ekiseera kye, n’atambula ne Katonda. ");
INSERT INTO lug_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuuwa yalina batabani be basatu: Seemu ne Kaamu ne Yafeesi. ");
INSERT INTO lug_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ensi yali nnyonoonefu mu maaso ga Katonda era ng’ejjudde eddalu. ");
INSERT INTO lug_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Katonda n’alaba ensi, era laba, ng’eyonoonese mu kweyisa kwayo kubanga buli muntu yenna yali kyetwala nga tewakyali mutuukirivu. ");
INSERT INTO lug_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Katonda kwe kugamba Nuuwa nti, “Mmaliridde okuzikiriza buli muntu, kubanga ensi ejjudde eddalu; laba, nzija kubazikiriza mbamalewo ku nsi. ");
INSERT INTO lug_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Naye ggwe Nuuwa weekolere eryato mu muti gofeeri, okolemu ebisenge, olibikke n’envumbo munda ne kungulu. ");
INSERT INTO lug_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Bw’oti bw’oba olikola: obuwanvu bwalyo mita kikumi mu ana, n’obugazi mita amakumi abiri mu ssatu, n’obugulumivu mita kkumi na ssatu n’ekitundu. ");
INSERT INTO lug_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Bw’oliba olizimba, waggulu oteekangayo akasolya nga kabika kimu kyakubiri ekya mita. Omulyango gwalyo oguteekanga mu mbiriizi zaalyo. Okolanga eryato lya kalinassatu, ery’emyaliiro: ogwa wansi n’ogwokubiri, n’ogwokusatu. ");
INSERT INTO lug_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ndireeta amataba ku nsi, okuzikiriza buli kiramu, ekissa omukka, ekiri wansi w’eggulu; buli ekiri ku nsi kya kufa. ");
INSERT INTO lug_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Naye ndikola endagaano naawe. Oliyingira mu lyato, ggwe, ne mukazi wo, ne batabani bo, ne baka batabani bo wamu naawe. ");
INSERT INTO lug_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Oliyingira mu lyato na buli kiramu ekirina omubiri; oliyingiza bibiri bibiri ekisajja n’ekikazi bibeere biramu naawe. ");
INSERT INTO lug_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ku binyonyi ebya buli ngeri, ne ku nsolo eza buli ngeri, na buli ekyewalula ekya buli ngeri, bibiri bibiri ebya buli ngeri birijja gy’oli, bibeere biramu. ");
INSERT INTO lug_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Era twala buli ngeri ya mmere eriibwa, ogitereke; eriba mmere yo n’ebiramu byo.” ");
INSERT INTO lug_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuuwa n’akola byonna nga Katonda bwe yamulagira. ");
INSERT INTO lug_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Awo Mukama n’agamba Nuuwa nti, “Yingira mu lyato, ggwe n’abantu bo bonna, kubanga nkulabye ng’oli mutuukirivu mu mulembe guno. ");
INSERT INTO lug_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Twala ku buli nsolo ennongoofu musanvu musanvu ensajja n’enkazi, ");
INSERT INTO lug_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","era ne ku binyonyi eby’omu bbanga musanvu musanvu ekisajja n’ekikazi, okukuuma olulyo lwabyo ku nsi. ");
INSERT INTO lug_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Bwe waliyitawo ennaku musanvu nditonnyesa enkuba ku nsi emisana n’ekiro okumalira ddala ennaku amakumi ana, era ndizikiriza buli kintu ekiramu kye natonda ku nsi.” ");
INSERT INTO lug_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Bw’atyo Nuuwa n’akola buli kintu nga Mukama bwe yakimulagira. ");
INSERT INTO lug_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuuwa yali aweza emyaka lukaaga amataba bwe gajja ku nsi. ");
INSERT INTO lug_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuuwa n’ayingira mu lyato n’abaana be ne mukazi we n’abakazi b’abaana be bawone amataba. ");
INSERT INTO lug_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Era ensolo ennongoofu, n’ensolo ezitali nnongoofu n’ebibuuka mu bbanga na buli ekyewalula, ");
INSERT INTO lug_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ne biyingira bibiri bibiri ekisajja n’ekikazi eri Nuuwa mu lyato, nga Katonda bwe yamulagira. ");
INSERT INTO lug_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Awo olwatuuka oluvannyuma lw’ennaku ziri omusanvu, amataba ne gatandika ku nsi. ");
INSERT INTO lug_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Mu mwaka ogw’olukaaga ogw’obulamu bwa Nuuwa, mu mwezi ogwokubiri, ku lunaku olw’ekkumi n’omusanvu olw’omwezi, ku lunaku olwo ensulo zonna ez’omu nnyanja ennene, ne ziggulwa lumu n’ebituli byonna eby’eggulu. ");
INSERT INTO lug_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Enkuba n’etonnya ku nsi okumala ennaku amakumi ana, emisana n’ekiro. ");
INSERT INTO lug_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ku lunaku olwo lwennyini Nuuwa ne mukazi ne batabani be, Seemu, ne Kaamu ne Yafeesi, ne bakazi baabwe bonsatule, ne bayingira mu lyato. ");
INSERT INTO lug_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Buli nsolo mu ngeri yaayo na buli nte, na buli ekyewalula, era na buli kinyonyi mu ngeri yaakyo na buli nkula ya kinyonyi, nabyo ne biyingira mu lyato. ");
INSERT INTO lug_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ne biyingira mu lyato lya Nuuwa bibiri bibiri byonna ebyalimu omukka ogw’obulamu. ");
INSERT INTO lug_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Byonna ne biyingira mu lyato, ekisajja n’ekikazi; byayingira nga Katonda bwe yalagira Nuuwa, Mukama n’aggalawo eryato. ");
INSERT INTO lug_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Amataba ne gabuna ensi okumala ennaku amakumi ana. Amazzi ne geeyongeranga, n’eryato nalyo ne lyeyongeranga okutumbiira ku nsi. ");
INSERT INTO lug_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Amazzi ne gatumbiira ne geeyongera okwala ku nsi, n’eryato ne liseeyeeya kungulu ku mazzi. ");
INSERT INTO lug_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Amazzi ne gatumbiira nnyo nnyini ku nsi, n’ensozi zonna empanvu wansi w’eggulu lyonna amazzi ne gazibikka. ");
INSERT INTO lug_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Amazzi ne gatumbiira ne gabikka ensozi ne zibulira wansi mu mazzi mita nga musanvu. ");
INSERT INTO lug_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Buli kiramu ekyali ku nsi ne kifa: ebinyonyi n’ensolo ez’awaka n’ez’omu nsiko, n’ebitonde byonna ebyali ku nsi n’abantu bonna. ");
INSERT INTO lug_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Buli kintu kyonna ekyali ku lukalu ekissa omukka ne kifa. ");
INSERT INTO lug_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Buli kiramu kyonna ekyali ku nsi ne kimalibwawo: abantu, n’ensolo, na buli kitonde ekitambula ku nsi, n’ebinyonyi eby’omu bbanga ne bimalibwawo ku nsi. Nuuwa yekka n’abo be yali nabo mu lyato be baasigalawo. ");
INSERT INTO lug_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Amataba gaamala ku nsi ennaku kikumi mu ataano. ");
INSERT INTO lug_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Katonda n’ajjukira Nuuwa n’ensolo zonna ez’awaka n’ez’omu nsiko ezaali naye mu lyato, n’asindika empewo ku nsi, amazzi ne gakendeera; ");
INSERT INTO lug_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ensulo eza wansi w’ensi n’ebituli eby’eggulu ne biggalibwa, n’enkuba eva mu ggulu n’eziyizibwa, ");
INSERT INTO lug_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","n’amazzi ne geeyongera okukendeera ku nsi. Ku nkomerero y’ennaku kikumi mu ataano amazzi gaali gakalidde; ");
INSERT INTO lug_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ne mu mwezi ogw’omusanvu, ku lunaku lwagwo olw’ekkumi n’omusanvu, eryato ne litereera ku nsozi eza Alalaati. ");
INSERT INTO lug_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Bwe gatyo amazzi ne geeyongera okukalira okutuusa mu mwezi ogw’ekkumi, ku lunaku olusooka olw’omwezi ogwo entikko z’ensozi ne zirabika. ");
INSERT INTO lug_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Oluvannyuma lw’ennaku amakumi ana Nuuwa n’aggula eddirisa lye yakola ku lyato ");
INSERT INTO lug_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","n’atuma namuŋŋoona n’agenda nga bw’akomawo okutuusa amazzi lwe gaakalira. ");
INSERT INTO lug_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Oluvannyuma n’atuma ejjuba ne liva w’ali okulaba ng’amazzi gakalidde ku nsi; ");
INSERT INTO lug_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","naye ejjuba ne litalaba we lissa kigere kyalyo, ne likomawo gy’ali mu lyato, kubanga amazzi gaali gakyali ku nsi yonna. N’agolola omukono gwe n’alikwata n’aliyingiza mu lyato. ");
INSERT INTO lug_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","N’alinda ennaku endala musanvu n’atuma ate ejjuba okuva mu lyato; ");
INSERT INTO lug_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ne likomawo akawungeezi, era laba, nga lirina mu kamwa kaalyo akakoola akabisi ke liggye ku muti omuzeyituuni. Awo Nuuwa n’ategeera nti amazzi gakendedde ku nsi. ");
INSERT INTO lug_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ate n’alinda ennaku endala musanvu, n’asindika ejjuba, naye ku mulundi guno teryadda. ");
INSERT INTO lug_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ku lunaku olw’olubereberye, olw’omwezi ogw’olubereberye nga Nuuwa aweza emyaka lukaaga mu gumu, amazzi gaali gakalidde ku nsi. Awo Nuuwa n’aggyako ekibikka ku lyato n’alaba ng’ensi ekalidde. ");
INSERT INTO lug_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ku lunaku olw’amakumi abiri mu omusanvu olw’omwezi ogwokubiri ensi yali ekalidde. ");
INSERT INTO lug_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Awo Katonda n’agamba Nuuwa nti, ");
INSERT INTO lug_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Vva mu lyato, ggwe, ne mukazi wo, ne batabani bo ne bakazi baabwe. ");
INSERT INTO lug_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Fulumya buli kiramu ekiri naawe: ebinyonyi, n’ensolo, na buli kiramu ekitambula ku ttaka, biryoke bizaale byale ku nsi, byeyongerenga obungi.” ");
INSERT INTO lug_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Awo Nuuwa n’afuluma ne batabani be, ne mukazi we wamu ne bakazi ba batabani be. ");
INSERT INTO lug_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","N’ensolo n’ebitonde byonna ebitambula ku ttaka, n’ebinyonyi byonna, byonna ne biva mu lyato bibiri bibiri mu bibinja. ");
INSERT INTO lug_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Awo Nuuwa n’azimbira Mukama ekyoto, n’addira ku zimu ku nsolo ennongoofu ne ku binyonyi ebirongoofu n’awaayo ekiweebwayo ekyokebwa ku kyoto. ");
INSERT INTO lug_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mukama n’awulira akawoowo akalungi akamusanyusa, n’ayogera mu mutima gwe nti, “Sikyaddayo kukolimira nsi olw’omuntu, newaakubadde ng’endowooza y’omutima gwe mbi okuva mu buto bwe. Sikyaddayo na kuzikiriza bitonde byonna ebiramu, nga bwe nkoze. ");
INSERT INTO lug_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Ensi ng’ekyaliwo, okusiga n’amakungula, obunnyogovu n’ebbugumu, ebiseera eby’omusana n’eby’obutiti, emisana n’ekiro, tebiggwengawo.” ");
INSERT INTO lug_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Awo Katonda n’awa Nuuwa ne batabani be omukisa n’agamba nti, “Muzaale mwale mweyongerenga nnyo mujjuze ensi. ");
INSERT INTO lug_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ensolo zonna ez’omu nsiko, n’ebinyonyi eby’omu bbanga, na buli ekitambula ku nsi, buli ekiri mu nnyanja, byonna binaakutyanga, mbikuwadde mu mikono gyo. ");
INSERT INTO lug_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Buli kintu ekiramu, ekitambula onookiryanga. Nga bwe nakuwa ebimera, kaakano nkuwa buli kintu. ");
INSERT INTO lug_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Naye toolyenga nnyama ng’ekyalimu omusaayi gwayo. ");
INSERT INTO lug_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Era ndivunaana ayiwa omusaayi gwammwe ne nvunaana n’omuntu olw’omusaayi gw’ensolo ne muvunaana n’olw’omusaayi gwa muntu munne. ");
INSERT INTO lug_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Buli anaayiwanga omusaayi gw’omuntu, n’ogugwe gunaayiibwanga, kubanga mu kifaananyi kya Katonda, Katonda mwe yakolera omuntu. ");
INSERT INTO lug_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Naye ggwe onoozaalanga ne weeyongera obungi. Oneeyongeranga ku nsi.” ");
INSERT INTO lug_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Awo Katonda n’agamba Nuuwa ne batabani bwe baali ");
INSERT INTO lug_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","nti, “Laba nkola endagaano yange nammwe ne bonna abaliva mu mmwe oluvannyuma lwammwe, ");
INSERT INTO lug_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","era na buli kitonde ekiramu ekiri naawe: ebinyonyi, n’ensolo ez’awaka n’ez’omu nsiko zonna, ne byonna bye muvudde nabyo mu lyato, ne buli kitonde kyonna ku nsi. ");
INSERT INTO lug_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nkola endagaano yange eno nammwe: tewaabengawo mataba gazikiriza bulamu bwonna, tewakyaddayo kubaawo mataba gasaanyaawo nsi.” ");
INSERT INTO lug_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Katonda n’agamba nti, “Kano ke kabonero ke nteeka wakati wange nammwe, na buli kitonde ekiramu ekiri nammwe, era n’ab’emirembe egiriddawo. ");
INSERT INTO lug_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nteeka musoke wange mu kire, nga ke kabonero ak’endagaano wakati wange n’ensi. ");
INSERT INTO lug_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","“Kale olunaatuukanga, bwe nnaaleetaanga ekire ku nsi, musoke anaalabikiranga ku bire, ");
INSERT INTO lug_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ne nzijukira endagaano yange nammwe na buli kiramu; era amazzi tegakyaddayo kuzikiriza biramu. ");
INSERT INTO lug_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Musoke bw’anaabanga ku bire, nnaamutunuuliranga ne nzijukira endagaano eteriggwaawo eriwo wakati wa Katonda na buli kitonde ekiramu ekiri ku nsi.” ");
INSERT INTO lug_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Katonda n’agamba Nuuwa nti, “Kano ke kabonero ak’endagaano gye ntaddewo wakati wange ne buli kiramu ekiri ku nsi.” ");
INSERT INTO lug_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Batabani ba Nuuwa abaava mu lyato ye Seemu, ne Kaamu ne Yafeesi. Kaamu ye yali kitaawe wa Kanani. ");
INSERT INTO lug_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Bonna abasatu be baali batabani ba Nuuwa; era okuva mu bano ensi yonna yajjula abantu. ");
INSERT INTO lug_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuuwa n’atandika okulima n’asimba emizabbibu; ");
INSERT INTO lug_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","n’anywa omwenge n’atamiira, ne yeebaka mu weema ng’ali bwereere. ");
INSERT INTO lug_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kaamu kitaawe wa Kanani n’alaba obwereere bwa kitaawe, n’abuulirako baganda be ababiri abaali ebweru. ");
INSERT INTO lug_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Awo ne bateeka olugoye ku bibegabega byabwe ne batambula ekyennyumannyuma, ne babikka ku bwereere bwa kitaabwe. ");
INSERT INTO lug_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Omwenge bwe gwamwamukako, Nuuwa n’azuukuka n’ategeera mutabani we omuto ky’amukoze. ");
INSERT INTO lug_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","N’akolimira ezzadde lya Kaamu n’agamba nti, “Kanani akolimirwe, abeere muddu wa baddu eri baganda be.” ");
INSERT INTO lug_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Era n’agamba nti, “Mukama Katonda wange, awe Seemu omukisa, Kanani abeere muddu we.” ");
INSERT INTO lug_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Katonda yaza Yafeesi, abeere mu weema za Seemu, Kanani abeere muddu we. ");
INSERT INTO lug_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Oluvannyuma lw’amataba Nuuwa yawangaala emyaka emirala ebikumi bisatu mu ataano. ");
INSERT INTO lug_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Emyaka gyonna Nuuwa, gye yamala ku nsi ne giba lwenda mu amakumi ataano, n’afa. ");
INSERT INTO lug_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Bano be bazzukulu ba Nuuwa, Seemu ne Kaamu, ne Yafeesi be baazaala oluvannyuma lw’amataba. ");
INSERT INTO lug_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Batabani ba Yafeesi: Gomeri, ne Magogi, ne Madayi, ne Yivani, ne Tubali ne Meseki ne Tirasi. ");
INSERT INTO lug_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Batabani ba Gomeri be bano: Asukenaazi, ne Lifasi, ne Togaluma. ");
INSERT INTO lug_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Batabani ba Yivani baali: Erisa, ne Talusiisi, ne Kittimu ne Dodanimu. ");
INSERT INTO lug_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Mu bano mwe mwava abo abaabuna olubalama lw’ennyanja. Bano be batabani ba Yafeesi mu bitundu byabwe, buli bamu mu nnimi zaabwe ng’ennyumba zaabwe n’amawanga gaabwe bwe biri.) ");
INSERT INTO lug_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Batabani ba Kaamu be bano: Kuusi, ne Misiri, ne Puuti, ne Kanani. ");
INSERT INTO lug_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Batabani ba Kuusi be bano: Seeba, ne Kavira, ne Sabuta, ne Laama ne Sebuteka. Batabani ba Laama baali: Seeba ne Dedani. ");
INSERT INTO lug_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuusi ye yazaala Nimuloodi; ye yasooka okuba omuntu ow’amaanyi ennyo ku nsi. ");
INSERT INTO lug_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yali muyizzi kkungwa, mu maaso ga Mukama, kyekyava kigambibwa nti, “Afaanana Nimuloodi omuyizzi kkungwa mu maaso ga Mukama.” ");
INSERT INTO lug_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Obwakabaka bwe bwatandikira Baberi, ne Eneki ne Akudi ne Kalune, nga byonna bya mu nsi Sinali. ");
INSERT INTO lug_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Bwe yava mu nsi eyo n’agenda mu Bwasuli, n’azimba Nineeve, ne Lekobosiyira, ne Kala ne ");
INSERT INTO lug_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Leseni, wakati wa Nineeve ne Kala; Leseni kye kyali ekibuga ekikulu. ");
INSERT INTO lug_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizulayimu oba Misiri ye kitaawe wa Ludimu, ne Anamimu, ne Lekabimu, ne Nafutukimu, ");
INSERT INTO lug_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ne Pasulusimu, ne Kasulukimu (omwava Abafirisuuti) ne Kafutorimu. ");
INSERT INTO lug_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanani ye yazaala Sidoni, omwana we omubereberye, ne Keesi, ");
INSERT INTO lug_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","n’Abayebusi, n’Abamoli, n’Abagirugaasi, ");
INSERT INTO lug_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","n’Abakiivi, n’Abaluki, n’Abasiini, ");
INSERT INTO lug_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","n’Abaluvada, n’Abazemali, n’Abakamasi n’ebika eby’omu Kanani ne babuna wonna. ");
INSERT INTO lug_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ekitundu kya Kanani kyava ku Sidoni, okwolekera Gerali n’okutuukira ddala e Gaza okwolekera Sodomu, ne Ggomola, ne Aduma, ne Zeboyimu okutuukira ddala e Lasa. ");
INSERT INTO lug_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Abo be bazzukulu ba Kaamu, mu nda zaabwe ne nnimi zaabwe, mu bitundu byabwe ne mu mawanga gaabwe. ");
INSERT INTO lug_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seemu kitaawe w’abo bonna abaava mu Eberi, mukulu wa Yafeesi naye yazaalirwa abaana. ");
INSERT INTO lug_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Abaana ba Seemu be bano: Eramu, ne Asuli, ne Alupakusaadi, ne Ludi ne Alamu. ");
INSERT INTO lug_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Batabani ba Alamu: Uzi, ne Kuuli, ne Ggeseri ne Masi. ");
INSERT INTO lug_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alupakusaadi ye kitaawe wa Seera. Seera ye kitaawe wa Eberi. ");
INSERT INTO lug_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Omu ku batabani ba Eberi yali Peregi, kubanga we yazaalirwa ensi yali yeesazeemu, muganda we ye yali Yokutaani. ");
INSERT INTO lug_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokutaani ye yali kitaawe wa Alumodaadi, ne Serefu, ne Kazalumaveesi, ne Yera, ");
INSERT INTO lug_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ne Kadolaamu, ne Uzali, ne Dikula, ");
INSERT INTO lug_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ne Obali, ne Abimayeeri, ne Seeba, ");
INSERT INTO lug_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ne Ofiri, ne Kavira ne Yobabu; bano bonna baali batabani ba Yokutaani. ");
INSERT INTO lug_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ekitundu mwe baali kyava ku Mesa okwolekera Serali, okutuukira ddala ku kitundu eky’ensozi ku luuyi olw’ebuvanjuba. ");
INSERT INTO lug_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Abo be bazzukulu ba Seemu, mu nnyumba zaabwe, ne mu nnimi zaabwe, ne mu bitundu byabwe ne mu mawanga gaabwe. ");
INSERT INTO lug_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Abo ze nnyumba za batabani ba Nuuwa ng’okuzaalibwa kwabwe bwe kwali, n’amawanga gaabwe; era okuva mu bano amawanga gonna mwe gaayalira ne gabuna ensi yonna oluvannyuma lw’amataba. ");
INSERT INTO lug_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ensi yonna yalina olulimi lumu, nga bakozesa ebigambo bye bimu. ");
INSERT INTO lug_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Abantu bwe baava oluuyi olw’ebuvanjuba ne batuuka mu lusenyi nsi ya Sinaali ne babeera omwo. ");
INSERT INTO lug_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ne bateesa nti, “Mujje tukole amatoffaali, tugookye bulungi.” Ne baba n’amatoffaali mu kifo ky’amayinja, ne kolaasi mu kifo ky’ettosi. ");
INSERT INTO lug_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Awo ne bagamba nti, “Mujje twezimbire ekibuga, tutuuse omunaala gwakyo ku ggulu; twekolere erinnya, tuleme okusaasaanyizibwa okubuna ensi yonna.” ");
INSERT INTO lug_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Naye Mukama nakka okulaba ekibuga n’omunaala, abaana b’abantu kye baali bazimba. ");
INSERT INTO lug_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Mukama n’ayogera nti, “Laba, bali omuntu omu, era boogera olulimi lumu! Era eno ntandikwa butandikwa ey’ebyo bye banaakola; era tewali kye banaateesa kukola ekinaabalemerera. ");
INSERT INTO lug_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mujje, tukke wansi tutabuletabule olulimi lwabwe, baleme kutegeeragana.” ");
INSERT INTO lug_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Bw’atyo Mukama n’abasaasaanya ne babuna ensi yonna, n’ekibuga kyabwe ne batakimaliriza. ");
INSERT INTO lug_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ekibuga ekyo erinnya lyakyo kye lyava liyitibwa Babiri, kubanga eyo Mukama gye yatabuliratabulira olulimi lw’ensi yonna. Eyo Mukama gye yabasaasaanyiza okubuna ensi yonna. ");
INSERT INTO lug_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Bino bye bifa ku b’olulyo lwa Seemu: Seemu bwe yali ng’aweza emyaka kikumi, n’azaala Alupakusaadi nga wakayita emyaka ebiri okuva ku mataba. ");
INSERT INTO lug_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Seemu n’amala emyaka ebikumi bitaano nga Alupakusaadi amaze okusaalibwa. N’azaaliramu abaana aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alupakusaadi bwe yaweza emyaka asatu mu etaano n’azaala Seera, ");
INSERT INTO lug_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Alupakusaadi bwe yamala okuzaala Seera n’awangaala emyaka emirala ebikumi bina mu esatu, omwo n’azaaliramu abaana aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Seera bwe yaweza emyaka amakumi asatu n’azaala Eberi, ");
INSERT INTO lug_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ate Seera n’aweza emyaka emirala ebikumi bina mu asatu ng’amaze okuzaala Eberi, era omwo n’azaaliramu abaana abalala aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberi bwe yaweza emyaka amakumi asatu mu ena n’azaala Peregi. ");
INSERT INTO lug_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eberi bwe yamala okuzaala Peregi n’awangaala emyaka ebikumi bina mu amakumi asatu, omwo n’azaaliramu abaana abalala aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peregi bwe yaweza emyaka amakumi asatu n’azaala Leewo, ");
INSERT INTO lug_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","bwe yamala okuzaala Leewo n’awangaala emyaka emirala ebikumi bibiri mu mwenda, n’azaaliramu abaana aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Leewo bwe yaweza emyaka amakumi asatu mu ebiri n’azaala Serugi. ");
INSERT INTO lug_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","N’awangaala emyaka emirala ebikumi bibiri mu musanvu. Omwo n’azaaliramu abaana aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugi bwe yaweza emyaka amakumi asatu n’azaala Nakoli, ");
INSERT INTO lug_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","bwe yamala okuzaala Nakoli n’awangaala emyaka emirala ebikumi bibiri. Omwo n’azaaliramu abaana aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nakoli bwe yaweza emyaka amakumi abiri mu mwenda n’azaala Teera. ");
INSERT INTO lug_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Bwe yamala okuzaala Teera n’awangaala emyaka emirala kikumi mu kkumi na mwenda, era omwo n’azaaliramu abaana aboobulenzi n’aboobuwala. ");
INSERT INTO lug_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teera bwe yaweza emyaka nsanvu, n’azaala Ibulaamu, ne Nakoli ne Kalani. ");
INSERT INTO lug_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Bino bye bifa ku b’olulyo lwa Teera: Teera ye kitaawe wa Ibulaamu, ne Nakoli ne Kalani; Kalani ye yali kitaawe wa Lutti. ");
INSERT INTO lug_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Kalani yafa nga kitaawe Teera tannafa. Yafiira mu Uli ey’Abakaludaaya mwe yazaalirwa. ");
INSERT INTO lug_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ibulaamu ne Nakoli ne bawasa; erinnya lya mukazi wa Ibulaamu lyali Salaayi, ate mukazi wa Nakoli nga ye Mirika, muwala wa Kalani, kitaawe wa Mirika ne Isika. ");
INSERT INTO lug_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Salaayi yali mugumba, teyalina mwana. ");
INSERT INTO lug_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teera n’atwala Ibulaamu mutabani we Lutti muzzukulu we mutabani wa Kalani, ne Salaayi muka mutabani we Ibulaamu, ne bagenda bonna okuva mu Uli eky’Abakaludaaya okugenda mu nsi ya Kalani; bwe baatuuka mu Kalani, ne babeera omwo. ");
INSERT INTO lug_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Emyaka gya Teera gyali ebikumi bibiri mu etaano; Teera n’afiira mu Kalani. ");
INSERT INTO lug_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Awo Mukama n’agamba Ibulaamu nti, “Vva mu nsi yannyo ne mu bantu bo ne mu nnyumba ya kitaawo ogende mu nsi gye ndikulaga. ");
INSERT INTO lug_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Nange ndikufuula eggwanga eddene, era ndikuwa omukisa, n’erinnya lyo ne ndifuula kkulu, olyoke obeere mukisa. ");
INSERT INTO lug_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ndiwa omukisa abo abakusabira omukisa, era buli alikukolimira nange namukolimiranga; era mu ggwe amawanga gonna ag’omu nsi mwe galiweerwa omukisa.” ");
INSERT INTO lug_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Bw’atyo Ibulaamu n’agenda nga Mukama bwe yamugamba, ne Lutti n’agenda wamu naye. Ibulaamu we yaviira mu Kalani yali aweza emyaka nsanvu mu etaano. ");
INSERT INTO lug_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ibulaamu n’atwala Salaayi mukazi we, ne Lutti mutabani wa muganda we ne byonna bye baalina bye baali bafunye, n’abantu baabwe be baafunira mu Kalani, ne basitula okugenda mu Kanani. Ne batuuka mu nsi ya Kanani. ");
INSERT INTO lug_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ibulaamu n’ayita mu nsi n’atuuka mu kifo ekiyitibwa Sekemu awali emivule gya Mole. Mu biro ebyo Abakanani be baali mu nsi omwo. ");
INSERT INTO lug_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Awo Mukama n’alabikira Ibulaamu n’agamba nti, “Ensi eno ndigiwa abo abaliva mu ggwe.” Awo Ibulaamu n’azimbira eyo Mukama ekyoto eyamulabikira. ");
INSERT INTO lug_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Bw’atyo n’alaga ku lusozi ku luuyi olw’ebuvanjuba obwa Beseri, n’asimba eweema ye nga Beseri ali ku luuyi olw’ebugwanjuba, ne Ayi ngali ku luuyi olw’ebuvanjuba, n’azimbira eyo Mukama ekyoto, n’akoowoola erinnya lya Mukama. ");
INSERT INTO lug_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ibulaamu ne yeeyongera okutambula ng’ayolekera Negevu. ");
INSERT INTO lug_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ne wagwa enjala mu nsi. Bw’atyo Ibulaamu n’aserengeta e Misiri asengukireko eyo, kubanga enjala nnyingi eyali mu nsi. ");
INSERT INTO lug_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Bwe yali anaatera okuyingira mu Misiri, n’agamba Salaayi mukazi we nti, “Mmanyi ng’oli mukazi mulungi era mubalagavu, ");
INSERT INTO lug_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","era Abamisiri bwe balikulabako baligamba nti, ‘Ono ye mukazi we,’ kale balinzita, naye ggwe ne bakuleka. ");
INSERT INTO lug_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ogambanga nti, Oli mwannyinaze ndyoke mbeere bulungi ku lulwo, n’obulamu bwange buleme kubaako kabi, buwone ku lulwo.” ");
INSERT INTO lug_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ibulaamu bwe yayingira mu Misiri, Abamisiri ne balaba Salaayi nga mukazi mulungi nnyo. ");
INSERT INTO lug_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","N’abakungu ba Falaawo bwe baamulaba ne bamutendera Falaawo ne bamutwala mu lubiri lwa Falaawo. ");
INSERT INTO lug_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ku lwa Salaayi, Falaawo n’ayisa bulungi Ibulaamu. Ibulaamu n’aweebwa endiga, n’ente, n’endogoyi, n’abaweereza abasajja, n’abaweereza abakazi, n’endogoyi enkazi, n’eŋŋamira. ");
INSERT INTO lug_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Naye Mukama n’aleetera Falaawo n’ennyumba ye endwadde enkambwe olwa Salaayi mukazi wa Ibulaamu. ");
INSERT INTO lug_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Awo Falaawo n’ayita Ibulaamu n’amugamba nti, “Kiki kino ky’onkoze? Lwaki tewantegeeza nti mukazi wo? ");
INSERT INTO lug_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Lwaki wagamba nti mwannyoko, ne mmutwala okuba mukazi wange? Kale kaakano mukazi wo wuuno mmutwale mugende.” ");
INSERT INTO lug_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Falaawo n’alagira basajja be ebikwata ku Ibulaamu, ne bamusindiikiriza n’ava mu nsi ne mukazi we ne byonna bye yalina. ");
INSERT INTO lug_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Bw’atyo Ibulaamu n’ayambuka okuva mu Misiri ye ne mukazi we, ne byonna bye yalina, ne Lutti ne bayingira mu Negevu. ");
INSERT INTO lug_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Mu kiseera ekyo Ibulaamu yalina ente nnyingi, ne ffeeza ne zaabu nnyingi nnyo. ");
INSERT INTO lug_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","N’atambula okuva e Negevu n’atuuka e Beseri, mu kifo eweema ye we yali olubereberye, wakati wa Beseri ne Ayi, ");
INSERT INTO lug_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","mu kifo we yasooka okuzimbira Mukama ekyoto, Ibulaamu n’akoowoolera eyo erinnya lya Mukama. ");
INSERT INTO lug_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ne Lutti eyagenda ne Ibulaamu naye yalina ebisibo by’endiga n’amagana g’ente n’ab’enju ye nga bangi, ");
INSERT INTO lug_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ekitundu mwe baali nga tekibamala bombi. Obugagga bwabwe bwali bungi nnyo, ");
INSERT INTO lug_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ate nga n’abasumba baabwe bayombagana. Mu kiseera ekyo Abakanani n’Abaperezi nabo baabanga mu nsi omwo. ");
INSERT INTO lug_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Awo Ibulaamu n’agamba Lutti nti, “Tewasaana kubaawo kuyombagana wakati wange naawe, wadde wakati w’abalunzi bo n’abange, kubanga tuli baaluganda. ");
INSERT INTO lug_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ensi yonna teri mu maaso go? Leka twawukane. Bwonoolonda oluuyi olwa kkono, nze n’alaga ku luuyi olwa ddyo, bw’onoolaga ku luuyi olwa ddyo nze n’alaga ku luuyi olwa kkono.” ");
INSERT INTO lug_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lutti n’ayimusa amaaso ge, n’alaba ekiwonvu kya Yoludaani nga kirungi, nga kirimu amazzi buli wantu nga kifaanana ng’ennimiro ya Mukama; nga kiri ng’ensi ya Misiri ku luuyi olwa Zowaali. Kino kyaliwo nga Mukama tannazikkiriza Sodomu ne Ggomola. ");
INSERT INTO lug_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Bw’atyo Lutti ne yeeronderawo olusenyi lwa Yoludaani n’agenda ku luuyi olw’ebuvanjuba; bwe batyo ne baawukana. ");
INSERT INTO lug_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ibulaamu n’abeera mu nsi ya Kanani, ye Lutti n’abeera mu bibuga eby’omu lusenyi n’atwala eweema ye n’agisimba okumpi ne Sodomu. ");
INSERT INTO lug_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Abasajja aba Sodomu baali babi era nga boonoonyi nnyo eri Mukama. ");
INSERT INTO lug_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Mukama n’agamba Ibulaamu ng’amaze okwawukana ne Lutti nti, “Yimusa amaaso go ng’osinziira mu kifo mw’oli, otunule ku bukiikakkono, ne ku bukiikaddyo, n’ebuvanjuba n’ebugwanjuba; ");
INSERT INTO lug_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","kubanga ensi gy’olaba ndigikuwa ggwe n’ezzadde lyo emirembe gyonna. ");
INSERT INTO lug_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ndyaza ezzadde lyo ng’enfuufu ey’oku nsi; omuntu bw’alisobola okubala enfuufu ey’oku nsi, n’ezzadde lyo aliribala. ");
INSERT INTO lug_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Situka, tambula obuwanvu n’obukiika obw’ensi kubanga ngikuwadde.” ");
INSERT INTO lug_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Awo Ibulaamu n’asimbula eweema ye n’agenda n’abeera okumpi n’emivule gya Mamule, ekiri e Kebbulooni, n’azimbira eyo Mukama ekyoto. ");
INSERT INTO lug_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Mu biro bya Amulafeeri kabaka wa Sinaali, ne Aliyooki kabaka wa Erasali, ne Kedolawomeeri kabaka wa Eramu ne Tidali kabaka wa Goyiyimu, ");
INSERT INTO lug_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","bakabaka bano ne balumba ne balwana ne Bbeera kabaka wa Sodomu, ne Bbiruusa kabaka wa Ggomola, ne Sinaabu kabaka wa Aduma, ne Semebeeri kabaka wa Zeboyiyimu ne kabaka wa Bera, ye Zowaali. ");
INSERT INTO lug_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Bano bonna abooluvannyuma ne beegatta wamu mu kiwonvu kya Sidimu (y’Ennyanja ey’Omunnyo). ");
INSERT INTO lug_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Baamala emyaka kkumi n’ebiri nga baweereza Kedolawomeeri kabaka we Eramu, naye mu mwaka ogw’ekkumi n’esatu ne bamujeemera. ");
INSERT INTO lug_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mu mwaka ogw’ekkumi n’ena Kedolawomeeri ne bakabaka abaali naye ne balumba Abaleefa mu Asuterosikalumayimu ne babawangula, n’Abazuuzi mu Kaamu, n’Abemi mu Savekiriyasayimu, ");
INSERT INTO lug_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","n’Abakooli mu nsi ey’ensozi eya Seyiri n’okutuukira ddala Erupalaani okumpi n’eddungu. ");
INSERT INTO lug_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ate ne bakyuka ne bajja e Nuumisupaati, ye Kadesi ne bawangula ensi yonna ey’Abamaleki n’Abamoli abaabeeranga mu Kazazonutamali. ");
INSERT INTO lug_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Awo kabaka wa Sodomu ne kabaka wa Ggomola, ne kabaka wa Aduma, ne kabaka wa Zeboyiyimu ne kabaka wa Bera, ye Zowaali ne beegatta mu lutalo mu kiwonvu ky’e Sidimu ");
INSERT INTO lug_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","okulwanyisa Kedolawomeeri kabaka wa Eramu, ne Tidali kabaka wa Goyiyimu ne Amulafeeri kabaka wa Sinaali awamu ne Aliyooki kabaka wa Erasali, bakabaka bana nga balwanyisa bakabaka bataano. ");
INSERT INTO lug_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ekiwonvu ky’e Sidimu kyali kijjudde ebinnya ebirimu kolaasi; bakabaka b’e Sodomu ne Ggomola bwe baddukanga ng’abamu babigwamu, n’abalala ne baddukira ku nsozi. ");
INSERT INTO lug_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Awo bakabaka abana ne batwala ebintu byonna ebyali mu Sodomu ne Ggomola, n’emmere yaabwe yonna gye baalina ne bagenda. ");
INSERT INTO lug_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Era ne batwala ne Lutti, mutabani wa muganda wa Ibulaamu eyali mu Sodomu, n’ebintu bye ne bagenda nabyo kubanga naye yali abeera mu Sodomu. ");
INSERT INTO lug_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Awo Omwamoli omu eyali abadduseeko n’ajja n’ategeeza Ibulaamu Omwebbulaniya, eyali abeera okumpi n’emivule gya Mamule, muganda wa Esukoli ne Aneri abaalina endagaano ne Ibulaamu. ");
INSERT INTO lug_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ibulaamu bwe yawulira nti muganda we atwalibbwa nga munyage, n’akulembera basajja be abatendeke, abazaalirwa mu nnyumba ye, ebikumi bisatu mu kkumi na munaana, ne bawondera abaatwala Lutti okutuuka e Ddaani. ");
INSERT INTO lug_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Mu kiro n’ayawulamu eggye lye, n’abalumba, ye n’abaddu be ne bagoberera abantu bali okutuuka e Kkoba, ku luuyi olw’obukiikakkono obwa Damasiko. ");
INSERT INTO lug_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Awo n’akomyawo ebintu byonna, era n’akomyawo ne muganda we Lutti n’ebintu bye n’abakazi n’abantu bonna. ");
INSERT INTO lug_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ibulaamu bwe yakomawo ng’amaze okuwangula Kedolawomeeri ne bakabaka abaali naye, kabaka wa Sodomu n’afuluma okumusisinkana mu kiwonvu ky’e Save (kye kiwonvu kya kabaka). ");
INSERT INTO lug_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ne Merukizeddeeki kabaka wa Ssaalemi eyali kabona wa Katonda Ali Waggulu Ennyo n’aleeta omugaati n’envinnyo. ");
INSERT INTO lug_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","N’asabira Ibulaamu omukisa ng’agamba nti, “Katonda Ali Waggulu Ennyo Omutonzi w’eggulu n’ensi awe Ibulaamu omukisa. ");
INSERT INTO lug_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Era Katonda Ali Waggulu Ennyo agulumizibwe agabudde abalabe bo mu mikono gyo.” Awo Ibulaamu n’amuwa ekitundu eky’ekkumi ekya buli kimu. ");
INSERT INTO lug_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ne kabaka wa Sodomu n’agamba Ibulaamu nti, “Mpa abantu, gwe otwale ebintu.” ");
INSERT INTO lug_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Naye Ibulaamu n’addamu kabaka wa Sodomu nti, “Ndayira Mukama Katonda Ali Waggulu Ennyo, Omutonzi w’eggulu n’ensi, ");
INSERT INTO lug_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","sijja kutwala wadde akawuzi oba akakoba akasiba engatto, oba ekintu kyonna ekikyo, oleme okugamba nti, ‘Ngaggawazza Ibulaamu.’ ");
INSERT INTO lug_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Sijja kubaako kye ntwala; okuggyako ebyo abavubuka bye balidde, n’omugabo gw’abasajja abaagenda nange; leka Aneri ne Esukoli ne Mamule bo batwale omugabo gwabwe.” ");
INSERT INTO lug_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ebyo nga biwedde, ekigambo kya Mukama ne kijjira Ibulaamu mu kwolesebwa nti, “Totya Ibulaamu, Nze ngabo yo era empeera yo ennene ennyo.” ");
INSERT INTO lug_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Naye Ibulaamu n’addamu nti, “Kiki ky’olimpa Ayi Mukama Katonda, kubanga sirina mwana, n’omusika w’ennyumba yange ye Eryeza ow’omu Ddamasiko?” ");
INSERT INTO lug_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ibulaamu ne yeeyongera n’agamba nti, “Laba tompadde mwana; omuddu eyazaalibwa mu nnyumba yange ye musika wange.” ");
INSERT INTO lug_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Laba ekigambo kya Mukama ne kimujjira nti, “Omusajja oyo tagenda kuba musika wo; mutabani wo, y’aliba omusika wo.” ");
INSERT INTO lug_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","N’amufulumya ebweru n’amugamba nti, “Tunuulira eggulu, obale emunyeenye, obanga osobola okuzibala.” Awo n’amugamba nti, “N’ezzadde lyo bwe liriba bwe lityo.” ");
INSERT INTO lug_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ibulaamu n’akkiriza Mukama, n’akimubalira okuba obutuukirivu. ");
INSERT INTO lug_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","N’amugamba nti, “Nze Mukama eyakuggya mu Uli ensi ey’Abakaludaaya, nkuwe ensi eno ebeere yiyo.” ");
INSERT INTO lug_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ibulaamu n’addamu nti, “Ayi Mukama nnaamanya ntya nti eriba yange?” ");
INSERT INTO lug_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Mukama n’amuddamu nti, “Ndeetera ennyana eyaakamala emyaka esatu, embuzi ey’emyaka esatu, endiga ensajja ey’emyaka esatu, kaamukuukulu n’ejjiba.” ");
INSERT INTO lug_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ibulaamu n’abireeta byonna n’abisalamu wakati n’ateeka buli kitundu kungulu ku kinnaakyo, naye ebinyonyi byo teyabisalamu bitundu nga biri. ");
INSERT INTO lug_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ensega bwe zajja okubirya, Ibulaamu n’azigoba. ");
INSERT INTO lug_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Enjuba yali egwa, Ibulaamu ne yeebaka otulo tungi; era laba, ekizikiza ekingi eky’amaanyi ne kimubuutikira. ");
INSERT INTO lug_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Awo Mukama n’agamba Ibulaamu nti, “Manyira ddala nti ezzadde lyo baliba batambuze mu nsi eteri yaabwe, era baliba baddu eyo, balibonyaabonyezebwa eyo okumala emyaka ebikumi bina. ");
INSERT INTO lug_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Naye ndibonereza eggwanga lye balikolera n’oluvannyuma balivaayo n’obugagga bungi. ");
INSERT INTO lug_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Naye ggwe oligenda mirembe eri bajjajjaabo; oliziikibwa ng’owangaalidde ddala nnyo. ");
INSERT INTO lug_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Era balikomawo wano mu mulembe ogwokuna; kubanga obutali butuukirivu bw’Omwamoli tebunnayitirira.” ");
INSERT INTO lug_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Enjuba bwe yagwa ng’ekizikiza kikutte, laba, ensuwa eyaka omuliro era enyooka omukka n’ekimulisa ne biyita wakati w’ebitundu bino. ");
INSERT INTO lug_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ku lunaku olwo Mukama n’akola endagaano ne Ibulaamu ng’agamba nti, “Ezadde lyo ndiwa ensi eno, okuva ku mugga ogw’e Misiri okutuuka ku mugga omunene, omugga Fulaati: ");
INSERT INTO lug_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Omukeeni, n’Omukenizi, n’Omukadumoni, ");
INSERT INTO lug_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","n’Omukiiti, n’Omuperizi, n’Abaleefa, ");
INSERT INTO lug_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","n’Omwamoli, n’Omukanani, n’Omugirugaasi n’Omuyebusi, mbagabula mu mukono gwo.” ");
INSERT INTO lug_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Salaayi mukyala wa Ibulaamu yali teyamuzaalira mwana; ");
INSERT INTO lug_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Salaayi n’agamba Ibulaamu nti, “Laba Mukama tampadde mwana; weebake n’omuweereza wange, oboolyawo nnyinza okufuna abaana mu ye.” Awo Ibulaamu n’awulira eddoboozi lya Salaayi. ");
INSERT INTO lug_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Bw’atyo Ibulaamu bwe yali yaakamala emyaka kkumi mu nsi ya Kanani, Salaayi mukazi we n’addira Agali Omumisiri, omuweereza we n’amuwa Ibulaamu abeere mukazi we. ");
INSERT INTO lug_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ibulaamu ne yeegatta ne Agali, Agali n’aba olubuto. Agali bwe yalaba ng’ali lubuto, n’anyooma Salaayi, mugole we. ");
INSERT INTO lug_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Salaayi n’agamba Ibulaamu nti, “Ekibi ekinkoleddwako kibeere ku ggwe. Nakuwa omuweereza wange mu kifuba kyo naye bw’alabye ng’ali lubuto n’annyooma. Mukama atulamule nze naawe!” ");
INSERT INTO lug_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Naye Ibulaamu n’agamba Salaayi nti, “Laba, omuweereza wo ali mu buyinza bwo; mukole nga bw’oyagala.” Awo Salaayi natandika okubonyaabonya Agali; Agali n’adduka okuva w’ali. ");
INSERT INTO lug_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malayika wa Mukama n’amusanga ku nsulo y’amazzi mu ddungu, ensulo y’amazzi eri ku kkubo eriraga e Ssuuli. ");
INSERT INTO lug_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","N’agamba nti, “Agali, omuweereza wa Salaayi, ovudde wa era ogenda wa?” N’amuddamu nti, “Nziruka mugole wange Salaayi.” ");
INSERT INTO lug_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Malayika wa Mukama n’amugamba nti, “Ddayo eri mugole wo omugondere.” ");
INSERT INTO lug_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Era Malayika n’amugamba nti, “Ezadde lyo ndiryaza waleme kubeerawo asobola kulibala.” ");
INSERT INTO lug_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ate malayika wa Mukama n’amugamba nti, “Laba, olina omwana mu nda yo, aliba wabulenzi, olimutuuma Isimayiri, kubanga Mukama ategedde okubonaabona kwo. ");
INSERT INTO lug_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Aliba ng’entulege, anaalwananga na buli muntu era na buli muntu anaalwananga naye, era anaabanga mu bulabe ne baganda be.” ");
INSERT INTO lug_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Awo n’akoowoola erinnya lya Mukama eyayogera naye, n’agamba nti, “Oli Katonda alaba”, kubanga yagamba nti, “Ndabidde ddala Katonda ne nsigala nga ndi mulamu nga maze okumulaba.” ");
INSERT INTO lug_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Oluzzi kye lwava luyitibwa Beerirakayiro, luli wakati wa Kadesi ne Beredi. ");
INSERT INTO lug_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Awo Agali n’azaalira Ibulaamu omwana owoobulenzi, Ibulaamu n’atuuma mutabani wa Agali gwe yamuzaalira, erinnya Isimayiri. ");
INSERT INTO lug_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ibulaamu yali wa myaka kinaana mu mukaaga Agali bwe yamuzaalira Isimayiri. ");
INSERT INTO lug_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ibulaamu bwe yaweza emyaka kyenda mu mwenda, Mukama n’amulabikira, n’amugamba nti, “Ndi Katonda Ayinzabyonna, tambulira mu maaso gange obe nga toliiko kya kunenyezebwa. ");
INSERT INTO lug_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ndikola endagaano yange naawe era ndikwaliza ddala nnyo.” ");
INSERT INTO lug_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Awo Ibulaamu n’avuunama; Katonda n’amugamba nti, ");
INSERT INTO lug_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Laba, ndikola naawe endagaano, era onoobeeranga kitaawe w’amawanga mangi. ");
INSERT INTO lug_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Erinnya lyo tokyayitibwa Ibulaamu, wabula onooyitibwanga Ibulayimu, kubanga nkufudde kitaawe w’amawanga mangi. ");
INSERT INTO lug_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ndikwaza nnyo nnyini; era ndikufuula amawanga, ne bakabaka baliva mu ggwe. ");
INSERT INTO lug_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Era ndituukiriza endagaano yange naawe, n’ezzadde lyo mbeere Katonda wo era Katonda w’ezzadde lyo eririddawo. Endagaano eno teriggwaawo emirembe n’emirembe. ");
INSERT INTO lug_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Era ndikuwa ggwe n’ezzadde lyo eririddawo ensi mw’obadde omusenze, ensi yonna eya Kanani, okuba eyiyo emirembe gyonna; era ndiba Katonda waabwe.” ");
INSERT INTO lug_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Awo Katonda n’agamba Ibulayimu nti, “Ggwe ky’olina okukola kwe kukwata endagaano yange, ggwe n’ezzadde lyo eririddawo emirembe gyabwe gyonna. ");
INSERT INTO lug_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Eno y’endagaano yange naawe n’ezzadde lyo eririddawo, gy’onookuumanga: Buli musajja mu mmwe anaakomolebwanga. ");
INSERT INTO lug_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Munaakomolebwanga ekikuta eky’omubiri gwammwe, ekyo kibeere akabonero ak’endagaano yange naawe. ");
INSERT INTO lug_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Buli mwana owoobulenzi anaawezanga ennaku omunaana ez’obukulu mu mmwe mu mirembe gyammwe gyonna anaakomolebwanga, ");
INSERT INTO lug_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","oyo azaaliddwa mu nnyumba yo oba gw’oguze n’ensimbi zo okuva ku munnaggwanga anaakomolebwanga. Endagaano yange eteriggwaawo eneebanga mu mubiri gwo. ");
INSERT INTO lug_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Omwana owoobulenzi yenna atali mukomole, atakomolebbwa kikuta kya mubiri gwe, taabalibwenga mu bantu be, aba amenye endagaano yange.” ");
INSERT INTO lug_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Katonda n’agamba Ibulayimu nti, “Era Salaayi mukazi wo, tokyamuyita Salaayi, erinnya lye linaabanga Saala. ");
INSERT INTO lug_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ndimuwa omukisa, era ndikuwa omwana owoobulenzi mu ye. Ndimuwa omukisa, alibeera jjajja w’amawanga, bakabaka baamawanga baliva mu ye.” ");
INSERT INTO lug_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Awo Ibulayimu n’avuunama n’aseka, n’agamba munda ye nti, “Omwana alizaalirwa oyo eyaakamala emyaka ekikumi? Saala ow’emyaka ekyenda alizaala omwana?” ");
INSERT INTO lug_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ibulayimu n’agamba Katonda nti, “Isimayiri abeerenga mulamu mu maaso go!” ");
INSERT INTO lug_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Katonda n’amugamba nti, “Nedda, naye Saala mukazi wo alikuzaalira omwana owoobulenzi, olimutuuma erinnya Isaaka. Ndinyweza endagaano yange naye okuba endagaano etaliggwaawo ku zadde lye eririddawo. ");
INSERT INTO lug_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ku Isimayiri nkuwulidde: Laba, ndimuwa omukisa, alyeyongera, ndimwaliza ddala nnyo, aliba jjajja w’abalangira kkumi na babiri, era ndimufuula eggwanga ery’amaanyi. ");
INSERT INTO lug_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kyokka ndinyweza endagaano yange ne Isaaka, Saala gw’alikuzaalira mu kiseera nga kino omwaka ogujja.” ");
INSERT INTO lug_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Katonda bwe yamala okwogera naye, Ibulayimu n’ava we yali. ");
INSERT INTO lug_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Awo Ibulayimu n’atwala Isimayiri mutabani we n’abaddu bonna abaazaalirwa mu nnyumba ye n’abo abaagulibwa n’ensimbi ze, buli musajja yenna mu nnyumba ya Ibulayimu n’akomolwa buli omu ekikuta ky’omubiri gwe ku lunaku olwo lwennyini, nga Katonda bwe yamugamba. ");
INSERT INTO lug_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibulayimu yali aweza emyaka kyenda mu mwenda bwe yakomolebwa ekikuta ky’omubiri gwe. ");
INSERT INTO lug_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ne Isimayiri mutabani we yali wa myaka kkumi n’esatu bwe yakomolebwa ekikuta ky’omubiri gwe. ");
INSERT INTO lug_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ku lunaku olwo lwennyini Ibulayimu ne mutabani we Isimayiri lwe baakomolebwa. ");
INSERT INTO lug_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","N’abasajja bonna mu nnyumba y’abo abazaalirwamu n’abo abaagulibwa n’ensimbi ze okuva eri munnaggwanga, baakomolebwa wamu naye. ");
INSERT INTO lug_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Awo Mukama n’alabikira Ibulayimu mu mivule gya Mamule, mu ttuntu ng’atudde mu mulyango gwa weema ye. ");
INSERT INTO lug_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Bwe yasitula amaaso ge n’alaba, era laba, abasajja basatu nga bayimiridde mu maaso ge. Bwe yabalaba, n’adduka okuva mu mulyango gwa weema ye, okubasisinkana n’agwa wansi, ");
INSERT INTO lug_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","n’agamba nti, “Mukama wange obanga ndabye ekisa mu maaso go, toyita ku muddu wo. ");
INSERT INTO lug_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Leka tuleete otuzzi munaabe ku bigere, muwummuleko wano wansi w’omuti, ");
INSERT INTO lug_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","nga bwe ndeeta omugaati mulyeko muddemu amaanyi, mulyoke mugende, anti muzze eri muddu wammwe.” Ne bamugamba nti, “Kola nga bw’ogambye.” ");
INSERT INTO lug_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ibulayimu n’ayanguwa okugenda eri Saala, n’amugamba nti, “Teekateeka mangu kilo kkumi na mukaaga ez’obutta okande ofumbire mangu abagenyi emmere.” ");
INSERT INTO lug_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ibulayimu n’agenda bunnambiro mu kisibo n’aggyamu ennyana, ento era ennungi n’agiwa omu ku bavubuka eyayanguwa okugifumba. ");
INSERT INTO lug_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Awo n’addira omuzigo n’amata n’ennyana eyafumbibwa n’abiteeka mu maaso gaabwe; n’ayimirira we baali, wansi w’omuti nga balya. ");
INSERT INTO lug_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ne bamubuuza nti, “Saala mukyala wo ali ludda wa?” N’addamu nti, “Ali mu weema.” ");
INSERT INTO lug_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Awo omu ku bo n’amugamba nti, “Ddala ndikomawo gy’oli mu kiseera nga kino, era Saala mukazi wo alizaala omwana owoobulenzi.” Ne Saala yali awuliriza ng’ali mu mulyango gwa weema emabega we. ");
INSERT INTO lug_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Mu kiseera kino Ibulayimu ne Saala baali bakaddiye nnyo nga Saala takyali na mu nsonga z’abakazi. ");
INSERT INTO lug_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Awo Saala n’asekera muli ng’agamba nti, “Nga nkaddiye, nga ne baze akaddiye, ndisanyusibwa?” ");
INSERT INTO lug_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Mukama n’abuuza Ibulayimu nti, “Lwaki Saala asese ng’agamba nti, ‘Ndiyinza okuzaala omwana nga nkaddiye?’ ");
INSERT INTO lug_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Waliwo ekirema Mukama? Omwaka ogujja, mu kiseera kyennyini, ndikomawo gy’oli, ne Saala alizaala omwana owoobulenzi.” ");
INSERT INTO lug_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Naye Saala ne yeegaana ng’agamba nti, “Si sese,” kubanga yali atidde. N’amuddamu nti, “Nedda osese.” ");
INSERT INTO lug_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Awo abasajja bwe bavaayo ne bagenda, ne boolekera oluuyi lwa Sodomu; Ibulayimu n’abawerekerako. ");
INSERT INTO lug_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Mukama n’agamba mu mutima gwe nti, “Ibulayimu namukweka kye ŋŋenda okukola? ");
INSERT INTO lug_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ibulayimu agenda kufuuka eggwanga eddene, ery’amaanyi, era mu ye, amawanga gonna mwe galiweerwa omukisa. ");
INSERT INTO lug_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Mmulonze alagire abaana be n’abantu be abaliddawo okukwatanga ekkubo lya Mukama nga bakola eby’obutuukirivu era nga ba mazima, Mukama alyoke atuukirize ekyo kye yasuubiza Ibulayimu.” ");
INSERT INTO lug_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Awo Mukama n’agamba nti, “Olw’okunkaabirira okusukkiridde olw’ebibi bya Sodomu ne Ggomola ebingi ennyo, ");
INSERT INTO lug_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","nzija kukka ndabe obanga ddala bakozi ba bibi ng’okunkaabirira olw’ebibi byabwe okutuuse gye ndi bwe kuli, era obanga si bwe kiri nnaamanya.” ");
INSERT INTO lug_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Awo abasajja ne bakyuka okuva awo, ne batambula okwolekera Sodomu; naye Ibulayimu n’asigala ng’akyayimiridde mu maaso ga Mukama. ");
INSERT INTO lug_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Awo Ibulayimu n’amusemberera n’agamba nti, “Ddala olizikiriza abatuukirivu awamu n’ababi? ");
INSERT INTO lug_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Singa mu kibuga mulimu abatuukirivu amakumi ataano onookizikiriza n’otokisonyiwa olw’abatuukirivu amakumi ataano abakirimu? ");
INSERT INTO lug_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kireme okuba gy’oli okukola ekintu bwe kityo, okutta abatuukirivu awamu n’ababi, abatuukirivu ne benkana n’ababi! Kireme kuba bwe kityo! Omulamuzi ow’ensi yonna teyandisaanye akole kituufu?” ");
INSERT INTO lug_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mukama n’agamba nti, “Bwe nnaasanga mu Sodomu abatuukirivu amakumi ataano mu kibuga omwo nzija kusonyiwa ekibuga kyonna ku lwabwe.” ");
INSERT INTO lug_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ibulayimu n’addamu nti, “Laba nnyinziza okwogera ne Mukama, nze ani, nze enfuufu n’evvu! ");
INSERT INTO lug_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Singa abatuukirivu babulako bataano okuwera amakumi ataano, onoozikiriza ekibuga kubanga kubulako bataano?” N’amuddamu nti, “Sijja kukizikiriza, bwe nnaasangamu abatuukirivu amakumi ana mu abataano abampulira.” ");
INSERT INTO lug_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ate Ibulayimu n’amugamba nti, “Singa musangibwamu amakumi ana.” N’amuddamu nti, “Ku lw’amakumi ana sijja kukizikiriza.” ");
INSERT INTO lug_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ate n’agamba nti, “Kale nno Mukama aleme okunsunguwalira, nange nnaayogera. Singa musangibwamu amakumi asatu.” N’addamu nti, “Sijja kukizikiriza singa musangibwamu amakumi asatu.” ");
INSERT INTO lug_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","N’agamba nti, “Laba ŋŋumye ne njogera ne Mukama. Singa musangibwamu amakumi abiri.” N’agamba nti, “Ku lw’amakumi abiri sijja kukizikiriza.” ");
INSERT INTO lug_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ate n’agamba nti, “Kale Mukama aleme okukwatibwa obusungu, nnaayongera okwogera, naye luno lwokka. Singa kkumi lye linaasangibwamu.” N’addamu nti, “Ku lw’abo ekkumi sijja kukizikiriza.” ");
INSERT INTO lug_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mukama bwe yamala okwogera ne Ibulayimu n’agenda, ne Ibulayimu n’addayo ewuwe. ");
INSERT INTO lug_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Bamalayika ababiri ne batuuka mu Sodomu akawungeezi; Lutti yali atudde mu mulyango gwa Sodomu. Lutti bwe yabalaba n’agolokoka okubasisinkana, n’avuunama, ");
INSERT INTO lug_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","n’agamba nti, “Bakama bange mukyame mu nnyumba y’omuddu wammwe munaabe ku bigere, mbegayiridde n’okusula musule. Munaazuukuka mangu ku makya ne mukwata ekkubo lyammwe.” Ne bagamba nti, “Nedda tunaasula mu luguudo.” ");
INSERT INTO lug_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Naye n’abawaliriza nnyo; awo ne bakyama ne bajja gy’ali ne bayingira mu nnyumba ye, n’abategekera ekijjulo n’emigaati egitali mizimbulukuse ne balya. ");
INSERT INTO lug_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Naye nga tebannaba kugenda kwebaka, abasajja ab’omu kibuga, abasajja ba Sodomu, abakulu n’abato, abantu bonna ne beetooloola ennyumba; ");
INSERT INTO lug_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ne bayita Lutti nga bagamba nti, “Abasajja abazze gy’oli ekiro kino bali ludda wa? Batufulumize twebake nabo.” ");
INSERT INTO lug_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lutti n’afuluma gye bali, n’aggalawo oluggi, ");
INSERT INTO lug_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","n’abagamba nti, “Baganda bange mbasaba temukola kibi kifaanana bwe kityo. ");
INSERT INTO lug_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Laba, nnina bawala bange embeerera babiri, ka mbabafulumize, mubakole kye mwagala; naye temubaako kye mukola basajja bano, bagenyi bange era nze mbalabirira.” ");
INSERT INTO lug_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Naye ne bamugamba nti, “Tuviire! Omusajja omugwira ono, ate kati y’atulagira eky’okukola! Nedda, tujja kukukolako n’okusinga abagenyi bo.” Awo ne banyigiriza nnyo Lutti, era kaabula kata bamenye n’oluggi. ");
INSERT INTO lug_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Naye abasajja ababiri abaali mu nnyumba ne bagolola emikono gyabwe ne bakwata Lutti ne bamuyingiza mu nnyumba ne baggalawo oluggi. ");
INSERT INTO lug_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ne baziba amaaso g’abasajja abaali ebweru ku luggi lw’ennyumba, abato n’abakulu, ne bakoowa nga bawammanta oluggi. ");
INSERT INTO lug_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Awo abasajja bali ababiri ne babuuza Lutti nti, “Olina abantu bo abalala wano, batabani bo, oba bakoddomi bo, oba bawala bo, oba omuntu omulala yenna mu kibuga? Bafulumye mu kifo kino; ");
INSERT INTO lug_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","kubanga tuli kumpi okukizikiriza. Kubanga okukaaba olw’abantu baamu eri Mukama kuyitiridde, era atutumye okukizikiriza.” ");
INSERT INTO lug_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Awo Lutti n’afuluma n’ategeeza bakoddomi be abaali ab’okuwasa bawala be ng’agamba nti, “Musituke, muve mu kifo kino, kubanga Mukama ali kumpi kukizikiriza.” Naye yafaanana ng’abalaata eri bakoddomi be. Lutti n’ab’ennyumba ye ne badduka. ");
INSERT INTO lug_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Naye obudde bwe bwali bunaatera okukya, bamalayika ne balagira Lutti nga bagamba nti, “Golokoka, otwale mukazi wo ne bawala bo ababiri abali wano muleme okuzikirira ng’ekibuga kibonerezebwa.” ");
INSERT INTO lug_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Naye bwe yali akyekunya, abasajja ne bamukwata omukono, n’emikono gya mukazi we, n’emikono gy’abawala be bombi, Mukama ng’abakwatirwa ekisa, ne babafulumya ne babateeka ebweru w’ekibuga. ");
INSERT INTO lug_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Bwe baabafulumya ne babagamba nti, “Mudduke muwonye obulamu bwammwe, temutunula mabega wadde okuyimirira mu kiwonvu; muddukire ku nsozi, muleme okuzikirizibwa.” ");
INSERT INTO lug_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Awo Lutti n’abagamba nti, “Nedda bakama bange; ");
INSERT INTO lug_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Laba, omuddu wammwe alabye ekisa mu maaso gammwe, era mundaze ekisa kingi nga muwonya obulamu bwange; naye siyinza kuddukira ku nsozi akabi tekalwa kunzingiza ne nfa. ");
INSERT INTO lug_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Laba, ekibuga kiri ekitono ekiri okumpi, kirungi okuddukira omwo. Leka nzirukire eyo. Era n’obulamu bwange bujja kuwona!” ");
INSERT INTO lug_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","N’amuddamu nti, “Laba, era nnyongedde okukukwatirwa ekisa, sijja kumalawo kibuga ky’oyogeddeko. ");
INSERT INTO lug_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Yanguwa tolwa, ddukira eyo; kubanga siriiko kye nnaakola nga tonnatuuka eyo.” Erinnya ly’ekibuga kyeryava liba Zowaali. ");
INSERT INTO lug_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lutti we yatuukira mu Zowaali enjuba yali evuddeyo, Sodomu ne Ggomola ne bizikirizibwa. ");
INSERT INTO lug_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Awo Mukama n’atonnyesa ku Sodomu ne Ggomola omuliro n’obuganga okuva mu ggulu; ");
INSERT INTO lug_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","n’azikiriza ebibuga ebyo, n’ekiwonvu kyonna n’abantu bonna abaali mu bibuga, ne buli kintu ekyalimu. ");
INSERT INTO lug_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Naye mukazi wa Lutti bwe yatunula emabega, n’afuuka empagi ey’omunnyo. ");
INSERT INTO lug_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Awo ku makya ennyo Ibulayimu n’agenda mu kifo mwe yayimiririra mu maaso ga Mukama; ");
INSERT INTO lug_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","n’atunula wansi okwolekera Sodomu ne Ggomola n’okwolekera ekitundu kyonna eky’olusenyi, n’alaba, era laba, ekitundu kyonna nga kijjudde omukka. ");
INSERT INTO lug_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Bwe kityo bwe kyali Katonda bwe yazikiriza ebibuga eby’omu kiwonvu. Katonda n’ajjukira Ibulayimu n’afulumya Lutti ebweru n’amuggya wakati mu kuzikirizibwa, bwe yazikiriza ebibuga Lutti mwe yabeeranga. ");
INSERT INTO lug_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Awo Lutti n’ava mu Zowaali, n’abeera mu nsozi wamu ne bawala be, kubanga yatya okubeera mu Zowaali. Ye ne bawala be ne babeera mu mpuku. ");
INSERT INTO lug_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Olunaku lumu omuwala omukulu n’agamba muto we nti, “Kitaffe akaddiye era tewali na musajja ku nsi ajja kutwagala ng’empisa y’ensi bw’eri. ");
INSERT INTO lug_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Jjangu tunywese kitaffe omwenge, tulyoke twebake naye, tusobole okufuna ezzadde nga liva mu kitaffe.” ");
INSERT INTO lug_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ne batamiiza kitaabwe ekiro ekyo, omukulu n’agenda ne yeebaka ne kitaawe, Lutti n’atamanya bwe yeebaka yadde bwe yagolokoka. ");
INSERT INTO lug_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ku lunaku olwaddirira, omuwala omukulu n’agamba omuto nti, “Laba, ekiro neebase ne kitange; Leka tumunywese omwenge ekiro kino, oyingire gy’ali weebake naye, tulyoke tusobole okukuuma ezzadde mu kitaffe.” ");
INSERT INTO lug_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Awo ne batamiiza kitaabwe ekiro ekyo, omuwala omuto n’asituka ne yeebaka naye, Lutti n’atamanya bwe yeebase ne bw’agolokose. ");
INSERT INTO lug_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Bwe batyo bawala ba Lutti bombi buli omu n’aba olubuto nga lwa kitaabwe. ");
INSERT INTO lug_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Omuwala omukulu n’azaala omwana wabulenzi n’amutuuma Mowaabu, ye jjajja w’Abamowaabu abaliwo kaakano. ");
INSERT INTO lug_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Omuto naye n’azaala omwana mulenzi n’amutuuma Benami, ye yavaamu Abamoni abaliwo ne kaakano. ");
INSERT INTO lug_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ibulayimu bwe yava eyo n’atambula okwolekera Negevu, n’abeera wakati wa Kadesi ne Ssuuli; n’agenda mu Gerali. ");
INSERT INTO lug_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ibulayimu n’ayogera ku Saala mukazi we nti, “Mwannyinaze.” Abimereki kabaka we Gerali n’atumya n’atwala Saala. ");
INSERT INTO lug_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Naye Katonda n’ajja eri Abimereki mu kirooto ekiro n’amugamba nti, “Laba oli mufu, olw’omukazi gw’otutte kubanga muka musajja.” ");
INSERT INTO lug_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Naye Abimereki yali tanneebaka naye, n’alyoka agamba nti, “Onotta abantu abataliiko musango. ");
INSERT INTO lug_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Si yeyaŋŋamba nti, ‘Mwannyinaze?’ Era ne Saala n’aŋŋamba nti, ‘Mwannyina.’ Kino nkikoze mu mutima omutuukirivu n’emikono gyange tegiriiko musango.” ");
INSERT INTO lug_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Awo Katonda n’ayogera naye mu kirooto nti, “Ddala mmanyi nti okoze kino mu mutima omutuukirivu, era nze nakukuuma oleme okwonoona gye ndi; ne nkuziyiza okumukwatako. ");
INSERT INTO lug_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kale kaakano zzaayo mukazi w’omusajja, kubanga nnabbi, era anaakusabira, nawe on’oba mulamu. Naye bw’otomuzzeeyo, manya ng’ojja kufa, ggwe ne by’olina byonna.” ");
INSERT INTO lug_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Awo Abimereki n’agolokoka mu makya ennyo n’ayita abakungu be bonna n’abategeeza ebintu bino byonna; abasajja ne batya nnyo. ");
INSERT INTO lug_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Awo Abimereki n’ayita Ibulayimu n’amugamba nti, “Otukoze ki? Era nsobi ki gye nkukoze, n’ondeetera nze n’obwakabaka bwange ekibi ekinene ekyenkana awo? By’onkoze tebisaana kukolebwa muntu.” ");
INSERT INTO lug_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Era Abimereki n’agamba Ibulayimu nti, “Wali olowooza ki okukola ekintu kino?” ");
INSERT INTO lug_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibulayimu n’addamu nti, “Nakikola kubanga nalowooza nti mu kifo kino temuliimu kutya Katonda n’akamu, era balinzita olwa mukazi wange. ");
INSERT INTO lug_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Naze ebyo nga biri awo ddala mwannyinaze, muwala wa kitange, naye si muwala wa mmange; era yafuuka mukazi wange. ");
INSERT INTO lug_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Katonda bwe yandeeta okuva mu nnyumba ya kitange, ne mugamba nti, ‘Eky’ekisa ky’oyinza okunkolera kye kino, buli kifo kye tutuukamu njogeraako nti ndi mwannyoko.’ ” ");
INSERT INTO lug_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Awo Abimereki n’atwala endiga n’ente, abaweereza abasajja n’abaweereza abakazi, n’abiwa Ibulayimu, n’amuddiza Saala mukyala we. ");
INSERT INTO lug_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Era Abimereki n’amugamba nti, “Laba ensi yange eri mu maaso go, beera w’oyagala.” ");
INSERT INTO lug_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","N’agamba ne Saala nti, “Laba mpadde mwannyoko ebitundu bya ffeeza lukumi, okukumalako ensonyi mu maaso gaabo bonna abali naawe.” ");
INSERT INTO lug_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Awo Ibulayimu n’asabira Abimereki eri Katonda, ne Katonda n’awonya Abimereki era n’awonya ne mukazi we; n’abaweereza be abakazi ne balyoka bazaala abaana. ");
INSERT INTO lug_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Kubanga Mukama yali aggalidde embuto z’ab’omu nnyumba y’Abimereki olwa Saala mukazi wa Ibulayimu. ");
INSERT INTO lug_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Awo Mukama n’akwatirwa Saala ekisa nga bwe yagamba Ibulayimu, era n’akolera Saala kye yasuubiza. ");
INSERT INTO lug_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saala n’aba olubuto, n’azaalira Ibulayimu omwana owoobulenzi mu bukadde bwe, mu kiseera Katonda kye yamugamba. ");
INSERT INTO lug_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibulayimu n’atuuma omwana owoobulenzi, eyamuzaalirwa Saala, erinnya Isaaka. ");
INSERT INTO lug_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ibulayimu n’akomola mutabani we Isaaka ow’ennaku omunaana ez’obukulu nga Katonda bwe yamulagira. ");
INSERT INTO lug_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ibulayimu yali aweza emyaka kikumi mutabani we Isaaka bwe yazaalibwa. ");
INSERT INTO lug_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saala n’agamba nti, “Katonda andeetedde okusekererwa, buli anaawulira anansekerera.” ");
INSERT INTO lug_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Era n’agamba nti, “Ani yandirowoozezza nti Saala alifuna omwana? Naye, laba mmuzaalidde omwana wabulenzi.” ");
INSERT INTO lug_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaaka n’akula, n’aggyibwa ku mabeere, Ibulayimu n’afumba embaga ennene ku lunaku Isaaka lwe yaggyibwa ku mabeere. ");
INSERT INTO lug_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Naye Saala yalaba nga mutabani wa Agali Omumisiri, gwe yazaalira Ibulayimu ng’azannya ne mutabani we Isaaka. ");
INSERT INTO lug_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","N’alyoka agamba Ibulayimu nti, “Goba omuweereza ono ne mutabani we, kubanga omwana w’omuweereza ono talisikira wamu na mwana wange Isaaka.” ");
INSERT INTO lug_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Naye ekyo Ibulayimu n’atakisiima. ");
INSERT INTO lug_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Katonda n’agamba Ibulayimu nti, “Tonakuwala olw’omulenzi n’olw’omuweereza wo omukazi, buli Saala ky’akugamba kikole; kubanga mu Isaaka mwe ndituukiririza ebyo byonna bye nakusuubiza. ");
INSERT INTO lug_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Era n’omwana w’omuweereza wo omukazi ndimufuula eggwanga, kubanga ava mu ggwe.” ");
INSERT INTO lug_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ibulayimu n’agolokoka ku makya ennyo, n’addira omugaati n’ensawo ey’amazzi n’abiwa Agali n’omwana gwe yazaala ng’abiteeka ku kibegabega kye, n’amusiibula. Agali n’agenda ng’atambulatambula mu ddungu lya Beeruseba. ");
INSERT INTO lug_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Awo amazzi ag’omu ddiba bwe gaggwaamu, Agali n’ateeka omwana we wansi w’ogumu ku miti. ");
INSERT INTO lug_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Agali ne yeeyongerayo ebbanga ng’awalasibwa akasaale, nga mita kikumi, n’atuula okumwolekera, kubanga yayogera nti, “Nneme okulaba omwana ng’afa.” Naye bwe yali ng’atudde, omwana n’ayimusa eddoboozi n’akaaba. ");
INSERT INTO lug_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Katonda n’awulira eddoboozi ly’omulenzi ng’akaaba, malayika wa Katonda n’ayita Agali ng’asinziira mu ggulu n’amugamba nti, “Kiki ekikuteganya? Totya, kubanga Katonda awulidde eddoboozi ly’omulenzi w’ali. ");
INSERT INTO lug_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Golokoka, situla omwana omunyweze mu mikono gyo, kubanga ndimufuula eggwanga eddene.” ");
INSERT INTO lug_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Awo Katonda n’azibula amaaso g’Agali, n’alaba oluzzi, n’agenda n’ajjuza ensawo ey’eddiba amazzi, n’anywesa omulenzi. ");
INSERT INTO lug_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Awo Katonda n’aba n’omulenzi n’akula n’abeera mu ddungu n’aba mwatiikirivu mu kulasa. ");
INSERT INTO lug_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Yabeeranga mu ddungu lya Palani: nnyina n’amufunira omukazi okuva mu nsi y’e Misiri. ");
INSERT INTO lug_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Mu kiseera ekyo Abimereki ng’ali ne Fikoli omukulu w’eggye lye n’agamba Ibulayimu nti, “Katonda ali naawe mu buli ky’okola: ");
INSERT INTO lug_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","kale kaakano ndayirira mu maaso ga Katonda nga tolinkuusakuusa, wadde okukuusakuusa omwana wange oba omwana w’omwana wange. Naye nga nze bwe nkukoze obulungi nga naawe bw’olinkola nze n’ensi mw’ozze.” ");
INSERT INTO lug_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ne Ibulayimu n’amuddamu nti, “Nkulayiridde.” ");
INSERT INTO lug_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Awo Ibulayimu ne yeemulugunya eri Abimereki olw’oluzzi lwe abaddu be lwe baamunyagako. ");
INSERT INTO lug_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimereki n’amugamba nti, “Simanyi n’omu eyakola ekintu ekyo, ggwe tewambulira era sikiwulirangako okutuusa ggwe lw’okintegeezeezza olwa leero.” ");
INSERT INTO lug_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Awo Ibulayimu n’addira endiga n’ente n’abiwa Abimereki, ne balagaana endagaano bombi. ");
INSERT INTO lug_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Awo Ibulayimu n’ayawulako endiga enduusi musanvu okuva mu kisibo kye. ");
INSERT INTO lug_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimereki n’abuuza Ibulayimu nti, “Endiga ezo omusanvu enduusi z’oyawuddeko amakulu gaazo ki?” ");
INSERT INTO lug_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","N’amuddamu nti, “Endiga ezo enduusi omusanvu onoozitwala okuva gye ndi kalyoke kabe obukakafu nti nze nasima oluzzi olwo.” ");
INSERT INTO lug_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ekifo ekyo kyekyava kiyitibwa Beeruseba, kubanga eyo bombi gye baalagaanira. ");
INSERT INTO lug_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Bwe baamala okukola endagaano e Beeruseba, Abimereki ne Fikoli omukulu w’eggye lye ne basitula ne baddayo mu nsi y’Abafirisuuti. ");
INSERT INTO lug_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibulayimu n’asimba omuti omumyulimu mu Beeruseba n’akaabiririra eyo erinnya lya Mukama, Katonda Ataggwaawo. ");
INSERT INTO lug_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ibulayimu ne yeeyongera okutambulatambula mu nsi y’Abafirisuuti okumala ennaku nnyingi. ");
INSERT INTO lug_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Awo oluvannyuma lw’ebyo, Katonda n’agezesa Ibulayimu, n’amuyita nti, “Ibulayimu!” N’addamu nti, “Nze nzuuno.” ");
INSERT INTO lug_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Katonda n’amugamba nti, “Twala mutabani wo, mutabani wo omu yekka, Isaaka, gw’oyagala, ogende mu nsi Moliya ku lumu ku nsozi lwe ndikulaga omuweereyo eyo okuba ekiweebwayo ekyokebwa.” ");
INSERT INTO lug_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ibulayimu n’agolokoka ku makya n’ateeka amatandiiko ku ndogoyi ye, n’atwala babiri ku baweereza be abasajja ne Isaaka mutabani we, n’ayasa enku ez’ekiweebwayo ekyokebwa, n’asituka n’agenda mu kifo Katonda kye yamugamba. ");
INSERT INTO lug_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ku lunaku olwokusatu Ibulayimu n’ayimusa amaaso ge n’alengera ekifo. ");
INSERT INTO lug_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Awo Ibulayimu n’agamba balenzi be nti, “Musigale wano n’endogoyi, nze n’omulenzi tugende eri tusinze, tulyoke tukomewo.” ");
INSERT INTO lug_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibulayimu n’addira enku ez’ekiweebwayo ekyokebwa n’azitikka Isaaka mutabani we, ye n’akwata omuliro n’akambe, ne bagenda bombi. ");
INSERT INTO lug_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaaka n’agamba Ibulayimu nti, “Taata.” Ibulayimu n’amuddamu nti, “Nzuuno mwana wange.” Isaaka n’amubuuza nti, “Laba, omuliro n’enku biibino, naye omwana gw’endiga ogw’ekiweebwayo ekyokebwa guluwa?” ");
INSERT INTO lug_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibulayimu n’amuddamu nti, “Mwana wange, Katonda aneefunira omwana gw’endiga ogw’ekiweebwayo ekyokebwa.” Kale ne bagenda bombi. ");
INSERT INTO lug_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Bwe baatuuka mu kifo Katonda kye yamugamba, Ibulayimu n’azimba ekyoto, n’atindikira enku, n’asiba omwana we Isaaka, n’amuteeka ku kyoto ku nku. ");
INSERT INTO lug_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Awo Ibulayimu n’akwata ekiso, n’agolola omukono gwe atte omwana we. ");
INSERT INTO lug_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Naye malayika wa Mukama n’amukoowoola ng’asinziira mu ggulu, n’agamba nti, “Ibulayimu! Ibulayimu!” Ibulayimu n’addamu nti, “Nze nzuuno.” N’amugamba nti, ");
INSERT INTO lug_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Togolola mukono gwo ku mulenzi so tomukola kintu na kimu, kubanga kaakano ntegedde nti otya Katonda, ndabye nti omwana wo tomunnyimye, omwana wo omu yekka bw’ati.” ");
INSERT INTO lug_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Awo Ibulayimu n’ayimusa amaaso, n’alaba, era laba, emabega we endiga ennume ng’eri mu kisaka ng’amayembe gaayo mwe galaalidde. Ibulayimu n’agenda n’addira endiga eyo n’agiwaayo okuba ekiweebwayo ekyokebwa, mu kifo ky’omwana we. ");
INSERT INTO lug_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ibulayimu kyeyava atuuma ekifo ekyo erinnya Mukama alitugabirira, era ne kaakano bwe kiyitibwa nti ku lusozi lwa Mukama anaagabiriranga. ");
INSERT INTO lug_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Awo malayika wa Mukama n’ayita Ibulayimu omulundi ogwokubiri ng’asinziira mu ggulu, ");
INSERT INTO lug_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","n’amugamba nti, “Nze Mukama neerayiridde, nga bw’okoze kino, n’otonnyima mwana wo omu yekka bw’ati, ");
INSERT INTO lug_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ddala ndikuwa omukisa, era ndyaza ezzadde lyo, ne liba ng’emmunyeenye ez’eggulu era ng’omusenyu oguli ku lubalama lw’ennyanja. Era ezzadde lyo balitwala eby’abalabe baabwe, ");
INSERT INTO lug_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","era mu zzadde lyo amawanga gonna mwe galiweerwa omukisa, kubanga ogondedde eddoboozi lyange.” ");
INSERT INTO lug_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ibulayimu n’alyoka addayo eri abavubuka be, ne basitula ne balaga e Beeruseba. ");
INSERT INTO lug_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Awo mu biro ebyo ne babuulira Ibulayimu nti, “Laba Mirika azaalidde Nakoli muganda wo abaana: Uzi ye mubereberye, ");
INSERT INTO lug_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ne muto we ye Buzi, ne Kemweri kitaawe wa Alamu, ");
INSERT INTO lug_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ne Kesedi, ne Kazo, ne Pirudaasi, ne Yidulaafu ne Besweri.” ");
INSERT INTO lug_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Era Besweri yazaala Lebbeeka. Abaana abo omunaana Mirika be yazaalira Nakoli muganda wa Ibulayimu. ");
INSERT INTO lug_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ate ne mukazi we omulala Lewuma n’azaalira Nakoli, abaana aboobulenzi era be bano: Teba, ne Gakamu, ne Takasi, ne Maaka. ");
INSERT INTO lug_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saala yawangaala emyaka kikumi mu abiri mu musanvu. ");
INSERT INTO lug_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","N’afiira e Kiriyasuwalaba, ye Kebbulooni, mu nsi ya Kanani. Saala bwe yafa Ibulayimu n’ayingira okumukungubagira n’amukaabira. ");
INSERT INTO lug_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Oluvannyuma Ibulayimu n’ava awali omulambo gwe n’agenda eri Abakiiti n’abagamba nti, ");
INSERT INTO lug_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ndi mugenyi era omutambuze mu mmwe, munfunire ekifo aw’okuziika, ndyoke nziikewo omuntu wange anve ku maaso.” ");
INSERT INTO lug_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Abakiiti ne baddamu Ibulayimu nti, ");
INSERT INTO lug_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Tuwulirize mukama waffe. Laba, oli muntu mukulu wakati mu ffe. Ziika mukazi wo mu emu ku ntaana zaffe gy’oneeroboza. Tewali n’omu mu ffe anaakuuma ntaana ye, oba okukuziyiza okuziika omuntu wo.” ");
INSERT INTO lug_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ibulayimu n’agolokoka n’avuunama eri Abakiiti, bannannyini nsi. ");
INSERT INTO lug_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","N’abagamba nti, “Obanga munzikirizza mu mwoyo mulungi okuziika omuntu wange, mumpulirize. Kale munneegayiririre Efulooni mutabani wa Zokali, ");
INSERT INTO lug_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","anguze empuku ey’e Makupeera, gy’alina, eri ku nkomerero y’ennimiro ye. Agingulize mu maaso gammwe, mmusasule omuwendo gwayo gwonna, efuuke ekifo kyange eky’okuziikangamu mu mmwe.” ");
INSERT INTO lug_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Mu kiseera ekyo Efulooni yali atudde awo wakati mu Bakiiti. Efulooni, Omukiiti n’addamu Ibulayimu nga Abakiiti bonna abaaliwo mu mulyango gw’ekibuga nga bawulira nti, ");
INSERT INTO lug_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Nedda mukama wange. Mpuliriza. Nkuwadde ennimiro n’empuku erimu, ng’abantu bange balaba, ziika omuntu wo.” ");
INSERT INTO lug_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Awo Ibulayimu n’avuunama mu maaso gaabwe bonna. ");
INSERT INTO lug_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","N’agamba Efulooni, bonna nga bawulira nti, “Obanga okkirizza, nkusaba nsasule omuwendo gw’ennimiro gwonna ndyoke nziikewo mukazi wange.” ");
INSERT INTO lug_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efulooni n’addamu Ibulayimu nti, ");
INSERT INTO lug_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mpuliriza mukama wange, ennimiro esaana ebitundu by’effeeza ebikumi bina. Kale ekyo ki eri ab’omukwano? Twala ennimiro oziikemu abafu bo.” ");
INSERT INTO lug_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ne bakkiriziganya, Ibulayimu kwe kusasula Efulooni ensimbi ze bakkirizaganya nga Abakiiti bonna balaba. ");
INSERT INTO lug_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Olwo ennimiro ya Efulooni mu Makupeera, eyali ku luuyi olw’ebuvanjuba olwa Mamule, ennimiro awamu n’empuku eyalimu, n’emiti gyonna egyali mu nnimiro ekitundu kyonna ne bifuuka bya ");
INSERT INTO lug_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ibulayimu nga Abakiiti bonna abaafuluma mu mulyango gw’ekibuga balaba. ");
INSERT INTO lug_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Oluvannyuma Ibulayimu n’aziika Saala mukazi we mu mpuku mu nnimiro ya Makupeera ku luuyi olw’ebuvanjuba bwa Mamule, ye Kebbulooni, mu nsi ya Kanani. ");
INSERT INTO lug_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Abakiiti ne bakwasa Ibulayimu ennimiro awamu n’empuku yaamu mu butongole okubeera obutaka bwe okuziikangamu abantu be. ");
INSERT INTO lug_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibulayimu yawangaala n’akaddiwa nnyo; era Mukama yamuwa emikisa mingi mu byonna. ");
INSERT INTO lug_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Awo Ibulayimu n’agamba omuddu asinga obukulu mu nnyumba ye, eyali afuga byonna Ibulayimu bye yalina nti, “Teeka omukono gwo wansi w’ekisambi kyange ");
INSERT INTO lug_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ndyoke nkulayize mu maaso ga Mukama Katonda w’eggulu era Katonda w’ensi, nga toliwasiza mutabani wange mukazi kuva mu bawala ba nsi ya Bakanani, mwe mbeera, ");
INSERT INTO lug_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","wabula ng’oligenda mu nsi yange mu bantu bange n’owasiza mutabani wange Isaaka omukazi.” ");
INSERT INTO lug_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Omuddu kwe ku mubuuza nti, “Omukazi bw’ataliyagala kujja nange mu nsi eno, ndizzaayo mutabani wo mu nsi mwe wava?” ");
INSERT INTO lug_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibulayimu n’addamu nti, “Togezanga n’ozzaayo mutabani wange. ");
INSERT INTO lug_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mukama, Katonda w’eggulu, eyanzigya mu nnyumba ya kitange, mu nsi mwe nazaalibwa eyayogera nange era n’andayirira nti, ‘Ezadde lyo ndiriwa ensi eno,’ alituma malayika we n’akukulembera owasirize mutabani wange omukazi era omuggyeyo. ");
INSERT INTO lug_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Naye omukazi bw’aligaana okujja naawe, olwo ekirayiro kino kiriba tekikyakusiba. Kyokka togezanga n’ozzaayo omwana wange.” ");
INSERT INTO lug_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Awo omuddu kwe kuteeka omukono gwe wansi w’ekisambi kya mukama we Ibulayimu. ");
INSERT INTO lug_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Awo omuddu n’atwala ku ŋŋamira za mukama we n’agenda ng’atutte buli ngeri ya kirabo okuva ku bya mukama we. N’ayimuka n’agenda e Mesopotamiya mu kibuga kya Nakoli. ");
INSERT INTO lug_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Obudde bwe bwawungeera n’atuuka ebweru w’ekibuga n’afukamiza awo eŋŋamira okumpi n’oluzzi obudde nga buwungedde abakazi we bagendera okukima amazzi. ");
INSERT INTO lug_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","N’asaba nti, “Ayi Mukama Katonda wa mukama wange Ibulayimu mpa obuwanguzi leero nkwegayiridde, olage mukama wange Ibulayimu okwagala kwo okutaggwaawo. ");
INSERT INTO lug_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Laba nnyimiridde okumpi n’oluzzi, ne bawala b’abantu ab’omu kibuga bajja okusena amazzi. ");
INSERT INTO lug_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kale omuwala gwe nnaagamba nti, ‘Nkwegayiridde mpa ku mazzi ag’omu nsuwa yo nnyweko,’ n’amala agamba nti, ‘Kale nnywa, era n’eŋŋamira zo nnaazinywesa,’ oyo y’aba abeera gw’olonze okuba mukazi w’omuddu wo Isaaka. Ku kino kwe nnaategeerera nti olaze mukama wange ekisa kyo ekitaggwaawo.” ");
INSERT INTO lug_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Laba, bwe yali nga tannamaliriza kusaba, Lebbeeka muwala wa Besweri mutabani wa Mirika muka Nakoli, muganda wa Ibulayimu, n’ajja ng’atadde ensuwa ye ey’amazzi ku kibegabega kye. ");
INSERT INTO lug_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Omuwala oyo yali mulungi okulabako nga muwala mbeerera, n’akka mu luzzi n’ajjuza ensuwa ye n’avaayo. ");
INSERT INTO lug_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Awo omuddu n’ayanguwa n’amusisinkana, n’amugamba nti, “Nkusaba ompe ku tuzzi ku nsuwa yo.” ");
INSERT INTO lug_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","N’amuddamu nti, “Nywako mukama wange.” Amangwago n’assa ensuwa mu mikono gye, n’agikwata mu mukono gwe n’amuwa amazzi. ");
INSERT INTO lug_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Bwe yamala okumuwa amazzi, n’amugamba nti, “N’eŋŋamira zo nazo nnaazisenera amazzi okutuusa lwe zinaamala okunywa.” ");
INSERT INTO lug_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Bw’atyo n’ayanguwa n’ayiwa ensuwa ye ey’amazzi n’agimalira mu kyesero, n’adduka n’asena amalala agaali gamala eŋŋamira ze zonna, ");
INSERT INTO lug_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","omusajja ng’asirise ng’amwekaliriza amaaso okumanya obanga Mukama awadde olugendo lwe omukisa oba nedda. ");
INSERT INTO lug_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Eŋŋamira bwe zaamala okunywa, omusajja n’addira empeta ya zaabu ey’oku matu erimu gulaamu ttaano n’obutundu musanvu n’ebikomo ebya zaabu bibiri eby’oku mikono bya gulamu kikumi mu kkumi na ttaano n’abiwa omuwala abyenaanike. ");
INSERT INTO lug_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","N’amubuuza nti, “Oli muwala w’ani? Mu nnyumba ya kitaawo mulimu ekisenge mwe tuyinza okusuzibwa?” ");
INSERT INTO lug_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","N’amuddamu nti, “Ndi muwala wa Besweri, mutabani wa Mirika gwe yazaalira Nakoli.” ");
INSERT INTO lug_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","N’ayongerako nti, “Tulina omuddo omukalu n’emmere endala ebimala, era n’ekisenge eky’okusulamu tukirina.” ");
INSERT INTO lug_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Awo omusajja n’akutamya omutwe gwe n’asinza Mukama. ");
INSERT INTO lug_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","N’agamba nti, “Yeebazibwe Mukama Katonda wa mukama wange Ibulayimu atalese kisa kye ekitaggwaawo n’obwesigwa bwe eri mukama wange. Era nze ku lwange Mukama ankulembedde mu kkubo n’antuusa mu nnyumba ya booluganda lwa mukama wange.” ");
INSERT INTO lug_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Awo omuwala n’adduka n’ategeeza ab’ennyumba ya nnyina ebintu ebyo byonna. ");
INSERT INTO lug_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Lebbeeka yalina mwannyina, Labbaani, eyayanguwa okulaga ku luzzi eri omusajja, ");
INSERT INTO lug_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Labbaani bwe yalaba empeta n’ebikomo ku mikono gya mwannyina, era bwe yawulira ebigambo bya mwannyina ng’omusajja bw’amugambye, n’agenda eri omusajja. Laba omusajja yali ng’ayimiridde awali eŋŋamira ku luzzi. ");
INSERT INTO lug_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labbaani n’amugamba nti, “Jjangu gwe aweereddwa Mukama omukisa. Lwaki obeera eno? Ntegesse ennyumba era n’ekifo ky’eŋŋamira.” ");
INSERT INTO lug_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Awo, omusajja n’alaga ku nnyumba, n’asumulula eŋŋamira, ne baziwa essubi n’ebyokulya ne bamuleetera n’amazzi ye n’abasajja be yali nabo banaabe ebigere. ");
INSERT INTO lug_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Oluvannyuma ne bamuleetera emmere alye. Kyokka ye n’agamba nti, “Sijja kulya nga sinnayogera kindeese.” Labbaani n’amugamba nti, “Yogera.” ");
INSERT INTO lug_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Awo n’agamba nti, “Ndi muddu wa Ibulayimu. ");
INSERT INTO lug_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mukama yawa mukama wange emikisa mingi, era afuuse mukulu, amuwadde ebisibo by’endiga n’amagana g’ente, ne ffeeza ne zaabu, abaweereza abasajja n’abaweereza abakazi era n’eŋŋamira awamu n’endogoyi. ");
INSERT INTO lug_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Era Saala muka mukama wange bwe yali ng’akaddiye yamuzaalira omwana owoobulenzi, era mukama wange awadde oyo byonna by’alina. ");
INSERT INTO lug_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mukama wange yandayiza n’aŋŋamba nti, ‘Towasizanga mutabani wange mukazi ava mu Bakanani ba nnyini nsi mwe mbeera. ");
INSERT INTO lug_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Wabula oligenda mu nnyumba ya kitange, mu bantu bange, n’owasiza mutabani wange omukazi okuva omwo.’ ");
INSERT INTO lug_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Ne mbuuza mukama wange nti, ‘Omukazi bw’atalikkiriza kujja nange?’ ");
INSERT INTO lug_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Ye n’anziramu nti, ‘Mukama oyo gwe ntambulira mu maaso ge alikutumira malayika we mu lugendo lwo era alikuwa omukisa, n’owasiza mutabani wange omukazi okuva mu bantu bange, era mu nnyumba ya kitange. ");
INSERT INTO lug_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Naye ekirayiro kyange tekirikubaako bw’olituuka mu bantu bange ne batamukuwa, nga ggwe toliiko musango.’ ");
INSERT INTO lug_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Leero bwe ntuuse ku luzzi, ne ŋŋamba nti, ‘Ayi Mukama, Katonda wa mukama wange Ibulayimu, obanga onoowa omukisa olugendo luno lwe ndiko, ");
INSERT INTO lug_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","laba, nnyimiridde awali oluzzi, kale omuwala anajja okusena amazzi, ne mugamba nti, “Nkusaba ku tuzzi mu nsuwa yo nyweko,” ");
INSERT INTO lug_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","n’anziramu nti, “Nnywa, era n’eŋŋamira zo nazo nzija kuzisenera,” oyo y’aba abeera omukazi Mukama gw’alondedde mutabani wa mukama wange.’ ");
INSERT INTO lug_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Laba, bwe nabadde nga nkyayogera mu mutima gwange, Lebbeeka n’avaayo n’ensuwa ye ng’eri ku kibegabega kye, n’aserengeta ku luzzi n’asena amazzi. Ne mugamba nti, ‘Nkusaba ompe nyweko.’ ");
INSERT INTO lug_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Nassa mangu ensuwa ye okuva ku kibegabega kye, n’agamba nti, ‘Nnywa, era nnaanywesa n’eŋŋamira zo.’ ");
INSERT INTO lug_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Kwe ku mubuuza nti, ‘Oli muwala w’ani?’ N’anziramu nti, ‘Ndi muwala wa Besweri, mutabani wa Nakoli, Mirika gwe yamuzaalira.’ Ne nteeka empeta ku nnyindo ye n’ebikomo ku mikono gye. ");
INSERT INTO lug_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Awo ne nkutamya omutwe gwange ne nsinza Mukama ne muwa ekitiibwa, Katonda wa mukama wange Ibulayimu eyankulembera nannuŋŋamya mu lugendo lwange okuwasiriza mutabani wa mukama wange omukazi okuva mu bantu ba mukama wange. ");
INSERT INTO lug_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kale kaakano obanga mu mazima munaakolera mukama wange ebyekisa, mumbuulire, era obanga si bwe kityo mumbuulire; ndyoke mmanye eky’okukola.” ");
INSERT INTO lug_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Awo Labbaani ne Besweri ne baddamu nti, “Kino kivudde wa Mukama, tetuyinza kukuddamu kino oba kiri. ");
INSERT INTO lug_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Laba, Lebbeeka wuuyo, mutwale, agende abeere muka mutabani wa mukama wo, nga Mukama bw’alagidde.” ");
INSERT INTO lug_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Omuddu wa Ibulayimu bwe yawulira ebigambo byabwe n’avuunama wansi mu maaso ga Mukama. ");
INSERT INTO lug_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","N’aggyayo eby’obugagga ebya ffeeza ne zaabu, n’ebyambalo n’abiwa Lebbeeka, era n’awa mwannyina ne nnyina ebirabo eby’omuwendo omungi. ");
INSERT INTO lug_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Awo ye n’abasajja be yali nabo ne balyoka balya era ne banywa; ne basulayo ekiro ekyo. Bwe baagolokoka enkya n’agamba nti, “Ka nzireyo eri mukama wange.” ");
INSERT INTO lug_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mwannyina ne nnyina ne bamuddamu nti, “Leka omuwala abeereko naffe akaseera, wakiri ennaku kkumi, olwo mulyoke mugende.” ");
INSERT INTO lug_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ye n’abaddamu nti, “Temundwisa, kubanga Mukama awadde olugendo lwange omukisa.” ");
INSERT INTO lug_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ne bagamba nti, “Ka tuyite omuwala tumubuuze.” ");
INSERT INTO lug_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ne bayita Lebbeeka, ne bamubuuza nti, “Onoogenda n’omusajja ono?” N’addamu nti, “Nnaagenda.” ");
INSERT INTO lug_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Awo ne basiibula Lebbeeka mwannyinaabwe, n’omuweereza we omuwala, n’omuweereza wa Ibulayimu omusajja awamu n’abasajja be. ");
INSERT INTO lug_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ne basabira Lebbeeka omukisa ne bamugamba nti, “Mwannyinaffe beera nnyina w’enkumi n’enkumi, abaana n’abazzukulu bo balyenga ebibuga by’abalabe baabwe.” ");
INSERT INTO lug_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Awo Lebbeeka n’abaweereza be ne basituka ne beebagala eŋŋamira ne bagenda n’omuweereza wa Ibulayimu omusajja, bw’atyo omuddu n’atwala Lebbeeka ne bagenda. ");
INSERT INTO lug_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Olwo Isaaka yali ng’avudde e Beerirakayiroyi ng’ali mu Negevu. ");
INSERT INTO lug_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Awo bwe yali ng’atambula nga bw’afumiitiriza mu nnimiro akawungeezi, n’ayimusa amaaso ge n’alengera eŋŋamira nga zijja. ");
INSERT INTO lug_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ne Lebbeeka n’ayimusa amaaso ge. Bwe yalengera Isaaka n’ava ku ŋŋamira, ");
INSERT INTO lug_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","n’abuuza omuddu nti, “Ani oyo gwe nnengera mu nnimiro ajja okutusisinkana?” Omuddu n’addamu nti, “Ye mukama wange.” Lebbeeka kwe kutoola omunagiro gwe ne yeebikkirira. ");
INSERT INTO lug_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Awo omuddu n’ategeeza Isaaka byonna nga bwe byagenda. ");
INSERT INTO lug_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Awo Isaaka n’atwala Lebbeeka n’amuyingiza mu weema eyali eya Saala nnyina, n’afuuka mukazi we n’amwagala. Isaaka n’alyoka afuna essanyu kasookedde afiirwa nnyina. ");
INSERT INTO lug_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibulayimu n’awasa omukazi omulala erinnya lye Ketula. ");
INSERT INTO lug_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Yamuzaalira Zimulaani, ne Yokusaani, ne Medani, ne Midiyaani, ne Isubaki ne Suwa. ");
INSERT INTO lug_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokusaani n’azaala Seeba ne Dedani. Dedani n’azaala Asulimu, ne Letusimu ne Leumimu. ");
INSERT INTO lug_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Batabani ba Midiyaani baali Efa, ne Eferi, ne Kanoki, ne Abida ne Eruda. Abo bonna be baana n’abazzukulu ba Ketula. ");
INSERT INTO lug_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibulayimu yawa Isaaka byonna bye yalina. ");
INSERT INTO lug_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Naye bo abaana b’abaweereza be n’abawa birabo, n’abasiibula bwe yali ng’akyali mulamu bagende ebuvanjuba mu nsi ey’ebuvanjuba; baviire mutabani we Isaaka. ");
INSERT INTO lug_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ibulayimu yawangaala emyaka kikumi mu nsanvu mu etaano. ");
INSERT INTO lug_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ibulayimu yafa ng’akaddiyidde ddala, nga musajja awangaalidde ddala obulungi. ");
INSERT INTO lug_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Batabani be Isaaka ne Isimayiri ne bamuziika mu mpuku ey’e Makupeera, mu nnimiro ya Efulooni, mutabani wa Zokali Omukiiti, ebuvanjuba bwa Mamule; ");
INSERT INTO lug_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ennimiro Ibulayimu gye yagula ku Bakiiti. Omwo Ibulayimu mwe yaziikibwa awali Saala mukazi we. ");
INSERT INTO lug_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ibulayimu bwe yafa, Katonda n’awa mutabani we Isaaka omukisa, Isaaka n’abeera e Beerirakayiroyi. ");
INSERT INTO lug_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Bino bye bifa ku b’olulyo lwa Isimayiri mutabani wa Ibulayimu eyazaalibwa Agali Omumisiri, omuweereza wa Saala omuwala. ");
INSERT INTO lug_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Gano ge mannya gaabwe nga bwe baddiŋŋanwako: Nebayoosi, omubereberye wa Isimayiri, ne Kedali, ne Adubeeri, ne Mibusamu, ");
INSERT INTO lug_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ne Misuma, ne Duma, ne Massa, ");
INSERT INTO lug_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ne Kadadi, ne Teema, ne Yetuli, ne Nafisi ne Kedema. ");
INSERT INTO lug_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Abo be batabani ba Isimayiri, era ago ge mannya gaabwe, mu byalo ne mu bibuga byabwe mwe baabeeranga, abafuzi kkumi na babiri buli omu n’eggwanga lye. ");
INSERT INTO lug_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isimayiri yafa ng’awezezza emyaka kikumi mu asatu mu musanvu n’atwalibwa mu babe. ");
INSERT INTO lug_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Abantu be baatuula okuviira ddala mu Kavira ne batuuka ku Ssuuli okuliraana Misiri ku luuyi olwa Bwasuli. Ennaku zaabwe zonna baawalananga baganda baabwe. ");
INSERT INTO lug_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Bino bye bifa ku b’olulyo lwa Isaaka, mutabani wa Ibulayimu. Ibulayimu yazaala Isaaka. ");
INSERT INTO lug_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaaka yalina emyaka amakumi ana, we yawasiza muwala wa Besweri Omusuuli ow’e Padanalaamu, eyayitibwanga Lebbeeka mwannyina wa Labbaani. ");
INSERT INTO lug_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaaka n’asaba Mukama ku lwa mukazi we Lebbeeka kubanga yali mugumba, Mukama n’awulira okusaba kwe, Lebbeeka naaba olubuto. ");
INSERT INTO lug_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Abaana bombi ne bagulumbira mu lubuto lwe, Lebbeeka n’agamba nti, “Obanga kiri bwe kityo, lwaki mba omulamu?” Awo n’agenda ne yeebuuza ku Mukama. ");
INSERT INTO lug_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mukama n’amuddamu nti, “Mu lubuto lwo mulimu amawanga abiri, abantu ababiri b’olizaala balibeera ba njawulo, omu alibeera w’amaanyi okusinga munne, era omukulu yaaliweereza omuto.” ");
INSERT INTO lug_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ennaku ez’okuzaala bwe zaatuuka, laba, n’azaala abalongo nga babulenzi. ");
INSERT INTO lug_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Eyasooka bwe yavaayo nga mumyufu, omubiri gwe gwonna nga gufaanana ng’ekyambalo eky’ebyoya. Kyebaava bamutuuma Esawu. ");
INSERT INTO lug_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Oluvannyuma ne muganda we n’azaalibwa, omukono gwe nga gukutte ekisinziiro kya Esawu; kyebaava bamuyita Yakobo. Isaaka yalina emyaka nkaaga Lebbeeka we yazaalira abaana abo. ");
INSERT INTO lug_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Abalenzi ne bakula, Esawu n’aba muyizzi lukulwe, omuntu ow’oku ttale. Naye ye Yakobo yali musajja musirise ng’asigala waka. ");
INSERT INTO lug_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaaka n’ayagala Esawu kubanga yalyanga ku muyiggo gwe, naye Lebbeeka ye n’ayagala Yakobo. ");
INSERT INTO lug_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lumu Yakobo yali afumba enva, Esawu n’ajja ng’ava ku ttale; enjala ng’emuluma nnyo. ");
INSERT INTO lug_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esawu n’agamba Yakobo nti, “Mpa mpute ku nva ezo, kubanga enjala ejula kunzita.” Kyeyava ayitibwa Edomu. ");
INSERT INTO lug_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobo n’amuddamu nti, “Sooka onguze obukulu bwo.” ");
INSERT INTO lug_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esawu n’agamba nti, “Laba Ndikumpi n’okufa, obukulu bungasa ki?” ");
INSERT INTO lug_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobo n’addamu nti, “Sooka ondayirire.” Awo Esawu n’amulayirira, olwo n’aguza Yakobo obukulu bwe. ");
INSERT INTO lug_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yakobo n’alyoka awa Esawu emmere n’enva, n’alya n’anywa, n’agolokoka n’agenda. Bw’atyo Esawu n’anyooma obukulu bwe. ");
INSERT INTO lug_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ne wabaawo enjala mu nsi, eteri eri eyabaawo mu biseera bya Ibulayimu. Isaaka n’agenda mu Gerali, ewa Abimereki kabaka w’Abafirisuuti. ");
INSERT INTO lug_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ne Mukama n’amulabikira, n’amugamba nti, “Toserengeta Misiri, beera mu nsi gye ndikulaga. ");
INSERT INTO lug_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Beera mu nsi gye ndikulaga, nnaabeeranga naawe, n’akuwanga omukisa kubanga gwe n’abaana bo ndibawa ensi zino zonna, era ndituukiriza ekirayiro kye nalayirira kitaawo Ibulayimu. ");
INSERT INTO lug_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ndyaza abaana b’enda yo ne baba ng’emmunyeenye ez’eggulu, era ndibawa n’ensi zino zonna. Era mu bo amawanga gonna ag’oku nsi mwe galiweerwa omukisa; ");
INSERT INTO lug_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","kubanga Ibulayimu yagondera eddoboozi lyange, n’akwata bye namukuutira, n’ebiragiro byange, n’ebigambo byange awamu n’amateeka gange.” ");
INSERT INTO lug_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Bw’atyo Isaaka n’abeera mu Gerali, ");
INSERT INTO lug_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","abasajja ab’omu nsi omwo bwe baamubuuza ku mukazi we n’abaddamu nti, “Mwannyinaze.” Kubanga yatya okwogera nti, “Mukazi wange,” ng’alowooza nti, “Abasajja ab’omu nsi omwo tebalwa kunzita lwa Lebbeeka,” kubanga yali mulungi nnyo. ");
INSERT INTO lug_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Bwe yamalayo ekiseera ekiwanvu, Abimereki, kabaka w’Abafirisuuti n’atunula mu ddirisa, n’alaba Isaaka ng’azannya ne Lebbeeka mukazi we. ");
INSERT INTO lug_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimereki kwe kuyita Isaaka n’amugamba nti, “Ddala, mukazi wo, lwaki wagamba nti, ‘Mwannyinaze’?” Isaaka n’amuddamu nti, “Kubanga nalowooza nti, ‘Nnyinza okufiirwa obulamu bwange ku lulwe.’ ” ");
INSERT INTO lug_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimereki n’amugamba nti, “Kale kiki kino ky’otukoze? Omu ku basajja yandiyinzizza okusobya ku mukazi wo, wandituleeseeko omusango.” ");
INSERT INTO lug_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Awo Abimereki n’alyoka alagira abantu bonna ng’agamba nti, “Buli alikwata ku musajja ono oba ku mukyala we waakuttibwa.” ");
INSERT INTO lug_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaaka n’asigala mu nsi omwo, n’afuna amakungula emirundi kikumi ag’ebyo bye yasiga, kubanga Mukama yamuwa omukisa. ");
INSERT INTO lug_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","N’afuuka mugagga, obugagga bwe ne bweyongera n’agaggawala nnyo. ");
INSERT INTO lug_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Yalina ebisibo by’endiga bingi nnyo n’amagana g’ente, era n’abaweereza nfaafa; Abafirisuuti ne bamukwatirwa obuggya. ");
INSERT INTO lug_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kyebaava bajjuza enzizi zonna abaddu ba kitaawe ze baasima mu biro bya kitaawe Ibulayimu, ne baziziba. ");
INSERT INTO lug_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ne Abimereki n’agamba Isaaka nti, “Ggenda, tuveemu kubanga otuyitiridde amaanyi.” ");
INSERT INTO lug_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Awo Isaaka n’avaayo n’azimba mu kiwonvu eky’e Gerali, n’abeera omwo. ");
INSERT INTO lug_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaaka n’azibukula enzizi ezaali zisimiddwa mu biseera bya Ibulayimu kitaawe, kubanga Abafirisuuti baziziba Ibulayimu bwe yamala okufa. Era ye Isaaka n’aziyita amannya gali kitaawe ge yali azituumye. ");
INSERT INTO lug_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Naye abaddu ba Isaaka bwe basima mu kiwonvu ne bazuula oluzzi olw’ensulo, ");
INSERT INTO lug_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","abasumba b’omu Gerali ne bayomba n’abasumba ba Isaaka nga bagamba nti, “Amazzi gaffe.” Oluzzi olwo kyeyava alutuuma Eseki, kubanga baawakana naye. ");
INSERT INTO lug_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kyebaava basima oluzzi olulala, era nalwo ne baluyombera, lwo kwe kuluyita Situna. ");
INSERT INTO lug_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Awo n’avaayo n’asima oluzzi olulala, olwo lwo ne bataluyombera, kyeyava alutuuma Lekobosi, ng’agamba nti, “Kubanga kaakano Mukama atuwadde ebbanga, era tujja kukulaakulanira muno.” ");
INSERT INTO lug_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Bwe yava eyo n’agenda e Beeruseba. ");
INSERT INTO lug_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ekiro ekyo Mukama n’alabikira Isaaka, n’amugamba nti, “Nze Katonda wa Ibulayimu kitaawo, totya. Kubanga ndiwamu naawe, ndikuwa omukisa era ndyaza abaana bo ku lwa Ibulayimu omuddu wange.” ");
INSERT INTO lug_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Awo n’azimbawo ekyoto n’akoowoola erinnya lya Mukama, n’asimba eyo eweema ye. Era n’eyo abaddu be ne basimayo oluzzi. ");
INSERT INTO lug_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Mu kiseera kye kimu Abimereki n’ava mu Gerali ng’ali ne Akuzasa gwe yeebuuzangako amagezi ne Fikoli omukulu w’eggye lye, n’agenda eri Isaaka. ");
INSERT INTO lug_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaaka n’ababuuza nti, “Lwaki muzze gye ndi ng’ate mwankijjanya ne mungobaganya?” ");
INSERT INTO lug_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ne bamuddamu nti, “Tulabidde ddala nga Mukama ali naawe, kyetuva tugamba nti, ‘Wabeewo ekirayiro wakati wo naffe. Era tukole endagaano naawe, ");
INSERT INTO lug_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","nga tolitukola kabi, nga ffe bwe tutaakakukola era nga tetuliiko kye tukukoze, wabula ebirungi era nga twakusiibula mirembe.’ Kaakano gwe oli muntu Mukama gw’awadde omukisa.” ");
INSERT INTO lug_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Awo Isaaka n’abakolera ekijjulo ne balya ne banywa. ");
INSERT INTO lug_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ku makya ennyo ne bagolokoka ne balayiriragana, Isaaka n’abawerekerako ne bava gy’ali mirembe. ");
INSERT INTO lug_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ku lunaku olwo lwennyini, abaddu ba Isaaka ne bajja ne bamutegeeza eby’oluzzi lwe baasima, ne bamugamba nti, “Tuzudde amazzi.” ");
INSERT INTO lug_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","N’alutuuma Siba; erinnya ly’ekibuga kyeriva liba Beeruseba na buli kati. ");
INSERT INTO lug_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esawu bwe yaweza emyaka amakumi ana egy’obukulu, n’awasa Yudisi muwala wa Beeri Omukiiti, ne Besimansi muwala wa Eroni naye Omukiiti. ");
INSERT INTO lug_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ne bakaluubiriza nnyo Isaaka ne Lebbeeka obulamu. ");
INSERT INTO lug_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Awo Isaaka bwe yali ng’akaddiye nnyo n’amaaso ge nga gayimbadde, nga takyayinza kulaba, n’ayita Esawu mutabani we omukulu, n’amugamba nti, “Mutabani,” n’amuddamu nti, “Nze nzuuno.” ");
INSERT INTO lug_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaaka n’amugamba nti, “Laba, nkaddiye, simanyi lwe ndifa. ");
INSERT INTO lug_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kale kaakano kwata by’oyizza, omutego gwo n’obusaale bwo, ogende mu nsiko onjiggire yo omuyiggo. ");
INSERT INTO lug_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Onteekereteekere ekyokulya ekiwooma ennyo kye njagala, okindeetere nkirye, ndyoke nkusabire omukisa nga sinnafa.” ");
INSERT INTO lug_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ne Lebbeeka yali awo ng’awuliriza, Isaaka ng’agamba mutabani we omukulu Esawu. Awo Esawu bwe yagenda mu nsiko okuyigga omuyiggo aguleete, ");
INSERT INTO lug_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Lebbeeka n’agamba mutabani we Yakobo owookubiri nti, “Mpulidde kitaawo ng’agamba muganda wo Esawu nti, ");
INSERT INTO lug_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ndeetera omuyiggo onteekereteekere ekyokulya ekiwooma obulungi, nkirye, ndyoke nkusabire omukisa eri Mukama nga sinnafa.’ ");
INSERT INTO lug_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kale nno kaakano mwana wange wulira kye nkugamba. ");
INSERT INTO lug_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Genda eri ekisibo ondeeteremu embuzi bbiri ennungi, nfumbire kitaawo ekyokulya ekiwooma, nga bw’ayagala, ");
INSERT INTO lug_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","okitwalire kitaawo akirye, alyoke akusabire omukisa nga tannafa.” ");
INSERT INTO lug_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Naye Yakobo n’agamba Lebbeeka nnyina nti, “Muganda wange Esawu musajja wa byoya, so nga nze ndi muweweevu. ");
INSERT INTO lug_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Singa kitange anampeeweetako, siifuuke mulimba gy’ali, ne nfuna ekikolimo mu kifo ky’okufuna omukisa?” ");
INSERT INTO lug_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nnyina n’amuddamu nti, “Ekikolimo kyo kibe ku nze mwana wange; wulira ekigambo kyange ogende ozindeetere.” ");
INSERT INTO lug_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Awo Yakobo n’agenda, n’azikwata n’azireeteera nnyina, n’ateekerateekera Isaaka ekyokulya ekiwooma nga bwe yayagala. ");
INSERT INTO lug_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Lebbeeka n’addira ebyambalo ebisinga obulungi ebya Esawu, mutabani we omukulu, ebyali mu nnyumba; n’abyambaza Yakobo mutabani we omuto, ");
INSERT INTO lug_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","era n’addira n’amaliba g’embuzi n’agamwambaza ku mikono ne ku bitundu ebyobulago ebiweweera. ");
INSERT INTO lug_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","N’alyoka addira ekyokulya ekiwooma n’omugaati bye yafumba, n’abikwasa Yakobo mutabani we. ");
INSERT INTO lug_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Awo Yakobo n’agenda eri kitaawe, n’amugamba nti, “Kitange nzuuno.” Ye n’amuddamu nti, “Ggwe ani mwana wange?” ");
INSERT INTO lug_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo n’agamba kitaawe nti, “Nze Esawu omwana wo omubereberye, nkoze nga bw’oŋŋambye. Kale kaakano tuula olye ku muyiggo gwange olyoke onsabire omukisa.” ");
INSERT INTO lug_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Naye Isaaka n’abuuza mutabani we nti, “Ogufunye otya amangu bw’otyo?” N’amuddamu nti, “Mukama Katonda wo ampadde omukisa.” ");
INSERT INTO lug_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Awo Isaaka n’agamba mutabani we nti, “Sembera wendi mutabani, nkukwateko, ntegeerere ddala nga ggwe mutabani wange Esawu.” ");
INSERT INTO lug_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobo kwe kusembera awali Isaaka kitaawe. Bwe yamuwulira n’agamba nti, “Eddoboozi lya Yakobo naye emikono gya Esawu.” ");
INSERT INTO lug_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","N’atamutegeera kubanga emikono gye gyaliko obwoya ng’egya Esawu muganda we, kwe kumuwa omukisa. ");
INSERT INTO lug_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isaaka n’amubuuza nti, “Ddala gwe mwana wange Esawu?” N’amuddamu nti, “Ye nze.” ");
INSERT INTO lug_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","N’alyoka amugamba nti, “Kale gundeetere, ndye ku muyiggo gwa mutabani wange, nkusabire omukisa.” N’alyoka agumuleetera, n’alya era n’amuleetera n’envinnyo n’anywa. ");
INSERT INTO lug_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Awo kitaawe Isaaka n’amugamba nti, “Sembera onnywegere mwana wange.” ");
INSERT INTO lug_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","N’amusemberera n’amunywegera, kitaawe n’awulira akaloosa ke ngoye ze n’amuwa omukisa ng’agamba nti, “Wulira akaloosa k’omwana wange, kali ng’akaloosa k’ennimiro Mukama gy’awadde omukisa. ");
INSERT INTO lug_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Katonda akuwe omusulo ogw’omu ggulu, n’obugimu bw’ensi, era akuwe emmere ey’empeke nnyingi n’envinnyo. ");
INSERT INTO lug_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Abantu bakuweerezenga, n’amawanga gakuvuunamirenga. Fuganga baganda bo, ne batabani ba nnyoko bakuvuunamirenga. Akolimirwe oyo anaakukolimiranga era aweebwenga omukisa oyo anaakusabiranga omukisa.” ");
INSERT INTO lug_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Amangu ddala nga Isaaka yakamala okuwa Yakobo omukisa, era nga Yakobo tannava wali Isaaka kitaabwe, Esawu n’atuuka ng’ava okuyigga. ");
INSERT INTO lug_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Era naye n’ateekateeka emmere ey’akawoowo n’agireetera kitaawe. N’agamba kitaawe nti, “Kitange golokoka olye ku muyiggo gw’omwana wo olyoke onsabire omukisa.” ");
INSERT INTO lug_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Kitaawe Isaaka n’amubuuza nti, “Gwe ani?” Kwe kumuddamu nti, “Nze omwana wo omubereberye Esawu.” ");
INSERT INTO lug_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Olwo Isaaka n’akankana nnyo n’abuuza nti, “Ani oyo ayizze omuyiggo n’agundeetera ne ngulya ne ngumalawo nga tonnajja ne mmusabira omukisa? Era ddala ajja kuweebwa omukisa.” ");
INSERT INTO lug_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Awo Esawu bwe yawulira ebigambo bya kitaawe ebyo, n’atulika n’akaaba nnyo nnyini, n’agamba kitaawe nti, “Nange mpa omukisa, ayi kitange.” ");
INSERT INTO lug_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Naye n’amuddamu nti, “Muganda wo azze n’annimba era akututteko omukisa gwo.” ");
INSERT INTO lug_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esawu n’ayogera nti, “Teyatuumibwa linnya lye Yakobo? Laba, anyingiridde emirundi gino gyombi; yanziggyako eby’obukulu bwange, ate kaakano antutteko n’omukisa gwange.” Kwe kubuuza kitaawe nti, “Tondekeddeewo mukisa n’akatono?” ");
INSERT INTO lug_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaaka n’addamu Esawu nti, “Laba, mmufudde mukama wo, era mmuwadde baganda be bonna babe baweereza be, era mmusabidde abe n’emmere ey’empeke wamu n’envinnyo nga bingi ddala. Kale nnaakukolera ki mwana wange?” ");
INSERT INTO lug_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esawu n’abuuza kitaawe nti, “Tolinaawo mukisa na gumu kitange? Nange mpa omukisa, ayi kitange.” Bw’atyo Esawu n’ayimusa eddoboozi lye n’akaaba. ");
INSERT INTO lug_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Awo Isaaka kitaawe n’amuddamu nti, “Laba, onooberanga mu nsi enkalu, era toofunenga musulo guva waggulu mu ggulu. ");
INSERT INTO lug_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ekitala kyo kye kinaakukuumanga, era onooweerezanga muganda wo. Naye bw’olimwesimattulako, oliba weefunidde eddembe.” ");
INSERT INTO lug_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Awo Esawu n’akyawa muganda we Yakobo ng’amulanga omukisa kitaabwe gwe yamuwa. Esawu n’alyoka ayogera nti, “Ennaku ez’okukungubagira kitange zinaatera okutuuka. Bwe zirituuka, muganda wange Yakobo nga mutta.” ");
INSERT INTO lug_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Kyokka Lebbeeka n’atuusibwako ebigambo bya Esawu mutabani we omukulu; kwe kutumya Yakobo mutabani we omuto, n’amugamba nti, “Laba, Esawu muganda wo ateekateeka okukutta. ");
INSERT INTO lug_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kale nno kaakano mwana wange, okole nga bwe nkugamba: Golokoka oddukire ewa, mwannyinaze Labbaani ali mu Kalani, ");
INSERT INTO lug_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","obeereko eyo, okutuusa obusungu bwa muganda wo nga bukkakkanye. ");
INSERT INTO lug_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Obusungu bwe buliba bumuweddeko, nga yeerabidde ky’omukoze, ne ndyoka ntuma ne bakunona. Kale lwaki mbafiirwa mwembi ku lunaku olumu?” ");
INSERT INTO lug_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Lebbeeka n’alyoka ategeeza Isaaka nti, “Obulamu bwange bwetamiddwa olw’abakazi bano Abakiiti. Singa Yakobo awasa omu ku bakazi Abakiiti, nga bano, omu ku bakazi aba muno, obulamu bwange buliba tebukyangasa.” ");
INSERT INTO lug_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Awo Isaaka n’ayita Yakobo n’amuwa omukisa, n’amukuutira nti, “Towasanga, wadde omu ku bakazi Abakanani. ");
INSERT INTO lug_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Golokoka ogende e Padanalaamu mu nnyumba ya Besweri kitaawe wa nnyoko, ofune omukazi omu ku bawala ba Labbaani mwannyina nnyoko. ");
INSERT INTO lug_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Katonda Ayinzabyonna akuwe omukisa, akwaze, weeyongere, era obeerenga n’abantu ab’enjawulo bangi. ");
INSERT INTO lug_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Akuwe emikisa gya Ibulayimu, era agiwe n’ezzadde lyo, olyoke ofune ensi mw’otambulira, Katonda gye yawa Ibulayimu.” ");
INSERT INTO lug_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Bw’atyo Isaaka n’asiibula Yakobo, Yakobo n’agenda e Padanalaamu ewa Labbaani, mutabani wa Besweri Omusuuli mwannyina Lebbeeka, nnyina wa Esawu ne Yakobo. ");
INSERT INTO lug_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esawu n’ategeera nga Isaaka awadde Yakobo omukisa, era ng’amusindise e Padanalaamu afuneyo omukazi, era nga bwe yamuwa omukisa yamukuutira nti, “Towasanga ku bakazi Abakanani,” ");
INSERT INTO lug_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","era nga Yakobo agondedde kitaawe ne nnyina n’agenda e Padanalaamu. ");
INSERT INTO lug_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Awo n’ategeera nti abakazi Abakanani tebaasanyusa kitaawe Isaaka. ");
INSERT INTO lug_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Esawu n’agenda eri Isimayiri n’awasa omukazi erinnya lye Makalasi, muwala wa Isimayiri, mutabani wa Ibulayimu, mwannyina wa Nebayoosi, n’amwongera ku bakazi be yalina. ");
INSERT INTO lug_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Awo Yakobo n’ava e Beeruseba n’ayolekera Kalani. N’atuuka mu kifo ekimu, n’asula awo ekiro ekyo, kubanga obudde bwali buzibye. ");
INSERT INTO lug_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","N’addira erimu ku mayinja agaali mu kifo ekyo, n’alyezizika ne yeebaka. ");
INSERT INTO lug_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","N’aloota ng’alaba eddaala eggwanvu nga liva ku nsi okutuuka mu ggulu, era nga bamalayika ba Katonda balikkirako era nga balinnyirako, ");
INSERT INTO lug_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","era nga Mukama atudde waggulu waalyo. Mukama n’agamba Yakobo nti, “Nze Mukama Katonda wa Ibulayimu jjajjaawo, era Katonda wa Isaaka; ensi kw’ogalamidde ndigikuwa ggwe n’ezzadde lyo. ");
INSERT INTO lug_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Era ezzadde lyo liriba ng’enfuufu y’oku nsi, era olibuna obugwanjuba n’obuvanjuba era n’obukiikakkono n’obukiikaddyo. Mu ggwe ne mu zadde lyo amawanga gonna ag’oku nsi mwe galiweerwa omukisa. ");
INSERT INTO lug_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Laba ndi wamu naawe, era nnaakukuumanga buli gy’onoogendanga yonna, era ndikukomyawo mu nsi eno, kubanga sirikuleka okutuusa nga mmaze okukola ekyo kye nkugambye.” ");
INSERT INTO lug_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Awo Yakobo n’ava mu tulo n’agamba nti, “Mazima ddala Mukama ali mu kifo kino, nze mbadde ssimanyi.” ");
INSERT INTO lug_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","N’atya nnyo, n’agamba nti, “Ekifo kino nga kyantiisa! Ekifo kino ye nnyumba ya Katonda, era guno gwe mulyango gw’eggulu.” ");
INSERT INTO lug_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Awo Yakobo n’agolokoka ku makya, n’addira ejjinja lye yali yeezizise n’alisimba okuba empagi n’ayiwa amafuta ku mutwe gwalyo. ");
INSERT INTO lug_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ekifo ekyo n’akituuma Beseri, songa ekibuga ekyo kyayitibwanga Luzi. ");
INSERT INTO lug_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Awo Yakobo ne yeerayirira ng’agamba nti, “Katonda bw’alibeera nange, n’ankuuma mu lugendo luno lwe ndiko, n’ampa emmere okulya era n’ebyokwambala ne nkomawo mirembe mu nnyumba ya kitange, ");
INSERT INTO lug_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","olwo Mukama n’aba Katonda wange. ");
INSERT INTO lug_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Era ejjinja lino lye nsimbye okuba empagi liriba nnyumba ya Katonda, era n’ebyo byonna by’ompa ndikuwaako ekimu eky’ekkumi.” ");
INSERT INTO lug_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Awo Yakobo ne yeeyongerayo mu lugendo lwe, n’atuuka mu nsi y’abantu b’ebuvanjuba. ");
INSERT INTO lug_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Bwe yatunula n’alaba oluzzi mu nnimiro, ng’ebisibo bisatu eby’endiga zigalamidde awo ku lwo, kubanga awo we zaanywesezebwanga. Ejjinja eryasaanikiranga ku mumwa gw’oluzzi olwo lyali ddene, ");
INSERT INTO lug_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","era ebisibo bwe byakuŋŋaananga, abasumba ne balyoka baliyiringisa okuliggya ku mumwa gw’oluzzi ne banywesa endiga; bwe zaamalanga ne balizzaako. ");
INSERT INTO lug_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Awo Yakobo n’abuuza abasumba nti, “Abooluganda muva wa?” Ne bamuddamu nti, “Tuva Kalani.” ");
INSERT INTO lug_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kwe kubabuuza nti, “Labbaani mutabani wa Nakoli mumumanyi?” Ne bamuddamu nti, “Tumumanyi.” ");
INSERT INTO lug_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","N’abuuza nti, “Ali bulungi?” Ne baddamu nti, “Ali bulungi, era laba Laakeeri muwala we wuuli ajja n’endiga!” ");
INSERT INTO lug_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","N’abagamba nti, “Mulabe, obudde bukyali bwa ttuntu, ekiseera tekinnatuuka okukuŋŋaanya ensolo awamu, muzinywese mulyoke mugende muzirunde.” ");
INSERT INTO lug_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Bo kwe kumuddamu nti, “Ekyo tetusobola kukikola ng’ebisibo byonna tebinnakuŋŋaanyizibwa, nga n’ejjinja terinaggyibwa ku mumwa gw’oluzzi, olwo ne tunywesa endiga.” ");
INSERT INTO lug_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakobo bwe yali akyayogera nabo, Laakeeri n’atuuka n’endiga za kitaawe. Kubanga ye yali azirunda. ");
INSERT INTO lug_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobo bwe yalaba Laakeeri, muwala wa Labbaani, mwannyina nnyina, n’endiga za Labbaani, n’agenda n’ayiringisa ejjinja okuva ku mumwa gw’oluzzi n’anywesa endiga za Labbaani. ");
INSERT INTO lug_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakobo n’alyoka agwa Laakeeri mu kifuba, n’ayimusa eddoboozi n’akaaba. ");
INSERT INTO lug_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakobo n’alyoka ategeeza Laakeeri nti, waluganda ne kitaawe, era ye mutabani wa Lebbeeka. Laakeeri kwe kudduka n’ategeeza kitaawe. ");
INSERT INTO lug_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Awo Labbaani bwe yawulira ebya Yakobo, mutabani wa mwannyina, n’adduka okumusisinkana, n’amugwa mu kifuba n’amulamusa bulungi, n’amutwala mu nnyumba ye. Yakobo n’ategeeza Labbaani byonna ebyaliwo. ");
INSERT INTO lug_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labbaani n’agamba nti, “Mazima oli ggumba lyange, era nnyama ya mubiri gwange! N’abeera naye omwezi mulamba.” ");
INSERT INTO lug_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Awo Labbaani n’agamba Yakobo nti, “Olw’okubanga oli waluganda ky’onoova ompeerereza obwereere? Ntegeeza empeera yo bw’eneebanga.” ");
INSERT INTO lug_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labbaani yalina bawala be babiri; erinnya ly’omukulu nga ye Leeya ne ly’omuto nga ye Laakeeri. ");
INSERT INTO lug_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leeya yali manafu, kyokka ye Laakeeri nga mulungi era nga w’amaanyi. ");
INSERT INTO lug_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo yayagala Laakeeri, era n’agamba Labbaani nti, “Nzija kukuweereza emyaka musanvu olwa muwala wo omuto Laakeeri.” ");
INSERT INTO lug_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labbaani kwe kumuddamu nti, “Kituufu okumuwa ggwe ne ssimuwa musajja mulala yenna. Beera nange.” ");
INSERT INTO lug_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Bw’atyo Yakobo n’akolerera Laakeeri emyaka musanvu, naye ne giba ng’ennaku obunaku gy’ali kubanga yamwagala nnyo. ");
INSERT INTO lug_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Awo Yakobo n’agamba Labbaani nti, “Kale mpa mukazi wange, mmutwale, kubanga ekiseera kye twalagaana nkimazeeko.” ");
INSERT INTO lug_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Labbaani kwe kukuŋŋaanya abantu b’ekifo ekyo, n’akola embaga. ");
INSERT INTO lug_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Naye mu kiro Labbaani n’atwala muwala we Leeya n’amuwa Yakobo okumutwala okuba mukazi we. ");
INSERT INTO lug_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labbaani yali awadde Leeya Zirupa amuweerezenga. ");
INSERT INTO lug_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Bwe bwakya, Yakobo n’alaba nga bamuwadde Leeya. Kwe kugamba Labbaani nti, “Onkoze ki kino? Saakuweereza lwa Laakeeri? Kale lwaki onimbye?” ");
INSERT INTO lug_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labbaani n’amuddamu nti, “Mu nsi yaffe tekiri mu buwangwa bwaffe, omuto okusooka omukulu okufumbirwa. ");
INSERT INTO lug_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Sooka omale n’ono wiiki eno emu, n’oli tugenda kumukuwa; kyokka olimukolerera okumala emyaka emirala musanvu.” ");
INSERT INTO lug_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ekyo Yakobo n’akikkiriza, n’amalako wiiki emu eyo, Labbaani n’alyoka amuwa Laakeeri muwala we okuba mukazi we. ");
INSERT INTO lug_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labbaani n’awa Laakeeri Biira amuweerezenga. ");
INSERT INTO lug_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakobo n’atwala Laakeeri n’aba mukazi we; n’ayagala Laakeeri okusinga Leeya, n’aweereza Labbaani emyaka egyo emirala omusanvu. ");
INSERT INTO lug_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mukama bwe yalaba nga Leeya akyayibbwa n’aggula olubuto lwe. Laakeeri ye yali mugumba. ");
INSERT INTO lug_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leeya n’aba olubuto, n’azaala omwana wabulenzi. N’amutuuma erinnya Lewubeeni, ng’agamba nti, “Kubanga Mukama alabye okubonyaabonyezebwa kwange: ddala baze ananjagala.” ");
INSERT INTO lug_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","N’aba olubuto olulala, n’azaala omwana mulenzi, n’agamba nti, “Kubanga Mukama alabye nga ndi mukyawe, kyavudde ampa omwana owoobulenzi omulala; n’amutuuma erinnya Simyoni.” ");
INSERT INTO lug_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ate n’aba olubuto n’azaala omwana mulenzi, n’agamba nti, “Kale kaakano baze ajja kuba bumu nange, kubanga mmuzaalidde abaana abalenzi basatu.” Omwana kyeyava atuumwa Leevi. ");
INSERT INTO lug_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Era Leeya n’aba olubuto n’azaala omwana wabulenzi, n’agamba nti, “Ku luno nzija kutendereza Mukama,” kyeyava amutuuma Yuda; n’alekayo okuzaala. ");
INSERT INTO lug_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Laakeeri bwe yalaba nga tazaalidde Yakobo baana, n’akwatirwa muganda we obuggya; n’agamba Yakobo nti, “Mpa abaana oba si ekyo nzija kufa!” ");
INSERT INTO lug_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Obusungu bwa Yakobo ne bubuubuukira Laakeeri, n’amugamba nti, “Nze Katonda akummye okuzaala?” ");
INSERT INTO lug_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Laakeeri kwe kumwanukula nti, “Omuweereza wange Biira wuuno, weetabe naye azaalire ku maviivi gange, ndyoke nfune abaana nga mpita mu ye.” ");
INSERT INTO lug_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","N’alyoka amuwa omuweereza we Biira okuba mukazi we, Yakobo ne yeetaba naye. ");
INSERT INTO lug_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biira n’aba olubuto n’azaalira Yakobo omwana owoobulenzi. ");
INSERT INTO lug_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Awo Laakeeri n’agamba nti, “Katonda ankoze bulungi, n’awulira eddoboozi lyange, n’ampa omwana owoobulenzi.” Kyeyava amutuuma Ddaani. ");
INSERT INTO lug_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biira omuweereza omukazi owa Laakeeri n’aba olubuto ate, n’azaalira Yakobo omwana owoobulenzi owookubiri. ");
INSERT INTO lug_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Laakeeri n’alyoka agamba nti, “Nnwanye ne muganda wange okulwana okw’amaanyi era mpangudde;” omwana kyeyava amutuuma Nafutaali. ");
INSERT INTO lug_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Awo Leeya bwe yalaba akomye okuzaala, n’addira omuweereza we Zirupa n’amuwa Yakobo abe mukazi we. ");
INSERT INTO lug_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zirupa omuweereza wa Leeya n’alyoka azaalira Yakobo omwana owoobulenzi; ");
INSERT INTO lug_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leeya n’agamba nti, “Guno mukisa gwennyini!” Kwe kumutuuma Gaadi. ");
INSERT INTO lug_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ate Zirupa omuweereza wa Leeya n’azaalira Yakobo omwana owoobulenzi owookubiri. ");
INSERT INTO lug_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leeya n’agamba nti, “Neesiimye! Kubanga abakazi banampita wa mukisa;” kyeyava amutuuma Aseri. ");
INSERT INTO lug_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Lumu mu biseera eby’amakungula g’eŋŋaano Lewubeeni n’agenda mu nnimiro, n’anoga amadudayimu, n’agaleetera nnyina Leeya. Laakeeri n’agamba Leeya nti, “Nkusaba ompe ku madudayimu g’omwana wo.” ");
INSERT INTO lug_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Kyokka ye n’amuddamu nti, “Okiyita kitono ggwe okunnyagako baze? Ate otwale n’amadudayimu g’omwana wange?” Laakeeri n’amugamba nti, “Kale anaaba naawe ekiro kino olw’amadudayimu g’omwana wo.” ");
INSERT INTO lug_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yakobo bwe yakomawo okuva mu nnimiro akawungeezi, Leeya n’afuluma okumusisinkana, n’amugamba nti, “Weetabe nange, kubanga nkuguze n’amadudayimu g’omwana wange.” Kwe kwetaba naye. ");
INSERT INTO lug_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Katonda n’awulira Leeya, n’aba olubuto, n’azaalira Yakobo omwana owoobulenzi owookutaano. ");
INSERT INTO lug_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leeya n’agamba nti, “Katonda ansasudde empeera yange, kubanga nawa baze, omuweereza wange,” omwana kyeyava amutuuma Isakaali. ");
INSERT INTO lug_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leeya n’aba olubuto ate, n’azaalira Yakobo Omwana owoobulenzi ow’omukaaga. ");
INSERT INTO lug_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leeya kwe kugamba nti, “Katonda ampadde ekirabo, kaakano baze anaabanga nange, kubanga muzaalidde abaana aboobulenzi mukaaga.” Ow’omukaaga kyeyava amutuuma Zebbulooni. ");
INSERT INTO lug_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Oluvannyuma n’azaala omwana owoobuwala, n’amutuuma Dina. ");
INSERT INTO lug_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ate Katonda n’ajjukira Laakeeri, n’amuwulira n’aggula olubuto lwe. ");
INSERT INTO lug_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","N’aba olubuto n’azaalira Yakobo omwana owoobulenzi, Laakeeri n’agamba nti, “Katonda anziggyeeko okunyoomebwa;” ");
INSERT INTO lug_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","n’amutuuma Yusufu, ng’agamba nti, “Mukama annyongere omwana omulenzi.” ");
INSERT INTO lug_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Laakeeri bwe yazaala Yusufu, Yakobo n’agamba Labbaani nti, “Nsiibula, ŋŋende ewaffe mu nsi yaffe. ");
INSERT INTO lug_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mpa bakazi bange n’abaana bange, be nkuweererezza, ondeke ŋŋende: kubanga omanyi okuweereza kwe nkuweerezza.” ");
INSERT INTO lug_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labbaani kwe kumuddamu nti, “Nga bwe nfunye omukisa mu ggwe, nkusaba oleme kuva wano, kubanga ndabye nga Mukama yampa omukisa ku bubwo. ");
INSERT INTO lug_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ntegeeza empeera yo nange ngikuwe.” ");
INSERT INTO lug_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobo n’amuddamu nti, “Ggwe kennyini omanyi nti nkuweerezza era n’ensolo zo nga nzaazizza. ");
INSERT INTO lug_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kubanga walina ntono nga sinnajja, naye zeeyongedde nnyo; era Mukama n’akuwa omukisa buli gye n’addanga. Naye kaakano nze ndikolera ddi ennyumba yange?” ");
INSERT INTO lug_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labbaani kwe ku mubuuza nti, “Nkuwe ki?” Yakobo n’amuddamu nti, “Tojja kubaako ky’ompa, okuggyako okunkolera kino, ndyoke nneeyongere okulunda ekisibo kyo: ");
INSERT INTO lug_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","nzikiriza mpite mu kisibo kyo leero, nziggyemu buli ndiga enkulu eza bugondo n’eza bitanga, n’endiga ento enzirugavu, n’embuzi eza bugondogondo n’ezabitanga mu mbuzi, era ezo ze zinaabeera empeera yange. ");
INSERT INTO lug_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Kale oluvannyuma lwa byonna obutuukirivu bwange bulimpolereza bw’olijja okukebera bw’onsasudde. Bw’olisanga embuzi yonna etali ya bugondogondo n’eya bitanga, oba endiga yonna enkazi enzirugavu eyo eribalibwa nti nnagikubbako.” ");
INSERT INTO lug_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labbaani n’amuddamu nti, “Ekyo kirungi. Kale kibeere bwe kityo nga bw’ogambye.” ");
INSERT INTO lug_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Naye ekiro ekyo Labbaani n’aggya mu kisibo embuzi ennume eza biwuuga n’eza bitanga, n’embuzi enkazi zonna eza bugondogondo n’eza bitanga, buli eyalina ebbala eryeru, na buli ndiga nzirugavu n’aziwa abaana be bazirunde; ");
INSERT INTO lug_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","nga beesudde ebbanga eritambulirwa ennaku ssatu okuva ku ye okutuuka ku Yakobo. Yakobo ye n’alunda ezo ezaasigalawo ku kisibo kya Labbaani. ");
INSERT INTO lug_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Awo Yakobo n’addira obuti bw’omulibine omubisi, n’obw’omusakedi, n’obw’omwalamoni n’abususumbulako ebikuta mu bukuubo. ");
INSERT INTO lug_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","N’asimba obuti bw’asasambudde mu maaso g’ebisibo ku by’esero ensolo we zanyweranga. ");
INSERT INTO lug_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Bwe zajjanga okunywa ne ziwakiranga mu maaso g’obuti obwo, ne zizaalanga eza biwuuga, n’eza bugondogondo n’eza bitanga. ");
INSERT INTO lug_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobo n’ayawula ento ne zibeera zokka. Naye endala n’azitunuza okwolekera eza biwuuga n’enzirugavu eza Labbaani. Bw’atyo ne yeekolera ebisibo eby’enjawulo, n’atagatta zize na za Labbaani. ");
INSERT INTO lug_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Buli nsolo enkazi ez’amaanyi bwe zaabanga zigenda okuwaka nga Yakobo ateeka ku by’esero obuti bwe buli okwolekera ensolo ezigenda okuwaka, ziwakire okumpi nabwo. ");
INSERT INTO lug_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Naye ku nsolo ennafu teyabutekangawo. Olwo ensolo ennafu ne zibanga za Labbaani, zo ez’amaanyi ne zibanga za Yakobo. ");
INSERT INTO lug_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mu ngeri eyo Yakobo n’agenda ng’agaggawalira ddala nnyo, n’afuna ebisibo bingi ddala, wamu n’abaweereza abakazi n’abasajja; era n’afuna n’eŋŋamira n’embalaasi. ");
INSERT INTO lug_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Awo Yakobo n’awulira nga batabani ba Labbaani bagamba nti, “Yakobo atutte ebyo byonna ebyali ebya kitaffe, era mu byali ebya kitaffe mw’aggye obugagga buno bwonna.” ");
INSERT INTO lug_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Era Yakobo n’alaba nga Labbaani takyamufaako nga bwe yali olubereberye. ");
INSERT INTO lug_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Awo Mukama n’agamba Yakobo nti, “Ddayo mu nsi ya bajjajjaabo, mu bantu bo, era nnaabeeranga naawe.” ");
INSERT INTO lug_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Awo Yakobo kwe kutumya Laakeeri ne Leeya ku ttale gye baalundiranga ekisibo. ");
INSERT INTO lug_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Bwe baatuuka n’abagamba nti, “Ndaba nga kitammwe takyanfaako nga bwe yakolanga olubereberye, naye Katonda wa kitange abadde nange. ");
INSERT INTO lug_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mumanyi bwe naweerea kitammwe n’amaanyi gange gonna. ");
INSERT INTO lug_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Kyokka ye kitammwe yandyazaamanya n’akyusa empeera yange n’agikendeeza emirundi kkumi; wabula Katonda n’atamukkiriza kundeetako kabi. ");
INSERT INTO lug_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kale bwe yagambanga nti, ‘Eza bugondogondo ze zinaabanga ezizo ekisibo kyonna ne kizaala eza bugondogondo, era bwe yayogeranga nti eza biwuuga ze zinaabanga ezizo ekisibo kyonna ne kizaala eza biwuuga.’ ");
INSERT INTO lug_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Bw’atyo Katonda aggye ku kitammwe ensolo ze n’azimpa. ");
INSERT INTO lug_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Mu kiseera ensolo mwe ziwakira, naloota nga nnyimusa amaaso gange nga ndaba embuzi ennume nga zirinyira enkazi eza biwuuga n’eza bugondogondo n’eza kiweewoweewo. ");
INSERT INTO lug_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ne mu kirooto ekyo malayika wa Katonda n’ampita nti, ‘Yakobo.’ Ne nziramu nti, ‘Nze nzuuno.’ ");
INSERT INTO lug_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","N’aŋŋamba nti, ‘Yimusa amaaso go olabe, embuzi zonna ezirinnyira ekisibo bwe ziri eza biwuuga, eza bugondogondo n’eza kiweewoweewo; kubanga ndabye ebyo byonna Labbaani by’akukoze. ");
INSERT INTO lug_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nze Katonda w’e Beseri gye wafukira amafuta ku jjinja lye wasimba, gye weeyamira obweyamo. Kale kaakano golokoka ove mu nsi muno, oddeyo mu nsi gye wazaalirwa.’ ” ");
INSERT INTO lug_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Awo Laakeeri ne Leeya ne bamuddamu nti, “Ekyo kituufu kubanga tetulina mugabo, mu busika bwa kitaffe. ");
INSERT INTO lug_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Era atutwala ng’abatali ba mu nnyumba ye. Kubanga yatutunda, era ebyatuvaamu bya badde akozesa. ");
INSERT INTO lug_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Eby’obugagga byonna Katonda bya muggyeko, bifuuse byaffe n’abaana baffe. Kale kaakano buli Katonda ky’akugambye okukola kikole.” ");
INSERT INTO lug_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Awo Yakobo n’agolokoka, n’ateeka batabani be ne bakazi be ku ŋŋamira; ");
INSERT INTO lug_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","n’agoba ente ze zonna, n’ebisolo bye ebirala byonna bye yafuna: obugagga bwe bwonna bwe yafunira mu Padanalaamu, agende mu nsi ya Kanani eri kitaawe Isaaka. ");
INSERT INTO lug_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labbaani yali agenze kusala byoya ku ndiga ze, Laakeeri n’abba bakatonda b’omu nnyumba ya Labbaani. ");
INSERT INTO lug_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakobo n’adduka ku Labbaani Omusuuli, era teyamutegeeza nti amuvaako agende. ");
INSERT INTO lug_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yadduka ne byonna bye yalina, n’agolokoka n’asomoka omugga Fulaati, n’ayolekera Giriyaadi ensi ey’ensozi. ");
INSERT INTO lug_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ku lunaku olwokusatu Labbaani bwe yategeezebwa nti Yakobo yamuddukako, ");
INSERT INTO lug_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Labbaani n’atwala basajja be, n’awondera Yakobo okumala ennaku musanvu, mu Giriyaadi ensi ey’ensozi. ");
INSERT INTO lug_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Naye Katonda n’ajjira Labbaani, Omusuuli, mu kirooto, ekiro, n’amugamba nti, “Weegendereze, toyogera na Yakobo kigambo kyonna, ekirungi oba ekibi.” ");
INSERT INTO lug_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Awo Labbaani n’atuuka ku Yakobo, eyali akubye eweema ye mu nsi ey’ensozi, Labbaani ne basajja be nabo ne basiisira mu nsi ey’ensozi eya Giriyaadi. ");
INSERT INTO lug_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labbaani n’agamba Yakobo nti, “Okoze ki, okuntwalako bawala bange mu kyama ne babanga abanyage? ");
INSERT INTO lug_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Kiki ekyakuddusa mu kyama nga tombuuliddeko, ndyoke, nkusibule mu kinyumu: n’ennyimba, n’ebitaasa, n’ennanga. ");
INSERT INTO lug_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kale lwaki tewaŋŋanya na kugwa mu kifuba bazzukulu bange ne bawala bange okubasiibula? Ekyo kye wakola si kya buntubulamu. ");
INSERT INTO lug_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mbadde nsobola okukukola akabi, wabula Katonda wa kitaawo yayogedde nange ekiro kino, n’aŋŋamba nti, ‘Weegendereze oleme okwogera ne Yakobo ekigambo kyonna, ekirungi oba ekibi.’ ");
INSERT INTO lug_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ne kaakano ogenda kubanga wayagala nnyo okuddayo mu nnyumba ya kitaawo; naye wabbira ki bakatonda bange?” ");
INSERT INTO lug_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobo n’addamu Labbaani nti, “Natya, kubanga n’alowooza nti oyinza okunnyagako bawala bo. ");
INSERT INTO lug_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Naye gw’onoosanga ne bakatonda bo taabe mulamu; waakufa. Mu maaso ga bantu baffe bano, ndaga ekikyo kye nnina okitwale.” Yakobo teyamanya nti Laakeeri abbye bakatonda ba Labbaani. ");
INSERT INTO lug_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labbaani n’ayingira mu weema ya Yakobo ne mu weema ya Leeya, ne mu weema ey’abaweereza bombi; naye n’atalaba bakatonda be. N’ava mu weema ya Leeya, n’ayingira mu ya Laakeeri. ");
INSERT INTO lug_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Laakeeri yali atutte bakatonda ba Labbaani, n’abateeka ku matandiiko g’eŋŋamira, n’abatuulako. Labbaani n’ayaza weema yonna naye n’atabalabamu. ");
INSERT INTO lug_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Laakeeri n’agamba kitaawe nti, “Mukama wange aleme okusunguwala kubanga sisobola kuyimirira w’oli kubanga ndi mu mpisa y’abakazi.” Labbaani n’anoonya naye n’atalaba bakatonda be. ");
INSERT INTO lug_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Awo Yakobo n’alyoka ajjula obusungu ne yeejuumulira Labbaani, n’amugamba nti, “Nzizizza musango ki? Kibi ki kye nnina, olyoke ongoberere n’obukaali butyo? ");
INSERT INTO lug_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Bw’oyazizza mu bintu byange, kikyo ki ky’osanzemu? Kiteeke wano wakati mu maaso g’abantu bange n’ababo, balyoke basalewo omusobya ku fembi. ");
INSERT INTO lug_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Emyaka gino gyonna amakumi abiri gye mbadde naawe, endiga zo ne mbuzi zo tezisowolanga, era siryanga ndiga mu kisibo kyo. ");
INSERT INTO lug_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Eyo eyataagulwanga ensolo enkambwe ey’omu nsiko saagikuleeteranga, nze nafiirwanga, waginsabanga, wadde eyo eyabbibwanga ekiro oba emisana nayo yabalirwanga ku nze. ");
INSERT INTO lug_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ekyo ne kindeetera essana okunzigwerangako, n’okubeeranga mu mpewo ekiro, n’otulo ne tumbula. ");
INSERT INTO lug_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Emyaka gino amakumi abiri mbadde mu nnyumba yo; n’akuweereza emyaka kkumi n’ena olwa bawala bo bombi, ate ne nkuweereza emyaka mukaaga mu kisibo kyo, kyokka okyusizza empeera yange emirundi kkumi. ");
INSERT INTO lug_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Singa Katonda wa kitange, era Katonda wa Ibulayimu, Katonda Entiisa ya Isaaka teyali ku lwange, mazima ddala wandinsiibudde ngalo nsa! Katonda yalabye okubonaabona n’okutegana kwange, kyeyavudde akunenya ekiro.” ");
INSERT INTO lug_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Awo Labbaani n’addamu Yakobo nti, “Bano bawala bange, n’abaana baabwe bazzukulu bange, n’ebisibo, bisibo byange era ne byonna byolaba byange. Naye bawala bange n’abaana baabwe be bazadde, nnyinza kubakolera ki leero? ");
INSERT INTO lug_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kale jjangu tukole endagaano gwe nange, ebeere omujulirwa wakati wo nange.” ");
INSERT INTO lug_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Awo Yakobo n’addira ejjinja n’alisimba ng’empagi. ");
INSERT INTO lug_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","N’agamba abantu be nti, “Mukuŋŋaanye amayinja.” Ne bagakuŋŋaanya ne bagatuuma entuumo, ne baliira awo awali entuumo. ");
INSERT INTO lug_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labbaani entuumu n’agiyita Yegalusakadusa, ye Yakobo n’agiyita Galeedi. ");
INSERT INTO lug_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labbaani n’agamba nti, “Entuumo eno ye mujulirwa wakati wo nange leero.” Kyeyava agiyita Galeedi, ");
INSERT INTO lug_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","n’empagi n’agiyita Mizupa, kubanga yayogera nti, “Mukama atunulenga wakati wo nange, nga twawukanye omu okuva ku munne. ");
INSERT INTO lug_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Bw’oliyisa obubi bawala bange, oba bw’olibawasizaako abakazi abalala, newaakubadde nga tewali muntu n’omu wakati waffe, ojjukire nti Katonda ye mujulirwa wakati wo nange.” ");
INSERT INTO lug_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Awo Labbaani n’agamba Yakobo nti, “Laba entuumu eno n’empagi bye ntadde wakati wo nange. ");
INSERT INTO lug_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Entuumu eno ye mujulirwa era n’empagi nayo mujulirwa nga nze sirisukka ntuumu eno na mpagi eno okukukola akabi. ");
INSERT INTO lug_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Katonda wa Ibulayimu, era Katonda wa Nakoli, Katonda wa kitaabwe atulamule.” Yakobo naye n’alayirira bw’atyo Katonda, Entiisa ya kitaawe Isaaka. ");
INSERT INTO lug_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakobo n’awaayo ssaddaaka ku lusozi; n’ayita abantu be okulya; ne balya, ne basula ku lusozi ekiro ekyo. ");
INSERT INTO lug_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ku makya ennyo Labbaani n’agolokoka n’asiibula bazzukulu be ne bawala be ng’abagwa mu kifuba; n’abawa omukisa, n’addayo ewuwe. ");
INSERT INTO lug_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Awo Yakobo n’akwata ekkubo lye, bamalayika ba Katonda ne bamusisinkana. ");
INSERT INTO lug_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakobo bwe yabalaba n’agamba nti, “Lino ggye lya Katonda.” Ekifo ekyo n’alyoka akituuma Makanayimu. ");
INSERT INTO lug_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Awo Yakobo n’atuma ababaka eri Esawu muganda we, mu kitundu kya Seyiri mu nsi ya Edomu. ");
INSERT INTO lug_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","N’abagamba nti, “Mugambe mukama wange Esawu nti, ‘Omuddu wo Yakobo abadde ne Labbaani okutuusa kaakano, ");
INSERT INTO lug_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","alina ente, n’endogoyi, n’endiga era n’embuzi, abaweereza abakazi era n’abasajja. Kaakano aweerezza mukama we Esawu obubaka buno afune okusaasirwa mu maaso ge.’ ” ");
INSERT INTO lug_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ababaka bwe baakomawo eri Yakobo ne bamugamba nti, “Twatuuka ewa muganda wo Esawu era ajja okukusisinkana ng’alina abasajja ebikumi bina.” ");
INSERT INTO lug_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Olwo Yakobo n’atandika okutiira ddala, n’asoberwa. N’ayawulamu abantu be yali nabo, n’ayawulamu n’endiga, ebisibo bye yalina ne mu ŋŋamira, ebibinja bibiri, ");
INSERT INTO lug_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ng’alowooza nti, “Esawu bw’anaatuuka ku kibinja ekisooka n’akizikiriza, kale ekibinja ekisigaddewo kinadduka.” ");
INSERT INTO lug_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Awo Yakobo n’agamba nti, “Ayi Katonda wa jjajjange Ibulayimu, era Katonda wa kitange Isaaka, Ayi Mukama eyaŋŋamba nti, ‘Ddayo mu nsi yammwe, mu bantu bo, nange nnaakugaggawazanga,’ ");
INSERT INTO lug_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","sisaanira wadde akatundu akatono ak’okwagala kwo okutaggwaawo, wadde obwesigwa bwonna bw’olaze omuddu wo. Kubanga nasomoka omugga guno Yoludaani nga nnina muggobuggo; naye kaakano nfuuse ebibinja bibiri. ");
INSERT INTO lug_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nkusaba omponye mu mukono gwa muganda wange, Esawu, kubanga mmutya, talwa kujja n’atutta ffenna awamu n’abakazi n’abaana. ");
INSERT INTO lug_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Naye waŋŋamba nti, ‘Nnaakugaggawazanga, era abalikuvaamu baliba ng’omusenyu gw’ennyanja, ogutabalika obungi bwabwe.’ ” ");
INSERT INTO lug_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","N’alyoka asula eyo ekiro ekyo, n’aggya ekirabo kya muganda we Esawu ku ebyo bye yalina: ");
INSERT INTO lug_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","embuzi enkazi ebikumi bibiri, embuzi ennume amakumi abiri, endiga enkazi ebikumi bibiri, endiga ennume amakumi abiri, ");
INSERT INTO lug_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","eŋŋamira enkazi amakumi asatu n’obwana bwazo, ente enkazi amakumi ana n’ennume kkumi, n’endogoyi enkazi amakumi abiri, n’endogoyi ennume kkumi. ");
INSERT INTO lug_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","N’azikwasa abaddu be, buli kisibo ng’akyawudde, n’agamba abaddu be nti, “Kale munkulemberemu, mulekeewo ebbanga wakati wa buli kisibo.” ");
INSERT INTO lug_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","N’alagira eyakulembera nti, “Esawu, muganda wange bw’anaakusisinkana n’akubuuza nti, ‘Oli muntu w’ani? Ogenda wa? Na bino by’olina by’ani?’ ");
INSERT INTO lug_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","N’olyoka omuddamu nti, ‘Bya muddu wo Yakobo, birabo by’aweerezza mukama wange Esawu, era tali wala naffe.’ ” ");
INSERT INTO lug_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Bw’atyo era n’alagira n’owokubiri n’owookusatu ne bonna abaagobereranga ebisibo nti, “Nammwe mwogere ebigambo bye bimu bwe musisinkana Esawu, ");
INSERT INTO lug_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","era mugambe nti, ‘Omuddu wo Yakobo tali wala naffe.’ ” Kubanga Yakobo yalowooza nti, “Nnaamuwooyawooya n’ekirabo ekinkulembedde, n’oluvannyuma nnaalaba amaaso ge, osanga tankole kabi.” ");
INSERT INTO lug_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ekirabo kyekyava kimukulemberamu, ye n’asula mu kifo we yali ekiro ekyo. ");
INSERT INTO lug_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Mu kiro ekyo Yakobo n’agolokoka n’atwala bakazi be bombi, n’abaweereza be abakazi ababiri, n’abaana be ekkumi n’omu n’asomokera e Yaboki. ");
INSERT INTO lug_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","N’abatwala ne byonna bye yalina n’abasomosa omugga. ");
INSERT INTO lug_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ye Yakobo n’asigala yekka, omusajja n’ameggana naye okutuusa obudde okukya. ");
INSERT INTO lug_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Omusajja bwe yalaba nga taasobole Yakobo, n’akoma ku kinywa ky’ekisambi kye. Yakobo n’atandika okuwenyera nga bw’ameggana n’omusajja. ");
INSERT INTO lug_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Omusajja n’alyoka agamba Yakobo nti, “Ndeka ŋŋende kubanga obudde bugenda kukya.” Naye Yakobo n’ayogera nti, “Sijja kukuta nga tompadde mukisa.” ");
INSERT INTO lug_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Omusajja n’amubuuza nti, “Erinnya lyo gw’ani?” N’amuddamu nti, “Yakobo.” ");
INSERT INTO lug_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Awo n’amugamba nti, “Tokyaddayo kuyitibwa Yakobo. Wabula onooyitibwanga Isirayiri, kubanga omegganye ne Katonda, awamu n’abantu n’owangula.” ");
INSERT INTO lug_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Awo ne Yakobo n’amugamba nti, “Mbuulira erinnya lyo.” Naye ye n’amuddamu nti, “Lwaki ombuuza erinnya lyange?” Awo n’amuwa omukisa. ");
INSERT INTO lug_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakobo ekifo ekyo kyeyava akiyita Penieri, ng’agamba nti, “Kubanga ndabaganye ne Katonda, kyokka obulamu bwange ne busigalawo.” ");
INSERT INTO lug_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Enjuba n’evaayo ne mwakako nga bw’asala Penieri, ng’awenyera olw’obuvune mu kisambi kye. ");
INSERT INTO lug_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Abayisirayiri kyebava batalya kinywa ky’ekisambi na buli kati, kubanga ekyo omusajja wa Katonda kye yakomako. ");
INSERT INTO lug_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Awo Yakobo n’ayimusa amaaso ge n’alaba Esawu ng’ajja ng’ali n’abasajja ebikumi bina. Yakobo n’alyoka ayawulamu abaana abaali ne Leeya ne Laakeeri awamu n’abaweereza be abakazi ababiri. ");
INSERT INTO lug_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Abaweereza n’abaana baabwe ne bakulembera, Leeya n’abaana be ne baddako, Laakeeri ne Yusufu ne basembayo. ");
INSERT INTO lug_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ye Yakobo ng’abakulembedde, nga bw’avuunama ku ttaka emirundi musanvu, okutuusa lwe yatuuka okumpi ne muganda we. ");
INSERT INTO lug_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Naye Esawu n’adduka okumusisinkana, n’amulamusa ng’amugwa mu kifuba n’amunywegera; bombi ne bakaaba. ");
INSERT INTO lug_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esawu bwe yayimusa amaaso ge n’alaba abakazi n’abaana, n’abuuza Yakobo nti, “Bano baani abali naawe?” Yakobo n’amuddamu nti, “Be baana Katonda baawadde omuddu wo mu kisa kye.” ");
INSERT INTO lug_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Awo abaweereza be abakazi n’abaana baabwe ne basembera, ne bavuunama, mu ngeri y’emu. ");
INSERT INTO lug_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leeya n’abaana be nabo ne basembera ne bavuunama. Oluvannyuma Yusufu ne Laakeeri ne basembera nabo ne bavuunama. ");
INSERT INTO lug_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esawu n’abuuza Yakobo nti, “Otegeezaaki olwa bino byonna bye nsanze?” Yakobo n’addamu nti, “Lwa kufuna kusaasirwa kwa mukama wange.” ");
INSERT INTO lug_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Naye ye Esawu n’amugamba nti, “Bye nnina bimmala, muganda wange, by’olina beera nabyo.” ");
INSERT INTO lug_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobo n’amuddamu nti, “Nedda nkwegayiridde, obanga nfunye okusaasirwa mu maaso go, kale kkiriza ekirabo kyange ekivudde mu ngalo zange. Kubanga ddala okulaba ku maaso go kiri ng’okulaba amaaso ga Katonda, olw’ekisa ekyo ky’onnyaniririzzaamu. ");
INSERT INTO lug_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nkwegayiridde kkiriza ekirabo kyange ekikuleeteddwa, kubanga Katonda andaze ekisa kye, era siri mu bwetaavu.” Bw’atyo Esawu n’akikkiriza. ");
INSERT INTO lug_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Awo Esawu n’agamba nti, “Kale tutambule, nze nzija okukukulemberamu.” ");
INSERT INTO lug_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Naye Yakobo n’amuddamu nti, “Mukama wange amanyi nti abaana banafu, era n’ebisibo biyonsa, era singa bitambuzibwa awatali busaasizi bijja kufa. ");
INSERT INTO lug_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mukama wange k’aleke omuddu we, nze nzija kujja mpola, okusinziira ku ntambula y’ebisolo ebikulembedde, era ne ku ntambula y’abaana, okutuusa lwe ndituuka mu Seyiri.” ");
INSERT INTO lug_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Awo Esawu n’agamba Yakobo nti, “Kale ka ndeke abamu ku basajja abali nange.” Naye Yakobo n’amuddamu nti, “Tekyetaagisa. Kale nsaba ekisa mu maaso ga mukama wange.” ");
INSERT INTO lug_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Bw’atyo Esawu n’addayo ku lunaku olwo mu Seyiri. ");
INSERT INTO lug_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Naye Yakobo n’alaga mu Sukkosi, ne yeezimbira ennyumba, n’azimbira n’ensolo ebisiisira; ekifo ekyo kyekiva kiyitibwa Sukkosi. ");
INSERT INTO lug_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Era Yakobo n’atuuka mirembe mu kibuga Sekemu, mu nsi ya Kanani, ng’ava e Padanalaamu, n’asiisira okwolekera ekibuga. ");
INSERT INTO lug_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Abaana ba Kamoli kitaawe wa Sekemu ne bamuguza ekitundu mwe yasiisira, n’abasasula ebitundu bya ffeeza kikumi. ");
INSERT INTO lug_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","N’azimbira eyo ekyoto n’akiyita Ekyoto kya Katonda wa Isirayiri. ");
INSERT INTO lug_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Awo Dina muwala wa Leeya gwe yazaalira Yakobo, n’agenda okukyalira abakazi ab’omu nsi eyo. ");
INSERT INTO lug_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sekemu mutabani wa Kamoli Omukiiti omufuzi w’ensi eyo n’amulaba n’amukwata n’amusobyako. ");
INSERT INTO lug_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Omwoyo gwa Sekemu ne gutwalibwa Dina muwala wa Yakobo, n’amwagala n’ayogera naye ebigambo ebiweweevu. ");
INSERT INTO lug_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sekemu n’alyoka agamba kitaawe Kamoli nti, “Mpasiza omuwala ono abeere mukazi wange.” ");
INSERT INTO lug_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakobo bwe yawulira nga Sekemu asobezza ku muwala we Dina, n’aba mukkakkamu okutuusa batabani be abaali balabirira ebisibo ku ttale lwe badda. ");
INSERT INTO lug_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kamoli kitaawe wa Sekemu n’agenda eri Yakobo okwogera naye. ");
INSERT INTO lug_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Batabani ba Yakobo ne bakomawo eka nga bamaze okukitegeera. Ne banakuwala era ne basunguwalira nnyo Sekemu olw’okukola eky’ekivve era ekitasaana mu Isirayiri. ");
INSERT INTO lug_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kyokka ye Kamoli n’ayogera nabo ng’agamba nti, “Omwoyo gwa mutabani wange gwegomba nnyo muwala wo, nkwegayirira mumuwe amuwase. ");
INSERT INTO lug_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kkiriza tufumbiriganwenga, otuwe bawala bo, nammwe muwasenga bawala baffe. ");
INSERT INTO lug_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Munaabeeranga mu ffe, era mukolenga buli kye mwagala mu nsi yaffe. Mubeeremu era musuubuliremu, mugaggawale nnyo.” ");
INSERT INTO lug_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekemu naye n’ayogera ne Yakobo ne bannyina ba Dina, nti, “Nsaba ndabe ekisa mu maaso gammwe, era kyonna kye munansalira nzija kukibawa. ");
INSERT INTO lug_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Munsabe ebyobuko ebirabo n’ebigenderako, byonna nzija kubibawa nga bwe binaaba binsabiddwa; kye muba munkolera kwe kumpa omuwala abeere mukazi wange.” ");
INSERT INTO lug_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Batabani ba Yakobo ne baddamu Sekemu ne kitaawe Kamoli nga babakwenyakwenya kuba Sekemu yali asobezza ku mwannyinaabwe Dina. ");
INSERT INTO lug_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ne babagamba nti, “Ekyo tetusobola kukikola okuwa mwannyinaffe omuntu atali mukomole, kubanga kya muzizo gye tuli. ");
INSERT INTO lug_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Kye muteekwa okukola, tulyoke tukkirize, kwe kufuuka nga ffe nga buli musajja mu mmwe akomolebbwa. ");
INSERT INTO lug_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tulyoke tubawe bawala baffe, era naffe tuwase bawala bammwe, tubeere mu mmwe tufuuke eggwanga limu. ");
INSERT INTO lug_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Naye bwe mutakkiriza kukomolebwa, kale tunaatwala muwala waffe ne tugenda.” ");
INSERT INTO lug_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ebigambo byabwe ne bisanyusa Kamoli ne mutabani we Sekemu. ");
INSERT INTO lug_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Era omuvubuka teyalwa kukomolebwa, kubanga yayagala nnyo muwala wa Yakobo. Omuvubuka oyo ye yali asinga okussibwamu ekitiibwa mu baana ba Kamoli bonna. ");
INSERT INTO lug_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Awo Kamoli ne mutabani we Sekemu ne batuuka ku wankaaki w’ekibuga kyabwe ne boogera n’abantu b’ekibuga kyabwe nga bagamba nti, ");
INSERT INTO lug_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Abasajja abo mikwano gyaffe. Ka babeere mu nsi yaffe bakoleremu, kubanga, mulabe, ensi nnene ebamala. Ffe ka tuwase bawala baabwe era naffe tubawe bawala baffe. ");
INSERT INTO lug_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Wabula buli musajja mu ffe ateekwa okukomolebwa, nga bo bwe bakola; tufuuke eggwanga limu, lwe banakkiriza okubeera mu ffe. ");
INSERT INTO lug_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Olwo ente zaabwe, ebintu byabwe n’ensolo zaabwe zonna tebiibe byaffe? Kye tuba tukola kwe kukkiriziganya nabo, balyoke babeere mu ffe. ");
INSERT INTO lug_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Abasajja bonna abaali ku mulyango ebweru w’ekibuga ne bakkiriziganya ne Kamoli ne mutabani we Sekemu; buli musajja eyafuluma ebweru w’omulyango gw’ekibuga n’akomolebwa. ");
INSERT INTO lug_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Bwe waayitawo ennaku ssatu, nga bakyali mu bulumi, batabani ba Yakobo: Simyoni ne Leevi bannyina Dina ne baddira ebitala byabwe ne balumba ekibuga, abaamu nga tebategedde, ne batta buli musajja. ");
INSERT INTO lug_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Battiramu Kamoli ne mutabani we Sekemu ne baggya Dina mu nnyumba ya Sekemu ne beetambulira. ");
INSERT INTO lug_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Awo batabani ba Yakobo ne bagwa ku munyago ne banyaga ekibuga olwa mwannyinaabwe. ");
INSERT INTO lug_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ne batwala ebisibo by’endiga, amagana g’ente, n’endogoyi, na buli ekyali mu kibuga ne ku ttale. ");
INSERT INTO lug_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","N’obugagga bwonna, n’abaana bonna awamu n’abakazi, na buli ekyali mu mayumba, byonna ne babiwamba ne babinyaga. ");
INSERT INTO lug_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Awo Yakobo n’agamba Simyoni ne Leevi nti, “Mundeetedde akacwano, nfuuse wa kukyayibwa abantu bonna ab’omu nsi, Abakanani n’Abaperezi. Ffe tuli batono, kale bwe baneekuŋŋaanya ne bannumba nzija kumalibwawo, nze n’ennyumba yange yonna.” ");
INSERT INTO lug_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Bo ne bamuddamu nti, “Lwaki yayisa mwannyinaffe ng’omwenzi?” ");
INSERT INTO lug_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Katonda n’agamba Yakobo nti, “Golokoka oyambuke e Beseri, obeere eyo, ozimbire Katonda ekyoto, eyakulabikira bwe wadduka muganda wo Esawu.” ");
INSERT INTO lug_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Awo Yakobo n’agamba ab’omu nnyumba ye ne bonna abaali naye nti, “Muggyeewo bakatonda abalala abali nammwe, mwetukuze mukyuse ebyambalo byammwe, ");
INSERT INTO lug_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","tulyoke twambuke tugende e Beseri ndyoke nzimbire Katonda ekyoto, Katonda eyanziramu mu nnaku ez’okunakuwala kwange, era abadde nange buli gye ŋŋenze. ");
INSERT INTO lug_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Awo ne bawa Yakobo bakatonda abalala bonna be baalina, n’empeta ezaali ku matu gaabwe; Yakobo n’abiziika wansi w’omuvule ogwali okumpi ne Sekemu.” ");
INSERT INTO lug_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Bwe baali batambula, entiisa ya Katonda n’egwa ku bibuga ebyali bibeetoolodde, ne batagoberera baana ba Yakobo. ");
INSERT INTO lug_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakobo n’ajja e Luzi, ye Beseri, ekiri mu nsi ya Kanani, ye n’abantu bonna abaali naye. ");
INSERT INTO lug_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","N’azimba eyo ekyoto, n’akituuma Erubeeseeri. Kubanga eyo Katonda gye yamweragira bwe yadduka muganda we. ");
INSERT INTO lug_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debola omujjanjabi wa Lebbeeka n’afa n’aziikibwa wansi w’omuvule, wansi wa Beseri kyekyava kiyitibwa Alooninakusi. ");
INSERT INTO lug_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakobo bwe yava mu Padanalaamu Katonda n’amulabikira, n’amuwa omukisa. ");
INSERT INTO lug_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Katonda n’amugamba nti, “Erinnya lyo ggwe Yakobo; tokyaddayo kuyitibwa Yakobo, erinnya lyo linaabanga Isirayiri.” Bwe kityo erinnya lye ne liba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Katonda n’amugamba nti, “Ndi Katonda Ayinzabyonna: zaala oyale, eggwanga n’enkuyanja y’amawanga biriva mu ggwe, ne bakabaka balisibuka mu ggwe. ");
INSERT INTO lug_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ensi gye nawa Ibulayimu ne Isaaka, ndigikuwa ggwe, era ndigiwa n’ezzadde lyo eririddawo.” ");
INSERT INTO lug_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Awo Katonda n’alinnya okuva waali mu kifo we yayogerera naye. ");
INSERT INTO lug_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakobo n’asimba empagi mu kifo Katonda mwe yayogerera naye, empagi ey’ejjinja; n’agiyiwako ekiweebwayo ekyokunywa, n’ayiwako n’amafuta. ");
INSERT INTO lug_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakobo ekifo Katonda we yayogerera naye n’akiyita Beseri. ");
INSERT INTO lug_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Bwe baava e Beseri, era nga bakyali walako okuva Efulasi, Laakeeri n’alumwa, n’alumwa ddala nnyo. ");
INSERT INTO lug_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Bwe yali ng’alumwa bw’atyo omuzaalisa n’amugamba nti, “Totya kubanga kaakano onoofuna omwana omulala owoobulenzi.” ");
INSERT INTO lug_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Omwoyo bwe gwali gumuggwaamu ng’afa, n’amutuuma Benoni, naye kitaawe n’amuyita Benyamini. ");
INSERT INTO lug_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Awo Laakeeri n’afa n’aziikibwa ku kkubo erigenda Efulasi (ye Besirekemu). ");
INSERT INTO lug_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakobo n’asimba empagi ku malaalo ge, y’empagi y’amalaalo ga Laakeeri, ekyaliwo n’okutuusa kaakano. ");
INSERT INTO lug_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isirayiri ne yeeyongera okutambula, n’akuba eweema ye, emabega w’omunaala gwa Ederi. ");
INSERT INTO lug_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isirayiri bwe yali ng’ali mu nsi omwo Lewubeeni n’agenda ne yeebaka ne Biira omuweereza wa kitaawe, Isirayiri n’akiwulira. Batabani ba Yakobo baali kkumi n’ababiri. ");
INSERT INTO lug_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Batabani ba Leeya baali: Lewubeeni mutabani wa Yakobo omubereberye, ne Simyoni, ne Leevi, ne Yuda, ne Isakaali ne Zebbulooni. ");
INSERT INTO lug_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Batabani ba Laakeeri ye: Yusufu ne Benyamini. ");
INSERT INTO lug_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Batabani ba Biira, omuweereza wa Laakeeri be ba: Ddaani ne Nafutaali. ");
INSERT INTO lug_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Batabani ba Zirupa omuweereza wa Leeya be ba: Gaadi ne Aseri. Bano be batabani ba Yakobo abaamuzaalirwa mu Padanalaamu. ");
INSERT INTO lug_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Awo Yakobo n’ajja eri kitaawe Isaaka e Mamule, oba Kiriyasaluba, ye Kebbulooni, Ibulayimu ne Isaaka mwe baatuulanga. ");
INSERT INTO lug_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaaka yawangaala emyaka kikumi mu kinaana. ");
INSERT INTO lug_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaaka n’afa ng’akaddiye nnyo n’agenda abantu be gye bagenda, ng’amaze ennaku nnyingi, batabani be Esawu ne Yakobo ne bamuziika. ");
INSERT INTO lug_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Bino bye bifa ku b’olulyo lwa Esawu, ye Edomu. ");
INSERT INTO lug_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esawu yawasa abakazi ng’abaggya mu Bakanani: Yawasa Ada muwala wa Eroni Omukiiti, ne Okolibama muwala wa Ana mutabani wa Zibyoni Omukiivi, ");
INSERT INTO lug_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ne Basimansi muwala wa Isimayiri muganda wa Nebayoosi. ");
INSERT INTO lug_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada n’azaalira Esawu Erifaazi, ne Basimansi n’azaala Leweri; ");
INSERT INTO lug_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ne Okolibama n’azaala Yewusi, ne Yalamu ne Koola; abo be batabani ba Esawu abaamuzaalirwa mu nsi ya Kanani. ");
INSERT INTO lug_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Awo Esawu n’atwala bakazi be, ne batabani be, ne bawala be n’abantu be bonna, n’ente ze, awamu n’ebintu bye byonna bye yafuna mu nsi ya Kanani; n’agenda mu nsi ey’ewala ku ya muganda we Yakobo. ");
INSERT INTO lug_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Kubanga obugagga bwabwe bwali bungi nnyo nga tebukyabasobozesa kubeera wamu n’ensi mwe baali ng’ebafundiridde olw’obungi bw’ebisolo byabwe. ");
INSERT INTO lug_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Olwo ye Esawu, era ye Edomu, n’abeera mu nsi ey’ensozi za Seyiri. ");
INSERT INTO lug_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Bino bye bifa ku b’olulyo lwa Esawu, kitaawe w’Abaedomu abaamuzaalirwa ng’ali mu nsi y’ensozi za Seyiri. ");
INSERT INTO lug_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Batabani be baali: Erifaazi eyamuzaalirwa Ada, ne Leweri eyamuzaalirwa Basimansi. ");
INSERT INTO lug_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Batabani ba Erifaazi baali Temani, ne Omali, ne Zefo, ne Gatamu ne Kenazi. ");
INSERT INTO lug_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timuna yali mukazi wa Erifaazi, mutabani wa Esawu era yamuzaalira Ameleki. Abo be batabani ba Ada mukazi wa Esawu. ");
INSERT INTO lug_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Bano be batabani ba Leweri: Nakasi, ne Zeera, ne Saama ne Mizza. Abo be bazzukulu ba Esawu ne mukazi we Basemasi. ");
INSERT INTO lug_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","N’abaana ba Okolibama muwala wa Ana, muzzukulu wa Zibyoni, baali Yewusi, ne Yalamu ne Koola, be yazaalira bba Esawu. ");
INSERT INTO lug_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Bano be bakulu b’enda ya Esawu: Enda ya Erifaazi omubereberye wa Esawu: Temani, ne Omali, ne Zefo, ne Kenazi, ");
INSERT INTO lug_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ne Koola, ne Gatamu ne Amaleki abaali mu nsi ya Edomu be batabani ba Ada. ");
INSERT INTO lug_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Enda ya Leweri mutabani wa Esawu: Nakasi, ne Zeera, ne Samma ne Mizza nabo baali mu nsi ya Edomu, era baava mu Basimansi, mukazi wa Esawu. ");
INSERT INTO lug_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Abaazaalibwa Okolibama mukazi wa Esawu, muwala wa Ana: Yewusi, ne Yalamu ne Koola. ");
INSERT INTO lug_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Abo bonna be baava mu Esawu, ye Edomu, era be bakulu b’enda zaabwe. ");
INSERT INTO lug_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Batabani ba Seyiri Omukooli abaabeeranga mu Edomu be ba Lotani, ne Sobali, ne Zibyoni, ne Ana, ");
INSERT INTO lug_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ne Disoni, ne Ezeri ne Disani. Abo be baava mu Bakooli, be baana ba Seyiri abaali mu nsi ya Edomu. ");
INSERT INTO lug_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Batabani ba Lotani baali Kooli, ne Kemamu, era Lotani yalina mwannyina nga ye Timuna. ");
INSERT INTO lug_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Batabani ba Sobali be ba Aluvani, ne Manakasi, ne Eberi, ne Sefo ne Onamu. ");
INSERT INTO lug_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Aba Zibyoni, be ba Aya ne Ana; ono ye Ana eyavumbula ensulo z’amazzi agookya, ezaali mu ddungu; bwe yali ng’alunda endogoyi za kitaawe Zibyoni. ");
INSERT INTO lug_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Abaana ba Ana be ba Disoni ne Okolibama omuwala. ");
INSERT INTO lug_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Bo batabani ba Disoni be ba Kemudaani, ne Esubani, ne Isulani ne Kerani. ");
INSERT INTO lug_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Aba Ezeri be ba Birani, ne Zaavani ne Akani. ");
INSERT INTO lug_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ate aba Disani be ba Uzi ne Alani. ");
INSERT INTO lug_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Bano be bakulu b’enda za Bakooli: Lotani, ne Sobali, ne Zibyoni, ne Ana, ");
INSERT INTO lug_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ne Disoni, ne Ezeri ne Disani. Bano be bakulu b’enda za Bakooli ng’ebika byabwe bwe byali, mu nsi ya Seyiri. ");
INSERT INTO lug_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Bakabaka abafuga ensi ya Edomu, nga tewannaba na kabaka afuga Isirayiri be bano: ");
INSERT INTO lug_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bera mutabani wa Byori yafuga Edomu ng’asinziira mu kibuga kye Dinukaba. ");
INSERT INTO lug_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bera bwe yafa Yobabu mutabani wa Zeera ow’e Bozula n’afuga mu kifo kye. ");
INSERT INTO lug_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabu bwe yafa Kusamu Omutemani n’afuga mu kifo kye. ");
INSERT INTO lug_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ne Kusamu bwe yafa, Kadadi mutabani wa Bedadi, eyawangula Midiyaani, mu nsi ya Mowaabu n’afuga mu kifo kye; ng’afugira mu kibuga ky’e Avisi. ");
INSERT INTO lug_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ate Kadadi bwe yafa, Samula ow’e Masuleka n’afuga mu kifo kye. ");
INSERT INTO lug_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula bwe yafa Sawuli ow’e Lekobosi, ku mugga Fulaati n’afuga mu kifo kye. ");
INSERT INTO lug_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sawuli bwe yafa, Baalukanani mutabani wa Akubooli n’afuga mu kifo kye. ");
INSERT INTO lug_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ate Balukanani mutabani wa Akubooli bwe yafa, Kadali n’afuga mu kifo kye, ng’ali mu kibuga kye Pawu; mukazi we yayitibwanga Meketaberu muwala wa Mezakabu ne Matirida. ");
INSERT INTO lug_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Bano be bakulu b’enda zaabo abaava mu Esawu, nga bwe baali mu bifo byabwe: Timuna, ne Aluva, ne Yesesi, ");
INSERT INTO lug_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ne Okolibama, ne Era, ne Pinoni, ");
INSERT INTO lug_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ne Kenazi, ne Temani, ne Mibuza, ");
INSERT INTO lug_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ne Magidiyeri, ne Iramu. Abo be bakulu b’enda ya Edomu, ye Esawu kitaawe wa Edomu, okusinziira mu bifo mwe baali mu nsi y’obutaka bwabwe. ");
INSERT INTO lug_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo yabeeranga mu Kanani, ensi bajjajjaabe mwe baatambuliratambuliranga. ");
INSERT INTO lug_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Era bino bye bifa ku lulyo lwa Yakobo: Yusufu bwe yali nga wa myaka kkumi na musanvu ng’ali ne baganda be batabani ba Biira ne Zirifa, nga balunda ekisibo ky’endiga, Yusufu n’ategeezanga Yakobo kitaabwe ebintu ebibi bye baakolanga. ");
INSERT INTO lug_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Bw’atyo Isirayiri n’ayagala nnyo Yusufu okusinga abaana be abalala, kubanga nga ye mwana ow’omu bukadde bwe; n’amutungira ekyambalo eky’amabala amangi. ");
INSERT INTO lug_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Naye baganda ba Yusufu bwe baalaba nga kitaabwe amwagala okusinga bo ne bakyawa Yusufu, ne batayinza na kwogera naye na kisa. ");
INSERT INTO lug_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Lumu Yusufu n’aloota ekirooto, n’agenda n’akitegeeza baganda be, ne beeyongera nnyo okumukyawa. ");
INSERT INTO lug_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yabagamba nti, “Muwulire ekirooto kino kye naloose. ");
INSERT INTO lug_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Twali tusiba ebinywa by’eŋŋaano nga tuli mu nnimiro, ekinywa kyange ne kiyimuka ne kiyimirira; laba ebinywa byammwe ne bikyebungulula ne bikivuunamira.” ");
INSERT INTO lug_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Baganda be ne bamugamba nti, “Olowooza olitufuga? Olowooleza ddala nti tulibeera baddu bo?” Olwo ne beeyongera nnyo okumukyayira ddala olw’ekirooto kye n’ebigambo bye. ");
INSERT INTO lug_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ate n’aloota ekirooto ekirala n’akitegeeza baganda be, n’agamba nti, “Ndoose ekirooto ekirala: ne ndaba enjuba n’omwezi n’emmunyeenye ekkumi n’emu nga binvuunamira.” ");
INSERT INTO lug_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Naye bwe yakitegeeza kitaawe ng’ali wamu ne baganda be, kitaawe n’amunenya ng’agamba nti, “Kirooto ki kino ky’oloose? Ddala nze ne nnyoko awamu ne baganda bo tulijja ne tuvuunama mu maaso go?” ");
INSERT INTO lug_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Baganda be ne bamukwatirwa obuggya, kyokka ye kitaabwe n’akuuma ekigambo ekyo mu mutima gwe. ");
INSERT INTO lug_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Awo baganda ba Yusufu ne bagenda okumpi ne Sekemu okulunda ekisibo kya kitaabwe. ");
INSERT INTO lug_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isirayiri n’alyoka agamba Yusufu nti, “Nga baganda bo bwe balundira e Sekemu, jjangu nkutume gye bali.” Yusufu n’amuddamu nti, “Nzuuno ntuma.” ");
INSERT INTO lug_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","N’alyoka amugamba nti, “Genda kaakano olabe obanga baganda bo n’ekisibo bali bulungi, okomewo ontegeeze.” Awo n’amutuma okuva mu kiwonvu kya Kebbulooni, n’atuuka e Sekemu. ");
INSERT INTO lug_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Awo omusajja n’amulaba ng’atangatangira ku ttale, n’amubuuza nti, “Onoonya ki?” ");
INSERT INTO lug_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","N’amuddamu nti, “Noonya baganda bange, nkwegayiridde mbuulira gye balundira ekisibo.” ");
INSERT INTO lug_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Omusajja n’amuddamu nti, “Beeyongerayo, kubanga nabawulira nga bagamba nti, ‘Ka tugende e Dosani.’ ” Awo Yusufu n’agoberera baganda be n’abasanga e Dosani. ");
INSERT INTO lug_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Baganda be ne bamulengera ng’akyali wala, era bwe yali nga tannabasemberera ne bateesa bamutte. ");
INSERT INTO lug_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ne bagambagana nti, “Sekalootera wuuyo ajja. ");
INSERT INTO lug_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kale mujje tumutte, tumusuule mu kimu ku binnya; tuligamba nti, ‘Ensolo enkambwe ye yamulya; tulabe ebirooto bye bwe birituukirira.’ ” ");
INSERT INTO lug_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Naye Lewubeeni bwe yakiwulira n’agezaako okumuwonya mu mikono gyabwe n’agamba nti, “Tetumutta. ");
INSERT INTO lug_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tuleme kuyiwa musaayi; ka tumusuule mu bunnya buno wano mu nsiko. Temumuteekako mukono gwammwe.” Yayogera bw’atyo alyoke amuwonye mu mikono gyabwe, amuddize kitaawe. ");
INSERT INTO lug_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Awo Yusufu bwe yatuuka ku baganda be ne bamwambulamu ekyambalo kye eky’amabala amangi kye yali ayambadde: ");
INSERT INTO lug_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ne bamutwala ne bamusuula mu bunnya obwali obukalu nga tebuliimu mazzi. ");
INSERT INTO lug_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Awo bwe baatuula okulya, ne bayimusa amaaso ne balengera ekibiina ky’Abayisimayiri nga bava e Gireyaadi, ng’eŋŋamira zaabwe zeettise ebyakaloosa, n’envumbo ne mooli nga bali mu lugendo babitwala e Misiri. ");
INSERT INTO lug_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda kwe kugamba baganda be nti, “Kitugasa ki okutta muganda waffe n’okuyiwa omusaayi gwe? ");
INSERT INTO lug_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tumuguze Abayisimayiri. Omukono gwaffe guleme okumubaako, kubanga muganda waffe, omubiri gwaffe gwennyini.” Baganda be ne bakkiriziganya naye. ");
INSERT INTO lug_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Abasuubuzi, Abayisimayiri bwe baabatuukako ne baggya Yusufu mu bunnya, ne bamuguza Abayisimayiri. Baamubaguza ebitundu bya ffeeza amakumi abiri; ne bamutwala e Misiri. ");
INSERT INTO lug_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Lewubeeni bwe yadda n’alaga ku bunnya n’alaba nga Yusufu taliimu, n’ayuza engoye ze, ");
INSERT INTO lug_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","n’addayo eri baganda be n’abagamba nti, “Omwana taliiyo. Kale naamunoonyeza wa?” ");
INSERT INTO lug_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Awo ne baddira ekyambalo kya Yusufu, ne batta embuzi, ne bakinnyika mu musaayi. ");
INSERT INTO lug_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ne baddira ekyambalo ekyo eky’amabala amangi ne bakitwalira kitaabwe ne bamugamba nti, “Twalaba ekyambalo kino, kikebere olabe obanga kye kya mutabani wo.” ");
INSERT INTO lug_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","N’akyetegereza n’agamba nti, “Kye kyambalo kya mutabani wange! Ensolo enkambwe yamulya. Ddala Yusufu yataagulwataagulwa.” ");
INSERT INTO lug_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Awo Yakobo n’ayuza ebyambalo bye, n’akungubagira Yusufu okumala ebbanga ddene. ");
INSERT INTO lug_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Batabani be bonna ne bawala be ne bagenda gy’ali okumusanyusa, kyokka ye n’atakkiriza kusanyusibwa. N’agamba nti, “Nedda, ndikka emagombe nga nkyakungubagira omwana wange Yusufu.” Bw’atyo Yakobo n’akungubagira nnyo Yusufu. ");
INSERT INTO lug_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mu kiseera kyekimu Abamidiyaani bwe baatuuka e Misiri, Yusufu ne bamuguza Potifali, omu ku bakungu ba Falaawo; omukungu oyo ye yali omukulu wa bambowa. ");
INSERT INTO lug_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Awo olwatuuka Yuda n’ava ku baganda be n’aserengeta, n’ayingira ew’Omudulamu, erinnya lye, Kira. ");
INSERT INTO lug_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yuda n’alabayo muwala wa Suwa, Omukanani, n’amuwasa, ne yeetaba naye, ");
INSERT INTO lug_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","n’aba olubuto n’azaala omwana owoobulenzi n’amutuuma erinnya Eri. ");
INSERT INTO lug_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Mukyala wa Yuda n’aba olubuto olulala n’azaala omwana omulenzi n’amutuuma Onani. ");
INSERT INTO lug_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ate n’azaala omwana omulala n’amutuuma Seera. Yamuzaalira mu Kezibu. ");
INSERT INTO lug_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Era Yuda n’awasiza mutabani we omukulu, Eri, omukazi erinnya lye Tamali. ");
INSERT INTO lug_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Naye Eri mutabani wa Yuda omukulu n’aba mwonoonyi mu maaso ga Mukama; Mukama n’amutta. ");
INSERT INTO lug_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Awo Yuda n’agamba Onani nti, “Genda eri muka muganda wo, ofunire muganda wo ezzadde.” ");
INSERT INTO lug_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Naye Onani n’amanya nti ezzadde teririba lirye; bw’atyo bwe yeetaba naye, amannyi n’agafuka wansi aleme okufunira muganda we ezzadde. ");
INSERT INTO lug_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ekyo kye yakola kyali kibi mu maaso ga Mukama. N’ono Mukama kyeyava amutta. ");
INSERT INTO lug_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Awo Yuda olw’okutya nti Seera ayinza okufa nga baganda be, n’agamba Tamali nti, “Ogira obeera nnamwandu, ng’oli mu nnyumba ya kitaawo okutuusa Seera lw’alikula.” Tamali kwe kugenda n’abeera mu nnyumba ya kitaawe. ");
INSERT INTO lug_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bwe waayitawo ebbanga mukazi wa Yuda, muwala wa Suwa n’afa. Yuda bwe yayita mu kukungubaga, n’agenda ne Kira Omudulamu e Timuna eri basajja be abasazi b’ebyoya by’endiga ze. ");
INSERT INTO lug_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamali bwe kyamubuulirwa nti, “Sezaala wo agenda e Timuna okusala ebyoya by’endiga ze,” ");
INSERT INTO lug_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","n’asuula eri ebyambalo by’obwannamwandu ne yeeteekako ekiremba ne yeebikkirira, n’atuula ku mulyango gwa Enayimu, ekiri ku kkubo ng’ogenda e Timuna. Kubanga yamanya nti, Seera akuze, kyokka nga tamuweereddwa ku muwasa. ");
INSERT INTO lug_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda bwe yamulaba, n’amulowooza okuba omu ku bamalaaya, kubanga yali abisse amaaso ge. ");
INSERT INTO lug_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","N’agenda gy’ali ku mabbali g’ekkubo, n’amugamba nti, “Jjangu, neetabe naawe,” kubanga teyamanya nti ye yali muka mutabani we. Tamali kwe ku mubuuza nti, “Onompa ki bwe neetaba naawe?” ");
INSERT INTO lug_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda n’amuddamu nti, “Nnaakuweereza embuzi ento.” N’amubuuza nti, “Onompa omusingo nga tonnagimpeereza?” ");
INSERT INTO lug_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda n’amuddamu nti, “Nkuwe musingo ki?” N’amugamba nti, “Akabonero ko, akajegere ko awamu n’omuggo gwo oguli mu mukono gwo.” Awo n’abimuwa, ne yeetaba naye, n’amufunyisa olubuto. ");
INSERT INTO lug_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamali n’agolokoka n’agenda, n’aggyako ekiremba n’ayambala ebyambalo by’obwannamwandu bwe. ");
INSERT INTO lug_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda bwe yatuma mukwano gwe Omudulamu, okutwala omwana gw’embuzi, addizibwe omusingo teyalaba ku mukazi. ");
INSERT INTO lug_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Bwe yabuuliriza ab’omu kifo omwo, omukazi malaaya eyali Enayimu ku mabbali g’ekkubo, ne bamuddamu nti, “Wano tewabeeranga mukazi malaaya.” ");
INSERT INTO lug_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","N’alyoka addayo eri Yuda n’amugamba nti takubikako kimunye; era n’abantu ab’ekitundu ekyo bamutegeezeza nti, “Awo tewabangawo mukazi malaaya.” ");
INSERT INTO lug_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda kwe kumugamba nti, “Omukazi oli, ebintu k’abisigaze tuleme okusekererwa, naweereza embuzi eno, naye n’atalabikako.” ");
INSERT INTO lug_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Emyezi ng’esatu bwe gyayitawo ne bagamba Yuda nti, “Muka mwana wo Tamali yafuuka mwenzi. Ate ebyo nga biri awo obwenzi obwo yabufunamu n’olubuto.” Yuda kwe kwejuumuula nga bw’agamba nti, “Mumuleete ayokebwe.” ");
INSERT INTO lug_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tamali bwe yali atwalibwa n’atumira sezaala we Yuda n’amugamba nti, “Omusajja nannyini bintu bino ye kazaalabulwa. Nkusaba weetegereze ebintu bino: akabonero, akajegere n’omuggo, by’ani?” ");
INSERT INTO lug_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Awo Yuda n’abitegeera n’agamba nti, “Omuwala mutuukirivu okunsinga, kubanga saamuwa mutabani wange Seera.” Yuda n’atamuddira. ");
INSERT INTO lug_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ekiseera eky’okuwona bwe kyatuuka n’alabika nga wakuzaala balongo. ");
INSERT INTO lug_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Era bwe yali mu ssanya omulongo omu n’afulumya omukono gwe, omuzaalisa n’agukwata n’agusibako akawuzi akaakakobe nga bw’agamba nti, “Ono y’asoose okujja.” ");
INSERT INTO lug_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Naye omulongo bwe yazzaayo omukono gwe munda, muganda we n’afuluma; omuzaalisa n’agamba nti, “Lwaki owaguzza?” Erinnya ly’omwana kyeryava liba Pereezi. ");
INSERT INTO lug_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Oluvannyuma muganda we n’afuluma n’akawuzi akaakakobe nga kali ku mukono gwe, n’ayitibwa Zeera. ");
INSERT INTO lug_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Awo Yusufu bwe yatwalibwa e Misiri, Potifali omukungu wa Falaawo, omukulu w’abambowa Omumisiri n’amugula okuva ku Bayisimayiri abaamutwala e Misiri. ");
INSERT INTO lug_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mukama n’aba ne Yusufu n’aba n’omukisa ng’ali mu nnyumba ya mukama we Omumisiri. ");
INSERT INTO lug_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ne mukama we n’alaba nga Mukama amuwadde omukisa mu buli ky’akola. ");
INSERT INTO lug_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Awo Yusufu n’aganja nnyo mu maaso ga mukama we, n’amulabiriranga, n’amufuula omukulu we nnyumba ye ne byonna bye yalina. ");
INSERT INTO lug_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Okuva olwo Mukama n’awa omukisa ennyumba y’Omumisiri olwa Yusufu. Omukisa gwa Mukama ne guba ku byonna bye yalina, mu nnyumba ne mu nnimiro. ");
INSERT INTO lug_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Awo Omumisiri n’ateeka byonna mu mikono gya Yusufu. Yusufu n’avunaanyizibwanga byonna okuggyako emmere mukama we gye yalyanga. Kyokka Yusufu yali mulungi nnyo, mubalagavu. ");
INSERT INTO lug_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Awo olwatuuka oluvannyuma lw’ebbanga eriwerako, mukyala wa mukama we namutunuulira n’okwegomba era n’amugamba nti, “Weebake nange.” ");
INSERT INTO lug_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Naye Yusufu n’agaana, n’agamba mukazi wa mukama we nti, “Laba, mukama wange yankwasa byonna ebiri mu nnyumba, n’abiteeka byonna mu mikono gyange, ");
INSERT INTO lug_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","era tewali n’omu ansinga mu nnyumba ye, tewali na kimu ky’atankwasa okuggyako ggwe, kubanga ggwe oli mukazi we. Kale nnyinza ntya okuyingira mu kwonoona okwenkanidde awo n’okusobya eri Katonda?” ");
INSERT INTO lug_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Newaakubadde muka mukama we yamutayirira, Yusufu ye teyamuwulira na mulundi na gumu. ");
INSERT INTO lug_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Naye lwali lumu Yusufu bwe yayingira mu nju okukola emirimu gye nga tewali n’omu mu nnyumba, ");
INSERT INTO lug_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","muka mukama we n’akwata ekyambalo kya Yusufu nga bw’agamba nti, “Weegatte nange.” Yusufu n’amwesimatulako, ekyambalo kye ne kisigala mu ngalo z’omukazi wa mukama we. Ye n’adduka n’ava mu nnyumba. ");
INSERT INTO lug_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Naye omukazi bwe yalaba ng’asigazza ekyambalo kya Yusufu, ");
INSERT INTO lug_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","n’ayita abasajja ab’omu nnyumba ye n’abagamba nti, “Mulabe, yatuleetera Omwebbulaniya okutuduulira, yazze gye ndi okwebaka nange, ");
INSERT INTO lug_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","bw’awulidde nga ndeekaana n’adduka n’ava mu nnyumba.” ");
INSERT INTO lug_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Awo kwe kutereka ekyambalo okutuusa mukama wa Yusufu lwe yadda eka. ");
INSERT INTO lug_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Omukyala n’abuulira bba byonna ng’agamba nti, “Omuddu Omwebbulaniya gwe watuleetera, yayingidde gye ndi okunjooga. ");
INSERT INTO lug_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Naye nabadde nakaleekaana, n’aleka ekyambalo kye gye ndi, n’adduka n’ava mu nnyumba.” ");
INSERT INTO lug_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Awo mukama wa Yusufu bwe yawulira ebigambo omukazi bye yamutegeeza ng’agamba nti, “Bw’ati ne bw’ati omuddu wo bwe yampisizza,” obusungu bwa bba ne bubuubuuka. ");
INSERT INTO lug_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Mukama wa Yusufu n’akwata Yusufu n’amuteeka mu kkomera omwasibirwanga abazzizza emisango eri kabaka. ");
INSERT INTO lug_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Naye Mukama n’abeera ne Yusufu, n’amulaga okwagala kwe okutalojjeka. N’aganja nnyo mu maaso g’omukuumi w’ekkomera. ");
INSERT INTO lug_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Omukuumi w’ekkomera n’ateeka abasibe bonna mu mikono gya Yusufu, era buli ekyakolebwanga nga Yusufu y’akirinako obuvunaanyizibwa. ");
INSERT INTO lug_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Omukuumi w’ekkomera nga tafaayo ku buli ekyalinga mu mikono gya Yusufu, kubanga Mukama yali naye, era Mukama n’amuwa omukisa mu buli kye yakolanga. ");
INSERT INTO lug_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Oluvannyuma lw’ebyo omusenero wa kabaka w’e Misiri wamu n’omukulu wa bafumbi be ne banyiiza mukama waabwe kabaka w’e Misiri. ");
INSERT INTO lug_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Falaawo n’asunguwalira nnyo abakungu be abo: omusenero n’omukulu w’abafumbi, ");
INSERT INTO lug_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","n’abawaayo mu mikono gy’omukulu w’ekkomera, Yusufu mwe yali. ");
INSERT INTO lug_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Omukulu w’ekkomera n’abawa Yusufu okubakuuma, n’abalabirira, ne babeera mu kkomera. ");
INSERT INTO lug_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Naye ekiro kimu omusenero n’omukulu wa bafumbi aba kabaka w’e Misiri abaali mu kkomera ne baloota, buli omu ekirooto kye, era nga buli kimu kirina amakulu gaakyo. ");
INSERT INTO lug_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yusufu bwe yajja gye bali ku makya, n’abalaba nga beeraliikirivu. ");
INSERT INTO lug_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","N’alyoka abuuza abakungu ba Falaawo abaali naye mu kkomera, mu nnyumba ya mukama waabwe nti, “Lwaki leero mulabika nga mweraliikiridde?” ");
INSERT INTO lug_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ne bamuddamu nti, “Twaloose ebirooto, naye tewali wa kubivvuunula.” Awo Yusufu n’abagamba nti, “Katonda y’abivvuunula. Kale mbasaba mubimbuulire.” ");
INSERT INTO lug_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Awo omusenero n’ategeeza Yusufu ekirooto kye n’agamba nti, “Nalabye omuti omutiini mu kirooto. ");
INSERT INTO lug_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ku mutiini nga kuliko amatabi asatu, gwabadde gwakatojjera ne gumulisa, ebirimba ne bibaako zabbibu ennyengevu. ");
INSERT INTO lug_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nga nkute ekikopo kya Falaawo mu ngalo zange, ne nzirira zabbibu ne nzikamulira mu kikopo kya Falaawo, ne nkimukwasa.” ");
INSERT INTO lug_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu n’alyoka amugamba nti, “Gano ge makulu gaakyo: amatabi asatu, ze nnaku esatu; ");
INSERT INTO lug_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","mu nnaku ssatu Falaawo alikuggya mu kkomera n’akuzza mu kifo kyo, era olimukwasa ekikopo nga bwe wakolanga edda ng’oli musenero we. ");
INSERT INTO lug_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kyokka onzijukiranga ng’otuuse mu maaso ga Falaawo, onzijukiranga n’onjogerako gy’ali nkwegayiridde, alyoke anzigye mu kkomera. ");
INSERT INTO lug_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kubanga ddala naggyibwa buggyibwa mu nsi y’Abaebulaniya; ate na wano sirina kye nakola kinsaanyiza kuteekebwa mu kkomera.” ");
INSERT INTO lug_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Omukulu w’abafumbi ba Falaawo bwe yalaba ng’amakulu g’ekirooto ky’oli gaali malungi, n’agamba Yusufu nti, “Nange naloose ekirooto: nga neetisse ku mutwe ebibbo by’emigaati bisatu. ");
INSERT INTO lug_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mu kibbo ekyokusatu mwabaddemu buli ngeri ya mmere enjokye eya Falaawo. Kyokka ng’ennyonyi zigiriira ku mutwe gwange.” ");
INSERT INTO lug_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Awo Yusufu n’amuddamu nti, “Gano ge makulu gaakyo: ebibbo ebisatu z’ennaku ssatu; ");
INSERT INTO lug_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","bwe wanaayitawo ennaku ssatu Falaawo ajja kukutemako omutwe, akuwanike ku muti, omulambo gwo guliibwe ebinyonyi.” ");
INSERT INTO lug_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ku lunaku olwokusatu, lwali lunaku lwa mazaalibwa ga Falaawo, n’akolera abaweereza be bonna embaga, n’atumya omusenero n’omukulu w’abafumbi. ");
INSERT INTO lug_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Omusenero n’amuzza ku mulimu gwe, n’atandika okuweereza Falaawo, ");
INSERT INTO lug_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","kyokka ye omukulu w’abafumbi n’amuwanika ku muti, nga Yusufu bwe yavvuunula ebirooto byabwe. ");
INSERT INTO lug_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Naye omusenero n’atajjukira Yusufu n’amwerabira n’atamussaako mwoyo. ");
INSERT INTO lug_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Oluvannyuma lw’emyaka ebiri emirambirira, Falaawo n’aloota ng’ayimiridde ku mugga Kiyira; ");
INSERT INTO lug_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","laba mu mugga ne muvaamu ente ennungi ensava musanvu, ne ziriira mu bisaalu. ");
INSERT INTO lug_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Era laba ente endala embi enkovvu musanvu nazo ne ziva mu mugga, ne ziyimirira wamu na ziri ku lubalama lw’omugga. ");
INSERT INTO lug_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ente enkovvu, embi ne zirya ente ennungi ensava. Awo Falaawo n’azuukuka. ");
INSERT INTO lug_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ate n’addamu okwebaka n’aloota ekirooto ekirala, laba ebirimba eby’emmere ey’empeke musanvu ebigimu nga biri ku kiti kimu. ");
INSERT INTO lug_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Era laba oluvannyuma ebirimba ebirala musanvu nga bikaze olw’empewo ez’ebbugumu ez’ebuvanjuba nabyo ne biddirira. ");
INSERT INTO lug_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Awo ebirimba biri ebikaze ne bimira ebirimba biri omusanvu ebigimu ebirungi. Falaawo n’azuukuka, laba nga kibadde kirooto. ");
INSERT INTO lug_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Awo ku makya Falaawo ne yeeraliikirira; n’atumya ne baleeta abalogo bonna ab’e Misiri, n’abagezigezi baamu bonna; Falaawo n’abategeeza ekirooto kye, kyokka ne watabaawo n’omu eyasobola okukivvuunulira Falaawo. ");
INSERT INTO lug_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Awo omusenero wa Falaawo n’agamba Falaawo nti, “Ntegedde nasobya nnyo. ");
INSERT INTO lug_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Falaawo bwe yasunguwalira abaddu be, nze n’omukulu w’abafumbi n’atuteeka mu kkomera, ");
INSERT INTO lug_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ekiro kimu omukulu wa bafumbi nange twaloota ebirooto, nga buli kimu kirina amakulu ga njawulo ku kinnaakyo. ");
INSERT INTO lug_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Mu ffe mwalimu omuvubuka Omwebbulaniya nga muddu wa mukulu w’abambowa; bwe twamutegeeza nannyonnyola buli omu ekirooto kye nga bwe kyali. ");
INSERT INTO lug_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Nga bwe yatunnyonnyola era bwe kityo bwe kyali; nze nazzibwa ku mulimu gwange, ye omufumbiro, n’awanikibwa ku muti.” ");
INSERT INTO lug_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Awo Falaawo n’atumya baleete Yusufu, ne bamuleeta mangu okumuggya mu kkomera. Bwe yamala okumwebwa omutwe n’okukyusa engoye ze, n’ajja mu maaso ga Falaawo. ");
INSERT INTO lug_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Falaawo n’agamba Yusufu nti, “Naloose ekirooto, naye tewali n’omu ayinza kukivvuunula.” ");
INSERT INTO lug_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu n’addamu Falaawo nti, “Si nze nzija okukikola, wabula Katonda y’anaabuulira Falaawo amakulu gaakyo.” ");
INSERT INTO lug_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Awo Falaawo n’agamba Yusufu nti, “Laba, bwe nabadde nga nneebase ne ndoota nga nnyimiridde ku lubalama lw’omugga Kiyira; ");
INSERT INTO lug_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ente ennungi ensava musanvu ne ziva mu mugga ne ziriira mu bisaalu; ");
INSERT INTO lug_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ate ente endala ennafu embi ennyo enkovvu ze sirabangako mu nsi y’e Misiri nazo ne zijja. ");
INSERT INTO lug_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Awo ente embi enkovvu ne zirya ente ziri omusanvu ensava ezaasoose, ");
INSERT INTO lug_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","naye bwe zamaze okuzirya nga toyinza na kutegeera nti ziziridde, kubanga nga nkovvu nga bwe zaabadde olubereberye. Awo ne ndyoka nzuukuka. ");
INSERT INTO lug_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Ate era mu kirooto kyange nalabye ebirimba ebigimu ebirungi musanvu nga biri ku kiti kimu, ");
INSERT INTO lug_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","n’ebirimba ebirala musanvu ebikaze olw’empewo ez’ebbugumu ez’ebuvanjuba, nabyo ne bivaayo. ");
INSERT INTO lug_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ebirimba ebikaze ne bimira biri ebigimu. Ebyo nabitegeezezza abagezigezi ne wabulawo n’omu abivvuunula.” ");
INSERT INTO lug_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Awo Yusufu n’agamba Falaawo nti, “Ekirooto kya Falaawo kiri kimu: Katonda alaze Falaawo ky’agenda okukola. ");
INSERT INTO lug_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ente omusanvu ennungi gy’emyaka musanvu n’ebirimba omusanvu ebigimu gy’emyaka musanvu; ekirooto kiri kimu. ");
INSERT INTO lug_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ente omusanvu embi enkovvu ezajja oluvannyuma, gy’emyaka musanvu, n’ebirimba omusanvu ebikaze olw’empewo ez’ebbugumu ez’ebuvanjuba gy’emyaka omusanvu egy’enjala. ");
INSERT INTO lug_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Nga bwe ŋŋambye Falaawo, Katonda alaze Falaawo ekyo ky’agenda okukola. ");
INSERT INTO lug_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Wajja kubaawo emyaka musanvu egy’ekyengera mu nsi yonna ey’e Misiri, ");
INSERT INTO lug_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","naye oluvannyuma lwagyo waliddawo emyaka musanvu egy’enjala eryerabiza ekyengera mu nsi yonna ey’e Misiri; enjala eribuna ensi. ");
INSERT INTO lug_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ekyengera tekirimanyika n’akatono olw’enjala empitirivu era embi ennyo, eribuna Misiri yenna. ");
INSERT INTO lug_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ekirooto kya Falaawo kyekivudde kiddiŋŋanwa, kitegeeza nti ekintu Katonda akikakasa era ajja kukituukiriza mangu. ");
INSERT INTO lug_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Kale kaakano Falaawo alonde omusajja omukalabakalaba era ow’amagezi amuwe obuvunaanyizibwa ku nsi yonna ey’e Misiri. ");
INSERT INTO lug_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Era asseewo abalabirira balabirire ensi bakuŋŋaanye ekimu ekyokutaano eky’emmere ey’empeke yonna mu nsi ey’e Misiri okumalirako ddala emyaka omusanvu egy’ekyengera. ");
INSERT INTO lug_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Bakuŋŋaanye emmere eyo mu myaka egijja egy’ekyengera, bazimbe ebyagi ebinene mu buli kibuga bagikuŋŋaanyize omwo olw’ekiragiro kya Falaawo, bagikuume. ");
INSERT INTO lug_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Emmere eyo eriterekebwa olw’enjala eriba mu nsi okumalako emyaka omusanvu egy’enjala erigwa mu Misiri yonna; ensi ereme okuzikirizibwa enjala.” ");
INSERT INTO lug_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ebigambo bya Yusufu ne biwulikika bulungi mu matu ga Falaawo n’ag’abaweereza be bonna. ");
INSERT INTO lug_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Falaawo n’agamba abaweereza be nti, “Tuyinza okufuna omuntu ng’ono Yusufu omuli Omwoyo wa Katonda?” ");
INSERT INTO lug_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Awo Falaawo n’agamba Yusufu nti, “Katonda nga bw’akulaze bino byonna, tewali mulala mukalabakalaba, omugezi okukwenkana ggwe. ");
INSERT INTO lug_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Gw’onoofuganga olubiri lwange, era abantu bange banaakolanga kyonna ky’onoobalagiranga; wabula nze kabaka n’abanga waggulu wo.” ");
INSERT INTO lug_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Awo Falaawo n’agamba Yusufu nti, “Laba, nkutadde wo okufuga ensi yonna ey’e Misiri.” ");
INSERT INTO lug_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Olwo Falaawo n’alyoka aggya empeta ku ngalo ye n’aginaanika Yusufu, n’amwambaza ekyambalo ekya linena omulungi, n’omukuufu ogwa zaabu mu bulago bwe. ");
INSERT INTO lug_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","N’amuwa n’okutambuliranga mu ggaali lye eriddirira mu kitiibwa ng’erya Falaawo mwe yatambuliranga. Bonna ne bavuunama mu maaso ga Yusufu nga bwe bagamba nti, “Muvuuname.” Bw’atyo Falaawo n’amuteekawo okufuga ensi yonna ey’e Misiri. ");
INSERT INTO lug_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Falaawo n’agamba Yusufu nti, “Nze Falaawo, naye awatali kigambo kyo tewali muntu aliyimusa mukono gwe newaakubadde ekigere kye mu Misiri.” ");
INSERT INTO lug_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Falaawo n’atuuma Yusufu erinnya Zafenasipaneya; n’amuwa Asenaasi muwala wa Potiferi kabona wa Oni okuba mukazi we. Bw’atyo Yusufu n’atambula okubuna Misiri yonna. ");
INSERT INTO lug_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufu yali aweza emyaka amakumi asatu bwe yatandika okuweereza Falaawo, ye kabaka w’e Misiri. Awo Yusufu n’ava mu maaso ga Falaawo n’agenda n’abuna Misiri yenna. ");
INSERT INTO lug_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mu myaka omusanvu egy’ekyengera emmere yabala n’ekamala. ");
INSERT INTO lug_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusufu n’akuŋŋaanya emmere mu Misiri mu myaka omusanvu egy’ekyengera n’agiterekera mu byagi ebinene mu bibuga. Mu buli kibuga n’akuŋŋaanyizamu emmere eyavanga mu nnimiro ezikyetoolodde. ");
INSERT INTO lug_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufu n’atereka emmere mpitirivu, n’ebanga omusenyu ogw’oku nnyanja, okutuusa lwe yalekeraawo okugipima, nga tekisoboka kugipima. ");
INSERT INTO lug_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Omwaka ogw’enjala nga tegunnatuuka Yusufu yafuna abaana aboobulenzi babiri, Asenaasi, muwala wa Potiferi kabona wa Oni be yamuzaalira. ");
INSERT INTO lug_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Omwana eyasooka yamutuuma Manase, kubanga Yusufu yagamba nti, “Katonda anneerabizza obuzibu bwange bwonna, n’ennyumba ya kitange.” ");
INSERT INTO lug_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Owookubiri n’amutuuma Efulayimu, kubanga yagamba nti, “Katonda anjazizza mu nsi mwe nabonaabonera.” ");
INSERT INTO lug_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Awo emyaka omusanvu egy’ekyengera ekyali mu nsi y’e Misiri ne giggwaako. ");
INSERT INTO lug_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Emyaka omusanvu egy’enjala ne gitandika nga Yusufu bwe yayogera. Enjala n’egwa n’ebuna mu nsi zonna, kyokka yo mu Misiri nga emmere mweri. ");
INSERT INTO lug_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Enjala bwe yagwa mu Misiri, abantu ne bakaabira Falaawo olw’emmere. Falaawo n’agamba Abamisiri nti, “Mugende eri Yusufu; ky’anaabagamba, kye muba mukola.” ");
INSERT INTO lug_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kale enjala bwe yabuna Misiri, Yusufu n’asumulula ebyagi by’emmere byonna; n’aguza Abamisiri emmere. ");
INSERT INTO lug_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ensi zonna nazo ne zijja e Misiri eri Yusufu okugula emmere; kubanga enjala yayitirira mu nsi zonna. ");
INSERT INTO lug_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobo bwe yategeera nga mu Misiri eriyo emmere, n’agamba batabani be nti, “Lwaki mutunula butunuzi? ");
INSERT INTO lug_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Mpulidde nti mu Misiri eriyo emmere, muserengete mutugulireyo emmere, tube balamu, tuleme okufa.” ");
INSERT INTO lug_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Awo baganda ba Yusufu ekkumi ne baserengeta e Misiri okugula emmere. ");
INSERT INTO lug_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Kyokka Yakobo n’atasindika Benyamini, muto wa Yusufu wamu ne baganda be kubanga yatya nti akabi kayinza okumutuukako. ");
INSERT INTO lug_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Bwe batyo batabani ba Isirayiri ne bajja mu Misiri wamu n’abalala abajja okugula emmere, kubanga ensi ya Kanani yali ejjudde enjala. ");
INSERT INTO lug_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Mu kiseera ekyo Yusufu ye yali afuga Misiri; nga y’aguza abantu emmere. Awo baganda be ne bajja ne bamuvuunamira. ");
INSERT INTO lug_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufu n’abalaba n’abategeera, wabula n’abayisa nga b’atamanyi n’ayogera nabo n’obukambwe. N’ababuuza nti, “Muva wa?” Ne bamuddamu nti, “Tuva mu nsi ya Kanani, tuzze kugula mmere.” ");
INSERT INTO lug_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Bw’atyo Yusufu n’ategeera baganda be kyokka bo ne batamutegeera. ");
INSERT INTO lug_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Awo Yusufu n’ajjukira ebirooto bye ku bo. N’abagamba nti, “Muli bakessi; muzze kuketta nsi yaffe mulabe bw’eri ennafu.” ");
INSERT INTO lug_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ne bamuddamu nti, “Nedda mukama waffe; abaddu bo tuzze kugula mmere. ");
INSERT INTO lug_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ffenna tuli batabani ba musajja omu, tuli basajja ba mazima. Abaddu bo tetuli bakessi.” ");
INSERT INTO lug_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ye n’abaddamu nti, “Nedda muzze kulaba obunafu bw’ensi yaffe bwe buli.” ");
INSERT INTO lug_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ne bamuddamu nti, “Abaddu bo tuli kkumi na babiri, tuli baana ba muntu omu mu nsi ya Kanani, laba muto waffe n’olwa leero ali ne kitaffe, n’omulala yafa.” ");
INSERT INTO lug_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Naye Yusufu n’alumiriza nti, “Kiri nga bwe mbagambye, muli bakessi. ");
INSERT INTO lug_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Nzija kubategeerera ku kino, ndayidde obulamu bwa Falaawo temujja kuva wano, okuggyako nga muto wammwe aleeteddwa wano. ");
INSERT INTO lug_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mutume omu ku mmwe, aleete muganda wammwe, mwe mubeere mu kkomera, ebigambo byammwe byetegerezebwe obanga ddala bye mwogedde bya mazima. Oba si ekyo ndayidde obulamu bwa Falaawo, muli bakessi.” ");
INSERT INTO lug_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Awo n’abateeka bonna mu kkomera okumala ennaku ssatu. ");
INSERT INTO lug_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ku lunaku olwokusatu Yusufu n’abagamba nti, “Mukole bwe muti okuwonya obulamu bwammwe, kubanga ntya Katonda; ");
INSERT INTO lug_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","obanga ddala muli basajja b’amazima, omu ku baganda bammwe asigale ng’asibiddwa mu kkomera, abalala mugende mutwalire abantu bammwe emmere, ");
INSERT INTO lug_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","mundeetere muto wammwe, olwo ebigambo byammwe bikakasibwe muleme okufa.” Awo ne bakola bwe batyo. ");
INSERT INTO lug_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Awo ne bagambagana nti, “Ddala tuliko omusango gwa muganda waffe, kubanga twalaba nga mweraliikirivu, bwe yatwegayirira ne tutamuwuliriza; akabi kano kyekavudde katutuukako.” ");
INSERT INTO lug_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Lewubeeni kwe kubaddamu nti, “Nnabagamba muleme kukola kabi ku mulenzi, nga mmwe temumpuliriza; kale omusaayi gwe kyeguva gutuwalanwako.” ");
INSERT INTO lug_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ne batamanya nti Yusufu ategedde bye boogedde, kubanga bayogeranga naye nga bayita mu mutaputa. ");
INSERT INTO lug_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Awo Yusufu n’atunula ebbali n’akaaba, ate n’akyuka gye bali n’ayogera nabo. Awo n’atwala Simyoni n’amusiba nga balaba. ");
INSERT INTO lug_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","N’alagira bajjuze ensawo zaabwe eŋŋaano, era bazze ensimbi za buli omu mu nsawo ye, baweebwe n’entanda; ne bibakolerwa. ");
INSERT INTO lug_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Awo ne batikka endogoyi zaabwe eŋŋaano ne bagenda. ");
INSERT INTO lug_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Naye omu ku bo bwe yasumulula ensawo ye okuliisa endogoyi ye nga bali mu kifo mwe baasula, n’alaba ensimbi ze ku mumwa gw’ensawo; ");
INSERT INTO lug_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","n’agamba baganda be nti, “Ensimbi zange baazinzirizza, ziizino mu kamwa k’ensawo yange!” Ekyo ne kibeeralikiriza, buli omu n’atandika okutya, nga bwe bagamba nti, “Kiki kino Katonda ky’atukoze!” ");
INSERT INTO lug_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Bwe baakomawo mu nsi ya Kanani eri Yakobo kitaabwe ne bamutegeeza byonna ebyababaako, nga bagamba nti, ");
INSERT INTO lug_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Omusajja omufuzi w’ensi y’e Misiri yayogera naffe n’obukambwe era n’atuyisa nga abaali bagenze okuketta ensi ye. ");
INSERT INTO lug_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Naye ne tumugamba nti, Tuli basajja b’amazima, tetuli bakessi, ");
INSERT INTO lug_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","tuli abooluganda kumi na babiri, baana ba muntu omu, munnaffe yafa, ne muto waffe olwa leero ali ne kitaffe mu nsi ya Kanani. ");
INSERT INTO lug_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Awo omusajja oyo omufuzi w’ensi n’atugamba nti, ‘Ku kino kwennaategeerera nga muli beesigwa: muleke wano omu ku baganda bammwe, mutwale eŋŋaano olw’enjala eri mu maka gammwe. ");
INSERT INTO lug_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Mundeetere muto wammwe, kwe nnaategeerera nga temuli bakessi, muli basajja b’amazima, olwo ne ndyoka mbawa muganda wammwe, mulyoke mugule emmere mu nsi eno.’ ” ");
INSERT INTO lug_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bwe baatuuka eka, buli eyafukumulanga ensawo ye, laba ng’omuvumbo gw’ensimbi ze mweziri. Awo bo ne kitaabwe bwe baalaba emivumbo gy’ensimbi ne batya. ");
INSERT INTO lug_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yakobo kitaabwe n’abagamba nti, “Munzigyeko abaana bange: Yusufu taliiwo, ne Simyoni taliiwo ne kaakano mwagala muntwaleko Benyamini!” ");
INSERT INTO lug_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Awo Lewubeeni n’agamba kitaawe nti, “Ottanga batabani bange bombi, bwe sirikomyawo Benyamini gy’oli; mumpe, nange ndimukomyawo gy’oli.” ");
INSERT INTO lug_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Naye Yakobo n’agamba nti, “Mutabani wange tajja kuserengeta nammwe, kubanga muganda we yafa, era ye y’asigalawo yekka. Akabi bwe kalimutuukako mu lugendo lwe mugendako, muliserengesa envi zange emagombe nga nkyali munakuwavu.” ");
INSERT INTO lug_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Awo enjala bwe yayinga obungi mu nsi, ");
INSERT INTO lug_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","era nga ne mmere gye baggya e Misiri yonna eriiriddwa, kitaabwe n’abagamba nti mugende mutugulire emmere. ");
INSERT INTO lug_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Naye Yuda n’amuddamu nti, “Omusajja yatukuutirira ddala ng’agamba nti, ‘Temulinyanga ekigere mu maaso gange nga temuzze na muganda wammwe.’ ");
INSERT INTO lug_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Bw’onokkiriza tuserengete ne muganda waffe okugula emmere, olwo tunaagenda. ");
INSERT INTO lug_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Naye bw’otomukkirize kugenda naffe, tetujja kuserengeta, kubanga omusajja yatugamba nti, ‘Temugenda kulaba maaso gange nga muganda wammwe tali nammwe.’ ” ");
INSERT INTO lug_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isirayiri kwe kubaddamu nti, “Mwankola ki kino eky’obubalagaze ne mugamba omusajja nti mulina muganda wammwe omulala.” ");
INSERT INTO lug_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ne bagamba nti, “Omusajja yatubuuza nnyo ebitufaako awamu n’ebifa ku lulyo lwaffe, ng’abuuza nti, ‘Kitammwe gyali mulamu? Mulina muganda wammwe omulala?’ Kye twamutegeeza nga kiddamu buzzi ebibuuzo bye yatubuuzanga. Tetwamanya ng’anaatugamba okuserengesa muganda waffe.” ");
INSERT INTO lug_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Era Yuda n’agamba Isirayiri kitaawe nti, “Mpa omulenzi tulyoke tugende tube balamu, tuleme okufa enjala, ffe naawe n’abaana baffe. ");
INSERT INTO lug_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nze newaddeyo okumukuuma, olimubuuza nze. Bwe sirikumuddiza, ne mussa mu maaso go mbeereko omusango ennaku zonna. ");
INSERT INTO lug_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kubanga singa tetwalwa twandibadde tukomyewo omulundi ogwokubiri.” ");
INSERT INTO lug_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Awo Isirayiri kitaabwe n’abagamba nti, “Bwe kinaaba bwe kityo, kale mukole bwe muti: mutwale ebimu ku bibala bya muno mu nsawo zammwe, mutwalire omusajja ekirabo: envumbo ntono, n’omubisi, n’omugavu, n’obubaane ne mooli n’ebinyeebwa ne Alumoni. ");
INSERT INTO lug_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mutwale n’ensimbi za mirundi ebiri nga mutwala na ziri ezaali ku mimwa gye nsawo zammwe, osanga omuntu yakola nsobi. ");
INSERT INTO lug_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mutwale ne muganda wammwe, musituke muddeyo eri omusajja. ");
INSERT INTO lug_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Katonda Ayinzabyonna abawe omukisa mu maaso g’omusajja, alyoke aleke muganda wammwe oli awamu ne Benyamini bakomewo. Obanga obulumi bw’okufa kw’abaana bange bulintuukako, kale.” ");
INSERT INTO lug_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Awo ne batwala ebirabo n’ensimbi za mirundi ebiri, ne Benyamini ne baserengeta naye e Misiri ne bayimirira mu maaso ga Yusufu. ");
INSERT INTO lug_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Awo Yusufu bwe yalaba nga bali ne Benyamini n’agamba omuweereza we nti, “Bayingize mu nnyumba, otte ensolo ofumbe ekijjulo, kubanga abasajja abo baakulya nange ekyemisana.” ");
INSERT INTO lug_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Omusajja n’akola nga Yusufu bwe yamulagira, n’ayingiza abasajja mu nnyumba ya Yusufu. ");
INSERT INTO lug_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Abasajja ne batya olw’okutwalibwa mu nnyumba ya Yusufu, ne bagamba nti kino kizze lwa nsimbi ezatuddizibwa ne ziteekebwa mu nsawo zaffe omulundi guli, kyetuvudde tuleetebwa wano, anoonye ensonga ku ffe atuvunaane, atufuule abaddu awambe n’endogoyi zaffe. ");
INSERT INTO lug_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Awo ne bambuka n’omuweereza mu nnyumba ya Yusufu, ");
INSERT INTO lug_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ne bagamba nti Ayi mukama waffe, twajja omulundi ogwasooka okugula emmere, ");
INSERT INTO lug_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","bwe twatuuka mu kifo we twasula, ne tusumulula ensawo zaffe, nga mu buli kamwa k’ensawo ya buli omu mulimu ensimbi ze ezaali ez’okugula emmere, kyetuvudde tuzizza, ");
INSERT INTO lug_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","era tuleese n’endala olw’okugula emmere. Tetumanyi yateeka nsimbi mu nsawo zaffe. ");
INSERT INTO lug_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ye n’abaddamu nti, “Mubeere bagumu temutya. Katonda wammwe era Katonda wa kitammwe ye yabateekera obugagga mu nsawo zammwe; ensimbi zammwe nazifuna.” Awo kwe kubaleetera Simyoni. ");
INSERT INTO lug_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Omusajja bwe yamala okuyingiza abasajja abo mu nnyumba ya Yusufu, nga bamaze n’okunaaba ebigere, ng’amaze n’okuliisa endogoyi zaabwe, ");
INSERT INTO lug_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ne bateekateeka ekirabo kya Yusufu bakimuwe mu ttuntu, kubanga baamanya nga bajja kuliira eyo. ");
INSERT INTO lug_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu bwe yakomawo eka ne bamuleetera ekirabo kye baalina ne bamuvuunamira. ");
INSERT INTO lug_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","N’ababuuza bwe bali, n’ababuuza nti, “Kitammwe akyali mulamu bulungi?” ");
INSERT INTO lug_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ne bamuddamu nti, “Ssebo, kitaffe akyali mulamu era ali bulungi.” Ne bavuunama mu bukkakkamu. ");
INSERT INTO lug_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufu bwe yayimusa amaaso, n’alaba Benyamini muganda we, mutabani wa nnyina. N’ababuuza nti, “Ono ye muto wammwe gwe mwantegeezako? Katonda akuwe omukisa mwana wange.” ");
INSERT INTO lug_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Awo Yusufu n’ayanguwa okuva mu maaso gaabwe, kubanga omutima gwe gwalumwa olwa muganda we, n’anoonya ekifo w’anaakabira. N’alinnya mu kisenge kye n’akaabira eyo. ");
INSERT INTO lug_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","N’anaaba amaziga n’afuluma, n’aguma n’alagira emmere egabwe. ");
INSERT INTO lug_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ye ne bamuwa eyiye yekka, ne baganda be bokka, n’Abamisiri abalya naye nabo ne bagabulwa bokka, kubanga Abamisiri tebalyanga n’Abaebulaniya, kubanga kyali kivve eri Abamisiri. ");
INSERT INTO lug_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Awo baganda ba Yusufu ne batuula mu maaso ge nga baddiriŋŋana okuva ku mukulu mu buzaale bwabwe okutuuka ku muto; ne batunulaganako nga beewuunya. ");
INSERT INTO lug_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusufu n’abakoleza ebitole okuva ku mmeeza ye, naye ekitole kya Benyamini ne kisinga ekya baganda be emirundi etaano. Bwe batyo ne balya ne basanyukira wamu ne Yusufu. ");
INSERT INTO lug_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Awo Yusufu n’alagira omuweereza mu nnyumba ye nti, “Jjuza ensawo z’abasajja emmere nga bwe basobola okugyetikka, era oteeke ensimbi za buli omu mu nsawo ye. ");
INSERT INTO lug_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Era oteeke ekikopo kyange, ekya ffeeza, mu kamwa k’ensawo ya muto waabwe, wamu n’ensimbi ze ez’okugula emmere.” N’akola nga Yusufu bwe yamugamba. ");
INSERT INTO lug_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Emmambya eba evaayo abasajja ne basiibulwa n’endogoyi zaabwe. ");
INSERT INTO lug_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Bwe baali baakava mu kibuga Yusufu n’agamba omuweereza we nti, “Golokoka obagoberere bw’obatuukako obabuuze nti, ‘Lwaki musasudde ekibi olw’ebirungi? Lwaki mubbye ekikopo kyange ekya ffeeza? ");
INSERT INTO lug_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Mu kino mukama wange si mwanywera, era si kyalaguza? Mu ekyo mukoze bubi.’ ” ");
INSERT INTO lug_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Bwe yabatuukako n’abategeeza ebigambo ebyo. ");
INSERT INTO lug_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ne bamugamba nti, “Mukama waffe lwaki ayogedde ebigambo ebyo? Olowooza tuli bantu ba ngeri ki abayinza okukola ekintu ng’ekyo? ");
INSERT INTO lug_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Laba, ensimbi ze twasanga ku mimwa gy’ensawo zaffe twazikuddiza okuva mu nsi ya Kanani, kale twandisobodde tutya okubba ffeeza oba zaabu okuva mu nnyumba ya mukama wo? ");
INSERT INTO lug_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Oyo gw’onookisanga nakyo mu ffe abaddu bo, afe, era naffe tuliba baddu ba mukama wange.” ");
INSERT INTO lug_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","N’abaddamu nti, “Kale kibeere nga bwe mwogedde, oyo anaasangibwa nakyo abeere muddu wange, naye abalala mu mmwe tewaabe abaako ky’avunaanwa.” ");
INSERT INTO lug_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Amangwago buli omu nassa ensawo ye wansi n’agisumulula. ");
INSERT INTO lug_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","N’alyoka abaaza ng’asookera ku asinga obukulu okutuuka ku asembayo obuto; ekikopo ne kisangibwa mu nsawo ya Benyamini. ");
INSERT INTO lug_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Awo ne bayuza engoye zaabwe, buli omu n’atikka endogoyi ye, ne baddayo mu kibuga. ");
INSERT INTO lug_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yusufu yali akyali mu nju, Yuda ne baganda be bwe baatuuka gy’ali, ne bagwa mu maaso ge ne bamuvuunamira. ");
INSERT INTO lug_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu n’abagamba nti, “Kiki kino kye mukoze? Temumanyi nti omuntu ali nga nze asobola okuvumbula kye mukoze?” ");
INSERT INTO lug_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda n’addamu nti, “Tunaddamu ki mukama wange? Tunaayogera ki? Oba tuneggyako tutya omusango? Katonda avumbudde obwonoonyi bw’abaddu bo, laba tuli baddu ba mukama wange, ffenna, ffe n’oyo asangiddwa n’ekikopo.” ");
INSERT INTO lug_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusufu n’addamu nti, “Ekyo sijja kukikola, wabula oyo asangiddwa n’ekikopo, y’anaaba omuddu wange, naye mmwe mwambuke mirembe, mutuuke eri kitammwe.” ");
INSERT INTO lug_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Awo Yuda n’alaga eri Yusufu n’agamba nti, “Ayi mukama wange nkusaba omuddu wo abeeko kyayogera gy’oli, n’obusungu bwo buleme kubuubuuka eri omuddu wo; kubanga oli nga Falaawo yennyini. ");
INSERT INTO lug_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mukama wange yabuuza abaweereza be nti, ‘Mulina kitammwe oba muganda wammwe?’ ");
INSERT INTO lug_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ne tuddamu mukama wange nti, ‘Tulina kitaffe, musajja mukulu, ne muganda waffe atusinga obuto, omwana gwe yazaala mu bukadde bwe, ne muganda wa muto waffe, yafa; muto waffe yekka y’aliwo, eyasigalawo yekka ku baana ba nnyina; era kitaawe amwagala nnyo.’ ");
INSERT INTO lug_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“N’olyoka ogamba abaddu bo nti, ‘Mumundeetere, mmulabeko.’ ");
INSERT INTO lug_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Twategeeza mukama wange nti, ‘Omulenzi tayinza kuva ku kitaawe, kubanga bw’amuvaako, kitaawe alifa bufi!’ ");
INSERT INTO lug_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","N’oddamu abaddu bo nti, ‘Muto wammwe bw’ataliserengeta nammwe, temugenda kulaba maaso gange.’ ");
INSERT INTO lug_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Bwe twaddayo eri omuddu wo kitaffe, twamutegeeza ebigambo ebyo, mukama wange. ");
INSERT INTO lug_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Kale kitaffe bwe yagamba nti, ‘Muddeeyo mutugulire ku mmere,’ ");
INSERT INTO lug_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ne tumuddamu nti, ‘Tetusobola kuserengeta. Muto waffe bw’atagenda naffe tetujja kugenda kubanga tetusobola kulaba maaso ga musajja oli nga muto waffe tali naffe.’ ");
INSERT INTO lug_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Awo omuddu wo, kitaffe n’atugamba nti, ‘Mumanyi, mukazi wange yanzaalira abaana abalenzi babiri; ");
INSERT INTO lug_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","omu yambulako, ne njogera nti mazima yataagulwataagulwa; era siddangayo kumulaba. ");
INSERT INTO lug_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Bwe muntwalako n’ono, akabi ne kamutuukako, muliserengesa envi zange emagombe nga nkungubaga.’ ");
INSERT INTO lug_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Kale kaakano, bwe nzirayo eri omuddu wo kitange ng’omulenzi tali naffe, obulamu bwe nga bwe bunyweredde ku bw’omulenzi, ");
INSERT INTO lug_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","bw’anaalaba ng’omulenzi tali naffe, ajja kufa, n’abaddu bo baliserengesa envi z’omuddu wo kitaffe emagombe ng’akyakungubagira omwana we. ");
INSERT INTO lug_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Kubanga omuweereza wo yeeyimirira omulenzi eri kitange; nga ŋŋamba nti, ‘Bwe sirimuzza gy’oli ndiba n’obuvunaanyizibwa n’okunenyezebwa ennaku zonna ez’obulamu bwange.’ ");
INSERT INTO lug_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Kale kaakano nkwegayirira, omuddu wo nsigale ng’omuddu wa mukama wange, mu kifo ky’omulenzi; omulenzi omuleke addeyo ne baganda be. ");
INSERT INTO lug_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kale n’addayo ntya eri kitange ng’omulenzi tali nange? Ntya okulaba akabi akayinza okutuuka ku kitange.” ");
INSERT INTO lug_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Awo Yusufu n’atasobola kwefuga n’alemererwa okwongera okwekuuma mu maaso gaabo bonna abaaliwo; kwe kulagira nti, “Muggyeewo abantu bonna mu maaso gange.” Bwe kityo ne wataba muntu mulala yenna Yusufu bwe yali yeeraga eri baganda be. ");
INSERT INTO lug_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Awo n’akaaba mu ddoboozi ery’omwanguka, n’Abamisiri ne bamuwulira era n’ennyumba yonna eya Falaawo nabo ne bamuwulira. ");
INSERT INTO lug_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu n’agamba baganda be nti, “Nze Yusufu, kitange akyali mulamu?” Naye baganda be ne batayinza kumuddamu, kubanga okweraliikirira kwabayinga mu maaso ge. ");
INSERT INTO lug_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Awo Yusufu n’agamba baganda be nti, “Mbasaba munsemberere.” Ne basembera gy’ali. N’abagamba nti, “Nze muganda wammwe Yusufu gwe mwatunda e Misiri. ");
INSERT INTO lug_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Naye kaakano temuggwaamu mwoyo, oba temwekubagiza olw’okuntunda wano, kubanga Katonda yantuma mbasookeyo nsobole okuwonya obulamu. ");
INSERT INTO lug_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kubanga enjala ebadde mu nsi okumala emyaka gino ebiri; era wakyaliyo emirala etaano egitalibaamu kulima wadde okukungula. ");
INSERT INTO lug_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Era Katonda yantuma mbasookeyo mbakuumire abalisigalawo ku nsi; ndyoke mbawonyezeewo abantu abangi ennyo mu ngeri ey’ekitalo. ");
INSERT INTO lug_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Noolwekyo si mmwe mwansindika wano, wabula Katonda; era anfudde kitaawe wa Falaawo, era mukama w’ennyumba ye era omufuzi w’ensi yonna ey’e Misiri. ");
INSERT INTO lug_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Kale mwanguwe, mwambuke eri kitange mumugambe nti, ‘Bw’ati mutabani wo Yusufu bw’agamba nti, Katonda anfudde mufuzi wa Misiri yenna; serengeta gye ndi, tolwa; ");
INSERT INTO lug_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ojja kubeera mu Goseni, olibeera kumpi nange. Ggwe n’abaana bo, n’abaana b’abaana bo, ebisibo byammwe, amagana gammwe ne byonna bye mulina; ");
INSERT INTO lug_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","eyo gye nnaabagabiririranga; si kulwa nga mmwe n’ennyumba zammwe ne byonna bye mulina biggwaawo.’ ");
INSERT INTO lug_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Era kaakano mwerabiddeko n’amaaso gammwe era ne muganda wange Benyamini akyerabiddeko nti nze njogera nammwe. ");
INSERT INTO lug_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Muteekwa okutegeeza kitange ekitiibwa kye nnina mu Misiri, ne byonna bye mulabye. Temulwa, muserengese kitange wano.” ");
INSERT INTO lug_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Awo Yusufu n’agwa Benyamini mu kifuba n’akaaba ne Benyamini n’akaabira ku kibegabega kye. ");
INSERT INTO lug_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","N’agwa baganda be mu kifuba, n’akaabira buli omu ku bo; n’oluvannyuma baganda be ne boogera naye. ");
INSERT INTO lug_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ebigambo eby’okujja kwa baganda ba Yusufu bwe byawulirwa mu nnyumba ya Falaawo ne bisanyusa nnyo Falaawo n’abaweereza be. ");
INSERT INTO lug_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Falaawo n’agamba Yusufu nti, “Gamba baganda bo nti, ‘Mukole bwe muti: mutikke ensolo zammwe muddeyo mu nsi ya Kanani, ");
INSERT INTO lug_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","munone kitammwe n’abantu bammwe n’ebyammwe mujje gye ndi, ndibawa ekifo ekisinga obulungi mu nsi y’e Misiri, nammwe mulirya obulungi obw’ensi.’ ");
INSERT INTO lug_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Era balagire batwale amagaali okuva mu nsi y’e Misiri olw’abaana baabwe abato ne bakyala bammwe, mujje ne kitammwe. ");
INSERT INTO lug_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Wabula ebintu byammwe tebibateganya nnyo, kubanga ebisinga obulungi mu Misiri yenna bijja kuba byammwe.” ");
INSERT INTO lug_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Abaana ba Isirayiri ne bakola bwe batyo; Yusufu n’abawa amagaali, nga Falaawo bwe yalagira n’abawa n’entanda ey’omu kkubo. ");
INSERT INTO lug_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Buli omu ku bo n’amuwa ebyambalo eby’okukyusa, naye ye Benyamini n’amuwa ebitundu bya ffeeza ebikumi bisatu n’ebyambalo eby’okuwanyisa emigogo etaano. ");
INSERT INTO lug_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Kitaawe n’amuweereza endogoyi kkumi ezeetisse ebintu ebirungi eby’e Misiri n’endogoyi enkazi kkumi ezeetisse emmere, emigaati n’entanda ya kitaawe bw’aliba ajja. ");
INSERT INTO lug_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Awo n’asiibula baganda be. Bwe baali bagenda n’abagamba nti, “Temuyombera mu kkubo.” ");
INSERT INTO lug_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Bwe batyo ne bambuka okuva mu Misiri ne batuuka mu nsi ya Kanani eri kitaabwe Yakobo. ");
INSERT INTO lug_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Bwe baatuuka ne bamutegeeza nti Yusufu akyali mulamu, era y’afuga ensi y’e Misiri yonna. Bwe yawulira ebyo n’awunga n’atasobola kubakkiriza. ");
INSERT INTO lug_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Naye bwe baamutegeeza ebigambo bya Yusufu byonna bye yabagamba, era bwe yalaba amagaali Yusufu ge yaweereza okumutwala n’addamu omwoyo; ");
INSERT INTO lug_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","n’agamba nti, “Mmatidde, omwana wange Yusufu akyali mulamu. Nzija kugenda mulabe nga sinnafa.” ");
INSERT INTO lug_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Awo Isirayiri n’addira byonna bye yalina, n’atandika olugendo; bwe yatuuka e Beriseba n’awaayo ssaddaaka eri Katonda wa kitaawe Isaaka. ");
INSERT INTO lug_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Katonda n’ayogera ne Isirayiri mu kwolesebwa ekiro, n’amuyita nti, “Yakobo, Yakobo?” N’amuddamu nti, “Nze nzuuno.” ");
INSERT INTO lug_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Katonda n’amugamba nti, “Nze Katonda, Katonda wa kitaawo; totya kuserengeta Misiri, kubanga ndi kufuulirayo eyo eggwanga eddene. ");
INSERT INTO lug_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nzija kuserengeta naawe e Misiri, era ndi kuggyayo; era olifiira mu mikono gya Yusufu.” ");
INSERT INTO lug_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Awo Yakobo n’ava e Beriseba, batabani be ne bamutwalira wamu n’abaana baabwe abato, ne bakazi baabwe ne babassa mu magaali Falaawo ge yaweereza okumutwala. ");
INSERT INTO lug_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Era ne batwala ebisibo n’ebintu byabwe bye baafunira mu nsi ya Kanani ne batuuka e Misiri, Yakobo wamu n’ezzadde lye. ");
INSERT INTO lug_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Batabani be ne bazzukulu be, bawala be n’abaana ba bawala be; ezzadde lye lyonna n’alireeta mu Misiri wamu naye. ");
INSERT INTO lug_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Gano ge mannya g’abazzukulu ba Isirayiri abaagenda e Misiri ne Yakobo: Lewubeeni mutabani wa Yakobo omubereberye, ");
INSERT INTO lug_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ne batabani ba Lewubeeni: Kanoki, ne Palu, ne Kezulooni ne Kalumi. ");
INSERT INTO lug_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ne batabani ba Simyoni: Yamweri, ne Yamini, ne Okadi, ne Yakini, ne Zokali ne Sawuli omwana w’omukazi Omukanani. ");
INSERT INTO lug_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ne batabani ba Leevi: Gerusoni, ne Kokasi ne Merali. ");
INSERT INTO lug_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","N’aba Yuda: Eri, ne Onani, ne Seera, ne Pereezi ne Zeera; naye bo Eri ne Onani baafiira mu nsi ya Kanani. Batabani ba Pereezi baali: Kezulooni ne Kamuli. ");
INSERT INTO lug_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Bo aba Isakaali baali: Tola, ne Puva, ne Yobu ne Simuloni. ");
INSERT INTO lug_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Batabani ba Zebbulooni baali Seredi, ne Eroni ne Yaleeri. ");
INSERT INTO lug_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Abo be batabani ba Leeya be yazaalira Yakobo nga bali mu Padanalaamu, omuwala ye yali Dina. Abaana bonna aboobulenzi n’aboobuwala baali amakumi asatu mu basatu. ");
INSERT INTO lug_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Batabani ba Gaadi baali Zifiyooni, ne Kagi, ne Suni, ne Ezuboni, ne Eri, ne Alodi ne Aleri. ");
INSERT INTO lug_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Bo batabani ba Aseri be bano: Imuna, ne Isuva, ne Isuvi, ne Beriya awamu ne Seera mwannyinaabwe. Bo Batabani ba Beriya baali Keba ne Malukiyeeri. ");
INSERT INTO lug_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Bano be batabani ba Zirupa, Labbaani gwe yawa Leeya muwala we, be yazaalira Yakobo; abantu kkumi na mukaaga. ");
INSERT INTO lug_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Batabani ba Laakeeri, mukazi wa Yakobo be bano Yusufu ne Benyamini. ");
INSERT INTO lug_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Aba Yusufu ng’ali e Misiri baali Manase ne Efulayimu, Asenaasi muwala wa Potiferi kabona wa Oni be yamuzaalira. ");
INSERT INTO lug_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ne batabani ba Benyamini be ba: Bera, ne Bekeri, ne Asuberi, ne Gera, ne Naamani, ne Eki, ne Losi, ne Mupimu, ne Kupimu ne Aludi. ");
INSERT INTO lug_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Abantu abasibuka mu Laakeeri mukazi wa Yakobo baali kkumi na bana. ");
INSERT INTO lug_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mutabani wa Ddaani ye Kusimu. ");
INSERT INTO lug_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Bo aba Nafutaali be ba: Yazeeri, ne Guni, ne Yezeri, ne Siremu. ");
INSERT INTO lug_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bano be baava mu Biira mukazi wa Yakobo, Labbaani gwe yawa Laakeeri muwala we; bonna be bantu musanvu. ");
INSERT INTO lug_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Abantu bonna aba Yakobo abajja mu Misiri, ab’enda ye nga totaddeeko baka baana be, baali abantu nkaaga mu mukaaga. ");
INSERT INTO lug_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Batabani ba Yusufu abaamuzaalirwa ng’ali mu Misiri baali babiri. Abantu bonna ab’ennyumba ya Yakobo abajja e Misiri baali nsanvu. ");
INSERT INTO lug_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakobo n’atuma Yuda eri Yusufu ajje amusisinkane mu Goseni, ne batuuka e Goseni. ");
INSERT INTO lug_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Awo Yusufu n’ateekateeka eggaali lye n’agenda okusisinkana Isirayiri kitaawe e Goseni, n’amweraga, n’amugwa mu kifuba n’akaabira mu kifuba kye okumala akabanga. ");
INSERT INTO lug_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isirayiri n’agamba Yusufu nti, “Kale kaakano ka nfe, kubanga ndabye amaaso go ne ntegeera nti okyali mulamu.” ");
INSERT INTO lug_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusufu n’agamba baganda be n’ab’ennyumba ya kitaawe nti, “Nzija kugenda eri Falaawo mugambe nti, ‘Baganda bange n’ennyumba ya kitange abaali mu nsi ya Kanani bazze gye ndi. ");
INSERT INTO lug_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Kyokka balunzi; balunda ente era baleese amagana gaabwe n’ebisibo byabwe ne byonna bye balina.’ ");
INSERT INTO lug_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kale Falaawo bw’abayita n’ababuuza nti, ‘Mukola mulimu ki?’ ");
INSERT INTO lug_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Mumuddemu nti, ‘Abaweereza bo kasookedde tuzaalibwa tuli balunzi, ffe ne bajjajjaffe.’ Mulyoke mubeere mu nsi ya Goseni, kubanga abalunzi baamuzizo eri Abamisiri.” ");
INSERT INTO lug_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Awo Yusufu n’agenda eri Falaawo n’amugamba nti, “Kitange ne baganda bange n’amagana gaabwe n’ebisibo byabwe ne byonna bye balina bazze nga bava mu Kanani; kaakano bali Goseni.” ");
INSERT INTO lug_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yalondako bataano ku baganda be, n’agenda nabo ewa Falaawo. ");
INSERT INTO lug_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Falaawo n’ababuuza nti, “Omulimu gwammwe mulimu ki?” Ne bamuddamu nti, “Abaweereza bo tuli balunzi nga bajjajjaffe. ");
INSERT INTO lug_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Tuzze muno kunoonyeza bisibo byaffe muddo, kubanga abaddu bo tuva mu njala mpitirivu eri mu Kanani; ne kaakano abaddu bo tukusaba tubeere e Goseni.” ");
INSERT INTO lug_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Awo Falaawo n’agamba Yusufu nti, “Kitaawo ne baganda bo bazze gy’oli. ");
INSERT INTO lug_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ensi y’e Misiri gw’ogirinako obuyinza, teeka kitaawo ne baganda bo awasinga obulungi; bateeke e Goseni. Era obanga omanyi asobola mu bo muwe akuume ente zange.” ");
INSERT INTO lug_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Awo Yusufu n’ayingiza Yakobo, kitaawe n’amwanjula eri Falaawo. Yakobo n’asabira Falaawo omukisa. ");
INSERT INTO lug_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Falaawo n’abuuza Yakobo nti, “Olina emyaka emeka?” ");
INSERT INTO lug_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobo n’addamu nti, “Emyaka egy’olugendo lwange mu nsi giri kikumi mu amakumi asatu; emyaka gyange gibadde mitono era mizibu; siwangadde nga bajjajjange.” ");
INSERT INTO lug_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Olwo Yakobo n’asabira Falaawo omukisa n’ava mu maaso ga Falaawo. ");
INSERT INTO lug_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Awo Yusufu n’asenza kitaawe ne baganda be e Misiri, n’abawa ekitundu ekyali kisinga obulungi eky’e Goseni, mu Disitulikiti ey’e Lamusesi nga Falaawo bwe yalagira. ");
INSERT INTO lug_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusufu n’awa kitaawe ne baganda be n’ab’ennyumba ya kitaawe emmere ng’omuwendo gw’abaana baabwe bwe gwali. ");
INSERT INTO lug_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Awo emmere n’eggwa mu kitundu ekyo kyonna kubanga enjala yayitirira obungi, ne kireetera ensi y’e Misiri ne Kanani okukosebwa ennyo. ");
INSERT INTO lug_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusufu n’akuŋŋaanya ensimbi zonna ezaali mu Misiri ne mu Kanani ng’abaguza emmere; n’azireeta mu lubiri lwa Falaawo. ");
INSERT INTO lug_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Awo ensimbi bwe zaggwa ku bantu b’e Misiri ne Kanani ne bajja eri Yusufu ne bamugamba nti, “Tuwe emmere. Ensimbi zituweddeko. Lwaki tufa?” ");
INSERT INTO lug_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu n’abagamba nti, “Kale obanga ensimbi zibaweddeko mundeetere ensolo zammwe mbaguze emmere.” ");
INSERT INTO lug_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Awo ne bamuleetera amagana g’ensolo zaabwe, omwali embalaasi, n’endiga, n’ente, n’endogoyi, okubiwaanyisaamu emmere; emmere eyo n’ebayisa mu mwaka ogwo. ");
INSERT INTO lug_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Omwaka ogwo bwe gwaggwaako, ne bajja eri Yusufu mu mwaka ogwaddirira ne bamugamba nti, “Tetuukukise mukama waffe, ensimbi zituweddeko n’ensolo zaffe zifuuse zizo tewali kye tusigazza, wabula emibiri gyaffe gino n’ebyalo byaffe. ");
INSERT INTO lug_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tufiira ki nga w’oli? Tugule ffe n’ebyalo byaffe otuwe emmere tuleme okufa, naffe tuliba baddu ba Falaawo, ensi yaffe ereme okuzikirira.” ");
INSERT INTO lug_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Bw’atyo Yusufu n’agulira Falaawo ensi yonna ey’e Misiri. Abamisiri kinoomu, bonna ne batunda ebyalo byabwe kubanga enjala yali mpitirivu, ensi yonna n’efuuka ya Falaawo. ");
INSERT INTO lug_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Bwe batyo n’abantu baamu okuva ku njuyi zonna ne bafuuka baddu ba Falaawo. ");
INSERT INTO lug_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ekitundu kya bakabona kye kyokka ky’ataagula, kubanga bo baasasulwanga Falaawo. Kye yabasasulanga kwe beeguliranga ebyokulya; bo kyebaava batatunda ttaka lyabwe. ");
INSERT INTO lug_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Awo Yusufu n’agamba abantu nti, “Mulabe, olwa leero mbaguze mmwe n’ebyalo byammwe; mbagulidde Falaawo. Kale kaakano ensigo zino zammwe munaazisiga. ");
INSERT INTO lug_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Bwe mulikungula, muliwa Falaawo ekitundu kimu kyakutaano, ebitundu bina bya kutaano biriba byammwe, okuba ensigo mu nnimiro zammwe, n’emmere ku lwammwe n’ab’ennyumba zammwe n’abaana bammwe.” ");
INSERT INTO lug_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ne bamuddamu nti, “Otuwonyezza okufa; mukama waffe bw’anaasiima tuliba baddu ba Falaawo.” ");
INSERT INTO lug_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Awo Yusufu n’ateeka etteeka erikwata ku ttaka mu nsi y’e Misiri; weeliri n’okutuusa kaakano, nti ekitundu kimu kyakutaano kiba musolo gwa Falaawo; ettaka ly’abakabona lyokka lye litaafuuka lya Falaawo. ");
INSERT INTO lug_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Bw’atyo Isirayiri n’abantu be ne babeera mu nsi y’e Misiri, mu Goseni, ne bagaggawalira mu kitundu ekyo. Baazaala ne baala nnyo. ");
INSERT INTO lug_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobo n’amala mu Misiri emyaka kkumi na musanvu. Bw’atyo Yakobo n’awangaala emyaka kikumi mu ana mu musanvu. ");
INSERT INTO lug_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ekiseera eky’okufa kwa Isirayiri bwe kyali kisembedde, n’ayita mutabani we Yusufu n’amugamba nti, “Obanga nfunye ekisa mu maaso go teeka omukono gwo wansi w’ekisambi kyange, ondayirire ng’onompulira n’otonkuusakuusa: tonziikanga mu Misiri, ");
INSERT INTO lug_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","onteekanga wamu ne bajjajjange. Olintwala n’onziika ku butaka.” Yusufu n’amuddamu nti, “Ndikola nga bw’ogambye.” ");
INSERT INTO lug_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","N’amugamba nti, “Ndayirira.” N’amulayirira. Awo Isirayiri n’akoteka omutwe gwe ng’atudde emitwetwe w’ekitanda kye. ");
INSERT INTO lug_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Oluvannyuma Yusufu n’ategeezebwa nti, “Laba, kitaawo mulwadde.” Bw’atyo n’atwala batabani be Manase ne Efulayimu; ");
INSERT INTO lug_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakobo n’ategeezebwa nti, “Mutabani wo azze okukulaba.” Awo Yakobo ne yeekakaba ku kitanda kye n’atuula. ");
INSERT INTO lug_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","N’agamba Yusufu nti, “Katonda Ayinzabyonna yandabikira e Luzi mu nsi ya Kanani n’ampa omukisa. ");
INSERT INTO lug_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","N’aŋŋamba nti, ‘Laba, ndikwaza n’osukkirira ne nkufuula abantu abangi, era ensi eno ndigiwa ezzadde lyo okuba obutaka bwabwe ennaku zonna.’ ");
INSERT INTO lug_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Kale kaakano batabani bo bombi abaakuzaalirwa mu Misiri nga sinnajja, bange; Efulayimu ne Manase baliba bange nga Lewubeeni ne Simyoni bwe bali. ");
INSERT INTO lug_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","N’abo abaakuzaalirwa oluvannyuma lwabwe baliba babo, banaayitibwa amannya ga baganda baabwe mu mugabo gwabwe. ");
INSERT INTO lug_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kubanga bwe najja ng’ava e Paddani, ne ndaba ennaku Laakeeri n’anfiirako mu kkubo mu nsi ya Kanani, nga nkyagenda Efulasi; ne mmuziika eyo mu kkubo erigenda Efulasi, ye Besirekemu.” ");
INSERT INTO lug_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Isirayiri bwe yalaba batabani ba Yusufu n’abuuza nti, “Bano be baani?” ");
INSERT INTO lug_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu n’addamu kitaawe nti, “Be batabani bange, Katonda b’ampeeredde wano.” N’amugamba nti, “Nkusaba obansembereze mbasabire omukisa.” ");
INSERT INTO lug_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Mu kiseera kino amaaso ga Isirayiri gaali gayimbadde olw’obukadde, nga takyasobola kulaba. Awo Yusufu n’abamusembereza, Yakobo n’abagwa mu kifuba n’abanywegera. ");
INSERT INTO lug_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isirayiri n’agamba Yusufu nti, “Saasuubira kulaba maaso go; era laba Katonda ansobozesezza okulaba n’abaana bo.” ");
INSERT INTO lug_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Awo Yusufu n’abaggya ku maviivi ge n’avuunama wansi. ");
INSERT INTO lug_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yusufu n’abatwala bombi, Efulayimu ng’ali mu mukono gwe ogwa ddyo, okwolekera ogwa Isirayiri ogwa kkono, ne Manase ng’ali mu mukono gwe ogwa kkono okwolekera ogwa Isirayiri ogwa ddyo, n’abamusembereza. ");
INSERT INTO lug_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Isirayiri n’agolola omukono gwe ogwa ddyo n’aguteeka ku mutwe gwa Efulayimu eyali omuto, n’omukono gwe ogwa kkono n’aguteeka ku mutwe gwa Manase, n’ayisiŋŋanya emikono gye, kubanga Manase ye yasooka okuzaalibwa. ");
INSERT INTO lug_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","N’awa Yusufu omukisa, n’agamba nti, “Katonda wa jjajjange Ibulayimu ne kitange Isaaka gwe baatambulira mu maaso ge, Katonda oyo ankulembedde obulamu bwange bwonna okutuusa leero, ");
INSERT INTO lug_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Malayika oyo eyannunula okuva mu bizibu byonna, owe omukisa abalenzi bano. Erinnya lyange lyeyongerenga okutuumibwa mu bo era n’erya Ibulayimu n’erya Isaaka. Era bafuuke ekibiina ekinene mu maaso g’ensi.” ");
INSERT INTO lug_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufu bwe yalaba nga kitaawe atadde omukono gwe ogwa ddyo ku Efulayimu n’atakyagala, n’akwata omukono gwa kitaawe okuguggya ku mutwe gwa Efulayimu aguzze ku mutwe gwa Manase. ");
INSERT INTO lug_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","N’agamba kitaawe nti, “Kireme kuba kityo, kitange, kubanga ono ye mubereberye, teeka omukono ogwa ddyo ku mutwe gwe.” ");
INSERT INTO lug_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Naye kitaawe n’agaana n’agamba nti, “Mmanyi, mwana wange, mmanyi nti alifuuka eggwanga era aliba mukulu; kyokka muto we aliba mukulu okumusinga era alivaamu amawanga mangi.” ");
INSERT INTO lug_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Awo n’abasabira omukisa ku lunaku olwo ng’agamba nti, “Abaana ba Isirayiri basabiragane omukisa nga bagamba nti, ‘Katonda akuyise nga Efulayimu ne Manase.’ ” Bw’atyo n’ateeka Efulayimu mu maaso ga Manase. ");
INSERT INTO lug_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ate Isirayiri n’agamba Yusufu nti, “Laba, nnaatera okufa, kyokka Katonda alibeera naawe era alikuzzaayo mu nsi ya bajjajjaabo. ");
INSERT INTO lug_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Wabula ggwe nkuwadde kinene okusinga baganda bo, nkuwadde ekitundu kimu ekikkirira olusozi, kye naggya ku Bamoli n’ekitala kyange n’omutego gwange.” ");
INSERT INTO lug_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Awo Yakobo n’ayita batabani be n’abagamba nti, Mukuŋŋaane, ndyoke mbategeeze ebiribabaako mu nnaku ezijja. ");
INSERT INTO lug_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Mukuŋŋaane muwulire, mwe abaana ba Yakobo, muwulirize Isirayiri kitammwe. ");
INSERT INTO lug_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Lewubeeni ggwe mubereberye wange, amaanyi gange, ebibala ebibereberye eby’amaanyi gange, ekitiibwa n’obuyinza ebiyitirivu. ");
INSERT INTO lug_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Naye tafugika, oli ng’amayengo g’ennyanja, naye tokyali wa kitiibwa, kubanga walinnya ekitanda kya kitaawo, mu nnyumba yange, n’okyonoona. ");
INSERT INTO lug_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simyoni ne Leevi baaluganda, ebitala byabwe byakulwanyisa bya maanyi. ");
INSERT INTO lug_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ayi omwoyo gwange teweetaba mu kuteesa kwabwe. Ayi omwoyo gwange teweegatta nabo. Kubanga mu busungu bwabwe batta abantu, olw’okwekulumbaza kwabwe baatema ente olunywa. ");
INSERT INTO lug_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Obusungu bwabwe bukolimirwe, kubanga bungi; n’obukambwe bwabwe, kubanga bwa ttima. Ndibaawula mu Yakobo, ndibasaasaanya mu Isirayiri. ");
INSERT INTO lug_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda gwe baganda bo banaakutenderezanga. Omukono gwo gunaatulugunyanga abalabe bo. Abaana ba kitaawo banaakuvuunamiranga. ");
INSERT INTO lug_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, mwana w’empologoma. Oyambuse mwana wange, ng’ovudde ku muyiggo. Yakutama, yabwama ng’empologoma. Ddala ng’empologoma enkazi, ani anaakweŋŋanga? ");
INSERT INTO lug_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Era omuggo gw’omufuzi teguuvenga wakati wa bigere bya Yuda, okutuusa Siiro lw’alijja; era oyo amawanga gonna gwe ganaawuliranga. ");
INSERT INTO lug_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Alisiba endogoyi ku muzabbibu, n’omwana gw’endogoyi ku muzabbibu ogusinga obulungi, ayoza ebyambalo bye mu nvinnyo, n’engoye ze mu musaayi gwe zabbibu. ");
INSERT INTO lug_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Amaaso ge galimyuka wayini, n’amannyo ge galitukula okusinga amata. ");
INSERT INTO lug_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebbulooni alibeera ku mabbali ga nnyanja; anaabanga mwalo gw’amaato, ensalo ze ziriba ku Sidoni. ");
INSERT INTO lug_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakaali ndogoyi ya maanyi, ng’akutama wakati mu bisibo by’endiga; ");
INSERT INTO lug_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","yalaba ng’ekifo ky’okuwummuliramu kirungi; nga n’ensi esanyusa; n’alyoka akkakkanya ekibegabega kye okusitula, n’afuuka omuddu ow’okukozesebwanga emirimu egy’obuwaze. ");
INSERT INTO lug_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ddaani anaalamulanga mu bwenkanya abantu be ng’ekika ekimu ku bika bya Isirayiri. ");
INSERT INTO lug_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ddaani anaaba musota mu kkubo, essalambwa ku kkubo, eriruma ebisinziiro by’embalaasi, omwebagazi waayo alyoke agwe emabega waayo. ");
INSERT INTO lug_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Nnindirira obulokozi bwo, Ayi Mukama. ");
INSERT INTO lug_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gaadi alirumbibwa ogubiina gw’abanyazi, naye ye, alibafubutukira emabega. ");
INSERT INTO lug_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aseri emmere ye eneebanga ngimu, era anaagemuliranga kabaka ebyokulya. ");
INSERT INTO lug_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafutaali mpeewo ya ddembe, avaamu ebigambo ebirungi. ");
INSERT INTO lug_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusufu lye ttabi eribala ennyo, ettabi eribala ennyo eriri ku mugga; abaana be babuna bbugwe. ");
INSERT INTO lug_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Abalasa obusaale baamulumba bubi nnyo, baamulasa ne bamulumya nnyo; ");
INSERT INTO lug_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","naye omutego gwe ne gunywera, n’emikono gye ne gitasagaasagana. Olw’omukono gwa Ayinzabyonna owa Yakobo, olw’Omusumba, Olwazi lwa Isirayiri, ");
INSERT INTO lug_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","olwa Katonda wa kitaawo, akuyamba, olwa Ayinzabyonna akuwa omukisa, omukisa oguva waggulu mu ggulu, omukisa ogwa wansi mu buziba, omukisa ogw’omu lubuto ne mu mabeere. ");
INSERT INTO lug_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Omukisa gwa kitaawo gusinga omukisa gwa bajjajjange, gusinga egyo egyaweebwa bajjajja ab’edda. Gino gyonna gibeere ku mutwe gwa Yusufu, gibeere ne ku bukowekowe bw’oyo eyayawukanyizibwa ne baganda be. ");
INSERT INTO lug_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamini musege ogunyaga, mu makya alya omuyiggo, mu kawungeezi n’agaba omunyago. ");
INSERT INTO lug_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ebyo byonna by’ebika ekkumi n’ebiriri ebya Isirayiri, era ebyo kitaabwe bye yayogera nabo ng’abasabira omukisa. Buli omu ng’amusabira omukisa ogumusaanira. ");
INSERT INTO lug_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Oluvannyuma n’abakuutira n’abagamba nti, “Nditwalibwa eri abantu bange gye baatwalibwa. Munziikanga wamu ne bajjajjange, mu mpuku eri mu nnimiro ya Efulooni Omukiiti, ");
INSERT INTO lug_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","mu mpuku eri mu nnimiro ya Makupeera, okumpi ne Mamule, mu nsi ya Kanani, Ibulayimu gye yagulira mu nnimiro, okuva ku Efulooni Omukiiti. Yagigula okuba obutaka bw’okuziikangamu. ");
INSERT INTO lug_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Awo we waaziikibwa Ibulayimu ne Saala mukazi we, era ne Isaaka ne Lebbeeka mukazi we, we baaziikwa, era awo we naziika Leeya. ");
INSERT INTO lug_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ennimiro n’empuku erimu byagulibwa okuva ku baana ba Kesi.” ");
INSERT INTO lug_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobo bwe yamala okukuutira batabani be, n’azaayo ebigere bye mu kitanda, n’assa omukka ogw’enkomerero n’afa n’akuŋŋaanyizibwa eri abantu be. ");
INSERT INTO lug_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Awo Yusufu n’agwa mu maaso ga kitaawe n’akaaba, n’amunywegera. ");
INSERT INTO lug_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yusufu n’alagira abaweereza be abasawo, okukalirira omulambo gwa kitaawe. Bwe batyo abasawo ne bakalirira omulambo gwa Isirayiri; ");
INSERT INTO lug_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","baali beetaaga ennaku amakumi ana okukoleramu ekyo. Ezo ze nnaku ezakaliririrwangamu emirambo. Abamisiri ne bakungubagira Yakobo okumala ennaku nsanvu. ");
INSERT INTO lug_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Awo ennaku ez’okukungubagiramu Yakobo bwe zaggwaako, Yusufu n’ayogera n’ennyumba ya Falaawo, n’agamba nti, “Obanga ndabye ekisa mu maaso gammwe munjogerereyo ewa Falaawo. Mumugambe nti, ");
INSERT INTO lug_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Kitange yandayiza ng’agamba nti, “Nnaatera okufa; mu ntaana yange gye nesimira mu nsi ya Kanani, omwo mw’onziikanga.” Kale kaakano mbasaba mundeke ŋŋende nziike kitange; oluvannyuma nkomewo.’ ” ");
INSERT INTO lug_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Falaawo n’addamu nti, “Genda oziike kitaawo nga bwe yakulayiza.” ");
INSERT INTO lug_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Awo Yusufu n’ayambuka wamu n’abaweereza ba Falaawo bonna, n’abakulu b’ennyumba ye, n’abakulu ba Misiri bonna, ");
INSERT INTO lug_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","n’ab’ennyumba ya Yusufu, ne baganda be, n’ab’ennyumba ya kitaawe. Abaana bokka be baasigala mu Goseni n’ebisibo byabwe n’amagana gaabwe. ");
INSERT INTO lug_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","N’agenda n’amagaali n’abeebagala embalaasi era ekibiina kyali kinene nnyo. ");
INSERT INTO lug_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Bwe baatuuka ku gguuliro lya Atadi ng’osomose Yoludaani, ne bakungubaga okukungubaga okutagambika okujjudde ennaku; Yusufu n’akungubagira kitaawe okumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Abantu ab’omu nsi, Abakanani, bwe baalaba okukungubaga mu gguuliro lya Atadi ne bagamba nti, “Okukungubaga kuno kwa ntiisa eri Abamisiri.” Ekifo ekyo kyekyava kiyitibwa Aberumizirayimu, ekiri emitala wa Yoludaani. ");
INSERT INTO lug_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Bwe batyo batabani ba Yakobo ne bakola nga bwe yabalagira. ");
INSERT INTO lug_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Baamwetikka ne bamutuusa mu Kanani, ne bamuziika mu mpuku eyali mu nnimiro ya Makupeera, okumpi ne Mamule, Ibulayimu gye yagula okuva ku Efulooni Omukiiti, aziikengamu abantu be. ");
INSERT INTO lug_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusufu bwe yamala okuziika kitaawe n’addayo e Misiri wamu ne baganda be ne bonna abaayambuka naye okuziika kitaawe. ");
INSERT INTO lug_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Baganda ba Yusufu bwe baalaba nga kitaabwe afudde, ne bagamba nti, “Osanga Yusufu ajja kutukyawa yeesasuze olw’ebibi byonna bye twamukola.” ");
INSERT INTO lug_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kyebaava bamutumira nga bagamba nti, “Kitaawo bwe yali tannafa yatulagira nti ");
INSERT INTO lug_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","tugambanga Yusufu nti, ‘Nkusaba osonyiwe baganda bo bye bakusobya n’ekibi kyabwe, kubanga baasobya nnyo gy’oli.’ Kale nno kaakano tukusaba osonyiwe okusobya kw’abaweereza ba Katonda wa kitaawo.” Yusufu bwe baakimugamba n’akaaba. ");
INSERT INTO lug_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Baganda be ne bagenda gy’ali ne beeyala mu maaso ge ne bagamba nti, “Laba, tuli baddu bo.” ");
INSERT INTO lug_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Naye Yusufu n’abagamba nti, “Temutya, nze ndi mu kifo kya Katonda? ");
INSERT INTO lug_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mwagenderera okunnumya, naye Katonda n’akifuula ekirungi, n’akikozesa abantu baleme okufa. ");
INSERT INTO lug_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Noolwekyo temutya, nzija kubaliisa mmwe n’abaana bammwe.” Bw’atyo n’abagumya n’abazaamu amaanyi. ");
INSERT INTO lug_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Awo Yusufu n’abeera mu Misiri, ye n’ennyumba ya kitaawe. N’awangaala emyaka kikumi mu kkumi. ");
INSERT INTO lug_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","N’alaba abaana ba Efulayimu, abazzukulu ab’omugigi ogwokusatu. Era n’alaba n’aba Makiri mutabani wa Manase abaazaalirwa ku maviivi ga Yusufu. ");
INSERT INTO lug_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusufu n’agamba baganda be nti, “Nnaatera okufa, naye Katonda alibakyalira n’abalinnyisa okubaggya mu nsi eno; n’abatwala mu nsi gye yalayirira Ibulayimu, ne Isaaka ne Yakobo.” ");
INSERT INTO lug_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Awo Yusufu n’alayiza abaana ba Isirayiri ng’agamba nti, “Katonda alibakyalira, nammwe mulinyisanga amagumba gange okugaggya wano.” ");
INSERT INTO lug_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Bw’atyo Yusufu n’afa, ng’alina emyaka kikumi mu kkumi; ne bakalirira omulambo gwe n’ateekebwa mu ssanduuko mu Misiri.");
INSERT INTO lug_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Gano ge mannya ga batabani ba Isirayiri, era ye Yakobo, abajja naye mu Misiri; buli omu n’ab’omu nnyumba ye: ");
INSERT INTO lug_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Lewubeeni, ne Simyoni, ne Leevi ne Yuda, ");
INSERT INTO lug_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ne Isakaali, ne Zebbulooni, ne Benyamini, ");
INSERT INTO lug_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ne Ddaani, ne Nafutaali, ne Gaadi, ne Aseri. ");
INSERT INTO lug_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Abaana bonna awamu Yakobo yennyini be yazaala baali bawera nsanvu; Yusufu ye, yali yabeera dda mu Misiri. ");
INSERT INTO lug_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Awo Yusufu n’afa; ne baganda be ne bonna ab’omulembe ogwo ne bafa. ");
INSERT INTO lug_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Naye Abayisirayiri ne bazaala nnyo, ne baala, ne bayitirira obungi, era ne baba ba maanyi nnyo; ne bajjula ekitundu ekyo mwe baali. ");
INSERT INTO lug_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Awo ne waddawo kabaka omuggya mu Misiri ataamanya Yusufu. ");
INSERT INTO lug_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","N’agamba abantu be nti, “Abayisirayiri batuyitiriddeko obungi era ba maanyi. ");
INSERT INTO lug_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ka tubasalire amagezi baleme kweyongera bungi. Kubanga singa wagwawo olutalo ne beegatta n’abalabe baffe, ne batulwanyisa, balituddukako ne bava mu nsi eno.” ");
INSERT INTO lug_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Bwe batyo ne babateekako bannampala bababonyeebonye n’emirimu egy’obuwaze; ne bazimbira Falaawo ebibuga eby’amaterekero, Pisomu ne Lamusesi. ");
INSERT INTO lug_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Naye gye baakoma okutuntuzibwa, ate gye baakoma okweyongera obungi, ne basaasaana wonna. Abamisiri ne bakyawa abaana ba Isirayiri ate nga bwe babatya. ");
INSERT INTO lug_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ne bongera okutuntuza abaana ba Isirayiri n’obukambwe. ");
INSERT INTO lug_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Obulamu bw’Abayisirayiri ne bubakaayirira nga bakozesebwa ng’abaddu; nga batabula ebbumba okukola amatoffaali; n’emirimu egya buli ngeri egikolebwa mu nnimiro. Mu mirimu egyo gyonna baabakozesanga n’amaanyi era n’obukambwe. ");
INSERT INTO lug_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Awo kabaka w’e Misiri n’ayogera n’abazaalisa b’Abaebbulaniya, amannya gaabwe Sifira ne Puwa, n’abagamba nti, ");
INSERT INTO lug_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Bwe mubanga muzaalisa abakazi Abaebbulaniya, ne mulaba ng’omwana wabulenzi, mumuttanga bussi, naye bw’abanga owoobuwala, mumulekanga n’alama.” ");
INSERT INTO lug_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Naye abazaalisa baali batya Katonda, nga bamussaamu ekitiibwa, ebyo kabaka w’e Misiri bye yabalagira ne batabikolerako, n’abaana abalenzi nabo ne babaleka ne balama. ");
INSERT INTO lug_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kabaka w’e Misiri n’ayita abazaalisa, n’ababuuza nti, “Kiki ekibakozesezza bwe mutyo, okuleka abaana abalenzi ne balama?” ");
INSERT INTO lug_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Abazaalisa, ne baddamu Falaawo nti, “Abakazi Abaebbulaniya tebali ng’abakazi Abamisiri; bo balamu bulungi era ba maanyi; abazaalisa we bagendera okubatuukako nga bamaze okuzaala.” ");
INSERT INTO lug_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Katonda, n’ayisanga bulungi abazaalisa n’abawa emikisa. Abaana ba Isirayiri ne beeyongera nnyo obungi era ne baba ba maanyi nnyo. ");
INSERT INTO lug_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Olwokubanga abazaalisa bassangamu Katonda ekitiibwa, nga bamutya, n’abawa ezzadde. ");
INSERT INTO lug_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Falaawo n’alyoka alagira abantu be bonna nti, “Buli mwana wabulenzi Abaebbulaniya gwe banaazaalanga mumusuulanga mu mugga Kiyira, naye owoobuwala mumulekanga.” ");
INSERT INTO lug_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Awo olwatuuka omusajja ow’omu kika kya Leevi, n’agenda n’awasa omukazi, nga naye Muleevi. ");
INSERT INTO lug_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Omukazi oyo n’aba olubuto n’azaala omwana mulenzi; naye bwe yalaba nga mwana alabika obulungi ennyo, n’amukwekera emyezi esatu. ");
INSERT INTO lug_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Naye bwe yatuusa ekiseera nga takyasobola kumukweka, n’amufunira ekibaya eky’ebitoogo, n’akisiigako ebitosi ne koolaasi; omwana n’amuteeka omwo, n’akissa mu bitoogo ku lubalama lw’omugga Kiyira. ");
INSERT INTO lug_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Mwannyina w’omwana n’ayimiriranga nga yeesuddeko akabanga, alabe ebinaamutuukangako. ");
INSERT INTO lug_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Awo muwala wa Falaawo n’aserengeta ku mugga Kiyira okunaaba; abaweereza be abawala ne batambulira ku lubalama lw’omugga; muwala wa Falaawo n’alaba ekibaya mu bitoogo, n’atuma omu ku bawala okukikima, n’akireeta. ");
INSERT INTO lug_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Bwe yakisaanukulako, n’alabamu omwana. Omwana yali akaaba, n’amusaasira nnyo, n’agamba nti, “Ono y’omu ku baana abawere aba Baebbulaniya.” ");
INSERT INTO lug_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Awo mwannyina w’omwana n’asembera, n’agamba muwala wa Falaawo nti, “Ŋŋende nkuyitire omulezi w’abaana Omwebbulaniya ajje akumulerere?” ");
INSERT INTO lug_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Muwala wa Falaawo n’amuddamu nti, “Kale, genda.” Omuwala mwannyina w’omwana oyo bwe yagenda, yaleeta nnyina wa mwana! ");
INSERT INTO lug_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Muwala wa Falaawo n’agamba nnyina w’omwana nti, “Twala omwana ono omunderere, nnaakusasulanga.” Omukazi oyo n’atwala omwana n’amulera. ");
INSERT INTO lug_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Omwana bwe yakula, n’amutwalira muwala wa Falaawo, n’afuuka omwana wa muwala wa Falaawo. N’amutuuma erinnya Musa, n’agamba nti, “Kubanga namuggya mu mazzi.” ");
INSERT INTO lug_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Awo olwatuuka, Musa ng’amaze okukula, n’agendako mu bantu be Abaebbulaniya, n’alaba emirimu emikakanyavu gye baali bakozesebwa. N’alaba Omumisiri ng’akuba Omwebbulaniya, omuntu ow’omu baganda be. ");
INSERT INTO lug_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Awo Musa n’amagamaga, bwe yalaba nga teri muntu mulala amulaba, n’akwata Omumisiri n’amutta, n’amukweka mu musenyu. ");
INSERT INTO lug_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Bwe yaddayo enkeera, n’alaba abasajja babiri Abaebbulaniya nga balwana. N’abuuza oyo eyali asobezza nti, “Lwaki okuba Mwebbulaniya munno?” ");
INSERT INTO lug_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Omusajja n’amuddamu nti, “Ani eyakulonda okuba omufuzi waffe era omulamuzi waffe? Oyagala kunzita nga bwe watta Omumisiri?” Musa n’atya, n’ayogera mu mutima gwe nti, “Ekintu kye nakola kirabika kyategeerebwa.” ");
INSERT INTO lug_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Awo Falaawo bwe yakiwulira, n’agezaako okutta Musa. Naye Musa n’aviira Falaawo, n’addukira mu nsi ya Midiyaani; n’atuula awali oluzzi. ");
INSERT INTO lug_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Waaliwo kabona mu Midiyaani eyalina abaana be abawala musanvu, ne bajja okusena amazzi bajjuze ebyesero banywese endiga za kitaabwe. ");
INSERT INTO lug_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kyokka ne wabaawo abasumba ne bajja ne babagobawo; naye Musa n’asituka n’abalwanirira, n’anywesa endiga zaabwe. ");
INSERT INTO lug_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Abawala bwe baddayo eka eri kitaabwe Leweri, n’ababuuza nti, “Nga mukomyewo mangu leero?” ");
INSERT INTO lug_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ne bamuddamu nti, “Omusajja Omumisiri atulwaniridde ng’abasumba batujoogereza; y’atusenedde n’amazzi n’anywesa ekisibo kyaffe.” ");
INSERT INTO lug_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","N’abuuza bawala be nti, “Ali ludda wa? Ye lwaki mumuleseeyo? Mumuyite ajje alye ku mmere.” ");
INSERT INTO lug_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa n’akkiriza. N’abeerera ddala mu maka ga Leweri. Leweri n’awa Musa muwala we Zipola okuba mukyala we. ");
INSERT INTO lug_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipola n’amuzaalira omwana owoobulenzi. Musa n’amutuuma erinnya Gerusomu, ng’agamba nti, “Kubanga ndi mugwira mu nsi etali yange.” ");
INSERT INTO lug_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Awo nga wayiseewo ebbanga ggwanvu, kabaka w’e Misiri n’afa. Abaana ba Isirayiri ne basindanga era ne bakaabanga olw’obuddu bwe baalimu, n’okukaaba kwabwe ne kutuuka eri Katonda. ");
INSERT INTO lug_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Katonda n’awulira okusinda kwabwe. Katonda n’ajjukira endagaano ye gye yalagaana ne Ibulayimu, ne Isaaka ne Yakobo. ");
INSERT INTO lug_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Katonda n’atunuulira abaana ba Isirayiri, n’ategeera okubonaabona kwabwe. ");
INSERT INTO lug_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Awo olwatuuka, Musa bwe yali ng’alunda ekisibo ky’endiga za mukoddomi we Yesero, kabona w’e Midiyaani, n’atwala ekisibo ku ludda olw’ebugwanjuba olw’eddungu; n’atuuka ku lusozi lwa Katonda oluyitibwa Kolebu. ");
INSERT INTO lug_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Malayika wa Mukama n’amulabikira ng’asinziira mu muliro ogwaka, mu makkati g’ekisaka. Musa n’atunuulira ekisaka, n’alaba nga kyaka naye nga tekisiriira. ");
INSERT INTO lug_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musa n’ayogera mu mwoyo gwe nti, “Leka nneetoolooleko neetegereze ekintu kino ekitali kya bulijjo, eky’ekitalo, ekireetedde ekisaka obutasiriira.” ");
INSERT INTO lug_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mukama bwe yalaba nga Musa agenze okwetegereza, Katonda n’amuyita ng’asinziira mu kisaka wakati nti, “Musa, Musa!” Musa n’ayitaba nti, “Nze nzuuno.” ");
INSERT INTO lug_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Katonda n’amugamba nti, “Teweeyongera kusembera. Ggyamu engatto zo, kubanga ekifo w’oyimiridde kitukuvu.” ");
INSERT INTO lug_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ne yeeyongera n’amugamba nti, “Nze Katonda wa kitaawo, era nze Katonda wa Ibulayimu, nze Katonda wa Isaaka, era nze Katonda wa Yakobo.” Musa bwe yawulira ebyo n’akweka amaaso ge, kubanga yatya okutunuulira Katonda. ");
INSERT INTO lug_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Awo Mukama Katonda n’ayogera nti, “Ndabidde ddala okubonaabona kw’abantu bange abali mu Misiri. Mpulidde ebiwoobe byabwe olw’abo ababatuntuza ng’abaddu; era ntegedde okubonaabona kwabwe. ");
INSERT INTO lug_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Kyenvudde nzika, mbawonye effugabbi ery’Abamisiri, era mbaggye mu nsi eyo, mbaleete mu nsi ennungi era engazi, y’ensi ekulukuta amata n’omubisi gw’enjuki; kaakano mwe muli Abakanani, n’Abakiiti, n’Abamoli, n’Abaperezi, n’Abakiivi n’Abayebusi. ");
INSERT INTO lug_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Kale mpulidde okukaaba kw’abaana ba Isirayiri, era ndabye ng’Abamisiri bwe bababonyaabonya. ");
INSERT INTO lug_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Noolwekyo, jjangu nkutume ewa Falaawo, oggyeyo abantu bange abaana ba Isirayiri mu Misiri.” ");
INSERT INTO lug_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Naye Musa n’agamba Katonda nti, “Nange nze ani agenda ewa Falaawo nziggyeyo abaana ba Isirayiri mu Misiri?” ");
INSERT INTO lug_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Katonda n’amuddamu nti, “Ddala, nnaabeeranga naawe. Era kino kye kikakasa nti nze nkutumye: Bw’olimala okuggya abantu abo mu Misiri, mulisinziza Katonda ku lusozi luno.” ");
INSERT INTO lug_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Awo Musa n’abuuza Katonda nti, “Bwe ndituuka mu baana ba Isirayiri ne mbategeeza nti, ‘Katonda wa bajjajjammwe antumye gye muli;’ nabo ne bambuuza nti, ‘Erinnya lye ye ani?’ Ndibaddamu ntya?” ");
INSERT INTO lug_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Katonda n’agamba Musa nti, “Ndi nga bwe Ndi,” n’ayongera nti, “Bw’otyo bw’onootegeeza abaana ba Isirayiri nti, ‘Ndi y’antumye gye muli.’ ” ");
INSERT INTO lug_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Katonda n’ayongera n’agamba Musa nti, “Tegeeza abaana ba Isirayiri nti, ‘Mukama, Katonda wa bajjajjammwe: Katonda wa Ibulayimu, era Katonda wa Isaaka, era nga ye Katonda wa Yakobo, y’antumye gye muli.’ “Eryo lye linnya lyange ery’olubeerera, era lye linnya lye nnajjuukirirwangako mu buli mulembe ogunaddiriranga gunnaagwo. ");
INSERT INTO lug_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Genda okuŋŋaanye abakadde ba Isirayiri, obategeeze nti, ‘Mukama, Katonda wa bajjajjammwe, Katonda wa Ibulayimu, era owa Isaaka, era owa Yakobo, yandabikira, n’aŋŋamba nti, Ntunuulidde abantu bange, ne ndaba ebibakolebwa mu Misiri. ");
INSERT INTO lug_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Kyenvudde nsuubiza okubaggya mu kubonaabona kwe balimu mu Misiri, mbaleete mu nsi y’Abakanani, n’Abakiiti, n’Abamoli, n’Abaperezi, n’Abakiivi, n’Abayebusi; y’ensi ekulukuta amata n’omubisi gw’enjuki.’ ");
INSERT INTO lug_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Abakadde ba Isirayiri bagenda kuwuliriza by’ogamba. Kale, ggwe n’abakadde ba Isirayiri muligenda eri kabaka wa Misiri ne mumugamba nti, ‘Mukama, Katonda w’Abaebbulaniya yeeraga gye tuli. Tukkirize tugende mu ddungu, olugendo lwa nnaku ssatu, tuweeyo ssaddaaka eri Mukama Katonda waffe.’ ");
INSERT INTO lug_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Naye mmanyi nga kabaka w’e Misiri talibakkiriza kugenda, wabula ng’awalirizibbwa n’amaanyi mangi. ");
INSERT INTO lug_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Kyendiva nkozesa amaanyi gange, ne mbonereza Misiri n’ebyamagero bye ndikolera mu nsi omwo; n’oluvannyuma alibakkiriza ne mugenda. ");
INSERT INTO lug_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Era Abamisiri ndibaagazisa abantu abo; bwe mutyo bwe muliba musitula, temulivaayo ngalo nsa. ");
INSERT INTO lug_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Buli mukazi Omuyisirayiri alisaba omukazi Omumisiri muliraanwa we, n’oyo bwe basula mu nju emu, ebitemagana ebya ffeeza n’ebya zaabu, n’engoye ez’okwambala. Ebyo byonna mulibyambaza batabani bammwe ne bawala bammwe; Abamisiri ne muleka nga mubakalizza.” ");
INSERT INTO lug_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa n’addamu nti, “Tebagenda kunzikiriza, wadde okuwuliriza ebyo bye mbagamba: kubanga bagenda kwogera nti, Mukama takulabikiranga.” ");
INSERT INTO lug_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Awo Mukama n’amubuuza nti, “Ekyo kiki ekiri mu ngalo zo?” N’addamu nti, “Muggo.” ");
INSERT INTO lug_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Mukama Katonda n’amugamba nti, “Gusuule wansi.” Musa n’agusuula wansi; ne gufuuka omusota, n’agudduka! ");
INSERT INTO lug_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Mukama n’agamba Musa nti, “Golola omukono gwo ogukwate akawuuwo ogusitule.” N’agolola omukono gwe n’agukwata, ne gufuuka omuggo mu mukono gwe. ");
INSERT INTO lug_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Mukama n’amugamba nti, “Bw’olikola bw’otyo bagenda kukukkiriza, era balitegeera nga Mukama Katonda wa bajjajjaabwe, Katonda wa Ibulayimu, era Katonda wa Isaaka, era Katonda wa Yakobo, yakulabikira.” ");
INSERT INTO lug_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Mukama n’amugamba nate nti, “Yingiza omukono gwo munda mu kyambalo kyo.” N’ayingiza omukono gwe munda mu kyambalo kye: bwe yaguggyaayo, laba, nga gujjudde ebigenge nga gutukula ng’omuzira. ");
INSERT INTO lug_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ate n’amugamba nti, “Zzaayo omukono gwo munda mu kyambalo kyo.” Musa n’azzaayo omukono gwe mu kyambalo kye. Bwe yaguggyaayo, laba nga gufuuse mulamu ng’omubiri gwe ogwa bulijjo. ");
INSERT INTO lug_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Mukama n’agamba Musa nti, “Bwe batalikukkiririza ku kabonero akasoose, balikukkiririza ku kabonero akookubiri. ");
INSERT INTO lug_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Bwe bagaananga okukukkiriza nga bamaze okulaba obubonero obwo bwombi, osenanga amazzi mu mugga n’ogayiwa ku lukalu; amazzi ago g’olisena mu mugga, galifuuka omusaayi ng’ogayiye ku lukalu.” ");
INSERT INTO lug_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Awo Musa n’agamba Mukama nti, “Ayi Mukama wange, siri mwogezi mulungi okuva edda n’edda, wadde ne mu kiseera kino ggwe kaayogerera nange, omuddu wo; njogera nnembeggerera ate nga bwe nnaanaagira.” ");
INSERT INTO lug_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Mukama n’amuddamu nti, “Ani yakola akamwa k’omuntu? Ani yatonda bakasiru, ne bakiggala, n’abatunula, ne bamuzibe? Si nze, Mukama? ");
INSERT INTO lug_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Kaakano, genda! Nnaakuyambanga ng’oyogera, era nnaakuyigirizanga by’onooyogeranga.” ");
INSERT INTO lug_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Naye Musa n’agamba nti, “Mukama wange, nkwegayiridde tuma omuntu omulala.” ");
INSERT INTO lug_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Mukama n’asunguwalira nnyo Musa, n’amugamba nti, “Muganda wo Alooni Omuleevi, taliiwo? Mmanyi nga mwogezi mulungi; era, laba, ajja gy’oli, era bw’anaakulabako ajja kusanyuka mu mutima gwe. ");
INSERT INTO lug_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ggwe ojja kwogeranga naye, nze nnaakutegeezanga ky’onoomugambanga, nange n’abayambanga mwembi, ne mbayigiriza eky’okukola. ");
INSERT INTO lug_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Y’anaakwogereranga eri abantu, ng’abategeeza bye wandiyogedde; ggwe n’oba nga Katonda gy’ali, ng’omutegeezanga by’anaayogeranga. ");
INSERT INTO lug_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Era oligenda n’omuggo guno, ng’ogukutte mu mukono gwo; gw’onookozesanga ebyamagero.” ");
INSERT INTO lug_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Awo Musa n’addayo eri Yesero, kitaawe wa mukazi we n’amugamba nti, “Nkusaba onzikirize ŋŋende ndabe obanga baganda bange e Misiri bakyali balamu.” Yesero n’addamu Musa nti, “Genda mirembe.” ");
INSERT INTO lug_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Awo Mukama n’ayogera ne Musa e Midiyaani nti, “Genda, oddeyo e Misiri kubanga abantu bonna abaali baagala okukutta, baafa.” ");
INSERT INTO lug_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Musa n’addira mukyala we n’abaana be, n’abassa ku ndogoyi, n’asitula okuddayo mu nsi y’e Misiri, ng’akutte omuggo gwa Katonda mu ngalo ze. ");
INSERT INTO lug_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Mukama n’agamba Musa nti, “Bw’oddangayo e Misiri, okoleranga ebyamagero ebyo byonna bye nkulaze, awali Falaawo. Nze ndikakanyaza omutima gwe, abantu bange aleme okubakkiriza okugenda. ");
INSERT INTO lug_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Falaawo omugambanga bw’oti nti, Mukama agambye nti, ‘Isirayiri mutabani wange, ye mwana wange omubereberye; ");
INSERT INTO lug_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","era nkulagira oleke omwana wange agende ampeereze; naye singa ogaana okumuleka okugenda, laba, nditta mutabani wo omubereberye.’ ” ");
INSERT INTO lug_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Awo bwe baali bagenda nga batuuse ku nnyumba y’abagenyi, Mukama n’amulabikira, n’ayagala okumutta. ");
INSERT INTO lug_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Naye Zipola n’addira ejjinja eryogi, n’akomola omwana we, ekikuta n’akisuula ku bigere bya Musa, n’amugamba nti, “Oli baze wa musaayi!” ");
INSERT INTO lug_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Awo Mukama n’amuleka. Mu kaseera ako Zipola we yayogerera ku kukomola nti, “Baze wange ng’osaabye omusaayi!” ");
INSERT INTO lug_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Awo Mukama n’agamba Alooni nti, “Genda mu ddungu, osisinkane Musa. N’agenda, n’amusanga ku lusozi lwa Katonda, ne bagwaŋŋana mu bifuba.” ");
INSERT INTO lug_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa n’abuulira Alooni ebigambo byonna Mukama bye yali amutumye okwogera, n’obubonero bwonna obw’ebyamagero bwe yamulagira okukola. ");
INSERT INTO lug_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Musa ne Alooni ne bagenda, ne bakuŋŋaanya abakulu abakulembeze b’abaana ba Isirayiri; ");
INSERT INTO lug_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Alooni n’abategeeza byonna Mukama bye yagamba Musa; era n’abakolera n’obubonero, ");
INSERT INTO lug_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ne bakkiriza. Era bwe baawulira nga Mukama yakyalira abaana ba Isirayiri, n’alaba okubonaabona kwabwe, ne bakoteka emitwe gyabwe ne basinza. ");
INSERT INTO lug_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Oluvannyuma lw’ebyo, Musa ne Alooni ne bajja eri Falaawo, ne bamugamba nti, “Tutumiddwa Mukama Katonda wa Isirayiri ng’akugamba nti, ‘Leka abantu bange bagende, bankolere embaga mu ddungu.’ ” ");
INSERT INTO lug_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Naye Falaawo n’abaddamu nti, “Mukama ye ani, mmugondere, nzikirize Abayisirayiri okugenda? Mukama ssimumanyi, era sijja kubakkiriza kugenda.” ");
INSERT INTO lug_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ne bamugamba nti, “Katonda w’Abaebbulaniya yatulabikira. Tukusaba otuleke tugende olugendo lwa nnaku ssatu mu ddungu, tuweeyo ssaddaaka eri Mukama Katonda waffe; aleme kututta ne kawumpuli, oba n’ekitala.” ");
INSERT INTO lug_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Naye kabaka w’e Misiri n’abagamba nti, “Mmwe Musa ne Alooni, lwaki mwagala okuggya abantu ku mirimu gyabwe? Muddeeyo mangu ku mirimu gyammwe.” ");
INSERT INTO lug_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Falaawo n’ayongera n’agamba nti, “Kale, mulabe abantu nga bwe beeyongedde obungi mu ggwanga ate mmwe mubaziyiza kukola.” ");
INSERT INTO lug_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ku lunaku olwo lwennyini Falaawo n’alagira abagabi b’emirimu ne bannampala b’abantu nti, ");
INSERT INTO lug_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Mulekeraawo okuwanga abantu essubi ery’okukozesa mu kubumba amatoffaali; mubaleke bagende beenoonyezenga essubi lyabwe. ");
INSERT INTO lug_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Naye mubalagire babumbenga obungi bw’amatoffaali bwe bumu nga ge babadde babumba; temukendeezanga ku muwendo ogwabasalirwa. Bagayaavu; era kyebava bankaabirira nti, ‘Tuleke tugende tuweeyo ssaddaaka eri Katonda waffe.’ ");
INSERT INTO lug_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Abasajja mubongereko ku mirimu gye mubasalira, bakole nnyo, balyoke baleme na kufa ku ebyo bye babalimbalimba.” ");
INSERT INTO lug_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Awo abakozesa ne bannampala ne bagenda ne bategeeza abantu nti, “Falaawo agambye bw’ati nti, ‘Sijja kwongera kubawanga ssubi. ");
INSERT INTO lug_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mugende mwenoonyeze essubi yonna gye musobola okuliraba; kyokka emirimu gyammwe tegijja kukendeezebwako n’akatono.’ ” ");
INSERT INTO lug_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Bwe batyo abantu ne basaasaanira Misiri yonna okukuŋŋaanya obukonge bw’essubi ly’eŋŋaano bakozese obwo mu kifo ky’essubi. ");
INSERT INTO lug_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Abakozesa ne babakuluusanyanga nga babalagira nti, “Emirimu gyammwe egibasalirwa buli lunaku, mugituukirize nga bwe mwakolanga ng’essubi likyabaweebwa.” ");
INSERT INTO lug_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Bannampala Abayisirayiri, abaalondebwa abakozesa ba Falaawo, ne bakubibwanga nga bwe babuuzibwa nti, “Lwaki omuwendo gw’amatoffaali ogwa jjo n’ogwa leero ogwabasalirwa temugutuukirizza nga bwe mwakolanga edda?” ");
INSERT INTO lug_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Awo bannampala Abayisirayiri ne bajja ne bajulira ewa Falaawo, ne bamugamba nti, “Ffe abaddu bo, lwaki otuyisizza bw’oti? ");
INSERT INTO lug_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Abaddu bo tetuweebwa ssubi, kyokka tulagirwa nti, ‘Mubumbe amatoffaali!’ Abaddu bo tukubibwa, so ng’omusango guli mu bantu bo.” ");
INSERT INTO lug_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Falaawo n’abaddamu nti, “Muli bagayaavu bugayaavu kyokka. Kyemuva mundeeberera nti, ‘Tuleke tugende tuweeyo ssaddaaka eri Mukama.’ ");
INSERT INTO lug_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Kale, mugende mukole! Temujja kuweebwa ssubi, naye muteekwa okubumba omuwendo gw’amatoffaali omujjuvu nga bwe gwabasalirwa.” ");
INSERT INTO lug_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Bannampala Abayisirayiri ne bategeera ng’akacwano kabatuukiridde, bwe baagambibwa nti, “Omuwendo gw’amatoffaali ogwabasalirwa okubumbanga buli lunaku tegujja kukendeezebwako.” ");
INSERT INTO lug_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Bwe baava ewa Falaawo, baasanga Musa ne Alooni nga babalindiridde. ");
INSERT INTO lug_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Bannampala ne babagamba nti, “Mukama abatunuulire era asalewo; kubanga mutufudde ekyenyinyalwa ewa Falaawo n’abaweereza be, era mubakwasizza ekitala okututta.” ");
INSERT INTO lug_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Awo Musa n’akomawo awali Mukama, n’ayogera nti, “Ayi Mukama, abantu bano lwaki obaleetedde emitawaana? Eyo y’ensonga kyewava ontuma? ");
INSERT INTO lug_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kubanga kasookedde ŋŋenda ne njogera ne Falaawo mu linnya lyo, abantu bo abataddeko ebizibu bingi; era abantu bo tobawonyezza n’akatono.” ");
INSERT INTO lug_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Awo Mukama n’addamu Musa nti, “Kaakano ojja kulaba kye nnaakola Falaawo. Kubanga alibaleka ne bagenda olw’amaanyi, era olw’amaanyi alibagoba mu nsi ye.” ");
INSERT INTO lug_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Katonda n’agamba Musa nti, “Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nalabikira Ibulayimu, ne Isaaka ne Yakobo nga Katonda Ayinzabyonna; kyokka saabategeeza linnya lyange nti Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Era nabasuubiza mu ndagaano yange okubawa ensi ya Kanani, gye baabeerangamu ng’abagwira abatambuze. ");
INSERT INTO lug_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Kaakano mpulidde okusinda kw’abaana ba Isirayiri abatuntuzibwa Abamisiri mu buddu, ne nzijukira endagaano yange. ");
INSERT INTO lug_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Noolwekyo tegeeza abaana ba Isirayiri nti, ‘Nze Mukama. Ndibatikkulako emigugu gy’Abamisiri, era ndibawonya obuddu, ne mbanunula n’omukono gwange ogw’amaanyi nga nsalira Abamisiri omusango. ");
INSERT INTO lug_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ndibafuula abantu bange, era nnaabeeranga Katonda wammwe, era mulitegeera nga nze Mukama Katonda wammwe abawonyezza ebizibu by’Abamisiri. ");
INSERT INTO lug_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ndibaleeta mu nsi gye nalayira okuwa Ibulayimu ne Isaaka ne Yakobo; ndigibawa n’efuuka yammwe. Nze Mukama.’ ” ");
INSERT INTO lug_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa n’ategeeza abaana ba Isirayiri ebigambo ebyo. Naye tebaamuwuliriza, kubanga emitima gyali gibennyise, nga n’okutuntuzibwa kubayitiridde. ");
INSERT INTO lug_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Genda otegeeze Falaawo kabaka w’e Misiri aleke abaana ba Isirayiri bave mu nsi ye.” ");
INSERT INTO lug_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Naye Musa n’addamu Mukama nti, “Laba, abaana ba Isirayiri bagaanyi okumpuliriza, kale Falaawo anampuliriza atya nze atayogera bulungi?” ");
INSERT INTO lug_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Naye Mukama n’ayogera ne Musa ne Alooni, n’abalagira bategeeze abaana ba Isirayiri ne Falaawo nti, Mukama abalagidde okuggya abaana ba Isirayiri mu nsi y’e Misiri. ");
INSERT INTO lug_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Gano ge mannya aga bajjajjaabwe ab’omu bika byabwe: Batabani ba Lewubeeni, mutabani wa Isirayiri omubereberye, be bano: Kanoki ne Palu, Kezulooni ne Kalumi. ");
INSERT INTO lug_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Batabani ba Simyoni: Yamweri ne Yamini, ne Okadi, Yakini ne Zokali, Sawuli (omwana w’omukyala Omukanani). Abo be b’omu mu bika bya Simyoni. ");
INSERT INTO lug_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Gano ge mannya ga batabani ba Leevi ng’emirembe bwe giri: Gerusoni ne Kokasi ne Merali. Leevi yawangaala emyaka kikumi mu asatu mu musanvu. ");
INSERT INTO lug_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Batabani ba Gerusoni be bano mu bika byabwe: Libuni ne Simeeyi. ");
INSERT INTO lug_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Bano be batabani ba Kokasi: Amulaani ne Izukali, Kebbulooni ne Wuziyeeri. Kokasi yawangaala emyaka kikumi mu asatu mu esatu. ");
INSERT INTO lug_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Bano be batabani ba Merali: Makuli ne Musi. Abo be b’omu bika bya Leevi ng’emirembe gyabwe bwe gyali. ");
INSERT INTO lug_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amulaamu n’awasa senga we Yokebedi; n’amuzaalira: Alooni ne Musa. Amulaamu n’awangaala emyaka kikumi mu asatu mu musanvu. ");
INSERT INTO lug_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Bano be baana ba Izukali: Koola ne Nefega ne Zikiri. ");
INSERT INTO lug_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Abaana ba Wuziyeeri be bano: Misayeri ne Erizafani ne Sisiri. ");
INSERT INTO lug_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Alooni n’awasa Eriseba, muwala wa Aminadaabu era nga ye mwannyina wa Nakayisoni. Yamuzaalira abaana bano: Nadabu ne Abiku, Eriyazaali ne Isamaali. ");
INSERT INTO lug_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Bano be baana ba Koola: Asira ne Erukaana, ne Abiyasaafu. Abo be b’omu kika kya Abakoola. ");
INSERT INTO lug_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eriyazaali, mutabani wa Alooni, yawasa omu ku bawala ba Putiyeeri, n’amuzaalira Finekaasi. Ago ge mannya g’abakulu b’ebika by’Abaleevi, n’ennyumba zaabwe mu bika ebyo. ");
INSERT INTO lug_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Abo ye Alooni ne Musa Mukama be yalagira nti, “Muggyeeyo abaana ba Isirayiri bonna mu nsi y’e Misiri.” ");
INSERT INTO lug_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Be bo abaayogera ne Falaawo, kabaka w’e Misiri, ku by’okuggyayo abaana ba Isirayiri mu Misiri. Ye Musa oyo, ne Alooni oyo. ");
INSERT INTO lug_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ku lunaku olwo Mukama kwe yayogerera ne Musa mu nsi y’e Misiri, ");
INSERT INTO lug_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Mukama yagamba Musa nti, “Nze Mukama. Tegeeza Falaawo, kabaka w’e Misiri, buli kimu kyonna kye nkugamba.” ");
INSERT INTO lug_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Naye Musa n’addamu Mukama nti, “Nze atamanyi kwogera bulungi, Falaawo anampuliriza atya?” ");
INSERT INTO lug_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Awo Mukama n’agamba Musa nti, “Laba, nkufudde nga Katonda awali Falaawo, ne muganda wo Alooni y’ajja okubeera nnabbi wo. ");
INSERT INTO lug_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ojjanga kwogera bye nkulagira, ne muganda wo Alooni ayogere ne Falaawo asobole okuleka abaana ba Isirayiri bave mu nsi ye. ");
INSERT INTO lug_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Naye ndikakanyaza omutima gwa Falaawo; ne bwe ndikolera ebyamagero ebingi ennyo mu nsi y’e Misiri, ");
INSERT INTO lug_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","tagenda kubawuliriza. Ndirumba Misiri n’amaanyi, ne ngisalira omusango, ne ndyoka nzigyayo abantu bange Abayisirayiri bonna. ");
INSERT INTO lug_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Era Abamisiri balitegeera nti Nze Mukama, bwe ndirumba Misiri n’amaanyi ne nzigyayo Abayisirayiri.” ");
INSERT INTO lug_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Awo Musa ne Alooni ne bakola nga Mukama bwe yabalagira. ");
INSERT INTO lug_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","We baayogerera ne Falaawo, Musa yali aweza emyaka kinaana egy’obukulu, ne Alooni ng’aweza emyaka kinaana mu esatu. ");
INSERT INTO lug_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Mukama n’agamba Musa ne Alooni nti, ");
INSERT INTO lug_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Falaawo bw’anaabagamba nti, ‘Mukoleeyo ekyamagero,’ nga ggwe ogamba Alooni nti, ‘Ddira omuggo gwo ogusuule wansi awali Falaawo,’ era gunaafuuka omusota.” ");
INSERT INTO lug_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Awo Musa ne Alooni ne bagenda ewa Falaawo, ne bakola nga Mukama bwe yabalagira. Alooni n’asuula omuggo gwe wansi awali Falaawo n’abaweereza be, ne gufuuka omusota. ");
INSERT INTO lug_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Falaawo naye n’atumya basajja be abagezigezi, n’abalogo; abakujjukujju abo Abamisiri ne bakola ekintu kye kimu mu magezi gaabwe ag’ekyama. ");
INSERT INTO lug_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Kubanga nabo baasuula wansi emiggo gyabwe, ne gifuuka emisota; naye omuggo gwa Alooni ne gumira emiggo gyabwe. ");
INSERT INTO lug_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Naye era omutima gwa Falaawo ne gukakanyala, nga Mukama bwe yali agambye. ");
INSERT INTO lug_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Awo Mukama n’agamba Musa nti, “Omutima gwa Falaawo gukakanyadde, era agaanye okuleka abantu okugenda. ");
INSERT INTO lug_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Mu makya genda eri Falaawo ng’afuluma okulaga ku mazzi, omulindirire ku lubalama lw’omugga Kiyira. Era twala n’omuggo ogwafuuka omusota. ");
INSERT INTO lug_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Olyoke omugambe nti, ‘Mukama Katonda wa Abaebbulaniya yantuma gy’oli ng’agamba nti, Leka abantu bange bajje mu ddungu bansinze; naye, laba, n’okutuusa leero okyagaanyi okuŋŋondera.’ ");
INSERT INTO lug_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Bw’ati bw’ayogera Mukama nti, ‘Ku kino kw’olitegeerera nga nze Mukama: laba ndikuba ku mazzi agali mu mugga, n’omuggo oguli mu mukono gwange, era galifuuka musaayi, ");
INSERT INTO lug_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","n’ebyennyanja ebiri mu mugga birifa, n’omugga guliwunya; era n’Abamisiri nga tebakyayagala kunywa ku mazzi gaagwo.’ ” ");
INSERT INTO lug_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Mukama n’agamba Musa nti, “Tegeeza Alooni nti, ‘Twala omuggo gwo ogwolekeze amazzi gonna mu Misiri: ku migga gyabwe, n’emikutu gyabwe, n’obuyanja bwabwe, n’ebidiba byabwe, byonna bifuuke musaayi. Era wagenda kubeerawo omusaayi mu nsi yonna ey’e Misiri: mu ntiba ez’emiti ne mu matogero ag’amayinja.’ ” ");
INSERT INTO lug_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Awo Musa ne Alooni ne bakola nga Mukama bwe yabalagira. Alooni n’addira omuggo gwe n’akuba ku mazzi ag’omu mugga, nga Falaawo n’abaweereza be balaba; amazzi gonna ag’omu mugga ne gafuuka omusaayi. ");
INSERT INTO lug_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Era n’ebyennyanja byonna mu mugga Kiyira ne bifa. Omugga ne guwunya, Abamisiri nga tebakyasobola kunywa mazzi ga mu mugga Kiyira; omusaayi ne gubuna wonna mu nsi y’e Misiri. ");
INSERT INTO lug_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Abalogo ab’omu Misiri nabo ne bakola bwe batyo mu magezi gaabwe ag’ekyama. Omutima gwa Falaawo ne gweyongera okukakanyala, ebya Musa ne Alooni n’atabiwuliriza era nga Mukama bwe yali agambye; ");
INSERT INTO lug_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","n’akyuka ne yeddirayo mu lubiri lwe, nga byonna ebibaddewo tabissizzaako mwoyo. ");
INSERT INTO lug_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Abamisiri bonna ne basimaasima okumpi n’omugga nga banoonya amazzi ag’okunywa, kubanga amazzi g’omu mugga nga tegakyanyweka. ");
INSERT INTO lug_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Awo ne wayitawo ennaku musanvu okuva ku lunaku Mukama lwe yakubirako omugga. ");
INSERT INTO lug_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Awo Mukama n’agamba Musa nti, “Ggenda ewa Falaawo omugambe nti, ‘Mukama agambye bw’ati nti, “Leka abantu bange bagende, balyoke bansinze. ");
INSERT INTO lug_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Naye bw’onoogaana n’otabakkiriza kugenda, laba, nnaasindika ebikere ne bijjula ensi yo yonna. ");
INSERT INTO lug_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Omugga gulivaamu ebikere enkumu ennyo ebirituuka ne mu lubiri lwo. Biriyingira mu kisenge kyo mw’osula, ne ku kitanda kyo. Biriyingira mu nnyumba z’abaweereza bo ne mu z’abantu bo. Biriyingira ne mu byoto omufumbirwa. ");
INSERT INTO lug_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ebikere birikuwalampa ne bikutambulirako ne ku bakungu bo bonna ne ku bantu bo.” ’ ” ");
INSERT INTO lug_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Mukama n’agamba Musa nti, “Tegeeza Alooni nti, ‘Golola omukono gwo oyolekeze omuggo gwo eri emigga, n’eri emikutu gy’amazzi, n’eri ebidiba, osobozese ebikere okubuna ensi yonna ey’e Misiri.’ ” ");
INSERT INTO lug_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Bw’atyo Alooni n’agolola omukono gwe ku mazzi gonna ag’omu Misiri; ebikere ne bivaayo ne bijjula ensi yonna ey’e Misiri. ");
INSERT INTO lug_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Abalogo nabo ne bakola bwe batyo mu magezi gaabwe ag’ekyama, nabo ne baleeta ebikere mu nsi ey’e Misiri. ");
INSERT INTO lug_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Awo Falaawo n’atumya Musa ne Alooni n’abagamba nti, “Mwegayirire Mukama anziggyeeko ebikere bino era ne ku bantu bange, ndyoke nange ndeke abantu bammwe bagende baweeyo ssaddaaka eri Mukama.” ");
INSERT INTO lug_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa n’addamu Falaawo nti, “Weerondere ekiseera nga bw’osiima, w’oyagalira neegayirire Mukama ku lulwo ne ku lw’abaweereza bo, ne ku lw’abantu bo, ebikere ebikuliko n’ebiri mu nnyumba zo bizikirizibwe, bisigale mu mugga Kiyira mwokka.” ");
INSERT INTO lug_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Falaawo n’agamba nti, “Enkya.” Musa n’agamba nti, “Kijja kubeera nga bw’ogambye, olyoke otegeere nga bwe watali n’omu afaanana nga Mukama Katonda waffe. ");
INSERT INTO lug_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ebikere bijja kukuviira, bive ne mu mayumba go, biviire n’abaweereza bo n’abantu bo; bijja kusigala mu mugga mwokka.” ");
INSERT INTO lug_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Awo Musa ne Alooni ne bava ewa Falaawo. Musa ne yeegayirira Mukama olw’ebikere Mukama bye yali aleetedde Falaawo. ");
INSERT INTO lug_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mukama n’akolera Musa kye yamusaba. Ebikere ne bifiira mu mayumba, ne mu mpya mu byalo, ne mu nnimiro. ");
INSERT INTO lug_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ne bikuŋŋaanyizibwa entuumo n’entuumo; ensi n’ejjula ekivundu. ");
INSERT INTO lug_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Naye Falaawo bwe yalaba nga waliwo wassiza ku mukka, n’akakanyaza omutima gwe, ebya Musa ne Alooni n’alekera awo okubiwuliriza, era nga Mukama bwe yali agambye. ");
INSERT INTO lug_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Awo Mukama n’ayogera ne Musa nti, “Gamba Alooni bw’oti nti, ‘Golola omuggo gwo, okube ku nfuufu eri ku ttaka, eryoke efuuke ensekere mu nsi yonna ey’e Misiri.’ ” ");
INSERT INTO lug_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ne bakola nga Mukama bw’abagambye; Alooni n’agolola omukono gwe ogwali gukute omuggo, n’akuba ku nfuufu ku ttaka, ne muvaamu ensekere ne zitambulira ku bantu ne ku nsolo; enfuufu yonna mu nsi y’e Misiri n’efuuka nsekere. ");
INSERT INTO lug_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Abalogo nabo ne bagezaako mu magezi gaabwe ag’ekyama okufuusa ensekere, naye ne balemwa. Ensekere ne ziteevuunya ku bantu ne ku nsolo. ");
INSERT INTO lug_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Abalogo ne bagamba Falaawo nti, “Engalo ya Katonda bino y’ebikoze.” Naye omutima gwa Falaawo ne gukakanyala, n’atabawuliriza, nga Mukama bwe yali agambye. ");
INSERT INTO lug_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Awo Mukama n’agamba Musa nti, “Keera mu makya nnyo, ogende osisinkane Falaawo ng’aserengeta ku mazzi omugambe nti, ‘Mukama agambye bw’ati nti, Leka abantu bange bagende, bansinze. ");
INSERT INTO lug_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Naye abantu bange bw’otoobakkirize kugenda, laba, ndireeta ebikuukuulu by’ensowera, ku ggwe ne ku baweereza bo, ne ku bantu bo, ne mu nnyumba zammwe. Ensowera zirijjula mu mayumba ga Bamisiri ne ku ttaka kwe gaazimbibwa. ");
INSERT INTO lug_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Naye ku lunaku olwo, ekitundu Goseni abantu bange gye babeera ndikiyisa mu ngeri ya njawulo; kubanga yo teribaayo bikuukuulu bya nsowera n’akatono, olyoke otegeere nga nze, Mukama, ndi wano wakati mu nsi. ");
INSERT INTO lug_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nzija kussaawo enjawulo wakati w’abantu bange n’abantu bo. Ekyamagero kino kijja kubaawo enkeera.’ ” ");
INSERT INTO lug_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Mukama n’akola bw’atyo. Ebikuukuulu by’ensowera ne byeyiwa mu lubiri lwa Falaawo, mu nnyumba ye, ne mu mayumba g’abaweereza be, ne mu nsi yonna ey’e Misiri: ensi n’eyonooneka olw’ebikuukuulu by’ensowera. ");
INSERT INTO lug_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Awo Falaawo n’atumira Musa ne Alooni, n’abagamba nti, “Kale, muweereeyo wano mu nsi eno ssaddaaka eri Katonda wammwe.” ");
INSERT INTO lug_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Naye Musa n’addamu nti, “Ekyo bwe tukikola, tekijja kuba kituufu. Kubanga ssaddaaka ze tuwaayo eri Mukama Katonda waffe, Abamisiri tebajja kuzaagala. Kale singa tuddira ssaddaaka Abamisiri ze bakyawa ennyo bwe batyo, ne tuziwaayo nga balaba, tebajja kutukuba amayinja? ");
INSERT INTO lug_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kitugwanira tutambule olugendo lwa nnaku ssatu mu ddungu, tuweeyo ssaddaaka eri Mukama Katonda waffe nga bw’anaatulagira.” ");
INSERT INTO lug_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Falaawo n’agamba nti, “Nzija kubaleka mugende muweeyo ssaddaaka eri Mukama Katonda wammwe mu ddungu, kyokka temugenda ewala ennyo. Kale munsabire.” ");
INSERT INTO lug_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa n’addamu nti, “Bwe nnaaba nakava wano w’oli nzija kusaba Mukama, enkya ensowera ziviire Falaawo n’abakungu be awamu n’abantu be. Naye kirungi Falaawo aleme nate kulimbalimba, n’atakkiriza bantu kugenda kuwaayo ssaddaaka eri Mukama.” ");
INSERT INTO lug_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Musa n’avaayo ewa Falaawo, n’asaba Mukama. ");
INSERT INTO lug_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Mukama n’akola nga Musa bwe yamusaba, n’aggyawo ebikuukuulu by’ensowera ewa Falaawo ne mu baweereza be, ne mu bantu be; ne watasigala nsowera n’emu. ");
INSERT INTO lug_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Kyokka ne ku mulundi guno, Falaawo yakakanyaza omutima gwe, abantu n’atabakkiriza kugenda. ");
INSERT INTO lug_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Awo Mukama n’agamba Musa nti, “Genda ewa Falaawo omugambe nti, Mukama Katonda wa Abaebbulaniya agambye nti, ‘Leka abantu bange bagende, bansinze. ");
INSERT INTO lug_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Singa ogaana okubakkiriza okugenda, n’oyongera okubakuumira wano, ");
INSERT INTO lug_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Mukama ajja kusindika nsotoka omukambwe ennyo mu magana go agali mu malundiro, ne mu mbalaasi ne mu ndogoyi, ne mu ŋŋamira, ne mu zisseddume z’ente ne mu ndiga. ");
INSERT INTO lug_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Naye Mukama ajja kwawulamu amagana aga Isirayiri n’aga Misiri, waleme kubaawo nsolo n’emu efa mu magana ag’abaana ba Isirayiri.’ ” ");
INSERT INTO lug_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mukama n’alonda ekiseera, n’agamba nti, “Enkya Mukama w’anaakolera ekintu kino mu nsi eno.” ");
INSERT INTO lug_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Era enkeera Mukama n’akola ekikolwa ekyo: amagana aga Misiri gonna ne gafa, naye ne wataba nsolo n’emu ku magana ag’abaana ba Isirayiri eyafa. ");
INSERT INTO lug_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Falaawo n’atuma abantu okwetegereza, ne basanga nga tewali wadde ensolo n’emu ey’abaana ba Isirayiri eyali efudde. Naye era omutima gwa Falaawo ne gusigala nga gukyakakanyadde, Abayisirayiri n’atabakkiriza kugenda. ");
INSERT INTO lug_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Awo Mukama n’agamba Musa ne Alooni nti, “Muyoole mu kyokero embatu z’omunyale, Musa agumanse waggulu mu bbanga nga ne Falaawo alaba. ");
INSERT INTO lug_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Gujja kufuuka nfuufu mu nsi yonna ey’e Misiri, guleete amayute ku bantu ne ku nsolo aganaatulikamu amabwa mu nsi yonna ey’e Misiri.” ");
INSERT INTO lug_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Bwe batyo ne bayoola omunyale mu kyokero, ne bagenda bayimirira mu maaso ga Falaawo. Musa n’amansa evvu waggulu mu bbanga, ne lifuuka amayute, ne gatulikamu amabwa ku bantu ne ku nsolo. ");
INSERT INTO lug_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Abalogo ne batasobola kuyimirira mu maaso ga Musa olw’amayute; kubanga amayute gaakwata abalogo n’Abamisiri bonna. ");
INSERT INTO lug_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Naye Mukama n’akakanyaza omutima gwa Falaawo, n’atawuliriza Musa ne Alooni, era nga Mukama bwe yagamba Musa. ");
INSERT INTO lug_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Awo Mukama n’agamba Musa nti, “Ozuukuka mu makya nnyo, n’ogenda oyolekera Falaawo, n’omugamba nti, Mukama Katonda wa Abaebbulaniya agamba bw’ati nti, ‘Leka abantu bange bagende, bampeereze. ");
INSERT INTO lug_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kubanga ku mulundi guno nzija kukusindikira kawumpuli ku ggwe kennyini, ne ku baweereza bo, ne ku bakungu bo, olyoke otegeere nga tewali ali nga nze mu nsi yonna. ");
INSERT INTO lug_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Kubanga nandiyinzizza okugolola omukono gwange ne nkusindikira olumbe, ggwe n’abantu bo, ne lubamalawo ku nsi. ");
INSERT INTO lug_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Naye olw’ensonga eno kyennava nkuleka n’obeera mulamu, ndyoke njolese amaanyi gange, era n’erinnya lyange liryoke litegeezebwe mu nsi yonna. ");
INSERT INTO lug_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Kyokka okyekulumbaliza ku bantu bange n’otobakkiriza kugenda, ");
INSERT INTO lug_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","noolwekyo, enkya obudde nga bwe buti, nzija kusindika kibuyaga ow’omuzira ogw’amayinja ogutagwangako mu Misiri kasookedde ensi eyo ebaawo. ");
INSERT INTO lug_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Kale, lagira bayingize amagana go ag’ente, n’ebisolo byonna ebiri mu ddundiro, kubanga omuzira gujja kukuba buli muntu ali ebweru era ajja kufa; ne buli nsolo yonna eneebeera ebweru mu ddundiro gujja kugikuba efe.’ ” ");
INSERT INTO lug_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Abakungu ba Falaawo abaali batya ekigambo kya Mukama, ne banguwa ne bayingiza abaddu baabwe n’amagana gaabwe. ");
INSERT INTO lug_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Naye abo abatassaayo mwoyo ku kigambo kya Mukama ne baleka abaddu baabwe n’amagana gaabwe ebweru. ");
INSERT INTO lug_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Awo Mukama n’agamba Musa nti, “Golola omukono gwo eri eggulu, omuzira gugwe ku nsi yonna ey’e Misiri: gukube abantu, n’ensolo, ne buli kimera kyonna ekiri mu nnimiro mu Misiri.” ");
INSERT INTO lug_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa n’ayolekeza omuggo gwe eri eggulu; Mukama n’asindika okubwatuka n’omuzira; laddu ne yakira ku ttaka. Bw’atyo Mukama n’atonnyesa omuzira ku nsi y’e Misiri. ");
INSERT INTO lug_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Omuzira ne gugwa, n’okumyansa ne kwetabika n’omuzira awatali kusalako, ne guba mungi nnyo, nga tegugwangako bwe gutyo kasookedde ensi ya Misiri efuuka ggwanga. ");
INSERT INTO lug_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Omuzira gwakuba buli kintu kyonna ekyali ebweru mu nnimiro mu nsi yonna ey’e Misiri: abantu n’ensolo; era omuzira ne gukuba buli kimera kyonna mu nnimiro, ne gusensebula emiti gyonna ku ttale. ");
INSERT INTO lug_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ekitundu kyokka ekitaatuukwamu muzira, kye kya Goseni, abaana ba Isirayiri gye baabeeranga. ");
INSERT INTO lug_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Awo Falaawo n’atumya Musa ne Alooni, n’abagamba nti, “Leero luno nnyonoonye; Mukama ye mutuufu, naye nze n’abantu bange ffe bakyamu. ");
INSERT INTO lug_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Weegayirire Mukama; kubanga omuzira n’okubwatuka bitwetamizza. Nzija kubaleka mugende; siraba kyemuva mweyongera kubeera wano.” ");
INSERT INTO lug_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa n’addamu nti, “Olunaafuluma mu kibuga, nnaagolola emikono gyange waggulu eri Mukama ne mmusaba. Okubwatuka kunaasirika, n’omuzira gunaalekera awo okugwa; olyoke otegeere ng’ensi eno Mukama ye nannyini yo. ");
INSERT INTO lug_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Kyokka mmanyi nga ggwe n’abakungu bo temunnatya Mukama Katonda.” ");
INSERT INTO lug_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Obugoogwa ne sayiri byakubwa ne bizikirizibwa, kubanga sayiri yali ayengera nga n’obugoogwa bumulisizza. ");
INSERT INTO lug_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Naye eŋŋaano n’omukyere, byo tebyayonoonebwa kubanga byali tebinnayengera.) ");
INSERT INTO lug_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa n’ava mu kibuga ewa Falaawo, n’awanika emikono gye eri Mukama ng’amusaba; okubwatuka n’omuzira ne bisirika, era n’enkuba n’ekya. ");
INSERT INTO lug_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Naye Falaawo bwe yalaba enkuba, n’omuzira, n’okubwatuka nga birekeddaawo, ate ne yeeyongera okusobya; ye n’abakungu be ne bakakanyaza emitima gyabwe. ");
INSERT INTO lug_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Omutima gwa Falaawo bwe gutyo ne gukakanyala; n’ataleka baana ba Isirayiri kugenda, era nga Mukama bwe yayogerera mu Musa. ");
INSERT INTO lug_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Awo Mukama n’agamba Musa nti, “Genda eri Falaawo, kubanga nnyongedde okukakanyaza omutima gwe, n’omutima gw’abaweereza be, ndyoke mbalage ebyamagero byange bino: ");
INSERT INTO lug_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","era naawe onyumize abaana bo, n’abaana b’abaana bo, ebintu bye nkoledde mu Misiri, n’ebyamagero bye mbalaze; nammwe mulyoke mutegeere nga nze Mukama.” ");
INSERT INTO lug_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Awo Musa ne Alooni ne bagenda ewa Falaawo, ne bamugamba nti, “Mukama Katonda wa Abaebbulaniya n’agamba bw’ati nti, ‘Olituusa ddi ng’okyagaanye okwetoowaza mu maaso gange? Leka abantu bange bagende, bansinze. ");
INSERT INTO lug_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Singa ogaana okubakkiriza okugenda, enkya nzija kuleeta enzige mu nsi yo. ");
INSERT INTO lug_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Zijja kubikka ensi yonna, wabulewo n’omuntu w’ayisa eriiso okulaba ettaka. Zijja kulya ebyo omuzira bye gwalekawo, zirye ne buli muti ogukula mu nnimiro. ");
INSERT INTO lug_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Zinajjuza amayumba go, n’amayumba g’abakungu bo bonna, n’amayumba g’Abamisiri bonna; ekyo bakadde bo, ne bakadde ba bakadde bo nga tebakirabangako kasookedde babeera mu nsi eno n’okutuusa leero.’ ” Musa n’akyuka n’aviira Falaawo. ");
INSERT INTO lug_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Abakungu ba Falaawo ne bamugamba nti, “Omusajja ono alituusa ddi ng’atufuukidde omutego? Leka abantu bagende basinze Mukama Katonda waabwe. Ggwe tolaba Misiri nga bw’eweddewo?” ");
INSERT INTO lug_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Musa ne Alooni ne bazzibwa awali Falaawo. N’abagamba nti, “Kale, mugende musinze Mukama Katonda wammwe. Naye abagenda be baani?” ");
INSERT INTO lug_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa n’addamu nti, “Abakulu n’abato, batabani baffe ne bawala baffe bonna tujja kugenda nabo; era tugenda n’amagana gaffe n’ebisibo byaffe, kubanga waliwo embaga gye tujja okukolera Mukama.” ");
INSERT INTO lug_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Falaawo n’abagamba nti, “Mukama abeere nammwe, obanga mulowooza nga nzija kubaleka mugende, mmwe n’abaana bammwe! Nze ndaba nga mulina olukwe lwe muteekateeka. ");
INSERT INTO lug_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nedda! Abasajja bokka ka bagende basinzeMukama; kubanga ekyo kye mwagala.” Ne bagobebwa awali Falaawo. ");
INSERT INTO lug_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Awo Mukama Katonda n’agamba Musa nti, “Golola omukono gwo ku nsi ya Misiri oyite enzige, zijje ku nsi ya Misiri, zirye buli kantu konna akamera mu nnimiro, n’ebyo byonna omuzira bye gwataliza.” ");
INSERT INTO lug_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa n’agolola omuggo gwe ku nsi ya Misiri; Mukama Katonda n’aleeta embuyaga ezaava ebuvanjuba, ne zikunta olunaku olwo lwonna n’ekiro kyonna. Obudde bwe bwakya embuyaga ne zireeta enzige. ");
INSERT INTO lug_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Enzige nnyingi nnyo ne zigwa ku nsi yonna ey’e Misiri, ne zigisaanikira, okuva ku nsalo yaayo ey’oluuyi olumu okutuuka ku y’oluuyi olulala. Zaali nzige za kabi kanene, nga tewalabikanga ziri ng’ezo, era tezigenda kulabika. ");
INSERT INTO lug_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Zaabuutikira ensi yonna, ne wabaawo ekizikiza ku nsi; ne zirya buli kimera kyonna mu nsi, n’ebibala byonna eby’emiti omuzira bye gwali gutalizza; era tewaasigalawo kintu kyonna kya kiragala ku miti n’ebimera mu nnimiro, mu nsi yonna ey’e Misiri. ");
INSERT INTO lug_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Awo Falaawo n’atumya Musa ne Alooni bunnambiro, n’abagamba nti, “Nnyonoonye eri Mukama Katonda wammwe ne gye muli. ");
INSERT INTO lug_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Mbeegayiridde munsonyiwe olw’okwonoona kwange, omulundi guno gwokka; era musabe Mukama Katonda wammwe anziggyeeko olumbe luno lwokka olututta.” ");
INSERT INTO lug_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa n’ava ewa Falaawo ne yeegayirira Mukama. ");
INSERT INTO lug_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Awo Mukama n’aleeta embuyaga ez’amaanyi ennyo nga ziva ebuvanjuba, ne zisitula enzige ne zizisuula mu Nnyanja Emyufu. Tewaasigala nzige n’emu wonna wonna mu nsi y’e Misiri. ");
INSERT INTO lug_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Naye Mukama n’akakanyaza omutima gwa Falaawo, abaana ba Isirayiri n’atabakkiriza kugenda. ");
INSERT INTO lug_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Awo Mukama n’agamba Musa nti, “Golola omukono gwo waggulu eri eggulu, wabeewo ekizikiza ku nsi ey’e Misiri; ekizikiza ekiyinza n’okuwulikika.” ");
INSERT INTO lug_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa n’agolola omukono gwe eri eggulu; ne wabaawo ekizikiza ekikwafu mu nsi yonna ey’e Misiri okumala ennaku ssatu. ");
INSERT INTO lug_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Abantu bonna nga tewali asobola kulaba munne; era tewaali yaseguka kuva mu kifo kye w’abeera okumala ennaku ssatu. Naye bo abaana ba Isirayiri ewaabwe ng’obudde bulaba. ");
INSERT INTO lug_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Awo Falaawo n’atumya Musa, n’amugamba nti, “Mugende musinze Mukama. Abaana bammwe nabo mugende nabo, wabula ente zammwe, n’embuzi n’endiga ze ziba zisigala.” ");
INSERT INTO lug_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Naye Musa n’addamu nti, “Osaana otuleke tutwale ebisolo eby’okuwaayo ssaddaaka n’ebiweebwayo ebyokebwa eri Mukama Katonda waffe. ");
INSERT INTO lug_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ente zaffe tusaana okugenda nazo; tewali nsolo n’emu eneesigala. Kubanga kitusaanira okuzitwala nga tugenda okusinza Mukama Katonda waffe; kubanga tujja kumala kutuuka eri, ne tulyoka tumanya kye tunaakozesa mu kusinza Mukama.” ");
INSERT INTO lug_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Naye Mukama n’akakanyaza omutima gwa Falaawo, n’atabaleka kugenda. ");
INSERT INTO lug_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Falaawo n’agamba Musa nti, “Nva mu maaso! Era weekuume, sikulabanga ng’okomyewo w’endi; bwe ndiddayo okukulaba tolirema kufa.” ");
INSERT INTO lug_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa n’addamu nti, “Nga bw’ogambye, nange siriddayo kukulaba.” ");
INSERT INTO lug_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Awo Mukama n’agamba Musa nti, “Ekyaliyo ekibonoobono kimu kye nzija okuleetera Falaawo n’ensi y’e Misiri. Oluvannyuma lwakyo ajja kubaleka mugende; ate bw’anaabakkiriza okugenda, ajja kubeegoberako ddala bwegobi abasindiikirize. ");
INSERT INTO lug_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Kale, tegeeza abantu, buli musajja asabanga muliraanwa we, ne buli mukazi asabanga muliraanwa we, ebintu eby’omuwendo ebya ffeeza n’ebya zaabu.” ");
INSERT INTO lug_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Mukama n’aleetera Abamisiri okukwanagana n’abaana ba Isirayiri; ne Musa n’aweebwa nnyo ekitiibwa mu nsi y’e Misiri. Abakungu ba Falaawo n’abantu bonna ne bamugulumiza nnyo. ");
INSERT INTO lug_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Awo Musa n’agamba Falaawo nti, “Mukama agambye bw’ati nti, ‘Nga wakati mu ttumbi, nzija kuyita mu Misiri yonna. ");
INSERT INTO lug_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ebibereberye mu nsi y’e Misiri bijja kufa, okutandikira ku mubereberye wa Falaawo agenda okumusikira, okutuukira ddala ku mubereberye w’omuwala omuzaana asa ku lubengo; era n’ebibereberye byonna eby’ebisolo. ");
INSERT INTO lug_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Wajja kubaawo okukungubaga okunene mu nsi yonna eya Misiri, okutabangawo era nga tewagenda kubaawo kukwenkana. ");
INSERT INTO lug_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Naye mu baana ba Isirayiri n’embwa teribaayo gw’eboggolera wadde ebisolo byabwe; mulyoke mutegeere nga Mukama Abamisiri n’Abayisirayiri tabayisa bumu.’ ");
INSERT INTO lug_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Era bano abakungu bo bonna balijja gye ndi nga babundabunda, ne banvuunamira nga banneegayirira nti, ‘Genda, ggwe n’abantu bo bonna abakugoberera.’ Oluvannyuma lw’ebyo nange ndigenda.” N’ava awali Falaawo n’obusungu bungi nnyo. ");
INSERT INTO lug_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Mukama yali agambye Musa nti, “Falaawo tagenda kuwuliriza by’omugamba, bwe ntyo ndyoke nkolere ebyamagero byange bingi mu Misiri.” ");
INSERT INTO lug_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa ne Alooni baakolera ebyamagero ebyo byonna awali Falaawo; naye Mukama yakakanyaza omutima gwa Falaawo, n’atakkiriza baana ba Isirayiri kuva mu nsi ye. ");
INSERT INTO lug_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Awo Mukama n’ayogera ne Musa ne Alooni nga bali mu nsi y’e Misiri, n’abagamba nti, ");
INSERT INTO lug_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Okuva leero omwezi guno gwe gunaabanga omubereberye mu myezi gyonna mu mwaka gwammwe. ");
INSERT INTO lug_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Mutegeeze abantu bonna aba Isirayiri nti ku lunaku olw’ekkumi olw’omwezi guno kigwanidde buli mukulu wa nnyumba, addire omwana gw’endiga ogw’okuliibwa mu maka ge, buli maka omwana gw’endiga gumu. ");
INSERT INTO lug_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Singa amaka gabaamu abantu batono nnyo abatamalaawo mwana gwa ndiga, amaka ago geegatte n’ag’omuliraano balye omwana gw’endiga ogwo. Muligeraageranya obungi bw’abantu abamalawo omwana gw’endiga nga musinziira ku ndya ya buli omu mu maka omwo. ");
INSERT INTO lug_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Omwana gw’endiga gusaana gube gwa seddume nga gwa mwaka gumu obukulu, era nga teguliiko kamogo. Guyinza okuba omwana gw’endiga oba ogw’embuzi. ");
INSERT INTO lug_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ensolo ezo muzirabiriranga okutuusa ku lunaku olw’ekkumi n’ennya olw’omwezi guno; ekibiina kyonna eky’abantu ba Isirayiri ne kiryoka kizitta akawungeezi. ");
INSERT INTO lug_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Baddiranga omusaayi ne bagumansira ku njuyi zombi ne waggulu, ku mwango gw’oluggi lwa buli nnyumba mwe baliriira omwana gw’endiga. ");
INSERT INTO lug_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Mu kiro ekyo ennyama balyanga njokye ku muliro, era baliirangako n’emigaati egitali mizimbulukuse n’enva ezikaawa. ");
INSERT INTO lug_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Tewabanga ku nnyama eyo gye mulya nga mbisi obanga efumbwa mu mazzi; wabula mugyokyanga ku muliro: omutwe, amagulu n’eby’omunda byonna. ");
INSERT INTO lug_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Temugiterekangako kutuusa nkeera; bw’ebalemanga eggulolimu, mugyokyanga bwokya ne mugizikiriza. ");
INSERT INTO lug_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Mugiryanga bwe muti: Mwesibanga ekimyu, nga mwambadde n’engatto zammwe, nga mukutte n’omuggo. Mugiryanga mangu. Kubanga eyo y’Embaga ey’Okuyitako kwa Mukama. ");
INSERT INTO lug_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Kubanga mu kiro ekyo ndiyita mu nsi ya Misiri, nditta buli kibereberye kyonna mu nsi y’e Misiri, abantu era n’ebisolo; era bakatonda bonna ab’omu Misiri ndibasalira omusango. Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Omusaayi ke kaliba akabonero akalaga ennyumba mwe muli; era bwe ndiraba omusaayi, nga mbayitako; so n’okuzikirira kwe ndireeta ku Bamisiri mmwe tekulibakwatako. ");
INSERT INTO lug_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Olunaku luno lunaababeereranga lwa kijjukizo, era munaalukuumanga ne mulukwata nga lwa mbaga ya Mukama mu mirembe gyammwe gyonna egiriddiriŋŋana. Lino lifuuse tteeka ery’emirembe gyonna. ");
INSERT INTO lug_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Munaalyanga emigaati egitali mizimbulukuse okumala ennaku musanvu; era ku lunaku olusooka, mu nnaku ezo omusanvu, ekizimbulukusa mukiggiranga ddala mu nnyumba zammwe, kubanga alivumbulwa ng’alidde omugaati ogulimu ekizimbulukusa, okuva ku lunaku olusooka okutuusa ku lunaku olw’omusanvu, aligobebwa mu Isirayiri. ");
INSERT INTO lug_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ku lunaku olusooka wanaabangawo olukuŋŋaana olutukuvu, ne ku lunaku olw’omusanvu munaabanga n’olukuŋŋaana olutukuvu; ennaku ezo temuzikolerangako mulimu gwa ngeri yonna, okuggyako okufumba emmere abantu bonna gye banaalya, kye kyokka kye mujjanga okukola. ");
INSERT INTO lug_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Mukwatanga Embaga ey’Emigati Egitali mizimbulukuse, kubanga ku lunaku luno lwennyini kwe naggyira ebika bya Isirayiri mu nsi y’e Misiri. Noolwekyo olunaku luno munaalukwatanga n’ab’omu mirembe gyonna egiriddawo. Ekyo kiragiro eky’emirembe n’emirembe. ");
INSERT INTO lug_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mu mwezi ogusooka, munaalyanga omugaati ogutaliimu kizimbulukusa, okuva mu kawungeezi ak’olunaku olw’ekkumi n’ennya olw’omwezi, okutuusa ku lunaku olw’amakumi abiri mu olumu olw’omwezi ogwo. ");
INSERT INTO lug_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Okumala ennaku musanvu mu nnyumba zammwe temulabikangamu ekizimbulukusa; era alivumbulwa ng’alidde ekintu kyonna omuli ekizimbulukusa, agenda kugobwa mu Isirayiri, ne bwaliba omuzaaliranwa oba omugwira. ");
INSERT INTO lug_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Temulyanga kintu kyonna omuli ekizimbulukusa; mu nnyumba zammwe mwe musula yonna, mulyanga emigaati egitali mizimbulukuse.” ");
INSERT INTO lug_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Awo Musa n’ayita abakulembeze ba Isirayiri bonna, n’abagamba nti, “Mwerondere abaana b’endiga ng’amaka gammwe bwe gali, mutte omwana gw’endiga ogw’Okuyitako. ");
INSERT INTO lug_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Musibe bulungi akaddo k’akakubansiri, mukannyike mu musaayi gwe mutadde mu bensani, mulyoke mumansire ku mwango gw’oluggi waggulu, ne ku njuyi zombi ez’omwango. Tewabaawo n’omu afuluma ennyumba ye okutuusa ng’obudde bukedde. ");
INSERT INTO lug_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Kubanga Mukama ajja kuyita awo ng’agenda okutta Abamisiri; kale bw’anaalaba omusaayi ku mwango gw’oluggi waggulu ne ku mwango mu mbiriizi z’oluggi, oluggi olwo Mukama ajja kuluyitako, era tajja kukkiriza oyo azikiriza kuyingira mu nnyumba zammwe n’okubatta. ");
INSERT INTO lug_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Kibagwanira okugondera ebiragiro bino ng’etteeka, mmwe ne batabani bammwe emirembe gyonna. ");
INSERT INTO lug_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Era bwe muliyingira mu nsi Mukama gy’alibawa nga bwe yasuubiza, temwerabiranga mukolo guno. ");
INSERT INTO lug_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Abaana bammwe bwe balibabuuza nti, ‘Omukolo guno gutegeeza ki?’ ");
INSERT INTO lug_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Mulibaddamu nti, ‘Kino kye kiweebwayo eri Mukama eky’Okuyitako, kubanga yayita ku nnyumba z’Abayisirayiri mu Misiri, n’awonya amaka gaffe, bwe yatta Abamisiri.’ ” Awo abantu ne bavuunama ne basinza. ");
INSERT INTO lug_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Abaana ba Isirayiri ne bagenda ne bakola nga Mukama bwe yalagira Musa ne Alooni, bwe batyo bwe baakola. ");
INSERT INTO lug_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Awo ekiro mu ttumbi Mukama n’atta ebibereberye byonna mu nsi y’e Misiri, okuviira ddala ku mubereberye wa Falaawo eyali ow’okumusikira, okutuuka ku mubereberye w’omusibe ali mu kkomera; era n’ente embereberye zonna. ");
INSERT INTO lug_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Falaawo n’azuukuka mu kiro wakati, ye n’abaweereza be bonna, n’Abamisiri bonna; Misiri yonna n’ejjula okukungubaga, kubanga tewaaliwo nnyumba n’emu omutaafa muntu. ");
INSERT INTO lug_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Mu kiro ekyo Falaawo n’atumya Musa ne Alooni n’abagamba nti, “Musituke! Mutuviire, nze n’abantu bange, mmwe n’abaana ba Isirayiri. Mugende musinze Mukama nga bwe mwansaba. ");
INSERT INTO lug_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Mutwale amagana gammwe n’ebisibo byammwe nga bwe mwansaba, mugende; nange munsabirangayo omukisa!” ");
INSERT INTO lug_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Awo Abamisiri ne basindiikiriza abaana ba Isirayiri banguwe okubaviira mu nsi yaabwe; kubanga baagamba nti, “Ffenna tufa tuggwaawo!” ");
INSERT INTO lug_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Abaana ba Isirayiri ne baddira obuwunga bwabwe obw’emigaati obugotte, obutaliimu kizimbulukusa, ne babussa mu bbakuli omufumbirwa emigaati, ne babuzinga mu ngoye zaabwe, ne babutwalira ku bibegabega byabwe. ");
INSERT INTO lug_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Baakola nga Musa bwe yabalagira, ne basaba Abamisiri eby’omuwendo ebya ffeeza n’ebya zaabu, awamu n’ebyambalo. ");
INSERT INTO lug_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Mukama yali aleetedde abaana ba Isirayiri okuganja mu Bamisiri, bwe batyo ne baweebwa buli kye baasabanga. Ne baleka nga bakalizza Abamisiri. ");
INSERT INTO lug_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Awo abaana ba Isirayiri ne batambula okuva e Lameseesi ne batuuka e Sukkosi. Baali abantu ng’emitwalo nkaaga, ng’abakazi n’abaana tebabaliddwa. ");
INSERT INTO lug_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Waaliwo n’abantu abalala bangi abaagenda nabo. Baatwala amagana g’ente mangi, n’ebisibo, bingi nnyo. ");
INSERT INTO lug_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ne beefumbira emigaati mu buwunga obugotte bwe baggya mu Misiri, naye tegyalimu kizimbulukusa, kubanga baasindiikirizibwa busindiikirizibwa okuva mu Misiri, ne bataba na budde bwa kwefumbira mmere. ");
INSERT INTO lug_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Emyaka abaana ba Isirayiri gye baamala mu Misiri gyawera ebikumi bina mu amakumi asatu. ");
INSERT INTO lug_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ku lunaku olwasembayo olwaweza emyaka ebikumi ebina mu asatu, eggye lya Mukama eryo lyonna kwe lyasitulira ne liva mu nsi y’e Misiri. ");
INSERT INTO lug_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Mukama yali bulindaala ekiro ky’olunaku olwo, n’aggya abaana ba Isirayiri mu nsi y’e Misiri; noolwekyo abaana ba Isirayiri banajjukiranga Mukama ekiro ky’olunaku olwo emirembe gyabwe gyonna. ");
INSERT INTO lug_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Awo Mukama n’agamba Musa ne Alooni nti, “Bino by’ebiragiro by’Okuyitako: “Omunaggwanga takkirizibwa kugiryako. ");
INSERT INTO lug_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Omuddu aguliddwa n’ensimbi akkirizibwa okugiryako singa amala okukomolebwa; ");
INSERT INTO lug_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","naye omugenyi omugwira, n’omupakasi akola awaka, tebakkirizibwa kugiryako. ");
INSERT INTO lug_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Buli ndiga eneerirwanga mu nnyumba emu; ennyama eyo tekuubengako efulumizibwa bweru wa nju eyo. Temumenyanga ku magumba gaayo n’erimu. ");
INSERT INTO lug_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Abantu bonna aba Isirayiri banaakolanga omukolo guno. ");
INSERT INTO lug_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Omunaggwanga abeera mu mmwe bw’abanga ayagala okukolera Mukama Katonda omukolo gw’Okuyitako, asaana asooke okukomola abantu be aboobulenzi bonna abali mu maka ge, alyoke asembere gye muli yeegatte mu mukolo ogwo; kubanga olwo anaabanga ng’omuzaaliranwa mu nsi omwo. Naye atali mukomole taagiryengako. ");
INSERT INTO lug_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Etteeka lye limu lye linaakwatibwanga omuzaaliranwa n’Omunnaggwanga abeera mu mmwe.” ");
INSERT INTO lug_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Bwe batyo abaana ba Isirayiri bonna ne bakola nga Mukama Katonda bwe yalagira Musa ne Alooni; bwe batyo bonna bwe baakola. ");
INSERT INTO lug_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Awo ku lunaku olwo lwennyini Mukama Katonda n’aggya abaana ba Isirayiri mu nsi ey’e Misiri nga bagendera mu bibinja byabwe. ");
INSERT INTO lug_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Ebibereberye byonna binjawulireko. Abaana abaggulanda mu Isirayiri yonna banaabanga bange; n’ebisolo ebiggulanda nabyo binaabanga byange.” ");
INSERT INTO lug_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Awo Musa n’agamba abantu nti, “Mujjukiranga olunaku luno, olunaku lwe mwaviirako mu Misiri, ensi gye mwafugibwanga ng’abaddu, kubanga Mukama yabaggyayo n’omukono gwe ogw’amaanyi. Temuliirangako mugaati gulimu kizimbulukusa. ");
INSERT INTO lug_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ku lunaku lwa leero olw’omwezi guno Abibu, lwe musitudde okuva mu Misiri. ");
INSERT INTO lug_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mukama bw’alimala okubatuusa mu nsi y’Abakanani, n’Abakiiti, n’Abamoli; n’ey’Abakiivi, n’Abayebusi, ensi gye yalayirira bajjajjammwe okugibawa, ensi ekulukuta amata n’omubisi gw’enjuki, mukwatanga omukolo guno mu mwezi guno. ");
INSERT INTO lug_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mumalanga ennaku musanvu nga mulya emigaati egitaliimu kizimbulukusa, ne ku lunaku olw’omusanvu kwe munaakoleranga embaga ya Mukama. ");
INSERT INTO lug_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Munaalyanga emigaati egitali mizimbulukuse okumala ennaku musanvu; tewabangawo alabika n’omugaati omuzimbulukuse, wadde ekizimbulukusa okusangibwa nammwe mu nsi yammwe. ");
INSERT INTO lug_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ku lunaku olwo mulitegeeza abaana bammwe nti, ‘Tukola tuti nga tujjukira ebyo Mukama bye yatukolera nga tuva mu Misiri.’ ");
INSERT INTO lug_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Omukolo guno gunaababeereranga ng’akabonero ku mikono gyammwe, oba mu byenyi wakati w’amaaso gammwe, okubajjukizanga etteeka lya Mukama eritaavenga ku mimwa gyammwe. Kubanga Mukama yabaggya mu Misiri n’omukono gwe ogw’amaanyi. ");
INSERT INTO lug_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Noolwekyo onookolanga ekiragiro kino bye kigamba, mu kiseera kyakyo buli mwaka, buli mwaka. ");
INSERT INTO lug_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Mukama ng’amaze okubatuusa mu nsi y’Abakanani, nga bwe yabalayirira mmwe ne bajjajja bammwe, era agenda kugibawa, ");
INSERT INTO lug_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Mukama mumwawulirangako ebiggulanda byonna. Zisseddume zonna embereberye ez’amagana gammwe zinaabanga za Mukama. ");
INSERT INTO lug_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Buli kalogoyi akabereberye mukawaanyisangamu omwana gw’endiga ne mukanunulayo, naye bwe mutaakanunulenga mukamenyanga ensingo ne kafa. Ne buli mutabani wammwe omubereberye mumununulanga. ");
INSERT INTO lug_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Awo olulituuka batabani bammwe, bwe bababuuzanga nti, ‘Kino kye mukola kitegeeza ki?’ Mubaddangamu nti, ‘Kubanga Mukama yatuggya mu Misiri, ensi ey’obuddu, n’omukono gwe ogw’amaanyi. ");
INSERT INTO lug_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Naye Falaawo bwe yali ng’akakanyadde ng’atugaanye okuvaayo, Mukama n’atta ebibereberye byonna mu nsi y’e Misiri; ababereberye b’abantu n’ebibereberye by’ebisolo. Noolwekyo kyetuva tuwaayo ssaddaaka eri Mukama ey’ebiggulanda byonna ebisajja; naye batabani baffe abaggulanda tubanunulayo.’ ");
INSERT INTO lug_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Omukolo ogwo gunaababeereranga ng’akabonero akookebbwa ku mikono gyammwe, oba mu byenyi wakati w’amaaso gammwe; kubanga Mukama yabaggya mu Misiri n’omukono gwe ogw’amaanyi.” ");
INSERT INTO lug_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Awo abantu, bwe baasitula nga Falaawo amaze okubaleka, Katonda teyabayisa mu kkubo eriyita mu nsi y’Abafirisuuti, newaakubadde lye lyali ery’okumpi. Kubanga Katonda yagamba nti, “Singa bagwa mu lutalo, bayinza okwejjusa ne bawetamu ne baddayo e Misiri.” ");
INSERT INTO lug_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Bw’atyo Katonda n’abeekooloobya ng’abayisa mu kkubo ery’omu ddungu eriggukira ku Nnyanja Emyufu. Abaana ba Isirayiri baava mu nsi y’e Misiri nga bakutte ebyokulwanyisa byabwe nga beetegekedde okulwana. ");
INSERT INTO lug_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Awo Musa n’avaayo n’amagumba ga Yusufu, kubanga Yusufu yali alayizza abaana ba Isirayiri. Yabagamba nti, “Ddala, ddala Mukama agenda kubadduukirira. Kale, amagumba gange mugendanga nago nga muva wano.” ");
INSERT INTO lug_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Bwe baava e Sukkosi ne bakuba eweema zaabwe mu Yesamu eddungu we litandikira. ");
INSERT INTO lug_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Emisana Mukama yabakulemberanga ng’ali mu mpagi ey’ekire okubalaga ekkubo, n’ekiro ng’ali mu mpagi ey’omuliro okubamulisiza, balyoke batambulenga emisana n’ekiro. ");
INSERT INTO lug_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Empagi ey’ekire ey’emisana, n’empagi ey’omuliro ey’ekiro tezaggibwawo mu maaso g’abantu obudde bwonna. ");
INSERT INTO lug_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Awo Mukama n’alagira Musa nti, ");
INSERT INTO lug_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Tegeeza abaana ba Isirayiri bawetemu nga boolekera Pikakirosi, bakube eweema zaabwe okumpi ne Pikakirosi, wakati wa Migudooli n’ennyanja. Musiisire ku lubalama lw’ennyanja nga mwolekedde Baali Zefoni. ");
INSERT INTO lug_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Falaawo abaana ba Isirayiri ajja kuboogerako nti, ‘Babulubuutira mu nsi yaffe, n’eddungu libazingizza.’ ");
INSERT INTO lug_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nzija kukakanyaza omutima gwa Falaawo, alyoke abawondere. Naye ndyefunira ekitiibwa okuva ku bye ndikola Falaawo n’eggye lye lyonna; n’Abamisiri balitegeera nga nze Mukama.” Abaana ba Isirayiri ne bakola bwe batyo. ");
INSERT INTO lug_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kabaka w’e Misiri bwe yategeera ng’Abayisirayiri baddukidde ddala, Falaawo n’abakungu be ne bejjusa, ne bagamba nti, “Kiki kino kye tukoze, okuleka Abayisirayiri ababadde batukolera ne bagenda?” ");
INSERT INTO lug_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Bw’atyo n’ateekateeka eggaali lye erisikibwa embalaasi, n’eggye ly’anaagenda nalyo. ");
INSERT INTO lug_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Yatwala amagaali lukaaga agasingira ddala obulungi, n’agattako n’amagaali amalala gonna agaali mu Misiri, n’abalwanyi abaduumizi nga be bagavuga. ");
INSERT INTO lug_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mukama n’akakanyaza omutima gwa Falaawo Kabaka w’e Misiri, n’agoberera abaana ba Isirayiri. Abaana ba Isirayiri ne bakwata olugendo lwabwe nga tebaliiko gwe batya. ");
INSERT INTO lug_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Abamisiri ne babawondera: embalaasi zonna, n’amagaali gonna aga Falaawo agasikibwa embalaasi, n’abeebagadde embalaasi, n’eggye lye, ne babasanga nga basiisidde ku lubalama lw’ennyanja okumpi ne Pikakirosi, nga boolekedde Baali Zefoni. ");
INSERT INTO lug_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Falaawo bwe yasembera, abaana ba Isirayiri ne balengera Abamisiri nga babagoberera, ne batya nnyo. Abaana ba Isirayiri ne balaajaanira Mukama. ");
INSERT INTO lug_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ne bagamba Musa nti, “Mu Misiri entaana tezaaliyo, kyewava otuleeta tufiire wano mu ddungu? Lwaki watuggya mu Misiri n’ojja otuyisa bw’oti? ");
INSERT INTO lug_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Bwe twali mu Misiri tetwakugamba nti, ‘Tuveeko, tuleke tukolere Abamisiri?’ Kubanga okukolera Abamisiri kyandibadde waddeko okusinga okufiira mu ddungu.” ");
INSERT INTO lug_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa n’addamu abantu nti, “Temutya, munywere, mujja kulaba obulokozi Mukama bw’anaabaleetera olwa leero. Kubanga Abamisiri abo be mulaba kaakano, temuliddayo nate kubalaba emirembe gyonna. ");
INSERT INTO lug_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Mukama ajja kubalwanirira. Mmwe musirike busirisi.” ");
INSERT INTO lug_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Mukama n’agamba Musa nti, “Lwaki okaabirira nze? Lagira abaana ba Isirayiri bakwate olugendo lwabwe. ");
INSERT INTO lug_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Wanika omuggo gwo, ogolole n’omukono gwo ku nnyanja, amazzi ogaawulemu, abaana ba Isirayiri bayite wakati mu nnyanja kyokka nga batambulira ku ttaka kkalu. ");
INSERT INTO lug_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nange nzija kukakanyaza emitima gy’Abamisiri, bayingirire ennyanja nga babagoberera. Ndyoke nefunire ekitiibwa okusinziira ku bye nnaakola Falaawo, n’amaggye ge, n’amagaali ge, n’abeebagadde embalaasi. ");
INSERT INTO lug_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Abamisiri nabo banaategeera nga nze Mukama, nga nefunidde ekitiibwa: okusinziira ku bye nnaakola Falaawo n’amagaali ge, n’abasajja be abeebagadde embalaasi.” ");
INSERT INTO lug_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Awo malayika wa Katonda eyali akulembera abaana ba Isirayiri n’akyuka n’abadda emabega; n’empagi ey’ekire ne yejjulula okuva mu maaso gaabwe, n’eyimirira emabega waabwe: ");
INSERT INTO lug_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Bw’etyo n’ebeera wakati w’abaana ba Isirayiri n’eggye ly’Abamisiri. Ekiro, ekire ne kireeta ekizikiza ku ludda lw’Abamisiri, naye ne kireeta omuliro okumulisa oludda lw’Abayisirayiri; ekiro kyonna ne wataba ggye lisemberera linnaalyo. ");
INSERT INTO lug_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Awo Musa n’agolola omukono gwe ku nnyanja; Mukama n’asindika ku nnyanja embuyaga ez’amaanyi ezaava ebuvanjuba, ne zigobawo amazzi ekiro kyonna, ne lufuuka lukalu, ng’amazzi gayawuddwamu. ");
INSERT INTO lug_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Abaana ba Isirayiri ne bayita wakati mu nnyanja nga batambulira ku ttaka ekkalu, ng’amazzi gakoze ekisenge ku ludda lwabwe olwa ddyo n’olwa kkono. ");
INSERT INTO lug_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Abamisiri ne babawondera ne bayingira wakati mu nnyanja n’amagaali ga Falaawo gonna, n’embalaasi ze, n’abasajja be abeebagadde embalaasi. ");
INSERT INTO lug_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Awo mu makya ennyo nga tebunnalaba, Mukama n’atunuulira eggye ly’Abamisiri ng’ali mu mpagi ey’ekire n’omuliro, n’atandika okulibonyaabonya. ");
INSERT INTO lug_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Amagaali gaabwe yagamaamulako zinnamuziga, ne gabakaluubirira okuvuga. Abamisiri n’okugamba ne bagamba nti, “Leka Abayisirayiri tubadduke! Kubanga Mukama alwanyisa Misiri ng’abalwanirira.” ");
INSERT INTO lug_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Awo Mukama n’agamba Musa nti, “Golola omukono gwo ku nnyanja, amazzi gakomewo gaggweere ku Bamisiri, ne ku magaali gaabwe, ne ku basajja baabwe abeebagadde embalaasi.” ");
INSERT INTO lug_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Bw’atyo Musa n’agololera ennyanja omukono gwe, obudde bwe bwakya n’ekomawo n’amaanyi, Abamisiri ne bagidduka nga balaba ejja; Mukama, Abamisiri n’abasaanyaawo wakati mu nnyanja. ");
INSERT INTO lug_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Amazzi ne gakomawo ne gasaanikira amagaali n’abeebagadde embalaasi, n’eggye lya Falaawo lyonna eryali ligoberedde Abayisirayiri mu nnyanja. Tewaali n’omu ku bo eyawona. ");
INSERT INTO lug_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Naye abaana ba Isirayiri bo nga batambulira ku ttaka kkalu wakati mu nnyanja, amazzi nga gakoze ekisenge ku ludda lwabwe olwa ddyo ne ku lwa kkono. ");
INSERT INTO lug_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Bwe kityo ku lunaku olwo Abayisirayiri Mukama n’abawonya Abamisiri. Abayisirayiri ne balaba Abamisiri ku lubalama lw’ennyanja nga bafudde. ");
INSERT INTO lug_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Abayisirayiri ne balaba obuyinza obunene ennyo Mukama bwe yalaga ng’akola ku Bamisiri: abantu ne batya Mukama, ne bakkiriza Mukama n’omuweereza we Musa. ");
INSERT INTO lug_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Awo Musa n’abaana ba Isirayiri ne bayimbira Mukama oluyimba luno nga bagamba nti, “Nnaayimbiranga Mukama, kubanga awangudde n’ekitiibwa kingi. Asudde mu nnyanja embalaasi n’omwebagazi waayo. ");
INSERT INTO lug_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Mukama ge maanyi gange era lwe luyimba lwange, era afuuse obulokozi bwange. Ye Katonda wange, nange nnaamutenderezanga, ye Katonda wa kitange, nange nnaamugulumizanga. ");
INSERT INTO lug_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Mukama mulwanyi; Mukama, ly’erinnya lye. ");
INSERT INTO lug_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Amagaali ga Falaawo n’eggye lye abisudde mu nnyanja; n’abaduumizi b’amaggye ge abalondemu basaanyeewo mu Nnyanja Emyufu. ");
INSERT INTO lug_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Obuziba bubasaanikidde; basse okutuuka ku ntobo ng’ejjinja. ");
INSERT INTO lug_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Omukono gwo ogwa ddyo, Ayi Mukama, gwalina amaanyi n’ekitiibwa; omukono gwo ogwa ddyo, Ayi Mukama, gwasesebbula omulabe. ");
INSERT INTO lug_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Mu bukulu obw’ekitiibwa kyo, wamegga abalabe bo, wabalaga obusungu bwo, ne bubasiriiza ng’ebisasiro. ");
INSERT INTO lug_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Omukka bwe gwava mu nnyindo zo, amazzi ne geetuuma; amazzi g’ebuziba ne geekwata ng’ekisenge wakati mu nnyanja. ");
INSERT INTO lug_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Omulabe n’ayogera nti, ‘Ka mbagobe, mbakwate. Nnaagabana omunyago; mbeemalireko eggoga. Nnaasowolayo ekitala kyange, ndyoke mbazikirize.’ ");
INSERT INTO lug_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Naye wakunsa embuyaga zo, ennyanja n’ebasaanikira. Bakka ng’ekyuma, ne basaanawo mu mazzi amangi ag’amaanyi. ");
INSERT INTO lug_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ani akufaanana, Ayi Mukama, mu bakatonda bonna? Ani akufaanana, ggwe, Omutukuvu Oweekitiibwa, atiibwa era atenderezebwa, akola ebyamagero? ");
INSERT INTO lug_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“Wagolola omukono gwo ogwa ddyo, ensi n’ebamira. ");
INSERT INTO lug_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Mu kwagala kwo okutaggwaawo, abantu be wanunula olibakulembera. Mu maanyi go, olibatuusa mu kifo kyo ekitukuvu. ");
INSERT INTO lug_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Amawanga galikiwulira ne gakankana, ababeera mu Bufirisuuti balijjula ennaku. ");
INSERT INTO lug_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Abakungu b’omu Edomu balitangaalirira nga batidde; abakulembeze ab’amaanyi aba Mowaabu balikankana; abatuuze b’omu Kanani baliggwaamu endasi. ");
INSERT INTO lug_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Okwesisiwala n’entiisa biribajjira. Olw’omukono gwo ogw’amaanyi tebalinyega, balisirika ng’ejjinja okutuusa abantu bo lwe baliyitawo, Ayi Mukama, okutuusa abantu bo, be wanunula, lwe baliyitawo. ");
INSERT INTO lug_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Olibayingiza n’obassa ku lusozi lwo lwe weerondera, kye kifo, Ayi Mukama kye weekolera mw’onoobeeranga, ekifo kyo Ekitukuvu, kye weekolera, Ayi Mukama, n’emikono gyo. ");
INSERT INTO lug_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Mukama anaafuganga emirembe n’emirembe.” ");
INSERT INTO lug_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Embalaasi za Falaawo, n’amagaali ge, ne basajja be abeebagadde embalaasi bwe baayingira mu nnyanja, Mukama n’akomyawo amazzi ag’ennyanja ne gabasaanikira; naye nga bo abaana ba Isirayiri batambulira ku ttaka kkalu wakati mu nnyanja. ");
INSERT INTO lug_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Awo Miryamu, nnabbi omukazi era mwannyina wa Alooni, n’akwata ekitaasa; n’abakazi abalala ne bamugoberera nga balina ebitaasa era nga bwe bazina. ");
INSERT INTO lug_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miryamu n’abayimbira bw’ati nti, “Muyimbire Mukama, kubanga awangudde n’ekitiibwa kingi. Asudde mu nnyanja embalaasi n’agyebagadde.” ");
INSERT INTO lug_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Awo Musa n’akulembera Isirayiri, n’abaggya ku Nnyanja Emyufu, ne bayingirira eddungu ly’e Ssuuli. Ne batambulira ennaku ssatu mu ddungu nga tebalabye ku mazzi. ");
INSERT INTO lug_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Bwe baatuuka e Mala, ne batasobola kunywa ku mazzi gaawo, kubanga gaali gakaawa: era eyo y’ensonga eyatuumisa ekifo ekyo Mala. ");
INSERT INTO lug_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Abantu ne beemulugunyiza Musa, ne bamubuuza nti, “Tunywe ki?” ");
INSERT INTO lug_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa ne yeegayirira Mukama; Mukama n’amulaga ekitundu ky’omuti. Bwe yakisuula mu mazzi, amazzi ne gaba malungi okunywa. Mu kifo kino Mukama we yabaweera ekiragiro kino n’etteeka, era n’abagezesa ");
INSERT INTO lug_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ng’agamba nti, “Singa muwuliriza eddoboozi lya Mukama Katonda wammwe n’obwegendereza, ne mukola ebyo by’alaba nga bituufu, ne mussaayo omwoyo ku biragiro bye, era ne mugondera amateeka ge, sigenda kubaleetako ndwadde n’emu, ng’ezo ze naleetera Abamisiri, kubanga nze Mukama, nze mbawonya endwadde zammwe.” ");
INSERT INTO lug_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Awo ne batuuka mu Erimu, awaali ensulo ekkumi n’ebbiri, n’enkindu ensanvu; ne bakuba awo eweema zaabwe okumpi n’amazzi. ");
INSERT INTO lug_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Awo abaana ba Isirayiri, nga kibiina kinene, ne basitula okuva mu Erimu; ne batuuka mu ddungu lya Sini, eriri wakati wa Erimu ne Sinaayi, nga baakamala emyezi ebiri n’ennaku kkumi na ttaano kasookedde bava mu nsi y’e Misiri. ");
INSERT INTO lug_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Nga bali mu ddungu eryo, ekibiina kyonna eky’abaana ba Isirayiri ne kyemulugunyiza Musa ne Alooni. ");
INSERT INTO lug_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Abaana ba Isirayiri ne babagamba nti, “Singa twasigala mu nsi y’e Misiri, Mukama n’atuttira eyo n’omukono gwe! Kubanga eyo twalyanga sefuliya z’ennyama, n’emmere nnyingi nga bwe twayagalanga, ne tukkuta; naye kaakano mutuleese mu ddungu lino, ekibiina kino kyonna kife enjala.” ");
INSERT INTO lug_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Awo Mukama n’agamba Musa nti, “Nzija kubatonnyeseza emmere ng’eva mu ggulu. Abantu banaakuŋŋaanyanga buli lunaku ekitundu eky’olunaku olwo; ndyoke mbagezese ndabe obanga banaakwatanga amateeka gange, oba tebaagakwatenga. ");
INSERT INTO lug_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ku lunaku olw’omukaaga bwe banaabanga bakuŋŋaanya emmere ey’olunaku olwo, bakuŋŋaanyanga eyenkanaankana n’ey’ennaku bbiri.” ");
INSERT INTO lug_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Awo Musa ne Alooni ne bagamba abaana ba Isirayiri bonna nti, “Obudde nga buwungeera, we munaategeerera nga Mukama ye yabaggya mu nsi y’e Misiri: ");
INSERT INTO lug_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ate enkya lwe munaalaba ekitiibwa kya Mukama, kubanga awulidde nga mumwemulugunyiza. Kubanga naffe ffe b’ani mmwe okutwemulugunyiza?” ");
INSERT INTO lug_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa n’ayongera okubagamba nti, “Mujja kwongera okutegeera Mukama, olweggulo nga buwungeera bw’anaabawa ennyama ne mulya, ate enkya n’abawa emmere ebamala: kubanga Mukama awulidde nga mumwemulugunyiza. Naffe ffe b’ani? Temwemulugunyiza ffe, wabula Mukama.” ");
INSERT INTO lug_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Awo Musa n’agamba Alooni nti, “Tegeeza ekibiina kyonna eky’abaana ba Isirayiri nti, ‘Musembere awali Mukama, kubanga awulidde okwemulungunya kwammwe!’ ” ");
INSERT INTO lug_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Awo olwatuuka, Alooni bwe yali ng’akyategeeza ekibiina kyonna eky’abaana ba Isirayiri, ne batunula mu ddungu; era, laba, ekitiibwa kya Mukama ne kirabikira mu kire. ");
INSERT INTO lug_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Mukama n’ayogera ne Musa, ng’agamba nti, ");
INSERT INTO lug_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Mpulidde okwemulugunya kw’abaana ba Isirayiri. Bagambe nti, ‘Obudde nga buwungeera munaalya ennyama, n’enkya munakkusibwa emmere. Bwe mutyo munaategeera nga nze Mukama Katonda wammwe.’ ” ");
INSERT INTO lug_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Obudde nga buwungeera enkwale ne zijja ne zijjula olusiisira; ne mu makya ne wabaawo omusulo ku ttaka mu lusiisira. ");
INSERT INTO lug_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Omusulo nga gwamuse ng’obudde bukaze, laba, ku ttaka ne kulabikako obuntu obutono obwekulungirivu obufaanana ng’omusulo ogukutte olw’obunnyogovu obungi. ");
INSERT INTO lug_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Abaana ba Isirayiri bwe baabulaba ne beebuzaganya nti, “Kiki kino?” Kubanga baali tebakimanyi. Musa n’abategeeza nti, “Eno ye mmere Mukama gy’abawadde okulya. ");
INSERT INTO lug_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Mukama alagidde bw’ati nti, ‘Buli muntu akuŋŋaanye gy’anaamalawo. Buli muntu ali mu weema zammwe mumukuŋŋaanyize kilo bbiri.’ ” ");
INSERT INTO lug_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Abaana ba Isirayiri ne bakola nga bwe baalagirwa; abamu ne bakuŋŋaanya nnyingi, n’abalala ntono. ");
INSERT INTO lug_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Bwe baagipimiranga mu kabakuli aka oma, ze lita ebbiri, oyo eyali akuŋŋaanyizza ennyingi teyasukkirizanga, n’oyo ow’entono nga teyeeseera. Buli muntu yakuŋŋaanyanga ng’okwetaaga kwe bwe kwabanga. ");
INSERT INTO lug_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa n’abagamba nti, “Tewabaawo omuntu n’omu agifissaako okutuusa enkeera.” ");
INSERT INTO lug_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Kyokka abamu Musa tebaamufaako; ne beeterekerako okutuusa enkeera; n’ezaala envunyu, era n’ewunya. Musa n’abasunguwalira. ");
INSERT INTO lug_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Buli nkya ne bakuŋŋaanyanga buli omu gye yayinzanga okulya nga anaagimalawo; naye akasana bwe kaayakanga nga kakazizza, n’esaanuuka. ");
INSERT INTO lug_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Awo ku lunaku olw’omukaaga ne bakuŋŋaanya emmere ya mirundi ebiri, ze kilo nnya buli muntu; abakulembeze bonna mu kibiina ne bajja ne bategeeza Musa. ");
INSERT INTO lug_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","N’abagamba nti, “Mukama yalagidde bw’ati nti, ‘Enkya lunaaba lunaku lwa kuwummula, ye Ssabbiiti ya Mukama Entukuvu. Leero mwokye emmere yammwe gye mwetaaga okwokya, era mufumbe gye mwagala okufumba; eneeba esigaddewo mugyeterekere okutuusa enkya.’ ” ");
INSERT INTO lug_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Bwe batyo ne bagyeterekera okutuusa enkeera, nga Musa bwe yabalagira; n’etewunya wadde okuzaala envunyu. ");
INSERT INTO lug_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa n’abagamba nti, “Eyo mugirye leero, kubanga leero ye Ssabbiiti ya Mukama, ku ttaka temujja kusangako mmere. ");
INSERT INTO lug_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mu nnaku omukaaga mujjanga kugikuŋŋaanya, naye ku lunaku olw’omusanvu, olwa Ssabbiiti, emmere teebeerengawo.” ");
INSERT INTO lug_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Naye era abamu ku bantu baafuluma ku lunaku olw’omusanvu bagikuŋŋaanye, naye tebaasangayo kantu. ");
INSERT INTO lug_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Awo Mukama n’agamba Musa nti, “Mulituusa ddi nga mukyajeemera ebiragiro byange? ");
INSERT INTO lug_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mutegeere nga Mukama abawadde Ssabbiiti; ku lunaku olw’omukaaga kyava abawa emmere ya nnaku bbiri. Buli muntu abeerenga mu maka ge nga tafulumye n’akatono ku lunaku olw’omusanvu.” ");
INSERT INTO lug_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Abantu bwe batyo ne bawummula ku lunaku olw’omusanvu. ");
INSERT INTO lug_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ab’omu nnyumba ya Isirayiri, emmere eyo ne bagiyitanga maanu. Yali efaanana ng’akasigo ka koliyanda, nga njeru; ng’ewoomerera ng’obusukuuti obufumbiddwa n’omubisi gw’enjuki. ");
INSERT INTO lug_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa n’agamba nti, “Mukama alagidde bw’ati nti, ‘Muddire akabakuli aka kilo bbiri mukajjuze maanu mugiterekere ab’emirembe egigenda okujja; balyoke balabe ku mmere gye nabaliisanga mu ddungu, bwe nabaggya mu nsi y’e Misiri.’ ” ");
INSERT INTO lug_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa n’agamba Alooni nti, “Ddira akabakuli osseemu maanu ejjuza oma, ze lita bbiri, obungi, ogisse awali Mukama, eterekerwe ab’emirembe egigenda okujja.” ");
INSERT INTO lug_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Bw’atyo Alooni n’ateeka maanu awali Endagaano, ekuumirwe awo, nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Abaana ba Isirayiri ne balya maanu okumala emyaka amakumi ana, okutuusa lwe baatuuka mu nsi omuli abantu. Baalya maanu okutuusa lwe baatuuka ku nsalo ya Kanani. ");
INSERT INTO lug_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Oma emu yenkana kimu kya kkumi ekya efa. ");
INSERT INTO lug_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Awo ekibiina kyonna eky’abaana ba Isirayiri ne kisitula okuva mu ddungu lya Sini, ne batambula ng’ekiragiro kya Mukama bwe kyali. Ne bakuba eweema zaabwe mu Lefidimu, naye nga tewaliiwo mazzi bantu ge banaanywa. ");
INSERT INTO lug_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Abantu ne bayombesa Musa nga bagamba nti, “Tuwe amazzi tunywe.” Musa n’abaddamu nti, “Lwaki munnyombesa? Lwaki mugezesa Mukama?” ");
INSERT INTO lug_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Naye abantu ennyonta y’amazzi n’ebaluma, ne beemulugunyiza Musa. Ne bagamba nti, “Lwaki watuggya mu Misiri, ennyonta okututtira wano, ffe n’abaana baffe n’ebisibo byaffe?” ");
INSERT INTO lug_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Musa n’akaabira Mukama nti, “Abantu bano mbakole ntya? Baabano baagala kunkuba mayinja.” ");
INSERT INTO lug_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mukama n’addamu Musa nti, “Abantu abo bakulembere, otwale ne ku bakulembeze ba Isirayiri; n’omuggo gwo gwe wakubisa ku mugga genda nagwo ng’ogukutte mu mukono gwo, mutambule. ");
INSERT INTO lug_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nange nzija kukwesooka mu maaso nyimirire ku lwazi e Kolebu, onookuba olwazi ne muvaamu amazzi abantu banywe.” Musa n’akola bw’atyo nga n’abakulembeze ba Isirayiri balaba. ");
INSERT INTO lug_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ekifo ekyo n’akituuma erinnya Masa ne Meriba, olw’okuyomba kw’abaana ba Isirayiri, n’olw’okugezesa Mukama nga bagamba nti, “Mukama waali mu ffe oba taliiwo?” ");
INSERT INTO lug_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Awo Abamaleki ne bajja balwane ne Isirayiri mu Lefidimu. ");
INSERT INTO lug_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa n’agamba Yoswa nti, “Tuyunguliremu abasajja bagende balwanyise Abamaleki. Enkya nzija kuyimirira ku ntikko y’olusozi nga nkutte omuggo gwa Katonda mu mukono gwange.” ");
INSERT INTO lug_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yoswa n’akola nga Musa bwe yamulagira, n’alwana n’Abamaleki. Musa ne Alooni ne Kuli ne bambuka ku ntikko y’olusozi. ");
INSERT INTO lug_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Musa bwe yawanikanga emikono gye, Abayisirayiri nga bagoba, naye bwe yagissanga, nga Abamaleki bagoba. ");
INSERT INTO lug_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Emikono gya Musa ne gitandika okumufuuyirira. Alooni ne Kuli ne bamuleetera ejjinja, n’atuula okwo; ne bawanirira emikono gye, omu ng’ali ku ludda olumu, ne munne ku ludda olulala, emikono gye olwo ne ginywerera waggulu okutuusa enjuba lwe yagwa. ");
INSERT INTO lug_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yoswa n’awangula Abamaleki ng’akozesa obwogi bw’ekitala. ");
INSERT INTO lug_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Awo Mukama n’agamba Musa nti, “Kino kiwandiike mu kitabo kiryoke kijjukirwenga ennaku zonna, era Yoswa asaana akimanye, kubanga Abamaleki ŋŋenda kubasangulirawo ddala ku nsi.” ");
INSERT INTO lug_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa n’azimbawo ekyoto n’akituuma erinnya Mukama ye Bendera Yange. ");
INSERT INTO lug_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","N’agamba nti, “Kubanga Abamaleki baalwanyisa entebe ya Mukama ey’obwakabaka, Mukama alayidde okubalwanyisa emirembe gyonna.” ");
INSERT INTO lug_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yesero, kabona w’e Midiyaani, era kitaawe wa mukyala wa Musa, n’awulira byonna Katonda bye yakolera Musa n’abantu be, Abayisirayiri; era nga Mukama yaggya Isirayiri mu Misiri. ");
INSERT INTO lug_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ye yalabiriranga Zipola, mukyala wa Musa; kubanga Musa yali amuzzizza ewaabwe ng’amumulekedde, ");
INSERT INTO lug_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ne batabani be babiri. Mutabani we omu yamutuuma Gerusomu, kubanga Musa yagamba nti, “Mbadde mugwira mu nsi etali yange;” ");
INSERT INTO lug_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","n’erinnya ly’omulala lyali Eryeza, kubanga yagamba nti, “Katonda wa kitange ye yali omubeezi wange, era n’amponya ekitala kya Falaawo.” ");
INSERT INTO lug_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yesero, mukoddomi wa Musa, n’ajja ne batabani ba Musa ne mukyala we eri Musa mu ddungu, we yali asiisidde okuliraana olusozi lwa Katonda. ");
INSERT INTO lug_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yesero yali amutumidde nti, “Nze Yesero mukoddomi wo, nzija okukulabako. Ndi ne mukyala wo ne batabani be bombi.” ");
INSERT INTO lug_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Awo Musa n’afuluma n’agenda okwaniriza mukoddomi we; n’akutamako ng’amulamusa, n’amugwa mu kifuba. Ne balamusaganya, n’oluvannyuma ne bayingira mu weema. ");
INSERT INTO lug_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa n’anyumiza mukoddomi we ebyo byonna Mukama bye yakola Falaawo n’Abamisiri ng’abalanga Isirayiri; n’ebizibu ebyabatuukako mu lugendo lwabe, ne Mukama nga bwe yabibawonya. ");
INSERT INTO lug_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yesero n’asanyuka nnyo okuwulira ebirungi ebyo byonna Mukama bye yakolera Isirayiri, ng’abanunula ku Bamisiri. ");
INSERT INTO lug_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yesero n’agamba nti, “Mukama atenderezebwe eyabanunula mu mikono gy’Abamisiri ne mu mukono gwa Falaawo, n’aggya abantu be mu mikono gy’Abamisiri. ");
INSERT INTO lug_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Kaakano ntegedde nga Mukama mukulu wa kitiibwa okukira bakatonda bonna, kubanga yanunula abantu be mu mikono gyabo abaali babeeragirako.” ");
INSERT INTO lug_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Awo Yesero, mukoddomi wa Musa, n’awaayo eri Katonda ekiweebwayo ekyokye ne ssaddaaka endala; Alooni n’abakulembeze ba Isirayiri bonna ne balya ne mukoddomi wa Musa emmere mu maaso ga Katonda. ");
INSERT INTO lug_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Awo bwe bwakya enkya, Musa n’atuula ku ntebe ye okulamula abantu. Abantu ne bamwetooloola okuva enkya okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mukoddomi we bwe yalaba Musa bye yali akolera abantu, n’amugamba nti, “Kiki kino ky’okola? Lwaki olamula bw’omu, abantu bano bonna ne bayimirira okukwetooloola okuva ku nkya okutuusa akawungeezi?” ");
INSERT INTO lug_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa n’addamu mukoddomi we nti, “Kubanga abantu bajja gye ndi bategeere Katonda by’ayagala. ");
INSERT INTO lug_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Buli lwe babeera n’obutakkiriziganya, bajja gye ndi, ne mbasalirawo, era ne mbategeeza amateeka ga Katonda n’ebiragiro bye.” ");
INSERT INTO lug_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mukoddomi wa Musa n’amugamba nti, “Ky’okola si kirungi. ");
INSERT INTO lug_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ggwe, n’abantu bano bonna abajja gy’oli, mujja kukoowa nnyo. Kubanga omulimu guno munene nnyo; tosobola kugukola bw’omu. ");
INSERT INTO lug_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Nkusaba ompulirize nkusalire ku magezi, ne Katonda ng’ali naawe. Osaana obeere omubaka w’abantu ewa Katonda, era omutuusengako ensonga zaabwe. ");
INSERT INTO lug_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Bayigirize amateeka n’ebiragiro, era obalage nga bwe basaana okweyisanga, awamu n’emirimu gye basaanidde okukola. ");
INSERT INTO lug_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Londayo abasajja abalina ebisaanyizo, ng’obaggya mu bantu bonna, abasajja abatya Katonda, ab’amazima era abatalya nguzi; obawe obukulembeze, ng’abamu bavunaanyizibwa abantu enkumi, n’abalala abantu ebikumi, n’abamu ebibiina eby’ataano n’abalala eby’ekkumi kkumi. ");
INSERT INTO lug_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Bawe obuyinza okulamulanga abantu ebbanga lyonna, naye ng’emisango emizibu bagikuleetera, emisango emyangu bo bagisalenga. Ekyo kinaawewulanga ku buzito bw’omugugu gwo, kubanga banaabanga bagukukwatirako. ");
INSERT INTO lug_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Singa okola bw’otyo, nga ne Katonda bw’akulagidde, ojja kusobola okugumira emirimu egyo, era n’abantu bano bonna balyoke baddeyo ewaabwe nga basanyuse.” ");
INSERT INTO lug_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa bw’atyo n’awuliriza amagezi gonna mukoddomi we ge yamuwa, n’akolera ku ebyo byonna bye yamubuulirira. ");
INSERT INTO lug_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa n’alonda mu Isirayiri yonna abasajja abasobola, n’abafuula abakulembeze b’abantu; nga bavunaanyizibwa enkumi, n’abalala ebikumi, n’abamu amakumi ataano ataano, n’abalala kkumi kkumi. ");
INSERT INTO lug_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ne balamula abantu ebbanga lyonna. Emisango emizibu nga bagireetera Musa, naye emyangu nga bagisala. ");
INSERT INTO lug_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Awo Musa n’asiibula mukoddomi we, mukoddomi we n’akwata ekkubo ne yeddirayo mu nsi y’ewaabwe. ");
INSERT INTO lug_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Mu mwezi ogwokusatu abaana ba Isirayiri nga bavudde mu Misiri, ne batuuka mu Ddungu lya Sinaayi. ");
INSERT INTO lug_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Kubanga baali basitudde okuva mu Lefidimu ne bayingira Eddungu lya Sinaayi. Abayisirayiri ne basimba eweema zaabwe mu ddungu omwo mu maaso g’olusozi Sinaayi. ");
INSERT INTO lug_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Awo Musa n’ayambuka eri Katonda; Mukama n’amuyita ng’asinziira ku lusozi ng’agamba nti, “Bino by’onoogamba ennyumba ya Yakobo, by’onootegeeza abaana ba Isirayiri nti, ");
INSERT INTO lug_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Mwalaba bye nakola Abamisiri, mmwe ne mbasitulira ku biwaawaatiro by’empungu n’embeereetera gye ndi. ");
INSERT INTO lug_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Kale, singa mugondera eddoboozi lyange awatali kwerekeramu, ne mukuuma endagaano yange, mulibeera eggwanga lyange ery’enjawulo egganzi mu mawanga gonna, kubanga ensi yonna yange. ");
INSERT INTO lug_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Munaabeeranga obwakabaka bwange obwa bakabona, era eggwanga ettukuvu.’ Ebyo bye bigambo by’ojja okutegeeza abaana ba Isirayiri.” ");
INSERT INTO lug_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Awo Musa n’akomawo, n’ayita abakulembeze b’abantu n’abategeeza ebigambo ebyo byonna Mukama bye yamulagira. ");
INSERT INTO lug_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Abantu bonna ne baddiramu wamu nti, “Ebyo byonna Mukama by’agambye, tujja kubikola.” Musa n’ategeeza Mukama ng’abantu bwe baayogera. ");
INSERT INTO lug_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Mukama n’agamba Musa nti, “Nzija kujja gy’oli mu kire ekikutte, abantu bawulire nga njogera naawe, bakukkirizenga era bakwesigenga ennaku zonna.” Musa n’ategeeza Mukama abantu bye baayogera. ");
INSERT INTO lug_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Mukama n’agamba Musa nti, “Genda eri abantu, obatukuze leero n’enkya. Bagambe booze engoye zaabwe, ");
INSERT INTO lug_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ku lunaku olwokusatu babeere beetegefu, kubanga ku lunaku olwo Mukama alikka ku lusozi Sinaayi ng’Abayisirayiri bonna balaba. ");
INSERT INTO lug_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Abayisirayiri bakugire n’olukomera okwetooloola olusozi, obagambe nti, ‘Mwekuume muleme okwambuka ku lusozi oba okulukwatako we lutandikira. Anaalukwatako ajja kuttibwa. ");
INSERT INTO lug_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Tajja kukwatibwako, wabula ajja kukubirwa ddala amayinja oba kufumitibwa. Omuntu tajja kulama, n’ebisolo tewaabeewo kirama.’ Akagombe bwe kanaamala okuvugira akabanga, olwo abantu ne balyoka bajja awali olusozi.” ");
INSERT INTO lug_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Awo Musa n’ava ku lusozi n’aserengeta eri abantu, n’abatukuza ne bayoza engoye zaabwe. ");
INSERT INTO lug_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","N’abagamba nti, “Mwetegekere olunaku olwokusatu, ne bakyala bammwe temubasemberera.” ");
INSERT INTO lug_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Awo ku lunaku olwokusatu ku nkya ne waba okubwatuka n’okumyansa, n’ekire ekikutte ku lusozi, n’eddoboozi ly’akagombe ery’omwanguka ennyo; abantu bonna abaali mu lusiisira n’okukankana ne bakankana. ");
INSERT INTO lug_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa n’aggya abantu mu lusiisira n’abaleeta basisinkane Katonda; ne bayimirira wansi w’olusozi. ");
INSERT INTO lug_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Olusozi Sinaayi ne lubikkibwa omukka; kubanga Mukama yalukkako mu muliro. Omukka ne gunyooka nga gwambuka ng’oguva mu kyoto, n’olusozi lwonna ne lukankana nnyo. ");
INSERT INTO lug_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Eddoboozi ly’akagombe bwe lyeyongera okuvuga n’omwanguka ogw’amaanyi, Musa n’ayogera, ne Katonda n’amwanukula n’eddoboozi ery’okubwatuka. ");
INSERT INTO lug_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Awo Mukama n’akka ku ntikko y’Olusozi Sinaayi. Mukama n’ayita Musa agende ku ntikko y’olusozi; Musa n’alinnya. ");
INSERT INTO lug_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Mukama n’agamba Musa nti, “Serengeta eri abantu obalabule baleme kuwaguza okujja okutunula ku Mukama, abantu bangi baleme kuzikirira. ");
INSERT INTO lug_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ne bakabona, abasemberera Mukama, nabo basaana beetukuze, kubanga Mukama ayinza okubasaanyaawo.” ");
INSERT INTO lug_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa n’addamu Mukama nti, “Abantu tebasobola kwambuka ku Lusozi Sinaayi, kubanga ggwe wennyini watulagira nti, ‘Muteekeewo akakomera okwetooloola olusozi, lusigale lwokka nga lutukuvu.’ ” ");
INSERT INTO lug_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Mukama n’alagira Musa nti, “Serengeta oleete Alooni; naye bakabona n’abantu tobaganya kuwaguza kujja kwambuka eri Mukama, kubanga ayinza okubasaanyaawo.” ");
INSERT INTO lug_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Bw’atyo Musa n’aserengeta mu bantu n’abategeeza. ");
INSERT INTO lug_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Awo Katonda n’ayogera ebigambo bino, n’agamba nti: ");
INSERT INTO lug_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Nze Mukama Katonda wo, eyakuggya mu Misiri, mu nsi gye mwafuulibwa abaddu. ");
INSERT INTO lug_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Tobeeranga na bakatonda balala wabula Nze nzekka. ");
INSERT INTO lug_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Teweekoleranga kintu kyonna ekyole ekifaanana n’ekintu kyonna ekiri waggulu mu ggulu, oba wansi ku nsi, oba ekiri mu mazzi agali wansi w’ensi. ");
INSERT INTO lug_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Tobivuunamiranga so tobisinzanga. Kubanga, nze Mukama Katonda wo ndi Katonda wa buggya; mbonereza abaana olw’ebibi bya bakitaabwe n’ebya bajjajjaabwe okutuusa ku mulembe ogwokusatu n’ogwokuna ogw’abo abankyawa. ");
INSERT INTO lug_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Naye abo enkumi n’enkumi abanjagala era abakwata amateeka gange, mbalaga okwagala kwange okutaggwaawo. ");
INSERT INTO lug_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Tokozesanga linnya lya Mukama Katonda wo ng’olayira ebitaliimu nsa; kubanga Mukama talirema kumusalira musango ne gumusinga omuntu oyo alayirira obwereere erinnya lye. ");
INSERT INTO lug_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Olunaku lwa Ssabbiiti lujjukirenga era olutukuzenga. ");
INSERT INTO lug_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Kolanga emirimu gyo, ofaabiine mu nnaku omukaaga, ");
INSERT INTO lug_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","naye olunaku olw’omusanvu ye Ssabbiiti ya Mukama Katonda wo. Ku lunaku olwo tokolerangako mulimu gwonna; ggwe, wadde mutabani wo, wadde muwala wo, wadde omuweereza wo omusajja, oba omuweereza wo omukazi, wadde ensolo zo, wadde omugenyi ali omumwo. ");
INSERT INTO lug_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kubanga mu nnaku omukaaga Mukama Katonda mwe yakolera eggulu n’ensi, n’ennyanja, ne byonna ebibirimu, n’awummulira ku lunaku olw’omusanvu. Mukama kyeyava awa omukisa olunaku olwa Ssabbiiti n’alutukuza. ");
INSERT INTO lug_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Kitaawo ne nnyoko obassangamu ekitiibwa, olyoke owangaale mu nsi Mukama Katonda wo gy’akuwa. ");
INSERT INTO lug_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Tottanga. ");
INSERT INTO lug_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Toyendanga. ");
INSERT INTO lug_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Tobbanga. ");
INSERT INTO lug_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Towaayirizanga muntu munno. ");
INSERT INTO lug_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Teweegombanga nnyumba ya muliraanwa wo. Teweegombanga mukazi wa muliraanwa wo, newaakubadde omuweereza we omusajja, newaakubadde omuweereza we omukazi, wadde ente ye, oba endogoyi ye, oba ekintu kyonna ekya muntu munno.” ");
INSERT INTO lug_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Awo abantu bwe baalaba okumyansa kw’eraddu, ne bawulira n’okubwatuka kw’eggulu awamu n’eddoboozi ly’akagombe, ne balaba n’olusozi nga lunyooka ne bakankana nga batidde nnyo. Ne bayimirira walako, ");
INSERT INTO lug_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ne bagamba Musa nti, “Ggwe yogera naffe, tujja kubiwuliriza. Naye Katonda aleme kwogera naffe tuleme okufa.” ");
INSERT INTO lug_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa n’agamba abantu nti, “Temutya, kubanga Katonda azze kubagezesa, mumutyenga bulijjo, mulyoke muleme okwonoona.” ");
INSERT INTO lug_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Abantu ne basigala nga bayimiridde walako, naye Musa n’asembera mu kizikiza ekikwafu Katonda mwe yali. ");
INSERT INTO lug_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Mukama n’agamba Musa nti, “Bw’oti bw’oba otegeeza abaana ba Isirayiri nti, ‘Mmwe bennyini mwerabiddeko nga njogera nammwe nga nsinziira mu ggulu. ");
INSERT INTO lug_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Temwekoleranga bakatonda balala wendi; temwekoleranga bakatonda ba ffeeza oba bakatonda ba zaabu. ");
INSERT INTO lug_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Munkolere ekyoto eky’ettaka, muweereyo okwo ssaddaaka zammwe ezookebwa, n’essaddaaka olw’emirembe, ey’endiga zo n’ente zo. Mu buli kifo mwe nnaaleeteranga erinnya lyange okuweebwa ekitiibwa, nnajjanga ne mbaweera omwo omukisa. ");
INSERT INTO lug_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Bwe munzimbiranga ekyoto eky’amayinja, temukizimbisanga mayinja mayooyoote, kubanga ekyuma bwe kirigakoonako kirigafuula agatasaanira kyoto kyange. ");
INSERT INTO lug_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ekyoto kyange temukizimbangako madaala, muleme okukiweebuula nga mulinnya amadaala.’ ” ");
INSERT INTO lug_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Amateeka gano gabategeeze nti: ");
INSERT INTO lug_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Bw’ogulanga omuddu Omwebbulaniya, akuweererezanga emyaka mukaaga. Mu mwaka ogw’omusanvu omuddizanga eddembe lye n’agenda, era talisasuliranga. ");
INSERT INTO lug_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Bw’aba nga yajja yekka, era agendanga yekka; naye bw’aba nga yajja ne mukazi we, era agendanga naye. ");
INSERT INTO lug_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Mukama we bw’abanga amuwadde omukazi, n’amuzaalira abaana aboobulenzi n’aboobuwala; omukazi n’abaana babanga ba mukama wa muddu oyo; omusajja yekka ye yaddizibwanga eddembe lye. ");
INSERT INTO lug_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Naye omuddu bw’agambanga nti, ‘Nze mukama wange mmwagala, ne mukazi wange n’abaana bange bonna mbagala, era seetaaga ddembe,’ ");
INSERT INTO lug_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","mukama we amutwalanga eri abalamuzi, amuleetanga ku luggi oba ku mwango gw’oluggi, n’amuwummula okutu n’olukato. Olwo anaamuweerezanga okutuusa okufa. ");
INSERT INTO lug_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Omusajja bw’anaatundanga omwana we owoobuwala ng’omuddu, omuwala oyo taddizibwenga ddembe ng’omuddu omusajja. ");
INSERT INTO lug_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Bw’ataasanyusenga mukama we eyamugula, anaayinzanga okununulibwa. Kyokka mukama we taabenga na buyinza kumutunda mu bannamawanga, kubanga mukama we yanaabanga amukuusizakuusiza okumala okumuwasa ate n’amwegobako. ");
INSERT INTO lug_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Singa amugabira mutabani we, olwo anaabanga ng’omu ku bawala be. ");
INSERT INTO lug_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Singa amuwasizaako omukazi omulala, mukama we taamuggyengako mmere ye oba engoye ze, wadde ebimukwatako byonna eby’obufumbo. ");
INSERT INTO lug_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ebintu ebyo ebisatu singa abimumma, omuwala omuddu anaayinzanga okuleka mukama we n’amuvaako awatali kusasulirwa. ");
INSERT INTO lug_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Anaakubanga omuntu n’amutta, naye ateekwa buteekwa okuttibwa. ");
INSERT INTO lug_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kyokka singa akikola nga tagenderedde, naye Katonda n’akikkiriza okubaawo, anaddukanga ne yeekweka mu kifo kye ndibateekerateekera. ");
INSERT INTO lug_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Naye singa omuntu anaasalanga olukwe n’alumba munne n’amutta mu bugenderevu, bw’anaabanga ku kyoto kyange, mumusikangako ne mumutwala ne mumutta. ");
INSERT INTO lug_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Akubanga kitaawe oba nnyina, ateekwa buteekwa okuttibwa. ");
INSERT INTO lug_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Oyo awambanga omuntu n’amutunda oba n’akwatibwa naye nga tannamutunda attibwanga buttibwa. ");
INSERT INTO lug_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Anaakolimiranga kitaawe oba nnyina ateekwa kuttibwa. ");
INSERT INTO lug_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Abantu singa bayomba ne balwana, omu n’akuba munne ejjinja oba ekikonde, n’atafa wabula n’abeera ku kitanda; ");
INSERT INTO lug_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","singa ava ku kitanda, n’atandika n’okutambulako ebweru n’omuggo gwe, oli eyamukuba taavunaanibwenga; wabula anaasasuliranga ebiseera by’oyo gwe yakuba, era n’amujjanjaba okutuusa ng’awonedde ddala. ");
INSERT INTO lug_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Omuntu bw’anaakubanga omuddu we omusajja oba omuddu we omukazi n’omuggo, omuddu oyo emiggo ne gimutta, omusajja oyo anaabonerezebwanga; ");
INSERT INTO lug_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","naye omuddu oyo bw’anaalamanga okumala olunaku oba ennaku ebbiri, mukama we taabonerezebwenga, kubanga ye nannyini ye. ");
INSERT INTO lug_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Singa abantu babadde balwana, ne bakubiramu omukazi ali olubuto, olubuto ne luvaamu, kyokka n’atabaako mutawaana mulala gwonna, oyo amukubye anaatanzibwanga omutango bba w’omukazi gw’anaasalanga, era nga n’abalamuzi bagukkirizza. ");
INSERT INTO lug_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Naye singa omukazi oyo abaako omutawaana ogw’amaanyi, ekibonerezo kineenkanaakananga n’ekyo ky’amukoze. Bw’anattanga anattibwanga, ");
INSERT INTO lug_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","bw’anaaggyangamu eriiso lya munne, n’erirye banaaligyangamu, oba omuntu bw’anaaggyangamu erinnyo lya munne, n’erirye banaalikuulangamu, bw’anaamutemangako omukono, n’ogugwe banaagutemangako, bw’anaamutemangako ekigere, n’ekikye banaakitemangako, ");
INSERT INTO lug_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","bw’anaamwokyanga, naye anaayokebwanga, bw’anaamussangako ekiwundu, naye anaassibwangako ekiwundu, bw’anaamunuubulanga, naye anaanuubulwanga. ");
INSERT INTO lug_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Omuntu bw’akubanga omuddu we omusajja oba omuddu we omukazi, n’amuggyamu eriiso, anaamuddizanga eddembe lye n’amuleka n’agenda, nga kwe kumuliyira olw’eriiso eryo. ");
INSERT INTO lug_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Singa akuba omuddu we omusajja oba omuddu we omukazi, n’amukuulamu erinnyo, anaamuddizanga eddembe lye, nga kwe kumuliyira olw’erinnyo eryo. ");
INSERT INTO lug_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Singa ente ya seddume etomera omusajja oba omukazi n’emutta, seddume eyo eteekwa okukubwanga amayinja n’efa, n’ennyama yaayo teriibwanga. Kyokka nannyini yo taabengako musango. ");
INSERT INTO lug_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Naye seddume eyo singa emanyiddwa nga bulijjo ntomezi, era nga ne nannyini yo yalabulwako dda, kyokka n’atagisibira mu lugo lwayo, n’etta omusajja oba omukazi, eneekubwanga amayinja n’efa, ne nannyini yo anattibwanga. ");
INSERT INTO lug_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Naye singa asalirwa engassi, aneenunulanga n’awona okufa ng’asasuddeyo kyonna ekinaabanga kimusaliddwa. ");
INSERT INTO lug_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Seddume bw’eneetomeranga mutabani w’omuntu oba muwala we, etteeka lye limu eryo lye linaakozesebwanga. ");
INSERT INTO lug_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Seddume bw’etomeranga omuddu omusajja oba omuddu omukazi, nannyini yo ateekwa okusasula mukama w’omuddu oyo, ebitundu bya ffeeza amakumi asatu, ne seddume ekubwenga amayinja efe. ");
INSERT INTO lug_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Omuntu bw’anaabikkulanga ekinnya n’akireka nga kyasamye, oba bw’anaasimanga ekinnya n’atakisaanikirako, seddume n’ekigwamu oba endogoyi, ");
INSERT INTO lug_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","nannyini kinnya anaasasuliranga okufiirwa okwo; anaasasulanga nannyini nsolo efudde, era n’okugitwala anaagitwalanga. ");
INSERT INTO lug_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Seddume y’omuntu bw’eneerumyanga seddume y’omulala, n’emala egitta; banaatundanga seddume ennamu, ensimbi ne bazigabana; ne seddume enfu nayo banaagigabananga. ");
INSERT INTO lug_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Oba singa seddume eyo ng’emanyiddwa nga ntomezitomezi, naye nannyini yo nga tagiggalira mu lugo lwayo, ateekwa asasule seddume olwa seddume, yo enfu eneebanga yiye. ");
INSERT INTO lug_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Omuntu bw’anabbanga ente ya munne, oba endiga, n’agitta oba n’agitunda; anazzangawo ente ttaano olw’emu gy’abbye, n’endiga nnya olw’endiga emu. ");
INSERT INTO lug_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Omubbi bw’anaakwatibwanga ng’amenya ennyumba, n’akubibwa emiggo n’afa; amukubye taabengako musango olw’okuyiwa omusaayi gw’omubbi oyo; ");
INSERT INTO lug_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","naye singa ebyo bigwawo ng’enjuba emaze okuvaayo, anaabangako omusango olw’okuyiwa omusaayi ogwo. Omubbi anaateekwanga okuliwa; naye bw’abanga talina kantu, anaatundibwanga alyoke asasulire bye yabba. ");
INSERT INTO lug_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Omubbi singa akwatibwa lubona nga n’ensolo gy’abbye agirina nnamu, oba nte, oba ndogoyi oba ndiga, anazzangawo bbiri bbiri. ");
INSERT INTO lug_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Omuntu bw’anaabanga alunda ebisolo bye mu ddundiro lye oba mu nnimiro ye ey’emizabbibu, ensolo ze n’azireka ne zigenda ziriira mu nnimiro y’omuntu omulala; anaasasulanga ku bibala ebisinga obulungi n’ezabbibu ebiva omumwe. ");
INSERT INTO lug_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Omuliro bwe gunaalandanga ne guyita mu bisaka ne gukwata ennimiro y’omuntu, ne gwokya ebinywa by’eŋŋaano, oba eŋŋaano ekyakula, oba ne guzikiriza ennimiro ye yonna; eyakumye omuliro ogwo anaasasuliranga byonna ebyonoonese. ");
INSERT INTO lug_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Omuntu bw’anaateresanga munne ensimbi oba ebintu bye ebirala, ne bamala babibbira mu nnyumba ye; omubbi bw’anaakwatibwanga anaaliwanga emirundi ebiri. ");
INSERT INTO lug_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Naye omubbi bw’ataakwatibwenga, nannyini nnyumba ateekwa agende eri abalamuzi, basalewo obanga ebintu bya munne ye yabitutte. ");
INSERT INTO lug_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Mu buli misango gyonna egy’okubeera n’ebintu mu ngeri emenya amateeka, ng’okubeera n’ente, oba endogoyi, oba endiga, oba ekyambalo, oba ekintu ekirala kyonna ekinaabanga kibuze, omuntu n’amala akyogerako nti, ‘Kino kyange,’ omuntu akirina n’oyo akiyita ekikye banaatwalanga ensonga zaabwe eri abalamuzi. Oyo abalamuzi gwe banaasaliranga nti gumusinze, anaddizangawo munne emirundi ebiri. ");
INSERT INTO lug_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Omuntu bw’anaateresanga munne endogoyi, oba ente, oba endiga, oba ensolo endala yonna; n’emala efa, oba n’erumizibwa, oba n’etwalibwa nga tekitegeerekese agitutte, ");
INSERT INTO lug_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ensonga zaabwe zinaagonjoolwanga nga eyatereka alayidde mu maaso ga Mukama nti ensolo eyo si ye yagibba. Nannyini nsolo ateekwanga okukkiriza ekirayiro ekyo, era taasasulwenga kintu kyonna. ");
INSERT INTO lug_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Naye bw’eneemubbibwangako, anaagiriwanga. ");
INSERT INTO lug_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Bw’eneebanga erumbiddwa ensolo enkambwe n’etaagulwataagulwa, anaaleetanga ebitundutundu byayo ebisigaddewo ng’obujulizi; taaliwenga nsolo etaaguddwataaguddwa. ");
INSERT INTO lug_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Omuntu bw’aneeyazikanga ensolo ku muliraanwa we, n’erumizibwa, oba n’emufaako nga nnyini yo taliiwo, anaateekwanga okugisasulira. ");
INSERT INTO lug_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Naye nannyini yo bw’anaabangawo, taaliyirwenga. Ensolo ng’ebadde epangisibbwa bupangisibwa, omuwendo ogugipangisizza gunaamalanga mu kugisasulira. ");
INSERT INTO lug_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Omusajja bw’anaasendasendanga omuwala omuto akyali embeerera, ne yeebaka naye, atwalengayo ebintu ebyobuko, amuwase. ");
INSERT INTO lug_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Naye singa kitaawe w’omuwala agaanira ddala okumumuwa, era asasulangayo omuwendo gw’ensimbi ogwenkanankana n’eby’obuko ebiweebwayo ku mbeerera. ");
INSERT INTO lug_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Omukazi omulogo omuttanga bussi. ");
INSERT INTO lug_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Omuntu akola eby’ensonyi n’ensolo ateekwanga kuttibwa. ");
INSERT INTO lug_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Omuntu atwalanga ssaddaaka eri katonda omulala, atali nze Mukama, azikirizibwenga. ");
INSERT INTO lug_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Bannamawanga temubayisanga bubi, so temubanyigirizanga, kubanga nammwe mwali bannaggwanga mu nsi y’e Misiri. ");
INSERT INTO lug_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Nnamwandu ne mulekwa temubajooganga. ");
INSERT INTO lug_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Bwe munaabajooganga ne bankaabira, nnaabawulirizanga. ");
INSERT INTO lug_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Obusungu bwange ne bubuubuuka, mmwe ne mbatta n’ekitala. Bakyala bammwe ne bafuuka bannamwandu n’abaana bammwe bamulekwa. ");
INSERT INTO lug_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Bw’owolanga ensimbi omu ku bantu bange abali mu mmwe, ng’ali mu kwetaaga, teweeyisanga ng’abawozi b’ensimbi abalala; tomusasuzanga magoba. ");
INSERT INTO lug_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Bw’otwalanga ekyambalo ky’omuntu ng’akakalu, kimuddize ng’enjuba egenda okugwa; ");
INSERT INTO lug_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","kubanga ekyambalo kye ekyo kye ky’okwebikka kye kyokka ky’alina. Kale bw’otokimuddiza olwo asule mu ki? Bw’anankaabiriranga nzijanga kumuwuliriza, kubanga ndi wa kisa. ");
INSERT INTO lug_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Tovumanga Katonda, wadde okwogera obubi ku bafuzi bammwe. ");
INSERT INTO lug_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Tolwangawo kuwaayo ku bibala ebibereberye nga byengedde. “Mutabani wo omubereberye onoomumpanga. ");
INSERT INTO lug_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ente zo n’endiga zo nazo onookolanga bw’otyo. Onoozirekeranga bannyina baazo okumala ennaku musanvu; onoozimpanga ku lunaku olw’omunaana. ");
INSERT INTO lug_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Mujjanga kuba bantu bange batukuvu. Noolwekyo temuulyenga nnyama ya nsolo etaaguddwataaguddwa ebisolo eby’omu nsiko. Munaagirekeranga mbwa. ");
INSERT INTO lug_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Tosaasaanyanga ŋŋambo. Teweegattanga na muntu mubi, ng’owa obujulirwa obw’obulimba bulyoke bumuyambe. ");
INSERT INTO lug_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Tokolagananga na kibiina ky’omanyi nga bye kiriko bikyamu. Bw’obanga owa obujulirwa mu musango, tokkirizanga kusikibwa kibiina ne kikuweesa obujulizi obw’obulimba nga weekubira ku ludda lwe kiriko; ");
INSERT INTO lug_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","era towanga bujulirwa bukyamu oyambe omuntu yenna olwokubanga mwavu. ");
INSERT INTO lug_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Bw’osanganga ente y’omulabe wo, oba endogoyi ye, ng’ebuzze ogimuddizangayo eka. ");
INSERT INTO lug_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Bw’olabanga endogoyi y’omuntu atakwagala, ng’omugugu gugisudde wansi, togirekanga, naye omuyambangako okugiyimusa. ");
INSERT INTO lug_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Tolemanga kusalirawo muntu nsonga ze mu bwenkanya, olwokubanga mwavu. ");
INSERT INTO lug_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Teweeyingizanga mu nsonga za bulimba, era tottanga muntu atalina kibi oba atazzizza musango, kubanga aliko omusango sigenda kumwejjeereza. ");
INSERT INTO lug_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Tolyanga nguzi, kubanga enguzi eziba omuntu amaaso n’ekyamya n’abatuukirivu. ");
INSERT INTO lug_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Temuwalagganyanga munnaggwanga, kubanga mmwe bennyini mumanyi nga bwe kiri okuba bannaggwanga, kubanga mwali bannaggwanga mu nsi y’e Misiri. ");
INSERT INTO lug_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Mu myaka omukaaga osigirangamu emmere yo mu nnimiro zo era n’ogikungula; ");
INSERT INTO lug_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","naye mu mwaka ogw’omusanvu ettaka olirekanga ne liwummula, abaavu mu mmwe basobolenga okulya ku mmere okuva mu bimererezi; eneefikkangawo ebisolo by’omu nsiko binaagiryanga. Era bw’otyo bw’onookolanga n’ennimiro zo ez’emizabbibu n’ez’emizeeyituuni. ");
INSERT INTO lug_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Mu nnaku omukaaga mw’okoleranga emirimu gyo, naye ku lunaku olw’omusanvu tokolanga, ente yo n’endogoyi yo ziryoke zisobole okuwummulako; ne mutabani w’omuweereza wo, ne munnaggwanga ali mu maka go bawummuleko baddemu endasi. ");
INSERT INTO lug_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Weegenderezanga n’okolanga byonna bye nkulagidde. Bakatonda abalala toboogerangako, era amannya gaabwe tegayitanga mu kamwa ko. ");
INSERT INTO lug_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Ononkoleranga embaga emirundi esatu buli mwaka. ");
INSERT INTO lug_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Onookolanga Embaga ey’Emigaati Egitali Mizimbulukuse. Onoolyanga omugaati ogutaliimu kizimbulukusa okumala ennaku musanvu, nga bwe nakulagira. Kino okikolanga mu kiseera ekyategekebwa, mu mwezi gwa Abibu, kubanga mu mwezi ogwo mwe waviira mu nsi y’e Misiri. “Tewabangawo ajja gye ndi engalo ensa. ");
INSERT INTO lug_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Onookolanga Embaga ey’Amakungula ey’ebibala ebibereberye eby’ebirime bye wasiga mu nnimiro yo. “Onookolanga Embaga ey’Amayingiza buli nkomerero ya mwaka, bw’onookuŋŋaanyanga ebibala by’omu nnimiro, n’obiyingiza. ");
INSERT INTO lug_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Abasajja bonna banajjanga awali Mukama Katonda emirundi egyo esatu buli mwaka. ");
INSERT INTO lug_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Temuwangayo kintu kyonna gye ndi ekirimu ekizimbulukusa nga mundeetedde ssaddaaka erimu omusaayi; n’amasavu aga ssaddaaka yange tegasulangawo kutuusa nkeera. ");
INSERT INTO lug_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Ebibala ebisinga obulungi mu ebyo ebisoose okuva mu ttaka lyo obitwalanga mu nnyumba ya Mukama Katonda wo. Tofumbanga akaana k’embuzi mu mata ga nnyina waako. ");
INSERT INTO lug_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Laba, ntuma malayika akukulembere, akutuuse bulungi mu kifo kye nteeseteese. ");
INSERT INTO lug_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Omuwulirizanga, era ogonderanga by’agamba. Tomujeemeranga; bw’olijeema tagenda kukusonyiwa, kubanga aliba akola mu Linnya lyange. ");
INSERT INTO lug_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Naye bw’onoowulirizanga eddoboozi lye, n’okola nga bwe ŋŋamba, kale nnaakyawanga abakukyawa, n’abalabe bo banaabanga balabe bange. ");
INSERT INTO lug_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Malayika wange alikwesooka mu maaso akukulemberenga akutuuse mu nsi y’Abamoli, ne mu y’Abakiiti, ne mu y’Abaperezi, ne mu y’Abakanani, ne mu y’Abakiivi, ne mu y’Abayebusi, nange ndibazikiririza ddala. ");
INSERT INTO lug_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Tovuunamiranga bakatonda baabwe, so tobaweerezanga, era tokwatanga mpisa zaabwe, wabula obabetetaranga ddala, n’omenyaamenya n’empagi zaabwe. ");
INSERT INTO lug_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Oweerezanga Mukama Katonda wo yekka, emmere yo n’amazzi go ndyoke mbiwe omukisa. Ndiggyawo endwadde mu mmwe; ");
INSERT INTO lug_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","tewaabengawo mugumba wadde avaamu olubuto. Ennaku z’obulamu bwo zonna nnaazituukirizanga. ");
INSERT INTO lug_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Nnaasindikanga ekikangabwa mu mawanga agaagala okukwolekera, ne ntabulatabula abo bonna abanaakwegezangamu, era abalabe bo nnaabafuumuulanga emisinde. ");
INSERT INTO lug_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ndisindika ennumba ne zikukulembera, ne zigoba Abakiivi, n’Abakanani, n’Abakiiti ne bakuviira mu kkubo lyo. ");
INSERT INTO lug_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Naye mu nsi omwo siribagobamu mu mwaka gumu, ebikande bireme kusukkirira, n’ensolo ez’omu nsiko ne zaala ne zibayitirira obungi. ");
INSERT INTO lug_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nzijanga kubagobamu mpola mpola, okutuusa nga mwaze ne mulyoka mulya ensi eyo. ");
INSERT INTO lug_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Ndisala ensalo zammwe okuva ku Nnyanja Emyufu okutuuka ku Nnyanja y’Abafirisuuti, n’okuva ku ddungu okutuuka ku Mugga Fulaati. Abantu b’omu nsi omwo ndibabawa, ne mubagobamu. ");
INSERT INTO lug_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Temukolanga nabo ndagaano, wadde ne bakatonda baabwe. ");
INSERT INTO lug_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Temubakkirizanga kubeera mu nsi yammwe, tebalwa kubanyoomesa biragiro byange; kubanga singa muweereza bakatonda baabwe muliba mugudde mu mutego.” ");
INSERT INTO lug_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Awo Mukama n’alagira Musa nti, “Mwambuke eno gye ndi, ggwe ne Alooni, ne Nadabu, ne Abiku, n’abakulembeze ba Isirayiri nsanvu. Musinze nga mwesuddeko akabanga, ");
INSERT INTO lug_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Musa yekka y’anaansemberera; abalala tebasembera. Era abantu tebasaana kujja naye.” ");
INSERT INTO lug_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa n’ajja n’ategeeza abantu ebigambo byonna Mukama bye yamugamba awamu n’amateeka ge gonna. Abantu bonna ne baddiramu wamu ne bagamba nti, “Ebigambo ebyo byonna Mukama by’agambye tunaabikola.” ");
INSERT INTO lug_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Bw’atyo Musa n’awandiika ebigambo byonna Mukama bye yayogera. Awo Musa n’akeera mu makya n’azimba ekyoto awo wansi w’olusozi; n’asimbako n’empagi kkumi na bbiri ng’ebika bya Isirayiri ekkumi n’ebibiri bwe byali. ");
INSERT INTO lug_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","N’atuma abasajja abavubuka Abayisirayiri, ne bawaayo ebiweebwayo ebyokebwa eri Mukama, ne ssaddaaka ey’emirembe ey’ente. ");
INSERT INTO lug_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa n’addira ekitundu ky’omusaayi n’akissa mu mabeseni, n’ekitundu ekirala n’akimansira ku kyoto. ");
INSERT INTO lug_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","N’asitula Ekitabo ky’Endagaano, n’akisomera abantu nga bonna bawulira. Ne bagamba nti, “Ebyo byonna Mukama by’agambye tujja kubikola; era tunaamugonderanga.” ");
INSERT INTO lug_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Awo Musa n’addira omusaayi n’agumansira ku bantu, n’agamba nti, “Guno gwe musaayi gw’endagaano Mukama Katonda gye yabalagira okukwata.” ");
INSERT INTO lug_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Awo Musa ne Alooni, ne Nadabu, ne Abiku, n’abakulembeze ba Isirayiri ensanvu, ne bambuka; ");
INSERT INTO lug_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ne balaba Katonda wa Isirayiri. Wansi w’ebigere bye nga waliwo ng’omwaliiro ogw’amayinja ga safiro, agalabika obulungi ng’eggulu eritaliiko bire. ");
INSERT INTO lug_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Naye Katonda teyakola kabi konna ku bakulembeze ba Isirayiri abo; Katonda baamulaba, ne balya era ne banywa. ");
INSERT INTO lug_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Mukama n’agamba Musa nti, “Yambuka eno gye ndi ku lusozi, obeere wano olinde; nzija kukuwa ebipande eby’amayinja okuli amateeka g’empandiise ogayigirize abantu.” ");
INSERT INTO lug_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Awo Musa n’asituka n’omuweereza we Yoswa; Musa n’ayambuka ku lusozi lwa Katonda. ");
INSERT INTO lug_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","N’agamba abakulembeze b’abantu nti, “Mugira mutulindako wano nga naffe bwe tukomawo. Mbalekedde Alooni ne Kuuli; buli anaaba n’ensonga yonna agende gye bali, bajja kugimumalira.” ");
INSERT INTO lug_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Awo Musa n’alinnyalinnya olusozi, ekire ne kirubikka. ");
INSERT INTO lug_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ekitiibwa kya Mukama ne kibeera ku Lusozi Sinaayi. Ekire ne kibikka olusozi okumala ennaku mukaaga; ku lunaku olw’omusanvu Mukama n’ayita Musa ng’asinziira wakati mu kire. ");
INSERT INTO lug_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Abaana ba Isirayiri bwe baatunuulira ekitiibwa kya Mukama, ne kibalabikira ng’omuliro ogw’amaanyi ennyo ku ntikko y’olusozi. ");
INSERT INTO lug_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa n’ayingira mu kire ng’agenda alinnyalinnya olusozi. Ku lusozi yamalako ennaku amakumi ana. ");
INSERT INTO lug_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mukama n’ayogera ne Musa nti, ");
INSERT INTO lug_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Gamba abaana ba Isirayiri bandeetere ekiweebwayo. Buli muntu aleete ekiweebwayo ng’okuteesa kw’omutima gwe bwe kuli, okimunzijireko. ");
INSERT INTO lug_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Bino bye biweebwayo bye banaakukwasa: “zaabu, ne ffeeza, n’ekikomo; ");
INSERT INTO lug_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","n’olugoye olwa bbululu, n’olwa kakobe, n’olumyufu, n’olugoye olwa linena erangiddwa mu wuzi ennungi; n’obwoya bw’embuzi, ");
INSERT INTO lug_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","n’amaliba g’endiga ennume amakunye amannyike mu langi emyufu, n’ekika ky’eddiba ekirala ekiwangaazi; n’embaawo z’omuti gwa akasiya; ");
INSERT INTO lug_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","n’amafuta g’ettaala; n’ebyakaloosa eby’okukozesa mu mafuta ag’okwawula, ne mu bubaane obw’okunyookeza; ");
INSERT INTO lug_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","n’amayinja aga onuku n’amayinja amalala ag’omuwendo, ag’okutona ku kkanzu ey’obwakabona eyitibwa efodi, era ne ku kyomukifuba. ");
INSERT INTO lug_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Bankolere ekifo ekitukuvu ndyoke mbeerenga wakati mu bo. ");
INSERT INTO lug_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Mukole Eweema ya Mukama eyo entukuvu n’ebigibeeramu byonna nga bwe nnaabalagirira. ");
INSERT INTO lug_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Bakole essanduuko mu muti gwa akasiya, obuwanvu mita emu ne sentimita kkumi na ssatu, obugazi sentimita nkaaga mu musanvu n’obugulumivu sentimita nkaaga mu musanvu. ");
INSERT INTO lug_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ogiteekeko zaabu omuka ennyo munda ne kungulu, era ogyetoolooze omuge ogwa zaabu. ");
INSERT INTO lug_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ogiweeseze empeta nnya eza zaabu ozisibe ku magulu gaayo ana, ng’empeta ebbiri ziri ku ludda olumu, n’endala ebbiri ku ludda lwayo olulala. ");
INSERT INTO lug_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Obajje emisituliro mu muti ogwa akasiya, ogibikkeko zaabu. ");
INSERT INTO lug_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ogisonseke mu mpeta eziri ku ssanduuko, okusituzanga essanduuko. ");
INSERT INTO lug_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Emisituliro egyo ginaalekebwanga mu mpeta ze ssanduuko, si zaakuggyangamu. ");
INSERT INTO lug_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Mu ssanduuko omwo mw’onossa Amateeka ge nnaakuwa. ");
INSERT INTO lug_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Okolereko ekisaanikira, ye ntebe ey’okusaasira, nga kya zaabu omuka ennyo; obuwanvu bwakyo sentimita nkaaga mu musanvu, n’obugazi sentimita nkaaga mu musanvu. ");
INSERT INTO lug_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Era okolereko ebifaananyi bya bakerubi babiri mu zaabu empeese, ku njuyi ebbiri ez’ekisaanikira. ");
INSERT INTO lug_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Oteeke ekifaananyi kya kerubi omu ku ludda lumu olw’ekisaanikira, n’ekifaananyi kya kerubi omulala ku ludda olwokubiri, nga ebifaananyi bya bakerubi byombi byekutte wamu n’ekisaanikira. ");
INSERT INTO lug_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ebiwaawaatiro bya bakerubi bibe bibikkule nga bisonze waggulu, era nga bisiikiriza ekisaanikira. Bakerubi batunulagane nga boolekedde ekisaanikira. ");
INSERT INTO lug_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ekisaanikira onookissa kungulu ku Ssanduuko; ekiwandiiko eky’Endagaano ey’Amateeka kye nnaakuwa, okisse munda mu Ssanduuko. ");
INSERT INTO lug_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Awo waggulu w’ekisaanikira, mu bakerubi bombi abali ku Ssanduuko ey’Endagaano, we nzija okukusisinkana ndyoke nkuwe ebiragiro byange byonna bye nkoledde abaana ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Okole emmeeza mu muti gwa akasiya, obuwanvu bwayo sentimita kyenda, obugazi sentimita amakumi ana mu ttaano, n’obugulumivu sentimita nkaaga mu musanvu. ");
INSERT INTO lug_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ogibikkeko zaabu omuka ennyo; era ogyetoolooze ne zaabu omuge gwonna. ");
INSERT INTO lug_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Era ogyetoolooze olukugiro oluweza sentimita musanvu ne desimoolo ttaano obugazi, n’omuge ogwa zaabu okwetooloola olukugiro olwo. ");
INSERT INTO lug_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ogikolere empeta nnya eza zaabu, ozisibe mu nsonda ennya awali amagulu ana. ");
INSERT INTO lug_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Empeta zijja kubeera waggulu okumpi n’omuge, emisituliro gy’emmeeza mwe ginaayisibwa. ");
INSERT INTO lug_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Okole emisituliro mu muti gwa akasiya, ogibikkeko zaabu, egyo emmeeza kw’eneesitulirwanga. ");
INSERT INTO lug_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Era ogikolere essowaani eza zaabu, n’ebijiiko ebya zaabu, n’ensuwa eza zaabu, n’ebibya ebya zaabu eby’okufukanga ebiweebwayo. ");
INSERT INTO lug_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Era ku mmeeza eno onossaako Emigaati egy’Okulaga, egy’okubeeranga mu maaso gange bulijjo. ");
INSERT INTO lug_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Okole ekikondo ky’ettaala nga kya zaabu omuka. Ekikondo kyonna na bino ebikiriko: entobo yaakyo n’enduli, ebikopo ebifaanana ng’ebimuli, amatabi n’emitunsi n’ebimuli byako, byonna byakuweesebwa mu kyuma kya zaabu kimu bulambalamba. ");
INSERT INTO lug_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kunaabako amatabi mukaaga omutuula emisubbaawa: amatabi asatu nga gali ku ludda lumu, n’amalala asatu nga gali ku ludda olulala. ");
INSERT INTO lug_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ku matabi gonna omukaaga agava ku kikondo ky’ettaala, kubeeko ku buli ttabi, ebikopo bisatu ebikole ng’ebimuli by’alumondi; mu buli kikopo nga mulimu omutunsi n’ekimuli. ");
INSERT INTO lug_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ku kikondo ky’ettaala kyennnyini kubeeko ebikopo bina ebifaanana ebimuli by’alumondi nga mulimu emitunsi n’ebimuli. ");
INSERT INTO lug_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Omutunsi gumu gujja kuba wansi w’amatabi abiri agava ku kikondo, n’omutunsi ogwokubiri gubeere wansi w’amatabi abiri amalala, n’omutunsi ogwokusatu gubeere wansi w’amatabi abiri amalala; amatabi gonna omukaaga ne gaggwaayo. ");
INSERT INTO lug_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Emitunsi n’amatabi biweesebwe mu kyuma kya zaabu omwereere, nga kiri bulambalamba n’ekikondo ky’ettaala. ");
INSERT INTO lug_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Era ekikondo kikolere ettaala musanvu; ettaala zino nga zaakira mu maaso gaakyo. ");
INSERT INTO lug_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Makansi ezikomola entambi, n’essowaani ez’okussaako ebisirinza, byonna bikolebwe mu zaabu mwereere. ");
INSERT INTO lug_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ojja kwetaaga zaabu omwereere aweza obuzito bwa kilo asatu mu nnya, okukola ekikondo ky’ettaala ne byonna ebigenderako. ");
INSERT INTO lug_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Weegendereze, byonna obikole ng’ogoberera ekifaananyi kye nkulaze wano ku lusozi.” ");
INSERT INTO lug_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Onookola Weema n’emitanda gy’entimbe kkumi, nga girukiddwa mu wuzi eza linena omulebevu alangiddwa n’ewuzi eza bbululu, ne kakobe, ne myufu. Omutunzi ow’amagezi ennyo akoleremu bakerubi. ");
INSERT INTO lug_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Emitanda gy’entimbe gyonna gijja kwenkanankana: obuwanvu mita kkumi na bbiri n’ekitundu, n’obugazi mita emu ne desimoolo munaana. ");
INSERT INTO lug_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Emitanda gy’entimbe etaano onoogigatta wamu, ng’ogisengese gumu ku gunnaagwo, era ne ginnaagyo ettaano ogikole bw’otyo. ");
INSERT INTO lug_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Otunge eŋŋango eza bbululu ku mukugiro gw’omutanda gw’entimbe ogukomererayo mu kitundu ekimu eky’entimbe ettaano, era okole bw’otyo ne ku ŋŋango ekomererayo mu kitundu ekyokubiri. ");
INSERT INTO lug_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Otunge eŋŋango amakumi ataano ku mutanda gw’entimbe ogumu, n’eŋŋango endala amakumi ataano ku mukugiro gw’omutanda gw’entimbe mu kitundu ekikomererayo, eŋŋango ezo nga zoolekaganye. ");
INSERT INTO lug_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Okole ebikwaso amakumi ataano ebya zaabu, okwase wamu emitanda gy’entimbe gyombi n’ebikwaso ebyo, olwo Eweema ya Mukama ebeere wamu nga nnamba. ");
INSERT INTO lug_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Okole entimbe kkumi na lumu nga zilukiddwa mu bwoya bw’embuzi, ozibikke ku Weema. ");
INSERT INTO lug_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Entimbe zonna ekkumi n’olumu zijja kwenkanankana obunene: ng’obuwanvu mita kkumi na ssatu n’ekitundu, n’obugazi mita emu ne desimoolo munaana. ");
INSERT INTO lug_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ogatte entimbe ttaano wamu, n’entimbe omukaaga ozigatte wamu. Olutimbe olw’omukaaga oluwetemu mu maaso g’Eweema. ");
INSERT INTO lug_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ojja kutunga eŋŋango amakumi ataano ku mukugiro gw’omutanda gw’entimbe ogukomererayo mu kitundu ky’entimbe ekimu, ne ku mukugiro gw’olutimbe olukomererayo mu kitundu ekyokubiri. ");
INSERT INTO lug_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Okole ebikwaso eby’ekikomo amakumi ataano, obiyise mu ŋŋango, bikwate ekibikka ku Weema, ebeere wamu nga nnamba. ");
INSERT INTO lug_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ekitundu ky’entimbe ekisigaddewo ku masuuka g’ebibikka ku Weema kijja kuleebeetera emabega wa Weema. ");
INSERT INTO lug_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Entimbe z’ekibikka ku Weema mu mbiriizi zombi ziyise Eweema kitundu kya mita emu mu buwanvu. Ebitundu bino byombi bijja kuleebeetera mu mbiriizi zombi eza Weema nga bigibisse. ");
INSERT INTO lug_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ekibikka ku Weema okikolereko ekibikkako eky’amaliba g’endiga nga gasiigiddwa erangi emyufu, okwo obikkeko amaliba g’ente ey’omu nnyanja. ");
INSERT INTO lug_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Obajje embaawo mu muti gwa akasiya oziyimirize zikole omudaala gw’Eweema kweneetuula. ");
INSERT INTO lug_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Buli lubaawo lube obuwanvu mita nnya n’ekitundu, ate obugazi sentimita nkaaga mu musanvu. ");
INSERT INTO lug_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Buli lubaawo oluteekeko obubaawo obuyiseemu bubiri, nga butunulaganye n’embaawo zonna. Embaawo zonna ez’omudaala gw’Eweema ozikole bw’otyo. ");
INSERT INTO lug_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Okole embaawo amakumi abiri ozisse ku ludda olw’obukiikaddyo obw’Eweema, ");
INSERT INTO lug_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","era okole entobo eza ffeeza amakumi ana, zibeere wansi w’obubaawo obuyiseemu obubiri ku buli lubaawo. ");
INSERT INTO lug_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ku ludda olwa bukiikakkono olw’Eweema okolereyo embaawo amakumi abiri, ");
INSERT INTO lug_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","n’entobo eza ffeeza amakumi ana, bbiri wansi wa buli lubaawo. ");
INSERT INTO lug_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Okole embaawo mukaaga oziteeke ku ludda olw’emabega, lwe lw’ebugwanjuba bwa Weema; ");
INSERT INTO lug_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","era okole embaawo bbiri ez’okussa ku nsonda ku ludda olwo. ");
INSERT INTO lug_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ku nsonda zino ebbiri embaawo zombi ozisibe wamu nabansasaana okuviira ddala wansi okutuuka waggulu, ozinyweze n’empeta. ");
INSERT INTO lug_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Kwe kugamba nti wajja kubeerawo embaawo zonna awamu munaana, n’entobo eza ffeeza kkumi na mukaaga, nga ku buli lubaawo wansi waalwo eriyo bbiri. ");
INSERT INTO lug_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Osale buliti mu muti gwa akasiya: buliti ttaano ez’okukozesa ku mbaawo eziri ku lusebenju lwa Weema olumu, ");
INSERT INTO lug_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ne buliti ttaano ku mbaawo eziri ku lusebenju lwa Weema olulala, ne buliti ttaano okukozesa ku mbaawo eziri ku ludda olw’emabega wa Weema olw’ebugwanjuba. ");
INSERT INTO lug_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Omulabba guyite wakati w’embaawo nga guva ku ludda olumu okutuuka ku ludda olulala. ");
INSERT INTO lug_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Embaawo ozibikkeko zaabu, era okole empeta eza zaabu ozisibise buliti; ne buliti nazo ozibikkeko zaabu. ");
INSERT INTO lug_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Eweema onoogizimba ng’ogoberera ekifaananyi ekyakulagibwa ng’oli ku lusozi. ");
INSERT INTO lug_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Okole eggigi mu wuzi eza bbululu, ne kakobe, ne myufu, ne linena omulebevu alangiddwa; era omukozi omukugu atungiremu bakerubi. ");
INSERT INTO lug_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Oliwanike n’amalobo aga zaabu ku mpagi nnya ezibajjiddwa mu muti gwa akasiya nga zibikkiddwako zaabu, era nga ziyimiriziddwa mu ntobo eza ffeeza. ");
INSERT INTO lug_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Eggigi olinyweze n’ebikwaso; olyoke otereeze Essanduuko ey’Endagaano munda waalyo. Eggigi liryoke lyawule Ekifo Ekitukuvu n’Ekifo Ekitukuvu Ennyo. ");
INSERT INTO lug_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Onosse ekisaanikira, ye ntebe ey’okusaasira ku Ssanduuko ey’Endagaano munda mu Kifo Ekitukuvu Ennyo. ");
INSERT INTO lug_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Oddire emmeeza ogisse ku ludda olwa ddyo mu kisenge ebweru w’eggigi mu Weema, n’ettaala ogisse ku ludda olwa kkono ng’eyolekedde emmeeza. ");
INSERT INTO lug_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Okole olutimbe lw’omu mulyango gw’Eweema mu wuzi eza bbululu, ne kakobe, ne myufu, ne linena omulebevu alangiddwa omulungi; nga byonna bitungiddwa bulungi. ");
INSERT INTO lug_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Olutimbe olukolere empagi ttaano ng’ozibazze mu muti gwa akasiya, ozibikkeko zaabu, n’amalobo gaalwo gabe zaabu; ogiweeseze entobo ttaano ez’ekikomo.” ");
INSERT INTO lug_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Zimba ekyoto mu miti gya akasiya, obugulumivu mita emu ne desimoolo ssatu, n’obuwanvu mita bbiri ne desimoolo ssatu, ate obugazi mita bbiri ne desimoolo ssatu. ");
INSERT INTO lug_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Era ku nsonda zaakyo ennya kolerako amayembe; ng’ekyoto n’amayembe bibajjiddwa bumu mu muti gumu; ekyoto kyonna olyoke okibikkeko ekikomo. ");
INSERT INTO lug_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Kola ebbakuli omunaayoolerwanga evvu lyakyo, n’ebisena evvu, n’ebbensani, n’ewuuma z’ennyama, ne fulampeni; ebyo byonna nga bikolebwa mu kikomo. ");
INSERT INTO lug_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ekyoto kikolere ekitindiro eky’obutimba eky’ebyuma eby’ekikomo; ku nsonda ennya ez’ekitindiro olyoke okolereko empeta nnya ez’ekikomo. ");
INSERT INTO lug_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Leebeeseza ekitindiro ekyo mu kyoto, nga waggulu kinyweredde ku muziziko ne kireebeeta okukoma wakati ng’ekyoto bwe kikka. ");
INSERT INTO lug_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Kola emisituliro gy’ekyoto mu muti gwa akasiya, ogibikkeko ekikomo. ");
INSERT INTO lug_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Emisituliro egyo ogiyingize mu mpeta ennya, gibeere ku njuyi zombi ez’ekyoto nga kibadde kisitulwa okubaako gye kitwalibwa. ");
INSERT INTO lug_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ekyoto kikole n’embaawo, nga wakati kya muwulukwa. Okikole nga bwe kyakulagibwa ku lusozi. ");
INSERT INTO lug_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Eweema ya Mukama gikolere oluggya. Ku ludda olwa ddyo oluggya lubeere mita amakumi ana mu mukaaga obuwanvu, era nga lulina amagigi aga linena omulebevu alangiddwa, ");
INSERT INTO lug_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","n’entobo amakumi abiri n’ebikolo ebikondo mwe bituula eby’ekikomo amakumi abiri; nga ku bikondo kuliko amalobo aga ffeeza n’emikiikiro egya ffeeza. ");
INSERT INTO lug_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ne ku ludda olwakkono oluggya lubeere mita ana mu mukaaga obuwanvu, era ebeeyo amagigi n’ebikondo amakumi abiri, n’entobo zaabyo eby’ekikomo amakumi abiri, nga ku bikondo kuliko amalobo aga ffeeza n’emikiikiro egya ffeeza. ");
INSERT INTO lug_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Ku ludda olw’obugwanjuba oluggya lubeere mita amakumi abiri mu ssatu obugazi, era lubeere n’amagigi n’ebikondo kkumi awamu n’entobo zaabyo kkumi. ");
INSERT INTO lug_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ku ludda olw’ebuvanjuba, enjuba gy’efulumira, nayo oluggya lubeere mita amakumi abiri mu ssatu obugazi. ");
INSERT INTO lug_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ku ludda olumu olw’omulyango kubeereko amagigi mita mukaaga ne desimoolo mwenda obuwanvu, n’ebikondo bisatu n’entobo zaabyo ssatu, ");
INSERT INTO lug_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ne ku ludda olulala nakwo kubeereko amagigi mita mukaaga ne desimoolo mwenda obuwanvu, n’ebikondo bisatu n’entobo zaabyo ssatu. ");
INSERT INTO lug_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Mu mulyango oguyingira mu luggya wanikamu eggigi mita mwenda obuwanvu, nga lya wuzi za bbululu, ne kakobe, ne myufu, ne linena endebevu ennange, nga bikolebwa omutunzi omukugu, era ng’eggigi lirina ebikondo bina n’entobo zaabyo nnya. ");
INSERT INTO lug_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ebikondo byonna mu luggya bibeere n’emikiikiro gya ffeeza, n’amalobo ga ffeeza, n’entobo za kikomo. ");
INSERT INTO lug_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Oluggya lubeere mita amakumi ana mu mukaaga obuwanvu, n’obugazi mita amakumi abiri mu ssatu, n’amagigi aga linena endebevu ennange, mita bbiri ne desimoolo ssatu obugulumivu, n’entobo ez’ekikomo. ");
INSERT INTO lug_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ebintu ebirala byonna ebinaakozesebwa ku mirimu gya Weema egya buli ngeri, ng’otaddeko n’obukondo obukomerera Weema n’obw’omu luggya, byonna bibeera bya kikomo. ");
INSERT INTO lug_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Lagira abaana ba Isirayiri bakuleetere amafuta ag’emizeeyituuni amalungi ennyo ag’okukozesa mu ttaala, eryoke eyakenga obudde bwonna nga tezikira. ");
INSERT INTO lug_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Mu kisenge kya Weema ey’Okukuŋŋaanirangamu, ebweru w’eggigi eribisse Endagaano, awo Alooni ne batabani be we banaabeeranga nga balabirira ettaala eyakirenga awali Mukama okuva olweggulo okutuusa mu makya. Lino libeere tteeka abaana ba Isirayiri lye banaakwatanga emirembe gyonna.” ");
INSERT INTO lug_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Muganda wo Alooni muyiteyo mu baana ba Isirayiri, awamu ne batabani be: Nadabu, ne Abiku, ne Eriyazaali, ne Isamaali, bajje bampeereze nga be bakabona. ");
INSERT INTO lug_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Muganda wo Alooni mutungire ebyambalo ebitukuvu, nga bya kitiibwa era nga birabika bulungi. ");
INSERT INTO lug_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Yogera n’abo bonna abasobola, be nawa ekirabo eky’amagezi mu mirimu egyo, bakolere Alooni ebyambalo mw’anaayawulirwa okubeera kabona wange. ");
INSERT INTO lug_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Bino bye byambalo bye banaakola: eky’omu kifuba, ekkanzu ey’obwakabona okutali mikono ennyimpi eyitibwa ekkanzu ey’obwakabona eyitibwa efodi; ng’ekoma mu ntumbwe; omunagiro; ekkooti erimu obusaze obw’obusimba n’obw’obukiika; ekitambaala; n’olukoba. Bakolere Alooni ne batabani be ebyambalo ebitukuvu balyoke bampeereze nga be bakabona. ");
INSERT INTO lug_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Abakozi baweebwe ewuzi eza zaabu, ne bbululu, ne kakobe, ne myufu, ne linena omulebevu omulange. ");
INSERT INTO lug_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Abakozi abakugu bakole ekkanzu ey’obwakabona ennyimpi etaliiko mikono n’ewuzi eza zaabu, ne bbululu, ne myufu, ne linena omulebevu omulange. ");
INSERT INTO lug_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ebeere n’eby’okubibegabega bibiri nga bitungiddwa w’ekoma, eryoke egattibwe bulungi. ");
INSERT INTO lug_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Omusipi gwayo mu kiwato gukolebwe n’amagezi mangi nga aganaakola ekkanzu ey’obwakabona, era n’ebinaakola bifaanagane, ng’ewuzi za zaabu, ne bbululu, ne kakobe, ne myufu, ne linena omulebevu alangiddwa. ");
INSERT INTO lug_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Oddire amayinja ga onuku abiri, ogalambeko amannya ga batabani ba Isirayiri, ");
INSERT INTO lug_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","amannya mukaaga ku jjinja erimu, n’amannya g’abasigaddewo omukaaga ku jjinja eryokubiri, ng’okuzaalibwa kwabwe bwe kugenda kuddiriragana. ");
INSERT INTO lug_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Olambe amannya ga batabani ba Isirayiri ku mayinja ago abiri ng’omusazi w’amayinja bw’ayola akabonero ku jjinja; ogateeke mu fuleemu ogeetoolooze n’emikugiro egya zaabu. ");
INSERT INTO lug_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Amayinja ago ojja gakwasiza ku by’okubibegabega eby’ekkanzu ey’obwakabona eyitibwa efodi, ng’amayinja ag’ekijjukizo ky’abaana ba Isirayiri. Alooni asitulenga amannya gaabwe awali Mukama ng’ekijjukizo. ");
INSERT INTO lug_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Okole fuleemu eza zaabu, ");
INSERT INTO lug_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","n’enjegere bbiri eza zaabu omuka, ozirange ng’emiguwa; olyoke osibire enjegere ez’oku fuleemu. ");
INSERT INTO lug_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Kola ekyomukifuba eky’okutereezanga ensonga, nga mulimu gwa kikugu ng’ogw’ekkanzu ey’obwakabona eyitibwa efodi, n’ewuzi eza zaabu, ne bbululu, ne kakobe, ne myufu, ne linena omulebevu omulange. ");
INSERT INTO lug_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kijja kwenkanankana, buli ludda sentimita amakumi abiri mu bbiri, okiwetemu wakati. ");
INSERT INTO lug_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Otungireko ennyiriri nnya ez’amayinja ag’omuwendo omungi. Mu lunyiriri olusooka osseemu amayinja saasiyo, ne topazi, ne kaabankulo; ");
INSERT INTO lug_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ne mu lunyiriri olwokubiri osseemu emalada, ne safiro ne dayamandi; ");
INSERT INTO lug_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ne mu lunyiriri olwokusatu osseemu jasinta; ne ageti, ne ametisita, ");
INSERT INTO lug_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ne mu lunyiriri olwokuna osseemu berulo, ne onuku, ne yasipero, ogateeke mu fuleemu ya zaabu. ");
INSERT INTO lug_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Wabeerewo amayinja kkumi n’abiri, n’amannya gaago ng’amannya g’abatabani ba Isirayiri. Gasalibwe bulungi ng’obubonero obuwoolebwa, nga ku buli limu kulambiddwako erinnya lyako okumalirayo ddala amannya g’ebika ekkumi n’ebibiri. ");
INSERT INTO lug_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Ekyomukifuba kikolere enjegere ennange ng’emiguwa gya zaabu omuka. ");
INSERT INTO lug_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Era ekyomukifuba kikolere empeta za zaabu bbiri, oteeke empeta ezo zombi ku mikugiro ebiri egy’ekyomu kifuba. ");
INSERT INTO lug_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Oyise enjegere ebbiri eza zaabu mu mpeta ebbiri eziri ku mikugiro gy’eky’omu kifuba. ");
INSERT INTO lug_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Oddire enjuuyi ebbiri ezisigaddewo ez’enjegere ozikwasize ku fuleemu ebbiri, ozinywereze mu maaso g’eby’oku bibegabega byombi eby’ekkanzu ey’obwakabona eyitibwa efodi. ");
INSERT INTO lug_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Era okole empeta bbiri eza zaabu, ozitunge ku mikugiro gy’eky’omu kifuba ku luuyi olw’omunda oluliraanye ekkanzu ey’obwakabona eyitibwa efodi. ");
INSERT INTO lug_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Era okole empeta bbiri eza zaabu oziteeke mu maaso, mu bitundu ebya wansi eby’eby’okubibegabega byombi eby’ekkanzu ey’obwakabona eyitibwa efodi, wagguluko okumpi n’oluzizi lw’omusipi olw’ekkanzu ey’obwakabona eyitibwa efodi. ");
INSERT INTO lug_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Empeta ez’oku kyomukifuba zisibwe wamu n’empeta z’ekkanzu ey’obwakabona eyitibwa efodi n’akaguwa aka bbululu, kagattibwe n’olukoba, olw’omu kifuba luleme kutaggulukuka ku kkanzu ey’obwakabona eyitibwa efodi. ");
INSERT INTO lug_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Buli kiseera Alooni lw’anaayingiranga mu Kifo Ekitukuvu, anaabanga ayambadde amannya ga batabani ba Isirayiri ku kyomukifuba eky’okumala ensonga, nga kiri ku mutima gwe, kibeerenga ekijjukizo awali Mukama. ");
INSERT INTO lug_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Mu ky’omu kifuba eky’okumala ensonga, onooteekamu Ulimu ne Sumimu, era binaabeeranga ku mutima gwa Alooni buli lw’anaayingiranga awali Mukama. Bw’atyo Alooni anaasitulanga ekkubo omuyitwa okumala ensonga z’abaana ba Isirayiri okumpi n’omutima gwe buli lw’anaagendanga awali Mukama. ");
INSERT INTO lug_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Onookola ekyambalo ekiri ng’ekkanzu ey’obwakabona eyitibwa efodi, nga kyonna kya bbululu. ");
INSERT INTO lug_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Waggulu mu makkati gaakyo munaabaamu ekituli omw’okuyisa omutwe; okwetooloola ekituli ekyo kunaabaako omuge omuyonde obulungi ng’omuleera ku kituli ky’omutwe eky’ekkanzu ey’obwakabona, kireme okuyulika. ");
INSERT INTO lug_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Okwetooloola ebirenge wansi onootungayo amajjolobera mu wuzi eza bbululu, ne kakobe, ne myufu; nga mu makkati ga buli langi eziriraanye otobekamu obude obwa zaabu. ");
INSERT INTO lug_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Ng’otunga amajjolobera n’ozzaako akade, ate n’oddiriza amajjolobera n’ozzaako akade; bw’otyo okwetooloola ebirenge by’ekyambalo ekyo. ");
INSERT INTO lug_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Gunaabanga mulimu gwa Alooni okwambala ekyambalo ekyo ng’agenda okuweereza. Obude obwo bunaawulirwanga ng’ayingira mu Kifo Ekitukuvu awali Mukama, ne bw’anaabanga afuluma, aleme okufa. ");
INSERT INTO lug_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Onookola akapande aka zaabu omuka ennyo, okayoleko, nga bwe bayola akabonero, nti, Mutukuvu wa Mukama. ");
INSERT INTO lug_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Akapande okasibeko akaguwa aka bbululu, okanywereze ku kitambaala ky’oku mutwe ku ludda olw’omu maaso olw’ekitambaala. ");
INSERT INTO lug_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Akapande ako kanaabeeranga mu kyenyi kya Alooni, era Alooni y’anaabangako obuvunaanyizibwa nga wabaddewo ebitatuuse mu biweebwayo ebitukuvu abaana ba Isirayiri bye banaaleetanga nga bamaze okubyawula ng’ebirabo byabwe ebitukuvu; kanaabeeranga ku kyenyi kye bulijjo, Mukama alyoke akkirize ebirabo ebyo. ");
INSERT INTO lug_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Luka ekkooti erimu obusaze obw’obusimba n’obw’obukiika mu wuzi eza linena omulebevu, era okole n’ekitambaala eky’oku mutwe mu linena omulebevu, era okole olukoba ng’olutunzeemu amajjolobera. ");
INSERT INTO lug_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Batabani ba Alooni bakolere amakooti, n’emisipi, n’enkuufiira; nga byonna bya kitiibwa era nga birabika bulungi nnyo. ");
INSERT INTO lug_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Alooni muganda wo mwambaze ebyambalo ebyo, ne batabani be nabo bw’otyo; olyoke obafukeko amafuta ag’omuzeeyituuni, obaawule, obatukuze, bampeerezenga nga be bakabona. ");
INSERT INTO lug_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Bakolere empale ez’omunda eza linena, nga ziva mu kiwato okukoma mu bisambi, zibikke omubiri gwabwe. ");
INSERT INTO lug_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Alooni ne batabani be banaazambalanga nga bajja mu Weema ey’Okukuŋŋaanirangamu oba bwe banaasembereranga Ekyoto okuweereza mu Kifo Ekitukuvu, baleme okwereetako omusango ne bafa. “Alooni ne batabani be ne bazzukulu be abalimuddirira banaakuumanga etteeka lino nga lya nkalakkalira.” ");
INSERT INTO lug_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Bino by’onookola okwawula Alooni ne batabani be okubafuula bakabona balyoke bampeereze. Ojja kulaba ente ya seddume emu ento, n’endiga ennume ento bbiri, zonna nga teziriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Era onookola mu buwunga bw’eŋŋaano ennungi emigaati egitaliimu kizimbulukusa, ne zikkeeke enkole n’amafuta ag’omuzeeyituuni ezitali nzimbulukuse, n’obusukuuti obw’oluwewere obutaliimu kizimbulukusa naye nga busiigiddwako amafuta ag’omuzeeyituuni. ");
INSERT INTO lug_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Obiteeke mu kibbo kimu obireete awamu n’ente n’endiga ebbiri. ");
INSERT INTO lug_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Leeta Alooni ne batabani be ku mulyango gw’Eweema ey’Okukuŋŋaanirangamu, obanaaze n’amazzi. ");
INSERT INTO lug_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ddira ebyambalo, oyambaze Alooni ekkooti, n’ekyambalo ekiri ng’ekkanzu ey’obwakabona eyitibwa efodi, n’ekkanzu ey’obwakabona eyitibwa efodi, n’ekyomukifuba, omusibeko omusipi gw’ekkanzu ey’obwakabona eyitibwa efodi ogwalukibwa n’amagezi amangi; ");
INSERT INTO lug_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","omusibe n’ekitambaala ku mutwe olyoke otereeze bulungi engule entukuvu ku kitambaala eky’oku mutwe. ");
INSERT INTO lug_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ddira amafuta ag’okwawula ogafuke ku mutwe gwe, omwawule. ");
INSERT INTO lug_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Leeta batabani be obambaze amakooti, ");
INSERT INTO lug_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","obasibeko emisipi, obambaze n’enkuufiira; olwo nga bafuuka bakabona emirembe gyonna ng’ekiragiro bwe kigamba. Bw’otyo bw’onooyawula Alooni ne batabani be. ");
INSERT INTO lug_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Onooleeta ente eyo ento mu maaso g’Eweema ey’Okukuŋŋaanirangamu. Alooni ne batabani be banaagikwatako ku mutwe, ");
INSERT INTO lug_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","n’olyoka ogittira awo awali Mukama ku mulyango gw’Eweema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Onoddira omusaayi ogw’ente eyo omutonotono, n’ogusiiga n’olugalo lwo ku mayembe ag’oku kyoto; omusaayi ogunaasigalawo oguyiwe wansi w’ekyoto. ");
INSERT INTO lug_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Onoddira amasavu gonna ag’oku byenda n’ogabikka ku kibumba n’ensigo zombi n’amasavu gaazo, obyokere ku kyoto. ");
INSERT INTO lug_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Naye ennyama y’ente eyo n’eddiba lyayo, n’obusa bwayo, byokere ebweru w’olusiisira. Ekyo ky’ekiweebwayo olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Kwata endiga zombi, Alooni ne batabani be banaakwatanga ku mutwe gw’endiga emu; ");
INSERT INTO lug_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","otte endiga eyo, n’oddira omusaayi gwayo n’ogumansa buli wantu ku kyoto. ");
INSERT INTO lug_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Onoosalaasala endiga eyo mu bifi, onaaze eby’omunda byayo n’amagulu gaayo; obisse wamu n’ebifi n’omutwe, ");
INSERT INTO lug_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","endiga yonna ogyokere ku kyoto. Ekyo ky’ekiweebwayo eri Mukama ekyokye, eky’akawoowo akasanyusa, nga kiweebwayo ku muliro eri Mukama. ");
INSERT INTO lug_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Onoddira endiga endala, Alooni ne batabani be ne bassa emikono ku mutwe gwayo; ");
INSERT INTO lug_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","onoogitta, n’oddira ku musaayi gwayo n’ogusiiga ku kasongezo k’okutu kwa Alooni okwa ddyo, ne ku busongezo bw’amatu ga batabani be aga ddyo, ne ku binkumu by’emikono gyabwe egya ddyo, ne ku bigere byabwe ebisajja ebya ddyo; omusaayi ogunaasigalawo ogumansire ku kyoto okukyetooloola. ");
INSERT INTO lug_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Onoddira ku musaayi oguli ku kyoto, oddire ne ku mafuta ag’okwawula, obimansire ku Alooni ne ku byambalo bye, era ne ku batabani be ne ku byambalo byabwe. Bw’atyo Alooni ne batabani be bajja kutukuzibwa awamu n’ebyambalo byabwe. ");
INSERT INTO lug_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Onoggya ku ndiga eyo amasavu, n’omukira omusava, n’amasavu agabikka eby’omu lubuto ne ku kibumba, n’ensigo zombi awamu n’amasavu agaziriko, n’ekisambi ekya ddyo; kubanga eyo y’endiga ey’okukozesa mu kwawula bakabona. ");
INSERT INTO lug_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Era olabe mu kibbo ekirimu ebitali bizimbulukuse ebiri awali Mukama oggyemu omugaati gumu, ne keeke emu okuli amafuta ag’omuzeeyituuni, n’akasukuuti ak’oluwewere; ");
INSERT INTO lug_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ebyo byonna obikwase Alooni ne batabani be, babiwuubire awali Mukama ng’ekiweebwayo ekiwuubibwa. ");
INSERT INTO lug_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Onoobibaggyako, n’obyokera ku kyoto ng’obyongera ku kiweebwayo ekyokebwa, mulyoke muveemu akawoowo akalungi akasanyusa Mukama; kye kiweebwayo eri Mukama ekyokye mu muliro. ");
INSERT INTO lug_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Era onoddira ekifuba ky’endiga y’okwawulibwa kwa Alooni, okiwuube ng’ekiweebwayo eri Mukama ekiwuubibwa; ogwo gwe gunaaba omugabo gwo. ");
INSERT INTO lug_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Onootukuza ekifuba eky’ekiweebwayo ekiwuubibwa, n’ekisambi eky’ekiweebwayo ekiwuubibwa, n’ekisambi eky’omugabo gwa bakabona era nga nakyo kiwuubibwa ekiva ku ndiga y’okwawulibwa, nga bwe guli omugabo gwa Alooni ne batabani be. ");
INSERT INTO lug_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Gunaabanga mugabo gwa Alooni ne batabani be, nga guva mu baana ba Isirayiri emirembe gyonna; kubanga gwe mugabo gwa bakabona ogunaavanga ku kiweebwayo ky’abaana ba Isirayiri eky’emirembe, nga kye kiweebwayo kyabwe eri Mukama. ");
INSERT INTO lug_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Ebyambalo bya Alooni ebitukuvu, batabani be, be banaabisikiranga, era mwe banaafukirwangako amafuta, era mwe banaayawulirwanga. ");
INSERT INTO lug_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Omwana anaabanga azze mu bigere bya Alooni nga kabona, anaabyambaliranga ennaku musanvu, bw’anajjanga mu Weema ey’Okukuŋŋaanirangamu okuweereza mu Kifo Ekitukuvu. ");
INSERT INTO lug_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Ojja kuddira endiga y’okwawulibwa, ofumbe ennyama yaayo mu kifo ekitukuvu; ");
INSERT INTO lug_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Alooni ne batabani be balye ku nnyama y’endiga eyo, ne ku mugaati oguli mu kibbo, nga bali ku mulyango gwa Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Banaalya ku ebyo ebikozesebbwa ku mukolo ogw’okusonyiyibwa kwabwe lwe batukuzibwa era lwe bayawulirwako. Naye atali kabona tabiryangako, kubanga bitukuvu. ");
INSERT INTO lug_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Era singa ku nnyama y’okwawula ne ku migaati wasigalawo ebiremye okutuusa enkeera, byonna byokebwanga bwokebwa; tewabanga abirya, kubanga bitukuvu. ");
INSERT INTO lug_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Bwe kutyo okwawulibwa kwa Alooni ne batabani be bw’onookukola nga bwe nkulagidde. Omukolo gwonna gujja kumala ennaku musanvu; ");
INSERT INTO lug_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","era buli lunaku ojja kuwaayo seddume y’ente emu ng’ekiweebwayo olw’ekibi, olw’okusonyiyibwa. Waayo ekiweebwayo olw’okulongoosa ekyoto, okifukeko amafuta, okitukuze. ");
INSERT INTO lug_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ojja kumala ennaku musanvu ng’owaayo ekiweebwayo olw’okulongoosa ekyoto, okitukuze; era ekyoto kijja kubeera kitukuvu nnyo, buli ekinaakikomangako nga nakyo kifuuka kitukuvu. ");
INSERT INTO lug_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Bino by’onoowangayo ku kyoto buli lunaku: onoowangayo endiga ento bbiri ez’omwaka ogumu. ");
INSERT INTO lug_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Endiga emu onoogiwangayo mu makya, ne ginnaayo n’ogiwaayo akawungeezi. ");
INSERT INTO lug_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Endiga esooka onoogiwaayo ne lita bbiri ez’obuwunga obulungi, nga butabuddwamu lita ng’emu ey’amafuta ge zeyituuni, n’oteekerako ne lita emu ey’envinnyo nga ky’ekiweebwayo ekyokunywa. ");
INSERT INTO lug_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Endiga eyookubiri onoogiwaayo akawungeezi awamu n’obuwunga n’ebyokunywa nga bw’onooba okoze mu makya, ne biryoka bivaamu akawoowo akalungi akasanyusa ak’ekiweebwayo ekyokebwa eri Mukama. ");
INSERT INTO lug_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Mu mirembe gyonna egigenda okujja, ekiweebwayo kino ekyokebwa kinaaweebwangayo eri Mukama obutayosa, mu mulyango gw’Eweema ey’Okukuŋŋaanirangamu. Awo we nnaakusanga ne njogera naawe. ");
INSERT INTO lug_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Era awo we nnaasisinkana abaana ba Isirayiri, ekifo ekyo ne kitukuzibwa nga kijjudde ekitiibwa kyange. ");
INSERT INTO lug_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Bwe ntyo nnaatukuza Eweema ey’Okukuŋŋaanirangamu n’ekyoto, era Alooni ne batabani be nabo nnaabatukuza, bampeereze nga bakabona. ");
INSERT INTO lug_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Bwe ntyo ndyoke mbeere mu baana ba Isirayiri era mbeere Katonda waabwe. ");
INSERT INTO lug_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Awo banaamanya nga nze Mukama Katonda waabwe, eyabaggya mu nsi y’e Misiri ndyoke mbeerenga mu bo. Nze Mukama Katonda waabwe.” ");
INSERT INTO lug_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Onookola ekyoto mu miti gya akasiya, okwoterezangako obubaane. ");
INSERT INTO lug_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kya kwenkanankana, sentimita amakumi ana mu ttaano buli ludda mu buwanvu ne mu bugazi; era kinaabeera n’obugulumivu bwa sentimita kyenda. Kubeeko amayembe amakole mu muti ogw’ekyoto nga si mayungeko buyunzi. ");
INSERT INTO lug_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ekyoto okiteekeko zaabu kyonna, waggulu ne mu mbiriizi, ne ku mayembe. Era kikolereko omuge ogwa zaabu okukyetooloola. ");
INSERT INTO lug_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Wansi w’omuge, mu mbiriizi z’ekyoto zombi, kolerawo empeta bbiri eza zaabu, okuyisaamu emisituliro gyakyo nga waliwo gye kitwalibwa. ");
INSERT INTO lug_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Emisituliro ogikole mu muti gwa akasiya, era ogiteekeko zaabu. ");
INSERT INTO lug_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ekyoto kitereeze mu maaso g’eggigi awali essanduuko ey’endagaano, awali ekisaanikira, ye ntebe ey’okusaasira, ekiri ku Ndagaano; awo we nnaakusisinkana. ");
INSERT INTO lug_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Alooni anaayotezanga obubaane buli nkya, bw’anajjanga okulongoosa ettaala. ");
INSERT INTO lug_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Era Alooni bw’anajjanga okukoleeza ettaala akawungeezi, anyookezenga obubaane mu maaso ga Mukama mu mirembe gyammwe gyonna. ");
INSERT INTO lug_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ku kyoto kino tojja kwoterezaako bubaane bulala, wadde ekiweebwayo ekyokebwa, newaakubadde eky’eŋŋaano era tojja kufukako ekiweebwayo eky’ekyokunywa. ");
INSERT INTO lug_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Alooni anaakolanga omukolo ogw’okulangiririra ku mayembe gaakyo omulundi gumu mu buli mwaka. Okulongoosa kuno okwa buli mwaka kunaakolebwanga n’omusaayi ogw’ekiweebwayo olw’ekibi mu mirembe gyammwe gyonna egigenda okujja. Ekyoto kya Mukama kino kitukuvu nnyo.” ");
INSERT INTO lug_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Bw’onoobalanga abaana ba Isirayiri, buli gw’onoobalanga anaasasulanga omuwendo eri Mukama olw’okununula obulamu bwe mu kiseera mw’abaliddwa, kawumpuli aleme okubagwamu. ");
INSERT INTO lug_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Buli abalibwa ne yeegatta ku bamaze okubalibwa, anaawaangayo gulaamu mukaaga eri Mukama, ng’okubala okw’Awatukuvu okutongole bwe kuli. Sekeri emu yenkanankana ne gera amakumi abiri. Gulaamu omukaaga zinaaweebwangayo ng’ekiweebwayo eri Mukama. ");
INSERT INTO lug_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Bonna abeegatta ku bamaze okubalibwa, okuva ku b’emyaka amakumi abiri egy’obukulu, n’okweyongerayo, anaawaayo ekiweebwayo ekyo eri Mukama. ");
INSERT INTO lug_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Abagagga tebaawengayo kusussa kitundu kya sekeri, n’omwavu taawengayo kitatuuka kitundu kya sekeri bwe munaawangayo ekiweebwayo eri Mukama olw’okwetangirira obulamu bwammwe. ");
INSERT INTO lug_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ensimbi abaana ba Isirayiri ze banaakuwa onoozikozesanga ku mirimu gy’Eweema ey’Okukuŋŋaanirangamu. Kinaabanga ekijjukizo mu maaso ga Mukama, olw’okwetangirira obulamu bwammwe.” ");
INSERT INTO lug_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Onookola ebbensani enaabirwamu nga ya kikomo ne ky’etuulako nga kya kikomo. Giteeke wakati w’ekyoto n’Eweema ey’Okukuŋŋaanirangamu; osseemu amazzi. ");
INSERT INTO lug_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Alooni ne batabani be ge banaakozesanga okunaaba engalo zaabwe n’ebigere byabwe. ");
INSERT INTO lug_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Bwe banaabanga bagenda okuyingira mu Weema ey’Okukuŋŋaanirangamu, banaanaabanga amazzi, baleme okufa. Era ne bwe banajjanga ku kyoto okuweereza nga bawaayo eri Mukama ekiweebwayo ekyokye n’omuliro, ");
INSERT INTO lug_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","banaanaabanga engalo zaabwe n’ebigere byabwe, baleme okufa. Kino kinaabanga kiragiro eky’olubeerera eri Alooni n’ezzadde lye emirembe gyonna.” ");
INSERT INTO lug_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ddira ebyakawoowo bino eby’omuwendo: Kiro mukaaga ez’omugavu omuyenge omuka, ne kiro ssatu eza kinamoni, ne kiro ssatu eza kalamu omuwoomerevu; ");
INSERT INTO lug_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ne kiro mukaaga eza kasiya, ne lita nnya ez’amafuta g’omuzeeyituuni; ng’ebipimo by’obuzito bw’omu Watukuvu bwe biri. ");
INSERT INTO lug_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Bino byonna obikolemu amafuta amatukuvu ag’okusiiga, nga bigattikibbwa bulungi ng’ebikoleddwa omutabuzi w’eby’akawoowo, ne galyoka gabeera amafuta amatukuvu ag’okufukibwangako. ");
INSERT INTO lug_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Olyoke osiige n’amafuta ago Eweema ey’Okukuŋŋaanirangamu, n’Essanduuko ey’Endagaano, ");
INSERT INTO lug_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","n’emmeeza n’ebibeerako byonna, n’ekikondo ky’ettaala n’ebyakyo byonna, n’ekyoto eky’obubaane, ");
INSERT INTO lug_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","n’ekyoto eky’ekiweebwayo ekyokebwa n’ebikozesebwako, n’ebbensani ne kw’etuula. ");
INSERT INTO lug_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Obyawule bifuuke bitukuvu nnyo, era buli ekinaabikomangako nga nakyo kifuuka kitukuvu. ");
INSERT INTO lug_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Alooni ne batabani be onoobafukako amafuta, obaawule, balyoke bampeerezenga nga bakabona. ");
INSERT INTO lug_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Era abaana ba Isirayiri obagambe nti, ‘Gano ge ganaabanga amafuta gange amatukuvu ag’okufukibwangako, mu mirembe gyammwe gyonna. ");
INSERT INTO lug_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Tegajjanga kufukibwa ku bantu ba bulijjo; era tewabangawo amafuta amalala agatabulwa mu ngeri eno. Gano matukuvu, era mujjukirenga nti matukuvu. ");
INSERT INTO lug_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Omuntu yenna anaakolanga amafuta ga kalifuuwa okufaanana ne gano, oba anaafukanga gano ku muntu yenna atali kabona, anaawaŋŋangusibwanga, n’ava mu bantu b’ewaabwe.’ ” ");
INSERT INTO lug_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Awo Mukama n’agamba Musa nti, “Ddira ebyakaloosa bino eby’omuwendo ennyo: sitakite, n’onuka, ne galabano, n’obubaane obuka, nga byenkanankana obuzito, ");
INSERT INTO lug_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Okolemu ebyakaloosa eby’omuwendo, bibe ng’ebikoleddwa omukugu w’ebyakaloosa. Obiteekemu omunnyo bibeere birongoofu era nga bitukuvu. ");
INSERT INTO lug_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Onoggyako ekitundu n’okisa ne kifuuka lufufugge, n’okiteeka okwolekera Essanduuko ey’Endagaano mu Weema ey’Okukuŋŋaanirangamu, awo we nnaakusisinkananga. Ekyo kinaabeeranga kitukuvu nnyo, gy’oli. ");
INSERT INTO lug_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Temwekoleranga ebyakaloosa ebyammwe ku bwammwe mu ntabula eno; bino binaabanga bitukuvu era nga bya Mukama. ");
INSERT INTO lug_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Omuntu yenna alikola ebibifaanana yeesanyuse olw’akaloosa kaabyo, anaawaŋŋangusibwanga, n’ava mu bantu b’ewaabwe.” ");
INSERT INTO lug_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Laba, nnonze Bezaaleeri mutabani wa Uli, muzzukulu wa Kuuli, ow’omu kika kya Yuda; ");
INSERT INTO lug_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","era mmujjuzza Omwoyo wa Katonda, n’okumanya, n’obusobozi n’amagezi mu kukola ebitali bimu ebyemikono ");
INSERT INTO lug_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","okutetenkanya ebintu ebinaakolebwa mu zaabu ne ffeeza n’ekikomo, nga bwe binaafaanana, ");
INSERT INTO lug_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","okwola amayinja n’okugategeka, n’okwola emiti, era n’okukola byonna ebyemikono ebya buli ngeri. ");
INSERT INTO lug_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ate mmulondeddeko Okoliyaabu mutabani wa Akisamaki, ow’omu kika kya Ddaani, okumuyamba. “Era abakugu abakola ebintu byonna ebya buli ngeri, mbawadde amagezi okukola bino byonna bye nkulagidde: ");
INSERT INTO lug_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“Eweema ey’Okukuŋŋaanirangamu, n’Essanduuko ey’Endagaano n’ekibikkako eky’entebe ey’okusaasira, awamu n’ebikozesebwa byonna mu Weema, ");
INSERT INTO lug_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","emmeeza n’ebigenderako, ekikondo ekya zaabu omuka eky’ettaala n’ebigenderako, n’ekyoto eky’obubaane, ");
INSERT INTO lug_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","n’ekyoto eky’ebiweebwayo ebyokebwa n’ebigenderako, n’ebbensani ne kw’etuula; ");
INSERT INTO lug_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","n’ebyambalo ebyalukibwa obulungi, ebyambalo ebitukuvu ebya Alooni, kabona, n’ebyambalo bya batabani be bye baweererezaamu mu bwakabona; ");
INSERT INTO lug_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","n’amafuta ag’okufukibwa, n’ebyakaloosa akalungi ak’omu Kifo Ekitukuvu. “Byonna babikole nga bwe nakulagira.” ");
INSERT INTO lug_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Tegeeza abaana ba Isirayiri nti, Munaateekwanga okukuuma Ssabbiiti zange, kubanga ako ke kabonero akanaabeeranga wakati wammwe nange mu mirembe gyammwe gyonna, mulyoke mumanye nga Nze Mukama, Nze mbatukuza. ");
INSERT INTO lug_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Munaakuumanga Ssabbiiti, kubanga lunaku lutukuvu. Buli anaaluweebuulanga waakufa; ne buli anaakolanga omulimu gwonna ku lunaku olwo waakuggibwa mu bantu be, attibwe. ");
INSERT INTO lug_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Emirimu ginaakolwanga mu nnaku mukaaga, naye olunaku olw’omusanvu ye Ssabbiiti ey’okuwummula, lunaku lwa Mukama lutukuvu. Buli anaakolanga omulimu ku lunaku lwa Ssabbiiti wa kuttibwa. ");
INSERT INTO lug_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Noolwekyo abaana ba Isirayiri banaakumanga olunaku lwa Ssabbiiti, nga balujjukira mu mirembe gyabwe gyonna, ng’endagaano etaggwaawo. ");
INSERT INTO lug_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Kanaabeeranga kabonero wakati wange n’abaana ba Isirayiri emirembe gyonna, akalaga nti Mukama yakola eggulu n’ensi mu nnaku mukaaga, ne ku lunaku olw’omusanvu n’alekeraawo okukola, n’awummula.’ ” ");
INSERT INTO lug_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Awo Mukama bwe yamaliriza okwogera ne Musa ku lusozi Sinaayi, n’awa Musa ebipande bibiri eby’amayinja, eby’Endagaano Katonda gye yawandiika n’engalo ye, ye kennyini. ");
INSERT INTO lug_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Abantu bwe baalaba nga Musa aluddeyo nnyo ku lusozi, ne bakuŋŋaanira awali Alooni, ne bamugamba nti, “Jjangu, otukolere bakatonda abanaatukulembera; kubanga Musa ono eyatuggya mu nsi y’e Misiri, tetumanyi kimutuuseeko.” ");
INSERT INTO lug_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Alooni n’abaddamu nti, “Mwambule empeta eza zaabu, bakyala bammwe, ne batabani bammwe, ne bawala bammwe ze bambadde ku matu gaabwe, muzindeetere.” ");
INSERT INTO lug_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Awo abantu bonna ne beenaanulako empeta zaabwe eza zaabu ez’oku matu, ne bazireetera Alooni. ");
INSERT INTO lug_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Alooni n’azisaanuusa; zaabu eyavaamu n’agibumbamu ennyana, ng’agirongoosa n’ekyuma. Ne balyoka boogera nti, “Bano be bakatonda bo ggwe Isirayiri abaakuggya mu nsi y’e Misiri!” ");
INSERT INTO lug_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Alooni bwe yalaba ebyo, n’azimba ekyoto mu maaso g’ennyana, n’alyoka alangirira nti, “Enkya tujja kukolera Mukama embaga.” ");
INSERT INTO lug_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Awo enkeera, abantu ne bazuukuka mu makya, ne bawaayo ebiweebwayo ebyokebwa, ne baleeta n’ebiweebwayo olw’emirembe; ne batuula ne balya era ne banywa, ne basituka ne bakola effujjo. ");
INSERT INTO lug_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Mukama n’agamba Musa nti, “Serengeta, kubanga abantu bo be waggya mu nsi ey’e Misiri boonoonye; ");
INSERT INTO lug_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","bavudde mangu mu kkubo lye nabalagira; beekoledde ennyana ensaanuuse ne bagisinza, ne bagireetera ebiweebwayo, ne boogera nti, ‘Bano be bakatonda bo, ggwe Isirayiri, abaakuggya mu nsi y’e Misiri!’ ” ");
INSERT INTO lug_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Mukama n’agamba Musa nti, “Abantu bano mbalabye, era ndabye nga bakakanyavu. ");
INSERT INTO lug_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Kale, kaakano ndeka obusungu bwange bubabuubuukireko, mbazikirize; kyokka ggwe ndikufuula eggwanga ekkulu.” ");
INSERT INTO lug_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Naye Musa ne yeegayirira Mukama Katonda we, n’agamba nti, “Lwaki obusungu bwo bubuubuukira abantu bo be waggya mu nsi y’e Misiri n’obuyinza, awamu n’omukono gwo ogw’amaanyi? ");
INSERT INTO lug_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Lwaki okwogeza Abamisiri nti, ‘Yabatwala ng’agenderedde kubakola kabi, abattire mu nsozi, abazikirize, bave ku nsi?’ Nyiigulukuka, obusungu obubuubuuka bukuveeko, oleme kuleeta bulabe ku bantu bo. ");
INSERT INTO lug_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Jjukira abaweereza bo Ibulayimu, ne Isaaka, ne Isirayiri, be walayirira ggwe kennyini, n’obagamba nti, ‘Ndyaza bazzukulu bammwe ng’emmunyeenye ez’oku ggulu, era n’ensi eno gye mbasuubizza ndigiwa bazzukulu bammwe, era eribeera omugabo gwammwe ennaku zonna.’ ” ");
INSERT INTO lug_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mukama akabi ke yali ategese okukola abantu be n’atakaleeta. ");
INSERT INTO lug_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Awo Musa n’aserengeta okuva ku lusozi ng’akutte mu mikono gye ebipande ebibiri eby’Endagaano, nga biwandiikiddwako ku njuyi zombi. ");
INSERT INTO lug_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ebipande byakolebwa Katonda, n’ebiwandiike ebyaliko byali bya Katonda, nga ye yabisala ku bipande ebyo. ");
INSERT INTO lug_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yoswa bwe yawulira oluyoogaano lw’abantu nga baleekaana, n’agamba Musa nti, “Mu lusiisira eriyo okuyoogaana ng’okw’olutalo.” ");
INSERT INTO lug_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Naye n’amuddamu nti, “Siwulira maloboozi galeekaana olw’obuwanguzi, oba amaloboozi g’okwaziirana olw’okuwangulwa, naye maloboozi ga kuyimba ge mpulira.” ");
INSERT INTO lug_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Naye Musa bwe yasemberera olusiisira, n’alengera ennyana, n’alaba n’amazina; obusungu bwe ne bubuubuuka, n’asuula eri ebipande ebyali mu mikono gye, ne bimenyekera awo wansi w’olusozi. ");
INSERT INTO lug_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","N’addira ennyana gye baali bakoze n’agyokya mu muliro n’agisekulasekula, n’agimerungulira ddala ng’olufuufu; olufuufu n’alumansa ku mazzi n’agawa abaana ba Isirayiri ne baganywa. ");
INSERT INTO lug_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Awo Musa n’agamba Alooni nti, “Abantu bano baakukoze ki, n’obaleetera okwonoona ennyo bwe batyo?” ");
INSERT INTO lug_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Alooni n’amuddamu nti, “Tonnyiigira nnyo, mukama wange, naawe abantu bano obamanyi, ng’emitima gyabwe bwe gyamanyiira okwonoona. ");
INSERT INTO lug_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Baŋŋambye nti, ‘Tukolere bakatonda abanaatukulembera kubanga Musa ono eyatuggya mu nsi y’e Misiri, tetumanyi kimutuuseeko.’ ");
INSERT INTO lug_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nange kwe kubagamba nti, ‘Buli alina ebya zaabu abyeyambuleko,’ ne babimpa ne mbiteeka mu muliro, ne bivaamu ennyana eno.” ");
INSERT INTO lug_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Awo Musa bwe yalaba ng’abantu basasamadde, nga Alooni yali abalese ne basasamala, era ng’abalabe baabwe babasekerera, ");
INSERT INTO lug_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","n’ayimirira mu mulyango gw’olusiisira, n’agamba nti, “Ani ali ku ludda lwa Mukama? Ajje wano we ndi.” Awo batabani ba Leevi bonna ne bakuŋŋaanira w’ali. ");
INSERT INTO lug_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","N’abagamba nti, “Bw’ati Mukama Katonda wa Isirayiri bw’ayogera nti, ‘Buli musajja yeesibe ekitala kye mu kiwato kye, muyiteeyite mu nsiisira okuva ku ludda olumu okutuuka ku ludda olulala, nga buli musajja atta muganda we ne mukwano gwe, ne muliraanwa we.’ ” ");
INSERT INTO lug_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Abaleevi ne bakola nga Musa bwe yabalagira; era ku lunaku olwo abantu ng’enkumi ssatu ne battibwa. ");
INSERT INTO lug_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Awo Musa n’agamba nti, “Mwawuddwa leero eri Mukama, bwe musse buli omu mutabani we, era ne muganda we; Mukama abawadde omukisa ku lunaku lwa leero.” ");
INSERT INTO lug_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Enkeera Musa n’agamba abantu nti, “Mwonoonye nnyo. Naye nze ka ŋŋende eri Mukama ndabe obanga nnaatangiririra ekibi kyammwe.” ");
INSERT INTO lug_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Bw’atyo Musa n’addayo eri Mukama, n’agamba nti, “Kitalo! Abantu bano nga boonoonye nnyo; bwe beekoledde bakatonda aba zaabu! ");
INSERT INTO lug_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Bw’oba osiima basonyiwe ekibi kyabwe; naye bwe kitaba kityo, nkwegayirira onsangule mu kitabo kyo ky’owandiise.” ");
INSERT INTO lug_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Naye Mukama n’agamba Musa nti, “Oyo yekka ankozeeko ekibi gwe ndisangula mu kitabo kyange. ");
INSERT INTO lug_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Kaakano genda otwale abantu mu kifo ekyo kye nakutegeeza; era, laba, malayika wange ajja kukukulembera. Naye ekiseera nga kituuse okubabonereza ndibabonerereza ddala olw’ekibi kyabwe.” ");
INSERT INTO lug_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Awo Mukama n’aleetera abantu kawumpuli, kubanga beekolera ennyana, Alooni gye yababumbira. ");
INSERT INTO lug_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Awo Mukama n’agamba Musa nti, “Vva mu kifo kino ogende, ggwe n’abantu be waggya mu nsi y’e Misiri, olage mu nsi gye nalayirira Ibulayimu ne Isaaka, ne Yakobo, nga njogera nti, ‘Ndigiwa bazzukulu bammwe.’ ");
INSERT INTO lug_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ndiweereza malayika abakulemberenga; era ndigobamu Abakanani, n’Abamoli, n’Abakiiti, n’Abaperezi, n’Abakiivi n’Abayebusi. ");
INSERT INTO lug_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Yambuka mu nsi ekulukutiramu amata n’omubisi gw’enjuki. Naye sijja kugenda nammwe; sirwa kubazikiririza mu kkubo, kubanga muli bantu ab’ensingo enkakanyavu.” ");
INSERT INTO lug_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Abantu bwe baawulira amawulire ago ag’ennaku, ne bakungubaga ne watabaawo ayambala eby’omu matu wadde eby’oku mikono ebyokwewoomya. ");
INSERT INTO lug_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Kubanga Mukama yali alagidde Musa nti, “Gamba abaana ba Isirayiri nti, ‘Mulina omutima omukakanyavu, era singa ntambula nammwe okumala akaseera wadde katono katya, nzija kubazikiriza. Kale kaakano mweyambulemu ebyokwewoomya byammwe, ndyoke ndabe kye nnaakola.’ ” ");
INSERT INTO lug_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Bwe batyo abaana ba Isirayiri ne beeyambulamu eby’obugagga byabwe nga bali ku lusozi Kolebu. ");
INSERT INTO lug_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Kale, Musa yaddiranga eweema n’agisimba ebweru w’olusiisira, ewala ddala n’olusiisira; n’agiyita Eweema ey’Okukuŋŋaanirangamu. Ne buli eyeetaaganga Mukama, ng’agenda awali Eweema ey’Okukuŋŋaanirangamu, eyali ebweru w’olusiisira. ");
INSERT INTO lug_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Era buli Musa lwe yafulumanga n’alaga eri Eweema, abantu bonna nga bayimirira mu miryango gy’eweema zaabwe ne batunuulira Musa okutuusa lwe yayingiranga mu Weema. ");
INSERT INTO lug_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musa bwe yayingiranga mu Weema, empagi ey’ekire n’ekka n’eyimirira mu mulyango gw’Eweema; Mukama n’alyoka ayogera ne Musa. ");
INSERT INTO lug_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Abantu bwe baalabanga ng’empagi ey’ekire eyimiridde mu mulyango gw’Eweema, bonna ne basituka ne basinza, buli omu mu mulyango gw’eweema ye. ");
INSERT INTO lug_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Bw’atyo Mukama bwe yayogeranga ne Musa nga batunulaganye, ng’omuntu bw’ayogera ne mukwano gwe. Musa bwe yaddangayo mu lusiisira, omuweereza we, omuvubuka Yoswa mutabani wa Nuuni, ye n’asigalayo mu Weema. ");
INSERT INTO lug_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa n’agamba Mukama nti, “Obadde ontegeeza nti, ‘Kulembera abantu bano,’ naye omuntu gw’onontuma naye tomuntegeezezza. Ogambye nti, ‘Nkumanyi awamu n’erinnya lyo, era onsanyusizza.’ ");
INSERT INTO lug_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Obanga nkusanyusizza, njigiriza amakubo go ndyoke nkumanye era nneeyongeranga okukusanyusa. Jjukira nti eggwanga lino be bantu bo.” ");
INSERT INTO lug_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Mukama n’addamu nti, “Nnaagendanga naawe, era nnaakuwummuzanga.” ");
INSERT INTO lug_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa n’amugamba nti, “Obanga toogende naffe, totuggya wano. ");
INSERT INTO lug_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Kale abantu balitegeerera ku ki nga Nkusanyusizza, nze n’abantu bo? Si lwa kubanga onooba ogenze naffe, ne tuba ba njawulo, nze n’abantu bo, nga twawukana ku bantu bonna ab’oku nsi?” ");
INSERT INTO lug_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Awo Mukama n’agamba Musa nti, “Nzija kukola ekyo kyennyini ky’osabye; onsanyusizza, era nkumanyi awamu n’erinnya lyo.” ");
INSERT INTO lug_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa n’agamba nti, “Nkwegayiridde, ndaga ekitiibwa kyo.” ");
INSERT INTO lug_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Mukama n’agamba nti, “Nzija kuggyayo obulungi bwange bwonna nga mbuyisa mu maaso go. Era nzija kukutegeeza erinnya lyange, Mukama. Buli gwe nnaayagalanga okukwatirwa ekisa, nnaamukwatirwanga ekisa, ne buli gwe nnaayagalanga okusaasira nnaamusaasiranga.” ");
INSERT INTO lug_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Era n’agamba nti, “Naye toyinza kulaba maaso gange, kubanga tewali muntu antunulako n’aba mulamu.” ");
INSERT INTO lug_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Mukama n’agamba nti, “Waliwo wano okumpi nange ekifo ku lwazi kw’onooyimirira. ");
INSERT INTO lug_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ekitiibwa kyange bwe kinaaba kiyitawo, nnaakuteeka mu mpataanya mu lwazi, ne nkubikkako omukono gwange okutuusa lwe nnaamala okuyitawo. ");
INSERT INTO lug_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Oluvannyuma omukono gwange nnaaguggyawo, n’olaba amabega gange; naye tojja kulaba ku maaso gange.” ");
INSERT INTO lug_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Awo Mukama n’agamba Musa nti, “Teekateeka ebipande bibiri eby’amayinja nga biri ebyasooka, nange nnaabiwandiikako ebigambo ebyali ku bipande ebyasooka bye wamenya. ");
INSERT INTO lug_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Weetegeke mu makya, ojje mu makya ago olinnye waggulu ku lusozi Sinaayi, olyoke onneeyanjulire eyo ku ntikko y’olusozi. ");
INSERT INTO lug_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tewasaana kubaawo muntu ajja naawe, era ku lusozi wonna wonna tewasaana kulabikawo muntu n’omu; era n’amagana n’ebisibo by’endiga tebisaana kuliira mu maaso ga lusozi.” ");
INSERT INTO lug_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Bw’atyo Musa n’atema mu mayinja ebipande bibiri nga bifaanana nga biri ebyasooka; n’akeera mu makya n’alinnya ku lusozi Sinaayi, nga Mukama bwe yamulagira, ng’asitudde n’ebipande eby’amayinja byombi mu mikono gye. ");
INSERT INTO lug_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Awo Mukama n’akkira mu kire, n’ayimirira awo ne Musa, n’alangirira erinnya lye, Mukama. ");
INSERT INTO lug_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Mukama n’ayita mu maaso ga Musa n’agamba nti, “Nze Mukama, Mukama Katonda alina ekisa n’okusaasira okungi, atasunguwala mangu, ajjudde obwesigwa n’okwagala okutaggwaawo. ");
INSERT INTO lug_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Akuuma okwagala eri enkumi n’enkumi asonyiwa ebisobyo byabwe, n’obujeemu bwabwe, n’ebibi byabwe. Talema kubonereza oyo asingiddwa omusango. Abonereza abaana n’abazzukulu olw’ebisobyo bya bakadde baabwe n’ebya bajjajjaabwe, okutuukira ddala ku mulembe ogwokusatu n’ogwokuna.” ");
INSERT INTO lug_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Amangwago Musa n’avuunama wansi, n’asinza. ");
INSERT INTO lug_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","N’agamba nti, “Obanga kaakano nkusanyusizza, Ayi Mukama, jjangu, Mukama, ogende naffe. Newaakubadde ng’abantu bano balina ensingo nkakanyavu, naye tusonyiwe ebyonoono byaffe n’ebibi byaffe, otukkirize tubeere abantu bo ab’obusika bwo.” ");
INSERT INTO lug_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Awo Mukama n’addamu nti, “Laba, nkola naawe endagaano. Nzija kukolera mu bantu bo ebyamagero ebitakolwangako mu nsi yonna, wadde mu ggwanga lyonna. Abantu bonna b’oli nabo banaalaba eby’ekitalo Mukama by’anaakolera mu ggwe. ");
INSERT INTO lug_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Gondera bye nkulagira leero. Nange, gye mulaga, nzija kugobayo Abamoli, n’Abakanani, n’Abakiiti, n’Abaperezi, n’Abakiivi, n’Abayebusi. ");
INSERT INTO lug_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Kirungi weekuume oleme kukola ndagaano n’abatuuze ab’omu nsi gy’olagamu, kubanga bayinza okubafuukira omutego. ");
INSERT INTO lug_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Olimenyaamenya ebyoto byabwe, obetente empagi zaabwe, n’otemaatema ebifaananyi byabwe ebibajje bye basinza. ");
INSERT INTO lug_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Tosinzanga katonda mulala yenna, kubanga Nze Mukama, ayitibwa Waabuggya, ndi Katonda wa buggya. ");
INSERT INTO lug_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Temukolanga ndagaano ey’okukolagana n’abatuuze b’omu nsi omwo. Kubanga bwe baliba bagoberera bakatonda baabwe, nga bawaayo ssaddaaka, gamba omu ku bo n’abayita, mulirya ku biweebwayo byabwe ebyo. ");
INSERT INTO lug_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Era bwe muliwasiza batabani bammwe abamu ku bawala baabwe, abawala abo ne bagoberera bakatonda baabwe, balireetera batabani bammwe nabo okukola bwe batyo. ");
INSERT INTO lug_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Temwekoleranga bakatonda mu byuma ebisaanuuse. ");
INSERT INTO lug_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Embaga ey’Emigaati Egitali Mizimbulukuse ogikwatanga. Munaamalanga ennaku musanvu nga mulya emigaati egitali mizimbulukuse, mu kiseera ekyategekebwa mu mwezi gwa Abibu nga bwe nabalagira; kubanga mu mwezi gwa Abibu mwe mwaviira mu Misiri. ");
INSERT INTO lug_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Ebiggulanda byonna byange, n’ennume zonna mu magana go embereberye, oba nte oba ndiga. ");
INSERT INTO lug_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Endogoyi embereberye onoozinunulanga n’endiga, naye nga toginunudde ogimenyanga ensingo n’ogitta. Abaana bo abaggulanda bonna obanunulanga. Era tewabanga ajja gye ndi engalo ensa. ");
INSERT INTO lug_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Onookolanga okumala ennaku mukaaga, naye ku lunaku olw’omusanvu n’owummula; ne mu biseera eby’okukabala n’ebyokukungula onoowummulanga. ");
INSERT INTO lug_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Onookwatanga Embaga eya Wiiki, n’Embaga ey’Amakungula g’Ebibala Ebibereberye eby’Eŋŋaano, n’Embaga ey’Okuyingiza Amakungula ku nkomerero y’omwaka. ");
INSERT INTO lug_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Abasajja bonna mu mmwe banaalabikanga awali Mukama Katonda, Katonda wa Isirayiri, emirundi esatu mu buli mwaka. ");
INSERT INTO lug_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Amawanga ŋŋenda kugagobawo wonna we muli, era ndigaziya n’ensalo zammwe. So tewalibaawo ayagala kutwala nsi yammwe nga mwambuse okulabika awali Mukama Katonda wammwe emirundi egyo esatu mu mwaka. ");
INSERT INTO lug_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Temuwangayo kintu kyonna gye ndi ekirimu ekizimbulukusa nga mundeetedde ssaddaaka erimu omusaayi; era ennyama ya ssaddaaka ey’Embaga y’Okuyitako tesigalangawo kutuusa nkeera. ");
INSERT INTO lug_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ebibala ebisinga obulungi mu ebyo ebisoose okuva mu ttaka lyo obitwalanga mu nnyumba ya Mukama Katonda wo. “Omwana gw’embuzi togufumbiranga mu mata ga nnyina waagwo.” ");
INSERT INTO lug_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Awo Mukama n’agamba Musa nti, “Wandiika ebigambo ebyo; kubanga nkoze endagaano naawe era ne Isirayiri ng’ebigambo ebyo bwe bigamba.” ");
INSERT INTO lug_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa n’abeera eyo ne Mukama, n’amalayo emisana amakumi ana n’ebiro amakumi ana, nga talya mmere wadde okunywa amazzi. N’awandiika ku bipande ebigambo eby’Endagaano, ge Mateeka Ekkumi. ");
INSERT INTO lug_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa bwe yaserengeta okuva ku lusozi Sinaayi ng’akutte mu ngalo ze ebipande byombi eby’Endagaano, teyakimanya ng’obwenyi bwe bwali bumasamasa kubanga yali ayogedde ne Mukama. ");
INSERT INTO lug_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Era Alooni n’abaana ba Isirayiri bonna bwe baatunula ku Musa, ne balaba ng’obwenyi bwe bumasamasa; ne batya okumusemberera. ");
INSERT INTO lug_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Naye Musa n’abayita; bw’atyo Alooni n’abakulembeze b’abantu ne bajja gy’ali, Musa n’ayogera nabo. ");
INSERT INTO lug_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Oluvannyuma abaana ba Isirayiri bonna ne basembera, n’abategeeza amateeka gonna Mukama ge yamulagira ku lusozi Sinaayi. ");
INSERT INTO lug_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Awo Musa bwe yamala okwogera nabo, n’abikka obwenyi bwe olugoye. ");
INSERT INTO lug_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Naye Musa bwe yabanga agenda awali Mukama okwogera naye, ng’olugoye olubikka obwenyi bwe alwebikkula okutuusa lwe yavangayo. Bwe yakomangawo okutegeeza abaana ba Isirayiri Mukama by’amulagidde, ");
INSERT INTO lug_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","baalabanga obwenyi bwe nga bumasamasa. Bw’atyo Musa ne yezzaako olugoye olubikka obwenyi bwe, okutuusa lwe yaddangayo eri Mukama okwogera naye. ");
INSERT INTO lug_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Awo Musa n’akuŋŋaanya ekibiina kyonna eky’abaana ba Isirayiri, n’abagamba nti, “Bino bye bintu Mukama by’abalagidde okukola. ");
INSERT INTO lug_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Munaakolanga emirimu mu nnaku omukaaga; naye olunaku olw’omusanvu lunaabanga Lwassabbiiti, lutukuvu, munaaluwummulanga awali Mukama. Buli anaakoleranga omulimu ku lunaku olwo anattibwanga. ");
INSERT INTO lug_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Temukumanga muliro mu nnyumba zammwe ku lunaku Lwassabbiiti.” ");
INSERT INTO lug_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa n’agamba ekibiina kyonna eky’abaana ba Isirayiri nti, “Kino Mukama ky’alagidde. ");
INSERT INTO lug_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Mutoole ku bye mulina muweeyo eri Mukama. Buli omu aweeyo, nga bw’ayagala mu mutima gwe ebiweebwayo eri Mukama: “zaabu, ne ffeeza, n’ekikomo; ");
INSERT INTO lug_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","n’olugoye olwa bbululu, n’olwa kakobe, n’olumyufu, n’olugoye olwa linena erangiddwa mu wuzi ennungi; n’obwoya bw’embuzi, ");
INSERT INTO lug_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","n’amaliba g’endiga ennume amakunye amannyike mu langi emyufu, n’ekika ky’eddiba ekirala ekiwangaazi; n’embaawo z’omuti gwa akasiya, ");
INSERT INTO lug_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","n’amafuta g’ettaala, n’ebyakaloosa eby’okukozesa mu mafuta ag’okwawula, ne mu bubaane obw’okunyookeza, ");
INSERT INTO lug_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","n’amayinja aga onuku n’amayinja amalala ag’omuwendo, ag’okutona ku kkanzu ey’obwakabona eyitibwa efodi era ne ku kyomukifuba. ");
INSERT INTO lug_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Abo bonna mu mmwe abakugu mu kukola, muveeyo mujje mukole ebyo byonna Mukama by’atulagidde: ");
INSERT INTO lug_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“Eweema ya Mukama Omukuŋŋaanirwa n’olugoye lwayo n’ekibikkako, n’ebisiba, n’embaawo, n’emikiikiro, n’empagi zaayo, n’ebituurwamu; ");
INSERT INTO lug_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","essanduuko ey’Endagaano n’emisituliro gyayo, n’ekisaanikira, ye ntebe ey’okusaasira, n’eggigi erigisiikiriza; ");
INSERT INTO lug_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","emmeeza n’emisituliro gyayo ne byonna ebigibeerako, n’emigaati gya egy’Okulaga; ");
INSERT INTO lug_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ekikondo ky’ettaala n’ebigenderako, ettaala n’amafuta gaazo; ");
INSERT INTO lug_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ekyoto eky’okwoterezaamu obubaane n’emisituliro gyakyo; amafuta ag’okwawula, n’obubaane obw’akawoowo; olutimbe olw’omu mulyango oguyingira mu Weema ya Mukama; ");
INSERT INTO lug_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ekyoto eky’ebiweebwayo ebyokebwa n’ekitindiro kyakyo eky’ekikomo; emisituliro gyakyo ne byonna ebikozeserwako; ebbensani ey’ekikomo ne ky’etuulako; ");
INSERT INTO lug_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","entimbe ez’oku bisenge eby’omu luggya n’empagi zaazo ne mwe zituula; n’olutimbe olw’omu mulyango ogulaga mu luggya; ");
INSERT INTO lug_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","enkondo z’eweema n’ez’omu luggya n’emiguwa gyazo; ");
INSERT INTO lug_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ebyambalo ebiruke ebyambalwa mu kuweereza mu Kifo Ekitukuvu, bye byambalo ebitukuvu ebya Alooni kabona, n’ebyambalo bya batabani be bye bakozesa mu bwakabona nga baweereza.” ");
INSERT INTO lug_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Awo abantu bonna ab’ekibiina ky’abaana ba Isirayiri ne bava awali Musa ne bagenda. ");
INSERT INTO lug_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Buli eyayagala, era ng’omwoyo gwe bwe gwamukubiriza, n’awaayo eri Mukama eby’okukozesa Eweema ey’Okukuŋŋaanirangamu n’ebikozesebwamu byonna, n’eby’okukozesa ebyambalo ebitukuvu. ");
INSERT INTO lug_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Abasajja n’abakazi bonna abaayagala mu mitima gyabwe ne bajja; ne baleeta ebikwaso eby’omuwendo, empeta ez’omu matu, n’empeta ez’oku ngalo, n’ebikomo, n’ebirala ebya zaabu ebitali bimu; buli muntu n’awaayo ekirabo ekya zaabu eri Mukama. ");
INSERT INTO lug_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Era buli muntu eyalina olugoye olwa bbululu, oba olwa kakobe, oba olumyufu, oba olwa linena ennungi, oba olw’obwoya bw’embuzi; oba amaliba amakunye ag’endiga ensajja oba ag’embuzi, byonna ne babireeta. ");
INSERT INTO lug_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Buli omu eyalina eky’okuwaayo ekya ffeeza oba eky’ekikomo, yakireeta n’akiwaayo eri Mukama; era na buli musajja eyalina olubaawo olwa akasiya nga luyinza okugasa mu mulimu ogwali gukolebwa, yaluleeta n’aluwaayo. ");
INSERT INTO lug_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Abakazi bonna abaali bamanyi ennyo okulanga ewuzi, ne balanga n’engalo zaabwe ewuzi eza bbululu, n’eza kakobe, n’emyufu n’eza linena omuyonde obulungi, ne bazireeta ne baziwaayo. ");
INSERT INTO lug_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Era n’abakazi bonna abaali abakugu era nga beeyagalidde, ne balanga ewuzi mu bwoya bw’embuzi. ");
INSERT INTO lug_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Awo abakulembeze ne baleeta amayinja aga onuku, n’amayinja amalala ag’omuwendo, gasalibwe galyoke gatonebwe ku kkanzu ey’obwakabona eyitibwa efodi ne ku ky’omu kifuba. ");
INSERT INTO lug_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Era ne baleeta n’ebyakaloosa, n’amafuta g’ettaala, n’amafuta ag’okwawula n’okukozesa ku bubaane. ");
INSERT INTO lug_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Abaana ba Isirayiri bonna, abasajja n’abakazi, abaalina omutima ogwagala okuleeta ekintu kyonna olw’omulimu Mukama gwe yali alagidde Musa okukolebwa, ne bakireeta ng’ekiweebwayo kyabwe kye baawaayo eri Mukama nga beesiimidde. ");
INSERT INTO lug_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Awo Musa n’agamba abaana ba Isirayiri nti, “Muwulire. Mukama alonze Bezaaleeri mutabani wa Uli, muzzukulu wa Kuuli, ow’omu kika kya Yuda. ");
INSERT INTO lug_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Mukama amujjuzza Omwoyo we, n’obusobozi, n’amagezi, n’okuteteenkanya, n’okutegeera, awamu n’obukozi obwa buli ngeri; ");
INSERT INTO lug_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ayiiye amajjolobera ag’okukolebwa mu zaabu ne ffeeza ne mu kikomo; ");
INSERT INTO lug_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","era n’ag’okusalwa mu mayinja ag’okutona, era n’ag’okwolebwa mu miti, n’okukola buli ngeri yonna ey’amagezi. ");
INSERT INTO lug_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Era ye ne Okoliyaabu mutabani wa Akisamaki ow’omu kika kya Ddaani, Mukama abawadde obusobozi okuyigiriza abalala. ");
INSERT INTO lug_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Abajjuzza amagezi ag’obukugu mu mitima gyabwe okukola eby’emikono ebya buli ngeri ng’ebikolebwa abayiiya amajjolobera, oba abasala amayinja, oba abatunzi b’emidalizo n’ebimuli mu wuzi eza bbululu, n’eza kakobe n’emyufu mu bitambaala ebya linena omulungi, oba abalusi, oba abakugu abakola ebintu byonna ebya buli ngeri n’abatetenkanya amajjolobera.” ");
INSERT INTO lug_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Bezaaleeri ne Okoliyaabu ne buli musajja mukugu yenna, Mukama gw’awadde obusobozi n’amagezi okumanya okukola omulimu gwonna ku kuzimba eweema ya Mukama, bajja kukola nga Mukama bw’alagidde.” ");
INSERT INTO lug_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Awo Musa n’ayita Bezaaleeri ne Okoliyaabu, ne buli mukugu yenna Mukama gwe yali awadde amagezi n’obusobozi, era nga yeeyagalidde yekka okukola. ");
INSERT INTO lug_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Musa n’abakwasa ebirabo byonna abaana ba Isirayiri bye baali batonedde Mukama nga bwe baali beeyagalidde eby’okukozesa eweema ya Mukama. Abantu ne bongera okuleeta ku byabwe ebya kyeyagalire buli nkya. ");
INSERT INTO lug_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Awo abakozi bali abakugu abaali bakola eweema ya Mukama ne bava ku mirimu gyabwe, ");
INSERT INTO lug_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ne bajja eri Musa ne bamugamba nti, “Ebirabo abantu bye baleese bisukkiridde obungi ku ebyo ebyetaagibwa okumala omulimu Mukama gwe yalagira okukolebwa.” ");
INSERT INTO lug_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Awo Musa n’awa ekiragiro ne kibunyisibwa mu lusiisira lwonna nti, “Tewabaawo musajja oba mukazi ayongera okuleeta ekiweebwayo olw’omulimu gw’Eweema ya Mukama.” Bwe batyo abantu ne bagaanibwa okwongera okuwaayo; ");
INSERT INTO lug_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","kubanga ebyo abakozi bye baalina byali bimala omulimu ogwo era n’okufikkawo. ");
INSERT INTO lug_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Awo bannakinku bonna mu basajja abakozi ne bakola Eweema ya Mukama n’emitanda kkumi egya linena omunyoole omulungi ennyo, nga mulimu n’ebya bbululu, ne kakobe, ne myufu, ne bakerubi nga batungiddwamu n’amagezi mangi. ");
INSERT INTO lug_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Emitanda gyonna gyali gyenkanankana; ng’omutanda ogumu guweza obuwanvu mita kkumi na bbiri n’ekitundu, ate obugazi mita emu ne desimoolo munaana. ");
INSERT INTO lug_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Baagatta emitanda etaano nga bagisengese, gumu ku gunnaagwo, n’emitanda emirala etaano nagyo ne bagigatta bwe batyo. ");
INSERT INTO lug_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ne batunga eŋŋango eza bbululu ku mukugiro gw’omutanda gw’entimbe ogukomererayo mu kitundu ekimu eky’entimbe etaano, era ne batunga n’eŋŋango endala mu ngeri y’emu ku ludda olulala. ");
INSERT INTO lug_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Baatunga eŋŋango amakumi ataano ku mutanda ogumu, era ne batunga eŋŋango endala amakumi ataano ku mukugiro gw’omutanda ku ludda olulala, eŋŋango nga zoolekaganye. ");
INSERT INTO lug_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ne bakola ebikwaso ebya zaabu amakumi ataano, ne bakwasa wamu enjuuyi zombi ez’emitanda n’ebikwaso; Eweema n’ebeera wamu nga nnamba. ");
INSERT INTO lug_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ne bakola entimbe kkumi na lumu nga zirukiddwa mu bwoya bw’embuzi ne bazibikka ku Weema. ");
INSERT INTO lug_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Entimbe zonna ekkumi n’olumu zaali zenkanankana: ng’obuwanvu mita kkumi na ssatu n’ekitundu, obugazi zaali mita emu n’obutundu munaana. ");
INSERT INTO lug_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ne bagatta entimbe ttaano wamu ku bwazo, n’entimbe omukaaga nazo ne bazigatta ku bwazo. ");
INSERT INTO lug_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ne batunga eŋŋango amakumi ataano ku mukugiro gw’entimbe ekomererayo ku bwazo, n’eŋŋango amakumi ataano endala ku mukugiro gw’entimbe omulala ku bwazo. ");
INSERT INTO lug_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ne bakola ebikwaso eby’ekikomo amakumi ataano, ne babiyisa mu ŋŋango okunyweza enjuuyi zombi ez’entimbe ezo ng’ekintu ekimu. ");
INSERT INTO lug_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ne bakola ekibikka ku Weema mu maliba g’endiga ennume nga gannyikiddwa mu langi emyufu; okwo ne babikkako amaliba g’ente ey’omu nnyanja. ");
INSERT INTO lug_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Awo ne babajja embaawo mu muti gwa akasiya ne baziyimiriza ne zikola entobo ya Weema. ");
INSERT INTO lug_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Buli lubaawo lwali mita nnya n’ekitundu obuwanvu, ate ng’obugazi zaali sentimita nkaaga mu musanvu. ");
INSERT INTO lug_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Buli lubaawo baaluteekako obubaawo obuyiseemu bubiri, obw’okukozesa mu kugatta, nga bulekawo amabanga agenkanankana. Embaawo zonna ez’entobo ya Weema bwe baazikola bwe batyo. ");
INSERT INTO lug_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Baakola embaawo amakumi abiri ne bazissa ku ludda olw’obukiikaddyo obw’Eweema, ");
INSERT INTO lug_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","era ne bakola obubya obutono obwa ffeeza amakumi ana, ne babussa wansi w’obubaawo obuyiseemu obubiri ku buli lubaawo. ");
INSERT INTO lug_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ate ku ludda olw’obukiikakkono olw’Eweema ne bakolerayo embaawo amakumi abiri, ");
INSERT INTO lug_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","n’entobo eza ffeeza amakumi ana, bbiri nga ziri wansi wa buli lubaawo. ");
INSERT INTO lug_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ne bakola embaawo mukaaga, ne baziteeka ku ludda olw’emabega wa Weema, lwe lw’ebugwanjuba; ");
INSERT INTO lug_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","era ne bakola embaawo endala bbiri ne bazissa ku nsonda ez’oku ludda olwo olw’ebugwanjuba. ");
INSERT INTO lug_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ku nsonda zino ebbiri, embaawo zombi baazisiba wamu nabansasaana okuviira ddala wansi okutuuka waggulu, ne bazinyweza n’empeta. ");
INSERT INTO lug_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Noolwekyo waaliwo embaawo munaana, n’entobo eza ffeeza kkumi na mukaaga, nga buli lubaawo wansi waalwo eriyo bbiri bbiri. ");
INSERT INTO lug_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ne bakola emikiikiro mu muti gwa akasiya. Emikiikiro etaano ne bagikozesa ku mbaawo eziri ku lusebenju lwa Weema olumu, ");
INSERT INTO lug_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","n’emikiikiro etaano ku mbaawo eziri ku lusebenju lwa Weema olulala, n’emikiikiro etaano ne bagikozesa ku mbaawo eziri ku ludda olw’emabega wa Weema olw’ebugwanjuba. ");
INSERT INTO lug_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ne bassaayo omulabba nga guyita wakati w’embaawo nga guva ku ludda olumu okutuuka ku ludda olulala. ");
INSERT INTO lug_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Embaawo ne bazibikkako zaabu, era ne bakola empeta eza zaabu ne bazisibisa emikiikiro; n’emikiikiro nagyo ne bagibikkako zaabu. ");
INSERT INTO lug_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Baakola eggigi mu wuzi eza bbululu, ne kakobe, ne myufu ne linena omulebevu omulungi alangiddwa; era omukozi omukugu n’atungiramu bakerubi. ");
INSERT INTO lug_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ne baliwanika n’amalobo aga zaabu ku mpagi nnya ezaabajjibwa mu muti gwa akasiya, nga zibikkiddwako zaabu, era nga zisimbiddwa mu ntobo eza ffeeza. ");
INSERT INTO lug_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ne bakola olutimbe olw’omu mulyango gwa Weema mu wuzi eza bbululu, ne kakobe, ne myufu ne linena omulebevu alangiddwa obulungi. ");
INSERT INTO lug_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ne balukolera empagi ttaano nga bazibazze mu muti gwa akasiya, ne baziteekako n’amalobo gaazo. Ne babikka zaabu kungulu ku mpagi ne ku bisiba byazo. Entobo zaazo ettaano ne bazikola mu kikomo. ");
INSERT INTO lug_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Awo Bezaaleeri n’akola Essanduuko mu muti gwa akasiya; ng’obuwanvu bwayo mita emu ne desimoolo emu, n’obugazi sentimita nkaaga mu musanvu, n’obugulumivu nabwo sentimita nkaaga mu musanvu. ");
INSERT INTO lug_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","N’agibikkako zaabu omuka ennyo kungulu ne munda, era n’agyetoolooza omuge ogwa zaabu. ");
INSERT INTO lug_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","N’agiweeseza empeta nnya eza zaabu, n’azisiba ku magulu gaayo ana, ng’empeta ebbiri ziri ku ludda lwayo olumu n’endala ebbiri ku ludda lwayo olulala. ");
INSERT INTO lug_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","N’abajja emisituliro mu muti ogwa akasiya, n’agibikkako zaabu, ");
INSERT INTO lug_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","n’agisonseka mu mpeta ziri okusituzanga essanduuko. ");
INSERT INTO lug_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","N’akolerako ekisaanikira, ye ntebe ey’okusaasira nga kya zaabu omuka ennyo; obuwanvu bwakyo bwali mita emu ne desimoolo emu, n’obugazi sentimita nkaaga mu musanvu. ");
INSERT INTO lug_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","N’akolerako ne bakerubi babiri mu zaabu omuweese ku njuyi ebbiri ez’ekisaanikira, ye ntebe ey’okusaasira. ");
INSERT INTO lug_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Kerubi omu yamuteeka ku ludda lumu olw’ekisaanikira, ye ntebe ey’okusaasira, ne kerubi omulala ku ludda olwokubiri, nga bakerubi bombi beekutte wamu n’ekisaanikirako, ye ntebe ey’okusaasira. ");
INSERT INTO lug_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ebiwaawaatiro bya bakerubi yabikola nga bibikkule nga bisonze waggulu, era nga bisiikirizza ekisaanikira, ye ntebe ey’okusaasira. Bakerubi ne batunulagana nga boolekedde ekisaanikira, ye ntebe ey’okusaasira. ");
INSERT INTO lug_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","N’akola n’emmeeza mu muti gwa akasiya, obuwanvu bwayo sentimita kyenda, n’obugazi sentimita amakumi ana mu ttaano, n’obugulumivu sentimita nkaaga mu musanvu. ");
INSERT INTO lug_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","N’agibikkako zaabu omuka ennyo, era n’agyetoolooza omuge ogwa zaabu. ");
INSERT INTO lug_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","N’agikolerako olukugiro oluweza sentimita musanvu ne desimoolo ttaano obugazi, n’omuge ogwa zaabu okwebungulula olukugiro olwo. ");
INSERT INTO lug_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","N’aweesa empeta nnya eza zaabu, n’azisiba mu nsonda ennya awali amagulu gaayo ana. ");
INSERT INTO lug_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Empeta ezo yazissa kumpi n’olukugiro ziyisibwemu emisituliro gy’emmeeza. ");
INSERT INTO lug_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","N’akola emisituliro gy’emmeeza mu muti gwa akasiya, n’agibikkako zaabu. ");
INSERT INTO lug_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","N’akola mu zaabu omuka, ebikozesebwa eby’okubeeranga ku mmeeza: essowaani zaako, n’ebijiiko byako, n’ebibya eby’okufukanga ebiweebwayo eby’okunywa. ");
INSERT INTO lug_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Yakola ekikondo ky’ettaala nga kya zaabu omuka. Yakiweesezaako entobo yaakyo n’enduli, n’ebikopo ebifaanana ng’ebimuli, amatabi n’emitunsi n’ebimuli byako; byonna yabiweesa mu kyuma kya zaabu kimu bulambalamba. ");
INSERT INTO lug_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Kwaliko amatabi mukaaga agafaanana ng’omutuula emisubbaawa; amatabi asatu nga gali ku ludda lumu n’amalala asatu nga gali ku ludda olulala. ");
INSERT INTO lug_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ku ttabi erimu kwaliko ebikopo bisatu nga bikoleddwa ng’ebimuli by’alumondi n’emitunsi n’ebimuli, ate bisatu ne bibeera ku ttabi eddala, n’ebirala bisatu ne bibeera ku buli limu ku matabi amalala okutuusa amatabi omukaaga gonna agava ku kikondo ky’ettaala lwe gaabuna. ");
INSERT INTO lug_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ku kikondo ky’ettaala kwennyini kwaliko ebikopo bina ebyakolebwa ng’ebimuli by’alumondi n’emitunsi gyabyo n’ebimuli byako. ");
INSERT INTO lug_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Omutunsi ogumu gwali wansi w’amatabi abiri agava ku kikondo ky’ettaala, n’omuntunsi ogwokubiri ne gubeera wansi w’amatabi abiri agaddirira, n’omutunsi ogwokusatu ne gubeera wansi w’amatabi abiri agaddako, amatabi gonna omukaaga ne gabuna. ");
INSERT INTO lug_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Emitunsi n’amatabi gaako yabikola bumu n’ekikondo ky’ettaala mu zaabu omuweese omuka nga biri wamu. ");
INSERT INTO lug_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ekikondo ky’ettaala n’akikolera ettaala musanvu, ne makansi ezikomola entambi, n’essowaani ez’okussaako ebisirinza, nga byonna abikoze mu zaabu omuka. ");
INSERT INTO lug_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ekikondo ky’ettaala ne byonna ebigenderako yabikola mu zaabu omuka eyaweza obuzito bwa kilo amakumi asatu mu nnya. ");
INSERT INTO lug_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Yakola ekyoto, mu miti gy’akasiya, okwoterezangako obubaane, nga kyenkanankana sentimita amakumi ana mu ttaano buli ludda mu buwanvu ne mu bugazi; n’obugulumivu bwa sentimita kyenda; n’amayembe gaakyo nga gali mu muti gumu nakyo. ");
INSERT INTO lug_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ekyoto yakisiigako zaabu omuka kyonna, waggulu ne mu mbiriizi ne ku mayembe, n’akolerako omuge ogwa zaabu okukyebungulula. ");
INSERT INTO lug_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Wansi w’omuge mu mbiriizi z’ekyoto zombi, yakolerako empeta bbiri eza zaabu, okuyisangamu emisituliro gyakyo nga wabaddewo gye kitwalibwa. ");
INSERT INTO lug_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Emisituliro yagikola mu muti gwa akasiya, n’agisiigako zaabu. ");
INSERT INTO lug_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","N’atabula amafuta amatukuvu ag’okwawula, n’ateekateeka obubaane obulongosebbwa ennyo, ng’abutabudde bulungi ng’omukugu mu byakaloosa bwe yandikoze. ");
INSERT INTO lug_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Yazimba ekyoto eky’ekiweebwayo ekyokebwa mu miti gy’akasiya, mita emu ne desimoolo ssatu obugulumivu, ne mita bbiri ne desimoolo ssatu obuwanvu, ate obugazi mita bbiri ne desimoolo ssatu. ");
INSERT INTO lug_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ku nsonda zaakyo ennya yakolerako amayembe; ng’ekyoto n’amayembe yabibajja bumu mu nduli y’omuti emu. Ekyoto kyonna n’alyoka akibikkako ekikomo. ");
INSERT INTO lug_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ate n’akola eby’okukozesa ku kyoto: ensaka, n’ebisena evvu, n’ebbensani, n’ewuuma z’ennyama, ne fulampeni. Ebyo byonna yabikola mu kikomo. ");
INSERT INTO lug_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ekyoto yakikolera ekitindiro eky’obutimba obw’ekikomo, n’akireebeeseza ku mukiikiro gw’ekyoto, n’akissa mu kyoto okutuuka mu makkati gaakyo. ");
INSERT INTO lug_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","N’akola empeta nnya ku nsonda ennya ez’ekitindiro ky’ekikomo nga ze z’okuwanirira emisituliro. ");
INSERT INTO lug_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Emisituliro gino yagibajja mu muti gwa akasiya, n’agibikkako ekikomo. ");
INSERT INTO lug_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","N’asonseka emisituliro egyo ng’agiyisa mu mpeta mu mbiriizi z’ekyoto, gikozesebwenga ng’ekyoto kisitulwa. Yakikola n’embaawo nga wakati kya muwulukwa. ");
INSERT INTO lug_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","N’akola ebbensani ey’ekikomo n’akameeza kaayo, bye yaweesa okuva mu ndabirwamu ez’ekikomo ezaagabwa abakazi abaaweerezanga ku mulyango gw’Eweema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ekyaddirira, yakola oluggya. Ku luuyi olw’obukiikaddyo, oluggya lwali obuwanvu mita amakumi ana mu mukaaga, nga lulina amagigi aga linena omulungi omulebevu alangiddwa, ");
INSERT INTO lug_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","n’ebikondo amakumi abiri, n’entobo mwe bituula ez’ekikomo amakumi abiri, nga kuliko amalobo aga ffeeza n’emikiikiro egya ffeeza. ");
INSERT INTO lug_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ne ku luuyi olw’obukiikakkono oluggya lwali obuwanvu mita ana mu mukaaga, n’ebikondo amakumi abiri, n’ebikolo byabyo mwe bituula eby’ekikomo amakumi abiri, nga ku bikondo kuliko amalobo aga ffeeza n’emikiikiro gyako gyali gya ffeeza. ");
INSERT INTO lug_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ku luuyi olw’ebugwanjuba oluggya lwali lwa mita amakumi abiri mu bbiri, ne desimoolo ttaano nga luliko entimbe, n’ebikondo kkumi, n’entobo kkumi; n’amalobo n’emikiikiro nga bya ffeeza. ");
INSERT INTO lug_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ne ku luuyi olw’ebuvanjuba oluggya lwali obugazi mita amakumi abiri mu bbiri n’obutundu butaano. ");
INSERT INTO lug_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ku ludda olumu olw’omulyango kwaliko amagigi obuwanvu mita mukaaga n’obutundu munaana, n’ebikondo bisatu n’entobo zaabyo ssatu. ");
INSERT INTO lug_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ne ku ludda olulala olw’omulyango nakwo kwaliko entimbe obuwanvu mita mukaaga n’obutundu munaana, era n’ebikondo bisatu n’entobo zaabyo ssatu. ");
INSERT INTO lug_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Entimbe zonna okwebungulula oluggya zaali za linena omulungi omulebevu alangiddwa. ");
INSERT INTO lug_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Entobo z’ebikondo zaali za kikomo, naye amalobo n’emikiikiro gyako nga bya ffeeza, ne ku mitwe gyabyo nga kubikkiddwako ffeeza; bwe bityo ebikondo byonna eby’omu luggya byaliko emikiikiro gya ffeeza. ");
INSERT INTO lug_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Olutimbe olw’omu mulyango gw’oluggya lwakolebwa mu linena omulungi omulebevu alangiddwa obulungi, nga lutungiddwamu amajjolobera mu wuzi eza bbululu, ne kakobe ne myufu. Lwali luweza obuwanvu mita mwenda n’obugulumivu mita bbiri n’obutundu busatu, ng’entimbe ez’oluggya bwe zaali. ");
INSERT INTO lug_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Lwalina empagi nnya, n’entobo zaazo nnya nga za kikomo, n’amalobo gaazo n’emikiikiro nga bya ffeeza, ne kungulu kwonna ne kubikkibwako ffeeza. ");
INSERT INTO lug_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Enkondo zonna ez’Eweema n’okwebungulula oluggya zaali za kikomo. ");
INSERT INTO lug_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Bino bye bintu byonna ebyakozesebwa ku Weema, Eweema ya Mukama ey’Obujulizi, nga Musa bwe yalagira okubibala bikozesebwe Abaleevi nga balabirirwa Isamaali mutabani wa Alooni kabona. ");
INSERT INTO lug_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaaleeri, mutabani wa Uli muzzukulu wa Kuuli, ow’omu kika kya Yuda, n’akola ebyo byonna Mukama bye yalagira Musa; ");
INSERT INTO lug_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","baakolera wamu ne Okoliyaabu, mutabani wa Akisamaki ow’omu kika kya Ddaani, eyali omukugu ennyo mu kwola ne mu kutetenkanya, n’okutunga amajjolobera mu linena ennungi endebevu ennange n’ewuzi eza bbululu ne kakobe ne myufu. ");
INSERT INTO lug_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Zaabu yenna eyali aweereddwayo eri Mukama, eyakozesebwa mu kuzimba ekifo ekitukuvu, yali nga ttani emu, ng’okupima kw’Awatukuvu okutongole bwe kuli. ");
INSERT INTO lug_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ne ffeeza eyaweebwayo abaabalibwa nga bava mu kibiina mu kubala abantu, yali wa kilo enkumi ssatu mu ebikumi bina, ng’okupima kw’Awatukuvu okutongole bwe kuli. ");
INSERT INTO lug_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Noolwekyo, buli muntu yawangayo gulaamu ttaano ne desimoolo ttaano ng’okupima kw’Awatukuvu okutongole bwe kuli ng’aweebwayo abo abaabalibwa nga bava ku myaka egy’obukulu amakumi abiri n’okweyongerayo, bonna baawera abasajja obusiriivu mukaaga mu enkumi ssatu mu bitaano mu ataano. ");
INSERT INTO lug_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ffeeza ow’obuzito bwa kilo enkumi ssatu mu ebikumi bina ye yasaanuusibwa okukolamu entobo ekikumi ez’Awatukuvu n’eggigi: noolwekyo, nga buli kilo amakumi asatu mu nnya zikola entobo emu. ");
INSERT INTO lug_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Kilo amakumi asatu ezaasigalawo zaakolwamu amalobo ag’oku bikondo n’emikiikiro gyabyo, n’okubikka ku mitwe gy’ebikondo. ");
INSERT INTO lug_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ekikomo ekyaweebwayo eri Mukama olw’ekiweebwayo ekiwuubibwa kyali kilo enkumi bbiri mu ebikumi bina. ");
INSERT INTO lug_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Omwo Bezaaleeri mwe yakola ekituurwamu eky’omulyango gw’Eweema ey’Okukuŋŋaanirangamu, n’ekyoto eky’ekikomo, n’ekitindiro eky’obutimba eky’ekikomo, n’ebikozesebwa ebirala byonna eby’ekyoto, ");
INSERT INTO lug_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","n’ekituurwamu okwebungulula oluggya, n’ekituurwamu eky’omulyango omunene ogw’oluggya, n’enkondo zonna ez’Eweema, n’enkondo zonna okwebungulula oluggya. ");
INSERT INTO lug_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Awo ne bakola, mu wuzi eza bbululu; ne kakobe ne myufu, ebyambalo ebirukiddwa obulungi eby’okuweererezangamu mu Kifo Ekitukuvu. Ne bakolera ne Alooni ebyambalo ebitukuvu, nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Awo ne bakola ekkanzu ey’obwakabona eyitibwa efodi mu wuzi eza zaabu, ne bbululu, ne kakobe ne myufu, ne linena omulebevu omulange. ");
INSERT INTO lug_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ne baweesa zaabu ey’oluwewere, ne bagisala obulere ne babukozesa awamu n’ewuzi eza bbululu, ne kakobe, ne myufu ne linena omulebevu omulungi omulange, nga bikoleddwa mu majjolobera agakoleddwa n’obukugu. ");
INSERT INTO lug_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ekkanzu ey’obwakabona eyitibwa efodi ne bagikolera eby’okubibegabega bibiri nga bitungiddwa w’ekoma, n’egattibwa bulungi. ");
INSERT INTO lug_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ne bakola omusipi gwayo n’amagezi mangi ng’agaakola ekkanzu ey’obwakabona, n’ebyakozesebwa nga bye bimu. Ewuzi nga za zaabu, ne bbululu, ne kakobe, ne myufu, ne linena omulebevu alangiddwa; nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ne baddira amayinja ga onuku ne bagakwasiza mu mapeesa aga zaabu, ng’amayinja gawandiikiddwako, ng’empeta bw’ewandiikwako, amannya g’abaana ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ne bagakwasiza ku byokubibegabega eby’ekkanzu ey’obwakabona eyitibwa efodi, okubeeranga amayinja g’ekijjukizo ky’abaana ba Isirayiri; nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ne bakola ekyomukifuba, nga mulimu gwa kikugu ng’ogw’ekkanzu ey’obwakabona eyitibwa efodi, mu wuzi za zaabu, ne bbululu, ne kakobe ne myufu ne linena omulebevu omulange. ");
INSERT INTO lug_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kyali kyenkanankana, buli ludda sentimita amakumi abiri mu bbiri ne desimoolo ttaano nga kimaze okuwetebwamu wakati. ");
INSERT INTO lug_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ne batungirako ennyiriri nnya ez’amayinja ag’omuwendo omungi. Mu lunyiriri olusooka bassaamu amayinja: sadiyo, ne topazi, ne kaabankulo; ");
INSERT INTO lug_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ne mu lunyiriri olwokubiri bassaamu amayinja: nnawandagala, ne safiro ne alimaasi; ");
INSERT INTO lug_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ne mu lunyiriri olwokusatu bassaamu amayinja: jasinta, ne ageti, ne amesusito; ");
INSERT INTO lug_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ne mu lunyiriri olwokuna bassaamu amayinja: berulo, ne onuku, ne yasipero; ne gategekebwa mu fuleemu eya zaabu. ");
INSERT INTO lug_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Waaliwo amayinja ag’omuwendo kkumi n’abiri, nga ku buli limu kusaliddwako erimu ku mannya g’abaana ba Isirayiri. Gaasalibwa bulungi ng’obubonero obuwoolebwa nga ku buli limu kuliko erinnya lyako okumalirayo ddala amannya g’ebika ekkumi n’ebibiri. ");
INSERT INTO lug_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ku kyomukifuba baakolerako enjegere ennange ng’emiguwa, nga za zaabu omuka; ");
INSERT INTO lug_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ne bakola fuleemu bbiri eza zaabu n’empeta bbiri eza zaabu; ne bassa empeta ezo zombi ku mikugiro ebiri egy’ekyomu kifuba. ");
INSERT INTO lug_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ne bayisa enjegere ebbiri mu mpeta ebbiri ezaali ku mikugiro gy’eky’omu kifuba. ");
INSERT INTO lug_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ne baddira enjuuyi ebbiri ezaasigalawo ez’enjegere ne bazikwasiza ku fuleemu ebbiri, ne bazinywereza mu maaso g’eby’okubibegabega byombi eby’ekkanzu ey’obwakabona eya efodi. ");
INSERT INTO lug_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Era baakola empeta bbiri eza zaabu ne bazitunga ku mikugiro ebiri egy’ekyomu kifuba ku luuyi olw’omunda olwali luliraanye ekkanzu ey’obwakabona eya efodi. ");
INSERT INTO lug_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ne bakolayo empeta endala bbiri eza zaabu ne baziteeka mu maaso mu bitundu byombi ebya wansi eby’eby’okubibegabega eby’ekkanzu ey’obwakabona eya efodi, wagguluko okumpi n’oluzizi lw’omusipi lw’ekkanzu ey’obwakabona eya efodi. ");
INSERT INTO lug_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Baasiba empeta ez’oku kyomukifuba wamu n’empeta z’ekkanzu ey’obwakabona eya efodi n’akaguwa aka bbululu, ne bakagatta n’omusipi ekyomukifuba kireme kutaggulukuka ku kkanzu ey’obwakabona eya efodi. Byakolebwa nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Baakola ekyambalo eky’omunda mu kkanzu ey’obwakabona eya efodi, nga kiruke era nga kya bbululu kyonna. ");
INSERT INTO lug_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ne bassa ekituli wakati mu kyambalo omw’okuyisa omutwe. Ku kituli ekyo ne beetooloozaako omuge omuyonde ng’omuleera kireme okuyulika. ");
INSERT INTO lug_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Okwetooloola ebirenge by’ekyambalo ekyo wansi ne batungayo amajjolobera mu wuzi eza bbululu, ne kakobe, ne myufu, ne linena omulebevu omulange obulungi. ");
INSERT INTO lug_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Era ne bakola n’obude obwa zaabu omuka, ne bagenda nga babutobeka mu majjolobera; ");
INSERT INTO lug_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","baatunga amajjolobera ne baddirizaako akade, ate ne batunga amajjolobera ne baddirizaako akade, okwetooloola ebirenge by’ekyambalo ekyo eky’okuweererezangamu; nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Era ne bakolera Alooni n’abaana be amakooti agaalukibwa mu wuzi eza linena omulebevu omulungi. ");
INSERT INTO lug_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Ne bakola n’ekitambaala eky’oku mutwe mu linena omulebevu omulungi, era n’enkuufiira ne bazikola mu linena omulebevu omulungi; ne bakola n’empale mu linena omulebevu omulungi omulange, ");
INSERT INTO lug_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","n’omusipi mu linena omulebevu omulungi omulange ow’ewuzi eza bbululu, ne kakobe ne myufu nga zitungiddwa ng’omudalizo n’amagezi mangi; nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Era ne bakola akapande ak’engule entukuvu mu zaabu omuka, ne bayolako ebigambo, nga bw’owandiika ku kabonero, nti: Mutukuvu wa Mukama. ");
INSERT INTO lug_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ne bakasibako akakoba akatunge obulungi aka bbululu, kakanywerezenga waggulu ku kitambaala ky’oku mutwe; nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Bwe gutyo omulimu gwonna ogw’okukola Eweema ya Mukama, Eweema ey’Okukuŋŋaanirangamu ne guggwa; ng’abaana ba Isirayiri bakoze ebyo byonna nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Awo Weema ya Mukama ne bagireetera Musa; Eweema yonna ne byonna ebyali bigirimu: ebisiba byayo, n’embaawo, n’emikiikiro, n’empagi zaayo, n’ebituurwamu; ");
INSERT INTO lug_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ekibikkako eky’amaliba g’endiga amakunye amannyike mu langi emyufu, n’amaliba g’embuzi amakunye, n’eggigi ery’okutimba; ");
INSERT INTO lug_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","essanduuko ey’Endagaano n’emisituliro gyayo n’ekisaanikira, ye ntebe ey’okusaasira; ");
INSERT INTO lug_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","emmeeza ne byonna ebigibeerako, n’emigaati egy’Okulaga; ");
INSERT INTO lug_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ekikondo ky’ettaala ekya zaabu omuka, n’ettaala zaako n’ebigenderako ebikozesebwa, n’amafuta gaazo; ");
INSERT INTO lug_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ekyoto ekya zaabu, amafuta ag’okwawula n’obubaane obw’akawoowo, n’olutimbe olw’omulyango oguyingira mu Weema; ");
INSERT INTO lug_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ekyoto eky’ekikomo n’ekitindiro kyakyo eky’ekikomo, emisituliro gyakyo ne byonna ebikozesebwako; ebbensani ne ky’etuulamu; ");
INSERT INTO lug_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","entimbe ez’oku bisenge, eby’omu luggya n’empagi zaazo ne mwe zituula, n’olutimbe olw’omu mulyango ogulaga mu luggya, emiguwa gyalwo n’enkondo zaalwo; ne byonna ebikozesebwa olw’emirimu gy’omu Weema ya Mukama, Eweema ey’Okukuŋŋaanirangamu; ");
INSERT INTO lug_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ebyambalo ebiruke obulungi ebyambalwa mu kuweereza mu Kifo Ekitukuvu, ebyambalo ebitukuvu ebya Alooni kabona, n’ebyambalo bya batabani be bye bakozesa mu bwakabona nga baweereza. ");
INSERT INTO lug_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Nga Mukama bwe yalagira Musa mu byonna, bwe batyo abaana ba Isirayiri omulimu gwonna bwe baagukola. ");
INSERT INTO lug_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Awo Musa n’akebera omulimu gwonna, era n’alaba nga bagumalirizza. Nga Mukama bwe yalagira, nabo bwe batyo bwe baagukola. Awo Musa n’abasabira omukisa. ");
INSERT INTO lug_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ku lunaku olw’olubereberye olw’omwezi ogw’olubereberye kw’olisimbira Eweema ya Mukama, Eweema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Essanduuko ey’Endagaano oligiyingiza mu Weema; Essanduuko n’olyoka ogisiikiriza n’eggigi. ");
INSERT INTO lug_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Oliyingiza emmeeza, n’otegeka bulungi byonna ebigikolerwako. Oliyingiza ekikondo ky’ettaala era n’otegekako ettaala zaakwo n’ozikoleeza. ");
INSERT INTO lug_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Era oliteeka ekyoto ekya zaabu eky’okwoterezangako obubaane mu maaso g’Essanduuko ey’Endagaano, n’ossaawo olutimbe mu mulyango gw’Eweema ya Mukama. ");
INSERT INTO lug_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Ekyoto eky’ekiweebwayo ekyokebwa olikissa mu maaso g’omulyango ogwa Weema ya Mukama, Weema ey’Okukuŋŋaanirangamu, ");
INSERT INTO lug_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","olyoke oteeke ebbensani wakati wa Weema ey’Okukuŋŋaanirangamu n’ekyoto, mu bbensani oteekemu amazzi. ");
INSERT INTO lug_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Olikola oluggya okwebungulula Weema ya Mukama, n’ossaawo olutimbe mu mulyango oguyingira mu luggya. ");
INSERT INTO lug_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Oliddira amafuta ag’okwawula n’ogamansa ku Weema ya Mukama ne byonna ebigirimu, olyoke oyawule Eweema ya Mukama n’ebigirimu byonna, ebeere ntukuvu. ");
INSERT INTO lug_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Olimansira amafuta ku kyoto eky’ebiweebwayo ebyokebwa n’ebikozesebwako byonna, n’oyawula ekyoto, bwe kityo ekyoto kiribeera kitukuvu nnyo. ");
INSERT INTO lug_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Era n’ebbensani oligimansirako amafuta, ne kw’etuula, n’ogyawula, n’ogitukuza. ");
INSERT INTO lug_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Olireeta Alooni ne batabani be ku mulyango gw’Eweema ey’Okukuŋŋaanirangamu, n’obanaaza n’amazzi, ");
INSERT INTO lug_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","n’oyambaza Alooni ebyambalo ebitukuvu n’omusiigako amafuta n’omwawula, alyoke ampeereze nga kabona. ");
INSERT INTO lug_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Olireeta ne batabani be n’obambaza ekkanzu ey’obwakabona, ");
INSERT INTO lug_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","n’obasiigako amafuta, nga bwe wasiize ku kitaabwe, balyoke bampeereze nga bakabona: era okusiigibwako amafuta okwo kulibafuula bakabona ebbanga lyonna mu mirembe gyabwe.” ");
INSERT INTO lug_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa bw’atyo n’akola ebyo byonna nga Mukama bwe yamulagira. ");
INSERT INTO lug_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Awo ku lunaku olusooka mu mwezi ogw’olubereberye, mu mwaka ogwokubiri, Eweema ya Mukama n’esimbibwa. ");
INSERT INTO lug_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa n’asimba Eweema ya Mukama; n’ateekateeka ebya wansi mw’etuula, n’ategeka olukangaga lwayo, n’asimba empagi zaayo; ");
INSERT INTO lug_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","n’assaako ekibikka ku Weema ya Mukama, nga Mukama bwe yamulagira. ");
INSERT INTO lug_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","N’addira Endagaano, ey’ebipande eby’amayinja okwasalibwa Amateeka Ekkumi, n’agiteeka munda mu Ssanduuko ey’Endagaano, n’assa emisituliro ku Ssanduuko ey’Endagaano, n’assaako kungulu ekisaanikira, ye ntebe ey’okusaasira; ");
INSERT INTO lug_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","n’ayingiza Essanduuko ey’Endagaano munda mu Weema ya Mukama, n’atimbawo eggigi, n’asiikiriza Essanduuko ey’Endagaano, nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","N’ayingiza emmeeza mu Weema ey’Okukuŋŋaanirangamu, n’agiteeka ku ludda olw’Obukiikakkono olwa Weema ya Mukama, wabweru w’eggigi, ");
INSERT INTO lug_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","n’assaako emigaati ng’agitegese bulungi awali Mukama, nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","N’assa ekikondo ky’ettaala mu Weema ey’Okukuŋŋaanirangamu ku ludda olw’Obukiikaddyo obw’Eweema ya Mukama, okwolekera emmeeza, ");
INSERT INTO lug_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","n’ategeka ettaala awali Mukama, nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","N’ayingiza ekyoto ekya zaabu mu Weema ey’Okukuŋŋaanirangamu mu maaso g’eggigi, ");
INSERT INTO lug_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","n’ayokerako obubaane obwa kawoowo, nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","N’ateeka olutimbe olw’omu mulyango gw’Eweema ya Mukama mu kifo kyalwo. ");
INSERT INTO lug_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","N’ateeka ekyoto eky’ebiweebwayo ebyokebwa ku mulyango gw’Eweema ya Mukama, Weema ey’Okukuŋŋaanirangamu, n’aweerayo okwo ekiweebwayo ekyokebwa eky’obuwunga, nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","N’atereeza ebbensani wakati wa Weema ey’Okukuŋŋaanirangamu n’ekyoto, n’assaamu amazzi ag’okunaaba; ");
INSERT INTO lug_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa ne Alooni ne batabani ba Alooni mwe baanaabiranga engalo zaabwe n’ebigere byabwe. ");
INSERT INTO lug_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Buli lwe baayingiranga mu Weema ey’Okukuŋŋaanirangamu, ne buli lwe baasembereranga ekyoto nga banaaba, nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","N’akola oluggya okwebungulula Weema ya Mukama n’ekyoto, n’assaawo olutimbe mu mulyango oguyingira mu luggya. Bw’atyo Musa omulimu n’agumaliriza. ");
INSERT INTO lug_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Awo ekire ne kibuutikira Eweema ey’Okukuŋŋaanirangamu, yonna n’ejjula ekitiibwa kya Mukama. ");
INSERT INTO lug_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa n’atasobola kuyingira mu Weema ey’Okukuŋŋaanirangamu, kubanga ekire kyagibuutikira, n’ekitiibwa kya Mukama ne kijijjula. ");
INSERT INTO lug_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Mu lugendo lwabwe lwonna, ekire bwe kyaggyibwanga ku Weema ya Mukama, olwo abaana ba Isirayiri nga basitula nga batambula; ");
INSERT INTO lug_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","naye ekire bwe kitaggyibwangako ku Weema ya Mukama, olwo nga tebasitula kutambula okutuusa ku lunaku lwe kyaggyibwangako. ");
INSERT INTO lug_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ekire kya Mukama kyabeeranga ku Weema ya Mukama emisana, ate ekiro nga mu kire ekyo mubaamu muliro, ng’abaana ba Isirayiri bonna ebyo babiraba mu lugendo lwabwe lwonna.");
INSERT INTO lug_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Awo Mukama n’ayita Musa, n’ayogera naye ng’asinziira mu Weema ey’Okukuŋŋaanirangamu. N’amulagira nti, ");
INSERT INTO lug_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Yogera n’abaana ba Isirayiri obagambe nti, ‘Omuntu yenna mu mmwe bw’aneeteesanga okuleeta ekiweebwayo eri Mukama, anaaleetanga ekiweebwayo kya nte ng’agiggya mu kiraalo kye, oba endiga oba embuzi ng’agiggya mu kisibo kye.’ ");
INSERT INTO lug_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Ekiweebwayo bwe kinaabanga ekiweebwayo ekyokebwa nga kiva mu kiraalo ky’ente, anaawangayo seddume etaliiko kamogo. Anaagyereeteranga n’agiweerayo ku mulyango gwa Weema ya Mukama ey’Okukuŋŋaanirangamu, kiryoke kikkirizibwe eri Mukama. ");
INSERT INTO lug_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Omuntu aleese ekiweebwayo ekyo ekyokebwa anaakwatanga omutwe gwakyo, era kinakkirizibwanga ku lulwe kiryoke kimutangiririre olw’ebibi bye. ");
INSERT INTO lug_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Seddume eyo anaagittiranga mu maaso ga Mukama; era batabani ba Alooni, bakabona, banaddiranga omusaayi gwayo ne baguwaayo eri Mukama nga bagumansira ku kyoto okwebungulula enjuuyi zonna ez’ekyoto ekiri awo okumpi n’omulyango gwa Weema ya Mukama ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Awo ekiweebwayo ekyo ekyokebwa anaakibaagangako eddiba, n’akitemaatemamu ebifi. ");
INSERT INTO lug_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Batabani ba Alooni, kabona, banaakumanga omuliro mu kyoto, ne batindikira bulungi enku ku muliro ogwo. ");
INSERT INTO lug_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Awo batabani ba Alooni, bakabona, banaategekanga bulungi ebifi ebyo, nga n’omutwe n’amasavu babitaddeko; banaabissanga ku nku ezikoledde omuliro ku kyoto. ");
INSERT INTO lug_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Eyaleese ekiweebwayo ekyo anaanaazanga n’amazzi eby’omu lubuto n’amagulu; ebyo byonna kabona anaabyokyanga ku kyoto ng’ekiweebwayo ekyokebwa, ekyokeddwa mu muliro ne kivaamu evvumbe eddungi erisanyusa Mukama. ");
INSERT INTO lug_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Ekinaaleetebwanga okuba ekiweebwayo ekyokebwa bwe kinaavanga mu kisibo, oba ndiga oba mbuzi, omuntu oyo anaawangayo ennume etaliiko kamogo. ");
INSERT INTO lug_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Anaagittiranga ku luuyi olwakkono olw’ekyoto mu maaso ga Mukama, era batabani ba Alooni, bakabona, banaamansiranga omusaayi gwayo ku njuyi zonna ez’ekyoto okukyebungulula. ");
INSERT INTO lug_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Anaagitemaatemangamu ebifi; era kabona anaategekanga bulungi ebifi ebyo, nga n’omutwe n’amasavu abitaddeko, n’abissa ku nku ezikoledde omuliro ku kyoto. ");
INSERT INTO lug_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Eyaleese ekiweebwayo ekyo anaanaazanga n’amazzi eby’omu lubuto n’amagulu; ebyo byonna kabona anaabiwangayo, n’abyokya ku kyoto, nga kye kiweebwayo ekyokebwa ekyokeddwa mu muliro, ne kivaamu evvumbe eddungi erisanyusa Mukama. ");
INSERT INTO lug_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Ekiweebwayo ekyokebwa eri Mukama bwe kinaabanga eky’ennyonyi, omuntu anaaleetanga ekiweebwayo eky’amayiba oba eky’enjiibwa ento. ");
INSERT INTO lug_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kabona anaaleetanga ennyonyi eyo ku kyoto n’aginyoola omutwe n’agukutulako, n’agwokya ku kyoto; omusaayi gwayo anaagukenenuliranga mu mbiriizi z’ekyoto. ");
INSERT INTO lug_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Anaagiggyangamu ekisakiro kyayo n’ebikirimu, n’akisuula ku ludda olw’ebuvanjuba olw’ekyoto mu kifo awayiyibwa evvu. ");
INSERT INTO lug_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Anaagikwatanga ebiwaawaatiro n’agiyuza; kyokka taagiryebulirengamu ddala. Anaagyokeranga ku nku ezikoledde omuliro mu kyoto; nga kye kiweebwayo ekyokebwa ekyokeddwa mu muliro ne kivaamu evvumbe eddungi erisanyusa Mukama. ");
INSERT INTO lug_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Omuntu yenna bw’anaaleetanga eri Mukama ekiweebwayo eky’emmere ey’empeke; empeke anaamalanga kuzisa, n’aleeta obuwunga obulungi. Anaabufukangako amafuta ag’omuzeeyituuni, n’ateekako n’obubaane, ");
INSERT INTO lug_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","n’alyoka abuleetera batabani ba Alooni, bakabona. Kabona anaayoolanga olubatu lw’obuwunga obulimu amafuta ag’omuzeeyituuni n’obubaane, n’abwokya mu kyoto ng’ekijjukizo, nga kye kiweebwayo ekyokeddwa mu muliro ne kivaamu evvumbe eddungi erisanyusa Mukama. ");
INSERT INTO lug_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Obuwunga obunaasigalangawo ku kiweebwayo, bunaatwalibwanga Alooni ne batabani be, nga kye kitundu ekitukuvu ennyo eky’ekiweebwayo eri Mukama ekyokeddwa mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Bw’onooleetanga emigaati egifumbiddwa mu oveni nga kye kiweebwayo, ginaabanga emigaati egikoleddwa mu buwunga obulungi nga mutabuddwamu n’amafuta ag’omuzeeyituuni nga tegiriimu kizimbulukusa, oba bunaabanga obusukuuti obw’oluwewere obutaliimu kizimbulukusa nga busiigiddwako amafuta ag’omuzeeyituuni. ");
INSERT INTO lug_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ekiweebwayo kyo bwe kinaabanga eky’emmere ey’empeke nga kitegekeddwa ku lukalango, kinaakolebwanga mu buwunga obulungi obutaliimu kizimbulukusa nga butabuddwamu amafuta ag’omuzeeyituuni. ");
INSERT INTO lug_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Onookimenyaamenyanga mu butundutundu, n’okifukako amafuta ag’omuzeeyituuni. Ekyo kye kiweebwayo eky’emmere ey’empeke. ");
INSERT INTO lug_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ekiweebwayo kyo bwe kinaabanga eky’emmere ey’empeke nga kyakufumbirwa mu fulampeni, kinaateekebwateekebwanga mu buwunga obulungi n’amafuta ag’omuzeeyituuni. ");
INSERT INTO lug_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Onooleeteranga Mukama ekiweebwayo ekyo eky’emmere ey’empeke ekitabuddwa mu bintu ebyo; bwe kinaakwasibwanga kabona, ye anaakireetanga ku kyoto. ");
INSERT INTO lug_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Awo kabona anaggyanga ku kiweebwayo eky’emmere ey’empeke, ekitundu eky’ekijjukizo kyakyo, n’akyokya ku kyoto, nga kye kiweebwayo ekyokeddwa mu muliro ne kivaamu evvumbe eddungi erisanyusa Mukama. ");
INSERT INTO lug_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Era ekinaafikkanga ku kiweebwayo eky’emmere ey’empeke, Alooni ne batabani be, be banaakitwalanga; nga kye kitundu ekitukuvu ennyo ekibalirwa ku biweebwayo eri Mukama ekyokeddwa mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Temuleeteranga Mukama ekiweebwayo eky’emmere ey’empeke nga kiteekeddwamu n’ekizimbulukusa; kubanga temuuyokyenga kizimbulukusa wadde omubisi gw’enjuki ng’ekiweebwayo eri Mukama ekyokeddwa mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Munaabireetanga eri Mukama ng’ebiweebwayo eby’ebibala ebibereberye, naye tebiiweerwengayo ku kyoto okubeera evvumbe eddungi erisanyusa Mukama. ");
INSERT INTO lug_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ebiweebwayo byo byonna eby’emmere ey’empeke onoobirungangamu omunnyo: tokkirizanga munnyo ogw’endagaano ne Katonda wo okubula mu biweebwayo byo eby’emmere ey’empeke; mu biweebwayo byo byonna ossangamu omunnyo. ");
INSERT INTO lug_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Bw’onooleetanga eri Mukama ebiweebwayo eby’ebibala ebibereberye eby’emmere ey’empeke, binaabanga ebirimba ebibisi ebibereberye eby’emmere ey’empeke nga bibetenteddwa era nga byokeddwako mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Onoobifukangako amafuta ag’omuzeeyituuni, n’obiteekangako n’obubaane; ekyo nga kye kiweebwayo eky’emmere ey’empeke. ");
INSERT INTO lug_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Awo kabona anaggyanga ku kiweebwayo eky’emmere ey’empeke, ekimaze okubetentebwa nga mulimu amafuta ag’omuzeeyituuni n’obubaane, ekitundu eky’ekijjukizo kyakyo, n’akyokya; ekyo nga kye kiweebwayo eri Mukama ekyokeddwa mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Omuntu bw’anaaleetanga ekiweebwayo olw’emirembe eri Mukama, ekiweebwayo ekyo nga kya nte nnume oba nkazi gy’aggye mu kiraalo kye, ente eyo tebeerengako kamogo. ");
INSERT INTO lug_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Omuntu aleese ekiweebwayo ekyo anaakwatanga omutwe gwakyo n’akittira ku mulyango gwa Weema ey’Okukuŋŋaanirangamu; batabani ba Alooni, bakabona, ne balyoka bamansira omusaayi ku kyoto okukyebungulula. ");
INSERT INTO lug_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Omu ku bakabona anaggyanga ebintu bino mu kiweebwayo olw’emirembe ekireeteddwa nga kyokeddwa mu muliro, nga kye kiweebwayo eri Mukama; anaawangayo amasavu agabikka ku byenda, n’amasavu gonna agali okumpi n’ebyenda, ");
INSERT INTO lug_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","n’ensigo zombi awamu n’amasavu agaziriko okuliraana ekiwato, n’ekibikka ku kibumba nga biggyibwako wamu n’ensigo. ");
INSERT INTO lug_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Kale batabani ba Alooni banaabyokeranga kungulu ku kiweebwayo ekyokebwa ekiri ku nku eziri ku muliro ne kivaamu evvumbe eddungi erisanyusa Mukama. ");
INSERT INTO lug_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Omuntu anaggyanga mu kisibo kye ekisolo ekisajja oba ekikazi nga tekiriiko kamogo, n’akiwaayo eri Mukama. ");
INSERT INTO lug_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Bw’anaaleetanga endiga ento nga kye kiweebwayo kye eri Mukama, ");
INSERT INTO lug_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","anaagikwatanga omutwe gwayo, n’agittira mu maaso ga Weema ey’Okukuŋŋaanirangamu. Kale batabani ba Alooni banaamansiranga omusaayi gwayo ku kyoto n’okukyebunguluza. ");
INSERT INTO lug_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Mu kiweebwayo olw’emirembe ky’anaaleetanga okuwaayo ng’ekiweebwayo eri Mukama nga kyokebwa mu muliro, anaggyangamu bino n’abiwaayo eri Mukama: anaawangayo amasavu n’omukira gwonna n’amasavu gaagwo, nga gusaliddwako okumpi n’omugongo, n’amasavu agabikka ku byenda, n’amasavu gonna agali okumpi n’ebyenda, ");
INSERT INTO lug_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","n’ensigo zombi awamu n’amasavu agaziriko okuliraana ekiwato, n’ekibikka ku kibumba, nga biggyibwako wamu n’ensigo. ");
INSERT INTO lug_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Awo kabona anaabyokeranga ku kyoto okubeera ekyokulya ekiweebwayo eri Mukama nga kyokeddwa mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Ekiweebwayo kye bwe kinaabanga embuzi, anaagiwangayo ng’ekiweebwayo eri Mukama; ");
INSERT INTO lug_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","anaagikwatanga omutwe gwayo, n’agittira mu maaso ga Weema ey’Okukuŋŋaanirangamu. Kale batabani ba Alooni banaamansiranga omusaayi gwayo ku kyoto n’okukyebunguluza. ");
INSERT INTO lug_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Awo anaawangayo ekiweebwayo eri Mukama ekyokeddwa mu muliro ng’akiggya okwo: amasavu agabikka ebyenda, n’amasavu gonna agaliraanye ebyenda, ");
INSERT INTO lug_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","n’ensigo zombi n’amasavu agaziriko okuliraana ekiwato, n’ekibikka ku kibumba nga biggyibwako wamu n’ensigo. ");
INSERT INTO lug_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Awo kabona anaabyokeranga ku kyoto okubeera ekyokulya ekiweebwayo nga kyokebwa mu muliro okuvaamu evvumbe eddungi erisanyusa Mukama. Amasavu gonna ganaabanga ga Mukama. ");
INSERT INTO lug_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Ekintu kino kinaabeeranga etteeka ery’ebiro byonna okuyita mu mirembe eginaagendanga giddiriragana mu bifo byonna gye munaabeeranga. Temulyanga masavu wadde omusaayi.’ ” ");
INSERT INTO lug_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Awo Mukama n’ayogera ne Musa n’amugamba nti, ");
INSERT INTO lug_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Tegeeza abaana ba Isirayiri nti: ‘Bino bye biragiro eri buli muntu anaasobyanga ku mateeka ga Mukama nga tagenderedde, n’akola ekintu kyonna Mukama kye yalagira obutakikolanga. ");
INSERT INTO lug_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Singa Kabona eyafukibwako amafuta ag’omuzeeyituuni ayonoona, bw’atyo abantu n’abaleetako omusango olw’ekibi ky’anaabanga akoze, anaaleeteranga Mukama ente ennume entoototo etaliiko kamogo, nga kye kiweebwayo olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Sseddume eyo anaagireetanga ku mulyango gwa Weema ey’Okukuŋŋaanirangamu, mu maaso ga Mukama; anaagikwatanga omutwe gwayo n’agittira awo mu maaso ga Mukama. ");
INSERT INTO lug_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Awo kabona eyafukibwako amafuta ag’omuzeeyituuni anaatoolangako ku musaayi gwa sseddume eyo n’aguleeta mu Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Anannyikanga olugalo lwe mu musaayi ogwo n’agumansirako emirundi musanvu awo eggigi ery’awatukuvu we litunudde mu maaso ga Mukama. ");
INSERT INTO lug_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Awo kabona anaddiranga ku musaayi, n’agusiiga ku mayembe ag’oku kyoto okwoterezebwa obubaane obw’akawoowo, ekiri mu Weema ey’Okukuŋŋaanirangamu mu maaso ga Mukama. Omusaayi gwa sseddume ogunaasigalangawo gwonna, anaaguyiwanga ku ntobo y’ekyoto eky’ebiweebwayo ebyokebwa ekiri ku mulyango gwa Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Amasavu gonna aganaabanga mu sseddume ey’ekiweebwayo olw’ekibi, anaagaggyangako: amasavu agabikka ebyenda, n’amasavu gonna agaliraanye ebyenda, ");
INSERT INTO lug_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","n’ensigo zombi n’amasavu agazirimu okuliraana ekiwato, n’ekibikka ku kibumba ng’abiggyirako wamu n’ensigo, ");
INSERT INTO lug_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","(nga bwe biggyibwa ku nte ey’ekiweebwayo olw’emirembe), bw’atyo kabona anaabyokeranga ku kyoto eky’ebiweebwayo ebyokebwa. ");
INSERT INTO lug_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Naye eddiba lya sseddume eyo n’ennyama yaayo yonna, n’omutwe gwayo, n’amagulu gaayo, n’eby’omu nda byayo nga n’ebyenda kwebiri, awamu n’obusa bwayo, ");
INSERT INTO lug_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ye sseddume yonna, anaagitwalanga wabweru w’olusiisira mu kifo ekiyonjo awayiyibwa evvu ly’ekyoto, anaatindiranga enku n’akuma omuliro n’agyokeranga okwo. ");
INSERT INTO lug_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Ekibiina kyonna eky’Abayisirayiri bwe kinaayonoonanga nga tekigenderedde, ne kikola ekimu ku ebyo Mukama bye yalagira mu mateeka ge obutabikolanga, ekibiina ne bwe kinaabanga tekitegedde nti kisobezza, banaabanga bazzizza omusango. ");
INSERT INTO lug_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Ekibi ekikoleddwa bwe kinaategeerekekanga, ekibiina kinaaleetanga sseddume y’ente entoototo mu maaso ga Weema ey’Okukuŋŋaanirangamu, nga ky’ekiweebwayo olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Abakulembeze b’ekibiina banassanga emikono gyabwe ku mutwe gwa sseddume eyo mu maaso ga Mukama, sseddume eyo n’ettirwa mu maaso ga Mukama. ");
INSERT INTO lug_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Awo kabona eyafukibwako amafuta ag’omuzeeyituuni anaatwalangako ku musaayi gwa sseddume eyo n’aguleeta mu Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Anannyikanga olugalo lwe mu musaayi ogwo n’agumansira emirundi musanvu awo eggigi ly’awatukuvu we litunudde mu maaso ga Mukama. ");
INSERT INTO lug_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Anaddiranga ku musaayi n’agusiiga ku mayembe ag’oku kyoto ekiri mu Weema ey’Okukuŋŋaanirangamu mu maaso ga Mukama. Omusaayi ogunaasigalangawo gwonna anaagufukanga ku ntobo y’ekyoto eky’ebiweebwayo ebyokebwa ekiri ku mulyango gwa Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Anaggyangamu amasavu gaayo gonna n’agookera ku kyoto, ");
INSERT INTO lug_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","n’akola ku sseddume eno nga bwe yakola ku sseddume ey’ekiweebwayo olw’ekibi. Bw’atyo kabona anaatangiririranga abantu bonna mu kibiina, era ne basonyiyibwa. ");
INSERT INTO lug_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Anaafulumyanga sseddume eno ebweru w’olusiisira n’agyokya nga bwe yayokya sseddume eri eyasooka. Kino kye kiweebwayo olw’ekibi ku lw’ekibiina ky’abantu bonna. ");
INSERT INTO lug_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Omufuzi bw’anaayonoonanga nga tagenderedde n’akola ekimu ku ebyo Mukama bye yalagira mu mateeka ge obutabikolanga, anaabanga azzizza omusango. ");
INSERT INTO lug_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Ekibi ekyo ky’akoze bwe kinaamalanga okumutegeezebwa, anaaleetanga ekiweebwayo kye eky’embuzi ensajja etaliiko kamogo. ");
INSERT INTO lug_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Anagikwatanga ku mutwe gwayo, n’agittira awo mu maaso ga Mukama we battira ebiweebwayo ebyokebwa. Ekyo nga kye kiweebwayo olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Awo kabona anaddiranga ku musaayi ogw’ekiweebwayo olw’ekibi, n’olugalo lwe, n’agusiiga ku mayembe ag’oku kyoto eky’ebiweebwayo ebyokebwa. Omusaayi ogunaabanga gusigaddewo gwonna anaaguyiwanga ku ntobo ey’ekyoto eky’ebiweebwayo ebyokebwa. ");
INSERT INTO lug_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Amasavu gaayo gonna anaagookeranga ku kyoto okwo, okufaanana ng’amasavu olw’ekiweebwayo olw’emirembe bwe ganaayokebwanga. Bw’atyo kabona anaatangiririranga omufuzi oyo olw’ekibi kye, n’asonyiyibwa. ");
INSERT INTO lug_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Omuntu yenna owabulijjo bw’anaayonoonanga nga tagenderedde, n’akola ekimu ku ebyo Mukama bye yalagira mu mateeka ge obutabikolanga, anaabanga azzizza omusango. ");
INSERT INTO lug_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Ekibi ekyo ky’akoze bwe kinaamalanga okumutegeezebwa, anaaleetanga ekiweebwayo kye eky’embuzi enkazi etaliiko kamogo, olw’ekibi ekyo ky’akoze. ");
INSERT INTO lug_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Anaakwatanga ku mutwe gw’ekiweebwayo ekyo olw’ekibi, n’akittira awo awattirwa ebiweebwayo ebyokebwa. ");
INSERT INTO lug_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Awo kabona anaddiranga ku musaayi gwakyo n’olugalo lwe n’agusiiga ku mayembe ag’oku kyoto eky’ebiweebwayo ebyokebwa. Omusaayi ogunaabanga gusigaddewo, gwonna anaaguyiwanga ku ntobo ey’ekyoto eky’ebiweebwayo ebyokebwa. ");
INSERT INTO lug_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Amasavu gaakyo anaagaggyangamu nga ag’omu biweebwayo olw’emirembe bwe gaggyibwamu; kabona anaagookeranga ku kyoto ne gavaamu evvumbe eddungi erisanyusa Mukama. Bw’atyo kabona anaatangiririranga omuntu oyo olw’ekibi kye, era omuntu oyo anaasonyiyibwanga. ");
INSERT INTO lug_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Bw’anaabanga aleese endiga ento ng’ekiweebwayo kye olw’ekibi, anaaleetanga nkazi etaliiko kamogo. ");
INSERT INTO lug_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Anaagikwatanga ku mutwe, n’agittira awo awattirwa ebiweebwayo ebyokebwa, nga kye kiweebwayo olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Awo kabona anaddiranga ku musaayi ogw’ekiweebwayo olw’ekibi, n’olugalo lwe, n’agusiiga ku mayembe ag’oku kyoto eky’ebiweebwayo ebyokebwa. Omusaayi ogunaabanga gusigaddewo, gwonna anaaguyiwanga ku ntobo ey’ekyoto eky’ebiweebwayo ebyokebwa. ");
INSERT INTO lug_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Amasavu gaayo anaagaggyangamu nga ag’omu biweebwayo olw’emirembe bwe gaggyibwamu, era kabona anaagookeranga ku kyoto ku biweebwayo eri Mukama ebyokeddwa mu muliro. Bw’atyo kabona anaatangiririranga omuntu oyo olw’ekibi kye, era omuntu oyo anaasonyiyibwanga. ");
INSERT INTO lug_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Omuntu bw’ategyengayo ku kintu ky’amanyi, n’awa obujulirwa ku kintu kye yalaba oba kye yawulira nga kikyamu, anaabanga azzizza omusango. ");
INSERT INTO lug_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Omuntu yenna bw’anaakwatanga ku kintu ekitali kirongoofu, gamba omulambo gw’ensolo ey’omu nsiko etali nnongoofu, oba ku mulambo gw’ente etali nnongoofu, oba ku mirambo gy’ebiramu ebyekulula ebitali birongoofu, ne bw’anaabanga takitegedde, anaabanga afuuse atali mulongoofu, era anaabanga azzizza omusango. ");
INSERT INTO lug_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Oba bw’anaakwatanga ku kintu kyonna ekitali kirongoofu ekivudde mu muntu nga si kirongoofu mu buli ngeri yonna, ne kimufuula atali mulongoofu, ne bw’anaabanga takigenderedde, bw’anaategeranga ky’akoze nga kibi, anaabanga azzizza omusango. ");
INSERT INTO lug_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Omuntu bw’anaayanguyirizanga okulayira okukola ekintu kyonna, oba kirungi oba kibi, ng’amaze galayira nga tafuddeeyo, ne bw’anaabanga takigenderedde, bw’anaategeranga ky’akoze bwe kiri, anaabanga azzizza omusango mu buli ngeri yonna gy’anaabanga alayiddemu. ");
INSERT INTO lug_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Omuntu bw’anazzanga omusango mu kyonna kyonna ku ebyo ebizze byogerwako, anaateekwanga okwatula ekibi ekyo ky’anaabanga akoze, ");
INSERT INTO lug_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","era n’aleeta ekiweebwayo kye olw’omusango eri Mukama olw’ekibi ekyo. Anaaleetanga endiga ento enkazi oba embuzi enkazi ng’abiggya mu kisibo kye, nga kye kiweebwayo olw’ekibi; era kabona anaatangiririranga omuntu oyo olw’ekibi kye. ");
INSERT INTO lug_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Omuntu bw’anaabanga omwavu, nga tasobola kuleeta ndiga nto olw’obwavu bwe, anaaleetanga bukaamukuukulu bubiri oba enjiibwa ento bbiri eri Mukama, olw’ekibi omuntu oyo ky’akoze, nga ky’ekiweebwayo olw’ekibi, ekimu nga kye ky’ekiweebwayo olw’ekibi ekirala nga kye ky’ekiweebwayo ekyokebwa. ");
INSERT INTO lug_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Anaabireeteranga kabona, n’asooka okuwaayo ekiweebwayo olw’ekibi. Kabona anaanyoolanga ensingo y’ekiweebwayo, naye nga tagikutuddeeko; ");
INSERT INTO lug_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","anaddiranga ku musaayi ogw’ekiweebwayo olw’ekibi n’agumansira ku mabbali g’ekyoto. Omusaayi gwonna ogunaabanga gusigaddewo anaaguttululiranga ku ntobo y’ekyoto. Kino kye kiweebwayo olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Kabona anaawangayo ekiweebwayo ekyokubiri nga kye kiweebwayo ekyokebwa ng’agoberera ebiragiro nga bwe bigamba. Bw’atyo kabona anaatangiririranga omuntu oyo olw’ekibi kye ky’anaabanga akoze, era omuntu oyo anaasonyiyibwanga. ");
INSERT INTO lug_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Omuntu oyo omwavu bw’anaabanga tasobola kuleeta bukaamukuukulu bubiri oba enjiibwa ento bbiri, anaaleetanga ekiweebwayo olw’ekibi kye, kimu kya kkumi ekya efa eky’obuwunga obulungi okuba ekiweebwayo kye olw’okwonoona. Taabuteekengamu mafuta wadde obubaane, kubanga kiweebwayo olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Anaakireeteranga kabona, era kabona anaatoolangako olubatu, nga kye kitundu eky’ekijjukizo kyakyo, n’akyokera ku kyoto, ku biweebwayo eri Mukama ebyokeddwa mu muliro. Kino nga kye kiweebwayo olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Bw’atyo kabona anaatangiririranga omuntu oyo olw’ekibi ky’anaabanga akoze mu bintu ebyo byonna, era anaasonyiyibwanga. Ebyo byonna ebinaasigalangawo ku kiweebwayo kino binaabanga bya kabona, nga bwe kiri mu biragiro by’ekiweebwayo eky’emmere y’empeke.’ ” ");
INSERT INTO lug_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Omuntu bw’anazzanga omusango ng’asobezza mu bimu ku ebyo ebitukuvu bya Mukama nga tagenderedde, anaaleetanga eri Mukama ekiweebwayo kye olw’omusango, endiga ennume etaliiko kamogo ng’agiggya mu kisibo kye; eneebalirirwanga omuwendo ogugigyamu mu ffeeza, ng’ebipimo by’awatukuvu bwe biri, ye sekeri. Ekyo nga kye kiweebwayo olw’omusango. ");
INSERT INTO lug_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Era anaaliwanga olw’ekyo kye yazzaako omusango mu bitukuvu bya Mukama, era anaayongerangako ekitundu kimu ekyokutaano eky’omuwendo gw’ekyo ky’anabanga asobezza; engassi eyo anaagiwanga kabona. Kabona anaatangiririranga omuntu oyo n’endiga ennume ey’ekiweebwayo olw’omusango, bw’atyo anaasonyiyibwanga. ");
INSERT INTO lug_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Omuntu yenna bw’anaayonoonanga n’akola ku ebyo Mukama bye yalagira mu mateeka ge obutabikolanga, ne bw’anaabanga takitegedde, anazzanga omusango. ");
INSERT INTO lug_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Anaaleeteranga kabona endiga ennume eteriiko kamogo ng’agiggya mu kisibo kye, ng’ebalirirwamu omuwendo ogugya mu kiweebwayo olw’omusango. Kabona anaamutangiririranga olw’ekisobyo ky’anaabanga akoze nga tagenderedde, era anaasonyiyibwanga. ");
INSERT INTO lug_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ekyo nga kye kiweebwayo olw’omusango, kubanga anaabanga ayonoonye mu maaso ga Mukama.” ");
INSERT INTO lug_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Omuntu bw’anaayonoonanga n’amenya obwesigwa eri Mukama olw’okulimbalimba munne ku kye yamuteresa, oba kye yamukwasa, oba omuntu oyo kye yabba; oba bw’anabbiranga munne, ");
INSERT INTO lug_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","oba bw’anaazuulanga ebyali bibuze naye n’alimba; oba bw’anaalayiranga eby’obulimba, oba bw’anaayonoonanga mu bintu ng’ebyo byonna abantu mwe batera okwonoona, ");
INSERT INTO lug_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","bw’anaayonoonanga bw’atyo anaabangako omusango; kinaamusaaniranga okuzzaayo ebyo bye yabba oba bye yanyaga, oba bye yateresebwa oba ebyo ebyali bibuze naye n’abizuula, ");
INSERT INTO lug_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","oba ekintu kyonna kye yalayirirako eby’obulimba. Anaaliwanga mu bujjuvu era anaagattangako ekitundu kimu kyakutaano eky’ebyo by’aliwa; bw’atyo anaabiddizanga nnyinibyo ku lunaku omuntu oyo lw’anaaleeterangako ekiweebwayo olw’omusango. ");
INSERT INTO lug_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Era anaaleeteranga kabona ekiweebwayo eri Mukama olw’omusango, nga kya ndiga ennume eteriiko kamogo ng’agiggya mu kisibo kye, ng’ogibaliriddemu omuwendo ogugya mu kiweebwayo olw’omusango. ");
INSERT INTO lug_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Awo kabona anaatangiririranga omuntu oyo mu maaso ga Mukama, era anaasonyiyibwanga mu bintu ebyo byonna by’anaabanga akoze n’azza omusango.” ");
INSERT INTO lug_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Lagira Alooni ne batabani be nti: Lino lye tteeka ery’ebiweebwayo ebyokebwa. Ekiweebwayo ekyokebwa kinaabeeranga ku kyoto ekiro kyonna okutuusa enkeera, era omuliro gw’omu kyoto gunaabanga gwaka ebbanga lyonna. ");
INSERT INTO lug_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Awo kabona anaayambalanga ebyambalo bye ebya bafuta, ng’asooseemu eby’omunda ebya bafuta ku mubiri gwe, n’addira evvu eriri mu kyoto ery’ekiweebwayo ekyokebwa ku kyoto, n’alissa wabbali w’ekyoto. ");
INSERT INTO lug_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Aneeyambulangamu ebyambalo ebyo, n’ayambala ebyambalo ebirala, n’asitula evvu n’alitwala ebweru w’olusiisira mu kifo ekirongoofu eky’emikolo ng’egyo. ");
INSERT INTO lug_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Omuliro gunaasigalanga nga gwaka ebbanga lyonna, teguuzikirenga. Buli nkya kabona anaayongerangako enku ku kyoto; era anaatereezangako ekiweebwayo ekyokebwa ng’akitegese bulungi; era anaayokerangako amasavu ag’ebiweebwayo olw’emirembe. ");
INSERT INTO lug_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Omuliro gunaasigalanga gwaka ku kyoto ebbanga lyonna; teguuzikirenga. ");
INSERT INTO lug_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Era lino ly’etteeka ery’ebiweebwayo eby’emmere ey’empeke. Batabani ba Alooni banaaleetanga ekiweebwayo ekyo awali Mukama mu maaso g’ekyoto. ");
INSERT INTO lug_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Kabona anaayoolanga olubatu lw’obuwunga obulungi obw’ekiweebwayo eky’emmere y’empeke n’amafuta gaako ag’omuzeeyituuni n’obubaane bwonna, ebiri ku kiweebwayo ekyo, n’akyokya ku kyoto nga kye kitundu eky’ekijjukizo kyakyo, ne kivaamu evvumbe eddungi erisanyusa Mukama. ");
INSERT INTO lug_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Batabani ba Alooni banaalyanga ekisigaddewo, naye nga tebaliiramu kizimbulukusa mu kifo ekyo ekitukuvu; banaakiriiranga mu luggya lw’Eweema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Tekiiyokerwengamu kizimbulukusa. Nkibawadde nga kye kinaabanga omugabo gwabwe ogw’oku biweebwayo byange ebyokebwa, kye kintu ekitukuvu ennyo okufaanana ng’ekiweebwayo olw’ekibi n’ekiweebwayo olw’omusango. ");
INSERT INTO lug_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Buli mwana mulenzi ava mu Alooni anaayinzanga okukiryako, ng’etteeka ery’emirembe gyonna bwe ligamba erifa ku biweebwayo eri Mukama ebyokeddwa mu muliro. Buli anaabikwatangako anaafuukanga mutukuvu.” ");
INSERT INTO lug_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Kino ky’ekiweebwayo Alooni ne batabani be kye banaawangayo eri Mukama ku lunaku lwe banaafukibwangako amafuta ag’omuzeeyituuni: ekitundu eky’ekkumi ekya liita bbiri, nga kilo emu ey’obuwunga obulungi, nga kye kiweebwayo eky’emmere ey’empeke nga kisalirwa wakati ekitundu ekimu, enkya, n’ekitundu ekirala, akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Bunaafumbibwanga n’amafuta ag’omuzeeyituuni ku fulampeni, ne butabulwa bulungi, ne buweebwayo eri Mukama nga kye kiweebwayo eky’emmere ey’empeke, ekivaamu evvumbe eddungi erisanyusa Mukama. ");
INSERT INTO lug_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Kabona ow’omu baana ba Alooni anaabanga afukiddwako amafuta ag’omuzeeyituuni okumusikira, y’anaakiwangayo eri Mukama ng’amateeka bwe galagira emirembe gyonna; ekiweebwayo kyonna kinaayokebwanga. ");
INSERT INTO lug_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Buli kiweebwayo kyonna eky’emmere ey’empeke kabona ky’anaawangayo kinaayokebwanga bulambalamba; tekiiriibwenga.” ");
INSERT INTO lug_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Tegeeza Alooni ne batabani be nti bino bye biragiro eby’ekiweebwayo olw’ekibi. Ekiweebwayo olw’ekibi kinattirwanga mu maaso ga Mukama awo wennyini ebiweebwayo ebyokebwa we bittirwa; kiweebwayo kitukuvu nnyo. ");
INSERT INTO lug_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Kabona anaakiwangayo olw’ekibi y’anaakiryanga. Kinaalirwanga mu kifo ekitukuvu mu luggya lwa Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Buli ekinaakoonanga ku nnyama y’ekiweebwayo ekyo, kinaafuukanga kitukuvu; era ogumu ku musaayi gwakyo bwe gunaamansukiranga ekyambalo, kinaayozerwanga mu kifo ekitukuvu. ");
INSERT INTO lug_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ensaka ey’ebbumba mwe kinaafumbirwanga eneeyasibwanga; naye bwe kinaafumbirwanga mu nsaka ey’ekyuma, eneekuutibwanga n’emunyunguzibwamu n’amazzi. ");
INSERT INTO lug_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Buli kabona omusajja anaayinzanga okukiryako; kiweebwayo kitukuvu nnyo. ");
INSERT INTO lug_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Naye ekiweebwayo olw’ekibi, omusaayi gwakyo nga guleeteddwako mu Weema ey’Okukuŋŋaanirangamu olw’okwetangirira mu kifo ekyo ekitukuvu, tekiiriibwenga, kyonna kinaayokebwanga. ");
INSERT INTO lug_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Bino bye biragiro eby’ekiweebwayo olw’omusango; kinaabanga kitukuvu nnyo. ");
INSERT INTO lug_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ekiweebwayo olw’omusango kinattirwanga awo wennyini ekiweebwayo ekyokebwa we kittirwa, era omusaayi gwakyo gunaamansirwanga ku njuyi zonna ez’ekyoto okukyebungulula. ");
INSERT INTO lug_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Amasavu gaakyo gonna ganaawebwangayo: omukira ogwa ssava, amasavu agabikka ku byenda, ");
INSERT INTO lug_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ensigo zombi awamu n’amasavu agaziriko okuliraana ekiwato, n’ekibikka ku kibumba nga biggyibwako wamu n’ensigo. ");
INSERT INTO lug_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kabona anaabyokeranga ku kyoto nga kye kiweebwayo eri Mukama ekyokeddwa mu muliro. Ekyo kye kiweebwayo olw’omusango. ");
INSERT INTO lug_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Buli kabona omusajja anaayinzanga okukiryako; kyokka kinaalirwanga mu kifo ekitukuvu. Kiweebwayo kitukuvu nnyo. ");
INSERT INTO lug_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ebiragiro ebikwata ku kiweebwayo olw’omusango bye bimu n’ebikwata ku kiweebwayo olw’ekibi. Kabona anaakozesanga ebiweebwayo ebyo olw’okutangiririra, y’anaabitwalanga. ");
INSERT INTO lug_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Kabona anaaweerangayo omuntu yenna ekiweebwayo kye ekyokebwa, y’aneesigalizanga eddiba ly’ekiweebwayo ekyo. ");
INSERT INTO lug_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Era buli kiweebwayo eky’emmere ey’empeke ekinaafumbibwanga mu oveni n’ekyo kyonna ekinaateekerwateekerwanga ku fulampeni oba ku lukalango, kabona oyo akiwaddeyo y’anaakitwalanga. ");
INSERT INTO lug_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Era na buli kiweebwayo eky’empeke ekya buli ngeri, nga kitabuddwa mu mafuta ag’omuzeeyituuni oba nga kikalu kyereere, batabani ba Alooni be banaakitwalanga nga bakigabana kyenkanyi buli omu. ");
INSERT INTO lug_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Bino by’ebiragiro eby’ekiweebwayo olw’emirembe omuntu ky’anaawangayo eri Mukama. ");
INSERT INTO lug_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Bw’anaakiwangayo olw’okwebaza, ekiweebwayo ekyo anaakigattirangako zikkeeke ezitabuliddwamu amafuta ag’omuzeeyituuni kyokka nga temuli kizimbulukusa, n’obusukuuti obw’oluwewere nga busiigiddwako amafuta ag’omuzeeyituuni, ne zikkeeke ez’obuwunga obulungi ennyo nga zigoyeddwa bulungi mu mafuta. ");
INSERT INTO lug_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Awamu n’ebiweebwayo bye olw’emirembe n’olw’okwebaza, anaaleeterangako emigaati emifumbe n’ekizimbulukusa. ");
INSERT INTO lug_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ku buli kimu ku biweebwayo ebyo anaggyangako omugaati gumu n’aguwaayo ng’ekiweebwayo eri Mukama; kabona anaamansiranga omusaayi ogw’ekiweebwayo olw’emirembe y’anaatwalanga ekiweebwayo ekyo. ");
INSERT INTO lug_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ennyama y’ebiweebwayo by’omuntu oyo by’aleese olw’emirembe olw’okwebaza eneeriibwanga ku lunaku olwo lwennyini olw’ebiweebwayo bye ebyo; tekubangako gy’asuzaawo. ");
INSERT INTO lug_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Naye omuntu bw’anaawangayo ekiweebwayo olw’okutuukiriza obweyamo, oba olw’okweyagalira, kinaaliibwanga ku lunaku olwo lwennyini lw’akiwaddeyo; ekinaasigalangawo ku kiweebwayo ekyo kinaaliibwanga enkeera. ");
INSERT INTO lug_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ennyama ey’ekiweebwayo eneefikkangawo n’etuusa ku lunaku olwokusatu eneeyokebwanga mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ennyama y’ekiweebwayo ky’omuntu oyo olw’emirembe bw’eneeriibwanga ku lunaku olwokusatu, ekiweebwayo ekyo Mukama taakikkirizenga, n’oyo akiwaddeyo tekiimubalirwengako kubanga tekiibenga kirongoofu, ne buli anaakiryangako anaabanga azzizza omusango. ");
INSERT INTO lug_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Ennyama eneekoonanga ku kintu kyonna ekitali kirongoofu teeriibwenga, wabula eneeyokebwanga mu muliro; naye ku nnyama endala omuntu yenna omulongoofu anaayinzanga okulyako. ");
INSERT INTO lug_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Naye omuntu atali mulongoofu bw’anaalyanga ku nnyama ey’ekiweebwayo eri Mukama olw’emirembe, anaaboolebwanga nga takyabalirwa mu bantu be. ");
INSERT INTO lug_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Era omuntu yenna bw’anaakwatanga ku kintu ekitali kirongoofu, obanga kivudde mu muntu oba mu nsolo, oba ekintu kyonna ekikyayibwa ekitali kirongoofu, ate n’alya ku nnyama y’ekiweebwayo eri Mukama olw’emirembe, omuntu oyo anaaboolebwanga, nga takyabalirwa mu bantu be.’ ” ");
INSERT INTO lug_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Tegeeza abaana ba Isirayiri nti, ‘Temulyanga ku masavu ga nte, oba ag’endiga, oba ag’embuzi. ");
INSERT INTO lug_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Amasavu g’ensolo efudde obufi yokka, n’amasavu g’eyo etaaguddwataaguddwa ensolo endala munaagakozesanga ku bintu ebirala byonna eby’omugaso, naye tekabatandanga ne mugalyako. ");
INSERT INTO lug_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Kubanga buli muntu anaalyanga ku masavu ag’ensolo eneevangako ekiweebwayo eri Mukama ekyokeddwa mu muliro, anaaboolebwanga, nga takyabalirwa mu bantu ba Mukama. ");
INSERT INTO lug_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Era buli kifo kyonna gye munaabeeranga, temuulyenga ku musaayi n’akatono, ne bwe gunaabanga ogw’ebinyonyi oba ogw’ensolo. ");
INSERT INTO lug_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Omuntu yenna anaalyanga ku musaayi, omuntu oyo anaaboolebwanga, nga takyabalirwa mu bantu be.’ ” ");
INSERT INTO lug_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Tegeeza abaana ba Isirayiri nti, Omuntu anaaleetanga ekiweebwayo kye olw’emirembe eri Mukama, anaawangayo eri Mukama Katonda ekitundu kyakyo. ");
INSERT INTO lug_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Anaakisitulanga n’engalo ze n’akireeta eri Mukama Katonda nga kye kiweebwayo kye ekyokeddwa mu muliro. Amasavu n’ekifuba nabyo anaabireetanga, n’awuubawuuba ekifuba mu maaso ga Mukama, ng’ekyo kye kiweebwayo ekiwuubibwa. ");
INSERT INTO lug_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Amasavu kabona anaagokyanga ku kyoto, naye ekifuba kinaabanga kya Alooni ne batabani be. ");
INSERT INTO lug_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ekisambi ekya ddyo kinaawebwanga kabona nga gwe mugabo gwe oguvudde ku kiweebwayo ky’omuntu oyo olw’emirembe. ");
INSERT INTO lug_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Mutabani wa Alooni anaabanga awaddeyo omusaayi n’amasavu eby’ekiweebwayo olw’emirembe, y’anaafunanga ekisambi ekya ddyo nga gwe mugabo gwe. ");
INSERT INTO lug_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ku kiweebwayo olw’emirembe eky’abaana ba Isirayiri, nzigyeko ekifuba ekiwuubibwawuubibwa n’ekisambi, ne mbiwa kabona Alooni ne batabani be, nga gwe gunaabanga omugabo gwabwe ogunaavanga mu baana ba Isirayiri emirembe gyonna.” ");
INSERT INTO lug_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Guno gwe mugabo nga guva ku biweebwayo eri Mukama Katonda ebyokeddwa mu muliro, ogwagerekerwa Alooni ne batabani be ku lunaku lwe baaleetebwa eri Mukama okumuweereza nga bakabona be. ");
INSERT INTO lug_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ku lunaku lwe baafukibwako amafuta ag’omuzeeyituuni, Mukama Katonda yalagira nti abaana ba Isirayiri babibawenga okubeeranga omugabo gwabwe, ogw’enkalakkalira emirembe gyonna. ");
INSERT INTO lug_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Eryo lye tteeka n’ebiragiro ebifuga ebiweebwayo ebyokebwa, ebiweebwayo eby’emmere ey’empeke, n’ebiweebwayo olw’ekibi, n’ebiweebwayo olw’omusango, n’ebiweebwayo olw’okwawulibwa, n’ebiweebwayo olw’emirembe, ");
INSERT INTO lug_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Mukama Katonda bye yawa Musa ku lusozi Sinaayi ku lunaku lwe yalagirirako abaana ba Isirayiri okuleeta ebiweebwayo byabwe eri Mukama Katonda, mu ddungu lya Sinaayi. ");
INSERT INTO lug_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Leeta Alooni ne batabani be, n’ebyambalo, n’amafuta ag’omuzeeyituuni ag’okwawula, ne seddume y’ente ey’ekiweebwayo olw’ekibi, n’endiga ennume bbiri, n’ekibbo ky’emigaati egitali mizimbulukuse; ");
INSERT INTO lug_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","okuŋŋaanyize abantu bonna ku mulyango gwa Weema ey’Okukuŋŋaanirangamu.” ");
INSERT INTO lug_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa n’akola nga Mukama Katonda bwe yamulagira; abantu ne bakuŋŋaanira mu kibiina kinene ku mulyango gwa Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Awo Musa n’agamba ekibiina nti, “Kino Mukama Katonda ky’atulagidde okukola.” ");
INSERT INTO lug_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Bw’atyo Musa n’aleeta Alooni ne batabani be n’abanaaza n’amazzi. ");
INSERT INTO lug_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","N’ayambaza Alooni ekkooti, n’amusiba olwesibyo, n’amwambaza omunagiro, n’amwambaza n’ekyambalo ekya efodi, n’amusibya olwesibyo lwa efodi olwalukibwa n’amagezi amangi, n’amunyweza. ");
INSERT INTO lug_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","N’amuteekako ekyomukifuba, era mu kyomukifuba n’ateekamu Ulimu ne Sumimu. ");
INSERT INTO lug_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","N’amusiba ekitambaala ku mutwe, ne mu maaso ku kitambaala n’assaako ekipande ekya zaabu, nga ye ngule entukuvu, nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Awo Musa n’addira amafuta ag’omuzeeyituuni ag’okwawula, n’agakozesa okwawula Weema ya Mukama, ne byonna ebibeeramu nabyo n’abyawula. ");
INSERT INTO lug_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","N’amansira agamu ku mafuta ku kyoto emirundi musanvu, n’ayawula ekyoto ne byonna ebikozesebwako, n’ebbensani ne mw’etuula, okubitukuza. ");
INSERT INTO lug_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","N’afuka agamu ku mafuta ag’okwawula ku mutwe gwa Alooni, n’amwawula, okumutukuza. ");
INSERT INTO lug_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Awo Musa n’aleeta batabani ba Alooni n’abambaza amakooti, n’abasiba eneesibyo, n’abambaza enkuufiira, nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Awo n’aleeta seddume ey’ekiweebwayo olw’ekibi; Alooni ne batabani be ne bakwata ku mutwe gwayo. ");
INSERT INTO lug_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa n’agitta, n’addira omusaayi gwayo n’agusiiga n’olugalo lwe ku mayembe ag’oku kyoto okukyebungulula, n’atukuza ekyoto. Omusaayi ogwasigalawo n’aguyiwa wansi w’ekyoto, n’akitukuza, okukitangiririra. ");
INSERT INTO lug_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Musa n’addira amasavu gonna agaali ku byenda, n’agaali gabisse ku kibumba, n’ensigo zombi n’amasavu gaazo, byonna n’abyokera ku kyoto. ");
INSERT INTO lug_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Naye seddume, n’eddiba lyayo, n’ennyama yaayo, n’obusa bwayo, n’abyokera mu muliro ebweru w’olusiisira, nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Awo n’aleeta endiga ennume ey’ekiweebwayo ekyokebwa; Alooni ne batabani be ne bakwata ku mutwe gwayo. ");
INSERT INTO lug_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musa n’agitta, n’amansira omusaayi gwayo buli wantu ku kyoto. ");
INSERT INTO lug_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Awo endiga ng’ewedde okusalwasalwa mu bifi, Musa n’ayokya ebifi ebyo n’omutwe gwayo n’amasavu. ");
INSERT INTO lug_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ebyenda n’amagulu nga biwedde okunaazibwa n’amazzi, Musa n’alyoka ayokya endiga yonna ku kyoto. Ekyo nga kye kiweebwayo ekyokye eky’akawoowo akasanyusa, nga kiweerwayo ku muliro eri Mukama, nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Awo Musa n’aleeta endiga ennume eyookubiri, nga y’endiga ey’ekiweebwayo olw’okwawulibwa; Alooni ne batabani be ne bagikwata ku mutwe gwayo. ");
INSERT INTO lug_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa n’alyoka agitta, n’addira ku musaayi gwayo n’agusiiga ku kasongezo k’okutu kwa Alooni okwa ddyo, ne ku kinkumu eky’engalo ye ey’omukono ogwa ddyo, ne ku kigere ekisajja eky’okugulu okwa ddyo. ");
INSERT INTO lug_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Batabani ba Alooni nabo ne baleetebwa, Musa n’asiiga omusaayi ku busongezo bw’amatu gaabwe aga ddyo, ne ku binkumu eby’engalo zaabwe ez’emikono gyabwe egya ddyo, ne ku bigere ebisajja eby’amagulu gaabwe aga ddyo. Musa n’addira omusaayi n’agumansira buli wantu ku kyoto okukyebungulula. ");
INSERT INTO lug_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","N’addira amasavu n’omukira ogwo omusava, n’amasavu gonna agaali ku byenda, n’agaali gabisse ku kibumba, n’ensigo zombi n’amasavu gaazo, n’ekisambi ekya ddyo; ");
INSERT INTO lug_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","n’alaba mu kibbo omubeera emigaati egitali mizimbulukuse egibeera mu maaso ga Mukama Katonda, n’aggyamu akagaati kamu akatali kazimbulukuse, n’akagaati akaakolebwa n’amafuta ag’omuzeeyituuni, n’akasukuuti ak’oluwewere kamu, n’abiteeka ku masavu ne ku kisambi ekya ddyo; ");
INSERT INTO lug_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ebyo byonna n’abikwasa Alooni ne batabani be mu ngalo zaabwe, ne babiwuubawuuba mu maaso ga Mukama Katonda, nga kye kiweebwayo ekiwuubibwa. ");
INSERT INTO lug_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Awo Musa ebyo byonna n’abibaggyako, n’abyokera ku kyoto awamu n’ekiweebwayo ekyokebwa, nga kye kiweebwayo eri Mukama Katonda eky’okwawulibwa, ekyokebwa mu muliro ne muvaamu akawoowo akalungi akasanyusa. ");
INSERT INTO lug_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Era Musa n’addira ekifuba n’akiwuubawuuba, nga kye kiweebwayo eri Mukama ekiwuubibwa. Guno nga gwe mugabo gwa Musa ku ndiga ennume ey’okwawulibwa, nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Awo Musa n’addira ku mafuta ag’okwawula ne ku musaayi ogwali ku kyoto, n’amansira ku Alooni ne ku byambalo bye, ne ku batabani be awamu ne ku byambalo byabwe. Bw’atyo n’atukuza Alooni n’ebyambalo bye awamu ne batabani be n’ebyambalo byabwe. ");
INSERT INTO lug_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa n’agamba Alooni ne batabani be nti, “Ennyama mugifumbire awo ku mulyango gw’Eweema ey’Okukuŋŋaanirangamu, era awo we muba mugiriira awamu n’emigaati egiri mu kibbo omuli ebiweebwayo olw’okwawulibwa, nga bwe nabalagira nga ŋŋamba nti, ‘Alooni ne batabani be baligirya.’ ");
INSERT INTO lug_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ebifisseewo ku nnyama ne ku migaati mujja kubyokya mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Era temufulumanga okuva ku mulyango gwa Weema ey’Okukuŋŋaanirangamu okumala ennaku musanvu, okutuusa ng’ennaku zammwe ez’okwawulibwa zituukiridde, kubanga okubaawula kugenda kumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Mukama alagidde nti nga bwe kikoleddwa leero bwe kinaakolebwanga bwe kityo okubatangiririra. ");
INSERT INTO lug_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Mujja kubeera ku mulyango gwa Weema ey’Okukuŋŋaanirangamu emisana n’ekiro okumala ennaku musanvu, nga mukola ebyo Mukama by’abalagidde, si kulwa nga mufa; bwe ntyo bwe ndagiddwa.” ");
INSERT INTO lug_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Bwe batyo Alooni ne batabani be ne bakola ebyo byonna Mukama Katonda bye yalagira ng’abiyisa mu Musa. ");
INSERT INTO lug_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ku lunaku olw’omunaana Musa n’ayita Alooni ne batabani be n’abakulembeze ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","N’agamba Alooni nti, “Ddira ennyana eya sseddume eweebwayo olw’ekibi, n’endiga ennume olw’ekiweebwayo ekyokebwa, nga zombi teziriiko kamogo, oziweeyo ng’ekiweebwayo eri Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ogambe abaana ba Isirayiri nti, ‘Muddire embuzi ennume eweebwayo olw’ekibi, n’ennyana n’omwana gw’endiga, nga zino zombi zaakamala omwaka gumu obukulu era nga teziriiko kamogo, nga za kiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","era n’ente eya sseddume n’endiga ennume eby’ebiweebwayo olw’emirembe, n’ekiweebwayo eky’emmere ey’empeke nga mulimu amafuta ag’omuzeeyituuni, byonna mubiweeyo nga kye kiweebwayo eri Mukama Katonda; kubanga ku lunaku lwa leero Mukama Katonda ajja kubalabikira.’ ” ");
INSERT INTO lug_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Bwe batyo ne baleeta byonna Musa bye yabalagira okuleeta mu maaso ga Weema ey’Okukuŋŋaanirangamu. Abantu bonna, kye kibiina ekinene, ne basembera ne bayimirira awali Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa n’alyoka abagamba nti, “Kino kye kyo Mukama Katonda kye yabagambye okukola, era ekitiibwa kya Mukama kijja kubalabikira.” ");
INSERT INTO lug_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Awo Musa n’agamba Alooni nti, “Sembera ku kyoto oweeyo ekiweebwayo kyo olw’ebyonoono byo, n’ekiweebwayo kyo ekyokebwa, olyoke weetangiririre awamu n’abantu era oleete ekiweebwayo eky’abantu; obatangiririre; nga Mukama Katonda bwe yalagidde.” ");
INSERT INTO lug_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Awo Alooni n’asembera ku kyoto, n’atta ennyana ey’ekiweebwayo kye olw’ebyonoono bye. ");
INSERT INTO lug_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Batabani ba Alooni ne bamuleetera omusaayi, n’annyika olunwe lwe mu musaayi n’agusiiga ku mayembe ag’oku kyoto, n’afuka omusaayi ku ntobo y’ekyoto. ");
INSERT INTO lug_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","N’addira amasavu n’ensigo n’ebibikka ku kibumba eby’omu kiweebwayo olw’ekibi, n’abyokera ku kyoto, nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ennyama n’eddiba n’abyokera mu muliro ebweru w’olusiisira. ");
INSERT INTO lug_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Alooni n’atta ekiweebwayo ekyokebwa; batabani be ne bamuleetera omusaayi, n’agumansira ku kyoto okukyebungulula. ");
INSERT INTO lug_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ne bamuleetera ebifi eby’ekiweebwayo ekyokebwa nga n’omutwe kweguli; byonna n’abyokera ku kyoto. ");
INSERT INTO lug_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","N’ayoza ebyenda n’amagulu, n’abyokera wamu n’ekiweebwayo ekyokebwa ku kyoto. ");
INSERT INTO lug_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Awo Alooni n’aleeta ekiweebwayo olw’abantu. Yaddira embuzi ey’ekiweebwayo olw’ebibi by’abantu n’agitta, n’agiwaayo ng’ekiweebwayo kye olw’ekibi, kye yasooka olw’ebibi bye. ");
INSERT INTO lug_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","N’aleeta ekiweebwayo ekyokebwa n’akiwaayo ng’etteeka bwe liragira. ");
INSERT INTO lug_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","N’aleeta ekiweebwayo eky’emmere ey’empeke, n’ayoolamu olubatu, n’akyokya ku kyoto okuliraana n’ekiweebwayo ekyokebwa eky’omu makya. ");
INSERT INTO lug_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ente ya sseddume n’endiga ennume nazo n’azitta, nga bye biweebwayo olw’emirembe eby’abantu; batabani ba Alooni ne bamuleetera omusaayi, n’agumansira ku kyoto okukyebungulula enjuuyi zonna. ");
INSERT INTO lug_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Naye amasavu ag’ente eya sseddume n’ago ag’endiga ennume, n’amasavu ag’oku mukira, n’ago agabikka ku byenda, n’ensigo, n’agabikka ku kibumba, ");
INSERT INTO lug_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ne bateeka amasavu gaabyo ku bifuba by’ensolo ezo, n’ayokya amasavu ago ku kyoto; ");
INSERT INTO lug_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","naye ebifuba n’ekisambi ekya ddyo, Alooni n’abiwuubawuuba mu maaso ga Mukama Katonda nga kye kiweebwayo ekiwuubibwa, nga Musa bwe yalagira. ");
INSERT INTO lug_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Awo Alooni n’awanikira abantu emikono gye, n’abasabira omukisa. Bw’atyo Alooni ng’amaze okuwaayo ekiweebwayo olw’ekibi, n’ekiweebwayo ekyokebwa, n’ekiweebwayo olw’emirembe, n’avaayo ku kyoto. ");
INSERT INTO lug_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa ne Alooni ne bayingira mu Weema ey’Okukuŋŋaanirangamu. Bwe baafuluma ne basabira abantu omukisa, era ekitiibwa kya Mukama Katonda ne kirabikira abantu bonna. ");
INSERT INTO lug_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Omuliro ne gujja nga guva eri Mukama Katonda ne gumalirawo ddala ekiweebwayo ekyokebwa n’amasavu ebyali ku kyoto. Awo abantu bonna bwe baakiraba ne baleekaana ne bagalamira wansi ng’amaaso gaabwe gali ku ttaka. ");
INSERT INTO lug_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Awo olwatuuka, batabani ba Alooni, Nadabu ne Abiku ne beetwalira buli omu ekyoterezo kye, ne bateekamu omuliro, ne bassaako obubaane, ne bawaayo eri Mukama Katonda omuliro ogutali mutukuvu, ne basobya ekiragiro kye. ");
INSERT INTO lug_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Omuliro ne guva eri Mukama ne gubookya, ne bafiira awo mu maaso ga Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Awo Musa n’agamba Alooni nti, Kino Mukama Katonda kye yayogerako bwe yagamba nti, “ ‘Nzija kweyolekanga nga bwe ndi omutukuvu eri abo abansemberera, era nassibwangamu ekitiibwa abantu bonna.’ ” Alooni n’asirika busirisi. ");
INSERT INTO lug_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Awo Musa n’ayita Misayeri ne Erizafani, abaana ba Wuziyeeri kitaawe omuto owa Alooni, n’abagamba nti, “Mujje wano musitule emirambo gya baganda bammwe mugiggye wano awatukuvu mugitwale ebweru w’olusiisira.” ");
INSERT INTO lug_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Bwe batyo ne bajja ne basitula baganda baabwe abo nga bwe baali bayambadde ne babatwala ebweru w’olusiisira nga Musa bwe yabagamba. ");
INSERT INTO lug_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Awo Musa n’agamba Alooni, ne Eriyazaali ne Isamaali, batabani ba Alooni, nti, “Mmwe temusumulula nviiri zammwe okuzita ne zireebeeta era temuyuza byambalo byammwe nga mukungubaga, kubanga muyinza okufa, n’obusungu bwa Mukama Katonda buyinza okubuubuukira abantu bonna. Naye baganda bammwe, ye nnyumba yonna eya Isirayiri, babakaabire abo Mukama Katonda b’azikirizza n’omuliro. ");
INSERT INTO lug_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Era temuva ku mulyango gwa Weema ey’Okukuŋŋaanirangamu, temulwa kufa; kubanga muliko amafuta ag’omuzeeyituuni ga Mukama Katonda ag’okwawula.” Ne bakola nga Musa bwe yabalagira. ");
INSERT INTO lug_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Awo Mukama Katonda n’agamba Alooni nti, ");
INSERT INTO lug_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Ggwe ne batabani bo bwe muyingiranga mu Weema ey’Okukuŋŋaanirangamu temunywanga envinnyo oba ekyokunywa ekirala kyonna ekitamiiza; bwe mulikikola temulirema kufa. Eryo linaabanga tteeka ery’enkalakkalira ne mu mirembe gyonna egigenda okujja. ");
INSERT INTO lug_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Mwawulengamu ebitukuvu n’ebyabulijjo, ebirongoofu n’ebitali birongoofu; ");
INSERT INTO lug_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","era kibasaanidde okuyigirizanga abaana ba Isirayiri amateeka gonna Mukama Katonda g’abawadde ng’agayisa mu Musa.” ");
INSERT INTO lug_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Awo Musa n’agamba Alooni ne Eriyazaali ne Isamaali, batabani ba Alooni abaali basigaddewo, nti, “Mutwale ekiweebwayo eky’emmere ey’empeke ekyasigaddewo ku biweebwayo ebyokebwa eri Mukama Katonda nga si kizimbulukuse, mukiriire okumpi n’ekyoto kubanga kitukuvu nnyo. ");
INSERT INTO lug_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mukiriire mu kifo ekitukuvu, kubanga gwe mugabo gwo, era gwe mugabo gw’abatabani bo, nga guva ku kiweebwayo eri Mukama Katonda ekyokebwa; bwe ntyo bwe ndagiddwa. ");
INSERT INTO lug_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Naye ekifuba ekiwuubibwa n’ekisambi ekiweebwayo munaabiriira mu kifo kyonna kye munaalaba ekirongoofu; mubirye, ggwe ne batabani bo ne bawala bo b’oli nabo; kubanga bibaweereddwa ng’omugabo gwammwe, ggwe n’abaana bo, nga biva ku biweebwayo olw’emirembe ebiweereddwayo abaana ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ekisambi ekiweereddwayo n’ekifuba ekiwuubibwa, binaaleetebwa awamu n’amasavu ag’oku biweebwayo ebyokebwa, ne biwuubibwawuubibwa nga kye kiweebwayo ekiwuubibwa awali Mukama, era kinaabeeranga mugabo gwo awamu ne batabani bo emirembe gyonna; nga Mukama Katonda bw’alagidde.” ");
INSERT INTO lug_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Awo Musa n’abuuliriza ebyali bifudde ku mbuzi ey’ekiweebwayo olw’ekibi, n’avumbula nga baagyokezza dda, n’anyiigira batabani ba Alooni abaali basigaddewo, Eriyazaali ne Isamaali, n’ababuuza nti, ");
INSERT INTO lug_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Lwaki ekiweebwayo ekyo olw’ekibi temwakiriiridde, wali awatukuvu? Kitukuvu nnyo. Kyabaweereddwa kiryoke kiggyiseeko abantu bonna ebibi byabwe, nga mmwe mubatangiririra awali Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ng’omusaayi gwayo bwe gutaatwaliddwa munda mu Kifo Ekitukuvu, embuzi eyo ddala mwandigiriiridde awo awatukuvu nga bwe nabalagira.” ");
INSERT INTO lug_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Awo Alooni n’addamu Musa nti, “Laba, olwa leero bawaddeyo eri Mukama Katonda ekiweebwayo olw’ebibi byabwe n’ekiweebwayo kyabwe ekyokebwa; naye era ebintu nga bino ne bingwako. Mukama Katonda yandisanyuse singa leero ndidde ekiweebwayo olw’ekibi?” ");
INSERT INTO lug_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Awo Musa bwe yawulira ebigambo ebyo n’amatira. ");
INSERT INTO lug_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Awo Mukama Katonda n’agamba Musa ne Alooni nti, ");
INSERT INTO lug_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Mutegeeze abaana ba Isirayiri nti bino bye biramu bye munaayinzanga okulya mu bisolo byonna eby’oku nsi. ");
INSERT INTO lug_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Munaayinzanga okulya ensolo yonna erina ekigere ekyaseemu nga kyeyawulidde ddala, era ng’ezza obwenkulumu. ");
INSERT INTO lug_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Kyokka ezo ezizza obwenkulumu bwokka, oba ezirina ebigere ebyaseemu byokka, temuziryanga. Ggamba eŋŋamira, newaakubadde ng’ezza obwenkulumu naye ebigere byayo si byaseemu; noolwekyo si nnongoofu. ");
INSERT INTO lug_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","N’omusu nagwo guzza obwenkulumu, naye ebigere byagwo si byaseemu; noolwekyo si mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ate n’akamyu ak’omu nsiko, newaakubadde nako kazza obwenkulumu naye ebigere byako si byaseemu, noolwekyo si kalongoofu, era temukalyanga. ");
INSERT INTO lug_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ate mulabe embizzi, newaakubadde ng’ekigere kyayo kyaseemu, ate nga kyeyawulidde ddala, naye tezza bwenkulumu; noolwekyo si nnongoofu gye muli. ");
INSERT INTO lug_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ebisolo ng’ebyo temulyanga nnyama yaabyo, wadde okukwatako ku mirambo gyabyo; kubanga si birongoofu gye muli. ");
INSERT INTO lug_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Ku biramu ebiri mu mazzi ag’omu nnyanja n’ag’omu migga mulyangako ebyo ebirina amatu awamu n’amagagamba ku mubiri gwabyo. ");
INSERT INTO lug_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ebiramu byonna ebyekuluumulira mu nnyanja ne mu migga naye nga tebiriiko matu oba magagamba binaabanga bya muzizo gye muli. ");
INSERT INTO lug_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Nga bwe binaabanga eby’omuzizo gye muli, temuulyenga ku nnyama yaabyo, era n’emirambo gyabyo ginaabanga gya muzizo. ");
INSERT INTO lug_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Buli kiramu kyonna ekibeera mu mazzi naye nga tekiriiko matu wadde amagagamba kinaabanga kya muzizo gye muli. ");
INSERT INTO lug_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Mu nnyonyi, zino ze z’omuzizo era temuuziryenga: empungu, ensega, makwanzi, ");
INSERT INTO lug_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","kamunye, eddiirawamu erya buli ngeri, ");
INSERT INTO lug_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ne namuŋŋoona owa buli ngeri; ");
INSERT INTO lug_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","maaya, olubugabuga, olusobe, enkambo eza buli ngeri, ");
INSERT INTO lug_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ekiwuugulu, enkobyokkobyo, ekkufufu, ");
INSERT INTO lug_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ekiwuugulu eky’amatu, ne kimbala, ensega, ");
INSERT INTO lug_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","kasida, mpabaana owa buli ngeri, ekkookootezi, n’ekinyira. ");
INSERT INTO lug_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Ebiwuka byonna ebirina ebiwaawaatiro nga bitambuza amagulu ana binaabanga bya muzizo gye muli. ");
INSERT INTO lug_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Naye mu biwuka ebyo ebirina ebiwaawaatiro era nga bitambuza amagulu ana munaalyangamu ebyo ebirina ennyingo ku magulu gaabyo ebigenda nga bibuuka amacco ku ttaka. ");
INSERT INTO lug_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Mu ebyo bino bye munaalyanga: enzige eza buli ngeri, n’enseenene eza buli ngeri, n’obunyeenyenkule obwa buli ngeri, n’amayanzi aga buli ngeri. ");
INSERT INTO lug_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Naye ebiwuka ebirala byonna eby’ebiwaawaatiro nga birina amagulu ana binaabanga bya muzizo gye muli. ");
INSERT INTO lug_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Bino nabyo binaabafuulanga abatali balongoofu; buli anaakwatanga ku mulambo gw’ensolo nga zino anaafuukanga atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Era buli anaasitulanga ekitundu kyonna eky’omulambo gwazo anaateekwanga okwoza engoye ze, kyokka era anaabanga afuuse atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“Buli nsolo yonna erina ekigere ekyaseemu naye nga tekyeyawulidde ddala, oba nga tezza bwenkulumu, eneebanga ya muzizo gye muli. Buli anaakwatanga ku mulambo gwazo anaabanga afuuse atali mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Mu nsolo zonna ezitambulira ku magulu ana, ezo ezitambulira ku bibatu byazo teziibenga nnongoofu gye muli, buli muntu anaakwatanga ku mulambo gwazo anaabanga afuuse atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Era n’oyo anaasitulanga omulambo gwazo anaayozanga engoye ze; naye era anaabanga afuuse atali mulongoofu okutuusa akawungeezi. Teziibenga nnongoofu gye muli. ");
INSERT INTO lug_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Mu nsolo ezigenda zisoobera ku ttaka; zino teziibenga nnongoofu gye muli: eggunju, emmese, amakonkome amanene aga buli ngeri; ");
INSERT INTO lug_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","anaka, enswaswa, omunya, ekkonkome, ne nnawolovu. ");
INSERT INTO lug_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Mu ezo zonna ezisoobera ku ttaka ezo teziibenga nnongoofu gye muli. Era buli anaazikwatangako nga zimaze okufa anaabanga afuuse atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Era emu ku zo bw’eneefanga n’egwa ku kintu eky’engeri yonna ekikozesebwa, ekintu ekyo kinaafuukanga ekitali kirongoofu, obanga ekintu ekyo kyakolebwa mu muti, oba mu lugoye, oba mu ddiba oba mu kkutiya. Kiteekebwenga mu mazzi. Tekiibenga kirongoofu okutuusa akawungeezi; kyokka oluvannyuma kinaalongookanga. ");
INSERT INTO lug_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Era emu ku zo bw’eneegwanga mu nsaka ey’ebbumba, byonna ebiri mu nsaka omwo binaafuukanga ebitali birongoofu, era ensaka eyo muteekwa buteekwa okugyasanga. ");
INSERT INTO lug_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Emmere eneebanga egenda okuliibwa naye n’ebaako amazzi agavudde mu nsaka omwo, teebenga nnongoofu, n’amazzi agandinywereddwa okuva mu nsaka omwo tegaabenga malongoofu. ");
INSERT INTO lug_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Era buli kintu kyonna omulambo gw’ensolo zino kwe gunaabanga gugudde ku masiga okufumbirwa oba mu ntamu, binaayasibwayasibwanga, kubanga si birongoofu; era tebiibenga birongoofu gye muli. ");
INSERT INTO lug_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Naye bwe gunaagwanga mu luzzi oba mu ppipa y’amazzi, ebyo byo binaasigalanga birongoofu; naye oyo yenna anaakwatanga ku mulambo ogwo taabenga mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Singa omulambo gugwa ku nsigo ez’engeri yonna ezigenda okusimbibwa, zinaasigalanga nnongoofu. ");
INSERT INTO lug_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Naye singa ensigo ziyiyibbwako amazzi, omulambo ne guzigwako, teziibenga nnongoofu gye muli. ");
INSERT INTO lug_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Singa ensolo yonna ku ezo ze mukkirizibwa okulya efa, oyo yenna anaakwatanga ku mulambo gwayo anaabanga atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Oyo anaalyanga ku nnyama y’omulambo kinaamusaaniranga okwoza engoye ze, era taabenga mulongoofu okutuusa akawungeezi. Oyo yenna anaasitulanga omulambo, kinaamusaaniranga okwoza engoye ze, naye taabenga mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Buli kitonde kyonna ekitambulira ku ttaka kinaabanga kya muzizo, temuukiryenga. ");
INSERT INTO lug_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Temuulyenga kitonde kyonna ekyekululira ku ttaka, obanga kyewalulira ku lubuto lwakyo, oba nga kitambuza amagulu, oba nga kikozesa ebigere bingi; kinaabanga kya muzizo. ");
INSERT INTO lug_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Temuganyanga kwonoonebwa bitonde ebyo n’ekimu. Temubikozesanga temulwa kweyonoona, era temubikkirizanga kubafuula abatali balongoofu. ");
INSERT INTO lug_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Kubanga Nze Mukama Katonda wammwe, kale mwetukuzanga ne mubeera batukuvu, kubanga Nze ndi mutukuvu. Temwesemberezanga ebitonde ebyo ebitambulira ku ttaka ne bibafuula abatali balongoofu. ");
INSERT INTO lug_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Kubanga Nze Mukama eyabaggya mu nsi ey’e Misiri, okubeera Katonda wammwe; noolwekyo kibasaanira okubeeranga abatukuvu, kubanga Nze ndi mutukuvu. ");
INSERT INTO lug_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Ago ge mateeka agakwata ku nsolo, ne ku nnyonyi, ne ku buli kiramu kyonna eky’omu mazzi, ne ku buli kitonde kyonna ekyewalulira ku ttaka. ");
INSERT INTO lug_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Kibasaaniranga mwawulemu, mu bitonde ebiramu ebirongoofu ebisaana okuliibwanga, ne mu bitonde ebiramu ebitali birongoofu ebitasaana kuliibwanga.” ");
INSERT INTO lug_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Abaana ba Isirayiri bagambe nti, ‘Omukazi bw’anaabanga olubuto, n’azaala omwana nga wabulenzi, omukazi oyo taabenga mulongoofu okumala ennaku musanvu, okufaanana nga bw’atabeera mulongoofu ng’ali mu kiseera ky’okulwala kw’abakazi okwa buli mwezi. ");
INSERT INTO lug_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ku lunaku olw’omunaana omwana oyo omulenzi anaakomolebwanga. ");
INSERT INTO lug_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ate omukazi anaalindanga ne wayitawo ennaku amakumi asatu mu ssatu alyoke atukuzibwe olw’omusaayi ogwamuvaamu ng’azaala. Taakwatenga ku kintu ekitukuvu wadde okuyingiranga mu watukuvu okutuusa ng’ennaku z’okutukuzibwa kwe ziweddeko. ");
INSERT INTO lug_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Naye bw’anaabanga azadde omwana wabuwala, omukazi taabenga mulongoofu okumala wiiki bbiri, nga bw’abeera ng’ali mu kiseera kye eky’okulwala kw’abakazi okwa buli mwezi. Ate anaalindanga ennaku nkaaga mu mukaaga alyoke alongoosebwe olw’omusaayi ogwamuvaamu ng’azaala. ");
INSERT INTO lug_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Ennaku z’omukazi oyo ez’okutukuzibwa bwe zinaggwangako, bw’anaabanga azadde omwana mulenzi oba muwala, anaaleetanga eri kabona ku mulyango gw’Eweema ey’Okukuŋŋaanirangamu, omwana gw’endiga oguwezezza omwaka gumu obukulu okuguwaayo ng’ekiweebwayo ekyokebwa, ng’enjiibwa ento oba ejjiba ng’ekiweebwayo olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kabona anaabiwangayo eri Mukama okutangirira omukazi oyo; bw’atyo anaabeeranga mulongoofu olw’omusaayi ogwamuvaamu ng’amaze okuzaala. “ ‘Ago ge mateeka agakwata ku mukazi anaazaalanga omwana owoobulenzi oba owoobuwala. ");
INSERT INTO lug_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Bw’anaabanga tasobola kuwaayo mwana gwa ndiga, anaaleetanga bibiri bibiri ku bino: enjiibwa ento bbiri oba amayiba abiri, ekimu nga ky’ekiweebwayo ekyokebwa n’ekirala nga ky’ekiweebwayo olw’ekibi. Mu ngeri eno kabona anaamutangiririranga, bw’atyo n’afuuka mulongoofu.’ ” ");
INSERT INTO lug_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Awo Mukama n’agamba Musa ne Alooni nti, ");
INSERT INTO lug_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Omuntu yenna bw’anaabanga n’akazimbye ku lususu lw’omubiri gwe, oba awabutuse, oba awali akatulututtu, ne wafaanana ng’awali endwadde ey’ebigenge, aleetebwenga eri Alooni kabona, oba eri omu ku batabani be bakabona. ");
INSERT INTO lug_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Kabona anaakeberanga ekifo ekyo awazimbye ku lususu, bw’anaasanganga ng’obwoya obuli awo awazimbye bufuuse bweru, ate nga awalwadde wennyise okusinga olususu lw’omubiri gw’omuntu oyo, ng’olwo ebyo bigenge. Kabona bw’anaamalanga okumukebera anaalangiriranga nti omuntu oyo si mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Naye awazimbye bwe wanaabanga walungudde, naye nga tewennyise okusinga olususu lw’omubiri gwe, ate nga n’obwoya mu wazimbye awo tebufuuse bweru, kabona anaasibiranga omuntu oyo omulwadde mu kalantiini okumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ku lunaku olw’omusanvu kabona anaakeberanga omuntu oyo; bw’anaasanganga ng’awazimbye teweeyongedde, era nga n’obulwadde obwo tebusaasaanye ku lususu, anaayongeranga okumusibira mu kalantiini ennaku endala musanvu. ");
INSERT INTO lug_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ku lunaku olw’omusanvu kabona anaddangamu okumukebera, kale bw’anaasanganga ng’obuzimbu tebukyalabika nnyo, era obulwadde obwo nga tebusaasaanye ku lususu, anaamulangiriranga nti mulongoofu; kubanga kubadde kubutuka bubutusi. Omuntu oyo anaayozanga engoye ze, era anaabanga mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Naye okubutuka okwo bwe kunaasaasaananga ku lususu oluvannyuma lw’okweyanjula eri kabona amulangirire nti mulongoofu, anaateekwanga okuddayo eri kabona yeeyanjule buto. ");
INSERT INTO lug_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kabona anaamukeberanga, bw’anaasanganga ng’okubutuka kusaasaanye ku lususu ku mubiri, kabona anaamulangiriranga nti si mulongoofu; ng’ebyo bigenge. ");
INSERT INTO lug_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Omuntu yenna bw’anaakwatibwanga ebigenge, anaaleetebwanga eri kabona. ");
INSERT INTO lug_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kabona anaamukeberanga, bw’anaasangangawo obuzimbu obweru ku lususu nga bwerusizza n’obwoya, era awazimbye nga waliwo n’ennyama y’omubiri erungudde, ");
INSERT INTO lug_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ebyo binaabanga bigenge eby’olutentezi ku lususu lw’omubiri gw’omuntu oyo, era kabona anaamulangiriranga nti si mulongoofu. Taasibibwenga mu kalantiini, kubanga amaze okutegeererwawo nga bw’atali mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Naye singa ebigenge bisaasaana ku lususu ne bituuka wonna wonna okuva ku mutwe gw’omuntu oyo okutuuka ku bigere nga kabona bw’asobola okulaba, ");
INSERT INTO lug_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","kale kabona anaakeberanga omuntu oyo; bwe kinaazuulibwanga ng’ebigenge bibunye omubiri gw’omuntu oyo gwonna, anaamulangiriranga nga bw’ali omulongoofu; kubanga omubiri gwe gwonna gufuuse mweru, oyo mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Naye ku lususu lw’omuntu oyo bwe kunaalabikangako ennyama erungudde taabenga mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kabona anaakeberanga ennyama eyo erungudde, n’amulangirira nga bw’atali mulongoofu. Ennyama erungudde si nnongoofu, kubanga bigenge. ");
INSERT INTO lug_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Naye singa ennyama erungudde ekyuka n’efuuka enjeru, omuntu oyo anajjanga eri Kabona. ");
INSERT INTO lug_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kabona anaamukeberanga, bw’anaazuulanga ng’olususu olulwadde lufuuse lweru, anaalangiriranga omulwadde oyo okuba omulongoofu; bw’atyo anaabanga mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Omuntu bw’anaabanga alwadde ejjute ku lususu lwe, naye ne liwona, ");
INSERT INTO lug_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","kyokka mu kifo awaali ejjute ne wajjawo obuzimbu obweru oba akatulututtu akatwakaavu, wasaana walagibwe kabona. ");
INSERT INTO lug_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kabona anaakeberangawo, bw’anaasanganga nga wennyise okusinga olususu, nga n’obwoya bwawo bufuuse bweru; kale kabona analangiriranga omuntu oyo nga bw’atali mulongoofu. Obwo bulwadde bwa bigenge ebifulumidde awo awaali ejjute. ");
INSERT INTO lug_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Naye kabona bw’anaakeberangawo, n’asanga ng’obwoya obuliwo si bweru, ate nga tewennyise okusinga olususu era nga tewakyalabika nnyo, kale kabona anaasibanga omuntu oyo mu kalantiini okumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Naye obulwadde obwo bwe bunaasaasaananga ku lususu, kale kabona analangiriranga omuntu oyo nti si mulongoofu, ebyo nga bigenge. ");
INSERT INTO lug_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Naye obuzimbu bwe bunaasigalanga mu kifo kimu ne butasaasaana, eyo eneebanga nkovu ya jjute, era kabona anaalangiriranga omuntu oyo nti mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Singa wabaawo ku lususu lw’omuntu awayidde omuliro, awo awali ennyama eyidde ne wazimba, ne wafuuka watwakaavu oba weeru, ");
INSERT INTO lug_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","kabona anaakeberangawo, obwoya bwawo bwe bunaabanga bufuuse bweru, ate nga walabika ng’awennyise okusinga olususu, ebyo nga bigenge bye bifulumye ku lususu oluyidde. Kabona anaalangiriranga omuntu oyo nti si mulongoofu; ebyo binaabanga bigenge. ");
INSERT INTO lug_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Naye kabona bw’anaakeberanga awo awayidde, n’asanga ng’obwoya obuliwo si bweru, era nga tewennyise kusinga lususu, naye nga tewakyalabika nnyo, kabona anaasibiranga omuntu oyo mu kalantiini okumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ku lunaku olw’omusanvu kabona anaamukeberanga, kale bw’anaasanganga ng’obulwadde busaasaana ku lususu, kabona anaamulangiriranga nti si mulongoofu; ebyo nga bigenge. ");
INSERT INTO lug_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Naye obulwadde bwe bunaasigalanga mu kifo ekimu ne butasaasaana ku lususu, era ng’awazimbu tewakyalabika nnyo, buno bunaabanga buzimbu obuleeteddwa omuliro ogwayokyawo; kale kabona anaamulangiriranga nti mulongoofu; kubanga eyo y’enkovu ku lususu awaayokebwa omuliro. ");
INSERT INTO lug_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Omusajja oba omukazi bw’anaalwalanga ebbwa ku mutwe oba ku kalevu, ");
INSERT INTO lug_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kabona anaakeberanga ebbwa eryo, bwe linaabanga lyennyise okusinga olususu, nga n’obwoya obulirimu bwa kyenvu ate nga bwa matalaga; kale kabona anaamulangiriranga nti si mulongoofu; eryo nga lye bbwa erisiiwa, nga bye bigenge eby’oku mutwe oba eby’oku kalevu. ");
INSERT INTO lug_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Kabona bw’anaakeberanga ebbwa erisiiwa, n’asanga nga teryennyise kuyisa lususu, ate nga mu lyo nga temuliimu bwoya buddugavu, kale kabona anaasibiranga omuntu oyo alina ebbwa erisiiwa mu kalantiini amalemu ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ku lunaku olw’omusanvu kabona anaakeberanga ebbwa eryo, bw’anaasanganga ng’okusiiwa tekusaasaanye, ate nga mu bbwa temuliimu bwoya bwa kyenvu, era ng’awasiiwa tewennyise kusinga lususu, ");
INSERT INTO lug_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","omuntu oyo asaananga amwebwe okuggyako awo awalwadde wokka; ate kabona anaamusibiranga mu kalantiini ennaku endala musanvu. ");
INSERT INTO lug_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ku lunaku olw’omusanvu kabona anaakeberanga awo awasiiwa, okusiiwa bwe kunaabanga tekusaasaanye ku lususu, ate nga tewennyise kusinga lususu, kale, kabona anaalangiriranga omuntu oyo nga bw’ali omulongoofu; era omuntu oyo anaayozanga engoye ze n’abeera mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Naye okusiiwa bwe kunaasaasaananga ku lususu ng’amaze okulongooka, ");
INSERT INTO lug_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","kabona anaayongeranga okumukebera, bw’anaasanganga ng’okusiiwa kusaasaanye ku lususu, kabona taanoonyenga bwoya bwa kyenvu mu bbwa eryo; omuntu oyo si mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Naye mu kulaba kwa kabona, okusiiwa bwe kunaabanga tekweyongedde, nga n’obwoya obwa kyenvu bukuze mu bbwa, olwo ng’okusiiwa kuwonye, era omuntu oyo nga mulongoofu era kabona naye anaamulangiriranga nti mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Omusajja oba omukazi bw’anaabanga n’obutulututtu obweru ku mubiri gwe, ");
INSERT INTO lug_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kabona anaamukeberanga, bw’anaasanganga ng’obutulututtu bweruyeru, okwo kuba kubutukabutuka okuyiise ku lususu lw’omuntu oyo, ye aba mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Omusajja bw’anaakuunyuukangako enviiri ze ku mutwe gwe zonna, anaabeeranga kyemwa, naye nga mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Era omusajja bw’anaakuunyuukangako enviiri ze ez’omu maaso nga ku kyenyi, oyo anaabanga wa kiwalaata eky’omu bwenyi, kyokka nga mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Naye mu mutwe omutali nviiri oba mu kiwalaata eky’omu bwenyi bwe munaabangamu akafo akalwadde ebbwa nga kalungudde keeruyeru nga kalimu obumyufumyufu, ebyo nga bigenge bye bifulumye mu mutwe ogutaliimu nviiri oba mu kiwalaata eky’omu bwenyi. ");
INSERT INTO lug_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Kale kabona anaakeberanga omuntu oyo, bw’anaasanganga ng’akafo ako awalwadde ebbwa era awazimbye mu mutwe oguweddemu enviiri oba mu kiwalaata ekiri mu bwenyi, nga kalungudde era nga weeruyeru nga kalimu obumyufumyufu, nga walabika ng’ebigenge bwe biba nga biri ku lususu olw’omubiri, ");
INSERT INTO lug_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","omuntu oyo anaabanga mugenge, nga si mulongoofu. Kabona anaamulangiriranga nga bw’atali mulongoofu, olw’obulwadde obwo mu mutwe gwe. ");
INSERT INTO lug_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Omuntu anaalwalanga ebigenge anaayambalanga engoye njulifu, n’enviiri z’oku mutwe gwe anaazirekanga ne zikula ne ziduumuuka, anaabikkanga ku mumwa gwe ogw’engulu n’atambula nga bw’aleekaana nti, ‘Siri mulongoofu! Siri mulongoofu!’ ");
INSERT INTO lug_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ebbanga lyonna omuntu ly’anaamalanga ng’alina obulwadde obwo anaabeeranga si mulongoofu. Anaasulanga yekka mu nnyumba ye ebweru w’olusiisira. ");
INSERT INTO lug_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Obulwadde bw’ebigenge bwe bunaalabikanga mu byambalo by’omusajja oba eby’omukazi, ebyambalo ebyo nga bikoleddwa mu byoya by’endiga oba mu bafuta oba maliba, ");
INSERT INTO lug_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","oba mu nfunyiro ne mu ntabiro z’ebyambalo by’ebyoya by’endiga, oba mu bafuta oba mu maliba, oba mu kyambalo ekya buli ngeri yonna ekitungiddwa mu maliba; ");
INSERT INTO lug_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","era obulwadde obwo bwe bunaalabikanga nga bwa langi ya kiragalalagala oba myufumyufu, nga buli mu kyambalo oba mu nfunyiro oba mu ntabiro zaakyo, oba mu kyambalo kyonna ekitungiddwa mu maliba; obwo nga bulwadde bwa bigenge, era bunaalagibwanga kabona. ");
INSERT INTO lug_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kabona anaakeberanga obulwadde obwo, anaasibiranga ekintu ekyo omuli obulwadde mu kalantiini okumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ku lunaku olw’omusanvu kabona anaakeberanga obulwadde obwo. Bw’anaasanganga ng’obulwadde obwo bauaasanye mu kyambalo, mu nfunyiro oba mu butungiro oba mu maliba, oba mu kyonna ekitungiddwa mu maliba, ng’amanya ng’obulwadde obwo bwa bigenge ebitta n’omuntu; ekyo ekyambalo nga si kirongoofu. ");
INSERT INTO lug_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Kabona anaayokyanga ebyambalo ebyo, obanga obulwadde buli mu nfunyiro oba mu ntabiro ez’ebyambalo ebya bafuta oba eby’ebyoya by’endiga, oba ebirala byonna ebitungiddwa mu maliba, kubanga obwo bwe bulwadde bw’ebigenge ebittira ddala. Ebyambalo ebyo binaayokebwanga mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Kabona bw’anaabanga akebedde ekyambalo ekirimu obulwadde, n’asanga nga tebusaasaanye mu kyambalo, ne mu nfunyiro zaakyo, oba ne mu ntabiro, oba ne mu kyonna ekitungiddwa mu maliba, ");
INSERT INTO lug_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","kale kabona anaalagiranga ne bayoza ekyambalo ekyo omuli obulwadde, n’ayongera okukisibira mu kalantiini ennaku endala musanvu. ");
INSERT INTO lug_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Awo kabona anaakeberanga ekyambalo ekyo ekyoze, bw’anaasanganga ng’erangi y’akafo awali obulwadde tekyuse, newaakubadde ng’obulwadde tebusaasaanye, ekyambalo ekyo nga si kirongoofu. Mukyokyanga mu muliro, awali ebigenge ne bwe wanaabanga mu kyambalo mu maaso oba mu mabega gaakyo. ");
INSERT INTO lug_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Naye kabona bw’anaakeberanga n’asanga nga bwe bamaze okwoza ekyambalo, akafo ako awali obulwadde tekakyalabika nnyo, akafo ako anaakayuzangamu mu kyambalo ekyo, oba mu ddiba oba mu kiruke kyonna ekyambalwa. ");
INSERT INTO lug_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Naye obulwadde obwo bwe bunaalabikanga nate mu kyambalo, oba mu kyambalo eky’eddiba oba ekiruke, nga busaasaanye, kale munaayokyanga mu muliro ekyambalo ekyo omuli obulwadde. ");
INSERT INTO lug_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Naye mu kyambalo kyonna, oba ekyambalo eky’eddiba oba ekiruke, obulwadde bwe buggwangamu nga kimaze okwozebwa, kale kinaayozebwanga omulundi ogwokubiri, ne kiba kirongoofu.” ");
INSERT INTO lug_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Eryo lye tteeka ery’obulwadde bw’ebigenge mu byambalo by’ebyoya by’endiga, oba linena, oba ebiruke obulusi, oba ebitunge mu maliba mu ngeri ezitali zimu, erinaasinziirwangako okulangirira obanga ekyambalo kirongoofu oba si kirongoofu. ");
INSERT INTO lug_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Lino lye tteeka erinaagobererwanga ku lunaku omugenge lw’anaafuulibwanga omulongoofu mu ngeri entongole ng’aleeteddwa eri kabona. ");
INSERT INTO lug_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Kabona anaafulumanga n’agenda ebweru w’olusiisira n’akebera omuntu oyo. Awo bw’anaasanganga ng’obulwadde bw’ebigenge bumuwonyeeko, ");
INSERT INTO lug_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","kabona anaalagiranga okuleetera omuntu oyo agenda okufuulibwa omulongoofu, ebinyonyi bibiri ebiramu ebirongoofu, n’omuti omwerezi, n’oluwuzi olumyufu, n’ezobu. ");
INSERT INTO lug_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Kabona anaalagiranga okuttira emu ku nnyonyi ziri ebbiri waggulu w’amazzi amalungi agali mu luggyo. ");
INSERT INTO lug_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Anaddiranga ennyonyi ennamu, awamu n’omuti omwerezi, n’oluwuzi olumyufu, n’ezobu, byonna ebyo n’abinnyika mu musaayi gw’ennyonyi enettirwanga waggulu w’amazzi amalungi. ");
INSERT INTO lug_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Anaamansiranga omusaayi emirundi musanvu ku oyo omulwadde w’ebigenge agenda okufuulibwa omulongoofu; era anaamulangiriranga nti mulongoofu. Ekinyonyi kiri ekiramu, kabona anaakirekanga n’ekibuuka n’ekigenda. ");
INSERT INTO lug_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Omuntu oyo anaabanga agenda okufuulibwa omulongoofu anaayozanga engoye ze, n’amwako enviiri ze, n’anaaba mu mazzi, n’abeera mulongoofu. Ebyo nga biwedde anaayingiranga mu lusiisira, naye ajjanga kumala ennaku musanvu ng’asula bweru wa weema ye. ");
INSERT INTO lug_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ku lunaku olw’omusanvu omuntu oyo anaayongeranga okumwa ku mutwe gwe enviiri ze zonna, anaamwangako n’ebirevu bye, n’ebisige bye, n’obwoya obulala bwonna obumwebwa. Ate anaayozanga engoye ze, n’anaaba omubiri gwe gwonna mu mazzi, bw’atyo n’afuuka mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Ku lunaku olw’omunaana anaaleetanga abaana b’endiga abalume babiri abataliiko kamogo, n’omwana gw’endiga omuluusi nga gwa mwaka gumu ogw’obukulu, n’aleeterako n’obuwunga obulungi obw’emmere ey’empeke obuweza kilo ssatu obw’ekiweebwayo, ng’abutabudde mu mafuta, n’aleeterako n’ebbakuli y’amafuta ag’omuzeeyituuni eweza desimoolo ssatu eza lita. ");
INSERT INTO lug_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Awo kabona ow’okulangiriranga omuntu oyo okuba omulongoofu, anaamuleetanga, awamu n’ebiweebwayo bye, awali Mukama Katonda mu mulyango gw’Eweema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Awo kabona anaddiranga omu ku baana b’endiga omulume n’aguwaayo awamu n’epakuli y’amafuta ag’omuzeeyituuni, ng’ekiweebwayo olw’omusango, anaabiwuubanga ng’ekiweebwayo eri Mukama Katonda ekiwuubibwawuubibwa. ");
INSERT INTO lug_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Omwana gw’endiga ogwo anaaguttiranga mu kifo ekitukuvu, ekiweebwayo olw’ekibi n’ekiweebwayo ekyokebwa we bittirwa. Okufaanana ng’ekiweebwayo olw’ekibi, ekiweebwayo olw’omusango nakyo kinaabanga kya kabona; nga kitukuvu nnyo. ");
INSERT INTO lug_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Awo kabona anaatoolanga ku musaayi ogw’ekiweebwayo olw’omusango n’agusiiga ku lukugiro lw’okutu okwa ddyo okw’oyo anaabeeranga azze okufuulibwa omulongoofu, ne ku kinkumu eky’engalo ey’omukono gwe ogwa ddyo, ne ku kigere ekisajja eky’oku kugulu kwe okwa ddyo. ");
INSERT INTO lug_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Kabona anaddiranga ku mafuta ag’omuzeeyituuni ag’omu pakuli n’agafukako mu kibatu ky’omukono gwe ogwa kkono, ");
INSERT INTO lug_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","anannyikanga olunwe lwe olwa ddyo mu mafuta ag’omuzeeyituuni agali mu kibatu ky’omukono gwe ogwa kkono, n’amansira n’olunwe lwe ku mafuta ag’omuzeeyituuni emirundi musanvu awali Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Kabona anaddiranga agamu ku mafuta ag’omuzeeyituuni aganaabanga gasigadde mu kibatu kye n’agasiiga ku lukugiro lw’okutu kw’oyo anaabeeranga azze okufuulibwa omulongoofu, ne ku kinkumu ky’engalo ey’omukono gwe ogwa ddyo, ne ku kigere ekisajja eky’oku kugulu kwe okwa ddyo, ng’agasiiga kungulu ku musaayi ogw’ekiweebwayo olw’omusango. ");
INSERT INTO lug_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Kabona anaddiranga amafuta ag’omuzeeyituuni aganaabanga gasigadde mu kibatu kye n’agasiiga mu mutwe gw’oyo ajja okufuulibwa omulongoofu, n’amutangiririra awali Mukama. ");
INSERT INTO lug_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Kabona anaawangayo ekiweebwayo olw’ekibi, atangiririre oyo atali mulongoofu ajja okufuulibwa omulongoofu. Oluvannyuma kabona anattanga ekiweebwayo ekyokebwa, ");
INSERT INTO lug_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","n’akiwaayo ku kyoto awamu n’ekiweebwayo eky’emmere ey’empeke. Bw’atyo kabona anaatangiririranga omuntu oyo, n’afuuka mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Naye omuntu oyo bw’anaabanga omwavu ng’ebyo byonna tabisobola, anaaleetanga omwana gw’endiga omulume gumu okuba ekiweebwayo olw’omusango, ne kiwuubibwa okumutangiririranga, okwo n’agattirako ne kimu kya kkumi ekya efa eky’obuwunga obulungi ennyo obutabikiddwa mu mafuta, nga kye kiweebwayo eky’emmere y’empeke, n’agattako n’epakuli y’amafuta ag’omuzeeyituuni; ");
INSERT INTO lug_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","n’amayiba abiri oba enjiibwa ento bbiri, ng’okufuna kwe bwe kunaamusobozesanga; emu eneebanga ya kiweebwayo olw’ekibi, endala nga ya kiweebwayo ekyokebwa. ");
INSERT INTO lug_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Ebyo byonna eby’okumufuula omulongoofu anaabireetanga eri kabona ku lunaku olw’omunaana, ku mulyango gw’Eweema ey’Okukuŋŋaanirangamu, awali Mukama. ");
INSERT INTO lug_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kabona anaddiranga omwana gw’endiga ogw’ekiweebwayo olw’omusango, n’epakuli y’amafuta ag’omuzeeyituuni, n’abiwuuba nga kye kiweebwayo ekiwuubibwawuubibwa awali Mukama. ");
INSERT INTO lug_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Kabona anattanga omwana gw’endiga ogw’ekiweebwayo olw’omusango; n’addira ogumu ku musaayi ogw’ekiweebwayo olw’omusango, n’agusiiga ku lukugiro lw’okutu okwa ddyo okw’oyo anaabanga azze okufuulibwa omulongoofu, era ne ku kinkumu eky’engalo ey’omukono gwe ogwa ddyo, ne ku kigere ekisajja eky’oku kugulu kwe okwa ddyo. ");
INSERT INTO lug_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Kabona anaafukanga agamu ku mafuta mu kibatu ky’omukono gwe ogwa kkono, ");
INSERT INTO lug_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","n’amansira n’olunwe lwe olwa ddyo agamu ku mafuta ago agali mu kibatu ky’omukono gwe ogwa kkono, emirundi musanvu awali Mukama. ");
INSERT INTO lug_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Era kabona anaasiiganga agamu ku mafuta ag’omuzeeyituuni agali mu kibatu ky’omukono gwe ku lukugiro lw’okutu okwa ddyo okw’oyo anaabanga azze okufuulibwa omulongoofu, ne ku kinkumu eky’engalo ey’omukono gwe ogwa ddyo, ne ku kigere ekisajja eky’oku kugulu kwe okwa ddyo, ng’agasiiga kungulu ku musaayi ogw’ekiweebwayo olw’omusango. ");
INSERT INTO lug_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Kabona anaddiranga amafuta ag’omuzeeyituuni aganaabanga gasigadde mu kibatu kye, n’agasiiga ku mutwe gw’oyo anaabanga azze okufuulibwa omulongoofu, okumutangiririra eri Mukama. ");
INSERT INTO lug_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Era anaawangayo, ng’obusobozi bwe gye bunaakomanga, amayiba oba enjiibwa ento, ");
INSERT INTO lug_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ekinyonyi ekimu ng’ekiweebwayo olw’ekibi n’ekyokubiri ng’ekiweebwayo ekyokebwa, ng’agattirako n’ekiweebwayo eky’emmere ey’empeke. Kabona anaamutangiririranga oyo anaabanga azze okufuulibwa omulongoofu eri Mukama. ");
INSERT INTO lug_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ago ge mateeka aganaagobererwanga omuntu omugenge anaabanga tasobola biweebwayo ebya bulijjo, alyoke afuuke omulongoofu.” ");
INSERT INTO lug_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Mukama n’agamba Musa ne Alooni nti, ");
INSERT INTO lug_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Bwe muliyingira mu nsi ya Kanani gye mbawadde okugirya, ne musanga nga ntadde ebigenge mu emu ku nnyumba ez’omu nsi eyo, ");
INSERT INTO lug_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","kale, oyo anaabanga nannyini nnyumba eyo anajjanga n’ategeeza kabona nti, ‘Mu nnyumba yange mufaanana ng’omuli obulwadde.’ ");
INSERT INTO lug_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Kabona anaalagiranga ne bafulumya ebintu byonna ebiri mu nnyumba ne babimalamu, nga tannaba kuyingiramu kukebera obulwadde obwo nga bwe buli, si kulwa nga byonna ebiri mu nnyumba biyitibwa ebitali birongoofu. Ekyo nga kiwedde kabona anaayingiranga mu nnyumba n’agikebera. ");
INSERT INTO lug_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Anaanoonyanga obulwadde we buli; bw’anaabusanganga ku bisenge by’ennyumba eyo, nga kuliko amabala aga kiragalalagala oba amamyukirivu, era nga galabika gayingidde munda mu mubiri gw’ekisenge, ");
INSERT INTO lug_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","olwo kabona anaafulumanga mu nnyumba eyo, n’agiggala okumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ku lunaku olw’omusanvu kabona anaakomangawo n’akebera ennyumba eyo. Bw’anaasanganga ng’obulwadde busaasaanidde ku bisenge by’ennyumba eyo, ");
INSERT INTO lug_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","kale, anaalagiranga ne basokoola mu bisenge amayinja gonna agaliko obulwadde ne bagasuula ebweru w’ekibuga mu kifo ekitali kirongoofu. ");
INSERT INTO lug_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Era anaalagiranga ebisenge byonna eby’omu nnyumba eyo ne bikalakatibwa, ebintu byonna ebikalakatibbwako ne bisuulibwa ebweru w’ekibuga mu kifo ekitali kirongoofu. ");
INSERT INTO lug_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Era banaddiranga amayinja amalala ne bagazimba mu bifo by’agali agaggyibwamu, ne batabula bulungi omusenyu, ennyumba yonna n’ekubibwa omusenyu. ");
INSERT INTO lug_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Singa obulwadde buddamu okuzuuka, oluvannyuma lw’ennyumba okugiggyamu amayinja gali, n’okugikalakata era n’okugikubako omusenyu omuggya, ");
INSERT INTO lug_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","kale, kabona anaagendangayo ne yeetegereza; bw’anaasanganga ng’obulwadde busaasaanye mu nnyumba, ng’ebyo bigenge bye biri mu nnyumba, era nga si nnongoofu. ");
INSERT INTO lug_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Anaalagiranga ennyumba eyo n’emenyebwawo, amayinja gaayo n’embaawo zaayo n’omusenyu ogwagikubwako, byonna binaasitulwanga ne bisuulibwa ebweru w’ekibuga mu kifo ekitali kirongoofu. ");
INSERT INTO lug_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Ennyumba eyo bw’eneebanga tennamenyebwawo, omuntu yenna anaayingiranga mu nnyumba eyo mu kiseera ky’eneemalanga nga nzigale anaabanga si mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","N’omuntu yenna anaasulanga mu nnyumba eyo oba anaaliirangamu, anaayozanga engoye ze. ");
INSERT INTO lug_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Naye kabona bw’anajjanga n’akebera mu nnyumba eyo ng’emaze okukubibwako omusenyu, n’asanga ng’obulwadde tebwasaasaana; kale, kabona anaalangiriranga ng’ennyumba eyo bw’eri ennongoofu, kubanga olwo ng’obulwadde bugenze. ");
INSERT INTO lug_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Okufuula ennyumba ennongoofu kabona anaddiranga ebinyonyi bibiri n’akabaawo k’omuti omwerezi, n’ekiwero ekimyufu n’ezobu. ");
INSERT INTO lug_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Anattiranga ekimu ku binyonyi mu mazzi amalungi mu kibya eky’ebbumba. ");
INSERT INTO lug_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Awo anaddiranga akabaawo k’omuti omwerezi n’ezobu, n’ekiwero ekimyufu, n’ekinyonyi ekikyali ekiramu, n’abinnyika mu musaayi gw’ekinyonyi ekyattiddwa ne mu mazzi amalungi, n’alyoka amansira ennyumba yonna emirundi musanvu. ");
INSERT INTO lug_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ennyumba anaagifuulanga ennongoofu n’omusaayi gw’akanyonyi, n’amazzi amalungi, n’akanyonyi akalamu, n’akabaawo k’omuti omwerezi, n’ezobu n’ekiwero ekimyufu. ");
INSERT INTO lug_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Awo n’afulumya ekinyonyi ekiramu ebweru w’ekibuga n’akiteera eyo ne kibuuka ne kigenda. Mu ngeri eyo anaatangiririranga ennyumba eyo era eneebanga nnongoofu.” ");
INSERT INTO lug_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ago ge mateeka aganaagobererwanga ku bulwadde bw’ebigenge, omubiri ogusiiwa, ");
INSERT INTO lug_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ebigenge mu ngoye oba mu nnyumba, ");
INSERT INTO lug_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","oba okubutukabutuka, oba obutulututtu, ");
INSERT INTO lug_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","okusinziirako okutegeera obanga ekintu kirongoofu oba si kirongoofu. Ago ge mateeka ku bigenge. ");
INSERT INTO lug_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Awo Mukama n’agamba Musa ne Alooni nti, ");
INSERT INTO lug_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Mugambe abaana ba Isirayiri nti omusajja yenna bw’anaavangamu ebitonnya mu bitundu bye ebyekyama, ebimuvaamu ebyo binaabanga ebitali birongoofu. ");
INSERT INTO lug_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Era lino ly’etteeka ery’obutali bulongoofu bwe obuleeteddwa ebyo ebimuvaamu: obanga bitonnya obutasalako, obanga birekeddaawo, bunaabanga obutali bulongoofu mu musajja oyo. ");
INSERT INTO lug_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“Buli kitanda omusajja oyo alina ebimuvaamu ky’anaasulangako kinaabanga si kirongoofu, ne buli kintu ky’anaatuulangako kyonna kinaabanga si kirongoofu. ");
INSERT INTO lug_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Omuntu yenna anaakwatanga ku kitanda ky’omusajja oyo naye anaafuukanga atali mulongoofu okutuusiza ddala akawungeezi, era anaateekwanga okwoza engoye ze n’okunaaba mu mazzi. ");
INSERT INTO lug_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Omuntu yenna anaatuulanga ku kintu kyonna omusajja oyo alina ebimuvaamu kw’anaabanga amaze okutuula, anaafuukanga atali mulongoofu okutuusa akawungeezi, era anaateekwanga okwoza engoye ze n’okunaaba mu mazzi. ");
INSERT INTO lug_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Era omuntu yenna anaakwatanga ku musajja oyo alina ebimuvaamu, anaafuukanga atali mulongoofu okutuusa akawungeezi, era anaateekwanga okwoza engoye ze n’okunaaba mu mazzi. ");
INSERT INTO lug_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Omusajja oyo alina ebimuvaamu bw’anaawandanga amalusu ku muntu omulongoofu, omuntu oyo anaafuukanga atali mulongoofu okutuusa akawungeezi, era anaateekwanga okwoza engoye ze n’okunaaba mu mazzi. ");
INSERT INTO lug_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Era n’amatandiiko gonna omusajja oyo alina ebimuvaamu kw’aneebagaliranga ganaabanga agatali malongoofu, ");
INSERT INTO lug_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","era n’omuntu anaakwatanga ku kintu ekirala kyonna ekinaabanga wansi w’omusajja oyo anaafuukanga atali mulongoofu okutuusa akawungeezi, era anaateekwanga okwoza engoye ze n’okunaaba mu mazzi. ");
INSERT INTO lug_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Omuntu yenna, omusajja oyo alina ebimuvaamu gw’anaakwatangako nga tasoose kunaaba mu ngalo mu mazzi anaafuukanga atali mulongoofu okutuusa akawungeezi, era anaateekwanga okwoza engoye ze n’okunaaba mu mazzi. ");
INSERT INTO lug_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ekibumbe kyonna ekikozesebwa mu maka bwe kinaakwatibwangako omusajja oyo alina ebimuvaamu kinaayasibwanga, na buli ekikozesebwa mu maka eky’omuti kinaanaazibwanga mu mazzi. ");
INSERT INTO lug_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Omusajja anaabanga alina ebimuvaamu bw’anaafuulibwanga omulongoofu, aneebaliranga ennaku musanvu ez’okufuulibwa omulongoofu; anaateekwanga okwoza engoye ze n’okunaaba omubiri gwe mu mazzi amayonjo agakulukuta, bw’atyo anaafuukanga mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ku lunaku olw’omunaana kinaamusaaniranga okuddira amayiba abiri oba enjiibwa ento bbiri n’ajja awali Mukama mu mulyango gw’Eweema ey’Okukuŋŋaanirangamu n’abikwasa kabona. ");
INSERT INTO lug_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kabona anaabiwangayo, ekimu nga kye kiweebwayo olw’ekibi n’ekirala nga kye kiweebwayo ekyokebwa. Mu ngeri eyo kabona anaatangiririranga omusajja oyo olw’ebimuvaamu eri Mukama. ");
INSERT INTO lug_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Omusajja bw’anaavangamu amazzi g’obusajja anaateekwanga okunaaba omubiri gwe n’amazzi, era anaasigalanga nga si mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Buli lugoye olwambalwa oba eddiba nga kuliko amazzi g’obusajja, binaateekwanga okwozebwa mu mazzi, era binaabanga ebitali birongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Omusajja bw’aneebakanga n’omukazi, ne wabaawo amazzi g’obusajja agafulumizibbwa, bombi banaanaabanga mu mazzi agatukula, era banaabeeranga abatali balongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Omukazi bw’anaavangamu omusaayi ng’empisa ye eya bulijjo eya buli mwezi bw’eba, anaabeeranga atali mulongoofu okumala ennaku musanvu, ne buli anaamukwatangako anaabeeranga atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Mu bbanga eryo ng’omukazi oyo si mulongoofu buli kintu kyonna ky’anaagalamirangako kinaabanga ekitali kirongoofu, ne buli kintu kyonna ky’anaatuulangako kinaabanga ekitali kirongoofu. ");
INSERT INTO lug_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Era buli anaakwatanga ku kitanda kye kinaamusaaniranga okwoza engoye ze, n’okunaaba mu mazzi, era anaabeeranga atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Buli anaakwatanga ku kintu kyonna omukazi oyo ky’atuulako, anaateekwanga okwoza engoye ze n’okunaaba omubiri gwe mu mazzi, era anaabeeranga atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Bwe kinaabanga ekitanda oba ekintu ekirala kyonna omukazi oyo ky’anaabanga atuddeko, omuntu bw’anaakikwatangako anaabeeranga atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Omusajja bw’aneebakanga n’omukazi oyo, omusaayi gw’omukazi ogumuvaamu ogwa buli mwezi ne gumutonnyako, anaabeeranga atali mulongoofu okumala ennaku musanvu; n’ekitanda kw’anaagalamiranga nakyo kinaabanga ekitali kirongoofu. ");
INSERT INTO lug_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Omukazi bw’anaavangamu omusaayi okumala ennaku nnyingi mu biseera ebitali ebyo ebya buli mwezi nga bwe kiba bulijjo, oba bw’anaavangamu omusaayi okumala ennaku ezisukka ku za bulijjo eza buli mwezi, anaabeeranga atali mulongoofu mu bbanga ly’anaamalanga ng’avaamu omusaayi, nga mu biseera bye ebya buli mwezi. ");
INSERT INTO lug_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Buli kitanda ky’anaagalamirangako ng’omusaayi gukyamuvaamu kinaabeeranga ekitali kirongoofu, ng’ekitanda kye bwe kiba mu biseera bye ebya buli mwezi eby’okuvaamu omusaayi, era ne buli kintu ky’anaatuulangako kinaabanga ekitali kirongoofu nga bwe kiba mu biseera bye ebya buli mwezi. ");
INSERT INTO lug_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Buli muntu anaakwatanga ku bintu ebyo anaabeeranga atali mulongoofu; kinaamusaaniranga okwoza engoye ze, n’okunaaba omubiri gwe mu mazzi, era anaabeeranga atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Naye omukazi oyo avaamu omusaayi bw’anaafuulibwanga omulongoofu, aneebaliranga ennaku musanvu, N’oluvannyuma lwazo anaabeeranga mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ku lunaku olw’omunaana kinaamusaaniranga okuddira amayiba abiri, oba enjiibwa ento bbiri n’ajja awali Mukama ku mulyango gw’Eweema ey’Okukuŋŋaanirangamu n’abikwasa kabona. ");
INSERT INTO lug_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kabona anaawangayo ekimu nga kye kiweebwayo olw’ekibi, n’ekirala nga kye kiweebwayo ekyokebwa. Mu ngeri eyo kabona anaatangiriranga omukazi oyo eri Mukama olw’ekitali kirongoofu ekimuvaamu. ");
INSERT INTO lug_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Bwe mutyo bwe munaakugiranga abaana ba Isirayiri balemenga okusemberera ebintu ebibafuula abatali balongoofu, balemenga okufa olw’obutali bulongoofu bwabwe okuboonoonyesa Eweema ya Mukama eri wakati mu bo. ");
INSERT INTO lug_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","“Ago ge mateeka ku musajja alina ebimuvaamu mu bitundu bye eby’ekyama, n’oyo avaamu amazzi g’obusajja; ");
INSERT INTO lug_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ne ku mukazi anaavangamu omusaayi ng’empisa y’abakazi eya bulijjo eya buli mwezi bw’eba. Amateeka ago ganaakwatanga ku musajja oba ku mukazi alina ebimuvaamu, ne ku musajja aneebakanga n’omukazi atali mulongoofu.” ");
INSERT INTO lug_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Awo Mukama n’ayogera ne Musa, abaana ba Alooni ababiri bwe baali bamaze okufa olwokubanga baasemberera Mukama. ");
INSERT INTO lug_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Mukama n’agamba Musa nti, “Tegeeza muganda wo Alooni alemenga okujja buli w’anaayagaliranga, mu kifo Awatukuvu ekiri munda w’eggigi, okutunuulira entebe ey’okusaasira eri ku Ssanduuko ey’Endagaano; bw’alikikola talirema kufa; kubanga nzijanga kulabikira mu kire nga kiri waggulu w’entebe ey’okusaasira. ");
INSERT INTO lug_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Naye Alooni bw’anaabanga ajja mu kifo Awatukuvu anaaleetanga ennyana ennume olw’ekiweebwayo olw’ekibi, n’endiga ennume olw’ekiweebwayo ekyokebwa. ");
INSERT INTO lug_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Anaayambalanga ekkooti entukuvu eya bafuta, ne munda ku mubiri gwe anaasookangako empale eya bafuta, nga yeesibye olukoba olwa bafuta, ne ku mutwe ng’asibyeko ekitambaala ekya bafuta. Ebyambalo ebyo bitukuvu, noolwekyo kimusaaniranga okusooka okunaaba omubiri gwe mu mazzi nga tannabyambala. ");
INSERT INTO lug_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Era anaggyanga mu baana ba Isirayiri embuzi ennume bbiri nga za kiweebwayo olw’ekibi, n’endiga emu nga ya kiweebwayo ekyokebwa. ");
INSERT INTO lug_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Alooni anaawangayo ennyana ennume nga ya kiweebwayo kye olw’ekibi alyoke yeetangiririre awamu n’ab’omu maka ge. ");
INSERT INTO lug_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Era anaddiranga embuzi ebbiri n’azireeta eri Mukama mu mulyango gw’Eweema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Embuzi ebbiri Alooni anaazikubirangako obululu; akalulu akamu nga ka kugwa ku mbuzi ya Mukama, n’akalala nga ka kugwa ku mbuzi enessibwangako omusango. ");
INSERT INTO lug_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Alooni anaddiranga embuzi akalulu ka Mukama kwe kanaagwanga, n’agiwaayo okubeera ekiweebwayo olw’okwonoona. ");
INSERT INTO lug_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Naye embuzi eneegwangako akalulu ak’okugissibyako omusango, eneeweebwangayo eri Mukama nga nnamu, n’eteebwa n’eddukira mu ddungu mu kifo Azazeri ng’esibiddwako omusango olw’okutangirira. ");
INSERT INTO lug_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Alooni anaawangayo ennyana eyo ennume nga ya kiweebwayo kye olw’ekibi, alyoke yeetangiririre awamu n’ab’omu maka ge; ennyana eyo ennume anaagittanga nga kye kiweebwayo kye olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Anaddiranga ekyoterezo ky’obubaane nga kijjudde amanda g’omuliro nga gavudde ku kyoto eri Mukama, n’embatu bbiri ez’obubaane obw’akaloosa obumerunguddwa obulungi, n’abireeta munda w’eggigi. ");
INSERT INTO lug_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Anassanga obubaane ku muliro eri Mukama, n’omukka ogunaavanga mu bubaane gunaabikkanga entebe ey’okusaasira eri kungulu w’Essanduuko ey’Endagaano, alyoke aleme okufa. ");
INSERT INTO lug_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Anaddiranga ku musaayi ogw’ennyana eyo ennume n’agumansira n’olunwe lwe ku ludda olw’ebuvanjuba olw’entebe ey’okusaasira; era omusaayi ogumu anaagumansiranga n’olunwe lwe emirundi musanvu mu maaso g’entebe ey’okusaasira. ");
INSERT INTO lug_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Era anattanga embuzi ey’ekiweebwayo ky’abantu olw’ekibi, n’atwala omusaayi gwayo munda w’eggigi n’agukola nga bwe yakola omusaayi gw’ennyana ennume; anaagumansiranga ku ntebe ey’okusaasira ne mu maaso gaayo. ");
INSERT INTO lug_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Mu ngeri eyo anaatangiririranga Ekifo eky’Awatukuvu Ennyo olw’obutali bulongoofu n’obujeemu eby’abaana ba Isirayiri, n’olw’ebyonoono byabwe ebirala byonna nga bwe byali. Era anaakolanga bw’atyo ne ku Weema ey’Okukuŋŋaanirangamu eri mu bo wakati mu butali bulongoofu bwabwe. ");
INSERT INTO lug_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Mu Weema ey’Okukuŋŋaanirangamu temuubengamu muntu n’omu Alooni bw’anaayingirangamu okutangiririra Ekifo eky’Awatukuvu Ennyo, okutuusa lw’anaafulumanga ng’amaze okwetangiririra awamu n’ab’omu maka ge, n’ekibiina kyonna ekya Isirayiri. ");
INSERT INTO lug_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Era anaafulumanga n’ajja ku kyoto ekiri awali Mukama n’akitangiririra. Anaddiranga ku musaayi gw’ennyana eya seddume ne ku musaayi gw’embuzi n’agusiiga ku mayembe gonna ag’ekyoto. ");
INSERT INTO lug_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ku musaayi ogwo anaamansirangako ku kyoto n’olunwe lwe emirundi musanvu okukifuula ekirongoofu n’okukitukuza okukiggya mu butali bulongoofu obw’abaana ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Awo Alooni bw’anaamalanga okutangiririra Ekifo eky’Awatukuvu Ennyo, n’Eweema ey’Okukuŋŋaanirangamu, n’ekyoto, anaaleetanga embuzi ennamu. ");
INSERT INTO lug_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Anaateekanga emikono gye gyombi ku mutwe gw’embuzi eyo ennamu n’agikwatako, n’agyenenyerezaako ebyonoono by’abaana ba Isirayiri, n’obujeemu bwabwe, n’ebibi byabwe byonna, ng’abitadde ku mutwe gw’embuzi eyo. Embuzi anaagisindikanga mu ddungu ng’etwalibwa omusajja anaalondebwanga okukola omulimu ogwo. ");
INSERT INTO lug_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Embuzi eyo eneetikkanga ebyonoono by’abaana ba Isirayiri byonna n’ebitwala mu kifo eteri bantu, eyo omusajja oyo gy’anaagiteeranga n’eraga mu ddungu. ");
INSERT INTO lug_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Alooni anaayingiranga mu Weema ey’Okukuŋŋaanirangamu, ne yeeyambulamu ebyambalo ebya bafuta bye yayambadde nga tannayingira mu Kifo eky’Awatukuvu Ennyo, era naabirekanga awo. ");
INSERT INTO lug_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Anaanaabiranga omubiri gwe mu mazzi nga gali mu kifo ekitukuvu, n’alyoka ayambala ebyambalo bye ebya bulijjo. Anaafulumanga n’awaayo ekiweebwayo kye ekyokebwa ku lulwe, n’ekiweebwayo ekyokebwa olw’abantu bonna, alyoke yeetangiririre era n’abantu abatangiririre. ");
INSERT INTO lug_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Era n’amasavu ag’ekiweebwayo olw’ekibi anaagookeranga ku kyoto. ");
INSERT INTO lug_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Omusajja anaatanga embuzi esibiddwako omusango, eraze mu Azazeri mu ddungu, kinaamugwaniranga okwoza engoye ze n’okunaaba omubiri gwe n’amazzi; oluvannyuma anaakomangawo mu lusiisira. ");
INSERT INTO lug_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ennyana ennume n’embuzi ennume ez’okuwaayo olw’ebiweebwayo olw’ekibi, era omwava omusaayi ogwaleetebwa mu Kifo eky’Awatukuvu Ennyo olw’okutangiririra, ziteekwa okufulumizibwa ebweru w’olusiisira, amaliba gaazo n’ennyama yaazo eriibwa n’eyo eteriibwa, zonna binaayokebwanga. ");
INSERT INTO lug_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Oyo anaazokyanga anaateekwanga okwoza engoye ze, n’okunaaba omubiri gwe mu mazzi; oluvannyuma anaakomangawo mu lusiisira. ");
INSERT INTO lug_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Etteeka lino munaalikwatanga emirembe gyonna: Ku lunaku olw’ekkumi mu mwezi ogw’omusanvu muneelesanga eby’amasanyu byonna n’emirimu gyammwe gyonna, temuukolerengako mulimu gwonna mmwe bannannyini nsi era n’abagwira ababeera mu mmwe, ");
INSERT INTO lug_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","kubanga ku lunaku olwo mulitangiririrwa ne mufuulibwa abalongoofu. Bwe mutyo munaabeeranga muvudde mu byonoono byammwe ne mufuulibwa balongoofu mu maaso ga Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Lunaabanga ssabbiiti nga lwa kuwummula; era kibasaanira okwefiisanga bye mwandiyagadde; etteeka eryo linaabanga lya mirembe gyonna. ");
INSERT INTO lug_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Kabona eyafukibwako amafuta ag’omuzeeyituuni era ng’ayawulibbwa n’asikira kitaawe, y’anaatangiririranga. Anaayambalanga ebyambalo ebya linena ebitukuvu, ");
INSERT INTO lug_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","n’atangiririra Ekifo Awatukuvu Ennyo, n’atangiririra n’Eweema ey’Okukuŋŋaanirangamu, n’atangiririra n’ekyoto, ne bakabona awamu n’abantu bonna mu kibiina kyonna. ");
INSERT INTO lug_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Etteeka eryo linaababeereranga lya mirembe gyonna, ng’okutangiririra okwo kukolebwa omulundi gumu buli mwaka olw’ebyonoono byonna eby’abaana ba Isirayiri.” Awo byonna ne bikolebwa nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Tegeeza Alooni ne batabani be n’abaana ba Isirayiri bonna, obagambe nti, Kino Mukama ky’alagidde: ");
INSERT INTO lug_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Omuntu yenna Omuyisirayiri anaawangayo ekiweebwayo eky’ente, oba endiga ento, oba embuzi, munda mu lusiisira oba ebweru w’olusiisira, ");
INSERT INTO lug_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","nga tagireese ku mulyango gw’Eweema ey’Okukuŋŋaanirangamu, okugiwaayo ng’ekirabo ekiweebwayo eri Mukama Katonda mu kisasi ky’Eweema ya Mukama; omuntu oyo anaabanga azzizza omusango ogw’okuyiwa omusaayi; olwokubanga ayiye omusaayi, anaagobwanga n’agaanibwa okukolagananga ne banne. ");
INSERT INTO lug_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ekyo kiri bwe kityo abaana ba Isirayiri balyoke balekeraawo okuweerangayo ebiweebwayo byabwe ebweru mu nnimiro, naye babireetenga awali Mukama Katonda. Kibagwanira okubireetanga eri Mukama babikwasenga kabona ku mulyango gw’Eweema ey’Okukuŋŋaanirangamu, ne biryoka bittibwa nga bye biweebwayo eri Mukama olw’emirembe. ");
INSERT INTO lug_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Kabona anaamansiranga omusaayi ku kyoto kya Mukama ku mulyango gw’Eweema ey’Okukuŋŋaanirangamu, amasavu n’agookya ne muvaamu akaloosa akalungi akasanyusa Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Tebasaana kwongera kuwangayo biweebwayo byabwe eri bakatonda be beekoledde mu kifaananyi ky’embuzi, be bakola nabyo eby’obwamalaaya. Eryo linaabanga tteeka lyabwe lya lubeerera n’okuyita mu mirembe egigenda okuddawo. ");
INSERT INTO lug_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Era bagambe nti, Buli muntu yenna Omuyisirayiri, oba omunnaggwanga yenna abeera mu bo, aliwaayo ekiweebwayo ekyokebwa, oba ekiweebwayo eky’engeri yonna, ");
INSERT INTO lug_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","nga takireese ku mulyango gw’Eweema ey’Okukuŋŋaanirangamu, okukiwaayo eri Mukama Katonda, omuntu oyo anaagobwanga n’agaanibwa okukolagananga ne banne. ");
INSERT INTO lug_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Omuntu yenna Omuyisirayiri oba ow’omu bannamawanga ababeera mu Isirayiri bw’anaalyanga omusaayi ogw’engeri yonna, nnaamunyiigiranga oyo anaalyanga omusaayi, era nnaamugobanga ne mugaana okukolagananga ne banne. ");
INSERT INTO lug_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Kubanga obulamu bw’ekitonde buli mu musaayi, ate nkibawadde okubatangiririra ku kyoto; omusaayi gwe gutangiririra obulamu bw’omuntu. ");
INSERT INTO lug_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Noolwekyo Abayisirayiri mbagamba nti tewabanga n’omu mu mmwe anaalyanga omusaayi, era ne munnaggwanga abeera mu mmwe naye taalyenga musaayi. ");
INSERT INTO lug_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Omuyisirayiri yenna, oba omunnaggwanga abeera mu mmwe, bw’anaayigganga ensolo oba ennyonyi nga ya kulya, anaagikenenulangamu omusaayi n’agubikkako ettaka, ");
INSERT INTO lug_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","kubanga obulamu bwa buli kitonde gwe musaayi gwakyo. Abayisirayiri kyenvudde mbagamba nti temulyanga musaayi gwa kitonde eky’engeri yonna, kubanga obulamu bwa buli kitonde gwe musaayi gwakyo, omuntu yenna anaagulyanga anaagobwanga n’agaanibwa okukolagana ne banne. ");
INSERT INTO lug_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Omuntu yenna omuzaaliranwa oba omunnaggwanga anaalyanga ekintu kyonna ekinaabanga kisangiddwa nga kifu, oba nga kitaaguddwataaguddwa ensolo enkambwe, anaayozanga ebyambalo bye, n’anaaba mu mazzi, era anaabeeranga atali mulongoofu okutuusa akawungeezi; oluvannyuma anaabeeranga mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Naye bw’ataayozenga byambalo bye, n’okunaaba n’atanaaba, ye anaabanga yeeretedde obutali bulongoofu bwe okumusigalako.” ");
INSERT INTO lug_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Tegeeza abaana ba Isirayiri nti, ‘Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Temusaana kweyisanga mu bikolwa byammwe ng’ab’omu Misiri, gye mwabeeranga, bwe beeyisa, era temusaana kweyisanga ng’ab’omu Kanani, gye mbatwala, bwe beeyisa. Temutambuliranga mu mateeka gaabwe. ");
INSERT INTO lug_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Munaagonderanga ebiragiro byange, munaakwatanga amateeka gange, era mwe munaatambuliranga. Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Mugonderenga ebiragiro byange awamu n’amateeka gange, kubanga buli muntu anaabikwatanga mu byo mwanaatambulizanga obulamu bwe. Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Tewabanga omuntu yenna mu mmwe ajja eri munne gw’alinako oluganda ne yeebaka naye. Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Toleeteranga kitaawo buswavu ng’okola ebyensonyi ne nnyoko. Oyo ye maama wo eyakuzaala, teweebakanga naye ne mukola ebyensonyi, n’omuleetako obuswavu. ");
INSERT INTO lug_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Teweebakanga na muka kitaawo ne mukola ebyensonyi, ekyo kireetera kitaawo obuswavu ne kimumalamu ekitiibwa. ");
INSERT INTO lug_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Teweebakanga na mwannyoko, azaalibwa kitaawo, oba azaalibwa nnyoko, ne bwe muba nga mwakulira mu maka gamu oba nga temwakulira wamu, tomukolangako bya nsonyi okumuleetera obuswavu. ");
INSERT INTO lug_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Teweebakanga na muwala azaalibwa mutabani wo, oba muwala w’omwana wo omuwala, n’okola naye ebyensonyi; ekyo ne kikuleetako obuswavu. ");
INSERT INTO lug_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Teweebakanga na mwana wa muka kitaawo ow’obuwala eyazaalibwa kitaawo n’omukolako ebyensonyi; oyo mwannyoko. Tomuleeteranga bya buswavu. ");
INSERT INTO lug_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Teweebakanga na mwannyina wa kitaawo n’okola naye ebyensonyi; oyo ne kitaawo ba musaayi gwe gumu. ");
INSERT INTO lug_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Teweebakanga na muwala bwe bazaalibwa ne nnyoko n’okola naye ebyensonyi; kubanga oyo ne nnyoko ba musaayi gwe gumu. ");
INSERT INTO lug_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Toweebuulanga muganda wa kitaawo, ng’olaga eri mukazi we weebake naye mukole ebyensonyi; oyo maama wo omuto. ");
INSERT INTO lug_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Teweebakanga na muka mutabani wo ne mukola ebyensonyi; kubanga oyo ye mukyala wa mutabani wo; tomuleeteranga bya buswavu. ");
INSERT INTO lug_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Teweebakanga na muka muganda wo ne mukola ebyensonyi, kubanga ekyo kinaaleeteranga muganda wo obuswavu. ");
INSERT INTO lug_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Teweebakanga na mukazi ate ne muwala we n’okola nabo ebyensonyi. Era teweebakanga na mwana muwala owa mutabani wa mukazi oyo oba na mwana muwala owa muwala we; kubanga abo ba musaayi gwe gumu n’ogw’omukazi oyo. Ekyo kibi kinene. ");
INSERT INTO lug_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Toleetanga mukazi nga muganda wa mukyala wo ne badda mu kuvuganya, era ne weebaka naye ne mukola ebyensonyi nga mukyala wo akyali mulamu. ");
INSERT INTO lug_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Tosembereranga mukazi ng’oyagala weebake naye omukoleko ebyensonyi ng’ali mu kiseera kye ekya buli mwezi eky’okuvaamu omusaayi mw’abeerera atali mulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Teweebakanga na mukyala wa munnansi yammwe okumukolako ebyensonyi, n’akuleetera obutali bulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Mu baana bo towangayo n’omu ng’ekiweebwayo ekyokeddwa mu muliro eri Moleki, kubanga erinnya lya Katonda wo tosaanira kuliweebuulanga. Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Teweebakanga na musajja nga bwe wandyebase n’omukazi, ekyo kibi ekikyayibwa ennyo. ");
INSERT INTO lug_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Tokolanga bya nsonyi ku nsolo kubanga ekyo kinaakufuulanga atali mulongoofu. Omukazi teyeewangayo eri ensolo emukoleko ebyensonyi, okwo kwe kuwabira ddala. ");
INSERT INTO lug_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Temwereetangako obutali bulongoofu nga mugoberera amayisa ago amabi; kubanga n’amawanga ge ŋŋenda okugoba mu nsi mwe mujja okuyingira bwe geefuula bwe gatyo agatali malongoofu; ");
INSERT INTO lug_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","n’ensi n’efuuka etali nnongoofu, ne ngibonereza olw’ebyonoono byayo, n’abantu baamu abagibeeramu n’ebasesema. ");
INSERT INTO lug_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Naye mmwe mukuumenga ebiragiro byange n’amateeka gange. Abazaaliranwa ne bannamawanga abali mu mmwe tewabanga n’omu anaakolanga ku bintu ebyo n’akatono ebikyayibwa ennyo bwe bityo. ");
INSERT INTO lug_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Kubanga ebintu ebyo byonna byakolebwanga abantu abaabasooka mmwe okubeera mu nsi omwo, ensi n’efuuka etali nnongoofu. ");
INSERT INTO lug_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Ensi eyo bwe muligifuula etali nnongoofu, egenda kubasesema nga bwe yasesema amawanga agaabasooka okugibeeramu. ");
INSERT INTO lug_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Abantu bonna abanaakolanga ebintu ebyo ebibi ebikyayibwa ennyo, abantu ng’abo banaagobwanga ne bagaanibwa okukolagana ne bannaabwe. ");
INSERT INTO lug_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Mukwatenga amateeka gange, nga mwewalanga okukola ebyonoono ebyo ebikyayibwa eby’amayisa amabi, abo abaabasooka ge beeyisanga si kulwa nga gabafuula abatali balongoofu. Nze Mukama Katonda wammwe.’ ” ");
INSERT INTO lug_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Awo Mukama Katonda n’agamba Musa ");
INSERT INTO lug_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","ategeeze ekibiina kyonna eky’abaana ba Isirayiri abagambe nti, “Mubeerenga batukuvu, kubanga nze Mukama Katonda wammwe ndi mutukuvu. ");
INSERT INTO lug_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“Buli omu mu mmwe assengamu nnyina ne kitaawe ekitiibwa; era mukuumenga Ssabbiiti zange. Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Temulaganga mu bitali Katonda, era temwekoleranga bakatonda abaweese mu kyuma ekisaanuuse. Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Bwe munaawangayo eri Mukama ekiweebwayo olw’emirembe, mukiwengayo mu butuufu kiryoke kikkirizibwe. ");
INSERT INTO lug_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Kinaalibwanga ku lunaku olwo lwe kinaaweebwangayo oba enkeera; ekinaabanga kisigaddewo okutuusa ku lunaku olwokusatu kinaazikiribwanga mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Singa kiriibwa ku lunaku olwokusatu tekiibenga kirongoofu, era tekikkirizibwenga, ");
INSERT INTO lug_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ne buli anaakiryangako anaabanga azzizza omusango; kubanga anaabeeranga aweebudde ekintu kya Mukama ekitukuvu; omuntu oyo anaagobwanga n’agaanibwa okukolagananga ne banne. ");
INSERT INTO lug_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Bw’okungulanga ekyengera eky’omu ttaka lyo, tokunguliranga ddala ebibala byonna eby’omu nnimiro yo okutuuka ku nkomerero zaayo, oba okukuŋŋaanya obubala obutonotono obunaabanga bugudde wansi ng’okungula. ");
INSERT INTO lug_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ennimiro yo ey’emizabbibu togimalirangamu ddala bibala byonna, n’ebyo ebibanga bigudde wansi tobikuŋŋaanyanga. Obirekeranga abaavu ne bannamawanga. Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Tobbanga. “Tokumpanyanga. “Temulimbagananga. ");
INSERT INTO lug_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“Tokozesanga linnya lyange ng’olayira ebitaliimu nsa, n’ovumisa erinnya lya Katonda wo. Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Muliraanwa wo tomujooganga so tomunyagangako bibye. “Tosulanga na mpeera ya mupakasi wo n’omala nayo ekiro kyonna okutuusa enkya nga tonnagimusasula. ");
INSERT INTO lug_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“Omuggavu w’amatu tomukolimiranga, so n’omuzibe w’amaaso tomuteganga nkonge w’anaayita, naye otyanga Katonda wo. Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Tosalirizanga ng’olamula; tobanga na kyekubiira ku ludda lw’omwavu wadde okwekubiira ku ludda lw’ow’ekitiibwa, banno obasalirangawo mu bwenkanya. ");
INSERT INTO lug_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“Togendanga ng’osaasaanya eŋŋambo mu banno. “Tokolanga kintu kyonna ku munno ekiyinza okumuleetera okufiirwa obulamu bwe. Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Muganda wo tomukyawanga mu mutima gwo. Naye munno ng’asobezza, omunenyanga, si kulwa nga naawe ogwa mu kibi nga ye. ");
INSERT INTO lug_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“Towalananga ggwanga oba okusiba ekiruyi ku mwoyo eri munno yenna ow’omu nsi yo, naye yagalanga muliraanwa wo nga bwe weeyagala wekka. Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Okwatanga amateeka gange. “Tokkirizanga nsolo za ngeri ndala kuzaazisa mu nsolo zo. “Mu nnimiro yo tosimbangamu nsigo za ngeri bbiri. “Toyambalanga kyambalo eky’olugoye olw’ebiwero eby’engeri ebbiri. ");
INSERT INTO lug_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Omusajja bw’aneebakanga n’omuddu omukazi n’amusobyako, naye ng’omukazi oyo tannaweebwa ddembe lye, kyokka ng’aliko omusajja amwogereza, wanaabangawo okuwozesebwa n’ebibonerezo, naye tebattibwenga, kubanga omukazi anaabanga tannaweebwa ddembe lye. ");
INSERT INTO lug_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Naye omusajja anaaleetanga endiga ennume ku mulyango gwa Weema ey’Okukuŋŋaanirangamu, nga ky’ekiweebwayo kye eri Mukama eky’omusango. ");
INSERT INTO lug_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kabona anaakozesanga endiga ennume ey’ekiweebwayo olw’omusango okutangiririra omusajja oyo eri Mukama; era ekibi kye ky’anaabanga akoze kinaamusonyiyibwanga. ");
INSERT INTO lug_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Bwe muyingiranga mu nsi ne musimba emiti egya buli ngeri egy’ebibala ebyokulya, mukitegeere nti ebibala byagyo biriba ng’ebiwereddwa. Biriwerebwa okumala emyaka esatu; tebijjanga kuliibwanga. ");
INSERT INTO lug_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mu mwaka ogwokuna ebibala byako byonna binaabanga bitukuvu, nga kye kiweebwayo eri Mukama eky’okumutendereza. ");
INSERT INTO lug_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Naye mu mwaka ogwokutaano munaayinzanga okulya ku bibala byako. Mu ngeri eno ebibala byako bigenda kweyongeranga nnyo. Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Tolyanga nnyama yonna nga teweddeemu musaayi; “so tokolanga bya ddogo wadde eby’okulagula. ");
INSERT INTO lug_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“Enviiri ez’oku mabbali g’omutwe gwo tozisalangako; n’ekirevu kyo tokikomolanga. ");
INSERT INTO lug_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“Toweesalanga misale ku mubiri gwo olw’okujjukira abaafa oba okwesalako enjola. Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Tofuulanga mwana wo omuwala ekivume ng’omufudde omwenzi, kubanga kirireetera abantu mu nsi yo okufuuka abenzi, n’ensi n’ejjula okwonoona. ");
INSERT INTO lug_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“Mukuumanga Ssabbiiti zange era mussangamu ekitiibwa ekifo kyange ekitukuvu. Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Temwebuuzanga ku basamize oba okukyukiranga abalogo, kubanga bagenda kubaleetera okwonooneka. Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Ositukiranga ow’envi, n’omukadde omussangamu ekitiibwa, era ne Katonda wo omutyanga. Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Omugwira bw’abeeranga omutuuze mu nsi yammwe, temumuyisanga bubi. ");
INSERT INTO lug_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Omugwira atuula mu mmwe mumuyisenga ng’omuzaaliranwa ow’omu nsi yammwe. Mumwagalenga nga bwe mweyagala, kubanga nammwe mwali bagwira mu nsi y’e Misiri. Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Temubangamu kyekubiira nga mupima obuwanvu, oba obuzito, oba obungi bw’ebintu. ");
INSERT INTO lug_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Mubanga ne minzaani entuufu, n’amayinja agapima obuzito amatuufu, n’ekipima ebikalu (efa) ekituufu, n’ekipima ebiyiikayiika ng’amazzi (ini) ekituufu. Nze Mukama Katonda wammwe, eyabaggya mu nsi y’e Misiri. ");
INSERT INTO lug_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“Munaakwatanga amateeka gange gonna, n’ebiragiro byange byonna, okubitambulirangako. Nze Mukama.” ");
INSERT INTO lug_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Tegeeza abaana ba Isirayiri bw’oti nti, Omuyisirayiri yenna, oba omunnaggwanga atuula mu Isirayiri, bw’anaawangayo omwana we ng’ekiweebwayo eri Moleki, kitaawe w’omwana oyo ajjanga kuttibwa. Abantu ab’omu kitundu ekyo mw’abeera banaamukubanga amayinja. ");
INSERT INTO lug_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Nange kennyini, omuntu oyo nnaamunyiigiranga, era nnaamugobanga ne mmugaana okukolagananga ne banne, kubanga awaddeyo omu ku baana be ng’ekiweebwayo eri Moleki, n’ayonoona Awatukuvu wange era n’avumisa erinnya lyange ettukuvu. ");
INSERT INTO lug_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Era abantu ab’omu kitundu ekyo mw’abeera, bwe banaamuzibiranga ku liiso, omuntu oyo awaddeyo omwana we eri Moleki, ne batamutta, ");
INSERT INTO lug_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","omuntu oyo nnaamunyiigiranga, ne ku b’omu nnyumba ye, ne mbagoba ne mbagaana okukolagananga ne bannaabwe, ye ne banne abakolaganye naye mu kukuba obwamalaaya ne Moleki. ");
INSERT INTO lug_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Omuntu bw’anaakolagananga n’abasamize, n’abalogo, n’akuba nabo obwamalaaya, nnaamunyiigiranga, era nnaamugobanga ne mugaana okukolagana ne banne. ");
INSERT INTO lug_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Noolwekyo mwetukuze mubeerenga batukuvu, kubanga Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Mukwatenga amateeka gange, mugagobererenga. Nze Mukama abatukuza. ");
INSERT INTO lug_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Omuntu yenna anaakolimiranga kitaawe oba nnyina wa kuttibwanga. Noolwekyo akolimidde kitaawe oba nnyina, omusaayi gwe gunaabanga ku mutwe gwe. ");
INSERT INTO lug_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Omusajja bwanaayendanga ku muka omusajja, bombi, omusajja ayenze n’omukazi gw’ayenzeeko banattibwanga. ");
INSERT INTO lug_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Omusajja bw’aneebakanga ne muka kitaawe, anaabanga aweebudde kitaawe. Bombi omusajja n’omukazi banattibwanga; omusaayi gwabwe gunaabanga ku mitwe gyabwe. ");
INSERT INTO lug_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Omusajja bw’aneebakanga ne muka mutabani we, bombi banattibwanga. Kubanga bombi banaabanga bakoze ebyambyone; omusaayi gwabwe gunaabanga ku mitwe gyabwe. ");
INSERT INTO lug_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Omusajja bw’aneebakanga ne musajja munne nga bwe yandyebase n’omukazi, bombi banaabanga bakoze eky’ekivve; era banattibwanga, n’omusaayi gwabwe gunaabanga ku mitwe gyabwe. ");
INSERT INTO lug_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Omusajja bw’anaawasanga omukazi ate n’atwalirako ne nnyina, ekyo kya kivve. Ye n’abakazi bombi banaayokebwanga mu muliro, bwe mutyo ekyonoono ekyo ne mukyegobako. ");
INSERT INTO lug_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Omusajja bw’anaakolanga eby’ensonyi ku nsolo, anattibwanga, era n’ensolo munaagittanga. ");
INSERT INTO lug_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Omukazi bw’anaasembereranga ensolo alyoke akole nayo eby’ensonyi, mumuttanga n’ensolo ne mugitta. Omukazi anattibwanga n’ensolo nettibwa; omusaayi gw’omukazi gunaabanga ku mutwe gwe, n’ogw’ensolo gunaabanga ku mutwe gwayo. ");
INSERT INTO lug_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Omusajja bw’anaawasanga mwannyina, oba nga mwanamuwala wa kitaawe, oba nga mwanamuwala wa nnyina, ne beebaka bombi, kinaabanga kya buwemu. Bombi banaagobwanga mu bannaabwe ne babagaana okukolagananga nabo. Kubanga omusajja oyo anaabanga aweebudde mwannyina, era y’aneetikkanga obuvunaanyizibwa bwonna olw’ekibi ekyo. ");
INSERT INTO lug_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Omusajja bw’aneebakanga n’omukazi mu biseera by’omukazi, ebya buli mwezi ng’empisa y’abakazi bw’eba, anaabanga abikudde ensulo y’omusaayi gw’omukazi oyo, era n’omukazi anaabanga yeebikudde. Bombi banaagobwanga mu bannaabwe ne babagaana okukolagananga nabo. ");
INSERT INTO lug_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Teweebakanga na mukazi muganda wa nnyoko oba ne mwannyina wa kitaawo n’okola naye eby’ensonyi, kubanga ekyo kiweebuula owooluganda ow’okumpi. Mwembi munaavunaanyizibwanga olw’ekyonoono kyammwe ekyo. ");
INSERT INTO lug_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Omusajja bw’aneebakanga ne muka kitaawe omuto oba ne muka kojjaawe, anaabanga aweebudde bakadde be abo. Omusajja oyo n’omukazi oyo be baneetikkanga obuvunaanyizibwa obw’ekibi ekyo, era balifa nga tebalina baana. ");
INSERT INTO lug_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Omusajja bw’anaawasanga muka muganda we, kinaabanga ekikolwa ekitali kirongoofu, kubanga aweebudde muganda we. Tebalizaala baana. ");
INSERT INTO lug_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Kale nno, mukwatenga amateeka gange gonna n’ebiragiro byange byonna, era mubikolerengako, ensi mwe mbatwala okutuulanga eryoke ereme kubasesema. ");
INSERT INTO lug_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Era temugobereranga mpisa ez’amawanga ge ŋŋenda ngoba mu nsi eyo; kubanga baakola ebintu ebyo byonna, noolwekyo mbakyawa nnyo. ");
INSERT INTO lug_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Naye nabategeeza nti, “Mulisikira ensi yaabwe, era ndigibawa ne mugirya, ye nsi omukulukuta amata n’omubisi gw’enjuki.” Nze Mukama Katonda wammwe eyabaawula ku mawanga amalala. ");
INSERT INTO lug_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Noolwekyo mujjanga kwawulamu ensolo ennongoofu n’etali nnongoofu, n’ennyonyi ennongoofu n’etali nnongoofu. Temufuukanga abatali balongoofu olw’ensolo oba ennyonyi, oba ebiramu byonna ebitambula ku ttaka, bye mmaze okwawulako ne mbibategeeza nti si birongoofu. ");
INSERT INTO lug_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kibasaanira okubeeranga abatukuvu gye ndi, kubanga Nze, Mukama, ndi mutukuvu, era mbaawudde ku mawanga amalala mubeerenga ggwanga lyange. ");
INSERT INTO lug_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Omusajja oba omukazi mu mmwe anaabeeranga omusamize oba omulogo, wa kuttibwanga. Mubakubanga amayinja; era omusaayi gwabwe gunaabanga ku mitwe gyabwe.’ ” ");
INSERT INTO lug_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Awo Mukama n’agamba Musa nti, “Yogera ne bakabona, batabani ba Alooni, obagambe nti tewabanga omuntu eyeeretako obutali bulongoofu olw’okukwata ku mufu mu bantu be, ");
INSERT INTO lug_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","wabula ng’amulinako oluganda olw’okumpi. Gamba nga nnyina, oba kitaawe, oba mutabani we, oba muwala we, oba muganda we, ");
INSERT INTO lug_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","oba mwannyina embeerera atamanyi musajja, gw’alinako obuvunaanyizibwa kubanga tabeerangako na bba, kubanga ayinza okwereetako obutali bulongoofu. ");
INSERT INTO lug_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Kabona nga bw’ali omukulembeze, tekimusaanira kwereetako obutali bulongoofu wakati mu bantu be. ");
INSERT INTO lug_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Bakabona tebamwangako nviiri ku mitwe gyabwe, wadde okumwako ebirevu byabwe, oba okusala emisale ku mibiri gyabwe. ");
INSERT INTO lug_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Kibasaanira okubeeranga abatukuvu eri Katonda waabwe balemenga okuleetera erinnya lya Katonda waabwe obutali bulongoofu. Kubanga be batuusa ebiweebwayo ebyokebwa mu muliro eri Mukama, ye mmere ya Katonda waabwe, noolwekyo kibasaanira okubeeranga abatukuvu. ");
INSERT INTO lug_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Tebawasanga mukazi malaaya oba atali mulongoofu, oba oyo agobeddwa ewa bba; kubanga bakabona batukuvu eri Katonda waabwe. ");
INSERT INTO lug_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Mubayisenga ng’abatukuvu, kubanga be bawaayo emmere eya Katonda wammwe. Mubayisenga ng’abatukuvu; kubanga Nze Mukama atukuza mmwe, ndi mutukuvu. ");
INSERT INTO lug_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Era omwana omuwala owa kabona bw’anaakubanga obwamalaaya, bw’atyo ne yeereetako obutali bulongoofu, anaabeeranga aleetedde kitaawe obutali bulongoofu; anaayokebwanga mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Kabona Asinga Obukulu, nga ye mukulembeze mu baganda be, era nga ye yafukibwako amafuta ag’omuzeeyituuni ku mutwe gwe, era nga yayawulibwa ayambalenga ebyambalo by’Obwakabona, tasaanira kusumululanga nviiri ze ku mutwe gwe n’azita, wadde okuyuzanga ebyambalo bye. ");
INSERT INTO lug_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Tayingiranga mu kifo omuli omulambo, aleme kwereetako obutali bulongoofu. Omulambo ne bwe gunaabanga ogwa kitaawe oba ogwa nnyina. ");
INSERT INTO lug_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Era n’ekifo kya Katonda we ekitukuvu taakivengamu oba okukireetako obutali bulongoofu, kubanga yayawulibwa bwe yafukibwako amafuta ag’omuzeeyituuni ga Katonda we. Nze Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Anaawasanga omukazi mbeerera atamanyanga musajja. ");
INSERT INTO lug_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Tawasanga nnamwandu, oba omukazi bba gwe yagoba, oba omukazi eyeereeseeko obutali bulongoofu olw’okukuba obwamalaaya; naye anaawasanga omukazi embeerera ng’amuggya mu bantu be; ");
INSERT INTO lug_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","aleme okuleetera ezzadde lye obutali bulongoofu wakati mu bantu be. Kubanga Nze Mukama Katonda amutukuza.” ");
INSERT INTO lug_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Tegeeza Alooni nti mu zadde lye, okuyita mu mirembe gyonna, bwe munaabangamu omuntu aliko akamogo ku mubiri gwe taasemberenga kuwaayo emmere ya Katonda we. ");
INSERT INTO lug_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Kubanga tewaabengawo muntu yenna aliko akamogo ku mubiri gwe anaasemberanga. Gamba: omuzibe w’amaaso, oba omulema, oba eyakyama ennyindo, oba eyakulako ekintu ekyasukkirira obuwanvu; ");
INSERT INTO lug_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","oba omuntu alina ekigere ekyagongobala, oba omukono ogwalemala, ");
INSERT INTO lug_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","oba ow’ebbango, oba nakalanga, oba atalaba bulungi, oba ng’omubiri gwe gumusiiwa yeetakulatakula, oba ng’alina amabwa agakulukuta, oba nga yayabika enjagi. ");
INSERT INTO lug_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Tewaabengawo wa mu zadde lya Alooni kabona ng’aliko akamogo anakkirizibwanga okusembera okuleeta ebiweebwayo eri Mukama Katonda, ebyokebwa mu muliro. Kubanga aliko akamogo; tekiimusaanirenga kusembera n’okuwaayo ekiweebwayo eri Katonda we. ");
INSERT INTO lug_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Anaayinzanga okulya ku mmere entukuvu ennyo eya Katonda we; ");
INSERT INTO lug_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","naye olwokubanga aliko akamogo ku mubiri gwe, taasaanirenga kusemberera ggigi, oba okulaga okumpi n’ekyoto, n’aleetera ebifo byange ebitukuvu obutali bulongoofu. Kubanga Nze Mukama Katonda abitukuza.” ");
INSERT INTO lug_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Bw’atyo Musa n’ategeeza Alooni ne batabani be, awamu n’abaana bonna aba Isirayiri ebigambo ebyo byonna. ");
INSERT INTO lug_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Tegeeza Alooni ne batabani be bassengamu ekitiibwa ebiweebwayo abaana ba Isirayiri bye bandeetera, ebyawuliddwa, bwe batyo balemenga okuvumisa erinnya lyange. Nze Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Era bagambe nti, Omuntu yenna ow’omu zadde lyabwe mu mirembe gyonna eginajjanga giddiriragana bw’ataabenga mulongoofu, naye n’asemberera ebiweebwayo ebyawuliddwa ebitukuvu, abaana ba Isirayiri bye banaabanga baleese eri Mukama Katonda, omuntu oyo anaagoberwanga ddala n’ava mu maaso gange. Nze Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Omuntu yenna ow’omu zadde lya Alooni alina obulwadde obukwata oba alwadde ekikulukuto taalyenga ku biweebwayo ebitukuvu okutuusa ng’afuuse omulongoofu. Omuntu yenna taabenga mulongoofu bw’anaakwatanga ku kintu kyonna ekitali kirongoofu ekivudde ku kukolagana n’omusajja eyavuddemu amazzi g’obusajja, oba olw’okukomako ku mulambo, ");
INSERT INTO lug_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","oba okukwata ku kyekulula ekiyinza okumufuula atali mulongoofu, oba okukoma ku muntu ayinza okumusiiga obutali bulongoofu, oba engeri yonna ey’obutali bulongoofu bw’efa yenkana. ");
INSERT INTO lug_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Omuntu ng’oyo taabenga mulongoofu okutuusa akawungeezi. Taalyenga ku biweebwayo ebitukuvu wabula ng’amaze okunaaba yenna mu mazzi. ");
INSERT INTO lug_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Enjuba bw’eneebanga egudde anaabeeranga mulongoofu; n’oluvannyuma anaalyanga ku biweebwayo ebitukuvu ebyo, kubanga ye mmere ye. ");
INSERT INTO lug_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Taalyenga ku kintu kyonna ekinaabanga kifudde obufi, oba ekinaabanga kitaaguddwataaguddwa ebisolo, kubanga kinaamufuulanga atali mulongoofu. Nze Mukama. ");
INSERT INTO lug_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Bwe batyo bakabona kibagwanira okukuumanga ebiragiro byange, balemenga okwereetako omusango ne bafa olw’okubigayaaliriranga. Nze Mukama Katonda abatukuza. ");
INSERT INTO lug_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Omuntu yenna atali wa mu lulyo lwa kabona, ne bw’anaabanga omugenyi we, oba omupakasi we, taalyenga ku biweebwayo ebyo ebitukuvu. ");
INSERT INTO lug_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Naye kabona bw’aneeguliranga omuddu n’ensimbi, oba omuddu bw’anaazaalirwanga mu nnyumba ya kabona, omuddu oyo anaalyanga ku mmere eyo. ");
INSERT INTO lug_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Omwana owoobuwala owa kabona bw’anaafumbirwanga omusajja atali kabona, talyenga ku biweebwayo ebyo ebitukuvu. ");
INSERT INTO lug_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Naye singa muwala wa kabona afuuka nnamwandu, oba singa ayawukanira ddala ne bba, kyokka nga talina mwana, n’akomawo okubeeranga mu nnyumba ya kitaawe nga bwe yakolanga ng’akyali muvubuka, anaalyanga ku mmere ya kitaawe. Omuntu yenna atakwatibwako mizizo egyo taalyenga ku mmere eyo. ");
INSERT INTO lug_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Era omuntu bw’anaalyanga ku kiweebwayo ekitukuvu nga tagenderedde, anaaleetanga ekitundu kimu kyakutaano eky’ekiweebwayo ekyo, n’akigatta ku kiweebwayo ekyo, kyonna n’akikwasa kabona. ");
INSERT INTO lug_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Bakabona tebavumisanga bintu bitukuvu abaana ba Isirayiri bye banaawangayo eri Mukama, ");
INSERT INTO lug_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","nga babakkiriza okulyanga ku biweebwayo byabwe ebitukuvu, bwe batyo ne babateekesaako omusango ogunaabaweesanga ekibonerezo. Nze Mukama Katonda abatukuza.” ");
INSERT INTO lug_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Tegeeza Alooni ne batabani be n’abaana ba Isirayiri bonna, obagambe nti, Omuntu yenna ow’omu nnyumba ya Isirayiri omu ku mmwe, oba omunnaggwanga abeera mu Isirayiri, bw’anaaleeteranga Mukama Katonda ekirabo eky’ekiweebwayo ekyokebwa okutuukiriza obweyamo bwe, oba ekiweebwayo olw’okweyagalira, ");
INSERT INTO lug_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","kinaateekwanga okubeera sseddume ey’ente oba ey’endiga, oba ey’embuzi etaliiko kamogo, ekirabo ekyo kiryokenga kikkirizibwe. ");
INSERT INTO lug_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Temuwangayo kintu kyonna ekiriko akamogo kubanga tekikkirizibwenga. ");
INSERT INTO lug_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Omuntu yenna bw’anaaleetanga ekiweebwayo eri Mukama Katonda olw’emirembe, oba okutuukiriza obweyamo, oba ekiweebwayo olw’okweyagalira, ng’akiggya mu kiraalo oba mu kisibo, okukkirizibwa kinaabeeranga ekituukiridde nga tekiriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Temuwangayo eri Mukama Katonda ensolo enzibe y’amaaso, oba eriko obuvune, oba ennema oba egongobadde, oba ezimbyezimbye ku mubiri, oba eriko amabwa agakulukuta. Ezo temuziwangayo ku kyoto eri Mukama Katonda ng’ekiweebwayo ekyokebwa. ");
INSERT INTO lug_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Naye ente oba endiga ng’eriko ekitundu kyayo ekisukkiridde obuwanvu oba ekisukkiridde obumpi eneeyinzanga okuleetebwa ng’ekiweebwayo eky’okweyagalira, naye tekkirizibwenga ng’ekiweebwayo olw’okutuukiriza obweyamo. ");
INSERT INTO lug_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Mukama Katonda temumuleeteranga ekiweebwayo eky’ensolo erina enjagi ezaanuubulwa, oba ezaabetentebwa, oba ezaayuzibwa, oba ezaasalibwa. Ekyo temukikolanga mu ggwanga lyammwe, ");
INSERT INTO lug_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","wadde okukkirizanga ng’ensolo ezo bannamawanga bazibatonedde ne muziwaayo ng’ekiweebwayo eri Katonda wammwe. Kubanga nnyonoonefu mu mubiri era ziriko obukyamu.” ");
INSERT INTO lug_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Ente, oba endiga, oba embuzi bw’eneezaalibwanga eneesigalanga ne nnyina waayo okumala ennaku musanvu. Okuva ku lunaku olw’omunaana n’okweyongerayo ennekkirizibwanga bw’eneeweebwangayo eri Mukama Katonda ng’ekiweebwayo ekyokebwa mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ente oba endiga temugittanga na mwana gwayo ku lunaku lwe lumu. ");
INSERT INTO lug_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Bwe muwangayo eri Mukama Katonda ekiweebwayo olw’okwebaza, mukiwengayo mu ngeri ennungi eneekisobozesanga okukkirizibwa. ");
INSERT INTO lug_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Kinaalibwanga ku lunaku olwo lwennyini, temukifissangawo n’akatono okutuusa enkeera. Nze Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Bwe mutyo mukwatenga amateeka gange era mugagonderenga. Nze Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Temuvumisanga linnya lyange. Abaana ba Isirayiri kibagwanira okunzisangamu ekitiibwa nga Nze mutukuvu. Nze Mukama Katonda abatukuza mmwe, ");
INSERT INTO lug_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","era Nze nabaggya mu nsi y’e Misiri mbeerenga Katonda wammwe. Nze Mukama Katonda.” ");
INSERT INTO lug_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Yogera n’abaana ba Isirayiri obagambe nti, Zino ze mbaga zange ze nnonze, nga ze mbaga za Mukama Katonda ezirondeddwa ze munaakubirangako enkuŋŋaana entukuvu. ");
INSERT INTO lug_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Mu nnaku omukaaga munaakolerangamu emirimu gyammwe, naye olunaku olw’omusanvu ye Ssabbiiti ey’okuwummula; lunaabeeranga olunaku olw’okukuŋŋaana okutukuvu. Temulukolerangako mulimu n’akatono yonna gye munaabeeranga, kubanga ye Ssabbiiti ya Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Zino ze mbaga Mukama Katonda ze yeerondera okunaakubirwanga enkuŋŋaana entukuvu ze munaalangiriranga mu ntuuko zaazo: ");
INSERT INTO lug_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Embaga ya Mukama Katonda ey’Okuyitako eneetandikanga ng’obudde buwungeera ku lunaku olw’ekkumi n’ennya olw’omwezi ogw’olubereberye. ");
INSERT INTO lug_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ku lunaku olw’ekkumi n’ettaano olw’omwezi ogwo, Embaga ya Mukama Katonda ey’Emigaati Egitali Mizimbulukuse kw’eneetandikiranga; munaamalanga ennaku musanvu nga mulya emigaati egifumbiddwa nga temuli kizimbulukusa. ");
INSERT INTO lug_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ku lunaku olusooka olw’embaga eyo ey’Okuyitako munaakubanga olukuŋŋaana olutukuvu, era temuukolerengako mirimu gyammwe egya bulijjo. ");
INSERT INTO lug_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Munaamalanga ennaku musanvu nga buli lunaku muleeta ekiweebwayo ekyokebwa n’omuliro eri Mukama. Ku lunaku olw’omusanvu munaakubanga olukuŋŋaana olutukuvu, era temuukolerengako mirimu gyammwe egya bulijjo.” ");
INSERT INTO lug_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Tegeeza abaana ba Isirayiri nti, Bwe mutuukanga mu nsi gye nzija okubawa ne mukungula ebibala byamu, muleetanga eri kabona ekinywa eky’ebibala byammwe eby’olubereberye; ");
INSERT INTO lug_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","naye anaawuubawuubanga ekinywa ekyo awali Mukama Katonda kiryoke kikkirizibwe ku lwammwe. Kabona anaakiwuubawuubanga ku lunaku oluddirira Ssabbiiti. ");
INSERT INTO lug_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ku lunaku olwo lwe munaawuubirawuubirangako ekinywa, munaawangayo ekiweebwayo ekyokebwa eri Mukama Katonda eky’omwana gw’endiga omulume, ogwakamala omwaka gumu ogw’obukulu era nga teguliiko kamogo. ");
INSERT INTO lug_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","N’ekiweebwayo eky’emmere ey’empeke ekigenderako kinaabanga kigero kya desimoolo bbiri eza efa, eky’obuwunga obulungi nga mutabuddwamu n’amafuta ag’omuzeeyituuni, nga kye kiweebwayo ekyokebwa n’omuliro eri Mukama, ne muvaamu evvumbe eddungi erisanyusa Mukama n’ekiweebwayo ekyokunywa ekigenderako kinaabanga ekitundu kimu kya kuna ekya lita emu ey’envinnyo. ");
INSERT INTO lug_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Era temuulyenga ku mugaati n’akatono oba ku mmere ey’empeke ensiike oba eyaakakungulwa, okutuusa ku lunaku olwo lwennyini lwe munaaleeterangako ekiweebwayo kino eri Katonda wammwe. Lino linaabanga tteeka ery’enkalakkalira ery’emirembe gyonna egigenda okujja, mu bifo byonna gye munaabeeranga. ");
INSERT INTO lug_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Okuva ku lunaku oluddirira Ssabbiiti, nga lwe lunaku kwe mwaleetera ekiweebwayo eky’ekinywa ekiwuubibwawuubibwa mubalanga ewiiki enzijuvu musanvu. ");
INSERT INTO lug_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Munaabalanga ennaku amakumi ataano okutuuka ku Ssabbiiti ey’omusanvu, ne mulyoka muwaayo eri Mukama ekiweebwayo eky’emmere ey’empeke empya eyaakakungulwa. ");
INSERT INTO lug_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Nga muva mu buli kitundu gye mubeera, munaaleetanga emigaati, ebiri ebiri nga gikoleddwa mu kigero ekya desimoolo bbiri eza efa ez’obuwunga obulungi, nga bufumbiddwa n’ekizimbulukusa; nga kye kiweebwayo eri Mukama Katonda ekiwuubibwawuubibwa eky’ebibala ebibereberye. ");
INSERT INTO lug_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Era awamu n’emigaati egyo munaaleeterangako abaana b’endiga musanvu ab’omwaka gumu abataliiko kamogo; munaaleetanga n’ente eya seddume ento emu, n’endiga ennume ento bbiri. Binaabeeranga ekiweebwayo ekyokebwa eri Mukama, awamu n’ekiweebwayo eky’emmere ey’empeke n’ekiweebwayo eky’ebyokunywa; nga kye kiweebwayo ekyokebwa n’omuliro, ne muvaamu evvumbe erisanyusa Mukama. ");
INSERT INTO lug_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Era munaawangayo embuzi emu ennume nga kye kiweebwayo olw’ekibi, era n’endiga ento ennume ez’omwaka ogumu bbiri nga kye kiweebwayo olw’emirembe. ");
INSERT INTO lug_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Kabona anaawubawuubanga ebiweebwayo ebyo awamu n’emigaati egikoleddwa mu bibala ebibereberye n’endiga zombi ento, nga kye kiweebwayo eri Mukama Katonda ekiwuubibwawuubibwa. Kinaabanga kiweebwayo eri Mukama Katonda ekitukuvu, era kabona y’anaakitwalanga. ");
INSERT INTO lug_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ku lunaku olwo onoolangiriranga olukuŋŋaana olutukuvu; era temujjanga kukolerako mirimu gyammwe egya bulijjo. Eryo linaabeeranga etteeka ery’emirembe gyonna mu mmwe buli yonna gye munaabeeranga. ");
INSERT INTO lug_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Bwe munaakungulanga emmere mu ttaka lyammwe temugimalirangamu ddala okutuuka ku mbibiro z’ennimiro yammwe, wadde okukuŋŋaanyanga eneebanga ekunkumuse wansi nga mumaze okukungula. Eyo mugirekeranga abaavu ne bannamawanga. Nze Mukama Katonda wammwe.” ");
INSERT INTO lug_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Tegeeza abaana ba Isirayiri nti olunaku olw’olubereberye mu mwezi ogw’omusanvu lunaabanga lwa kuwummula, munaakwatirangako olukuŋŋaana olutukuvu olunaalangirirwanga n’okufuuwa amakondeere ag’omwanguka. ");
INSERT INTO lug_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Temukolerangako mirimu gyonna egya bulijjo, naye munaawangayo ekiweebwayo ekyokebwa n’omuliro eri Mukama Katonda.” ");
INSERT INTO lug_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Olunaku olw’ekkumi olw’omwezi guno ogw’omusanvu lwe lunaabanga Olunaku olw’Okutangiririrwa. Munaakubanga olukuŋŋaana olutukuvu, muneefiirizanga ne mwerumya, era munaawangayo ekiweebwayo ekyokebwa n’omuliro eri Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Olunaku olwo temulukolerangako mulimu na gumu, kubanga lwe Lunaku olw’Okutangiririrwa, lwe munaatangiririrwanga awali Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Omuntu yenna anaagaananga okwefiiriza ku lunaku olwo kinaamugwaniranga okuwaŋŋangusibwa n’aggyibwa mu banne. ");
INSERT INTO lug_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Era buli muntu anaakolanga omulimu ku lunaku olwo ndimuggya mu banne ne mmuzikiriza. ");
INSERT INTO lug_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Temulukolerangako mulimu n’akatono. Eryo linaabeeranga etteeka ery’enkalakkalira, ery’emirembe gyonna egigenda okujja mu bifo byonna gye munaabeeranga. ");
INSERT INTO lug_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Lunaabeeranga lwa Ssabbiiti na kuwummulirako gye muli, era muneefiirizanga. Munaakuumanga Ssabbiiti yammwe okuva ku lunaku olw’omwenda olw’omwezi akawungeezi okutuusa ku kawungeezi akaddirira.” ");
INSERT INTO lug_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Tegeeza abaana ba Isirayiri nti ku lunaku olw’ekkumi n’ettaano Embaga ya Mukama ey’Ensiisira kw’eneetandikiranga, era eneemalanga ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ku lunaku olw’olubereberye munaakubirangako olukuŋŋaana olutukuvu; temuulukolerengako mirimu egya bulijjo. ");
INSERT INTO lug_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Munaaleetanga ebiweebwayo eri Mukama ebyokye mu muliro okumalira ddala ennaku musanvu, ne ku lunaku olw’omunaana munaakubanga olukuŋŋaana olutukuvu ne muwaayo eri Mukama Katonda ekiweebwayo ekyokye n’omuliro. Olwo lwe lukuŋŋaana olukulu oluggalawo, temulukolerangako mirimu egya bulijjo. ");
INSERT INTO lug_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Ezo ze mbaga Mukama ze yalagira, ze munaalangiriranga nti mbaga ntukuvu okunaaleeterwanga ebiweebwayo eri Mukama Katonda ebyokeddwa mu muliro, ebiweebwayo ebyokye, ebiweebwayo eby’empeke, ssaddaaka n’ebiweebwayo ebinywebwa ebineetaagibwanga buli lunaku. ");
INSERT INTO lug_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ebiweebwayo bino byeyongera ku biri eby’oku Ssabbiiti za Mukama Katonda, era ne byeyongera ku birabo byammwe ne ku ebyo byonna bye munaabanga mweyamye, ne ku biweebwayo ebirala byonna bye munaabanga muleetedde Mukama Katonda nga mweyagalidde. ");
INSERT INTO lug_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Kale nno okutandikira ku lunaku olw’ekkumi n’ettaano olw’omwezi ogw’omusanvu, nga mumaze okukungula n’okuyingiza ebibala ebivudde mu ttaka lyammwe, munaakoleranga Mukama Katonda ekijaguzo okumala ennaku musanvu; olunaku olw’olubereberye lunaabanga lwa kuwummula era n’olunaku olw’omunaana nalwo nga lwa kuwummula. ");
INSERT INTO lug_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ku lunaku olw’olubereberye munaanoganga ku miti ebibala ebisingira ddala obulungi ne muddira n’amatabi g’enkindu, n’amatabi ag’emiti agaziyidde n’ebikoola ebigimu, n’emiti egy’oku migga, ne mulyoka musanyukira awali Mukama Katonda wammwe okumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Mukolanga bwe mutyo ng’ekyo kye kijaguzo eri Mukama Katonda, okumala ennaku musanvu buli mwaka. Lino ly’etteeka ery’enkalakkalira erinaakwatibwanga n’ab’omu mirembe egigenda okujja; mujaguzenga mu mwezi ogw’omusanvu. ");
INSERT INTO lug_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Munaasulanga mu busiisira okumala ennaku musanvu. Abo bonna abazaaliranwa ab’omu Isirayiri banaasulanga mu busiisira, ");
INSERT INTO lug_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","bwe batyo ab’omu zzadde lyammwe balyoke bamanye nga bwe nasuzanga abaana ba Isirayiri mu busiisira bwe nnali nga mbaggya mu nsi y’e Misiri. Nze Mukama Katonda wammwe.” ");
INSERT INTO lug_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Bw’atyo Musa n’alangirira mu baana ba Isirayiri embaga za Mukama ennonde. ");
INSERT INTO lug_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Lagira abaana ba Isirayiri bakuleetere amafuta ag’omuzeeyituuni aga zeyituuni amalungi amaka ag’okukozesa mu ttaala ziryoke zaakenga buli kiseera awatali kusalako. ");
INSERT INTO lug_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Wabweru w’Eggigi ery’Endagaano mu Weema ey’Okukuŋŋaanirangamu, Alooni w’anaalabiririranga ettabaaza ezo nga zaakira awali Mukama Katonda okuva akawungeezi okutuusa mu makya awatali kusalako. Eryo linaabanga tteeka ery’enkalakkalira ne mu mirembe egigenda okujja. ");
INSERT INTO lug_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Alooni anaalabiriranga ettaala ez’oku kikondo ekya zaabu omuka awali Mukama Katonda nga zaaka awatali kusalako. ");
INSERT INTO lug_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Ojja kuddiranga obuwunga bw’eŋŋaano obulungi ofumbe emigaati kkumi n’ebiri ng’okozesa desimoolo bbiri eza efa. ");
INSERT INTO lug_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Onoogitegekanga mu nnyiriri bbiri nga mu buli lunyiriri mulimu emigaati mukaaga. Onoogiteekanga ku mmeeza eya zaabu omuka awali Mukama. ");
INSERT INTO lug_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Era ku buli lunyiriri onooteekangako obubaane obuka nga bugendera wamu n’emigaati nga kye kijjukizo eky’ekiweebwayo eri Mukama Katonda nga kyokeddwa mu muliro. ");
INSERT INTO lug_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Emigaati egyo ginaategekebwanga awali Mukama buli Ssabbiiti awatali kwosa, ng’ekyo kikolebwa ku lw’abaana ba Isirayiri nga ye ndagaano ey’emirembe n’emirembe. ");
INSERT INTO lug_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Emigaati egyo ginaabanga gya Alooni ne batabani be, era banaagiriiranga mu kifo ekitukuvu, kubanga giva ku kiweebwayo ekitukuvu ennyo eri Mukama Katonda nga kyokeddwa mu muliro nga kye kiragiro eky’enkalakkalira.” ");
INSERT INTO lug_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Awo mutabani w’omukazi Omuyisirayiri naye nga kitaawe Mumisiri n’afuluma n’abeera mu baana ba Isirayiri, naye ne wasitukawo olutalo wakati w’omusajja oyo n’Omuyisirayiri, nga bali mu lusiisira. ");
INSERT INTO lug_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Mutabani w’omukazi Omuyisirayiri n’avvoola Erinnya lya Mukama, era n’akolima. Ne bamuleeta eri Musa. Nnyina ye yali Seromisi, muwala wa Dibuli ow’omu kika kya Ddaani. ");
INSERT INTO lug_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ne bamuggalira mu kkomera okutuusa Mukama Katonda lw’anaabategeeza ekinaakolebwa. ");
INSERT INTO lug_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Eyavvodde mumufulumye ebweru w’olusiisira. Abo bonna abaamuwulidde ng’avvoola bateeke emikono gyabwe ku mutwe gwe; oluvannyuma ekibiina kyonna kiryoke kimukube amayinja. ");
INSERT INTO lug_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Tegeeza abaana ba Isirayiri nti omuntu yenna anaakolimiranga Katonda we anaabanga n’obuvunaanyizibwa olw’ekibi ekyo. ");
INSERT INTO lug_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Oyo yenna anavvoolanga erinnya lya Mukama Katonda anattibwanga. Ekibiina kyonna kinaamukubanga amayinja. Ne bw’anaabanga omugwira oba Omuyisirayiri, bw’anavvoolanga Erinnya anattibwanga. ");
INSERT INTO lug_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Anattanga omuntu naye anattibwanga. ");
INSERT INTO lug_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Omuntu yenna anattanga ensolo ya munne anaagimuliyiranga, ensolo ku nsolo. ");
INSERT INTO lug_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Omuntu bw’anaaleetanga akamogo ku munne n’amulumya, ekyo ky’akoze ku munne naye kye kinaamukolwangako: ");
INSERT INTO lug_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","obuvune olw’obuvune, eriiso olw’eriiso, erinnyo olw’erinnyo; nga bw’anaabanga alumizza munne, naye bw’atyo bw’anaalumizibwanga. ");
INSERT INTO lug_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Omuntu anattanga ensolo ya munne anaagimuliyiranga, n’oyo anattanga omuntu naye waakuttibwanga. ");
INSERT INTO lug_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Etteeka lye limu lye linaafuganga omugwira era n’Omuyisirayiri. Nze Mukama Katonda wammwe.” ");
INSERT INTO lug_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Bw’atyo Musa n’ategeeza abaana ba Isirayiri, ne bafulumya eyavvoola ebweru w’olusiisira ne bamukuba amayinja n’afa. Abaana ba Isirayiri baakola nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mukama Katonda yagamba Musa ku lusozi Sinaayi nti, ");
INSERT INTO lug_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Tegeeza abaana ba Isirayiri nti bwe mutuukanga mu nsi gye mbawa, ensi yennyini eneekuumiranga Mukama Katonda ssabbiiti. ");
INSERT INTO lug_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Okumala emyaka mukaaga ennimiro zammwe munaazisigangamu emmere, era mu myaka egyo omukaaga munaasaliranga emizabbibu gyammwe n’ebibala ne mubikungula. ");
INSERT INTO lug_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Naye mu mwaka ogw’omusanvu ettaka ly’ensi eyo linaabanga ne ssabbiiti ey’okuwummula eri Mukama Katonda. Temusiganga mmere mu nnimiro zammwe wadde okusalira emizabbibu gyammwe. ");
INSERT INTO lug_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ebimera ebyekuzizza byokka, ebimererezi, temubikungulanga wadde okunoga ebibala ku mizabbibu gyammwe egitaasalirwa. Omwaka ogwo ettaka ly’ensi linaaguwummulanga. ");
INSERT INTO lug_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ebyo byonna ebyokulya ebinaavanga mu ttaka mu mwaka ogwa ssabbiiti yaalyo binaabanga mmere yammwe, mmwe bennyini, n’eri abaddu bammwe abasajja, n’abakazi, era n’abaweereza bammwe ab’empeera, n’abagenyi abanaabanga basula mu maka gammwe; ");
INSERT INTO lug_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","era n’ente zammwe n’ensolo ez’omu nsiko ezinaabanga ku ttaka lyammwe. Buli ekyokulya ekinaakuliranga ku ttaka eryo kinaabanga mmere. ");
INSERT INTO lug_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Munaabaliriranga essabbiiti musanvu ez’omu myaka, kwe kugamba nti musanvu emirundi emyaka musanvu. Bwe kityo ekiseera kyonna ekya ssabbiiti ezo ne kiba emyaka amakumi ana mu mwenda. ");
INSERT INTO lug_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ekkondeere ery’okujaguza munaalifuuyiranga wonna wonna ku lunaku olw’ekkumi mu mwezi ogw’omusanvu ku Lunaku olw’Okutangiririrwa, ekkondeere munaalifuuyiranga mu nsi yammwe yonna. ");
INSERT INTO lug_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Munaatukuzanga omwaka ogw’amakumi ataano, era munaalangiriranga ebiseera eby’eddembe eri abatuuze bonna mu ggwanga lyammwe. Omwaka ogwo gunaabanga gwa kujaguza gwa Jjubiri gye muli; buli omu anaddangayo mu kifo kye eky’obwannannyini, era buli omu anaddangayo mu kika kye. ");
INSERT INTO lug_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Omwaka ogw’amakumi ataano gunaabanga gwa kujaguza gwa Jjubiri gye muli; mu mwaka ogwo temuusigenga era temuukungulenga bikuze ku bimererezi newaakubadde okukuŋŋaanya ebibala eby’oku mizabbibu egitali misalire. ");
INSERT INTO lug_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Kubanga ekiseera ekyo kya kujaguza kya Jjubiri era kinaabanga kitukuvu gye muli; mulyenga ebyo byokka bye munaggyanga mu nnimiro. ");
INSERT INTO lug_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Mu mwaka ogwo ogw’okujaguza ogwa Jjubiri buli omu anaddangayo mu kifo kye eky’obwannannyini. ");
INSERT INTO lug_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Era bwe munaatunzanga bannammwe ekintu kyonna oba bwe munaagulanga ku bannammwe ekintu kyonna, temuseeragananga. ");
INSERT INTO lug_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Munnansi munno onoomugulangako ng’osinziira ku myaka egyakayitawo okuva ku kujaguza ku Jjubiri. Era naye anaakutunzanga ng’asinziira ku myaka egibulayo okutuuka ku makungula g’ebibala. ");
INSERT INTO lug_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Emyaka bwe ginaabanga emingi, omuwendo ogulamulwa munaagwongezanga, naye emyaka bwe ginaabanga emitono munaagukendeezanga, kubanga obungi bw’ebikungulwa, bw’ogula ku mutunzi. ");
INSERT INTO lug_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Temuseeragananga; mutyanga Katonda wammwe, kubanga Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Mugonderenga ebiragiro byange, era mukwatenga amateeka gange, bwe mutyo munaatuulanga n’emirembe mu nsi yammwe. ");
INSERT INTO lug_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ensi eneebaleeteranga ebibala byayo, ne mulya ne mukkuta ne mutuulamu n’emirembe. ");
INSERT INTO lug_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Muyinza okubuuza nti, ‘Bwe tutaasigenga era ne tutakungulanga, kale mu mwaka ogw’omusanvu tunaalyanga ki?’ ");
INSERT INTO lug_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mu mwaka ogw’omukaaga ndibayiwako omukisa gwange ogulireetera ensi yammwe ebibala ebirimala emyaka esatu. ");
INSERT INTO lug_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Bwe munaabanga musiga mu mwaka ogw’omunaana, munaabanga mulya ku bibala ebikadde bye mwatereka, okutuusa nga mukungudde ebibala eby’omwaka ogw’omwenda. ");
INSERT INTO lug_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Ettaka teriitundibwenga kagenderere, kubanga ensi yange; mwe muli bayise era abasuze obusuze. ");
INSERT INTO lug_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Buli kitundu kya nsi kye munaalyanga, bwe mutundanga ettaka mwerekerangawo omwagaanya ogw’okulinunulayo gye mulitunze. ");
INSERT INTO lug_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Munnansi munnammwe bw’anaayavuwalanga, n’atunda ebimu ku bintu bye, muganda we ow’okumpi mu luganda anajjanga n’anunula ebyo munnansi munne by’atunze. ");
INSERT INTO lug_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Omuntu bw’anaabanga talina anaabimununulira, naye ye ku bubwe ng’agaggawadde, era ng’afunye obusobozi obw’okubinunula, ");
INSERT INTO lug_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","anaabaliriranga omuwendo gw’ensimbi oguli mu myaka kasookedde abitunda, n’abala n’omuwendo ogugya mu myaka egisigaddeyo okutuuka ku Jjubiri, n’agusasula omuntu gwe yaguza ebintu ebyo, olwo eyatunda aneddirangayo mu bintu bye. ");
INSERT INTO lug_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Naye singa alemwa okufuna obusobozi okumusasula, kale ebyo bye yatunda binaasigalanga mu mukono gw’eyabigula nga ye nannyini byo okutuusa mu Mwaka gwa Jjubiri. Binamuddizibwanga mu Jjubiri, era anaayinzanga okweddirayo mu bintu bye. ");
INSERT INTO lug_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Omuntu bw’anaatundanga ennyumba esulwamu eri mu kibuga ekyetooloddwa bbugwe, anaayinzanga okuginunula mu mwaka nga tegunaggwaako. Mu bbanga eryo ery’omwaka omulamba mw’anaabeereranga n’obuyinza obw’okuginunula. ");
INSERT INTO lug_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ennyumba eyo eri mu kibuga ekyetooloddwa bbugwe bw’eteenunulibwenga mu bbanga ery’omwaka ogumu, kale eneebeereranga ddala y’oyo eyagigula n’ezzadde lye. Eyagitunda teemuddizibwenga mu Jjubiri. ");
INSERT INTO lug_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Naye amayumba ag’omu bubuga obutono obw’omu byalo obuteetooloddwako bisenge, ganaabalirwanga mu ttuluba lye limu n’ery’ennimiro eziri mu byalo. Ganaanunulibwanga era ne gaddira bannyinigo mu Jjubiri. ");
INSERT INTO lug_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“Bulijjo Abaleevi banaabanga ba ddembe okununula amayumba gaabwe agali mu bibuga byabwe eby’Abaleevi bye balinako obwannannyini. ");
INSERT INTO lug_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Era Omuleevi bw’anaabanga takozesezza ddembe lye ery’okununula, kale ennyumba eyatundirwa mu kibuga Abaleevi kye balinako obwannannyini, eneemuddiranga mu Jjubiri; kubanga mu bantu ba Isirayiri ennyumba eziri mu bibuga by’Abaleevi za Baleevi. ");
INSERT INTO lug_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Naye ennimiro eziri ku ttaka lya wamu ery’ebibuga byabwe teziitundibwenga; kubanga ezo zaabwe za bwannannyini obw’olubeerera. ");
INSERT INTO lug_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Munnansi munnammwe bw’anaayavuwalanga ng’ali wamu nammwe, nga takyasobola kwefunira buyambi, mubeerenga naye nga mumulabirira nga bwe mwandirabiridde omunnaggwanga oba omusuze obusuze ali mu mmwe. ");
INSERT INTO lug_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Mutyenga Katonda wammwe. Munnammwe temumuggyangako magoba ku kintu kyonna kye munaabanga mumuwoze, bw’atyo munnammwe oyo alyoke abeerenga mu mmwe. ");
INSERT INTO lug_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Bw’omuwolanga ensimbi azzengawo omuwendo gwennyini gw’omuwoze so tasukkirizangamu. Era bw’omuguzanga emmere tossangamu magoba. ");
INSERT INTO lug_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Nze Mukama Katonda wammwe eyabaggya mu nsi ey’e Misiri okubawa ensi ya Kanani n’okubeera Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Era munnansi munnammwe bw’anaayavuwalanga ng’ali nammwe, ne yeetunda gye muli, temumukozesanga nga muddu. ");
INSERT INTO lug_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Munaamukozesanga ng’omupakasi ow’empeera oba ng’omusuze obusuze, ng’ali nammwe. Anaabaweerezanga okutuusa mu Mwaka gwa Jjubiri. ");
INSERT INTO lug_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Kale nno, olwo anaalekebwanga n’addayo ewaabwe, ye n’abaana be, mu kika kye ku butaka bwa bakadde be. ");
INSERT INTO lug_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Kubanga baweereza bange be naggya mu nsi y’e Misiri; tebaatundibwenga ng’abaddu. ");
INSERT INTO lug_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Temubafugisanga bukambwe, naye mutyenga Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Abaddu bammwe abasajja n’abaddu bammwe abakazi munaabaggyanga mu mawanga agabeetoolodde, mu mawanga ago mwe muneeguliranga abaddu abasajja n’abaddu abakazi. ");
INSERT INTO lug_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Era munaayinzanga okwegulira ku bannamawanga abali nammwe abasuze obusuze, ne ku baana baabwe abanaazaalirwanga mu nsi yammwe; abo banaabanga nvuma zammwe. ");
INSERT INTO lug_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Munaayinzanga okulaamira batabani bammwe abalibagoberera envuma ezo ng’obusika bwabwe obw’emirembe gyonna. Naye Bayisirayiri bannammwe temubafugisanga bukambwe. ");
INSERT INTO lug_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Omunnaggwanga oba omusuze obusuze ali nammwe bw’anaagaggawalanga, naye munnansi munnammwe bwe babeera n’ayavuwala, ne yeetunda eri munnaggwanga oba eri omusuze obusuze ali nammwe, oba eri omu ku b’omu luggya lwa munnaggwanga, ");
INSERT INTO lug_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","anaayinzanga okununulibwa, ng’amaze okwetunda. Omu ku baganda be anayinzanga okumununula: ");
INSERT INTO lug_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Taata we oba mutabani wa taata we, oba owooluganda omulala ow’okumpi mu buzaale ow’omu kika kye anaayinzanga okumununula. Oba ye bw’anaagaggawalanga anaayinzanga okwenunula. ");
INSERT INTO lug_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ye n’oli eyamugula bajjanga kubalirira ebbanga okuva mu mwaka gwe yeetundiramu okutuuka ku Mwaka gwa Jjubiri. Omuwendo ogw’okununulibwa guneesigamizibwanga ku muwendo gw’emyaka egibaliriddwa; ebbanga lye yamala n’eyamugula linaageraageranyizibwanga n’ebbanga ery’omupakasi asasulwa empeera. ");
INSERT INTO lug_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Mu kubalirira kwabwe bwe kinaazuukanga ng’ekyasigaddeyo emyaka mingi okutuuka ku Jjubiri, ku muwendo gwe yeetunda anaasasulangako omuwendo munene olw’okwenunula. ");
INSERT INTO lug_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Naye bw’eneebanga esigaddeyo emyaka mitono, egyo gy’anaabalirirangamu ensimbi zaamu n’asasula ezo nga bwe kyetaagisa olw’okwenunula. ");
INSERT INTO lug_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Oyo eyagula munne anaamuyisanga ng’omupakasi amukolera mu kupatana okwa buli mwaka. Temulekanga oyo eyagula munne okumutuntuzanga nga nammwe mulaba. ");
INSERT INTO lug_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“Bw’anaabanga tanunulibbwa mu zimu ku ngeri ezo, ye n’abaana be banaanunulibwanga mu Mwaka gwa Jjubiri. ");
INSERT INTO lug_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Kubanga abaana ba Isirayiri bantu bange, abaweereza bange be naggya mu nsi ey’e Misiri. Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Temwekoleranga bifaananyi oba okwesimbira ebifaananyi ebyole, oba amayinja ge muyise amatukuvu, era temuteekanga mayinja mawoole mu nsi yammwe okugavuunamiranga. Nze Mukama Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Mukwatenga Ssabbiiti zange, era n’ebifo byange ebitukuvu mubissengamu ekitiibwa. Nze Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Bwe munaakwatanga amateeka gange, ne mugondera ebiragiro byange n’obwegendereza, ");
INSERT INTO lug_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","nnaabatonnyesezanga enkuba mu ntuuko zaayo, n’ettaka linaavangamu ebibala byalyo, n’emiti egy’omu nnimiro ginaabalanga ebibala byagyo. ");
INSERT INTO lug_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Munaawuulanga okutuusa ku makungula g’emizabbibu, n’okukungula emizabbibu kunaabatuusanga mu biseera eby’okusiga; era munaalyanga emmere yonna nga bwe mwetaaga, ne mubeera mu nsi yammwe nga mulina emirembe. ");
INSERT INTO lug_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Ndibawa emirembe mu nsi ne mwebaka bulungi, so tewaabengawo anaabatiisatiisanga. Ebisolo ebikambwe ndibimalamu mu nsi yammwe, era temuubeerengamu ntalo. ");
INSERT INTO lug_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Munaawonderanga abalabe bammwe ne mubatta n’ekitala ne mubawangula. ");
INSERT INTO lug_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Abataano mu mmwe banaagobanga ekikumi, era ekikumi mu mmwe banaagobanga omutwalo ogumu, era munaawangulanga abalabe bammwe n’ekitala. ");
INSERT INTO lug_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Nnaabassangako omwoyo ne mbawa okuzaala ne mweyongera obungi, era endagaano yange nammwe nnaagituukirizanga. ");
INSERT INTO lug_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Munaabanga mukyalya ku makungula ag’omwaka oguyise ne mugafulumya olw’amakungula amaggya. ");
INSERT INTO lug_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ekifo kyange eky’okubeeramu nnaakiteekanga mu mmwe, era omutima gwange teguubatamwenga. ");
INSERT INTO lug_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nnaatambuliranga mu mmwe, era nnaabanga Katonda wammwe, nammwe munaabanga bantu bange. ");
INSERT INTO lug_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Nze Mukama Katonda wammwe eyabaggya mu nsi ey’e Misiri, mulyoke mukome okuba abaddu b’Abamisiri; namenya ebikoligo byammwe ne mbasobozesa okutambula nga mwesimbye. ");
INSERT INTO lug_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Naye bwe mutampulirenga, ne mutagondera biragiro ebyo byonna, ");
INSERT INTO lug_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","era bwe munaanyoomoolanga ebiragiro byange ne mukyawa amateeka gange, ne mulemwa okutuukiriza ebiragiro byange ebyo byonna, bwe mutyo ne mutakuumanga ndagaano yange, ");
INSERT INTO lug_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","kale, kino kye ndibakola: Ndibaleetera entiisa eza mangu ez’embagirawo, n’obulwadde obw’olukonvuba obubalumya akasiiso n’omusujja, ebiribaziba amaaso ne bibakamulamu obulamu. Era muliteganira bwereere okusimba ebibala byammwe, kubanga abalabe bammwe be balibirya. ");
INSERT INTO lug_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ndibeefuukira, abalabe bammwe n’okubawangula ne babawangula; abo ababakyawa banaabafuganga, ne mudduka n’okudduka so nga tewali abagoba. ");
INSERT INTO lug_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Oluvannyuma lw’ebyo byonna okubatuukako, era bwe mutaŋŋonderenga, kale ndyongera okubabonereza okusingawo emirundi musanvu, olw’ebibi byammwe. ");
INSERT INTO lug_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Amalala gammwe n’emputtu ndibibaggyamu, eggulu ne likakanyala ng’ekyuma, n’ettaka ne likaluba ng’ekikomo. ");
INSERT INTO lug_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Amaanyi gammwe ganaabafanga busa, kubanga ettaka lyammwe teriivengamu mmere yaalyo, wadde emiti egy’omu nsi yammwe okubala ebibala byagyo. ");
INSERT INTO lug_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Era bwe muneeyongeranga okutambulira mu makubo ge sikkiriza, ne mugaana okumpulira, ndyongera okubaleetako endwadde nnyingi nga za mirundi musanvu ng’ebibi byammwe bwe byenkana. ");
INSERT INTO lug_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Era ndibasindikira ensolo ez’omu nsiko, ezinaalyanga abaana bammwe, ne zizikiriza ente zammwe n’omuwendo gwammwe ne gukendeera, nga n’enguudo zammwe tewakyali azitambuliramu. ");
INSERT INTO lug_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Era okukangavvula okwo bwe kutaabakyusenga kudda gye ndi, naye ne mweyongera okujeema, ");
INSERT INTO lug_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","kale, nange ndibalaga obukambwe, era nze kennyini ndibeebonerereza emirundi musanvu olw’ebyonoono byammwe. ");
INSERT INTO lug_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Era nnaabaleeteranga entalo okwesasuza olw’okumenya endagaano. Bwe muneekuŋŋaanyizanga mu bibuga byammwe, nnaabaleeteranga endwadde enkambwe, era n’abalabe bammwe banaabawangulanga. ");
INSERT INTO lug_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Bwe ndikendeeza ku bungi bw’emmere yammwe, olwo abakazi ekkumi banaabafumbiranga emmere yammwe mu ntamu emu, era buli omu banaamupimirangako akatole katono. Munaalyanga, naye temukkutenga. ");
INSERT INTO lug_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“N’ebyo byonna bwe binaalemanga okukyusa emitima gyammwe okumpulira, naye ne mweyongera okunjeemeranga; ");
INSERT INTO lug_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","nange nnaabasunguwaliranga, nze kennyini ne mbeebonerereza emirundi musanvu olw’ebibi byammwe. ");
INSERT INTO lug_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mulirya batabani bammwe ne bawala bammwe. ");
INSERT INTO lug_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ndizikiriza ebyoto bya bakatonda bammwe, ne ntemaatema bakatonda abalala, ne ntuuma emirambo gyammwe ku mirambo gya bakatonda abalala; era ndibakyawa. ");
INSERT INTO lug_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ebibuga byammwe binaasigaliranga awo tayo, n’ebifo byammwe ebitukuvu nga tebiriiko abifaako, era n’akaloosa akava mu biweebwayo byammwe tekansanyusenga. ");
INSERT INTO lug_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ensi yammwe ndigifuula ddungu n’abalabe bammwe abanaagibeerangamu ne bagyewuunya. ");
INSERT INTO lug_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ndibasaasaanyiza mu mawanga ne mbagobereza ekitala kyange. Ensi yammwe erifuuka amalungu n’ebibuga byammwe nga bimenyeddwa. ");
INSERT INTO lug_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Awo ettaka ne liryoka lifuna emyaka egya ssabbiiti zaalyo mu bbanga eryo lye lirimala nga tewali alifaako, nga mmwe muli mu nsi z’abalabe bammwe; ettaka ne liwummulako ne lyeyagalira mu ssabbiiti zaalyo ezo. ");
INSERT INTO lug_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ebbanga eryo lyonna ettaka lye lirimala nga tewali kikolerwako, liriba n’okuwummula kwe litaafuna mu ssabbiiti ezaayita bwe mwali nga mmwe mulibeerako. ");
INSERT INTO lug_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Mu mmwe, abaliba basigaddewo nga bakyali balamu, nditeeka okutya mu mitima gyabwe nga bali eyo mu nsi z’abalabe baabwe, nga n’eddoboozi ly’akakoola k’omuti akafuumuulibwa n’empewo kabatiisa. Banaddukanga ng’abaliko abalabe ab’ebitala ababagoba, banaagwanga newaakubadde nga tewaabeerengawo babawondera. ");
INSERT INTO lug_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Banaagwaŋŋanangako ng’abadduka okwewonya omulabe ow’ekitala newaakubadde nga tewaabengawo babawondera. Bwe mutyo temuusobolenga kwolekera balabe bammwe. ");
INSERT INTO lug_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mulisaanawo mu mawanga; ensi z’abalabe bammwe ziribamira. ");
INSERT INTO lug_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","N’abo ku mmwe abanaabanga basigaddewo banaakoozimbiranga mu nsi z’abalabe bammwe olw’ebibi byabwe, era balikoozimba n’olw’ebibi bya bakitaabwe. ");
INSERT INTO lug_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Naye bwe baneenenyanga ebibi byabwe n’ebyonoono bya bakitaabwe n’obunnanfuusi bwabwe gye ndi n’obujeemu bwabwe, ");
INSERT INTO lug_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ebyandeetera okubalaga obukambwe ne mbasindika ne mu nsi z’abalabe baabwe, era amalala g’emitima gyabwe egitali mikomole bwe galikkakkana ne bakkiriza okukola ebibonerezo olw’ebyonoono byabwe, ");
INSERT INTO lug_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","kale ndijjukira endagaano yange ne Yakobo, ne nzijukira endagaano yange ne Isaaka n’endagaano yange ne Ibulayimu, era ndijjukira n’ensi yaabwe. ");
INSERT INTO lug_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Naye ensi banaabanga bagivuddemu n’efuna ssabbiiti zaayo kubanga abaagibeerangamu tebakyagirimu. Banaabonerezebwanga olw’ebibi byabwe kubanga baanyoomoolanga amateeka gange ne batagondera biragiro byange. ");
INSERT INTO lug_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Newaakubadde ng’ebyo biriba bwe bityo, bwe banaabanga mu nsi z’abalabe baabwe, siibeggyengako wadde okubakyawanga n’okumenyawo ne mmenyerawo ddala endagaano yange gye nalagaana nabo; kubanga Nze Mukama Katonda waabwe. ");
INSERT INTO lug_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Naye ku lwabwe, najjukiranga endagaano gye nalagaana ne bajjajjaabwe, be naggya mu nsi ey’e Misiri nga n’amawanga gonna galaba ndyoke mbeere Katonda waabwe. Nze Mukama.” ");
INSERT INTO lug_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ago ge mateeka n’ebiragiro n’amateeka amakulu Mukama ge yakolera abaana ba Isirayiri, nga bwe yalagira Musa, ku lusozi Sinaayi. ");
INSERT INTO lug_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Yogera eri abaana ba Isirayiri obagambe nti: Omuntu bw’anaakolanga obweyamo obw’enjawulo obw’okuwaayo abantu eri Mukama naye ng’asasulayo miwendo egibagyamu, onoobasaliranga bw’oti: ");
INSERT INTO lug_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","omusajja aweza emyaka egy’obukulu egiri wakati w’amakumi abiri n’enkaaga anaaleetanga sekeri za ffeeza amakumi ataano, nga sekeri z’omu watukuvu bwe ziba, ");
INSERT INTO lug_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","naye bw’anaabanga omukazi onoomusaliranga sekeri amakumi asatu. ");
INSERT INTO lug_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Omuntu aweza emyaka egy’obukulu egiri wakati w’ettaano n’amakumi abiri, bw’anaabanga omusajja onoomusaliranga sekeri amakumi abiri naye omukazi sekeri kkumi. ");
INSERT INTO lug_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Bw’anaabanga omwana ng’ali wakati w’omwezi gumu n’emyaka etaano, onoomusaliranga sekeri ttaano eza ffeeza nga mulenzi, naye omuwala sekeri za ffeeza ssatu. ");
INSERT INTO lug_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Omuntu bw’anaabanga ow’emyaka egy’obukulu nkaaga n’okusingawo, omusajja onoomusaliranga sekeri kkumi na ttaano n’omukazi sekeri kkumi. ");
INSERT INTO lug_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Omuntu eyakola obweyamo bw’anaabanga omwavu ennyo atasobola kuleeta miwendo egyo gye wamusalira, anaayanjulwanga eri kabona; kale kabona anaamusaliranga omuwendo ogumugyamu ng’ageraageranya obusobozi bw’oyo eyeeyama nga bwe bunaabanga. ");
INSERT INTO lug_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Obweyamo bw’omuntu bwe bunaabeeranga obw’ekisolo ekikkirizibwa ng’ekiweebwayo eri Mukama Katonda, ekisolo ng’ekyo ekiweebwayo eri Mukama Katonda kinaabanga kitukuvu. ");
INSERT INTO lug_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Tasaaniranga kukikyusaamu oba kukiwaanyisaamu ekibi mu kirungi wadde ekirungi mu kibi; bw’anaabanga awaanyisizza ekisolo ekimu mu kirala, byombi kino na kiri ky’awanyisizzaamu binaafuukanga bitukuvu. ");
INSERT INTO lug_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ensolo omuntu gy’anaabanga yeeyamye bw’eneebanga etali nnongoofu, etakkirizibwa ng’ekiweebwayo eri Mukama Katonda, ensolo eyo esaanira okuleetebwanga eri kabona, ");
INSERT INTO lug_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ye alyokenga asalewo nga bw’eri, oba nnungi oba mbi. Omuwendo kabona gw’anaabaliriranga ku nsolo eyo, gwe gunaawebwangayo. ");
INSERT INTO lug_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Nannyini nsolo bw’anaabanga ayagala okuginunulayo, anaasaniranga okugattako ekitundu ekimu ekyokutaano ku muwendo gwayo. ");
INSERT INTO lug_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Omusajja bw’anaawangayo ennyumba ye okubeera entukuvu eri Mukama Katonda kabona anaagirabiranga omuwendo ogugigyamu, oba nnungi oba mbi. Omuwendo ogwo kabona gw’anaasalanga gwe gunaakolanga. ");
INSERT INTO lug_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Oyo anaawangayo ennyumba ye eri Mukama bw’anaabanga ayagala okuginunula, anaayongerangako ekitundu kimu kyakutaano ku muwendo gwayo, olwo ng’ennyumba emuddira. ");
INSERT INTO lug_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Omusajja bw’anaawangayo ekitundu ky’ettaka lye, lye yasikira, eri Mukama Katonda, omuwendo oguligyamu gunaabalirirwanga nga gwesigamizibwa ku bungi bw’ensigo ezeetaagibwa okusiga ku ttaka eryo ne ziggweerako; ensigo za sayiri ezipimibwamu oma zinaabalirirwangamu sekeri za ffeeza amakumi ataano. ");
INSERT INTO lug_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Singa ennimiro ye, agiwaayo mu biseera by’Omwaka gwa Jjubiri, omuwendo ogubaliriddwa gunaasigalanga nga bwe guli. ");
INSERT INTO lug_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Naye bw’anaawangayo ennimiro ye nga Jjubiri eweddeko, kabona anagibalirirangamu omuwendo ng’agwesigamya ku myaka eginaabanga gibulayo Omwaka gwa Jjubiri eddirira gulyoke gutandike, n’omuwendo ogwali gubaliriddwa gunaakendeezebwangako. ");
INSERT INTO lug_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Era oyo anaabanga awaddeyo ennimiro ye bw’anaayagalanga okuginunula, kale anaagattangako ekitundu kimu kyakutaano ku muwendo gwayo, olwo ennimiro n’emuddira. ");
INSERT INTO lug_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Naye bw’anaabanga tayagala kununula nnimiro eyo, oba bw’anaabanga agiguzizza omuntu omulala, kale ng’olwo tekyanunulibwa n’akamu. ");
INSERT INTO lug_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Naye mu Mwaka gwa Jjubiri ennimiro eyo bw’eneeteebwanga, eneebanga ntukuvu, ng’ennimiro eyawongebwa ewa Mukama; eneebanga ya kabona. ");
INSERT INTO lug_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Omusajja bw’anaawangayo eri Mukama Katonda ennimiro gye yagula, etali ku ttaka lye ery’obwannannyini, ");
INSERT INTO lug_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","kabona anaabaliriranga omuwendo ogugigyamu okutuuka ku mwaka gwa Jjubiri, omusajja anaasasulanga omuwendo ogwo ku lunaku olwo ng’ekintu ekitukuvu eri Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Mu mwaka gwa Jjubiri, ennimiro eneddizibwanga oyo gwe yagigulako, nga y’oyo eyali nannyini ttaka. ");
INSERT INTO lug_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Buli muwendo ogubalirirwa guneesigamizibwanga ku sekeri z’Awatukuvu, nga gera amakumi abiri zivaamu sekeri emu. ");
INSERT INTO lug_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Tewabanga awaayo omwana gw’ensolo omubereberye eri Mukama, kubanga abaana b’ensolo ababereberye bonna ba Mukama, oba nte oba ndiga zonna za Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Bw’anaabanga awaddeyo emu ku nsolo ezitali nnongoofu, anagisasuliranga omuwendo gwayo ogwagibalirirwamu, ng’agattako ekitundu kimu kyakutaano eky’omuwendo gwayo. Bw’ataaginunulengayo eneetundwanga omuwendo ogwagibalirirwamu. ");
INSERT INTO lug_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Naye omuntu yenna bw’anaamalanga okuwongera Mukama Katonda ku bintu bye by’anaabanga nabyo, gamba oba muntu oba kisolo oba ennimiro ye gye yasikira, tewaabengawo ku bintu ebyo bitundibwa oba okununulibwa; buli kintu ekiwongere ddala mu ngeri eyo kinaabanga kitukuvu nnyo eri Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Omuntu eyawongebwa nga wa kuttibwa, taanunulibwenga kinaamusaaniranga kuttibwa. ");
INSERT INTO lug_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Buli kitundu eky’ekkumi ekiva mu nsi, gamba ku mmere ey’empeke eva mu ttaka, oba ku bibala ebiva ku miti, kya Mukama Katonda, era kitukuvu eri Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Omuntu anaayagalanga okununula ku bitundu bye eby’ekkumi, anaagatangako ekitundu kimu kyakutaano ku muwendo gwakyo. ");
INSERT INTO lug_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ebitundu eby’ekkumi byonna ebyamagana g’ente n’eby’ebisibo by’endiga, kwe kugamba nti buli nsolo omusumba gy’anaabalanga nga ya kkumi, eneebanga ntukuvu eri Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Tasaaniranga kulondamu nnungi ng’alekawo embi, oba okuwaanyisa. Bw’anaawaanyisanga ng’olwo ensolo zombi, eri n’eno ewanyisizibbwa zinaafuukanga ntukuvu teziinunulibwenga.” ");
INSERT INTO lug_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ago ge mateeka Mukama Katonda ge yawa Musa ku lusozi Sinaayi agategeeze abaana ba Isirayiri.");
INSERT INTO lug_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Awo Mukama Katonda n’ayogera ne Musa mu Weema ey’Okukuŋŋaanirangamu, mu Ddungu lya Sinaayi ku lunaku olw’olubereberye olw’omu mwezi ogwokubiri ogw’omwaka ogwokubiri kasookedde abaana ba Isirayiri bava mu nsi y’e Misiri. N’amugamba nti: ");
INSERT INTO lug_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Bala ekibiina kyonna eky’abaana ba Isirayiri ng’obategeka mu bika byabwe, ne mu mpya zaabwe, ng’owandiika erinnya lya buli musajja kinnoomu ku lukalala. ");
INSERT INTO lug_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Ggwe ne Alooni mujja kutegeka abasajja bonna ab’omu Isirayiri abawezezza emyaka amakumi abiri egy’obukulu n’okusingawo, abatuuse okuyingira mu magye, mubabalire mu bibinja byabwe. ");
INSERT INTO lug_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Munaayambibwako omusajja omu omu okuva mu buli kika, nga ye mukulu w’oluggya lwa bajjajjaabe. ");
INSERT INTO lug_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Gano ge mannya g’abasajja abajja okubayambako: “Aliva mu kika kya Lewubeeni ye Erizuuli mutabani wa Sedewuli; ");
INSERT INTO lug_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","mu kya Simyoni ye Serumiyeeri mutabani wa Zulisadaayi; ");
INSERT INTO lug_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","mu kya Yuda ye Nakusoni mutabani wa Amminadaabu; ");
INSERT INTO lug_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","mu kya Isakaali ye Nesaneri mutabani wa Zuwaali; ");
INSERT INTO lug_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","mu kya Zebbulooni ye Eriyaabu mutabani wa Keroni. ");
INSERT INTO lug_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Okuva mu baana ba Yusufu: mu kya Efulayimu ye Erisaama mutabani wa Ammikudi; mu kya Manase ye Gamalyeri mutabani wa Pedazuuli. ");
INSERT INTO lug_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Aliva mu kika kya Benyamini ye Abidaani mutabani wa Gidyoni; ");
INSERT INTO lug_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","mu kya Ddaani ye Akiyezeeri mutabani wa Amisadaayi; ");
INSERT INTO lug_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","mu kya Aseri ye Pagiyeeri mutabani wa Okulaani; ");
INSERT INTO lug_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","mu kya Gaadi ye Eriyasaafu mutabani wa Deweri; ");
INSERT INTO lug_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","mu kya Nafutaali ye Akira mutabani wa Enani.” ");
INSERT INTO lug_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Abo be basajja abaalondebwa okuva mu kibiina, nga be bakulembeze ab’ebika bya bajjajjaabwe. Abo nga be bakulu b’ebika bya Isirayiri. ");
INSERT INTO lug_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Awo Musa ne Alooni ne batwala abasajja abo abaatuddwa amannya gaabwe, ");
INSERT INTO lug_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ne bakuŋŋaanya ekibiina ky’abantu bonna ku lunaku olw’olubereberye olw’omu mwezi ogwokubiri. Awo abantu bonna ne beewandiisa mu bujjajja bwabwe ne mu bika byabwe awamu ne mu mpya zaabwe. Abasajja abo abaali bawezezza emyaka amakumi abiri egy’obukulu n’okusingawo, amannya gaabwe ne gawandiikibwa kinnoomu ku lukalala, ");
INSERT INTO lug_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","nga Mukama bwe yalagira Musa. Bw’atyo Musa n’ababalira mu Ddungu lya Sinaayi: ");
INSERT INTO lug_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ab’omu bazzukulu ba Lewubeeni, mutabani wa Isirayiri omubereberye: Abasajja bonna ab’emyaka egy’obukulu amakumi abiri n’okusingawo, nga batuuse n’okuyingira mu magye, baawandiikibwa amannya gaabwe kinnoomu, ng’ebiwandiiko by’ebika byabwe n’eby’empya zaabwe bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Abaabalibwa okuva mu kika kya Lewubeeni baali emitwalo ena mu kakaaga mu bitaano (46,500). ");
INSERT INTO lug_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Ab’omu bazzukulu ba Simyoni: Abasajja bonna ab’emyaka egy’obukulu amakumi abiri n’okusingawo nga batuuse n’okuyingira mu magye, baawandiikibwa amannya gaabwe kinnoomu, ng’ebiwandiiko by’ebika byabwe n’eby’empya zaabwe bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Abaabalibwa okuva mu kika kya Simyoni baali emitwalo etaano mu kenda mu ebikumi bisatu (59,300). ");
INSERT INTO lug_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Ab’omu bazzukulu ba Gaadi: Abasajja bonna ab’emyaka egy’obukulu amakumi abiri n’okusingawo, nga batuuse n’okuyingira mu magye, baawandiikibwa amannya gaabwe kinnoomu, ng’ebiwandiiko by’ebika byabwe, n’eby’empya zaabwe bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Abaabalibwa okuva mu kika kya Gaadi baali emitwalo ena mu enkumi ttaano mu lukaaga mu amakumi ataano (45,650). ");
INSERT INTO lug_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Ab’omu bazzukulu ba Yuda: Abasajja bonna ab’emyaka egy’obukulu amakumi abiri n’okusingawo, nga batuuse n’okuyingira mu magye, baawandiikibwa amannya gaabwe kinnoomu, ng’ebiwandiiko by’ebika byabwe n’eby’empya zaabwe bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Abaabalibwa okuva mu kika kya Yuda baali emitwalo musanvu mu enkumi nnya mu lukaaga (74,600). ");
INSERT INTO lug_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Ab’omu bazzukulu ba Isakaali: Abasajja bonna ab’emyaka egy’obukulu amakumi abiri n’okusingawo, nga batuuse n’okuyingira mu magye, baawandiikibwa amannya gaabwe, kinnoomu, ng’ebiwandiiko by’ebika byabwe n’eby’empya zaabwe bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Abaabalibwa okuva mu kika kya Isakaali baali emitwalo etaano mu enkumi nnya mu ebikumi bina (54,400). ");
INSERT INTO lug_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Ab’omu bazzukulu ba Zebbulooni: Abasajja bonna ab’emyaka egy’obukulu amakumi abiri n’okusingawo, nga batuuse n’okuyingira mu magye, baawandiikibwa amannya gaabwe kinoomu, ng’ebiwandiiko by’ebika byabwe n’eby’empya zaabwe bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Abaabalibwa okuva mu kika kya Zebbulooni baali emitwalo etaano mu kasanvu mu ebikumi bina (57,400). ");
INSERT INTO lug_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Okuva mu batabani ba Yusufu: Ab’omu bazzukulu ba Efulayimu Abasajja bonna ab’emyaka egy’obukulu amakumi abiri n’okusingawo, nga batuuse n’okuyingira mu magye, baawandiikibwa amannya gaabwe kinnoomu, ng’ebiwandiiko by’ebika byabwe n’eby’empya zaabwe bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Abaabalibwa okuva mu kika kya Efulayimu baali emitwalo ena mu ebikumi bitaano (40,500). ");
INSERT INTO lug_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Ab’omu bazzukulu ba Manase: Abasajja bonna ab’emyaka egy’obukulu amakumi abiri n’okusingawo, nga batuuse n’okuyingira mu magye, baawandiikibwa amannya gaabwe kinnoomu, ng’ebiwandiiko by’ebika byabwe n’eby’empya zaabwe bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Abaabalibwa okuva mu kika kya Manase baali emitwalo esatu mu enkumi bbiri mu ebikumi bibiri (32,200). ");
INSERT INTO lug_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Ab’omu bazzukulu ba Benyamini: Abasajja bonna ab’emyaka egy’obukulu amakumi abiri n’okusingawo, nga batuuse n’okuyingira mu magye, baawandiikibwa amannya gaabwe kinnoomu, ng’ebiwandiiko by’ebika byabwe n’eby’empya zaabwe bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Abaabalibwa okuva mu kika kya Benyamini baali emitwalo esatu mu enkumi ttaano mu ebikumi bina (35,400). ");
INSERT INTO lug_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Ab’omu bazzukulu ba Ddaani: Abasajja bonna ab’emyaka egy’obukulu amakumi abiri n’okusingawo nga batuuse n’okuyingira mu magye, baawandiikibwa amannya gaabwe kinnoomu, ng’ebiwandiiko by’ebika byabwe n’eby’empya zaabwe bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Abaabalibwa okuva mu kika kya Ddaani baali emitwalo mukaaga mu enkumi bbiri mu lusanvu (62,700). ");
INSERT INTO lug_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Ab’omu bazzukulu ba Aseri: Abasajja bonna ab’emyaka egy’obukulu amakumi abiri n’okusingawo, nga batuuse n’okuyingira mu magye, baawandiikibwa amannya gaabwe kinnoomu, ng’ebiwandiiko by’ebika byabwe n’eby’empya zaabwe bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Abaabalibwa okuva mu kika kya Aseri baali emitwalo ena mu lukumi mu ebikumi bitaano (41,500). ");
INSERT INTO lug_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Ab’omu bazzukulu ba Nafutaali: Abasajja bonna ab’emyaka egy’obukulu amakumi abiri n’okusingawo, nga batuuse n’okuyingira mu magye, baawandiikibwa amannya gaabwe kinnoomu, ng’ebiwandiiko by’ebika byabwe n’eby’empya zaabwe bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Abaabalibwa okuva mu kika kya Nafutaali baali emitwalo etaano mu enkumi ssatu mu ebikumi bina (53,400). ");
INSERT INTO lug_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Abo be basajja Musa ne Alooni be baabala, nga bayambibwako abakulembeze ab’omu Isirayiri ekkumi n’ababiri, nga buli omu akiikiridde ekika kye. ");
INSERT INTO lug_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Abasajja bonna abaana ba Isirayiri abaali bawezezza emyaka egy’obukulu amakumi abiri n’okusingawo, nga batuuse n’okuyingira mu magye ga Isirayiri bwe batyo ne babalirwa mu bika byabwe. ");
INSERT INTO lug_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Obungi bwabwe bonna abaabalibwa okugatta awamu baali bawera emitwalo nkaaga mu enkumi ssatu mu ebikumi bitaano mu amakumi ataano (603,550). ");
INSERT INTO lug_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Abazzukulu ab’omu mpya ez’omu bika ebirala bwe baali babalibwa, bo ab’omu kika kya Leevi tebaabalibwa. ");
INSERT INTO lug_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Kubanga Mukama Katonda yali agambye Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ab’omu kika kya Leevi tababalanga wadde okubagatta awamu n’emiwendo gy’abaana ba Isirayiri abalala.” ");
INSERT INTO lug_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Era n’amugamba nti, “Naye Abaleevi obawanga omulimu ogw’okulabirira Eweema ey’Endagaano n’ebintu byamu byonna awamu ne byonna ebigigenderako. Banaasitulanga Eweema n’ebyamu byonna, banaagirabiriranga era banaasiisiranga okugyetooloola. ");
INSERT INTO lug_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Eweema bw’eneebanga etwalibwa mu kifo ekirala, Abaleevi be banaagisimbulanga, era bwe kineetaagisanga okugissa mu kifo awalala, Abaleevi be banaagisimbangawo. Omuntu omulala yenna bw’anaagisembereranga anaafanga. ");
INSERT INTO lug_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Abaana ba Isirayiri banaasiisiranga mu bibinja, nga buli musajja ali mu lusiisira lwe n’ebendera ye ku bubwe. ");
INSERT INTO lug_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Naye Abaleevi bo banaasimbanga eweema zaabwe okwebungulula Eweema ey’Endagaano, abaana ba Isirayiri baleme kutuukibwako busungu bwa Mukama. Abaleevi be banaabanga n’obuvunaanyizibwa obw’okulabirira Eweema ey’Endagaano.” ");
INSERT INTO lug_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Abaana ba Isirayiri ne bakola ebyo byonna nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Awo Mukama Katonda n’agamba Musa ne Alooni nti, ");
INSERT INTO lug_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Abaana ba Isirayiri banaasiisiranga okwebungulula Eweema ey’Okukuŋŋaanirangamu, nga bagyesuddeko akabanga naye nga bagyolekedde. Buli musajja anaawanikanga ebendera ye n’ebendera z’empya za bajjajjaabwe.” ");
INSERT INTO lug_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ebibinja by’olusiisira lwa Yuda binaasiisiranga ku ludda olw’enjuba gy’eva ne basimba awo ebendera yaabwe. Omukulembeze w’abantu ba Yuda ye Nakusoni mutabani wa Amminadaabu. ");
INSERT INTO lug_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Mu kibinja kye nga mulimu abaabalibwa emitwalo musanvu mu enkumi nnya mu lukaaga (74,600). ");
INSERT INTO lug_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Ab’ekika kya Isakaali be banaasiisiranga okuliraana Yuda. Omukulembeze w’abantu ba Isakaali ye Nesaneri mutabani wa Zuwaali. ");
INSERT INTO lug_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Abaabalibwa mu kibinja kye baali emitwalo etaano mu enkumi nnya mu ebikumi bina (54,400). ");
INSERT INTO lug_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ekika kya Zebbulooni kye kinaddangako. Omukulembeze w’abantu ba Zebbulooni ye Eriyaabu mutabani wa Keroni. ");
INSERT INTO lug_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Abaabalibwa mu kibinja kye baali emitwalo etaano mu kasanvu mu ebikumi bina (57,400). ");
INSERT INTO lug_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Abasajja bonna abaali mu lusiisira lwa Yuda abaabalibwa ng’ebibinja by’amaggye gaabwe bwe byali baali emitwalo kkumi na munaana mu kakaaga mu ebikumi bina (186,400). Be banaakulemberanga. ");
INSERT INTO lug_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ku ludda olw’obukiikaddyo ebibinja eby’amaggye g’omu kika kya Lewubeeni gye banaasiisiranga, nga basimbye eyo n’ebendera yaabwe. Omukulembeze w’abantu ba Lewubeeni ye Erizuuli mutabani wa Sedewuli. ");
INSERT INTO lug_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Abaabalibwa mu kibinja kye baali emitwalo ena mu kakaaga mu ebikumi bitaano (46,500). ");
INSERT INTO lug_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Ab’ekika kya Simyoni be banaabaddiriranga. Omukulembeze w’abantu ba Simyoni ye Serumiyeeri mutabani wa Zulisadaayi. ");
INSERT INTO lug_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Abaabalibwa mu kibinja kye baali emitwalo etaano mu kenda mu ebikumi bisatu (59,300). ");
INSERT INTO lug_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ab’ekika kya Gaadi be banaddangako. Omukulembeze w’abantu ba Gaadi ye Eriyasaafu mutabani wa Deweri. ");
INSERT INTO lug_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Abaabalibwa mu kibinja kye baali emitwalo ena mu enkumi ttaano mu lukaaga mu amakumi ataano (45,650). ");
INSERT INTO lug_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Abasajja bonna okugatta awamu abaali mu lusiisira lwa Lewubeeni abaabalibwa, ng’ebibinja by’amaggye gaabwe bwe byali, baali emitwalo kkumi n’ettaano mu lukumi mu ebikumi bina mu amakumi ataano (151,450). Be banaabanga abookubiri okusitula ng’olugendo lutuuse. ");
INSERT INTO lug_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Eweema ey’Okukuŋŋaanirangamu eneesitulwanga ng’olugendo lutuuse nga yeebunguluddwa olusiisira lw’Abaleevi, ng’eri mu makkati g’ensiisira endala zonna. Banaasitulanga okutambula nga baddiriragana ng’enteekateeka y’ensiisira zaabwe bw’eri, buli musajja ng’agenda n’ebendera ye. ");
INSERT INTO lug_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ku ludda olw’ebugwanjuba y’eneebeeranga olusiisira lw’ebibinja bya Efulayimu nga bakutte n’ebendera zaabwe. Omukulembeze w’abantu ba Efulayimu ye Erisaama mutabani wa Ammikudi. ");
INSERT INTO lug_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ab’omu kibinja kye abaabalibwa baali emitwalo ena mu ebikumi bitaano (40,500). ");
INSERT INTO lug_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Ekika kya Manase kye kinaddangako. Omukulembeze w’abantu ba Manase ye Gamalyeri mutabani wa Pedazuuli. ");
INSERT INTO lug_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ab’omu kibinja kye abaabalibwa baali emitwalo esatu mu enkumi bbiri mu ebikumi bibiri (32,200). ");
INSERT INTO lug_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ekika kya Benyamini ne kiddako. Omukulembeze w’abantu ba Benyamini ye Abidaani mutabani wa Gidyoni. ");
INSERT INTO lug_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ab’omu kibinja kye abaabalibwa baali emitwalo esatu mu enkumi ttaano mu ebikumi bina (35,400). ");
INSERT INTO lug_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Okugatta awamu abasajja bonna abaali mu lusiisira lwa Efulayimu abaabalibwa ng’ebibinja byabwe bwe byali baali emitwalo kkumi mu kanaana mu kikumi (108,100). Bano be banaabanga abookusatu okusitula ng’olugendo lutuuse. ");
INSERT INTO lug_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ku ludda olw’obukiikakkono y’eneebeeranga olusiisira lw’ebibinja bya Ddaani n’ebendera yaabwe. Omukulembeze w’abantu ba Ddaani ye Akiyezeeri mutabani wa Amisadaayi. ");
INSERT INTO lug_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ab’omu kibinja kye abaabalibwa baali emitwalo mukaaga mu enkumi bbiri mu lusanvu (62,700). ");
INSERT INTO lug_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Ab’ekika kya Aseri be banaasiisiranga okubaddirira. Omukulembeze w’abantu ba Aseri ye Pagiyeeri mutabani wa Okulaani. ");
INSERT INTO lug_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ab’omu kibinja kye abaabalibwa baali emitwalo ena mu lukumi mu ebikumi bitaano (41,500). ");
INSERT INTO lug_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ab’ekika kya Nafutaali be banaddangako. Omukulembeze w’abantu ba Nafutaali ye Akira mutabani wa Enani. ");
INSERT INTO lug_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ab’omu kibinja kye abaabalibwa baali emitwalo etaano mu enkumi ssatu mu ebikumi bina (53,400). ");
INSERT INTO lug_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Okugatta awamu abasajja bonna abaali mu lusiisira lwa Ddaani baali emitwalo kkumi n’ettaano mu kasanvu mu lukaaga (157,600). Abo be banaasembangayo okusitula ng’olugendo lutuuse, ng’ebendera zaabwe bwe ziri. ");
INSERT INTO lug_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Abo be baana ba Isirayiri abaabalibwa ng’empya zaabwe bwe zaali. Okugatta abaali mu nsiisira bonna ng’ebibinja byabwe bwe byali, baawera emitwalo nkaaga mu enkumi ssatu mu ebikumi bitaano mu amakumi ataano (603,550). ");
INSERT INTO lug_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Naye abaana ba Isirayiri bwe baali babalibwa, Abaleevi bo tebaabalibwa, kubanga bw’atyo Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Abaana ba Isirayiri bwe batyo ne bakola ebyo byonna Mukama Katonda bye yalagira Musa. Bwe batyo bwe baasiisiranga ensiisira zaabwe ng’ebendera zaabwe bwe zaali, era bwe batyo bwe baasitulanga okutambula buli bantu mu bika byabwe ne mu mpya za bajjajjaabwe. ");
INSERT INTO lug_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Luno lwe lulyo lwa Alooni n’olwa Musa mu biseera Mukama mwe yayogerera ne Musa ku Lusozi Sinaayi. ");
INSERT INTO lug_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Gano ge mannya ga batabani ba Alooni: Nadabu, omubereberye, ne Abiku, ne Eriyazaali, ne Isamaali. ");
INSERT INTO lug_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ago ge mannya ga batabani ba Alooni, abaafukibwako amafuta ag’omuzeeyituuni okuba bakabona, era abaayawulibwa okuweereza mu mulimu gw’obwakabona. ");
INSERT INTO lug_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Naye nno Nadabu ne Abiku baatondokera mu maaso ga Mukama ne bafa, kubanga baayokya ekiweebwayo eri Mukama Katonda n’omuliro ogutakkirizibwa nga bali mu ddungu ly’e Sinaayi. Tebaalina baana; bwe batyo, Eriyazaali ne Isamaali ne basigala nga be bokka abaaweerezanga nga bakabona ebbanga lyonna kitaabwe Alooni lye yamala nga mulamu. ");
INSERT INTO lug_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Leeta ab’omu kika kya Leevi obakwase Alooni kabona bamuweerezenga. ");
INSERT INTO lug_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Banaamukoleranga emirimu era ne baweereza n’ekibiina kyonna awali Eweema ey’Okukuŋŋaanirangamu, nga bakola emirimu awali Eweema ya Mukama. ");
INSERT INTO lug_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Banaalabiriranga ebintu byonna eby’omu Weema ey’Okukuŋŋaanirangamu, ne bakola emirimu gy’omu Weema ya Mukama nga batuukiriza ebyo byonna ebivunaanyizibwa abaana ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Abaleevi onoobawanga eri Alooni ne batabani be; baweereddwa ddala Alooni nga baggyibwa mu baana ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Onoolonda Alooni ne batabani be okubeera bakabona; naye bwe wanaabangawo omuntu omulala yenna n’asembera awatukuvu, anaafanga.” ");
INSERT INTO lug_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Mukama Katonda n’ayongera okugamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Laba, neetwalidde Abaleevi nga mbaggya mu baana ba Isirayiri mu kifo ky’abaana ababereberye abazaalibwa abakazi mu baana ba Isirayiri. Abaleevi banaabanga bange, ");
INSERT INTO lug_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","kubanga byonna ebizaalibwa ebibereberye byange. Bwe natta ebibereberye byonna mu nsi y’e Misiri neeyawulira ebibereberye byonna mu Isirayiri okubeeranga ebyange, abantu n’ebisolo. Nze Mukama Katonda.” ");
INSERT INTO lug_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Awo Mukama Katonda n’agamba Musa mu ddungu ly’e Sinaayi nti, ");
INSERT INTO lug_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Bala Abaleevi bonna mu mpya zaabwe ne mu bika byabwe. Bala buli mwana mulenzi ow’omwezi ogumu n’okusingawo.” ");
INSERT INTO lug_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Bw’atyo Musa n’ababala nga Mukama Katonda bwe yamulagira, ng’ekigambo kya Mukama bwe kyali. ");
INSERT INTO lug_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Gano ge mannya ga batabani ba Leevi: Gerusoni, ne Kokasi, ne Merali. ");
INSERT INTO lug_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gano ge mannya g’abatabani ba Gerusoni ng’empya zaabwe bwe zaali: Libuni ne Simeeyi. ");
INSERT INTO lug_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Bano be batabani ba Kokasi ng’empya zaabwe bwe zaali: Amulaamu, ne Izukali ne Kebbulooni, ne Wuziyeeri. ");
INSERT INTO lug_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Bano be batabani ba Merali ng’empya zaabwe bwe zaali: Makuli ne Musi. Ebyo bye bika by’Abaleevi ng’empya za bakitaabwe bwe zaali. ");
INSERT INTO lug_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Mu Gerusoni mwe mwava oluggya lwa Abalibuni n’oluggya lwa Abasimeeyi; ezo nga z’empya za Abagerusoni. ");
INSERT INTO lug_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Abaana aboobulenzi okuva ku w’omwezi ogumu ogw’obukulu n’okusingawo abaabalibwa baali kasanvu mu ebikumi bitaano (7,500). ");
INSERT INTO lug_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ab’omu Gerusoni nga baakusiisiranga ku ludda olw’ebugwanjuba emmanju wa Weema ya Mukama. ");
INSERT INTO lug_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Omukulembeze w’empya za Abagerusoni yali Eriyasaafu mutabani wa Laeri. ");
INSERT INTO lug_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Abagerusoni be banaabanga n’obuvunaanyizibwa obw’okulabirira Eweema ey’Okukuŋŋaanirangamu, nga balabirira ebigibikkako n’eggigi ery’omu mulyango oguyingira mu Weema, ");
INSERT INTO lug_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","n’entimbe ez’omu luggya, n’entimbe ez’omu mizigo egiggulira ku luggya okwebungulula Weema n’ekyoto. Era banaalabiriranga n’emiguwa awamu n’ebintu byonna ebinaakozesebwanga ku mirimu egyo. ");
INSERT INTO lug_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Mu Kokasi mwe mwava oluggya lwa Abamulaamu, n’oluggya lwa Abayizukaali, n’oluggya lwa Abakebbulooni, n’oluggya lwa Abawuziyeeri; ezo z’empya za Abakokasi. ");
INSERT INTO lug_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Abaana aboobulenzi okuva ku w’omwezi ogumu ogw’obukulu n’okusingawo abaabalibwa baali kanaana mu lukaaga (8,600). Abakokasi be baweebwa obuvunaanyizibwa okulabiriranga awatukuvu. ");
INSERT INTO lug_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ab’omu Kokasi nga baakusiisiranga ku ludda olw’obukiikaddyo obwa Weema ya Mukama. ");
INSERT INTO lug_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Omukulembeze w’empya za Abakokasi yali Erizafani mutabani wa Wuziyeeri. ");
INSERT INTO lug_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Abakokasi be baabanga n’obuvunaanyizibwa okulabirira Essanduuko ey’Endagaano, n’emmeeza, n’ekikondo ky’ettaala, n’ebyoto, n’ebintu eby’omu watukuvu ebikozesebwa mu kuweereza, n’eggigi; n’emirimu gyonna egyekuusa ku buweereza obwo. ");
INSERT INTO lug_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eriyazaali mutabani wa Alooni kabona ye yalondebwa okuba omukulu w’abakulembeze ba Abaleevi, era n’okulabirira abo abaaweerezanga mu watukuvu. ");
INSERT INTO lug_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Mu Merali mwe mwava oluggya lwa Abamakuli n’oluggya lwa Abamusi; ezo nga ze mpya za Abamerali. ");
INSERT INTO lug_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Abaana aboobulenzi okuva ku w’omwezi ogumu n’okusingawo abaabalibwa baali kakaaga mu ebikumi bibiri (6,200). ");
INSERT INTO lug_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Omukulembeze w’empya za Abamerali yali Zuliyeeri mutabani wa Abikayiri; Abamerali nga baakusiisiranga ku bukiikaddyo obwa Weema ya Mukama. ");
INSERT INTO lug_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Be baavunaanyizibwanga emikiikiro, n’empagi, n’ebikondo, n’ebikwata ku Weema ya Mukama byonna n’ebyekuusa ku mirimu gyayo. ");
INSERT INTO lug_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Okwo baagattangako empagi zonna ezeebunguludde oluggya n’entobo zaazo, n’enkondo za Weema n’emiguwa. ");
INSERT INTO lug_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa ne Alooni ne batabani baabwe baasiisiranga ku ludda olw’ebuvanjuba olwa Weema ya Mukama, okwolekera enjuba gy’eva mu maaso ga Weema ya Mukama ey’Okukuŋŋaanirangamu. Baavunaanyizibwanga okulabirira awatukuvu ku lw’abaana ba Isirayiri. Omuntu omulala yenna eyasembereranga awatukuvu, ng’ateekwa kufa. ");
INSERT INTO lug_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Omuwendo gwonna ogw’Abaleevi abaabalibwa ng’empya zaabwe bwe zaali, nga mwe muli abaana aboobulenzi okuva ku w’omwezi ogumu n’okusingawo, nga Mukama Katonda bwe yalagira Musa ne Alooni, baali emitwalo ebiri mu enkumi bbiri (22,000). ");
INSERT INTO lug_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Mukama Katonda n’agamba Musa nti, “Bala abaana ba Isirayiri bonna aboobulenzi ababereberye okuva ku mwana ow’omwezi ogumu n’okusingawo okole olukalala lw’amannya gaabwe gonna. ");
INSERT INTO lug_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Era ojja kunfunira Abaleevi mu kifo ky’ababereberye ab’abaana ba Isirayiri, era onfunire n’ente ez’Abaleevi mu kifo ky’ente ez’abaana ba Isirayiri embereberye. Nze Mukama Katonda.” ");
INSERT INTO lug_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Awo Musa n’abala abaana ba Isirayiri ababereberye nga Mukama Katonda bwe yamulagira. ");
INSERT INTO lug_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Okugatta awamu abaana aboobulenzi ababereberye bonna okuva ku w’omwezi ogumu n’okusingawo abaabalibwa, nga n’amannya gaabwe gawandiikiddwa ku lukalala, baali emitwalo ebiri mu enkumi bbiri mu ebikumi bibiri mu nsanvu mu basatu. ");
INSERT INTO lug_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Nfunira Abaleevi badde mu kifo ky’abaana ba Isirayiri ababereberye, n’ente z’Abaleevi zidde mu kifo ky’ente z’abaana ba Isirayiri, era Abaleevi banaabanga bange. Nze Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Okununula ababereberye ab’abaana ba Isirayiri ebikumi ebibiri mu ensanvu mu abasatu abasukkirira ku muwendo gw’Abaleevi abasajja, ");
INSERT INTO lug_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","onoddiranga gulaamu amakumi ataano mu ttaano ku buli omu, ng’ogeraageranyiza ku gulaamu kkumi n’emu ey’awatukuvu nga bw’eri, ye sekeri ey’obuzito ze gulaamu kkumi n’emu n’ekitundu. ");
INSERT INTO lug_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ensimbi ez’okununula abaana ba Isirayiri abasukkiriramu oziwanga Alooni ne batabani be.” ");
INSERT INTO lug_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Bw’atyo Musa n’asolooza ensimbi ez’okwenunula ku abo abaasukkirira ku muwendo gw’abo abaanunulibwa Abaleevi. ");
INSERT INTO lug_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Yasolooza ku babereberye ab’abaana ba Isirayiri effeeza ey’obuzito obwa kilo kkumi na ttaano n’ekitundu, ng’engeraageranya ya sekeri y’awatukuvu bw’eri. ");
INSERT INTO lug_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Musa n’addira ensimbi ez’okwenunula n’aziwa Alooni ne batabani be, ng’ekigambo kya Mukama bwe kyali, nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Mukama Katonda n’agamba Musa ne Alooni nti, ");
INSERT INTO lug_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Mubale batabani ba Kokasi abava mu kika ky’Abaleevi, ng’empya zaabwe n’ennyumba z’abakadde baabwe bwe ziri. ");
INSERT INTO lug_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Mubabale nga muva ku basajja ab’emyaka amakumi asatu egy’obukulu okutuuka ku b’emyaka amakumi ataano, abayinza okuyingira mu buweereza obw’okukola emirimu mu Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Gino gye mirimu eginaakolwanga batabani ba Kokasi mu Weema ey’Okukuŋŋaanirangamu: nga gya kulabirira ebintu ebitukuvu ennyo. ");
INSERT INTO lug_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Olusiisira bwe lunaabanga lusitula, Alooni ne batabani be banaayingirangamu, ne batimbulula eggigi ery’olutimbe ne balibikka ku Ssanduuko ey’Endagaano. ");
INSERT INTO lug_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Okwo banaabikkangako amaliba ga lukwata, kuno ne babikkako olugoye olwa bbululu omuka, ne balyoka basonsekamu emisituliro gyayo. ");
INSERT INTO lug_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Ku mmeeza ey’Emigaati egy’Okulaga banaayaliirangako ekitambala ekya bbululu, ne bassaako amasowaane, n’ebijiiko ebinene, n’amabakuli, n’ejaagi omunaabeeranga ebiweebwayo ebyokunywa; n’emigaati egy’okulaga nagyo ginaabeeranga okwo. ");
INSERT INTO lug_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Banaayaliirangako ekitambaala ekimyufu ennyo, ne bakibikkako amaliba ga lukwata; ne basonsekamu emisituliro gyayo. ");
INSERT INTO lug_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Banaddiranga ekitambaala ekya bbululu ne bakibikka ku kikondo ky’ettaala kwe zinaayakiranga, n’ettabaaza zaako, n’ebikomola entambi n’ensuniya ez’ebisirinza, n’ejaagi ez’amafuta ag’omuzeeyituuni aganaakozesebwanga mu ttaala ezo. ");
INSERT INTO lug_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ekikondo n’ebigenderako byonna binaasibibwanga mu maliba ga lukwata ne biteekebwa ku musituliro. ");
INSERT INTO lug_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Banaayaliiranga olugoye olwa bbululu ku kyoto ekya zaabu, okwo ne babikkako amaliba ga lukwata, ne basonsekamu emisituliro gyakyo. ");
INSERT INTO lug_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Banaddiranga ebintu byonna ebinaakozesebwanga ku mirimu gy’obuweereza mu watukuvu ne babiteeka mu lugoye olwa bbululu ne babibikkako amaliba ga lukwata, ne babiteeka ku misituliro gyabyo. ");
INSERT INTO lug_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ekyoto banaakiggyangamu evvu ne bakibikkako olugoye olwa ffulungu; ");
INSERT INTO lug_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ne balyoka bakissaako ebintu byonna ebikozesebwa mu mirimu gy’oku kyoto, nga mwe muli ensiniya ez’omuliro, n’ewuuma, n’ebijiiko n’ebibya. Okwo banaabikkangako amaliba ga lukwata, ne balyoka basonsekamu emisituliro gyakyo. ");
INSERT INTO lug_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Alooni ne batabani be bwe banaamalanga okusibako awatukuvu ne byonna ebibeeramu, nga n’ekiseera ky’olusiisira okusitula mu lugendo kituuse; awo batabani ba Kokasi banajjanga ne babisitula, naye ekintu kyonna ekitukuvu tebakikwatangako, baleme okufa. Ebyo bye bintu eby’omu Weema ey’Okukuŋŋaanirangamu batabani ba Kokasi bye baneetikkanga. ");
INSERT INTO lug_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eriyazaali, mutabani wa Alooni kabona, y’anaabeeranga n’obuvunaanyizibwa obw’amafuta g’ettaala ag’omuzeeyituuni, n’obubaane obwakaloosa, n’ekiweebwayo eky’okulaga eky’emmere ey’empeke, n’amafuta ag’omuzeeyituuni ag’okwawula. Era y’anaalabiriranga Eweema ya Mukama ne byonna ebigirimu, n’awatukuvu ne byonna ebikozesezebwamu.” ");
INSERT INTO lug_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Mukama Katonda n’agamba Musa ne Alooni nti, ");
INSERT INTO lug_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Mwegendereze ab’omu mpya z’ennyumba z’Abakokasi baleme okukutulwa ku kika ky’Abaleevi. ");
INSERT INTO lug_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ekyo munaakibakoleranga, bwe batyo bwe banaasembereranga ebintu ebitukuvu ennyo balemenga okufa, naye basigalenga nga balamu. Alooni ne batabani be banaayingiranga mu watukuvu ne bagabira buli Mukokasi omulimu gwe n’ebyo by’aneetikkanga. ");
INSERT INTO lug_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Naye Abakokasi tebaayingirenga munda kutunula ku bintu ebitukuvu, wadde n’eddakiika emu, balemenga okufa.” ");
INSERT INTO lug_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Bala ne batabani ba Gerusoni ng’empya zaabwe n’ennyumba z’abakadde baabwe bwe ziri. ");
INSERT INTO lug_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Babale ng’otandikira ku basajja ab’emyaka amakumi asatu egy’obukulu okutuuka ku b’emyaka amakumi ataano, abayinza okuyingira mu buweereza obw’okukola emirimu egya Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Gino gye mirimu eginaakolebwanga ab’omu mpya z’Abagerusoni mu kuweereza era ne mu kwetikka emigugu: ");
INSERT INTO lug_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Baneetikkanga entimbe ez’omu Weema ya Mukama, y’Eweema ey’Okukuŋŋaanirangamu n’ebigibikkako, n’amaliba aga lukwata agabikkibwa kungulu kwayo, n’entimbe ez’omu mulyango gwa Weema ey’Okukuŋŋaanirangamu, ");
INSERT INTO lug_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","n’entimbe ez’omu luggya olwebungulula Weema ya Mukama n’ekyoto, n’olutimbe lw’omulyango gw’oluggya, n’emiguwa, ne byonna ebinaakozesebwanga mu kuweereza okwo. Abagerusoni banaakolanga byonna ebineetaagibwanga okukola ku bintu ebyo. ");
INSERT INTO lug_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Mu kuweereza kwonna okw’Abagerusoni, oba mu kwetikka oba mu kukola emirimu egy’engeri endala, Alooni ne batabani be, be banaabalagiranga. Abagerusoni ojjanga kubakwasa obuvunaanyizibwa bwonna ku ebyo bye baneetikkanga. ");
INSERT INTO lug_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Obwo bwe buweereza bwa batabani ba Gerusoni nga bukwata ku Weema ey’Okukuŋŋaanirangamu. Bye banaakolanga binaalabirirwanga Isamaali mutabani wa Alooni kabona. ");
INSERT INTO lug_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Batabani ba Merali nabo babale ng’empya zaabwe n’ennyumba z’abakadde baabwe bwe ziri. ");
INSERT INTO lug_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Babale ng’otandikira ku basajja ab’emyaka amakumi asatu egy’obukulu okutuuka ku b’emyaka amakumi ataano, abayinza okuyingira mu buweereza obw’okukola emirimu egya Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Gino gye ginaabanga emirimu gyabwe egikwata ku Weema ey’Okukuŋŋaanirangamu: okusitula omudaala gwa Weema ya Mukama, n’embaawo zaayo, n’empagi n’ebibya mwe zituula, ");
INSERT INTO lug_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","awamu n’empagi ezeebungulula oluggya n’ebibya byazo mwe zituula, n’enkondo z’eweema, n’emiguwa, ne byonna ebyetaagibwa okukozesebwa ku mirimu egyo. Buli musajja onoomutegeezanga amannya g’ebintu byennyini by’ajjanga okwetikka. ");
INSERT INTO lug_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Egyo gye ginaabanga emirimu gy’omu mpya z’abaana ba Merali nga bali mu buweereza bwabwe obwa Weema ey’Okukuŋŋaanirangamu, nga bakulemberwa Isamaali mutabani wa Alooni kabona.” ");
INSERT INTO lug_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Awo Musa ne Alooni n’abakulembeze b’abantu ne babala batabani b’Abakokasi ng’empya zaabwe n’ennyumba z’abakadde baabwe bwe zaali. ");
INSERT INTO lug_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Ne bababala nga batandikira ku basajja ab’emyaka amakumi asatu egy’obukulu okutuuka ku myaka amakumi ataano, abajja okuweereza mu Weema ey’Okukuŋŋaanirangamu, ");
INSERT INTO lug_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","nga bababala ng’empya zaabwe bwe zaali; baawera enkumi bbiri mu lusanvu mu amakumi ataano (2,750). ");
INSERT INTO lug_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ogwo gwe gwali omuwendo gwonna ogw’abo abaali mu mpya z’Abakokasi abaaweerezanga mu Weema ey’Okukuŋŋaanirangamu. Musa ne Alooni baababala nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Batabani ba Gerusoni nabo baabalibwa ng’empya zaabwe bwe zaali n’ennyumba z’abakadde baabwe bwe zaali. ");
INSERT INTO lug_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Abasajja bonna okuva ku b’emyaka amakumi asatu egy’obukulu okutuuka ku b’emyaka amakumi ataano abaaweerezanga mu mirimu egy’omu Weema ey’Okukuŋŋaanirangamu, ");
INSERT INTO lug_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","baabalibwa ng’empya zaabwe n’ennyumba z’abakadde baabwe bwe zaali, ne bawera enkumi bbiri mu lukaaga mu amakumi asatu (2,630). ");
INSERT INTO lug_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ogwo gwe gwali omuwendo gwonna ogwa batabani ba Gerusoni abaali mu mpya za Abagerusoni abaaweerezanga mu Weema ey’Okukuŋŋaanirangamu. Musa ne Alooni baababala nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Batabani ba Merali baabalibwa ng’empya zaabwe n’ennyumba z’abakadde baabwe bwe zaali. ");
INSERT INTO lug_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Abasajja bonna okuva ku b’emyaka amakumi asatu egy’obukulu okutuuka ku b’emyaka amakumi ataano abajja okuweereza mu mirimu gy’omu Weema ey’Okukuŋŋaanirangamu, ");
INSERT INTO lug_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","abaabalibwa ng’empya zaabwe bwe zaali baali bawera enkumi ssatu mu ebikumi bibiri (3,200). ");
INSERT INTO lug_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ogwo gwe gwali omuwendo gwonna ogwabalibwa ogw’omu mpya za batabani ba Merali. Musa ne Alooni baababala nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Bwe batyo Musa ne Alooni n’abakulembeze ba Isirayiri ne babala Abaleevi bonna mu mpya zaabwe ne mu nnyumba z’abakadde baabwe. ");
INSERT INTO lug_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Abasajja bonna okuva ku b’emyaka amakumi asatu egy’obukulu okutuuka ku b’emyaka amakumi ataano abajja okuweereza mu mirimu egy’omu Weema ey’Okukuŋŋaanirangamu, ");
INSERT INTO lug_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","abaabalibwa baawera kanaana mu ebikumi bitaano mu kinaana (8,580). ");
INSERT INTO lug_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Buli musajja yaweebwa omulimu ogw’okukola n’ategeezebwa ky’aneetikka, nga Mukama Katonda bwe yalagira Musa. Bwe batyo bonna ne babalibwa nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Lagira abaana ba Isirayiri buli mugenge bamufulumye ebweru w’olusiisira, na buli alina ekikulukuto ky’omusaayi, n’oyo anaabanga akutte ku mufu. ");
INSERT INTO lug_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Abasajja n’abakazi bonna babafulumyenga ebweru w’olusiisira baleme okulufuula olutali lulongoofu, kubanga omwo mwe mbeera.” ");
INSERT INTO lug_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Awo abaana ba Isirayiri ne bakolanga bwe batyo ne babafulumyanga ebweru w’olusiisira. Ne bakola nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Tegeeza abaana ba Isirayiri nti, ‘Omuntu yenna omusajja oba omukazi bw’anaasobyanga eri munne mu ngeri yonna, bw’atyo anaabanga asobezza eri Mukama Katonda, omuntu oyo anaabangako omusango, ");
INSERT INTO lug_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","era asaana ayatule ekibi ekyo ky’anaabanga akoze. Anaaliwanga mu bujjuvu olw’ekibi ekyo ky’anaabanga akoze, n’agattako n’ekitundu ekimu ekyokutaano eky’ebyo by’anaabanga aliye, byonna anaabiwanga oyo gw’anaabanga azizzaako omusango. ");
INSERT INTO lug_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Naye singa omuntu oyo azzibbwako omusango taabengawo na waaluganda lwa kumpi, eby’okuliwa ebyo binaabanga bya Mukama Katonda era n’endiga ennume ey’okutangiririra oyo eyazza omusango, binaaweebwanga kabona. ");
INSERT INTO lug_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Era ebirabo byonna ebitukuvu abaana ba Isirayiri bye banaaleetanga eri kabona binaabanga bya kabona oyo. ");
INSERT INTO lug_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ekirabo kya buli muntu ekitukuvu kinaabanga kikye, naye ekyo ky’anaaleeteranga kabona kinaabanga kya kabona.’ ” ");
INSERT INTO lug_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Tegeeza abaana ba Isirayiri nti, Muka omusajja yenna bw’anaakyamanga n’akola ebitali bya bwesigwa eri bba ");
INSERT INTO lug_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ne yeebaka n’omusajja omulala nga bba tategedde, omusajja oyo n’amusobyako, ekikolwa ekyo ne kitamanyibwa, kubanga tewali mujulizi akirabye era nga tebabakutte nga bakikola; ");
INSERT INTO lug_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","singa omusajja akwatibwa ebbuba n’ateebereza nti osanga mukazi we baamusobezzaako, oba ebbuba ne limukwata newaakubadde nga mukazi we tebaamusobezzaako, ");
INSERT INTO lug_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","kale anaaleetanga mukazi we eri kabona. Anaaleetanga n’ekyokuwaayo ku lwa mukazi we ekitundu kimu eky’ekkumi ekya efa eky’obuwunga bw’emmere eyitibwa sayiri. Obuwunga obwo taabufukengako mafuta ag’omuzeeyituuni wadde okubussaamu ebyakawoowo, kubanga bwe buwunga obuweereddwayo ku nsonga y’ebbuba, nga kye kiweebwayo eky’okujjukiza nti waliwo omusango ogwazzibwa. ");
INSERT INTO lug_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Kabona anaasembezanga omukazi oyo n’amuleeta n’amuyimiriza mu maaso ga Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Anaddiranga amazzi amatukuvu nga gali mu kijaagi eky’ebbumba n’ateeka mu mazzi ago enfuufu gy’anaggyanga wansi mu Weema. ");
INSERT INTO lug_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Kabona bw’anaamalanga okuyimiriza omukazi oyo mu maaso ga Mukama Katonda, anaamusumululanga enviiri ze n’azita ne zikka, n’amukwasa ekiweebwayo eky’okujjukiza eky’emmere y’empeke ekiweereddwayo olw’obuggya, ye kabona ng’akutte amazzi agakaawa agaleeta ekikolimo. ");
INSERT INTO lug_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Kabona anaalayizanga omukazi oyo n’amugamba bw’ati nti, ‘Obanga tewali musajja yenna eyeebase naawe mu kyama n’ofuuka atali mulongoofu songa oli mu bufumbo ewa balo, amazzi agakaawa gano agaleeta ekikolimo tegaakukole kabi.’ ");
INSERT INTO lug_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Naye bw’onoowabanga ne weebaka n’omusajja atali balo, bw’otyo ne weeyonoonyesa, ");
INSERT INTO lug_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","wano kabona anaalayizanga omukazi ekirayiro eky’ekikolimo n’amugamba nti, ‘Mukama Katonda aleetere abantu bo okukukolimira n’okukuboola bw’anaakoozimbyanga ekisambi kyo n’olubuto lwo n’aluleetera entumbi ne luzimba. ");
INSERT INTO lug_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Amazzi gano agaleeta ekikolimo gayingirenga mu mubiri gwo gazimbye olubuto lwo era n’ekisambi kyo kikoozimbe.’ “Omukazi anaddangamu nti, ‘Amiina, Amiina.’ ");
INSERT INTO lug_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Kabona anaawandiikanga ebikolimo ebyo ku muzingo n’abyozaako mu mazzi agakaawa. ");
INSERT INTO lug_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Anaanywesanga omukazi amazzi agakaawa agaleeta ekikolimo, era amazzi ago ganaayingiranga mu mukazi oyo ne gamuleetera obulumi n’okubonaabona mu mubiri. ");
INSERT INTO lug_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Awo kabona anaggyangako omukazi oyo ekiweebwayo eky’empeke olw’obuggya, anaawuubanga ekiweebwayo ekyo eky’empeke mu maaso ga Mukama Katonda, n’akireeta ku kyoto. ");
INSERT INTO lug_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Kabona anaddiranga olubatu lw’obuwunga obw’ekiweebwayo ng’ekiweebwayo olw’okujjukira n’akyokya ku kyoto; ebyo nga biwedde anaanywesanga omukazi amazzi gali. ");
INSERT INTO lug_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Bw’anaamalanga okumunywesa amazzi ago, kale bw’anaabanga yeeyonoonyesezza nga tabadde mwesigwa eri bba, amazzi ago agaleeta ekikolimo ganaayingiranga mu mubiri gw’omukazi oyo ne gamuleetera obulumi obubalagala; olubuto lwe lunaazimbulukukanga n’ekisambi kye ne kikoozimba, era anaafuukanga omukolimire mu bantu b’ewaabwe. ");
INSERT INTO lug_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Naye omukazi oyo bw’anaabanga teyeeyonoonyesa nga mulongoofu, kale taabeerengako musango, era anaabanga wa ddembe okuzaala abaana.’ ");
INSERT INTO lug_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Eryo lye tteeka ery’obuggya, omukazi bw’anaakyamanga ne yeeyonoona songa mufumbo aliko bba, ");
INSERT INTO lug_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","oba omusajja bw’anaayingirangamu omwoyo ogw’ebbuba, n’akwatirwa mukazi we obuggya; kale anaaleetanga mukazi we oyo eri Mukama Katonda, kabona n’alyoka assa etteeka eryo mu nkola ku mukazi oyo. ");
INSERT INTO lug_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Balo taabengako kyonoono ku nsonga ezo wabula mukazi we y’anaabangako omusango olw’okwonoona kwe.’ ” ");
INSERT INTO lug_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Tegeeza abaana ba Isirayiri nti, Omusajja oba omukazi bw’anaabanga ayagala okukola obweyamo obw’enjawulo obutali bwa bulijjo ne yeetukuza ne yeeyawula eri Mukama ng’Omunazaalayiti, ");
INSERT INTO lug_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","anaateekwanga obutanywa nvinnyo n’ekyokunywa ekirala kyonna ekitamiiza, era taanywenga nvinnyo wadde ekitamiiza ekirala kyonna ekikaatuuse. Era taalyenga ku bibala bya mizabbibu wadde ensigo zaabyo. ");
INSERT INTO lug_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ebbanga lyonna ly’anaamalanga nga Munnazaalayiti taalyenga ku kintu kyonna ekiva mu mizabbibu newaakubadde ensigo wadde ebikuta. ");
INSERT INTO lug_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Ebbanga lyonna ly’anaamalanga ng’ali mu bweyamo bwe obwo, kkirita teyitenga ku mutwe gwe. Anaabanga mutukuvu eri Mukama Katonda okutuusa ekiseera kye eky’okweyawula nga kiweddeko; era enviiri ez’oku mutwe gwe anaazirekanga ne zikula ne ziwanvuwa. ");
INSERT INTO lug_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Ebbanga lyonna ly’anaamalanga mu bweyamo bwe obwo eri Mukama Katonda, taasembererenga muntu afudde. ");
INSERT INTO lug_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Newaakubadde kitaawe, oba nnyina, oba muganda we oba mwannyina nga kwe kuli afudde, taabasembererenga alemenga okufuuka atali mulongoofu, kubanga akabonero ak’obweyamo obw’okweyawula eri Katonda kanaabanga kali ku mutwe gwe. ");
INSERT INTO lug_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Okumala ebbanga lyonna ery’obweyamo bwe obw’okweyawula, anaabanga mutukuvu eri Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Omuntu bw’anaafanga ekikutuko ng’aliraanye omuwonge oyo, bw’atyo n’afuula enviiri ze okuba ezitali nnongoofu, kale, anaamwanga omutwe gwe ku lunaku olw’okwerongoosa, lwe lunaku olw’omusanvu. ");
INSERT INTO lug_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ku lunaku olw’omunaana anaaleetanga amayiba abiri oba enjiibwa ento bbiri eri kabona ku mulyango gwa Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Kabona anaawangayo ekimu ku ebyo ng’ekiweebwayo olw’ekibi, n’ekyokubiri ng’ekiweebwayo ekyokebwa olw’okumutangiririra kubanga yali ayonoonye bwe yaliraana omuntu afudde. Ku lunaku olwo lwe lumu, kw’anaatukulizangako omutwe gwe. ");
INSERT INTO lug_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Aneewangayo eri Mukama Katonda okumala ebbanga lyonna ery’obweyamo bwe obw’okweyawula, era anaaleetanga omwana gw’endiga omulume n’aguwaayo ng’ekiweebwayo olw’okusingibwa omusango. Ennaku ezaasooka teziibalibwenga kubanga yafuuka atali mulongoofu mu bbanga ery’obweyamo bwe obw’okweyawula. ");
INSERT INTO lug_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Lino ly’etteeka erinaakwatanga ku Munnazaalayiti ebbanga lye ery’obweyamo obw’okweyawula bwe linaggwangako. Anaaleetebwanga ku mulyango gwa Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Anaawangayo ebirabo bye eby’ebiweebwayo eri Mukama Katonda, bye bino: omwana gw’endiga omulume ogw’omwaka ogumu ogw’obukulu ogutaliiko kamogo nga gwe gw’ekiweebwayo ekyokebwa; n’omwana gw’endiga omuluusi ogutaliiko kamogo nga gwe gw’ekiweebwayo olw’ekibi; n’endiga ennume etaliiko kamogo nga ye y’ekiweebwayo olw’emirembe; ");
INSERT INTO lug_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","n’ekibbo ky’emigaati egitali mizimbulukuse; ne kkeeke ezikoleddwa mu buwunga obulungi obutabuddwamu n’amafuta ag’omuzeeyituuni agafumba; n’obusukuuti obw’oluwewere obutali buzimbulukuse obusiigiddwako amafuta ag’omuzeeyituuni, n’ebiweebwayo eby’emmere y’empeke n’ebiweebwayo eby’ebyokunywa. ");
INSERT INTO lug_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Kabona anaabireetanga awali Mukama Katonda, n’awaayo ekiweebwayo kye olw’ekibi n’ekiweebwayo kye ekyokebwa. ");
INSERT INTO lug_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Anaawangayo endiga ennume nga ssaddaaka ey’ekiweebwayo olw’emirembe eri Mukama Katonda awamu n’ekibbo ky’emigaati egitali mizimbulukuse; era kabona anaawangayo ekiweebwayo eky’emmere y’empeke n’ekiweebwayo eky’ebyokunywa. ");
INSERT INTO lug_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Omunnazaalayiti anaamweranga omutwe gwe ogw’obuwonge bwe ku mulyango gwa Weema ey’Okukuŋŋaanirangamu; anaddiranga enviiri ezivudde ku mutwe ogw’obuwonge bwe n’azissa ku muliro oguli wansi wa ssaddaaka ey’ekiweebwayo olw’emirembe. ");
INSERT INTO lug_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Omunnazaalayiti bw’anaamalanga okumwa omutwe gwe ogw’obuwonge bwe, kabona anaddiranga omukono gw’endiga omufumbe, n’aggya ne kkeeke etali nzimbulukuse emu mu kibbo, n’akasukuuti ak’oluwewere akatali kazimbulukuse kamu, n’abimukwasa mu ngalo ze. ");
INSERT INTO lug_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Kabona anaabiwuubanga nga kye kiweebwayo ekiwuubibwa mu maaso ga Mukama Katonda. Binaabanga bitukuvu era nga bya kabona awamu n’ekifuba ekiwuubibwa n’ekisambi ekinaaweebwangayo. Ebyo bwe binaggwanga, Omunnazaalayiti anaayinzanga okunywa envinnyo. ");
INSERT INTO lug_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Eryo lye tteeka ery’Omunnazaalayiti aneeyamanga okwewaayo eri Mukama Katonda ng’obweyamo bwe obw’okweyawula bwe bunaabanga, ng’agasseeko n’ebirala nga bw’anaasobolanga. Anaateekwanga okutuukiriza obweyamo bwe bwanaabanga akoze, ng’etteeka ly’Omunnazaalayiti bwe liragira.” ");
INSERT INTO lug_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Tegeeza Alooni ne batabani be nti, Bwe muti bwe munaasabiranga abaana ba Isirayiri omukisa: munaabagambanga nti: ");
INSERT INTO lug_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Mukama Katonda akuwe omukisa, akukuume; ");
INSERT INTO lug_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Mukama Katonda akwakize amaaso ge akukwatirwe ekisa; ");
INSERT INTO lug_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Mukama Katonda akwolekeze amaaso ge akuwe emirembe.’ ");
INSERT INTO lug_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Bwe batyo banaateekanga erinnya lyange ku baana ba Isirayiri, nange naabawanga omukisa.” ");
INSERT INTO lug_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Awo olwatuuka ku lunaku olwo, Musa bwe yamala okusimba Weema ya Mukama, n’agifukako amafuta ag’omuzeeyituuni n’agitukuza ne byonna ebikozesebwa mu yo, era n’afuka amafuta ag’omuzeeyituuni ku kyoto n’akitukuza n’ebintu byakyo byonna. ");
INSERT INTO lug_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Abakulembeze ba Isirayiri, abakulu b’empya za bakitaabwe era nga be bakulembeze b’ebika abaalina obuvunaanyizibwa eri abaabalibwa, ne baleeta ebiweebwayo byabwe. ");
INSERT INTO lug_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Baaleeta ebirabo byabwe eby’ebiweebwayo eri Mukama Katonda, amagaali agabikkiddwako mukaaga n’ente kkumi na bbiri, nga buli mukulembeze aleeta ente emu, na buli bakulembeze babiri nga baleeta eggaali emu. Ebyo byonna ne babiweerayo mu maaso ga Weema ya Mukama. ");
INSERT INTO lug_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Bye baleese bibaggyeeko, binaakozesebwanga ku mirimu gy’omu Weema ey’Okukuŋŋaanirangamu. Bikwase Abaleevi, nga buli mulimu gwa buli omu bwe gwetaagisa.” ");
INSERT INTO lug_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Bw’atyo Musa n’addira amagaali n’ente n’abiwa Abaleevi. ");
INSERT INTO lug_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Amagaali abiri n’ente nnya yaziwa batabani ba Gerusoni, ng’emirimu gyabwe bwe gyali, ");
INSERT INTO lug_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","n’addira amagaali ana n’ente munaana n’abiwa batabani ba Merali, ng’emirimu gyabwe bwe gyali; bonna nga bakulemberwa Isamaali mutabani wa Alooni, kabona. ");
INSERT INTO lug_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Naye abaana ba Kokasi, Musa teyabawaako, kubanga ebintu ebitukuvu bye baalinako obuvunaanyizibwa baabitwaliranga ku bibegabega byabwe. ");
INSERT INTO lug_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Bwe batyo abakulembeze ne bawaayo ebiweebwayo mu maaso g’ekyoto olw’okukitukuza, ku lunaku lwe kyafukibwako amafuta ag’omuzeeyituuni. ");
INSERT INTO lug_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Mukama n’agamba Musa nti, “Buli lunaku omukulembeze omu anaaleetanga ekiweebwayo kye olw’okutukuza ekyoto.” ");
INSERT INTO lug_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Eyaleeta ekiweebwayo kye ku lunaku olusooka yali Nakusoni mutabani wa Amminadaabu ow’omu kika kya Yuda. ");
INSERT INTO lug_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ekiweebwayo kye yali sowaani emu eya ffeeza, ng’obuzito epima kilo emu n’ekitundu, n’ekibya ekya ffeeza eky’okumansira ng’obuzito bwakyo bwali obutundu bwa kilo, munaana, byombi, essowaani n’ekibya, nga bipimibwa ng’ebipimo by’awatukuvu bwe biri; byombi nga bijjuziddwa obuwunga obulungi obutabuddwamu amafuta ag’omuzeeyituuni obw’ekiweebwayo eky’emmere y’empeke; ");
INSERT INTO lug_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","n’ekijiiko ekinene ekya zaabu kimu ng’obuzito kipima gulaamu kikumi mu kkumi, nga kijjudde ebyakaloosa; ");
INSERT INTO lug_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ente ya sseddume emu envubuka, endiga ennume emu, n’omwana gw’endiga omulume gumu oguwezezza omwaka gumu ogw’obukulu, olw’ekiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","embuzi ennume emu nga ya kiweebwayo olw’ekibi; ");
INSERT INTO lug_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","era olwa ssaddaaka ey’ebiweebwayo olw’emirembe: ente bbiri, endiga ennume ttaano, embuzi ennume ttaano, n’abaana b’endiga abalume bataano abawezezza omwaka gumu gumu ogw’obukulu. Ekyo kye kyali ekiweebwayo eri Mukama ekya Nakusoni mutabani wa Amminadaabu. ");
INSERT INTO lug_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ku lunaku olwokubiri Nesaneri mutabani wa Zuwaali, omukulembeze wa Isakaali, n’aleeta ekiweebwayo kye. ");
INSERT INTO lug_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ekirabo kye yaleeta yali sowaani eya ffeeza ng’epima obuzito bwa kilo emu n’ekitundu, n’ekibya ekya ffeeza omubeera eby’okumansira ng’obuzito bwakyo bwali obutundu bwa kilo, munaana, nga buli kimu kipimibwa ng’ebipimo by’awatukuvu bwe biri; byombi nga bijjuziddwa obuwunga obulungi obutabuddwamu amafuta ag’omuzeeyituuni obw’ekiweebwayo eky’emmere y’empeke; ");
INSERT INTO lug_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","n’ekijiiko ekinene ekya zaabu kimu ng’obuzito kipima gulaamu kikumi mu kkumi, nga kijjudde ebyakaloosa; ");
INSERT INTO lug_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ente ya sseddume emu envubuka, endiga ennume emu, n’omwana gw’endiga omulume gumu oguwezezza omwaka gumu ogw’obukulu, olw’ekiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","embuzi ennume emu nga ya kiweebwayo olw’ekibi; ");
INSERT INTO lug_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","era olwa ssaddaaka ey’ebiweebwayo olw’emirembe: ente bbiri, endiga ennume ttaano, embuzi ennume ttaano, n’abaana b’endiga abalume bataano abawezezza omwaka gumu gumu ogw’obukulu. Ekyo kye kyali ekiweebwayo eri Mukama ekya Nesaneri mutabani wa Zuwaali. ");
INSERT INTO lug_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ku lunaku olwokusatu Eriyaabu mutabani wa Keroni, omukulembeze w’abantu ba Zebbulooni, yaleeta ekiweebwayo kye. ");
INSERT INTO lug_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ekiweebwayo kye yali sowaani emu eya ffeeza ng’obuzito epima kilo emu n’ekitundu, n’ekibya ekya ffeeza omubeera eby’okumansira ng’obuzito bwakyo bwali obutundu bwa kilo, munaana, nga buli kimu kipimibwa ng’ebipimo by’awatukuvu bwe biri; byombi nga bijjuziddwa obuwunga obulungi obutabulemu amafuta ag’omuzeeyituuni obw’ekiweebwayo eky’emmere y’empeke; ");
INSERT INTO lug_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","n’ekijiiko ekinene ekya zaabu kimu ng’obuzito kipima gulaamu kikumi mu kkumi, nga kijjudde ebyakaloosa; ");
INSERT INTO lug_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ente eya sseddume emu nga nvubuka, endiga ennume emu, n’omwana gw’endiga omulume gumu nga guwezezza omwaka gumu ogw’obukulu, olw’ekiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","embuzi ennume emu nga ya kiweebwayo olw’ekibi; ");
INSERT INTO lug_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","era olwa ssaddaaka ey’ebiweebwayo olw’emirembe: ente bbiri, endiga ennume ttaano, embuzi ennume ttaano, n’abaana b’endiga abalume bataano abawezezza omwaka gumu gumu ogw’obukulu. Ekyo kye kyali ekiweebwayo eri Mukama ekya Eriyaabu mutabani wa Keroni. ");
INSERT INTO lug_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ku lunaku olwokuna Erizuuli mutabani wa Sedewuli, omukulembeze w’abantu ba Lewubeeni, n’aleeta ekiweebwayo kye. ");
INSERT INTO lug_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ekiweebwayo kye yali sowaani emu eya ffeeza ng’obuzito epima kilo emu n’ekitundu, n’ekibya ekya ffeeza omubeera eby’okumansira ng’obuzito bwakyo obutundu bwa kilo, munaana, nga buli kimu kipimibwa ng’ebipimo by’awatukuvu bwe biri, byombi nga bijjuziddwa obuwunga obulungi obutabulemu amafuta obw’ekiweebwayo eky’emmere y’empeke; ");
INSERT INTO lug_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","n’ekijiiko ekinene ekya zaabu kimu, ng’obuzito kipima gulaamu kikumi mu kkumi, nga kijjudde ebyakaloosa; ");
INSERT INTO lug_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ente eya sseddume emu envubuka, endiga ennume emu, n’omwana gw’endiga omulume gumu nga guwezezza omwaka gumu ogw’obukulu, olw’ekiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","embuzi ennume emu nga ya kiweebwayo olw’ekibi; ");
INSERT INTO lug_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","era olwa ssaddaaka ey’ebiweebwayo olw’emirembe: ente bbiri, endiga ennume ttaano, embuzi ennume ttaano, n’abaana b’endiga abalume bataano abawezezza omwaka gumu gumu ogw’obukulu. Ekyo kye kyali ekiweebwayo eri Mukama ekya Erizuuli mutabani wa Sedewuli. ");
INSERT INTO lug_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ku lunaku olwokutaano Serumiyeeri mutabani wa Zulisadaayi, omukulembeze w’abantu ba Simyoni, yaleeta ekiweebwayo kye. ");
INSERT INTO lug_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Ekiweebwayo kye yali sowaani emu eya ffeeza ng’obuzito epima kilo emu n’ekitundu, n’ekibya ekya ffeeza omubeera eby’okumansira ng’obuzito bwakyo bwali obutundu bwa kilo, munaana, nga buli kimu kipimibwa ng’ebipimo by’awatukuvu bwe biri, byombi nga bijjuziddwa obuwunga obulungi obutabulemu amafuta ag’omuzeeyituuni obw’ekiweebwayo eky’emmere y’empeke; ");
INSERT INTO lug_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","n’ekijiiko ekinene ekya zaabu kimu, ng’obuzito kipima gulaamu kikumi mu kkumi, nga kijjudde ebyakaloosa; ");
INSERT INTO lug_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ente eya sseddume emu envubuka, endiga ennume emu, n’omwana gw’endiga omulume gumu nga guwezezza omwaka gumu ogw’obukulu, olw’ekiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","embuzi ennume emu nga ya kiweebwayo olw’ekibi; ");
INSERT INTO lug_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","era olwa ssaddaaka ey’ebiweebwayo olw’emirembe: ente bbiri, endiga ennume ttaano, embuzi ennume ttaano, n’abaana b’endiga abalume bataano abawezezza omwaka gumu gumu ogw’obukulu. Ekyo kye kyali ekiweebwayo eri Mukama ekya Serumiyeeri mutabani wa Zulisadaayi. ");
INSERT INTO lug_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ku lunaku olw’omukaaga Eriyasaafu mutabani wa Deweri, omukulembeze w’abantu ba Gaadi, n’aleeta ekiweebwayo kye. ");
INSERT INTO lug_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Ekiweebwayo kye yali sowaani emu eya ffeeza ng’obuzito epima kilo emu n’ekitundu, n’ekibya ekya ffeeza omubeera eby’okumansira ng’obuzito bwakyo bwali obutundu bwa kilo, munaana, nga buli kimu kipimibwa ng’ebipimo by’awatukuvu bwe biri, byombi nga bijjuziddwa obuwunga obulungi obutabulemu amafuta ag’omuzeeyituuni obw’ekiweebwayo eky’emmere y’empeke; ");
INSERT INTO lug_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","n’ekijiiko ekinene ekya zaabu kimu ng’obuzito kipima gulaamu kikumi mu kkumi, nga kijjudde ebyakaloosa; ");
INSERT INTO lug_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ente eya sseddume emu envubuka, endiga ennume emu, n’omwana gw’endiga omulume gumu nga guwezezza omwaka gumu ogw’obukulu, olw’ekiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","embuzi ennume emu nga ya kiweebwayo olw’ekibi; ");
INSERT INTO lug_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","era olwa ssaddaaka ey’ebiweebwayo olw’emirembe: ente bbiri, endiga ennume ttaano, embuzi ennume ttaano, n’abaana b’endiga abalume bataano abawezezza omwaka gumu gumu ogw’obukulu. Ekyo kye kyali ekiweebwayo eri Mukama ekya Eriyasaafu mutabani wa Deweri. ");
INSERT INTO lug_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ku lunaku olw’omusanvu Erisaama mutabani wa Ammikudi, omukulembeze w’abantu ba Efulayimu, n’aleeta ekiweebwayo kye. ");
INSERT INTO lug_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Ekiweebwayo kye yali sowaani emu eya ffeeza ng’obuzito epima kilo emu n’ekitundu, n’ekibya kya ffeeza omubeera eby’okumansira ng’obuzito bwakyo bwali obutundu bwa kilo, munaana, nga buli kimu kipimibwa ng’ebipimo by’awatukuvu bwe biri, byombi nga bijjuziddwa obuwunga obulungi obutabulemu amafuta ag’omuzeeyituuni obw’ekiweebwayo eky’emmere y’empeke; ");
INSERT INTO lug_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","n’ekijiiko ekinene ekya zaabu kimu, ng’obuzito kipima gulaamu kikumi mu kkumi, nga kijjudde ebyakaloosa; ");
INSERT INTO lug_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ente eya sseddume emu envubuka, endiga ennume emu, n’omwana gw’endiga omulume gumu nga guwezezza omwaka gumu ogw’obukulu, olw’ekiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","embuzi ennume emu nga ya kiweebwayo olw’ekibi; ");
INSERT INTO lug_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","era olwa ssaddaaka ey’ebiweebwayo olw’emirembe: ente bbiri, endiga ennume ttaano, embuzi ennume ttaano, n’abaana b’endiga abalume bataano abawezezza omwaka gumu gumu ogw’obukulu. Ekyo kye kyali ekiweebwayo eri Mukama ekya Erisaama mutabani wa Ammikudi. ");
INSERT INTO lug_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ku lunaku olw’omunaana Gamalyeri mutabani wa Pedazuuli, omukulembeze w’abantu ba Manase, n’aleeta ekiweebwayo kye. ");
INSERT INTO lug_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Ekiweebwayo kye yali esowaani emu eya ffeeza ng’obuzito epima kilo emu n’ekitundu, n’ekibya ekya ffeeza omubeera eby’okumansira ng’obuzito bwakyo bwali obutundu bwa kilo, munaana, nga buli kimu kipimibwa ng’ebipimo by’awatukuvu bwe biri, byombi nga bijjuziddwa obuwunga obulungi obutabulemu amafuta ag’omuzeeyituuni obw’ekiweebwayo eky’emmere y’empeke; ");
INSERT INTO lug_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","n’ekijiiko ekinene ekya zaabu kimu, ng’obuzito kipima gulaamu kikumi mu kkumi, nga kijjudde ebyakaloosa; ");
INSERT INTO lug_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ente eya sseddume emu envubuka, endiga ennume emu, n’omwana gw’endiga omulume gumu nga guwezezza omwaka gumu ogw’obukulu, olw’ekiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","embuzi ennume emu nga ya kiweebwayo olw’ekibi; ");
INSERT INTO lug_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","era olwa ssaddaaka ey’ebiweebwayo olw’emirembe: ente bbiri, endiga ennume ttaano, n’abaana b’endiga abalume bataano abawezezza omwaka gumu gumu ogw’obukulu. Ekyo kye kyali ekiweebwayo eri Mukama ekya Gamalyeri mutabani wa Pedazuuli. ");
INSERT INTO lug_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ku lunaku olw’omwenda Abidaani mutabani wa Gidyoni, omukulembeze w’abantu ba Benyamini, n’aleeta ekiweebwayo kye. ");
INSERT INTO lug_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Ekiweebwayo kye yali sowaani emu eya ffeeza ng’obuzito epima kilo emu n’ekitundu, n’ekibya ekya ffeeza omubeera eby’okumansira ng’obuzito bwakyo bwali obutundu bwa kilo, munaana, nga buli kimu kipimibwa ng’ebipimo by’awatukuvu bwe biri; byombi nga bijjuziddwa obuwunga obulungi obutabulemu amafuta ag’omuzeeyituuni obw’ekiweebwayo eky’emmere y’empeke; ");
INSERT INTO lug_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","n’ekijiiko ekinene ekya zaabu kimu ng’obuzito kipima gulaamu kikumi mu kkumi, nga kijjudde ebyakaloosa; ");
INSERT INTO lug_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ente eya sseddume emu nga nvubuka, endiga ennume emu, n’omwana gw’endiga omulume gumu nga guwezezza omwaka gumu ogw’obukulu, olw’ekiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","embuzi ennume emu nga ya kiweebwayo olw’ekibi; ");
INSERT INTO lug_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","era olwa ssaddaaka ey’ebiweebwayo olw’emirembe: ente bbiri, endiga ennume ttaano, embuzi ennume ttaano, n’abaana b’endiga abalume bataano abawezezza omwaka gumu gumu ogw’obukulu. Ekyo kye kyali ekiweebwayo eri Mukama ekya Abidaani mutabani wa Gidyoni. ");
INSERT INTO lug_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ku lunaku olw’ekkumi Akiyezeeri mutabani wa Amisadaayi, omukulembeze w’abantu ba Ddaani, n’aleeta ekiweebwayo kye. ");
INSERT INTO lug_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ekiweebwayo kye yali essowaani emu eya ffeeza ng’obuzito epima kilo emu n’ekitundu, n’ekibya ekya ffeeza omubeera eby’okumansira ng’obuzito bwakyo bwali obutundu bwa kilo, munaana, nga buli kimu kipimibwa ng’ebipimo by’awatukuvu bwe biri; byombi nga bijjuziddwa obuwunga obulungi obutabulemu amafuta ag’omuzeeyituuni obw’ekiweebwayo eky’emmere y’empeke; ");
INSERT INTO lug_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","n’ekijiiko ekinene ekya zaabu kimu ng’obuzito kipima gulaamu kikumi mu kkumi, nga kijjudde ebyakaloosa; ");
INSERT INTO lug_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ente eya sseddume emu nga nvubuka, endiga ennume emu, n’omwana gw’endiga omulume gumu nga guwezezza omwaka gumu ogw’obukulu, olw’ekiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","embuzi ennume emu nga ya kiweebwayo olw’ekibi; ");
INSERT INTO lug_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","era olwa ssaddaaka ey’ebiweebwayo olw’emirembe: ente bbiri, endiga ennume ttaano, embuzi ennume ttaano, n’abaana b’endiga abalume bataano abawezezza omwaka gumu gumu ogw’obukulu. Ekyo kye kyali ekiweebwayo eri Mukama ekya Akiyezeeri mutabani wa Amisadaayi. ");
INSERT INTO lug_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ku lunaku olw’ekkumi n’olumu Pagiyeeri mutabani wa Okulaani, omukulembeze w’abantu ba Aseri, n’aleeta ekiweebwayo kye. ");
INSERT INTO lug_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Ekiweebwayo kye yali essowaani emu eya ffeeza ng’obuzito epima kilo emu n’ekitundu, n’ekibya ekya ffeeza omubeera eby’okumansira ng’obuzito bwakyo bwali obutundu bwa kilo, munaana, nga buli kimu kipimibwa ng’ebipimo by’awatukuvu bwe biri; byombi nga bijjuziddwa obuwunga obulungi obutabulemu amafuta ag’omuzeeyituuni obw’ekiweebwayo eky’emmere y’empeke; ");
INSERT INTO lug_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","n’ekijiiko ekinene ekya zaabu kimu ng’obuzito kipima gulaamu kikumi mu kkumi, nga kijjudde ebyakaloosa; ");
INSERT INTO lug_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ente eya sseddume emu nga nvubuka, endiga ennume emu, n’omwana gw’endiga omulume gumu nga guwezezza omwaka gumu ogw’obukulu, olw’ekiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","embuzi ennume emu nga ya kiweebwayo olw’ekibi; ");
INSERT INTO lug_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","era olwa ssaddaaka ey’ebiweebwayo olw’emirembe: ente bbiri, endiga ennume ttaano, embuzi ennume ttaano, n’abaana b’endiga abalume bataano abawezezza omwaka gumu gumu ogw’obukulu. Ekyo kye kyali ekiweebwayo eri Mukama ekya Pagiyeeri mutabani wa Ekulaani. ");
INSERT INTO lug_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ku lunaku olw’ekkumi n’ebbiri Akira mutabani wa Enani, omukulembeze w’abantu ba Nafutaali, yaleeta ekiweebwayo kye. ");
INSERT INTO lug_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ekiweebwayo kye yali essowaani emu eya ffeeza ng’obuzito epima kilo emu n’ekitundu, n’ekibya ekya ffeeza omubeera eby’okumansira ng’obuzito bwakyo bwali obutundu bwa kilo, munaana, nga buli kimu kipimibwa ng’ebipimo by’awatukuvu bwe biri; byombi nga bijjuziddwa obuwunga obulungi obutabulemu amafuta ag’omuzeeyituuni obw’ekiweebwayo eky’emmere y’empeke; ");
INSERT INTO lug_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","n’ekijiiko ekinene ekya zaabu kimu ng’obuzito kipima gulaamu kikumi mu kkumi nga kijjudde ebyakaloosa; ");
INSERT INTO lug_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ente eya sseddume emu nga nvubuka, endiga ennume emu, n’omwana gw’endiga omulume gumu nga guwezezza omwaka gumu ogw’obukulu, olw’ekiweebwayo ekyokebwa; ");
INSERT INTO lug_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","embuzi ennume emu nga ya kiweebwayo olw’ekibi; ");
INSERT INTO lug_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","era olwa ssaddaaka ey’ebiweebwayo olw’emirembe: ente bbiri, endiga ennume ttaano, embuzi ennume ttaano, n’abaana b’endiga abalume bataano abawezezza omwaka gumu gumu ogw’obukulu. Ekyo kye kyali ekiweebwayo eri Mukama ekya Akira mutabani wa Enani. ");
INSERT INTO lug_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Bino bye biweebwayo abakulembeze ba Isirayiri bye baaleeta olw’okutukuza ekyoto ku lunaku lwe kyafukibwako amafuta ag’omuzeeyituuni: essowaani eza ffeeza kkumi na bbiri, ebibya omubeera eby’okumansira kkumi na bibiri, n’ebijiiko ebinene ebya zaabu kkumi na bibiri. ");
INSERT INTO lug_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Buli sowaani eya ffeeza ng’epima obuzito bwa kilo emu n’ekitundu, na buli kibya omubeera eby’okumansira nga kipima obuzito bwa butundu bwa kilo, munaana. Okugatta awamu obuzito bw’essowaani ezo zonna n’obw’ebibya ebyo byonna bwali bupima kilo amakumi abiri mu munaana ng’ebipimo by’awatukuvu bwe byali. ");
INSERT INTO lug_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ebijiiko ebya zaabu ebinene ekkumi n’ebibiri ebyali bijjudde ebyakaloosa buli kimu, byali bipima obuzito kilo kikumi mu kkumi na musanvu, ng’ebipimo by’awatukuvu bwe biri. Okugatta awamu ebijiiko byonna byapima obuzito bwa kilo emu ne desimoolo nnya. ");
INSERT INTO lug_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Omuwendo gwonna ogw’ebisolo ebyaweebwayo olw’ekiweebwayo ekyokebwa gwali bwe guti: ente ento ennume kkumi na bbiri, endiga ennume kkumi na bbiri, abaana b’endiga abato abalume ab’omwaka ogw’obukulu gumu baali kkumi na babiri, awamu n’ekiweebwayo eky’emmere y’empeke n’ebigenderako. Embuzi ennume kkumi na bbiri ze zaakozesebwa olw’ekiweebwayo olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Omuwendo gwonna ogw’ebisolo ebyaweebwayo olwa ssaddaaka y’ekiweebwayo olw’emirembe gwali bwe guti: ente ennume amakumi abiri mu nnya, endiga ennume nkaaga, embuzi ennume nkaaga n’abaana b’endiga abato abalume ab’omwaka ogw’obukulu ogumu ogumu nabo nkaaga. Ebyo bye byali ebiweebwayo olw’okutukuza ekyoto nga kimaze okufukibwako amafuta ag’omuzeeyituuni. ");
INSERT INTO lug_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Awo Musa bwe yayingira mu Weema ey’Okukuŋŋaanirangamu okwogera ne Mukama, n’awulira eddoboozi nga lyogera gy’ali nga liva wakati wa bakerubbi ababiri abali waggulu w’entebe ey’okusaasira eri ku Ssanduuko ey’Endagaano. Bw’atyo Mukama bwe yayogera naye. ");
INSERT INTO lug_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Yogera ne Alooni omugambe nti, ‘Bw’oba oteekateeka ettaala omusanvu, zisaana zaake nga zimulisa ebbanga eryo eriri mu maaso g’ekikondo ky’ettaala.’ ” ");
INSERT INTO lug_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Alooni n’akola bw’atyo; n’akoleeza ettaala ne zaaka nga zimulisa ebbanga eryali mu maaso g’ekikondo ky’ettaala, nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ekikondo ky’ettaala kyakolebwa mu ngeri eno: kyaweesebwa mu zaabu okuva ku ntobo yaakyo okutuuka ku bimuli byakyo. Ekikondo ky’ettaala kyakolebwa ng’ekifaananyi ekyokulabirako Mukama Katonda kye yalaga Musa bwe kyali. ");
INSERT INTO lug_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Ggyamu Abaleevi mu baana ba Isirayiri, obafuule balongoofu. ");
INSERT INTO lug_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Okubafuula abalongoofu ojja kukola bw’oti: bamansireko amazzi ag’obulongoofu, obalagire bamwe omubiri gwabwe gwonna, era booze n’engoye zaabwe, bwe batyo bafuuke abalongoofu. ");
INSERT INTO lug_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Balagire baweeyo ente ya sseddume ento n’ekiweebwayo ekigenderako eky’obuwunga obulungi obutabuddwamu amafuta ag’omuzeeyituuni; n’oluvannyuma naawe oddire ente ya sseddume ento ogiweeyo olw’ekiweebwayo olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Abaleevi obaleete mu maaso ga Weema ya Mukama ey’Okukuŋŋaanirangamu, era okuŋŋaanyize awo ekibiina ky’abaana ba Isirayiri bonna. ");
INSERT INTO lug_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Onooleeta Abaleevi mu maaso ga Mukama, era abaana ba Isirayiri bajja kussa emikono gyabwe ku Baleevi abo. ");
INSERT INTO lug_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Alooni ajja kuwaayo Abaleevi eri Mukama Katonda ng’ekiweebwayo ekiwuubibwa ekivudde mu baana ba Isirayiri, bwe batyo babe nga beetegese okukola omulimu gwa Mukama. ");
INSERT INTO lug_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Abaleevi banassa emikono gyabwe ku mitwe gy’ente zisseddume zombi; emu onoogiwaayo ng’ekiweebwayo olw’ekibi, n’endala ng’ekiweebwayo ekyokebwa eri Mukama Katonda, okutangiririra Abaleevi. ");
INSERT INTO lug_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ojja kuyimiriza Abaleevi mu maaso ga Alooni ne batabani be, olyoke obaweeyo eri Mukama Katonda ng’ekiweebwayo ekiwuubibwa. ");
INSERT INTO lug_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","“Bw’otyo bw’onooyawula Abaleevi okuva mu baana ba Isirayiri, era Abaleevi banaabanga bange. ");
INSERT INTO lug_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Ebyo nga biwedde Abaleevi banaayingiranga mu Weema ey’Okukuŋŋaanirangamu ne baweereza, ng’omaze okubafuula abalongoofu era ng’obawaddeyo ng’ekiweebwayo ekiwuubibwa. ");
INSERT INTO lug_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Kubanga bampeereddwa ddala nga bava mu baana ba Isirayiri. Mbeetwalidde nga be bange ddala mu kifo ky’ababereberye, eky’abaana aboobulenzi ababereberye abazaalibwa buli mukazi Omuyisirayiri. ");
INSERT INTO lug_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Buli ekizaalibwa kyonna mu Isirayiri ekisajja nga kibereberye, oba muntu oba nsolo, kyange. Bwe nazikiriza ebibereberye byonna eby’omu nsi y’e Misiri, ebya Isirayiri nabyeyawulirako ne biba byange. ");
INSERT INTO lug_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Kaakano ntutte Abaleevi mu kifo ky’ababereberye mu baana ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Nzigye Abaleevi mu baana ba Isirayiri ne mbagabira Alooni ne batabani be ng’ekirabo, bakolererenga abaana ba Isirayiri nga baweereza mu Weema ey’Okukuŋŋaanirangamu nga batangiririra abaana ba Isirayiri balemenga kulumbibwa kawumpuli nga babadde basemberedde awatukuvu.” ");
INSERT INTO lug_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Bwe batyo Musa ne Alooni n’ekibiina kyonna eky’abaana ba Isirayiri ne bakola ku Baleevi ebyo byonna nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Abaleevi ne bayoza engoye zaabwe, ne Alooni n’abawaayo ng’ekiweebwayo ekiwuubibwa eri Mukama Katonda, n’abatangiririra okubafuula abalongoofu. ");
INSERT INTO lug_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ebyo bwe byaggwa Abaleevi ne bajja okukola omulimu gwabwe nga baweereza mu Weema ey’Okukuŋŋaanirangamu, nga balabirirwa Alooni ne batabani be. Baakola byonna ku Baleevi nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Bino bye bikwata ku Baleevi: Abasajja ab’emyaka amakumi abiri mu etaano egy’obukulu n’okusingawo, banajjanga ne batandika emirimu gyabwe mu Weema ey’Okukuŋŋaanirangamu; ");
INSERT INTO lug_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","naye bwe banaawezanga emyaka egy’obukulu amakumi ataano banaawummuliranga ddala ne bava ku mirimu emitongole egya bulijjo ne bateeyongera kuweereza. ");
INSERT INTO lug_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Naye banaayinzanga okudduukirirako ku booluganda abanaabanga bakola emirimu egyo mu Weema ey’Okukuŋŋaanirangamu, naye bo ku lwabwe tebaakolenga mirimu egyo mu butongole. Bw’otyo bw’onootegekanga emirimu gy’Abaleevi.” ");
INSERT INTO lug_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Awo Mukama n’ayogera ne Musa mu Ddungu lya Sinaayi mu mwezi ogw’olubereberye ogw’omwaka ogwokubiri kasookedde bava mu nsi y’e Misiri. N’amugamba nti, ");
INSERT INTO lug_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Lagira abaana ba Isirayiri bakwatenga Embaga ey’Okuyitako mu ntuuko zaayo nga bwe kyalagirwa. ");
INSERT INTO lug_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Mugikwatanga mu ntuuko zaayo ezaalagirwa ku lunaku olw’ekkumi n’ennya olw’omwezi guno nga buwungeera, ng’amateeka n’ebiragiro byako bwe bigamba.” ");
INSERT INTO lug_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Bw’atyo Musa n’agamba abaana ba Isirayiri okukwata Embaga ey’Okuyitako; ");
INSERT INTO lug_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","era ne bakola bwe batyo mu Ddungu lya Sinaayi ku lunaku olw’ekkumi n’ennya olw’omwezi ogw’olubereberye nga buwungeera. Abaana ba Isirayiri baakola ebyo byonna nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Naye waaliwo abantu abamu abataasobola kukwata Mbaga ey’Okuyitako ku lunaku olwo, kubanga tebaali balongoofu olwokubanga baali bakutte ku mufu. Bwe batyo ne bajja eri Musa ne Alooni ku lunaku olwo lwennyini, ");
INSERT INTO lug_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ne bagamba Musa nti, “Tetuli balongoofu kubanga twakutte ku mufu; lwaki tugaanibwa okuleetera Mukama ekiweebwayo kye, awamu n’abaana ba Isirayiri, mu ntuuko zaakyo ezaalagirwa?” ");
INSERT INTO lug_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa n’abaddamu nti, “Mulinde mmale okumanya Mukama Katonda ky’anandagira ku nsonga yammwe.” ");
INSERT INTO lug_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Yogera eri abaana ba Isirayiri obagambe nti, ‘Omu ku mmwe, oba omu ku bazzukulu bammwe ab’omu mirembe egiriddawo, singa afuuka atali mulongoofu olw’okukwata ku mufu, oba nga taliiwo yagenda olugendo olw’ewala, anaakwatanga Embaga ey’Okuyitako eya Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Banaakwatanga embaga eyo ku lunaku olw’ekkumi n’ennya mu mwezi ogwokubiri akawungeezi. Omwana gw’endiga banaagulyanga n’omugaati ogutali muzimbulukuse n’enva ez’ebikoola ebikaawa. ");
INSERT INTO lug_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Tebagulekangawo okutuusa enkeera, wadde okumenya ku magumba gaagwo. Bwe banaakwatanga Embaga ey’Okuyitako kinaabasaaniranga okukola ng’amateeka g’embaga eyo bwe galagira. ");
INSERT INTO lug_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Naye omuntu omulongoofu ate nga teyagenda lugendo, kyokka n’atakwata Mbaga ey’Okuyitako, anaawaŋŋangusibwanga n’ava mu banne, kubanga teyaleeta kiweebwayo kya Mukama Katonda mu ntuuko zaakyo. Ekibi ky’omuntu oyo kinaabeeranga ku mutwe gwe. ");
INSERT INTO lug_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Omunnaggwanga anaabeeranga mu mmwe bw’anaabanga ayagala okukwata Embaga ey’Okuyitako kwa Mukama Katonda anaagikwatanga ng’agoberera amateeka n’ebiragiro byayo. Munaabanga n’ebiragiro byebimu ebinaagobererwanga bannaggwanga era ne bannansi.’ ” ");
INSERT INTO lug_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ku lunaku Weema ya Mukama ey’Endagaano lwe yasimbibwa, ekire ne kigibikka. Okuva akawungeezi okutuusa ku makya ekire ekyali waggulu wa Weema ne kifaanana ng’omuliro. ");
INSERT INTO lug_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Bwe kityo bwe kyabeeranga; ekire kyagibikkanga emisana naye ekiro ne kifaanana ng’omuliro. ");
INSERT INTO lug_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Era ekire buli lwe kyaggyibwanga ku Weema, olwo abaana ba Isirayiri ne basitula mu lugendo lwabwe; era awo ekire ekyo we kyayimiriranga, nga n’abaana ba Isirayiri we basiisira. ");
INSERT INTO lug_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Mukama bwe yalagiranga abaana ba Isirayiri okusitula mu lugendo lwabwe, nga basitula; Mukama bwe yabalagiranga okukuba olusiisira nga bakola bwe batyo. Ebbanga lyonna ekire lye kyamalanga waggulu wa Weema nga nabo lye bamala mu lusiisira lwabwe. ");
INSERT INTO lug_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ekire ne bwe kyamalanga ennaku ennyingi waggulu wa Weema, abaana ba Isirayiri baagonderanga ekiragiro kya Mukama Katonda ne batasitula kutambula. ");
INSERT INTO lug_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Oluusi ekire kyamalanga ennaku ntono waggulu wa Weema; naye ng’ekiragiro kya Mukama Katonda bwe kyali, nga basigala mu lusiisira lwabwe; kyokka oluvannyuma nga basitula okutambula ng’ekiragiro kya Mukama Katonda bwe kyabanga. ");
INSERT INTO lug_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Oluusi ekire kyabeerangawo okuva akawungeezi okutuusa mu makya; naye ekire bwe kyaggyibwangawo mu makya, ng’olwo basitula okutambula; oba bwe kyasigalangawo olunaku n’ekiro kyonna oluvannyuma ne kiggyibwawo, ng’olwo basitula okutambula. ");
INSERT INTO lug_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ekire ne bwe kyabeeranga waggulu wa Weema okumala ennaku ebbiri oba omwezi, abaana ba Isirayiri nga babeera awo mu lusiisira lwabwe nga tebasitula kutambula; naye bwe kyaggyibwangawo ng’olwo basitula okutambula. ");
INSERT INTO lug_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Mukama bwe yabalagiranga okusigala, nga basigala mu lusiisira lwabwe nga bawummudde, ate Mukama bwe yabalagiranga okutambula, nga basitula okutambula. Baagonderanga ekiragiro kya Mukama nga bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Weesa mu ffeeza amakondeere abiri ogakozesenga okuyitanga abantu bonna okukuŋŋaana, era n’okubalagira okuggyawo ensiisira zaabwe. ");
INSERT INTO lug_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Amakondeere gombi bwe ganaafuuyibwanga, ekibiina ky’abantu bonna banaakuŋŋaaniranga w’oli ku mulyango gwa Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Naye bwe banaafuuwangako erimu, olwo abakulembeze, be bakulu b’ebika bya Isirayiri, be banaakuŋŋaaniranga w’oli. ");
INSERT INTO lug_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Amakondeere ag’omwanguka bwe ganaafuuyibwanga, ebika ebinaabanga bisiisidde ku luuyi olw’ebuvanjuba binaasitulanga okutambula. ");
INSERT INTO lug_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ate bwe banaafuuwanga ag’omwanguka omulundi ogwokubiri, ensiisira ezinaabanga mu bukiikaddyo, zinaasitulanga okutambula. Amakondeere ag’omwanguka ke kanaabanga akabonero akanaabategeezanga nti basitule batambule. ");
INSERT INTO lug_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Naye bwe kineetaagisanga okukuba olukuŋŋaana, onoofuuwanga amakondeere naye tegaabenga ga mwanguka. ");
INSERT INTO lug_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Abaana ba Alooni, bakabona, be banaafuuwanga amakondeere. Lino linaabanga tteeka ery’enkalakkalira mu mmwe ne mu mirembe egigenda okujja. ");
INSERT INTO lug_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Bwe munaagendanga okutabaala omulabe abajoogerereza mu nsi yammwe, mufuuwanga amakondeere ag’omwanguka. Bwe mutyo munajjukirwanga Mukama Katonda, era anaabawonyanga abalabe bammwe. ");
INSERT INTO lug_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Mu biseera eby’essanyu, ne ku mbaga zammwe entongole ne ku mbaga z’omwezi ogwakaboneka, munaafuuwanga amakondeere nga bwe muwaayo ebiweebwayo byammwe ebyokebwa n’ebiweebwayo byammwe olw’emirembe, era binaabanga bijjukizo byammwe awali Katonda wammwe. Nze Mukama Katonda wammwe.” ");
INSERT INTO lug_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Awo olwatuuka ku lunaku olw’amakumi abiri mu mwezi ogwokubiri mu mwaka ogwokubiri, ekire ne kisitulibwa okuva waggulu wa Weema ey’Endagaano. ");
INSERT INTO lug_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Abaana ba Isirayiri ne basitula ne batambula okuva mu Ddungu lya Sinaayi, oluvannyuma ekire ne kiyimirira mu Ddungu lya Palani. ");
INSERT INTO lug_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ogwo gwe gwali omulundi omubereberye okusitula okutambula nga bagendera ku kiragiro kya Mukama Katonda kye yayisa mu Musa. ");
INSERT INTO lug_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Olusiisira lw’abaana ba Yuda lwe lwasooka okusitula okutambula, nga bakulemberwa ebendera yaabwe; Nakusoni mutabani wa Amminadaabu nga ye muduumizi waabwe. ");
INSERT INTO lug_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nesaneri mutabani wa Zuwaali ye yaduumira ekibinja ky’ekika kya Isakaali, ");
INSERT INTO lug_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ne Eriyaabu mutabani wa Keroni n’aduumira ekibinja ky’ekika kya Zebbulooni. ");
INSERT INTO lug_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Eweema ya Mukama n’esimbulwa, batabani ba Gerusoni ne batabani ba Merali abaagyetikkanga ne basitula ne batambula. ");
INSERT INTO lug_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ebibinja by’omu lusiisira lwa Lewubeeni bye byaddako okusitula okutambula awamu n’ebendera yaabyo, nga biduumirwa Erizuuli mutabani wa Sedewuli. ");
INSERT INTO lug_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Serumiyeeri mutabani wa Zulisadaayi ye yaduumira ekibinja ky’ekika kya Simyoni, ");
INSERT INTO lug_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ne Eriyasaafu mutabani wa Deweri n’aduumira ekibinja ky’ekika kya Gaadi. ");
INSERT INTO lug_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Abakokasi ne basitula okutambula nga beetisse ebintu ebitukuvu. Eweema ya Mukama ng’emala kusimbibwa, nabo ne balyoka batuuka. ");
INSERT INTO lug_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ebibinja by’omu lusiisira lwa Efulayimu bye byaddirira okusitula okutambula awamu n’ebendera yaabyo; Erisaama mutabani wa Ammikudi nga ye muduumizi waabyo. ");
INSERT INTO lug_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalyeri mutabani wa Pidazuuli ye yaduumira ekibinja ky’ekika kya Manase; ");
INSERT INTO lug_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ne Abidaani mutabani wa Gidyoni n’aduumira ekibinja ky’ekika kya Benyamini. ");
INSERT INTO lug_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ku nkomerero ya byonna, ebibinja by’omu lusiisira lwa Ddaani, nga bye bikuuma emabega, ne bisitula okutambula n’ebendera yaabyo nga bikoobedde ensiisira zonna; Akiyezeeri mutabani wa Amisadaayi nga ye muduumizi waabyo. ");
INSERT INTO lug_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagiyeeri mutabani wa Okulaani ye yaduumira ekibinja ky’ekika kya Aseri; ");
INSERT INTO lug_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ne Akira mutabani wa Enani n’aduumira ekibinja ky’ekika kya Nafutaali. ");
INSERT INTO lug_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Eyo ye yali entegeka ey’abaana ba Isirayiri ng’ebibinja byabwe bwe byali nga basitula okutambula. ");
INSERT INTO lug_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Awo Musa n’agamba mukoddomi we Kobabu mutabani wa Leweri Omumidiyaani nti, “Tusitula okutambula okugenda mu kifo Mukama kye yatugamba nti, ‘Ndikibawa.’ Kale nno, jjangu tugende ffenna tulikuyisa bulungi, kubanga Mukama yasuubiza Isirayiri ebintu ebirungi.” ");
INSERT INTO lug_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Naye n’addamu nti, “Nedda, sijja kugenda nammwe, nzirayo mu nsi ye waffe era mu bantu bange.” ");
INSERT INTO lug_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Naye Musa n’amugamba nti, “Nkwegayiridde totuleka. Ggwe omanyi obulungi eddungu gye tusaanye okukuba olusiisira lwaffe, ggwe ojja okubeera amaaso gaffe. ");
INSERT INTO lug_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Singa ojja ne tugenda ffenna, tunaagabaniranga wamu buli kirungi kyonna Mukama ky’anaatuwanga.” ");
INSERT INTO lug_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Awo ne basitula okuva ku lusozi lwa Mukama Katonda ne batambulira ennaku ssatu. Essanduuko ya Mukama ey’Endagaano n’ebakulemberanga okumala ennaku ezo essatu ng’ebanoonyeza ekifo eky’okuwummuliramu. ");
INSERT INTO lug_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Buli lwe baasitulanga okutambula nga bava mu lusiisira, ekire kya Mukama Katonda kyabeeranga waggulu waabwe buli budde bwa misana. ");
INSERT INTO lug_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Buli abeetissi b’Essanduuko ya Mukama Katonda lwe baasitulanga okutambula, Musa n’agamba nti, “Golokoka, Ayi Mukama! Abalabe bo basaasaane; amaggye agakulwanyisa gakudduke.” ");
INSERT INTO lug_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Buli Ssanduuko ya Mukama Katonda lwe yawummuzibwanga, Musa n’agamba nti, “Komawo, Ayi Mukama, eri enkumi n’enkumi eza Isirayiri.” ");
INSERT INTO lug_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Awo abantu ne beemulugunya olw’ebizibu byabwe nga ne Mukama awulira; bwe yabawulira obusungu bwe ne bubuubuuka. Omuliro ne guva eri Mukama ne gwakira mu bo, ne gwokya ebitundu ebimu ebyali bikomererayo eby’olusiisira lwabwe. ");
INSERT INTO lug_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Abantu ne bakaabirira Musa; Musa n’asaba Mukama, omuliro ne guzikira. ");
INSERT INTO lug_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ekifo ekyo ne kituumibwa erinnya Tabera, kubanga omuliro ogwava eri Mukama gwabaakiramu. ");
INSERT INTO lug_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Abagwira abaali beetabudde mu baana ba Isirayiri ne baluluunkanira ebyokulya; n’abaana ba Isirayiri nabo ne bongera okukaaba nga bwe bagamba nti, “Singa nno tufuna ku nnyama ne tulyako! ");
INSERT INTO lug_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Tukyajjukira ebyennyanja bye twalyanga mu Misiri nga tewali na kye tubisasulidde, ne wujju n’ensujju, n’enderema n’obutungulu ne katungulukyumu n’ebyokuliira. ");
INSERT INTO lug_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Naye kaakano n’okwoya emmere kutuweddemu, buli we tukuba eriiso tulaba mmaanu eno!” ");
INSERT INTO lug_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Emmaanu yafaanananga ng’ensigo za koliyanda, nga n’ekifaananyi kyayo kiri ng’ekya bideriamu. ");
INSERT INTO lug_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Abantu baagendanga ne bagikuŋŋaanya ne bagiseera ku lubengo oba ne bagisekulira mu binu, ne bagifumba mu ntamu oba ne bakolamu bukeeke. Nga mu kamwa ebanga ekoleddwa n’amafuta ga zeyituuni. ");
INSERT INTO lug_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Omusulo bwe gwagwanga mu lusiisira ekiro n’emmaanu nayo n’egwa nagwo. ");
INSERT INTO lug_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa n’awulira abantu aba buli luggya nga bakaaba, buli omu ng’akaabira mu muzigo gw’eweema ye; obusungu bwa Mukama Katonda ne bubuubuuka nnyo, ne Musa n’asoberwa n’anyiikaala. ");
INSERT INTO lug_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Musa n’agamba Mukama Katonda nti, “Lwaki oleetedde omuddu wo obuzibu buno? Nkoze ki ekitakusanyusizza ne kikuleetera okwetikka omugugu gw’abantu bano bonna? ");
INSERT INTO lug_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Nze nali olubuto omwali abantu bano bonna? Nze nabazaala? Lwaki oŋŋamba okubasitula mu mikono gyange ng’omulezi w’abaana bw’asitula omwana omuwere mbatwale mu nsi gye wabasuubiza ng’ogirayirira bajjajjaabwe? ");
INSERT INTO lug_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ennyama abantu bano bonna gye banaalya nnaagiggya wa? Kubanga baneetayirira nga bankaabirira nti, ‘Tuwe ennyama tulye!’ ");
INSERT INTO lug_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Sisobola kusitula bantu bano bonna bw’omu kubanga obuzito bwabwe buyinza okummenya nga ndi nzekka. ");
INSERT INTO lug_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Obanga bw’otyo bw’ojja okumpisa, ate nga bulijjo ondaga ekisa kyo, kale nno nzitiraawo kaakano oleme kundeka ne neereetera okwezikiriza.” ");
INSERT INTO lug_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Mukama n’agamba Musa nti, “Nfunira abasajja nsanvu mu bakulu ba Isirayiri b’omanyi nga be bakulu b’abantu era nga be bakulembeze baabwe obaleete ku Weema ey’Okukuŋŋaanirangamu, bayimirire awo naawe. ");
INSERT INTO lug_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nzija kukka awo njogere naawe; era nzija kutoola ku mwoyo oguli mu ggwe ngubateekemu, balyokenga bakusitulireko omugugu gw’abantu oleme kugwetikkanga wekka. ");
INSERT INTO lug_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Abantu bagambe nti, ‘Mwetukuze nga mwetegekera olunaku lw’enkya, lwe mujja okulya ennyama. Kubanga Mukama Katonda yabawulira nga mumukaabirira bwe muti nti, “Singa tufunye ku nnyama ne tulyako! Bwe twali mu Misiri twali bulungi!” Noolwekyo Mukama ajja kubawa ennyama mugirye. ");
INSERT INTO lug_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Temugenda kugirya mu lunaku lumu, oba mu nnaku bbiri, oba mu nnaku ttaano, oba mu nnaku kkumi, oba nnaku abiri; ");
INSERT INTO lug_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","naye kumala mwezi mulambirira, okutuusa lw’erifulumira mu nnyindo zammwe n’ebanyiwa, kubanga mwesamudde Mukama Katonda abeera mu mmwe, ne mumukaabirira nga mugamba nti, “Mu Misiri twaviirayo ki?” ’ ” ");
INSERT INTO lug_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Musa n’agamba nti, “Abantu bano mwe ndi bawera omuwendo gwa mitwalo nkaaga abatambuza ebigere, naawe ogamba nti, ‘Nzija kubawa ennyama gye banaalya okumala omwezi mulamba!’ ");
INSERT INTO lug_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ebisolo ebiri mu biraalo ne mu bisibo bwe binattibwa binaabamala? Nantiki ebyennyanja byonna eby’omu nnyanja bwe binaavubibwa ne bibaweebwa, binaabamala?” ");
INSERT INTO lug_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Mukama n’agamba Musa nti, “Omukono gwa Mukama Katonda guyimpawadde? Kaakano ojja kulaba obanga ekigambo kyange kye nkugambye kinaatuukirira oba tekiituukirire.” ");
INSERT INTO lug_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Awo Musa n’afuluma n’ategeeza abantu ebigambo bya Mukama Katonda; n’akuŋŋaanya abasajja nsanvu mu bakulembeze b’abantu n’abayimiriza okumpi ne Weema ya Mukama. ");
INSERT INTO lug_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Awo Mukama Katonda n’akkira mu kire n’ayogera ne Musa, n’addira ku mwoyo ogwali mu Musa n’agussa mu bakulembeze ensanvu. Omwoyo bwe baagufuna ne batandika okutegeeza obunnabbi, kyokka tebaddayo nate kukikola. ");
INSERT INTO lug_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Waaliwo abasajja babiri nga bayitibwa Eridaadi ne Medadi, baali babaliddwa ku bakulembeze ensanvu, naye bo ne basigala mu lusiisira, ne batagenda ku Weema ya Mukama; nabo baafuna omwoyo, era ne bategeeza obunnabbi mu lusiisira. ");
INSERT INTO lug_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Omuvubuka n’adduka n’agenda ategeeza Musa nti, “Eridaadi ne Medadi bategeeza obunnabbi mu lusiisira.” ");
INSERT INTO lug_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Awo Yoswa mutabani wa Nuuni, omuweereza wa Musa gwe yali yeerondedde ng’akyali muvubuka n’agamba nti, “Mukama wange Musa, baziyize.” ");
INSERT INTO lug_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Naye Musa n’amugamba nti, “Okwatiddwa obuggya ku lwange? Kyandibadde kirungi singa abantu ba Mukama bonna bannabbi, ne Mukama Katonda n’abawa omwoyo gwe!” ");
INSERT INTO lug_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Musa n’abakulembeze ba Isirayiri ne baddayo mu lusiisira. ");
INSERT INTO lug_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Awo empewo n’eva eri Mukama Katonda n’ereeta obugubi nga buva mu nnyanja ne bugwa okwebungulula olusiisira nga bukoze entuumo nga ya mita emu okuva ku ttaka, nga bujjuza ebbanga lya lugendo lwa lunaku lumu ku ludda olumu olw’olusiisira n’olugendo lwa lunaku lumu ku ludda olulala. ");
INSERT INTO lug_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ku lunaku olwo ne ku lunaku olwaddirira abantu ne bakuŋŋaanya obugubi emisana n’ekiro. Tewali yakuŋŋaanya buzito bwakka wansi wa kilo lukumi; ne babwanika buli wantu mu lusiisira. ");
INSERT INTO lug_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Naye ennyama yali ekyali mu mannyo gaabwe nga tebannaba kugirya, obusungu bwa Mukama Katonda ne bubuubuukira abantu n’abaleetera kawumpuli ow’amaanyi ennyo. ");
INSERT INTO lug_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Noolwekyo ekifo ekyo kyekyava kituumibwa Kiberosu Katava, kubanga awo we baaziika abantu abaalina omulugube. ");
INSERT INTO lug_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Abantu bwe baava e Kiberosu Katava ne batambula okutuuka e Kazerosi ne babeera awo. ");
INSERT INTO lug_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Awo Miryamu ne Alooni ne boogera nga bawakanya Musa olw’omukazi Omukuusi gwe yali awasizza, kubanga yali awasizza Mukuusi. ");
INSERT INTO lug_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ne bagamba nti, “Naye ddala Mukama bwe yayogeranga yayitanga mu Musa yekka? Mu ffe namwo teyayogereramu?” Mukama Katonda n’abiwulira. ");
INSERT INTO lug_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Naye nno, Musa yali musajja muwombeefu nnyo, nga muteefu okusinga abantu bonna abaali ku nsi. ");
INSERT INTO lug_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Amangwago Mukama n’ayogera ne Musa, ne Alooni ne Miryamu n’abagamba nti, “Mujje, mwensatule, mu Weema ey’Okukuŋŋaanirangamu.” Bonsatule ne bagenda. ");
INSERT INTO lug_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Mukama Katonda n’akkira mu mpagi ey’ekire, n’ayimirira ku mulyango gwa Weema n’ayita Alooni ne Miryamu. Bombi bwe baasembera ");
INSERT INTO lug_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","n’abagamba nti, “Muwulirize ebigambo byange: “Mu mmwe bwe mubaamu nnabbi wa Mukama Katonda, nneeraga gy’ali mu kulabikirwa, oba njogera naye mu birooto. ");
INSERT INTO lug_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Naye ekyo si bwe kiri ku muddu wange Musa; mu nju yange yonna, muntu mwesigwa. ");
INSERT INTO lug_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Bwe mba njogera naye tutunulagana maaso na maaso, njogera butereevu so si mu ngero; alaba ekifaananyi kya Mukama Katonda. Kale, lwaki temwatidde okuwakanya omuddu wange Musa?” ");
INSERT INTO lug_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Obusungu bwa Mukama Katonda ne bubabuubuukira, n’abaviira. ");
INSERT INTO lug_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ekire bwe kyasituka okuva ku Weema, era laba, Miryamu n’agengewala, n’atukula ng’omuzira. Alooni n’amukyukira n’alaba ng’agengewadde; ");
INSERT INTO lug_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","n’agamba Musa nti, “Nkwegayirira, mukama wange, oleme kututeekako kibi kino kye tukoze mu busirusiru bwaffe. ");
INSERT INTO lug_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Tomuleka omubiri gwe okufaanana ng’ogw’omwana omuwere azaalibwa ng’ali ng’afudde, ng’omubiri gwe guweddemu ensa.” ");
INSERT INTO lug_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musa n’akaabirira Mukama ng’agamba nti, “Ayi Katonda, nkwegayirira omuwonye.” ");
INSERT INTO lug_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Mukama Katonda n’addamu Musa nti, “Singa kitaawe amuwandidde amalusu mu maaso, teyandibadde muswavu okumala ennaku musanvu? Kale mumusibire ebweru w’olusiisira okumala ennaku musanvu; bwe zinaggwaako ayinza okukomezebwawo.” ");
INSERT INTO lug_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Bw’atyo Miryamu n’asibirwa ebweru w’olusiisira okumala ennaku musanvu; abantu ne batasitula kutambula okutuusa Miryamu lwe yakomezebwawo. ");
INSERT INTO lug_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ebyo bwe byaggwa abantu ne basitula okuva e Kazerosi ne batambula okutuusa lwe baasiisira mu ddungu lya Palani. ");
INSERT INTO lug_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Tuma abasajja bagende bakette beetegereze ensi ya Kanani gye ŋŋenda okuwa abaana ba Isirayiri. Mu buli kika kya bajjajja ojja kulondamu omusajja omu ku bakulembeze baakyo.” ");
INSERT INTO lug_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Bw’atyo Musa n’abatuma okuva mu ddungu lya Palani, ng’ekiragiro kya Mukama Katonda bwe kyali. Bonna baali bakulembeze b’abaana ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Amannya gaabwe ge gano: Eyava mu kika kya Lewubeeni yali Sammuwa mutabani wa Zakula. ");
INSERT INTO lug_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Eyava mu kika kya Simyoni yali Safati mutabani wa Kooli. ");
INSERT INTO lug_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Eyava mu kika kya Yuda yali Kalebu mutabani wa Yefune. ");
INSERT INTO lug_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Eyava mu kika kya Isakaali yali Igali mutabani wa Yusufu. ");
INSERT INTO lug_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Eyava mu kika kya Efulayimu yali Koseya mutabani wa Nuuni. ");
INSERT INTO lug_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Eyava mu kika kya Benyamini yali Paluti mutabani wa Lafu. ");
INSERT INTO lug_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Eyava mu kika kya Zebbulooni yali Gadyeri mutabani wa Sodi. ");
INSERT INTO lug_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Eyava mu kika kya Manase, ky’ekika kya Yusufu, yali Gaadi mutabani wa Susi. ");
INSERT INTO lug_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Eyava mu kika kya Ddaani yali Ammiyeri mutabani wa Gemali. ");
INSERT INTO lug_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Eyava mu kika kya Aseri yali Sesula mutabani wa Mikaeri. ");
INSERT INTO lug_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Eyava mu kika kya Nafutaali yali Nakabi mutabani wa Vofesi. ");
INSERT INTO lug_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Eyava mu kika kya Gaadi yali Geweri mutabani wa Maki. ");
INSERT INTO lug_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ago ge mannya ag’abasajja Musa be yatuma okugenda okuketta n’okwetegereza ensi eyo. Musa yali atuumye Koseya mutabani wa Nuuni erinnya Yoswa. ");
INSERT INTO lug_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa n’abatuma okuketta n’okwetegereza ensi ya Kanani, n’abagamba nti, “Mwambuke nga muyita mu Negebu muggukire mu nsi ey’ensozi. ");
INSERT INTO lug_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mwetegerezenga ensi nga bw’efaanana, n’abantu baamu nga bwe bali, obanga ba maanyi oba banafu, obanga bangi oba batono. ");
INSERT INTO lug_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Mulyetegereza obanga ensi mwe babeera nnungi oba mbi. Era muliraba ebibuga byabwe obanga tebiriiko bisenge bya bbugwe oba byetooloddwa bigo. ");
INSERT INTO lug_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Mulikebera okulaba obanga ensi yaabwe ngimu oba nkalu, era obanga erimu emiti mingi oba temuli. Mwenywezanga ne muleetayo ku bibala eby’omu nsi eyo.” Ekyo kye kyali ekiseera ezabbibu nga zaakatandika okwengera. ");
INSERT INTO lug_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Awo ne bambuka ne beetegereza ensi okuva mu ddungu lya Zini okutuuka e Lekobu okumpi n’awayingirirwa mu Kamasi. ");
INSERT INTO lug_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ne bambuka mu Negebu ne batuuka e Kebbulooni, era wano Akimaani ne Sesayi ne Talumaayi abazzukulu ba Anaki nga we babeera. Kebbulooni bwe kyamala okuzimbibwa waayitawo emyaka musanvu ne Zowani eky’omu Misiri nakyo ne kiryoka kizimbibwa. ");
INSERT INTO lug_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ne batuuka mu kiwonvu ekiyitibwa Esukoli ne batemamu ettabi limu eryaliko ekirimba kimu ekya zabbibu, abantu babiri ne bakireetera ku musituliro. Era ne baleeta ne ku makomamawanga ne ku ttiini. ");
INSERT INTO lug_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ekifo ekyo ne kiyitibwa Ekiwonvu kya Esukoli, olw’ekirimba ekyo abaana ba Isirayiri kye baatemamu. ");
INSERT INTO lug_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Awo nga wayiseewo ennaku amakumi ana ne bakomawo nga bamaze okuketta ensi. ");
INSERT INTO lug_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ne bajja eri Musa ne Alooni e Kadesi mu ddungu lya Palani. Ne babakomezaawo obubaka n’eri ekibiina kyonna, era ne babanjulira ebibala bye baggya mu nsi eyo. ");
INSERT INTO lug_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ne bategeeza Musa nti, “Twatuuka mu nsi gye watutumamu: ekulukuta amata n’omubisi gw’enjuki, ejjudde ebirungi ebyereere, era bino bye bibala byamu. ");
INSERT INTO lug_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Naye nno abantu ababeera mu nsi omwo ba maanyi, n’ebibuga byabwe binene nnyo era byetooloddwako ebigo. Ate n’ekirala twalabaayo n’abazzukulu ba Anaki. ");
INSERT INTO lug_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Abamaleki babeera mu Negebu mu bukiikaddyo; Abakiiti n’Abayebusi, n’Abamoli babeera mu nsi ey’ensozi; n’Abakanani ne babeera okumpi n’ennyanja ne ku lubalama lw’omugga Yoludaani.” ");
INSERT INTO lug_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Awo Kalebu n’asirisa abantu awali Musa n’agamba nti, “Twambukirewo kaakano tutwale ensi eyo, kubanga ndaba nga tusobola okugiwangula.” ");
INSERT INTO lug_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Kyokka abaagenda ne Kalebu okuketta ne baddamu nti, “Abantu bali tetubasobola, batusinga amaanyi.” ");
INSERT INTO lug_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Bwe batyo ne babunya mu baana ba Isirayiri alipoota etaali nnungi ng’efa ku nsi gye baali bagenze okuketta; nga bagamba nti, “Ensi gye twayitaayitamu nga tugiketta tesobola na kuliisa bantu baayo abagituulamu; ate n’abantu bonna be twalabamu baali ba kiwago. ");
INSERT INTO lug_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Twalabayo n’Abanefisi, abazzukulu ba Anaki abava mu Banefiri. Bwe twetunulako nga tuli ng’obwacaaka, era nabo nga bwe batulaba bwe batyo.” ");
INSERT INTO lug_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ekiro ekyo abantu bonna mu kibiina ne bayimusa amaloboozi gaabwe ne bakaaba n’eddoboozi ery’omwanguka. ");
INSERT INTO lug_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Abaana ba Isirayiri bonna ne beemulugunyiza Musa ne Alooni; abantu bonna awamu mu kibiina ne babagamba nti, “Singa twafiira mu nsi y’e Misiri! Oba singa twafiira mu ddungu muno! ");
INSERT INTO lug_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Lwaki Mukama atutwala mu nsi eyo, tutuuke eyo tulyoke tuttibwe n’ekitala? Abakazi baffe n’abaana baffe bagenda kunyagibwa. Okuddayo mu Misiri si kye kinaasingako?” ");
INSERT INTO lug_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ne boogeraganya nti, “Ka twerondere omukulembeze tuddeyo mu Misiri.” ");
INSERT INTO lug_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Awo Musa ne Alooni ne bavuunama wansi mu maaso g’ekibiina kyonna eky’abaana ba Isirayiri abaali bakuŋŋaanidde awo. ");
INSERT INTO lug_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yoswa mutabani wa Nuuni ne Kalebu mutabani wa Yefune, abaali mu abo abaagenda okuketta ensi, ne bayuzaayuza engoye zaabwe, ");
INSERT INTO lug_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ne bagamba ekibiina kyonna eky’abaana ba Isirayiri nti, “Ensi gye twayitaayitamu okugiketta, nsi nnungi nnyo. ");
INSERT INTO lug_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Mukama Katonda bw’aliba atusanyukidde, alitukulembera n’atutuusa mu nsi eyo, ensi ekulukuta amata n’omubisi gw’enjuki, era agenda kugituwa. ");
INSERT INTO lug_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Kyokka temujeemera Mukama Katonda, era n’abantu b’omu nsi omwo temubatya, kubanga kuliba kumenya mu jjenje kkalu; tebakyalina abakuuma, ate nga Mukama Katonda ali wamu naffe. Temubatya.” ");
INSERT INTO lug_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Naye abantu bonna mu kibiina ne bateesa okubakuba mayinja. Awo ekitiibwa kya Mukama Katonda ne kirabikira eri abaana ba Isirayiri bonna mu Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Mukama n’agamba Musa nti, “Abantu bano balinnyooma kutuusa ddi? Balikomya ddi obutanzikiririzaamu, newaakubadde nga nakola ebyamagero mu bubonero bwe nakolera mu bo? ");
INSERT INTO lug_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nzija kubaboola mbazikirize ne kawumpuli, mbasaanyeewo; naye nzija kukuggyamu ggwe eggwanga eriribasinga abo obukulu n’amaanyi.” ");
INSERT INTO lug_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Naye Musa n’agamba Mukama Katonda nti, “Ebyo Abamisiri bagenda kubiwulira! Kubanga abantu bano wabaggya mu nsi y’Abamisiri n’obuyinza obw’amaanyi amangi. ");
INSERT INTO lug_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Bajja kubuulirako ku bantu ab’omu nsi muno. Baamala dda okukiwulira nga ggwe, Ayi Mukama, obeera wakati mu bantu bano, era nga, Ayi Mukama Katonda, mulabagana nabo amaaso n’amaaso, era ng’ekire kyo kibeera nabo buli kiseera, era ng’obakulemberera mu mpagi ey’ekire emisana ne mu mpagi ey’omuliro ekiro. ");
INSERT INTO lug_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Singa abantu bano obatta bonna omulundi gumu, amawanga agawulidde obututumufu bwo gagenda kugamba nti, ");
INSERT INTO lug_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Kubanga Mukama Katonda yali tasobola kuyingiza bantu bano mu nsi gye yabasuubiza ng’agibalayirira; kyeyava abattira mu ddungu.’ ");
INSERT INTO lug_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Ne kaakano nkwegayirira oyoleke obuyinza bwo, Ayi Mukama nga bwe buli obusukkirivu nga bwe wasuubiza nti, ");
INSERT INTO lug_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Mukama Katonda alwawo okusunguwala, era ajjudde okwagala okutaggwaawo, era asonyiwa ekibi n’obujeemu. Naye era asingiddwa omusango tamuleka nga tabonerezebbwa; abonereza abaana olw’ebibi bya bakadde baabwe okutuuka ku mulembe ogwokusatu n’ogwokuna.’ ");
INSERT INTO lug_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ng’okwagala kwe okungi okutaggwaawo bwe kuli, nsaba osonyiwe abantu bano ekibi ky’abwe, nga bw’ozze obasonyiwa kasookedde bava mu Misiri n’okutuusa leero.” ");
INSERT INTO lug_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Awo Mukama Katonda n’addamu nti, “Mbasonyiye nga bw’onsabye. ");
INSERT INTO lug_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Naye nno mu mazima ddala nga bwe ndi omulamu, era ng’ekitiibwa kya Mukama Katonda bwe kijjuza ensi yonna, ");
INSERT INTO lug_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","tewalibaawo n’omu ku bantu abaalaba ekitiibwa kyange n’obubonero obw’ebyamagero bwe nakolera e Misiri ne mu ddungu, naye ne batagondera ddoboozi lyange wabula ne bangezesa nga bankema emirundi kkumi, ");
INSERT INTO lug_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","tewalibaawo n’omu ku bo aliraba ku nsi eyo gye nalayirira bajjajjaabwe ne mbasuubiza okugibawa. Tewalibaawo n’omu ku bo abannyoomye aligirabako. ");
INSERT INTO lug_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Naye olwokubanga omuweereza wange Kalebu alina omwoyo ogw’enjawulo era ng’angoberera n’omutima gwe gwonna, ndimuleeta mu nsi gye yatumibwamu, n’ezzadde lye lirigirya. ");
INSERT INTO lug_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Kale nno olwokubanga Abamaleki n’Abakanani babeera mu biwonvu; enkya muddeeko emabega, musitule mutambule nga mwolekera eddungu nga mukutte ekkubo eriraga ku Nnyanja Emyufu.” ");
INSERT INTO lug_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Mukama Katonda n’agamba Musa ne Alooni nti, ");
INSERT INTO lug_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Ekibiina kino ekibi kirituusa ddi nga kinneemulugunyiza? Mpulidde okutolotooma kw’abaana ba Isirayiri nga banneemulugunyiza. ");
INSERT INTO lug_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Bategeeze nti, ‘Mukama agambye nti, Nga bwe ndi omulamu, bw’ayogera Mukama Katonda, ebyo bye mpulidde nga mwogera, nange bye ndibakola. ");
INSERT INTO lug_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mulifiira mu ddungu muno n’emirambo gyammwe mwe girisigala; mwenna abawezezza emyaka amakumi abiri n’okusingawo egy’obukulu nga bwe mwamala okubalibwa, abanneemulugunyiza. ");
INSERT INTO lug_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Tewaliba n’omu ku bo aliyingira mu nsi gye neelayirira nti ge galibeera amaka gammwe, okuggyako Kalebu mutabani wa Yefune ne Yoswa mutabani wa Nuuni. ");
INSERT INTO lug_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Naye abaana bammwe abato, be mwogeddeko nti balifuulibwa omunyago, ndibayingiza mu nsi eyo gye mugaanye ne beeyagalira omwo. ");
INSERT INTO lug_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Naye mmwe, emirambo gyammwe girisigala mu ddungu muno mwe girigwa. ");
INSERT INTO lug_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Mmwe olw’obutabeera beesigwa, abaana bammwe balimala emyaka amakumi ana mu ddungu nga bwe balunda ebisibo byabwe okutuusa omulambo gw’oyo alisembayo okufa lwe guliziikibwa mu ddungu muno. ");
INSERT INTO lug_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Nga bwe mwamala ennaku amakumi ana nga muketta ensi eri, bwe mutyo bwe mujja okumala emyaka amakumi ana mu ddungu, nga buli lumu ku nnaku ezo muvaamu mwaka gumu gumu; muboneebone olw’ebibi byammwe, mulyoke mutegeere obuzibu obw’okunneesimbamu. ");
INSERT INTO lug_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Nze, Mukama Katonda, nkyogedde; ddala ddala ekyo ndikikola ku kibiina kyonna eky’abantu bano aboonoonyi abeegasse awamu okunjolekera. Tebagenda kuva mu ddungu lino, bonna mwe balifiira.’ ” ");
INSERT INTO lug_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Abasajja abo Musa be yatuma okuketta ensi ne bakomawo ne beemulugunyiza ekibiina ky’abantu bonna nga babaleetedde obubaka obutaali bulungi ku nsi eri, era ne babubunyisa mu bantu, ");
INSERT INTO lug_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","abasajja abo abaaleeta obubaka obutaali bulungi ne babubunyisa mu bantu kawumpuli n’abattira awo mu maaso ga Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mu basajja bonna abaatumibwa okuketta ensi, Yoswa mutabani wa Nuuni ne Kalebu mutabani wa Yefune be bokka abaasigalawo nga balamu. ");
INSERT INTO lug_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa n’ategeeza abaana ba Isirayiri bonna ebigambo ebyo, ne bakungubaga nnyo. ");
INSERT INTO lug_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Enkeera mu makya ne bambuka mu nsi ey’ensozi. Ne boogera nti, “Twayonoona, naye nga bwe tuli wano tujja kwambuka tuyingire mu nsi Mukama Katonda gye yatusuubiza.” ");
INSERT INTO lug_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Naye Musa n’abagamba nti, “Lwaki munyooma ekiragiro kya Mukama Katonda? Ebyo bye mutegeka tebiyinza kutuukiririra. ");
INSERT INTO lug_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Temwambuka kubanga Mukama Katonda tali nammwe. Abalabe bammwe bajja kubawangula. ");
INSERT INTO lug_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Kubanga Abamaleki n’Abakanani bajja kuboolekera. Olwokubanga mwekyusizza ne muva ku Mukama Katonda, tajja kubeera nammwe, ekitala kijja kubatta.” ");
INSERT INTO lug_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Naye era bo ne beesigula ne bambuka mu nsi ey’ensozi, newaakubadde nga Musa teyagenda nabo era nga n’essanduuko ey’endagaano yasigala mu lusiisira. ");
INSERT INTO lug_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Awo Abamaleki n’Abakanani abaabeeranga mu nsi eyo ey’ensozi ne bakkirira ne babalumba ne babakubira ddala okubatuusa e Koluma. ");
INSERT INTO lug_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Mukama Katonda n’agamba Musa ");
INSERT INTO lug_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","ayogere n’abaana ba Isirayiri abagambe nti, “Bwe mutuukanga mu nsi gye mbawadde, mwe munaabeeranga, nga ge maka gammwe, ");
INSERT INTO lug_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ne muleetera Mukama Katonda ebiweebwayo ebyokye nga mubiggya mu biraalo byammwe oba mu bisibo byammwe, ekiweebwayo ku muliro oba ssaddaaka enjokye, okutuukiriza obweyamo bwammwe oba ebiweebwayo olw’okweyagalira oba ku mbaga zammwe entongole, ne muvaamu akawoowo akasanyusa Mukama; ");
INSERT INTO lug_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","kale nno oyo anaaleetanga ekiweebwayo eri Mukama Katonda anaawangayo ekiweebwayo eky’emmere y’empeke eweza nga kilo emu n’ekitundu ez’obuwunga obulungi, nga mutabuddwamu n’amafuta ag’omuzeeyituuni agaweza nga obutundu mwenda obwa Ini ey’amafuta ag’omuzeeyituuni. ");
INSERT INTO lug_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Ku buli mwana gwa ndiga ogw’ekiweebwayo ekyokebwa oba ogwa ssaddaaka, munaateekerateekerangako obutundu mwenda obwa Ini ey’envinnyo nga kye kiweebwayo ekyokunywa. ");
INSERT INTO lug_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“Bwe munaabanga muwaayo endiga ennume munaateekateekanga ekiweebwayo eky’emmere y’empeke eweza nga kilo ssatu n’obutundu bubiri n’ekitundu obwa Ini ez’obuwunga obulungi nga mutabuddwamu n’amafuta ag’omuzeeyituuni ag’obutundu mwenda n’obutundu bubiri obwa Ini, ");
INSERT INTO lug_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","era n’obutundu mwenda n’obutundu bubiri obwa Ini obw’envinnyo nga kye kiweebwayo ekyokunywa, eky’akawoowo akasanyusa Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Bwe munaabanga muteekateeka ente ennume ento ey’ekiweebwayo ekyokebwa oba ssaddaaka, okutuukiriza obweyamo, oba ekiweebwayo olw’emirembe eri Mukama Katonda, ");
INSERT INTO lug_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ku nte eyo ennume munaaleeterangako ekiweebwayo eky’emmere ey’empeke eweza gulaamu mukaaga n’ekitundu ez’obuwunga obulungi nga mutabuddwamu amafuta ag’omuzeeyituuni agaweza kilo emu n’ekitundu. ");
INSERT INTO lug_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Era munaaleetanga envinnyo eweza lita bbiri nga kye kiweebwayo ekyokunywa. Kinaabanga ekiweebwayo ekyokebwa mu muliro ne kivaamu akawoowo akasanyusa Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Buli nte ennume oba endiga ennume, na buli mwana gwa ndiga oba embuzi ento, zonna zinaateekebwateekebwanga mu ngeri eyo. ");
INSERT INTO lug_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Munaakolanga bwe mutyo ku buli gye munaateekateekanga nga bwe zinenkananga obungi. ");
INSERT INTO lug_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“Buli nzaalwa yenna kimusaanira okugobereranga enkola eyo buli lw’anaaleetanga ekiweebwayo ekyokebwa ku muliro, ne kivaamu akawoowo akasanyusa Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Mu mirembe gyammwe gyonna egirijja, omugwira oba omugenyi yenna anaabeeranga mu mmwe bw’anaaleetanga ekiweebwayo ekyokebwa ku muliro ekivaamu akawoowo akasanyusa Mukama Katonda, anaakoleranga ddala nga bwe mukola. ");
INSERT INTO lug_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ekibiina kyammwe kyonna kinaabeeranga n’amateeka geegamu, mmwe ge munaakwatanga era n’abagwira abali mu mmwe ge banaakwatanga; eryo linaabanga etteeka ery’enkalakkalira mu mirembe gyammwe gyonna egirijja. Mmwe nga bwe muli n’omugwira bw’atyo bw’anaabanga mu maaso ga Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Amateeka n’ebiragiro bye munaakwatanga n’omugwira anaabeeranga mu mmwe by’anaakwatanga.” ");
INSERT INTO lug_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Tegeeza abaana ba Isirayiri nti, ‘Bwe muyingiranga mu nsi mwe mbatwala, ");
INSERT INTO lug_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ne mulya ku mmere y’omu nsi omwo, munaaleetangako ekitundu nga kye kiweebwayo eri Mukama. ");
INSERT INTO lug_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Munaggyanga ekitole ku mmere gye munaasookanga okusa mu gguuliro ne mukireeta nga kye kiweebwayo ekivudde mu gguuliro. ");
INSERT INTO lug_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ku mmere eyo gye munaasookerangako okusa munaaleetangako ekiweebwayo ekyo eri Mukama Katonda okuyita mu mirembe gyammwe gyonna.’ ");
INSERT INTO lug_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Naye nno bwe munaalemwanga okukwata amateeka ago gonna Mukama Katonda g’awadde Musa, nga mukikoze mu butagenderera, ");
INSERT INTO lug_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","amateeka ago gonna Mukama Katonda ge yalagira Musa okugabatuusaako okuva ku lunaku Mukama lwe yagamuweerako n’okweyongerayo okuyita mu mirembe gyammwe gyonna egigenda okujja, ");
INSERT INTO lug_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ne mugasobya mu butagenderera n’ekibiina kyonna mu butamanya, kale nno ekibiina kyonna kinaaleetanga ekiweebwayo eky’ente ya sseddume ento emu nga kye kiweebwayo ekyokebwa, omuva akawoowo akalungi eri Mukama Katonda, nga kuliko n’ekiweebwayo ky’emmere y’empeke n’ekyokunywa ng’etteeka bwe liragira, n’ekiweebwayo eky’embuzi ennume emu olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Kabona anaatangiririranga ekibiina ky’abaana ba Isirayiri bonna, era bwe batyo banaasonyiyibwanga; kubanga baasobya mu butagenderera, ate banaabanga baleese ekiweebwayo eri Mukama Katonda ekyokebwa ku muliro, era n’ekiweebwayo eri Mukama Katonda olw’ekibi olw’ekisobyo kyabwe ekitaali kigenderere. ");
INSERT INTO lug_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ekibiina ky’abaana ba Isirayiri bonna, bwe batyo banaasonyiyibwanga, n’abagwira abanaabeeranga mu bo nabo banaasonyiyibwanga, kubanga abantu bonna banaabanga basoberezza wamu nga tebagenderedde. ");
INSERT INTO lug_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Naye omuntu bw’anaasobyanga ng’ali bw’omu mu butagenderera, anaaleetanga embuzi enduusi ey’omwaka gumu ogw’obukulu nga kye kiweebwayo olw’ekibi. ");
INSERT INTO lug_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Kabona anaatangiririranga, eri Mukama, omuntu oyo asobezza mu butagenderera; bw’anaamalanga okutangiririrwa, anaasonyiyibwanga. ");
INSERT INTO lug_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Munaabeeranga n’etteeka lye limu erinaakozesebwanga ku muntu yenna anaasobyanga nga tagenderedde, bw’anaabanga enzaalwa oba ne bw’anaabanga omugwira bulijjo abeera mu mmwe. ");
INSERT INTO lug_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Naye buli muntu anaakolanga ekibi mu bugenderevu, bw’anaabanga enzaalwa ne bw’anaabeeranga omugwira abeera mu mmwe, omuntu oyo anaabanga avvodde Mukama Katonda, noolwekyo anaagobwanga mu bantu be, ne bamwesalirako ddala. ");
INSERT INTO lug_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Olwokubanga anaabanga anyoomye ekigambo kya Mukama Katonda, n’amenya etteeka lye, omuntu oyo anaagoberwanga ddala okuva mu bantu be, ne bamwesalirako ddala, era ekibi kye ekyo kinaasigalanga ku mutwe gwe.” ");
INSERT INTO lug_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Abaana ba Isirayiri bwe baali nga bakyali mu ddungu, ne basisinkana omusajja omu ku b’omu kibiina ky’Abayisirayiri eyali atyaba enku ku lunaku lwa Ssabbiiti. ");
INSERT INTO lug_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Abo abaamusanga ng’atyaba enku ne bamuleeta eri Musa ne Alooni n’ekibiina kyonna, ");
INSERT INTO lug_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ne bamuggalira mu kkomera, kubanga baali tebamanyi bulungi kya kumukolera. ");
INSERT INTO lug_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Awo Mukama Katonda n’agamba Musa nti, “Omusajja oyo ateekwa kuttibwa. Ekibiina kyonna kimukubire amayinja ebweru w’olusiisira.” ");
INSERT INTO lug_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ekibiina kyonna ne kimufulumya wabweru w’olusiisira ne kimukuba amayinja n’afa, nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Yogera eri abaana ba Isirayiri obalagire beekolere amatanvuuwa bagatungenga ku nkugiro z’ebyambalo byabwe mu mirembe gyabwe gyonna, era ku buli ttanvuuwa batungengako akaguwa aka bbululu. ");
INSERT INTO lug_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Amatanvuuwa ago munaagatunulangako, ekyo ne kibajjukiza amateeka ga Mukama Katonda gonna ge musaanira okugonderanga, mulyoke mugagobererenga mulemenga okweyonoonyesa nga mukola ebyo ebitaliimu nsa byokka nga bye bisanyusa amaaso gammwe n’emitima gyammwe. ");
INSERT INTO lug_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Bwe mutyo munajjukiranga amateeka gange ne mubeera batukuvu eri Katonda wammwe. ");
INSERT INTO lug_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Nze Mukama Katonda wammwe, eyabaggya mu nsi y’e Misiri, okubeeranga Katonda wammwe; Nze Mukama Katonda wammwe.” ");
INSERT INTO lug_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Lwali lumu, Koola mutabani wa Izukali, mutabani wa Kokasi, mutabani wa Leevi, ne bano abava mu Lewubeeni, Dasani ne Abiraamu batabani ba Eriyaabu, awamu ne Oni mutabani wa Peresi, bonna ne beewaggula ");
INSERT INTO lug_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ne basituka ne boolekera Musa. Baali ne bannaabwe abasajja Abayisirayiri ebikumi bibiri mu ataano, abaali abamanyifu ennyo mu baana ba Isirayiri era nga bakiise mu Lukiiko Olukulu. ");
INSERT INTO lug_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ne bajjira wamu nga beekobaanye okwolekera Musa ne Alooni ne babagamba nti, “Mwekulumbaza nnyo! Ekibiina kyonna, buli omu mu kyo mutukuvu, ne Mukama Katonda ali nabo. Kale, lwaki mwekulumbaliza ku kibiina ky’abantu ba Mukama?” ");
INSERT INTO lug_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Musa bwe yakiwulira n’avuunama wansi. ");
INSERT INTO lug_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","N’alyoka agamba Koola ne bonna abaali naye nti, “Enkya Mukama Katonda anaalondamu ababe, n’oyo omutukuvu, era anaasembeza omuntu oyo gy’ali. Oyo gw’anaalonda gw’anaasembeza gy’ali. ");
INSERT INTO lug_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Gwe Koola n’abagoberezi bo bonna mukole bwe muti: Muddire ebyoterezo, ");
INSERT INTO lug_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","enkya mubiteekemu omuliro n’obubaane awali Mukama, oyo Mukama Katonda gw’anaalondamu, nga ye mutukuvu. Mmwe batabani ba Leevi mwekulumbazizza nnyo!” ");
INSERT INTO lug_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa n’agamba Koola nti, “Muwulirize, mmwe batabani ba Leevi! ");
INSERT INTO lug_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Mukiraba nga kitono nnyo tekibamala, Katonda wa Isirayiri okubaawulako n’abaggya ku kibiina ekinene eky’abaana ba Isirayiri n’abasembeza w’abeera okukolanga omulimu gwa Mukama mu Weema ya Mukama, n’okuyimiriranga mu maaso g’ekibiina n’okubaweereza? ");
INSERT INTO lug_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Mmwe ne Baleevi bannammwe Mukama Katonda yabasembeza gy’ali, kaakano mwagala n’obwakabona nabwo mubulye? ");
INSERT INTO lug_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Noolwekyo mmwe n’abagoberezi bammwe, mwesimbye ku Mukama Katonda, era gwe mwolekedde. Kale Alooni naye ye ani, mmwe okumwemulugunyiza?” ");
INSERT INTO lug_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Awo Musa n’atumya Dasani ne Abiraamu batabani ba Eriyaabu bayitibwe bajje. Naye ne bagamba nti, “Tetujja kujja! ");
INSERT INTO lug_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Eky’okutuggya mu nsi ekulukuta amata n’omubisi gw’enjuki okututtira mu ddungu, kyali kitono nga tekimala? Ne kaakano oyagala okutwefuulirako omulangira otufuge? ");
INSERT INTO lug_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ng’ebyo bikyali awo, totuleese mu nsi ekulukuta amata n’omubisi gw’enjuki, wadde okutusikiza amasamba n’ennimiro z’emizabbibu. Abasajja bano oyagala obasibe kantuntunu ku maaso obalimberimbe? Nedda, tetujja kujja.” ");
INSERT INTO lug_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Awo Musa n’asunguwala nnyo n’agamba Mukama Katonda nti, “Ekiweebwayo kyabwe tokikkiriza. Tewaliiwo gwe nnali ntutteko wadde akalogoyi akamu, so tewali n’omu ku bo gwe nnali mpisizza obubi.” ");
INSERT INTO lug_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa n’agamba Koola nti, “Ggwe n’abo bonna abakugoberera, enkya mujje awali Mukama Katonda, ggwe nabo ne Alooni. ");
INSERT INTO lug_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Buli musajja ajje n’ekyoterezo kye akiteekemu obubaane, ebyoterezo bijja kuwera ebikumi bibiri mu ataano, mubireete awali Mukama. Ggwe ne Alooni nammwe mujja kuleeta ebyoterezo byammwe.” ");
INSERT INTO lug_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Awo buli musajja n’addira ekyoterezo kye n’akissaamu obubaane n’omuliro, bonna ne bayimirira ne Musa ne Alooni ku mulyango gwa Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Koola bwe yamala okukuŋŋaanya abagoberezi be abavuganya, ku mulyango gwa Weema ey’Okukuŋŋaanirangamu, ekitiibwa kya Mukama Katonda ne kyeraga eri ekibiina kyonna ekyali kikuŋŋaanye. ");
INSERT INTO lug_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Mukama Katonda n’agamba Musa ne Alooni nti, ");
INSERT INTO lug_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Mweyawuleko muve mu kibiina kino ndyoke nkizikirize embagirawo.” ");
INSERT INTO lug_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Naye Musa ne Alooni ne bavuunama amaaso gaabwe wansi ne bagamba nti, “Ayi Katonda, Katonda ow’emyoyo egy’abantu bonna, omuntu omu bw’ayonoona, osunguwalira ekibiina kyonna?” ");
INSERT INTO lug_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Muve okumpi n’eweema eza Koola ne Dasani ne Abiraamu.” ");
INSERT INTO lug_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Awo Musa n’asituka n’agenda eri Dasani ne Abiraamu, n’abakulembeze ba Isirayiri ne bagenda naye nga bamugoberera. ");
INSERT INTO lug_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","N’agamba ekibiina kyonna nti, “Musembereeyo muve okumpi n’eweema z’abasajja bano abakozi b’ebibi! Temukwata ku kintu kyabwe n’ekimu, sikulwa nga mwenna muzikirizibwa olw’ebibi byabwe.” ");
INSERT INTO lug_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Bwe batyo ne basemberayo ne bava okumpi n’eweema za Koola, ne Dasani, ne Abiraamu. Dasani ne Abiraamu baali nga bafulumye mu weema zaabwe nga bayimiridde mu miryango gyazo, nga bali ne bakazi baabwe, ne batabani baabwe, n’obwana bwabwe obuto. ");
INSERT INTO lug_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Awo Musa n’agamba nti, “Ku kino kwe munaategeerera nga Mukama Katonda y’antumye okukola ebintu bino byonna so tekubadde kutetenkanya kwange. ");
INSERT INTO lug_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Singa abasajja bano bafa olumbe olwa bulijjo, oba kugwibwako ebyo ebya bulijjo ebigwa ku bantu bonna, kinaaba kitegeeza nti Mukama si y’antumye. ");
INSERT INTO lug_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Naye singa Mukama Katonda aleetawo ekintu ekiggya ddala ekitali kya bulijjo, ensi n’eyasamya akamwa kaayo n’ebamira nga balamu n’ebintu byabwe byonna, ne bagwa wansi mu gunnya oguwanvu, kale nno munaategeera ng’abasajja abo banyoomodde Mukama Katonda.” ");
INSERT INTO lug_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Awo bwe yali nga yakamala okwogera ebigambo ebyo, ettaka bali kwe baali bayimiridde ne lyabikamu wabiri, ");
INSERT INTO lug_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ensi n’eyasamya akamwa kaayo n’ebamira n’ebintu byabwe byonna eby’omu maka gaabwe, ne basajja ba Koola bonna n’ebintu byabwe byonna. ");
INSERT INTO lug_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Baagwayo wansi mu gunnya nga balamu, n’ebintu byabwe byonna bye baalina; ensi n’ebabuutikira, ne basaanirawo ddala okuva mu bannaabwe. ");
INSERT INTO lug_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Abayisirayiri bonna abaaliwo bwe baabawulira nga bakaaba ne badduka nga bwe bagamba nti, “Si kulwa nga naffe ensi etumira!” ");
INSERT INTO lug_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Olwo omuliro ne gujja nga guva eri Mukama ne gwokera ddala abasajja ebikumi ebibiri mu ataano abaali bawaayo ekiweebwayo eky’obubaane. ");
INSERT INTO lug_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Gamba Eriyazaali mutabani wa Alooni kabona aggye ebyoterezo mu muliro, kubanga bitukuvu, amanda ag’omuliro agasaasaanyize wala. ");
INSERT INTO lug_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ebyoterezo ebyo bya basajja abaayonoona era n’okufa ne bafa; noolwekyo biweesebwemu amasowaane gakozesebwenga ng’ebibikka ku kyoto kubanga baabiwaayo eri Mukama Katonda; noolwekyo bitukuvu. Kale binaabanga kabonero ka kijjukizo eri abaana ba Isirayiri.” ");
INSERT INTO lug_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Bw’atyo Eriyazaali kabona n’addira ebyoterezo eby’ekikomo, ebyali biweereddwayo bali abaayokebwa, ne biweesebwamu ebibikka ku kyoto, ");
INSERT INTO lug_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","kiyambe abaana ba Isirayiri okujjukiranga nti omuntu atali kabona, atava mu lulyo lwa Alooni, taasemberenga kumpi na kyoto okunyookeza obubaane eri Mukama, si kulwa ng’afuuka nga Koola n’ekibiina kye. Eriyazaali bw’atyo bwe yabikola byonna ng’ekiragiro kya Mukama Katonda bwe kyali kye yayisa mu Musa. ");
INSERT INTO lug_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Naye enkeera ekibiina kyonna eby’abaana ba Isirayiri ne beemulugunyiza Musa ne Alooni, nga bagamba nti, “Musse abantu ba Mukama Katonda.” ");
INSERT INTO lug_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Kyokka ekibiina ky’abantu bwe baakuŋŋaana okusoomooza Musa ne Alooni ne bakyuka okwolekera Eweema ey’Okukuŋŋaanirangamu, amangwago ekire ne kigibikka n’ekitiibwa kya Mukama Katonda ne kyeyoleka. ");
INSERT INTO lug_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Musa ne Alooni ne balaga ku mulyango gwa Weema ey’Okukuŋŋaanirangamu, ");
INSERT INTO lug_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Muve mu bantu bano ndyoke mbazikirize embagirawo.” Ne bavuunama wansi. ");
INSERT INTO lug_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Awo Musa n’agamba Alooni nti, “Ddira ekyoterezo kyo okisseemu obubaane, n’omuliro ng’oguggya mu kyoto kya Mukama, oyanguwe ogende mu kibiina obatangiririre. Kubanga obusungu bubuubuuse okuva eri Mukama Katonda era kawumpuli atandise.” ");
INSERT INTO lug_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Alooni n’akola nga Musa bwe yamulagira, n’adduka n’agenda wakati mu kibiina. Yasanga kawumpuli yatandise dda mu bantu, naye Alooni n’awaayo eri Mukama Katonda obubaane okubatangiririra; ");
INSERT INTO lug_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","n’ayimirira wakati w’abafu n’abalamu, kawumpuli n’aziyizibwa. ");
INSERT INTO lug_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Bwe kityo abantu abaafa kawumpuli baawera omutwalo gumu mu enkumi nnya mu lusanvu, nga bali abaafa olw’emitawaana gya Koola tobataddeeko. ");
INSERT INTO lug_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Alooni n’akomawo eri Musa mu mulyango gwa Weema ey’Okukuŋŋaanirangamu, nga kawumpuli amaze okuziyizibwa. ");
INSERT INTO lug_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Awo Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Tegeeza abaana ba Isirayiri baleete emiggo kkumi n’ebiri nga gireetebwa abakulembeze baabwe mu buli kika, omuggo gumu buli kika. Owandiike erinnya lya buli musajja ku muggo gwe gw’aleese. ");
INSERT INTO lug_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Wandiika erinnya lya Alooni ku muggo oguvudde mu kika kya Leevi. Kubanga buli mukulembeze w’ekika ky’obujjajja ajja kubeera n’omuggo ggumu. ");
INSERT INTO lug_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Olyoke ogiteeke mu Weema ey’Okukuŋŋaanirangamu mu maaso g’Essanduuko ey’Endagaano, we mbasisinkana. ");
INSERT INTO lug_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Kale nno omuggo gw’oyo gwe nnaalonda gujja kutojjera; bwe ntyo nzija kusirisa okukwemulugunyiza kuno okutatadde okw’abaana ba Isirayiri.” ");
INSERT INTO lug_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Musa n’ategeeza abaana ba Isirayiri; abakulembeze baabwe ne bamuleetera emiggo, buli mukulembeze omuggo gumu gumu, ng’ebika by’obujjajjaabwe bwe byali, okugatta gyonna gy’emiggo kkumi n’ebiri, nga n’omuggo gwa Alooni mwe guli. ");
INSERT INTO lug_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa n’ateeka emiggo egyo mu maaso ga Mukama Katonda mu Weema ya Mukama ey’Endagaano. ");
INSERT INTO lug_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Awo bwe bwakya enkya Musa n’ayingira mu Weema ya Mukama awali Essanduuko ey’Endagaano, era laba, ng’omuggo gwa Alooni ow’omu kika kya Leevi nga gutojjedde nga guliko n’obutabi obuto, nga gutaddeko n’ebibala ebyengedde. ");
INSERT INTO lug_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Musa n’afulumya emiggo gyonna ng’agiggya mu maaso ga Mukama Katonda, n’agireeta awali abaana ba Isirayiri; ne bagitunuulira, buli omu n’aggyawo omuggo gwe. ");
INSERT INTO lug_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Mukama Katonda n’agamba Musa nti, “Omuggo gwa Alooni guzzeeyo awali Essanduuko ey’Endagaano gukuumirwenga awo ng’akabonero ak’okulabulanga abajeemu. Ekyo kinaasirisa okunneemulugunyiza, balyoke bawone okufa.” ");
INSERT INTO lug_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa n’akola nga Mukama bwe yamulagira. ");
INSERT INTO lug_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Awo abaana ba Isirayiri ne bagamba Musa nti, “Laba, ffenna tujja kufa! Tujja kuggwaawo, tujja kuzikirira. ");
INSERT INTO lug_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Buli muntu anaasembereranga Eweema ya Mukama ajjanga kufa. Ffenna tuli ba kuzikirira?” ");
INSERT INTO lug_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Awo Mukama Katonda n’agamba Alooni nti, “Ggwe, ne batabani bo, n’ab’omu kika kyo bonna, mmwe munaavunaanyizibwanga olw’emisango eginazzibwanga ku watukuvu; era ggwe ne batabani bo mwekka mmwe muneetikkanga obuvunaanyizibwa ku misango eginazzibwanga ku bwakabona. ");
INSERT INTO lug_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Onooleetanga Abaleevi banno ab’omu kika kyo eky’obujjajja ne babeegattako, ggwe ne batabani bo, okubayambanga bwe munaabanga muweereza mu Weema ya Mukama ey’Endagaano. ");
INSERT INTO lug_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Banaaweererezanga wansi wo nga bakola emirimu gyonna egy’omu Weema ya Mukama; naye beekuumenga balemenga okusemberera ekyoto wadde eby’omu watukuvu byonna; bwe balikikola, bo naawe mugenda kufa. ");
INSERT INTO lug_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Bagenda kukwegattako, balabirirenga Weema ya Mukama ey’Okukuŋŋaanirangamu, nga bakola emirimu gyonna egy’omu Weema, era tewaabenga mugwira n’omu anaasemberanga we muli. ");
INSERT INTO lug_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Mmwe munaabanga n’obuvunaanyizibwa obw’emirimu gyonna egy’awatukuvu n’egy’Ekyoto, olwo obusungu buleme kuddamu kubuubuukiranga ku baana ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Kale weeteegereze: nziridde ab’omu lulyo lwo olw’Abaleevi nga mbalonze mu baana ba Isirayiri, ne mbakukwasa ng’ekirabo ekiweereddwayo eri Mukama Katonda okukolanga emirimu egy’omu Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Naye ggwe ne batabani bo mwekka mmwe munaakolanga emirimu gyonna egy’obwakabona bwammwe egikwata ku kyoto n’egy’omunda w’eggigi. Obuweereza obw’Obwakabona mbubawadde ng’ekirabo. Omuntu yenna omulala anaasemberanga okumpi n’awatukuvu, anaafanga.” ");
INSERT INTO lug_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Awo Mukama Katonda n’agamba Alooni nti, “Laba, Nze kennyini nkukwasizza ebiweebwayo byonna ebireetebwa gye ndi; ebiweebwayo byonna ebitukuvu abaana ba Isirayiri bye banandeeteranga mbikuwadde ggwe ne batabani bo nga gwe mugabo gwammwe ogw’olubeerera. ");
INSERT INTO lug_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ku biweebwayo byonna ebitukuvu ennyo ebitayokeddwa mu muliro kunaabangako ebibyo. Omugabo gwo ne batabani bo gunaavanga ku birabo ebitukuvu ennyo abaana ba Isirayiri bye banandeeteranga: ebiweebwayo eby’emmere y’empeke oba ebiweebwayo olw’ekibi, oba ebiweebwayo olw’omusango. ");
INSERT INTO lug_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Omugabo ogwo onooguliiranga mu kifo ekitukuvu ennyo, era buli musajja anaagulyangako. Osaana okitegeere ng’ebyo bitukuvu nnyo. ");
INSERT INTO lug_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Bino nabyo binaabanga bibyo: ku birabo bye banandeeteranga, n’ebiweebwayo ebiwuubibwawuubibwa eby’abaana ba Isirayiri. Ebyo mbikuwadde ne batabani bo ne bawala bo okuba omugabo gwo ogw’olubeerera. Buli muntu yenna ow’omu maka go omulongoofu anaalyangako. ");
INSERT INTO lug_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Nkuwadde ku mafuta ag’omuzeeyituuni agasinga obulungi ne ku wayini omusu, ne ku mmere y’empeke embereberye bye baleetera Mukama eby’amakungula gaabwe. ");
INSERT INTO lug_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Ebibala ebinaasookanga okwengera mu nnimiro zaabwe, bye banaaleeteranga Mukama Katonda, binaabanga bibyo. Buli muntu yenna ow’omu maka go omulongoofu anaalyangako. ");
INSERT INTO lug_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Buli kintu kyonna mu Isirayiri ekiweereddwayo ddala ne kiwongebwa eri Mukama kinaabanga kikyo. ");
INSERT INTO lug_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Buli ekinaggulangawo enda y’omuntu oba ey’ekisolo, nga kyakuwaayo eri Mukama Katonda, kinaabanga kikyo. Naye omwana omubereberye ow’omuntu onoomununulanga, era n’embereberye ez’ensolo ezitali nnongoofu nazo onoozinunulanga. ");
INSERT INTO lug_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ebyo eby’okununula onoobinunulanga bimaze okuweza omwezi gumu ogw’obukulu. Onoobinunuliranga ku muwendo ogwagerekebwa ogwa gulaamu amakumi ataano mu ttaano, ng’ebipimo by’awatukuvu bwe biri. ");
INSERT INTO lug_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Naye embereberye ey’ente, oba embereberye ey’endiga oba ey’embuzi, ezo toozinunulenga, kubanga zo ntukuvu. Onoomansiranga omusaayi gwazo ku kyoto, n’oyokya amasavu gaazo mu muliro ng’ekiweebwayo ekyokebwa ekivaamu akawoowo akasanyusa Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ennyama yaazo eneebanga yiyo ng’ekiweebwayo ky’ekifuba ekiwuubibwawuubibwa n’ekisambi ekya ddyo bwe kiri ekikyo. ");
INSERT INTO lug_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ebiweebwayo byonna ebitukuvu abaana ba Isirayiri bye banaaleeteranga Mukama, mbikuwadde, ggwe ne batabani bo, ne bawala bo, okubeeranga omugabo gwo ogw’olubeerera. Eneebeeranga endagaano ey’omunnyo eya Mukama wakati we naawe n’ezzadde lyo emirembe gyonna.” ");
INSERT INTO lug_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Awo Mukama Katonda n’agamba Alooni nti, “Toobenga na byabusika mu nsi yaabwe, so toobenga na mugabo gwonna mu bo; Nze mugabo gwo era Nze busika bwo mu baana ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Ebitundu eby’ekkumi byonna abaana ba Isirayiri bye banaaleetanga, mbiwadde Abaleevi okubeeranga omugabo gwabwe nga ye mpeera yaabwe olw’omulimu gwe bakola nga baweereza mu Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Era okuva leero abaana ba Isirayiri tebaasembererenga Weema ey’Okukuŋŋaanirangamu, si kulwa nga bakolerayo ebibi, ne bafa. ");
INSERT INTO lug_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Abaleevi be banaakolanga emirimu egy’omu Weema ey’Okukuŋŋaanirangamu, era be baneetikkanga obuvunaanyizibwa bwe banaakolerangayo ebibi. Lino linaabanga tteeka ery’enkalakkalira ne mu mirembe gyammwe gyonna egigenda okujja. Tebaafunenga byabusika mu baana ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Kubanga ebitundu eby’ekkumi abaana ba Isirayiri bye banaaleetanga ng’ekiweebwayo eri Mukama, mbiwadde Abaleevi okubeera omugabo gwabwe. Noolwekyo tebaabenga na byabusika mu baana ba Isirayiri.” ");
INSERT INTO lug_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Yogera n’Abaleevi obagambe nti, ‘Bwe munaafunanga ebitundu eby’ekkumi, bye mbawadde ng’omugabo gwammwe, nga mubiggya ku baana ba Isirayiri, munaggyangako ekitundu eky’ekkumi ne mukireeta nga kye kiweebwayo kyammwe eri Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ekiweebwayo kyammwe kinaabalibwanga ng’emmere y’empeke ey’omu gguuliro oba ng’omubisi ogw’omu ssogolero. ");
INSERT INTO lug_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Mu ngeri eyo nammwe munaaleetanga ekiweebwayo eri Mukama Katonda nga mukiggya ku bitundu eby’ekkumi bye munaafunanga ku baana ba Isirayiri. Ku bitundu ebyo eby’ekkumi kwe munaggyanga ekiweebwayo kya Mukama ne mukikwasa Alooni kabona. ");
INSERT INTO lug_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Mu birabo ebyo byonna bye banaabawanga munaggyangako ekisingira ddala obulungi era ekitukuvu ennyo ne mukireeta nga kye kiweebwayo eri Mukama Katonda.’ ");
INSERT INTO lug_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Abaleevi bagambe nti, ‘Bwe munaawangayo ebitundu ebisinga obulungi, binaababalirwangako ng’ebivudde mu gguuliro n’ebivudde mu ssogolero. ");
INSERT INTO lug_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Mmwe n’ab’omu maka gammwe munaayinzanga okubiriira wonna we munaayagalanga, kubanga eneebeeranga mpeera yammwe olw’omulimu gwe munaakolanga mu Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Bwe munaawangayo ebisingira ddala obulungi, tewaabengawo musango gwonna gwe munaabanga muzzizza; bwe mutyo ebiweebwayo ebitukuvu eby’abaana ba Isirayiri munaabanga temubivumisizza, muleme okufa.’ ” ");
INSERT INTO lug_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Mukama Katonda n’agamba Musa ne Alooni nti, ");
INSERT INTO lug_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Kino kye kiragiro eky’etteeka Mukama ky’alagidde: Gamba abaana ba Isirayiri bakuleetere ente enduusi eya lukunyu eteriiko kamogo wadde ekikyamu kyonna, era nga tesibibwangamu kikoligo. ");
INSERT INTO lug_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ogiwanga Eriyazaali kabona; eneetwalibwanga ebweru w’olusiisira n’ettirwa mu maaso ge. ");
INSERT INTO lug_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eriyazaali anaddiranga ku musaayi gwayo n’olunwe lwe n’agumansira okwolekera obwenyi bwa Weema ey’Okukuŋŋaanirangamu emirundi musanvu. ");
INSERT INTO lug_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Ente eyo eneeyokerwanga mu maaso ge; ne bookya eddiba lyayo, n’ennyama yaayo, n’omusaayi gwayo n’obusa bwayo. ");
INSERT INTO lug_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Kabona anaddiranga omuti omwerezi, n’ezobu n’olugoye olumyufu n’abisuula wakati mu nte eyokebwa. ");
INSERT INTO lug_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Ebyo nga biwedde kabona anaayozanga ebyambalo bye n’anaaba omubiri gwe n’amazzi. Anaddangayo mu lusiisira, naye anaabanga atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","N’omusajja anaayokyanga ente eyo, kinaamusaaniranga okwoza engoye ze n’okunaaba omubiri gwe n’amazzi, era naye anaabanga atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Omusajja omulongoofu anaayoolanga evvu ly’ente, anaaliteekanga mu kifo ekirongoofu ebweru w’olusiisira. Linaalabirirwanga abaana ba Isirayiri ne balikozesanga mu mazzi ag’okwerongoosa; kwe kulongoosebwa okw’okuggibwako ekibi. ");
INSERT INTO lug_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Omuntu oyo anaayoolanga evvu ly’ente, kinaamusaaniranga okwoza engoye ze, era naye taabenga mulongoofu okutuusa akawungeezi. Eryo linaabanga etteeka ery’emirembe n’emirembe eri abaana ba Isirayiri n’eri bannamawanga abanaatuulanga mu bo. ");
INSERT INTO lug_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Buli anaakwatanga ku mulambo ogw’omuntu yenna, anaabanga atali mulongoofu okumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Kinaamusaaniranga okwerongoosa n’amazzi ku lunaku olwokusatu ne ku lunaku olw’omusanvu, olwo n’alyoka abeera omulongoofu. Naye bw’ateerongoosenga ku lunaku olwokusatu ne ku lunaku olw’omusanvu, taabenga mulongoofu. ");
INSERT INTO lug_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Buli anaakwatanga ku mulambo gw’omuntu n’ateelongoosa, anaabanga ayonoonye ennyumba ya Mukama Katonda. Omuntu oyo anaagobwanga mu Isirayiri. Kubanga teyamansirwako mazzi agalongoosa, anaabeeranga atali mulongoofu; obutali bulongoofu bwe bunaamusigalangako. ");
INSERT INTO lug_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Lino lye tteeka erikwata ku muntu anaafiiranga mu weema: Buli anaayingiranga mu weema omwo n’oyo anaabanga agirimu banaabanga abatali balongoofu okumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Buli kintu ekiterekwamu ekyasaamiridde ekitaliiko kisaanikira tekiibenga kirongoofu. ");
INSERT INTO lug_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Omuntu yenna ng’abadde ali ebweru mu kyererezi, n’akwata ku muntu attiddwa n’ekitala oba olumbe gwe lusse, oba omuntu yenna anaakwatanga ku ggumba ly’omuntu oba ku malaalo, anaabeeranga atali mulongoofu okumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Nga mukola ku muntu atali mulongoofu, munaatoolanga ku vvu ery’oku kiweebwayo olw’ekibi ne muliteeka mu bbakuli ne muliyiwako amazzi amalungi. ");
INSERT INTO lug_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Omusajja omulongoofu anaddiranga ezobu n’aginnyika mu mazzi, n’agamansira ku weema ne ku bintu byamu byonna ne ku bantu bonna abanaabanga balimu. Era anaamansiranga ne ku muntu anaabanga akutte ku ggumba ery’omuntu, ne ku malaalo, ne ku muntu attiddwa, ne ku oyo afudde olumbe. ");
INSERT INTO lug_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Omusajja omulongoofu anaamansiranga ku oyo atali mulongoofu ku lunaku olwokusatu ne ku lw’omusanvu, ne ku lunaku olw’omusanvu anaabanga amulongoosezza. Omuntu oyo alongoosebwa anaayozanga engoye ze mu mazzi, n’okunaaba n’anaaba yenna; era akawungeezi ako anaabeeranga mulongoofu. ");
INSERT INTO lug_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Naye omuntu atali mulongoofu bw’ateerongoosenga anaagobwanga mu banne bonna, n’asalibwa ku kibiina kyabwe, kubanga anaabeeranga ayonoonye awatukuvu wa Mukama Katonda. Amazzi agalongoosa nga tegamumansiddwako, taabeerenga mulongoofu. ");
INSERT INTO lug_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Eryo linaabanga tteeka lyabwe lya mirembe gyonna. Oyo anaamansiranga amazzi ag’obulongoofu, naye anaayozanga engoye ze, n’oyo anaakwatanga ku mazzi ag’okulongoosa anaabeeranga atali mulongoofu okutuusa akawungeezi. ");
INSERT INTO lug_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Buli kintu atali mulongoofu ky’akwatako, kinaabanga ekitali kirongoofu; na buli anaakikwatangako anaabanga atali mulongoofu okutuusa akawungeezi.” ");
INSERT INTO lug_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Mu mwezi ogw’olubereberye, ekibiina kyonna eky’abaana ba Isirayiri, ne batuuka mu ddungu lya Zini, ne batuula mu Kadesi. Miryamu n’afiira eyo, era gye yaziikibwa. ");
INSERT INTO lug_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Awo ekibiina kyonna ne kitaba na mazzi. Abantu bonna ne beekuŋŋanyiza ku Musa ne Alooni. ");
INSERT INTO lug_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ne bayombesa Musa nga bagamba nti, “Singa nno naffe twafa, baganda baffe bwe baafiira mu maaso ga Mukama Katonda! ");
INSERT INTO lug_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Lwaki waleeta ekibiina kya Mukama Katonda kino mu ddungu tulyoke tufiire wano n’ebisibo byaffe? ");
INSERT INTO lug_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Lwaki watuggya mu nsi y’e Misiri okutuleeta mu kifo kino ekibi bwe kiti? Tekiriimu mmere ya mpeke wadde ttiini, so si kifo kya mizabbibu, so si kya mikomamawanga. Tewali na mazzi ge tuyinza kunywako!” ");
INSERT INTO lug_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Awo Musa ne Alooni ne bava mu maaso g’ekibiina ky’abantu ne balaga ku mulyango gwa Weema ey’Okukuŋŋaanirangamu, ne bavuunama wansi. Ekitiibwa kya Mukama Katonda ne kibalabikira. ");
INSERT INTO lug_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Twala omuggo, ggwe ne muganda wo Alooni mukuŋŋaanye ekibiina kyonna. Lagira olwazi nga n’ekibiina kyonna kiraba, lujja kufukumula amazzi. Bw’otyo obaggire amazzi mu lwazi, basobole okunywako, era banywese n’ebisibo byabwe.” ");
INSERT INTO lug_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musa n’aggya omuggo awali Mukama n’agutwala nga Mukama Katonda bwe yamulagira. ");
INSERT INTO lug_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa ne Alooni ne bakuŋŋanyiza ekibiina ky’abantu bonna awali olwazi, Musa n’agamba abantu nti, “Mumpulirize, mmwe abajeemu; kitugwanidde ffe okubaggyira amazzi mu lwazi luno?” ");
INSERT INTO lug_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Awo Musa n’ayimusa omukono gwe n’akuba olwazi n’omuggo gwe emirundi ebiri. Amazzi mangi ne gafukumuka okuva mu lwazi, abantu bonna mu kibiina ne banywa, n’ebisibo byabwe nabyo ne binywa. ");
INSERT INTO lug_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Naye Mukama Katonda n’agamba Musa ne Alooni nti, “Olwokubanga temunneesize, ne mutampa kitiibwa, ne mutalaga kibiina kino eky’abaana ba Isirayiri nga bwe ndi omutukuvu, noolwekyo temugenda kutuusa kibiina ky’abantu bano mu nsi gye mbasuubizza okubawa.” ");
INSERT INTO lug_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ago ge mazzi ag’e Meriba, abaana ba Isirayiri gye baayombera ne Mukama, era ne Mukama Katonda gye yeeragira mu bo nga mutukuvu. ");
INSERT INTO lug_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa yatumira Kabaka wa Edomu ababaka ng’asinziira e Kadesi ng’amugamba nti, “Muganda wo Isirayiri agamba bw’ati nti: Ebizibu byonna ebyatutuukako obimanyi. ");
INSERT INTO lug_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Omanyi nga bajjajjaffe bwe baaserengeta mu Misiri, ne tumalayo emyaka mingi. Abamisiri ne bayisa bubi bakadde baffe, era naffe; ");
INSERT INTO lug_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","naye bwe twakaabirira Mukama Katonda, yawulira okukaaba kwaffe, n’atutumira malayika n’atuggya mu nsi y’e Misiri. Kaakano tuli wano mu Kadesi, ekibuga ekiri ku nsalo n’ensi yo. ");
INSERT INTO lug_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","“Nkwegayirira otukkirize tuyite mu nsi yo. Tetuliyita mu birime wadde mu nnimiro z’emizabbibu, era tetugenda kunywa na ku mazzi agali mu nzizi. Tugenda kutambulira mu Luguudo lwa Kabaka Olunene, era tetugenda kuluvaamu kukyamako ku ludda olwa kkono oba olwa ddyo okutuusa nga tumaze okuva mu nsi yo.” ");
INSERT INTO lug_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Naye Edomu n’addamu nti, “Tojja kuyita wano, bw’onookikola tujja kwesowolayo tukulumbe n’ekitala.” ");
INSERT INTO lug_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Abaana ba Isirayiri ne baddamu nti, “Tujja kwambukira mu luguudo olunene mwokka, era ebisibo byaffe naffe bwe tunaanywa ku mazzi gammwe tujja kugasasulira. Twagala kuyitawo buyisi nga tutambuza bigere, tetwetaagayo kirala.” ");
INSERT INTO lug_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Naye Edomu n’addamu nti, “Temuyitawo.” Edomu ne yeesowolayo n’eggye ddene nnyo era nga lya maanyi. ");
INSERT INTO lug_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Bw’atyo Edomu n’agaana Isirayiri okuyitira mu matwale ge, Isirayiri n’amuviira. ");
INSERT INTO lug_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Awo ekibiina kyonna eky’abaana ba Isirayiri ne basitula okuva e Kadesi, ne batuuka ku lusozi Koola. ");
INSERT INTO lug_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Mukama Katonda n’agamba Musa ne Alooni, nga bali ku lusozi Koola okuliraana n’ensalo y’ensi ya Edomu, nti, ");
INSERT INTO lug_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Alooni ajja kugenda abantu be bonna gye baalaga, kubanga tagenda kuyingira mu nsi gye nzija okuwa abaana ba Isirayiri. Kubanga mwembi mwajeemera ekiragiro kyange ku mazzi ag’e Meriba. ");
INSERT INTO lug_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Leeta Alooni ne mutabani we Eriyazaali, obaleete ku lusozi Koola; ");
INSERT INTO lug_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Alooni omwambulemu ebyambalo bye, obyambaze Eriyazaali mutabani we, kubanga Alooni ajja kufa agende abantu be bonna gye baalaga.” ");
INSERT INTO lug_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa n’akola nga Mukama bwe yamulagira; ne balinnya olusozi Koola ng’abantu bonna mu kibiina balaba. ");
INSERT INTO lug_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa n’ayambulamu Alooni ebyambalo, n’abyambaza Eriyazaali mutabani wa Alooni. Alooni n’afiira awo ku ntikko y’olusozi. Musa ne Eriyazaali ne baserengeta ne bakka wansi w’olusozi. ");
INSERT INTO lug_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Abantu bonna mu kibiina bwe bategeera nga Alooni afudde, ab’omu nnyumba ya Isirayiri bonna ne bakungubagira Alooni okumala ennaku amakumi asatu. ");
INSERT INTO lug_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kabaka Omukanani ow’e Yaladi eyatuulanga mu bukiikaddyo, n’awulira nga Isirayiri ajjira mu kkubo lya Asalimu, n’alumba Isirayiri n’amulwanyisa n’awambamu abamu ku bo. ");
INSERT INTO lug_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Awo Isirayiri ne yeeyama eri Mukama Katonda obweyamo buno nti, “Bw’onoogabula abantu bano mu mukono gwaffe, ne tubawangula, ebibuga byabwe tulibizikiririza ddala.” ");
INSERT INTO lug_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Mukama Katonda n’awulira okwegayirira kw’Abayisirayiri, Abakanani n’abawaayo eri Abayisirayiri, ne bazikiriza ebibuga byabwe; ekifo ekyo ne kituumibwa erinnya Koluma. ");
INSERT INTO lug_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ne basitula okuva ku lusozi Koola, ne bakwata ekkubo eriraga ku Nnyanja Emyufu, balyoke beetooloole ensi ya Edomu. Abantu nga bali ku lugendo olwo ne batandika okuggwaamu obugumiikiriza. ");
INSERT INTO lug_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ne beemulugunyiza Musa ne Katonda nga boogera nti, “Lwaki mwatuggya mu Misiri okufiira wano mu malungu? Kubanga temuli mmere; so temuli mazzi; n’obumere buno bwe tufuna tubwetamiddwa.” ");
INSERT INTO lug_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Awo Mukama n’asindikira abantu emisota emikambwe egy’obusagwa, ne gibojja abantu, era abaana ba Isirayiri bangi ne bafa. ");
INSERT INTO lug_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Abantu ne bajja awali Musa, ne bamugamba nti, “Twayonoona bwe twakwemulugunyiza ne twemulugunyiza ne Mukama Katonda, ne tuboogerako bubi. Tusaba weegayirire Mukama atuggyeko emisota gino.” Musa n’asabira abantu. ");
INSERT INTO lug_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Mukama Katonda n’agamba Musa nti, “Kolayo omusota ogufaanana nga giri emikambwe egy’obusagwa oguwanike ku mulongooti; buli anaabojjebwanga omusota, n’agutunulako, anaawonanga.” ");
INSERT INTO lug_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Awo Musa n’aweesa omusota ogw’ekikomo, n’aguwanika ku mulongooti. Kale buli eyabojjebwanga omusota n’atunula ku musota ogw’ekikomo, ng’awona, ng’aba mulamu. ");
INSERT INTO lug_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Awo abaana ba Isirayiri ne basitula ne batambula okutuuka mu Yebosi, ne basiisira omwo. ");
INSERT INTO lug_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ne basitula okuva mu Yebosi ne batambula, ne basiisira mu Lye-Abalimu, mu ddungu eryolekedde Mowaabu, ku luuyi olw’ebuvanjuba. ");
INSERT INTO lug_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Bwe baava awo, ne batambula okulaga mu kiwonvu kya Zeredi, ne basiisira omwo. ");
INSERT INTO lug_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ne bava awo, ne batambula ne basiisira emitala w’omugga Alunoni, oguli mu ddungu erituuka ne ku nsalo ya Abamoli. Omugga Alunoni ye nsalo ya Mowaabu, eyawula Mowaabu n’Abamoli. ");
INSERT INTO lug_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Kyekyava kiwandiikibwa mu Kitabo ky’Entalo za Mukama Katonda, nti, “Zakabu ne Sufa, n’ebiwonvu bya Alunoni, ");
INSERT INTO lug_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","n’obuserengeto bw’ebiwonvu ebituuka ku kibuga kya Ali, ne byesigama ku nsalo ya Mowaabu.” ");
INSERT INTO lug_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Bwe baava eyo ne batambula okutuuka e Beeri, olwo lwe luzzi Mukama we yagambira Musa nti, “Abantu bonna bakuŋŋaanye, mbawe amazzi.” ");
INSERT INTO lug_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Isirayiri n’alyoka ayimba oluyimba luno, nti, “Weetale, ggwe Oluzzi! Muluyimbirire! ");
INSERT INTO lug_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Muyimbe ku luzzi abalangira lwe baasima, abakungu n’abantu lwe baayiikuula, abakungu, emiggo gyabwe.” ");
INSERT INTO lug_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Ne bava mu ddungu ne batambula okutuuka e Matana. Bwe baava e Matana ne balaga e Nakalieri, ne bava e Nakalieri ne balaga e Bamosi. ");
INSERT INTO lug_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bwe baava e Bamosi ne balaga mu kiwonvu ekiri mu matwale ga Mowaabu wansi w’olusozi Pisuga, kw’osinziira okulengera eddungu. ");
INSERT INTO lug_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Awo Isirayiri n’atuma ababaka eri Sikoni kabaka w’Abamoli ng’amugamba nti, ");
INSERT INTO lug_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Tukkirize tuyite mu nsi yo. Tetuliyita mu birime wadde mu nnimiro z’emizabbibu, era tetugenda kunywa na ku mazzi agali mu nzizi. Tugenda kutambulira mu Luguudo lwa Kabaka olunene mwokka okutuusa lwe tuliva mu nsi yo.” ");
INSERT INTO lug_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Naye Sikoni n’atakkiriza Isirayiri kuyita mu nsi ye. N’akuŋŋaanya eggye lye lyonna, n’agenda atabaale Isirayiri mu ddungu. Bwe yatuuka e Yakazi n’alwana ne Isirayiri. ");
INSERT INTO lug_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Isirayiri n’amufumita n’obwogi bw’ekitala, n’atwala ensi ye okuva ku mugga Alunoni okutuuka ku mugga Yaboki, n’atuukira ddala ku Bamoni, n’akoma awo, kubanga Abamoni baali ba maanyi nnyo ku nsalo yaabwe. ");
INSERT INTO lug_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isirayiri n’awamba ebibuga byonna eby’Abamoli n’abeera omwo, ne Kesuboni n’akiwambiramu n’obubuga bwonna obwali bukyetoolodde. ");
INSERT INTO lug_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Kesuboni kye kyali ekibuga ekikulu ekya Sikoni Kabaka w’Abamoli kye yali awambye ng’amaze okulwana n’eyali kabaka wa Mowaabu n’amuggyako ensi ye yonna okutuuka ku Alunoni. ");
INSERT INTO lug_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Abayiiya ennyimba kyebaava bayimba nti, “Mujje e Kesuboni kizimbibwe; ekibuga kya Sikoni kizzibwewo. ");
INSERT INTO lug_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Omuliro gwafuluma mu Kesuboni, ennimi z’omuliro ne ziva mu kibuga kya Sikoni. Gwayokya Ali ekya Mowaabu, n’abatuula mu nsozi za Alunoni. ");
INSERT INTO lug_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Zikusanze, gwe Mowaabu! Muzikirizibbwa, mmwe abantu ba Kemosi! Batabani be abawaddeyo eri kabaka Sikoni ow’Abamoli ne bafuuka ng’abanoonyi b’obubudamu ne bawala be, ng’abawambe. ");
INSERT INTO lug_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Naye tubawangudde Kesuboni azikiridde okutuukira ddala ku Diboni. Tubafufuggazza okutuuka ku Nofa, kwe kutuukira ddala ku Medeba.” ");
INSERT INTO lug_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Bw’atyo Isirayiri n’atuula mu nsi y’Abamoli. ");
INSERT INTO lug_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa bwe yamala okutuma abakessi e Yazeri, abaana ba Isirayiri ne bawamba ebibuga ebyali bikyebunguludde, ne bagobamu Abamoli abaabibeerangamu. ");
INSERT INTO lug_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ne bakyuka ne bambukira mu kkubo eriraga e Basani. Ogi kabaka w’e Basani n’eggye lye lyonna ne yeesowolayo okubatabaala mu lutalo olwali mu Ederei. ");
INSERT INTO lug_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Mukama n’agamba Musa nti, “Tomutya; kubanga mugabudde mu mukono gwo, n’eggye lye lyonna awamu n’ensi ye; omukole nga bwe wakola Sikoni kabaka w’Abamoli eyafugiranga mu Kesuboni.” ");
INSERT INTO lug_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Bwe batyo ne bamutta, ne batabani be, n’eggye lye lyonna, ne batawonyaawo muntu n’omu. Ensi ye ne bagirya. ");
INSERT INTO lug_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Awo abaana ba Isirayiri ne basitula, ne batambula ne basiisira mu lusenyi lwa Mowaabu ku mugga Yoludaani okwolekera Yeriko. ");
INSERT INTO lug_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balaki mutabani wa Zipoli n’alaba byonna Isirayiri bye yali akoze Abamoli. ");
INSERT INTO lug_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Mowaabu n’atya nnyo kubanga abantu abo baali bangi nnyo. Mowaabu okutya abaana ba Isirayiri ne kumusukkirira. ");
INSERT INTO lug_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Awo Mowaabu n’agamba abakulembeze ba Midiyaani nti, “Ogubiina gw’abantu bano bajja kulya byonna bye tuli nabyo ebitwetoolodde ng’ente bw’erya n’esaanyaawo omuddo ogw’oku ttale.” Balaki mutabani wa Zipoli, eyali kabaka wa Mowaabu mu biseera ebyo, ");
INSERT INTO lug_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","n’atuma ababaka eri Balamu mutabani wa Byoli, eyali mu Pesoli, ekiriraanye Omugga, mu nsi y’ewaabwe, okumuyita ng’amugamba nti, “Abantu bali wano, baavudde mu Misiri, basaanikidde ensi yonna we batudde; basiisidde wano okunninaana. ");
INSERT INTO lug_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Kale nno, nkusaba ojje onkolimirire abantu bano, kubanga bampitiridde amaanyi. Oboolyawo lwe ndisobola okubawangula ne mbagoba mu nsi yange. Kubanga mmanyi nga gw’okolimira akolimirwa, ne gw’osabira omukisa aweebwa omukisa.” ");
INSERT INTO lug_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Awo ababaka abaatumibwa, abaali abakulembeze ba Mowaabu n’abakulembeze ba Midiyaani, ne basitula nga batutte n’ensimbi ez’okumusasula. Bwe baatuuka eri Balamu ne bamutegeeza obubaka Balaki bwe yabatuma. ");
INSERT INTO lug_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balamu n’abagamba nti, “Musule wano leero, nange nnaabatuusaako ekigambo Mukama ky’anaaba aŋŋambye.” Bwe batyo abakungu abaava mu Mowaabu ne basula ewa Balamu. ");
INSERT INTO lug_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Katonda n’ajja eri Balamu n’amubuuza nti, “Bantu ki bano abali naawe?” ");
INSERT INTO lug_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balamu n’addamu Katonda nti, “Balaki mutabani wa Zipoli, Kabaka wa Mowaabu ye yampeereza obubaka buno ng’agamba nti, ");
INSERT INTO lug_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Abantu abavudde mu Misiri basaanikidde ensi we batudde. Kale nno jjangu obankolimirire. Oboolyawo ekyo kiyinza okunsobozesa okubalwanyisa ne mbagoba mu nsi yange.’ ” ");
INSERT INTO lug_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Naye Katonda n’agamba Balamu nti, “Togenda na bantu abo. Abantu bali tekikugwanidde kubakolimira, kubanga baaweebwa omukisa.” ");
INSERT INTO lug_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Enkeera mu makya Balamu n’azuukuka, n’agamba abakungu abaatumibwa Balaki nti, “Muddeeyo mu nsi yammwe, kubanga Mukama Katonda aŋŋaanye okugenda nammwe.” ");
INSERT INTO lug_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Abakungu aba Mowaabu ne bakomawo eri Balaki ne bamugamba nti, “Balamu yagaanye okujja naffe.” ");
INSERT INTO lug_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balaki ne yeeyongera okutuma abakungu abalala, nga baabitiibwa binene era nga bangi okusingako ku bali abaasooka. ");
INSERT INTO lug_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ne bajja eri Balamu ne bamugamba nti, “Bw’ati bw’ayogera Balaki mutabani wa Zipoli nti, ‘Nkwegayiridde, tokkiriza kintu kyonna kukuziyiza kujja gye ndi; ");
INSERT INTO lug_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","kubanga nzija kutumbula nnyo ekitiibwa kyo, era ŋŋenda kukukolera kyonna ky’ononsaba. Jjangu onkoliimiririre abantu bano.’ ” ");
INSERT INTO lug_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Naye Balamu n’addamu abo Balaki be yatuma nti, “Balaki ne bw’alimpa enju ye ng’ejjudde ffeeza ne zaabu sigenda kukola kinene oba kitono nga kisukka ku kiragiro kya Mukama Katonda wange. ");
INSERT INTO lug_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Kale nno musule wano olwa leero, nga bannammwe bwe baakola, nange mpulire Mukama Katonda ky’anaayongera okuŋŋamba.” ");
INSERT INTO lug_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Mu kiro ekyo Katonda n’ajja eri Balamu n’amugamba nti, “Obanga abantu abo bakuddukidde, genda nabo, naye okole ekyo kyokka kye nnaakulagira okukola.” ");
INSERT INTO lug_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balamu n’agolokoka mu makya, n’ateeka amatandiiko ku ndogoyi ye, n’agenda n’abakungu ba Mowaabu. ");
INSERT INTO lug_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Naye Katonda n’asunguwala nnyo kubanga Balamu yagenda, malayika wa Mukama Katonda n’ayimirira mu kkubo okumuziyiza. Balamu yali yeebagadde endogoyi ye, abaweereza be babiri nabo baali naye. ");
INSERT INTO lug_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Endogoyi n’eraba malayika wa Mukama Katonda ng’ayimiridde mu kkubo, n’ekitala ekisowoddwa nga kiri mu mukono gwe; endogoyi n’ekyama n’eva mu kkubo n’eraga mu nnimiro. Balamu n’agikuba agizze mu kkubo. ");
INSERT INTO lug_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Malayika wa Mukama Katonda n’ayimirira mu kakubo akafunda akayita wakati w’ennimiro z’emizabbibu nga ziriko ekisenge ku buli luuyi. ");
INSERT INTO lug_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Endogoyi bwe yalaba malayika wa Mukama Katonda ne yeenyigiriza ku kisenge, n’ebetenterako ekigere kya Balamu. N’ayongera okugikuba. ");
INSERT INTO lug_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Malayika wa Mukama Katonda ne yeeyongerayo mu maaso, n’ayimirira mu kakubo akafunda ennyo, awataali kabanga ka kwekyusizaamu kulaga ku mukono ogwa ddyo wadde ku gwa kkono. ");
INSERT INTO lug_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Endogoyi bwe yalaba malayika wa Mukama Katonda n’egalamira wansi, nga Balamu ye agituddeko; obusungu bwa Balamu ne bubuubuuka, n’akuba endogoyi n’omuggo gwe. ");
INSERT INTO lug_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Awo Mukama Katonda n’ayasamya akamwa k’endogoyi, n’egamba Balamu nti, “Nkukoze ki okunkuba emirundi gino gyonsatule?” ");
INSERT INTO lug_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balamu n’agamba endogoyi nti, “Kubanga onfudde atategeera! Singa mbadde n’ekitala mu mukono gwange nandikuttiddewo kaakano.” ");
INSERT INTO lug_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Endogoyi n’egamba Balamu nti, “Siri ndogoyi yo gye weebagadde ebbanga lyonna n’okutuusa ku lunaku lwa leero? Ebadde mpisa yange okukukola bwe nti?” Balamu n’addamu nti, “Nedda.” ");
INSERT INTO lug_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Awo Mukama Katonda n’alyoka azibula amaaso ga Balamu, n’alaba malayika wa Mukama ng’ayimiridde wakati mu kkubo n’ekitala ekisowoddwa nga kiri mu mukono gwe. N’awunzika omutwe gwe, ne yeevuunika wansi n’avuunama. ");
INSERT INTO lug_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Malayika wa Mukama Katonda n’amugamba nti, “Lwaki endogoyi ogikubye emirundi egyo gyonsatule? Laba, nzize okukuziyiza kubanga ekkubo ly’okutte terinsanyusa. ");
INSERT INTO lug_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Endogoyi yandabye n’enneebalama emirundi egyo esatu. Singa teyanneebalamye, nandibadde ggwe nkusse, naye yo nga ngirese.” ");
INSERT INTO lug_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balamu n’agamba malayika wa Mukama Katonda nti, “Nnyonoonye. Saategedde nti ggwe oyimiridde mu kkubo okunziyiza. Kale nno nga kye nkoze bwe kitakusanyusizza, ka nzireyo eka.” ");
INSERT INTO lug_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Malayika wa Mukama Katonda n’agamba Balamu nti, “Genda n’abasajja abo, naye ebigambo bye nnaakulagira bye byokka by’oba oyogera.” Bw’atyo Balamu n’agenda n’abakungu ba Balaki. ");
INSERT INTO lug_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaki bwe yawulira nga Balamu ajja, n’afuluma okugenda okumusisinkana mu kibuga kya Mowaabu ekiri ku nsalo ya Alumoni, ku nkomerero y’amatwale ge. ");
INSERT INTO lug_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki n’agamba Balamu nti, “Saakutumira nga nkuyita ojje ku bwange? Lwaki tewajja gye ndi? Olowooza siyinza kukuwa bitiibwa bingi?” ");
INSERT INTO lug_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balamu n’addamu nti, “Nzuuno kaakano nzize gy’oli! Naye olowooza nnina obuyinza okwogera kyonna kye njagala? Nteekwa okwogera ebyo byokka Katonda by’anassa mu kamwa kange.” ");
INSERT INTO lug_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Bw’atyo Balamu n’agenda ne Balaki ne bajja e Kiriasikuzosi. ");
INSERT INTO lug_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaki n’awaayo ekiweebwayo eky’ente n’endiga, n’aweerezaako ne ku Balamu n’abakungu abaali naye. ");
INSERT INTO lug_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Enkeera Balaki n’atwala Balamu n’amulinnyisa ku bifo bya Bamosi Baali, n’asinziira awo okulengera ku kitundu eky’abantu ba Isirayiri abaali okumpi. ");
INSERT INTO lug_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balamu n’agamba Balaki nti, “Nkolera wano ebyoto musanvu, era onfunire ne sseddume z’ente musanvu, n’endiga ennume musanvu.” ");
INSERT INTO lug_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki n’akola nga Balamu bwe yamugamba; bombi Balaki ne Balamu ne bawaayo ente emu n’endiga ennume emu ku buli kyoto. ");
INSERT INTO lug_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balamu n’agamba Balaki nti, “Beera wano awali ekiweebwayo kyo nze njire nga nzirako wabbali. Oboolyawo nga Mukama anajja n’ansisinkana. Buli kyonna ky’anambikkulira nnaakikutegeeza.” N’alaga waggulu ku lusozi awatali bimera. ");
INSERT INTO lug_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Katonda n’asisinkana Balamu; Balamu n’amugamba nti, “Nteeseteese ebyoto musanvu, era ku buli kyoto mpeereddeko ente ya sseddume emu n’endiga ennume emu.” ");
INSERT INTO lug_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Mukama Katonda n’assa ebigambo mu kamwa ka Balamu n’amugamba nti, “Ddayo eri Balaki omutuuseeko obubaka buno.” ");
INSERT INTO lug_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","N’addayo gye yali, n’amusanga ng’ayimiridde awali ekiweebwayo kye, n’abakungu bonna aba Mowaabu. ");
INSERT INTO lug_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balamu n’alagula nti, “Balaki ye yanzigya mu Alamu, kabaka wa Mowaabu yanzigya mu nsozi z’ebuvanjuba. N’aŋŋamba nti, ‘Jjangu onkolimiririre Yakobo; jjangu oboole Isirayiri.’ ");
INSERT INTO lug_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Nnyinza okukolimira abo Katonda batakolimidde? Nnyinza okuboola abo Mukama Katonda baatabodde? ");
INSERT INTO lug_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Mbalaba okuva ku ntikko ez’enjazi mbalengera nga nsinziira ku nsozi. Ndaba abantu abeeyawuddeko abateerowooza kuba ng’erimu ku mawanga. ");
INSERT INTO lug_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ani ayinza okubala enfuufu ya Yakobo, oba okubala ekitundu ekyokuna ekya Isirayiri? Leka nfe okufa okw’omutuukirivu, n’enkomerero yange ebeere ng’eyaabwe!” ");
INSERT INTO lug_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaki n’agamba Balamu nti, “Onkoze ki kino? Nakuyita kujja kukolimira balabe bange, naye obw’edda bwonna obadde obasabira mukisa!” ");
INSERT INTO lug_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","N’addamu nti, “Tekiŋŋwanidde kwogera ekyo Mukama Katonda ky’atadde mu kamwa kange?” ");
INSERT INTO lug_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaki n’amugamba nti, “Jjangu tugende mu kifo ekirala w’onoolabira abaana ba Isirayiri; ojja kulabako kitundu butundu so si bonna. Kale nno sinziira awo obankolimiririre.” ");
INSERT INTO lug_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","N’amutwala mu nnimiro ya Zofimu, ku ntikko ya Pisuga, n’azimbira eyo ebyoto musanvu n’awaayo sseddume w’ente emu n’endiga ennume emu ku buli kyoto. ");
INSERT INTO lug_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balamu n’agamba Balaki nti, “Beera wano awali ebiweebwayo byo, nze ŋŋende musisinkane wali.” ");
INSERT INTO lug_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Mukama Katonda n’asisinkana Balamu, n’ateeka obubaka mu kamwa ke, ng’agamba nti, “Ddayo eri Balaki omuwe obubaka obwo.” ");
INSERT INTO lug_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","N’addayo gy’ali n’amusanga ng’ayimiridde awali ekiweebwayo, ng’ali n’abakungu ba Mowaabu. Balaki n’amubuuza nti, “Mukama Katonda agambye ki?” ");
INSERT INTO lug_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Bw’atyo n’alagula nti, “Golokoka, Balaki, owulirize; mpulira, mutabani wa Zipoli. ");
INSERT INTO lug_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Katonda si muntu, nti ayinza okulimba, oba nti mwana wa bantu nti akyusakyusa ebigambo bye. Ayogera n’atakola? Asuubiza n’atatuukiriza? ");
INSERT INTO lug_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Mpeereddwa ekiragiro okusaba omukisa; agabye omukisa, era siyinza kukikyusa. ");
INSERT INTO lug_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Tewali kibi kirabiddwa mu Yakobo, tewali kubonaabona kulabise mu Isirayiri. Mukama Katonda waabwe ali nabo; eddoboozi lya kabaka ery’omwanguka liri wakati mu bo. ");
INSERT INTO lug_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Katonda ye yabaggya mu Misiri, balina amaanyi ng’aga sseddume ey’omu nsiko. ");
INSERT INTO lug_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Tewali bulogo ku Yakobo, tewali bulaguzi ku Isirayiri. Kiryogerwako ku Yakobo ne ku Isirayiri nti, ‘Mulabe Katonda ky’akoze!’ ");
INSERT INTO lug_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Abantu basituka ng’empologoma enkazi, beezuukusa ng’empologoma ensajja etaweera okutuusa ng’eridde omuyiggo gwayo n’enywa omusaayi gw’ebyo by’esse.” ");
INSERT INTO lug_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaki n’agamba Balamu nti, “Tobakolimira wadde okubasabira omukisa n’akamu!” ");
INSERT INTO lug_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balamu n’addamu nti, “Saakutegeezezza nti kinsaanidde okukola ekyo kyonna Mukama Katonda ky’anaagamba?” ");
INSERT INTO lug_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki n’agamba Balamu nti, “Jjangu, nkutwale mu kifo ekirala, oboolyawo Katonda anakkiriza obankoliimiririre ng’osinziira awo.” ");
INSERT INTO lug_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaki n’atwala Balamu ku ntikko y’olusozi Peoli, olwolekedde eddungu. ");
INSERT INTO lug_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balamu n’agamba Balaki nti, “Nzimbira wano ebyoto musanvu, era onfunireyo wano ente za sseddume musanvu n’endiga ennume musanvu.” ");
INSERT INTO lug_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaki n’akola nga Balamu bwe yamusaba, n’awaayo sseddume y’ente emu n’endiga ennume emu ku buli kyoto. ");
INSERT INTO lug_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Awo Balamu bwe yalaba nga Mukama Katonda asiimye okuwa Isirayiri omukisa, n’ataddayo kunoonya bya bulaguzi, nga bwe yakola ku mirundi emirala, naye n’ayolekeza amaaso ge eddungu. ");
INSERT INTO lug_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balamu n’alengera ewala, n’alaba Isirayiri gye yasiisira ng’ebika bwe byali, n’ajjirwa Omwoyo wa Katonda, ");
INSERT INTO lug_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","n’alagula nti, “Okulagula kwa Balamu mutabani wa Byoli, okulagula kw’omuntu azibuddwa amaaso, ");
INSERT INTO lug_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","okulagula kw’oyo awulira ekigambo kya Katonda alaba okwolesebwa kw’Ayinzabyonna, eyeeyaze wansi, n’amaaso ge nga gatunula: ");
INSERT INTO lug_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Eweema zo nga nnungi, Ayi Yakobo, ebifo byo mw’obeera, Ayi Isirayiri! ");
INSERT INTO lug_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Byeyaliiridde ng’ebiwonvu, ng’ennimiro ku mabbali g’omugga, ng’emigavu egisimbiddwa Mukama ng’emivule egiri okumpi n’amazzi. ");
INSERT INTO lug_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Amazzi ganaakulukutanga mu bulobo bwabwe; ne gabooga ensigo zaabwe zirifunanga amazzi mangi. “Kabaka waabwe aliba wa kitiibwa okukira Agagi obwakabaka bwabwe bunaagulumizibwanga. ");
INSERT INTO lug_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Katonda ye yabaggya mu Misiri balina amaanyi nga aga sseddume ey’omu nsiko. Basaanyaawo amawanga g’abalabe ne bamenyaamenya amagumba gaabwe mu butundutundu, ne babalasa n’obusaale bwabwe. ");
INSERT INTO lug_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ng’empologoma ensajja, beekulula ne bagalamira wansi, ng’empologoma enkazi; ani ayaŋŋanga okubagolokosa? “Akusabiranga omukisa aweebwenga omukisa n’oyo akukolimira akolimirwenga!” ");
INSERT INTO lug_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Awo obusungu bwa Balaki ne bubuubuukira ku Balamu. N’akuba mu ngalo omulundi gumu, n’amugamba nti, “Nakuyita okolimire abalabe bange, naye obasabidde mukisa emirundi gino gyonsatule. ");
INSERT INTO lug_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Kale nno situka oddeyo ewammwe! Nagamba nti nnandikuwadde ebitiibwa bingi, naye Mukama akuziyizza okuweebwa ebitiibwa ebyo.” ");
INSERT INTO lug_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balamu n’agamba Balaki nti, “Ababaka bo be wantumira, saabagamba nti, ");
INSERT INTO lug_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Balaki ne bw’alimpa ennyumba ye ng’ejjudde zaabu ne ffeeza, sigenda kusukka kiragiro kya Mukama ne nkola ekyange ku bwange oba nga kirungi oba nga kibi, wabula nga ndyogera ebyo byokka Mukama by’alindagira okwogera?’ ");
INSERT INTO lug_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Kaakano nno nzirayo ewaffe mu bantu bange, naye wuliriza nga nkulabula abantu bano kye balikola abantu bo mu nnaku ezijja.” ");
INSERT INTO lug_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","N’alagula bw’ati nti, “Okulagula kwa Balamu mutabani wa Byoli, okulagula kw’omuntu azibuddwa amaaso, ");
INSERT INTO lug_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","okulagula kw’oyo awulira ekigambo kya Katonda, aggya okutegeera eri oyo Ali Waggulu Ennyo alaba okulabikirwa kw’Ayinzabyonna eyeeyaze wansi, n’amaaso ge nga gatunula. ");
INSERT INTO lug_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Mmulaba, naye si kaakano; mmutunuulira, naye tali kumpi. Emmunyeenye eriva ewa Yakobo; omufuzi alisituka ng’ava mu Isirayiri. Alibetenta Mowaabu, obuwanga bw’abatabani ba Seezi. ");
INSERT INTO lug_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edomu aliwangulwa; Seyiri, omulabe we, aliwangulwa, naye Isirayiri alyeyongera amaanyi. ");
INSERT INTO lug_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Omufuzi alisituka ng’ava mu Yakobo n’azikiriza ab’omu kibuga abaliba bawonyeewo.” ");
INSERT INTO lug_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balamu n’alaba Amaleki, n’alagula nti, “Amaleki ye yakulemberanga mu mawanga, naye ku nkomerero agenda kuzikirira.” ");
INSERT INTO lug_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","N’alaba Abakeeni, n’alagula nti: “Ekifo kyo w’obeera wagumu, ekisu kyo kiri mu lwazi ");
INSERT INTO lug_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","naye era mmwe Abakeeni mugenda kuzikirizibwa Asuli bw’alibatwala mu busibe.” ");
INSERT INTO lug_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ate n’alagula nti, “Woowe! Ani aba omulamu nga Katonda asazeewo eky’okukola? ");
INSERT INTO lug_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ebyombo birijja nga biva ku mbalama za Kittimu; birifufuggaza Asuli ne Eberi, naye nabyo birizikirira.” ");
INSERT INTO lug_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Awo Balamu n’asituka n’addayo ewaabwe, ne Balaki n’akwata agage. ");
INSERT INTO lug_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Isirayiri bwe yali mu Sitimu, abasajja ne batandika okwenda n’abakazi ba Mowaabu, ");
INSERT INTO lug_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","abaabayitanga ku kuwaayo ebiweebwayo eri bakatonda baabwe. Abaana ba Isirayiri ne balya era ne bavuunamira bakatonda abo. ");
INSERT INTO lug_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Bw’atyo Isirayiri n’ayingirira eby’okusinzanga Baali ow’e Peoli. Obusungu bwa Mukama ne bubabuubuukirako. ");
INSERT INTO lug_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Mukama n’agamba Musa nti, “Kwata abakulembeze b’abantu bano obatte, obaanike mu maaso ga Mukama abantu bonna we babalabira, obusungu bwa Mukama bulyoke bukkakkane buve ku Isirayiri.” ");
INSERT INTO lug_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Musa n’agamba abalamuzi ba Isirayiri nti, “Buli omu ku mmwe atte abo abali mu mmwe abeegasse mu kusinza Baali ow’e Peoli.” ");
INSERT INTO lug_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Kale, laba, omusajja omu ku baana ba Isirayiri n’aleeta mu maka ge omukazi Omumidiyaani awo mu maaso ga Musa, nga n’ekibiina kyonna ekya Isirayiri bali awo bakaabira mu mulyango gwa Weema ey’Okukuŋŋaanirangamu. ");
INSERT INTO lug_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Naye Finekaasi mutabani wa Eriyazaali, mutabani wa Alooni kabona, bwe yakiraba, n’asituka mu kibiina n’akwata effumu mu mukono gwe ");
INSERT INTO lug_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","n’agoberera Omuyisirayiri n’amutuusa mu weema. Bombi n’abafumita effumu ne liyita mu Muyisirayiri ne liggukira ne mu mubiri gw’omukazi, ne libayitamu bombi. Awo kawumpuli eyali alumbye abaana ba Isirayiri n’akoma. ");
INSERT INTO lug_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","N’abo abaafa kawumpuli baawera emitwalo ebiri mu enkumi nnya. ");
INSERT INTO lug_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finekaasi mutabani wa Eriyazaali, mutabani wa Alooni kabona, ankyusisizza obusungu bwange ne mbuggya ku baana ba Isirayiri; kubanga obusungu bwe bwabuubuuka nnyo ng’obwange olw’obutafaayo ku kitiibwa kyange, kyenvudde sibazikiriza kubamalawo. ");
INSERT INTO lug_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Noolwekyo mutegeeze nti, ‘Laba nkola naye endagaano ey’emirembe. ");
INSERT INTO lug_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ye, ne bazzukulu be bonna banaabanga mu ndagaano ey’obwakabona obw’emirembe gyonna, kubanga yasunguwalira abaana ba Isirayiri olw’okutyoboola ekitiibwa kya Katonda we, n’abatangiririra.’ ” ");
INSERT INTO lug_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Omusajja Omuyisirayiri eyattirwa awamu n’omukazi Omumidiyaani yali Zimuli mutabani wa Salu eyali omukulembeze mu kika kya Simyoni. ");
INSERT INTO lug_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","N’erinnya ly’omukazi Omumidiyaani eyattibwa nga ye Kozebi muwala wa Zuuli, eyali omukulembeze mu kimu ku bika bya Midiyaani. ");
INSERT INTO lug_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Abamidiyaani obayigganyanga n’obatta, ");
INSERT INTO lug_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","kubanga baayagala okubazikiriza n’enkwe zaabwe bwe baabakyamya e Peoli, n’olwa Kozebi muwala w’omukulembeze w’e Midiyaani, omukazi oyo eyattibwa ku lunaku okwajjira kawumpuli olw’ebyo ebyali e Peoli.” ");
INSERT INTO lug_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Awo oluvannyuma lwa kawumpuli, Mukama Katonda n’agamba Musa ne Eriyazaali, mutabani wa Alooni, kabona, nti, ");
INSERT INTO lug_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Bala omuwendo gw’abantu bonna abali mu kibiina ky’abaana ba Isirayiri, ng’obabala mu bika byabwe ne mu mayumba ga bakadde baabwe. Bala abasajja bonna abawezezza emyaka amakumi abiri n’okusingawo abakyasobola okutabaala mu ggye lya Isirayiri.” ");
INSERT INTO lug_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Bwe batyo, nga bali mu nsenyi za Mowaabu, ku ludda lw’omugga Yoludaani okwolekera Yeriko, Musa ne Eriyazaali kabona, ne boogera ne bagamba abantu nti, ");
INSERT INTO lug_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Mubale abasajja bonna abawezezza emyaka amakumi abiri n’okusingawo, nga Mukama Katonda bwe yalagira Musa.” Bano be baana ba Isirayiri abaava mu nsi y’e Misiri: ");
INSERT INTO lug_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ab’omu kika kya Lewubeeni, mutabani wa Isirayiri omubereberye, be bano: abaava mu Kanoki, lwe lunyiriri lw’Abakanoki; abaava mu Palu, lwe lunyiriri lw’Abapalu; ");
INSERT INTO lug_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","abaava mu Kezulooni, lwe lunyiriri lw’Abakezulooni; abaava mu Kalumi, lwe lunyiriri lw’Abakalumi. ");
INSERT INTO lug_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ezo ze nnyiriri z’ekika kya Lewubeeni. Abo abaabalibwa baawera emitwalo ena mu enkumi ssatu mu lusanvu mu amakumi asatu (43,730). ");
INSERT INTO lug_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Mutabani wa Palu yali Eriyaabu, ");
INSERT INTO lug_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ne batabani ba Eriyaabu baali, Nemweri ne Dasani ne Abiraamu. Dasani ne Abiraamu be bo abaali abakulembeze mu kibiina abaajeemera Musa ne Alooni era baali mu kabondo k’abagoberezi ba Koola abaajeemera Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Ensi yayasamya akamwa kaayo n’ebamira, ne bafiira wamu ne Koola; n’abagoberezi ba Koola ebikumi bibiri mu ataano nabo baazikirizibwa mu muliro ogwabasaanyaawo. Ne babeera kabonero ka kulabirako akanaalabulanga abantu. ");
INSERT INTO lug_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Kyokka olunyiriri lwa Koola terwazikiririra ddala lwonna. ");
INSERT INTO lug_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ab’omu kika kya Simyoni ng’ennyiriri zaabwe bwe zaali be bano: abaava mu Nemweri, lwe lunyiriri lw’Abanemweri; abaava mu Yamini, lwe lunyiriri lw’Abayamini; abaava mu Yakini, lwe lunyiriri lw’Abayakini; ");
INSERT INTO lug_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","abaava mu Zeera, lwe lunyiriri lw’Abazeera; abaava mu Sawuli, lwe lunyiriri lw’Abasawuli. ");
INSERT INTO lug_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ezo ze nnyiriri z’ekika kya Simyoni. Abaabalibwa baawera abasajja emitwalo ebiri mu enkumi bbiri mu ebikumi bibiri (22,200). ");
INSERT INTO lug_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ab’omu kika kya Gaadi ng’ennyiriri zaabwe bwe zaali, be bano: abaava mu Zefoni, lwe lunyiriri lw’Abazefoni; abaava mu Kagi, lwe lunyiriri lw’Abakagi; abaava mu Suni, lwe lunyiriri lw’Abasuni; ");
INSERT INTO lug_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","abaava mu Ozeni, lwe lunyiriri lw’Abaozeni; abaava mu Eri, lwe lunyiriri lw’Abaeri; ");
INSERT INTO lug_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","abaava mu Alodi, lwe lunyiriri lw’Abaalodi; abaava mu Aleri, lwe lunyiriri lw’Abaaleri. ");
INSERT INTO lug_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Ezo ze nnyiriri z’ekika kya Gaadi. Abaabalibwa baawera abasajja emitwalo ena mu ebikumi bitaano (40,500). ");
INSERT INTO lug_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Eri ne Onani baali batabani ba Yuda, naye ne bafiira mu nsi ya Kanani. ");
INSERT INTO lug_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Ab’omu kika kya Yuda ng’ennyiriri zaabwe bwe zaali, be bano: abaava mu Seera, lwe lunyiriri lw’Abaseera; abaava mu Pereezi, lwe lunyiriri lw’Abapereezi; abaava mu Zeera, lwe lunyiriri lw’Abazeera. ");
INSERT INTO lug_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Bazzukulu ba Pereezi be bano: abaava mu Kezulooni, lwe lunyiriri lw’Abakezulooni abaava mu Kamuli, lwe lunyiriri lw’Abakamuli. ");
INSERT INTO lug_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ezo ze nnyiriri z’ekika kya Yuda. Abaabalibwa baawera abasajja emitwalo musanvu mu kakaaga mu ebikumi bitaano (76,500). ");
INSERT INTO lug_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ab’omu kika kya Isakaali ng’ennyiriri zaabwe bwe zaali, be bano: abaava mu Tola, lwe lunyiriri lw’Abatola; abaava mu Puva, lwe lunyiriri lw’Abapuva; ");
INSERT INTO lug_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","abaava mu Yasubu, lwe lunyiriri lw’Abayasubu; abaava mu Simuloni, lwe lunyiriri lw’Abasimuloni ");
INSERT INTO lug_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ezo ze nnyiriri z’ekika kya Isakaali. Abaabalibwa baawera abasajja emitwalo mukaaga mu enkumi nnya mu ebikumi bisatu (64,300). ");
INSERT INTO lug_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Ab’omu kika kya Zebbulooni ng’ennyiriri zaabwe bwe zaali be bano: abaava mu Seredi, lwe lunyiriri lw’Abaseredi; abaava mu Eroni, lwe lunyiriri lw’Abaeroni; abaava mu Yaleeri, lwe lunyiriri lw’Abayaleeri. ");
INSERT INTO lug_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Ezo ze nnyiriri z’ekika kya Zebbulooni. Abaabalibwa baawera abasajja emitwalo mukaaga mu ebikumi bitaano (60,500). ");
INSERT INTO lug_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ab’omu kika kya Yusufu nga bayita mu bika bya batabani be Manase ne Efulayimu. ");
INSERT INTO lug_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ab’omu kika kya Manase ng’ennyiriri zaabwe bwe zaali be bano: abaava mu Makiri, lwe lunyiriri lw’Abamakiri, Makiri ye yali kitaawe wa Gireyaadi. Abaava mu Gireyaadi, lwe lunyiriri lw’Abagireyaadi. ");
INSERT INTO lug_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ab’omu kika kya Gireyaadi ng’ennyiriri zaabwe bwe zaali be bano: abaava mu Yezeeri, lwe lunyiriri lw’Abayezeeri, abaava mu Kereki, lwe lunyiriri lw’Abakereki; ");
INSERT INTO lug_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","abaava mu Asuliyeri, lwe lunyiriri lw’Abasuliyeri, abaava mu Sekemu, lwe lunyiriri lw’Abasekemu: ");
INSERT INTO lug_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","abaava mu Semida, lwe lunyiriri lw’Abasemida; abaava mu Keferi, lwe lunyiriri lw’Abakeferi. ");
INSERT INTO lug_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zerofekadi teyazaala baana balenzi, yalina bawala bokka, amannya gaabwe ge gano: Maala, ne Noowa ne Kogula ne Mirika ne Tiruza. ");
INSERT INTO lug_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Ezo ze nnyiriri z’ekika kya Manase; abaabalibwa baawera abasajja emitwalo etaano mu enkumi bbiri mu lusanvu (52,700). ");
INSERT INTO lug_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ab’omu kika kya Efulayimu ng’ennyiriri zaabwe bwe zaali, be bano: abaava mu Susera, lwe lunyiriri lw’Abasusera; abaava mu Bekeri, lwe lunyiriri lw’Ababekeri; abaava mu Takani, lwe lunyiriri lw’Abatakani. ");
INSERT INTO lug_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Bano be bazzukulu ba Susera: abaava mu Erani, lwe lunyiriri lw’Abaerani. ");
INSERT INTO lug_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ezo ze nnyiriri z’ekika kya Efulayimu; n’abaabalibwa baawera abasajja emitwalo esatu mu enkumi bbiri mu ebikumi bitaano (32,500). Abo bonna baava mu Yusufu ng’ebika byabwe bwe byali n’ennyiriri zaabwe bwe zaali. ");
INSERT INTO lug_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ab’omu kika kya Benyamini ng’ennyiriri zaabwe bwe zaali, be bano: abaava mu Bera, lwe lunyiriri lw’Ababera; abaava mu Asuberi, lwe lunyiriri lw’Abasuberi abaava mu Akiramu, lwe lunyiriri lw’Abakiramu ");
INSERT INTO lug_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","abaava mu Sufamu, lwe lunyiriri lw’Abasufamu; abaava mu Kufamu, lwe lunyiriri lw’Abakufamu. ");
INSERT INTO lug_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Abazzukulu ba Bera nga bava mu Aluda ne Naamani ng’ennyiriri zaabwe bwe zaali be bano: abaava mu Aluda, lwe lunyiriri lw’Abaluda; abaava mu Naamani, lwe lunyiriri lw’Abanaamani. ");
INSERT INTO lug_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ezo ze nnyiriri z’ekika kya Benyamini; n’abaabalibwa baawera abasajja emitwalo ena mu enkumi ttaano mu lukaaga (45,600). ");
INSERT INTO lug_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ab’omu kika kya Ddaani ng’ennyiriri zaabwe bwe zaali be bano: abaava mu Sukamu, lwe lunyiriri lw’Abasukamu. Abo be baava mu Ddaani. ");
INSERT INTO lug_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Zonna zaali nnyiriri za Basukamu. Abaabalibwa baawera abasajja emitwalo mukaaga mu enkumi nnya mu ebikumi bina (64,400). ");
INSERT INTO lug_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ab’omu kika kya Aseri ng’ennyiriri zaabwe bwe zaali be bano: abaava mu Imuna, lwe lunyiriri lw’Abayimuna; abaava mu Isuvi, lwe lunyiriri lw’Abayisuvi; abaava mu Beriya, lwe lunyiriri lw’Ababeriya. ");
INSERT INTO lug_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ate okuva mu bazzukulu ba Beriya, ze zino: abaava mu Keberi, lwe lunyiriri lw’Abakeberi; abaava mu Malukiyeeri, lwe lunyiriri lw’Abamalukiyeeri. ");
INSERT INTO lug_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aseri yalina omwana omuwala erinnya lye nga ye Seera. ");
INSERT INTO lug_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ezo ze nnyiriri z’ekika kya Aseri; n’abaabalibwa baawera abasajja emitwalo etaano mu enkumi ssatu mu ebikumi bina (53,400). ");
INSERT INTO lug_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ab’omu kika kya Nafutaali ng’ennyiriri zaabwe bwe zaali be bano: abaava mu Yazeeri, lwe lunyiriri lw’Abayazeeri, abaava mu Guni, lwe lunyiriri lw’Abaguni ");
INSERT INTO lug_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","abaava mu Yezeri, lwe lunyiriri lw’Abayezeeri; abaava mu Siremu, lwe lunyiriri lw’Abasiremu. ");
INSERT INTO lug_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ezo ze nnyiriri z’ekika kya Nafutaali. Abaabalibwa baawera abasajja emitwalo ena mu enkumi ttaano mu ebikumi bina (45,400). ");
INSERT INTO lug_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Okugatta awamu omuwendo gwonna ogw’abaana ba Isirayiri abasajja abaabalibwa baawera emitwalo nkaaga mu lukumi mu lusanvu mu amakumi asatu (601,730). ");
INSERT INTO lug_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Awo Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Ensi ejja kubagabanyizibwamu okubeera obutaka bwabwe ng’obungi bw’amannya gaabwe bwe buli. ");
INSERT INTO lug_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ekibiina ekinene kinaafuna wanene, n’ekibiina ekitono kinaafuna watono. Buli kibiina kinaafuna obunene nga obungi bw’amannya agali ku lukalala bwe genkana obungi. ");
INSERT INTO lug_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Weegendereze okukakasa ng’ensi egabanyizibbwa mu bwenkanya. Ekika, ekitundu kye kinaafuna kineesigama ku bungi bw’amannya ga bajjajja b’ekika ekyo. ");
INSERT INTO lug_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ebitundu ebinene binaagabanyizibwa ku kalulu, era n’ebitundu ebitono nabyo bwe bityo.” ");
INSERT INTO lug_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Bano be Baleevi abaabalibwa ng’enyiriri zaabwe bwe zaali: abaava mu Gerusoni, lwe lunyiriri lw’Abagerusoni; abaava mu Kokasi, lwe lunyiriri lw’Abakokasi; abaava mu Merali, lwe lunyiriri lw’Abamerali. ");
INSERT INTO lug_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ne zino nazo nnyiriri za Baleevi: olunyiriri lw’Ababalibuni, olunyiriri lw’Abakebbulooni, olunyiriri lw’Abamakuli, olunyiriri lw’Abamusi, n’olunyiriri lw’Abakoola. Kokasi yazaala Amulaamu. ");
INSERT INTO lug_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Erinnya lya muka Amulaamu ye yali Yokebedi muwala wa Leevi, Leevi gwe yazaalira mu Misiri. N’azaalira Amulaamu bano: Alooni, ne Musa ne mwannyinaabwe Miryamu. ");
INSERT INTO lug_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Alooni ye yali kitaawe wa bano: Nadabu, ne Abiku, ne Eriyazaali ne Isamaali. ");
INSERT INTO lug_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Kyokka Nadabu ne Abiku ne bafa bwe baakuma omuliro ogutali mutukuvu mu maaso ga Mukama. ");
INSERT INTO lug_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Abasajja bonna okuva ku mwezi ogumu ogw’obukulu n’okusingawo, abaabalibwa, baali emitwalo ebiri mu enkumi ssatu (23,000). Tebaabalirwa wamu na baana ba Isirayiri nga babalibwa, kubanga Abaleevi bo tebaaweebwa mugabo gwa butaka ng’abaana ba Isirayiri bagabana. ");
INSERT INTO lug_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Abo be baabalibwa Musa ne Eriyazaali kabona lwe baabala abaana ba Isirayiri mu nsenyi za Mowaabu ku mugga Yoludaani okwolekera Yeriko. ");
INSERT INTO lug_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Naye mu bano abaabalibwa temwalimu musajja n’omu ku abo abaali babaliddwa Musa ne Alooni kabona bwe baabala abaana ba Isirayiri mu Ddungu lya Sinaayi. ");
INSERT INTO lug_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Kubanga Mukama Katonda yali agambye abaana ba Isirayiri abo nti awatali kubuusabuusa bonna bagenda kufiira mu ddungu. Era tewali n’omu eyasigalawo nga mulamu okuggyako Kalebu mutabani wa Yefune, ne Yoswa mutabani wa Nuuni. ");
INSERT INTO lug_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Abawala ba Zerofekadi mutabani wa Keferi, mutabani wa Gireyaadi, mutabani wa Makiri, mutabani wa Manase, baali ba mu kika kya Manase mutabani wa Yusufu. Amannya g’abawala abo nga ge gano: Maala, ne Noowa, ne Kogula, ne Mirika ne Tiruza. ");
INSERT INTO lug_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Lwali lumu, ne bajja okumpi n’omulyango gwa Weema ey’Okukuŋŋaanirangamu, ne bayimirira mu maaso ga Musa ne Eriyazaali kabona, ne mu maaso g’abakulembeze n’ag’ekibiina kyonna, ne bagamba nti, ");
INSERT INTO lug_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Kitaffe yafiira mu ddungu. Teyali omu ku bajeemu abagoberezi ba Koola abaajeemera Mukama; naye ye yafa bufi lwa bibi bye, naye teyalekawo baana babulenzi. ");
INSERT INTO lug_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Lwaki erinnya lya kitaffe mu kika linaabulamu olw’obutazaala mwana wabulenzi? Mutuwe omugabo mu baganda ba kitaffe.” ");
INSERT INTO lug_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Musa n’aleeta ensonga zaabwe awali Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Mukama n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Abawala ba Zerofekadi kye bagamba kituufu; bafunire omugabo ogw’obutaka awamu ne baganda ba kitaabwe, era n’omugabo gwa kitaabwe gubaweebwe. ");
INSERT INTO lug_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Era gamba abaana ba Isirayiri nti, ‘Omusajja bw’anaafanga nga taleseewo mwana wabulenzi, kale omugabo gwe ogw’obusika bwe gunaaweebwanga omwana we omuwala. ");
INSERT INTO lug_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Bw’ataabenga na mwana wabuwala, omugabo gwe onooguwanga baganda be. ");
INSERT INTO lug_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Bw’anaabanga talina baganda be, omugabo gwe onooguwanga baganda ba kitaawe. ");
INSERT INTO lug_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Kitaawe bw’aba nga teyalina baganda be, omugabo gwe onooguwanga owooluganda asinga okuba ow’okumpi mu kika kye, oyo y’anaagutwalanga. Eryo linaabanga tteeka erinaakwatibwanga abaana ba Isirayiri, nga Mukama Katonda bwe yalagira Musa.’ ” ");
INSERT INTO lug_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Awo Mukama Katonda n’agamba Musa nti, “Yambuka waggulu ku lusozi luno Abalimu olengere ensi gye mpadde abaana ba Isirayiri. ");
INSERT INTO lug_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Bw’onoomala okugiraba, naawe ojja kugenda abantu bo bonna gye baalaga, nga bwe kyali ne ku muganda wo Alooni, ");
INSERT INTO lug_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","kubanga mwembi mwajeemera ekigambo kyange, abantu bwe baajagalala mu ddungu lya Zini ne mutampeesa kitiibwa ng’omutukuvu mu maaso gaabwe.” Ago ge gaali amazzi ag’e Meriba mu Kadesi mu ddungu ly’e Zini. ");
INSERT INTO lug_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Awo Musa n’agamba Mukama Katonda nti, ");
INSERT INTO lug_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Mukama Katonda w’emyoyo gy’abantu bonna, alonde omusajja okulabirira ekibiina kino, ");
INSERT INTO lug_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","afulumenga era ayingirenga mu maaso gaabwe, omuntu anaabafulumyanga era anaabayingizanga, abantu ba Mukama baleme okuba ng’endiga ezitaliiko musumba.” ");
INSERT INTO lug_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Mukama Katonda n’agamba Musa nti, “Twala Yoswa mutabani wa Nuuni, omusajja alimu omwoyo, omusseeko omukono gwo. ");
INSERT INTO lug_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Muyimirize mu maaso ga Eriyazaali kabona ne mu maaso g’ekibiina kyonna, omukuutirire mu maaso gaabwe. ");
INSERT INTO lug_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Mukwase ekitundu ky’obuyinza bwo, ekibiina kyonna eky’abaana ba Isirayiri batandike okumugondera. ");
INSERT INTO lug_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Anajjanga n’ayimirira mu maaso ga Eriyazaali kabona anaamutegeezanga ebinaabanga bisaliddwawo ng’akozesa Ulimu mu maaso ga Mukama Katonda. Abaana ba Isirayiri bonna, bw’anaalagiranga banaafulumanga, era bw’anaalagiranga banaayingiranga.” ");
INSERT INTO lug_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Awo Musa n’akola nga Mukama Katonda bwe yamulagira. Yatwala Yoswa n’amuyimiriza mu maaso ga Eriyazaali kabona, ne mu maaso g’ekibiina kyonna. ");
INSERT INTO lug_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Bw’atyo n’amussaako emikono gye, n’amukuutira, nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Lagira abaana ba Isirayiri ng’obagamba nti, ‘Mutegekenga ekiweebwayo kyange mu biseera bye nnyini, ye mmere ey’ebiweebwayo byange ebyokye, nga bivaamu akawoowo akalungi akansanyusa.’ ");
INSERT INTO lug_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Bagambe nti, ‘Ekiweebwayo ekyokye ky’ojjanga okuwaayo eri Mukama, kinaabanga bwe kiti: endiga ennume bbiri ezitaliiko kamogo nga buli emu ya mwaka gumu ogw’obukulu: zaakuweebwangayo nga njokye buli lunaku. ");
INSERT INTO lug_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Endiga emu munaagiwangayo mu makya, n’endiga eyookubiri munaagiwangayo akawungeezi; ");
INSERT INTO lug_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","nga muteekeddeko ne kilo emu n’ekitundu ez’obuwunga obulungi nga butabuddwamu lita ng’emu ey’amafuta ge zeyituuni. ");
INSERT INTO lug_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ekyo ky’ekiweebwayo ekyokebwa ekya buli kiseera nga bwe kyalagirwa ku lusozi Sinaayi, nga ke kawoowo akasanyusa ak’ekiweebwayo ekyokye eri Mukama. ");
INSERT INTO lug_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Ekiweebwayo ekyokunywa ekigenderako kinaabanga kya lita ng’emu ku buli ndiga. Ekiweebwayo ekyokunywa eri Mukama Katonda munaakifukiranga mu watukuvu. ");
INSERT INTO lug_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Endiga eyookubiri mugiteekateekanga kawungeezi, mu ngeri y’emu n’eyo ey’omu makya. Ekyo kinaabanga ekiweebwayo ekyokebwa, omuva akawoowo akalungi akasanyusa Mukama Katonda.’ ");
INSERT INTO lug_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Ku lunaku lwa Ssabbiiti munaaleetanga ekiweebwayo eky’endiga ennume ez’omwaka ogumu ogw’obukulu, ezitaliiko kamogo, wamu n’ekiweebwayo ekyokunywa ekigenderako, n’ekiweebwayo eky’obuwunga obulungi ekiweza nga kilo ssatu n’obutundu bubiri n’ekitundu nga butabuddwamu amafuta ag’omuzeeyituuni. ");
INSERT INTO lug_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Kino kye kinaabanga ekiweebwayo ekyokebwa ekya buli Ssabbiiti, nga kyongerwa ku kiweebwayo ekyokebwa ekya buli kiseera awamu n’ekiweebwayo ekyokunywa ekigenderako. ");
INSERT INTO lug_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Ku buli lunaku olw’olubereberye olwa buli mwezi onooleetanga eri Mukama ekiweebwayo ekyokebwa eky’ente ennume ento bbiri, n’endiga ento ennume emu, n’abaana b’endiga abalume musanvu abawezezza omwaka ogumu ogw’obukulu; byonna nga tebiriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Ku buli nte nnume ento munaaleeterangako kilo ttaano ez’obuwunga obulungi obutabuddwamu amafuta ag’omuzeeyituuni; ku ndiga ento ennume munaaleeterangako ekiweebwayo eky’emmere y’empeke epima kilo ssatu n’obutundutundu bubiri n’ekitundu ez’obuwunga obulungi obutabuddwamu amafuta ag’omuzeeyituuni; ");
INSERT INTO lug_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ku buli mwana gw’endiga ennume munaaleeterangako ekiweebwayo eky’emmere y’empeke eky’obuwunga obulungi obupima kilo emu n’ekitundu obutabuddwamu amafuta ag’omuzeeyituuni. Ebyo byonna bye by’ekiweebwayo ekyokebwa, ekivaamu akawoowo akalungi ak’ekiweebwayo ekiri ku muliro, ekiweereddwayo eri Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ku buli nte ennume ento kunaaleeterwangako ekiweebwayo ekyokunywa ekya lita emu n’obutundu munaana eza wayini; ku ndiga ennume ento ekya wayini apima lita emu n’obutundu bubiri, ne ku buli mwana gw’endiga ennume ekyokunywa ekya lita emu n’obutundu bubiri eza wayini. Ekyo kye kinaabanga ekiweebwayo ekyokebwa ekya buli mwezi nga gwakaboneka mu mwaka. ");
INSERT INTO lug_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ng’oggyeko ekiweebwayo ekyokebwa ekya bulijjo awamu n’ekiweebwayo ekyokunywa ekigenderako, munaaleetanga embuzi ennume nga kye kiweebwayo olw’ekibi eri Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Olunaku olw’ekkumi n’ennya mu mwezi ogw’olubereberye kwe kunaabanga Embaga ey’Okuyitako kwa Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ku lunaku olw’ekkumi n’ettaano olw’omwezi ogwo kwe kunaabeeranga embaga; munaalyanga emigaati egitali mizimbulukuse okumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Ku lunaku olw’olubereberye munaabeeranga n’okukuŋŋaana okutukuvu; era temulukolerangako mirimu gyonna egy’okukakaalukana. ");
INSERT INTO lug_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Munaawangayo ekiweebwayo ekyokebwa eri Mukama Katonda, ekiweebwayo ekyokebwa eky’ente eza sseddume ento bbiri, n’endiga ento ennume emu, n’abaana b’endiga abalume abawezezza omwaka gumu ogw’obukulu; nga byonna tebiriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Ku buli nte ento ennume munaaleeterangako ekiweebwayo eky’emmere y’empeke ng’eweza kilo ssatu ez’obuwunga obulungi obutabuddwamu amafuta ag’omuzeeyituuni; ku ndiga ennume ento munaaleeterangako kilo bbiri; ");
INSERT INTO lug_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ne ku buli emu ku baana b’endiga ennume omusanvu, kilo emu. ");
INSERT INTO lug_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Munaaleeterangako embuzi ennume emu ey’ekiweebwayo olw’ekibi olw’okwetangiririza. ");
INSERT INTO lug_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Ebyo byonna munaabiteekateekanga nga mwongereza ku kiweebwayo ekyokebwa ekya bulijjo ekya buli makya. ");
INSERT INTO lug_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Munaategekanga mu ngeri eyo, buli lunaku, emmere ey’ekiweebwayo ekyokebwa, okumala ennaku musanvu, nga ke kawoowo akasanyusa Mukama Katonda; ekyo kinaateekebwateekebwanga okwongereza ku kiweebwayo ekyokebwa ekya bulijjo awamu n’ekiweebwayo ekyokunywa ekigenderako. ");
INSERT INTO lug_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Ku lunaku olw’omusanvu munaakubangawo olukuŋŋaana olutukuvu, era temuukolerengako mirimu gyonna egya bulijjo egy’okukakaalukana. ");
INSERT INTO lug_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Ku lunaku olw’ebibala ebibereberye, kwe munaaleeteranga ekiweebwayo eky’emmere y’empeke ey’obuwunga, eri Mukama Katonda, ku Mbaga ya Wiiki, munaakubanga olukuŋŋaana olutukuvu; era temuukolerengako mirimu gyonna egya bulijjo egy’okukakaalukana. ");
INSERT INTO lug_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Munaawangayo ekiweebwayo ekyokebwa eky’ente ento eza sseddume bbiri, n’endiga ento ennume emu, n’abaana b’endiga abalume abawezezza omwaka ogumu ogw’obukulu musanvu, nga ke kawoowo akasanyusa Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Ku buli nte ya sseddume kunaaleeterwangako ekiweebwayo eky’emmere y’empeke ey’obuwunga obulungi obutabuddwamu amafuta ag’omuzeeyituuni obupima kilo ttaano; ne ku ndiga ennume ento, obupima kilo ssatu n’obutundu bubiri n’ekitundu; ");
INSERT INTO lug_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ne ku buli emu ku baana b’endiga ennume omusanvu, obupima kilo emu n’ekitundu. ");
INSERT INTO lug_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Munaagattangako n’embuzi ennume emu ento olw’okwetangiririza. ");
INSERT INTO lug_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Ebyo byonna munaabiwangayo awamu n’ekiweebwayo kyabyo ekyokunywa; okwo kwe munaagattanga ekiweebwayo ekyokebwa ekya bulijjo n’ekiweebwayo kyako eky’emmere ey’empeke. Mwegenderezenga okulaba ng’ensolo ezo zonna teziriiko kamogo.” ");
INSERT INTO lug_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Ku lunaku olw’olubereberye olw’omwezi ogw’omusanvu munaakubanga olukuŋŋaana olutukuvu, era temuukolerengako mulimu gwonna ogwa bulijjo ogw’okukakaalukana. Olwo lwe lunaabanga olunaku lwammwe kwe munaafuuyiranga amakondeere. ");
INSERT INTO lug_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Munaawangayo ekiweebwayo ekyokebwa eky’akawoowo akasanyusa Mukama Katonda. Munaateekateekanga ente ento eza sseddume bbiri, n’endiga ento ennume emu, n’abaana b’endiga abalume abawezezza omwaka ogumu ogw’obukulu musanvu; ebyo byonna nga tebiriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Ku buli nte ya sseddume kunaaleeterwangako ekiweebwayo eky’emmere ey’empeke ey’obuwunga obulungi obutabuddwamu amafuta ag’omuzeeyituuni obupima lita mukaaga n’ekitundu; ne ku ndiga ennume ento obupima kilo ssatu n’obutundu bubiri n’ekitundu, ");
INSERT INTO lug_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ne ku buli emu ku baana b’endiga omusanvu, obupima kilo emu n’ekitundu. ");
INSERT INTO lug_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Mugattangako n’embuzi emu ennume, nga kye kiweebwayo olw’ekibi, okwetangiririza. ");
INSERT INTO lug_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Okwo kwe munaagattanga ebiweebwayo ebyokebwa ebya buli mwezi, n’ebiweebwayo byabyo eby’emmere y’empeke n’ebiweebwayo ebyokunywa, nga bwe kyalagirwa. Binaabanga ebiweebwayo ebyokebwa nga biweereddwayo eri Mukama Katonda ne muvaamu akawoowo akalungi akasanyusa. ");
INSERT INTO lug_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Ku lunaku olw’ekkumi olw’omwezi ogwo ogw’omusanvu munaakubanga olukuŋŋaana olutukuvu. Muneerekerezanga ne mutalukolerako mulimu gwonna. ");
INSERT INTO lug_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Naye munaawangayo ekiweebwayo ekyokebwa eky’ente ento eya sseddume emu, n’endiga ento ennume emu, n’abaana b’endiga abalume ab’omwaka ogumu ogw’obukulu musanvu, byonna nga tebiriiko kamogo ng’ebyo kye kiweebwayo ekyokebwa omuva akawoowo akasanyusa Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Ku nte ya sseddume kunaaleeterwangako ekiweebwayo eky’emmere ey’empeke ey’obuwunga obulungi obutabuddwamu amafuta ag’omuzeeyituuni nga bupima kilo ttaano, ne ku ndiga ennume ento obupima kilo ssatu n’obutundu bubiri n’ekitundu, ");
INSERT INTO lug_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ne ku buli emu ku baana b’endiga abalume omusanvu obupima kilo emu n’ekitundu. ");
INSERT INTO lug_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Mugattangako embuzi ennume emu ey’ekiweebwayo olw’ekibi, nga kyongerwa ku kiweebwayo olw’ekibi olw’okwetangiririza, n’ekiweebwayo ekyokebwa ekya bulijjo nga kuliko n’ekiweebwayo kyako eky’emmere y’empeke, n’ebiweebwayo ebyokunywa ebigenderako. ");
INSERT INTO lug_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Ku lunaku olw’ekkumi n’ettaano olw’omwezi ogw’omusanvu munaakubanga olukuŋŋaana olutukuvu era temulukolerangako mirimu egya bulijjo. Munaakolanga embaga eri Mukama Katonda okumala ennaku musanvu. ");
INSERT INTO lug_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Munaawangayo ekiweebwayo ekyokebwa, ekyokebbwa ku muliro ne muvaamu akawoowo akalungi akasanyusa Mukama Katonda, nga kya nte eza sseddume ento kkumi na ssatu, endiga ennume ento bbiri, abaana b’endiga abalume abaweza omwaka gumu ogw’obukulu kkumi na bana; nga byonna tebiriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Era munaaleeterangako ekiweebwayo eky’emmere y’empeke eky’obuwunga obulungi obutabuddwamu amafuta ag’omuzeeyituuni, nga bupima kilo ttaano ku buli emu ku nte ekkumi n’essatu, nga bupima kilo ssatu n’obutundu bubiri n’ekitundu ku buli emu ku ndiga ento ebbiri ennume; ");
INSERT INTO lug_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ne ku baana b’endiga abalume ekkumi na bana, nga bupima kilo emu n’ekitundu ku buli emu. ");
INSERT INTO lug_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Era munaawangayo n’embuzi emu ennume olw’ekiweebwayo olw’ekibi, ng’okwo mugasseeko n’ebiweebwayo ebyokebwa ebya bulijjo n’ebiweebwayo eby’emmere y’empeke n’ekiweebwayo ekyokunywa ekigenderako. ");
INSERT INTO lug_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“Ku lunaku olwokubiri munaateekateekanga ente eza sseddume ento kkumi na bbiri, n’endiga ennume ento bbiri n’abaana b’endiga abalume kkumi na bana abaweza omwaka gumu ogw’obukulu, nga byonna tebiriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Ku nte eza sseddume, n’endiga ento ennume, n’abaana b’endiga abalume, munaateekateekanga ebiweebwayo byabyo eby’emmere y’empeke n’ebiweebwayo byako eby’ebyokunywa, ng’emiwendo egyalagirwa bwe giri. ");
INSERT INTO lug_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Munaagattangako embuzi ennume emu ey’ekiweebwayo olw’ekibi, nga mwongereza ku kiweebwayo ekyokebwa ekya bulijjo n’emmere yaako ey’empeke, n’ebiweebwayo byako ebyokunywa. ");
INSERT INTO lug_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“Ku lunaku olwokusatu munaateekateekanga ente eza sseddume kkumi n’emu, endiga ento ennume bbiri, n’abaana b’endiga abalume kkumi na bana ab’omwaka ogumu ogw’obukulu; nga byonna tebiriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Ku nte ne ku ndiga ento ennume, ne ku baana b’endiga, byonna munaabiteekerateekerangako ebiweebwayo eby’emmere yaako ey’empeke n’ebiweebwayo ebyokunywa byako ebigenderako, ng’emiwendo egyalagirwa bwe giri. ");
INSERT INTO lug_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Era munaawangayo embuzi emu ennume nga kye kiweebwayo olw’ekibi nga mwongereza ku kiweebwayo ekyokebwa ekya bulijjo, n’ekiweebwayo kyako eky’emmere ey’empeke n’ekiweebwayo kyako ekyokunywa. ");
INSERT INTO lug_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“Ku lunaku olwokuna munaategekanga ente eza sseddume kkumi, n’endiga ento ennume bbiri, n’abaana b’endiga abalume kkumi na bana abawezezza omwaka gumu ogw’obukulu; ebyo byonna nga tebiriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Ku nte ne ku ndiga ento ennume, n’abaana b’endiga, munaabiteekerateekerangako ebiweebwayo byako eby’emmere y’empeke n’ebiweebwayo ebyokunywa byako ng’emiwendo egyalagirwa bwe giri. ");
INSERT INTO lug_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Era munaawangayo embuzi emu ennume, nga kye kiweebwayo olw’ekibi, nga mwongerereza ku kiweebwayo ekyokebwa ekya bulijjo n’ekiweebwayo kyako eky’emmere y’empeke n’ekiweebwayo kyako ekyokunywa. ");
INSERT INTO lug_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“Ku lunaku olwokutaano munaateekateekanga ente eza sseddume mwenda, endiga ento ennume bbiri, n’abaana b’endiga abalume kkumi na bana abawezezza omwaka ogumu nga byonna tebiriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Ku nte ne ku ndiga ento ennume, ne ku baana b’endiga, byonna munaabiteekerateekerangako ebiweebwayo byako eby’emmere y’empeke n’ebiweebwayo ebyokunywa byako ng’emiwendo egyalagirwa bwe giri. ");
INSERT INTO lug_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Era munaawangayo embuzi emu ennume, nga kye kiweebwayo olw’ekibi nga mwongereza ku kiweebwayo kyako eky’emmere y’empeke n’ekiweebwayo ekyokunywa. ");
INSERT INTO lug_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“Ku lunaku olw’omukaaga munaateekateekanga ente eza sseddume munaana, endiga ento ennume bbiri, n’abaana b’endiga abalume kkumi na bana ab’omwaka ogumu ogw’obukulu, ebyo byonna nga tebiriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Ku nte ne ku ndiga ento ennume, n’abaana b’endiga munaabiteekerateekerangako ebiweebwayo byako eby’emmere y’empeke n’ebiweebwayo ebyokunywa byako ng’emiwendo egyalagirwa bwe giri. ");
INSERT INTO lug_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Era munaawangayo embuzi emu ennume, nga kye kiweebwayo olw’ekibi, nga mwongerereza ku kiweebwayo ekyokebwa ekya bulijjo n’ebiweebwayo byako eby’emmere y’empeke, n’ekiweebwayo kyako ekyokunywa. ");
INSERT INTO lug_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“Ku lunaku olw’omusanvu munaateekateekanga ente za sseddume musanvu, endiga ento ennume bbiri, n’abaana b’endiga abalume kkumi na bana ab’omwaka ogumu ogw’obukulu, ebyo byonna nga tebiriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Ku nte ne ku ndiga ento ennume, ne ku baana b’endiga, byonna munaabiteekerateekerangako ebiweebwayo byako eby’emmere y’empeke n’ebiweebwayo byako ebyokunywa, ng’emiwendo egyalagirwa bwe giri. ");
INSERT INTO lug_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Era munaawangayo embuzi emu ennume, nga kye kiweebwayo olw’ekibi, nga mwongerereza ku kiweebwayo ekyokebwa ekya bulijjo, n’ekiweebwayo kyako eky’emmere y’empeke n’ekiweebwayo ekyokunywa. ");
INSERT INTO lug_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“Ku lunaku olw’omunaana munaakubanga olukuŋŋaana, era temuukolenga mirimu gya bulijjo egy’okukakaalukana. ");
INSERT INTO lug_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Munaawangayo ekiweebwayo ekyokye omuva akaloosa akalungi akasanyusa Mukama Katonda, nga kye kiweebwayo ekyokye eky’ente eya sseddume emu, n’endiga ennume ento emu, n’abaana b’endiga abalume musanvu ab’omwaka ogumu ogw’obukulu, ebyo byonna nga tebiriiko kamogo. ");
INSERT INTO lug_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Ku nte ne ku ndiga ento ennume ne ku baana b’endiga, byonna munaabiteekerateekerangako ebiweebwayo byako eby’emmere y’empeke n’ebiweebwayo byako ebyokunywa ng’emiwendo egyalagirwa bwe giri. ");
INSERT INTO lug_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Era munaawangayo embuzi emu ennume nga kye kiweebwayo olw’ekibi, nga mwongerereza ku kiweebwayo ekyokebwa ekya bulijjo, n’ekiweebwayo kyako eky’emmere y’empeke n’ekiweebwayo ekyokunywa. ");
INSERT INTO lug_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“Ebiweebwayo ebyo munaabiwangayo eri Mukama Katonda ku mbaga entongole ezaategekebwa era ezaalagirwa; nga mubyongera ku biweebwayo bye mweyama, n’ebya kyeyagalire, n’ebiweebwayo ebyokebwa, n’ebiweebwayo eby’emmere y’empeke, n’ebiweebwayo ebyokunywa n’ebiweebwayo olw’emirembe.” ");
INSERT INTO lug_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Awo Musa n’ategeeza abaana ba Isirayiri buli kimu kyonna nga Mukama Katonda bwe yamulagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musa n’agamba abakulembeze b’ebika by’abaana ba Isirayiri nti, “Kino Mukama Katonda ky’alagidde: ");
INSERT INTO lug_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Omusajja bw’aneeyamanga eri Mukama Katonda, oba bw’anaalayiranga okutuukiriza ekisuubizo kye, ekigambo kye ekyo taakimenyengawo, naye anaakolanga nga bw’anaabanga asuubizza. ");
INSERT INTO lug_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Omukazi omuvubuka anaabeeranga akyasula mu maka ga kitaawe, bw’aneeyamanga eri Mukama Katonda, oba bw’anaalayiranga okutuukiriza ekisuubizo kye, kale, obweyamo bwe bwonna n’ebyo by’anaabanga asuubizza binaasigalanga nga bwe biri. ");
INSERT INTO lug_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Naye kitaawe bw’anaakiteegerangako, n’amuziyiza, kale, tewaabengawo n’ekimu ku ebyo by’anaabanga asuubizza ebinaasigalanga nga bwe biri. ");
INSERT INTO lug_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Naye kitaawe bw’anaamugaananga ku lunaku lw’anaakiwulira, tewaabengawo ku bweyamo bwe newaakubadde bye yalayira bye yasuubiza ebinaatuukirizibwanga, Mukama Katonda anaabimusonyiwanga, kubanga kitaawe abimuziyizza. ");
INSERT INTO lug_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Bw’anaafumbirwanga ng’amaze okweyama ng’awaddeyo n’ebisuubizo nga tamaze kwerowooza, ");
INSERT INTO lug_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","bba n’abiwulirako, naye n’atabaako ky’ayogera; kale, obweyamo bw’omukazi oyo n’ebisuubizo bye, bye yalagira okubituukiriza, binaasigalanga nga bwe biri. ");
INSERT INTO lug_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Naye singa bba bw’amala okubiwulirako n’amuziyiza, olwo obweyamo bw’omukazi oyo n’ebyo byonna bye yasuubiza nga teyeerowozezza, biba bifudde, era Mukama Katonda anaasonyiwanga omukazi oyo. ");
INSERT INTO lug_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Obweyamo n’ebisuubizo bwe binaakolebwanga nnamwandu oba omukazi eyayawukanira ddala ne bba mu bufumbo, binaasigalanga nga bwe biri. ");
INSERT INTO lug_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Omukazi ali mu bufumbo ng’abeera wamu ne bba mu maka gaabwe, bw’aneeyamanga oba n’asuubiriza ku kirayiro ng’alibaako by’atuukiriza, ");
INSERT INTO lug_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","bba n’abiwulirako, naye n’atabaako ky’agamba mukazi we, n’atamuziyiza; kale, obweyamo bw’omukazi oyo bwonna bunaasigalangawo, ne buli kimu kyonna kye yasuubiza ne yeerayirira, binaasigalangawo. ");
INSERT INTO lug_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Naye bba bw’anaabanga abiwuliddeko, kyokka n’abidibya n’abisazaamu, olwo tewaabengawo bweyamo oba ebisuubizo ebyava mu kamwa k’omukazi, ebinaasigalangawo, era Mukama Katonda anaabimusonyiwanga. ");
INSERT INTO lug_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Bba anaayinzanga okukakasa oba okudibya obweyamo bwonna mukazi we bw’anaabanga akoze n’ebisuubizo byonna by’anaabanga yeerayiridde ebirimu n’okwerumya n’okwefiiriza. ");
INSERT INTO lug_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Naye bba bw’ataabengako ne kyabyogerako nga ky’ajje abiwulire, olwo omukazi anaabanga akakasizza obweyamo bwe bwonna n’ebisuubizo bye yeerayirira. Bba anaabikakasanga bw’ataabengako ky’ategeeza mukazi we bw’anaabanga yaakamala okubiwulirako. ");
INSERT INTO lug_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Naye bwe wanaayitangawo ennaku ng’amaze okubiwulirako, oluvannyuma n’alyoka abidibya, y’anaavunaanyizibwanga ku bitatuukiridde mu bweyamo bw’omukazi oyo.” ");
INSERT INTO lug_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Ago ge mateeka Mukama Katonda ge yalagira Musa aganaakwatanga ku musajja ne mukazi we, era ne kitaawe w’omuwala ne muwala we anaabanga akyali omuvubuka ng’akyasula mu nju ya kitaawe. ");
INSERT INTO lug_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Woolera eggwanga ly’abaana ba Isirayiri ku Bamidiyaani, oluvannyuma olyoke ogende abantu bo bonna gye balaga.” ");
INSERT INTO lug_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Awo Musa n’agamba abantu nti, “Muyungule okuva mu mmwe abasajja abalwanyi mubawe ebyokulwanyisa, beetegekere olutalo, batabaale Midiyaani bawoolere eggwanga lya Mukama Katonda ku Midiyaani. ");
INSERT INTO lug_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Mu buli kika kya Isirayiri mujja kuggyamu abasajja lukumi abanaagenda okutabaala.” ");
INSERT INTO lug_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Awo ne baleeta okuva ku nkumi za Isirayiri abasajja lukumi okuva mu buli kika be balwanyi omutwalo gumu mu enkumi bbiri abeetegekera olutabaalo. ");
INSERT INTO lug_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa n’abasindika mu lutalo, abalwanyi lukumi nga bava mu buli kika; ne Finekaasi mutabani wa Eriyazaali kabona, n’ebintu by’omu watukuvu n’amakondeere ag’okulwana ng’ali nago. ");
INSERT INTO lug_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ne batabaala Midiyaani nga Mukama Katonda bwe yalagira Musa, ne batta buli musajja. ");
INSERT INTO lug_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Mu battibwa mwe mwagendera ne bakabaka ba Midiyaani bano abataano: Evi, ne Lekemu, ne Zuuli, ne Kuula, ne Leeba. Balamu mutabani wa Byoli naye baamuttiramu n’ekitala. ");
INSERT INTO lug_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Abaana ba Isirayiri ne bawamba abakazi ba Midiyaani n’abaana baabwe, ne banyaga ente n’ebisibo byabwe n’ebintu ebirala bingi. ");
INSERT INTO lug_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Baayokya ebibuga by’Abamidiyaani mwe baabeeranga, awamu n’ensiisira zaabwe zonna. ");
INSERT INTO lug_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Baatwala omunyago gwonna, nga mulimu n’abantu n’ensolo; ");
INSERT INTO lug_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ne babireeta awali Musa ne Eriyazaali kabona n’ekibiina kyonna eky’abaana ba Isirayiri mu lusiisira lwabwe olwali mu nsenyi za Mowaabu eziri ku mugga Yoludaani okutunuulira emitala wa Yeriko. ");
INSERT INTO lug_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa ne Eriyazaali kabona n’abakulembeze mu kibiina bonna ne bagenda okusisinkana abatabaazi ebweru w’olusiisira. ");
INSERT INTO lug_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musa n’anyiigira abakulembeze b’eggye, abaduumizi b’ebikumi n’abaduumizi b’enkumi abaakomawo nga bava mu lutabaalo. ");
INSERT INTO lug_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Musa n’ababuuza nti, “Abakazi bonna temubasse? ");
INSERT INTO lug_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Mumanyi nga be baaleetera abaana ba Isirayiri okujeemera Mukama Katonda e Peoli bwe baakolera ku magezi Balamu ge yabawanga, kawumpuli amale alumbe ekibiina kya Mukama. ");
INSERT INTO lug_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Kale nno mutte buli mulenzi mu baana abato, era mutte na buli mukazi eyali yeegasseeko n’omusajja. ");
INSERT INTO lug_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Naye abawala abato abatamanyanga musajja, mubeeterekere. ");
INSERT INTO lug_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Musiisire ebweru w’olusiisira okumala ennaku musanvu. Buli omu mu mmwe eyatta omuntu yenna, n’oyo eyakwatako ku gwe basse, mwetukuze awamu n’abanyage bammwe ku lunaku olwokusatu ne ku lunaku olw’omusanvu. ");
INSERT INTO lug_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Mutukuze buli kyambalo ne buli kintu ekyakolebwa mu maliba, oba mu bwoya bw’embuzi oba mu muti.” ");
INSERT INTO lug_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Awo Eriyazaali kabona n’agamba abasajja abaatabaala nti, “Lino lye tteeka Mukama Katonda ly’alagidde Musa: ");
INSERT INTO lug_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Zaabu, ne ffeeza, n’ekikomo, n’ekyuma, n’ebbaati, n’essasi ");
INSERT INTO lug_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","n’ekirala kyonna ekigumira omuliro mukiyise mu muliro kiryoke kibeere ekirongoofu. Naye era kisaana okulongoosebwa n’amazzi agalongoosa. Ebyo byonna ebitaasobole kuyita mu muliro biyisibwe mu mazzi ago. ");
INSERT INTO lug_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ku lunaku olw’omusanvu mwozanga engoye zammwe, mulyoke mubeere abalongoofu. Ebyo nga biwedde mulyoke muyingire mu lusiisira.” ");
INSERT INTO lug_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Mukama Katonda n’agamba Musa nti, ");
INSERT INTO lug_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Ggwe ne Eriyazaali kabona, n’abakulembeze b’empya ez’omu kibiina mubale obungi bw’omunyago ogwaleetebwa omuli abantu n’ebisolo. ");
INSERT INTO lug_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Omunyago gugabanyeemu mu bitundu bibiri: eky’abatabaazi abaalwana olutalo n’ekyabaasigala mu kibiina. ");
INSERT INTO lug_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Munaggya ku basajja abaatabaala ekitundu kimu ku buli bikumi bitaano, nga gwe musolo gwa Mukama Katonda, oba bantu, oba nte, oba ndogoyi, oba ndiga oba mbuzi. ");
INSERT INTO lug_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Omusolo ogwo mujja kuguggya ku kitundu ekya wakati ekinaagabanibwa abatabaazi mukiwe Eriyazaali kabona nga kye kitundu kya Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Ku munyago gw’abaana ba Isirayiri abasigaddewo munaggyako ekitundu kimu ku bitundu ataano, oba bantu, oba nte, oba ndogoyi, oba ndiga oba mbuzi oba ensolo endala zonna. Ebyo mujja kubiwa Abaleevi, abalabirira Weema ya Mukama.” ");
INSERT INTO lug_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Bwe batyo Musa ne Eriyazaali bwe baakola, nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Omunyago ogwasigalawo abatabaazi gwe beetwalira gwali bwe guti: Endiga, emitwalo nkaaga mu musanvu mu enkumi ttaano (675,000). ");
INSERT INTO lug_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Ente, emitwalo musanvu mu enkumi bbiri (72,000). ");
INSERT INTO lug_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","Endogoyi, emitwalo mukaaga mu lukumi (61,000), ");
INSERT INTO lug_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","n’abakazi abatamanyangako basajja emitwalo esatu mu enkumi bbiri (32,000). ");
INSERT INTO lug_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ekitundu eky’omu makkati eky’omunyago eky’abo abaatabaala kyali bwe kiti: Endiga, obusiriivu busatu mu emitwalo esatu mu kasanvu mu bitaano (337,500); ");
INSERT INTO lug_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ku ezo kwaliko ez’omusolo gwa Mukama Katonda lukaaga mu nsavu mu ttaano (675). ");
INSERT INTO lug_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Ente, emitwalo esatu mu kakaaga (36,000), ng’ez’omusolo gwa Mukama Katonda nsanvu mu bbiri (72). ");
INSERT INTO lug_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Endogoyi, emitwalo esatu mu bitaano (30,500), ng’ez’omusolo gwa Mukama Katonda zaali nkaaga mu emu (61). ");
INSERT INTO lug_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Abantu omutwalo gumu mu kakaaga (16,000); ng’ab’omusolo gwa Mukama Katonda baali amakumi asatu mu babiri (32). ");
INSERT INTO lug_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Omusolo gwa Mukama, Musa n’aguwa Eriyazaali kabona, nga Mukama Katonda bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ekitundu eky’omu makkati eky’omunyago ogwaweebwa abaana ba Isirayiri nga Musa amaze okuggyako ogw’abatabaazi abaalwana mu lutalo, ");
INSERT INTO lug_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ekitundu ekyo kyali bwe kiti: Endiga, emitwalo asatu mu esatu mu bitaano (337,500); ");
INSERT INTO lug_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Ente, emitwalo esatu mu kakaaga (36,000); ");
INSERT INTO lug_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Endogoyi, emitwalo esatu mu bitaano (30,500); ");
INSERT INTO lug_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","n’abantu omutwalo gumu mu kakaaga (16,000). ");
INSERT INTO lug_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Ekitundu eky’omugabo eky’abaana ba Isirayiri, Musa n’aggyako ekitundu kimu ku buli bitundu ataano byombi eby’abantu n’eby’ebisolo, n’abiwa Abaleevi abaalabiriranga Weema ya Mukama, nga Mukama bwe yalagira Musa. ");
INSERT INTO lug_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Awo abakulembeze b’ebibinja mu ggye abaaduumiranga ebikumi n’abaaduumiranga enkumi, ne bajja eri Musa, ");
INSERT INTO lug_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ne bamugamba nti, “Abaweereza bo tubaze abatabaazi bonna be tutwala, nga tewaliiwo n’omu abulawo. ");
INSERT INTO lug_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Noolwekyo tuleetedde Mukama Katonda ekiweebwayo nga kya bintu ebya zaabu buli omu ku ffe bye yanyaga; mwe muli ebikomo eby’oku mikono, emikuufu egy’oku magulu, empeta z’oku ngalo n’empeta ez’omu matu n’obutiiti obw’omu bulago, twetangiririre mu maaso ga Mukama Katonda.” ");
INSERT INTO lug_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa ne Eriyazaali kabona, ne bakkiriza ebyaleetebwa omwali zaabu n’ebyomuwendo ebirala byonna. ");
INSERT INTO lug_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Zaabu yenna abaduumizi b’enkumi, n’abaduumizi b’ebikumi gwe baleeta eri Musa ne Eriyazaali kabona, okuwaayo eri Mukama Katonda, yali apima obuzito bwa kilo kikumi mu kyenda. ");
INSERT INTO lug_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Buli mutabaazi yali yeenyagiddeyo ebintu ebibye ku bubwe. ");
INSERT INTO lug_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Awo Musa ne Eriyazaali kabona ne baddira zaabu eyaleetebwa abaduumizi b’enkumi n’abaduumizi b’ebikumi, ne bamuleeta mu Weema ey’Okukuŋŋaanirangamu, okubeeranga ekijjukizo eri abaana ba Isirayiri mu maaso ga Mukama Katonda. ");
INSERT INTO lug_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Batabani ba Lewubeeni ne batabani ba Gaadi baalina amagana g’ente n’ebisibo by’endiga; ebisolo byabwe nga bingi nnyo. Baatunuulira ensi ya Yazeri n’ensi ya Gireyaadi, ne balaba ng’ekitundu ekyo kituufu okulundiramu ebisolo byabwe. ");
INSERT INTO lug_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Ne bajja awali Musa ne Eriyazaali kabona, n’eri abakulembeze b’ekibiina ne babagamba nti, ");
INSERT INTO lug_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Ebitundu bino: Atalisi, ne Diboni, ne Yazeri, ne Nimula, ne Kesuboni, ne Ereyale, ne Sebamu, ne Nebo ne Beoni, ");
INSERT INTO lug_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","bye bitundu by’ensi Mukama Katonda gye yawangulira mu maaso g’abaana ba Isirayiri, nsi nnungi okulundiramu; ate ng’abaweereza bammwe tulina ebisolo byaffe bingi.” ");
INSERT INTO lug_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ne bagamba nti, “Bwe kuba nga kwe kusiima kwammwe, mukkirize ebitundu by’ensi bino bituweebwe, ffe abaweereza bammwe, bibeere obutaka bwaffe. Temutusomosa Yoludaani.” ");
INSERT INTO lug_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa n’agamba batabani ba Gaadi ne batabani ba Lewubeeni nti, “Mwagala baganda bammwe bagende batabaale, nga mmwe mwetuulidde wano? ");
INSERT INTO lug_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Lwaki abaana ba Isirayiri mwagala okubamalamu amaanyi mu mitima gyabwe mubalemese okuyingira mu nsi Mukama Katonda gy’abawadde? ");
INSERT INTO lug_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Ne bakadde bammwe bwe baakola bwe nabatuma okuva e Kadesubanea okuketta ensi. ");
INSERT INTO lug_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Kubanga bwe baayambuka mu Kiwonvu ekya Esukoli, ensi ne bagiraba, ne bayeengebula emitima gy’abaana ba Isirayiri baleme okugenda okuyingira mu nsi Mukama Katonda gye yali abawadde. ");
INSERT INTO lug_vp