﻿USE sofia;
DROP TABLE IF EXISTS sofia.luc_vpl;
CREATE TABLE luc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES luc_vpl WRITE;
INSERT INTO luc_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Íꞌdóŋá gá rĩ sĩ, Ãdróŋá ꞌbã ꞌbụ̃ kí ụ̃nọ́kụ́ be. ");
INSERT INTO luc_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ụ̃nọ́kụ̂ ándrá ị̃sálị ãzíla ãko ãzî kóru, ãngũ nị ị̃yị́ kị́rị́ rĩ drị̃ gá ãzíla úríndí Ãdróŋá drị̂ ri uꞌálé ị̃yị́ drị̃ gá ụrụgá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ, “Dị̃zã ꞌbã adru cí,” ãzíla dị̃zã iꞌdá dó cí. ");
INSERT INTO luc_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ãdróŋá ndre dị̃zã ĩꞌdi múké ãzíla awa dó sĩ dị̃zã kí ãngũ ịnị rĩ be ndú-ndú. ");
INSERT INTO luc_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ãdróŋá ꞌda dó sĩ dị̃zã ní rụ́ “ị̃tụ́ ꞌi” ãzíla ꞌda dó ãngũ ịnị rĩ rụ́ “ị́nị́ ꞌi.” Ị̃tụ́ kí Ị́nị́ be ꞌdĩ ụ́ꞌdụ́ ãlu rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ, “Ãko ãzí ꞌbã adru cí sĩ ị̃yị́ kí drĩdríŋĩ cejó ị̃yị́ be.” ");
INSERT INTO luc_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ị́jọ́ ꞌdĩ sĩ Ãdróŋá idé dó ãko ãzí ị̃yị́ ụrụ gá ri kí drĩdríŋĩ cejó ị̃yị́ vụ̃rụ́ rĩ abe, idé dó ru cécé ꞌdĩ ꞌbã áni. ");
INSERT INTO luc_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ãdróŋá umve dó ãngũ ụrụ gá rĩ “ꞌbụ̃ ꞌi.” Ị̃tụ́ kí Ị́nị́ be ꞌdĩ ụ́ꞌdụ́ ị̃rị̃ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ, “Ị̃yị́ ꞌbụ̃ ị̃ndụ́ gá rĩ ꞌbã tra kí ru ãngũ ãlu gá, ãngũ ãꞌí rĩ ꞌbã iꞌdá dó sĩ.” Wó idé ru rá. ");
INSERT INTO luc_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ãdróŋá ꞌda ãngũ ãꞌí rĩ rụ́ vũ ꞌi ãzíla ị̃yị́ ru tralépi ãngũ ãlu gá rĩ rụ́ mĩrĩ ꞌi. Ãdróŋá ndre ãko ꞌdĩ kí múké. ");
INSERT INTO luc_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ, “Ásé ꞌbã dụ vũ drị̃ gá, ife ífí kalépi ndú-ndú ꞌdĩ kî trũ.” Idé ru rá. ");
INSERT INTO luc_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ásé ũví ndú-ndú ꞌdĩ dụ kí vũ drị̃ gá ꞌdãá ife ũví ndú-ndú ífí kalépi rĩ kí abe. Ãdróŋá ndre ãko ꞌdĩ kí múké. ");
INSERT INTO luc_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ị̃tụ́ kí Ị́nị́ be ụ́ꞌdụ́ na rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ, “Dị̃zã ꞌbã adru kí ꞌbụ̃ gá ꞌdãá cí sĩ ị̃tụ́ kí drĩdríŋĩ cejó ị́nị́ be, ꞌbã adru kí ícétáŋá ru cí sĩ áyi, ụ́ꞌdụ́ ãzíla ílí kí nị̃jó. ");
INSERT INTO luc_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Lẽ dị̃zã ꞌbã adru ꞌbụ̃ gá ꞌdãá cí sĩ ãngũ jijó ụ̃nọ́kụ́ drị̃ gá.” Idé ru ꞌdã ꞌbã áni rá. ");
INSERT INTO luc_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ị́jọ́ ꞌdĩ sĩ Ãdróŋá idé dó dị̃zã ãmbógó la kí ị̃rị̃ ãmbógó ãndânĩ rĩ ꞌbã ji dó sĩ ãngũ ị̃tụ́ sĩ ãzíla wereŋá rĩ ꞌbã ji dó sĩ ãngũ ị́nị́ sĩ, ꞌbã adru kí dó úpí ru ị́nị́ kí drị̃lẹ́ gá ị̃tụ́ be. Ũꞌbã vâ lẽlẽgó kí ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ãdróŋá ụ̃tị̃ dị̃zã kí ꞌbụ̃ gá ꞌdãá ãngũ jijó vũ drị̃ gá, ");
INSERT INTO luc_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","adrujó úpí ru ị̃tụ́ kí drị̃ gá ị́nị́ be, awa dô sĩ dị̃zã kí drĩdríŋĩ ị́nị́ be. Ãdróŋá ndre ãko ꞌdĩ kí múké. ");
INSERT INTO luc_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ị̃tụ́ kí Ị́nị́ be ꞌdĩ ụ́ꞌdụ́ sụ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ, “Mĩrĩ ꞌbã ga tré ãko ídri trũ ꞌdĩ kî sĩ, ãriŋa ꞌbã unga kí vâ ụrụ gá ꞌbụ̃ agá ꞌdãá.” ");
INSERT INTO luc_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ị́jọ́ ꞌdĩ sĩ Ãdróŋá ũꞌbã dó ãnãkpá ãmbogo uꞌálépi mĩrĩ agá rĩ kí, ãko pírí ídri trũ acị́lépi acị̂ ị̃yị́ ꞌbã sĩ gajó tré ũví ĩꞌbadrị̂ kí sĩ rĩ kí ãriŋa ũví ndú-ndú ꞌdĩ kí abe. Ãdróŋá ndre ãko ꞌdĩ kí dó múké. ");
INSERT INTO luc_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ãdróŋá wi ĩꞌbaní sụ̃sụ́ jọ, “Ĩtị ãzíla ĩmi ĩjãlã ĩmi wẽwẽ rú mĩrĩ ꞌbã ga dó sĩ tré ãzíla ãriŋa ꞌbã ĩjãlã kí vâ ru vũ drị̃ gá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ị̃tụ́ kí Ị́nị́ be, ꞌdĩ ụ́ꞌdụ́ tõwú rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ, “Vũ ꞌbã fẽ Ãnãkpá pírí ídri trũ rĩ ꞌbã kpẹ̃ kí sụ́rụ́ tị ĩꞌbadrị̂ kí vú sĩ, ãnãkpá lị́cọ́ gá rĩ kí, ãnãkpá ãgãlépi vũ rụ̂ sĩ rĩ abe, ásé agá rĩ kí, ãnãkpá ãmbogo rĩ kí, ãnãkpá nírí rĩ kí abe.” Idé ru ꞌdã ꞌbã áni rá. ");
INSERT INTO luc_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ãdróŋá ũꞌbã ãnãkpá ásé agá rĩ kí sụ́rụ́ tị ĩꞌbadrị̂ kí vú sĩ, lị́cọ́ gá rĩ kí sụ́rụ́ tị ĩꞌbadrị̂ kí vú sĩ, ãnãkpá ãgãlépi vũ rụ̂ sĩ rĩ kí ũví ĩꞌbadrị̂ kí vú sĩ. Ãdróŋá ndre ãko ꞌdĩ kí dó múké. ");
INSERT INTO luc_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ, “Lẽ ãma idé ꞌbá gbíyã ãmadrị̂ sĩ, ꞌba ají ru ãma abe, ꞌbã adru kí úpí ru Ị̃ꞌbị mĩrĩ agá rĩ kí drị̃lẹ́ gá, ãriŋa ꞌbụ̃ gá rĩ kî trũ, ãnãkpá lị́cọ́ gá rĩ kî trũ, ãko pírí ũꞌbãlé ụ̃nọ́kụ́ drị̃ gá rĩ kî trũ ãzíla ãnãkpá ãgãlépi vũ rụ̂ sĩ rĩ kí abe pírí.” ");
INSERT INTO luc_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ãdróŋá ꞌbã dó ꞌbá gbíyã ĩꞌdidrị̂ sĩ, gbíyã ĩꞌdidrị̂ sĩ ꞌbã dó ágọ́bị́ kí ũkú be. ");
INSERT INTO luc_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá wi dó sụ̃sụ́ ĩꞌbanî, jọ, “Ĩtị ãzíla ĩkpẹ̃ wẽwẽ rú, ĩga tré ụ̃nọ́kụ́ drị̃ gá ꞌdâ. Ĩmi adru úpí ru Ị̃ꞌbị mĩrĩ agá rĩ kí drị̃ gá, ãriŋa ꞌbụ̃ gá rĩ kî trũ ãzíla ãko pírí ídri trũ acị́lépi ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ kî trũ.” ");
INSERT INTO luc_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ, “Ĩndre áfẽ ĩminí ũri ãko pírí ãni ífí kalépi ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ kí ife pírí ífí kalépi ꞌdĩ kí abe kí adru ĩminí ãkónã rú. ");
INSERT INTO luc_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Áfẽ vâ ásé ĩrí ru ãnãkpá pírí ꞌbaní, ãriŋa ꞌbụ̃ gá rĩ kî trũ ãzíla ãko acị́lépi ídri trũ ụ̃nọ́kụ́ drị̃ gá rĩ ꞌbaní ãkónã rú.” Idé dó ru ꞌdã ꞌbã áni. ");
INSERT INTO luc_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ãdróŋá ndre dó ãko pírí ĩꞌdi ꞌbã idélé rĩ kí ũniyambamba rú. Ị̃tụ́ kí Ị́nị́ be, ꞌdĩ ụ́ꞌdụ́ ázíyá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ị́jọ́ ꞌdĩ sĩ Ãdróŋá de dó ꞌbụ̃ kí ũꞌbã agá ụ̃nọ́kụ́ be ãzíla ãko pírí ala gá rĩ kí abe rá. ");
INSERT INTO luc_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ãdróŋá avị́ dó ụ́ꞌdụ́ ázị̂rị̃ rĩ sĩ ãzị́ ĩꞌdi ꞌbã ngalé vâ delé ꞌbo rĩ kí ũngúkú gá. ");
INSERT INTO luc_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ị́jọ́ ꞌdĩ sĩ Ãdróŋá wi dó sụ̃sụ́ ụ́ꞌdụ́ ázị̂rị̃ rĩ drị̃ gá ãzíla ꞌbã dó sĩ ĩꞌdi ãlá ru ãꞌdusĩku ụ́ꞌdụ́ ázị̂rị̃ ꞌdã ándrá ụ́ꞌdụ́ Ãdróŋá ꞌbã sĩ avị́jó ãzị́ pírí ĩꞌdi ꞌbã ngalé sĩ ãko kí ũꞌbãjó rĩ ꞌbã vúlé gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ꞌDĩ ãwí Úpí Ãdróŋá ꞌbã ꞌbụ̃ kí ꞌbãjó ụ̃nọ́kụ́ be rĩ. Úpí Ãdróŋá la dó mụ ụ̃nọ́kụ́ ꞌbãlé ꞌbụ̃ be ꞌbo, ");
INSERT INTO luc_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ãko ãzí dụlépi ĩrí ru la ụ̃nọ́kụ́ drị̃ gá ꞌdáyụ ãzíla ũri ãzí angálépi rá la ꞌdáyụ ãꞌdusĩku Úpí Ãdróŋá ꞌbã drĩ fẽjó la uzogó ꞌbã ꞌdịjó ku rĩ sĩ ãzíla ꞌbá ámvụ́ sõlépi la ꞌbã adrujó yụ rĩ sĩ, ");
INSERT INTO luc_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","wó ị̃yị́ ri agbẹ́lé vụ̃rụ̂lé ãzíla ị̃mvụ̃ dó sĩ ụ̃nọ́kụ́ drị̃ pírí. ");
INSERT INTO luc_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Úpí Ãdróŋá idé ꞌbá ũdrí ụ̃nọ́kụ́ gá rĩ sĩ, vu ãvẹ̃vị̃ sĩ adrujó ídri rĩ ũmvu la gâsĩ. ꞌBá acá dó sĩ ãko ídri trũ la rú. ");
INSERT INTO luc_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ꞌDã ꞌbã ũngúkú gá, Úpí Ãdróŋá idé ámvụ́ ị̃tụ́ ꞌbã ãfũ agâlé ru ꞌdĩ Ídẽnĩ gá, ãzíla ꞌbã dó sĩ ꞌbá ĩꞌdi ꞌbã idélé rĩ ala gá. ");
INSERT INTO luc_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Úpí Ãdróŋá fẽ ife ũví ndú-ndú ũnĩ-ambamba rĩ ꞌbaní zolé ámvụ́ agá ꞌdãá ãzíla fẽ ĩꞌbaní ífí ũnĩ-ambamba nalé nãnã rĩ kí kalé. Ámvụ̂ ꞌbã ágágá ꞌdãá ife ídri fẽlépi rĩ ãzíla ife ị́jọ́ múké rĩ kí nị̃jó ị́jọ́ ũnzí be cé rĩ cí. ");
INSERT INTO luc_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ị̃yị́ dịlépi ámvụ́ Ídẽnĩ ị̃mvụ̃lépi rĩ awa ru sụ. ");
INSERT INTO luc_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ị̃yị́ drị̃drị̃ rĩ ꞌbã rụ́ Písõnĩ ꞌi; dị ãngũ umvelé Hãvị́lã rĩ agâ sĩ pírí, ꞌdĩ ãngũ sĩ gólũdĩ ịsụ́jó rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Gólũdĩ ãngũ ꞌdã agá rĩ ãlá ru usa ru ku, ãdu ãjị́ ngụ̃lépi vĩrĩ rĩ ãzíla írã ãjẹ̃ rú únĩkĩsĩ rú rĩ kí vâ ꞌdãá cí. ");
INSERT INTO luc_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ị̃yị́ ị̃rị̃ rĩ ꞌbã rụ́ Gị́họ̃nị̃ ꞌi. Dị ãngũ Kụ́sị̃ drị̂ agâ sĩ pírí. ");
INSERT INTO luc_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ị̃yị́ na rĩ ꞌbã rụ́ Tị̃gị̃rị́sị̃ ꞌi; dị Ãsụ́rị̃yã ꞌbã wókõ ị̃tụ́ ꞌbã ãfũ agâlé ru rĩ gâsĩ. Ị̃yị́ sụ rĩ ꞌbã rụ́ Ũfũrátĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ꞌDã ꞌbã ũngúkú gá, Úpí Ãdróŋá ꞌbã ꞌbá ámvụ́ Ídẽnĩ agá sĩ ãzị́ la ngajó vâ sĩ tã la mbajó. ");
INSERT INTO luc_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Úpí Ãdróŋá azị ĩꞌdiní, “Mí icó ife ífí ámvụ́ agá ꞌdâ rĩ kí nalé pírí rá, ");
INSERT INTO luc_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","wó lẽ ína ife ífí ị́jọ́ múké rĩ kí nị̃jó ị́jọ́ ũnzí rĩ be rĩ ku. Ídrĩ na la rá, mi drã rá ãndá-ãndá ru.” ");
INSERT INTO luc_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ꞌDã ꞌbã ũngúkú gá, Úpí Ãdróŋá jọ, “Ágọ́bị̂ ní adrujó áꞌdụ̂sĩ rĩ adru múké ku, ma ĩꞌdiní ꞌbá ĩꞌdi ãzã kolépi icólépi ĩꞌdi sĩ rá rĩ ꞌbã rá.” ");
INSERT INTO luc_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ị́jọ́ ꞌdĩ sĩ Úpí Ãdróŋá ũꞌbã ãnãkpá ãzíla ãriŋa kí pírí ụ̃nọ́kụ́ sĩ, ají kí iꞌdalé Ádãmũ ní sĩ kí rụ́ ꞌdajó. Rụ́ pírí ĩꞌdi ꞌbã ꞌdalé ãko ãlu-ãlu ídri trũ rĩ ꞌbanî rĩ ace dó ĩꞌbaní rụ́ ru nĩ. ");
INSERT INTO luc_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ádãmũ ꞌda dó ãnãkpá lị́cọ́ agá rĩ kí rụ́, ãnãkpá ásé agá rĩ kí abe ãzíla ãriŋa kî trũ, wó tí ịsụ́ ꞌbá ĩꞌdi ãzã kolépi icólépi ĩꞌdi sĩ rá la ku. ");
INSERT INTO luc_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ị́jọ́ ꞌdĩ sĩ, Úpí Ãdróŋá fẽ dó Ádãmũ ꞌbe ụ́ꞌdụ́ káyĩ rá. Anzé dó sĩ ĩꞌdi ꞌbã lúmã ãlu ãzíla ụ̃pị̃ dó ãngũ la ꞌdã ĩzánáká sĩ cí. ");
INSERT INTO luc_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ꞌDã ꞌbã ũngúkú gá, Úpí Ãdróŋá idé dó ũkú lúmã ĩꞌdi ꞌbã anzélé ágọ́ꞌbị̂ rụ́ rĩ sĩ, ãzíla ají dó ĩꞌdi ágọ́bị̂ rú ꞌdõlé. ");
INSERT INTO luc_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ádãmũ jọ dó, “ꞌdĩ ĩfãkã mádrị̂ ꞌbã ãzí ãzíla ĩzá mádrị̂ ꞌbã ãzí, ála dó sĩ ĩꞌdi umve ũkú ꞌi ꞌbání ĩꞌdi anzéjó ágọ́bị́ ụrụꞌbá gá rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ị́jọ́ ꞌdĩ bã sĩ ꞌbá ꞌbã sĩ átẹ́pị̃ kí aꞌbejó ãndrẽ be, sĩ ru icíjó ũkú ĩꞌdidrị̂ be ãzíla kí dó sĩ acá ụrụꞌbá ãlu rú ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ágọ́bị̂ kí ándrá ũkû be ị̃rị̃trá pílílí ru wó kí ándrá drị̃nzâ kóru. ");
INSERT INTO luc_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ị̃nị̃ ĩꞌdi ándrá ãnãkpá úlétáŋá ambamba la ndẽ ãnãkpá Úpí Ãdróŋá ꞌbã ũꞌbãlé ásé agá rĩ kí pírí rá. Ị̃nị̃ zị ũkú ꞌi, “Ãdróŋá jọ ãndá-ãndá ru, ‘Ĩna ife ífí ámvụ́ agá ꞌdĩ ꞌbã ãzí kí ku yã’?” ");
INSERT INTO luc_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ũkû umvi ị̃nị̃ ní, “Ãma icó ife ífí ámvụ́ agá ꞌdĩ kí nalé pírí rá. ");
INSERT INTO luc_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Wó Ãdróŋá jọ lẽ ãna jõ ife ámvụ́ agá ágágá rĩ ꞌbã ífí ku, ãma aló jõ vâ ụrụꞌbá la ku, ãdrĩ na la rá, ãma ũdrã rá.” ");
INSERT INTO luc_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ị̃nị̃ jọ, “Ĩmi ũdrã ku fô. ");
INSERT INTO luc_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ãꞌdusĩku Ãdróŋá nị̃ rá ĩdrĩ na la rá ĩmi mịfị́ la ru nzị̃ rá ãzíla ĩmi adru cécé Ãdróŋâ áni sĩ ị́jọ́ ũnzí rĩ kí nị̃jó ị́jọ́ múké rĩ abe cé.” ");
INSERT INTO luc_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ũkû la mụ ndrelé la ife ífî ũniyambamba rú ãzíla múké najó la ãzíla ĩꞌdi ꞌbã lẽjó acájó ũndũwã rú rĩ sĩ, ãtĩ ífí la nalé rá ãzíla fẽ vâ ágô ní nalé ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ꞌDã ꞌbã ũngúkú gá, mịfị́ la nzị̃ kí dó ru rá ãzíla ịsụ́ kí dó ru pílílí ru. Uce kí dó úlúgó bị́ sĩ ru ụrụꞌbá atrịjó cí. ");
INSERT INTO luc_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ị̃tọ́lọŋá sĩ Ágọ́bị̂ are kí ũkû be Úpí Ãdróŋá ꞌbã acị́ agá ámvụ́ agá, ụ̃zị̃ kí dó ru ámvụ́ agá ꞌdãá ife agá. ");
INSERT INTO luc_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Wó Úpí Ãdróŋá umve ágọ́bị̂ ꞌi, “Mi íngõlé yã?” ");
INSERT INTO luc_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ágọ́bị̂ umvi, “Má are ụ́ꞌdụ́kọ́ míní sĩ acị́jó ámvụ́ agá ꞌdãá rĩ rá, má acá dó sĩ ụ̃rị̃ sĩ mání adrujó pílílí ru rĩ sĩ, ị́jọ́ ꞌdĩ sĩ, ázị̃ dó sĩ ma cí.” ");
INSERT INTO luc_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ãdróŋá zị ĩꞌdi, “Ãꞌdi jọ míní mi pílílí ru rĩ gá nĩ yã? Ína ife ífí mání jọlé úna ĩꞌdi ku rĩ rá yã?” ");
INSERT INTO luc_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ágọ́bị̂ jọ, “Ũkú míní fẽlé mání rĩ fẽ mání ife ꞌbã ífî ꞌi ána dó ĩꞌdi rá.” ");
INSERT INTO luc_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Úpí Ãdróŋá zị dó ũkû ꞌi, “Ị́jọ́ míní idélé íni rĩ ãꞌdu yã?” Ũkú umvi, “Mání jõ najó la ị̃nị̃ ulé ma nĩ.” ");
INSERT INTO luc_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Úpí Ãdróŋá jọ ị̃nị̃ ní, “Míní ị́jọ́ ꞌdĩ idéjó íni rĩ sĩ áwãtáŋá mídrị̂ ndẽ ãnãkpá lị́cọ́ gá rĩ ꞌbadrị́ ásé agá rĩ abe rĩ pírí rá. Mi ími use kụ̃bụ̃drị̃ sĩ ãzíla mi pụ́trụ́ mvũ ídri mídrị̂ agá pírí. ");
INSERT INTO luc_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ma mũkẽrẽ ꞌbã ĩmi drĩdríŋĩ gá ũkû be, ũri mídrị̂ kí drĩdríŋĩ gá ũri ũkú drị̂ kí abe, ũri ũkú drị̂ la rú ími drị̃kã gbã ãzíla ũri mídrị̂ la rú ĩꞌdi ĩníŋâ ga rá.” ");
INSERT INTO luc_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ãdróŋá jọ ũkû ní, “Ma ãzá mídrị̂ ĩjãlã drị̃ gá míní adru agá ꞌa trũ ãzíla míní ngọ́tị́ tĩ agá, ị́jọ́ míní lẽlé rĩ ꞌbã ũkpó la adru ágọ́bị́ drị́, ĩꞌdi dó sĩ adru úpí ru ími drị̃lẹ́ gá.” ");
INSERT INTO luc_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ãdróŋá jọ Ádãmũ ní, “Míní ũkú mídrị̂ tị arejó rĩ sĩ ãzíla míní ife mání ándrá jọlé ína jõ ífí la ku rĩ najó rá rĩ sĩ, áwã ụ̃nọ́kụ̂ ími ị́jọ́ sĩ rá, mi ãzị́ nga ũkpõ sĩ sĩ ãkónã ịsụ́jó ụ́ꞌdụ́ míní adrujó ídri rú rĩ kí agá pírí. ");
INSERT INTO luc_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ụ̃cị́kị́ la dụ míní ãvúkí trũ ãzíla mi dó ũri ãfũlépi ámvụ́ agá rĩ na áyụ. ");
INSERT INTO luc_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mi íná na ụ́rị́ ãfũlépi ími mẹ́lẹ́tị gá rĩ sĩ kpere míní fi agá ꞌbụ́ gá. Ími idéjó ũdrí sĩ rĩ sĩ, mi ũdrí ãzíla mi vâ gõ vúlé ũdrí gâlé.” ");
INSERT INTO luc_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ádãmũ ꞌda ũkú ĩꞌdidrị̂ rụ́ Ị́vã ꞌi ĩꞌdi ꞌbã adrujó ꞌbá pírí ídri trũ rĩ ꞌbã andre rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Úpí Ãdróŋá idé íníríkó bõngó ru sĩ Ádãmũ kí ụ̃sụ̃jó ũkû Ị́vã be. ");
INSERT INTO luc_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Úpí Ãdróŋá jọ, “ꞌBá acá kí dó ãma áni, ị́jọ́ múké rĩ kí nị̃jó ị́jọ́ ũnzí rĩ be ꞌbo, lẽ úꞌdîꞌda ꞌba aló kí dó ife ídri drị̂ drị́ sĩ ku ãzíla ꞌbã na kí ĩꞌdi ku, kí sĩ mụ uꞌálé ídri rú jãꞌdâ ku rá.” ");
INSERT INTO luc_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ị́jọ́ ꞌdĩ sĩ, Úpí Ãdróŋá dro ĩꞌdi ámvụ́ Ídẽnĩ agá rĩ sĩ ãmvé. Fẽ dó ĩꞌdiní vũ ándrá ĩꞌdi idéjó ala gá rĩ sõlé. ");
INSERT INTO luc_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ĩꞌdi mụ Ádãmũ drolé ꞌbo, ámvụ́ Ídẽnĩ ꞌbã wókõ ị̃tụ́ ꞌbã agá agâlé ru rĩ gá, ũꞌbã kẹ̃rụ́bị̃ ãngũ andre tẽlépi rĩ kí ménéŋá dị̃lépi ãcí ru bẹ̃kụ̃bẹ̃kụ̃ la trũ sĩ ife ídri drị̂ andre tẽjó. ");
INSERT INTO luc_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ꞌDã ꞌbã ũngúkú gá, Ádãmũ icí kí ru ũkû Ị́vã be, ũkû ịsụ́ dó sĩ ꞌa, tị dó sĩ Kãyị́nị̃ ꞌi, jọ, “Átị dó ꞌbá ꞌbo, Úpí ꞌbã áma ãzã kojó rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ꞌDã ꞌbã ũngúkú gá, tị vâ Hãbị́lị̃ ꞌi, ĩꞌdi ꞌbá kãbĩlõ ucélépi rĩ ꞌi, Kãyị́nị̃ ĩꞌdi ꞌbá ámvụ́ sõlépi rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ụ́ꞌdụ́ ãlu Kãyị́nị̃ ají ũri ãzí kalépi ĩꞌdidrị́ ámvụ́ agá rĩ kí ꞌbã ãzí Úpí ní ãwãꞌdĩfô rú, ");
INSERT INTO luc_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Hãbị́lị̃ ají ĩzá úsã trũ kãbĩlõ ĩꞌdidrị́ tịlé drị̃drị̃ rĩ kí agá rĩ ꞌbã ãzí fẽlé ídétáŋá ru Úpí nî, Úpí ãꞌị̃ ĩꞌdi ídétáŋá ĩꞌdidrị̂ kí abe rá. ");
INSERT INTO luc_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Wó Ãdróŋá gã Kãyị́nị̃ kí ãwãꞌdĩfô ĩꞌdidrị̂ be úmgbé. Kãyị́nị̃ ásị́ acá dó sĩ ãzá-ãzá ãzíla mịfị́ la nị dó sĩ ádrị́pị̃ ní kpákpá. ");
INSERT INTO luc_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ꞌDã ꞌbã ũngúkú gá, Úpí zị Kãyị́nị̃ ꞌi, “Ími mịfị́ nị kpákpá íni ãꞌdu sĩ yã? ");
INSERT INTO luc_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ídrĩ ị́jọ́ múké rĩ idé má icó ími ãꞌị̃lé ku yã? Wó ídri ị́jọ́ múké rĩ idé ku, ị́jọ́ ũnzí la uvá ími agá ꞌdĩ, lẽ ími izalé rá wó lẽ mí arụ́ ĩꞌdi drị̃ sĩ adrujó ĩꞌdiní úpí ru.” ");
INSERT INTO luc_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kãyị́nị̃ jọ ádrị́pị̃ Hãbị́lị̃ ní, “Ãmụ ꞌbání acị̂ trũ ámvụ́ agâlé.” Ĩꞌbã kí adru agá ámvụ́ agâlé ꞌdĩ gá ꞌdâ, Kãyị́nị̃ zõ ádrị́pị̃ drị̃ gá ãzíla ꞌdị dó sĩ ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ꞌDã ꞌbã ũngúkú gá, Úpí zị Kãyị́nị̃ ꞌi, “Mí ádrị́pị Hãbị́lị̃ dó íngõlé yã?” Kãyị́nị̃ umvi ĩꞌdiní, “Ánị̃ ku, wó ma ꞌbá mâ ádrị́pị tãmbalépi rĩ ꞌi yã?” ");
INSERT INTO luc_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Úpí jọ, “Mí idé ị́jọ́ ũnzíkãnã íni ꞌdĩ ãꞌdu ị́jọ́ sĩ? Mí ádrị́pị ꞌbã ãrí la ími tõ áma bị́lẹ́ gá angájó vụ̃rụ̂lé ꞌdã. ");
INSERT INTO luc_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Mi dó úꞌdîꞌda ꞌbá wãlé rá ãzíla drolé ãngũ drị̃ gá ꞌdâ rá ị́jọ́ vũ ꞌbã tị afujó mgbọ mî ádrị́pị ꞌbã ãrí mvụjó ími drị́ gá rĩ sĩ la. ");
INSERT INTO luc_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ídrĩ ámvụ́ sõ, icó dó míní ãkónã kalé ku, mi dó adru lị́cọ́ kóru ꞌbá acị́lépi ngara ụ̃nọ́kụ́ drị̃ gá ꞌdâ la rú.” ");
INSERT INTO luc_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kãyị́nị̃ jọ Úpí ní, “Drị̃rịma míní fẽlé mání ꞌdĩ ambamba ndẽ dó ma ꞌdụ agá rá. ");
INSERT INTO luc_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ãndrũ ídro dó ma ãngũ drị̃ gá ꞌdâ rá, má icó dó ími mẹ́lẹ́tị ndrelé ị̃dị́ ku, ma dó mụ adrulé ꞌbá lị́cọ́ kóru acị́lépi ngara ávị́ŋâ kóru ụ̃nọ́kụ́ drị̃ gá ꞌdâ la, ꞌbá cí áma ịsụ́lépi rĩ la dó áma ꞌdị rá.” ");
INSERT INTO luc_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Úpí jọ ĩꞌdiní, “Adru íni ku! ꞌBá ãzí drĩ Kãyị́nị̃ ími ꞌdị rá ma ãrígó la ũfẽ pâlé ázị̂rị̃.” Ãdróŋá ꞌbã ícétáŋá Kãyị́nị̃ ụrụꞌbá gá ꞌbá ãzí drĩ sĩ ĩꞌdi ịsụ́ rá ꞌbã ꞌdị rû sĩ ĩꞌdi ku. ");
INSERT INTO luc_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ị́jọ́ ꞌdĩ sĩ, Kãyị́nị̃ ĩdã dó ru Úpí mẹ́lẹ́tị gá ꞌdãá rá, mụ dó sĩ uꞌálé ãngũ Nọ́dị̃ gá ꞌdĩ Ídẽnĩ ꞌbã wókõ ị̃tụ́ ꞌbã ãfũ agâlé ru. ");
INSERT INTO luc_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kãyị́nị̃ icí kí ru ũkû be, ũkû ịsụ́ ꞌa tị dó sĩ ngọ́tị́ ágọ́bị́ ãzíla ꞌda dó rụ́ la Ínõkã ꞌi. Sị dó sĩ táwụ̃nị̃ ãzí ãzíla ꞌda dó sĩ rụ́ la Ínõkã ngọ́pị̃ ꞌbã rụ́ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Útị Ị̃rádị̃ Ínõkã nî, Ị̃rádị̃ tị Mẽhũyáyẽlĩ ꞌi, Mẽhũyáyẽlĩ ꞌbã ngọ́pị Mẹ̃tụ̃sãyẹ́lị̃ ꞌi, Mẹ̃tụ̃sãyẹ́lị̃ tị Lãmékĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lãmékĩ ĩgbã ũkú kí ị̃rị̃. Kãyú rĩ ꞌbã rụ́ Ádã ꞌi ãzí rĩ ꞌbã rụ́ Zílã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ádã tị ngọ́tị́ ágọ́bị́, rụ́ la Yãbálĩ ꞌi, ĩꞌdi ꞌbá ãnãkpá ucélépi hémã agá rĩ ꞌbã áyị́pị drị̃drị̃ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yãbálĩ ꞌbã ádrị́pị rụ́ Yũbálĩ ꞌi, ĩꞌdi ꞌbá drị̃drị̃ iꞌdólépi úngó ngolépi gũká sĩ ãzíla ụ̃ꞌdị́ sĩ rĩ kí ꞌbã Áyị́pị. ");
INSERT INTO luc_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zílã tị Tũbálĩ Kãyị́nị̃ ꞌi Lãmékĩ nî. Ĩꞌdi áꞌbị́ ꞌbá ãlị́gọ́ ru úká dịlépi ãko pírí sị́ cilépi idélé aya ũkpó bũrônzĩ rú la sĩ rĩ ꞌbadrị̂ ꞌi. Tũbálĩ Kãyị́nị̃ ꞌbã ámvọ́pị Námã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lãmékĩ jọ ũkúka Ádã ꞌbaní Zílã be, “Ĩmi are áma ụ́ꞌdụ́kọ́ mâ ũkúka, áꞌdị ꞌbá ĩꞌdi ꞌbã áma ĩpẽŋãjó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Údrĩ Kãyị́nị̃ ꞌbã ãvũ ãrí ũfẽ pâlé ázị̂rị̃, Lãmékĩ drị̂ ála ũfẽ la pâlé kãlị́ ázị̂rị̃ drị̃ la ázị̂rị̃.” ");
INSERT INTO luc_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ádãmũ icí kí vâ ru ũkû be, tị kí ngọ́tị́ ágọ́bị́ ãzíla ꞌda kí rụ́ la Sẹ́tị̃ ꞌi. Ífí la Ãdróŋá fẽ mání ngọ́tị́ Hãbị́lị̃ ándrá Kãyị́nị̃ ꞌbã ꞌdịlé rá rĩ ꞌbã kẹ̃jị́ gá ꞌbo. ");
INSERT INTO luc_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sẹ́tị̃ tị ngọ́tị́ ágọ́bị́ ãzíla ꞌda rụ́ la Ínõsĩ ꞌi. Iꞌdójó ụ́ꞌdụ́ ꞌdã sĩ ꞌbá iꞌdó kí Úpí rulé rũ rũ. ");
INSERT INTO luc_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ꞌDĩ ãwí sĩlé Ádãmũ drị̃ gá anzị ĩꞌdidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe rĩ drị̂ ꞌi. Ãdróŋá la mụ ꞌbá ꞌbãlé ꞌbo, ꞌbã ĩꞌdi gbíyã ĩꞌdidrị̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ꞌBã ágọ́bị́ kí ũkú be, wi sụ̃sụ́ ĩꞌbanî ãzíla umve dó kí “ꞌBá.” ");
INSERT INTO luc_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ádãmũ ílí la mụ calé 130 ꞌbo, tị ngọ́tị́ ágọ́bị́ gbíyã ĩꞌdidrị̂ sĩ ꞌda rụ́ la Sẹ́tị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ádãmũ la dó mụ Sẹ́tị̃ tịlé ꞌbo, uꞌá dó ílí 800 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ádãmũ uꞌá ãngũ drị̃ gá ꞌdâ ídri rú pírí rĩ gá ílí 930, ãzíla drã dó rá. ");
INSERT INTO luc_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sẹ́tị̃ ílí la mụ calé 105 ꞌbo, tị dó Ínõsĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Sẹ́tị̃ la dó mụ Ínõsĩ tịlé ꞌbo, uꞌá dó ílí 807 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sẹ́tị̃ uꞌá ãngũ drị̃ gá ídri rú ílí 912 ãzíla drã dó rá. ");
INSERT INTO luc_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ínõsĩ ílí la mụ calé kãlị́ úrômĩ ꞌbo, tị dó Kénãnĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ínõsĩ la dó mụ Kénãnĩ tịlé ꞌbo, uꞌá dó ílí 815 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ínõsĩ uꞌá ãngũ drị̃ gá ídri rú ílí 905 ãzíla drã dó rá. ");
INSERT INTO luc_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kénãnĩ ílí la mụ calé kãlị́ ázị̂rị̃ ꞌbo, tị dó Mãhãlãlẹ́lị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kénãnĩ la dó mụ Mãhãlãlẹ́lị̃ tịlé ꞌbo, uꞌá dó ílí 840 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kénãnĩ uꞌá ãngũ drị̃ gá ídri rú ílí 910 ãzíla drã dó rá. ");
INSERT INTO luc_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mãhãlãlẹ́lị̃ ílí la mụ calé kãlị́ ázíyá drị̃ tõwú ꞌbo, tị dó Yãrẹ́dị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mãhãlãlẹ́lị̃ la dó mụ Yãrẹ́dị̃ tịlé ꞌbo, uꞌá dó ílí 830 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mãhãlãlẹ́lị̃ uꞌá dó ãngũ drị̃ gá ídri rú ílí 895 ãzíla drã dó rá. ");
INSERT INTO luc_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yãrẹ́dị̃ ílí la mụ calé 162 ꞌbo, tị dó Ínõkã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yãrẹ́dị̃ la dó mụ Ínõkã tịlé ꞌbo, uꞌá dó ílí 800 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yãrẹ́dị̃ uꞌá dó ãngũ drị̃ gá ídri rú ílí 962 ãzíla drã dó rá. ");
INSERT INTO luc_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ínõkã la dó mụ calé ílí trũ kãlị́ ázíyá drị̃ tõwú ꞌbo, tị dó Mẽtũsélã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Mẽtũsélã átẹ́pị Ínõkã ri tị icílé Ãdróŋá be ãrútáŋá sĩ ílí 300, tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ínõkã uꞌá ílí trũ 365. ");
INSERT INTO luc_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ínõkã ri tị icílé Ãdróŋá be ãzíla Ãdróŋá ꞌdụ dó sĩ ĩꞌdi ꞌbụ̃ gâlé ídri rú, ị́jọ́ ꞌdĩ sĩ ãvĩ dó rá. ");
INSERT INTO luc_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mẽtũsélã ílí la mụ calé 187 ꞌbo, tị dó Lãmékĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Mẽtũsélã la dó mụ Lãmékĩ tịlé ꞌbo, uꞌá dó ílí 782 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mẽtũsélã uꞌá dó ãngũ drị̃ gá ídri rú ílí 969 ãzíla drã dó rá. ");
INSERT INTO luc_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lãmékĩ la dó mụ calé ílí trũ 182 ꞌbo, tị dó ngọ́tị́ ágọ́bị́. ");
INSERT INTO luc_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ꞌDa rụ́ la Núwã ꞌi ífí la ĩꞌdi rú ãma ásị́ ũŋmĩ ãzị́ ngalé ũkpó sĩ ụ̃nọ́kụ́ Úpí ꞌbã wãlé rá ꞌdĩ drị̃ gá ꞌdâ. ");
INSERT INTO luc_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lãmékĩ uꞌá ídri rú ílí 595 ĩꞌdi ꞌbã Núwã tịjó ꞌbo rĩ ꞌbã vúlé gá ãzíla tị dó anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lãmékĩ uꞌá ídri rú ílí 777 ãzíla drã dó rá. ");
INSERT INTO luc_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Núwã ꞌbã ílí la dó mụ calé 500 ꞌbo, tị dó anzị ãgọbị kí na Sẹ́mị̃ ꞌi, Hámũ ꞌi ãzíla Yáfẽtĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ꞌBá kí dó mụ kpẹ̃lé ãngũ drị̃ gá ꞌdâ wẽwẽ rú ꞌbo, tị kí dó izonzi kî. ");
INSERT INTO luc_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Anzị Ãdróŋá drị̂ ndre kí izonzi ꞌbá drị̂ kí ũniyambamba rú ụꞌdụ kí dó kí ĩꞌbaní ũkú ru. ");
INSERT INTO luc_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ꞌDã ꞌbã ũngúkú gá, Úpí jọ, “Úríndí mádrị̂ icó uꞌálé ꞌbá kí abe jãꞌdâ ku, ĩꞌbã kí adrujó ꞌbá ụrụꞌbá ãrí trũ rĩ kí rĩ sĩ. Iꞌdójó úꞌdîꞌda kpere drị̃lẹ́ gâlé, icó kí uꞌálé ílí 120 drị̃lẹ́ gá ku.” ");
INSERT INTO luc_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ꞌBá Néfĩlĩmũ rú rĩ kí ándrá ụ́ꞌdụ́ ꞌdã sĩ ụ̃nọ́kụ́ drị̃ gá ꞌdâ cí, ãzíla ꞌdã ꞌbã ũngúkú gá anzị Ãdróŋá drị̂ ụꞌdụ kí izonzi ꞌbá ꞌbadrị̂ kí sĩ anzị ụtịjó. ꞌBá ꞌdã kí ándrá ꞌbá ũkpó ru rụ́ kụlépi kụ̃kụ̃ ãzíla kẹ́jẹ́ŋị́ la kî. ");
INSERT INTO luc_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Úpí ndre ꞌbá acá kí dó ụ̃nọ́kụ́ drị̃ gá ꞌdâ ꞌbá ũnzí la rú ãzíla ũrãtáŋá ĩꞌbadrị́ kí ásị́ gá rĩ kí vâ sáwã pírí sĩ ũnzí-ũnzí. ");
INSERT INTO luc_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Úpí ásị́ nũ dó rá ãzíla jọ, “ꞌBá rĩ áꞌbã ájẹ mání ꞌbá kí ụ̃nọ́kụ́ drị̃ gá ꞌdâ ku yã áni!” Ũcõgõ fi dó ásị́ la gá. ");
INSERT INTO luc_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ị́jọ́ ꞌdĩ sĩ Úpí jọ, “Ma ãko mání ũꞌbãlé ꞌbá, ãnãkpá, ãriŋa ãzíla ãnãkpá ãgãlépi vũ rụ̂ sĩ rĩ kí ị̃lị̃kị̃ pírí ụ̃nọ́kụ́ drị̃ gá ꞌdâ rá, ãꞌdusĩku ma cãndí sĩ mání kí ũꞌbãjó rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Wó Úpí uꞌá ꞌbãngá lú ãyĩkõ sĩ la Núwã ꞌbã ị́jọ́ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ꞌDĩ ãwí Núwã drị̂ ꞌi. Núwã ándrá ꞌbá mgbã la, ꞌbã ándrá ásị́ ị́jọ́ Ãdróŋá drị̂ ꞌbã drị̃ gá ãzíla ri ị́jọ́ Ãdróŋá drị̂ kí vú ũbĩlé rá. ");
INSERT INTO luc_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Núwã ꞌbã anzị kí ándrá na: Sẹ́mị̃ ꞌi, Hámũ ꞌi ãzíla Yáfẽtĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ꞌBá ụ̃nọ́kụ́ gá rĩ iza kí ándrá ru Ãdróŋâ mẹ́lẹ́tị gá ũnzíríkãnã rú ãzíla ga kí dó tré ãlí sĩ. ");
INSERT INTO luc_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ãdróŋá ndre ꞌbá ru izalépi ụ̃nọ́kụ́ drị̃ gá ꞌdâ ꞌdĩ kí ũmbã rú ãzíla gbíyã ĩꞌbã kí sĩ ꞌbá kí ũnzãjó rĩ wókõ pírí agá. ");
INSERT INTO luc_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ãdróŋá jọ Núwã ní, “Má umbé áma ásị́ ꞌbo, ma ꞌbá ụ̃nọ́kụ́ drị̃ gá ꞌdĩ kí ị̃lị̃kị̃ pírí, ụ̃nọ́kụ́ ꞌbã gajó tré ãlí ãzíla ununuŋá ĩꞌbadrị̂ sĩ rĩ sĩ, ma ụ̃nọ́kụ̂ ị̃lị̃kị̃ ꞌbá ụrụꞌbá ãrí trũ rĩ abe rá, ụ́ꞌdụ́ ĩꞌbadrị́ ãsị̃jó rĩ acá dó ꞌbo. ");
INSERT INTO luc_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ị́jọ́ ꞌdĩ sĩ, mí idé íꞌbó ãmbógó la báwũ múké ị̃yị́ ꞌbã fijó ala gá ku la sĩ, mí ụlị́ ala ndú-ndú, mí ĩbĩ ụrụꞌbá la ꞌa la trũ ísékísé sĩ. ");
INSERT INTO luc_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Mí idé íꞌbô ꞌdĩ áni, ãzo la ꞌbã adru mítã 133, mgbọ la ꞌbã adru mítã kãlị́ ị̃rị̃ drị̃ ị̃rị̃, ãzo la lótré gâlé rĩ ꞌbã adru mítã mụdrị́ drị̃ na. ");
INSERT INTO luc_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ísị ãngũ mgbọ ãni rú nụ́sụ̃ mítã la lótré drị̃ gá ꞌdâ dị̃zã ní sĩ ãngũ jijó íꞌbó agâlé, mí idé ĩꞌdi gõrófã na, ílũ kẹ̃jị́ la bụ́lụ́ la gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Índre ma ãni rú mụ uzogó ãngũ nzelépi ị̃ndụ́ trũ rĩ fẽlé ꞌdịlé gajó mĩlĩ-mĩlĩ ãko ídri trũ rĩ kí ị̃lị̃kị̃jó ụ̃nọ́kụ́ drị̃ gá ꞌdâ pírí. ");
INSERT INTO luc_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Wó ma mụ tị icíma icílé mí be, ĩmi fi íꞌbó agâlé ũkú mídrị̂ be, anzị mídrị̂ kî trũ ãzíla ũkúka ĩꞌbadrị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Mí aꞌdụ́ ãnãkpá ũví pírí ị̃rị̃-ị̃rị̃ ágó rĩ kí ãrónĩ rĩ kí abe íꞌbó ãmbógó ꞌdĩ agá ꞌdõlé sĩ kí tã mbajó ídri rú ị̃yị́ ãmbógó ãngũ nzelépi ị̃ndụ̂ trũ ꞌdĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ãriŋa ũví ndú-ndú ꞌdĩ kí pírí ị̃rị̃-ị̃rị̃ ágó rĩ kí ãrónĩ rĩ be, ãzíla ãnãkpá ũví ndú-ndú ꞌdĩ kí pírí ãmbogo ãzíla nírí rĩ kî trũ ꞌdĩ ꞌbã áni, kí amụ́ mí rụ́ ꞌdõlé sĩ adrujó ídri. ");
INSERT INTO luc_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Lẽ íꞌdụ ãkónã ũví ndú-ndú rĩ kí míní ꞌbá mí drị́ko gá rĩ kí abe ãzíla íꞌdụ vâ ãnãkpá pírí ꞌbanî ĩndĩ.” ");
INSERT INTO luc_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Núwã idé dó ị́jọ́ kí cécé Ãdróŋá ꞌbã azịlé ĩꞌdiní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Núwã ní, “Ífi íꞌbó ãmbógó rĩ agâlé ꞌbá mí drị́ko gá rĩ kî abe, ãꞌdusĩku má ịsụ́ mi ꞌbá mgbã la ꞌbá áyi úꞌdîꞌda ꞌdĩ agá rĩ kí drĩdríŋĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Íꞌdụ ãnãkpá ũví ndú ndú ágó ãzíla ãrónĩ ãlá nalé nãnã rĩ kí ázị̂rị̃-ázị̂rị̃. Íꞌdụ vâ ãnãkpá ũví ndú ndú ágó ãzíla ãrónĩ ãlã kóru rĩ kí ị̃rị̃-ị̃rị̃, ");
INSERT INTO luc_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ãzíla ãriŋa ũví ndú-ndú ágó ãzíla ãrónĩ rĩ kí ázị̂rị̃-ázị̂rị̃ sĩ kí tãmbajó ídri rú ụ̃nọ́kụ́ drị̃ gá ꞌdâ sĩ amụ́jó kí ũri ị̃drị̃jó. ");
INSERT INTO luc_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ace ụ́ꞌdụ́ ázị̂rị̃ mání sĩ uzogó fẽjó ꞌdịjó ụ́ꞌdụ́ kãlị́ sụ ị́nị́ kí ị̃tụ́ be, ma sĩ ãko ụ̃nọ́kụ́ drị̃ gá ꞌdâ ídri trũ mání ũꞌbãlé rĩ kí ị̃lị̃kị̃ pírí.” ");
INSERT INTO luc_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ị́jọ́ ꞌdĩ sĩ Núwã idé ị́jọ́ Úpí ꞌbã jọlé ĩꞌdiní rĩ kí pírí. ");
INSERT INTO luc_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Sáwã uzogó ꞌbã ꞌdịjó ꞌdã sĩ Núwã ꞌbã ílí dó ꞌdĩ sĩ 600. ");
INSERT INTO luc_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Núwã fi kí dó íꞌbó agá ũkû be, anzị kí abe, ãzíla anzị ꞌbã ũkúka kí abe sĩ ru pajó uzogó ãmbógó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ãnãkpá ãzíla ãriŋa ãlá rĩ kí ãlá ru ku rĩ kí abe amụ́ kí dó ĩꞌdi rụ́ íꞌbó agá ꞌdõlé ị̃rị̃-ị̃rị̃ ágó rĩ kí ãrónĩ rĩ be, ãnãkpá ãgãlépi vũ rụ̂ sĩ rĩ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Afí kí dó Núwã rụ́ íꞌbó agá ꞌdõlé ágó rĩ kí ãrónĩ rĩ abe Ãdróŋá ꞌbã jọlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ụ́ꞌdụ́ ázị̂rị̃ ꞌbã ũngúkú gá uzogó iꞌdó dó ꞌdịlé ụ̃nọ́kụ́ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Núwã ꞌbã ílí la dó mụ calé 600 ꞌbo, ĩmbá ụ́ꞌdụ́ mụdrị́ drị̃ ázị̂rị̃ ĩmbá ị̃rị̃ drị̂ sĩ ị̃yị́ ãkpẹ̃ dó vũ ị̃ndụ́ gâlé ãzíla únzị̃ dó dẹ̃rị́sã uzogó drị́ ꞌbụ̃ gâlé rĩ kí tị mgbọ. ");
INSERT INTO luc_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ị́jọ́ ꞌdĩ sĩ, uzogó ꞌdị dó sĩ ụ́ꞌdụ́ kãlị́ sụ ãzíla ị́nị́ kãlị́ sụ. ");
INSERT INTO luc_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ụ́ꞌdụ́ ãlu uzogó ꞌbã iꞌdójó ꞌdịjó ꞌdã ꞌbã vúŋá sĩ, Núwã fi kí dó íꞌbó ꞌdã agâlé ũkû be ãzíla ngọ́pịka na Sẹ́mị̃, Hámũ, ãzíla Yáfẽtĩ ꞌi ãzíla ngọ́pịka ꞌbã ũkúka kí abe. ");
INSERT INTO luc_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ãko filépi ĩꞌba abe ĩndĩ rĩ kí ãnãkpá ũví ndú-ndú tãmbalé lị́cọ́ gá ãzíla ásé agá rĩ kî, ãko ru uselépi kụ̃bụ̃drị̃ sĩ vũ rụ̂ sĩ rĩ kí ũví ĩꞌbadrị̂ sĩ ãzíla ãriŋa pírí ũví ndú-ndú ꞌdĩ kí ãko pírí ụ́pụ́pị́ trũ ꞌdĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ãko ágó ãzíla ãrónĩ ídri trũ ꞌdĩ fi kí dó íꞌbó agâlé Núwã trũ. ");
INSERT INTO luc_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ãnãkpá pírí ídri trũ ũví ndú-ndú ágó rĩ kí ãrónĩ rĩ abe fi kí dó íꞌbó agâlé cécé Ãdróŋá ꞌbã ãzị́táŋá la fẽjó Núwã ní rĩ áni. ꞌDã ꞌbã ũngúkú gá, Úpí ụ̃pị̃ dó íꞌbô tị cí. ");
INSERT INTO luc_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Uzogó ꞌdị ụ́ꞌdụ́ kãlị́ sụ pá tuŋâ kóru, ị̃yị́ tị̃ dó ãzíla iti dó ụ̃nọ́kụ́ drị̃ rá inga dó íꞌbô ꞌi, íꞌbô atụ́ dó ị̃yị́ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ị̃yị́ ꞌbã tụ agá ụrụgá ụrụgá ꞌdĩ gá ꞌdâ íꞌbô atụ́ dó ị̃yị́ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Uzogó ꞌbã ãmbõgõ sĩ ị̃yị́ iti ꞌbé ãmbogo ãzombílíkoko rĩ kí drị̃ mĩlĩ-mĩlĩ. ");
INSERT INTO luc_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Iti ꞌbé kí drị̃ kpere ĩꞌbã kí ꞌde agá mgbi mítã ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ãko pírí ídri trũ ãngũ drị̃ gá ꞌdâ rĩ ũdrã kí dó pírí rá; ãnãkpá kí, ãriŋa kí, ãzíla ꞌbá kí abe ịmvụ́ kí dó sĩ ị̃yị́ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ãko pírí uꞌálépi ídri ãngũ ãꞌí drị̃ gá ũlí sĩ rĩ ị̃lị̃kị̃ kí pírí. ");
INSERT INTO luc_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Úpí ị̃lị̃kị̃ dó ãko ụ̃nọ́kụ́ drị̃ gá rĩ kí pírí; ꞌbá kí, ãnãkpá kí, ãnãkpá ãgãlépi vũ rụ̂ sĩ ãzíla ãriŋa kí abe pírí. Núwã pa kí lú ru ꞌbá ãzíla ãnãkpá ĩꞌdi abe íꞌbó agá rĩ kî trũ nĩ áꞌdụ̂sĩ. ");
INSERT INTO luc_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ị̃yị́ tị̃lépi ꞌdã uꞌá ụ́ꞌdụ́ 150. ");
INSERT INTO luc_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ãdróŋá ũrã dó ị́jọ́ Núwã drị̃ gá ãzíla ãnãkpá ásé agá ãzíla lị́cọ́ agá uꞌálépi ĩꞌdi be íꞌbó ãmbógó rĩ agá rĩ kí drị̃ gá, ãpẽ dô sĩ ãlụ́kụ́kụ̃ tị ị̃yị́ ãmbógó tị̃lépi rĩ ní sĩ ru umvijó. ");
INSERT INTO luc_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ãdróŋá ụ̃pị̃ dó ị̃yị́ agbẹ́lépi vụ̃rụ̂lé ãzíla aꞌdélépi ꞌbụ̃ gâlé rĩ kí tị ãzíla uzogó tu dó pá ꞌdịŋá gá cí. ");
INSERT INTO luc_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ị̃yị́ tị̃lépi vũ drị̃ gá rĩ nzụ dó jãjãŋá ru vụ̃rụ̂lé ụ́ꞌdụ́ 150. ");
INSERT INTO luc_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ĩmbá ázị̂rị̃ rĩ ꞌbã ụ́ꞌdụ́ mụdrị́ drị̃ ázị̂rị̃ rĩ sĩ íꞌbô amụ́ dó rilé ꞌbé Ãrãrátĩ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ị̃yị̂ ri nzụlé íni kpere ĩmbá mụdrị́ sĩ ãzíla ĩmbá mụdrị́ ꞌbã ụ́ꞌdụ́ ãlu sĩ ꞌbé ãzí ri kí drị̃ iꞌdó kí dó indrélé rá. ");
INSERT INTO luc_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ụ́ꞌdụ́ kãlị́ sụ vúlé gá Núwã nzị̃ dó dẹ̃rị́sã íꞌbó ĩꞌdi ꞌbã idélé rĩ drị̂, ");
INSERT INTO luc_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ãzíla pẽ dó kúrúke tị ãmvêlé ala gâsĩ ãzíla kúrúke ri ungalé ándrá ụ́rụ́ kpere ị̃yị́ ꞌbã nzụ agá ụ̃nọ́kụ́ drị̃ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ꞌDã ꞌbã ũngúkú gá, pẽ vâ ãlĩꞌbõ tị amájó la ị̃yị̂ nzụ vũ drị̃ gá ꞌdãá rá yã rĩ. ");
INSERT INTO luc_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Wó ãlĩꞌbõ ịsụ́ ãngũ sĩ rijó la ku ị̃yị́ ꞌbã ụ̃nọ́kụ̂ drị̃ ꞌbejó cí rĩ sĩ, angá dó vúlé Núwã rụ́ íꞌbó agá ꞌdõlé, Núwã ĩjũ dó sĩ ru drị́ ĩꞌdi aꞌị́jó íꞌbó agâlé. ");
INSERT INTO luc_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Tẽ vâ ụ́ꞌdụ́ ãzí kí ázị̂rị̃ ị̃dị́ ãzíla pẽ ãlĩꞌbõ tị ãmvé angájó íꞌbó agâlé. ");
INSERT INTO luc_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ãlĩꞌbõ ãgõ dó ĩndróloŋá sĩ ĩꞌdi rụ́ ꞌdõlé ãzíla ãtĩ dó mị̃zẹ̃yị́tụ̃ bị́ ãráŋá la ajílé ĩndĩ. Núwã nị̃ dó ị̃yị̂ nzụ dó vũ drị̃ gâlé ꞌbo rĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tẽ ụ́ꞌdụ́ ãzí kí ázị̂rị̃ ãzíla pẽ vâ ãlĩꞌbõ tị ãmvêlé ị̃dị́, wó ãlĩꞌbõ gõ dó vúlé ku. ");
INSERT INTO luc_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Núwã ꞌbã ílí la dó mụ calé 601 ꞌbo, ĩmbá ãlu ꞌbã ụ́ꞌdụ́ ãlu sĩ Núwã nzị̃ dó íꞌbô ꞌbã dẹ̃rị́sã, ndre dó ãngũ drị̃ ꞌi rá ãzíla ị̃yị̂ nzụ dó rá. ");
INSERT INTO luc_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ĩmbá ị̃rị̃ rĩ ꞌbã ụ́ꞌdụ́ kãlị́ ị̃rị̃ drị̃ ázị̂rị̃ sĩ, ụ̃nọ́kụ̂ drị̃ ꞌi dó ãꞌí ru. ");
INSERT INTO luc_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ãdróŋá jọ dó Núwã nî, ");
INSERT INTO luc_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Mí ãfũ dó íꞌbó agâlé rĩ sĩ ãmvé, mi ũkú mídrị̂ be ãzíla anzị kí ũkúka ĩꞌbadrị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Mí iyá ãko filépi mí be ídri rĩ kí pírí ãmvé, ãnãkpá kí, ãriŋa kí ãzíla ãnãkpá ãgãlépi vũ rụ̂ sĩ rĩ kí, ꞌba amụ́ kî sĩ tịlé ãzíla ꞌbã kpẹ̃ kí sĩ wẽwẽ rú ụ̃nọ́kụ́ drị̃ gá ꞌdâ pírí.” ");
INSERT INTO luc_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ị́jọ́ ꞌdĩ sĩ Núwã ãfũ kí dó ũkû be, ngọ́pịka kî trũ, ãzíla ngọ́pịka kí ꞌbã ũkúka kî trũ ãmvé. ");
INSERT INTO luc_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ãnãkpá pírí kí, ãnãkpá ãgãlépi vũ rụ̂ sĩ rĩ kí pírí, ãriŋa pírí kí ãzíla ãko pírí acị́lépi vũ drị̃ gá ꞌdâ rĩ kí abe ãfũ kí dó íꞌbó agâlé ũví ĩꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Núwã sị dó sĩ ãlĩtárĩ ídétáŋá idéjó rĩ Úpí nî, aꞌdụ́ dó ãnãkpá pírí ũví ndú-ndú ãlá rĩ kí ãzí ãzíla ãriŋa ãlá rĩ kí abe, sĩ ídétáŋá ivélé ivê rĩ idéjó. ");
INSERT INTO luc_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Úpí uꞌá dó ãyĩkõ sĩ ídétáŋá idélé ꞌdã sĩ ãzíla ũrã dó ĩꞌdi ásị́ gâlé cénĩ-cénĩ rú jọ, “Má icó dó ụ̃nọ́kụ̂ wãlé ꞌbá ꞌbá ru rĩ ꞌbã ị́jọ́ sĩ ị̃dị́ ku, ꞌbá ꞌbá ru ꞌdĩ ꞌbã ásị́ drĩ táni adru ũnzí iꞌdójó ãnzị̃rị̃ŋã sĩ má icó dó ãko ídri trũ ꞌdĩ kí ị̃lị̃kị̃lé cécé mání idélé ꞌdĩ áni ku. ");
INSERT INTO luc_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Ụ̃nọ́kụ́ ꞌbã adrujó cí rĩ áni, áyi ãná kpẹ̃jó rĩ kí ãná lãjó rĩ be, ị̃gbẹ̃ kí ãngũ ãcí be, ílí kí áyi be, ị̃tụ́ kí ị́nị́ be, icó kí ukólé ku.” ");
INSERT INTO luc_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá wi sụ̃sụ́ Núwã ꞌbaní ngọ́pịka abe ãzíla jọ, “Ĩtị ãzíla ĩkpẹ̃ wẽwẽ rú, ĩga ụ̃nọ́kụ́ drị̃ gá ꞌdâ tré. ");
INSERT INTO luc_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ãnãkpá pírí ụ̃nọ́kụ́ drị̃ gá ꞌdâ ãmbogo ãzíla nírí rĩ kí ãriŋa ꞌbụ̃ gá rĩ kî, Ị̃ꞌbị ị̃yị́ agá rĩ kî trũ ãzíla ãko pírí acị́lépi vũ drị̃ gâsĩ rĩ kí abe kí idé ĩmi sĩ ụ̃rị̃ sĩ ãꞌdusĩku áfẽ ũkpõ ĩꞌbadrị̂ kí ĩmi drị́lẹ́ agá. ");
INSERT INTO luc_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Áfẽ ĩminí ãko pírí ídri trũ acị́lépi acị̂ rĩ kí ãkónã rú cécé mání ĩminí ãko dụlépi vũ drị̃ gá ꞌdĩ kí fẽlé ãkónã rú rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Wó lẽ ĩna ĩzá ãrí trũ mũtú ku, ídri ꞌbã adrujó ꞌa la gá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Má uga ꞌbá ꞌdịŋá úmgbé, ꞌbá drĩ ꞌbá ꞌdị ála ĩꞌdi ꞌdị kẹ̃jị́ la gá. Ãnãkpá ꞌbá ꞌdịlépi rĩ lẽ úꞌdị ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ꞌBá ãzí drĩ ꞌbá ãzí ãrí asu rá, lẽ âsu vâ ãrí ĩꞌdidrị̂ rá ãꞌdusĩku Ãdróŋá idé ꞌbá gbíyã ĩꞌdidrị̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Lẽ ĩtị anzị kí ũꞌbí ru, ĩmi ĩjãlã sĩ ĩmi wẽwẽ rú ãzíla ĩmi iré sĩ ãngũ drị̃ gá ꞌdâ pírí.” ");
INSERT INTO luc_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ãdróŋá jọ Núwã ní anzị ĩꞌdidrị̂ kí abe, ");
INSERT INTO luc_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ma tị icíma icí mí be ãzíla anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ãzíla ãko ándrá ídri filépi mí be íꞌbó agá rĩ kí: ãriŋa kí, ãnãkpá lị́cọ́ gá rĩ kí ãzíla ásé agá rĩ kí ãko ídri vũ drị̃ gá ꞌdâ rĩ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ma tị icíma icí mi be: má icó ãko ídri trũ rĩ kí ị̃lị̃kị̃lé ị̃yị́ tị̃lépi rĩ sĩ ị̃dị́ ku, ị̃yị́ icó dó sĩ ụ̃nọ́kụ̂ izalé ị̃dị́ ku.” ");
INSERT INTO luc_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ, “Ị́jọ́ iꞌdalépi la ícétáŋá ru tị icíma ãma drĩdríŋĩ gá ꞌdâ mí be ãzíla ãko ídri trũ adrulépi ĩmi abe mání ꞌbãlé ĩmi abe pírí rĩ ꞌbã ícétáŋá jãꞌdâ rĩ gápi ꞌdĩ, ");
INSERT INTO luc_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","áꞌbã gẹ́rị́ ụ̃rụ́ꞌbụ̃ agá. Ĩꞌdi ícétáŋá mání tị icíma drị́ ukólépi ku rĩ azịjó míní ãko ídri trũ rĩ kí abe pírí ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ. ");
INSERT INTO luc_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ádrĩ ụ̃rụ́ꞌbụ̃ tị ãpẽ ụ̃nọ́kụ́ drị̃ gá ꞌdâ gẹ́rị́ drĩ ru ala ụ̃rụ́ꞌbụ̃ gá cí, ");
INSERT INTO luc_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ma tị icíma ãmadrị́ mí be ãzíla ãko pírí ídri trũ rĩ abe rĩ ꞌbã ị́jọ́ ũrã rá. Tánĩ-tánĩ ãko pírí ídri trũ la ãzí icô dó ị̃lị̃kị̃lé ị̃yị́ tị̃lépi ꞌdã ꞌbã áni rĩ sĩ ị̃dị́ ku. ");
INSERT INTO luc_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ádrĩ dó gẹ́rị́ ndre ụ̃rụ́ꞌbụ̃ gá ꞌdãá, ma tị icíma ãmadrị́ mí be ãzíla ãko pírí ídri trũ rĩ abe jãꞌdâ rĩ ꞌbã ị́jọ́ ũrã.” ");
INSERT INTO luc_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ị́jọ́ ꞌdĩ sĩ Ãdróŋá jọ Núwã ní, “ꞌdĩ ícétáŋá tị icíma ãni mání ꞌbãlé ãma drĩdríŋĩ gá ãko pírí ídri trũ ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ kí abe rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Anzị Núwã drị́ ãfũlépi íꞌbó agâlé rĩ kí: Sẹ́mị̃ ꞌi, Hámũ ꞌi ãzíla Yáfẽtĩ ꞌi. (ꞌBá Kãnánĩ rú rĩ ꞌbã átẹ́pị gápi umvelé Hámũ ꞌi ꞌdĩ.) ");
INSERT INTO luc_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Anzị Núwã drị́ na ꞌdĩ kí dó bãsĩ áꞌbị́ ꞌbá pírí irélépi ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ ꞌbadrị̂ kî. ");
INSERT INTO luc_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Núwã ándrá ꞌbá ámvụ́ sõlépi la, ãzíla ĩꞌdi vâ ꞌbá ámvụ́ zãbíbũ drị̂ salépi drị̃drị̃ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ĩꞌdi mụ sụ́ la mvụlé ꞌbo, ĩmẽrã dó rá, ãzíla la dó ru pílílí ru ĩꞌdidrị́ jó agâlé. ");
INSERT INTO luc_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hámũ Kãnánĩ átẹ́pị la mụ átẹ́pị̃ Núwã ꞌbã pílílí ndrelé ꞌbo, fũ ãmvêlé sĩ vú la nzejó ádrị́pịka ị̃rị̃ ꞌdã ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Wó Sẹ́mị̃ kí Yáfẽtĩ be aꞌdụ́ kí bõngó, ꞌbe kí ĩꞌdi kí kọ́trọ́ gá ãzíla fi kí dó ũngúkú-ũngúkú ru jó agâlé. Ajá kí tị ãmvé ꞌdõlé ru ĩꞌbaní sĩ átẹ́pị̃ ꞌbã pílílí ndrejó ku, ꞌbe kí dó sĩ pílílí la drị̃ cí. ");
INSERT INTO luc_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Núwã la mụ angálé ụ́ꞌdụ́ ĩꞌdi ꞌbã ĩmẽrãjó wáyĩnĩ sĩ rĩ gâlé ꞌbo, nị̃ dó ị́jọ́ ngọ́pị̃ wereŋá rĩ ꞌbã idélé ĩꞌdi rụ́ rĩ rá. ");
INSERT INTO luc_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Jọ dó, “Áwã Kãnánĩ rá, ꞌbã adru dó ãtíꞌbó ru ádrị́pịka kí pálé gá.” ");
INSERT INTO luc_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Jọ vâ, “Ị́cụ́ Úpí Ãdróŋá Sẹ́mị̃ drị̂ ịcụ́-ịcụ̂, lẽ Kãnánĩ ꞌbã adru ãtíꞌbó ru Sẹ́mị̃ pálé gá. ");
INSERT INTO luc_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Lẽ Ãdróŋá ꞌbã fẽ ãngũ Yáfẽtĩ drị̂ ꞌbã adru mgbọ rú, ꞌba uꞌá kí Sẹ́mị̃ be ádrị́pị ãzí ru, Kãnánĩ ꞌbã adru ĩꞌbã ãtíꞌbó ru.” ");
INSERT INTO luc_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Núwã uꞌá dó ílí 350 ị̃yị́ tị̃lépi ãmbógó ꞌdã ꞌbã ũngúkú gá. ");
INSERT INTO luc_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Núwã uꞌá dó sĩ pírí rĩ gá ílí 950 drã dó sĩ ĩndõ. ");
INSERT INTO luc_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ꞌDĩ ãwí anzị Núwã drị́ Sẹ́mị̃, Hámũ ãzíla Yáfẽtĩ ꞌbã kí tịlé ị̃yị́ tị̃lépi ꞌbá kí ị̃lị̃kị̃lépi rĩ ꞌbã vúlé gá rĩ ꞌbadrị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Anzị Yáfẽtĩ drị̂ kí: Gómã ꞌi, Mãgọ́gị̃ ꞌi, Mãdáyĩ ꞌi, Yãvánĩ ꞌi, Tũbálĩ ꞌi, Mẹ̃sẹ́kị̃ ꞌi ãzíla Tĩrásĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Anzị Gómã drị̂ kí: Ãsĩkẽnázĩ ꞌi, Rĩfátĩ ꞌi ãzíla Tõgõrámã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Anzị Yãvánĩ drị̂ kí: Ĩlísã ꞌi, Tãrãsị́sị̃ ꞌi, Kĩtímũ ꞌi ãzíla Rõdõmínĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ꞌDĩ kí ꞌbá uꞌálépi ị̃yị́ tị gá ãzíla ãngũ ru ụlị́lépi ị̃yị́ agá rĩ agá rĩ kî, awa kí ru sụ́rụ́ ĩꞌbadrị̂ kí vú sĩ ãzíla kí vâ pírí tị ndú-ndú jọ. ");
INSERT INTO luc_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Anzị Hámũ drị̂ kí: Kụ́sị̃ ꞌi, Mị̃zị̃rãyị́mụ̃ ꞌi, Pụ́tị̃ ꞌi ãzíla Kãnánĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Anzị Kụ́sị̃ drị̂ kí: Sébã ꞌi, Hãvị́lã ꞌi, Sãbị́tã ꞌi, Rãmáhã ꞌi ãzíla Sãbị̃tẹ́kã ꞌi. Anzị Rãmáhã drị̂ kí: Sébã kí Dẽdánĩ be. ");
INSERT INTO luc_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kụ́sị̃ tị Nị̃mụ̃rọ́dị̃ ꞌi, ndẽ ándrá ãgọ̃bị̃ sĩ ụ̃nọ́kụ́ drị̃ gá ꞌdâ nĩ. ");
INSERT INTO luc_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ĩꞌdi ándrá ágọ́bị́ dora gbẹlépi la Úpí drị̃lẹ́ gá, ị́jọ́ ꞌdĩ bãsĩ ꞌbá ꞌbã kí ándrá sĩ jọjó la, “Úpí ꞌbã idé tá míní mi ágọ́bị́ Nị̃mụ̃rọ́dị̃ ụ́sụ gbẹlépi ambamba rĩ áni la ĩꞌdi tá adru agá múké ꞌdĩ.” ");
INSERT INTO luc_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ãngũ ĩꞌdidrị́ ũpĩ najó rĩ ándrá Bãbụ̃lọ́nị̃ gá, táwụ̃nị̃ la ala gá rĩ kí ándrá Ị̃rẹ́kị̃ ꞌi, Ãkádĩ ꞌi ãzíla Kãlĩnéhĩ ꞌi. ꞌDĩ kí ãngũ Sínã gá. ");
INSERT INTO luc_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Angájó ãngũ ꞌdã gá mụ dó kpere Ãsụ́rị̃yã gá, sị dó sĩ Nị̃nẹ́vẹ̃ ꞌi Rẹ̃họ̃bọ́tị̃ ꞌi, Ị́rị̃ ꞌi, Kálã ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ãzíla Rẹ̃sẹ́nị̃ ꞌi drĩdríŋĩ Nị̃nẹ́vẹ̃ ꞌbadrị́ Kálã be rĩ gá, ĩꞌdi ándrá táwụ̃nị̃ ãmbógó la. ");
INSERT INTO luc_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mị̃zị̃rãyị́mụ̃ ꞌbã anzị kí: ꞌBá Lụ̃dị́mụ̃ rú ꞌdĩ kí, Ãnãmímũ rú ꞌdĩ kí, Lẽhãbímũ rú ꞌdĩ kí, Nãfụ̃tụ̃hị́mụ̃ rú ꞌdĩ kí, ");
INSERT INTO luc_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pãtụ̃rụ̃sị́mụ̃ rú ꞌdĩ kí, Kãsụ̃lụ̃hị́mụ̃ rú ꞌdĩ kí (ꞌbá Fị̃lị̃sị̃tị́nị̃ rú) rĩ ꞌbã kí ãfũjó ala gá ꞌbá Kãfụ̃tọ̃rị́mụ̃ rú rĩ kí abe rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kãnánĩ ꞌbã anzị kí: Sị̃dọ́nị̃ ngọ́tị́ ĩꞌdidrị́ kãjãní rĩ ꞌi, ãzíla ũri ãzí rĩ kí gápi ꞌbá Hị́tị̃ rú, ");
INSERT INTO luc_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yẹ̃bụ́sị̃ rú, Ãmọ́rị̃ rú, Gị̃rị̃gásị̃ rú, ");
INSERT INTO luc_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hị́vị̃ rú, Ãrị́kị̃ rú, Sínã rú, ");
INSERT INTO luc_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Ãrĩvádĩ rú, Zẽmárĩ rú, ãzíla Hãmátĩ rú ꞌdĩ. Vúlé vúlé ru sụ́rụ́ Kãnánĩ drị̂ ꞌbã ꞌbá iré kí ru ndú-ndú ");
INSERT INTO luc_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","lõkókõrí Kãnánĩ drị̂ ándrá angájó Sị̃dọ́nị̃ gá cajó Gérã gâlé ru kpere Gázã gá. Mụ vâ íni Sõdómũ gâlé ru Gõmórã gá, Ãdímã gá ãzíla Zẹ̃bụ̃yị́mụ̃ gá cajó kpere Lásã gá. ");
INSERT INTO luc_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ꞌDĩ kí anzị Hámũ drị̂ kí sụ́rụ́, tị ãzíla ãngũ ĩꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sẹ́mị̃ Yáfẽtĩ ꞌbã ádrị́pị kãjãní rĩ ĩꞌdi áyị́pị ꞌbá pírí Ị̃bẹ́rị̃ rú rĩ ꞌbadrị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Anzị Sẹ́mị̃ drị̂ kí: Ĩlámũ ꞌi, Ãsụ́rị̃ ꞌi, Ãrĩfãsádĩ ꞌi, Lụ́dị̃ ꞌi ãzíla Ãrámũ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Anzị Ãrámũ drị̂ kí: Ụ́zị̃ ꞌi, Hálĩ ꞌi, Gẹ̃dẹ́rị̃ ꞌi ãzíla Másĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ãrĩfãsádĩ Sélã átẹ́pị ꞌi, Sélã ĩꞌdi Ị̃bẹ́rị̃ ꞌbã átẹ́pị ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Anzị Ị̃bẹ́rị̃ drị̂ kí ị̃rị̃: Ãlu rĩ rụ́ Pẽlégĩ ꞌi ãꞌdusĩku ụ́ꞌdụ́ ꞌdã sĩ ꞌbá ụ̃nọ́kụ́ gá rĩ awa kí ándrá ru rá ãzíla úꞌda ándrá ádrị́pị̃ ꞌbã rụ́ Yõkĩtánĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yõkĩtánĩ ꞌbã anzị kí: Ãlĩmõdádĩ ꞌi, Sẹ̃lẹ́fị̃ ꞌi, Hãzãrãmãvẹ́tị̃ ꞌi, Yẹ́rã ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hãdõrámũ ꞌi, Ũzálĩ ꞌi, Dĩkĩláyĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Ũbálĩ ꞌi, Ãbị̃mãyẹ́lị̃ ꞌi, Sébã ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ũfírĩ ꞌi, Hãvị́lã ꞌi ãzíla Yõbábũ ꞌi. ꞌDĩ kí pírí anzị Yõkĩtánĩ drị̂ kî. ");
INSERT INTO luc_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ãngũ ĩꞌbã kí sĩ uꞌájó rĩ ĩjũ ru iꞌdójó Mésã gá Sẽfárĩ gâlé ru ãngũ ꞌbé ꞌa rú wókõ ị̃tụ́ ꞌbã ãfũ agâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ꞌDĩ kí ínátị anzị Sẹ́mị̃ drị̂ gá rĩ drị̂ kí, tị ãzíla ãngũ ĩꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ꞌBá ꞌdĩ ãfũ kí pírí ũri Núwã drị̂ agá, sụ́rụ́ ĩꞌbadrị̂ kí trũ, ãwí ĩꞌbã kí sĩ ãfũjó rĩ trũ, ãzíla ãngũ ĩꞌbadrị̂ abe. Sụ́rụ́ pírí ãfũ kí irélé ụ̃nọ́kụ́ drị̃ gá ꞌdâ ꞌbá ꞌdĩ kí agá ị̃yị́ ándrá tị̃lépi rĩ ꞌbã vúlé gá. ");
INSERT INTO luc_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ándrá údu rĩ sĩ ꞌbá ãngũ drị̃ gá ꞌdâ rĩ kí ị́jọ́ jọ tị ãlu sĩ. ");
INSERT INTO luc_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ꞌBá ꞌbã kí mvi agá ị̃tụ́ ꞌbã ãfũ agâlé ru ꞌdĩ gá ꞌdĩ, ịsụ́ kí ãngũ gbayi rú la Sínã gá ãzíla ri kí dó uꞌálé ala gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Jọ kí kí drĩdríŋĩ gá, “Ãma amụ́ kí bị̃rị́kị̃ ꞌbelé, ãma ivé ĩꞌdi ꞌbã mba kí dó sĩ ũkpó ru.” Ayú kí dó ísékísé ũkpó la ũdrí kẹ̃jị́ gá. ");
INSERT INTO luc_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ꞌDã ꞌbã ũngúkú gá, jọ kí, “Lẽ ãma amụ́ kí ãmaní táwụ̃nị̃ sịlé jó gõrófã rú la trũ drị̃ la ꞌbã ca wị́lị́wị́lị́ ꞌbụ̃ gâlé, ãma rụ́ ꞌbã kụ rú dó sĩ, ãma dó sĩ uꞌá ãngũ ãlu gá ãzíla ãma iré rú dó sĩ ụ̃nọ́kụ́ drị̃ gá ꞌdâ pírí ku.” ");
INSERT INTO luc_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Wó Úpí asị́ vụ̃rụ́ ꞌdõlé táwụ̃nị̃ ꞌbá ꞌdĩ ꞌbã kí iꞌdólé sịlé rĩ ndrelé gõrófã ãzo ĩꞌbã kí iꞌdólé sịlé rĩ be. ");
INSERT INTO luc_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Úpí jọ, “ꞌBá ꞌdĩ kí ꞌbá ãlu ãzíla kí pírí tị ãlu jọ, ꞌdĩ dó drĩ íꞌdóŋá ꞌbá ꞌdĩ ꞌbã kí ị́jọ́ drụ́zị́ ĩꞌbã kí lẽlé idélé rĩ kí iꞌdójó rĩ. Ị́jọ́ ꞌdĩ sĩ, kí dó ãko ĩꞌbã kí lẽlé idélé rĩ kí idé rá, icó kí sĩ kí ndẽlé ku! ");
INSERT INTO luc_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ĩmi amụ́, lẽ ãmụ kí vụ̃rụ̂lé tị ĩꞌbadrị̂ usalé, ꞌba are kí rú sĩ ru kí drĩdríŋĩ gá ku.” ");
INSERT INTO luc_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ị́jọ́ ꞌdĩ sĩ Úpí iré dó sĩ kí ãngũ drị̃ gá ꞌdâ pírí ãzíla ãzị́ ĩꞌbadrị́ táwụ̃nị̃ sịjó ꞌdã tu dó sĩ pá cí. ");
INSERT INTO luc_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Táwụ̃nị̃ ãmbógó ꞌdã rụ́ la Bãbélị̃ ꞌi ífí la Úpí usa ándrá ꞌbá kí tị ꞌdãá. Iré dó sĩ kí kpékpé ãngũ drị̃ gá ꞌdãá pírí. ");
INSERT INTO luc_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ꞌDĩ ãwí Sẹ́mị̃ drị̂ ꞌi. Ílí ị̃rị̃ ị̃yị́ ándrá tị̃lépi ꞌbá kí ị̃lị̃kị̃lépi rĩ ꞌbã vúlé gá, Sẹ́mị̃ ílí ca dó 100 ãzíla tị dó sĩ Ãrĩfãsádĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sẹ́mị̃ la dó mụ Ãrĩfãsádĩ tịlé ꞌbo, uꞌá dó ílí 500 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ãrĩfãsádĩ ílí la mụ calé kãlị́ na drị̃ tõwú ꞌbo, tị dó Sélã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ãrĩfãsádĩ la dó mụ Sélã tịlé ꞌbo, uꞌá dó ílí 403 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sélã ílí la mụ calé kãlị́ na ꞌbo, tị dó Ị̃bẹ́rị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sélã la dó mụ Ị̃bẹ́rị̃ tịlé ꞌbo, uꞌá dó ílí 403 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ị̃bẹ́rị̃ ílí la mụ calé kãlị́ na drị̃ sụ ꞌbo, tị dó Pẽlégĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ị̃bẹ́rị̃ la dó mụ Pẽlégĩ tịlé ꞌbo, uꞌá dó ílí 430 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pẽlégĩ ílí la mụ calé kãlị́ na ꞌbo, tị dó Rẹ́wụ̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pẽlégĩ la dó mụ Rẹ́wụ̃ tịlé ꞌbo, uꞌá dó ílí 209 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rẹ́wụ̃ ílí la mụ calé kãlị́ na drị̃ ị̃rị̃ ꞌbo tị Sẹ̃rụ́gị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Rẹ́wụ̃ la dó mụ Sẹ̃rụ́gị̃ tịlé ꞌbo, uꞌá dó ílí 207 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sẹ̃rụ́gị̃ ílí la mụ calé kãlị́ na ꞌbo, tị dó Nãhọ́rị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sẹ̃rụ́gị̃ la dó mụ Nãhọ́rị̃ tịlé ꞌbo, uꞌá dó ílí 200 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nãhọ́rị̃ ílí la dó mụ calé kãlị́ ị̃rị̃ drị̃ úrômĩ ꞌbo, tị dó Térã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nãhọ́rị̃ la dó mụ Térã tịlé ꞌbo, uꞌá dó ílí 119 ãzíla tị dó sĩ anzị ãgọbị ãzí kí izonzi kí abe. ");
INSERT INTO luc_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Térã ílí la mụ calé kãlị́ ázị̂rị̃ ꞌbo, tị dó Ịbụrámụ̃ ꞌi, Nãhọ́rị̃ ꞌi ãzíla Hãránĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ꞌDĩ dó ãwí Térã drị̂ ꞌi. Térã tị dó Ịbụrámụ̃ ꞌi, Nãhọ́rị̃ ꞌi ãzíla Hãránĩ ꞌi. Hãránĩ tị dó ĩꞌdidrị̂ gá Lọ́tị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Térã ꞌbã drĩ adrujó ídri rĩ sĩ ngọ́pị̃ Hãránĩ drã Ụ́rị̃ Kãlị̃dị́yã gá ꞌdĩ ãngũ sĩ ĩꞌdi tịjó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ịbụrámụ̃ kí Nãhọ́rị̃ be ĩgbã kí ũkú ị̃rị̃ trá rá. Ũkú Ịbụrámụ̃ drị̂ rụ́ la Sãráyĩ ꞌi, Nãhọ́rị̃ drị̂ rụ́ Mílĩkã ꞌi, ĩꞌdi ádrị́pị̃ Hãránĩ ị̃zẹ́pị ꞌi. Mílĩkã ꞌbã ámvọ́pị ãzí rĩ rụ́ la Ị̃sị́kã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sãráyĩ ĩꞌdi ándrá úndó anzị kóru. ");
INSERT INTO luc_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Térã ꞌdụ ngọ́pị̃ Ịbụrámụ̃ kí ũkû Sãráyĩ be, Hãránĩ ngọ́pị Lọ́tị̃ ĩꞌdi umvelépi áyị́pị rĩ trũ ãzíla aꞌbe kí dó ãngũ Ụ́rị̃ Kãlị̃dị́yã gá rĩ sĩ mụjó Kãnánĩ gá. Wó kí mụ acálé Hãránĩ gá ꞌbo ꞌbe kí dó lị́cọ́ sĩ rijó ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Térã uꞌá ílí 205, drã dó sĩ Hãránĩ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Úpí jọ ándrá Ịbụrámụ̃ ní, “Mí aꞌbe ãngũ ꞌdĩ ꞌi, ꞌbá mídrị̂ kí ãzíla ꞌbá mî átẹ́pị drị́ko gá ꞌdĩ kí abe ãzíla ímụ ãngũ mání mụlé iꞌdalé míní rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Ma ími ꞌbã áꞌbị́ sụ́rụ́ ãmbógó la ãni la rú, ãzíla ma míní sụ̃sụ́ wi; ma ími rụ́ ꞌbã ãmbógó ru, ꞌbá kí dó vâ sĩ sụ̃sụ́ ãlá rĩ ịsụ́ mí rụ̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ma sụ̃sụ́ wi ꞌbá sụ̃sụ́ wilépi míní rĩ ní, wó ma ꞌbá ími wãlépi rĩ wã rá, ãzíla ꞌbá pírí ãngũ drị̃ gá rĩ kí sụ̃sụ́ ãlá rĩ ịsụ́ mí rụ̂ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ị́jọ́ ꞌdĩ sĩ, Ịbụrámụ̃ aꞌbe dó ãngũ ꞌdã rá cécé ándrá Úpí ꞌbã jọlé ĩꞌdiní rĩ áni; ãzíla Lọ́tị̃ mụ dó ĩꞌdi be ĩndĩ. Ịbụrámụ̃ ílí ca dó ꞌdĩ sĩ kãlị́ ázị̂rị̃ drị̃ tõwú ĩꞌdi ꞌbã drị̃ kojó Hãránĩ gá ꞌdãá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ꞌDụ ĩꞌdi ꞌbã ũkû Sãráyĩ ꞌi, ádrị́pị̃ ꞌbã ngọ́pị Lọ́tị̃ ꞌi, ãko ĩꞌdidrị̂ kí ãzíla ꞌbá ãtíꞌbó ru ĩꞌbã kí ándrá ịsụ́lé Hãránĩ gá ꞌdãá rĩ kí abe pírí sĩ kí trũ mụjó ãngũ Kãnánĩ gá ãzíla ca kí dó sĩ Kãnánĩ gâlé rá. ");
INSERT INTO luc_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ịbụrámụ̃ alị ãngũ ꞌdã agâ sĩ kpere ĩꞌdi ꞌbã ca agá ife ãmbógó Mõréyã rú Sẹ̃kẹ́mụ̃ gá rĩ gá. Ịsụ́ ụ́ꞌdụ́ ꞌdã sĩ ꞌbá Kãnánĩ rú rĩ kí uꞌá agá ãngũ ꞌdã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ꞌDã ꞌbã ũngúkú gá, Úpí iꞌda ru Ịbụrámụ̃ ní ãzíla jọ, “Ma ãngũ ꞌdĩ fẽ anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbanî.” Sị dó sĩ ãlĩtárĩ Úpí ru iꞌdalépi ĩꞌdiní rĩ ní ãngũ ꞌdã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ko dó sĩ drị̃ ꞌdãá rĩ sĩ mụjó ꞌbé agâlé ru Bẹ̃tẹ́lị̃ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá. Sị dó sĩ hémã ĩꞌdidrị̂ Bẹ̃tẹ́lị̃ kí drĩdríŋĩ gá Áyĩ be. Áyĩ ĩꞌdi wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá ãzíla Bẹ̃tẹ́lị̃ ꞌbã wókõ ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ gá; ꞌdãá sị dó sĩ ãlĩtárĩ Úpí nî ãzíla ị̃nzị̃ dô sĩ Úpí ꞌbã rụ́. ");
INSERT INTO luc_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ꞌDã ꞌbã ũngúkú gá, Ịbụrámụ̃ mụ dó ácị̃ trũ drị̃ gá ãngũ umvelé Nẹ̃gẹ́vụ̃ ꞌi rĩ gâlé ru. ");
INSERT INTO luc_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ꞌDã ꞌbã ũngúkú gá, rílẽ aꞌdé dó ãngũ Kãnánĩ drị̂ gá, Ịbụrámụ̃ mụ dó sĩ ándrá Mị̃sị́rị̃ gâlé sĩ uꞌájó sáwã were rílẽ ꞌdã tẽjó ãꞌdusĩku rílẽ ꞌdã mị la ꞌbãngá ika. ");
INSERT INTO luc_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ĩꞌdi dó mụ calé ãni rú sĩ fijó Mị̃sị́rị̃ gá, jọ ũkû Sãráyĩ ní, “Ánị̃ mi ũkú ũniyambamba la rĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ꞌBá Mị̃sị́rị̃ gá ꞌdĩ drĩ kí ími ndre, kí jọ la ꞌdĩ bãsĩ ũkû ꞌi. Kí dó áma ꞌdị rá, wó kí ími aꞌbe ídri. ");
INSERT INTO luc_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Íjọ ĩꞌbaní mi má ámvọ́pị ꞌi, kí dó sĩ áma tãmba ími ị́jọ́ sĩ, áma ídri la dó sĩ ru pa ími ị́jọ́ sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ịbụrámụ̃ la mụ calé Mị̃sị́rị̃ gá, ndre kí Sãráyĩ ꞌi ũkú ũniyambamba la. ");
INSERT INTO luc_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ãzíla ꞌbá ãmbogo Fãráwũ drị̂ ndre kí ĩꞌdi, ịcụ́ kí ĩꞌdi Fãráwũ ní, úꞌdụ dó sĩ ĩꞌdi agụlé úpí drị́ko gâlé. ");
INSERT INTO luc_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sãráyĩ ꞌbã ị́jọ́ sĩ úpí Fãráwũ mba dó Ịbụrámụ̃ ꞌbã tã múké, ãzíla fẽ dó ĩꞌdiní fẽtáŋá ru kãbĩlõ, tị́, kãyĩnõ ágó rĩ kí ãrónĩ rĩ kí abe, ngãmíyã ágó rĩ kí ãrónĩ rĩ kí abe, ãtíꞌbó ãgọbị rú ãzíla ũkú ru rĩ kî trũ. ");
INSERT INTO luc_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Wó Sãráyĩ Ịbụrámụ̃ ũkû ꞌbã ị́jọ́ sĩ Úpí ĩcãndĩ Fãráwũ jụ́wẹ̃ ũkpó la sĩ ꞌbá ĩꞌdidrị́ko gá rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Fãráwũ umve Ịbụrámụ̃ ꞌi ãzíla zị ĩꞌdi, “Mí idé dó ma íni ãꞌdu ị́jọ́ sĩ yã? Ílũ mání ĩꞌdi ũkú mídrị̂ ꞌi ku la ãꞌdu ị́jọ́ sĩ? ");
INSERT INTO luc_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Íjọ mání ĩꞌdi mî ámvọ́pị ꞌi mání sĩ ĩꞌdi ꞌdụjó mání ũkú ru íni la ãꞌdu ị́jọ́ sĩ? Úꞌdîꞌda íni, mî ũkû dó ꞌdĩ. Íꞌdụ ĩꞌdi ímụ dó ĩꞌdi trũ!” ");
INSERT INTO luc_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ꞌDã ꞌbã ũngúkú gá, Fãráwũ fẽ dó ãzị́táŋá ꞌbá ĩꞌdidrị̂ ꞌbaní Ịbụrámụ̃ drị̃ gá, pẽ kí dó sĩ ĩꞌdi tị ũkû be ãko pírí ĩꞌdi ꞌbã ịsụ́lé rĩ kî trũ ꞌdãá rá. ");
INSERT INTO luc_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ịbụrámụ̃ ãfũ dó Mị̃sị́rị̃ gâlé ũkú ĩꞌdidrị̂ be, ãko ĩꞌdidrị̂ kî trũ pírí ãzíla Lọ́tị̃ mụ ĩꞌdi be ĩndĩ, fi dô sĩ Kãnánĩ gá ãngũ umvelé Nẹ̃gẹ́vụ̃ rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ịbụrámụ̃ ándrá málĩ kí trũ; tị́, kãbĩlõ, ị̃ndrị́, gólũdĩ ãzíla sílĩvã trũ wẽwẽ rú. ");
INSERT INTO luc_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Angájó Nẹ̃gẹ́vụ̃ gá rĩ sĩ, Ịbụrámụ̃ co dó wãyá ãngũ pírí gá cajó kpere Bẹ̃tẹ́lị̃ gá; ãngũ ꞌdã drĩdríŋĩ Bẹ̃tẹ́lị̃ ꞌbãni Áyĩ be rĩ gá ãngũ ándrá ĩꞌdi ꞌbã sĩ hémã drị̃drị̃ ");
INSERT INTO luc_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ãzíla ãlĩtárĩ ídétáŋá idéjó rĩ sịjó rĩ gá. Ịbụrámụ̃ ị̃nzị̃ dó Úpí rụ́ ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Sáwã ꞌdã sĩ Lọ́tị̃ ándrá acị́lépi Ịbụrámụ̃ be ĩndĩ rĩ ꞌbã málĩ kí ándrá vâ wẽwẽ rú ãzíla hémã kî trũ. ");
INSERT INTO luc_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Wó ãngũ ꞌdã ca dó Ịbụrámụ̃ ꞌbaní Lọ́tị̃ be sĩ uꞌájó ãlu ku, ãꞌdusĩku málĩ ĩꞌbadrị̂ ꞌbã kí ándrá adrujó ambamba rĩ sĩ, icó kí dó sĩ uꞌálé ãngũ ãlu gá ku. ");
INSERT INTO luc_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ị́jọ́ ꞌdĩ sĩ ãwãŋá ꞌde dó ꞌbá málĩ Ịbụrámụ̃ drị̂ kí ucélépi rĩ kí drĩdríŋĩ gá ꞌbá málĩ Lọ́tị̃ drị̂ kí ucélépi rĩ abe. Ụ́ꞌdụ́ ꞌdã sĩ ꞌbá Kãnánĩ rú ãzíla Pẹ̃rẹ́zị̃ drị̂ kí abe ri kí ándrá vâ uꞌálé ãngũ ꞌdã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ꞌDã ꞌbã ũngúkú gá, Ịbụrámụ̃ jọ dó Lọ́tị̃ ní, “Lẽ tátí ãma ãwã mí be ku, ãꞌdusĩku ãma mí be kãká. ꞌBá málĩ mídrị̂ kí ucélépi rĩ kí ꞌbá málĩ mádrị̂ kí ucélépi rĩ abe ꞌbã ãwã kí vâ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ãngũ ꞌdĩ dó pírí ími drị̃lẹ́ gá ꞌdĩ ku yã? Lẽ ãma iré ãma rá. Ímụ wókõ ãzí rĩ gâlé ru ma vâ mụ wókõ ãzí rĩ gâlé ru.” ");
INSERT INTO luc_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lọ́tị̃ undré ãngũ, ndre ãngũ gbayi Yõrĩdánĩ tị gá rĩ ị̃yị́ trũ ãzíla ĩrí la rũ kpãcĩ cécé ámvụ́ úpí drị̂ áni, cécé ãngũ Mị̃sị́rị̃ gá rĩ áni, mụ agá Zówã gâlé ru. ꞌDĩ sĩ Ãdróŋá ị̃lị̃kị̃ drĩ ꞌbá Sõdómũ gá rĩ kí Gõmórã gá rĩ kí abe ku. ");
INSERT INTO luc_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lọ́tị̃ pẽ dó ãngũ gbayi Yõrĩdánĩ tị gá rĩ ꞌi ãzíla mụ dó sĩ ị̃tụ́ ꞌbã ãfũ agâlé ru. ꞌBá ꞌdĩ awa kí dó sĩ ru rá. ");
INSERT INTO luc_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ịbụrámụ̃ ace dó ru uꞌálé ãngũ Kãnánĩ drị̂ gá, wó Lọ́tị̃ rĩ dó tọ̃rọ́mẹ́ ị̃yị́ tị gá ꞌdã kí agá, ꞌbe lị́cọ́ ĩꞌdidrị̂ ãni rú ãngũ Sõdómũ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Wó ꞌbá Sõdómũ gá rĩ kí ándrá ꞌbá ũnzí la, ãzíla ri kí ándrá ị́jọ́ izalé Úpí rụ́. ");
INSERT INTO luc_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lọ́tị̃ ꞌbã mụjó ꞌbo rĩ sĩ, Úpí jọ Ịbụrámụ̃ ní, “Mí undré drĩ ãngũ ꞌdĩ ándrá ãzíla ụ́rụ́, ị̃tụ́ ꞌbã ãfũ agá ãzíla ị̃tụ́ ꞌbã ꞌde agá. ");
INSERT INTO luc_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ma mụ ãngũ míní ndrelé ꞌdĩ fẽlé míní anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe adrujó mî ãni la rú jãꞌdâ. ");
INSERT INTO luc_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ma anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí fẽ kpẹ̃lé cínákí vũ gá rĩ áni, ꞌbá ãzí drĩ cínákí vũ drị̃ gá rĩ ꞌbã kãlãfe la rá, ĩꞌdi rú anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí ꞌbã kãlãfe la rá. ");
INSERT INTO luc_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ímụ úꞌdîꞌda mí acị́ ãngũ mání mụlé fẽlé míní ꞌdĩ ꞌbã mgbọ la kí undrélé ãzo la be.” ");
INSERT INTO luc_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ị́jọ́ ꞌdĩ sĩ Ịbụrámụ̃ mụ dó hémã ĩꞌdidrị̂ kî trũ uꞌálé ãni rú kọmọrọ́ ife Mãmírẽ drị́ Hẹ̃bụ̃rọ́nị̃ gá rĩ gá, sị dó sĩ ãlĩtárĩ ídétáŋá idéjó rĩ Úpí ní ãngũ ꞌdã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ụ́ꞌdụ́ ꞌdã sĩ Ãmãrãfẹ́lị̃ úpí Sínã drị́, Ãrị̃yọ́kị̃ úpí Ĩlásã drị́, Kẹ̃dọ̃rị̃lãwọ̃mẹ́rị̃ úpí Ĩlámũ drị́, ãzíla Tídãlĩ úpí Gọ̃yị́mụ̃ drị̂ abe, ");
INSERT INTO luc_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ꞌbá ꞌdĩ mụ kí dó ãꞌdị́ gá ũpi; Bérã úpí Sõdómũ gá rĩ ꞌba rú, Bị̃rị́sã úpí Gõmórã drị́, Sĩnábũ úpí Ãdímã drị́, Sẹ̃mẹ̃bẹ́rị̃ úpí Zẹ̃bụ̃yị́mụ̃ drị́ ãzíla úpí Bélã (umvelé Zówã ꞌi rĩ) drị̂ ꞌba rụ́. ");
INSERT INTO luc_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ũpi tõwú vúlé ꞌdĩ icí kí ru ãlu áꞌbụ Sị̃dị́mụ̃ gá (mĩrĩ umvelé Mĩrĩ Ãꞌị́ ru rĩ gá). ");
INSERT INTO luc_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ũpi tõwú ꞌdĩ ri kí ándrá ãzị́ ngalé Kẹ̃dọ̃rị̃lãwọ̃mẹ́rị̃ ꞌbã pálé gá ílí mụdrị́ drị̃ ị̃rị̃, ílí mụdrị́ drị̃ na rĩ sĩ ají kí ị́jọ́ sĩ mvujó ĩꞌdi rụ́ ꞌdãá rĩ sĩ ãmvé. ");
INSERT INTO luc_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ílí mụdrị́ drị̃ sụ rĩ sĩ úpí Kẹ̃dọ̃rị̃lãwọ̃mẹ́rị̃ ãzíla ũpi ãzí ꞌdĩ kí abe icí kí ru ãlu sĩ mụjó ãꞌdị́ gá. Mụ kí Ãsị̃tẹ̃rọ́tị̃-Kãrị̃námụ̃ gá ndẽ kí ꞌbá Rẹ̃fãyị́mụ̃ drị̂ kî, Hámũ gá ndẽ kí ꞌbá Zụ́zị̃mụ̃ drị̂ kî, Sávẽ Kị̃rị̃yãtãnãyị́mụ̃ gá ndẽ kí ꞌbá Ị̃mị́mụ̃ drị̂ kî ");
INSERT INTO luc_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ãzíla ndẽ kí ꞌbá Họ́rị̃ drị̂ kí ãngũ ꞌbé ꞌa rú Sẽyírĩ gá ãzíla kpere Ĩlĩ-Pãránĩ ãngũ kõtórõ rú rĩ tị gá ãni rú. ");
INSERT INTO luc_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Uja kí ru vúlé, mụ kí dó Ĩnĩ-Mĩsĩpátĩ gá (ãngũ umvelé Kãdẹ́sị̃ ꞌi rĩ). ꞌDụ kí dó ãngũ ꞌbá Ãmãlẹ́kị̃ rú ãzíla ꞌbá Ãmọ́rị̃ rú rĩ ꞌbadrị̂ pírí kpere cajó ãngũ Hãzázõ Tãmárĩ gá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ꞌDã ꞌbã ũngúkú gá, úpí Sõdómũ drị̂, úpí Gõmórã drị̂, úpí Ãdímã drị̂, úpí Zẹ̃bụ̃yị́mụ̃ drị̂ ãzíla úpí Bélã drị̂ trũ (ãngũ ꞌdĩ Zówã ꞌi) mụ kí ru ụ̃tị̃lé áꞌbụ Sị̃dị́mụ̃ drị̂ gá (ꞌdĩ mĩrĩ ãꞌị́ ru rĩ ꞌi) sĩ ãꞌdị́ ꞌdịjó, ");
INSERT INTO luc_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kẹ̃dọ̃rị̃lãwọ̃mẹ́rị̃ úpí Ĩlámũ drị̂, Tídãlĩ úpí Gọ̃yị́mụ̃ drị̂, Ãmãrãfẹ́lị̃ úpí Sínã drị̂ ãzíla Ãrị̃yọ́kị̃ úpí Ĩlásã gá rĩ drị̂ abe; ũpi sụ ꞌdĩ ꞌdị kí ãꞌdị́ ũpi tõwú abe. ");
INSERT INTO luc_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ịsụ́ íni ꞌdĩ áꞌbụ Sị̃dị́mụ̃ drị̂ ga tré ꞌbụ́ kócõ rú rĩ sĩ, ũpi Sõdómũ ãzíla Gõmórã gá rĩ kí mụ apálé, ꞌbá ĩꞌbadrị̂ uꞌde kí ꞌbụ́ ꞌdĩ kí agá ụrụka la apá kî dó ꞌbé agá. ");
INSERT INTO luc_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ũpi sụ Ãmãrãfẹ́lị̃, Ãrị̃yọ́kị̃, Kẹ̃dọ̃rị̃lãwọ̃mẹ́rị̃ ãzíla Tídãlĩ ra kí ãko Sõdómũ ãzíla Gõmórã gá rĩ kí pírí ãzíla mụ kí kîtrũ rá. ");
INSERT INTO luc_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ꞌDụ kí vâ ala gá Lọ́tị̃ Ịbụrámụ̃ ádrị́pị ꞌbã ngọ́pị ĩndĩ, málĩ ĩꞌdidrị̂ kí abe pírí ĩꞌdi ꞌbã uꞌájó Sõdómũ gá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ꞌBá ãzí ãlu apálépi la amụ́ ị́jọ́ ꞌdĩ lũlé Ịbụrámụ̃ Ĩbũrãníyã rú rĩ nî. Ịsụ́ ꞌdĩ sĩ Ịbụrámụ̃ la uꞌá agá kọmọrọ́ ife ãmbogo Mãmírẽ drị̂ kí andre gá, Ãmọ́rị̃ ĩꞌdi ádrị́pị Ị̃sị̃kọ́lị̃ ꞌbadrị́ Ãnẹ́rị̃ be rĩ. ꞌBá ꞌdĩ kí ándrá Ịbụrámụ̃ kî trũ wọ̃rị́ ru kí vâ ru ale ãlu. ");
INSERT INTO luc_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ịbụrámụ̃ la mụ arelé la ụ́ꞌdụ ádrị́pị̃ ꞌbã ngọ́pị ĩndĩ ꞌbo, tra ꞌbá 318 ĩꞌdidrị́ kogá icólépi ãꞌdị́ ꞌdịlépi rá ꞌdĩ kí dro dô sĩ ũpi sụ ꞌdĩ kí vú kpere Dánĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ꞌDãá awa dó ꞌbá kí tị ị̃rị̃, ụꞌdị́ kî dó mẹ́rọ́ꞌbá kí ị́nị́ sĩ ndẽ kí dó sĩ kí rá, dro kí dó kí vú kpere Hõbáhã gá, ꞌdĩ Dãmãsị̃kị́yã ꞌbã drị̃lẹ́ gâlé ru, ");
INSERT INTO luc_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ãzíla apá kí dó ãko tá ralé ꞌda kî. Ají dó ádrị́pị̃ ngọ́pị Lọ́tị̃ ꞌi málĩ ĩꞌdidrị̂ kí abe ĩndĩ, ũkú kî trũ ãzíla ꞌbá ꞌdụlé ĩꞌdi abe rĩ kî trũ. ");
INSERT INTO luc_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ịbụrámụ̃ la mụ ãgõlé ãꞌdị́ ĩꞌdi ꞌbã sĩ úpí Kẹ̃dọ̃rị̃lãwọ̃mẹ́rị̃ ndẽjó ũpi ãzí ꞌdĩ kí abe rĩ gâlé ꞌbo, úpí Sõdómũ drị̂ amụ́ dó drị̃ ụfụlé ĩꞌdi be áꞌbụ ꞌa Sávẽ drị̂ agá (ꞌdĩ áꞌbụ ꞌa úpí drị̂ ꞌi). ");
INSERT INTO luc_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ꞌDã ꞌbã ũngúkú gá, Mẹ̃lẹ̃kị̃zẹ̃dẹ́kị̃ úpí Sãlẹ́mụ̃ drị̂ ãzíla ꞌbá ídétáŋá idélépi Ãdróŋá Ụrụgá Ãndânĩ rĩ ní rĩ ají ãkónã ãzíla wáyĩnĩ abe Ịbụrámụ̃ nî, ");
INSERT INTO luc_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","wi sụ̃sụ́ ĩꞌdiní jọ, “Ãdróŋá Ụrụgá Ãndânĩ ꞌbụ̃ kí ũꞌbãlépi ụ̃nọ́kụ́ be rĩ ꞌbã wi Ịbụrámụ̃ míní sụ̃sụ́! ");
INSERT INTO luc_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ãdróŋá Ụrụgá Ãndânĩ míní fẽlépi la índẽ mẹ́rọ́ꞌbá mídrị̂ kí rá rĩ lẽ ị́cụ́ rụ́ la ịcụ́-ịcụ̂!” Wó Ịbụrámụ̃ fẽ dó Mẹ̃lẹ̃kị̃zẹ̃dẹ́kị̃ ní ãlu mụdrị́ ãko pírí ándrá ralé ĩꞌdi ꞌbã apálé rá rĩ ꞌbadrị̂ kî. ");
INSERT INTO luc_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Úpí Sõdómũ drị̂ jọ Ịbụrámụ̃ ní, “Mí aꞌbe ãko mî arálé ri kí, be la mí ãfẽ mâ ꞌbá kí pírí áyụ.” ");
INSERT INTO luc_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ịbụrámụ̃ umvi úpí Sõdómũ drị̂ ní, “Ána ũyõ Ãdróŋá Ụrụgá Ãndânĩ, ꞌbụ̃ kí ũꞌbãlépi ụ̃nọ́kụ́ be rĩ drị̃lẹ́ gá, ");
INSERT INTO luc_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","má icó ãko ãzí mí ãni la tãmbalé ku drĩ táni adru wị́zị̃ jõku ŋĩlâ ĩbáká. Míní sĩ vúlé-vúlé ru amụ́jó jọjó la Ịbụrámụ̃ acá kụ́rẹ́nị́ ru la ãko mádrị̂ kí sĩ la ku. ");
INSERT INTO luc_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Má icó ãko ãzí ꞌdụlé mání ãluŋá la ku, ma rá la ãko ꞌbá mádrị̂ ꞌbã kí nalé ꞌbo rĩ kí ãꞌị̃ áyụ. Be la lẽ mâ wọ̃rị́ka, Ãnẹ́rị̃, Ị̃sị̃kọ́lị̃ ãzíla Mãmírẽ ꞌbã ꞌdụ kí ãko ĩꞌbadrị́ wókõ gá rĩ kî.” ");
INSERT INTO luc_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ ị́jọ́ Ịbụrámụ̃ ní urobí agâ sĩ jọ, “Mí idé ụ̃rị̃ sĩ ku Ịbụrámụ̃, ãꞌdusĩku ma ími tãmba ãzíla ma míní ụ̃rọ̃drị́ ãzí ãmbógó la fẽ rá.” ");
INSERT INTO luc_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Wó Ịbụrámụ̃ umvi jọ, “Úpí Ũkpó ꞌDị́pị, mâ ngọ́tị́ŋá ꞌdáyụ, sụ̃sụ́ míní wilé ꞌdĩ ꞌbã ụ̃rọ̃drị́ la dó adru mání ãꞌdu yã? Mání adrujó ngọ́tị́ŋâ kóru rĩ sĩ Ị̃lị̃yãzẹ́rị̃ Dãmãsị̃kị́yã gá ãtíꞌbó ru ãzị́ ngalépi mádrị́ rĩ la dó mụ ãko mádrị́ málĩ rú rĩ kí ꞌdụlé pírí nĩ yã? ");
INSERT INTO luc_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ífẽ dó mání anzị kí ku, ị́jọ́ ꞌdĩ sĩ ãtíꞌbó mádrị̂ ꞌbã ãzí ãlu la dó mụ ãko mádrị̂ kí ꞌdụlé nĩ.” ");
INSERT INTO luc_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ꞌDã ꞌbã ũngúkú gá, Úpí jọ ị́jọ́ Ịbụrámụ̃ ní ị̃dị́ jọ, “Ị̃lị̃yãzẹ́rị̃ ãtíꞌbó ru ꞌdĩ icó ãko mídrị̂ kí ꞌdụlé nĩ ku; wó ngọ́tị́ŋá ãfũlépi mí rụ́ rĩ la ãko mídrị́ ꞌdĩ kí ꞌdụ nĩ.” ");
INSERT INTO luc_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ãdróŋá fẽ Ịbụrámụ̃ ní fũlé ãmvêlé ãzíla jọ ĩꞌdiní, “Índre ãngũ ụrụgâlé, ílã lẽlẽgó ụrụgá ꞌdĩ kí kãlãfe. Anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí mụ adrulé cécé ꞌdã ꞌbã áni, ícó kí lãlé ku.” ");
INSERT INTO luc_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ịbụrámụ̃ ãꞌị̃ Úpí ꞌi rá, ãꞌị̃táŋá ĩꞌdidrị̂ ꞌbã ị́jọ́ sĩ Úpí ꞌbã dó ĩꞌdi ꞌbá mgbã la rú. ");
INSERT INTO luc_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ãdróŋá jọ vâ ĩꞌdiní, “Ma Úpí ími ajílépi angájó ãngũ Ụ́rị̃ ꞌdĩ ꞌbá Kãlị̃dị́yã gá rĩ ꞌbadrị̂ agâlé sĩ ãngũ ꞌdĩ fẽjó mî ãni la rú rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Wó Ịbụrámụ̃ zị, “Úpí Ũkpó ꞌDị́pị, má icó nị̃lé la ãngũ ꞌdĩ la adru má ani rĩ gá íngoní ru?” ");
INSERT INTO luc_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ị́jọ́ ꞌdĩ sĩ Úpí jọ ĩꞌdiní, “Mí ají mání tị́ ãlu, ị̃ndrị́ ãlu ãzíla kãbĩlõ ãlu pírí calépi ílí trũ na la kí ãlĩꞌbõ ãlu ãzíla ãmámũ ãlu be.” ");
INSERT INTO luc_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ịbụrámụ̃ ají dó ãnãkpá ꞌdĩ kí Ãdróŋá rụ́ ꞌdõlé, ụlị́ kí rá asi kí ꞌa trũ-trũ ãzíla ụ̃tị̃ kí láyĩnĩ sĩ ndre kí ru ndrẽndrẽ; wó asi ãriŋa rú rĩ kí ꞌa gẹ̃rị̃ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ꞌDã ꞌbã ũngúkú gá, Núgúnúke iꞌdó kí tí urilé ĩzá kí drị̃ gá sĩ kí tijó wó Ịbụrámụ̃ adro kí rá. ");
INSERT INTO luc_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ị̃tụ́ ꞌbã ꞌde agá, ụ́ꞌdụ́ ꞌbe Ịbụrámụ̃ álị́, ụ̃rị̃ ãmbógó la rụ ĩꞌdi cí. ");
INSERT INTO luc_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ꞌDã ꞌbã ũngúkú gá, Úpí jọ ĩꞌdiní, “Lẽ ínị̃ rá anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí mụ adrulé ãmị́yọ́ŋá ru ãngũ ꞌbá ãzí ãni la gá; kí adru ãtíꞌbó ru ãngũ ꞌdã gá ãzíla ála ĩꞌbaní ũcõgõ fẽ ãzị́ ngaŋá sĩ ílí 400. ");
INSERT INTO luc_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Wó sụ́rụ́ ĩꞌbaní ũcõgõ fẽlépi ãzị́ ngaŋá sĩ rĩ ní ma drị̃rịma fẽ rá. Drĩ kí ãfũ ãngũ ꞌdã agâlé ꞌbo, kí amụ́ ãko trũ wẽwẽ rú. ");
INSERT INTO luc_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Mî rú rĩ gá, mi uꞌá ílí wẽwẽ rú, mi drã ãzíla ála ími ị̃sị̃ ásị́ ị̃gbẹ̃ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé áꞌbị́ anzị námbã sụ sĩ rĩ kí mụ ãgõlé vúlé ꞌdõlé nĩ, ãꞌdusĩku má icó ꞌbá Ãmọ́rị̃ rú ꞌdĩ kí drolé ãmvé ku kpere ĩꞌbaní amụ́ agá ĩꞌbaní drị̃rịma fẽ agá ị́jọ́ ũnzĩ ĩꞌbadrị̂ kí sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ị̃tụ́ la mụ ꞌdelé ãzíla ãngũ la mụ nịlé ꞌbo, Ịbụrámụ̃ ndre ãcí dị̃lépi dị̃-dị̃ imvesílílí la alị agá ãnãkpá ĩzá tá ĩꞌdi ꞌbã ụlị́lé ũꞌbãlé ndú-ndú láyĩnĩ sĩ ị̃rị̃ ꞌdĩ kí agâ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ụ́ꞌdụ́ ꞌdã sĩ Úpí icí kí dó tị Ịbụrámụ̃ be. Jọ ĩꞌdiní, “Ma anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbaní ãngũ angálépi Mị̃sị́rị̃ gá kpere mĩrĩ Ũfũrátĩ gá rĩ fẽ, ");
INSERT INTO luc_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ãngũ ꞌbá Kénĩ gá rĩ ꞌbadrị́, ꞌbá Kẹ̃nị́zị̃ gá rĩ ꞌbadrị́, ꞌbá Kãdị̃mọ́nị̃ gá rĩ ꞌbadrị́, ");
INSERT INTO luc_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ꞌbá Hị́tị̃ gá rĩ ꞌbadrị́, ꞌbá Pẹ̃rẹ́zị̃ gá rĩ ꞌbadrị́, ꞌbá Rẹ̃fãyị́mụ̃ gá rĩ ꞌbadrị́, ");
INSERT INTO luc_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ꞌbá Ãmọ́rị̃ gá rĩ ꞌbadrị́, ꞌbá Kãnánĩ gá rĩ ꞌbadrị́, ꞌbá Gị̃rị̃gásị̃ gá rĩ ꞌbadrị́, ãzíla ꞌbá Yẹ̃bụ́sị̃ gá rĩ ꞌbadrị̂ kîtrũ pírí ĩꞌbanî.” ");
INSERT INTO luc_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ịbụrámụ̃ ꞌbã ũkû Sãráyĩ tị ĩꞌdiní anzị kí ku. Wó ĩꞌdi ꞌbã ãtíꞌbó Mị̃sị́rị̃ ízó ru Hãgárĩ ꞌi cí. ");
INSERT INTO luc_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ị́jọ́ ꞌdĩ sĩ, Sãráyĩ jọ Ịbụrámụ̃ ní, “Úpí atrị ma anzị tịŋá gá míní cí. Ímụ kolé ĩzóŋá mádrị́ ãtíꞌbó ru rĩ be. Ma nõ vâ sĩ ngọ́tị́ ịsụ́ agá lị́cọ́ ꞌbãjó ĩꞌdi rụ̂ sĩ rá be.” Ịbụrámụ̃ ãꞌị̃ ị́jọ́ Sãráyĩ ꞌbã jọlé rĩ rá. ");
INSERT INTO luc_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ị́jọ́ ꞌdĩ sĩ Sãráyĩ fẽ dó ĩꞌdi ꞌbã ĩzóŋá ãtíꞌbó ru Hãgárĩ Mị̃sị́rị̃ ízó ru rĩ Ịbụrámụ̃ ní ũkú ru, ịsụ́ ꞌdĩ sĩ uꞌá kí dó Kãnánĩ gá ꞌdãá ílí mụdrị́ ꞌbo. ");
INSERT INTO luc_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ịbụrámụ̃ uꞌá kí Hãgárĩ be rá, Hãgárĩ ịsụ́ ꞌa, ĩꞌdi mụ nị̃lé la ꞌi ngúlú ru ꞌbo, iꞌdó dó Sãráyĩ idelé idê. ");
INSERT INTO luc_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sãráyĩ jọ dó Ịbụrámụ̃ ní, “Ífẽ ị́jọ́ mání sĩ drị̃ cịjó ꞌdĩ mi ꞌi. Áfẽ ãtíꞌbó mádrị̂ míní ãzíla nị̃ dó ꞌi ꞌa trũ rĩ gá cé, ĩꞌdi dó áma ide-ĩdẽ. Lẽ Úpí ꞌbã awa ị́jọ́ ãma drĩdríŋĩ gá mí be rĩ nĩ.” ");
INSERT INTO luc_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ịbụrámụ̃ jọ, “Ãtíꞌbó mídrị́ ꞌdĩ ĩꞌdi ími drị́ alé gá. Mí icó ị́jọ́ míní ũrãlé ĩꞌdi míní múké rĩ idélé ĩꞌdi ụrụꞌbá gá rá.” ꞌDã ꞌbã ũngúkú gá, Sãráyĩ uja dó ru Hãgárĩ ĩcãndĩlé ãzíla Hãgárĩ apá dó sĩ ĩꞌdi rụ́ ꞌdãá rá. ");
INSERT INTO luc_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mãlãyíkã Úpí drị̂ ịsụ́ dó Hãgárĩ kõtórõ agá ãni rú kídí andre gá, ĩꞌdi kídí gẹ̃rị̃ mụlépi wókõ Sụ́rị̃ gá rĩ tị gá. ");
INSERT INTO luc_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Mãlãyíkã zị ĩꞌdi, “Hãgárĩ ãtíꞌbó Sãráyĩ drị̂, mí angá íngõlé ãzíla mi mụ íngõlé yã?” Hãgárĩ Umvi, “Ma apá ãmbógó mádrị́ Sãráyĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mãlãyíkã Úpí drị̂ jọ ĩꞌdiní, “Ígõ ãmbógó mídrị̂ rụ̂lé vúlé ãzíla ífẽ mi pírí ĩꞌdidrị́ alé gá.” ");
INSERT INTO luc_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mãlãyíkã Úpí drị̂ ũꞌbã ĩꞌdiní jọ, “Ma anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí ĩjãlã ũꞌbí ru ála kí la tí.” ");
INSERT INTO luc_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mãlãyíkã Úpí drị̂ jọ vâ ĩꞌdiní: “Mi dó úꞌdîꞌda ꞌa trũ ãzíla mi mụ ngọ́tị́ ágọ́bị̂ tịlé. Mi dó rụ́ la ꞌda Ịsụmayị́lị̃ ꞌi ífí la Úpí andré dó ími ũcõgõ rá ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ĩꞌdi rú adru kãyĩnõ ásé agá rĩ áni ꞌbá kí drĩdríŋĩ gá, drị́ la la adru ꞌbá pírí kí ụrụꞌbá gá, ꞌbá pírí kí drị́ la adru ĩꞌdi ụrụꞌbá gá. Ĩꞌdi rú adru ũmbã rú ádrị́pịka ꞌba rụ́, ĩꞌdi dó sĩ uꞌá kãká ĩꞌdidrị̂ kí abe ndú-ndú.” ");
INSERT INTO luc_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ị́jọ́ ꞌdĩ sĩ, ꞌda dó Úpí ị́jọ́ jọlépi ĩꞌdi be rĩ ní rụ́, “Ãdróŋá áma ndrelépi cé rĩ ꞌi.” Jọ vâ, “Ándre dó úꞌdîꞌda Ãdróŋá áma ndrelépi rĩ rá.” ");
INSERT INTO luc_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ị́jọ́ ꞌdĩ sĩ, úꞌda dó sĩ kídí ꞌdã ꞌbã rụ́ Bẹ̃rị̃ Lãháyĩ-Rọ́yị̃ ꞌi. Ála drĩ ĩꞌdi ịsụ́ drĩdríŋĩ Kãdẹ́sị̃ ꞌbadrị́ Bẹ̃rẹ́dị̃ be rĩ gá cí. ");
INSERT INTO luc_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hãgárĩ tị ngọ́tị́ ágọ́bị́ Ịbụrámụ̃ nî, ãzíla Ịbụrámụ̃ ꞌda dó sĩ ngọ́tị̂ rụ́ Ịsụmayị́lị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ịbụrámụ̃ ílí ca dó sáwã ꞌdã sĩ kãlị́ ãrõ drị̃ ázíyá Hãgárĩ ꞌbã ĩꞌdiní Ịsụmayị́lị̃ tịjó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ịbụrámụ̃ la dó mụ calé ílí trũ kãlị́ úrômĩ drị̃ úrômĩ ꞌbo, Úpí iꞌda ru ĩꞌdiní ãzíla jọ, “Ma Ãdróŋá Ũkpó ꞌDị́pị ꞌi; mí are jõ áma tị ụ́ꞌdụ́ pírí sĩ, mí idé ị́jọ́ múké rĩ kí áma drị̃lẹ́ gá áyụ. ");
INSERT INTO luc_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ma tị icíma ãma drĩdríŋĩ gá mí be rĩ ꞌbã ị́jọ́ azị ãzíla ma anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí fẽ kpẹ̃lé ũꞌbí ru.” ");
INSERT INTO luc_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ị́jọ́ ꞌdĩ sĩ, Ịbụrámụ̃ tị̃ dó ãja ãzíla su tị vụ̃rụ́ ãrútáŋá ru, Ãdróŋá jọ ĩꞌdiní, ");
INSERT INTO luc_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Tị icíma ãmadrị́ mí be rĩ ꞌdĩ: Áꞌbã mi adrujó sụ́rụ́ wẽwẽ rú kí ꞌbã áꞌbị́ ru. ");
INSERT INTO luc_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ícó dó ími umvelé Ịbụrámụ̃ ꞌi ị̃dị́ ku, ála dó ími umve Ịbụrahị́mụ̃ ꞌi ãꞌdusĩku ma dó ími ꞌbã áꞌbị́ sụ́rụ́ ũꞌbí ꞌbã ãni la rú. ");
INSERT INTO luc_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ma fẽ anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbaní kpẹ̃lé ũꞌbí ru, sụ́rụ́ kí ãfũ ími agá ꞌdâ wẽwẽ rú ãzíla anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbã ãzí rĩ kí adru ũpi rú. ");
INSERT INTO luc_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ma ị́jọ́ mání azịlé míní ꞌdĩ tãmba ãzíla anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbã anzịŋá ꞌbaní tị icíma ukólépi ku la rú. Ma adru Ãdróŋá mídrị́ gá rĩ ꞌi ãzíla anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbãni. ");
INSERT INTO luc_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ma ãngũ míní sĩ adrujó ala gá ꞌdâ ãmị́yọ́ŋá ru ꞌdĩ fẽ míní ãzíla anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ abe. Ãngũ Kãnánĩ gá ꞌdĩ la adru pírí mí ãni ãzíla anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbaní jãꞌdâ, ma dó sĩ adru Ãdróŋá ĩꞌbadrị̂ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ Ịbụrahị́mụ̃ ní, “Lẽ mí ãꞌị̃ tị icíma ꞌdĩ tãmbalé má be rá, mi ꞌi ãzíla anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ꞌDĩ tị icíma ãmadrị́ mí be ãzíla anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe rĩ: Lẽ ãgọbị tịlé mí drị́ko gá ꞌdâ rĩ kí mí ĩtãrã kí pírí rá. ");
INSERT INTO luc_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Lẽ mí ĩtãrã mi rá ãzíla ĩtãrãŋá ꞌdĩ la adru ícétáŋá tị icíma ãma drĩdríŋĩ gá mí be rĩ drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Anzị ãgọbị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ drĩ kí ca ụ́ꞌdụ́ ãrõ ꞌbo lẽ îtãrã kí rá, mí ĩtãrã vâ ꞌbá ãtíꞌbó ru tịlé mídrị́ko gá ꞌdâ jõku míní ĩgbãlé séndẽ sĩ ãmị́yọ́ŋá ru rĩ ꞌbadrị̂ kí pírí ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Lẽ mí ĩtãrã ꞌbá ãlu-ãlu mídrị́ko gá ꞌdâ ãgọbị rú rĩ kí pírí rá, údrĩ táni ĩꞌdi tị mídrị́ lị́cọ́ gá ꞌdâ jõku ídrĩ ĩꞌdi ĩgbã séndẽ sĩ tí, ꞌdĩ la dó iꞌda la tị icíma ãmadrị́ mí be rĩ ĩꞌdi tị icíma ukólépi ku la. ");
INSERT INTO luc_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ꞌBá ágọ́bị́ ru ĩtãrãlé ku rĩ adru dó mâ ꞌbá ũri ku, ãꞌdusĩku mba tị icíma ãmadrị́ ꞌdĩ tã ku.” ");
INSERT INTO luc_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ãdróŋá jọ Ịbụrahị́mụ̃ ní, “Lẽ mí umve dó mî ũkû Sãráyĩ ꞌi ku, ĩꞌdi rụ́ dó adru Sárã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ma ĩꞌdiní sụ̃sụ́ wi rá, mi ngọ́tị́ ágọ́bị́ tị ĩꞌdi be, ĩꞌdi adru andre sụ́rụ́ ũꞌbí ꞌbãni la, ũpi kí vâ ãfũ anzị ĩꞌdiní mụlé tịlé drị̃lẹ́ gâlé rĩ kí agá.” ");
INSERT INTO luc_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ịbụrahị́mụ̃ tị̃ dó ãja ãzíla su tị vụ̃rụ́ wó iꞌdó gụlé gụ̃gụ̃ ũrã ị́jọ́ ásị́sị́ŋá sĩ jọ, “ꞌBá la icó tịlé ílí la drĩ ca 100 ꞌbo rĩ gá rá yã? Sárã icó ngọ́tị́ tịlé ꞌdĩ sĩ ĩꞌdi ílí trũ kãlị́ úrômĩ rĩ gá rá yã?” ");
INSERT INTO luc_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Wó Ịbụrahị́mụ̃ jọ Ãdróŋá ní, “Ịsụmayị́lị̃ icó dó adrulé ngọ́tị́ mání sĩ ị́jọ́ azịjó ĩꞌdiní rĩ rú ku yã?” ");
INSERT INTO luc_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Wó Ãdróŋá jọ Ịbụrahị́mụ̃ ní, “Yụ. Ũkú mídrị́ Sárã la ngọ́tị́ ágọ́bị́ tị mi rụ́ la ꞌda Ĩsákã ꞌi. Ma tị icíma mádrị̂ tãmba ĩꞌdi be, ãzíla anzị ĩꞌdidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe jãꞌdâ. ꞌDĩ tị icíma ukólépi ku rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Má are ị́jọ́ míní zịlé Ịsụmayị́lị̃ ꞌbã ị́jọ́ sĩ rĩ rá ma mụ ĩꞌdiní sụ̃sụ́ wilé rá, ãzíla ma ĩꞌdiní anzị kí fẽ wẽwẽ rú, anzị ĩꞌdidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí vâ adru ũꞌbí ru. Ĩꞌdi adru ũpi anzị ãmbogo mụdrị́ drị̃ ị̃rị̃ ꞌdĩ kí ꞌbã átẹ́pị rú ãzíla ma ĩꞌdi ꞌbã adrulé sụ́rụ́ ãmbógó la rú. ");
INSERT INTO luc_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Wó ma tị icíma mádrị́ mî ngọ́pị Ĩsákã Sárã ꞌbã mụlé tịlé ílí drụ̃sị̃ rĩ sĩ ụ́ꞌdụ́ ãndrũ ꞌdĩ áni rĩ sĩ rĩ be rĩ tãmba rá.” ");
INSERT INTO luc_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ãdróŋá la mụ ị́jọ́ jọlé Ịbụrahị́mụ̃ be ꞌbo, aꞌbe dó ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ụ́ꞌdụ́ ãlu ꞌdã sĩ Ịbụrahị́mụ̃ ꞌdụ ngọ́pị̃ Ịsụmayị́lị̃ ãzíla ꞌbá pírí ãgọbị rú ĩꞌdidrị́ko gá rĩ kí, ꞌbá ĩꞌdi ꞌbã ĩgbãlé ĩgbã séndẽ sĩ rĩ abe ĩtãrã dó kí rá Ãdróŋá ꞌbã jọlé ĩꞌdiní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ịbụrahị́mụ̃ ĩtãrã ru ꞌdĩ sĩ ílí la ca dó kãlị́ úrômĩ drị̃ úrômĩ, ");
INSERT INTO luc_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ãzíla ngọ́pị̃ Ịsụmayị́lị̃ ílí ca dó ꞌdĩ sĩ mụdrị́ drị̃ na, ");
INSERT INTO luc_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","îtãrã dó Ịbụrahị́mụ̃ kí ngọ́pị̃ Ịsụmayị́lị̃ be ị̃rị̃ trá ụ́ꞌdụ́ ãlu ꞌdã sĩ. ");
INSERT INTO luc_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ꞌBá pírí ãgọbị rú Ịbụrahị́mụ̃ drị́ko gá rĩ kí, ꞌbá ãmị́yọ́ŋá ru ĩꞌdi ꞌbã ĩgbãlé ĩgbã séndẽ sĩ rĩ kí abe ĩtãrã dó kí pírí ĩꞌdi abe. ");
INSERT INTO luc_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Úpí iꞌda ru Ịbụrahị́mụ̃ ní kọmọrọ́ ife Mãmírẽ drị̂ ị̃ndụ́ gá ĩꞌdiní rĩ agá hémã ĩꞌdidrị̂ ꞌbã tị gá ꞌdãá ị̃tụ́kã íríkírí sĩ. ");
INSERT INTO luc_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ndre ãngũ ụrụgá ãzíla ndre dó ãgọbị kí na pá tu agá ụrụgâsĩ. Ĩꞌdi mụ kí ndrelé ꞌbo, cọtị cẹ̃ mụlé drị̃ ụfụlé ĩꞌba abe. Ãvụ̃ vụ̃rụ́ ị̃nzị̃táŋá sĩ kpere drị̃ la ꞌbã vũ aló agá. ");
INSERT INTO luc_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Jọ, “Úpí mádrị̂, Áma ị́jọ́ drĩ fi ĩmi ásị́ gá rá, ĩmi alị ãtíꞌbó ĩmidrị̂ drị́ko gâsĩ alị-alị ku. ");
INSERT INTO luc_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ma dó ãzị́ nga ĩminî. Ĩmi ají ásũ ĩminí ị̃yị́ sĩ pá ũjĩjó. Ĩmi dó sĩ avị́ ife ꞌdĩ ị̃ndụ́ gá ꞌdâ. ");
INSERT INTO luc_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ma ĩminí ãkónã ají wereŋá ru sĩ ĩminí ũkpõ fẽjó, ĩmi dó sĩ mụ ãcị̃ ĩmidrị́ ꞌdĩ gá múké. Ĩminí amụ́jó mádrị́ko gá ꞌdõlé rĩ ĩꞌdi mání ị̃nzị̃táŋá ru, lẽ áfẽ ĩminí ãko ãzí nalé rá.” Umvi kí, “Múké, ãma ãꞌị̃ rá.” ");
INSERT INTO luc_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ịbụrahị́mụ̃ afụ ru hémã agâlé, jọ Sárã ní, “Mí aꞌdụ́ ãnáfóró mĩnãmĩnã la sĩ íná avujó gbõrú.” ");
INSERT INTO luc_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ꞌDã ꞌbã ũngúkú gá, cẹ̃ dó tị́ kí agâlé ãzíla aꞌdụ́ dó kãjóŋá mũlũkũdũ la, fẽ ĩꞌdi ãtíꞌbó drị́ idélé kpĩcá gbõ rú. ");
INSERT INTO luc_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ãkónã la dó mụ aꞌdílé ꞌbo, Ịbụrahị́mụ̃ ají dó ãdu, lẹ́sụ́ ãzíla kãjóŋá ĩzá tá idélé ꞌda kí ꞌbãlé kí drị̃lẹ́ gá. Ĩꞌbaní íná na agá ꞌdãá, Ịbụrahị́mụ̃ tu dó pá ãni rú ife ị̃ndụ́ gá ꞌdãá sĩ íyóŋá íyó jó. ");
INSERT INTO luc_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ãgọbị na ꞌdã zị kí Ịbụrahị́mụ̃ ꞌi, “Ũkú mídrị́ gá Sárã dó íngõlé yã?” Ịbụrahị́mụ̃ umvi kí jọ, “Ĩꞌdi hémã agâlé ꞌdã.” ");
INSERT INTO luc_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ꞌDã ꞌbã ũngúkú gá, Úpí jọ, “Ãndá-ãndá ru ílí drụ̃sị̃ rĩ sĩ sáwã ꞌdĩ áni rĩ gá ma ãgõ mí rụ́ ꞌdõlé rá, ãzíla ũkú mídrị́ Sárã la ngọ́tị́ ágọ́bị́ ịsụ́ rá.” Ịsụ́ íni ꞌdĩ Sárã la dị̃ ị́jọ́ ĩꞌbã kí jọlé ꞌdĩ kí are sĩ hémã agâlé. ");
INSERT INTO luc_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ịbụrahị́mụ̃ kí dó Sárã be ĩdranigo rú ãzíla Sárã ꞌbã áyi sĩ ĩmbá ndrejó rĩ alí dó rá. ");
INSERT INTO luc_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sárã gụ dó gụ̃gụ̃. Jọ, “Ma dó ĩdránígó ru ãzíla áma ũkpõ ukó dó ꞌbo, mâ ágô vâ ĩdránígó ru, má icó dó ãyĩkõ ịsụ́lé sĩ áma icíjó ágọ́bị́ be rá yã?” ");
INSERT INTO luc_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Úpí zị Ịbụrahị́mụ̃ ꞌi, “Sárã gụgụ̃ ãzíla jọ ‘Má icó ngọ́tị́ŋá ịsụ́lé ꞌdĩ sĩ ma dó ĩdránígó ru la íngoní ru ãꞌdu ị́jọ́ sĩ?’ ");
INSERT INTO luc_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ị́jọ́ ãzí Úpí ní ũkpó-ũkpó la cí yã? Ílí drụ̃sị̃ rĩ sĩ sáwã pẽlé rĩ agá, ma ãgõ rá ãzíla Sárã la ngọ́tị́ ágọ́bị́ tị rá.” ");
INSERT INTO luc_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sárã idé ụ̃rị̃ sĩ, ga ãgátã rá jọ, “Ágụ gẹ̃rị̃ sĩ ku.” Úpí jọ, “Ãndá, ígụ rá.” ");
INSERT INTO luc_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ꞌDã ꞌbã ũngúkú gá, ãgọbị̂ angá kí dó ụrụgá sĩ drị̃ kojó mụjó, ndre kí dó ãngũ ándrá Sõdómũ gâlé ru. Ịbụrahị́mụ̃ agụ dó kí pá ꞌbãlé gẹ̃rị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ꞌDã ꞌbã ũngúkú gá, Úpí zị ru ꞌa, “Má icó ị́jọ́ mání lẽlé idélé rĩ kí ucílé Ịbụrahị́mụ̃ ní cá rá yã? Yụ má icó kí ucílé ĩꞌdiní ku. ");
INSERT INTO luc_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ãndá-ãndá ru Ịbụrahị́mụ̃ la mụ acálé sụ́rụ́ ãmbógó ũkpó íni la, ĩꞌdi rụ̂ sĩ ma mụ sụ̃sụ́ wilé sụ́rụ́ ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ ꞌbaní pírí. ");
INSERT INTO luc_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ị́jọ́ ꞌdĩ sĩ ápẽ ĩꞌdi íni la sĩ ímbátáŋá fẽjó anzị ĩꞌdidrị̂ ꞌbaní ãzíla anzị ĩꞌdidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí dó sĩ Úpí tị are sĩ ị́jọ́ pịrị rĩ idéjó ãzíla ị́jọ́ lịŋá pịrị rĩ be, Úpí la dó sĩ ị́jọ́ ĩꞌdi ꞌbã azịlé ꞌi idé la Ịbụrahị́mụ̃ ní rĩ kí idé rá.” ");
INSERT INTO luc_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Úpí jọ Ịbụrahị́mụ̃ ní, “Ị́jọ́ ũnzí jọlé ꞌbá Sõdómũ gá ãzíla Gõmórã gá rĩ kí drị̃ gá rĩ acá kpere áma bị́lẹ́ gá rá. ");
INSERT INTO luc_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ị́jọ́ ꞌdĩ sĩ, álẽ sịlé vụ̃rụ̂lé sĩ ị́jọ́ ũnzíkãnã ĩꞌbadrị́ ĩꞌbã kí idélé acálépi kpere áma bị́lẹ́ gá ꞌdĩ kí ãndá yã rĩ ndrelé. Drĩ kí dó adru ãndá ku ma dô sĩ nị̃ la rá.” ");
INSERT INTO luc_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ãgọbị ị̃rị̃ ꞌdĩ mụ kí dó Sõdómũ gâlé ru, wó Úpí ace drĩ ru Ịbụrahị́mụ̃ be. ");
INSERT INTO luc_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ꞌDã ꞌbã ũngúkú gá, Ịbụrahị́mụ̃ asé ru Ãdróŋá andre gá, zị ĩꞌdi, “Mi mụ ꞌbá ị́jọ́ kóru rĩ kí ụꞌdị́lé ꞌbá ị́jọ́ ũnzí rĩ kí abe yã? ");
INSERT INTO luc_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ꞌBá ị́jọ́ kóru rĩ drĩ kí adru ꞌbá kãlị́ tõwú táwụ̃nị̃ ꞌdã agá ꞌdãá cí mí kí ụꞌdị́ ꞌbá ũnzí rĩ kí abe pírí yã? Mí icó táwụ̃nị̃ ꞌdã aꞌbelé kí ị́jọ́ sĩ ku yã? ");
INSERT INTO luc_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ãndá-ãndá ru mí icó ꞌbá ị́jọ́ kóru rĩ kí ụꞌdị́lé ꞌbá ị́jọ́ trũ rĩ abe pírí ku. Mí icó ku! ꞌBá ị́jọ́ ụ̃nọ́kụ́ drị̃ gá rĩ lịlẹ́pi pírí nĩ rĩ icó ị́jọ́ pịrị rĩ idélé ku yã?” ");
INSERT INTO luc_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Úpí jọ, “Ádrĩ ꞌbá ị́jọ́ kóru rĩ kí ịsụ́ kãlị́ tõwú rá ma táwụ̃nị̃ Sõdómũ drị́ ꞌdã aꞌbe kí ị́jọ́ sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ꞌDã ꞌbã ũngúkú gá, Ịbụrahị́mụ̃ ꞌbã vâ mãmálá Ãdróŋá drị̃lẹ́ gá ị̃dị́ jọ, “Áma ũkpó sĩ ị́jọ́ jọjó mí be la yụ, ãꞌdusĩku ma ꞌbá míní ꞌbãlé mi ꞌi la. ");
INSERT INTO luc_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ꞌBá ị́jọ́ kóru rĩ drĩ kí adru ꞌbá kãlị́ sụ drị̃ tõwú drĩ kí ca kãlị́ tõwú ku mi drĩ vâ táwụ̃nị̃ ꞌdã ị̃lị̃kị̃ ꞌbá tõwú ꞌdã kí ị́jọ́ sĩ rá yã?” Úpí umvi, “Ádrĩ ꞌbá ị́jọ́ kóru rĩ kí ịsụ́ ꞌdãá kãlị́ sụ drị̃ tõwú rá, má icó tõwú ꞌdã ị̃lị̃kị̃ lé ku.” ");
INSERT INTO luc_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ịbụrahị́mụ̃ zị vâ ị̃dị́, “ꞌBá drĩ kí adru ꞌdãá kãlị́ sụ mi ãngũ ꞌdã ị̃lị̃kị̃ rá yã?” Ãdróŋá umvi, “ꞌBá kãlị́ sụ ꞌda kí ị́jọ́ sĩ, má icó ãngũ ꞌdã ị̃lị̃kị̃ lé ku.” ");
INSERT INTO luc_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ịbụrahị́mụ̃ jọ Úpí ní, “Ími ásị́ ꞌbã azá mání ku mí aꞌbe ájọ ị́jọ́; ꞌbá múké rĩ drĩ kí adru kãlị́ na mi ãngũ ꞌdã ị̃lị̃kị̃ rá yã?” Úpí umvi, “Má icó ku.” ");
INSERT INTO luc_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ịbụrahị́mụ̃ jọ, “Ítrũ ma ị́jọ́ mání jọlé ásị́ ũkpó sĩ ꞌdĩ sĩ rá. ꞌBá drĩ kí adru kãlị́ ị̃rị̃ mi ãngũ ꞌdã ị̃lị̃kị̃ rá yã?” Úpí umvi, “ꞌBá kãlị́ ị̃rị̃ ꞌdã kí ị́jọ́ sĩ má icó ku.” ");
INSERT INTO luc_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ịbụrahị́mụ̃ jọ, “Úpí mí idé mání ũmbã sĩ ku fô! Wó ꞌbá drĩ kí adru mụdrị́?” Úpí umvi, “ꞌBá mụdrị́ ꞌdã kí ị́jọ́ sĩ má ị̃lị̃kị̃ ãngũ ꞌdã ku.” ");
INSERT INTO luc_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Úpí la mụ Ịbụrahị́mụ̃ be ị́jọ́ jọŋá delé ꞌbo, mụ dó rá, ãzíla Ịbụrahị́mụ̃ gõ dó lị́cọ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Mãlãyíkã tá ị̃rị̃ ꞌdã ca kí dó Sõdómũ gâlé ĩndró sĩ, ịsụ́ kí ꞌdĩ sĩ Lọ́tị̃ ri kẹ̃jị́tị táwụ̃nị̃ drị̂gá. Ĩꞌdi mụ kí ndrelé ꞌbo, gbõgbõ nga ụrụgá, cẹ̃ mụlé kí aꞌị́lé ãzíla ãvụ̃ dó ị̃nzị̃táŋá sĩ vũ gá, ");
INSERT INTO luc_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","jọ, “Ũpi mádrị́ ꞌdĩ, má aꞌị́ ĩmi amụ́jó mádrị́ jó agá ꞌdõlé, ĩmi ũjĩ ĩmi pá kî ãzíla ĩko ị́nị́ ꞌdĩ sĩ ꞌdâ, ĩmi dô sĩ fũ údukanana mụlé gẹ̃rị̃ ĩminí lẽjó mụjó rĩ gâlé.” Umvi kí, “Yụ, ãma ụ́ꞌdụ́ ko ãmvé ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Fu kí kpere ĩꞌbã kí ãꞌị̃ agá mụ agá ĩꞌdidrị́ko gâlé. Lọ́tị̃ idé dó ĩꞌbaní mũkátĩ ãkụ́kị́ kóru rĩ ãkónã rú ãzíla na kí dó ĩꞌdi. ");
INSERT INTO luc_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ãmụ́ ꞌdã mụ kí drĩ ru lalé vụ̃rụ́ ku rú, ꞌbá táwụ̃nị̃ Sõdómũ drị̂ gá ĩdranigo rú ãzíla kãrị́lẹ̃ rú ꞌdã ce kí jó Lọ́tị̃ drị́ ꞌdã andre rị́. ");
INSERT INTO luc_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Umve kí Lọ́tị̃ ꞌi, zị kí ĩꞌdi, “Ãgọbị tá amụ́lépi ụ́ꞌdụ́ gá mí drị́ ꞌdõlé ị́nị́ ꞌdĩ sĩ rĩ kí dó íngõlé, mí ají kí ãma rụ́ ꞌdõlé, ãlẽ lalé kí sĩ ũkú ru.” ");
INSERT INTO luc_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lọ́tị̃ ãfũ ãmvé ꞌbá ru tralépi rĩ ꞌba rụ́ ꞌdõlé ãzíla ụ̃pị̃ dó kẹ̃jị́tị cí ");
INSERT INTO luc_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ãzíla jọ, “Íni ku, mâ wọ̃rị́kâ má ãꞌị̃ ĩminí ị́jọ́ ũnzí ꞌdĩ áni la idéjó ku. ");
INSERT INTO luc_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ĩndre mâ izonzi ị̃rị̃ drĩ ágó ãjị́ ꞌbị̃lépi ku la kí cí, ma kí ají ĩminî ãzíla ĩmi icó ị́jọ́ cí ĩminí lẽlé idélé rĩ kí idélé kí ụrụꞌbá gá rá, ꞌbo álẽ ĩmi idé ị́jọ́ ãzí ꞌbá mâni ꞌdĩ kí ụrụꞌbá gá ku. Kí ãmụ́ mâni la, lẽ ámba kí tã rá.” ");
INSERT INTO luc_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Jọ kí, “Mí ĩdã mi ꞌdâ rá, mi ãmị́yọ́ŋá. Mi ãꞌdi ꞌi ãma ị́jọ́ lịjó, mí ĩdã mi ãma andre gá ꞌdâ jõ íni ku ãma ími idé ũnzíríkãnã rú ĩꞌbaní ãndânĩ.” Ze kí dó Lọ́tị̃ tẽndẽrẽ vúlé vúlé ru tí sĩ kẹ̃jị́tị nũjó íni. ");
INSERT INTO luc_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Wó ꞌbá ị̃rị̃ tá jó agâlé ꞌdã asú kí drị́ kẹ̃jị́tị gâsĩ ãmvé ꞌdõlé, se kí dó sĩ Lọ́tị̃ jó agâlé ãzíla ụ̃pị̃ kí dó kẹ̃jị́tị cí. ");
INSERT INTO luc_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ꞌDã ꞌbã ũngúkú gá, ãgọbị ị̃rị̃ jó agâlé ꞌdã ãzụ̃ kí dó ꞌbá kẹ̃jị́tị gá ꞌdã kí mịfị́ cí ꞌbã ndre kí dó sĩ kẹ̃jị́tị ku. ");
INSERT INTO luc_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ꞌBá ị̃rị̃ ꞌdã jọ kí Lọ́tị̃ ní, “Mî kãká ãzí: ị̃zịgọ rú, izonzi rú, anzị ãgọbị ãzíla mî ị̃zẹ́pịka ru la drĩ kí adru ꞌdâ cí yã áni, mí iyá kí ꞌdâ rá, ");
INSERT INTO luc_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ãꞌdusĩku ãma mụ ãngũ ꞌdĩ ị̃lị̃kị̃lé rá. Ị́jọ́ ũnzíkákãnã ꞌbá Sõdómũ gá ãzíla Gõmórã gá rĩ ꞌbadrị̂ ca dó kpere Úpí bị́lẹ́ gá rá, ị́jọ́ ꞌdĩ sĩ ãpẽ dó sĩ ãma tị sĩ amụ́jó ãngũ ꞌdĩ ị̃lị̃kị̃jó ãcí sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lọ́tị̃ mụ ꞌbá ị̃zẹ́pịka kí lẽlépi ĩgbãlépi rĩ ꞌba rụ́ ãzíla jọ ĩꞌbaní, “Ĩmi idé gbõrú, ĩmi aꞌbe táwụ̃nị̃ ꞌdĩ ꞌi ãꞌdusĩku Úpí la mụ ãngũ ꞌdĩ ị̃lị̃kị̃lé ãcí sĩ rá.” Wó ị̃zịgọ ĩꞌdidrị̂ ũrã kí Lọ́tị̃ la ꞌbãngá ĩrẽ idé íni. ");
INSERT INTO luc_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ãngũsãrã sĩ mãlãyíkã ĩrũgbũ kí dó Lọ́tị̃ ꞌi ãzíla jọ kí ĩꞌdiní, “Gbõrú, gbõrú! Íꞌdụ ũkú mídrị̂ ꞌi ãzíla izonzi mídrị́ ị̃rị̃ ꞌdĩ kí abe trũ apájó, ị́jọ́ ꞌdĩ sĩ ĩmi ị̃lị̃kị̃ rû sĩ ụ́ꞌdụ́ sĩ táwụ̃nị̃ ꞌdĩ ní drị̃rịma fẽjó rĩ sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lọ́tị̃ ụrụꞌbá la mụ filé fĩfĩ ꞌbo, ãgọbị ị̃rị̃ ꞌdĩ rụ kí ĩꞌdidrị́ ũkû be ãzíla ị̃zẹ́pịka ị̃rị̃ ꞌdã kí abe sĩ kí agụjó táwụ̃nị̃ agá ꞌdãá rĩ sĩ ãmvé ãꞌdusĩku Úpí Ãdróŋâ ásị́ ĩꞌbaní ị̃gbẹ́ ru. ");
INSERT INTO luc_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Mãlãyíkã kí mụ kí ajílé ãmvé ꞌdõlé ꞌbo, ãlu rĩ jọ, “Ĩcẹ̃cẹ̃ sĩ ĩmi ídri pajó! Ĩmi andré ãngũ vúlé ku ãzíla ĩtu pá áꞌbụ agá ꞌdãá ku! Ĩcẹ̃ ꞌbé kí agâlé ru ĩmi ũdrã rû sĩ ku fô!” ");
INSERT INTO luc_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Wó Lọ́tị̃ jọ, “Yụ! Ũpi mádrị̂! Ĩfẽ ãma idé ꞌdĩ áni ku fô! ");
INSERT INTO luc_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ãtíꞌbó mídrị̂ ịsụ́ ãyĩkõ ími drị̃lẹ́ gá, ãzíla mí iꞌda mání ásị́ ị̃gbẹ̃ ãmbógó ꞌdĩ ꞌi míní áma ídri pajó rĩ sĩ. Wó ꞌbé ꞌdã ĩꞌdi álị́-álị́, táwụ̃nị̃ ꞌdĩ ꞌbã ivéŋá la ãma ịsụ́ gẹ̃rị̃ gá ãma ũdrã ịsụ́ ꞌdĩ sĩ ãca drĩ lé ku rú. ");
INSERT INTO luc_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Índre, táwụ̃nị̃ ãzí ãníyágágá la ꞌdã mání sĩ cẹ̃jó alagá la, ãzíla ĩꞌdi ĩmbíráŋá ru. Lẽ má apá ala gâlé, ma dó sĩ áma ídri pa rá.” ");
INSERT INTO luc_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Jọ ĩꞌdiní, “Má ãꞌị̃ rá, ma ị́jọ́ míní jọlé ꞌdĩ idé rá, má icó táwụ̃nị̃ míní jọlé ꞌdĩ ị̃lị̃kị̃lé ku. ");
INSERT INTO luc_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Wó mí apá gbõrú, ãꞌdusĩku má icó ị́jọ́ ãzí idélé ku kpere míní ca agâlé rá ká.” (ꞌDĩ bã sĩ ị́jọ́ táwụ̃nị̃ ꞌdĩ umvejó Zówã ꞌi rĩ ꞌi.) ");
INSERT INTO luc_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lọ́tị̃ ca Zówã gá ị̃tụ̂ ꞌbã agâ gá. ");
INSERT INTO luc_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ị́jọ́ tị gá ꞌdĩ ambamba Úpí su Gõmórã kí ãcí Sõdómũ be bãrụ́tị̃ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ivé ãko táwụ̃nị̃ agá rĩ kí angájó áꞌbụ agâlé, ꞌbá kí trũ, ife ãzíla ásé kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Wó ũkú Lọ́tị̃ drị̂ uja tị ãngũ ndrelé vúlê lé ru, cọtị ũkû umba dó ãꞌị́ ru ị́dị́ŋâ áni. ");
INSERT INTO luc_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ãngũsãrã sĩ Ịbụrahị́mụ̃ mụ ãngũ ĩꞌdi ꞌbã sĩ ándrá pá tujó Úpí be rĩ gâlé. ");
INSERT INTO luc_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ndre ãngũ Gõmórã kí agâlé ru Sõdómũ be ãzíla ãngũ áꞌbụ agâlé ru rĩ gá. Ndre ãcíkã angálépi alagâlé rĩ ịnịbịrịcịcị rú mẽnú ãcíkã áni. ");
INSERT INTO luc_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Wó Ãdróŋá la mụ táwụ̃nị̃ ãngũ ꞌdã agá rĩ kí ị̃lị̃kị̃lé ꞌbo, ũrã ị́jọ́ Ịbụrahị́mụ̃ drị̃ gá, ãzíla anzé Lọ́tị̃ ꞌi lị́kị̃ ándrá ĩꞌdi ꞌbã sĩ táwụ̃nị̃ ándrá ĩꞌdi ꞌbã sĩ uꞌájó rĩ ị̃lị̃kị̃jó rĩ agâlé rá. ");
INSERT INTO luc_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lọ́tị̃ kí ĩꞌdi ꞌbã ị̃zẹ́pịka ị̃rị̃ ꞌdã kí abe aꞌbe kí dó Zówã rá ãzíla mụ kí dó uꞌálé ꞌbé agâlé, ãꞌdusĩku Lọ́tị̃ idé ụ̃rị̃ sĩ uꞌájó Zówã gá ꞌdãá. Tụ kí dó uꞌálé ụ̃jị́gọ́ agá ꞌbé agâlé. ");
INSERT INTO luc_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ụ́ꞌdụ́ ãlu Lọ́tị̃ ꞌbã ĩzóŋá kãjãní rĩ jọ ámvọ́pị̃ vúlé rĩ nî, “Ãma átẹ́pị la úgólé adrulé ĩdránígó ru, wó ãgọbị ãzí ãni rú ãma ĩgbãlépi la kí ꞌdáyụ sĩ ãmaní ngọ́tị́ŋá ịsụ́jó cécé lãꞌbĩ ꞌbã lẽlé ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Mí amụ́, lẽ ãfẽ ãma átẹ́pị ní wáyĩnĩ mvụlé ĩꞌdi dô sĩ ụ́ꞌdụ́ ko ãma abe ãzíla lị́cọ́ ãmadrị̂ ꞌba anụ́ rû sĩ ku be nĩ.” ");
INSERT INTO luc_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ị́nị́ ꞌdã sĩ fẽ kí dó ĩꞌdiní wáyĩnĩ mvụlé, ĩzóŋá kãjãní rĩ la kí ru ĩꞌdi be. Wó átẹ́pị̃ mvụ wáyĩnĩ ambamba nị̃ dô sĩ ãꞌdu ị́jọ́ idé ru nĩ yã rĩ gá ku. ");
INSERT INTO luc_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ụ́ꞌdụ́ ãzí rĩ sĩ ĩzóŋá kãjãní rĩ jọ ámvọ́pị̃ nî, “Ị́nị́ ájệ rĩ sĩ ãko ụ́ꞌdụ́ ĩꞌdi be rá, úꞌdîꞌda ãma ị̃jọ̃tọ̃ rú ĩꞌdi wáyĩnĩ sĩ, mi sĩ ími la ĩꞌdi be, ꞌdĩ gá ꞌdâ mi dô sĩ ngọ́tị́ ịsụ́ ĩꞌdi be.” ");
INSERT INTO luc_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ị́jọ́ ꞌdĩ sĩ, ị́nị́ ꞌdã sĩ ị̃jọ̃tọ̃ kí dó ĩꞌdi wáyĩnĩ sĩ, átẹ́pị̃ ĩmẽrã dó rá, la kí dó sĩ ru ĩzóŋá vúlé rĩ be. Mérã sĩ nị̃ vâ ãꞌdu ị́jọ́ idé ru nĩ yã rĩ gá ku. ");
INSERT INTO luc_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ị́jọ́ ꞌdĩ sĩ, izonzi ị̃rị̃ ꞌdĩ ịsụ́ kí dó ꞌa átẹ́pị̃ Lọ́tị̃ drị́. ");
INSERT INTO luc_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ĩzóŋá drị̃drị̃ rĩ ịsụ́ ngọ́tị́ ágọ́bị́ ꞌda rụ́ la Mụ̃wábụ̃ ꞌi. Ĩꞌdi áyị́pị ꞌbá úꞌdîꞌda umvelé Mụ̃wábụ̃ rĩ ꞌbadrị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ĩzóŋá vúlé rĩ ịsụ́ vâ ngọ́tị́ ágọ́bị́ ꞌda rụ́ la Bénãmĩ ꞌi, ꞌdĩ áyị́pị ꞌbá úꞌdîꞌda umvelé Ãmọ́nị̃ rĩ ꞌbadrị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ꞌDã ꞌbã ũngúkú gá, Ịbụrahị́mụ̃ mụ dó Hẹ̃bụ̃rọ́nị̃ gá ꞌdãá rĩ sĩ Nẹ̃gẹ́vụ̃ gá, ri dó Gérã gá drĩdríŋĩ Kãdẹ́sị̃ ꞌbadrị́ Sụ́rị̃ be rĩ gá. Ĩꞌdi ní uꞌá agá ꞌdãá sáwã were sĩ, ");
INSERT INTO luc_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ịbụrahị́mụ̃ jọ ꞌbá ꞌdãá rĩ ꞌbaní, “Sárã ĩꞌdi má ámvọ́pị ꞌi.” ꞌDã ꞌbã ũngúkú gá, Úpí Ãbị̃mẹ́lẹ̃kị̃ Gérã drị̂ pẽ ꞌbá tị sĩ Sárã ajíjó ĩꞌdi rụ́ ꞌdõlé ãzíla ꞌdụ dó ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Wó Ãdróŋá amụ́ Ãbị̃mẹ́lẹ̃kị̃ rụ́ ị́nị́ sĩ urobí agâ sĩ ãzíla jọ ĩꞌdiní, “Mi mụ drãlé rá míní ũkú ꞌdĩ ꞌdụjó rĩ sĩ ãꞌdusĩku ĩꞌdi ágó trũ.” ");
INSERT INTO luc_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Wó íni ꞌdĩ Ãbị̃mẹ́lẹ̃kị̃ icí kí ru ĩꞌdi be ku. Jọ, “Úpí, ma ị́jọ́ kóru! Mi dó mụ ãma ị̃lị̃kị̃lé ꞌbá mádrị̂ kí abe pírí yã? ");
INSERT INTO luc_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Adru Ịbụrahị́mụ̃ jọ mání, ‘ꞌDĩ má ámvọ́pị ꞌi rĩ gá ku yã’ ãzíla Sárã ꞌbã mgbã jọ mání, ‘ꞌDĩ mâ ádrị́pị ꞌi rĩ gá ku yã’? Má idé ị́jọ́ ꞌdĩ mání nị̃jó la ku rĩ sĩ, áma ũnzĩ ꞌdáyụ.” ");
INSERT INTO luc_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ãdróŋá umvi ĩꞌdiní urobí agâ sĩ, “Ãndá, mí idé ị́jọ́ ꞌdĩ íni la míní nị̃jó la ku rĩ sĩ. Má atrị mi ị́jọ́ ũnzí idéjó áma ụrụꞌbá gá rĩ sĩ rá, ãzíla má ãꞌị̃ míní ĩꞌdi alójó ãluŋá la ku. ");
INSERT INTO luc_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Wó úꞌdîꞌda ífẽ ũkú ꞌdĩ ágô drị̂lé vúlé. Ĩꞌdi nábị̃, ĩꞌdi míní Ãdróŋá ãꞌị̃ mi dô sĩ adru ídri, wó ídrĩ ĩꞌdi uja ágô drị̂lé ku, mi ꞌi ãzíla ꞌbá mídrị̂ abe ĩmi ũdrã rá.” ");
INSERT INTO luc_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ãngũsãrã sĩ Ãbị̃mẹ́lẹ̃kị̃ umve ãmbogo ĩꞌdi pálé gá rĩ kí sĩ ị́jọ́ ru idélépi ĩꞌdi rụ́ rĩ kí ũlũjó ĩꞌbaní. Ĩꞌdi mụ kí ũlũlé ꞌbo, uja kí dó idélé ụ̃rị̃ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ꞌDã ꞌbã ũngúkú gá, Ãbị̃mẹ́lẹ̃kị̃ umve Ịbụrahị́mụ̃ ꞌi ãzíla zị ĩꞌdi, “Mí idé dó ãma íni ãꞌdu sĩ? Ị́jọ́ ũnzí mání idélé ími ụrụꞌbá gá rĩ ãꞌdu míní sĩ lẽjó drị̃lẹ́ ũnzĩ ajíjó áma drị̃ gá sụ́rụ́ mádrị̂ abe? Ị́jọ́ ꞌdĩ tátí míní icólé idélé mání ku la.” ");
INSERT INTO luc_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ãbị̃mẹ́lẹ̃kị̃ zị Ịbụrahị́mụ̃ ꞌi, “Ásị́sị́ŋá míní ị́jọ́ ꞌdĩ áni rĩ idéjó rĩ ãꞌdu?” ");
INSERT INTO luc_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ịbụrahị́mụ̃ umvi, “Má ũrã, ‘ꞌBá ãzí ãngũ ꞌdĩ gá ꞌdâ Ãdróŋá ụ̃rị̃lépi rá la ãluŋá la yụ, ị́jọ́ ꞌdĩ sĩ kí áma ꞌdị agá rá sĩ mâ ũkû ꞌdụjó rá.’ ");
INSERT INTO luc_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ĩꞌdi ábị́ ngá má ámvọ́pị mgbã la, má átẹ́pị ꞌbã ĩzóŋá má ụ́kụ́pị ꞌbã ị̃zẹ́pị rú rĩ ꞌi, wó adru mâ ãndrẽ ꞌbã ị̃zẹ́pị mgbã rĩ ꞌi ku, má ĩgbã dô sĩ ĩꞌdi mání ũkú ru rá. ");
INSERT INTO luc_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ãdróŋá la dó mụ áma anzélé má átẹ́pị drị́ko gâlé sĩ mụjó ãmị́yọ́ŋá ꞌbã ãngũ gá ꞌbo, ájọ dó Sárã ní, ‘Mi dó ílẽ ma rá rĩ iꞌda míní jọjó la ꞌbá pírí ꞌbaní, “Ĩꞌdi má ádrị́pị ꞌi rĩ sĩ.”’” ");
INSERT INTO luc_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ꞌDã ꞌbã ũngúkú gá, Ãbị̃mẹ́lẹ̃kị̃ fẽ dó Ịbụrahị́mụ̃ ꞌbã ũkû Sárã ĩꞌdidrị̂lé vúlé, ãzíla fẽ vâ ĩꞌdiní kãbĩlõ, tị́, ãzíla ãtiꞌbo ãgọbị rú rĩ kí ũkú ru rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ãbị̃mẹ́lẹ̃kị̃ jọ Ịbụrahị́mụ̃ ní, “Ãngũ ꞌdĩ pírí mádrị̂ ꞌi, mí uꞌá wókõ la cí ími ásị́ ꞌbã lẽlé rĩ agá.” ");
INSERT INTO luc_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Jọ Sárã ní, “Ma mí ádrị́pị ní séndẽ ífí-ífí la kí fẽ álĩfũ ãlu iꞌdajó la ꞌbá mídrị̂ ꞌbaní ãndá-ãndá ru mi ị́jọ́ kóru, ꞌbá pírí kí dô sĩ nị̃ la mí idé ị́jọ́ ũnzí ku.” ");
INSERT INTO luc_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ꞌDã ꞌbã ũngúkú gá, Ịbụrahị́mụ̃ zị dó Ãdróŋá ꞌi úpí Ãbị̃mẹ́lẹ̃kị̃ nî, Ãdróŋá adrí dó sĩ ĩꞌdi ũkú ĩꞌdidrị̂ be ãzíla ãtiꞌbo ĩꞌdidrị́ izonzi rú rĩ kí abe, ꞌba tị kí dó vâ sĩ anzị kí ị̃dị́ be nĩ, ");
INSERT INTO luc_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ãꞌdusĩku Úpí fẽ ũkú Ãbị̃mẹ́lẹ̃kị̃ drị́ko gá rĩ acá kí úndó ru Ịbụrahị́mụ̃ ꞌbã ũkû Sárã ꞌbã ị́jọ́ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Úpí wi sụ̃sụ́ Sárã ní cécé ĩꞌdi ꞌbã ándrá jọlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sárã ịsụ́ ꞌa, tị dó Ịbụrahị́mụ̃ ní ngọ́tị́ ágọ́bị́ ílí ĩꞌdi ꞌbã adrujó ĩdránígó ru rĩ sĩ. Útị mgbâ cé ụ́ꞌdụ́ Ãdróŋá ꞌbã jọlé ála sĩ ĩꞌdi tị rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ịbụrahị́mụ̃ ꞌda dó ngọ́tị̂ rụ́ Ĩsákã ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ĩsákã ụ́ꞌdụ́ la mụ calé ãrõ ꞌbo, Ịbụrahị́mụ̃ ĩtãrã ĩꞌdi rá cécé ándrá Ãdróŋá ꞌbã azịlé ĩꞌdiní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ịbụrahị́mụ̃ ílí dó ꞌdĩ sĩ 100 sáwã Ĩsákã tịjó ĩꞌdiní rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sárã jọ, “Ãdróŋá ají mání ãyĩkõ ꞌbo! ꞌBá pírí ị́jọ́ ꞌdĩ arelépi rá rĩ kí dó gụ má be.” ");
INSERT INTO luc_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Jọ vâ, “Ãꞌdi icó tátí jọlé la ma Sárã ꞌi má icó tá ngọ́tị́ tịlé Ịbụrahị́mụ̃ ní rá rĩ gá nĩ yã? Wó átị ĩꞌdiní ngọ́tị́ ágọ́bị́ sáwã ĩꞌdi ꞌbã dejó ꞌbo rĩ agá ꞌdâ rá.” ");
INSERT INTO luc_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ngọ́tị̂ zo dó ãzíla únze tị la ĩbã gá rá, ụ́ꞌdụ́ Ĩsákã tị nzejó ĩbã gá rĩ sĩ, Ịbụrahị́mụ̃ ꞌbã ụ̃mụ̃ ãmbógó tẽté la. ");
INSERT INTO luc_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ụ́ꞌdụ́ ãlu Sárã ndre Ịsụmayị́lị̃ Hãgárĩ Mị̃sị́rị̃ rú rĩ ꞌbã tịlé Ịbụrahị́mụ̃ nî rĩ la avá agá ngọ́pị̃ Ĩsákã sĩ, ");
INSERT INTO luc_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ãzíla Sárã jọ Ịbụrahị́mụ̃ ní, “Ípẽ ĩzóŋá ãtíꞌbó ru ꞌdĩ kí tị ngọ́pị̃ be ꞌdâ rá. Lẽ ũkú ꞌdĩ ꞌbã ngọ́pị ꞌba ịsụ́ ãko mídrị́ mâ ngọ́pị Ĩsákã ꞌbã amụ́lé ꞌdụlé rĩ kí agá ꞌdâ ku.” ");
INSERT INTO luc_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ị́jọ́ ꞌdĩ fẽ Ịbụrahị́mụ̃ ásị́ gá ũcõgõ ãmbógó la ãꞌdusĩku Ịsụmayị́lị̃ ꞌbã vâ adrujó ĩꞌdi ꞌbã ngọ́tị́ŋá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Wó Ãdróŋá jọ Ịbụrahị́mụ̃ ní, “Mí adru mgbá ꞌdĩ sĩ ãzíla ĩzóŋá ãtíꞌbó ru Hãgárĩ ꞌbã ị́jọ́ sĩ ũcõgõ sĩ ku. Mí idé ị́jọ́ Sárã ꞌbã jọlé míní rĩ, ãꞌdusĩku ũyõ mání nalé rĩ sĩ anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí ãfũ Ĩsákã rụ̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ma vâ Hãgárĩ ngọ́pị fẽ acálé sụ́rụ́ trũ ãꞌdusĩku ãfũ vâ mí rụ́.” ");
INSERT INTO luc_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ịbụrahị́mụ̃ angá ụ́ꞌdụ́ ãzí rĩ sĩ ãngũsãrã sĩ, fẽ Hãgárĩ ní íná ãzíla ị̃yị́ íníríkó sĩ ị̃yị́ tõjó rĩ agá tré. Nị ngọ́tị́ŋâ ũngúkú la gá ãzíla pẽ dó ĩꞌdi tị mụlé. Hãgárĩ mụ rá ãzíla rĩ dó sĩ wãyá colé kõtórõ ꞌa Bẹ̃rị̃sẹ́bã drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ị̃yị̂ la mụ ukólé pírí ꞌbo, aꞌbe ngọ́tị́ŋâ mị̃rị́ ãzí agá ");
INSERT INTO luc_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ãzíla ngọ́pị̃ rụ́ ꞌdãá rĩ sĩ ri rá-rá ru ãni rú mítã 100. Jọ ĩꞌdiní cénĩ-cénĩ rú, “Má icó mâ ngọ́tị̂ ndrelé drã agá áma mịfị́ sĩ ku.” Ĩꞌdi ꞌbã ri agá ꞌdãá iꞌdó dó awálé. ");
INSERT INTO luc_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ãdróŋá are mgbâ awá agá ãzíla mãlãyíkã Ãdróŋá drị̂ ajọ́ ị́jọ́ angájó ꞌbụ̃ gâlé Hãgárĩ nî, ãzíla jọ, “Hãgárĩ! Ãꞌdu ị́jọ́ fẽ míní ũcõgõ nĩ? Mí idé ụ̃rị̃ sĩ ku. Má are mgbâ ꞌbã áwáŋá rá. ");
INSERT INTO luc_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Mí angá ụrụgá, ímụ mgbâ aꞌdụ́lé ími drị́ gá ãzíla mí ũmŋĩ ásị́ la. Ma ĩꞌdi fẽ acálé sụ́rụ́ ãmbógó la rú anzị ĩꞌdidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌba rụ̂ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá fẽ mịfị́ la nzị̃ dó ru rá ãzíla ndre dô sĩ kídí ãzí. Mụ ị̃yị́ ãtõlé íníríkó ị̃yị́ drị̂ agá ãzíla fẽ ĩꞌdi mvụlé mgbâ nî. ");
INSERT INTO luc_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mgbâ ꞌbã zo agá ꞌdĩ gá ꞌdâ, Ãdróŋá rĩ adrulé ĩꞌdi be; rĩ uꞌálé ãngũ kõtórõ rú Pãránĩ drị̂ gá ãzíla acá ãlị́gọ́ dora gbẹlépi la rú. ");
INSERT INTO luc_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ĩꞌdiní uꞌá agá ãngũ kõtórõ rú Pãránĩ drị̂ gá, ãndrẽ ĩgbã ĩꞌdiní ũkú Mị̃sị́rị̃ ízó ru la. ");
INSERT INTO luc_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ụ́ꞌdụ́ ãlu Ãbị̃mẹ́lẹ̃kị̃ mụ kí ãmbógó ĩꞌdidrị́ ãsĩkárĩ drị́ Fĩkólĩ be ãzíla jọ Ịbụrahị́mụ̃ ní, “Ãdróŋá ĩꞌdi ãko pírí míní idélé rĩ kí agá cí. ");
INSERT INTO luc_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Úꞌdîꞌda lẽ ína ũyõ Ãdróŋá drị̃lẹ́ gá mí icó áma ulélé ku, jõku anzịŋá mádrị̂ kí ãzíla anzị mádrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí ulé lé ku. Mí iꞌda mání sụ́rụ́ míní sĩ mụjó uꞌájó ala gá ãmị́yọ́ŋá ru rĩ, mí icé mání ásị́-ị̃gbẹ̃ cécé mání icélé míní rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ịbụrahị́mụ̃ jọ, “Ána ũyõ, ma idé la rá.” ");
INSERT INTO luc_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ịbụrahị́mụ̃ unu Ãbị̃mẹ́lẹ̃kị̃ drị̃lẹ́ gá ụ̃pị́gọ́ŋá ĩꞌdidrị̂ ꞌbã kí kídî pajó rá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Wó Ãbị̃mẹ́lẹ̃kị̃ jọ, “Ánị̃ ãꞌdi idé ị́jọ́ ꞌdĩ nĩ yã rĩ gá ku. Ílũ vâ mání ị́jọ́ ꞌdĩ ku, drĩ gápi mâ arelé ími tị gá ãndrũ ꞌdĩ.” ");
INSERT INTO luc_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ị́jọ́ ꞌdĩ sĩ Ịbụrahị́mụ̃ ají dó kãbĩlõ kí tị́ be ãzíla fẽ dó kí Ãbị̃mẹ́lẹ̃kị̃ drị́. ꞌBá ị̃rị̃ ꞌdĩ icí kí dó tị rá. ");
INSERT INTO luc_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ịbụrahị́mụ̃ uya kãbĩlõ ĩꞌdidrị́ ũꞌbí rĩ kí agá kãbĩlõmvá ãrónĩ la kí ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ãbị̃mẹ́lẹ̃kị̃ zị Ịbụrahị́mụ̃ ꞌi, “Ị́jọ́ míní kãbĩlõmvá ázị̂rị̃ ꞌdĩ kí uyajó rĩ ꞌbã ífí íngoní yã?” ");
INSERT INTO luc_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ịbụrahị́mụ̃ umvi ĩꞌdiní, “Mí aꞌị́ kãbĩlõ ázị̂rị̃ ꞌdĩ kí áma drị́ gá ꞌdâ icéjó la ága kídí ꞌdĩ ma ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ãngũ ꞌdã ála dô sĩ ĩꞌdi umve Bẹ̃rị̃sẹ́bã ꞌi ãꞌdusĩku ãgọbị ị̃rị̃ ꞌdĩ icí kí tị ala gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tị icíma Bẹ̃rị̃sẹ́bã gá ꞌdã vúlé gá, Ãbị̃mẹ́lẹ̃kị̃ kí ãsĩkárĩ ãmbógó ĩꞌdidrị́ Fĩkólĩ be uja kí ru mụlé ãngũ Fị̃lị̃sị̃tị́nị̃ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ịbụrahị́mụ̃ sa ị́tị́ Bẹ̃rị̃sẹ́bã gá ꞌdãá, ãzíla ịcụ́ dó sĩ Úpí Ãdróŋá jãꞌdâ rĩ rụ́ ãngũ ꞌdã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ịbụrahị́mụ̃ uꞌá dó ãngũ Fị̃lị̃sị̃tị́nị̃ drị̂ gá ụ́ꞌdụ́ ãzo rú. ");
INSERT INTO luc_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ụ́ꞌdụ́ ãzí vúlé gá Ãdróŋá ụ̃ꞌbị̃ Ịbụrahị́mụ̃ ꞌi; umve ĩꞌdi, “Ịbụrahị́mụ̃!” Ịbụrahị́mụ̃ ãꞌị̃ dó, “Ma ꞌdõ!” ");
INSERT INTO luc_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ, “Íꞌdụ mî ngọ́pị kílímgbí Ĩsákã míní lẽlé ambamba rĩ ꞌi, ímụ ĩꞌdi trũ ãngũ Mọ̃rị́yã gá. Ífẽ ĩꞌdi mání ídétáŋá ru ꞌbé mání mụlé lũlé míní rĩ ꞌbã drị̃ gá.” ");
INSERT INTO luc_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ịbụrahị́mụ̃ angá dó ãngũsãrã ụ́ꞌdụ́ ãzí rĩ drị̂ sĩ, asi ijijá sĩ ídétáŋá idéjó rĩ kí, ꞌbã dó kí kãyĩnõ ĩꞌdidrị̂ drị̃ gá, ãzíla ꞌdụ dó ngọ́pị̃ Ĩsákã kí ãtíꞌbó ị̃rị̃ la kí abe. Ko kí dó drị̃ mụlé ãngũ ándrá Ãdróŋá ꞌbã lũlé ĩꞌdinî rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ụ́ꞌdụ́ na ãcị̃ ꞌdã drị̂ sĩ Ịbụrahị́mụ̃ ndre dó ãngũ ꞌdã rá-rá ru. ");
INSERT INTO luc_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Jọ dó ãtíꞌbó ĩꞌdidrị̂ ꞌbaní, “Ĩmi adru kãyĩnõ ꞌdĩ trũ ꞌdâ. Ãma drĩ mụ mgbâ be Ãdróŋâ ị̃nzị̃lé lé, ꞌdã ꞌbã ũngúkú gá ãma dó ãgõ ĩmi rụ́ ꞌdõlé ĩndõ.” ");
INSERT INTO luc_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ịbụrahị́mụ̃ fẽ ngọ́pị̃ Ĩsákã ꞌdụ ijijá ídétáŋá drị̂ kí nĩ ãzíla ꞌdụ dó ĩꞌdidrị́ gá ménéŋá kí ãcí be. Ĩꞌbaní mụ agá ị̃rị̃trá ãngũ ãlu gá ꞌdĩ gá ꞌdâ, ");
INSERT INTO luc_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ĩsákã jọ átẹ́pị̃ Ịbụrahị́mụ̃ ní, “Má átẹ́pị!” Ịbụrahị́mụ̃ ãꞌị̃ dó, “Ma ꞌdõ, mâ ngọ́pị!” Ĩsákã zị ĩꞌdi, “Ándre íꞌdụ ijijá kí ãcí be rá, wó kãbĩlõmvá ídétáŋá idéjó rĩ dó íngãá yã?” ");
INSERT INTO luc_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ịbụrahị́mụ̃ umvi ĩꞌdiní, “Ãdróŋá ꞌbã ãmgbã rĩ la kãbĩlõ mvâ fẽ rá.” Ị́jọ́ ꞌdĩ sĩ mụ kí dó ị̃rị̃trá ãngũ ãlu gá. ");
INSERT INTO luc_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kí dó mụ calé ãngũ Ãdróŋá ꞌbã lũlé ĩꞌdiní rĩ gá ꞌbo, Ịbụrahị́mụ̃ sị dó ãlĩtárĩ ãzíla ũꞌbã dó ijijá kí drị̃ la gá. Umbé dó ngọ́pị̃ Ĩsákã ꞌi, ꞌbã dó ĩꞌdi ãlĩtárĩ drị̃ gá ijijá kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ꞌDã ꞌbã ũngúkú gá, Ịbụrahị́mụ̃ anzé dó ménéŋá rãwũ tí sĩ ngọ́pị̃ Ĩsákã lịjó. ");
INSERT INTO luc_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Wó mãlãyíkã Úpí drị̂ umve ĩꞌdi angájó ꞌbụ̃ gâlé, “Ịbụrahị́mụ̃! Ịbụrahị́mụ̃!” Ịbụrahị́mụ̃ ãꞌị̃ dó, “Ma ꞌdõ.” ");
INSERT INTO luc_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mãlãyíkã jọ, “Ísu drị́ mgbâ ụrụꞌbá gá ku ãzíla mí idé ãko ãzí ĩꞌdi ụrụꞌbá gá ku. Ánị̃ dó ãndrũ íru Ãdróŋá mídrị̂ rá rĩ gá rá ãꞌdusĩku mí uga mî ngọ́pị ãlu kílímgbí ꞌdĩ ĩꞌdiní ku.” ");
INSERT INTO luc_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ịbụrahị́mụ̃ undré ãngũ ĩꞌdi andre gá ꞌdãá ndre kãbĩlógó újé la gĩ mị̃rị́ agá. Mụ ĩꞌdi aꞌdụ́lé ãzíla fẽ ĩꞌdi ídétáŋá ivélé ivê rĩ rú ngọ́pị ꞌbã kẹ̃jị́ gá. ");
INSERT INTO luc_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ị́jọ́ ꞌdĩ sĩ Ịbụrahị́mụ̃ ꞌda dó ãngũ ꞌdã rụ́, Úpí la fẽ la rá ꞌi, kpere ãndrũ ꞌbá kí jọ la, “ꞌBé Úpí drị̂ drị̃ gá ĩꞌdi fẽ la rá.” ");
INSERT INTO luc_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Mãlãyíkã Úpí drị̂ umve Ịbụrahị́mụ̃ angájó ꞌbụ̃ gâlé pâlékó ị̃rị̃ la sĩ, ");
INSERT INTO luc_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ãzíla Úpí jọ, “Ána ũyõ áma mgbã rĩ ꞌbã rụ́ sĩ ꞌdĩ áni, ma rú míní sụ̃sụ́ wi ãmbógó ru ãꞌdusĩku míní ị́jọ́ ꞌdĩ idéjó rĩ sĩ ãzíla míní mî ngọ́pị kílímgbí ꞌdĩ ugajó mání ku rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ma míní sụ̃sụ́ wi ãzíla ma anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí fẽ adrulé wẽwẽ rú cécé lẽlẽgó ụrụgá rĩ kî áni ãzíla cínákí mĩrĩ tị gá rĩ áni. Anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí rú mụ mẹ́rọ́ꞌbá ĩꞌbadrị̂ kí ndẽlé rá, ãzíla kí ãngũ ĩꞌbãdrị̂ ꞌdụ rá. ");
INSERT INTO luc_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌba rụ̂ sĩ ma sụ̃sụ́ wi Sụ́rụ́ pírí ꞌbaní ãꞌdusĩku míní áma tị arejó rá rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ꞌDã ꞌbã ũngúkú gá, Ịbụrahị́mụ̃ uja dó ru vúlé ãtíꞌbô ꞌba rụ̂lé ãzíla mụ kí dó ãngũ ãlu gá Bẹ̃rị̃sẹ́bã gâlé. Ịbụrahị́mụ̃ ri dó uꞌálé Bẹ̃rị̃sẹ́bã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Sáwã ãzí vúlé gá Ịbụrahị́mụ̃ are Mílĩkã tị anzị kí ádrị́pị̃ Nãhọ́rị̃ ní ãrõ: ");
INSERT INTO luc_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ụ́zị̃ ĩꞌdi ngọ́tị́ kãjãní rĩ, ꞌBụ́zị̃ ꞌi Ụ́zị̃ ꞌbã ádrị́pị̃, Kẹ̃mụ̃wẹ́lị̃ ꞌi Ãrámũ ꞌbã átẹ́pị ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kẹ̃sẹ́dị̃ ꞌi, Házõ ꞌi, Pĩlĩdásĩ ꞌi, Yĩdĩláfũ ꞌi, ãzíla Bẹ̃tụ́wẹ́lị̃ ꞌi ");
INSERT INTO luc_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bẹ̃tụ́wẹ́lị̃ tị Rẽbékã ꞌi. Mílĩkã tị anzị ãgọbị ãrõ ꞌdĩ kí Ịbụrahị́mụ̃ ꞌbã ádrị́pị Nãhọ́rị̃ nî. ");
INSERT INTO luc_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ũkú ĩꞌdidrị́ ãtíꞌbó ru umvelé Rẹ̃wụ́mã ꞌi rĩ tị ĩꞌdiní: Tébã ꞌi, Gãhámụ̃ ꞌi, Tãhásĩ ꞌi ãzíla Mákã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sárã uꞌá ụ̃nọ́kụ́ drị̃ gá ꞌdâ ílí 127. ");
INSERT INTO luc_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sárã drã dó Hẹ̃bụ̃rọ́nị̃ gá ꞌdĩ ãngũ Kãnánĩ drị̂ gá ãzíla Ịbụrahị́mụ̃ awá ĩꞌdi ꞌbã drã ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ꞌDã ꞌbã ũngúkú gá, Ịbụrahị́mụ̃ aꞌbe ãvũ ũkû drị̂ vụ̃rụ́ ꞌdãá, mụ ꞌbá Hị́tị̃ rú rĩ ꞌba rụ́ jọ, ");
INSERT INTO luc_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ma ĩmi drĩdríŋĩ gá ꞌdâ ãmị́yọ́ŋá; ĩmi uzị mání ãngũ ãzí mání sĩ icójó mâ ũkû ꞌbã ãvũ ị̃sị̃jó rá la.” ");
INSERT INTO luc_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ꞌBá Hị́tị̃ rú rĩ umvi kí Ịbụrahị́mụ̃ ní, ");
INSERT INTO luc_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ãmbógó, mí are ị́jọ́ ãma tị gá rĩ. Mi úpímvá ãmbógó la ãma drĩdríŋĩ gá ꞌdâ; ípẽ ụ̃jị́gọ́ ãzí ũniyambamba la sĩ mî ũkû ꞌbã ãvũ ị̃sị̃jó ãngũ ãmadrị́ ꞌdĩ agá ꞌdâ. ꞌBá ãzí ãma drĩdríŋĩ gá ꞌdâ icólépi míní ꞌbụ́ ugalépi míní sĩ ãvũ ị̃sị̃jó la ꞌdá yụ.” ");
INSERT INTO luc_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ꞌDã ꞌbã ũngúkú gá, Ịbụrahị́mụ̃ ilú drị̃ vụ̃rụ́ ꞌbá Hị́tị̃ rú rĩ kí drị̃lẹ́ gá, ");
INSERT INTO luc_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","jọ, “Ĩdrĩ ãꞌị̃ ásị́ pírí sĩ mání sĩ mâ ũkû ꞌbã ãvũ ị̃sị̃jó ꞌdâ rá yã áni, ĩzị mání Zõhárĩ ngọ́pị Ífĩrõnĩ ꞌi áma kẹ̃jị́ gá sĩ ");
INSERT INTO luc_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","mání ụ̃jị́gọ́ Mãkĩpélã gá adrulépi ĩꞌdidrị́ ámvụ́ tị gá rĩ ụzịjó. Ĩzị mání ĩꞌdi ãngũ ꞌdĩ ụzịjó ãjẹ̃ ãngũ ꞌdĩ drị́ pírí rĩ sĩ ĩminí adru agá ꞌdâ cí ꞌdĩ gá ꞌdĩ, ĩꞌdi dô sĩ adru ãngũ mání ꞌbá mádrị̂ kí ị̃sị̃jó rĩ rú.” ");
INSERT INTO luc_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ífĩrõnĩ ꞌbã ãmgbã rĩ ri vâ kẹ̃jị́tị táwụ̃nị̃ ꞌbá Hị́tị̃ rú rĩ ꞌbaní ru trajó rĩ gá ꞌdãá ĩndĩ; ãzíla umvi ị́jọ́ Ịbụrahị́mụ̃ ní ꞌbá pírí Hị́tị̃ rú ꞌdãá rĩ kí drị̃ gâsĩ; ");
INSERT INTO luc_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Yụ ãmbógó mádrị̂ mí are drĩ ma; ma míní ãngũ ámvụ́ ru ꞌdã fẽ pírí ụ̃jị́gọ́ ala gá rĩ trũ ị̃sálị, ꞌbá mádrị́ ꞌdĩ kí drị̃ gâsĩ ma ãngũ ꞌdĩ fẽ míní rá, mi dô sĩ mî ũkû ꞌbã ãvũ ị̃sị̃.” ");
INSERT INTO luc_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ꞌDã ꞌbã ũngúkú gá, Ịbụrahị́mụ̃ ilú drị̃ vụ̃rụ́ ꞌbá Hị́tị̃ rú rĩ kí drị̃lẹ́ gá ị̃dị́ ");
INSERT INTO luc_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ãzíla jọ Ífĩrõnĩ ní ꞌbá pírí ꞌdãá rĩ kí drị̃ gâsĩ, “Mí are drĩ ma ídrĩ icó rá rĩ gá. Ma ámvụ́ ꞌdĩ ꞌbã ãjẹ̃ ũfẽ pírí rá. Mí ãꞌị̃ ũfẽŋá mání lẽlé ũfẽlé ꞌdĩ ꞌi, ma dô sĩ ũkú mádrị̂ ꞌbã ãvũ ị̃sị̃ ꞌdãá.” ");
INSERT INTO luc_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ífĩrõnĩ umvi Ịbụrahị́mụ̃ ní jọ, ");
INSERT INTO luc_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ãmbógó mádrị̂ mí are drĩ ma, ãngũ ꞌdĩ ꞌbã ãjẹ̃ lú Sẹ̃kẹ́lị̃ sílĩvã rú 400, wó ꞌdĩ la ãmaní mí be ãꞌdu idé? Mí ị̃sị̃ mî ũkû ꞌbã ãvũ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ịbụrahị́mụ̃ ãꞌị̃ ãjẹ̃ Ífĩrõnĩ ꞌbã lịlẹ́ rĩ rá ãzíla ụ̃ꞌbị̃ dó séndẽ tá ĩꞌdiní lẽlé ꞌdã ꞌi ꞌbá Hị́tị̃ rú rĩ kí drị̃ gâsĩ: Sẹ̃kẹ́lị̃ sílĩvã rú 400 ꞌdĩ ãko séndẽ ụ̃ꞌbị̃jó ꞌbá bĩsírã idélépi sáwã ꞌdã sĩ rĩ ꞌbadrị̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ị́jọ́ ꞌdĩ sĩ, ãngũ Ífĩrõnĩ drị́ Mãkĩpélã gá Mãmírẽ andre gá rĩ ámvụ́ la kí ụ̃jị́gọ́ la ala gá rĩ be ãzíla ife pírí ala gá ꞌdãá rĩ abe acá kî dó Ịbụrahị́mụ̃ ꞌbã ãko rú. ");
INSERT INTO luc_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ꞌBá pírí Hị́tị̃ rú ru tralépi ꞌdãá rĩ nị̃ kí dó tọndọlọ rá ãngũ ꞌdã dó Ịbụrahị́mụ̃ ãni. ");
INSERT INTO luc_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ꞌDã ꞌbã vúlé gá Ịbụrahị́mụ̃ ị̃sị̃ dó ũkû Sárã ꞌi ụ̃jị́gọ́ ãngũ Mãkĩpélã ꞌdĩ Mãmírẽ (umvelé Hẹ̃bụ̃rọ́nị̃ ꞌi rĩ) ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá ꞌdĩ Kãnánĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ị́jọ́ ꞌdĩ sĩ, ámvụ́ ándrá ꞌbá Hị́tị̃ rú rĩ ꞌbadrị́ ãzíla ụ̃jị́gọ́ la ala gá rĩ be rĩ acá kí dó sĩ ãko Ịbụrahị́mụ̃ ãni la rú sĩ ꞌbá ị̃sị̃jó. ");
INSERT INTO luc_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ịbụrahị́mụ̃ acá dó ãmbá ru ãzíla ílí trũ ũꞌbí ru ãzíla Úpí wi dó ĩꞌdiní sụ̃sụ́ ãko pírí ĩꞌdi ꞌbã idélé rĩ kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ịbụrahị́mụ̃ jọ dó ãtíꞌbó ãmbógó ãko ĩꞌdidrị̂ kí drị̃lẹ́ gá pírí rĩ ní, “Ísu ími drị́ áma pálé gá. ");
INSERT INTO luc_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Álẽ ína ũyõ Úpí Ãdróŋá ꞌbụ̃ kí ꞌbãlépi ụ̃nọ́kụ́ be rĩ ꞌbã rụ́ sĩ, mí icó fẽlé la mâ ngọ́pị ní ũkú Kãnánĩ ízó ru la ĩgbãlé ku. ");
INSERT INTO luc_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Lẽ ímụ ãngũ ándrá mání sĩ ãfũjó rĩ gá mâ kãká ꞌba rụ̂lé, mí ịsụ́ dó sĩ ũkú mâ ngọ́pị Ĩsákã ní ala gá ꞌdãá.” ");
INSERT INTO luc_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ãtíꞌbô zị ĩꞌdi, “Wó ĩzóŋâ drĩ dó lẽ lị́cọ́ ĩꞌbadrị̂ aꞌbelé sĩ amụ́jó má be ãngũ ꞌdĩ gá ꞌdõlé ku rĩ gá? Ma dó mî ngọ́pị agụ vúlé ãngũ míní sĩ angájó rĩ gâlé yã?” ");
INSERT INTO luc_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ịbụrahị́mụ̃ umvi ĩꞌdiní, “Índre múké-múké álẽ mí uja mâ ngọ́pị vúlê lé ku! ");
INSERT INTO luc_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Úpí Ãdróŋá ꞌbụ̃ kí ꞌbãlépi ụ̃nọ́kụ́ be, ándrá áma anzélépi angájó má átẹ́pị drị́ lị́cọ́ gâlé rĩ na ándrá ũyõ ãngũ ꞌdĩ fẽjó anzị mádrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbanî. Ĩꞌdi mãlãyíkã tị pẽ mụlé ími drị̃lẹ́ gá, mi dô sĩ ũkú ịsụ́ mâ ngọ́pị ní ãngũ ꞌdã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ĩzóŋâ drĩ lẽ amụ́lé mí be ku, átrũ mi ũyõ míní nalé rĩ agá rá, wó álẽ mí uja mâ ngọ́pị vúlê lé ku.” ");
INSERT INTO luc_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ị́jọ́ ꞌdĩ sĩ ãtíꞌbó Ịbụrahị́mụ̃ drị̂ su dó drị́ úpí ĩꞌdidrị̂ pálé gá, na dô sĩ ũyõ ãꞌị̃ dó ị́jọ́ Ịbụrahị́mụ̃ ꞌbã jọlé ĩꞌdiní rĩ ngalé rá. ");
INSERT INTO luc_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ãtíꞌbó Ịbụrahị́mụ̃ drị́ ãmbógó rĩ ũdrõ dó ãko ãlá-ãlá la kí ngãmíyã mụdrị́ ãmbógó ĩꞌdidrị̂ drị̂ kí drị̃ gá ãzíla mụ dô sĩ Mẽsõpõtámĩyã gá táwụ̃nị̃ Nãhọ́rị̃ ꞌbã sĩ uꞌájó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ĩꞌdi dó mụ calé ꞌbo, fẽ dó ngãmíyã ula kí ru ĩndróloŋá sĩ vụ̃rụ́ kídí tị gá ãmvé-ãmvélé ru ꞌdĩ sĩ úfi drĩ táwụ̃nị̃ agâlé ku rú sáwã ũkú ꞌbaní amụ́jó ị̃yị́ kojó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ꞌDã ꞌbã ũngúkú gá, zị Ãdróŋá ꞌi, “Úpí Ãdróŋá ãmbógó mádrị́ Ịbụrahị́mụ̃ drị̂, ífẽ mání ãndrũ drị̃lẹ́ba ãzíla mí iꞌda ásị́ ị̃gbẹ̃ ãmbógó mádrị́ Ịbụrahị́mụ̃ nî. ");
INSERT INTO luc_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Índre, átu pá kídí tị gá izonzi ãmụrụgọ rú ꞌbá táwụ̃nị̃ ꞌdĩ agá rĩ ꞌbadrị̂ ꞌbã kí ị̃yị́ kojó rĩ gá ꞌdõ. ");
INSERT INTO luc_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ádrĩ jọ la ãlu la ní, ‘Mí ilú mání kére ị̃yị́ drị́ gá ꞌdĩ ꞌi, ꞌbárĩ ífẽ mání ị̃yị́ ala gá ꞌdĩ mvụlé fô.’ Drĩ jọ la, ‘Ímvụ, ãzíla ma ị̃yị́ ãbĩ ngãmíyã mídrị̂ ꞌbaní ĩndĩ,’ ꞌdĩ la dó ꞌbã sĩ adru ĩzóŋá míní pẽlé ãtíꞌbó mídrị́ Ĩsákã ní ũkú ru rĩ ꞌi. Drĩ dó ru idé ꞌdĩ ꞌbã áni rá, ma dó nị̃ la ímba ị́jọ́ míní azịlé ãmbógó mádrị̂ ní rĩ ꞌbã tã rá rĩ gá rá.” ");
INSERT INTO luc_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","De drĩ Ãdróŋá zị agá ku rú, Rẽbékã acá kére ị̃yị́ drị̂ trũ kọ́trọ́ gá. Ĩꞌdi Bẹ̃tụ́wẹ́lị̃ ị̃zẹ́pị Ịbụrahị́mụ̃ ádrị́pị Nãhọ́rị̃ ngọ́pị Mílĩkã ꞌbã tịlé rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ĩꞌdi ĩzóŋá ãráŋá bíkĩrã rú ũniyambamba la. Fi dó kídí agâlé, tõ dó ị̃yị́ kére gá tré, ãfũ dô trũ ãmvé ꞌdõlé. ");
INSERT INTO luc_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ãtíꞌbô afụ dó ru ĩꞌdi rụ̂lé jọ, “ꞌBárĩ ífẽ mání mî ị̃yị́ kére agá ꞌdĩ mvụlé wereŋá ru fô.” ");
INSERT INTO luc_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ĩzóŋâ jọ, “Ãmbógó ímvụ.” Gbõgbõ ĩzóŋâ inga dó kére ĩꞌdi kọ́trọ́ gá rĩ vụ̃rụ́ ãzíla fẽ dó sĩ ĩꞌdiní ị̃yị̂ mvụlé. ");
INSERT INTO luc_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ĩꞌdi dó mụ ị̃yị́ fẽlé mvụlé ĩꞌdiní ꞌbo jọ dó, “Ma vâ mụ ị̃yị́ ãbĩlé ngãmíyã mídrị́ ꞌdĩ ꞌbaní mvụlé kpere ĩꞌbaní aga agá.” ");
INSERT INTO luc_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ị́jọ́ ꞌdĩ sĩ ũsũ ị̃yị̂ ị́mbị́ mbẽlẽŋá ru ãkójó ngãmíyã ꞌbaní ị̃yị́ mvụjó rĩ agá, cẹ̃ dó kídí gâlé ị̃yị́ ukolé kpere ngãmíyã ꞌbã kí ị̃yị́ mvụ agá pírí. ");
INSERT INTO luc_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ãtíꞌbô rĩ dó ĩzóŋá ꞌdĩ nị̃lé kíríkírí ru, ndrejó la Úpí fẽ dó íní drị̃lẹ́ba ꞌbo yã rĩ. ");
INSERT INTO luc_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ngãmíyã kí mụ ị̃yị́ delé mvụ agá ꞌbo, ágọ́bị̂ aꞌdụ́ fõrĩfõrĩŋá ãzíla su ĩꞌdi ũmvu la gá, aꞌdụ́ vâ ríŋĩ gólũdĩ rú pãrã-pãrã la kí ị̃rị̃ sulé drị́ ũte la gá. ");
INSERT INTO luc_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Uja dó ĩꞌdi zịlé, “Mi ãꞌdi ị̃zẹ́pị ꞌi yã? ꞌBárĩ ílũ mánî fô; ãngũ ãzí mání sĩ kojó mâ ꞌbá ꞌdĩ kí abe ãzíla ãko má ãni ꞌdĩ kí abe la ĩmi drị́ko gâlé cí yã?” ");
INSERT INTO luc_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ĩzóŋâ umvi ĩꞌdiní, “Ma ngọ́tị́ŋá Mílĩkã ꞌbã tịlé Nãhọ́rị̃ ní Bẹ̃tụ́wẹ́lị̃ ꞌbã ị̃zẹ́pị ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Jọ vâ, “Ãma drị́ko gá ꞌdãá ãná céke ãnãkpá ꞌbaní sĩ ru ulajó drị̃ la gá ãzíla ãkónã ãnãkpá ꞌbaní nalé rĩ cí, ãngũ ĩminí sĩ uꞌájó ãzíla ụ́ꞌdụ́ kojó rĩ vâ cí.” ");
INSERT INTO luc_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ágọ́bị̂ tị̃ ãja, ilú drị̃ vụ̃rụ́ sĩ Úpí ị̃nzị̃jó ãrútáŋá sĩ. ");
INSERT INTO luc_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Jọ, “Má ịcụ́ Úpí Ãdróŋá ãmbógó mádrị́ Ịbụrahị́mụ̃ drị̂ ꞌbã rụ́. Ĩꞌdi ꞌbã ị́jọ́ ĩꞌdiní azịlé rĩ tãmbajó ãꞌị̃táŋá sĩ ãmbógó mádrị̂ ní rĩ sĩ. Úpí aꞌdé áma drị̃ gẹ̃rị̃ gâsĩ pịrị kãká ãmbógó mádrị̂ drị̂ ꞌba rụ́.” ");
INSERT INTO luc_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ĩzóŋâ cẹ̃ dó ụ́ngụ́ sĩ mụlé ị́jọ́ ru idélépi rĩ kí vú nzelé ꞌbá ĩꞌbadrị́ko gá rĩ ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rẽbékã ꞌbã ádrị́pị Lábãnĩ afụ dó ru cẹ̃lé ãtíꞌbó Ịbụrahị́mụ̃ drị̂ rụ́ kídí tị gâlé. ");
INSERT INTO luc_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Idé ị́jọ́ ꞌdĩ íni la ĩꞌdi ꞌbã fõrĩfõrĩŋá ámvọ́pị̃ ꞌbã ũmvu gá ãzíla ríŋĩ pãrã-pãrã drị́ ũte la gá rĩ kí ndrejó ãzíla ị́jọ́ ágọ́bị̂ ꞌbã jọlé ámvọ́pị̃ Rẽbékã ꞌbã lũlé rĩ kí arejó rĩ sĩ. Lábãnĩ mụ dó sĩ ágọ́bị̂ rụ̂lé ãzíla ịsụ́ dó tu pá ngãmíyã kí andre gá kídí tị gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Lábãnĩ jọ ĩꞌdiní, “Mí amụ́ lị́cọ́ gá, mi ꞌbá Úpí ꞌbã sĩ sụ̃sụ́ wijó drị̃ la gá ꞌbo la. Ítu pá ãmvélé ꞌdõlé íni la ãꞌdu ị́jọ́ sĩ yã? Má idé míní jó sĩ ụ́ꞌdụ́ kojó ãzíla ãngũ ngãmíyã kí sĩ ụ́ꞌdụ́ kojó rĩ kí bábá ꞌbo.” ");
INSERT INTO luc_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ị́jọ́ ꞌdĩ sĩ ágọ́bị̂ fi dó lị́cọ́ agâlé, Lábãnĩ ayụ dó tẹ́rị́ ngãmíyã kí ũngúkú gá rĩ kí rá. Fẽ dó ĩꞌbaní ãkónã nalé ãzíla fẽ dó ị̃yị́ ãtíꞌbó Ịbụrahị́mụ̃ drị̂ ní ꞌbá ĩꞌdidrị̂ abe sĩ pá ũjĩjó. ");
INSERT INTO luc_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ála mụ íná ajílé ĩꞌbaní ꞌbo, ágọ́bị̂ jọ, “Ána drĩ íná ku kpere mání ị́jọ́ tá mání amụ́jó rĩ jọ agá ráká.” Lábãnĩ jọ, “Múké, ínze ãmaní ị́jọ́ míní amụ́jó rĩ vú.” ");
INSERT INTO luc_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ágọ́bị̂ jọ, “Ma ãtíꞌbó Ịbụrahị́mụ̃ drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Úpí wi sụ̃sụ́ ãmbógó mádrị̂ ní ĩyõ rú ĩꞌdi dô sĩ málĩ trũ. Fẽ ĩꞌdiní málĩ kí kãbĩlõ, ị̃ndrị́, tị́ ãzíla málĩ gólũdĩ, sílĩvã, ãtíꞌbó ãgọbị rú ãzíla ũkú ru rĩ kí, ngãmíyã ãzíla kãyĩnõ kî trũ. ");
INSERT INTO luc_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ãmbógó mádrị́ Ịbụrahị́mụ̃ ꞌbã ũkû Sárã tị ĩꞌdiní ngọ́tị́ ꞌdĩ sĩ ĩꞌdi dó ãmbá ru, ãzíla fẽ dó ãko ĩꞌdidrị̂ kí pírí ngọ́pị̃ nî. ");
INSERT INTO luc_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ãmbógó mádrị̂ fẽ mání ũyõ nalé jọ, ‘Lẽ ífẽ mâ ngọ́pị ní ũkú ĩgbãlé ãngũ Kãnánĩ drị́ mání sĩ uꞌájó ala gá ꞌdĩ gá ꞌdâ ku. ");
INSERT INTO luc_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Wó ímụ rá la ꞌbá mâ átẹ́pị drị̂ ꞌba rụ́ ãzíla mí ịsụ́ mâ ngọ́pị ní ũkú angájó kãká mádrị̂ kí agá.’ ");
INSERT INTO luc_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Má uja dó ãmbógó mádrị̂ zịlé, ‘Wó ĩzóŋâ drĩ dó gã amụ́lé má be úmgbé rĩ gá?’ ");
INSERT INTO luc_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Umvi mání, ‘Úpí mání tị arelé ụ́ꞌdụ́ pírí rĩ la Mãlãyíkã ĩꞌdidrị̂ tị pẽ mí be, mi adru drị̃lẹ́ba rú. Mi ũkú ĩgbã mâ ngọ́pị ní kãká mádrị̂ kí agá, angájó jó má átẹ́pị drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ꞌDã ꞌbã ũngúkú gá, ídrĩ dó mụ ꞌbá mâ kãká ru rĩ ꞌba rụ́, drĩ kí ĩzóŋâ fẽ amụ́lé ku la nĩ yã áni, átrũ mi ũyõ míní nalé rĩ agá rá.’ ");
INSERT INTO luc_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ma tá ãndrũ mụ acálé kídí tị gá ꞌdãá ꞌbo, ázị ị́jọ́ ájọ, ‘Úpí Ãdróŋá ãmbógó mádrị́ Ịbụrahị́mụ̃ drị̂ drĩ tá icó rá ꞌbá rĩ ífẽ mání drị̃lẹ́ba ị́jọ́ mání amụ́jó ꞌdĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Índre átu pá kídí ꞌdĩ tị gá ꞌdõ, ĩzóŋá ãzí bíkĩrã rú la drĩ amụ́ ị̃yị́ kolé, ádrĩ jọ la ꞌbã ãfẽ mání ị̃yị́ mvụlé kére ĩꞌdidrị́ ꞌdĩ agá, ");
INSERT INTO luc_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","drĩ jọ la ꞌẽ ímvụ, ꞌi vâ fẽ la ngãmíyã mádrị̂ ꞌbaní ĩndĩ, lẽ ꞌbã adru dó ĩzóŋá Úpí ꞌbã pẽlé ãmbógó mádrị́ Ịbụrahị́mụ̃ ꞌbã ngọ́pị ní rĩ ꞌi.’ ");
INSERT INTO luc_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Áde drĩ Ãdróŋá ãꞌị̃ agá áma ásị́ gâlé ku rú, gbõgbõ Rẽbékã acá cí kére trũ ĩꞌdi kọ́trọ́ gá, fi dó kídí agâlé ị̃yị́ ãbĩlé, ájọ ĩꞌdiní, ‘ꞌBárĩ mí ãfẽ mání ị̃yị́ mvụlé fô.’ ");
INSERT INTO luc_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Gbõgbõ ĩzóŋâ ilú dó kére ĩꞌdi kọ́trọ́ gâlé jọ, ‘Ímvụ, ma vâ uko la ngãmíyã mídrị̂ ꞌbaní ĩndĩ,’ ámvụ dó ị̃yị̂ rá ãzíla ĩzóŋâ fẽ dó vâ ị̃yị́ mvụlé ngãmíyã ꞌbaní ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ázị dó ĩꞌdi, ‘Mi ãꞌdi ị̃zẹ́pị ꞌi yã?’ Umvi, ‘Ma ngọ́tị́ŋá Mílĩkã ꞌbã tịlé Nãhọ́rị̃ ní Bẹ̃tụ́wẹ́lị̃ ꞌbã ị̃zẹ́pị ꞌi.’ ꞌDã ꞌbã ũngúkú gá, ágĩ dó fõrĩfõrĩŋá ũmvu la gá ãzíla ásu dó ríŋĩ kí drị́ ũte la gá. ");
INSERT INTO luc_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ꞌDã ꞌbã ũngúkú gá, átị̃ dó ãja ãzíla má ilú drị̃ vụ̃rụ́ sĩ Úpí ị̃nzị̃jó ãrútáŋá sĩ. Má ịcụ́ Úpí Ãdróŋá ãmbógó mádrị́ Ịbụrahị́mụ̃ drị̂ ꞌi ĩꞌdi ꞌbã áma drị̃ aꞌdéjó pịrị ꞌbá ãmbógó mádrị̂ drị̂ ꞌba rụ́ ádrị́pị̃ ꞌbã ĩzóŋá ĩgbãjó ngọ́pị̃ nî rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Úꞌdîꞌda ílũ mání ãꞌị̃táŋá sĩ ãzíla ásị́ ị̃gbẹ̃ sĩ ị́jọ́ ãmbógó mádrị̂ ꞌbã áma tị ãpẽjó ꞌdĩ icó rá yã jõku yụ, ma dó sĩ nị̃ la ma ãꞌdu idé yã rĩ gá ĩndõ.” ");
INSERT INTO luc_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lábãnĩ kí Bẹ̃tụ́wẹ́lị̃ be umvi kí ĩꞌdiní, “ꞌdĩ ị́jọ́ angálépi Úpí drị́ rĩ ꞌi ãma icó ị́jọ́ ujalé ala gá ãluŋá la ku. ");
INSERT INTO luc_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rẽbékã ĩꞌdi ꞌdĩ, íꞌdụ ĩꞌdi ímụ trũ, mí agụ ĩꞌdi, ꞌba acá ãmbógó mídrị̂ ꞌbã ngọ́pị ꞌbã ũkú ru cécé Úpí ꞌbã jọlé rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ãtíꞌbó Ịbụrahị́mụ̃ drị̂ la mụ ị́jọ́ ꞌdĩ arelé ꞌbo, tị̃ ãja ãzíla su tị vụ̃rụ́ sĩ Úpí ị̃nzị̃jó. ");
INSERT INTO luc_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ãtíꞌbó Ịbụrahị́mụ̃ drị̂ fẽ dó gólũdĩ, ŋálí ãzíla bõngó ãjẹ̃ rú ꞌdĩ kí Rẽbékã nî. Fẽ vâ fẽtáŋá ãjẹ̃ rú la kí ádrị́pị̃ ꞌbaní ãndrẽ be ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ãtíꞌbó Ịbụrahị́mụ̃ drị̂ kí ꞌbá ĩꞌdidrị̂ abe na kí dó íná, mvụ kí dó wáyĩnĩ, ị́nị́ ꞌdã sĩ ko kí dó ꞌdãá. Kí mụ angálé ụ̃ꞌbụ́tị sĩ ãtíꞌbô jọ, “Álẽ dó mụlé ãmbógó mádrị̂ drị̂lé.” ");
INSERT INTO luc_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Wó Rẽbékã ꞌbã ádrị́pị kí ãndrẽ be jọ kí, “Lẽ ĩzóŋâ ꞌbã uꞌá drĩ ụ́ꞌdụ́ ázị̂rị̃ jõku mụdrị́ ꞌdĩpí ráká ĩꞌdi dô sĩ mụ ĩndõ.” ");
INSERT INTO luc_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Wó ãtíꞌbô jọ ĩꞌbaní, “Ĩmi ịrị́ ma ꞌdâ ku, ãꞌdusĩku úꞌdîꞌda Úpí fẽ mání drị̃lẹ́ba ácị̃ mádrị̂ gá rá, ĩfẽ ámụ ãmbógó mádrị̂ rụ̂lé.” ");
INSERT INTO luc_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Jọ kí, “Ãma drĩ ĩzóŋâ umve ꞌba amụ́ drĩ ị́jọ́ ĩꞌdi tị gá rĩ jọlé nĩ.” ");
INSERT INTO luc_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ị́jọ́ ꞌdĩ sĩ umve kí dó Rẽbékã ꞌi ãzíla zị kí ĩꞌdi, “Ílẽ mụlé ágọ́bị́ ꞌdĩ be rá yã?” Umvi dó, “ꞌẼ, ma mụ rá.” ");
INSERT INTO luc_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ị́jọ́ ꞌdĩ sĩ ꞌbá ꞌdĩ pẽ kí dó Rẽbékã kí tị ũkú ándrá ĩꞌdi tã mbalépi ãnzị̃rị̃ŋã sĩ rĩ be, mụ kí dó ãtíꞌbó Ịbụrahị́mụ̃ drị̂ trũ ꞌbá ĩꞌdidrị̂ abe. ");
INSERT INTO luc_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Wi kí dó sụ̃sụ́ Rẽbékã ní jọ kí, “Ãmã ámvọ́pị ítị álĩfũ álĩfũ; anzị mídrị́ tịlé drị̃lẹ́ gâlé rĩ ꞌbã ndẽ kí mẹ́rọ́ꞌbá ĩꞌbadrị̂ kí rá.” ");
INSERT INTO luc_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ꞌDã ꞌbã ũngúkú gá, Rẽbékã kí izonzi ĩꞌdidrị́ ãtíꞌbó ru rĩ kí abe tụ kí dó ngãmíyã kí sị́ gá ãzíla ãtíꞌbó Ịbụrahị́mụ̃ drị̂ ꞌdụ dó Rẽbékã ꞌi trũ mụjó. ");
INSERT INTO luc_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ĩsákã amụ́ kídí Bẹ̃rị̃ Lãháyĩ-Rọ́yị̃ gâsĩ Kãnánĩ ꞌbã wókõ ándrá Nẹ̃gẹ́vụ̃ ãngũ ĩꞌdi ꞌbã sĩ uꞌájó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ụ́ꞌdụ́ ãlu ĩndróloŋá sĩ Ĩsákã mụ ámvụ́ agâlé ị́jọ́ ũrã trũ Ãdróŋá drị̃ gá, inga mịfị́ ụrụgá ndre ngãmíyã kí amụ́ agá. ");
INSERT INTO luc_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rẽbékã ndre vâ ãngũ ụrụgá, ndre Ĩsákã ꞌi, asị́ ngãmíyã sị́ gâlé rĩ sĩ vụ̃rụ́ ");
INSERT INTO luc_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ãzíla zị ãtíꞌbô ꞌi, “Ágọ́bị́ amụ́lépi ámvụ́ agâ sĩ ãma drị̃ alịlépi ꞌdã ãꞌdi ꞌi?” Ãtíꞌbô umvi ĩꞌdiní, “ꞌDã ãmbógó mádrị̂ ꞌi.” Rẽbékã aku dó ru drị̃ bõngó sĩ cí. ");
INSERT INTO luc_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ꞌDã ꞌbã ũngúkú gá, ãtíꞌbô nze dó Ĩsákã ní ị́jọ́ ꞌdĩ kí vú pírí. ");
INSERT INTO luc_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ĩsákã ajî dó Rẽbékã ꞌi ãndrẽ Sárã drị́ jó agá ãzíla acâ dó ĩꞌdi ꞌbã ũkú ru. Lẽ ĩꞌdi ambamba, ãzíla acâ dó ꞌbá Ĩsákã ꞌbã ásị́ ũŋmĩlépi rĩ rú ãndrẽ ꞌbã drãjó ꞌbo rĩ ꞌbã vúlé gá. ");
INSERT INTO luc_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ịbụrahị́mụ̃ ĩgbã vâ ũkú ãzí rĩ rụ́ la Kẹ̃tụ́rã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Tị ĩꞌdiní anzị ꞌdĩ kî: Zĩmũránĩ ꞌi, Yõkĩsánĩ ꞌi, Mẽdánĩ ꞌi, Mị̃dị́yánị̃ ꞌi, Ĩsãbákĩ ꞌi, ãzíla Sụ́wã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yõkĩsánĩ tị Sébã kí Dẽdánĩ be, Dẽdánĩ tị Ãsũrímũ ꞌi, Lẹ̃tụ̃sị́mụ̃ ꞌi ãzíla ꞌbá Lẹ̃wụ̃mị́mụ̃ drị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Anzị Mị̃dị́yánị̃ drị̂ kí: Ífã ꞌi, Ĩférũ ꞌi, Hãnókĩ ꞌi, Ãbídã ꞌi ãzíla Ĩlídã ꞌi. ꞌDĩ kí ándrá pírí anzị Kẹ̃tụ́rã drị̂ kî. ");
INSERT INTO luc_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ịbụrahị́mụ̃ fẽ dó ãko ĩꞌdidrị̂ kí pírí Ĩsákã drị́. ");
INSERT INTO luc_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Wó Ịbụrahị́mụ̃ drã drĩ ku rú, fẽ ãko wókõ anzị ũkú ĩꞌdidrị́ ãtíꞌbó ru rĩ ꞌbadrị̂ kí ãzíla pẽ dó sĩ kí tị ãngũ ị̃tụ̂ ꞌbã ãfũ agâlé ru ngọ́pị̃ Ĩsákã rụ́ ꞌdãá rĩ sĩ álị́. ");
INSERT INTO luc_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ịbụrahị́mụ̃ uꞌá dó ídri rú ílí 175 drã dó ĩndõ. ");
INSERT INTO luc_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Drã dó ꞌdĩ sĩ ĩꞌdi dó ĩdránígó ru, mụ dô sĩ áyị́pịka ũdrãlépi rá rĩ ꞌba rụ̂lé. ");
INSERT INTO luc_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ngọ́pị̃ Ĩsákã kí Ịsụmayị́lị̃ be ị̃sị̃ kí dó ĩꞌdi ụ̃jị́gọ́ Mãkĩpélã gá, ámvụ́ Mãmírẽ ꞌbã wókõ ị̃tụ̂ ꞌbã agá gâlé ru Ífĩrõnĩ Zõhárĩ ngọ́pị ꞌbá Hị́tị̃ rú rĩ drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ꞌDĩ ámvụ́ ándrá Ịbụrahị́mụ̃ ꞌbã ĩgbãlé ꞌbá Hị́tị̃ rú rĩ ꞌbadrị́ rĩ ꞌi ị̂sị̃ dó Ịbụrahị́mụ̃ kí ũkû Sárã ꞌbe ị̃rị̃ trá ãngũ ꞌdã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Drã Ịbụrahị́mụ̃ drị̂ ꞌbã ũngúkú gá, Ãdróŋá wi sụ̃sụ́ ngọ́pị̃ Ĩsákã nî, ĩꞌdi ꞌbã uꞌá agá ãni rú kídí Bẹ̃rị̃ Lãháyĩ-Rọ́yị̃ drị̂ tị gá. ");
INSERT INTO luc_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ꞌDĩ ãwí Ịsụmayị́lị̃ ũkú Ịbụrahị́mụ̃ drị́ Sárã ꞌbã ãtíꞌbó ru Hãgárĩ Mị̃sị́rị̃ ízó ru rĩ ꞌbã tịlé rĩ drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Anzị Ịsụmayị́lị̃ drị̂ kí gápi ꞌdĩ tịŋá ĩꞌbadrị̂ kí vú sĩ; ngọ́tị́ kãjãní rĩ rụ́ Nẽbãyọ́tị́ ꞌi, ũngúkú la gá rĩ kí Kẽdárĩ ꞌi, Ãdị̃bẹ́lị̃ ꞌi, Mĩbũsámũ ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mísíma ꞌi, Dúmã ꞌi, Másã ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hãdádĩ ꞌi, Témã ꞌi, Yẹ̃tụ́rị̃ ꞌi, Náfĩsĩ ꞌi ãzíla Kẽdémã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ꞌDĩ kí anzị Ịsụmayị́lị̃ drị́ mụdrị́ drị̃ ị̃rị̃ rụ́ ũsĩlé sụ́rụ́ ãzíla tọ̃rọ́mẹ́ ĩꞌbadrị̂ kí vú sĩ ãzíla ãngũ ĩꞌbã kí sĩ urijó rĩ abe rĩ kî. ");
INSERT INTO luc_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ịsụmayị́lị̃ uꞌá ídri rú ílí 137 drã dó ĩndõ. ");
INSERT INTO luc_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Anzị Ịsụmayị́lị̃ ꞌbã drị̃lẹ́ ru rĩ ri kí uꞌálé drĩdríŋĩ ãngũ Hãvị́lã ꞌbadrị́ Sụ́rị̃ be rĩ gá Mị̃sị́rị̃ ꞌbã wókõ ị̃tụ̂ ꞌbã agá gâlé ru mụ agá Ãsụ́rị̃yã gâlé ru. Anzị ꞌdĩ ngụ̃ kí ru ĩꞌbã ádrị́pịka Ịbụrahị́mụ̃ ꞌbã drị̃lẹ́ ru rĩ kí abe ũnzí. ");
INSERT INTO luc_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ꞌDĩ ãwí Ĩsákã Ịbụrahị́mụ̃ ngọ́pị drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ĩsákã ꞌbã ílí la dó mụ calé kãlị́ sụ ꞌbo, ĩgbã dó Rẽbékã Bẹ̃tụ́wẹ́lị̃ Ãrãménĩyã rú rĩ ꞌbã ị̃zẹ́pị Lábãnĩ ꞌbã ámvọ́pị ꞌi angájó Pãdãnĩ Ãrámũ gá. ");
INSERT INTO luc_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rẽbékã ꞌbã tịjó ku rĩ sĩ Ĩsákã zị Úpí ĩꞌdinî. Úpí umvi ĩꞌdi ꞌbã zịtáŋá rá, Rẽbékã ịsụ́ dó sĩ ꞌa. ");
INSERT INTO luc_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Anzị ãꞌbã kí dó sĩ ru ị̃rị̃, ri kí dó ru colé ĩꞌdi agâlé útĩ drĩ kí ku rú. Rẽbékã zị, “Ãꞌdu la ru idé áma ụrụꞌbá gá íni nĩ?” Mụ dó sĩ Úpí zịlé ị́jọ́ la sĩ. ");
INSERT INTO luc_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Úpí jọ ĩꞌdiní, “Sụ́rụ́ ị̃rị̃ kí ími ꞌa gá nĩ, mi rú ꞌbá kí ãwụ̃ ị̃rị̃, kí ru awa ndú-ndú angájó ími agá ꞌdâ. Sụ́rụ́ ãlu rĩ la adru ũkpó trũ ĩꞌdi ãzí rĩ ndẽ rá. Ngọ́tị́ kãjãní rĩ la mụ adrulé vúlé rĩ pálé gá.” ");
INSERT INTO luc_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Sáwã ĩꞌdi ꞌbã tĩjó rĩ la mụ calé ꞌbo, ísụ́ anzị ãgọbị kí ĩꞌdi ꞌa gá ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kãyó rĩ íní la ika rú ꞌbíko trũ jĩnã, ị́jọ́ ꞌdĩ sĩ úꞌda dó rụ́ la Ị́sãwụ̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Vúlé rĩ ãfũ ãzíla rụ ádrị́pị̃ Ị́sãwụ̃ ꞌbã ĩníŋá ĩꞌdidrị́ sĩ cí, ị́jọ́ ꞌdĩ sĩ úꞌda dó rụ́ la Yãkóꞌbõ ꞌi. Ĩsákã ꞌbã ílí ca dó ꞌdĩ sĩ kãlị́ ázíyá ũkû ꞌbã anzị ꞌdĩ kí tĩjó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Anzị ꞌdĩ zo kí dó rá, Ị́sãwụ̃ acá dó ãlị́gọ́ dora gbẹlépi rĩ rú ꞌbá ásé ꞌa ãni la rú, wó Yãkóꞌbõ ꞌbãngá ꞌbá ị̃gbẹ́ uꞌálépi lị́cọ́ gá la. ");
INSERT INTO luc_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ĩsákã lẽ ꞌbãngá Ị́sãwụ̃ ꞌi ĩzá ásé agá rĩ ꞌbã ãjị́ sĩ, wó Rẽbékã lẽ ꞌbãngá Yãkóꞌbõ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ụ́ꞌdụ́ ãlu Yãkóꞌbõ la lõpérẽté aꞌdí agá, Ị́sãwụ̃ angá dora gá ãzíla ãbị́rị́ ndẽ dó ĩꞌdi káyĩ. ");
INSERT INTO luc_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Jọ Yãkóꞌbõ ní, “Mí ãfẽ mání lõpérẽté ika ꞌdĩ ꞌi gbõrú! Má ukó rá.” (ꞌDĩ bãsĩ ĩꞌdi umvejó Ídõmũ ꞌi ꞌdĩ.) ");
INSERT INTO luc_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yãkóꞌbõ umvi, “Ma míní fẽ la rá, ídrĩ hákĩ míní adrujó mání kãjãní rĩ fẽ mání rá rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ị́sãwụ̃ jọ, “Múké ma úgólé drãlé drã, mání adrujó kãjãní rĩ la mání mũkẽ íngõ idé yã?” ");
INSERT INTO luc_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yãkóꞌbõ jọ, “Ína ũyõ ị́jọ́ míní adrujó kãjãní rĩ mi fẽ la mání ráká.” Ị́sãwụ̃ na dó sĩ ũyõ fẽ dó sĩ hákĩ ĩꞌdi sĩ adrujó kãjãní rĩ Yãkóꞌbõ drị́. ");
INSERT INTO luc_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ꞌDã ꞌbã ũngúkú gá, Yãkóꞌbõ fẽ dó ĩꞌdiní íná lõpérẽté sĩ nalé, mvu dó ãzíla inga dó ru mụlé rá. ꞌDĩ dó bãsĩ ị́jọ́ Ị́sãwụ̃ ꞌbã hákĩ ĩꞌdidrị́ kãjãnĩ drị̂ ꞌbãjó áváŋá ru rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Rílẽ ãzí aꞌdé ãngũ drị̃ gá ị̃dị́ cécé ụ́ꞌdụ́ ándrá Ịbụrahị́mụ̃ ngá rĩ sĩ rĩ áni. Ĩsákã mụ Ãbị̃mẹ́lẹ̃kị̃ úpí Fị̃lị̃sị̃tị́nị̃ gá rĩ rụ́ Gérã gá. ");
INSERT INTO luc_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Úpí iꞌda ru Ĩsákã ní jọ, “Ímụ ándrá Mị̃sị́rị̃ gâlé ku, mí adru ãngũ mání lũlé míní mí adru ala gá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mí uꞌá drĩ ãngũ ꞌdĩ gá ꞌdâ cêkõ, ma adru mí be ãzíla ma míní sụ̃sụ́ wi rá. Ma ãngũ ꞌdĩ fẽ míní anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ abe ũyõ ándrá mání nalé mí átẹ́pị Ịbụrahị́mụ̃ ní rĩ tãmbajó. ");
INSERT INTO luc_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ma anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbaní fẽ kpẹ̃lé cécé lẽlẽgó ꞌbụ̃ gá rĩ kî áni, ma vâ ãngũ ꞌdĩ kí fẽ pírí ĩꞌbanî. Ma rú sụ̃sụ́ wi ꞌbá ụ̃nọ́kụ́ drị̃ gá ꞌdĩ ꞌbaní anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌba rụ̂ sĩ, ");
INSERT INTO luc_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ãꞌdusĩku Ịbụrahị́mụ̃ are ma rá ãzíla mba vâ ãzị́táŋá mádrị̂ kí tã ị́jọ́ mání azịlé rĩ kí abe rá.” ");
INSERT INTO luc_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ị́jọ́ ꞌdĩ sĩ Ĩsákã uꞌá dó sĩ Gérã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ãngũ ꞌdị́pịka kí mụ ĩꞌdi zịlé ũkû ị́jọ́ sĩ ꞌbo, umvi, “Ĩꞌdi mâ ámvọ́pị ꞌi,” ãꞌdusĩku idé ụ̃rị̃ sĩ sĩ jọjó la, “ꞌDĩ mâ ũkû ꞌi” ũrã “ꞌBá ãngũ ꞌdĩ gá rĩ icó kí áma ꞌdịlé rá mâ ũkû Rẽbékã la adrujó ũniyambamba rú rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ĩsákã la mụ uꞌálé ụ́ꞌdụ́ ãzo rú ꞌdãá ꞌbo, Ãbị̃mẹ́lẹ̃kị̃ úpí ꞌbá Fị̃lị̃sị̃tị́nị̃ gá rĩ ꞌbadrị̂ andré ãngũ dẹ̃rị́sã gâsĩ vụ̃rụ́ ꞌdõlé, ndre Ĩsákã la avá agá ũkû Rẽbékã be, amvu ĩꞌdi lẽtáŋá sĩ cí. ");
INSERT INTO luc_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ãbị̃mẹ́lẹ̃kị̃ umve Ĩsákã ꞌi jọ, “Ị́jọ́ mgbã sĩ ꞌdĩ mî ũkû ꞌi! Íjọ ĩꞌdi mî ámvọ́pị ꞌi íni la ãꞌdu ị́jọ́ sĩ yã?” Ĩsákã umvi ĩꞌdiní, “Má ũrã ádrĩ jọ la ĩꞌdi mâ ũkû ꞌi ála áma ꞌdị rá.” ");
INSERT INTO luc_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ãbị̃mẹ́lẹ̃kị̃ jọ, “Mí idé dó ãma íni ãꞌdu ị́jọ́ sĩ? ꞌBá má ãni ãzí ãlu la drĩ tá ru la agá ũkú mí drị́ ꞌdĩ sĩ rá, mí ají tá drị̃lẹ́ ũnzĩ ãma drị̃ gá ꞌbo.” ");
INSERT INTO luc_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ãbị̃mẹ́lẹ̃kị̃ azị ị́jọ́ ꞌbá pírí ꞌbaní, “ꞌBá ãzí drĩ ágọ́bị́ ꞌdĩ ĩcãndĩ jõku drĩ ru la ũkú ꞌdĩ sĩ rá, ála ĩꞌdi ꞌdị rá.” ");
INSERT INTO luc_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ĩsákã sa ũri ãngũ ꞌdã agá ꞌdãá, ílí ꞌdã ꞌbã vúŋá sĩ tra ãkónã alị údu rĩ pâlé 100 ãꞌdusĩku Úpí wi ĩꞌdiní sụ̃sụ́ rá. ");
INSERT INTO luc_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Málĩ ĩꞌdidrị̂ ri kí kpẹ̃lé kpẹ̃kpẹ̃ ãzíla acá dô sĩ ꞌbá kụ́rẹ́nị́ la. ");
INSERT INTO luc_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ĩꞌdi ꞌbã kãbĩlõ, tị́ ãzíla ꞌbá ãtiꞌbo rú ꞌdĩ kí ũꞌbí rú, ị́jọ́ ꞌdĩ sĩ ꞌbá Fị̃lị̃sị̃tị́nị̃ gá rĩ kí acá kí dó ĩꞌdiní ãjã sĩ. ");
INSERT INTO luc_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kụ̃ kí dó sĩ kídí ándrá ãtíꞌbó átẹ́pị̃ Ịbụrahị́mụ̃ drị̂ ꞌbã kí galé ịsụ́ ĩꞌdi drĩ ꞌdĩ sĩ ídri rú rĩ kí tị pírí cí. ");
INSERT INTO luc_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ꞌDã ꞌbã ũngúkú gá, Ãbị̃mẹ́lẹ̃kị̃ jọ Ĩsákã ní, “Mí aꞌbe ãmã ãngũ. Ũkpó mídrị̂ iti dó ãmadrị̂ rá.” ");
INSERT INTO luc_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ị́jọ́ ꞌdĩ sĩ Ĩsákã ĩdã dó ru ꞌbá kãbĩlõ ucélépi Fị̃lị̃sị̃tị́nị̃ rú rĩ kí andre gá ꞌdãá rá, mụ dó sĩ lị́cọ́ ꞌbelé áꞌbụ ꞌa Gérã drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ĩsákã uvá kídí ándrá átẹ́pị Ịbụrahị́mụ̃ ꞌbã galé ꞌbá Fị̃lị̃sị̃tị́nị̃ gá rĩ ꞌbã kí ãzụ̃lé átẹ́pị̃ Ịbụrahị́mụ̃ ꞌbã drãjó ꞌbo rĩ sĩ ꞌdĩ kí ãzíla ꞌda vâ ĩꞌbaní rụ́ ándrá átẹ́pị̃ ꞌbã ꞌdalé rĩ kí vúŋá. ");
INSERT INTO luc_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ãtiꞌbo Ĩsákã drị̂ ga kí kídí áꞌbụ agâlé ịsụ́ kí ị̃yị́ ãlá la ala gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ꞌBá Gérã gá kãbĩlõ ucélépi rĩ ãwã kí ꞌbá kãbĩlõ Ĩsákã drị̂ kí ucélépi rĩ kí abe ãzíla jọ kí, “Ị̃yị́ ꞌdĩ ãma ãni!” Ị́jọ́ ꞌdĩ sĩ, Ĩsákã ꞌda dó sĩ ị̃yị̂ rụ́ Ĩsékĩ ꞌi, ĩꞌbã kí ãwãjó drị̃ la gá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ꞌDã ꞌbã ũngúkú gá, ãtíꞌbó Ĩsákã drị̂ ga kí kídí ãzî, ãwã kí vâ drị̃ la gá, ị́jọ́ ꞌdĩ sĩ Ĩsákã ꞌda dó sĩ rụ́ la Sítĩnã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isé vâ ru drị̃lẹ́ gá, ga vâ kídí ãzí rĩ i ãzíla ãwã kî dó drị̃ la gá ku, ị́jọ́ ꞌdĩ sĩ ꞌda dó sĩ rụ́ la Rẹ̃họ̃bọ́tị̃ ꞌi, jọ dó, “Úꞌdîꞌda Úpí ꞌbe dó ãmaní ị́rị́rị́ ꞌbo, ãma dó sĩ zo drị̃ gá drị̃ gá ụ̃nọ́kụ́ ꞌdĩ gá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ꞌDãá rĩ sĩ Ĩsákã mụ dó kpere Bẹ̃rị̃sẹ́bã gá. ");
INSERT INTO luc_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ị́nị́ ꞌdã sĩ Úpí iꞌda ru ĩꞌdiní jọ, “Ma Ãdróŋá mí átẹ́pị Ịbụrahị́mụ̃ drị̂ ꞌi. Mí idé ụ̃rị̃ sĩ ku, ãꞌdusĩku ma mí be cí; ma míní sụ̃sụ́ wi rá, ma vâ anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí fẽ kpẹ̃lé wẽwẽ rú ãtíꞌbó mádrị́ Ịbụrahị́mụ̃ ꞌbã ị́jọ́ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ĩsákã sị ãlĩtárĩ ꞌdãá ãzíla ị̃nzị̃ dó sĩ Úpí ꞌi. Sị dó hémã ĩꞌdidrị̂ ꞌdãá ãzíla ãtíꞌbó ĩꞌdidrị̂ ga kí vâ kídí ãzí ãngũ ꞌdã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ụ́ꞌdụ́ ãlu úpí Ãbị̃mẹ́lẹ̃kị̃ ãmụ́ kí angájó Gérã gá Ãhụ̃zátị̃ ꞌbá ĩꞌdidrị́ ị́jọ́ itulépi rĩ ãzíla Fĩkólĩ ãmbógó ãsĩkárĩ ĩꞌdidrị̂ kí drị̃lẹ́ gá rĩ trũ Ĩsákã rụ́. ");
INSERT INTO luc_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ĩsákã zị kí, “Wó ĩlẽ jõ dó ꞌdâ ꞌbã ngá áma ãjị́ ku yã, ĩmi adró ándrá vâ ꞌdâ ma ĩmidrị̂lé rá yã, ĩmi amụ́ dó má rụ́ ꞌdõlé ãꞌdu gá?” ");
INSERT INTO luc_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Umvi kí ĩꞌdiní, “Ãndre ábí ꞌbãngá lọ́lọ́ Úpí ĩꞌdi mí be cí rĩ gá rá, ị́jọ́ ꞌdĩ sĩ ãjọ lẽ dó ãma icí kí tị mî trũ, ãna kí dó sĩ ũyõ ãma drĩdríŋĩ gá cí, ");
INSERT INTO luc_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ãꞌdusĩku mí icó dô sĩ ãma idélé ũnzí ku, cécé ãmaní ándrá ími idéjó ũnzí ku ãmaní sĩ ími tị ãpẽjó ásị́ ị̃gbẹ̃ sĩ rĩ áni. Mi dó ꞌbá Úpí ꞌbã sĩ sụ̃sụ́ wijó drị̃ la gá rá la.” ");
INSERT INTO luc_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ĩsákã ꞌbã dó ꞌbá ꞌdĩ ꞌbaní ụ̃mụ̃, na kí dó íná ãzíla mvụ kí dó ãko mvụlé mvụ-mvụ̃ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ụ̃ꞌbụ́tịnị́nị́ ãgọbị ꞌdĩ na kí dó ũyõ kí drĩdríŋĩ gá Ĩsákã trũ, Ĩsákã ꞌbã dó kí pá ãzíla aꞌbe kí dó Ĩsákã ꞌi ásị́ ị̃gbẹ̃ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ụ́ꞌdụ́ ꞌdã sĩ ãtiꞌbo Ĩsákã drị̂ amụ́ kí ĩꞌdiní ị́jọ́ kídí ĩꞌbaní galé rĩ drị̂ lũlé jọ kí, “Ãma ịsụ́ dó ị̃yị́ ꞌbo!” ");
INSERT INTO luc_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ꞌDa dó rụ́ la Síbã ꞌi kpere ãndrũ tọ̃rọ́mẹ́ ꞌdã ꞌbã rụ́ dó sĩ Bẹ̃rị̃sẹ́bã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ị́sãwụ̃ la dó mụ calé ílí trũ kãlị́ sụ ꞌbo, ĩgbã dó Bẹ́rị̃ Hị́tị̃ rú rĩ ꞌbã ị̃zẹ́pị Yụ̃dị́tị̃ ꞌi ũkú ru ãzíla ĩgbã vâ Bãsĩmátĩ Ị̃lọ́nị̃ Hị́tị̃ rú rĩ ꞌbã ị̃zẹ́pị ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ũkú ꞌdĩ fẽ kí dó Ĩsákã ꞌbaní Rẽbékã be ũcõgõ ásị́ gá trẹ̃yị́. ");
INSERT INTO luc_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ĩsákã la mụ delé ꞌbo, mịfị́ la ãzụ̃ dó cí. Umve ngọ́pị̃ Ị́sãwụ̃ ngọ́tị́ kãjãní rĩ jọ ĩꞌdiní, “Mâ ngọ́pị!” Ãꞌị̃ dó, “Ma cí!” ");
INSERT INTO luc_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ĩsákã jọ, “Índre ma dó ĩdránígó ãzíla má icó dó uꞌálé ụ́ꞌdụ́ ãzo rú ku. ");
INSERT INTO luc_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Íꞌdụ mî ụ́sụ kí bọ̃lộ be ãzíla ífũ mụlé mání ãnãkpá ásé agá rĩ ꞌbã ĩzá ajílé. ");
INSERT INTO luc_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Mí aꞌdí mání ĩzá mání lẽlé ãjị́ ambamba rĩ ꞌi, mí ají ĩꞌdi má rụ́ ꞌdõlé. Ádrĩ dó na la ꞌbo, ma dó sĩ míní sụ̃sụ́ mádrị́ ãsị̃jó rĩ wi ꞌdĩ sĩ ádrã drĩ ku rú.” ");
INSERT INTO luc_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ĩsákã ꞌbã ị́jọ́ jọ agá ngọ́pị̃ Ị́sãwụ̃ be ꞌdĩ gá ꞌdâ, Rẽbékã ri ị́jọ́ ꞌdĩ kí arelé. Ị́sãwụ̃ la mụ drị̃ kolé mụle ĩzá ásé agá rĩ ndrụ̃ trũ ꞌbo, ");
INSERT INTO luc_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rẽbékã jọ ngọ́pị̃ Yãkóꞌbõ ní, “Má are úꞌdîꞌda mí átẹ́pị ꞌbã ị́jọ́ jọ agá Ị́sãwụ̃ ní, ");
INSERT INTO luc_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Mí ají mání ãnãkpá ásé agá rĩ ꞌbã ĩzá, mí aꞌdí ĩꞌdi mánî. Ádrĩ dó ĩꞌdi na ꞌbo, ma míní sụ̃sụ́ mádrị̂ wi Úpí Ãdróŋâ mẹ́lẹ́tị gá ịsụ́ ꞌdĩ sĩ ádrã drĩ ku.’ ");
INSERT INTO luc_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Mâ ngọ́pị! Mí are ị́jọ́ mání jọlé míní rĩ múké-múké ãzíla ínga ị́jọ́ mání jọlé míní rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ímụ ị̃ndrị́ kí agâlé, mí aꞌdụ́ ị̃ndrị́ mũlũkũdũ ãlá la kí ị̃rị̃, ma ãkónã ãjị́-ambamba la aꞌdí mî átẹ́pị ní cécé ĩꞌdi ꞌbã lẽlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Mi ĩꞌdi agụ mí átẹ́pị ní nalé ãzíla ĩꞌdi dó sĩ míní sụ̃sụ́ wi ịsụ́ ꞌdĩ sĩ drã drĩ ku rú benĩ.” ");
INSERT INTO luc_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Wó Yãkóꞌbõ jọ ãndrẽ Rẽbékã ní, “Índre má ádrị́pị Ị́sãwụ̃ ꞌbã ụrụꞌbá dụ pírí ꞌbíko rú, wó áma ụrụꞌbá gá ꞌbíko dụ ku. ");
INSERT INTO luc_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Wó má átẹ́pị drĩ dó lẽ áma ụrụꞌbá ụmvị́lé rĩ gâ? Má icó dó iꞌdálé ꞌbá ꞌbá ulélépi la rú ku yã? Ị́jọ́ ꞌdĩ sĩ má icó áma ụrụꞌbá gá áwãtáŋá ajílé sụ̃sụ́ wiŋá kẹ̃jị́ gá ku yã?” ");
INSERT INTO luc_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ãndrẽ Rẽbékã umvi ĩꞌdiní, “Áwãtáŋâ ꞌbã adru áma drị̃ gá, mâ ngọ́pị; mí idé lú ị́jọ́ mání jọlé míní ꞌdĩ ꞌi, ímụ ãzíla mí aꞌdụ́ mání ị̃ndrị́ kî.” ");
INSERT INTO luc_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ị́jọ́ ꞌdĩ sĩ mụ dó ị̃ndrị́ kí aꞌdụ́lé ajílé ãndrẽ rụ́ ꞌdõlé, aꞌdí dó ĩzâ ãjị́ ambamba rú átẹ́pị̃ ꞌbã lẽlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ꞌDã ꞌbã ũngúkú gá, Rẽbékã aꞌdụ́ dó bõngó ĩꞌdi ꞌbã ngọ́pị̃ drị̃drị̃ Ị́sãwụ̃ drị́ ũnĩ sĩ ndẽlépi rá ĩꞌdiní tãmbalé ĩꞌdidrị́ jó agá ꞌdãá rĩ kí fẽlé sụ̃lé Yãkóꞌbõ nî. ");
INSERT INTO luc_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Aku ị̃ndrị́ íníríkó ĩꞌdidrị́ kí gá ãzíla ãngũ imbe gá ꞌbíko kó ru rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ꞌDã ꞌbã ũngúkú gá, fẽ dó íná ĩꞌdi ꞌbã aꞌdílé ãjị́ ambamba ꞌdã ngọ́pị̃ Yãkóꞌbõ drị́. ");
INSERT INTO luc_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yãkóꞌbõ mụ dó átẹ́pị̃ rụ̂lé ãzíla jọ, “Mâ átẹ́pị!” Ãꞌị̃, “Ma cí,” zị ĩꞌdi, “Mi dó mâ ngọ́pị íngõ ꞌi?” ");
INSERT INTO luc_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yãkóꞌbõ umvi ĩꞌdiní, “Ma mî ngọ́pị kãjãní Ị́sãwụ̃ ꞌi; ánga ãzị̂ cécé tá míní lũlé mání rĩ áni. Mí angá rilé ụrụgá ãzíla ína ĩzá mání ajílé míní ꞌdĩ ꞌi, mi dô sĩ mání sụ̃sụ́ wi.” ");
INSERT INTO luc_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ĩsákã zị ngọ́pị̃ ꞌi, “Mí ịsụ́ ĩzâ gbõŋáŋá ru íngoní ru?” Yãkóꞌbõ umvi ĩꞌdi, “Úpí Ãdróŋá mídrị̂ ko áma ãzã ĩzâ ịsụ́jó nĩ.” ");
INSERT INTO luc_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ĩsákã jọ Yãkóꞌbõ ní, “Mâ ngọ́pị, mí asé drĩ mi ãni rú má rụ́ ꞌdõlé, ma dó sĩ ími ụrụꞌbá ụmvị́ nị̃jó la ãndá-ãndá ru mi Ị́sãwụ̃ ꞌi yã jõku yụ.” ");
INSERT INTO luc_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yãkóꞌbõ asé dó ru ãni rú átẹ́pị̃ Ĩsákã rụ́ ꞌdõlé. Ĩtrĩkã ĩꞌdi jọ, “Ími ụ́ꞌdụ́kọ́ la ꞌụ cécé Yãkóꞌbõ drị̂ áni, wó ími drị́ kí cécé Ị́sãwụ̃ drị̂ kî áni.” ");
INSERT INTO luc_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ĩtrĩkã dó Yãkóꞌbõ ku ãꞌdusĩku ĩꞌdi ꞌbã drị́ kí ꞌbíko rú cécé Ị́sãwụ̃ drị̂ kî áni. Ĩsákã dó ãni rú lẽ agá ĩꞌdiní sụ̃sụ́ wi agá, ");
INSERT INTO luc_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","wó zị ĩꞌdi ị̃dị́, “Ãndá-ãndá ru mi ma ngọ́pị Ị́sãwụ̃ ꞌi yã?” Umvi ĩꞌdi, “ꞌẼ, ma Ị́sãwụ̃ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ĩsákã jọ, “Mâ ngọ́pị, mí ají mání ĩzâ ꞌi. Ádrĩ dó na la ꞌbo, ma dó míní sụ̃sụ́ mádrị̂ wi.” Yãkóꞌbõ ajî dó ĩzâ ĩꞌdi rụ́ ꞌdõlé ãzíla fẽ vâ ĩꞌdiní wáyĩnĩ mvụlé ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ꞌDã ꞌbã vúlé gá átẹ́pị̃ Ĩsákã jọ ĩꞌdiní, “Mí asé mi ãni rú má rụ́ ꞌdõlé, mâ ngọ́pị.” ");
INSERT INTO luc_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ĩꞌdi dó mụ ru asélé Ĩsákã amvulé ꞌbo, ngụ̃ ĩꞌdi ꞌbã bõngó kî, wi dó ĩꞌdiní sụ̃sụ́ ĩꞌdidrị̂ ꞌi ãzíla jọ, “Mâ ngọ́pị ꞌbã ãjị́ la ngụ̃ cécé ámvụ́ Úpí ꞌbã sĩ sụ̃sụ́ wijó drị̃ la gá rá rĩ drị̂ áni. ");
INSERT INTO luc_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ãdróŋá ꞌbã fẽ míní uzogó ꞌbụ̃ gá rĩ ãzíla ꞌbã fẽ ámvụ́ mídrị̂ ꞌbã adru kí ãkónã kalépi ambamba rĩ kî rú! Ãdróŋá ꞌbã fẽ míní ãná ꞌbã kakã ãzíla wáyĩnĩ ꞌbã adru míní wẽwẽ rú. ");
INSERT INTO luc_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Sụ́rụ́ ꞌbã adru kí míní ãzị́ ngalé ãtíꞌbó ru, ꞌbá pírí ꞌbã tị̃ kí ãja vụ̃rụ́ ími drị̃lẹ́ gá. Mi adru úpí ru sĩ mí ádrị́pịka kí drị̃ cejó, anzị mî ãndrẽ ꞌbã tịlé rĩ ꞌbã tị̃ kí ãja vụ̃rụ́ ími drị̃lẹ́ gá. Áwãtáŋá ꞌbã adru ꞌbá ími wãlépi rĩ kí drị̃ gá ãzíla drị̃lẹ́ba ꞌbã adru ꞌbá míní sụ̃sụ́ wilépi rĩ kí drị̃ gá.” ");
INSERT INTO luc_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ĩsákã la mụ sụ̃sụ́ wiŋá Yãkóꞌbõ ní rĩ delé ãzíla Yãkóꞌbõ la mụ fũlé ꞌbo, cọtị ádrị́pị̃ Ị́sãwụ̃ acá vâ ásé agâlé rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Aꞌdí vâ ĩzâ ãjị́ ambamba rú, agụ ĩꞌdi átẹ́pị̃ rụ̂lé. Jọ, “Mâ átẹ́pị, mí angá rilé ụrụgá ãzíla ína ĩzá mání ajílé míní ásé agâlé rĩ ꞌi mi dó sĩ mání sụ̃sụ́ mí drị́ gá rĩ wi benĩ.” ");
INSERT INTO luc_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ĩsákã zị ĩꞌdi, “Mi ãꞌdi ꞌi?” Umvi, “Ma mî ngọ́pị kãjãní Ị́sãwụ̃ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ĩsákã aru gbãdrí-gbãdrí ãzíla ụrụꞌbá la iꞌdó yãlé yã-yã, zị dó, “ꞌBá tá ãnãkpá ĩzá aꞌdílépi ajílépi la mání rĩ ãꞌdi ꞌi? Ána ĩꞌdi úꞌdîꞌda ịsụ́ mí afí drĩ ku rú. Áwi dó ĩꞌdiní sụ̃sụ́ mádrị́ ãsị̃jó rĩ ꞌbo ãzíla ãndá-ãndá ru ꞌdụ dó sụ̃sụ́ tá tí mání wilé míní rĩ rá.” ");
INSERT INTO luc_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ị́sãwụ̃ la mụ ị́jọ́ átẹ́pị̃ Ĩsákã ꞌbã jọlé ꞌdĩ arelé ꞌbo kpẹ̃ dó áwáŋá gá ụ́ꞌdụ́kọ́ ụrụgá sĩ ásị́ la lẽ dó kpẹ̃lé kpẹ̃kpẹ̃ ãzíla jọ, “Má átẹ́pị íwi mání sụ̃sụ́ mídrị̂ ĩndĩ fô!” ");
INSERT INTO luc_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ĩsákã jọ ĩꞌdiní, “Mí ádrị́pị amụ́ áma ulélé. ꞌDụ dó sĩ sụ̃sụ́ mídrị̂ ꞌbo.” ");
INSERT INTO luc_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ị́sãwụ̃ jọ, “ꞌdĩ dó pâlé ị̃rị̃ la Yãkóꞌbõ ꞌbã áma ụ̃gụ̃jó úléŋá sĩ rĩ. Rụ́ la vâ Yãkóꞌbõ ꞌi. ꞌDụ ándrá vâ mání adrujó kãjãní rĩ rá, úꞌdîꞌda ꞌdụ vâ sụ̃sụ́ mádrị̂ rá. Ímba tâ dó sụ̃sụ́ ãzí tã mání ku yã?” ");
INSERT INTO luc_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ĩsákã umvi Ị́sãwụ̃ ní, “Áꞌbã dó ĩꞌdi úpí ru ími drị̃lẹ́ gá ꞌbo, ãzíla áꞌbã ĩꞌdi ꞌbã kãká kí adrujó ĩꞌdi ꞌbã ãtíꞌbó ru ꞌbo. Áfẽ ĩꞌdiní ãná kí wáyĩnĩ trũ ꞌbo. Mâ ngọ́pị, ãko ãzí mání icólé idélé míní rá la dó ꞌdáyụ.” ");
INSERT INTO luc_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ị́sãwụ̃ rĩ mãmálá ꞌbãlé átẹ́pị̃ drị́ jọ, “Mi lú sụ̃sụ́ wiŋâ trũ ãlu yã, má átẹ́pị? Íwi mání sụ̃sụ́ ĩndĩ fô!” Iꞌdó dó awálé ụ́ꞌdụ́kọ́ sĩ rere ãzíla mị́ndrệ trũ rũrũ. ");
INSERT INTO luc_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ĩsákã jọ ĩꞌdiní, “Uzogó ꞌbụ̃ gá la dó míní ꞌdáyụ, ãngũ ãzí ãkónã ũfũlépi múké la la adru míní ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Mi adru ídri rú la míní ꞌbá ụꞌdị́jó ménéŋá sĩ rĩ sĩ ãzíla mi ãzị́ nga mí ádrị́pị drị́ ãtíꞌbó ru. Wó mi ími ãtrũ mí ádrị́pị drị́lẹ́ agá míní drị̃-ũnzĩ ajíjó rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ị́sãwụ̃ ngụ̃ dó Yãkóꞌbõ ãjị́ ũnzí átẹ́pị̃ ꞌbã ĩꞌdiní sụ̃sụ́ wijó rĩ sĩ. Ũrã ĩꞌdi ásị́ gâlé, “Ụ́ꞌdụ́ mâ átẹ́pị ị̃sị̃jó rĩ ace kí dó ru wereŋá rú, ma dó sĩ mụ má ádrị́pị Yãkóꞌbõ ꞌdịlé rá.” ");
INSERT INTO luc_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rẽbékã la mụ ị́jọ́ Ị́sãwụ̃ ꞌbã itúlé Yãkóꞌbõ ꞌdịjó rĩ nị̃lé ꞌbo, umve Yãkóꞌbõ ꞌi jọ ĩꞌdiní, “Mí ádrị́pị Ị́sãwụ̃ itú ị́jọ́ lẽjó ími ꞌdịjó rá. ");
INSERT INTO luc_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Mâ ngọ́pị mí idé ị́jọ́ mání jọlé míní ꞌdĩ ꞌi. Mí apá má ádrị́pị Lábãnĩ rụ́ Hãránĩ gâlé. ");
INSERT INTO luc_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Mí uꞌá ĩꞌdi be kpere mí ádrị́pị ꞌbã ásị́ ꞌbã ịgbẹ agá rá ká, ");
INSERT INTO luc_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ãzíla drĩ dó ị́jọ́ míní idélé ĩꞌdi ụrụꞌbá gá ꞌdĩ ãvĩ rá, ma dó amụ́ ꞌbá ãzí tị pẽlé mụlé ími ajílé vúlé ꞌdõlé ĩndõ. Ma dó mâ anzị kí ãvĩ ị̃rị̃ trá ụ́ꞌdụ́ ãlu agá la ãꞌdu ị́jọ́ sĩ?” ");
INSERT INTO luc_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rẽbékã jọ Ĩsákã ní, “Ma ãyánĩ rú ãzíla má ãndẽ Ị́sãwụ̃ ꞌbã ũkúka Hị́tị̃ rú ꞌdĩ kí ꞌbã ị́jọ́ sĩ rá. Yãkóꞌbõ drĩ dó sĩ kí ãzí ĩgbã ĩꞌdiní ũkú ru yã áni dũbã la mání drãjó rá rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ꞌDã ꞌbã ũngúkú gá, Ĩsákã umve Yãkóꞌbõ ꞌi ãzíla wi ĩꞌdiní sụ̃sụ́ ãzíla jọ, “Lẽ mí ĩgbã jõ ũkú Kãnánĩ ízó ru la ku. ");
INSERT INTO luc_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ímụ rá la Pãdãnĩ Ãrámũ gá lị́cọ́ mî ãndrẽ ꞌbã átẹ́pị Bẹ̃tụ́wẹ́lị̃ drị̂ gá. Mí ịsụ́ ũkú mî ádrọ́pị Lábãnĩ ꞌbã izonzi kí agá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ãdróŋá Ũkpó ꞌDị́pị ꞌbã wi míní sụ̃sụ́ ãzíla ꞌbã fẽ vâ míní ũri mídrị̂ ꞌbã kpẹ̃ kí wẽwẽ rú, mi dó sĩ acá sụ́rụ́ ũꞌbí kí ꞌbã áyị́pị ru. ");
INSERT INTO luc_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ãdróŋá ꞌbã fẽ míní anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ abe drị̃lẹ́ba ándrá ĩꞌdi ꞌbã sĩ sụ̃sụ́ wijó Ịbụrahị́mụ̃ nî rĩ ꞌi, mi dó sĩ ãngũ míní uꞌájó ala gá ꞌdâ ãmị́yọ́ŋá ru ándrá ĩꞌdi ꞌbã fẽlé Ịbụrahị́mụ̃ nî rĩ ꞌdụ mî ãni la rú.” ");
INSERT INTO luc_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ꞌDã ꞌbã ũngúkú gá, Ĩsákã pẽ dó Yãkóꞌbõ tị mụjó Pãdãnĩ Ãrámũ gá, ãngũ ádrọ́pị̃ Lábãnĩ Bẹ̃tụ́wẹ́lị̃ ngọ́pị Ãrãménĩyã rú Rẽbékã ꞌbã ádrị́pị andre Yãkóꞌbõ ꞌbadrị́ Ị́sãwụ̃ be rĩ drị́ko gá. ");
INSERT INTO luc_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Úꞌdîꞌda Ị́sãwụ̃ nị̃ dó rá Ĩsákã wi dó sụ̃sụ́ Yãkóꞌbõ ní ãzíla pẽ dó ĩꞌdi tị sĩ mụjó ũkú ịsụ́jó Pãdãnĩ Ãrámũ gá. Ị́sãwụ̃ nị̃ vâ rá Ĩsákã la mụ Yãkóꞌbõ ní sụ̃sụ́ wilé ꞌbo, fẽ vâ ĩꞌdiní ãzị́táŋá sĩ Kãnánĩ ízó ĩgbãjó ũkú ru ku. ");
INSERT INTO luc_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yãkóꞌbõ are dó átẹ́pị̃ kí tị ãndrẽ be rá, mụ dô sĩ Pãdãnĩ Ãrámũ gá. ");
INSERT INTO luc_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ị́sãwụ̃ nị̃ vâ ũkú Kãnánĩ ízó ru ꞌdĩ kí ꞌí átẹ́pị̃ Ĩsákã lẽ kí ku rĩ gá rá; ");
INSERT INTO luc_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","mụ dó sĩ átịdrị̂ Ịsụmayị́lị̃ Ịbụrahị́mụ̃ ngọ́pị drị́, ĩgbã dó ị̃zẹ́pị̃ Mãhãlátĩ Nẽbãyọ́tị́ ꞌbã ámvọ́pị rú rĩ ꞌi ũkú ru. ");
INSERT INTO luc_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yãkóꞌbõ aꞌbe dó Bẹ̃rị̃sẹ́bã rá ko dó sĩ drị̃ mụjó Hãránĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ị̃tụ́ ꞌbã ꞌdejó ꞌdẽ rĩ sĩ, ịsụ́ ãngũ ãzí sĩ ụ́ꞌdụ́ kojó. Aꞌdụ́ írã ãzí ãlu sĩ drị̃ ãtị̃jó, ãzíla la dó ru vụ̃rụ́ ụ́ꞌdụ́ kolé. ");
INSERT INTO luc_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ĩꞌdiní ụ́ꞌdụ́ ko agá ꞌdĩ gá ꞌdâ urobí ũbĩ ĩꞌdi, urobî agá ꞌdãá, ndre ãpị́kẹ ãzí ꞌbãlé pá la ꞌbã sĩ adrujó vụ̃rụ́ ãzíla drị̃ la ꞌbã sĩ cajó kpere ꞌbụ̃ gá la ãzíla mãlãyíkã Ãdróŋá drị̂ kí asị́ agá ãzíla tụ agá drị̃ la gâsĩ. ");
INSERT INTO luc_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Úpí tu pá drị̃lẹ́ la gá ụrụgá ꞌdãá jọ, “Ma Úpí Ãdróŋá mí áyị́pị Ịbụrahị́mụ̃ drị̂ ꞌi, ma Ãdróŋá Ĩsákã drị̂ ꞌi, ma rú ãngũ míní sĩ ími lajó ala gá ꞌdĩ fẽ míní ãzíla anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí adru wẽwẽ rú cécé cínákí ụ̃nọ́kụ́ drị̃ gá rĩ áni, kí ru iré ị̃tụ̂ ꞌbã ꞌde agâlé ru ãzíla ị̃tụ̂ ꞌbã ãfũ agâlé ru, ándrâlé ru ãzíla ụ́rụ̂lé ru. Ma rú sụ̃sụ́ wi sụ́rụ́ pírí ꞌbaní mí rụ̂ sĩ ãzíla anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌba rụ̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ímba ị́jọ́ ꞌdĩ kí tã ími ásị́ gá, ma adru mí be ãzíla ma ími tãmba ãngũ míní mụjó rĩ kí agá, ma rú vâ ími ají vúlé ãngũ ꞌdĩ gá ꞌdõlé; má icó ími aꞌbelé ku kpere mání ị́jọ́ mání jọlé míní ꞌdĩ idé agá.” ");
INSERT INTO luc_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yãkóꞌbõ la mụ angálé ụ́ꞌdụ́ gá rĩ sĩ ꞌbo, jọ, “Ãndá-ãndá ru Úpí ãngũ ꞌdĩ gá ꞌdâ cí, wó ánị̃ tá ị́jọ́ ꞌdĩ ku.” ");
INSERT INTO luc_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Idé dó ụ̃rị̃ sĩ ãzíla jọ, “Ãngũ ꞌdĩ la ꞌbá rụ ụ̃rị̃ rú ꞌdõ áni yã! ꞌDĩ dó jó Ãdróŋá drị̂ ꞌi; ĩꞌdi vâ kẹ̃jị́ tị ꞌbụ̃drị̂ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yãkóꞌbõ angá ụ̃ꞌbụ́tịnị́nị́ ụ́ꞌdụ́ ãzí rĩ sĩ, aꞌdụ́ írã tá ĩꞌdi ꞌbã sĩ ru drị̃ ãtị̃jó rĩ ꞌi, ịꞌdị ĩꞌdi ụrụ gá pịrị-pịrị sĩ ãngũ ꞌdã ị́jọ́ ũrãjó ãzíla ũsũ ãdu drị̃ la gá sĩ ãwãꞌdĩfô fẽjó Ãdróŋá nî. ");
INSERT INTO luc_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ꞌDa dó ãngũ ꞌdã rụ́ Bẹ̃tẹ́lị̃ ꞌi. Ála ándrá táwụ̃nị̃ ꞌdã umve Lụ́zị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ꞌDã ꞌbã ũngúkú gá, Yãkóꞌbõ na ũyõ jọ, “Ãdróŋá drĩ adru má be ãzíla drĩ áma tã mba ãcị̃ mádrị́ ꞌdĩ agá, drĩ vâ mání íná fẽ nalé bõngó sụ̃lé sụ̃sụ̃ rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ádrĩ vâ sĩ ãgõ vúlé mâ átẹ́pị drị́ko gá ꞌdõ lé ásị́ ị̃gbẹ̃ sĩ rá, Úpí la dó adru Ãdróŋá mádrị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Írã mání ịꞌdịlé pịrị-pịrị ꞌdĩ la adru ãngũ sĩ Ãdróŋá ị̃nzị̃jó rĩ ãzíla ãko pírí mání ịsụ́lé rĩ ꞌbã wókõ ãlu mụdrị́ drị́ gá rĩ ma fẽ la Ãdróŋá nî.” ");
INSERT INTO luc_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ꞌDã ꞌbã ũngúkú gá, Yãkóꞌbõ mụ dó ãcị̃ trũ drị̃ gá wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ĩꞌdi ꞌbã mụ agá ꞌdĩ gá ꞌdâ ndre kídí rị̂ ãzí agá ãzíla tị la gá ꞌdãá kãbĩlõ ula kí ru ngúlú ru ngúlú ru, ãꞌdusĩku kídí ꞌdã Kãbĩlõ ꞌbã kí jõ sĩ ị̃yị́ mvụjó rĩ ꞌi. Ála jõ kídí ꞌdã tị ụ̃pị̃ írã kpakụ la sĩ. ");
INSERT INTO luc_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kãbĩlõ drĩ kí dó sáwã pírí sĩ ru atrá ãngũ ãlu gá ꞌbo, ꞌbá kãbĩlõ kí ucélépi rĩ kí dó írã ꞌdã gũ bụ́lụ́ gá kí dó sĩ kãbĩlõ ꞌbaní ị̃yị́ fẽ mvụlé ãzíla kí dó vâ írã gũ vúlé sĩ kídí tị ụ̃pị̃jó cí. ");
INSERT INTO luc_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yãkóꞌbõ zị ꞌbá kãbĩlõ kí ucélépi ꞌdĩ kí, “Mâ wọ̃rị́kâ ĩmi angá íngõlé yã?” Umvi kí, “Ãma angá Hãránĩ gá.” ");
INSERT INTO luc_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Zị kí, “Ị̃nị̃ Lábãnĩ Nãhọ́rị̃ umvelépi áyị́pị rĩ rá yã?” Umvi kí, “ꞌẽ, ãnị̃ ĩꞌdi cé.” ");
INSERT INTO luc_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yãkóꞌbõ zị kí, “Ĩꞌdi múké yã?” Umvi kí, “ꞌẽ, Lábãnĩ múké, índre ị̃zẹ́pị̃ Rãkẹ́lị̃ la amụ́ kãbĩlõ ĩꞌdidrị̂ kî trũ ꞌdã.” ");
INSERT INTO luc_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yãkóꞌbõ jọ ĩꞌbaní, “Ị̃tụ̂ drĩ ụrụgá ꞌdĩ; sáwã kãbĩlõ ꞌbã kí sĩ ru trajó ãngũ ãlu gá rĩ ca drĩ ku, ĩfẽ ĩꞌbaní ị̃yị́ mvụlé ꞌbã mụ kí rú dó sĩ ĩrí nalé.” ");
INSERT INTO luc_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Umvi kí, “Ãma icó ku kpere kãbĩlõ ꞌbã kí ru atrá agá pírí ráká, ála írã kídí tị gá rĩ gũ bụ́lụ́ gá, ála dó sĩ kãbĩlõ ꞌbaní ị̃yị́ fẽ mvụlé ĩndõ.” ");
INSERT INTO luc_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yãkóꞌbõ ꞌbã kí drĩ ị́jọ́ jọ agá ꞌdĩ gá ꞌdâ, Rãkẹ́lị̃ iyá kãbĩlõ átẹ́pị̃ drị̂ kí trũ ãꞌdusĩku ĩꞌdi ándrá ꞌbá kãbĩlõ ucélépi la. ");
INSERT INTO luc_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yãkóꞌbõ la mụ ádrọ́pị̃ Lábãnĩ ị̃zẹ́pị Rãkẹ́lị̃ ndrelé kãbĩlõ ĩꞌdidrị̂ kî trũ ꞌbo, mụ kídí tị gâlé, gũ dó írã bụ́lụ́ gá sĩ kãbĩlõ ꞌbaní ị̃yị́ fẽjó mvụjó. ");
INSERT INTO luc_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yãkóꞌbõ amvu kí ru Rãkẹ́lị̃ be kpãrã ãzíla iꞌdó dó awálé mị́ndrẹ trũ ãyĩkõ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Nze dó ru vú Rãkẹ́lị̃ ní, “Ma mí átẹ́pị ꞌbã kãká, Rẽbékã ꞌbã ngọ́pị ꞌi.” Ị́jọ́ ꞌdĩ sĩ Rãkẹ́lị̃ cẹ̃ dó ị́jọ́ ꞌdĩ lũlé átẹ́pị̃ nî. ");
INSERT INTO luc_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lábãnĩ la mụ ị́jọ́ ãdrõmvâ Yãkóꞌbõ drị̃ gá rĩ arelé ꞌbo, gbõgbõ afụ ru mụlé ĩꞌdi aꞌị́lé, amvu kí ru Yãkóꞌbõ be kpãrã ají dó ĩꞌdi ĩꞌdidrị́ lị́cọ́ gá ꞌdõlé, ãzíla Yãkóꞌbõ nze dó sĩ ĩꞌdiní ị́jọ́ ĩꞌdi ụrụꞌbá gá rĩ kí vú pírí. ");
INSERT INTO luc_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lábãnĩ jọ Yãkóꞌbõ ní, “Mi ĩfãkã ãzíla ãrí mádrị̂ ꞌi.” Yãkóꞌbõ uꞌá dó sĩ ĩꞌdi be ꞌdãá ĩmbá ãlu. ");
INSERT INTO luc_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ꞌDã ꞌbã ũngúkú gá, Lábãnĩ jọ Yãkóꞌbõ ní “Míní adrujó mání kãká rĩ sĩ adru mi dó sĩ ãzị́ nga mání ĩsá ru la ku. Ílũ mání ílẽ má ũfẽ mi íngõpí yã rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lábãnĩ ꞌbã ị̃zẹ́pịka kí ándrá ị̃rị̃, kãjãní rĩ ꞌbã rụ́ Léyã ꞌi, ãzíla vúlé rĩ ꞌbã rụ́ Rãkẹ́lị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Léyã ꞌbã mịfị́ kí ándrá ũniyambamba rú, wó Rãkẹ́lị̃ ụrụꞌbá ꞌbãngá túlí-túlí ãzíla ũniyambamba rú. ");
INSERT INTO luc_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yãkóꞌbõ ásị́ lẽ Rãkẹ́lị̃ ꞌi ãzíla jọ, “Ma ãzị́ nga míní ílí ázị̂rị̃, mi dó sĩ mání mî ị̃zẹ́pị vúlé Rãkẹ́lị̃ fẽ ũkú ru.” ");
INSERT INTO luc_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lábãnĩ jọ, “Má ãꞌị̃ rá, ma dũbã la ĩꞌdi fẽ míní ndẽ mání ĩꞌdi fẽjó ꞌbá ãzí ní rĩ rá. Mí uꞌá áma andre gá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ị́jọ́ ꞌdĩ sĩ Yãkóꞌbõ nga dó ãzị́ ílí ázị̂rị̃ Rãkẹ́lị̃ ĩgbãjó, wó ílí ꞌdĩ indré kí ĩꞌdiní wereŋá ru ĩꞌdi ꞌbã Rãkẹ́lị̃ lẽjó ambamba rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ꞌDã ꞌbã ũngúkú gá, Yãkóꞌbõ jọ dó Lábãnĩ ní, “Sáwã mádrị́ ãzị́ ngajó rĩ ukó dó rá, mí ãfẽ dó mâ ũkû ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ị́jọ́ ꞌdĩ sĩ Lábãnĩ umve dó ꞌbá ãngũ ꞌdã gá ꞌdãá rĩ kí pírí idé dó sĩ ĩꞌbaní yãmãrĩ. ");
INSERT INTO luc_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Wó ị́nị́ ꞌdã sĩ Rãkẹ́lị̃ fẽjó rĩ kẹ̃jị́ gá Lábãnĩ fẽ Léyã ꞌi áyụ, ãzíla Yãkóꞌbõ icí kî dó sĩ ru ĩꞌdi be. ");
INSERT INTO luc_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lábãnĩ fẽ dó ị̃zẹ́pị̃ Léyã ní Zị̃lị́pã ꞌi ãtíꞌbó ru. ");
INSERT INTO luc_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Yãkóꞌbõ la mụ angálé ụ̃ꞌbụ́tị sĩ ꞌbo, ịsụ́ ꞌbâ Léyã ꞌi adru Rãkẹ́lị̃ ꞌi ku. Mụ Lábãnĩ rụ̂lé, jọ “Mí idé dó ma íni ãꞌdu sĩ? Ánga ãzị́ sĩ Rãkẹ́lị̃ ĩgbãjó áyụ ku yã? Mí ule dó áma drị̃ íni ãꞌdu ị́jọ́ sĩ yã?” ");
INSERT INTO luc_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lábãnĩ umvi jọ, “Lãꞌbĩ ãmadrị̂ sĩ îgbã ĩzóŋá vúlé rĩ kãjãní rĩ ní drị̃drị̃ ku. ");
INSERT INTO luc_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ítẽ kpere ụ́ꞌdụ́ ázị̂rị̃ ụ́ꞌdụ́ ị̃zị̃nãkã drị̂ ꞌba ukó kí ráká, ma míní Rãkẹ́lị̃ fẽ ídrĩ ãzị́ nga ílí ázị̂rị̃ ị̃dị́ rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yãkóꞌbõ ãꞌị̃ rá ãzíla ụ́ꞌdụ́ ázị̂rị̃ ị̃zị̃nãkã drị̂ kí mụ ukólé ꞌbo, Lábãnĩ fẽ ị̃zẹ́pị̃ Rãkẹ́lị̃ ꞌi ĩꞌdiní ũkú ru. ");
INSERT INTO luc_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lábãnĩ fẽ Bílĩhã ꞌi Rãkẹ́lị̃ ní ãtíꞌbó ru. ");
INSERT INTO luc_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yãkóꞌbõ fi dó Rãkẹ́lị̃ drị́ jó agá ko dó sĩ ĩꞌdi be, ãzíla lẽ Rãkẹ́lị̃ ꞌi Léyã ní ãndânĩ. Nga dó sĩ ãzị́ Lábãnĩ ní ílí ázị̂rị̃ ị̃dị́. ");
INSERT INTO luc_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Úpí la dó mụ ndrelé la úlẽ Léyã ku, nzị̃ ĩꞌdi ꞌbã mvájólé rá, wó Rãkẹ́lị̃ ace úndó ru. ");
INSERT INTO luc_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Léyã ịsụ́ dó ꞌa, tị dó ngọ́tị́ ágọ́bị́ ãzíla ꞌdâ dó sĩ rụ́ la Rụ́bẹ̃nị̃ ꞌi. Rụ́bẹ̃nị̃ ꞌbã ífí, “Úpí andré dó áma ũcõgõ rá ꞌi. Ãndá-ãndá ru má ágô dó áma lẽ rá.” ");
INSERT INTO luc_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ịsụ́ vâ ꞌa ãzí rĩ, tị ngọ́tị́ ágọ́bị́, jọ, “Úpí are dó úlẽ ma ku rĩ ꞌbo, fẽ dó mání ꞌdõ ꞌi.” ꞌDa dó sĩ rụ́ la Sị̃mọ́nị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ịsụ́ vâ ꞌa ãzí rĩ ꞌi, tị ngọ́tị́ ágọ́bị́, jọ, “Mâ ágô dó ru ĩbĩ má be rá, ãꞌdusĩku átị dó ĩꞌdiní anzị ãgọbị kí na ꞌbo.” ꞌDa dó sĩ rụ́ la Lẹ́vị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ịsụ́ vâ ꞌa ãzí rĩ ꞌi, tị ngọ́tị́ ágọ́bị́, jọ, “Úꞌdîꞌda ma dó Úpí ịcụ́ rá.” ꞌDa dó sĩ rụ́ la Yụ́dã ꞌi. Lị dó ru ngọ́tị́ ịsụ́ŋá gá rá. ");
INSERT INTO luc_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rãkẹ́lị̃ la mụ ndrelé la ítị anzị Yãkóꞌbõ ní ku, uja acálé ámvọ́pị̃ ní ãjã sĩ. Jọ, “Yãkóꞌbõ, ífẽ mání anzị, jõ íni ku ma mụ drãlé rá.” ");
INSERT INTO luc_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yãkóꞌbõ acá dó Rãkẹ́lị̃ be ũmbã sĩ ãzíla jọ, “Mí ũrã ma Ãdróŋá ími atrịlépi tịŋá gá cí rĩ ꞌi yã?” ");
INSERT INTO luc_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rãkẹ́lị̃ jọ Yãkóꞌbõ ní, “Ãtíꞌbó mádrị́ Bílĩhã ꞌi ꞌdĩ, ĩmi icí ĩmi ĩꞌdi be, ítị ĩꞌdi be anzị kí lị́cọ́ mádrị̂ ꞌbã adru rû sĩ cí.” ");
INSERT INTO luc_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ị́jọ́ ꞌdĩ sĩ Rãkẹ́lị̃ fẽ dó ĩzóŋá ĩꞌdidrị́ ãtíꞌbó ru Bílĩhã ꞌi Yãkóꞌbõ ní ũkú ru. Yãkóꞌbõ ící kí dó ru ĩꞌdi be ");
INSERT INTO luc_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ãzíla ịsụ́ dó ꞌa, tị dó sĩ ĩꞌdiní ngọ́tị́ ágọ́bị́. ");
INSERT INTO luc_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rãkẹ́lị̃ jọ dó, “Ãdróŋá lị dó ị́jọ́ áma drị̃ gá múké ꞌbo; are dó áma áwáŋá rá ãzíla fẽ dó mání ngọ́tị́ ágọ́bị́.” ꞌDa dó sĩ ngọ́tị̂ rụ́ Dánĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rãkẹ́lị̃ ꞌbã ĩzóŋá ãtíꞌbó ru Bílĩhã ịsụ́ vâ ꞌa ãzí, tị dó sĩ Yãkóꞌbõ ní ngọ́tị́ ágọ́bị́ ị̃rị̃ jó rĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rãkẹ́lị̃ jọ, “Ãtrị dó ãma ị̃fụ́ ãjã sĩ mâ ámvọ́pị be wó ándẽ dó ꞌbo.” Ị́jọ́ ꞌdĩ sĩ ꞌda dó sĩ rụ́ la Nãfũtálĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Léyã la mụ ndrelé la ítu pá tịŋá gá cí ꞌbo, fẽ ĩzóŋá ĩꞌdidrị́ ãtíꞌbó ru Zị̃lị́pã ꞌi Yãkóꞌbõ ní ũkú ru. ");
INSERT INTO luc_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Léyã ꞌbã ãtíꞌbó Zị̃lị́pã tị dó ngọ́tị́ ágọ́bị́ Yãkóꞌbõ nî. ");
INSERT INTO luc_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Léyã jọ, “Áma andre dó múké.” ꞌDa dó ngọ́tị̂ rụ́ Gádĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ãtíꞌbó Léyã drị́ Zị̃lị́pã tị Yãkóꞌbõ ní ngọ́tị́ ágọ́bị́ ãzí rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Léyã jọ, “Ãyĩkõ fụ ma ꞌdóni yã! Ũkú kí dó áma umve ãyĩkõ rú ꞌi.” ꞌDa dó ngọ́tị̂ rụ́ Ásẹ̃rị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Áyi ãná lãjó rĩ sĩ Rụ́bẹ̃nị̃ angá ámvụ́ agâlé ife umvelé ágófũku rĩ trũ, ĩꞌdi kí ají agá ãndrẽ Léyã nî. Ụ́kụ́pị̃ Rãkẹ́lị̃ jọ Léyã ní, “Mí ãfẽ mání mi ngọ́pị ꞌbã ágófũku kí be.” ");
INSERT INTO luc_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Léyã umvi Rãkẹ́lị̃ ní, “Míní mâ ágô pajó rá rĩ ca míní ku yã? ꞌDĩ ꞌbã drị̃ gâsĩ ílẽ vâ mâ ngọ́pị ꞌbã ife ágófũku rú rĩ palé ĩndĩ yã?” Rãkẹ́lị̃ umvi dó ĩꞌdiní jọ, “Ị́nị́ ãndrũ rĩ sĩ ĩꞌdi dó mụ ru icílé mí be.” ");
INSERT INTO luc_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Léyã tẽ dó ágô Yãkóꞌbõ amụ́ agá ĩndróloŋá sĩ ámvụ́ agâlé, lị dó drị̃ la jọ, “Ãndrũ rĩ gá má ĩgbã mi rá, mâ ngọ́pị ꞌbã ife ágófũku rú rĩ sĩ. Mi ãndrũ rĩ gá ko má be.” Yãkóꞌbõ mụ dô sĩ kolé Léyã be. ");
INSERT INTO luc_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ãdróŋá are Léyã ꞌbã áwáŋá rá, ịsụ́ dó sĩ ꞌa rá, tị dó sĩ ngọ́tị́ ágọ́bị́ Yãkóꞌbõ ní námbã tõwú sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Léyã jọ, “Ãdróŋá ũfẽ dó mání ụ̃rọ̃drị́ rá ãꞌdusĩku ĩzóŋá mádrị́ ãtíꞌbó ru rĩ áfẽ ándrá ĩꞌdi Yãkóꞌbõ nî.” Uja dó sĩ ngọ́tị̂ rụ́ ꞌdalé Ĩsãkárĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Léyã ịsụ́ vâ ꞌa ãzí, tị dó sĩ Yãkóꞌbõ ní ngọ́tị́ ágọ́bị́ námbã ázíyá sĩ rĩ. ");
INSERT INTO luc_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Jọ, “Ãdróŋá fẽ mání drị̃lẹ́ba ndẽlépi rá rĩ ꞌbo. Ãma dó ãma icí mâ ágô Yãkóꞌbõ be rá, ĩꞌdi dó vâ áma lẽ rá, ĩꞌdi vâ mání ãrútáŋá fẽ ĩndĩ ãꞌdusĩku átị dó ĩꞌdiní anzị ãgọbị kí ázíyá.” ꞌDa dó sĩ ngọ́tị̂ rụ́ Zãbụ̃lọ́nị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Sáwã ãzí vúlé gá, Léyã tị ĩzóŋá, ꞌda rụ́ la Dị́nã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá ũrã Rãkẹ́lị̃ ꞌbã ị́jọ́, are ĩꞌdi ꞌbã áwáŋá rá ãzíla nzị̃ dó sĩ ĩꞌdi ꞌbã mvájólé rá. ");
INSERT INTO luc_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ịsụ́ ꞌa, tị dó sĩ ngọ́tị́ ágọ́bị́ ãzí jọ, “Ãdróŋá wụ̃ dó drị̃nzá áma drị̃ gá rĩ rá.” ");
INSERT INTO luc_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ꞌDa dó sĩ rụ́ la Yụ̃sụ́fụ̃ ꞌi, ãzíla jọ, “Úpí ꞌbã fẽ mání ngọ́tị́ ágọ́bị́ ãzí ị̃dị́.” ");
INSERT INTO luc_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rãkẹ́lị̃ la mụ Yụ̃sụ́fụ̃ tịlé ꞌbo ꞌdã ꞌbã vúlé gá, Yãkóꞌbõ jọ Lábãnĩ ní, “Ípẽ dó áma tị ma dó sĩ gõ ãmadrị̂lé. ");
INSERT INTO luc_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ífẽ áꞌdụ mâ ũkú kí anzị kí abe ãꞌdusĩku ánga míní ãzị́ kí ị́jọ́ sĩ rá ãzíla ífẽ ámụ dó sĩ rá. Ínị̃ dó ánga míní ãzị́ íngõpí yã rĩ gá rá.” ");
INSERT INTO luc_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Wó Lábãnĩ umvi ĩꞌdiní, “Áma ị́jọ́ drĩ fi ími drị̃ gá rá ímụ ku ãꞌdusĩku má andré újógó gá, Úpí wi mání sụ̃sụ́ míní adrujó ꞌdâ cí rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ílũ mání ãjẹ̃ míní lẽlé rĩ kî ãzíla ma kí ũfẽ rá.” ");
INSERT INTO luc_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yãkóꞌbõ umvi ĩꞌdiní, “Ínị̃ ánga míní ãzị́ ílí ũꞌbí ꞌdĩ kí agá ásị́ ãlu sĩ rĩ rá ãzíla kãbĩlõ mídrị̂ kpẹ̃ kí ũꞌbí ru la mání kí tãmbajó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kãbĩlõ mídrị́ ándrá wereŋá mání drĩ amụ́jó ku rĩ sĩ rĩ kpẹ̃ kí wẽwẽ rú mání kí tãmbajó rĩ sĩ ãzíla Úpí wi vâ míní sụ̃sụ́ ãngũ pírí mání acị́jó ri kí agá. Wó úꞌdîꞌda ma dó ãzị́ mádrị̂ kí nga sáwã íngõ gá?” ");
INSERT INTO luc_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lábãnĩ zị ĩꞌdi ị̃dị́, “Ílẽ má ũfẽ mi íngõpí?” Yãkóꞌbõ umvi ĩꞌdiní, “Álẽ ũfẽŋá ãzí ị̃dị́ ku, wó ídrĩ mání ị́jọ́ ãlu ꞌdĩ idé rá, ma mụ kãbĩlõ mídrị̂ kí tãmbaŋâ trũ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ífẽ ãndrũ má acị́ kãbĩlõ ãzíla ị̃ndrị́ mídrị́ ũꞌbí ꞌdĩ kí agâ sĩ, kãbĩlõ ãzíla ị̃ndrị́ ru uꞌbélépi kpĩcíkpĩcí rĩ kí ịnị rĩ kí abe pírí, kãbĩlõ mvaka ãzíla ị̃ndrịmvaŋa ịnị rĩ kí abe pírí ma mụ kí uyalé ãzíla kí ꞌdụlé mánî. ꞌDĩ dó adru ũyá mání lẽlé ífẽ mání rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ídrĩ dó drụ́zị́ kãbĩlõ ãzíla ị̃ndrị́ ru uꞌbélépi kpĩcíkpĩcí ku la kí ịsụ́ míní fẽlé mání ũyá ru rĩ kí agá ꞌdâ ku, mi dó nị̃ la tọndọlọ ánga ị́jọ́ pịrị rĩ ꞌi. Ídrĩ dó kãbĩlõ ãzíla ị̃ndrị́ ru uꞌbélépi ku rĩ kí ịsụ́ mádrị̂ kí agá ꞌdãá rá, mi dó nị̃ la rá má ụ̃gụ̃ dó kí angájó ãnãkpá mídrị̂ kí agá.” ");
INSERT INTO luc_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lábãnĩ umvi, “Má ãꞌị̃ ị́jọ́ ꞌdĩ rá. Ãma dó idé la cécé míní jọlé ꞌdĩ áni.” ");
INSERT INTO luc_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Wó ụ́ꞌdụ́ ꞌdã sĩ Lábãnĩ uya dó ị̃ndrọgọ ru uꞌbélépi kpĩcíkpĩcí ãzíla ị̃ndrị́ ãrónĩ ru uꞌbélépi kpĩcíkpĩcí rĩ kí kãbĩlõ ịnị rĩ abe fẽlé anzị ĩꞌdidrị̂ kí drị́ gá. ");
INSERT INTO luc_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Lábãnĩ ngọ́pịka ụꞌdụ kí dó ãnãkpá kpĩcíkpĩcí rĩ kí, mụ kí dó álị́ Yãkóꞌbõ rụ́ ꞌdãá rĩ sĩ kãbĩlõ kî trũ ãcị̃ ãzo ụ́ꞌdụ́ ꞌdụlépi na la gá. Yãkóꞌbõ mba dó sĩ kãbĩlõ Lábãnĩ drị́ acelépi rĩ kí tã. ");
INSERT INTO luc_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ꞌDã ꞌbã ũngúkú gá, Yãkóꞌbõ agá ife ị̃bị umvelé Pápũlũ, Ãlĩmóndĩ ãzíla Sãkãmórẽ rĩ kí ꞌbã kénĩ, upí dó úꞌbó la kí rá ãzíla aꞌbe dó sĩ kénĩ ꞌdã kí ụrụꞌbá imve rú. ");
INSERT INTO luc_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ũꞌbã dó ifê ꞌbã kénĩ ꞌdĩ kí ãkójó ãnãkpá ꞌbã kí sĩ ị̃yị́ mvụjó rĩ kí agâ sĩ pírí ãꞌdusĩku ãnãkpá ꞌdĩ kí jõ ĩlũwã ị̃yị́ mvụŋá gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ị́jọ́ ꞌdĩ sĩ ãnãkpá drĩ kí dó ĩlũwã ife ꞌbã kénĩ kí drị̃lẹ́ gá ꞌdãá ị̃yị́ mvụŋá gá, mvaka la kí ru uꞌbé lúbékẽ rú ãzíla kpĩcíkpĩcí ru. ");
INSERT INTO luc_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yãkóꞌbõ awa kãbĩlõ kí ị̃ndrị́ abe ndú-ndú, fẽ ja kí tị kãbĩlõ lúbékẽ ãzíla ịnị Lábãnĩ drị̂ ꞌba rụ́ lé ru. Ị́jọ́ ꞌdĩ sĩ, ịsụ́ ãngũ sĩ kãbĩlõ ĩꞌdidrị̂ kí tãmbajó rĩ Lábãnĩ drị̂ ꞌba rụ́ ꞌdãá ndú. ");
INSERT INTO luc_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ãnãkpá ãrónĩ ụrụꞌbá trũ ãlá rĩ drĩ kí dó idé ágó sĩ, Yãkóꞌbõ la ife ꞌdã ꞌbã kénĩ kí aꞌdụ́ ꞌbãlé ãngũ ĩꞌbã kí sĩ ị̃yị́ mvụjó rĩ gá, kî dó sĩ ĩlũwã kẹ̃lị́ká ꞌdĩ kí drĩdríŋĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Wó ꞌbã ife ꞌbã kénĩ kí ãnãkpá ũkpó kóru rĩ kí drị̃lẹ́ gá ku. Ãnãkpá Lábãnĩ drị̂ kí ũkpô kóru, wó Yãkóꞌbõ drị̂ kí dó sĩ pírí ũkpô trũ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ị́jọ́ ꞌdĩ sĩ, Yãkóꞌbõ acá dó sĩ ꞌbá kụ́rẹ́nị́ la rú. Ĩꞌdi ꞌbã kãbĩlõ kí, ꞌbá ãtiꞌbo rú rĩ kí, ngãmíyã kí ãzíla kãyĩnõ kí abe kí wẽwẽ rú. ");
INSERT INTO luc_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yãkóꞌbõ are ị́jọ́ anzị Lábãnĩ drị̂ ꞌbã kí unujó ĩꞌbã kí jọjó la, “Yãkóꞌbõ ꞌdụ ãko ãmã átẹ́pị drị̂ kí pírí ãzíla ịsụ́ dó sĩ málĩ ĩꞌdidrị̂ kí angájó ãko ãmã átẹ́pị drị́ kí agá rĩ rá.” ");
INSERT INTO luc_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ndre vâ Lábãnĩ lẽ ꞌi cécé ándrá ídu rĩ áni ku rĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Yãkóꞌbõ ní, “Ígõ vúlé ãngũ mí átẹ́pị drị̂ gá, kãká mídrị̂ ꞌbarụ̂lé ãzíla ma adru mí be cí.” ");
INSERT INTO luc_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ị́jọ́ ꞌdĩ sĩ Yãkóꞌbõ ị̃drị̃ ụ́ꞌdụ́kọ́ tị Léyã ꞌbaní Rãkẹ́lị̃ be amụ́jó ĩꞌdi drị̃ tẽjó ãngũ kãbĩlõ ꞌbã kí adrujó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Jọ ĩꞌbaní, “Ándre úꞌdîꞌda ĩmĩ átẹ́pị lẽ ma cécé ándrá ídu rĩ áni ku, wó Ãdróŋá mâ átẹ́pị drị̂ Ĩꞌdi má be cí. ");
INSERT INTO luc_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ĩmi ị̃rị̃trá ị̃nị̃ ánga ãzị́ ĩmĩ átẹ́pị ní ásị́ pírí sĩ rĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ĩꞌdiní táni áma ũnzã agá ũyá mádrị̂ kí sĩ pâlé mụdrị́ rá tí, wó Ãdróŋá fẽ idé ma ũnzí ku. ");
INSERT INTO luc_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Lábãnĩ drĩ táni jọ la, ‘Ị̃ndrị́ ru uꞌbélépi lúbékẽ rĩ kí adru mâ ũyá ru,’ ị̃ndrị́ kí mvaka kí tị lúbékẽ rú. Drĩ táni jọ la, ‘Ị̃ndrị́ kpĩcíkpĩcí rĩ kí adru mâ ũyá ru,’ ị̃ndrị́ kí pírí mvaka tị kpĩcíkpĩcí ru. ");
INSERT INTO luc_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ãdróŋá aꞌdụ́ ị̃ndrị́ kí pírí ĩmĩ átẹ́pị rụ̂lé rá ãzíla fẽ dó kí mánî. ");
INSERT INTO luc_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Sáwã ĩꞌbaní ĩlũwãjó rĩ gá urobí ũbĩ ma ándre ala gá ị̃ndrọgọ kí ĩlũwãlépi rĩ kí kpĩcíkpĩcí ru ãzíla uꞌbé kí ru lúbékẽ rú. ");
INSERT INTO luc_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mãlãyíkã Ãdróŋá drị̂ jọ mání urobí agá ꞌdãá, ‘Yãkóꞌbõ!’ Má ãꞌị̃, ‘Ma cí.’ ");
INSERT INTO luc_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","‘Índre ị̃ndrọgọ ị̃ndrị́ kí ĩlũwãlépi rĩ kí kpĩcíkpĩcí ru ãzíla lúbékẽ rú. Áfẽ ị́jọ́ ꞌdĩ ꞌbã idé kí ru íni la ãꞌdusĩku ándre ị́jọ́ Lábãnĩ ꞌbã idélé mí rụ́ ꞌdĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ma Ãdróŋá ándrá míní ru iꞌdalépi Bẹ̃tẹ́lị̃ gá, míní sĩ ãdu ũsũjó írã míní ịꞌdịlé rĩ drị̃ gá ãzíla míní sĩ ũyõ najó ĩꞌdiní rĩ ꞌi. Mí itú dó sĩ mi bábá sĩ gõjó ãngũ ándrá ími tịjó rĩ gâlé.’” ");
INSERT INTO luc_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rãkẹ́lị̃ umvi kí Léyã be Yãkóꞌbõ ní, “Ãko ãzí acelépi ãmã átẹ́pị drị́ gá ꞌdâ ãmaní ãwítã rú la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ĩꞌdi ãma ndre ãmị́yọ́ŋá ru. Ụzị ãma rá ãzíla iza séndẽ fẽlé ãma agá ĩꞌdiní rĩ kí pírí rá. ");
INSERT INTO luc_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Málĩ Ãdróŋá ꞌbã aꞌdụ́lé ãmã átẹ́pị drị̂lé ꞌdĩ kí pírí ãma ãni anzị ãmadrị̂ kí abe. Mí idé ị́jọ́ Ãdróŋá ꞌbã jọlé míní rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ị́jọ́ ꞌdĩ sĩ Yãkóꞌbõ itú ru, ũꞌbã anzị kí ũkúka abe ngãmíyã kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Dro dó sĩ ĩꞌdi ꞌbã ãnãkpá kí ãko pírí ĩꞌdi ꞌbã ịsụ́lé Pãdãnĩ Ãrámũ gá rĩ kí abe ĩꞌdi drị̃lẹ́ gá trũ mụjó átẹ́pị̃ Ĩsákã rụ́ ãngũ Kãnánĩ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ị́jọ́ ꞌdĩ idé ru Lábãnĩ ꞌbã vúlé gá ịsụ́ ꞌdĩ sĩ mụ ĩꞌdi ꞌbã kãbĩlõ kí ꞌbíko lịlẹ́, wó ị̃zẹ́pị̃ Rãkẹ́lị̃ ụ̃gụ̃ ĩꞌdi ꞌbã ãdroŋa ĩnzõ rú jó agá rĩ kí ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yãkóꞌbõ ulé Lábãnĩ Ãrãménĩyã rú rĩ, apá dó sĩ ĩꞌdiní vúlé gá azịŋá kóru. ");
INSERT INTO luc_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Aꞌdụ́ ãko ĩꞌdidrị̂ kí pírí trũ apájó gbõŋáŋá ru. Za ị̃yị́ Ũfũrátĩ ꞌi ãzíla ja dó sĩ drị̃ mụlé ãngũ ꞌbé ꞌa rú Gị̃lẹ́dị̃ drị̂ gâlé ru. ");
INSERT INTO luc_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Lábãnĩ are Yãkóꞌbõ apá rá rĩ ụ́ꞌdụ́ na vúlé gá. ");
INSERT INTO luc_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ꞌDụ dó sĩ ãgọbị ĩꞌdidrị̂ kí ĩndĩ sĩ Yãkóꞌbõ vú drojó ụ́ꞌdụ́ ázị̂rị̃ kpere ĩꞌdiní ĩꞌdi arụ́ agá ãngũ ꞌbé ꞌa rú Gị̃lẹ́dị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Wó Ãdróŋá amụ́ ru iꞌdalé Lábãnĩ Ãrãménĩyã rú rĩ ní urobí agâ sĩ ị́nị́ ꞌdã sĩ, jọ ĩꞌdiní, “Lẽ mí adru mịfị́ trũ íjọ Yãkóꞌbõ ní ị́jọ́ ãzí múké jõ ku ũnzí la ku.” ");
INSERT INTO luc_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yãkóꞌbõ sõ hémã ĩꞌdidrị̂ ãngũ ꞌbé ꞌa rú Gị̃lẹ́dị̃ gá ãzíla Lábãnĩ ãsõ vâ hémã ĩꞌbadrị́ kãká ĩꞌdidrị̂ abe rĩ kí ꞌdãá ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lábãnĩ jọ Yãkóꞌbõ ní, “Mí ulé dó ma ãzíla mí aꞌdụ́ mâ izonzị kí bãdã-tị́ áni la ãꞌdu ị́jọ́ sĩ? ");
INSERT INTO luc_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Mí ulé ma sĩ apájó mání ũní ãꞌdu sĩ yã? Ídrĩ ájẹ́ mání lũ la rá la, ma ájẹ́ ími tị ãpẽ ãyĩkõ sĩ úngó tuŋá ụ̃ꞌdị́ sĩ, árị́ sĩ ãzíla kõyõ trũ rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ífẽ vâ mání sáwã azịjó mâ ị̃zẹ́pịka ãzíla mâ ngọ́pịka kí abe ku. ꞌDã ị́jọ́ ãzí ífí kóru la. ");
INSERT INTO luc_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Áma ũkpó cí sĩ ími idéjó ũnzí, wó Ãdróŋá mí átẹ́pị drị̂ iꞌda ru mání ị́nị́ ájẹ rĩ sĩ jọ, ‘Lẽ mí adru mịfị́ trũ íjọ Yãkóꞌbõ ní ị́jọ́ ãzí múké jõ ku ũnzí la ku.’ ");
INSERT INTO luc_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ánị̃ rá mi apá íni la ílẽ ásị́ pírí sĩ calé ĩmi drị́ko gâlé rá, wó mí ụ̃gụ̃ dó mâ ꞌbawụga jó agá ꞌdãá rĩ kí ĩndĩ la ãꞌdu ị́jọ́ sĩ yã?” ");
INSERT INTO luc_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yãkóꞌbõ umvi ĩꞌdiní, “Má idé ụ̃rị̃ sĩ, ãꞌdusĩku má ũrã mí icó mî ị̃zẹ́pịka kí ꞌdụlé mádrị́ ꞌdâ rá. ");
INSERT INTO luc_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Wó ídrĩ ịsụ́ la mî ꞌbawụga kí ꞌbá ãzí ꞌdâ la drị́ cí yã áni ála ꞌbá la ꞌdã ꞌdị rá, kãká ãmadrị́ mí be ꞌdĩ kí dó adru ãmã sãdínĩ, mí undré drĩ ãko mídrị̂ kí mádrị̂ kí agá ꞌdâ ãzíla mí uya mídrị̂ kí ꞌdụlé.” Yãkóꞌbõ nị̃ Rãkẹ́lị̃ ụ̃gụ̃ Lábãnĩ ꞌbã ꞌbawụga jó agá rĩ kí nĩ rĩ gá ku. ");
INSERT INTO luc_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lábãnĩ mụ hémã Yãkóꞌbõ drị̂ kí ꞌa undrê trũ, fi Léyã drị̂ agá ãzíla ũkú ị̃rị̃ ãtiꞌbo rú rĩ ꞌbadrị̂ kí agá wó ịsụ́ ĩꞌdi ꞌbã ꞌbawụga kí ku. ꞌDã ꞌbã ũngúkú gá, fi dó Rãkẹ́lị̃ drị́ hémã agá. ");
INSERT INTO luc_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rãkẹ́lị̃ aꞌdụ́ ꞌbawụga jó agá rĩ kí, ꞌbã kí íníríkó rijó ngãmíyã drị̃ gá jũrúwã rú rĩ agá, rĩ dó kí drị̃ gá cí. Lábãnĩ undré ãngũ hémã agá ꞌdãá pírí ịsụ́ dó ãko ꞌdĩ kí ku. ");
INSERT INTO luc_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rãkẹ́lị̃ jọ átẹ́pị̃ ní, “Mí idé mání ũmbã sĩ ku má átẹ́pị, má icó pá tulé ụrụgá ími drị̃lẹ́ gá ku ãꞌdusĩku ándre ĩmbá.” Lábãnĩ ndrụ̃ dó ꞌbawụga jó agá rĩ kí tí ịsụ́ dó kí ku. ");
INSERT INTO luc_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yãkóꞌbõ ásị́ iza dó ru rá zị dó Lábãnĩ ũmbã rú, “Ị́jọ́ ũnzí mání izalé mí rụ́ míní sĩ ãma vú adrojó rĩ ãꞌdu? ");
INSERT INTO luc_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Índrụ̃ dó úꞌdîꞌda ãko mádrị̂ kí ꞌa pírí ãko míní ịsụ́lé mî ní la rú rĩ dó ãꞌdu? Íꞌbã ĩꞌdi ãmvé ꞌdâ sãdínĩ mádrị̂ ꞌbã ndre kî sĩ cé ꞌbá mídrị̂ kí abe. ꞌBã lị kí sĩ ị́jọ́ ãma drĩdríŋĩ gá mí be ãꞌdi múké la nĩ yã rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Ári uꞌálé mí be ílí kãlị́ ị̃rị̃; ãnãkpá mídrị̂ ĩcẽ kí tịŋá gá ku, wó ána vâ mî kãbĩlogo kí ku. ");
INSERT INTO luc_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ụ̃bọ̃gụ̃ ci jõ mî kãbĩlõ yã áni, ma ũfẽ la ma ꞌi. Má agụ vâ iꞌdalé la míní sĩ jọjó la ꞌdã ị́jọ́ mâni ku la ku. Ãko mí ãni ụ̃gụ̃lé ị́nị́ sĩ jõku ị̃tụ́ sĩ rĩ kí, ífẽ ándrá má ũfẽ kí ma ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ári velé ị̃tụ́kã gá ãzíla ị̃gbẹ̃ ri áma fụlé ị́nị́ sĩ ụ́ꞌdụ́ kóŋâ kóru. ");
INSERT INTO luc_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Idé ru ꞌdĩ áni ílí kãlị́ ị̃rị̃ mání sĩ uꞌájó mí be ꞌdĩ kí agá ꞌdâ. Ánga ãzị́ ílí mụdrị́ drị̃ sụ sĩ mî ị̃zẹ́pịka ị̃rị̃ ꞌdĩ kí ĩgbãjó, ílí ázíyá sĩ ãnãkpá kí ịsụ́jó ãzíla mí uja áma ũfẽŋá pâlé mụdrị́. ");
INSERT INTO luc_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Wó Ãdróŋá má áyị́pị Ịbụrahị́mụ̃ drị̂ ãzíla má átẹ́pị Ĩsákã drị̂ drị̃ tá adru agá má be ku la, mí tá áma tị ãpẽ agá drị́drị́ ru. Wó Ãdróŋá ndre ãzị́ mání ngalé rĩ rá, ãzíla ị́nị́ ájẹ rĩ sĩ lị ị́jọ́ ãma drĩdríŋĩ gá mí be.” ");
INSERT INTO luc_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lábãnĩ umvi Yãkóꞌbõ ní, “Ũkú ꞌdĩ kí mâ ị̃zẹ́pịka kî; anzị ĩꞌbadrị́ ꞌdĩ kí má ãni, ãnãkpá ꞌdĩ kí má ãni ãzíla mí icó kî trũ mụlé rá. Ị́jọ́ mgbã sĩ ãko pírí míní ndrelé ꞌdĩ kí má ãni. Ma icó ị́jọ́ ũnzí idélé mâ ị̃zẹ́pịka kí ụrụꞌbá gá mâ ngọ́pịka kí abe íngoní ru? ");
INSERT INTO luc_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ma bábá tị icíjó mí be. Ãtra írã ãma igájó tị icíma ãmadrị́ ꞌdĩ agá.” ");
INSERT INTO luc_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ị́jọ́ ꞌdĩ sĩ Yãkóꞌbõ aꞌdụ́ írã ịꞌdị ĩꞌdi ụrụgá pịrị-pịrị sãdínĩ ru. ");
INSERT INTO luc_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jọ ãgọbị ĩꞌdidrị́ ꞌdĩ ꞌbaní, “Ĩtra írã ãzí kî.” Ị́jọ́ ꞌdĩ sĩ ĩmi ũꞌbã kí ngúlú ru ãngũ ãlu gá. ꞌDã ꞌbã ũngúkú gá, na kí dó íná írã drõlé ngúlú ru ꞌdĩ kí andre gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lábãnĩ ꞌda dó rụ́ la Yégã Sãhãdụ́tã ꞌi, Yãkóꞌbõ ꞌda rụ́ la Gãlị́dị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lábãnĩ jọ Yãkóꞌbõ ní, “Írã drõlé ꞌdĩ kí sĩ ãma igájó.” Ị́jọ́ ꞌdĩ bãsĩ ãngũ ꞌdã rụ́ ꞌdajó Gãlị́dị̃ ꞌi ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Lábãnĩ jọ vâ, “Úpí ꞌbã andré ãngũ ãmaní ãma iré agá ꞌdĩ gá ꞌdâ.” Cọtị úꞌda vâ ãngũ ꞌdã rụ́ Mị̃sị́pã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Lábãnĩ mụ vâ ị́jọ́ jọŋâ trũ drị̃ gá jọ, “Ídrĩ mâ ị̃zẹ́pịka kí ĩcãndĩ rá, ídrĩ vâ ũkú ãzí ndú la kí aꞌdụ́ ádrĩ táni ị́jọ́ nị̃ drị̃ la gá ku tí, lẽ ínị̃ rá Ãdróŋá la ãma andré ꞌdĩ.” ");
INSERT INTO luc_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lábãnĩ jọ vâ Yãkóꞌbõ ní, “Írã mání drõlé ãzíla írã mání iꞌdịlé ãma drĩdríŋĩ gá mí be ꞌdĩ kí sãdínĩ ru. ");
INSERT INTO luc_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Írã drõlé ãzíla ịꞌdịlé ꞌdĩ kí pírí sãdínĩ. Má icó alịlé írã drõlé ꞌdĩ drị̃ gâsĩ ãꞌdị́ ꞌdịjó mí be ku, lẽ mí alị vâ ĩꞌdi drị̃ gâsĩ ãꞌdị́ ꞌdịjó má be ku. ");
INSERT INTO luc_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ãdróŋá Ịbụrahị́mụ̃ drị̂ ãzíla Nãhọ́rị̃ drị̂ ãzíla Ãdróŋá ĩꞌbã átẹ́pị drị̂ la ị́jọ́ awa ãma drĩdríŋĩ gá nĩ.” Ị́jọ́ ꞌdĩ sĩ Yãkóꞌbõ na dó ũyõ Ãdróŋá átẹ́pị Ĩsákã drị̂ ꞌbã rụ́ sĩ, sĩ ị́jọ́ azịlé rĩ kí tãmbajó. ");
INSERT INTO luc_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Lị ãnãkpá, idé dô sĩ ĩꞌdi ídétáŋá ru ꞌbé sị́ gá ꞌdãá. Umve kãká ĩꞌdidrị̂ kí ínâ nalé. Kí mụ ínâ nalé ꞌbo, ko kí dó sĩ ụ́ꞌdụ́ ꞌbé sị́ gá ꞌdãá ũgũgõ. ");
INSERT INTO luc_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ụ̃ꞌbụ́tị ụ́ꞌdụ́ ãzí rĩ drị̂ sĩ Lábãnĩ azị dó ĩꞌdi ꞌbã ngọ́pịka ꞌbaní ị̃zẹ́pịka abe ãzíla wi dó ĩꞌbaní sụ̃sụ́. ꞌDã ꞌbã ũngúkú gá, gõ dó vúlé ĩꞌdidrị́ko gâlé. ");
INSERT INTO luc_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yãkóꞌbõ ꞌbã mụ agá gẹ̃rị̃ gá ꞌdâ, mãlãyíkã Ãdróŋá drị̂ amụ́ kí drị̃ ụfụlé ĩꞌdi be. ");
INSERT INTO luc_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yãkóꞌbõ la mụ kí ndrelé ꞌbo, jọ, “ꞌdĩ kámbĩ Ãdróŋá drị̂ ꞌi,” ꞌda dó sĩ ãngũ ꞌdã ꞌbã rụ́ Mãhãnãyị́mụ̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ꞌDã ꞌbã ũngúkú gá, Yãkóꞌbõ pẽ ꞌbá ị́jọ́ ujílépi rĩ kí tị ĩꞌdi drị̃lẹ́ gá mụjó ádrị́pị̃ Ị́sãwụ̃ rụ́ ãngũ umvelé Sẽyírĩ rĩ gá ꞌdĩ sụ́rụ́ Ídõmũ ꞌi rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Jọ ĩꞌbaní; “Ị́jọ́ ĩminí mụlé jọlé ãmbógó mádrị́ Ị́sãwụ̃ ní rĩ ꞌdĩ: ‘Ãtíꞌbó mí drị́ Yãkóꞌbõ jọ, ma jõ uꞌá agá Lábãnĩ be acájó kpere ãndrũ. ");
INSERT INTO luc_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ma tị́, kãyĩnõ, kãbĩlõ ãzíla ị̃ndrị́ kî trũ ãzíla ãtiꞌbo ãgọbị rú ãzíla ũkú ru rĩ kî abe. Ápẽ ụ̃pịgọŋa ꞌdĩ kí tị ãmbógó mádrị̂ mí rụ̂lé sĩ nị̃jó la áma ị́jọ́ fi nõ ími drị̃ gá rá yã áni.’” ");
INSERT INTO luc_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ꞌBá ụ̃pịgọŋa rú ꞌdĩ kí mụ ãgõlé Yãkóꞌbõ rụ́ ꞌdõlé ꞌbo jọ kí ĩꞌdiní, “Ãmụ kpere mî ádrị́pị Ị́sãwụ̃ rụ̂lé, ãzíla ĩꞌdi amụ́ drị̃ ụfụlé mí be ꞌbá túrú sụ kí abe.” ");
INSERT INTO luc_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yãkóꞌbõ idé ụ̃rị̃ sĩ ãzíla ásị́ la mvu rá, awa dó ꞌbá ĩꞌdidrị̂ kí tị ị̃rị̃ ãzíla awa vâ tị́ kí, ị̃ndrị́ kí, Kãbĩlõ kí ãzíla ngãmíyã kí abe tị ị̃rị̃-ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ũrã ĩꞌdi ásị́ gâlé, “Ị́sãwụ̃ drĩ amụ́ ãlí gá wókõ ãlu rĩ gâsĩ, ꞌbá wókõ ãzí rĩ gá acelépi rĩ kí sĩ ru pa rá.” ");
INSERT INTO luc_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ꞌDã ꞌbã ũngúkú gá, Yãkóꞌbõ zị Ãdróŋá ꞌi, “Ãdróŋá má áyị́pị Ịbụrahị́mụ̃ drị̂ ãzíla Ãdróŋá má átẹ́pị Ĩsákã drị̂, Úpí ándrá jọlépi la mání, ‘Ígõ vúlé sụ́rụ́ mídrị̂ agá kãká mídrị̂ ꞌba rụ̂lé, ãzíla ma fẽ mi adru múké rĩ ꞌi.’ ");
INSERT INTO luc_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Má icó ásị́ ị̃gbẹ̃ ãzíla ị́jọ́ mgbã míní iꞌdalé ãtíꞌbó mídrị̂ ní rĩ sĩ ku. Áza ándrá Yõrĩdánĩ ꞌi túré áma drị́ gá rĩ sĩ ãko wereŋá kí abe, úꞌdîꞌda má acá dó ꞌbá trũ ũꞌbí ru tị trũ ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ázị ími tị gá, ípa ma, má ádrị́pị Ị́sãwụ̃ drị́ gá, ãꞌdusĩku ma idé ĩꞌdi sĩ ụ̃rị̃ sĩ drĩ amụ́ ãꞌdị́ gá má rụ́ ãzíla anzịŋá ꞌdĩ kí ꞌbã andre abe rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Wó íjọ ándrá mání, ‘Ma ãndá-ãndá ru fẽ míní adrulé múké, mi kpẹ̃ ãzíla anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí adru cécé cínákí mĩrĩ tị gá rĩ áni, ícó kí lãlé ku.’” ");
INSERT INTO luc_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yãkóꞌbõ la dó mụ ụ́ꞌdụ́ kolé ị́nị́ ꞌdã sĩ ꞌdãá ꞌbo, uya ãko ãzí kí fẽlé ádrị́pị̃ Ị́sãwụ̃ ní ãwãꞌdĩfô rú, ");
INSERT INTO luc_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ị̃ndrị́ ãrónĩ rĩ kí túrú ị̃rị̃, ị̃ndrọgọ kí kãlị́ ị̃rị̃, kãbĩlõ ãrónĩ rĩ kí túrú ị̃rị̃ ãzíla kãbĩlogo kí kãlị́ ị̃rị̃, ");
INSERT INTO luc_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ngãmíyã ãrónĩ rĩ kí kãlị́ na mvaka abe, tị́ ãrónĩ rĩ kí kãlị́ sụ, mọ́nị̃gọ́ kí mụdrị́, kãyĩnõ ãrónĩ rĩ kí kãlị́ ị̃rị̃, ágó rĩ kí mụdrị́. ");
INSERT INTO luc_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Fẽ dó kí ãtiꞌbo ĩꞌdidrị̂ kí drị́ gá tãmbalé kúmú ãlu-ãlu ĩꞌdi sĩ ĩꞌdi sĩ; jọ ãtiꞌbo ꞌdĩ ꞌbaní, “Ĩmụ drị̃lẹ́ gá wó ĩmi aꞌbe jõ ãngũ ãma drĩdríŋĩ gá ãnãkpá ꞌdĩ kí abe rĩ mgbọ.” ");
INSERT INTO luc_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Imbá ãtíꞌbó ãtiꞌbo kí drị̃ ꞌdelépi rĩ jọ, “Má ádrị́pị Ị́sãwụ̃ drĩ dó drị̃ ụfụ ĩmi trũ ãzíla zị jõ dó, ‘Ĩmi ãꞌdi ãni, ãzíla ĩmi mụ íngõlé, ãnãkpá ĩmi drị̃lẹ́ gá ꞌdĩ kí ꞌbã ꞌdị́pị ãꞌdi ꞌi?’ ");
INSERT INTO luc_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ĩjọ dó íni, ‘Kí ãtíꞌbó mídrị́ Yãkóꞌbõ ãni. Ãfẽ kí ãwãꞌdĩfô rú úpí mádrị́ Ị́sãwụ̃ ní ãzíla ĩꞌdi amụ́ ãma vúlé gá ꞌdĩ.’” ");
INSERT INTO luc_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Imbá vâ námbã ị̃rị̃ sĩ rĩ, námbã na sĩ rĩ ãzíla ꞌbá pírí kí vú ãbĩlépi ãnãkpá abe ꞌdĩ kí: “Ĩjọ ị́jọ́ ãlu ꞌdĩ ꞌbã vúŋá Ị́sãwụ̃ ní ĩdrĩ drị̃ ụfụ ĩꞌdi be rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Lẽ ĩjọ ĩꞌdiní, ‘Ãtíꞌbó mídrị́ Yãkóꞌbõ la amụ́ ãma vúlé gá ꞌdĩ.’” Yãkóꞌbõ ũrã ásị́ sĩ, “Ãko mání fẽlé ãwãꞌdĩfô rú drị̃lẹ́ gâlé ꞌdĩ kí sĩ, ádrĩ dó drị̃ ụfụ Ị́sãwụ̃ be, ĩꞌdi dó áma aꞌị́ ádrị́pị rú rá.” ");
INSERT INTO luc_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ị́jọ́ ꞌdĩ sĩ ãko Yãkóꞌbõ ꞌbã fẽlé ãwãꞌdĩfô rú rĩ kí údro kí ĩꞌdi ꞌbã drị̃lẹ́ gá, wó ace ru ụ́ꞌdụ́ kolé ị́nị́ ꞌdã sĩ hémã ĩꞌdidrị̂ agá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ị́nị́ ꞌdã sĩ Yãkóꞌbõ angá, ꞌdụ ĩꞌdi ꞌbã ũkú ị̃rị̃ Léyã kí Rãkẹ́lị̃ be, ũkú ĩꞌdidrị́ ị̃rị̃ ãtiꞌbo rú rĩ kí ãzíla anzị mụdrị́ drị̃ ãlu ꞌdĩ kí abe za dó sĩ ị̃yị́ Yãbọ́kị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ĩꞌdi mụ ꞌbá ĩꞌdidrị̂ kí izálé ꞌá ꞌdã sĩ pírí ꞌbo, izá dó vâ ãko ĩꞌdidrị̂ kí pírí ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ị́jọ́ ꞌdĩ sĩ Yãkóꞌbõ ace dó ru áꞌdụ̂sĩ vúlé ꞌdãá. ꞌDã ꞌbã ũngúkú gá, ágọ́bị́ ãzí ãlu la amụ́, uꞌbé kí ru kópé sĩ ĩꞌdi be kpere ãngũ ꞌbã ụwị́ agá. ");
INSERT INTO luc_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ágọ́bị̂ la mụ ndrelé la ꞌí icó Yãkóꞌbõ ũkpó ndẽlé ku, tị̃ drị́ Yãkóꞌbõ ꞌbã ĩfã úrósị́ gá rĩ gá, Yãkóꞌbõ úrósị́ anzé dó sĩ rá ĩꞌbã kí ru uꞌbé agá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ꞌDã ũngúkú gá Ágọ́bị̂ jọ ĩꞌdiní, “Mí ají ámụ ãꞌdusĩku ãngũ ụwị́ ꞌbo.” Yãkóꞌbõ jọ, “Má icó ími aꞌbelé ku kpere míní mání sụ̃sụ́ wi agá.” ");
INSERT INTO luc_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ágọ́bị̂ zị ĩꞌdi ꞌi, “Ími rụ́ ãꞌdi?” Umvi, “Yãkóꞌbõ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ꞌDã ũngúkú gá Ágọ́bị̂ jọ ĩꞌdiní, “Ími rụ́ icó dó adrulé Yãkóꞌbõ ꞌi ị̃dị́ ku, wó Ịsịrayị́lị̃ ꞌi, ãꞌdusĩku ĩmi uꞌbé ĩmi Ãdróŋá be ãzíla ꞌbá kí abe ãzíla índẽ dó sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yãkóꞌbõ jọ ĩꞌdiní, “ꞌBárĩ ílũ mání ími rụ́ fô.” Wó jọ ĩꞌdiní, “Mi áma rụ́ zị ãꞌdu ị́jọ́ sĩ?” Wi dó ĩꞌdiní sụ̃sụ́ ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ị́jọ́ ꞌdĩ sĩ Yãkóꞌbõ ꞌda dó ãngũ ꞌdã rụ́ Pẹ̃nị́yẹ́lị̃ ꞌi jọ, “Ĩꞌdi íni la ãꞌdusĩku ãndre ãma Ãdróŋá be mịfị́ gá mịfị́ gá, wó tí mba drĩ vâ áma tá ídri rú.” ");
INSERT INTO luc_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ị̃tụ́ agá ĩꞌdi drị̃ gá ĩꞌdiní dó alị agá Pẹ̃nị́yẹ́lị̃ gá ꞌdãá, ĩꞌdi dó pá ꞌbe agá ꞌbẽ-ꞌbẽ úrósị́ la ꞌbã anzéjó rá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ꞌDĩ bã sĩ ị́jọ́ kpere ãndrũ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã kí sĩ ị́sụ́ úrósị́ icílépi rĩ najó ku ꞌdĩ, ãꞌdusĩku áló ándrá Yãkóꞌbõ ꞌbã ĩfã úrósị́ gá rĩ ãni rú ị́sụ́ ꞌdã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yãkóꞌbõ ndre ádrị́pị Ị́sãwụ̃ ꞌbã amụ́ agá ãgọbị ĩꞌdidrị́ túrú sụ rĩ kî trũ, ị́jọ́ ꞌdĩ sĩ awa anzị kí íni: Léyã drị̂ kí Léyã drị́, Rãkẹ́lị̃ drị̂ kí Rãkẹ́lị̃ drị́ ãzíla izonzi ị̃rị̃ ãtiꞌbo rú Bílĩhã ãzíla Zị̃lị́pã ꞌbadrị̂ kí ĩꞌbadrị́. ");
INSERT INTO luc_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ꞌBã izonzi ị̃rị̃ ãtiꞌbo rú rĩ kí anzị ĩꞌbadrị̂ abe drị̃ gá, Léyã anzị ĩꞌdidrị́ rĩ kí abe kí ũngúkú gá, Rãkẹ́lị̃ kí ngọ́pị̃ Yụ̃sụ́fụ̃ be ãsị̃jó. ");
INSERT INTO luc_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yãkóꞌbõ mụ kí drị̃lẹ́ gá, ĩꞌdiní lẽ agá ca agá ádrị́pị̃ rụ̂lé, tị̃ ãja vụ̃rụ́ pâlé ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Wó Ị́sãwụ̃ cẹ̃ ĩꞌdi rụ̂lé drị̃ ụfụjó ĩꞌdi be, amvu ĩꞌdi kpãrã. Ri kí ị̃rị̃trá awálé awâwâ ãyĩkõ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ꞌDã ꞌbã ũngúkú gá, Ị́sãwụ̃ undré ãngũ pírí, ãzíla ndre ũkú kí anzị kí abe zị, “ꞌBá mí be ꞌdĩ kí ãꞌdi kî?” Yãkóꞌbõ umvi ĩꞌdiní, “Ãmbógó, ꞌdĩ kí anzị Ãdróŋá ꞌbã fẽlé mání ásị́ ị̃gbẹ̃ ĩꞌdidrị̂ sĩ rĩ kî.” ");
INSERT INTO luc_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ꞌDã ꞌbã ũngúkú gá, izonzi ị̃rị̃ ãtiꞌbo rú ꞌdĩ amụ́ kí anzị ĩꞌbadrị̂ kí abe ụ̃tị̃ kí ãja vụ̃rụ́, ");
INSERT INTO luc_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Léyã amụ́ kí anzị ĩꞌdidrị̂ abe. Rãkẹ́lị̃ amụ́ kí ngọ́pị̃ Yụ̃sụ́fụ̃ be ãsị̃jó, ãzíla ụ̃tị̃ kí pírí ãja vụ̃rụ́ ĩꞌdĩ drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ị́sãwụ̃ zị ĩꞌdi jọ, “Ãnãkpá tá mání drị̃ ụfụjó ĩꞌba abe ꞌda kí ípẽ kí bụ́lụ́ gá ãꞌdu ị́jọ́ sĩ?” Yãkóꞌbõ umvi jọ, “Mání sĩ ásị́ ị̃gbẹ̃ ịsụ́jó mídrị́ ãmbógó mádrị̂.” ");
INSERT INTO luc_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Wó Ị́sãwụ̃ jọ, “Má ádrị́pị ãko mádrị̂ kí wẽwẽ rú, ímba ãko míní trũ adrujó rĩ kí tã mínî.” ");
INSERT INTO luc_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yãkóꞌbõ jọ, “Yụ, ími ásị́ drĩ adru mání ị̃gbẹ̃ ru, mí áꞌị́ ãko mání fẽlé míní ꞌdĩ kî. Mání ími mẹ́lẹ́tị ndrejó rĩ ĩꞌdi cécé mání Ãdróŋá ꞌbã mẹ́lẹ́tị ndrejó rĩ áni, míní adrujó mání wọ̃rị́ ru úꞌdîꞌda rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Má ádrị́pị, mí aꞌị́ ãko mání ajílé míní fẽtáŋá ru ꞌdĩ kî, ãꞌdusĩku Ãdróŋá wi mání sụ̃sụ́ ãko ꞌdĩ kî sĩ.” Yãkóꞌbõ ũŋmĩ ĩꞌdi siri-siri kpere Ị́sãwụ̃ bã ãꞌị̃ agá. ");
INSERT INTO luc_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ꞌDã ꞌbã ũngúkú gá, Ị́sãwụ̃ jọ, “Lẽ ãma itú kí ãma mụjó, wó ma dó drị̃ ꞌde ma ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Wó Yãkóꞌbõ umvi jọ, “Ãmbógó ínị̃ vâ rá anzị acá kî dó ãvẹ̃vị̃ kóru, lẽ má ũrã ị́jọ́ kãbĩlõ kí drị̃ gá tị́ kî trũ ãzíla ĩꞌbã mvaka kí abe. Údrĩ kí dro ũkpó sĩ ụ́ꞌdụ́ ãlu ị̃dị́ yã áni, icó kí ũdrãlé pírí rá. ");
INSERT INTO luc_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Úpí mádrị̂ ímụ ãma drị̃lẹ́ gá ma dó ꞌde ími ũngúkú gá ãnãkpá mádrị́ ꞌdĩ kî trũ anzị kí abe jãjã rú kpere mání mụ agá ími arụ́ agá Ídõmũ gâlé.” ");
INSERT INTO luc_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ị́sãwụ̃ jọ ĩꞌdiní, “Lẽ má aꞌbe ãgọbị mádrị́ ꞌdĩ kí ꞌbã ãzí kí ꞌdâ.” Wó Yãkóꞌbõ umvi ĩꞌdiní, jọ, “Mi kí aꞌbe ꞌdâ ãꞌdu ị́jọ́ sĩ? Álẽ tá lú ásị́ ị̃gbẹ̃ ịsụ́lé mídrị́ ãmbógó mádrị̂.” ");
INSERT INTO luc_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ị́jọ́ ꞌdĩ sĩ Ị́sãwụ̃ iꞌdó dó ãcị̃ ĩꞌdidrị́ mụjó Ídõmũ gá rĩ ụ́ꞌdụ́ ꞌdã sĩ. ");
INSERT INTO luc_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Wó Yãkóꞌbõ uja mụlé Sụ̃kọ́tị̃ gá, sị jó sĩ ĩꞌdiní ụ́ꞌdụ́ kojó rĩ ꞌi ãzíla drõ bụ́rụ́jọ́ ãnãkpá ꞌbanî. ꞌDĩ bãsĩ ị́jọ́ sĩ ãngũ ꞌdã ꞌbã rụ́ umvejó Sụ̃kọ́tị̃ ꞌi ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yãkóꞌbõ ꞌbã angájó Pãdãnĩ Ãrámũ gá rĩ sĩ acá dó Sẹ̃kẹ́mụ̃ gá ꞌdĩ Kãnánĩ gá ãzíla sõ hémã ĩꞌdidrị̂ ãni rú táwụ̃nị̃ andre la gá rĩ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ĩgbã ãngũ ĩꞌdiní hémã sõjó rĩ Sẹ̃kẹ́mụ̃ ꞌbã átẹ́pị Hãmọ́rị̃ ꞌbã ngọ́pịka ꞌbadrị́ sílĩvã 100 sĩ. ");
INSERT INTO luc_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Uja dó ãlĩtárĩ sịlé ꞌdãá ãzíla ꞌda dó sĩ rụ́ la Ị́lị̃-Ị̃lọ́hẹ̃-Ịsịrayị́lị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ụ́ꞌdụ́ ãlu Yãkóꞌbõ ị̃zẹ́pị Dị́nã Léyã ꞌbã tịlé rĩ mụ ãmụ́ ru ũkú Kãnánĩ rú la ꞌba rụ́. ");
INSERT INTO luc_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hãmọ́rị̃ úpí Hị́vị̃ rú ãngũ ꞌdã gá rĩ ꞌbã ngọ́pị Sẹ̃kẹ́mụ̃ la mụ Dị́nã ndrelé ꞌbo, ꞌdụ ĩꞌdi ãzíla uja ĩꞌdi ụrụlé rá. ");
INSERT INTO luc_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ásị́ la ꞌde Dị́nã Yãkóꞌbõ ị̃zẹ́pị drị̃ gá, ãzíla lẽ ĩꞌdi jọ dó sĩ ĩꞌdiní ị́jọ́ sĩ ĩꞌdi ũcĩjó ꞌbã lẽ rụ̂ sĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ị́jọ́ ꞌdĩ sĩ Sẹ̃kẹ́mụ̃ jọ átẹ́pị̃ Hãmọ́rị̃ ní, “Álẽ mí ĩgbã mání ĩzóŋá ꞌdĩ ꞌi ũkú ru.” ");
INSERT INTO luc_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yãkóꞌbõ la mụ arelé la úfẽ ị̃zẹ́pị̃ ní drị̃nzá ĩꞌdi ụrụjó rĩ sĩ ꞌbo, wó ngọ́pịka ꞌbã kí drĩ adrujó ãnãkpá kí abe ásé agâlé rĩ sĩ, idé ị́jọ́ ãzí ku kpere anzị ꞌbã kí ãgõ agá. ");
INSERT INTO luc_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ꞌDã ꞌbã ũngúkú gá, Sẹ̃kẹ́mụ̃ ꞌbã átẹ́pị Hãmọ́rị̃ mụ ị́jọ́ jọlé Yãkóꞌbõ be. ");
INSERT INTO luc_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Anzị Yãkóꞌbõ drị̂ ãgõ kí dó ásé agâlé rĩ sĩ ãnãkpá kí abe. Kí mụ ị́jọ́ ꞌdĩ arelé ꞌbo, acá kí ũmbájírílí ị́jọ́ Sẹ̃kẹ́mụ̃ ꞌbã idélé ꞌbá Ịsịrayị́lị̃ gá ꞌdĩ kí uꞌdájó ĩꞌdi ꞌbã Yãkóꞌbõ ị̃zẹ́pị ụrụjó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hãmọ́rị̃ jọ Yãkóꞌbõ ní, “Mâ ngọ́pị Sẹ̃kẹ́mụ̃ lẽ ĩzóŋá mídrị́ ꞌdĩ ꞌi; ífẽ má ĩgbã ĩꞌdi ĩꞌdiní ũkú ru fô. ");
INSERT INTO luc_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Lẽ ãma itú ị́jọ́ la mí be ãmaní sĩ icójó ãma ĩgbãjó ãma drĩdríŋĩ gá ꞌbá mídrị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mí icó rilé ãma drĩdríŋĩ gá ꞌdâ rá ãngũ ãmadrị̂ mgbọ rú. Mí uꞌá alagá ꞌdâ ãzíla ínga bĩsírã sĩ málĩ ịsụ́jó alagá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ꞌDã ꞌbã ũngúkú gá, Sẹ̃kẹ́mụ̃ jọ Dị́nã ꞌbã átẹ́pị ꞌbaní ádrị́pịka kí abe, “Ĩmi ásị́ ꞌbã adru mání ị̃gbẹ́ ru, ãzíla ma ãko ĩminí lẽlé rĩ kí fẽ pírí rá. ");
INSERT INTO luc_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ĩlũ mání ãko ĩminí lẽlé rĩ kí ãꞌdu, ĩꞌbã ãjẹ̃ ũkú ĩgbãjó rĩ ãmbógó ru cécé ĩmĩ ũrãlé rĩ áni; ĩdrĩ mání ãꞌị̃ ĩzóŋá ꞌdĩ ĩgbãlé ũkú ru rá, ma ãko ĩminí lịlẹ́ rĩ kí ũfẽ pírí.” ");
INSERT INTO luc_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Anzị Yãkóꞌbõ drị̂ umvi kí Sẹ̃kẹ́mụ̃ kí átẹ́pị̃ Hãmọ́rị̃ be úlétáŋá sĩ, ãꞌdusĩku Sẹ̃kẹ́mụ̃ ꞌbã ĩꞌbã ámvọ́pị Dị́nã ní drị̃nzá fẽjó rá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Jọ kí ĩꞌbaní, “Ãma icó ãma ámvọ́pị fẽlé ĩgbãlé ꞌbá ru ĩtãrãlépi ku rĩ ní ku; ꞌdã la adru ãmaní drị̃nzá ru. ");
INSERT INTO luc_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ãma ị́jọ́ ꞌdĩ ãꞌị̃ rá la ĩdrĩ ãgọbị ĩmidrị̂ kí ĩtãrã pírí rá drĩ kí acá ãmã áni ꞌbo rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ꞌDã ꞌbã ũngúkú gá, ãma dó ãꞌị̃ ãmaní ãma ĩgbãjó ĩmi abe rá ãma dó sĩ uri ĩmi drĩdríŋĩ gá ãzíla ãma dó sĩ acá ꞌbá ãlu rú ĩndõ. ");
INSERT INTO luc_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Wó ĩdrĩ ị́jọ́ ãmaní jọlé ĩminí rĩ ãꞌị̃ ku ãzíla ĩmi ĩtãrã jõ ĩmi ku, ãma ãmã ámvọ́pị ꞌdụ rá ãzíla ãma ãngũ ĩmidrị́ ꞌdĩ aꞌbe rá.” ");
INSERT INTO luc_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ị́jọ́ jọlé ꞌdĩ indré kí Hãmọ́rị̃ ꞌbaní ngọ́pị̃ Sẹ̃kẹ́mụ̃ be ị́jọ́ múké la rú. ");
INSERT INTO luc_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sẹ̃kẹ́mụ̃ ĩꞌdi ꞌbá ĩꞌdi ꞌbã átẹ́pị drị́ko gá ꞌdãá rulé ãndânĩ rĩ, iza sáwã ị́jọ́ jọlé ꞌdĩ idéŋá gá ku ãꞌdusĩku ĩꞌdi ꞌbã Yãkóꞌbõ ị̃zẹ́pị Dị́nã lẽjó ambamba rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ị́jọ́ ꞌdĩ sĩ Hãmọ́rị̃ mụ kí ngọ́pị̃ Sẹ̃kẹ́mụ̃ be kẹ̃jị́tị táwụ̃nị̃ ĩꞌbadrị̂ drị̂ gá sĩ ị́jọ́ jọjó drị̃lẹ́ ĩꞌbadrị́ táwụ̃nị̃ ꞌdã gá ꞌdãá rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Jọ kí ĩꞌbaní, “Ãgọbị ꞌdĩ kí ãmã wọ̃rị́ka kî, lẽ ꞌba uꞌá kí ãngũ ãmadrị̂ gá ꞌdâ ãzíla ꞌbã idé kí bĩsírã; ãngũ ꞌdĩ mgbọ rú ĩꞌbaní sĩ rijó. Ãma icó izonzi ĩꞌbadrị̂ kí ĩgbãlé ãmaní ũkú ru rá ãzíla icó kí vâ ãmadrị̂ kí ĩgbãlé ĩꞌbaní ũkú ru rá. ");
INSERT INTO luc_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Wó ãgọbị ꞌdĩ kí ãꞌị̃ uꞌálé ãma abe ãzíla adrujó ãma abe ꞌbá ãlu rú rá la ãdrĩ kí ãgọbị ãmadrị̂ kí ĩtãrã pírí rá cécé kí ru ĩtãrãjó rá rĩ áni rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ãdrĩ kí ị́jọ́ ꞌdĩ nga ꞌdĩ áni rá, ãnãkpá ĩꞌbadrị̂ kí ãko ĩꞌbadrị̂ kí abe pírí kí mụ adrulé ãma ãni. Ị́jọ́ ꞌdĩ sĩ, lẽ ãmã ãꞌị̃ kí ị́jọ́ ĩꞌbaní lẽlé rĩ kí, ãma dó sĩ uꞌá ĩꞌba abe.” ");
INSERT INTO luc_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ꞌBá pírí táwụ̃nị̃ ꞌdã agá ꞌdãá rĩ ãꞌị̃ kí ị́jọ́ Hãmọ́rị̃ ꞌbã kí jọlé Sẹ̃kẹ́mụ̃ be rĩ kí pírí rá, ãzíla îtãrã dó sĩ ãgọbị fũlépi kẹ̃jị́tị táwụ̃nị̃ ꞌdã drị̂ agâ sĩ rĩ kí pírí. ");
INSERT INTO luc_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ụ́ꞌdụ́ na ĩꞌbã ãkõzá ꞌbã kí drĩ jajó ku rĩ gá, anzị Yãkóꞌbõ drị́ ị̃rị̃, Sị̃mọ́nị̃ kí Lẹ́vị̃ be Dị́nã ꞌbã ádrị́pịka rú rĩ ꞌdụ kí ménéŋá séfũ rú rĩ kí trũ mụjó táwụ̃nị̃ ꞌdã agâlé ꞌbá ꞌdã ꞌbaní nị̃ŋâ kó ru, ụꞌdị́ kí dó sĩ ãgọbị ꞌdãá rĩ kí pírí. ");
INSERT INTO luc_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ꞌBá uꞌdị́lé ꞌda kí agá ĩndĩ rĩ kí Hãmọ́rị̃ kí ngọ́pị̃ Sẹ̃kẹ́mụ̃ be ãzíla aꞌdụ́ kí dó ĩꞌbã ámvọ́pị̃ Dị́nã ꞌi Sẹ̃kẹ́mụ̃ drị́ jó agá rĩ sĩ ãzíla mụ kí dó rá. ");
INSERT INTO luc_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Anzị Yãkóꞌbõ drị̂ ra kí dó ãko ꞌbá ũdrãlépi rá ꞌdã ꞌbadrị̂ kí sĩ ãrígọ́tị ũfẽjó ãꞌdusĩku ála ĩꞌbã ámvọ́pị̃ Dị́nã ụrụjó ãngũ ꞌdã gá ꞌdãá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ra kí tị́, ị̃ndrị́, kãbĩlõ, kãyĩnõ, ãko pírí táwụ̃nị̃ ꞌdã gá ꞌdãá rĩ kí ãzíla ãkónã amvụ́ agá rĩ kí trũ. ");
INSERT INTO luc_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ꞌDụ kí ãko pírí málĩ rú rĩ kí ãzíla ĩꞌbã ũkúka kí anzịŋá kí abe bãdã-tị́ ru ãzíla ra kí ãko jó agá rĩ kí pírí. ");
INSERT INTO luc_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yãkóꞌbõ jọ dó Sị̃mọ́nị̃ ꞌbaní Lẹ́vị̃ be, “Ĩmi ají dó ị́jọ́ áma drị̃ gá ꞌbo, ꞌbá Kãnánĩ rú, Pẹ̃rẹ́zị̃ rú ãzíla ꞌbá uꞌálépi ãngũ ꞌdĩ agá rĩ kí dó mụ áma ngụ̃lé ũnzí. Ãma kãlãfe lú were rú, ãzíla ꞌbá ꞌdĩ drĩ kí dó ru icí ãꞌdị́ ꞌdịlé ãma abe kí ãma ị̃lị̃kị̃ ꞌbá mádrị́ lị́cọ́ agá rĩ kí abe pírí.” ");
INSERT INTO luc_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Wó Sị̃mọ́nị̃ kí Lẹ́vị̃ be jọ kí Yãkóꞌbõ ní, “Ãma icó ãma ámvọ́pị aꞌbelé drị̃ izalé ĩzóŋá ãwụ́ rĩ áni ku.” ");
INSERT INTO luc_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ Yãkóꞌbõ ní, “Ímụ uꞌálé Bẹ̃tẹ́lị̃ gá ꞌdãá. Ísị ãlĩtárĩ sĩ ídétáŋá idéjó rĩ Ãdróŋá ándrá ru iꞌdalépi míní sáwã ándrá míní apájó mí ádrị́pị Ị́sãwụ̃ sĩ rĩ nî.” ");
INSERT INTO luc_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ị́jọ́ ꞌdĩ sĩ Yãkóꞌbõ jọ ꞌbá ĩꞌdidrị́ jó agá rĩ ꞌbaní, ꞌbá pírí uꞌálépi ĩꞌdidrị́ko gá rĩ kí abe, “Ĩmi idé ĩmi ásị́ kí ãlá ru, ĩmi aꞌbe ãdroŋa ĩminí ajílé ꞌbá ãzí ꞌbã ãngũ gá ꞌdĩ kí cã ãzíla ĩsụ̃ bõngó ãla la kí áyụ. ");
INSERT INTO luc_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ãma kí mụ mụlé ãngũ ꞌdĩ aꞌbelé sĩ mụjó Bẹ̃tẹ́lị̃ gá, ma sĩ mụ ãlĩtárĩ sịlé Ãdróŋá áma ãzã kolépi ũcõgõ mádrị̂ kí agá ãzíla adrulépi má be ãngũ pírí mání acị́jó rĩ agá rĩ nî.” ");
INSERT INTO luc_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ị́jọ́ ꞌdĩ sĩ fẽ kî dó Yãkóꞌbõ drị́ ãdroŋa ĩꞌbã kí ajílé ꞌbá ãzí ꞌbã ãngũ gá rĩ kí ngílíngílí ĩꞌbã kí ándrá ũgĩlé bị́lẹ́ gá rĩ kí abe. Yãkóꞌbõ ị̃sị̃ dó sĩ kí kọmọrọ́ ife ị̃ndụ́ gá ãni rú Sẹ̃kẹ́mụ̃ andre gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yãkóꞌbõ kí mụ drị̃ kolé ngọ́pịka kí abe ꞌbo, Ãdróŋá ají ụ̃rị̃ ãmbógó la ꞌbá táwụ̃nị̃ ãníyágágá ꞌdãá rĩ kí ásị́ gá ị́jọ́ ꞌdĩ sĩ ꞌbá ãzí dó kí vú drolépi la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ụ́ꞌdụ́ were vúlé gá Yãkóꞌbõ acá kí ꞌbá ĩꞌdidrị́ko gá rĩ kí abe pírí Lụ́zị̃ úꞌda umvelé Bẹ̃tẹ́lị̃ ꞌi rĩ gá ꞌdĩ ãngũ Kãnánĩ gá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Sị dó ãlĩtárĩ sĩ ídétáŋá idéjó rĩ ꞌdãá, ꞌda dó sĩ ãngũ ꞌdã rụ́ Ị̃lị̃-Bẹ̃tẹ́lị̃ ꞌi ãꞌdusĩku ꞌdĩ ãngũ ándrá Ãdróŋá ꞌbã sĩ ru iꞌdajó ĩꞌdiní ĩꞌdi ꞌbã ándrá apájó ádrị́pị̃ sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Násị̃ Rẽbékã ĩtẽtẽnãlépi Dẽꞌbórã drã dó rá, ị̂sị̃ dó ĩꞌdi kọmọrọ́ ị̃ndụ́ gá Bẹ̃tẹ́lị̃ ꞌbã wókõ ándrá rĩ gá. Úꞌda dó sĩ kọmọrộ ꞌbã rụ́ kọmọrọ́ sĩ awájó rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yãkóꞌbõ la dó mụ ãgõlé Pãdãnĩ Ãrámũ gâlé ꞌbo, Ãdróŋá iꞌda ru ĩꞌdiní ị̃dị́ ãzíla wi vâ ĩꞌdiní sụ̃sụ́. ");
INSERT INTO luc_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ãdróŋá jọ ĩꞌdiní, “Ími rụ́ Yãkóꞌbõ ꞌi, wó ûmve dó mi Yãkóꞌbõ ꞌi ị̃dị́ ku; ími rụ́ la dó adru Ịsịrayị́lị̃ ꞌi.” ꞌDa dô sĩ rụ́ la Ịsịrayị́lị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ãdróŋá jọ ĩꞌdiní, “Ma Ãdróŋá Ũkpó ꞌDị́pị ꞌi; anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbã kpẹ̃ kí wẽwẽ rú, sụ́rụ́ kî sĩ ãfũ ími agá ꞌdâ, mi dó sĩ adru áꞌbị́ ũpi ꞌbã ãni la. ");
INSERT INTO luc_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ma ãngũ ándrá mání fẽlé Ịbụrahị́mụ̃ ꞌbaní Ĩsákã be rĩ fẽ mínî ãzíla ma vâ ĩꞌdi fẽ anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbaní ími vúlé gá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá aꞌbe dó Yãkóꞌbõ rá. ");
INSERT INTO luc_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yãkóꞌbõ ịꞌdị dó írã pịrị-pịrị rú ãngũ Ãdróŋá ꞌbã ándrá sĩ ị́jọ́ jọjó ĩꞌdi be rĩ gá ꞌdãá, ãzíla ũsũ wáyĩnĩ ídétáŋá ru rĩ kí ãdu be drị̃ la gá. ");
INSERT INTO luc_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yãkóꞌbõ ꞌda dó sĩ ãngũ ándrá Ãdróŋá ꞌbã sĩ ị́jọ́ jọjó ĩꞌdi be ꞌdã ꞌbã rụ́ Bẹ̃tẹ́lị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ꞌDã ꞌbã ũngúkú gá, acá kí drĩ Ĩfũrátã gá angájó Bẹ̃tẹ́lị̃ gá rĩ sĩ ku rú ãzíla ĩꞌbã kí drĩ adru agá rá-rá ru ꞌdĩ gá ꞌdâ, sáwã Rãkẹ́lị̃ ꞌbã sĩ ngọ́tị́ tĩjó rĩ acá dó rá ãzíla ngọ́tị̂ tĩŋá acá dó ũkpó-ũkpó. ");
INSERT INTO luc_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ngọ́tị̂ tĩŋá la mụ acálé ũkpó-ũkpó trẹ̃yị́, ũkú ngọ́tị́ tĩlépi rĩ jọ ĩꞌdiní, “Mí ide ụ̃rị̃ sĩ ku Rãkẹ́lị̃; ꞌdĩ ngọ́tị́ ágọ́bị́ ãzí rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rãkẹ́lị̃ ní lẽ agá drã agá drã-drã ꞌdĩ gá ꞌdâ, ꞌda dó ngọ́tị̂ rụ́ Bénõnĩ ꞌi wó átẹ́pị̃ ꞌda rụ́ la Bénzãmĩnĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rãkẹ́lị̃ la dó mụ drãlé ꞌbo, ị̂sị̃ dó ĩꞌdi gẹ̃rị̃ sĩ mụjó Ĩfũrátã gá úꞌda umvelé Bẹ̃tẹ̃lẹ̃hẹ́mụ̃ ꞌi rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yãkóꞌbõ su írã sĩ Rãkẹ́lị̃ ꞌbã ị́jọ́ agájó rĩ ị̃nádrị̃ Rãkẹ́lị̃ drị̂ gá ꞌdãá ãzíla írã ꞌdã drĩ kpere sáwã ꞌdĩ sĩ ꞌdãá cí sĩ ị̃nádrị̃ ꞌdã iꞌdajó. ");
INSERT INTO luc_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ịsịrayị́lị̃ mụ dó drị̃lẹ́ gá sĩ hémã ĩꞌdidrị̂ sịlé ãngũ Mĩgĩdálĩ Ị̃dẹ́rị̃ drị̂ ꞌbã drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ịsịrayị́lị̃ ní uꞌá agá ãngũ ꞌdã gá ꞌdãá, ngọ́pị̃ Rụ́bẹ̃nị̃ fi ũkú Rãkẹ́lị̃ drị́ ãtíꞌbó ru Bílĩhã drị́ jó agá, Ịsịrayị́lị̃ la mụ ị́jọ́ ꞌdĩ arelé ꞌbo, ala iꞌdó velé ũnzí. Yãkóꞌbõ ꞌbã anzị kí ándrá mụdrị́ drị̃ ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Anzị Léyã drị̂ kí: Rụ́bẹ̃nị̃ Yãkóꞌbõ ꞌbã ngọ́tị́ ágọ́bị́ kãjãní rĩ ꞌi, Sị̃mọ́nị̃ ꞌi, Lẹ́vị̃ ꞌi, Yụ́dã ꞌi, Ĩsãkárĩ ꞌi, ãzíla Zãbụ̃lọ́nị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Anzị Rãkẹ́lị̃ drị̂ kí: Yụ̃sụ́fụ̃ kí Bénzãmĩnĩ be. ");
INSERT INTO luc_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Anzị ĩzóŋá Rãkẹ́lị̃ drị́ ãtíꞌbó ru Bílĩhã drị̂ kí: Dánĩ kí Nãfũtálĩ be. ");
INSERT INTO luc_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Anzị ĩzóŋá Léyã drị́ ãtíꞌbó ru Zị̃lị́pã drị̂ kí: Gádĩ kí Ásẹ̃rị̃ be. Anzị Yãkóꞌbõ drị́ ꞌdĩ kí útị kí pírí Mẽsõpõtámĩyã gá. ");
INSERT INTO luc_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yãkóꞌbõ mụ átẹ́pị̃ Ĩsákã rụ́ Mãmírẽ gá ãni la Hẹ̃bụ̃rọ́nị̃ gá ꞌdĩ ãngũ ándrá Ịbụrahị́mụ̃ ꞌbaní uꞌájó Ĩsákã be rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ĩsákã uꞌá ílí 180, ");
INSERT INTO luc_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","drã dó ꞌdĩ sĩ ĩꞌdi dó ꞌbá ãmbá ru. Ngọ́pịka Ị́sãwụ̃ kí Yãkóꞌbõ be ị̃sị̃ kí dó sĩ ĩꞌdi nĩ. ");
INSERT INTO luc_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ꞌDĩ ãwí Ị́sãwụ̃ vâ umvelé Ídõmũ ꞌi rĩ drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ị́sãwụ̃ ĩgbã ũkú kí na angájó izonzi Kãnánĩ rú rĩ kí agá. Ũkú kãyó rĩ ꞌbã rụ́ Ádã ꞌi, ĩꞌdi Ị̃lọ́nị̃ Hị́tị̃ rú rĩ ꞌbã ị̃zẹ́pị ꞌi, ũkú ị̃rị̃ rĩ ꞌbã rụ́ Ụ̃họ̃lị̃bámã Hánã ị̃zẹ́pị Zị̃bị̃yọ́nị̃ Hị́vị̃ rú rĩ umvelépi ị̃dẹ́pị rĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ũkú na rĩ ĩꞌdi Bãsĩmátĩ Ịsụmayị́lị̃ ị̃zẹ́pị Nẽbãyọ́tị́ ámvọ́pị ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ádã tị Ị́sãwụ̃ ní Ị̃lị̃fázị̃ ꞌi. Bãsĩmátĩ tị Rụ̃wẹ́lị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ãzíla Ụ̃họ̃lị̃bámã tị Yẹ̃wụ́sị̃ ꞌi, Yãlámũ ꞌi ãzíla Kórã ꞌi. ꞌDĩ kí anzị tịlé Ị́sãwụ̃ ní Kãnánĩ gá rĩ kî. ");
INSERT INTO luc_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ꞌDã ꞌbã ũngúkú gá, Ị́sãwụ̃ ꞌdụ ũkúka kí ãnzị kí abe, ꞌbá ĩꞌdidrị́ko gá rĩ kí, ãnãkpá ĩꞌdidrị̂ kí ãko pírí ĩꞌdi ꞌbã ịsụ́lé ãngũ Kãnánĩ gá rĩ kî trũ trũ mụjó ãngũ álị́ gá ádrị́pị̃ Yãkóꞌbõ ꞌbã andre gá ꞌdãá rĩ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ꞌDĩ idé ru íni la ãꞌdusĩku ãko ĩꞌbã kí ịsụ́lé málĩ rú rĩ kí ambamba, ãngũ ca dó sĩ ĩꞌbaní sĩ icójó uꞌájó ị̃rị̃ trá ãngũ ãlu gá ku. ");
INSERT INTO luc_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ị́jọ́ ꞌdĩ sĩ, Ị́sãwụ̃ vâ umvelé Ídõmũ ꞌi rĩ ri dó uꞌálé ãngũ ꞌbé ꞌa rú Sẽyírĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ꞌDĩ ãwí Ị́sãwụ̃ adrulépi ꞌbá Ídõmũ rú rĩ kí ꞌbã áyị́pị rú uꞌálépi ãngũ ꞌbé ꞌa rú Sẽyírĩ gá rĩ drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ꞌDĩ kí rụ́ anzị Ị́sãwụ̃ drị̂ ꞌbadrị̂ kî: Ũkú ĩꞌdidrị́ Ádã tị lú ĩꞌdiní Ị̃lị̃fázị̃ ꞌi. Bãsĩmátĩ tị ĩꞌdiní Rụ̃wẹ́lị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Anzị Ị̃lị̃fázị̃ drị̂ kí rụ́: Tẽmánĩ ꞌi, Úmãrĩ ꞌi, Zéfõ ꞌi, Gãtámũ ꞌi ãzíla Kénãzĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ũkú Ị̃lị̃fázị̃ drị́ ãtíꞌbó ru Tímũnã tị ĩꞌdiní Ãmãlẹ́kị̃ ꞌi. ꞌDĩ kí anzị Ị́sãwụ̃ ꞌbã ũkú umvelé Ádã ꞌi rĩ drị̂ kî. ");
INSERT INTO luc_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Anzị Rụ̃wẹ́lị̃ drị̂ kí: Nãhátĩ ꞌi, Zérã ꞌi, Sámã ꞌi ãzíla Mízã ꞌi. ꞌDĩ kí anzị Ị́sãwụ̃ ꞌbã ũkú umvelé Bãsĩmátĩ drị̂ kî. ");
INSERT INTO luc_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Anzị Ị́sãwụ̃ ꞌbã ũkú umvelé Ụ̃họ̃lị̃bámã Zị̃bị̃yọ́nị̃ ị̃zẹ́pị Hánã ꞌbã tịlé rĩ kí rụ́: Yẹ̃wụ́sị̃ ꞌi, Yãlámũ ꞌi ãzíla Kórã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ꞌDĩ kí ũpi angálépi Ị́sãwụ̃ ngọ́pịka kí agá rĩ kî. Anzị Ị̃lị̃fázị̃ Ị́sãwụ̃ ꞌbã ngọ́pị kãjãní rĩ drị̂ kí: úpí Tẽmánĩ ꞌi, Úmãrĩ ꞌi, Zéfõ ꞌi, Kénãzĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kórã ꞌi, Gãtámũ ꞌi ãzíla Ãmãlẹ́kị̃ ꞌi ꞌdĩ kí úpí anzị Ị̃lị̃fázị̃ drị́ ãngũ Ídõmũ gá rĩ kî. Anzị ꞌdĩ umve kí ũkú Ị́sãwụ̃ drị́ umvelé Ádã rĩ ị̃dẹ́pị. ");
INSERT INTO luc_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Anzị Ị́sãwụ̃ ngọ́pị Rụ̃wẹ́lị̃ drị̂ kí: úpí Nãhátĩ ꞌi, Zérã ꞌi, Sámã ꞌi ãzíla Mízã ꞌi. Anzị ꞌdĩ kí ꞌbã ị̃dẹ́pị ĩꞌdi ũkú Ị́sãwụ̃ drị́ umvelé Bãsĩmátĩ ꞌi rĩ. ");
INSERT INTO luc_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Anzị angálépi ũkú Ị́sãwụ̃ drị́ umvelé Ụ̃họ̃lị̃bámã Hánã ꞌbã tịlé rĩ drị̂ kí: úpí Yẹ̃wụ́sị̃ ꞌi, Yãlámũ ꞌi ãzíla Kórã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ꞌDĩ kí anzị Ị́sãwụ̃ vâ umvelé Ídõmũ rĩ drị̂ kî ãzíla ꞌdĩ kí ũpi ĩꞌbãdrị̂ kî. ");
INSERT INTO luc_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ꞌDĩ kí anzị Sẽyírĩ Họ́rị̃ rú ándrá uꞌálépi ãngũ Ídõmũ gá rĩ drị̂ kî: Lõtánĩ ꞌi, Sõbálĩ ꞌi, Zị̃bị̃yọ́nị̃ ꞌi, Hánã ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dị́sọ̃nị̃ ꞌi, Ị̃zẹ́rị̃ ꞌi ãzíla Dĩsánĩ ꞌi. Anzị Sẽyírĩ Họ́rị̃ rú rĩ drị́ ꞌdĩ kí ándrá ũpi rú Ídõmũ gá. ");
INSERT INTO luc_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Anzị Lõtánĩ drị̂ kí: Họ́rị̃ ꞌi ãzíla Hẽmámũ ꞌi. Lõtánĩ ꞌbã ámvọ́pị ĩꞌdi Tímũnã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Anzị Sõbálĩ drị̂ kí: Ãlĩvánĩ ꞌi, Mãnãbátĩ ꞌi, Ĩbálĩ ꞌi, Séfõ ꞌi ãzíla Ũnámũ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Anzị Zị̃bị̃yọ́nị̃ drị̂ kí: Ãyíyã ꞌi ãzíla Hánã ꞌi. (Hánã ꞌdĩ ándrá ị̃yị́ kídí ru ãcí agbẹ́lépi tũlãtũlã rĩ ịsụ́lépi ãngũ kõtórõ rú rĩ agá sáwã ĩꞌdi ꞌbã kãyĩnõ átẹ́pị̃ drị̂ kí ucéjó rĩ sĩ rĩ ꞌi). ");
INSERT INTO luc_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anzị Hánã drị̂ kí: Dị́sọ̃nị̃ kí Hánã ị̃zẹ́pị Ụ̃họ̃lị̃bámã be. ");
INSERT INTO luc_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Anzị Dị́sọ̃nị̃ drị̂ kí: Hẽmãdánĩ ꞌi, Ĩsãbánĩ ꞌi, Ĩtĩránĩ ꞌi ãzíla Kérãnĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Anzị Ị̃zẹ́rị̃ drị̂ kí: Bĩlĩhánĩ ꞌi, Zãvánĩ ꞌi ãzíla Ãkánĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Anzị Dĩsánĩ drị̂ kí: Ụ́zị̃ kí Ãránĩ be. ");
INSERT INTO luc_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ꞌBá ũpi rú Họ́rị̃ gá rĩ kí ꞌdĩ: Lõtánĩ ꞌi, Sõbálĩ ꞌi, Zị̃bị̃yọ́nị̃ ꞌi, Hánã ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dị́sọ̃nị̃ ꞌi, Ị̃zẹ́rị̃ ꞌi ãzíla Dĩsánĩ ꞌi. ꞌDĩ kí ándrá ũpi ꞌbá Họ́rị̃ gá rĩ ꞌbadrị̂ kî ãngũ Sẽyírĩ drị̂ ꞌbã awaŋá vú sĩ. ");
INSERT INTO luc_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ꞌDĩ kí ándrá ũpi ãngũ nalépi Ídõmũ gá ꞌdĩ sĩ anzị Ịsịrayị́lị̃ drị̂ iꞌdó kí drĩ ũpĩ nalé ãngũ ꞌdã gá ku rĩ kî: ");
INSERT INTO luc_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bélã Bẹ̃yọ́rị̃ ngọ́pị acá úpí ru Ídõmũ gá ãzíla ꞌda táwụ̃nị̃ ĩꞌdidrị́ ãmbógó rĩ rụ́ Dĩnĩhábã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bélã la mụ drãlé ꞌbo, Yõbábũ Zérã ngọ́pị angálépi Bõzírã gá rĩ acá úpí ru ĩꞌdi kẹ̃jị́ gá nĩ. ");
INSERT INTO luc_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yõbábũ la mụ drãlé ꞌbo, Hũsámũ angálépi Tẽmánĩ gá rĩ acá úpí ru ĩꞌdi kẹ̃jị́ gá nĩ. ");
INSERT INTO luc_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hũsámũ la mụ drãlé ꞌbo, Hãdádĩ Bẽdádĩ ngọ́pị angálépi Mị̃dị́yánị̃ gá rĩ acá úpí ru Mụ̃wábụ̃ gá ĩꞌdi kẹ̃jị́ gá nĩ. ꞌDa táwụ̃nị̃ ĩꞌdidrị́ ãmbógó rĩ rụ́ Ãvị́tị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hãdádĩ la mụ drãlé ꞌbo, Sámũlã angálépi Mãsĩrékã gá rĩ acá úpí ru ĩꞌdi kẹ̃jị́ gá nĩ. ");
INSERT INTO luc_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Sámũlã la mụ drãlé ꞌbo, Sáwụ̃lụ̃ angálépi táwụ̃nị̃ Rẹ̃họ̃bọ́tị̃ ị̃yị́ tị gá rĩ acá úpí ru ĩꞌdi kẹ̃jị́ gá nĩ. ");
INSERT INTO luc_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sáwụ̃lụ̃ la mụ drãlé ꞌbo, Bãálĩ-Hãnánĩ Ãkị̃bọ́rị̃ ngọ́pị acá úpí ru ĩꞌdi kẹ̃jị́ gá nĩ. ");
INSERT INTO luc_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bãálĩ-Hãnánĩ Ãkị̃bọ́rị̃ ꞌbã ngọ́pị la mụ drãlé rá, Hãdádĩ acá úpí ru ĩꞌdi kẹ̃jị́ gá nĩ, táwụ̃nị̃ ĩꞌdidrị́ ãmbógó rĩ ála umve la Páwũ ꞌi ãzíla ũkú ĩꞌdidrị̂ ꞌbã rụ́ Mẽhẽtãbélĩ ꞌi, ĩꞌdi Mátrẽdĩ ị̃zẹ́pị ꞌbã ị̃zẹ́pị Mẽzãhábũ drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ꞌDĩ kí ũpi ándrá ãfũlépi ũri Ị́sãwụ̃ drị́ ínátị ãlu-ãlu gá rĩ kî: Tímũnã ꞌi, Álĩvã ꞌi, Yẽtétĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Ụ̃họ̃lị̃bámã ꞌi, Ílã ꞌi, Pĩnónĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kénãzĩ ꞌi, Tẽmánĩ ꞌi, Mĩbĩzárĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Mãgãdẹ́lị̃ ꞌi ãzíla Ĩrámũ ꞌi. ꞌDĩ kí ínátị ꞌbá Ídõmũ rú rĩ (ꞌdĩ Ị́sãwụ̃ ꞌbã adrujó ĩꞌbã átẹ́pị rú rĩ) ꞌbadrị̂ kî sụ́rụ́ tị ĩꞌbadrị́ ũpĩ drị̂ kí sĩ ãzíla ãngũ ĩꞌbaní rijó rĩ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yãkóꞌbõ ri uꞌálé Kãnánĩ gá ãngũ ándrá átẹ́pị̃ ꞌbã sĩ uꞌájó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ꞌDĩ dó ãwí Yãkóꞌbõ drị̂: Yụ̃sụ́fụ̃ ri kí ándrá kãbĩlõ kí ucélé ádrị́pịka ụ́kụ́pị̃ Bílĩhã ãzíla Zị̃lị́pã Yãkóꞌbõ ꞌbã ũkúka rú rĩ kí abe ịsụ́ íni ꞌdĩ ílí la mụdrị́ drị̃ ázị̂rị̃. Wó Yụ̃sụ́fụ̃ ri ị́jọ́ ádrị́pịka ꞌbã kí idélé ũnzí rĩ kí ũlũlé átẹ́pị̃ nî. ");
INSERT INTO luc_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yãkóꞌbõ lẽ Yụ̃sụ́fụ̃ ãndânĩ ndẽ anzị ĩꞌdidrị́ ãzí rĩ kí rá, ãꞌdusĩku útị Yụ̃sụ́fụ̃ ꞌi ịsụ́ ꞌdĩ sĩ Yãkóꞌbõ dó ãmbá ru. Yãkóꞌbõ fẽ dó sĩ Yụ̃sụ́fụ̃ ní kánzũ uꞌbélé ũniyambamba la. ");
INSERT INTO luc_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Wó Yụ̃sụ́fụ̃ ádrị́pịka kí dó mụ ndrelé la átẹ́pị̃ lẽ ĩꞌdi ãndânĩ ꞌbo, ngụ̃ kí dó ĩꞌdi ãjị́ ũnzí, ãzíla jọ kí ĩꞌdiní ị́jọ́ ásị́ ị̃gbẹ̃ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ị́nị́ ãlu, urobí ũbĩ Yụ̃sụ́fụ̃ ꞌi, ĩꞌdi dó mụ vú la nzelé ádrị́pịka ꞌbaní ꞌbo, ngụ̃ kí dó sĩ ĩꞌdi ị̃dị́-ị̃dị́. ");
INSERT INTO luc_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Jọ ĩꞌbaní, “Ĩmi are drĩ urobí áma ũbĩlépi ꞌdĩ ꞌi: ");
INSERT INTO luc_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ãma ní ngánũ lịlẹ́ ámvụ́ agá rĩ kí umbé agâ ꞌdĩ gá ꞌdâ gbõgbõ mádrị́ tị ngúlú rĩ inga ru pâ tulé ụrụgá, ĩmidrị̂ atrá kí ru mádrị̂ andre gá, ilú kí ru ĩꞌdiní vụ̃rụ́.” ");
INSERT INTO luc_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ádrị́pịka jọ kí, “Mi dó sĩ mụ adrulé ãma drị̃lẹ́ gá ãmbógó ru yã? Mi ãma drị̃ ce úpí ru ãndá-ãndá ru yã?” Ngụ̃ kí dó sĩ ĩꞌdi ị̃dị́-ị̃dị́ urobí ĩꞌdidrị́ ꞌdã kí sĩ ãzíla ị́jọ́ ĩꞌdi ꞌbã jọlé rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ꞌDã ꞌbã ũngúkú gá, urobí ãzí rĩ ũbĩ vâ Yụ̃sụ́fụ̃ ꞌi, nze vú la ádrị́pịka ꞌbaní jọ, “Ĩmi are drĩ urobí ꞌdĩ ꞌi, ị̃tụ́ kí ĩmbá be ãzíla lẽlẽgó mụdrị́ drị̃ ãlu la kí abe ãvụ̃ kí vụ̃rụ́ áma ị̃nzị̃jó.” ");
INSERT INTO luc_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ĩꞌdi mụ urobí ꞌdĩ vú nzelé átẹ́pị̃ ꞌbaní ádrị́pịka kí abe ꞌbo, átẹ́pị̃ angá drị̃ la gá trụ, “Urobí ími ũbĩlépi ꞌdĩ ífí la íngoní? Mî ãndrẽ kí mî ádrị́pịka abe ãzíla mâ trũ kí rú amụ́ ãvụ̃lé vụ̃rụ́ ími drị̃lẹ́ gá rá yã?” ");
INSERT INTO luc_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ádrị́pịka idé kí ĩꞌdiní ãjã sĩ, wó átẹ́pị̃ mba ị́jọ́ ꞌdĩ kí tã ĩꞌdi ásị́ gá cí. ");
INSERT INTO luc_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ụ́ꞌdụ́ ãlu, Yụ̃sụ́fụ̃ ꞌbã ádrị́pịka mụ kí kãbĩlõ átẹ́pị̃ drị̂ kí ucé trũ Sẹ̃kẹ́mụ̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Yãkóꞌbõ jọ Yụ̃sụ́fụ̃ ní, “Ínị̃ rá mî ádrị́pịka mụ kí kãbĩlõ kí ucé trũ ãni rú Sẹ̃kẹ́mụ̃ gâlé ꞌdã, álẽ ími tị pẽlé ĩꞌba rụ̂lé.” Yụ̃sụ́fụ̃ umvi, “Múké ma bábá mụjó.” ");
INSERT INTO luc_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Jọ ĩꞌdiní, “Ímụ mî ádrị́pịka kí andrélé ãnãkpá kí abe kí nõ múké yã áni, mí ají mání ụ́ꞌdụ́kọ́ la.” Yụ̃sụ́fụ̃ mụ dó angájó wọ́rọ̃ŋá Hẹ̃bụ̃rọ́nị̃ drị̂ gá rĩ sĩ Sẹ̃kẹ́mụ̃ gâlé. ");
INSERT INTO luc_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ĩꞌdi mụ calé ꞌdãá ꞌbo, ágọ́bị́ ãzí ndre ĩꞌdi wãyá co agá ãzíla zị ĩꞌdi, “Mi ãꞌdu ndrụ̃ yã?” ");
INSERT INTO luc_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Umvi ĩꞌdiní, “Ma mâ ádrị́pịka kí ndrụ̃, mí icó mání lũlé la kí kãbĩlõ kí ucé íngõlé rĩ gá rá yã?” ");
INSERT INTO luc_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ágọ́bị̂ jọ ĩꞌdiní, “Mî ádrị́pịka aꞌbe kí ãngũ ꞌdĩ rá, má are kí jọ agá la ‘Ãmụ kí Dõtánĩ gâlé.’” Yụ̃sụ́fụ̃ bĩ dó kí vú Dõtánĩ gâlé ãzíla ịsụ́ kí rá. ");
INSERT INTO luc_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Yụ̃sụ́fụ̃ ꞌbã ádrị́pịka ndre kí ĩꞌdi amụ́ agá rá-rá ru acá drĩ ku rú, utú kí ị́jọ́ sĩ ĩꞌdi ꞌdịjó rá. ");
INSERT INTO luc_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Jọ kí ị́jọ́ kí drĩdríŋĩ gá, “Urobí ꞌdị́pị la amụ́ ꞌdã. ");
INSERT INTO luc_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ĩmi amụ́, lẽ ãꞌdị kí ĩꞌdi rá, ãꞌbe kí dó sĩ ãvũ la kídí nzụlépi rá la ꞌbã ꞌbụ́ ãzí agá, ãjọ kí ụ̃bọ̃gụ̃ ãzí na ĩꞌdi rá. Ãma kí dó drĩ sĩ ndre la ãꞌdu la nõ ru idé urobí ĩꞌdi ãni ꞌdĩ kí agá nĩ yã áni.” ");
INSERT INTO luc_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rụ́bẹ̃nị̃ la mụ ị́jọ́ ꞌdĩ arelé ꞌbo, ụ̃ꞌbị̃ Yụ̃sụ́fụ̃ palé kí drị́ gá rĩ sĩ rá jọ, “Ãꞌdị kí ĩꞌdi ku.” ");
INSERT INTO luc_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Jọ ĩꞌbaní, “Ĩmi asu ãrí la ku; úꞌbe ĩꞌdi kõtórõ agá ꞌbụ́ ꞌdĩ agá ꞌdâ wó lẽ ꞌbá ãzí ꞌbã su drị́ ĩꞌdi rụ́ ku.” Rụ́bẹ̃nị̃ idé ị́jọ́ ꞌdĩ íni la sĩ ĩꞌdi pajó ãzíla sĩ ĩꞌdi agụjó átẹ́pị̃ drị̂lé ídri. ");
INSERT INTO luc_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yụ̃sụ́fụ̃ la mụ acálé ádrị́pịka ꞌba rụ́ ꞌdõlé ꞌbo, trũ kí kánzũ ĩꞌdi ụrụꞌbá gá uꞌbélé ũniyambamba rĩ rá. ");
INSERT INTO luc_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ꞌDã ꞌbã ũngúkú gá, rụ kí ĩꞌdi ãzíla ꞌdụ kí ĩꞌdi ꞌbelé ꞌbụ́ ãꞌí la agá. ");
INSERT INTO luc_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ĩꞌbaní rĩ agá íná na agá, inga kí drĩ ụrụgá ãzíla ndre kí ꞌbá Ịsụmayị́lị̃ rú rĩ kí ũꞌbí ru angá kí Gị̃lẹ́dị̃ gá ãzíla kî mụ agá Mị̃sị́rị̃ gá. Ngãmíyã ĩꞌbadrị̂ kí drị̃ gá ꞌdụ kí tẹ́rị́ ãko ãjị̂ trũ vĩrĩ rĩ ãni la kí ãdu ifílé ifí-ifî rĩ abe. ");
INSERT INTO luc_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ꞌDã ꞌbã ũngúkú gá, Yụ́dã jọ ádrị́pịka ꞌbaní, “Ãma kí ãꞌdu ịsụ́ ãdrĩ kí ãmã ádrị́pị ꞌdị rá ãzíla ãdrĩ kí drã ĩꞌdidrị̂ ꞌbã ị́jọ́ zị̃ cí rĩ gá? ");
INSERT INTO luc_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ãma uzị kí ĩꞌdi ꞌbá Ịsụmayị́lị̃ rú ꞌdĩ ꞌbanî, ãma asu kí ĩꞌdi ꞌbã ãrí ãmadrị́ sĩ ãma ꞌi ku ĩꞌdi ꞌbã adrujó ãmã ádrị́pị ãrí ãlu ãzíla ĩzá ãlu rĩ sĩ.” Ádrị́pịka ãꞌị̃ kí rá. ");
INSERT INTO luc_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ꞌBá bĩsírã idélépi Mị̃dị́yánị̃ rú rĩ ꞌbã kí alị agá, Yụ̃sụ́fụ̃ ꞌbã ádrị́pịka anzé kí ĩꞌdi ꞌbụ́ agâlé rá ãzíla uzị kí ĩꞌdi ꞌbá Ịsụmayị́lị̃ rú rĩ ꞌbaní séndẽ sílĩvã rú kãlị́ ị̃rị̃ sĩ, ꞌdụ kí ĩꞌdi Mị̃sị́rị̃ gâlé ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rụ́bẹ̃nị̃ la mụ gõlé ꞌbụ́ tị gâlé ꞌbo, ịsụ́ Yụ̃sụ́fụ̃ ꞌdãá yụ ãzíla asi ĩꞌdi ꞌbã bõngó kí ũcõgõ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Atrị drị̃ ádrị́pịka ꞌba rụ̂lé jọ, “Mgbâ dó ꞌdãá yụ, ma dó mání áma idé ãꞌdurú yã?” ");
INSERT INTO luc_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ꞌDã ꞌbã ũngúkú gá, aꞌdụ́ kí dó ị̃ndrị́, lị kí ĩꞌdi rá ãzíla su kî dó Yụ̃sụ́fụ̃ ꞌbã kánzũ ãrí la gá. ");
INSERT INTO luc_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Agụ kí dó ĩꞌdi ꞌbã bõngó uꞌbélé ũniyambamba rĩ átẹ́pị̃ rụ̂lé, jọ kí ĩꞌdiní, “Ãma ịsụ́ bõngó ꞌdĩ ꞌi, mí amá drĩ ĩꞌdi, icó nõ adrulé mî ngọ́pị Yụ̃sụ́fụ̃ drị̂ ꞌi ku yã áni.” ");
INSERT INTO luc_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Átẹ́pị̃ nị̃ ĩꞌdi cọtị cé jọ, “ꞌdĩ mâ ngọ́pị ꞌbã bõngô ꞌi! Ãndá-ãndá ru ụ̃bọ̃gụ̃ na kí dó mání ĩꞌdi rá ꞌdộ! Ãndá-ãndá ru ândi dó Yụ̃sụ́fụ̃ kpékpé!” ");
INSERT INTO luc_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yãkóꞌbõ asi dó bõngó ĩꞌdi ụrụꞌbá gá rĩ kí ũcõgõ sĩ rá, sụ̃ dó kõlĩbá ĩꞌdi ụrụꞌbá gá ãzíla awâ dó ngọ́pị̃ ꞌi ụ́ꞌdụ́ wẽwẽ rú. ");
INSERT INTO luc_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Anzị ĩꞌdidrị̂ amụ́ kí pírí ĩꞌdi ásị́ ũŋmĩlé, wó gã ru ásị́ ũŋmĩlé úmgbé jọ yụ, “Ma awá mâ ngọ́tị̂ sĩ kpere mání fi agá ꞌbụ́ gá.” Ị́jọ́ ꞌdĩ sĩ, átẹ́pị̃ awá dó ngọ́pị̃ Yụ̃sụ́fụ̃ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Wó íni ꞌdĩ ꞌbá Mị̃dị́yánị̃ rú rĩ ĩtụ̃ndã kí Yụ̃sụ́fụ̃ ꞌi Mị̃sị́rị̃ gâlé Pọ̃tị̃fárọ̃ ãsĩkárĩ ãmbógó úpí Fãráwũ andre tẽlépi rĩ drị̂ nî. ");
INSERT INTO luc_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Sáwã Yụ̃sụ́fụ̃ ụzịjó ꞌbo rĩ ꞌbã vúlé gá, Yụ́dã aꞌbe ádrị́pịka kí rá ãzíla mụ uꞌálé ágọ́bị́ Ãdũlámũ rú umvelé Hị́rã ꞌi rĩ be. ");
INSERT INTO luc_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yụ́dã ịsụ́ ágọ́bị́ Kãnánĩ rú rĩ ꞌbã ị̃zẹ́pị umvelé Sụ́wã rĩ ꞌi, ĩgbã ĩꞌdi rá ãzíla acá dó ĩꞌdi ꞌbã ũkú ru. ");
INSERT INTO luc_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ịsụ́ dó ꞌa tị dó sĩ ngọ́tị́ ágọ́bị́ ãzíla ꞌda dó rụ́ la Ị́rị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ịsụ́ vâ ꞌa ãzí rĩ ꞌi tị ngọ́tị́ ágọ́bị́ ãzíla ꞌda rụ́ la Ũnánĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Tị vâ ngọ́tị́ ágọ́bị́ ãzí rĩ ꞌi, ꞌda rụ́ la Sélã ꞌi. Sáwã ngọ́tị́ ꞌdã tĩjó rĩ sĩ, ịsụ́ Yụ́dã ꞌdĩ sĩ Kẹ̃zị́bụ̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yụ́dã ĩgbã ũkú ngọ́tị́ ĩꞌdidrị́ kãjãní Ị́rị̃ nî, ũkû rụ́ Tãmárã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Wó Ị́rị̃ Yụ́dã ngọ́pị kãjãní rĩ idé ị́jọ́ ũnzíkãnã la Úpí drị̃lẹ́ gá, ị́jọ́ ꞌdĩ sĩ Úpí fẽ drã rá. ");
INSERT INTO luc_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ꞌDã ꞌbã ũngúkú gá, Yụ́dã jọ Ũnánĩ ní, “Ífi mí ádrị́pị ꞌbã ũkû lãꞌbĩ ãmadrị̂ ꞌbã ãꞌị̃jó la ítị ĩꞌdiní anzị kí sĩ ĩꞌdi rụ́ ajíjó rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Wó Ũnánĩ nị̃ rá anzị ꞌdã icó kí adrulé ĩꞌdi ãni ku, drĩ fi ru lalé ũkú ꞌdã be ꞌbo, ĩꞌdi ũri sĩ ꞌbá tịjó rĩ kí ũsũ vụ̃rụ́, ị́jọ́ ꞌdĩ sĩ lẽ dó sĩ anzị ịsụ́lé ũkú ꞌdã be ádrị́pị̃ rụ́ ajíjó ku. ");
INSERT INTO luc_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ị́jọ́ ĩꞌdi ꞌbã idélé rĩ ĩꞌdi ũnzí Úpí Ãdróŋâ drị̃lẹ́ gá ị́jọ́ ꞌdĩ sĩ, Úpí fẽ dó vâ sĩ ĩꞌdiní drãlé rá. ");
INSERT INTO luc_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yụ́dã jọ dó ngọ́pị̃ ꞌbã ũkû Tãmárã ní, “Ímụ tẽlé ãwụ́zị́ ru mí átẹ́pị drị́ko gá ꞌdãá kpere mâ ngọ́pị Sélã ꞌbã zo agá sĩ icójó ími fijó rá.” Yụ́dã jọ ị́jọ́ ꞌdĩ íni la idé ụ̃rị̃ sĩ ꞌî ngọ́pị la vâ mụ drãlé ádrị́pịka ị̃rị̃ ꞌdã kî áni rá rĩ sĩ. Ị́jọ́ ꞌdĩ sĩ Tãmárã gõ dó sĩ vúlé ĩꞌbadrị́ko gâlé. ");
INSERT INTO luc_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Sáwã ãzo vúlé gá Yụ́dã ꞌbã ũkû Sụ́wã ꞌbã ị̃zẹ́pị rú rĩ drã rá. Ụ́ꞌdụ́ Yụ́dã ꞌbã ũkû awájó rĩ kí mụ ukólé ꞌbo, mụ Tímũnã gá ꞌbá ĩꞌdi ꞌbã kãbĩlõ ꞌbíko lịlẹ́pi rĩ kí andrélé ãzíla ĩꞌdi ꞌbã wọ̃rị̂ Hị́rã Ãdũlámũ rú rĩ mụ ĩꞌdi be ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ꞌBá ãzí mụ lũlé la Tãmárã ní, “Mí ándrị́pị la mụ Tímũnã gá ĩꞌdi ꞌbã kãbĩlõ ꞌbíko lịlẹ́,” ");
INSERT INTO luc_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","trũ bõngó ĩꞌdidrị́ ãwụ̃zị̃ drị̂ kí rá, ali ru ụrụꞌbá kũrũbábã sĩ, ꞌbe ru drị̃ bõngó sĩ cí, mụ dó rilé kẹ̃jị́tị sĩ fijó Ĩnãyímũ gá rĩ gá gẹ̃rị̃ mụlépi Tímũnã gá rĩ gá, Tãmárã ꞌbã nị̃jó la Sélã zo rá úfẽ ĩꞌdi ĩꞌdiní ágó ru ku rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yụ́dã la mụ ĩꞌdi ndrelé ꞌbo, ũrã ꞌbãngá ĩꞌdi ũkú ãwụ́ꞌbá ru la ĩꞌdi ꞌbã ru mẹ́lẹ́tị ꞌbejó cí rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ĩꞌdiní nị̃jó la Tãmárã ĩꞌdi ngọ́pị̃ Ị́rị̃ drãlépi rá rĩ ꞌbã ũkû ꞌi ku rĩ sĩ, mụ ĩꞌdi rụ́ gẹ̃rị̃ tị gâlé jọ, “Ífẽ ámụ kolé mí be.” Tãmárã zị ĩꞌdi, “Mi dó mání ãꞌdu fẽ ãdrĩ dó ko mí be rĩ gá?” ");
INSERT INTO luc_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","“Ma mụ míní ị̃ndrị́ mũlũkũdũ la ãfẽlé angájó ị̃ndrị́ mádrị̂ kí agâlé.” Tãmárã zị, “Ãko ãzí míní fẽlé mání gúrã rú cêkõ rĩ ãꞌdu?” ");
INSERT INTO luc_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yụ́dã jọ, “Ma dó míní gúrã rú ãꞌdu fẽ cêkõ yã?” Umvi ĩꞌdiní, “Drọ̃nọ́ mídrị́ ími rụ́ trũ ꞌdĩ ꞌi ãzíla túré ími drị́ gá ꞌdĩ ꞌi.” Ị́jọ́ ꞌdĩ sĩ Yụ́dã fẽ dó kí ĩꞌdidrị̂lé rá, ko dó sĩ ụ́ꞌdụ́ ĩꞌdi be, Tãmárã ịsụ́ dô sĩ ꞌa. ");
INSERT INTO luc_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ꞌDã ꞌbã ũngúkú gá, Tãmárã gõ dó vúlé ĩꞌbadrị́ko gâlé, trũ dó kũrũbábã kí bõngó drị̃ ꞌbejó rĩ be rá, ãzíla sụ̃ dó bõngó ĩꞌdidrị́ ãwụ̃zị̃ drị̂ kí áyụ. ");
INSERT INTO luc_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yụ́dã la mụ wọ̃rị̂ Hị́rã Ãdũlámũ rú rĩ tị ãpẽlé ị̃ndrị́ mváŋâ trũ Tãmárã rụ́ ꞌdõlé, sĩ ãko ándrá ĩꞌdi ꞌbã aꞌbelé gúrã rú rĩ kí unzejó ꞌbo, Hị́rã ịsụ́ Tãmárã gẹ̃rị̃ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Zị ãgọbị Ĩnãyímũ gá rĩ kí, “Ũkú jõ ãwụ́ꞌbá ru gẹ̃rị̃ tị gá ꞌdâ rĩ íngõlé yã?” ꞌBá ãngũ ꞌdã gá rĩ umvi kí ĩꞌdiní, “ꞌBá ãzí ãwụ́ꞌbá ru la ꞌdộ ꞌdáyụ.” ");
INSERT INTO luc_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ị́jọ́ ꞌdĩ sĩ Hị́rã gõ dó Yụ́dã rụ̂lé jọ ĩꞌdiní, “Ándrụ̃ mâ ngá ũkú ꞌdã tí. Ãgọbị ãngũ ꞌdã gá ꞌdãá rĩ jọ kí mání ꞌbá ãzí ãwụ́ꞌbá ru la ꞌbãngá ĩꞌbadrị́ ꞌdãá yụ.” ");
INSERT INTO luc_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ꞌDã ꞌbã ũngúkú gá, Yụ́dã jọ, “Lẽ ũkú ꞌdã ꞌba mba dó ãko ꞌdã kí tã ĩꞌdiní la rú, álẽ ꞌbá ꞌbã gụ kí ãma ku. Má ụ̃ꞌbị̃ tá tí ĩꞌdi ũfẽlé rá wó mí ịsụ́ dó ĩꞌdi ku.” ");
INSERT INTO luc_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ãni rú ĩmbá na vúlé gá ꞌbá ãzí jọ Yụ́dã ní, “Mî ngọ́pị ꞌbã ũkû Tãmárã idé mị-ãcí ị́jọ́ ꞌdĩ sĩ ĩꞌdi dó sĩ ꞌa trũ.” Ị́jọ́ ꞌdĩ sĩ, Yụ́dã jọ, “Ĩmi iyá ĩꞌdi ivélé ãzíla ꞌbã drã dó sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ála dó mụ ĩꞌdi iyálé ãmvêlé ꞌbo, pẽ dó ꞌbá ãzí tị ándrị́pị̃ rụ̂lé ãko ándrá ĩꞌdi ꞌbã fẽlé gúrã rú rĩ kí trũ, jọ, “Má ịsụ́ ꞌa ágọ́bị́ ríŋĩ ãzíla túré ꞌdĩ ꞌbã ꞌdị́pị rú rĩ drị́. Índre drĩ ãko ꞌdĩ kí nõ ãꞌdi ãni yã áni.” ");
INSERT INTO luc_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yụ́dã nị̃ dó kí rá jọ, “Tãmárã idé ị́jọ́ kpị la ndẽ ma rá mání mâ ngọ́pị Sélã fẽjó ĩꞌdiní ágó ru ku rĩ sĩ.” Yụ́dã la dó ru ĩꞌdi be ị̃dị́ ku. ");
INSERT INTO luc_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Sáwã ĩꞌdi ꞌbã tĩjó rĩ la mụ calé ꞌbo, ísụ́ anzị ãgọbị kí ĩꞌdi ꞌa gá ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ĩꞌdiní kí tĩ agá ꞌdãá, ngọ́tị́ ãzí rĩ asú ru drị́ ãmvé, ũkú ngọ́tị́ tĩlépi rĩ rụ drị́ la icí kéyĩ ika la drị́ la gá cí jọ, “ꞌdĩ ngọ́tị́ kãjãní rĩ.” ");
INSERT INTO luc_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Wó uja ru drị́ nzelé vúlé, ádrị́pị̃ uja dó sĩ ãfũlé drị̃drị̃ ãzíla ũkú ngọ́tị́ tĩlépi rĩ jọ, “ꞌDĩ dó gẹ̃rị̃ mídrị́ míní sĩ ãfũjó ãmvé ꞌdõlé ũkpó sĩ rĩ ꞌi ꞌbo,” ꞌda dó sĩ rụ́ la Pẹ̃rẹ́zị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ꞌDã ꞌbã ũngúkú gá, ádrị́pị̃ sĩ drị́ la gá kéyĩ ika icíjó rĩ, útĩ dó ĩꞌdi vúlé vúlé ru ãzíla úꞌda dó sĩ rụ́ la Zérã ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ꞌBá Ịsụmayị́lị̃ rú ꞌdĩ kí dó mụ Yụ̃sụ́fụ̃ agụlé Mị̃sị́rị̃ gâlé ꞌbo, ágọ́bị́ ãzí Mị̃sị́rị̃ rú umvelé Pọ̃tị̃fárọ̃ ãsĩkárĩ ãmbógó úpí Fãráwũ andre tẽlépi rĩ ĩgbã dó ĩꞌdi kí drị́ gá nĩ. ");
INSERT INTO luc_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Úpí ko Yụ̃sụ́fụ̃ ãzã ị́jọ́ pírí kí agá, ĩꞌdi dó sĩ drị̃lẹ́ba rú, rĩ dó uꞌálé ãmbógó ĩꞌdi ĩgbãlépi Mị̃sị́rị̃ ru rĩ drị́ko gá. ");
INSERT INTO luc_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ãmbógó ĩꞌdidrị̂ la mụ ndrelé la Úpí ꞌi Yụ̃sụ́fụ̃ be cí ãzíla Úpí fẽ ĩꞌdiní drị̃lẹ́ba ĩꞌdi ꞌbã drị́ gá ãko pírí ĩꞌdi ꞌbã idélé rĩ kí agá rá, ");
INSERT INTO luc_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Pọ̃tị̃fárọ̃ uꞌá dó ãyĩkõ sĩ, ꞌbã dó ĩꞌdi ãtíꞌbó ãzị́ ngalépi ĩꞌdiní rĩ rú ãzíla azị dó ãko pírí kí ĩꞌdidrị́ alé gá. ");
INSERT INTO luc_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Iꞌdójó sáwã ĩꞌdiní Yụ̃sụ́fụ̃ ꞌbãjó ãmbógó ru lị́cọ́ agá ãzíla ãko ĩꞌdidrị̂ kí drị̃lẹ́ gá rĩ sĩ, Úpí wi sụ̃sụ́ lị́cọ́ ágọ́bị́ Mị̃sị́rị̃ ru rĩ drị̂ drị̃ gá Yụ̃sụ́fụ̃ ị́jọ́ sĩ. Úpí wi sụ̃sụ́ Pọ̃tị̃fárọ̃ ní ãko pírí ĩꞌdidrị́ jó agá ãzíla ámvụ́ agá rĩ kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ị́jọ́ ꞌdĩ sĩ aꞌbe dó ãko pírí kí Yụ̃sụ́fụ̃ drị́lẹ́ gá, ꞌbã ásị́ mâ ãko ãzí kí lẹ́ꞌdị̃ cí yã rĩ drị̃ gá ku, wó lú ãkónã ĩꞌdi ꞌbã nalé rĩ áꞌdụ̂sĩ. Yụ̃sụ́fụ̃ zo dó úmgbô trũ ãzíla ụrụꞌbá trũ túlí-túlí. ");
INSERT INTO luc_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ụ́ꞌdụ́ were vúlé gá ãmbógó ĩꞌdidrị̂ ꞌbã ũkû ásị́ ꞌde ĩꞌdi drị̃ gá jọ ĩꞌdiní, “Mí amụ́ ími lalé mâ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Wó gã úmgbé ãzíla jọ ĩꞌdiní, “Ãmbógó mádrị̂ aꞌbe ãko ĩꞌdidrị́ jó agá rĩ kí pírí áma drị́lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ꞌBá ãzí áma drị̃lẹ́ gá jó ꞌdĩ agá ꞌdâ la yụ, ãko ãzí ĩꞌdi ꞌbã fẽlé tãmbalé mádrị́ ku la ĩꞌdi ꞌdáyụ, pẽ lú mi ꞌi. Má icó dó ị́jọ́ ũnzíkãnã ꞌdĩ idélé sĩ ị́jọ́ izajó Ãdróŋâ mẹ́lẹ́tị gá íngoní ru?” ");
INSERT INTO luc_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ĩꞌdiní ị́jọ́ ꞌdĩ jọ agá Yụ̃sụ́fụ̃ ní íla mi mâ sĩ ụ́ꞌdụ́ pírí rá tí, Yụ̃sụ́fụ̃ gã ru lalé ĩꞌdi sĩ úmgbé. ");
INSERT INTO luc_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ụ́ꞌdụ́ ãlu Yụ̃sụ́fụ̃ mụ jó agâlé ĩꞌdi ꞌbã ãzị́ kí ngalé, ꞌbá ãzí ãtíꞌbó ru jó agá ꞌdãá cí la yụ. ");
INSERT INTO luc_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Pọ̃tị̃fárọ̃ ũkû rụ Yụ̃sụ́fụ̃ ꞌbã bõngó jọ ĩꞌdiní, “Mí amụ́ ími lalé mâ sĩ.” Wó Yụ̃sụ́fụ̃ aꞌbe dó bõngô drị́ la gá ꞌdãá, apá dó ụ́ngụ́lẹ́ sĩ ãmvêlé. ");
INSERT INTO luc_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Pọ̃tị̃fárọ̃ ũkû la dó mụ ndrelé la Yụ̃sụ́fụ̃ aꞌbe dó bõngô ĩꞌdidrị́ gá ꞌdãá ãzíla apá ụ́ngụ́lẹ́ sĩ ãmvé, ");
INSERT INTO luc_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","umve ãtiꞌbo ãzị́ ngalépi jó agá ꞌdãá rĩ kí jọ ĩꞌbaní “Ĩndre drĩ mgbá Ĩbũrãníyã rú ꞌdĩ ájí ĩꞌdi amụ́jó avájó ãma sĩ! Amụ́ tí jó agá ꞌdõlé áma ụrụlé gbõgbõ áꞌbe ụ̃lụ́lụ́. ");
INSERT INTO luc_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ĩꞌdi mụ áma ụ̃lụ́lụ́ arelé ꞌbá ꞌbaní áma itójó, apá ãmvêlé ụ́ngụ́lẹ́ sĩ aꞌbe ĩꞌdi ꞌbã bõngô áma drị́ gá ꞌdĩ.” ");
INSERT INTO luc_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Mba dó bõngô tã ꞌdãá kpere ágô ꞌbã iyá agá. ");
INSERT INTO luc_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Uja dó ĩꞌdiní ị́jọ́ ꞌdĩ kí vú nzelé jọ, “Ãtíꞌbó míní ajílé Ĩbũrãníyã rú ꞌdĩ afí mádrị́ jó agá ꞌdõlé áma ụrụlé. ");
INSERT INTO luc_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Wó ma mụ ụ̃lụ́lụ́ ꞌbelé sĩ ãzãkoma ịsụ́jó ꞌbo, mvu apálé rá ãzíla aꞌbe ĩꞌdi ꞌbã bõngô áma andre gá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yụ̃sụ́fụ̃ ꞌbã ãmbógô la mụ ị́jọ́ ũkû ꞌbã jọlé, “ꞌDĩ bã sĩ gbíyã ãtíꞌbó mídrị̂ ꞌbã ị́jọ́ idéjó má rụ́ rĩ ꞌi,” ꞌdĩ arelé ꞌbo, acá dó ũmbájírílí. ");
INSERT INTO luc_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ꞌDụ dó sĩ Yụ̃sụ́fụ̃ ꞌi sulé jó sĩ ꞌbá úpí drị́ mãbụ́sụ̃ rú rĩ kí sujó rĩ gá. Wó Yụ̃sụ́fụ̃ ꞌbã adrujó mãbụ́sụ̃ gá ꞌdãá rĩ sĩ, ");
INSERT INTO luc_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Úpí aꞌbe ĩꞌdi ku, iꞌda ĩꞌdiní ásị́ ị̃gbẹ̃ ãzíla fẽ dó sĩ ãsĩkárĩ mãbụ́sụ̃ kí andre tẽlépi rĩ ní ĩꞌdi lẽjó. ");
INSERT INTO luc_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ị́jọ́ ꞌdĩ sĩ fẽ dó ꞌbá mãbụ́sụ̃ gá rĩ kí pírí ĩꞌdi ꞌbã drị́lẹ́ gá ãzíla acá dó ãko pírí idélé mãbụ́sụ̃ gá ꞌdãá rĩ kí drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ꞌBá mãbụ́sụ̃ kí tãmbalépi rĩ ꞌbã ásị́ ãko aꞌbelé Yụ̃sụ́fụ̃ drị́lẹ́ gá rĩ kí drị̃ gá ku ãꞌdusĩku ãko pírí ĩꞌdi ꞌbã idélé rĩ kí ãfũ drị̃lẹ́ba rú rá Úpí ꞌbã adrujó ĩꞌdi be cí rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Sáwã ãzí vúlé gá ꞌbá wáyĩnĩ fẽlépi ãzíla ꞌbá ãkónã aꞌdílépi úpí Mị̃sị́rị̃ gá rĩ ní rĩ iza kí ĩꞌdi ásị́. ");
INSERT INTO luc_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ị́jọ́ ꞌdĩ sĩ Fãráwũ ꞌa ve ũmbã sĩ ãmbogo ĩꞌdidrị́ ị̃rị̃ wáyĩnĩ fẽlépi, ãzíla ãkónã aꞌdílépi rĩ ꞌbanî, ");
INSERT INTO luc_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ãzíla ꞌbe dó sĩ kí mãbụ́sụ̃ gá ãmbógó ĩꞌdi andre tẽlépi rĩ drị́ jó agá ãngũ ãlu ála vâ sĩ Yụ̃sụ́fụ̃ ꞌbãjó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ãmbógó úpí Fãráwũ andre tẽlépi rĩ ꞌdụ dó ꞌbá ị̃rị̃ ꞌdĩ kí fẽlé Yụ̃sụ́fụ̃ drị́ ãzíla mba dó sĩ kí tã. Ĩꞌbaní uꞌá agá mãbụ́sụ̃ gá ꞌdãá, ");
INSERT INTO luc_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ị́nị́ ãlu urobí ũbĩ ágọ́bị́ wáyĩnĩ fẽlépi Fãráwũ ní ri kí ãkónã aꞌdílépi ĩꞌdiní rĩ be mãbụ́sụ̃ gá ꞌdãá, wó urobí ꞌdĩ kí ꞌbã ífí ndú-ndú. ");
INSERT INTO luc_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yụ̃sụ́fụ̃ la mụ filé ĩꞌba rụ́ jó agâlé ụ̃ꞌbụ́tị sĩ ꞌbo, ndre kí mẹ́lẹ́tị ízákĩzã rú. ");
INSERT INTO luc_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ị́jọ́ ꞌdĩ sĩ zị dó ãmbogo Fãráwũ drị̂ kí, “Ĩmi indré ãndrũ ízákĩzã rú íni la ãꞌdu ị́jọ́ sĩ yã?” ");
INSERT INTO luc_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Umvi kí ĩꞌdiní, “Urobí ũbĩ ãma ị̃rị̃ trá, ꞌbá ãzí ãmaní ífí la icélépi la ꞌdáyụ.” ꞌDã ꞌbã ũngúkú gá, Yụ̃sụ́fụ̃ jọ dó ĩꞌbaní, “Ị̃nị̃ urobí ífí icéŋá la angá Ãdróŋá drị́ rĩ gá ku yã? Ĩnze mání urobí ĩmidrị̂ kí vú.” ");
INSERT INTO luc_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ị́jọ́ ꞌdĩ sĩ ꞌbá ãmbógó ní wáyĩnĩ fẽlépi rĩ nze dó sĩ urobí ĩꞌdidrị̂ vú Yụ̃sụ́fụ̃ nî ãzíla jọ, “Ándre zãbíbũ ife áma drị̃lẹ́ gá, ");
INSERT INTO luc_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ãzíla kénĩ la kí na. Bị́ la kí dó mụ iꞌdólé dụlé ꞌbo, ci dó ũfũ ãzíla ka dó rá, zãbíbũ ãka ru ãgũlépi kũcũ rĩ nị kí dó rá. ");
INSERT INTO luc_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kópõ úpí Fãráwũ ꞌbã sĩ zãbíbũ sụ́ mvụjó rĩ áma drị́ gá, ãzíla áꞌdụ kópõ ꞌi ánzi zãbíbũ nịlépi rá rĩ ĩꞌdiní ala gá, áfẽ dó sĩ kópõ ĩꞌdidrị́ gá.” ");
INSERT INTO luc_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yụ̃sụ́fụ̃ jọ ĩꞌdiní, “Urobí ꞌdĩ ꞌbã ífí ĩꞌdi íni; ife ꞌbã kénĩ na ꞌda kí ụ́ꞌdụ́ na. ");
INSERT INTO luc_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ụ́ꞌdụ́ na alị ku rú, Fãráwũ la ími trũ rá ãzíla ĩꞌdi ími uja ãzị́ jõ míní ngalé rĩ gá vúlé. Mi ĩꞌdi ꞌbã kópõ wáyĩnĩ mvụjó rĩ fẽ ĩꞌdidrị́ gá, mi dó sĩ ĩꞌdiní wáyĩnĩ fẽ cécé jõ údu rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Wó ị́jọ́ ꞌdĩ drĩ kí ru idé míní múké rá, mí ũrã jõ áma ị́jọ́ ãzíla mí iꞌda jõ mání ásị́ ị̃gbẹ̃ sĩ áma vú nzejó Fãráwũ ní ĩndĩ ꞌbã nze rû sĩ ma mãbụ́sụ̃ gá ꞌdâ rá. ");
INSERT INTO luc_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ãndá-ãndá ru árụ́ ándrá ma angájó ãngũ ꞌbá Ĩbũrãníyã rú rĩ ꞌbadrị̂ gá ũkpó sĩ. Wó Mị̃sị́rị̃ gá ꞌdâ ị́jọ́ ãzí mání idélé ũnzíkãnã sĩ áma ꞌbãjó mãbụ́sụ̃ gá la ꞌdáyụ.” ");
INSERT INTO luc_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ãmbógó ãkónã aꞌdílépi rĩ la mụ arelé la Yụ̃sụ́fụ̃ icé urobî ꞌbã ífí ũniyambamba rú ꞌbo, jọ ĩꞌdiní, “Urobí ũbĩ vâ ma ĩndĩ. Urobí mádrị̂ agá ũvú mũkátĩ trũ rĩ kí áma drị̃ gá ꞌdâ na. ");
INSERT INTO luc_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ũvú ụrụgá drị̃drị̃ rĩ agá ãkónã ũví ndú-ndú aꞌdílé Fãráwũ nî rĩ kí cí, wó ãriŋa ri kí kî tilé ũvú agá ꞌdãá.” ");
INSERT INTO luc_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yụ̃sụ́fụ̃ jọ, “Urobí ꞌdĩ ꞌbã ífí íni; Ũvú na ꞌdã kí ụ́ꞌdụ́ na. ");
INSERT INTO luc_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ụ́ꞌdụ́ na alị ku rú Fãráwũ la ími drị̃kã lị rá ãzíla ĩꞌdi ími ãvũ gĩ ife sị́ gá. Ãriŋa kí dó sĩ ími ĩzá ti nĩ.” ");
INSERT INTO luc_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ụ́ꞌdụ́ na ꞌdã ꞌde dó cé ĩmbá ụ́ꞌdụ́ sĩ Fãráwũ tĩjó rĩ gá ãzíla Fãráwũ ꞌbã dó ụ̃mụ̃ ãmbógó la ꞌbá ãmbogo ĩꞌdidrị̂ ꞌbaní, ꞌbá ãzị́ ngalépi ĩꞌdidrị́ko gá rĩ kí abe. Pẽ dó sĩ ꞌbá tị ꞌbá ãmbógó ĩꞌdiní wáyĩnĩ fẽlépi rĩ kí ajílé ꞌbá ãmbógó ĩꞌdiní ãkónã aꞌdílépi rĩ be ꞌbá ãmbogo ụ̃mụ̃ gá ũꞌbí ꞌdã kí drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Fãráwũ uja dó ãmbógó ĩꞌdiní wáyĩnĩ fẽlépi rĩ ãzị́ gá vúlé sĩ wáyĩnĩ fẽjó ĩꞌdiní ídu rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Wó nzi ãmbógó ĩꞌdiní ãkónã aꞌdílépi rĩ rá cécé Yụ̃sụ́fụ̃ ꞌbã ándrá vú la nzejó ĩꞌbaní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ãmbógó wáyĩnĩ fẽlépi úpí Fãráwũ ní rĩ ãvĩ ị́jọ́ ándrá Yụ̃sụ́fụ̃ ꞌbã jọlé ĩꞌdiní ꞌbã ũrã jõ ị́jọ́ îdrị̃ gá be rĩ rá. ");
INSERT INTO luc_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ílí ị̃rị̃ ãmbógó wáyĩnĩ fẽlépi úpí Fãráwũ ní rĩ ujajó ꞌbo rĩ ꞌbã vúlé gá, urobí ũbĩ Fãráwũ ꞌi, tu pá mĩrĩ umvelé Náyĩlĩ ꞌi rĩ tị gá. ");
INSERT INTO luc_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ndre tị́ ázị̂rị̃ use-mgbụ́rụtụtụ ãlá la ãfũ kí mĩrĩ agâlé iꞌdó kí ũzú nalé. ");
INSERT INTO luc_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ꞌDã ꞌbã ũngúkú gá, ndre vâ tị́ ãzí ũnzíkãnã nzụlépi goromoto la kí ázị̂rị̃ ãfũ kí vâ Mĩrĩ Náyĩlĩ agâlé. Utu kí pá tị́ use ãlá ꞌdã kí andre gá mĩrĩ tị gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tị́ tá ũnzíkãnã nzụlépi goromoto ꞌdã na kí tị́ use-mgbụ́rụtụtụ ãlá ꞌdã kí pírí rá. ꞌDã ꞌbã ũngúkú gá, Fãráwũ angá rá. ");
INSERT INTO luc_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Wó ụ́ꞌdụ́ ꞌbe ĩꞌdi ị̃dị́ ãzíla urobí ị̃rị̃ rĩ ũbĩ vâ ĩꞌdi; urobí ị̃rị̃ ꞌdĩ gá ndre ãná céke ãlu gá ãná ãgũ kí use-use rú ãzíla ũniyambamba rú ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ꞌDã ꞌbã vúlé gá ndre vâ ãná céke ãlu gá ãná nụlépi ị̃tụ́kã sĩ diri-diri la kí ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ãná nụlépi ị̃tụ́kã sĩ diri-diri ꞌdã uti kí ãná use-use ꞌdã kí pírí. Fãráwũ angá dó rá ịsụ́ íni ꞌdĩ urobí la ĩꞌdi ũbĩ agá nĩ. ");
INSERT INTO luc_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ãngũ la mụ ụwị́lé ꞌbo, ụ̃ꞌbụ́tị sĩ Úpí Fãráwũ ásị́ ri umvúlé umvû; ị́jọ́ ꞌdĩ sĩ pẽ dó ꞌbá tị ũjogo kí umvelé ꞌbá ũndũwã trũ Mị̃sị́rị̃ gá rĩ abe. Fãráwũ nze dó urobí ĩꞌdi ũbĩlépi rĩ kí vú ꞌbá ꞌdĩ ꞌbanî, wó ꞌbá ãzí icólépi urobí ꞌdĩ kí ífí icélépi ĩꞌdiní rá la yụ. ");
INSERT INTO luc_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ꞌDã ꞌbã ũngúkú gá, ãmbógó wáyĩnĩ fẽlépi rĩ jọ Fãráwũ ní, “Má agá ị́jọ́ mání izalé rĩ ãndrũ rá. ");
INSERT INTO luc_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Fãráwũ uꞌá ándrá ũmbã sĩ ãtiꞌbo ĩꞌdidrị́ gá rĩ ꞌbanî ãzíla ꞌbã ma mãbụ́sụ̃ gá ãmbógó ꞌbá ãkónã aꞌdílépi rĩ kí drị̃lẹ́ gá rĩ be jó ãsĩkárĩ ãmbógó úpí andre tẽlépi rĩ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Urobí ũbĩ ãma ị́nị́ ãlu agá ãzíla urobí ãma ũbĩlépi ꞌda kí ífí ndú-ndú. ");
INSERT INTO luc_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ịsụ́ íni ꞌdĩ kãrị́lẹ̃ Ĩbũrãníyã rú ãmbógó ãsĩkárĩ úpí andre tẽlépi rĩ kí drị̃lẹ́ gá rĩ ꞌbã ãtíꞌbó ru rĩ ándrá ꞌdãá cí. Ãnze urobí ãma ũbĩlépi rĩ kí vú ĩꞌdinî, ãzíla icé ꞌbá ãlu-ãlu ꞌbã urobí ífí ꞌbá ãlu-ãlu ní rá. ");
INSERT INTO luc_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Urobí ífí ĩꞌdi ꞌbã icélé rĩ idé kí ru cécé ĩꞌdi ꞌbã jọlé rĩ áni; mâ rú rĩ ûja ma ãzị́ gá rá, ágọ́bị́ ãzí rĩ úꞌdị ĩꞌdi rá.” ");
INSERT INTO luc_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Fãráwũ pẽ dó ꞌbá tị Yụ̃sụ́fụ̃ umvelé, gbõgbõ íyá dó Yụ̃sụ́fụ̃ mãbụ́sụ̃ gâlé rá. Ĩꞌdi mụ ru drị̃ꞌbị́ falé ꞌbo uja dó bõngó ãzíla mụ dó sĩ Fãráwũ drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Fãráwũ jọ Yụ̃sụ́fụ̃ ní, “Urobí ũbĩ ma, wó ꞌbá ãzí icólépi mání ífí la icélépi rá la yụ wó újọ mání mi urobí ífí icé rá údrĩ míní vú la nze rá rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yụ̃sụ́fụ̃ umvi Fãráwũ ní, “Má icé urobí ífí má ꞌi ku, wó rá la Ãdróŋá la míní urobí múké rĩ ꞌbã ífí icé nĩ.” ");
INSERT INTO luc_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ꞌDã ꞌbã ũngúkú gá, Fãráwũ jọ Yụ̃sụ́fụ̃ ní, “Urobí áma ũbĩlépi rĩ agá átu pá Mĩrĩ Náyĩlĩ tị gá, ");
INSERT INTO luc_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ãzíla ándre tị́ ázị̂rị̃ use-mgbụ́rụtụtụ ãlá la ãfũ kí Mĩrĩ Náyĩlĩ agâlé iꞌdó kí ũzú nalé. ");
INSERT INTO luc_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ꞌDã ꞌbã vúlé gá, ándre tị́ ãzí ũnzíkãnã nzụlépi goromoto la kí ázị̂rị̃ ãfũ kí vâ Mĩrĩ Náyĩlĩ agâlé. Ándre jõ drĩ tị́ ãzí ũnzíkãnã nzụlépi goromoto ꞌdã áni la kí ãngũ Mị̃sị́rị̃ drị̂ gá ꞌdâ ãluŋá la ku. ");
INSERT INTO luc_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tị́ ũnzíkãnã nzụlépi goromoto ꞌdã uti kí tị́ use mgbụrụtụtụ ãlá ꞌda kí pírí rá. ");
INSERT INTO luc_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Wó ĩꞌbaní táni tị́ use mgbụrụtụtụ ãlá ꞌda kí uti agá rá tí, mí icó nị̃lé la uti kí kí rá rĩ gá ku ãꞌdusĩku ace kí goromoto rú ũgũgõ. ꞌDã ꞌbã ũngúkú gá, ma angá dó rá. ");
INSERT INTO luc_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Urobí áma ũbĩlépi ị̃rị̃ rĩ gá ándre ãná céke ãlu gá ãná ãgũ kí use-use rú ãzíla ũniyambamba rú ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ꞌDã ꞌbã vúlé gá ándre vâ ãná céke ãlu la gá ãná nụlépi ị̃tụ́kã sĩ diri-diri la kí ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ãná nụlépi ị̃tụ́kã sĩ diri-diri ꞌdã uti kí ãná tá use-use ãzíla ũniyambamba rú ꞌdĩ kí pírí rá. Ánze dó urobí ị̃rị̃ ꞌdĩ kí vú ꞌbá mádrị́ ũjogo rú ꞌdĩ ꞌbanî, wó ꞌbá ãzí ãlu icólépi mání ífí la kí icélépi rá la ꞌdáyụ.” ");
INSERT INTO luc_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ꞌDã ꞌbã ũngúkú gá, Yụ̃sụ́fụ̃ jọ Fãráwũ ní, “Urobí ị̃rị̃ ími ũbĩlépi ꞌdĩ kí ꞌbã ífí ꞌbã ngá ãlu. Ãdróŋá iꞌda míní ị́jọ́ ĩꞌdi ꞌbã lẽlé mụlé ngalé rĩ kî. ");
INSERT INTO luc_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tị́ ázị̂rị̃ use mgbụrụtụtụ ꞌda kí ãzíla ãná céke ãlu gá ãgũlépi use-use rú ãzíla ũniyambamba rú ázị̂rị̃ ꞌdã kí ílí ázị̂rị̃; wó kí pírí urobí ífí ãlu la. ");
INSERT INTO luc_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Tị́ ázị̂rị̃ ũnzíkãnã nzụlépi goromoto ꞌdã kí Ãná nụlépi ị̃tụ́kã sĩ diri-diri ázị̂rị̃ ꞌda kí abe kí ílí ázị̂rị̃ ãbị́rị́ ꞌbã sĩ ꞌdejó nĩ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ĩꞌdi cécé tá mání jọlé Fãráwũ ní rĩ áni, Ãdróŋá la míní ị́jọ́ ĩꞌdi ꞌbã lẽlé mụlé idélé rĩ kí iꞌda. ");
INSERT INTO luc_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ílí ázị̂rị̃ ꞌda kí agá ãkónã la mụ kalé rõnzõ-rõnzõ ãngũ Mị̃sị́rị̃ drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Wó ílí ázị̂rị̃ ãkónã ꞌbã sĩ kajó rõnzõ-rõnzõ ꞌdã kí ũngúkú gá rílẽ la mụ ꞌdelé ílí ázị̂rị̃. ꞌDã ꞌbã ũngúkú gá, ãkónã kalépi ãngũ Mị̃sị́rị̃ drị̂ gá rõnzõ-rõnzõ ꞌda kí ukó rá ãzíla rílẽ ꞌdã la ãngũ iza ũnzíkãnã rú. ");
INSERT INTO luc_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Rílẽ ꞌdã ꞌbã ũnzĩkãnã sĩ ị́jọ́ ãkónã ka ándrá ãngũ Mị̃sị́rị̃ drị̂ gá rõnzõ-rõnzõ rá rĩ la ãvĩ rá. ");
INSERT INTO luc_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ásị́sị́ŋá Ãdróŋá ꞌbã urobí ị̃rị̃ ꞌdĩ kí iꞌdajó Fãráwũ míní rĩ Ãdróŋá ꞌbã ị́jọ́ la ũkpó ru, ãzíla ĩꞌdi mụ ị́jọ́ ꞌdĩ idélé gbõŋáŋá ru. ");
INSERT INTO luc_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Ị́jọ́ ꞌdĩ sĩ, lẽ Fãráwũ ꞌbã ndrụ̃ ꞌbá ãzí ị́jọ́ nị̃lépi cé ãzíla ũndũwã rú la ꞌbãlé ãmbógó ru ãngũ Mị̃sị́rị̃ drị̂ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Lẽ Fãráwũ ꞌbã ũpẽ vâ ꞌbá ãzí drị̃lẹ́ ru la kí ãkónã kalépi ílí ázị̂rị̃ ꞌdĩ agá rĩ kí ꞌbã ĩsélé ãlu tõwú drị̂ trajó. ");
INSERT INTO luc_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ị́jọ́ Fãráwũ ꞌbã azịlé rĩ sĩ ꞌbã tra kí ãkónã ílí amụ́lépi ázị̂rị̃ ũniyambamba ꞌdĩ kí agá, ꞌbã mba kí dó sĩ ãkónã ꞌdĩ kí tã ĩrá gá táwụ̃nị̃ ãlu-ãlu agá. ");
INSERT INTO luc_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Lẽ úmba ãkónã ꞌdĩ kí tã lómúre gá múké-múké sĩ ãbị́rị́ amụ́lépi ãngũ Mị̃sị́rị̃ drị̂ drị̃ gá ílí ázị̂rị̃ ꞌdã kí agá ꞌdã drị̃ tẽjó rílẽ ꞌbã ị̃lị̃kị̃ rû sĩ ꞌbá Mị̃sị́rị̃ drị̂ kí ku.” ");
INSERT INTO luc_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ị́jọ́ Yụ̃sụ́fụ̃ ꞌbã itúlé ꞌdĩ fẽ ãyĩkõ Fãráwũ ní ãmbogo ĩꞌdidrị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ị́jọ́ ꞌdĩ sĩ Fãráwũ zị ãmbogo ĩꞌdi pálé gá rĩ kî, “Ãma icó ꞌbá ãzí úríndí Ãdróŋá drị̂ trũ ị́jọ́ ngalépi cécé Yụ̃sụ́fụ̃ áni la ịsụ́lé rá yã?” ");
INSERT INTO luc_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ꞌDã ꞌbã ũngúkú gá, Fãráwũ jọ Yụ̃sụ́fụ̃ ní, “Ãdróŋá ꞌbã ị́jọ́ ꞌdĩ kí ífí icéjó míní rĩ sĩ, ꞌbá ãzí calépi mí rụ́ ị́jọ́ vãŋá sĩ ãzíla ũndũwã sĩ ími ndẽlépi Mị̃sị́rị̃ gá ꞌdâ rá la yụ. ");
INSERT INTO luc_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ma mụ ími ꞌbãlé ãzị́ ꞌdĩ ꞌbã drị̃lẹ́ ru, mi dó adru ãmbógó ãko mádrị́ lị́cọ́ agá rĩ kí drị̃lẹ́ gá pírí ãzíla ꞌbá mádrị̂ kí pírí mụ ị́jọ́ arelé ími tị gá, ma dó adru ãmbógó ru ími drị̃lẹ́ gá la lú úmvúke mádrị́ ũpĩ drị̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Áꞌbã dó mi ãmbógó ru ãngũ Mị̃sị́rị̃ drị̂ drị̃lẹ́ gá pírí.” ");
INSERT INTO luc_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ꞌDã ꞌbã ũngúkú gá, Fãráwũ ãtrũ kátĩ ĩꞌdidrị́mváŋá gá rĩ sulé Yụ̃sụ́fụ̃ drị́ gá ãzíla ụ̃sụ̃ dó ĩꞌdi kánzũ ãmbõgõ drị̂ kî sĩ, gĩ ĩꞌdi imbe gá nõrórõ gólũdĩ rú ũpĩ drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Fãráwũ fẽ dó gá rĩ ãmbógó ũpĩ gá námbã ị̃rị̃ sĩ rĩ drị̂ Yụ̃sụ́fụ̃ ní sĩ cẹ̃jó ãzíla ꞌbá kí dó dị̃ uzâ sĩ, “Ĩmi aꞌbe gẹ̃rị̃ ãmbógó nî,” Yụ̃sụ́fụ̃ acá dó sĩ ãmbógó Fãráwũ ꞌbã ũngúkú gá námbã ãlu sĩ rĩ rú. Fãráwũ ꞌbã dó ĩꞌdi ãmbógó ru ãngũ Mị̃sị́rị̃ drị̂ drị̃lẹ́ gá pírí. ");
INSERT INTO luc_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Fãráwũ jọ Yụ̃sụ́fụ̃ ní, “Ma úpí ru ma ꞌi, ꞌbá ãzí icó ãzị́ ngalé Mị̃sị́rị̃ gá ꞌda ími tị kóru ku.” ");
INSERT INTO luc_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Fãráwũ uja dó Yụ̃sụ́fụ̃ rụ́ ꞌdalé Zãfẽnátĩ Pãnéyã ꞌi. Fẽ dó Ãsĩnátã Pọ̃tị̃fẹ́rã átáló úrí uwilépi Ụ́nị̃ gá rĩ ꞌbã ị̃zẹ́pị ĩꞌdiní ũkú ru. Yụ̃sụ́fụ̃ acị́ dó ãngũ Mị̃sị́rị̃ drị̂ agâ sĩ pírí. ");
INSERT INTO luc_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yụ̃sụ́fụ̃ ílí dó mụ calé kãlị́ na ꞌbo iꞌdó dó ãzị́ ngalé úpí Fãráwũ pálé gá, fũ dó Fãráwũ drị̃lẹ́ gá rĩ sĩ ãzíla acị́ ãngũ Mị̃sị́rị̃ drị̂ undré trũ pírí. ");
INSERT INTO luc_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ílí ázị̂rị̃ ãkónã ꞌbã sĩ kajó rĩ sĩ, ãngũ ka dó ãkónã kpẽté-kpẽté. ");
INSERT INTO luc_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yụ̃sụ́fụ̃ tra dó ãkónã kalépi kpẽté-kpẽté ílí ázị̂rị̃ Mị̃sị́rị̃ gá ꞌdãá rĩ kí, ꞌbã dó sĩ kí pírí ĩrá gá. Tra ãkónã ámvụ́ táwụ̃nị̃ ãlu-ãlu andre gá rĩ, mba dó kí tã táwụ̃nị̃ ãlu-ãlu gá ꞌdãá cí. ");
INSERT INTO luc_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yụ̃sụ́fụ̃ mba dó ãkónã tã ĩrá gá tré-tré ụ̃ꞌbị̃ŋá la ndẽ ĩꞌdi rá ãkónã ꞌbã adrujó cécé cínákí mĩrĩ gá rĩ áni rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ílí rílẽ ꞌbã aꞌdéjó rĩ acá drĩ ku rú, Ãsĩnátã Pọ̃tị̃fẹ́rã átáló úrí uwilépi Ụ́nị̃ gá rĩ ꞌbã ị̃zẹ́pị tị Yụ̃sụ́fụ̃ ní anzị kí ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yụ̃sụ́fụ̃ ꞌda dó sĩ ngọ́tị́ kãjãní rĩ rụ́ Mãnásẽ ꞌi jọ, “Ãꞌdusĩku Ãdróŋá fẽ má ãvĩ ị́jọ́ ũcõgõ mádrị̂ kí drị̃ gá ãzíla ꞌbá má átẹ́pị drị́ jó agá rĩ kí abe pírí rá.” ");
INSERT INTO luc_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ꞌDa ngọ́tị́ŋá vúlé rĩ ꞌbã rụ́ Ịfụrayị́mụ̃ ꞌi jọ, “Ãꞌdusĩku Ãdróŋá wi mání sụ̃sụ́ ma dô sĩ drị̃lẹ́ trũ ãngũ mání sĩ ũcõgõ najó rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ílí ázị̂rị̃ ãkónã ꞌbã kajó rõnzõ-rõnzõ Mị̃sị́rị̃ gá rĩ ukó kí dó rá, ");
INSERT INTO luc_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ãzíla ílí ázị̂rị̃ rílẽ drị̂ iꞌdó kí dó cécé Yụ̃sụ́fụ̃ ꞌbã ándrá jọlé rĩ áni. Rílẽ ꞌde dó ãngũ drị̃ gá pírí, wó ãkónã ꞌbã ngá ãngũ Mị̃sị́rị̃ drị̂ agá pírí cí. ");
INSERT INTO luc_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ꞌBá pírí Mị̃sị́rị̃ gá rĩ kí mụ rílẽ ꞌdã ĩtrĩkãlé ꞌbo, ꞌbã kí mãmálá Fãráwũ drị̃lẹ́ gá ãkónã ị́jọ́ sĩ. Fãráwũ jọ ꞌbá Mị̃sị́rị̃ gá ꞌdãá rĩ ꞌbanî, “Ĩmụ Yụ̃sụ́fụ̃ rụ́, ãzíla ĩmi idé ị́jọ́ ĩꞌdi ꞌbã jọlé ĩminî rĩ kî.” ");
INSERT INTO luc_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Rílẽ ꞌdã iré dó ãngũ Mị̃sị́rị̃ drị̂ agá sĩ pírí, Yụ̃sụ́fụ̃ nzị̃ ĩrá lómúre rú rĩ kí tị sĩ ãkónã ụzịjó ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbaní ãbị́rị́ ꞌbã adrujó ambamba rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Sụ́rụ́ pírí amụ́ kí dó ãkónã ĩgbãlé Yụ̃sụ́fụ̃ drị́ Mị̃sị́rị̃ gá ãꞌdusĩku rílẽ ꞌdã ꞌbã mịfị́ ka ụ̃nọ́kụ́ drị̃ gá ꞌdâ pírí. ");
INSERT INTO luc_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yãkóꞌbõ la mụ arelé la ãkónã ãngũ Mị̃sị́rị̃ drị̂ gá cí, jọ anzị ĩꞌdidrị̂ ꞌbaní, “Ĩmi ídé ị́jọ́ ãzí ku ãꞌdu sĩ yã? ");
INSERT INTO luc_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Má are Mị̃sị́rị̃ gâlé ãkónã cí, ĩmụ ꞌbání ĩgbãlé la sĩ uꞌájó ídri ãbị́rị́ ika ꞌdĩ agá ꞌdâ ãma icó dó sĩ ũdrãlé ku.” ");
INSERT INTO luc_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ị́jọ́ ꞌdĩ sĩ, Yụ̃sụ́fụ̃ ꞌbã ádrị́pịka mụdrị́ rĩ mụ kí dó ãkónã ĩgbãlé Mị̃sị́rị̃ gâlé nĩ. ");
INSERT INTO luc_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Wó Yãkóꞌbõ uga Yụ̃sụ́fụ̃ ꞌbã ádrị́pị Bénzãmĩnĩ mụlé ĩꞌba abe úmgbé ãꞌdusĩku idé ụ̃rị̃ sĩ, ũrã ị́jọ́ ãzí ũnzí la icó mụlé ru idélé ĩꞌdi ụrụꞌbá gá rá. ");
INSERT INTO luc_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Anzị Yãkóꞌbõ drị́ ꞌdĩ mụ kí ꞌbá ãzí mụlépi ãkónã ĩgbãlépi Mị̃sị́rị̃ gâlé rĩ kí abe ãꞌdusĩku rílẽ ꞌde ándrá vâ ãngũ Kãnánĩ drị̂ agá ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yụ̃sụ́fụ̃ ꞌbã ándrá adrujó ãmbógó ru ãngũ Mị̃sị́rị̃ drị̂ gá rĩ sĩ, ri ãkónã ụzịlé ꞌbá ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ ꞌbaní pírí nĩ. Yụ̃sụ́fụ̃ ꞌbã ádrị́pịka kí mụ acálé ꞌbo tị̃ kí ãja ãzíla su kí drị̃ vụ̃rụ́ ĩꞌdi drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yụ̃sụ́fụ̃ la mụ ádrị́pịka kí ndrelé ꞌbo, cọtị nị̃ kí cé, wó ꞌbã ru ínị̃ kí ku. Zị kí ũmbájírílí, “Ĩmi angá íngõlé yã?” Umvi kí ĩꞌdiní, “Ãma angá ãngũ Kãnánĩ drị̂ gá, ãma amụ́ ãkónã ĩgbãlé.” ");
INSERT INTO luc_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yụ̃sụ́fụ̃ ní táni ádrị́pịka kí nị̃ agá rá tí, wó nị̃ kí ĩꞌdi ku. ");
INSERT INTO luc_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ꞌDã ꞌbã ũngúkú gá, ị́jọ́ ándrá urobí ꞌbã ĩꞌdi ũbĩjó rĩ agá kí dó ĩꞌdinî, ãzíla jọ ĩꞌbaní, “Ĩmi ꞌbá ũní-ũníŋá gá la kî; ĩmi amụ́ lú sĩ lẽjó ãngũ ãmadrị́ ꞌdĩ ị̃ndụ́ ndrụ̃jó sĩ nị̃jó la ĩꞌdi ũkpó kóru la wókõ íngõ gá yã rĩ.” ");
INSERT INTO luc_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Umvi kí, “Yụ, úpí ãmadrị̂ ãtiꞌbo mídrị̂ amụ́ kí ãkónã ĩgbãlé. ");
INSERT INTO luc_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ãma pírí anzị átẹ́pị ãlu ãni la. Ãma adru ꞌbá ũní-ũníŋá gá la kî ku, ãma ꞌbá ị́jọ́ mgbã idélépi la kî.” ");
INSERT INTO luc_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yụ̃sụ́fụ̃ jọ ĩꞌbaní, “Yụ! Ĩmi amụ́ lú sĩ lẽjó ãngũ ãmadrị́ ꞌdĩ ị̃ndụ́ ndrụ̃jó sĩ nị̃jó la ĩꞌdi ũkpó kóru la wókõ íngõ gá yã rĩ.” ");
INSERT INTO luc_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Wó jọ kí, “Ãtiꞌbo mídrị̂ kí ándrá ádrị́pịka rú pírí rĩ gá ꞌbá mụdrị́ drị̃ ị̃rị̃, ãma anzị ꞌbá ãlu ãni la kí angájó ãngũ Kãnánĩ drị̂ gá. Ãmã ádrị́pị ãlu rĩ drã rá, ãzí vúléŋá rĩ ace ru ãmã átẹ́pị be.” ");
INSERT INTO luc_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yụ̃sụ́fụ̃ jọ ĩꞌbaní, “Ĩꞌdi tá mání jọlé ĩminí rĩ áni, ĩmi ꞌbá ũní-ũníŋá gá la kî. ");
INSERT INTO luc_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ma ĩmi ụ̃ꞌbị̃ ꞌdĩ áni: Ána ũyõ úpí Fãráwũ ꞌbã rụ́ sĩ ĩmi icó gõlé ku kpere ĩmi ádrị́pị vúléŋá ꞌdã ꞌbã acâ gá ꞌdâ. ");
INSERT INTO luc_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ĩmi ãzí ãlu la ꞌbã mụ ĩmĩ ádrị́pị ajílé. Ála ĩmi ãzí rĩ kí ꞌbã mãbụ́sụ̃ gá, ma sĩ nị̃ la ị́jọ́ ĩminí jọlé ꞌdĩ ĩꞌdi jõ nõ ị́jọ́ mgbã la yã áni. Ĩdrĩ ĩmĩ ádrị́pị vúléŋá ꞌdã ají ku, ị́jọ́ mání jọlé rĩ, ána ũyõ úpí Fãráwũ ꞌbã rụ́ sĩ ĩmi ꞌbá ũní-ũníŋá gá la kî!” ");
INSERT INTO luc_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ꞌDã ꞌbã vúlé gá Yụ̃sụ́fụ̃ ꞌbã dó kí mãbụ́sụ̃ gá ụ́ꞌdụ́ na. ");
INSERT INTO luc_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ụ́ꞌdụ́ na la sĩ Yụ̃sụ́fụ̃ jọ ĩꞌbaní, “Ma ꞌbá Ãdróŋâ ụ̃rị̃lépi rá la, ma ĩmi aꞌbe ídri rá ĩdrĩ ị́jọ́ ꞌdĩ nga rá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ĩmi ꞌbá mgbã la yã rĩ nị̃jó, ĩmĩ ãzí ãlu rĩ ꞌbã ace mãbụ́sụ̃ gá ꞌdâ; ĩmi ãzí rĩ icó kí gõlé vúlêlé íná ĩꞌbã kí ĩgbãlé rĩ trũ ꞌbá ĩꞌbadrị́ ãbị́rị́ trũ ꞌdã ꞌba rụ̂lé rá. ");
INSERT INTO luc_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Wó ĩminí ãgõ agá ĩmi ají ĩmĩ ádrị́pị vúléŋá rĩ má rụ́ ꞌdõlé ĩndĩ. ꞌDĩ la iꞌda la mání ĩmi ị́jọ́ mgbã rĩ jọ ãzíla má icó dó sĩ ĩmi ụꞌdị́lé ku.” Ãꞌị̃ kí ị́jọ́ ꞌdĩ idéjó rá. ");
INSERT INTO luc_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Iꞌdó dó kí ị́jọ́ jọlé kí drĩdríŋĩ gá, jọ kí ãndá-ãndá ru “Ị́jọ́ ꞌdĩ kí ru idé ãma ụrụꞌbá gá íni la ãmaní ándrá ãmã ádrị́pị Yụ̃sụ́fụ̃ idéjó ũnzí rĩ sĩ. Ãndre kí ándrá ũcõgõ ĩꞌdi ꞌbã adrujó ala gá rĩ ãzíla drị́ ĩꞌdi ꞌbã ãꞌbãlé ãzãkoma aꞌị́jó ãmadrị́ rĩ rá, wó ãma are kí ándrá ĩꞌdi ku. Ũcõgõ ãmadrị́ ꞌdĩ acá ãma drị̃ gá ị́jọ́ ándrá ãmaní idélé rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rụ́bẹ̃nị̃ jọ, “Ájọ ándrá ĩmi idé mgbâ ũnzí ku rĩ gá ku yã? Wó ĩmi are ándrá áma tị ku. Ãma kí dó mụ ũdrãlé ãvũ ãrí ũfẽjó ãmã kí ándrá ĩꞌdi ꞌdịjó rá rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yụ̃sụ́fụ̃ are ị́jọ́ ĩꞌbã kí jọlé rĩ cé, wó ũrã kí ꞌbã ngá are ku íni ãꞌdusĩku Yụ̃sụ́fụ̃ rĩ ị́jọ́ jọlé ĩꞌba abe ꞌdĩ sĩ ꞌbá ãzí la tị uja agá ĩꞌbaní nĩ. ");
INSERT INTO luc_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yụ̃sụ́fụ̃ ĩdã ru kí andre gá ꞌdãá rĩ sĩ mbẽlẽŋá ru, fũ mụlé awálé bụ́lụ́ gá. Ĩꞌdi mụ ĩyãŋãlé ꞌbo, ãgõ vúlé ĩꞌba rụ́ ꞌdõlé, fẽ Sị̃mọ́nị̃ arụ́lé ãzíla úmbé ĩꞌdi mgbemgbe ádrị́pịka kí drị̃ gâsĩ. ");
INSERT INTO luc_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yụ̃sụ́fụ̃ azị ị́jọ́ ũkpó ru ãtiꞌbo ĩꞌdidrị́ ꞌdĩ ꞌbaní sĩ ãkónã tõjó ádrị́pịka kí ꞌbã gụ̃tị́yã kí agá, ꞌbá ãlu-ãlu ꞌbã séndẽ sujó gụ̃tị́yã agá ãzíla ĩꞌbaní ãkónã gẹ̃rị̃ ãni la fẽjó ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ũꞌbã kí dó ãkónã ĩꞌbaní ĩgbãlé rĩ kí kãyĩnõ kí drị̃ gá ãzíla ko kí dó drị̃ gõlé vúlé. ");
INSERT INTO luc_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ãngũ ĩꞌbã kí ụ́ꞌdụ́ kojó rĩ gá ĩꞌbã ãzí ãlu la nzị̃ gụ̃tị́yã ĩꞌdidrị̂ tị sĩ ãkónã ãndĩjó kãyĩnõ nî, ịsụ́ úꞌbã séndẽ ĩꞌdidrị̂ ãkónã drị̃ gá gụ̃tị́yã agá ꞌdãá ũgũgõ. ");
INSERT INTO luc_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Umve ádrị́pịka kí jọ, “Séndẽ mádrị̂ ûja ĩꞌdi mádrị́ vúlé. Ĩndre ĩꞌdi gápi gụ̃tị́yã agá ꞌdĩ!” Kí ásị́ mvu rụ̃, ãzíla acá kí ụ̃rị̃ sĩ jọ kí, “Ị́jọ́ Ãdróŋá ꞌbã idélé ãma rụ́ íni ꞌdĩ dó ãꞌdu ị́jọ́?” ");
INSERT INTO luc_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kí dó mụ acálé átẹ́pị̃ Yãkóꞌbõ rụ́ Kãnánĩ gá ꞌdõlé ꞌbo, nze kí ị́jọ́ ru idélépi ĩꞌba abe rĩ kí vú pírí jọ kí, ");
INSERT INTO luc_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ãmbógó Mị̃sị́rị̃ drị̂ ri ị́jọ́ jọlé ãma abe ũkpómgboroto rú ãzíla alị́ ĩnzõ ãma ụrụꞌbá gá jọ, ãma amụ́ íni la ãngũ ĩꞌdidrị̂ ị̃ndụ́ ndrụ̃ trũ. ");
INSERT INTO luc_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ãjọ ĩꞌdiní, ‘Ãma adru ꞌbá ũní-ũníŋá gá la kî ku, ãma ꞌbá mgbã la kî. ");
INSERT INTO luc_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ãma pírí rĩ gá ádrị́pịka rú ꞌbá mụdrị́ drị̃ ị̃rị̃, anzị ꞌbá ãlu ãni. Ãmã ádrị́pị ãlu rĩ drã rá, ãzí vúléŋá rĩ ace ru ãmã átẹ́pị be Kãnánĩ gâlé ꞌdã.’ ");
INSERT INTO luc_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“ꞌDã ꞌbã ũngúkú gá, ágọ́bị́ úpí ru ãngũ ꞌdã gá rĩ jọ ãmaní, ‘Ma mụ nị̃lé la ĩmi ꞌbá mgbã la rĩ gá ị́jọ́ ꞌdĩ sĩ: Ĩmi aꞌbe ĩmi ádrị́pị ãzí ãlu rĩ má be ꞌdâ; ãzíla ĩꞌdụ ãkónã agụlé ꞌbá ĩmi drị́ko gá ãbị́rị́ ru ꞌdã ꞌba nî. ");
INSERT INTO luc_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Wó ĩmi ají ĩmi ádrị́pị vúléŋá rĩ má rụ́ ꞌdõlé ĩndĩ ma dó sĩ nị̃ la lọ́lọ́ ĩmi adru ꞌbá ũní-ũníŋá gá la kí ku, wó ꞌbá mgbã la kî; ma dó sĩ ĩmi ádrị́pị fẽ vúlé ĩmidrị́, ĩmi dó sĩ bĩsírã nga ãma be ãngũ ꞌdĩ gá ꞌdâ.’” ");
INSERT INTO luc_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ĩꞌbaní ĩꞌbã ãkónã kí ũsũ agá, ꞌbá ãlu-ãlu ndre ĩꞌdi ꞌbã bẹ́gị̃ séndẽ drị̂ séndẽ kî trũ gụ̃tị́yã agá ꞌdãá ũgũgõ, kí mụ átẹ́pị̃ trũ séndẽ kí ndrelé bẹ́gị̃ agá ꞌdãá ꞌbo, ụ̃rị̃ rụ kí átẹ́pị̃ Yãkóꞌbõ trũ cí. ");
INSERT INTO luc_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Átẹ́pị̃ jọ ĩꞌbaní, “Ĩlẽ mâ ãvĩ mâ anzị kí pírí yã? Yụ̃sụ́fụ̃ ꞌdáyụ; Sị̃mọ́nị̃ dó vâ ꞌdáyụ; ãzíla ĩlẽ vâ Bénzãmĩnĩ ꞌdụlé rá. ꞌBá ũcõgõ la nalépi rĩ ĩꞌdi dó ma ꞌi.” ");
INSERT INTO luc_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rụ́bẹ̃nị̃ jọ átẹ́pị̃ nî, “Ádrĩ Bénzãmĩnĩ ají vúlé mí rụ́ ꞌdõlé ku, mi anzị mádrị́ ị̃rị̃ ꞌdĩ kí ụꞌdị́ tị la gá. Ífẽ ĩꞌdi áma drị́lẹ́ gá ãzíla ma rú ĩꞌdi ají vúlé mị́rụ́ ꞌdõlé rá.” ");
INSERT INTO luc_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Wó Yãkóꞌbõ jọ, “Mâ ngọ́pị icó mụlé mí be ku; ãꞌdusĩku ádrị́pị̃ Yụ̃sụ́fụ̃ drã rá, ĩꞌdi dó lú ngọ́tị́ŋá acelépi ãndrẽ agá ꞌdâ rĩ ꞌi. Ị́jọ́ ãzí drĩ dó mụ ru idélé ĩꞌdi ụrụꞌbá gá gẹ̃rị̃ agâlé, ị́jọ́ ĩminí ajílé áma drị̃ gá ꞌdĩ la áma ĩdrãnĩgõ fẽ filé ꞌbụ́ gâlé ũcõgõ trũ.” ");
INSERT INTO luc_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kãnánĩ gá ꞌdãá rílẽ acá ũnzí trẹ̃yị́. ");
INSERT INTO luc_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ꞌBá Yãkóꞌbõ drị́ko gá rĩ kí mụ ãkónã ándrá ajílé Mị̃sị́rị̃ gâlé rĩ nalé pírí ꞌbo, Yãkóꞌbõ jọ ngọ́pịka ꞌbanî, “Ĩgõ ꞌbání ãkónã ãzí kí ĩgbãlé Mị̃sị́rị̃ gâlé.” ");
INSERT INTO luc_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Wó Yụ́dã jọ átẹ́pị̃ ní, “Ágọ́bị́ ꞌdã li ándrá ãma bị́lẹ́ ị̃ndụ́ ũkpómgboroto rú jọ, ‘Má icó ĩminí ãꞌị̃lé amụ́lé áma drị̃lẹ́ gá ku ĩdrĩ amụ́ ĩmi ádrị́pị vúléŋá rĩ kó ru rĩ gá.’ ");
INSERT INTO luc_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ídrĩ ãꞌị̃ Bénzãmĩnĩ fẽlé mụjó ãma abe rá, ãma mụ ãkónã ĩgbãlé míní rá. ");
INSERT INTO luc_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ídrĩ ãꞌị̃ ku yã áni, ãma icó mụlé ku, ãꞌdusĩku ágọ́bị́ ꞌdã jọ ándrá ãmaní, ‘Má icó ĩminí ãꞌị̃lé amụ́lé áma drị̃lẹ́ gá ku ĩdrĩ amụ́ ĩmi ádrị́pị vúléŋá rĩ kó ru rĩ gá.’” ");
INSERT INTO luc_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yãkóꞌbõ zị kí, “Ĩlũ ágọ́bị́ ꞌdã ní ĩmĩ ádrị́pị ãzí cí mání sĩ ũcõgõ ịsụ́jó ásị́ gá íni ãꞌdu ị́jọ́ sĩ?” ");
INSERT INTO luc_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Umvi kí, “Ágọ́bị́ ꞌdã ri ị́jọ́ ụzịlé ãma tị gá ãzíla ꞌbá ãmadrị́ lị́cọ́ agá rĩ kí drị̃ gá jọjó la, ‘Ĩmi átẹ́pị drĩ kpere ídri yã? Ĩmĩ ádrị́pị ãzí cí yã?’ Ị́jọ́ ꞌdĩ sĩ, ãma ũlũ dó sĩ ĩꞌdiní kí rá. Ãma icó tâ dó nị̃lé la ĩꞌdi ꞌbã jọ la, ‘Ĩmi ají ĩmi ádrị́pị vúléŋá rĩ ĩndĩ rĩ gá íngoní ru’?” ");
INSERT INTO luc_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ꞌDã ꞌbã ũngúkú gá, Yụ́dã jọ átẹ́pị̃ Yãkóꞌbõ nî, “Ípẽ mgbâ tị má be ãma dó sĩ drị̃ ko mụlé cọtị. Ị́jọ́ ꞌdĩ sĩ ꞌbá ãzí ãlu la ꞌbã drã rú dó sĩ ãbị́rị́ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ma pa tu ĩꞌdi ị́jọ́ gá ma ꞌi, mi dó sĩ amụ́ ĩꞌdi ịsụ́lé áma drị́ gá. Ádrĩ ĩꞌdi ají mí rụ́ ꞌdõlé ku, lẽ áwá dó ĩꞌdi ị́jọ́ áma ụrụꞌbá gá jãꞌdâ. ");
INSERT INTO luc_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ãdrĩ tá sáwã iza gá biri ꞌdĩ áni ku, ãma acị́ tánõ lé pâlé ị̃rị̃ ꞌdĩpí ꞌbo.” ");
INSERT INTO luc_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ꞌDã ꞌbã ũngúkú gá, ĩꞌbã átẹ́pị Ịsịrayị́lị̃ jọ ĩꞌbaní, “Drĩ dó adru ꞌdĩ áni yã áni, lẽ ĩꞌdụ ĩmidrị́ bẹ́gị̃ rĩ kí agá ãko ũniyambamba ãngũ ꞌdĩ drị̂ kí ãmbógó ní ĩndĩ; ãdu ngụ̃lépi vĩrĩ rĩ, ãnụ́ úsã, lũbánĩ ngụ̃lépi vĩrĩ rĩ, ife ífí kí ãzíla ife umvelé ãlĩmóndĩ rú rĩ ꞌbã ífí kí abe. ");
INSERT INTO luc_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ĩꞌdụ vâ séndẽ ĩmi drị́ gá pâlékó ị̃rị̃ sĩ ĩndĩ ãꞌdusĩku lẽ ĩmi uja séndẽ ándrá ũꞌbãlé ĩmidrị́ gụ̃tị́yã kí agá rĩ kí vúlé. ");
INSERT INTO luc_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ĩꞌdụ ĩmi ádrị́pị ꞌi, ĩgõ dó sĩ ĩꞌdi trũ vúlé ágọ́bị̂ rụ̂lé. ");
INSERT INTO luc_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ãdróŋá Ũkpó ꞌDị́pị ꞌbã fẽ ásị́ ị̃gbẹ̃ ágọ́bị́ ꞌdã ꞌbã ásị́ gá ĩꞌdiní sĩ Bénzãmĩnĩ kí ãfẽjó ĩmidrị́ ĩmi ádrị́pị̃ ãzí lé ꞌdã be ĩndĩ. Wó drĩ dó vâ adru mání sĩ anzị mádrị̂ kí ãvĩjó pírí yã áni, lẽ ꞌbã adru dó ꞌdã ꞌbã áni.” ");
INSERT INTO luc_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ị́jọ́ ꞌdĩ sĩ, ꞌbá ꞌdĩ ꞌdụ kí dó ãko ãzí fẽtáŋá ru la kí kí drị́ gá ĩndĩ ãzíla séndẽ pâlékó ị̃rị̃ sĩ rĩ abe trũ mụjó Mị̃sị́rị̃ gâlé Bénzãmĩnĩ trũ, ãzíla iꞌda kí dó sĩ ru Yụ̃sụ́fụ̃ drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yụ̃sụ́fụ̃ la mụ Bénzãmĩnĩ ndrelé ĩꞌba abe ꞌbo, jọ ãtíꞌbó ĩꞌdidrị́ jó agá ꞌdãá ãmbógó ru rĩ ní, “Mí agụ ꞌbá ꞌdĩ kí mádrị́ jó agâlé, ílị ãnãkpá ãzí ãzíla mí aꞌdí ĩꞌdi ãma dó sĩ mụ íná sáwã ázíyá drị̂ nalé ĩꞌba abe.” ");
INSERT INTO luc_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ãtíꞌbó ꞌdã idé cécé tá Yụ̃sụ́fụ̃ ꞌbã lũlé ĩꞌdiní rĩ áni, ꞌdụ dó ꞌbá ꞌdĩ kí agụlé ĩꞌdidrị́ jó agâlé. ");
INSERT INTO luc_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Yụ̃sụ́fụ̃ ꞌbã ádrị́pịka ri kí idélé ụ̃rị̃ sĩ ála kí agụjó jó agâlé ꞌdĩ gá ꞌdâ. Ũrã kí, “Âjí ãma ꞌdõlé la séndẽ ándrá ujalé ãmadrị́ gụ̃tị́yã kí agá ĩndĩ ụ́ꞌdụ́ drị̃drị̃ ꞌdã drị̂ sĩ rĩ kí ị́jọ́ sĩ. Kí dó úꞌdîꞌda ãma tị ce, kí ãma kãyĩnõ kí upa rá ãzíla kí ãma ꞌbã acálé ĩꞌbã ãtiꞌbo rú.” ");
INSERT INTO luc_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Yụ̃sụ́fụ̃ ꞌbã ádrị́pịka kí mụ calé ĩꞌdidrị́ko gâlé ꞌbo, jọ kí ãtíꞌbó ãmbógó ru rĩ ní jó tị gá ꞌdãá, ");
INSERT INTO luc_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ãmbógó, ụ́ꞌdụ́ drị̃drị̃ ꞌdã sĩ ãma amụ́ ãkónã ĩgbãlé Mị̃sị́rị̃ gá ꞌdâ. ");
INSERT INTO luc_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ãma mụ calé ãngũ ãmaní sĩ ụ́ꞌdụ́ kojó gẹ̃rị̃ gá rĩ gá, ãnzị̃ dó gụ̃tị́yã ãmadrị̂ kí tị wó ꞌbá ãlu-ãlu ịsụ́ ĩꞌdi ꞌbã séndẽ gụ̃tị́yã agá ꞌdãá ũgũgõ ãnị̃ ãꞌdi ũꞌbã séndẽ ꞌdĩ kí ãmadrị́ gụ̃tị́yã kí agâlé nĩ yã rĩ gá ku. Ị́jọ́ ꞌdĩ sĩ ãma uja kí vúlé ꞌdõlé ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ãma ají vâ séndẽ ãzí kí sĩ ãkónã ĩgbãjó ĩndĩ. Ãnị̃ ãꞌdi ũꞌbã séndẽ ꞌdĩ kí ãmadrị́ gụ̃tị́yã kí agâlé vúlé nĩ yã rĩ gá ku.” ");
INSERT INTO luc_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ãtíꞌbô jọ, “Ásị́ ị̃gbẹ̃ ꞌbã adru ĩmi abe. Ĩmi idé ụ̃rị̃ sĩ ku. Ãdróŋá ĩmidrị́ ĩmi átẹ́pị drị̂ ꞌbã séndẽ ꞌdĩ kí ĩminí gụ̃tị́yã agâlé nĩ. Má ịsụ́ ándrá séndẽ ĩmidrị́ ĩminí sĩ ãkónã ĩgbãjó rĩ kí rá.” ꞌDã ꞌbã ũngúkú gá, âjí dó Sị̃mọ́nị̃ ĩꞌba rụ́ ꞌdõlé. ");
INSERT INTO luc_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ãtíꞌbó ꞌdĩ agụ dó ꞌbá ꞌdĩ kí Yụ̃sụ́fụ̃ drị́ jó agâlé, fẽ ĩꞌbaní ị̃yị́ sĩ pá ũjĩjó ãzíla fẽ ĩrí kãyĩnõ ĩꞌbadrị̂ ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Itú kí ĩꞌbã fẽtáŋá kí bábá fẽlé Yụ̃sụ́fụ̃ ní sáwã ĩꞌdiní acájó rĩ sĩ, ãꞌdusĩku úlũ ĩꞌbaní kí amụ́ íná sáwã ázíyá drị̂ nalé ĩꞌdi trũ ãngũ ãlu gá rĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yụ̃sụ́fụ̃ la mụ acálé lị́cọ́ gá ꞌbo, ꞌdụ kí dó ĩꞌbã fẽtáŋá kí kí drị́ gá ĩndĩ trũ mụjó ĩꞌdi rụ́ jó agâlé ãzíla ãvụ̃ kí dó vụ̃rụ́ ĩꞌdi drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yụ̃sụ́fụ̃ zị kí sĩ ị́jọ́ kí lé íngoní yã rĩ nị̃jó ãzíla jọ, “Ĩmi átẹ́pị ãmbá ru ándrá ĩminí mání ị́jọ́ jọjó drị̃ la gá rĩ múké yã? Ĩꞌdi drị̃ kị́rị́ ídri yã?” ");
INSERT INTO luc_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Umvi kí, “Ãtíꞌbó mídrị́ ãma átẹ́pị drĩ ídri ãzíla ĩꞌdi múké.” Ãvụ̃ kí Yụ̃sụ́fụ̃ drị̃lẹ́ gá vụ̃rụ́ sĩ ĩꞌdiní ị̃nzị̃táŋá fẽjó. ");
INSERT INTO luc_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yụ̃sụ́fụ̃ undré ãngũ ãzíla ndre ádrị́pị̃ Bénzãmĩnĩ kí sĩ adrujó ĩꞌdi be andre gá ãlu rĩ ꞌi zị, “ꞌdĩ dó ĩmi ádrị́pị vúléŋá ándrá ĩminí jọlé mání rĩ ꞌi yã?” Jọ, “Mâ ngọ́tị̂, ásị́ ị̃gbẹ̃ Ãdróŋá drị̂ ꞌbã ri ími drị̃ gá.” ");
INSERT INTO luc_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yụ̃sụ́fụ̃ la mụ ádrị́pị̃ Bénzãmĩnĩ ndrelé ꞌbo, ásị́ la lẽ dó kpẹ̃lé kpẹ̃kpẹ̃, afụ dó ru fũlé ãmvé ãzíla mụ dó ãngũ ndrụ̃ trũ sĩ awájó. Fi rụ́mụ̃ ãzí agá ãzíla awá dó mị́ndrẹ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ĩꞌdi mụ ru mẹ́lẹ́tị mị́ndrẹ rú rĩ ũjĩlé ꞌbo, ãfũ ãmvé ĩꞌba rụ́ ꞌdõlé, ãzíla imbá ru ásị́ ũkpó ru, jọ ãtíꞌbô ní, “Mí ají dó ãmaní íná nalé.” ");
INSERT INTO luc_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Úfẽ Yụ̃sụ́fụ̃ ní íná méjã ĩꞌdidrị̂ drị̃ gá ãzíla ádrị́pịka ꞌbaní méjã ãzí rĩ drị̃ gá. ꞌBá Mị̃sị́rị̃ rú íná ꞌdã nalépi ĩndĩ rĩ ꞌbaní úfẽ íná nalé áꞌdụ̂sĩ ãꞌdusĩku ĩꞌdi ị́jọ́ ãzí ũnzí la ꞌbá Mị̃sị́rị̃ rú rĩ ꞌbaní íná najó ꞌbá Ĩbũrãníyã rú rĩ abe ãngũ ãlu gá. ");
INSERT INTO luc_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Îri Yụ̃sụ́fụ̃ ꞌbã ádrị́pịka kí méjã ĩꞌbadrị̂ tị gá ílí ĩꞌbadrị̂ kí vú sĩ ãzíla ja kí tị ĩꞌdi rụ̂lé ru iꞌdójó kãjãní rĩ sĩ kpere vúléŋá rĩ rụ́. Kí mụ ndrelé la îri kí ꞌdĩ ꞌbã áni, ụ̃sụ̃ kí ụ̃sụ̃-ụ̃sụ̃ ãzíla undré kí dó ru mịfị́ gá mịfị́ gá. ");
INSERT INTO luc_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Úfẽ Bénzãmĩnĩ ní íná ãmbógó ru ãndânĩ ndẽ ádrị́pịka ꞌbadrị̂ kí pâlé tõwú sĩ. Na kí dó ãkónã ãzíla mvụ kí wáyĩnĩ kpere ĩꞌbã kí aga agá. ");
INSERT INTO luc_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yụ̃sụ́fụ̃ fẽ ãzị́táŋá ãtíꞌbó ãmbógó ru ĩꞌdidrị́ jó agá rĩ ní jọ, “Ítõ ãkónã gụ̃tị́yã ꞌbá ꞌdĩ ꞌbadrị̂ kí agá tré-tré úmgbó ĩꞌbã kí icólé ꞌdụlé rá rĩ sĩ, ãzíla íꞌbã séndẽ ꞌbá ãlu-ãlu drị̂ gụ̃tị́yã ĩꞌdidrị̂ agâlé vúlé. ");
INSERT INTO luc_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Íꞌbã kópõ mádrị́ sílĩvã rú rĩ ĩꞌbã ádrị́pị vúléŋá rĩ drị́ gụ̃tị́yã agá séndẽ ĩꞌdidrị̂ kí abe.” Ãtíꞌbô idé ị́jộ cécé Yụ̃sụ́fụ̃ ꞌbã jọlé ĩꞌdiní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ụ̃ꞌbụ́tịnị́nị́ úpẽ dó Yụ̃sụ́fụ̃ ꞌbã ádrị́pịka kí tị mụlé kãyĩnõ ĩꞌbadrị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Mụ kí drĩ táwụ̃nị̃ agá ꞌdãá rĩ sĩ álị́ ku rú, Yụ̃sụ́fụ̃ jọ ãtíꞌbó ĩꞌdidrị́ ãmbógó ru rĩ ní, “Ídro ꞌbá ꞌdĩ kí vú mbẽlẽ-mbẽlẽ. Ídrĩ kí arụ́ ꞌbo, ízị kí, ‘Ĩmi ũfẽ ị́jọ́ múké rĩ ị́jọ́ ũnzí sĩ la ãꞌdu ị́jọ́ sĩ yã? ");
INSERT INTO luc_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ĩmi ụ̃gụ̃ ãmbógó mádrị̂ ꞌbã kópõ rá ãꞌdu ị́jọ́ sĩ? Ĩꞌdi jõ sĩ ãko mvụ, ãzíla ĩꞌdi jõ vâ sĩ íngá ndrị. Ĩmi idé ị́jọ́ ũnzíkãnã la ꞌbo.’” ");
INSERT INTO luc_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ãtíꞌbô la mụ kí arụ́lé ꞌbo, amvi ị́jọ́ ꞌdĩ kí vúŋá ĩꞌbanî. ");
INSERT INTO luc_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Umvi kí ĩꞌdiní, “Ãmbógó ị́jọ́ míní jọlé ꞌdĩ ꞌbã ífí íngoní? Ãna ũyõ rú ị́jọ́ ãzí ãmaní idélé ꞌdĩ áni la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Índre drĩ ãma ají séndẽ ãmaní ịsụ́lé ãmadrị́ gụ̃tị́yã kí agá rĩ kí angájó Kãnánĩ gâlé vúlé ĩndĩ. Ãma icó dó sílĩvã jõku gólũdĩ ụ̃gụ̃lé ãmbógó mídrị̂ drị́ jó agâlé íngoní ru? ");
INSERT INTO luc_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Údrĩ ãma ãzí ịsụ́ kópõ ꞌdĩ trũ lẽ ꞌbã drã rá ãzíla ãma ị́mbị́ acelépi rĩ kí acá úpí ãmadrị̂ ꞌbã ãtiꞌbo rú.” ");
INSERT INTO luc_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Jọ, “Má ãꞌị̃ ị́jọ́ ꞌdĩ rá; wó ꞌbá kópõ lékõ ịsụ́jó ĩꞌdidrị́ rĩ la lú acá mâ ãtíꞌbó ru nĩ, ĩmi ị́mbị́ acelépi rĩ kí adru ị́jọ́ kóru.” ");
INSERT INTO luc_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ị́jọ́ ꞌdĩ sĩ, ayụ kí tẹ́rị́ ĩꞌbadrị̂ kí mbẽlẽŋá ru vụ̃rụ́, ãzíla ꞌbá ãlu-ãlu nzị̃ gụ̃tị́yã ĩꞌdidrị̂ ꞌbã tị. ");
INSERT INTO luc_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ãtíꞌbó Yụ̃sụ́fụ̃ drị̂ iꞌdó kópõ ndrụ̃lé jãjã rú iꞌdójó ꞌbá kãjãní rĩ drị̂ sĩ ãsị̃jó ꞌbá vúléŋá rĩ drị̂ gá, ịsụ́ kópõ gụ̃tị́yã Bénzãmĩnĩ drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ꞌBá ꞌdĩ asi kí dó bõngó kí ụrụꞌbá gá rĩ kí ũcõgõ sĩ rá, umbé kí ĩꞌbã tẹ́rị́ kí vúlé kãyĩnõ kí drị̃ gá ãzíla uja kí ru vúlé táwụ̃nị̃ ãmbógó rĩ gâlé. ");
INSERT INTO luc_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yụ́dã kí mụ acálé ádrị́pịka abe Yụ̃sụ́fụ̃ drị́ jó agá ꞌdãá ꞌbo, ịsụ́ ꞌdĩ sĩ ĩꞌdi drĩ jó agá ꞌdãá cí. ꞌBe kí ru vụ̃rụ́ ĩꞌdi drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yụ̃sụ́fụ̃ jọ, “Ị́jọ́ ĩminí idélé íni rĩ ãꞌdu? Ị̃nị̃ drĩ ꞌbá cécé má áni ꞌdĩ icó ũkpó Ãdróŋá drị̂ sĩ ị́jọ́ ĩminí idélé ũní rĩ kí nị̃lé cé rĩ gá ku yã?” ");
INSERT INTO luc_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yụ́dã umvi, “Úpí, ãma dó míní ãꞌdu ị́jọ́ jọ? Ãma dó ãgátã ga íngoní ru? Ãma icó dó ãma trũlé íngoní ru? Ãdróŋá iꞌda ị́jọ́ ũnzĩ ãtiꞌbo mídrị̂ ꞌbadrị̂ ꞌbo, ãma pírí dó mî ãtiꞌbo adru lú ꞌbá tá sĩ kópõ lékõ ịsụ́jó ĩꞌdidrị́ rĩ ꞌi áꞌdụ̂sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Wó Yụ̃sụ́fụ̃ jọ, “Adru ꞌdĩ áni ku! Má icó ị́jọ́ ꞌdĩ áni la idélé ku! ꞌBá tá kópõ ịsụ́jó ĩꞌdidrị́ rĩ la lú adru mâ ãtíꞌbó ru nĩ. Ĩmi ãzí acelépi rĩ icó kí gõlé ĩmĩ átẹ́pị rụ̂lé ásị́ ị̃gbẹ̃ sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yụ́dã mụ kpere Yụ̃sụ́fụ̃ rụ jọ, “ꞌBárĩ úpí, mí ãꞌị̃ mání ị́jọ́ jọjó mí be fô, Mí idé mání ũmbã sĩ ku, mi cécé Fãráwũ áni. ");
INSERT INTO luc_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Úpí mádrị̂, ízị ándrá ãma, ‘Ĩmĩ átẹ́pị cí yã jõku ĩmĩ ádrị́pị ãzí cí yã?’ ");
INSERT INTO luc_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ãma umvi ándrá ãmbógó mádrị̂ míní, ‘Ãmã átẹ́pị cí wó ĩꞌdi dó ĩdránígó ru ãzíla ãmã ádrị́pị vúléŋá ĩꞌdiní tịlé ịsụ́ ꞌdĩ sĩ ĩꞌdi dó ꞌbá ãmbá ru rĩ vâ cí. Mgbâ ꞌbã ádrị́pị drã rá, ĩꞌdi dó lú ngọ́tị́ŋá ãndrẽ agá ꞌdâ acelépi ídri rĩ ꞌi, átẹ́pị̃ lẽ dó sĩ ĩꞌdi ambamba.’ ");
INSERT INTO luc_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Ãmbógó, íjọ ándrá ãmaní ãma ají ĩꞌdi mí rụ́ ꞌdõlé ĩndĩ mi sĩ amụ́ ĩꞌdi ndrelé. ");
INSERT INTO luc_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Wó ãma umvi ándrá ãmbógó mádrị̂ míní mgbâ icó átẹ́pị̃ aꞌbelé ku; drĩ ĩꞌdi aꞌbe rá, átẹ́pị̃ la drã rá. ");
INSERT INTO luc_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ꞌDã ꞌbã vúlé gá íjọ ándrá ãmaní mí icó ãmaní ãꞌị̃lé amụ́lé ími drị̃lẹ́ gá ị̃dị́ ku ãdrĩ amụ́ ãmã ádrị́pị vúléŋá rĩ kó ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Ụ́ꞌdụ́ ãmaní gõjó ãmã átẹ́pị rụ̂lé rĩ sĩ, ãnze ĩꞌdiní ị́jọ́ míní jọlé ãmaní rĩ kí vú rá. ");
INSERT INTO luc_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“ꞌDã ꞌbã ũngúkú gá, ãma átẹ́pị jọ ãmaní, ‘Lẽ ĩgõ vúlêlé ãkónã ãzí ĩgbãlé were ị̃dị́.’ ");
INSERT INTO luc_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ãjọ ĩꞌdiní, ‘Ãma icó mụlé ku; ãma lú mụ rá la ãma ádrị́pị vúléŋá rĩ drĩ mụ ãma abe ĩndĩ rĩ gá. Ãma icó mụlé ĩꞌdi drị̃lẹ́ gá ku ãma ádrị́pị vúléŋá rĩ drĩ adru ãma abe yụ rĩ gá.’ ");
INSERT INTO luc_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ãmã átẹ́pị jọ ãmaní, ‘Ị̃nị̃ ị́jọ́ ꞌdĩ lọ́lọ́ ũkú mádrị́ Rãkẹ́lị̃ tị mání anzị ãgọbị kí lú ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ĩꞌbã ãzí ãlu rĩ drã rá. Ãndá-ãndá ru ụ̃bọ̃gụ̃ uce kí ĩꞌdi kpékpé rá ãꞌdusĩku ĩꞌdiní ándrá mụ agá kpere ãndrũ ándre dó ĩꞌdi ị̃dị́ ku. ");
INSERT INTO luc_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ĩdrĩ vâ úꞌdîꞌda mgbá ꞌdĩ ꞌdụ má rụ́ ꞌdâ rá ãzíla ị́jọ́ ãzí drĩ mụ ru idélé ĩꞌdi ụrụꞌbá gá rá, ị́jọ́ ĩminí ajílé áma drị̃ gá ꞌdĩ la áma ĩdrãnĩgõ fẽ filé ꞌbụ́ gâlé ũcõgõ trũ.’ ");
INSERT INTO luc_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Ãmbógó, má icó gõlé má átẹ́pị rụ̂lé mgbâ kóru ku, má átẹ́pị ídri rú la mgbá ꞌdĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Drĩ ndre la ãma amụ́ mgbâ kóru, ĩꞌdi drã rá. Ị́jọ́ ãmaní ajílé ĩꞌdi drị̃ gá ꞌdĩ la fẽ ĩꞌdiní filé ꞌbụ́ gâlé ũcõgõ trũ. ");
INSERT INTO luc_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ájọ ándrá mâ átẹ́pị ní ma mgbâ tãmba rá, ájọ vâ ĩꞌdiní ádrĩ mgbâ ají ĩꞌdi rụ́ ꞌdõlé ku, lẽ áwá dó ĩꞌdi ị́jọ́ áma ụrụꞌbá gá jãꞌdâ. ");
INSERT INTO luc_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ãmbógó, ị́jọ́ ꞌdĩ sĩ ma dó ace ꞌdâ míní ãtíꞌbó ru mgbâ ꞌbã kẹ̃jị́ gá; ífẽ dó sĩ ꞌbã gõ vúlé ádrị́pịka kí abe. ");
INSERT INTO luc_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Má icó dó gõlé má átẹ́pị rụ̂lé mgbâ kóru íngoní ru? Yụ! Má icó ũcõgõ mụlépi aꞌdélépi má átẹ́pị drị̃ gá rĩ ndrelé ku.” ");
INSERT INTO luc_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ꞌDã ꞌbã ũngúkú gá, Yụ̃sụ́fụ̃ icó dó ị́jọ́ ĩꞌdi ásị́ nũlépi rĩ talé ãtiꞌbo ĩꞌdidrị̂ kí drị̃ gâsĩ ku, ãzíla pẽ dó sĩ kí tị pírí fũlé ãmvé. Ị́jọ́ ꞌdĩ sĩ ace dó ru ádrị́pịka kí abe ádụ̂sĩ sáwã ĩꞌdiní ru vú nzejó ĩꞌbaní ꞌdã sĩ. ");
INSERT INTO luc_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Rĩ awálé ụ́ꞌdụ́kọ́ sĩ rere, ị́jọ́ ꞌdĩ sĩ ꞌbá Mị̃sị́rị̃ rú ꞌdĩ are kí ĩꞌdi ꞌbã áwáŋá rá, ãzíla ụ́ꞌdụ́kọ́ ꞌdĩ ca úpí Fãráwũ drị́ko gâlé rá. ");
INSERT INTO luc_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yụ̃sụ́fụ̃ jọ ádrị́pịka ꞌbaní, “Ma Yụ̃sụ́fụ̃ ꞌi! Má átẹ́pị drĩ ídri yã?” Wó ádrị́pịka icó kí ĩꞌdi umvilé ku, acá kí dó ụ̃rị̃ sĩ ĩꞌbaní adrujó Yụ̃sụ́fụ̃ ꞌbã drị̃lẹ́ gá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ꞌDã ꞌbã ũngúkú gá, Yụ̃sụ́fụ̃ jọ ádrị́pịka ꞌbaní, “Ĩmi asé drĩ ĩmi má rụ́ ꞌdõlé ãni rú.” Ị́jọ́ ꞌdĩ sĩ, asé kí dó ru ãni rú ĩꞌdi rụ́ ꞌdõlé. Jọ ĩꞌbaní, “Ma ĩmi ádrị́pị Yụ̃sụ́fụ̃ ándrá ĩminí ụzịlé ꞌbá Mị̃sị́rị̃ gá la ꞌbaní rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Lẽ ĩmi ásị́ ꞌbã umvú jõku ĩmi adru ũmbã sĩ ĩminí áma ụzịjó rá rĩ sĩ ku ãꞌdusĩku Ãdróŋá ãpẽ áma tị drị̃lẹ́ gá ꞌdõlé sĩ amụ́jó ꞌbá kí ídri upajó. ");
INSERT INTO luc_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Rílẽ iꞌdólépi ꞌdĩ ꞌdụ drĩ lú ílí kí ị̃rị̃; ílí ãzí ace kí drĩ ĩꞌdiní drị̃lẹ́ gâlé tõwú cí, ala gá ꞌbá icó kí ámvụ́ sõlé jõku ãkónã ũkũnãlé ku. ");
INSERT INTO luc_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Wó Ãdróŋá ãpẽ áma tị ĩmi drị̃lẹ́ gá ꞌdõlé sĩ ĩmi ị́mbị́ pajó anzị ĩmidrị̂ kí abe ụ̃nọ́kụ́ drị̃ gá ꞌdâ gẹ̃rị̃ ụ̃sụ̃táŋá ru ꞌdĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Ị́jọ́ ꞌdĩ sĩ adru ĩmi ãpẽ áma tị ꞌdõlé ĩmi ꞌi la ku wó Ãdróŋá ꞌi. Fẽ má acá úpí Fãráwũ ní ꞌbá ímbátáŋá fẽlépi rĩ rú. Ma ãmbógó ru ĩꞌdidrị́ ãngũ rĩ drị̃ gá ꞌdâ pírí; ma ãngũ Mị̃sị́rị̃ drị̂ drị̃ ce pírí ma ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Úꞌdîꞌda ĩgõ mâ átẹ́pị rụ̂lé mbẽlẽ rú, ĩjọ ĩꞌdiní, ‘ꞌDĩ ị́jọ́ mî ngọ́pị Yụ̃sụ́fụ̃ ꞌbã jọlé rĩ ꞌi: Ãdróŋá ꞌbã ma úpí ru ãngũ Mị̃sị́rị̃ drị̂ agá pírí. Mí amụ́ má rụ́ ꞌdõlé; mí iza sáwã ku. ");
INSERT INTO luc_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Mĩ mụ uꞌálé Gõsénĩ gá ãni rú áma andre gá, anzị mídrị̂ kí, anzịŋá anzị mídrị̂ ꞌbã kí tịlé rĩ kí, kãbĩlõ mídrị̂ kí ị̃ndrị́ kí abe, tị́ kí ãzíla ãko pírí míní trũ adrujó rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ídrĩ uꞌá ãngũ Gõsénĩ gá, ma ími tãmba rá. Ílí rílẽ drị̂ ace kí drĩ tõwú cí; álẽ mi ꞌi, ꞌbá mídrị̂ kí, ãzíla ãnãkpá mídrị̂ kí abe ꞌbã ũdrã kí sĩ ãbị́rị́ sĩ ku.’” ");
INSERT INTO luc_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yụ̃sụ́fụ̃ mụ ị́jọ́ jọŋá trũ drị̃ gá jọ, “Ĩmi pírí Bénzãmĩnĩ trũ, ĩndre dó ĩmi mịfị́ sĩ tọndọlọ ꞌdõ ma ꞌi Yụ̃sụ́fụ̃ ꞌi ị́jọ́ jọlépi ĩmi abe rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ĩlũ má átẹ́pị ní úfẽ mání ị̃nzị̃táŋá Mị̃sị́rị̃ gá ꞌdõlé íngõpí yã rĩ ꞌi ãzíla ĩmi ũlũ ĩꞌdiní ãko pírí ĩminí ndrelé ꞌdĩ kî. Ĩmụ, ĩmi ají ĩꞌdi má rụ́ ꞌdõlé mbẽlẽ rú.” ");
INSERT INTO luc_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ꞌDã ꞌbã ũngúkú gá, Yụ̃sụ́fụ̃ amvu dó ádrị́pị̃ Bénzãmĩnĩ kpãrã ãzíla iꞌdó dó awálé; Bénzãmĩnĩ ꞌbe vâ ru áwáŋá gá ĩndĩ ĩꞌbaní ru amvu agá ꞌdâ. ");
INSERT INTO luc_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ĩꞌdiní awá agá ꞌdĩ gá ꞌdâ, ri ádrị́pịka kí amvulé ãlu-ãlu ãzíla kí mị́ndrẹ la dị̃ ra sĩ. ꞌDã ꞌbã vúlé gá, ádrị́pịka iꞌdó kí dó ị́jọ́ jọlé ĩꞌdi be. ");
INSERT INTO luc_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ụ́ꞌdụ́kọ́ ꞌdĩ la mụ calé úpí Fãráwũ drị́ lị́cọ́ gâlé Yụ̃sụ́fụ̃ ꞌbã ádrị́pịka amụ́ kí nĩ, Fãráwũ kí ãmbogo ĩꞌdidrị́ ãzí ꞌdĩ abe uꞌá kí pírí ãyĩkõ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Fãráwũ jọ Yụ̃sụ́fụ̃ ní, “Íjọ mí ádrị́pịka ꞌbaní, ‘Ĩmi ũꞌbã tẹ́rị́ kí kãyĩnõ kí drị̃ gá, ĩgõ trũ Kãnánĩ gá, ");
INSERT INTO luc_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ãzíla ĩmi ají ĩmi átẹ́pị̃ ꞌi ꞌbá ĩmi drị́ko gá rĩ kí abe vúlé má rụ́ ꞌdõlé. Ma ĩminí ãngũ Mị̃sị́rị̃ gá ꞌdâ ũniyambamba ãndânĩ rĩ fẽ, ãzíla ĩmi dó sĩ ãyĩkõ ãngũ ꞌdĩ drị̂ ịsụ́.’ ");
INSERT INTO luc_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Jọ vâ Yụ̃sụ́fụ̃ ní ílũ ĩꞌbaní, ‘Ĩꞌdụ gãlĩgãlĩ kí Mị̃sị́rị̃ gá ꞌdâ sĩ mụjó ĩmi ũkúka kí ajíjó anzị kí abe ãzíla ĩmi ají ĩmi átẹ́pị ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ĩmi idé ụ̃rị̃ sĩ ãko ĩmidrị̂ kí aꞌbejó vúlé rĩ sĩ ku; ãko ũniyambamba ãngũ Mị̃sị́rị̃ gá ꞌdâ ꞌdĩ kí adru pírí ĩmĩ ãni.’” ");
INSERT INTO luc_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Anzị Ịsịrayị́lị̃ drị̂ idé kí cécé jọlé ĩꞌbaní rĩ áni. Yụ̃sụ́fụ̃ fẽ ĩꞌbaní gãlĩgãlĩ kí tá úpí Fãráwũ ꞌbã jọlé ĩꞌdiní rĩ áni, fẽ vâ ĩꞌbaní ãkónã gẹ̃rị̃ drị̂ kí ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Fẽ vâ ꞌbá ãlu-ãlu ní bõngó sĩ bõngó ujajó gẹ̃rị̃ gá ꞌdâ ĩndĩ, wó fẽ Bénzãmĩnĩ ní séndẽ 300 ãzíla bõngó sĩ bõngó ujajó gẹ̃rị̃ gá la kí tõwú. ");
INSERT INTO luc_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ũdrõ átẹ́pị̃ ní ãko ũniyambamba Mị̃sị́rị̃ gá rĩ kí kãyĩnõ mụdrị́ kí drị̃ gá ãzíla kãyĩnõ ãrónĩ mụdrị́ rĩ kí drị̃ gá ũdrõ ãná, mũkátĩ ãzíla ãko ãkónã rú Yãkóꞌbõ ní nalé ãcị̃ gá rĩ kí trũ. ");
INSERT INTO luc_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Pẽ dó ádrị́pịka kí tị sĩ mụjó, ĩꞌbaní drị̃ ko agá ꞌdâ jọ, “Ĩmi ãwã jõ gẹ̃rị̃ gá ꞌdâ ku.” ");
INSERT INTO luc_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ị́jọ́ ꞌdĩ sĩ aꞌbe kí Mị̃sị́rị̃ ꞌi ãzíla gõ kí dó vúlé lị́cọ́ gá átẹ́pị̃ Yãkóꞌbõ rụ́ Kãnánĩ gâlé. ");
INSERT INTO luc_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Jọ kí ĩꞌdiní, “Yụ̃sụ́fụ̃ drĩ kpere ídri! Ĩꞌdi úꞌdîꞌda ãmbógó Mị̃sị́rị̃ drị̃lẹ́ gá rĩ ꞌi.” Yãkóꞌbõ ꞌbã ásị́ mvu rá ãzíla ãꞌị̃ ị́jọ́ ĩꞌba kí jọlé rĩ ku. ");
INSERT INTO luc_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Wó kí mụ ị́jọ́ Yụ̃sụ́fụ̃ ꞌbã jọlé ĩꞌdiní ꞌdĩ kí vú nzelé pírí ꞌbo, ãzíla ĩꞌdi mụ gãlĩgãlĩ Yụ̃sụ́fụ̃ ꞌbã ãfẽlé sĩ ĩꞌdi ꞌdụjó agụjó Mị̃sị́rị̃ gá rĩ kí ndrelé ꞌbo, ásị́ la ãgõ ĩꞌdi rụ́ ꞌdõlé rõ vúlé. ");
INSERT INTO luc_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ịsịrayị́lị̃ jọ, “Má ãꞌị̃ rá, mâ ngọ́pị Yụ̃sụ́fụ̃ drĩ ídri! Lẽ ámụ ĩꞌdi ndrelé ꞌdĩ sĩ ádrã drĩ ku rú.” ");
INSERT INTO luc_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yãkóꞌbõ ko dó drị̃ mụlé Mị̃sị́rị̃ gá ãko ĩꞌdidrị̂ kí abe pírí. Ĩꞌdi mụ calé Bẹ̃rị̃sẹ́bã gá ꞌbo, idé ídétáŋá Ãdróŋá ĩꞌdi ꞌbã átẹ́pị̃ Ĩsákã drị̂ nî. ");
INSERT INTO luc_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ị́nị́ ágágá Ãdróŋá jọ ị́jọ́ ĩꞌdiní urobí agâ sĩ umve ĩꞌdi, “Yãkóꞌbõ, Yãkóꞌbõ!” Yãkóꞌbõ ãꞌị̃, “Ma cí.” ");
INSERT INTO luc_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ãdróŋá jọ ĩꞌdiní, “Ma Ãdróŋá mí átẹ́pị Ĩsákã drị̂ ꞌi. Mí idé ụ̃rị̃ sĩ mụjó ándrá Mị̃sị́rị̃ gâlé ku, ãꞌdusĩku ma ími fẽ acálé sụ́rụ́ ãmbógó la rú. ");
INSERT INTO luc_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ma mụ Mị̃sị́rị̃ gâlé mi be, ãzíla ma ãndá-ãndá ru anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí uja vúlé ꞌdõlé rá, ãzíla sáwã míní drãjó rĩ sĩ Yụ̃sụ́fụ̃ la drụ́zị́ ími mịfị́ kí ụ̃pị̃ nĩ.” ");
INSERT INTO luc_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ꞌDã ꞌbã ũngúkú gá, Yãkóꞌbõ aꞌbe dó Bẹ̃rị̃sẹ́bã ꞌi ãzíla anzị ĩꞌdidrị̂ agụ kí dó ĩꞌdi, ꞌdụ kí dó anzị ĩꞌbadrị̂ kí ũkúka kí abe gãlĩgãlĩ Fãráwũ ꞌbã ãfẽlé sĩ kí agụjó rĩ kî sĩ. ");
INSERT INTO luc_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Yãkóꞌbõ kí anzị ĩꞌdidrị̂ kí abe pírí ꞌdụ kí ĩꞌbã ãnãkpá kí ãko ĩꞌbã kí ịsụ́lé ãngũ Kãnánĩ drị̂ gá ꞌdãá rĩ kî trũ sĩ mụjó Mị̃sị́rị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yãkóꞌbõ ꞌdụ anzị ĩꞌdidrị̂ kí, anzị ĩꞌdidrị̂ ꞌbã izonziŋá kí ngọ́pịka ĩꞌdi umvelépi áyị́pị rĩ kí abe mụ dô sĩ ꞌbá ĩꞌdidrị̂ kí trũ pírí Mị̃sị́rị̃ gâlé. ");
INSERT INTO luc_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ꞌDĩ kî dó rụ́ anzị Yãkóꞌbõ drị́ Ịsịrayị́lị̃ ꞌbã ũri rú mụlépi ĩꞌdi be Mị̃sị́rị̃ gá rĩ kî: Ngọ́tị́ŋá ĩꞌdidrị́ kãjãní rĩ ĩꞌdi Rụ́bẹ̃nị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Anzị Rụ́bẹ̃nị̃ drị̂ kí rụ́: Hãnókĩ ꞌi, Pálụ̃ ꞌi, Hẽzĩrónĩ ꞌi ãzíla Kãrị́mị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Anzị Sị̃mọ́nị̃ drị̂ kí rụ́: Yẹ̃mụ̃wẹ́lị̃ ꞌi, Yãmínĩ ꞌi, Ũhádĩ ꞌi, Yãkínĩ ꞌi, Zõhárĩ ꞌi ãzíla Sáwụ̃lụ̃ andre la ꞌbã sĩ adrujó Kãnánĩ ízó rú rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Anzị Lẹ́vị̃ drị̂ kí rụ́: Gị́rị́sọ̃nị̃ ꞌi, Kõhátĩ ꞌi ãzíla Mẽrárĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Anzị Yụ́dã drị̂ kí rụ́: Ị́rị̃ ꞌi, Ũnánĩ ꞌi, Sélã ꞌi, Pẹ̃rẹ́zị̃ ꞌi ãzíla Zérã ꞌi, (wó Ị́rị̃ kí Ũnánĩ be ũdrã kí Kãnánĩ gâlé). Anzị Pẹ̃rẹ́zị̃ drị̂ kí: Hẽzĩrónĩ kí Hãmụ́lị̃ be. ");
INSERT INTO luc_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Anzị Ĩsãkárĩ drị̂ kí rụ́: Tólã ꞌi, Pụ́vã ꞌi, Yãsụ́bụ̃ ꞌi ãzíla Sị̃mị̃rọ́nị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Anzị Zãbụ̃lọ́nị̃ drị̂ kí rụ́: Sẹ̃rẹ́dị̃ ꞌi, Ị̃lọ́nị̃ ꞌi ãzíla Yãlẹ́lị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ꞌDĩ kí anzị Léyã ꞌbã tịlé Yãkóꞌbõ ní Mẽsõpõtámĩyã gá rĩ kî; ĩzóŋá la ala gá rĩ Dị́nã ꞌi, kí pírí rĩ gá kãlị́ na drị̃ na. ");
INSERT INTO luc_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Anzị Gádĩ drị̂ kí rụ́: Zị̃fụ̃yọ́nị̃ ꞌi, Hágĩ ꞌi, Sụ́nị̃ ꞌi, Ị̃zị̃bọ́nị̃ ꞌi, Ị́rị̃ ꞌi, Hãrọ́dị̃ ꞌi ãzíla Ãrẹ́lị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Anzị Ásẹ̃rị̃ drị̂ kí rụ́: Ímũnã ꞌi, Ị̃sị́vã ꞌi, Ị̃sị́vị̃ ꞌi, Bẽríyã ꞌi ãzíla ámvọ́pị ĩꞌbadrị̂ Sérã ꞌi. Anzị Bẽríyã drị̂ kí: Hẹ̃bẹ́rị̃ kí Mãlị̃kẹ́lị̃ be. ");
INSERT INTO luc_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ꞌDĩ kí anzị Zị̃lị́pã ándrá Lábãnĩ ꞌbã fẽlé Léyã be rĩ ꞌbã tịlé Yãkóꞌbõ ní rĩ kî. Anzị ĩꞌdidrị̂ kí pírí rĩ gá mụdrị́ drị̃ la ázíyá. ");
INSERT INTO luc_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Anzị Yãkóꞌbõ ꞌbã ũkú Rãkẹ́lị̃ drị̂ kí: Yụ̃sụ́fụ̃ kí Bénzãmĩnĩ be. ");
INSERT INTO luc_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Mị̃sị́rị̃ gâlé Ãsĩnátã Pọ̃tị̃fẹ́rã átáló uwiŋá uwilépi Hẹ̃lị̃pọ́lị̃ gá rĩ ꞌbã ị̃zẹ́pị tị Yụ̃sụ́fụ̃ ní Mãnásẽ kí Ịfụrayị́mụ̃ be. ");
INSERT INTO luc_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Anzị Bénzãmĩnĩ drị̂ kí rụ́: Bélã ꞌi, Bẽkérĩ ꞌi, Ãsị̃bẹ́lị̃ ꞌi, Gérã ꞌi, Nãmánĩ ꞌi, Íhĩ ꞌi, Rọ́sị̃ ꞌi, Mũpímũ ꞌi, Hụ̃pị́mụ̃ ꞌi ãzíla Árị̃dị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Anzị Rãkẹ́lị̃ ꞌbã tịlé Yãkóꞌbõ ní rĩ kí pírí rĩ gá mụdrị́ drị̃ la sụ. ");
INSERT INTO luc_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ngọ́tị́ŋá Dánĩ drị̂ rụ́: Hũsímũ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Anzị Nãfũtálĩ drị̂ kí rụ́: Yãzẹ́lị̃ ꞌi, Gụ́nị̃ ꞌi, Yẹ̃zẹ́rị̃ ꞌi ãzíla Sĩlémũ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bílĩhã ãtíꞌbó Lábãnĩ ꞌbã fẽlé ị̃zẹ́pị̃ Rãkẹ́lị̃ ní rĩ tị Yãkóꞌbõ ní anzị kí pírí rĩ gá ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Anzị mụlépi Mị̃sị́rị̃ gá ãfũlépi Yãkóꞌbõ ꞌbã ụrụꞌbá gá rĩ kí pírí rĩ gá kãlị́ ázíyá drị̃ la ázíyá. Úlã ngọ́pịka ꞌbã ũkúka kí gẹ̃rị̃ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yụ̃sụ́fụ̃ tị vâ anzị kí Mị̃sị́rị̃ gâlé ị̃rị̃; ꞌbá Yãkóꞌbõ drị́ko gá Mị̃sị́rị̃ gâlé rĩ kí pírí rĩ gá kãlị́ ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yãkóꞌbõ pẽ dó ngọ́pị̃ Yụ́dã tị Yụ̃sụ́fụ̃ rụ́ drị̃ gâlé sĩ mụjó gẹ̃rị̃ mụlépi Gõsénĩ gá rĩ zịjó. Kí dó mụ calé Gõsénĩ gâlé pírí ꞌbo, ");
INSERT INTO luc_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yụ̃sụ́fụ̃ itú gãlĩgãlĩ ĩꞌdidrị̂ kí bábá mụ dó sĩ drị̃ ụfụlé átẹ́pị̃ be Gõsénĩ gá. Yụ̃sụ́fụ̃ la mụ ru iꞌdalé ĩꞌdi drị̃lẹ́ gá ꞌbo, amvu dó átẹ́pị̃ gbũrúkã gá kpãrã ãzíla awá dó sĩ ãyĩkõ sĩ sáwã ãzo rú. ");
INSERT INTO luc_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yãkóꞌbõ jọ dó ngọ́pị̃ Yụ̃sụ́fụ̃ ní, “Ma dó bábá drãjó ãꞌdusĩku ándre dó mi drĩ ídri rĩ gá ꞌbo.” ");
INSERT INTO luc_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ꞌDã ꞌbã ũngúkú gá, Yụ̃sụ́fụ̃ jọ dó ádrị́pịka ꞌbaní ꞌbá átẹ́pị̃ drị́ko gá rĩ abe, “Ma dó mụ jọlé la Fãráwũ ní, ‘Má ádrị́pịka kí ꞌbá má átẹ́pị drị́ko gá rĩ kí abe, ãzíla ãko pírí ĩꞌbadrị̂ kî trũ iyá kí má rụ́ ꞌdõlé ꞌbo angájó Kãnánĩ gâlé. ");
INSERT INTO luc_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ꞌBá mádrị́ ꞌda kí ꞌbá ãnãkpá tãmbalépi la, ají kí ãnãkpá ĩꞌbadrị̂ kí ãzíla ãko pírí ĩꞌbadrị̂ kí ĩndĩ.’ ");
INSERT INTO luc_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Fãráwũ drĩ ĩmi umve jó agâlé, drĩ zị la, ‘Ãzị́ ĩmidrị̂ ãꞌdu yã?’ ");
INSERT INTO luc_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Ĩmi umvi ĩꞌdiní, ‘Ãma ꞌbá ãnãkpá tãmbalépi la iꞌdójó ãnzị̃rị̃ŋã sĩ ándrá ãmã átẹ́pịka ꞌbadrị̂ áni.’ Ĩdrĩ jọ la íni, ĩꞌdi ãꞌị̃ ĩminí uꞌájó ãngũ Gõsénĩ gá rá, ãꞌdusĩku ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbã kí ꞌbá ãnãkpá tãmbalépi rĩ kí ngụ̃jó ũnzí rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yụ̃sụ́fụ̃ mụ dó Fãráwũ rụ̂lé jọ ĩꞌdiní, “Má átẹ́pị amụ́ kí mâ ádrị́pịka kí abe ãzíla ãnãkpá ĩꞌbadrị́ tị́, kãbĩlõ, ị̃ndrị́ ãzíla ãko ĩꞌbadrị̂ kí trũ pírí angájó Kãnánĩ gâlé rĩ sĩ ãzíla kí dó úꞌdîꞌda íni Gõsénĩ gá ꞌdã.” ");
INSERT INTO luc_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ũpẽ dó ádrị́pịka kí tõwú ãzíla iꞌda dó kí Fãráwũ nî. ");
INSERT INTO luc_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Fãráwũ zị ádrị́pịka kí, “Ĩmi ãꞌdu ãzị́ nga yã?” Ádrị́pịka umvi kí, “Ãtiꞌbo mídrị̂ kí ꞌbá kãbĩlõ ucélépi la, ãmã áyị́pịka kî áni.” ");
INSERT INTO luc_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Jọ kí vâ Fãráwũ ní, “Ãma amụ́ uꞌálé Mị̃sị́rị̃ gá ꞌdõlé íni la ĩrí ꞌbã cajó ãnãkpá ãmadrị̂ ꞌbaní ku rĩ sĩ, ãzíla rílẽ ꞌdĩ mịfị́ ká dó ãngũ Kãnánĩ drị̂ gâlé ũnzí; ị́jọ́ ꞌdĩ sĩ ãma mãmálá ꞌbã ími drị̃lẹ́ gá, ífẽ ãma uꞌá ãmaní Gõsénĩ gá ꞌdãá fô.” ");
INSERT INTO luc_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Fãráwũ jọ Yụ̃sụ́fụ̃ ní, “Mí átẹ́pị kí mí ádrị́pịka abe amụ́ kí mí rụ́, ");
INSERT INTO luc_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ãzíla ãngũ Mị̃sị́rị̃ drị́ ꞌdĩ pírí ĩmi drị́lẹ́ agá. Ífẽ mí ádrị́pịka ꞌbã ri kí ãngũ ũniyambamba Gõsénĩ drị́ ꞌdã gá ꞌdãá ãzíla ꞌbá ãzí kí agá ꞌdãá ãlịgọ rú la drĩ kí adru cí, íꞌbã kí drị̃lẹ́ ru ãnãkpá mádrị̂ kí tã mbajó.” ");
INSERT INTO luc_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ꞌDã ꞌbã ũngúkú gá, Yụ̃sụ́fụ̃ ají dó átẹ́pị̃ Yãkóꞌbõ ꞌi iꞌdalé Fãráwũ nî ãzíla Yãkóꞌbõ wi Fãráwũ ní sụ̃sụ́. ");
INSERT INTO luc_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Fãráwũ zị Yãkóꞌbõ ꞌi, “Ími ílí dó sị́ yã?” ");
INSERT INTO luc_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yãkóꞌbõ umvi ĩꞌdiní, “Áma ílí mání sĩ wãyá cojó ãmị́yọ́ŋá ru ụ̃nọ́kụ́ gá ꞌdâ rĩ ca dó 130. Ílí ꞌdĩ kí ãlị́ŋá ru ãzíla ri kí adrulé ũcõgõ rú, ají kí ru ándrá má átẹ́pịka ꞌbadrị̂ abe ku.” ");
INSERT INTO luc_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yãkóꞌbõ wi dó sụ̃sụ́ Fãráwũ ní ị̃dị́ ãzíla aꞌbe dó ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ꞌDã ꞌbã ũngúkú gá, Yụ̃sụ́fụ̃ fẽ ádrị́pịka ꞌbaní rilé átẹ́pị̃ trũ ãngũ ũniyambamba Mị̃sị́rị̃ drị̂ gá ꞌdĩ Rãmãsẹ́sị̃ gá cécé Fãráwũ ꞌbã lũlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yụ̃sụ́fụ̃ fẽ dó ãkónã átẹ́pị̃ ꞌbaní ádrị́pịka kí abe ãzíla ꞌbá pírí átẹ́pị̃ drị́ko gá rĩ ꞌbaní icólépi calépi kãlãfe ĩꞌbadrị̂ sĩ rá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Rílẽ ꞌdã ꞌbã mịfị́ ꞌbãngá ika, ãkónã dó sĩ ãngũ pírí kí agá ꞌdáyụ, Mị̃sị́rị̃ kí Kãnánĩ be ị̃rị̃ trá iza kí ru rílẽ ꞌdã ị́jọ́ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yụ̃sụ́fụ̃ tra dó séndẽ ꞌbá Mị̃sị́rị̃ gá ãzíla Kãnánĩ gá rĩ ꞌbã kí sĩ ãkónã ĩgbãjó rĩ kí pírí, agụ dó kí tã mbalé Fãráwũ drị́ lómúre agá. ");
INSERT INTO luc_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Séndẽ ꞌbá Mị̃sị́rị̃ gá ãzíla Kãnánĩ gá rĩ ꞌbadrị̂ kí mụ ukólé kpírĩ-kpírĩ ꞌbo, amụ́ kí áwáŋâ trũ Yụ̃sụ́fụ̃ rụ́, jọ kí, “Séndẽ ãmadrị̂ ukó kí rá, ãma icó dó ũdrãlé ími drị̃ gâsĩ íngoní ru yã? Ífẽ ãmaní ãkónã.” ");
INSERT INTO luc_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yụ̃sụ́fụ̃ umvi ĩꞌbaní, “Úꞌdîꞌda séndẽ ĩmidrị̂ ukó kí dó rá ꞌbo, ĩmi ají dó ãnãkpá ĩmidrị̂ kí, ma dó sĩ kí ufu ĩminí ãkónã sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ị́jọ́ ꞌdĩ sĩ ají kí dó ãnãkpá ĩꞌbadrị̂ kí fãrásĩ, kãbĩlõ, ị̃ndrị́, tị́ ãzíla kãyĩnõ kî trũ Yụ̃sụ́fụ̃ drị́ sĩ ãkónã ụfụjó. Ri kí ãnãkpá kí ufulé ãkónã sĩ ílí ꞌdã agá pírí. ");
INSERT INTO luc_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ílí ꞌdã la mụ ukólé ꞌbo, amụ́ kí vâ ĩꞌdi rụ́ ꞌdõlé jọ kí, “Ãma icó ị́jọ́ ãzí zị̃lé úpí ãmadrị̂ ní ku, mgbã rĩ gá séndẽ ãmadrị̂ ukó kí dó rá ãzíla ãma ãnãkpá ãmadrị̂ kí abe pírí mî ãni, ãko ãzí dó ru acelépi ãluŋá la dó ꞌdáyụ dó lú ãma ụrụꞌbá kí ãngũ ãmadrị̂ abe. ");
INSERT INTO luc_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ãma dó ũdrã ími drị̃ gâsĩ mịfị́ trũ tẽrẽ íngoní ru yã? Mí ĩgbã ãma ãngũ ãmadrị̂ kí abe pírí ãma dó sĩ ãmaní ãkónã ịsụ́ ãzíla ãma dó sĩ acá ãtiꞌbo Fãráwũ ãni la rú. Ífẽ ãmaní ãkónã sĩ ãma ídri pajó ãzíla ũri kí salé ámvụ́ ãmadrị̂ kí agá ãngũ ꞌbã acá rû sĩ ándrú ru ku.” ");
INSERT INTO luc_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ị́jọ́ ꞌdĩ sĩ Yụ̃sụ́fụ̃ ĩgbã dó ãngũ Mị̃sị́rị̃ gá rĩ pírí Fãráwũ nî. ꞌBá Mị̃sị́rị̃ gá rĩ uzị kí ãngũ ĩꞌbadrị̂ kí pírí ãꞌdusĩku rílẽ ꞌdã ꞌbã mịfị́ la ꞌbã kajó ika rĩ sĩ. Ãngũ Mị̃sị́rị̃ gá rĩ acá dó sĩ pírí Fãráwũ ãni. ");
INSERT INTO luc_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yụ̃sụ́fụ̃ isé dó ꞌbá kí pírí ãtíꞌbó Fãráwũ ãni la rú, iꞌdójó Mị̃sị́rị̃ ꞌbã wókõ ãzí rĩ gá kpere ãzí rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ãngũ ĩꞌdi ꞌbã ĩgbãlé ku rĩ ꞌbãngá lú ãtalo ꞌbadrị̂ kî ãꞌdusĩku ri kí ãkónã ịsụ́lé Fãráwũ rụ̂ sĩ ãzíla ãkónã fẽlé ĩꞌbaní rĩ ca vâ sĩ rá. Ị́jọ́ ꞌdĩ dó bã sĩ ĩꞌbaní ãngũ ĩꞌbadrị̂ kí uzị jó ku ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yụ̃sụ́fụ̃ jọ ꞌbá ꞌbaní, “Úꞌdîꞌda má ĩgbã dó ĩmi ãngũ ĩmidrị̂ kí trũ pírí Fãráwũ ní ꞌbo, ũri kî dó ꞌdĩ, ĩkpẹ̃ dó sĩ ámvụ́ kî. ");
INSERT INTO luc_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Wó ũri drĩ kí ka rá, lãŋá la gá wókõ ãlu tõwú agá rĩ lẽ úfẽ ĩꞌdi Fãráwũ drị́. Ĩmi icó dó ị́mbị́ la acelépi rĩ kí tã mbalé ũri rú ãzíla nalé ãkónã rú ꞌbá ĩmidrị́ lị́cọ́ gá rĩ kí abe rá.” ");
INSERT INTO luc_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Jọ kí dó ĩꞌdiní, “Ípa ãma ídri ꞌbo, ími ásị́ ꞌbã adru ãmaní ị̃gbẹ́ ru fô ãmbógó ãmadrị̂, ãma adru Fãráwũ ꞌbã pálé gá ãtíꞌbó ru rá.” ");
INSERT INTO luc_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yụ̃sụ́fụ̃ ꞌbã dó ị́jọ́ ꞌdĩ ãzị́táŋá ru ãngũ Mị̃sị́rị̃ drị̂ agá kpere ãndrũ, ãko ãlu tõwú agá rĩ Fãráwũ ãni, pẽ lú ãngũ ãtalo ꞌbadrị̂ adru kí Fãráwũ ãni ku rĩ gá nĩ. ");
INSERT INTO luc_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ꞌBá Ịsịrayị́lị̃ drị̂ ri kí Mị̃sị́rị̃ gá ãngũ Gõsénĩ rĩ gá. Ịsụ́ kí málĩ ãzíla tị kí vâ wẽwẽ rú. ");
INSERT INTO luc_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yãkóꞌbõ uꞌá dó Mị̃sị́rị̃ gá ílí mụdrị́ drị̃ ázị̂rị̃, ílí ĩꞌdidrị́ ĩꞌdi ꞌbã adrujó ídri rú rĩ 147. ");
INSERT INTO luc_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Sáwã Ịsịrayị́lị̃ ꞌbã drãjó rĩ la dó mụ acálé ãni rú, umve dó ngọ́pị̃ Yụ̃sụ́fụ̃ ꞌi ãzíla jọ ĩꞌdiní, “Áma ị́jọ́ drĩ fi ími ásị́ gá rá, ísu ími drị́ áma pálé gá ꞌdâ ãzíla ína ũyõ ãzíla mi mụ ị́jọ́ kí idélé má rụ́ ásị́ ị̃gbẹ̃ sĩ ãzíla ị́jọ́ mgbã sĩ mí icó dó sĩ áma ị̃sị̃lé Mị̃sị́rị̃ gá ꞌdâ ku. ");
INSERT INTO luc_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ádrĩ dó drã rá álẽ îsị̃ ma ãngũ má átẹ́pịka kí ị̃sị̃jó rĩ gá. Íꞌdụ ma Mị̃sị́rị̃ gá ꞌdâ rĩ sĩ mụlé ị̃sị̃lé ãngũ sĩ mâ átẹ́pịka kí ị̃sị̃jó rĩ gá.” Yụ̃sụ́fụ̃ jọ ĩꞌdiní, “Ma ị́jọ́ míní jọlé ꞌdĩ idé rá.” ");
INSERT INTO luc_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yãkóꞌbõ jọ, “Ína ũyõ ru.” Yụ̃sụ́fụ̃ na dó ũyõ rá, ãzíla Ịsịrayị́lị̃ ãvụ̃ dó mgbọ́lọ́ drị̃ gá ꞌdãá sĩ ãwãꞌdĩfô fẽjó ị̃nzị̃táŋá be. ");
INSERT INTO luc_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Sáwã ãzí vúlé gá ụ́ꞌdụ́kọ́ acá Yụ̃sụ́fụ̃ ní, “Mî átẹ́pị ãyánĩ rú trẹ̃yị́.” Ị́jọ́ ꞌdĩ sĩ Yụ̃sụ́fụ̃ ꞌdụ ngọ́pịka ị̃rị̃ Mãnásẽ kí Ịfụrayị́mụ̃ be ĩndĩ trũ mụjó Yãkóꞌbõ ndrejó. ");
INSERT INTO luc_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yãkóꞌbõ la mụ arelé la ngọ́pị̃ Yụ̃sụ́fụ̃ acá ꞌbo, imbá ru rijó ị̃ndụ́ sĩ mgbọ́lọ́ drị̃ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yãkóꞌbõ jọ ngọ́pị̃ Yụ̃sụ́fụ̃ ní, “Ãdróŋá Ũkpó ꞌDị́pị iꞌda ándrá ru mání Lụ́zị̃ gá ꞌdĩ ãngũ Kãnánĩ gá, ãzíla wi mání sụ̃sụ́ ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ãdróŋá jọ, ‘Ma ũri mídrị̂ kí fẽ kpẹ̃lé wẽwẽ rú ãzíla mi dó sĩ acá sụ́rụ́ ũꞌbí kí ꞌbã áyị́pị rú. Ma dó sĩ ãngũ ꞌdĩ fẽ acájó anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbã ãni la rú jãꞌdâ.’ ");
INSERT INTO luc_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ị́jọ́ ꞌdĩ sĩ, mî ngọ́pịka ị̃rị̃ tịlé Mị̃sị́rị̃ gá ꞌdâ ịsụ́ ꞌdĩ sĩ má amụ́ drĩ Mị̃sị́rị̃ gá ꞌdâ ku rú ꞌdĩ kí anzị mâ ãni la kí; Ịfụrayị́mụ̃ kí Mãnásẽ be kí mâ anzị cécé Rụ́bẹ̃nị̃ kí adrujó Sị̃mọ́nị̃ be má ãni rĩ áni. ");
INSERT INTO luc_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Anzịŋá míní tịlé kí vúlé gá rĩ kí dó adru mí ãni, ãngũ ĩꞌbã kí mụlé ịsụ́lé ĩꞌba ãni la rú rĩ la adru Ịfụrayị́mụ̃ ꞌbarụ̂ sĩ Mãnásẽ be. ");
INSERT INTO luc_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ma ị́jọ́ ꞌdĩ idé íni la mî ãndrẽ Rãkẹ́lị̃ ꞌbã ị́jọ́ sĩ, ĩꞌdi mání ũcõgõ rú mání ãgõjó angájó Pãdánĩ gá rĩ sĩ, mî ãndrẽ drã gẹ̃rị̃ gá Kãnánĩ gá ịsụ́ ꞌdĩ sĩ áca drĩ Ĩfũrátã gá ku rú. Má ị̃sị̃ dó sĩ ĩꞌdi ꞌdãá.” (Ĩfũrátã ĩꞌdi ãngũ úꞌdîꞌda umvelé Bẹ̃tẹ̃lẹ̃hẹ́mụ̃ rĩ ꞌi.) ");
INSERT INTO luc_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ịsịrayị́lị̃ la mụ anzị Yụ̃sụ́fụ̃ drị̂ kí ndrelé ꞌbo, zị Yụ̃sụ́fụ̃ ꞌi, “Anzị ꞌdĩ kí dó íngõ kî yã?” ");
INSERT INTO luc_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yụ̃sụ́fụ̃ umvi, “ꞌDi kí anzị Ãdróŋá ꞌbã fẽlé mání Mị̃sị́rị̃ gá ꞌdâ rĩ kî.” Ịsịrayị́lị̃ jọ, “Mí ají kí má rụ́ ꞌdõlé, ma dó sĩ ĩꞌbaní sụ̃sụ́ wi.” ");
INSERT INTO luc_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ĩdrãnĩgõ sĩ Yãkóꞌbõ ꞌbã mịfị́ ndre kí dó ãngũ múké-múké ku. Ị́jọ́ ꞌdĩ sĩ Yụ̃sụ́fụ̃ ají dó anzị kí ĩꞌdi rụ́ ꞌdõlé, Yãkóꞌbõ amvu dó kí, ãzíla wi dó sụ̃sụ́ ĩꞌbanî. ");
INSERT INTO luc_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ꞌDã ꞌbã ũngúkú gá, Ịsịrayị́lị̃ jọ Yụ̃sụ́fụ̃ ní, “Áꞌbã ándrá áma ásị́ gá ma ími ndre ị̃dị́ rá la ku, wó Ãdróŋá fẽ dó vâ ándre mî anzị kí ĩndĩ.” ");
INSERT INTO luc_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yụ̃sụ́fụ̃ ꞌdụ dó anzị ꞌdĩ kí ĩꞌbã áyị́pị ꞌbã ị̃lị́ gá rĩ sĩ rá ãzíla su drị̃ vụ̃rụ́ ị̃nzị̃táŋá ru ĩꞌdi drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yụ̃sụ́fụ̃ ꞌbã Ịfụrayị́mụ̃ ꞌi Yãkóꞌbõ ꞌbã drị́ ị̃jị́ rĩ gá, Mãnásẽ ꞌi Yãkóꞌbõ ꞌbã drị́ ãndá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Wó Yãkóꞌbõ aca ru drị́ kí ãzíla ꞌbã drị́ ãndá rĩ Ịfụrayị́mụ̃ drị̃ gá ĩꞌdi ꞌbã táni adrujó ngọ́tị́ŋá vúlé rĩ ꞌi tí, ꞌbã drị́ ị̃jị́ rĩ Mãnásẽ drị̃ gá ĩꞌdi ꞌbã táni adrujó ngọ́tị́ kãjãní rĩ ꞌi rá tí. ");
INSERT INTO luc_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ꞌDã ꞌbã ũngúkú gá, wi dó sụ̃sụ́ Yụ̃sụ́fụ̃ ní jọ, “Lẽ Ãdróŋá má áyị́pị Ịbụrahị́mụ̃ ãzíla má átẹ́pị Ĩsákã drị̂, Ãdróŋá áma ídri tã mbalépi kpere ãndrũ rĩ ꞌbã wi sụ̃sụ́ ĩꞌbanî. ");
INSERT INTO luc_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mãlãyíkã áma apálépi ị́jọ́ ũnzí rĩ kí agá pírí rĩ, ꞌbã wi anzị ꞌdĩ ꞌbaní sụ̃sụ́! Rụ́ mâ áyị́pị Ịbụrahị́mụ̃ drị̂, mâ átẹ́pị Ĩsákã drị̂, ãzíla rụ́ mádrị́ Yãkóꞌbõ drị̂ ꞌbã ãvĩ kí rû sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yụ̃sụ́fụ̃ la dó mụ ndrelé la átẹ́pị ꞌbã drị́ ãndá rĩ Ịfụrayị́mụ̃ drị̃ gá, uꞌá dó cãndí sĩ ãzíla ꞌdụ dó drị́ la ãndá rĩ Ịfụrayị́mụ̃ drị̃ gá rĩ sĩ ꞌbãlé Mãnásẽ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Uja dó jọlé la, “Má átẹ́pị adru ꞌdĩ ꞌbã áni ku ngọ́tị́ŋá kãjãní rĩ ĩꞌdi Mãnásẽ ꞌi, íꞌbã ími drị́ ãndá rĩ ĩꞌdi drị̃ gá.” ");
INSERT INTO luc_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Wó Átẹ́pị̃ gã úmgbé jọ, “Mâ ngọ́pị ánị̃ ị́jọ́ ꞌdĩ rá, anzị Mãnásẽ drị́ mụlé tịlé drị̃lẹ́ gâlé ri kí acá ũꞌbí ru, wó ĩꞌdi adru sụ́rụ́ ãmbógó la. ꞌBo ádrị́pị̃ wereŋá Ịfụrayị́mụ̃ ꞌbã anzị mụlé tịlé drị̃lẹ́ gâlé ri kí adru wẽwẽ rú ĩꞌdidrị̂ ꞌbaní ãndânĩ ãzíla anzị ĩꞌdidrị́ mụlé tịlé drị̃lẹ́ gâlé ri kí adru sụ́rụ́ ãzí ãmbógó la.” ");
INSERT INTO luc_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Wi ĩꞌbaní sụ̃sụ́ jọ, “ꞌBá Ịsịrayị́lị̃ gá rĩ kí rú ĩꞌdi rụ́ umve sĩ sụ̃sụ́ ãlá rĩ ịsụ́jó. Kí rú jọ la, ‘Ãdróŋá ꞌbã ꞌbã mi cécé Ịfụrayị́mụ̃ áni ãzíla Mãnásẽ áni.’” Ị́jọ́ ꞌdĩ sĩ, Yãkóꞌbõ ꞌbã dó Ịfụrayị́mụ̃ ꞌi Mãnásẽ drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Yãkóꞌbõ jọ Yụ̃sụ́fụ̃ ní, “Ma úgólé drãlé drã-drã, wó Ãdróŋá ꞌbã mba ími tã ꞌbã uja vâ mi vúlé ãngũ mî áyị́pịka ꞌbadrị́ Kãnánĩ gá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Áfẽ míní ãngũ ꞌbã wókõ mání apálé ꞌbá Ãmọ́rị̃ rú rĩ kí drị́ alé agá ménéŋá sĩ ãzíla ụ́sụ sĩ rĩ míní adrujó mî ádrị́pịka kí drị̃lẹ́ gá rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yãkóꞌbõ umve ngọ́pịka kí pírí jó ĩꞌbaní, “Ĩmi atrá ĩmi áma andre gá, ma dó sĩ ĩminí ị́jọ́ drụ́zị́ drị́lẹ́ gâlé mụlépi ru idélépi ĩmi ụrụꞌbá gá rĩ kí iꞌda. ");
INSERT INTO luc_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Ĩmi atrá ĩmi áma andre gá mâ ngọ́pịka ãzíla ĩmi are ị́jọ́ ĩmĩ átẹ́pị Ịsịrayị́lị̃ ꞌbã jọlé rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rụ́bẹ̃nị̃ mi ngọ́tị́ mádrị́ kãjãní mání sĩ bõdõ ụ̃nị̃jó rĩ ꞌi, mi ũkpõ mádrị́ kãrị̃lẹ̃ drị̂ iꞌdalépi rĩ ꞌi, mí alị ꞌbá ãzí ꞌdĩ kí ũkpõ sĩ ãzíla ãrútáŋá sĩ rá. ");
INSERT INTO luc_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mi cécé ị̃yị́ galépi tré drị̃ ụtrị́lé ku rĩ áni, mí icó ãrútáŋá kãjãnĩ drị̂ ịsụ́lé ku, míní ándrá tụjó mí átẹ́pị drị́ mgbọ́lọ́ sị́ gá, sĩ mî ụ́kụ́pị drị̃ izajó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Sị̃mọ́nị̃ kí ádrị́pị̃ Lẹ́vị̃ be ají kí ru ị́jọ́ ngaŋá sĩ ãlu; kí ménéŋá ĩꞌbadrị̂ kí ayú sĩ ãlí idéjó sĩ ãꞌdị́ ꞌdịjó. ");
INSERT INTO luc_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Lẽ áfi ị́jọ́ amáŋá ĩꞌbadrị̂ agá ku, lẽ má icí tị ĩꞌba abe ãlu sĩ ị́jọ́ itújó ku, ãꞌdusĩku ụꞌdị́ kí ꞌbá ũmbã ĩꞌbadrị̂ sĩ rá ãzíla ụlị́ kí vâ tị́ ꞌbã ị́sụ́ pá gá use rĩ kí sĩ avájó. ");
INSERT INTO luc_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Áwã ũmbã ĩꞌbadrị́ ãcí ꞌdĩ rá ãzíla ũmbã ĩꞌbadrị̂ ũnzí-ũnzí, ma kí iré Yãkóꞌbõ agá ꞌdâ ãzíla kí awa ndú-ndú Ịsịrayị́lị̃ agá ꞌdâ. ");
INSERT INTO luc_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yụ́dã, mî ádrị́pịka kí rú ími ịcụ́-ịcụ̂; ími drị́ la adru mẹ́rọ́ꞌbá mídrị̂ kí imbe gá; mí ádrị́pịka kí rú drị̃ su míní vụ̃rụ́. ");
INSERT INTO luc_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yụ́dã! Mi kẹ̃mị̃mvá; mi ãgõ angájó ĩzá ciŋá gâlé mâ ngọ́tị̂. Mi ãngũ va sĩ ími lajó vụ̃rụ́ cécé kẹ̃mị̃ áni, mi kẹ̃mị̃ andre rĩ áni, ãꞌdi la ími aló nĩ yã? ");
INSERT INTO luc_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ꞌBá ãzí icó gbéréke ũpĩ drị̂ palé ími drị́ gá ku, túré ũpĩ drị́ ími pálé gá rĩ be, kpere úpí gbéréke ꞌdị́pị ꞌbã acá agá, ãzíla sụ́rụ́ pírí ꞌbaní ãrútáŋá fẽ agá ĩꞌdinî. ");
INSERT INTO luc_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ĩꞌdi kãyĩnõ ĩꞌdidrị̂ gĩ zãbíbũ ife gá, ĩꞌdi mváŋá la gĩ zãbíbũ ife ũniyambamba rĩ gá, ãzíla ĩꞌdi bõngó ĩꞌdidrị̂ kí ũjĩ zãbíbũ sụ́ ika ãrí áni rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mịfị́ la kí ka ndẽ wáyĩnĩ rá, ãzíla sị́ la kí mve ndẽ lẹ́sụ́ rá. ");
INSERT INTO luc_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zãbụ̃lọ́nị̃ la ri ị̃yị́tị gá ãzíla ĩꞌdi ị̃yị́tị íꞌbó ꞌbã kí sĩ pá tujó rĩ ꞌi. Ãngũ ĩꞌdidrị̂ la ca kpere Sị̃dọ́nị̃ gá. ");
INSERT INTO luc_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Ĩsãkárĩ ꞌi ĩꞌdi kãyĩnõ ũkpó ru lalépi tẹ́rị́ ĩꞌdi ꞌbã ꞌdụlé rĩ kí drĩdríŋĩ gá rĩ. ");
INSERT INTO luc_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Drĩ ãngũ avị́jó rĩ ndre ãlá ru ãzíla ãngũ lékõ drĩ ĩꞌdiní ãyĩkõ fẽ rá, ĩꞌdi ru ũngúkú ꞌbã sĩ tẹ́rị́ ujíjó ãzíla ĩꞌdi ãzị́ ĩꞌdi ũŋmĩjó ũkpó sĩ rĩ nga rá. ");
INSERT INTO luc_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dánĩ la rú ị́jọ́ lịŋá pịrị rĩ fẽ ꞌbá ĩꞌdidrị̂ ꞌbaní cécé sụ́rụ́ ãlu Ịsịrayị́lị̃ drị̂ ꞌbã ãzí áni. ");
INSERT INTO luc_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dánĩ la ru co ị̃nị̃ rú gẹ̃rị̃ tị gá, galaꞌbá gẹ̃rị̃ agá kãyĩnõ kí ĩníŋá agalépi rĩ rú, ị́jọ́ ꞌdĩ sĩ ꞌbá cẹ̃lépi kãyĩnõ drị̃ gá rĩ ꞌba aꞌdé rû sĩ ụ̃lị̃-ụ̃lị rú.” ");
INSERT INTO luc_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ꞌDã ꞌbã ũngúkú gá, Yãkóꞌbõ zị Ãdróŋá ꞌi, “Úpí! Ma patáŋá mídrị̂ tẽ.” ");
INSERT INTO luc_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","ꞌDã ꞌbã ũngúkú gá, Yãkóꞌbõ jọ ngọ́pịka ꞌbaní, “ꞌBá ꞌbá ralépi rĩ kí amụ́ ũꞌbí ru Gádĩ tị celé sĩ ĩꞌdi rajó, wó ĩꞌdi ꞌde kí ĩníŋá gá sĩ kí ndẽjó rá. ");
INSERT INTO luc_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Ásẹ̃rị̃ ꞌbã ãngũ la adru ãkónã ní úsã rú, ĩꞌdi rú ãkónã ãjị́ ambamba úpí ní icólé nalé rá rĩ kí ũfũ nĩ. ");
INSERT INTO luc_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nãfũtálĩ ĩꞌdi lẽza trũlé rá mvaka tịlépi ũniyambamba rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yụ̃sụ́fụ̃ ĩꞌdi zãbíbũ ífí kalépi kũlũ kídí tị gá rĩ ꞌi, kénĩ la kí dị Bõrõ drị̃ gâsĩ. ");
INSERT INTO luc_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Mẹ́rọ́ꞌbá ĩꞌdidrị̂ atrá kí ru ĩꞌdi celé ụ́sụ sĩ; kí ĩꞌdi gbẹ ásị́ ị̃gbẹ̃ kóru. ");
INSERT INTO luc_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Wó ụ́sụ ĩꞌdidrị̂ bábá ãzíla úꞌbã drị́ ĩfã ĩꞌdidrị̂ kí ũkpó ru ãzãkoma Ãdróŋá Ũkpó ꞌDị́pị Yãkóꞌbõ drị̂ drị̂ sĩ, ãꞌdusĩku ĩꞌdi ꞌbá ꞌbá ucélépi rĩ ãzíla ũkpõ Ịsịrayị́lị̃ drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ĩꞌdi Ãdróŋá mí átẹ́pị ꞌbadrị́ ími ãzã kolépi rĩ ꞌi, Ũkpó ꞌDị́pị míní sụ̃sụ́ wilépi rĩ ꞌbã wi míní sụ̃sụ́ uzogó, ị̃tụ́ ãlá ꞌbụ̃ gá rĩ drị̂ trũ, ꞌbã wi míní sụ̃sụ́ ãko ụ̃nọ́kụ́ ị̃ndụ́ gá mgbi rĩ ꞌbadrị̂ ãzíla ꞌbã wi míní sụ̃sụ́ ĩbã sụ́ ãzíla mvájólé drị̂ kî abe. ");
INSERT INTO luc_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Lẽ sụ̃sụ́ mí átẹ́pịka ꞌbadrị̂ ꞌbã adru cécé ꞌbê áni, ꞌbã ndẽ ꞌbé údu rĩ kí rá, sụ̃sụ́ wilé ꞌdĩ ꞌbã tra kí ru pírí Yụ̃sụ́fụ̃ drị̃ gá. Ími androko ꞌbã indré mí ádrị́pịka kí agá ꞌdâ ndú míní adrujó úpí mvá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Bénzãmĩnĩ ĩꞌdi ụ̃bọ̃gụ̃ ãko ucílépi ŋmãrụ̃-ŋmãrụ̃ rĩ ꞌi, ụ̃ꞌbụ́tị sĩ ĩꞌdi ĩzá ĩꞌdiní ucílé rĩ kí na, ĩndró sĩ ĩꞌdi ĩzá ĩꞌdiní ralé rĩ kí awa.” ");
INSERT INTO luc_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ꞌDĩ kí sụ́rụ́ mụdrị́ drị̃ ị̃rị̃ Ịsịrayị́lị̃ drị̂ kí, ị́jọ́ ꞌdĩ dó átẹ́pị̃ ꞌbã sĩ azịjó ãzíla sụ̃sụ́ wijó ĩꞌbanî rĩ ꞌi, ngọ́tị́ŋá ãlu-ãlu ní úfẽ sụ̃sụ́ icólépi ĩꞌdi sĩ rá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ꞌDã ꞌbã ũngúkú gá, Yãkóꞌbõ azị ĩꞌbaní, “Ma dó ãni rú mụjó mâ átẹ́pịka ꞌba rụ́ mâ áyị́pịka abe, ĩmi ị̃sị̃ ma mâ átẹ́pịka kí abe ụ̃jị́gọ́ gá ámvụ́ Ífĩrõnĩ ꞌbá Hị́tị̃ rú rĩ drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ꞌDĩ ụ̃jị́gọ́ ámvụ́ Mãkĩpélã drị̂ agá ãni rú Mãmírẽ Kãnánĩ gá rĩ gá ándrá Ịbụrahị́mụ̃ ꞌbã ĩgbãlé Ífĩrõnĩ Hị́tị̃ rú rĩ drị́ ámvụ̂ trũ ãngũ sĩ ꞌbá ị̃sị̃jó rĩ rú rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ị̂sị̃ ándrá Ịbụrahị́mụ̃ kí ũkû Sárã be, Ĩsákã kí ũkû Rẽbékã be ãzíla ị̂sị̃ vâ Léyã ꞌi alagá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ámvụ̂ kí ụ̃jị́gọ́ ala gá rĩ kí abe îgbã ándrá kí angájó ꞌbá Hị́tị̃ rú rĩ ꞌbadrị́.” ");
INSERT INTO luc_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yãkóꞌbõ la mụ ị́jọ́ ĩꞌdidrị̂ kí delé azịlé ngọ́pịka abe ꞌbo, la dó ru vúlé mgbọ́lọ́ sị́ gâlé ãzíla drã dó rá. ");
INSERT INTO luc_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yụ̃sụ́fụ̃ ꞌbe dó ru átẹ́pị̃ drị̃ gâlé áwáŋâ trũ. ");
INSERT INTO luc_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ꞌDã ꞌbã ũngúkú gá, Yụ̃sụ́fụ̃ fẽ ãzị́táŋá ꞌbá írúwá idélépi rĩ ꞌbaní sĩ átẹ́pị̃ ụrụꞌbá iníjó írúwá sĩ icójó ŋmajó ku rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Yãkóꞌbõ ụrụꞌbá iníjó írúwá sĩ rĩ ꞌdụ ụ́ꞌdụ́ kãlị́ sụ ãzíla sụ́rụ́ ndụlụ Mị̃sị́rị̃ drị̂ awá kí ĩꞌdi ụ́ꞌdụ́ kãlị́ ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ụ́ꞌdụ́ áwáŋá drị̂ kí dó mụ ukólé ꞌbo, Yụ̃sụ́fụ̃ jọ dó ꞌbá ĩyõ Fãráwũ drị̂ ꞌbaní, “Áma ị́jọ́ drĩ fi ĩmi ásị́ gá rá, ꞌbá rĩ ĩjọ Fãráwũ ní ị́jọ́ áma kẹ̃jị́ gá. ");
INSERT INTO luc_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Má átẹ́pị fẽ ándrá ma ũyõ nalé jọ, “Ma úgólé drãlé drã-drã. Ádrĩ drã ꞌbo, mí ị̃sị̃ ma ꞌbụ́ mání galé ãngũ Kãnánĩ gá rĩ agá.” Mí ají ámụ dó má átẹ́pị ị̃sị̃lé, ádrĩ dó ĩꞌdi ị̃sị̃ ꞌbo, ꞌdã ꞌbã ũngúkú gá ma dó ãgõ vúlé ꞌdõlé gbõŋáŋá ru.’” ");
INSERT INTO luc_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Fãráwũ jọ Yụ̃sụ́fụ̃ ní, “Ímụ mí átẹ́pị ị̃sị̃lé míní ándrá ũyõ najó mi idé la rá rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yụ̃sụ́fụ̃ mụ dó átẹ́pị̃ ị̃sị̃lé. ꞌBá ĩyõ Fãráwũ drị̂ ꞌde kí ĩꞌdi vú gâsĩ, ꞌbá ãmbogo pírí Mị̃sị́rị̃ gá rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ꞌBá Yụ̃sụ́fụ̃ drị́ko gá rĩ kí, ádrị́pịka kí abe, ãzíla ꞌbá átẹ́pị̃ drị́ko gá rĩ kí trũ mụ kí pírí rá. ꞌBá acelépi Gõsénĩ gá ꞌdãá rĩ kí lú anzịŋá kí ãnãkpá kí abe. ");
INSERT INTO luc_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ꞌBá ũꞌbí mụ kí ĩꞌdi ị̃sị̃lé nĩ, ꞌbá cẹ̃lépi gá rĩ ãꞌdị́drị̂ sĩ rĩ kí ꞌbá cẹ̃lépi fãrásĩ sĩ rĩ kí abe mụ kí vâ ĩꞌdi trũ ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ꞌBá kí mụ calé ãngũ Ãtádị̃ sĩ ãná cojó rĩ gá, ãni rú Ị̃yị́ Yõrĩdánĩ gá ꞌbo, rĩ kí dó awálé ụ́ꞌdụ́kọ́ ụrụ gá sĩ ãzákírílí ru ãzíla Yụ̃sụ́fụ̃ uꞌá kí ꞌdãá sĩ átẹ́pị̃ awájó ụ́ꞌdụ́ ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ꞌBá Kãnánĩ rú uꞌálépi ꞌdãá rĩ kí mụ ꞌbá ꞌdã kí ndrelé awá-agá ãngũ Ãtádị̃ sĩ ãná cojó rĩ gá ꞌdãá ꞌbo, jọ kí, “ꞌBá Mị̃sị́rị̃ rú rĩ kí drã ãmbógó la awá.” (ꞌDĩ dó bãsĩ ị́jọ́ sĩ ãngũ Yõrĩdánĩ andre gá ꞌdã umvejó Ãbẹ̃lị̃-Mị̃zị̃rãyị́mụ̃ ꞌi ꞌdĩ.) ");
INSERT INTO luc_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ị́jọ́ ꞌdĩ sĩ Yãkóꞌbõ ꞌbã ngọ́pịka idé kí dó ị́jọ́ cécé ĩꞌdi ꞌbã azịlé ĩꞌbaní rĩ ãni. ");
INSERT INTO luc_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Agụ kí dó ĩꞌdi ị̃sị̃lé Kãnánĩ gá ụ̃jị́gọ́ ámvụ́ Mãkĩpélã gá rĩ gá ãni rú Mãmírẽ gá, ꞌdĩ ãngũ ándrá Ịbụrahị́mụ̃ ꞌbã ĩgbãlé Ífĩrõnĩ Hị́tị̃ rú rĩ drị́ ámvụ́ trũ ãzíla ãngũ sĩ ꞌbá ị̃sị̃jó ri be rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yụ̃sụ́fụ̃ la mụ átẹ́pị̃ Yãkóꞌbõ ị̃sị̃lé ꞌbo, uja kí ru vúlé Mị̃sị́rị̃ gá ꞌdõlé ádrị́pịka kí abe ãzíla ꞌbá mụlépi átẹ́pị̃ ꞌbã ị̃sị̃ŋá gá rĩ kî trũ. ");
INSERT INTO luc_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yụ̃sụ́fụ̃ ꞌbã ádrị́pịka kí dó mụ ndrelé la ĩꞌbã átẹ́pị drã dó rá, jọ kí, “Ãzî sĩ Yụ̃sụ́fụ̃ la mụ acálé ãma abe ũnzí ị́jọ́ ándrá ãmaní idélé ĩꞌdi ụrụꞌbá gá ũnzí rĩ kî sĩ.” ");
INSERT INTO luc_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ị́jọ́ ꞌdĩ sĩ ị̃drị̃ kí dó ụ́ꞌdụ́kọ́ Yụ̃sụ́fụ̃ ní jọ kí, “Ãmã átẹ́pị azị ándrá ãmaní ị́jọ́ ꞌdĩ kí ịsụ́ ꞌdĩ sĩ drã drĩ ku rú. ");
INSERT INTO luc_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ꞌDĩ ị́jọ́ ĩminí mụlé jọlé Yụ̃sụ́fụ̃ nî rĩ ꞌi: ‘Má aꞌị́ mi mî ádrị́pịka kí trũjó rá ũnzĩkãnã ándrá ĩꞌbã kí idélé mí rụ́ rĩ kî sĩ.’” ꞌBárĩ úꞌdîꞌda ãma ãtiꞌbo Ãdróŋá mí átẹ́pị drị̂ kî, ãma aꞌị́ mi ũnzĩkãnã ãmadrị̂ kî trũjó rá fô. Ụ́ꞌdụ́kọ́ ꞌdĩ la mụ calé ĩꞌdi rụ̂lé ꞌbo, Yụ̃sụ́fụ̃ awá mị́ndrẹ sĩ. ");
INSERT INTO luc_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ádrị́pịka amụ́ kí ãzíla ụ̃tị̃ kí ãja vụ̃rụ́ ĩꞌdi drị̃lẹ́ gá jọ kí, “Ãma ãtiꞌbo mî ãni.” ");
INSERT INTO luc_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Wó Yụ̃sụ́fụ̃ jọ ĩꞌbaní, “Ĩmi idé mâ sĩ ụ̃rị̃ sĩ ku. Ma Ãdróŋá ꞌi sĩ ꞌbá ị́jọ́ lịjó yã? ");
INSERT INTO luc_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ĩmi ũrã ándrá ĩmi áma idé agá ũnzí, wó Ãdróŋá ãpẽ áma tị ĩmi drị̃lẹ́ gá ꞌdõlé sĩ amụ́jó ꞌbá ũꞌbí kí ídri upajó. ");
INSERT INTO luc_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ị́jọ́ ꞌdĩ sĩ Yụ̃sụ́fụ̃ jọ ĩꞌbaní ị́jọ́ ásị́-ị̃gbẹ̃ sĩ ị̃dị́ jọ, Ĩmi idé mâ sĩ ụ̃rị̃ sĩ ku, ma mụ ĩminí ãkónã fẽlé ãzíla ma vâ ĩmi tãmba anzị ĩmidrị̂ kí abe rá.” ");
INSERT INTO luc_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yụ̃sụ́fụ̃ uꞌá Mị̃sị́rị̃ gá ꞌbá ĩꞌdi ꞌbã átẹ́pị drị́ko gá rĩ kí abe. Uꞌá ílí 110 drã dó ĩndõ. ");
INSERT INTO luc_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yụ̃sụ́fụ̃ ndre anzị tịlé Ịfụrayị́mụ̃ ní drị̃lẹ́ gâlé rĩ kí kpere áꞌbị́ anzị na rĩ gá. Úlã vâ anzị Mãkírĩ Mãnásẽ ꞌbã ngọ́pị drị̂ kí anzị Yụ̃sụ́fụ̃ ãni la kî rú. ");
INSERT INTO luc_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ꞌDã ꞌbã ũngúkú gá, Yụ̃sụ́fụ̃ jọ ádrị́pịka ꞌbaní, “Ma ãni rú drãjó, wó ãndá-ãndá ru Ãdróŋá la mụ ĩmi ãzã kolé rá, ãzíla ĩꞌdi drụ́zị́ ĩmi ũfũ ãngũ Mị̃sị́rị̃ agá ꞌdâ rĩ sĩ agụlé ãngũ ándrá ĩꞌdi ꞌbã ũyõ najó ꞌi fẽ la Ịbụrahị́mụ̃ ní, Ĩsákã ãzíla Yãkóꞌbõ ꞌbaní rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yụ̃sụ́fụ̃ fẽ anzị Ịsịrayị́lị̃ drị̂ ꞌbaní ũyõ nalé jọ, “Ãndá-ãndá ru Ãdróŋá la mụ ĩmi agụlé Kãnánĩ gâlé rá, ĩꞌdụ jõ áma ĩfãkã kí ĩndĩ.” ");
INSERT INTO luc_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ị́jọ́ ꞌdĩ sĩ Yụ̃sụ́fụ̃ drã dó Mị̃sị́rị̃ gá ꞌdĩ sĩ ílí la dó 110. Úní dó ãvũ la írúwá sĩ, ãzíla úmba dó sĩ tã la Sãndụ́kụ̃ sĩ ãvũ tãmbajó rĩ agá Mị̃sị́rị̃ gá ꞌdãá.");
INSERT INTO luc_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Anzị Yãkóꞌbõ drị́ mụlépi ĩꞌdi trũ Mị̃sị́rị̃ gâlé lị́cọ́ ĩꞌbadrị̂ abe rĩ kí rụ́ ꞌdĩ ꞌbã áni: ");
INSERT INTO luc_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rụ́bẹ̃nị̃ ꞌi, Sị̃mọ́nị̃ ꞌi, Lẹ́vị̃ ꞌi ãzíla Yụ́dã ꞌi, ");
INSERT INTO luc_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Ĩsãkárĩ ꞌi, Zãbụ̃lọ́nị̃ ꞌi ãzíla Bénzãmĩnĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dánĩ ꞌi, Nãfũtálĩ ꞌi, Gádĩ ꞌi ãzíla Ásẹ̃rị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Anzị Yãkóꞌbõ drị̂ kí ándrá anzị ĩꞌdidrị̂ ꞌbã anzị kí abe pírí rĩ gá kãlị́ ázị̂rị̃, ịsụ́ ꞌdĩ sĩ Yụ̃sụ́fụ̃ dó Mị̃sị́rị̃ gá. ");
INSERT INTO luc_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ílí ũꞌbí vúlé gá Yụ̃sụ́fụ̃ kí ádrị́pịka abe ãzíla ꞌbá ílí ĩꞌbadrị́ ꞌdã agá rĩ abe ũdrã kí dó ꞌdĩ sĩ pírí ꞌbo, ");
INSERT INTO luc_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","wó ꞌbá Ịsịrayị́lị̃ drị̂ ri kí drị̃lẹ́ba rú tịlé gbõrú-gbõrú ãzíla kãlãfe ĩꞌbadrị̂ tụ dó ũꞌbí ru alị dó rá, ị́jọ́ ꞌdĩ sĩ ga kí dó ãngũ Mị̃sị́rị̃ drị̂ agá pírí. ");
INSERT INTO luc_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ꞌDã ꞌbã vúlé gá úpí ãzí úꞌdí ị́jọ́ nị̃lépi Yụ̃sụ́fụ̃ drị̃ gá ku la ri dó ũpĩ gá Mị̃sị́rị̃ gá nĩ. ");
INSERT INTO luc_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Jọ ꞌbá ĩꞌdidrị̂ ꞌbaní, “Ĩndre, ꞌbá Ịsịrayị́lị̃ drị̂ acá kí dó ũꞌbí ru ãzíla ũkpó ru ãma ní ãndânĩ. ");
INSERT INTO luc_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Lẽ ãma idé kí ị́jọ́ ãmaní lẽlé rĩ kí kí ụrụꞌbá gá ũndũwã sĩ, jõ íni ku kí mụ tịlé ũꞌbí ru drị̃ gá drị̃ gá ãzíla, sụ́rụ́ ãzí drĩ kí amụ́ ãma rụ́ ãꞌdị́ gá, kí ru icí mẹ́rọ́ꞌbá amụ́lépi ãma rụ́ ãꞌdị́ gá rĩ abe kí ãma ndẽ rá.” ");
INSERT INTO luc_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ị́jọ́ ꞌdĩ sĩ, ꞌbá drị̃lẹ́ ru Mị̃sị́rị̃ drị̂ ũꞌbã kí dó ꞌbá ãmbogo rú Mị̃sị́rị̃ rú la kí ꞌbá Ịsịrayị́lị̃ drị́ ãtiꞌbo rú rĩ kí drị̃lẹ́ gá. Ri kí dó sĩ kí ĩkpãlé ãzị́ ngaŋá ũkpó la sĩ, ãzíla sị kí dó táwụ̃nị̃ Pĩtómũ kí Rãmãsẹ́sị̃ be sĩ ãkónã tãmbajó úpí Mị̃sị́rị̃ drị̂ ní. ");
INSERT INTO luc_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Wó ĩꞌbaní táni kí ĩkpã agá drị̃ gá drị̃ gá rá tí, kãlãfe ĩꞌbadrị̂ ri tụlé tịŋá sĩ ãzíla iréŋá sĩ drị̃ gá; ꞌdãá ꞌbá Mị̃sị́rị̃ gá rĩ iꞌdó kí dó idélé ụ̃rị̃ sĩ ꞌbá Ịsịrayị́lị̃ rú rĩ kí ị́jọ́ sĩ, ");
INSERT INTO luc_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ị́jọ́ ꞌdĩ sĩ ꞌbá Mị̃sị́rị̃ drị̂ ĩkpã kí dó kí ãzákírílí ru. ");
INSERT INTO luc_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Fẽ kí ĩꞌbaní ãzị́ ũkpó la kí sĩ kí ĩkpãjó ídri ĩꞌbadrị̂ agá ũdrí tujó sĩ bị̃rị́kị̃ ꞌbejó ãzíla ãzị́ ũví ndú ndú ámvụ́ drị̂ kí abe; ãzị́ pírí ĩꞌbã kí ngalé rĩ kí agá ꞌbá Mị̃sị́rị̃ gá rĩ kí ásị́ ĩꞌbaní ãcí-ãcí. ");
INSERT INTO luc_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ị́jọ́ ꞌdĩ sĩ úpí Mị̃sị́rị̃ drị̂ jọ ũkú ũkú Ĩbũrãníyã rú rĩ kí ãzã kolépi tĩŋá gá Sĩfúrã ꞌbaní Púwã be: ");
INSERT INTO luc_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Ĩminí ũkú Ĩbũrãníyã ꞌbadrị̂ kí ãzã ko agá ngọ́tị́ tĩŋá gá ꞌdãá ĩdrĩ ndre la ĩꞌdi ngọ́tị́ ágọ́bị́, ĩꞌdị ĩꞌdi rá, drĩ adru ĩzóŋá ĩmi aꞌbe ĩꞌdi ídri.” ");
INSERT INTO luc_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ũkú ũkú kí ãzã kolépi tĩŋá gá rĩ ru kí Ãdróŋâ rá ãzíla nga kí ãzị́ úpí Mị̃sị́rị̃ drị̂ ꞌbã lũlé ĩꞌbaní rĩ ku, aꞌbe kí dó sĩ anzị ãgọbị rĩ kí ídri. ");
INSERT INTO luc_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ꞌDã ꞌbã ũngúkú gá, úpí Mị̃sị́rị̃ drị̂ umve ũkú ũkú kí ãzã kolépi tĩŋá gá rĩ kí ãzíla zị kí: “Ĩmĩ idé ị́jọ́ anzị ãgọbị rú ꞌdĩ kí aꞌbejó ídri la ãꞌdu sĩ yã?” ");
INSERT INTO luc_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ũkú ũkú kí ãzã kolépi tĩŋá sĩ rĩ umvi kí Fãráwũ nî, “Ũkú Ĩbũrãníyã rú rĩ adru kí ũkú Mị̃sị́rị̃ rú rĩ kí áni ku, kí tĩ gbõŋá ru, ũkú ũkú kí ãzã kolépi rĩ kí jõ mụ acá trũ ꞌdĩ kí ịsụ́ la ũkú Ĩbũrãníyã rú ꞌdĩ tĩ kí ꞌbo.” ");
INSERT INTO luc_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ị́jọ́ ꞌdĩ sĩ, Ãdróŋá ꞌbã ásị́ dó sĩ ị̃gbẹ́ ru ũkú ꞌdĩ ꞌbanî ãzíla ꞌbá Ịsịrayị́lị̃ drị̂ kí kãlãfe tụ dó drị̃ gá ị̃dị́-ị̃dị́. ");
INSERT INTO luc_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Wó Ãdróŋá ꞌbã dó ásị́ ị̃gbẹ̃ lị́cọ́ ũkú ũkú kí ãzã kolépi tĩŋá sĩ rĩ ꞌbadrị̂ kí drị̃ gá rá, ãꞌdusĩku ru kí Ãdróŋâ rá. ");
INSERT INTO luc_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ị́jọ́ ꞌdĩ sĩ, Fãráwũ úpí Mị̃sị́rị̃ drị̂ fẽ dó ãzị́táŋá ꞌdĩ ꞌbá pírí ĩꞌdidrị̂ ꞌbaní: “Anzị pírí ãgọbị ũkú Ĩbũrãníyã rú rĩ ꞌbã kí tị̃lé rĩ kí úꞌbé kí Mĩrĩ Náyĩlĩ agá, anzị izonzi rú rĩ kí âꞌbe kí ídri.” ");
INSERT INTO luc_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Sáwã ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbaní ꞌbá Ịsịrayị́lị̃ rú rĩ kí ĩkpãjó ꞌdã sĩ, ágọ́bị́ sụ́rụ́ Lẹ́vị̃ drị̂ agá la ĩgbã vâ ĩzóŋá sụ́rụ́ Lẹ́vị̃ drị̂ agá la ũkú ru. ");
INSERT INTO luc_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ũkú ꞌdã ịsụ́ ꞌa ãzíla tị dó ngọ́tị́ŋá ágọ́bị́. Ĩꞌdi dó mụ ndrelé la ngọ́tị́ŋâ ĩꞌdĩ ãlá ru ꞌbo, uja dó sĩ ĩꞌdi ụ̃zị̃lé ĩmbá na. ");
INSERT INTO luc_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Wó ĩꞌdi ꞌbã icójó ngọ́tị́ŋâ ụ̃zị̃jó ị̃dị́ ku rĩ sĩ; aꞌdụ́ gụ́fá idélé ũzú sĩ la ãzíla ĩbĩ ụrụꞌbá la ísékísé sĩ cí ị̃yị́ ꞌbã fi rû sĩ gụ́fá agâlé ku. ꞌBã dó ngọ́tị́ŋâ ꞌi ꞌa la gá ãzíla zị̃ dó ĩꞌdi ũzú agá ị̃yị́ Mĩrĩ umvelé Náyĩlĩ rĩ tị gá. ");
INSERT INTO luc_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ámvọ́pị̃ tu pá rá-rá ru sĩ ndrejó la ãꞌdu ị́jọ́ la nõ mụ ru idélé ĩꞌdi rụ́ nĩ yã áni. ");
INSERT INTO luc_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ꞌDã ꞌbã ũngúkú gá, Fãráwũ ꞌbã ị̃zẹ́pị mụ Mĩrĩ Náyĩlĩ gâlé mụlé ru ũjĩlé, ãzíla izonzi ĩꞌdi ãzãkolépi rĩ ri kí ị̃yị́ tị pilé. Úpí ị̃zẹ́pị ndre gụ́fá ũzú agá ꞌdãá ãzíla pẽ dó ãtíꞌbó ĩꞌdidrị́ ĩzóŋá ru rĩ tị mụlé gụ́fâ aꞌdụ́lé. ");
INSERT INTO luc_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Úpí ị̃zẹ́pị nzị̃ tị la ãzíla ndre urekeŋâ ꞌi. Urekeŋâ la awá agá awá-awâ, ãzíla Fãráwũ ị̃zẹ́pị uꞌá dó cãndí sĩ ĩꞌdi ị́jọ́ sĩ. Jọ “Lẽ ũrekeŋá ꞌdĩ ꞌbã adru ꞌbá Ĩbũrãníyã rú ꞌdĩ ꞌbã ãzí áni la.” ");
INSERT INTO luc_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ꞌDã ꞌbã vúlé gá urekeŋâ ꞌbã ámvọ́pị̃ zị Fãráwũ ị̃zẹ́pị ꞌi, “Má icó mụlé míní ũkú ãzí Ĩbũrãníyã rú la umvelé sĩ ngọ́tị́ŋâ undrujó rá yã?” ");
INSERT INTO luc_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Fãráwũ ꞌbã ị̃zẹ́pị umvi, “Wõyí, ímụ.” Ĩzóŋâ mụ dó rá ãzíla ají dó urekeŋâ ꞌbã ãndrẽ mgbãrĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Fãráwũ ꞌbã ị̃zẹ́pị jọ urekeŋâ ꞌbã ãndrẽ nî, “Íꞌdụ mání ũrekeŋá ꞌdĩ undrulé, ma ími ũfẽ rá.” Ị́jọ́ ꞌdĩ sĩ, ũkú ꞌdĩ ꞌdụ dó urekeŋâ tã mbalé rá. ");
INSERT INTO luc_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ngọ́tị́ŋâ la dó mụ zolé ꞌbo, ꞌdụ dó ĩꞌdi agụlé Fãráwũ ꞌbã ị̃zẹ́pị drị̂lé ãzíla acá dó sĩ ĩꞌdi ꞌbã ngọ́pị rú. ꞌDa dó sĩ rụ́ la Mụ́sã ꞌi, ífí la, “Má aꞌdụ́ ĩꞌdi ị̃yị́ agá.” ");
INSERT INTO luc_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ụ́ꞌdụ́ ãlu Mụ́sã ꞌbã zojó ꞌbo rĩ sĩ, mụ ꞌbá Ĩbũrãníyã rú ĩꞌdi ꞌbã sụ́rụ́ ru rĩ kí andrélé ãzíla ndre kí ũŋmĩ agá ãzị́ ũkpómgboroto rĩ nga agá. Ndre ágọ́bị́ Mị̃sị́rị̃ rú la ꞌbá Ĩbũrãníyã rú ĩꞌdi ꞌbã sụ́rụ́ ru la co agá. ");
INSERT INTO luc_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mụ́sã undré ãngũ trộkị́lịrị, ndre ꞌbá ãzí ĩꞌdi ndrelépi la ꞌdáyụ, ꞌdị dó ágọ́bị́ Mị̃sị́rị̃ rú ꞌdã rá ãzíla zị̃ dó ĩꞌdi cínákí agá. ");
INSERT INTO luc_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Drụ̃sị̃ íni Mụ́sã ꞌbã mụjó ꞌbá ĩꞌdidrị̂ kí andréjó rĩ gá, ịsụ́ ãgọbị ị̃rị̃ Ĩbũrãníyã rú la kí ru co agá. Mụ́sã zị ágọ́bị́ ãzí rĩ idélépi ũnzí rĩ ꞌi, “Mi ꞌbá mî ádrị́pị rú rĩ co íni ãꞌdu ị́jọ́ sĩ yã?” ");
INSERT INTO luc_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ágọ́bị̂ umvi, “Ãꞌdi ꞌbã mi ãmaní úpí ru ãzíla ꞌbá ị́jọ́ lịlẹ́pi rĩ rú nĩ yã? Ílẽ áma ꞌdịlé cécé míní ágọ́bị́ Mị̃sị́rị̃ rú ꞌdã ꞌdịlé rĩ áni yã?” Mụ́sã acá dó ụ̃rị̃ sĩ ãzíla ũrã dó, “ꞌBá pírí nị̃ kí dó ị́jọ́ mání idélé rĩ ꞌbo.” ");
INSERT INTO luc_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Fãráwũ la mụ ị́jọ́ ꞌdĩ arelé ꞌbo, ụ̃ꞌbị̃ tí Mụ́sã ndrụ̃lé sĩ ĩꞌdi ꞌdịjó rá, wó Mụ́sã apá Fãráwũ rụ́ ꞌdãá rĩ sĩ rá sĩ mụjó uꞌájó Mị̃dị́yánị̃ gá. Mụ́sã la mụ calé Mị̃dị́yánị̃ gá ꞌbo, ri vũ gá kídí tị gá. ");
INSERT INTO luc_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ụ́ꞌdụ́ ãlu, átáló Mị̃dị́yánị̃ gá rĩ ꞌbã izonzi ázị̂rị̃ ꞌdĩ amụ́ kí ị̃yị́ ukolé ãkójó ãnãkpá ꞌbaní ị̃yị́ fẽjó rĩ kí agá sĩ ị̃yị́ fẽjó ãnãkpá átẹ́pị̃ drị̂ ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ꞌBá ãzí ãnãkpá tãmbalépi la amụ́ kí átáló Mị̃dị́yánị̃ gá rĩ ꞌbã izonzi kí drolé rá, wó Mụ́sã angá ụrụgá sĩ kí pajó ꞌbá ꞌda kí drị́ gá, ãzíla ko kí ãzã ị̃yị́ fẽjó ãnãkpá ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Izonzị ꞌdĩ kí mụ gõlé lị́cọ́ gá ĩꞌbã átẹ́pị Rụ̃wẹ́lị̃ rụ̂lé ꞌbo, Átẹ́pị̃ zị kí, “Ĩmi ãgõ ãndrũ lị́cọ́ gá údu ãꞌdu ị́jọ́ sĩ yã?” ");
INSERT INTO luc_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Umvi kí, “ꞌBá ãzí Mị̃sị́rị̃ rú la pa ãma ꞌbá ãnãkpá ucélépi rĩ kí drị́ gá rá. Átã uko vâ ãmaní ị̃yị́ fẽlé ãnãkpá ꞌbaní nĩ.” ");
INSERT INTO luc_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Rụ̃wẹ́lị̃ zị kí, “Ágọ́bị̂ dó íngãá yã? Ĩmi aꞌbe dó ĩꞌdi lé ãꞌdu ị́jọ́ sĩ? Ĩmi umve ĩꞌdi ãkónã nalé ãma abe.” ");
INSERT INTO luc_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mụ́sã ãꞌị̃ uꞌálé Rụ̃wẹ́lị̃ be rá ãzíla Rụ̃wẹ́lị̃ fẽ dó ĩꞌdi ꞌbã ị̃zẹ́pị Zĩpórã ꞌi Mụ́sã ní ũkú ru. ");
INSERT INTO luc_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zĩpórã tị ĩꞌdiní ngọ́tị́ ágọ́bị́, ãzíla Mụ́sã ꞌda dó rụ́ la Gị́rị́sị̃mụ̃ ꞌi, jọ “Má acá dó ãmị́yọ́ŋá ru ꞌbá ãzí ꞌbã ãngũ gá.” ");
INSERT INTO luc_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Sáwã ãzo vúlé gá, úpí Mị̃sị́rị̃ gá rĩ drã dó rá. ꞌBá Ịsịrayị́lị̃ rú rĩ ri kí drị̃cịlé ĩꞌbã kí adrujó ãtíꞌbó rĩ sĩ. Awá kí sĩ ãzãkoma aꞌị́jó ãzíla áwáŋá ĩꞌbadrị̂ ca kpere Ãdróŋá rụ́ rá. ");
INSERT INTO luc_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ãdróŋá are ĩꞌbã ãzá taŋá rá ãzíla ũrã ị́jọ́ tị icítáŋá ándrá ĩꞌdidrị́ Ịbụrahị́mụ̃ be, Ĩsákã ãzíla Yãkóꞌbõ be rĩ ꞌbã ị́jọ́ rá. ");
INSERT INTO luc_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ãdróŋá ndre dó ãngũ ꞌbá Ịsịrayị́lị̃ rú rĩ ꞌba rụ́ ãzíla así dó sĩ kí ị́jọ́ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ụ́ꞌdụ́ ãlu Mụ́sã dro ándrị́pị̃ Yétẽrõ átáló ru Mị̃dị́yánị̃ gá rĩ ꞌbã kãbĩlõ kí ị̃ndrị́ abe mụlé ucé trũ ãngũ álị́ kõtórõ ꞌbã wókõ ãzí ꞌbé Hõrébũ Ãdróŋá drị̂ gâlé. ");
INSERT INTO luc_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ꞌDã gá ꞌdãá mãlãyíkã Úpí drị̂ iꞌda ru ĩꞌdiní ãcí velépi mị̃rị́ agá rĩ gá. Mụ́sã ndre mị̃rị́ la ve agá wó ãcî ivé mị̃rị̂ ku. ");
INSERT INTO luc_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ị́jọ́ ꞌdĩ sĩ Mụ́sã ũrã ị́jọ́ jọ, “Ma drĩ áma uja sĩ mụjó ãko iꞌdálépi ndú mị̃rị̂ ꞌbã sĩ vejó ku ꞌdã ndrelé.” ");
INSERT INTO luc_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Úpí la mụ ndrelé la Mụ́sã asé ru ãni rú ꞌbo, Ãdróŋá umve ĩꞌdi angájó mị̃rị́ ãcí trũ rĩ agâlé, “Mụ́sã! Mụ́sã!” Mụ́sã umvi, “Ma ꞌdõ.” ");
INSERT INTO luc_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ãdróŋá jọ, “Mí amụ́ ãni rú ku. Ítrũ ŋĩlâ kí rá, ãꞌdusĩku ãngũ mí ní sĩ pá tụjó ꞌdĩ ĩꞌdi ãngũ ãlá la.” ");
INSERT INTO luc_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Jọ vâ ĩꞌdiní, “Ma Ãdróŋá mî áyị́pịka ꞌbadrị̂ ꞌi, Ãdróŋá Ịbụrahị́mụ̃ drị̂ ꞌi, Ãdróŋá Ĩsákã drị̂ ꞌi ãzíla Ãdróŋá Yãkóꞌbõ drị̂ ꞌi.” ꞌDĩ sĩ rĩ gá Mụ́sã zị̃ ru mịfị́ cí, ãꞌdusĩku idé ụ̃rị̃ sĩ sĩ Ãdróŋá ndrejó. ");
INSERT INTO luc_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Úpí jọ, “Ãndá ándre ũcõgõ ꞌbá mádrị̂ ꞌbã kí ịsụ́lé Mị̃sị́rị̃ gá rĩ rá, má are áwáŋá ĩꞌbadrị́ ꞌbá ãmbogo rú ãtiꞌbo kí drị̃lẹ́ gá ꞌdĩ ꞌbã kí sĩ kí ĩkpãjó rĩ rá, ánị̃ drị̃cị́rị̃ ĩꞌbadrị̂ rá ãzíla áꞌbã ásị́ kí drị̃ gá rá. ");
INSERT INTO luc_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ị́jọ́ ꞌdĩ sĩ ma asị́ vụ̃rụ́ sĩ amụ́jó kí pajó ꞌbá Mị̃sị́rị̃ gá ꞌdĩ kí drị́ gá ãzíla ma kí anzé agụlé ãmvé ãngũ málĩ trũ ãlá mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ lé ꞌbã sĩ rajó ala gá ãnụ́ úsã be rĩ gá, ꞌdĩ ãngũ Kãnánĩ, Hị́tị̃, Ãmọ́rị̃, Pẹ̃rẹ́zị̃, Hị́vị̃, ãzíla Yẹ̃bụ́sị̃ ꞌbadrị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Úꞌdîꞌda rĩ gá má are áwáŋá ꞌbá mádrị́ Ịsịrayị́lị̃ ꞌbadrị̂ rá, ãzíla ándre gẹ̃rị̃ ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbaní kí ĩkpãjó rĩ rá. ");
INSERT INTO luc_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ị́jọ́ ꞌdĩ sĩ úꞌdîꞌda ímụ, ma ími tị pẽ Fãráwũ úpí Mị̃sị́rị̃ gá rĩ rụ́ mi dó sĩ ꞌbá mádrị́ Ịsịrayị́lị̃ drị̂ kí anzé sụ́rụ́ ĩꞌdidrị̂ agá ꞌdãá rĩ sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Wó Mụ́sã jọ Ãdróŋá ní, “Ma dó ãꞌdi ꞌi, mání sĩ mụjó Fãráwũ rụ́ ãzíla sĩ ꞌbá Ịsịrayị́lị̃ drị̂ kí ajíjó Mị̃sị́rị̃ gâlé rá?” ");
INSERT INTO luc_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ãdróŋá umvi, “Ma adru mí be. Ãzíla ícétáŋá ꞌdĩ la adru mí be iꞌdajó la míní ápẽ ími tị ma ꞌi: ídrĩ ꞌbá ꞌdĩ kí ají ãmvé Mị̃sị́rị̃ gâlé rĩ sĩ rá, ĩmi dó áma ị̃nzị̃ ꞌbé ꞌdĩ drị̃ gá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mụ́sã jọ Ãdróŋá ní, “Ádrĩ dó mụ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌba rụ̂lé ãzíla ádrĩ jọ la ĩꞌbaní, ‘Ãdróŋá ĩmĩ áyị́pịka ꞌbadrị̂ ãpẽ áma tị nĩ,’ ãzíla drĩ kí áma zị, ‘Rụ́ la dó ãꞌdi ꞌi?’ Ma dó ĩꞌbaní ãꞌdu lũ yã?” ");
INSERT INTO luc_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ãdróŋá jọ Mụ́sã ní, “MA MÂ NGÁ MA ꞌI. ꞌDĩ bãsĩ ị́jọ́ míní mụlé jọlé ꞌbá Ịsịrayị́lị̃ drị̂ ꞌ ꞌbaní rĩ ꞌi: ‘MA MA ꞌI ãpẽ áma tị ĩmi rụ́ ꞌdõlé nĩ.’” ");
INSERT INTO luc_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ãdróŋá jọ vâ Mụ́sã ní, “Íjọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbanî, ‘Úpí Ãdróŋá ĩmĩ áyị́pịka, Ãdróŋá Ịbụrahị́mụ̃ drị̂, Ãdróŋá Ĩsákã drị̂ ãzíla Ãdróŋá Yãkóꞌbõ drị̂ ãpẽ áma tị nĩ.’ ꞌDĩ áma rụ́ jãꞌdâ rĩ ꞌi, ꞌdĩ rụ́ Mádrị́ anzị pírí drị̃lẹ́ gâlé rĩ ꞌbã kí sĩ áma umvejó jãꞌdâ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Ímụ, ítra ꞌbá ĩyõ Ịsịrayị́lị̃ drị̂ kí ãzíla íjọ ĩꞌbaní, ‘Úpí Ãdróŋá ĩmĩ áyị́pịka ꞌbadrị̂, Ãdróŋá Ịbụrahị́mụ̃ drị̂, Ĩsákã drị̂ ãzíla Yãkóꞌbõ drị̂ iꞌda ru mání ãzíla jọ: Má amụ́ ĩꞌba rú ꞌdõlé ꞌbo ãzíla ándre ị́jọ́ ꞌbá Mị̃sị́rị̃ drị̂ ꞌba kí idélé ĩꞌba rú rĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Áꞌbã áma ásị́ gá ĩmi anzéjó ãmvé angájó Mị̃sị́rị̃ gâlé, ãngũ ꞌbá ꞌbã kí ĩminí ũcõgõ fẽjó rĩ gâlé rá, ãzíla ma ĩmi agụ ãngũ málĩ trũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ lé ꞌbã sĩ rajó ala gá ãnụ́ úsã be rĩ gá, ꞌbá Kãnánĩ, Hị́tị̃, Ãmọ́rị̃, Pẹ̃rẹ́zị̃, Hị́vị̃, ãzíla Yẹ̃bụ́sị̃ rú rĩ ꞌbadrị̂ agá.’ ");
INSERT INTO luc_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“ꞌBá drị̃lẹ́ ru Ịsịrayị́lị̃ drị̂ kí ị́jọ́ míní jọlé ĩꞌbaní rĩ are rá. Ĩmi dó mụ ꞌbá ĩyõ ꞌdĩ abe úpí Mị̃sị́rị̃ gá rĩ rụ́ ãzíla ĩmi jọ la, ‘Úpí Ãdróŋá ꞌbá Ĩbũrãníyã rú rĩ ꞌbadrị̂ iꞌda ru ãmaní. Ífẽ ãmụ ụ́ꞌdụ́ na, ãma dó sĩ mụ ídétáŋá idélé Úpí Ãdróŋá ãmadrị̂ nî.’ ");
INSERT INTO luc_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Wó ánị̃ rá úpí Mị̃sị́rị̃ drị̂ icó ĩminí ãꞌị̃lé mụlé ku kpere ála ĩꞌdi ũŋmĩ agá drị́ ũkpó sĩ rá ká. ");
INSERT INTO luc_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ị́jọ́ ꞌdĩ sĩ ma áma drị́ tị̃ Mị̃sị́rị̃ ụrụꞌbá gá ãzíla ma ꞌbá Mị̃sị́rị̃ drị̂ ꞌbaní drị̃rịma fẽ ị́jọ́ ụ̃sụ̃táŋá ru mání mụlé idélé kí drĩdríŋĩ gá rĩ sĩ. ꞌDã ꞌbã ũngúkú gá, ĩꞌdi dó ĩmi aꞌbe mụlé rá. ");
INSERT INTO luc_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Ma ꞌbá Mị̃sị́rị̃ gá ꞌdĩ kí ásị́ gá lẽtáŋá fẽ, drĩ kí dó sĩ ĩmi ndre, kí dó sĩ ĩminí ãko kí fẽ, ị́jọ́ ꞌdĩ sĩ ĩmụ dó sĩ drị́drị́ ru ku. ");
INSERT INTO luc_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ũkú ãlu-ãlu Ịsịrayị́lị̃ rú rĩ la mụ jĩránĩ ĩꞌdidrị́ Mị̃sị́rị̃ rú rĩ drị̂lé ãzíla ũkú cí Mị̃sị́rị̃ rú uꞌálépi ĩꞌdidrị́ jó agá rĩ drị́ ãko ꞌdĩ kí aꞌị́lé: Sílĩvã, gólũdĩ ãzíla bõngó kí abe. Ũkú Ịsịrayị́lị̃ drị̂ kí dó sĩ kí sụ̃ anzị ãgọbị rú rĩ kí ụrụꞌbá gá izonzi kí abe. Ĩmi dó sĩ málĩ ꞌbá Mị̃sị́rị̃ rú rĩ ꞌbadrị̂ kí upa rá.” ");
INSERT INTO luc_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mụ́sã umvi Ãdróŋá ní, “Wó ꞌbá Ịsịrayị́lị̃ drị̂ drĩ kí ị́jọ́ mání jọlé rĩ ãꞌị̃ ku jõku drĩ kí ị́jọ́ áma tị gá rĩ gã arelé úmgbé, drĩ kí jọ la, ‘Úpí iꞌda ru míní ku rĩ gá’?” ");
INSERT INTO luc_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Úpí zị ĩꞌdi, “Ãko ími drị́ gá ꞌdĩ ãꞌdu?” Mụ́sã umvi “Ãko áma drị́ gá ꞌdõ túré,” ");
INSERT INTO luc_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Úpí jọ ĩꞌdiní, “Íꞌbe ĩꞌdi vũ gá.” Mụ́sã ꞌbe túrê vũ gá ãzíla túrê uja ru ị̃nị̃ rú! Mụ́sã mvu apálé rá. ");
INSERT INTO luc_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Úpí uja jọlé la ĩꞌdiní, “Ísu ími drị́ ãzíla írụ ĩꞌdi kótẽ gá.” Ị́jọ́ ꞌdĩ sĩ, Mụ́sã su ru drị́ aꞌdụ́ ị̃nị̃ ꞌi, ãzíla ị̃nị̃ uja dó ru ĩꞌdidrị́ gá ꞌdâ túré rú. ");
INSERT INTO luc_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Úpí jọ ĩꞌdiní, “Mí idé tálí ꞌdĩ ꞌi, kí dó sĩ ãꞌị̃ la Úpí Ãdróŋá ĩꞌbã áyị́pịka ꞌbadrị̂, ꞌdĩ Ãdróŋá Ịbụrahị́mụ̃ drị̂, Ĩsákã drị̂ ãzíla Yãkóꞌbõ drị̂ iꞌda ru míní nĩ.” ");
INSERT INTO luc_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ꞌDã ꞌbã ũngúkú gá, Úpí jọ, “Ísu ími drị́ bõngó agâlé.” Ị́jọ́ ꞌdĩ sĩ, Mụ́sã su dó ru drị́ bõngó agâlé, ĩꞌdi dó mụ anzélé la ãmvé ꞌbo, ãrí na drị́ la rá, íní la acá imve rú cécé sí áni. ");
INSERT INTO luc_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ãdróŋá jọ vâ, “Ísu ími drị́ vúlé bõngó agâlé.” Mụ́sã su vâ ru drị́ vúlé bõngó agâlé, ĩꞌdi mụ anzélé la ꞌbo, drị́ la acá ãlápítí ru cécé ĩꞌdi ꞌbã ụrụꞌbá ꞌbã úkõ ãzí gá rĩ kí áni. ");
INSERT INTO luc_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ꞌDã ꞌbã ũngúkú gá, Ãdróŋá jọ, “Drĩ kí ị́jọ́ mídrị̂ ãꞌị̃ ku jõku drĩ kí gã ásị́ ꞌbãlé ícétáŋá drị̃drị̃ rĩ drị̃ gá úmgbé, kí icó ícétáŋá úꞌdîꞌda ꞌdĩ ãꞌị̃lé rá. ");
INSERT INTO luc_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Wó drĩ kí ícétáŋá úꞌdîꞌda ꞌdĩ ãꞌị̃ ku jõku drĩ kí gã ị́jọ́ arelé ími tị gá úmgbé, mí ãbĩ ị̃yị́ Mĩrĩ Náyĩlĩ drị̂ ꞌi ãzíla ísũ ĩꞌdi vũ gá. Ị̃yị́ míní ãbĩlé Mĩrĩ Náyĩlĩ gá rĩ la ru uja vũ gá ꞌdãá ãrí ru.” ");
INSERT INTO luc_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ị́jọ́ ꞌdĩ sĩ Mụ́sã jọ Úpí nî, “Úpí, ma mâ ngá ꞌbá ị́jọ́ ulílépi túlí-túlí ku la, ándrá ídu ãzíla sáwã míní iꞌdójó ị́jọ́ jọjó ãtíꞌbó mídrị̂ be ꞌdĩ agá ꞌdâ. Áma ĩdra nị̃ ꞌbãngá ị́jọ́ ulí sĩ ku, ma ị́jọ́ jọ jã-jã rú.” ");
INSERT INTO luc_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Úpí jọ ĩꞌdiní, “Ãꞌdi la ꞌbá ꞌbá ru rĩ ní tị ị́jọ́ jọjó rĩ fẽ nĩ yã? Ãꞌdi la ĩꞌdi fẽ adrulé bị́lẹ́ kóru jõku ị́jọ́ jọjó ku la nĩ yã? Ãꞌdi la ĩꞌdiní mịfị́ fẽ sĩ ãngũ ndrejó jõku ĩꞌdi fẽ adrulé mịfị́ kóru ãngũ ndrejó ku la nĩ yã? Adru ma ꞌI, Úpí ꞌi ku yã? ");
INSERT INTO luc_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Úꞌdîꞌda ímụ dô, ma mụ ími ãzã kolé ãzíla ími imbálé ị́jọ́ míní mụlé jọlé rĩ kî sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Wó Mụ́sã jọ, “Úpí, ípẽ rá la ꞌbá ãzí ndú la tị áyụ.” ");
INSERT INTO luc_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ị́jọ́ ꞌdĩ sĩ, Úpí acá dó Mụ́sã ní ũmbã sĩ ãzíla jọ dó, “Mí ádrị́pị Ãrọ́nị̃ Lẹ́vị̃ rú rĩ ãꞌdu rú yã? Ánị̃ rá icó ị́jọ́ jọlé múké-múké rá. Ĩꞌdi dó úꞌdîꞌda ãni rú gẹ̃rị̃ gá sĩ drị̃ ụfụjó mí be, Ãrọ́nị̃ la adru ãyĩkõ sĩ ĩꞌdi ꞌbã ími ndrejó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Mĩ mụ ị́jọ́ jọlé ĩꞌdiní ãzíla ĩꞌdiní lũlé la ꞌbã jọ ãꞌdu ị́jọ́ yã rĩ; Ma mụ ĩmi ãzã kolé ị̃rị̃trá sĩ ị́jọ́ jọjó ãzíla ĩmi imbálé ị́jọ́ ĩminí mụlé ngalé rĩ kí sĩ. ");
INSERT INTO luc_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ĩꞌdi mụ ị́jọ́ jọlé ũꞌbí ꞌbaní ími kẹ̃jị́ gá ãzíla ĩꞌdi adru cécé ĩꞌdi ꞌbã rĩ ími tị ãzíla mi ꞌbã rĩ ĩꞌdiní Ãdróŋá rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Wó íꞌdụ túré ꞌdĩ ími drị́ gá ĩndĩ, mi dó sĩ mụ ícétáŋá tálí ru rĩ kí idélé.” ");
INSERT INTO luc_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ꞌDã ꞌbã ũngúkú gá, Mụ́sã gõ dó vúlé ĩꞌdi ꞌbã ándrị́pị Yétẽrõ rụ́ ãzíla jọ ĩꞌdiní, “Ífẽ ágõ vúlé ꞌbá mádrị́ Mị̃sị́rị̃ gá rĩ ꞌba rụ́ sĩ ndrejó la ĩꞌbã ãzí ace kí nõ ídri rú rá yã áni.” Yétẽrõ jọ, “Ímụ, ãzíla mí acị́ múké.” ");
INSERT INTO luc_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Sáwã Mụ́sã ꞌbã adrujó Mị̃dị́yánị̃ gá rĩ sĩ, Úpí jọ ĩꞌdiní, “Ígõ vúlé Mị̃sị́rị̃ gâlé, ãꞌdusĩku ꞌbá ándrá ími ndrụ̃lépi sĩ ími ꞌdịjó rĩ ũdrã kí dó úꞌdîꞌda rá.” ");
INSERT INTO luc_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ị́jọ́ ꞌdĩ sĩ, Mụ́sã ꞌdụ ĩꞌdi ꞌbã ũkû ꞌi anzị kí abe, ꞌbã dó kí kãyĩnõ sị́ gá ãzíla ko dó drị̃ gõlé Mị̃sị́rị̃ gá. ꞌDụ dó túré Ãdróŋá ꞌbã lũlé ĩꞌdiní rĩ ĩꞌdidrị́ gá ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Úpí jọ Mụ́sã ní, “Ídrĩ gõ vúlé Mị̃sị́rị̃ gâlé ꞌbo, lẽ mí idé Fãráwũ drị̃lẹ́ gá tálí mání sĩ ũkpõ fẽjó míní mí idé kí rĩ kí pírí. Wó ma mụ ĩꞌdi ásị́ fẽlé mbalé ũkpómgboroto rú ãzíla icó ꞌbá ꞌdĩ kí aꞌbelé mụlé ku. ");
INSERT INTO luc_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ꞌDã ꞌbã ũngúkú gá, ílũ Fãráwũ ní, ‘Úpí jọ: Ịsịrayị́lị̃ ĩꞌdi ngọ́tị́ŋá má drị́ kãjãní rĩ ꞌi ");
INSERT INTO luc_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","mání jọlé míní ꞌbo rĩ áni, “Ífẽ ngọ́tị́ŋá mádrị̂ ꞌbã mụ, ĩꞌdi dó sĩ áma ị̃nzị̃ be nĩ.” Wó ígã ĩꞌdi aꞌbelé úmgbé, ị́jọ́ ꞌdĩ sĩ ma mî ngọ́tị́ŋá kãjãní rĩ ꞌdị rá!’” ");
INSERT INTO luc_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mụ́sã ꞌbã mụ agá gẹ̃rị̃ gá ꞌdâ, ca ãngũ sĩ ụ́ꞌdụ́ kojó la gá, ụfụ kí drị̃ Úpí be ãzíla Ãdróŋá apá ĩꞌdi ꞌdị sĩ. ");
INSERT INTO luc_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Wó Zĩpórã Mụ́sã ꞌbã ũkû aꞌdụ́ ị́lị́ŋá sị́ ãcí la, ĩtãrã dó sĩ ngọ́pị̃ ꞌi ãzíla aló íníríkó la sĩ Mụ́sã ꞌbã pá. Jọ, “Ãndá-ãndá ru mi ágó mádrị́ ãrí sĩ rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ị́jọ́ ꞌdĩ sĩ, Úpí aꞌbe dó Mụ́sã rá. (Ị́jọ́ Zĩpórã ꞌbã jọlé “Mi ágó mádrị́ ãrí sĩ rĩ ꞌi,” rĩ ꞌbã ífí ꞌbá ĩtãrãjó rĩ.) ");
INSERT INTO luc_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Wó íni ꞌdĩ Úpí jọ Ãrọ́nị̃ ní, “Ímụ kõtórõ agâlé sĩ drị̃ ụfụjó Mụ́sã be.” Ị́jọ́ ꞌdĩ sĩ, Ãrọ́nị̃ ụfụ kí dó drị̃ Mụ́sã be ꞌbé Ãdróŋá drị̂ drị̃ gá ãzíla amvu kí dó ru ãyĩkõ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ꞌDã ꞌbã ũngúkú gá, Mụ́sã nze Ãrọ́nị̃ ní ị́jọ́ pírí Úpí ꞌbã ĩꞌdi tị pẽjó ꞌbã mụ kí jọlé rĩ kí vú ãzíla ícétáŋá tálí ru pírí Úpí ꞌbã azịlé ꞌbã mụ kí idélé rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mụ́sã atrá kí Ãrọ́nị̃ be ꞌbá ĩyõ Ịsịrayị́lị̃ drị̂ kí pírí, ");
INSERT INTO luc_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ãzíla Ãrọ́nị̃ nze ĩꞌbaní ị́jọ́ Úpí ꞌbã jọlé Mụ́sã ní ri kí vú pírí. Idé vâ ꞌbá kí drị̃lẹ́ gá ícétáŋá tálí ru rĩ kí ĩndĩ, ");
INSERT INTO luc_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ị́jọ́ ꞌdĩ sĩ ꞌbá Ịsịrayị́lị̃ drị̂ ãꞌị̃ kí dó rá. Kí dó mụ arelé la Úpí así dó kí ị́jọ́ sĩ rá ãzíla ndre dó ũcõgõ ĩꞌbadrị̂ ꞌbo íni, su kí dó drị̃ vũ gá sĩ ị̃nzị̃táŋá fẽjó Úpí nî. ");
INSERT INTO luc_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Mụ́sã ꞌbã kí Ãrọ́nị̃ be ị́jọ́ jọjó ꞌbá ĩyõ drị̃lẹ́ ru Ịsịrayị́lị̃ drị̂ kí abe ꞌbo rĩ ꞌbã vúlé gá, mụ kí dó úpí Mị̃sị́rị̃ drị̂ rụ́ ãzíla jọ kí ĩꞌdiní, “Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ jọ, ‘Mí aꞌbe ꞌbá mádrị̂ ꞌbã mụ kí, kí dó sĩ mụ ụ̃mụ̃ ꞌbãlé sĩ áma ị̃nzị̃jó ãngũ kõtórõ rú rĩ agâlé.’” ");
INSERT INTO luc_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Fãráwũ jọ, “Úpí la ꞌdĩ dó ãꞌdi ꞌi, mání ĩꞌdiní ị̃nzị̃táŋá fẽjó ãzíla ꞌbá Ịsịrayị́lị̃ drị̂ kí aꞌbejó mụjó rĩ? Ánị̃ Úpí la ĩmi ãni ꞌdĩ ku ãzíla má icó ꞌbá Ịsịrayị́lị̃ drị̂ kí aꞌbelé mụlé ku.” ");
INSERT INTO luc_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ꞌDãá jọ kí, “Ãdróŋá Ĩbũrãníyã drị̂ iꞌda ru ãmaní úꞌdîꞌda íni, lẽ ãꞌdụ ãcị̃ ãzí ụ́ꞌdụ́ na ãni la sĩ mụjó ãngũ kõtórõ rú rĩ agâlé sĩ mụjó ídétáŋá idéjó Úpí Ãdróŋá ãmadrị̂ ní, jõ íni ku ĩꞌdi ãma ị̃lị̃kị̃ jụ́wẹ̃ sĩ jõku ãꞌdị́ sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Wó úpí Mị̃sị́rị̃ drị̂ jọ, Mụ́sã ꞌbaní Ãrọ́nị̃ be, “Ĩmi ꞌbá kí ꞌdụ ãzị́ ĩꞌbadrị̂ kí tị gá ꞌdâ rá la ãꞌdu sĩ? Ĩgõ vúlé ãzị́ ĩmidrị̂ kí tị gâlé!” ");
INSERT INTO luc_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Fãráwũ jọ vâ, “Ĩndre drĩ ꞌbá Ịsịrayị́lị̃ drị̂ kí dó ãngũ drị̃ gá ꞌdâ ũꞌbí ru, ãzíla ĩlẽ vâ kí atrịlé ãzị́ ngaŋá gá cí.” ");
INSERT INTO luc_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ụ́ꞌdụ́ ꞌdã sĩ Fãráwũ ꞌbã ãzị́táŋá ꞌbá ãmbogo rú ãtiꞌbo kí drị̃lẹ́ gá ãzíla ꞌbá Ịsịrayị́lị̃ rú ãzị́ pámvú undrélépi rĩ abe: ");
INSERT INTO luc_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Ĩfẽ ꞌbá ꞌdĩ ꞌbaní ásé sĩ bị̃rị́kị̃ ꞌbejó la ị̃dị́ ku, ꞌbã ndrụ̃ kí ásé cénĩ. ");
INSERT INTO luc_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Wó ĩfẽ ꞌbã ꞌbe kí kãlãfe bị̃rị́kị̃ drị́ jõ lịlẹ́ kí drị̃ gá ídu rĩ ꞌi; ĩmi isé bị̃rị́kị̃ ꞌbã kãlãfe vúlé ku. Ũvũ la kí fẽ awálé sĩ jọjó la ãma tá mụ ídétáŋá idélé Ãdróŋá ãmadrị̂ ní rĩ gá nĩ. ");
INSERT INTO luc_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ĩꞌbã ãzị́ ãgọbị kí drị̃ gá ũkpó ru, kí dó sĩ ị́jọ́ ãvĩ ĩnzõ drị̃ gá rá, be la kí dó sĩ ásị́ ꞌbã ãzị́ ngalé áyụ.” ");
INSERT INTO luc_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ꞌDã ꞌbã vúlé gá ꞌbá ãmbogo rú ãtiꞌbo kí drị̃lẹ́ gá ãzíla ꞌbá Ịsịrayị́lị̃ rú ãzị́ pámvú undrélépi rĩ kí abe mụ kí dó ꞌbá ꞌba rụ́ ãzị́ ãngũ gâlé ị́jọ́ ꞌdĩ lũjó ꞌbá ꞌbanî. Jọ kí, “ꞌDĩ ị́jọ́ Fãráwũ ꞌbã jọlé rĩ ꞌi: ‘Má icó ĩminí ásé sĩ bị̃rị́kị̃ ꞌbejó rĩ fẽlé ị̃dị́ ku. ");
INSERT INTO luc_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ĩmụ ásé ĩmidrị́ sĩ bị̃rị́kị̃ ꞌbejó rĩ kí ndrụ̃ trũ, ĩmụ ãngũ ĩminí sĩ icójó ịsụ́jó la rá rĩ gâlé wó ãzị́ ĩminí ngalé rĩ ûmvi úmgbó la vúlé ãluŋá la ku.’” ");
INSERT INTO luc_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ị́jọ́ ꞌdĩ sĩ, ꞌbá iré kí dó ru ãngũ Mị̃sị́rị̃ drị̂ agâ sĩ pírí mụjó ásé ndrụ̃ trũ. ");
INSERT INTO luc_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ꞌBá ãmbogo rú ãtiꞌbo kí drị̃lẹ́ gá rĩ ri kí ꞌbá ꞌdĩ ꞌbaní ũcõgõ fẽlé, jọjó la, “Lẽ ĩde bị̃rị́kị̃ lẽlé ĩmidrị́ ụ́ꞌdụ́ ãlu-ãlu sĩ rĩ cécé jõ ĩminí ásé bị̃rị́kị̃ ꞌbejó rĩ fẽjó bábá rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ꞌBá ãmbogo rú ãtiꞌbo kí drị̃lẹ́ gá Ịsịrayị́lị̃ rú Fãráwũ ꞌbã ũꞌbãlé rĩ kí úco kí ãzíla úzị kí, “Ĩde bị̃rị́kị̃ lịlẹ́ ĩmi drị̃ gá ájẹ ãzíla ãndrũ rĩ kí ꞌbelé ku ãꞌdu sĩ?” ");
INSERT INTO luc_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ị́jọ́ ꞌdĩ sĩ, ꞌbá Ịsịrayị́lị̃ rú ãzị́ pámvú undrélépi ꞌdĩ mụ kí ãzíla ꞌbã kí mãmálá Fãráwũ rụ́: “Mí idé dó ị́jọ́ ãtiꞌbo mídrị̂ ꞌba rụ́ ꞌdĩ ꞌbã áni ãꞌdu ị́jọ́ sĩ yã? ");
INSERT INTO luc_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Újọ ãmaní, lẽ úfẽ ãtiꞌbo mídrị̂ ꞌbaní ásé sĩ bị̃rị́kị̃ ꞌbejó rĩ ku, ãꞌbe vâ bị̃rị́kị̃, ála dị̃ ãma co sĩ, ꞌdĩ adru izatáŋá ãtiꞌbo mídrị̂ ꞌbaní la ku wó ꞌbá mídrị̂ ꞌbã ni la.” ");
INSERT INTO luc_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Fãráwũ jọ, “ꞌDĩ ũvũ, ĩmi ũvúꞌbá! ꞌDĩ bã sĩ ị́jọ́ ĩminí sĩ jọjó la, lẽ ãmụ kí ídétáŋá idélé Úpí nî ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ị́jọ́ ꞌdĩ sĩ, ĩmụ ãzị́ gá. Ícó ĩminí ásé bị̃rị́kị̃ ꞌbejó rĩ fẽlé ku, wó lẽ ĩde kãlãfe bị̃rị́kị̃ ãni lịlẹ́ ĩmi drị̃ gá rĩ kí ꞌbelé pírí lẽlé rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ꞌBá Ịsịrayị́lị̃ rú ãzị́ pámvú undrélépi ꞌdĩ kí dó mụ ị́jọ́ jọlé ĩꞌbaní, “Lẽ ísé kãlãfe bị̃rị́kị̃ drị́ ĩꞌbaní ꞌbelé ụ́ꞌdụ́ ãlu-ãlu sĩ rĩ ku ꞌdĩ arelé ꞌbo, nị̃ kí dó rá kí dó ũcõgõ ãmbógó la agá.” ");
INSERT INTO luc_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Kí mụ Fãráwũ aꞌbelé ꞌbo, ịsụ́ kí Mụ́sã kí Ãrọ́nị̃ be kí kí drị̃ tẽ agá sĩ ị́jọ́ jọjó ĩꞌba abe, ");
INSERT INTO luc_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","jọ kí ĩꞌbaní, “Lẽ Úpí ꞌbã ndre ị́jọ́ ĩmidrị̂ nĩ ãzíla ꞌbã lị ị́jọ́ ĩmi drị̃ gá nĩ! Ĩfẽ Fãráwũ ní ãtiꞌbo ĩꞌdidrị̂ kí abe ãma ãjị́ ngụ̃lé ãzíla ménéŋá ĩꞌdidrị́ ãꞌdị́ drị̂ sĩ ãma ụꞌdị́jó ĩmi ꞌi.” ");
INSERT INTO luc_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mụ́sã uja ru Úpí rụ̂lé jọ ĩꞌdiní, “Wáwọ̃ Úpí mí ají dó ũcõgõ ꞌbá ꞌdĩ kí drị̃ gá íni ãꞌdu sĩ? ꞌDĩ dó ị́jọ́ míní sĩ áma tị pẽjó ala gá rĩ ꞌi yã? ");
INSERT INTO luc_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Iꞌdójó mání mụ agá Fãráwũ drị̃lẹ́ gá ị́jọ́ jọjó ími rụ́ sĩ rĩ sĩ, Fãráwũ ají ũcõgõ ꞌbá Ịsịrayị́lị̃ drị́ ꞌdĩ ꞌbaní, wó ípa drĩ vâ ꞌbá mídrị́ ꞌdĩ kí ku.” ");
INSERT INTO luc_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ vâ Mụ́sã ní, “Úꞌdîꞌda mi mụ ị́jọ́ mání mụlé idélé Fãráwũ rụ́ rĩ ndrelé: Ãꞌdusĩku ma mụ ĩꞌdi ũŋmĩlé drị́ ũkpó sĩ sĩ ꞌbá ꞌdĩ kí tị pẽjó ãzíla kí drojó ãmvé ĩꞌdidrị́ sụ́rụ́ agá ꞌdâ rá.” ");
INSERT INTO luc_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ãdróŋá jọ vâ Mụ́sã ní, “Ma Úpí ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Má iꞌda ma Ịbụrahị́mụ̃ ní, Ĩsákã ní, ãzíla Yãkóꞌbõ ní Ãdróŋá Ũkpó ꞌDị́pị ꞌi, wó áma rụ́ Úpí ꞌdĩ má iꞌda ándrá ĩꞌbaní sĩ áma nịjó ku. ");
INSERT INTO luc_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ꞌDĩ ꞌbã drị̃ gâsĩ má itú ị́jọ́ tị icítáŋá icíjó ĩꞌba abe ãngũ Kãnánĩ drị̂ fẽjó ĩꞌbaní, ꞌdĩ ĩꞌbã kí uꞌájó ãla gá ãmị́yọ́ŋá ru rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ꞌDĩ ꞌbã drị̃ gâsĩ, má are ị́jọ́ ãzá taŋá ꞌbá Ịsịrayị́lị̃ ꞌbadrị́ gá rĩ drị̂ rá, ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbaní kí ꞌbãjó ãtíꞌbó ru rĩ, ãzíla má ũrã tị icítáŋá mádrị́ ĩꞌba abe rĩ ꞌbã ị́jọ́ ꞌbo. ");
INSERT INTO luc_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Ị́jọ́ ꞌdĩ sĩ, íjọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní: Ma Úpí ꞌi. Ma ĩmi anzé ị́jọ́ ĩminí adrujó ãtíꞌbó ru ꞌbá Mị̃sị́rị̃ gá ꞌdĩ ꞌbaní rĩ agá rá. Ma ũkpõ mádrị́ ãmbógó rĩ ayú sĩ ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbaní drị̃rịma ũnzí la fẽjó. Ma ĩmi anzé ĩminí adrujó ãtíꞌbó ru rĩ agá rá. ");
INSERT INTO luc_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ma ĩmi ꞌbã ꞌbá mgbã mádrị̂ kî rú, ma adru Ãdróŋá ĩmidrị̂ ꞌi, ĩmi adru ꞌbá mádrị̂ kî. Ị́jọ́ ꞌdĩ sĩ ĩmi dó sĩ nị̃ la rá ma Úpí Ãdróŋá ĩmidrị́ ĩmi anzélépi ị́jọ́ ĩminí adrujó ãtíꞌbó ru ꞌbá Mị̃sị́rị̃ gá ꞌdĩ ꞌbaní rĩ agá rĩ sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ma ĩmi ají ãngũ ándrá mání ũyõ najó ma fẽ la, Ịbụrahị́mụ̃ ní, Ĩsákã ní, ãzíla Yãkóꞌbõ ní rĩ gá; ãzíla ĩꞌdi adru ãko ĩminí la rú jãꞌdâ. Ma Úpí ꞌi.” ");
INSERT INTO luc_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mụ́sã jọ ị́jọ́ ꞌdĩ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, wó ꞌbá ꞌdã are kí tị la ku, ãꞌdusĩku ásị́ lã nũ kí rá ĩꞌbaní adrujó ãtíꞌbó ru ãzíla ꞌbání ãzị́ ãnzị ũdrõjó kí drị̃ gá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ꞌDã ꞌbã ũngúkú gá, Úpí jọ vâ Mụ́sã nî, ");
INSERT INTO luc_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Ímụ, íjọ úpí Mị̃sị́rị̃ drị̂ nî, ꞌbã aꞌbe ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã aꞌbe kí sụ́rụ́ ĩꞌdidrị̂ rá.” ");
INSERT INTO luc_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Wó Mụ́sã jọ Úpí ní, “ꞌBá Ịsịrayị́lị̃ rú rĩ drĩ kí áma tị are ku, Fãráwũ icó dó áma tị arelé íngoní ru, íni ꞌdĩ ị́jọ́ mání jọlé rĩ kí ũkpõ kọ́lị.” ");
INSERT INTO luc_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Úpí jọ ị́jọ́ Mụ́sã ꞌbaní Ãrọ́nị̃ be ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃ gá ãzíla Fãráwũ úpí Mị̃sị́rị̃ drị̂ ní. Úpí fẽ ãzị́táŋá Mụ́sã ꞌbaní Ãrọ́nị̃ ꞌbe sĩ ꞌbá Ịsịrayị́lị̃ drị̂ kí aꞌbe jó sĩ fũjó Mị̃sị́rị̃ gá rĩ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ꞌDĩ kí drị̃lẹ́ lị́cọ́ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbadrị̂ kî: Ngọ́tị́ kãyú Ịsịrayị́lị̃ drị́ Rụ́bẹ̃nị̃ ꞌbã anzị kí: Hãnókĩ ꞌi, Pálụ̃ ꞌi, Hẽzĩrónĩ ꞌi, ãzíla Kãrị̃mị̃ ꞌi. ꞌDĩ kí ínátị Rụ́bẹ̃nị̃ drị̂ kî. ");
INSERT INTO luc_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Anzị ãgọbị Sị̃mọ́nị̃ drị̂ kí: Yẹ̃mụ̃wẹ́lị̃ ꞌi, Yãmínĩ ꞌi, Ũhádĩ ꞌi, Yãkínĩ ꞌi, Zõhárĩ ꞌi ãzíla Sáwụ̃lụ̃ ũkú Kãnánĩ rú rĩ ꞌbã ngọ́pị ꞌi. ꞌDĩ kí ínátị Sị̃mọ́nị̃ drị̂ kî. ");
INSERT INTO luc_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ꞌDĩ kí anzị ãgọbị Lẹ́vị̃ drị̂ kí ꞌbã rụ́: Gẹ́rị́sọ̃nị̃ ꞌi, Kõhátĩ ꞌi, ãzíla Mẽrárĩ ꞌi. Lẹ́vị̃ uꞌá ílí 137. ");
INSERT INTO luc_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Anzị ãgọbị Gị́rị́sọ̃nị̃ drị̂ kí, ínátị la abe Lị̃bị́nị̃ kí Sị̃mẹ́yị̃ be. ");
INSERT INTO luc_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Anzị ãgọbị Kõhátĩ drị̂ kí Ãmũrámũ ꞌi, Ĩzíhã ꞌi, Hẹ̃bụ̃rọ́nị̃ ꞌi ãzíla Ụ̃zị̃yẹ́lị̃ ꞌi. Kõhátĩ uꞌá ílí 133. ");
INSERT INTO luc_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Anzị ãgọbị Mẽrárĩ drị̂ kí Máhĩlĩ kí Mụ́sị̃ be. ꞌDĩ kí ínátị Lẹ́vị̃ drị̂ kí ị́jọ́ sĩlé kí drị̃ gá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ãmũrámũ ĩgbã átẹ́pị̃ ꞌbã ámvọ́pị Yãkọ̃bẹ́dị̃ ꞌi, tị dó sĩ ĩꞌdiní Ãrọ́nị̃ kí Mụ́sã be. Ãmũrámũ uꞌá ílí 137. ");
INSERT INTO luc_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Anzị ãgọbị Ĩzíhã drị̂ kí rụ́: Kórã ꞌi, Néfẽgĩ ꞌi, ãzíla Zị́kị̃rị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Anzị ãgọbị Ụ̃zị̃yẹ́lị̃ drị̂ kí: Mị̃sị̃yẹ́lị̃ ꞌi, Ị̃lị̃záfãnị̃ ꞌi ãzíla Sítĩrĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ãrọ́nị̃ ĩgbã Ĩlĩsébã Ãmĩnãdábũ ị̃zẹ́pị ꞌdĩ Násõnĩ ꞌbã ámvọ́pị ꞌi, tị dó sĩ ĩꞌdiní Nãdábũ ꞌi, Ãbị́hụ̃ ꞌi, Ị̃lị̃yãzárị̃ ꞌi ãzíla Ĩtãmárĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Anzị ãgọbị Kórã drị̂ kí: Ãsírĩ ꞌi, Ĩlĩkánã ꞌi, ãzíla Ãbĩyãsáfũ ꞌi. ꞌDĩ kí anzị ínátị Kórã drị̂ kî. ");
INSERT INTO luc_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ị̃lị̃yãzárị̃ Ãrọ́nị̃ ngọ́pị ĩgbã Pụ̃tụ̃wẹ́lị̃ ꞌbã ị̃zẹ́pị ꞌi, tị dó sĩ ĩꞌdiní Fĩnẽhásĩ ꞌi. ꞌDĩ kí drị̃lẹ́ sụ́rụ́ Lẹ́vị̃ drị̂ kí ínátị ĩꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ãrọ́nị̃ kí Mụ́sã be ꞌbá ãlu ꞌdĩ kí vúŋá Úpí ꞌbã jọjó la, “Ĩmi ají ꞌbá mádrị́ Ịsịrayị́lị̃ drị̂ kí ãmvé angájó Mị̃sị́rị̃ gâlé ínátị ĩꞌbadrị̂ kí vú sĩ rĩ kî.” ");
INSERT INTO luc_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Mụ́sã kí Ãrọ́nị̃ be bãsĩ ꞌbá ándrá ị́jọ́ jọlépi úpí Mị̃sị́rị̃ gá rĩ ní Mị̃sị́rị̃ gâlé, ífẽ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã ãfũ kí Mị̃sị́rị̃ gâlé rá rĩ kî. ");
INSERT INTO luc_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Úpí la dó mụ ị́jọ́ jọlé Mụ́sã ní Mị̃sị́rị̃ gá ꞌdãá ꞌbo, ");
INSERT INTO luc_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","jọ Mụ́sã ní, “Ma Úpí ꞌi. Ílũ úpí Mị̃sị́rị̃ drị̂ ní ị́jọ́ mání jọlé míní rĩ kí pírí.” ");
INSERT INTO luc_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mụ́sã jọ Úpí ní, “Ị́jọ́ mání jọlé rĩ kí ũkpõ kọ́lị, Fãráwũ la dó áma tị are íngoní ru?” ");
INSERT INTO luc_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ní, “Índre drĩ, áꞌbã mi acájó Fãráwũ ní cécé Ãdróŋá áni, ãzíla mî ádrị́pị Ãrọ́nị̃ la adru nábị̃ mídrị́ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Lẽ ị́jọ ị́jọ́ mání azịlé míní rĩ kí pírí ãzíla mí ádrị́pị Ãrọ́nị̃ ꞌbã lũ Fãráwũ ní ꞌbã fẽ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã aꞌbe kí sụ́rụ́ ĩꞌdidrị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Wó ma Fãráwũ ásị́ ꞌbã mbajó mba-mbã, ãzíla ádrĩ táni ícétáŋá tálí ru rĩ kí kãlãfe itụ́ Mị̃sị́rị̃ gá rá tí, ");
INSERT INTO luc_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","icó ị́jọ́ míní jọlé rĩ kí arelé ku. Ị́jọ́ ꞌdĩ sĩ, ma dó mụ drị́ mádrị̂ tị̃lé Mị̃sị́rị̃ ụrụꞌbá gá ãzíla ị́jọ́ mání lịlẹ́ ũkpómgboroto rĩ sĩ ma ꞌbá sụ́rụ́ Ịsịrayị́lị̃ drị̂ kí anzé ãmvé ãngũ ꞌdĩ agâlé rá. ");
INSERT INTO luc_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Sáwã mání áma drị́ ĩjũjó sĩ drị̃rịma fẽjó ꞌbá Mị̃sị́rị̃ drị̂ ꞌbaní sĩ ꞌbá Ịsịrayị́lị̃ drị̂ kí anzéjó rĩ sĩ, ꞌbá Mị̃sị́rị̃ gá rĩ kí dó nị̃ la rá ma Úpí ꞌi.” ");
INSERT INTO luc_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mụ́sã kí Ãrọ́nị̃ be nga kí ị́jọ́ ꞌdĩ kí cécé Úpí ꞌbã azịlé ĩꞌbaní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Sáwã Mụ́sã ꞌbã kí Ãrọ́nị̃ be ị́jọ́ ꞌdĩ kí jọjó Fãráwũ ní rĩ sĩ, Mụ́sã ꞌbã ílí dó ꞌdĩ sĩ kãlị́ ãrõ ãzíla Ãrọ́nị̃ ꞌbã ílí dó ꞌdĩ sĩ kãlị́ ãrõ drị̃ na. ");
INSERT INTO luc_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Úpí jọ Mụ́sã ꞌbaní Ãrọ́nị̃ be, ");
INSERT INTO luc_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Fãráwũ drĩ jọ la ĩminí, ‘Ĩmi idé tálí ãzí,’ íjọ Ãrọ́nị̃ ní, ‘Mí aꞌdụ́ túré mídrị̂ íꞌbe ĩꞌdi vũ gá Fãráwũ drị̃lẹ́ gá ꞌdâ,’ ãzíla ĩꞌdi ru uja ị̃nị̃ rú.” ");
INSERT INTO luc_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ị́jọ́ ꞌdĩ sĩ, Mụ́sã mụ kí Ãrọ́nị̃ be Fãráwũ rụ́ ãzíla nga kí ị́jọ́ kí cécé Úpí ꞌba azịlé ĩꞌba ní rĩ áni. Ãrọ́nị̃ ꞌbe dó túré ĩꞌdidrị́ gá rĩ Fãráwũ drị̃lẹ́ gá ꞌbá ĩꞌdidrị́ ãtiꞌbo rú rĩ kí abe, túrê uja dó sĩ ru ị̃nị̃ rú. ");
INSERT INTO luc_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Fãráwũ umve ꞌbá ĩꞌdidrị́ ũndũwá ru Mị̃sị́rị̃ gá rĩ kí ãzíla ꞌbá ãzị́ ngalépi ũjogo kí pálé gá rĩ kí abe, idé kí vâ tálí ãlu ꞌdĩ kí vúŋá ũkpõ ĩꞌbadrị́ ndrelé ku rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Kí ãlu-ãlu pírí uꞌbé kí túré ĩꞌbadrị̂ kí vũ gá ãzíla uja kí ru ị̃nị̃ rú. Wó túré Ãrọ́nị̃ drị̂ uti dó túré ĩꞌbadrị̂ kí pírí. ");
INSERT INTO luc_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ị́jọ́ ꞌdĩ kí agâ sĩ pírí tí Fãráwũ ꞌbã ásị́ mba ũkpómgboroto rú ãzíla are ị́jọ́ ꞌbá ꞌdĩ ꞌbadrị̂ kí ku, cécé Úpí ꞌbã jọlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ní, “Fãráwũ ꞌbã ásị́ mba ũkpómgboroto rú; uga ꞌbá ꞌdĩ kí mụlé úmgbé. ");
INSERT INTO luc_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ímụ drị̃ ụfụlé ụ̃ꞌbụ́tị sĩ Fãráwũ be ĩꞌdi ꞌbã mụ agá Mĩrĩ Náyĩlĩ tị gâlé rĩ gá ꞌdĩ. Íꞌdụ ími drị́ gá túré ándrá ru ujalépi ị̃nị̃ rú rĩ ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ꞌDã ꞌbã ũngúkú gá, íjọ ĩꞌdiní, ‘Úpí Ãdróŋá ꞌbá Ĩbũrãníyã rú rĩ ꞌbadrị̂ ãpẽ áma tị sĩ jọjó la míní: “Mí aꞌbe ꞌbá mádrị̂ ꞌbã mụ kî, ị́jọ́ ꞌdĩ sĩ kí dó sĩ mụ áma ị̃nzị̃lé kõtórõ agâlé.” Wó kpere úꞌdîꞌda mí are drĩ ị́jọ́ ꞌdĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ꞌDĩ ị́jọ́ Úpí ꞌbã jọlé rĩ: “Ị́jọ́ ꞌdĩ sĩ mi dó nị̃ la rá ma Úpí ꞌi: Túré áma drị́ gá ꞌdĩ sĩ ma Mĩrĩ Náyĩlĩ ꞌa gbã, ãzíla ĩꞌdi ru uja ãrí ru. ");
INSERT INTO luc_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ị̃ꞌbị Mĩrĩ Náyĩlĩ agá ri kí ũdrã rá, ãzíla ị̃yị́ la mụ ngụ̃lé; ꞌbá Mị̃sị́rị̃ gá rĩ icó kí ị̃yị́ ꞌdĩ mvụlẹ́ ku.”’” ");
INSERT INTO luc_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Úpí jọ Mụ́sã ní, “Ílũ Ãrọ́nị̃ ní, ‘Íꞌdụ túré mídrị̂ ꞌi mí inga trũ ími drị́ ị̃yị́ Mị̃sị́rị̃ drị̂ kí drị̃ gá wọ́rọ̃ŋá kí, lọ̃rọ́ kí, kẹ̃bẹ̃lụ́ kí drị̃ gá ãzíla ãngũ ị̃yị́ tã mbajó rĩ kí agá pírí, ị́jọ́ ꞌdĩ sĩ kí sĩ ru uja ãrí ru. Ãrí la mụ adrulé ãngũ Mị̃sị́rị̃ drị̂ agá pírí, kpere ãkójó idélé ife sĩ rĩ kí agá ãzíla írã sĩ rĩ kí abe.’” ");
INSERT INTO luc_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mụ́sã idé kí Ãrọ́nị̃ be cécé Úpí ꞌbã azịlé ĩꞌba ní rĩ áni. Ãrọ́nị̃ inga túré ĩꞌdidrị̂ Fãráwũ drị̃ gâsĩ ãmbogo ĩꞌdidrị̂ abe ãzíla gbã dó sĩ Mĩrĩ Náyĩlĩ drị̂ ꞌa, ị̃yị́ pírí uja kí dó ru ãrí ru. ");
INSERT INTO luc_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ị̃ꞌbị Mĩrĩ Náyĩlĩ gá rĩ ũdrã kí rá, ãzíla ị̃yị́ ꞌbã ĩmŋã ngụ̃lépi rĩ sĩ ꞌbá Mị̃sị́rị̃ gá rĩ icó kí ị̃yị́ mvụlé ku. Ãrí ri adrulé ãngũ Mị̃sị́rị̃ drị̂ agá pírí rá ru. ");
INSERT INTO luc_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Wó ꞌbá Mị̃sị́rị̃ gá ũjogo rú ãzíla ꞌbá ãzị́ ngalépi ũjogo kí pálé gá rĩ kí abe idé kí vâ tálí ãlu ꞌdĩ kí vúŋá ũkpõ ĩꞌbadrị́ ndrelé ku rĩ sĩ, ãzíla Fãráwũ ꞌbã ásị́ mba ũkpómgboroto rú; icó dó sĩ Mụ́sã kí tị arelé Ãrọ́nị̃ be ku, cécé Úpí ꞌbã ándrá jọlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Rá la Fãráwũ uja ru filé lị́cọ́ ĩꞌdidrị́ ãmbõgõ drị̂ agá, ãzíla ꞌbã ásị́ ị́jọ́ ꞌdĩ kí drị̃ gá ku. ");
INSERT INTO luc_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ꞌBá pírí Mị̃sị́rị̃ gá rĩ ga kí ꞌbụ́ Mĩrĩ Náyĩlĩ tị gâsĩ ị̃yị́ mvụlé mvụ-mvụ̃ rĩ ịsụ́jó, ãꞌdusĩku ĩꞌbã kí icójó ị̃yị́ Mĩrĩ Náyĩlĩ drị̂ mvụjó ku rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ụ́ꞌdụ́ alị kí ázị̂rị̃ sáwã Úpí ꞌbã Mĩrĩ Náyĩlĩ ꞌa gbãjó ꞌbo rĩ ꞌbã vúlé gá. ");
INSERT INTO luc_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ní, “Ímụ Fãráwũ rụ̂lé íjọ ĩꞌdiní, ‘ꞌDĩ ị́jọ́ Úpí ꞌbã jọlé rĩ ꞌi: Mí aꞌbe ꞌbá mádrị̂ ꞌbã mụ kî, ị́jọ́ ꞌdĩ sĩ, kí dó sĩ mụ áma ị̃nzị̃lé. ");
INSERT INTO luc_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ídrĩ kí uga mụlé úmgbé, Ma jụ́wẹ̃ ají ãngũ mídrị̂ agá, ụ́drụ́gọ́ kí ãfũ ãngũ mídrị̂ agâ sĩ pírí. ");
INSERT INTO luc_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mĩrĩ Náyĩlĩ ꞌa la ga pírí ụ́drụ́gọ́ kî sĩ. Kí amvú ru tõlé lị́cọ́ mídrị́ ãmbõgõ drị̂ agá, ãngũ míní sĩ kojó rĩ gá, mgbọ́lọ́ mídrị̂ sị́ gá, jó ãtiꞌbo mídrị̂ ꞌbadrị̂ kí agâ sĩ, ꞌbá mídrị̂ kí ụrụꞌbá gâsĩ, kí ụtụ ãngũ sĩ mũkátĩ uꞌbéjó rĩ agâ sĩ ãzíla ãkójó sĩ ngánũ anzájó rĩ kí agâ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ụ́drụ́gọ́ ꞌdĩ kí ụtụ ími ụrụꞌbá gâsĩ, ꞌbá mídrị̂ kí ụrụꞌbá gâsĩ ãzíla ãtiꞌbo mídrị̂ kí ụrụꞌbá gâsĩ.’” ");
INSERT INTO luc_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ꞌDã ꞌbã ũngúkú gá, Úpí umvi Mụ́sã ní jọ, “Íjọ Ãrọ́nị̃ nî, mí inga túré ími drị́ gá ꞌdĩ ílũ sĩ ãngũ wọ́rọ̃ŋá, lọ̃rọ́, ãzíla kẹ̃bẹ̃lụ́ kí agâlé fẽjó la ụ́drụ́gọ́ ꞌbaní ãfũjó ị̃yị́ agâlé ãngũ Mị̃sị́rị̃ drị̂ drị̃ gá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ị́jọ́ ꞌdĩ sĩ, Ãrọ́nị̃ inga dó ru drị́, lũ dó sĩ ãngũ ị̃yị́ Mị̃sị́rị̃ gá rĩ kí drị̃ gá, ụ́drụ́gọ́ ãfũ kí dó ãzíla íré kí dó ru ãngũ drị̃ gâsĩ pírí. ");
INSERT INTO luc_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Wó ꞌbá Mị̃sị́rị̃ gá újógó ru ãzíla ꞌbá ãzị́ ngalépi ũjogo kí pálé gá rĩ kí abe idé kí vâ tálí ãlu ꞌdĩ kí vúŋá ũkpõ ĩꞌbadrị́ ndrelé ku rĩ sĩ, fẽ kí vâ ụ́drụ́gọ́ ãfũ kí ãngũ Mị̃sị́rị̃ drị̂ agâ sĩ ãlu rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Fãráwũ umve Mụ́sã kí Ãrọ́nị̃ be ị́jọ́ jọjó ĩꞌbaní, “Ĩzị Úpí ꞌi ụ́drụ́gọ́ ꞌdĩ kí ĩdãjó má rụ́ ꞌdâ ꞌbá mádrị̂ abe rá ãzí la ma dó sĩ ꞌbá ĩmidrị̂ kí aꞌbe mụlé ídétáŋá idélé Úpí nî.” ");
INSERT INTO luc_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mụ́sã jọ Fãráwũ ní, “Ma adru ãyĩkõ sĩ míní Ãdróŋá zịjó, ípẽ sáwã mání sĩ ĩꞌdi zịjó míní ãmbogo mídrị̂ abe rĩ ꞌi. Lẽ ụ́drụ́gọ́ ꞌdĩ ꞌbã fũ kí rú sĩ ĩmidrị́ jó agá rĩ sĩ rá, be la rá la Mĩrĩ Náyĩlĩ agá rĩ ꞌba ace kí nĩ.” ");
INSERT INTO luc_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Fãráwũ jọ, “Ízị drụ̃sị̃ mání Ãdróŋá ꞌi.” Mụ́sã umvi, “ꞌBã adru míní jọlé rĩ áni, ị́jọ́ ꞌdĩ sĩ, mi dó sĩ nị̃ la rá ãdróŋá ãzí ndú Úpí ãmadrị́ ꞌdĩ áni la ꞌdá yụ. ");
INSERT INTO luc_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ụ́drụ́gọ́ kí ími aꞌbe ꞌbá mídrị́ jó agá rĩ kí abe, ãmbogo mídrị̂ kí ãzíla ꞌbá mídrị̂ kí abe, kí dó sĩ lú ace Mĩrĩ Náyĩlĩ agá áꞌdụ̂sĩ.” ");
INSERT INTO luc_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mụ́sã kí Ãrọ́nị̃ be ĩꞌbã kí Fãráwũ aꞌbejó ꞌbo rĩ ꞌbã vúlé gá, Mụ́sã ꞌbã mãmálá Úpí drị̃lẹ́ gá ị́jọ́ ụ́drụ́gọ́ ĩꞌdi ꞌbã ajílé Fãráwũ kí drị̃ gá ꞌbá ĩꞌdidrị̂ kí abe ꞌdĩ kí sĩ ");
INSERT INTO luc_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Úpí idé ị́jọ́ Mụ́sã ꞌbã zịlé rĩ rá. Ụ́drụ́gọ́ jó agá, lị́cọ́ agá ãzíla ámvụ́ agâ sĩ rĩ ũdrã kí dó rá. ");
INSERT INTO luc_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Útra dó kí ngúlú ru ngúlú ru, ĩꞌbã ĩŋmã sĩ ãngũ pírí ri dó ngụ̃lé ĩŋmákíꞌdíꞌdí. ");
INSERT INTO luc_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Wó Fãráwũ dó mụ ndrelé la ãngũ ịgbẹ ꞌbo, ásị́ la mba vâ úꞌdí ru gã dó Mụ́sã kí tị arelé Ãrọ́nị̃ be úmgbé cécé Úpí ꞌbã jọlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ní, “Íjọ Ãrọ́nị̃ ní, ‘Mí inga túré ími drị́ gá ꞌdĩ ꞌi, ígbã dó sĩ pụ́trụ́ ãngũ drị̃ gá ꞌdĩ ꞌi, ãzíla pụ́trụ́ ãngũ Mị̃sị́rị̃ drị̂ agá rĩ la dó sĩ ru uja pírí lúgbákíꞌdí ru.’” ");
INSERT INTO luc_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Idé kí ị́jọ́ ꞌdĩ rá, Ãrọ́nị̃ inga ru drị́ túré trũ ãzíla gbã pụ́trụ́ ãngũ drị̃ gá rĩ ꞌi, lúgbákíꞌdí ci dó sĩ ꞌbá ꞌba rụ́ ãnãkpá abe pírí. Ãngũ Mị̃sị́rị̃ drị̂ uja dó sĩ ru pírí lúgbákíꞌdí ru. ");
INSERT INTO luc_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Wó ꞌbá Mị̃sị́rị̃ gá újógó ru ãzíla ꞌbá ãzị́ ngalépi ũjogo kí pálé gá rĩ kí abe idé kí tí vâ tálí ãlu ꞌdĩ kí vúŋá ũkpõ ĩꞌbadrị́ ndrelé ku rĩ sĩ, icó ru ku. Lúgbákíꞌdí ũgĩ ru ꞌbá kí ụrụꞌbá gá ãnãkpá kí abe kũlũ. ");
INSERT INTO luc_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ꞌBá ũjogo rú ꞌdĩ jọ kí Fãráwũ ní, “ꞌdĩ ũkpõ Ãdróŋá ãni la.” Wó Fãráwũ ásị́ mba vâ ũkpó ru ị̃dị́-ị̃dị́, ãzíla acá bị́lẹ́ kóru cécé Úpí ꞌbã jọlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, “Mí ãfũ ụ̃ꞌbụ́tịnị́nị́ ímụ drị̃ ụfụlé Fãráwũ be ĩꞌdi ꞌbã mụ agá ị̃yị́ gâlé ꞌdĩ gá ꞌdĩ. Íjọ ĩꞌdiní, ‘ꞌDĩ ị́jọ́ Úpí ꞌbã jọlé rĩ i, “Lẽ mí aꞌbe ꞌbá mádrị̂ ꞌbã mụ kî, ị́jọ́ ꞌdĩ sĩ kí dó sĩ mụ áma ị̃nzị̃lé kõtórõ agâlé. ");
INSERT INTO luc_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ídrĩ ꞌbá mádrị̂ kí aꞌbe mụlé ku, ma mụ ụ́nụ́ ũꞌbí drụdrụ la kí tị ãpẽlé mí rụ́ ãmbogo mídrị̂ kí abe. Jó ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbadrị̂ kí pírí ga tré ụ́nụ́ sĩ ãzíla ụ́nụ́ la vũ drị̃ aku pírí cí. ");
INSERT INTO luc_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Wó ụ́ꞌdụ́ ꞌdã sĩ ị́jọ́ mání mụlé idélé ãngũ Gõsénĩ gá rĩ la adru ndú ꞌdĩ ãngũ ꞌbá mádrị̂ ꞌbã kí sĩ uꞌájó rĩ i, ụ́nụ́ ũꞌbí drụdrụ ꞌdĩ ca kí calé ala gâlé ku, ị́jọ́ ꞌdĩ sĩ ĩmi dó sĩ nị̃ la Úpí ꞌi ãngũ ꞌdĩ gá ꞌdâ cí. ");
INSERT INTO luc_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ma ꞌbá mádrị̂ kí drĩdríŋĩ awa ꞌbá mídrị̂ abe. Tálí ꞌdĩ la ru idé drụ̃sị̃.”’” ");
INSERT INTO luc_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Úpí idé ị́jọ́ ꞌdĩ rá, ụ́nụ́ ũꞌbí drụdrụ rĩ íré kí ru tõlé lị́cọ́ ĩꞌdidrị́ ãmbõgõ drị̂ agá, jó ãmbogo Fãráwũ drị̂ ꞌbadrị̂ kí agâ sĩ, ãzíla ãngũ Mị̃sị́rị̃ drị̂ ụ́nụ́ iza kí dó ĩꞌdi pírí. ");
INSERT INTO luc_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ꞌDã ꞌbã vúlé gá Fãráwũ umve Mụ́sã kí Ãrọ́nị̃ be ĩꞌdi rụ́ ꞌdõlé jọ ĩꞌbaní, “Ĩmụ ídétáŋá idélé Ãdróŋá ní ãngũ ꞌdĩ gá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Wó Mụ́sã jọ Fãráwũ ní, “ꞌDã icó adrulé múké ku. Ídétáŋá ãmaní mụlé idélé Úpí Ãdróŋá ãmadrị̂ ní rĩ la adru ídétáŋá ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbaní ngụ̃lé ũnzí rĩ ꞌi. Ãma ní ídétáŋá ꞌdĩ kí idé agá kí drị̃ gâsĩ ꞌdâ, icó kí ãma uꞌbélé írã sĩ káyĩ ku yã? ");
INSERT INTO luc_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Lẽ ãꞌdụ ãcị̃ ụ́ꞌdụ́ na la mụjó ídétáŋá idéjó Úpí Ãdróŋá ãmadrị̂ ní kõtórõ gá ásé agâlé, ĩꞌdi ꞌbã ãmaní ãzị́táŋá la fẽjó rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Fãráwũ jọ, “Ma ĩminí ãꞌị̃ mụlé Úpí Ãdróŋá ĩmidrị̂ ní ídétáŋá idélé ãngũ kõtórõ rú rĩ gá ásé agâlé rá, wó adru rá-rá ru la ku: Wó ĩzị mání ĩꞌdi ĩndĩ.” ");
INSERT INTO luc_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mụ́sã umvi Fãráwũ ní, “Cọtị́ ádrĩ dó fũ ími drị̃lẹ́ gá ꞌdâ ꞌbo, ma mụ Úpí zịlé rá, ụ́nụ́ ũꞌbí drụdrụ ꞌdĩ kí mụ ími aꞌbelé ãmbogo ãzíla ꞌbá mídrị̂ kí abe drụ̃sị̃ rá. Wó lẽ mí ulé ãma ị̃dị́ ãzíla ãma atrịjó sĩ mụjó ídétáŋá idéjó Úpí ãmadrị̂ ní ku.” ");
INSERT INTO luc_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ꞌDã ꞌbã vúlé gá Mụ́sã aꞌbe dó Fãráwũ rá, mụ dó Úpí zịlé, ");
INSERT INTO luc_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ãzíla Úpí idé ị́jọ́ Mụ́sã ꞌbã zịlé rĩ rá: Ụ́nụ́ aꞌbe kí Fãráwũ ꞌi, ãmbogo ĩꞌdidrị̂ kí ãzíla ꞌbá ĩꞌdidrị̂ kí abe rá. Ụ́nụ́ ũꞌbí drụdrụ ꞌdã kí ãzí ífí ãlu la ace dó ꞌdãá ku. ");
INSERT INTO luc_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Wó sáwã ꞌdã sĩ Fãráwũ ꞌbã ásị́ mba ũkpó ru ãzíla ãꞌị̃ ꞌbá ꞌbaní mụjó ku. ");
INSERT INTO luc_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ní, “Ímụ Fãráwũ rụ̂lé íjọ ĩꞌdiní, ‘Úpí Ãdróŋá ꞌbá Ĩbũrãníyã rú rĩ ꞌbadrị̂ jọ, “Lẽ mí aꞌbe ꞌbá mádrị̂ ꞌbã mụ kî, kí dó sĩ mụ áma ị̃nzị̃lé.” ");
INSERT INTO luc_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ídrĩ kí uga mụlé úmgbé ãzíla ídrĩ vâ kí rụ cí, ");
INSERT INTO luc_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Úpí la jụ́wẹ̃ ũnzí la ají ãnãkpá mídrị̂ kí drị̃ gá ámvụ́ agâlé, fãrásĩ kí, kãyĩnõ kí, ngãmíyã kí, tị́ kí, kãbĩlõ kí, ãzíla ị̃ndrị́ kí abe. ");
INSERT INTO luc_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Wó Úpí la ãnãkpá ꞌbá Ịsịrayị́lị̃ ꞌbadrị̂ kí drĩdríŋĩ awa ãnãkpá ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbadrị̂ abe, ị́jọ́ ꞌdĩ sĩ ãnãkpá ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbadrị̂ ꞌbã ũdrã kí rú sĩ ku.’” ");
INSERT INTO luc_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Úpí ꞌbã ụ́ꞌdụ́ ãzí jọ, “Drụ̃sị̃ Úpí la ị́jọ́ ꞌdĩ idé ãngũ ꞌdĩ gá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Drụ̃sị̃ íni Úpí idé ị́jọ́ ĩꞌdi ꞌbã jọlé rĩ rá. Ãnãpká ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbadrị̂ ũdrã kí pírí, wó ãnãkpá ꞌbá Ịsịrayị́lị̃ rú rĩ ꞌbadrị̂ ꞌbã ãzí drã ífí ãlu ku. ");
INSERT INTO luc_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Fãráwũ pẽ ꞌbá ãzí kí tị ị́jọ́ ru idélépi ꞌdĩ kí undrélé, wó újọ ĩꞌdiní ãnãpká ꞌbá Ịsịrayị́lị̃ rú rĩ ꞌbadrị̂ ꞌbã ãzí drã ífí ãlu ku. Wó Fãráwũ ásị́ mba ũkpómgboroto rú, aꞌbe ꞌbá ꞌdĩ kí mụlé ku. ");
INSERT INTO luc_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ꞌbaní Ãrọ́nị̃ be, “Ĩmi ãndĩ úfóró ãti agâlé rĩ drị́ gá tré ãzíla Mụ́sã ꞌbã yĩ ĩꞌdi ãlụ́kụ́kụ̃ agá Fãráwũ drị̃ gâsĩ. ");
INSERT INTO luc_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ĩꞌdi acá pụ́trụ́ ru ru irélé ãngũ Mị̃sị́rị̃ drị̂ agâ sĩ pírí, ãzíla kụ̃rụ́tẹ́ la ꞌbá kí ãvõ ãnãkpá abe ãngũ Mị̃sị́rị̃ drị̂ agâ sĩ pírí.” ");
INSERT INTO luc_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ị́jọ́ ꞌdĩ sĩ ãndĩ kí úfóró angájó ãti agâlé ãzíla tu kí pá Fãráwũ ꞌbã drị̃lẹ́ gá. Mụ́sã yĩ dó úfórô ũlí agâlé ãzíla kụ̃rụ́tẹ́ ꞌbá kí ãvõlépi ãnãkpá kí abe rĩ ụ̃kpẹ̃ kí ãzíla ce kí dó ãkõzá ru kí ụrụꞌbá gâsĩ pírí. ");
INSERT INTO luc_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ꞌBá ũjogo rú ꞌdĩ icó kí pá tulé Mụ́sã drị̃lẹ́ gá ku ãꞌdusĩku kụ̃rụ́tẹ́ ãvõ kí ụrụꞌbá ꞌbá Mị̃sị́rị̃ gá rĩ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Wó Úpí fẽ Fãráwũ ásị́ mba ũkpómgboroto rú ãzíla ꞌbã are rú sĩ Mụ́sã kí tị Ãrọ́nị̃ be ku, cécé Úpí ꞌbã jọlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ní, “Mí angá drụ̃sị̃ ụ̃ꞌbụ́tịnị́nị́, mí ụfụ drị̃ Fãráwũ be ãzíla ị́jọ ĩꞌdiní, ‘Úpí Ãdróŋá ꞌbá Ĩbũrãníyã rú rĩ ꞌbadrị̂ jọ íni, “Lẽ mí aꞌbe ꞌbá mádrị̂ ꞌbã mụ kî, ị́jọ́ ꞌdĩ sĩ kí dó sĩ mụ áma ị̃nzị̃lé, ");
INSERT INTO luc_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","sáwã ꞌdĩ sĩ adru ma jụ́wẹ̃ fẽ drị̃rịma rú ãtíꞌbó mídrị̂ ꞌbaní jõku ꞌbá mídrị̂ ꞌbaní áꞌdụ̂sĩ la ku, ma vâ míní drị̃rịma fẽ ĩndĩ. Ị́jọ́ ꞌdĩ sĩ mi dó sĩ nị̃ la rá ꞌbá ãzí mâ áni la ãngũ drị̃ gá ꞌdâ ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ãꞌdusĩku ádrĩ tá áma drị́ inga ími cojó ꞌbá mídrị̂ kí abe ãyánĩ sĩ, ĩmi ị̃lị̃kị̃ tá nõ ụ̃nọ́kụ́ drị̃ gá ꞌdâ ꞌbo. ");
INSERT INTO luc_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Má aꞌbe mi ídri rú la ị́jọ́ ꞌdĩ sĩ, ma sĩ ũkpõ mádrị̂ iꞌda míní ãzíla ála sĩ áma rụ́ ịkụ́ ãngũ drị̃ gá ꞌdâ pírí. ");
INSERT INTO luc_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Íꞌbã mi ꞌbá mádrị̂ kí drị̃lẹ́ gá ãfó ru, mí aꞌbe sĩ ꞌbá mádrị̂ kí mụlé ku. ");
INSERT INTO luc_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ị́jọ́ ꞌdĩ sĩ, drụ̃sị̃ ị̃tụ́ ꞌdõpí ma sí fẽ zõlé ũkpó ru jõdrĩ ídu ru idélépi ãngũ Mị̃sị́rị̃ drị̂ agá ꞌdâ ĩꞌdi ꞌbã iꞌdóŋá gá ku la kpere ãndrũ. ");
INSERT INTO luc_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Mí azị ị́jọ́ úꞌdîꞌda, ꞌbá kí tị pẽjó mụjó ãnãkpá ãzíla ãko pírí ámvụ́ gá ásé agâlé rĩ kí ajíjó lị́cọ́ gá ãngũ sĩ kí tãmbajó rĩ gá, ãꞌdusĩku sí la zõ ꞌbá, ãzíla ãnãkpá pírí ajílé tãmbalé ku ásé agâlé rĩ kí drị̃ gá, ãzíla kí ũdrã rá.”’” ");
INSERT INTO luc_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ꞌBá Fãráwũ drị́ ãmbogo ru ị́jọ́ Úpí drị̂ ụ̃rị̃lépi rĩ fẽ kí ãtíꞌbó ĩꞌbadrị̂ kí ãnãkpá kí abe ajílé tã mbalé jó agá rá. ");
INSERT INTO luc_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Wó ꞌbá ị́jọ́ Úpí drị̂ idelépi rá rĩ aꞌbe kí ãtiꞌbo ĩꞌbadrị̂ kí ãnãkpá kí abe ámvụ́ agá ásé agâlé. ");
INSERT INTO luc_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ꞌDã ꞌbã ũngúkú gá, Úpí jọ vâ Mụ́sã ní, “Mí ĩjũ ími drị́ ꞌbụ̃ gâlé ru, ị́jọ́ ꞌdĩ sĩ sí ꞌbã zõ ãngũ Mị̃sị́rị̃ drị̂ agá pírí ꞌbá kí drị̃ gá ãnãkpá kí abe ãzíla ãko zolépi ámvụ́ ꞌbá Mị̃sị́rị̃ rú rĩ ꞌbadrị̂ kí agá rĩ kí abe.” ");
INSERT INTO luc_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mụ́sã la mụ túré ĩjũlé ꞌbụ̃ gâlé ꞌbo, Úpí fẽ ãvi ní ũnĩjó ãzíla ụ̃kpẹ̃jó ãzíla sí ní zõjó ãngũ drị̃ gá. Ị́jọ́ ꞌdĩ sĩ Úpí fẽ sí ní zõjó ãngũ Mị̃sị́rị̃ drị̂ agá pírí; ");
INSERT INTO luc_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","sí zõ ãzíla ãvi ují ãngũ nẽmẽ-nẽmẽ. Sí ꞌdã ándrá jõdrĩ ídu zõlépi ꞌdã ꞌbã áni sụ́rụ́ Mị̃sị́rị̃ drị̂ agá ãwí ĩꞌdidrị̂ gá ku la. ");
INSERT INTO luc_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mị̃sị́rị̃ ꞌbã ãngũ gá pírí, sí co ãko ámvụ́ agá ásé agâlé rĩ kí, ꞌbá kí ãnãkpá abe; co vâ ãko pírí zolépi ámvụ́ agá ásé agâlé rĩ kí ãzíla ife kí bị́ zõ pírí. ");
INSERT INTO luc_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ãngũ sí ꞌbã sĩ zõjó ku rĩ ĩꞌdi lú ãngũ Gõsénĩ gá ꞌbá Ịsịrayị́lị̃ rú rĩ ꞌbadrị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ị́jọ́ ꞌdĩ sĩ Fãráwũ umve dó Mụ́sã kí Ãrọ́nị̃ be ãzíla jọ ĩꞌbaní, “Sáwã ꞌdĩ sĩ má iza rá. Úpí ꞌbã ị́jọ́ ꞌbãngá pịrị, ãzíla ãma idé ꞌbãngá ũnzí ꞌbá mádrị̂ abe. ");
INSERT INTO luc_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mí aꞌị́ mání Úpí ꞌi, ãꞌdusĩku ãvi ꞌdĩ kí sí ꞌdĩ abe ca kí ãmaní rá. Ma ĩmi aꞌbe mụlé rá; ĩmi uꞌá dó sĩ ụ́ꞌdụ́ ãzo rú ꞌdâ ku.” ");
INSERT INTO luc_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mụ́sã umvi, “Ádrĩ fũ táwụ̃nị̃ ꞌdĩ agá ꞌdâ ãmvé ꞌbo, ma áma drị́ aja Úpí drị̃lẹ́ gá ĩꞌdi aꞌị́jó. Ãvi ꞌdĩ la pá tu rá ãzíla sí la adru ꞌdá yụ, mi dó ị́jọ́ ꞌdĩ sĩ nị̃ la ụ̃nọ́kụ́ ꞌdĩ Úpí ãni. ");
INSERT INTO luc_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Wó ánị̃ rá mi ꞌi ãzíla ãmbogo mídrị́ ꞌdĩ kí abe ĩmi idé Úpí Ãdróŋá sĩ ụ̃rị̃ sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Wãrũ kí ãná abe sí co kí rá, ãná ꞌbã ayijó rá ãzíla wãrũ ꞌbã ũfũ ci jó ꞌbo rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ãná ngánũ rú rĩ kí bũrúsú kí abe co kí ku ĩꞌbã kí drĩ angájó ku rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mụ́sã aꞌbe dó Fãráwũ rá ãzíla fũ táwụ̃nị̃ ꞌa gá rĩ sĩ ãmvé. Aja ru drị́ kí Úpí rụ́; ãvi ãzíla sí tu kí dó pá rá; uzogó asu dó ãngũ drị̃ gá ku. ");
INSERT INTO luc_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Fãráwũ la dó mụ ndrelé la uzogó, sí ãzíla ãvi tu kí pá ꞌbo, ĩꞌdi ꞌi ãzíla ꞌbá ãmbogo ĩꞌdidrị̂ kí abe iza kí ị́jọ́ ị̃dị́ ãzíla ásị́ la mba kí ũkpó ru. ");
INSERT INTO luc_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Fãráwũ ꞌbã ásị́ mba vâ ũkpómgboroto rú ị̃dị́-ị̃dị́ ãzíla icó ꞌbá Ịsịrayị́lị̃ drị̂ kí aꞌbelé mụlé ku, cécé tá Úpí ꞌbã jọlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ní, “Ímụ Fãráwũ rụ̂lé ãꞌdusĩku áꞌbã ĩꞌdi ꞌbã ásị́ mbalé ũkpómgboroto rú ꞌbá ãmbogo rú ĩꞌdidrị̂ kí abe, ma dó sĩ ị́jọ́ mádrị́ tálí ru rĩ kí idé kí drĩdríŋĩ gá ꞌdâ benĩ, ");
INSERT INTO luc_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","mi dó sĩ vú la nze mî anzị ꞌbaní ãzíla mî anzị ꞌbã anzị ꞌbaní, ị́jọ́ ándrá ũmbã ꞌbã sĩ áma najó ꞌbá Mị̃sị́rị̃ rú ꞌdĩ ꞌbaní ãzíla mání dó sĩ ị́jọ́ mádrị́ tálí ru rĩ kí idéjó kí drĩdríŋĩ gá rĩ abe ãzíla ĩmi dó sĩ nị̃ la rá ma Úpí ru ma ꞌi.” ");
INSERT INTO luc_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ị́jọ́ ꞌdĩ sĩ Mụ́sã kí Ãrọ́nị̃ be mụ kí dó Fãráwũ rụ̂lé ãzíla jọ kí ĩꞌdiní, “Úpí Ãdróŋá ꞌbá Ĩbũrãníyã rú rĩ ꞌbadrị̂ jọ: ‘Mi gã áma tị arelé úmgbé ụ́ꞌdụ́ íngõpí yã? Lẽ mí aꞌbe ꞌbá mádrị̂ ꞌbã mụ kî, ị́jọ́ ꞌdĩ sĩ kí dó sĩ mụ áma ị̃nzị̃lé kõtórõ agâlé. ");
INSERT INTO luc_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ídrĩ kí uga mụlé úmgbé, drụ̃sị̃ ma úmbí fẽ ꞌdelé ãngũ mídrị̂ agá. ");
INSERT INTO luc_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Kí ãngũ aku cí ícó dó sĩ ãngũ ndrelé ku. Ĩꞌdi ãko mídrị́ were sí ꞌbã colé ku ꞌdĩ kí iza rá, ife zolépi mídrị́ ámvụ́ agá ꞌdĩ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Kí ru tõ jó mídrị̂ kí agá, jó ꞌbá mídrị́ ãmbogo rú ꞌdĩ ꞌbadrị̂ abe ãzíla jó ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbadrị̂ kí agá sĩ pírí. ꞌDĩ la adru ị́jọ́ ãzí jõ drĩ údu ru ngalépi mí átẹ́pị jõku mí áyị́pịka kí ụrụꞌbá gá ku la iꞌdójó ụ́ꞌdụ́ ĩꞌbã kí rijó ãngũ ꞌdĩ gá ꞌdâ rĩ sĩ kpere ãndrũ.’” Cọtị́ Mụ́sã uja ru aꞌbe dó Fãráwũ rá. ");
INSERT INTO luc_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ãmbogo Fãráwũ drị̂ jọ kí ĩꞌdiní, “Ágọ́bị́ ꞌdĩ la ãmaní ũcõgõ fẽ ụ́ꞌdụ́ íngõpí yã? Mí amá drĩ Mị̃sị́rị̃ ị̃lị̃kị̃ rá rĩ ku yã? Ị́jọ́ ꞌdĩ sĩ âꞌbe ꞌbá ꞌdĩ ꞌbã mụ kí dó sĩ Úpí Ãdróŋá ĩꞌbadrị̂ ị̃nzị̃lé kõtórõ agâlé.” ");
INSERT INTO luc_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ꞌDãá Mụ́sã kí Ãrọ́nị̃ be ájí dó kí vúlé Fãráwũ rú ꞌdõlé. Fãráwũ jọ, “Ĩmụ Úpí Ãdróŋá ĩmidrị̂ ị̃nzị̃lé. Wó mgbãrĩ gá ãꞌdi kí mụ nĩ?” ");
INSERT INTO luc_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mụ́sã umvi, “Ãma mụ anzị ãzíla ꞌbá ĩyõ ãmadrị̂ kí abe, ãmã anzị ãgọbị rú ãzíla izonzi rú rĩ abe, kãbĩlõ ãzíla tị́ kí abe, ãꞌdusĩku ãma mụ ụ̃mụ̃ ꞌbãlé sĩ Úpí ị̃nzị̃jó.” ");
INSERT INTO luc_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Fãráwũ jọ, “Ásõ ũyõ Úpí ꞌbã rụ́ sĩ, má icó ĩmi aꞌbelé mụlé ũkú ĩmidrị̂ kí trũ anzị abe ku. Ị́jọ́ ꞌdĩ iꞌda ru mání pịrị-pịrị ị́jọ́ ũnzí ãzí ĩmi agá ĩminí itúlé la cí. ");
INSERT INTO luc_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Yụ! Ãgọbị ꞌbã mụ kí Úpí ị̃nzị̃lé nĩ áꞌdụ̂sĩ; ꞌdĩ ꞌbã adrujó ị́jọ́ míní lẽlé rĩ ꞌi rĩ sĩ.” ꞌDãá cọtị ádró dó Mụ́sã kí Ãrọ́nị̃ be Fãráwũ drị̃lẹ́ gâlé rá. ");
INSERT INTO luc_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Wó Úpí jọ Mụ́sã ní, “Mí ĩjũ ími drị́ ãngũ Mị̃sị́rị̃ drị̂ drị̃ gá úmbí ũꞌbí ꞌbã ꞌde kí dó sĩ ãngũ Mị̃sị́rị̃ drị̂ drị̃ gá ãzíla ꞌbã mụ kí ãkónã kalépi ámvụ́ agá sí ꞌbã izalé ku rĩ ꞌbã ị́mbị́ acelépi rĩ kí nalé pírí.” ");
INSERT INTO luc_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ị́jọ́ ꞌdĩ sĩ Mụ́sã inga dó túré ĩꞌdidrị́ gá rĩ ꞌi, ãzíla Úpí fẽ ãlụ́kụ́kụ̃ iꞌdó dó alílé ị̃tụ́ ꞌbã ãfũ agâlé ru lijó ãngũ Mị̃sị́rị̃ drị̂ drị̃ gá ị̃tụ̂ rụ̃ ãzíla ị́nị́ ãrã. Ĩꞌdi mụ calé ụ̃ꞌbụ́tị sĩ ãlụ́kụ́kụ̃ adró úmbí kî. ");
INSERT INTO luc_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Úmbí ꞌdĩ amụ́ kí ũꞌbí ru ãzíla pa kí dó ãngũ Mị̃sị́rị̃ drị̂ pírí. Jụ́wẹ̃ ãzí jõ drĩ úmbí ãni ꞌdĩ ꞌbã áni la ꞌdá yụ jõku icó vâ mụlé ꞌdelé ꞌdĩ ꞌbã áni ị̃dị́ ku. ");
INSERT INTO luc_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ri kí dó ãngũ pírí agá, ị́jọ́ ꞌdĩ sĩ aku kí dó ụ̃nọ́kụ̂ drị̃ cí ãzí la ụ̃nọ́kụ̂ iꞌdá dó ĩꞌbadrị́ ịnị rú. Na kí dó ãkónã ꞌbã ị́mbị́ sí ꞌbã colé ku rĩ kí pírí, ãko ife rú pírí ífí kalépi kãkã rĩ kí trũ. Ãko ãzí acelépi ĩrí ru ãngũ Mị̃sị́rị̃ drị̂ agá la ꞌdá yụ. ");
INSERT INTO luc_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Cọtị Fãráwũ umve Mụ́sã kí Ãrọ́nị̃ be jọ ĩꞌbaní, “Má iza ị́jọ́ Úpí Ãdróŋá ĩmidrị̂ rụ́ ãzíla ĩmi rụ́ rá. ");
INSERT INTO luc_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ị́jọ́ ꞌdĩ sĩ má aꞌị́ trũtáŋá ĩmidrị́ ị́jọ́ ũnzí mádrị̂ sĩ pálé ãlu ị̃dị́ ãzíla ĩzị mání Úpí Ãdróŋá ĩmidrị̂ sĩ drã ũnzíkákãnã ꞌdĩ nzejó rá.” ");
INSERT INTO luc_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mụ́sã ãfũ dó Fãráwũ drị̂lé rĩ sĩ rá ãzíla zị dó Úpí ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ꞌDã ꞌbã vúlé gá Úpí uja dó ãlụ́kụ́kụ̃ tị lijó ị̃tụ́ ꞌbã ꞌde agâlé ru sĩ úmbí kí drojó Mĩrĩ Ika rĩ agâlé. Úmbí ãzí ãlu acelépi ãngũ Mị̃sị́rị̃ drị̂ agá la ꞌdá yụ. ");
INSERT INTO luc_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Wó Úpí fẽ Fãráwũ ásị́ mba ũkpómgboroto rú sĩ ꞌbá Ịsịrayị́lị̃ drị̂ kí aꞌbejó mụjó ku. ");
INSERT INTO luc_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, “Mí ĩjũ ími drị́ ꞌbụ̃ gâlé ãngũ ꞌbã nị dó sĩ Mị̃sị́rị̃ drị̃ gá kpákpá, ãngũ nịlépi ꞌbá ꞌbã kí icólé ĩtrĩkãlé rá la.” ");
INSERT INTO luc_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ị́jọ́ ꞌdĩ sĩ Mụ́sã inga dó ru drị́ ꞌbụ̃ gâlé, ãngũ nị dó Mị̃sị́rị̃ drị̃ gá pírí kpákpá ụ́ꞌdụ́ na. ");
INSERT INTO luc_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ꞌBá Mị̃sị́rị̃ rú rĩ icó kí ru ndrelé ku jõku aꞌbe kí ãngũ ĩꞌbã kí sĩ adrujó rĩ kí ku cajó ụ́ꞌdụ́ na ꞌdĩpí. Wó íni ꞌdĩ Ịsịrayị́lị̃ kí ngá uꞌá dị̃zã agá. ");
INSERT INTO luc_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ꞌDã ꞌbã ũngúkú gá, Fãráwũ umve Mụ́sã ꞌi jọ ĩꞌdiní, “Ĩmụ Úpí ị̃nzị̃lé. Ĩmi ũkú kí ꞌdụ anzị ĩmidrị̂ kí abe trũ mụjó rá; wó ĩmi aꞌbe kãbĩlõ kí tị́ abe vúlé ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Wó Mụ́sã jọ, “Lẽ mí aꞌbe ãma mụlé ídétáŋá ivélé ivê rĩ idélé Úpí Ãdróŋá ãmadrị̂ nî. ");
INSERT INTO luc_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ãnãkpá ãmadrị̂ kí mụ ãma abe pírí ĩndĩ; ãnãkpá ãzí ãlu la ace vúlé ku. Ãma mụ ãzí rĩ kí ayúlé sĩ Úpí Ãdróŋá ãmadrị̂ ị̃nzị̃jó, wó ãdrĩ ca lé ꞌbo ãnị̃ ãma mụ ãdu ayúlé sĩ Úpí ị̃nzị̃jó yã rĩ gá ku.” ");
INSERT INTO luc_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Wó Úpí fẽ Fãráwũ ásị́ mba ũkpómgboroto rú, ãzíla lẽ ꞌbá ꞌdĩ ꞌbã mụ kí ku. ");
INSERT INTO luc_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Fãráwũ jọ Mụ́sã ní, “Mí ĩdã mi áma drị̃lẹ́ gá ꞌdâ rá! Lẽ mí iꞌda mi áma drị̃lẹ́ gá ị̃dị́ ku! Ụ́ꞌdụ́ míní áma mẹ́lẹ́tị ndrejó rĩ sĩ mi mụ drãlé rá.” ");
INSERT INTO luc_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mụ́sã umvi Fãráwũ nî, “Cécé míní jọlé rĩ áni, mí icó áma mẹ́lẹ́tị ndrelé ị̃dị́ ku.” ");
INSERT INTO luc_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, “Ma jụ́wẹ̃ ãzí ají ãlu úpí Fãráwũ drị̃ gá ꞌbá ĩꞌdidrị́ Mị̃sị́rị̃ gá rĩ abe. ꞌDã ꞌbã vúlé gá ĩꞌdi ĩmi aꞌbe mụlé, ĩꞌdi mgbãrĩ gá ĩmi dro ꞌdâ rĩ gá ãmvé. ");
INSERT INTO luc_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Íjọ ị́jọ́ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ãzíla ílũ ĩꞌbaní ꞌbã aꞌị́ kí ãko gólũdĩ, ãzíla sílĩvã ãko ũnĩ drị̂ kí ꞌbá ĩꞌbã jĩránĩ rú rĩ ꞌbadrị́.” ");
INSERT INTO luc_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Úpí fẽ ꞌbá Mị̃sị́rị̃ drị̂ iꞌda kí ꞌbá Ịsịrayị́lị̃ drị̂ ꞌba ní ásị́ ị̃gbẹ̃ rá. Mgbãrĩ gá, Fãráwũ ꞌi ãmbogo ĩꞌdidrị̂ kí ãzíla ꞌbá ĩꞌdidrị̂ abe pírí ãꞌị̃ kí Mụ́sã ĩꞌdi ꞌbá ãzí ãmbógó la rĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ị́jọ́ ꞌdĩ sĩ, Mụ́sã jọ dó Fãráwũ nî, “ꞌdĩ ị́jọ́ Úpí ꞌbã jọlé rĩ, ‘Ãni rú sáwã ázíyá ị́nị́ drị̂ sĩ ma acị́ Mị̃sị́rị̃ agâ sĩ pírí. ");
INSERT INTO luc_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Anzị kãjãní ꞌbá Mị̃sị́rị̃ rú rĩ ꞌbadrị̂ kí ũdrã pírí rá, iꞌdójó ngọ́tị́ kãjãní Fãráwũ drị́ drụ́zị́ rilépi úmvúke ũpĩ drị̂ drị̃ gá rĩ sĩ, cajó ngọ́tị́ kãjãní ãtíꞌbó ũkú ru ãná ꞌịlépi drị́ sĩ rĩ drị̂ gá, ãzíla kãjoŋa kãjãní tị́ ꞌbadrị́ gá rĩ kí vâ ũdrã ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ãngũ Mị̃sị́rị̃ drị̂ agá pírí ụ̃lụ́lụ́ la angá ụrụ gá ũnzĩkãnã sĩ jõdrĩ ídu ru idélépi ku la, jõku icó vâ ru idélé ị̃dị́ ku. ");
INSERT INTO luc_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Wó ãngũ Ịsịrayị́lị̃ drị̂ gá ũcógó ífí ãlu la icó ãgbọ̃lé ꞌbá sĩ jõku ãnãkpá sĩ ku. Ị́jọ́ ꞌdĩ sĩ ĩmi dó nị̃ la Úpí awa ꞌbá Ịsịrayị́lị̃ drị̂ kí drĩdríŋĩ ꞌbá Mị̃sị́rị̃ drị̂ abe ndú ndú rĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ꞌBá ãmbogo mídrị́ ꞌdĩ kí pírí amụ́ má rụ́ kí ãvụ̃ vụ̃rụ́ áma drị̃lẹ́ gá ãzíla kí jọ la, “Ímụ ꞌbá mídrị́ ími vú bĩlépi rĩ kí abe pírí!” ꞌDã ꞌbã vúlé gá ma ãngũ ꞌdĩ aꞌbe rá.’” Mụ́sã acá ũmbã rú ãzíla aꞌbe dó Fãráwũ rá. ");
INSERT INTO luc_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Úpí jọ Mụ́sã nî, “Fãráwũ la gã ími tị arelé úmgbé, ị́jọ́ ꞌdĩ sĩ ma rú sĩ ị́jọ́ mádrị́ ụ̃sụ̃táŋá ru ꞌdĩ kí idé ãngũ Mị̃sị́rị̃ drị̂ gá ꞌdâ wẽwẽ rú benĩ.” ");
INSERT INTO luc_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mụ́sã kí Ãrọ́nị̃ be idé kí ị́jọ́ ụ̃sụ̃táŋá ru ꞌdĩ kí Fãráwũ drị̃lẹ́ gá, wó Úpí fẽ Fãráwũ ásị́ mba ũkpómgboroto rú, ãzíla ãꞌị̃ ꞌbá Ịsịrayị́lị̃ drị̂ kí aꞌbelé mụlé sụ́rụ́ ĩꞌdidrị̂ agá ꞌdãá rá la ku. ");
INSERT INTO luc_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ꞌbaní Ãrọ́nị̃ be Mị̃sị́rị̃ gá ꞌdãá, ");
INSERT INTO luc_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ĩmbá ꞌdĩ ꞌbã adru ĩminí ĩmbá drị̃drị̃ ílí ꞌbã sĩ iꞌdójó rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ĩlũ ꞌbá ũꞌbí Ịsịrayị́lị̃ drị́ ꞌdĩ ꞌbaní pírí ĩmbá ꞌdĩ ꞌbã ụ́ꞌdụ́ mụdrị́ sĩ ágọ́bị́ ãlu-ãlu ꞌbã aꞌdụ́ lị́cọ́ ĩꞌdidrị̂ agá ꞌdãá kãbĩlõmvá mũlũkũdũ la. ");
INSERT INTO luc_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ꞌBá lị́cọ́ ꞌdã agá rĩ drĩ kí adru were rú sĩ icójó kãbĩlõmvá mũlũkũdũ rĩ najó pírí ku ꞌbã icí kí ru ꞌbá ĩꞌdĩ ꞌbã jĩránĩ Ịsịrayị́lị̃ rú rĩ be, sĩ icójó najó la pírí rá. Lẽ ĩnị̃ rá ꞌbá mụlépi kãbĩlõmvá mũlũkũdũ lẽlé ꞌdã ꞌbã ĩzá nalépi rĩ ꞌbã na kí ĩꞌdi pírí ị́mbị́ la ꞌbã ace ku. ");
INSERT INTO luc_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ãnãkpá ĩminí pẽlé rĩ ꞌbã adru kí kãbĩlõ ágó jõku ị̃ndrị́ ágó bị́lẹ́mị kóru calépi ílí ãlu rá la. ");
INSERT INTO luc_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ĩmba kí tã cajó ĩmbá ꞌbã ụ́ꞌdụ́ mụdrị́ drị̃ sụ rĩ gá, ꞌbá ũꞌbí Ịsịrayị́lị̃ drị̂ ꞌbã ụlị́ kí dó ãnãkpá ꞌdĩ kí ĩndró sĩ. ");
INSERT INTO luc_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ꞌDã ꞌbã ũngúkú gá, ꞌbã aꞌị́ kí ãnãkpá ụlị́lé ꞌdĩ kí ꞌbã ãrí ãzíla ꞌbã trị kí ĩꞌdi kẹ̃jị́tị ꞌbã fụ̃rẹ́mụ̃ bụ́lụ́ gá, ãzíla ụrụgá rĩ gá jó ĩꞌbã kí sĩ ãnãkpá ꞌdĩ kí ĩzá najó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ị́nị́ ꞌdã ꞌbã vúŋá sĩ ꞌbã na kí ĩzá ꞌdĩ ãcí drị̃ gá ꞌdâ ịbịbị́ ụ̃jị́ la sĩ ãzíla mũkátĩ ãkụ́kị́ kóru rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ĩna ĩzá la ị̃bị rú ku jõku ĩmi aꞌdí ĩꞌdi aꞌdí aꞌdî ku, úꞌbã ĩꞌdi ũꞌbĩlé ãcí drị̃ gá táni drị̃kã, kícũ, ífí ĩmi ũꞌbĩ kí ũꞌbĩ-ũꞌbĩ. ");
INSERT INTO luc_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ĩmi aꞌbe ị́mbị́ la cajó ụ̃ꞌbụ́tị gá ku, ãzíla drĩ kí ru aꞌbe rá, ĩmi ivé kí rá. ");
INSERT INTO luc_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ĩna ĩꞌdi mbẽlẽ-mbẽlẽ, ị̃sụ̃ ĩmi bábá ãcị̃ ní ãko pá gá trũ, túré trũ drị́ gá ꞌdĩ ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ Úpí drị́ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Ị́nị́ ãlu ꞌdã sĩ ma mụ alịlé ãngũ Mị̃sị́rị̃ drị̂ agâ sĩ, ma mụ anzị kãjãní ꞌbá ꞌbadrị̂ kí ụꞌdị́lé ãnãkpá ꞌbadrị̂ kí abe pírí, ma vâ mụ ị́jọ́ lịlẹ́ ãdroŋa Mị̃sị́rị̃ gá rĩ kí drị̃ gá pírí. Ma Úpí ru ma ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ãrí ꞌdĩ la dó adru ícétáŋá ru jó ĩminí adrujó ala gá rĩ kí iꞌdajó; ị́jọ́ ꞌdĩ sĩ ádrĩ dó ãrí ndre ꞌbo ma alị ĩmĩ drị̃ gâsĩ alị-alị. Jụ́wẹ̃ ꞌdĩ aló ĩmi ku mání ꞌbá Mị̃sị́rị̃ drị̂ kí aco agá. ");
INSERT INTO luc_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ĩmi ị̃nzị̃ ụ́ꞌdụ́ ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ rĩ ꞌi sĩ ị́jọ́ Úpí ꞌbã ándrá idélé ĩminí rĩ igájó anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbaní pírí. ");
INSERT INTO luc_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ụ́ꞌdụ́ ázị̂rị̃ ꞌdĩ kí agá lẽ ĩna mũkátĩ ãkụ́kị́ kóru rĩ áyụ, ụ́ꞌdụ́ drị̃drị̃ rĩ sĩ ĩmi iyá ãkụ̃kị́ kí ĩmidrị́ jó agâlé ãmvé ꞌbá ãzí ãko ãkụ́kị́ trũ rĩ nalépi ụ́ꞌdụ́ drị̃drị̃ ázị̂rị̃ ꞌdã agá rĩ sĩ rĩ lẽ údro ĩꞌdi Ịsịrayị́lị̃ kí agá rá. ");
INSERT INTO luc_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ụ́ꞌdụ́ drị̃drị̃ rĩ kí ụ́ꞌdụ́ ázị̂rị̃ rĩ be ꞌbã adru kí ĩminí ụ́ꞌdụ́ ãlá sĩ ru trajó ị̃nzị̃táŋá idéjó rĩ kî, ĩnga ãzị́ ãluŋá la kí agá ku, be la rá la ĩmi icó íná aꞌdílé ĩminí nalé rá. ");
INSERT INTO luc_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Ĩꞌbã ụ́ꞌdụ́ ụ̃mụ̃ Mũkátĩ Ãkụ́kị́ kóru rĩ drị́ gá rĩ ãmbógó ru ị̃nzị̃táŋá ru, ãꞌdusĩku ꞌdĩ ụ́ꞌdụ́ ándrá mání sĩ ĩmi drĩdríŋĩ cojó ꞌbá Mị̃sị́rị̃ gá rĩ kí abe rĩ ꞌi. Ĩmi dó sĩ ụ́ꞌdụ́ ꞌdĩ tã mba ãzị́táŋá ru anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ĩmbá drị̃drị̃ rĩ sĩ ĩna mũkátĩ ãkụ́kị́ kóru rĩ áyụ, iꞌdójó ĩndró ụ́ꞌdụ́ mụdrị́ drị̃ sụ rĩ drị̂ sĩ cajó kpere ụ́ꞌdụ́ kãlị́ ị̃rị̃ drị̃ ãlu rĩ drị̂ ꞌbã ĩndró sĩ. ");
INSERT INTO luc_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Lẽ ísụ́ ãkụ́kị́ jó mídrị̂ agá ꞌdãá ku cajó ụ́ꞌdụ́ ázị̂rị̃ ꞌdĩpí. ꞌBá ịsụ́lé ãko ãkụ̃kị́ trũ rĩ nalépi rĩ lẽ únze ĩꞌdi ꞌbá ũꞌbí Ịsịrayị́lị̃ drị̂ kí agá ꞌdãá rá, jõ táni ꞌbá ãmị́yọ́ŋá ru la jõku ãngũ ꞌdị́pị ru la. ");
INSERT INTO luc_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ĩna ãko idélé ãkụ̃kị́ sĩ la kí ku. Táni ãngũ ĩminí sĩ uꞌájó rĩ gá, lẽ ĩna mũkátĩ ãkụ́kị́ kóru rĩ áyụ.” ");
INSERT INTO luc_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ị́jọ́ ꞌdĩ sĩ Mụ́sã umve dó ꞌbá ĩyõ Ịsịrayị́lị̃ drị̂ kí ĩꞌdi rụ́ ꞌdõlé jọ dó ĩꞌbaní, “Ĩmụ cọtị́ ĩmi ũpẽ ãnãkpá lị́cọ́ ĩmidrị̂ kí vú sĩ ĩmi ụlị́ dó kãbĩlõmvá ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ rĩ drị̂ kî. ");
INSERT INTO luc_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ĩmi ãnũ ũdúgó bị́ kí, ĩsu kí ãrí bãkụ́lẹ̃ gá rĩ agá ĩmi ũyã ãzí rĩ kí kẹ̃jị́tị gá ụrụ gá ꞌdãá ãzí rĩ kẹ̃jị́tị ꞌbã fụ̃rẹ́mụ̃ kí gá. ꞌBá ãzí ꞌbã ãfũ jó agâlé ãmvé ku cajó kpere ụ̃ꞌbụ́tị sĩ. ");
INSERT INTO luc_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Úpí drĩ alị ãngũ Mị̃sị́rị̃ drị̂ agâ sĩ anzị Mị̃sị́rị̃ gá rĩ kí ụꞌdị́jó, ĩꞌdi ãrí ꞌdĩ ndre kẹ̃jị́tị gá ụrụ gá ãzíla kẹ̃jị́tị ꞌbã fụ̃rẹ́mụ̃ kí agá, ĩꞌdi dó alị jó ꞌdĩ drị̃ gâsĩ mãlãyíkã ꞌbá ụꞌdị́lépi rĩ fi dó sĩ jó agâlé ꞌbá ꞌdịlé ku. ");
INSERT INTO luc_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Ĩmi ũbĩ ị́jọ́ ãzị́táŋá ru ꞌdĩ kí vú anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe ãzíla drị̃lẹ́ ĩmidrị́ gá rĩ kí trũ sĩ kí tã mbajó jãꞌdâ. ");
INSERT INTO luc_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ĩdrĩ fi ãngũ Úpí ꞌbã azịlé ĩꞌdi mụ fẽlé la ĩminí rĩ agâlé ꞌbo, lẽ ĩmba jõ ị́jọ́ ụ̃mụ̃ ꞌdĩ drị̂ tã. ");
INSERT INTO luc_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ drĩ kí ĩmi zị, ‘Ị́jọ́ ụ̃mụ̃ ꞌdĩ drị̂ ꞌbã ífí íngoní yã?’ ");
INSERT INTO luc_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Ĩjọ ĩꞌbaní, ‘ꞌDĩ ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ idélé ídétáŋá ru Úpí ní sĩ ĩꞌdi ị̃nzị̃jó rĩ ꞌi, ãꞌdusĩku ĩꞌdi ꞌbã ándrá alịjó jó ꞌbá Ịsịrayị́lị̃ ꞌbadrị̂ kí drị̃ gâsĩ ãngũ Mị̃sị́rị̃ drị̂ agâ sĩ rĩ sĩ, pa ándrá ꞌbá ãmadrị̂ kí ãzíla ụꞌdị́ ándrá ꞌbá Mị̃sị́rị̃ drị̂ kí ꞌbã anzị kãjãní rĩ kí rá.’” ꞌBá ĩyõ Ịsịrayị́lị̃ drị̂ tị̃ kí dó ãja vụ̃rụ́ ị̃nzị̃ kí dó sĩ Úpí ꞌi rá. ");
INSERT INTO luc_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ꞌBá Ịsịrayị́lị̃ drị̂ idé kí ị́jọ́ Úpí ꞌbã ãzị́táŋá fẽjó Mụ́sã ꞌbadrị́ Ãrọ́nị̃ be rĩ rá. ");
INSERT INTO luc_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ĩꞌdi mụ calé ị́nị́ ágágá Úpí ụꞌdị́ anzị kãjãní ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbadrị̂ kí pírí, iꞌdójó Fãráwũ ꞌbã ngọ́tị́ kãjãní rilépi úmvúke ĩꞌdidrị̂ drị̃ gá rĩ sĩ, ꞌbá ꞌbãlé mãbụ́sụ̃ gá ãngũ ịnị rĩ gá rĩ ꞌbã anzị kãjãní rĩ kí, ãzíla ãnãkpá ꞌbã mvaka kãjãní rĩ kí pírí ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Fãráwũ kí ꞌbá ãmbogo ĩꞌdidrị̂ kí abe ãzíla ꞌbá Mị̃sị́rị̃ drị̂ kí abe ángá kí pírí ụrụgá ị́nị́ ꞌdã sĩ, áwáŋá ãmbógó la angá dó ãngũ Mị̃sị́rị̃ drị̂ agá nĩ, lị́cọ́ ãzí ãlu ꞌbá ãzí ꞌbãsĩ drãjó ala gá ku la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Fãráwũ umve Mụ́sã kí Ãrọ́nị̃ be ị́nị́ ꞌdã sĩ jọ ĩꞌbaní, “Ĩmi ĩdã ĩmi! Ĩmi aꞌbe ꞌbá mádrị̂ kî, ãzíla ĩꞌdụ ꞌbá Ịsịrayị́lị̃ drị́ ị́mbị́ acelépi rĩ kí ĩmi abe! Ĩmụ, Úpí ĩmidrị̂ ị̃nzị̃lé ĩminí aꞌị́lé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ĩꞌdụ ĩmi kãbĩlõ kí tị́ kí abe, ĩmụ ĩminí jọlé rĩ áni, má aꞌị́ ĩmi mání ásị́ ị̃gbẹ̃ aꞌbejó.” ");
INSERT INTO luc_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ꞌBá Mị̃sị́rị̃ drị̂ ũŋmĩ kí ꞌbá Ịsịrayị́lị̃ drị́ ꞌdĩ kí ũkpó sĩ sĩ ãngũ ĩꞌba drị̂ aꞌbejó. Ãꞌdusĩku jọ kí, ꞌbá ꞌdĩ drĩ kí mụ ku, “Ãma mụ ũdrãlé pírí!” ");
INSERT INTO luc_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ị́jọ́ ꞌdĩ kí vúlé gá ꞌbá Ịsịrayị́lị̃ drị̂ tra kí dó ãnáfóró ãkụ́kị́ kóru rĩ kí, ãko sĩ mũkátĩ uꞌbéjó rĩ kí abe umbé kí dó kí bõngó sĩ ãngũ ãlu gá sĩ kí gĩjó kọ́trọ́ gá. ");
INSERT INTO luc_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ꞌBá Ịsịrayị́lị̃ drị̂ idé kí cécé Mụ́sã ꞌbã lũlé ĩꞌbaní rĩ áni, aꞌị́ kí ãko idélé sílĩvã sĩ, gólũdĩ sĩ ãzíla bõngó sụ̃lé sụ̃sụ̃ rĩ kí ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbadrị́. ");
INSERT INTO luc_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Úpí fẽ ásị́ ị̃gbẹ̃ ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbaní ndre kí dó sĩ ꞌbá Ịsịrayị́lị̃ drị̂ kí múké ãzíla ꞌbá Mị̃sị́rị̃ drị̂ fẽ kí dó sĩ ĩꞌbaní ãko ĩꞌbã kí aꞌị́lé rĩ kí rá; upa kí dó sĩ ꞌbá Mị̃sị́rị̃ drị̂ kí ꞌbã málĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ꞌBá Ịsịrayị́lị̃ drị̂ iꞌdó kí dó ãcị̃ angájó táwụ̃nị̃ Rãmãsẹ́sị̃ gá trũ mụjó táwụ̃nị̃ Sụ̃kọ́tị̃ gá. ꞌBá ãgọbị rú mụlépi pá sĩ rĩ kí ãni rú 600,000 ala gá ũkú kí anzị́ŋá kí abe úlã kí ku. ");
INSERT INTO luc_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ꞌBá ũꞌbí ãzí mụ kí ĩꞌba abe ĩndĩ, dro kí ãnãkpá ũꞌbí, ị̃ndrị́, kãbĩlõ ãzíla tị́ kí abe. ");
INSERT INTO luc_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ãnáfóró ĩꞌbã kí ajílé Mị̃sị́rị̃ gâlé rĩ sĩ idé kí mũkátĩ ãkụ́kị́ kóru rĩ kî, ãꞌdusĩku ádró kí angájó Mị̃sị́rị̃ gâlé rĩ sĩ ũkpó sĩ ãnáfóró ãkụ́kị́ kóru rĩ trũ, ịsụ́ kí dó sáwã sĩ ĩꞌbaní ãkónã aꞌdíjó ku. ");
INSERT INTO luc_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ílí ꞌBá Ịsịrayị́lị̃ drị̂ ꞌbã kí uꞌájó Mị̃sị́rị̃ gá rĩ pírí ílí 430. ");
INSERT INTO luc_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ílí 430 ꞌbã ukóŋá gá, kpere ụ́ꞌdụ́ ꞌdã sĩ, sụ́rụ́ Úpí drị̂ ꞌbã ꞌbá aꞌbe kí ãngũ Mị̃sị́rị̃ drị́ gá rĩ rá. ");
INSERT INTO luc_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ãngũ ꞌbã adrujó ị́nị́ rĩ sĩ Úpí mba ꞌbá kí tã nĩ ĩꞌdiní ꞌbá kí anzéjó Mị̃sị́rị̃ gâlé ꞌbo rĩ sĩ, lẽ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã mba kí ị́nị́ ãlu ꞌdĩ tã Úpí ní ị̃nzị̃táŋá ru anzị ĩꞌbadrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe pírí ílí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Úpí jọ Mụ́sã ꞌbaní Ãrọ́nị̃ be, “ꞌdĩ kí ãzị́táŋá ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ rĩ drị̂ kî: ꞌBá ãmị́yọ́ŋá ru rĩ ꞌbã na kí ku. ");
INSERT INTO luc_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ꞌBá ĩminí ĩgbãlé ãtíꞌbó ru séndẽ sĩ rĩ kí ĩmi ĩtãrã kí rá ká ꞌbã na kí ĩndõ, ");
INSERT INTO luc_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","wó ꞌbá ãmụ́ ru rĩ kí ꞌbá iyólé iyô rĩ abe ꞌbã na kí ku. ");
INSERT INTO luc_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Ĩzá idélé ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ rĩ drị́ rĩ úna ĩꞌdi jó la sĩ ĩꞌdi idéjó rĩ agá ũgũgõ, âfũ ị́mbị́ la trũ ãmvé ku, ãzíla ânu ĩfãkã ãnãkpá la ꞌdã drị̂ ku. ");
INSERT INTO luc_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ꞌBá ũꞌbí Ịsịrayị́lị̃ drị̂ kí pírí ꞌbã nga kí ụ̃mụ̃ ị̃nzị̃táŋá ru ꞌdĩ idélé rá. ");
INSERT INTO luc_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“ꞌBá ãmị́yọ́ŋá ru lẽlépi ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ Úpí drị́ gá ꞌdĩ ị̃nzị̃lépi ĩndĩ rĩ lẽ ꞌbã ĩtãrã ꞌbá ãgọbị rú ĩꞌdidrị́ko gá rĩ kí pírí rá; ĩꞌdi dó sĩ adru ãngũ ꞌdị́pị rú ĩndõ. Bá ãgọbị rú ĩtãrãlé ku rĩ ꞌbã na kí ụ̃mụ̃ ꞌdĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ãzị́táŋá ãlu ꞌdĩ ꞌbã vúŋá la ãzị́ nga ꞌbá ãngũ ꞌdị́pị rú tịlé rĩ ní, ãzíla ꞌbá ãmị́yọ́ŋá ru rĩ ní ĩndĩ.” ");
INSERT INTO luc_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ꞌBá Ịsịrayị́lị̃ drị̂ kí pírí idé kí ị́jọ́ kí Úpí ꞌbã jọlé Mụ́sã kí tị gá Ãrọ́nị̃ be rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Iꞌdójó ụ́ꞌdụ́ ꞌdã sĩ cọtị́ Úpí anzé ꞌbá Ịsịrayị́lị̃ drị̂ kí sụ́rụ́ tị vú sĩ ãngũ Mị̃sị́rị̃ drị̂ agâlé rá. ");
INSERT INTO luc_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Úpí jọ Mụ́sã nî, ");
INSERT INTO luc_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Mí ũpẽ mání anzị kãjãní rĩ kí ndú, ãꞌdusĩku anzị ãgọbị kãjãní ꞌbá Ịsịrayị́lị̃ drị̂ ãzíla ãnãkpá pírí kãjãní ágó rĩ kí mâni.” ");
INSERT INTO luc_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mụ́sã jọ ꞌbá ꞌbanî, “Ĩmi ũrã jõ ụ́ꞌdụ́ ꞌdĩ ꞌbã ị́jọ́, ꞌdĩ ụ́ꞌdụ́ ándrá ĩminí ãfũjó Mị̃sị́rị̃ gâlé rĩ ꞌi, ãzíla ãngũ ĩminí ándrá sĩ adrujó alagá ãtíꞌbó ru rĩ ꞌi, ãꞌdusĩku Úpí anzé ándrá ĩmi Mị̃sị́rị̃ gâlé ãmvé drị́ ũkpó ĩꞌdidrị̂ sĩ. Lẽ ĩna mũkátĩ ãkụ́kị́ trũ la ku. ");
INSERT INTO luc_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ãndrũ ĩmbá Ãbíbũ drị́ ꞌdĩ ĩminí sĩ fũjó Mị̃sị́rị̃ gá ꞌdâ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Úpí drĩ ĩmi ufí ãngũ ꞌbá kãnánĩ rú, Hị́tị̃ rú, Ãmọ́rị̃ rú, Hị́vị̃ rú, ãzíla Yẹ̃bụ́sị̃ rú rĩ ꞌbadrị̂ kí agá ĩꞌdiní ũyõ nalé ꞌi fẽ la ĩmĩ áyị́pịka ꞌbaní, ãngũ málĩ trũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ lé ꞌbã sĩ rajó ala gá ãnụ́ úsã be rĩ gá ꞌbo, ĩmi ị̃nzị̃ ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ rĩ ĩmbá Ãbíbũ drị́ ꞌdĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ụ́ꞌdụ́ ázị̂rị̃ ꞌdĩ kí agá lẽ ĩna mũkátĩ ãkụ́kị́ kóru rĩ áyụ, ãzíla ụ́ꞌdụ́ ázị̂rị̃ rĩ sĩ ĩmi idé dó ụ̃mụ̃ Úpí nî sĩ ĩꞌdi ị̃nzị̃jó. ");
INSERT INTO luc_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ĩna mũkátĩ ãkụ́kị́ kóru rĩ ụ́ꞌdụ́ ázị̂rị̃ ꞌdã kí agá, ãko ãzí ãkụ́kị́ trũ la ꞌbã indré ĩmi drĩdríŋĩ gá ku, jõ ku ãkụ́kị́ ndrejó ãngũ ãzí agá lõkókõrí ĩmidrị̂ gá la ꞌbã adru yụ. ");
INSERT INTO luc_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ụ́ꞌdụ́ ꞌdã sĩ míní ụ̃mụ̃ ꞌdĩ na agá, ínze vú la anzị mídrị̂ ꞌbanî, ‘Ma ị́jọ́ ꞌdĩ idé íni la ị́jọ́ Úpí ꞌbã idélé sĩ áma ũfũjó Mị̃sị́rị̃ gâlé rá rĩ sĩ.’ ");
INSERT INTO luc_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ụ̃mụ̃ ꞌdĩ naŋá ꞌbã igá mi ị́jọ́ Úpí ꞌbã idélé míní rĩ ũrãjó ĩꞌdi ꞌbã ími anzéjó drị́ ũkpó ĩꞌdidrị̂ sĩ Mị̃sị́rị̃ gâlé rĩ sĩ. Lẽ ꞌbã adru míní ãko sụ̃lé ícétáŋá ru drị́ gá ãzíla ími androko gá rĩ rú, ị́jọ́ ꞌdĩ sĩ lẽ ãzị́táŋá Úpí drị̂ ꞌbã ãvĩ ími tị gá ku, íngo ĩꞌdi ãzíla mí ụ̃nị̃ ĩꞌdi. ");
INSERT INTO luc_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ĩmi ị̃nzị̃ ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ ꞌdĩ ãzị́táŋá ru ụ́ꞌdụ́ pẽlé rĩ sĩ ílí ãlu-ãlu vú sĩ. ");
INSERT INTO luc_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Úpí drĩ ĩmi ají ãngũ ꞌbá Kãnánĩ rú rĩ ꞌbadrị̂ gá, ĩꞌdiní ũyõ la najó ĩminí ãzíla ĩmĩ áyị́pịka ꞌbaní rĩ gá ꞌbo, ãzíla drĩ dó fẽ la ĩminí rá, ");
INSERT INTO luc_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ĩmi anzị ãgọbị ĩmidrị́ kãjãní rĩ kí fẽ ãnãkpá ágó kãjãní rĩ abe pírí Úpí nî. ");
INSERT INTO luc_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kãyĩnõ mváŋá kãjãní rĩ mi unze la kãbĩlõ fẽjó kẹ̃jị́ la gá rĩ sĩ, ídrĩ lẽ unzelé la ku mi imbe la nũ rá. Lẽ mí unze anzị ãgọbị kãjãní rĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Ụ́ꞌdụ́ drị̃lẹ́ gá rĩ sĩ, ngọ́tị́ mídrị̂ drĩ ími zị ‘Ụ̃mụ̃ ꞌdĩ ꞌbã ífí íngoní yã?’ Mi umvi la, ‘Úpí ayú drị́ ũkpó ĩꞌdidrị̂ ꞌi sĩ ãma ũfũjó Mị̃sị́rị̃ gâlé, ãngũ ãmaní ándrá adrujó ãtíꞌbó ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Fãráwũ drị̃ ũnzĩ sĩ uga ándrá ãmaní ãfũlé úmgbé, Úpí ụꞌdị́ ándrá anzị ãgọbị ãzíla ãnãkpá ágó kãjãní Mị̃sị́rị̃ gá rĩ kí pírí. Ị́jọ́ ꞌdĩ bãsĩ ãma ní ãnãkpá ágó kãjãní rĩ kí fẽjó Úpí ní ꞌdĩ, ãzíla ãma anzị ãgọbị kãjãní ãmadrị̂ kí unze ãjẹ̃ sĩ.’ ");
INSERT INTO luc_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Lẽ ụ̃mụ̃ ꞌdĩ ꞌbã adru ĩminí ãko sụ̃lé ícétáŋá ru drị́ gá ãzíla ĩmi androko gá rĩ áni sĩ ĩmi igájó Úpí unze ándrá ĩmi Mị̃sị́rị̃ gâlé drị́ ũkpó ĩꞌdidrị̂ sĩ.” ");
INSERT INTO luc_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Fãráwũ la mụ ꞌbá kí aꞌbelé mụlé ꞌbo, Ãdróŋá ꞌde kí drị̃ ãngũ ꞌbá Fị̃lị̃sị̃tị́nị̃ rú rĩ ꞌbadrị̂ gâsĩ ku, táni ĩꞌdiní adrujó ãni rú rá tí, ãꞌdusĩku Ãdróŋá jọ, “Ãꞌdị́ drĩ mụ ꞌdelé ꞌbo, ꞌbá ꞌdĩ kí ru ũrãtáŋá uja sĩ gõjó vúlé Mị̃sị́rị̃ gâlé. ");
INSERT INTO luc_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ị́jọ́ ꞌdĩ sĩ Ãdróŋá ꞌde kí drị̃ nĩ, pi kí dó sĩ ru gẹ̃rị̃ sĩ mụjó kõtórõ gâsĩ drị̃ jajó sĩ mụjó Mĩrĩ Ika rĩ gâlé. ꞌBá Ịsịrayị́lị̃ drị̂ fũ kí Mị̃sị́rị̃ gá ꞌdâ bábá ãko ĩꞌbadrị́ ãꞌdị́ ꞌdịjó rĩ kí trũ.” ");
INSERT INTO luc_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mụ́sã ꞌdụ ĩfãkã Yụ̃sụ́fụ̃ drị̂ kí ĩꞌdi be ĩndĩ, ãꞌdusĩku Yụ̃sụ́fụ̃ fẽ ándrá anzị Ịsịrayị́lị̃ drị̂ ꞌbaní ũyõ nalé, Yụ̃sụ́fụ̃ jọ, “Ãdróŋá drĩ ĩmi ãzã ko rá ĩꞌdụ jõ áma ĩfãkã kí ĩmi abe ĩndĩ.” ");
INSERT INTO luc_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ꞌBá Ịsịrayị́lị̃ drị̂ aꞌbe kí Sụ̃kọ́tị̃ mụ kí rĩlé Ĩtámũ gá, ꞌdĩ ãngũ kõtórõ rú rĩ ꞌbã iꞌdóŋá gá. ");
INSERT INTO luc_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Jõ ị̃tụ́ sĩ Úpí la mụ kí drị̃lẹ́ gá ụ̃rụ́ꞌbụ̃ iꞌdálépi ị́dị́ŋâ áni rĩ sĩ, jõ ị́nị́ sĩ ĩꞌdi mụ ãcí iꞌdálépi ị́dị́ŋâ áni rĩ sĩ ĩꞌbaní ãngũ jịjó kí dó sĩ acị́ ị̃tụ́ sĩ ãzíla ị́nị́ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ụ̃rụ́ꞌbụ̃ ị́dị́ŋâ áni ãnzị ị̃tụ́ sĩ rĩ ãzíla ãcí ị́dị́ŋá ru ãmbógó ị́nị́ sĩ rĩ ĩdã kí ru ꞌbá ꞌdĩ kí drị̃lẹ́ gá ꞌdãá ku. ");
INSERT INTO luc_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, ");
INSERT INTO luc_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ílũ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ru ujajó vúlé ãzíla sĩ ru trajó ãni rú Pĩ Hãhị̃rọ́tị̃ gá ꞌdĩ drĩdríŋĩ Mĩgĩdọ́lị̃ ꞌbã ãni Mĩrĩ Ika rĩ be rĩ gá. ꞌBã tra kí ru ãni rú Mĩrĩ tị gá, pịrị-pịrị wókõ Bãálĩ Zẽfónĩ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Fãráwũ la dó ũrã la, ‘Bá Ịsịrayị́lị̃ drị̂ kí dó wãyá co ásé agá ãngũ kõtórõ rú rĩ agá ꞌdĩ.’ ");
INSERT INTO luc_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ma Fãráwũ ásị́ ꞌbã mbalé mba-mbã, ĩꞌdi dó sĩ kí vú dro. Ma dó dị̃zã ịsụ́ Fãráwũ rụ̂ sĩ ãsĩkárĩ pírí ĩꞌdidrị̂ kí abe, ꞌbá Mị̃sị́rị̃ drị̂ kí dó sĩ nị̃ la ma Úpí ꞌi.” Ị́jọ́ ꞌdĩ sĩ ꞌbá Ịsịrayị́lị̃ drị̂ idé kí dó ị́jọ́ kí cécé lũlé ĩꞌbaní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ála mụ lũlé la úpí Mị̃sị́rị̃ drị̂ ní ꞌbá Ịsịrayị́lị̃ drị̂ mụ kí ꞌbo, Fãráwũ kí ꞌbá ĩꞌdidrị́ ãmbogo rú rĩ abe uja kí ĩꞌbã ũrãtáŋá ꞌbá ꞌdĩ kí drị̃ gá rĩ rá jọ kí, “Ị́jọ́ ãmaní idélé íni rĩ ãꞌdu? Ãma aꞌbe ꞌbá Ịsịrayị́lị̃ drị̂ kí mụlé rá ãzíla ãma ãvĩ kí vâ ãzị́ jõ ĩꞌbã kí ngalé ãmaní rĩ kí rá!” ");
INSERT INTO luc_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ị́jọ́ ꞌdĩ sĩ itú dó gá rĩ ãꞌdị́ drị̂ kí bábá ãzíla ꞌdụ dó ãsĩkárĩ ĩꞌdidrị̂ kí trũ mụjó. ");
INSERT INTO luc_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ꞌDụ dó fãrásĩ gá rĩ ãꞌdị́ drị̂ selépi múké ãndânĩ rĩ kí 600 ãzíla fãrásĩ pírí Mị̃sị́rị̃ gá ꞌdãá rĩ kí trũ, ãmbogo la kí drị̃ celépi rĩ abe. ");
INSERT INTO luc_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Úpí ꞌbã Fãráwũ úpí Mị̃sị́rị̃ drị̂ ꞌbã ásị́ mbalé ũkpómgboroto rú, inga dó sĩ ásị́ la ꞌbá Ịsịrayị́lị̃ drị̂ kí vú bĩjó, ĩꞌbã kí fũjó drị̃ ũkpõ sĩ rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ãsĩkárĩ Mị̃sị́rị̃ drị̂ bĩ kí ꞌbá Ịsịrayị́lị̃ drị̂ kí vú, Fãráwũ ꞌbã fãrásĩ kí, gá rĩ ãꞌdị́ drị̂ kí, ãzíla ꞌbá cẹ̃lépi la rĩ kí, ãsĩkárĩ kí abe pírí, ịsụ́ kí ꞌbá ꞌdĩ tra kí ru ị̃yị́ tị gá ãni rú Pĩ Hãhị̃rọ́tị̃ ꞌbã wókõ ãzí Bãálĩ Zẽfónĩ rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Fãráwũ la mụ kí ũŋmĩlé ꞌbo, ꞌbá Ịsịrayị́lị̃ drị̂ ndre kí ãngũ kí ũngúkú gâlé, ndre kí ꞌbá Mị̃sị́rị̃ gá rĩ kí kí vú ãbĩ agá. Acá kí ụ̃rị̃ sĩ ãzíla awá kí dó sĩ Úpí rụ́. ");
INSERT INTO luc_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Jọ kí Mụ́sã nî, “Mí ají ãma ũdrãlé kõtórõ agá ꞌdõlé ãngũ ꞌbã adrujó yụ sĩ ꞌbá kí ị̃sị̃jó Mị̃sị́rị̃ gâlé rĩ sĩ yã? Míní idélé íni ꞌdĩ dó ãꞌdu míní sĩ ãma anzéjó Mị̃sị́rị̃ gâlé rá? ");
INSERT INTO luc_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ãjọ ándrá míní Mị̃sị́rị̃ gá ꞌdãá, ‘Mí aꞌbe ãma, lẽ ãnga ãzị́ ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbanî rĩ gá ku yã?’ Ĩꞌdi ãmaní múké ãndânĩ sĩ ãzị́ ngajó ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbanî ndẽ ãmaní ũdrãjó ãngũ kõtórõ rú ꞌdĩ agá ꞌdâ rĩ rá!” ");
INSERT INTO luc_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mụ́sã umvi ꞌbá ꞌbaní, “Ĩmi idé ụ̃rị̃ sĩ ku. Ĩtu pá ũkpó ru ĩmi mụ úꞌdîꞌda patáŋá Úpí ꞌbã mụlé iꞌdalé ĩminí ãndrũ rĩ ndrelé rá. ꞌBá Mị̃sị́rị̃ drị́ ĩminí ndrelé ãndrũ ꞌdĩ kí ĩmi icó kí ndrelé ị̃dị́ ku. ");
INSERT INTO luc_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Úpí la mụ ãꞌdị́ ꞌdịlé ĩminí nĩ, lẽ ĩmi adru dríŋá.” ");
INSERT INTO luc_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, “Mi awá sĩ ãzãkoma ndrụ̃jó má rụ́ ãꞌdu ị́jọ́ sĩ? Íjọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ꞌbã mụ kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Mí ĩjũ ími drị́ Mĩrĩ drĩ gá ị́jọ́ ꞌdĩ sĩ ị̃yị́ la dó sĩ ru awa ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã za kí rú sĩ ãngũ ãꞌí gâsĩ. ");
INSERT INTO luc_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ma ꞌbá Mị̃sị́rị̃ drị̂ kí ásị́ ꞌbã mbalé mba-mbã ị́jọ́ ꞌdĩ sĩ kí dó sĩ fi kí vú gâsĩ. ꞌDãá ma dó sĩ dị̃zã ịsụ́ Fãráwũ drị́, ãsĩkárĩ ĩꞌdidrị̂ kí pírí, gárĩ ãꞌdị́ drị̂ kí ãzíla ãgọbị cẹ̃lépi fãrásĩ sĩ rĩ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ꞌBá Mị̃sị́rị̃ drị̂ kí dó sĩ nị̃ la ma Úpí ꞌi, ádrĩ dó dị̃zã ịsụ́ Fãráwũ rụ̂ sĩ, gárĩ ĩꞌdidrị́ ãꞌdị́ drị̂ kí, ãzíla ãgọbị cẹ̃lépi fãrásĩ sĩ rĩ ꞌbadrị́ ꞌbo rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Cọtị́ mãlãyíkã Ãdróŋá drị́ tá ãsĩkárĩ Ịsịrayị́lị̃ drị̂ kí drị̃ celépi nĩ rĩ uja dó ru kí ũngúkú gâlé ru. Ụ̃rụ́ꞌbụ̃ ãnzị ị́dị́ŋá áni rĩ ajá ru kí drị̃lẹ́ gâlé rĩ sĩ kí ũngúkú gá, ");
INSERT INTO luc_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ãzíla amụ́ dó pá tulé ãsĩkárĩ Mị̃sị́rị̃ ꞌbadrị̂ kí drĩdríŋĩ gá ꞌbá Ịsịrayị́lị̃ ꞌbadrị̂ abe. Ị́nị́-ãrã ụ̃rụ́ꞌbụ̃ ájí ị́nị́ wókõ ãzí rĩ nî ãzíla ãngũ ule wókõ ãzí rĩ nî, ꞌbá ãzí rĩ ca kí ꞌbá ãzí rĩ ꞌba rụ́ ãni rú ku ị́nị́ ꞌdã sĩ pírí. ");
INSERT INTO luc_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ꞌDã ꞌbã vúlé gá Mụ́sã ĩjũ ru drị́ ị̃yị́ drị̃ gá, ị́nị́ ꞌdã agá ꞌdãá pírí Úpí dro ị̃yị́ gõjó vúlé ãlụ́kụ́kụ̃ ũkpó angálépi ĩtụ́ ꞌbã ãfũ agâlé la sĩ, ãngũ acá dó sĩ ãꞌí ru, ị̃yị́ awa dó ru, ");
INSERT INTO luc_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ãzíla ꞌbá Ịsịrayị́lị̃ drị̂ za kí mĩrĩ agâ sĩ ãngũ ãꞌí gâsĩ, ị̃yị́ tu pá cí Bõrõ áni drị́ ị̃jị́ gá ãzíla ãndá gá. ");
INSERT INTO luc_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ãsĩkárĩ Mị̃sị́rị̃ drị̂ bĩ kí ꞌbá Ịsịrayị́lị̃ drị̂ kí vú, Fãráwũ ꞌbã fãrásĩ kí, gárĩ ãꞌdị́ drị̂ kí, ꞌbá cẹ̃lépi la rĩ kí abe fi kí ị̃yị́ agâlé ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ãngũsãrã sĩ Úpí andré ãngũ vụ̃rụ́ ꞌdõlé ụ̃rụ́ꞌbụ̃ ãnzị ị́dị́ŋá áni ãzíla ãcí ị́dị́ŋá áni ãmbógó rĩ agâ sĩ ãsĩkárĩ Mị̃sị́rị̃ drị̂ ꞌba rụ́ ãzíla drị̃ la ꞌbe kí dó ru rá. ");
INSERT INTO luc_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Úpí unze gárĩ ãꞌdị́ drị́ fãrásĩ ꞌbã kí selé rĩ ꞌbã pá kí rá, ꞌbã cẹ̃ kí rú sĩ tí be nĩ. ꞌBá Mị̃sị́rị̃ drị̂ jọ kí, “Úpí la ãꞌdị́ ꞌdị ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní nĩ! Lẽ ãma ĩdã kí ãma ĩꞌba rụ́ ꞌdâ rá.” ");
INSERT INTO luc_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, “Mí ĩjũ ími drị́ Mĩrĩ drị̃ gá, ị́jọ́ ꞌdĩ sĩ ị̃yị̂ la dó sĩ ãgõ vúlé ꞌdõlé ꞌbá Mị̃sị́rị̃ drị̂ kí ịmvụ́jó fãrásĩ ãzíla ꞌbá cẹ̃lépi fãrásĩ sĩ rĩ kí abe.” ");
INSERT INTO luc_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mụ́sã ĩjũ dó drị́ Mĩrĩ drị̃ gá, ãzíla ãngũ ꞌbã ụwị́ agá ꞌdĩ Mĩrĩ ãgõ dó ũkpó ĩꞌdiní údu rĩ trũ vúlé. ꞌBá Mị̃sị́rị̃ drị̂ ꞌbã kí apá agá, Úpí iti kí ị̃yị́ agá lé. ");
INSERT INTO luc_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ị̃yị́ icí dó ru vúlé aku dó gárĩ ãꞌdi drị̂ kí, ꞌbá fãrásĩ cẹ̃lépi rĩ kí trũ, mgbã rĩ gá aku ãsĩkárĩ Fãráwũ drị́ ꞌbá Ịsịrayị́lị̃ drị̂ kí vú bĩlépi Mĩrĩ agâlé ꞌdĩ kí pírí. Ãzí ãlu ru palépi rá la ꞌdá yụ. ");
INSERT INTO luc_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Wó ꞌbá Ịsịrayị́lị̃ drị̂ za kí ị̃yị́ agâ sĩ ãngũ ãꞌí gâsĩ, ị̃yị́ tu pá cí Bõrõ áni drị́ ị̃jị́ gá ãzíla drị́ ãndá gá. ");
INSERT INTO luc_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ụ́ꞌdụ́ ꞌdã sĩ Úpí pa ꞌbá Ịsịrayị́lị̃ drị̂ kí ꞌbá Mị̃sị́rị̃ drị̂ kí drị́ gá nĩ ãzíla ꞌbá Ịsịrayị́lị̃ drị̂ ndre kí ãvũ ꞌbá Mị̃sị́rị̃ drị̂ ꞌbadrị̂ kí ꞌbárá cínákí drị̃ gá ị̃yị́ tị gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ꞌBá Ịsịrayị́lị̃ drị̂ kí mụ ũkpõ ãmbógó Ãdróŋá drị́ ꞌbá Mị̃sị́rị̃ gá rĩ ꞌba rụ́ ꞌdĩ ndrelé, ụ̃rị̃ rụ ꞌbá Ịsịrayị́lị̃ drị̂ kí ị́jọ́ Úpí ꞌbã idélé ꞌdĩ kí sĩ ãzíla ꞌbã kí dó ãꞌị̃táŋá ĩꞌbadrị̂ Úpí kí drị̃ gá ãtíꞌbó ĩꞌdidrị́ Mụ́sã be. ");
INSERT INTO luc_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Mụ́sã kí ꞌbá Ịsịrayị́lị̃ drị̂ kí abe ngo kí úngó ꞌdĩ Úpí nî: “Ma úngó ngo Úpí ní, ãꞌdusĩku ndẽ ãꞌdị́ rá înga rú la ụrụgá. Fãrásĩ kí ꞌbá cẹ̃lépi drị̃ la gá rĩ abe uꞌbé kí ị̃yị́ agá. ");
INSERT INTO luc_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Úpí ĩꞌdi ũkpõ mádrị̂ ꞌi ãzíla ma úngó ngo ĩꞌdinî; Ĩꞌdi ꞌbá áma palépi rĩ ꞌi. Ĩꞌdi Ãdróŋá mádrị̂ ꞌi, ma ĩꞌdi ịcụ́ jãꞌdâ, Úpí má átẹ́pị drị̂, ãzíla ma ãmbõgõ ĩꞌdidrị̂ ungo. ");
INSERT INTO luc_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Úpí ĩꞌdi ꞌbá ãꞌdị́ ꞌdịlépi rĩ; rụ́ la Úpí ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Fãráwũ ꞌbã gárĩ ãꞌdị́ drị̂ kí ãsĩkárĩ abe uꞌbé kí ị̃yị́ agá. Ãsĩkárĩ ãmbogo Fãráwũ drị́ múké ãndânĩ rĩ kí ịmvụ́ kí Mĩrĩ Ika rĩ agá. ");
INSERT INTO luc_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ị̃yị́ kị́rị́ rĩ aku kí drị̃ cí; ꞌDe kí ị̃yị́ ị̃ndụ́ gâlé cécé írã áni. ");
INSERT INTO luc_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Úpí, ími drị́ ãndá rĩ, iꞌda ũkpõ mídrị́ ãmbógó rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ũkpõ mídrị́ ãmbógó rĩ sĩ mí uꞌbé ꞌbá ími lẽlépi ku rĩ kí vụ̃rụ́. Ínzị̃ ũmbã mídrị́ ãcí ru rĩ kí drị̃ gá; Ivé kí rúmú-rúmú ásé áni. ");
INSERT INTO luc_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ũlí míní vúlé ũmvu sĩ rĩ tra ị̃yị́ ụrụ gá. Ị̃yị́ umvúlépi tũlãtũlã rĩ tra ru ãzíla tu pá Bõrõ áni; ị̃yị́ ị̃yị́ ꞌbã ágádrị̃ gá kị́rị́ rĩ tra ru ulílé ũkpó ru. ");
INSERT INTO luc_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mẹ́rọ́ꞌbá ịpị́ kí ru, ‘Ma kí vú bĩ, ma kí arụ́ rá. Ma ãko ĩꞌbadrị́ mání arálé rĩ kí awa; Áma ꞌa la aga kî sĩ. Ma ménéŋá mádrị̂ anzé, ma kí ị̃lị̃kị̃ ĩꞌdi sĩ.’ ");
INSERT INTO luc_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Wó ívu kí ũlí ími ũmvu gá rĩ sĩ, ãzíla ị̃yị́ aku kí drị̃ rá. ꞌDe kí ị̃yị́ ị̃ndụ́ gâlé cécé írã ꞌbã ꞌdelé ị̃yị́ ũkpó agá rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Úpí, ãꞌdi ꞌi ãdroŋa kí agá mî áni la nĩ yã? Ãꞌdi ꞌi mî áni rĩ gá nĩ? Dị̃zã rú ãzíla ãlá ru, Ãzị́ míní ngalé rĩ ụ̃sụ̃táŋá ru ");
INSERT INTO luc_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Mí ĩjũ ími drị́ ãndá rĩ Vũ uti mẹ́rọ́ꞌbá kí rá. ");
INSERT INTO luc_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Lẽtáŋá mídrị́ aꞌdélépi ku rĩ sĩ, íꞌde ꞌbá míní anzélé rĩ kí drị̃. Ũkpõ mídrị̂ sĩ mi kí andre tẽ, ãngũ ãlá míní sĩ uꞌájó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Sụ́rụ́ drĩ kí are la ãzíla kí yã-yã; ũcõgõ la ꞌbá Fị̃lị̃sị̃tị́nị̃ gá rĩ kí rụ cí. ");
INSERT INTO luc_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Drị̃lẹ́ Ídõmũ gá rĩ kí idé ụ̃rị̃ sĩ, Drị̃lẹ́ Mụ̃wábụ̃ gá rĩ kí ụ̃rị̃ la kí rụ yãŋá trũ, ꞌbá Kãnánĩ drị̂ kí aká ralé sụ́sụ́ ru; ");
INSERT INTO luc_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ụ̃rị̃ ãmbógó la fi kí ásị́ gá nĩ. Drĩ kí drị́ ũkpó mídrị̂ ndre kí pá tu ãvẹ̃vị̃ kóru ụ̃rị̃ sĩ kpere ꞌbá mídrị̂ ꞌbã kí alị agá, Úpí, kpere ꞌbá míní apálé rĩ ꞌbã kí alị agá. ");
INSERT INTO luc_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Mi kí ají ãzíla mi kí iri ꞌbé mídrị̂ drị̃ gá, ãngũ míní idélé míní sĩ uꞌájó rĩ gá Úpí, ãngũ ãlápítí, Úpí míní idélé drị́ mídrị̂ sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Úpí mi adru Úpí ru jãꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ꞌBá Ịsịrayị́lị̃ drị̂ ꞌbã kí alịjó ị̃yị́ agá ãngũ ãꞌí rĩ drị̃ gâsĩ rĩ sĩ, Fãráwũ ꞌbã fãrásĩ kí, gárĩ ãꞌdị́ drị̂ kí, ꞌbá cẹ̃lépi la rĩ kí abe fi kí ị̃yị́ agâlé, Úpí ají ị̃yị́ kí drị̃ akulé mũꞌdũ. ");
INSERT INTO luc_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Nábị̃ ũkú ru Míríyãmũ Ãrọ́nị̃ ꞌbã ámvọ́pị aꞌdụ́ kụ́lịmvá drị́ gá, ãzíla ũkú pírí bĩ kí ĩꞌdi vú, ãko ĩꞌbadrị́ úngó drị̂ trũ ãzíla úngó tuŋá trũ. ");
INSERT INTO luc_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Míríyãmũ ngo úngó ĩꞌbanî “Ma úngó ngo Úpí ní, ãꞌdusĩku ndẽ ãꞌdị́ rá înga rụ́ la ụrụgá. Fãrásĩ kí ꞌbá cẹ̃lépi drị̃ la gá rĩ kí abe uꞌbé kí ị̃yị́ agá.” ");
INSERT INTO luc_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ị́jọ́ ꞌdã ꞌbã vúlé gá Mụ́sã ꞌde dó ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃ Mĩrĩ Ika rĩ gá rĩ sĩ, mụ kí dó ãngũ kõtórõ ru Sụ́rị̃ gá. Acị́ kí ãngũ kõtórõ rú rĩ agá ụ́ꞌdụ́ na ịsụ́ kí ị̃yị́ ku. ");
INSERT INTO luc_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Kí mụ acálé Márã gá ꞌbo, icó kí ị̃yị́ ꞌdãá rĩ mvụlé ku ãꞌdusĩku ị̃yị̂ ụ̃jị́-ụ̃jị́. (Ị́jọ́ ꞌdĩ bãsĩ ĩꞌbaní ãngũ ꞌdã ꞌbã rụ́ ꞌdajó Márã ꞌi ꞌdĩ.) ");
INSERT INTO luc_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ꞌBá unu kí Mụ́sã ụrụꞌbá gá, jọ kí, “Ãma dó mụ ãꞌdu mvụlé?” ");
INSERT INTO luc_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mụ́sã ꞌbã mãmálá Úpí drị̃lẹ́ gá, ãzíla Úpí iꞌda ĩꞌdiní ife dụ́lụ́. ꞌBe ife ị̃yị́ agá, ãzíla ị̃yị̂ uja dó sĩ ru ãjị́-ambamba rú mvụlé mvụ-mvụ̃. Ãngũ ꞌdã gá ꞌdãá Úpí azị ãzị́táŋá ĩꞌbaní, ãzíla ụ̃ꞌbị̃ sĩ kî. ");
INSERT INTO luc_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Jọ ĩꞌbaní, “Ĩdrĩ Úpí Ãdróŋá ĩmidrị̂ tị are múké-múké, ãzíla ĩdrĩ ị́jọ́ áma mịfị́ gá múké rĩ kí idé áyụ, ĩdrĩ ásị́ ꞌbã ãzị́táŋá mání azịlé rĩ kí tãmbajó rá, Má icó ãyánĩ ándrá mání ajílé ꞌbá Mị̃sị́rị̃ gá rĩ kí drị̃ gá rĩ ajílé ĩmi drị̃ gá ku, ãꞌdusĩku ma Úpí ĩmi adrílépi rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ꞌBá ꞌdĩ mụ kí dó Ị̃lị́mụ̃ gá, ꞌdãá ị̃yị́ kídí ru rĩ kí mụdrị́ drị̃ ị̃rị̃, ãzíla káci kí kãlị́ ázị̂rị̃, ãzíla ri kí dó ị̃yị́ tị gá ꞌdãá ãni rú. ");
INSERT INTO luc_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ꞌBá ũꞌbí Ịsịrayị́lị̃ drị̂ ko kí dó pírí drị̃ mụlé angájó Ị̃lị́mụ̃ gá rĩ sĩ ãzíla ca kí dó kõtórõ umvelé Sínĩ rĩ gá, ꞌdĩ drĩdríŋĩ Ị̃lị́mụ̃ ꞌbadrị́ Sĩnáyĩ be rĩ gá ĩmbá ị̃rị̃ rĩ ꞌbã ụ́ꞌdụ́ mụdrị́ drị̃ tõwú rĩ sĩ ꞌdĩ ĩꞌbaní ãfũjó Mị̃sị́rị̃ gâlé rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Kõtórõ agâlé ũꞌbí Ịsịrayị́lị̃ drị̂ unu kí Mụ́sã kí ụrụꞌbá gá Ãrọ́nị̃ be. ");
INSERT INTO luc_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ꞌBá Ịsịrayị́lị̃ drị̂ jọ kí ĩꞌbaní, “Ãdrĩ ándrá ũdrã agá Úpí drị́ gá Mị̃sị́rị̃ gâlé la ándrá múké. Ãma ándrá ĩzá na ĩyõ rú ĩꞌdi ca ãmaní rá ãzíla ãma ándrá ãkónã na agá ãmaní lẽlé rĩ áni, wó ĩmi ají ãma lú kõtórõ ꞌdĩ agá ꞌdõlé sĩ ãma ụꞌdị́jó pírí ãbị́rị́ sĩ.” ");
INSERT INTO luc_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ꞌDã ꞌbã ũngúkú gá, Úpí jọ vâ Mụ́sã nî, “Índre ma mụ ãkónã fẽlé angájó ꞌbụ̃ gâlé ĩminî, ụ́ꞌdụ́ ãlu-ãlu sĩ ꞌbá ꞌbã mụ kí ãkónã calépi ĩꞌbaní ụ́ꞌdụ́ ꞌdã sĩ rá rĩ atrálé. Ị́jọ́ ꞌdĩ sĩ ma kí ụ̃ꞌbị̃ kí nõ sĩ icó ãzị́táŋá mádrị̂ kí vú ũbĩlé rá yã jõku yụ yã rĩ. ");
INSERT INTO luc_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ụ́ꞌdụ́ ázíyá Sãbị́tị̃ ãlu-ãlu drị̂ sĩ, drĩ kí ãko ĩꞌbaní tralé rĩ kí idé ajílé jó agá, ꞌbã adru dó ĩyõ rú pâlé ị̃rị̃ sĩ, ꞌbã ndẽ jõ tralé ụ́ꞌdụ́ ãzí ꞌdã ꞌbadrị́ gá rĩ kí rá.” ");
INSERT INTO luc_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ị́jọ́ ꞌdĩ sĩ, Mụ́sã kí Ãrọ́nị̃ be jọ kí ꞌbá pírí Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ĩndró ꞌdĩ sĩ ĩmi dó nị̃ la rá ĩꞌdi Úpí ĩmi ajílépi angájó Mị̃sị́rị̃ gâlé rĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ãzíla ụ̃ꞌbụ́tị sĩ ĩmi dị̃zã Úpí drị̂ ndre, ãꞌdusĩku are ununuŋá ĩminí unujó ĩꞌdi ụrụꞌbá gá rĩ rá. Ãma dó ãꞌdi ꞌi ĩminí sĩ unujó ãma ụrụꞌbá gá?” ");
INSERT INTO luc_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mụ́sã jọ vâ, “Ĩmi nị̃ la ꞌdĩ Úpí ꞌi ĩꞌdiní ĩminí ĩzá fẽjó najó ĩndró sĩ ãzíla ãkónã ĩminí lẽlé rĩ fẽjó ụ̃ꞌbụ́tị sĩ rĩ sĩ, ãꞌdusĩku are ununuŋá ĩmidrị́ ĩꞌdi ụrụꞌbá gá rĩ rá. Wó ãma ãꞌdi kî? Adru ĩmi ꞌdĩ unu ãma ụrụꞌbá gá la ku, wó ĩmi ꞌdĩ unu Úpí ụrụꞌbá gá.” ");
INSERT INTO luc_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mụ́sã jọ Ãrọ́nị̃ ní, “Íjọ ꞌbá ũꞌbí Ịsịrayị́lị̃ drị̂ ꞌbaní pírí, ꞌbã amụ́ kí Úpí drị̃lẹ́ gá, ãꞌdusĩku are ununuŋá ĩꞌbadrị̂ rá.” ");
INSERT INTO luc_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ãrọ́nị̃ ꞌbã drĩ ị́jọ́ jọ agá ũꞌbí pírí Ịsịrayị́lị̃ drị̂ kí abe ꞌdĩ gá ꞌdâ, ndre kí ãngũ kõtórõ agâlé, ãzíla dị̃zã Úpí drị̂ iꞌda ru ụ̃rụ́ꞌbụ̃ agá. ");
INSERT INTO luc_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Úpí jọ Mụ́sã ní, ");
INSERT INTO luc_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Má are ununuŋá ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbadrị̂ ꞌbo. Íjọ ĩꞌbaní, ‘Ị̃tọ́lọŋá sĩ ĩmi ĩzá na, ãzíla ụ̃ꞌbụ́tị sĩ ĩmi aga ãkónã sĩ rá. Ĩmi dó sĩ nị̃ la ma Úpí Ãdróŋá ĩmidrị̂ ꞌi.’” ");
INSERT INTO luc_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ĩndró ꞌdã sĩ ãlíꞌboŋá amụ́ kí ãzíla uri kí ãngũ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã kí bụ́rụ́jọ́ kí drõjó rĩ gá pírí, ãzíla ụ̃ꞌbụ́tị sĩ andrẹlị́ká ka ãngũ drị̃ gá fumgbu. ");
INSERT INTO luc_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Andrẹlị́ká la mụ ụngụ́lé ꞌbo, ãko ãzí ꞌbe ãngũ drị̃ cí. ");
INSERT INTO luc_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ꞌBá Ịsịrayị́lị̃ drị̂ kí mụ ndrelé la ꞌbo, nị̃ kí ãkõ ãꞌdu yã rĩ gá ku iꞌdó kí ru ụzịlé cénĩ-cénĩ rú, “Ãko ꞌdĩ ãꞌdu?” Ị́jọ́ ꞌdĩ sĩ, Mụ́sã jọ ĩꞌbaní, “ꞌdĩ bã sĩ ãkónã Úpí ꞌbã fẽlé ĩminí nalé rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Úpí fẽ ãzị́táŋá, ‘Lẽ ꞌbá ãlu-ãlu ꞌbã tra ãkónã ĩꞌdiní lẽlé rĩ áni. Íꞌdụ ꞌbá ãlu-ãlu mídrị́ lị́cọ́ gá rĩ ꞌbaní ĩꞌdi bãkụ́lẹ̃ ị̃rị̃-ị̃rị̃ calépi ĩꞌbaní rá rĩ sĩ.’” ");
INSERT INTO luc_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ꞌBá Ịsịrayị́lị̃ drị̂ idé kí cécé lũlé ĩꞌbaní ꞌdã áni, ꞌbá ãzí rĩ tra kí ãkónã ĩyõ rú ãzí rĩ tra kí were rú. ");
INSERT INTO luc_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ꞌBá ꞌdĩ kí mụ ãkónã ĩꞌbaní tralé rĩ kí ụ̃ꞌbị̃lé ꞌbo, ꞌbá tralépi la ĩyõ rĩ ꞌbaní adru ambamba ku, ãzíla tralépi la were rĩ ꞌbadrị̂ adru kí dọ́dọ́ ku. ꞌBá pírí tra kí ãkónã calépi ĩꞌbaní lẽlé rĩ vú sĩ. ");
INSERT INTO luc_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mụ́sã jọ ĩꞌbaní, “ꞌBá ãzí ꞌbã mba jõ tã la cajó kpere ụ̃ꞌbụ́tị gá ku.” ");
INSERT INTO luc_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Wó ꞌbá ãzí rĩ are kí Mụ́sã ꞌbã tị ku mba kí tã la kpere ụ̃ꞌbụ́tị gá. Ĩꞌdi mụ calé ụ̃ꞌbụ́tị sĩ ãkónã ci kí dó ụ̃ꞌbụ rú iꞌdó kí dó ngụ̃lé ngụ̃ngụ̃. Ị́jọ́ ꞌdĩ sĩ, Mụ́sã uꞌá ĩꞌbaní ũmbã sĩ. ");
INSERT INTO luc_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ụ̃ꞌbụ́tị ãlu-ãlu sĩ ꞌbá ãlu-ãlu ri tralé la ĩꞌdiní lẽlé rĩ áni; ị̃tụ́ drĩ aká ãcí ru ꞌbo, tá acelépi rĩ kí aká rá. ");
INSERT INTO luc_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ụ́ꞌdụ́ ázíyá rĩ sĩ, tra kí ãkónã ĩyõ rú bãkụ́lẹ̃ sụ ꞌbá ãlu-ãlu sĩ pâlé ị̃rị̃. ꞌBá drị̃lẹ́ ru ũꞌbí ꞌbadrị̂ amụ́ kí pírí ãzíla lũ kí ị́jọ́ la Mụ́sã ní. ");
INSERT INTO luc_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mụ́sã jọ ĩꞌbaní, “Ị́jọ́ ꞌdĩ bãsĩ Úpí ꞌbã azịlé rĩ: Drụ̃sị̃ ĩꞌdi Sãbátũ ụ́ꞌdụ́ ãlá avị́jó Úpí ꞌbã ꞌbãlé ndú sĩ ĩꞌdi ị̃nzị̃jó rĩ ꞌi. Ĩmi uꞌbé ãko ĩminí lẽlé uꞌbélé rĩ kî, ãzíla ĩmi aꞌdí ãko ĩminí aꞌdílé rĩ kî. Ĩmba ị́mbị́ la kí tã ꞌbãlé bụ́lụ́ gá ụ́ꞌdụ́ drụ̃sị̃ rĩ nî.” ");
INSERT INTO luc_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mba kí tã la kpere ụ̃ꞌbụ́tị gá cécé Mụ́sã ꞌbã azịlé ĩꞌbaní rĩ áni, ãzíla ci ụ̃ꞌbụ rú ku jõku ngụ̃ ku. ");
INSERT INTO luc_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mụ́sã jọ, “Ĩna ãndrũ ĩꞌdi, ãꞌdusĩku ãndrũ ĩꞌdi Sãbátũ ụ́ꞌdụ́ ãlá avị́jó Úpí ꞌbã ꞌbãlé ndú sĩ ĩꞌdi ị̃nzị̃jó rĩ ꞌi ãzíla ĩmi icó ãkónã ịsụ́lé ãngũ drị̃ gá ãmvêlé ku. ");
INSERT INTO luc_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ụ́ꞌdụ́ ázíyá rĩ kí agá, ĩtra ãkónã ĩmidrị̂ kî, wó ụ́ꞌdụ́ ázị̂rị̃ rĩ la adru Sãbátũ, ãko ãzí ãkónã rú la ꞌbã adru ala gá ꞌdáyụ.” ");
INSERT INTO luc_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Wó ụ́ꞌdụ́ ãlu Sãbátũ drị́ ꞌdã sĩ, ꞌbá ãzí rĩ fũ kí tí mụlé ãkónã tralé, wó ịsụ́ kí ku. ");
INSERT INTO luc_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî ꞌbã jọ, “ꞌBá Ịsịrayị́lị̃ drị́ ꞌdĩ ĩmi ãzị́táŋá mádrị̂ kí gã tã mbalé úmgbé ụ́ꞌdụ́ íngõpí yã? ");
INSERT INTO luc_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ĩndre drĩ ma Úpí ꞌi, áfẽ ĩminí Sãbátũ sĩ avị́jó ụ́ꞌdụ́ ázíyá sãbị́tị̃ ãlu-ãlu drị̂ sĩ, ĩmi ãkónã tra ụ́ꞌdụ́ ị̃rị̃ ãni. ꞌBá pírí ꞌba uꞌá kí ãngũ ãlu gá ụ́ꞌdụ́ sãbátũ drị̂ sĩ; ꞌbá ãzí ꞌbã fũ ãmvé ku.” ");
INSERT INTO luc_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ị́jọ́ ꞌdĩ sĩ, ꞌbá avị́ kí dó ụ́ꞌdụ́ ázị̂rị̃ rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ꞌBá Ịsịrayị́lị̃ drị̂ umve kí ãkónã ꞌbã rụ́ mãnã. Iꞌdá ándrá cécé ũri ãzí ífí imve la áni ãzíla ãjị́ la ándrá cécé mũkátĩ idélé ãnụ́ sĩ rĩ drị̂ áni. ");
INSERT INTO luc_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mụ́sã jọ ĩꞌbaní, “Ãzị́táŋá Úpí ꞌbã fẽlé rĩ íni: Ĩꞌdụ mãnã bãkụ́lẹ̃ ãlu ãzíla ĩmba tã la anzị ĩmidrị́ drị̃lẹ́ gâlé rĩ ꞌbanî, kí dó sĩ ãkónã ándrá mání fẽlé ĩminí nalé kõtórõ agá ꞌdãá mání ĩmi anzéjó Mị̃sị́rị̃ gâlé rĩ ndre.” ");
INSERT INTO luc_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ị́jọ́ ꞌdĩ sĩ, Mụ́sã jọ Ãrọ́nị̃ ní, “Íꞌdụ úmvú lụ́rụ́lụ̃rụ̃ rú la íꞌbã mãnã bãkụ́lẹ̃ ãlu ala gá. Íꞌbã ĩꞌdi Úpí drị̃lẹ́ gá tã la mbajó anzị ĩmidrị́ drị̃lẹ́ gâlé rĩ ꞌbanî.” ");
INSERT INTO luc_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ãrọ́nị̃ are ị́jọ́ Úpí ꞌbã azịlé Mụ́sã ní ꞌdã rá, idé cécé lũlé ĩꞌdiní mãnã ị́jọ́ vú nzejó rĩ ꞌbãjó sĩ tã la mbajó rá. ");
INSERT INTO luc_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ꞌBá Ịsịrayị́lị̃ drị̂ na kí dó mãnã ílí kãlị́ sụ, kpere ĩꞌbaní acá agá ãngũ ĩꞌbã kí sĩ ri jó rĩ gá; na kí dó mãnã kpere ĩꞌbaní ca agá lõkókõrí Kãnánĩ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ãko ãꞌí rĩ ꞌbã ụ̃ꞌbị̃ŋá ífã rĩ ají kí ru lítã kãlị́ ị̃rị̃ rĩ be.) ");
INSERT INTO luc_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ꞌBá ũꞌbí Ịsịrayị́lị̃ drị̂ ko kí dó drị̃ pírí mụlé kõtórõ umvelé Sínĩ gâlé wãyá co trũ Úpí ꞌbã ãzị́táŋá la fẽjó rĩ áni. Mụ kí dó rilé Rị̃fị̃dị́mụ̃ gá, wó ị̃yị́ ꞌbá ꞌbaní icólé mvụlé la ꞌdá yụ. ");
INSERT INTO luc_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ị́jọ́ ꞌdĩ sĩ ꞌbá iꞌdó kí dó ãwãlé Mụ́sã ụrụꞌbá gá ãzíla jọ kí, “Ífẽ ãmaní ị̃yị́ mvụlé.” Mụ́sã umvi ĩꞌbaní, “Ĩmi ãwã má be ãꞌdu ị́jọ́ sĩ yã? Ĩmi Úpí ụ̃ꞌbị̃ ãꞌdu ị́jọ́ sĩ yã?” ");
INSERT INTO luc_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Wó ị̃yị́ vị́ ndẽ dó ꞌbá kí rá, iꞌdó kí dó ị́jọ́ jọlé Mụ́sã ụrụꞌbá gá. Jọ kí ĩꞌdiní, “Mí ají ãma angájó Mị̃sị́rị̃ gâlé ãmaní sĩ drị̃ cịjó ãmã anzị abe ãzíla ãnãkpá kí trũ ị̃yị́ ãkõ sĩ sĩ ũdrãjó ãꞌdu ị́jọ́ sĩ yã?” ");
INSERT INTO luc_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ꞌDã ꞌbã ũngúkú gá, Mụ́sã ꞌbã dó mãmálá Úpí drị̃lẹ́ gá, “Ma dó rá la ꞌbá ꞌdĩ ꞌbaní ãꞌdu idé? Kí bábá lẽjó áma uꞌbéjó írã sĩ sĩ áma ꞌdịjó.” ");
INSERT INTO luc_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Úpí umvi Mụ́sã ní, “Ímụ ꞌbá kí drị̃lẹ́ gâlé. Íꞌdụ ꞌbá ĩyõ Ịsịrayị́lị̃ drị̂ kí ꞌbã ãzí kí ãzíla íꞌdụ vâ ími drị́ gá túré ándrá míní sĩ mĩrĩ umvelé Náyĩlĩ ꞌi rĩ ꞌa gbãjó rĩ ꞌi ãzíla ímụ dô. ");
INSERT INTO luc_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ma mụ pá tulé ími drị̃lẹ́ gá ꞌBé Hõrébũ gá ꞌdãá. Ígbã írã ꞌi, ị̃yị́ la dó sĩ ãfũ alagâlé ꞌbá ꞌbaní mvụlé.” Ị́jọ́ ꞌdĩ sĩ Mụ́sã idé dó ị́jọ́ ꞌdĩ ꞌdĩ ꞌbã áni ꞌbá ĩyõ Ịsịrayị́lị̃ drị̂ kí drị̃ gâsĩ. ");
INSERT INTO luc_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ꞌDa dó sĩ ãngũ ꞌdã ꞌbã rụ́ Másã ꞌi ãzíla Mẹ̃rị́bã ꞌi, ãꞌdusĩku ꞌbá Ịsịrayị́lị̃ rú rĩ ꞌbã kí ãwãjó ãzíla Úpí ụ̃ꞌbị̃jó rĩ sĩ, “Úpí ãma agá ꞌdâ cí yã jõku ꞌdáyụ?” ");
INSERT INTO luc_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ꞌBá Ãmãlẹ́kị̃ drị̂ amụ́ kí ãꞌdị́ ꞌdịlé ꞌbá Ịsịrayị́lị̃ drị̂ kí abe Rị̃fị̃dị́mụ̃ gá. ");
INSERT INTO luc_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mụ́sã jọ Yósũwã nî, “Mí ũpẽ ãgọbị ãzí kí ãgọbị ãmadrị̂ kí agá ꞌdâ mụjó ãꞌdị́ ꞌdịjó ꞌbá Ãmãlẹ́kị̃ drị̂ abe, drụ̃sị̃ ma mụ pá tulé ꞌbé drị̃ gá túré Ãdróŋá drị̂ trũ áma drị́ gá.” ");
INSERT INTO luc_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ị́jọ́ ꞌdĩ sĩ Yósũwã ꞌdị dó ãꞌdị́ ꞌbá Ãmãlẹ́kị̃ drị̂ kí abe Mụ́sã ꞌbã jọlé ĩꞌdiní rĩ áni, Mụ́sã ꞌi, Ãrọ́nị̃ ꞌi ãzíla Hụ́rị̃ ꞌi tụ kí ụrụgá ꞌbé sị́ gâlé. ");
INSERT INTO luc_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mụ́sã drĩ drị́ inga ụrụgá, ꞌbá Ịsịrayị́lị̃ drị̂ kí ãꞌdị́ ndẽ nĩ, wó drị́ la drĩ ũrõ asị́jó vụ̃rụ́, ꞌbá Ãmãlẹ́kị̃ drị̂ kí ãꞌdị́ ndẽ nĩ. ");
INSERT INTO luc_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mụ́sã ꞌbã drị́ la dó mụ ũrõlé ꞌbo, Ãrọ́nị̃ kí Hụ́rị̃ be aꞌdụ́ kí írã ꞌbãlé Mụ́sã ní sĩ rijó drị̃ la gá. Ãrọ́nị̃ kí Hụ́rị̃ be tu kí pá, inga kí drị́ la kí ụrụgá, ꞌbá ãlu rĩ wókõ ãlu rĩ gá, ãzí rĩ wókõ ãzí rĩ gá. Ị́jọ́ ꞌdĩ sĩ Mụ́sã ꞌbã drị́ ace kí dó ũkpó ru ụrụgâsĩ kpere ị̃tụ́ ꞌbã ꞌde agá. ");
INSERT INTO luc_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ị́jọ́ ꞌdĩ sĩ Yósũwã ụꞌdị́ dó ꞌbá Ãmãlẹ́kị̃ drị̂ kí ménéŋá sĩ. ");
INSERT INTO luc_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ní, “Ísĩ ị́jọ́ ꞌdĩ kí bụ́kụ̃ gá sĩ ị́jọ́ ũrãjó drị̃ la gá. Lẽ ífẽ Yósũwã ꞌbã are ĩꞌdi ꞌbã bị́lẹ́ sĩ cé, ãꞌdusĩku ma mụ ꞌbá Ãmãlẹ́kị̃ drị́ ꞌdĩ kí ụꞌdị́lé ụ̃nọ́kụ́ drị̃ gá ꞌdâ pírí rá.” ");
INSERT INTO luc_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mụ́sã sị dó ãlĩtárĩ sĩ ídétáŋá idéjó rĩ, ꞌda dó sĩ rụ́ la “Úpí fẽ mání ãꞌdị́ ndẽlé rá ꞌi.” ");
INSERT INTO luc_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Mụ́sã jọ, “Ị́jọ́ ꞌdĩ sĩ drị́ sulé ụrụgâlé rĩ la ca kpere úmvúke Úpí drị̂ rụ́. Úpí la mụ ãꞌdị́ ꞌdịlé ꞌbá Ãmãlẹ́kị̃ drị̂ kí abe jãꞌdâ!” ");
INSERT INTO luc_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ụ́ꞌdụ́ ãlu Mụ́sã ꞌbã ándrị́pị Yétẽrõ átáló ru Mị̃dị́yánị̃ gá rĩ are ị́jọ́ pírí Ãdróŋá ꞌbã idélé Mụ́sã ní ꞌbá Ịsịrayị́lị̃ drị̂ kí abe rĩ kí, ãzíla Úpí ꞌbã ꞌbá kí anzéjó Mị̃sị́rị̃ gâlé ãmvé rĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mụ́sã ꞌbã ándrị́pị Yétẽrõ amụ́ ĩꞌdi rụ́ ꞌdõlé, ají ũkû Zĩpórã ándrá Mụ́sã ꞌbã tị pẽlé vúlé ĩꞌdi rụ̂lé rĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ãzíla ĩꞌdi ꞌbã anzị ị̃rị̃ rĩ kí ĩndĩ. Ngọ́pị̃ ãlu rĩ rụ́ la Gị́rị́sị̃mụ̃ ꞌi ãzí rĩ rụ́ la Ị̃lị̃yãzárị̃ ꞌi Mụ́sã jọ, “Ári uꞌálé ꞌbá ãzí ꞌbã ãngũ gá ãmị́yọ́ŋá ru,” ꞌda dó sĩ ngọ́pị̃ rụ́ Gị́rị́sị̃mụ̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Jọ vâ, “Ãdróŋá má átẹ́pị drị̂ ko áma ãzã ãzíla apá ma úpí Mị̃sị́rị̃ drị̂ ꞌbã lẽjó áma ꞌdịjó rĩ sĩ,” ị́jọ́ ꞌdĩ sĩ ꞌda dó ngọ́pị̃ rụ́ Ị̃lị̃yãzárị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yétẽrõ amụ́ kí ị̃zẹ́pị̃ Mụ́sã ꞌbã ũkû trũ ãzíla anzịŋá kí abe kõtórõ agá ꞌbé Ãdróŋá drị́ Mụ́sã ꞌbã kí rijó rĩ ꞌbã pá gá. ");
INSERT INTO luc_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Pẽ dó ụ́ꞌdụ́kọ́ tị Mụ́sã ní lũjó la kí amụ́ gẹ̃rị̃ gá ꞌdĩ, ");
INSERT INTO luc_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ị́jọ́ ꞌdĩ sĩ Mụ́sã mụ kí aꞌị́lé, kí mụ drị̃ ụfụlé ꞌbo, Mụ́sã ãvụ̃ vụ̃rụ́, ãzíla inga dó ru ĩꞌdi amvulé jụ́jụ́ sĩ. Zị kí ru vị́ sĩ, ãzíla mụ kí filé Hémã agâlé. ");
INSERT INTO luc_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mụ́sã nze Yétẽrõ ní ị́jọ́ Úpí ꞌbã idélé úpí Mị̃sị́rị̃ drị̂ rụ́ ãzíla ꞌbá Mị̃sị́rị̃ drị̂ kí ụrụꞌbá gá, ĩꞌdi ꞌbã sĩ ꞌbá Ịsịrayị́lị̃ drị̂ kí pajó rĩ kí pírí. Nze vâ ĩꞌdiní ị́jọ́ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã kí cãndí ịsụ́jó gẹ̃rị̃ gá ãzíla Úpí ꞌbã kí pajó rĩ. ");
INSERT INTO luc_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yétẽrõ la mụ ị́jọ́ Úpí ꞌbã idélé múké sĩ ꞌbá Ịsịrayị́lị̃ drị̂ kí pajó ꞌbá Mị̃sị́rị̃ drị̂ kí drị́ gá rĩ arelé ꞌbo, ãyĩkõ fụ ĩꞌdi rá, ");
INSERT INTO luc_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yétẽrõ jọ, “Ícụ́ Úpí ꞌi, ĩꞌdi ꞌbã ĩmi apájó angájó úpí Mị̃sị́rị̃ drị́ ãzíla ꞌbá Mị̃sị́rị̃ drị̂ kí drị́ gá rĩ sĩ! Ícụ́ Úpí ꞌi, ĩꞌdi ꞌbã ꞌbá ĩꞌdidrị̂ kí apájó ĩꞌbaní adrujó ãtíꞌbó ru rĩ gá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ánị̃ dó úꞌdîꞌda Úpí ndẽ ãmbõgõ sĩ ãdroŋa ãzí ꞌbá ꞌbã kí ị̃nzị̃lé ãzí rĩ kí pírí rá, ãꞌdusĩku idé ị́jọ́ ꞌdĩ kí ꞌbá Mị̃sị́rị̃ rú ꞌdĩ ꞌba rụ́ ꞌdĩ sĩ kí ꞌbá Ịsịrayị́lị̃ drị̂ kí uꞌé agá ũnzí.” ");
INSERT INTO luc_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Yétẽrõ Mụ́sã ꞌbã ándrị́pị ají dó ãko fẽlé ídétáŋá ivélé ivê rĩ rú rĩ kí, ãko ãwãꞌdĩfô rú fẽlé Ãdróŋá ní rĩ kí abe; ãzíla Ãrọ́nị̃ amụ́ kí ꞌbá ĩyõ Ịsịrayị́lị̃ drị̂ kí abe pírí ãkónã idélé ndú ãrútáŋá ru ꞌdĩ nalé Ãdróŋâ drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Drụ̃sị̃ íni Mụ́sã ri úmvúke ĩꞌdidrị̂ drị̃ gá sĩ ꞌbá kí ị́jọ́ lịlẹ́. ꞌBá fẽ kí ĩꞌdiní sáwã sĩ avị́jó ku iꞌdójó ụ̃ꞌbụ́tị sĩ kpere ĩndró sĩ. ");
INSERT INTO luc_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Yétẽrõ lã mụ ị́jọ́ Mụ́sã ꞌbã idélé ꞌdĩ kí ndrelé pírí ꞌbo, zị Mụ́sã ꞌi, “Ị́jọ́ míní idélé sĩ ꞌbá pírí kí ꞌbã ị́jọ́ lịjó mi ꞌi ꞌdĩ ãꞌdu? Mi kí nga pírí mi ꞌi la ãꞌdu sĩ, ꞌbá pírí ꞌbaní sĩ pá tujó ími andre gá iꞌdójó ụ̃ꞌbụ́tị sĩ kpere ĩndró sĩ?” ");
INSERT INTO luc_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mụ́sã umvi Yétẽrõ ní, “Ãꞌdusĩku ꞌbá kí amụ́ má rụ́ ị́jọ́ Ãdróŋá ꞌbã lẽlé rĩ nị̃lé. ");
INSERT INTO luc_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ꞌBá drị̃ kí ị́jọ́ ịsụ́ kí drĩdríŋĩ gá, ála ají la mádrị́, ãzíla ma dó sĩ ị́jọ́ ĩꞌbadrị̂ awa ãꞌdi pịrị la nĩ jõku ãꞌdi pịrị ku la nĩ ãzíla ma ĩꞌbaní ãzị́táŋá Ãdróŋá drị̂ kí lũ rá.” ");
INSERT INTO luc_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Yétẽrõ jọ dó Mụ́sã ní, “Ị́jọ́ míní idélé ꞌdĩ adru múké ku. ");
INSERT INTO luc_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Mi mụ ãndẽlé ꞌbá amụ́lépi mí rụ́ ꞌdĩ kí abe rá. Ãzị́ ꞌdĩ míní ngalé áꞌdụ̂sĩ rĩ gá ambamba. ");
INSERT INTO luc_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Mí are drị̃ ị́jọ́ áma tị gá rĩ, ãzíla Ãdróŋá la ími ãzã ko rá. Ĩꞌdi múké la míní pá tujó ꞌbá kí kẹ̃jị́ gá Ãdróŋâ drị̃lẹ́ gá ãzíla ị́jọ́ ĩꞌbã kí ãwãjó rĩ kí lũjó ĩꞌdinî. ");
INSERT INTO luc_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Mí imbá kí ãzị́táŋá Ãdróŋá drị̂ kí sĩ ãzíla gbíyã múké rĩ kí sĩ ꞌbã nị̃ kí rû sĩ kí ãꞌdu idé yã rĩ gá cé. ");
INSERT INTO luc_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ũꞌbãjó la ꞌdĩ drị̃ gá, lẽ mí ũpẽ ꞌbá icólépi rá rĩ kí, lẽ ꞌba adru kí ꞌbá idélépi ụ̃rị̃ sĩ Ãdróŋá sĩ rĩ kî, icójó ásị́ tịjó kí drị̃ gá rá ãzíla ꞌbá séndẽ sĩ ꞌba mịfị́ sajó rĩ ngụ̃lépi ũnzí rĩ kî. Íꞌbã kí ãmbogo rú ị́jọ́ lịlẹ́ ꞌbá álĩfũ drị̂ kí, ꞌbá túrú drị̂ kí, ꞌbá kãlị́ tõwú drị̂ kí, ãzíla ꞌbá mụdrị́ drị̂ kí drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ífẽ ꞌbã nga kí ãzị́ ꞌbá kí ị́jọ́ lịjó ụ́ꞌdụ́ pírí. ꞌBã lị kí ị́jọ́ were rĩ kí, ị́jọ́ ãnzị rĩ kí ꞌba ají kí kí mídrị́. Ãzị́ la sĩ adru míní ĩpé ru drĩ kí ãzị́ ꞌbã ãnzị ale mí be rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ídrĩ idé la ꞌdĩ áni, ãzị́táŋá Ãdróŋá ꞌbã fẽlé mídrị́ rĩ sĩ mí icó ãndẽlé ãzị́ sĩ ku, ꞌbá ꞌdĩ kí pírí mụ lị́cọ́ gâlé ásị́ ị̃gbẹ̃ sĩ ãzíla kí ịsụ́ la ị́jọ́ ĩꞌbadrị̂ kí úde kí rá.” ");
INSERT INTO luc_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mụ́sã are ị́jọ́ Yétẽrõ ꞌbã jọlé ĩꞌdiní rĩ kí rá ãzíla idé ị́jọ́ pírí ĩꞌdi ꞌbã jọlé rĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mụ́sã ũpẽ ꞌbá icólépi rá rĩ kí ꞌbá Ịsịrayị́lị̃ drị̂ kí drĩdríŋĩ gá. Ũpẽ ꞌbá ãmbogo rú ị́jọ́ lịlẹ́pi ꞌbá álĩfũ, ꞌbá túrú, ꞌbá kãlị́ tõwú, ãzíla ꞌbá mụdrị́ kí drị̃lẹ́ gá rĩ kî. ");
INSERT INTO luc_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Nga kí ãzị́ ꞌbá kí ị́jọ́ lịjó rĩ ãsị̃ŋá kóru, kí ị́jọ́ ãnzị rĩ kí ájí Mụ́sã drị́, kí ĩpé rĩ kí ị́jọ́ de lịlẹ́ nĩ. ");
INSERT INTO luc_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Mụ́sã azị dó ándrị́pị̃ Yétẽrõ be, ꞌbã dó pá la ãzíla mụ dó sĩ ĩꞌdidrị́ sụ́rụ́ gâlé. ");
INSERT INTO luc_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ꞌBá Ịsịrayị́lị̃ drị̂ ꞌbã kí ãfũjó Mị̃sị́rị̃ gâlé ꞌbo rĩ sĩ, acị́ kí ĩmbá ị̃rị̃ ãzíla ĩmbá na rĩ ꞌbã ụ́ꞌdụ́ ãlu rĩ sĩ ãzíla acá kí dó ꞌbé Sĩnáyĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ꞌDĩ ĩꞌbã kí ãngũ Rị̃fị̃dị́mụ̃ drị̂ aꞌbejó ꞌbo rĩ gá, fi kí dó ãngũ kõtórõ rú Sĩnáyĩ drị̂ agá, ꞌbá Ịsịrayị́lị̃ drị̂ ri kí dó ꞌdãá ãngũ kõtórõ rú ꞌbé Sĩnáyĩ drị̂ ꞌbã mẹ́lẹ́tị gâlé ru. ");
INSERT INTO luc_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ꞌDã ꞌbã ũngúkú gá, Mụ́sã mụ dó Ãdróŋá rụ́ ꞌbé sị́ gâlé, ãzíla Úpí umve dó ĩꞌdi ꞌbé agâlé ãzíla jọ ĩꞌdiní, “ꞌDĩ ị́jọ́ míní mụlé jọlé ꞌbá Yãkóꞌbõ drị́ lị́cọ́ gá ãzíla ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní rĩ: ");
INSERT INTO luc_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Ĩmĩ ãmgbã rĩ ndre kí ị́jọ́ mání idélé ꞌbá Mị̃sị́rị̃ gá rĩ ꞌba rụ́ ꞌdĩ kí ĩmi mịfị́ sĩ cé, ãzíla mání ĩmi ụꞌdụjó ụ́pụ́pị́ sĩ cécé yụ́kụ́ ꞌbã mvaka kí ụꞌdụjó rĩ áni sĩ ĩmi ajíjó má rụ́ ꞌdõlé. ");
INSERT INTO luc_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ị́jọ́ ꞌdĩ sĩ ĩdrĩ áma ru ásị́ pírí sĩ ãzíla tị icíma mádrị́ ĩmi abe rĩ tãmba rá, sụ́rụ́ pírí ụ̃nọ́kụ́ drị̃ gá ꞌdĩ kí agá ꞌdâ ĩmi adru ꞌbá mání áma ásị́ ꞌbãjó rĩ kî. Ụ̃nọ́kụ̂ táni adru agá má ãni tí, ");
INSERT INTO luc_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ĩmi ãtalo Úpí drị̂ kî ãzíla sụ́rụ́ ãlá rĩ kî.’ ꞌDĩ kí ị́jọ́ míní mụlé jọlé anzị Ịsịrayị́lị̃ drị̂ ꞌbaní ri kî.” ");
INSERT INTO luc_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ꞌDã ꞌbã vúlé gá Mụ́sã mụ dó ꞌbá ĩyõ Ịsịrayị́lị̃ drị̂ kí tralé sĩ amụ́jó ị́jọ́ tá Úpí ꞌbã jọlé ĩꞌdiní rĩ kí vú nzejó kí drị̃lẹ́ gá ĩꞌdĩ ꞌbã ãzị́táŋá la fẽjó ĩꞌdiní ꞌbã jọ rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ꞌBá pírí ãꞌị̃ kí dó tị ãlu sĩ, “Ãma ị́jọ́ pírí Úpí ꞌbã jọlé rĩ kí idé rá.” ꞌDã ꞌbã vúlé gá Mụ́sã agụ dó umvitáŋá la vúlé Úpí rụ̂lé. ");
INSERT INTO luc_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Úpí jọ Mụ́sã ní, “Ma mụ amụ́lé mí rụ́ ꞌdõlé ụ̃rụ́ꞌbụ̃ ãnzị la agâ sĩ, ꞌbá kí dó ãma are ị́jọ́ jọ agá mí be kí dó sĩ ásị́ ꞌbã ími drị̃ gá jãꞌdâ.” ꞌDã ꞌbã ũngúkú gá, Mụ́sã iꞌda dó ị́jọ́ tá ꞌbá ꞌbã kí jọlé rĩ kí Úpí nî. ");
INSERT INTO luc_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Úpí jọ Mụ́sã ní, “Ímụ ꞌbá ꞌba rụ̂lé mí itú kí adrujó ãlá ru ãndrũ cajó kpere drụ̃sị̃. ꞌBã ũjĩ kí ĩꞌbã bõngó kí ãlá ru, ");
INSERT INTO luc_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ãzíla ụ́ꞌdụ́ na la sĩ ꞌbã adru kí bábá ãꞌdusĩku ụ́ꞌdụ́ ꞌdã sĩ Úpí la asị́ vụ̃rụ́ ꞌbá ꞌba rụ́ ꞌdõlé ꞌbé Sĩnáyĩ drị̃ gá ꞌdãá ꞌbá pírí kí dị̃ ĩꞌdi ndre sĩ. ");
INSERT INTO luc_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Íꞌbã lõkókõrí ꞌbé pá gâsĩ trộkị́lịrị ãzíla ílũ ꞌbá ꞌbaní, ꞌbã mba kí ru tã ꞌbã alị kí jõ lõkókõrí ꞌdĩ drị̃ gâsĩ sĩ tụjó ꞌbé sị́ gâlé ku ãzíla ꞌbã ca kí jõ ꞌbé pá gâlé ku. ꞌBá ꞌbé ụrụꞌbá alólépi rĩ lẽ úꞌdị ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Lẽ úꞌbé ĩꞌdi írã sĩ jõku úcã ĩꞌdi ꞌé sĩ, ꞌbá ãzí ꞌbã aló ụrụꞌbá la drị́ sĩ ku drĩ táni adru ꞌbá jõku ãnãkpá, âꞌị̃ ĩꞌdiní adrulé ídri ku. Údrĩ dó gũká vu sáwã ãzo rú ꞌbo, ꞌbá kí dó tụ ꞌbé sị́ gâlé ĩndõ.” ");
INSERT INTO luc_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mụ́sã la mụ asị́lé ꞌbé sị́ gâlé rĩ sĩ ꞌbá ꞌba rú ꞌdõlé ꞌbo, itú dó ꞌbá kí sĩ kí ꞌbãjó ãlá ru ãzíla ũjĩ kí dó ĩꞌbã bõngó kî. ");
INSERT INTO luc_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ꞌDã ꞌbã vúlé gá Mụ́sã jọ dó ꞌbá ꞌbanî, “Ĩmi itú ĩmi ụ́ꞌdụ́ na la sĩ bábá. Ĩmi icí ĩmi ũkû ĩmidrị̂ kí abe ku.” ");
INSERT INTO luc_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ụ̃ꞌbụ́tị ụ́ꞌdụ́ na rĩ drị́ gá rĩ sĩ ãvi ꞌbã ụ̃kpẹ̃ŋá ãzíla ũnĩŋá iꞌdó dó nĩ, ụ̃rụ́ꞌbụ̃ ãnzị la aku dó ꞌbé ꞌbã drĩ cí, ãzíla ụ́ꞌdụ́kọ́ gũká ãni kụlépi re la akụ́ dó nĩ. ꞌBá pírí bụ́rụ́jọ́ gá rĩ iꞌdó kí dó yãlé yã-yã. ");
INSERT INTO luc_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ꞌDã ꞌbã ũngúkú gá, Mụ́sã ꞌde dó ꞌbá kí drị̃ trũ fũjó bụ́rụ́jọ́ kí agá ꞌdãá trũ mụjó Ãdróŋá rụ̂lé, utu kí dó pá ꞌbé pá gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ãcíkã ĩmũlũ dó ꞌbé Sĩnáyĩ pírí, ãꞌdusĩku Úpí asị́ dó rilé ꞌbé drị̃ gá ꞌdãá ãcí agâ sĩ. Ãcíkã la tụ dó ꞌbụ̃ gâlé cécé ãcíkã úká drị̂ áni, ꞌbê iꞌdó ru ayalé ũkpó sĩ, ");
INSERT INTO luc_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","gũká ꞌbã ụ́ꞌdụ́kọ́ iꞌdó dó ꞌụlé rere ũkpó sĩ drị̃ gá drị̃ gá. ꞌDã ꞌbã vúlé gá Mụ́sã la dó ị́jọ́ jọ, Ãdróŋá dó umvi la ĩꞌdiní ụ́ꞌdụ́kọ́ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Úpí asị́ dó ꞌbé Sĩnáyĩ ꞌbã drị̃ gá umve dó Mụ́sã ĩꞌdi rụ́ ꞌbé ꞌbã drị̃kã gâlé. Ị́jọ́ ꞌdĩ sĩ Mụ́sã tụ dó rá, ");
INSERT INTO luc_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Úpí jọ dó Mụ́sã nî, “Ísị vụ̃rụ́ ꞌbá ꞌba rụ̂lé mí itré kí ꞌbã alị kí jõ lõkókõrí ũkpõ sĩ amụ́jó Úpí ndrejó ku, ꞌbá ũꞌbí kí mụ ũdrãlé ku. ");
INSERT INTO luc_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Táni ãtalo amụ́lépi ãni rú Úpí rụ́ rĩ kî, ꞌbã itú kí ru ꞌbãjó ãlá ru cénĩ, jõ íni ku ma drị̃rịma fẽ ĩꞌbaní rá.” ");
INSERT INTO luc_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mụ́sã jọ Úpí ní, “ꞌBá icó kí tụlé mí rụ́ ꞌbé Sĩnáyĩ drị̃ gâlé ku ãꞌdusĩku ími ãmgbã rĩ itré ãma ꞌbo, ‘Lõkókõrí míní ꞌbãlé trộkị́lịrị sĩ ꞌbê ꞌbãjó ãlá ru rĩ sĩ.’” ");
INSERT INTO luc_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Úpí umvi, “Ísị vụ̃rụ̂lé mí ají Ãrọ́nị̃ ụrụgá ꞌdõlé ĩndĩ. Wó ãtalo kí ꞌbá ãzí ꞌdĩ kí abe ꞌbã amụ́ kí Úpí rụ́ ụrụgá ꞌdõlé ku, drị̃ kí amụ́ rá kí ũdrã rá.” ");
INSERT INTO luc_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ꞌDã ꞌbã vúlé gá Mụ́sã sị dó ꞌbá ꞌba rụ̂lé ãzíla nze ị́jọ́ ꞌdĩ kí vú ĩꞌbaní. ");
INSERT INTO luc_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ãdróŋá jọ ị́jọ́ ꞌdĩ kî: ");
INSERT INTO luc_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ma Úpí Ãdróŋá mídrị́ ími anzélépi Mị̃sị́rị̃ gâlé, míní ándrá adrujó ãtíꞌbó ru rĩ sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Lẽ mí ị̃nzị̃ ãdróŋá ãzí ku wó lú Ma ꞌi áꞌdụ̂sĩ. ");
INSERT INTO luc_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Lẽ mí idé míní íꞌdá ãko ãzí ãni ꞌbụ̃ gá jõku ụ̃nọ́kụ́ drị̃ gá jõku ị̃yị́ ụ̃nọ́kụ́ ị̃ndụ́ gá la ãni ku. ");
INSERT INTO luc_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Lẽ ítị̃ ími ãja vụ̃rụ́ ãdroŋa ĩnzõ rú ꞌdĩ ꞌbaní jõku mí ị̃nzị̃ kí ku, ãꞌdusĩku ma Úpí Ãdróŋá mídrị̂ ꞌi ma Úpí ãjã rú rĩ ꞌi. Ma drị̃rịma fẽ ꞌbá áma ngụ̃lépi ũnzí rĩ ꞌbaní anzị ĩꞌbadrị̂ abe cajó kpere áꞌbị́ anzị na ãzíla sụ rĩ ꞌba rụ́. ");
INSERT INTO luc_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Wó ma lẽtáŋá mádrị̂ iꞌda ꞌbá áma lẽlépi ãzíla ãzị́táŋá mádrị̂ tãmbalépi rĩ ꞌbã anzị mụlé tịlé drị̃lẹ́ gâlé álĩfũ álĩfũ rĩ ꞌbaní. ");
INSERT INTO luc_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Mí ayú Úpí mídrị̂ ꞌbã rụ́ ị́jọ́ ũnzí gá ku, ãꞌdusĩku ma Úpí Ãdróŋá mídrị̂ ꞌi, ma drị̃rịma fẽ ꞌbá áma rụ́ ayúlépi yã ꞌdâ rĩ ní rá. ");
INSERT INTO luc_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Mí ũrã ụ́ꞌdụ́ Sãbátũ drị̂ ãzíla ímba tã la ãlá ru. ");
INSERT INTO luc_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ínga ãzị́ mídrị̂ kí ụ́ꞌdụ́ ázíyá, ");
INSERT INTO luc_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Wó ụ́ꞌdụ́ ázị̂rị̃ rĩ ĩꞌdi Sãbátũ ụ́ꞌdụ́ sĩ avị́jó pẽlé ndú Úpí Ãdróŋá mídrị̂ ní rĩ. Ụ́ꞌdụ́ ꞌdã sĩ, táni mi ꞌi, anzị mídrị̂ kí, ãtíꞌbó mídrị̂ kî, ãnãpká mídrị̂ kî, táni ãmị́yọ́ŋá uꞌálépi mídrị́ sụ́rụ́ gá ꞌdâ rĩ kí abe pírí ãzị́ ngaŋá ꞌdá yụ. ");
INSERT INTO luc_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ụ́ꞌdụ́ ázíyá rĩ sĩ, Úpí ꞌbã ꞌbụ̃ kí ụ̃nọ́kụ́ be, ị̃yị́, ãzíla ãko pírí ala gá rĩ kí abe, wó ụ́ꞌdụ́ ázị̂rị̃ rĩ sĩ avị́ dô sĩ. Ị́jọ́ ꞌdĩ sĩ Úpí wi sụ̃sụ́ Sãbátũ drị̃ gá ãzíla ꞌbã ĩꞌdi ãlá ru. ");
INSERT INTO luc_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Íru mí átẹ́pị kí mí ãndrẽ be, ị́jọ́ ꞌdĩ sĩ mi dó sĩ uꞌá ílí ãzo rú ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã mụlé fẽlé míní rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Lẽ íꞌdị ꞌbá ku. ");
INSERT INTO luc_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Lẽ ínga ãwụ̃ ku. ");
INSERT INTO luc_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Lẽ mí ụ̃gụ̃ ãko ku. ");
INSERT INTO luc_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Lẽ mí alị́ ĩnzõ mî jĩránĩ rụ́ ku. ");
INSERT INTO luc_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Lẽ ími ũlẽ ꞌbã ãngã mî jĩránĩ ꞌbã jó sĩ ku. Lẽ ími ũlẽ ꞌbã ãngã ĩꞌdi ꞌbã ũkú sĩ ku, ãtíꞌbó ĩꞌdidrị́ ágọ́bị́ ru jõku ũkú ru rĩ sĩ ku, tị́ kí sĩ ku, kãyĩnõ kî sĩ ku, jõku ãko ãzí pírí ĩꞌdi ꞌbã trũ adrujó ꞌdĩ kî sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ꞌBá kí mụ ãvi ãzíla gũká ꞌbã ụ́ꞌdụ́kọ́ arelé, ꞌbé ꞌbã ãcíkã gbụ́gbụ́ ꞌdĩ ndrelé ꞌbo, yã kí ụ̃rị̃ sĩ yã-yã ãzíla tu kí sĩ pá rá-rá ru. ");
INSERT INTO luc_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Jọ kí Mụ́sã nî, “Íjọ ãmaní ị́jọ́ mi ꞌi, ãma are la rá, wó Ãdróŋá drĩ ị́jọ́ jọ ãmaní nĩ ãma ũdrã rá.” ");
INSERT INTO luc_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mụ́sã umvi ĩꞌbaní, “Ĩmi idé ụ̃rị̃ sĩ ku; Ãdróŋá amụ́ lú ĩmi ụ̃ꞌbị̃lé, ãzíla ĩmi sĩ ĩꞌdi ụ̃rị̃, ĩmi sĩ ásị́ ꞌbã sĩ tị la arejó, ị́jọ́ ꞌdĩ sĩ ĩmi idé rú dó sĩ ị́jọ́ ũnzí ku.” ");
INSERT INTO luc_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Wó ꞌbá ri kí pá tulé rá-rá ru, Mụ́sã mụ ãni rú ụ̃rụ́ꞌbụ̃ ãnzị Ãdróŋá ꞌbã adrujó ꞌdã gâlé nĩ áꞌdụ̂sĩ. ");
INSERT INTO luc_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî ꞌbã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ĩndre áma mgbãrĩ ꞌbã ị́jọ́ ájọ agá ĩminí angájó ꞌbụ̃ agâlé íngoní yã rĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ĩmi ũꞌbã ãdroŋa ãzí ĩminí idélé sílĩvã sĩ jõku gólũdĩ sĩ la kí ị̃nzị̃lé má be ku. ");
INSERT INTO luc_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ĩsị mání ãlĩtárĩ ũdrí sĩ, ãzíla ĩmi idé ídétáŋá ĩmidrị́ kãbĩlõ sĩ ãzíla tị́ sĩ ídétáŋá ivélé pírí ãzíla ídétáŋá ásị́ ị̃gbẹ̃ drị̂ kí drị̃ la gá. Ãngũ pírí mání pẽlé ndú áma ị̃nzị̃jó rĩ kí agá, ma amụ́, ma dó sĩ ĩminí sụ̃sụ́ wi. ");
INSERT INTO luc_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ĩdrĩ mání ãlĩtárĩ sị írã sĩ, ĩmi idé ĩꞌdi írã upalé upâ rĩ sĩ ku, ãꞌdusĩku írã upalé upâ rĩ adru múké ãzị́ mádrị̂ kí ngajó ku. ");
INSERT INTO luc_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ĩsị ãlĩtárĩ ãpị́kẹ trũ sĩ tụjó drị̃ la gâlé ku, ãꞌdusĩku ĩꞌdi ĩmi pílípílí iꞌda ĩminí tụ agá ụrụgâlé ãpị́kẹ gâsĩ ꞌdĩ gá ꞌdâ rá. ");
INSERT INTO luc_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ãzị́táŋá ꞌdĩ kí míní mụlé lũlé ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní rĩ kî: ");
INSERT INTO luc_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Ídrĩ ꞌbá mî sụ́rụ́ ru Ĩbũrãníyã rú la ĩgbã ãtíꞌbó ru, lẽ ꞌbã nga ãzị́ míní ílí ázíyá, ílí ázị̂rị̃ rĩ sĩ ítrũ ĩꞌdi rá ími ũfẽŋâ kóru. ");
INSERT INTO luc_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Drĩ ándrá amụ́ áꞌdụ̂sĩ lẽ ꞌbã mụ drị̃lẹ́ mgbọ sĩ áꞌdụ̂sĩ, wó drĩ ándrá adru ũkû trũ lẽ ꞌbã mụ kí ũkû be. ");
INSERT INTO luc_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ĩꞌdi ꞌbã ãmbógô drĩ ĩꞌdiní ũkú fẽ nĩ drĩ ãtíꞌbô ní anzị kí tị rá, ála ágọ́bị̂ trũ rá, wó ũkû kí anzị abe ace ãmbógó ĩꞌdidrị̂ ãni. ");
INSERT INTO luc_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Wó ãtíꞌbô drĩ jọ la, ‘Álẽ mâ ãmbógô ꞌi, mâ ũkû kí anzị abe rá ị́jọ́ ꞌdĩ sĩ álẽ áma trũlé ku.’ ");
INSERT INTO luc_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ꞌDã ꞌbã ũngúkú gá, ãmbógó ĩꞌdidrị̂ la dó ĩꞌdi agụ ãngũ Ãdróŋá ị̃nzị̃jó rĩ gá. Ála dó ĩꞌdi agụ kẹ̃jị́tị jó Ãdróŋá ị̃nzị̃jó rĩ drị̂ gá jõku ị́dị́ŋá kẹ̃jị́tị drị̂ gá, sĩ bị́lẹ́ la lũjó ũꞌbí kí drị̃lẹ́ gá. ꞌDã ꞌbã ũngúkú gá, ãtíꞌbô la dó ace ãmbógô ꞌbã pálé gá jãꞌdâ. ");
INSERT INTO luc_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ágọ́bị́ ãzí drĩ ĩꞌdi ꞌbã ị̃zẹ́pị̃ ị̃tụ̃ndã ãtíꞌbó ru, útrũ ĩꞌdi cécé ágọ́bị́ ãtíꞌbó ru rĩ drị̂ áni ku. ");
INSERT INTO luc_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ãmbógó ĩzóŋá ꞌdĩ ĩgbãlépi ãtíꞌbó ru rĩ drĩ ĩꞌdi lẽ ĩꞌdiní ũkú ru, wó ĩzóŋá ꞌdĩ drĩ ãyĩkõ fẽ ĩꞌdiní ku, ꞌbã ị̃tụ̃ndã ĩꞌdi átẹ́pị̃ ní vúlé. Lẽ ꞌbã ị̃tụ̃ndã ĩꞌdi drị̃ gá ꞌbá ãzí ãmị́yọ́ŋá ru la ní ku ãꞌdusĩku drĩ ĩꞌdi ị̃tụ̃ndã rá ífí la mba ị́jọ́ ĩꞌbaní itúlé rĩ tã ku. ");
INSERT INTO luc_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Wó ãmbógó ĩzóŋá ãtíꞌbó ru rĩ drị̂ drĩ kí ị́jọ́ itú ĩzóŋâ be sĩ ĩꞌdi ĩgbãjó ngọ́pị̃ nî, lẽ ꞌbã ꞌbã dó ĩꞌdi ãtíꞌbó ru ku be la rá la ĩꞌdi ꞌbã ị̃zẹ́pị rú. ");
INSERT INTO luc_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“Ágọ́bị́ ũkú ãtíꞌbó ru rĩ ĩgbãlépi rĩ drĩ ĩꞌdi ꞌbã ũkú ãzí aꞌdụ́, lẽ ꞌbã nde ĩꞌdi ãko ĩꞌdidrị́ ãkónã rú, bõngó ru, ãzíla adrujó ágọ́bị́ kí ũkú be rĩ kî sĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Drĩ ĩcẽ ị́jọ́ na ꞌdĩ kí idéŋá sĩ ĩꞌdiní rá, útrũ ũkú ꞌdĩ rá, ꞌbá ãzí ꞌbã ũfẽ séndẽ sĩ ĩꞌdi unzejó ku. ");
INSERT INTO luc_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“ꞌBá ꞌbá ãzí colépi ãzíla ĩꞌdi ꞌdịlépi káyĩ rĩ lẽ úꞌdị ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Wó drĩ adru drị̃lẹ́ ũnzĩ Ãdróŋá ꞌbã ajílé sĩ ĩꞌdi fẽjó drãjó ĩꞌdidrị́ gá nĩ la yã áni, ma ãngũ ĩꞌdiní sĩ apájó ru zị̃jó rĩ iꞌda rá. ");
INSERT INTO luc_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Wó ꞌbá ãzí drĩ ꞌbá ꞌdị círí ru, drĩ sĩ apá ru zị̃lé ãlĩtárĩ mádrị̂ gá, lẽ ásé ĩꞌdi dịlé rá. ");
INSERT INTO luc_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“ꞌBá átẹ́pị̃ kí colépi ãndrẽ be rĩ, lẽ úꞌdị ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“ꞌBá ꞌbá kí ụrụlépi ũkpõ sĩ sĩ kí ị̃tụ̃ndãjó jõku kí tãmbajó ĩꞌdiní ãtíꞌbó ru rĩ lẽ úꞌdị ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“ꞌBá átẹ́pị̃ kí uꞌdálépi ãndrẽ be rĩ, lẽ úꞌdị ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“ꞌBá ãzí drĩ kí ru co kí drĩdríŋĩ gá údrĩ dó sĩ ãzí rĩ dị írã sĩ jõku bụ́nị́yã sĩ wó drĩ drã ku ãzíla drĩ ru la vụ̃rụ́ mgbọ́lọ́ sị́, ");
INSERT INTO luc_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ꞌbá dịlé rĩ drĩ ru imbá acị́lé túré sĩ ĩꞌdi ꞌbã pá sĩ, ꞌbá ĩꞌdi dịlépi rĩ ní úfẽ drị̃rịma ku be la rá la ĩꞌdi ágọ́bị́ dịlé ꞌdã tãmba kpere ĩꞌdi ꞌbã adrí agá múké-múké rá ká. ꞌBã ũfẽ ụ́ꞌdụ́ ágọ́bị́ dịlé rĩ ꞌbã izalé sĩ uꞌájó vũ gâsĩ rĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Bá ãzí drĩ ĩꞌdi ꞌbã ãtíꞌbó ágọ́bị́ ru jõku ũkú ru rĩ gbã ĩꞌdidrị́ sĩ káyĩ rá, lẽ ꞌbã ịsụ́ drị̃rịma rá, ");
INSERT INTO luc_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","wó ãtíꞌbô drĩ drã ku drĩ ru imbá ụ́ꞌdụ́ ãlu jõku ụ́ꞌdụ́ ị̃rị̃ vúlé gá rá, ĩꞌdi ꞌbã adrujó ãmbógô ꞌbã ãko rĩ sĩ úca dó sĩ ãmbógô ní drị̃rịma fẽlé ku. ");
INSERT INTO luc_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ãgọbị ãzí drĩ kí ru co, drĩ kí ũkú ꞌa trũ la sị̃ sĩ ngọ́tị̂ ní ãfũjó rá, wó ãko ãzí drĩ ũkû idé ũnzí ku, ꞌbá ị́jọ́ ꞌdĩ idélépi rĩ ꞌbã ũfẽ kí ãko ágô jõku kẹ́sị̃ ꞌbã lịlẹ́ kí drị̃ gá rĩ rá. ");
INSERT INTO luc_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Wó údrĩ ĩꞌdi ĩpẽŋã trẹ̃yị́ drĩ sĩ drã rá, ídri ꞌbã ụfụ kí drị̃ ídri be, ");
INSERT INTO luc_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","mịfị́ ꞌbã ụfụ kí drị̃ mịfị́ be, sị́ ꞌbã ụfụ kí drị̃ sị́ be, drị́ ꞌbã ụfụ kí drị̃ drị́ be, pá ꞌbã ụfụ kí drị̃ pá be, ");
INSERT INTO luc_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ívéŋá ꞌbã ụfụ kí drị̃ ívéŋá be, ãkõzá ꞌbã ụfụ kí drị̃ ãkõzá be, kụ̃ŋá ꞌbã ụfụ kí drị̃ kụ̃ŋá be. ");
INSERT INTO luc_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“ꞌBá ãzí drĩ ĩꞌdi ꞌbã ãtíꞌbó ágọ́bị́ ru jõku ũkú ru rĩ ꞌbã mịfị́ gbã rá mịfị́ la drĩ sĩ ru iza rá, lẽ ꞌbã aꞌbe ĩꞌdi mụlé drị̃lẹ́ mgbọ rú sĩ ãtíꞌbó ꞌdã ꞌbã mịfị́ ũfẽjó. ");
INSERT INTO luc_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Drĩ sị́ ãtíꞌbó ágọ́bị́ ru jõku ũkú ru rĩ drị̂ adị́ rá, lẽ ꞌbã aꞌbe ĩꞌdi mụlé drị̃lẹ́ mgbọ rú sĩ ãtíꞌbó ꞌdã ꞌbã sị́ ũfẽjó. ");
INSERT INTO luc_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Mọ́nị̃gọ́ drĩ ágọ́bị́ jõku ũkú ãzí fụ káyĩ, lẽ úꞌbé ĩꞌdi írã sĩ káyĩ ꞌbá ãzí ꞌbã na ĩzá la ku. Wó ícó tị́ ꞌdị́pị rụlé ị́jọ́ ꞌbá drãlépi rĩ drị̂ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Drĩ adru tị́ ũmbá ꞌbá fụlépi fụ̃fụ̃ la, újọ jõ ị́jọ́ la ꞌdị́pị ní tí gĩ jõ ĩꞌdi ku wó drĩ ágọ́bị́ jõku ũkú ãzí fụ káyĩ rá, úꞌbé ĩꞌdi írã sĩ ãzíla lẽ úꞌdị vâ ꞌdị́pị̃ rá. ");
INSERT INTO luc_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Wó údrĩ ãko ãzí ũfẽ rú la lị ĩꞌdi drị̃ gá sĩ ru unzejó, ꞌbã ũfẽ ãko lịlẹ́ ĩꞌdi drị̃ gá rĩ rá. ");
INSERT INTO luc_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Mọ́nị̃gộ drĩ vâ ꞌdị́pị̃ ꞌbã ngọ́pị jõku ị̃zẹ́pị̃ fụ, ála vâ ãzị́táŋá ãlu ꞌdã ꞌbã vúŋá ꞌbã kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Mọ́nị̃gộ drĩ ãtíꞌbó ágọ́bị́ ru jõku ũkú ru ãmbógó ãzí ãni la fụ, tị́ ꞌdị́pị ꞌbã ũfẽ ãmbógó ãtíꞌbó ꞌdã drị̂ séndẽ ífí-ífí sílĩvã kãlị́ na sĩ ãzíla úꞌbé mọ́nị̃gọ́ ꞌdã írã sĩ rá. ");
INSERT INTO luc_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“ꞌBá ãzí drĩ ꞌbụ́ ga drĩ tị la uꞌbé ku jõku drĩ ꞌbụ́ ꞌbá ãzí ꞌbã galé la tị nzị̃ mgbọ ãnãkpá ãzí drĩ aꞌdé ala gá, ");
INSERT INTO luc_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ꞌbụ́ ꞌdị́pị ꞌbã ũfẽ ãnãkpá drãlépi rĩ ꞌbã ꞌdị́pị ꞌi séndẽ sĩ ãzíla ãnãkpá drãlépi rĩ la dó ace ꞌbụ́ ꞌdị́pị ãni. ");
INSERT INTO luc_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“ꞌBá ãzí ꞌbã mọ́nị̃gọ́ drĩ ꞌbá ãzí ãni la fụ káyĩ, lẽ îtụ̃ndã mọ́nị̃gọ́ ídri rĩ rá ꞌbã awa kí séndẽ la kí trũ-trũ ãzíla ꞌbã awa kí vâ ĩzá mọ́nị̃gọ́ drãlépi rá rĩ drị̂ trũ-trũ. ");
INSERT INTO luc_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Wó údrĩ ándrá nị̃ la mọ́nị̃gọ́ ꞌdĩ ũmbá ru ĩꞌdi mọ́nị̃gọ́ kí fụfụ̃, wó ꞌdị́pị̃ drĩ ĩꞌdi gĩ ku, lẽ ꞌbã ũfẽ mọ́nị̃gọ́ drãlépi rá rĩ mọ́nị̃gọ́ sĩ. Mọ́nị̃gọ́ drãlépi rá rĩ dó ace mọ́nị̃gọ́ tá ĩꞌdi fụlépi rĩ ꞌbã ꞌdị́pị ãni. ");
INSERT INTO luc_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ꞌBá ãzí drĩ tị́ jõku kãbĩlõ ụ̃gụ̃ ãzíla drĩ ĩꞌdi lị jõku ị̃tụ̃ndã rá, lẽ ụ̃gụ́ꞌbá ꞌdã ꞌbã ũfẽ tị́ ĩꞌdi ꞌbã ụ̃gụ̃lé ãlu rĩ tị gá tị́ kí tõwú, ãzíla kãbĩlõ ãlu ĩꞌdi ꞌbã ụ̃gụ̃lé rĩ tị gá kãbĩlõ kí sụ. ");
INSERT INTO luc_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Údrĩ ụ̃gụ́ꞌbá rụ jó tị nũ agá ị́nị́ sĩ ãzíla údrĩ ĩꞌdi gbã káyĩ rá, ị́jọ́ ãzí lịlẹ́ ꞌbá ụ̃gụ́ꞌbá ꞌdã ꞌbã ãrí asulépi la drị̃ gá la ꞌdá yụ. ");
INSERT INTO luc_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Wó ị́jọ́ ꞌdĩ drĩ ru nga ịsụ́ ꞌdĩ sĩ ãngũ ụwị́ rá ká, ꞌbá ụ̃gụ́ꞌbá ꞌdã ꞌbã ãrí asulépi rĩ idé ị́jọ́ ũnzí la. “Lẽ ụ̃gụ́ꞌbâ ꞌbã ũfẽ ãko ĩꞌdi ꞌbã ụ̃gụ̃lé rĩ tị rá, wó ãko ãzí drĩ adru ĩꞌdidrị́ ũfẽjó la yụ, lẽ îtụ̃ndã ĩꞌdi ãtíꞌbó ru sĩ ãko ꞌdã tị ũfẽjó. ");
INSERT INTO luc_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Údrĩ ãnãkpá ĩꞌdi ꞌbã ụ̃gụ̃lé rĩ ịsụ́ ĩꞌdidrị́ ꞌdãá ídri, jõ nõ mọ́nị̃gọ́ yã, kãyĩnõ yã jõku kãbĩlõ yã lẽ ꞌbã ũfẽ tị la pâlékó ị̃rị̃ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“ꞌBá drĩ ĩꞌdi ꞌbã ãnãkpá kí ucé ámvụ́ agá jõku ámvụ́ zãbíbũ drị̂ agá ãzíla drĩ kí aꞌbe ị̃sálị filé ꞌbá ãzí ꞌbã ámvụ́ agá, lẽ ꞌbã ũfẽ tị la ãkónã kalépi múké ĩꞌdidrị́ ámvụ́ agá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“ꞌBá ãzí drĩ ãcí su velé drĩ ru iré ãngũ ásé ru rĩ agá pírí sĩ ꞌbá ãzí ꞌbã ãkónã tralé ámvụ́ agá jõku zolépi zozõ jõku ãko ámvụ́ agá rĩ kí ivéjó pírí rá, lẽ ꞌbá ãcí sulépi rĩ ꞌbã ũfẽ ãkónã velépi rĩ kí tị rá. ");
INSERT INTO luc_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“ꞌBá ãzí drĩ ĩꞌdi ꞌbã séndẽ jõku ãko ãzí kí fẽ tãmbalé jĩránĩ drị́ ãzíla údrĩ kí ụ̃gụ̃ ĩꞌdi ꞌbã jĩránĩ drị́ jó agâlé rá, údrĩ ụ̃gụ́ꞌbá la rụ rá, lẽ ụ̃gụ́ꞌbá ꞌdã ꞌbã ũfẽ ãko ĩꞌdi ꞌbã ụ̃gụ̃lé rĩ kí tị pâlékó ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Wó údrĩ ụ̃gụ́ꞌbá la rụ ku, lẽ ꞌbá ãko kí fẽjó ĩꞌdidrị́ rĩ ꞌbã amụ́ pá tulé ãngũ Ãdróŋá ị̃nzị̃jó rĩ gá sĩ amájó la ꞌdụ nõ ãko ĩꞌdi ꞌbã jĩránĩ drị̂ kí nĩ yã áni. ");
INSERT INTO luc_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ãgátã drĩ ãfũ ꞌbá ị̃rị̃ kí drĩdríŋĩ gá jõ nõ mọ́nị̃gọ́ yã, kãyĩnõ yã, kãbĩlõ yã, bõngó yã, jõku ãko ãzí cí ãvĩlépi ãvĩ-ãvĩ la drị̃ gá, ꞌbá ãlu-ãlu drĩ jọ la, ‘Ãko ꞌdĩ mâni,’ ꞌbá ị̃rị̃ ꞌdã ꞌbã ají kí ị́jọ́ ꞌdĩ amálé ãngũ Ãdróŋá ị̃nzị̃jó rĩ gá. Lẽ ꞌbá ị́jọ́ ꞌbã ndẽlé rá rĩ ꞌbã ũfẽ ãko ĩꞌdi ꞌbã jĩránĩ drị́ pâlékó ị̃rị̃ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“ꞌBá ãzí drĩ nõ mọ́nị̃gọ́ yã, kãyĩnõ yã, kãbĩlõ yã, jõku ãnãkpá ãzí fẽ tã mbalé ĩꞌdi ꞌbã jĩránĩ drị́ wó drĩ drã rá, adrá rá jõku ãvĩ rá ꞌbá ãzí ꞌbã nị̃ŋá kóru, ");
INSERT INTO luc_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","lẽ ꞌbá ꞌdĩ ꞌbã mụ ãngũ sĩ Úpí ị̃nzị̃jó rĩ gá ũyõ nalé sĩ jọjó la má ụ̃gụ̃ ꞌbá ꞌdã ꞌbã ãnãkpá ku. Lẽ ꞌdị́pị ꞌbã ãꞌị̃ dó ãvĩ rá rĩ gá rá ãzíla ꞌbá ꞌdã ꞌbã ũfẽ dó sĩ ãrígó tị lã ku. ");
INSERT INTO luc_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Wó údrĩ ãnãkpá ꞌdã ụ̃gụ̃ jĩránĩ drị́ rá, lẽ ꞌbã ũfẽ tị la ꞌdị́pị̃ drị́ rá. ");
INSERT INTO luc_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ãnãkpá ásé agá la drĩ ĩꞌdi ci nalé rá, lẽ ꞌbá tã lã mbalépi rĩ ꞌba ajị́ ị́mbị́ la acelépi rĩ sãdínĩ rú iꞌdalé ꞌdị́pị̃ ní rá ãzíla icó dó sĩ tị la ũfẽlé ku. ");
INSERT INTO luc_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“ꞌBá ãzí drĩ ãnãkpá aꞌị́ ĩꞌdĩ ꞌbã jĩránĩ drị́ ꞌbo ãnãkpâ drĩ adrá rá jõku drã rá ịsụ́ ꞌdĩ sĩ ꞌdị́pị̃ ꞌdáyụ, lẽ ꞌbá aꞌị́lépi la rĩ ꞌbã ũfẽ tị la rá. ");
INSERT INTO luc_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Wó ꞌdị́pị la drĩ adru sáwã ĩꞌdi ꞌbã drãjó rĩ sĩ cí, ûfẽ tị la ku. Wó údrĩ ãnãkpâ ꞌdụ pãngísã rú, ûfẽ tị la ku ãꞌdusĩku séndẽ sĩ ĩꞌdi ĩpãngĩsãjó rĩ ca tị la ũfẽjó rá. ");
INSERT INTO luc_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Ágọ́bị́ ãzí drĩ ĩzóŋá bíkĩrã rú drĩ ũyõ sõlépi ágọ́bị́ ãzí ꞌdụjó ĩꞌdi ꞌbã ágó ru ku la ulé sĩ ru lajó ĩꞌdi sĩ, lẽ ꞌbã ũfẽ ãjẹ̃ ĩzóŋá ꞌdã drị̂ ꞌbã ꞌdụ dó ĩꞌdi ĩꞌdiní ũkú ru. ");
INSERT INTO luc_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Wó ĩzóŋâ ꞌbã átẹ́pị̃ drĩ ĩꞌdi uga fẽlé ágọ́bị́ ꞌdã ní úmgbé, lẽ ꞌbã ũfẽ ãjẹ̃ sĩ izonzi bíkĩrã rú rĩ kí ĩgbãjó rĩ ĩzóŋâ ꞌbã átẹ́pị̃ drị́ rá. ");
INSERT INTO luc_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Ũkú ũjõgõ ãzị́ ngalépi rĩ, lẽ úꞌdị ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“ꞌBá ru lalépi ãnãkpá sĩ rĩ, lẽ úꞌdị ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“ꞌBá ídétáŋá idélépi ãdroŋa ndú ndú ꞌdĩ ꞌbanî adru Úpí ní ku rĩ, lẽ úꞌdị ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Ĩfẽ jõ ũcõgõ ꞌbá ãmị́yọ́ŋá ru rĩ ꞌbaní jõku kí ĩkpãjó ku ãꞌdusĩku ĩmi ándrá vâ Mị̃sị́rị̃ gâlé ãmị́yọ́ŋá. ");
INSERT INTO luc_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Ĩfẽ jõ ãwụzị ꞌbaní ĩmvú kí abe mị́ndrẹ mvụlé ku. ");
INSERT INTO luc_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ĩdrĩ kí fẽ mị́ndrẹ mvụlé rá, wó drĩ kí awá má rụ́, ma ĩꞌbã áwáŋá are rá. ");
INSERT INTO luc_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ũmbã la áma na ĩminí ãzíla ma ĩmi ụꞌdị́ ménéŋá sĩ; ũkú ĩmidrị̂ kí acá ãwụ́zị́ ru ãzíla anzịŋá ĩmidrị̂ kí adru átẹ́pị kóru. ");
INSERT INTO luc_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ĩdrĩ séndẽ fẽ mọ̃rị́ ru ꞌbá mâni ĩmi drĩdríŋĩ gá ꞌdâ lẽmẽrí ru ãlu la nî, ĩmi adru jõ ꞌbá lẽlépi ụ̃rọ̃drị́ ịsụ́lépi séndẽ ãzí lịŋá sĩ drị̃ la gá rĩ kí áni ku. Ĩmi ũꞌbã séndẽ ãzí ụ̃rọ̃drị́ ru la drị̃ la gá ku. ");
INSERT INTO luc_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ĩdrĩ ĩmĩ jĩránĩ ꞌbã bõngó ꞌdụ gúrã rú, ĩmi uja ĩꞌdi ngâ ꞌi ꞌdĩ sĩ ị̃tụ̂ ꞌde drĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ãzî sĩ bõngó ꞌdĩ ꞌi ĩꞌdi ꞌbã ãko cí rá ĩꞌdi ꞌbã sĩ icójó ru drị̃ ꞌbejó rĩ ꞌi. ꞌBá icó kolé drị̃ mgbọ rú íngoní ru? Ĩdrĩ bõngó ꞌdĩ uja ku, wó ĩmĩ jĩránĩ drĩ dó awá áma drị̃lẹ́ gá ãzãkoma ịsụ́jó, ma ĩꞌdi tị are rá ãꞌdusĩku ma Ãdróŋá ꞌbá ꞌbã ízákĩzã ndrelépi ĩndĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Ĩjọ ị́jọ́ ũnzí Ãdróŋá rụ́ ku jõku ĩwã ꞌbá ĩmidrị́ drị̃lẹ́ ru rĩ kí ku. ");
INSERT INTO luc_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Ĩminí ãwãꞌdĩfô fẽ agá mání, ĩfẽ ũndú, wáyĩnĩ ãzíla ãdu drĩ kí adru bábá rĩ gá. “Ĩfẽ anzị ĩmidrị́ ãgọbị kãjãní rĩ kí mánî. ");
INSERT INTO luc_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","“Lẽ ĩfẽ ãnãkpá mvaka kãjãní ru tị́ ꞌbadrị́, ãzíla kãbĩlõ ꞌbadrị̂ kí mání. Be la rá la ꞌbã uꞌá kí ĩꞌbã andreka kí abe ụ́ꞌdụ́ ázị̂rị̃ ráká; ĩmi ají dó kí fẽlé ụ́ꞌdụ́ ãrõ la sĩ. ");
INSERT INTO luc_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Ĩmi ꞌbá mâni ãlá rĩ kî. Ị́jọ́ ꞌdĩ sĩ, ĩna jõ ĩzá ãnãkpá ásé agá rĩ ꞌbã kí cilé nalé nĩ rĩ ꞌbã ị́mbị́ ku. Ĩꞌbe ĩꞌdi ũcogo ꞌbaní. ");
INSERT INTO luc_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Ĩmi ují ụ́ꞌdụ́kọ́ ĩnzõ rú la ku. Ĩmi ãtị̃ ꞌbá ị́jọ́ ũnzí ngalépi rĩ ꞌbã ũngúkú sĩ pá tujó ĩꞌdiní sãdínĩ rú ku. ");
INSERT INTO luc_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Ĩbĩ ũꞌbí ị́jọ́ ũnzí idélépi rĩ kí vú ku. Údrĩ ĩmi umve ị́jọ́ ị̃ndụ́ nzelé sãdínĩ rú dũwánĩ drị̃lẹ́ gá, ĩfi jõ ũꞌbí ꞌbaní ị́jọ́ pịrị rĩ ífí ujajó ĩnzõ rú ku, ");
INSERT INTO luc_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ãzíla ĩfi jõ ꞌbá lẽmẽrí rĩ ní dũwánĩ gá ĩꞌdi ꞌbã adrujó ãko ãzí kóru rĩ sĩ la ku. ");
INSERT INTO luc_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ĩdrĩ ĩmĩ mẹ́rọ́ꞌbá ꞌbã mọ́nị̃gọ́ jõku kãyĩnõ ịsụ́ abá agá, ĩmi agụ ĩꞌdi vúlé ĩꞌdidrị̂lé. ");
INSERT INTO luc_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ĩdrĩ kãyĩnõ ꞌbá ĩmi ngụ̃lépi ũnzí rĩ ꞌbaní la ịsụ́ aꞌdé vũ gá tẹ́rị́ ĩꞌdi ꞌbã selé rĩ trũ, ĩmi aꞌbe jõ ĩꞌdi vũ gá ꞌdãá ku. Ĩtu pá sĩ mẹ́rọ́ꞌbâ ꞌbã ãzã kojó sĩ ĩꞌdiní kãyĩnõ ingajó. ");
INSERT INTO luc_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Mí ụtrị́ ị́jọ́ lịŋá pịrị rĩ ꞌbá lẽmẽrí rĩ ní dũwánĩ gá ku. ");
INSERT INTO luc_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“Ĩtõ ꞌbá ĩnzõ sĩ ku ãzíla ĩfẽ ꞌbá ị́jọ́ kóru rĩ ní drãlé ku ãꞌdusĩku ma ꞌbá pírí ị́jọ́ ũnzí ꞌdĩ áni rĩ kí idélépi rĩ kí ị́jọ́ lị rá. ");
INSERT INTO luc_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Ĩfẽ ꞌbá ãzí ꞌbã sa ĩmi mịfị́ ãko ãzí sĩ ku, ãꞌdusĩku ꞌbá mịfị́ sajó ãko ãzí sĩ rĩ la ꞌbá mịfị́ ãzụ̃ sĩ ị́jọ́ pịrị rĩ ndrejó cí. ꞌBá mịfị́ sajó ãko ãzí sĩ rĩ la ꞌbá ị́jọ́ pịrị rĩ ngalépi rĩ fẽ ị́jọ́ pịrị rĩ ꞌbã ífí ujajó ndú. ");
INSERT INTO luc_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Ĩmi ĩkpã jõ ꞌbá ãmị́yọ́ŋá ru rĩ ku; ãꞌdusĩku ĩꞌbị̃ ándrá adrujó ãmị́yọ́ŋá ru rĩ ꞌbã sị́mvụ́ Mị̃sị́rị̃ gâlé rá. ");
INSERT INTO luc_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Ĩsõ ámvụ́ ĩmidrị́ gá rĩ kí ílí ázíyá sĩ ãkónã sajó ãzíla kí atrájó. ");
INSERT INTO luc_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Wó ílí ázị̂rị̃ la sĩ ĩmi aꞌbe ámvụ́ ĩmidrị̂ kí avị́lé, ĩsõ kí ku. Ị́jọ́ ꞌdĩ sĩ ꞌbá lẽmẽrí ĩmi drĩdríŋĩ gá rĩ ꞌbã ịsụ́ kí sĩ ãkónã ámvụ́ ꞌdã kí agá, ãzíla ãnãkpá ásé agá rĩ ꞌbã na kí acelépi rĩ kî. Ĩmi idé vâ ꞌdĩ ꞌbã áni ámvụ́ zãbíbũ drị̂ ꞌbaní ámvụ́ mị̃zẹ̃yị́tụ̃ drị̂ be. ");
INSERT INTO luc_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Ĩnga ãzị́ ụ́ꞌdụ́ ázíyá, wó ụ́ꞌdụ́ ázị̂rị̃ rĩ sĩ ĩnga ãzị́ ku, ị́jọ́ ꞌdĩ sĩ mọ́nị̃gọ́ ĩmidrị̂ kí kãyĩnõ kí abe, ãtíꞌbó tịlé ĩmidrị́ lị́cọ́ gá rĩ kí ãzíla ꞌbá ãmị́yọ́ŋá ru rĩ kí abe kí dó sĩ sáwã ịsụ́ sĩ avị́jó. ");
INSERT INTO luc_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Ĩmi adru múké-múké sĩ ndrejó la ĩmba ị́jọ́ mání azịlé ĩminí ꞌdĩ kí tã rá. Ĩzị ị́jọ́ ãdroŋa ãzí ndú ꞌdĩ kí tị gá ku, ĩmi umve kí rụ́ ĩmi tị sĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Lẽ ĩꞌbã ụ̃mụ̃ kí na ílí ãlu-ãlu agá sĩ áma ị̃nzị̃jó sĩ ãrútáŋá fẽjó mánî. ");
INSERT INTO luc_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ĩmi ị̃nzị̃ Ụ̃mụ̃ mũkátĩ ãkụ́kị́ kóru rĩ drị̂ ꞌi, ĩna mũkátĩ ãkụ́kị́ kóru rĩ ụ́ꞌdụ́ ázị̂rị̃, cécé mání azịlé ĩminí rĩ áni. Ĩmi ị̃nzị̃ ụ́ꞌdụ́ ꞌdĩ sáwã pịrị rĩ agá ĩmbá na ꞌbã ni sụ be, ãꞌdusĩku ꞌdĩ sáwã ándrá ĩminí sĩ Mị̃sị́rị̃ aꞌbejó rĩ ꞌi. ꞌBá ãzí ꞌbã amụ́ jõ áma drị̃lẹ́ gá drị́drị́ ru ku. ");
INSERT INTO luc_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Ĩꞌbã Ụ̃mụ̃ ãkónã ãfũlépi drị̃drị̃ ĩmidrị́ ámvụ́ agá rĩ drị̂ ꞌi. “Ĩꞌbã Ụ̃mụ̃ ãkónã ámvụ́ agá rĩ kí Atrájó pírí ꞌbo rĩ drị̂ ꞌi ílí ꞌbã ukóŋá gá. ");
INSERT INTO luc_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Ãgọbị ꞌba amụ́ kí Ũkpó ꞌDị́pị Úpí Ãdróŋá drị̃lẹ́ gá ĩꞌdi ị̃nzị̃jó ílí ãlu-ãlu agá pâlékó na. ");
INSERT INTO luc_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Sáwã ụ̃mụ̃ ꞌdĩ drị̂ sĩ lẽ ĩmi ají mání ãrí ãnãkpá ídétáŋá ru rĩ drị̂ ãngũ ãlu gá mũkátĩ idélé ãkụ́kị́ trũ rĩ be ku, ĩmi aꞌbe jõ úsã ĩzá lịlẹ́ mání ídétáŋá ru la ãni la uꞌálé kpere ụ̃ꞌbụ́tị sĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Ílí ãlu-ãlu sĩ ĩmi ají ãkónã ãfũlépi ĩmidrị́ ámvụ́ agá drị̃drị̃ múké ãndânĩ rĩ kí jó Úpí Ãdróŋá ĩmidrị́ gá rĩ drị̂ agá. “Lẽ ĩmi aꞌdí ị̃ndrị́ mváŋá ĩzá ãndrẽ ꞌbã lẹ́sụ́ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Ĩndre drĩ, ma mãlãyíkã ãzí tị pẽ ĩmi drị̃lẹ́ gá ĩmi tãmbajó gẹ̃rị̃ gá ꞌdâ vâ sĩ ĩmi agụjó ãngũ mání itúlé ĩminí rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ĩfẽ ĩꞌdiní ãrútáŋá ãzíla ĩmi are ị́jọ́ ĩꞌdi ꞌbã jọlé rĩ kî. Ĩgã jõ ĩꞌdi tị ku, ãꞌdusĩku icó ĩmi trũlé ị́jọ́ ĩminí ĩꞌdi tị gãjó rĩ gá ku áma rụ́ ꞌbã adrujó ĩꞌdi agá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Wó ĩdrĩ ị́jọ́ ĩꞌdi tị gá rĩ are múké-múké ãzíla ĩdrĩ ị́jọ́ mání jọlé ĩminí rĩ kí nga rá, ma mụ adrulé mẹ́rọ́ꞌbá ru ꞌbá ĩmi lẽlépi ku rĩ ꞌba ní ãzíla ma ãꞌdị́ ꞌdị bá ĩmi ngụ̃lépi ũnzí rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mãlãyíkã mádrị́ gá rĩ lã mụ ĩmi drị̃ ꞌdelé ãzíla ĩmi agụlé ãngũ ꞌbá Ãmọ́rị̃ rú, Hị́tị̃ rú, Pẹ̃rẹ́zị̃ rú, Kãnánĩ rú, Hị́vị̃ rú ãzíla Yẹ̃bụ́sị̃ rú rĩ ꞌbadrị̂ agá ãzíla ma ꞌbá ꞌdĩ kí ị̃lị̃kị̃ pírí. ");
INSERT INTO luc_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ĩmi ụ̃tị̃ ãja ãdroŋa ĩꞌbadrị̂ kí drị̃lẹ́ gá jõku kí ị̃nzị̃jó jõku ị́jọ́ ĩꞌbã kí ngalé rĩ kí ngajó ku. Ĩmi andi ãdroŋa ĩꞌbadrị́ gá rĩ kí ãzíla ĩmi aco írã ĩꞌbã ãni ị̃nzị̃lé ị̃nzị̃-ị̃nzị̃ ꞌdĩ kí vụ̃rụ́. ");
INSERT INTO luc_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ĩmi ị̃nzị̃ Úpí Ãdróŋá ĩmidrị́ gá rĩ ꞌi, ị́jọ́ ꞌdĩ sĩ, ásị́ ị̃gbẹ̃ ĩꞌdidrị̂ la dó sĩ adru ãkónã ĩmidrị́ gá rĩ kí drị̃ gá ị̃yị́ abe. Ma ãyánĩ kí nze ĩmi drĩdríŋĩ gá ꞌdâ pírí rá ");
INSERT INTO luc_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ũkú ãzí ꞌbã ngọ́tị́ŋá icó ãfũlé ku jõku ꞌbá ãzí icó adrulé úndó ru ãngũ ĩmidrị̂ agá ꞌdâ ku. Ma ĩmi fẽ uꞌálé ụ́ꞌdụ́ ãzo rú. ");
INSERT INTO luc_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Ma ꞌbá ị́jọ́ ĩmidrị̂ kí gãlépi úmgbé rĩ kí fẽ acájó ụ̃rị̃ sĩ ãzíla ãbãŋá ají sụ́rụ́ ãlu-ãlu ĩminí drị̃ ụfụjó ĩꞌba abe rĩ ꞌbanî. Ma mẹ́rọ́ꞌbá ĩmidrị̂ kí fẽ pírí ru ũngúkú ujajó sĩ apájó ĩmi sĩ apá-apâ. ");
INSERT INTO luc_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ma mẹ́rọ́ꞌbá ĩmidrị̂ kí ụrụꞌbá fẽ ãcí colé kpĩrí-kpĩrí ãzíla ma sụ́rụ́ Hị́vị̃ drị́, Kãnánĩ drị́ ãzíla Hị́tị̃ drị́ ꞌdĩ kí dro gẹ̃rị̃ ĩminí mụjó rĩ agá rĩ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Wó má icó kí drolé ílí ãlu agá ku, ãꞌdusĩku ádrĩ kí dro rá, ãngũ lã mụ acálé bá kóru ãzíla ãnãkpá ásé agá rĩ kí kãlãfe la acá ũꞌbíkãná rú ĩminí ãndânĩ. ");
INSERT INTO luc_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ma mụ kí drolé ĩmi drị̃lẹ́ gá ꞌdãá were-were, kpere kãlãfe ĩmidrị̂ ꞌbã ca agá sĩ ãngũ ꞌdã ꞌdụjó ĩmi ãni la rú. ");
INSERT INTO luc_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Ma lõkókõrí ĩmidrị̂ ꞌbã angájó Mĩrĩ Ika rĩ gá kpere ị̃yị́ ꞌbá Fị̃lị̃sị̃tị́nị̃ rú rĩ ꞌbadrị̂ agá, ãzíla iꞌdójó kõtórõ agá rĩ sĩ kpere ị̃yị́ Ũfũrátĩ gá. Ma ꞌbá uꞌálépi ãngũ ꞌdĩ agá rĩ kí fẽ ĩmi drị́ alé gá ãzíla ĩmi kí dro ĩmi drị̃lẹ́ gá rĩ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ĩmi icí tị ĩꞌba abe jõku ãdroŋa ĩꞌbadrị̂ abe ku. ");
INSERT INTO luc_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ĩfẽ ĩꞌbaní uꞌájó ãngũ ĩmidrị̂ drị̃ gá ku, jõ íni ku, kí ĩmi fẽ ị́jọ́ ũnzí idélé áma ụrụꞌbá gá, ãꞌdusĩku ĩꞌba ní ãdroŋa ĩꞌbadrị̂ kí ị̃nzị̃jó rĩ la adru ĩminí ãko ĩmi isílépi la rú.” ");
INSERT INTO luc_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Úpí jọ Mụ́sã ní, “Ĩmi amụ́ Ãrọ́nị̃ be má rụ́ ꞌdõlé, Nãdábũ kí Ãbị́hụ̃ be ãzíla ꞌbá ĩyõ kãlị́ ázị̂rị̃ Ịsịrayị́lị̃ drị̂ kí abe. Ĩmi ị̃nzị̃ ma ĩminí adru agá rá-rá ru, ");
INSERT INTO luc_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","wó Mụ́sã ꞌbã amụ́ kpere má rụ́ ꞌdõlé áꞌdụ̂sĩ, ꞌbá ãzí ꞌbã asé kí ru ãni rú ku ãzíla ꞌbá ãzí ꞌbã amụ́ Mụ́sã be ĩndĩ ku.” ");
INSERT INTO luc_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mụ́sã la mụ ị́jọ́ Úpí drị̂ kí vú nzelé ãzị́táŋá ĩꞌdidrị̂ kí abe ꞌbá ꞌdĩ ꞌbaní ꞌbo, umvi kí pírí ị́jọ́ tị ãlu sĩ, “Ị́jọ́ pírí Úpí ꞌbã jọlé rĩ kí ãma kí nga rá.” ");
INSERT INTO luc_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ꞌDã ꞌbã ũngúkú gá, Mụ́sã sĩ dó ị́jọ́ Úpí ꞌbã jọlé rĩ kí pírí vũ gá. Mụ́sã angá ụ̃ꞌbụ́tị nị́nị́ ãzíla sị ãlĩtárĩ ꞌbé pá gá ꞌdãá ãzíla ụ̃tị̃ írã kí mụdrị́ drị̃ ị̃rị̃, írã ãlu-ãlu tu pá sụ́rụ́ ꞌbá Ịsịrayị́lị̃ rú rĩ ꞌbadrị̂ kí kẹ̃jị́ gá. ");
INSERT INTO luc_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ꞌDã ꞌbã ũngúkú gá, pẽ dó kãrị́lẹ̃ Ịsịrayị́lị̃ drị̂ kí tị ídétáŋá ivélé ivê rĩ idélé ãzíla fẽ kí ídétáŋá ru mọ́nị̃gọ́ mũlũkũdũ la kí ídétáŋá ásị́ ị̃gbẹ̃ drị̂ rú Úpí nî. ");
INSERT INTO luc_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mụ́sã ꞌdụ ãrí nụ́sụ̃ ãnãkpá lịlẹ́ ídétáŋá idéjó ꞌdã ꞌbadrị̂ ꞌi ãzíla sũ dó ĩꞌdi bãkụ́lẹ̃ kí agá ãzíla ũyã nụ́sụ̃ la ãlĩtárĩ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ꞌDã ꞌbã ũngúkú gá, Mụ́sã ꞌdụ Bụ́kụ̃ tị Icíma drị̂ ꞌi ãzíla lã dó ĩꞌdi ꞌbá ꞌbanî. ꞌBá umvi kí, “Ãma ị́jọ́ Úpí ꞌbã jọlé ãmaní ꞌdĩ kí nga pírí rá; ãma kí vú ũbĩ rá.” ");
INSERT INTO luc_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ꞌDãá Mụ́sã ꞌdụ ãrî ꞌi, ũyã dó ĩꞌdi ꞌbá kí drị̃ gá ãzíla jọ, “ꞌDĩ ãrí tị icíma ãni Úpí ꞌbã tị icíjó ĩmi abe ĩꞌdi ꞌbã ãzị́táŋá ꞌdĩ kí fẽjó rĩ sĩ rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mụ́sã ꞌi, Ãrọ́nị̃ ꞌi, Nãdábũ ꞌi Ãbị́hụ̃ ꞌi ãzíla ꞌbá ĩyõ kãlị́ ázị̂rị̃ Ịsịrayị́lị̃ drị̂ kí abe tụ kí ꞌbé drị̃ gá ụrụgâlé ");
INSERT INTO luc_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ãzíla ndre kí dó sĩ Ãdróŋá Ịsịrayị́lị̃ drị̂ rá. Ãko ĩꞌdi sĩ pá ꞌbãjó drị̃ la gá rĩ cécé jó ꞌa idélé írã pãrã-pãrã sãfírẽ sĩ rĩ áni, ãlápítítí ru ꞌbụ̃ áni. ");
INSERT INTO luc_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Wó Ãdróŋá idé drị̃lẹ́ Ịsịrayị́lị̃ drị̂ kí ũnzí ku; táni ĩꞌbã kí Ãdróŋá ndre agá rá tí, na kí ãkónã ãzíla mvụ kí ãko mvụlé mvụ-mvụ̃ rĩ kí ĩꞌdi andre gâsĩ ãngũ ãlu gá. ");
INSERT INTO luc_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Úpí jọ Mụ́sã nî, “Mí atụ́ má rụ́ ꞌbé sị́ gá ꞌdõlé ãzíla mí uꞌá ꞌdâ, ma míní írã ꞌbara-ꞌbara mání sĩ ãzị́táŋá sĩjó drị̃ la gá rĩ kí fẽ, míní sĩ ꞌbá kí imbájó.” ");
INSERT INTO luc_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mụ́sã ko kí dó drị̃ mụlé Yósũwã ꞌbá ĩꞌdi ãzãkolépi rĩ be, ãzíla Mụ́sã tụ dó ꞌbé Ãdróŋá drị̂ drị̃ gâlé. ");
INSERT INTO luc_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Jọ ꞌbá ĩyõ rĩ ꞌbaní, “Ĩtẽ ãma ꞌdâ kpere ãma ní ãgõ agá ĩmi rụ́ ꞌdõlé. Ãrọ́nị̃ kí Hụ́rị̃ be kí adru ĩmi abe cí. ꞌBá ãzí drĩ kí ị́jọ́ ịsụ́ kí drĩdríŋĩ gá, ꞌbã mụ kí ĩꞌba rụ́ sĩ ị́jọ́ la itújó.” ");
INSERT INTO luc_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mụ́sã la dó mụ tụlé ꞌbé sị́ gâlé ꞌbo, ụ̃rụ́ꞌbụ̃ aku dó ꞌbê cí. ");
INSERT INTO luc_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Dị̃zã Úpí drị̂ ri dó ꞌbé Sĩnáyĩ drị̃ gá. Ụ̃rụ́ꞌbụ̃ aku ꞌbê drị̃ ụ́ꞌdụ́ ázíyá, wó ụ́ꞌdụ́ ázị̂rị̃ rĩ sĩ Úpí umve Mụ́sã ꞌi angájó ụ̃rụ́ꞌbụ̃ agâlé. ");
INSERT INTO luc_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Dị̃zã Úpí drị̂ indré ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ꞌbé drị̃ gá ꞌdãá cécé ãcí ãko kí ivélépi rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ꞌDã ꞌbã ũngúkú gá, Mụ́sã ꞌbã mụ agá ꞌbé sị́ gâlé, fi dó ụ̃rụ́ꞌbụ̃ agá. Ãzíla uꞌá dó ꞌbé drị̃ gá ꞌdãá ụ́ꞌdụ́ kãlị́ sụ ãzíla ị́nị́ kãlị́ sụ. ");
INSERT INTO luc_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Úpí jọ Mụ́sã ní, ");
INSERT INTO luc_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ílũ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ꞌbã ají kí mání ãwãꞌdĩfô fẽlé. Mí aꞌị́ mání ãko ꞌbá ãlu-ãlu lẽlépi ãwãꞌdĩfô fẽlépi ĩꞌdi ásị́ agâlé mání rá rĩ drị́. ");
INSERT INTO luc_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ꞌDĩ kí ãko míní mụlé aꞌị́lé rĩ kî: gólũdĩ, sílĩvã ãzíla aya bũrônzĩ rú rĩ; ");
INSERT INTO luc_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","wị́zị̃ la ꞌbã gbẽtí ꞌbã adru kí bụ̃lụ̂, pápũlũ ãzíla ika; bõngó ãjẹ̃ rú mịfị́ níríŋá, idélé ị̃ndrị́ ꞌbíko sĩ rĩ; ");
INSERT INTO luc_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","kãbĩlõ íní vúlé rángi sĩ ika rĩ kí, ãnãkpá íníríkó ãlá la sĩ, báwũ ꞌbọ́kọ́lọ̃ ife drị̂ sĩ, ");
INSERT INTO luc_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","tárã ãdu; ãdu ãjị́ ngụ̃lépi vĩrĩ ũsũlé ꞌbá drị̃ gá rĩ ꞌi ãzíla lũbánĩ ivélé ivê rĩ be; ");
INSERT INTO luc_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ãzíla írã únĩkĩsĩ rú rĩ kí írã ãzí ãjẹ̃ rú icólé ịgbẹlé átáló ãmbógó ãndânĩ rĩ ꞌbã bõngó ĩfódĩ rú rĩ gá ãzíla bõngó jụ́jụ́ gá rĩ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“ꞌDã ꞌbã ũngúkú gá, ꞌbá Ịsịrayị́lị̃ drị́ ꞌdĩ ꞌbã sị kí mání ãngũ ãlápítí la, ma dó sĩ uꞌá ĩꞌba abe. ");
INSERT INTO luc_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ísị Hémã sĩ áma ị̃nzị̃jó rĩ ãko ũꞌbãlé ala gá ꞌdĩ kí abe cécé mání mụlé iꞌdalé míní rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Úpí jọ Mụ́sã nî, “ꞌBá Ịsịrayị́lị̃ drị̂ ꞌbã idé kí Sãndụ́kụ̃ tị icíma drị̂ báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ, ꞌbã zo mítã ãlu nụ́sụ̃, mgbọ la ꞌbã adru ãni rú mítã ãlu nụ́sụ̃, ãzíla ãzo la ụrụgâlé ru rĩ ꞌbã adru ãni rú mítã ãlu nụ́sụ̃. ");
INSERT INTO luc_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Íꞌbu ụrụꞌbá la agâ sĩ ãzíla ãmvê sĩ rĩ gólũdĩ ãlá rĩ sĩ. Ãzíla mí ulí láyĩnĩ ũnĩ ãni la gólũdĩ sĩ ụrụꞌbá la gâsĩ pírí cí. ");
INSERT INTO luc_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Mí idé Sãndụ́kụ̃ tị icíma drị̂ ní ímve gólũdĩ sĩ la kí sụ sĩ ĩꞌdi ujíjó, mí icí kí pá la sụ rĩ kí agá, ímve ꞌbã adru kí Sãndụ́kụ̃ ꞌbã wókõ ãlu rĩ gá ị̃rị̃ ãzí rĩ gá vâ ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ꞌDã ꞌbã ũngúkú gá, mí idé ife sĩ ĩꞌdi ujíjó la kí báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ ãzíla íꞌbu ụrụꞌbá la kí gólũdĩ sĩ cí ");
INSERT INTO luc_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ãzíla ísu ife sĩ ĩꞌdi ujíjó la kí ímve ꞌdã kí agâ sĩ Sãndụ́kụ̃ tị icíma drị̂ ꞌbã bụ́lụ́ gâsĩ sĩ ĩꞌdi ujíjó. ");
INSERT INTO luc_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ife sĩ Sãndụ́kụ̃ tị icíma drị̂ ujíjó rĩ ꞌbã ace kí ímve kí agá ꞌdãá ũgũgõ; lẽ únze kí ku. ");
INSERT INTO luc_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ꞌDã ꞌbã ũngúkú gá, íꞌbã dó ãzị́táŋá mání sĩlé írã ꞌbara-ꞌbara ị̃rị̃ ꞌdã kí drị̃ gá mání mụlé fẽlé mídrị́ rĩ kí ala gá. ");
INSERT INTO luc_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Mí idé Sãndụ́kụ̃ tị icíma drị̂ ní úmvúke ásị́ ị̃gbẹ̃ drị́ sĩ ĩꞌdi tị ụ̃pị̃jó rĩ gólũdĩ ãlá rĩ sĩ, ãzo la ꞌbã adru ãni rú mítã ãlu nụ́sụ̃, mgbọ la ꞌbã adru ãni rú mítã ãlu. ");
INSERT INTO luc_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Mí idé kẹ̃rụ́bị̃ ụ́pụ́pị́ trũ la kí ị̃rị̃ gólũdĩ uꞌdilé uꞌdî rĩ sĩ úmvúke ásị́ ị̃gbẹ̃ drị̂ ꞌbã tị ãsị̃jó rĩ kí gá. ");
INSERT INTO luc_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Mí idé kẹ̃rụ́bị̃ ụ́pụ́pị́ trũ ãlu rĩ wókõ ãlu rĩ gá, ãzí ãlu rĩ vâ ãzí rĩ gá; mí icí kẹ̃rụ́bị̃ ụ́pụ́pị́ trũ rĩ kí Sãndụ́kụ̃ ꞌbã tị be ãlu tị la ị̃rị̃ rĩ kí gá. ");
INSERT INTO luc_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kẹ̃rụ́bị̃ ụ́pụ́pị́ trũ rĩ ꞌbã inga kí ru ụ́pụ́pị́ ụrụgâlé ru ꞌbã aku kí dó sĩ úmvúke ásị́ ị̃gbẹ̃ drị́ sĩ Sãndụ́kụ̃ tị ụ̃pị̃jó rĩ cí. ꞌBã ndre kí ru ndre-ndrẽ ãzíla ꞌbã ndre kí ãngũ ãko sĩ Sãndụ́kụ̃ ꞌbã tị ụ̃pị̃jó rĩ gâlé ru. ");
INSERT INTO luc_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Íꞌbã írã ꞌbara-ꞌbara ị̃rị̃ ꞌdĩ kí Sãndụ́kụ̃ tị icíma drị̂ agá ãzíla mí ụ̃pị̃ dó Sãndụ́kụ̃ tị cí. ");
INSERT INTO luc_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ma dó mụ drị̃ ụfụlé mí be úmvúke ásị́ ị̃gbẹ̃ drị́ sĩ Sãndụ́kụ̃ tị icíma drị̂ tị ụ̃pị̃jó rĩ ꞌbã drị̃lẹ́ gá, kẹ̃rụ́bị̃ ụ́pụ́pị́ trũ ị̃rị̃ ipalé Sãndụ́kụ̃ ị́jọ́ vú nzejó rĩ kí drĩdríŋĩ gá ꞌdãá. Ma mụ drị̃ ụfụlé mí be ãzíla ma míní ãzị́táŋá mádrị́ bá Ịsịrayị́lị̃ drị̂ ꞌbaní rĩ kí fẽ. ");
INSERT INTO luc_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Mí idé méjã báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ, ãzo la ꞌbã adru ãni rú mítã ãlu, mgbọ la ꞌbã adru ãni rú nụ̃sụ̃ mítã ãzíla ãzo la ụrụgâlé ru rĩ ꞌbã adru ãni rú mítã ãlu. ");
INSERT INTO luc_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Íꞌbu ụrụꞌbá la gólũdĩ ãlá rĩ sĩ ãzíla íli tị la pírí gólũdĩ sĩ trộkị́lịrị cí. ");
INSERT INTO luc_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Íli tị la trộkị́lịrị ꞌbã adru ãni rú ị́nzị̃ na ãzíla íꞌbu ĩꞌdi gólũdĩ sĩ cí. ");
INSERT INTO luc_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Mí idé ímve gólũdĩ sĩ la kí sụ méjã ꞌdĩ ní sĩ ĩꞌdi ujíjó, ãzíla mí icí kí kónã la sụ ꞌdĩ kí agá ãngũ ĩꞌdi ꞌbã pá ꞌbã adrujó rĩ kí agá. ");
INSERT INTO luc_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ímve ꞌdĩ ꞌbã adru kí méjã ꞌbã bụ́lụ́ gâsĩ ãni rú sĩ ife usúlé ĩꞌdi ujíjó rĩ kí rụjó. ");
INSERT INTO luc_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Mí idé ife ꞌdĩ kí báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ, íꞌbu kí ụrụꞌbá gólũdĩ sĩ cí ãzíla íꞌdụ dó méjã ꞌi ife ꞌdĩ kî sĩ. ");
INSERT INTO luc_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Mí idé sãánĩ, kópõ, jágĩ ãzíla bãkụ́lẹ̃ kí gólũdĩ ãlá rĩ sĩ, sĩ wáyĩnĩ ãwãꞌdĩfô ru rĩ kí ũsũjó. ");
INSERT INTO luc_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Mũkátĩ ãlá rĩ ꞌbã adru méjã ꞌdĩ drị̃ gá sáwã pírí sĩ cí. ");
INSERT INTO luc_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Mí idé tárã céke gólũdĩ ãlá uꞌdilé uꞌdî rĩ sĩ, ị̃ndụ́ la kí gbọ́ŋị la be; kópõ la cécé mãwụ́wã áni rĩ kí abe, mãwụ́wã drĩ drị̃kã nzị̃lépi ku rĩ abe ãzíla ꞌbã icí kí ru mãwụ́wã la abe pírí ãlu. ");
INSERT INTO luc_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Tárã céke ꞌbã gbọ́ŋị gá mí idé kénĩ kí ázíyá, na rĩ kí wókõ ãlu rĩ gá ãzí na rĩ kí wókõ ãzí rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kénĩ ãlu-ãlu ụrụꞌbá gá mí idé mãwụ́wã íꞌdá cécé ãlĩmóndĩ drị́ agbẹ́lépi ãzíla ayilépi rĩ kí áni, ꞌbã adru kí na-na. Mí idé ĩꞌdi pírí ꞌdĩ ꞌbã áni kénĩ ázíyá ãfũlépi tárã céke kí ụrụꞌbá gâlé ꞌdã ꞌba rụ́. ");
INSERT INTO luc_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Tárã céke ágágá rĩ drị̃ gá mãwụ́wã idélé cécé mãwụ́wã ãlĩmóndĩ drị̂ áni agbẹ́lépi ngúlú ãzíla ayilépi rĩ ꞌbã íꞌdá ꞌbã adru kí sụ. ");
INSERT INTO luc_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Mãwụ́wã drị̃kã agbẹ́lépi ngúlú rĩ ꞌbã adru kí kénĩ ãfũlépi tárã céke kí ụrụꞌbá gâlé ru ị̃rị̃-ị̃rị̃ sĩ na ꞌdĩ kí ị̃ndụ́lé gá ãlu-ãlu cí. ");
INSERT INTO luc_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Tárã céke, kénĩ la kí ãzíla mãwụ́wã drị̃ ngúlú rĩ kí abe, mí idé kí gólũdĩ ãlá ꞌbara ãlu la sĩ. ");
INSERT INTO luc_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Mí idé dó tárã la ázị̂rị̃ rĩ kí ãzíla mí usú dó kí ụrụ gá, ꞌbã ji kí dó sĩ ãngũ benĩ. ");
INSERT INTO luc_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Mí idé aya kpákuŋá ru sĩ ãko kí rụjó jõku aꞌdụ́jó rĩ ãzíla trụ̃wẹ́yị̃ idélé gólũdĩ ãlá rĩ sĩ la kî. ");
INSERT INTO luc_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Mí ayú gólũdĩ ãlá rĩ kị́lọ̃ kãlị́ na drị̃ tõwú sĩ tárã céke idéjó ãzíla ãko ndú-ndú ala gá rĩ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Mí adru múké-múké, mí idé jõ ãko ꞌdĩ kí pírí gbíyã iꞌdalé míní ꞌbé drị̃ gâlé rĩ kí vú sĩ.” ");
INSERT INTO luc_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Úpí jọ Mụ́sã ní, “Ísị Hémã sĩ áma ị̃nzị̃jó rĩ. Mí ayú bõngó mụdrị́ mịfị́ níríŋá uꞌbélé wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika sĩ la kí, ꞌbá ãlị̃gọ̃ ãko idélé drị́ sĩ rĩ drị̂ trũ la ꞌbã idé kí íꞌdá kẹ̃rụ́bị̃ ãni la kí ụrụꞌbá la kí gá cí. ");
INSERT INTO luc_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Bõngó ayúlé rĩ ꞌbã adru kí trũ-trũ, ãzo la ꞌbã adru mítã mụdrị́ drị̃ ị̃rị̃, mgbọ la ꞌbã adru mítã ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Mí icí bõngó tõwú rĩ kí ãlu, mí idé vâ ãzí tõwú rĩ kí abe ꞌdã áni. ");
INSERT INTO luc_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Mí ịgbẹ ꞌbụ́ bõngó bụ̃lụ̂ sĩ la kí bõngó tõwú icílé ãlu rĩ ꞌbã tị gâsĩ, mí idé vâ bõngó ãzí tõwú icílé ãlu rĩ kí abe ꞌdĩ ꞌbã áni. ");
INSERT INTO luc_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Mí ịgbẹ ꞌbụ́ ꞌdĩ kí bõngó tõwú icílé ãlu rĩ ꞌbã tị gá kãlị́ tõwú ãzíla ꞌbụ́ kãlị́ tõwú bõngó ãzí tõwú icílé ãlu rĩ ꞌbã tị gá, ꞌbụ́ ꞌdĩ ꞌbã ndre kí ru ndre-ndrẽ. ");
INSERT INTO luc_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ꞌDã ꞌbã ũngúkú gá, mí idé gõlĩ idélé gólũdĩ sĩ rĩ kí kãlị́ tõwú ãzíla mí ayú kí sĩ bõngó ꞌdĩ kí ũgĩjó ãlu, ị́jọ́ ꞌdĩ sĩ, Hémã sĩ áma ị̃nzị̃jó rĩ ꞌbã icí rû sĩ ru ãlu benĩ. ");
INSERT INTO luc_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Mí idé bõngó ãzí kí mụdrị́ drị̃ ãlu ị̃ndrị́ ꞌbíko sĩ, sĩ Hémã sĩ áma ị̃nzị̃jó rĩ drị̃ akujó. ");
INSERT INTO luc_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Bõngó mụdrị́ drị̃ ãlu ꞌdĩ ꞌbã adru kí pírí trũ-trũ, ãzo la ꞌbã adru kí mítã mụdrị́ drị̃ na ãzíla mgbọ la ꞌbã adru mítã ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Mí icí bõngó tõwú rĩ kí ãngũ ãlu gá, mí icí vâ ãzí ázíyá rĩ kí ãngũ ãlu gá. Bõngó námbã ázíyá sĩ Hémã ꞌbã drị̃lẹ́ gá rĩ mí aca ĩꞌdi ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Mí ịgbẹ ꞌbụ́ ꞌdĩ kí bõngó tõwú icílé ãlu rĩ ꞌbã tị gá kãlị́ tõwú ãzíla ꞌbụ́ kãlị́ tõwú bõngó ãzí tõwú icílé ãlu rĩ ꞌbã tị gá. ");
INSERT INTO luc_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Mí idé gõlĩ bũrônzĩ sĩ rĩ kí kãlị́ tõwú ãzíla mí ũgĩ kí ꞌbụ́ míní ịgbẹlé bõngó tị gá rĩ kí agá sĩ Hémã ꞌdĩ umbéjó ãko ãlu rú. ");
INSERT INTO luc_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ígĩ bõngó tị ãfũlépi nụ́sụ̃ rú rĩ Hémã sĩ áma ị̃nzị̃jó rĩ ꞌbã ũngúkú gá. ");
INSERT INTO luc_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Bõngó tị acelépi rĩ ꞌbã adru nụ̃sụ̃ mítã wókõ ị̃rị̃ rĩ kí agá; tị la acelépi rĩ ála ũgĩ la Hémã sĩ áma ị̃nzị̃jó rĩ ꞌbã bụ́lụ́ gâsĩ, sĩ ĩꞌdi akujó. ");
INSERT INTO luc_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Mí idé Hémã ꞌdĩ ní ãko ĩꞌdi akujó la kãbĩlógó ꞌbã íníríkó uꞌbélé rángi ika la sĩ la sĩ, ãzíla mí aku ĩꞌdi drị̃ ãnãkpá íníríkó ãlá la sĩ. ");
INSERT INTO luc_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Mí idé báwũ ị́dị́ŋá ru kpị la kí báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ sĩ Hémã sĩ áma ị̃nzị̃jó rĩ sịjó. ");
INSERT INTO luc_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Báwũ ị́dị́ŋá ru rĩ kí pírí ꞌbã zo kí mítã sụ-sụ ãzíla mgbọ la kí drĩdríŋĩ gá rĩ ꞌbã adru sẽndị́mĩtã 66, ");
INSERT INTO luc_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","sị́ la ꞌbã ãfũ kí ị̃rị̃ sĩ ĩꞌdi icíjó ãzí rĩ be. Mí idé báwũ ị́dị́ŋá ru Hémã sĩ áma ị̃nzị̃jó rĩ drị̂ kí pírí ꞌdĩ ꞌbã áni. ");
INSERT INTO luc_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Mí idé báwũ ị́dị́ŋá ru ri kí kãlị́ ị̃rị̃ Hémã sĩ áma ị̃nzị̃jó rĩ ꞌbã wókõ ándrá rĩ gá ");
INSERT INTO luc_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ãzíla mí idé ãko báwũ ị́dị́ŋá ru rĩ kí ị̃ndụ́ usújó sílĩvã rú la kí ĩꞌbaní cí, mí idé báwũ ị́dị́ŋá ãlu-ãlu ní ãko ị̃ndụ́ la sujó rĩ kí ị̃rị̃-ị̃rị̃, ísu ị̃ndụ́ la idélé sílĩvã sĩ rĩ ị́dị́ŋá ãlu-ãlu ꞌbã tị ãfũlépi rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Hémã sĩ áma ị̃nzị̃jó rĩ ꞌbã wókõ ụ́rụ́lé rĩ gá, mí idé báwũ ị́dị́ŋá ru la kí kãlị́ ị̃rị̃ ");
INSERT INTO luc_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ãzíla ị̃ndụ́ la idélé sílĩvã sĩ rĩ ꞌbã adru kí kãlị́ sụ, ị́dị́ŋá ãlu-ãlu ị̃ndụ́ gá ꞌbã adru kí ị̃rị̃-ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Mí idé Hémã sĩ áma ị̃nzị̃jó rĩ ní báwũ ị́dị́ŋá ru rĩ kí ázíyá, wókõ la ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ gá, ");
INSERT INTO luc_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","mí idé vâ báwũ ị́dị́ŋá ru rĩ kí ị̃rị̃ kónã Hémã sĩ áma ị̃nzị̃jó rĩ drị̂ ꞌbã tị ní ãsị̃jó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Kónã ị̃rị̃ ꞌdĩ kí agá lẽ úsu ị́dị́ŋá kí ímve ãlu agá ị̃rị̃ iꞌdójó ị̃ndụ́ la gá kpere drị̃ la gá; ĩmi idé ị́dị́ŋá ꞌdĩ kí ị̃rị̃trá ũví ãlu sĩ. ");
INSERT INTO luc_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ị́jọ́ ꞌdĩ sĩ, báwũ ị́dị́ŋá ru rĩ kí dó sĩ adru ãrõ ãzíla ị̃ndụ́ la sílĩvã rú rĩ kí adru mụdrị́ drị̃ ázíyá, ị́dị́ŋá ãlu-ãlu ị̃ndụ́ gá ị̃rị̃-ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Mí idé báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ, báwũ alalé alâ la kî: tõwú rĩ ꞌbã adru kí báwũ ị́dị́ŋá ru Hémã sĩ áma ị̃nzị̃jó rĩ ꞌbã bụ́lụ́ ãlu rĩ gá, ");
INSERT INTO luc_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ãzí tõwú rĩ ꞌbã adru kí vâ bụ́lụ́ la ãzí rĩ gá, ãzíla báwũ ị́dị́ŋá ru tõwú rĩ ꞌba adru kí wókõ la ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ gá ãngũ Hémã sĩ áma ị̃nzị̃jó rĩ ꞌbã tị ꞌbã sĩ ãsị̃jó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Báwũ jó ife rú ꞌbãlé ágágá alalé alâ rĩ ꞌbã adru iꞌdóŋá gá kpere ãsị̃ŋá gá báwũ ị́dị́ŋá ru ágágá rĩ kí drị̃ gâsĩ. ");
INSERT INTO luc_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Íꞌbu báwũ ị́dị́ŋá ru ꞌdĩ kí ụrụꞌbá gólũdĩ sĩ cí ãzíla mí idé ímve gólũdĩ sĩ la kí sĩ báwũ alalé alâ jó ife rú ĩjũlé ꞌdĩ kí rụjó cí. ");
INSERT INTO luc_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Mí idé Hémã sĩ áma ị̃nzị̃jó rĩ ũví la iꞌdajó la míní ꞌbé drị̃ gâlé rĩ ꞌbã vúŋá sĩ. ");
INSERT INTO luc_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Mí idé kátẽnĩ uꞌbélé wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika sĩ la kí, ꞌbá ãlị̃gọ̃ ãko idélé drị́ sĩ rĩ drị̂ trũ la ꞌbã idé kí íꞌdá kẹ̃rụ́bị̃ ãni la ụrụꞌbá la gá cí. ");
INSERT INTO luc_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ígĩ kátẽnĩ ꞌdĩ gõlĩ idélé gólũdĩ sĩ usúlé ị́dị́ŋá sụ idélé báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ ụrụꞌbá ꞌbulé gólũdĩ sĩ ãzíla usúlé ị̃ndụ́ la idélé sílĩvã sĩ rĩ kí drị̃ gá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ígĩ dó kátẽnĩ ꞌdĩ láyĩnĩ gõlĩ ꞌbadrị̂ ụrụꞌbá gá Hémã ꞌbã drị̃ gá ãzíla íꞌbã dó Sãndụ́kụ̃ tị icíma drị̂ kátẽnĩ ị̃ndụ́lé gá. Kátẽnĩ ꞌdĩ la dó Ãngũ Ãlá rĩ kí awa Ãngũ Ãlá Ãndânĩ rĩ be. ");
INSERT INTO luc_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Mí ụ̃pị̃ dó Sãndụ́kụ̃ tị icíma drị̂ tị úmvúke ásị́ ị̃gbẹ̃ drị̂ sĩ cí Ãngũ Ãlá Ãndânĩ rĩ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Íꞌbã dó méjã ãmvélé ãmvélé ru ꞌbã adru sĩ kátẽnĩ agá ku. Íꞌbã ĩꞌdi Hémã sĩ áma ị̃nzị̃jó rĩ ꞌbã wókõ ụ́rụ́lé rĩ gá ãzíla íꞌbã tárã céke ꞌbã ndre kí ru wókõ la ándrá rĩ be. ");
INSERT INTO luc_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Kẹ̃jị́ sĩ fijó Hémã ꞌdĩ agâlé rĩ gá, mí idé kátẽnĩ uꞌbélé wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika sĩ la kí ꞌbá bõngó cãlépi rĩ ꞌbã cã kí ĩꞌdi ãlị̃gọ̃ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Mí idé gõlĩ gólũdĩ sĩ rĩ kí kátẽnĩ ꞌdĩ nî ãzíla ị́dị́ŋá báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ ꞌbulé gólũdĩ sĩ cí la kí tõwú. Mí idé ãko ị̃ndụ́ la ꞌbãjó vũ gá rĩ kí tõwú bũrônzĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Úpí jọ Mụ́sã ní, “Ípa ãlĩtárĩ báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ, ꞌbã adru trũ-trũ ãzo la ꞌbã adru mítã ị̃rị̃, mgbọ la mítã ị̃rị̃, ãzo la ụrụgâlé ru rĩ mítã ãlu. ");
INSERT INTO luc_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Mí upa újéke la kí kónã la sụ ꞌdĩ kí gâsĩ pírí, ãlĩtárĩ kí újéke la abe mí upa kí ife ãlu la ụrụꞌbá gá, ãzíla íꞌbu ụrụꞌbá la bũrônzĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Mí idé úmvú sĩ úfóró iyájó, ãko sĩ ãko ũpẽjó, bãkụ́lẹ̃ sĩ ãko ũyãjó, fókĩ ãmbógó sĩ ĩzá ũsõjó ãzíla sũfũríyã sĩ ãko ụsịjó ãcí drị̃ gá rĩ abe pírí bũrônzĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Mí idé ĩꞌdiní kẽyĩkéyĩ aya bũrônzĩ rú rĩ sĩ, mí idé ímve kí sụ bũrônzĩ sĩ, sĩ pá la kí icíjó kónã la sụ ꞌdĩ kí gâsĩ. ");
INSERT INTO luc_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Íꞌbã kẽyĩkéyĩ ãlĩtárĩ drị̃ gá ĩꞌdi dó sĩ adru ꞌbụ́ ágágá ãlĩtárĩ agá ꞌdã agá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Mí idé Ãlĩtárĩ ꞌbã ife sĩ ĩꞌdi ꞌdụjó rĩ kí báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ, íꞌbu ụrụꞌbá la kí aya bũrônzĩ rú rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Mí usú ife sĩ ĩꞌdi ujíjó ꞌdĩ kí ímve kí agâ sĩ ãlĩtárĩ ꞌbã wókõ ị̃rị̃ rĩ kí agá sĩ ĩꞌdi ụꞌdụjó. ");
INSERT INTO luc_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Mí idé ãlĩtárĩ ꞌa Sãndụ́kụ̃ áni mgbọ rú ꞌbã lũ iꞌdójó drị̃ la gá kpere ị̃ndụ́ la gá. Mí idé ĩꞌdi cécé mání iꞌdalé míní ꞌbé sị́ gâlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Íce Hémã sĩ áma ị̃nzị̃jó rĩ ꞌbã lị́cọ́ ꞌa andre bõngó ãjẹ̃ rú mịfị́ níríŋá rĩ sĩ. Wókõ la ándrá rĩ ꞌbã zo mítã kãlị́ sụ drị̃ sụ. ");
INSERT INTO luc_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Mí ũgĩ bõngó ꞌdĩ kí gõlĩ sílĩvã rú rĩ sĩ ị́dị́ŋá bũrônzĩ rú kãlị́ ị̃rị̃ usúlé ị̃ndụ́ la bũrônzĩ rú kãlị́ ị̃rị̃ rĩ kí ụrụꞌbá gá. ");
INSERT INTO luc_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Wókõ la ụ́rụ́ rĩ ꞌbã ãzo ꞌbã adru mítã kãlị́sụ drị̃ sụ. Mí ũgĩ bõngó ꞌdĩ kí gõlĩ sílĩvã rú rĩ sĩ ị́dị́ŋá bũrônzĩ rú kãlị́ ị̃rị̃ usúlé ị̃ndụ́ la bũrônzĩ rú kãlị́ ị̃rị̃ rĩ kí ụrụꞌbá gá gõlĩ sílĩvã rú ãzíla ríŋĩ kí sĩ. ");
INSERT INTO luc_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Lị́cọ́ ꞌa ꞌbã wókõ ị̃tụ́ ꞌbã ꞌde agâlé ru rĩ gá, mí ũgĩ bõngó mítã kãlị́ ị̃rị̃ drị̃ ị̃rị̃ rĩ kí, ị́dị́ŋá mụdrị́ usúlé ị̃ndụ́ la mụdrị́ rĩ kí ụrụꞌbá gá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Lị́cọ́ ꞌa ꞌbã wókõ ị̃tụ́ ꞌbã ãfũ agâlé ru rĩ cejó ãzo la ꞌbã adru mítã kãlị́ ị̃rị̃ drị̃ ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ãngũ la sĩ fijó rĩ ꞌbã wókõ ãlu rĩ gá, bõngó gĩlé rĩ ꞌbã ãzo ꞌbã adru ãni rú mítã ázị̂rị̃, ị́dị́ŋá la ꞌbã adru kí na ãzíla ãko idélé sĩ ị́dị́ŋá kí ị̃ndụ́ usújó rĩ ꞌbã adru kí na. ");
INSERT INTO luc_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Bõngó gĩlé ãngũ sĩ fijó rĩ ꞌbã wókõ ãzí rĩ gá rĩ ꞌbã ãzo ꞌbã adru kí ãni rú mítã ázị̂rị̃, ị́dị́ŋá la ꞌbã adru kí na ãzíla ãko idélé sĩ ị́dị́ŋá kí ị̃ndụ́ usújó rĩ ꞌbã adru kí na. ");
INSERT INTO luc_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Kẹ̃jị́ sĩ fijó lị́cọ́ ꞌa gâlé rĩ gá ígĩ bõngó mịfị́ níríŋá mítã úrômĩ ꞌbá bõngó cãlépi rĩ ꞌbã kí cãlé ãlị̃gọ̃ sĩ, uꞌbélé wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika sĩ kátẽnĩ rú rĩ kí ị́dị́ŋá sụ usúlé ãko sĩ kí ị̃ndụ́ usújó sụ rĩ kí agá rĩ kí ụrụꞌbá gá. ");
INSERT INTO luc_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ị́dị́ŋá pírí usúlé sĩ lị́cọ́ ꞌa andre cejó rĩ kí ící kí aya ĩzíŋá sílĩvã rú rĩ kí sĩ ãzíla gõlĩ sĩ bõngó kí ũgĩjó rĩ kí idé kí sílĩvã sĩ, ãko sĩ ị́dị́ŋá kí ị̃ndụ́ usújó rĩ kí ídé kí bũrônzĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ãko Lị́cọ́ ꞌa andre cejó rĩ ꞌbã ãzo la ꞌbã adru mítã kãlị́ sụ drị̃ sụ, mgbọ la ꞌbã adru mítã kãlị́ ị̃rị̃ drị̃ ị̃rị̃ ãzíla ãzo la ụrụgâlé ru rĩ ꞌbã adru mítã ị̃rị̃ dũ ị̃rị̃, bõngó ãjẹ̃ rú mịfị́ níríŋá rĩ sĩ. Ãko sĩ ị́dị́ŋá kí ị̃ndụ́ usújó rĩ kí ídé kí bũrônzĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ãko pírí ayúlé Hémã sĩ áma ị̃nzị̃jó rĩ agá rĩ kí, áló ĩꞌdidrị̂ kí lị́cọ́ ꞌa drị̂ kí abe ídé kí bũrônzĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Úpí jọ Mụ́sã nî, “Mí azị anzị Ịsịrayị́lị̃ drị̂ ꞌbaní ꞌba ají kí ãdu ãlá mị̃zẹ̃yị́tụ̃ drị́ ĩꞌbaní nzilé rĩ ꞌbã ãzí kí tõlé tárã agá ꞌdãá ꞌbã ve sĩ jãꞌdâ. ");
INSERT INTO luc_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ãrọ́nị̃ kí anzị ĩꞌdidrị̂ abe ꞌbã ꞌbã kí tárã tị Hémã tị icíma drị̂ agá ãmvé ãmvélé ru kátẽnĩ Sãndụ́kụ̃ tị icíma drị̂ ꞌbã drị̃lẹ́ gá rĩ gá. Tárã ꞌbã ve Sãndụ́kụ̃ tị icíma drị̂ ꞌbã drị̃lẹ́ gá iꞌdójó ĩndró sĩ kpere ụ̃ꞌbụ́tị gá Úpí drị̃lẹ́ gá. Ị́jọ́ ꞌdĩ la adru ãzị́táŋá ru ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní anzị ĩꞌbadrị́ drị̃lẹ́ gâlé rĩ abe jãꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Úpí jọ Mụ́sã nî, “Mí anzé mí ádrị́pị Ãrọ́nị̃ kí anzị ĩꞌdidrị́ Nãdábũ ꞌi, Ãbị́hụ̃ ꞌi, Ị̃lị̃yãzárị̃ ꞌi ãzíla Ĩtãmárĩ abe ꞌbá Ịsịrayị́lị̃ drị̂ kí agâlé rá. Ị́jọ́ ꞌdĩ sĩ kí dó sĩ ãzị́ nga mání ãtalo rú. ");
INSERT INTO luc_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Mí ịgbẹ mí ádrị́pị Ãrọ́nị̃ ní bõngó ãlá ĩꞌdi ꞌbãlépi ndú ꞌbá kí agá ꞌdâ la kí, ála dó sĩ ĩꞌdiní ị̃nzị̃táŋá fẽ ãrútáŋá be. ");
INSERT INTO luc_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ílũ ꞌbá ãlịgọ rú mání ĩꞌbaní úríndí ũndũwã drị̂ fẽjó ꞌdĩ ꞌbaní pírí ꞌbã ịgbẹ kí Ãrọ́nị̃ ní bõngó sụ̃lé sụ̃sụ̃ rĩ kí cí. Ị́jọ́ ꞌdĩ sĩ ála dó sĩ ĩꞌdi ꞌbã ndú adrujó átáló ru ãzị́ mádrị̂ agá. ");
INSERT INTO luc_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Bõngó ĩꞌbaní mụlé ịgbẹlé rĩ kí: bõngó jụ́jụ́ gá rĩ ꞌi, ĩfódĩ, kọ́tị̃ ãzo rĩ, kánzũ, bõngó sĩ drị̃ umbéjó rĩ ꞌi, ãzíla sẹ́rị̃ ịgbẹlé ũniyambamba rĩ. ꞌBã ịgbẹ kí mí ádrị́pị Ãrọ́nị̃ ní anzị ĩꞌdidrị̂ kí abe bõngó ãlá ꞌdĩ kí, ị́jọ́ ꞌdĩ sĩ kí dó sĩ ãzị́ nga mání átáló rú. ");
INSERT INTO luc_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ꞌBá ãlịgọ rú ꞌdĩ ꞌbã ayú kí gólũdĩ, wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika ãzíla bõngó mịfị́ níríŋá rĩ kî. ");
INSERT INTO luc_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“ꞌBá ãlịgọ rú ꞌdĩ ꞌbã ayú kí wị́zị̃ gólũdĩ rú, wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ ika ãzíla bõngó mịfị́ níríŋá rĩ kí sĩ ĩfódĩ ịgbẹjó, ꞌbã uꞌbé kí ĩꞌdi ãlị̃gọ̃ sĩ ũniyambamba rú. ");
INSERT INTO luc_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Mí idé ĩfódĩ ꞌbã kọ́trọ́ drị̃ gá bõngó ĩbá ꞌbã adru kí ị̃rị̃ sĩ ĩꞌdi icíjó. ");
INSERT INTO luc_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ꞌBá ãlịgọ rú rĩ ꞌbã ayú kí wị́zị̃ gólũdĩ rú, wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ, ika ãzíla bõngó mịfị́ níríŋá rĩ kí sĩ sẹ́rị̃ cãjó, sẹ́rị̃ kí ĩfódĩ be ꞌbã adru kí ãlu. ");
INSERT INTO luc_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Mí aꞌdụ́ írã únĩkĩsĩ rú la kí ị̃rị̃, ísĩ anzị Ịsịrayị́lị̃ drị̂ kí rụ́ drị̃ la gá. ");
INSERT INTO luc_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ísĩ rụ́ ázíyá rĩ kí írã ãlu rĩ drị̃ gá ãzíla ázíyá acelépi rĩ kí írã ãzí rĩ drị̃ gá tịŋá ĩꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ꞌBã sĩ rụ́ anzị Ịsịrayị́lị̃ drị̂ ꞌbadrị̂ kí ãlị̃gọ̃ sĩ írã ị̃rị̃ ãjẹ̃ rú rĩ kí drị̃ gá ãzíla ꞌbã usú írã ꞌdĩ kí gólũdĩ kí rụlépi cí rĩ agá. ");
INSERT INTO luc_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Mí ịgbẹ kí bõngó ĩbá ĩfódĩ ꞌbã kọ́trọ́ gá rĩ drị̃ gá. Gẹ̃rị̃ ꞌdĩ sĩ Ãrọ́nị̃ la dó sĩ rụ́ ꞌdĩ kí ꞌdụ ĩꞌdi ꞌbã kọ́trọ́ gá. Ị́jọ́ ꞌdĩ sĩ ma, Úpí ꞌi ma dó sĩ anzị Ịsịrayị́lị̃ drị̂ kí ị́jọ́ igá. ");
INSERT INTO luc_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ícã ĩbáká gólũdĩ rú la kí ru ĩkpãlépi ");
INSERT INTO luc_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ãzíla ru icílépi nõrórõ idélé gólũdĩ ãlá la sĩ ị̃rị̃ ĩbáká áni la, ãngũ ĩꞌbã kí ru icójó ĩkpãjó rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Úpí jọ Mụ́sã ní, “Mí ịgbẹ átáló ãmbógó ãndânĩ rĩ ní bõngó jụ́jụ́ gá dị̃lépi lẽrẽlẽrẽ cécé ĩfódĩ áni rĩ sĩ ị́jọ́ amájó Ãdróŋá ꞌbã lẽlé rĩ áni. Mí ayú wị́zị̃ gólũdĩ rú, wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ, ika ãzíla bõngó mịfị́ níríŋá rĩ kí sĩ ĩꞌdi ịgbẹjó drị́mvụ́ ãlị́gọ́ drị̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ãzo la kí mgbọ la abe ꞌbã adru kí trũ-trũ ágbọ́ ĩꞌdi ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ꞌDã ꞌbã vúlé gá mí ũꞌbã ụrụꞌbá la gá írã pãrã-pãrã la kí láyĩnĩ sĩ sụ. Láyĩnĩ la iꞌdójó rĩ ꞌbã adru írã rụ́bị̃, tõpázĩ, ãzíla ĩmẽrálĩdĩ ru rĩ kî; ");
INSERT INTO luc_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","láyĩnĩ ị̃rị̃ rĩ gá írã tãkụ́sẹ̃ rú, sãfírẽ rú, ãzíla dáyímõndĩ rú rĩ kî; ");
INSERT INTO luc_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","láyĩnĩ na rĩ gá írã jãsị̃nị́tọ̃ rú, írã ágãtẽ rú, ãzíla írã ãmẹ̃tẹ̃sị́tọ̃ rú rĩ kî; ");
INSERT INTO luc_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","láyĩnĩ sụ rĩ gá írã kụ̃rị̃sị̃lị́tọ̃ rú, írã únĩkĩsĩ rú ãzíla írã yãsípẽ rú rĩ kî. Írã ꞌdĩ kí ûtị̃ kí gólũdĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Írã ꞌbã adru kí mụdrị́ drị̃ ị̃rị̃, írã ãlu-ãlu drị̃ gá úsĩ anzị Ịsịrayị́lị̃ drị̂ kí rụ́, úsĩ rụ́ ꞌdã kí pá tujó ínátị mụdrị́ drị̃ ị̃rị̃ ꞌdĩ kí kẹ̃jị́ gá. ");
INSERT INTO luc_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Bõngó jụ́jụ́ gá rĩ ní mí idé nõrórõ cécé ĩbáká áni la gólũdĩ ãlá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Mí idé ríŋĩ gólũdĩ sĩ la kí ị̃rị̃ ãzíla ígĩ kí bõngó jụ́jụ́ gá rĩ ꞌbã kónã ị̃rị̃ la kí gá. ");
INSERT INTO luc_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Mí ũgĩ ĩbáká nõrórõ gólũdĩ rú ị̃rị̃ ꞌdĩ kí ríŋĩ kí agá bõngó jụ́jụ́ gá rĩ ꞌbã kónã kí gá. ");
INSERT INTO luc_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ĩbáká nõrórõ gólũdĩ rú ꞌdĩ ꞌbã tị kí gá ígĩ ĩfódĩ ꞌbã ĩbáká kọ́trọ́ gá rĩ kí drị̃lẹ́ gâlé ru. ");
INSERT INTO luc_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Mí idé ríŋĩ gólũdĩ sĩ la kí ị̃rị̃ ãzíla mí ũgĩ kí bõngó jụ́jụ́ gá rĩ ꞌbã kónã la ị̃rị̃ rĩ kí tị gá agâlé ru ĩfódĩ rụ̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Mí idé vâ ríŋĩ gólũdĩ sĩ la kí ãzí ị̃rị̃ mí icí kí bõngó ĩbá ĩfódĩ ꞌbã kọ́trọ́ gá rĩ ꞌbã ị̃ndụ́lé gá mẹ́lẹ́tị gá ꞌdõlé ru, ãni rú ãngũ ĩꞌbã kí sĩ ru ịsụ́jó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Mí icí ríŋĩ ĩfódĩ drị̂ kí ríŋĩ bõngó jụ́jụ́ gá rĩ ꞌbã ĩbáká bụ̃lụ̂ rĩ sĩ, ãzíla ící kí sẹ́rị̃ ụ́pị́cẹ́ gá rĩ gá, ꞌbã adru rû sĩ mgbemgbe. ");
INSERT INTO luc_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Sáwã Ãrọ́nị̃ ꞌbã fijó Ãngũ Ãlá rĩ agâlé rĩ sĩ, lẽ ꞌbã sụ̃ bõngó jụ́jụ́ gá sĩ rụ́ sụ́rụ́ Ịsịrayị́lị̃ drị́ mụdrị́ drị̃ ị̃rị̃ ꞌdĩ kí sĩjó drị̃ la gá rĩ cí. Ị́jọ́ ꞌdĩ sĩ ma Úpí ꞌi, ma dó sĩ anzị Ịsịrayị́lị̃ drị̂ kí ị́jọ́ igá. ");
INSERT INTO luc_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Lẽ ꞌbã sụ̃ vâ Ụ̃rị́mụ̃ ãzíla Tãmímũ bõngó jụ́jụ́ gá rĩ drị̃ gá, ị́jọ́ ꞌdĩ kí sĩ adru Ãrọ́nị̃ ásị́ drị̃ gá cí ĩꞌdiní fi agá Úpí drị̃lẹ́ gâlé. Ị́jọ́ ꞌdĩ sĩ ĩꞌdi dó sĩ ị́jọ́ mâ lẽlé rĩ pẽ ꞌbá mádrị́ Ịsịrayị́lị̃ drị́ rĩ ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Mí idé kọ́tị̃ ãzo sĩ ĩfódĩ sụ̃jó drị̃ la gá rĩ pírí bõngó bụ̃lụ̂ rĩ sĩ, ");
INSERT INTO luc_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ꞌbã adru ꞌbụ́ trũ ágágá drị̃kã ní sĩ fijó. Tị la ꞌbụ́ ru imbe gá ãzíla drị́ gá ꞌdĩ kí úci kí cĩcĩ kálã gá rĩ áni, ꞌbã uce kí rú sĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Mí uꞌbé tị la gâsĩ ife põmũgũránãtĩ rú rĩ ꞌbã íꞌdá; gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika rú trộkị́lịrị, ũlángí gólũdĩ rú la trũ kí drĩdríŋĩ gá cí. ");
INSERT INTO luc_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Íꞌdá ũlángí idélé gólũdĩ sĩ rĩ drị̂ kí ãzíla ife põmũgũránãtĩ drị̂ kí mí ũꞌbã kí kọ́tị̃ ꞌbã imbe tị gâsĩ trộkị́lịrị. ");
INSERT INTO luc_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ãrọ́nị̃ ꞌbã sụ̃ bõngó ꞌdĩ ꞌi ĩꞌdi ꞌbã ꞌbá kí drị̃ ce agá. Ĩꞌdi ꞌbã fi agá Ãngũ Ãlá rĩ gá Úpí drị̃lẹ́ gâlé ãzíla ãfũ agá ãmvé ꞌdõlé, Ị́jọ́ ꞌdĩ sĩ, icó dó sĩ drãlé ku. ");
INSERT INTO luc_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Ídị gólũdĩ ãlá rĩ ꞌbara rú ãzíla ísĩ drị̃ la gá: ÃLÁ RU Úpí NÎ. ");
INSERT INTO luc_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Mí úmbé ĩꞌdi bõngó ĩbáká bụ̃lụ̂ la sĩ, bõngó sĩ drị̃ umbéjó rĩ ꞌbã mẹ́lẹ́tị gâlé ru. ");
INSERT INTO luc_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ãrọ́nị̃ ꞌbã sụ̃ ĩꞌdi ĩꞌdi ꞌbã androko gá, ị́jọ́ ꞌdĩ sĩ, Úpí la dó sĩ ãko pírí ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã kí idélé ídétáŋá ru rĩ kí ãꞌị̃ rá, drĩ kí táni ị́jọ́ iza. ");
INSERT INTO luc_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Ícã bõngó Ãrọ́nị̃ drị́ kánzũ rú rĩ bõngó ãjẹ̃ rú mịfị́ níríŋá rĩ sĩ, bõngó sĩ drị̃ umbéjó rĩ bõngó ãjẹ̃ rú mịfị́ níríŋá rĩ sĩ ãzíla mí uꞌbé Sẹ́rị̃ la ũniyambamba rú. ");
INSERT INTO luc_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Anzị Ãrọ́nị̃ drị̂ ꞌbaní, mí ịgbẹ kánzũ, bõngó sĩ drị̃ umbéjó rĩ ꞌi, ãzíla sẹ́rị̃, ála sĩ ĩꞌbaní ị̃nzị̃táŋá fẽ ãrútáŋá be. ");
INSERT INTO luc_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Mí ụ̃sụ̃ dó Ãrọ́nị̃ kí anzị ĩꞌdidrị̂ abe bõngó ꞌdĩ kí sĩ, mí ũsũ kí ãdu sĩ drị́ tị̃jó kí drị̃ gá ãzíla kí ꞌbãjó ndú. Ítị̃ dó drị́ kí drị̃ gá, ị́jọ́ ꞌdĩ sĩ kí dó sĩ adru ãtalo rú ãzị́ ngalé mánî. ");
INSERT INTO luc_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Mí ịgbẹ pájãmã ꞌbá ꞌdĩ ꞌbaní sĩ ĩꞌbã pílípílí atrịjó, ãzo la ꞌbã adru ụ́pị́cẹ́ gá kpere ị̃lị́ gá. ");
INSERT INTO luc_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Ãrọ́nị̃ kí anzị ĩꞌdidrị̂ abe ꞌbã sụ̃ kí bõngó ꞌdĩ kí ĩꞌbã kí fi agá Hémã tị icíma drị̂ agâlé jõku ãngũ ãlĩtárĩ drị̂ gâlé ãzị́ ngajó Ãngũ Ãlá rĩ gá, ị́jọ́ ꞌdĩ ꞌbã adru rú sĩ ĩꞌbaní ị́jọ́ ũnzí ru ãzíla drã rú ku. “ꞌDĩ la adru ãzị́táŋá ru Ãrọ́nị̃ ní anzị ĩꞌdidrị́ drị̃lẹ́ gâlé rĩ abe jãꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Úpí jọ Mụ́sã nî, “ꞌDĩ kí ị́jọ́ míní mụlé idélé sĩ Ãrọ́nị̃ kí ꞌbãjó ndú anzị abe ãtalo rú rĩ kî: Mí aꞌdụ́ mọ́nị̃gọ́ ãlu mũlũkũdũ la kãbĩlógó ị̃rị̃ bị́lẹ́mị kóru la kí abe. ");
INSERT INTO luc_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Mí idé mũkátĩ ãnáfóró ngánũ drị́ mĩnãmĩnã ãkụ́kị́ kóru rĩ sĩ, mũkátĩ mvụtụ rĩ, kékĩ usalé ãdu sĩ rĩ, mũkátĩ níríŋá aselé ãdu sĩ rĩ. ");
INSERT INTO luc_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Íꞌbã kí gụ́fá agá, mí ají kí mọ́nị̃gọ́ ãzíla kãbĩlõ ị̃rị̃ ꞌdã abe ídétáŋá ru mánî. ");
INSERT INTO luc_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ꞌDã ꞌbã ũngúkú gá, mí ají dó Ãrọ́nị̃ kí anzị ĩꞌdidrị̂ kí abe kẹ̃jị́tị sĩ fijó Hémã tị icíma drị̂ agá rĩ gá ãzíla mí ũjĩ dó kí ị̃yị́ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Mí ụ̃sụ̃ dó bõngó ꞌdĩ kí Ãrọ́nị̃ ụrụꞌbá gá, kánzũ, kọ́tị̃, ĩfódĩ, bõngó jụ́jụ́ gá rĩ ãzíla sẹ́rị̃. Mí icí ĩꞌdi ĩfódĩ ụrụꞌbá gá sẹ́rị̃ cãlé ãlị̃gọ̃ sĩ rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Mí umbé drị̃kã la bõngó sĩ drị̃ umbéjó rĩ sĩ, mí icí gólũdĩ ãlá dịlé ꞌbara sĩ drị̃ la gá sĩjó la ÃLÁ RU ÃDRÓŊÁ NÎ rĩ. ");
INSERT INTO luc_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Mí ũsũ ãdu drị́ tị̃jó ꞌbá drị̃ gá rĩ sĩ ĩꞌdiní ũkpõ fẽjó. ");
INSERT INTO luc_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Mí ụ̃sụ̃ ngọ́pịka kí kánzũ ĩꞌbadrị́ ãtalo ꞌbadrị̂ kí sĩ ");
INSERT INTO luc_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ãzíla mí umbé kí drị̃ gá bõngó sĩ drị̃ umbéjó rĩ cí. ꞌDã ꞌbã ũngúkú gá, mí úmbé dó Ãrọ́nị̃ kí ụ́pị́cẹ́ ngọ́pịka kí abe sẹ́rị̃ sĩ. Ị́jọ́ ĩꞌbaní adrujó ãtalo rú rĩ úꞌbã ĩꞌdi ãzị́táŋá ru jãꞌdâ. Gẹ̃rị̃ ꞌdĩ sĩ mi dó Ãrọ́nị̃ kí ꞌbã ndú ngọ́pịka abe. ");
INSERT INTO luc_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Mí ají mọ́nị̃gọ́ Hémã tị icíma drị̂ ꞌbã drị̃lẹ́ gá, ãzíla Ãrọ́nị̃ kí ngọ́pịka abe ꞌbã ụ̃tị̃ kí drị́ drị̃ la gá. ");
INSERT INTO luc_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ílị ĩꞌdi Úpí drị̃lẹ́ gá kẹ̃jị́tị sĩ fijó Hémã tị icíma drị̂ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Mí ãbĩ mọ́nị̃gộ ꞌbã ãrí ãzí, mí ũꞌbã ĩꞌdi ãlĩtárĩ ꞌbã újé sụ rĩ kí agá tĩndrímváŋá sĩ ãzíla ị́mbị́ la acelépi rĩ mí ũsũ ĩꞌdi ãlĩtárĩ ị̃ndụ́ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ꞌDã ꞌbã ũngúkú gá, úsã ãko agá rĩ kí akulépi rĩ kí mí anzé kí rá, úgú gá rĩ abe, rókójí úsã ala gá rĩ abe, mí ivé kí ãlĩtárĩ drị̃ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Wó mí ivé mọ́nị̃gọ́ ꞌbã ĩzá íníríkó la abe ífí la kí abe ãngũ ꞌbá ꞌbã kí sĩ uꞌájó rĩ gá ãmvé-ãmvélé ru. ꞌDĩ ídétáŋá sĩ ị́jọ́ ũnzí ãtalo ꞌbadrị̂ kí idéjó rĩ. ");
INSERT INTO luc_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Mí aꞌdụ́ kãbĩlógó ãzí ãlu rĩ, Ãrọ́nị̃ kí ngọ́pịka abe ꞌbã ụ̃tị̃ kí drị́ drị̃ la gá. ");
INSERT INTO luc_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ílị ĩꞌdi ãzíla mí ũyã ãrí la ãngũ ãlĩtárĩ drị̂ ꞌbã wókõ kí agâ sĩ pírí. ");
INSERT INTO luc_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Mí ụlị́ ĩzá kãbĩlógô drị̂ ndú-ndú ãzíla mí ũjĩ ífí la kí ĩzá la pá gá rĩ kí abe, íꞌbã kí drị̃kã abe ĩzá ị́mbị́ acelépi ꞌdĩ abe ãlĩtárĩ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ꞌDã ꞌbã ũngúkú gá, mí ivé dó ĩzá kãbĩlógô drị̂ pírí ãlĩtárĩ drị̃ gá ꞌdãá. Ĩꞌdi ídétáŋá ivélé ivê Úpí ní ngụ̃lépi vĩrĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Mí aꞌdụ́ kãbĩlógó ãzí rĩ ꞌi, Ãrọ́nị̃ ꞌbã tị̃ kí drị́ drị̃ la gá ngọ́pịka abe. ");
INSERT INTO luc_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ílị ĩꞌdĩ ãzíla mí ãbĩ ãrí la ꞌbã ãzí, íꞌbã ĩꞌdi Ãrọ́nị̃ ꞌbã bị́lẹ́ drị̃lẹ́ ãndá gá rĩ gá ãzíla ngọ́pịka kí ꞌbã bị́lẹ́ drị̃lẹ́ ãndá gá rĩ kí gá, drị́ ágó ãndá gá rĩ kí gá, ĩꞌbã pá ágó ãndá gá rĩ kí gá. ꞌDã ꞌbã ũngúkú gá, mí ũyã dó ãrí la ꞌbã ãzí rĩ ãlĩtárĩ ꞌbã wókõ kí agâ sĩ pírí. ");
INSERT INTO luc_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Íꞌdụ ãrí ãlĩtárĩ gá ꞌdãá rĩ ꞌbã ãzí ãdu drị́ tị̃jó ꞌbá drị̃ gá rĩ abe ãzíla mí ũyã ĩꞌdi Ãrọ́nị̃ ụrụꞌbá gá bõngó ĩꞌdidrị̂ kí abe ãzíla ngọ́pịka kí ụrụꞌbá gá bõngó ĩꞌbadrị̂ kí abe. Ãrọ́nị̃ kí ngọ́pịka abe ãzíla bõngó ĩꞌbadrị̂ kí abe ála dó sĩ kí ꞌbã ndú mánî. ");
INSERT INTO luc_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Kãbĩlógó ꞌdĩ rụ́ ꞌdâ mí alị́ úsã ãko agá rĩ kí akulépi rĩ kí, úsã kótẽ gá rĩ, úsã la úgú drị̃ gá rĩ abe, rókójí kí úsã ala gá rĩ abe, ãzíla ị̃lị́ la pá ãndá gá rĩ abe. ꞌDĩ kãbĩlógó sĩ drị́ tị̃jó kí drị̃ gá rĩ. ");
INSERT INTO luc_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Angájó gụ́fá mũkátĩ ãkụ́kị́ kóru ꞌbãlé Úpí drị̃lẹ́ gá rĩ kí agá, mí aꞌdụ́ mũkátĩ ãkụ́kị́ kóru mvụtụ rĩ ãlu, kékĩ idélé ãdu sĩ rĩ ãzíla mũkátĩ níríŋá aselé ãdu sĩ rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Íꞌbã ãko ꞌdĩ kí pírí Ãrọ́nị̃ kí drị́ gá ngọ́pịka abe ãzíla ílũ ĩꞌbaní ꞌbã inga kí ãko ꞌdĩ kí fẽlé Úpí ní ídétáŋá ru. ");
INSERT INTO luc_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ꞌDã ꞌbã ũngúkú gá, mí aꞌdụ́ ãkónã ídétáŋá ru ꞌdĩ kí ꞌbá ꞌdĩ kí drị́ gá ꞌdâ rá, mí ivé kí ãlĩtárĩ drị̃ gá ꞌdãá, ídétáŋá ivélé ivê ãjị́ ngụ̃lépi vĩrĩ rĩ ꞌbã drị̃ gá sĩ ãyĩkõ fẽjó Úpí nî. ");
INSERT INTO luc_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Íꞌdụ kãbĩlógó sĩ drị́ tị̃jó Ãrọ́nị̃ drị̃ gá rĩ ꞌbã jụ́jụ́tị ãzíla mí inga ĩꞌdi Úpí ní ídétáŋá ru. ꞌDĩ wókõ mídrị́ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Ĩzá drị́ tị̃jó Ãrọ́nị̃ kí drị̃ gá ngọ́pịka abe rĩ íꞌbã kí ndú: jụ́jụ́tị ãzíla pá ãndá gá rĩ abe ingalé ídétáŋá ru mání rĩ kí ála kí ꞌbã ndú ãtalo ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ị́jọ́ ꞌdĩ kí mání lẽlé anzị Ịsịrayị́lị̃ drị̂ ꞌbã nga kí kí sáwã drị́ tị̃jó ãtalo kí drị̃ gá rĩ sĩ rĩ kî: Ĩzá jụ́jụ́tị gá ãzíla pá ãndá gá rĩ kí wókõ fẽtáŋá ru Ãrọ́nị̃ ꞌbaní anzị ĩꞌdidrị̂ abe jãꞌdâ rĩ kî. ꞌDĩ kí ídétáŋá anzị Ịsịrayị́lị̃ drị̂ ꞌbã kí fẽlé Úpí ní rĩ kî. ");
INSERT INTO luc_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Ãrọ́nị̃ drĩ drã rá bõngó ãlá ĩꞌdidrị́ átáló drị̂ kí ála kí ꞌdụ fẽlé anzị ĩꞌdidrị̂ ꞌbanî, ị́jọ́ ꞌdĩ sĩ ála dó sĩ ãdu ũsũ kí drị̃ gá ãzíla drị́ tị̃ kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ngọ́tị́ŋá acálépi átáló ru ĩꞌdi kẹ̃jị́ gá rĩ ní úsụ̃ bõngó ꞌdĩ kí ụ́ꞌdụ́ ázị̂rị̃ ĩꞌdi dó sĩ mụ Hémã tị icíma drị̂ agâlé sĩ mụjó ãzị́ ngajó Ãngũ Ãlá rĩ gâlé nĩ. ");
INSERT INTO luc_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Íꞌdụ kãbĩlógó sĩ drị́ tị̃jó ꞌbã drị̃ gá rĩ ꞌbã ĩzá ãzíla mí aꞌdí ĩꞌdi ãngũ ãlá rĩ agá. ");
INSERT INTO luc_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ãrọ́nị̃ kí ngọ́pịka abe ꞌbã na kí kãbĩlógô ĩzá ãzíla mũkátĩ gụ́fá agá rĩ abe kẹ̃jị́tị sĩ fijó Hémã tị icíma drị̂ ꞌbã tị gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ꞌBã na kí ídétáŋá sĩ ị́jọ́ ũnzí ĩꞌbadrị̂ kí idéjó ayúlé sáwã ꞌbání drị́ tị̃jó kí drị̃ gá rĩ nĩ. Wó ꞌbá ãzí ndú la ꞌbã na ku, ãꞌdusĩku kí dó ãlá ru. ");
INSERT INTO luc_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ĩzá kãbĩlógô drị́ sĩ drị́ tị̃jó rĩ ꞌbã ị́mbị́ jõku mũkátĩ cí rĩ drị̃ ace kpere ụ̃ꞌbụ́tị gá cí, mí ivé ĩꞌdi rá. Lẽ úna ĩꞌdi ku, ãꞌdusĩku ĩꞌdi ãlá ru. ");
INSERT INTO luc_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Mí idé Ãrọ́nị̃ ꞌbaní ngọ́pịka abe ị́jọ́ pírí mání azịlé ꞌdĩ kí ꞌbã ꞌdụ kí ụ́ꞌdụ́ ázị̂rị̃ ála dó sĩ drị́ tị̃ kí drị̃ gá ĩndõ. ");
INSERT INTO luc_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ụ́ꞌdụ́ ãlu-ãlu sĩ, ílị mọ́nị̃gọ́ ãlu ídétáŋá sĩ ị́jọ́ ũnzí idéjó rĩ idéjó, mí ũsũ ãdu Mị̃zẹ̃yị́tụ̃ drị̂ ãlĩtárĩ drị̃ gá sĩ ĩꞌdi ꞌbãjó ndú ãlá ru. ");
INSERT INTO luc_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Mí idé ídétáŋá ãlĩtárĩ ꞌbãjó ãlá ru rĩ ụ́ꞌdụ́ ázị̂rị̃ sĩ ĩꞌdi ꞌbãjó ndú. Ị́jọ́ ꞌdĩ sĩ ãlĩtárĩ dó sĩ ndẽ ãlãpĩtĩ sĩ rá, ãzíla ãko ĩꞌdi ụrụꞌbá alólépi rĩ la adru ãlá ru. ");
INSERT INTO luc_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Ụ́ꞌdụ́ ãlu-ãlu sĩ mi mụ kãbĩlõ mũlũkũdũ calépi ílí ãlu ꞌbo la kí fẽlé ị̃rị̃ ídétáŋá ru ãlĩtárĩ drị̃ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Mí idé kãbĩlõ ãlu rĩ ídétáŋá ru ụ̃ꞌbụ́tị sĩ ãzí ãlu rĩ ĩndró sĩ. ");
INSERT INTO luc_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Míní Kãbĩlõ mũlũkũdũ drị̃drị̃ rĩ fẽ agá ídétáŋá ru, mí ayú ãnáfóró kị́lọ̃ ãlu usalé ãdu Mị̃zẹ̃yị́tụ̃ drị̂ sĩ rĩ ãni rú lítã ị̃rị̃. Ísũ wáyĩnĩ lítã ãlu rĩ fẽtáŋá ãko mvụlé mvụ-mvụ̃ rĩ rú. ");
INSERT INTO luc_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Kãbĩlõ ãzí rĩ míní ĩꞌdi fẽ agá ídétáŋá ru ĩndró sĩ, mí ayú vâ ãnáfóró kị́lọ̃ ãlu usalé ãdu Mị̃zẹ̃yị́tụ̃ drị̂ sĩ rĩ ãni rú lítã ị̃rị̃. Ísũ wáyĩnĩ lítã ãlu rĩ fẽtáŋá ãko mvụlé mvụ-mvụ̃ rĩ rú. ꞌDĩ kí ãkónã fẽlé Úpí ní ídétáŋá ãjị́ ngụ̃lépi vĩrĩ ĩꞌdiní sĩ uꞌájó ãyĩkõ sĩ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Ĩmi idé ídétáŋá ivélé ivê ꞌdĩ ãzị́táŋá ru anzị ĩmidrị́ drị̃lẹ́ gâlé rĩ ꞌbaní ụ́ꞌdụ́ pírí sĩ Hémã tị icíma drị̂ ꞌbã tị gá Úpí drị̃lẹ́ gá ꞌdãá. ꞌDã ãngũ mání sĩ drị̃ ụfụjó mí be ãzíla ị́jọ́ jọjó míní rĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ma drị̃ ụfụ anzị Ịsịrayị́lị̃ drị̂ abe ꞌdãá, ãzíla ma ãngũ ꞌdã ꞌbã ãlá ru dị̃zã mádrị́ dị̃lépi rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Ị́jọ́ ꞌdĩ sĩ ma dó sĩ Hémã tị icíma drị̂ kí ꞌbã ãlĩtárĩ be ndú, Ãrọ́nị̃ kí ngọ́pịka abe ma kí ꞌbã ndú adrujó ãtalo rú ãzị́ mádrị̂ ngajó. ");
INSERT INTO luc_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ꞌDã ꞌbã ũngúkú gá, ma uꞌá anzị Ịsịrayị́lị̃ drị̂ kí drĩdríŋĩ gá ãzíla ma adru Ãdróŋá ĩꞌbadrị̂ rú. ");
INSERT INTO luc_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Kí dó sĩ nị̃ la rá ma Úpí Ãdróŋá ĩꞌbadrị́ kí anzélépi angájó Mị̃sị́rị̃ gâlé rĩ ꞌi, ma dó mụ uꞌálé kí drĩdríŋĩ gá. Ma dó sĩ adru Úpí ĩꞌbadrị̂ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Úpí jọ Mụ́sã nî, “Mí idé ãlĩtárĩ sĩ lũbánĩ ãjị́ ngụ̃lépi vĩrĩ rĩ ivéjó rĩ drị̂ báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ãzo la kí mgbọ la be ꞌbã adru kí trũ-trũ ãni rú nụ̃sụ̃ mítã ãzíla ãzo la ụrụgâlé ru rĩ ꞌbã adru ãni rú mítã ãlu. Újé la kónã sụ ꞌdĩ kí gá rĩ ꞌbã icí kí ru ĩꞌdi be ãko ãlu rú. ");
INSERT INTO luc_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Íꞌbu drị̃ la, bụ́lụ́ la, ãzíla újé la kí abe pírí gólũdĩ ãlá la sĩ, íli tị la gólũdĩ sĩ trộkị́lịrị cí. ");
INSERT INTO luc_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Mí idé ímve gólũdĩ sĩ la kí ị̃rị̃ láyĩnĩ ũnĩ ãni ulílé gólũdĩ sĩ trộkị́lịrị rĩ ꞌbã ị̃ndụ́lẹ́ gâlé ru ꞌbã ndre kí ru ãzí rĩ kí abe. Ímve ị̃rị̃ rĩ ꞌbã adru kí bụ́lụ́ ãzí rĩ gá, ãzí ị̃rị̃ rĩ ꞌbã adru kí bụ́lụ́ ãzí rĩ gá sĩ ife sĩ ãlĩtárĩ ujíjó rĩ rụjó. ");
INSERT INTO luc_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Mí idé ife sĩ ĩꞌdi ujíjó rĩ kí báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ ãzíla íꞌbu ụrụꞌbá la kí gólũdĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Íꞌbã ãlĩtárĩ ꞌdĩ ãmvé-ãmvélé ru kátẽnĩ Sãndụ́kụ̃ tị icíma drị̂ aꞌbólépi rĩ be úmvúke ásị́ ị̃gbẹ̃ drị̂ drị̃lẹ́ gá. ꞌDĩ dó ãngũ mání sĩ drị̃ ụfụjó mí be rĩ. ");
INSERT INTO luc_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Ãrọ́nị̃ ꞌbã ivé lũbánĩ ãjị́ ngụ̃lépi vĩrĩ rĩ ãngũ ãlĩtárĩ drị̂ gá ụ̃ꞌbụ́tị ãlu-ãlu sĩ ĩꞌdi ꞌbã tárã kí tị ũꞌbã agá. ");
INSERT INTO luc_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Lẽ ꞌbã ivé ãko ãjị́ ngụ̃lépi vĩrĩ rĩ ị̃dị́ drĩ dó tárã kí tị ũꞌbã ĩndró sĩ ꞌbo rĩ gá. Ị́jọ́ ꞌdĩ sĩ, lũbánĩ ãjị́ ngụ̃lépi vĩrĩ velépi rĩ kí dó sĩ ve ụ́ꞌdụ́ pírí Úpí drị̃lẹ́ gá anzị ĩmidrị́ drị̃lẹ́ gâlé rĩ abe jãꞌdâ. ");
INSERT INTO luc_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ãlĩtárĩ ꞌdĩ drị̃ gá mí ivé lũbánĩ ãzí lẽlé ku la ku jõku ãnãkpá ídétáŋá ru, jõku ãnáfóró ídétáŋá ru ãzíla mí ũsũ wáyĩnĩ ídétáŋá ru rĩ drị̃ la gá ku. ");
INSERT INTO luc_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ílí ãlu agá Ãrọ́nị̃ ꞌbã idé ídétáŋá sĩ ãlĩtárĩ ꞌbãjó ãlá ru rĩ pâlé ãlu. ꞌBã ꞌbã újé la sụ ꞌdã kí agá ãnãkpá lịlẹ́ sĩ ídétáŋá ị́jọ́ ũnzí idé jó rĩ ꞌbã ãrí. Lẽ ꞌbã idé ị́jọ́ ꞌdĩ ílí ãlu-ãlu sĩ anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbanî. Ãlĩtárĩ ꞌdĩ ãlá ãndânĩ Úpí nî rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, ");
INSERT INTO luc_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Míní anzị Ịsịrayị́lị̃ drị̂ kí lã agá, ꞌbá ãlu-ãlu ꞌbã fẽ Úpí ní ãko lịlẹ́ ĩꞌdi drị̃ gá sĩ ídri ĩꞌdidrị́ gá rĩ unzejó rĩ sáwã ĩꞌdi lãjó rĩ sĩ. Ị́jọ́ ꞌdĩ sĩ jụ́wẹ̃ icó dó sĩ kí rụlé ku. ");
INSERT INTO luc_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ꞌBá ãlu-ãlu lãlé rá rĩ lẽ ꞌbã fẽ séndẽ aꞌị́lé rĩ fẽtáŋá ãlá rĩ ru Úpí nî. Séndẽ ꞌdĩ ĩꞌdi nụ́sụ̃ sẹ̃kẹ́lị̃ drị̂ ãko jó Ãdróŋá drị̂ agá rĩ kí ụ̃ꞌbị̃jó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ꞌBá pírí rụ́ sĩlé rá ílí trũ kãlị́ ị̃rị̃ jõku ꞌdĩ drị̃lẹ́ gá rĩ ꞌbã fẽ kí séndẽ ꞌdĩ fẽtáŋá ru Úpí ní rá. ");
INSERT INTO luc_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ꞌBá málĩ trũ rĩ ꞌbã fẽ kí ꞌbã alị séndẽ aꞌị́lé ꞌdã ku, ꞌbá lẽmẽrí rĩ ꞌbã fẽ kí vâ vúlé dọ́dọ́ ku ĩꞌbaní fẽtáŋá ꞌdĩ fẽ agá Úpí ní ídétáŋá ru sĩ ídri ĩꞌbadrị̂ unzejó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Mí atrá séndẽ sĩ ídétáŋá idéjó ꞌdĩ anzị Ịsịrayị́lị̃ drị̂ ꞌbadrị́ sĩ ãzị́ Hémã tị icíma drị̂ kí ngajó. Ĩꞌdi adru anzị Ịsịrayị́lị̃ drị̂ ꞌbaní sĩ ị́jọ́ ũrãjó Úpí drị̃ gá, sĩ kí ídri tã mbajó.” ");
INSERT INTO luc_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, ");
INSERT INTO luc_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Mí idé báfũ sĩ ru drị́ kí ũjĩjó pá abe la bũrônzĩ sĩ ãzíla pá la sĩ ĩꞌdi ꞌbãjó drị̃ la gá rĩ ꞌbã adru kí vâ bũrônzĩ sĩ. Íꞌbã ĩꞌdi ị̃yị́ trũ drĩdríŋĩ Hémã tị icíma drị̂ ꞌbadrị́ ãlĩtárĩ be rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ị̃yị́ ala gá rĩ Ãrọ́nị̃ ꞌbã ayú kí ĩꞌdi ngọ́pịka abe sĩ ĩꞌbã pá kí ũjĩjó drị́ abe. ");
INSERT INTO luc_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ĩꞌbaní fi agá Hémã tị icíma drị̂ agâlé rĩ gá, ꞌbã ũjĩ kí ru pá kí drị́ abe ị̃yị́ sĩ ráká, ị́jọ́ ꞌdĩ sĩ icó kí dó sĩ drãlé ku. Ĩꞌbaní mụ agá fẽtáŋá fẽlé Úpí ní ídétáŋá ru ivélé ãcí sĩ rĩ kí fẽ agá ãlĩtárĩ gâlé, ");
INSERT INTO luc_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","lẽ ꞌbã ũjĩ kí ru drị́ kí pá abe ráká ị́jọ́ ꞌdĩ sĩ ꞌbã drã kî sĩ ku. ꞌDĩ la adru Ãrọ́nị̃ ꞌbaní ãzị́táŋá ru anzị ĩꞌbadrị́ drị̃lẹ́ gâlé rĩ abe jãꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, ");
INSERT INTO luc_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Íꞌdụ ãdu ãjị́ ngụ̃lépi vĩrĩ mírã rú ũsũlé ꞌbá drị̃ gá rĩ kị́lọ̃ ázíyá, ãdu sụ́sụ́ ru ãjị́ ngụ̃lépi vĩrĩ rĩ ꞌbã nụ́sụ̃ cajó kị́lọ̃ na, ꞌdĩ páwụ̃dã sínãmõnĩ rú rĩ ꞌi, ãdu kọ́rọ́kọ́rọ́ gá rĩ kí kị́lọ̃ na. ");
INSERT INTO luc_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Kị́lọ̃ ázíyá kásĩyã drị̂ kí ûꞌbị̃ kí ãko úmgbó ụ̃ꞌbị̃jó ꞌbání ãꞌị̃lé rá rĩ sĩ. Íꞌbã ãdu mị̃zẹ̃yị́tụ̃ drị̂ drị̃ la gá lítã sụ. ");
INSERT INTO luc_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Mí idé ãdu ãlá ꞌbãlé ndú sĩ drị́ tị̃jó ꞌbá drị̃ gá ãjị́ ngụ̃lépi vĩrĩ rĩ. ");
INSERT INTO luc_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Mí ayú ãdu sĩ ꞌbá ꞌbã jó ndú ꞌdĩ ꞌi sĩ Hémã tị icíma drị̂ ꞌbãjó ãlá ru, Sãndụ́kụ̃ tị icíma drị̂, ");
INSERT INTO luc_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","méjã ãzíla ãko ayúlé drị̃ la gá rĩ kí abe, tárã céke ãzíla ãko la ĩꞌdidrị̂ kí abe ãzíla ãlĩtárĩ sĩ lũbánĩ ivéjó rĩ, ");
INSERT INTO luc_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ãlĩtárĩ sĩ ídétáŋá ivélé ivê rĩ kí ivéjó rĩ ãzíla ãkójó ala gá rĩ kí abe ãzíla báfũ pá la kí abe. ");
INSERT INTO luc_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Mi kí ꞌbã ndú ị́jọ́ ꞌdĩ sĩ, kí dó sĩ adru ãlá ru ãndânĩ, ãko kí ụrụꞌbá alólépi rĩ kí dó sĩ adru ãlá ru. ");
INSERT INTO luc_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Mí ũsũ ãdu Ãrọ́nị̃ kí drị̃ gá ngọ́pịka abe sĩ kí ꞌbãjó ndú, ítị̃ drị́ kí drị̃ gá kí dó sĩ ãzị́ nga mání ãtalo ru. ");
INSERT INTO luc_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Íjọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, ꞌdĩ la mụ adrulé ãdu mání sĩ ĩmi ꞌbãjó ãlá ru anzị ĩmidrị́ drị̃lẹ́ gâlé rĩ abe jãꞌdâ rĩ. ");
INSERT INTO luc_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Mí ũsũ ãdu ꞌdĩ ꞌbá kí drị̃ gá mị́rị̃ rú ku ãzíla mí idé vâ ãdu ãzí gẹ̃rị̃ míní sĩ ãdu ꞌdĩ idéjó rĩ sĩ ku. Ĩꞌdi ãdu ãzí ꞌbãlé ndú la, lẽ ínị̃ rá ĩꞌdi ãlá ru ndú áꞌdụ̂sĩ. ");
INSERT INTO luc_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ꞌBá ãzí drĩ vâ ãdu ãzí idé gẹ̃rị̃ míní sĩ ãdu ꞌdĩ idéjó rĩ sĩ ãzíla drĩ ũsũ la ꞌbá ãzí nị̃lé ku la drị̃ gá rá ịsụ́ ꞌdĩ sĩ ꞌbá la ꞌdã adru átáló ku yã áni, ma ĩꞌdi nze ꞌbá mádrị̂ kí agá ꞌdâ rá.” ");
INSERT INTO luc_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, “Mí aꞌdụ́ ãko ngụ̃lépi vĩrĩ ꞌdĩ kí trũ-trũ: ísékísé ife ꞌbã ũgórókóꞌbõ gá rĩ, átíríkó ꞌbã úꞌbó, ãzíla gãlũbãnámũ. ");
INSERT INTO luc_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Mí ayú ãko ꞌdĩ kí sĩ lũbánĩ ãjị́ ngụ̃lépi vĩrĩ rĩ kí usajó, mí usa kí acájó ãdu ngụ̃lépi vĩrĩ rĩ rú. Íꞌbã ãꞌị́ ala gá cí ꞌbã iza kí sĩ ru ku ãzíla ꞌbã adru kí vâ sĩ ndú ãzíla ãlá ru. ");
INSERT INTO luc_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Mí amvi ãzí rĩ kí fúfú ru, mí agụ kí ꞌbãlé Hémã tị icíma drị̂ agá Sãndụ́kụ̃ tị icíma drị̂ drị̃lẹ́ gá, ꞌdĩ ãngũ mání sĩ mụjó drị̃ ụfụjó mí be rĩ gá. Ĩꞌdi adru míní ãlá ru ãndânĩ. ");
INSERT INTO luc_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Mí idé lũbánĩ ãzí gẹ̃rị̃ míní sĩ lũbánĩ ãjị́ ngụ̃lépi vĩrĩ rĩ idéjó rĩ sĩ ku. Ĩꞌdi lũbánĩ ꞌbãlé ãlá ru ndú áꞌdụ̂sĩ Úpí nî la. ");
INSERT INTO luc_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ꞌBá ãzí drĩ vâ lũbánĩ ãzí idé gẹ̃rị̃ míní sĩ lũbánĩ ãjị́ ngụ̃lépi vĩrĩ rĩ idéjó rĩ sĩ sĩ ãyĩkõ ịsụ́jó ãjị́ la sĩ, ma ꞌbá ꞌdĩ áni rĩ nze ꞌbá mádrị̂ kí agá ꞌdâ rá.” ");
INSERT INTO luc_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Úpí jọ Mụ́sã nî, ");
INSERT INTO luc_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ápẽ Bẹ̃zãlẹ́lị̃ Ụ́rị̃ ngọ́pị, Hụ́rị̃ umvelépi áyị́pị rĩ angájó sụ́rụ́ Yụ́dã drị̂ gá, ");
INSERT INTO luc_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ãzíla áfẽ ĩꞌdiní úríndí mádrị̂ ꞌi. Áfẽ ĩꞌdiní nị̃táŋá, ãlị̃gọ̃ sĩ icójó ãko pírí kí idéjó, ");
INSERT INTO luc_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ĩꞌdi sĩ íꞌdá gbã ãlị̃gọ̃ sĩ, ãzị́ nga gólũdĩ sĩ, sílĩvã sĩ, ãzíla aya bũrônzĩ rú rĩ sĩ; ");
INSERT INTO luc_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ĩꞌdi ũnĩ ãko ŋálí kî áni ꞌdĩ kí idé, ife kí upa ãzíla agọ́ ũví ndú-ndú sĩ ãzíla ãzị́ pírí ngalé ãlị̃gọ̃ sĩ rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ápẽ vâ Ũhõlĩyábũ Ãhĩsãmákĩ ngọ́pị ꞌi angájó sụ́rụ́ Dánĩ drị̂ agá, kí sĩ ãzị́ nga ĩꞌdi be. Áfẽ vâ ãlị̃gọ̃ ãmbógó la ꞌbá ãlịgọ rú rĩ ꞌbaní, icó kí sĩ ãko mání azịlé míní ídé kî ꞌdĩ kí idélé rá: ");
INSERT INTO luc_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Hémã tị icíma drị̂, Sãndụ́kụ̃ tị icíma drị̂ kí úmvúke ásị́ ị̃gbẹ̃ drị̂ be, ãko pírí Hémã ụ̃sụ̃jó rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","méjã ãzíla ãko ĩꞌdidrị̂ kí abe, tárã céke idélé gólũdĩ ãlá rĩ sĩ ãzíla ãko ĩꞌdidrị̂ kí abe pírí, ãlĩtárĩ sĩ lũbánĩ ivéjó rĩ, ");
INSERT INTO luc_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ãlĩtárĩ sĩ ídétáŋá ivélé ivê rĩ kí ivéjó rĩ ãzíla ãkójó ala gá rĩ kí abe, báfũ drị́ ũjĩjó rĩ kí ãko ị̃ndụ́ la ꞌbãjó rĩ abe, ");
INSERT INTO luc_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","bõngó ũniyambamba ãlá átáló Ãrọ́nị̃ ní ãzíla anzị ĩꞌdidrị̂ abe ĩꞌbaní sụ̃lé ãzị́ átáló drị̂ ngajó rĩ kí, ");
INSERT INTO luc_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ãdu sĩ drị́ tị̃jó ꞌbá drị̃ gá rĩ, ãzíla lũbánĩ ngụ̃lépi vĩrĩ Ãngũ Ãlá rĩ drị̂ gá rĩ trũ. Ãko ꞌdĩ kí idéjó pírí, lẽ ꞌbã idé kí kí cécé mání ãzị́táŋá la fẽjó míní rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Úpí jọ Mụ́sã nî, ");
INSERT INTO luc_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Íjọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, ‘Ĩmba ụ́ꞌdụ́ mádrị́ avị́jó Sãbátũ drị̂ tã, ãꞌdusĩku ĩꞌdi ícétáŋá ãma drĩdríŋĩ gá ĩmi abe ãzíla anzị ĩmidrị́ drị̃lẹ́ gâlé rĩ ꞌbaní pírí rĩ, iꞌdajó la ma Úpí ꞌi, áꞌbã ĩmi ꞌbá mgbã mádrị̂ kî rú. ");
INSERT INTO luc_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Lẽ ĩmba ụ́ꞌdụ́ Sãbátũ drị́ avị́jó ꞌdĩ tã, ãꞌdusĩku ĩꞌdi ãlá ru. ꞌBá ãzí drĩ tã la mba ku, wó drĩ ãzị́ nga ụ́ꞌdụ́ ꞌdã sĩ, lẽ úꞌdị ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ụ́ꞌdụ́ ázíyá ꞌdĩ kí míní sĩ ãzị́ ngajó, wó ụ́ꞌdụ́ ázị̂rị̃ rĩ ĩꞌdi Sãbátũ ụ́ꞌdụ́ míní sĩ avị́jó rĩ ꞌi, ímba tã la ãlá ru Úpí nî. ꞌBá ãzí drĩ ãzị́ ãzí nga ala gá rá, lẽ úꞌdị ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ꞌBá Ịsịrayị́lị̃ drị̂ ꞌbã mba kí ụ́ꞌdụ́ Sãbátũ drị̂ tã ícétáŋá tị icíma drị̂ rú jãꞌdâ. ");
INSERT INTO luc_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ụ́ꞌdụ́ ꞌdĩ ĩꞌdi ícétáŋá ukólépi ku rĩ rú ꞌbá Ịsịrayị́lị̃ drị̂ kí drĩdríŋĩ gá má be, ãꞌdusĩku ma Úpí ꞌi, má idé ꞌbụ̃ kí ụ̃nọ́kụ́ be ụ́ꞌdụ́ ázíyá ãzíla ụ́ꞌdụ́ ázị̂rị̃ rĩ sĩ má aꞌbe ãzị́ ngaŋá dríŋá ãzíla má avị́ dó sĩ áyụ.’” ");
INSERT INTO luc_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ãdróŋá la dó mụ ị́jọ́ delé jọ agá Mụ́sã be ꞌbé Sĩnáyĩ drị̃ gâlé ꞌbo, fẽ dó írã ꞌbara-ꞌbara ị̃rị̃ Ãdróŋá ꞌbã ãzị́táŋá kí sĩjó drị̃ la gá drị́ ĩꞌdidrị̂ sĩ rĩ kí Mụ́sã drị́. ");
INSERT INTO luc_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ꞌBá Ịsịrayị́lị̃ drị̂ kí mụ ndrelé la Mụ́sã uꞌá ꞌbé sị́ gâlé sáwã ãzo rú asị́ vụ̃rụ́ ꞌdõlé ku, atrá kí ru Ãrọ́nị̃ andre gá ãzíla jọ kí, “Ãnị̃ ãꞌdu ị́jọ́ idé ru ágọ́bị́ Mụ́sã ándrá ãma anzélépi Mị̃sị́rị̃ gâlé ꞌdĩ ụrụꞌbá gá nĩ yã rĩ gá ku, mí idé ãmaní ãdróŋá ãzí ꞌbã ce dó sĩ ãma drị̃.” ");
INSERT INTO luc_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ãrọ́nị̃ jọ ĩꞌbanî, “Ĩmi ũtrũ ngílíngílí gólũdĩ rú ũku ĩmidrị́, anzị, ãzíla izonzi ĩmidrị̂ ꞌbã kí sụ̃lé bị́lẹ́ gá ꞌdĩ kí, ĩmi ajị́ kí mádrị́ ꞌdõlé.” ");
INSERT INTO luc_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ị́jọ́ ꞌdĩ sĩ ꞌbá pírí ũtrũ kí ngílíngílí gólũdĩ rú kí bị́lẹ́ gá rĩ kí ãzíla ajị́ kí kí Ãrọ́nị̃ rụ́ ꞌdõlé. ");
INSERT INTO luc_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ꞌDụ dó ngílíngílí gólũdĩ rú ꞌdĩ kí, aká kí ãcí sĩ, ãzíla ũsũ ĩꞌdi umbalé, idé dó ĩꞌdi kãjóŋá ꞌbã íꞌdá rú. ꞌDã ꞌbã ũngúkú gá, ꞌbá jọ kí dó, “Ịsịrayị́lị̃, ꞌdĩ ãdróŋá ĩmidrị́ ándrá ĩmi anzélépi Mị̃sị́rị̃ gâlé rĩ ꞌi!” ");
INSERT INTO luc_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ꞌDã ꞌbã ũngúkú gá, Ãrọ́nị̃ sị dó ãlĩtárĩ kãjóŋá ãdróŋá ru idélé gólũdĩ sĩ rĩ drị̃lẹ́ gá ãzíla uyú dó ị́jọ́ la ꞌbá ꞌbaní, “Drụ̃sị̃ ụ̃mụ̃ la adru ị̃nzị̃táŋá fẽjó Úpí ní cí.” ");
INSERT INTO luc_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ụ́ꞌdụ́ ãzí rĩ sĩ ụ̃ꞌbụ́tịnị́nị́, ꞌbá ajị́ kí ãnãkpá ãzí kí ídétáŋá ivélé ivê rĩ rú ãzíla na kí ãzí rĩ kí ídétáŋá ásị́ ị̃gbẹ̃ drị̂ rú. ꞌBá ri kí vụ̃rụ́ ụ̃mụ̃ nalé, ụ̃mụ̃ uja dó ru íwá mvụjó ãzíla ãwụ̃ ngajó. ");
INSERT INTO luc_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, “Ígõ vúlê lé gbõrú, ãꞌdusĩku ꞌbá mídrị́ Ịsịrayị́lị̃ rú míní ándrá anzélé Mị̃sị́rị̃ gâlé rĩ iza kí ị́jọ́ ꞌbo ãzíla gã kí ma úmgbé. ");
INSERT INTO luc_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Aꞌbe kí gẹ̃rị̃ mání azịlé ꞌbã bĩ kí vú la rĩ rá; idé kí kãjóŋá ãdróŋá ru la gólũdĩ akálé ãcí sĩ rĩ sĩ, ãzíla iꞌdó kí ĩꞌdi ị̃nzị̃lé sĩ ídétáŋá idéjó ĩꞌdi nî. Jọ kí, ‘ꞌDĩ ãdróŋá ĩꞌbadrị́ kí anzélépi Mị̃sị́rị̃ gâlé rĩ ꞌi.’” ");
INSERT INTO luc_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Úpí jọ Mụ́sã ní, “Ánị̃ ꞌbá ꞌdĩ kí ꞌbá drị̃ ũnzí la rĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Álẽ úꞌdîꞌda mí útrị́ ma ku, ũmbã na dó ma ĩꞌbaní rá, ma mụ kí ị̃lị̃kị̃lé rá. Ma ị́jọ́ ꞌdĩ sĩ ími ꞌbã ãzíla drị̃lẹ́ mídrị̂ abe sụ́rụ́ ãmbógó la rú.” ");
INSERT INTO luc_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Wó Mụ́sã ꞌbã mãmálá Úpí Ãdróŋá ĩꞌdidrị̂ rụ́ jọ, “Úpí ũmbã na dó mĩ ꞌbá mídrị̂ ꞌbaní trẹ̃yị́ íni ãꞌdu ị́jọ́ sĩ yã? Ịsụ́ ꞌdĩ sĩ mí anzé kí Mị̃sị́rị̃ gâlé drị́ ũkpó ãzíla ãvẹ̃vị̃ mídrị́ ãmbógó rĩ sĩ mi ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ꞌBá Mị̃sị́rị̃ gá rĩ ꞌbã jọ kí rú vâ sĩ mí anzé ꞌbá ꞌdĩ kí rá, sĩ amụ́jó kí ụꞌdị́jó ꞌbé agá ãzíla kí ị̃lị̃kị̃jó pírí rá yã? Mí aꞌbe drĩ ũmbã ꞌdĩ cã; mí uja drĩ ími ásị́ ãzíla mí ají drĩ lị́kị̃ ꞌbá mídrị̂ kí drị̃ gá ku fô. ");
INSERT INTO luc_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Mí ũrã drĩ ãtíꞌbó mídrị́ Ịbụrahị́mụ̃, Ĩsákã, ãzíla Yãkóꞌbõ kí ꞌbã ị́jọ́. Mí ũrã drĩ ị́jọ́ ándrá míní ũyõ najó mi drị̃lẹ́ kí fẽ ĩꞌbaní ũꞌbíkãnã rú cécé lẽlẽgó ꞌbụ̃ gá ꞌdĩ kí áni, ãzíla anzị ĩꞌbadrị́ drị̃lẹ́ gâlé rĩ ꞌbaní ãngũ ándrá míní azịlé rĩ fẽ ãwítã rú jãꞌdâ rĩ ꞌbã ị́jọ́ fô.” ");
INSERT INTO luc_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ị́jọ́ ꞌdĩ sĩ Úpí uja dó ru ásị́ ãzíla ají dó lị́kị̃ ĩꞌdi ꞌbã lẽlé ajílé ꞌbá ĩꞌdidrị̂ ꞌbaní rĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mụ́sã asị́ dó ꞌbé sị́ gâlé rĩ sĩ vụ̃rụ́ ꞌdõlé, aꞌdụ́ dó sĩ írã ꞌbara-ꞌbara ị̃rị̃ ãzị́táŋá kí sĩjó drị̃ la gá wókõ la sụ rĩ kí agá pírí rĩ ĩꞌdidrị́ gá ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ãdróŋá ꞌbã mgbãrĩ idé írã ꞌbara-ꞌbara ꞌdã kí nĩ ãzíla sĩ ãzị́táŋá drị̃ la gá rĩ kí ĩꞌdi ꞌbã drị́ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yósũwã lã mụ ꞌbá kí ꞌbã úzáŋá arelé ꞌbo, jọ dó sĩ Mụ́sã ní, “Ma ụ́ꞌdụ́kọ́ ãꞌdị́ ãni la are kámbĩ agâlé ꞌdĩ.” ");
INSERT INTO luc_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mụ́sã umvi, “Ụ́ꞌdụ́kọ́ ꞌdã adru ãꞌdị́ ndẽjó jõku áwáŋá ꞌbá kí ndẽjó rá rĩ ní aꞌụ́jó rĩ áni ku; ĩꞌdi aꞌụ́ ụ́ꞌdụ́kọ́ úngó ngoŋá ãni la rú.” ");
INSERT INTO luc_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mụ́sã la dó mụ acálé ãni rú kámbĩ gá sĩ kãjóŋá ãdróŋá ru ꞌdã ndrejó, ãzíla ꞌbá kí ꞌbã úngó tuŋá ndrelé ꞌbo, ũmbã na ĩꞌdi ũnzí. ꞌBé pá gá ꞌdãá Mụ́sã ꞌbe dó írã ꞌbara-ꞌbara tá ĩꞌdi ꞌbã aꞌdụ́lé ĩꞌdidrị́ gá ĩndĩ ꞌdã kí ãzíla andi kí dó sĩ kpékpé rá. ");
INSERT INTO luc_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ꞌDụ kãjóŋá ãdróŋá ru ĩꞌbaní idélé rĩ ꞌi, aká ĩꞌdi ãcí sĩ, ꞌị ĩꞌdi fúfú ru, usa ĩꞌdi ị̃yị́ sĩ. ꞌDã ꞌbã ũngúkú gá, fẽ dó ĩꞌdi ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní mvụlé. ");
INSERT INTO luc_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mụ́sã zị Ãrọ́nị̃ ꞌi, “ꞌBá ꞌdĩ idé kí míní ãꞌdu míní sĩ fẽjó la ĩꞌbaní ị́jọ́ ũnzíkãnã ꞌdĩ idéjó?” ");
INSERT INTO luc_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ãrọ́nị̃ umvi ĩꞌdiní, “Ãmbógó mádrị̂, ũmbã ꞌbã na mi mání ku; ínị̃ cé ꞌbá ꞌdĩ kí bábá ị́jọ́ ũnzí idéjó. ");
INSERT INTO luc_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ꞌBá ꞌdĩ jọ kí mání, ‘Ãnị̃ ãꞌdu ị́jọ́ idé ru ágọ́bị́ Mụ́sã ándrá ãma anzélépi Mị̃sị́rị̃ gâlé ꞌdĩ ụrụꞌbá gá nĩ yã rĩ gá ku, mí idé ãmaní ãdróŋá ãzí ꞌbã ce dó sĩ ãma drị̃.’ ");
INSERT INTO luc_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Má aꞌị́ ĩꞌbadrị́, ngílíngílí gólũdĩ rú rĩ kî ãzíla ꞌbá cí ngílíngílí gólũdĩ rú rĩ trũ rĩ ũtrũ kí dó kí ãfẽlé mádrị́. Áꞌbe dó ngílíngílí ꞌdĩ kí ãcí gá ãzíla ũfũ kí dó kãjóŋá ãdróŋá ru ꞌdĩ rú ꞌdĩ.” ");
INSERT INTO luc_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mụ́sã ndre ị́jọ́ Ãrọ́nị̃ ꞌbã ꞌbá kí aꞌbejó ụtrị́ŋá kóru, ãzíla ĩꞌbaní aza ĩꞌbadrị̂ iꞌdajó mẹ́rọ́ꞌbá ĩꞌbadrị̂ kí drị̃lẹ́ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ị́jọ́ ꞌdĩ sĩ Mụ́sã tu dó pá kẹ̃jị́tị kámbĩ drị̂ gá ãzíla za, “ꞌBá pírí wókõ Úpí drị̂ gá rĩ ꞌba amụ́ kí má rụ́ ꞌdõlé!” Ị́jọ́ ꞌdĩ sĩ ꞌbá Lẹ́vị̃ drị̂ atrá kí ru ĩꞌdi andre gá. ");
INSERT INTO luc_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ꞌDã ꞌbã ũngúkú gá, Mụ́sã jọ ꞌbá Lẹ́vị̃ drị̂ ꞌbanî, “Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ fẽ ãzị́táŋá, ‘Ĩmi ãlu-ãlu ꞌbã aꞌdụ́ ménéŋá ĩꞌdidrị̂ ꞌi ꞌbã su ĩꞌdi nákũrá agá ꞌbã mụ kámbĩ agâ sĩ kẹ̃jị́tị ꞌdĩ gá ꞌdâ kpere ꞌdã gá sĩ ĩmĩ ádrị́pịka kí ãzíla ĩmĩ wọ̃rị́ka kí ụꞌdị́jó jĩránĩ ĩmidrị̂ kí abe.’” ");
INSERT INTO luc_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ꞌBá Lẹ́vị̃ drị̂ are kí Mụ́sã tị rá, ãzíla ụꞌdị́ kí ꞌbá 3,000 ụ́ꞌdụ́ ꞌdã sĩ. ");
INSERT INTO luc_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mụ́sã jọ ꞌbá Lẹ́vị̃ drị̂ ꞌbanî, “Ãndrũ úꞌbã ĩmi ndú ãtalo rú ãzị́ Úpí drị̂ ngajó ĩminí anzị ĩmidrị̂ kí ãzíla ĩmi ádrị́pịka kí ụꞌdị́jó rĩ sĩ, ị́jọ́ ꞌdĩ sĩ wi ĩminí sụ̃sụ́ ĩꞌdidrị́ gá rĩ rá.” ");
INSERT INTO luc_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ụ̃ꞌbụ́tị ãzí rĩ sĩ Mụ́sã jọ ꞌbá ꞌbaní, “Ĩmi iza ị́jọ́ ũnzíkãnã la. Wó ma drĩ mụ tụlé ụrụgá Úpí rụ́ ꞌbé sị́ gâlé ị̃dị́; Ĩꞌdi jõnõ ãꞌị̃ ị́jọ́ ũnzí ĩmidrị̂ kí trũlé rá yã áni.” ");
INSERT INTO luc_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mụ́sã gõ dó ị́jọ́ ꞌdĩ sĩ Úpí rụ̂lé ãzíla jọ, “ꞌBá ꞌdĩ idé kí ị́jọ́ ũnzíkãnã la. Idé kí ãdróŋá gólũdĩ sĩ la ãzíla ị̃nzị̃ kí ĩꞌdi ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ꞌBá rĩ ítrũ mání ị́jọ́ ũnzí ĩꞌbadrị̂ kí rá fô; wó ídrĩ lẽ la ku yã áni ílị ãma rụ́ bụ́kụ̃ míní sĩ ꞌbá mídrị́ gá rĩ kí rụ́ sĩjó rĩ gá rá.” ");
INSERT INTO luc_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Wó Úpí umvi Mụ́sã nî, “ꞌBá mání rụ́ lịlẹ́ bụ́kụ̃ mádrị̂ agá rá rĩ kí adru ꞌbá ị́jọ́ ũnzí izalépi má rụ́ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Úꞌdîꞌda ímụ, íce ꞌbá ꞌdĩ kí drị̃ ãngũ mání ị́jọ́ la jọjó míní ꞌbo rĩ gá. Lẽ ínị̃ rá Mãlãyíkã mádrị̂ la ími drị̃ ce nĩ, wó sáwã ãzí la acá rá ma mụ ꞌbá ꞌdĩ ꞌbaní drị̃rịma fẽlé ị́jọ́ ũnzí ĩꞌbã kí idélé ꞌdĩ sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Úpí ãpẽ dó ãyánĩ tị ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃ gá, ãꞌdusĩku ĩꞌbã kí fẽjó la Ãrọ́nị̃ idé kãjóŋá ãdróŋá ru gólũdĩ sĩ la rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Úpí jọ Mụ́sã nî, “Mí aꞌbe ãngũ ꞌdĩ ꞌi, mi ꞌi ãzíla ꞌbá mídrị́ míní ajílé Mị̃sị́rị̃ gâlé rĩ abe. Ímụ ãngũ mání ũyõ najó ma fẽ la Ịbụrahị́mụ̃, Ĩsákã, ãzíla Yãkóꞌbõ ꞌbaní anzị ĩꞌbadrị́ drị̃lẹ́ gâlé rĩ abe rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ma mãlãyíkã tị pẽ ĩmi drị̃ cejó, ãzíla ma ꞌbá Kãnánĩ rú, Ãmọ́rị̃ rú, Hị́tị̃ rú, Pẹ̃rẹ́zị̃ rú, Hị́vị̃ rú ãzíla Yẹ̃bụ́sị̃ rú ꞌdĩ kí dro ĩmi drị̃lẹ́ gá ꞌdãá rá. ");
INSERT INTO luc_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ĩmụ ãngũ málĩ trũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ lé ꞌbã sĩ rajó ala gá ãnụ́ úsã be rĩ gá, wó má icó mụlé ĩmi drĩdríŋĩ gá ku, ãꞌdusĩku ĩmi ꞌbá drị̃ ũnzí la kî, ma mụ ĩmi ị̃lị̃kị̃lé ku rá.” ");
INSERT INTO luc_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ꞌBá ꞌdĩ kí mụ ị́jọ́ jọlé ũnzíríkãnã ꞌdĩ kí arelé ꞌbo, ꞌbe kí ru áwáŋá gá, ꞌbá ãzí ãlu la sụ̃ ãko ũnĩ ãni la kí ku. ");
INSERT INTO luc_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Úpí jọ Mụ́sã nî, “Íjọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, ‘Ĩmi ꞌbá drị̃ ũnzí la kî, ádrĩ mụ pâlé ãlu ĩmi drĩdríŋĩ gá, ma ĩmi ị̃lị̃kị̃ rá. Ị́jọ́ ꞌdĩ sĩ ĩmi ũtrũ ũnĩ ãko ĩminí sụ̃lé ꞌdĩ kí rá ãzíla ma ị́jọ́ míní lẽlé idélé ĩmi abe rĩ pẽ ma ꞌi.’” ");
INSERT INTO luc_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ị́jọ́ ꞌdĩ sĩ ꞌbá Ịsịrayị́lị̃ drị̂ ũtrũ kí dó ãko ĩꞌbadrị́ ũnĩ drị̂ kí pírí ꞌBé Hõrébũ gá ꞌdãá rá sụ̃ kí dó sĩ kí ị̃dị́ ku. ");
INSERT INTO luc_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ꞌBá Ịsịrayị́lị̃ drị̂ drĩ kí dó kámbĩ sị ꞌbo, Mụ́sã la Hémã ãzí idé kámbĩ agá ꞌdãá rĩ sĩ ãmvé-ãmvélé ru, ála ĩꞌdi umve Hémã tị icíma drị̂ ꞌi. ꞌBá ãzí drị̃ sĩ lẽ tị icílé Úpí be ĩꞌdi dó sĩ mụ ãmvé ala gâlé. ");
INSERT INTO luc_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mụ́sã drĩ dó fũ mụlé Hémã tị icíma drị̂ gá ãmvêlé ꞌbo, ꞌbá pírí kí dó pá utu hémã ĩꞌbadrị̂ kí tị gá, ãzíla kí Mụ́sã ndre kpere ĩꞌdiní fi agá ala gâlé. ");
INSERT INTO luc_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ꞌDã ꞌbã ũngúkú gá, Mụ́sã drĩ dó fi ala gâlé ꞌbo, ụ̃rụ́ꞌbụ̃ ị́dị́ŋá áni rĩ la asị́ vụ̃rụ́ ãzíla ĩꞌdi pá tu Hémã tị icíma drị̂ ꞌbã kẹ̃jị́tị gá, Úpí la ị́jọ́ jọ Mụ́sã be angájó ụ̃rụ́ꞌbụ̃ ãnzị̃ rĩ agâlé. ");
INSERT INTO luc_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ꞌBá pírí drĩ kí ụ̃rụ́ꞌbụ̃ ị́dị́ŋá áni ãnzị rĩ ndre pá tu agá kẹ̃jị́tị Hémã tị icíma drị̂ drị̂ tị gá ꞌdãá ꞌbo, ꞌbá pírí kí ãvụ̃ vụ̃rụ́ hémã ĩꞌbadrị̂ kí tị gá ꞌdãá Úpí ị̃nzị̃jó. ");
INSERT INTO luc_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Úpí la ị́jọ́ jọ Mụ́sã be mịfị́ gá mịfị́ gá, cécé ꞌbá ꞌbã kí ị́jọ́ jọjó wọ̃rị́ka abe rĩ áni. Mụ́sã drĩ dó gõ vúlé kámbĩ gâlé, wó kãrị́lẹ̃ Yósũwã Nụ́nị̃ ngọ́pị rú ĩꞌdi ãzã kolépi rĩ la ace Hémã tị icíma drị̂ agá ꞌdãá ũgũgõ. ");
INSERT INTO luc_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mụ́sã jọ Úpí ní, “Índre drĩ, ị́jọ mání, ‘Áce ꞌbá ꞌdĩ kí drị̃,’ wó ífẽ mání ꞌbá míní mụlé tị pẽlé má be rĩ ãꞌdi ꞌi yã rĩ nị̃lé ku, drị̃ la gâsĩ ị́jọ vâ, ‘Ínị̃ ma rụ́ sĩ cé, ãzíla má ịsụ́ vâ lẽtáŋá ĩmi drị̃lẹ́ gá ꞌbo.’ ");
INSERT INTO luc_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ídrĩ áma lẽ rá, mí imbá mání gẹ̃rị̃ mídrị̂ kî, ị́jọ́ ꞌdĩ sĩ ma dó sĩ ími nị̃ cé ãzíla ma dó sĩ ri ásị́ ị̃gbẹ̃ mídrị̂ ịsụ́lé. Lẽ mí igá ị́jọ́ míní sụ́rụ́ ꞌdĩ pẽjó mî ãni la rú rĩ rá.” ");
INSERT INTO luc_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Úpí jọ Mụ́sã nî, “Ma mụ mí be ĩndĩ, ãzíla ma míní fẽ avị́lé rá.” ");
INSERT INTO luc_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mụ́sã jọ Úpí ní, “Ídrĩ mụ ãma abe ĩndĩ ku, ífẽ ãma aꞌbe ãngũ ꞌdĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ꞌBá icó kí nị̃lé la ími ásị́ mání ị̃gbẹ́ ru rĩ gá íngoní ru, ídrĩ mụ ãma abe ĩndĩ ku rĩ gá? Ãma ꞌbá mí ãni la rú ꞌdĩ, ãꞌdu la icó ãma ĩsélé colé ꞌbá ãzí ụ̃nọ́kụ́ drị̃ gá ꞌdĩ kí abe nĩ yã?” ");
INSERT INTO luc_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Úpí jọ Mụ́sã ní, “Ma ị́jọ́ míní zịlé ꞌdĩ kí idé pírí rá, ãꞌdusĩku ánị̃ mi rụ́ sĩ cé, ãzíla má uꞌá mî sĩ ãyĩkõ sĩ.” ");
INSERT INTO luc_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mụ́sã jọ Úpí nî, “Álẽ dị̃zã mídrị̂ ndrelé rá mí iꞌda ĩꞌdi mánî.” ");
INSERT INTO luc_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Úpí jọ, “Ma alị ími drị̃lẹ́ gâsĩ mi sĩ dị̃zã mádrị̂ ꞌbã ũnĩ ndre pírí, mũkẽ mádrị̂ be. Ma áma rụ́ umve Úpí ꞌi, ma ꞌbá mání pẽlé rĩ ꞌbaní lẽtáŋá uyaŋá kóru rĩ fẽ ãzíla kí ízákĩzã ndre. ");
INSERT INTO luc_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Mí icó áma mẹ́lẹ́tị ndrelé ku, ꞌbá drĩ áma mẹ́lẹ́tị ndre rá icó adrulé ídri ku.” ");
INSERT INTO luc_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, “Ãngũ ãzí áma bụ́lụ́ gá ꞌdĩ mi sĩ pá tu írã drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Dị̃zã mádrị̂ drĩ dó alị yã áni, ma ími ꞌbã írã ru nzị̃lépi mgbọ la agá ãzíla ma ími aku áma drị́ sĩ kpere mání alị agá. ");
INSERT INTO luc_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ꞌDã ꞌbã ũngúkú gá, ma dó áma drị́ ꞌdụ rá ãzíla mi dó áma ũngúkú ndre áyụ wó adru áma mẹ́lẹ́tị ku.” ");
INSERT INTO luc_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Úpí jọ Mụ́sã ní, “Mí upa írã ꞌbara-ꞌbara la ãzí kí ị̃rị̃ cécé ándrá drị̃drị̃ ꞌdã kí áni, ãzíla ma ị́jọ́ ándrá mání sĩlé írã drị̃drị̃ míní ándrá andilé ꞌdã kí drị̃ gá rĩ sĩ kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Drụ̃sị̃ ụ̃ꞌbụ́tị sĩ mí adru bábá mi dó sĩ atụ́ ꞌbé Sĩnáyĩ drị̃ gá ꞌdộ sĩ drị̃ ụfụjó má be. ");
INSERT INTO luc_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ꞌBá ãzí ꞌba atụ́ mí be ụrụgá ꞌbé drị̃ gá ꞌdõlé ĩndĩ ku, jõku ãko ãzí ꞌba indré ꞌbé drị̃ gá ꞌdãá ku, drĩ táni adru agá kãbĩlõ jõku ãnãkpá ĩrí nalépi ꞌbé drị̃ gá ꞌdãá la kí yã ꞌba indré kí ꞌbé ꞌbã pá gá ꞌdãá ku.” ");
INSERT INTO luc_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ị́jọ́ ꞌdĩ sĩ, Mụ́sã upa írã ꞌbara-ꞌbara la kí ị̃rị̃ cécé ándrá drị̃drị̃ ꞌdã kí áni, ãzíla tụ ꞌbé Sĩnáyĩ drị̃ gá ụrụ gâlé ụ̃ꞌbụ́tịnị́nị́, cécé Úpí ꞌbã jọlé ĩꞌdiní rĩ áni, ꞌdụ írã ị̃rị̃ ꞌdã kí drị́ gá ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ꞌDã ꞌbã ũngúkú gá, Úpí asị́ vụ̃rụ́ ꞌdõlé ụ̃rụ́ꞌbụ̃ agâ sĩ ãzíla tu pá Mụ́sã be ꞌdãá, umve ru rụ́ Úpí ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Úpí alị Mụ́sã drị̃lẹ́ gâsĩ, ãzíla umve ru rụ́, “Ma, Úpí ꞌi, ma Ãdróŋá galépi tré ị́jọ́ mgbã sĩ ãzíla ꞌbá kí ízákĩzã ndrelépi rĩ ꞌi, ũmbã rụ ma gbõrú ku, ma lẽtáŋá ãmbógó la iꞌda ãzíla ꞌbá kí sĩ ásị́ tị̃ áma drị̃ gá rá. ");
INSERT INTO luc_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ma lẽtáŋá mádrị́ ukólépi ku rĩ tã mba anzị álĩfũ álĩfũ ĩꞌbadrị́ drị̃lẹ́ gâlé rĩ ꞌba ní, ãzíla ma ị́jọ́ ũnzí ĩꞌbadrị̂ kí trũ ũnzĩkãnã ĩꞌbadrị̂ abe rá. Wó má icó ĩcẽlé drị̃rịma fẽjó ꞌbá ị́jọ́ ũnzí idélépi rĩ ꞌbaní ku. ꞌBá drĩ kí ị́jọ́ ũnzí idé ma rụ́, ma anzị ĩꞌbadrị́ mụlé tịlé drị̃lẹ́ gâlé áꞌbị́ anzị na jõku sụ rĩ ꞌbaní drị̃rịma fẽ, ị́jọ́ ũnzí ĩꞌbã átẹ́pịka ꞌbadrị̂ kí sĩ.” ");
INSERT INTO luc_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mụ́sã ãvụ̃ vụ̃rụ́ gbõrú sĩ ị̃nzị̃táŋá fẽjó. ");
INSERT INTO luc_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Jọ, “Úpí ídrĩ uꞌá mání ãyĩkõ sĩ, má aꞌị́ mi ímụ dó ãma abe ĩndĩ. ꞌBá ꞌdĩ drĩ kí táni adru drị̃ ũnzí ru, ítrũ ị́jọ́ ũnzí ãmadrị̂ kí ũnzĩkãnã ãmaní idélé rĩ kí abe, ãzíla íꞌdụ ãma ꞌbá mídrị́ mgbã rĩ kî rú.” ");
INSERT INTO luc_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Úpí jọ Mụ́sã ní, “Ma mụ úꞌdîꞌda tị icíma idélé ꞌbá Ịsịrayị́lị̃ drị̂ abe. Ma mụ ị́jọ́ ãmbógó la kí idélé kí mẹ́lẹ́tị gá ị́jọ́ jõ drĩ ídu idélé sụ́rụ́ ãzí agá ãngũ drị̃ gá ꞌdâ ku la kî. ꞌBá pírí kí mụ ị́jọ́ ãmbógó mání icólé idélé ꞌdĩ kí ndrelé, ãꞌdusĩku ma Úpí ꞌi, ma mụ ị́jọ́ ụ̃sụ̃táŋá ru ꞌdĩ kí idélé ĩminî. ");
INSERT INTO luc_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ĩmba ãzị́táŋá mání fẽlé ĩminí ãndrũ ꞌdĩ kí tã. Mã mụ sụ́rụ́ ꞌdĩ kí drolé ãmvé Ãmọ́rị̃ kí, Kãnánĩ kí, Hị́tị̃ kí, Pẹ̃rẹ́zị̃ kí, Hị́vị̃ kí, ãzíla Yẹ̃bụ́sị̃ kí trũ, ĩminí mụ agá ꞌdĩ gá ꞌdâ. ");
INSERT INTO luc_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Lẽ ĩmi adru mịfị́ trũ ĩmi idé ị́jọ́ ãzí sĩ tị icíma icíjó sụ́rụ́ ĩminí fijó ala gá ꞌdĩ kí abe ku, ãꞌdusĩku kí mụ adrulé ĩminí mãtégõ ũnzí la. ");
INSERT INTO luc_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Kẹ̃jị́ la gá ĩmi andi ãlĩtárĩ ĩꞌbadrị̂ kí, írã ĩꞌbã ãni ị̃nzị̃lé ị̃nzị̃-ị̃nzị̃ ꞌdĩ kî, ãzíla ĩmi aga ị́dị́ŋá ãdróŋá ũkú ru Ãsérã drị́ ꞌdĩ kí vụ̃rụ́. ");
INSERT INTO luc_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Mí ị̃nzị̃ ãdróŋá ãzí ku, ãꞌdusĩku Ma, Úpí ꞌi, ma ãjã rú ãdróŋá ãzí ị̃nzị̃jó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Mí adru mịfị́ trũ mí icí tị ꞌbá uꞌálépi sụ́rụ́ ꞌdĩ agá rĩ abe ku, ãꞌdusĩku drĩ kí ãdroŋa ĩꞌbadrị̂ kí ị̃nzị̃ ãzíla ídétáŋá idé ĩꞌbanî, kí ími umve sĩ ru umújó ĩꞌba abe, ãzíla kí ími drị̃ se sĩ íná ĩꞌbaní fẽlé ídétáŋá ru ãdroŋa ĩꞌbadrị̂ ꞌbaní rĩ kí nalé ku rá. ");
INSERT INTO luc_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Anzị ĩmidrị̂ drĩ kí izonzi ãmị́yọ́ŋá ru ꞌdã kí ĩgbã ũkú ru, kí dó sĩ kí drị̃ se sĩ áma ãꞌị̃jó ku ãzíla ãdroŋa ĩꞌbã ãni ꞌdã kí ị̃nzị̃jó. ");
INSERT INTO luc_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Mí idé aya ãdroŋa rú la kí míní ị̃nzị̃lé ku. ");
INSERT INTO luc_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Ímba Ụ̃mụ̃ Mũkátĩ Ãkụ́kị́ kóru rĩ najó rĩ tã. Mání ị́jọ́ la azịjó míní rĩ áni, ína Mũkátĩ Ãkụ́kị́ kóru ꞌdĩ ụ́ꞌdụ́ ázị̂rị̃ ĩmbá ãbíbũ drị́ ꞌdĩ sĩ, ãꞌdusĩku ĩmbá ꞌdĩ ándrá míní sĩ Mị̃sị́rị̃ aꞌbejó rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Ngọ́tị́ ágọ́bị́ kãjãní rĩ kí ãnãkpá lị́cọ́ gá ágó kãjãní rĩ abe kí pírí má ãni. ");
INSERT INTO luc_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Kãyĩnõ mváŋá kãjãní rĩ mi unze la kãbĩlõ fẽjó kẹ̃jị́ la gá rĩ sĩ, ídrĩ lẽ unzelé la ku mi imbe la nũ rá. Lẽ mí unze anzị ãgọbị kãjãní rĩ kí rá. “Lẽ ꞌbá ãzí ꞌbã amụ́ áma drị̃lẹ́ gá drị́drị́ ru ãwãꞌdĩfô kóru ku. ");
INSERT INTO luc_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Ínga ãzị́ mídrị́ sĩ ámvụ́ sõjó ãzíla ãkónã ũkũnãjó rĩ kí ụ́ꞌdụ́ ázíyá, wó ụ́ꞌdụ́ ázị̂rị̃ rĩ sĩ mí avị́. ");
INSERT INTO luc_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Íꞌbã Ụ̃mụ̃ Ãkónã Ãfũlépi drị̃drị̃ mídrị́ ámvụ́ agá rĩ ꞌbadrị̂ ꞌi ãzíla íꞌbã Ụ̃mụ̃ ãkónã ámvụ́ agá rĩ kí Atrájó pírí ꞌbo rĩ drị̂ ílí ꞌbã ukó agá. ");
INSERT INTO luc_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ãgọbị mídrị̂ ꞌbã amụ́ kí Ũkpó ꞌDị́pị Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ drị̃lẹ́ gá ĩꞌdi ị̃nzị̃jó ílí ãlu-ãlu agá pâlé na. ");
INSERT INTO luc_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ma mụ sụ́rụ́ ꞌdĩ kí drolé ími drị̃lẹ́ gâsĩ rá ãzíla ma sụ́rụ́ mídrị̂ nzị̃ mgbọ rú ꞌbá ãzí icó amụ́lé ími ndẽlé sáwã míní adrujó Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá ụ̃mụ̃ na ꞌdĩ naŋá gá ílí ãlu-ãlu sĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Ĩmi ají mání ãrí ãnãkpá lịlẹ́ ídétáŋá ru la ãni la idélé ãkónã ãkụ́kị́ trũ la be ku. Ĩmba ãko ídétáŋá ru ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ rĩ drị̂ ꞌbã ị́mbị́ tã kpere ụ̃ꞌbụ́tị gá ku. ");
INSERT INTO luc_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ílí ãlu-ãlu sĩ mí ají jó Úpí Ãdróŋá mídrị̂ drị̂ agá ãkónã mídrị́ ãfũlépi drị̃drị̃ rĩ kî. “Lẽ mí aꞌdí ị̃ndrị́ mváŋá ĩzá ãndrẽ ꞌbã lẹ́sụ́ sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã nî, “Ísĩ ị́jọ́ ꞌdĩ kí vụ̃rụ́, ãꞌdusĩku ị́jọ́ ꞌdĩ kí bã sĩ fẽlépi la mání tị icíma icíjó mí be ãzíla ꞌbá Ịsịrayị́lị̃ drị̂ abe ꞌdĩ.” ");
INSERT INTO luc_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mụ́sã uꞌá Úpí be ꞌbé sị́ gâlé ụ́ꞌdụ́ kãlị́ sụ ãzíla ị́nị́ kãlị́ sụ, mũkátĩ naŋá ãzíla ị̃yị́ mvụŋá kóru. Sĩ dó írã ꞌbara-ꞌbara ꞌdã kí drị̃ gá ị́jọ́ tị icíma drị̂ kí ãzị́táŋá mụdrị́ rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mụ́sã la mụ asị́lé ꞌbé Sĩnáyĩ sị́ gâlé vụ̃rụ́ ꞌdõlé írã ꞌbara-ꞌbara ị̃rị̃ ãzị́táŋá mụdrị́ rĩ kí sĩjó drị̃ la gá rĩ abe ĩꞌdidrị́ gá ꞌbo, mẹ́lẹ́tị la ri dị̃lé pãrã-pãrã rú, ãꞌdusĩku angá ị́jọ́ jọ agá Úpí be; wó nị̃ ꞌî mẹ́lẹ́tị la dị̃-dị̃ la ku. ");
INSERT INTO luc_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ãrọ́nị̃ kí ꞌbá Ịsịrayị́lị̃ drị̂ kí abe pírí ndre kí dó Mụ́sã ꞌbã mẹ́lẹ́tị la dị̃-dị̃, idé kí dó ụ̃rị̃ sĩ sĩ mụjó ãni rú ĩꞌdi andre gâlé. ");
INSERT INTO luc_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Wó Mụ́sã umve Ãrọ́nị̃ kí drị̃lẹ́ ũꞌbí ꞌbadrị̂ abe ãzíla mụ kí dó ĩꞌdi rụ̂lé, Mụ́sã jọ ị́jọ́ ĩꞌbanî. ");
INSERT INTO luc_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ꞌDã ꞌbã vúlé gá ꞌbá pírí Ịsịrayị́lị̃ drị̂ tra kí ru Mụ́sã andre gá, ãzíla fẽ dó ĩꞌbaní ãzị́táŋá pírí Úpí ꞌbã fẽlé ĩꞌdidrị́ ꞌbé Sĩnáyĩ drị̃ gâlé rĩ kî. ");
INSERT INTO luc_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mụ́sã la mụ ị́jọ́ ĩꞌdiní jọlé ĩꞌbaní rĩ delé ꞌbo, aku ru mẹ́lẹ́tị bõngó sĩ cí. ");
INSERT INTO luc_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Wó Mụ́sã drĩ mụ Úpí drị̃lẹ́ gá sĩ ị́jọ́ jọjó ĩꞌdi be, ĩꞌdi bõngó ĩꞌdi sĩ ru mẹ́lẹ́tị akujó rĩ wị rá. Drĩ dó ãfũ ãmvé ĩꞌdi ị́jọ́ Úpí ꞌbã azịlé ĩꞌdiní rĩ kí vú nze ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní pírí, ");
INSERT INTO luc_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ãzíla ꞌbá kí mẹ́lẹ́tị la dị̃lépi dị̃-dị̃ ꞌdã ndre. ꞌDã ꞌbã ũngúkú gá, Mụ́sã la ru mẹ́lẹ́tị aku bõngô sĩ cí kpere sáwã ĩꞌdi ꞌbã mụjó ị́jọ́ jọjó Úpí be rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ꞌDã ꞌbã ũngúkú gá, Mụ́sã tra ũꞌbí Ịsịrayị́lị̃ drị̂ kí pírí ãzíla jọ, “Ị́jọ́ ꞌdĩ kí ãzị́táŋá Úpí ꞌbã azịlé ĩmi idé kí rĩ kî: ");
INSERT INTO luc_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Ụ́ꞌdụ́ ázíyá rĩ kí ĩminí sĩ ãzị́ ngajó, wó ụ́ꞌdụ́ ázị̂rị̃ rĩ ĩꞌdi ụ́ꞌdụ́ Sãbátũ drị́ ĩminí sĩ avị́jó rĩ ꞌi, ĩmba tã la ãlá ru Úpí nî. ꞌBá ãzí drĩ ãzị́ ãzí nga ala gá rá, lẽ úꞌdị ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Lẽ ꞌbá ãzí ꞌbã ũdũ ãcí ãngũ ĩꞌdiní uꞌájó rĩ gá Sãbátũ sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mụ́sã jọ vâ ũꞌbí Ịsịrayị́lị̃ drị̂ ꞌbaní pírí, “ꞌdĩ ị́jọ́ Úpí ꞌbã azịlé rĩ: ");
INSERT INTO luc_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Ĩmi aꞌdụ́ ãko ĩmidrị̂ kí agụlé ãwãꞌdĩfô rú Úpí nî. ꞌBá pírí lẽlépi ãwãꞌdĩfô ajílépi Úpí ní ásị́ ãlu sĩ rĩ ꞌba ají ãwãꞌdĩfô rú gólũdĩ, sílĩvã, ãzíla bũrônzĩ; ");
INSERT INTO luc_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","wị́zị̃ la ꞌbã adru kí gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika; bõngó ãjẹ̃ rú mịfị́ níríŋá, idélé ị̃ndrị́ ꞌbíko sĩ rĩ; ");
INSERT INTO luc_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kãbĩlõ íní vúlé rángi sĩ ika rĩ kí; ãnãkpá íníríkó ãlá la kí; báwũ ꞌbọ́kọ́lọ̃ drị̂ kí; ");
INSERT INTO luc_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","tárã ãdu; ãdu ãjị́ ngụ̃lépi vĩrĩ ũsũlé ꞌbá drị̃ gá rĩ ꞌi ãzíla lũbánĩ ãjị́ ngụ̃lépi vĩrĩ rĩ be; ");
INSERT INTO luc_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ãzíla írã únĩkĩsĩ rú rĩ kí írã ãzí ãjẹ̃ rú icólé ịgbẹlé átáló ãmbógó ãndânĩ rĩ ꞌbã bõngó ĩfódĩ rú rĩ gá ãzíla bõngó jụ́jụ́ gá rĩ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“ꞌBá ĩmi agá ãlịgọ rú ãzị́ ãni ꞌdĩ ꞌba amụ́ kí ãzíla ꞌbã idé kí ãko pírí Úpí ꞌbã azịlé ꞌdĩ kí: ");
INSERT INTO luc_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ ꞌi; ãko sĩ ĩꞌdi atrịjó rĩ kî; gõlĩ la kí ãzíla báwũ ị́dị́ŋá ru rĩ abe; jó ife báwũ alalé alâ rĩ kí; ị́dị́ŋá la kí; ãzíla ãko sĩ ị̃ndụ́ la kí sujó rĩ. ");
INSERT INTO luc_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Sãndụ́kụ̃ tị icíma drị̂ kí ife sĩ ĩꞌdi ujíjó rĩ kí abe; úmvúke ásị́ ị̃gbẹ̃ drị̂ ãzíla kátẽnĩ ĩꞌdi atrịlépi rĩ; ");
INSERT INTO luc_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","méjã kí ife sĩ ĩꞌdi ujíjó rĩ abe ãzíla ãko drị̃ la gá rĩ kí abe; mũkátĩ ídétáŋá ru ꞌbãlé ndú Ãdróŋá nî rĩ; ");
INSERT INTO luc_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","tárã céke ãcí drị̂ ãdu la abe; ");
INSERT INTO luc_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ãlĩtárĩ sĩ lũbánĩ ãjị́ ngụ̃lépi vĩrĩ rĩ ivéjó rĩ ãzíla ife la kî abe; ãdu sĩ drị́ tị̃jó ꞌbá drị̃ gá rĩ, lũbánĩ ãjị́ ngụ̃lépi vĩrĩ rĩ, kátẽnĩ kẹ̃jị́tị sĩ fijó Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ agâlé rĩ; ");
INSERT INTO luc_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ãzíla ãlĩtárĩ ãko ídétáŋá ru ivélé ivê rĩ drị̂ kí, kẽyĩkéyĩ idélé aya bũrônzĩ rú rĩ sĩ rĩ; ife sĩ ĩꞌdi ujíjó rĩ kí ãzíla ãkójó la kî; báfũ bũrônzĩ rú rĩ pá la abe; ");
INSERT INTO luc_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","bõngó sĩ lị́cọ́ ꞌa atrịjó rĩ, ị́dị́ŋá ãzíla ãko sĩ ị̃ndụ́ la sujó rĩ; ãzíla kátẽnĩ kẹ̃jị́tị sĩ fijó lị́cọ́ ꞌa gâlé rĩ atrịjó rĩ; ");
INSERT INTO luc_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","áló Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ drị̂ kí ĩbáká la abe ãzíla ãko sĩ lị́cọ́ ꞌa atrịjó rĩ; ");
INSERT INTO luc_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ãzíla bõngó cãlé ũniyambamba ãlá ãtalo ꞌbaní sụ̃lé sĩ ãzị́ ngajó Ãngũ Ãlá rĩ gá, átáló Ãrọ́nị̃ ꞌbaní anzị ĩꞌdidrị̂ abe rĩ.” ");
INSERT INTO luc_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ꞌDã ꞌbã ũngúkú gá, ũꞌbí Ịsịrayị́lị̃ drị̂ ĩdã kí ru pírí Mụ́sã drị̃lẹ́ gá ꞌdãá rá, ");
INSERT INTO luc_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ãzíla ꞌbá pírí ásị́ gâlé lẽlépi ãko fẽlépi rá rĩ ají kí ãko fẽtáŋá ru ãlá rĩ kí Úpí ní sĩ Hémã tị icíma drị̂ idéjó. Ají kí ãko lẽlé ị̃nzị̃táŋá drị́ ãzíla ãko sĩ bõngó ãtalo ꞌbadrị̂ kí idéjó rĩ kî. ");
INSERT INTO luc_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ꞌBá pírí ãgọbị rú ãzíla ũkú ru ásị́ gâlé lẽlépi ãko fẽlépi ꞌdĩ amụ́ kí ãzíla ají kí ãko ũnĩ drị́ gólũdĩ rú ũví ndú ndú ꞌdĩ kí ingalé ídétáŋá ru Úpí nî: ");
INSERT INTO luc_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ꞌBá pírí ají kí náyị́lọ̃nị̃ ãla; bụ̃lụ̂ rú, pápũlũ, jõku kãbĩlõ ꞌbíko ika; bõngó ãjẹ̃ rú mịfị́ níríŋá idélé ị̃ndrị́ ꞌbíko sĩ rĩ, kãbĩlõ íní vúlé rángi sĩ ika rĩ kí, jõku ãnãkpá íníríkó ãlá la. ");
INSERT INTO luc_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ꞌBá fẽtáŋá fẽlépi sílĩvã sĩ jõku bũrônzĩ sĩ rĩ ají kí kí fẽlé Úpí nî, ãzíla ꞌbá báwũ ꞌbọ́kọ́lọ̃ drị̂ trũ rĩ ají kí sĩ ãzị́ kí lẽlépi rĩ kí ngajó. ");
INSERT INTO luc_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ũkú pírí ãlịgọ rú ãko cãlépi drị́ sĩ ꞌdĩ ají kí bõngó mịfị́ níríŋá ĩꞌbaní cãlé rĩ kí, wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ũkú pírí ãlịgọ rú rĩ idé kí vâ wị́zị̃ ị̃ndrị́ ꞌbíko sĩ ĩꞌbã ásị́ sĩ cénĩ. ");
INSERT INTO luc_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ꞌBá drị̃lẹ́ ru rĩ ají kí írã únĩkĩsĩ rú rĩ kí írã ãzí ãjẹ̃ rú icólé ịgbẹlé átáló ãmbógó ãndânĩ rĩ ꞌbã bõngó ĩfódĩ rú rĩ gá ãzíla bõngó jụ́jụ́ gá rĩ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ají kí lũbánĩ ãjị́ ngụ̃lépi vĩrĩ rĩ kí tárã ãdu Mị̃zẹ̃yị́tụ̃ drị̂ abe, ãdu ũsũlé sĩ drị́ tị̃jó ꞌbá drị̃ gá rĩ ãzíla ãko ãjị́ ngụ̃lépi vĩrĩ rĩ abe. ");
INSERT INTO luc_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ꞌBá pírí Ịsịrayị́lị̃ drị́ ãgọbị rú ãzíla ũkú ru ásị́ gâlé lẽlépi ãko fẽlépi cénĩ ãwãꞌdĩfô rú rĩ ají kí Úpí ní ãko sĩ ãzị́ ngajó ĩꞌdi ꞌbã azịlé Mụ́sã ní rĩ kî. ");
INSERT INTO luc_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ꞌDã ꞌbã ũngúkú gá, Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ĩndre, Úpí pẽ Bẹ̃zãlẹ́lị̃ Ụ́rị̃ ngọ́pị Hụ́rị̃ umvelépi áyị́pị rĩ angájó sụ́rụ́ Yụ́dã drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ãdróŋá fẽ ga tré úríndí ĩꞌdidrị̂ sĩ, ãlị̃gọ̃ sĩ, nị̃táŋá sĩ ãzíla icó ãzị́ pírí idélé ãlị̃gọ̃ sĩ rĩ kí ngalé rá. ");
INSERT INTO luc_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ĩꞌdi sĩ íꞌdá gbã ãlị̃gọ̃ sĩ, ãzị́ nga gólũdĩ sĩ, sílĩvã sĩ, ãzíla bũrônzĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Ĩꞌdi ũnĩ ãko ŋálí kí áni ꞌdĩ kí idé, ife kí upa ãzíla agọ́ ũví ndú-ndú sĩ ãzíla ãzị́ pírí ngalé ãlị̃gọ̃ sĩ rĩ abe. ");
INSERT INTO luc_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Úpí fẽ Bẹ̃zãlẹ́lị̃ ãzíla Ũhõlĩyábũ Ãhĩsãmákĩ ngọ́pị, sụ́rụ́ Dánĩ drị̂ gá rĩ kí ásị́ gá ũndũwã sĩ ꞌbá kí imbájó ãlị̃gọ̃ sĩ rĩ. ");
INSERT INTO luc_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Úpí fẽ ga kí tré ãlị̃gọ̃ sĩ ãko ndú-ndú kí idéjó ãzíla ãzị́ pírí kí ngajó rĩ kí sĩ. Ãko idélé drị́ sĩ ꞌdĩ kí, báwũ kí upajó, ãko kí uꞌbéjó gbẽtí bụ̃lụ̂, pápũlũ, kãbĩlõ ꞌbíko ika, ãzíla bõngó ãjẹ̃ rú mịfị́ níríŋá rĩ kí abe. Kí icó ãzị́ pírí kí ngalé rá, ãzíla kí ãlị̃gọ̃ ãko pírí kí idéjó rĩ trũ. ");
INSERT INTO luc_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Ị́jọ́ ꞌdĩ sĩ Bẹ̃zãlẹ́lị̃ ꞌi, Ũhõlĩyábũ ꞌi ãzíla ꞌbá ãzí ãlịgọ rú Úpí ꞌbã sĩ ĩꞌbaní ũndũwã, ãlị̃gọ̃ ãzíla nị̃táŋá fẽjó rĩ ꞌbã sị kí Hémã Ãdróŋá Ị̃nzị̃jó rĩ cécé Úpí ꞌbã azịlé rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ꞌDã ꞌbã ũngúkú gá, Mụ́sã umve dó Bẹ̃zãlẹ́lị̃ kí Ũhõlĩyábũ be ãzíla ꞌbá pírí ãlịgọ rú Úpí ꞌbã sĩ ĩꞌbaní ãlị̃gọ̃ ãzíla ũndũwã fẽjó ãꞌị̃lépi amụ́lépi ãzị́ ngalépi cénĩ ꞌdĩ kí amụ́lé sĩ iꞌdólé ãzị́ ngalé. ");
INSERT INTO luc_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Mụ́sã fẽ dó ĩꞌbadrị̂lé ãko ãwãꞌdĩfô rú ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã kí fẽlé sĩ ãzị́ ãngũ ãlá rĩ drị̂ sịjó rĩ kî. ꞌBá ꞌdĩ ri kí ụ̃ꞌbụ́tị ãlu-ãlu sĩ ãko ãwãꞌdĩfô ru rĩ kí ajílé fẽlé cénĩ. ");
INSERT INTO luc_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ị́jọ́ ꞌdĩ sĩ ꞌbá pírí ãlịgọ rú ãzị́ ngalépi ãngũ ãlá rĩ ꞌbã sịŋá gá ꞌdĩ aꞌbe kí ãzị́ ĩꞌbadrị̂ kí rá ");
INSERT INTO luc_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ãzíla jọ kí Mụ́sã ní, “ꞌBá kí ãko ají sĩ ãzị́ ngajó ndẽ Úpí ꞌbã azịlé rĩ rá.” ");
INSERT INTO luc_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ị́jọ́ ꞌdĩ sĩ Mụ́sã fẽ dó ãzị́táŋá sĩ ị́jọ́ ꞌdĩ azịjó kámbĩ agâ sĩ pírí: “ꞌBá ãzí ágọ́bị́ ru jõku ũkú ru la ꞌbã ají kí dó ãko ãzí fẽtáŋá ru la kí fẽlé ãngũ ãlá rĩ ní ị̃dị́ ku.” Ị́jọ́ ꞌdĩ sĩ âtrị dó ꞌbá kí ãko fẽtáŋá ru rĩ kí ajíŋá gá cí, ");
INSERT INTO luc_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ãꞌdusĩku ãko tralé sĩ Hémã sĩ Ãdróŋá Ị̃nzị̃jó rĩ sịjó ãzíla dejó rĩ tra kí ru ambamba. ");
INSERT INTO luc_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ꞌBá pírí ãlịgọ rú ꞌdĩ sị kí Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ drị̂ bõngó mụdrị́ mịfị́ níríŋá uꞌbélé gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika la kî sĩ, ãzíla ꞌbá ãlị̃gọ̃ ãko idéjó drị́ sĩ rĩ drị̂ trũ rĩ idé kí íꞌdá kẹ̃rụ́bị̃ ãni la kí ụrụꞌbá la kí gá cí. ");
INSERT INTO luc_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Bõngó ꞌdĩ ꞌbã adru kí pírí trũ-trũ, ãzo la ꞌbã adru kí mítã mụdrị́ drị̃ ị̃rị̃, mgbọ la ꞌbã adru mítã ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Icí kí bõngó tõwú rĩ kí ãlu, idé kí vâ ãzí tõwú ꞌdã kí cécé ꞌdã áni. ");
INSERT INTO luc_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ꞌDã ꞌbã ũngúkú gá, ịgbẹ kí bõngó bụ̃lụ̂ la kí bõngó ãlu rĩ ꞌbã tị gâsĩ, idé kí vâ bõngó ãzí rĩ kí abe ꞌdã áni. ");
INSERT INTO luc_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Idé kí dó ꞌbụ́ bõngó tõwú icílé ãlu rĩ ꞌbã tị gá kãlị́ tõwú ãzíla ꞌbụ́ kãlị́ tõwú bõngó ãzí tõwú icílé ãlu rĩ ꞌbã tị gá, ꞌbụ́ ꞌdĩ ndre kí ru ndre-ndrẽ. ");
INSERT INTO luc_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ꞌDã ꞌbã ũngúkú gá, idé kí gõlĩ gólũdĩ sĩ rĩ kí kãlị́ tõwú ãzíla ayú kí dó kí sĩ bõngó ꞌdĩ kí ũgĩjó ãlu, ị́jọ́ ꞌdĩ sĩ, Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ drị̂ ꞌbã icí kí rú sĩ ru ãlu benĩ. ");
INSERT INTO luc_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Idé bõngó ãzí kí mụdrị́ drị̃ ãlu ị̃ndrị́ ꞌbíko sĩ sĩ Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ drị̃ akujó. ");
INSERT INTO luc_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Bõngó mụdrị́ drị̃ ãlu ꞌdĩ kí pírí trũ-trũ, ãzo la kí mítã mụdrị́ drị̃ na ãzíla mgbọ la kí mítã ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Usé kí kátẽnĩ tõwú rĩ kí ĩbáká ãlu gá ãzí ázíyá rĩ kí ĩbáká ãlu gá. ");
INSERT INTO luc_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ꞌDã ꞌbã ũngúkú gá, ịgbẹ kí ꞌbụ́ kí kãlị́ tõwú bõngó tõwú usélé ãngũ ãlu gá ãsị̃jó rĩ ꞌbã tị gâsĩ, ịgbẹ kí vâ ꞌbụ́ kí kãlị́ tõwú kátẽnĩ ázíyá usélé ãngũ ãlu gá ãsị̃jó rĩ ꞌbã tị gâsĩ. ");
INSERT INTO luc_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Idé kí gõlĩ bũrônzĩ sĩ rĩ kí kãlị́ tõwú sĩ Hémã kí icíjó ãko ãlu rú. ");
INSERT INTO luc_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ꞌDã ꞌbã ũngúkú gá, idé kí Hémã ní ãko sĩ ĩꞌdi drị̃ akujó la kãbĩlógó ꞌbã íníríkó vulé rángi ika la sĩ rĩ sĩ, ãzíla aku kí ĩꞌdi drị̃ ãnãkpá íníríkó ãlá la sĩ. ");
INSERT INTO luc_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Idé kí ị́dị́ŋá kpị la kí báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ nî. ");
INSERT INTO luc_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Báwũ ị́dị́ŋá ru ãlu-ãlu rĩ ꞌbã ãzo ꞌbã adru mítã sụ-sụ ãzíla mgbọ la kí drĩdríŋĩ gá rĩ ꞌbã adru sẽndị́mĩtã 66. ");
INSERT INTO luc_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Báwũ ꞌbã tị ị̃rị̃ rĩ ꞌbã ãfũ kí ãzíla ꞌbã ndre kí ru ãzí rĩ abe sĩ kí icíjó ãlu. Idé kí báwũ ị́dị́ŋá ru Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ drị̂ kí pírí ꞌdĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Idé kí báwũ ị́dị́ŋá ru rĩ kí kãlị́ ị̃rị̃ Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ ꞌbã wókõ ándrá rĩ gá ");
INSERT INTO luc_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ãzíla idé kí ãko sĩ báwũ ị́dị́ŋá ru rĩ kí ị̃ndụ́ usújó sílĩvã rú rĩ kí kãlị́ sụ, ị́dị́ŋá ãlu-ãlu ị̃ndụ́ gá kí ị̃rị̃-ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ ꞌbã wókõ ụ́rụ́lé rĩ gá, idé kí báwũ ị́dị́ŋá ru rĩ kí kãlị́ ị̃rị̃ ");
INSERT INTO luc_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ãzíla ị̃ndụ́ la idélé sílĩvã sĩ rĩ kí kãlị́ sụ, ị́dị́ŋá ãlu-ãlu ị̃ndụ́ gá kí ị̃rị̃-ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Idé kí Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ ní báwũ ị́dị́ŋá ru rĩ kí ázíyá, wókõ la ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ gá, ");
INSERT INTO luc_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ãzíla idé kí vâ báwũ ị́dị́ŋá ru rĩ kí ị̃rị̃ kónã Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ ꞌbã ãsị̃jó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Kónã ị̃rị̃ ꞌdĩ kí agá usú kí ị́dị́ŋá kí ímve ãlu agá ị̃rị̃-ị̃rị̃ iꞌdójó ị̃ndụ́ gá kpere drị̃ gá. Idé kí kí ị̃rị̃trá ũví ãlu sĩ. ");
INSERT INTO luc_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ị́jọ́ ꞌdĩ sĩ, báwũ ị́dị́ŋá ru rĩ kí dó sĩ ãrõ ãzíla ị̃ndụ́ la sílĩvã rú rĩ kí mụdrị́ drị̃ ázíyá, kí ị́dị́ŋá ãlu-ãlu ị̃ndụ́ gá ị̃rị̃-ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Idé kí jó ife báwũ alalé alâ la kí báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ: tõwú rĩ kí ị́dị́ŋá Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ ꞌbã bụ́lụ́ ãlu rĩ gá, ");
INSERT INTO luc_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ãzí tõwú rĩ kí bụ́lụ́ la ãzí rĩ gá, ãzíla báwũ ị́dị́ŋá ru tõwú rĩ kí wókõ ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ gá ãngũ Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ ꞌbã tị ꞌbã ãsị̃jó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Idé kí báwũ alalé alâ ꞌbãlé ị́dị́ŋá ágágá rĩ kí drị̃ gâsĩ rĩ kí iꞌdóŋá gá kpere ãsị̃ŋá gá. ");
INSERT INTO luc_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ase kí ị́dị́ŋá ꞌdĩ kí ụrụꞌbá gólũdĩ sĩ cí ãzíla idé kí ímve gólũdĩ sĩ la kí sĩ báwũ alalé alâ ꞌdĩ kí rụjó. Ase kí vâ báwũ alalé ala-lã lã ꞌdĩ kí ụrụꞌbá gólũdĩ sĩ cí. ");
INSERT INTO luc_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Idé kí kátẽnĩ kí bõngó mịfị́ níríŋá la sĩ ãzíla uꞌbé kí ĩꞌdi wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ, ika ãzíla ꞌbá ãlị̃gọ̃ ãko idélé drị́ sĩ rĩ drị̂ trũ rĩ idé kí kẹ̃rụ́bị̃ ụ́pụ́pị́ trũ la kî. ");
INSERT INTO luc_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Idé kí ĩꞌdiní ị́dị́ŋá kí sụ báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ ãzíla ase kí ụrụꞌbá la kí gólũdĩ sĩ. Idé kí gõlĩ kí gólũdĩ sĩ ãzíla idé kí ãko sĩ ị́dị́ŋá kí ị̃ndụ́ sujó sụ rĩ kí sílĩvã sĩ. ");
INSERT INTO luc_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Kẹ̃jị́tị sĩ fijó Hémã Ãdróŋá Ị̃nzị̃jó rĩ agâlé rĩ gá, cã kí kátẽnĩ uꞌbélé wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika sĩ la kí wị́zị̃ sĩ ãzíla bõngó mịfị́ níríŋá cãlé ãlị̃gọ̃ sĩ la sĩ. ");
INSERT INTO luc_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Idé kí ị́dị́ŋá kí tõwú gõlĩ trũ bõngó ꞌdĩ ꞌbaní. Ase kí ị́dị́ŋá ꞌdĩ kí drị̃ ãzíla aya usúlé kí ụrụꞌbá gá rĩ kí abe gólũdĩ sĩ. Idé kí ị̃ndụ́ la tõwú rĩ kí bũrônzĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bẹ̃zãlẹ́lị̃ idé Sãndụ́kụ̃ tị icíma drị̂ báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ, ãzo la mítã ãlu nụ́sụ̃, mgbọ la mítã ãlu nụ́sụ̃, ãzíla ãzo la ụrụgâlé ru rĩ mítã ãlu nụ́sụ̃. ");
INSERT INTO luc_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ase ụrụꞌbá la agâ sĩ ãzíla ãmvê sĩ rĩ gólũdĩ ãlá rĩ sĩ. Ãzíla ulí láyĩnĩ ũnĩ ãni la gólũdĩ sĩ ụrụꞌbá la gâsĩ pírí cí. ");
INSERT INTO luc_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Bẹ̃zãlẹ́lị̃ idé Sãndụ́kụ̃ tị icíma drị̂ ní ímve gólũdĩ sĩ la kí sụ sĩ ĩꞌdi ujíjó, icí pá la sụ ꞌdĩ kí agá ímve ãlu-ãlu. Sãndụ́kụ̃ ꞌbã wókõ ãlu rĩ gá ị̃rị̃ ãzí rĩ gá vâ ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ꞌDã ꞌbã ũngúkú gá, idé ife sĩ ĩꞌdi ujíjó la kí báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ ãzíla ase ụrụꞌbá la kí gólũdĩ sĩ cí, ");
INSERT INTO luc_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ãzíla su ife ꞌdã kí ímve kí agâ sĩ Sãndụ́kụ̃ tị icíma drị̂ ꞌbã bụ́lụ́ gá sĩ ĩꞌdi ujíjó. ");
INSERT INTO luc_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Bẹ̃zãlẹ́lị̃ idé Sãndụ́kụ̃ tị icíma drị̂ ní úmvúke ásị́ ị̃gbẹ̃ drị̂ sĩ ĩꞌdi tị ụ̃pị̃jó gólũdĩ ãlá rĩ sĩ, ãzo la ãni rú mítã ãlu nụ́sụ̃ ãzíla mgbọ la ãni rú mítã ãlu. ");
INSERT INTO luc_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Idé kẹ̃rụ́bị̃ ụ́pụ́pị́ trũ uꞌdilé gólũdĩ sĩ la kí ị̃rị̃, ũꞌbã kí úmvúke ásị́ ị̃gbẹ̃ drị̂ ꞌbã tị ãsị̃jó rĩ kí gá. ");
INSERT INTO luc_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Idé kẹ̃rụ́bị̃ ụ́pụ́pị́ trũ ãlu rĩ wókõ ãlu rĩ gá, ãzí ãlu rĩ vâ ãzí rĩ gá; icí kí úmvúke ásị́ ị̃gbẹ̃ drị̂ be ãlu tị la ị̃rị̃ rĩ kí gá. ");
INSERT INTO luc_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kẹ̃rụ́bị̃ inga kí ru ụ́pụ́pị́ ụrụgâlé ru ãzíla aku kí dó sĩ úmvúke ásị́ ị̃gbẹ̃ drị̂ cí, ndre kí ru ndre-ndrẽ ãzíla ndre kí ãngũ úmvúke ásị́ ị̃gbẹ̃ drị̂ rụ̂lé ru. ");
INSERT INTO luc_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bẹ̃zãlẹ́lị̃ idé méjã báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ, ãzo la ãni rú mítã ãlu, mgbọ la ãni rú nụ̃sụ̃ mítã ãzíla ãzo la ụrụgâlé ru rĩ ãni rú mítã ãlu. ");
INSERT INTO luc_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ꞌDã ꞌbã ũngúkú gá, Bẹ̃zãlẹ́lị̃ ase ụrụꞌbá la gólũdĩ ãlá rĩ sĩ ãzíla li tị la pírí gólũdĩ sĩ trộkị́lịrị cí. ");
INSERT INTO luc_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Li tị la trộkị́lịrị, ãnzị la ãni rú ị́nzị̃ na ãzíla ase kí ĩꞌdi gólũdĩ sĩ cí. ");
INSERT INTO luc_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Idé ímve gólũdĩ sĩ la kí sụ méjã ꞌdĩ ní sĩ ĩꞌdi ujíjó, ãzíla icí ímve ꞌdĩ kí kónã la sụ ꞌdĩ kí agá ãngũ ĩꞌdi ꞌbã pá ꞌbã sĩ adrujó rĩ kí gá. ");
INSERT INTO luc_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Bẹ̃zãlẹ́lị̃ umbé ímve kí méjã ꞌbã bụ́lụ́ gâsĩ ãni rú sĩ ife usúlé ĩꞌdi ụꞌdụjó rĩ kí rụjó. ");
INSERT INTO luc_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Idé kí ife sĩ méjã ꞌdĩ ụꞌdụjó rĩ kí báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ ãzíla ase kí ụrụꞌbá la kí gólũdĩ sĩ cí. ");
INSERT INTO luc_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Idé kí dó ãkójó ndú-ndú méjã ꞌdĩ drị́ sãánĩ, kópõ, jágĩ ãzíla bãkụ́lẹ̃ sĩ icójó ãko mvụlé mvụ-mvụ̃ rĩ kí ũsũjó rĩ kí gólũdĩ ãlá la sĩ. ");
INSERT INTO luc_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Bẹ̃zãlẹ́lị̃ idé kí tárã céke gólũdĩ ãlá uꞌdilé uꞌdî rĩ sĩ, ị̃ndụ́ la kí gbọ́ŋị la be; kópõ la cécé mãwụ́wã áni rĩ kí abe, mãwụ́wã drĩ drị̃kã nzị̃lépi ku rĩ abe ãzíla icí kí ru mãwụ́wã la abe pírí ãlu. ");
INSERT INTO luc_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Tárã céke ꞌbã gbọ́ŋị gá idé kí kénĩ kí ázíyá, na rĩ kí wókõ ãlu rĩ gá ãzíla na rĩ kí wókõ ãzí rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Idé kí kénĩ ãlu-ãlu ázíyá ꞌdĩ kí ụrụꞌbá gá mãwụ́wã íꞌdá cécé ãlĩmóndĩ drị́ ãfũlépi tárã céke kí ụrụꞌbá gâlé rĩ ꞌba nî. ");
INSERT INTO luc_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Idé kí tárã céke ágágá rĩ drị̃ gá mãwụ́wã idélé cécé mãwụ́wã ãlĩmóndĩ drị̂ áni agbẹ́lépi ngúlú ãzíla ayilépi rĩ kí sụ cí. ");
INSERT INTO luc_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Idé kí mãwụ́wã drị̃kã agbẹ́lépi ngúlú rĩ kí kénĩ ãkpãlé ị̃rị̃-ị̃rị̃ na ꞌdĩ kí ị̃ndụ́lé gá ãlu-ãlu. ");
INSERT INTO luc_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Tárã céke, kénĩ la kí ãzíla mãwụ́wã drị̃ ngúlú rĩ kí abe ídé kí gólũdĩ ãlá ꞌbara ãlu la sĩ. ");
INSERT INTO luc_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Idé kí dó tárã la ázị̂rị̃ rĩ kî, ãzíla kpákuŋá sĩ ãko kí rụjó jõku aꞌdụ́jó rĩ abe gólũdĩ ãlá la sĩ. ");
INSERT INTO luc_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ayú gólũdĩ ãlá rĩ kị́lọ̃ kãlị́ na drị̃ tõwú sĩ tárã céke idéjó ãzíla ãko ndú-ndú ala gá rĩ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bẹ̃zãlẹ́lị̃ idé ãlĩtárĩ sĩ lũbánĩ ãjị́ ngụ̃lépi vĩrĩ rĩ ivéjó rĩ báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ. Idé ĩꞌdi trũ-trũ ãzo la kí mgbọ la be ãni rú nụ̃sụ̃ mítã ãzíla ãzo la ụrụgâlé ru rĩ ãni rú mítã ãlu. Újé la kónã la sụ ꞌdĩ kí gá rĩ icí kí ru ãko ãlu rú. ");
INSERT INTO luc_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ase drị̃ la, bụ́lụ́ la kí, ãzíla újé la kónã gá rĩ kí abe pírí gólũdĩ ãlá rĩ sĩ, ãzíla li kí tị gólũdĩ sĩ trộkị́lịrị cí. ");
INSERT INTO luc_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Idé kí ímve gólũdĩ sĩ la kí ị̃rị̃ láyĩnĩ ũnĩ ãni ulílé gólũdĩ sĩ trộkị́lịrị rĩ ꞌbã ị̃ndụ́lẹ́ gâlé ru ndre kí ru ãzí rĩ be, ị̃rị̃ rĩ kí bụ́lụ́ ãzí rĩ gá ãzíla ị̃rị̃ rĩ kí bụ́lụ́ ãzí rĩ gá sĩ ife kí usújó sĩ ãlĩtárĩ ujíjó. ");
INSERT INTO luc_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Idé ife sĩ ĩꞌdi ujíjó rĩ báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ ãzíla ase kí ụrụꞌbá la kí gólũdĩ ãlá rĩ sĩ cí. ");
INSERT INTO luc_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Idé kí ãdu ꞌbãlé ndú sĩ drị́ tị̃jó ꞌbá drị̃ gá rĩ ãzíla lũbánĩ ãlá ãjị́ ngụ̃lépi vĩrĩ rĩ be. ");
INSERT INTO luc_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bẹ̃zãlẹ́lị̃ pa kí ãlĩtárĩ ídétáŋá ivélé ivê rĩ drị̂ báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ, ãzo la kí mgbọ la be kí trũ-trũ mítã ị̃rị̃-ị̃rị̃, ãzo la ụrụgâlé ru rĩ mítã ãlu. ");
INSERT INTO luc_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Upa újéke kí ãlĩtárĩ ꞌbã kónã sụ ꞌdĩ kí agâ sĩ pírí, ãlĩtárĩ iꞌdá dó sĩ ãko ãlu rú ãzíla ꞌbu ãlĩtárĩ ụrụꞌbá bũrônzĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Idé ãlĩtárĩ ní úmvú sĩ úfóró iyájó, ãko sĩ ãko ũpẽjó, bãkụ́lẹ̃ sĩ ãko ũyãjó, fókĩ ãmbógó sĩ ĩzá ũsõjó ãzíla sũfũríyã sĩ ãko ụsịjó ãcí drị̃ gá rĩ abe pírí bũrônzĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Idé ãlĩtárĩ ní kẽyĩkéyĩ bũrônzĩ sĩ, ãzíla ímve kí sụ sĩ pá la kí icíjó kónã la sụ ꞌdĩ kí agá. ");
INSERT INTO luc_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Idé ímve kí sụ kónã kẽyĩkéyĩ idélé bũrônzĩ sĩ rĩ drị̂ kí agá sĩ ife sĩ ĩꞌdi ujíjó rĩ kí sujó. ");
INSERT INTO luc_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Idé báwũ ꞌbọ́kọ́lọ̃ drị́ sĩ ĩꞌdi ujíjó rĩ kí ãzíla ase báwũ kí ụrụꞌbá aya bũrônzĩ rú rĩ sĩ, ");
INSERT INTO luc_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ãzíla usú kí ife sĩ ĩꞌdi ujíjó rĩ kí ímve ãlĩtárĩ ꞌbã kónã ãlu-ãlu gá rĩ kí agá. Idé kí ãlĩtárĩ báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ ãzíla ꞌa la lũ mgbọ. ");
INSERT INTO luc_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Bẹ̃zãlẹ́lị̃ idé báfũ sĩ drị́ kí ũjĩjó pá abe rĩ kí pá lã be mãráyã bũrônzĩ rú ũkú ãzị́ ngalépi kẹ̃jị́tị sĩ fijó Hémã tị icíma drị̂ agá rĩ ꞌbã kí fẽlé rĩ kí sĩ. ");
INSERT INTO luc_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ꞌDã ꞌbã ũngúkú gá, Bẹ̃zãlẹ́lị̃ idé lị́cọ́ ꞌa Hémã andre gá ꞌdãá cí. Wókõ la ándrá rĩ zo mítã kãlị́ sụ drị̃ sụ ãzíla bõngó mịfị́ níríŋá rĩ ala gá cí. ");
INSERT INTO luc_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ũgĩ bõngó ꞌdĩ kí gõlĩ sílĩvã rú rĩ sĩ ị́dị́ŋá bũrônzĩ rú kãlị́ ị̃rị̃ usúlé ị̃ndụ́ la bũrônzĩ rú kãlị́ ị̃rị̃ rĩ kí ụrụꞌbá gá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Wókõ la ụ́rụ́ rĩ gá ị́dị́ŋá kãlị́ ị̃rị̃ idélé bũrônzĩ sĩ rĩ kí ãko ị̃ndụ́ la kí usújó ala gá kãlị́ ị̃rị̃ idélé bũrônzĩ sĩ rĩ kí, gõlĩ ãzíla ãko sĩ kí icíjó sílĩvã sĩ rĩ abe. ");
INSERT INTO luc_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Bẹ̃zãlẹ́lị̃ ũgĩ bõngó mítã kãlị́ ị̃rị̃ drị̃ ị̃rị̃ rĩ kí gõlĩ sílĩvã rú rĩ sĩ ị́dị́ŋá mụdrị́ usúlé ị̃ndụ́ la mụdrị́ rĩ kí agá rĩ kí ụrụꞌbá gá, Lị́cọ́ ꞌa ꞌbã wókõ ị̃tụ́ ꞌbã ꞌde agâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Lị́cọ́ ꞌa ꞌbã wókõ sĩ fijó ị̃tụ́ ꞌbã ãfũ agâlé ru rĩ ꞌbã mgbọ mítã kãlị́ ị̃rị̃ drị̃ ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Kẹ̃jị́tị sĩ fijó rĩ ꞌbã wókõ ị̃jị́ gá rĩ gá, bõngó gĩlé rĩ kí ꞌbã ãzo ãni rú mítã ázị̂rị̃, ị́dị́ŋá la kí na ãzíla ãko idélé sĩ ị́dị́ŋá kí ị̃ndụ́ sujó rĩ kí na. ");
INSERT INTO luc_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Bõngó gĩlé kẹ̃jị́tị sĩ fijó lị́cọ́ ꞌa gâlé rĩ ꞌbã wókõ ãndá gá rĩ gá rĩ kí ꞌbã ãzo ãni rú mítã ázị̂rị̃, ị́dị́ŋá la kí na ãzíla ãko idélé sĩ ị́dị́ŋá kí ị̃ndụ́ sujó rĩ kí na. ");
INSERT INTO luc_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Bõngó ũgĩlé lị́cọ́ ꞌa andre gá trộkị́lịrị rĩ kí ídé kí bõngó mịfị́ níríŋá cãlé ãlá la sĩ. ");
INSERT INTO luc_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ãko sĩ ị́dị́ŋá kí ị̃ndụ́ usújó rĩ kí ídé kí bũrônzĩ sĩ, gõlĩ sĩ bõngó kí ũgĩjó rĩ kí ídé kí sílĩvã sĩ, ị́dị́ŋá pírí kí drị̃ âse kí sílĩvã sĩ, ị́jọ́ ꞌdĩ sĩ ị́dị́ŋá lị́cọ́ ꞌa drị̂ kí icí kí kí aya sílĩvã rú rĩ kí sĩ. ");
INSERT INTO luc_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Kẹ̃jị́tị sĩ fijó lị́cọ́ ꞌa gâlé rĩ gá, gĩ bõngó mịfị́ níríŋá uꞌbélé wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika sĩ la kí kátẽnĩ rú mítã úrômĩ ꞌbá bõngó cãlépi rĩ ꞌbã kí cãlé ãlị̃gọ̃ sĩ la kí cí, ");
INSERT INTO luc_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ị́dị́ŋá sụ ãzíla ãko ị́dị́ŋá ị̃ndụ́ usújó sụ idélé bũrônzĩ sĩ rĩ kí abe. Gõlĩ ãzíla ãko sĩ kí icíjó rĩ kí aya ipalé kí ụrụꞌbá gá rĩ kí, ãzíla drị̃kã la abe ase kí sílĩvã sĩ. ");
INSERT INTO luc_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ídé áló Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ gĩjó rĩ drị̂ kí lị́cọ́ ꞌa drị̂ kí abe pírí bũrônzĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ꞌDĩ kí ãko ayúlé Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ agá Sãndụ́kụ̃ tị icíma drị́ írã ꞌbara-ꞌbara ị̃rị̃ sĩ ãzị́táŋá mụdrị́ ꞌdĩ kí tã mbajó ala gá rĩ gá rĩ kî. Mụ́sã fẽ ándrá ãzị́táŋá la ꞌbá Lẹ́vị̃ rú ãzị́ ngalépi Ĩtãmárĩ Ãrọ́nị̃ ngọ́pị átáló ru rĩ drị́. ");
INSERT INTO luc_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bẹ̃zãlẹ́lị̃ Ụ́rị̃ ngọ́pị Hụ́rị̃ umvelépi áyị́pị angálépi sụ́rụ́ Yụ́dã drị̂ agá rĩ idé ãko ꞌdĩ kí pírí Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ꞌBá Bẹ̃zãlẹ́lị̃ ãzã kolépi ãzị́ ꞌdĩ kí ngajó rĩ ĩꞌdi Ũhõlĩyábũ Ãhĩsãmákĩ ngọ́pị sụ́rụ́ Dánĩ drị̂ gá, báwũ kí upalépi, ãko kí uꞌbélépi gbẽtí bụ̃lụ̂, pápũlũ, kãbĩlõ ꞌbíko ika, ãzíla bõngó ãjẹ̃ rú mịfị́ níríŋá rĩ kí abe ãzíla ãlị̃gọ̃ sĩ ãko pírí kí idéjó rĩ trũ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Gólũdĩ fẽlé Ãdróŋá ní ídétáŋá ru ãngũ ãlá Ãdróŋá drị̂ gá rĩ ãnzị la kị́lọ̃ 1,000. ꞌDĩ ãko ãnzị ụ̃ꞌbị̃jó ꞌbá pírí ꞌbã kí ãꞌị̃lé rá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Mụ̃sọ́rọ̃ sílĩvã rú tralé ũꞌbí Ịsịrayị́lị̃ drị̂ kí lãjó rĩ sĩ rĩ tra ru kị́lọ̃ 3,430. ꞌDĩ ãko ãnzị ụ̃ꞌbị̃jó ꞌbá pírí ꞌbã kí ãꞌị̃lé ãngũ ãlápítí rĩ gá rá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Sílĩvã ꞌdĩ tra ru ꞌdĩ áni la kãlãfe ꞌbá lãlé rá rĩ ꞌbadrị̂ 603,550. ꞌBá ílí trũ kãlị́ ị̃rị̃ ꞌbã drị̃lẹ́ gá rĩ ꞌbe kí sẹ̃kẹ́lị̃ ãlu ꞌbã nụ́sụ̃. ꞌDĩ ãko ãnzị ụ̃ꞌbị̃jó ꞌbá pírí ꞌbã kí ãꞌị̃lé ãngũ ãlápítí Ãdróŋá drị̂ gá rá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Bẹ̃zãlẹ́lị̃ ayú sílĩvã kị́lọ̃ 3,400 sĩ ãko ị́dị́ŋá ị̃ndụ́ usújó 100 ãngũ ãlápítí Ãdróŋá drị̂ ní ãzíla ayú kị́lọ̃ kãlị́ na drị̃ sụ sĩ ãko ãlu-ãlu ị́dị́ŋá kátẽnĩ gĩjó rĩ kí ị̃ndụ́ usújó rĩ kí idéjó. ");
INSERT INTO luc_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Bẹ̃zãlẹ́lị̃ ayú sílĩvã ꞌbã ị́mbị́ acelépi kị́lọ̃ kãlị́ na rĩ kí sĩ aya ipalé ife ụrụꞌbá gá rĩ kí, gõlĩ ị́dị́ŋá kí ụrụꞌbá gá rĩ kí ãzíla ãko kí drị̃ akujó rĩ abe rĩ kí idéjó. ");
INSERT INTO luc_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Bũrônzĩ fẽlé Úpí ní ídétáŋá ru rĩ ꞌbã kãlãfe ũꞌbã kí ru kị́lọ̃ 2,425. ");
INSERT INTO luc_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Bẹ̃zãlẹ́lị̃ idé ãko ị́dị́ŋá kí ị̃ndụ́ usújó rĩ kí kẹ̃jị́tị sĩ fijó Hémã tị icíma drị̂ agâlé rĩ ní, ãlĩtárĩ bũrônzĩ sĩ rĩ, kẽyĩkéyĩ la bũrônzĩ sĩ rĩ abe ãzíla ãkójó ala gá rĩ kí abe pírí, ");
INSERT INTO luc_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ãko sĩ ị́dị́ŋá lị́cọ́ ꞌa andre cejó rĩ kí ị̃ndụ́ usújó rĩ kí ãzíla kẹ̃jị́tị fijó lị́cọ́ agâlé rĩ ꞌbadrị̂ kí abe, áló pírí Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ drị̂ ãzíla ãngũ andre la celépi rĩ drị̂ kí idé kí bũrônzĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Bẹ̃zãlẹ́lị̃, Ũhõlĩyábũ ãzíla ꞌbá ãlịgọ rú rĩ ịgbẹ kí bõngó gbẽtí bụ̃lụ̂, pápũlũ, ika, ãzíla bõngó mịfị́ cãlé níríŋá rĩ abe sĩ ãzị́ ngajó Ãngũ Ãlá rĩ gá rĩ kî. Idé kí vâ Ãrọ́nị̃ ní bõngó sĩ ĩꞌdi ꞌbãjó ndú rĩ kí cécé Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bẹ̃zãlẹ́lị̃ ịgbẹ kí ĩfódĩ bõngó mịfị́ níríŋá rĩ sĩ, uꞌbé kí ĩꞌdi wị́zị̃ gólũdĩ rú dị̃lépi lẽrẽlẽrẽ, wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika rĩ kí sĩ. ");
INSERT INTO luc_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Dị kí gólũdĩ ꞌbara rú, ũsĩ kí ĩꞌdi wị́zị̃ rú ĩzíŋá-ĩzíŋá ru idé kí dó sĩ bõngó ãjẹ̃ rú mịfị́ níríŋá rĩ wị́zị̃ bụ̃lụ̂, pápũlũ, ika rĩ kí sĩ ũniyambamba rú ãlị̃gọ̃ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Idé kí ĩfódĩ ꞌbã kọ́trọ́ drị̃ gá bõngó ĩbáká kí ị̃rị̃, icí kí dó kí kónã la kí agá sĩ ĩꞌdi icíjó. ");
INSERT INTO luc_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ꞌBá ãlịgọ rú rĩ ayú kí wị́zị̃ gólũdĩ rú, wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ, ika ãzíla bõngó mịfị́ níríŋá rĩ kí sĩ sẹ́rị̃ cãjó, ící sẹ́rị̃ kí ĩfódĩ be ãlu cécé Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ũdrõ kí ãlị̃gọ̃ sĩ írã únĩkĩsĩ rú dị̃lépi gị̃lị̃gị̃lị̃ ãjẹ̃ rú rĩ kí gólũdĩ ꞌbele-ꞌbele rĩ kí sĩ ãzíla ũsĩ kí anzị Ịsịrayị́lị̃ drị̂ kí rụ́ kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ꞌDã ꞌbã ũngúkú gá, ịgbẹ kí dó kí ĩfódĩ ꞌbã kọ́trọ́ gá anzị Ịsịrayị́lị̃ drị̂ kí igájó cécé Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ịgbẹ kí bõngó jụ́jụ́ gá rĩ ãlị̃gọ̃ sĩ cécé ĩfódĩ ịgbẹjó rĩ áni. Ayú kí wị́zị̃ gólũdĩ rú, wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ, ika ãzíla bõngó mịfị́ níríŋá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Bõngó jụ́jụ́ gá rĩ ꞌbã ãzo la kí mgbọ la abe trũ-trũ, agbọ́ kí ĩꞌdi ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ũꞌbã kí ụrụꞌbá la gá írã pãrã-pãrã la kí láyĩnĩ sĩ sụ. Láyĩnĩ iꞌdójó rĩ gá ũꞌbã kí írã rụ́bị̃, tõpázĩ, ãzíla ĩmẽrálĩdĩ rú rĩ kî; ");
INSERT INTO luc_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","láyĩnĩ ị̃rị̃ rĩ gá írã tãkụ́sẹ̃, sãfírẽ, ãzíla dáyímõndĩ rú rĩ kî; ");
INSERT INTO luc_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","láyĩnĩ na rĩ gá írã jãsị̃nị́tọ̃, ágãtẽ, ãzíla írã ãmẹ̃tẹ̃sị́tọ̃ rú rĩ kî; ");
INSERT INTO luc_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","láyĩnĩ sụ rĩ gá írã kụ̃rị̃sị̃lị́tọ̃, únĩkĩsĩ ãzíla yãsípẽ rú rĩ kî. Ụ̃tị̃ kí írã ꞌdĩ kí gólũdĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Írã kí mụdrị́ drị̃ ị̃rị̃, írã ãlu-ãlu drị̃ gá ũsĩ kí anzị Ịsịrayị́lị̃ drị̂ kí rụ́; rụ́ ꞌdĩ tu kí pá ínátị mụdrị́ drị̃ ị̃rị̃ ꞌdĩ kí kẹ̃jị́ gá. ");
INSERT INTO luc_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Idé kí bõngó jụ́jụ́ gá rĩ ní nõrórõ cécé ĩbáká áni la gólũdĩ ãlá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Idé kí ãko sĩ kí icíjó la kí gólũdĩ ãlá rĩ sĩ ị̃rị̃, ríŋĩ kí ị̃rị̃ ãzíla gĩ kí dó kí bõngó jụ́jụ́ gá rĩ ꞌbã kónã ị̃rị̃ rĩ kí agá. ");
INSERT INTO luc_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ũgĩ kí nõrórõ gólũdĩ rú ị̃rị̃ ꞌdĩ kí ríŋĩ ꞌba rú bõngó jụ́jụ́ gá rĩ ꞌbã kónã kí gá, ");
INSERT INTO luc_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ãzíla nõrórõ gólũdĩ rú rĩ ꞌbã tị ãsị̃jó rĩ kí icí kí ĩfódĩ ꞌbã ĩbáká kọ́trọ́ drị̃ gá uꞌbélé gólũdĩ sĩ rĩ kí gá. ");
INSERT INTO luc_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Idé kí ríŋĩ gólũdĩ sĩ la kí ị̃rị̃ ãzíla ũgĩ kí dó kí bõngó jụ́jụ́ gá rĩ ꞌbã kónã ị̃rị̃ rĩ kí tị gá agâlé ru ĩfódĩ rụ̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Idé kí ríŋĩ gólũdĩ sĩ la ꞌbã ãzí kí ị̃rị̃, icí kí dó kí bõngó kọ́trọ́ gá rĩ ꞌbã ị̃ndụ́lé gá ĩfódĩ ꞌbã mẹ́lẹ́tị gá ꞌdõlé ru, ãni rú ãngũ ĩꞌbã kí sĩ ru ịsụ́jó rĩ gá sẹ́rị̃ cãlé mịfị́ níríŋá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Umbé kí ríŋĩ bõngó jụ́jụ́ gá rĩ drị̂ kí ríŋĩ ĩfódĩ drị̂ kí gá ĩbáká bụ̃lụ̂ ĩꞌdi icílépi sẹ́rị̃ be bõngó jụ́jụ́ gá rĩ ꞌbã aya dó sĩ ru ĩfódĩ rụ́ ꞌdâ ku cécé Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ịgbẹ kí kọ́tị̃ ãzí ĩfódĩ sụ̃jó drị̃ la gá rĩ ãndá la bõngó bụ̃lụ̂ rĩ sĩ, ");
INSERT INTO luc_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ꞌbụ́ trũ ágágá drị̃kã ní sĩ fijó. Tị la ꞌbụ́ ru imbe gá ãzíla drị́ gá ꞌdĩ kí ci kí dó kí cĩcĩ kálã gá rĩ áni, ꞌbã uce kí rú sĩ ku. ");
INSERT INTO luc_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ũꞌbã kí ife põmũgũránãtĩ drị̂ ꞌbã íꞌdá wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika ãzíla bõngó mịfị́ níríŋá cãlé ãlá rĩ kọ́tị̃ tị gâsĩ trộkị́lịrị ũlángí gólũdĩ rú la trũ kí drĩdríŋĩ gá cí. ");
INSERT INTO luc_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Uꞌbé kí kọ́tị̃ ꞌbã imbe tị ife põmũgũránãtĩ drị̂ ꞌbã íꞌdá sĩ ãzíla ũꞌbã kí dó íꞌdá ũlángí idélé gólũdĩ ãlá rĩ sĩ rĩ drị̂ kí ife põmũgũránãtĩ drị̂ kí drĩdríŋĩ gâsĩ trộkị́lịrị. ");
INSERT INTO luc_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ci kí ũlángí íꞌdá kí ife põmũgũránãtĩ drị̂ ꞌbã íꞌdá trũ kọ́tị̃ Ãrọ́nị̃ ꞌbã sụ̃lé sáwã ĩꞌdiní ãzị́ ngajó rĩ sĩ rĩ tị gâsĩ trộkị́lịrị cécé Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ꞌBá ãlịgọ rú rĩ ịgbẹ kí Ãrọ́nị̃ ꞌbaní ngọ́pịka abe kánzũ, ");
INSERT INTO luc_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","kõfíyã drị̃ gá rĩ, bõngó sĩ drị̃ umbéjó rĩ abe ãzíla bõngó ãlị́ sụ̃lé pájãmã drị̃ gá rĩ kí trũ. ");
INSERT INTO luc_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Idé kí sẹ́rị̃ umbélé ụ́pị́cẹ́ gá rĩ ãlị̃gọ̃ sĩ wị́zị̃ gbẽtí bụ̃lụ̂, pápũlũ ãzíla ika ãzíla bõngó mịfị́ níríŋá rĩ sĩ. Ịgbẹ kí dó kí lị́bị̃rã sĩ cécé Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Idé kí sãánĩ gólũdĩ ãlá rĩ sĩ ãzíla sĩ kí drị̃ la gá: Ãlá ru Úpí Nî. ");
INSERT INTO luc_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ꞌDã ꞌbã ũngúkú gá, umbé kí gólũdĩ ãlá dịlé ꞌbara rĩ bõngó ĩbáká sĩ drị̃ umbéjó bụ̃lụ̂ rĩ sĩ kõfíyã Ãrọ́nị̃ drị̂ ꞌbã mẹ́lẹ́tị gá cécé Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ị́jọ́ ꞌdĩ sĩ anzị Ịsịrayị́lị̃ drị̂ de kí dó ãzị́ Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ drị̂ rá. Idé kí dó cécé Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ꞌDã ꞌbã ũngúkú gá, ají kí dó Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ ãko ala gá rĩ kí abe pírí Mụ́sã drị̃lẹ́ gá: Hémã ꞌi, gõlĩ la kí, báwũ la kí, báwũ alalé alâ rĩ kí, ị́dị́ŋá la kí; ãzíla ãko sĩ ị́dị́ŋá kí ị̃ndụ́ sujó rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Ãko sĩ drị̃ la akujó rĩ kãbĩlõ ágó íní vúlé rángi ika rĩ sĩ, ãnãkpá íníríkó ãlá la, kátẽnĩ; ");
INSERT INTO luc_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ife sĩ Sãndụ́kụ̃ tị icíma drị̂ ujíjó rĩ kí úmvúke ásị́ ị̃gbẹ̃ drị̂ be. ");
INSERT INTO luc_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Méjã ꞌi ãko pírí ĩꞌdidrị̂ kí abe ãzíla mũkátĩ ndú fẽlé Ãdróŋá ní rĩ abe. ");
INSERT INTO luc_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Tárã céke idélé gólũdĩ ãlá sĩ rĩ, tárã kí ãdu la abe ãzíla ãko pírí ĩꞌdidrị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Ãlĩtárĩ idélé gólũdĩ sĩ rĩ, ãdu sĩ drị́ tị̃jó ꞌbá drị̃ gá rĩ, lũbánĩ ãjị́ ngụ̃lépi vĩrĩ rĩ ãzíla kátẽnĩ kẹ̃jị́tị sĩ fijó Hémã Ãdróŋá Ị̃nzị̃jó rĩ drị̂ gá rĩ; ");
INSERT INTO luc_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Ãlĩtárĩ idélé bũrônzĩ sĩ rĩ, kẽyĩkéyĩ idélé aya bũrônzĩ rú rĩ sĩ rĩ; ife sĩ ĩꞌdi ujíjó rĩ kí ãkójó la kí abe; báfũ bũrônzĩ rú rĩ pá la kí abe; ");
INSERT INTO luc_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","kátẽnĩ sĩ Bõrõ lị́cọ́ ꞌa atrịjó rĩ kí, báwũ ị́dị́ŋá rú rĩ kí, ãko la sĩ ị̃ndụ́ la kí usújó rĩ kí abe, kátẽnĩ gĩlé kẹ̃jị́tị sĩ fijó lị́cọ́ agá rĩ drị̂ kí; ĩbáká hémã drị̂ kí áló la kí abe, ãzíla ãko pírí ayúlé sĩ ị̃nzị̃táŋá idéjó Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ agá rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Bõngó cãlé ãlá ãtalo ꞌbaní sụ̃lé sĩ ãzị́ ngajó Ãngũ Ãlá rĩ gá, átáló Ãrọ́nị̃ ꞌbaní anzị ĩꞌdidrị̂ abe rĩ. ");
INSERT INTO luc_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ꞌBá Ịsịrayị́lị̃ drị̂ nga kí ãzị́ ꞌdĩ kí pírí cécé Úpí ꞌbã azịlé Mụ́sã nî rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mụ́sã undré ãko ꞌdĩ kí pírí ãzíla ịsụ́ dó ãko ꞌdĩ idé kí dó ru cécé Úpí ꞌbã azịlé ĩꞌdiní rĩ áni. Ị́jọ́ ꞌdĩ sĩ, wi dó sĩ ĩꞌbaní sụ̃sụ́. ");
INSERT INTO luc_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ní, ");
INSERT INTO luc_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ĩmbá ãlu ꞌbã ụ́ꞌdụ́ ãlu sĩ, mí ĩdrẽ Hémã sĩ áma ị̃nzị̃jó rĩ ụrụgá. ");
INSERT INTO luc_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Íꞌbã Sãndụ́kụ̃ tị icíma drị́ sĩ ãzị́táŋá mụdrị́ rĩ kí ꞌbãjó ala gá rĩ ala gá, ãzíla mí atrị ĩꞌdi kátẽnĩ sĩ cí. ");
INSERT INTO luc_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Mí ají méjã jó agá ãzíla mí ũꞌbã ãko drị̃ la gá rĩ kî. Mí ají vâ tárã céke kí ãzíla mí ũꞌbã tárã kí drị̃ la gá. ");
INSERT INTO luc_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Íꞌbã ãlĩtárĩ gólũdĩ rú sĩ lũbánĩ ivéjó rĩ Sãndụ́kụ̃ tị icíma drị̂ drị̃lẹ́ gá ãzíla ígĩ kátẽnĩ kẹ̃jị́tị sĩ fijó Hémã sĩ áma ị̃nzị̃jó rĩ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Íꞌbã ãlĩtárĩ sĩ ídétáŋá ivélé ivê rĩ kí ivéjó rĩ kẹ̃jị́tị sĩ fijó Hémã sĩ áma ị̃nzị̃jó rĩ drị̂ ꞌbã drị̃lẹ́ gá; ");
INSERT INTO luc_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","íꞌbã báfũ sĩ ãko ũjĩjó rĩ Hémã sĩ áma ị̃nzị̃jó rĩ kí drĩdríŋĩ gá ãlĩtárĩ be ãzíla ísũ ị̃yị́ ala gá cí. ");
INSERT INTO luc_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Mí idé lị́cọ́ ꞌa andre la gá trộkị́lịrị ãzíla ígĩ kátẽnĩ kẹ̃jị́tị la sĩ fijó lị́cọ́ agá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Íꞌdụ ãdu sĩ drị́ tị̃jó ꞌbá drị̃ gá rĩ ãzíla mí ũsũ ĩꞌdi Hémã sĩ áma ị̃nzị̃jó rĩ drị̃ gá, ãko ala gá rĩ kí abe pírí; íꞌbã Hémã ꞌdĩ ãko ala gá rĩ kí abe pírí ndú ãzíla ĩꞌdi dó sĩ adru ãlá ru. ");
INSERT INTO luc_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ꞌDã ꞌbã ũngúkú gá, íꞌbã ãlĩtárĩ ídétáŋá ivélé ivê rĩ drị̂ ndú ãzíla mí ũsũ ãdu drị̃ la gá, ꞌbã adru sĩ pírí ãlá ru ãndânĩ. ");
INSERT INTO luc_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Mí ũsũ ãdu báfũ drị̃ gá ãzíla pá la sĩ ĩꞌdi ꞌbãjó rĩ abe sĩ kí ꞌbãjó ndú. ");
INSERT INTO luc_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Mí ají Ãrọ́nị̃ kí ngọ́pịka abe kẹ̃jị́tị sĩ fijó Hémã tị icíma drị̂ agá rĩ gá ãzíla mí ũjĩ kí ị̃yị́ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Mí ụ̃sụ̃ Ãrọ́nị̃ bõngó ĩꞌdidrị́ átáló drị̂ kí agá, mí ũsũ ãdu drị̃ la gá ãzíla gẹ̃rị̃ ꞌdĩ sĩ mi ĩꞌdi ꞌbã ãlá ru ndú, ị́jọ́ ꞌdĩ sĩ ĩꞌdi dó sĩ ãzị́ nga mání átáló ru. ");
INSERT INTO luc_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Mí ají ngọ́pịka kí, ãzíla mí ụ̃sụ̃ kí kánzũ sĩ. ");
INSERT INTO luc_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Mí ũsũ vâ ãdu kí drị̃ gá míní tá idélé átẹ́pị̃ ụrụꞌbá gá rĩ áni, ị́jọ́ ꞌdĩ sĩ kí dó sĩ ãzị́ nga mání átáló ru. Ãdu ũsũlé kí drị̃ gá ꞌdĩ la kí ꞌbã adrujó átáló ru anzị ĩꞌbadrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe jãꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mụ́sã idé ị́jọ́ Úpí ꞌbã azịlé ĩꞌdiní rĩ kí pírí rá. ");
INSERT INTO luc_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ị́jọ́ ꞌdĩ sĩ úde dó Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ sị agá ĩmbá ãlu ꞌbã ĩmbá ụ́ꞌdụ́ ãlu sĩ ꞌdĩ ílí ị̃rị̃ ĩꞌbaní Mị̃sị́rị̃ aꞌbejó ꞌbo rĩ ꞌbã vúlé gá. ");
INSERT INTO luc_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mụ́sã la mụ Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ ꞌbã sịŋá delé ꞌbo, ũꞌbã ãko ị́dị́ŋá kí ị̃ndụ́ usújó rĩ kí ĩꞌbadrị́ ãngũ gá, umbé báwũ alalé alâ rĩ kî, ãzíla usú dó ị́dị́ŋá la kî. ");
INSERT INTO luc_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Aja bõngó idélé ị̃ndrị́ ꞌbíko sĩ sĩ Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ drị̃ akujó ãzíla ꞌbe Hémã drị̃ ãmvé-ãmvélé ru rĩ bõngó Hémã drị̃ akujó rĩ sĩ cí cécé Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ꞌDã ꞌbã ũngúkú gá, ꞌdụ írã tị icíma drị̂ kí, ꞌbã kí Sãndụ́kụ̃ tị icíma drị̂ agá. Usú ife sĩ ĩꞌdi ujíjó rĩ kí ímve Sãndụ́kụ̃ ꞌbã bụ́lụ́ gá rĩ kí gá ãzíla ụ̃pị̃ dó tị la úmvúke ásị́ ị̃gbẹ̃ drị̂ sĩ cí. ");
INSERT INTO luc_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ají dó Sãndụ́kụ̃ Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ drị̂ agá, ãzíla ũgĩ dó kátẽnĩ sĩ Sãndụ́kụ̃ tị icíma drị̂ atrịjó rĩ, atrị dó sĩ ĩꞌdi cí cécé Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mụ́sã ꞌbã dó méjã Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ Ãngũ Ãlá rĩ ꞌbã wókõ ụ́rụ́ rĩ gá kátẽnĩ gĩlé ꞌa gâsĩ rĩ ꞌbã wókõ ãmvélé ãmvélé ru rĩ gá, ");
INSERT INTO luc_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ãzíla ꞌbã drị̃ la gá mũkátĩ fẽlé Úpí ní rĩ, cécé Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ꞌDã ꞌbã ũngúkú gá, Mụ́sã ꞌbã dó tárã céke kí Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ agá Ãngũ Ãlá rĩ ꞌbã wókõ ándrá rĩ gá, ndre kí ru méjã be. ");
INSERT INTO luc_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ꞌBã tárã kí tị Úpí drị̃lẹ́ gá, cécé Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ꞌBã dó ãlĩtárĩ gólũdĩ rú rĩ Hémã tị icíma drị̂ rĩ agâlé, kátẽnĩ drị̃lẹ́ gá ");
INSERT INTO luc_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ãzíla ivé lũbánĩ ãjị́ ngụ̃lépi vĩrĩ rĩ drị̃ la gá Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Mụ́sã gĩ dó kátẽnĩ kẹ̃jị́tị sĩ fijó Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ agá rĩ gá, ");
INSERT INTO luc_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ãzíla kẹ̃jị́tị sĩ fijó Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ agâlé rĩ ꞌbã drị̃lẹ́ gá ꞌdãá ꞌbã dó ãlĩtárĩ ídétáŋá ivéjó rĩ. Idé dó ídétáŋá ivélé ivê rĩ drị̃ la gá ãzíla ídétáŋá ãnáfóró sĩ rĩ abe cécé Úpí ꞌbã azịlé ĩꞌdiní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ꞌDã ꞌbã ũngúkú gá, Mụ́sã ꞌbã báfũ ãko ũjĩjó rĩ Hémã tị icíma drị̂ rĩ kí drĩdríŋĩ gá ãlĩtárĩ be, sũ dó ị̃yị́ ala gá tré sĩ ãko kí ũjĩjó. ");
INSERT INTO luc_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mụ́sã kí Ãrọ́nị̃ be ãzíla anzị Ãrọ́nị̃ drị̂ kí trũ kí ru drị́ kí ũjĩ pá abe ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Kí drị́ kí ũjĩ pá abe drĩ kí lẽ filé Hémã tị icíma drị̂ rĩ agâlé jõku acájó ãni rú ãlĩtárĩ andre gá, Úpí ꞌbã azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Mụ́sã ce dó Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ ꞌi, ãlĩtárĩ ãzíla lị́cọ́ ꞌa ꞌbã andre bõngó ãjẹ̃ rú mịfị́ níríŋá rĩ sĩ trộkị́lịrị ãzíla gĩ kátẽnĩ kẹ̃jị́tị sĩ fijó lị́cọ́ ꞌa gâlé rĩ gá cí. De dó ãzị́ kí pírí rá. ");
INSERT INTO luc_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ꞌDã ꞌbã ũngúkú gá, ụ̃rụ́ꞌbụ̃ ãnzị la aku dó Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ drị̃ cí, ãzíla dị̃zã Úpí drị̂ ga dó ꞌa lã gá tré. ");
INSERT INTO luc_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ị́jọ́ ꞌdĩ sĩ Mụ́sã icó dó filé Hémã sĩ Ãdróŋá Ị̃nzị̃jó rĩ agâlé ku, ãꞌdusĩku ụ̃rụ́ꞌbụ̃ aku Hémã drị̃ cí ãzíla dị̃zã Úpí drị̂ ga ꞌa lã gá tré. ");
INSERT INTO luc_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ãcị̃ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbadrị̂ kí agá pírí, ụ̃rụ́ꞌbụ̃ drĩ ru inga Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ drị̃ gá ꞌdãá rĩ sĩ mụlé ãngũ ãzí gá rá, kí ĩꞌdi vú bĩ ĩndĩ; ");
INSERT INTO luc_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","wó ụ̃rụ́ꞌbụ̃ drĩ ru inga ku icó kí drị̃ kolé ku kpere ụ́ꞌdụ́ ĩꞌdi ꞌbã ru ingajó mụjó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ãcị̃ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbadrị̂ kí agá pírí, kí ị̃tụ́ sĩ ụ̃rụ́ꞌbụ̃ Úpí drị̂ ndre, ãzíla ị́nị́ sĩ kí ãcí ndre dị̃ agá ụ̃rụ́ꞌbụ̃ agá Hémã sĩ Ãdróŋá ị̃nzị̃jó rĩ drị̂ drị̃ gá.");
INSERT INTO luc_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ꞌDĩ kí ị́jọ́ Mụ́sã ꞌbã jọlé ꞌbá pírí Ịsịrayị́lị̃ drị̂ ꞌbaní ãngũ kõtórõ rú Ị̃yị́ Yõrĩdánĩ drị̂ ꞌbã wókõ ị̃tụ́ ꞌbã ãfũ agâlé ru rĩ gá rĩ kî, ꞌdĩ ãngũ Ãrábã ꞌi ru ndrelépi Sụ́fụ̃ be Pãránĩ kí drĩdríŋĩ gá Tọ́fẹ̃lị̃ be Lãbánĩ, Hãzẹ̃rọ́tị̃ ãzíla Dĩzãhábũ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Ãcị̃ ꞌdĩ ꞌdụ ụ́ꞌdụ́ mụdrị́ drị̃ ãlu ꞌdĩ iꞌdójó Hõrébũ gá sĩ cajó Kãdẹ́sị̃ Bãrĩnéyã gá ꞌdĩ gẹ̃rị̃ mụlépi ꞌBé Sẽyírĩ gâsĩ rĩ ꞌi.) ");
INSERT INTO luc_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Ílí kãlị́ sụ ꞌbá Ịsịrayị́lị̃ drị̂ bã kí ãngũ Mị̃sị́rị̃ drị̂ aꞌbejó ꞌbo rĩ ꞌbã vúlé gá ĩmbá mụdrị́ drị̃ ãlu ꞌbã ĩmbá ụ́ꞌdụ́ ãlu rĩ sĩ, Mụ́sã ũlũ ị́jọ́ Úpí ꞌbã ãzị́táŋá la kí fẽjó ĩꞌdiní ꞌbá Ịsịrayị́lị̃ drị̂ kí ị́jọ́ sĩ rĩ kí pírí rá. ");
INSERT INTO luc_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Ị́jọ́ ꞌdĩ idé kí ru Mụ́sã ꞌbã úpí Sị̃họ́nị̃ sụ́rụ́ Ãmọ́rị̃ drị́ ũpĩ nalépi Hẹ̃sị̃bọ́nị̃ gá rĩ ndẽjó ꞌbo ãzíla ĩꞌdi ꞌbã úpí Ụ́gị̃ Bãsánĩ drị́ ũpĩ nalépi táwụ̃nị̃ Ãsị̃tãrọ́tị̃ ꞌbadrị́ Ị̃drẹ́yị̃ be rĩ kí ndẽjó ꞌbo rĩ ꞌbã vúlé gá. ");
INSERT INTO luc_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Yõrĩdánĩ ꞌbã wókõ ị̃tụ́ ꞌbã ãfũ agâlé ru ꞌdĩ sụ́rụ́ Mụ̃wábụ̃ drị̂ agá, Mụ́sã iꞌdó ándrá dó ị́jọ́ jọlé ãzị́táŋá ꞌdĩ kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Úpí Ãdróŋá ãmadrị̂ jọ ãmaní ꞌBé Hõrébũ gá ꞌdãá, ‘Ĩmi uꞌá dó ꞌbé ꞌdĩ gá ꞌdâ sáwã ãzo rú ꞌbo. ");
INSERT INTO luc_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Ĩmi aꞌbe kámbĩ ꞌdĩ ꞌi ãzíla ĩko drị̃ mụlé ãngũ ꞌbé ꞌa rú Ãmọ́rị̃ ꞌbadrị̂ agâlé, ĩmụ ꞌbá pírí jĩránĩ rú Ãrábã gá rĩ ꞌba rụ́ ꞌbé agâlé, ꞌbé ꞌbã pá ị̃tụ́ ꞌbã ꞌde agâlé ru rĩ gá, ꞌdĩ Nẹ̃gẹ́vụ̃ gá ị̃yị́ tị gá ãngũ ꞌbá Kãnánĩ gá rĩ ꞌbadrị̂ gá ãzíla Lébãnõnĩ gá cajó kpere ị̃yị́ ãmbógó Ũfũrátĩ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ĩndre, áfẽ ãngũ ꞌdĩ pírí ĩminî. Ĩfi ala gâlé, ĩꞌdụ ãngũ Úpí ꞌbã ũyõ la najó ꞌi fẽ la ãmã áyị́pịka Ịbụrahị́mụ̃, Ĩsákã ãzíla Yãkóꞌbõ ꞌbaní anzị ĩꞌbadrị́ drị̃lẹ́ gâlé rĩ abe rĩ gá.’” ");
INSERT INTO luc_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Sáwã ãmaní ándrá drĩ adrujó ꞌbé Sĩnáyĩ gá rĩ sĩ, ájọ ándrá ĩminí, ‘Ãzị́ adrujó drị̃lẹ́ ru sĩ ꞌbá kí drị̃ cejó rĩ mání ambamba. Má icó ĩꞌdi ngalé áꞌdụ̂sĩ ku. ");
INSERT INTO luc_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Úpí Ãdróŋá ĩmidrị̂ fẽ ĩtị dó wẽwẽ rú cécé lẽlẽgó ꞌbụ̃ gá rĩ kî áni. ");
INSERT INTO luc_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Lẽ Úpí Ãdróŋá ãmã áyị́pịka ꞌbadrị̂ ꞌbã fẽ ĩminí tịjó pâlé álĩfũ ãlu sĩ ãzíla ꞌbã wi ĩminí sụ̃sụ́ ĩꞌdi ꞌbã ándrá azịlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Wó má icó ị́jọ́ ĩmi rụlépi, ị́jọ́ ĩmi nũlépi ãzíla ĩmi ịsụ́lépi rĩ kí ãzã kolé ma ꞌi áꞌdụ̂sĩ íngoní-íngoní ru? ");
INSERT INTO luc_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Ĩmi ũpẽ ãgọbị kí agá ꞌbá ũndũwã rú ị́jọ́ vãlépi rá ãzíla rulé rũrũ la kí ínátị ãlu-ãlu agá ãzíla ma dó sĩ kí ꞌbã adrulé ĩmi drị̃lẹ́ gá.’ ");
INSERT INTO luc_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","“ꞌDã ꞌbã ũngúkú gá, ĩmi umvi ándrá ma, ‘Ị́jọ́ míní jọlé ãmaní ꞌdĩ ĩꞌdi ị́jọ́ múké la.’ ");
INSERT INTO luc_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","“Ị́jọ́ ꞌdĩ sĩ, áꞌdụ dó ꞌbá ũndũwã rú ĩminí ũpẽlé ínátị kí agâlé ꞌbá drị̃lẹ́ ru rulé rũrũ ꞌdĩ kí, áꞌbã dó sĩ kí ĩminí drị̃lẹ́ ru. Áꞌbã ãzí rĩ kí drị̃lẹ́ ru ꞌbá álĩfũ kí drị̃lẹ́ gá, ãzí rĩ kí ꞌbá túrú ãlu kí drị̃lẹ́ gá, ãzí rĩ kí ꞌbá kãlị́ tõwú kí drị̃lẹ́ gá, ꞌbá mụdrị́ kí drị̃lẹ́ gá. Áꞌbã ãzí rĩ kí ãmbogo rú ínátị kí drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Ụ́ꞌdụ́ ꞌdã sĩ áꞌbã ĩmi kí drị̃lẹ́ gá ꞌbá ị́jọ́ amálépi rĩ kî rú ãzíla ájọ, ‘Ĩmi itú ị́jọ́ ĩmĩ ádrị́pịka ãzíla ámvọ́pịka kí drĩdríŋĩ gá rĩ kí ãzíla ĩlị ị́jọ́ la kí ásị́ ị̃gbẹ̃ sĩ, drĩ táni adru ị́jọ́ la rụ mî ádrị́pị Ịsịrayị́lị̃ rú rĩ ꞌi jõku ꞌbá ãzí ndú ãmị́yọ́ŋá ru la. ");
INSERT INTO luc_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Ílị ị́jọ́ mũlũmbẽ sĩ ku, íꞌdụ ꞌbá pírí kí trũ-trũ uyaŋá kóru. Mí idé ꞌbá ãzí sĩ ụ̃rị̃ sĩ ku, ãꞌdusĩku ꞌbá ị́jọ́ lịlẹ́pi rĩ ĩꞌdi Ãdróŋá ꞌi. Ị́jọ́ ũkpó ĩmi ndẽlépi rá rĩ kí ĩmi ajị́ kí áma drị̃lẹ́ gá, ma mụ kí ukólé ma ꞌi.’ ");
INSERT INTO luc_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Sáwã ꞌdã sĩ álũ ándrá ĩminí ị́jọ́ pírí ĩminí mụlé idélé rĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“Ị́jọ́ ꞌdã kí ũngúkú gá, Úpí Ãdróŋá ãmadrị̂ fẽ ãmaní ãzị́táŋá, ãko dó sĩ drị̃ Hõrébũ gá ꞌdãá rĩ sĩ mụlé ãngũ ꞌbé ꞌa rú sụ́rụ́ ꞌbá Ãmọ́rị̃ ꞌbadrị̂ agâ sĩ ꞌdĩ ãngũ ꞌbâ kóru ãzíla ãngũ sĩ icójó idéjó ụ̃rị̃ sĩ kõtórõ rú ĩminí ndrelé ĩmi mịfị́ sĩ cé rĩ áni, ãzíla ꞌdãá rĩ sĩ ãca dó Kãdẹ́sị̃ Bãrĩnéyã gá. ");
INSERT INTO luc_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Ị́jọ́ ꞌdĩ sĩ, ájọ ĩminí, ‘Ĩmi acá dó ãngũ ꞌbé ru sụ́rụ́ ꞌbá Ãmọ́rị̃ rú rĩ ꞌbadrị́ Úpí Ãdróŋá ãmadrị̂ ꞌbã mụlé fẽlé ãmaní rĩ gá ꞌbo. ");
INSERT INTO luc_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Índre, Úpí Ãdróŋá mídrị̂ fẽ míní ãngũ ꞌdĩ ꞌbo. Ímụ ãzíla íꞌdụ ĩꞌdi mî ãni la rú, cécé Úpí Ãdróŋá mî áyị́pịka ꞌbadrị̂ ꞌbã jọlé rĩ áni. Mí idé ụ̃rị̃ sĩ ku jõku mí ịsụ́ ũkpõ ãkõ ku.’ ");
INSERT INTO luc_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","“Wó ĩmi amụ́ má rụ́ ꞌdõlé ãzíla ĩjọ mání, ‘Lẽ ãpẽ kí ꞌbá ũní-ũníŋá gá la kí tị drị̃lẹ́ gâlé ị́jọ́ ãngũ ꞌdã gá rĩ kí ị̃ndụ́ ndrụ̃lé sĩ ãmaní ị́jọ́ la ajíjó vúlé ãma rụ́ ꞌdõlé gẹ̃rị̃ ãmaní mụlé ꞌdụlé rĩ ãzíla táwụ̃nị̃ ãmaní sĩ mụjó ala gá rĩ kí abe.’ ");
INSERT INTO luc_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","“Ígátáŋá ꞌdĩ iꞌdá mání rĩ gá múké, ị́jọ́ ꞌdĩ sĩ, má ũpẽ dó sĩ ĩmi agá ꞌbá kí mụdrị́ drị̃ ị̃rị̃, ꞌbá ãlu-ãlu angájó ínátị ĩꞌdidrị̂ agá. ");
INSERT INTO luc_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Aꞌbe kí dó ãngũ ꞌdã rá ãzíla mụ kí dó ãngũ ꞌbé ru rĩ agâlé, ca kí dó áꞌbụ Ị̃sị̃kọ́lị̃ rĩ gá ãzíla acị́ kí dó ꞌa la ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Ají kí ife ífí nalé nãnã ãngũ ꞌdã agá rĩ kí kí drị́ gá ĩndĩ, ají kí kí ãma rụ́ ꞌdõlé ĩꞌbã kí ụ́ꞌdụ́kọ́ ãngũ ꞌdã gâlé rĩ kí ajíjó ãmaní rĩ sĩ, ‘Ãngũ Úpí Ãdróŋá ãmadrị̂ ꞌbã fẽlé ꞌdã ĩꞌdi ãngũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ ãlá la.’ ");
INSERT INTO luc_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“Wó ĩlẽ ándrá mụlé ku ĩminí ãzị́táŋá Úpí Ãdróŋá ĩmidrị̂ drị̂ kí gãjó úmgbé rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Ĩmi unu ándrá hémã ĩmidrị̂ kí agâlé ãzíla ĩjọ, ‘Úpí lẽ ãma ku; ị́jọ́ ꞌdĩ sĩ anzé dó sĩ ãma angájó Mị̃sị́rị̃ gâlé ãma fẽjó ꞌbá Ãmọ́rị̃ drị̂ kí drị́ alé agá sĩ ãma uꞌdị́jó. ");
INSERT INTO luc_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Ãma dó mụ íngõlé? Ãmã ádrị́pịka fẽ kí ãma ásị́ ní umvúlé rá. Jọ kí, “ꞌBá ꞌdã kí ũkpó ru ãzíla zo kí ãmaní ãndânĩ, táwụ̃nị̃ ĩꞌbadrị̂ kí ãmbógó ru ãzíla Bõrõ la kí ụrụgá wị́lị́wị́lị́ kpere ꞌbụ̃ gâlé. Ãndre vâ ꞌbá Ãnákĩ drị̂ kí ꞌdãá rá.”’ ");
INSERT INTO luc_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“Wó ájọ ĩminí, ‘Ĩmi ụrụꞌbá ꞌbã yã ku, ĩmi idé kí sĩ ụ̃rị̃ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Úpí Ãdróŋá ĩmidrị̂ la mụ ĩmi drị̃lẹ́ gá, ĩꞌdi mụ ãꞌdị́ ꞌdịlé ĩminí cécé ĩꞌdi ꞌbã ándrá idélé ĩmi drị̃ gâsĩ Mị̃sị́rị̃ gá ");
INSERT INTO luc_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ãzíla ãngũ kõtórõ rú rĩ gâlé rĩ áni. ꞌDãá índre ándrá Úpí Ãdróŋá mídrị̂ mba ími tã íngoní yã rĩ gá rá, cécé átẹ́pị ꞌbã ngọ́tị́ŋá ĩꞌdidrị̂ tã mbajó gẹ̃rị̃ agá ꞌdâ rĩ áni, mba ími tã kpere míní acá agá ãngũ ꞌdĩ gá ꞌdâ.’ ");
INSERT INTO luc_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","“Wó ị́jọ́ ꞌdĩ kí agâ sĩ pírí, ĩꞌbã ándrá ásị́ ị́jọ́ Úpí Ãdróŋá ĩmidrị́, ");
INSERT INTO luc_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ándrá mụlépi ĩmi drị̃lẹ́ gá ácị̃ ĩmidrị̂ gá, ĩmi drị̃ ꞌdelépi ị́nị́ sĩ ãcí sĩ ãzíla ị̃tụ́ sĩ ụ̃rụ́ꞌbụ̃ sĩ, ĩminí ãngũ ịsụ́lépi sĩ rijó ãzíla vâ gẹ̃rị̃ iꞌdalépi ĩminí sĩ mụjó rĩ drị̃ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“Úpí la mụ ị́jọ́ ĩminí jọlé rĩ kí arelé ꞌbo, ũmbã na ĩꞌdi ãzíla na dó sĩ ũyõ, ");
INSERT INTO luc_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘ꞌBá ãzí áyi ĩmidrị́ ũnzí ꞌdĩ agá ꞌdâ icólépi ãngũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ ãlá mání ũyõ nalé ma fẽ la ĩmĩ áyị́pịka ꞌbaní ꞌdã ndrelépi la la adru ꞌdáyụ, ");
INSERT INTO luc_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Kãlẹ́bụ̃ Yẹ̃fụ́nẹ̃ ngọ́pị la lú mụ ndrelé la nĩ. Ma mụ ãngũ ĩꞌdi ꞌbãsĩ pá tị̃jó ala gá ꞌbo rĩ fẽlé ĩꞌdinî ãzíla anzị ĩꞌdidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ abe, ãꞌdusĩku ũbĩ ị́jọ́ Úpí drị̂ kí vú ásị́ pírí sĩ.’ ");
INSERT INTO luc_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","“Úpí rụ mání ũmbã ĩmi ị́jọ́ sĩ rá ãzíla jọ mání, ‘Mí icó filé ãngũ ꞌdã agâlé ku, ");
INSERT INTO luc_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","be la rá la ꞌbá ími ãzã kolépi, Yósũwã Nụ́nị̃ ꞌbã ngọ́pị la fi nĩ. Mí ímbá ásị́ la, ãꞌdusĩku ĩꞌdi mụ ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃ ꞌdelé ãngũ ꞌdã ꞌdụjó nĩ. ");
INSERT INTO luc_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","ꞌDã ꞌbã ũngúkú gá, Úpí jọ ãmaní pírí anzị nírí ĩmidrị́ icólépi ị́jọ́ múké rĩ kí drĩdríŋĩ awalépi ị́jọ́ ũnzí rĩ abe ku rĩ kí fi ãngũ ꞌdã gá nĩ. ꞌDĩ kí anzị nírí ĩminí jọlé mẹ́rọ́ꞌbá ĩmidrị̂ kí kí ụrụ mãbụ́sụ̃ rú rĩ kî. Ma ãngũ ꞌdĩ fẽ ĩꞌbaní ãzíla kí dó sĩ ri ala gá. ");
INSERT INTO luc_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Wó ꞌbá ꞌdĩ ĩmi rú rĩ gá, ĩmi uja ĩmi mụlé ãngũ kõtórõ rú rĩ gâlé gẹ̃rị̃ sĩ mụjó Mĩrĩ Ika rĩ gâlé ru.’ ");
INSERT INTO luc_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“ꞌDã ꞌbã ũngúkú gá, ĩmi umvi, ‘Ãma iza ị́jọ́ Úpí rụ́ rá. Wó ãma mụ ãꞌdị́ ꞌdịlé rá, cécé Úpí Ãdróŋá ãmadrị̂ ꞌbã azịlé ãmaní rĩ áni.’ Ị́jọ́ ꞌdĩ sĩ, ꞌbá ãlu-ãlu ꞌdụ dó ãko ĩꞌdidrị́ ãꞌdị́ drị̂ kí trũ mụjó ĩꞌdiní ũrãjó la ĩꞌdi adru ĩpé ru ãngũ ꞌbé ꞌa rú rĩ ꞌdụjó rĩ sĩ rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","“Wó Úpí jọ mánî, ‘Ílũ ĩꞌbaní lẽ ꞌbã mụ kí ãꞌdị́ gâlé ku, ãꞌdusĩku mẹ́rọ́ꞌbá ĩꞌbadrị̂ kí mụ kí ndẽlé rá.’ ");
INSERT INTO luc_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Ájọ ándrá ĩminí rá, wó ĩmi are ándrá áma tị ku. Ĩgã ándrá ãzị́táŋá Úpí drị̂ kí úmgbé ãzíla ĩko dó drị̃ ãfó sĩ mụlé ãngũ ꞌbé ru rĩ gâlé. ");
INSERT INTO luc_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ꞌBá Ãmọ́rị̃ drị́ uꞌálépi ãngũ ꞌbé agá rĩ angá kí ĩmi drị̃ gá, ndẽ kí ĩmi, adró kí ĩmi cécé ãnụ́kụ́fị́ áni ãzíla mụ kí ĩmi ụꞌdị́ trũ angájó Sẽyírĩ gá kpere cajó Họ́rị̃mã gá. ");
INSERT INTO luc_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Ị́jọ́ ꞌdĩ sĩ ĩmi ãgõ vúlé áwáŋá trũ Úpí rụ́ ꞌdõlé, wó ꞌbã ásị́ áwáŋá ĩmidrị̂ drị̃ gá ku ãzíla ꞌbã bị́lẹ́ áwáŋá ĩmidrị̂ kí arejó ku. ");
INSERT INTO luc_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Ị́jọ́ ꞌdĩ sĩ ĩmi uꞌá ándrá dó Kãdẹ́sị̃ gá ꞌdãá ụ́ꞌdụ́ wẽwẽ rú, ĩmi iza sáwã ãndânĩ rĩ kí ꞌdãá.” ");
INSERT INTO luc_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Ị́jọ́ ꞌdã kí ũngúkú gá Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ãma uja ãma vúlé ãzíla ãko drị̃ mụlé gẹ̃rị̃ mụlépi Mĩrĩ Ika rĩ gâlé ru, cécé Úpí ꞌbã azịlé mání rĩ áni. Ãma acị́ ãngũ ꞌbé ru Sẽyírĩ drị̂ agá ụ́ꞌdụ́ ãzo rú. ");
INSERT INTO luc_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","“ꞌDã ꞌbã ũngúkú gá, Úpí jọ mánî, ");
INSERT INTO luc_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘Ĩmi apí dó ꞌbé ꞌdĩ ꞌa ụ́ꞌdụ́ ãzo rú ꞌbo, ĩtụ dó ụ́rụ̂lé ru. ");
INSERT INTO luc_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Ífẽ ꞌbá ꞌdĩ ꞌbaní ãzị́táŋá ꞌdĩ kî, “Ĩmi dó ãni rú alịjó ĩmi ádrị́pịka Ị́sãwụ̃ ꞌbã drị̃lẹ́ ru rĩ ꞌbadrị́ ãngũ agâ sĩ, ꞌdĩ kí ꞌbá uꞌálépi ãngũ Sẽyírĩ gá rĩ kî. Kí dó mụ idélé ĩmi sĩ ụ̃rị̃ sĩ, wó ĩmi adru mịfị̂ trũ. ");
INSERT INTO luc_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Ĩmi inga ũmbã kí agâlé ãꞌdị́ sĩ ku, ãꞌdusĩku má icó ãngũ ĩꞌbadrị̂ ꞌbã wókõ fẽlé ĩminí ku, ca ĩminí sĩ icójó pá sujó ala gá ku. Áfẽ ãngũ ꞌbé ru Sẽyírĩ drị̂ ꞌbá Ị́sãwụ̃ drị̂ ꞌbaní ꞌbo. ");
INSERT INTO luc_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Lẽ ĩmi ĩgbã ãko ĩminí mụlé nalé ãzíla ị̃yị́ ĩminí mụlé mvụlé rĩ kí ĩꞌbadrị́ séndẽ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Úpí Ãdróŋá mídrị̂ wi míní sụ̃sụ́ ãzị́ pírí míní ngalé ími drị́ sĩ rĩ kí drị̃ gá ꞌbo. Ílí kãlị́ sụ míní uꞌájó Úpí Ãdróŋá be ꞌdĩ gá ꞌdâ, mba ími tã ácị̃ míní wãyá cojó kõtórõ ãmbógó ꞌdĩ agá rĩ gá ãzíla mí ĩcẽ ãko ãzí sĩ ku.”’ ");
INSERT INTO luc_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“Ị́jọ́ ꞌdĩ sĩ, ãma alị dó ãmã ádrị́pịka anzị Ị́sãwụ̃ drị̂ ꞌbã drị̃lẹ́ ꞌba rụ̂ sĩ Sẽyírĩ gá ãngũ ĩꞌbaní uꞌájó rĩ gâsĩ. Ãma uja ãma gẹ̃rị̃ Ãrábã drị́ angálépi Ĩlátĩ gá Ị̃zị̃yọ́nị̃-gébã gá ãzíla ãmụ dó ãngũ kõtórõ rú rĩ agâ sĩ, ꞌdĩ gẹ̃rị̃ mụlépi Mụ̃wábụ̃ gâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","“ꞌDã ꞌbã ũngúkú gá, Úpí jọ mání, ‘Mí inga ũmbã ꞌbá Mụ̃wábụ̃ gá rĩ kí asị́ gá ku, jõku mí iꞌdó ãꞌdị́ ĩꞌba abe ku, ãꞌdusĩku má icó ãngũ ĩꞌbadrị̂ ꞌbã wókõ fẽlé ĩminí ku. Áfẽ táwụ̃nị̃ Árị̃ drị̂ anzị Lọ́tị̃ drị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbaní ĩꞌbã ãko rú ꞌbo.’” ");
INSERT INTO luc_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(ꞌBá Ị̃mị́mụ̃ ꞌbadrị̂ ri kí ándrá uꞌálé ꞌdãá, kí ũkpó ru ãzíla ũꞌbí ru, zo kí ãzo rú cécé ꞌbá Ãnákĩ drị̂ kí áni. ");
INSERT INTO luc_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Cécé ꞌbá Ãnákĩ drị̂ kí áni, úlã ándrá vâ kí ꞌbá Rẹ̃fãyị́mụ̃ drị̂ kî rú, wó ꞌbá Mụ̃wábụ̃ gá rĩ ri kí ándrá kí umvelé ꞌbá Ị̃mị́mụ̃ drị̂ kî. ");
INSERT INTO luc_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ꞌBá Họ́rị̃ drị̂ ri kí ándrá uꞌálé ãngũ Sẽyírĩ drị̂ gá, wó anzị Ị́sãwụ̃ ꞌbã drị̃lẹ́ ru rĩ dro kí ándrá kí ꞌdãá rá. Ụꞌdị́ kí ꞌbá Họ̃rị́tị̃ drị̂ kí kí drị̃lẹ́ gá ꞌdãá rá ãzíla ri kí ándrá ãngũ ĩꞌbadrị̂ agá cí, cécé ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã kí idélé ãngũ Úpí ꞌbã ándrá fẽlé ĩꞌbã ãko rú rĩ agá rĩ áni.) ");
INSERT INTO luc_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Mụ́sã mụ ị́jọ́ jọŋá trũ drị̃ gá jọ, “Úpí Ãdróŋá jọ ãmaní, ‘Ĩnga dó úꞌdîꞌda ụrụgá ãzíla ĩmi alị áꞌbụ Zẹ̃rẹ́dị̃ drị́ ꞌdĩ ꞌi.’ Ị́jọ́ ꞌdĩ sĩ ãma alị dó sĩ áꞌbụ̂ rá. ");
INSERT INTO luc_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","“Ílí alị kí dó ꞌdĩ sĩ kãlị́ na drị̃ ãrõ ꞌbo angájó sáwã ãmaní Kãdẹ́sị̃ Bãrĩnéyã aꞌbejó rĩ sĩ kpere ãmaní Zẹ̃rẹ́dị̃ alị agá. Ịsụ́ ꞌdĩ sĩ ꞌbá áyi ꞌdã agá icólépi ãꞌdị́ ꞌdịlépi rá kámbĩ agá rĩ ũdrã kí dó ꞌdĩ sĩ pírí ꞌbo, ándrá Úpí ꞌbã ũyõ najó ĩꞌbaní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Úpí ri ĩꞌbaní drị̃rịma fẽlé kámbĩ agá ꞌdãá kpere ĩꞌdiní kí ị̃lị̃kị̃ agá pírí drị́ ĩꞌdidrị̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“ꞌBá ãgọbị rú ãꞌdị́ drị́ ãsị̃jó rĩ kí dó mụ ũdrãlé ꞌbá kí agá ꞌdãá pírí ꞌbo, ");
INSERT INTO luc_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Úpí jọ mánî, ");
INSERT INTO luc_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘Ãndrũ lẽ mí alị dó mụlé táwụ̃nị̃ Mụ̃wábụ̃ drị́ Árị̃ gâsĩ. ");
INSERT INTO luc_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Ĩdrĩ dó acá ꞌbá Ãmọ́rị̃ drị̂ ꞌba rú ꞌbo, ĩmi inga ũmbã kí agâlé ãꞌdị́ ꞌdịjó ku ãꞌdusĩku má icó ãngũ bá Ãmọ́nị̃ rú rĩ ꞌbadrị̂ ꞌbã wókõ ãzí fẽlé ĩminí ku. Áfẽ ĩꞌdi anzị Lọ́tị̃ drị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbaní ꞌbo.’” ");
INSERT INTO luc_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Ãngũ ꞌdã úlã ándrá ĩꞌdi ãngũ ꞌbá Rẹ̃fãyị́mụ̃ ꞌbadrị̂ ꞌbãni la rú, ꞌdĩ kí ꞌbá uꞌálépi ꞌdãá rĩ kî, wó ꞌbá Ãmọ́nị̃ drị̂ kí ándrá ꞌbá ꞌdĩ kí umve Zãmũzúmĩ. ");
INSERT INTO luc_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ꞌBá ꞌdĩ kí ándrá ꞌbá ũkpó, ũꞌbí ãzíla ãzo rú cécé ꞌbá Ãnákĩ drị̂ kî áni la kî. Úpí ị̃lị̃kị̃ ꞌbá ꞌdĩ kí ꞌbá Ãmọ́rị̃ drị̂ kí drị̃lẹ́ gá ꞌdãá, ꞌbá Ãmọ́rị̃ drị̂ dro kí dó kí ꞌdãá rá, ꞌdụ kí dó ãngũ ĩꞌbadrị̂ rá ãzíla ri kí dó ala gá cí. ");
INSERT INTO luc_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Úpí idé ị́jọ́ ãlu ꞌdĩ ꞌbã vúŋá anzị Ị́sãwụ̃ ꞌbã drị̃lẹ́ ru rĩ ꞌbaní, ĩꞌbã kí uꞌájó Sẽyírĩ gá rĩ sĩ, ꞌbá Họ́rị̃ gá rĩ ũdrã kí kí drị̃lẹ́ gâsĩ. Dro kí dó sĩ kí ꞌdãá rá ãzíla ri kí dó ĩꞌbã ãngũ gá cí kpere ãndrũ. ");
INSERT INTO luc_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Ị́jọ́ ꞌdĩ sĩ, cécé ꞌbá Ávị̃tị̃ drị̂ ꞌbã kí ándrá uꞌájó tọ̃rọ́mẹ́ ꞌdã agá kpere cajó ãngũ Gázã gá rĩ áni, ꞌbá Kãfụ̃tọ̃rị́mụ̃ rú angálépi ãngũ Kãfụ̃tọ́rị̃ gá rĩ angá kí, ị̃lị̃kị̃ kí ꞌbá Ávị̃tị̃ drị̂ kí rá ãzíla rĩ kí dó ĩꞌbã ãngũ gá cí.) ");
INSERT INTO luc_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ãma dó mụ alịlé ãngũ Mụ̃wábụ̃ drị̂ agâ sĩ ꞌbo, Úpí jọ ãmaní, ‘Ĩmi iꞌdó dó ãcị̃ ãzíla ĩza dó áꞌbụ Ãrị̃nọ́nị̃ drị̂ ꞌi. Áfẽ úpí Sị̃họ́nị̃ Hẹ̃sị̃bọ́nị̃ Ãmọ́rị̃ rú rĩ ãngũ ĩꞌdidrị̂ abe ími drị́lẹ́ gá ꞌbo. Íꞌdị ãꞌdị́ ĩꞌdi be, mi dó sĩ ãngũ ĩꞌdidrị̂ kí ꞌdụ ãzíla mĩ dó sĩ ri ala gá. ");
INSERT INTO luc_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Iꞌdójó ãndrũ mụjó drị̃ gâlé ru, ma ꞌbá vũ drị̃ gá ꞌdâ rĩ kí fẽ idélé ĩmi sĩ pírí ụ̃rị̃ sĩ. ꞌBá pírí drĩ kí ị́jọ́ are ĩmi drị̃ gá, kí ụrụꞌbá la yã ụ̃rị̃ sĩ yã-yã.’” ");
INSERT INTO luc_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Mụ́sã mụ ị́jọ́ jọŋá trũ drị̃ gá jọ, “Ị́jọ́ ꞌdĩ sĩ, ápẽ dó ꞌbá ị́jọ́ ujílépi rĩ kí tị angájó ãngũ kõtórõ rú Kẽdẽmọ́tị̃ drị̂ agá úpí Sị̃họ́nị̃ ãngũ Hẹ̃sị̃bọ́nị̃ gá rĩ rụ́ ị́jọ́ ásị́ ị̃gbẹ̃ drị̂ trũ: ");
INSERT INTO luc_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘Mí aꞌbe ãmaní alịjó ãngũ mídrị̂ agâ sĩ, ãma dó sĩ mụ gẹ̃rị̃ ꞌbã ífí-ífí agâ sĩ, ãma uja ma drị́ ãndá gá jõku drị́ ị̃jị́ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Ídrĩ tá ãmaní ãkónã ãmaní mụlé nalé ãzíla ị̃yị́ ãmaní mụlé mvụlé rĩ kí fẽ ĩgbãlé séndẽ sĩ, ãma tá kí ĩgbã rá. Ị́jọ́ ãmaní lẽlé rĩ lú sĩ alịjó ãngũ mídrị̂ agâ sĩ ");
INSERT INTO luc_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","cécé anzị ándrá Ị́sãwụ̃ ꞌbã drị̃lẹ́ ru uꞌálépi Sẽyírĩ gá, ꞌbá Mụ̃wábụ̃ rú uꞌálépi Árị̃ gá rĩ ꞌbã kí idélé ãmaní rĩ áni kpere ãmaní Yõrĩdánĩ za agá ãngũ Úpí Ãdróŋá ãmadrị̂ ꞌbã fẽlé ãmaní rĩ gá.’ ");
INSERT INTO luc_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","“Wó úpí Sị̃họ́nị̃ Hẹ̃sị̃bọ́nị̃ drị̂ ãꞌị̃ ãmaní alịjó dã sĩ ku ãꞌdusĩku Úpí Ãdróŋá mídrị̂ fẽ ĩꞌdiní acájó drị̃ ũnzí ru ãzíla ꞌbã ásị́ la adrujó ũkpó ru ĩꞌdi dó sĩ amụ́ aꞌdélé ími drị́ alé gá cécé ĩꞌdi ꞌbã ru idéjó ãndrũ ꞌdĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","“Úpí jọ mánî, ‘Índre, má iꞌdó Sị̃họ́nị̃ kí fẽlé sụ́rụ́ ĩꞌdidrị̂ abe mídrị́ ꞌbo. Úꞌdîꞌda, mí iꞌdó dó ꞌbá ꞌdĩ kí ndẽlé sĩ ãngũ ĩꞌbadrị̂ kí ꞌdụjó mínî.’ ");
INSERT INTO luc_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","“ꞌDã ꞌbã ũngúkú gá, úpí Sị̃họ́nị̃ gá rĩ kí ãsĩkárĩ ĩꞌdidrị̂ abe kí mụ amụ́lé ãꞌdị́ gá ãma rụ́ Jãházĩ gá ꞌdãá ꞌbo, ");
INSERT INTO luc_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Úpí Ãdróŋá ãmadrị̂ fẽ dó ĩꞌdi ãma drị́lẹ́ gá, ãma ụꞌdị́ kí ngọ́pịka kí abe ãzíla ãsĩkárĩ ĩꞌdidrị̂ kî trũ pírí. ");
INSERT INTO luc_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Sáwã ꞌdã agá ãma upa táwụ̃nị̃ ĩꞌdidrị̂ kí pírí ãzíla ãma ị̃lị̃kị̃ ãgọbị, ũkú ãzíla anzị ĩꞌdidrị̂ kí abe pírí. Ãma aꞌbe ꞌbá ãzí ídri la ku. ");
INSERT INTO luc_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Wó ãnãkpá ãzíla ãko ãmaní upalé táwụ̃nị̃ agâlé rĩ kí ãma awa kí ãma drĩdríŋĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","“Iꞌdójó táwụ̃nị̃ Ãrówã tị gá cajó áꞌbụ Ãrị̃nọ́nị̃ rĩ gá, ꞌdĩ táwụ̃nị̃ áꞌbụ tị gá rĩ gá cajó kpere Gị̃lẹ́dị̃ gá, táwụ̃nị̃ ãzí ãlu ãma ndẽlépi ũkpõ sĩ rá la ꞌdá yụ. Úpí Ãdróŋá ãmadrị̂ fẽ táwụ̃nị̃ ꞌda kí pírí ãma drị́lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Wó ãzị́táŋá Úpí Ãdróŋá ãmadrị̂ drị̂ sĩ, ĩfi ándrá ãngũ Ãmọ́nị̃ drị̂ agá ku, ị̃yị́ tị Yãbọ́kị̃ drị̂ agá ku ãzíla táwụ̃nị̃ ꞌbé andre gá rĩ kí agá ku. ");
INSERT INTO luc_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“ꞌDã ꞌbã ũngúkú gá, ãma uja dó tị sĩ mụjó ụ́rụ́ tọ̃rọ́mẹ́ Bãsánĩ gá, ãzíla úpí Ụ́gị̃ amụ́ ãsĩkárĩ ĩꞌdidrị́ ãꞌdị́ drị̂ kí abe ãma rụ́ ãꞌdị́ gá ãni la táwụ̃nị̃ Ị̃drẹ́yị̃ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Úpí jọ mánî, ‘Mí idé ĩꞌdi sĩ ụ̃rị̃ sĩ ku, áfẽ Ụ́gị̃ kí ãsĩkárĩ ĩꞌdidrị̂ abe sụ́rụ́ ĩꞌdidrị̂ kí trũ pírí ími drị́lẹ́ gá ꞌbo. Mí idé ị́jọ́ ꞌdĩ kí vúŋá ĩꞌdi rụ́ cécé míní idélé úpí Ãmọ́rị̃ drị́ Sị̃họ́nị̃ uꞌálépi Hẹ̃sị̃bọ́nị̃ gá rĩ ụrụꞌbá gá rĩ áni.’ ");
INSERT INTO luc_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Ị́jọ́ ꞌdĩ sĩ Úpí Ãdróŋá ãmadrị̂ fẽ úpí Ụ́gị̃ Bãsánĩ drị̂ ãsĩkárĩ ĩꞌdidrị̂ kí abe ãma drị́lẹ́ gá ãzíla ãma ụlị́ dó kí pírí. ");
INSERT INTO luc_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Sáwã ꞌdã agá, ãꞌdụ dó táwụ̃nị̃ ĩꞌdidrị̂ kí pírí. Táwụ̃nị̃ kãlị́-ázíyá ꞌdã kí agá ãmaní ꞌdụlé ku la ꞌdáyụ, ãrụ ãngũ Ãrĩgóbũ drị̂ pírí ꞌdĩ ãngũ úpí Ụ́gị̃ Bãsánĩ drị̂ ꞌbã nalé rĩ. ");
INSERT INTO luc_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Táwụ̃nị̃ ꞌdĩ kí úce kí pírí Bõrõ mére rú sịlé ãzo la kî sĩ cí ãzíla kẹ̃jị́tị idélé báwũ sĩ kí ụ̃pị̃jó rĩ kí cí ãzíla tọ̃rọ́mẹ́ ãzí ũꞌbí andre celé Bõrõ sĩ ku la kí vâ cí. ");
INSERT INTO luc_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Ãma ị̃lị̃kị̃ ꞌbá ala gá rĩ kí pírí, cécé ãmaní ngalé úpí Sị̃họ́nị̃ Hẹ̃sị̃bọ́nị̃ drị̂ rụ́ rĩ áni. Ãma ụꞌdị́ Ãgọbị kí, ũkú kí ãzíla anzị nírí kí abe pírí táwụ̃nị̃ ĩꞌbadrị̂ agá ꞌdãá rá. ");
INSERT INTO luc_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Wó ãꞌdụ ãnãkpá lị́cọ́ gá rĩ kí pírí ãmaní ãzíla ãra vâ ãko táwụ̃nị̃ agá ꞌdãá rĩ kí ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Sáwã ꞌdã sĩ ãꞌdụ ũpi ị̃rị̃ Ãmọ́rị̃ ꞌbadrị́ ãngũ Ị̃yị́ Yõrĩdánĩ gá wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá rĩ kí angájó áꞌbụ Ãrị̃nọ́nị̃ drị̂ gá kpere ꞌBé Hẹ̃rị̃mọ́nị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(ꞌBá Sị̃dọ́nị̃ gá rĩ kí ꞌBé Hẹ̃rị̃mọ́nị̃ umve Sị́rị̃yọ̃ ꞌi, ꞌbá Ãmọ́rị̃ gá rĩ kí ĩꞌdi umve Sẹ́nị̃ ꞌi.) ");
INSERT INTO luc_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Ãꞌdụ úpí Ụ́gị̃ ꞌbã ãngũ Bãsánĩ gá rĩ kí pírí, Táwụ̃nị̃ túpũ drị̃ gá rĩ kí abe, ãngũ Gị̃lẹ́dị̃ drị́ ãzíla Bãsánĩ drị̂ kí trũ, angájó ị̃tụ̂ ꞌbã ãfũ agá cajó Táwụ̃nị̃ Sãlékã gá ãzíla Ị̃drẹ́yị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Úpí Ụ́gị̃ Bãsánĩ drị̂ ĩꞌdi ꞌbá drãlépi ꞌbá Rẹ̃fãyị́mụ̃ drị̂ kí agá vúvúlé ru rĩ ꞌi, ídé Sãndụ́kụ̃ sĩ ĩꞌdi ị̃sị̃jó rĩ aya sĩ, ãzo la mítã sụ ãzíla mgbọ la mítã ị̃rị̃. Ála drĩ ĩꞌdi ịsụ́ Kpere ãndrũ táwụ̃nị̃ Rábã anzị Ãmọ́nị̃ rú rĩ ꞌbadrị̂ gá ꞌdãá cí.) ");
INSERT INTO luc_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“Ãma dó mụ ãngũ ꞌdã ꞌdụlé sáwã ꞌdã sĩ ꞌbo, áfẽ dó ínátị Rụ́bẹ̃nị̃ drị̂ ꞌbaní Gádĩ drị̂ be ãngũ ụ́rụ́ táwụ̃nị̃ Ãrówã gá ãni la áꞌbụ Ãrị̃nọ́nị̃ gá rĩ ꞌi ãzíla ãngũ Gị̃lẹ́dị̃ drị́ túpũ rú rĩ ꞌbã nụ́sụ̃ táwụ̃nị̃ la kí abe. ");
INSERT INTO luc_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Gị̃lẹ́dị̃ ꞌbã ị́mbị́ ãzíla ãngũ úpí Ụ́gị̃ Bãsánĩ gá rĩ drị̂ abe áfẽ kí ínátị Mãnásẽ drị̂ ꞌbã nụ́sụ̃ nî. (Ãngũ Ãrĩgóbũ Bãsánĩ drị̂ pírí únị̃ ándrá ĩꞌdi ãngũ ꞌbá Rẹ̃fãyị́mụ̃ ꞌbã ãni la rú. ");
INSERT INTO luc_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jãyírĩ angájó anzị Mãnásẽ drị̂ kí agá rĩ, ꞌdụ ãngũ Ãrĩgóbũ drị́ Bãsánĩ gá rĩ pírí angájó Gẹ̃sụ̃rụ́tị̃ gá kpere Mãkátĩ gá. ꞌDa dó tọ̃rọ́mẹ́ ꞌdã kí rụ́ ĩꞌdi ꞌbã rụ́ sĩ ãzíla kpere ãndrũ ála ãngũ ꞌdã umve Hãvọ́tị̃ Jãyírĩ ꞌi.) ");
INSERT INTO luc_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Áfẽ ándrá ãngũ Gị̃lẹ́dị̃ drị̂ ꞌi sụ́rụ́ Mãkírĩ drị̂ ní. ");
INSERT INTO luc_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Wó anzị Rụ́bẹ̃nị̃ drị̂ ꞌbaní Gádĩ drị̂ abe áfẽ ãngũ angájó Gị̃lẹ́dị̃ gá rĩ kpere ándrá áꞌbụ Ãrị̃nọ́nị̃ gá. Lõkókõrí ĩꞌbadrị́ ándrá rĩ ị̃yị́ ꞌbã ágágá ãzíla lõkókõrí ĩꞌbadrị́ ụ́rụ́ rĩ ị̃yị́ Yãbọ́kị̃ gá, ꞌdĩ lõkókõrí ĩꞌbã ãni Ãmọ́nị̃ be rĩ. ");
INSERT INTO luc_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Lõkókõrí ĩꞌbadrị́ ị̃tụ́ ꞌbã ꞌde agâlé ru rĩ Ị̃yị́ Yõrĩdánĩ ꞌi, ꞌdĩ Ãrábã gá, angájó Kị̃nẹ̃rẹ́tị̃ gá kpere ị̃yị́ Ãrábã drị́ (ꞌdĩ mĩrĩ umvelé Mĩrĩ Ãꞌị́ ru rĩ), kpere ꞌBé Pị́sị̃gã ꞌbã pá gá wókõ ị̃tụ́ ꞌbã ãfũ agâlé ru. ");
INSERT INTO luc_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“Áfẽ ándrá ĩminí ãzị́táŋá sáwã ꞌdã sĩ ájọ, ‘Úpí Ãdróŋá ĩmidrị̂ fẽ ĩminí ãngũ ꞌdã ꞌdụjó ĩmĩ ãni la rú. Wó ãgọbị ĩmidrị́ ũkpó trũ rĩ ꞌbã za kí ãko ĩꞌbadrị́ ãꞌdị́ drị̂ kî trũ pírí Ị̃yị́ Yõrĩdánĩ ꞌbã âlé sĩ ĩmi ádrị́pịka Ịsịrayị́lị̃ rú ãzí acelépi rĩ kí ãzã kojó sĩ ãngũ ĩꞌbadrị̂ ꞌdụjó. ");
INSERT INTO luc_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Wó ũkú ĩmidrị̂ kí anzị kí abe ãzíla ãnãkpá kí trũ (ánị̃ cé ãnãkpá ĩmidrị̂ kí ũꞌbí ru) icó kí acelé vúlé táwụ̃nị̃ mání fẽlé ĩminí rĩ kí agá ꞌdãá, ");
INSERT INTO luc_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","kpere Úpí ꞌbã fẽ agá la ĩmĩ ádrị́pịka ꞌbaní ãꞌdị́ ndẽ agá cécé ĩꞌdiní fẽlé ĩminí rĩ ãni. Ĩko kí ãzã vâ sĩ ãngũ Úpí Ãdróŋá ĩmidrị̂ ꞌbã fẽlé ĩꞌbaní Ị̃yị́ Yõrĩdánĩ ꞌbã ꞌá ꞌdã sĩ rĩ ꞌdụjó, ꞌdã ꞌbã ũngúkú gá ĩmi dó sĩ gõ vúlé ãngũ mání fẽlé ĩminí rĩ gá ĩndõ.’ ");
INSERT INTO luc_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","“Ụ́ꞌdụ́ ꞌdã sĩ má azị Yósũwã ní, ‘Índre ími mịfị́ sĩ ị́jọ́ pírí Úpí Ãdróŋá ĩmidrị̂ ꞌbã ngalé ũpi ị̃rị̃ Sị̃họ́nị̃ ꞌba rụ́ Ụ́gị̃ be rĩ kí rá. Úpí la mụ ị́jọ́ ãlu ꞌdĩ ꞌbã vúŋá ngalé ãngũ sụ́rụ́ pírí ĩminí sĩ fijó ala gá rĩ kí ụrụꞌbá gá rá. ");
INSERT INTO luc_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Ĩmi idé kí sĩ ụ̃rị̃ sĩ kụ, Úpí Ãdróŋá ĩmidrị̂ la ãꞌdị́ ꞌdị ĩminí nĩ.’ ");
INSERT INTO luc_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“Sáwã ꞌdã sĩ áꞌbã mãmálá ásị́ pírí sĩ Úpí rụ́, má aꞌị́ ĩꞌdi, ");
INSERT INTO luc_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘Úpí Ãdróŋá Ũkpó ꞌDị́pị, mí iꞌdó dó ãmbõgõ ãzíla drị́ mídrị́ ũkpó trũ rĩ iꞌdalé ãtíꞌbó mídrị̂ ní ꞌbo, ãꞌdusĩku ãdróŋá ãzí ꞌbụ̃ gá jõku ụ̃nọ́kụ́ drị̃ gá ꞌdâ icólépi ãzị́ míní ngalé ꞌdĩ kí ngalépi la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Ífẽ áza mání Yõrĩdánĩ ꞌbã ꞌá ꞌdã sĩ, ma dó sĩ mání ãngũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ ꞌdã kí ndre ãzíla ãngũ ãlá ꞌbé ꞌa rú Lébãnõnĩ drị̂ kí abe.’ ");
INSERT INTO luc_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","“Wó ꞌbá ꞌdĩ ĩmi ị́jọ́ sĩ, Úpí uꞌá ándrá mání ũmbã sĩ, icó ándrá dó sĩ áma ị́jọ́ arelé ku. Kẹ̃jị́ la gá jọ ándrá mánî, ‘ꞌDĩ ca rá! Álẽ mí agá mání ị́jọ́ ꞌdĩ ị̃dị́ ku! ");
INSERT INTO luc_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Ítụ ụrụgá ꞌBé Pị́sị̃gã drị̃ gâlé, índre ãngũ ụ́rụ́ ãzíla ándrá, ĩtụ́ ꞌbã ãfũ agá ãzíla ị̃tụ́ ꞌbã ꞌde agá, mí undré ãko pírí kí múké-múké wó mí icó zalé Ị̃yị́ Yõrĩdánĩ ꞌbã ꞌá ꞌdã sĩ ku. ");
INSERT INTO luc_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Wó ífẽ ímbátáŋá Yósũwã nî, mí imbá ĩꞌdi asị́ ãzíla ífẽ ĩꞌdiní ũkpõ ãꞌdusĩku ĩꞌdi mụ ꞌbá kí drị̃ ꞌdelé sĩ zajó ãngũ míní ndrelé ꞌdã agá sĩ rijó nĩ.’ ");
INSERT INTO luc_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","“Ị́jọ́ ꞌdĩ sĩ ãma ace dó áꞌbụ ꞌa Bẹ̃tị̃pẹ̃yọ́rị̃ gá.” ");
INSERT INTO luc_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“Úꞌdîꞌda Ịsịrayị́lị̃ ĩmi are drĩ ị́jọ́ mání azịlé ãzíla ãzị́táŋá mání imbálé ĩminí ꞌdĩ kí, ĩmi ũbĩ kí vú ãzíla ĩmi dó vâ sĩ uꞌá ãngũ Úpí Ãdróŋá ĩmĩ áyị́pịka ꞌbadrị̂ ꞌbã fẽlé ĩminí ꞌdã gá, ĩmi dó sĩ ꞌdụ la ĩmi ãni la rú. ");
INSERT INTO luc_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Ĩmi ũꞌbã jõ ãzị́táŋá ãzí ãzíla ĩnze jõ ãzị́táŋá mání imbálé ĩminí ꞌdĩ kí ꞌbã ãzí ku, wó ĩmba jõ ãzị́táŋá Úpí Ãdróŋá ĩmidrị̂ ꞌbã fẽlé ĩminí ꞌdĩ kí tã. ");
INSERT INTO luc_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Ĩndre ĩmi mịfị́ sĩ ị́jọ́ Úpí ꞌbã idélé ꞌBé Pẹ̃yọ́rị̃ drị̃ gâlé rĩ kí cé. Úpí Ãdróŋá mídrị̂ ị̃lị̃kị̃ ꞌbá ꞌdĩ kî ĩmi drĩdríŋĩ gá ꞌdãá ãdróŋá umvelé Bãálĩ ꞌBé Pẹ̃yọ́rị̃ gá rĩ kí ị̃nzị̃lépi rĩ kí pírí rá. ");
INSERT INTO luc_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Wó ĩmi ꞌbá ãꞌị̃táŋá trũ Úpí Ãdróŋá ĩmidrị̂ tị arelépi rá ꞌdĩ, ĩmi drĩ kpere ãndrũ ídri. ");
INSERT INTO luc_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“Ĩndre, má imbá ĩminí ãzị́táŋá Úpí Ãdróŋá mádrị̂ ꞌbã azịlé mání rĩ kí ꞌbo. Ĩmi ũbĩ kí vú ãngũ ĩminí sĩ fijó ĩminí ꞌdụ lé ĩmĩni la rú rĩ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Ĩmi ũbĩ ãzị́táŋá ꞌdĩ kí vú múké-múké, ãzíla ị́jọ́ ꞌdĩ kí iꞌda la ꞌbá sụ́rụ́ ãzí gá rĩ ꞌbanî, ĩmi ũndũwá ru ãzíla ꞌbá ị́jọ́ vãlépi rá la kî. Ãndá-ãndá ru drĩ kí ãzị́táŋá ꞌdĩ kí are ị́jọ́ azịlé ꞌdĩ kí abe, kí jọ la, ‘Sụ́rụ́ ãmbógó ꞌdĩ ũndũwá ru ãzíla ꞌbá ala gá ꞌdĩ kí nị̃táŋá trũ.’ ");
INSERT INTO luc_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","“Sụ́rụ́ ãzí ãmbógó ĩꞌdi ꞌbã ãdróŋá ní adrujó ãníŋá drĩ kí ĩꞌdi lẽ Úpí Ãdróŋá ãmadrị̂ áni la ꞌdáyụ. Ãdrĩ ĩꞌdi zị ĩꞌdi ãma umvi rá. ");
INSERT INTO luc_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Sụ́rụ́ ãzí ãmbógó ãzị́táŋá pịrị mání imbálé ĩminí ꞌdĩ kî trũ ri íngõ ꞌi? ");
INSERT INTO luc_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Ĩmi adru mịfị́ trũ ãzíla ĩmba ĩmi tã, ị́jọ́ ĩminí ndrelé ĩmĩ mịfị́ sĩ ꞌdĩ ꞌbã ãvĩ kí jõ sĩ ĩminí ku, ĩminí adru agá ídri rú ꞌdĩ gá ꞌdĩ. Ĩmi imbá ãzị́táŋá ꞌdĩ kí anzị ĩmidrị̂ ꞌbaní ãzíla anzị ĩmidrị̂ ꞌbã anzị ꞌbaní ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Ụ́ꞌdụ́ ándrá míní sĩ pá tujó Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá ꞌBé Hõrébũ gá ꞌdãá rĩ ꞌbã agá jõ mínî, ụ́ꞌdụ́ ĩꞌdi ꞌbã jọjó la mání, ‘Mí ajị́ ꞌbá ꞌdĩ kí áma drị̃lẹ́ gá rĩ. Álẽ ꞌbã are kí ị́jọ́ mání jọlé rĩ kî, ị́jọ́ ꞌdĩ sĩ kî dó sĩ ála áma ị̃nzị̃ íngoní ru yã rĩ ụ̃nị̃ ĩꞌbaní uꞌá agá ꞌdĩ gá ꞌdâ ãzíla kí dó sĩ anzị ĩꞌbadrị̂ kí imbá idéjó la ꞌdĩ ꞌbã áni.’ ");
INSERT INTO luc_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","“Ĩlũ anzị ĩmidrị̂ ꞌbaní ĩmụ ándrá ãzíla ĩtu ándrá pá ꞌbé pá gá ꞌdãá ꞌdĩ sĩ ụ̃rụ́ꞌbụ̃ ãnzị ãzíla ãcíkã ịnịbịrịcịcị rĩ aku ĩꞌdi cí ãzíla ãcí velépi kpere ꞌbụ̃ gâlé rĩ be íngoní ru yã rĩ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Ĩlũ ĩꞌbaní, Úpí ajọ́ ándrá ị́jọ́ ĩmi abe ãcí agâlé íngoní ru yã rĩ drị̃ gá, ĩmi are ĩꞌdi ꞌbã ị́jọ́ jọ agá rá, wó ĩndre ĩꞌdi ꞌbã mgbã rĩ ku. ");
INSERT INTO luc_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Jọ ĩminí ị́jọ́ tị icíma drị́, ꞌdĩ kí ãzị́táŋá mụdrị́ ĩꞌdi ꞌbã azịlé ĩminí ꞌdĩ kí vú ũbĩjó ãzíla sĩ kí írã ꞌbara-ꞌbara ị̃rị̃ la kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Ụ́ꞌdụ́ ꞌdã sĩ Úpí jọ mání lẽ má imbá ĩminí ãzị́táŋá ꞌdĩ kí, ĩmi sĩ mụ kí tã mbalé ãngũ ĩminí sĩ mụjó rijó rĩ gâlé.” ");
INSERT INTO luc_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Mụ́sã jọ anzị Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ụ́ꞌdụ́ Úpí ꞌbã ị́jọ́ ajọ́jó ĩmi abe ãcí agâlé ꞌBé Hõrébũ gá ꞌdãá rĩ sĩ, ĩndre ĩꞌdi mgbã rĩ ku. Ị́jọ́ ꞌdĩ sĩ lẽ ĩmba ĩmi tã múké-múké, ");
INSERT INTO luc_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","lẽ ĩmi idé ị́jọ́ ũnzí ĩmi izalépi la sĩ ãdroŋa ĩnzõ rú iꞌdálépi gbíyã ágọ́bị́ drị̂ sĩ jõku ũkú drị̂ sĩ la kí idéjó ku, ");
INSERT INTO luc_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","jõku ãnãkpá ụ̃nọ́kụ́ drị̃ gá jõku ãriŋa ungalépi ꞌbụ̃ gâsĩ ꞌdĩ kí, ");
INSERT INTO luc_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","jõku ãko ídri trũ acị́lépi vũ rụ̂ sĩ jõku Ị̃ꞌbị ị̃yị́ agá rĩ kî trũ. ");
INSERT INTO luc_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ídrĩ ị̃tụ́, ĩmbá ãzíla lẽlẽgó ꞌbụ̃ gá ꞌdĩ kí ndre, ãko ãzí ꞌbã ulé jõ mi kí ị̃nzị̃jó jõku ãzị́ ngajó ĩꞌbaní ku, ãko ꞌdĩ kí Úpí Ãdróŋá mídrị̂ ꞌbã ꞌbãlé ꞌbá pírí ụ̃nọ́kụ́ drị̃ gá ꞌdĩ ꞌbaní rĩ kî. ");
INSERT INTO luc_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Ị́jọ́ ándrá Úpí ꞌbã ĩmi anzéjó Mị̃sị́rị̃ ĩminí sĩ drị̃cịjó ala gâlé cécé ĩmi ꞌbã rĩ adru agá ãcí úká drị́ ika rĩ agá rĩ áni rĩ ꞌbã agá jõ ĩminî, ají ĩmi sĩ ĩmi ꞌbãjó ĩꞌdi ꞌbã ꞌbá ru, ĩminí ãndrũ sĩ adrujó ꞌdĩ ꞌbã áni ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","“Wó ími ị́jọ́ sĩ, Úpí Ãdróŋá mídrị̂ uꞌá ándrá mání ũmbã sĩ, ãzíla na ũyõ jọ mání, má icó Ị̃yị́ Yõrĩdánĩ zalé sĩ fijó ãngũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ ãlá ĩꞌdiní mụlé fẽlé míní rĩ gâlé ku. ");
INSERT INTO luc_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Ị́jọ́ ꞌdĩ sĩ ma mụ drãlé ãngũ ꞌdĩ gá ꞌdâ, má icó Ị̃yị́ Yõrĩdánĩ zalé ku, wó ĩmi ãni rú mụ zalé sĩ ãngũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ ãlá ꞌdã ꞌdụjó sĩ rijó ĩmi ãni la rú. ");
INSERT INTO luc_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Ĩmi adru mịfị̂ trũ, ĩmi drị̃ ꞌbã ãvĩjõ tị icíma Úpí Ãdróŋá ĩmidrị̂ ꞌbã icílé ĩmi abe rĩ ꞌbã ị́jọ́ sĩ ku, ĩmi idé jõ ãdroŋa ĩnzõ rú la kí anzị ĩmidrị̂ ꞌbaní ị̃nzị̃lé ku, ꞌdĩ ị́jọ́ Úpí Ãdróŋá mídrị̂ ꞌbã gãlé úmgbé rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Úpí Ãdróŋá mídrị̂ ĩꞌdi cécé ãcí ãko pírí kí ivélépi rĩ áni, ĩꞌdi ãjã rú. ");
INSERT INTO luc_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“Ĩdrĩ táni uꞌá ãngũ ꞌdĩ gá ꞌdâ ílí ãzo rú ãzíla ídrĩ anzị kí tị rá ãzíla anzị ĩmidrị̂ ꞌbã anzị drị̃lẹ́ gâlé rĩ kí abe, ĩmi idé jõ ị́jọ́ ũnzí ãzí sĩ ĩminí ãdroŋa ĩnzõ rú la kí idé jõ ku. Ĩꞌdi ị́jọ́ ũnzí la Úpí Ãdróŋá mídrị̂ ꞌbã drị̃lẹ́ gá ãzíla ĩꞌdi fẽ ĩꞌdiní uꞌájó ũmbã sĩ. ");
INSERT INTO luc_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Ụ́ꞌdụ́ ãndrũ ꞌdõ sĩ má umve ĩminí ꞌbụ̃ kí ụ̃nọ́kụ́ be sãdínĩ rú, ĩmi mụ ũdrãlé mbẽlẽŋá ru ụ̃nọ́kụ́ ĩminí Yõrĩdánĩ zajó ꞌá ꞌdã sĩ ĩminí mụlé ꞌdụlé ĩmi ãko rú rĩ gá. Ĩmi ị̃lị̃kị̃ pírí rá ĩdrĩ ĩꞌdi tị are ku rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Úpí la ĩmi iré sụ́rụ́ ãzí kí drĩdríŋĩ gâsĩ ãzíla ꞌbá were kí rũ pa sụ́rụ́ ꞌdã kí agâlé nĩ. ");
INSERT INTO luc_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","ꞌDãá ĩmi mụ ãzị́ ngalé ãdroŋa ãzí ĩnzõ rú ãngũ ndrelépi ku jõku ị́jọ́ arelépi ku vâ ãkónã nalépi ku jõku ãko ãzí ꞌbã ãjị́ ngụ̃lépi ku báwũ rú ãzíla írã rú ꞌbá ꞌbã kí idélé drị́ sĩ rĩ ꞌba nî. ");
INSERT INTO luc_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Wó ídrĩ Úpí Ãdróŋá mídrị̂ ndrụ̃, mi ĩꞌdi ịsụ́ rá, ídrĩ ĩꞌdi ndrụ̃ ími ásị́ pírí sĩ ãzíla ími ídri pírí sĩ rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Ídrĩ adru ũcõgõ agá ãzíla ị́jọ́ ꞌdĩ drĩ kí ru idé ími ụrụꞌbá gá, ụ́ꞌdụ́ vúlé rĩ sĩ mi ãgõ Úpí Ãdróŋá mídrị̂ rụ́ sĩ ĩꞌdi tị arejó. ");
INSERT INTO luc_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Úpí Ãdróŋá mídrị̂ ĩꞌdi Ãdróŋá ásị́ ị̃gbẹ̃ trũ la, icó ími aꞌbelé jõku ími ị̃lị̃kị̃lé ku ãzíla icó tị icíma ándrá ĩꞌdi ꞌbã sĩ ũyõ najó mí áyị́pịka abe rĩ ꞌbã ị́jọ́ ãvĩlé ku.” ");
INSERT INTO luc_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Mụ́sã mụ ị́jọ́ jọŋá trũ drị̃ gá ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní jọ, “Ĩmi ũrã drĩ ụ́ꞌdụ́ ídu ándrá drĩ ĩmi tịjó ku ꞌdã kí ꞌbã ị́jọ́, iꞌdójó ụ́ꞌdụ́ Ãdróŋá ꞌbã ꞌbá ꞌbãjó ụ̃nọ́kụ́ gá ꞌdã sĩ. Ĩzị drĩ angájó ꞌbụ̃ ꞌbã wókõ ãzí rĩ gá cajó ãzí rĩ gá, ị́jọ́ ãzí ru ngalépi ãmbógó ru ꞌdĩ ꞌbã áni la cí yã? ꞌBá ãzí ãlu ị́jọ́ arelépi ị́jọ́ ãzí ꞌdĩ áni la drị̃ gá la cí yã? ");
INSERT INTO luc_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","ꞌBá ãzí ĩminí arelé ãdróŋá ĩꞌbadrị̂ jọ ị́jọ́ ĩꞌba abe angájó ãcí agâlé acelépi ídri cécé Ãdróŋá ĩmidrị̂ ꞌbã jọlé ĩminí ãcí agâ sĩ rĩ áni la cí yã? ");
INSERT INTO luc_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Jõku ãdróŋá ãzí sụ́rụ́ ãzí ãlu la ꞌdụlépi sụ́rụ́ kí agá, ãzíla ĩꞌdi ꞌbãlépi ĩꞌdi ãni la rú ĩꞌdi ꞌbã sĩ ị́jọ́ ụ̃ꞌbị̃táŋá ru, ícétáŋá, ị́jọ́ ụ̃sụ̃táŋá ru, ãꞌdị́ ru, drị́ ũkpó ĩꞌdidrị̂ iꞌdaŋá trũ, drị́ ĩjũŋá trũ, ị́jọ́ ãmbogo ãmbogo ụ̃rị̃ fẽlépi ꞌbání rĩ kí trũ ri kí idélépi ĩminí cécé Úpí Ãdróŋá ĩmidrị̂ ꞌbã idélé ĩminí Mị̃sị́rị̃ gá rĩ áni la cí yã? ");
INSERT INTO luc_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","“Iꞌda ĩminí ãko ꞌdĩ kí íni la sĩ ĩminí nị̃jó la Úpí ĩꞌdi Ãdróŋá ru nĩ, ĩꞌdi bụ́lụ́ gá ãdróŋá ãzí ndú la yụ. ");
INSERT INTO luc_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Fẽ ĩminí ĩꞌdi ꞌbã ụ́ꞌdụ́kọ́ arejó angájó ꞌbụ̃ gâlé sĩ ímbátáŋá fẽjó ĩminî. Iꞌda ĩminí ụ̃nọ́kụ́ drị̃ gá ꞌdâ ãcí ãmbógó rĩ ãzíla ĩmi are ị́jọ́ ĩꞌdi ꞌbã jọlé rĩ angájó ãcí ãmbógó rĩ agâlé. ");
INSERT INTO luc_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Ĩꞌdi ꞌbã ĩmi áyị́pịka kí lẽjó rá rĩ sĩ ũpẽ ĩmi anzị ĩmidrị́ drị̃lẹ́ gâlé rĩ abe, ũkpõ ĩꞌdidrị́ ãmbógó rĩ sĩ ĩꞌdi ãmgbã anzé ĩmi Mị̃sị́rị̃ gâlé nĩ. ");
INSERT INTO luc_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Ĩminí mụ agá, Ãdróŋá adro sụ́rụ́ ĩmi ndẽlépi ãmbõgõ sĩ ãzíla ũkpõ sĩ rá ꞌdĩ kí ĩmi drị̃lẹ́ gá rĩ sĩ rá, fẽjó la ãngũ ĩꞌbadrị̂ ꞌbã kí adrujó ĩmi ãni la rú. ");
INSERT INTO luc_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Ị́jọ́ ꞌdĩ sĩ lẽ ị̃nị̃ dó sĩ ãndrũ rá ãzíla ĩmba ị́jọ́ ꞌdĩ kí tã ĩmi ásị́ gá cí Úpí ĩꞌdi Ãdróŋá ꞌbụ̃ gá ãzíla ụ̃nọ́kụ́ gá rĩ ꞌi, Ãdróŋá ãzí ndú la yụ. ");
INSERT INTO luc_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Ímba ị́jọ́ mání azịlé rĩ kí tã ãzị́táŋá ĩꞌdidrị́ mání fẽlé míní ãndrũ ꞌdĩ kí abe, ị́jọ́ ꞌdĩ sĩ ma dó mụ adrulé mí be ãzíla anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ abe. Mi dó sĩ mụ uꞌálé ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ gá jãꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","ꞌDã ꞌbã ũngúkú gá, Mụ́sã ũpẽ dó táwụ̃nị̃ ãzí kí na ndú Yõrĩdánĩ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá, ");
INSERT INTO luc_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","sĩ ꞌbá ꞌbá adrulépi ĩꞌdi ꞌbã mẹ́rọ́ꞌbá rú ku rĩ ꞌdịlépi drị̃lẹ́ ũnzĩ sĩ rĩ ꞌba apá sĩ ru ídri pajó táwụ̃nị̃ ꞌdĩ kí ꞌbã ãzí ãlu la gá. ");
INSERT INTO luc_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Ínátị Rụ́bẹ̃nị̃ drị̂ ní úfẽ táwụ̃nị̃ Bẹ̃zárị̃ ꞌi ꞌdĩ ãngũ túpũ rú kõtórõ rú rĩ ꞌi, ínátị Gádĩ drị̂ ní úfẽ Rãmọ́tị̃ ꞌi, ꞌdĩ ãngũ Gị̃lẹ́dị̃ drị̂ agá, ãzíla ínátị Mãnásẽ drị̂ ní úfẽ Gõlánĩ ꞌi ꞌdĩ ãngũ Bãsánĩ drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","ꞌDĩ kí ãzị́táŋá Mụ́sã ꞌbã ꞌbãlé anzị Ịsịrayị́lị̃ drị̂ kí drị̃lẹ́ gá rĩ kî. ");
INSERT INTO luc_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Mụ́sã azị ị́jọ́ ũkpó ꞌdĩ kí ãzị́táŋá kí abe anzị Ịsịrayị́lị̃ drị̂ ꞌbaní ĩꞌbã kí ãfũjó Mị̃sị́rị̃ gâlé ꞌbo rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","ꞌBá ꞌdĩ kí ꞌdĩ sĩ ãni rú áꞌbụ Bẹ̃tị̃pẹ̃yọ́rị̃ drị̂ gá ꞌdĩ Ị̃yị́ Yõrĩdánĩ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá, ãngũ úpí Sị̃họ́nị̃ ꞌbá Ãmọ́rị̃ rú rĩ ꞌbadrị́ ũpĩ nalépi Hẹ̃sị̃bọ́nị̃ gá ándrá Mụ́sã ꞌbã kí ndẽlé anzị Ịsịrayị́lị̃ drị̂ abe ĩꞌbã kí ãfũjó Mị̃sị́rị̃ gâlé rĩ sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","ꞌDụ kí ãngũ úpí Sị̃họ́nị̃ drị̂ ãzíla ãngũ úpí Ụ́gị̃ Bãsánĩ ꞌbadrị̂ kí rá, ꞌdĩ kí ũpi ị̃rị̃ ꞌbá Ãmọ́rị̃ ꞌbadrị́ Ị̃yị́ Yõrĩdánĩ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ ꞌbadrị̂ kî. ");
INSERT INTO luc_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Ãngũ ꞌdĩ se ru angájó táwụ̃nị̃ Ãrówã gá, áꞌbụ tị Ãrị̃nọ́nị̃ drị̂ gá kpere ꞌBé Sị̃yọ́nị̃ (ꞌdĩ ꞌBé Hẹ̃rị̃mọ́nị̃) gá. ");
INSERT INTO luc_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Umú kí ãngũ Ãrábã drị̂ Yõrĩdánĩ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ pírí cajó Ị̃yị́ umvelé Mĩrĩ ãꞌị́ ru rĩ ꞌbã wókõ ándrá rĩ gá, kpere ꞌBé Pị́sị̃gã ꞌbã pá gá. ");
INSERT INTO luc_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Mụ́sã umve ꞌbá Ịsịrayị́lị̃ drị̂ kí pírí ãngũ ãlu gá ãzíla jọ ĩꞌbanî, “Ĩmi ꞌbá Ịsịrayị́lị̃ drị́ ꞌdĩ, ĩmi are drĩ ãzị́táŋá pírí ãzíla ị́jọ́ mání azịlé ĩminí ụ́ꞌdụ́ ãndrũ ꞌdõ sĩ rĩ kî. Ĩmi ụ̃nị̃ kí ãzíla ĩmi ũbĩ kí vú. ");
INSERT INTO luc_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","ꞌBé Hõrébũ sị́ gá ꞌdãá, Úpí Ãdróŋá ãmadrị̂ idé tị icíma ãma abe, ");
INSERT INTO luc_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Úpí idé tị icíma ꞌdĩ ãma átẹ́pịka kí abe ãzíla ãma úꞌdîꞌda ídri rú ãndrũ ꞌdĩ kí abe ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","ꞌBé sị́ gá ꞌdãá, Úpí jọ ị́jọ́ ĩmi abe mịfị́ gá mịfị́ gá angájó ãcí agâlé. ");
INSERT INTO luc_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Sáwã ꞌdã sĩ, átu pá ĩmi drĩdríŋĩ gá Úpí be sĩ ị́jọ́ ĩꞌdi ꞌbã jọlé rĩ kí vú nzejó ĩminî, ãꞌdusĩku ĩmi ándrá idé agá ãcí sĩ ụ̃rị̃ sĩ sĩ tụjó ꞌbé sị́ gâlé. ꞌDĩ kí ị́jọ́ Úpí ꞌbã jọlé rĩ kî: ");
INSERT INTO luc_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Ma Úpí Ãdróŋá mídrị́ ími anzélépi Mị̃sị́rị̃ gâlé, míní ándrá adrujó ãtíꞌbó ru rĩ sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Lẽ ĩmi ị̃nzị̃ ãdroŋa ãzí kí ku wó lú ma ꞌi áꞌdụ̂sĩ. ");
INSERT INTO luc_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“Lẽ ĩmi idé ĩminí íꞌdá ãko ãzí ꞌbụ̃ gá jõku ụ̃nọ́kụ́ drị̃ gá jõku ị̃yị́ ụ̃nọ́kụ́ ị̃ndụ́ gá rĩ agá rĩ ãni la ku. ");
INSERT INTO luc_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Lẽ ítị̃ ími ãja vụ̃rụ́ ãdroŋa ĩnzõ rú ꞌdĩ ꞌbaní kí ị̃nzị̃jó ãzíla ãzị́ ngajó ĩꞌbaní ku, ãꞌdusĩku ma Úpí Ãdróŋá mídrị̂ ꞌi, ma Úpí Ãdróŋá ãjã rú rĩ ꞌi. Ma drị̃rịma fẽ ꞌbá áma ngụ̃lépi ũnzí ãzíla ị́jọ́ ũnzí ngalépi rĩ ꞌbaní anzị ĩꞌbadrị̂ kí abe cajó kpere áꞌbị́ anzị na ãzíla sụ rĩ ꞌba rụ́. ");
INSERT INTO luc_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Wó ma lẽtáŋá mádrị̂ iꞌda ꞌbá áma lẽlépi rá ãzíla ãzị́táŋá mádrị̂ ãꞌị̃lépi rá rĩ ꞌbã anzị drị̃lẹ́ gâlé álĩfũ álĩfũ rĩ ꞌbaní. ");
INSERT INTO luc_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“Mí ayú Úpí Ãdróŋá mídrị̂ ꞌbã rụ́ ị́jọ́ ũnzí gá ku, ãꞌdusĩku ma Úpí Ãdróŋá mídrị̂ ꞌi, ma drị̃rịma fẽ ꞌbá áma rụ́ ayúlépi yã ꞌdâ rĩ ní rá. ");
INSERT INTO luc_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“Ímba Sãbátũ tã ãzíla íꞌbã ĩꞌdi ndú ãlá ru cécé Úpí Ãdróŋá mídrị̂ ꞌbã azịlé míní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Ínga ãzị́ mídrị̂ kí ụ́ꞌdụ́ ázíyá, ");
INSERT INTO luc_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","wó ụ́ꞌdụ́ ázị̂rị̃ rĩ ĩꞌdi ụ́ꞌdụ́ sãbátũ drị́ sĩ avị́jó pẽlé ndú Úpí Ãdróŋá mídrị̂ ní rĩ ꞌi. Ụ́ꞌdụ́ ꞌdã sĩ, táni mi ꞌi, anzị mídrị̂ kí, ãtíꞌbó mídrị̂ kí, ãnãpká mídrị̂ kí, táni ãmị́yọ́ŋá uꞌálépi mídrị́ko gá ꞌdâ rĩ kí abe pírí ꞌbã nga kí ãzị́ ku, ãtíꞌbó mídrị̂ ꞌbã avị́ kí cécé míní avị́lé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Mí ũrã drĩ ị́jọ́ míní ándrá adrujó Mị̃sị́rị̃ gâlé ãtíꞌbó ru rĩ, wó ma Úpí Ãdróŋá mídrị̂ ꞌi, má anzé mi drị́ ũkpõ má drị́ ãmbógó calépi rá rĩ sĩ. Ị́jọ́ ꞌdĩ bãsĩ mání lẽjó la mí ị̃nzị̃ ụ́ꞌdụ́ sãbátũ drị̂ ꞌi ĩꞌdi ꞌbãjó ãlá ru ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“Íru mî átẹ́pị kí mî ãndrẽ be, cécé Úpí Ãdróŋá mídrị̂ ꞌbã azịlé míní rĩ áni, ị́jọ́ ꞌdĩ sĩ mi adru drị̃lẹ́ba rú, mi dó sĩ uꞌá ílí ãzo rú ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã mụlé fẽlé míní rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“Lẽ íꞌdị ꞌbá ku. ");
INSERT INTO luc_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“Lẽ ínga ãwụ̃ ku. ");
INSERT INTO luc_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“Lẽ mí ụ̃gụ̃ ãko ku. ");
INSERT INTO luc_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“Lẽ mí alị́ ĩnzõ ꞌbá ãzí rụ́ ku. ");
INSERT INTO luc_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“Lẽ ími ũlẽ ꞌbã ãngã ꞌbá ãzí ꞌbã ũkú sĩ ku, jó sĩ ku, ãtíꞌbó ĩꞌdidrị̂ sĩ ku, tị́ kí sĩ ku, kãyĩnõ kî sĩ ku, jõku ãko ãzí ĩꞌdi ꞌbã trũ adrujó rĩ kí abe pírí.” ");
INSERT INTO luc_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“ꞌDĩ kí ãzị́táŋá Úpí ꞌbã azịlé ĩmi ꞌbá Ịsịrayị́lị̃ rú ꞌdĩ ꞌbaní ụ́ꞌdụ́kọ́ re sĩ ĩminí ĩmi trajó ꞌbé sị́ gá rĩ sĩ rĩ kî. Ĩꞌdi ꞌbã ị́jọ́ nzejó ụ́ꞌdụ́kọ́ ũkpó la sĩ ãcí agâlé ãzíla ụ̃rụ́ꞌbụ̃ ãnzị rĩ agâlé rĩ sĩ, fẽ ĩminí ãzị́táŋá ꞌdĩ kí, ũꞌbã ãzí la kí kí drị̃ gá ku. ꞌDã ꞌbã ũngúkú gá, Ãdróŋá sĩ ãzị́táŋá ꞌdĩ kí írã ꞌbara-ꞌbara ị̃rị̃ la kí drị̃ gá ãzíla fẽ dó kí ma ꞌi Mụ́sã drị́.” ");
INSERT INTO luc_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","“ꞌDã ꞌbã ũngúkú gá, Mụ́sã mụ ị́jọ́ jọŋá trũ drị̃ gá jọ, ꞌbê lã mụ ãcí akólé velé ãzíla ĩmi mụ ụ́ꞌdụ́kọ́ arelé ãngũ ịnị rĩ gâlé ꞌbo, drị̃lẹ́ ĩmidrị̂ kí ꞌbá ĩyõ ínátị drị̂ kí abe amụ́ kí má rụ́ ꞌdõlé ");
INSERT INTO luc_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","ãzíla jọ kí, ‘Úpí Ãdróŋá ãmadrị̂ iꞌda ándrá ĩꞌdi ꞌbã dị̃zã ãzíla ãmbõgõ ãmaní ĩꞌdi are agá ị́jọ́ jọ agâ ãcí agâlé rĩ sĩ. Ãndrũ ãndre dó rá ꞌbá ꞌbá ru rĩ icó adrulé ídri rú rá Ãdróŋá drĩ táni ị́jọ́ jọ agá ĩꞌdi be rá tí. ");
INSERT INTO luc_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Wó ãma icó dó ãma fẽlé ũdrãlé ị̃dị́ ãꞌdu ị́jọ́ sĩ? Ãcí ãmbógó ꞌdã la ãma ị̃lị̃kị̃ rá. Ãma ũdrã rá ãndá-ãndá ru ãdrĩ Úpí Ãdróŋá ãmadrị̂ ꞌbã ụ́ꞌdụ́kọ́ are ị́jọ́ jọ agá ị̃dị́ rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","ꞌBá ãzí acelépi ídri rú ĩꞌdi ꞌbã Ãdróŋá ídri rĩ ꞌbã ụ́ꞌdụ́kọ́ arejó ãcí agâlé rĩ ꞌbã vúlé gá la cí yã? ");
INSERT INTO luc_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Mụ́sã, ígõ vúlé mụlé ị́jọ́ pírí Úpí Ãdróŋá ãmadrị̂ ꞌbã jọlé ãmaní rĩ kí arelé. ꞌDã ꞌbã ũngúkú gá, mí ãgõ dó vúlé ãmaní ị́jọ́ ĩꞌdi ꞌbã jọlé míní rĩ kí vú nzelé. Ãma kí are ãzíla kí vú ũbĩ rá.’ ");
INSERT INTO luc_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","“Úpí la mụ ị́jọ́ ꞌdĩ arelé ꞌbo, jọ mání, ‘Má are ị́jọ́ ꞌbá ꞌdĩ ꞌbã kí jọlé rĩ rá, ãzíla ị́jọ́ ĩꞌbã kí jọlé rĩ kí múké. ");
INSERT INTO luc_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Wọ́gọ̃! Ụ̃rị̃ drị̃ tá adru ꞌbá ꞌdĩ kí ásị́ gá sáwã pírí sĩ, sĩ ãzị́táŋá mádrị̂ kí tã mbajó la, ị́jọ́ ꞌdĩ sĩ kí tá adru drị̃lẹ́ba rú anzị ĩꞌbadrị̂ kí abe jãꞌdâ! ");
INSERT INTO luc_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Ímụ, ílũ ĩꞌbaní ꞌbã gõ kí vúlé hémã ĩꞌbadrị̂ kí agâlé. ");
INSERT INTO luc_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Wó Mụ́sã mi ꞌi rĩ gá, mí adru má be ꞌdâ, ma dó sĩ míní ãzị́táŋá mádrị̂ kí fẽ ị́jọ́ mání azịlé rĩ abe pírí, mi dó sĩ kí imbá sĩ ãzị́táŋá ꞌdĩ kí vú ũbĩjó ãngũ mání mụlé fẽlé ĩꞌbaní rĩ gá.’” ");
INSERT INTO luc_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Mụ́sã jọ ị́jọ́ ꞌbá Ịsịrayị́lị̃ drị̂ kí abe ị̃dị́ jọ, “Ĩmi ꞌbá Ịsịrayị́lị̃ drị́ ꞌdĩ, lẽ ĩmi adru mịfị́ trũ sĩ ndrejó la ĩnga ị́jọ́ pírí Úpí Ãdróŋá ĩmidrị̂ ꞌbã azịlé ĩminí ꞌdĩ kí rá. Ĩmi aꞌbe jõ ãzíla ãmvé tãmbaŋá kóru ku. ");
INSERT INTO luc_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Ĩmba jõ ãzị́táŋá Úpí Ãdróŋá ĩmidrị̂ drị̂ kí tã pírí, ị́jọ́ ꞌdĩ sĩ ị́jọ́ ĩmidrị̂ kí dó sĩ adru pírí drị̃lẹ́ba rú ãzíla ĩmi dó sĩ uꞌá sáwã ãzo rú ãngũ mání fẽlé ĩminí rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Mụ́sã mụ ị́jọ́ jọŋá trũ drị̃ gá jọ, “ꞌDĩ kí ãzị́táŋá Úpí Ãdróŋá ĩmidrị̂ ꞌbã azịlé lẽ má imbá kí ĩminí rĩ kî. Ĩmi ũbĩ kí vú ĩminí Mĩrĩ Yõrĩdánĩ zajó sĩ fijó ãngũ mání azịlé ĩmi ꞌdụ la ãko ĩmĩni la rú rĩ gâlé rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Ị́jọ́ ꞌdĩ sĩ, anzị mídrị̂ kí anzị ĩꞌbadrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ abe, kí Úpí Ãdróŋá mídrị̂ ụ̃rị̃ ụ́ꞌdụ́ míní adrujó ídri rú rĩ kî sĩ pírí, ãzị́táŋá ĩꞌdidrị́ mání fẽlé mídrị́ rĩ kí tã mbajó pírí, ị́jọ́ ꞌdĩ sĩ, mi dó sĩ uꞌá ãngũ ꞌdã gá ꞌdãá sáwã ãzo rú. ");
INSERT INTO luc_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Ĩmi are ãzị́táŋá ꞌdĩ kí, ĩmi ꞌbá Ịsịrayị́lị̃ drị́ ꞌdĩ, ãzíla ĩmi adru mịfị̂ trũ sĩ kí tã mbajó, ị́jọ́ ꞌdĩ sĩ, ị́jọ́ ĩmidrị̂ kí dó sĩ pírí adru múké ãzíla ĩmi mụ kpẹ̃lé ũꞌbí ru ãngũ málĩ trũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ ãnụ́ ꞌbã sĩ rajó ala gá lé trũ rĩ gá, cécé Úpí Ãdróŋá ĩmĩ áyị́pịka ꞌbadrị̂ ꞌbã azịlé ĩminí rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Mụ́sã mụ drị̃ gá jọ, “Mí are drĩ, Ịsịrayị́lị̃: Úpí Ãdróŋá ãmadrị̂ ꞌbãngá lú Úpí ãlu áꞌdụ̂sĩ. ");
INSERT INTO luc_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Ílẽ Úpí Ãdróŋá mídrị̂ ími ásị́ pírí sĩ, ími ídri pírí sĩ, ími ũkpó pírí sĩ ãzíla ími ũndũwã pírí sĩ. ");
INSERT INTO luc_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Ãzị́táŋá mání fẽlé míní ãndrũ ꞌdĩ kí ímba kí tã ími asị́ gá. ");
INSERT INTO luc_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Mí imbá kí anzị mídrị̂ ꞌbanî. Mí amvi ãzị́táŋá ꞌdĩ kí ĩꞌbaní míní ri agá vụ̃rụ́ lị́cọ́ gá, míní acị́ agá gẹ̃rị̃ gâsĩ, míní ími la agá vụ̃rụ́ ãzíla míní ãzị́ nga agá. ");
INSERT INTO luc_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Mí úmbé kí ícétáŋá ru ími drị́ gá ãzíla ísụ̃ kí ími androko gá sĩ ími igájó. ");
INSERT INTO luc_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Ísĩ kí báwũ kẹ̃jị́tị gá jó mídrị̂ drị̂ ụrụꞌbá gá ãzíla kẹ̃jị́tị sĩ afíjó lị́cọ́ gá rĩ ụrụꞌbá gá. ");
INSERT INTO luc_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","“Úpí Ãdróŋá mídrị̂ na ándrá ũyõ mî áyị́pịka Ịbụrahị́mụ̃, Ĩsákã ãzíla Yãkóꞌbõ ꞌbaní ꞌi mụ ãngũ ãlá ãmbógó la fẽlé ĩꞌbaní táwụ̃nị̃ wẽwẽ rú ãzíla málĩ trũ míní sịlé mi ꞌi ku rĩ abe. ");
INSERT INTO luc_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","Jó ꞌdĩ kí ꞌa lã ga ãko ũniyambamba ĩminí ꞌbãlé ĩmi ꞌi ku la kí sĩ ãzíla ị̃yị́ kídí ru ĩminí ꞌdịlé ĩmi ꞌi ku la kî sĩ, zãbíbũ ãzíla mị̃zẹ̃yị́tụ̃ ife ĩminí salé ĩmi ꞌi ku la kí abe. ");
INSERT INTO luc_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","Ĩmi adru mịfị̂ trũ sĩ ndrejó la ĩmi ãvĩ ị́jọ́ Úpí ándrá ĩmi anzélépi Mị̃sị́rị̃ gâlé ĩmĩ adrujó ãtíꞌbó ru rĩ sĩ rĩ drị̃ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","“Mí ị̃nzị̃ Úpí Ãdróŋá mídrị̂ ꞌi, ínga ãzị́ ĩꞌdiní áꞌdụ̂sĩ ãzíla ína ũyõ mídrị̂ kí lú ĩꞌdi ꞌbã rụ́ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","“Ĩmi ị̃nzị̃ ãdroŋa ãzí ndú la kí ku, ãdroŋa ãzí ꞌbá ĩmĩ jĩránĩ rú rĩ ꞌbadrị̂ kî. ");
INSERT INTO luc_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Ídrĩ ãdroŋa ndú ꞌdĩ kí ị̃nzị̃, ãjã Úpí Ãdróŋá mídrị̂ drị̂ la asị́ ími drị̃ gá cécé ãcí áni ãzíla ĩꞌdi ími ivé rúmú-rúmú, ãꞌdusĩku Úpí Ãdróŋá mídrị́ adrulépi mi be cí rĩ ta ꞌbãngá ꞌbá ãzí ụ̃ꞌbị̃drị̃ŋá idélépi ĩꞌdi be la ku. ");
INSERT INTO luc_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","“Ĩꞌbã jõ Úpí Ãdróŋá ĩmidrị̂ ụ̃ꞌbị̃táŋá agá cécé ĩminí ándrá idélé Másã gá rĩ áni ku. ");
INSERT INTO luc_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Ĩmi adru múké-múké sĩ ndrejó la ĩmba ãzị́táŋá Úpí Ãdróŋá ĩmidrị̂ drị̂ kí tã ãzíla ị́jọ́ ĩꞌdi ꞌbã azịlé rĩ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Ĩnga ị́jọ́ pịrị ãzíla múké rĩ kí Úpí ꞌbã mẹ́lẹ́tị gá áyụ, ị́jọ́ ꞌdĩ sĩ, ị́jọ́ ĩmidrị̂ kî dó sĩ adru pírí drị̃lẹ́ba rú. Ĩmi sĩ icó ãngũ ãlá mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ Úpí ꞌbã ándrá ũyõ najó ĩmĩ áyị́pịka ꞌbaní rĩ ꞌdụjó ĩmĩ ãko rú, ");
INSERT INTO luc_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","ãzíla ĩmi mụ mẹ́rọ́ꞌbá ĩmidrị̂ kí drolé Úpí ꞌbã azịlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“Ụ́ꞌdụ́ ãzí sĩ anzị ĩmidrị̂ kí ími zị, ‘Úpí Ãdróŋá ãmadrị̂ fẽ ãmaní ãzị́táŋá ꞌdĩ kí ị́jọ́ azịlé rĩ abe tã mbalé pírí íni ãꞌdu ị́jọ́ sĩ?’ ");
INSERT INTO luc_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ꞌDã ꞌbã ũngúkú gá, ĩjọ anzị ĩmidrị̂ ꞌbaní, ‘Ãma ándrá ãtíꞌbó ru úpí Mị̃sị́rị̃ drị̂ pálé gá, wó Úpí anzé ãma drị́ ũkpõ ĩꞌdidrị́ gá ãmbógó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Ãndre tálí Úpí ꞌbã idélé rĩ kí ãma mịfị́ sĩ ãzíla idé ị́jọ́ ụ̃rị̃ fẽlépi la kí ꞌbá Mị̃sị́rị̃ rú rĩ ꞌba rụ́, Fãráwũ rụ́ ãzíla drị̃lẹ́ka ĩꞌdidrị̂ ꞌba rụ́ pírí. ");
INSERT INTO luc_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Wó anzé ãma angájó Mị̃sị́rị̃ gâlé sĩ ãma ajíjó ꞌdâ ãzíla sĩ ãmaní ãngũ ꞌdĩ fẽjó ándrá ĩꞌdi ꞌbã ũyõ la najó ãmã áyị́pịka ꞌbaní ꞌi fẽ la rá rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","ꞌDã ꞌbã ũngúkú gá, Úpí Ãdróŋá ãmadrị̂ azị ãmaní ị́jọ́ sĩ ãzị́táŋá ĩꞌdidrị̂ kí tãmbajó pírí ãzíla sĩ ĩꞌdi ị̃nzị̃jó. Ãdrĩ idé la ꞌdĩ ꞌbã áni rá, ĩꞌdi mụ sáwã pírí sĩ sụ́rụ́ ãmadrị̂ tã mbalé ãzíla ĩꞌdi fẽ la ꞌba adru ãlá ru málĩ trũ. ");
INSERT INTO luc_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Ãdrĩ ị́jọ́ pírí ãzị́táŋá ru Úpí Ãdróŋá ãmadrị̂ ꞌbã lẽlé rĩ kí tã mba rá, Ãdróŋá la ãma lã ꞌbá mgbã rú.’” ");
INSERT INTO luc_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Úpí Ãdróŋá mídrị̂ la ími agụ ãngũ ĩꞌdi ꞌbã mụlé fẽlé míní ꞌdụlé rĩ gâlé ãzíla ĩꞌdi ꞌbá Hị́tị̃ drị́, Gị̃rị̃gásị̃ drị́, Ãmọ́rị̃ drị́, Kãnánĩ drị́, Pẹ̃rẹ́zị̃ drị́, Hị́vị̃ drị́ ãzíla Yẹ̃bụ́sị̃ drị́ sụ́rụ́ ázị̂rị̃ kãlãfe ĩꞌbadrị̂ ꞌbã sĩ adrujó ũꞌbí ru ãzíla ũkpõ trũ ꞌdĩ kí dro rá. ");
INSERT INTO luc_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Úpí Ãdróŋá mídrị̂ drĩ dó ꞌbá ꞌdĩ kí fẽ ími drị́ alé gá sĩ kí ndẽjó rá, lẽ mí ị̃lị̃kị̃ kí pírí. Mí icí tị ĩꞌba abe ku jõku mí iꞌda ĩꞌbaní ásị́ ị̃gbẹ̃ ku. ");
INSERT INTO luc_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Ĩmi ĩgbã kí ĩminí ũkú ru ku. Lẽ anzị ĩmidrị̂ kí izonzi abe ꞌbã ĩgbã kí ru ĩꞌba abe ãluŋá la ku, ");
INSERT INTO luc_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","ãꞌdusĩku icó kí anzị ĩmidrị̂ kí fẽlé áma gãlé ị̃nzị̃lé úmgbé sĩ ãdroŋa ndú ꞌdĩ kí ị̃nzị̃jó ãzíla ãzị́ ngajó ĩꞌbanî. Ị́jọ́ ꞌdĩ ꞌbã áni rĩ drĩ ru idé rá, Úpí la acá ĩminí ũmbã sĩ ãzíla ĩꞌdi cọtị ĩmi ị̃lị̃kị̃ rá. ");
INSERT INTO luc_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Ị́jọ́ ꞌdĩ sĩ, ĩmi andi ãlĩtárĩ ĩꞌbã kí sịlé rĩ kí rá, írã ĩꞌbã kí ꞌbãlé ndú ị̃nzị̃lé ị̃nzị̃ ꞌdĩ kí ĩmi aco kí kpékpé. Ĩmi aga ị́dị́ŋá ãdróŋá ũkú ru umvelé Ãsérã rĩ drị̂ kí vụ̃rụ́ ãzíla ĩmi ivé ãdroŋa ĩnzõ rú rĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Mí idé ị́jọ́ ꞌdĩ kí ꞌdĩ ꞌbã ãni la ãꞌdusĩku mi ꞌbá Úpí Ãdróŋá mídrị̂ ãni. Pẽ mi adrujó ndú ĩꞌdi ꞌbã ꞌbá ru angájó sụ́rụ́ pírí ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ kí agá. ");
INSERT INTO luc_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","“Úpí lẽ ãzíla pẽ ĩmi íni la adru ĩndẽ sụ́rụ́ ãzí ꞌdĩ kí kãlãfe sĩ rá rĩ sĩ la ku, pẽ ĩmi ĩꞌdi ꞌbã ĩmi lẽjó rá rĩ sĩ, ĩmi ꞌbá ụ̃nọ́kụ́ drị̃ gá rĩ kí agá ꞌdâ wereŋá ru ãndânĩ. ");
INSERT INTO luc_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Wó Úpí lẽ ĩmi rá ãzíla mba ũyõ ĩꞌdi ꞌbã ándrá nalé ĩmĩ áyị́pịka ꞌbaní rĩ tã rá. ꞌDĩ bãsĩ ị́jọ́ ĩꞌdi ꞌbã sĩ ĩmi apájó drị́ ũkpõ ĩꞌdidrị̂ sĩ ãzíla ĩꞌdi ꞌbã sĩ ĩmi anzéjó úpí Mị̃sị́rị̃ drị̂ drị́ alé gá sáwã ándrá ĩminí adrujó ãtíꞌbó ru úpí Fãráwũ drị́ Mị̃sị́rị̃ gâlé rĩ sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Lẽ mí ãvĩ jõ ị́jọ́ Úpí Ãdróŋá mídrị̂ ĩꞌdi Ãdróŋá ꞌi ãzíla ĩꞌdi ãꞌị̃táŋá trũ rĩ ku. Ĩꞌdi tị icíma ándrá ĩꞌdi ꞌbã icílé mí be rĩ tã mba ãzíla lẽtáŋá ĩꞌdidrị́ ukólépi ku rĩ iꞌda anzị drị̃lẹ́ gâlé álĩfũ álĩfũ ĩꞌdi lẽlépi ãzíla ãzị́táŋá ĩꞌdidrị̂ kí tã mbalépi rĩ ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Wó ĩꞌdi ꞌbá ĩꞌdi ngụ̃lépi ũnzí rĩ ꞌbaní drị̃rịma fẽ rá. ");
INSERT INTO luc_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Ị́jọ́ ꞌdĩ sĩ ĩmba ãzị́táŋá mání azịlé míní ꞌdĩ kí tã múké-múké.” ");
INSERT INTO luc_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Mụ́sã mụ ị́jọ́ jọŋá trũ drị̃ gá jọ, ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ídrĩ ãzị́táŋá ꞌdĩ kí are ãzíla tã mba ásị́ mgbã sĩ rá Úpí Ãdróŋá mídrị̂ la tị icíma ĩꞌdidrị́ mí be rĩ tã mba jãꞌdâ ãzíla ĩꞌdi míní lẽtáŋá ĩꞌdidrị́ ukólépi ku rĩ iꞌda ándrá ĩꞌdi ꞌbã ũyõ la najó mî áyị́pịka ꞌbaní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Ĩꞌdi ĩmi lẽ ãzíla ĩminí sụ̃sụ́ wi, ĩmi dó sĩ kpẹ̃ ãzíla ĩmi adru anzị trũ ũꞌbí ru, ĩꞌdi ĩminí sụ̃sụ́ wi ámvụ́ ĩmidrị̂ kí drị̃ gá, ị́jọ́ ꞌdĩ sĩ ãná, wáyĩnĩ úꞌdí rĩ ãzíla ãdu kí dó sĩ adru ĩminí cí ãzíla ĩꞌdi ĩminí sụ̃sụ́ wi ãnãkpá ĩmidrị́ tị́, kãbĩlõ, ị̃ndrị́ ꞌdĩ kí drị̃ gá, ãngũ ándrá ĩꞌdi ꞌbã ũyõ najó ĩmĩ áyị́pịka ꞌbaní rĩ ĩꞌdi dó sĩ mụ fẽlé la ĩminî. ");
INSERT INTO luc_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","ꞌBá ãzí ụ̃nọ́kụ́ drị̃ gá ꞌdâ sĩ ĩꞌbaní sụ̃sụ́ wijó icólépi adrulépi málĩ trũ ĩminí ãndânĩ la kí adru ꞌdá yụ. Ãgọbị, ũkú ãzíla ãnãkpá ĩmidrị̂ kí abe icó kí adrulé úndó ru ku. ");
INSERT INTO luc_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Úpí la ĩmi tã mba ãyánĩ ũnzíkákãnã ándrá ĩminí ndrelé Mị̃sị́rị̃ gâlé rĩ kí sĩ, wó rá la ĩꞌdi kí fẽ mẹ́rọ́ꞌbá ĩmidrị̂ kí rụlé áyụ. ");
INSERT INTO luc_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Lẽ mí ị̃lị̃kị̃ ꞌbá Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé ị̃lị̃kị̃lé ími drị́ alé gá rĩ kí pírí rá; ĩꞌbã ízákĩzã ꞌbã agá míní ku. Mî ị̃nzị̃ ãdroŋa ĩꞌbã kí ị̃nzị̃lé rĩ kí ku ãzíla ínga ãzị́ ĩꞌbaní ku, ídrĩ ãdroŋa ĩꞌbadrị̂ kí ị̃nzị̃ rá, kí adru míní ímbá ru. ");
INSERT INTO luc_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“Lẽ ĩjọ jõ ꞌbá ꞌdĩ kí ꞌbã kãlãfe ũꞌbí ru ĩminí ãndânĩ ãzíla ĩmi icó dó sĩ sụ́rụ́ ꞌdĩ kí ndẽlé ku íni la ku. ");
INSERT INTO luc_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Mí idé ụ̃rị̃ sĩ kí sĩ ku, lẽ mí ũrã jõ drĩ ị́jọ́ ándrá Úpí Ãdróŋá mídrị̂ ꞌbã ngalé Fãráwũ ụrụꞌbá gá ꞌbá ĩꞌdidrị́ Mị̃sị́rị̃ gá rĩ abe rĩ kí pírí ãzíla mí ãvĩ jõ kí ku. ");
INSERT INTO luc_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Mí ũrã jõ drĩ ị́jọ́ jụ́wẹ̃ ũnzíkãnã ándrá Úpí Ãdróŋá mídrị̂ ꞌbã ajílé ꞌbá Mị̃sị́rị̃ gá rĩ kí drị̃ gá míní ndrelé ími mịfị́ sĩ cé rĩ kí ꞌbã ị́jọ́. Ị́jọ́ ícétáŋá ru, tálí ru, ụ̃sụ̃táŋá ru, ụ̃ꞌbị̃táŋá ãmbogo ãmbogo ãzíla drị́ ũkpó ĩꞌdidrị́ ĩꞌdi ꞌbã sĩ ími anzéjó rĩ kí abe. Gẹ̃rị̃ ãlu ĩꞌdi ꞌbã sĩ ꞌbá Mị̃sị́rị̃ drị̂ kí ị̃lị̃kị̃jó rĩ sĩ, ĩꞌdi mụ ꞌbá míní idéjó kî sĩ ụ̃rị̃ sĩ ꞌdĩ kí ị̃lị̃kị̃lé pírí rá. ");
INSERT INTO luc_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Úpí Ãdróŋá mídrị̂ la kí ụrụꞌbá fẽ ãcí colé kpĩrí-kpĩrí kí drĩdríŋĩ gá ãzíla ĩꞌdi ꞌbá apálépi ru zị̃lépi ĩnzõ rĩ kí ị̃lị̃kị̃ rá. ");
INSERT INTO luc_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Ị́jọ́ ꞌdĩ sĩ mí idé ụ̃rị̃ sĩ ꞌbá ꞌdĩ kí sĩ ku. Úpí Ãdróŋá mídrị̂ ĩꞌdi mi be cí; ĩꞌdi Ãdróŋá ãmbógó ꞌbání rulé rũrũ la. ");
INSERT INTO luc_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Úpí Ãdróŋá mídrị̂ la mụ sụ́rụ́ ꞌdĩ kí drolé ími drị̃lẹ́ gá ꞌdâ jãjã rú rá. Mí icó kí ị̃lị̃kị̃lé pâlé ãlu cọtị́ la ku, ãꞌdusĩku ĩdrĩ kí ị̃lị̃kị̃ pâlé ãlu cọtị́ ãnãkpá ásé agá rĩ kí kpẹ̃ wẽwẽ rú ãzíla ãnãkpá ꞌdĩ kí mụ acálé ĩmi abe ũnzí ku rá. ");
INSERT INTO luc_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Úpí Ãdróŋá mídrị̂ la mẹ́rọ́ꞌbá mídrị̂ kí fẽ aꞌdélé ími drị́ alé gá ãzíla kí idé ụ̃rị̃ sĩ kpere míní kí ị̃lị̃kị̃ agá. ");
INSERT INTO luc_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Ĩꞌdi ũpi ĩꞌbadrị̂ kí fẽ ími drị́ alé gá, mi kí ị̃lị̃kị̃ rá ãzíla kí ị́jọ́ la ãvĩ rá. ꞌBá ãzí icó ími drị̃ tẽlé ãꞌdị́ sĩ ku, mi kí ị̃lị̃kị̃ ụ̃nọ́kụ́ drị̃ gá ꞌdâ pírí rá. ");
INSERT INTO luc_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Mí ivé íꞌdá ĩꞌbã kí ị̃nzị̃lé ị̃nzị̃ rĩ kí rá. Ími ũlẽ ꞌbã ãngãjõ sílĩvã ãzíla gólũdĩ sĩ kí idéjó rĩ kí sĩ, sĩ kí ꞌdụjó míní ku. Ídrĩ kí ꞌdụ míní rá ĩꞌdi adru ị́jọ́ ãzí ũnzíkákãnã rú Ãdróŋá drị̃lẹ́ gá la ãꞌdusĩku Úpí Ãdróŋá mídrị̂ ngụ̃ íꞌdá ị̃nzị̃jó ĩꞌdi kẹ̃jị́ gá rĩ ũnzí. ");
INSERT INTO luc_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Mí ají ãdroŋa idélé drị́ sĩ ꞌdĩ kí ꞌbã ãzí mídrị́ lị́cọ́ gá ku, ídrĩ kí ají rá áwãtáŋá kí wãjó rĩ la ru uja ími drị̃ gá. Lẽ íngụ̃ ãko ꞌdĩ kí ũnzí ãꞌdusĩku Ãdróŋá wã kí rá.” ");
INSERT INTO luc_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ĩmi adru mịfị̂ trũ sĩ ãzị́táŋá mání fẽlé ĩminí ꞌdĩ kí tã mbajó ásị́ pírí sĩ ĩmi dó sĩ uꞌá ídri, ĩmi dó sĩ kpẹ̃ ũꞌbí ru ãzíla ĩmi dó sĩ ãngũ ándrá Úpí ꞌbã ũyõ la najó ꞌi fẽ la ĩmi áyị́pịka ꞌbaní rĩ ꞌdụ ĩminí la rú. ");
INSERT INTO luc_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Mí ũrã jõ ị́jọ́ Úpí Ãdróŋá mídrị̂ ꞌbã ándrá ími drị̃ aꞌdéjó ãcị̃ ãzo ãngũ kõtórõ rú rĩ gâsĩ ílí kãlị́ sụ alịlépi ꞌdĩ kí agá, ĩꞌdiní sĩ ãfó ími ꞌa gá rĩ nzejó ãzíla ími ụ̃ꞌbị̃jó sĩ lẽjó nị̃jó la ãko míní lẽlé idélé rĩ kí ãꞌdu ãzíla mí icó ãzị́táŋá ĩꞌdidrị̂ kí tã mbalé rá yã jõku yụ yã rĩ. ");
INSERT INTO luc_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Úpí fẽ míní adrujó ãbị́rị́ sĩ sĩ ãfó ími agá rĩ nzejó ãzíla fẽ míní mãnã nalé, íná míní jõ drĩ nalé mî áyị́pịka kí abe ku la. Idé ị́jọ́ ꞌdĩ íni la sĩ ími imbájó sĩ nị̃jó la ꞌbá icó lú adrulé ídri rú ãkónã sĩ áꞌdụ̂sĩ ku, wó ị́jọ́ pírí ãfũlépi Úpí tị gá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Ílí kãlị́ sụ ꞌdĩ kí agá bõngó de ími ụrụꞌbá gá ku ãzíla ími pá ãvõ kí ku. ");
INSERT INTO luc_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Lẽ ínị̃ rá Úpí Ãdróŋá mídrị̂ la ími co ãzíla míní drị̃rịma fẽ cécé átẹ́pị ní ĩꞌdi ꞌbã anzị kí ị̃ndụ́ cojó ímbátáŋá ru rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","“Ị́jọ́ ꞌdĩ sĩ lẽ ímba ãzị́táŋá Úpí Ãdróŋá mídrị̂ drị̂ kí tã, mí uꞌá gẹ̃rị̃ ĩꞌdi ꞌbã lẽlé rĩ sĩ ãzíla ífẽ ĩꞌdiní ãrútáŋá. ");
INSERT INTO luc_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Úpí Ãdróŋá mídrị̂ la ími agụ ãngũ ãlá mụ̃ꞌdụ̃-mụ̃ꞌdụ̃, ãngũ ị̃yị́ dịlépi dị̃-dị̃ rĩ trũ, kídí ãzíla ị̃yị́ agbẹ́lépi vũ gâlé dịlépi áꞌbụ agâ sĩ, ");
INSERT INTO luc_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","ãngũ ãná ngánũ rú ãzíla ãná bálẽ rú, zãbíbũ, úlúgó ife, põmũgũránãtĩ ife ãzíla mị̃zẹ̃yị́tụ̃ ife ãdu ũfũlépi rĩ ꞌbã kí adrujó ala gá ãnụ́ trũ rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Ĩꞌdi ãngũ ãkónã ꞌbã sĩ adrujó ala gá wẽwẽ rú ãzíla ãko ãzí ꞌbã sĩ ĩcẽjó ala gá ku la. Ĩꞌdi ãngũ aya ꞌbã sĩ abájó ala gá cécé írã áni ãzíla kópã ꞌbã sĩ adrujó túpũ la kí gá wẽwẽ rú rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Ídrĩ dó ãkónã na sĩ agajó ꞌbo, mí ịcụ́ dó Úpí Ãdróŋá mídrị̂ ꞌi ãngũ ãlá mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ ĩꞌdiní fẽlé míní rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“Mí adru mịfị̂ trũ, lẽ mí ãvĩ ị́jọ́ Úpí Ãdróŋá mídrị̂ drị̃ gá ku, mí ũbĩ ãzị́táŋá ĩꞌdidrị́ mání fẽlé míní ãndrũ ꞌdĩ kí vú múké-múké mí ãvĩ kí ị́jọ́ ku. ");
INSERT INTO luc_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Ị́jọ́ ꞌdĩ sĩ ãkónã míní lẽlé nalé rĩ drĩ kí dó adru míní pírí cí, ídrĩ dó jó ãlá la kí sị sĩ uꞌájó ala gá, ");
INSERT INTO luc_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ãnãkpá mídrị́ tị́ ru ãzíla kãbĩlõ rú rĩ drĩ kí tị wẽwẽ rú rá, gólũdĩ, sílĩvã ãzíla ãko ãzí míní trũ adrujó ndú-ndú ꞌdĩ kí abe drĩ kí kpẹ̃ rá, ");
INSERT INTO luc_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","lẽ mí adru jõ ãfó ru sĩ ị́jọ́ ãvĩjó Úpí Ãdróŋá mídrị́ ándrá ími apálépi ꞌbá Mị̃sị́rị̃ drị̂ kí drị́ alé gá míní adrujó ãtíꞌbó ru rĩ sĩ rĩ drị̃ gá sĩ ĩꞌdi gãjó úmgbé ku. ");
INSERT INTO luc_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Aꞌdé ími drị̃ ãngũ kõtórõ rú wada ụ̃rị̃ ní sĩ ꞌbá rụjó cí, ị̃nị̃ ũjũ trũ rĩ ꞌbã kí adrujó ala gá ítóniŋá trũ rĩ gâsĩ. Ãngũ ãꞌí ị̃yị́ kóru rĩ gá fẽ ị̃yị́ ní ãfũjó írã ụrụꞌbá gá mínî. ");
INSERT INTO luc_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Kõtórõ agâlé Ãdróŋá fẽ míní mãnã nalé, ãkónã mî áyị́pịka ꞌbã kí nalé kí ídri gá ku la sĩ ãfó ími ꞌa gá rĩ nzejó ãzíla ími ụ̃ꞌbị̃jó sĩ lẽjó nị̃jó la ãko míní lẽlé idélé rĩ kí ãꞌdu ími sĩ ãsị̃ŋá gá ãko ũniyambamba Ãdróŋá ꞌbã sĩ míní sụ̃sụ́ ãlá rĩ wijó kí drị̃ gá rĩ kí ịsụ́ benĩ. ");
INSERT INTO luc_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Mí ũrã jõ ị́jọ́ ími ásị́ gâlé jọjó la mi ũndũwã rú ãzíla ãzị́ míní ngalé ũkpó ru ími drị́ sĩ rĩ fẽ míní adrujó málĩ trũ nĩ íni la ku. ");
INSERT INTO luc_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Lẽ mí ũrã jõ ị́jọ́ Úpí Ãdróŋá mídrị̂ la míní ũkpõ fẽ sĩ adrujó málĩ trũ rĩ gá nĩ rĩ ꞌi. Idé ị́jọ́ ꞌdĩ íni la ĩꞌdiní tị icíma ándrá ĩꞌdi ꞌbã ũyõ la najó mí áyị́pịka abe rĩ tã mbajó kpere ãndrũ rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Ma ãndrũ ĩmi bị́lẹ́-ị̃ndụ́ li, ĩdrĩ Úpí Ãdróŋá mídrị̂ drị̃ gá ị́jọ́ ãvĩ rá jõku ĩdrĩ tị uja sĩ ãdroŋa ãzí ꞌdĩ kí ị̃nzị̃jó ãzíla sĩ ãzị́ ngajó ĩꞌbanî, ĩmi ị̃lị̃kị̃ rá ãndá-ãndá ru. ");
INSERT INTO luc_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Ĩdrĩ Úpí Ãdróŋá ĩmidrị̂ ꞌbã tị are ku, ĩꞌdi mụ ĩmi ị̃lị̃kị̃lé cécé ĩꞌdi ꞌbã mụjó sụ́rụ́ ãzí ꞌdĩ kí ị̃lị̃kị̃jó rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Mí are drĩ mi Ịsịrayị́lị̃. Ãndrũ mi dó ãni rú sĩ Ị̃yị́ Yõrĩdánĩ zajó sĩ fijó sụ́rụ́ ãmbógó ãzíla ũkpó sĩ ími ndẽlépi rá rĩ kí drojó sĩ ãngũ ĩꞌbadrị̂ ꞌdụjó rá. Táwụ̃nị̃ la kí mgbọ rú ãzíla Bõrõ sĩ kí andre cejó rĩ zo kí wị́lị́wị́lị́ kpere ꞌbụ̃ gâlé. ");
INSERT INTO luc_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","ꞌBá ala gá Ãnákĩ rú rĩ kí ãzo rú ãzíla ũkpó ru, ínị̃ ị́jọ́ kí drị̃ gá cé ãzíla mí are ị́jọ́ jọlé ꞌdĩ rá, ‘Ãꞌdi la pá tu anzị Ãnákĩ drị̂ kí drị̃lẹ́ gá nĩ yã?’ ");
INSERT INTO luc_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Wó ãndrũ lẽ ínị̃ rá Úpí Ãdróŋá mídrị̂ la mụ ími drị̃lẹ́ gâlé cécé ãcí ãngũ ivélépi ũkpó sĩ rĩ áni. Ĩꞌdi mụ kí ndẽlé ãzíla kí ị̃lị̃kị̃lé ími drị̃lẹ́ gá ꞌdãá rá, ị́jọ́ ꞌdĩ sĩ mi dó sĩ kí dro ãzíla kí ị̃lị̃kị̃ gbõrú cécé ĩꞌdi ꞌbã ị́jọ́ la azịjó rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","“ꞌDã ꞌbã ũngúkú gá, Úpí Ãdróŋá mídrị̂ drĩ sụ́rụ́ ꞌdĩ kí dro ími drị̃lẹ́ gá ꞌdâ ãmvé rá, lẽ íjọ míní cénĩ-cénĩ rú, ‘Úpí ají ma ãngũ ꞌdĩ ꞌdụjó mâ ãni la rú mání adrujó ãlá ru rĩ sĩ la ku.’ Adru íni ku, Úpí Ãdróŋá mídrị̂ la mụ sụ́rụ́ ꞌdĩ kí drolé ími drị̃lẹ́ gá ãmvé la ãꞌdusĩku ĩꞌbã kí ũnzĩkãnã idéjó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Ị́jọ́ ꞌdĩ adru kí mi ãlá ru rĩ sĩ la ku jõku mũkẽ mídrị̂ sĩ míní dó sĩ mụjó ãngũ ĩꞌbadrị̂ ꞌdụjó ꞌdĩ la ku, wó ị́jọ́ sụ́rụ́ ꞌdĩ ꞌbã kí idélé ũnzíkãnã rĩ sĩ, Úpí Ãdróŋá mídrị̂ la kí dro ãmvé ími drị̃lẹ́ gá rá la ãꞌdusĩku lẽ tị icíma ándrá ĩꞌdiní ũyõ najó Ịbụrahị́mụ̃ be, Ĩsákã, ãzíla Yãkóꞌbõ kí abe rĩ ꞌbã ãzị́ ngalé. ");
INSERT INTO luc_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Lẽ ínị̃ cé Úpí Ãdróŋá mídrị̂ fẽ míní ãngũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ ꞌdĩ míní adrujó ãlá ru rĩ sĩ la ku. Adru íni ku, mi ꞌbá drị̃ ũnzí la.” ");
INSERT INTO luc_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Lẽ mí ũrã drĩ ị́jọ́ ándrá míní fẽjó la Úpí Ãdróŋá mídrị̂ ꞌbã uꞌájó míní ũmbã sĩ kõtórõ agâlé rĩ. Ị́jọ́ ꞌdĩ ꞌbã ãvĩ jõ míní ku. Iꞌdójó ụ́ꞌdụ́ míní Mị̃sị́rị̃ aꞌbejó rĩ sĩ kpere ãndrũ míní acá agá ꞌdâ, íri Úpí tị gãlé úmgbé mvujó ĩꞌdi rụ́ ꞌdâ rĩ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","ꞌBé Hõrébũ sị́ gá ꞌdãá ífẽ Úpí ꞌbã ũmbã ní angájó ãzíla ũmbã ĩꞌdidrị́ calépi rá rĩ sĩ tí sĩ ími ị̃lị̃kị̃jó rá. ");
INSERT INTO luc_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Ị́jọ́ ꞌdĩ idé kí ru sáwã mání mụjó ꞌbé sị́ gâlé írã ꞌbara-ꞌbara ị̃rị̃ sĩ ị́jọ́ tị icíma drị̂ sĩjó kí drị̃ gá Úpí ꞌbã sĩ tị icíjó mí be rĩ kí aꞌị́jó rĩ sĩ, má uꞌá ꞌbé sị́ gâlé ụ́ꞌdụ́ kãlị́ sụ ãzíla ị́nị́ kãlị́ sụ, ána jõku ámvụ ãko ãzí ku. ");
INSERT INTO luc_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Úpí ãfẽ mádrị́ írã ꞌbara-ꞌbara ị̃rị̃ ĩꞌdi ꞌbã sĩ ị́jọ́ sĩjó kí drị̃ gá tĩndrímváŋá ĩꞌdidrị̂ sĩ nĩ rĩ kî. Drị̃ la gá ãzị́táŋá pírí Úpí ꞌbã jọlé míní ꞌbé sị́ gá ãcí agâ sĩ, ụ́ꞌdụ́ ꞌbá ꞌbã kí ru trajó ꞌbé pá gá ꞌdãá rĩ sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","“Ụ́ꞌdụ́ kãlị́ sụ ãzíla ị́nị́ kãlị́ sụ ꞌdã ꞌbã kí ukójó ꞌbo rĩ ũngúkú gá, Úpí fẽ írã ꞌbara-ꞌbara ị̃rị̃ tị icíma drị́ ꞌdã kí mádrị́. ");
INSERT INTO luc_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","ꞌDã ꞌbã ũngúkú gá, Úpí jọ mání, ‘Ísị vụ̃rụ̂lé gbõrú, ãꞌdusĩku ꞌbá mídrị́ míní ajílé Mị̃sị́rị̃ gâlé ꞌdã iza kí ru rá ãzíla idé kí ị́jọ́ ũnzí ꞌbo. Uja kí ru ãzị́táŋá mání fẽlé rĩ kí agá ꞌdâ rá, ãzíla idé kí ĩꞌbaní ãdróŋá kãjóŋá ru la aya akálépi aká-akâ rĩ sĩ.’ ");
INSERT INTO luc_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","“Ị́jọ́ ꞌdĩ sĩ, Úpí jọ vâ mání, ‘Ánị̃ ꞌbá ꞌdĩ kí drị̃ ũnzí ãzíla are kí ꞌbá tị ku rĩ gá rá! ");
INSERT INTO luc_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Mí aꞌbe drĩ áma ụtrị́ŋá cã, ma drĩ sĩ ꞌbá ꞌdĩ kí ị̃lị̃kị̃ ãzíla kí rụ́ ịnị́ ụ̃nọ́kụ́ drị̃ gá ꞌdâ rá. Ma ími ꞌbã sụ́rụ́ ũkpó ãzíla ũꞌbĩkãnã sĩ kí ndẽlépi rá la rú.’ ");
INSERT INTO luc_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","“Ị́jọ́ ꞌdĩ sĩ, má asị́ dó ꞌbé sị́ gâlé rĩ sĩ vụ̃rụ́ írã ꞌbara-ꞌbara ị̃rị̃ Úpí ꞌbã sĩ ị́jọ́ tị icíma drị̂ sĩjó kí drị̃ gá rĩ kí trũ áma drị́ gá, íni ꞌdĩ ꞌbê la vâ ꞌdĩ ve sĩ ãcí sĩ. ");
INSERT INTO luc_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Ma mụ ãngũ andrélé, ándre ĩmi idé ị́jọ́ ũnzí la Úpí Ãdróŋá ĩmidrị̂ tị gãjó úmgbé; ĩmi idé ĩminí ãdróŋá ĩnzõ rú kãjóŋá íꞌdá ru la. Ĩmi uja ĩmi bụ́lụ́ gá gbõrú gẹ̃rị̃ Úpí Ãdróŋá ĩmidrị̂ ꞌbã azịlé ĩminí rĩ aꞌbejó rá. ");
INSERT INTO luc_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Ị́jọ́ ꞌdĩ sĩ, áꞌbe írã ꞌbara-ꞌbara áma drị́ gá rĩ kí ĩmi drị̃lẹ́ gá ãzíla andi kí dó sĩ kícíkící rá. ");
INSERT INTO luc_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","“ꞌDã ꞌbã ũngúkú gá, ála ma Úpí drị̃lẹ́ gá kpụ́kụ-kpụ́kụ rú, ụ́ꞌdụ́ kãlị́ sụ ãzíla ị́nị́ kãlị́ sụ ána jõku ámvụ ãko ãzí ku. Má idé íni la ĩminí ị́jọ́ ũnzí idéjó Úpí rụ́ ãzíla fẽjó la ũmbã ꞌbã na ĩꞌdi rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Má idé ũmbã Úpí drị̂ sĩ ụ̃rị̃ sĩ, ãꞌdusĩku ũmbã ꞌdã ca ĩꞌdiní sĩ ĩmi ị̃lị̃kị̃jó rá. Wó Úpí are drĩ vâ ma ị̃dị́ rá. ");
INSERT INTO luc_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Ũmbã na Úpí ꞌi calépi rĩ sĩ tí sĩ ĩꞌdiní Ãrọ́nị̃ ị̃lị̃kị̃jó rá, wó má áꞌị́ vâ Úpí ꞌi ĩꞌdiní sáwã ãlu ꞌdã agá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Ĩmi idé ị́jọ́ ũnzí la ĩminí kãjóŋá idéjó Ãdróŋá ru rĩ sĩ, má aꞌdụ́ kãjóŋá ĩminí idélé rĩ ivélé ãcí sĩ. Má aco ĩꞌdi ãzíla áꞌị ĩꞌdi fúfú ru cécé pụ́trụ́ áni, ãzíla ásũ ĩꞌdi ị̃yị́ adị́lépi vụ̃rụ́ ꞌbé agâlé rĩ agá. ");
INSERT INTO luc_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","“Ĩfẽ ándrá vâ Úpí idé ĩminí ũmbã sĩ Tãbérã gá, Másã gá ãzíla Kị̃bọ̃rọ́tị̃ Hãtávã kí agá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","“Úpí ꞌbã ándrá ĩmi tị ãpẽjó angájó Kãdẹ́sị̃ Bãrĩnéyã gá rĩ sĩ jọ, ‘Ĩmĩ mụ ãngũ mání fẽlé ĩminí ꞌdã ꞌdụlé ĩmi ãni la rú.’ Drị̃ ũnzĩ sĩ ĩgã ãzị́táŋá Úpí Ãdróŋá ĩmidrị̂ drị̂ úmgbé, ĩꞌbã ásị́ ĩꞌdi drị̃ gá sĩ tị la arejó ku. ");
INSERT INTO luc_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Iꞌdójó mání ĩmi nị̃ agá, ĩmi ꞌbá drị̃ ũnzí Úpí ꞌbã tị galépi úmgbé la kî. ");
INSERT INTO luc_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","“Ị́jọ́ ꞌdĩ sĩ, ála ma Úpí drị̃lẹ́ gá kpụ́kụ-kpụ́kụ rú, ụ́ꞌdụ́ kãlị́ sụ ãzíla ị́nị́ kãlị́ sụ, ãꞌdusĩku lẽ ándrá mgbãrĩ gá ĩmi ị̃lị̃kị̃lé rá. ");
INSERT INTO luc_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Má aꞌị́ Úpí ꞌi ãzíla ájọ ĩꞌdinî, ‘Úpí Ãdróŋá ũkpó pírí ꞌdị́pị, mí ị̃lị̃kị̃ ꞌbá mídrị́ míní unzelé drị́ ũkpõ mídrị́ ãmbógó rĩ sĩ Mị̃sị́rị̃ gâlé ãzíla míní ajílé ũkpõ mídrị̂ sĩ ꞌdĩ kí ku fô! ");
INSERT INTO luc_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Mí ũrã drĩ ãtíꞌbó mídrị́ Ịbụrahị́mụ̃, Ĩsákã ãzíla Yãkóꞌbõ kí ị́jọ́. Íꞌbã drĩ ásị́ drị̃ ũnzĩ ꞌbá ꞌdĩ ꞌbadrị́, ũnzĩkãnã ãzíla ị́jọ́ ũnzí ĩꞌbadrị̂ drị̃ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Ị́jọ́ ꞌdĩ la fẽ la ꞌbá Mị̃sị́rị̃ drị̂ kí sĩ amụ́ jọlé la, “Úpí icó ándrá ꞌbá ꞌdĩ kí agụlé ãngũ ĩꞌdiní azịlé ĩꞌbaní rĩ gá ku, agụ kí ụꞌdị́lé kõtórõ agâlé la ĩꞌdi ꞌbã kí ngụ̃jó ũnzí rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Wó ị́jọ́ mgbã sĩ ꞌbá ꞌdĩ kí ꞌbá mídrị̂ kî, míní ũpẽlé adrujó mí ãni la rú, ãzíla míní unzelé ũkpõ mídrị́ ãmbógó rĩ sĩ Mị̃sị́rị̃ gâlé, ãzíla míní ajílé drị́ mídrị̂ ꞌbã ũkpó sĩ rĩ kî.’ ");
INSERT INTO luc_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","“ꞌDã ꞌbã ũngúkú gá, Úpí jọ mání, ‘Mí upa írã ꞌbara-ꞌbara ị̃rị̃ ándrá drị̃drị̃ ꞌdã kî áni, ãzíla mí atụ́ má rụ́ ꞌbé sị́ gá ꞌdõlé. Mí idé vâ Sãndụ́kụ̃ tị icíma drị̂ báwũ sĩ sĩ kí ꞌbãjó. ");
INSERT INTO luc_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Ma mụ ị́jọ́ ándrá mání sĩlé drị̃drị̃ írã ꞌbara-ꞌbara ị̃rị̃ míní andilé rá ꞌdã kí drị̃ gá rĩ kí vúŋá sĩlé írã ꞌbara-ꞌbara ị̃rị̃ míní upalé ꞌdĩ kí drị̃ gá. Mi dó sĩ kí ꞌbã Sãndụ́kụ̃ tị icíma drị̂ agá.’ ");
INSERT INTO luc_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","“Ị́jọ́ ꞌdĩ sĩ, Má idé Sãndụ́kụ̃ tị icíma drị̂ báwũ ꞌbọ́kọ́lọ̃ drị̂ sĩ ãzíla má upa írã ꞌbara-ꞌbara ị̃rị̃ cécé ándrá drị̃drị̃ ꞌdã kî áni, ãzíla áꞌdụ kí áma drị́ gá trũ tụjó kî trũ ꞌbé sị́ gâlé. ");
INSERT INTO luc_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Úpí sĩ írã ꞌbara-ꞌbara ị̃rị̃ ꞌdã kí drị̃ gá ị́jọ́ ándrá sĩlé drị̃drị̃ ꞌdã kí vúŋá, ãzị́táŋá mụdrị́ ĩꞌdiní azịlé ĩminí angájó ãcí agâlé ụ́ꞌdụ́ ándrá ĩminí ĩmi trajó ꞌbé pá gá ꞌdãá rĩ sĩ rĩ kî. Úpí fẽ írã ꞌbara-ꞌbara ị̃rị̃ ꞌdã kí mádrị́. ");
INSERT INTO luc_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","ꞌDã ꞌbã ũngúkú gá, má uja dó sĩ ma asị́lé vụ̃rụ́ ꞌbé sị́ gâlé, áꞌbã írã ꞌbara-ꞌbara ị̃rị̃ ꞌda kí Sãndụ́kụ̃ tị icíma drị́ mání idélé rĩ agá cécé Úpí ꞌbã ãzị́táŋá la fẽjó mání rĩ áni ãzíla írã ꞌbara-ꞌbara ị̃rị̃ ꞌda kí drĩ ãndrũ kpere ala gá ꞌdã.” ");
INSERT INTO luc_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(ꞌBá Ịsịrayị́lị̃ drị̂ angá kí kídí ꞌbá Jãkánĩ drị̂ ꞌbadrị̂ gâsĩ mụjó Mõsérã gá. Ãrọ́nị̃ drã dó Mõsérã gá, ꞌbá ị̃sị̃ kí dó ĩꞌdi ꞌdãá ãzíla ngọ́pị̃ Ị̃lị̃yãzárị̃ acá dó ĩꞌdi kẹ̃jị́ gá átáló ru nĩ. ");
INSERT INTO luc_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Angájó ꞌdãá, mụ kí dó Gũdĩgódã gá, ãzíla mụ kí drị̃ gá Yõtĩbátĩyã gá ãngũ wọ́rọ̃ŋá ru ị̃yị́ trũ la kí agá. ");
INSERT INTO luc_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Sáwã ꞌdã sĩ Úpí pẽ sụ́rụ́ Lẹ́vị̃ drị̂ kí ndú sĩ Sãndụ́kụ̃ Úpí Ãdróŋá drị́ tị icíma drị̂ ujíjó, sĩ ãzị́ ngajó ĩꞌdiní ãtalo rú ãzíla sụ̃sụ́ wijó ꞌbá ꞌbaní ĩꞌdi rụ́ sĩ. ꞌDĩ ãzị́ ĩꞌba kí ngalé kpere ãndrũ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Ị́jọ́ ꞌdĩ bã sĩ sụ́rụ́ Lẹ́vị̃ drị̂ ꞌbaní ãngũ fẽjó ádrị́pịka kí agá ꞌdâ ku ꞌdĩ. Kí ãzãkoma ĩꞌbadrị̂ kí ịsụ́ ãzị́ átáló drị́ ĩꞌbã kí ngalé Úpí ní rĩ tị gá cécé Úpí Ãdróŋá mídrị̂ ꞌbã azịlé rĩ áni.) ");
INSERT INTO luc_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Mụ́sã mụ ị́jọ́ jọŋá trũ drị̃ gá jọ, “Mání uꞌájó ꞌbé sị́ gâlé ụ́ꞌdụ́ kãlị́ sụ ãzíla ị́nị́ kãlị́ sụ mání ándrá idélé drị̃drị̃ rĩ áni ꞌdã sĩ, Úpí are ándrá ma pá alé ãlu rá ãzíla ãꞌị̃ vâ sĩ ĩmi ị̃lị̃kị̃jó ku. ");
INSERT INTO luc_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","ꞌDã ꞌbã ũngúkú gá, Úpí jọ mání, ‘Ímụ ãzíla íce ꞌbá ꞌdĩ kí drị̃ sĩ mụjó fijó ãngũ mání ũyõ najó ma fẽ la ĩmĩ áyị́pịka ꞌbaní rĩ ꞌdụjó ĩꞌbã ãni la rú.’” ");
INSERT INTO luc_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Mụ́sã jọ Ịsịrayị́lị̃ ní, “ꞌdĩ úꞌdîꞌda ị́jọ́ Úpí Ãdróŋá mídrị̂ ꞌbã lẽlé mídrị́ rĩ ꞌi, mí ị̃nzị̃ Úpí Ãdróŋá mídrị̂ ꞌi ãzíla mí ũbĩ ãzị́táŋá ĩꞌdidrị̂ kí vú pírí, ílẽ ĩꞌdi, ínga ãzị́ ĩꞌdiní ásị́ pírí sĩ, ");
INSERT INTO luc_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","ãzíla ímba ãzị́táŋá Úpí drị́ mání fẽlé míní ãndrũ ꞌdĩ kí tã, ị́jọ́ kí dó sĩ adru míní múké. ");
INSERT INTO luc_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","“Ãko pírí kí Úpí Ãdróŋá mídrị̂ ãni, ãko pírí ꞌbụ̃ agá táni ꞌbụ̃ wị́lị́wị́lị́ ꞌdã agá rĩ kí, ãzíla ụ̃nọ́kụ̂ vâ ĩꞌdi ãni ãko ala gá rĩ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Wó lẽtáŋá Úpí drị́ mí áyị́pịka ꞌbaní rĩ ándrá ũkpó ru, ị́jọ́ ꞌdĩ sĩ pẽ dó mi sụ́rụ́ pírí kí drị̃lẹ́ gá ãzíla mi drĩ kpere ãndrũ ꞌbá ĩꞌdi ꞌbã pẽlé rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Ị́jọ́ ꞌdĩ sĩ, lẽ mí ĩtãrã ími ásị́ iꞌdójó úꞌdîꞌda lẽ mí are Úpí tị ãzíla mí aꞌbe drị̃ ũnzĩ cã. ");
INSERT INTO luc_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Úpí Ãdróŋá ĩmidrị̂ ĩꞌdi Ãdróŋá ãdroŋa kí drị̃lẹ́ gá rĩ ꞌi, Úpí ũpi kí drị̃lẹ́ gá rĩ ꞌi, Ãdróŋá ãmbógó ũkpó ꞌdị́pị ꞌi, ãzíla Ãdróŋá ụ̃rị̃lé ụ̃rị̃ ụ̃rị̃ rĩ ꞌi. Uya ꞌbá ku ãzíla ãꞌị̃ ru mịfị́ salé málĩ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Ĩꞌdi ị́jọ́ ĩmvú ꞌbadrị́ ãwụ́zị́ kí abe rĩ lị pịrị-pịrị, lẽ vâ ãmị́yọ́ŋá kí rá ãzíla ĩꞌdi vâ ĩꞌbaní ãkónã fẽ bõngó kí abe rá. ");
INSERT INTO luc_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Ị́jọ́ ꞌdĩ sĩ lẽ ĩlẽ ãmị́yọ́ŋá kí lẽlẽ, ãꞌdusĩku ĩmi ándrá vã ãmị́yọ́ŋá rũ Mị̃sị́rị̃ gâlé. ");
INSERT INTO luc_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Mí ị̃nzị̃ Úpí Ãdróŋá mídrị̂ ꞌi, mí are tị la ãzíla ínga ãzị́ ĩꞌdinî. Írụ ị́jọ́ ĩꞌdidrị̂ kí mgbemgbe ãzíla ína ũyõ ĩꞌdi rụ́ sĩ áꞌdụ̂sĩ. ");
INSERT INTO luc_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Mí ịcụ́ ĩꞌdi rụ́ ãꞌdusĩku ĩꞌdi Ãdróŋá mídrị̂ ꞌi, índre ị́jọ́ ándrá ĩꞌdi ꞌbã idélé ãmbógó ụ̃sụ̃táŋá ru míní ꞌdã kí ími mịfị́ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Mî áyị́pịka mụ kí ándrá Mị̃sị́rị̃ gâlé, kí ándrá lú ꞌbá kãlị́ ázị̂rị̃. Wó úꞌdîꞌda Úpí Ãdróŋá mídrị̂ fẽ dó míní kpẹ̃lé ũꞌbí ru cécé lẽlẽgó ꞌbụ̃ gá rĩ kî áni.” ");
INSERT INTO luc_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Ílẽ Úpí Ãdróŋá mídrị̂ ꞌi, mí ũbĩ ị́jọ́ ĩꞌdiní azịlé rĩ kí vú, ãzị́táŋá ĩꞌdidrị̂ kí abe pírí sáwã pírí sĩ. ");
INSERT INTO luc_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Ãndrũ ĩmi igá drĩ ị́jọ́ ĩminí ndrelé ãzíla amálé Úpí ꞌbã drị̃ gá ị́jọ́ ĩꞌdi ꞌbã ĩmi cojó ímbátáŋá ru rĩ drị̂ ꞌi. Anzị ĩmidrị̂ ndre kí ándrá ị́jọ́ ꞌdĩ kí ku, ĩꞌdi ándrá ĩmi ãmgbã rĩ ꞌi. Ĩndre ãmbõgõ Úpí Ãdróŋá ĩmidrị̂ drị̂ rá, ũkpõ ãmbógó ĩꞌdidrị̂, ");
INSERT INTO luc_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","ãzíla tálí ĩꞌdidrị̂ kî abe. Ĩndre ị́jọ́ ĩꞌdi ꞌbã idélé úpí Mị̃sị́rị̃ gá rĩ rụ́ rĩ kí rá ãzíla sụ́rụ́ ĩꞌdidrị̂ agá pírí. ");
INSERT INTO luc_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","Índre ándrá ũkpõ Úpí ꞌbã sĩ ãsĩkárĩ Mị̃sị́rị̃ drị̂ kí ị̃lị̃kị̃jó pírí rĩ rá, fãrásĩ ĩꞌdidrị́ ãꞌdị́ drị̂ kí ãzíla gárĩ ãꞌdị́ drị̂ kí abe, ịmvụ́ kí Mĩrĩ Ika rĩ agá ĩꞌbaní ꞌbá Ịsịrayị́lị̃ drị̂ kí vú bĩ agá. ");
INSERT INTO luc_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Anzị mídrị̂ ndre kí ándrá ị́jọ́ Úpí ꞌbã idélé míní ãngũ kõtórõ rú rĩ agá ꞌdĩ sĩ mí afí drĩ ãngũ ꞌdĩ agá ꞌdâ ku rú rĩ kí ku, ");
INSERT INTO luc_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","ãzíla mí igá drĩ ị́jọ́ Ãdróŋá ꞌbã ándrá idélé Dãtánĩ rụ́ ãzíla Ãbị̃rámụ̃ rụ́, Ị̃lị̃yábụ̃ ínátị Rụ́bẹ̃nị̃ drị̂ agá rĩ ꞌbã anzị kí abe rĩ drị̃ gá. Vũ nzị̃ ándrá ru tị mgbọ ꞌbá kí mịfị́ gâsĩ ãzíla uti ꞌbá kí, lị́cọ́, hémã, ãtiꞌbo ãzíla ãko pírí ĩꞌbadrị́ ídri rĩ kí abe ꞌbá Ịsịrayị́lị̃ drị̂ kí drĩdríŋĩ gá ꞌdãá pírí. ");
INSERT INTO luc_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Wó ími ãmgbã rĩ ndre ándrá ị́jọ́ pírí ãmbogo-ãmbogo rú Úpí ꞌbã idélé ími drị̃ gâsĩ rĩ kí rá.” ");
INSERT INTO luc_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Mụ́sã jọ anzị Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ĩmi ũbĩ ãzị́táŋá mání fẽlé ĩminí ãndrũ ꞌdĩ kí vú pírí. ꞌDã ꞌbã ũngúkú gá, ĩmi dó sĩ icó Ị̃yị́ Yõrĩdánĩ zalé sĩ fijó ãngũ ĩminí mụjó ala gá ꞌdĩ ꞌdụjó ĩmĩni la rú. ");
INSERT INTO luc_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","Ị́jọ́ ꞌdĩ sĩ ĩmi dó sĩ uꞌá ãngũ málĩ trũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ ándrá Úpí ꞌbã ũyõ la najó ꞌi fẽ la ĩmi áyị́pịka ꞌbaní anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ abe rĩ gá ílí ãzo rú. ");
INSERT INTO luc_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Ãngũ ĩminí mụlé ꞌdụlé ꞌdĩ adru cécé ãngũ Mị̃sị́rị̃ gá ándrá ĩminí sĩ uꞌájó ala gá drị̃drị̃ rĩ áni ku. Ĩmi ándrá ala gá ꞌdãá ũri kpẹ̃, ĩmi ãzị́ ũkpó la nga agá sĩ ị̃yị́ ũsũjó ãkónã ĩmidrị̂ kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Wó ãngũ ĩminí Ị̃yị́ Yõrĩdánĩ zajó sĩ fijó ala gâlé ꞌdĩ ĩꞌdi ãngũ ꞌbé ru ãzíla áꞌbụ ꞌa rú la, ãngũ ꞌdã ĩꞌdi uzogó ꞌbụ̃ gá rĩ ꞌbã sĩ ꞌdịjó drị̃ la gá nĩ la. ");
INSERT INTO luc_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","Ãngũ ꞌdĩ Úpí Ãdróŋá mídrị̂ ꞌbã tã mbalé ãzíla andre tẽlé ílí ꞌbã iꞌdóŋá gá kpere ílí ꞌbã ãsị̃ŋá gá nĩ rĩ. ");
INSERT INTO luc_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","“Ị́jọ́ ꞌdĩ sĩ, ĩdrĩ ãzị́táŋá ãndrũ mání fẽlé ĩminí ꞌdĩ kí tã mba ãꞌị̃táŋá sĩ vâ sĩ Úpí Ãdróŋá ĩmidrị̂ lẽjó ãzíla ãzị́ ngajó ĩꞌdiní ĩmi ásị́ pírí sĩ ãzíla ĩmi ídri pírí sĩ, ");
INSERT INTO luc_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ꞌdã ꞌbã ũngúkú gá ma uzogó fẽ ꞌdịlé áyi ꞌbã iꞌdóŋá gá ãzíla áyi ꞌbã ukóŋá gá, ị́jọ́ ꞌdĩ sĩ ãná, wáyĩnĩ ãzíla ãdu kí dó sĩ adru ĩminí cí. ");
INSERT INTO luc_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Ma dó ásé kí fẽ dụlé ãnãkpá ĩmidrị̂ ꞌbaní ĩrí ru ãzíla ĩmi adru ãkónã pírí ĩminí lẽlé rĩ kî trũ. ");
INSERT INTO luc_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","“Ĩmi adru mịfị́ trũ, jõ íni ku ála ĩmi ulé sĩ ĩmi sejó ãmvé sĩ mụjó ãdroŋa ĩnzõ rú ꞌdĩ kí ị̃nzị̃jó sĩ ãzị́ ngajó ĩꞌbanî. ");
INSERT INTO luc_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Ĩdrĩ idé la ꞌdĩ ꞌbã áni rá, Úpí la uꞌá ĩminí ũmbã sĩ. Ĩꞌdi dó sĩ uzogó tị umbé ꞌbụ̃ gâlé cí, ãngũ la adru ãꞌí ru ãzíla ũri icó kí dó sĩ zolé ku. ꞌDã ꞌbã ũngúkú gá, ĩmi dó ũdrã ꞌdãá rá, drĩ táni adru ãngũ múké ĩꞌdi ꞌbã fẽlé ĩminí rĩ ꞌi tí. ");
INSERT INTO luc_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","“Ĩmba ị́jọ́ mádrị́ ꞌdĩ kí tã ĩmi asị́ gá ãzíla ĩmi úŋmĩ gá; ĩmi úmbé kí ícétáŋá ru ĩmi drị́ gá ãzíla ĩsụ̃ kí ĩmi androko gá sĩ ĩmi igájó. ");
INSERT INTO luc_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Ĩmi imbá kí anzị ĩmidrị̂ ꞌbanî, ĩnze ị́jọ́ ĩꞌbaní kí drị̃ gá sáwã ĩminí rijó ĩmidrị́ lị́cọ́ agá rĩ gá ãzíla ĩminí mụ agá gẹ̃rị̃ gâsĩ ꞌdĩ gá ꞌdâ, ĩminí ĩmi la agá mgbọ́lọ́ drị̃ gá ãzíla ĩminí angá agá ụrụgá. ");
INSERT INTO luc_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Ísĩ kí báwũ kẹ̃jị́tị gá jó mídrị̂ drị̂ ụrụꞌbá gá ãzíla kẹ̃jị́tị sĩ afíjó lị́cọ́ gá rĩ ụrụꞌbá gá. ");
INSERT INTO luc_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","Ị́jọ́ ꞌdĩ sĩ, ĩmi anzị ĩmidrị̂ abe ĩmi dó sĩ uꞌá ụ̃nọ́kụ́ drị̃ gá ꞌdâ ílí ãzo rú, Úpí ꞌbã ándrá ũyõ la najó ꞌi fẽ la ĩmi áyị́pịka ꞌbaní rĩ áni. Ĩmi mụ uꞌálé ãngũ drị̃ gá ꞌdâ jãꞌdâ. ");
INSERT INTO luc_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","“Ĩmi adru mịfị́ trũ sĩ ãzị́táŋá mání fẽlé ĩminí ꞌdĩ kí tãmbajó pírí, ĩmi dó sĩ Úpí Ãdróŋá ĩmidrị̂ lẽ sĩ acị́jó gẹ̃rị̃ ĩꞌdidrị̂ kí agá pírí ãzíla sĩ ị́jọ́ ĩꞌdidrị̂ kí rụjó mgbe-mgbe. ");
INSERT INTO luc_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","ꞌDã ꞌbã ũngúkú gá, Úpí la dó sụ́rụ́ pírí ĩmi drị̃lẹ́ gá ꞌdĩ kí dro rá, ãzíla ĩmi dó sụ́rụ́ ãmbõgõ sĩ ãzíla ũkpõ sĩ ĩmi ndẽlépi rá ꞌdĩ kí ꞌbã ãngũ kí ꞌdụ ĩmi ãni la rú. ");
INSERT INTO luc_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Ãngũ pírí ĩminí sĩ pá tị̃jó ala gá ꞌbo rĩ kí adru ĩmĩni. Ãngũ ĩmidrị̂ la ru ị̃drị̃ angájó ãngũ kõtórõ rú rĩ gá kpere Lébãnõnĩ gá, ãzíla angájó ị̃yị́ Ũfũrátĩ gá kpere Mĩrĩ Mẽdĩtẽránĩyãnĩ ꞌbã wókõ ị̃tụ́ ꞌbã ꞌde agâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Ãngũ ĩminí sĩ mụjó rĩ gá, Úpí Ãdróŋá ĩmidrị̂ la fẽ la ꞌbá ĩmi drị̃lẹ́ gá ꞌdĩ kí idé ĩmi sĩ ụ̃rị̃ sĩ, cécé ĩꞌdi ꞌbã azịlé rĩ áni, ãzíla ꞌbá ãzí icólépi ĩmi drị̃ atrịlépi la la adru ꞌdá yụ. ");
INSERT INTO luc_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","“Ĩndre drĩ, ãndrũ áfẽ ĩminí ị́jọ́ pẽjó drị̃lẹ́ba kí drĩdríŋĩ gá áwãtáŋá be. ");
INSERT INTO luc_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Ãndrũ ĩdrĩ ãzị́táŋá Úpí Ãdróŋá ĩmidrị̂ ꞌbã fẽlé ĩminí rĩ kí tã mba rá, ĩmi adru drị̃lẹ́ba rú. ");
INSERT INTO luc_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Wó ĩdrĩ ãzị́táŋá Úpí Ãdróŋá ĩmidrị̂ drị̂ kí gã úmgbé sĩ ru ujajó ãdroŋa ĩminí nị̃lé ku la kí ị̃nzị̃jó, ĩꞌdi adru ĩminí áwãtáŋá ru. ");
INSERT INTO luc_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Úpí Ãdróŋá mídrị̂ drĩ ími agụ ãngũ míní mụjó fijó ala gá míní mụlé ꞌdụlé mî ãni la rú rĩ gá ꞌbo, lẽ mí ũlũ ị́jọ́ drị̃lẹ́ba drị̂ ꞌBé Gẹ̃rị̃zị́mụ̃ drị̃ gá ãzíla ị́jọ́ áwãtáŋá drị̂ ꞌBé Ĩbálĩ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Ĩminí nị̃lé ꞌbo rĩ áni, ꞌbé ị̃rị̃ ꞌdĩ kí Mĩrĩ Yõrĩdánĩ ꞌbã wókõ ꞌá ꞌdã sĩ rĩ gá gẹ̃rị̃ mụjó ãngũ ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ gá, ãni rú ãngũ mị̃rị́ ru Mõréyã drị̂ gá, ꞌdĩ ãngũ ꞌbá Kãnánĩ gá rĩ ꞌbã kí sĩ uꞌájó Ãrábã gá ãni rú Gị̃lị̃gálị̃ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Ĩmi dó ãni rú mụ Mĩrĩ Yõrĩdánĩ zalé sĩ fijó ãngũ Úpí Ãdróŋá ĩmidrị̂ ꞌbã fẽlé ĩminí, ĩminí mụlé ꞌdụlé ĩmi ãni la rú rĩ gá. Ĩdrĩ ꞌdụ la sĩ rijó ala gá ꞌbo, ");
INSERT INTO luc_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","ĩmi adru mịfị̂ trũ sĩ ndrejó la ị́jọ́ ãzị́táŋá ru mání ꞌbãlé ãndrũ ĩmi drị̃lẹ́ gá ꞌdĩ kí ĩmĩ ũbĩ kí vú rá.” ");
INSERT INTO luc_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Mụ́sã jọ anzị Ịsịrayị́lị̃ drị̂ ꞌbaní, “ꞌdĩ kí ị́jọ́ azịlé ãzị́táŋá ru rĩ kî; ĩmi adru mịfị̂ trũ sĩ kí vú ũbĩjó ụ́ꞌdụ́ ĩminí uꞌájó ãngũ Úpí Ãdróŋá mí átẹ́pịka ꞌbadrị̂ ꞌbã fẽlé mî ãni la rú rĩ agá ꞌdãá rĩ kí gá pírí. ");
INSERT INTO luc_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Ãngũ ĩminí mụlé ꞌdụlé rĩ gá, ĩmi andi ãngũ ꞌbá ꞌdã ꞌbã kí sĩ ãzị́ ngajó ãdroŋa ĩꞌbadrị̂ ꞌbaní ãzíla sĩ kí ị̃nzị̃jó ꞌbé ãzo ãzíla ꞌbé were rĩ kí drị̃ gâsĩ ãzíla ife kị̃dị̃ rĩ kí ị̃ndụ́ gâsĩ rĩ kí pírí. ");
INSERT INTO luc_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Ĩmi andi ãlĩtárĩ ĩꞌbã kí sịlé ꞌdĩ kí rá, írã ĩꞌbã kí ꞌbãlé ndú ị̃nzị̃lé ị̃nzị̃ ꞌdĩ kí ĩmi aco kí kpékpé, ĩmi aga ị́dị́ŋá ãdróŋá ũkú ru umvelé Ãsérã rĩ drị̂ kí vụ̃rụ́, ĩmi ivé kí ãcí sĩ, ĩmi aga íꞌdá ãdroŋa ĩꞌbadrị̂ ꞌbadrị̂ kí rá ãzíla ĩmi ịnị́ ãdroŋa ĩꞌbadrị̂ kí rụ́ ãngũ ꞌdĩ kí agá ꞌdâ rá. ");
INSERT INTO luc_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","“Ĩmi ị̃nzị̃ Úpí Ãdróŋá ĩmidrị̂ ꞌi gẹ̃rị̃ ĩꞌbadrị́ ĩꞌbaní ãdroŋa ĩꞌbadrị̂ kí ị̃nzị̃jó rĩ kí sĩ ku. ");
INSERT INTO luc_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Wó ĩndrụ̃ ãngũ Úpí Ãdróŋá ĩmidrị̂ ꞌbã mụlé pẽlé ãlu ínátị pírí ĩmidrị̂ kí agá ꞌdâ sĩ ĩꞌdi ị̃nzị̃jó ala gá rĩ ꞌi. Ãngũ ꞌdã gâlé lẽ ĩmụ rá; ");
INSERT INTO luc_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","ꞌdãá ĩmi ají ídétáŋá ĩmidrị́ ivélé ivê rĩ kí ídétáŋá ãzí ꞌdĩ kí abe, fẽtáŋá ãlu mụdrị́ drị́ rĩ ãzíla fẽtáŋá ndú-ndú angálépi ĩmi asị́ gá rĩ kí, ãko ĩminí azịlé ĩmi kí fẽ fẽtáŋá ru cénĩ rĩ abe, ãzíla ãnãkpá mvaka kãjãní ĩmidrị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Úpí Ãdróŋá ĩmidrị̂ ꞌbã drị̃lẹ́ gá ꞌdãá ĩmi ĩzá ĩminí ụlị́lé rĩ kí na ꞌbá ĩmidrị́ lị́cọ́ gá rĩ kí abe, ĩmi ãko ĩminí ãzị́ ngalé ĩmi drị́ sĩ rĩ kí na ãzíla ĩmi dó sĩ uꞌá ãyĩkõ sĩ ãko pírí ĩminí nalé rĩ kí sĩ, ãꞌdusĩku Úpí Ãdróŋá mídrị̂ wi míní sụ̃sụ́ ꞌbo. ");
INSERT INTO luc_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","“Lẽ ĩmi idé ị́jọ́ kí ãndrũ cécé ĩminí idélé ꞌbá ãlu-ãlu ní ũrãjó la ị́jọ́ ĩꞌdiní idélé rĩ ĩꞌdi múké ĩꞌdiní rĩ áni la ku. ");
INSERT INTO luc_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","Ãꞌdusĩku ĩfi drĩ ãngũ Úpí Ãdróŋá ĩmidrị̂ ꞌbã mụlé fẽlé ĩminí ãwítã rú, ĩminí sĩ mụjó uꞌájó ala gá rĩ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Wó ĩmi mụ Mĩrĩ Yõrĩdánĩ zalé sĩ rijó ãngũ Úpí Ãdróŋá ĩmidrị̂ ꞌbã fẽlé ĩminí ãwítã rú rĩ gá, ĩꞌdi fẽ ĩmi mụ avị́lé mẹ́rọ́ꞌbá pírí ĩmi andre gá rĩ ꞌbadrị́ rá, ĩmi dó sĩ adru ásị́ ị̃gbẹ̃ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","Úpí Ãdróŋá ĩmidrị̂ la mụ ãngũ pẽlé ãlu sĩ ĩꞌdi ị̃nzị̃jó, ãzíla ꞌdãá lẽ ĩmi ají ãko pírí mání jọlé ĩminí ĩmi ají kí rĩ kî: ídétáŋá ivélé ivê rĩ kí, ãkõ ãzí ídétáŋá ru rĩ kí abe, ãzíla fẽtáŋá ãlu mụdrị́ drị̂ ãzíla fẽtáŋá ndú ndú angálépi ĩmi ásị́ gá rĩ, ãko ĩminí ajílé fẽlé ĩmi ásị́ sĩ rĩ, fẽtáŋá cénĩ rĩ, ãzíla ãko pírí ĩminí ũyõ najó ĩmi kí fẽ Ãdróŋá ní rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Ĩmi uꞌá ãyĩkõ sĩ Úpí Ãdróŋá ĩmidrị̂ drị̃lẹ́ gá, anzị ĩmidrị̂ kí abe, ãtiꞌbo ĩmidrị́ ãgọbị rú ãzíla ũkú ru rĩ kí, ꞌbá Lẹ́vị̃ drị́ uꞌálépi táwụ̃nị̃ ĩmidrị̂ kí agá ꞌdĩ kî, lẽ ĩmi ũrã jõ ị́jọ́ ꞌbá Lẹ́vị̃ drị̂ ꞌbaní ãngũ ꞌdáyụ rĩ ꞌbã ị́jọ́ ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Ĩmi adru mịfị́ trũ, adru ĩmi dó sĩ ãko ĩmidrị́ ídétáŋá ru rĩ kí fẽ ãngũ ĩmi ásị́ ꞌbã lẽlé rĩ gá la ku. ");
INSERT INTO luc_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Ĩfẽ kí ãngũ Úpí ꞌbã pẽlé sụ́rụ́ ãzí ãlu la agá rĩ gá ꞌdãá, lẽ ị́jọ́ ãzị́táŋá ru rĩ kí ĩmba kí tã múké-múké. ");
INSERT INTO luc_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","“Wó míní drị̃lẹ́mgbọ cí sĩ ãnãkpá míní lẽlé lịlẹ́ rĩ lịjó ãngũ míní sĩ uꞌájó rĩ gá. Mí icó nalé la ĩyõ rú cécé Úpí Ãdróŋá mídrị̂ ꞌbã sụ̃sụ́ la wijó míní rĩ áni rá. Drĩ táni adru ị́jọ́ lãꞌbĩ drị̂ sĩ ãlá ru jõku ãlá ru ku tí, mí icó nalé la cécé mi ꞌbã rĩ lẽza ãzíla yéré ꞌbã ĩzá na rĩ áni rá. ");
INSERT INTO luc_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Wó lẽ ĩna ãrí ku; ĩmi asu ĩꞌdi vũ gá cécé ị̃yị́ áni. ");
INSERT INTO luc_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","“Ãko ĩminí fẽlé Ãdróŋá ní ídétáŋá ru ꞌbo rĩ lẽ ĩna ĩꞌdi ãngũ ĩminí sĩ uꞌájó rĩ kí agá ku: drĩ táni adru ãko ãkónã rú la, wáyĩnĩ, jõku ãdu Mị̃zẹ̃yị́tụ̃ drị̂, jõku ãnãkpá ĩmidrị́ lị́cọ́ gá rĩ ꞌbã mvaka kãjãní rĩ kî, fẽtáŋá ĩminí ị́jọ́ la azịjó Úpí ní rĩ, fẽtáŋá ị́jọ́ la sĩ angájó ĩmi ásị́ gá cénĩ rĩ ãzíla fẽtáŋá ãzí rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Lẽ ína fẽtáŋá ꞌdĩ kí Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã pẽlé rĩ gá anzị mídrị̂ kí abe, ãtiꞌbo mídrị́ ãgọbị rú ãzíla ũkú ru rĩ kí abe, ꞌbá Lẹ́vị̃ rú uꞌálépi táwụ̃nị̃ mídrị̂ agá ꞌdĩ kí abe. Lẽ mí uꞌá ꞌdãá ãyĩkõ sĩ ị́jọ́ míní idélé rĩ kí sĩ Úpí Ãdróŋá mídrị̂ ꞌbã drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Ụ́ꞌdụ́ míní uꞌájó ãngũ mídrị̂ agá ꞌdãá rĩ kí agá pírí, mí adru mịfị́ trũ, mí aꞌbe jõ ꞌbá Lẹ́vị̃ rú la kí yã ku. ");
INSERT INTO luc_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","“Úpí Ãdróŋá mídrị̂ drĩ dó sụ́rụ́ mídrị̂ nzị̃ ãmbógó ru cécé ĩꞌdi ꞌbã ándrá azịjó la míní rĩ áni ꞌbo, mi icó ĩzá nalé ími ásị́ ꞌbã lẽlé rĩ áni rá. ");
INSERT INTO luc_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã pẽlé Rụ́ ĩꞌdidrị̂ ꞌbã adru sĩ ala gá rĩ drĩ adru álị́ mí rụ́ ꞌdâ, mí icó ãnãkpá Úpí ꞌbã fẽlé míní mídrị́ lị́cọ́ agá rĩ kí ꞌbã ãzí ãlu la lịlẹ́ rá, mání ũkpó la fẽjó míní rĩ áni, ãzíla mí icó dó sĩ ĩzá la nalé ími ásị́ ꞌbã lẽlé rĩ áni táwụ̃nị̃ mídrị̂ agá rá. ");
INSERT INTO luc_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Mí icó ãnãkpá ásé agá lẽza ãzíla mũcé ꞌdĩ kí nalé míní lẽlé rĩ áni rá. Drĩ táni adru ị́jọ́ lãꞌbĩ drị̂ sĩ ãlá ru jõku ãndị́ ru tí. ");
INSERT INTO luc_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Wó lẽ ĩna ãrí ku, ãꞌdusĩku ãrí ĩꞌdi ídri, lẽ ĩna ĩzá ídri la trũ ku. ");
INSERT INTO luc_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Lẽ ĩna ãrí ku; ĩmi asu ĩꞌdi vũ gá cécé ị̃yị́ áni. ");
INSERT INTO luc_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Lẽ ĩna ãrí ku, ị́jọ́ ꞌdĩ sĩ ĩmi dó sĩ uꞌá múké Úpí drị̃lẹ́ gá anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe, ãꞌdusĩku ĩminí mụjó ị́jọ́ pịrị Úpí mịfị́ gá rĩ idéjó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Wó ĩmi agụ ãwãꞌdĩfô ĩmidrị̂ kí ãko ĩminí azịlé Úpí ní fẽtáŋá ru rĩ kí abe ãngũ ãlu ĩꞌdi ꞌbã pẽlé sĩ ĩꞌdi ị̃nzị̃jó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Ãko ídétáŋá ru rĩ kí ivé kí pírí ãlĩtárĩ Úpí Ãdróŋá mídrị̂ drị̂ drị̃ gá ĩzá la kí ãrí la abe. Ãrí ãko mídrị́ ídétáŋá ru rĩ drị̂ kí, lẽ úsũ ĩꞌdi ãlĩtárĩ Úpí Ãdróŋá mídrị̂ drị̂ ꞌbã bụ́lụ́ gá, wó mí icó ĩzá la nalé rá. ");
INSERT INTO luc_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Mí adru mịfị́ trũ sĩ ãzị́táŋá mání fẽlé míní ꞌdĩ kí vú ũbĩjó pírí, ị́jọ́ ꞌdĩ sĩ ãko pírí kí dó sĩ adru míní múké anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbaní jãꞌdâ, ãꞌdusĩku mi mụ ị́jọ́ múké ãzíla pịrị rĩ kí ngalé Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá.” ");
INSERT INTO luc_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Mụ́sã mụ ị́jọ́ jọŋá trũ drị̃ gá jọ, “Úpí Ãdróŋá mídrị̂ la mụ sụ́rụ́ míní sĩ ãngũ ĩꞌbadrị̂ ꞌdụjó mí ãni la rú ꞌdĩ ꞌbã ꞌbá kí ị̃lị̃kị̃lé ãzíla mi dô sĩ ri ãngũ ĩꞌbadrị̂ gá cí. ");
INSERT INTO luc_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","Ãdróŋá drĩ dó ꞌbá ꞌdã kí ị̃lị̃kị̃ ꞌbo, mí adru mịfị̂ trũ, mí ũbĩ jõ ãdroŋa ĩꞌbadrị̂ kí vú ku, ãꞌdusĩku ꞌdĩ la adru ị́jọ́ ũnzí la. Lẽ índrụ̃ ꞌbá ꞌdã kí ándrá ãdroŋa ĩꞌbadrị̂ ꞌbaní ãzị́ nga íngoní ru yã rĩ gá ku, ị́jọ́ ꞌdĩ la ími fẽ ãdroŋa ĩꞌbadrị̂ kí ị̃nzị̃lé. ");
INSERT INTO luc_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Mí ị̃nzị̃ Úpí Ãdróŋá mídrị̂ cécé ĩꞌbã kí ãdroŋa ĩꞌbadrị̂ kí ị̃nzị̃lé rĩ áni ku, ãꞌdusĩku ĩꞌbã kí ãdroŋa ĩꞌbadrị̂ kí ị̃nzị̃ agá, kí ị́jọ́ ũnzí Úpí Ãdróŋá mídrị̂ ꞌbã ngụ̃lé ũnzí ꞌdĩ kí idé. Kí vâ anzị ĩꞌbadrị̂ kí ivé ãcí sĩ ídétáŋá ru ãlĩtárĩ ĩꞌbadrị̂ kí drị̃ gá ãdroŋa ĩꞌbadrị̂ ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","“Ĩmi idé ị́jọ́ mání jọlé ĩminí ꞌdĩ kí pírí; ĩmi ũꞌbã ãzí la kí drị̃ la gá ku jõku ĩnze ãzíla kí ala gá ꞌdâ ãmvé ku.” ");
INSERT INTO luc_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Mụ́sã jọ Ịsịrayị́lị̃ ní, “ꞌBá ãzí nábị̃ rú la jõku bá ãzí urobí ífí icélépi la drĩ ãfũ ími agá ꞌdâ ị́jọ́ ícétáŋá ru jõku ụ̃sụ̃táŋá ru la kí icéjó, ");
INSERT INTO luc_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","ị́jọ́ ícétáŋá ru jõku ụ̃sụ̃táŋá ru ĩꞌdiní ị́jọ́ icéjó drị̃ la gá rĩ drĩ kí táni ru idé rá, ãzíla drĩ jọ la, ãbĩ kí ãdroŋa ãzí ĩnzõ rú ꞌdĩ kí vú ãdroŋa míní nị̃lé ku ꞌdĩ kî ãzíla ãma ị̃nzị̃ kí kî ãzíla ãnga kí ãzị́ ĩꞌbaní, ");
INSERT INTO luc_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","lẽ mí are nábị̃ jõku ꞌbá urobí ífí icélépi ꞌdã ꞌbã ị́jọ́ ku. Úpí Ãdróŋá ĩmidrị̂ la ĩmi ụ̃ꞌbị̃ sĩ nị̃jó la ĩlẽ ꞌi ĩmi ásị́ pírí sĩ yã jõku ĩmi ídri pírí sĩ yã rĩ. ");
INSERT INTO luc_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Ĩꞌdi Úpí Ãdróŋá ĩmidrị̂ ꞌi, lẽ ĩmi ũbĩ ĩꞌdi vú ãzíla ĩmi ị̃nzị̃ ĩꞌdi áyụ; ĩmi ũbĩ ãzíla ĩmba ãzị́táŋá ĩꞌdidrị̂ kí tã; ĩnga ãzị́ ĩꞌdiní ãzíla ĩmi ĩbĩ ĩmi ĩꞌdi rụ́. ");
INSERT INTO luc_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Wó lẽ úꞌdị Nábị̃ ĩnzõ rú jõku ꞌbá urobí ífí icélépi ĩnzõ rú rĩ rá, ãꞌdusĩku ĩꞌdi ꞌbã lẽjó ĩmi ujajó sĩ mvujó Úpí Ãdróŋá ĩmidrị̂ ándrá ĩmi ajílépi angájó Mị̃sị́rị̃ gâlé ãzíla ĩmi anzélépi ãngũ ándrá ĩminí sĩ adrujó ãtíꞌbó ru rĩ rụ́ rá rĩ sĩ. ꞌBá ꞌdĩ áni ꞌdĩ ĩꞌdi ꞌbá ũnzí la, lẽ ími drị̃ selé bụ́lụ́ gá sĩ ãzị́táŋá Úpí Ãdróŋá mídrị̂ drị̂ kí gãjó úmgbé, lẽ úꞌdị ĩꞌdi rá, gẹ̃rị̃ ꞌdĩ áni rĩ sĩ, ĩmi dó sĩ ị́jọ́ ũnzí atrị ĩmi drĩdríŋĩ gá ꞌdâ rá. ");
INSERT INTO luc_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","“Ícétáŋá sĩ mí ádrị́pị jõku mî ngọ́pị jõku mî ị̃zẹ́pị, jõku ũkú mídrị́ míní lẽlé rĩ, jõku mî wọ̃rị́ ãníyágágá la drĩ ími ũcĩ ũní-ũní ru, drĩ jọ la, ‘Lẽ ãmụ kí ãdroŋa ãzí ĩnzõ rú la kí ị̃nzị̃lé sĩ ãzị́ ngajó ĩꞌbaní’ (ãdroŋa ĩmi jõku ĩmĩ áyị́pịka ꞌbã kí jõ drĩ nị̃lé ku la. ");
INSERT INTO luc_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","Icó kí ĩminí ígátáŋá fẽlé jọjó la ĩmi ị̃nzị̃ ãdroŋa ꞌbá uꞌálépi ĩmi andre gá ãni rú jõku ꞌbá angálépi álị́ ãngũ tị ꞌbã ãsị̃ agá rĩ ꞌbadrị̂ kî). ");
INSERT INTO luc_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","Wó ĩmi ãꞌị̃ jõ ị́jọ́ ĩꞌbaní jọlé rĩ kí ku jõku ĩmi are kí tị ku, ĩmi iꞌda ĩꞌbaní ásị́ ị̃gbẹ̃ ku ãzíla ĩmba kí tã ku. ");
INSERT INTO luc_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","Ĩmi ụꞌdị́ kí rá, ĩmi adru ꞌbá drị̃drị̃ kí uꞌbélépi írã sĩ rĩ, ãzíla ꞌbá pírí ꞌbã nga kí kí uꞌbélé. ");
INSERT INTO luc_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Ĩmi uꞌbé ĩꞌdi írã sĩ káyĩ rá, ãꞌdusĩku ĩꞌdi ꞌbã lẽjó ĩmi drị̃ sejó bụ́lụ́ gá Úpí Ãdróŋá mídrị̂ rụ́ ꞌdâ ãmvé rĩ sĩ, ꞌdĩ Ãdróŋá ĩmi ajílépi angájó Mị̃sị́rị̃ gâlé ãngũ ándrá ĩminí sĩ adrujó ala gá ãtíꞌbó ru rĩ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","ꞌDã ꞌbã ũngúkú gá, ꞌbá pírí Ịsịrayị́lị̃ drị̂ kí dó sĩ are la ãzíla kí dó sĩ idé ụ̃rị̃ sĩ, ãzíla ꞌbá ãzí ãlu ĩmi drĩdríŋĩ gá la icó dó sĩ ị́jọ́ ũnzí idélé ku. ");
INSERT INTO luc_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","“Sáwã míní uꞌájó táwụ̃nị̃ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ kí agá rĩ sĩ, mí icó arelé la, ");
INSERT INTO luc_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","ꞌbá ãzí ũnzĩkãnã idélépi la ãfũ kí ĩmĩ drĩdríŋĩ gá anzị Bĩlĩyálĩ drị̂ kí agá ꞌdĩ ãzíla ce kí ꞌbá ĩmidrị̂ kí drị̃ ũnzí, ĩꞌbaní jọjó la, ‘Lẽ ãmụ kí ãdroŋa ãzí kí ị̃nzị̃lé’ ãzíla ãzị́ ngalé ãdroŋa ãzí ĩnzõ rú ĩminí jõ drĩ nị̃lé ku la ꞌbaní rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","Ídrĩ kõyõkõyõ ãzí are rá, mí ifí ị́jọ́ la ị̃ndụ́ múké-múké, ãzíla ídrĩ ịsụ́ la ị́jọ́ ũnzí ꞌdĩ nga kí ru rá ãndá-ãndá ru yã áni, ");
INSERT INTO luc_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","lẽ mí ị̃lị̃kị̃ ꞌbá táwụ̃nị̃ ꞌdã agá ꞌdãá rĩ kí pírí rá málĩ ĩꞌbadrị́ ãnãkpá ru rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","Mí atrá ãko ĩꞌbadrị̂ ꞌbã ị́mbị́ ãzí acelépi rĩ kí pírí ũdrõlé ãngũ ãlu gá táwụ̃nị̃ ꞌbã ágágá. Mí ivé dó táwụ̃nị̃ ꞌdã ꞌi ãko la ala gá rĩ kí abe pírí ídétáŋá ru Úpí Ãdróŋá mídrị̂ nî. Âꞌbe ĩꞌdi ĩsá ru, ãngũ ꞌbã fi ndrú jãꞌdâ ãzíla úsị jõ ĩꞌdi ị̃dị́ ku. ");
INSERT INTO luc_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","Ímba jõ ãko ãzí lẽlé ívé kí rá ꞌdĩ kí tã ãluŋá la míní ku, ãzíla Úpí la dó sĩ ru ásị́ uja adrã ĩꞌdidrị̂ agá, ĩꞌdi dó sĩ míní ásị́ ị̃gbẹ̃ ĩꞌdidrị̂ iꞌda, ãzíla ĩꞌdi dó sĩ fẽ la mi kpẹ̃ wẽwẽ rú ándrá ĩꞌdĩ ꞌbã ũyõ la najó mî áyị́pịka ꞌbaní rĩ áni, ");
INSERT INTO luc_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","ídrĩ ãzị́táŋá ĩꞌdidrị́ mání fẽlé míní ãndrũ ꞌdĩ kí vú ũbĩ pírí rá ãzíla ídrĩ ị́jọ́ múké rĩ kí idé Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá rá, ífí la mí are Úpí Ãdróŋá mídrị̂ ꞌbã tị rá.” ");
INSERT INTO luc_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ĩdrĩ awá ꞌbá drãlépi ꞌbo rĩ sĩ, ĩmi ụlị́ jõ ĩmi ku jõku ĩfa jõ ĩmi drị̃ꞌbị́ tandala rú cécé ꞌbá ãzí ꞌbã kí falé rĩ áni ku ãꞌdusĩku ĩmi anzị Úpí Ãdróŋá ĩmidrị̂ ãni. ");
INSERT INTO luc_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","Mi ꞌbá ãlá Úpí Ãdróŋá mídrị̂ ãni ĩꞌdi ꞌbã pẽlé ndú ĩꞌdĩ ꞌbã ꞌbá ru angájó ꞌbá ãzí ụ̃nọ́kụ́ drị̃ gá ꞌdâ ꞌdĩ kí agá rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Lẽ ĩna jõ ãko ãzí Ãdróŋá ꞌbã ugalé úmgbé ꞌdĩ kí ku. ");
INSERT INTO luc_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Ĩmi icó rá la ãnãkpá ãzí ꞌdĩ kí ꞌbã ĩsélé ãzí nalé áyụ: tị́, kãbĩlõ, ị̃ndrị́ kí abe, ");
INSERT INTO luc_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","Yéré, ụ̃drụ́, Ãbụ́rị̃, Lẽza, Káꞌbó ãzíla ị̃ndẹ́rẹŋá kí abe. ");
INSERT INTO luc_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","Ãnãkpá ĩsélé kụ́rụ̃bẹ́ la ꞌbã kí sĩ ru awajó ị̃rị̃ ị̃rị̃ ãzíla vâ ĩrí ꞌa amvilépi amvi-amvĩ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Wó ãnãkpá ĩrí amvilépi ku kụ́rụ̃bẹ́ la kí sĩ ru awajó ku ꞌdĩ kí ĩna kí ku: Ngãmíyã, Ĩtógóŋá ãzíla kílẽ. Lẽ ĩlã kí ãko ãlã kóru la rú, drĩ kí táni ĩrí ꞌa amvi rá tí kụ́rụ̃bẹ́ la ꞌbã kí ru awajó ị̃rị̃ ku rĩ sĩ, kí ãlã kóru. ");
INSERT INTO luc_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","Lẽ ĩna ĩzõgó ĩzá ku jõku ĩmi aló ĩzá la ku. Kí ãlã kóru kí táni kụ́rụ̃bẹ́ trũ ị̃rị̃ ị̃rị̃ rá tí, amvi kí ĩrí ꞌa ku. ");
INSERT INTO luc_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","“Ãko ídri trũ ị̃yị́ agá ꞌdĩ kí agá, ĩminí icólé nalé rá rĩ kí Ị̃ꞌbị ụ́pụ́pị́ abe vâ ꞌbíko falé fã-fã rĩ kî. ");
INSERT INTO luc_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","Wó ãko ị̃yị́ agá ụ́pụ́pị́ kóru ãzíla ꞌbíko kóru ꞌdĩ kí úna kí ku, kí ãlã kóru. ");
INSERT INTO luc_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","“Ĩmi icó ãriŋa ãlá rĩ kí nalé rá. ");
INSERT INTO luc_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","18","Wó ãriŋa nalé ku rĩ kí ũví la kí ꞌdĩ: yụ́kụ́, lụ́ŋụ́ꞌdụ̃, íŋmáŋá, kọ̃tụ́rọ̃, kôŋá, ụ̃gbụ́lụ́kụ, ụ̃wọ́lọ, Núgúnúke, kúrúke, kálụ́wẹ, mórõkõkõ, ụ̃kọ̃ndọ̃, yụ̃gụ̂, ãꞌbanaka ãzíla ꞌbị́ꞌbị́ŋá kí abe. ");
INSERT INTO luc_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","“Ãko ụ́pụ́pị́ trũ ungalépi nzénzéŋá kí áni ꞌdĩ kí, úna kí ku, kí ãlã kóru. ");
INSERT INTO luc_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Wó ãko ungalépi ụ́pụ́pị́ trũ cécé úna, íse ãzíla úmbí kí áni ꞌdĩ kí ãko ãlá la kî, ĩmi icó kí nalé rá. ");
INSERT INTO luc_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","“Lẽ ína ãnãkpá drãlépi cénĩ rĩ ku. Mí icó ĩꞌdi fẽlé ꞌbá ãmị́yọ́ŋá ru ími andre gá rĩ ꞌbaní nalé rá, jõku mí icó ĩꞌdi ị̃tụ̃ndãlé ĩꞌbaní rá. Wó mi ꞌbá ãlá Úpí Ãdróŋá mídrị̂ ãni la. “Lẽ mí aꞌdí ị̃ndrị́ mváŋá ĩzá ãndrẽ ꞌbã lé sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ĩmba ãko ĩmidrị́ ámvụ́ agá ãfũlépi rĩ kí ꞌbã ĩsélé ãlu mụdrị́ drị́ rĩ kí tã bụ́lụ́ gá ílí ãlu-ãlu sĩ. ");
INSERT INTO luc_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","ꞌDã ꞌbã ũngúkú gá, ímụ ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã pẽlé míní sĩ ĩꞌdi ị̃nzị̃jó rĩ gá ãngũ ãlu gá sĩ ãkónã ĩsélé ãlu mụdrị́ drị̂ kí najó ĩꞌdi drị̃lẹ́ gá ꞌdãá, ãná, wáyĩnĩ úꞌdí rĩ, ãdu Mị̃zẹ̃yị́tụ̃ drị̂, ãnãkpá kãjãní rĩ kí ãzíla tị́ kí kãbĩlõ abe, mí idé ị́jọ́ ꞌdĩ ꞌi ãrútáŋá ru Úpí Ãdróŋá mídrị̂ ní sáwã pírí sĩ. ");
INSERT INTO luc_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Úpí Ãdróŋá mídrị̂ drĩ míní sụ̃sụ́ wi ãko mídrị̂ kí drị̃ gá rá, ãngũ Úpí Ãdróŋá mídrị̂ ní pẽlé sĩ ĩꞌdi ị̃nzị̃jó rĩ drĩ adru lị́cọ́ mídrị̂ be álị́-álị́ ru sĩ míní ãlu mụdrị́ mídrị̂ kí agụjó ku yã áni, ");
INSERT INTO luc_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","lẽ mí ị̃tụ̃ndã kí rá ãzíla íꞌdụ séndẽ la kí ími drị́ gá agụlé ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã pẽlé sĩ ĩꞌdi ị̃nzị̃jó rĩ gâlé. ");
INSERT INTO luc_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","Mí ayú séndẽ la sĩ ãko ími ásị́ ꞌbã lẽlé rĩ kí ĩgbãjó jõnõ tị́ yã, kãbĩlõ yã, wáyĩnĩ yã, ãko mvụlé mvụ-mvụ̃ ũká la yã, jõku ãko cí ími ásị́ ꞌbã lẽlé rĩ kî. Ína ãko ꞌdĩ kí ꞌbá mídrị́ lị́cọ́ gá rĩ kí abe Úpí Ãdróŋá mídrị̂ ꞌbã drị̃lẹ́ gá ãzíla mí uꞌá dó sĩ ãyĩkõ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Ĩnde jõ ꞌBá Lẹ́vị̃ rú uꞌálépi ĩmidrị́ táwụ̃nị̃ agá rĩ kí ĩꞌbã kí adrujó kápa kóru rĩ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","“Drĩ ca ílí na ꞌbã ukóŋá gá, ĩmi ájí ãkónã ĩmidrị́ ãlu mụdrị́ drị̂ kí pírí tã mbalé táwụ̃nị̃ ĩmidrị̂ kí agá. ");
INSERT INTO luc_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","Ị́jọ́ ꞌdĩ sĩ ꞌbá Lẹ́vị̃ rú uꞌálépi táwụ̃nị̃ mídrị̂ agá kápa kóru, ꞌbá ãmị́yọ́ŋá ru, ĩmvú ru, ãzíla ãwụzị kí abe, kí dó sĩ amụ́ ãko ꞌdĩ kí nalé sĩ agajó ãzíla ị́jọ́ ꞌdĩ sĩ Úpí Ãdróŋá mídrị̂ la dó sĩ míní sụ̃sụ́ wi ãzị́ pírí míní ngalé drị́ sĩ rĩ kí drị̃ gá.” ");
INSERT INTO luc_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ílí ázị̂rị̃ ꞌbã ukóŋá gá ĩlị dẹ́nọ̃ ꞌbá ãzí ꞌbã nalé ĩmidrị́ rĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Gẹ̃rị̃ la idéjó la rĩ gápi ꞌdĩ. ꞌBá séndẽ fẽlépi dẹ́nọ̃ rú ádrị́pị̃ Ịsịrayị́lị̃ rú rĩ nî rĩ lẽ ꞌbã lị dẹ́nọ̃ ꞌdã rá, lẽ ꞌbã aꞌị́ dẹ́nọ̃ ꞌdã ị̃dị́ ku, ãꞌdusĩku Úpí fẽ ãzị́táŋá dẹ́nọ̃ ꞌdã kí lịjó rĩ nĩ. ");
INSERT INTO luc_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","Mí icó dẹ́nọ̃ mídrị̂ aꞌị́lé ꞌbá ãmị́yọ́ŋá ru rĩ drị́ rá, wó adru ꞌbá mídrị́ Ịsịrayị́lị̃ ru rĩ drị́ ku. ");
INSERT INTO luc_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","“ꞌBá ãzí icó adrulé lẽmẽrí ru ĩmi agá ꞌdâ ku ãꞌdusĩku Úpí Ãdróŋá mídrị̂ la mụ míní sụ̃sụ́ wilé ãngũ ĩꞌdi ꞌbã mụlé fẽlé míní ãwítã rú rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","Ídrĩ ãzị́táŋá Úpí Ãdróŋá mídrị̂ drị́ mání fẽlé míní ãndrũ ꞌdĩ kí tã mba ãzíla ĩꞌdi tị are rá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Úpí Ãdróŋá mídrị̂ la míní sụ̃sụ́ wi cécé ĩꞌdi ꞌbã ị́jọ́ la azịjó míní ꞌbo rĩ áni. Mi séndẽ fẽ sụ́rụ́ ũꞌbí ꞌbaní dẹ́nọ̃ rú, wó mí icó séndẽ aꞌị́lé sụ́rụ́ ãzí drị́ ku, mi adru úpí ru ꞌbá kí drị̃lẹ́ gá, wó sụ́rụ́ ãzí icó kí adrulé úpí ru ími drị̃lẹ́ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","“Mí ádrị́pịka Ịsịrayị́lị̃ rú la drĩ kí adru lẽmẽrí ru táwụ̃nị̃ ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã mụlé fẽlé míní rĩ kí agá, ími ásị́ ꞌbã mbajõ jõku íbĩ jõ ími mịfị́ ꞌbá mídrị́ Ịsịrayị́lị̃ rú lẽmẽrí rĩ kí ãzã kojó cí ku. ");
INSERT INTO luc_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","Kẹ̃jị́ la gá ị̃nzị̃ ĩmidrị́ mgbọ rú sĩ kí ãzã kojó ĩsá ru ãko ĩꞌbaní lẽlé rĩ kí fẽjó. ");
INSERT INTO luc_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Ĩmi adru mịfị́ trũ, lẽ ĩgã jõ ꞌbá ꞌdĩ ꞌbaní dẹ́nọ̃ fẽlé ku, ĩminí nị̃jó la ála mụ dẹ́nọ̃ kí lịlẹ́ ãni rú ílí ázị̂rị̃ rĩ agá rá rĩ sĩ. Lẽ ũrãtáŋá ũnzí ꞌdĩ ꞌbã áni rĩ ꞌba fi ími ásị́ gá ku. Ídrĩ gã dẹ́nọ̃ fẽlé ĩꞌbaní úmgbé, kí awá Úpí rụ́ ĩmi rụ́ sĩ, ãzíla ála ími ịsụ́ mi adru ị́jọ́ ũnzí trũ. ");
INSERT INTO luc_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Ífẽ ĩꞌbaní ãko ásị́ pírí sĩ ãzíla ĩndrã kóru, ãzíla Úpí Ãdróŋá mídrị̂ la míní sụ̃sụ́ wi ãko míní idélé rĩ kí gá ãzíla ãko míní sĩ ími drị́ tị̃jó kí drị̃ gá rĩ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","ꞌBá ãzí lẽmẽrí la kí adru ụ́ꞌdụ́ pírí sĩ ãngũ Ịsịrayị́lị̃ drị̂ agá cí ãzíla kí ãzãkoma lẽ rá. Ị́jọ́ ꞌdĩ sĩ áꞌbã ãzị́táŋá ru ị̃nzị̃ ĩmi drị́ mgbọ rú sĩ ĩmi ádrị́pịka lẽmẽrí ru ãzãkoma lẽlépi rĩ kí ãzã kojó ãngũ ĩmidrị̂ agá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “ꞌBá ũkú ru jõku ágọ́bị́ ru Ĩbũrãníyã rú la ꞌbã ãzí ru ị̃tụ̃ndãlépi míní ãzị́ ngalépi ílí ázíyá ꞌbo rĩ, lẽ ĩtrũ kí ílí ázị̂rị̃ rĩ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","Ĩdrĩ kí trũ mụjó rá, ĩꞌbaní mụ agá, lẽ ĩmi aꞌbe kí mụlé drị́drị́ ru ku. ");
INSERT INTO luc_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","Ífẽ ĩꞌbaní kãbĩlõ, ị̃ndrị́, ãná ífí ãzíla wáyĩnĩ angájó ãko mídrị̂ kí agá ásị́ pírí sĩ, cécé Úpí Ãdróŋá mídrị̂ ꞌbã míní sụ̃sụ́ la wijó rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","Mí ũrã drĩ ị́jọ́ míní ándrá adrujó ãtíꞌbó rú Mị̃sị́rị̃ gâlé Úpí Ãdróŋá mídrị̂ ꞌbã sĩ ími anzéjó drị́ ũkpó ĩꞌdidrị̂ sĩ rĩ ꞌbã ị́jọ́, ꞌdĩ bãsĩ ị́jọ́ mání míní ãzị́táŋá ꞌdĩ kí fẽjó ãndrũ ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","“Wó ãtíꞌbó mídrị̂ drĩ jọ la míní, ‘Álẽ ími aꞌbelé ku,’ ãꞌdusĩku lẽ mi ꞌi ꞌbá mídrị́ lị́cọ́ gá rĩ kí abe ịsụ́ vâ uꞌáŋá mí be rĩ múké, ");
INSERT INTO luc_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","ꞌdã ꞌbã ũngúkú gá íꞌdụ ĩꞌdi agụlé kẹ̃jị́tị jó mídrị̂ drị̂ agá, ísõ bị́lẹ́ la gụ̃trụ́ sĩ ãzíla ĩꞌdi dó sĩ adru ãtíꞌbó mî ãni la ru jãꞌdâ. Mí idé vâ ãtíꞌbó mídrị́ ũkú ru rĩ ní ãlu ꞌdĩ ꞌbã áni. ");
INSERT INTO luc_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","“Ími ásị́ ꞌbã azá ku míní ãtíꞌbó mídrị̂ kí trũjó rĩ sĩ, ãꞌdusĩku ãzị́ ĩꞌbaní ngalé míní ílí ázíyá ꞌdã ca ãzị́ tá ꞌbá ꞌbãlé séndẽ sĩ rĩ ꞌbã ngalé pâlé ị̃rị̃ rĩ ꞌbã ãjẹ̃ tị gá rá. Ị́jọ́ pírí míní ngalé rĩ kí agá Úpí Ãdróŋá mídrị̂ la sụ̃sụ́ wi kí drị̃ gá rá ídrĩ idé la ꞌdĩ ꞌbã áni rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Lẽ íꞌbã ãnãkpá mvaka kãjãní tị́, kãbĩlõ ãzíla ị̃ndrị́ ꞌbadrị̂ kí Úpí Ãdróŋá mídrị̂ ní angájó kõróŋá mídrị̂ agá. Lẽ íꞌbã mọ́nị̃gọ́ kãjãní tị́ mídrị̂ kí agá la ãzị́ ngalé ku, ãzíla lẽ úlị kãbĩlõ kãjãní rĩ ꞌbã ꞌbíko ku. ");
INSERT INTO luc_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","Ílí ãlu-ãlu sĩ, mi ꞌbá mídrị́ lị́cọ́ gá rĩ kí abe lẽ ĩna ĩzá la kí Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá ãngũ ĩꞌdi ꞌbã pẽlé sĩ ĩꞌdi ị̃nzị̃jó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Ãnãkpá ꞌdĩ drĩ kí adru acá trũ, mịfị́ kọ́lị, jõku ị́lụ́wẹ́ trũ yã áni, mí idé kí ídétáŋá ru Úpí Ãdróŋá mídrị̂ ní ku. ");
INSERT INTO luc_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","Lẽ ĩna ãnãkpá ꞌdĩ ꞌbã áni rĩ kí ꞌbá ĩmidrị̂ kí abe lị́cọ́ gá, ãnãkpá la drĩ táni adru ãlá ru jõku ãlã kóru yã áni, ĩna kí cécé ĩminí mũcé kí nalé lóꞌbá abe rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Wó lẽ ĩna ãrí ku, be la rá la ĩmi asu ĩꞌdi vụ̃rụ́ cécé ị̃yị́ áni.” ");
INSERT INTO luc_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Mí ị̃nzị̃ Úpí Ãdróŋá mídrị̂ ꞌi ị̃nzị̃táŋá Ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ rĩ drị̂ sĩ ĩmbá Ãbíbũ drị̂ agá, ãꞌdusĩku anzé mi angájó Mị̃sị́rị̃ gâlé ị́nị́ ĩmbá ꞌdĩ drị̂ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","Ímụ ãngũ ãlu ị̃nzị̃táŋá drị́ Úpí Ãdróŋá mídrị̂ ꞌbã pẽlé sĩ ĩꞌdi rụ́ ị̃nzị̃jó rĩ gá, mí ụlị́ ãnãkpá kí angájó kõróŋá mídrị̂ agá sĩ Ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ rĩ najó. ");
INSERT INTO luc_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Míní ãkónã ꞌdĩ na agá, ína ĩꞌdi mũkátĩ uꞌbélé ãkụ́kị́ kóru rĩ sĩ. Ína mũkátĩ uꞌbélé ãkụ́kị́ kóru rĩ ụ́ꞌdụ́ ázị̂rị̃, míní ándrá idélé míní ãfũjó Mị̃sị́rị̃ gâlé mbẽlẽ rĩ sĩ rĩ áni. Ína mũkátĩ ꞌdĩ ꞌi, ála ĩꞌdi umve mũkátĩ drị̃cị́rị̃ drị̂, ị́jọ́ ꞌdĩ sĩ mi dó sĩ ị́jọ́ ándrá míní adrujó Mị̃sị́rị̃ gâlé drị̃cị́rị̃ gá rĩ ꞌbã ị́jọ́ ũrã ụ́ꞌdụ́ míní uꞌájó ídri rĩ agá pírí. ");
INSERT INTO luc_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","Lẽ ísụ́ mídrị́ ãngũ gá ãzíla lị́cọ́ gá ãkụ́kị́ ụ́ꞌdụ́ ázị̂rị̃ ụ̃mụ̃ drị́ ꞌdĩ kí agá ku. Ãnãkpá lịlẹ́ ụ́ꞌdụ́ drị̃drị̃ rĩ ꞌbã ĩndró sĩ rĩ úna ĩꞌdi ụ́ꞌdụ́ ꞌdã ꞌbã ị́nị́ sĩ, lẽ ĩzá la ꞌbã ca ụ̃ꞌbụ́tị gá ku. ");
INSERT INTO luc_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","“Mí idé ídétáŋá ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ rĩ drị̂ táwụ̃nị̃ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ ꞌbã ãzí agá ku, ");
INSERT INTO luc_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","be la rá la ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã mụlé pẽlé sĩ ĩꞌdi rụ́ ị̃nzị̃jó rĩ gá. Mí idé ídétáŋá ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ rĩ drị̂ ꞌi ĩndró la ꞌdã sĩ, ị̃tụ́ ꞌbã ꞌde agá ꞌdĩ, sáwã ándrá ụ́ꞌdụ́ míní Mị̃sị́rị̃ aꞌbejó rĩ sĩ rĩ drị̂ áni. ");
INSERT INTO luc_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","Mí ũꞌbĩ ĩzá la ãzíla ína ĩꞌdi ãngũ ãlu Úpí Ãdróŋá mídrị̂ ꞌbã pẽlé sĩ ĩꞌdi ị̃nzị̃jó rĩ gá. Ụ̃ꞌbụ́tị sĩ ígõ dó sĩ vúlé mídrị́ hémã ꞌa gâlé. ");
INSERT INTO luc_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Ína mũkátĩ ãkụ́kị́ kóru rĩ ụ́ꞌdụ́ ázíyá, ụ́ꞌdụ́ ázị̂rị̃ rĩ sĩ ĩtra ĩmi Úpí Ãdróŋá mídrị̂ ị̃nzị̃lé ãzíla ĩnga ãzị́ ụ́ꞌdụ́ ꞌdã sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Ílã sãbị́tị̃ kí ázị̂rị̃ iꞌdójó sáwã míní ũndú lịjó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","ꞌDã ꞌbã ũngúkú gá, mí idé dó Ụ̃mụ̃ ãkónã ãfũlépi drị̃drị̃ mídrị́ ámvụ́ agá rĩ drị̂ ꞌi Úpí Ãdróŋá mídrị̂ ní, mí ají ĩꞌdiní ídétáŋá míní fẽlé cénĩ rĩ kí angájó ãko ĩꞌdiní sụ̃sụ́ wijó míní ĩꞌdi ꞌbã fẽlé rĩ kí agá ãko ĩꞌdiní fẽlé míní rĩ kí úmgbó vú sĩ. ");
INSERT INTO luc_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","Mí uꞌá ãyĩkõ sĩ Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá ãngũ ĩꞌdiní pẽlé sĩ ĩꞌdi ị̃nzị̃jó rĩ gá, mi anzị mídrị̂ kí abe, ãtiꞌbo mídrị́ ũkú ru ãzíla ãgọbị rú rĩ kí, ꞌbá Lẹ́vị̃ rú mídrị́ táwụ̃nị̃ agá rĩ kí, ãzíla ꞌbá ãmị́yọ́ŋá ru rĩ kí, ĩmvú kí ãzíla ãwụzị uꞌálépi ĩmi drĩdríŋĩ gá rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","Ị́jọ́ ándrá míní adrujó ãtíꞌbó ru Mị̃sị́rị̃ gâlé rĩ ꞌba agá jõ drĩ míní, ị́jọ́ ꞌdĩ sĩ ímba ãzị́táŋá ꞌdĩ kí tá ásị́ pírí sĩ.” ");
INSERT INTO luc_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Míní ũndú kí ndrịjó ꞌbo ãzíla zãbíbũ nzijó wáyĩnĩ rú ꞌbo rĩ ꞌbã vúlé gá, mí idé dó Ụ̃mụ̃ nalé bõrõkõ agá rĩ ụ́ꞌdụ́ ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","Mí uꞌá ãyĩkõ sĩ ụ̃mụ̃ ꞌdĩ sĩ anzị mídrị̂ kí abe, ãtíꞌbó mídrị́ ũkú ru ãzíla ágọ́bị́ rú rĩ kí, ꞌbá Lẹ́vị̃ rú mídrị́ táwụ̃nị̃ agá rĩ kí, ãzíla ꞌbá ãmị́yọ́ŋá ru rĩ kí, ĩmvú kí ãzíla ãwụzị uꞌálépi táwụ̃nị̃ mídrị̂ agá rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","Mí ị̃nzị̃ Úpí Ãdróŋá mídrị̂ ꞌi ãyĩkõ sĩ ụ́ꞌdụ́ ázị̂rị̃ ãngũ ãlu ĩꞌdi ꞌbã pẽlé sĩ ĩꞌdi ị̃nzị̃jó rĩ gá. Mí uꞌá ãyĩkõ sĩ ãꞌdusĩku Úpí Ãdróŋá mídrị̂ wi sụ̃sụ́ ãkónã míní ũkũnãlé ãzíla ãzị́ míní ngalé ími drị́ sĩ rĩ kí drị̃ gá rá. ");
INSERT INTO luc_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","“Ãgọbị mídrị́ sụ́rụ́ agá rĩ ꞌbã amụ́ kí pírí Úpí Ãdróŋá mídrị̂ ị̃nzị̃lé pâlé na ílí ãlu-ãlu sĩ ãngũ ĩꞌdi ꞌbã pẽlé sĩ ĩꞌdi ị̃nzị̃jó rĩ gá: Ụ̃mụ̃ mũkátĩ ãkụ́kị́ kóru rĩ drị̂ ꞌi, Ụ̃mụ̃ ãkónã ãfũlépi drị̃drị̃ mídrị́ ámvụ́ agá rĩ drị̂ ꞌi ãzíla Ụ̃mụ̃ nalé bõrõkõ agá rĩ trũ. ꞌBá ãzí ꞌba amụ́ drị́drị́ ru Úpí drị̃lẹ́ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","ꞌBá ãlu-ãlu ꞌbã ají ãwãꞌdĩfô úmgbó Úpí Ãdróŋá mídrị̂ ꞌbã sụ̃sụ́ la wijó ĩꞌdiní rĩ ꞌbã vú sĩ.” ");
INSERT INTO luc_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Mí ũpẽ ínátị ãlu-ãlu agá ꞌbá ị́jọ́ lịlẹ́pi rĩ kí ãzíla ꞌbá ãmbogo rú táwụ̃nị̃ pírí Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ kí agá. ꞌBá ꞌdĩ ꞌbã lị kí ꞌbá kí ị́jọ́ múké-múké uyaŋá kọ́lị. ");
INSERT INTO luc_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","ꞌBá ị́jọ́ lịlẹ́pi rĩ ꞌbã atrị ị́jọ́ lịlẹ́ mgbã rĩ ku, jõku ꞌba uya ꞌbá kí ku. Mí aꞌị́ séndẽ sĩ ꞌbá mịfị́ sajó rĩ ku, ãꞌdusĩku ĩꞌdi ꞌbá ũndũwã rú rĩ ꞌbã mịfị́ ãsã cí ãzíla ꞌbá ị́jọ́ mgbãrĩ idélépi rĩ fẽ ị́jọ́ pịrị rĩ ujalé ị́jọ́ ũnzí ru. ");
INSERT INTO luc_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Ụ́ꞌdụ́ pírí sĩ mí awa ị́jọ́ pịrị rĩ, ị́jọ́ ꞌdĩ sĩ mi dó sĩ uꞌá ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","Mụ́sã jọ, “Míní ãlĩtárĩ idé agá Úpí Ãdróŋá mídrị̂ ní, mí ịꞌdị ị́dị́ŋá ife rú bụ́lụ́ la gá ꞌdâ ãdróŋá ũkú ru Ãsérã ní la ku. ");
INSERT INTO luc_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","Mí ịꞌdị írã ãzí kí ị́dị́ŋá ru ãdroŋa ĩnzõ rú la kí ị̃nzị̃jó ku, ãꞌdusĩku Úpí Ãdróŋá mídrị̂ ngụ̃ kí ũnzí.” ");
INSERT INTO luc_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","Mụ́sã jọ, “Mí idé jõ ídétáŋá ru tị́ jõku kãbĩlõ ãcá trũ jõku ãyánĩ rú la kí Úpí Ãdróŋá mídrị̂ ní ku, ꞌdĩ kí ãko Úpí Ãdróŋá mídrị̂ ꞌbã ngụ̃lé ũnzí rĩ kî. ");
INSERT INTO luc_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","“Ídrĩ are la ágọ́bị́ ãzí jõku ũkú ãzí uꞌálépi táwụ̃nị̃ ĩmidrị́ ꞌdĩ kí agá la iza ị́jọ́ Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá sĩ tị icíma ꞌdĩ kí nũjó rá, ");
INSERT INTO luc_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","sĩ ãdroŋa ĩnzõ rú ꞌdĩ kí ị̃nzị̃jó ãzíla ãzị́ ngajó ĩꞌbadrị́ jõku ị̃tụ́ ị̃nzị̃jó jõku ĩmbá ị̃nzị̃jó jõku lẽlẽgó ꞌbụ̃ gá ꞌdĩ kí ị̃nzị̃jó, ãzị́táŋá Úpí drị̂ kí bụ́lụ́ gâsĩ, ");
INSERT INTO luc_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","ídrĩ ị́jọ́ ꞌdĩ áni la are rá, lẽ mí ifí ị̃ndụ́ la múké-múké. Ị́jọ́ ũnzí ꞌdĩ áni rĩ drĩ ru idé Ịsịrayị́lị̃ gá ꞌdâ rá ãndá-ãndá ru yã áni, ");
INSERT INTO luc_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","mí ájí ágọ́bị́ jõku ũkú ị́jọ́ ũnzí ꞌdĩ áni ꞌdĩ idélépi rĩ kẹ̃jị́tị sĩ fijó táwụ̃nị̃ agâlé rĩ gá, lẽ úꞌbé ĩꞌdi írã sĩ ꞌbã drã dó sĩ káyĩ rá. ");
INSERT INTO luc_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","ꞌBá ị̃rị̃ jõku ꞌbá na drĩ kí ị́jọ́ vû nze drị̃ la gá ãzíla drĩ kí ru ájí pírí ãlu, lẽ úꞌdị ĩꞌdi rá, wó ꞌbá ãlu drĩ ị́jọ́ vû nze drị̃ la gá nĩ lẽ úꞌdị ĩꞌdi ku. ");
INSERT INTO luc_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","ꞌBá sãdínĩ rú rĩ ꞌbã iꞌdó kí ĩꞌdi uꞌbélé kí drị́ sĩ drị̃drị̃ sĩ ĩꞌdi ꞌdịjó, ãzíla ũꞌbí ꞌbã iꞌdó kí dó ĩꞌdi uꞌbélé sãdínĩ kí vú gâsĩ, gẹ̃rị̃ ꞌdĩ áni rĩ sĩ, ĩmi dó sĩ ị́jọ́ ũnzí drị̃ atrị ĩmi drĩdríŋĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","“Údrĩ Ununuŋá ãzí ají ími drị̃lẹ́ gá wó drĩ mba rá sĩ ị́jọ́ la lịjó, drĩ adru ãrí asuŋá ãni yã, jõku ãcóŋá ãni yã, jõku ꞌbá ꞌdịŋá ãni yã, ĩmi agụ ĩꞌdi ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã pẽlé sĩ ĩꞌdi ị̃nzị̃jó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","Mí agụ ununuŋá ꞌdĩ áni ꞌdĩ kí ãtalo Lẹ́vị̃ rú la kí drị̃lẹ́ gá, ãzíla ꞌbá ị́jọ́ lịlẹ́pi dũwánĩ gá sáwã ꞌdã sĩ rĩ drị̃lẹ́ gá, ífẽ ꞌbã amá kí ị́jọ́ drị̃ la gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","Lẽ mí idé ị́jọ́ ĩꞌbã kí amálé rĩ ꞌbã vúŋá ãngũ Úpí ꞌbã mụlé pẽlé rĩ gá ꞌdãá. Mí adru mịfị́ trũ sĩ ị́jọ́ ꞌdĩ kí ngajó cécé ĩꞌbã kí lũlé míní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","Ínga ị́jọ́ ãzị́táŋá drị́ ĩꞌbã kí imbálé míní rĩ kí ãzíla ị́jọ́ ĩꞌbaní amálé mí idé kí rĩ kí vúŋá. Mí uja mi bụ́lụ́ gá sĩ ị́jọ́ ĩꞌbaní lũlé míní rĩ kí aꞌbejó ku. ");
INSERT INTO luc_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","ꞌBá ꞌbá ị́jọ́ lịlẹ́pi rĩ jõku átáló ãzị́ tị gá pá tulépi Úpí Ãdróŋá mídrị̂ ꞌbã kẹ̃jị́ gá rĩ idelépi rĩ lẽ úꞌdị ĩꞌdi rá, gẹ̃rị̃ ꞌdĩ ꞌbã áni rĩ sĩ, mi dó sĩ ị́jọ́ ũnzí atrị ꞌbá Ịsịrayị́lị̃ drị̂ kí drĩdríŋĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","ꞌBá ãzí drĩ dó sĩ are la, ĩꞌdi dó sĩ idé ụ̃rị̃ sĩ, ãzíla ꞌbá ãzí icó dó sĩ idemará ꞌdã ꞌbã áni la idélé ị̃dị́ ku.” ");
INSERT INTO luc_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Mụ́sã jọ, “Ídrĩ fi ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní íꞌdụ ĩꞌdi mî ãni la rú rĩ gá sĩ rijó ꞌbo, ãzíla mí icó jọlé la, ‘Lẽ ãpẽ kí ꞌbá ãzí ãmaní úpí ru cécé sụ́rụ́ ãzí ãma andre gá ꞌdĩ ꞌbadrị̂ áni.’ ");
INSERT INTO luc_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","Lẽ ínị̃ rá ꞌbá míní pẽlé úpí ru rĩ ꞌba adru ꞌbá Úpí Ãdróŋá mídrị̂ ꞌbã pẽlé nị̃ la. ꞌBa adru ꞌbá mí ádrị́pịka rú la kí ꞌbã ãzí, íꞌbã jõ ãmị́yọ́ŋá míní úpí ru ku. ");
INSERT INTO luc_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Úpí ꞌdã ꞌbã adru jõ fãrásĩ trũ ũꞌbí ru ãsĩkárĩ ĩꞌdidrị̂ ꞌbaní ku, ꞌbã pẽ jõ ꞌbá kí tị vúlé Mị̃sị́rị̃ gâlé sĩ mụjó fãrásĩ ãzí kí ĩgbãjó ku, ãꞌdusĩku Úpí jọ ꞌbá ĩꞌdidrị̂ bã gõ kí jõ vúlé lé ị̃dị́ ku. ");
INSERT INTO luc_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Lẽ ꞌbã ꞌdụ ũkú wẽwẽ rú ku, ãꞌdusĩku ũkú ꞌdĩ kí mụ ásị́ la ujalé Ãdróŋá rụ́ ꞌdâ ku rá, ꞌba adru kụ́rẹ́nị́ sílĩvã trũ ãzíla gólũdĩ trũ ambamba ku. ");
INSERT INTO luc_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","“Drĩ acá úpí ru ꞌbo, lẽ ꞌbã adru bụ́kụ̃ ãzị́táŋá ꞌdĩ ꞌbadrị̂ trũ cí, ímbátáŋá la ala gá rĩ ꞌba adru kí bụ́kụ̃ ãzị́táŋá drị́ ãtalo Lẹ́vị̃ rú rĩ ꞌbã kí imbálé rĩ ꞌbã vúŋá. ");
INSERT INTO luc_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Lẽ ꞌbã mba bụ́kụ̃ ꞌdĩ tã ĩꞌdi andre gá ãni rú ãzíla ꞌbã lã ĩꞌdi ụ́ꞌdụ́ pírí sĩ. Ị́jọ́ ꞌdĩ sĩ ĩꞌdi dó sĩ ụ̃nị̃ ãrútáŋá fẽlé Úpí Ãdróŋá ĩꞌdidrị̂ ní, tị la arejó ãzíla ãzị́táŋá fẽlé ĩꞌdiní rĩ kí vú ũbĩjó pírí. ");
INSERT INTO luc_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","Ị́jọ́ ꞌdĩ la ĩꞌdi tãmba ũrãtáŋá índẽ dó ꞌî ádrị́pịka Ịsịrayị́lị̃ rú rĩ kí rá rĩ gá, ãzíla ĩꞌdi ĩꞌdi atrị icójó ãzị́táŋá Úpí drị̂ kí gãjó gẹ̃rị̃ ndú ndú sĩ rĩ gá. ꞌDã ꞌbã ũngúkú gá, ĩꞌdi dó sĩ ũpĩ na ílí ãzo rú ãzíla anzị ĩꞌdidrị́ drị̃lẹ́ gâlé rĩ kí vâ ũpĩ na ílí ãzo rú ãngũ Ịsịrayị́lị̃ drị̂ gá.” ");
INSERT INTO luc_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbanî, “Ãtalo ãfũlépi sụ́rụ́ Lẹ́vị̃ drị̂ kí agá rĩ kí ꞌbá Lẹ́vị̃ rú rĩ kí abe pírí, úfẽ ĩꞌbaní wókõ ãngũ ãni la ãngũ Ịsịrayị́lị̃ drị̂ gá ꞌdãá ku; be la rá la kí uꞌá ãko fẽlé ãwãꞌdĩfô rú ãzíla ãko ãzí fẽlé Úpí ní ídétáŋá ru rĩ kí sĩ. ");
INSERT INTO luc_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","Úfẽ ĩꞌbaní ãngũ sụ́rụ́ ãzí rĩ ꞌbadrị̂ áni ku, wókõ ĩꞌbadrị̂ gápi Úpí ní fẽlé adrujó ãtalo rú ꞌdã cécé Úpí ꞌbã azịlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","“Sáwã tị́ kí jõku kãbĩlõ kí idéjó ídétáŋá ru rĩ sĩ, ị̃wụ́, sị́sọ̃ ãzíla ífí la kí abe úfẽ kí ãtalo ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","Ĩfẽ ĩꞌbaní ãko ĩsélé ĩmidrị́ ãfũlépi drị̃drị̃ ãná, wáyĩnĩ, ãdu nalé nãnã rĩ ãzíla wị́zị̃ idélé kãbĩlõ ꞌbíko sĩ rĩ abe. ");
INSERT INTO luc_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","Mi ị́jọ́ ꞌdĩ nga íni la ãꞌdusĩku Úpí Ãdróŋá mídrị̂ pẽ sụ́rụ́ Lẹ́vị̃ ꞌbadrị̂ sụ́rụ́ ĩmidrị̂ kí agá ꞌdâ pírí sĩ ãzị́ átáló drị̂ ngajó anzị ĩꞌdidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ abe jãꞌdâ. ");
INSERT INTO luc_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","“ꞌBá Lẹ́vị̃ rú la drĩ ãfũ táwụ̃nị̃ ĩmi drị́ Ịsịrayị́lị̃ drị̂ kí ꞌbã ãzí gá ãngũ ĩꞌdi ꞌbã sĩ uꞌájó rĩ gá sĩ amụ́jó ãngũ Úpí ꞌbã pẽlé sĩ ĩꞌdi ị̃nzị̃jó rĩ gá, ");
INSERT INTO luc_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","icó ãzị́ ngalé Úpí Ãdróŋá ĩꞌdidrị̂ ní átáló ru cécé ãtalo Lẹ́vị̃ ru ꞌdĩ kí ꞌbã ãzí ꞌbã kí ngalé rĩ áni rá. ");
INSERT INTO luc_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","ꞌBa ịsụ́ ãkónã úmgbó fẽlé ꞌbá ꞌdã ꞌbaní rĩ vúŋá cécé ãtalo ãzí rĩ ꞌbã kí ịsụ́lé rĩ áni, átã ꞌbá ĩꞌdidrị̂ drĩ kí táni ĩꞌdiní ãko ãzí ãjị́ angájó lị́cọ́ ĩꞌdidrị̂ gâlé rá tí.” ");
INSERT INTO luc_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Mụ́sã jọ, “Ídrĩ fi ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ gá ꞌbo, mí ụ̃nị̃ jõ gẹ̃rị̃ sụ́rụ́ ꞌdãá rĩ ꞌbã kí sĩ ị́jọ́ ũnzí idéjó rĩ kí ku. ");
INSERT INTO luc_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Lẽ ꞌbá ãzí ĩmi drĩdríŋĩ gá la ꞌbã fẽ ídétáŋá ru ĩꞌdi ꞌbã ngọ́tị́ ágọ́bị́ jõku ĩzóŋá ídétáŋá ivélé ivê rĩ rú ku ãzíla ꞌbá ãzí ꞌbã ndrị ãndrị́kẹ ku, ꞌbã nga ũlẽgõ ãzị́ ku, ");
INSERT INTO luc_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","lẽ ꞌbá ãzí ꞌbã uwi úrí ku, ꞌbã nga ũjõgõ ãzị́ ku ãzíla ꞌbã zị ị́jọ́ ꞌbá ũdrãlépi rá rĩ kí ꞌbã úríndí tị gá ku. ");
INSERT INTO luc_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Úpí Ãdróŋá mídrị̂ lẽ ꞌbá ị́jọ́ ũnzíkãnã ꞌdĩ áni ꞌdĩ kí idélépi rĩ kí ku, ãzíla ị́jọ́ ꞌdĩ bãsĩ gápi fẽlépi la ĩꞌdiní sụ́rụ́ ãzí ꞌdĩ kí drojó ãmvé ãngũ ĩminí sĩ mụjó rijó ꞌdã gá ꞌdãá rá ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Mí adru Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá ị́jọ́ kóru.” ");
INSERT INTO luc_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Mụ́sã jọ, “Sụ́rụ́ míní sĩ lẽjó mụjó rijó ãngũ ĩꞌbadrị̂ agá ꞌdĩ kí ꞌbá ãndrị́kẹ ndrịlépi ãzíla ũjõgõ ãzị́ ngalépi la kî. Wó Úpí Ãdróŋá mídrị̂ uga míní ị́jọ́ ꞌdĩ kí ngalé úgmbé. ");
INSERT INTO luc_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Úpí Ãdróŋá mídrị̂ la míní nábị̃ mâ áni la inga ĩmi drĩdríŋĩ gá angájó mí ádrị́pịka kí agá ꞌdâ ãzíla lẽ ĩmi are ĩꞌdi tị rá. ");
INSERT INTO luc_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","ꞌDĩ ị́jọ́ ándrá míní zịlé Úpí Ãdróŋá mídrị̂ tị gá sáwã ándrá ĩminí ĩmi trajó ꞌBé Hõrébũ gá ꞌdãá rĩ sĩ rĩ ꞌi, míní jọjó la, ‘Lẽ má are ụ́ꞌdụ́kọ́ Úpí Ãdróŋá mádrị̂ ãni la jõku ándre ãcí ãmbógó ꞌdĩ ị̃dị́ ku, ãꞌdusĩku mã mụ drãlé ku rá rĩ ꞌi.’ ");
INSERT INTO luc_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","“Ị́jọ́ ꞌdĩ sĩ Úpí jọ mání, ‘Ị́jọ́ ĩꞌbã kí jọlé ꞌdĩ ĩꞌdi múké. ");
INSERT INTO luc_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Ma mụ ĩꞌbaní nábị̃ ãzí mí áni la ingalé kí drĩdríŋĩ gá ꞌdâ; ma mụ ĩꞌdiní ị́jọ́ ĩꞌdi ꞌbã mụlé jọlé rĩ lũlé ãzíla ĩꞌdi mụ ị́jọ́ pírí mání azịlé rĩ kí lũlé ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní nĩ. ");
INSERT INTO luc_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Ĩꞌdi mụ ị́jọ́ jọlé áma rụ́ sĩ, mã mụ drị̃rịma fẽlé ꞌbá ĩꞌdi tị gãlépi úmgbé rĩ ní rá. ");
INSERT INTO luc_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Wó nábị̃ ãzí drĩ angá ị́jọ́ jọlé áma rụ́ sĩ ịsụ́ ꞌdĩ sĩ áfẽ ĩꞌdiní ãzị́táŋá la ma ꞌi ku, jõku nábị̃ ị́jọ́ jọlépi rụ́ ãdroŋa ãzí ĩnzõ rú ꞌdĩ ꞌbadrị̂ sĩ rĩ lẽ úꞌdị ĩꞌdi rá.’ ");
INSERT INTO luc_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Mí icó ími zịlé, ‘Ãma icó dó nị̃lé la ụ́ꞌdụ́kọ́ ꞌdĩ angá Úpí drị́ ku rĩ gá íngoní ru yã?’ ");
INSERT INTO luc_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Ị́jọ́ Nábị̃ ãzí ꞌbã jọlé Úpí rụ́ sĩ rĩ drĩ ru idé ku jõku drĩ adru mgbã ku, ꞌdã adru ị́jọ́ ãfũlépi Úpí tị gá la ku. Nábị̃ ꞌdã la ị́jọ́ ĩꞌdi ãni ꞌbá ꞌbá la jọ. Ĩmi idé ụ̃rị̃ ĩꞌdi sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","Mụ́sã jọ, “Úpí Ãdróŋá mídrị̂ drĩ dó sụ́rụ́ ĩꞌdi ꞌbã sĩ mụjó ãngũ la fẽjó míní rĩ ꞌbã ꞌbá kí ị̃lị̃kị̃ rá, ídrĩ dó kí ndẽ sĩ rijó táwụ̃nị̃ ĩꞌbadrị̂ kí agá ãzíla lị́cọ́ ĩꞌbadrị̂ kí agá ꞌbo, ");
INSERT INTO luc_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","ípẽ dó míní táwụ̃nị̃ ãzí kí na ágágá ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní sĩ uꞌájó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","Mí awa ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní ꞌdã wókõ na sĩ, ãngũ ãlu-ãlu ꞌbã adru táwụ̃nị̃ sĩ icójó cajó ala gá gbõrú rĩ trũ. Ị́jọ́ ꞌdĩ sĩ, ꞌbá ãzí drĩ ꞌbá ꞌdị, ĩꞌdi dó sĩ apá ru zị̃lé ala gá sĩ ru tãmbajó. ");
INSERT INTO luc_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","“ꞌBá ãzí drị́ drĩ ru pa ꞌbá ꞌdịjó drị̃lẹ́ ũnzĩ sĩ drĩ adru ị́jọ́ ásị́ gá la sĩ ku yã áni, ĩꞌdi dó sĩ icó apálé ru zị̃lé sĩ ru tãmbajó táwụ̃nị̃ ꞌdã kí ãzí agá rá, ĩꞌdi dó sĩ uꞌá ị́jọ́ kóru. ");
INSERT INTO luc_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","Ícétáŋá sĩ, ãgọbị ị̃rị̃ drĩ kí mụ ãngũ ãlu gá ife galé ásé agâlé, ãlu rĩ ꞌbã ife ga agá, nekeŋá drĩ nze ãzí ãlu rĩ drị́ gá sĩ ãzí rĩ drị̃ gajó káyĩ, ĩꞌdi icó apálé ru zị̃lé sĩ ru tãmbajó táwụ̃nị̃ ꞌdĩ kí ãzí agá rá, ĩꞌdi dó sĩ uꞌá ị́jọ́ kóru. ");
INSERT INTO luc_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","Táwụ̃nị̃ sĩ apájó ru zị̃jó rĩ drĩ tá adru ãlu, drĩdríŋĩ cajó alagá rĩ icó adrulé rá-rá ru, wó ágọ́bị́ ꞌdịlé rĩ ꞌbã kãká ãvũ ãrí ũfẽlépi rĩ drĩ ĩꞌdi dro arụ́lé ꞌdịlé gẹ̃rị̃ gá sĩ ãrígọ́tị la ũfẽjó, ágọ́bị́ ꞌbá ꞌdịlépi andre-ũnzĩ sĩ rĩ úꞌdị ꞌbãngá ĩꞌdi ị́jọ́ kó ru ãꞌdusĩku ị́jọ́ ãzí ĩꞌbã ãni ásị́ gá la ꞌbã adrujó ĩꞌdi ꞌbã jĩránĩ be ꞌdáyụ rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","Ị́jọ́ ꞌdĩ bãsĩ mání ãzị́táŋá fẽjó ĩminí sĩ táwụ̃nị̃ ãzí kí pẽjó na bụ́lụ́ gá ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","“Úpí Ãdróŋá mídrị̂ drĩ dó sụ́rụ́ mídrị̂ nzã mgbọ rú ándrá ĩꞌdi ꞌbã ũyõ la najó ꞌi mụ idélé la rá rĩ áni, ãzíla ĩꞌdi ꞌbã ãngũ ĩꞌdi ꞌbã ị́jọ́ azịjó mí áyị́pịka ꞌbaní ꞌi fẽ la rĩ áni, ");
INSERT INTO luc_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","ꞌdã ꞌbã ũngúkú gá mí ũpẽ táwụ̃nị̃ ãzí kí na ị̃dị́. (Ĩꞌdi mụ ãngũ ꞌdĩ fẽlé mídrị́ ídrĩ ãzị́táŋá pírí ãndrũ mání fẽlé míní ꞌdĩ kí idé rá ãzíla ídrĩ Úpí Ãdróŋá mídrị̂ lẽ sĩ uꞌájó ímbátáŋá ĩꞌdidrị̂ kí sĩ rĩ gá.) ");
INSERT INTO luc_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","Gẹ̃rị̃ ꞌdĩ sĩ mi dó sĩ ꞌbá ꞌdịŋá ị́jọ́ kóru rĩ atrị ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã mụlé fẽlé míní ãwítã rú rĩ gá. Ị́jọ́ ꞌdĩ sĩ ị́jọ́ ꞌbá ꞌdịjó ị́jọ́ kóru rĩ rụ dó sĩ mi ku. ");
INSERT INTO luc_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","“Wó ꞌbá ãzí drĩ ĩꞌdi ꞌbã jĩránĩ ngụ̃ ũnzí, drĩ ru zị̃ ĩꞌdi tẽlé gẹ̃rị̃ tị gá, ĩꞌdi cojó ãzíla drĩ ĩꞌdi ꞌdị rá, drĩ apá ru zị̃lé táwụ̃nị̃ ꞌdĩ kí ꞌbã ãzí ãlu la gá, ");
INSERT INTO luc_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","ꞌbá ĩyõ drị̃lẹ́ ru táwụ̃nị̃ ĩꞌdidrị̂ agá rĩ ꞌbã pẽ kí ꞌbá ãzí kí tị sĩ ĩꞌdi ajíjó vúlé angájó táwụ̃nị̃ ꞌdã agâlé ãzíla ꞌbã fẽ kí dó sĩ ĩꞌdi ꞌbá ꞌdịlé rá rĩ ꞌbã ãrígọ́tị ũfẽjó, ị́jọ́ ꞌdĩ sĩ lẽ úꞌdị dó sĩ ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","Ĩmi iꞌda ĩꞌdiní ásị́ ị̃gbẹ̃ ku. Lẽ ĩꞌdị ꞌbá ꞌbá ị́jọ́ kóru rĩ ꞌdịlépi rĩ ãngũ Ịsịrayị́lị̃ drị̂ agá ꞌdâ rá, ị́jọ́ pírí kí dó sĩ adru ĩminí múké benĩ. ");
INSERT INTO luc_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","“Mí unze jõ írã ándrá mí áyị́pịka ꞌbã kí usúlé lõkókõrí mídrị́ mî jĩránĩ kí abe ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ gá rĩ kí ku.” ");
INSERT INTO luc_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Lẽ úlị ꞌbá ị́jọ́ ũnzí idélépi rĩ ꞌbã ị́jọ́ sãdínĩ ãlu sĩ ku, ị́jọ́ lịjó pịrị-pịrị rá, lẽ sãdínĩ ꞌbã adru kí ị̃rị̃ jõku na. ");
INSERT INTO luc_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","“Sãdínĩ ãzí drĩ lẽ ꞌbá ãzí ní ũcõgõ fẽlé sĩ ĩꞌdi tõjó ĩnzõ sĩ, ");
INSERT INTO luc_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","ꞌbá ị̃rị̃ ị́jọ́ ꞌdĩ gá rĩ ꞌbã tu kí pá ꞌbá ãtalo rú ãzíla ꞌbá ị́jọ́ lịlẹ́pi sáwã ꞌdã sĩ rĩ kí drị̃lẹ́ gá ãngũ sĩ Úpí ị̃nzị̃jó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","Lẽ ꞌbá ị́jọ́ lịlẹ́pi rĩ ꞌbã ndrụ̃ kí ị́jọ́ la ꞌbã ị̃ndụ́ múké-múké, wó údrĩ ꞌbá sãdínĩ rú rĩ ịsụ́ jọ ĩnzõ, ị́jọ́ ĩnzõ rú ĩꞌdi ꞌbã jọlé ĩꞌdi ꞌbã ádrị́pị̃ ụrụꞌbá gá rĩ sĩ, ");
INSERT INTO luc_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","ꞌbá ꞌdĩ ꞌbã áni rĩ ꞌbã ịsụ́ drị̃rịma ꞌbá tá ꞌbá tõlépi rĩ ꞌbã tá tí mụlé ịsụ́lé rĩ. Gẹ̃rị̃ ꞌdĩ áni rĩ sĩ, ĩmi dó sĩ ị́jọ́ ũnzí atrị ĩmi drĩdríŋĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","ꞌBá ꞌbã ị́mbị́lị́kọ́ acelépi rĩ kí dó sĩ ị́jọ́ ꞌdĩ are ãzíla kí dó sĩ idé ụ̃rị̃ sĩ, ãzíla ị́jọ́ ũnzí ꞌdĩ ꞌbã áni rĩ icó dó sĩ ru idélé ĩmi drĩdríŋĩ gá ꞌdâ ị̃dị́ ku. ");
INSERT INTO luc_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","Ị́jọ́ ꞌdĩ ꞌbã áni rĩ kí agá ĩmi iꞌda ásị́ ị̃gbẹ̃ ku: ídri ꞌbã ụfụ kí drị̃ ídri be, mịfị́ ꞌbã ụfụ kí drị̃ mịfị́ be, sị́ ꞌbã ụfụ kí drị̃ sị́ be, drị́ ꞌbã ụfụ kí drị̃ drị́ be ãzíla pá ꞌbã ụfụ kí drị̃ pá be.” ");
INSERT INTO luc_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Ídrĩ mụ ãꞌdị́ gá mẹ́rọ́ꞌbá mídrị̂ ꞌba rụ́, ídrĩ ndre la fãrásĩ kí, gárĩ ãꞌdị́ drị̂ kí ãzíla ãsĩkárĩ ĩꞌbadrị̂ kí abe ndẽ kí ũꞌbĩkãnã sĩ mídrị̂ kí rá, mí idé kí sĩ ụ̃rị̃ sĩ ku, ãꞌdusĩku Úpí Ãdróŋá mídrị́ ími anzélépi ãngũ Mị̃sị́rị̃ drị̂ agâlé rĩ la adru mí be cí. ");
INSERT INTO luc_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","Mi jõ dó ãni rú lẽjó ãꞌdị́ iꞌdójó, átáló ꞌbã amụ́ pá tulé ãsĩkárĩ kí drị̃lẹ́ gá sĩ ị́jọ́ jọjó ĩꞌbaní. ");
INSERT INTO luc_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","ꞌBã jọ, ‘Mí are drĩ Ịsịrayị́lị̃, ãndrũ mi dó mụ ãꞌdị́ ꞌdịlé mẹ́rọ́ꞌbá mídrị̂ kí abe ꞌdĩ, ími ásị́ ꞌbã umvú ku jõku mí idé ụ̃rị̃ sĩ ku, ími ụrụꞌbá ꞌbã yã mẹ́rọ́ꞌbá mídrị̂ kí drị̃lẹ́ gá ku, ");
INSERT INTO luc_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","ãꞌdusĩku Úpí Ãdróŋá ĩmidrị̂ la mụ ĩmi abe ĩndĩ, ãzíla ĩꞌdi ĩmi fẽ ãꞌdị́ ndẽlé rá.’ ");
INSERT INTO luc_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","“ꞌBá ãmbogo rú ãsĩkárĩ kí drị̃lẹ́ gá rĩ kí jọ la ãsĩkárĩ ꞌbaní, ‘ꞌBá ãzí jó úꞌdí la sịlépi sĩ Ãdróŋá zịjó drị̃ la gá ku la cí yã? Ị́jọ́ ꞌdĩ sĩ, lẽ ꞌbã gõ lị́cọ́ gá, jõ íni ku ĩꞌdi icó mụlé drãlé ãꞌdị́ gâlé rá ãzíla ꞌbá ãzí ndú la la dó sĩ mụ Ãdróŋá zịlé jó ꞌdã drị̃ gá nĩ ku rá. ");
INSERT INTO luc_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","ꞌBá ãzí ꞌdâ zãbíbũ ámvụ́ trũ wó ífí la ãjị́ ꞌbị̃lépi ku la cí yã? Lẽ ꞌbã gõ lị́cọ́ gá, jõ íni ku ĩꞌdi icó drãlé ãꞌdị́ gâlé rá ãzíla ꞌbá ãzí ndú la la dó sĩ mụ ãyĩkõ idélé ífí la sĩ nĩ ku rá. ");
INSERT INTO luc_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","ꞌBá ãzí lẽlépi ũkú ĩgbãlépi wó ají drĩ ũkú lê ku la cí yã? Lẽ ꞌbã gõ lị́cọ́ gá, jõ íni ku ĩꞌdi icó drãlé ãꞌdị́ gâlé rá ãzíla ꞌbá ãzí ndú la lã mụ ũkú ꞌdã ĩgbãlé nĩ ku rá.’ ");
INSERT INTO luc_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","ꞌDã ꞌbã ũngúkú gá, ꞌbá ãmbogo rú ãsĩkárĩ kí drị̃lẹ́ gá rĩ kí dó vâ jọ la ĩꞌbaní, ‘ꞌBá ãzí ụ̃rị́ ãzíla ásị́ umvúlépi umvú-umvû la cí yã? Lẽ ꞌbã gõ vúlé lị́cọ́ gá ãꞌdusĩku ĩꞌdi mụ ũkpó ãkõ fẽlé ádrị́pịka ãzí ꞌdĩ ꞌbaní ku rá.’ ");
INSERT INTO luc_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","ꞌBá ãsĩkárĩ ꞌbã ãmbogo rú rĩ drĩ kí dó ị́jọ́ jọŋá de ãsĩkárĩ kí abe ꞌbo, kí dó drị̃lẹ́ ãsĩkárĩ ꞌbadrị̂ kí ũpẽ ãsĩkárĩ kí drĩdríŋĩ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","“Míní mụ agá táwụ̃nị̃ ãzí ce agá sĩ ãꞌdị́ ꞌdịjó, drị̃drị̃ rĩ sĩ ífẽ ĩꞌbaní drị̃lẹ́mgbọ sĩ ásị́ ị̃gbẹ̃ ịsụ́jó ráká. ");
INSERT INTO luc_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","Drĩ kí ãꞌị̃ kẹ̃jị́ tị ĩꞌbadrị́ táwụ̃nị̃ drị̂ kí nzị̃lé ásị́ ị̃gbẹ̃ sĩ rá, ꞌbá pírí táwụ̃nị̃ ꞌdã agá rĩ kí dó sĩ adru mî ãtíꞌbó ru, mi dó sĩ kí ũŋmĩ ãzị́ ngalé míní ũkpó sĩ. ");
INSERT INTO luc_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","ꞌBá táwụ̃nị̃ ꞌdã agá rĩ drĩ kí gã ásị́ ị̃gbẹ̃ idélé mí be úmgbé ãzíla drĩ kí mí be ãꞌdị́ ãꞌị̃, ãsĩkárĩ ꞌbã ce kí táwụ̃nị̃ ꞌdã trộkị́lịrị. ");
INSERT INTO luc_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","ꞌDã ꞌbã ũngúkú gá, Úpí Ãdróŋá mídrị̂ drĩ dó fẽ la ípa táwụ̃nị̃ ꞌdã rá, mí ụꞌdị́ ãgọbị ala gá rĩ kí pírí rá. ");
INSERT INTO luc_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","Wó ũkú kí, anzị kí abe, ãnãkpá kí trũ ãzíla ãko ãzí táwụ̃nị̃ ꞌdã agá rĩ kí abe pírí, kí dó adru ụ̃rọ̃drị́ mí ãni la rú, ãzíla mi dó sĩ icó ụ̃rọ̃drị́ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní angájó mẹ́rọ́ꞌbá mídrị̂ ꞌba rụ̂lé rĩ kí ayúlé mí ãni la rú rá. ");
INSERT INTO luc_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","Ínga ị́jọ́ ꞌdĩ kí ꞌbá táwụ̃nị̃ mí rụ́ ꞌdâ rá-rá ru ãngũ míní sĩ mụjó rijó ala gá rĩ gá ꞌdã kí ụrụꞌbá gá cécé ꞌdĩ ꞌbã áni, adru sụ́rụ́ mí rụ́ ꞌdâ ãni rú rĩ ꞌba rụ́ ku. ");
INSERT INTO luc_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","“Wó sụ́rụ́ Úpí Ãdróŋá mídrị̂ ꞌbã mụlé fẽlé ãwítã rú míní rĩ ꞌbã táwụ̃nị̃ kí agá, mí ụꞌdị́ ãko ídri trũ ala gá ꞌdãá rĩ kí pírí. ");
INSERT INTO luc_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","Mí ị̃lị̃kị̃ ꞌbá sụ́rụ́ ꞌdã kí agá rĩ kí pírí: ꞌBá Hị́tị̃ drị̂ kí, ꞌbá Ãmọ́rị̃ drị̂ kí, ꞌbá Kãnánĩ drị̂ kí, ꞌbá Pẹ̃rẹ́zị̃ drị̂ kí, ꞌbá Hị́vị̃ drị̂ kí ãzíla ꞌbá Yẹ̃bụ́sị̃ drị̂ kí abe cécé Úpí Ãdróŋá mídrị̂ ꞌbã míní ũkpó la fẽjó rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","Ĩdrĩ kí ị̃lị̃kị̃ pírí ku, kí ĩmi fẽ ị́jọ́ ũnzí idélé Úpí Ãdróŋá ĩmidrị̂ rụ́, ị́jọ́ ꞌdĩ sĩ kí dó sĩ ĩmi imbá ị́jọ́ drị̃nzá ru ĩꞌbã kí jõ sĩ ãdroŋa ĩꞌbadrị̂ kí ị̃nzị̃jó rĩ kî sĩ. ");
INSERT INTO luc_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","“Míní lẽ agá táwụ̃nị̃ ꞌdã pa agâ, íga ife ífí la kí najó nãnã rĩ kí vụ̃rụ́ ku, ãꞌdị́ ꞌdã drĩ táni ụ́ꞌdụ́ ꞌdụ agá ãzo rú rá tí. Mí icó ife ꞌdã kí ífí nalé rá, wó ĩga jõ kí vụ̃rụ́ ku, ãꞌdusĩku ife ꞌdã adru kí mẹ́rọ́ꞌbá mídrị̂ kí ku. ");
INSERT INTO luc_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","Mí icó ife ãzí ífí nalé ku ꞌdĩ kí izalé ãzíla galé vụ̃rụ́ sĩ ãko ími ãzãkolépi sĩ táwụ̃nị̃ ꞌdã ꞌdụjó rĩ kí idéjó rá kpere míní táwụ̃nị̃ ꞌdã ꞌdụ agâ.” ");
INSERT INTO luc_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","Mụ́sã jọ, “Údrĩ ꞌbá ãzí ịsụ́ úꞌdị ĩꞌdi ũní ásé agâlé ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã mụlé fẽlé míní rĩ gá, wó údrĩ nị̃la ãꞌdi ꞌdị ĩꞌdi nĩ yã rĩ gá ku, ");
INSERT INTO luc_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","ꞌbá ĩyõ ĩmidrị́ drị̃lẹ́ ru rĩ kí ãzíla ꞌbá ị́jọ́ lịlẹ́pi rĩ kí abe ꞌbã mụ kí ãngũ ꞌdã ꞌbã ãzo ãvũ rụ́ ꞌdãá rĩ ụ̃ꞌbị̃lé táwụ̃nị̃ ãníyágágá ꞌdãá ĩꞌdi ịsụ́jó rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","ꞌDã ꞌbã ũngúkú gá, ꞌbá ĩyõ drị̃lẹ́ ru táwụ̃nị̃ ãníŋá ãvũ ꞌdã andre gá rĩ ꞌbã aꞌdụ́ kí tị́ kẹ̃rị́ drĩ ãzị́ ngalépi ku la. ");
INSERT INTO luc_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","ꞌBá ĩyõ ꞌdã ꞌba agụ kí ĩꞌdi áꞌbụ ị̃yị́ trũ nzụlépi ku, drĩ sõlé ku ãzíla ũri sajó ala gá ku la agá, ꞌbã nũ kí imbe la rá. ");
INSERT INTO luc_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","Anzị Lẹ́vị̃ drị́ ãtalo rú ꞌdĩ ꞌbã mụ kí ꞌdãá ĩndĩ, ãꞌdusĩku kí mụ kẹ́sị̃ ru bĩlépi ãlí be ꞌdĩ lịlẹ́ nĩ. Úpí Ãdróŋá mídrị̂ pẽ kí ãzị́ ngalé ĩꞌdinî ãzíla kí sĩ ị́jọ́ sụ̃sụ́ wijó rĩ jọ nĩ. ");
INSERT INTO luc_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","ꞌDã ꞌbã ũngúkú gá, ꞌbá ĩyõ pírí drị̃lẹ́ ru táwụ̃nị̃ ãni ágágá ãvũ ꞌdã andre gá rĩ ꞌbã ũjĩ kí ru drị́ tị́ kẹ̃rị́ imbe nũlé ꞌdã drị̃ gá, ");
INSERT INTO luc_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","ãzíla ꞌbã jọ kí, ‘Ãma asu ãrí ꞌdĩ drị́ ãmadrị̂ sĩ ku ãzíla ãnị̃ ãꞌdu ídé ĩꞌdi nĩ yã rĩ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","ꞌBá drị̃lẹ́ ru ꞌdĩ kí dó Úpí aꞌị́ jọjó la ítrũ ꞌbá mídrị́ Ịsịrayị́lị̃ drị́ míní apálé Mị̃sị́rị̃ gâlé ꞌdĩ kî. Úpí ítrũ ãma ãzíla íꞌbã ị́jọ́ ꞌbá ꞌdịlé ị́jọ́ kọ́lị ꞌdĩ drị̂ ãma drị̃ gá ku fô!’ ");
INSERT INTO luc_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","Ị́jọ́ ꞌdĩ sĩ, ị́jọ́ ĩminí idélé Úpí ꞌbã lẽlé rá ꞌdĩ la fẽ, ãrí ꞌbá ꞌdã drị̂ úꞌbã dó sĩ ĩꞌdi ĩmi drị̃ gá ku.” ");
INSERT INTO luc_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","Mụ́sã jọ, “Ídrĩ mụ ãꞌdị́ ꞌdịlé mẹ́rọ́ꞌbá mídrị̂ kí abe ãzíla Úpí Ãdróŋá mídrị̂ drĩ dó kí fẽ ĩmidrị́ gá rá, ĩdrĩ dó sĩ kí rụ ãꞌdị́ gá ꞌdãá mãbụ́sụ̃ rú, ");
INSERT INTO luc_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","ĩmi ãzí drĩ ũkú ãzí ndre kí agá ꞌdãá ãla ru, drĩ lẽ ĩꞌdi ꞌdụlé ĩꞌdiní ũkú ru yã áni, ");
INSERT INTO luc_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","ꞌba agụ ĩꞌdi lị́cọ́ ĩꞌdidrị̂ gá, ꞌbã ufá ĩꞌdi drị̃ꞌbị́ rá ãzíla ꞌbã ụlị́ únúká la kí rá, ");
INSERT INTO luc_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","ãzíla ꞌbã ũtrũ bõngó ándrá sĩ ĩꞌdi rụjó rĩ kí rá. ꞌBa uꞌá dó ĩꞌdidrị́ ko gá ꞌdãá átẹ́pị̃ kí awájó ãndrẽ be ĩmbá ãlu, ꞌdã ꞌbã ũngúkú gá icó dó ĩꞌdi ꞌdụlé ĩꞌdiní ũkú ru rá. ");
INSERT INTO luc_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","Vúlé vúlé ru drĩ uꞌá ĩꞌdiní ãyĩkõ sĩ ku, lẽ ꞌba aꞌbe ĩꞌdi mụlé drị̃lẹ́ mgbọrú. Ĩꞌdiní ĩꞌdi ꞌdụjó ũkú ru rá rĩ sĩ icó dó ĩꞌdi ꞌbãlé ãtíꞌbó ru ku, ãzíla ĩꞌdi ị̃tụ̃ndãlé séndẽ sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “ꞌBá ãzí drĩ adru ũkú kí trũ ị̃rị̃ drĩ ãzí rĩ lẽ ãndânĩ, wó ngọ́tị́ kãjãní rĩ drĩ adru ũkú ĩꞌdi ꞌbã ngụ̃lé ũnzí rĩ drị̂ ꞌi, ");
INSERT INTO luc_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","ágọ́bị̂ drĩ dó lẽ ãko ĩꞌdidrị̂ kí awalé anzị ĩꞌdidrị̂ ꞌbaní, lẽ ꞌbã fẽ hákĩ ngọ́tị́ kãjãní rĩ drị̂ kí mũlũmbẽ kóru adru ũkú vúlé ĩꞌdi ꞌbã lẽlé ambamba rĩ ꞌbã ngọ́tị́ drị́ la ku. ");
INSERT INTO luc_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","Lẽ ꞌbã fẽ ãko úmgbó pâlé ị̃rị̃ rĩ kí ngọ́tị́ kãjãní rĩ nî, drị̃ táni adru agá ngọ́tị́ ũkú ngụ̃lé ũnzí rĩ drị̂ ꞌi rá tí. Ngọ́tị́ ꞌdĩ bãsĩ ĩꞌdiní bõdõ ụ̃nị̃jó rĩ. Hákĩ kãjãní drị̂ kí ĩꞌdi ãni.” ");
INSERT INTO luc_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","Mụ́sã jọ Ịsịrayị́lị̃ ní, “ꞌBá ãzí drĩ adru ngọ́tị́ drị̃ ũnzí ãzíla átẹ́pị̃ kí tị arelépi ãndrẽ be ku la trũ, drĩ kí táni ĩꞌdiní drị̃rịma fẽ rá, drĩ gã kí tị arelé úmgbé, ");
INSERT INTO luc_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","átẹ́pị̃ ꞌbã rụ kí ĩꞌdi ãndrẽ be, ꞌbã agụ kí ĩꞌdi ꞌbá ĩyõ drị̃lẹ́ ru táwụ̃nị̃ ꞌdã agá rĩ kí drị̃lẹ́ gá pá tujó kẹ́sị̃ drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","ꞌBã jọ kí ꞌbá ĩyõ drị̃lẹ́ ru rĩ ꞌbaní, ‘Ngọ́tị́ ãmadrị́ ꞌdĩ drị̃ la ũnzí, gã ãma tị arelé úmgbé, ĩꞌdi séndẽ iza ãzíla ĩꞌdi ꞌbá ĩmẽrãlépi íwá sĩ la.’ ");
INSERT INTO luc_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","ꞌDã ꞌbã ũngúkú gá, ꞌbá pírí Ịsịrayị́lị̃ drị̂ kí dó sĩ ĩꞌdi uꞌbé írã sĩ káyĩ. Gẹ̃rị̃ ꞌdĩ áni rĩ sĩ, ĩmi dó sĩ ị́jọ́ ũnzí atrị ĩmi drĩdríŋĩ gá rá. ꞌBá pírí Ịsịrayị́lị̃ drị̂ kí dó sĩ are la ãzíla kí dó sĩ idé ụ̃rị̃ sĩ.” ");
INSERT INTO luc_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Údrĩ ꞌbá ãzí ꞌdị ị́jọ́ ũnzí ĩꞌdi ꞌbã idélé rĩ sĩ ãzíla údrĩ dó sĩ ãvũ la gĩ ife sị́ gá, ");
INSERT INTO luc_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","lẽ âꞌbe ãvũ la ife sị́ gá ꞌdãá kpere ị́nị́ gá ku. Îsị̃ ĩꞌdi ụ́ꞌdụ́ ãlu ꞌdã ꞌbã vúŋá sĩ rá, ãꞌdusĩku ãvũ ꞌbádrị́ ife sí gá rĩ la áwãtáŋá Ãdróŋá drị̂ ají ãngũ drị̃ gá. Mí andị́ ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé ĩminí ꞌdĩ ãvũ ị̃sị̃lé ku rĩ sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Ídrĩ ꞌbá ãzí ꞌbã tị́ jõku kãbĩlõ ndre lẽ ãvĩlé ãvĩ-ãvĩ, mí aꞌbe ĩꞌdi ku, írụ ĩꞌdi agụlé vúlé ꞌdị́pị̃ drị̂lé. ");
INSERT INTO luc_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","ꞌBá ꞌdã ꞌbã lị́cọ́ drĩ adru ãni rú ku, jõku ídrĩ ꞌdị́pị̃ la ãꞌdi ꞌi yã rĩ nị̃ ku yã áni, íꞌdụ tị̂ ꞌi jõku kãbĩlõ ꞌi trũ mụjó lị́cọ́ gâlé mí be ĩndĩ kpere ꞌdị́pị̃ ꞌbã ru aꞌdị́ agá. Mi dó sĩ fẽ la ĩꞌdidrị̂lé ĩndõ. ");
INSERT INTO luc_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","Mí idé ị́jọ́ ãlu ꞌdĩ áni rĩ ídrĩ ꞌbá ãzí ꞌbã kãyĩnõ, bõngó jõku ãko ãzí ꞌbá ãzí ãni lẽlépi ãvĩlépi ãvĩ-ãvĩ la ịsụ́ rĩ gá, lẽ mí aꞌbe ĩꞌdi ku. ");
INSERT INTO luc_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","“Ídrĩ ꞌbá ãzí ꞌbã kãyĩnõ jõku tị́ ndre aꞌdé vụ̃rụ́, mí aꞌbe ĩꞌdi ku. Íko ꞌbá ꞌdã ꞌbã ãzã ãnãkpá ĩꞌdidrị̂ ingajó ụrụ gá pá drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","“Lẽ ũkú ꞌbã sụ̃ kí ãgọbị ꞌbã bõngó ku, ãzíla ãgọbị ꞌbã sụ̃ kí ũku kí ꞌbã bõngó ku, ãꞌdusĩku Úpí Ãdróŋá mídrị̂ ngụ̃ ꞌbá ị́jọ́ ꞌdĩ ꞌbã áni rĩ kí idélépi rĩ kí ũnzí. ");
INSERT INTO luc_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","“Ídrĩ ãríŋá ãzí ꞌbã jõrõvũ ịsụ́ ife sị́ gá jõku vụ̃rụ́ gẹ̃rị̃ tị gá ãzíla ãndrẽ vũ mvaka kí drị̃ gá jõku gbẹ́ kí drị̃ gá, lẽ íꞌdụ ãríŋâ ꞌbã ãndrẽ ĩndĩ ku. ");
INSERT INTO luc_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","Mí icó ãríŋâ ꞌbã mvaka kí ꞌdụlé rá, wó lẽ mí aꞌbe ãríŋâ ꞌbã ãndrẽ mụlé rá, ị́jọ́ ꞌdĩ sĩ mí dó sĩ uꞌá ụ́ꞌdụ́ ãzo ru ãzíla adru málĩ trũ. ");
INSERT INTO luc_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","“Ídrĩ jó úꞌdí sị, lẽ ísị Bõrõ ãzí dẽrẽ la jó ꞌdã ꞌbã drị̃ ꞌbã bụ́lụ́ gâsĩ cí sĩ ꞌbá kí atrị jó áꞌdéŋá gá. ꞌBá ãzí drị̃ dó sĩ aꞌdé drãjó rá, ị́jọ́ la adru dó sĩ mî ãni ku. ");
INSERT INTO luc_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","“Lẽ mí umú ũri ị̃rị̃ kí salé amvụ́ mídrị́ zãbíbũ drị̂ agá ku; ídrĩ idé la ꞌdĩ ꞌbã áni rá, ũri míní salé ꞌdã kí zãbíbũ drị̂ be kí ru iza ị̃rị̃trá rá. ");
INSERT INTO luc_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","“Lẽ mí icí mọ́nị̃gọ́ kí kãyĩnõ be ãngũ ãlu gá sĩ ámvụ́ sõjó ku. ");
INSERT INTO luc_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","“Lẽ ísụ̃ bõngó cãlé kãbĩlõ ꞌbíko sĩ usalé bõngó mịfị́ níríŋá rĩ be ãngũ ãlu gá rĩ kí ku. ");
INSERT INTO luc_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","“Mí ịgbẹ bõngó tãyã-tãyã la bõngó míní sụ̃lé rĩ ꞌbã kónã sụ rĩ kí tị gâsĩ cí.” ");
INSERT INTO luc_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ágọ́bị́ ãzí drĩ ũkú aꞌdụ́, ĩꞌbaní ru lajó ĩꞌdi be ꞌbo rĩ ꞌbã vúlé drĩ dó ĩꞌdi ngụ̃ ũnzí, ");
INSERT INTO luc_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","ãzíla drĩ dó sĩ ĩnzõ alị́ ĩꞌdi rụ́ sĩ rụ́ la izajó jọjó la, ‘Má aꞌdụ́ ándrá ĩꞌdi ũkú ru, wó ma mụ áma lalé ĩꞌdi be ꞌbo, má ịsụ́ adru bíkĩrã ku.’ ");
INSERT INTO luc_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","“Ị́jọ́ ꞌdĩ drĩ ru idé ꞌdĩ áni rá, ĩzóŋâ ꞌbã átẹ́pị̃ kí ãndrẽ be ꞌbã aꞌdụ́ kí sókã ándrá ãrí trũ ị̃zẹ́pị̃ ꞌbã kí sĩ ru lajó ágô be drị̃ la gá ụ́ꞌdụ́ drị̃drị̃ ꞌdã sĩ rĩ ꞌi, iꞌdajó la ꞌbá ĩyõ kí drị̃lẹ́ gá ꞌbị̃ jõ drĩ ágó ãjị́ ku. ");
INSERT INTO luc_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","Ĩzóŋâ ꞌbã átẹ́pị ꞌbã jọ dó ꞌbá ĩyõ drị̃lẹ́ ru rĩ ꞌbaní, ‘Áfẽ ándrá mâ ị̃zẹ́pị ágọ́bị́ ꞌdĩ ní ũkú ru, wó úꞌdîꞌda gã dó ĩꞌdi úmgbé. ");
INSERT INTO luc_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","Ị́jọ́ ꞌdĩ sĩ úꞌdîꞌda alị́ dó ĩnzõ ĩzóŋá mádrị̂ ụrụꞌbá gá ãzíla jọ ísụ́ mâ ị̃zẹ́pị adru bíkĩrã ku. Wó ꞌbá ĩyõ ꞌdĩ, ãko iꞌdalépi la mâ ị̃zẹ́pị ĩꞌdi bíkĩrã rĩ ĩꞌdi sókã ãrí trũ ándrá ĩꞌbaní sĩ ru lajó drị̃ la gá ụ́ꞌdụ́ drị̃drị̃ ꞌdã sĩ rĩ gápi ꞌdĩ.’ ");
INSERT INTO luc_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","Ị́jọ́ ꞌdĩ ꞌbã ũngúkú gá ꞌbá ĩyõ drị̃lẹ́ ru táwụ̃nị̃ drị̂ kî dó ágô ꞌdụ sĩ ĩꞌdi ị̃ndụ́ cojó. ");
INSERT INTO luc_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","ꞌBã lị kí drị̃ la gá séndẽ sílĩvã rú rĩ 100 fẽlé fáyĩnĩ rú átẹ́pị̃ ní, ãꞌdusĩku ágọ́bị́ ꞌdĩ iza ĩzóŋá bíkĩrã rú Ịsịrayị́lị̃ rú ꞌdĩ ꞌbã rụ́. Ĩzóŋâ ꞌbã adru dó ĩꞌdi ꞌbã ũkú ru ãzíla lẽ ágô ꞌbã dro ĩꞌdi ku kpere ĩꞌdiní drã agâ. ");
INSERT INTO luc_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","“Wó ị́jọ́ ĩꞌdi tõjó rĩ drĩ adru ãndá ãzíla ãko ãzí iꞌdalépi la ĩzóŋá ꞌdĩ bíkĩrã la drĩ adru ꞌdáyụ, ");
INSERT INTO luc_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","lẽ ꞌba agụ ĩꞌdi átẹ́pị̃ drị́ kẹ̃jị́tị gá, ꞌbá táwụ̃nị̃ ꞌdã gá ꞌdãá rĩ ꞌbã uꞌbé kí ĩꞌdi írã sĩ káyĩ rá, ãꞌdusĩku ĩꞌdiní ị́jọ́ drị̃nzá ru la idéjó ãngũ Ịsịrayị́lị̃ drị̂ gá ĩꞌdiní mị-ãcí idéjó átẹ́pị̃ drị́ kogâlé ꞌdĩ sĩ rụ drĩ ágó ku rú rĩ sĩ. Gẹ̃rị̃ ꞌdĩ áni rĩ sĩ, ĩmi dó sĩ ị́jọ́ ũnzí drị̃ atrị ĩmi drĩdríŋĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","“Údrĩ ágọ́bị́ ãzí ịsụ́ ꞌbá ãzí ꞌbã ũkú drị̃ iza agá, ágọ́bị́ ĩꞌdi ꞌbã ũkû drị̃ izalépi ꞌdã kí ũku ꞌdã be lẽ ụ́ꞌdị́ kí ị̃rị̃trá rá. Gẹ̃rị̃ ꞌdĩ áni rĩ sĩ, ĩmi dó sĩ ị́jọ́ ũnzí atrị ĩmi drĩdríŋĩ gá Ịsịrayị́lị̃ gá ꞌdâ. ");
INSERT INTO luc_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","“Ágọ́bị́ ãzí drĩ kí ru ịsụ́ ĩzóŋá bíkĩrã rú drị̃ ꞌbãlé ĩgbãlé ũkú ru la be drĩ drị̃ la iza sĩ ru lajó rá, ");
INSERT INTO luc_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","ĩmi kí ꞌdụ ị̃rị̃trá kẹ̃jị́tị táwụ̃nị̃ ꞌdã drị̂ gá ãzíla ĩmi úꞌbé kí írã sĩ káyĩ rá, ãꞌdusĩku ĩzóŋâ ꞌbe ụ̃lụ́lụ́ ãzãkoma ịsụ́jó ku, ágọ́bị̂ iza ꞌbá ãzí ꞌbã ũkú drị̃. Gẹ̃rị̃ ꞌdĩ ꞌbã áni rĩ sĩ, ĩmi dó sĩ ị́jọ́ ũnzí drị̃ atrị ĩmi drĩdríŋĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","“Wó ꞌbá ãzí drĩ ĩzóŋá drị̃ ꞌbãlé ĩgbãlé ꞌbá ãzí ní ũkú ru la ụrụ rá, lẽ ágọ́bị́ ꞌdã ꞌbã drã lú ị́jọ́ ꞌdã sĩ nĩ. ");
INSERT INTO luc_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","Lẽ ídé ị́jọ́ ãzí ũnzí la ĩzóŋá ꞌdã ꞌbã ụrụꞌbá gá ku, ãꞌdusĩku idé drĩ ị́jọ́ ũnzí sĩ ĩꞌdiní drãjó rá la ku. Kẹ́sị̃ ꞌdĩ ĩꞌdi cécé ꞌbá ãzí ní ꞌbá ãzí cojó ãzíla sĩ ĩꞌdi ꞌdịjó rĩ áni, ãꞌdusĩku ");
INSERT INTO luc_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","ágọ́bị̂ ụrụ ĩzóŋá drị̃ ꞌbãlé ĩgbãlé ũkú ru ꞌdĩ ásé agâlé, ĩzóŋâ ní táni uzájó sĩ ãzãkoma ịsụ́jó rá tí, ꞌbá ãzí aꞌdị́ ru sĩ ĩꞌdi ãzã kojó ku. ");
INSERT INTO luc_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","“Ágọ́bị́ ãzí drĩ ĩzóŋá bíkĩrã rú drị̃ ꞌbãlé ĩgbãlé ku la ãzí ụrụ rá, údrĩ kí rụ rá, ");
INSERT INTO luc_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","ĩꞌdi ĩzóŋâ ꞌbã átẹ́pị drị́ ãjẹ̃ ũfẽ séndẽ sílĩvã rú kãlị́ tõwú sĩ. Lẽ ꞌbã ꞌdụ ĩꞌdi ĩꞌdi ꞌbã ũkú ru ãꞌdusĩku ụrụ ĩꞌdi ũkpõ sĩ. Icó ĩꞌdi drolé ku kpere ĩꞌdiní drã agá. ");
INSERT INTO luc_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","“ꞌBá ãzí ꞌbã la ru átẹ́pị̃ ꞌbã ũkú sĩ ku, lẽ ꞌbã fẽ drị̃nzá átẹ́pị̃ ní ĩꞌdiní ru lajó átẹ́pị̃ drị́ mgbọ́lọ́ sị́ gá rĩ sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Ágọ́bị́ acolé pálé gâlé rá jõku pálé la lịjó rá rĩ ꞌbã fi ꞌbá Úpí drị̂ kí agá ku. ");
INSERT INTO luc_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","“ꞌBá tịlé ụ̃gbọ́ ru rĩ jõku ꞌbá ꞌdĩ áni rĩ ꞌbã anzị mụlé tịlé drị̃lẹ́ gâlé rĩ kí, cajó kpere áꞌbị́ anzị mụdrị́ rĩ ꞌba rụ́, ꞌbã fi kí ꞌbá Úpí drị̂ kí agá ku. ");
INSERT INTO luc_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","“ꞌBá Ãmọ́nị̃ drị̂ kí jõku ꞌbá Mụ̃wábụ̃ drị̂ kí jõku anzị ĩꞌbadrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe, kpere áꞌbị́ anzị mụdrị́ rĩ ꞌba rụ́, ꞌbã fi kí ꞌbá Úpí drị̂ kí agá ku jãꞌdâ. ");
INSERT INTO luc_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","Ĩꞌbã kí ándrá gãjó ĩminí íná ãzíla ị̃yị́ fẽjó úmgbé gẹ̃rị̃ gá ꞌdãá sáwã ĩmini ãfũjó Mị̃sị́rị̃ gâlé rĩ sĩ rĩ sĩ, ãzíla ĩꞌbaní ándrá Bẹ̃yọ́rị̃ ngọ́pị Bãlámũ angálépi táwụ̃nị̃ Pẽtórĩ Mẽsõpõtámĩyã gá rĩ ayújó ĩmi wãjó rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","Wó Úpí Ãdróŋá mídrị̂ gã Bãlámũ tị arelé úmgbé, kẹ̃jị́ la gá uja áwãtáŋá ꞌdĩ míní drị̃lẹ́ba rú, ãꞌdusĩku ĩꞌdi ꞌbã ími lẽjó rá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","Lẽ índrụ̃ uꞌájó ĩꞌba abe ásị́ ị̃gbẹ̃ sĩ ku jõku índrụ̃ málĩ ĩꞌbadrị̂ kí sáwã pírí míní adrujó ídri rú rĩ kí agá ku. ");
INSERT INTO luc_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","“Mí ide ꞌbá Ídõmũ drị̂ kí ku ãꞌdusĩku kí mî ádrị́pịka kî. Mí ide vâ ꞌbá Mị̃sị́rị̃ drị̂ kí ku ãꞌdusĩku mí uꞌá ándrá vâ ãmị́yọ́ŋá ru ĩꞌbadrị́ ãngũ gá rá. ");
INSERT INTO luc_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","Áꞌbị́ anzị ĩꞌbadrị́ mụlé tịlé drị̃lẹ́ gâlé námbã na sĩ rĩ kí dó mụ filé ꞌbá Úpí drị́ ru tralépi rĩ kí agá nĩ.” ");
INSERT INTO luc_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Ĩminí ĩmi tra agá kámbĩ sĩ ãꞌdị́ ꞌdịjó mẹ́rọ́ꞌbá ĩmidrị̂ kí abe rĩ gá, ĩmi idé ị́jọ́ ũnzí ku. ");
INSERT INTO luc_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","Ágọ́bị́ ãzí drĩ ru ũnzõ ị́nị́ sĩ údré sĩ yã áni, ꞌbã fũ kámbĩ agá ꞌdãá rĩ sĩ ãmvé ãꞌdusĩku ĩꞌdi ãndị́ ru ãzíla ꞌba uꞌá áꞌdụ̂sĩ. ");
INSERT INTO luc_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","Drĩ ca ĩndró sĩ ꞌbã ũjĩ ru rá, ị̃tụ̂ ꞌbã ꞌde agá ꞌdâ icó dó afílé ꞌbá kí agá kámbĩ agá ꞌdõlé rá. ");
INSERT INTO luc_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","“Lẽ ãngũ ĩminí sĩ mụjó ĩzẽ gá ãzíla údré gá rĩ ꞌbã adru kí kámbĩ agá rĩ sĩ ãmvé. ");
INSERT INTO luc_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","Ĩminí acị́ agá, ĩmi acị́ ãko ãzí sĩ ꞌbụ́ gajó la trũ, ị́jọ́ ꞌdĩ sĩ ĩdrĩ dô sĩ lẽ mụlé ĩzẽ gá, ĩmi dó sĩ ꞌbụ́ ga ãzíla ĩmi dó sĩ ĩzẽ drị̃ kụ̃ cí. ");
INSERT INTO luc_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","Ímba kámbĩ míní sĩ rijó ala gá rĩ tã ãlá ru ĩminí ĩmĩ tra agá ãngũ ãlu gá, ãꞌdusĩku Úpí Ãdróŋá mídrị̂ ĩꞌdi ĩmi drĩdríŋĩ gá ꞌdâ cí sĩ ĩmi tã mbajó ãzíla ĩminí ãꞌdị́ ndẽjó, ị́jọ́ ꞌdĩ sĩ lẽ ĩmi idé cãkã ku, Úpí Ãdróŋá ĩmidrị̂ la mụ ru ugoró ujalé ĩminí ku rá.” ");
INSERT INTO luc_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","Mụ́sã jọ bá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ãtíꞌbó ágọ́bị́ ru jõku ũkú ru rĩ drĩ kí apá ágọ́bị́ ĩꞌbã ãmbógó ru rĩ rụ́ ꞌdãá rĩ sĩ rá, drĩ kí apá mị́rị̃ rú sĩ ru pajó, lẽ ípẽ kí tị vúlêlé ị̃dị́ ku. ");
INSERT INTO luc_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","Icó uꞌálé ĩmi drĩdríŋĩ gá ꞌdâ ãngũ ĩꞌdi ꞌbã pẽlé táwụ̃nị̃ ĩmidrị̂ kí ꞌbã ãzí ãlu ĩꞌdiní múké la agá rá. ");
INSERT INTO luc_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","“Ãgọbị jõku ũku Ịsịrayị́lị̃ gá rĩ ꞌbã nga kí ãwụ̃ ãngũ sĩ Ãdróŋá ị̃nzị̃jó rĩ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","Séndẽ ịsụ́lé ãwụ̃ sĩ rĩ lẽ ájí ĩꞌdi jó Ãdróŋá drị̂ agá sĩ ũyõ najó drị̃ la gá ku. Úpí Ãdróŋá mídrị̂ gã séndẽ sĩ ụrụꞌbá ụzịjó ꞌdĩ áni rĩ kí úmgbé. ");
INSERT INTO luc_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","“Ídrĩ séndẽ jõku ãkónã jõku ãko cí la fẽ ꞌbá mí ãni Ịsịrayị́lị̃ rú la nî, lẽ íꞌbã ụ̃rọ̃drị́ drị̃ la gá ku. ");
INSERT INTO luc_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","Mí icó ụ̃rọ̃drị́ ꞌbãlé ãko ꞌdĩ áni ꞌdĩ drị̃ gá rá la ãmị́yọ́ŋá ꞌbanî, wó ku la ꞌbá mí ãni Ịsịrayị́lị̃ rú rĩ nî, mí ũbĩ ãzị́táŋá ꞌdĩ kí vú ãzíla Úpí Ãdróŋá mídrị̂ la dô sĩ míní sụ̃sụ́ wi ãko pírí míní mụlé ꞌdụlé rĩ kí agá ãngũ míní sĩ mụjó rijó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","“Ídrĩ ũyõ na Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá, lẽ íꞌbe ị́jọ́ míní azịlé sĩ ũyõ najó ꞌdã vụ̃rụ́ ku, Úpí Ãdróŋá mídrị̂ la ími rụ ũyõ ĩnzõ rụ́ ꞌdĩ sĩ rá, ãzíla ĩꞌdi ị́jọ́ ũnzí la ídrĩ ũyõ nalé rĩ tã mba ku rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","Wó ídrĩ ũyõ na ku adru ími drị̃ gá ị́jọ́ ũnzí la rú ku. ");
INSERT INTO luc_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","Wó ídrĩ ũyõ na ími tị sĩ cénĩ ꞌbo, ími vúŋá ꞌbã mba ũyõ míní nalé Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá rĩ tã múké-múké. ");
INSERT INTO luc_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","“Ídrĩ mụ mî jĩránĩ ꞌbã ámvụ́ zãbíbũ drị̂ tị gâsĩ, mí icó zãbíbũ ala gá rĩ kí nalé rá, wó lẽ íꞌdụ ãzíla ãkójó sĩ ĩndĩ ku. ");
INSERT INTO luc_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","Ídrĩ mụ mî jĩránĩ ꞌbã ámvụ́ ãná drị̂ tị gâsĩ, mí icó ãnâ ucelé anilé ími drị́ gá nalé rá, be la rá la, ílã ị́lị́ŋá sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Ícétáŋá sĩ ágọ́bị́ ãzí drĩ ũkú ĩgbã rá ãzíla drĩ vúlé vúlé ru lẽ ĩꞌdi gãlé úmgbé, ãꞌdusĩku ĩꞌdiní ị́jọ́ ãzí ãyĩkõ fẽlépi ĩꞌdiní ku la ịsụ́jó ĩꞌdi ụrụꞌbá gá rĩ sĩ, lẽ ꞌbã sĩ wárãgã sĩ ũkú ꞌdã gãjó rĩ drị́ la gá ãzíla ꞌbã pẽ dó sĩ tị la ĩꞌdidrị́ko gá ꞌdãá rá. ");
INSERT INTO luc_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","Ũkú ꞌdã drĩ lị́cọ́ ágọ́bị́ ꞌdã drị̂ aꞌbe ꞌbo, drĩ dó mụ ágó ãzí gá, ");
INSERT INTO luc_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","ãzíla ũkû ꞌbã ágó námbã ị̃rị̃ sĩ rĩ drĩ vâ ĩꞌdi ngụ̃ ũnzí, ágô ꞌbã sĩ wárãgã ĩꞌdi ꞌbã sĩ ũkú ꞌdã gãjó rĩ fẽlé drị́ la gá ĩndĩ, ꞌbã pẽ dó sĩ ĩꞌdi tị ĩꞌdidrị́ko gá ꞌdãá rĩ sĩ rá, jõku ágô drĩ drã rá, ");
INSERT INTO luc_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","ágó kãyú ándrá ĩꞌdi gãlépi ꞌdã lẽ ꞌbã ĩgbã ũkú ꞌdã ị̃dị́ ku, lẽ ꞌbã nị̃ rá ũkú ꞌdã dó ãndị́ ru, drĩ ĩꞌdi ĩgbã ĩꞌdiní ũkú ru ị̃dị́, ĩꞌdi adru Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá ꞌbá ngụ̃lé ũnzí la rú, lẽ mí idé ũnzĩkãnã ãzí ãmbógó ꞌdĩ áni la ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ gá ꞌdâ ku. ");
INSERT INTO luc_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","“Ágọ́bị́ ãzí drĩ ũkú ĩgbã úꞌdí, lẽ úpẽ tị la ãꞌdị́ gá ku jõku úfẽ ĩꞌdiní ãzị́ ngalé ũꞌbí kí agá ku, lẽ ꞌba uꞌá drị̃lẹ́mgbọ rú ílí ãlu lị́cọ́ gâsĩ ãzíla ꞌbã fẽ sĩ ãyĩkõ ũkú ĩꞌdi ꞌbã ĩgbãlé rĩ ní rá ká. ");
INSERT INTO luc_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","“Ídrĩ ꞌbá ãzí ní dẹ́nọ̃ fẽ, lẽ íꞌdụ ĩꞌdi ꞌbã írã sĩ ãná ꞌịjó rĩ tị la gá gúrã rú ku, ꞌdĩ la fẽ la mi ꞌbá lị́cọ́ ꞌdã agá ꞌdãá rĩ kí ꞌbã ãko kí sĩ uꞌájó ídri rĩ ꞌdụ rá. ");
INSERT INTO luc_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","“Údrĩ ꞌbá ãzí ịsụ́ ꞌbá Ịsịrayị́lị̃ rú ágọ́bị́ jõku ũkú ru la uzị agá ãtíꞌbó ru séndẽ sĩ, lẽ ꞌbá ꞌbá kí ụzịlépi ꞌdĩ ꞌbã áni rĩ úꞌdị ĩꞌdi rá, gẹ̃rị̃ ꞌdĩ áni rĩ sĩ, ĩmi dó sĩ ị́jọ́ ũnzí atrị ĩmi drĩdríŋĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","“ꞌBá ãrí ꞌbã nalé rá rĩ kí lẽ ꞌbã nga kí ị́jọ́ ãzị́táŋá ru ãtalo Lẹ́vị̃ rú ꞌdĩ ꞌbã kí fẽlé rĩ kî, lẽ ꞌbã ũbĩ kí ãzị́táŋá mání azịlé ꞌdĩ kí vú múké-múké. ");
INSERT INTO luc_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","Lẽ mí ũrã ị́jọ́ Úpí Ãdróŋá mídrị̂ ꞌbã ándrá idélé Míríyãmũ rụ́ gẹ̃rị̃ gá ꞌdãá sáwã míní ándrá ãfũjó Mị̃sị́rị̃ gâlé rĩ sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","“Ídrĩ jĩránĩ mídrị̂ ní ãko ãzí fẽ dẹ́nọ̃ rú, lẽ ífi ĩꞌdidrị́ jó agâlé ũkpó sĩ sĩ ãko ĩꞌdi ꞌbã ꞌbãlé gúrã rú rĩ aꞌdụ́lé mi ꞌi la ku. ");
INSERT INTO luc_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","Ítẽ ãmvé ꞌdãá ãzíla ífẽ ꞌba aꞌdụ́ ãko ꞌdã ajílé mí rụ́ ꞌdõlé nĩ. ");
INSERT INTO luc_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","ꞌBá ꞌdã drĩ adru lẽmẽrí yã áni, ímba ĩꞌdi ꞌbã bõngó ĩꞌdiní sĩ drị̃ ꞌbejó rĩ tã ị́nị́-ãrã ku. ");
INSERT INTO luc_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","Mí uja ĩꞌdi ꞌbã bõngô ĩꞌdidrị̂lé vúlé ꞌdĩ sĩ ị̃tụ́ ꞌde drĩ ku rú, ị́jọ́ ꞌdĩ sĩ ĩꞌdi dó sĩ ru drị̃ ꞌbe, ĩꞌdi dó sĩ míní sụ̃sụ́ wi, ãzíla ị́jọ́ ꞌdĩ la dó sĩ adru ị́jọ́ ãlá la Úpí Ãdróŋá mídrị̂ ꞌbã drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","“Mí ũnzã ꞌbá lẽmẽrí ãzíla ꞌbá ãzãkoma lẽlépi ãzị́ ngalépi mídrị́ séndẽ sĩ ꞌdĩ kí ku, drĩ táni adru ꞌbá mî ádrị́pịka Ịsịrayị́lị̃ rú la ꞌbã ãzí jõku ꞌbá ãmị́yọ́ŋá ru uꞌálépi táwụ̃nị̃ ĩmidrị́ ꞌdĩ kí ꞌbã ãzí ãlu la agá la. ");
INSERT INTO luc_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","Mí ũfẽ ĩꞌdi ꞌbã ũyá ĩꞌdi ꞌbã sĩ ãzị́ ngajó rĩ ịsụ́ ꞌdĩ sĩ ị̃tụ́ ꞌde drĩ ku rú, ãꞌdusĩku tị̃ ásị́ ũyá ꞌdã drị̃ gá. Ídrĩ ũfẽ la ku ĩꞌdi mụ awálé míní Úpí drị̃lẹ́ gá rá ãzíla ꞌdĩ la adru ími ụrụꞌbá gá ị́jọ́ ũnzí la. ");
INSERT INTO luc_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","“Úꞌdị átẹ́pị kí ãndrẽ be ị́jọ́ ũnzí anzị ꞌbadrị̂ sĩ ku, jõku úꞌdị anzị kí ị́jọ́ ũnzí átẹ́pị ꞌbadrị́ ãndrẽ be rĩ sĩ ku, be la rá la ꞌbá ãlu-ãlu ꞌbã drã ị́jọ́ ũnzí ĩꞌdidrị̂ ꞌbã tị gá. ");
INSERT INTO luc_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","“Mí ĩkpã ãmị́yọ́ŋá kí ĩmvú kí abe ĩꞌbã hákĩ drị̃ gá ku, ãzíla íꞌdụ ãwụ́zị́ ꞌbã bõngó sĩ drị̃ ꞌbejó la mọ̃rị́ tị gá ku. ");
INSERT INTO luc_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","Lẽ mí ũrã ị́jọ́ ándrá míní adrujó ãtíꞌbó ru Mị̃sị́rị̃ gá rĩ ãzíla Úpí Ãdróŋá mídrị̂ ꞌbã sĩ ími anzéjó ꞌdã ꞌi, ꞌdĩ ị́jọ́ mání sĩ míní ãzị́táŋá ꞌdĩ kí fẽjó ngajó ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","“Sáwã míní ãná lãjó ámvụ́ mídrị̂ agá rĩ sĩ, ími drị̃ drĩ ãvĩ sĩ ãná ãzí kí lãjó ku, ãná ãzí drĩ kí ace ími vúlé gâlé cí, ígõ kí lãlé ku. ꞌDã kí dó ãko ru aꞌbelépi ãmị́yọ́ŋá, ĩmvú ãzíla ãwụ́zị́ ꞌbaní rĩ kî, ị́jọ́ ꞌdĩ sĩ Úpí Ãdróŋá mídrị̂ la dó sĩ míní sụ̃sụ́ wi ãzị́ pírí míní ngalé rĩ kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","Sáwã míní mị̃zẹ̃yị́tụ̃ ífí ũtĩjó ámvụ́ mídrị̂ agá rĩ sĩ, ígõ álólóke ru acelépi rĩ kí ũtĩlé ị̃dị́ ku, ị́mbị́ la acelépi álólóke rú ꞌdã ꞌba ace kí dó ãmị́yọ́ŋá ꞌbaní ĩmvú kí abe ãzíla ãwụ́zị́ kí trũ. ");
INSERT INTO luc_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","Míní zãbíbũ ãka ũtĩ agá ámvụ́ mídrị̂ agá rĩ gá, ígõ álólóke ru acelépi rĩ kí ũtĩlé ị̃dị́ ku, ị́mbị́ la acelépi álólóke rú ꞌdã ꞌba ace kí dó ãmị́yọ́ŋá ꞌbaní, ĩmvú kí abe ãzíla ãwụ́zị́ kí trũ. ");
INSERT INTO luc_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","Lẽ mí ũrã ị́jọ́ ándrá míní adrujó ãtíꞌbó ru Mị̃sị́rị̃ gá rĩ. Ị́jọ́ ꞌdĩ bã sĩ mání sĩ míní ãzị́táŋá ꞌdĩ kí fẽjó ngajó ꞌdĩ.” ");
INSERT INTO luc_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","Mụ́sã jọ Ịsịrayị́lị̃ ní, “ꞌBá ị̃rị̃ drĩ kí ị́jọ́ ịsụ́ kí drĩdríŋĩ gá, ꞌbã agụ kí ị́jọ́ la amálé ꞌbá ꞌbá ị́jọ́ lịlẹ́pi rĩ ꞌbadrị́, ãzíla ꞌbá ꞌbá ị́jọ́ lịlẹ́pi rĩ drĩ kí ị́jọ́ ꞌdĩ amá ꞌbo, ꞌbã aꞌbe kí ꞌbá ị́jọ́ pịrị rĩ ngalépi rĩ rá ãzíla ꞌbã lị kí ị́jọ́ ꞌbá ị́jọ́ ũnzí idélépi rĩ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","Drĩ sĩ adru ágọ́bị́ ị́jọ́ idélépi ũnzí rĩ ị̃ndụ́ cojó, lẽ ꞌbá ꞌbá ị́jọ́ lịlẹ́pi rĩ ꞌbã fẽ kí ꞌbã la ru vũ gá ãzíla úco dó sĩ ị̃ndụ́ la ꞌbá ị́jọ́ lịlẹ́pi rĩ drị̃lẹ́ gá. Kãlãfe kẹ̃lị́ká drị́ sĩ ĩꞌdi ị̃ndụ́ cojó rĩ la adru ị́jọ́ ĩꞌdi ꞌbã izalé rĩ ꞌbã úmgbó sĩ. ");
INSERT INTO luc_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","Ícó drị̃ la gá kẹ̃lị́ká ꞌbã kãlãfe lịlẹ́ ũꞌbí ru rá, wó rá la ꞌbã alị kãlị́sụ ku ãꞌdusĩku, drĩ alị rá, ĩꞌdi drị̃nzá ají ꞌbá ị́jọ́ izalépi rĩ ní ũꞌbí kí drị̃lẹ́ gá rá. ");
INSERT INTO luc_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","“Mí úmbé jõ mọ́nị̃gọ́ ãná tulépi rĩ ꞌbã tị cí sĩ ĩꞌdi atrịjó ãná naŋá gá ku. ");
INSERT INTO luc_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","“ꞌBá ádrị́pị rú ị̃rị̃ la drĩ kí uꞌá ãngũ ãlu gá wó ãzí ãlu rĩ drĩ drã rá drĩ ngọ́tị́ŋá aꞌbe ku, ꞌbá ãzí lị́cọ́ ndú gá la ꞌbã fi ũkú ĩꞌdi ꞌbã aꞌbelé rĩ nĩ ku; ĩꞌdi ãzị́ ágọ́bị́ drãlépi rá rĩ ꞌbã ádrị́pị̃ ãni sĩ ãwụ́zị́ ꞌdĩ fijó sĩ anzị tịjó ádrị́pị̃ drãlépi rá rĩ nî. ");
INSERT INTO luc_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","Ngọ́tị́ ágọ́bị́ ĩꞌbã kí tịlé drị̃drị̃ rĩ ála ĩꞌdi lã ꞌbá drãlépi rá rĩ ꞌbã ngọ́tị́ ru, ị́jọ́ ꞌdĩ sĩ, lị́cọ́ ĩꞌdidrị̂ ꞌbã anụ́ rú dó sĩ sụ́rụ́ Ịsịrayị́lị̃ drị̂ agá ꞌdâ ku be nĩ. ");
INSERT INTO luc_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","“Wó ágọ́bị́ drãlépi rá rĩ ꞌbã ádrị́pị drĩ gã ũkú ãwụ́zị́ ru ꞌdã filé úmgbé, ãwụ́zị̂ ꞌbã mụ ꞌbá ĩyõ táwụ̃nị̃ tị gá rĩ ꞌba rụ́ ãzíla ꞌbã jọ ĩꞌbaní, ‘Mâ únere gã áma filé sĩ anzị tịjó sĩ ĩꞌdi ꞌbã ádrị́pị̃ drãlépi rá rĩ rụ́ ajíjó Ịsịrayị́lị̃ gá ꞌdâ úmgbé.’ ");
INSERT INTO luc_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","ꞌDã ꞌbã ũngúkú gá, ꞌbá ĩyõ táwụ̃nị̃ tị gá rĩ ꞌbã umve kí ágọ́bị́ drãlépi rá ꞌdã ꞌbã ádrị́pị̃ ꞌi sĩ ị́jọ́ jọjó ĩꞌdi be. Drĩ gã kpere ãwụ́zị́ ꞌdã filé úmgbé, ");
INSERT INTO luc_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","ãwụ́zị́ ádrị́pị̃ ꞌbã aꞌbelé rĩ ꞌbã mụ ĩꞌdi rụ́ ꞌbá ĩyõ táwụ̃nị̃ tị gá rĩ kí drị̃ gâsĩ, ꞌbã ãtrũ ŋĩlâ únẽrê ꞌbã pá ãlu rĩ gá rĩ rá, ꞌbã wi sụ̃sụ́ ĩꞌdi mẹ́lẹ́tị gá ãzíla ꞌbã jọ, ‘ꞌDĩ ị́jọ́ ngalé ꞌbá gãlépi ádrị́pị̃ drãlépi rá rĩ ní anzị tịjó úmgbé sĩ ĩꞌdi ꞌbã rụ́ ajíjó rĩ ụrụꞌbá gá rĩ ꞌi.’ ");
INSERT INTO luc_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","Ála mụ lị́cọ́ ĩꞌdidrị̂ nị̃lé Ịsịrayị́lị̃ gá ꞌdâ lị́cọ́ sĩ ágọ́bị́ ala gá rĩ ꞌbã pá gá ŋĩlâ trũjó rá rĩ rú. ");
INSERT INTO luc_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","“Ãgọbị ị̃rị̃ drĩ kí rũ co ãzíla ũkú ágọ́bị́ ãlu rĩ drị̂ drĩ amụ́ ĩꞌdi ꞌbã ágô apálé ágọ́bị́ ĩꞌbã kí rũ cojó rĩ drị́ gá drĩ ágọ́bị́ ãzí ꞌdã rụ́ pálé gá ũkpó sĩ, ");
INSERT INTO luc_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","ĩꞌbã ásị́ ị̃gbẹ̃ ũkú ꞌdã drị̃ gá ku, ĩlị drị́ la rá. ");
INSERT INTO luc_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","“Lẽ mí adru ãko sĩ ãko kí ãnzị ụ̃ꞌbị̃jó rĩ kî trũ mídrị́ bẹ́gị̃ agá ị̃rị̃ ãzí rĩ la adru ãnzị rú ãzí rĩ ĩpé ru la ku. ");
INSERT INTO luc_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","Lẽ mí adru ãko sĩ ãko kí ãnzị ụ̃ꞌbị̃jó rĩ kí abe ị̃rị̃ mídrị́ jó agá, ãzí rĩ la adru mgbọrú ãzí rĩ la dó sĩ adru ĩmbíráŋá ru íni la ku. ");
INSERT INTO luc_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","Mí ayú ãko sĩ ãko ụ̃ꞌbị̃jó múké ꞌbá najó ku íni rĩ, ị́jọ́ ꞌdĩ sĩ mi dó sĩ uꞌá ílí ãzo rú ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","Úpí Ãdróŋá mídrị̂ ngụ̃ ꞌbá ꞌbá kí ũnzãlépi rĩ ũnzí. ");
INSERT INTO luc_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","“Ĩmi ũrã drĩ ị́jọ́ ꞌbá Ãmãlẹ́kị̃ rú rĩ ꞌbã kí idélé ĩmi rụ́ gẹ̃rị̃ gá ꞌdãá sáwã ĩmĩ ãgõjó Mị̃sị́rị̃ gâlé rĩ sĩ rĩ. ");
INSERT INTO luc_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","Idé kí ándrá ụ̃rị̃ Ãdróŋâ sĩ ku ị́jọ́ ꞌdĩ sĩ, ụꞌdị́ kí ándrá ꞌbá ãndẽlépi rá amụ́lépi jãjã rú vúlêlé rĩ kí pírí rá. ");
INSERT INTO luc_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","Ị́jọ́ ꞌdĩ sĩ, Úpí Ãdróŋá mídrị̂ drĩ míní ãngũ fẽ ãzíla drĩ fẽ la ãngũ ꞌba adru ị̃gbẹ́ ru mẹ́rọ́ꞌbá mídrị́ ími andre gá rĩ kí drị́ gá rĩ sĩ ꞌbo, lẽ mí ụꞌdị́ ꞌbá Ãmãlẹ́kị̃ rú ꞌdĩ kí ụ̃nọ́kụ́ drị̃ gá ꞌdâ pírí rá, ị́jọ́ ꞌdĩ sĩ ꞌbá ãzí agá dó sĩ ị́jọ́ kí drị̃ gá ị̃dị́ ku be nĩ. Mí ãvĩ jõ ị́jọ́ ꞌdĩ ku! ");
INSERT INTO luc_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","“Ídrĩ ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ ꞌdụ mî ãko rú sĩ rijó ala gá ꞌbo, ");
INSERT INTO luc_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","lẽ mí ají ãkónã ãfũlépi drị̃drị̃ míní atrálé ámvụ́ agâlé ãkónã ãlu-ãlu míní salé rĩ ꞌbadrị̂ kí pírí gụ́fá sĩ. Ímụ kî trũ ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã pẽlé sĩ ĩꞌdi rụ́ ị̃nzị̃jó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","Ímụ átáló drị̃lẹ́ ru sáwã ꞌdã sĩ rĩ rụ́ ãzíla íjọ ĩꞌdiní, ‘Má ají fẽtáŋá ꞌdĩ ãndrũ Úpí Ãdróŋá mídrị̂ ní sĩ iꞌdajó má afí dó ãngũ ándrá ĩꞌdi ꞌbã ũyõ la najó ãmã áyị́pịka ꞌbaní ꞌi fẽ la ãmaní rĩ gá ꞌbo.’ ");
INSERT INTO luc_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","Átáló la dó gụ́fâ ꞌdụ ími drị́ gá rĩ sĩ ãzíla ĩꞌdi dó ĩꞌdi ꞌbã ãlĩtárĩ Úpí Ãdróŋá mídrị̂ drị̂ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","“ꞌDã ꞌbã ũngúkú gá, mi dó ị́jọ́ ꞌdĩ jọ Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá: ‘Mâ áyị́pị ꞌi ándrá ꞌbá Ãrãménĩyã rú ãngũ pilépi la, ꞌdụ ꞌbá ĩꞌdidrị́ lị́cọ́ gá rĩ kí trũ mụjó Mị̃sị́rị̃ gá. Sáwã ĩꞌbã kí mụjó Mị̃sị́rị̃ gá rĩ sĩ kí kãlãfe ándrá were rú, wó acá kí dó sụ́rụ́ ãmbógó ãzíla ũkpó la rú. ");
INSERT INTO luc_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","Wó ꞌbá Mị̃sị́rị̃ rú rĩ fẽ kí ãmaní ũcõgõ ãzíla ꞌbã kí ãma ãzị́ ngalé ãtíꞌbó ru. ");
INSERT INTO luc_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","ꞌDã ꞌbã ũngúkú gá, ãma awá Úpí Ãdróŋá ãmã áyị́pịka ꞌbadrị̂ rụ́. Are áwáŋá ãmadrị̂ rá ãzíla ndre drị̃cịŋá, ũcõgõ, ãzíla ĩkpãŋá sĩ ãma ĩkpãjó rĩ rá. ");
INSERT INTO luc_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","Ị́jọ́ ꞌdĩ sĩ Úpí fẽ ꞌbá Mị̃sị́rị̃ gá rĩ kí acálé ụ̃rị̃ ãmbógó la sĩ tálí ĩꞌdidrị́ ũkpó rĩ kí sĩ, ãzíla Mị̃sị́rị̃ gâlé rĩ sĩ, anzé dó sĩ ãma drị́ ũkpó ĩꞌdidrị̂ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","Ají ãma ꞌdâ ãzíla fẽ ãmaní ãngũ málĩ trũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ ãnụ́ ꞌbã sĩ rajó lé be ꞌdĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","Ị́jọ́ ꞌdĩ sĩ, má ajị́ dó úꞌdîꞌda Úpí ní ãkónã drị̃drị̃ ãfũlépi ĩꞌdi ꞌbã fẽlé mání rĩ ꞌi.’ ꞌDã ꞌbã ũngúkú gá, íꞌbã dó gụ́fâ ꞌi Úpí Ãdróŋá mídrị̂ bã drị̃lẹ́ gá ãzíla ísu dó drị̃ vũ gá sĩ ĩꞌdi ị̃nzị̃jó. ");
INSERT INTO luc_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","Ífẽ Úpí Ãdróŋá mídrị̂ ní ãwãdĩfô ãko ũniyambamba rú ĩꞌdi ꞌbã fẽlé míní ãzíla lị́cọ́ mídrị̂ ní rĩ kí sĩ; ꞌbá Lẹ́vị̃ rú ãzíla ꞌbá ãmị́yọ́ŋá ru uꞌálépi ĩmi drĩdríŋĩ gá rĩ ꞌbã amụ́ kí ãyĩkõ idélé ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","“Ílí na ãlu-ãlu sĩ, lẽ ífẽ ãlu mụdrị́ ãkónã mídrị́ ãfũlépi rĩ drị̂ kí ꞌbá Lẹ́vị̃ rú, ꞌbá ãmị́yọ́ŋá ru, ꞌbá ĩmvú ru ãzíla ꞌbá ãwụ́zị́ ru rĩ ꞌbaní, ị́jọ́ ꞌdĩ sĩ táwụ̃nị̃ cí ĩꞌbã kí adrujó rĩ gá, kí dó sĩ ãko cí ĩꞌbã kí lẽlé nalé rĩ ịsụ́ rá. ꞌDã ꞌbã ũngúkú gá, ");
INSERT INTO luc_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","íjọ dó, Úpí Ãdróŋá mídrị̂ ní, ‘Áfẽ dó úꞌdîꞌda ãlu mụdrị́ drị́ mádrị́ ãlápítí rĩ ꞌbá Lẹ́vị̃ rú, ãmị́yọ́ŋá ru, ĩmvú ru ãzíla ãwụ́zị́ ru rĩ ꞌbaní cécé míní azịlé mání rĩ áni. Má ãvĩ ị́jọ́ kí ãzí ãlu la drị̃ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","Ána ị́mbị́ la ãlá rĩ sáwã mání ꞌbá mádrị́ drãlépi rá rĩ awájó rĩ sĩ ku; áꞌdụ wókõ la ãzí sáwã mání adrujó ãndị́ ru rĩ sĩ ku ãzíla áfẽ wókõ la ãzí ídétáŋá ru ꞌbá drãlépi rá rĩ ní ku. Áfẽ ãrútáŋá Úpí Ãdróŋá mádrị̂ ní rá; ánga ị́jọ́ pírí míní azịlé mání rĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","Mí andré drĩ ãngũ angájó ꞌbụ̃ gá, ãngũ míní uꞌájó ãlápítí ꞌdã gâlé, ãzíla íwi sụ̃sụ́ ꞌbá mídrị́ Ịsịrayị́lị̃ rú rĩ ꞌbaní ãzíla ãngũ míní fẽlé ãma ní rĩ drị̃ gá cécé míní ándrá ũyõ la najó ãmã áyị́pịka ꞌbaní rĩ áni, ãngũ málĩ trũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ lé ꞌbã sĩ rajó ala gá ãnụ́ úsã be rĩ gá.’ ");
INSERT INTO luc_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","“Ụ́ꞌdụ́ ãndrũ ꞌdĩ sĩ, Úpí Ãdróŋá mídrị̂ azị míní sĩ ãzị́táŋá ĩꞌdidrị̂ kí tã mbajó pírí; ị́jọ́ ꞌdĩ sĩ ímba dó sĩ kí tã ími ásị́ pírí sĩ ãzíla ími ídri pírí sĩ. ");
INSERT INTO luc_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","Ãndrũ ĩmi ãꞌị̃ dó Úpí ꞌi Ãdróŋá ĩmidrị̂ rú ꞌbo; ĩna vâ ũyõ sĩ jọjó la ĩmi mụ ĩꞌdi ị̃nzị̃lé rĩ gá rá, sĩ ãzị́táŋá ĩꞌdidrị̂ kí tã mbajó pírí, ãzíla ãzị́táŋá pírí ĩꞌdi ꞌbã fẽlé rĩ kí ngajó. ");
INSERT INTO luc_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","Ãndrũ Úpí lã dó mi ĩꞌdi ꞌbã ꞌbá ụ̃rọ̃drị́ ru la rú ꞌbo cécé ándrá ĩꞌdi ꞌbã azịlé míní rĩ áni; ãzíla fẽ míní ãzị́táŋá sĩ ãzị́táŋá ĩꞌdidrị̂ kí tãmbajó pírí. ");
INSERT INTO luc_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","Ĩꞌdi ími ꞌbã ãmbógó ru sụ́rụ́ ãzí ĩꞌdi ꞌbã ũꞌbãlé ꞌdĩ ꞌbaní ãndânĩ, ãzíla mi dó rụ́ kụma ají ị̃nzị̃táŋá be ĩꞌdiní. Mi dó sĩ adru ꞌbá Úpí Ãdróŋá mídrị̂ ãni ãlá rĩ rú cécé ĩꞌdi ꞌbã azịlé rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","Mụ́sã kí ꞌbá ĩyõ Ịsịrayị́lị̃ drị̂ kí abe jọ kí ꞌbá ꞌbaní, “Ĩmba ãzị́táŋá mání fẽlé ĩminí ãndrũ ꞌdĩ kí tã pírí. ");
INSERT INTO luc_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","Ụ́ꞌdụ́ míní Mĩrĩ Yõrĩdánĩ zajó ãzíla fijó ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ agá rĩ sĩ, mí ịꞌdị írã ꞌbara la kí ãzíla mí ase kí ụrụꞌbá cí. ");
INSERT INTO luc_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","Írã ꞌdĩ kí ụrụꞌbá gá mí ũsĩ ãzị́táŋá ãzíla ímbátáŋá ꞌdĩ kí pírí. Sáwã míní fijó ãngũ málĩ trũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ lé ꞌbã sĩ rajó ala gá ãnụ́ be Úpí Ãdróŋá mí áyị́pịka ꞌbadrị̂ ꞌbã azịlé míní rĩ áni rĩ gá, ");
INSERT INTO luc_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","ídrĩ Ị̃yị́ Yõrĩdánĩ za ꞌbo, mí ịꞌdị írã ꞌdĩ kí ꞌBé Ĩbálĩ drị̃ gá, cécé mání ãndrũ azịlé míní ꞌdĩ áni ãzíla mí ase írã ꞌdĩ kí ụrụꞌbá cí. ");
INSERT INTO luc_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","ꞌDãá ísị ãlĩtárĩ Úpí Ãdróŋá mídrị̂ ní írã upalé aya sĩ ku rĩ kí sĩ, ");
INSERT INTO luc_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","ãlĩtárĩ míní sịlé Úpí Ãdróŋá mídrị̂ ní rĩ lẽ ꞌba adru írã upalé ku rĩ sĩ. Ãlĩtárĩ míní sịlé rĩ gá ꞌdãá mi dó sĩ mání ídétáŋá ivélé ivê rĩ kí ivé, ");
INSERT INTO luc_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","ãzíla mí idé ídétáŋá ásị́ ị̃gbẹ̃ drị̂ ꞌdãá, ína ĩꞌdi ꞌbá kí abe ãzíla mí adru ãyĩkõ ãmbógó la sĩ Úpí Ãdróŋá mídrị̂ drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","Ísĩ ị́jọ́ ãzị́táŋá ꞌdĩ drị̂ kí pírí tọndọlọ írã míní mụlé sịlé rĩ kí drị̃ gá múké-múké ꞌbá ꞌbã lã kí rû sĩ kí ị́jọ́ ãzí kóru benĩ.” ");
INSERT INTO luc_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","ꞌDã ꞌbã ũngúkú gá, Mụ́sã kí ãtalo Lẹ́vị̃ rú rĩ kí abe jọ kí Ịsịrayị́lị̃, “Mí are drĩ ãma! Ãndrũ mí acá ꞌbá Úpí Ãdróŋá mídrị̂ ãni la rú ꞌbo; ");
INSERT INTO luc_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","ị́jọ́ ꞌdĩ sĩ mí are Úpí Ãdróŋá mídrị̂ tị ãzíla ímba ãzị́táŋá ĩꞌdidrị́ mání mụlé fẽlé míní ãndrũ ꞌdĩ kí tã pírí.” ");
INSERT INTO luc_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","Ụ́ꞌdụ́ ꞌdã ꞌbã vúŋá sĩ Mụ́sã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbanî, ");
INSERT INTO luc_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","“Ĩdrĩ Ị̃yị́ Yõrĩdánĩ za ꞌbo, ínátị Sị̃mọ́nị̃ drị́, Lẹ́vị̃ drị́, Yụ́dã drị́, Ĩsãkárĩ drị́, Yụ̃sụ́fụ̃ drị́ ãzíla Bénzãmĩnĩ drị̂ ꞌbã tu kí pá ꞌBé Gẹ̃rị̃zị́mụ̃ drị̃ gá sĩ sụ̃sụ́ ãlá rĩ wijó ꞌbá kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","Ínátị Rụ́bẹ̃nị̃ drị́, Gádĩ drị́, Ásẹ̃rị̃ drị́, Zãbụ̃lọ́nị̃ drị́, Dánĩ drị́ ãzíla Nãfũtálĩ drị̂ ꞌbã tu kí pá ꞌBé Ĩbálĩ drị̂ drị̃ gá sĩ áwãtáŋá wãjó. ");
INSERT INTO luc_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","“ꞌBá Lẹ́vị̃ rú rĩ kí ị́jọ́ ꞌdĩ kí jọ ụ́ꞌdụ́kọ́ ụrụgá sĩ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní pírí: ");
INSERT INTO luc_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","“‘ꞌBá ãlị́gọ́ ru íꞌdá ị̃nzị̃lé ị̃nzị̃-ị̃nzị̃ rĩ idélépi írã sĩ, báwũ sĩ jõku aya sĩ ãzíla íꞌdá ĩꞌdi ꞌbã idélé ĩꞌdidrị́ sĩ rĩ ị̃nzị̃lépi ũní-ũní ru rĩ Ãdróŋá la ĩꞌdi wã rá; Úpí ngụ̃ íꞌdá ị̃nzị̃jó ĩꞌdi kẹ̃jị́ gá rĩ ũnzí.’ ꞌBá pírí ꞌbã jọ kí ‘Ámĩnã!’ ");
INSERT INTO luc_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","“‘ꞌBá átẹ́pị̃ kí tị arelépi ãndrẽ be ku rĩ Ãdróŋá la ĩꞌdi wã rá.’ ꞌBá pírí ꞌbã jọ kí ‘Ámĩnã!’ ");
INSERT INTO luc_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","“‘ꞌBá ĩꞌdi ꞌbã jĩránĩ ꞌbã írã lõkókõrí iꞌdalépi rĩ nzelépi rá rĩ Ãdróŋá la ĩꞌdi wã rá.’ ꞌBá pírí ꞌbã jọ kí ‘Ámĩnã!’ ");
INSERT INTO luc_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","“‘ꞌBá ꞌbá mịfị́ kóru rĩ drị̃ ꞌdelépi gẹ̃rị̃ ndú gâsĩ rĩ Ãdróŋá la ĩꞌdi wã rá.’ ꞌBá pírí ꞌbã jọ kí ‘Ámĩnã!’ ");
INSERT INTO luc_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","“‘ꞌBá ãmị́yọ́ŋá, ĩmvú ãzíla ãwụ́zị́ kí ị́jọ́ lịlẹ́pi pịrị ku rĩ Ãdróŋá la ĩꞌdi wã rá.’ ꞌBá pírí ꞌbã jọ kí ‘Ámĩnã!’ ");
INSERT INTO luc_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","“‘ꞌBá drị̃nzá fẽlépi átẹ́pị̃ ní ĩꞌdi ꞌbã rũ lajó ụ́kụ́pị̃ sĩ rĩ Ãdróŋá la ĩꞌdi wã rá.’ ꞌBá pírí ꞌbã jọ kí ‘Ámĩnã!’ ");
INSERT INTO luc_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","“‘ꞌBá ru lalépi ãnãkpá sĩ rĩ Ãdróŋá la ĩꞌdi wã rá.’ ꞌBá pírí ꞌbã jọ kí ‘Ámĩnã!’ ");
INSERT INTO luc_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","“‘ꞌBá ru lalépi ámvọ́pị̃ sĩ rĩ Ãdróŋá la ĩꞌdi wã rá.’ ꞌBá pírí ꞌbã jọ kí ‘Ámĩnã!’ ");
INSERT INTO luc_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","“‘ꞌBá ru lalépi ĩdrâ sĩ rĩ Ãdróŋá la ĩꞌdi wã rá.’ ꞌBá pírí ꞌbã jọ kí ‘Ámĩnã!’ ");
INSERT INTO luc_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","“‘ꞌBá ĩꞌdi ꞌbã jĩránĩ ꞌdịlépi ũní rĩ Ãdróŋá la ĩꞌdi wã rá.’ ꞌBá pírí jọ kí ‘Ámĩnã!’ ");
INSERT INTO luc_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","“‘ꞌBá séndẽ sĩ ꞌbá mịfị́ sajó rĩ ꞌdụlépi sĩ ꞌbá ị́jọ́ kóru rĩ ꞌdịjó rá rĩ Ãdróŋá la ĩꞌdi wã rá.’ ꞌBá pírí ꞌbã jọ kí ‘Ámĩnã!’ ");
INSERT INTO luc_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","“‘ꞌBá Ãdróŋá tị arelépi ku ãzị́táŋá ãzíla ímbátáŋá ĩꞌdidrị̂ kí tã mbalépi ku rĩ Ãdróŋá la ĩꞌdi wã rá.’ ꞌBá pírí ꞌbã jọ kí ‘Ámĩnã!’” ");
INSERT INTO luc_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Ídrĩ Úpí Ãdróŋá mídrị̂ tị are ãꞌị̃táŋá sĩ ãzíla ãzị́táŋá ĩꞌdidrị́ mání fẽlé míní ãndrũ ꞌdĩ kí tã mba rá, Úpí Ãdróŋá mídrị̂ la ími ꞌbã adrulé sụ́rụ́ ãzí ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ ꞌbaní pírí ãmbógó ru ãndânĩ. ");
INSERT INTO luc_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","Mí are Úpí Ãdróŋá mídrị̂ ꞌbã tị, ĩꞌdi dó sĩ míní sụ̃sụ́ wi ãzíla ãko ꞌdĩ kí dó sĩ acá mí ãni la rú: ");
INSERT INTO luc_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","“Úpí mídrị̂ la sụ̃sụ́ wi míní táwụ̃nị̃ ĩmidrị̂ kí drị̃ gá ámvụ́ ĩmidrị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","“Úpí la ĩminí sụ̃sụ́ wi sĩ anzị kí tịjó ũꞌbí ru, ĩꞌdi ĩminí ãkónã kí fẽ kalé ĩyõ rú, ĩꞌdi tị́ ãzíla kãbĩlõ ĩmidrị̂ ꞌbaní fẽ kpẹ̃lé wẽwẽ rú. ");
INSERT INTO luc_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","“Úpí la ĩminí sụ̃sụ́ wi ãzíla ãkónã ĩminí nalé rĩ kí adru ĩyõ rú ĩminí calépi rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","“Mi adru drị̃lẹ́ba rú míní afí agá ãzíla mi adru drị̃lẹ́ba rú míní fũ agá. ");
INSERT INTO luc_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","“Úpí la fẽ mi mẹ́rọ́ꞌbá amụ́lépi mí rụ́ ãꞌdị́ gá rĩ kí ndẽ rá. Mẹ́rọ́ꞌbá kí amụ́ mí rụ́ ãꞌdị́ gá gẹ̃rị̃ ãlu gâsĩ, wó kí apá mídrị́ gẹ̃rị̃ ndú-ndú gâsĩ. ");
INSERT INTO luc_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","“Úpí Ãdróŋá mídrị̂ la míní sụ̃sụ́ wi ãngũ ĩꞌdi ꞌbã fẽlé míní rĩ gá ãzíla ãkónã kí sĩ ka múké. Jó jõku ĩrá míní ãkónã ꞌbãjó rĩ kí ga ãkónã sĩ tré-tré sụ̃sụ́ ĩꞌdi ꞌbã wilé rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","“Ídrĩ Úpí Ãdróŋá mídrị̂ tị are ãzíla ãzị́táŋá ĩꞌdidrị̂ kí tã mba rá, ĩꞌdi ími ꞌbã adrujó ꞌbá ĩꞌdi ãni ãlá rĩ rú cécé ĩꞌdi ꞌbã ándrá ũyõ la najó rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","ꞌDã ꞌbã ũngúkú gá, ꞌbá pírí ụ̃nọ́kụ́ gá ꞌdâ rĩ kí dó sĩ ndre la rá Úpí pẽ mi ĩꞌdi ꞌbã ꞌbá ru ãzíla kí dó acá ụ̃rị̃ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","Úpí la míní anzị kí fẽ wẽwẽ rú, tị́ kí fẽ tịlé ũꞌbí ru ãzíla ãkónã fẽ kpẽté-kpẽté ãngũ ándrá ĩꞌdi ꞌbã ũyõ najó mî áyị́pịka ꞌbaní ꞌi mụ fẽlé la míní rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","Úpí la míní uzogó ꞌbụ̃ gá rĩ tị nzị̃ ꞌdịlé áyi múké rĩ gá ãzíla ĩꞌdi ásị́ ị̃gbẹ̃ ꞌbã ãzị́ pírí míní ngalé rĩ kí drị̃ gá. Mi mọ̃rị́ fẽ sụ́rụ́ ũꞌbí ꞌbaní, wó mí icó mọ̃rị́ aꞌị́lé sụ́rụ́ ãzí drị́ ku. ");
INSERT INTO luc_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","Úpí Ãdróŋá mídrị̂ la ími ꞌbã sụ́rụ́ kí agá ꞌdâ adrulé drị̃lẹ́ gá ị́jọ́ pírí kî sĩ, mí icó adrulé ꞌbá kí vúlé gá ku. Mi ꞌbé adru ãko trũ ãzíla ị́jọ́ ãzí icó ími ndẽlé ku ídrĩ ãzị́táŋá mání fẽlé míní ãndrũ ꞌdĩ kí vú ũbĩ ásị́ pírí sĩ rá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","Wó lẽ ígã jõ ãzị́táŋá mání mụlé fẽlé míní ãndrũ ꞌdĩ kí ꞌbã ãzí ãlu la gẹ̃rị̃ ãzí sĩ jõku míní ị̃nzị̃táŋá fẽjó ãzíla ãzị́ ngajó ãdroŋa ãzí ꞌdĩ ꞌba ní rĩ sĩ ku.” ");
INSERT INTO luc_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","Mụ́sã jọ Ịsịrayị́lị̃ ní, “Ídrĩ Úpí Ãdróŋá mídrị̂ tị gã úmgbé ãzíla ídrĩ ãzị́táŋá mání fẽlé míní ãndrũ ꞌdĩ kí ãꞌị̃ ku, áwãtáŋá ndú-ndú ꞌdĩ kí pírí ími rụ rá: ");
INSERT INTO luc_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","“Úpí la ãngũ míní ãzị́ ngajó táwụ̃nị̃ rú ãzíla ámvụ́ ru rĩ kí wã pírí rá, málĩ icó kí míní ãfũlé kí agá ku. ");
INSERT INTO luc_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","“Úpí la ími wã rá, ãná ãzíla ãkónã míní nalé rĩ icó kí adrulé míní calépi rĩ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","“Úpí la anzị mídrị̂ kí wã ãkónã kí trũ rá. Ĩꞌdi Ãnãkpá tị́ ru ãzíla kãbĩlõ rú ꞌdĩ kí wã rá. ");
INSERT INTO luc_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","“Ĩꞌdi ími wã míní afí agá ãzíla míní fũ agá. ");
INSERT INTO luc_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","“Ĩdrĩ ị́jọ́ ũnzí kí nga ãzíla Úpí gã úmgbé, ĩꞌdi áwãtáŋá, ũcõgõ ãzíla drị̃nama ají ãzị́ pírí ĩminí ngalé ĩmi drị́ sĩ rĩ kí agá kpere ĩminí ị̃lị̃kị̃ agá pírí gbõŋáŋá ru. ");
INSERT INTO luc_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","Úpí la ĩyéngã tị ãpẽ ĩyéngã vúlé gá ĩmi rụlé ị̃ndụ́ ceŋá kóru kpere ĩꞌdi ꞌbã ĩmi ị̃lị̃kị̃ agá pírí ãngũ ĩminí mụlé ꞌdụlé ĩminí la rú rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","Úpí la ĩmi co ĩyéngã sĩ, ĩmi ụrụꞌbá kí ãvõ-ãvõ ãzíla ĩmi ụrụꞌbá la ko tị̃rị̃-tị̃rị̃. Ĩꞌdi ị̃tụ́kã ãzíla ãlụ́kụ́kụ̃ ãcíꞌbíríto rĩ kí tị ãpẽ ãkónã ĩmidrị̂ kí izalé. Ãko ꞌdĩ kí ru idé ĩmi abe íni kpere ĩminí ũdrã agá pírí. ");
INSERT INTO luc_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","ꞌBụ̃ ĩmi drị̃ gá rĩ la adru cécé bũrônzĩ áni ãzíla vũ ĩmidrị̂ la umba ũkpómgboroto rú aya áni. ");
INSERT INTO luc_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","Uzogó kẹ̃jị́ gá Úpí la ĩminí pụ́trụ́ ãzíla cínákí fẽ ꞌdịlé angájó ꞌbụ̃ agâlé kpere ĩminí ị̃lị̃kị̃ agá. ");
INSERT INTO luc_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","“Úpí la fẽ mẹ́rọ́ꞌbá ĩmidrị́ amụ́lépi ĩmi rụ́ ãꞌdị́ gá rĩ kí ĩmi ndẽ rá. Ĩmi mẹ́rọ́ꞌbá kí gbẹ gẹ̃rị̃ ãlu rĩ gâsĩ, wó ĩmi apá ĩꞌbadrị́ gẹ̃rị̃ ndú-ndú gâsĩ, ãzíla ꞌbá pírí ụ̃nọ́kụ́ drị̃ gá ꞌdâ ị́jọ́ ꞌdĩ kí ndrelépi rá rĩ kí ụ̃rị̃ ãmbógó la kí rụ ị́jọ́ ru ngalépi ĩmi ụrụꞌbá gá ꞌdĩ kî sĩ. ");
INSERT INTO luc_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","Ĩdrĩ ũdrã ꞌbo, núgúnúke ꞌbụ̃ gá rĩ kí ụ̃bọ̃gụ̃ abe kí amụ́ ĩmi ĩzá ucelé nĩ ãzíla ꞌbá ãzí amụ́lépi núgúnúke kí adrolépi ĩmĩ ãvũ drị̃ gá ꞌdãá rá la kí adru ꞌdá yụ. ");
INSERT INTO luc_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","Úpí la kụ̃rụ́tẹ́ tị ãpẽ ĩmi ụrụꞌbá gá ándrá ĩꞌdi ꞌbã idélé ꞌbá Mị̃sị́rị̃ rú rĩ kí ụrụꞌbá gá rĩ áni. Ĩꞌdi fẽ ĩmi ụrụꞌbá la ụ̃kpẹ̃ ãkõzá ru. Ĩmi ụrụꞌbá la ura ị̃vị̃ rú ãzíla ĩmi ĩmi ũvĩ ãrí trũ wó jụ́wẹ̃ ꞌdĩ icó walé ku. ");
INSERT INTO luc_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","Úpí la fẽ la aza la fi ĩmi drị̃ gá cí, ĩꞌdi ĩmi mịfị́ kí ãzụ̃ cí ãzíla ĩmi drị̃ la ru iza kpékpé. ");
INSERT INTO luc_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","Drĩ táni adru ị̃tụ́ sĩ mi mụ ãngũ ụmvị́ trũ ꞌbá mịfị́ kóru rĩ áni ãzíla mí icó gẹ̃rị̃ tá míní lẽjó mụjó rĩ ịsụ́lé ku. Ĩmi icó drị̃lẹ́ba málĩ drị̂ ịsụ́lé ãzị́ pírí ĩminí ngalé rĩ kí agá ku. Ála ĩmi ĩkpã ãsị̃ŋá kóru, ãko ĩmidrị̂ kí ála kí ra rá ãzíla ꞌbá ãzí ãlu icólépi ĩmi ãzã kolépi rá la la adru ꞌdá yụ. ");
INSERT INTO luc_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","“Mi tátí dó lẽ ĩzóŋá ãzí ꞌdụlé míní ũkú ru rá wó ꞌbá ãzí ndú la la uja ĩꞌdi ꞌdụlé ĩꞌdiní ũkú ru nĩ. Mi jó sị rá wó mí icó uꞌálé ala gá ku. Mi ámvụ́ zãbíbũ drị̂ agá zãbíbũ kí sa rá wó mí icó ãka la kí nalé ãluŋá la ku. ");
INSERT INTO luc_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","Tị́ ĩmidrị̂ kí ála kí ụlị́ ĩmi drị̃ gâsĩ wó ĩmi icó kí ãzí ãlu la ꞌbã ĩzá nalé ku. Kãyĩnõ ĩmidrị̂ kí ála kí ꞌdụ ĩmi dị̃ kí ndre sĩ ãzíla ícó kí umvilé ĩmidrị́ vúlé ku. Kãbĩlõ ĩmidrị̂ kí ála kí fẽ mẹ́rọ́ꞌbá ꞌbaní ãzíla ꞌbá ãzí icólépi ĩmi ãzã kolépi rá la kí adru yụ ");
INSERT INTO luc_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","Anzị ãgọbị ĩmidrị̂ kí izonzi ĩmidrị̂ kí abe ála kí fẽ ãtíꞌbó ru sụ́rụ́ ãzí gá ĩmi dị̃ kí ndre sĩ. Ụ́ꞌdụ́ pírí ĩmi mịfị́ la adru gẹ̃rị̃ gá ĩꞌbã ãgõŋá drị̃ tẽjó ĩmi ĩꞌbã ãgõŋá ũtẽ tí. ");
INSERT INTO luc_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","Sụ́rụ́ ãzí ĩminí nị̃lé ku la kí amụ́ ãzíla kí ãkónã ĩminí ãzị́ la kí ngajó ũkpó sĩ sĩ kí sajó rĩ kí palé rá, kí ĩmi ĩkpã ásị́ ũnzí sĩ ãzíla kí ĩmi rụ drị́ ũkpó sĩ. ");
INSERT INTO luc_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","Ị́jọ́ ĩminí ũcõgõ ndrejó ĩmi mịfị́ sĩ ꞌdĩ la fẽ ĩminí azalé rá. ");
INSERT INTO luc_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","Úpí la kụ̃rụ́tẹ́ tị ãpẽ ĩmi ụrụꞌbá gá. Ĩꞌdi fẽ ĩmi ụrụꞌbá la ụ̃kpẹ̃ ãkõzá ru iꞌdójó ĩmi pá alé gá kpere drị̃kã gá wó jụ́wẹ̃ ꞌdĩ icó walé ku. ");
INSERT INTO luc_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","“Úpí la ĩmi dro ũpi ĩmidrị́ ĩminí ũꞌbãlé rĩ kí abe sụ́rụ́ ĩminí nị̃lé ĩmi áyị́pịka kí abe ku rĩ kí agá ĩmi dó sĩ acá ãtíꞌbó ru. Ĩmi mụ ãdroŋa ãzí idélé báwũ sĩ ãzíla írã sĩ rĩ kí ị̃nzị̃lé ãzíla ãzị́ ngalé ĩꞌbaní ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","ꞌBá Úpí ꞌbã sĩ ĩmi drojó ãngũ ĩꞌbadrị̂ agá rĩ kí idé drị̃nzá ãmbógó la sĩ ị́jọ́ ru idélépi ĩmi ụrụꞌbá ꞌdĩ kí sĩ; kí ĩmĩ gụgụ̃ ãzíla kí ĩmi ide-ĩdẽ. ");
INSERT INTO luc_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","“Ĩmi ũri kpẹ̃ ámvụ́ kí agá wẽwẽ rú wó ĩmi ãkónã la kí atrá wereŋá ru ãꞌdusĩku úmbí ꞌbã kí najó rá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","Ĩmi ámvụ́ ãzị́ nga sĩ zãbíbũ sajó rá ãzíla ĩmi kí tã mba múké rá wó ĩmi icó kí sụ́ mvụlé wáyĩnĩ rú jõku ãka la nalé ku ãꞌdusĩku ụ̃ꞌbụ la kí ũsõ rá. ");
INSERT INTO luc_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","Mị̃zẹ̃yị́tụ̃ la zo ãngũ ĩmidrị̂ agá pírí, wó ĩmi icó ãdu la nalé ku ãꞌdusĩku mị̃zẹ̃yị́tụ̃ ꞌbã ãka la kí zõ nị kí drĩ ku rú. ");
INSERT INTO luc_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","Ĩmi anzị kí tị rá, wó mẹ́rọ́ꞌbá kí amụ́ kí ꞌdụlé rá, kí dó sĩ acá mãbụ́sụ̃ arụ́lé ãꞌdị́ gá rĩ kí rú. ");
INSERT INTO luc_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","Ife ãzíla ãkónã ĩmidrị́ ámvụ́ agá rĩ kí Úmbí la kí na pírí. ");
INSERT INTO luc_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","“ꞌBá ãmị́yọ́ŋá ru uꞌálépi ãngũ ĩmidrị̂ agá rĩ kí acá kụ́rẹ́nị́ ru ãzíla ma kí ꞌbã ĩmi drị̃lẹ́ gá wó ĩmi adru kí pálé gá. ");
INSERT INTO luc_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","Kí ĩminí séndẽ fẽ dẹ́nọ̃ rú rá wó ĩmi icó ĩꞌbaní dẹ́nọ̃ fẽlé ku. Ãsị̃jó kí adru ꞌbá ĩmi drị̃ celépi rĩ kî rú, wó ĩmi dó acá kótẽ rú. ");
INSERT INTO luc_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","“Áwãtáŋá ndú-ndú ꞌdĩ kí pírí amụ́ ími drị̃ gá, kpere ĩꞌbã kí ími rụ agá ãzíla kí ími ị̃lị̃kị̃ rá ãꞌdusĩku mí are Úpí Ãdróŋá mídrị̂ tị ãzíla ímba ãzị́táŋá ĩꞌdidrị́ ĩꞌdi ꞌbã fẽlé míní rĩ kí tã ku. ");
INSERT INTO luc_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","Áwãtáŋá ꞌdĩ kí amụ́ pírí ícétáŋá ru ãzíla bị́lẹ́ ị̃ndụ́lima rú ĩmi drị̃ gá anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe jãꞌdâ. ");
INSERT INTO luc_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","Míní ãzị́ ngajó Úpí Ãdróŋá mídrị̂ ní ásị́ ãyĩkõ rú sĩ ãzíla ãyĩkõ sĩ sáwã míní adrujó málĩ trũ rĩ sĩ ku rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","Ị́jọ́ ꞌdĩ sĩ Úpí la ĩminí mẹ́rọ́ꞌbá kí tị ãpẽ ĩmi ꞌdụlé ĩmi dó sĩ mụ ãzị́ ngalé ĩꞌbaní, ãbị́rị́ agá, ị̃yị́vị́ trũ ãzíla ĩdrĩ átã adru pílílí ru ãzíla ãko ãzí kóru. Úpí la fẽ la mẹ́rọ́ꞌbá ĩmidrị̂ kí ĩminí cãndí fẽ ãzíla kí ĩminí ũcõgõ fẽ kpere ĩminí ũdrã agá. ");
INSERT INTO luc_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","“Úpí la sụ́rụ́ ĩminí adrujó ĩꞌba abe rá-rá rú la kí ají angájó ụ̃nọ́kụ́ ꞌbã ãsị̃ agá, kí zõ ĩmi drị̃ gá yụ́kụ́ ꞌbã ꞌdejó ãꞌụ́ drị̃ gá rĩ áni, sụ́rụ́ ĩminí tị ĩꞌbã kí jọlé rĩ vãjó ku la, ");
INSERT INTO luc_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","Sụ́rụ́ ãzí ĩminí icólé drị̃ tẽlé ku ãzíla icólépi ꞌbá ĩyõ kí rulépi ku jõku ásị́ ị̃gbẹ̃ ꞌbãlépi anzị kí drị̃ gá ku la kî. ");
INSERT INTO luc_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","Kí ãnãkpá ĩmidrị̂ kí na ãzíla kí ãkónã ĩmidrị́ ámvụ́ agá rĩ kí upa rá kpere ĩminí ị̃lị̃kị̃ agá. Icó kí ĩminí ãko ãzí ífí ãlu la aꞌbelé ku; ãná, wáyĩnĩ úꞌdí, ãdu Mị̃zẹ̃yị́tụ̃ drị̂ jõku kãjóŋá kí kãbĩlõmvaka kí abe kpere ĩminí ị̃lị̃kị̃ agá. ");
INSERT INTO luc_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","Sụ́rụ́ ꞌdĩ kí táwụ̃nị̃ mídrị̂ kí andre ce trộkị́lịrị cí kpere mére Bõrõ rú míní sịlé trộkị́lịrị cí ími ásị́ ꞌbã sĩ mbajó ũkpó ru ꞌdĩ kí andi agá. Kí táwụ̃nị̃ mídrị̂ kí andre ce ãngũ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ kí abe trộkị́lịrị cí. ");
INSERT INTO luc_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","“Mẹ́rọ́ꞌbá mídrị̂ kí ími drị̃ gá ũcõgõ ajíjó ĩꞌbã kí ími andre cejó trộkị́lịrị cí rĩ sĩ, mi dó ũri ãfũlépi ími ụrụꞌbá gá rĩ kí na, mi anzị ãzíla izonzi mídrị́ Úpí Ãdróŋá mídrị̂ ꞌbã fẽlé míní rĩ kí ꞌbã ĩzá na. ");
INSERT INTO luc_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","Ágọ́bị́ ásị́ ị̃gbẹ̃ trũ ĩmi agá ꞌdâ ãndânĩ rĩ ásị́ la icó adrulé ị̃gbẹ́ ru ádrị́pị ní, ũkû ní jõku anzị ĩꞌdidrị́ acelépi ídri rĩ ꞌbaní ku. ");
INSERT INTO luc_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","Ágọ́bị̂ la gã ĩzá ngọ́tị́ŋá ĩꞌdidrị́ ĩꞌdi ꞌbã nalé rĩ drị̂ fẽlé ĩꞌba ãzí ãlu la ní úmgbé ãꞌdusĩku ãko ãzí ndú la ꞌbã acejó ĩꞌdiní ku mẹ́rọ́ꞌbá ꞌbã kí ĩꞌdi ĩcãndĩjó ãzíla cejó trộkị́lịrị rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","Ũkú ásị́ ị̃gbẹ̃ trũ ĩmi agá ꞌdâ ãndânĩ, ru pá alé sĩ vũ tulépi ku rĩ ásị́ icó adrulé ị̃gbẹ́ ru ĩꞌdi ꞌbã ágô ĩꞌdiní lẽlé ambamba rĩ ní jõku ĩꞌdi ꞌbã ngọ́pị ãzíla ị̃zẹ́pị ní ku. ");
INSERT INTO luc_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","Ĩꞌdi anzị ꞌbã ũtu ãzíla ũrekeŋá ĩꞌdiní tịlé rĩ kí na ũní-ũní ru ãꞌdusĩku mẹ́rọ́ꞌbá ĩmidrị̂ ꞌbã kí ĩmi cejó trộkị́lịrị cí rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","“Ídrĩ ímbátáŋá Ãdróŋá drị́ ĩꞌdi ꞌbã sĩlé bụ́kụ̃ ãzị́táŋá drị̂ agá rĩ kí vú ũbĩ ásị́ pírí sĩ ãzíla ídrĩ Úpí Ãdróŋá mídrị̂ ꞌbã rụ́ ũniyambamba rĩ ị̃nzị̃ ku, ");
INSERT INTO luc_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","Úpí la míní ãyánĩ ãzíla jụ́wẹ̃ ãzí icólé ĩdãwãlé ku rĩ kí tị ãpẽ ími drị̃ gá anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","Ĩꞌdi ími drị̃ gá ĩyéngã ũnzí ándrá míní nị̃lé Mị̃sị́rị̃ gâlé rĩ kí ají ãzíla ãyánĩ ꞌdĩ icó kí walé ku. ");
INSERT INTO luc_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","Úpí la míní ãyánĩ ũví ndú-ndú ãzíla jụ́wẹ̃ ãzí ꞌbání rụ́ ũlũlé bụ́kụ̃ sĩ ãzị́táŋá ãzíla ímbátáŋá Ãdróŋá drị̂ kí sĩjó rĩ agá ku ꞌdĩ kí tị ape ími ị̃lị̃kị̃lé rá. ");
INSERT INTO luc_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","Ídrĩ táni kpẹ̃ lẽlẽgó ꞌbụ̃ gá ꞌdĩ kí áni, ími agá ꞌdâ ꞌbá were la kí mụ acelé ídri rú nĩ ãꞌdusĩku mí are Úpí Ãdróŋá mídrị̂ tị ku. ");
INSERT INTO luc_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","Cécé Úpí ꞌbã adrujó ãyĩkõ sĩ ími fẽjó adrujó málĩ trũ ãzíla kãlãfe mídrị̂ ꞌbã kpẹ̃jó rĩ áni, gẹ̃rị̃ ãlu ꞌdĩ sĩ ĩꞌdi adru ãyĩkõ sĩ ími andijó ãzíla ími ị̃lị̃kị̃jó. Ĩꞌdi ími unze ízókí trũ ãngũ míní mụlé ꞌdụlé mí ãni la rú rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","“ꞌDã ꞌbã ũngúkú gá, Úpí la ĩmi iré sụ́rụ́ pírí kí agá, iꞌdójó wókõ ãlu rĩ gá cajó ãzí rĩ gá. Ãngũ ĩꞌdi sĩ ĩmi drojó rĩ gá, ĩmi mụ ãzị́ ngalé ãdroŋa idélé ife sĩ ãzíla írã sĩ, ãdroŋa ĩmi jõku ĩmi áyị́pịka ꞌbã kí ị̃nzị̃lé ku rĩ ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","Ĩmi icó ásị́ ị̃gbẹ̃ ịsụ́lé ãngũ ãzí gá ku, ãngũ ãzí ĩminí umvelé ĩminí la la adru yụ; Úpí la ĩmi fẽ adrujó ũrãtáŋá sĩ, ĩmi adru ásị́ tị̃ŋá kóru ãzíla ĩmi ásị́ la dó umvú-umvû. ");
INSERT INTO luc_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","Ídri ĩmidrị̂ agá ĩmi drị̃ la ru iza ị̃ndụ́ ceŋá kóru, ị̃tụ́ kí ị́nị́ be ĩmi uꞌá ụ̃rị̃ drãdrị̂ agá ásị́ ꞌbãŋá ko ru. ");
INSERT INTO luc_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","Ĩmi ásị́ la umvú ụ̃rị̃ sĩ ãko pírí ĩminí ndrelé rĩ kî sĩ. Ụ̃ꞌbụ́tị ãlu-ãlu sĩ ĩmi tátí lẽ la ĩndró ꞌbã acá nĩ, wó ĩndró ãlu-ãlu sĩ ĩmi tátí lẽ la ụ̃ꞌbụ́tị ꞌbã acá nĩ. ");
INSERT INTO luc_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","Úpí la ĩmi tị pẽ mẹ́lị̃ sĩ Mị̃sị́rị̃ gá vúlé, drĩ táni ándrá jọ la ĩmi icó gõlé Mị̃sị́rị̃ gâlé ku rá tí. ꞌDã gâlé ĩmi tí lẽ ĩmi ụzịlé mẹ́rọ́ꞌbá ĩmidrị̂ ꞌbaní ãtíꞌbó ru, wó kí ãzí ãlu la icó ĩmi ĩgbãlé ku.” ");
INSERT INTO luc_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","ꞌDĩ kí ãzị́táŋá Úpí ꞌbã fẽlé Mụ́sã ní sĩ tị icíma idéjó ꞌbá Ịsịrayị́lị̃ drị̂ kí abe ãngũ Mụ̃wábụ̃ drị̂ gá rĩ kî; tị icíma ꞌdĩ ĩꞌdi Úpí ꞌbã ándrá idélé ĩꞌba abe ꞌBé Hõrébũ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","Mụ́sã umve ꞌbá Ịsịrayị́lị̃ drị̂ kí pírí ãngũ ãlu gá ãzíla jọ ĩꞌbaní, “Ĩndre ĩmi mịfị́ sĩ ị́jọ́ Úpí ꞌbã idélé úpí Mị̃sị́rị̃ drị̂ rụ́ ãmbogo ĩꞌdidrị̂ kí abe ãzíla sụ́rụ́ ĩꞌdidrị̂ ụrụꞌbá gá rĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","Ĩndre vâ ĩmi mịfị́ sĩ ụ̃ꞌbị̃táŋá ũkpó ru, tálí ãzíla ị́jọ́ ụ̃sụ̃táŋá ru Úpí ꞌbã idélé rĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","Wó Úpí nzị̃ ĩmi mịfị́ sĩ ị́jọ́ ꞌdĩ kí ndrejó jõku úŋmĩ sĩ ị́jọ́ ꞌdĩ kí vãjó ãzíla bị́lẹ́ sĩ ị́jọ́ ꞌdĩ kí arejó ku. ");
INSERT INTO luc_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","Ílí kãlị́ sụ ꞌdĩ kí agá Úpí ri ĩmi drị̃ uꞌdelé ãngũ kõtórõ rú rĩ agâ sĩ, ꞌdãá bõngó ĩmidrị̂ kí jõku ãko ĩminí sụ̃lé ĩmi pá gá rĩ kí abe de kí ku. ");
INSERT INTO luc_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","Ĩna ándrá mũkátĩ ku, ĩmvụ ándrá wáyĩnĩ jõku ãko ũká mvụlé mvụ-mvụ̃ ꞌdĩ kí ku. Wó Úpí Ãdróŋá ĩmidrị̂ fẽ ĩminí ãko ꞌdĩ kí sĩ ĩmi imbájó ꞌi Ãdróŋá ĩmidrị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","“ꞌDã ꞌbã ũngúkú gá, ãma dó mụ acálé ãngũ ꞌdĩ gá ꞌbo, úpí Sị̃họ́nị̃ Hẹ̃sị̃bọ́nị̃ drị̂ kí úpí Ụ́gị̃ Bãsánĩ drị̂ be ãfũ kí amụ́lé ãꞌdị́ gá ãma rụ́, wó ãndẽ kí rá. ");
INSERT INTO luc_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","Ãpa ãngũ ĩꞌbadrị̂ rá ãzíla ãfẽ ĩꞌdi ínátị Rụ́bẹ̃nị̃ drị́, Gádĩ drị́ ãzíla ínátị Mãnásẽ drị̂ ꞌbã nụ́sụ̃ ꞌbaní ãwítã rú. ");
INSERT INTO luc_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","“Ĩmi ụ̃ꞌbị̃ ásị́ pírí sĩ ị́jọ́ tị icíma ꞌdĩ drị̂ kí vú ũbĩjó, ị́jọ́ ꞌdĩ sĩ, ĩmi dó sĩ adru drị̃lẹ́ba rú ị́jọ́ pírí ĩminí idélé rĩ kí agá. ");
INSERT INTO luc_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","Ãndrũ ĩmi utu pá pírí Úpí Ãdróŋá ĩmidrị̂ drị̃lẹ́ gá ꞌbá ĩmidrị́ ínátị gá drị̃lẹ́ ru, ꞌbá úpí ru, ꞌbá ĩyõ, ꞌbá ãmbogo rú ãzíla ꞌbá Ịsịrayị́lị̃ drị̂ kí abe, ");
INSERT INTO luc_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","anzị ĩmidrị̂ kí, ũkú ĩmidrị̂ kí ãzíla ãmị́yọ́ŋá ĩminí ijijá galépi rĩ kí, ĩminí ị̃yị́ kolépi uꞌálépi ĩmidrị́ lị́cọ́ gá rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","Ítu pá ꞌdâ la sĩ fijó tị icíma agá Úpí Ãdróŋá mídrị̂ be, tị icíma ꞌdĩ ĩꞌdi tị icíma Úpí Ãdróŋá mídrị̂ ꞌbã mụlé icílé mí be ụ́ꞌdụ́ ãndrũ ꞌdĩ sĩ rĩ ãzíla ála umbé la ũyõ naŋá sĩ. ");
INSERT INTO luc_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","Ị́jọ́ ꞌdĩ sĩ Úpí la dó sĩ ĩmi lã ĩꞌdi ꞌbã ꞌbá ru ãzíla ĩꞌdi dó sĩ adru Ãdróŋá ĩmidrị̂ rú cécé ĩꞌdi ꞌbã ándrá azịlé ãzíla ũyõ la najó ĩmĩ áyị́pịka Ịbụrahị́mụ̃, Ĩsákã ãzíla Yãkóꞌbõ ꞌbaní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","Ma tị icíma ꞌdĩ idé, ũyõ la naŋá be, adru lú ĩmi abe áꞌdụ̂sĩ la ku. ");
INSERT INTO luc_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","Ma ĩꞌdi idé ꞌbá pírí pá utulépi áma drị̃lẹ́ gá, Úpí Ãdróŋá ãmadrị̂ drị̃lẹ́ gá ãndrũ ãzíla vâ anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbaní ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","“Ĩmĩ ãmgbã rĩ nị̃ kí ãma uꞌá ándrá Mị̃sị́rị̃ gâlé íngoní yã rĩ drị̃ gá ị́jọ́ rá ãzíla ãma alị kí sụ́rụ́ ãzí ꞌdĩ kí agâ sĩ íngoní ru yã rĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","Ĩndre ãdroŋa ĩꞌbadrị́ ĩꞌbã kí idélé ũnzíkãnã báwũ sĩ, írã sĩ, sílĩvã sĩ ãzíla gólũdĩ sĩ icólépi ru alólépi ku ꞌdĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","Lẽ ĩndre múké-múké ágọ́bị́, ũkú, ꞌbá lị́cọ́ agá jõku sụ́rụ́ ãndrũ pá tulépi ꞌdâ Úpí Ãdróŋá ãmadrị̂ drị̃lẹ́ gá ru ujalépi ãdroŋa sụ́rụ́ ãzí ndú ꞌdĩ ꞌbadrị̂ kí ị̃nzị̃lépi ãzíla ãzị́ ngalépi ĩꞌbaní rĩ la ũmbã Úpí Ãdróŋá ãmadrị̂ drị̂ umve ĩꞌdi ụrụꞌbá gá. Ị́jọ́ ꞌdĩ la adru cécé ife ízókí ụ̃jị́ ãdrákĩ rú rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","“Lẽ ĩndre múké-múké ꞌbá ãzí ꞌdâ ãndrũ ị́jọ́ ũyõ ꞌdĩ drị̂ arelépi rá wó sụ̃sụ́ wilépi ĩꞌdiní cénĩ-cénĩ rú sĩ ũrãjó la, ‘Ị́jọ́ kí mụ adrulé múké ĩꞌdiní rĩ drĩ táni mụ drị̃ ũnzĩ sĩ gẹ̃rị̃ ĩꞌdidrị̂ gá.’ Ị́jọ́ ꞌdĩ la ꞌbá múké rĩ kí ị̃lị̃kị̃ pírí ꞌbá ũnzí rĩ abe trũ-trũ. ");
INSERT INTO luc_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","Úpí icó ꞌbá ꞌdĩ ꞌbã áni rĩ trũlé ku. Be la rá la, ĩꞌdi ꞌbã ũmbã velépi ãcí áni rĩ la ꞌde ꞌbá ũnzĩkãnã ngalépi rĩ drị̃ gá ãzíla áwãtáŋá pírí sĩlé bụ́kụ̃ ꞌdĩ agá ꞌdâ rĩ kí ꞌde ĩꞌdi drị̃ gá ãzíla Úpí la dó sĩ ĩꞌdi ị̃lị̃kị̃ ụ̃nọ́kụ́ drị̃ gá ꞌdâ rá. ");
INSERT INTO luc_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","Úpí la ĩꞌdi ãpẽ áꞌdụ̂sĩ sụ́rụ́ Ịsịrayị́lị̃ drị̂ kí agá ꞌdãá sĩ ũcõgõ ịsụ́jó, ị́jọ́ jọlé ãzíla sĩlé tị icíma drị́ bụ́kụ̃ Ãdróŋá drị́ ãzị́táŋá drị̂ agá rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","“Ílí drị̃lẹ́ gá amụ́lépi rĩ kí agá anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí ãzíla ꞌbá ãmị́yọ́ŋá ru amụ́lépi ãngũ rá-rá ru ꞌdã kí agá rĩ kí amụ́ ũcõgõ ãzíla ãyánĩ Úpí ꞌbã ajílé ãngũ ĩmidrị̂ drị̃ gá ꞌdĩ kí ndrelé. ");
INSERT INTO luc_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","Ụ̃nọ́kụ́ ala gá rĩ la adru ãngũ ru izalépi rá velépi bãrụ́tị̃ sĩ ãzíla ãꞌị́ sĩ rĩ áni, ãngũ sĩ icójó ãkónã sajó ku, ãko ãzí ꞌbã sĩ icójó angájó ala gá ku, ife ãzíla ásé ꞌbã kí sĩ icójó angájó ala gá ku cécé Sõdómũ ꞌbadrị́ Gõmórã be, Ãdímã, ãzíla Zẹ̃bụ̃yị́mụ̃ gá ándrá Úpí ꞌbã ivélé ãcí sĩ ũmbã ꞌbã ĩꞌdi najó rĩ sĩ rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","Sụ́rụ́ pírí ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ kí zị la, ‘Úpí idé dó ị́jọ́ ꞌdĩ ãngũ ꞌdĩ rụ́ íni ãꞌdu ị́jọ́ sĩ yã fô? Ásị́sị́ŋá ũmbã ꞌbã Ãdróŋá najó ambamba rĩ dó ãꞌdu?’ ");
INSERT INTO luc_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","Umvitáŋá lã la adru, ‘Ị́jọ́ ꞌdĩ idé ru íni la ꞌbá ꞌdĩ gã kí tị icíma ándrá Úpí Ãdróŋá ꞌbã icílé ĩꞌbã átẹ́pịka abe sáwã ĩꞌdi ꞌbã kí anzéjó ãmvé Mị̃sị́rị̃ gâlé rĩ sĩ rĩ úmgbé. ");
INSERT INTO luc_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","Ri kí ãdroŋa ndú la kí ị̃nzị̃lé ãzíla ãzị́ ngajó ĩꞌbaní áyụ, ãvụ̃ kí kí drị̃lẹ́ gá, ꞌdĩ kí ãdroŋa ãzí ndú ĩꞌbã kí jõ drĩ ị̃nzị̃lé ku la kî ãzíla ãdroŋa Úpí ꞌbã fẽlé ĩꞌbaní nĩ ku la kî. ");
INSERT INTO luc_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","Ị́jọ́ ꞌdĩ sĩ, ũmbã na Úpí ꞌi ꞌbá ĩꞌdidrị̂ ꞌbaní rá ãzíla ají dó ãngũ ĩꞌbadrị̂ drị̃ gá áwãtáŋá pírí sĩlé bụ́kụ̃ ꞌdĩ agá rĩ kî. ");
INSERT INTO luc_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","Úpí ꞌa ve dó ĩꞌbaní ãcí ru ãzíla ꞌa la dra ĩꞌbaní ũmbájírílí ru ãzíla unze dó sĩ kí ízókí ãngũ ĩꞌbadrị̂ kí agá ꞌdãá rĩ sĩ rá, dro dó sĩ kí ãmị́yọ́ŋá ꞌbã ãngũ gá ꞌdĩ ãngũ ĩꞌbã kí sĩ úꞌda uꞌájó ala gá kpere ãndrũ rĩ gá.’ ");
INSERT INTO luc_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","“Ị́jọ́ ru zị̃lépi cí ꞌdĩ kí Úpí Ãdróŋá ãmadrị̂ ãni, wó ị́jọ́ ru iꞌdalépi rá ꞌdĩ kí ãmaní anzị ãmadrị̂ kí abe jãꞌdâ, ị́jọ́ ꞌdĩ sĩ ãma dó sĩ ãzị́táŋá ꞌdĩ kí vú ũbĩ. ");
INSERT INTO luc_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","“Úꞌdîꞌda áfẽ míní drị̃lẹ́mgbọ sĩ ị́jọ́ pẽjó drị̃lẹ́ba kí drĩdríŋĩ gá áwãtáŋá be. Ị́jọ́ ꞌdĩ drĩ kí dó ru idé pírí mí rụ́ ãzíla ídrĩ uꞌá sụ́rụ́ Úpí Ãdróŋá mídrị̂ ꞌbãsĩ ĩmi iréjó rĩ kí drĩdríŋĩ gá, mi dó mụ ị́jọ́ mání pẽlé míní rĩ ꞌbã ị́jọ́ agálé. ");
INSERT INTO luc_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","Ídrĩ ími uja anzị mídrị́ drị̃lẹ́ gâlé rĩ kí abe Úpí Ãdróŋá mídrị̂ rụ́ ími ásị́ pírí sĩ ãzị́táŋá ĩꞌdidrị́ mání fẽlé míní ãndrũ ꞌdĩ kí tã mbajó, ");
INSERT INTO luc_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","ꞌdã ꞌbã ũngúkú gá Úpí Ãdróŋá mídrị̂ la dó drị̃lẹ́ba mídrị̂ kí fẽ adrulé ídu rĩ ꞌbã áni. Ãdróŋá ꞌbã ásị́ ị̃gbẹ̃ la dó adru ími drị̃ gá ãzíla ĩꞌdi dó ími uja vúlé ãngũ ĩꞌdi ꞌbã ándrá sĩ ĩmi iréjó ala gá rĩ kí agâlé rá. ");
INSERT INTO luc_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","Údrĩ táni ĩmi iré agá ãngũ álị́ ãndânĩ ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ kí agá, Úpí Ãdróŋá mídrị̂ la ĩmi atrá ãngũ ãlu gá ãzíla ĩꞌdi ími ají vúlé, ");
INSERT INTO luc_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","ị́jọ́ ꞌdĩ sĩ mi dó sĩ mí uja vúlé ãngũ ándrá ími áyị́pịka ꞌbã kí sĩ uꞌájó ala gá rĩ gá. Úpí Ãdróŋá mídrị̂ la fẽ la mi adru drị̃lẹ́ba ru ãzíla mi ũꞌbĩkãnã sĩ adru ĩꞌbaní ãndânĩ. ");
INSERT INTO luc_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Úpí Ãdróŋá mídrị̂ la ími ásị́ ĩtãrã ãzíla ásị́ anzị mídrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbadrị̂ abe, ị́jọ́ ꞌdĩ sĩ mi dó sĩ ĩꞌdi lẽ ími ásị́ pírí sĩ, ími úríndí sĩ ãzíla mi dó sĩ uꞌá ãngũ ꞌdã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","Úpí Ãdróŋá mídrị̂ la áwãtáŋá ꞌdĩ kí ꞌbã pírí mẹ́rọ́ꞌbá ími ngụ̃lépi ũnzí ãzíla mi ĩcõcõŋãlépi rĩ ꞌba rụ́. ");
INSERT INTO luc_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","Ídrĩ Úpí tị are ãzíla ídrĩ ãzị́táŋá ĩꞌdidrị́ mání mụlé fẽlé míní ãndrũ ꞌdĩ kí tã mba ásị́ pírí sĩ rá, ");
INSERT INTO luc_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","ꞌdã ꞌbã ũngúkú gá Úpí Ãdróŋá mídrị̂ la ãzị́ pírí ími drị́ ꞌbã ngalé rĩ kí fẽ adrulé drị̃lẹ́ba ãmbógó la trũ, anzị míní tịlé rĩ kí, ãnãkpá mídrị̂ ꞌbã mvaka kí ãzíla ũri mídrị́ ámvụ́ agá rĩ kí abe. Úpí Ãdróŋá mídrị̂ la uꞌá mí sĩ ãyĩkõ sĩ ãzíla ĩꞌdi ími fẽ adrulé drị̃lẹ́ba ãmbógó la trũ, cécé ãyĩkõ ꞌbã ándrá ĩꞌdi fụjó mí áyị́pịka kí sĩ rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","Ídrĩ Úpí Ãdróŋá mídrị̂ tị are ãzíla ídrĩ ị́jọ́ ĩꞌdidrị́ azịlé sĩlé Bụ́kụ̃ ãzị́táŋá drị́ ꞌdĩ agá ꞌdĩ kí vú ũbĩ rá, lẽ mí uja dó mi vúlé ĩꞌdi rụ́ ꞌdõlé ími ásị́ pírí sĩ.” ");
INSERT INTO luc_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","Mụ́sã jọ, “Ãzị́táŋá ãndrũ mání fẽlé ĩminí ꞌdĩ adru kí ũkpómgboroto rú jõku ĩminí sĩ icójó cajó ala gá ku íni la ku. ");
INSERT INTO luc_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","Adru kí ụrụgá ꞌbụ̃ gâlé, ĩminí dó sĩ zịjó la, ‘Ãꞌdi la tụ ãmaní ꞌbụ̃ gâlé nĩ sĩ kí ajíjó ãma rụ́ ꞌdõlé ãzíla ị́jọ́ la ũlũjó ãmaní ãma dó sĩ ãꞌị̃ la rĩ gá nĩ yã la ku.’ ");
INSERT INTO luc_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","Jõku ĩꞌdi ị̃yị́ ꞌbã ꞌá ꞌdã sĩ ĩminí dó sĩ zịjó la, ‘Ãꞌdi la dó ãmaní za ị̃yị́ ꞌbã ꞌá ꞌdã sĩ sĩ mụjó ajíjó la ãzíla sĩ amụ́jó ũlũjó la ãmaní, ãma dó sĩ are la ãzíla sĩ ãꞌị̃ la benĩ yã?’ ");
INSERT INTO luc_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","Yụ, ị́jọ́ Ãdróŋá drị̂ ĩꞌdi ãni rú ími andre gá ꞌdĩ, ĩꞌdi ími tị gá ꞌdĩ ãzíla ími ásị́ gá ꞌdĩ, mí ãꞌị̃ ĩꞌdi. ");
INSERT INTO luc_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“Índre, ãndrũ áfẽ míní drị̃lẹ́mgbọ sĩ ị́jọ́ pẽjó mũkẽ kí drĩdríŋĩ gá ũnzĩkãnã be, ídri kí drĩdríŋĩ gá drã be. ");
INSERT INTO luc_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Ị́jọ́ ꞌdĩ sĩ ãndrũ áfẽ míní ãzị́táŋá sĩ Úpí Ãdróŋá mídrị̂ lẽjó, acị́jó gẹ̃rị̃ ĩꞌdidrị̂ kí agá, ãzị́táŋá ĩꞌdidrị̂ kí tã mbajó ị́jọ́ azịlé rĩ kí abe; mi dó sĩ adru drị̃lẹ́ba rú ãzíla sụ́rụ́ ꞌbá trũ ũꞌbí la rú. Úpí Ãdróŋá mídrị̂ la míní ásị́ ị̃gbẹ̃ fẽ ãngũ míní mụlé ꞌdụ lé sĩ rijó ala gá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","“Wó ĩmi ásị́ drĩ ru uja má rụ́ ꞌdâ rá ãzíla ĩdrĩ áma tị gã arelé úmgbé ĩminí sĩ ãvụ̃jó sĩ ãdroŋa ãzí kí ị̃nzị̃jó ãzíla ãzị́ ngajó ĩꞌbaní, ");
INSERT INTO luc_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","ájọ ĩminí ụ́ꞌdụ́ ãndrũ ꞌdĩ sĩ ĩmi ị̃lị̃kị̃ rá, ĩmi icó uꞌálé ãzo rú ãngũ ĩminí sĩ zajó ꞌá Mĩrĩ Yõrĩdánĩ gá ĩminí mụlé ꞌdụlé ĩmi ãni la rú rĩ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","“Ụ́ꞌdụ́ ãndrũ ꞌdõ sĩ ma ꞌbụ̃ kí umve ụ̃nọ́kụ́ be adrujó sãdínĩ rú iꞌdajó la ĩminí áꞌbã ĩmi drị̃lẹ́ gá ídri kí drã be, drị̃lẹ́ba kí áwãtáŋá be. Lẽ ĩpẽ ídri, ị́jọ́ ꞌdĩ sĩ ĩmi dó sĩ uꞌá anzị ĩmidrị̂ kí abe ídri rú, ");
INSERT INTO luc_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","ãzíla mi dó sĩ Úpí Ãdróŋá mídrị̂ lẽ, ị́jọ́ ĩꞌdidrị̂ are, ãzíla ru ĩkpãjó ĩꞌdi rụ́. Ị́jọ́ ꞌdĩ sĩ Úpí Ãdróŋá mídrị̂ ĩꞌdi ídri mídrị̂ ꞌi, ĩꞌdi míní ílí kí fẽ ãzo rú sĩ ãngũ ĩꞌdi ꞌbã ándrá ũyõ najó sĩ fẽjó la mí átẹ́pịka Ịbụrahị́mụ̃, Ĩsákã, ãzíla Yãkóꞌbõ ꞌbaní rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","ꞌDã ꞌbã ũngúkú gá, Mụ́sã mụ drị̃ gá ị́jọ́ jọŋâ trũ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, ");
INSERT INTO luc_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","ãzíla jọ, “Áma ílí dó úꞌdîꞌda 120 ãzíla má icó dó adrulé ĩminí drị̃lẹ́ ru sĩ fũjó ãmvé ãzíla afíjó ĩmi abe ị̃dị́ ku. Úpí jọ mání ‘Má icó Ị̃yị́ Yõrĩdánĩ zalé ku.’ ");
INSERT INTO luc_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Úpí Ãdróŋá mídrị̂ lã mụ drị̃ ꞌdelé ími drị̃lẹ́ gá ãzíla ĩꞌdi mụ sụ́rụ́ uꞌálépi ꞌdãá rĩ kí ị̃lị̃kị̃lé, ị́jọ́ ꞌdĩ sĩ, mi dó sĩ ãngũ ĩꞌbadrị̂ kí ꞌdụ mínî. Yósũwã la mụ mụlé ími drị̃lẹ́ gá sĩ ími drị̃ ꞌdejó sĩ zajó nĩ, cécé Úpí Ãdróŋá mídrị̂ ꞌbã jọlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","Úpí la mụ ꞌbá ꞌdã kí ị̃lị̃kị̃lé, cécé ĩꞌdi ꞌbã ándrá úpí Ãmọ́rị̃ drị́ Sị̃họ́nị̃ kí ị̃lị̃kị̃jó Ụ́gị̃ be ãzíla sụ́rụ́ ĩꞌbadrị̂ kí ãngũ ĩꞌbadrị̂ kí abe rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Úpí la fẽ la ĩmi kí ndẽ rá ãzíla lẽ ĩnga ị́jọ́ ĩꞌba rụ́ cécé mání azịlé ĩminí rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Mí adru jõ ũkpó ru ãzíla ụ̃rị̃ kóru. Mí ídé ụ̃rị̃ sĩ ku, jõku ími ụrụꞌbá ꞌbã co ãcí kî sĩ ku. Úpí Ãdróŋá mídrị̂ lã mụ mí be; má icó ími aꞌbelé jõku ími ãzãkolé ku la ku.” ");
INSERT INTO luc_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","ꞌDã ꞌbã ũngúkú gá, Mụ́sã umve dó Yósũwã ꞌi ãzíla jọ ĩꞌdiní ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃ gâsĩ pírí, “Mí adru ũkpó ru ãzíla ụ̃rị̃ kóru, lẽ ímụ ꞌbá Ịsịrayị́lị̃ drị́ ꞌdĩ abe ãngũ Úpí ꞌbã ándrá ũyõ nalé ĩꞌbã áyị́pịka ꞌbaní ĩꞌdi mụ fẽlé la ĩꞌbaní rĩ gá ãzíla lẽ mí awa ãngũ ꞌdĩ ĩꞌbaní ãko ĩꞌbã ni la rú. ");
INSERT INTO luc_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Úpí ãmgbã rĩ la mụ drị̃ ꞌdelé ĩmi drị̃lẹ́ gá ãzíla ĩꞌdi mụ adrulé ĩmi abe. Icó ĩmi aꞌbelé ku jõku ĩmi ãzãkolé ku la ku. Ĩmi idé ụ̃rị̃ sĩ ku; ĩmi ịsụ́ ũkpõ ãkõ ku.” ");
INSERT INTO luc_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","Ị́jọ́ ꞌdĩ sĩ Mụ́sã sĩ ãzị́táŋá ꞌdĩ kí pírí bụ́kụ̃ gá ị́jọ́ ꞌbá imbájó rĩ kí abe ãzíla fẽ dó kí ãtalo Lẹ́vị̃ rú rĩ ꞌbadrị́, ꞌbá ĩyõ Ịsịrayị́lị̃ drị̂ kí abe pírí kí, ꞌdĩ kí ꞌbá ándrá Sãndụ́kụ̃ Úpí drị́ tị icíma drị̂ ụꞌdụlépi rĩ kî ");
INSERT INTO luc_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","ꞌDã ꞌbã ũngúkú gá, Mụ́sã fẽ ãzị́táŋá ãtalo ꞌdĩ ꞌbaní ꞌbá ĩyõ Ịsịrayị́lị̃ drị̂ kí abe jọ, “Ílí ázị̂rị̃ ãlu-ãlu ꞌbã ukóŋá gá, ílí sĩ ꞌbá trũjó mọ̃rị́ sĩ rĩ drị̂ gá, sáwã ụ̃mụ̃ nalé bõrõkõ agá rĩ drị̂ sĩ, ");
INSERT INTO luc_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","ílã dó bụ́kụ̃ ãzị́táŋá drị̂ ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃lẹ́ gá ĩꞌbã kí ru atrá agá Úpí Ãdróŋá mídrị̂ ꞌbã drị̃lẹ́ gá ãngũ ĩꞌdi ꞌbã pẽlé rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","Ĩmi atrá ãgọbị, ũkú, ãzíla anzị nírí kî, ãzíla ꞌbá ãmị́yọ́ŋá ru ĩmidrị́ táwụ̃nị̃ gá rĩ kí abe ãngũ ãlu gá, ị́jọ́ ꞌdĩ sĩ kí dó sĩ ị́jọ́ are ãzíla ị́jọ́ ụ̃nị̃ sĩ Úpí Ãdróŋá ĩmidrị̂ ụ̃rị̃jó ãzíla kí sĩ adru múké-múké sĩ ị́jọ́ ãlu-ãlu sĩlé ãzị́táŋá ꞌdĩ agá rĩ kí tã mbajó. ");
INSERT INTO luc_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","Ị́jọ́ ꞌdĩ sĩ, anzị ĩꞌbadrị́ mụlé tịlé drị̃lẹ́ gâlé ãzị́táŋá ꞌdĩ nị̃lépi ku rĩ kí dó sĩ are la ãzíla kí sĩ ị́jọ́ ụ̃nị̃ sĩ Úpí Ãdróŋá ĩmidrị̂ rujó ílí ĩminí uꞌájó ãngũ ĩminí mụlé ꞌdụlé ĩmi ãni la rú rĩ gá ĩdrĩ Ị̃yị́ Yõrĩdánĩ za ꞌbo rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ní, “Índre drĩ, ụ́ꞌdụ́ mídrị́ míní drãjó rĩ acá dó ãni rú. Mí umve Yósũwã ꞌi ãzíla ĩmi amụ́ ĩmi iꞌdalé ĩꞌdi be Hémã Ãdróŋá ị̃nzị̃jó rĩ agá, ị́jọ́ ꞌdĩ sĩ ma dó sĩ ĩꞌdiní ũkpõ fẽ.” ꞌDã ꞌbã ũngúkú gá, Mụ́sã mụ kí dó Yósũwã be ru iꞌdalé Hémã Ãdróŋá ị̃nzị̃jó rĩ agâlé. ");
INSERT INTO luc_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","ꞌDã ꞌbã ũngúkú gá, Úpí iꞌda ru Hémã Ãdróŋá ị̃nzị̃jó rĩ agá ãzíla ị́dị́ŋá ụ̃rụ́ꞌbụ̃ rú rĩ tupá kẹ̃jị́tị sĩ fijó Hémã Ãdróŋá ị̃nzị̃jó rĩ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","Úpí jọ Mụ́sã ní, “Ace were mĩ mụ drãlé rá, ãzíla ídrĩ drã ꞌbo ꞌbá ꞌdĩ kí dó iꞌdó ãdroŋa ndú ãngũ ĩminí mụjó fijó ala gâlé ꞌdĩ ꞌbadrị̂ kí ị̃nzị̃lé ãzíla kí áma gã úmgbé, kí tị icíma mání icílé ĩꞌba abe rĩ anu rá. ");
INSERT INTO luc_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","Ụ́ꞌdụ́ ꞌdã sĩ ma acá ĩꞌbaní ũmbã sĩ, ma kí gã mâ ꞌbá ru úmgbé ãzíla ma áma ugoró uja ĩꞌbaní áyụ ãzíla ma kí ị̃lị̃kị̃ rá. Ị́jọ́ ũnzí ãzíla ũcõgõ ndú-ndú kí aꞌdé kí drị̃ gá, ị́jọ́ ꞌdĩ sĩ kí mụ jọlé la ụ́ꞌdụ́ ꞌdã sĩ, ‘Ị́jọ́ ꞌdĩ nga kí ru ãma abe ꞌdĩ ꞌbã áni la adru Ãdróŋá ꞌbã adrujó ãma abe yụ rĩ sĩ la ku yã?’ ");
INSERT INTO luc_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","Ụ́ꞌdụ́ ꞌdã sĩ ma áma ugoró uja ĩꞌbaní áyụ ị́jọ́ ũnzí pírí ĩꞌbã kí ngalé rĩ kî sĩ, ãꞌdusĩku uja kí ru ãdroŋa ndú la kí ị̃nzị̃lé. ");
INSERT INTO luc_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","“Úꞌdîꞌda ísĩ úngó ꞌdĩ ꞌi ãzíla mí imbá ĩꞌdi anzị Ịsịrayị́lị̃ drị̂ ꞌbaní, ꞌbã ngo kí ĩꞌdi, ị́jọ́ ꞌdĩ sĩ úngó ꞌdĩ la adru mání sãdínĩ rú ꞌbá Ịsịrayị́lị̃ drị̂ kí ị́jọ́ lịjó. ");
INSERT INTO luc_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","Ádrĩ kí ajị́ ãngũ málĩ trũ mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ lé ꞌbã sĩ rajó ãnụ́ úsã be rĩ gá ãngũ mání ándrá ũyõ najó ma fẽ la ĩꞌbã átẹ́pịka ꞌbaní rĩ gá ꞌbo, ãzíla drĩ kí ãkónã na sĩ agajó tré ãzíla usejó ãmbógó ru ꞌbo, kí ru uja ãdroŋa ãzí ndú la ꞌba rụ́ sĩ kí ị̃nzị̃jó ãzíla ãzị́ ngajó ĩꞌbaní áma idejó ide-idê ãzíla kí tị icíma mádrị́ ĩꞌba abe rĩ aꞌbe rá. ");
INSERT INTO luc_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","Wó lị́kị̃ ũnzí la drĩ aꞌdé kí drị̃ gá drị̃cị́rị̃ abe ꞌbo, úngó ꞌdĩ la adru sãdínĩ rú sĩ kí ị́jọ́ lịjó ãꞌdusĩku anzị ĩꞌbadrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ icó kí ĩꞌdi ãvĩlé ku. Ánị̃ ị́jọ́ ĩꞌbã kí ũrãlé ngalé ꞌdĩ sĩ má agụ drĩ kí ãngũ mání ũyõ nalé ma kí agụ ala gá rĩ gâlé ku rú rĩ kí rá.” ");
INSERT INTO luc_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","ꞌDã ꞌbã ũngúkú gá, Mụ́sã sĩ dó úngó ꞌdĩ cí ụ́ꞌdụ́ ãlu ꞌdã sĩ ãzíla imbá dó ĩꞌdi anzị Ịsịrayị́lị̃ drị̂ ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","ꞌDã ꞌbã ũngúkú gá, Úpí fẽ dó ũkpõ Yósũwã Nụ́nị̃ ngọ́pị ní ãzíla jọ, “Mí adru jõ ũkpó ru ãzíla ụ̃rị̃ kóru ãꞌdusĩku mĩ mụ ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃ ꞌdelé agụlé ãngũ mání ándrá ũyõ la najó mã mụ fẽlé la ĩꞌbaní rĩ gá. Ma mụ adrulé ĩmi abe.” ");
INSERT INTO luc_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","Mụ́sã lã mụ ãzị́táŋá Úpí drị́ ꞌdĩ kí delé sĩlé bụ́kụ̃ gá idóŋá gá kpere ãsị̃ŋá gá ꞌbo, ");
INSERT INTO luc_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","fẽ dó ãzị́táŋá ꞌbá Lẹ́vị̃ rú ándrá Sãndụ́kụ̃ Úpí drị́ tị icíma drị̂ ujílépi rĩ ꞌbaní, ");
INSERT INTO luc_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“Ĩꞌdụ bụ́kụ̃ ãzị́táŋá drị́ ꞌdĩ ãzíla ĩꞌbã ĩꞌdi Sãndụ́kụ̃ Úpí Ãdróŋá ĩmidrị̂ drị́ tị icíma drị̂ ꞌbã bụ́lụ́ gá, ị́jọ́ ꞌdĩ sĩ, ĩꞌdi dó sĩ ace ꞌdãá sãdínĩ rú ị́jọ́ lịjó ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","Ánị̃ ĩmi drị̃ ũnzĩkãnã íngõpí ãzíla ĩmi are ꞌbá tị ku íngõpí yã rĩ gá rá. Ĩdrĩ dó ị́jọ́ Úpí drị̂ gã sĩ ịsụ́ ꞌdĩ sĩ ma drĩ ídri, ĩmi dó ĩꞌdi gã íngõpí ádrĩ dó drã rá rĩ gá! ");
INSERT INTO luc_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","Ĩmi atrá mání ꞌbá ĩyõ ĩmidrị́ ínátị gá rĩ kí drị̃lẹ́ka kí abe áma drị̃lẹ́ gá ꞌdâ pírí, ị́jọ́ ꞌdĩ sĩ ma dó sĩ ị́jọ́ ꞌdĩ kí jọ kí drị̃ gá ãzíla ma ꞌbụ̃ kí umve ụ̃nọ́kụ́ be sãdínĩ rú ị́jọ́ lịjó kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","Ánị̃ rá drã mádrị̂ ꞌbã vúlé gá, ĩmi mụ ãndá-ãndá ru ị́jọ́ ũnzí ĩmi izalépi rá rĩ kí ngalé ãzíla ĩmi ĩmi uja gẹ̃rị̃ pịrị mání azịlé ĩminí rĩ aꞌbejó rá. Ụ́ꞌdụ́ drụ́zị́ amụ́lépi drị̃lẹ́ gá ꞌdĩ kí agá, lị́kị̃ lã mụ aꞌdélé ĩmi drị̃ gá ãꞌdusĩku ĩmi mụ ị́jọ́ ũnzí idélé Úpí drị̃lẹ́ gá sĩ ĩꞌdiní ũmbã fẽjó ãko ĩminí idélé drị́ ĩmidrị̂ kí sĩ rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","ꞌDã ꞌbã ũngúkú gá, Mụ́sã lã dó úngó ꞌdĩ ꞌi drị̃kã sĩ iꞌdóŋá gá kpere ãsị̃ŋá gá ꞌbá Ịsịrayị́lị̃ drị́ ru atrálépi rĩ kí bị́lẹ́ gá: ");
INSERT INTO luc_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","“Ĩmi are, ĩmi ꞌbá ꞌbụ̃ gá ꞌdĩ! Ma mụ ị́jọ́ jọlé ĩminí ꞌdĩ; Ĩmi are ị́jọ́ áma tị gá rĩ ꞌbá ụ̃nọ́kụ́ gá ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","Ímbátáŋá mádrị̂ la ꞌdị ĩmi drị̃ gá uzogó áni; ãzíla ị́jọ́ mádrị̂ la ka ĩmi drị̃ gá cécé andrẹlị́ ꞌbã kalé rĩ áni, cécé uzogó ꞌbã ꞌdịjó ãko dụlépi úꞌdí rĩ kí drị̃ gá rĩ áni, cécé uzogó ꞌbã ꞌdịjó ĩrí ãráŋá rĩ drị̃ gá rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","Ma Úpí rụ́ ịcụ́, ꞌbá ĩꞌdidrị̂ ꞌbã ũlũ kí ãmbõgõ Ãdróŋá drị̂ ꞌbã ị́jọ́. ");
INSERT INTO luc_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","Ãdróŋá ĩꞌdi cécé Írã ũkpó ãma tã mbalépi rĩ áni, ãzị́ ĩꞌdi ꞌbã ngalé rĩ kí pírí ãlá ru ãzíla gẹ̃rị̃ ĩꞌdidrị̂ kí pịrị. Ĩꞌdi Ãdróŋá ãꞌị̃táŋá trũ ị́jọ́ unzí idélépi ku rĩ ꞌi, ĩꞌdi ị́jọ́ pịrị ãzíla ũniyamba rĩ kí nga. ");
INSERT INTO luc_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","“Wó ĩmi ãꞌị̃táŋá kóru, ĩsị adrujó ĩꞌdi ꞌbã anzị ru ku, ĩmi ꞌbá ru izalépi rá ãzíla sụ́rụ́ úlétáŋá ru la. ");
INSERT INTO luc_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","ꞌDĩ gẹ̃rị̃ ĩmi sĩ Úpí ũfẽjó rĩ ꞌi yã, ĩmi ꞌbá azalépi aza-azâ ãzíla ũndũwã kóru ꞌdĩ? Adru ꞌbá ĩmi átẹ́pị rú, ĩmi ũꞌbãlépi nĩ, ĩmi ꞌbãlépi sụ́rụ́ ru rĩ ꞌi ku yã? ");
INSERT INTO luc_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","“Ĩmi ũrã drĩ ílí alịlépi ꞌbo ꞌdã kí ị́jọ́; ĩzị drĩ ꞌbá ĩyõ ĩmi tịlépi rĩ kí ãꞌdu ị́jọ́ idé kí ándrá ru nĩ yã rĩ sĩ, ĩzị ꞌbá ándrá ídu rĩ kí sĩ ĩminí ị́jọ́ ídu rĩ kí ũlũjó. ");
INSERT INTO luc_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","Ãdróŋá Ụrụgá ãndânĩ rĩ fẽ ãngũ sụ́rụ́ ꞌbaní ãwítã rú rĩ kí nĩ; ĩꞌdi mụ ꞌbá pírí ꞌbaní ãngũ sĩ rijó rĩ kí awalé ꞌbo, sĩ ĩꞌbaní lõkókõrí kãlãfe sụ́rụ́ anzị Ịsịrayị́lị̃ drị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","Wó Úpí pẽ anzị Yãkóꞌbõ drị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí adrujó ĩꞌdi ꞌbã ꞌbá ru. ");
INSERT INTO luc_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","“Úpí ịsụ́ kí wãyá co agá ãngũ kõtórõ rú, ꞌbá kóru, ãlụ́kụ́kụ̃ ꞌbã sĩ lijó nĩ rĩ agá. Ũtẽ kí andre ãzíla mba kí tã cécé ĩꞌdi ꞌbã ru mịfị́ ífí tã mbalé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","Cécé yụ́kụ́ ꞌbã ĩꞌdi ꞌbã mvaka kí imbájó sĩ ngajó; ãzíla ĩꞌdi ꞌbã ru ụ́pụ́pị́ kí iréjó sĩ kí rụjó múké-múké rĩ áni, Úpí la Ịsịrayị́lị̃ tãmba sĩ aꞌdéjó ku rĩ gá nĩ. ");
INSERT INTO luc_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","Úpí ꞌde ꞌbá ĩꞌdidrị̂ kí drị̃ nĩ áꞌdụ̂sĩ ãdroŋa ĩnzõ rú rĩ kí kọ́lị. ");
INSERT INTO luc_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","“Fẽ ĩꞌdiní cẹ̃jó ãngũ túpũ rú rĩ kí drị̃ gâsĩ nĩ, ãzíla fẽ ĩꞌdiní ife ífí ámvụ́ agá rĩ kí nalé. Ịsụ́ kí ãnụ́ ásé agá rĩ írã kí agá; ife ĩꞌbadrị́ Mị̃zẹ̃yị́tụ̃ drị̂ nga kí ãngũ írã rú rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","Tị́, ị̃ndrị́ ãzíla kãbĩlõ Bãsánĩ gá rĩ kí lé fẽ ĩyõ rú; kãbĩlógó, ị̃ndrị́ ãzíla tị́ ĩꞌdidrị̂ kí ũniyambamba rú, ngánũ ĩꞌdidrị̂ ndẽ ãlãpĩtĩ sĩ rá ãzíla ꞌbá alagá rĩ ri kí ándrá zãbíbũ idélé ãjị́ ambamba rĩ mvụlé. ");
INSERT INTO luc_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","“ꞌBá Úpí drị̂ zo kí, acájó kí dó kụ́rẹ́nị́, wó drị̃ ũnzĩ rú; use kí ãzíla aga kí dó ãkónã sĩ. Aꞌbe kí Ãdróŋá kí ꞌbãlépi rĩ rá ãzíla gã kí Írã ũkpó trũ kí palépi rĩ úmgbé. ");
INSERT INTO luc_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","Úpí acá ãjã sĩ ĩꞌbaní ãdroŋa ĩnzõ rú rĩ kí ị̃nzị̃jó rĩ sĩ; ãzíla ị́jọ́ ũnzí ĩꞌbã kí idélé rĩ sĩ ũmbã na dó sĩ Ãdróŋá ĩꞌbaní rá. ");
INSERT INTO luc_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","Idé kí ídétáŋá ãdroŋa ĩnzõ rú rĩ ꞌbanî, ãdroŋa úꞌdí ĩꞌbã áyị́pịka ꞌbã kí ị́jọ́ nị̃jó kí drị̃ gá ku la kî, ãdroŋa ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã kí ị́jọ́ ị̃nzị̃lé ku íni la kî. ");
INSERT INTO luc_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","Ĩmi ãvĩ ị́jọ́ Írã ándrá ĩmi tịlépi rĩ drị̃ gá rá, ãzíla Ãdróŋá ũkpó trũ ĩmi palépi rĩ drị̃ gá rá. ");
INSERT INTO luc_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","“Úpí la mụ ị́jọ́ ꞌdĩ ndrelé ꞌbo acá ũmbã sĩ ãzíla gã anzị Ịsịrayị́lị̃ drị̂ kí úmgbé. ");
INSERT INTO luc_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","Úpí jọ, ‘Má icó kí ãzã kolé ị̃dị́ ku, ꞌdã ꞌbã ũngúkú gá ma dó ãꞌdu ị́jọ́ la drụ́zị́ ru idé ĩꞌba rụ́ nĩ yã rĩ ndre, ꞌdĩ kí anzị drị̃ ũnzí, ꞌbá ãzí ãꞌị̃táŋá kóru íni la kî. ");
INSERT INTO luc_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","Fẽ kí mání uꞌálé ãjã sĩ ãdroŋa ꞌdá yụ la kí sĩ, ãzíla fẽ kí ũmbã na ma ãdroŋa ĩꞌbã ãni ĩnzõ rú ãzị́ kọ́lị ꞌdĩ kí sĩ. Ma sụ́rụ́ pịrị kóru la kí ayú sĩ ĩꞌbaní ũmbã fẽjó, ma fẽ la ũmbã ꞌbã ga kí ásị́ gá sụ́rụ́ ị́jọ́ nị̃lépi ku ꞌdĩ kî sĩ. ");
INSERT INTO luc_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","Ũmbã mádrị̂ la akó ãcí áni ãzíla ĩꞌdi ụ̃nọ́kụ̂ ivé ãko drị̃ la gá ꞌdĩ kí abe pírí. Ĩꞌdi ca ụ̃nọ́kụ́ ị̃ndụ́ gá vụ̃rụ̂lé ãzíla ma ꞌbé kí ivé ị̃ndụ́ trũ. ");
INSERT INTO luc_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","Ma lị́kị̃ ãzí ají lị́kị̃ ãzí rĩ drị̃ gá ãzíla ma ꞌé mádrị̂ kí ayú pírí kí ụrụꞌbá gá. ");
INSERT INTO luc_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","Kí mụ ũdrãlé ãbị́rị́ sĩ, ãyánĩ sĩ ãzíla jụ́wẹ̃ sĩ. Ma ãnãkpá ásé agá rĩ kí tị ãpẽ kí uꞌdị́lé ãzíla ị̃nị̃ ũjũ trũ rĩ kí tị ãpẽ kí agalé. ");
INSERT INTO luc_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","Ãꞌdị́ la fẽ ꞌbá kí mụ ũdrãlé gẹ̃rị̃ agâ sĩ, ụ̃rị̃ la fi lị́cọ́ kí agá nĩ. Kãrị́lẹ̃ kí izonzi kí abe kí mụ ũdrãlé, ũrekeŋá kí ĩdranigo kí abe âꞌbe kí ku. ");
INSERT INTO luc_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","Má icó ándrá kí ị̃lị̃kị̃lé pírí ị́jọ́ ꞌdĩ sĩ ꞌbã ãzí icó ándrá dó sĩ ị́jọ́ agálé kí drị̃ gá ku rĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","Wó má icó mẹ́rọ́ꞌbá ĩꞌbadrị̂ kí aꞌbelé sĩ ru ịpị́jó jọjó la ĩndẽ ꞌbá mádrị́ Ịsịrayị́lị̃ drị̂ kí rá la ku, ịsụ́ ꞌdĩ sĩ ma Úpí ꞌi má ụꞌdị́ ꞌbá ꞌdĩ kí ma ꞌi.’ ");
INSERT INTO luc_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","“Ịsịrayị́lị̃ ĩꞌdi sụ́rụ́ ị́jọ́ nị̃lépi ku la, kí ũndũwá kó ru. ");
INSERT INTO luc_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","Icó kí nị̃lé la úndẽ kí ãꞌdu ị́jọ́ sĩ yã rĩ gá ku; icó kí vâ drụ́zị́ nị̃lé la ãꞌdu idé ru nĩ yã rĩ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","ꞌBá ãlu la ꞌbá 1,000 kí ndẽ ãꞌdu ị́jọ́ sĩ jõku ꞌbá ị̃rị̃ kí ꞌbá 10,000 kí dro íngoní ru? Úpí Ãdróŋá ĩꞌbadrị̂ aꞌbe kí rá; ĩꞌdi cécé Írã ũkpó trũ rĩ ꞌbã ru nzejó ĩꞌba rụ́ ꞌdâ rá rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","Mẹ́rọ́ꞌbá ĩꞌbadrị̂ nị̃ kí cé ãdroŋa ĩꞌbadrị̂ kí ũkpõ kóru, adru kí ũkpõ trũ cécé Ãdróŋá Ịsịrayị́lị̃ drị̂ áni ku. ");
INSERT INTO luc_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","Mẹ́rọ́ꞌbá ĩꞌbadrị̂ kí cécé zãbíbũ ife salé ámvụ́ Sõdómũ ꞌbadrị́ Gõmórã be rĩ gá rĩ kî áni. Ífí ĩꞌbã kí kalé rĩ kí ụ̃jị́-ụ̃jị́ ãzíla ãdrákĩ rú; ");
INSERT INTO luc_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","cécé wáyĩnĩ idélé ị̃nị̃ ꞌbã ũjũ sĩ rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","“Úpí ũrã ị́jọ́ mẹ́rọ́ꞌbá ĩꞌbadrị̂ ꞌbã kí idélé rĩ kî; ãzíla ĩꞌdi sáwã pịrị ĩꞌdiní sĩ ĩꞌbaní drị̃rịma fẽjó rĩ tẽ. ");
INSERT INTO luc_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","Úpí la ãrígọ́tị ũfẽ drị̃rịma be nĩ. Sáwã la acá ĩꞌbaní sĩ uꞌdejó rá; ụ́ꞌdụ́ ĩꞌbadrị́ sĩ ị̃lị̃kị̃jó rĩ dó ãni rú ãzíla ụ́ꞌdụ́ kí ị́jọ́ lịjó rĩ dó ãni rú. ");
INSERT INTO luc_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","Úpí la ꞌbá ĩꞌdidrị̂ kí ị́jọ́ lị ãzíla ĩꞌdi ásị́ ị̃gbẹ̃ fẽ ãtiꞌbo ĩꞌdidrị̂ ꞌbaní nĩ, drĩ dó ndre la ũkpó ĩꞌbadrị̂ ukó dó rá ãzíla ꞌbá ãzí ãtíꞌbó ru jõku drị̃lẹ́mgbọ la ace dó ru ku rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","ꞌDã ꞌbã ũngúkú gá, Úpí la dó ꞌbá ĩꞌdidrị̂ kí zị, ‘Ãdroŋa la ĩmi ãni ũkpó trũ ĩminí jõ sĩ ásị́ ꞌbãjó kí drị̃ gá rĩ kí dó íngõlé yã? ");
INSERT INTO luc_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","Ĩfẽ ándrá ãdroŋa ꞌdĩ ꞌbaní úsã ídétáŋá ĩminí idélé rĩ ꞌbadrị̂ nalé ãzíla ĩfẽ ĩꞌbaní wáyĩnĩ mvụlé. Lẽ ãdroŋa ꞌdĩ ꞌbã amụ́ kí dó ĩmi ãzã kolé! Ãzíla ꞌbã angá kí dó ĩmi palé! ");
INSERT INTO luc_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","Ĩndre ma Ãdróŋá ru ma ꞌi; ãdróŋá ãzí ndú la yụ. Ma ꞌbá ꞌdị ma ꞌi ãzíla ma ídri fẽ ma ꞌi. Ma bị́lẹ́mị ꞌbã ma ꞌi, ma ĩꞌdiní fẽ jalé ma ꞌi, ãzíla ꞌbá ãzí áma drị̃ ụtrị́lépi ị́jọ́ mání lẽlé rĩ gá la yụ! ");
INSERT INTO luc_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","Ma áma drị́ inga ꞌbụ̃ gá sĩ ũyõ najó; Ãndá ma Ãdróŋá ídri jãꞌdâ rĩ i, ");
INSERT INTO luc_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","ádrĩ dó ménéŋá má drị́ dị̃lépi dị̃-dị̃ rĩ sị́ jĩ ꞌbo, áma drị́ la ị́jọ́ lịŋá pịrị rĩ idé ra. Ma ãrígọ́tị ũfẽ mẹ́rọ́ꞌbá mádrị̂ kí ụrụꞌbá gá ãzíla ma drị̃rịma fẽ ꞌbá áma ngụ̃lépi ũnzí rĩ ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","ꞌÉ mádrị̂ kí mẹ́rọ́ꞌbá mádrị̂ kí ꞌbã ãrí mvụ; ménéŋá mádrị̂ la ꞌbá áma drị̃ ụtrị́lépi rĩ kí ụꞌdị́ rá. Má icó ꞌbá ãꞌdị́ ꞌdịlépi ma be rĩ kí aꞌbelé ku; kí jõ táni bị́lẹ́mị trũ jõku mãbụ́sụ̃ rú, kí ũdrã rá.’ ");
INSERT INTO luc_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","“Ãyĩkõ ꞌbã fụ ĩmi ĩmi sụ́rụ́ ụ̃nọ́kụ́ gá ꞌdĩ ꞌbá Ãdróŋá drị̂ kí abe, ãꞌdusĩku ĩꞌdi mụ ꞌbá ãtíꞌbó ru ꞌbá ĩꞌdidrị̂ kí ụꞌdị́lépi rĩ ꞌbaní drị̃rịma fẽlé rá. Ĩꞌdi ãrígọ́tị ũfẽ mẹ́rọ́ꞌbá ĩꞌdidrị̂ ꞌba rụ́ rá; ãzíla ĩꞌdi ị́jọ́ ũnzí ꞌbá ĩꞌdidrị̂ ꞌbadrị̂ kí trũ rá.” ");
INSERT INTO luc_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","Mụ́sã amụ́ kí Yósũwã Nụ́nị̃ ngọ́pị be ꞌbá kí drị̃lẹ́ gá úngó ꞌdĩ ngolé, ꞌbá kí dị̃ are sĩ la. ");
INSERT INTO luc_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","Mụ́sã la mụ úngó ꞌdĩ delé ngo agá pírí ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ꞌbo, ");
INSERT INTO luc_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","jọ ĩꞌbaní, “Ụ́ꞌdụ́ pírí sĩ ĩmi ũrã ị́jọ́ ímbátáŋá ãndrũ mání imbálé ĩminí ꞌdĩ drị̃ gá. Ị́jọ́ ꞌdĩ ꞌbã adru ĩminí bị́lẹ́ ị̃ndụ́ lima rú, lẽ ĩmi ímbá sĩ anzị ĩmidrị̂ kí, sĩ ãzị́táŋá sĩlé ꞌdĩ kí vú ũbĩjó. ");
INSERT INTO luc_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","Ímbátáŋá ꞌdĩ ꞌbã adru kí ĩminí ị́jọ́ ãzí ífí kóru la rú ku, ꞌdĩ kí ị́jọ́ ĩminí sĩ adrujó ídri rĩ kî. Ị́jọ́ ꞌdĩ kí ĩminí sĩ uꞌájó ídri rú rĩ kî. Ĩmba kí tã ãzíla ĩmi sĩ uꞌá ílí ãzo rú ãngũ ĩminí mụlé ꞌdụlé ĩmi ãni la rú ĩminí Ị̃yị́ Yõrĩdánĩ zajó ꞌbo rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","Ụ́ꞌdụ́ ꞌdã ꞌbã vúŋá sĩ Úpí jọ Mụ́sã ní, ");
INSERT INTO luc_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“Ímụ ꞌbé Ãbãrị́mụ̃ ãngũ Mụ̃wábụ̃ drị́ ru ndrelépi táwụ̃nị̃ Yẹ̃rị́kọ̃ be rĩ gá, ítụ ꞌBé Nébõ sị́ gâlé, mí undré ãngũ Kãnánĩ drị́ mání mụlé fẽlé anzị Ịsịrayị́lị̃ drị̂ ꞌbaní rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","Mi mụ drãlé ꞌbé ꞌdã drị̃ gá cécé mí ádrị́pị Ãrọ́nị̃ ꞌbã drãjó ꞌBé Họ́rị̃ drị̃ gá rĩ áni, ");
INSERT INTO luc_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","ãꞌdusĩku ĩmi ándrá mí ádrị́pị Ãrọ́nị̃ be ị̃rị̃trá má rụ́ ãꞌị̃táŋá kóru ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃lẹ́ gá. ꞌDĩ ĩminí ándrá adrujó ị̃yị́ Mẹ̃rị́bã drị̂ tị gá, ãni rú táwụ̃nị̃ Kãdẹ́sị̃ drị̂ gá ꞌdĩ ãngũ kõtórõ rú Zínĩ drị̂ gá rĩ sĩ. Ĩmi ị̃nzị̃ ándrá ãlã mádrị̂ ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃lẹ́ gá ku. ");
INSERT INTO luc_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","Ị́jọ́ ꞌdĩ sĩ mi dó ãngũ ꞌdã ndre rá-rá ru, wó mí icó dó filé ãngũ mání mụlé fẽlé anzị Ịsịrayị́lị̃ drị̂ ꞌbaní rĩ gá ku.” ");
INSERT INTO luc_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","ꞌDĩ sụ̃sụ́ nábị̃ Ãdróŋá drị́ Mụ́sã ꞌbã wilé anzị Ịsịrayị́lị̃ drị̂ ꞌbaní ꞌdĩ sĩ drã drĩ ku rú rĩ: ");
INSERT INTO luc_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","“Úpí amụ́ angájó ꞌBé Sĩnáyĩ gâlé ãzíla agá cécé ị̃tụ́ áni Ídõmũ drị̃ gâsĩ; ãzíla fẽ dị̃zã ĩꞌdidrị̂ ní dị̃jó ꞌbá ĩꞌdidrị̂ kí drị̃ gá angájó ꞌBé Pãránĩ gá. Amụ́ mãlãyíkã álĩfũ-álĩfũ abe, ãcí velépi la trũ ĩꞌdi ꞌbã drị́ ãndá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","Úpí lẽ ꞌbá ĩꞌdidrị́ ãlá rĩ kí rá; ãzíla ĩꞌdi ꞌbá ĩꞌdidrị̂ kí tã mba nĩ. Ị́jọ́ ꞌdĩ sĩ ãma ãvụ̃ kí ĩꞌdi ꞌbã pálé gá ãzíla ãma ũbĩ kí ãzị́táŋá ĩꞌdidrị̂ kí vú. ");
INSERT INTO luc_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","Ãma ũbĩ kí ãzị́táŋá ándrá Mụ́sã ꞌbã fẽlé ãmaní rĩ kí vú, ꞌdĩ málĩ ãmbógó tã mbalé ꞌbá Yãkóꞌbõ drị̂ ꞌbaní rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","Úpí acá úpí ru ꞌbá ĩꞌdidrị́ Ịsịrayị́lị̃ kí drị̃lẹ́ gá, sáwã drị̃lẹ́ ꞌbá ꞌbadrị̂ ꞌbã kí ru trajó, sụ́rụ́ Ịsịrayị́lị̃ drị̂ kí abe rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","Mụ́sã jọ ị́jọ́ sụ́rụ́ Rụ́bẹ̃nị̃ drị̂ drị̃ gá, “Lẽ ꞌbá sụ́rụ́ Rụ́bẹ̃nị̃ drị̂ ꞌbã ũdrã kí ku, jõku kí kãlãfe ꞌbã adru were rú ku.” ");
INSERT INTO luc_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","Mụ́sã jọ ị́jọ́ sụ́rụ́ Yụ́dã drị̂ drị̃ gá, “Úpí, mí are Yụ́dã ꞌbã áwáŋá ĩꞌdiní ãzãkoma aꞌị́ agá mídrị́. Mí icí kí sụ́rụ́ Ịsịrayị́lị̃ drị̂ kí abe ꞌbá ãlu rụ́ ị̃dị́, ífẽ ĩꞌdiní ũkpó sĩ mẹ́rọ́ꞌbá kí ndẽjó.” ");
INSERT INTO luc_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","Mụ́sã jọ ị́jọ́ sụ́rụ́ Lẹ́vị̃ drị̂ drị̃ gá, “Tãmímũ mídrị̂ kí Ụ̃rị́mụ̃ mídrị̂ abe kí ꞌbá mídrị́ lẽlé lẽlẽ rĩ ꞌbãni, mí ụ̃ꞌbị̃ ándrá kí Másã gá ãzíla mí ãwã ándrá ĩꞌba abe ị̃yị́ Mẹ̃rị́bã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","ꞌBá Lẹ́vị̃ drị̂ ãꞌị̃ kí ándrá ị́jọ́ mídrị̂ rá ãzíla mba kí ándrá tị icíma mídrị́ ĩꞌba abe rĩ tã rá. Kí ándrá ãrútáŋá ru ími ụrụꞌbá gá ndẽ ĩꞌbaní iꞌdalé ĩꞌbã átẹ́pịka ꞌbaní ádrị́pịka abe, jõku anzịŋá ĩꞌbadrị̂ ꞌbaní rĩ rá. Ũbĩ kí ãzị́táŋá mídrị̂ kí vú ãꞌị̃táŋá sĩ. ");
INSERT INTO luc_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","Kí Yãkóꞌbõ imbá ị́jọ́ lịŋá mídrị̂ sĩ; ãzíla Ịsịrayị́lị̃ imbá ãzị́táŋá mídrị̂ kí sĩ. Kí lũbánĩ ivélé ivé-ívẽ rĩ ꞌbã ími drị̃lẹ́ gá ãzíla ídétáŋá ivélé ivé-ívẽ rĩ abe ãlĩtárĩ mídrị̂ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","Úpí, íwi sụ̃sụ́ sụ́rụ́ Lẹ́vị̃ drị̂ ꞌbaní sĩ zojó ũkpó ru; mí adru ãyĩkõ sĩ ị́jọ́ ĩꞌbaní idelé ĩꞌbã drị́ sĩ rĩ kî sĩ. Mí ịꞌị́ mẹ́rọ́ꞌbá ĩꞌbadrị̂ kí, ífẽ ꞌba angá kí ị̃dị́ ku.” ");
INSERT INTO luc_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","Mụ́sã jọ ị́jọ́ sụ́rụ́ Bénzãmĩnĩ drị̂ drị̃ gá, “ꞌDĩ sụ́rụ́ Úpí ní lẽlé ãzíla tã mbalé nĩ rĩ ꞌi; ĩꞌdi kí ãzã ko ụ́ꞌdụ́ pírí sĩ ãzíla ĩꞌdi adru kí drĩdríŋĩ gá cí.” ");
INSERT INTO luc_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","Mụ́sã jọ ị́jọ́ sụ́rụ́ Yụ̃sụ́fụ̃ drị̂ drị̃ gá, “Úpí ꞌbã wi sụ̃sụ́ ụ̃nọ́kụ́ ĩꞌdidrị̂ drị̃ gá uzogó ũnĩ ambamba ꞌbụ̃ gá ãzíla ị̃yị́ ụ̃nọ́kụ́ ị̃ndụ́ gá vụ̃rụ̂lé rĩ sĩ; ");
INSERT INTO luc_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","ꞌBã wi sụ̃sụ́ ị̃tụ́kã ãlá rĩ sĩ ãkónã ꞌbaní sĩ kajó áyi ãlu-ãlu sĩ; ");
INSERT INTO luc_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","ꞌBã wi sụ̃sụ́ ꞌbé áyị́pịka ꞌbadrị̂ kí drị̃ gá ãzíla ãkónã ꞌbã ka kí sĩ ĩꞌbaní nĩ jãꞌdâ; ");
INSERT INTO luc_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","Lẽ ụ̃nọ́kụ́ ĩꞌbadrị̂ ꞌbã ga pírí ị́jọ́ múké sĩ, Úpí ꞌbã sụ̃sụ́ mũkẽ ĩꞌdidrị̂ wijó ĩꞌdiní ị́jọ́ jọjó angájó mị̃rị́ velépi ãcí sĩ rĩ agâlé rĩ áni, sụ̃sụ́ ꞌdĩ ꞌba amụ́ rilé sụ́rụ́ Yụ̃sụ́fụ̃ drị̂ drị̃ gá, ãꞌdusĩku ĩꞌdi drị̃lẹ́ ádrị́pịka ꞌbadrị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","Ãmbõgõ sĩ Yụ̃sụ́fụ̃ ĩꞌdi cécé mọ́nị̃gọ́ kãjãní rĩ áni; újéke ĩꞌdidrị̂ kí cécé Ụ̃drụ́ ásé agá rĩ drị̂ áni, újéke ĩꞌdidrị̂ kí ãsĩkárĩ álĩfũ-álĩfũ Mãnásẽ drị́ ãzíla Ịfụrayị́mụ̃ drị́ álĩfũ mụdrị́ rĩ áni. Kí ꞌbá ĩꞌbã jĩránĩ rú rĩ kí iré ãzíla dro kpere ụ̃nọ́kụ́ ị̃ndụ́ ꞌbã ãsị̃ agá.” ");
INSERT INTO luc_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","Mụ́sã jọ ị́jọ́ sụ́rụ́ Zãbụ̃lọ́nị̃ drị̂ kí drị̃ gá sụ́rụ́ Ĩsãkárĩ drị̂ be, “Zãbụ̃lọ́nị̃ ĩmi adru drị̃lẹ́ba rú bĩsírã sĩ ĩminí acị́ agá ị̃yị́ drị̃ gá ꞌdâ ãzíla Ĩsãkárĩ ꞌbaní málĩ ꞌbã ga ĩmidrị́ lị́cọ́ agá tré. ");
INSERT INTO luc_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","Kí ꞌbá kí umve ĩꞌba rụ́ ꞌbé agâlé ãzíla kí fẽtáŋá ídétáŋá ru múké rĩ kí fẽ; kí málĩ ịsụ́ angájó ị̃yị́ agá ãzíla cínákí agá ị̃yị́ tị gâsĩ.” ");
INSERT INTO luc_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","Mụ́sã jọ ị́jọ́ sụ́rụ́ Gádĩ drị̂ drị̃ gá, “Ĩmi ịcụ́ Ãdróŋá ꞌi, ĩꞌdi ꞌbá ãngũ ĩmidrị̂ nzị̃lépi ãmbógó ru rĩ ꞌi! Gádĩ mi adru cécé kẹ̃mị̃ áni ꞌbá kí drị́ jõku drị̃kã ucíjó. ");
INSERT INTO luc_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","ꞌDụ ụ̃nọ́kụ́ ãlá ãndânĩ rĩ ĩꞌdinî; sáwã drị̃lẹ́ka Ịsịrayị́lị̃ drị̂ ꞌbã kí ru trajó ãngũ ãlu gá rĩ gá, úfẽ ĩsélé ãngũ drị̃lẹ́ drị̂ ĩꞌbadrị́ ĩꞌdi ị́jọ́ lịŋá pịrị Úpí drị̂ nga ãzíla ĩꞌdi ãzị́táŋá fẽlé Ịsịrayị́lị̃ ní rĩ kí tã mba.” ");
INSERT INTO luc_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","Mụ́sã jọ ị́jọ́ sụ́rụ́ Dánĩ drị̂ drị̃ gá, “Dánĩ ĩꞌdi cécé kẹ̃mị̃ mváŋá áni; ĩꞌdi amvú ãmvé angájó Bãsánĩ gá rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","Mụ́sã jọ ị́jọ́ sụ́rụ́ Nãfũtálĩ drị̂ drị̃ gá, “Úpí ꞌbã ásị́ ị̃gbẹ̃ ĩꞌdi sụ́rụ́ Nãfũtálĩ drị̂ drị̃ gá, fẽ ĩꞌbaní drị̃lẹ́ba sĩ; ãngũ angájó ándrá kpere ị̃yị́ Gãlị́lị̃ gá rĩ ꞌdụjó.” ");
INSERT INTO luc_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","Mụ́sã jọ ị́jọ́ sụ́rụ́ Ásẹ̃rị̃ drị̂ drị̃ gá, “Drị̃lẹ́ba ãndânĩ rĩ Ãdróŋá ꞌbã fẽ ꞌba adru anzị Ásẹ̃rị̃ drị̂ ꞌbanî, ádrị́pịka ꞌbã lẽ kí ĩꞌdi pírí lẽlẽ, lẽ úsu ĩꞌdi ãdu Mị̃zẹ̃yị́tụ̃ drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","Táwụ̃nị̃ mídrị̂ ꞌbã kẹ̃jị́tị ꞌbã adru ũkpó ru aya sĩ ãzíla bũrônzĩ sĩ, mi dó sĩ ími andre ũtẽ ũkpó ru ụ́ꞌdụ́ pírí sĩ.” ");
INSERT INTO luc_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","“Ĩmi ꞌbá Ịsịrayị́lị̃ drị́ ꞌdĩ, ãdróŋá ãzí cécé Ãdróŋá ĩmidrị̂ áni, cẹ̃lépi ꞌbụ̃ gâsĩ ĩmi ãzã kolépi ũkpó ĩꞌdidrị̂ sĩ, ụ̃rụ́ꞌbụ̃ agâ sĩ rĩ áni la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","Ãdróŋá ĩꞌdi ꞌbá ĩminí sĩ apájó ĩmi zị̃jó ĩꞌdi rụ́ rĩ ꞌi, ãzíla aja ĩꞌdi ꞌbã drị́ ĩmi drị̃ gá sĩ ĩmi tã mbajó jãꞌdâ. Ĩꞌdi mẹ́rọ́ꞌbá kí adro ĩmi drị̃lẹ́ gá rĩ sĩ rá jọjó la, ‘Ĩmi ụꞌdị́ kî!’ ");
INSERT INTO luc_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","Ị́jọ́ ꞌdĩ sĩ Yãkóꞌbõ la dó sĩ uꞌá ásị́ ị̃gbẹ́ agá ị́jọ́ kóru, kídí Yãkóꞌbõ drị̂ lú ĩꞌdi ãni áꞌdụ̂sĩ ãngũ múké ãná trũ ãzíla wáyĩnĩ trũ, ꞌbụ̃ ꞌbã sĩ andrẹlị́ ũsũjó drị̃ la gá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","Drị̃lẹ́ba ĩminî, ĩmi ꞌbá Ịsịrayị́lị̃ drị́ ꞌdĩ, ꞌbá ãzí ĩmi áni la cí yã? ꞌBá ãzí cécé ĩmi áni Úpí ꞌbã tã mbalé nĩ la ꞌdáyụ. Úpí ĩꞌdi gọ́bẹ́rẹ́ ãzíla ménéŋá ĩmidrị̂ ꞌi ĩꞌdi ĩmi tãmba ãzíla ĩmi fẽ ãꞌdị́ ndẽlé. Mẹ́rọ́ꞌbá ĩmidrị̂ kí amụ́ mãmálá ꞌbãlé ĩmi rụ́ sĩ ásị́ ị̃gbẹ̃ ịsụ́jó ãzíla ĩmi kí ndẽ rá.” ");
INSERT INTO luc_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","ꞌDã ꞌbã ũngúkú gá, Mụ́sã angá ãngũ gbayi Mụ̃wábụ̃ drị̂ gá sĩ tụjó ꞌBé Nébõ sị́ gá. Mụ ꞌBé Pị́sị̃gã ꞌbã drị̃ mbílí rĩ gá ꞌdĩ Yẹ̃rị́kọ̃ ꞌbã wókõ ị̃tụ́ ꞌbã ãfũ agâlé ru rĩ gá. ꞌDãá Úpí iꞌda ĩꞌdiní ãngũ ꞌdã ꞌi pírí angájó Gị̃lẹ́dị̃ gá kpere Dánĩ gá, ");
INSERT INTO luc_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","ãngũ Nãfũtálĩ drị̂ gá pírí, ãngũ Ịfụrayị́mụ̃ ꞌbadrị́ Mãnásẽ be rĩ kí, ãngũ Yụ́dã drị̂ pírí kpere ị̃yị́ ị̃tụ́ ꞌbã ꞌde agâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Úpí iꞌda Mụ́sã ní ãngũ umvelé Nẹ̃gẹ́vụ̃ ꞌi rĩ ãzíla áꞌbụ Yẹ̃rị́kọ̃ drị́ táwụ̃nị̃ káci drị̂ ꞌi kpere ãngũ Zówã drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Mụ́sã ní, “ꞌdĩ ãngũ mání ándrá azịlé mání sĩ ũyõ najó mã mụ fẽlé la Ịbụrahị́mụ̃ ní, Ĩsákã ní ãzíla Yãkóꞌbõ ní mání jọjó la, ‘Ma mụ ĩꞌdi fẽlé anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbaní rĩ ꞌi.’ Áfẽ ĩꞌdi ndrelé míní mịfị́ sĩ, wó mí icó calé ala gâlé ku.” ");
INSERT INTO luc_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Ị́jọ́ ꞌdĩ sĩ ãtíꞌbó Úpí drị́ Mụ́sã uja dó drãlé Mụ̃wábụ̃ gá ꞌdãá cécé ándrá Úpí ꞌbã jọlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Úpí ị̃sị̃ dó ĩꞌdi Mụ̃wábụ̃ gá ꞌdãá, áꞌbụ gá ãngũ Mụ̃wábụ̃ ꞌbadrị́ tị ru ndrelépi Bẹ̃tị̃pẹ̃yọ́rị̃ be rĩ gá, wó kpere ãndrũ ꞌbá ãzí ndre ĩꞌdi ꞌbã ĩnádrị̃ ku. ");
INSERT INTO luc_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Sáwã Mụ́sã ꞌbã ándrá drãjó rĩ sĩ, ílí la 120, ịsụ́ ꞌdĩ sĩ mịfị́ la ace kí ru ídri ãzíla ụrụꞌbá la ũkpó ru. ");
INSERT INTO luc_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Anzị Ịsịrayị́lị̃ drị̂ awá kí Mụ́sã ꞌi ãngũ gbayi Mụ̃wábụ̃ drị̂ gá ụ́ꞌdụ́ kãlị́ na kpere ụ́ꞌdụ́ áwáŋá drị̂ ꞌbã kí ukó agá. ");
INSERT INTO luc_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","ꞌDã ꞌbã ũngúkú gá, úríndí ũndũwã drị̂ tõ dó ru Yósũwã Nụ́nị̃ ngọ́pị agá ãꞌdusĩku Mụ́sã tị̃ ándrá drị́ ĩꞌdi drị̃ gá rá. Ị́jọ́ ꞌdĩ sĩ, ꞌbá Ịsịrayị́lị̃ drị̂ ị̃nzị̃ kí ĩꞌdi rá ãzíla nga kí ị́jọ́ kí cécé Úpí ꞌbã ándrá azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Iꞌdójó ụ́ꞌdụ́ ꞌdã sĩ, nábị̃ ãzí ãfũlépi Ịsịrayị́lị̃ gá Úpí ꞌbã sĩ ị́jọ́ jọjó ĩꞌdi be mịfị́ gá-mịfị́ gá Mụ́sã áni la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","Nábị̃ ãzí ndú Úpí ꞌbã tị pẽlé tálí kí idéjó ị́jọ́ ụ̃sụ̃táŋá ru rĩ kí abe Mị̃sị́rị̃ gá Fãráwũ drị̃lẹ́ gá ãmbogo ĩꞌdidrị̂ kí abe, ãzíla sụ́rụ́ ĩꞌdidrị̂ drị̃ gá pírí cécé Mụ́sã áni la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Nábị̃ ãzí ndú ị́jọ́ ũkpó ãzíla ícétáŋá ụ̃rị̃ fẽlépi rĩ kí ngalépi Mụ́sã drị̂ áni ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃ gâsĩ la ꞌdáyụ.");
INSERT INTO luc_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Ãtíꞌbó Úpí drị́ Mụ́sã la dó mụ drãlé ꞌbo, Úpí jọ Yósũwã Nụ́nị̃ ngọ́pị ándrá Mụ́sã ãzã kolépi rĩ ní, ");
INSERT INTO luc_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Ãtíꞌbó mádrị́ Mụ́sã drã dó ꞌbo. Ị́jọ́ ꞌdĩ sĩ mi ꞌi ãzíla ꞌbá pírí Ịsịrayị́lị̃ drị̂ kí abe ĩmi adru dó bábá sĩ mĩrĩ Yõrĩdánĩ zajó, ĩmi dó sĩ mụ filé ãngũ mání mụlé fẽlé ĩmi ꞌbá Ịsịrayị́lị̃ rú ꞌdĩ ꞌbaní rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Ma mụ ãngũ pírí ĩminí sĩ pá ꞌbãjó ala gá ꞌbo rĩ kí fẽlé ĩminí cécé mání ándrá azịlé Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Iꞌdójó kõtórõ Nẹ̃gẹ́vụ̃ drị̂ gá ándrá cajó ãngũ ꞌbé ꞌa rú Lébãnõnĩ drị̂ gá ụ́rụ́, angájó mĩrĩ Ũfũrátĩ drị̂ gá ị̃tụ̂ ꞌbã ãfũ agâlé ru cajó mĩrĩ Mẽdĩtẽránĩyãnĩ drị̂ gá ị̃tụ̂ ꞌbã ꞌde agâlé ru, umú ãngũ ꞌbá Hị́tị̃ rú rĩ ꞌbadrị̂ pírí ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Ụ́ꞌdụ́ míní adrujó ídri rú rĩ kí agá pírí, mẹ́rọ́ꞌbá ãzí ãlu la icó ími ndẽlé ku. Cécé ándrá mání adrujó Mụ́sã be rĩ áni, ma vâ mụ adrulé mí be ꞌdã ꞌbã áni. Má icó ími aꞌbelé ku, má icó vâ ími gãlé ku. ");
INSERT INTO luc_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Mí adru ũkpó ru ãzíla ími ásị́ ꞌbã mba-mbã ãꞌdusĩku mi mụ ꞌbá ꞌdĩ kí drị̃ celé sĩ mụjó ãngũ ándrá mání ũyõ la najó ma fẽ la ĩꞌbã áyị́pịka ꞌbaní ãwítã rú rĩ ꞌdụjó. ");
INSERT INTO luc_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Mí adru jõ ũkpó ru ãzíla ími ásị́ ꞌbã mba jõ ũkpómgboroto rú sĩ ị́jọ́ kí idéjó ásị́ pírí sĩ, mí adru jõ mịfị́ trũ sĩ ãzị́táŋá ãtíꞌbó Mụ́sã ꞌbã azịlé míní rĩ kí tá mbajó pírí; mí uja jõ mi kí agá rĩ sĩ drị́ ãndá gá ku jõku drị́ ị̃jị́ gá ku, ị́jọ́ ꞌdĩ sĩ mi dó sĩ adru drị̃lẹ́ba rú ãngũ cí míní mụjó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Lẽ ílã bụ́kụ̃ ãzị́táŋá drị́ ꞌdĩ ụ́ꞌdụ́ pírí sĩ, mí ũrã ị́jọ́ drị̃ la gá ị̃tụ́ kí ị́nị́ be, ị́jọ́ ꞌdĩ sĩ mi dó sĩ adru mịfị́ trũ sĩ ị́jọ́ sĩlé ala gá ꞌdĩ kí idéjó pírí. ꞌDã ꞌbã ũngúkú gá, mi dó sĩ adru málĩ trũ ãzíla drị̃lẹ́ba rú ị́jọ́ pírí míní ngalé rĩ kí agá. ");
INSERT INTO luc_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Má azị ándrá míní lẽ mí adru ũkpó ru ãzíla ími ásị́ ꞌbã mba-mbã rĩ gá ku yã? Mí idé ụ̃rị̃ sĩ ku, ími ásị́ ꞌba umvú ku, ãꞌdusĩku Úpí Ãdróŋá mídrị̂ la adru mí be ãngũ cí míní mụjó rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","ꞌDã ꞌbã ũngúkú gá, Yósũwã azị dó ị́jọ́ ꞌbá ãmbogo rú Ịsịrayị́lị̃ drị̂ ꞌbaní jọ, ");
INSERT INTO luc_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Ĩmụ kámbĩ agâsĩ ãzíla ĩmi ũlũ ꞌbá ꞌbaní, ‘Ĩmi itú ĩmi bábá ãko ĩmidrị̂ kî trũ ãꞌdusĩku ụ́ꞌdụ́ na vúlé gá ĩmi mụ mĩrĩ Yõrĩdánĩ zalé sĩ mụjó ãngũ Úpí Ãdróŋá ĩmidrị̂ ꞌbã mụlé fẽlé ĩmi ãni la rú rĩ ꞌdụjó.’” ");
INSERT INTO luc_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Yósũwã jọ sụ́rụ́ Rụ́bẹ̃nị̃ drị́, Gádĩ drị́ ãzíla sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ ꞌbaní, ");
INSERT INTO luc_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“Ĩmi agá drĩ ị́jọ́ ãtíꞌbó Úpí drị́ Mụ́sã ꞌbã azịlé ĩminí ĩꞌdi ꞌbã sĩ jọjó la ‘Úpí Ãdróŋá ĩmidrị̂ la ĩminí ãngũ sĩ avị́jó la fẽ rĩ, ãzíla fẽ ĩminí ãngũ lê ꞌbo.’ ");
INSERT INTO luc_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Ũkú ĩmidrị̂ kí, anzị ĩmidrị̂ kí ãzíla ãnãkpá ĩmidrị̂ kí abe kí mụ acelé ãngũ Mụ́sã ꞌbã fẽlé ĩminí mĩrĩ Yõrĩdánĩ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru ꞌdĩ gá ꞌdâ, wó ãgọbị ãꞌdị́ drị̂ kí mụ drị̃ gá sĩ ĩmi ádrị́pịka kí ãzã kojó sĩ kí irijó ãngũ ĩꞌbadrị̂ kí agá, ");
INSERT INTO luc_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","kpere Úpí ꞌbã ĩmi ádrị́pịka ꞌbaní ávị́ŋá fẽ agá cécé ĩꞌdi ꞌbã fẽjó la ĩminí avị́jó rĩ áni ãzíla ĩꞌbaní ãngũ Úpí Ãdróŋá ĩmidrị̂ ꞌbã fẽlé ĩꞌbaní rĩ ꞌdụjó rĩ áni. ꞌDã ꞌbã ũngúkú gá, ĩmi dó sĩ gõ ãngũ ĩminí ꞌdụlé ĩmi ãni la rú rĩ gá, ꞌdĩ ãngũ ãtíꞌbó Úpí drị́ Mụ́sã ꞌbã fẽlé ĩminí Yõrĩdánĩ ꞌbã wókõ ị̃tụ́ ꞌbã ãfũ agâlé ru rĩ gá rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Umvi kí Yósũwã ní, “Ị́jọ́ pírí míní azịlé rĩ kí ãma kí nga rá ãzíla ãngũ cí míní ãma tị pẽjó rĩ gá ãma mụ rá. ");
INSERT INTO luc_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Cécé ãmaní ándrá Mụ́sã ꞌbã tị arejó ị́jọ́ pírí kí agá rĩ áni, ị́jọ́ ꞌdĩ sĩ ãma vâ ími tị are rá. Úpí Ãdróŋá mídrị̂ ꞌba adru mí be cécé ĩꞌdi ꞌbã ándrá adrujó Mụ́sã be rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","ꞌBá ị́jọ́ míní azịlé rĩ kí gãlépi úgmbé ãzíla ími tị arelépi ku, ị́jọ́ míní jọlé rĩ ngalépi ku rĩ lẽ úꞌdị ĩꞌdi rá. Mí adru ũkpó ru ãzíla ími ásị́ ꞌbã mba-mbã.” ");
INSERT INTO luc_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","ꞌDã ꞌbã ũngúkú gá, Yósũwã Nụ́nị̃ ngọ́pị pẽ dó ãgọbị ị̃rị̃ ũní-ũníŋá gá rĩ kí tị Sị̃tị́mụ̃ gá ꞌdãá rĩ sĩ ãzíla jọ ĩꞌbaní, “Ĩmụ, ĩmi undré ãngũ Yẹ̃rị́kọ̃ drị̂ ꞌa.” Ị́jọ́ ꞌdĩ sĩ bá ꞌdĩ mụ kí dó rá ãzíla fi kí dó ũkú ãwụ́ꞌbá ru umvelé Rãhábụ̃ rĩ drị́ jó agá ãzíla ko kí dó sĩ ụ́ꞌdụ́ ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Wó ꞌbá ãzí lũ ị́jọ́ ꞌdĩ úpí Yẹ̃rị́kọ̃ drị̂ ní, “Índre úpí, ãgọbị ãzí ị̃rị̃ Ịsịrayị́lị̃ rú la amụ́ kí tá ị́nị́ ãndrũ rĩ sĩ ãngũ ãmadrị̂ undrélé ũní-ũní ru.” ");
INSERT INTO luc_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Ị́jọ́ ꞌdĩ sĩ úpí Yẹ̃rị́kọ̃ drị̂ pẽ dó sĩ ꞌbá ãzí kí tị Rãhábụ̃ drị́ko gâlé ãzíla jọ, “Mí íyá ãgọbị tá amụ́lépi filépi mídrị́ jó agá ꞌdâ rĩ kí fẽlé ãmadrị́, ãꞌdusĩku amụ́ kí ãngũ ãmadrị̂ ị̃ndụ́ ndrụ̃ trũ.” ");
INSERT INTO luc_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Wó ũkú ꞌdĩ ꞌdụ dó ãgọbị ị̃rị̃ ꞌdĩ kí zị̃lé cí. Jọ dó ꞌbá ꞌdã ꞌbaní, “Ãndá ãgọbị ꞌdĩ amụ́ kí má rụ́ ꞌdộ rá, wó ánị̃ angá kí íngõlé yã rĩ gá ku. ");
INSERT INTO luc_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Sáwã sĩ kẹ̃jị́tị ụ̃pị̃jó ị́nị́ sĩ rĩ la mụ acálé ꞌbo, ãgọbị ꞌdĩ fũ kí mụlé rá. Ĩdro kí vú mbẽlẽ-mbẽlẽ ãꞌdusĩku ĩmi icó tá drĩ kí arụ́lé rá.” ");
INSERT INTO luc_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Wó ũkú ꞌdĩ zị̃ dó ãgọbị Ịsịrayị́lị̃ rú ꞌdĩ kí pálá céke ĩꞌdi ꞌbã ũdrõlé jó drị̃ gá rĩ kí agá. ");
INSERT INTO luc_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Ị́jọ́ ꞌdĩ sĩ ãgọbị ꞌdĩ dro kí dó kí vú gẹ̃rị̃ mụlépi Yõrĩdánĩ gâlé ru rĩ gâsĩ kpere ị̃yị́ tị cene sĩ zajó rĩ gá. ꞌBá kí vú drolépi rĩ kí mụ fũlé ꞌbo cọtị ûpị̃ dó kẹ̃jị́tị sĩ fijó táwụ̃nị̃ agâlé rĩ cí. ");
INSERT INTO luc_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Ãgọbị Ịsịrayị́lị̃ rú ị̃rị̃ ꞌdã la kí drĩ ru ụ́ꞌdụ́ gá ku rú, Rãhábụ̃ mụ ĩꞌba rụ́ ụrụ gâlé ");
INSERT INTO luc_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","ãzíla jọ ĩꞌbaní, “Ánị̃ rá Úpí fẽ ĩminí ãngũ ꞌdĩ ꞌbo ãzíla ụ̃rị̃ rụ ãma cí ĩmi ị́jọ́ sĩ, ꞌbá pírí ꞌdâ rĩ kí ásị́ mvu ĩmi ị́jọ́ sĩ rá, ");
INSERT INTO luc_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","ãꞌdusĩku ãma are ị́jọ́ Úpí Ãdróŋá ꞌbã mĩrĩ ika rĩ awajó ĩminí sáwã ándrá ĩminí angájó Mị̃sị́rị̃ gâlé rĩ sĩ, sĩ zajó rĩ kí rá ãzíla ị́jọ́ ĩminí idélé ũpi ị̃rị̃ Ãmọ́rị̃ drị́ Sị̃họ́nị̃ ꞌba rụ́ Ụ́gị̃ be sĩ kí ị̃lị̃kị̃jó Yõrĩdánĩ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agá ꞌá ꞌdã sĩ rĩ rá. ");
INSERT INTO luc_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Ãma dó mụ ị́jọ́ ꞌdĩ kí arelé ꞌbo, ãma ásị́ mvu rá ãzíla ãma ũkpó ukó ãma rú ꞌdâ rá ãꞌdusĩku Úpí Ãdróŋá ĩmidrị̂ ꞌbã adrujó Ãdróŋá ꞌbụ̃ gá ãzíla ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ ꞌi rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Ị́jọ́ ꞌdĩ sĩ álẽ ĩna ũyõ rụ́ Úpí drị̂ sĩ ĩmi drụ́zị́ ásị́ ị̃gbẹ̃ iꞌda lị́cọ́ mâ átẹ́pị drị̂ ní cécé mání iꞌdalé ĩminí ꞌdĩ ꞌbã áni. Ĩꞌbã mání ícétáŋá ãzí nị̃jó la ");
INSERT INTO luc_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","ĩmi drụ́zị́ mâ átẹ́pị kí aꞌbe mâ ãndrẽ be, mâ ádrị́pịka kí abe mâ ámvọ́pịka kí abe ãzíla kãká ĩꞌbadrị̂ kí abe ídri, ĩmi icó kí ụꞌdị́lé ku.” ");
INSERT INTO luc_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Ãgọbị ị̃rị̃ Ịsịrayị́lị̃ rú ꞌdĩ jọ kí, “Ídri ãmadrị̂ kí adru ídri ĩmidrị̂ kí tị gá! Ídrĩ ị́jọ́ ãmaní amụ́jó ꞌdâ rĩ lũ ꞌbá ãzí ꞌbaní ku rĩ gá, ị́jọ́ ꞌdĩ sĩ Úpí drĩ ãngũ ꞌdĩ fẽ ãmaní rá, ãma míní ásị́ ị̃gbẹ̃ ãzíla ị́jọ́ pịrị rĩ iꞌda rá.” ");
INSERT INTO luc_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","ꞌDã ꞌbã ũngúkú gá, Rãhábụ̃ asú dó ãgọbị ꞌdĩ kí dẹ̃rị́sã gâsĩ ãzíla ịsị́ dó kí vụ̃rụ́ ꞌdõlé ĩbáká sĩ ãꞌdusĩku jó ĩꞌdi ꞌbã ándrá sĩ uꞌájó rĩ icí kí ru Bõrõ sĩ táwụ̃nị̃ andre cejó rĩ be. ");
INSERT INTO luc_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Jọ ĩꞌbaní, “Ĩmi apá ꞌbé agâlé ꞌbá ĩmi vú drolépi ꞌdã ꞌbã ịsụ́ kí sĩ ĩmi ku. Ĩzị̃ ĩmi ꞌdãá ụ́ꞌdụ́ na kpere ꞌbá ĩmi vú drolépi ꞌdã ꞌbã kí ãgõ agá. ꞌDã ꞌbã vúlé gá ĩmi dó sĩ mụ ãngũ ĩmidrị̂ gâlé ĩndõ.” ");
INSERT INTO luc_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Ãgọbị ꞌdĩ jọ kí ĩꞌdiní, “Ũyõ ãmaní nalé ꞌdĩ la ãma rụ rá la ídrĩ ị́jọ́ ãmaní azịlé míní ꞌdĩ kí tã mba rá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Ãdrĩ dó amụ́ ãngũ ꞌdĩ gá ꞌbo, mí umbé dó ĩbáká ika la ãzíla mí asú ĩꞌdi dẹ̃rị́sã ándrá míní sĩ ãma ịsị́jó ĩbáká sĩ ãmvé ꞌdĩ gâsĩ, mí atrá mî átẹ́pị kí mî ãndrẽ be, mî ádrị́pịka kí mî ámvọ́pịka kí abe ãzíla kãká mídrị̂ kí abe pírí mídrị́ jó agá ꞌdâ. ");
INSERT INTO luc_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","ꞌDã ꞌbã ũngúkú gá, ꞌbá ãzí drĩ fũ mídrị́ jó agá ꞌdâ rĩ sĩ ãmvé mụlé gẹ̃rị̃ agâlé drĩ dó sĩ drã rá yã áni, ãrí la adru dó sĩ ãma drị̃ gá ku, ĩꞌdi adru ĩꞌdi ãmgbã rĩ drị̃ gá. Wó údrĩ ꞌbá ãzí mídrị́ jó agá ꞌdâ fũlépi ãmvé ku la ꞌdị yã áni, ãrí la la adru ãma drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Wó ídrĩ ị́jọ́ ãmaní itúlé sĩ ũyõ najó ꞌdĩ lũ ꞌbá ãzí ní rá, ãma adru ị́jọ́ kóru ũyõ ĩminí fẽlé nalé ãmaní rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Rãhábụ̃ jọ, “Ị́jọ́ ꞌdĩ ꞌba adru ĩminí jọlé ꞌdĩ ꞌbã áni.” ꞌDã ꞌbã ũngúkú gá, pẽ dó kí tị mụlé rá ãzíla umbé dó sĩ ĩbáká ika ꞌdã dẹ̃rị́sã gá ꞌdãá cí. ");
INSERT INTO luc_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Ãgọbị ị̃rị̃ ꞌdĩ zị̃ kí dó ru ꞌbé agá ꞌdãá ụ́ꞌdụ́ na kpere ꞌbá kí vú drolépi rĩ ꞌbã kí gõ agá táwụ̃nị̃ agâlé vúlé. ꞌBá tị pẽlé rĩ ndrụ̃ kí dó kí gẹ̃rị̃ pírí kí agâsĩ wó ịsụ́ kí ꞌbá ãzí ãlu la ku. ");
INSERT INTO luc_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","ꞌDã ꞌbã ũngúkú gá, ꞌbá ị̃rị̃ ꞌdĩ gõ kí dó rá. Ãfũ kí dó ꞌbé agâlé rĩ sĩ za kí dó sĩ Yõrĩdánĩ ꞌi ãzíla mụ kí dó Yósũwã Nụ́nị̃ ngọ́pị rụ́ ãzíla ũlũ kí dó ĩꞌdiní ị́jọ́ pírí ru idélépi kí ụrụꞌbá gá rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Jọ kí Yósũwã ní, “Ãndá-ãndá ru Úpí fẽ ãngũ ꞌdã pírí ãmadrị́ gá ꞌbo. Fẽ vâ ꞌbá pírí alagá rĩ kí ásị́ mvu ãma ị́jọ́ sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Ụ̃ꞌbụ́tịnị́nị́, Yósũwã kí ꞌbá Ịsịrayị́lị̃ drị̂ kí abe pírí aꞌbe kí dó Sị̃tị́mụ̃ rá. Mụ kí dó sĩ mĩrĩ Yõrĩdánĩ gâlé ru ãzíla tra kí dó ru tị la gá ꞌdãá za kí drĩ ku rú. ");
INSERT INTO luc_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Ụ́ꞌdụ́ na la ꞌbã ukóŋá gá, ꞌbá drị̃lẹ́ ru rĩ acị́ kí dó kámbĩ agâsĩ ");
INSERT INTO luc_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","sĩ ãzị́táŋá fẽjó ꞌbá ꞌbaní ãzíla jọ kí, “Ĩdrĩ dó ãtalo Lẹ́vị̃ rú rĩ kí ndre Sãndụ́kụ̃ tị icíma drị́ Úpí Ãdróŋá ĩmidrị̂ drị̂ ꞌdụ agâ drị́ gá, ĩmi aꞌbe dó ãngũ ĩminí adrujó rĩ rá ãzíla ĩꞌde dó kí vú gâsĩ. ");
INSERT INTO luc_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Ĩmi dó sĩ gẹ̃rị̃ ĩminí mụjó rĩ nị̃ cé ãꞌdusĩku ĩminí jõ drĩ ídu mụjó lé ru ku rĩ sĩ. Wó lẽ ãngũ ĩmi drĩdríŋĩ gá Sãndụ́kụ̃ tị icíma drị̂ be rĩ ꞌba adru ãnirú kị́lọ̃ mítã ãlu ꞌdĩ pí, lẽ ĩmi adru dó sĩ ĩꞌdĩ be ãni rú ku.” ");
INSERT INTO luc_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Yósũwã jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ĩmi idé ĩmi ãlá ru ãꞌdusĩku Úpí la mụ drụ̃sị̃ ị́jọ́ ãzí ụ̃sụ̃táŋá ru la idélé ĩmi drĩdríŋĩ gá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Yósũwã jọ ãtalo ꞌbaní, “Ĩꞌdụ Sãndụ́kụ̃ tị icíma drị̂ ãzíla ĩmi alị ꞌbá kí drị̃lẹ́ gá.” Ị́jọ́ ꞌdĩ sĩ ꞌdụ kí dó Sãndụ́kụ̃ tị icíma drị̂ ãzíla mụ kí dó sĩ ꞌbá kí drị̃lẹ́ gâlé. ");
INSERT INTO luc_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Úpí jọ Yósũwã ní, “Ãndrũ ma dó mụ iꞌdólé ími ingalé ụrụgá Ịsịrayị́lị̃ kí drị̃lẹ́ gá, ị́jọ́ ꞌdĩ sĩ kí dó sĩ nị̃ la rá ma ándrá Mụ́sã be ãzíla ma vâ úꞌdîꞌda mí be cí. ");
INSERT INTO luc_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Mí azị ị́jọ́ ꞌdĩ ãtalo Sãndụ́kụ̃ tị icíma drị̂ ꞌdụlépi rĩ ꞌbaní, ‘Ĩdrĩ ca ị̃yị́ Yõrĩdánĩ drị̂ tị gá ꞌbo, ĩtu pá ị̃yị́ agá ꞌdãá cí.’” ");
INSERT INTO luc_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","ꞌDã ꞌbã ũngúkú gá, Yósũwã jọ dó ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ĩmi amụ́ ꞌdộ ãzíla ĩmi are ị́jọ́ Úpí Ãdróŋá ĩmidrị̂ ꞌbã jọlé rĩ.” ");
INSERT INTO luc_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Yósũwã jọ, “Gẹ̃rị̃ ꞌdĩ sĩ ĩmi dó sĩ nị̃ la Ãdróŋá ídri rĩ ĩmi abe cí ãzíla ĩcẽ ꞌbá Kãnánĩ rú, Hị́tị̃ rú, Hị́vị̃ rú, Pẹ̃rẹ́zị̃ rú, Gị̃rị̃gásị̃ rú, Ãmọ́rị̃ rú ãzíla Yẹ̃bụ́sị̃ rú rĩ kí dro agá ĩmi drị̃lẹ́ gá ku. ");
INSERT INTO luc_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Ĩndre Sãndụ́kụ̃ tị icíma drị́ Úpí ụ̃nọ́kụ́ drị̃ gá ꞌdâ pírí rĩ drị̂ la ĩmi drị̃ ce sĩ mĩrĩ Yõrĩdánĩ za jó. ");
INSERT INTO luc_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Ị́jọ́ ꞌdĩ sĩ úꞌdîꞌda mí aꞌdụ́ ãgọbị kí ãlu-ãlu ínátị mụdrị́ drị̃ ị̃rị̃ sụ́rụ́ Ịsịrayị́lị̃ drị́ ꞌdĩ kí agá ꞌdâ. ");
INSERT INTO luc_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Ãtalo Sãndụ́kụ̃ tị icíma drị́ Úpí ụ̃nọ́kụ́ drị̃ gá ꞌdâ pírí rĩ drị̂ ꞌdụlépi rĩ drĩ kí dó pá su mĩrĩ Yõrĩdánĩ agá ꞌbo, ị̃yị́ Yõrĩdánĩ drị̂ la dó ru awa ị̃rị̃ ãzíla ị̃yị́ dịlépi rĩ la dó pá tu Bõrõ áni ãngũ ãlu gá.” ");
INSERT INTO luc_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","ꞌBá Ịsịrayị́lị̃ drị̂ aꞌbe kí dó hémã ĩꞌbadrị̂ kí rá sĩ Yõrĩdánĩ zajó ãzíla ãtalo Sãndụ́kụ̃ tị icíma drị̂ ꞌdụlépi rĩ ꞌde kí dó kí drị̃ nĩ. ");
INSERT INTO luc_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Ãtalo Sãndụ́kụ̃ tị icíma drị̂ ꞌdụlépi rĩ kí mụ acálé Yõrĩdánĩ gá ãzíla kí dó mụ pá sulé ị̃yị́ gá gọ́rọ̃tị́yọ̃ gá ꞌdãá ꞌbo, ");
INSERT INTO luc_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ị̃yị́ adị́lépi ụ́rụ́ léru rĩ tu dó pá cí ãzíla tra dó ru Bõrõ áni álị́-álị́ ru táwụ̃nị̃ Ádãmũ adrulépi táwụ̃nị̃ Zãrẹ́tị̃ drị̂ ꞌbã bụ́lụ́ gá rĩ be ãzíla ị̃yị́ dịlépi ándrá léru rĩ dị mĩrĩ Ãrábã gá (ꞌdĩ mĩrĩ ãꞌị́ ru rĩ ꞌi) kpere ị̃yị́ ꞌbã nzụ agá pírí. Ị́jọ́ ꞌdĩ sĩ ꞌbá alị kí dó sĩ ãni rú ãngũ ꞌbã wókõ rũ ndrelépi Yẹ̃rị́kọ̃ be rĩ gâsĩ. ");
INSERT INTO luc_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Ãtalo Sãndụ́kụ̃ tị icíma drị́ Úpí drị̂ ujílépi rĩ tu kí pá mgbe-mgbe ãngũ ãꞌí drị̃ gá mĩrĩ Yõrĩdánĩ ꞌbã ágágá ꞌdĩ sĩ ꞌbá Ịsịrayị́lị̃ drị̂ kí dị̃ alị sĩ ãngũ ãꞌí drị̃ gâsĩ kpere sụ́rụ́ Ịsịrayị́lị̃ drị̂ ꞌbã kí alị agâ Yõrĩdánĩ ꞌbã ꞌá ꞌdã sĩ pírí. ");
INSERT INTO luc_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","ꞌBá sụ́rụ́ Ịsịrayị́lị̃ drị̂ kí mụ mĩrĩ Yõrĩdánĩ zalé pírí ꞌbo, Úpí jọ dó Yósũwã ní, ");
INSERT INTO luc_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Mí ãpẽ ãgọbị kí mụdrị́ drị̃ ị̃rị̃ ínátị ãlu-ãlu agâsĩ ãlu-ãlu, ");
INSERT INTO luc_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","ílũ ĩꞌbaní, ‘Ĩmi aꞌdụ́ írã kí mụdrị́ drị̃ ị̃rị̃ ãngũ ãtalo ꞌbã kí sĩ pá tujó ũkpó ru ị̃yị́ ꞌbã ágá gá rĩ gá ꞌdãá ãzíla ĩmi agụ kí ãngũ ãndrũ ị́nị́ sĩ ĩminí sĩ mụjó ụ́ꞌdụ́ kojó ala gá rĩ gá.’” ");
INSERT INTO luc_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","ꞌDã ꞌbã ũngúkú gá, Yósũwã umve dó ãgọbị mụdrị́ drị̃ ị̃rị̃ ĩꞌdi ꞌbã ũpẽlé ínátị Ịsịrayị́lị̃ drị́ mụdrị́ drị̃ ị̃rị̃ ꞌdĩ kí agá ãlu-ãlu ꞌdĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","Yósũwã jọ dó ĩꞌbaní, “Ĩmi alị Sãndụ́kụ̃ tị icíma drị́ Úpí Ãdróŋá ĩmidrị̂ drị̂ ꞌbã drị̃lẹ́ gá mĩrĩ Yõrĩdánĩ ꞌbã ágá gá ꞌdãá. Ĩmi ãlu-ãlu ꞌbã ꞌdụ írã ĩꞌdi kọ́trọ́ gá kãlãfe ínátị ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbadrị̂ kí vú sĩ, ");
INSERT INTO luc_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","ãꞌdusĩku ị́jọ́ ꞌdĩ la dó adru ĩminí ícétáŋá ru. Sáwã ãzí gá anzị ĩmidrị̂ drĩ kí dó sĩ amụ́ ĩmi zịlé, ‘Írã ꞌdĩ kí ꞌbã ífí ĩminí íngoní yã?’ ");
INSERT INTO luc_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Ĩmi dó sĩ lũ la ĩꞌbaní ị̃yị́ Yõrĩdánĩ drị̂ tu ándrá pá cí sáwã Sãndụ́kụ̃ tị icíma drị́ Úpí drị̂ ꞌbã alịjó ala gâsĩ rĩ sĩ. Ị́jọ́ ꞌdĩ sĩ írã ꞌdĩ kí dó sĩ adru ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní sĩ kí igájó jãꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","ꞌBá Ịsịrayị́lị̃ drị̂ idé kí dó ị́jọ́ ꞌdĩ cécé Yósũwã ꞌbã azịlé ĩꞌbaní rĩ áni ãzíla ꞌdụ kí dó sĩ írã kí mụdrị́ drị̃ ị̃rị̃ mĩrĩ Yõrĩdánĩ ꞌbã ágá gá ꞌdãá kãlãfe sụ́rụ́ Ịsịrayị́lị̃ drị̂ kí vú sĩ cécé Úpí ꞌbã jọlé Yósũwã ní rĩ áni. ꞌDụ kí dó sĩ kí ĩꞌba abe ãngũ ĩꞌbã kí sĩ kojó rĩ gá ãzíla ꞌbã kí dó kí ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Yósũwã ũdrõ vâ írã ãzí kí mụdrị́ drị̃ ị̃rị̃ mĩrĩ Yõrĩdánĩ ꞌbã ágá gá ꞌdãá ãngũ ãtalo Sãndụ́kụ̃ tị icíma drị̂ ꞌdụlépi rĩ ꞌbã kí sĩ pá tujó rĩ gá ãzíla írã ꞌdĩ kí drĩ kpere úꞌdîꞌda ãngũ ándrá sĩ kí drõjó rĩ gá ꞌdãá cí. ");
INSERT INTO luc_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Ãtalo Sãndụ́kụ̃ tị icíma drị̂ ꞌdụlépi rĩ tu kí dó pá mĩrĩ Yõrĩdánĩ ꞌbã ágágá ꞌdãá kpere ị́jọ́ pírí Úpí ꞌbã ándrá azịlé Yósũwã ní rĩ ꞌbã kí ru idé agá cécé Mụ́sã ꞌbã ándrá azịlé Yósũwã ní rĩ áni, ꞌdĩ sĩ ꞌbá Ịsịrayị́lị̃ drị̂ kí dị̃ ru afụ sĩ, sĩ alịjó mĩrĩ Yõrĩdánĩ ꞌbã wókõ ãzí rĩ gâlé ru. ");
INSERT INTO luc_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","ꞌBá pírí kí dó mụ alịlé ꞌbo, ãtalo Sãndụ́kụ̃ tị icíma drị́ Úpí drị̂ ꞌdụlépi rĩ ali kí dó wókõ ãzí rĩ gâlé ꞌbá kí drị̃ kí ndre sĩ. ");
INSERT INTO luc_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Sụ́rụ́ Rụ́bẹ̃nị̃ drị́, Gádĩ drị́ ãzíla sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ kí abe ꞌdụ kí dó ãko ãꞌdị́ ꞌdịjó rĩ kí ãzíla alị kí dó sĩ ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃lẹ́ gá cécé Mụ́sã ꞌbã ándrá jọlé ĩꞌbaní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","ꞌBá ãnirú 40,000 ru itúlépi ãko sĩ ãꞌdị́ ꞌdịjó rĩ kí abe Úpí ꞌbã adrujó ĩꞌba abe cí rĩ za kí dó ãngũ gbayi Yẹ̃rị́kọ̃ drị̂ gá sĩ ãꞌdị́ ꞌdịjó. ");
INSERT INTO luc_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Ụ́ꞌdụ́ ꞌdã sĩ Úpí inga Yósũwã ꞌbá pírí Ịsịrayị́lị̃ drị̂ kí drị̃lẹ́ gá ãmbógó ru ãzíla fẽ kí dó ĩꞌdiní ãrútáŋá cécé ĩꞌbã kí ándrá fẽlé Mụ́sã ní rĩ áni sáwã ĩꞌdi ꞌbã adrujó ídri rú rĩ agá pírí. ");
INSERT INTO luc_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Yósũwã ní, ");
INSERT INTO luc_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“Íjọ ãtalo Sãndụ́kụ̃ tị icíma drị̂ ꞌdụlépi ꞌdĩ ꞌbaní ꞌbã ãfũ kí Yõrĩdánĩ agâlé rĩ sĩ ãmvé.” ");
INSERT INTO luc_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Ị́jọ́ ꞌdĩ sĩ Yósũwã jọ dó ãtalo ꞌdĩ ꞌbaní, “Ĩmi ãfũ dó mĩrĩ Yõrĩdánĩ agâlé rĩ sĩ ãmvé.” ");
INSERT INTO luc_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Ãtalo Sãndụ́kụ̃ tị icíma drị́ Úpí drị̂ dụlépi rĩ kí dó mụ ãfũlé mĩrĩ Yõrĩdánĩ agâlé rĩ sĩ ãmvé ãzíla kí dó mụ pá tị̃lé ãngũ ãꞌí rĩ gá ꞌbo, ị̃yị́ pá tulépi cí rĩ icí dó sĩ ru ãlu ãzíla iꞌdó dó sĩ dịlé jõ ídu rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","ꞌBá Ịsịrayị́lị̃ drị̂ za kí dó Yõrĩdánĩ ĩmbá ãlu ꞌbã ụ́ꞌdụ́ mụdrị́ sĩ ãzíla sị kí dó kámbĩ Gị̃lị̃gálị̃ gá Yẹ̃rị́kọ̃ ꞌbã wókõ ị̃tụ́ ꞌbã agá agâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Yósũwã ũdrõ dó írã mụdrị́ drị̃ ị̃rị̃ ĩꞌbã kí aꞌdụ́lé mĩrĩ Yõrĩdánĩ agâlé rĩ kí Gị̃lị̃gálị̃ gá ꞌdãá ãzíla ");
INSERT INTO luc_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","jọ dó ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ drĩ kí drụ́zị́ ĩmi zị ‘Ãmgbã rĩ gá írã ꞌdĩ icé kí dó ãꞌdu?’ ");
INSERT INTO luc_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","Ĩmi dó icé la anzị ĩmidrị̂ ꞌbaní, ‘Ịsịrayị́lị̃ alị ándrá mĩrĩ Yõrĩdánĩ agâsĩ ãngũ ãꞌí rĩ drị̃ gâsĩ.’ ");
INSERT INTO luc_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Ílũ ĩꞌbaní Úpí Ãdróŋá ĩmidrị̂ fẽ ándrá ị̃yị́ Yõrĩdánĩ drị̂ ní nzụlé rá, ĩmi alị ándrá dó sĩ ãngũ ãꞌí drị̃ gâsĩ cécé ándrá Úpí ꞌbã vâ idélé ãmaní mĩrĩ ika rĩ gá rĩ áni. Fẽ ándrá mĩrĩ ika rĩ nzụ rá ãzíla ãma alị dó sĩ ándrá ãngũ ãꞌí rĩ drị̃ gâsĩ. ");
INSERT INTO luc_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Ị́jọ́ ꞌdĩ sĩ ꞌbá pírí ụ̃nọ́kụ́ drị̃ gá ꞌdâ rĩ kí dó sĩ nị̃ la rá Úpí ꞌbã drị́ ĩꞌdi ũkpó ru ãzíla ĩmi dó sĩ Úpí Ãdróŋá ĩmidrị̂ ụ̃rị̃ jãꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Ũpi Ãmọ́rị̃ gá Yõrĩdánĩ ꞌbã wókõ ꞌá ꞌdã sĩ cajó kpere ị̃tụ́ ꞌbã ꞌde agá rĩ gá rĩ kí, ũpi Kãnánĩ drị́ mĩrĩ ꞌbã tị gá rĩ kí abe pírí kí mụ ị́jọ́ Úpí ꞌbã fẽjó la mĩrĩ Yõrĩdánĩ drị̂ nzụ rá ãzíla ꞌbá Ịsịrayị́lị̃ drị̂ alị kí dó sĩ pírí ãngũ ãꞌí gâsĩ rĩ arelé ꞌbo, ásị́ la ra kí dó sụ́sụ́ ru ị̃yị́ áni ãzíla ụ̃rị̃ ãmbógó la rụ dó sĩ kí ꞌbá Ịsịrayị́lị̃ drị̂ kí ị́jọ́ sĩ cí. ");
INSERT INTO luc_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Sáwã ꞌdã sĩ Úpí jọ dó Yósũwã ní, “Mí idé ị́lị́ŋá ãzí kí írã ũkpó la sĩ ãzíla mí ĩtãrã dó sĩ ꞌbá Ịsịrayị́lị̃ drị́ ĩtãrã lé ku rĩ kí rá.” ");
INSERT INTO luc_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Ị́jọ́ ꞌdĩ sĩ Yósũwã idé dó ị́lị́ŋá ãzí kí írã ũkpó la sĩ ãzíla ĩtãrã dó sĩ ãgọbị anzị Ịsịrayị́lị̃ drị̂ kí pírí ãngũ Gĩbẽyátĩ-hãrãlọ́tị̃ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Yósũwã ĩtãrã ꞌbá ꞌdi kí rá la ãꞌdusĩku ãgọbị ándrá ãfũlépi Mị̃sị́rị̃ gâlé rĩ kí ãgọbị ãꞌdị́ ꞌdịlépi rĩ kí abe ũdrã kí gẹ̃rị̃ gá kõtórõ agâlé pírí rá ĩꞌbã kí ãfũjó Mị̃sị́rị̃ gâlé rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Ándrá táni ꞌbá ãgọbị rú ãfũlépi Mị̃sị́rị̃ gâlé rĩ kí ĩtãrãjó rá tí, ꞌbá pírí tịlé kõtórõ agâlé ĩꞌbã kí ãfũjó Mị̃sị́rị̃ gâlé ꞌbo rĩ sĩ rĩ kí îtãrã ándrá kí gẹ̃rị̃ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Ị́jọ́ ꞌdĩ idé ru ꞌdĩ ꞌbã áni la ꞌbá Ịsịrayị́lị̃ drị̂ acị́ kí kõtórõ agâsĩ ílí kãlị́ sụ kpere ꞌbá pírí ãzíla ãgọbị ãꞌdị́ ꞌdịlépi ãfũlépi Mị̃sị́rị̃ gâlé rĩ ꞌbã kí ị̃lị̃kị̃ agâ ãꞌdusĩku are kí ándrá Úpí tị ku. Úpí na dó sĩ ũyõ ĩꞌbaní jọ, “Má icó kí fẽlé ãngũ ándrá mání ũyõ la najó ma fẽ la ĩꞌbã áyị́pịka ꞌbaní, ãngũ málĩ trũ ãlá mụ̃ꞌdụ̃-mụ̃ꞌdụ̃ lé ꞌbã sĩ rajó ala gá ãnụ́ úsã be rĩ ndrelé ku.” ");
INSERT INTO luc_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Ị́jọ́ ꞌdĩ sĩ Úpí inga dó anzị ĩꞌbadrị̂ kí kí kẹ̃jị́ gá, ꞌdĩ kí dó sĩ anzị Yósũwã ꞌbã ĩtãrãlé rĩ kî. Îtãrã kí íni la ãꞌdusĩku ándrá drĩ kí ĩtãrãjó gẹ̃rị̃ gá lé ku rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Ála dó mụ ãgọbị Sụ́rụ́ ꞌdĩ agá rĩ kí ĩtãrãlé pírí ꞌbo, ꞌbá ꞌdĩ ace kí dó ĩꞌbadrị́ kámbĩ agá ꞌdãá kpere ãkõzá kí ĩtãrãjó rĩ ꞌbã kí ja agá. ");
INSERT INTO luc_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Úpí jọ dó Yósũwã ní, “Ãndrũ áwụ̃ dó drị̃nzá ĩmi drị̃ gá ꞌbá Mị̃sị́rị̃ gá rĩ ꞌbã kí fẽlé rĩ rá.” Ị́jọ́ ꞌdĩ sĩ ꞌda dó sĩ ãngũ ꞌdã ꞌbã rụ́ Gị̃lị̃gálị̃ ꞌi kpere ãndrũ. ");
INSERT INTO luc_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","ꞌBá Ịsịrayị́lị̃ drị̂ ꞌbã kí adru agá Gị̃lị̃gálị̃ gá ꞌdãá, na kí dó ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ rĩ drị̂ ĩndró sĩ ĩmbá ụ́ꞌdụ́ mụdrị́ drị̃ sụ ĩmbá ꞌdã drị̂ sĩ ãngũ gbayi Yẹ̃rị́kọ̃ drị̂ gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Ụ́ꞌdụ́ ụ̃mụ̃ alịjó ꞌbá drị̃ gâsĩ rĩ drị̂ ꞌbã vúlé gá, ꞌbá ꞌdĩ na kí dó ãkónã ãngũ ꞌdã gá rĩ kí, mũkátĩ ãkụ́kị́ kóru rĩ ãzíla ũndú ụ̃kụ rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Drụ̃sị̃ íni mãnã tu dó pá zõŋá gá cí ụ́ꞌdụ́ ĩꞌbã kí iꞌdójó ãkónã ãngũ ꞌdã gá rĩ kí najó rĩ sĩ. Mãnã zõ dó ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ị̃dị́ ku, wó ri kí dó ãkónã ãfũlépi ãngũ kãnánĩ drị̂ gá rĩ kí nalé ílí ꞌdã sĩ áyụ. ");
INSERT INTO luc_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Sáwã Yósũwã ꞌbã adrujó Yẹ̃rị́kọ̃ ꞌbã tị gá ꞌdãá rĩ sĩ, inga mịfị́ ụrụgá ãzíla ndre ágọ́bị́ ãzí tu pa ménéŋá trũ drị́ gá. Yósũwã mụ ĩꞌdi rụ̂lé ãzíla zị ĩꞌdi, “Mí amụ́ ꞌbá ãma ãni la rú yã jõku mí amụ́ mẹ́rọ́ꞌbá ãmadrị̂ ꞌbaní?” ");
INSERT INTO luc_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Mãlãyíkã jọ, “Yụ, rá la sĩ ma ãsĩkárĩ ãmbógó Úpí drị̂ ꞌi. Má amụ́ dó bã sĩ ꞌbo.” Ị́jọ́ ꞌdĩ sĩ Yósũwã su dó tị vụ̃rụ́ sĩ ĩꞌdi ị̃nzị̃jó ãzíla zị dó ĩꞌdi, “Ị́jọ́ úpí mádrị̂ ꞌbã jọlé ãtíꞌbó ĩꞌdidrị̂ ní rĩ dó ãꞌdu?” ");
INSERT INTO luc_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","ꞌDã ꞌbã ũngúkú gá, ãsĩkárĩ ãmbógó Úpí drị̂ jọ dó sĩ Yósũwã ní, “Ítrũ ãko ími pá gá ꞌdĩ kí rá, ãꞌdusĩku ãngũ míní sĩ pá tujó ꞌdĩ ĩꞌdi ãngũ ãlá la.” Yósũwã idé dó cécé jọlé ĩꞌdiní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Sáwã ꞌdã sĩ ụ̂pị̃ dó kẹ̃jị́tị táwụ̃nị̃ Yẹ̃rị́kọ̃ drị̂ mgbemgbe ꞌbá Ịsịrayị́lị̃ drị̂ kí ị́jọ́ sĩ. Bá ãzí icó filé táwụ̃nị̃ agâlé ku jõku fũlé ãmvé ku. ");
INSERT INTO luc_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","ꞌDã ꞌbã ũngúkú gá, Úpí jọ dó Yósũwã ní, “Índre, Áfẽ táwụ̃nị̃ Yẹ̃rị́kọ̃ drị̂ úpí la be ãzíla ãgọbị ũkpó ãꞌdị́ ꞌdịlépi rĩ kí abe ími drị́ alé gá ꞌbo. ");
INSERT INTO luc_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Mí acị́ ãsĩkárĩ mídrị̂ kí abe táwụ̃nị̃ ꞌdĩ andre gâsĩ trộkị́lịrị ụ́ꞌdụ́ ázíyá. Ụ́ꞌdụ́ ãlu agá pâlé ãlu. ");
INSERT INTO luc_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Ãtalo ázị̂rị̃ rĩ ꞌbã adru kí Sãndụ́kụ̃ tị icíma drị̂ drị̃lẹ́ gá ãzíla ꞌbã rụ kí jaligó idélé kãbĩlógó újé sĩ rĩ kí kí drị́ gá cí. Ụ́ꞌdụ́ ázị̂rị̃ rĩ sĩ, ĩmi acị́ táwụ̃nị̃ andre gâsĩ trộkị́lịrị pâlé ázị̂rị̃ ãzíla ãtalo ꞌbã dị̃ kí jaligó vu sĩ. ");
INSERT INTO luc_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Ãtalo ꞌdĩ drĩ kí dó jaligó idélé kãbĩlõ újé sĩ ꞌdĩ kí vu ũkpó sĩ biri-biri ꞌbo, ꞌbá pírí ꞌbã uzá kí dó rere ụ́ꞌdụ́kọ́ ụrụgá sĩ. Bõrõ táwụ̃nị̃ andre cejó rĩ la dó sĩ aꞌdé vũ rụ́ ãzíla ꞌbá ãlu-ãlu la dó sĩ fi ala gâlé.” ");
INSERT INTO luc_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Ị́jọ́ ꞌdĩ sĩ Yósũwã Nụ́nị̃ ngọ́pị umve dó ãtalo kí ãzíla jọ ĩꞌbaní, “Ĩꞌdụ Sãndụ́kụ̃ tị icíma drị̂ ãzíla ãtalo ázị̂rị̃ jaligó idélé kãbĩlógó újé sĩ rĩ trũ rĩ ꞌbã adru kí Sãndụ́kụ̃ tị icíma drị́ Úpí drị̂ ꞌbã drị̃lẹ́ gá.” ");
INSERT INTO luc_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","ꞌDã ꞌbã ũngúkú gá, Yósũwã jọ dó ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ĩmụ dó, ĩmi apí táwụ̃nị̃ trộkị́lịrị ãzíla ãsĩkárĩ ꞌbã mụ kí dó Sãndụ́kụ̃ tị icíma drị́ Úpí drị̂ ꞌbã drị̃lẹ́ gá.” ");
INSERT INTO luc_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Yósũwã la dó mụ ị́jọ́ ꞌdĩ kí jọlé ꞌbo, ãtalo ázị̂rị̃ jaligó idélé kãbĩlógó újé sĩ rĩ kí ꞌdụlépi rĩ mụ kí dó Úpí drị̃lẹ́ gá jaligó kí vuŋá trũ, ãzíla Sãndụ́kụ̃ tị icíma drị́ Úpí drị̂ ꞌde dó sĩ kí vú gá. ");
INSERT INTO luc_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Ãsĩkárĩ ãzí rĩ ꞌde kí dó drị̃ ãtalo jaligó vulépi rĩ kí drị̃lẹ́ gá, ãzíla ãsĩkárĩ ãzí rĩ ꞌde kí dó Sãndụ́kụ̃ tị icíma drị̂ ꞌbã ũngúkú gá. ");
INSERT INTO luc_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Wó Yósũwã azị ị́jọ́ ꞌbá ꞌdĩ ꞌbaní, “Ĩmi uzá jõ ku, ĩmi ĩyãŋã tú kpere ụ́ꞌdụ́ mání jọjó la ĩmi uzá dó rĩ ꞌbã acá gâ, ĩmi dó sĩ uzá ĩndõ.” ");
INSERT INTO luc_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Ị́jọ́ ꞌdĩ sĩ Yósũwã fẽ apí dó Sãndụ́kụ̃ tị icíma drị́ Úpí drị̂ trũ táwụ̃nị̃ trộkị́lịrị pâlé ãlu. ꞌDã ꞌbã ũngúkú gá, ꞌbá ꞌdĩ ãgõ kí dó pírí kámbĩ agá ꞌdõlé ãzíla ko kí dó sĩ ụ́ꞌdụ́ ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Ụ́ꞌdụ́ ãzí rĩ sĩ Yósũwã angá dó ụ̃ꞌbụ́tị nị́nị́ ãzíla ãtalo ꞌdụ kí dó Sãndụ́kụ̃ tị icíma drị́ Úpí drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Ãtalo ázị̂rị̃ jaligó idélé kãbĩlógó újé sĩ ázị̂rị̃ rĩ kí trũ ꞌdĩ mụ kí dó Sãndụ́kụ̃ tị icíma drị́ Úpí drị̂ ꞌbã drị̃lẹ́ gá ãzíla ri kí dó jaligó kí vulé biri-biri. Ãsĩkárĩ ãzí rĩ alị kí dó drị̃lẹ́ gá ãzíla ãsĩkárĩ ãzí rĩ kí dó Sãndụ́kụ̃ tị icíma drị́ Úpí drị̂ ꞌbã ũngúkú gá íni ꞌdĩ jaligó kí dị̃ ụ sĩ. ");
INSERT INTO luc_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Ụ́ꞌdụ́ ị̃rị̃ rĩ sĩ apí kí dó táwụ̃nị̃ andre trộkị́lịrị pâlé ãlu ị̃dị́ ãzíla gõ kí dó vúlé kámbĩ gâlé. Idé kí ị́jọ́ ꞌdĩ ꞌdĩ ꞌbã áni ụ́ꞌdụ́ ázíyá. ");
INSERT INTO luc_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Ụ́ꞌdụ́ ázị̂rị̃ rĩ sĩ, angá kí dó ãngũsãrã sĩ ãzíla apí kí dó táwụ̃nị̃ trộkị́lịrị pâlé ázị̂rị̃ cécé ĩꞌbã kí jõ idélé drị̃drị̃ rĩ áni. Wó ụ́ꞌdụ́ ꞌdã sĩ rĩ gá apí kí dó táwụ̃nị̃ trộkị́lịrị pâlé ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Pâlé ázị̂rị̃ rĩ sĩ ãtalo kí dó mụ jaligó kí vulé ꞌbo, Yósũwã jọ dó ꞌbá ꞌbaní, “Ĩmi uzá, ãꞌdusĩku Úpí fẽ dó táwụ̃nị̃ ꞌdĩ ĩminí ꞌbo. ");
INSERT INTO luc_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Ĩmi ị̃lị̃kị̃ táwụ̃nị̃ ꞌdĩ ꞌi ãko ala gá rĩ kí abe pírí ídétáŋá ru Úpí nî. Ĩmi aꞌbe lú Rãhábụ̃ kí ꞌbá ĩꞌdidrị́kogá rĩ kí abe ãꞌdusĩku mba ándrá ꞌbá ũní-ũníŋá gá Ịsịrayị́lị̃ rú ãmaní tị pẽlé rĩ kí tã rá. ");
INSERT INTO luc_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Wó lẽ ĩmba ĩmi tã ãzíla ĩꞌdụ ãko Úpí ꞌbã jọlé ĩmi andi kí rá rĩ kí ĩminí ku, ĩdrĩ kí ꞌdụ rá, ĩmi ị̃lị̃kị̃ pírí rá ãzíla ĩmi lị́kị̃ ãmbógó la ají kámbĩ Ịsịrayị́lị̃ drị̂ drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Ãko idélé Sílĩvã sĩ, Gólũdĩ sĩ, bũrônzĩ sĩ ãzíla aya sĩ rĩ kí pírí lẽ úꞌbã kí ndú Úpí ní ãzíla lẽ úmba kí tã ĩrá ãko Úpí drị̂ kí tã mbajó rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Ála dó mụ jaligó kí vulé ꞌbo, ꞌbá uzá kí dó ụ́ꞌdụ́kọ́ ụrụgá sĩ rere, cọtị Bõrõ sĩ táwụ̃nị̃ andre cejó rĩ aꞌdé dó vũ rụ́. Ị́jọ́ ꞌdĩ sĩ ãsĩkárĩ pírí cẹ̃ kí dó filé táwụ̃nị̃ agâlé ãzíla ꞌdụ kí dó sĩ ĩꞌdi rá. ");
INSERT INTO luc_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Ụꞌdị́ kí dó ãko táwụ̃nị̃ agá ꞌdãá rĩ kí pírí ménéŋá ãꞌdị́ drị̂ kí sĩ. Ụꞌdị́ kí ãgọbị kí ũkú abe, kãrị̃lẹ̃ kí ĩdranigo abe, tị́, kãbĩlõ ãzíla kãyĩnõ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Wó Yósũwã jọ ãgọbị ị̃rị̃ ándrá mụlépi ãngũ Yẹ̃rị́kọ̃ drị̂ undrélépi ũní-ũníŋá ru rĩ ꞌbaní, “Ĩmụ ũkú ãwụ́ꞌbá ru ándrá ĩmi tã mbalépi rĩ drị́ jó agá ãzíla ĩmi ají ĩꞌdi ꞌbá pírí ĩꞌdi ꞌbã kãká ru ĩꞌdidrị́ jó agá rĩ kí abe cécé ĩminí ándrá ũyõ najó ĩꞌdiní rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Ị́jọ́ ꞌdĩ sĩ ãgọbị ándrá ị̃rị̃ ũní-ũníŋá gá ꞌdĩ mụ kí dó Rãhábụ̃ drị́ jó gâlé ãzíla ají kí dó Rãhábụ̃ ꞌi, átẹ́pị̃ kí ãndrẽ be, ádrị́pịka kí ãzíla ꞌbá pírí ĩꞌdidrị̂ kí abe. Ají kí dó ĩꞌdi kãká ĩꞌdidrị̂ kí abe pírí ãzíla ꞌbã kí dó kí kámbĩ Ịsịrayị́lị̃ drị̂ ꞌbã andre gá ꞌdãá ãmvé-ãmvélé ru. ");
INSERT INTO luc_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Ivé kí táwụ̃nị̃ ãko la ala gá rĩ kí abe pírí. Ãko ĩꞌbã kí lú ivélé ku rĩ kí ãko idélé Sílĩvã sĩ, gólũdĩ sĩ ãzíla ãko idélé aya sĩ rĩ kî. ꞌBã kí dó ãko ꞌdĩ kí ãngũ sĩ ãko Úpí drị̂ kí tãmbajó ĩꞌdidrị́ jó agá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Wó ũkú ãwụ́ꞌbá ru Rãhábụ̃ ꞌi kãká ĩꞌdidrị́ ándrá ĩꞌdi be jó agá ꞌdãá rĩ kí abe Yósũwã ị̃lị̃kị̃ dó kí gẹ̃rị̃ sĩ ku ãꞌdusĩku zị̃ ándrá ꞌbá Ịsịrayị́lị̃ rú ị̃rị̃ mụlépi ãngũ Yẹ̃rị́kọ̃ drị̂ undrélépi ũní-ũní ru rĩ kí rá. Kpere ãndrũ Rãhábụ̃ la dó sĩ uꞌá ꞌbá Ịsịrayị́lị̃ drị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Sáwã ꞌdã agá Yósũwã na dó ũyõ ãzíla jọ, “ꞌBá ru ingalépi táwụ̃nị̃ Yẹ̃rị́kọ̃ drị́ ꞌdĩ sịlépi úꞌdí ru rĩ Úpí drị̃lẹ́ gá úwã ĩꞌdí rá.” “Ĩꞌdiní ị̃ndụ́ la iꞌdó agá sị agá ꞌdĩ gá ꞌdâ, ngọ́pị̃ kãyú rĩ ꞌbã drã rá. Ĩꞌdiní kẹ̃jị́tị la kí usú agâ, ngọ́pị vúléŋá rĩ ꞌbã drã rá.” ");
INSERT INTO luc_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Ị́jọ́ ꞌdĩ sĩ Úpí ri dó adrulé Yósũwã be ãzíla ĩꞌdi ꞌbã rụ́ kụ dó sĩ ãngũ ꞌdã gá ꞌdãá pírí. ");
INSERT INTO luc_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Wó ꞌbá Ịsịrayị́lị̃ drị̂ nũ kí ãzị́táŋá ãko ꞌbãlé ndú Úpí ní rĩ drị̂ kí rá. Ágọ́bị́ umvelé Ãkánĩ Zãbị́dị̃ ngọ́pị rú rĩ ụ̃gụ̃ ãko ꞌbãlé ndú Úpí ní rĩ ꞌbã ĩsélé ãzí kí rá. Ị́jọ́ ꞌdĩ sĩ Úpí ꞌbã ásị́ ve dó sĩ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ũnzí. Ãkánĩ ꞌdĩ Kãrị́mị̃ ngọ́pị ꞌi, Kãrị́mị̃ ꞌbã átẹ́pị Zị́mị̃rị̃ ꞌi, Zị́mị̃rị̃ ꞌbã átẹ́pị Zérã ꞌi angájó sụ́rụ́ Yụ́dã drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Yósũwã pẽ dó ꞌbá ãzí kí tị Yẹ̃rị́kọ̃ gá rĩ sĩ mụjó Áyĩ gá ãni rú Bẹ̃tị̃ Ávẹ̃nị̃ gá, ꞌdĩ wókõ Bẹ̃tẹ́lị̃ drị́ ị̃tụ́ ꞌbã ãfũ agâlé ru rĩ gá. “Ĩmụ ãzíla ĩmi imí ãngũ ꞌdã ũní-ũní ru.” Ị́jọ́ ꞌdĩ sĩ ãgọbị ꞌdĩ mụ kí dó Áyĩ imílé rá. ");
INSERT INTO luc_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Kí mụ ãgõlé Yósũwã rú ꞌdõlé ꞌbo, jọ kí ĩꞌdiní, “Ị́jọ́ ãzí lẽlépi la ãma pírí ꞌbã mụ kí ãꞌdị́ gá Áyĩ gá la yụ, ꞌbá álĩfũ ị̃rị̃ jõku na la ꞌbã mụ kí lú Áyĩ ꞌdụlé nĩ. Lẽ ꞌbá ãmadrị̂ ꞌbã mụ kí drị̃cị trũ lé ku ꞌbá ꞌdã ꞌbã kí adrujó were rú rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Ị́jọ́ ꞌdĩ sĩ ꞌbá ãꞌdị́ drị́ ãnirú 3,000 mụ kí dó sĩ nĩ, wó ꞌbá Áyĩ drị̂ ndẽ kí kí rá, ");
INSERT INTO luc_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","ꞌbá Áyĩ drị̂ adró kí ꞌbá Ịsịrayị́lị̃ drị̂ kí angájó kẹ̃jị́tị táwụ̃nị̃ drị̂ gâlé kpere Sẽbãrị́mụ̃ gá ãzíla ụꞌdị́ kí ꞌbá ãni rú kãlị́ na drị̃ ázíyá ãngũ ilũlépi ilú ilû rĩ gá ꞌdãá. ꞌBá Ịsịrayị́lị̃ drị̂ ra kí dó ụ̃rị̃ sĩ sụ́sụ́ ru ị̃yị́ áni. ");
INSERT INTO luc_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Ị́jọ́ ꞌdĩ sĩ Yósũwã kí ꞌbá ĩyõ Ịsịrayị́lị̃ drị̂ kí abe asi kí dó bõngó ĩꞌbadrị̂ kí ãzíla umvú kí cínákí kí drị̃ gá, ula kí ru ãzíla su kí tị vụ̃rụ́ Sãndụ́kụ̃ tị icíma drị́ Úpí drị̂ ꞌbã drị̃lẹ́ gá kpere ĩndró sĩ. ");
INSERT INTO luc_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","ꞌDã ꞌbã ũngúkú gá, Yósũwã jọ, “ꞌBárĩ Úpí Ãdróŋá ũkpó ꞌdị́pị, mí ají dó ãma mĩrĩ Yõrĩdánĩ ꞌbã ꞌá ꞌdõlé sĩ ãma fẽjó ụꞌdị́jó ꞌbá Ãmọ́rị̃ rú rĩ kí drị́ gá yã? Ãdrĩ tá adru agá ꞌá ꞌdã sĩ la tá múké! ");
INSERT INTO luc_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Úpí, ma dó úꞌdîꞌda ãꞌdu ị́jọ́ jọ ꞌbá Ịsịrayị́lị̃ drị̂ drĩ kí dó apá mẹ́rọ́ꞌbá ĩꞌbadrị̂ kí sĩ ꞌdĩ áni? ");
INSERT INTO luc_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Ị́jọ́ ꞌdĩ drĩ dó úꞌdîꞌda kụ ꞌbá Kãnánĩ drị̂ kí bị́lẹ́ gá ꞌbá ãzí uꞌálépi ãngũ ꞌdĩ gá ꞌdâ rĩ kí abe ꞌbo, kí dó ãma ce rị́ ãzíla kí dó sĩ ãma rụ́ ịnị́ ụ̃nọ́kụ́ drị̃ gá ꞌdâ rá. Mi dó ãꞌdu ị́jọ́ idé rụ́ mídrị́ ãmbógó ꞌdĩ drị̃ gá yã?” ");
INSERT INTO luc_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Úpí jọ dó Yósũwã ní, “Mí angá ụrụgá! Mi ími la kpụ́kụ-kpụ́kụ rú ãꞌdu ị́jọ́ sĩ yã? ");
INSERT INTO luc_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Ịsịrayị́lị̃ iza kí ị́jọ́ rá, nũ kí tị icíma mádrị́ ĩꞌba abe rĩ rá! Ụ̃gụ̃ kí ãko ꞌbãlé ndú mání rĩ ꞌbã ãzí kí rá. Ụ̃gụ̃ kí ãko, alị́ kí ĩnzõ ãzíla ụ̃zị̃ kí ãko ꞌdĩ kí ãko ĩꞌbadrị̂ kí agá. ");
INSERT INTO luc_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","ꞌDĩ bãsĩ ị́jọ́ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã kí apájó mẹ́rọ́ꞌbá ĩꞌbadrị̂ ꞌbã kí kí ndẽjó rá rĩ sĩ rĩ ꞌi. Ị́jọ́ fẽlépi la ꞌbá Ịsịrayị́lị̃ drị̂ uja kí ũngúkú sĩ apájó mẹ́rọ́ꞌbá ĩꞌbadrị̂ kí sĩ rĩ ãꞌdusĩku úfẽ dó kí lị́kị̃ ní ꞌbo. Má icó dó adrulé ĩmi abe ị̃dị́ ku kpere ĩminí ãko ꞌbãlé mání ndú ꞌdĩ kí andi agá rá ká. ");
INSERT INTO luc_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","Ímụ, ífẽ ãzị́táŋá ꞌbá ꞌbaní sĩ ru itújó ãlá ru bábá ụ́ꞌdụ́ drụ̃sị̃ rĩ nî, ãꞌdusĩku ꞌdĩ ị́jọ́ Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ ꞌbã jọlé rĩ ꞌi, jọ, ãko ꞌbãlé mání ndú ꞌdĩ kí ĩmi drĩdríŋĩ gá ꞌdĩ Ịsịrayị́lị̃. Ĩmi icó mẹ́rọ́ꞌbá ĩmidrị̂ kí ndẽlé ku kpere ĩminí ãko ꞌbãlé ndú ꞌdĩ kí ĩdã agá ĩmi drĩdríŋĩ gá ꞌdâ rá ká. ");
INSERT INTO luc_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Ụ̃ꞌbụ́tị sĩ ĩmi iꞌda ĩmi sụ́rụ́ vú sí sụ́rụ́ vú sĩ, sụ́rụ́ Úpí ꞌbã pẽlé rĩ la amụ́ drị̃lẹ́ gá ínátị vú sị̃ ínátị vú sĩ, ínátị Úpí ꞌbã pẽlé rĩ la amụ́ drị̃lẹ́ gá, ínátị amụ́lépi rĩ gá ꞌbá lị́cọ́ Úpí ꞌbã pẽlé rĩ gá rĩ kí amụ́ drị̃lẹ́ gá ãlu-ãlu. ");
INSERT INTO luc_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","ꞌBá rụlé ãko ꞌbãlé ndú ꞌdĩ kí abe rĩ ála ĩꞌdi ivé ãcí sĩ, ãko pírí ĩꞌdidrị̂ kí abe ãꞌdusĩku iza tị icíma Úpí Ãdróŋá drị̂ rá ĩꞌdiní ị́jọ́ ũnzíkãnã ꞌdĩ idéjó Ịsịrayị́lị̃ gá rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Ụ̃ꞌbụ́tị ụ́ꞌdụ́ ãzí rĩ drị̂ sĩ, Yósũwã ají sụ́rụ́ Ịsịrayị́lị̃ drị̂ kí sụ́rụ́ vú sụ́rụ́ vú sĩ Úpî drị̃lẹ́ gá, âpẽ dó sụ́rụ́ Yụ́dã drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","ꞌDã ꞌbã ũngúkú gá, ínátị Yụ́dã drị̂ ãmụ drị̃lẹ́ gá, âpẽ dó lị́cọ́ Zérã drị̂ ꞌi, ꞌbá lị́cọ́ Zérã drị̂ gá rĩ ãfũ kí dó drị̃lẹ́ gá ãlu-ãlu, âpẽ dó sĩ ala gá lị́cọ́ Zị́mị̃rị̃ drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Yósũwã fẽ dó ꞌbá lị́cọ́ Zị́mị̃rị̃ drị̂ gá rĩ ꞌbaní amụ́jó drị̃légá ꞌbá ãlu-ãlu, âpẽ dó Ãkánĩ Kãrị́mị̃ ngọ́pị Zérã umvelépi áyị́pị rĩ angájó sụ́rụ́ Yụ́dã drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","ꞌDã ꞌbã ũngúkú gá, Yósũwã jọ dó Ãkánĩ ní, “Mâ ngọ́pị, ífẽ dị̃zã Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ ní míní ị́jọ́ pịrị rĩ lũjó rĩ sĩ. Mí iꞌda mání ị́jọ́ míní idélé rá rĩ, mí ucí mání ku.” ");
INSERT INTO luc_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Ãkánĩ umvi Yósũwã ní, “Ĩꞌdi ãndá! Má iza ị́jọ́ Úpí Ãdróŋá mádrị́ Ịsịrayị́lị̃ drị̂ rụ́ rá. Ị́jọ́ mání idélé rĩ ꞌdĩ áni: ");
INSERT INTO luc_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Ándre ãko ãmaní rụlé ꞌdã kí agá bõngó ũnĩ ambamba angálépi Bãbụ̃lọ́nị̃ gá la, séndẽ sílĩvã rú ífí-ífí la kí 200, ãzíla gólũdĩ ꞌbara ãnzị̃lépi kị́lọ̃ ị̃rị̃ la, áma sụ̃sụ́ ãngã dó kí sĩ rá ãzíla má aꞌdụ́ dó sĩ kí rá. Ázị̃ kí ĩnzõ sílĩvã kí abe vũ gá hémã mádrị̂ agá.” ");
INSERT INTO luc_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Ị́jọ́ ꞌdĩ sĩ Yósũwã pẽ dó ꞌbá ãzí kí tị sĩ mụjó ãko ꞌdã kí ndrụ̃jó, cẹ̃ kí hémã agâlé, ịsụ́ kí ãko ꞌdĩ kí hémã agá ꞌdãá rá, sílĩvã dó vũ gâlé ru. ");
INSERT INTO luc_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Aꞌdụ́ kí ãko kí hémã agâlé agụ kí kí Yósũwã rụ̂lé ãzíla ꞌbá pírí Ịsịrayị́lị̃ drị̂ kí drị̃lẹ́ gá, ãzíla aja kí kí vũ gá Úpí drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","ꞌDã ꞌbã ũngúkú gá, Yósũwã ꞌi ãzíla ꞌbá pírí Ịsịrayị́lị̃ drị̂ kí abe ꞌdụ kí dó Ãkánĩ Zérã ngọ́pị ꞌi, sílĩvã, kánzũ, gólũdĩ ꞌbara rĩ, ĩꞌdi ꞌbã ngọ́pịka kí ị̃zẹ́pịka kí abe, tị́ kí, kãyĩnõ kí, kãbĩlõ kí, ĩꞌdi ꞌbã hémã ãzíla ãko pírí ĩꞌdi ꞌbã trũ adrujó rĩ abe agụ kí kí áꞌbụ ꞌa Ãkọ́rị̃ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Yósũwã jọ Ãkánĩ ní, “Mí ají drị̃lẹ́ ụ̃nzị̃ ãmã drị̃ gá íni ãꞌdụ ị́jọ́ sĩ? Úpí Ãdróŋá la drị̃lẹ́ ụ̃nzị̃ ají ími drị̃ gá úꞌdîꞌda.” ꞌBá pírí Ịsịrayị́lị̃ drị̂ uꞌbé kí dó Ãkánĩ kí ꞌbá ĩꞌdidrị̂ kí abe írã sĩ ivé kí kí ãcí sĩ. ");
INSERT INTO luc_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Ũdrõ kí írã ngúlú ru ãmbógó ru Ãkánĩ drị̃ gá kpere ãndrũ cí. ꞌDã ꞌbã ũngúkú gá, ũmbã Úpí drị́ ãcí rĩ uja dó ru rá. Ị́jọ́ ꞌdĩ sĩ iꞌdójó ụ́ꞌdụ́ ꞌdã sĩ, ãngũ ꞌdã ꞌbã rụ́ acá dó áꞌbụ ꞌa Ãkọ́rị̃ drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Yósũwã ní, “Mí idé ụ̃rị̃ sĩ ku jõku ími ásị́ ꞌbã umvú ku. Íꞌdụ ãsĩkárĩ mídrị́ ãꞌdị́ drị̂ kí pírí mí be, ímụ ĩꞌba abe Áyĩ gâlé ãꞌdị́ gá. Ãꞌdusĩku áfẽ Áyĩ ꞌi úpí ĩꞌdidrị̂ be, ꞌbá kí, táwụ̃nị̃ ãzíla ãngũ ĩꞌdidrị̂ abe ími drị́ gá ꞌbo. ");
INSERT INTO luc_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Mí idé ị́jọ́ táwụ̃nị̃ Áyĩ drị̂ rụ́ úpí ĩꞌdidrị̂ be cécé ándrá míní idélé táwụ̃nị̃ Yẹ̃rị́kọ̃ drị̂ rụ́ úpí ĩꞌdidrị̂ be rĩ áni, ĩmi icó ãko ĩꞌbadrị̂ kí ralé rá ãzíla ĩmi ícó ãnãpká ĩꞌba drị̂ kí ꞌdụlé ĩminí rá. Mí itú ãsĩkárĩ ãzí kí zị̃lé táwụ̃nị̃ ꞌbã ũngúkú gâlé ru sĩ kí alị́jó ũní ũní ru.” ");
INSERT INTO luc_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Ị́jọ́ ꞌdĩ sĩ Yósũwã ꞌi ãzíla ãsĩkárĩ ĩꞌdidrị̂ kí abe mụ kí dó pírí Áyĩ gâlé ãꞌdị́ gá. Ũpẽ ãsĩkárĩ ĩꞌdidrị́ ũkpõ trũ ãꞌdị ꞌdịlépi mgbã rĩ kí 30,000 ãzíla pẽ dó kí tị mụlé ãꞌdị́ gá ãmvêlé ị́nị́ sĩ ");
INSERT INTO luc_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","ãzị́táŋá ꞌdĩ kí abe: “Ĩmi are múké múké, ĩmi ụ̃zị̃ ĩmi táwụ̃nị̃ ꞌbã ũngúkú gâlé ru sĩ kí alị́jó ũní ũní ru. Ĩmụ álị́ ku, ĩmi adru pírí bábá. ");
INSERT INTO luc_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Ma ꞌi ãzíla ꞌbá pírí mâ abe ꞌdĩ kí mụ ãꞌdị́ gá táwụ̃nị̃ gâlé, ꞌbá ꞌdã drị̃ kí dó amụ́ ãma rú ãꞌdị́ gá ándrá ĩꞌbaní idélé drị̃drị̃ rĩ áni, ãma apá ĩꞌba rú ꞌdãá rá. ");
INSERT INTO luc_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Drị̃ kí dó ãma adro, ãma dó sĩ kí anzé angájó táwụ̃nị̃ agâlé rĩ sĩ rá, kí dó sĩ jọ la, ‘Ándrá drị̃drị̃ rĩ áni kí dó apá ꞌdã.’ Ị́jọ́ ꞌdĩ sĩ ãdrĩ dó apá ĩꞌba rụ́ ꞌdãá rá, ");
INSERT INTO luc_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","ĩmi dó angá ãngũ ĩminí sĩ ĩmi ụ̃zị̃jó rĩ gâlé ãzíla ĩmi dó sĩ táwụ̃nị̃ ꞌdụ rá. Úpí Ãdróŋá ĩmidrị̂ la ĩꞌdi fẽ ĩmi drị́ alé gá. ");
INSERT INTO luc_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Ĩdrĩ táwụ̃nị̃ ꞌdụ rá, ĩsu ãcí la rá cécé Úpí ꞌbã ãzị́táŋá la fẽjó rĩ áni. Ĩndre, lẽ ĩmi ũbĩ ị́jọ́ mádrị́ ꞌdĩ kí vú rá.” ");
INSERT INTO luc_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","ꞌDã ꞌbã ũngúkú gá, Yósũwã pẽ dó ãsĩkárĩ kí tị, mụ kí dó ãngũ ĩꞌbaní sĩ ru zị̃jó ũní rĩ gá ãzíla la kí ru kí tẽlé Bẹ̃tẹ́lị̃ ꞌbã drĩdríŋĩ Áyĩ be rĩ gá, ꞌdĩ wókõ Áyĩ drị́ ị̃tụ́ ꞌbã ꞌde agâlé ru rĩ gá wó Yósũwã ace ru ị́nị́ ꞌdã sĩ ꞌbá kí abe kámbĩ agá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Ụ̃ꞌbụ́tịnị́nị́ Yósũwã inga ꞌbá ĩꞌdidrị̂ kí, ĩꞌdi ꞌi ãzíla ꞌbá Ịsịrayị́lị̃ ꞌbã drị̃lẹ́ ru rĩ kí abe, mụ kí drị̃lẹ́ gá Áyĩ gâlé. ");
INSERT INTO luc_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Ãsĩkárĩ ĩꞌdi abe ꞌdĩ mụ kí pírí ĩꞌdi abe kpere ĩꞌbaní ca agá táwụ̃nị̃ ꞌbã drị̃lẹ́ gá. Sị kí kámbĩ Áyĩ ꞌbã drị̃lẹ́ gá ụ́rụ̂lé ru ãzíla áꞌbụ kí drĩdríŋĩ gá táwụ̃nị̃ be ci. ");
INSERT INTO luc_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Yósũwã ꞌdụ ãsĩkárĩ 5,000 ãzíla ụ̃zị̃ kí ũní Bẹ̃tẹ́lị̃ ꞌbã drĩdríŋĩ Áyĩ be rĩ gá, táwụ̃nị̃ ꞌbã wókõ ị̃tụ́ ꞌbã ꞌde agâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Ũꞌbã dó ãsĩkárĩ pírí kámbĩ agá rĩ kí ãngũ ĩꞌbadrị́ Áyĩ ꞌba wókõ ụ́rụ̂lé rĩ gá, ãzíla ꞌbá zị̃lé zị̃zị̃ rĩ kí ị̃tụ̂ ꞌbã ꞌde agâlé ru. Ị́nị́ ꞌdã sĩ Yósũwã mụ ụ́ꞌdụ́ kolé áꞌbụ agâlé. ");
INSERT INTO luc_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Úpí Áyĩ drị̂ la mụ ꞌbá Ịsịrayị́lị̃ drị̂ kí ndrelé ꞌbo, úpí kí ãsĩkárĩ ĩꞌdidrị̂ kí abe afụ kí ru ụ̃ꞌbụ́tịnị́nị́ ãmvêlé ãꞌdị́ ꞌdịlé ꞌbá Ịsịrayị́lị̃ drị̂ kí abe ãngũ ãzí ru ndrelépi Ãrábã be rĩ gá. Wó nị̃ úzị̃ ꞌbá ãzí rĩ kí kí ũngúkú gá vúlé táwụ̃nị̃ gâlé ru la ku. ");
INSERT INTO luc_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Yósũwã kí ꞌbá Ịsịrayị́lị̃ drị̂ kí abe pírí aꞌbe kí ru drolé vúlé, ãzíla apá kí dó sĩ ãngũ kõtórõ ru rĩ agâlé ru. ");
INSERT INTO luc_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","ꞌBá pírí Áyĩ drị̂ kí ûmve kí ꞌbá ꞌdĩ kí vú drolé, dro kí dó sĩ Yósũwã kí vú sĩ kí drị̃ aséjó ãmvé táwụ̃nị̃ agâlé rĩ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","ꞌBá ãzí ru acelépi Áyĩ gá jõku Bẹ̃tẹ́lị̃ gá ꞌbá Ịsịrayị́lị̃ kí vú drolépi ku la ꞌdá yụ. Aꞌbe kí dó sĩ táwụ̃nị̃ ꞌbã tị mgbọ ãzíla dro kí dó sĩ ãsĩkárĩ Ịsịrayị́lị̃ drị̂ kí vú. ");
INSERT INTO luc_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Yósũwã ní, “Mí ĩjũ ãjụ́ ími drị́ gá ꞌdĩ Áyĩ gâlé ru, ãꞌdusĩku ma táwụ̃nị̃ ꞌdĩ fẽ ími drị́ alé gá.” Ị́jọ́ ꞌdĩ sĩ Yósũwã ĩjũ dó sĩ ãjụ̂ Áyĩ gâlé ru. ");
INSERT INTO luc_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Ĩꞌdi mụ ãjụ̂ ĩjũlé ꞌbo, ꞌbá tá zị̃lé ꞌdã angá kí ãngũ tá ĩꞌbã kí ru zị̃jó rĩ gâlé gbõrú ãzíla cẹ̃ kí dó drị̃ gá. Fi kí dó táwụ̃nị̃ agâlé, ꞌdụ kí ĩꞌdi ãzíla su kí dó sĩ ãcí la cọtị rá. ");
INSERT INTO luc_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","ꞌBá Áyĩ drị̂ ndre kí ãngũ kí vúlé gâlé, ndre kí ãcíkã táwụ̃nị̃ ꞌbã sĩ vejó rĩ la nga agá ãzíla tụ agá ꞌbụ̃ gâlé, wó icó kí kẹ̃jị́ ãzí ịsụ́lé sĩ apájó wókõ ãzí gâsĩ ku, ãꞌdusĩku ꞌbá tá Ịsịrayị́lị̃ drị́ apálépi kõtórõ gâlé rĩ uja kí tị sĩ kí adrójó. ");
INSERT INTO luc_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Ị́jọ́ ꞌdĩ sĩ Yósũwã kí ꞌbá Ịsịrayị́lị̃ drị̂ kí abe pírí mụ ndrelé la ꞌbá zị̃lé ꞌdã ꞌdụ kí dó táwụ̃nị̃ rá ãzíla ãcíkã la tụ ꞌbụ̃ gâlé ru angájó táwụ̃nị̃ agâlé ru ꞌbo, uja kí ru kị́lịrị ꞌbá Áyĩ drị̂ kí ụꞌdị́lé. ");
INSERT INTO luc_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","ꞌBá zị̃lé ꞌdã ãfũ kí vâ táwụ̃nị̃ agâlé rĩ sĩ ãmvé sĩ ꞌbá ꞌdã kí uꞌdị́jó, ị́jọ́ ꞌdĩ sĩ úce dó kí ágágá, ꞌbá Ịsịrayị́lị̃ drị̂ kí dó wókõ pírí agá cí. ꞌBá Ịsịrayị́lị̃ drị̂ ulí kí kí pírí vụ̃rụ́ ꞌbá ãzí ru palépi rá ãzíla apálépi rá la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Wó ꞌbá ꞌdĩ rụ kí dó úpí Áyĩ drị̂ ídri rú ãzíla agụ kí dó ĩꞌdi Yósũwã rụ̂lé. ");
INSERT INTO luc_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Ãsĩkárĩ Ịsịrayị́lị̃ drị̂ kí dó mụ ꞌbá Áyĩ drị̂ kí delé ụꞌdị́ agá ásé agá kõtórõ agâlé ãngũ ĩꞌbã kí sĩ kí drojó rĩ gá ꞌbo, ãzíla ála dó mụ ꞌbá pírí kí ũsõlé ménéŋá sĩ ꞌbo, ꞌbá Ịsịrayị́lị̃ drị̂ ãgõ kí dó pírí Áyĩ gá ãzíla ụ́ꞌdị́ kí dó ꞌbá ꞌdãá cí rĩ kí pírí. ");
INSERT INTO luc_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","ꞌBá Áyĩ drị́ ãgọbị rú ãzíla ũkú ru ũdrãlépi ụ́ꞌdụ́ ꞌdã sĩ rĩ kí ꞌbã kãlãfe pírí rĩ gá 12,000. ");
INSERT INTO luc_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Wó Yósũwã uja drị́ ĩꞌdi ꞌbã ĩjũlé ãjụ́ trũ rĩ vúlé ku kpere ꞌbá pírí uꞌálépi Áyĩ gá rĩ ꞌbã kí ị̃lị̃kị̃ agá. ");
INSERT INTO luc_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Wó ꞌbá Ịsịrayị́lị̃ drị̂ ꞌdụ kí dó ãnãkpá ãzíla ãko ĩꞌbã kí arálé ꞌbá Áyĩ gá rĩ ꞌbadrị́ táwụ̃nị̃ gá ꞌdãá rĩ kí ĩꞌbaní, ãꞌdusĩku ꞌdĩ ị́jọ́ Úpí ꞌbã jọlé Yósũwã ní ꞌbã idé rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Ị́jọ́ ꞌdĩ sĩ Yósũwã ivé dó Áyĩ rá, acá dó sĩ ándrú ru ãzíla kpere ãndrũ ace dó sĩ túrúmũ rú. ");
INSERT INTO luc_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","ꞌDã ꞌbã ũngúkú gá, Yósũwã nzi dó úpí Áyĩ drị̂ ife sị́ gá ãzíla aꞌbe dó ãvũ la ꞌdãá kpere ĩndró gá. Ị̃tụ́ ꞌbá ꞌde agá ꞌdĩ gá ꞌdĩ, Yósũwã fẽ dó ãzị́táŋá sĩ ĩꞌdi ꞌbã ãvũ ãtrũjó angájó ife sí gâlé rĩ sĩ ãzíla ĩꞌdi ꞌbejó vụ̃rụ́ táwụ̃nị̃ ꞌbã kẹ̃jị́tị sĩ fijó rĩ gá. Drõ kí dó írã ãmbogo la kí ĩꞌdi drị̃ gá cí kpere ãndrũ. ");
INSERT INTO luc_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","ꞌDã ꞌbã ũngúkú gá, Yósũwã sị dó ãlĩtárĩ ꞌbé Ĩbálĩ drị̃ gá Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ nî. ");
INSERT INTO luc_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","Sị ĩꞌdi cécé ãtíꞌbó Úpí Ãdróŋá drị́ Mụ́sã ꞌbã ándrá azịlé ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní sĩlé bụ́kụ̃ ãzị́táŋá drị́ Mụ́sã drị̂ agá rĩ áni: “Ísị mání ãlĩtárĩ írã lịlẹ́ ãzíla upalé aya sĩ ku la kí sĩ.” ꞌDã ꞌbã ũngúkú gá, idé kí dó ídétáŋá ivélé ivé rĩ kí ídétáŋá ásị́ ị̃gbẹ̃ drị̂ be Úpí nî. ");
INSERT INTO luc_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","ꞌBá Ịsịrayị́lị̃ drị̂ ꞌbã kí drĩ ãngũ ndre sĩ ꞌdĩ gá ꞌdâ, Yósũwã ũsĩ dó ãzị́táŋá ándrá Mụ́sã ꞌbã sĩlé ri kí írã ãzí kí drị̃ gá. ");
INSERT INTO luc_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","ꞌBá Ịsịrayị́lị̃ drị̂ kí pírí, ꞌbá ãmị́yọ́ŋá ru rĩ kí, ꞌbã ãngũ ꞌdị́pịka rú rĩ kí, ꞌbá drị̃lẹ́ ru rĩ kí, ꞌbá ĩdranigo rú rĩ kí, ꞌbá ị́jọ́ lịlẹ́pi rĩ kí abe utu kí dó pá ndre kí ru ndrẽ-ndrẽ Sãndụ́kụ̃ tị icíma drị́ ãtalo Lẹ́vị̃ rú rĩ ꞌbã kí ꞌdụlé sĩ tị icíma Úpí drị̂ ꞌbã tãmbajó rĩ ꞌbã drị̃lẹ́ gá. ꞌBá ꞌbã nụ́sụ̃ tu kí dó pá ꞌbé Gẹ̃rị̃zị́mụ̃ ꞌbã drị̃lẹ́ gá, ãzíla nụ́sụ̃ ãzí rĩ tukí pá ꞌbé Ĩbálĩ drị̃légá, cécé ãtíꞌbó Úpí drị́ Mụ́sã ꞌbã ándrá azịlé drị̃drị̃ ĩꞌdiní sĩ sụ̃sụ́ wijó ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","ꞌDã ꞌbã ũngúkú gá, Yósũwã la dó ị́jọ́ pírí ãzị́táŋá drị́ sĩ sụ̃sụ́ wijó ãzíla áwãtáŋá wãjó rĩ kí cécé kí sĩjó bụ́kụ̃ ãzị́táŋá drị̂ agá rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Ị́jọ́ ãzí ru aꞌbelépi ị́jọ́ Mụ́sã ꞌbã ándrá azịlé rĩ kí agá Yósũwã ꞌbã lãlé ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃lẹ́ gá ku la ꞌdáyụ. Lã ị́jọ́ ꞌdĩ ũkú kí drị̃lẹ́ gá anzịŋá kí abe ãzíla ꞌbá ãmị́yọ́ŋá ru uꞌálépi ꞌbá Ịsịrayị́lị̃ drị̂ kí drĩdríŋĩ gá rĩ ꞌbaní pírí ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Ũpi pírí Yõrĩdánĩ ꞌbã wókõ ị̃tụ́ ꞌbã ꞌde agâlé ru rĩ are kí dó ị́jọ́ ru idélépi rĩ kí rá. ꞌDĩ kí ũpi ꞌbá Hị́tị̃, Ãmọ́rị̃, Kãnánĩ, Pẹ̃rẹ́zị̃, Hị́vị̃ ãzíla Yẹ̃bụ́sị̃ drị́ uꞌálépi ãngũ ꞌbé ꞌa rú ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ kí ãzíla mĩrĩ Mẽdĩtẽránĩyãnĩ drị̂ ꞌbã tị gá cajó kpere ụ́rụ́ ꞌbé Lébãnõnĩ drị̂ kí agá rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","Ũpi ꞌdĩ trá kí dó ru ãlu sĩ ãꞌdị́ ꞌdịjó Yósũwã be ãzíla ꞌbá Ịsịrayị́lị̃ drị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Wó ꞌbá Gị̃bẹ̃yọ́nị̃ gá Hị́vị̃ rú rĩ are kí vâ ị́jọ́ Yósũwã ꞌbã ándrá idélé ꞌbá Yẹ̃rị́kọ̃ drị̂ ꞌba rụ́ ꞌbá Áyĩ drị̂ kí abe rĩ rá. ");
INSERT INTO luc_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","Ị́jọ́ ꞌdĩ sĩ ꞌbã kí dó ru ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ꞌbá ụ́ꞌdụ́kọ́ ajílépi angájó ãngũ álị́ gá la rú. Aꞌdụ́ kí dó kãyĩnõ kí drị̃ gá gụ̃tị́yã lẹ́rị́kọ́ ãzíla íníríkó sĩ wáyĩnĩ tõjó delépi rá ịgbẹlé ịgbẹ ị̃gbẹ̃ la kî. ");
INSERT INTO luc_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Su kí kí pá gá kámúka ũlũlépi rá la kí bõngó lẹ́rị́kọ́ la kí abe. Mũkátĩ ĩꞌbadrị́ nalé nãnã rĩ kí pírí ãꞌí ru ãzíla ãtõ kí rá. ");
INSERT INTO luc_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","ꞌDã ꞌbã ũngúkú gá, mụ kí dó Yósũwã rú kámbĩ gá Gị̃lị̃gálị̃ gâlé ãzíla jọ kí ĩꞌdiní ꞌbá Ịsịrayị́lị̃ drị̂ kí abe, “Ãma angá ãngũ álị́ gá, ãma amụ́ sĩ ími zịjó sĩ tị icíjó ãma abe.” ");
INSERT INTO luc_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Wó ꞌbá Ịsịrayị́lị̃ drị̂ jọ kí ꞌbá Hị́vị̃ drị̂ ꞌbaní, “Ĩmi ícó adrulé ꞌbá uꞌálépi ãmarụ́ ꞌdâ ãnirú la kí rá, ãma icó dó tị icílé ĩmi abe íngoníru?” ");
INSERT INTO luc_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Jọ kí, “Ãma ãtíꞌbó mî ãni.” Wó Yósũwã zị kí, “Ĩmi ãꞌdị kî, ĩmi angá íngõlé yã?” ");
INSERT INTO luc_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Umvi kí ĩꞌdiní, “Ãtiꞌbo mídrị́ ꞌdĩ angá kí ãngũ álị́ la gá, ãmbógó ãma are ị́jọ́ Úpí Ãdróŋá mídrị̂ ꞌbã rụ́ ꞌbã kụjó rĩ rá. Ãma are vâ ị́jọ́ pírí ĩꞌdi ꞌbã idélé ꞌbá Mị̃sị́rị̃ drị̂ kí ụrụꞌbá gá rĩ rá ");
INSERT INTO luc_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","ãzíla ị́jọ́ ĩꞌdi ꞌbã idélé ũpi ị̃rị̃ Ãmọ́rị̃ drị̂ ꞌbarụ́ Yõrĩdánĩ ꞌbã wókõ ị̃tụ́ ꞌbã agá agâlé ru rĩ kí rá. Úpí Sị̃họ́nị̃ Hẹ́sị̃bọ̃nị̃ drị́ ãzíla úpí Ụ́gị̃ Bãsánĩ drị́ ũpĩ nalépi Ãsĩtẽrótĩ gá rĩ ꞌba rụ́ rĩ rá. ");
INSERT INTO luc_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","ꞌBá ĩyõ ãmadrị̂ kí ꞌbá pírí uꞌálépi sụ́rụ́ ãmadrị̂ agá rĩ kí abe jọ kí ãmaní, ‘Ĩꞌdụ ãko ãzí kí ĩminí ãcị̃ ꞌdĩ ní ĩndĩ, ĩmụ dó ãzíla ĩmi ụfụ dó sĩ drị̃ ꞌbá Ịsịrayị́lị̃ drị̂ kí abe ãzíla ĩjọ ĩꞌbaní, “Ãma ãtiꞌbo ĩmi ãni, ĩmi icí tị ãma abe.”’ ");
INSERT INTO luc_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Mũkátĩ ãmadrị́ ꞌdĩ kí ándrá ãcí ru ãmaní kí ũꞌbãjó lị́cọ́ gâlé sĩ drị̃ akójó amụ́jó ĩmi rú ꞌdõlé rĩ sĩ. Wó ĩndre dó drĩ kí úꞌdîꞌda ãꞌí ru ãzíla ãtõ kí dó rá. ");
INSERT INTO luc_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Gọ́bẹ́rẹ́ wáyĩnĩ tõjó ꞌdĩ kí ándrá úꞌdí wó ĩndre dó drĩ de kí dó úꞌdîꞌda rá ãzíla asi kí dó rá. Bõngó ãmadrị̂ kí kámúka ãma pá gá rĩ kí abe de kí dó ãcị̃ ãzo ꞌdĩ sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","ꞌBá Ịsịrayị́lị̃ drị̂ aꞌdụ́ kí ãkónã ĩꞌbadrị̂ ãzí kí nalé rá wó zị kí Úpí tị gá ị́jọ́ gẹ̃rị̃ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","ꞌDã ꞌbã ũngúkú gá, Yósũwã idé dó tị icíma ásị́ ị̃gbẹ̃ drị̂ ꞌbá ꞌdĩ kí abe ĩꞌbaní dó sĩ icójó uꞌájó ị́jọ́ kọ́lị́, ãzíla ꞌbá drị̃lẹ́ ru ũꞌbí ꞌbadrị̂ na kí dó ũyõ sĩ ị́jọ́ ꞌdĩ tã mbajó rá. ");
INSERT INTO luc_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Ụ́ꞌdụ́ na ꞌbã vúlé gá ĩꞌbaní tị icíma ꞌdĩ idéjó ꞌbá Gị̃bẹ̃yọ́nị̃ ꞌbadrị̂ abe ꞌbo rĩ sĩ, ꞌbá Ịsịrayị́lị̃ drị̂ are kí dó ị́jọ́ ꞌbá ꞌdi kí jĩránĩ jõ uꞌálépi ĩꞌba rụ́ ꞌdãá ãníŋá gá la kî rĩ rá. ");
INSERT INTO luc_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Ị́jọ́ ꞌdĩ sĩ ꞌbá Ịsịrayị́lị̃ drị̂ ko kí dó drị̃ mụlé, ụ́ꞌdụ́ ꞌbã na la sĩ ca kí dó táwụ̃nị̃ ĩꞌbadrị̂ kí agá: Táwụ̃nị̃ ꞌdĩ kí: Gị̃bẹ̃yọ́nị̃ ꞌi, Kẽfírã ꞌi, Bẹ̃yãrọ́tị̃ ꞌi ãzíla Kĩrĩyátĩ Yẹ̃yãrị́mụ̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Wó ꞌbá Ịsịrayị́lị̃ drị̂ ꞌdị kí ãꞌdị́ ĩꞌba abe ku, ãꞌdusĩku ũꞌbí drị̃lẹ́ ru rĩ na kí ándrá ũyõ Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ ꞌbã rụ́ sĩ rá. ꞌBá Ịsịrayị́lị̃ drị̂ unu kí ándrá dó drị̃lẹ́ ĩꞌbadrị̂ ꞌba rú rá, ");
INSERT INTO luc_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","wó ꞌbá drị̃lẹ́ ru ꞌdĩ umvi kí, “Ãna dó ũyõ Úpí Ãdróŋá ãmadrị́ Ịsịrayị́lị̃ drị̂ ꞌbã rụ́ sĩ ꞌbo ãzíla ãma icó dó ꞌbá ꞌdĩ kí alólé úꞌdîꞌda ku.” ");
INSERT INTO luc_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Ị́jọ́ ꞌdĩ dó ãmaní mụlé idélé rĩ: Ãma kí aꞌbe uꞌálé ídri, ãdrĩ kí aꞌbe ku, adrã Ãdróŋá drị̂ la mụ aꞌdélé ãma drị̃ gá ũyõ ãmaní ándrá nalé ꞌbo rĩ anujó rĩ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","ꞌBá ĩyõ jọ kí ĩꞌbaní, “Lẽ ꞌba uꞌá kî, wó kí dó sĩ acá ꞌbá ãmaní ijijá galépi ãzíla ị̃yị́ ukólépi ũꞌbí ꞌbaní la kî rú.” Ị́jọ́ ꞌdĩ idé dó ru ꞌbá drị̃lẹ́ ru rĩ ꞌbã kí jọlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","ꞌDã ꞌbã ũngúkú gá, Yósũwã umve dó ꞌbá Gị̃bẹ̃yọ́nị̃ drị̂ kí ãzíla zị dó kî, “Ĩmi ulé dó ãma jọjó la, ‘Ãma ꞌbá uꞌálépi ãngũ alị́ gá la kî,’ wó ịsụ́ íni ꞌdĩ ĩmi ꞌbá ãma andre gá ãníyágágá ꞌdâ la kí la ãꞌdu ị́jọ́ sĩ? ");
INSERT INTO luc_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Ị́jọ́ ĩminí ngalé ꞌdĩ sĩ úwã dó ĩmi rá! Ĩmi dó ãzị́ ngá ꞌbá ijijá galépi ãzíla ꞌbá ị̃yị́ kolépi jó Ãdróŋá drị̂ agá la kî rú.” ");
INSERT INTO luc_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Umvi kí Yósũwã ní, “Ãma idé ị́jọ́ ꞌdĩ íni la, úlũ ándrá ãtíꞌbó mídrị̂ ꞌbaní tọndọlọ, Úpí Ãdróŋá ĩmidrị̂ azị ándrá ãtíꞌbó ĩꞌdidrị́ Mụ́sã ní ãngũ ꞌdĩ fẽjó pírí ĩminí ãzíla ꞌbá ala gá rĩ kí ị̃lị̃kị̃jó ĩmi drị̃lẹ́ gá rĩ sĩ pírí rá. Ị́jọ́ ꞌdĩ sĩ ãma idé dó ĩmi sĩ ụ̃rị̃ sĩ ídri ãmadrị̂ ꞌbã ị́jọ́ sĩ. ");
INSERT INTO luc_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Ãma dó ĩmi drị́ alégá ꞌdĩ. Ĩmi idé dó ị́jọ́ cí ĩminí ndrelé ĩꞌdi múké ãzíla pịrị ĩminí rĩ ãma ụrụꞌbá gá.” ");
INSERT INTO luc_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Ị́jọ́ ꞌdĩ sĩ Yósũwã pa dó ꞌbá ꞌdĩ kí ꞌbá Ịsịrayị́lị̃ drị̂ kí drị́ gá rá, ụꞌdị́ kí dó sĩ kí ku. ");
INSERT INTO luc_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Ụ́ꞌdụ́ ꞌdã sĩ Yósũwã ꞌbã dó ꞌbá Gị̃bẹ̃yọ́nị̃ drị̂ kí ꞌbá ijijá galépi ãzíla ꞌbá ị̃yị́ kolépi ũꞌbí ꞌbaní ãzíla ãlĩtárĩ Úpí drị́ ãngũ ĩꞌdi ꞌbã pẽlé rĩ gá rĩ kî rú. ꞌDĩ dó bã sĩ ãzị́ ꞌbá Gị̃bẹ̃yọ́nị̃ drị̂ ꞌbã kí ngalé kpere ãndrũ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Ãdọ̃nị̃-zẹ̃dẹ́kị̃ úpí Yẹ̃rụ́sãlẹ́mụ̃ drị̂ la dó mụ arelé la Yósũwã pa Áyĩ ꞌbo ãzíla andi ĩꞌdi cécé ĩꞌdi ꞌbã ándrá táwụ̃nị̃ Yẹ̃rị́kọ̃ drị̂ andijó rĩ áni, ꞌdị úpí ĩꞌdidrị̂ cécé ĩꞌdi ꞌbã ándrá úpí Yẹ̃rị́kọ̃ drị̂ ꞌdịjó rĩ áni ãzíla ꞌbá Gị̃bẹ̃yọ́nị̃ gá rĩ idé kí ị́jọ́ ásị́ ị̃gbẹ̃ ãni ꞌbá Ịsịrayị́lị̃ drị̂ kí abe sĩ uꞌájó kí drĩdríŋĩ gá, ");
INSERT INTO luc_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","ụ̃rị̃ ãmbógó la rụ dó ĩꞌdi ꞌbá ĩꞌdidrị̂ kí abe cí ãꞌdusĩku Gị̃bẹ̃yọ́nị̃ ándrá táwụ̃nị̃ ãzí ãmbógó la. Ĩꞌdi ándrá ãmbógó ru cécé táwụ̃nị̃ ãzí úpí ꞌbã sĩ uꞌájó ala gá rĩ kí ꞌbã ãzí áni, ndẽ ándrá Áyĩ ãmbõgõ sĩ rá ãzíla ãgọbị ala gá rĩ kí ándrá pírí ꞌbá ãꞌdị́ ãni la. ");
INSERT INTO luc_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Ị́jọ́ ꞌdĩ sĩ Ãdọ́nị̃-zẽdékĩ úpí Yẹ̃rụ́sãlẹ́mụ̃ drị̂ fẽ dó ụ́ꞌdụ́kọ́ úpí Họ̃hámụ̃ drị̂ ní, úpí Hẹ̃bụ̃rọ́nị̃ drị̂ ní, úpí Pị̃rámụ̃ drị̂ ní, úpí Yãrị̃mụ́tị̃ drị̂ ní, úpí Yáfĩyã drị̂ ní, úpí Lãkísĩ drị̂ ní ãzíla úpí Dẹ̃bị́rị̃ Ị̃gị̃lọ́nị̃ drị̂ ní. ");
INSERT INTO luc_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","Ãdọ́nị̃-zẽdékĩ jọ ũpi ꞌdĩ ꞌbaní, “Ĩmi amụ́ má rụ́ ꞌdõlé áma ãzã kojó sĩ ãꞌdị́ ꞌdịjó Gị̃bẹ̃yọ́nị̃ be ãꞌdusĩku idé kí ásí ị̃gbẹ́ Yósũwã be ãzíla ꞌbá Ịsịrayị́lị̃ drị̂ kí abe.” ");
INSERT INTO luc_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","ꞌDã ꞌbã ũngúkú gá, ũpi tõwú Ãmọ́rị̃ drị̂ kí: úpí Yẹ̃rụ́sãlẹ́mụ̃ drị́, Hẹ̃bụ̃rọ́nị̃ drị́, Yãrị̃mụ́tị̃ drị́, Lãkísĩ drị́ ãzíla úpí Ị̃gị̃lọ́nị̃ drị̂ kí abe icí kí dó ãsĩkárĩ ĩꞌbadrị̂ kí ãlu sĩ mụjó ãꞌdị́ gá ꞌbá Gị̃bẹ̃yọ́nị̃ drị̂ ꞌbarụ́. ");
INSERT INTO luc_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Cọtị ꞌbá Gị̃bẹ̃yọ́nị̃ drị̂ fẽ kí dó ụ́ꞌdụ́kọ́ Yósũwã ní kámbĩ gá Gị̃lị̃gálị̃ gâlé ãzíla jọ kí, “Mí aꞌbe jõ ãtiꞌbo mídrị̂ kí ku fô! Mí amụ́ ãma rụ́ ꞌdõlé gbõrú sĩ ãma pajó. Íko ãma ãzã ãꞌdusĩku ũpi Ãmọ́rị̃ drị́ ꞌbé ꞌa gá rĩ tra kí ãsĩkárĩ ĩꞌbadrị̂ kí pírí sĩ ãꞌdị́ ꞌdịjó ãma be.” ");
INSERT INTO luc_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Ị́jọ́ ꞌdĩ sĩ Yósũwã amụ́ dó angájó Gị̃lị̃gálị̃ gá rĩ sĩ ãsĩkárĩ ĩꞌdidrị̂ kí abe pírí ãsĩkárĩ ĩꞌdidrị́ ũkpó ndẽlépi ãꞌdị́ ꞌdịŋá sĩ nĩ rĩ kî trũ. ");
INSERT INTO luc_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Úpí jọ Yósũwã ní, “Mí idé jõ ꞌbá ꞌdĩ kí sĩ ụ̃rị̃ sĩ ku, ãꞌdusĩku áfẽ kí ími drị́ alé gá ꞌbo. ꞌBá ꞌdi kí ꞌbã ãzí icólépi pá tulépi ími drị̃lẹ́ gá rá la, la adru ꞌdáyụ.” ");
INSERT INTO luc_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Ị́jọ́ ꞌdĩ sĩ Yósũwã amụ́ dó angájó Gị̃lị̃gálị̃ gâlé rĩ sĩ ị́nị́ ãrã sĩ ãꞌdị́ ꞌdị jó ũpi ꞌdĩ kí abe ĩꞌbaní nĩŋá kó ru. ");
INSERT INTO luc_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Úpí fẽ ꞌbá ꞌdĩ acá kí dó ụ̃rị̃ sĩ ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃lẹ́ gá ãzíla ụlị́ kí dó kí kãlãfe ãmbógó la sĩ Gị̃bẹ̃yọ́nị̃ gá ꞌdãá. ꞌDã ꞌbã ũngúkú gá, ꞌbá Ịsịrayị́lị̃ drị̂ dro kí dó mẹ́rọ́ꞌbá ꞌdĩ kí gẹ̃rị̃ Bẹ̃tị̃ Họ̃rọ́nị̃ drị̂ gâsĩ, mụ kí dó kí ụꞌdị́ trũ kpere Ãzékã gá ãzíla Mãkédã gá. ");
INSERT INTO luc_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","ꞌBá Ãmọ́rị̃ drị̂ ꞌbã kí apájó ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃lẹ́ gá ãngũ ilúlépi Bẹ̃tị̃ Họ̃rọ́nị̃ gá ꞌbo rĩ sĩ, Úpí fẽ dó sí gbongo gbongo la ꞌbaní uꞌdejó kí drị̃ gá angájó ꞌbụ̃ gâlé kpere cajó Ãzékã gá ãzíla ũdrã kí dó sĩ rá. ꞌBá ũdrãlépi sí sĩ rĩ ꞌbã kãlãfe ndẽ anzị Ịsịrayị́lị̃ drị̂ ꞌbã kí ụꞌdị́lé ménéŋá sĩ rĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Ụ́ꞌdụ́ ꞌdã sĩ Yósũwã jọ kí dó ị́jọ́ Úpí be sáwã ĩꞌdi ꞌbã ꞌbá Ãmọ́rị̃ drị̂ kí fẽjó anzị Ịsịrayị́lị̃ drị̂ kí drị́lẹ́ agá ꞌbo rĩ sĩ. Jọ anzị Ịsịrayị́lị̃ drị̂ kí drị̃lẹ́ gá: “Ị̃tụ̂, ítu pá Gị̃bẹ̃yọ́nị̃ drị̃ gá ꞌdâ cí, ãzíla ĩmbâ ítu pá cí áꞌbụ̂ Ãyị̃yãlọ́nị̃ drị̂ drị̃ gá.” ");
INSERT INTO luc_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Ị́jọ́ ꞌdĩ sĩ ị̃tụ̂ tu dó sĩ pá liri ãzíla ĩmbâ tu vâ pá liri mụŋá kó ru, kpere sụ́rụ́ Ịsịrayị́lị̃ drị̂ ꞌbã ru ãrígọ́tị ũfẽ agá mẹ́rọ́ꞌbá ĩꞌdidrị̂ ꞌba rụ́ rá ká, cécé sĩlé bụ́kụ̃ Yãsírĩ drị̂ agá rĩ áni. Ị̃tụ̂ tu dó sĩ pá ꞌbụ̃ gá ágágá ꞌdâ ãzíla ꞌde dó sĩ ku ụ́ꞌdụ́ ãlu ndị. ");
INSERT INTO luc_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Ụ́ꞌdụ́ ãzí jõ drĩ ídu jõku iꞌdójó sáwã ꞌdã sĩ Úpí ꞌbã sĩ ꞌbá ꞌbá ru rĩ ꞌbã tị arejó ꞌdĩ ꞌbã áni la ꞌdáyụ. Ụ́ꞌdụ́ ꞌdã sĩ ãndá-ãndá ru Úpí ꞌdị ãꞌdị́ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní nĩ. ");
INSERT INTO luc_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","ꞌDã ꞌbã ũngúkú gá, Yósũwã uja kí dó ru anzị Ịsịrayị́lị̃ drị̂ kí abe pírí kámbĩ agá Gị̃lị̃gálị̃ gâlé vúlé. ");
INSERT INTO luc_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Ũpi tõwú ꞌdĩ apá kí dó ru ụ̃zị̃lé ụ̃jị́gọ́ Mãkédã gá rĩ agá. ");
INSERT INTO luc_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","Ála dó mụ lũlé la Yósũwã ní ị́sụ́ dó ũpi tõwú ꞌdĩ kí ĩꞌbã kí ru ụ̃zị̃ agâ ụ̃jị́gọ́ Mãkédã gá rĩ gá ꞌbo íni, ");
INSERT INTO luc_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","Yósũwã jọ dó sĩ, “Ĩgũ írã kpakụ la kí ụ̃jị́gọ́ tị gá cí ãzíla ĩꞌbã ꞌbá ãzí kí tị la ũtẽjó, ");
INSERT INTO luc_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","wó lẽ ĩmi uꞌá ꞌdãá áyụ ku. Ĩmi ũbĩ mẹ́rọ́ꞌbá ĩmidrị̂ kí vú, ĩmi ụꞌdị́ kí iꞌdójó vúlé lé ru ãzíla lẽ ĩfẽ ꞌbã ca kí táwụ̃nị̃ ĩꞌbadrị̂ kí agâlé ku, ãꞌdusĩku Úpí Ãdróŋá ĩmidrị̂ fẽ kí ĩmi drị́ gá ꞌbo.” ");
INSERT INTO luc_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Yósũwã kí dó mụ anzị Ịsịrayị́lị̃ drị̂ kí abe ꞌbá ꞌdĩ kí delé uꞌdị́lé pírí ꞌbo, ãzíla ꞌbá ꞌdĩ ꞌbã ị́mbị́ acelépi rĩ ꞌbã ãzí kí dó mụ filé táwụ̃nị̃ celé Bõrõ sĩ cí rĩ kí agâlé ꞌbo, ");
INSERT INTO luc_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","ꞌdã bã ũngúkú gá ꞌbá pírí ãgõ kí dó Yósũwã rú kámbĩ agá ꞌdõlé ãlá ru, ꞌbá ãzí ru tị nzị̃lépi sĩ ị́jọ́ jọjó anzị Ịsịrayị́lị̃ drị̂ kí ụrụꞌbá gá ũnzí la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","ꞌDã ꞌbã ũngúkú gá, Yósũwã jọ, “Ị̃nzị̃ dó ụ̃jị́gộ tị mgbọ ãzíla ĩmi iyá ũpi tõwú ꞌdã kí ajílé má rụ́ ꞌdõlé.” ");
INSERT INTO luc_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Ị́jọ́ ꞌdĩ sĩ ꞌbá ꞌdã nzị̃ kí dó sĩ ụ̃jị́gộ tị rá ãzíla ají kí dó ũpi tõwú ꞌdã kí Yósũwã rụ́ ꞌdõlé. Úpí la kí: Úpí Yẹ̃rụ́sãlẹ́mụ̃ drị̂ ꞌi, úpí Hẹ̃bụ̃rọ́nị̃ drị̂ i, úpí Yãrị̃mụ́tị̃ drị̂ ꞌi, úpí Lãkísĩ drị̂ ꞌi ãzíla úpí Ị̃gị̃lọ́nị̃ drị̂ i. ");
INSERT INTO luc_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Kí dó mụ ũpi ꞌdĩ kí ajílé ãmvé Yósũwã rú ꞌdõlé ꞌbo, Yósũwã umve dó anzị Ịsịrayị́lị̃ drị̂ kí pírí ãzíla jọ dó ꞌbá ãmbogo rú ãꞌdị́ drị̃ celépi mụlépi ĩꞌdi be ĩndĩ rĩ ꞌbaní, “Ĩmi asé ĩmi ãni rú; ĩmi ũꞌbã ĩmi pá kí ũpi ꞌdĩ kí imbe gá.” ꞌDã ꞌbã ũngúkú gá, asé kí dó ru ãni rú ãzíla ũꞌbã kí dó ĩꞌbã pá kí ũpi ꞌdĩ kí imbe gá. ");
INSERT INTO luc_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Yósũwã jọ dó ĩꞌbaní, “Ĩmi idé jõ ụ̃rị̃ sĩ ku, ĩmi ịsụ́ jõ ũkpõ ãkõ ku. Ĩmi adru jõ ũkpó ru ãzíla ĩmi ásị́ ꞌbã mbajõ mba mbã ãꞌdusĩku Úpí lã mụ ị́jọ́ ꞌdĩ kí idélé mẹ́rọ́ꞌbá ĩmidrị́ ĩminí sĩ ãꞌdị́ ꞌdịjó ꞌdĩ ꞌba rụ́ nĩ.” ");
INSERT INTO luc_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","ꞌDã ꞌbã ũngúkú gá, Yósũwã ụꞌdị́ dó ũpi tõwú ꞌdĩ kí rá ãzíla ũgĩ dó sí ãvũ la kí ife tõwú kí sị́ gá. Ãvũ la ri kí adrulé ife kí sị́ gá ꞌdãá kpere ĩndró sĩ. ");
INSERT INTO luc_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Wó ị̃tụ̂ ꞌbã ꞌde agâ ꞌdĩ gá ꞌdĩ Yósũwã fẽ dó ãzị́táŋá sĩ ãvũ la kí ũtrũjó ife kí sị́ gâlé rĩ sĩ rá, âgụ dó kí uꞌbélé ụ̃jị́gọ́ ándrá ĩꞌbã kí sĩ ru ụ̃zị̃jó rĩ gá, ãzíla aꞌdụ́ kí dó sĩ írã kpakụ la kí sĩ ụ̃jị́gọ́ tị ũdrõjó, kí drĩ kpere ãndrũ ꞌdãá cí. ");
INSERT INTO luc_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Ụ́ꞌdụ́ ꞌdã sĩ Yósũwã ꞌdụ dó táwụ̃nị̃ Mãkédã drị̂ rá ãzíla ụꞌdị́ dó sĩ ꞌbá alagá ri kí úpí ĩꞌdidrị̂ be ménéŋá sĩ rá, ị̃lị̃kị̃ ꞌbá alagá rĩ kí pírí, aꞌbe ꞌbá ãzí ídri ãluŋá la ku. Ídé ị́jọ́ úpí Mãkédã drị̂ rụ́ cécé ĩꞌdi ꞌbã ándrá idéjó la úpí Yẹ̃rị́kọ̃ drị̂ rụ́ rĩ ꞌbã áni. ");
INSERT INTO luc_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","ꞌDã ꞌbã ũngúkú gá, Yósũwã alị kí dó ꞌbá Ịsịrayị́lị̃ drị̂ kí abe pírí Mãkédã gá rĩ sĩ Líbĩnã gá ãzíla ꞌdị kí dó sĩ ãꞌdị́ ꞌbá Líbĩnã gá rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Úpí fẽ vâ táwụ̃nị̃ Líbĩnã drị̂ úpí alagá rĩ be anzị Ịsịrayị́lị̃ drị̂ kí drị́ alé gá. Yósũwã ụꞌdị́ dó ꞌbá ala gá ri kí pírí ménéŋá sĩ, aꞌbe ꞌbá ãzí ídri la ãluŋá la ku. Idé dó ị́jọ́ úpí ꞌdĩ ụrụꞌbá gá cécé ĩꞌdi ꞌbã ándrá idélé úpí Yẹ̃rị́kọ̃ drị̂ ụrụꞌbá gá rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","ꞌDã ꞌbã ũngúkú gá, Yósũwã kí ꞌbá pírí Ịsịrayị́lị̃ drị̂ kí abe alị kí dó Líbĩnã gá rĩ sĩ Lãkísĩ gá, ce kí ĩꞌdi ãzíla ꞌdị kí ãꞌdị́ ꞌbá ala gá rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Úpí fẽ dó ꞌbá Ịsịrayị́lị̃ drị̂ ndẽ kí dó ꞌbá Lãkísĩ drị̂ kí rá, Yósũwã pa dó ãngũ ĩꞌbadrị̂ ụ́ꞌdụ́ ị̃rị̃ la sĩ ãzíla ụꞌdị́ dó ꞌbá ala gá rĩ kí pírí ménéŋá sĩ ĩꞌdi ꞌbã ándrá idélé Líbĩnã gá rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","ꞌDã ꞌbã ũngúkú gá, úpí Hõrámũ Gẹ̃zẹ́rị̃ drị̂ amụ́ dó sĩ ꞌbá Lãkísĩ drị̂ kí ãzã kolé ãzíla Yósũwã ụꞌdị́ dó kí ꞌbá ĩꞌdidrị̂ kí abe pírí, aꞌbe ꞌbá ãzí ídri la ãluŋá la ku. ");
INSERT INTO luc_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","ꞌDã ꞌbã ũngúkú gá, Yósũwã kí ꞌbá Ịsịrayị́lị̃ drị̂ kí abe pírí alị kí dó Lãkísĩ gá rĩ sĩ sĩ mụjó Ị̃gị̃lọ́nị̃ gá ãzíla ce kí dó ꞌbá ala gá rĩ kí rị́ sĩ ãꞌdị́ ꞌdịjó ĩꞌba abe. ");
INSERT INTO luc_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Yósũwã ꞌdụ kí ãngũ ꞌdã ụ́ꞌdụ́ ꞌdã sĩ rá, ụꞌdị́ kí ꞌbá ala gá rĩ kí pírí ménéŋá sĩ cécé ĩꞌdi ꞌbã ándrá idélé ꞌbá Lãkísĩ gá rĩ ꞌba rụ́ rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","ꞌDã ꞌbã ũngúkú gá, Yósũwã kí ꞌbá Ịsịrayị́lị̃ drị̂ kí abe mụ kí Ị̃gị̃lọ́nị̃ gá rĩ sĩ Hẹ̃bụ̃rọ́nị̃ gá, ce kí ꞌbá ala gá rĩ kí rị́, ");
INSERT INTO luc_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","pa kí ĩꞌdi rá ãzíla ị̃lị̃kị̃ kí táwụ̃nị̃ bá ala gá rĩ kí pírí úpí ĩꞌdidrị̂ be ménéŋá sĩ. ꞌBá ãzí aꞌbelé ídri la ãluŋá la ꞌdáyụ. Idé kí ị́jọ́ ĩꞌba rụ́ cécé ĩꞌbã kí ándrá idélé ꞌbá Ị̃gị̃lọ́nị̃ gá rĩ ꞌba rụ́ rĩ áni. Ị̃lị̃kị̃ kí dó táwụ̃nị̃ ꞌi ꞌbá ala gá rĩ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","ꞌDã ꞌbã ũngúkú gá, Yósũwã kí ꞌbá Ịsịrayị́lị̃ drị̂ kí abe uja kí dó ru vúlé sĩ ãꞌdị́ ꞌdịjó ꞌbá Dẹ̃bị́rị̃ gá rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","ꞌDụ kí táwụ̃nị̃ ꞌdã, úpí ala gá rĩ ꞌi ãzíla ꞌbá ĩꞌdidrị̂ kí abe rá. Ụꞌdị́ kí kí pírí ménéŋá sĩ, aꞌbe kí ꞌbá ãzí ídri la ãluŋá la ku. Idé kí ị́jọ́ táwụ̃nị̃ Dẹ̃bị́rị̃ drị̂ rụ́ cécé ĩꞌbã kí ándrá idélé Hẹ̃bụ̃rọ́nị̃ ꞌba rụ́ Líbĩnã be rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","Ị́jọ́ ꞌdĩ sĩ Yósũwã upa dó sĩ ãngũ ꞌdãá rĩ kí pírí, ãngũ ꞌbé ru rĩ, Nẹ̃gẹ́vụ̃ ꞌi, ãngũ ụ́rụ́ rĩ, ãngũ áꞌbụ ꞌa rú rĩ, ãngũ ilúlépi ilú-ilû rĩ ãzíla ũpi la ala gá rĩ kí abe pírí. Aꞌbe ꞌbá ãzí ku, wó ụꞌdị́ ãko ídri trũ ꞌdĩ kí pírí rá, cécé Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ ꞌbã ándrá azịlé rĩ ꞌbã áni. ");
INSERT INTO luc_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","Yósũwã ụꞌdị́ ꞌbá ꞌdĩ kí iꞌdójó Kãdẹ́sị̃-bãrĩnéyã gá, kpere Gázã gá, ãngũ Gõsénĩ drị̂ pírí cajó kpere Gị̃bẹ̃yọ́nị̃ gá. ");
INSERT INTO luc_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Yósũwã ndẽ ũpi ꞌdĩ kí pírí ãzíla pa ãngũ ĩꞌbadrị̂ kí pâlé ãlu, ãꞌdusĩku Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ ꞌdị ãꞌdị́ ĩꞌbaní nĩ. ");
INSERT INTO luc_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","ꞌDã ꞌbã ũngúkú gá, Yósũwã uja kí dó ru anzị Ịsịrayị́lị̃ drị̂ kí abe pírí kámbĩ gá Gị̃lị̃gálị̃ gâlé. ");
INSERT INTO luc_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","Úpí Hãzọ́rị̃ drị́ Yãbínĩ la mụ arelé la ãsĩkárĩ Ịsịrayị́lị̃ drị̂ ꞌdụ kí dó ãngũ ꞌdã pírí ꞌbo, ị̃drị̃ dó ụ́ꞌdụ́kọ́ tị úpí Yõbábũ Mãdónĩ gá rĩ rụ́, úpí Sị̃mị̃rọ́nị̃ gá rĩ rụ́, ãzíla úpí Ãkĩsáfũ gá rĩ rụ́, ");
INSERT INTO luc_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","ũpi ãngũ ꞌbé ꞌa rú ụ́rụ́ vâ Ãrábã Kị̃nẹ̃rẹ́tị̃ ꞌbã wókõ ándrá rĩ gá, ãngũ áꞌbụ ꞌa rú rĩ ãzíla ãngũ Nãfọ́tị̃ Dọ́rị̃ ị̃tụ́ ꞌbã ꞌde ágâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","ꞌBá Kãnánĩ rú ị̃tụ́ ꞌbã ãfũ agá ãzíla ị̃tụ́ ꞌbã ꞌde ágâlé ru rĩ kí, ꞌbá Ãmọ́rị̃ drị́, ꞌbá Hị́tị̃ drị́, ꞌbá Pẹ̃rẹ́zị̃ drị́, ꞌbá Yẹ̃bụ́sị̃ drị́ ꞌbé agá rĩ kí ãzíla ꞌbá Hị́vị̃ drị́ uꞌálépi úpí Hẹ̃rị̃mọ́nị̃ ãngũ Mị̃zị́pã drị̂ pálé gá rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Ãfũ kí ãmvé ꞌdõlé ãsĩkárĩ ĩꞌbadrị̂ kí abe pírí, ãzíla fãrásĩ ũꞌbí la kí abe ãzíla gárĩ ãꞌdị́drị̂ kí abe. Kãlãfe ãsĩkárĩ ꞌbadrị̂ ũꞌbíkãná ru cécé cínákí mĩrĩ tị gá rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Ũpi ꞌdĩ icí kí dó ãsĩkárĩ ĩꞌbadrị̂ kí pírí ãngũ ãlu gá ãzíla ꞌbã kí dó kámbĩ ĩꞌbadrị̂ ị̃yị́ tị Mẹ̃rọ́mụ̃ drị̂ gá, sĩ ãꞌdị́ ꞌdịjó ꞌbá Ịsịrayị́lị̃ drị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","ꞌDã ꞌbã ũngúkú gá, Úpí jọ Yósũwã ní, “Mí idé kí sĩ ụ̃rị̃ sĩ ku, ãꞌdusĩku drụ̃sị̃ cé sáwã ꞌdĩ ꞌbã áni rĩ gá ma mụ kí fẽlé pírí ꞌbá Ịsịrayị́lị̃ drị̂ kí drị́ gá, kí kí ụꞌdị́ pírí rá. Mĩ mụ fãrásĩ ĩꞌbadrị̂ kí ꞌbã ị́sụ́ kpọrọlọ gá rĩ kí ụlị́lé rá ãzíla gárĩ ĩꞌbadrị́ ãꞌdị́ drị̂ kí ivélé ãcí sĩ rá.” ");
INSERT INTO luc_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Ị́jọ́ ꞌdĩ sĩ Yósũwã kí ãsĩkárĩ ĩꞌdidrị́ ãꞌdị́ drị̂ kí abe pírí mụ kí dó sĩ ꞌbá ꞌdĩ kí celé ị̃yị́ Mẹ̃rọ́mụ̃ ꞌbã tị gá ꞌdãá ĩꞌbã nĩŋá kó ru, ");
INSERT INTO luc_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","ãzíla Úpí fẽ anzị Ịsịrayị́lị̃ drị̂ ndẽ kí dó ꞌbá ꞌdĩ kí rá. Ụꞌdị́ kí dó kí rá ãzíla dro kí dó kí kpere ãngũ ãmbógó Sị̃dọ́nị̃ rĩ gá ãzíla Mĩsĩrẽfótĩ Mãyị́mụ́ gá, áꞌbụ Mị̃zị́pã drị́ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá. Ụꞌdị́ kí dó kí pírí ãzíla ꞌbá ãzí ru palépi ídri rú ãluŋá la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Yósũwã idé dó ị́jọ́ kí ꞌbá ꞌdĩ ꞌba rụ́ cécé Úpí ꞌbã jọlé ĩꞌdiní rĩ áni, ụlị́ dó sĩ fãrásĩ ĩꞌbadrị̂ kí ꞌbã ị́sụ́ kpọrọlọ gá rĩ kí rá ãzíla ivé dó gárĩ ĩꞌbadrị́ ãꞌdị́drị̂ kí ãcí sĩ rá. ");
INSERT INTO luc_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Sáwã ꞌdã sĩ Yósũwã uja dó ru vúlé ãzíla pa dó Hãzọ́rị̃ rá, ꞌdị úpí ĩꞌdidrị̂ ménéŋá sĩ (Hãzọ́rị̃ ĩꞌdi ándrá sáwã ãzí sĩ vúlêlé ru táwụ̃nị̃ ãmbógó sụ́rụ́ ꞌdã ꞌbadrị́ pírí rĩ ꞌi). ");
INSERT INTO luc_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Ụꞌdị́ kí dó ꞌbá ala gá rĩ kí pírí ménéŋá sĩ. Ị̃lị̃kị̃ kí dó sĩ kí pírí ãzíla ivé kí dó sĩ táwụ̃nị̃ Hãzọ́rị̃ drị̂ ãcí sĩ rá. ");
INSERT INTO luc_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Yósũwã upa táwụ̃nị̃ ũpi ꞌdã ꞌbadrị̂ kí rá ãzíla ị̃lị̃kị̃ dó ũpi la ala gá rĩ kí pírí ménéŋá sĩ cécé ãtíꞌbó Úpí drị́ Mụ́sã ꞌbã ándrá ũkpó la fẽjó rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Wó Táwụ̃nị̃ ꞌbá ꞌdã ꞌbadrị́ ándrá sịlé ándrú agá rĩ kí ꞌbá Ịsịrayị́lị̃ drị̂ ivé kí kí gẹ̃rị̃ sĩ ku, Yósũwã ivé lú rá la táwụ̃nị̃ Hãzọ́rị̃ drị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","ꞌBá Ịsịrayị́lị̃ drị̂ ꞌdụ kí dó ãko táwụ̃nị̃ ivélé rá ꞌdĩ agá ꞌdĩ kí ãnãkpá kí abe pírí ĩꞌbanî. Wó ụꞌdị́ kí dó ꞌbá kí pírí ménéŋá sĩ kpere ĩꞌbã kí ꞌbá ꞌdã kí ị̃lị̃kị̃ agâ pírí, ꞌbá ãzí acelépi ídri rá la ãluŋá la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Cécé Úpí ꞌbã ándrá ũkpó la fẽjó ãtíꞌbó ĩꞌdi ãni Mụ́sã drị́ rĩ áni, ị́jọ́ ꞌdĩ sĩ Mụ́sã fẽ dó ãzị́táŋá Yósũwã drị́, Yósũwã idé dó ꞌdã ꞌbã áni. Ị́jọ́ ãzí Mụ́sã ꞌbã ũkpó la fẽjó Yósũwã ní rá, ĩꞌdi ꞌbã idélé ku la ꞌdáyụ. ");
INSERT INTO luc_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Ị́jọ́ ꞌdĩ sĩ Yósũwã upa dó ãngũ ꞌbé ꞌa rú, Nẹ̃gẹ́vụ̃ gá, ãngũ Gõsénĩ drị́, ãngũ Ịsịrayị́lị̃ drị́ ꞌbé pá ru ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ ꞌi, ãngũ Ãrábã drị̂ ꞌi ãzíla ãngũ áꞌbụ ꞌa rú rĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","ãngũ angálépi ꞌbé Hãnókĩ gá, tụlépi Sẽyírĩ gâlé ru rĩ ꞌi, cajó kpere Bãlĩ-gádĩ gá, áꞌbụ ꞌa Lébãnõnĩ drị̂ gá, ꞌdĩ ꞌbé Hẹ̃rị̃mọ́nị̃ drị̂ ꞌbã pá gá. Rụ ũpi ĩꞌbadrị̂ kí pírí, aco kí vũ rụ́ ãzíla ụꞌdị́ kí rá. ");
INSERT INTO luc_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","Yósũwã ꞌdị ãꞌdị́ ũpi ꞌdĩ kí abe sáwã ãzo rú. ");
INSERT INTO luc_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","Táwụ̃nị̃ ásị́ ị̃gbẹ́ idélépi ꞌbá Ịsịrayị́lị̃ drị̂ kí abe rá rĩ lú Gị̃bẹ̃yọ́nị̃ ꞌi, ꞌdĩ ãngũ ꞌbá Hị́vị̃ rú ꞌdĩ ꞌbã ãzí ꞌbã kí sĩ uꞌájó rĩ ꞌi. Úrụ táwụ̃nị̃ ãzí ꞌdĩ kí pírí ãꞌdị́ sĩ. ");
INSERT INTO luc_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","Wó Úpí ꞌbã ãmgbã rĩ fẽ ꞌbá ꞌdĩ kí ꞌbã ásị́ ní mbajó sĩ ãꞌdị́ ꞌdịjó ꞌbá Ịsịrayị́lị̃ drị̂ kí abe rĩ gá nĩ, ị́jọ́ ꞌdĩ sĩ ĩꞌdi dó sĩ kí ị̃lị̃kị̃ ásị́ ị̃gbẹ̃ kó ru benĩ, cécé Úpí ꞌbã ándrá ãzị́táŋá la fẽjó Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Sáwã ꞌdã sĩ Yósũwã mụ dó ꞌbá Ãnákĩ drị̂ kí ị̃lị̃kị̃lé ãngũ ꞌbé ꞌa rú rĩ ágá ꞌdãá rĩ sĩ angájó Hẹ̃bụ̃rọ́nị̃ gá, Dẹ̃bị́rị̃ gá ãzíla Ãnábũ gá, ãngũ ꞌbé ꞌa rú Yụ́dã drị̂ gá ãzíla ãngũ ꞌbé ꞌa rú Ịsịrayị́lị̃ drị̂ gá. Yósũwã ị̃lị̃kị̃ dó ꞌbá ꞌdĩ kí táwụ̃nị̃ ĩꞌbadrị̂ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","ꞌBá Ãnákĩ drị́ ãzí aꞌbelé sụ́rụ́ Ịsịrayị́lị̃ drị̂ agá ídri rú rá la ꞌdá yụ, rá la lú Gázã gá, Gátũ gá ãzíla Ãsị̃dọ́dị̃ gá. ");
INSERT INTO luc_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Ị́jọ́ ꞌdĩ sĩ Yósũwã ꞌdụ dó ãngũ ꞌdã pírí rá cécé Úpí ꞌbã jọlé Mụ́sã ní rĩ áni. Yósũwã fẽ dó sĩ ãngũ ꞌdã ꞌi ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ãwítã rú ínátị ĩꞌbadrị́ awalé rĩ kí vú sĩ. ꞌDã ꞌbã ũngúkú gá, ꞌbá Ịsịrayị́lị̃ drị̂ avị́ kí dó drĩ vâ ãꞌdị́ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","ꞌDĩ kí ũpi ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã kí ndẽlé rá ĩꞌbã kí sĩ ãngũ ĩꞌbadrị̂ kí ꞌdụjó ĩꞌbã ani la rú wókõ Yõrĩdánĩ drị́ ĩtụ́ ꞌbã ãfũ agâlé ru rĩ gá, angájó áꞌbụ Ãrị̃nọ́nị̃ gá cajó kpere ꞌbé Hẹ̃rị̃mọ́nị̃ gá, ãngũ Ãrábã drị́ wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ trũ ri kî. ");
INSERT INTO luc_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","Úpí Sị̃họ́nị̃ ꞌbá Ãmọ́rị̃ gá rĩ ꞌbadrị̂ ĩꞌdi ándrá úpí Hẹ́sị̃bọ̃nị̃ gá rĩ ꞌi. Rụ ándrá ãngũ angájó Ãrówã gá ꞌdĩ, áꞌbụ ꞌa Ãrị̃nọ́nị̃ drị̂ gâsĩ kpere mĩrĩ Yãbọ́kị̃ gá, ꞌdĩ lõkókõrí ꞌbá Ãmọ́nị̃ drị̂ ꞌbadrị́ ãngũ Gị̃lẹ́dị̃ drị̂ ꞌbã nụ́sụ̃ be rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","Rụ vâ ãngũ ị̃tụ̂ ꞌbã ãfũ agâlé ru Ãrábã drị́ angájó mĩrĩ Kị̃nẹ̃rẹ́tị̃ gá kpere mĩrĩ Ãrábã ꞌdĩ mĩrĩ Ãꞌị́ ru rĩ ꞌi, kpere Bẹ̃tị̃ Yẹ̃sị̃mọ́tị̃ gá ãngũ ilũlépi ꞌbé Pị́sị̃gã ꞌbã pá gá wókõ ándrá lé rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","Ndẽ kí ándrá vâ úpí Ụ́gị̃ Bãsánĩ drị́ ꞌbá Rẹ̃fãyị́mụ̃ drị́ ị́mbị́ acelépi rĩ kí agá ándrá ãngũ rụlépi Ãsị̃tãrọ́tị̃ gá kpere Ị̃drẹ́yị̃ gá rĩ ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","Rụ ándrá ãngũ ꞌbé Hẹ̃rị̃mọ́nị̃ drị̂ ꞌi, táwụ̃nị̃ Sãlékã drị̂ ꞌi, ãzíla ãngũ Bãsánĩ drị̂ pírí kpere lõkókõrí ꞌbá Gẹ̃sụ̃rụ́tị̃ rú rĩ ꞌbadrị́ ꞌbá Mãkátĩ rú rĩ kí abe rĩ gá, ãngũ Gị̃lẹ́dị̃ drị̂ ꞌbã nụ́sụ̃ trũ kpere lõkókõrí úpí Sị̃họ́nị̃ ꞌbadrị́ Hẹ́sị̃bọ̃nị̃ be rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","Ãtíꞌbó Úpí drị́ Mụ́sã kí ꞌbá Ịsịrayị́lị̃ drị̂ kí abe ndẽ kí kí rá. Ãtíꞌbó Úpí drị́ Mụ́sã fẽ dó sĩ ãngũ ĩꞌbadrị̂ ꞌbá Rụ́bẹ̃nị̃ drị̂ ꞌbaní, ꞌbá Gádĩ drị̂ abe ãzíla sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ ꞌbaní ãwítã rú. ");
INSERT INTO luc_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","ꞌDĩ kí ũpi Yósũwã ꞌbã kí ndẽlé ꞌbá Ịsịrayị́lị̃ drị̂ kí abe Yõrĩdánĩ ꞌbã wókõ ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ gá angájó Bãlĩ-gádĩ áꞌbụ ꞌa Lébãnõnĩ drị̂ gá cajó kpere ꞌbé Hãlákĩ gá, ꞌdĩ ãngũ tụlépi Sẽyírĩ gâlé ru rĩ kî. (Yósũwã fẽ dó ãngũ ꞌbá ꞌdĩ ꞌbadrị̂ sụ́rụ́ Ịsịrayị́lị̃ drị̂ ꞌbaní ãwítã ru ãngũ awalé ĩꞌbaní rĩ kí vú sĩ.) ");
INSERT INTO luc_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","Ãngũ ala gá ĩndĩ rĩ kí ãngũ ꞌbé ꞌa ru rĩ ꞌi, ãngũ ꞌbé pá gá ĩtụ́ ꞌbã ꞌde agâlé ru rĩ ꞌi, ãngũ Ãrábã drị̂ ꞌi, ãngũ ꞌbé drị́ ilũlépi ilú ilû rĩ ꞌi, ãngũ kõtórõ rú rĩ kí Nẹ̃gẹ́vụ̃ drị̂ be. ꞌDĩ kí ãngũ ꞌbá Hị́tị̃ rú, ꞌbá Ãmọ́rị̃ rú, ꞌbá Kãnánĩ rú, ꞌbá Pẹ̃rẹ́zị̃ rú, ꞌbá Hị́vị̃ rú ãzíla ꞌbá Yẹ̃bụ́sị̃ rú rĩ ꞌbadrị̂ kî. ");
INSERT INTO luc_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","Úpí Yẹ̃rị́kọ̃ drị̂ ãlu, úpí ãngũ Bẹ̃tẹ́lị̃ bụ́lụ́ gá Áyĩ drị̂ ãlu, ");
INSERT INTO luc_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","úpí Yẹ̃rụ́sãlẹ́mụ̃ drị̂ ãlu, úpí Hẹ̃bụ̃rọ́nị̃ drị̂ ãlu, ");
INSERT INTO luc_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","úpí Yãrị̃mụ́tị̃ drị̂ ãlu, úpí Lãkísĩ drị̂ ãlu; ");
INSERT INTO luc_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","úpí Ị̃gị̃lọ́nị̃ drị̂ ãlu, úpí Gẹ̃zẹ́rị̃ drị̂ ãlu, ");
INSERT INTO luc_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","úpí Dẹ̃bị́rị̃ drị̂ ãlu, úpí Gẹ̃dẹ́rị̃ drị̂ ãlu; ");
INSERT INTO luc_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","úpí Họ́rị̃mã drị̂ ãlu, úpí Ãrádị̃ drị̂ ãlu; ");
INSERT INTO luc_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","úpí Líbĩnã drị̂ ãlu, úpí Ãdũlámũ drị̂ ãlu; ");
INSERT INTO luc_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","úpí Mãkédã drị̂ ãlu, úpí Bẹ̃tẹ́lị̃ drị̂ ãlu; ");
INSERT INTO luc_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","úpí Tápũwã drị̂ ãlu, úpí Hẹ̃fẹ́rị̃ drị̂ ãlu, ");
INSERT INTO luc_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","úpí Ãfẹ́kị̃ drị̂ ãlu, úpí Lãsãrọ́nị̃ drị̂ ãlu; ");
INSERT INTO luc_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","úpí Mãdónĩ drị̂ ãlu, úpí Hãzọ́rị̃ drị̂ ãlu; ");
INSERT INTO luc_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","úpí Sị̃mị̃rọ́nị̃ Mẹ̃rọ́nị̃ drị̂ ãlu, úpí Ãkĩsáfũ drị̂ ãlu; ");
INSERT INTO luc_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","úpí Tãnákĩ drị̂ ãlu, úpí Mẹ̃gị́dọ̃ drị̂ ãlu; ");
INSERT INTO luc_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","úpí Kẹ̃dẹ́sị̃ drị̂ ãlu, úpí Yõkĩnẽyámũ Kãrị̃mẹ́lị̃ gá rĩ drị̂ ãlu; ");
INSERT INTO luc_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","úpí Dọ́rị̃ drị́ táwụ̃nị̃ Nãfãtọ́rị̃ Dọ́rị̃ gá ãlu, úpí Gọ̃yị́mụ̃ Gãlị́lị̃ gá rĩ drị̂ ãlu, ");
INSERT INTO luc_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","ãzíla úpí Tị̃rị́zã drị̂ ãlu. Ũpi ndẽlé rá rĩ kí pírí rĩ gá kãlị́na drị̃ ãlu. ");
INSERT INTO luc_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","Sáwã Yósũwã ꞌbã ándrá adrujó ĩdránígó ru ílí trũ ũꞌbí ru rĩ sĩ, Úpí jọ ĩꞌdiní, “Yósũwã íde dó ꞌbo ãzíla mi dó ílí trũ wẽwẽ ru, wó ãngũ ãmbógó lẽlé ꞌdụlé ꞌdụ̃ ꞌdụ̃ rĩ ace kí drĩ cí. ");
INSERT INTO luc_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","Ãngũ acelépi rĩ kí ꞌdĩ: Ãngũ ꞌbá Fị̃lị̃sị̃tị́nị̃ rú rĩ ꞌbadrị̂ ãngũ ꞌbá Gẹ̃sụ̃rụ́tị̃ rú rĩ ꞌbadrị̂ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","Angájó mĩrĩ Sị̃họ́nị̃ gá ꞌdĩ Mị̃sị́rị̃ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá kpere cajó táwụ̃nị̃ Ị̃kị̃rọ́nị̃ drị̂ ꞌbã wókõ ụ́rụ́ rĩ gá. Úlã ándrá Ị̃kị̃rọ́nị̃ ꞌi ãngũ Kãnánĩ ãni la rú; ũpi ãngũ Fị̃lị̃sị̃tị́nị̃ drị̂ rụlépi rĩ kí ándrá tõwú: úpí Gázã gá rĩ ꞌi, Ãsị̃dọ́dị̃ gá rĩ ꞌi, Ãsị̃kẹ̃lọ́nị̃ gá rĩ ꞌi, Gátũ gá rĩ ꞌi, Ị̃kị̃rọ́nị̃ gá rĩ ꞌi ãzíla Ávị̃ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","Angájó ãngũ ꞌbá Kãnánĩ rú rĩ ꞌbadrị̂ ꞌbã wókõ ándrá lé ru rĩ gá pírí ãzíla Mẹ̃yárã gá, ꞌdĩ ãngũ ꞌbá Sị̃dọ́nị̃ rú rĩ ꞌbadrị̂ gá kpere ãngũ Ãfẹ́kị̃ gá, cajó lõkókõrí ꞌbá Ãmọ́rị̃ rú rĩ ꞌbadrị̂ gá, ");
INSERT INTO luc_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","cajó ãngũ ꞌbá Gẹ̃bálị̃ rú rĩ ꞌbadrị̂ gá ãngũ Lébãnõnĩ drị̂ abe pírí, ãngũ Bãlĩ-gádĩ drị́ ꞌbé Hẹ̃rị̃mọ́nị̃ gá cajó Lẽbõ Hãmátĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","ꞌBá pírí uꞌálépi ãngũ ꞌbé drị̃ gá rĩ kí pírí angájó Lébãnõnĩ gá cajó Mĩsĩrẽfótĩ Mãyị́mị̃ gá ãzíla ꞌbá Sị̃dọ́nị̃ drị̂ kí abe pírí, ma mụ kí drolé ꞌbá Ịsịrayị́lị̃ drị̂ kí drị̃lẹ́ gá ꞌdãá rĩ sĩ rá. Mí awa lú ãngũ ꞌdĩ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ãwítã rú. ");
INSERT INTO luc_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","Mí awa ãngũ ꞌdĩ ãwítã rú ínátị úrômĩ rĩ ꞌbanî ínátị Mãnásẽ drị̂ ꞌbã nụ́sụ̃ abe.” ");
INSERT INTO luc_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","Ínátị Mãnásẽ drị̂ ꞌbã nụ́sụ̃ ãzí rĩ kí ínátị Rụ́bẹ̃nị̃ ꞌbadrị́ Gádĩ be rĩ trũ ãtíꞌbó Úpí drị́ Mụ́sã fẽ ándrá ĩꞌbaní ãngũ ãwítã rú rĩ mĩrĩ Yõrĩdánĩ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","Ãngũ ĩꞌbadrị̂ iꞌdó ru táwụ̃nị̃ Ãrówã tị gá, se ru kpere áꞌbụ Ãrị̃nọ́nị̃ drị̂ gá, umú ãngũ táwụ̃nị̃ áꞌbụ ꞌbã agá gá rĩ drị̂ kí ãngũ sẽ Mẽdébã drị̂ abe kpere Dị̃bọ́nị̃ gá. ");
INSERT INTO luc_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","Umú vâ táwụ̃nị̃ úpí Sị̃họ́nị̃ ꞌbá Ãmọ́rị̃ rú rĩ ꞌbadrị́ ũpĩ nalépi Hẹ́sị̃bọ̃nị̃ gá cajó kpere lõkókõrí Ãmọ́nị̃ drị̂ gá ri kí ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","Umú vâ táwụ̃nị̃ Gị̃lẹ́dị̃ drị̂ kí ãngũ ꞌbá Gẹ̃sụ̃rụ́tị̃ rú rĩ ꞌbadrị̂ abe, ꞌbá Mãkátĩ rú rĩ ꞌbadrị̂, ꞌbé Hẹ̃rị̃mọ́nị̃ drị̂ pírí, ãngũ Bãsánĩ drị̂ pírí cajó kpere Sãlékã gá. ");
INSERT INTO luc_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","Umú vâ ãngũ úpí Ụ́gị̃ Bãsánĩ gá rĩ drị́ ándrá ũpĩ nalépi Ãsị̃tãrọ́tị̃ gá ãzíla Ị̃drẹ́yị̃ gá rĩ kí pírí ĩndĩ. Úpí Úgĩ ĩꞌdi ándrá lú ꞌbá Rẹ̃fãyị́mụ̃ drị̂ kí agá acelépi Mụ́sã ꞌbã ándrá sĩ ãꞌdị́ ꞌdịjó ĩꞌba abe ĩꞌdi ꞌbã sĩ kí drojó rá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","Wó ꞌbá Ịsịrayị́lị̃ drị̂ dro kí ándrá ꞌbá Gẹ̃sụ́rị̃ drị̂ kí ꞌbá Mãkátĩ drị̂ abe gẹ̃rị̃ sĩ ku, ị́jọ́ ꞌdĩ ꞌbã sĩ fẽlépi la kí sĩ adru jó kpere ãndrũ ꞌbá Ịsịrayị́lị̃ drị̂ kí drĩdríŋĩ gá cí ꞌdĩ. ");
INSERT INTO luc_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","Mụ́sã fẽ ándrá ꞌbá Lẹ́vị̃ drị̂ ꞌbaní ãngũ ãwítã rú la gẹ̃rị̃ sĩ ku, ãko fẽlé ĩꞌbaní ãwítã rú rĩ kí ãko ivélé ivé ivê ídétáŋá ru ãcí sĩ ãlĩtárĩ drị̃ gá Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ ní rĩ ꞌbã wókõ. ");
INSERT INTO luc_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","ꞌDĩ kí ãngũ Mụ́sã ꞌbã ándrá fẽlé sụ́rụ́ Rụ́bẹ̃nị̃ drị̂ ní ãwítã rú ꞌbá ĩꞌbadrị́ ínátị kí agá rĩ kí vú sĩ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","Ãngũ ĩꞌbadrị̂ iꞌdó ru táwụ̃nị̃ Ãrówã gá cajó kpere áꞌbụ Ãrị̃nọ́nị̃ drị̂ ꞌbã tị gá, umú táwụ̃nị̃ áꞌbụ ꞌbã ágágá rĩ cajó kpere ãngũ pírí túpũ rú Mẽdébã ꞌbã andre gá rĩ trũ. ");
INSERT INTO luc_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","Umú táwụ̃nị̃ Hẹ́sị̃bọ̃nị̃ drị̂ ꞌi, táwụ̃nị̃ pírí túpũ drị̃ gá rĩ kí, táwụ̃nị̃ Dị̃bọ́nị̃ drị̂ ꞌi, Bãmọ́tị̃ Bálĩ ꞌi ãzíla Bẹ̃tị̃ Bálĩ Mẽyónĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","Yãházị̃ ꞌi, Kẽdẽmọ́tị̃ ꞌi, Mẽfátĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","Kĩrĩyãtãyị́mụ̃ ꞌi, Sĩbũmá ꞌi ãzíla Zẹ̃rẹ́tị̃ Sáhã adrulépi túpũ áꞌbụ agá rĩ ꞌbã drị̃ gá rĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","Bẹ̃tị̃ Pẹ̃yọ́rị̃ ꞌi, ãngũ Pị́sị̃gã drị́ ilúlépi rĩ ꞌi ãzíla Bẹ̃tị̃ Yẹ̃sị̃mọ́tị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","Umú táwụ̃nị̃ túpũ drị̃ gá ri kí pírí ãngũ úpí Ãmọ́rị̃ drị́ Sị̃họ́nị̃ ándrá vâ adrulépi úpí ru Hẹ́sị̃bọ̃nị̃ gá rĩ drị̂ kí abe. Mụ́sã ndẽ ándrá kí ãmbogo Mị̃dị́yánị̃ drị́ Ị́vị̃, Rẹ̃kẹ́mụ̃, Zụ́rị̃, Hụ́rị̃ ãzíla Rébã úpí Sị̃họ́nị̃ drị̂ ꞌbã ngọ́pị trũ rá, ri kí ándrá pírí uꞌálé ãngũ ꞌdã gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","ꞌBá Ịsịrayị́lị̃ drị̂ ꞌdị kí ándrá vâ Bãlámũ Bẹ̃yọ́rị̃ ꞌbã ngọ́pị ándrá ũjõgõ ãzị́ ngalépi sĩ ị́jọ́ mụlépi ru idélépi drị̃lẹ́ gâlé rĩ kí ũlũlépi rĩ ꞌbá ụꞌdị́lé rĩ kí agá ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","Ãngũ ínátị ꞌbá Rụ́bẹ̃nị̃ drị̂ ꞌbã lõkókõrí ị̃tụ́ ꞌbã ꞌde agâlé ru rĩ ãsị̃ mĩrĩ Yõrĩdánĩ sĩ. ꞌDĩ kí táwụ̃nị̃ ãzíla tọ̃rọ́mẹ́ fẽlé sụ́rụ́ Rụ́bẹ̃nị̃ drị̂ ꞌbaní ãwítã rú ínátị ĩꞌbadrị̂ kí vú sĩ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","Mụ́sã fẽ sụ́rụ́ Gádĩ drị̂ ꞌbaní ãgũ ꞌdĩ kí ínátị ĩꞌbadrị̂ ꞌbaní anzị ĩꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","Ãngũ ĩꞌbadrị̂ iꞌdó ru Yãzẹ́rị̃ gá, táwụ̃nị̃ Gị̃lẹ́dị̃ drị̂ kí pírí, ãngũ ꞌbá Ãmọ́nị̃ rú rĩ ꞌbadrị̂ ꞌbã nụ́sụ̃ gá, cajó kpere táwụ̃nị̃ Ãrówã drị̂ gá ꞌdĩ Rábã ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","Ãngũ ꞌdĩ ĩjũ ru angájó Hẹ́sị̃bọ̃nị̃ gá cajó kpere Rãmátĩ Mị̃zị́pẹ̃ gá ãzíla Bẹ̃tọ̃nị́mụ̃ gá angájó Mãhãnãyị́mụ̃ gá rĩ sĩ cajó kpere ãngũ Dẹ̃bị́rị̃ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","Áꞌbụ ꞌa Yõrĩdánĩ drị̂ gá sụ́rụ́ Gádĩ drị̂ ịsụ́ ãngũ Bẹ̃tị̃ Hãrámũ drị̂ ꞌi, Bẹ̃tị̃ Nímĩrã drị̂ ꞌi, Sụ̃kọ́tị̃ drị̂ ꞌi ãzíla Zãfọ́nị̃ drị̂ ꞌi ãngũ úpí Hẹ́sị̃bọ̃nị̃ drị́ Sị̃họ́nị̃ ꞌbã rụlé rĩ ꞌbã ị́mbị́lị́kọ́ abe. Lõkókõrí ĩꞌbadrị́ ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ ĩꞌdi mĩrĩ Yõrĩdánĩ ꞌbã tị gâsĩ kpere mĩrĩ ãmbógó Gãlị́lị̃ drị̂ gá ụ́rụ́lé ãzíla ꞌdã ꞌbã ũngúkú gá ja dó ru ị̃tụ̂ ꞌbã ãfũ agâlé ru. ");
INSERT INTO luc_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","ꞌDĩ kí táwụ̃nị̃ ãzíla tọ̃rọ́mẹ́ fẽlé sụ́rụ́ Gádĩ drị̂ ꞌbaní ãwítã rú ínátị ĩꞌbadrị̂ kí vú sĩ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","Mụ́sã fẽ ándrá sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ ꞌbaní ãngũ ꞌdĩ kí ãwítã rú ínátị ĩꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","Ãngũ ĩꞌba drị̂ iꞌdó ru Mãhãnãyị́mụ̃ gá, ꞌdụ ãngũ Bãsánĩ drị̂ pírí, sụ́rụ́ ándrá úpí Ụ́gị̃ ꞌbã sĩ ũpĩ najó rĩ kí pírí, ãzíla táwụ̃nị̃ kãlị́ ázíyá Jãyírĩ gá rĩ kí Bãsánĩ gá rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","Umú vâ Gị̃lẹ́dị̃ ꞌbã nụ́sụ̃ ãzíla táwụ̃nị̃ úpí Ụ́gị̃ ꞌbã sĩ uꞌájó ala gá Ãsị̃tãrọ́tị̃ kí Ị̃drẹ́yị̃ be ĩndĩ. Úfẽ ãngũ ꞌdĩ pírí ꞌbá Mãkírĩ drị́ ándrá adrulépi Mãnásẽ ngọ́pị rú rĩ ꞌbadrị̂ ꞌbaní ínátị ĩꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","ꞌDĩ ãwítã Mụ́sã ꞌbã ándrá fẽlé sáwã ĩꞌdiní adrujó ãngũ ꞌbé ꞌa rú Mụ̃wábụ̃ drị̂ gá Yõrĩdánĩ ꞌbã ꞌá ꞌdõ sĩ wókõ Yẹ̃rị́kọ̃ drị́ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","Wó sụ́rụ́ Lẹ́vị̃ drị̂ ní Mụ́sã fẽ ãngũ ãzị́ ĩꞌbaní ãwítã rú la ku, kí ãko ĩꞌbadrị̂ kí ịsụ́ Úpí Ãdróŋá Ịsịrayị́lị̃ drị́ rĩ drị́ cécé ĩꞌdi ꞌbã ándrá azịlé ĩꞌbaní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","ꞌDĩ kí ãngũ Ị̃lị̃yãzárị̃ átáló ru rĩ ꞌbã kí fẽlé Yósũwã Nụ́nị̃ ngọ́pị be ãzíla drị̃lẹ́ka ínátị sụ́rụ́ Ịsịrayị́lị̃ drị̂ kí abe ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ãwítã rú ãngũ Kãnánĩ drị̂ agá rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","Sụ́rụ́ úrômĩ nụ́sụ̃ rĩ ịsụ́ kí ãngũ fẽlé ĩꞌbaní ãwítã rú rĩ jẽgê ꞌbeŋá sĩ cécé Úpí ꞌbã ándrá ãzị́táŋá la fẽjó Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","Mụ́sã fẽ ándrá sụ́rụ́ ị̃rị̃ nụ́sụ̃ rĩ ꞌbaní ãngũ ãwítã rú rĩ Mĩrĩ Yõrĩdánĩ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru, wó fẽ ándrá ãngũ ꞌbá Lẹ́vị̃ drị̂ ꞌbaní gẹ̃rị̃ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","Anzị Yụ̃sụ́fụ̃ ꞌbã drị̃lẹ́ka ru rĩ acá kí sụ́rụ́ ị̃rị̃ rú, Mãnásẽ kí Ịfụrayị́mụ̃ be, úfẽ ándrá ãngũ ꞌbá Lẹ́vị̃ drị̂ ꞌbaní gẹ̃rị̃ sĩ ku, úfẽ lú ĩꞌbaní rá la táwụ̃nị̃ sĩ uꞌájó rĩ kí ãngũ ĩrí trũ sĩ tị́ kí ucéjó kãbĩlõ kí abe rĩ áyụ. ");
INSERT INTO luc_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","Ị́jọ́ ꞌdĩ sĩ ꞌbá Ịsịrayị́lị̃ drị̂ awa kí dó sĩ ãngũ ꞌdã kí drĩdríŋĩ gá cécé Úpí ꞌbã ãzị́táŋá la fẽjó Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","Ụ́ꞌdụ́ ãlu ãgọbị sụ́rụ́ Yụ́dã drị̂ agá rĩ ámụ kí Yósũwã ꞌbã drị̃légá Gị̃lị̃gálị̃ gá ꞌdãá, ĩꞌbã ãzí ãlu Kãlẹ́bụ̃ Yẹ̃fụ́nẹ̃ Kẹ̃nị́zị̃ rú rĩ ꞌbã ngọ́pị jọ Yósũwã ní, “Ínị̃ ị́jọ́ Úpí ꞌbã ándrá jọlé Mụ́sã ãtíꞌbó Ãdróŋá drị̂ ní Kãdẹ́sị̃-bãrĩnéyã gá ꞌdãá ãma drị̃ gá mí be rĩ rá. ");
INSERT INTO luc_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","Sáwã ãtíꞌbó Úpí drị́ Mụ́sã ꞌbã ándrá áma tị pẽjó ãngũ undré jó ũní-ũní ru rĩ sĩ áma ílí dó ꞌdĩ sĩ kãlị́ sụ. Má ají ándrá Mụ́sã ní ị́jọ́ mgbã mání undrélé rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","Wó mâ ádrị́pịka mụlépi má be rĩ fẽ kí ꞌbá kí ásị́ ní umvúlé ụ̃rị̃ sĩ trẹ̃yị́, wó ábĩ Úpí Ãdróŋá mádrị̂ ꞌbã vú áma ásị́ pírí sĩ. ");
INSERT INTO luc_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Ị́jọ́ ꞌdĩ sĩ, Mụ́sã na ándrá dó sĩ ũyõ ụ́ꞌdụ́ ꞌdã sĩ ãzíla jọ mání, ‘Ãngũ míní sĩ ími pá ꞌbãjó drị̃ la gá rá rĩ la dó acá míní ãwítã rú anzị míní mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe jãꞌdâ ãꞌdusĩku mí ũbĩ Úpí Ãdróŋá mádrị̂ ꞌbã vú ásị́ pírí sĩ rá.’ ");
INSERT INTO luc_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","“Wó úꞌdîꞌda, cécé Úpí ꞌbã ándrá azịlé Mụ́sã ní sáwã Ịsịrayị́lị̃ ꞌbã wãyá cojó kõtórõ agá ꞌdãá rĩ sĩ rĩ áni, mba dó áma tã ídri rú ílí kãlị́ sụ drị̃ tõwú ꞌbo sáwã ĩꞌdi ꞌbã ị́jọ́ ꞌdã jọjó rĩ sĩ, ma dó úꞌdîꞌda íni ílí trũ kãlị́ ãrõ drị̃ tõwú. ");
INSERT INTO luc_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","Ma drĩ ũkpó ru cécé ándrá Mụ́sã ꞌbã áma tị pẽjó ꞌdã bã áni: úꞌdîꞌda áma ũkpó drĩ vâ cí sĩ ãꞌdị́ ꞌdị jó vâ sĩ ãzị́ cí rĩ ngajó údu rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Úꞌdîꞌda ị́jọ́ ꞌdĩ sĩ ífẽ dó mání ãngũ ꞌbé ꞌa rú ꞌdĩ ꞌi ándrá Úpí ꞌbã azịlé ụ́ꞌdụ́ ꞌdã sĩ rĩ áni. Ími vúŋá are rá ꞌbá Ãnákĩ drị̂ kí ándrá ꞌdãá cí ãzíla táwụ̃nị̃ ĩꞌbadrị̂ kí ándrá ãmbógó ru úsị Bõrõ la kí ũkpó ru cí, wó Úpí drĩ áma ãzã ko rá, ma kí dro rá cécé ándrá ĩꞌdi ꞌbã jọlé rĩ áni.” ");
INSERT INTO luc_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","ꞌDã ꞌbã ũngúkú gá, Yósũwã wi dó Kãlẹ́bụ̃ Yẹ̃fụ́nẹ̃ ngọ́pị ní sụ̃sụ́ ãzíla fẽ dó ãngũ Hẹ̃bụ̃rọ́nị̃ drị̂ ĩꞌdiní ãwítã rú. ");
INSERT INTO luc_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Ị́jọ́ ꞌdĩ sĩ Hẹ̃bụ̃rọ́nị̃ acá dó sĩ ãngũ Kãlẹ́bụ̃ Yẹ̃fụ́nẹ̃ ngọ́pị ãni la rú ụ́ꞌdụ́ ꞌdã sĩ, ãꞌdusĩku ũbĩ Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ ꞌbã vú ásị́ pírí sĩ rá. ");
INSERT INTO luc_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","Drị̃drị̃ rĩ sĩ ála ándrá Hẹ̃bụ̃rọ́nị̃ umve Kị̃rị̃yátị̃ Ãrị́bã ꞌi. (Ãrị́bã ĩꞌdi ándrá ꞌbá ãmbógó ãndânĩ ꞌbá Ãnákĩ drị̂ kí drĩdríŋĩ gá rĩ ꞌi), úꞌda dó sĩ ãngũ ꞌdã ꞌbã rụ́ ĩꞌdi ꞌbã rụ́ sĩ. ꞌDã ꞌbã ũngúkú gá, ꞌbá Ịsịrayị́lị̃ drị̂ avị́ kí dó drĩ vâ ãꞌdị́ sĩ rá. ");
INSERT INTO luc_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","Ãngũ fẽlé sụ́rụ́ Yụ́dã drị̂ ní, íná tị sĩ, íná tị sĩ rĩ ĩjũ ru Ídõmũ gá ándrá cajó kpere kõtórõ Zínĩ drị̂ ꞌbã tị ándrá ãsị̃jó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","Lõkókõrí ĩꞌbadrị́ ándrá rĩ iꞌdó ru mĩrĩ ãꞌị́ ru rĩ ꞌbã tị ꞌbã ãsị̃ agá angájó tị la ãngũ ndrelépi ándrá rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","Angájó ándrá Ãkị̃rãbị́nị̃ gá rĩ sĩ, alị dó Zínĩ gâsĩ mụjó ándrá Kãdẹ́sị̃ Bãrĩnéyã gá, ꞌdãá rĩ sĩ alị dó Hẹ̃zị̃rọ́nị̃ gâsĩ cajó kpere Ãdárĩ gá, mụ dó sĩ Kãríkã gá. ");
INSERT INTO luc_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","ꞌDãá rĩ sĩ alị kpere Ãzị̃mọ́nị̃ gá wọ́rọ̃ŋá Mị̃sị́rị̃ drị̂ gâsĩ, mụ dó sĩ ãsị̃lé mĩrĩ Mẽdĩtẽránĩyãnĩ gá. ꞌDĩ dó sĩ lõkókõrí ĩꞌbadrị́ ándrá rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","Lõkókõrí ĩꞌbadrị́ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ ãsị̃ mĩrĩ ãꞌị́ ru rĩ sĩ kpere mĩrĩ Yõrĩdánĩ ꞌbã tị gá. Lõkókõrí ụ́rụ́ rĩ iꞌdó dó sĩ ꞌdãá, ");
INSERT INTO luc_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","mụ dó sĩ kpere Bẹ̃tị̃ Họ́gị̃lã gá alị dó sĩ Bẹ̃tị̃ Ãrábã ꞌbã wókõ ụ́rụ́ rĩ gâsĩ. ꞌDãá rĩ sĩ mụ dó kpere írã Bõhánĩ Rụ́bẹ̃nị̃ ꞌbã ngọ́pị drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","Lõkókõrí ꞌdĩ mụ kpere Dẹ̃bị́rị̃ gá angájó áꞌbụ ꞌa Ãkórĩ drị̂ gá, uja dó ꞌdãá rĩ sĩ mụlé Gị̃lị̃gálị̃ gâlé ru, ndre kí ru ndre-ndrẽ ãngũ Ãdũmímũ drị́ tụlépi tụ̃-tụ̃ rĩ ꞌbã wókõ ándrá rĩ be. ꞌDãá rĩ sĩ alị kpere ị̃yị́ Ị̃nị̃ Sẹ̃mẹ́sị̃ drị̂ gá ãzíla ãsị̃ dó sĩ Ẽnĩ Rõgélĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","ꞌDã ꞌbã ũngúkú gá, lõkókõrî mụ áꞌbụ ꞌa Bẹ́nị̃ Hị̃nọ́mụ̃ drị̂ gâsĩ ãni rú ãngũ ilúlépi ándrá táwụ̃nị̃ Yẹ̃bụ́sị̃ drị́ ãngũ táwụ̃nị̃ Yẹ̃rụ́sãlẹ́mụ̃ drị̂ ꞌbã sĩ adrujó rĩ gá. ꞌDãá rĩ sĩ tụ dó ꞌbé drị̃ gá ụrụgá áꞌbụ ꞌa Hị̃nọ́mụ̃ drị̂ gâsĩ wókõ ụ́rụ́ ị̃tụ̂ ꞌbã ꞌde agâlé ru áꞌbụ ꞌa Rẹ̃fãyị́mụ̃ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","ꞌBé drị̃ gá ꞌdãá rĩ sĩ lõkókõrî uja dó drị̃ mụjó kídí Nẽfũtówã drị̂ gâsĩ, angájó ꞌdãá rĩ sĩ mụ táwụ̃nị̃ ꞌbé Ĩfũrónĩ drị̂ kí agâsĩ, ꞌdãá rĩ gá mụ dó sĩ vụ̃rụ́ Bãálã gá, ꞌdĩ Kĩrĩyátĩ Yẹ̃yãrị́mụ̃ gá. ");
INSERT INTO luc_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","ꞌDã ꞌbã ũngúkú gá, lõkókõrî angájó Bãálã gá rĩ sĩ agọ́ dó ru ị̃tụ̂ ꞌbã ꞌde agâlé ru sĩ tụjó ꞌbé Sẹ̃yị́rị̃ gá, alị táwụ̃nị̃ Kẹ̃sãlọ́nị̃ drị̂ gâsĩ, sĩ mụjó ꞌbé Yẹ̃yãrị́mụ̃ (úꞌdîꞌda umvelé Kẹ̃sãlọ́nị̃ ꞌi rĩ) drị̂ ꞌbã wókõ ụ́rụ́ rĩ gâsĩ, ali gbõgbõ Bẹ̃tị̃ Sẹ̃mẹ́sị̃ gá vụ̃rụ̂ lé ãzíla za dó sĩ Tímũnã gá. ");
INSERT INTO luc_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","Lõkókõrî mụ dó túpũ táwụ̃nị̃ Ị̃kị̃rọ́nị̃ drị̂ ꞌbã wókõ ụ́rụ́ rĩ gâsĩ, uja dó tị sĩ mụjó Sị̃kẹ̃rọ́nị̃ gá, alị dó sĩ ꞌbé Bãálã gâsĩ ãzíla mụ Yãbụ̃nẹ́lị̃ gâsĩ ãzíla ãsĩ dó sĩ mĩrĩ Mẽdĩtẽránĩyãnĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","Lõkókõrí ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ mụ mĩrĩ Mẽdĩtẽránĩyãnĩ ꞌbã tị gâsĩ. ꞌDĩ kí lõkókõrí ꞌbá Yụ́dã drị̂ kí andre gá rĩ kí ínátị ĩꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","Úpí fẽ ãzị́táŋá Yósũwã ní sĩ ãngũ Yụ́dã drị̂ ꞌbã ĩsélé fẽjó Kãlẹ́bụ̃ Yẹ̃fụ́nẹ̃ ngọ́pị ní. Ị́jọ́ ꞌdĩ sĩ úfẽ Kãlẹ́bụ̃ ní Kị̃rị̃yátị̃ Ãrị́bã ꞌi, ꞌdĩ Hẹ̃bụ̃rọ́nị̃ gá. Ãrị́bã ꞌdĩ úꞌda ĩꞌdi áyị́pị ꞌbá Ãnákĩ drị̂ kí ꞌba rụ́ sĩ. ");
INSERT INTO luc_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","Hẹ̃bụ̃rọ́nị̃ gá ꞌdãá rĩ sĩ Kãlẹ́bụ̃ dro dó ꞌbá ínátị Ãnákĩ drị́ na Sẽsáyĩ, Ãhĩmánĩ, ãzíla Tãlĩmáyĩ ꞌdĩ kí rá. ");
INSERT INTO luc_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","Angájó ꞌdãá rĩ sĩ mụ dó sĩ ãꞌdị́ ꞌdịlé ꞌbá uꞌálépi Dẹ̃bị́rị̃ gá ándrá jõ umvelé Kị̃rị̃yátị̃ Sẹ̃fẹ́rị̃ rĩ abe. ");
INSERT INTO luc_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","Kãlẹ́bụ̃ jọ, “Ma mâ ị̃zẹ́pị Ãkísã fẽ ꞌbá Kị̃rị̃yátị̃ Sẹ̃fẹ́rị̃ ndẽlépi rá rĩ ní ũkú ru.” ");
INSERT INTO luc_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","Kãlẹ́bụ̃ ádrị́pị Kénãzĩ ngọ́pị Ụ̃tị̃nị̃yẹ́lị̃ ndẽ dó ꞌbá táwụ̃nị̃ ꞌdã agá rĩ kí rá, ị́jọ́ ꞌdĩ sĩ Kãlẹ́bụ̃ fẽ dó ị̃zẹ́pị Ãkísã Ụ̃tị̃nị̃yẹ́lị̃ ní ũkú ru. ");
INSERT INTO luc_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","Ụ́ꞌdụ́ Kãlẹ́bụ̃ ꞌbã ị̃zẹ́pị Ãkísã ĩgbãjó Ụ̃tị̃nị̃yẹ́lị̃ ní ũkú ru rĩ sĩ Ãkísã aꞌị́ Ụ̃tị̃nị̃yẹ́lị̃ ꞌi sĩ átẹ́pị̃ zịjó ꞌbã fẽ sĩ íní ámvụ́. Ãkísã la mụ asị́lé kãyĩnõ drị̃ gâlé vũ rú ꞌdõlé ꞌbo, Kãlẹ́bụ̃ zị ĩꞌdi, “Ílẽ má idé dó míní ãꞌdụ?” ");
INSERT INTO luc_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","Ãkísã umvi ĩꞌdiní, “Íwi mání sụ̃sụ́ mídrị̂, míní mání ãngũ fẽjó Nẹ̃gẹ́vụ̃ gá rá rĩ áni, ífẽ vâ mání kídí kí fẽtáŋá ru sĩ icéjó la íwi mání sụ̃sụ́ rá.” Ị́jọ́ ꞌdĩ sĩ Kãlẹ́bụ̃ fẽ dó sĩ kídí ụ́rụ́ rĩ kí ándrá rĩ abe ĩꞌdinî. ");
INSERT INTO luc_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","ꞌDĩ kí ãngũ fẽlé ãwítã rú ꞌbá sụ́rụ́ Yụ́dã drị̂ gá rĩ ꞌbaní ínátị vú sĩ, ínátị vú sĩ rĩ kî: ");
INSERT INTO luc_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","Táwụ̃nị̃ ꞌbá sụ́rụ́ Yụ́dã drị́ ãsị̃ŋá gá ándrâlé ru lõkókõrí Ídõmũ drị̂ be rĩ kí: Kãbị̃zẹ́lị̃ ꞌi, Ị̃dẹ́rị̃ ꞌi, Yãgụ́rị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","Kínã ꞌi, Dị̃mọ́nã ꞌi, Ãdádã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","Kẹ̃dẹ́sị̃ ꞌi, Hãzọ́rị̃ ꞌi, Ị̃tị̃nánị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","Zị́fụ̃ ꞌi, Tẹ̃lẹ́mụ̃ ꞌi, Bẹ̃yãlọ́tị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","Hãzọ́rị̃ Hãdátã ꞌi, Kẹ̃rị̃yọ́tị̃ Hẹ̃zị̃rọ́nị̃ (ꞌdĩ táwụ̃nị̃ Hãzọ́rị̃ ꞌi). ");
INSERT INTO luc_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","Ãmámũ ꞌi, Sẹ́mã ꞌi, Mõládã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","Hãzárĩ-gádã ꞌi, Hẹ̃sị̃mọ́nị̃ ꞌi, Bẹ̃tị̃ Pẹ̃lẹ́tị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","Hãzárị̃ Sụ̃wálị̃ ꞌi, Bẹ̃rị̃sẹ́bã ꞌi, Bị̃zị̃yọ̃tị́yã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","Bãálã ꞌi, Ị̃yị́mụ̃ ꞌi, Ị̃zẹ́mụ̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","Ị̃lị̃tọ̃ládị̃ ꞌi, Kẹ̃sị́lị̃ ꞌi, Họ̃rị́mã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","Zĩkĩlágĩ ꞌi, Mãdĩmánã ꞌi, Sãnĩsánã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","Lẹ̃bãwọ́tị̃ ꞌi, Sị̃lị́mị̃ ꞌi, Ãyị́nị̃ ꞌi, Rị̃mọ́nị̃ abe, Táwụ̃nị̃ ãmbogo ãmbogo kãlị́ ị̃rị̃ drị̃ úrômĩ ãzíla tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","Táwụ̃nị̃ ãngũ vụ̃rụ́lé rĩ agá rĩ kí: Ị̃sị̃tãyọ́lị̃ ꞌi, Zórã ꞌi, Ãsínã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","Zãnówã ꞌi, Ĩnị̃ Gãnímũ ꞌi, Tãpúwã ꞌi, Ị̃námụ̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","Yãrị̃mụ́tị̃ ꞌi, Ãdũlámũ ꞌi, Sọ́kọ̃ ꞌi, Ãzékã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","Sãrãyị́mụ̃ ꞌi, Ãdị̃tãyị́mụ̃ ꞌi, Gẹ̃dẹ́rã ꞌi, Gẹ̃dẹ̃rọ̃tãyị́mụ̃ ꞌi, táwụ̃nị̃ mụdrị́ drị̃ sụ tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","Zẽnánĩ ꞌi, Hãdásã ꞌi, Mĩgĩdálĩ Gádĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","Dị̃lánị̃ ꞌi, Mị̃zị́pẹ̃ ꞌi, Yọ̃kị̃tẹ́lị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","Lãkísĩ ꞌi, Bọ̃zị̃kátị̃ ꞌi, Ị̃gị̃lọ́nị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","Kãbọ́nị̃ ꞌi, Lãhị̃mámụ̃ ꞌi, Kị̃tị̃lị́sị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","Gẹ̃dẹ̃rọ́tị̃ ꞌi, Bẹ̃tị̃ Dãgọ́nị̃ ꞌi, Nãámã ꞌi, Mãkédã ꞌi, táwụ̃nị̃ mụdrị́ drị̃ ázíyá ãzíla tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","Táwụ̃nị̃ ãzí ala gá rĩ kí, Líbĩnã ꞌi, Ị́tẹ́rị̃ ꞌi, Ãsánị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","Ĩfútã ꞌi, Ãsánã ꞌi, Nẹ̃zị́bụ̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","Kẹ̃yị́la ꞌi, Ãkị̃zị́bụ̃ ꞌi, Mãrẹ́sã ꞌi, táwụ̃nị̃ úrômĩ tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","Táwụ̃nị̃ Ị̃kị̃rọ́nị̃ drị̂ kí tọ̃rọ́mẹ́ la kí abe, ");
INSERT INTO luc_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","angájó Ị̃kị̃rọ́nị̃ gá cajó kpere mĩrĩ Mẽdĩtẽránĩyãnĩ gá, Lõkókõrî ĩjũ dó ru ị̃tụ̂ ꞌbã ꞌde agâlé ru táwụ̃nị̃ Ãsị̃dọ́dị̃ drị̂ ꞌbã andre gâsĩ tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","Ãsị̃dọ́dị̃ ꞌi, táwụ̃nị̃ ĩꞌdidrị̂ kí tọ̃rọ́mẹ́ la kí abe ãzíla Gázã ꞌi táwụ̃nị̃ la kí tọ̃rọ́mẹ́ la kí abe cajó kpere Ị̃yị́ dịlépi dị̃-dị̃ Mị̃sị́rị̃ drị̂ gá ãzíla ị̃yị́ tị Mẽdĩtẽránĩyãnĩ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","Ãngũ ꞌbé agá rĩ gá: Sãmị́rị̃ ꞌi, Yátĩrĩ ꞌi, Sọ́kọ̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","Dánã ꞌi, Kị̃rị̃yátị̃ Sánã ꞌi (ꞌdĩ táwụ̃nị̃ Dẹ̃bị́rị̃ drị̂ ꞌi), ");
INSERT INTO luc_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","Ãnábũ ꞌi, Ị̃sị̃tẹ́mọ̃ ꞌi, Ãnị́mụ̃ ꞌi ");
INSERT INTO luc_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","Gõsénĩ ꞌi, Họ̃lọ́nị̃ ꞌi ãzíla Gị́lọ̃ ꞌi, táwụ̃nị̃ mụdrị́ drị̃ ãlu tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","Ãrábũ ꞌi, Dụ́mã ꞌi, Ị̃sánị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","Yãnị́mụ̃ ꞌi, Bẹ̃tị̃ Tãpúwã ꞌi, Ãfékã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","Hụ̃mụ̃tã ꞌi, Kị̃rị̃yátị̃ Ãrị́bã ꞌi (ꞌdĩ Hẹ̃bụ̃rọ́nị̃ ꞌi) ãzíla Zị̃yọ́rị̃ ꞌi. Táwụ̃nị̃ úrômĩ tọ̃rọ́mẹ́ la kí abe: ");
INSERT INTO luc_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","Mãwọ́nị̃ ꞌi, Kãrị̃mẹ́lị̃ ꞌi, Zị́fụ̃ ꞌi, Yụ́tã ꞌi ");
INSERT INTO luc_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","Yẹ̃zẹ̃rẹ́lị̃ ꞌi, Yõkĩdẽyámụ̃ ꞌi, Zãnówã ꞌi ");
INSERT INTO luc_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","Kãyị́nị̃ ꞌi, Gị̃bẹ́yã ꞌi, ãzíla Tímũnã ꞌi. Táwụ̃nị̃ mụdrị́ ãzíla tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","Hãlị̃hụ́lị̃ ꞌi, Bẹ̃tị̃ Zụ́rị̃ ꞌi, Gẹ̃dọ́rị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","Mãrátĩ ꞌi, Bẹ̃tị̃ Ãnọ́tị̃ ꞌi, ãzíla Ị̃lị̃tẹ̃kọ́nị̃ ꞌi. Táwụ̃nị̃ ázíyá tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","Kị̃rị̃yátị̃ Bãálĩ ꞌi, (ꞌdĩ Kĩrĩyátĩ Yẹ̃yãrị́mụ̃ ꞌi) ãzíla Rábã ꞌi, táwụ̃nị̃ ị̃rị̃ tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","Táwụ̃nị̃ ãngũ kõtórõ rú rĩ agá rĩ kí: Bẹ̃tị̃ Ãrábã ꞌi, Mị̃dị́nị̃ ꞌi, Sẹ̃kákã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","Nị̃bụ̃sánị̃ ꞌi, táwụ̃nị̃ mĩrĩ ãꞌị́ ru rĩ drị̂ ꞌi ãzíla Ị̃nị̃ Gẹ́dị̃ ꞌi. Táwụ̃nị̃ ázíyá tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","Wó sụ́rụ́ Yụ́dã drị̂ dro kí ándrá ꞌbá Yẹ̃bụ́sị̃ drị́ uꞌálépi táwụ̃nị̃ Yẹ̃rụ́sãlẹ́mụ̃ drị̂ gá rĩ kí ku, ị́jọ́ ꞌdĩ sĩ ꞌbá Yẹ̃bụ́sị̃ drị̂ kí drĩ uꞌá kpere ãndrũ ꞌbá Yụ́dã drị̂ kí abe Yẹ̃rụ́sãlẹ́mụ̃ gá. ");
INSERT INTO luc_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","Ãngũ fẽlé anzị Yụ̃sụ́fụ̃ drị̂ ꞌbaní ãwítã rú rĩ iꞌdó ru mĩrĩ Yõrĩdánĩ gá ãnirú Yẹ̃rị́kọ̃ gá. ꞌDĩ wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru kídí Yẹ̃rị́kọ̃ drị̂ kí tị gá, alị dó ꞌdãá rĩ sĩ tụjó ụ́rụ́ kõtórõ agâsĩ, sĩ fijó ãngũ ꞌbé ꞌa rú Bẹ̃tẹ́lị̃ drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","Angájó Bẹ̃tẹ́lị̃ (ꞌdĩ Lụ́zị̃ ꞌi) gá rĩ sĩ alị mụjó ꞌbá Ãrị́kị̃ drị̂ ꞌbadrị́ ãngũ gâsĩ mụjó Ãtãrọ́tị̃ gá. ");
INSERT INTO luc_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","Ilú ị̃tụ̂ ꞌbã ꞌde agâlé ru ãngũ ꞌbá Yãfị̃lẹ́tị̃ ꞌbadrị̂ gâsĩ kpere ándrá Bẹ̃tị̃ Họ̃rọ́nị̃ gá, ꞌdã bã ũngúkú gá alị dó Gẹ̃zárị̃ gâsĩ, mụ dó sĩ ãsị̃lé mĩrĩ Mẽdĩtẽránĩyãnĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","Ị́jọ́ ꞌdĩ sĩ anzị Yụ̃sụ́fụ̃ drị́ Mãnásẽ kí Ịfụrayị́mụ̃ be ịsụ́ kí dó sĩ ãngũ ĩꞌbadrị́ ãwítã rú rĩ. ");
INSERT INTO luc_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","ꞌDĩ ãngũ ándrá fẽlé ꞌbá Ịfụrayị́mụ̃ drị̂ ꞌbaní ínátị vú sĩ ínátị vú sĩ rĩ ꞌi: Lõkókõrí ãngũ fẽlé ĩꞌbaní ãwítã rú rĩ drị̂ iꞌdó ru ị̃tụ̂ ꞌbã ãfũ agâlé ru Ãtãrọ́tị̃ Ádã gá cajó ụ́rụ́ Bẹ̃tị̃ Họ̃rọ́nị̃ gá, ");
INSERT INTO luc_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","mụ dó ꞌdãá rĩ sĩ kpere mĩrĩ Mẽdĩtẽránĩyãnĩ gá. Angájó ụ́rụ́ Mĩkĩmẽtátĩ gá ꞌdãá rĩ sĩ lõkókõrị̂ agọ́ dó ru ị̃tụ̂ ꞌbã ãfũ agâlé ru mụjó Tãnátị̃ Sị́lọ̃ gá, alị ala gâsĩ sĩ mụjó Yãnówã gá ị̃tụ̂ ꞌbã ãfũ agâlé ru. ");
INSERT INTO luc_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","Angájó Yãnówã gá ꞌdãá rĩ sĩ mụ dó Ãtãrọ́tị̃ gá, Nãárã gá ãzíla ãkpõ Yẹ̃rị́kọ̃ ꞌbã tị ala gá ĩndĩ, mụ dó sĩ ãsị̃lé mĩrĩ Yõrĩdánĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","Angájó Tápũwã gá rĩ sĩ, lõkókõrî mụ ị̃tụ̂ ꞌbã ꞌde agâlé ru wọ́rọ̃ŋá Kána drị̂ gá ãzíla ãsị̃ dó sĩ mĩrĩ Mẽdĩtẽránĩyãnĩ gá. ꞌDĩ dó sĩ ãngũ fẽlé sụ́rụ́ Ịfụrayị́mụ̃ drị̂ ꞌbaní ãwítã rú ínátị vú sĩ ínátị vú sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","Ala gá umú vâ táwụ̃nị̃ ãzí Ịfụrayị́mụ̃ drị̂ kí pírí tọ̃rọ́mẹ́ la ala gá rĩ kí abe pẽlé ndú ꞌbá Ịfụrayị́mụ̃ drị̂ ꞌbaní ãngũ fẽlé ãwítã rú ꞌbá Mãnásẽ drị̂ ꞌbaní rĩ agá. ");
INSERT INTO luc_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","Wó dro kí ándrá ꞌbá Kãnánĩ drị́ uꞌálépi Gẹ̃zẹ́rị̃ gá rĩ kí gẹ̃rị̃ sĩ ku, ị́jọ́ ꞌdĩ sĩ ꞌbá Kãnánĩ drị̂ kí drĩ kpere ãndrũ ꞌbá Ịfụrayị́mụ̃ drị̂ kí drĩdríŋĩ gá cí, wó ála kí ũmŋĩ sĩ ãzị́ ngajó ũkpó sĩ ꞌbá Ịfụrayị́mụ̃ drị̂ ꞌbaní ãtíꞌbó ru. ");
INSERT INTO luc_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","ꞌDĩ ãngũ fẽlé ãwítã rú sụ́rụ́ Mãnásẽ drị̂ ní ĩꞌdi ꞌbã adrujó Yụ̃sụ́fụ̃ ꞌbã ngọ́tị́ kãjãní rĩ sĩ rĩ ꞌi. Mãkírĩ ĩꞌdi Mãnásẽ ꞌbá ngọ́tị́ kãjãní rĩ ꞌi. Mãkírĩ ĩꞌdi áyị́pị ꞌbá Gị̃lẹ́dị̃ gá rĩ ꞌbadrị̂, ịsụ́ ándrá ãngũ Gị̃lẹ́dị̃ drị̂ kí Bãsánĩ drị̂ be la ãꞌdusĩku ꞌbá Mãkírĩ drị̂ kí ándrá ꞌbá ãꞌdị́ ãni ũkpó la kî. ");
INSERT INTO luc_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","Ị́jọ́ ꞌdĩ sĩ úfẽ dó sĩ ãngũ ꞌdĩ ꞌbá Mãnásẽ drị̂ ꞌbã ị́mbị́ acelépi rĩ ꞌbaní, ínátị ĩꞌbadrị̂ kí vú sĩ. Ínátị la kí: Ãbị̃yẹ̃zẹ́rị̃ ꞌi, Hẹ̃lẹ́kị̃ ꞌi, Ãsĩrayẹ́lị̃ ꞌi, Sẹ̃kẹ́mụ̃ ꞌi, Hẹ̃fẹ́rị̃ ꞌi ãzíla Sẹ̃mị́dã ꞌi. ꞌDĩ kí ãgọbị anzị Yụ̃sụ́fụ̃ ꞌbã ngọ́pị Mãnásẽ drị̂ kí ínátị ĩꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","Mãnásẽ ꞌbã ngọ́pị Mãkírĩ ꞌi, Mãkírĩ ꞌbã ngọ́pị Gị̃lẹ́dị̃ ꞌi, Gị̃lẹ́dị̃ ꞌbã ngọ́pị Hẹ̃fẹ́rị̃ ꞌi, Hẹ̃fẹ́rị̃ ꞌbã ngọ́pị Zẹ̃lọ̃fẹ̃hádị̃ ꞌi, ĩꞌdi ándrá ngọ́tị́ ágọ́bị́ kọ́lị, ãko ĩꞌdidrị̂ kí ándrá pírí izonzị. Rụ́ la kí: Máhĩlã ꞌi, Nọ́wã ꞌi, Họ́gị̃lã ꞌi, Mílĩkã ꞌi, ãzíla Tị̃rị́zã ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","Izonzị ꞌdĩ mụ kí Ị̃lị̃yãzárị̃ átáló ru rĩ rụ́, Yósũwã Nụ́nị̃ ngọ́pị rụ́ ãzíla ꞌbá drị̃lẹ́ ru rĩ ꞌba rú jọ kí, “Úpí fẽ ándrá ãzị́táŋá Mụ́sã ní sĩ ãngũ ãmadrị́ ãwítã rú rĩ fẽjó ãmã ádrị́pịka kí drĩdríŋĩ gá ꞌdâ.” Ị́jọ́ ꞌdĩ sĩ Yósũwã fẽ dó sĩ ãngũ ĩꞌbadrị́ ãwítã rú rĩ ĩꞌbã ádrị́pịka átịdrị́ gá rĩ kí drĩdríŋĩ gá ꞌdãá, Úpí ꞌbã ãzị́táŋá la fẽjó rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","Ị́jọ́ ꞌdĩ sĩ sụ́rụ́ Mãnásẽ drị̂ ꞌdụ dó sĩ ãngũ kí mụdrị́ ãngũ Gị̃lẹ́dị̃ drị̂ kí ꞌbã ãzí ru ãngũ Bãsánĩ drị̂ be wókõ mĩrĩ Yõrĩdánĩ drị́ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá, ");
INSERT INTO luc_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","ãꞌdusĩku sụ́rụ́ Mãnásẽ drị̂ ꞌbã izonzị kí ándrá ãngũ ãwítã rú rĩ ịsụ́ ádrị́pịka kí drĩdríŋĩ gá ꞌdãá ũgũgõ. Ãngũ Gị̃lẹ́dị̃ drị̂ úfẽ ĩꞌdi anzị Mãnásẽ drị̂ ꞌbã ị́mbị́ acelépi rĩ ꞌba nî. ");
INSERT INTO luc_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","Ãngũ Mãnásẽ drị̂ ĩjũ ru angájó Ásẹ̃rị̃ gá cajó Mĩkĩmẽtátĩ gá ꞌdĩ Sẹ̃kẹ́mụ̃ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá. Lõkókõrî mụ ándrá lé ru asú dó sĩ ꞌbá uꞌálépi Ị̃yị́ Tãpúwã gá rĩ kí ala gá ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","Táwụ̃nị̃ Tãpúwã ĩꞌdi lõkókõrí ãngũ ꞌbá Mãnásẽ ꞌbadrị́ sụ́rụ́ Ịfụrayị́mụ̃ drị̂ be rĩ gá. Táwụ̃nị̃ Tãpúwã ĩꞌdi sụ́rụ́ Ịfụrayị́mụ̃ drị̂ ꞌbãni wó ãngũ andre la celépi rĩ ĩꞌdi Mãnásẽ ãni. ");
INSERT INTO luc_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","ꞌDã ꞌbã ũngúkú gá, lõkókõrî alị dó ándrá wọ́rọ̃ŋá Kána drị̂ gâsĩ. Táwụ̃nị̃ ándrá wọ́rọ̃ŋá Kána drị̂ gá rĩ kí ándrá Ịfụrayị́mụ̃ ãni ĩꞌbaní táni adru agá ãngũ Mãnásẽ drị̂ agá rá tí. Lõkókõrí Mãnásẽ drị̂ alị ãnirú wọ́rọ̃ŋá Kána drị̂ ꞌbã wókõ ụ́rụ́ rĩ gâsĩ mụ dó sĩ ãsị̃lé mĩrĩ Mẽdĩtẽránĩyãnĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","Ãngũ ị̃yị́ tị gá ándrá rĩ ĩꞌdi sụ́rụ́ Ịfụrayị́mụ̃ drị̂ ani ãzíla ãngũ ụ́rụ́ rĩ ĩꞌdi sụ́rụ́ Mãnásẽ drị̂ ani. Sụ́rụ́ Mãnásẽ drị̂ ꞌbã ãngũ su ru tị kpere mĩrĩ Mẽdĩtẽránĩyãnĩ gá ị̃tụ̂ ꞌbã ꞌde agá wókõ ụ́rụ́lé rĩ gá, Ásẹ̃rị̃ ĩꞌdi Mãnásẽ ꞌbã wókõ ụ́rụ́ rĩ gá, ãzíla Ĩsãkárĩ ĩꞌdi Mãnásẽ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","Táwụ̃nị̃ ãzí kí sụ́rụ́ Ĩsãkárĩ ꞌbadrị́ Ásẹ̃rị̃ be rĩ kí agá tọ̃rọ́mẹ́ la kí abe kí sụ́rụ́ Mãnásẽ drị̂ ãni. Táwụ̃nị̃ ꞌdĩ kí Bẹ̃tị̃ Sánị̃ ꞌi, Ị̃bụ̃lẹ́mụ̃ ꞌi, Dọ́rị̃ vâ umvelé Nãfọ́tị̃ Dọ́rị̃ rĩ ꞌi, Ị̃nị̃-dọ́rị̃ ꞌi, Tãnákĩ ꞌi, ãzíla Mẹ̃gị́dọ̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","Wó ꞌbá Mãnásẽ drị̂ icó kí táwụ̃nị̃ ꞌdĩ kí ꞌdụlé ĩꞌba ãni la rú ku. Ị́jọ́ ꞌdĩ sĩ ꞌbá Kãnánĩ rú rĩ ace kí ru uꞌálé táwụ̃nị̃ ꞌdĩ kí agá ũgũgõ. ");
INSERT INTO luc_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","Wó vúlé vúlé ru ꞌbá Ịsịrayị́lị̃ drị̂ kí mụ acálé ũkpó trũ ꞌbo, ũmŋĩ kí ꞌbá Kãnánĩ drị̂ kí ãzị́ ngajó ĩꞌbaní ũkpó sĩ ãtiꞌbo ru. Dro kí dó sĩ kí gẹ̃rị̃ sĩ ku. ");
INSERT INTO luc_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","ꞌDã ꞌbã ũngúkú gá, anzị Yụ̃sụ́fụ̃ drị̂ amụ́ kí Yósũwã rú ãzíla jọ kí ĩꞌdiní, “Ífẽ dó ãmaní ãngũ ãwítã rú rĩ were rú la ãꞌdu ị́jọ́ sĩ yã? Ãma kãlãfe ũꞌbí ru ãꞌdusĩku Úpí fẽ ãmaní drị̃lẹ́ba rá.” ");
INSERT INTO luc_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","Yósũwã umvi dó ĩꞌbaní, “Ĩdrĩ adru ũꞌbí ru ãzíla ãngũ ꞌbé ru Ịfụrayị́mụ̃ drị̂ drĩ ca ĩminí ku yã ani, ĩtụ dó mị̃rị́ agâlé ru, ĩmi idé dó sĩ ĩminí ãngũ ꞌbá Pẹ̃rẹ́zị̃ drị̂ ꞌbã kí uꞌá agá ꞌbá Rẹ̃fãyị́mụ̃ drị̂ kí abe rĩ gá ꞌdãá.” ");
INSERT INTO luc_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","Anzị Ịfụrayị́mụ̃ drị̂ umvi kí ĩꞌdiní, “Ĩꞌdi ãndá ãngũ ꞌbé agá rĩ ĩꞌdi wereŋá ru ca ãmaní ku, wó ꞌbá Kãnánĩ drị́ uꞌálépi ãngũ gbayi rĩ agá rĩ ꞌbadrị́ gárĩ ãꞌdị́ drị́ idélé aya sĩ rĩ kí cí, Bẹ̃tị̃ Sánị̃ gá ãzíla tọ̃rọ́mẹ́ la andre la celépi rĩ kí abe ãzíla ꞌbá uꞌálépi áꞌbụ ꞌa Yẹ̃zẹ̃rẹ́lị̃ gá rĩ kí vâ gárĩ ãꞌdị́ drị̂ trũ, ị́jọ́ ꞌdĩ sĩ ãma icó kí ndẽlé ku.” ");
INSERT INTO luc_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","Yósũwã umvi Mãnásẽ ní, “Ánị̃ rá sụ́rụ́ ĩmidrị́ Ịfụrayị́mụ̃ drị̂ agá ꞌdâ ĩmi kãlãfe ũꞌbí ru ãzíla ĩmi vâ ãꞌdị́ gá ũkpó ru. Ị́jọ́ ꞌdĩ sĩ ma ĩminí ãngũ ãzị́ fẽ ị̃dị́. ");
INSERT INTO luc_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","Wó ãngũ ꞌbé agá rĩ la dó mụ adrulé ĩmĩni, drĩ táni adru agá mị̃rị́ ru tí, ĩmi idé ĩꞌdi, ĩꞌdụ dó sĩ ĩꞌdi ĩminí uꞌájó. ꞌBá Kãnánĩ drị̂ drĩ kí táni adru agá gárĩ ãꞌdị́ drị́ aya rú rĩ kî trũ ãzíla ãꞌdị́ sĩ ũkpó ru rá tí, ĩmi ícó kí drolé rá sĩ áꞌbụ ꞌa ꞌdã aꞌbejó.” ");
INSERT INTO luc_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","ꞌDã ꞌbã ũngúkú gá, ꞌbá Ịsịrayị́lị̃ drị̂ tra kí dó ru pírí Sị́lọ̃ gá ãzíla sõ kí dó sĩ hémã tị icíma drị̂ ꞌdãá. Ãngũ acá dó sĩ kí drị́ ꞌalé gá. ");
INSERT INTO luc_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","Wó sụ́rụ́ Ịsịrayị́lị̃ drị̂ kí agá ꞌbá sĩ ãngũ fẽjó ĩꞌbaní ãwítã rú ku rĩ ace kí ru ázị̂rị̃. ");
INSERT INTO luc_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","Ị́jọ́ ꞌdĩ sĩ Yósũwã jọ dó ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, “Ĩlẽ tẽlé la kpere ãꞌdụtụ́ sĩ ãngũ Úpí Ãdróŋá ĩmĩ áyị́pịka ꞌbadrị̂ ꞌbã fẽlé ĩminí rĩ ꞌdụjó ĩmĩ ãni la rú yã? ");
INSERT INTO luc_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","Ĩmi ãpẽ ãgọbị kí na na sụ́rụ́ ãlu-ãlu agá, ma dó sĩ kí tị pẽ sĩ acị́jó ãngũ ꞌdã ꞌa undré trũ. ꞌDã ꞌbã ũngúkú gá, kí dó sĩ ãgõ ị́jọ́ ĩꞌbã kí ũsĩlé ãngũ sụ́rụ́ ãlu-ãlu drị́ ãwítã rú rĩ drị̃ gá rĩ kî trũ má rụ́ ꞌdõlé. ");
INSERT INTO luc_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","Ĩmi awa ãngũ ꞌdã tị ndúndú ázị̂rị̃. Yụ́dã ꞌba ace ru ãngũ ĩꞌdidrị́ ándrá rĩ gá ãzíla sụ́rụ́ Yụ̃sụ́fụ̃ drị̂ ꞌba ace ru ãngũ ĩꞌdidrị́ ụ́rụ́ rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","Ĩdrĩ dó ị́jọ́ ãngũ ázị̂rị̃ ꞌdĩ kí drị̃ gá rĩ de ũsĩ agâ ꞌbo, ĩmi ají dó ị́jọ́ ĩminí ũsĩlé rĩ kí má rụ́ ꞌdõlé, ma dó sĩ ĩminí jẽgê ꞌbe Úpí Ãdróŋá drị̃lẹ́ gá sĩ awajó la sụ́rụ́ ãlu-ãlu nî. ");
INSERT INTO luc_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","ꞌBá Lẹ́vị̃ rú rĩ ịsụ́ kí ãngũ ĩmi drĩdríŋĩ gá ku, ãꞌdusĩku kí ãko ĩꞌbadrị̂ kí ịsụ́ ãzị́ ĩꞌbaní ngalé átáló ru Úpí ní rĩ sĩ. Gádĩ kí Rụ́bẹ̃nị̃ be ãzíla sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ kí abe ịsụ́ kí ãngũ ĩꞌbadrị̂ mĩrĩ Yõrĩdánĩ ꞌbã ꞌá ꞌdã sĩ ị̃tụ̂ ꞌbã ãfũ agâlé ru ꞌbo, ꞌdĩ ãngũ ándrá ãtíꞌbó Úpí drị́ Mụ́sã ꞌbã fẽlé ĩꞌbaní rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","Ị́jọ́ ꞌdĩ sĩ ꞌbá ꞌdĩ ꞌbã kí lẽ agá mụ agá ãngũ ꞌdã undré trũ ꞌdĩ gá ꞌdâ, Yósũwã azị ĩꞌbaní, “Ĩmi acị́ ãngũ ꞌdã ꞌbã ꞌa undré trũ pírí, ĩmi ũsĩ ị́jọ́ drị̃ la gá ãzíla ĩmi ãgõ dó trũ má rụ́ ꞌdõlé. Ma dó sĩ mụ ĩminí jẽgê ꞌbelé Úpí drị̃lẹ́ gá Sị́lọ̃ gâlé.” ");
INSERT INTO luc_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","Ị́jọ́ ꞌdĩ sĩ ãgọbị ũpẽlé rĩ mụ kí dó rá, ací kí ãngũ ꞌdã agá sĩ ãzíla ũsĩ kí dó ị́jọ́ ĩꞌbaní ịsụ́lé rĩ kí bụ́kụ̃ gá táwụ̃nị̃ ãlu-ãlu sĩ ãzíla ají kí dó ị́jọ́ ꞌdĩ kí Yósũwã rụ́ kámbĩ gá Sị́lọ̃ gá ꞌdõlé. ");
INSERT INTO luc_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","Yósũwã awa dó ãngũ ꞌdã ĩꞌbaní Úpí drị̃lẹ́ gá jẽgê ꞌbeŋá sĩ Sị́lọ̃ gá ꞌdãá. Awa dó ãngũ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ínátị ĩꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","Sụ́rụ́ Bénzãmĩnĩ drị̂ ní úfẽ ãngũ jẽgê ꞌbã ꞌdejó ĩꞌdiní drị̃drị̃ rĩ sĩ ínátị ĩꞌbadrị̂ kí vú sĩ. Ãngũ fẽlé ĩꞌdiní rĩ ĩꞌdi drĩdríŋĩ ꞌbá Yụ́dã drị̂ ꞌbadrị́ ꞌbá Yụ̃sụ́fụ̃ drị̂ kí abe rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","Lõkókõrí ĩꞌbadrị́ ụ́rụ́ rĩ iꞌdó ru ị̃yị́ Yõrĩdánĩ gá, alị Yẹ̃rị́kọ̃ ꞌbã pá gâsĩ wókõ ụ́rụ́ rĩ gá ãzíla uja dó ru mụjó ãngũ ꞌbé ꞌa rú rĩ gâlé ru. Lõkókõrî ca kpere kõtórõ Bẹ̃tị̃ Ávẹ̃nị̃ drị̂ gá wókõ ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","ꞌDãá rĩ sĩ lõkókõrî ali Lụ́zị̃ ꞌbã pá ilúlépi ándrá rĩ gâsĩ (ꞌdĩ Bẹ̃tẹ́lị̃ gá) ãzíla ĩjũ dó ru wókõ ándrá ị̃tụ̂ bá ꞌde agâlé ru rĩ gâsĩ Ãtãrọ́tị̃ Ãdárĩ gá, ꞌbé Bẹ̃tị̃ Họ̃rọ́nị̃ ꞌbã drị̃ gâsĩ ándrâlé. ");
INSERT INTO luc_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","ꞌBé Bẹ̃tị̃ Họ̃rọ́nị̃ drị̂ drị̃ gá ꞌdãá rĩ sĩ lõkókõrî uja mụlé ándrá Kị̃rị̃yátị̃ Bãálĩ gâlé ru (ꞌdĩ Kĩrĩyátĩ Yẹ̃yãrị́mụ̃ ꞌi) ꞌdĩ táwụ̃nị̃ ꞌbá Yụ́dã drị̂ ꞌbadrị̂ ꞌi, wókõ ị̃tụ̂ ꞌbã ꞌde gâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","Lõkókõrí ándrá rĩ iꞌdó ru Kĩrĩyátĩ Yẹ̃yãrị́mụ̃ ꞌbã wókõ ãmvélé rĩ gá, ãzíla mụ kpere ị̃tụ̂ ꞌbã ꞌde agâlé ru ị̃yị́ Nẹ̃fị̃tọ́wã gá. ");
INSERT INTO luc_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","ꞌDãá rĩ sĩ lõkókõrî mụ ꞌbé ru ndrelépi áꞌbụ ꞌa Rẹ̃fãyị́mụ̃ drị̂ be rĩ ꞌbã pá gâsĩ vụ̃rụ̂lé, ꞌdĩ áꞌbụ ꞌa Hị̃nọ́mụ̃ ꞌbã iꞌdó agá wókõ áꞌbụ ꞌa Rãfẹ̃yị́mụ̃ drị̂ ꞌbã ãsĩ agá wókõ ụ́rụ́ rĩ gá. ꞌDã ꞌbã ũngúkú gá, lõkókõrî mụ Hị̃nọ́mụ̃ gá vụ̃rụ̂lé táwụ̃nị̃ Yẹ̃bụ́sị̃ drị̂ ꞌbã pá ándrá rĩ gâsĩ ãzíla kpere Ẽnĩ Rõgélĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","ꞌDã ꞌbã ũngúkú gá, lõkókõrî mụ dó ụ́rụ́ ãzíla agọ́ dó ru sĩ mụjó Ị̃nị̃ Sẹ̃mẹ́sị̃ gá ãzíla ꞌdãá rĩ sĩ mụ Gẹ̃lị̃lọ́tị̃ ru ndrelépi ãngũ túpũ rú Ãdũmímũ be rĩ gá ãzíla sị vụ̃rụ́ írã Bõhánĩ ándrá Rụ́bẹ̃nị̃ ꞌbã ngọ́pị rú rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","ꞌDãá rĩ sĩ ị̃drị̃ ru drị̃ gá mụjó ụ́rụ́ ãngũ ilúlépi Bẹ̃tị̃ Ãrábã gá rĩ gá ãzíla sị dó vụ̃rụ́ Ãrábã gâlé. ");
INSERT INTO luc_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","ꞌDã ꞌbã ũngúkú gá, mụ Bẹ̃tị̃ Họ́gị̃lã ꞌbã wókõ ilúlépi ụ́rụ́ rĩ gâsĩ mụ ãsị̃lé ị̃yị́ tị mĩrĩ ãꞌị́ ru rĩ drị̂ gá, ꞌdĩ ị̃yị́ Yõrĩdánĩ ꞌbã wókõ ándrá rĩ gá. Lõkókõrí ꞌdĩ ándrá sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","Lõkókõrí wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ ĩꞌdi ị̃yị́ Yõrĩdánĩ ꞌi. ꞌDĩ kí ándrá lõkókõrí ãngũ ãwítã rú ínátị ꞌbá Bénzãmĩnĩ drị̂ kí iꞌdalépi wókõ pírí kí agâsĩ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","ꞌDĩ kí táwụ̃nị̃ fẽlé sụ́rụ́ Bénzãmĩnĩ drị̂ ní íná tị ĩꞌbadrị̂ kí vú sĩ rĩ kî: Yẹ̃rị́kọ̃ ꞌi, Bẹ̃tị̃ Họ́gị̃lã ꞌi, Ị̃mẹ́kị̃ ꞌi, Kẹ̃zị́zị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","Bẹ̃tị̃ Ãrábã ꞌi, Zẹ̃mãrãyị́mụ̃ ꞌi, Bẹ̃tẹ́lị̃, ");
INSERT INTO luc_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","Ãvị́mụ̃, Párã, Ụ́fị́rã, ");
INSERT INTO luc_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","Kẹ̃fãrị̃ ꞌi, Ãmọ́rị̃ ꞌi, Ụ̃fị́nị̃ ꞌi, Gébã ꞌi, kí táwụ̃nị̃ mụdrị́ drị̃ ị̃rị̃ tọ̃rọ́mẹ́ la kí abe ");
INSERT INTO luc_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","Gị̃bẹ̃yọ́nị̃ ꞌi, Rámã ꞌi, Bẹ̃yãrọ́tị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","Mị̃zị́pã ꞌi, Kẹ̃fị́rã ꞌi, Mózã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","Rẹ̃kẹ́mụ̃ ꞌi, Ị̃rị̃pẹ́lị̃ ꞌi, Tãrálã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","Zélã ꞌi, Hãyẹ̃lẹ́fụ̃ ꞌi, táwụ̃nị̃ ꞌbá Yẹ̃bụ́sị̃ rú rĩ ꞌba drị́ Yẹ̃rụ́sãlẹ́mụ̃ ꞌi, Gị̃bẹ́yã ꞌi, ãzíla Kị̃rị̃yátị̃ ꞌi táwụ̃nị̃ mụdrị́ drị̃ sụ ãzíla tọ̃rọ́mẹ́ la kí abe. ꞌDĩ kí ãngũ fẽlé ãwítã rú sụ́rụ́ Bénzãmĩnĩ drị̂ ꞌbaní ínátị ĩꞌbadrị̂ kí vú sĩ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","Sụ́rụ́ Sị̃mọ́nị̃ drị̂ ní úfẽ ãngũ jẽgê ꞌbã ꞌdejó ĩꞌdiní námbã ị̃rị̃ sĩ rĩ sĩ ínátị ĩꞌbadrị̂ kí vú sĩ. Ãngũ fẽlé ĩꞌbaní ãwítã rú rĩ ꞌde ãngũ anzị Yụ́dã drị̂ ꞌbadrị̂ agá. ");
INSERT INTO luc_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","Ãngũ ãwítã rú ala gá ĩndĩ rĩ kí: Bẹ̃rị̃sẹ́bã ꞌi, Sébã ꞌi, Mũládã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","Hãzárị̃ Sụ̃wálị̃ ꞌi, Bálã ꞌi, Ị̃zẹ́mụ̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","Ị̃lị̃tọ̃ládị̃ ꞌi, Bẹ̃tụ́lị̃ ꞌi, Họ́rị̃mã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","Zĩkĩlágĩ ꞌi, Bẹ̃tị̃ Mãrị̃kãbọ́tị̃ ꞌi, Hãzãrĩ Sụ́sã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","Bẹ̃tị̃ Lẹ̃bãwọ́tị̃ ꞌi, Sãrũhénĩ ꞌi, táwụ̃nị̃ mụdrị́ drị̃ na tọ̃rọ́mẹ́ ĩꞌba drị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","Táwụ̃nị̃ ãzí sụ Ãꞌị́nị̃ ꞌi, Rị̃mọ́nị̃ ꞌi, Ị̃tẹ́rị̃ ꞌi ãzíla Ãsánị̃ ꞌi tọ̃rọ́mẹ́ ĩꞌbadrị̂ kí abe kí ala gá ĩndĩ. ");
INSERT INTO luc_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","ꞌDĩ kí tọ̃rọ́mẹ́ pírí ándrá táwụ̃nị̃ ꞌdi kí andre celépi trộkị́lịrị kpere Bãlátĩ Bẹ́rị̃ gá, Rámã gá ꞌdĩ ãngũ Nẹ̃gẹ́vụ̃ gá rĩ kî. ꞌDĩ ãngũ fẽlé ãwítã rú sụ́rụ́ anzị Sị̃mọ́nị̃ drị̂ ꞌbaní ínátị ĩꞌbadrị̂ kí vú sĩ rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","Ãngũ ãwítã rú anzị Yụ́dã drị̂ ꞌbadrị̂ ꞌbã wókõ ãzí rĩ úfẽ ĩꞌdi anzị Sị̃mọ́nị̃ drị̂ ꞌbanî, ãꞌdusĩku ãngũ fẽlé anzị Yụ́dã drị̂ ꞌbaní rĩ ĩꞌdi ándrá ambamba, ị́jọ́ ꞌdĩ sĩ ãngũ fẽlé anzị Sị̃mọ́nị̃ drị̂ ꞌbaní rĩ ĩꞌdi ãngũ anzị Yụ́dã drị̂ ꞌbadrị̂ agá. ");
INSERT INTO luc_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","Sụ́rụ́ Zãbụ̃lọ́nị̃ drị̂ ꞌbaní úfẽ ãngũ ãwítã rú rĩ jẽgê ꞌbã ꞌdejó ĩꞌdiní námbã na sĩ rĩ sĩ ínátị anzị ĩꞌbadrị̂ ꞌbadrị́ kí vú sĩ. Lõkókõrí ãngũ ĩꞌbadrị̂ drị̂ se ru cajó kpere Sãrị́dị̃ gá. ");
INSERT INTO luc_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","Angájó ꞌdãá rĩ sĩ, lõkókõrî mụ dó ị̃tụ̂ ꞌbã ꞌde agâlé ru Mãrálã gá, aló dó Dãbẹ̃sẹ́tị̃ ĩndĩ se dó sĩ ru ãni rú wọ́rọ̃ŋá Yõkĩnẽyámũ drị̂ ꞌbã tị gá. ");
INSERT INTO luc_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","Angájó Sãrị́dị̃ gá rĩ sĩ, lõkókõrî uja dó ru mụlé ị̃tụ̂ ꞌbã ãfũ agâlé ru ãngũ Kị̃sị̃lọ́tị̃ Tãbọ́rị̃ gá ĩjũ dó si ru mụjó Dãbẽrátĩ gâsĩ cajó kpere Yáfĩyã gá. ");
INSERT INTO luc_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","ꞌDã ꞌbã ũngúkú gá, alị dó ị̃tụ̂ ꞌba ãfũ agâlé ru kpere Gãtã Hẹ̃fẹ́rị̃ gá ãzíla Ĩtĩ Kãzínĩ gá, mụ íni Rị̃mọ́nị̃ gá, ị̃drị̃ dó sĩ ru Néyã gâlé. ");
INSERT INTO luc_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","ꞌDãá rĩ gá lõkókõrî pi dó ru ụ́rụ́ Hãnãtónĩ gâsĩ ãzíla ãsị̃ dó áꞌbụ Ĩfãtã Ị́lị̃ gá. ");
INSERT INTO luc_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","Ala gá ĩndĩ rĩ kí Kãtátĩ ꞌi, Nãhãlálĩ ꞌi, Sị̃mị̃rọ́nị̃ ꞌi, Ĩdálã ꞌi ãzíla Bẹ̃tẹ̃lẹ̃hẹ́mụ̃ ꞌi. Táwụ̃nị̃ kí mụdrị́ drị̃ ị̃rị̃ tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","ꞌDĩ kí táwụ̃nị̃ ãzíla tọ̃rọ́mẹ́ fẽlé sụ́rụ́ Zãbụ̃lọ́nị̃ drị̂ ꞌbaní ãwítã rú ínátị anzị ĩꞌbadrị̂ ꞌbadrị̂ kí vú sĩ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","Sụ́rụ́ Ĩsãkárĩ drị̂ ní úfẽ ãngũ jẽgê ꞌbã ꞌdejó ĩꞌdiní námbã sụ sĩ rĩ sĩ ínátị anzị ĩꞌbadrị̂ ꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","Ãngũ ĩbadrị̂ umú: Yẹ̃zẹ̃rẹ́lị̃ ꞌi, Kẹ̃sụ̃lọ́tị̃ ꞌi, Sụ̃námụ̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","Hãfãrãyị́mụ̃ ꞌi, Sị̃yọ́nị̃ ꞌi, Ãnãhãrátị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","Rãbítĩ ꞌi, Kị̃sị̃yọ́nị̃ ꞌi, Ị̃bẹ́zị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","Rẹ̃mẹ́tị̃ ꞌi, Ị̃nị̃ Gãnímũ ꞌi, Ị̃nị̃ Hádã ꞌi ãzíla Bẹ̃tị̃ Pãzẹ́zị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","Lõkókõrî ca kpere Tãbọ́rị̃ gá, Sãhãzúmã gá, Bẹ̃tị̃ Sẹ̃mẹ́sị̃ gá, ãzíla ãsị̃ dó Yõrĩdánĩ gá. Ĩꞌbã táwụ̃nị̃ kí ándrá mụdrị́ drị̃ ázíyá tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","ꞌDĩ kí táwụ̃nị̃ ãzíla tọ̃rọ́mẹ́ fẽlé sụ́rụ́ Ĩsãkárĩ drị̂ ꞌbaní ãwítã rú ínátị anzị ĩꞌbadrị̂ ꞌbadrị̂ kí vú sĩ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","Sụ́rụ́ Ásẹ̃rị̃ drị̂ ní úfẽ ãngũ jẽgê ꞌbã ꞌdejó ĩꞌdiní námbã tõwú sĩ rĩ sĩ ínátị anzị ĩꞌbadrị̂ ꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","Ãngũ ĩbadrị̂ umú: Hẽlĩkátĩ ꞌi, Hálĩ ꞌi, Bẽténĩ ꞌi, Ãkĩsáfũ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","Ãlãmẹ́lẹ̃kị̃ ꞌi, Ãmádĩ ꞌi, ãzíla Mĩsálĩ ꞌi. Wókõ ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ gá ca kpere Kãrị̃mẹ́lị̃ gá ãzíla Sĩhórĩ Lị̃bị̃nátị̃ gá. ");
INSERT INTO luc_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","ꞌDa ꞌbã ũngúkú gá uja ru ị̃tụ̂ ꞌbã ãfũ agâlé ru ca kpere Bẹ̃tị̃ Dãgọ́nị̃ gâlé ru aló Zãbụ̃lọ́nị̃ kí áꞌbụ Ĩfãtã Ílĩ be ãzíla mụ ụ́rụ́ Bẹ̃tị̃ Ị̃mẹ́kị̃ gá Nẹ̃yẹ́lị̃ be. ꞌDã bã ũngúkú gá alị dó sĩ Kãbụ́lụ̃ ꞌbã wókõ ị̃jị́ gâsĩ. ");
INSERT INTO luc_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","Lõkókõrî mụ Ãbãdónĩ gá, Rẽhóbũ gá, Hẹ̃rị̃mọ́nị̃ gá, Kána gâsĩ, cajó Sị̃dọ́nị̃ Ãmbógó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","ꞌDã ꞌbã vúlé gá lõkókõrî uja ru Rámã gá, cajó táwụ̃nị̃ Tụ́rọ̃ drị́ andre celé Bõrõ sĩ rĩ gá. ꞌDã ꞌbã vúlé gá uja ru Hósã gá ãzíla mĩrĩ Mẹ̃dị̃tẹ̃rẹ́nị̃yãnị̃ gá rĩ sĩ ãfũ ãmvé amụ́ Ãkị̃zị́bụ̃ gá, ");
INSERT INTO luc_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","Úmã gá, Ãfẹ́kị̃ gá ãzíla Rẹ̃họ́bụ̃ gá. Táwụ̃nị̃ kãlị́ ị̃rị̃ drị̃ ị̃rị̃ tọ̃rọ́mẹ́ la kí abe. ");
INSERT INTO luc_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","ꞌDĩ kí táwụ̃nị̃ ãzíla tọ̃rọ́mẹ́ fẽlé sụ́rụ́ Ásẹ̃rị̃ drị̂ ꞌbaní ãwítã rú ínátị anzị ĩꞌbadrị̂ ꞌbadrị̂ kí vú sĩ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","Sụ́rụ́ Nãfũtálĩ drị̂ ní úfẽ ãngũ jẽgê ꞌbã ꞌdejó ĩꞌdiní námbã ázíyá sĩ rĩ sĩ ínátị anzị ĩꞌdidrị̂ ꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","Angájó Hẽléfũ gá rĩ sĩ Lõkókõrí ĩꞌbadrị̂ mụ, ãngũ kọmọrọ́ ife trũ Zãnãnị́mụ̃ gá, alị Ãdámị̃ Nẹ̃kẹ́bụ̃ gâsĩ Yãbãnẹ́lị̃ gá kpere Lãkụ́mụ̃ gá ãzíla mụ ãsị̃lé ị̃yị́ Yõrĩdánĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","Dã ꞌbã ũngúkú gá Lõkókõrî uja ru ị̃tụ̂ ꞌbã ꞌde agâlé ru Ãzị̃nọ́tị̃ Tãbọ́rị̃ gá, ꞌdãá rĩ sĩ mụ dó Hũkókĩ gá, aló Zãbụ̃lọ́nị̃ ꞌbã wókõ ándrá rĩ, ị̃tụ̂ ꞌbã ꞌde agâlé ru Ásẹ̃rị̃ ꞌi, wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá Yụ́dã kí mĩrĩ Yõrĩdánĩ be. ");
INSERT INTO luc_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","Táwụ̃nị̃ ándrá andre celé Bõrõ sĩ rĩ kí: Zị̃dị́mụ̃ ꞌi, Zẹ́rị̃ ꞌi, Hãmátĩ ꞌi, Rãkátĩ ꞌi, Kĩnẽrétĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","Ãdámã ꞌi, Rámã ꞌi, Hãzọ́rị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","Kẹ̃dẹ́sị̃ ꞌi, Ị̃drẹ́yị̃ ꞌi, Ị̃nãhãzọ́rị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","Yị̃rọ́nị̃ ꞌi, Mĩgĩdãlélĩ ꞌi, Hõrémụ̃ ꞌi, Bẹ̃tị̃ Ãnátị̃ ꞌi ãzíla Bẹ̃tị̃ Sẹ̃mẹ́sị̃ ꞌi, táwụ̃nị̃ mụdrị́ drị̃ úrômĩ tọ̃rọ́mẹ́ ĩꞌba drị̂ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","ꞌDĩ kí táwụ̃nị̃ ãzíla tọ̃rọ́mẹ́ fẽlé sụ́rụ́ Nãfũtálĩ drị̂ ꞌbaní ãwítã rú anzị ĩꞌdidrị̂ ꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","Sụ́rụ́ Dánĩ drị̂ ní úfẽ ãngũ jẽgê ꞌbã ꞌdejó ĩꞌdiní námbã ázị̂rị̃ sĩ rĩ sĩ anzị ĩꞌdidrị̂ ꞌbadrị̂ kí vú sĩ. ");
INSERT INTO luc_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","Ãngũ fẽlé ĩꞌdiní ãwítã rú rĩ umú: Zórã ꞌi, Ị̃sị̃tãyọ́lị̃ ꞌi, Ị̃rị̃ Sẹ̃mẹ́sị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","Sãlãbínĩ ꞌi, Ãyị̃yãlọ́nị̃ ꞌi, Ị́tị̃lã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","Ị̃lọ́nị̃ ꞌi, Tímũnã ꞌi, Ị̃kị̃rọ́nị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","Ị̃lị̃tẹ́kẹ̃ ꞌi, Gị̃bẹ̃tọ́nị̃ ꞌi, Bãlátĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","Yẹ̃hụ́dị̃ ꞌi, Bẽnẽ Bẹ̃rákị̃ ꞌi, Gãtị̃ Rị̃mọ́nị̃ ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","Mẹ̃-yãrị̃kọ́nị̃ ꞌi ãzíla Rãkónĩ ꞌdĩ ãngũ ru ndrelépi Yópã be rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","Wó ꞌbá Dánĩ drị̂ ịsụ́ kí ándrá ĩꞌdi ũkpó-ũkpó sĩ ãngũ fẽlé ĩꞌbaní rĩ ꞌdụjó, ị́jọ́ ꞌdĩ sĩ mụ kí dó ãꞌdị́ gá ꞌbá Lẹ̃sẹ́mụ̃ gá rĩ ꞌba rụ́, ụꞌdị́ kí dó kí ménéŋá sĩ ãzíla ri kí dó sĩ ãngũ ꞌdã gá cí. Ri kí dó Lẹ̃sẹ́mụ̃ gá cí, ꞌda kí dó sĩ rụ́ la ĩꞌbã áyị́pị Dánĩ ꞌbã rụ́ sĩ. ");
INSERT INTO luc_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","ꞌDĩ kí táwụ̃nị̃ ãzíla tọ̃rọ́mẹ́ fẽlé sụ́rụ́ Dánĩ drị̂ ꞌbaní ãwítã rú anzị ĩꞌdidrị̂ ꞌbadrị̂ kí vú sĩ rĩ kî. ");
INSERT INTO luc_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","ꞌBá Ịsịrayị́lị̃ drị̂ kí dó mụ ãngũ fẽlé ĩꞌbaní rĩ kí delé awa agá ꞌbo, fẽ kí dó ãngũ Yósũwã Nụ́nị̃ ngọ́pị ní ãwítã rú ");
INSERT INTO luc_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","cécé Úpí ꞌbã ãzị́táŋá la fẽjó rĩ áni. Fẽ kí dó ĩꞌdiní táwụ̃nị̃ ĩꞌdi bã aꞌị́lé Tị̃mụ̃nátị̃ Sérã ꞌi, ꞌdĩ ãngũ ꞌbé ꞌa rú Ịfụrayị́mụ̃ drị̂ agá rĩ gá. Sị dó sĩ ĩꞌdi táwụ̃nị̃ rú ãzíla ri dó sĩ uꞌálé ala gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","ꞌDĩ kí ãngũ Ị̃lị̃yãzárị̃ átáló ru Yósũwã Nụ́nị̃ ngọ́pị ãzíla drị̃lẹ́ sụ́rụ́ ínátị Ịsịrayị́lị̃ drị̂ ꞌbã kí awalé ãwítã rú jẽgê ꞌbeŋá sĩ Sị́lọ̃ gá Úpí ꞌbã drị̃lẹ́ gá kẹ̃jị́tị sĩ fijó hémã tị icíma drị̂ gá rĩ gá rĩ kî. Ị́jọ́ ꞌdĩ sĩ de kí dó sĩ ãngũ awalé rá. ");
INSERT INTO luc_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","ꞌDã ꞌbã ũngúkú gá, Úpí jọ dó Yósũwã ní, ");
INSERT INTO luc_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“Ị́jọ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní, ꞌbã ũpẽ kí táwụ̃nị̃ ãzí kí ĩꞌbaní sĩ icójó apájó ru zị̃jó ala gá rĩ kí cécé ándrá mání jọlé Mụ́sã ní rĩ áni, ");
INSERT INTO luc_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","ꞌbá ãzí drị́ drĩ ru pa ꞌbá ꞌdịjó drị̃lẹ́ ũnzĩ sĩ drĩ adru ị́jọ́ ásị́ gá la sĩ ku yã áni, ĩꞌdi dó sĩ icó apálé ru zị̃lé sĩ ru tãmbajó táwụ̃nị̃ ꞌdã kí ãzí agá rá. ");
INSERT INTO luc_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","“Icó apálé táwụ̃nị̃ ꞌdĩ kí ꞌbã ãzí ãlu la gá, ĩꞌdi dó sĩ pá tu táwụ̃nị̃ ꞌbã kẹ̃jị́tị gá sĩ ị́jọ́ vú nzejó ꞌbá ĩyõ táwụ̃nị̃ ꞌdã agá rĩ ꞌbanî. ꞌDã ꞌbã ũngúkú gá, ꞌbá ĩyõ kí dó sĩ ĩꞌdi agụ táwụ̃nị̃ agâlé sĩ ĩꞌdiní ãngũ fẽjó ãzíla ĩꞌdi dó sĩ ru ace uꞌálé ĩꞌba abe ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","ꞌBá ꞌdịlé rĩ ꞌbã kãká ãzí drĩ dó sĩ ĩꞌdi vú dro sĩ lẽjó ãvũ ãrígó ũfẽjó, lẽ úfẽ ꞌbá ꞌbá ꞌdịlépi rĩ ĩꞌdĩ drị́ ku, ãꞌdusĩku adru ꞌdị ĩꞌdi ꞌbã jĩránĩ ĩꞌdiní ĩꞌdi ngụ̃jó ũnzí rĩ sĩ la ku. ");
INSERT INTO luc_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","ꞌBá ꞌbá ꞌdịlépi ꞌdã ꞌbã uꞌá táwụ̃nị̃ ꞌdã gá ꞌdãá kpere ĩꞌdi ꞌbã amụ́ agá pá tụ agá ũꞌbí kí drị̃lẹ́ gá ãzíla kpere átáló ãmbógó ãndânĩ ãzị́ ngalépi sáwã ꞌdã sĩ rĩ ꞌbã drã agá. ꞌDã ꞌbã ũngúkú gá, ꞌbá ꞌbá ꞌdịlépi rĩ icó dó sĩ gõlé táwụ̃nị̃ ãzíla lị́cọ́ ĩꞌdidrị́ ándrá ĩꞌdi ꞌbã sĩ apájó rĩ gâlé vúlé rá.” ");
INSERT INTO luc_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","Ị́jọ́ ꞌdĩ sĩ pẽ kí dó ãngũ ꞌbé ꞌa rú sụ́rụ́ Yụ́dã drị̂ agá na ꞌdĩ kí ndú, táwụ̃nị̃ Kãdẹ́sị̃ Gãlị́lị̃ ãngũ ꞌbé ꞌa rú sụ́rụ́ Nãfũtálĩ drị̂ gá rĩ ꞌi, Sẹ̃kẹ́mụ̃ ãngũ ꞌbé ꞌa rú sụ́rụ́ Ịfụrayị́mụ̃ drị̂ gá rĩ ꞌi ãzíla Kị̃rị̃yátị̃ Ãrábã Hẹ̃bụ̃rọ́nị̃ ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","Mĩrĩ Yõrĩdánĩ drị̂ ꞌbã wókõ Yẹ̃rị́kọ̃ drị́ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá, úpẽ táwụ̃nị̃ Bẹ̃zẹ́rị̃ drị̂ ãngũ ásé ꞌa rú sụ́rụ́ Rụ́bẹ̃nị̃ drị̂ agá, táwụ̃nị̃ Rãmọ́tị̃ Gị̃lẹ́dị̃ gá rĩ sụ́rụ́ Gádĩ drị̂ agá ãzíla táwụ̃nị̃ Gõlánĩ drị̂ ãngũ Bãsánĩ drị́ sụ́rụ́ Mãnásẽ drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","ꞌDĩ kí táwụ̃nị̃ ándrá ũpẽlé ꞌbá Ịsịrayị́lị̃ rú ãzíla ꞌbá ãmị́yọ́ŋá ru uꞌálépi kí drĩdríŋĩ gá ꞌbá ꞌdịlépi drị̃lẹ́ ũnzĩ sĩ rĩ ꞌbã kí sĩ apájó ru zị̃jó kí agá rĩ kî. Ị́jọ́ ꞌdĩ sĩ ꞌbá ꞌbá ꞌdịlépi rĩ icó dó sĩ drãlé ꞌbá lẽlépi ãvũ ãrí (gó) ũfẽlépi rĩ drị́ alé gá ku kpere ĩꞌdiní amụ́ agá pá tu agá ꞌbá ũꞌbí kí drị̃lẹ́ gá sĩ ị́jọ́ ĩꞌdidrị̂ amájó. ");
INSERT INTO luc_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","Dã ꞌbã ũngúkú gá ꞌbá ãmbogo rú sụ́rụ́ Lẹ́vị̃ drị̂ agá rĩ amụ́ kí átáló Ị̃lị̃yãzárị̃ ꞌba rụ́ Yósũwã Nụ́nị̃ ngọ́pị be ãzíla drị̃lẹ́ka ínátị drị́ sụ́rụ́ Ịsịrayị́lị̃ drị́ ãzí rĩ kí abe ");
INSERT INTO luc_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","Sị́lọ̃ gá Kãnánĩ gá ꞌdãá ãzíla jọ kí ĩꞌbaní, “Úpí fẽ ándrá ãzị́táŋá Mụ́sã tị gâsĩ ĩfẽ ãmaní táwụ̃nị̃ kí sĩ uꞌájó ãzíla ãngũ andre la gá rĩ ꞌba adru kí ãngũ ãnãkpá ãmadrị̂ ꞌbaní sĩ ĩrí najó rĩ kí trũ.” ");
INSERT INTO luc_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","Ị́jọ́ ꞌdĩ sĩ cécé ándrá Úpí ꞌbã ãzị́táŋá la fẽjó rĩ áni, anzị Ịsịrayị́lị̃ drị̂ fẽ kí dó ꞌbá Lẹ́vị̃ rú rĩ ꞌbaní táwụ̃nị̃ ꞌdĩ kí ãngũ sĩ ãnãkpá ucéjó rĩ kí abe angájó ãngũ ĩꞌbadrị́ ãwítã rú rĩ agá. ");
INSERT INTO luc_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","Jẽgê ꞌbelé drị̃drị̃ rĩ ꞌde Kõhátĩ ní ínátị ĩꞌdidrị̂ kí vú sĩ. Anzị Lẹ́vị̃ drị́ ándrá ãfũlépi Ãrọ́nị̃ átáló ru rĩ rụ́ rĩ ꞌbaní úfẽ táwụ̃nị̃ kí mụdrị́ drị̃ na angájó sụ́rụ́ Yụ́dã, Sị̃mọ́nị̃ ãzíla Bénzãmĩnĩ ꞌbadrị̂ kí agá. ");
INSERT INTO luc_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","Anzị Kõhátĩ drị́ ãzí acelépi rĩ ꞌbaní úfẽ táwụ̃nị̃ kí jẽgê ꞌbeŋá sĩ mụdrị́ angájó sụ́rụ́ Ịfụrayị́mụ̃ drị́, Dánĩ drị́ ãzíla sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ agá. ");
INSERT INTO luc_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","Anzị Gị́rị́sọ̃nị̃ drị̂ ꞌbaní úfẽ táwụ̃nị̃ kí mụdrị́ drị̃ na jẽgê ꞌbeŋá sĩ angájó sụ́rụ́ Ĩsãkárĩ drị́, Ásẹ̃rị̃ drị́, Nãfũtálĩ drị́ ãzíla sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ agá Bãsánĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","Anzị Mẽrárĩ drị̂ ꞌbaní úfẽ táwụ̃nị̃ kí mụdrị́ drị̃ ị̃rị̃ angájó sụ́rụ́ Rụ́bẹ̃nị̃ drị́, Gádĩ drị́ ãzíla sụ́rụ́ Zãbụ̃lọ́nị̃ drị̂ kí agá. ");
INSERT INTO luc_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","Ị́jọ́ ꞌdĩ sĩ táwụ̃nị̃ ꞌdĩ kí ãngũ ĩrí trũ rĩ abe ꞌbá Ịsịrayị́lị̃ drị̂ fẽ kí dó kí ꞌbá Lẹ́vị̃ drị̂ ꞌbaní jẽgê ꞌbeŋá sĩ cécé Úpí ꞌbã ãzị́táŋá la fẽjó Mụ́sã ní rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","Angájó sụ́rụ́ Yụ́dã drị́ ãzíla sụ́rụ́ Sị̃mọ́nị̃ drị̂ kí agá úfẽ táwụ̃nị̃ rụ́ la kí ũsĩ jó ꞌdĩ kî, ");
INSERT INTO luc_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","(táwụ̃nị̃ ꞌdĩ kí úfẽ kí anzị Ãrọ́nị̃ drị́ angálépi ínátị Kõhátĩ drị̂ gá ꞌbá Lẹ́vị̃ rú rĩ ꞌbaní ãꞌdusĩku jẽgê drị̃drị̃ rĩ ꞌde ĩꞌbanî.) ");
INSERT INTO luc_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","Fẽ kí dó ĩꞌbaní Kị̃rị̃yátị̃ Ãrị́bã (ꞌdĩ Hẹ̃bụ̃rọ́nị̃ ꞌi) ãngũ ĩꞌdi andre celépi ĩrí trũ ꞌbé ꞌa rú Yụ́dã drị̂ trũ. (Ãrị́bã ĩꞌdi áyị́pị ꞌbá Ãnákĩ rú rĩ ꞌbadrị̂ ꞌi.) ");
INSERT INTO luc_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","Wó ámvụ́ táwụ̃nị̃ ꞌdã andre gá rĩ kí tọ̃rọ́mẹ́ la kí abe úfẽ kí Kãlẹ́bụ̃ Yẹ̃fụ́nẹ̃ ꞌbã ngọ́pị ní ĩꞌdi ꞌbã ãko rú. ");
INSERT INTO luc_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","Anzị átáló Ãrọ́nị̃ drị̂ ꞌbaní úfẽ táwụ̃nị̃ Hẹ̃bụ̃rọ́nị̃ drị̂ ꞌi, ꞌdĩ táwụ̃nị̃ ꞌbá ꞌbá dịlépi drị̃lẹ́ ũnzĩ sĩ rĩ ꞌbã kí sĩ apájó sĩ ru zị̃jó rĩ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, táwụ̃nị̃ Líbĩnã drị̂ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","Yátĩrĩ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Ĩsĩtẽmówã ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","Họ̃lọ́nị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Dẹ̃bị́rị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","Ãyị́nị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Yụ́tã ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Bẹ̃tị̃ Sẹ̃mẹ́sị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe táwụ̃nị̃ úrômĩ angájó sụ́rụ́ ị̃rị̃ ꞌdĩ kí agá. ");
INSERT INTO luc_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","Angájó sụ́rụ́ Bénzãmĩnĩ drị̂ agá, táwụ̃nị̃ Gị̃bẹ̃yọ́nị̃ drị̂ kí Gébã drị̂ be ãngũ ĩꞌbadrị́ ĩrí trũ rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","Ãnãtọ́tị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ãzíla Ãlị̃mọ́nị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, kí pírí táwụ̃nị̃ sụ. ");
INSERT INTO luc_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","Anzị átáló Ãrọ́nị̃ drị̂ ꞌbaní úfẽ táwụ̃nị̃ kí mụdrị́ drị̃ na ãngũ kí andre celépi ĩrí trũ rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","ꞌBá ínátị Kõhátĩ drị̂ gá acelépi sụ́rụ́ Lẹ́vị̃ drị̂ agá rĩ ꞌbaní úfẽ táwụ̃nị̃ kí angájó sụ́rụ́ Ịfụrayị́mụ̃ drị̂ gá jẽgê ꞌbeŋá sĩ. ");
INSERT INTO luc_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","Úfẽ ĩꞌbaní táwụ̃nị̃ Sẹ̃kẹ́mụ̃ ꞌi ãngũ Ịfụrayị́mụ̃ drị́ ꞌbé agá rĩ gá, ꞌdĩ táwụ̃nị̃ ꞌbá ꞌbá ꞌdịlépi drị̃lẹ́ ũnzĩ sĩ rĩ ꞌbaní sĩ apájó ru zị̃jó rĩ ꞌi ãzíla táwụ̃nị̃ Gẹ̃zẹ́rị̃ drị̂ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","Kĩbĩzãyímũ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Bẹ̃tị̃ Họ̃rọ́nị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, kí pírí táwụ̃nị̃ sụ, ");
INSERT INTO luc_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","ãzíla sụ́rụ́ Dánĩ drị̂ agá úfẽ ĩꞌbaní táwụ̃nị̃ Ị̃lị̃tẹ́kẹ̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Gị̃bẹ̃tọ́nị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","Ãyị̃yãlọ́nị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Gãtị̃ Rị̃mọ́nị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, kí pírí táwụ̃nị̃ sụ. ");
INSERT INTO luc_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","Sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ agá ịsụ́ kí táwụ̃nị̃ Tãnákĩ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Gãtị̃ Rị̃mọ́nị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, kí pírí táwụ̃nị̃ ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","Táwụ̃nị̃ mụdrị́ ꞌdĩ kí pírí úfẽ ándrá kí ínátị ꞌbá Kõhátĩ drị̂ ꞌbã ị́mbị́ acelépi rĩ ꞌbaní ãngũ ĩꞌbadrị́ ĩrí trũ rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","Úfẽ anzị Gị́rị́sọ̃nị̃ drị́ sụ́rụ́ Lẹ́vị̃ drị̂ agá rĩ ꞌbaní: Gõlánĩ Bãsánĩ gá rĩ ꞌi angájó táwụ̃nị̃ sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ drị̂ agá rĩ gá ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ꞌdĩ táwụ̃nị̃ ꞌbá ꞌbá ꞌdịlépi drị̃lẹ́ ũnzĩ sĩ rĩ ꞌbã sĩ apájó ru zị̃jó ala gá rĩ ꞌi ãzíla táwụ̃nị̃ Bẹ̃sị̃tẹ́rã drị̂ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, táwụ̃nị̃ ꞌdĩ kí pírí rĩ gá ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","Angájó sụ́rụ́ Ĩsãkárĩ drị̂ agá, úfẽ táwụ̃nị̃ Kísõnĩ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Dãbẽrátĩ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","Yãrị̃mụ́tị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Ĩnĩ-gãnímũ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, kí pírí rĩ gá táwụ̃nị̃ sụ. ");
INSERT INTO luc_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","Angájó sụ́rụ́ Ásẹ̃rị̃ drị̂ agá, úfẽ táwụ̃nị̃ Mĩsálĩ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Ãbãdónĩ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","Hẽlĩkátĩ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe ãzíla Rẹ̃họ́bụ̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, kí pírí rĩ gá táwụ̃nị̃ sụ. ");
INSERT INTO luc_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","Angájó sụ́rụ́ Nãfũtálĩ drị̂ gá, úfẽ táwụ̃nị̃ Kẹ̃dẹ́sị̃ Gãlị́lị̃ gá rĩ ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ꞌdĩ táwụ̃nị̃ ꞌbá ꞌbá ꞌdịlépi drị̃lẹ́ ũnzĩ sĩ rĩ ꞌbã sĩ apájó ru zị̃jó ala gá rĩ ꞌi, Hãmọ́tị̃ Dọ́rị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe ãzíla Kãrĩtánĩ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ꞌdĩ kí pírí rĩ gá táwụ̃nị̃ na. ");
INSERT INTO luc_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","Táwụ̃nị̃ fẽlé anzị Gị́rị́sọ̃nị̃ drị̂ ꞌbaní rĩ kí ándrá pírí rĩ gá mụdrị́ drị̃ na ãngũ ĩꞌbadrị́ ĩrí trũ rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","Anzị ínátị Mẽrárĩ drị́ acelépi sụ́rụ́ Lẹ́vị̃ drị̂ agá rĩ ꞌbaní úfẽ angájó sụ́rụ́ Zãbụ̃lọ́nị̃ drị̂ agá, táwụ̃nị̃ Yõkĩnẽyámũ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Kãrítã ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","Dímĩnã ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Nãhãlálĩ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, kí pírí rĩ gá táwụ̃nị̃ sụ. ");
INSERT INTO luc_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","Angájó sụ́rụ́ Rụ́bẹ̃nị̃ drị̂ gá úfẽ ĩꞌbaní táwụ̃nị̃ Bẹ̃zẹ́rị̃ drị̂ ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, Yãházị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","Kẹ̃dẹ̃mọ́tị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe ãzíla Mẽfátĩ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe kí pírí rĩ gá táwụ̃nị̃ sụ. ");
INSERT INTO luc_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","Angájó Sụ́rụ́ Gádĩ drị̂ agá úfẽ ĩꞌbaní táwụ̃nị̃ Rãmọ́tị̃ Gị̃lẹ́dị̃ gá rĩ, ꞌdĩ táwụ̃nị̃ ꞌbá ꞌbá ꞌdịlépi drị̃lẹ́ ũnzĩ sĩ rĩ ꞌbã kí sĩ apájó ru zịjó ala gá rĩ, Mãhãnãyị́mụ̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, ");
INSERT INTO luc_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","Hẹ́sị̃bọ̃nị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe ãzíla Yãzẹ́rị̃ ꞌi ãngũ ĩꞌdidrị́ ĩrí trũ rĩ kí abe, kí pírí rĩ gá táwụ̃nị̃ sụ. ");
INSERT INTO luc_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","Ị́jọ́ ꞌdĩ sĩ táwụ̃nị̃ fẽlé ínátị Mẽrárĩ drị̂ ꞌbaní ꞌbá Lẹ́vị̃ drị́ acelépi rĩ kí agá rĩ kí pírí rĩ gá táwụ̃nị̃ mụdrị́ drị̃ ị̃rị̃. ");
INSERT INTO luc_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","Kãlãfe táwụ̃nị̃ ãngũ la ala gá ĩrí trũ rĩ abe fẽlé ꞌbá Lẹ́vị̃ drị̂ ꞌbaní ãngũ Ịsịrayị́lị̃ drị̂ agá rĩ kí ándrá pírí rĩ gá kãlị́ sụ drị̃ ãrõ. ");
INSERT INTO luc_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","Táwụ̃nị̃ ꞌdĩ kí ꞌbã ãlu-ãlu ándrá ãngũ ĩꞌbadrị́ ĩrí trũ kí andre celépi rĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","Ị́jọ́ ꞌdĩ sĩ Úpí fẽ dó sĩ Ịsịrayị́lị̃ ní ãngũ pírí ándrá ĩꞌdi ꞌbã ũyõ la najó ꞌi mụ fẽlé la ĩꞌbã áyị́pịka ꞌbaní rĩ kí rá. ꞌDụ kí dó sĩ ãngũ ꞌdã ĩꞌbã ãni la rú rá, ri kí dó sĩ ala gá. ");
INSERT INTO luc_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","Úpí fẽ dó ĩꞌbaní ásị́ ị̃gbẹ̃ wókõ pírí kí agâsĩ cécé ĩꞌdi ꞌbã ándrá ũyõ la najó ĩꞌbã áyị́pịka ꞌbaní rĩ áni. Mẹ́rọ́ꞌbá ãzí ándrá pá tulépi sĩ kí ndẽjó rá la ꞌdá yụ, ãꞌdusĩku Úpí ꞌbã ándrá mẹ́rọ́ꞌbá ĩꞌbadrị̂ kí fẽjó pírí kí drị́ alé gá rá rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","Ị́jọ́ ãzí ãlu múké Úpí ꞌbã azịlé ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ru idélépi ku la ꞌdáyụ; ị́jọ́ pírí nga kí ru jọlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","ꞌDã ꞌbã ũngúkú gá, Yósũwã umve dó sụ́rụ́ Rụ́bẹ̃nị̃ drị̂ ꞌi, Gádĩ drị̂ ꞌi ãzíla sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ ꞌi ");
INSERT INTO luc_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","ãzíla jọ ĩꞌbaní, “Ĩmi idé dó ị́jọ́ pírí ãtíꞌbó Úpí drị́ Mụ́sã ꞌbã ándrá ãzị́táŋá la kí fẽjó ĩminí rĩ kí ꞌbo, ãzíla ĩmba vâ ị́jọ́ mání azịlé ĩminí rĩ kí tã pírí rá. ");
INSERT INTO luc_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","Ụ́ꞌdụ́ alịlépi wẽwẽ rú ꞌdĩ kí agá, ĩgã drĩ ĩmĩ ádrị́pịka Ịsịrayị́lị̃ rú rĩ kí tị gẹ̃rị̃ sĩ ku, wó ĩmba vâ ãzị́táŋá pírí Úpí Ãdróŋá ĩmidrị̂ ꞌbã fẽlé ĩminí rĩ kí tã kpere ãndrũ rá. ");
INSERT INTO luc_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","Úꞌdîꞌda Úpí Ãdróŋá fẽ dó ĩꞌbaní ásị́ ị̃gbẹ̃ ꞌbo cécé ándrá ĩꞌdi ꞌbã ị́jọ́ la azịjó rĩ áni, ị́jọ́ ꞌdĩ sĩ lẽ ĩgõ dó ĩmidrị́ lị́cọ́ kí agâlé, ꞌdĩ ãngũ ãtíꞌbó Úpí drị́ Mụ́sã ꞌbã fẽlé ĩminí mĩrĩ Yõrĩdánĩ ꞌbã ꞌá ꞌdã sĩ rĩ kí agá. ");
INSERT INTO luc_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","Wó lẽ ĩmi adru mịfị́ trũ sĩ ị́jọ́ azịlé ãzíla ãzị́táŋá ãtíꞌbó Úpí drị́ Mụ́sã ꞌbã fẽlé ĩminí rĩ kí tãmbajó, sĩ Úpí Ãdróŋá ĩmidrị̂ lẽjó, acị́jó gẹ̃rị̃ ĩꞌdidrị̂ kí agá pírí, sĩ ãzị́táŋá ĩꞌdidrị̂ kí tãmbajó, ru ĩbĩjó ĩꞌdi rụ́ ãzíla sĩ ãzị́ ngajó ĩꞌdiní ĩmi ásí pírí sĩ ãzíla ĩmi ídri pírí sĩ.” ");
INSERT INTO luc_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","ꞌDã ꞌbã ũngúkú gá, Yósũwã wi dó ĩꞌbaní sụ̃sụ́, pẽ dó sĩ kí tị sĩ mụjó rá, ãzíla mụ kí dó sĩ ĩꞌbadrị́ lị́cọ́ kí agâlé. ");
INSERT INTO luc_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","Sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ ꞌbaní Mụ́sã fẽ ándrá ãngũ Bãsánĩ gá, wó nụ́sụ̃ la ãzí rĩ ní Yósũwã fẽ ándrá ãngũ mĩrĩ Yõrĩdánĩ ꞌbã wókõ ĩtụ̂ ꞌbã ꞌde agâlé ru rĩ gá. Yósũwã ꞌbã kí tị pẽ agâ mụ agâ lị́cọ́ gá ꞌdĩ gá ꞌdâ, wi dó vâ ĩꞌbaní sụ̃sụ́ ĩndĩ, ");
INSERT INTO luc_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","jọ, “Ĩgõ ĩmidrị́ lị́cọ́ kí agâlé ãnãkpá trũ, sílĩvã, gólũdĩ, bũrônzĩ, aya ãzíla bõngó kí abe ũꞌbí ru, ĩmi awa ãko ĩminí upalé mẹ́rọ́ꞌbá ĩmidrị̂ ꞌbadrị́ rĩ kí ĩmĩ ádrị́pịka kí trũ.” ");
INSERT INTO luc_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","Ị́jọ́ ꞌdĩ sĩ ꞌbá Rụ́bẹ̃nị̃ drị̂ kí, ꞌbá Gádĩ drị̂ kí abe ãzíla sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ trũ aꞌbe kí dó ꞌbá Ịsịrayị́lị̃ drị̂ kí Sị́lọ̃ gá Kãnánĩ gâlé, gõ kí dó sĩ vúlé ãngũ ĩꞌbadrị́ mgbã Gị̃lẹ́dị̃ gá, ꞌdĩ ãngũ ándrá ĩꞌbaní ịsụ́lé ãzị́táŋá Úpí ꞌbã fẽlé Mụ́sã rụ̂ sĩ rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","Kí dó mụ acálé Gẹ̃lị̃lọ́tị̃ gá ãnirú mĩrĩ Yõrĩdánĩ gá Kãnánĩ gá ꞌdãá ꞌbo, ꞌbá Rụ́bẹ̃nị̃ drị̂ kí ꞌbá Gádĩ drị̂ trũ ãzíla sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ abe sị kí dó ãlĩtárĩ ãzí ãmbógó la mĩrĩ Yõrĩdánĩ ꞌbã tị gá ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","ꞌBá Ịsịrayị́lị̃ drị̂ ꞌbã ãzí rĩ kí dó mụ arelé la sụ́rụ́ Rụ́bẹ̃nị̃ drị́, Gádĩ drị́ ãzíla sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ sị kí dó ãlĩtárĩ ãzí lõkókõrí Kãnánĩ drị̂ gá Gẹ̃lị̃lọ́tị̃ gá ꞌdãá ãni rú mĩrĩ Yõrĩdánĩ ꞌbã tị gá wókõ Ịsịrayị́lị̃ drị̂ gâlé ru íni, ");
INSERT INTO luc_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","ꞌbá Ịsịrayị́lị̃ drị̂ tra kí dó ru Sị́lọ̃ gá sĩ mụjó ãꞌdị́ gá ĩꞌba rụ̂lé. ");
INSERT INTO luc_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","Ị́jọ́ ꞌdĩ sĩ ꞌbá Ịsịrayị́lị̃ drị̂ pẽ kí dó Fĩnẽhásĩ átáló Ị̃lị̃yãzárị̃ ꞌbã ngọ́pị tị Gị̃lẹ́dị̃ gá sĩ mụjó ị́jọ́ jọjó sụ́rụ́ Rụ́bẹ̃nị̃ drị́, Gádĩ drị́ ãzíla sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ abe. ");
INSERT INTO luc_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","Úpẽ dó drị̃lẹ́ kí mụdrị́ angájó sụ́rụ́ Ịsịrayị́lị̃ drị̂ kí agá mụlé Fĩnẽhásĩ be drị̃lẹ́ ãlu-ãlu angájó lị́cọ́ ínátị Ịsịrayị́lị̃ drị̂ kí agá. ");
INSERT INTO luc_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","Kí mụ mụlé Gị̃lẹ́dị̃ gá Sụ́rụ́ Rụ́bẹ̃nị̃ drị́, Gádĩ drị́ ãzíla sụ́rụ́ Mãnásẽ drị̂ ꞌbã nụ́sụ̃ ꞌba rụ́ ꞌbo jọ kí ĩꞌbaní, ");
INSERT INTO luc_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“ꞌBá ũꞌbí Úpí drị́ ru tralépi rĩ jọ kí: Ĩmi icó dó ị́jọ́ ũnzíkãnã ꞌdĩ ꞌbã áni rĩ idélé Ãdróŋá Ịsịrayị́lị̃ drị̂ rụ́ ãꞌdu ị́jọ́ sĩ? Ĩmvu dó úꞌdîꞌda Úpí rụ́ ꞌdâ rá ĩminí ãlĩtárĩ sịjó ĩminí rĩ sĩ. Ĩmi ũbĩ dó úꞌdîꞌda ị́jọ́ ĩꞌdidrị̂ kí vú ku. ");
INSERT INTO luc_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","Ị́jọ́ ũnzí ándrá Pẹ̃yọ́rị̃ gá rĩ ca drĩ ãmaní ku yã? Kpere ãndrũ ãma ũjĩ kí drĩ ãma ãlá ru ị́jọ́ ũnzí ãmadrị̂ kí sĩ ku, átã jụ́wẹ̃ ꞌbã táni aꞌdé agâ ũꞌbí Úpí drị̂ kí drĩ gá rá tí! ");
INSERT INTO luc_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","Ĩlẽ úꞌdîꞌda mvulé Úpí rụ́ ꞌdâ rĩ sĩ ãmvé yã? Ĩdrĩ ãndrũ rĩ gá mvu ĩꞌdi rụ́ ꞌdâ rĩ sĩ rá, drụ̃sị̃ ĩꞌdi mụ adrulé ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní pírí ũmbã sĩ. ");
INSERT INTO luc_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","Ãngũ ĩmidrị̂ drĩ adru ũnzí, ĩmi alị ãngũ Úpí drị̂ gá, ꞌdĩ ãngũ Hémã sĩ Úpí ị̃nzị̃jó rĩ ꞌbã adrujó ala gá rĩ gá, ãzíla ĩmi dó sĩ ãngũ ãzí ꞌdụ ĩmĩni la rú ãma drĩdríŋĩ gá ꞌdâ. Wó lẽ ĩmvu Úpí rụ́ rĩ sĩ rá jõku ãma rú rĩ sĩ rá, ĩminí sĩ ãlĩtárĩ ãzí sịjó ãlĩtárĩ Úpí Ãdróŋá ãmadrị̂ drị̃ gá la ku. ");
INSERT INTO luc_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","Zérã ngọ́pị Ãkánĩ la dó mụ ãko ꞌbãlé ndú Ãdróŋá ní rĩ kí ụ̃gụ̃lé ꞌbo, ũmbã Ãdróŋá drị̂ aꞌdé ándrá ꞌbá Ịsịrayị́lị̃ drị̂ kí drĩ gá pírí ku yã? Adru ándrá ꞌbá drãlépi ị́jọ́ ũnzí ĩꞌdidrị̂ sĩ áꞌdụ̂sĩ rĩ ꞌi ku.” ");
INSERT INTO luc_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","ꞌDã ꞌbã ũngúkú gá, sụ́rụ́ Rụ́bẹ̃nị̃ drị́, Gádĩ drị́ ãzíla Mãnásẽ drị̂ ꞌbã nụ́sụ̃ abe umvi kí dó ꞌbá drị̃lẹ́ ru ínátị Ịsịrayị́lị̃ drị̂ agá rĩ ꞌbaní, ");
INSERT INTO luc_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“Úpí Ãdróŋá ĩꞌdi Ũkpó ꞌdị́pị ꞌi! Úpí Ãdróŋá ĩꞌdi Ũkpó ꞌdị́pị ꞌi! Nị̃ ị́jọ́ pịrị rĩ rá rĩ gá nĩ ãzíla ãlẽ Ịsịrayị́lị̃ ꞌbã nị̃ vâ ị́jọ́ ꞌdĩ ĩndĩ! Drĩ adru ãmvu nõ Úpí rụ́ rĩ sĩ ãmvé jõku ãma are nõ Úpí tị ku yã áni, ĩmi ị̃lị̃kị̃ ãma ãndrũ rá. ");
INSERT INTO luc_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","Ãdrĩ ãlĩtárĩ sị sĩ mvujó Úpí rụ́ ꞌdâ rĩ sĩ ãmvé jõku sĩ ãmaní ídétáŋá ivélé ivê, ídétáŋá ãnáfóró sĩ rĩ jõku ídétáŋá ásị́ ị̃gbẹ́ drị̂ kí idéjó ãmaní yã áni, lẽ Úpí ꞌbã fẽ ãmaní drị̃rịma rá. ");
INSERT INTO luc_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","Ị́jọ́ mgbã sĩ rĩ gá ãsị ãlĩtárĩ ꞌdĩ íni la ụ̃rị̃ drụ́zị́ anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí drụ́zị́ amụ́ anzị ãma drị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí zịlé, ‘Ĩmĩ ị́jọ́ ãzí Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ be la cí yã? ");
INSERT INTO luc_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","Wó Ãdróŋá ꞌbã lõkókõrí ãma drĩdríŋĩ gá ĩmi abe rĩ ị̃yị́ Yõrĩdánĩ sĩ ꞌbo, ĩmi sụ́rụ́ Rụ́bẹ̃nị̃ drị́ ãzíla Gádĩ drị́ ꞌdĩ. Ĩmĩ hákĩ ãzí sĩ Úpí ị̃nzị̃jó la ꞌdáyụ.’ Ị́jọ́ ꞌdĩ sĩ anzị ĩmidrị̂ kí drụ́zị́ anzị ãmadrị̂ ꞌbaní Úpí ní ãrútáŋá fẽjó rĩ atrị rá. ");
INSERT INTO luc_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","“Ị́jọ́ ꞌdĩ sĩ ãjọ, ‘Lẽ ãsị ãlĩtárĩ adru sĩ ídétáŋá ivélé ivê rĩ kí ivéjó jõku sĩ ídétáŋá idéjó la ku, ");
INSERT INTO luc_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","wó ĩꞌdi adru sãdínĩ rú ãma drĩdríŋĩ gá ĩmi abe, ãzíla anzị ãmadrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí abe, ãma dó sĩ Úpí ị̃nzị̃ ãngũ ĩꞌdidrị́ ãlá rĩ gá sĩ ĩꞌdiní ídétáŋá ivélé ivê rĩ kí ivé, ídétáŋá idélé idê rĩ ãzíla ídétáŋá ásị́ ị̃gbẹ́ drị̂ fẽ. Ị́jọ́ ꞌdĩ sĩ anzị ĩmidrị́ mụlé tịlé drị̃lẹ́ gâlé rĩ icó kí dó sĩ drụ́zị́ anzị ãma drị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí atrịlé Úpí ní ãrútáŋá fẽjó ku.’ ");
INSERT INTO luc_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","“Ị́jọ́ ꞌdĩ sĩ ãjọ dó sĩ, ‘Drụ́zị́ drĩ kí dó sĩ ãma tị zị jõku anzị ãma drị́ mụlé tịlé drị̃lẹ́ gâlé rĩ kí tị zị rá, ãma dó sĩ umvi la ĩꞌbaní ĩndre drĩ ãlĩtárĩ Úpí drị́ ꞌdĩ ꞌbã gbíyã, ándrá ãmã áyị́pịka ꞌbã kí sịlé rĩ ꞌi adru sĩ ídétáŋá ivélé ivê ãzíla ídétáŋá idéjó la ku. Wó ĩꞌdi ãma drĩdríŋĩ gá ĩmi abe sãdínĩ rú.’ ");
INSERT INTO luc_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","“Ãma icó mvulé Úpí ụrụꞌbá gá rĩ sĩ rá jõku ãmaní sĩ ĩꞌdiní ũngúkú ujajó sĩ ãlĩtárĩ ãzí sịjó sĩ ídétáŋá ivélé ivê, ídétáŋá ãnáfóró sĩ jõku ídétáŋá ásị́ ị̃gbẹ̃ drị̂ idéjó ãma vúŋá nî la ku. Wó ãma lú ãlĩtárĩ sị rá la Úpí Ãdróŋá ãmadrị́ pá tulépi Hémã sĩ ĩꞌdi ị̃nzị̃jó rĩ drị̃lẹ́ gá rĩ nî.” ");
INSERT INTO luc_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","Átáló Fĩnẽhásĩ, drị̃lẹ́ka ũꞌbí ꞌbadrị̂ kí ãzíla drị̃lẹ́ ínátị sụ́rụ́ Ịsịrayị́lị̃ ꞌbadrị̂ kí mụ ị́jọ́ ꞌbá Rụ́bẹ̃nị̃ drị́, Gádĩ drị́ ãzíla Mãnásẽ drị̂ ꞌbã kí jọlé rĩ kí arelé ꞌbo, uꞌá kí dó ãyĩkõ sĩ ị́jọ́ jọlé ĩꞌbaní rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","Átáló Fĩnẽhásĩ Ị̃lị̃yãzárị̃ ngọ́pị jọ ꞌbá Rụ́bẹ̃nị̃ drị́, Gádĩ drị́ ãzíla ꞌbá Mãnásẽ drị̂ ꞌbaní, “Ãndrũ ãnị̃ dó rá Úpí ĩꞌdi ãma be cí, ãꞌdusĩku ĩmi idé ị́jọ́ ũnzí ãzí Úpí rụ́ ku. Úꞌdîꞌda ĩpa dó anzị Ịsịrayị́lị̃ drị̂ kí drị̃rịma Úpí ní tá fẽlé ĩꞌbaní rĩ agá ꞌbo.” ");
INSERT INTO luc_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","ꞌDã ꞌbã ũngúkú gá, átáló Fĩnẽhásĩ Ị̃lị̃yãzárị̃ ngọ́pị ãzíla ꞌbá drị̃lẹ́ ru rĩ abe gõ kí dó Kãnánĩ gâlé ĩꞌbã kí angájó ị́jọ́ jọjọ́ ꞌbá Rụ́bẹ̃nị̃ drị́ ãzíla ꞌbá Gádĩ drị̂ abe Gị̃lẹ́dị̃ gâlé rĩ sĩ ãzíla nze kí dó ị́jọ́ ꞌdĩ kí vú ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","ꞌBá Ịsịrayị́lị̃ drị̂ uꞌá kí dó ãyĩkõ sĩ ị́jọ́ vú nzelé ĩꞌbaní rĩ sĩ ãzíla ịcụ́ kí dó sĩ Ãdróŋá ꞌi. Jọ kí dó sĩ ị́jọ́ sĩ mụjó ãꞌdị́ gá ꞌbá Rụ́bẹ̃nị̃ drị́ ãzíla Gádĩ drị̂ ꞌbarụ́ sĩ kí izajó la ku. ");
INSERT INTO luc_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","ꞌBá Rụ́bẹ̃nị̃ drị̂ kí Gádĩ drị̂ kí abe ꞌda kí dó sĩ ãlĩtárĩ ꞌdĩ rụ́ Sãdínĩ ꞌi, “Ãꞌdusĩku jọ kí ĩꞌdi sãdínĩ ãma drĩdríŋĩ gá ĩmi abe icélépi la Úpí ĩꞌdi Ãdróŋá ꞌi rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","Ụ́ꞌdụ́ ãzo ꞌbã vúlé gá, Úpí fẽ dó ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ásị́ ị̃gbẹ̃ mẹ́rọ́ꞌbá ĩꞌbadrị́ kí andre gá rĩ ꞌbadrị́ rá, ꞌdĩ sĩ Yósũwã dó ĩdránígó ru ílí trũ wẽwẽ rú. ");
INSERT INTO luc_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","Yósũwã umve dó ꞌbá Ịsịrayị́lị̃ drị̂ kí, ꞌbá ĩyõ ãzíla drị̃lẹ́ ru rĩ kí, ꞌbá ị́jọ́ lịlẹ́pi rĩ kí ãmbogo kí abe pírí ĩꞌdi rụ́ ꞌdõlé. Jọ dó ĩꞌbaní, “Ma dó úꞌdîꞌda íni ĩdránígó ru ílí trũ wẽwẽ rú. ");
INSERT INTO luc_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Wó ĩndre ị́jọ́ pírí Úpí Ãdróŋá ĩmidrị̂ ꞌbã idélé sụ́rụ́ pírí ꞌdĩ ꞌba rú ĩmi ị́jọ́ sĩ ꞌdĩ kí rá, ãꞌdusĩku Úpí Ãdróŋá ĩmidrị̂ ꞌdị ãꞌdị́ ĩminí nĩ. ");
INSERT INTO luc_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Ĩndre má awa ĩminí ãngũ sụ́rụ́ mání ndẽlé rá ãzíla mání drĩ ndẽlé ku rĩ ꞌbadrị̂ kí ĩminí ãwítã rú angájó Yõrĩdánĩ gá cajó mĩrĩ Mẽdĩtãrénĩyãnĩ ꞌbã wókõ ị̃tụ̂ ꞌbã ꞌde agâlé ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Úpí Ãdróŋá ĩmidrị̂ la mụ kí drolé gẹ̃rị̃ ĩmidrị̂ agá ꞌdâ rá ãzíla ĩꞌdĩ kí ĩdã ĩmi drị̃lẹ́ gá ꞌdâ rá. Imi dó sĩ ãngũ ĩꞌbadrị̂ ꞌdụ ĩminí la rú, cécé Úpí Ãdróŋá ĩmidrị̂ ꞌbã azịlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","“Ị́jọ́ ꞌdĩ sĩ, ĩmi ásị́ ꞌbã adru jõ ũkpómgboroto rú, ĩmi adru jõ mịfị́ trũ sĩ ị́jọ́ pírí sị̃lé Bụ́kụ̃ Ãzị́táŋá Mụ́sã drị̂ agá rĩ kí vú ũbĩjó, ĩmi uja ĩmi bụ́lụ́ gá drị́ ị̃jị́ gá jõku drị́ ãndá gá ku. ");
INSERT INTO luc_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Ĩmi icí jõ ĩmi sụ́rụ́ acelépi ĩmi drĩdríŋĩ gá ꞌdĩ kí abe ku, ĩmi umve ãdroŋa ĩꞌbadrị̂ kí rụ́ ku jõku ĩna ũyõ kî sĩ ku. Ĩmi ị̃nzị̃ jõ kí ku jõku ĩmi ãvũ jõ kí drị̃lẹ́ gá ku. ");
INSERT INTO luc_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Wó lẽ ĩmi ĩbĩ ĩmi Úpí Ãdróŋá ĩmidrị̂ rụ́ cécé ĩminí ĩmi ĩbĩjó kpere ãndrũ ꞌdĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","“Úpí adro ĩmi drị̃lẹ́ gá sụ́rụ́ ãmbogo ãmbogo ũkpó trũ ꞌdĩ kí rá, kpere úꞌdîꞌda ꞌbá ãzí pá tụlépi ĩmi drị̃lẹ́ gá la ꞌdá yụ. ");
INSERT INTO luc_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","ꞌBá ãlu la mụ ãꞌdị́ ꞌdịlé ꞌbá álĩfũ ãlu abe nĩ ãꞌdusĩku Úpí Ãdróŋá ĩmidrị̂ la ãꞌdị́ ꞌdị ĩminí nĩ cécé ĩꞌdi ꞌbã ándrá azịlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Ị́jọ́ ꞌdĩ sĩ ĩmi adru jõ mịfị́ trũ sĩ Úpí Ãdróŋá ĩmidrị̂ lẽjó. ");
INSERT INTO luc_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","“Wó ĩdrĩ ĩmi ja bụ́lụ́ gá sĩ sụ́rụ́ aꞌbelé ídri ĩmi drĩdríŋĩ gá ꞌdĩ kí abe ru ĩgbãjó ãzíla ru icíjó ĩꞌba abe rá, ");
INSERT INTO luc_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","ꞌdã ꞌbã ũngúkú ĩmi dó nị̃ la rá Úpí Ãdróŋá ĩmidrị̂ icó dó sụ́rụ́ ꞌdĩ kí drolé ĩmi drị̃lẹ́ gá ꞌdâ rá rĩ gá ku. Wó kí dó acá ímbá sĩ ĩmi rụjó rĩ rú, kẹ̃lị́ká sĩ ĩmi ugoró cojó rĩ rú, ụ̃cị́kị́ sĩ ĩmi mịfị́ kí ũsõjó rĩ rú, kpere ĩminí ị̃lị̃kị̃ agá ãngũ múké Úpí Ãdróŋá ĩmidrị̂ ꞌbã fẽlé ĩminí ꞌdĩ gá ꞌdâ. ");
INSERT INTO luc_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“Ĩndre ma dó ãnirú mụ drãlé drã-drã, ĩnị̃ pírí ĩmi ásị́ gá ãzíla ĩmi ídri gá rá ị́jọ́ múké Úpí Ãdróŋá ĩmidrị̂ ꞌbã azịlé ĩminí rĩ kí ꞌbã ãzí ãlu ĩcẽlépi ĩminí rá la ꞌdá yụ. Ị́jọ́ pírí azịlé ĩminí ꞌdĩ idé kí ru rá ãzí ãlu ĩcẽlépi ĩminí rá la ꞌdá yụ. ");
INSERT INTO luc_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","“Wó cécé Úpí Ãdróŋá ĩmidrị̂ ꞌbã ị́jọ́ pírí múké ĩꞌdi ꞌbã azịlé ĩminí rĩ kí fẽjó rĩ áni, ĩdrĩ ĩꞌdi tị are ku ĩꞌdi lị́kị̃ ají ĩmi drị̃ gá. Ĩꞌdi ĩmi ị̃lị̃kị̃ pírí ãngũ ãlá ĩꞌdi ꞌbã fẽlé ĩminí ꞌdĩ agá ꞌdâ rá. ");
INSERT INTO luc_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Ĩdrĩ tị icíma Úpí Ãdróŋá ĩmidrị́ gá rĩ drị̂ iza rá sĩ ãdroŋa ãzí ĩnzõ rú ꞌdĩ kí ị̃nzị̃jó ãzíla sĩ ãvụ̃jó kí drị̃lẹ́ gá, ị́jọ́ ꞌdĩ sĩ ũmbã Úpí drị̂ la dó ve ĩmi ụrụꞌbá gá kpere ĩminí ị̃lị̃kị̃ agá ãngũ múké ĩꞌdi ꞌbã fẽlé ĩminí ꞌdĩ gá ꞌdâ.” ");
INSERT INTO luc_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","ꞌDã ꞌbã ũngúkú gá, Yósũwã tra dó sụ́rụ́ Ịsịrayị́lị̃ drị̂ kí pírí Sẹ̃kẹ́mụ̃ gá ãzíla umve dó ꞌbá ĩyõ, ꞌbá drị̃lẹ́ ru, ꞌbá ị́jọ́ lịlẹ́pi, ãzíla ꞌbá ãmbogo rú Ịsịrayị́lị̃ drị̂ kí trũ sĩ kí iꞌdajó Ãdróŋá drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Yósũwã jọ ꞌbá pírí ꞌbaní, “ꞌDĩ ị́jọ́ Úpí Ãdróŋá Ịsịrayị́lị̃ drị̂ ꞌbã jọlé rĩ: Ándrá ídu ĩmĩ áyị́pịka ri kí uꞌálé Mĩrĩ Ũfũrátĩ ꞌbã ꞌá ꞌdã sĩ ãzíla ri kí ãdroŋa ãzí ndú la kí ị̃nzị̃lé. Térã Ịbụrahị́mụ̃ kí ꞌbã átẹ́pị Nãhọ́rị̃ be rĩ ĩꞌbã ãzí. ");
INSERT INTO luc_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Wó má aꞌdụ́ ĩmi átẹ́pị Ịbụrahị́mụ̃ angájó ãngũ álị́ Mĩrĩ Ũfũrátĩ ꞌbã ꞌá ꞌdã sĩ ãzíla má ují ĩꞌdi ãngũ Kãnánĩ drị̂ agâsĩ pírí ãzíla áfẽ anzị ãfũlépi ĩꞌdi rụ́ rĩ kí tịlé wẽwẽ rú. Áfẽ ĩꞌdiní Ĩsákã ꞌi, ");
INSERT INTO luc_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","ãzíla Ĩsákã ní áfẽ Yãkóꞌbõ kí Ị́sãwụ̃ be. Áfẽ Ị́sãwụ̃ ní ãngũ ꞌbé ꞌa rú Sẽyírĩ drị̂ adrujó ĩꞌdĩni la rú, wó Yãkóꞌbõ mụ dó anzị ĩꞌdidrị̂ kí abe Mị̃sị́rị̃ gâlé ru. ");
INSERT INTO luc_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","“‘ꞌDã ꞌbã ũngúkú gá, ápẽ dó Mụ́sã kí tị Ãrọ́nị̃ be, áfẽ dó jụ́wẹ̃ ꞌbá Mị̃sị́rị̃ gá rĩ kí ĩcãndĩ jó ị́jọ́ mání idélé lé rĩ sĩ, ãzíla má anzé dó ĩmi Mị̃sị́rị̃ gâlé rĩ sĩ ãmvé. ");
INSERT INTO luc_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","ꞌDã ꞌbã ũngúkú gá, ma dó mụ ĩmi átẹ́pịka kí anzélé angájó Mị̃sị́rị̃ gâlé sĩ kí agụjó kpere mĩrĩ ika rĩ tị gá ꞌbo, ꞌbá Mị̃sị́rị̃ drị̂ ádró kí kí vú gárĩ ãꞌdị́ drị̂ kí sĩ, ãgọbị cẹ̃lépi fãrásĩ sĩ rĩ kí abe kpere mĩrĩ ika rĩ tị gá. ");
INSERT INTO luc_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Kí mụ awalé Úpí rụ́ ꞌbo, ꞌbã dó ị́nị́ ꞌbá Mị̃sị́rị̃ drị̂ kí drĩdríŋĩ gá ĩmi abe cí, fẽ mĩrĩ ní ꞌbá Mị̃sị́rị̃ drị̂ kí drị̃ akujó rá. Ĩndre ĩmi mịfị́ sĩ ị́jọ́ mání idélé ꞌbá Mị̃sị́rị̃ drị̂ kí ụrụꞌbá gá rĩ kí cé. ꞌDã ꞌbã ũngúkú gá, ĩmi uꞌá ãngũ kõtórõ rú rĩ agá sáwã ãzo rú. ");
INSERT INTO luc_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","“‘Má ají ĩmi ãngũ ꞌbá Ãmọ́rị̃ rú rĩ ꞌbadrị́ Yõrĩdánĩ ꞌbã wókõ ị̃tụ̂ ꞌbã ãfũ agâlé ru rĩ gá. ꞌDị kí ãꞌdị́ ĩmi abe, wó áfẽ kí ĩmi drị́ alé gá. Má ị̃lị̃kị̃ kí ĩmi drị̃lẹ́ gá ꞌdâ rá ãzíla ĩꞌdụ dó sĩ ãngũ ĩꞌbadrị̂ ĩmini la rú. ");
INSERT INTO luc_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Bãlákĩ Zị̃pọ́rị̃ ngọ́pị úpí Mụ̃wábụ̃ gá rĩ ꞌbã ru itújó ãꞌdị́ ꞌdịjó ꞌbá Ịsịrayị́lị̃ drị̂ kí abe rĩ sĩ, pẽ Bãlámũ Bẹ̃yọ́rị̃ ngọ́pị ꞌi sĩ amụ́jó ĩmi wãjó. ");
INSERT INTO luc_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Wó má are Bãlámũ tị gẹ̃rị̃ sĩ ku, ị́jọ́ ꞌdĩ sĩ wi dó sĩ ĩminí sụ̃sụ́ ị̃dị́-ị̃dị́ ãzíla má anzé dó ĩmi ĩꞌdi ꞌbã drị́ agâlé rá. ");
INSERT INTO luc_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","“‘ꞌDã ꞌbã ũngúkú gá, ĩza ándrá dó mĩrĩ Yõrĩdánĩ rá ãzíla ĩca ándrá dó sĩ Yẹ̃rị́kọ̃ gá. ꞌBá Yẹ̃rị́kọ̃ gá rĩ ꞌdị kí ándrá ãꞌdị́ ĩmi abe, cécé ꞌbá Ãmọ́rị̃ drị́, Pẹ̃rẹ́zị̃ drị́, Kãnánĩ drị́, Hị́tị̃ drị́, Gị̃rị̃gásị̃ drị́, Hị́vị̃ drị́ ãzíla ꞌbá Yẹ̃bụ́sị̃ drị̂ ꞌbã kí ãꞌdị́ ꞌdịjó ĩmi abe rĩ áni, wó áfẽ ándrá kí ĩmidrị́ alé gá rá. ");
INSERT INTO luc_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Ápẽ ándrá ị̃dịrịlị kí tị ĩmi drị̃lẹ́ gá sĩ kí drojó, vâ ũpi ị̃rị̃ Ãmọ́rị̃ drị̂ kí abe; adru ĩndẽ ándrá kí ménéŋá sĩ ãzíla ụ́sụ ĩmidrị̂ kí sĩ la ku. ");
INSERT INTO luc_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Ị́jọ́ ꞌdĩ sĩ áfẽ ándrá ĩminí ãngũ ĩminí ãzị́ la ngajó ũkpó ru ĩmi ꞌi ku la, táwụ̃nị̃ ĩminí sịlé ĩmi ꞌi ku la kí, ĩri ándrá uꞌálé kí agá. Ĩri ándrá zãbíbũ ãzíla mị̃zẹ̃yị́tụ̃ ĩminí salé ĩmi ꞌi ku rĩ kí nalé.’ ");
INSERT INTO luc_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“Wó iꞌdójó úꞌdîꞌda lẽ ĩmi ụ̃rị̃ Úpí ꞌi ãzíla ĩmĩ ị̃nzị̃ ĩꞌdi ĩmi ásị́ pírí sĩ ãzíla ị́jọ́ mgbã sĩ. Ĩmi uꞌbé ãdroŋa ĩmĩ áyị́pịka ꞌbã kí ándrá ị̃nzị̃lé mĩrĩ Ũfũrátĩ ꞌbã ꞌá ꞌdã sĩ ꞌdĩ kí Mị̃sị́rị̃ gá ꞌdĩ kí abe rá, wó lẽ ĩmi ị̃nzị̃ Úpí ꞌi. ");
INSERT INTO luc_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Wó ĩdrĩ dó ndre la Úpí ị̃nzị̃jó rĩ ĩꞌdi ũnzí, ĩpẽ dó ụ́ꞌdụ́ ãndrũ ꞌdõ sĩ ĩmi mụ ãꞌdi ị̃nzị̃lé yã rĩ, ãdroŋa ándrá ĩmĩ áyị́pịka ꞌbã kí ị̃nzị̃lé mĩrĩ Ũfũrátĩ ꞌbã ꞌá ꞌdã sĩ rĩ kí, jõku ãdroŋa ꞌbá Ãmọ́rị̃ rú ándrá uꞌálépi ãngũ ĩminí sĩ úꞌdîꞌda uꞌájó ala gá ꞌdĩ ꞌbadrị̂ kî yã rĩ. Wó ma ꞌi ꞌbá mádrị́ lị́cọ́ gá ꞌdĩ kí abe ãma ãmã ngá mụ Úpí ị̃nzị̃lé.” ");
INSERT INTO luc_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","ꞌDã ꞌbã ũngúkú gá, ꞌbá umvi kí, “Ãma icó mvulé Úpí rụ́ ꞌdâ rá sĩ ãdroŋa ãzí ndú la kí ị̃nzị̃jó ku! ");
INSERT INTO luc_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Úpí ĩꞌdi Ãdróŋá ãmadrị́ ándrá ãma anzélépi ãma átẹ́pịka kí abe angájó ãngũ ándrá ãmaní sĩ adrujó ãtíꞌbó ru Mị̃sị́rị̃ gâlé rĩ ꞌi, idé ándrá ị́jọ́ ụ̃sụ̃táŋá ru ãmbógó la kí ãma drị̃ gâsĩ. Mba ãma tã ãcị̃ ãmaní acị́jó rĩ kí agâsĩ ãzíla sụ́rụ́ pírí ãmaní alịjó ala gá sĩ rĩ kí agâsĩ. ");
INSERT INTO luc_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Úpí dro sụ́rụ́ pírí kí ãma drị̃lẹ́ gá ꞌdãá rĩ sĩ rá, ꞌbá Ãmọ́rị̃ drị́ ándrá uꞌálépi ãngũ ꞌdã agá ꞌdãá rĩ kí abe. Ị́jọ́ ꞌdĩ sĩ ãma dó ngá rá la Úpí ị̃nzị̃, ãꞌdusĩku ĩꞌdi Ãdróŋá ãmadrị̂ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Wó Yósũwã jọ ꞌbá ꞌbaní, “Ĩmi icó Úpí ị̃nzị̃lé ku, ãꞌdusĩku ĩꞌdi Ãdróŋá Ãlá la, ĩꞌdi Ãdróŋá ãjã rú rĩ ꞌi. Icó ị́jọ́ ũnzí ĩmidrị̂ kí trũlé ị́jọ́ ĩminí sĩ mvujó ĩꞌdi rụ́ ꞌdâ rá rĩ abe ku. ");
INSERT INTO luc_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Ĩdrĩ Úpí aꞌbe rá sĩ ãdroŋa ndú la kí ị̃nzị̃jó, ĩꞌdi ru uja ĩmi ụrụꞌbá gá ãzíla ĩꞌdi lị́kị̃ ají ĩmi drị̃ gá sĩ ĩmi ị̃lị̃kị̃jó rá drĩ ándrá táni ĩminí mũkẽ idé rá tí.” ");
INSERT INTO luc_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Wó ꞌbá jọ kí Yósũwã ni, “Yụ, ãma Úpí ị̃nzị̃ rá.” ");
INSERT INTO luc_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","ꞌDã bã ũngúkú gá, Yósũwã jọ ĩꞌbaní, “Ĩmi ĩmĩ sãdínĩ rú cénĩ ĩminí pẽjó Úpí ị̃nzị̃jó rĩ sĩ.” Umvi kí, “Ãma ãꞌị̃ adrujó ãmã sãdínĩ rú rá.” ");
INSERT INTO luc_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Yósũwã jọ ĩꞌbaní, “Úꞌdîꞌda, lẽ ĩmi uꞌbé ãdroŋa ãmị́yọ́ŋá ꞌbãni ꞌdĩ kí ĩmi drĩdríŋĩ gá ꞌdâ rá, ãzíla ĩmi uja ĩmi ásị́ Úpí rụ́ ꞌdõlé, ꞌdĩ Ãdróŋá ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbadrị̂ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Bá jọ kí Yósũwã ní, “Ãma Úpí Ãdróŋá ãmadrị̂ ị̃nzị̃ rá ãzíla ãma ĩꞌdi tị are rá.” ");
INSERT INTO luc_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Ị́jọ́ ꞌdĩ sĩ Yósũwã icí kí dó tị icíma ꞌbá kí abe Sẹ̃kẹ́mụ̃ gá ụ́ꞌdụ́ ꞌdã sĩ, azị dó ị́jọ́ kí ãzị́táŋá kí abe ꞌbá ꞌbanî. ");
INSERT INTO luc_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Yósũwã sĩ dó ị́jọ́ ꞌdĩ kí Bụ́kụ̃ Ãdróŋá drị́ Ãzị́táŋá drị̂ agá. ꞌDã ꞌbã ũngúkú gá, aꞌdụ́ dó írã kpakụ la, ịꞌdị ĩꞌdi ụrụ gá kọmọrọ́ ị̃ndụ́ gá ãngũ ãlá Úpí drị̂ andre gá. ");
INSERT INTO luc_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Yósũwã jọ dó ꞌbá pírí ꞌbaní, “Ĩndre drĩ, írã ꞌdĩ la adru sãdínĩ rú ãma ụrụꞌbá ga, ãꞌdusĩku are ị́jọ́ pírí Úpí Ãdróŋá ꞌba jọlé ãmaní ꞌdĩ kí rá. Ĩꞌdi adru sãdínĩ rú ĩmi ụrụꞌbá gá ĩdrĩ ị́jọ́ ĩnzõ rú la kí nga Úpí Ãdróŋá ĩmidrị̂ rụ́ rĩ gá.” ");
INSERT INTO luc_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","ꞌDã ꞌbã ũngúkú gá, Yósũwã pẽ dó ꞌbá kí tị rá, ꞌbá ãlu-ãlu gõ dó ãngũ ĩꞌdidrị́ ãwítã rú rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Ị́jọ́ ꞌdĩ kí vúlé gá ãtíꞌbó Úpí drị́ Yósũwã Nụ́nị̃ ngọ́pị drã dó ꞌdĩ sĩ ílí la dó 110. ");
INSERT INTO luc_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","ꞌBá Ịsịrayị́lị̃ drị̂ ị̃sị̃ kí dó ĩꞌdi ãngũ ándrá fẽlé ĩꞌdiní ãwítã rú Tị̃mụ̃nátị̃ Sérã gá, ꞌdĩ ãngũ ꞌbé ꞌa rú Ịfụrayị́mụ̃ drị́ ꞌbé Gásĩ ꞌbã wókõ ụ́rụ́ rĩ gá. ");
INSERT INTO luc_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","ꞌBá Ịsịrayị́lị̃ drị̂ ị̃nzị̃ kí dó Úpí ꞌi ụ́ꞌdụ́ Yósũwã drị̂ kí agá pírí ãzíla ụ́ꞌdụ́ ꞌbá ĩyõ ándrá uꞌálépi ídri rú Yósũwã ní ãndânĩ ị́jọ́ pírí Úpí ꞌbã idélé ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní rĩ kí nị̃lépi rá rĩ ꞌbadrị̂ agá pírí. ");
INSERT INTO luc_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","ꞌDã ꞌbã ũngúkú gá, ĩfãkã Yụ̃sụ́fụ̃ drị́ ándrá anzị Ịsịrayị́lị̃ drị̂ ꞌbã kí ajílé angájó Mị̃sị́rị̃ gâlé rĩ kí ị̂sị̃ dó kí Sẹ̃kẹ́mụ̃ gá, ãngũ ándrá Yãkóꞌbõ ꞌbã ĩgbãlé anzị Hãmọ́rị̃ drị́ rĩ ꞌbadrị́ séndẽ sílĩvã rú 100 sĩ rĩ gá. Ãngũ ꞌdĩ acá dó sĩ anzị Yụ̃sụ́fụ̃ drị́ mụlé tịlé drị̃lẹ́ gâlé rĩ ꞌbã ãwítã rú. ");
INSERT INTO luc_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Ị́jọ́ ꞌdĩ sĩ Ị̃lị̃yãzárị̃ Ãrọ́nị̃ ngọ́pị drã dó rá, ị̂sị̃ dó sĩ ĩꞌdi táwụ̃nị̃ Gị̃bẹ́yã drị̂ gá, ꞌdĩ ãngũ ándrá fẽlé ngọ́pị Fĩnẽhásĩ ní ãngũ ꞌbé ꞌa rú Ịfụrayị́mụ̃ drị̂ agá.");
INSERT INTO luc_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Ándrá ídu ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbã kí adrujó úpí kóru rĩ sĩ, rílẽ aꞌdé ãngũ Ịsịrayị́lị̃ drị̂ gá. Ị́jọ́ ꞌdĩ sĩ, ágọ́bị́ ãzí uꞌálépi Bẹ̃tẹ̃lẹ̃hẹ́mụ̃ gá Yụ́dã gá rĩ ꞌdụ ĩꞌdi ꞌbã ũkû ꞌi, ĩꞌdi ꞌbã ngọ́pịka ị̃rị̃ rĩ kí trũ sĩ mụjó uꞌájó ãngũ Mụ̃wábụ̃ drị̂ gá ụ́ꞌdụ́ were ãni. ");
INSERT INTO luc_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Ágọ́bị̂ ꞌbã rụ́ Ị̃lị̃mẹ́lẹ̃kị̃ ꞌi ãzíla ũkû ꞌbã rụ́ Nãwụ́mị̃ ꞌi. Anzị ĩꞌdidrị̂ kí Málọ̃nị̃ kí Kị̃lị̃yọ́nị̃ be. ꞌBá ꞌdĩ kí ꞌbá Ĩfũrátã gá sụ́rụ́ Bẹ̃tẹ̃lẹ̃hẹ́mụ̃ Yụ́dã gá rĩ gá la kî. ꞌBá ꞌdĩ mụ kí dó Mụ̃wábụ̃ gá ãzíla ri kí dó uꞌálé ꞌdãá. ");
INSERT INTO luc_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","ꞌDã ꞌbã vúlé gá, Ị̃lị̃mẹ́lẹ̃kị̃ drã rá áꞌbe dó Nãwụ́mị̃ ꞌi ĩꞌdi ꞌbã anzị ị̃rị̃ ꞌdĩ kí abe. ");
INSERT INTO luc_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ngọ́pịka ị̃rị̃ ꞌdĩ aꞌdụ́ kí ũkú ru Mụ̃wábụ̃ ízó Ụ̃rị́pã kí Rụ́tụ̃ be. ꞌDĩ sĩ uꞌá kí dó ꞌdãá ílí mụdrị́ ꞌbo. ");
INSERT INTO luc_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Málọ̃nị̃ ũdrã kí vâ Kị̃lị̃yọ́nị̃ be rá, Nãwụ́mị̃ ace dó ru ágó kóru ãzíla ngọ́pịka ị̃rị̃ ꞌda kí kóru. ");
INSERT INTO luc_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Ụ́ꞌdụ́ ãzí vúlé gá Nãwụ́mị̃ la mụ arelé la Mụ̃wábụ̃ gâlé Úpí wi sụ̃sụ́ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbaní ãkónã fẽŋá sĩ ꞌbo íni, itú kí ru ũkúka kí abe sĩ gõjó vúlé ĩꞌbadrị́ Ịsịrayị́lị̃ gâlé. ");
INSERT INTO luc_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Nãwụ́mị̃ mụ dó ũkúka ị̃rị̃ ꞌdĩ abe aꞌbe kí ãngũ ĩꞌbã kí sĩ uꞌájó ꞌdã ꞌi, ko kí drị̃ mụjó vúlé ãngũ Yụ́dã drị̂ gá. ");
INSERT INTO luc_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Wó ĩꞌbaní mụ agá gẹ̃rị̃ gá ꞌdâ Nãwụ́mị̃ jọ ũkúka ꞌbanî, “Ĩminí mụjó má be rĩ kẹ̃jị́ gá ĩgõ vúlé ĩmĩ andreka ꞌbadrị́ lị́cọ́ gâlé, ãzíla Úpí ꞌbã ũfẽ ĩmi ũyá sĩ ĩminí ásị́ ị̃gbẹ̃ idéjó ĩmĩ ágóka ũdrãlépi rá rĩ ꞌbaní ãzíla mání rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Lẽ Úpí ꞌbã wi ĩminí sụ̃sụ́ ĩmi tãmbajó ásị́ ị̃gbẹ̃ sĩ ágó ãzí kí rụjó.” Nãwụ́mị̃ amvu kí jụ́jụ́ sĩ ãzíla jọ ĩꞌbaní ĩmụ dô, ị́jọ́ ꞌdĩ sĩ, iꞌdó kí dó sĩ awálé, ");
INSERT INTO luc_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","ãzíla jọ kí ĩꞌdinî, “Yụ ãlẽ mụlé mí be ꞌbá mídrị̂ ꞌba rụ̂lé ĩndĩ.” ");
INSERT INTO luc_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Wó Nãwụ́mị̃ jọ, “Mâ ị̃zẹ́pịkâ, ĩgõ vúlé. Ĩlẽ mụlé má be ĩndĩ ãꞌdu ị́jọ́ sĩ yã? Má icó anzị ãzí kí tịlé ị̃dị́, kí dó sĩ zo ĩminí ágó ru rá yã? ");
INSERT INTO luc_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Yụ mâ ị̃zẹ́pịkâ ĩgõ vúlé ꞌbá ĩmi tịlépi rĩ ꞌbadrị́ kogâlé, ãꞌdusĩku áde kpánĩ-kpánĩ ꞌbo sĩ ágó rụjó. Ádrĩ táni ꞌbã la áma ásị́ gá icó tátí rá, ãzíla ádrĩ tá icó uꞌálé ágó be ị́nị́ ãndrũ ꞌdĩ sĩ anzị kí tịjó rá, ");
INSERT INTO luc_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ĩmi icó tá anzị la ꞌda kí ũtẽlé zo agá sĩ kí rụjó ágó ru rá yã? Ĩmi icó sĩ ágó ãzí ndú la kí rụlé ku yã? Yụ ĩmi idé ꞌdĩ áni ku mâ ị̃zẹ́pịkâ! Ị́jọ́ uja kí ru mání ụ̃jị́-ụ̃jị́ ndẽ ĩmidrị̂ kí rá, ãꞌdusĩku Úpí uja ru drị́ áma ụrụꞌbá gá ũnzí.” ");
INSERT INTO luc_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Iꞌdó kí vâ awálé ị̃dị́, ꞌdã ꞌbã ũngúkú gá Ụ̃rị́pã amvu dó ĩdrâ ꞌi, azị dó sĩ ĩꞌdiní ãzíla gõ dó rá. Wó Rụ́tụ̃ ĩbĩ ru ãsítáŋá sĩ uꞌálé Nãwụ́mị̃ be. ");
INSERT INTO luc_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Nãwụ́mị̃ jọ ĩꞌdiní, “Índre, mî ãjágô gõ vúlé ꞌbá ĩꞌdidrị̂ ꞌba rụ́ ãzíla ãdroŋa ĩꞌdidrị̂ ꞌba rụ̂lé ꞌbo. Lẽ ígõ vâ vúlé ꞌbá mídrị̂ ꞌba rụ́ ĩꞌdi be.” ");
INSERT INTO luc_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Rụ́tụ̃ umvi ĩꞌdiní, “Lẽ ị́jọ mání má aꞌbe mi sĩ gõjó vúlé la ku, ãma mụ mí be, ãngũ míní sĩ mụjó rĩ gá ãzíla ãngũ míní sĩ uꞌájó rĩ gá. ꞌBá mídrị̂ kí adru ꞌbá mádrị̂ kî, ãzíla Ãdróŋá mídrị̂ la vâ adru Ãdróŋá mádrị̂ ꞌi. ");
INSERT INTO luc_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ãngũ míní drãjó rĩ gá ma vâ drã ꞌdãá, ãzíla ãngũ ími ị̃sị̃jó rĩ gá ála vâ áma ị̃sị̃ ꞌdãá. Lẽ Úpí ꞌbã fẽ mání drị̃rịma ũnzí la ádrĩ ị́jọ́ ãzí idé ími aꞌbejó rá rĩ gá, wó drã la rá la ãma awa mí be nĩ.” ");
INSERT INTO luc_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Nãwụ́mị̃ la mụ ndrelé la Rụ́tụ̃ umbé dó ru ásị́ mụjó ĩꞌdi be rĩ gá rá, aꞌbe jọjó la ĩꞌdiní ꞌbã gõ vúlé rĩ rá. ");
INSERT INTO luc_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ị́jọ́ ꞌdĩ sĩ ũkú ị̃rị̃ ꞌdĩ amụ́ kí dó kpere ĩꞌbaní acá agá Bẹ̃tẹ̃lẹ̃hẹ́mụ̃ gá. Kí mụ acálé ꞌbo, ũkú táwụ̃nị̃ agá ꞌdãá rĩ amụ́ kí ĩꞌdi aꞌị́lé ãyĩkõ sĩ ãzíla zị kí dó sĩ, “ꞌDĩ ãndá-ãndá ru Nãwụ́mị̃ ꞌi yã?” ");
INSERT INTO luc_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Nãwụ́mị̃ umvi ĩꞌba ní, “Ĩmi umve ma Nãwụ́mị̃ ꞌi ku rá la Márã ꞌi ãꞌdusĩku Ãdróŋá Ũkpó ꞌDị́pị fẽ mání ũcõgõ. ");
INSERT INTO luc_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Mání ándrá mụjó rĩ sĩ, ámụ ándrá ꞌbá trũ ũꞌbí ru, wó Úpí ají ma lị́cọ́ gá ꞌdõlé drị́drị́ ru ꞌbá kóru. Ĩmi dó áma umve Nãwụ́mị̃ la ãꞌdu ị́jọ́ sĩ, ịsụ́ Úpí Ũkpó ꞌDị́pị lị áma ị́jọ́ ãzíla ají mání ũcõgõ?” ");
INSERT INTO luc_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","ꞌDĩ dó bãsĩ ũví Nãwụ́mị̃ ꞌbã ándrá ãgõjó Mụ̃wábụ̃ gâlé ũkû Rụ́tụ̃ Mụ̃wábụ̃ ízó ru rĩ be rĩ ꞌi. Ịsụ́ sáwã ꞌdĩ dó bãsĩ ãná umvelé bálẽ rĩ lãjó rĩ ꞌbã iꞌdójó Bẹ̃tẹ̃lẹ̃hẹ́mụ̃ gá rĩ. ");
INSERT INTO luc_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Nãwụ́mị̃ ꞌbã ágô Ị̃lị̃mẹ́lẹ̃kị̃ ꞌbã kãká ãzí ĩꞌbadrị́ ínátị gá kụ́rẹ́nị́ ru rụ́ kụlépi kụ̃kụ̃ rĩ ꞌbã rụ́ Bõwázĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ụ́ꞌdụ́ ãlu Rụ́tụ̃ Mụ̃wábụ̃ ízó ru rĩ jọ Nãwụ́mị̃ ní, “Má icó tá mụlé ãná ródóvúlé ndrụ̃ trũ ꞌbá cí icólépi áma ízákĩzã ndrelépi rá rĩ drị́ ámvụ́ agá rá yã?” Nãwụ́mị̃ umvi, “Ímụ ꞌbánî, mâ ũkû.” ");
INSERT INTO luc_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ị́jọ́ ꞌdĩ sĩ Rụ́tụ̃ mụ dó rá iꞌdó dó ãná ródóvúlé ndrụ̃lé ꞌbá ãná lãlépi rĩ kí vúlé gá. ꞌDãá ịsụ́ dó ru ãná ndrụ̃ agá Ị̃lị̃mẹ́lẹ̃kị̃ ꞌbã kãká Bõwázĩ drị́ ámvụ́ agá. ");
INSERT INTO luc_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Sáwã were vúlé gá Bõwázĩ acá angájó Bẹ̃tẹ̃lẹ̃hẹ́mụ̃ gâlé rĩ sĩ ãzíla zị ꞌbá ãná lãlépi rĩ kí jọ ĩꞌbaní, “Ásị́ ị̃gbẹ̃ Úpí drị̂ ꞌba adru ĩmi abe!” Umvi kí ĩꞌdiní, “Ásị́ ị̃gbẹ̃ Úpí drị̂ ꞌba adru vâ mí be ĩndĩ!” ");
INSERT INTO luc_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bõwázĩ zị ãmbógó ꞌbá ãná lãlépi rĩ ꞌbadrị̂ ꞌi, “Ũkú úꞌdí ꞌdã ãꞌdi ãni?” ");
INSERT INTO luc_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Ãmbógô umvi, “ꞌDã Rụ́tụ̃ Mụ̃wábụ̃-ízó ru amụ́lépi Nãwụ́mị̃ be angájó Mụ̃wábụ̃ gâlé rĩ ꞌi. ");
INSERT INTO luc_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Zị tá ma sĩ ãná ródóvúlé ndrụ̃jó ꞌbá ãná lãlépi rĩ kí vúlé gá ꞌdâ. Iꞌdó tá ãzị́ ngalé ũkpó ru ụ̃ꞌbụ́tị sĩ, rá la avị́ lú índríkã gá ꞌdãá sáwã were sĩ.” ");
INSERT INTO luc_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Ị́jọ́ ꞌdĩ sĩ Bõwázĩ mụ dó Rụ́tụ̃ rụ̂lé ãzíla jọ dó ĩꞌdiní, “Mí are ma, mâ ị̃zẹ́pị, ímụ jõ ãná ródóvúlé ndrụ̃lé ámvụ́ ãzí ndú la agá ku ãzíla mí aꞌbe jõ ãngũ ꞌdĩ ku. Índrụ̃ ãná ródóvúlé izonzi mádrị́ ãtiꞌbo rú ꞌdĩ kí vúlé gá ꞌdâ ãni rú. ");
INSERT INTO luc_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ími mịfị́ ꞌbã adru ámvụ́ ꞌbá ꞌbã kí sĩ ãná lãjó rĩ gá, íꞌde izonzi kí vú gâsĩ. Ájọ ꞌbá ãgọbị rú ꞌdĩ ꞌbaní ꞌbã fẽ kí jõ míní ũcõgõ ku. Ị̃yị́ vị́ drĩ ími ndẽ rá, ímụ ị̃yị́ mvụlé ãkójó sĩ ị̃yị́ tõjó rĩ gá ĩꞌba rụ́ ꞌdãá.” ");
INSERT INTO luc_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ị́jọ́ ꞌdĩ sĩ Rụ́tụ̃ tị̃ dó ãja, ilú dó drị̃ vụ̃rụ́ ãrútáŋá ru. Jọ, “Ma ãmị́yọ́ŋá, mí iꞌda mání ásị́ ị̃gbẹ̃ íni ãꞌdu ị́jọ́ sĩ yã?” ");
INSERT INTO luc_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Bõwázĩ umvi, “Má are ị́jọ́ ãzị́ míní ngalé mî ĩdrâ ní mî ágô ꞌbã drãjó ꞌbo rĩ sĩ rĩ kí drị̃ gá pírí rá. Únze vâ mání ị́jọ́ míní mî átẹ́pị kí aꞌbejó mî ãndrẽ be, sụ́rụ́ mídrị̂ kí abe ãzíla míní amụ́jó uꞌájó ꞌbá míní nị̃lé ku ꞌdĩ kí abe rĩ rá. ");
INSERT INTO luc_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Úpí ꞌbã ũfẽ mi calépi rĩ sĩ ị́jọ́ míní idélé ꞌdĩ kí sĩ ꞌdĩ Ãdróŋá Ịsịrayị́lị̃ drị́ míní sĩ amụ́jó ĩꞌdi rụ́ sĩ ími tãmbajó rĩ ꞌi.” ");
INSERT INTO luc_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rụ́tụ̃ jọ, “Ãmbógó míní áma ásị́ ũŋmĩjó rĩ sĩ ãzíla míní ị́jọ́ jọjó mání ásị́ ị̃gbẹ̃ sĩ rĩ sĩ, ífẽ má ịsụ́ ásị́ ị̃gbẹ̃ jãꞌdâ mání adrujó izonzi mídrị́ ãzị́ gá ꞌdĩ kí abe trũ trũ ku rá tí.” ");
INSERT INTO luc_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Sáwã ãkónã najó rĩ la mụ calé ꞌbo, Bõwázĩ jọ Rụ́tụ̃ ní, “Mí amụ́, ãma amụ́ kí íná nalé. Ídũ íná tẹ́bị́ agâlé.” Rụ́tụ̃ la dó mụ rilé ꞌbá ãná lãlépi rĩ kí andre gá ꞌdãá ꞌbo, Bõwázĩ fẽ dó ĩꞌdiní ãkónã nalé. Na dó ãkónã ꞌi, aga dó sĩ rá ãzíla aꞌbe dó ị́mbị́ la kí cí. ");
INSERT INTO luc_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Rụ́tụ̃ la mụ iꞌdólé ãná ródóvúlé ndrụ̃lé ị̃dị́ ꞌbo, Bõwázĩ fẽ ãzị́táŋá ꞌbá ĩꞌdidrị́ ãzị́ ngalépi rĩ ꞌbaní, jọ, “Ĩmi ĩcõcõŋã jõ ĩꞌdi ku drĩ táni ãná bálẽ rú uꞌdelépi ũdĩbá kí drĩdríŋĩ gá rĩ kí ụꞌdụ rĩ gá. ");
INSERT INTO luc_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Be la rá la ĩmi aꞌbe ĩꞌdiní ãná ãzí kí angájó ũdĩbá gá ãzíla ꞌbã ụꞌdụ sĩ kí ĩꞌdidrị̂ kí ĩjãlãjó, ĩmi uzá jõ ĩꞌdi drị̃ gá ku.” ");
INSERT INTO luc_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ị́jọ́ ꞌdĩ sĩ, Rụ́tụ̃ ndrụ̃ dó ãná bálẽ rú rĩ ꞌbã ródóvúlé kpere ĩndró gá. ꞌDã ꞌbã vúlé gá co dó ífí-ífí lã ãni rú kị́lọ̃ mụdrị́ ꞌdĩpí. ");
INSERT INTO luc_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","ꞌDụ dó ãná trũ mụ́jó ĩdrâ rụ́ táwụ̃nị̃ gâlé. Iꞌda dó ĩdrâ ní ndrụ̃ ãná íngõpí yã rĩ ꞌi. Rụ́tụ̃ anzé dó vâ ãkónã tá ĩꞌdi ꞌbã nalé ãná ndrụ̃ŋá gâlé tí rĩ kí fẽ kí nalé Nãwụ́mị̃ nî. ");
INSERT INTO luc_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Nãwụ́mị̃ zị Rụ́tụ̃ ꞌi, “Ímụ tá ãná ndrụ̃lé íngõlé yã? Ínga tá ãzị́ ãꞌdi drị́ ámvụ́ agá yã? Ãdróŋá ꞌbã wi sụ̃sụ́ ꞌbá ásị́ ị̃gbẹ̃ iꞌdalépi míní rĩ nî!” Rụ́tụ̃ lũ ĩdrâ ní angá ãzị́ ágọ́bị́ umvelé Bõwázĩ rĩ drị́ ámvụ́ agá. ");
INSERT INTO luc_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Nãwụ́mị̃ jọ Rụ́tụ̃ ní, “Úpí ꞌbã wi sụ̃sụ́ Bõwázĩ nî, ĩꞌdi mî ágô ꞌbã kãká lị́cọ́ agá ꞌdâ icólépi ãma tãmbalépi mí be rá rĩ ꞌbã ãzí. Úpí la ụ́ꞌdụ́ pírí sĩ ꞌbá ídri rĩ kí ị́jọ́ ũrã ꞌbá ũdrãlépi rá rĩ abe rá.” ");
INSERT INTO luc_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","ꞌDã ꞌbã ũngúkú gá, Rụ́tụ̃ Mụ̃wábụ̃ ízó ru rĩ jọ, “Bõwázĩ jọ vâ mání ándrụ̃ ãná bálẽ rú rĩ kpere ꞌbá ĩꞌdidrị́ bálẽ lãlépi rĩ ꞌbã kí de agá lã agá.” ");
INSERT INTO luc_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Nãwụ́mị̃ jọ Rụ́tụ̃ ní, “Mâ ũkû, ĩꞌdi ị́jọ́ múké la míní acị́jó izonzi ãzị́ ngalépi Bõwázĩ drị́ ámvụ́ agá ꞌdĩ kí abe, ãꞌdusĩku ídrĩ mụ ꞌbá ãzí drị́ ámvụ́ agá mí icó ũcõgõ ịsụ́lé rá.” ");
INSERT INTO luc_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ị́jọ́ ꞌdĩ sĩ, Rụ́tụ̃ ri dó ãná bálẽ rú rĩ ꞌbã ródóvúlé ndrụ̃lé izonzi Bõwázĩ drị́ amvụ́ agá rĩ kí vúlé gá ꞌdãá kpere ãnâ ꞌbã ukó agá ãzíla Rụ́tụ̃ ri dó uꞌálé ĩdrâ be. ");
INSERT INTO luc_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Ụ́ꞌdụ́ ãzí sĩ Rụ́tụ̃ ꞌbã ĩdrâ Nãwụ́mị̃ jọ ĩꞌdiní, “Mâ ị̃zẹ́pị, lẽ má ịsụ́ míní ágó icólépi ími tãmbalépi múké rá la, ĩmi dó sĩ lị́cọ́ sị ĩꞌdi be. ");
INSERT INTO luc_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Lẽ ínị̃ rá Bõwázĩ míní ãzị́ ngajó izonzi la kí abe rĩ ĩꞌdi ãmã kãká. Mí are drĩ, ãndrũ ĩndró sĩ Bõwázĩ la mụ ãná ndrịlé ãngũ sĩ ãná cojó rĩ gá. ");
INSERT INTO luc_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ị́jọ́ ꞌdĩ sĩ, lẽ mí ũjĩ mi, mí uní mi ãdu ãjị́ ngụ̃lépi vĩrĩ rĩ sĩ ãzíla ísụ̃ bõngó mídrị́ ãlá rĩ kí áyụ. ꞌDã ꞌbã ũngúkú gá, ímụ dó ãngũ ĩꞌdi ꞌbã sĩ ãná ndrịjó rĩ gá, wó lẽ ífẽ ꞌbã nị̃ mi ꞌdãá cí rĩ gá ku kpere ĩꞌdi ꞌbã íná naŋá ãzíla wáyĩnĩ mvụŋá de agá. ");
INSERT INTO luc_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Ĩꞌdi ꞌbã ru la agá ụ́ꞌdụ́ gá, índre ãngũ ĩꞌdi ꞌbã sĩ rũ lajó rĩ múké-múké. ꞌBo ímụ dó bõngó ĩꞌdi ꞌbã pá gá rĩ wịlé ãzíla íla dó sĩ mi vũ gá. Ĩꞌdi dó mụ míní mí idé ãꞌdu yã rĩ lũlé nĩ.” ");
INSERT INTO luc_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rụ́tụ̃ umvi Nãwụ́mị̃ ní, “Ma ị́jọ́ míní jọlé ꞌdĩ kí nga pírí rá.” ");
INSERT INTO luc_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Ị́jọ́ ꞌdĩ sĩ Rụ́tụ̃ mụ dó ãngũ sĩ ãná ndrịjó rĩ gâlé ãzíla idé ị́jọ́ kí pírí ĩꞌdĩ ꞌbã ĩdrâ ꞌbã jọlé rĩ áni. ");
INSERT INTO luc_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Bõwázĩ la dó mụ íná naŋá ãzíla wáyĩnĩ mvụŋá delé ꞌbo, ásị́ la acá dó ãyĩkõ rú. Mụ dó sĩ ru lalé vụ̃rụ́ ãngũ ãná drõjó rĩ ꞌbã tị ꞌbã ãsị̃ agá. Rụ́tụ̃ mụ dó jã-jã rú, wị dó sókã Bõwázĩ pá gá rĩ ãzíla la dó ru vũ gá. ");
INSERT INTO luc_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ị́nị́ ágágá Bõwázĩ angá, uja ru tị ãzíla aru-arû. Acá dó ụ̃sụ̃táŋá sĩ ĩꞌdi ꞌbã ịsụ́jó la ũkú ãzí la ru ĩꞌdi pá gá ꞌdãá cí rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Zị dó, “Mi ãꞌdi ꞌi?” Rụ́tụ̃ umvi, “Ma ãtíꞌbó mídrị́ Rụ́tụ̃ ꞌi. Má aꞌị́ mídrị́ ífi ma míní adrujó mâ ágô ꞌbã kãká icólépi áma tãmbalépi rá rĩ ꞌi rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Bõwázĩ umvi ĩꞌdiní, “Úpí ꞌbã wi míní sụ̃sụ́ mâ ị̃zẹ́pị, lẽtáŋá míní iꞌdalé úꞌdîꞌda ꞌdĩ ndẽ míní iꞌdalé Nãwụ́mị̃ ní rĩ rá. Míní ásị́ ꞌbãjó anzị kãrị́lẹ̃ rú, kụ́rẹ́nị́ ru jõku lẽmẽrí ru rĩ kí drị̃ gá ku rĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ụ̃rị̃ ꞌbã rụ mi ku mâ ị̃zẹ́pị, ma ị́jọ́ míní lẽlé rĩ kí idé rá. ꞌBá pírí ãmadrị́ táwụ̃nị̃ agá ꞌdãá rĩ nị̃ kí mi ũkú gbíyã múké la rĩ gá rá. ");
INSERT INTO luc_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ádrĩ táni adru agá mí ágô ꞌbã kãká tí, ꞌbá ãzí ãni rú kãká ru icólépi ími tãmbalépi la cí. ");
INSERT INTO luc_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Íde ị́nị́ ꞌdĩ ꞌdâ, drụ̃sị̃ ụ̃ꞌbụ́tị sĩ ãma dó sĩ ĩꞌdi icó ími tãmbalé rá yã rĩ ịsụ́. Wó drĩ lẽ la ku, Úpí ꞌbã adrujó ídri rú rĩ áni ma ími tãmba rá, íla mi ꞌdâ kpere ụ̃ꞌbụ́tị gá.” ");
INSERT INTO luc_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ị́jọ́ ꞌdĩ sĩ Rụ́tụ̃ la ru Bõwázĩ ꞌbã pá gá ándrá ꞌdãá kpere ụ̃ꞌbụ́tị gá, wó angá sáwã sĩ icójó ꞌbá nị̃jó ku la gá. Bõwázĩ jọ ĩꞌdiní, “Ífẽ ꞌbá ãzí ꞌbã nị̃ jõ ũkú ãzí amụ́ ãngũ sĩ ãná ndrịjó rĩ gá ꞌdõlé rá la ku.” ");
INSERT INTO luc_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Bõwázĩ jọ vâ Rụ́tụ̃ ní, “Mí ajị́ bõngó míní sĩ ími ụrụꞌbá ꞌbejó rĩ ãzíla mí aja ĩꞌdi vũ gá ꞌdâ.” Ĩꞌdi mụ bõngô ajalé ꞌbo, Bõwázĩ sũ ãná ala gá ãni rú kị́lọ̃ kãlị́na ꞌdĩpí ãzíla ꞌbã dó ĩꞌdi Rụ́tụ̃ drị̃ gá. Uja dó ru táwụ̃nị̃ gâlé. ");
INSERT INTO luc_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rụ́tụ̃ la mụ ãgõlé ĩꞌdi ꞌbã ĩdrâ rụ́ ꞌdõlé ꞌbo, Nãwụ́mị̃ zị dó, “Mâ ĩzẹ́pị, ị́jọ́ acị́ kí íngoní?” ꞌDãá nze dó ị́jọ́ Bõwázĩ ꞌbã ngalé ĩꞌdiní rĩ kî, ");
INSERT INTO luc_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","ãzíla jọ vâ, “Fẽ mání ãná ꞌdĩ kí pírí nĩ, ãzíla jọ, má ãgõ jõ mí rụ́ ꞌdõlé drị́drị́ ru ku.” ");
INSERT INTO luc_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Ị́jọ́ ꞌdĩ sĩ Nãwụ́mị̃ jọ, “Mâ ị̃zẹ́pị ími ásị́ ꞌbã adru ũkpó ru kpere míní nị̃ agá la ãꞌdu ị́jọ́ la ru idé nĩ yã rĩ gá, ãꞌdusĩku Bõwázĩ ásị́ icó pá tulé ku kpere ị́jọ́ ꞌdĩ ꞌbã ru ãzã ko agá ãndrũ ráká.” ");
INSERT INTO luc_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Bõwázĩ mụ rilé kẹ̃jị́tị sĩ fijó táwụ̃nị̃ agâlé rĩ tị gá ꞌdãá. Kãká tá icólépi Rụ́tụ̃ tãmbalépi nĩ ĩꞌdi ꞌbã sĩ ị́jọ́ jọjó drị̃ la gá rĩ la mụ acálé ꞌbo, jọ dó, “Mâ wọ̃rị̂, mí amụ́ drĩ rilé áma andre gá ꞌdộ.” Ị́jọ́ ꞌdĩ sĩ, ágọ́bị̂ mụ dó rilé vũ gá. ");
INSERT INTO luc_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Bõwázĩ umve ꞌbá ĩyõ táwụ̃nị̃ drị̂ ꞌbã ãzí kí mụdrị́ ãzíla aꞌị́ kí rilé vũ gá. Idé kí dó ꞌdã ꞌbã áni. ");
INSERT INTO luc_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Jọ dó kãká icólépi Rụ́tụ̃ tãmbalépi rá ꞌdã ní, “Nãwụ́mị̃ ãgõlépi Mụ̃wábụ̃ gá rĩ la ãngũ ãmã ádrị́pị Ị̃lị̃mẹ́lẹ̃kị̃ drị̂ ị̃tụ̃ndã. ");
INSERT INTO luc_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Má ũrã ị́jọ́ la lũjó míní ãzíla vâ sĩ ími aꞌị́jó ĩgbãjó la ꞌbá urilépi ꞌdĩ kí drị̃ gâsĩ ãzíla ꞌbá ĩyõ mádrị́ ꞌdĩ kí drị̃ gâsĩ. Ídrĩ ãngũ ꞌdĩ lẽ rá, mí ĩgbã ĩꞌdi ꞌbá urilépi ꞌdĩ kí drị̃ gâsĩ, wó ídrĩ lẽ ĩgbãlé la ku, ílũ mání, ma dó sĩ nị̃ la cé ãꞌdusĩku ꞌbá ãzí ndú icólépi ĩgbãlépi la yụ pẽ lú mi ꞌi ãzíla ma ꞌi ími ũngúkú gá ãni rú rĩ.” Ágọ́bị̂ jọ, “Ma ĩgbã la rá.” ");
INSERT INTO luc_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","ꞌDã ꞌbã ũngúkú gá, Bõwázĩ jọ, “Ụ́ꞌdụ́ míní ãngũ ꞌdã ĩgbãjó Nãwụ́mị̃ drị́ rĩ sĩ, mi vâ Rụ́tụ̃ Mụ̃wábụ̃ ízó ru rĩ tãmba ĩndĩ, sĩ ágó ĩꞌdidrị́ drãlépi rá Málọ̃nị̃ ꞌbã rụ́ ĩdrị̃jó ãko ĩꞌdidrị̂ kí abe.” ");
INSERT INTO luc_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","ꞌDã ꞌbã ũngúkú gá, kãká tá tí icólépi Rụ́tụ̃ tãmbalépi rá rĩ jọ, “Má icó dó ãngũ ꞌdĩ ĩgbãlé ku ãꞌdusĩku anzị mádrị̂ icó kí ãngũ ꞌdã ꞌdụlé ĩꞌbã ãni la rú ku. Mí ĩgbã dó bãsĩ ĩꞌdi míní. Má icó ku.” ");
INSERT INTO luc_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Ándrá ídu rĩ sĩ, lãꞌbĩ ꞌbá Ịsịrayị́lị̃ drị̂ ꞌbadrị̂ agá ꞌbá ãzí ní acájó ãko ãzí ꞌbã ꞌdị́pị rú, ꞌbá ãlu rĩ la ŋĩlâ ĩꞌdi ꞌbã pá gá rĩ ãtrũ fẽlé ꞌbá ãzí rĩ drị́. ꞌDĩ ándrá gẹ̃rị̃ pịrị ꞌbá ãzí ꞌbã sĩ acájó ãko ãzí ꞌbã ꞌdị́pị rú Ịsịrayị́lị̃ gá rĩ. ");
INSERT INTO luc_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ị́jọ́ ꞌdĩ sĩ, ágọ́bị́ ꞌdĩ jọ Bõwázĩ ní, “Mí ĩgbã ĩꞌdi mi ꞌi.” ꞌBo ãtrũ dó ŋĩlâ ĩꞌdi pá gá rĩ fẽlé Bõwázĩ drị́. ");
INSERT INTO luc_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","ꞌDã ꞌbã ũngúkú gá, Bõwázĩ jọ ꞌbá ĩyõ ãzíla ꞌbá pírí ꞌdãá cí rĩ ꞌbaní, “Ãndrũ ĩmi mâ sãdínĩ rú ndrejó la má ĩgbã Nãwụ́mị̃ drị́ ãko Ị̃lị̃mẹ́lẹ̃kị̃, Kị̃lị̃yọ́nị̃ ãzíla Málọ̃nị̃ ꞌbadrị̂ kí pírí. ");
INSERT INTO luc_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Áꞌdụ vâ Rụ́tụ̃ Mụ̃wábụ̃ ízó ru ãwụ́zị́ Málọ̃nị̃ ꞌbã aꞌbelé rĩ mání ũkú ru ĩndĩ sĩ ĩꞌdi ꞌbã rụ́ ị̃drị̃jó ãzí la ãko ĩꞌdidrị̂ kí abe. Ị́jọ́ ꞌdĩ sĩ, ĩꞌdi ꞌbã rụ́ ꞌbã ãvĩ rú sĩ lị́cọ́ ãmadrị́ ãzíla táwụ̃nị̃ ãmadrị̂ agá ku benĩ. Ĩmi dó sĩ ãndrũ mâ sãdínĩ!” ");
INSERT INTO luc_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","ꞌDã ꞌbã vúlé gá ꞌbá ĩyõ rĩ kí ꞌbá ũꞌbí ꞌdãá rĩ kí abe jọ kí, “Ãma pírí sãdínĩ. Ị́jọ́ ꞌdĩ sĩ, Úpí ꞌbã fẽ ũkú afílépi mídrị́ lị́cọ́ gá ꞌdõlé ꞌdĩ ꞌbã adru cécé Rãkẹ́lị̃ ꞌbã kí ándrá Léyã be lị́cọ́ Yãkóꞌbõ drị̂ ị̃ndụ́ iꞌdójó ãngũ ãlu gá nĩ rĩ áni. Mí adru kẹ́jẹ́ŋị́ málĩ trũ íná tị Ĩfũrátã gá ãzíla ími rụ́ ꞌbã kụ-kụ̃ sụ́rụ́ Bẹ̃tẹ̃lẹ̃hẹ́mụ̃ gá. ");
INSERT INTO luc_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Úpí ꞌbã fẽ anzị ãfũlépi ĩmi rụ́ Rụ́tụ̃ be rĩ ꞌba adru kí cécé Pẹ̃rẹ́zị̃ drị̂ kî áni ꞌdĩ ngọ́tị́ Yụ́dã ꞌbadrị́ Tãmárã be rĩ.” ");
INSERT INTO luc_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ị́jọ́ ꞌdĩ sĩ, Bõwázĩ ꞌdụ dó Rụ́tụ̃ ꞌi ĩꞌdi ꞌbã ũkú ru ãzíla ko kí dó ĩꞌdi be. Úpí wi ĩꞌbaní sụ̃sụ́ rá, ịsụ́ dó sĩ ꞌa, ãzíla tị dó ngọ́tị́ ágọ́bị́. ");
INSERT INTO luc_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Ũkú táwụ̃nị̃ Bẹ̃tẹ̃lẹ̃hẹ́mụ̃ gá rĩ jọ kí Nãwụ́mị̃ ní, “Lẽ ãma ịcụ́ kí Úpí ꞌi ãndrũ ĩꞌdi ꞌbã míní ngọ́tị́ ágọ́bị́ ími tãmbalépi la fẽjó rĩ sĩ. Lẽ rụ́ la ꞌbã kụ-kụ̃ ãngũ Ịsịrayị́lị̃ drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Mí ũkû lẽ mi ambamba, ndẽ míní adrujó anzị ãgọbị trũ ázị̂rị̃ rĩ rá, ngọ́tị́ ĩꞌdi ꞌbã tịlé míní ꞌdĩ la drụ́zị́ ími ásị́ imbá, ãzíla ĩꞌdi ími tãmba ĩdrãnĩgõ gá nĩ!” ");
INSERT INTO luc_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Nãwụ́mị̃ ꞌdụ dó ngọ́tị̂ ĩꞌdidrị́ gá ãzíla mba dó tã la. ");
INSERT INTO luc_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ũkú uꞌálépi jĩránĩ rú ꞌdãá rĩ jọ kí ꞌbá ꞌbanî, “Nãwụ́mị̃ ꞌbã ngọ́tị́ ágọ́bị́ dó cí!” ꞌDa kí ĩꞌdi rụ́ Ụ̃bẹ́dị̃ ꞌi. Ụ̃bẹ́dị̃ tị dó Yésẽ ꞌi, ꞌdĩ Dãwụ́dị̃ ꞌbã átẹ́pị ꞌi. ");
INSERT INTO luc_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","ꞌDĩ ãwí Pẹ̃rẹ́zị̃ drị̂ ꞌi: Hẽzĩrónĩ ꞌbã átẹ́pị Pẹ̃rẹ́zị̃ ꞌi ");
INSERT INTO luc_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Rámũ ꞌbã átẹ́pị Hẽzĩrónĩ ꞌi, Ãmĩnãdábũ ꞌbã átẹ́pị Rámũ ꞌi, ");
INSERT INTO luc_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Násõnĩ ꞌbã átẹ́pị Ãmĩnãdábũ ꞌi, Sãlĩmónĩ ꞌbã átẹ́pị Násõnĩ ꞌi ");
INSERT INTO luc_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Bõwázĩ ꞌbã átẹ́pị Sãlĩmónĩ ꞌi, Ụ̃bẹ́dị̃ ꞌbã átẹ́pị Bõwázĩ ꞌi, ");
INSERT INTO luc_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Yésẽ ꞌbã átẹ́pị Ụ̃bẹ́dị̃ ꞌi, Ãzíla Dãwụ́dị̃ ꞌbã átẹ́pị Yésẽ ꞌi.");
INSERT INTO luc_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Ágọ́bị́ ãzí ándrá cí rụ́ la Ĩlĩkánã ꞌi. Ĩꞌdi ándrá ꞌbá Rãmãtãyị́mụ̃ Zõfímũ gá ãngũ ꞌbé ꞌa rú sụ́rụ́ Ịfụrayị́mụ̃ drị̂ agá la. Ĩꞌdi Yẽhõrámũ ngọ́pị ꞌi, áyị́pị̃ ĩꞌdi Ẹ̃lị́hụ̃ ꞌi, Ẹ̃lị́hụ̃ ĩꞌdi Tọ́hụ̃ ngọ́pị ꞌi, Tọ́hụ̃ ĩꞌdi Zụ́fụ̃ ngọ́pị ꞌi angájó sụ́rụ́ Ịfụrayị́mụ̃ drị̂ agá. ");
INSERT INTO luc_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Ĩlĩkánã ꞌbã ũkú kí ándrá ị̃rị̃. Ũkú ãlu rĩ ꞌbã rụ́ Hánã ꞌi, ãzí rĩ ꞌbã rụ́ Pẹ̃nị́nã ꞌi. Pẹ̃nị́nã ꞌbã anzị kí ándrá cí wó Hánã ándrá anzị kó ru. ");
INSERT INTO luc_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Ịsụ́ íni ꞌdĩ ílí ãlu ãlu sĩ Ĩlĩkánã la mụ táwụ̃nị̃ Sị́lọ̃ gá sĩ Ãdróŋá Ũkpó ꞌdị́pị ị̃nzị̃jó ãzíla sĩ ĩꞌdiní ídétáŋá idéjó Sị́lọ̃ gá, ꞌdĩ ãngũ Élĩ ꞌbã ngọ́pịka Hófĩnĩ ꞌbã kí sĩ ãzị́ ngajó Fĩnẽhásĩ be Úpí ní átáló ru rĩ gá. ");
INSERT INTO luc_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Ụ́ꞌdụ́ Ĩlĩkánã ꞌbã sĩ ídétáŋá idéjó rĩ sĩ, ri ĩzá ꞌbã wókõ fẽlé ũkû Pẹ̃nị́nã ní ãzíla vâ anzị ĩꞌdidrị́ ãgọbị rú rĩ ꞌbaní izonzi rú rĩ kí abe pírí. ");
INSERT INTO luc_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Wó Hánã ní rĩ gá ri ĩzá fẽlé pâlékó ị̃rị̃ sĩ ãꞌdusĩku lẽ ándrá ĩꞌdi ambamba Úpí ꞌbã ándrá táni ĩꞌdi atrị agá tịŋá gá cí rá tí. ");
INSERT INTO luc_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Úpí ꞌbã ándrá Hánã atrịjó tịŋá gá cí rĩ sĩ, ãjágô Pẹ̃nị́nã ri ásị́ la ꞌdụlé sĩ ĩꞌdiní ásị́ ãzá fẽjó. ");
INSERT INTO luc_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Ị́jọ́ ꞌdĩ ri ru ngalé Ílí ãlu ãlu sĩ. Hánã drĩ kí mụ jó Úpí drị̂ gá, ãjágô la ĩꞌdiní ásị́ ãzá fẽ kpere ĩꞌdiní awá agá ãzíla Hánã la dó sĩ gã íná nalé úmgbé. ");
INSERT INTO luc_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Ĩlĩkánã Hánã ꞌbã ágô la jọ la ĩꞌdiní, “Hánã, mi awá ãꞌdu ị́jọ́ sĩ yã? Ína ãkónã ku la ãꞌdu ị́jọ́ sĩ yã? Ũcõgõ fi ími ásị́ gá íni sĩ? Áca míní anzị ãgọbị mụdrị́ kí kẹ̃jị́ gá ku yã?” ");
INSERT INTO luc_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Ụ́ꞌdụ́ ãlu ꞌbá ꞌdĩ kí dó mụ ãkónã delé na agá ãzíla ãko mvụlé mvụ-mvụ̃ ri kí abe Sị́lọ̃ gá ꞌdãá ꞌbo, Hánã angá dó pá tulé ụrụgá sĩ Ãdróŋá zịjó. Íni ꞌdĩ átáló Élĩ ri dó úmvúke sị́ gá kẹ̃jị́tị sĩ fijó Hémã Úpí ị̃nzị̃jó rĩ ꞌbã bụ́lụ́ gá. ");
INSERT INTO luc_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Hánã ri dó adrulé ũcõgõ ãmbógó la sĩ, ri dó awálé ãzákírílí ru ĩꞌdiní Úpí zị agâ. ");
INSERT INTO luc_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","ꞌDã ꞌbã ũngúkú gá, na dó ũyõ ãzíla jọ dó, “ꞌBárĩ Úpí Ũkpó ꞌdị́pị, ídrĩ tá ãtíꞌbó mídrị̂ ꞌbã ízákĩzã ndre, ídrĩ tá ị́jọ́ ũrã ĩꞌdi drị̃ gá ãzíla ídrĩ tá ị́jọ́ ãvĩ ĩꞌdi drị̃ gá ku sĩ ĩꞌdiní ngọ́tị́ ágọ́bị́ fẽjó ꞌdã ꞌbã ũngúkú gá ma tá dó ngọ́tị́ ágọ́bị́ ꞌdĩ ꞌdụ fẽlé míní ídri ĩꞌdidrị̂ agá pírí ãzíla ícó tá ĩꞌdi ꞌbã drị̃ꞌbị́ lịlé ku.” ");
INSERT INTO luc_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Hánã ꞌbã dị̃ agá Úpí zị sĩ ꞌdĩ gá ꞌdâ, Élĩ la dị̃ tị la ndre sĩ. ");
INSERT INTO luc_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Hánã ri Ãdróŋá zịlé ásị́ sĩ; tị la ri acị́lé mũꞌdũmũꞌdũ wó âre ĩꞌdi ꞌbã ụ́ꞌdụ́kọ́ ku. Ị́jọ́ ꞌdĩ sĩ Élĩ ũrã dó ĩmẽrã ꞌbãngá wáyĩnĩ sĩ. ");
INSERT INTO luc_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Jọ dó sĩ ĩꞌdiní, “Mi dó ĩmẽrã wáyĩnĩ sĩ ụ́ꞌdụ́ sị́? Lẽ mí aꞌbe wáyĩnĩ mîni ꞌdĩ rá.” ");
INSERT INTO luc_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Wó Hánã umvi ĩꞌdiní, “Yụ, úpí mádrị̂, ámvụ ꞌbãngá wáyĩnĩ ku wó áma úríndí ga tré ũcõgõ sĩ ma mâ mãmálá kí ũꞌbã Úpí drị̃lẹ́ gá. ");
INSERT INTO luc_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Mí ũrã jõ ãtíꞌbó mídrị̂ ĩꞌdi ũkú ãzí ífî kóru la rú ku, ári ꞌbãngá lú Ãdróŋá zịlé ũcõgõ áma ásị́ gá ambamba rĩ sĩ.” ");
INSERT INTO luc_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","ꞌDã ꞌbã ũngúkú gá, Élĩ umvi ĩꞌdiní, “Ímụ ásị́ ị̃gbẹ̃ sĩ, ãzíla Ãdróŋá Ịsịrayị́lị̃ drị̂ ꞌbã fẽ jõ míní ị́jọ́ míní zịlé ĩꞌdi tị gá rĩ rá.” ");
INSERT INTO luc_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Hánã jọ dó sĩ Élĩ ní, “Ãtíꞌbó mídrị̂ ꞌbã ịsụ́ ásị́ ị̃gbẹ́ ími drị̃lẹ́ gá rá fô!” ꞌDã ꞌbã ũngúkú gá, mụ dó rá, na dó ãkónã ãzíla ũcõgõ ĩꞌdi mẹ́lẹ́tị gá rĩ ukó dó rá. ");
INSERT INTO luc_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Ụ́ꞌdụ́ ãzí rĩ sĩ Ĩlĩkánã angá kí ꞌbá ĩꞌdidrị́ kogá rĩ kí abe ụ̃ꞌbụ́tịnị́nị́ ãzíla ị̃nzị̃ kí Úpí ꞌi; ꞌdã ꞌbã ũngúkú gá gõ kí dó vúlé ĩꞌbadrị́ lị́cọ́ gá Rámã gâlé. Ĩlĩkánã icí kí dó ru ũkû Hánã be ãzíla Úpí ũrã dó sĩ Hánã ꞌbã ị́jọ́ rá. ");
INSERT INTO luc_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Sáwã were vúlé gá Hánã ịsụ́ dó ꞌa, tị dó sĩ ngọ́tị́ ágọ́bị́, ꞌda dó rụ́ la Sámụ̃wẹ̃lị̃ ꞌi ãꞌdusĩku jọ, “Ázị ĩꞌdi Úpí tị gá.” ");
INSERT INTO luc_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Ílí ãzí rĩ sĩ, Ĩlĩkánã mụ kí ꞌbá ĩꞌdidrị́ kogá rĩ kí abe ídétáŋá idélé ílí ãlu ãlu sĩ rĩ idéjó Úpí ní ãzíla sĩ ũyõ ándrá ĩꞌdi ꞌbã nalé rĩ ũfẽjó. ");
INSERT INTO luc_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Wó Hánã mụ ĩꞌba abe gẹ̃rị̃ sĩ ku. Jọ dó ágô ní, “Ádrĩ dó mgbâ tị nze ĩbã gá rĩ sĩ ꞌbo, ma dó sĩ cọtị ĩꞌdi agụ jó Úpí drị̂ agá, ị́jọ́ ꞌdĩ sĩ, ĩꞌdi dó sĩ uꞌá ꞌdãá ídri ĩꞌdidrị̂ agá pírí.” ");
INSERT INTO luc_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Ágô Ĩlĩkánã umvi ĩꞌdiní, “Mí idé ị́jọ́ míní ndrelé ĩꞌdi míní múké ãndânĩ rĩ; mí adru lị́cọ́ gá ꞌdâ kpere míní mgbâ tị nze agâ ĩbã gá; lẽ Úpí ꞌbã fẽ ị́jọ́ míní ũyõ najó ꞌbo rĩ ꞌbã idé dó ru nĩ.” ");
INSERT INTO luc_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Ála dó mụ mgbâ tị nzelé ꞌbo, ãndrẽ ꞌdụ dó ĩꞌdi mụjó ĩꞌdi be Sị́lọ̃ gâlé ĩndĩ. ꞌDụ mọ́nị̃gọ́ ílí na la, ãnáfóró kị́lọ̃ mụdrị́ ãzíla wáyĩnĩ íníríkó gá la ĩndĩ, agụ dó sĩ ĩꞌdi jó Úpí drị̂ agâlé mgbâ drĩ ꞌdĩ sĩ ĩmbíráŋá ru. ");
INSERT INTO luc_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Ála dó mụ mọ́nị̃gộ lịlé rá âgụ dó mgbâ Élĩ rụ̂lé ");
INSERT INTO luc_