﻿USE sofia;
DROP TABLE IF EXISTS sofia.lth_vpl;
CREATE TABLE lth_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lth_vpl WRITE;
INSERT INTO lth_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ï acaki Obanga ocweo polo ëka lobo. ");
INSERT INTO lth_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Lobo onwongo obedo atata na gin mörö ope ïë, pïny na cöl onwongo oumo pii na tye ï nam ëka Tipo k'Obanga onwongo olyero ï wi pii. ");
INSERT INTO lth_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Cë Obanga okobo nï, “Ëk tar obed na tye,” ëka tar obedo na tye. ");
INSERT INTO lth_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Obanga önënö nï tar onwongo bër, ëka ën opoko tar kï ï kom pïny na cöl. ");
INSERT INTO lth_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Obanga öcakö nyïng tar nï “kiceng,” ëka pïny na cöl nï “kiwor.” Pïny ocido ëka pïny oru—manön nïnö më acël. ");
INSERT INTO lth_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Cë Obanga okobo nï, “Ëk gin n'öpëdhërë obed na tye ï dyere pii na poko pii kï ï kom pii.” ");
INSERT INTO lth_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Obanga ocweo gin n'öpëdhërë na poko pii na tye pïny kï ï kom pii na tye malö. Ëka obedo nï kömanön. ");
INSERT INTO lth_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Obanga öcakö nyïng gin n'öpëdhërë na poko pii nï “polo.” Pïny ocido ëka pïny oru—manön nïnö më arïö. ");
INSERT INTO lth_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Cë Obanga okobo nï, “Ëk pii na tye ï thë polo ögürë kanya acël ï kabedo acël ëk ngöm n'öthwö onen.” Ëka obedo nï kömanön. ");
INSERT INTO lth_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Obanga öcakö nyïng ngöm n'öthwö nï “lobo” ëka pii n'ögürë kanya acël öcakö nyïngë nï “nam.” Ëka Obanga önënö onwongo nï bër. ");
INSERT INTO lth_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Cë Obanga okobo nï, “Ëk gin na mar otuu ï wi lobo: gin n'ëpïdhö na nyakö nyig-gï ëka yen na tye ï lobo na nyakö nyig-gï na kodhi tye ïë, na lübërë kï kothgï.” Ëka obedo nï kömanön. ");
INSERT INTO lth_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Gin na mar öcakö tuu ï wi lobo: gin n'ëpïdhö na nyakö nyig-gï na lübërë kï kothgï ëka yen na nyakö nyig-gï na kodhi tye ïë na lübërë kï kothgï. Ëka Obanga önënö onwongo nï bër. ");
INSERT INTO lth_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Pïny ocido ëka pïny oru—manön nïnö më adek. ");
INSERT INTO lth_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Cë Obanga okobo nï, “Ëk jami na mïö tar obed na tye ï wi polo më poko kiceng kï ï kom kiwor, ëk gïn obed na calö anyuth më poko karë, nïnö ëka mwaka, ");
INSERT INTO lth_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ëk obed gïnï tar na ryëny kï ï wi polo më mënyö wi lobo.” Ëka obedo nï kömanön. ");
INSERT INTO lth_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Obanga ocweo jami arïö na thwon na ryëny—mana thwönë më löönö kiceng, ëka mana tïdï më löönö kiwor. Ën thon oketho cër. ");
INSERT INTO lth_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Obanga okethogï ï wi polo më mënyö lobo, ");
INSERT INTO lth_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","më löönö kiceng ëka kiwor, ëka më poko tar kï ï kom pïny na cöl. Ëka Obanga önënö onwongo nï bër. ");
INSERT INTO lth_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Pïny ocido ëka pïny oru—manön nïnö më angwën. ");
INSERT INTO lth_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Cë Obanga okobo nï, “Ëk gin na kwö opong ï pii më nam, ëka wïny öngwëc gïnï malö ï wi polo.” ");
INSERT INTO lth_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Obanga ocweo leeni na thwon më nam, gin na kwö kïbëc na bedo ï nam, na lübërë kï kothgï, ëka kï wïny na bwomgï tye na lübërë kï kothgï. Ëka Obanga önënö onwongo nï bër. ");
INSERT INTO lth_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Obanga ömïögï gum ëka okobo nï, “Nywöl ïnya unu, ipong unu ï pii na tye ï nam, ëka wïny thon önya ï wi lobo.” ");
INSERT INTO lth_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Pïny ocido ëka pïny oru—manön nïnö më abic. ");
INSERT INTO lth_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Cë Obanga okobo nï, “Ëk gin na kwö obed tye ï wi lobo na lübërë kï kothgï: leeni më pacö, leeni na wotho ï wi ngöm kï korgï, ëka leeni më thim, acëlacël kï kothe.” Ëka obedo nï kömanön. ");
INSERT INTO lth_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Obanga ocweo leeni më thim na lübërë kï kothgï, leeni më pacö na lübërë kï kothgï, ëka leeni na wotho ï wi ngöm kï korgï na lübërë kï kothgï. Ëka Obanga önënö onwongo nï bër. ");
INSERT INTO lth_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Cë Obanga okobo nï, “Eru ecweu dhanö na cal kï onu, ëka ëmïïgï ölöö rëc më ï nam, wïny na ngwëcö kï malö, leeni më pacö, wi lobo thükül, ëka leeni na wotho ï wi ngöm kï korgï.” ");
INSERT INTO lth_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Cë Obanga ocweo dhanö ï cal mërë kikokome, Obanga ocweogï ï cal mërë, ocweo ëcwö ëka dhakö. ");
INSERT INTO lth_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Obanga ömïögï gum ëka okobo nï, “Nywöl ïnya unu, ipong unu lobo ëka ïlöö unu. Löö unu rëc na tye ï nam, wïny na ngwëcö kï malö, ëka gin na kwö kïbëc na wotho ï wi ngöm.” ");
INSERT INTO lth_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Cë Obanga okobo nï, “An amïöwu kodhi kïbëc më wi lobo thükül na nyakö nyig-gï ëka yen kïbëc na nyakö nyig-gï na kodhi tye ï ïgï. Un ibino camögï. ");
INSERT INTO lth_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ëka leeni kïbëc më thim, wïny kïbëc na ngwëcö malö, leeni kïbëc na wotho ï wi ngöm—jami kïbëc na yweo na kwö tye ï komgï—an amïö jami kïbëc na mar më acamagï.” Ëka obedo nï kömanön. ");
INSERT INTO lth_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Obanga önënö jami kïbëc na ën ocweo, ëka onwongo nï bër rwök. Pïny ocido ëka pïny oru—manön nïnö më abicël. ");
INSERT INTO lth_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Cë Obanga otyeko cweno polo ëka lobo kï jami kïbëc na tye ïë. ");
INSERT INTO lth_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ï nïnö më abïrö, Obanga onwongo otyeko tic mërë na ën obedo ka tïmö, ëka oyweo kï ï kom tic mërë kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ëka Obanga ömïö gum ï kom nïnö më abïrö cë ömïö ödökö na leng, pïën ï nïnö nön ën oyweo kï ï kom tic mërë kïbëc më cwec na ën otio. ");
INSERT INTO lth_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Man ënë kite na polo ëka lobo öcakërë ködë ï karë n'ecweogï. Ï karë na Rwoth Obanga ocweo lobo ëka polo— ");
INSERT INTO lth_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","yath mörö më thim onwongo bara tye ï wi lobo ëka kit lum mörö më thim onwongo bara otuu, pïën Rwoth Obanga onwongo bara ömïö köth ocwe ï wi lobo ëka dhanö mörö onwongo ope na myero opur ngöm, ");
INSERT INTO lth_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ëntö pii öcakö cwer kï ï ngöm ï wi lobo ëka obido wi ngöm kïbëc— ");
INSERT INTO lth_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","cë Rwoth Obanga ocweo dhanö kï ï apua më ngöm, öküdhö yamö më kwö ï ume, ëka dhanö ödökö gin na kwö. ");
INSERT INTO lth_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Rwoth Obanga oketho pwodho ï Eden, kï kukïdë, ëka oketho dhanö na ën ocweo kunön. ");
INSERT INTO lth_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ëka Rwoth Obanga oketho koth yen kïbëc më tuu kï ï ngöm—yen n'onwongo bër kï ï wang jö ëka bër më acama. Yath më kwö ëka yath më ngeo gin na bër ëka gin na rac onwongo tye ï dyere pwodho. ");
INSERT INTO lth_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Kulo onwongo molo yaa kï ï Eden na kelo pii ï pwodho, ëka kï kany nön pokere ï kulo angwën. ");
INSERT INTO lth_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Nyïng kulo më acël ënë Picon, ën möl rimo lobo Kabila kïbëc, kanya gol nwongere ïë. ");
INSERT INTO lth_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Gol më lobo nön bër; odok yath n'ecwodo nï bedola ëka kite na welgï tëk n'ecwodo nï onik tye thon kunön.) ");
INSERT INTO lth_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Nyïng kulo më arïö ënë Gikon, ën möl rimo lobo Kuc kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Nyïng kulo më adek ënë Tigiric, ën möl dök yo kukïdë Aciria. Ëka kulo më angwën ënë Euparate. ");
INSERT INTO lth_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Rwoth Obanga ökwanyö dhanö cë oketho ï pwodho më Eden ëk ën opur ëka ögwökï. ");
INSERT INTO lth_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ëka Rwoth Obanga öcïkö dhanö nï, “In ïtwërö camö nyig yath mörö këkën na tye ï pwodho, ");
INSERT INTO lth_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ëntö yath më ngeo gin na bër ëka gin na rac, in myero kür ïcam, pïën ï nïnö na in ibino camö nyig yath nön, ënë in ibino thöö ködë.” ");
INSERT INTO lth_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Cë Rwoth Obanga dökï okobo nï, “Ba bër nï dhanö myero obed kënë. Pï manön, an abino cweno ngat na könyö ën n'opore pïrë.” ");
INSERT INTO lth_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Cë Rwoth Obanga onwongo dong ocweo leeni më thim kïbëc kï kom ngöm ëka wïny kïbëc na ngwëcö kï malö. Ën okelogï both dhanö ëk önën kite na myero öcak kï nyïng-gï ködë, ëka nyïng mörö na dhanö öcakö kï gin na kwö acëlacël, manön dökö nyïngë. ");
INSERT INTO lth_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Dhanö öcakö nyïng leeni më pacö kïbëc, wïny na ngwëcö kï malö ëka leeni më thim kïbëc. Ëntö ngat na myero ököny Adam n'opore pïrë onwongo pod ope. ");
INSERT INTO lth_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Cë Rwoth Obanga ömïö nïnö ömakö wang dhanö rwök, ï karë na ën tye ka nïnö, Obanga ökwanyö cogo lak nget dhanö acël ëka ömwönö kakarë kï ringo. ");
INSERT INTO lth_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Cë Rwoth Obanga ocweo dhakö kï ï kom cogo lak nget na ën ökwanyö kï ï kom dhanö, ëka okelo dhakö both dhanö. ");
INSERT INTO lth_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Cë Dhanö okobo nï, “Man ënë cogo më cogona ëka ringo më ringo koma, ebino cwodo ën nï ‘dhakö,’ pïën ëkwanyö ën kï ï kom dhanö.” ");
INSERT INTO lth_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Pï tyën köp ni ëcwö bino wëkö apap mërë ëka aya mërë cë rïbërë kï dhakö mërë ëka jö arïö bino dökö kom acël. ");
INSERT INTO lth_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ï karë nön ëcwö kï dhakö mërë onwongo tye gïnï kotula ëka lewic onwongo ba makögï. ");
INSERT INTO lth_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Thwol onwongo obedo lee na ryëk n'obedo jö ököra kï kin leeni më thim na Rwoth Obanga onwongo ocweo. Ï nïnö mörö acël, thwol obino cë okobo both dhakö nï, “Adyer Obanga okobo nï, ‘Un myero kür ïcam nyig yath mörö këkën kï ï pwodho’?” ");
INSERT INTO lth_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Dhakö okobo both thwol nï, “Wan ëtwërö camö nyig yen kïbëc na tye ï pwodho, ");
INSERT INTO lth_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ëntö Obanga okobo nï, ‘Kür ïcam unu nyig yath na tye ï dyere pwodho, ëka kür igud unu; ka ïcamö unu, ibino unu thöö.’” ");
INSERT INTO lth_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ëntö thwol okobo both dhakö nï, “Adyer un ba ibino thöö. ");
INSERT INTO lth_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Pïën Obanga ngeo nï ka ïcamö unu, wangwu bino yabërë, ëka ibino bedo unu calö Obanga, nakun ingeo unu gin na bër ëka gin na rac.” ");
INSERT INTO lth_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ï karë na dhakö önënö nï nyig yath onwongo bër më acama, nen na bër kï ï wang jö ëka thon twërö mïö ryëkö, dhakö öpüdö ëka öcamö. Ën thon ömïö nökënë both cwörë n'onwongo tye ködë kanya acël cë öcamö. ");
INSERT INTO lth_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Cë gïn jö arïö kïbëc wang-gï öyabërë ökö, ëka ongeo gïnï nï etye gïnï kotula, gïn öcakö kwönö pot ölam kanya acël më umo komgï. ");
INSERT INTO lth_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Cë gïn owinyo Rwoth Obanga ka tye ka woth ï pwodho ï caa na pïny okwe, ëka opono gïnï ökö kï both Rwoth Obanga ï kin yen na tye ï pwodho. ");
INSERT INTO lth_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ëntö Rwoth Obanga ocwodo Adam nï, “In itye kwene?” ");
INSERT INTO lth_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Dhanö ögamö nï, “An awinyo ka in itye ka woth ï pwodho ëka an abedo na lwor pïën onwongo atye kotula, cë an apono.” ");
INSERT INTO lth_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ëka Rwoth Obanga okobo nï, “Nga n'okobo nï in itye kotula? In ïcamö nyig yath na an acïkö nï kür ïcam?” ");
INSERT INTO lth_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Dhanö okobo nï, “Dhakö na in ïmïö botha ënë ömïa nyig yath ëka acamö.” ");
INSERT INTO lth_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Cë Rwoth Obanga openyo dhakö nï, “Ngö ene na in ïtïmö?” Dhakö ögamö nï, “Thwol öbwöla ëka acamö.” ");
INSERT INTO lth_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Rwoth Obanga okobo both thwol nï, “Pïën in ïtïmö man, “In elami na löö kï kin leeni më pacö kïbëc, ëka leeni më thim kïbëc! In ibino ywari kï ii ëka ibino camö apua ï karë më kwöni kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","An abino ketho adagë ï kin in ëka dhakö, ëka ï kin ëkwaëni ëka ëkwaë mërë, akwarë bino göönö wi, ëka in ibino tongo opunye.” ");
INSERT INTO lth_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Cë ën okobo both dhakö nï, “An abino mëdö arem na thwönë rwök ï karë më nywöl; in ibino nywölö ëthïnö k'arem. Mitini bino bedo ï kom cwori, ëka ën bino löönöni.” ");
INSERT INTO lth_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ëka okobo both Adam nï, “Pïën in iwinyo köp ka dhaköni ëka ïcamö nyig yath n'onwongo aciki nï, ‘In myero kür ïcam,’ “Ëlamö ngöm ökö piri ibino tic na tëk k'arem ëka ibino cem pï karë më kwöni kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ngöm bino cëgö okudhi ëka öcöcök, ëntö in ibino camö ngwedo më thim. ");
INSERT INTO lth_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","In ibino camö cem kï kwok na cwer kï ï terinyimi, naka ka ibino dök ï ngöm, kite na yam ekwanyi kï ï apua, pïën in ibedo apua, ëka ibino dök ï apua.” ");
INSERT INTO lth_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam öcakö nyïng dhakö mërë Eba, pïën ën bino dökö aya ka jö na kwö kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Rwoth Obanga öyübö lör lee, ömïö both Adam ëka dhakö mërë cë oruko gïnï. ");
INSERT INTO lth_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ëka Rwoth Obanga okobo nï, “Dhanö dong ödökö ngat na cal kï onu, nakun ngeo poko gin na bër ëka gin na rac. Kür dökï ëmïï öryë cïngë më püdö nyig yath më kwö ëka öcam cë ökwö pï naka naka.” ");
INSERT INTO lth_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Pï manön Rwoth Obanga öryëmögï ökö kï ï pwodho më Eden më cïdhö puro ngöm na yam ëkwanyö ën kï ïë. ");
INSERT INTO lth_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Kinge na dong öryëmö dhanö ökö, ën oketho cerubim yo kukïdë më pwodho më Eden. Ëka oketho pala abadë na lyël mac, wïrë tungi ëka tungi, më gwökö yoo na cïdhö yo yath më kwö. ");
INSERT INTO lth_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam obedo kï dhakö mërë Eba, cë öyac ëka önywölö Kain, nakun kobo nï, “Rwoth ökönya ömïö anwongo athïn n'ëcwö.” ");
INSERT INTO lth_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kinge ën önywölö ömïn mërë Abel. Abel ödökö akwath, ëka Kain ödökö apur pwodho. ");
INSERT INTO lth_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kinge karë mörö, Kain okelo cem mörö kï ï pwodho mërë ömïö both Rwoth na calö mïc. ");
INSERT INTO lth_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ëntö Abel okelo ëthïn rom mërë n'obedo kaö kï dwologï. Rwoth cwinye obedo na yom ï kom Abel ëka oyeo mïc mërë, ");
INSERT INTO lth_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ëntö Rwoth ba oyeo Kain kï mïc mërë. Cë man ömïö Kain ökëcö na cwinye ba yom. ");
INSERT INTO lth_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Cë Rwoth openyo Kain nï, “Pïngö in ïkëcö? Pïngö cwinyi ba yom? ");
INSERT INTO lth_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ka in ïtïmö gin na tye atïr, ba ebino yeeno? Ëntö ka in ba ïtïmö gin na tye atïr, bal buto ï dholokek na calö lee na ger më kürö nekoni, ëntö in myero ïlöö ën.” ");
INSERT INTO lth_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kain okobo both ömïn mërë Abel nï, “Ërö ëcïdhï ï pwodho.” Ëka ï karë na gïn tye ï pwodho, Kain öcakö lwëny ï kom ömïn mërë Abel ëka oneko ökö. ");
INSERT INTO lth_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Cë Rwoth okobo both Kain nï, “Omeru Abel tye kwene?” Ën ögamö nï, “An ba angeo, an abedo ngat na gwökö ömëra?” ");
INSERT INTO lth_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Rwoth okobo both Kain nï, “Ngö na in ïtïmö? Winy kany! Remo k'omeru tye ka kok botha kï ï ngöm. ");
INSERT INTO lth_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kobedi dong elami ëka eryemi ökö kï ï ngöm, n'ongamo dhögë më madhö remo k'omeru na in ïönyö. ");
INSERT INTO lth_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ngöm ba dök bino cëgö cem nini ka ipuro. In ibino bedo ngat na lathö alatha na parë ope wi lobo.” ");
INSERT INTO lth_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Cë Kain okobo both Rwoth nï, “Pwod na in ïmïa pëk na ba arömö dangö. ");
INSERT INTO lth_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Nën! Tin dong itye ka ryëmöna ökö kï ï pwodho, ëka an ba dök abino nen ï nyimi. An abino bedo ngat na lathö alatha ï wi lobo, ëka ngat mörö këkën na bino nwongona bino nekona.” ");
INSERT INTO lth_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ëntö Rwoth okobo bothe nï, “Pathï nï kömanön, ka ngat mörö oneko Kain, ebino cülö kwor ï kome wang abïrö.” Cë Rwoth oketho alama ï kom Kain ëk ka ngat mörö onwongo ën kür oneki. ");
INSERT INTO lth_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kain öya ökö kï ï nyim Rwoth cë öcïdhö obedo ï lobo Nod na tye kukïdë më Eden. ");
INSERT INTO lth_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain obedo kï dhakö mërë, ëka öyac cë önywölö Enoka. Kain ögërö pacö na dit ëka öcakö kï nyïng wode Enoka. ");
INSERT INTO lth_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoka önywölö Irad, Irad önywölö Mekujael, Mekujael önywölö Metucael, ëka Metucael önywölö Lamek. ");
INSERT INTO lth_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek önyömö mon arïö, acël nyïngë Ada ëka nökënë ca nyïngë Jila. ");
INSERT INTO lth_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada önywölö Jabal, ën onwongo obedo kwarö ka jö na bedo gïnï ï këma ëka gwökö leeni më pacö. ");
INSERT INTO lth_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ömïn mërë nyïngë onwongo ecwodo nï Jubal, ën onwongo obedo kwarö ka jö kïbëc na göö adungu ëka küdhö oletu. ");
INSERT INTO lth_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Jila thon önywölö wode, Tubal Kain, na ënë obedo athedh jami më tic kïbëc më mola ëka nywenyo. Amïn Tubal Kain onwongo ecwodo nï Naama. ");
INSERT INTO lth_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ï nïnö mörö acël, Lamek okobo both mon mërë nï, “Winya unu, un mon-na, winy unu köpna. An aneko dhanö n'ömïa ret, aneko awobi pï wanöna. ");
INSERT INTO lth_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ka ebino cülö kwor ka Kain wang abïrö, cë më ka Lamek bino bedo wang pyer abïrö wie abïrö.” ");
INSERT INTO lth_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam obedo kï dhakö mërë dökï, ëka önywölö wode cë öcakö nyïngë Ceth, nakun kobo nï, “Obanga ömïa athïn nökënë dökï n'oleo kakar Abel na Kain oneko.” ");
INSERT INTO lth_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ceth thon önywölö wode ëka öcakö nyïngë Enoc. Ï karë nön jïï öcakö wörö Rwoth nakun etio kï nyïngë. ");
INSERT INTO lth_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Man ënë cöc na nyutho ëkwaë k'Adam. Ï karë n'Obanga ocweo dhanö, ën ocweo na cal ködë. ");
INSERT INTO lth_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ën ocweogï ëcwö ëka dhakö cë ömïögï gum. Ëka ï karë na ën ocweogï, öcakö nyïng-gï “Dhanö.” ");
INSERT INTO lth_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ï karë na dong Adam obedo ï wi lobo pï mwaka 130, ën önywölö wode na cal ködë kikokome, ëka öcakö nyïngë Ceth. ");
INSERT INTO lth_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Kinge na dong ënywölö Ceth, Adam obedo ï wi lobo pï mwaka 800 nakun onwongo önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam obedo ï wi lobo pï mwaka 930 kïbëc ëka öthöö. ");
INSERT INTO lth_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ï karë na dong Ceth obedo ï wi lobo pï mwaka 105, ën obino önywölö Enoc. ");
INSERT INTO lth_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ëka kinge na ën dong önywölö Enoc, Ceth obedo ï wi lobo pï mwaka 807 nakun onwongo önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ceth obedo ï wi lobo pï mwaka 912 kïbëc ëka öthöö. ");
INSERT INTO lth_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ï karë na dong Enoc obedo ï wi lobo pï mwaka 90, ën obino önywölö Kenan. ");
INSERT INTO lth_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ëka kinge na ën dong önywölö Kenan, Enoc obino obedo ï wi lobo pï mwaka 815 nakun önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoc obino obedo ï wi lobo pï mwaka 905 kïbëc ëka öthöö. ");
INSERT INTO lth_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ï karë na dong Kenan obedo ï wi lobo pï mwaka 70, ën obino önywölö Malalel. ");
INSERT INTO lth_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ëka ï karë na ën dong önywölö Malalel, Kenan obino obedo ï wi lobo pï mwaka 840 nakun onwongo önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan obino obedo ï wi lobo pï mwaka 910 kïbëc ëka öthöö. ");
INSERT INTO lth_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ï karë na dong Malalel obedo ï wi lobo pï mwaka 65, ën obino önywölö Jared. ");
INSERT INTO lth_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ëka kinge na ën dong önywölö Jared, Malalel obino obedo ï wi lobo pï mwaka 830 nakun onwongo önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Malalel obino obedo ï wi lobo pï mwaka 895 kïbëc ëka öthöö. ");
INSERT INTO lth_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ï karë na dong Jared obedo ï wi lobo pï mwaka 162, ën obino önywölö Enoka. ");
INSERT INTO lth_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ëka ï karë na ën dong önywölö Enoka, Jared obino obedo ï wi lobo pï mwaka 800 nakun onwongo önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared obino obedo ï wi lobo pï mwaka 962 kïbëc ëka öthöö. ");
INSERT INTO lth_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ï karë na dong Enoka obedo ï wi lobo pï mwaka 65, ën obino önywölö Methucela. ");
INSERT INTO lth_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ëka kinge na ën dong önywölö Methucela, Enoka obino ökwö ï nyim Obanga ï yoo n'opore pï mwaka 300 nakun onwongo önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoka obino obedo ï wi lobo pï mwaka 365 kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoka ökwö ï nyim Obanga ï yoo n'opore ëka obino orwenyo, pïën Obanga otero ën ökö. ");
INSERT INTO lth_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ï karë na dong Methucela obedo ï wi lobo pï mwaka 187, ën obino önywölö Lamek. ");
INSERT INTO lth_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ëka kinge na ën dong önywölö Lamek, Methucela obino obedo ï wi lobo pï mwaka 782 nakun onwongo önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methucela obino obedo ï wi lobo pï mwaka 969 kïbëc ëka öthöö. ");
INSERT INTO lth_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ï karë na dong Lamek obedo ï wi lobo pï mwaka 182, ën obino önywölö wode. ");
INSERT INTO lth_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Cë öcakö nyïngë Noa ëka okobo nï, “Ën bino kelo nïwa yweo kï ï tic më cïngwa na wan eyelere ïë ï kom ngöm na Rwoth ölamö.” ");
INSERT INTO lth_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Kinge na dong ënywölö Noa, Lamek obino obedo ï wi lobo pï mwaka 595 nakun onwongo önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamek obino obedo ï wi lobo pï mwaka 777 ëka öthöö. ");
INSERT INTO lth_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Kinge na dong Noa tye kï mwaka 500, ën obino önywölö Cem, Kam ëka Yapec. ");
INSERT INTO lth_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ï karë na dhanö öcakö nya ï wi lobo ëka önywölö gïnï anyira, ");
INSERT INTO lth_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","awope k'Obanga önënö nï anyira ka dhanö bëcö, ëka öcakö gïnï nyömö mökö kï ï kin-gï na gïn öyërö. ");
INSERT INTO lth_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Cë Rwoth okobo nï, “Tipona ba bino bedo ï kom dhanö pï naka naka, pïën ën obedo kom na thöö, nïnö më kwögï bino bedo mwaka 120 këkën.” ");
INSERT INTO lth_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Jö Nepili onwongo tye gïnï ï wi lobo ï karë nonu—ëka kinge—ï karë n'awope k'Obanga obedo gïnï k'anyira ka dhanö ëka önywölö ködgï ëthïnö. Gïn ënë onwongo jö na tëk ï karë na cön, ëka jö na ngere. ");
INSERT INTO lth_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Rwoth önënö nï bal ka jö na tye ï wi lobo ödökö na thwönë rwök, ëka thama më cwinygï kïbëc opong më tïmö gin na reco këkën ï karë kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Rwoth cwinye ba obedo na yom pï cweno dhanö ï wi lobo, cë cwinye ocwer rwök. ");
INSERT INTO lth_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ëka Rwoth okobo nï, “Abino tyeko dhanö na yam acweo ï wi lobo—dhanö ëka leeni, ëka gin n'ecweo kïbëc na wotho ï wi ngöm, ëka wïny na ngwëcö kï malö—pïën cwinya ba yom nï acweogï.” ");
INSERT INTO lth_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ëntö Rwoth onwongo tye kï cwiny na bër ï kom Noa. ");
INSERT INTO lth_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Man ënë ëkwaë ka Noa. Noa onwongo obedo dhanö na kite atïr abonge bal mörö kï ï kin jïï ï karë mërë, ëka obedo kwö ï nyim Obanga ï yoo n'opore. ");
INSERT INTO lth_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa onwongo tye ka awope mërë adek: Cem, Kam ëka Yapec. ");
INSERT INTO lth_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Lobo onwongo öbal ökö kï ï nyim Obanga ëka opong kï tïm më gero. ");
INSERT INTO lth_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Obanga önënö kite na lobo öbal ködë, pïën jö kïbëc na tye ï wi lobo onwongo öbalö kwögï ökö. ");
INSERT INTO lth_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Cë Obanga okobo both Noa nï, “An amoko thamana më tyeko gin na kwö kïbëc na tye ï wi lobo, pïën gïn ömïö lobo opong kï tïm më gero. An abino tyekogï ökö kanya acël ëka kï wi lobo. ");
INSERT INTO lth_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Pï manön yüb dong yeya kï bao më yath caiprac; pok ïë na papath, ëka ipu ïë ëka kungee k'odok lam. ");
INSERT INTO lth_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Man ënë kite na myero in ïyüb ködë: Bor ka yeya myero obed mita 135, lac mërë mita 22 ëka bor mërë yo malö myero obed mita 13. ");
INSERT INTO lth_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gër wi yeya ëka ityek ökö nakun ïwëkö malö mërë dong nucu mita. Keth dholokek ï kom yeya kucël ëka ipok ïë kör adek—pïny, dyere ëka malö. ");
INSERT INTO lth_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","An abino kelo abwal pii ï wi lobo më tyeko gin na kwö kïbëc na tye ï thë polo, gin n'ecweo kïbëc na tye kï kwö ï komgï. Gin na kïbëc na tye ï wi lobo bino thöö ökö. ");
INSERT INTO lth_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ëntö an abino ketho cïkërëna kodi, ëka in ibino dönyö ï yeya—in ëka awopeni, dhaköni ëka mon k'awopeni. ");
INSERT INTO lth_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","In myero ikel ï yeya jami kïbëc na kwö ka arïö arïö, lee n'obedo ëcwö ëka lee n'obedo dhakö, ëk obed gïnï na kwö kanya acël kodi. ");
INSERT INTO lth_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Koth wïny na papath arïö ëcwö kï dhakö, koth leeni na papath arïö ëcwö kï dhakö ëka gin n'ecweo kïbëc na wotho ï wi ngöm bino gïnï bino bothi ëk ïgwökgï obed na kwö. ");
INSERT INTO lth_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ter koth cem na papath më acama ëk ïgwökï më acamani ëka pï leeni kïbëc.” ");
INSERT INTO lth_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa ötïmö gin na kïbëc kite n'Obanga öcïkö ën ködë. ");
INSERT INTO lth_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Cë Rwoth okobo both Noa nï, “Cïdh ï öd yeya, in ëka jö më odi kïbëc, pïën an anwongo nï in ënë kiteni atïr kï ï kin rok më karë ni. ");
INSERT INTO lth_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ter koth leeni n'ëcamö abïrö ka arïö arïö, lee n'obedo ëcwö ëka lee n'obedo dhakö, ëka koth leeni na ba ëcamö ka arïö arïö, lee n'obedo ëcwö ëka lee n'obedo dhakö, ");
INSERT INTO lth_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ëka thon koth wïny abïrö, wïnyü n'obedo ëcwö ëka wïnyü n'obedo dhakö, më gwökö kothgï bedo na kwö ï wi lobo kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Cakërë kobedini kinge nïnö abïrö, an abino mïö köth cwe ï wi lobo pï nïnö pyer angwën kiceng ëka kiwor, ëka an abino tyeko gin na kwö kïbëc na tye ï wi lobo na an acweo.” ");
INSERT INTO lth_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ëka Noa ötïmö gin na kïbëc na Rwoth öcïkö ën më tïmö. ");
INSERT INTO lth_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa onwongo dong tye kï mwaka 600 ï karë n'abwal pii opong ï wi lobo. ");
INSERT INTO lth_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ëka Noa, awope mërë, dhakö mërë ëka mon k'awope mërë ödönyö gïnï ï yeya më bwöth kï ï abwal pii. ");
INSERT INTO lth_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Leeni n'ëcamö ëka leeni na ba ëcamö ka arïö arïö, wïny ëka gin n'ecweo kïbëc na wotho ï wi ngöm, ");
INSERT INTO lth_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","n'obedo ëcwö ëka n'obedo dhakö obino gïnï both Noa ëka ödönyö gïnï ï yeya, kite n'Obanga öcïkö Noa ködë. ");
INSERT INTO lth_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ëka kinge nïnö abïrö abwal pii opong ï wi lobo. ");
INSERT INTO lth_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ï mwaka 600 më kwö ka Noa, ï nïnö dwe apar abïrö më dwe më arïö—ï nïnö nön wang pii kïbëc omwoc ëka polo thon öyabërë. ");
INSERT INTO lth_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ëka köth ocwee ï wi lobo pï nïnö pyer angwën, kiceng ëka kiwor. ");
INSERT INTO lth_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ï nïnö nön kikokome Noa ëka awope mërë, Cem, Kam ëka Yapec, kanya acël kï dhakö mërë ëka mon k'awope mërë adek, ödönyö gïnï ï yeya. ");
INSERT INTO lth_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Gïn ödönyö kanya acël kï leeni më thim kïbëc na lübërë kï kothgï, leeni më pacö kïbëc na lübërë kï kothgï, gin n'ecweo kïbëc na wotho ï wi ngöm na lübërë kï kothgï ëka wïny kïbëc na lübërë kï kothgï, gin na kïbëc na tye kï bwomgï. ");
INSERT INTO lth_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Gin n'ecweo kïbëc na tye kï yweo më kwö ï komgï obino gïnï both Noa ëka ödönyö gïnï ï öd yeya ka arïö arïö. ");
INSERT INTO lth_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Leeni na papath n'obedo cwö ëka mon, kite n'Obanga öcïkö ën ködë obino ödönyö gïnï ï yeya both Noa. Cë Rwoth ocegogï ï öd yeya. ");
INSERT INTO lth_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Köth obedo cwee ï wi lobo pï nïnö pyer angwën, ëka abwal pii opong ï wi lobo naka otingo yeya malö kï ï kom lobo. ");
INSERT INTO lth_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Köth ocwee ëka ömïö pii ömëdërë rwök ï wi lobo naka yeya olyero ï wi pii. ");
INSERT INTO lth_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Köth ocwee rwök ï wi lobo naka ömïö pii oumo kite na boco kïbëc na tye ï thë polo. ");
INSERT INTO lth_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Köth ömëdërë kï cwee ï wi lobo naka pii ömwönyö wi kite na kadhö puti pyer arïö. ");
INSERT INTO lth_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Gin mörö këkën na kwö n'onwongo wotho ï wi lobo—wïny, leeni më pacö, leeni më thim, gin n'ecweo kïbëc na wotho ï wi ngöm ëka kï jïï kïbëc öthöö gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Gin na kïbëc na tye ï wi ngöm n'onwongo tye kï yweo më kwö ï kome öthöö ökö. ");
INSERT INTO lth_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Gin na kwö kïbëc n'onwongo tye ï wi lobo etyekogï ökö; dhanö, leeni, gin n'ecweo kïbëc na wotho ï wi ngöm ëka wïny kïbëc na ngwëcö kï malö etyekogï ökö kï ï wi lobo. Noa ëka jö n'onwongo tye ködë ï yeya këkën ënë odong. ");
INSERT INTO lth_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Abwal pii opong ï wi lobo pï nïnö 150. ");
INSERT INTO lth_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ëntö Obanga opo ï kom Noa kï leeni më thim kïbëc, ëka kï leeni më pacö n'onwongo tye kanya acël ködë ï yeya, ëka ooro yamö ï wi lobo, cë pii öcakö dwon ökö. ");
INSERT INTO lth_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Wang pii na thuth kï ï ngöm ëka pii na yaa kï ï polo ocung ökö, cë köth kï ï polo ocok ökö. ");
INSERT INTO lth_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Pii ömëdërë më dwon kï ï wi lobo. Kinge nïnö 150, pii onwongo odwon ökö. ");
INSERT INTO lth_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ï nïnö dwe apar abïrö më dwe më abïrö, yeya obino ocung ï wi kite më Ararat. ");
INSERT INTO lth_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Pii ömëdërë më dwon naka ï dwe më apar, ëka ï nïnö më acël më dwe më apar, wi kite na boco öcakö gïnï nen. ");
INSERT INTO lth_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Kinge nïnö pyer angwën, Noa öyabö wang derica n'onwongo ën otuco ï kom yeya, ");
INSERT INTO lth_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ëka ooro akürük yökö, cë öcakö ngwëc, nakun wïrë tungi kï tungi, naka pii öthwö ökö kï ï wi lobo. ");
INSERT INTO lth_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Cë Noa ooro amam më nënö ka pii dong odwon ökö kï ï wi ngöm. ");
INSERT INTO lth_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ëntö amam ba onwongo kanya myero epye ïë, pïën pii onwongo pod tye ï wi lobo kïbëc. Cë amam öcakö dök cen both Noa ï yeya. Noa olyao cïngë ëka ögamö amam cë odwongo yo bothe ï yeya. ");
INSERT INTO lth_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ën ökürö pï nïnö abïrö nökënë, ëka dökï ooro amam yo yökö kï ï yeya. ");
INSERT INTO lth_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ï karë n'amam ödök bothe ï yeya kothyeno, amam onwongo otingo pot yath jeituni na thïc ï dhögë na ën öpüdö. Cë Noa önïang nï pii dong otyeko dwon ökö kï ï wi lobo. ");
INSERT INTO lth_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Cë Noa ökürö pï nïnö abïrö nökënë, ëka dökï ooro amam, ëntö amam ba dök odwogo bothe. ");
INSERT INTO lth_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ï karë na Noa onwongo dong tye kï mwaka 601, ï nïnö më acël më dwe më acël më mwaka na nyen, pii onwongo dong odwon ökö kï ï wi lobo. Noa öcakö pudho wi yeya ökö, cë önënö nï wi ngöm onwongo öthwö ökö. ");
INSERT INTO lth_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ï nïnö dwe pyer arïö wie abïrö më dwe më arïö, wi lobo kïbëc onwongo öthwö ökö. ");
INSERT INTO lth_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Cë Obanga okobo both Noa nï, ");
INSERT INTO lth_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Donyi yökö kï ï yeya, in ëka dhaköni, awopeni ëka mon-gï. ");
INSERT INTO lth_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kel gin na kwö kïbëc na tye gïnï kanya acël kodi yökö—wïny, leeni ëka gin na kïbëc na wotho gïnï kï korgï ï wi ngöm—ëk önya gïnï ï wi lobo, önywöl gïnï ëka ömëdërë na pol ï wi lobo.” ");
INSERT INTO lth_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Cë Noa odonyo yökö, kanya acël k'awope mërë, dhakö mërë, ëka mon k'awope mërë. ");
INSERT INTO lth_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Leeni kïbëc, gin na kïbëc na wotho kï korgï ï wi ngöm, ëka wïny kïbëc—gin na kïbëc na wotho ï wi lobo—odonyo gïnï yökö kï ï yeya, na lübërë kï kothgï. ");
INSERT INTO lth_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Cë Noa ögërö keno tyër both Rwoth ëka ökwanyö koth leeni kï wïny n'ëcamögï, ëka ötyërö tyër awanga ï wi keno tyër. ");
INSERT INTO lth_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Rwoth ongweo gin na ngwece kur na yomo cwinye, cë Rwoth okobo kï ï cwinye kënë nï, “An ba dökï abino lamö lobo pï dhanö, kadï bed thama më cwinye opong kï bal cakërë kï ï karë më thino mërë. An ba dökï abino neko gin na kwö kïbëc kite na yam atïmö. ");
INSERT INTO lth_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Ka lobo pod tye, karë më cwöc ëka kac, ngïcö ëka lyetho, oro ëka cwïr, kiceng ëka kiwor, ba bino jik na twal.” ");
INSERT INTO lth_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Cë Obanga ömïö gum ï kom Noa ëka ëthïnö awope mërë nakun kobo bothgï nï, “Nywöl ïnya unu, ëka ipong unu lobo. ");
INSERT INTO lth_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Leeni kïbëc më thim bino gïnï lworoni, naka thon wïny kïbëc na ngwëcö kï malö, gin na wotho gïnï kï korgï ï wi ngöm, ëka kï rëc kïbëc na tye ï nam; etyeko mïögï ï cïngwu. ");
INSERT INTO lth_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Gin na kïbëc na kwö ëka na wotho, bino bedo cem na mewu. Kite na calö amïö bothwu ngwedo, kobedi dong an amïöwu jami kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Ëntö kür ïcam unu ringo na remo pod tye ïë, pïën remo obedo kwö mërë. ");
INSERT INTO lth_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ëka ka ëönyö remowu, an abino mïö pwod both lee mörö këkën. Ëka both dhanö acëlacël thon, an abino mïö pwod pï kwö k'awodhe. ");
INSERT INTO lth_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Ka ngat mörö öönyö remo ka dhanö, dhanö thon bino önyö remo mërë; pïën Obanga ocweo dhanö ï cal mërë. ");
INSERT INTO lth_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ëntö pï un, nywöl unu, mëdërë unu na pöl, ëka ïnya unu ï wi lobo.” ");
INSERT INTO lth_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Cë Obanga okobo both Noa ëka awope mërë nï, ");
INSERT INTO lth_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Nën! An amoko cïkërëna kodwu ëka k'ëkwaëwu na bino lübö körwu ");
INSERT INTO lth_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kï gin na kwö kïbëc n'onwongo tye gïnï kodwu—wïny, leeni më pacö ëka kï leeni më thim kïbëc, gin na kïbëc n'odonyo yökö kï ï yeya kodwu—kï gin na kwö kïbëc na tye ï wi lobo. ");
INSERT INTO lth_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","An amoko cïkërëna kodwu nï abwal pii ba dökï bino neko gin na kwö; abwal pii ba dökï bino bedo na tye më tyeko wi lobo.” ");
INSERT INTO lth_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ëka Obanga okobo nï, “Man ënë anyuth më cïkërëna na an aketho ï kin an kodwu ëka kï gin na kwö kïbëc na tye kodwu, cïkërë na bino bedo na twal ï rok kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","An aketho lüth köth na mëga ï edou, ëka bino bedo anyuth më cïkërëna ï kin an ëka kï wi lobo. ");
INSERT INTO lth_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ka an akelo edou ï wi lobo ëka lüth köth orire ï edou, ");
INSERT INTO lth_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","an abino po ï kom cïkërëna na tye ï kin an kodwu ëka kï gin na kwö kïbëc kï kothgï. Abwal pii ba dökï bino bedo na tye më tyeko gin na kwö kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ka lüth köth orire ï edou, an abino nënö, cë abino po ï kom cïkërë na ba jik ï kin Obanga ëka koth gin na kwö kïbëc na tye ï wi lobo.” ");
INSERT INTO lth_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Cë Obanga okobo both Noa nï, “Man ënë anyuth më cïkërë na an aketho ï kin an kï gin na kwö kïbëc na tye ï wi lobo.” ");
INSERT INTO lth_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Awope ka Noa n'odonyo gïnï kï ï yeya ënë Cem, Kam ëka Yapec. (Kam ënë obedo apap ka Kanaan.) ");
INSERT INTO lth_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Man ënë awope adek ka Noa, ëka kï ï kin-gï ënë jö n'obino ökëth gïnï ï wi lobo thükül. ");
INSERT INTO lth_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Kinge abwal pii, Noa obino ödökö apur ëka opuro pwodho ölök. ");
INSERT INTO lth_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ï nïnö mörö acël ën ömadhö köngö ölök cë ömër ökö, ëka obuto kotula ï öd këma mërë. ");
INSERT INTO lth_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ï karë na Kam, apap ka Kanaan, önënö apap mërë na tye kotula, ën öcïdhö okobo both omego mërë n'onwongo tye gïnï yökö. ");
INSERT INTO lth_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Cë Cem ëka Yapec otero gïnï böngü cüka n'otingo ï wi baagï, cë öcakö woth gïnï ayongec, ëka oumo gïnï kom apapgï n'onwongo tye kotula. Terinyimgï onwongo nënö yo kanya path, naka ba dök önënö gïnï kom apapgï n'onwongo tye kotula. ");
INSERT INTO lth_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ï karë na Noa oco kï ï wang nïnö na köngö ölök dong othum ökö kï ï wie, cë opo ï kom gin na wode na tïdï ötïmö ï kome, ");
INSERT INTO lth_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ën okobo nï, “Cen obed ï kom Kanaan! Ën obed opii na rwöm mërë tïdï ï kin opii k'omego mërë.” ");
INSERT INTO lth_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ën thon okobo nï, “Pak obed both Rwoth, Obanga ka Cem! Ëk Kanaan obed opii mërë. ");
INSERT INTO lth_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ëk Obanga ömïï wang lobo ka Yapec obed na lac ëk Yapec obed ï këma ka Cem ëka Kanaan obed opii mërë.” ");
INSERT INTO lth_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Kinge n'abwal pii opong ï wi lobo, Noa obedo ï wi lobo pï mwaka 350. ");
INSERT INTO lth_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa obino obedo ï wi lobo pï mwaka 950, cë dong öthöö. ");
INSERT INTO lth_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Man ënë cöc na nyutho ëkwaë ka Cem, Kam ëka Yapec awope ka Noa n'obino önywölö gïnï ëthïnö na pol kinge abwal pii. ");
INSERT INTO lth_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Awope ka Yapec gïn ene: Gomer, Magog, Madai, Jaban, Tubal, Mecak ëka Tirac. ");
INSERT INTO lth_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Awope ka Gomer gïn ene: Acikenaj, Ripat ëka Togarma. ");
INSERT INTO lth_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Awope ka Jaban gïn ene: Elica, Tarcic, Kitim, ëka Rodanim. ");
INSERT INTO lth_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Jö na tye ï dhö nam opokere gïnï ökö kï ï kom jö nön. Man ënë ëkwaë ka Yapec kï lobogï, nakun ngat acëlacël twakö lëbgï, na calö kakagï kï rokgï tye ködë. ");
INSERT INTO lth_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Awope ka Kam gïn ene: Kuc, Ejip, Put ëka Kanaan. ");
INSERT INTO lth_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Awope ka Kuc gïn ene: Ceba, Kabila, Cabta, Raama ëka Cabteca. Awope ka Raama gïn ene: Ceba ëka Dedan. ");
INSERT INTO lth_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuc onwongo obedo apap ka Nimrod, n'öcakö bedo alwëny na tëk kï ï wi lobo. ");
INSERT INTO lth_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ën onwongo obedo thwön adwar na tëk ï nyim Rwoth, ënë ömïö ekobo nï, “Calö Nimrod n'obedo thwön adwar na tëk ï nyim Rwoth.” ");
INSERT INTO lth_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Acaki më löc mërë onwongo obedo ï Babel, Erek, Akad ëka Kalne, na tye ï lobo Cinar. ");
INSERT INTO lth_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Cakërë kï ï lobo nön, ën öcïdhö naka ï Aciria, kanya ën ögërö ïë Ninebe, Rekobot Ir, Kala, ");
INSERT INTO lth_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ëka Recen, n'obedo kabedo na tye ï kin Ninebe kï Kala, manön ënë pacö na dit. ");
INSERT INTO lth_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ejip onwongo obedo apap ka jö Lud, jö Anam, jö Leab, jö Naptuk, ");
INSERT INTO lth_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","jö Patruc, ëka jö Kacluk (man ënë kaka na Pilicitain öya gïnï kï ïë) ëka jö Kaptor. ");
INSERT INTO lth_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan onwongo obedo apap ka Cidon athïn kaö mërë, ëka jö Kit, ");
INSERT INTO lth_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","jö Jebuc, jö Amor, jö Girgac, ");
INSERT INTO lth_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","jö Kibi, jö Arka, jö Cin, ");
INSERT INTO lth_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","jö Abad, jö Jemar, ëka jö Kamat. Kinge, kaka ka jö Kanaan ökëth gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Wang lobo ka jö Kanaan öcakërë kï ï Cidon odok ködë yo kutung Gerar, më thuno ködë naka ï Gaja, ëka dök ködë yo Codom, Gomora, Adma ëka Jeboim më thuno ködë naka yo Laca. ");
INSERT INTO lth_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Man ënë awope ka Kam na lübërë kï kakagï ëka lëbgï, ï kabedogï ëka ï rokgï. ");
INSERT INTO lth_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Cem ömïn Yapec na dit obino önywölö awope thon, Cem ënë onwongo obedo kwarö k'awope ka Eber kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Awope ka Cem gïn ene: Elam, Acur, Arpakcad, Lud ëka Aram. ");
INSERT INTO lth_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Awope ka Aram gïn ene: Uj, Kul, Geter ëka Mac. ");
INSERT INTO lth_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakcad onwongo obedo apap ka Cela, ëka Cela onwongo obedo apap ka Eber. ");
INSERT INTO lth_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber obino önywölö awope arïö: Ngat acël ebino ëcakö nyïngë Peleg, pïën ï karë mërë ënë jö më lobo obino opokere, ömïn mërë ebino ëcakö nyïngë Yokotan. ");
INSERT INTO lth_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokotan onwongo obedo apap ka Almodad, Celep, Kajarmabet, Jera, ");
INSERT INTO lth_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Ujal, Dikla, ");
INSERT INTO lth_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Ceba, ");
INSERT INTO lth_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Kabila ëka Jobab. Man ënë onwongo obedo gïnï awope ka Yokotan. ");
INSERT INTO lth_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Lobo na gïn onwongo obedo gïnï ïë öcakërë kï ï Meka, ödök ködë yo kutung Cepar ï lobo n'otingere malö na tye yo kukïdë. ");
INSERT INTO lth_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Man ënë awope ka Cem, na lübërë kï kakagï ëka lëbgï na tye ï lobogï ëka rokgï. ");
INSERT INTO lth_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Man ënë kaka k'awope ka Noa, na lübërë k'ëkwaëgï, ï kin rokgï. Rok öcakö këth ï wi lobo thükül kinge abwal pii. ");
INSERT INTO lth_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Yam cön jö më wi lobo thükül onwongo twakö gïnï lëb acël ëka köp acël. ");
INSERT INTO lth_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ï karë na jïï öcakö woth nakun ëdök yo kukïdë, gïn onwongo kany mörö n'obedo bar ï Cinar ëka obedo gïnï kunön. ");
INSERT INTO lth_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Gïn öcakö twak kën-gï nï, “Bin unu, ëk ëgöö bïrïk ëka ëwang na bër.” Gïn otio kï bïrïk nakaka kidi, ëka odok lam më mwönö kin-gï. ");
INSERT INTO lth_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Cë gïn dökï okobo nï, “Bin unu, ëk ëgër pacö onu, kï gedo na bor na thuno malö ï wi polo, ëk ëmïï nyïng onu ongere ëka kür ëkëth ata ï wi lobo kïbëc.” ");
INSERT INTO lth_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ëntö Rwoth oidho pïny më nënö pacö ëka gedo na bor na jïï onwongo tye ka gërö. ");
INSERT INTO lth_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Cë Rwoth okobo nï, “Ka gïn na calö jö n'örïbërë acël na twakö gïnï lëb acël öcakö gïnï tïmö nï köman, cë gin mörö na gïn bino yübö më tïmö ba bino löönögï. ");
INSERT INTO lth_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Bin unu, ëcïdh pïny erurubo lëbgï ëk kür ngat acëlacël önïang ï lëb awodhe.” ");
INSERT INTO lth_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Cë Rwoth ökëthögï kï kunön ï wi lobo thükül, ëka öwëkö gïnï gërö pacö nön. ");
INSERT INTO lth_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Manön ënë ömïö ëcakö nyïngë nï Babel—pïën kany nön ënë Rwoth orurubo kï lëb më wi lobo thükül, ëka kï kunön ënë Rwoth ökëthögï ködë ï wi lobo kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Man ënë ëkwaë ka Cem. Ï karë na Cem onwongo dong tye kï mwaka 100, ën önywölö Arpakcad, kinge mwaka arïö n'abwal pii opong ködë ï wi lobo. ");
INSERT INTO lth_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ëka kinge na ën önywölö Arpakcad, Cem obedo ï wi lobo pï mwaka 500, ëka ën onwongo dong önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ï karë n'Arpakcad obedo ï wi lobo pï mwaka 35, ën obino önywölö Cela. ");
INSERT INTO lth_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ëka kinge na ën önywölö Cela, Arpakcad obedo ï wi lobo pï mwaka 403 ëka ën onwongo dong önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ï karë na Cela obedo ï wi lobo pï mwaka 30, ën önywölö Eber. ");
INSERT INTO lth_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ëka kinge na ën önywölö Eber, Cela obedo ï wi lobo pï mwaka 403 ëka ën onwongo dong önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ï karë n'Eber obedo ï wi lobo pï mwaka 34, ën önywölö Peleg. ");
INSERT INTO lth_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ëka kinge na ën önywölö Peleg, Eber obedo ï wi lobo pï mwaka 430 ëka ën onwongo dong önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ï karë na Peleg obedo ï wi lobo pï mwaka 30, ën önywölö Reu. ");
INSERT INTO lth_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ëka kinge na ën önywölö Reu, Peleg obedo ï wi lobo pï mwaka 209 ëka ën onwongo dong önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ï karë na Reu obedo ï wi lobo pï mwaka 32, ën önywölö Cerug. ");
INSERT INTO lth_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ëka kinge na ën önywölö Cerug, Reu obedo ï wi lobo pï mwaka 207 ëka ën onwongo dong önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ï karë na Cerug obedo ï wi lobo pï mwaka 30, ën önywölö Nakor. ");
INSERT INTO lth_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ëka kinge na ën önywölö Nakor, Cerug obedo ï wi lobo pï mwaka 200 ëka ën onwongo önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ï karë na Nakor obedo ï wi lobo pï mwaka 29, ën önywölö Tera. ");
INSERT INTO lth_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ëka kinge na ën önywölö Tera, Nakor obedo ï wi lobo pï mwaka 119 ëka ën onwongo dong önywölö awope nökënë ëka anyira. ");
INSERT INTO lth_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Kinge na Tera obedo ï wi lobo pï mwaka 70, ën onwongo dong önywölö Abram, Nakor ëka Aran. ");
INSERT INTO lth_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Man ënë ëkwaë ka Tera. Tera önywölö Abram, Nakor ëka Aran. Ëka Aran önywölö Lot. ");
INSERT INTO lth_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ï karë na Tera apap k'Aran pod kwö, Aran obino öthöö ï Ur n'obedo lobo ka jö Kaldaya. ");
INSERT INTO lth_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram ëka Nakor obino onyomo gïnï. Nyïng dhakö k'Abram onwongo ecwodo nï Carai ëka nyïng dhakö ka Nakor onwongo ecwodo nï Milca, ën onwongo obedo nyaka Aran, apap ka Milca ëka Icika. ");
INSERT INTO lth_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ëntö Carai onwongo ope k'athïn mörö pïën onwongo ba nywöl. ");
INSERT INTO lth_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera ökwanyö wode Abram, akwarë Lot wod ka Aran, ëka cii wode Carai, dhakö ka Abram. Gïn kïbëc öya ökö kï ï Ur n'obedo pacö ka jö Kaldaya më cïdhö yo lobo Kanaan. Ëntö ï karë na gïn othuno ï Aran, cë gïn kono obedo kany nön. ");
INSERT INTO lth_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera obedo ï wi lobo pï mwaka 205, ëka öthöö ï lobo Aran. ");
INSERT INTO lth_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Rwoth okobo both Abram nï, “Yaa ökö kï ï lobo thurwu, kï ï kin jöwu ëka jö më öt k'apapni ëk ïcïdh ï lobo na an abino nyutho nini. ");
INSERT INTO lth_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“An abino mïöni ibedo rok na dit, ëka abino mïöni gum; An abino mïö nyingi bedo na dit, ëka in ibino bedo dhanö më gum both jö nökënë. ");
INSERT INTO lth_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","An abino mïö gum both jö na bino mïöni gum, ëka ngat mörö këkën na bino lamöni an thon abino lamö; ëka rok kïbëc na tye ï wi lobo bino nwongo gïnï gum na yaa kï bothi.” ");
INSERT INTO lth_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Cë Abram öya, kite na Rwoth okobo nïnë ködë, ëka Lot thon owotho ködë. Abram onwongo tye mwaka 75 ï karë na ën yaa kï ï lobo Aran. ");
INSERT INTO lth_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram owotho kï dhakö mërë Carai, Lot wod k'ömïn mërë, kï jamigï kïbëc n'onwongo gïn tye ködë ëka kï jïï na gïn onwongo kï ï lobo Aran. Gïn öya öcïdhö, ëka othuno gïnï ï lobo Kanaan. ");
INSERT INTO lth_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram owotho ï lobo naka othuno ï kabedo na tye ï Cekem. Kany nön ën oketho këma mërë ï nget yath na thwönë më More. Ï karë nön jö Kanaan onwongo tye gïnï ï lobo nön. ");
INSERT INTO lth_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Cë Rwoth onen both Abram ëka okobo nï, “An abino mïö lobo ni both ëkwaëni.” Cë ën ögërö keno tyër both Rwoth n'onen bothe. ");
INSERT INTO lth_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kï kany nön, ën öcakö dak ökö nakun dök yo kukïdë lobo n'otingere më Betel ëka oguro këma mërë ïë, Betel nwongo tye kï kuthö ëka Ai nwongo tye kï kukïdë. Ën ögërö keno tyër kany nön both Rwoth ëka öwörö nyïng Rwoth. ");
INSERT INTO lth_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Cë Abram ömëdërë kï woth mërë na cïdhö yo Negeb. ");
INSERT INTO lth_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kec onwongo opodho ï lobo Kanaan, ömïö Abram öcïdhö yo Ejip më bedo kunön pï karë mörö, pïën kec onwongo rac rwök. ");
INSERT INTO lth_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ï karë n'Abram onwongo dong cwök dönyö ï Ejip, ën okobo both dhakö mërë Carai nï, “An angeo nï in ibedo dhakö na leng rwök. ");
INSERT INTO lth_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ka jö më Ejip oneni gïnï, gïn bino kobo nï, ‘Man ënë dhakö mërë.’ Cë gïn bino nekona ökö, ëntö ebino wëköni na kwö. ");
INSERT INTO lth_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kob bothgï nï in ibedo amëra, ëk ömïïgï obed köda na bër pï in ëka kwöna ba ebino neko.” ");
INSERT INTO lth_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ï karë n'Abram obino ï Ejip, jö Ejip onwongo önënö dhakö mërë nï leng rwök. ");
INSERT INTO lth_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ï karë n'edite ka Parao önënö Carai, gïn öpakö ën both Parao, ëka etero ï pacö ka Parao. ");
INSERT INTO lth_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Parao ögwökö Abram na bër pï Carai. Abram ögamö rom, dhok, kene n'obedo cwö ëka kene na mon, etic n'obedo cwö, etic n'obedo mon, ëka kïnaga. ");
INSERT INTO lth_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ëntö Rwoth ooro two na reco ï kom Parao ëka kï jö më ödë pï Carai dhakö k'Abram. ");
INSERT INTO lth_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Cë Parao ocwodo Abram ëka okobo nïnë nï, “Ngö na in ïtïmö ï koma? Pïngö in ba ikobo nïna nï Carai obedo dhaköni? ");
INSERT INTO lth_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Pïngö in ikobo nï ën obedo ameru, ëka ïmïö atero ën na calö dhaköna? Dhaköni dong ene, kwany ën ëka ïcïdh ökö kï kany!” ");
INSERT INTO lth_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Cë Parao ömïö twërö both jögë ï kom Abram, ëka gïn ömïö ën öcïdhö kï dhakö mërë ëka kï jami kïbëc n'onwongo ën tye ködë. ");
INSERT INTO lth_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram öya ökö kï Ejip gïn kï dhakö mërë, ëka kï jami kïbëc n'onwongo ën tye ködë më cïdhö ï Negeb, ëka Lot thon owotho ködë. ");
INSERT INTO lth_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ï karë nön, Abram onwongo ölöny kï leeni më pacö, kï ryal ëka kï gol. ");
INSERT INTO lth_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ën obedo ka mëdërë kï wowotha nakun yaa kï ï Negeb naka othuno ï Betel, kanya ën onwongo oguro këma mërë ïë cön, ï kabedo na tye ï kin Betel ëka Ai. ");
INSERT INTO lth_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Man onwongo obedo kabedo na ën öcakö gërö keno tyër ïë, ëka kany nön ënë Abram öwörö Rwoth ïë dökï. ");
INSERT INTO lth_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, n'onwongo wotho gïn k'Abram onwongo thon tye kï rom, dhok ëka këma. ");
INSERT INTO lth_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ëntö ngöm onwongo ope na römö mïögï bedo kanya acël, pïën lïmgï onwongo dwong rwök na mïögï ba römö bedo kanya acël. ");
INSERT INTO lth_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Dhaa öcakërë ï kin ëkwath k'Abram ëka më ka Lot. Ï karë nön jö Kanaan ëka jö Periji onwongo thon bedo gïnï ï lobo nön. ");
INSERT INTO lth_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram okobo both Lot nï, “Ba amïtö nï dha mörö obed na tye ï kin in kï an, onyo ï kin ëkwathni ëka mëga, pïën onu ebedo utmego. ");
INSERT INTO lth_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Lobo kïbëc tye n'omore ï nyimi. Kobedini myero in ipokiri ökö kï botha. Ka in ïdök yo kucam, an abino dök yo kucem, ka in ïdök yo kucem an abino dök yo kucam.” ");
INSERT INTO lth_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Cë Lot öcakö tingo wangë ëka önënö nï lobo n'opwodere më Jordan onwongo opong kï pii na bër, calö pwodho ka Rwoth, ëka calö lobo më Ejip na dök yo Joar. (Man ötïmërë na bara Rwoth otyeko Codom ëka Gomora.) ");
INSERT INTO lth_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot öyërö gire kënë, lobo kïbëc n'opwodere ï Jordan ëka ödök yo kukïdë. Man ömïö jö arïö ni opokere. ");
INSERT INTO lth_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram obedo ï lobo më Kanaan, nakun Lot obedo ï kin taun na döngö n'opwodere ëka oguro këma mërë na cwök kï Codom. ");
INSERT INTO lth_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Jö Codom onwongo obedo gïnï jö na kitegï reco ëka balgï onwongo dwong rwök both Rwoth. ");
INSERT INTO lth_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Kinge na dong Lot opokere kï both Abram, Rwoth okobo both Abram nï, “Ting wangi malö kï kanya in itye ïë ëka ïnën kukuju ëka kukwap, kukïdë ëka kuthö. ");
INSERT INTO lth_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Lobo kïbëc na in itye ka nënö an abino mïöni ëka both ëkwaëni na twal. ");
INSERT INTO lth_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","An abino mïö ëkwaëni bedo calö kwo më dhö nam, ëk ka ngat mörö twërö kwanö kwo më dhö nam, cë ëkwaëni bino kwanërë. ");
INSERT INTO lth_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Yaa malö, ïcak lübö bor mërë ëka arii mërë, pïën an abino mïöni.” ");
INSERT INTO lth_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Cë Abram ökwanyö këma mërë ëka öcïdhö obedo ï nget yath na thwönë më Mamre na tye ï Kebron, kanya ën ögërö keno tyër ïë both Rwoth. ");
INSERT INTO lth_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ï karë nön rwoth Amrapel më Cinar, rwoth Ariok më Elacar, rwoth Kedorlaomer më Elam, ëka rwoth Tidal më Goim, ");
INSERT INTO lth_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","öcïdhö gïnï më lwëny ï kom rwoth Bera më Codom, rwoth Birca më Gomora, rwoth Cinab më Adma, rwoth Cemeber më Jeboim, ëka rwoth më Bela (manön, Joar). ");
INSERT INTO lth_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Rwodhi ni kïbëc örïbö gïnï acikarigï kanya acël ï Ora më Cidim (Nam më Kadö). ");
INSERT INTO lth_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Gïn onwongo obedo ï thë löc ka Kedorlaomer pï mwaka apar arïö, ëntö ï mwaka më apar adek gïn öcakö jëm ökö. ");
INSERT INTO lth_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ï mwaka më apar angwën, rwoth Kedorlaomer ëka kï rwodhi n'onwongo örïbërë ködë obino öcakö lwëny ëka ölöö gïnï jö Repa kï ï Aciterot Karnaim, jö Jujim kï ï Kam, jö Emim kï ï Cabe Kiriataim ");
INSERT INTO lth_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ëka jö Kori kï ï kite më Ceir, naka ï El Paran na cwök kï thim. ");
INSERT INTO lth_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Cë ödök gïnï cen ëka öcïdhö gïnï yo En Micipat (manön, Kadec). Gïn öcïdhö ölöö lobo ka jö Amalek, ëka jö Amor n'onwongo bedo gïnï ï Ajajon Tamar. ");
INSERT INTO lth_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Cë rwoth më Codom, rwoth më Gomora, rwoth më Adma, rwoth më Jeboim ëka rwoth më Bela (manön, Joar) öya ëka öyübërë gïnï më lwëny ï Ora më Cidim ");
INSERT INTO lth_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ï kom rwoth Kedorlaomer më Elam, rwoth Tidal më Goim, rwoth Amrapel më Cinar ëka rwoth Ariok më Elacar—rwodhi angwën ölwënyö ï kom rwodhi abic. ");
INSERT INTO lth_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ora më Cidim onwongo opong kï bur odok lam na cöl, ëka ï karë na rwodhi më Codom ëka Gomora ngwëcö gïnï, jö mökö opodho gïnï ïë cë jö nökënë n'odong öngwëcö gïnï ökö yo wi kite. ");
INSERT INTO lth_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Cë rwodhi angwën n'ölöö, öyakö jami kïbëc na pïrgï tëk kï cem ka jö Codom ëka Gomora, cë öcïdhö gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Gïn thon obino otero gïnï Lot wod k'ömïn Abram kï jami mërë, pïën ën onwongo bedo ï lobo Codom. ");
INSERT INTO lth_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ngat acël n'onwongo öbwöth obino otero köp ni both Abram dhanö më Iburu. Abram onwongo bedo na cwök kï yen na thwon ka Mamre dhanö më Amor, ömïn Ecikol ëka Aner, gïn kïbëc onwongo rïbërë k'Abram. ");
INSERT INTO lth_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ï karë n'Abram owinyo nï Lot wod k'ömïn mërë ëmakö ökö, ën ocwodo jö 318 n'opwonyere, n'ënywölögï ï parë ëka öcïdhö ölübö kï kör lang naka ï Dan. ");
INSERT INTO lth_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ï kiwor, Abram opoko etic mërë më lwëny ï komgï ëka ölöögï nakun ryëmögï naka yo Koba, kukuju më Damaciko. ");
INSERT INTO lth_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram odwongo jami kïbëc ëka okelo Lot wod k'ömïn mërë kï jami mërë, kanya acël kï mon ëka kï jö nökënë. ");
INSERT INTO lth_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kinge n'Abram odwogo kï kanya ën ölöö Kedorlaomer ëka rwodhi n'onwongo örïbërë ködë, rwoth më Codom obino më romo k'Abram ï Ora më Cabe (manön, Ora ka Rwoth). ");
INSERT INTO lth_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Cë rwoth Melkijedek më Calem okelo ogati ëka köngö ölök. Ën onwongo obedo alamdhök k'Obanga na Malö Rwök, ");
INSERT INTO lth_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ëka ömïö gum both Abram nakun kobo nï, “Gum k'Obanga na Malö Rwök obed ï kom Abram, Obanga n'ocweo polo ëka lobo. ");
INSERT INTO lth_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ëka pak obed both Obanga na Malö Rwök, n'ömïö langni ï cingi.” Cë Abram ömïö acël më apar më jami kïbëc bothe. ");
INSERT INTO lth_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Rwoth më Codom okobo both Abram nï, “Mïa jïï ëka in ïgwök jami obed megi.” ");
INSERT INTO lth_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ëntö Abram okobo both rwoth më Codom nï, “An atyeko tingo cïnga nakun acïkara both Rwoth, Obanga na Malö Rwök, n'ocweo polo kï lobo ");
INSERT INTO lth_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nï ba abino gamö gin mörö kï bothi, kadï thon wicu, onyo del wör, ëk kür ibin ikob nï, ‘An ënë amïö Abram ölöny.’ ");
INSERT INTO lth_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","An ba abino gamö gin mörö ëntö ngö n'awopena öcamö ëka jami n'obedo më ka jö n'owotho köda yo both Aner, Ecikol ëka Mamre. Mïïgï oter jamigï n'epoko nïgï.” ");
INSERT INTO lth_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kinge man, Rwoth ötwak k'Abram ï wang lek, nakun kobo nï, “Abram, kür ibed na lwor! An abedo kwot na megi, cül na megi bino bedo na thwönë.” ");
INSERT INTO lth_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ëntö Abram ögamö nï, “Rwoth Obanga Won Twër, ngö na in ibino mïöna nakun ape k'athïn mörö ëka dhanö na bino leeno jamina ënë Eliejer më Damaciko?” ");
INSERT INTO lth_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram dökï okobo nï, “In ba ïmïa athïn mörö, ëka atic ni n'ënywölö ï öda ënë bino leeno jamina.” ");
INSERT INTO lth_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Cë Rwoth dökï ötwak ködë nï, “Dhanö ni ba bino leeno jamini, ëntö wodi kikokome na in ïnywölö ënë bino leeno jamini.” ");
INSERT INTO lth_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Cë Rwoth okelo Abram yökö ëka okobo nïnë nï, “Nën malö ï wi polo ëka ïkwan wel cër—ka adyer in ïrömö kwanögï.” Cë ën okobo nïnë nï, “Ëkwaëni thon bino bedo na pol kömanön.” ");
INSERT INTO lth_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram oketho yee mërë ï kom Rwoth, ëka ömïö ëkwanö ën nï kite atïr. ");
INSERT INTO lth_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Cë Rwoth dökï okobo nïnë nï, “An abedo Rwoth na ënë okeli yökö kï ï Ur na tye ï lobo ka jö Kaldaya, më mïöni lobo ni ëk obed megi.” ");
INSERT INTO lth_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ëntö Abram ögamö nï, “Rwoth Obanga Won Twër, an atwërö ngeno nïngö nï lobo ni bino bedo mëga?” ");
INSERT INTO lth_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Rwoth okobo both Abram nï, “Kel nïna nya raa mörö më mwaka adek, nya dyël më mwaka adek, thwön römö më mwaka adek, akur ëka athïn amam.” ");
INSERT INTO lth_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ën okelo jami ni kïbëc both Rwoth, cë ongunguno ïgï arïö arïö ëka öcanögï na dul acëlacël kemo awodhe, ëntö wïny ën ba ongungunogï. ");
INSERT INTO lth_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ka acuth obino më camö ringogï, Abram ryëmögï ökö. ");
INSERT INTO lth_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ï karë na ceng dong cwök dönyö, nïnö ömakö wang Abram rwök, ëka pïny na cöl cuc oumo ën ökö. ");
INSERT INTO lth_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Cë Rwoth okobo nïnë nï, “Myero inge atïr nï ëkwaëni bino bedo Erok ï lobo na pathï mëgï. Ebino mïögï bedo opii ëka ebino yelogï pï mwaka 400. ");
INSERT INTO lth_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ëntö an abino mïö pwod ï kom jö na bino yelogï, ëka kinge gïn bino yaa ökö kï kunön nakun nwongo tye gïnï kï lïm na pol. ");
INSERT INTO lth_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ëntö in ebino ikoni kanya acël kï kwereni kï kuc. Ebino ikoni na dong itii. ");
INSERT INTO lth_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Kinge rok më angwën, ëkwaëni bino dwogo gïnï cen kany pïën bal ka jö Amor bara römö ketho can ï komgï.” ");
INSERT INTO lth_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ï karë na ceng dong ödönyö, ëka pïny ödökö na cöl, agulu na iro dung kï ïë kï mac na lyël ï raa onen ëka owok ï dyere ringo n'engunguno kï kom lee acëlacël. ");
INSERT INTO lth_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ï nïnö nön ënë Rwoth oketho cïkërë mërë k'Abram nakun kobo nï, “An amïö lobo ni both ëkwaëni, cakërë kï ï kulo më Ejip thuno ködë naka ï kulo na thwönë më Euparate, ");
INSERT INTO lth_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","lobo ka jö Keni, jö Keniji, jö Kadmon, ");
INSERT INTO lth_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","jö Kit, jö Periji, jö Repa, ");
INSERT INTO lth_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","jö Amor, jö Kanaan, jö Girgac ëka jö Jebuc.” ");
INSERT INTO lth_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Carai dhakö ka Abram ba önywölö nïnë ëthïnö mörö. Ëntö onwongo tye k'atic mërë n'obedo nya jö Ejip na nyïngë Agar. ");
INSERT INTO lth_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Carai okobo both Abram nï, “Rwoth öjüka ökö më nwongo ëthïnö, cïdhï ibed k'aticna gwök onyo abino nwongo athïn mörö kï bothe.” Abram oyeo ngö na Carai okobo. ");
INSERT INTO lth_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Cë kinge na dong Abram obedo ï Kanaan pï mwaka apar, Carai ökwanyö atic mërë Agar n'obedo nya jö Ejip ëka ömïö both Abram më bedo dhakö mërë. ");
INSERT INTO lth_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram obedo k'Agar, ëka öyac. Ï karë n'Agar ongeo nï dong ëyac, ën öcakö caö adit mërë Carai. ");
INSERT INTO lth_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Cë Carai okobo both Abram nï, “Can na an atye ka nwongo myero obed ï wi. An amïö aticna ï cingi ëka kobedini ën ongeo nï ën dong ëyac, cë öcakö caöna. Ëk Rwoth öngöl ï kin ön nga na rac.” ");
INSERT INTO lth_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram ögamö nï, “Aticni tye ï cingi, tïm gin mörö këkën na in ïthamö nï bër ï kome.” Cë Carai öcakö yelo Agar rwök naka ömïö öngwëcö ökö kï bothe. ");
INSERT INTO lth_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malaika ka Rwoth onwongo Agar ï nget kulo na tye ï thim na cïdhö yo Cur. ");
INSERT INTO lth_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Malaika okobo nïnë nï, “Agar, atic ka Carai, in ibino kï kwene, ëka ïcïdhö yo kwene?” Ën ögamö nï, “An atye ka ngwëc ökö kï both Carai.” ");
INSERT INTO lth_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Cë Malaika ka Rwoth okobo nïnë nï, “Dök cen both Carai ëka ibed ï thë löc mërë.” ");
INSERT INTO lth_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Cë malaika ömëdërë më kobo nïnë nï, “An abino mëdö ëkwaëni bedo na pol na ba kwanërë.” ");
INSERT INTO lth_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Malaika ka Rwoth okobo nïnë thon nï, “In kobedini dong ï yac ëka ibino nywölö athïn n'ëcwö. Ibino cakö nyïngë Icimael, pïën Obanga owinyo koko më cwer cwinyi. ");
INSERT INTO lth_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ën bino bedo calö kana na ger, ën bino bedo na ger nakun lwënyö ï kom jö kïbëc ëka jö kïbëc bino lwëny ï kome, ëka ën bino bedo kënë kï both utmego mërë kïbëc.” ");
INSERT INTO lth_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Agar ömïö nyïng ni both Rwoth n'ötwak ködë nï, “In ibedo Obanga na nëna,” pïën okobo nï, “An dong anënö Obanga na nëna.” ");
INSERT INTO lth_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ënë ömïö kulo nön ecwodo nï Beer Lakai Roi. Kulo nön nwongere ï dyere Kadec ëka Bered. ");
INSERT INTO lth_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agar önywölö n'Abram athïn n'ëcwö ëka Abram öcakö nyïngë Icimael. ");
INSERT INTO lth_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram onwongo dong tye kï mwaka 86 ï karë na Agar önywölö nïnë Icimael. ");
INSERT INTO lth_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ï karë n'Abram dong othuno mwaka 99, Rwoth onen bothe ëka okobo nï, “An Obanga Won Twër kïbëc, kwö ï nyima ï yoo n'opore abonge bal mörö. ");
INSERT INTO lth_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","An abino moko cïkërëna ï kin an kï in ëka abino mïö ëkwaëni bino bedo na pol.” ");
INSERT INTO lth_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram oryebere pïny ï ngöm ï nyim Obanga, ëka Obanga okobo nïnë nï, ");
INSERT INTO lth_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“An amoko cïkërëna kodi. In ibino bedo kwarö ka rok na pol. ");
INSERT INTO lth_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nyingi ba dökï ebino cwodo nï Abram, ëntö Abraam, pïën an amii ïdökö kwarö ka rok na pol. ");
INSERT INTO lth_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","An abino mïö ëkwaëni bedo na pol; an abino mïöni ïdökö rok na pol, ëka rwodhi bino yaa kï bothi. ");
INSERT INTO lth_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","An abino moko cïkërëna kodi ëka ëkwaëni na bino lüböni, ëka ëkwaëgï kïbëc obed cïkërë na bino bedo na twal pï run kïbëc. An abino bedo Obangani ëka Obanga k'ëkwaëni na bino lüböni. ");
INSERT INTO lth_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","An abino mïö lobo Kanaan kïbëc bothi—lobo na in kobedini itye ïë na calö arok ëk obed megi na twal ëka ëkwaëni na bino lüböni. An abino bedo Obangagï.” ");
INSERT INTO lth_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Cë Obanga okobo both Abraam nï, “In myero ïgwök cïkërëna, in ëka ëkwaëni na bino lüböni ï run më anyim. ");
INSERT INTO lth_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Man ënë cïkërëna kodi ëka ëkwaëni na bino lüböni, cïkërë na myero ïgwökï: Cwö kïbëc na tye ï kinwu myero ëlïr. ");
INSERT INTO lth_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Un myero ïlïr wi del komwu më cwö, ëka man bino bedo anyuth më cïkërë ï kin an ëka un. ");
INSERT INTO lth_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Pï rok na tye ka bino, ëthïnö awope kïbëc na tye nïnö aboro myero ëlïr, naka thon ëthïnö awope n'ënywölö ï kinwu onyo ëwïlö kï cïlïng kï both Erok na ba ënywölögï ï kin ëkwaëni. ");
INSERT INTO lth_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Kono kadï ënywölö ï odi onyo ïwïlö kï cïlïngni, myero ëlïrgï. Cïkërëna na tye ï del komwu myero obed cïkërë na bino bedo na twal. ");
INSERT INTO lth_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Dhanö mörö n'obedo ëcwö na ba ëlïrö del wi kome më cwö, ebino kwanyö ökö kï ï kin jögë, pïën nwongo ën ötürö cïkërëna.” ");
INSERT INTO lth_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Obanga thon okobo both Abraam nï, “Dhaköni, in ba dök ibino cwodo ën nï Carai; nyïngë bino bedo Cara. ");
INSERT INTO lth_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","An abino mïö gum bothe ëka abino mïöni athïn n'ëcwö na yaa kï bothe. Abino mïö gum both Cara ëk obed aya ka rok na pol, rwodhi ka jïï bino yaa kï bothe.” ");
INSERT INTO lth_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraam oryebere pïny ï ngöm, önyërö ëka ötwak kënë nï, “Dhanö na tye kï mwaka 100 twërö nywölö athïn? Cara twërö nywölö athïn nakun ën dong tye kï mwaka pyer abungwën?” ");
INSERT INTO lth_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ëka Abraam okobo both Obanga nï, “Öma mïï Icimael olee jami na in ïcïkö!” ");
INSERT INTO lth_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Cë Obanga okobo nï, “Pe, ëntö dhaköni Cara bino nywölö nini athïn n'ëcwö, ëka ibino cakö nyïngë Icaka. An abino moko cïkërëna ködë na bino bedo na twal ëka ëkwaë mërë na bino lübö ën. ");
INSERT INTO lth_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ëka pï Icimael, an awinyo kwacni, adyer an abino mïö ën gum, abino mïö ën nywöl nya na pol rwök. Ën bino bedo kwarö ka rwodhi apar arïö ëka abino mïö ën dökö rok na dit. ");
INSERT INTO lth_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ëntö an abino moko cïkërëna kï Icaka, athïn na Cara bino nywölö nini ï koth karë ni ï mwaka na bino.” ");
INSERT INTO lth_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ï karë na ën dong otyeko twak k'Abraam, Obanga öya ökö kï bothe. ");
INSERT INTO lth_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ï nïnö nön kikokome Abraam ökwanyö wode Icimael kanya acël kï jö kïbëc n'ënywölö ï pacö mërë, onyo n'öwïlö kï cïlïng mërë, jö kïbëc n'obedo cwö na tye ï pacö mërë ölïrögï kite n'Obanga okobo nïnë. ");
INSERT INTO lth_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraam onwongo dong tye kï mwaka më dit mërë 99 ï karë n'ëlïrö ën, ");
INSERT INTO lth_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ëka wode Icimael onwongo dong tye kï mwaka apar adek ï karë n'ëlïrö ën. ");
INSERT INTO lth_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraam ëka wode Icimael ëlïrögï ï nïnö nonu kikokome. ");
INSERT INTO lth_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Cwö kïbëc n'onwongo tye ï pacö mërë, ëka cwö kïbëc n'ënywölö ï pacö onyo n'ëwïlö kï both arok, ëlïrögï kanya acël ködë. ");
INSERT INTO lth_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Rwoth dökï onen both Abraam ï nget yen na thwon na tye ï Mamre, n'onwongo ën obedo ï dholokek më këma mërë ï karë na pïny lyeth. ");
INSERT INTO lth_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ën otingo wangë, ëka cücüth önënö jö adek n'ocung gïnï kï cecen. Ï karë na ën önënögï, örïngö kï ï dhö këma mërë më romo ködgï, cë oryebere pïny ï ngöm. ");
INSERT INTO lth_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Abraam okobo nï, “Rwothna, ka itye kï cwiny na bër ï koma, kür ïkadh aticni akadha. ");
INSERT INTO lth_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ëk ekel pii mörö na nönök, ïlwök unu kï tyënwu, ëka dong iywe unu ï thë yath ni. ");
INSERT INTO lth_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ëk acïdh akel niwu gin mörö më acama, ëk ömïï inwong unu tëkö mörö, ëka dong ïmëdërë unu kï wothwu—kite n'onwongo ibino unu ködë botha.” Gïn ögamö nï, “Eyo, tïm kite na in ikobo ködë.” ");
INSERT INTO lth_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Cë Abraam öbünyö cïdhö yo both Cara ï këma, okobo nïnë nï, “Kwany mökö ngano na römö agweti adek pïöpïö ëk ïnyöbï, ëka ited k'ogati mörö.” ");
INSERT INTO lth_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Cë Abraam örïngö ï öd okul dhok, öyërö wod thwön na ringo mërë pod yom na bër, ëka ömïö both atic mërë, n'öyübö pïöpïö. ");
INSERT INTO lth_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ï karë na cem dong öcëk, Abraam okelo cak na wac, cak na lïbü, ringo na gïn otedo, ëka oketho ï nyimgï. Ën ocung ï nget yath nakun kürögï na gïn tye ka cem. ");
INSERT INTO lth_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Cë gïn openyo nï, “Dhaköni Cara tye kwene?” Abraam ögamö nï, “Ën tye ï këma.” ");
INSERT INTO lth_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Cë Rwoth okobo nï, “Adyer an abino dwogo bothi ï mwaka na bino ï koth karë ni, ëka dhaköni Cara nwongo dong tye kï wode.” Cara onwongo tye ka winyo köpgï kï ï dholokek më këma, n'onwongo tye ï nge Abraam. ");
INSERT INTO lth_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ï karë nön Abraam gïn kï Cara onwongo dong otii gïnï ökö ëka mwakagï onwongo thon thwönë, mwaka ka Cara thon më nywölö athïn onwongo dong opoth ökö. ");
INSERT INTO lth_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Cara önyërö kënë, nakun kobo nï, “Kinge na dong an atii, ëka adwongna thon dong otii ökö, pod dökï atwërö bedo kï miti më nywölö athïn?” ");
INSERT INTO lth_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Cë Rwoth okobo both Abraam nï, “Pïngö Cara önyërö nakun kobo nï, ‘Adyer an dökï atwërö nywölö athïn, na dong atii ökö?’ ");
INSERT INTO lth_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Tye gin mörö na tëk na löö Rwoth? An abino dwogo bothi ï karë n'opore ï mwaka na bino, nwongo Cara dong tye kï wode.” ");
INSERT INTO lth_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ëntö Cara obedo na lwor ëka okobo twodo nï, “An gira ba anyërö.” Ëntö Rwoth ögamö nï, “Eyo, in ïnyërö.” ");
INSERT INTO lth_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ï karë na wele öya më cïdhö ökö, gïn ödök yo kutung Codom, ëka Abraam ökwangögï më nyuthigï yoo. ");
INSERT INTO lth_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Cë Rwoth okobo nï, “Myero an amüng n'Abraam gin na an acwök tïmö? ");
INSERT INTO lth_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Adyer Abraam bino bedo rok na thwönë, ëka na tëk, na rok kïbëc na tye ï wi lobo bino nwongo gum na yaa kï bothe? ");
INSERT INTO lth_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Pïën an dong atyeko yërö ën, ëk onyuth n'ëthïnö mërë ëka jö më ödë na bino lübö körë më lübö yoo ka Rwoth nakun tio gïnï gin na tye atïr. Cë Rwoth bino mïö Abraam gin na yam ën öcïkö.” ");
INSERT INTO lth_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Cë Rwoth okobo nï, “Koko ï kom Codom ëka Gomora ödökö na thwönë rwök, ëka balgï dong rac rwök. ");
INSERT INTO lth_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","An abino cïdhö bothgï ëk acïdh anën ka adyer gin na gïn tye ka tïmö, na koko mërë othuno botha. Cë ka pe, an abino ngeno.” ");
INSERT INTO lth_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Cë jö arïö ölökërë ëka öcakö gïnï woth më cïdhö yo Codom, ëntö Abraam odong nakun ocung ï nyim Rwoth. ");
INSERT INTO lth_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraam önyïkö na cwök yo bothe ëka okobo nïnë nï, “In ibino tyeko jö na kitegï atïr kanya acël kï jö na reco? ");
INSERT INTO lth_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Cë ka jö na kitegï atïr bino nwongërë pyer abic ï pacö nön? Adyer in ibino tyeko kabedo nön ökö ëka ba ibino wëkö pacö nön pï jö pyer abic na kitegï atïr na tye gïnï ïë? ");
INSERT INTO lth_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Adyer ba opore in më tïmö nï kömanön—më neko jö na kitegï atïr kanya acël kï jö na reco, nakun ïmïö jö na kitegï atïr thon bedo na rom kï jö na reco. Adyer ba opore in më tïmö nï kömanön! Angöl-köp më lobo kïbëc ba bino tïmö gin na tye atïr?” ");
INSERT INTO lth_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Rwoth ögamö nï, “Ka an anwongo jö na kitegï atïr pyer abic na tye gïnï ï Codom, an abino wëkö kabedo nön kïbëc pïrgï.” ");
INSERT INTO lth_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Cë Abraam dökï ötwak nï, “Kite na dong an atwak both Rwoth kï tëk cwiny, kadï bed nï an ba abedo gin mörö ëntö apua ëka buru. ");
INSERT INTO lth_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Cë ka jö na kitegï atïr tye pyer angwën wie abic? In ibino tyeko pacö nön kïbëc pï jö abic n'orem?” Ën ögamö nï, “Ka an anwongo jö pyer angwën wie abic, an ba abino tyeko.” ");
INSERT INTO lth_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ëka Abraam okobo dökï nï, “Cë ka ibino nwongo jö pyer angwën këkën kunön?” Ën ögamö nï, “Pï jö pyer angwën an ba abino tïmö gin mörö.” ");
INSERT INTO lth_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ëka dökï okobo nï, “Kür akëmö omaki, in Rwoth, an abino twak dökï. Ka cë ibino nwongo kunön jö pyer adek kono?” Cë ën ögamö nï, “Ba abino tïmö ka cë abino nwongo jö pyer adek kunön.” ");
INSERT INTO lth_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraam dökï okobo nï, “Kite na dong an atwak both Rwoth kï tëk cwiny, cë ka jö pyer arïö këkën ënë bino nwongere kunön?” Ën ögamö nï, “Pï jö pyer arïö, an ba abino tyeko pacö nön.” ");
INSERT INTO lth_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Më ajiki Abraam okobo nï, “Rwoth, kür akëmö omaki ï koma, ëk atwak kïcël këkën. Cë ka in ibino nwongo jö apar këkën kunön?” Ën ögamö nï, “Pï jö apar nön, an ba abino tyeko pacö nön.” ");
INSERT INTO lth_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ï karë na dong Rwoth otyeko twak k'Abraam, ën öya ökö ëka Abraam ödök ï kabedo mërë. ");
INSERT INTO lth_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ï karë n'emalaika arïö othuno gïnï ï Codom kothyeno, gïn onwongo Lot obedo ï dhö wangkac më pacö. Ï karë na Lot önënögï, ën öya malö më romo ködgï, ëka oryebere pïny ï ngöm. ");
INSERT INTO lth_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ën okobo nï, “Editena, akwaöwu an aticwu ëk ibin unu ï pacöna. Ïlwök tyënwu ëka ïnïn unu kany, cë dong ïya unu kodiko cön më mëdërë kï woth na mewu.” Gïn ögamö nï, “Pe, wan ebino nïnö ï dyere pacö.” ");
INSERT INTO lth_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ëntö Lot ödïögï rwök, cë gïn ölökërë ödönyö gïnï ï ödë. Ën otedo cem nïgï, otedo ogati abonge thöbï, ëka öcamö gïnï. ");
INSERT INTO lth_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Na gïn bara öcïdhö ï kabuto, cwö kïbëc na tye ï pacö më Codom—jö na thïnö ëka jö n'otii—obino cë ögürö gïnï öt. ");
INSERT INTO lth_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Gïn öcakö redo kï nyïng Lot nï, “Jö n'obino gïnï bothi woro kothyeno tye gïnï kwene? Kelgï yökö bothwa kany, ëk ebut ködgï.” ");
INSERT INTO lth_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot ödönyö yökö bothgï, ëka oloro dholokek ökö, ");
INSERT INTO lth_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","nakun kobo bothgï nï, “Akwaöwu, utmegona, kür ïtïm unu tïm më kïpyëdë. ");
INSERT INTO lth_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nën, an atye k'anyirana arïö na bara ongere gïnï kï cwö. Ëk akelgï bothwu, ïtïm unu gïn na un ïmïtö ködgï. Ëntö kür ïtïm unu gin mörö ï kom jö ni, pïën gïn dong tye ï thë gwök na mëga.” ");
INSERT INTO lth_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Gïn oredo nï, “Yaa ökö kï ï nyimwa!” Ëka okobo gïnï dökï nï, “Nyeri obino kany na calö arok ëka kobedini mïtö bedo angöl-köp! Wan ebino tïmö gin na rac ï komi na löö gïn.” Gïn ömëdërë më dïö Lot, nakun cïdhö gïnï më türö dholokek. ");
INSERT INTO lth_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ëntö emalaika arïö olyao cïng-gï yökö, cë öywaö gïnï Lot ï öt ëka oloro gïnï dholokek ökö. ");
INSERT INTO lth_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Cë gïn öbörö wang jö na dito ëka jö na thïnö n'onwongo tye gïnï ï dholokek më öt kï thöö wang, ëk kür onwong gïnï dholokek. ");
INSERT INTO lth_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Emalaika arïö okobo both Lot nï, “In itye kï jö mörö nökënë kany n'onyomo ï pacöni, awope, anyira onyo ngat mörö n'obedo watni? Yaa unu ködgï ökö kï kany, ");
INSERT INTO lth_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","pïën wan ëcwök tyeko kabedo ni ökö. Koko na tye ï kom jö na tye ïë ödökö na thwönë ï nyim Rwoth, ëka ën oorowa nï ëk etyekgï ökö.” ");
INSERT INTO lth_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Cë Lot ödönyö yökö, ëka ötwak kï jö n'onwongo mïtö nyömö anyira mërë. Ën okobo nï, “Yaa unu ökö pïöpïö kï ï kabedo ni, pïën Rwoth cwök tyeko pacö ni ökö.” Ëntö jö n'onwongo mïtö nyömö anyira mërë, öthamö gïnï nï ën onwongo woco awoca. ");
INSERT INTO lth_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kodiko na pïny dong ruu, emalaika arïö öbünyö gïnï Lot, nakun kobo gïnï nï, “Yaa ökö! Kwany dhaköni ëka anyirani arïö na tye gïnï kany, ëk kür etyekwu ökö ka ebino pwodo pacö ni.” ");
INSERT INTO lth_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ï karë na ën obedo galërë, emalaika ömakö cïngë ëka cïng dhakö mërë, cïng anyira mërë arïö cë öpëögï yökö kï ï pacö, pïën Rwoth onwongo tye kï kïca ï komgï. ");
INSERT INTO lth_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ï karë na dong ekelogï yökö, malaika acël okobo nï, “Rïng ïlar unu kwöwu! Kür ïnën unu ngewu, ëka kür icung unu kany mörö ï ora! Rïng unu ï wi kite, ëk kür ïthöö unu!” ");
INSERT INTO lth_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ëntö Lot okobo bothgï nï, “Pe, adwongna. ");
INSERT INTO lth_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","An aticni anwongo cwiny na bër rwök ï nyimi, ëka inyutho kïca na thwönë rwök pï larö kwöna. Ëntö ba atwërö rïngö yo wi kite, pëkö ni bino podho ï koma cë abino thöö ökö. ");
INSERT INTO lth_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nën, pacö na cwök na an arömö rïngö yo ïë, ëka tïdï mörö. Ëk arïng yo ïë ëntö pacö nön tïdï rwök. Pathï nï kömanön? Cë kwöna twërö bwöth.” ");
INSERT INTO lth_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Malaika okobo nïnë nï, “Bër, an awinyo kwacni, ba abino tyeko pacö nön. ");
INSERT INTO lth_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ëntö rïng yo kunön pïöpïö, pïën an ba abino tïmö gin mörö na bara ithuno kunön.” (Manön ënë ömïö pacö nön ecwodo nï Joar.) ");
INSERT INTO lth_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ï karë na Lot othuno ï Joar, ceng onwongo dong odonyo. ");
INSERT INTO lth_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Cë Rwoth ooro mac ëka calpa na lyël kï ï polo n'ocwe pïny calö köth ï kom Codom ëka Gomora. ");
INSERT INTO lth_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ën otyeko taun na döngö nön gïnï kanya acël kï ngömgï, ëka jö kïbëc na bedo gïnï ï taun na döngö, ëka thon gin na mar n'otuu kï ï ngöm. ");
INSERT INTO lth_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ëntö dhakö ka Lot ogwilo nge, ëka ölökërë ödökö kadö n'ocung kamë wïr. ");
INSERT INTO lth_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kodiko mërë Abraam öya cön, cë öcïdhö ï kabedo na ën onwongo ocung ïë ï nyim Rwoth. ");
INSERT INTO lth_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ën önënö Codom ëka Gomora, cë önënö iro na dung kï ï kabedo kïbëc na tye ï lobo nön na cal kï mac na lyël kï ï keno. ");
INSERT INTO lth_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ï karë n'Obanga otyeko peci na tye ï kabedo na Lot onwongo bedo ïë, ën opo ï kom cïkërë mërë gïn k'Abraam ëka ölarö Lot kï ï kom can na thwönë rwök. ");
INSERT INTO lth_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot ëka anyira mërë öya gïnï ökö kï ï Joar, cë öcïdhö obedo gïnï ï wi kite, pïën onwongo lworo gïnï bedo ï Joar. Ën ëka anyira mërë arïö obedo gïnï ï rwo. ");
INSERT INTO lth_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ï nïnö mörö acël, nyarë na dit öcakö kobo both amïn mërë na tïdï nï, “Apap ön dong otii ökö, ëka ëcwö mörö ope ï wi lobo na myero obed kï ön kite na cïk më wi lobo kïbëc mïtö. ");
INSERT INTO lth_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Bin, ëmïï apap ön ömadh köngö ölök, ëk ebed ködë ëka enwong ëthïnö.” ");
INSERT INTO lth_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ï kiwor nön gïn ömïö apapgï ömadhö köngö ölök, ëka anyaka na dit ödönyö ï öt cë obedo k'apap mërë. Lot ba ongeo caa na nyarë obedo ködë, ëka caa na ën öya ködë malö. ");
INSERT INTO lth_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kodiko mërë nyarë na dit okobo both amïn mërë na tïdï nï, “Woro kiwor abedo k'apap ön. Ëk dökï ëmïï köngö ölök tin kiwor, ëka in dökï ïcïdh ibed ködë, ëk enwong ëthïnö n'aya kï both apap ön.” ");
INSERT INTO lth_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Cë gïn ömïö apapgï ömadhö köngö ölök ï kiwor nön thon, ëka nyarë na tïdï öcïdhö obedo ködë. Ën dökï ba ongeo caa na nyarë obedo ködë ëka caa na ën öya ködë malö. ");
INSERT INTO lth_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Manön kite n'anyira ka Lot arïö öyac gïnï k'apapgï ködë. ");
INSERT INTO lth_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nyarë na dit önywölö athïn n'ëcwö, ëka öcakö nyïngë Moab. Ënë obedo kwarö ka jö Moab më tin. ");
INSERT INTO lth_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nyarë na tïdï thon önywölö athïn n'ëcwö, ëka öcakö nyïngë Ben Ami. Ënë obedo kwarö ka jö Amon më tin. ");
INSERT INTO lth_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraam öcakö woth më cïdhö ï lobo më Negeb cë ën obedo ï dyere Kadec ëka Cur. Ën obedo ï Gerar pï karë mörö na nönök na calö arok, ");
INSERT INTO lth_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ëka kï kunön Abraam öcakö kobo both jö kïbëc nï, “Cara obedo amëra.” Cë Abimelek, rwoth më Gerar, ooro jögë më cïdhö ömö Cara bothe. ");
INSERT INTO lth_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ëntö ï kiwor mörö acël, Obanga onen both Abimelek ï wang lek ëka okobo nïnë nï, “In itero dhakö na dong ënyömö ökö, ëka pï manön in ibino thöö.” ");
INSERT INTO lth_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek onwongo bara obedo ködë ëka ën okobo nï, “Rwoth, in ibino neko rok mörö na ba öbalö? ");
INSERT INTO lth_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraam okobo nïna nï Cara obedo amïn mërë, ëka Cara thon okobo nï Abraam obedo ömïn mërë. An atïmö man na cwinya leng, ëka cïnga thon ba ötïmö gin mörö.” ");
INSERT INTO lth_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Cë Obanga dökï okobo bothe ï wang lek nï, “Eyo, angeo nï ïtïmö kömanön na cwinyi leng, ëka manön ënë ömïö an ajuki kï ï tïmö bal ï nyima. Manön ënë gin n'ömïö an ba amii ibedo ködë. ");
INSERT INTO lth_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kobedini dong dwök dhakö ni both cwörë, pïën cwörë obedo adwarpïny, ëka ën bino lëgö piri cë ibino kwö. Ëntö ka ba ïdwökö, adyer myero inge nï in kanya acël kï jö më pacöni kïbëc ibino unu thöö.” ");
INSERT INTO lth_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kodiko mërë cön, Abimelek ocwodo etic mërë kïbëc, ëka ï karë na ën okobo bothgï ngö n'ötïmërë, gïn obedo kï lworo na thwönë rwök. ");
INSERT INTO lth_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Cë Abimelek ocwodo Abraam bothe ëka okobo nïnë nï, “Ngö na in ïtïmö ï komwa? Ngö na an abalö nini, n'ömïö in ikelo bal na thwönë ï koma ëka ï kom kerna? In ïtïmö gin n'onwongo myero kür ïtïm ï koma.” ");
INSERT INTO lth_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ëka Abimelek openyo Abraam nï, “Ngö n'ömïö ïtïmö gin ni?” ");
INSERT INTO lth_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraam ögamö nï, “Pïën an athamö nï, ‘Ngat mörö ope na lworo Obanga ï kabedo ni, ëka gïn bino nekona ökö pï dhaköna.’ ");
INSERT INTO lth_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Adyer ën obedo amëra kikokome, nyaka apapna kadï bed ba obedo athïn k'ayana, ëka ën ödökö dhaköna. ");
INSERT INTO lth_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ï karë n'Obanga ökwanya ökö kï ï pacö k'apapna, akobo nïnë nï, ‘Man ënë kite na myero in inyuth nïna marni: Kabedo kïbëc na ön ebino cïdhö ïë, ibino kobo nï, “Ën obedo ömëra.”’” ");
INSERT INTO lth_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Cë Abimelek okelo rom ëka dyegi, dhok, opii na cwö ëka opii na mon cë ömïögï both Abraam, ëka Abimelek ödwökö Cara yo both Abraam. ");
INSERT INTO lth_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ëka Abimelek okobo nï, “Nën, lobona ene kïbëc; bed kany mörö na in ïmïtö.” ");
INSERT INTO lth_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ën okobo both Cara nï, “Nën, an amïö omeru cëkël na römö elip acël. Man obedo më cülöni pï bal mörö këkën na an atïmö ï komi ëka më nyutho both jö kïbëc nï in ba ïbalö gin mörö.” ");
INSERT INTO lth_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Cë Abraam ölëgö both Obanga, ëka Obanga öcangö Abimelek, dhakö mërë, ëka opii mërë na mon, ëk dökï önywöl gïnï ëthïnö, ");
INSERT INTO lth_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","pïën Rwoth onwongo oloro öd nyodo kïbëc kï ï öt ka Abimelek pï köp ï kom Cara, dhakö ka Abraam. ");
INSERT INTO lth_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Rwoth ömïö gum both Cara kite na ën onwongo okobo cön, ëka Rwoth ötïmö kite n'onwongo ën öcïkö. ");
INSERT INTO lth_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Cara öyac ëka önywölö athïn awobi both Abraam ï karë më tio mërë, ï karë n'Obanga öcïkö ën ïë kikokome. ");
INSERT INTO lth_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraam öcakö nyïng athïn na Cara önywölö nï Icaka. ");
INSERT INTO lth_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ï karë na wode Icaka onwongo dong tye nïnö aboro, Abraam ölïrö ën kite n'Obanga onwongo öcïkö ën ködë. ");
INSERT INTO lth_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraam onwongo dong tye kï mwaka mia acël ï karë n'ënywölö wode Icaka. ");
INSERT INTO lth_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Cara okobo nï, “Obanga ömïa anyërö kï yom cwiny ëka jö kïbëc na bino winyo köp ni bino nyërö gïnï köda kï yom cwiny.” ");
INSERT INTO lth_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ëka ömëdö dökï na kobo nï, “Nga n'onwongo bino kobo both Abraam nï Cara bino dödhö ëthïnö? Nën, an anywölö nïnë athïn awobi ï karë më tio mërë.” ");
INSERT INTO lth_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Icaka ödöngö ëka ëkwanyö ökö kï ï cak. Abraam öyübö karama na thwönë rwök ï nïnö n'ëkwanyö ën kï ï cak. ");
INSERT INTO lth_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Kinge na karama othum, Cara önënö awobi na Agar n'obedo dhanö më Ejip önywölö gïn k'Abraam tye ka nywarö Icaka. ");
INSERT INTO lth_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Cë Cara okobo both Abraam nï, “Ryëm dhakö ni n'obedo opii gïn kï wode ökö pïën wod ka dhakö ni ba bino nywakö gin më alea kï woda Icaka.” ");
INSERT INTO lth_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Köp ni ocwero cwiny Abraam rwök pïën Icimael onwongo thon obedo wode. ");
INSERT INTO lth_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ëntö Obanga okobo both Abraam nï, “Kür ïmïï cwinyi ocwer rwök ï kom awobi ëka opiini Agar. Tïm gin na kïbëc na Cara kobo nini, pïën ëthïnö ka Icaka ënë ebino cwodogï nï ëkwaëni. ");
INSERT INTO lth_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","An abino mïö wod ka dhakö n'obedo opii dökö rok thon, pïën ën thon obedo wodi.” ");
INSERT INTO lth_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abraam öya kodiko cön, ökwanyö cem mörö ëka ocwe më pii cë ömïögï both Agar. Ën okethogï ï wi baë, ömïö athïn bothe ëka ömïögï öcïdhö. Agar öcïdhö kï yore ëka obedo ka lath ï thim më Beerceba. ");
INSERT INTO lth_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ï karë na pii othum ökö kï ï ocwe, ën ocibo athïn ï thë bunga mörö acël. ");
INSERT INTO lth_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Cë ën öcïdhö ëka obedo pïny na cwök, na bor mërë röm kï kanya athërö jik ïë k'eyuo, pïën ën onwongo öthamö nï, “Ba amïtö nënö athïn-na ka thöö.” Ëka ën obedo kany nön na bobor ködë, cë ën öcakö koko. ");
INSERT INTO lth_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Obanga owinyo athïn ka kok, ëka malaika k'Obanga ocwodo Agar kï ï polo cë okobo nïnë nï, “Agar, ngö na rac? Kür ibed kï lworo, Obanga owinyo koko k'athïn kï kanya obuto ïë. ");
INSERT INTO lth_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Yaa malö, iting athïn ëka ïmak cïngë, pïën an abino mïö ëkwaë mërë dökö rok na dit.” ");
INSERT INTO lth_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Cë Obanga öyabö wang Agar ëka önënö kulo na pii tye ïë. Ën öcïdhö ötwömö pii cë öpïkö pong ocwe ëka ömïö athïn omodho. ");
INSERT INTO lth_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Obanga onwongo tye k'athïn ni na ën tye ka döngö. Ën obedo ï thim ëka ödökö adwar. ");
INSERT INTO lth_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ën obedo ï thim më Paran, ëka aya mërë önyömö nïnë nyakö kï ï lobo më Ejip. ");
INSERT INTO lth_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ï karë nön Abimelek ëka Pikol adit acikari mërë öcïdhö gïnï both Abraam ëka okobo nï, “Obanga tye kodi ï gin na kïbëc na in ïtïmö. ");
INSERT INTO lth_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kobedini kwongiri botha kany ï nyim Obanga nï ba ibino bwölöna onyo ëthïnöna onyo ëkwaëna. Nyuth nïna ëka lobo na in itye kabedo ïë na calö arok, gin na bër na an thon atïmö bothi.” ");
INSERT INTO lth_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraam okobo nï, “An akwongara.” ");
INSERT INTO lth_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Cë Abraam okok both Abimelek pï kulo na pii tye ïë n'onwongo etic k'Abimelek ocere gïnï ökö ïë. ");
INSERT INTO lth_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ëntö Abimelek okobo nï, “An ba angeo nga n'ötïmö gin ni. In ba ikobo nïna, ëka an awinyo köp ni tin.” ");
INSERT INTO lth_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Cë Abraam ökwanyö rom ëka dhok cë ömïögï both Abimelek, ëka jö arïö ni öcïkërë ï kin-gï. ");
INSERT INTO lth_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraam öyërö nyirom abïrö okethogï path, ");
INSERT INTO lth_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ëka Abimelek openyo Abraam nï, “Pïngö in iketho rom abïrö na path kï kom rom nökënë?” ");
INSERT INTO lth_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ën ögamö nï, “Gam rom abïrö ni kï ï cïnga, na calö caden nï an yam akünyö kulo ni.” ");
INSERT INTO lth_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Manön ënë ömïö ecwodo kabedo nön nï Beerceba, pïën jö arïö okwongere gïnï kunön. ");
INSERT INTO lth_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kinge na cïkërë ötïmërë ï Beerceba, Abimelek ëka Pikol adit acikari mërë ödök gïnï ï lobo ka jö Pilicitain. ");
INSERT INTO lth_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraam öpïdhö yath tamarik ï Beerceba, ëka kany nön ënë ën öwörö Rwoth, Obanga na Bedo Naka. ");
INSERT INTO lth_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ëka Abraam obedo ï lobo ka jö Pilicitain pï karë na lac. ");
INSERT INTO lth_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Kinge karë mörö, Obanga ötëmö Abraam. Ën okobo nïnë nï, “Abraam!” Abraam ögamö nï, “An enene.” ");
INSERT INTO lth_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Cë Obanga okobo nï, “Kwany wodi acël këkën Icaka, na in ïmarö, ëka ïcïdh ï lobo më Moria, ëk ïtyër ën kunön na calö tyër awanga ï wi kidi mörö acël na an abino kobo nini.” ");
INSERT INTO lth_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kodiko cön Abraam öya ëka otweo then më bedo ï wi kana mërë. Ën ökwanyö etic mërë arïö ëka wode Icaka. Ï karë na ën dong otongo yen më tyër awanga, ën öcakö woth më cïdhö ï kabedo n'Obanga onwongo okobo nïnë. ");
INSERT INTO lth_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ï nïnö më adek Abraam otingo wangë malö ëka önënö kabedo nön kï kanya bor. ");
INSERT INTO lth_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Cë Abraam okobo both etic mërë nï, “Bed unu kany kï kana nakun an ëka awobi ni ëcïdhö yo tung ca më wörö Obanga ëka ebino dwogo bothwu.” ");
INSERT INTO lth_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraam ökwanyö yen më tyër awanga cë oketho ï wi wode Icaka, nakun ën ömakö mac ëka pala ï cïngë. Ï karë na jö arïö ni tye ka woth kanya acël, ");
INSERT INTO lth_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Icaka okobo both apap mërë Abraam nï, “Apap!” Apap mërë ögamö nï, “Eyo woda.” Icaka ögamö nï, “Mac ëka yen tye kany, ëntö römö më tyër awanga tye kwene?” ");
INSERT INTO lth_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraam ögamö nï, “Woda, Obanga kikokome bino mïö römö më tyër awanga.” Ëka jö arïö ni ömëdërë gïnï më woth kanya acël. ");
INSERT INTO lth_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ï karë na gïn othuno ï kabedo n'onwongo Obanga okobo nïnë, Abraam ögërö keno tyër kany nön ëka öcanö yen ï wie. Ën otweo wode Icaka ëka opyelo ï wi keno tyër, ï wi yen. ");
INSERT INTO lth_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Cë Abraam ökwanyö pala ëka otingo cïngë malö më neko wode. ");
INSERT INTO lth_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ëntö malaika ka Rwoth ocwodo Abraam kï ï polo nï, “Abraam! Abraam!” Ën ögamö nï, “An enene.” ");
INSERT INTO lth_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ën okobo nï, “Kür iketh cingi ï kom awobi nön. Kür ïtïm gin mörö ï kome. Kobedi dong an angeo nï in ilworo Obanga, pïën in ba itwona wodi, wodi acël këkën.” ");
INSERT INTO lth_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraam otingo wangë, cë önënö römö tye yo kungee na tunge omoko ökö. Ën öcïdhö cë ökwanyö römö ëka ötyërö na calö tyër awanga nakaka wode. ");
INSERT INTO lth_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraam öcakö nyïng kabedo nön nï “Rwoth ënë bino mïö.” Ëka naka tin ekobo nï, “Ï wi kidi ka Rwoth ebino mïö.” ");
INSERT INTO lth_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Malaika ka Rwoth ocwodo Abraam wang më arïö kï ï polo. ");
INSERT INTO lth_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Cë okobo nï, “Rwoth okobo nï, ‘An akwongara kï nyïnga këna, pïën in ïtïmö gin ni ëka ba itwona wodi, wodi acël këkën, ");
INSERT INTO lth_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","an abino mïöni gum, ëka an abino mïö ëkwaëni bedo na pol calö cër na tye ï wi polo ëka na calö kwo na tye ï dhö nam. Ëkwaëni bino löönö jami më pacö ka lang-gï, ");
INSERT INTO lth_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ëka kï kom ëkwaëni, rok kïbëc na tye ï wi lobo bino bedo kï gum, pïën in ibedo kï winy ï koma.’” ");
INSERT INTO lth_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Cë Abraam odwogo both etic mërë, ëka öcakö cïdhö gïnï yo Beerceba kanya Abraam obedo ïë. ");
INSERT INTO lth_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Kinge karë mörö, ekobo both Abraam nï, “Milca thon önywölö ëthïnö k'omeru Nakor: ");
INSERT INTO lth_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uj obedo athïn kaö, ömïn mërë Buj, Kemuel (apap k'Aram), ");
INSERT INTO lth_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keced, Kajo, Pildac, Jidlap ëka Betuel.” ");
INSERT INTO lth_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel önywölö Rebeka. Milca önywölö ëthïnö aboro kï Nakor ömïn Abraam. ");
INSERT INTO lth_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nakor onwongo thon tye kï dhakö nökënë n'ecwodo nï Reuma, n'önywölö thon awope: Teba, Gaam, Taac ëka Maaca. ");
INSERT INTO lth_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Cara obedo ï wi lobo pï mwaka 127. ");
INSERT INTO lth_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ën öthöö ï Kiriat Arba (na kobedini ecwodo nï Kebron) na tye ï lobo Kanaan. Abraam ödönyö ï këma më kumo pï Cara ëka okoko ën. ");
INSERT INTO lth_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Cë Abraam öya kï ï nget lyël ka dhakö mërë ëka öcïdhö okobo both jö Kit nï, ");
INSERT INTO lth_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“An abedo welo ëka arok ï kinwu. Cadh nïna unu kany mörö më ik ëk aik dhanöna n'öthöö ïë.” ");
INSERT INTO lth_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Jö Kit ögamö dhö Abraam nï, ");
INSERT INTO lth_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Adwong, winywa. In ibedo ngat na dit ï kinwa kany. Ik kom athööni ï bur lyël mörö na bër na in ïyërö kï kin bur lyenewa ni. Ngat mörö ope na bino kwërö nini ï bur lyënë më iko athööni ïë.” ");
INSERT INTO lth_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Cë Abraam öya ëka oryebere pïny ï nyim jö Kit. ");
INSERT INTO lth_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ën okobo bothgï nï, “Ka un iye më mïöna iko athööna, cë winya unu ëka kwa unu nïna Epron wod ka Joar ");
INSERT INTO lth_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ëk öcadh nïna rwo më Makpela, n'obedo mëgë na tye ï ajiki më pwodho mërë. Peny unu ën ëk öcadh nïna ï wel mërë kikokome na römö wïlö ëk obed na calö kabedo më ik na tye ï kinwu.” ");
INSERT INTO lth_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ï karë nön Epron onwongo obedo ï kin jö Kit ëka ën ögamö dhö Abraam na jö Kit kïbëc tye ka winyo, n'onwongo obino gïnï ï kabedo më athuko na tye ï dhö wangkac më pacö mërë. ");
INSERT INTO lth_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Ën okobo nï, “Pathï nï kömanön rwothna, winy köpna. An amïö pwodho bothi, ëka amïö rwo na tye ïë. An amii ï nyim jö na mëga. Ik jö na megi ïë.” ");
INSERT INTO lth_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraam dökï oryebere ï nyim jö Kit ");
INSERT INTO lth_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ëka okobo both Epron na gïn tye ka winyo nï, “Winy unu köpna, ka un iye. An abino cülö wel më pwodho. Yee unu nïna ëk aik dhaköna n'öthöö kunön.” ");
INSERT INTO lth_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Epron ögamö dhö Abraam nï, ");
INSERT INTO lth_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Winy köpna, rwothna, wel lobo nön römö cëkël më ryal 400, ëntö ngö ënön na tye ï kin an kï in? Ik jö na megi n'öthöö ïë.” ");
INSERT INTO lth_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraam oye köp ka Epron, cë opimo wel ryal ï nyim jö Kit na römö cëkël më ryal 400, nakun pimo kï kidi ratili n'ëcath pimo kï jami ï karë nön. ");
INSERT INTO lth_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Pwodho ka Epron na tye ï Makpela, n'onwongo tye kukïdë më Mamre—pwodho ëka rwo na tye ïë, ëka yen kïbëc na tye ï wang abakëth më pwodho—onwongo ëmïö ökö ");
INSERT INTO lth_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","both Abraam na calö mëgë ï nyim jö Kit n'onwongo obino gïnï ï dhö wangkac më pacö. ");
INSERT INTO lth_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kinge manön Abraam oiko dhakö mërë Cara ï rwo na tye ï pwodho më Makpela na tye kukïdë më Mamre (manön, Kebron) na tye ï lobo më Kanaan. ");
INSERT INTO lth_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Jö Kit ömïö pwodho ëka rwo n'onwongo tye ïë both Abraam na calö kabedo më ik. ");
INSERT INTO lth_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraam onwongo dong otii ëka mwaka mërë më tio onwongo pol. Rwoth onwongo ömïö ën gum ï gin na kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraam okobo both atic mërë na dit na tye ï ödë n'onwongo ënë löö gin na kïbëc n'onwongo ën tye ködë nï, “Keth cingi ï kin ema. ");
INSERT INTO lth_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","An amïtö nï in ikwongiri kï nyïng Rwoth, Obanga n'ocweo polo kï lobo, nï in ba ibino nyömö nï woda dhakö kï ï kin anyira ka jö Kanaan, na an atye ï kin-gï. ");
INSERT INTO lth_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ëntö ibino cïdhö ï lobo n'ënywöla ïë ëka both wedena kikokome cë ïnyöm dhakö nï woda Icaka.” ");
INSERT INTO lth_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Atic k'Abraam openyo ën nï, “Cë ka dhakö ënë ba oyeo më bino köda ï lobo ni? An myero ater wodi ï lobo na yam in ïya kï ïë?” ");
INSERT INTO lth_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraam ögamö nï, “Gwokiri, kür iter woda yo kunön. ");
INSERT INTO lth_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Rwoth, n'obedo Obanga n'ocweo polo, n'ökwanya kï ï öt k'apapna, kï ï lobo n'ënywöla ïë ëka n'ötwak köda cë öcïkërë botha kï kwong nï, ‘Abino mïö ëkwaëni lobo ni,’ ën bino oro malaika mërë më cïdhö anyim nini ëk in ïnyöm dhakö nï woda kï kunön. ");
INSERT INTO lth_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ëntö ka dhakö ënë ökwërö më bino kodi, cë in ibino bedo agönya kï kom kwongna ni. Ëntö kür iter woda yo kunön.” ");
INSERT INTO lth_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Cë atic k'Abraam oketho cïngë ï kin em adwong mërë ëka okwongere bothe na lübërë kï köp ni. ");
INSERT INTO lth_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Cë atic k'Abraam ökwanyö jami kïbëc na bëcö n'adwong mërë ömïö bothe ëka otweogï inge kïnaga apar k'adwong mërë cë öcakö woth më cïdhö yo Aram Naaraim, ï pacö kanya Nakor onwongo bedo ïë. ");
INSERT INTO lth_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ï karë na ën othuno kunön, ën ömïö kïnaga orumo cöng-gï pïny ï nget kulo na tye ï nge pacö. Pïny onwongo dong kothyeno caa na mon bwörö ködë yo kulo më cïdhö twömö pii. ");
INSERT INTO lth_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Cë ën ölëgö nï, “Rwoth, Obanga k'adwongna Abraam, mïï gin na abino ïë ocobere, ëka inyuth kïcani both adwongna Abraam. ");
INSERT INTO lth_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","An enene, acung ï nget kulo, ëka anyira ka jïï na bedo gïnï ï pacö ni tye ka bino më twömö pii. ");
INSERT INTO lth_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","An abino kobo both nyakö mörö acël nï, ‘Mïa pii amodhi,’ cë okobo nï, ‘Modhi, ëka an abino mïö kïnagani thon modho,’ mïï ën obed nyakö na in ïyërö pï aticni Icaka. Ëka manön mïö an angeo nï in dong inyutho kïcani both adwongna.” ");
INSERT INTO lth_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Na bara ën otyeko lëga, nyakö mörö obino n'otingo agulu mërë ï wi baë. Nyïngë onwongo ecwodo nï Rebeka. Ën onwongo obedo nyaka Betuel wod ka Milca n'onwongo obedo dhakö ka Nakor ömïn Abraam. ");
INSERT INTO lth_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nyakö ni onwongo leng rwök, nyakö na bara ongeo ëcwö, na ngat mörö bara obedo ködë. Ën öcïdhö yo kulo, cë ötwömö pii ï agulu mërë ëka odwogo cen. ");
INSERT INTO lth_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Atic k'Abraam öbünyö woth më romo ködë ëka okobo nïnë nï, “Öma mïa pii mörö kï ï aguluni amodhi.” ");
INSERT INTO lth_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nyakö ögamö nï, “Eyo adwongna, modh pii.” Cë ën ökwanyö agulu ökö kï ï wi baë otingo atinga ï cïngë nakun atic k'Abraam tye ka modho. ");
INSERT INTO lth_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kinge na ën dong ömïö pii më amodha, nyakö okobo nï, “An abino twömö pii pï kïnagani thon, naka ka gïn otyeko modho.” ");
INSERT INTO lth_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Cë pïöpïö ën öönyö pii ï öd pwa, ëka örïngö ödök cen më twömö pii kï ï kulo pï kïnaga mërë kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Atic k'Abraam ölïng ba okobo gin mörö, ëntö ën obedo ka nënö Rebeka alïlïng, pïën ën onwongo mïtö ngeo ka cë Rwoth ömïö woth mërë ocobere onyo pe. ");
INSERT INTO lth_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ï karë na kïnaga otyeko gïnï modho, atic k'Abraam ökwanyö gwïlü um n'obedo gol ëka atëgö arïö cë ömïögï bothe. ");
INSERT INTO lth_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Cë ën openyo nï, “In ibedo nyaka nga? Öma kob nïna, kabuto mörö tye ï öt k'apapni na wan ëtwërö nïnö ïë ï kiwor?” ");
INSERT INTO lth_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nyakö ögamö nïnë nï, “An abedo nyaka Betuel, wod ka Milca n'önywölö both Nakor.” ");
INSERT INTO lth_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ën ömëdërë nï, “Wan etye kï cem na römö, ëka kabuto pï un më nïnö ï kiwor.” ");
INSERT INTO lth_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Cë atic k'Abraam okulo wie pïny ëka öwörö Rwoth, ");
INSERT INTO lth_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","nakun kobo nï, “Pak obed both Rwoth, Obanga k'adwongna Abraam, n'ögwökö mar ëka gen mërë na ba lökërë ï kom adwongna. Rwoth ötëla ï wothna yo öt ka wede k'adwongna.” ");
INSERT INTO lth_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Cë Rebeka örïngö ëka okobo gin n'ötïmërë kïbëc both jö na tye ï öt k'aya mërë. ");
INSERT INTO lth_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka onwongo tye k'ömïn mërë n'ecwodo nï Laban, n'örïngö më romo k'ëcwö nön ï kulo. ");
INSERT INTO lth_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Cücüth na ën önënö gwïlü um, atëgö kï ï ngut cïng amïn mërë, ëka owinyo gin n'onwongo Rebeka ötwakö ï kom ngö n'atic k'Abraam okobo nïnë, ën öcïdhö both atic k'Abraam n'onwongo ocung ï nget kïnaga na cwök kï kulo. ");
INSERT INTO lth_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban okobo nïnë nï, “Bin, in na Rwoth ömïö gum ï komi! Pïngö in icung kany? An ayübö öt nini ëka kabedo pï kïnaga.” ");
INSERT INTO lth_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Atic k'Abraam öcïdhö yo pacö gïn kï Laban, ëka ëgönyö yëc kï nge kïnaga cë ëmïögï cem ëka kabuto. Ëmïö pii both atic k'Abraam ëka jö na ën owotho ködë ëk ölwök gïnï tyën-gï. ");
INSERT INTO lth_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ï karë n'ekelo cem ï nyime, ën okobo nï, “An ba acemo naka ka an akobo gin na myero akob.” Cë Laban okobo nï, “Kob nïwa.” ");
INSERT INTO lth_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Atic k'Abraam okobo nï, “An abedo atic k'Abraam. ");
INSERT INTO lth_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Rwoth ömïö gum na thwönë rwök both adwongna, ëka ën ödökö alönyö. Rwoth ömïö ën rom ëka dhok, ryal ëka gol, etic n'obedo cwö ëka etic na mon, kïnaga ëka kene. ");
INSERT INTO lth_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Cara, dhakö k'adwongna, önywölö nïnë athïn n'ëcwö ï karë më tio mërë, ëka Abraam ömïö jami kïbëc n'obedo mëgë bothe. ");
INSERT INTO lth_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ëka adwongna ömïö an akwongo kwong, ëka okobo nï, ‘In myero kür ïnyöm dhakö nï woda kï ï kin anyira ka jö Kanaan, ï lobo ni na an akwö ïë, ");
INSERT INTO lth_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ëntö cïdh ï öt k'apapna ëka yo both kakana, cë ïnyöm dhakö nï woda.’ ");
INSERT INTO lth_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Cë an apenyo adwongna nï, ‘Cë ka dhakö ökwërö woth köda?’ ");
INSERT INTO lth_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Adwongna ögamö nï, ‘Rwoth na an abedo kwö ï nyime ï yoo n'opore, bino oro malaika mërë wotho kodi ëka mïö wothni cobere, ëk in ïnyöm dhakö nï woda kï ï kakana kikokome ëka kï ï öt k'apapna. ");
INSERT INTO lth_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Cë ka in ïcïdhö ï kakana, in ibino bedo agönya kï kom kwongna kadï bed gïn bino kwërö më mïöni—in ibino bedo agönya kï kom kwongna.’ ");
INSERT INTO lth_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ï karë na an abino ï kulo tin, an akobo nï, ‘Rwoth, Obanga k'adwongna Abraam, ka in ïmïtö, mïï wothna ocobere. ");
INSERT INTO lth_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","An enene, an acung ï nget kulo ni; ka nyakö mörö obino më twömö pii ëka an akobo nïnë nï, “Öma mïa pii mörö amodhi kï ï aguluni,” ");
INSERT INTO lth_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","cë ka ën okobo nïna nï, “Modhi, ëka an abino twömö pii amïö kïnagani thon modho,” ëk ën obed nyakö na Rwoth öyërö pï wod k'adwongna.’ ");
INSERT INTO lth_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Na an bara atyeko lëga kï ï cwinya, Rebeka obino n'otingo angulu ï wi baë. Ën ödönyö ï kulo cë ötwömö pii, ëka an akobo nïnë nï, ‘Öma mïa pii mörö amodhi.’ ");
INSERT INTO lth_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Rebeka ökwanyö agulu kï ï wi baë pïöpïö ëka okobo nï, ‘Modhi, an abino mïö kïnagani thon modho.’ Cë an amodho ëka ën ömïö kïnaga thon omodho. ");
INSERT INTO lth_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“An dong apenyo Rebeka nï, ‘In ibedo nyaka nga?’ “Ën ögamö nï, ‘An abedo nyaka Betuel wod ka Nakor, na Milca önywölö nïnë.’ “Cë an aketho gwïlü ï ume ëka atëgö ï ngut cïngë, ");
INSERT INTO lth_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","cë arumo cönga pïny ëka awörö Rwoth. An apakö Rwoth, Obanga k'adwongna Abraam, n'ötëla ï yoo n'atïr më nwongo akwar nyaka ömïn adwongna pï wode. ");
INSERT INTO lth_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kobedini dong ka ibino nyutho marni ëka kïcani both adwongna, kob nïna; ëka ka pe, kob nïna, ëk ange gin na myero an atïm.” ");
INSERT INTO lth_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban ëka Betuel ögamö gïnï nï, “Man obedo yüb ka Rwoth; wan ba ërömö kobo gin mörö bothi. ");
INSERT INTO lth_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka ene; ter ën ëk öcïdh obed dhakö ka wod k'adwongni, kite na Rwoth onyutho nini ködë.” ");
INSERT INTO lth_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ï karë n'atic k'Abraam owinyo ngö na gïn okobo, ën orumo cöngë pïny ï nyim Rwoth. ");
INSERT INTO lth_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Cë atic k'Abraam ökwanyö gol, ryal ëka böng cë ömïö both Rebeka; ën thon ömïö mïc na welgï tëk both ömïn nyakö ëka aya ka nyakö. ");
INSERT INTO lth_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kinge man, atic k'Abraam ëka jö na ën owotho ködë ocemo cë önïnö gïnï kunön. Ï karë na gïn oco kodiko mërë, atic k'Abraam okobo nï, “Yee nïna adök cen both adwongna.” ");
INSERT INTO lth_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ëntö ömïn nyakö k'aya ka nyakö ögamö gïnï nï, “Ëk nyakö obed bothwa pï nïnö na römö apar; cë ën twërö cïdhö.” ");
INSERT INTO lth_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ëntö atic k'Abraam okobo bothgï nï, “Kür ïjüka unu, kite na Rwoth dong ömïö wothna ocobere na bër. Wëka unu acïdh ëk adök cen both adwongna.” ");
INSERT INTO lth_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Cë gïn okobo nï, “Eru ecwod nyakö ëk epeny ngö na ën römö kobo.” ");
INSERT INTO lth_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Cë gïn ocwodo Rebeka ëka epenyo ën nï, “In ibino woth k'ëcwö ni?” Rebeka ögamö nï, “An abino cïdhö.” ");
INSERT INTO lth_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Cë gïn oye n'amïn-gï Rebeka kanya acël k'atic mërë na dhakö n'ögwökö ën ï karë na ën pod tïdï më cïdhö k'atic k'Abraam ëka kï jö na ën owotho ködë. ");
INSERT INTO lth_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ölamö gïnï gum ï kom Rebeka ëka ekobo nïnë nï, “Amïnwa, in myero ibed aya ka jö na pol; ëkwaëni myero obed na tëk ëka ölöö gïnï lang-gï.” ");
INSERT INTO lth_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Cë Rebeka k'etic mërë n'obedo anyira öyübërë cë obedo gïnï ï wi kïnaga ëka owotho gïnï k'atic k'Abraam. ");
INSERT INTO lth_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ï karë nön Icaka onwongo obino kï ï Beer Lakai Roi, pïën ën onwongo bedo ï Negeb. ");
INSERT INTO lth_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ï kothyeno mörö acël, Icaka onwongo tye ka lath ï bar, ï karë na ën otingo wangë malö, ën önënö kïnaga na pol ka tye ka bino. ");
INSERT INTO lth_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka thon otingo wangë malö cë önënö Icaka. Rebeka opye pïny kï ï wi kïnaga mërë ");
INSERT INTO lth_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ëka openyo atic k'Abraam nï, “Ëcwö mënë ca na tye ï bar nakun tye ka bino më romo kod onu?” Atic k'Abraam ögamö nï, “Manön adwongna.” Cë Rebeka ökwanyö atam ëka oumo kï terinyime. ");
INSERT INTO lth_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Atic k'Abraam okobo gin na kïbëc na ën ëtïmö both Icaka. ");
INSERT INTO lth_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Cë Icaka okelo Rebeka ï këma k'aya mërë ëka obedo ködë, ödökö dhakö mërë na ën ömarö. Cwiny Icaka okwe kinge thöö k'aya mërë Cara. ");
INSERT INTO lth_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraam dökï obino önyömö dhakö nökënë na nyïngë Ketura. ");
INSERT INTO lth_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ën obino önywölö nïnë Yimran, Yokocan, Medan, Midian, Icibak ëka Cuak. ");
INSERT INTO lth_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokocan önywölö Ceba ëka Dedan. Ëkwaë ka Dedan ënë jö Acurit, jö Letuc, ëka jö Leum. ");
INSERT INTO lth_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Awope ka Midian ënë Epa, Eper, Anok, Abida, ëka Elda. Man kïbëc onwongo obedo gïnï ëkwaë ka Ketura. ");
INSERT INTO lth_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraam ömïö gin na kïbëc na ën onwongo tye ködë both wode Icaka. ");
INSERT INTO lth_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ëntö ï karë na ën onwongo pod kwö, ën obino ömïö mïc both ëthïnö na mon mërë nökënë önywölö ëka ömïögï öcïdhö ökö kï both Icaka yo ngöm na tye yo kukïdë. ");
INSERT INTO lth_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraam obino obedo ï wi lobo pï mwaka 175. ");
INSERT INTO lth_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Cë öthöö na mwaka mërë dong dit, na dong otengo rwök cë eiko ën kanya acël kï kwere mërë. ");
INSERT INTO lth_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Awope mërë Icaka ëka Icimael, oiko gïnï ën ï rwo më Makpela na cwöcwök kï Mamre, ï pwodho ka Epron wod ka Joar n'obedo dhanö më Kit, ");
INSERT INTO lth_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","kunön ënë pwodho na yam Abraam öwïlö kï both jö Kit ëka eiko ën kï dhakö mërë Cara ïë. ");
INSERT INTO lth_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Kinge na dong Abraam öthöö, Obanga obino ömïö wode Icaka gum, cë Icaka obedo na cwöcwök kï Beer Lakai Roi. ");
INSERT INTO lth_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Man ënë ëkwaë ka Icimael wod k'Abraam, na Agar, atic ka Cara n'obedo nya jö Ejip, önywölö both Abraam. ");
INSERT INTO lth_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Man ënë nyïng awope ka Icimael, na lübërë kï kite n'ënywölögï ködë körë kï körë. Nebayot ënë obedo kaö ka Icimael ëka dong Kedar, Adbel, Mibcam, ");
INSERT INTO lth_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Micma, Duma, Maca, ");
INSERT INTO lth_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adad, Tema, Jetur, Napic ëka Kedema. ");
INSERT INTO lth_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Man ënë awope ka Icimael, n'onwongo obedo gïnï rwodhi më kaka apar arïö na lübërë kï peci ëka këmagï. ");
INSERT INTO lth_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Icimael obino obedo ï wi lobo pï mwaka 137 cë dong öthöö, ëka eiko ën kanya acël kï kwere mërë. ");
INSERT INTO lth_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Lobo ka jö ka Icimael öcakërë kï ï Kabila thuno ködë naka yo Cur, na cwök kï wang lobo më Ejip na dök yo Aciria. Ëka gïn onwongo bedo na dagërë gïnï kï utmegogï nökënë kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Man ënë ëkwaë ka Icaka wod ka Abraam. Abraam önywölö Icaka. ");
INSERT INTO lth_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Icaka onwongo dong tye kï mwaka pyer angwën ï karë na ën nyömö Rebeka nyaka Betuel n'obedo dhanö më Aram na tye ï Paddan Aram, ëka amïn Laban dhanö më Aram. ");
INSERT INTO lth_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Icaka obino ölëgö both Rwoth pï dhakö mërë, pïën Rebeka onwongo obedo alür. Rwoth ögamö lëga mërë cë dhakö mërë Rebeka obino öyac. ");
INSERT INTO lth_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ëthïnö obedo ka twomere kën-gï kï ïë, cë Rebeka okobo nï, “Pïngö gin ni tye ka tïmërë ï koma?” Cë ën openyo Rwoth. ");
INSERT INTO lth_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ëka Rwoth okobo nïnë nï, “Rok arïö tye ï ii, ëka rok arïö kï bothi bino pokere gïnï ökö, rok acël bino bedo na tëk na löö awodhe, ëka athïn na dit bino tic pï athïn na tïdï.” ");
INSERT INTO lth_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ï karë na caa mërë më nywöl dong örömö, Rebeka obino ongeo nï adyer etye kï rudi ï ïë. ");
INSERT INTO lth_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Athïn n'ëcakö nywölö onwongo kwar ëka kome opong yer, cë gïn obino öcakö nyïngë Ecau. ");
INSERT INTO lth_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kinge, ebino ënywölö ömïn mërë n'ömakö opuny tyën Ecau, cë gïn obino öcakö nyïngë Jakob. Icaka onwongo dong tye kï mwaka 60 ï karë na Rebeka nywölö ëthïnö mërë. ");
INSERT INTO lth_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ëthïnö awope ödöngö ëka Ecau obino obedo adwar na tye kï dïrü, ën onwongo marö woth ï lum, ëntö Jakob onwongo obedo dhanö na lïng alïnga na marö bedo pacö. ");
INSERT INTO lth_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Icaka onwongo marö Ecau rwök pïën onwongo marö camö ringo leeni na ën neko, ëntö Rebeka onwongo marö Jakob. ");
INSERT INTO lth_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ï nïnö mörö acël Jakob onwongo tye ka tedo dëk, cë Ecau obino kï ï lum na kec oneko. ");
INSERT INTO lth_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ën okobo both Jakob nï, “Mïa dëk nön mörö acam pïën kec oneka rwök.” (Ënë ömïö onwongo ecwodo ën thon nï Edom.) ");
INSERT INTO lth_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jakob ögamö nï, “An abino mïöni ka in ïmïa twëröni më bedo kaö.” ");
INSERT INTO lth_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ecau ögamö nï, “Nën, an dong acwök thöö, ngö na twërö më bedo kaö tïmö nïna?” ");
INSERT INTO lth_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ëntö Jakob okobo nï, “Kwongiri botha kono.” Cë Ecau okwongere nakun cadhö twërö mërë më kaö both Jakob. ");
INSERT INTO lth_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Cë Jakob ömïö Ecau kwon ëka dëk. Ën ocemo ëka omodho cë öya öcïdhö. Manön ënë kite n'Ecau öcadhö kï twërö mërë më kaö. ");
INSERT INTO lth_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ï karë mörö kec na rac rwök obino opodho ï lobo n'onwongo Icaka bedo ïë na path kï kec na yam opodho ï karë k'Abraam. Icaka obino öcïdhö ï pacö më Gerar both Abimelek rwoth më Pilicitain. ");
INSERT INTO lth_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Cë Rwoth onen both Icaka ëka okobo nï, “Kür ïcïdh yo Ejip, bed ï lobo na an akobo nï ibed ïë. ");
INSERT INTO lth_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Bed ï lobo ni pï karë mörö na nönök, ëka an abino bedo kodi ëka amii gum. Pï in ëka ëkwaëni an abino mïöwu lobo ni kïbëc ëka abino cobo kwong na an acïkara ködë both apapni Abraam. ");
INSERT INTO lth_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","An abino mïö ëkwaëni bedo na pol calö cër na tye ï wi polo ëka abino mïögï lobo ni kïbëc, ëka pï ëkwaëni, jö kïbëc më lobo bino nwongo gïnï gum, ");
INSERT INTO lth_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","pïën Abraam obedo kï winy ï koma, ötïmö gin na an akobo nïnë nï ötïm, ögwökö köpna ëka cïkna.” ");
INSERT INTO lth_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Cë Icaka obino obedo ï Gerar. ");
INSERT INTO lth_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ï karë na cwö më kabedo nön openyo ën pï dhakö mërë, ën okobo nï, “Ën obedo amëra,” pïën ën onwongo tye kï lworo më kobo nï, “Ën obedo dhaköna.” Ën öthamö nï, “Cwö më kabedo ni twërö nekona pï Rebeka pïën ën leng rwök.” ");
INSERT INTO lth_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ï karë na Icaka obedo kunön pï karë na lac, Abimelek rwoth më Pilicitain önënö Icaka kï ï wang derica ka tye ka tuko kï dhakö mërë Rebeka. ");
INSERT INTO lth_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Cë Abimelek ocwodo Icaka ëka okobo nïnë nï, “Ën obedo dhaköni adyer! Pïngö in ikobo nï ën obedo ameru?” Icaka ögamö nïnë nï, “Pïën athamö nï ërömö nekona ökö pïrë.” ");
INSERT INTO lth_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Cë Abimelek okobo nï, “Ngö na in ïtïmö ï komwa? Ngat mörö acël onwongo römö bedo ökö kï dhaköni, ëka in onwongo ïrömö kelo bal ni ï wiwa.” ");
INSERT INTO lth_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Cë Abimelek öcïkö jö kïbëc nï, “Ngat mörö n'ogudo ëcwö ni onyo dhakö mërë ebino neko ökö.” ");
INSERT INTO lth_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ï karë na Icaka opuro ï mwaka nön, ën ökaö kac na thwönë na kadhö wang mia acël na ën öcwö ökö, pïën Rwoth ömïö gum bothe. ");
INSERT INTO lth_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Icaka obino ölöny, ëka lönyö mërë ömëdërë naka obino obedo thwön alönyö. ");
INSERT INTO lth_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ën onwongo tye kï rom ëka dyegi, dhok ëka etic na pol naka ömïö jö Pilicitain nyeko ömakögï ökö ï kome. ");
INSERT INTO lth_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Cë kulo kïbëc na yam etic k'apap mërë Abraam ogolo ï karë k'Abraam, jö Pilicitain obino öcülö ökö, nakun eumo ökö kï lobo. ");
INSERT INTO lth_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Cë Abimelek okobo both Icaka nï, “Yaa ökö kï bothwa pïën in dong ïdökö na tëk rwök na lööwa ökö.” ");
INSERT INTO lth_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Cë Icaka öya ökö kï kany nön ëka öcïdhö oguro këma mërë ï ora më Gerar ëka ën obedo kunön. ");
INSERT INTO lth_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Cë Icaka dökï ogolo kulo na yam egolo ï karë k'apap mërë Abraam, na jö Pilicitain obino öcülö kinge thöö k'Abraam, ëka öcakö nyïng-gï kite na yam apap mërë Abraam öcakö ködë. ");
INSERT INTO lth_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Etic ka Icaka ogolo kulo ï öd ora ëka onwongo gïnï pii na mït na möl. ");
INSERT INTO lth_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ëntö ëkwath më Gerar ödhaa gïnï k'ëkwath ka Icaka nakun kobo gïnï nï, “Pii ni obedo mëwa!” Cë Icaka öcakö nyïng kulo nön Ecek, pïën gïn ödhaa ködë. ");
INSERT INTO lth_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Cë etic mërë dökï ogolo kulo nökënë ëntö manön thon ëdhaa ködgï ïë, cë ën öcakö nyïngë Citina. ");
INSERT INTO lth_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ën öya kï kunön ëka ogolo kulo nökënë, cë ngat mörö ba dökï ödhaa ködgï ïë. Ën öcakö nyïng kulo nön Rekobot nakun kobo nï, “Kobedini Rwoth dong ömïöwa kabedo na lac ëka onu ebino löny ï lobo ni.” ");
INSERT INTO lth_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Icaka obino öcïdhö naka yo Beerceba. ");
INSERT INTO lth_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ï kiwor nön, Rwoth onen bothe ëka okobo nïnë nï, “An abedo Obanga k'apapni Abraam. Kür ibed na lwor pïën an atye kodi. An abino mïöni gum ëka abino mïö wel ëkwaëni nya dökö na pol pï aticna Abraam.” ");
INSERT INTO lth_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Icaka ögërö keno tyër kunön ëka öwörö Rwoth. Ën ögërö këma mërë ëka etic mërë ogolo kulo nökënë kunön. ");
INSERT INTO lth_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Cë Abimelek öya kï ï Gerar kanya acël k'amïï thama mërë Aujat ëka Pikol n'obedo adit wi acikari mërë cë obino gïnï yo both Icaka. ");
INSERT INTO lth_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Icaka openyogï nï, “Pïngö ibino unu botha nakun ïdaga unu ëka ïryëma unu ökö?” ");
INSERT INTO lth_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Gïn ögamö nï, “Wan ënënö kanyalër nï Rwoth onwongo tye kodi, cë ömïö wan ekobo nï, ‘Myero wan ebed kï kwong ï kinwa ëka in.’ Ëk wan emok cïkërë kodi ");
INSERT INTO lth_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ëk kür ïtïm gin mörö na rac ï komwa, kite na wan thon ba ebino ëtïmö gin mörö na rac ï komi, ëntö emii ïcïdhö kï kuc. Ëka kobedini Rwoth dong ömïö gum bothi.” ");
INSERT INTO lth_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Icaka dong öcakö yübö nïgï karama cë gïn ocemo ëka omedho. ");
INSERT INTO lth_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kodiko mërë cön gïn okwongere both ngat acëlacël. Cë Icaka ömïögï öcïdhö kï yorgï ëka gïn öwëkö ën kï kuc. ");
INSERT INTO lth_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ï nïnö nonu etic ka Icaka obino ëka okobo gïnï both Icaka köp ï kom kulo na gïn ogolo. Gïn okobo nï, “Wan enwongo pii!” ");
INSERT INTO lth_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ën öcakö nyïng kulo nön Ciba, ëka naka tin nyïng pacö nön ecwodo nï Beerceba. ");
INSERT INTO lth_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ï karë n'Ecau dong tye kï mwaka pyer angwën, ën obino önyömö Judit nyaka Beeri dhanö më Kit ëka thon Bacemat nyaka Elon dhanö më Itite. ");
INSERT INTO lth_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Gïn obino ömïö cwer cwiny both Icaka ëka Rebeka rwök. ");
INSERT INTO lth_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ï karë na dong Icaka otii ëka wangë ödökö na görü, na ba dökï römö nënö pïny, ën ocwodo wode na dit Ecau ëka okobo nïnë nï, “Woda.” Ecau ögamö nï, “An enene apap.” ");
INSERT INTO lth_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Icaka okobo nïnë nï, “An dong atii ökö, ëka ba angeo nïnö më thööna. ");
INSERT INTO lth_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kobedini dong, kwany jamini më dwar—ocwe athërö ëka atum ëk ïcïdh ï lum ïdwar lee mörö nïna. ");
INSERT INTO lth_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Yüb nïna koth cem na mït na an amarö ëka ikel nïna acam, ëk amii gumna na bara athöö.” ");
INSERT INTO lth_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ï caa nön Rebeka onwongo tye ka winyo ka Icaka twak kï wode Ecau. Ï karë n'Ecau dong öcïdhö ï lum më dwarö lee ëk ekel, ");
INSERT INTO lth_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka okobo both wode Jakob nï, “Nën, an awinyo apapni kobo both omeru Ecau nï, ");
INSERT INTO lth_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Kel nïna ringo lee mörö ëka ïyüb nïna na mït më acama, ëk an amii gumna ï nyim Rwoth na bara athöö.’ ");
INSERT INTO lth_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Dong, woda, winy na bër ëka ïtïm gin na an akobo nini. ");
INSERT INTO lth_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Cïdh ï kin rom kï dyegi ëk ikel nïna nyi dyegi arïö n'öcwëë ëk ayüb n'apapni na mït kite na ën marö ködë. ");
INSERT INTO lth_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Cë iter both apapni öcam ëk omii gum mërë na ën bara öthöö.” ");
INSERT INTO lth_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakob okobo both aya mërë Rebeka nï, “Ëntö ömëra Ecau kome opong yer, ëka an koma pwöth. ");
INSERT INTO lth_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Cë ka apapna oguda? Arömö nen calö ngat na bwölö ën ëka römö kelo cen nakaka gum.” ");
INSERT INTO lth_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Aya mërë okobo nïnë nï, “Woda, ëk cen obin ï koma. Tïm gin na an akobo nini këkën, cïdhï ëka ikelgï nïna.” ");
INSERT INTO lth_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Cë Jakob öcïdhö ëka onwongo dyegi cë okelo both aya mërë, cë Rebeka öyübö cem na mït kite na Icaka marö ködë. ");
INSERT INTO lth_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Cë Rebeka ökwanyö böng na bëcö ka wode na dit Ecau n'onwongo tye ï öt, ëka ömïö wode na tïdï Jakob oruko. ");
INSERT INTO lth_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ën thon oumo cïngë ëka kanya yer ope ïë kï ï ngute k'adëla dyegi. ");
INSERT INTO lth_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Cë ën ömïö cem na mït ëka kwon na ën öyübö both wode Jakob. ");
INSERT INTO lth_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jakob öcïdhö both apap mërë ëka okobo nï, “Apapna!” Icaka ögamö nï, “Eyo woda, nga ënön?” ");
INSERT INTO lth_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakob okobo both apap mërë nï, “An abedo Ecau athïn kaöni. An atïmö kite na in ikobo nïna ködë. Yaa malö ibed abeda ëka ïcam ringo leena ëk ïmïa gumni.” ");
INSERT INTO lth_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Icaka openyo ën nï, “Woda! Inwongo nïngö pïöpïö?” Jakob ögamö nï, “Rwoth Obangani ömïa anwongo.” ");
INSERT INTO lth_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Cë Icaka okobo both Jakob nï, “Woda, bin na cwök ëk agudi, ëk ange ka in ibedo woda Ecau adyer onyo pe.” ");
INSERT INTO lth_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakob öcïdhö na cwök both apap mërë Icaka, cë Icaka ogudo ën ëka okobo nï, “Dwoni cal kï dwön Jakob, ëntö cingi obedo cïng Ecau.” ");
INSERT INTO lth_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ën ba ongeo Jakob pïën cïngë onwongo obedo yer calö cïng ömïn mërë Ecau, cë Icaka ömïö Jakob gum. ");
INSERT INTO lth_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Icaka dökï openyo ën nï, “Adyer in ibedo woda Ecau?” Jakob ögamö nï, “An ënön.” ");
INSERT INTO lth_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Cë ën okobo nï, “Woda, kel ringo leeni nön mörö acam, ëk amii gumna.” Jakob okelo bothe cë ën öcamö ëka okelo thon köngö ölök mörö cë Icaka ömadhö. ");
INSERT INTO lth_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Cë apap mërë Icaka okobo nïnë nï, “Bin kany, woda, ëk ïnödh lema.” ");
INSERT INTO lth_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Cë ën öcïdhö, ëka önödhö lem apap mërë. Ï karë na Icaka ongweo ngwec böng mërë, ömïö ën gum nakun kobo nï, “Eyo, ngwece ka woda cal kï ngwece pwodho na Rwoth dong ömïö gum. ");
INSERT INTO lth_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ëk Obanga omii thoi më polo ëka lönyö më lobo bël na büp ëka pig ölök na nyen. ");
INSERT INTO lth_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ëk rok otii nini ëka jïï oryebere pïny më wöröni. Bed rwoth ï nyim utmegoni, ëk awope ka ayani oryebere pïny më wöröni. Ëk jö na lami, ëlamgï ëka jö na mii gum, ëmïïgï gum.” ");
INSERT INTO lth_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Kinge na Icaka dong otyeko mïö gum ëka Jakob dong öcïdhö ökö kï bothe, ömïn mërë Ecau othuno kï ï dwar. ");
INSERT INTO lth_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ën thon öyübö cem na mït ëka otero both apap mërë. Cë okobo n'apap mërë nï, “Apapna, yaa malö ibed abeda ëka ïcam ringo leena ëk ïmïa gumni.” ");
INSERT INTO lth_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Apap mërë Icaka openyo ën nï, “In ïnga?” Ecau ögamö nï, “An wodi Ecau, kaöni.” ");
INSERT INTO lth_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Icaka kome ömyël rwök ï karë na ën onwongo nï Ecau ënön cë okobo nï, “Nga kara n'ödwarö ringo lee ëka okelo nïna? An pod acamö acama ëka amïö gum na bara in ibino ëka dong adyer bino bedo kï gum!” ");
INSERT INTO lth_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ï karë n'Ecau owinyo köp k'apap mërë, ën oredo kï koko rwök na cwinye cwer nakun kobo both apap mërë nï, “Apapna, mïa an thon gum!” ");
INSERT INTO lth_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ëntö Icaka okobo nïnë nï, “Omeru obino öbwöla ëka otero gumni ökö.” ");
INSERT INTO lth_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ecau okobo nï, “Pathï Jakob ënön adyer? Ën dong öbwöla wang arïö. Ën otero twëröna na calö kaö, ëka kobedini dökï otero gumna!” Cë ën openyo apap mërë nï, “Ba ïwëkö nïna gum mörö?” ");
INSERT INTO lth_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Icaka ögamö dhö Ecau nï, “An amïö ën obedo rwoth ï nyimi ëka amïö wede mërë kïbëc obedo etic mërë. Amïö ën kal ëka pig ölök na nyen. Dong ngö na an arömö tïmö nini, woda?” ");
INSERT INTO lth_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ecau okobo both apap mërë nï, “Apapna, in itye kï gum acël këkën? Apapna, mïa an thon gum!” Cë Ecau okok rwök. ");
INSERT INTO lth_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Apap mërë Icaka ögamö dhögë nï, “Kabedoni bino bedo na bor kï lobo na cëgö cem, na bor kï thoi më polo na malö. ");
INSERT INTO lth_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","In ibino kwö kï pala abadëni ëka ibino tic pï omeru. Ëntö ka in ibino jëm nïnë, in ibino bedo agönya kï bothe.” ");
INSERT INTO lth_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ecau obedo k'adagë ï kom Jakob pïën apap mërë ömïö ën gum mërë ökö. Cë okobo ën kënë nï, “Nïnö më kumo pï thöö ka apapna dong cwök, cë abino neko ömëra Jakob ökö.” ");
INSERT INTO lth_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ï karë n'ekobo both Rebeka ngö na wode na dit Ecau okobo, ën ocwodo Jakob wode na tïdï ëka okobo nïnë nï, “Omeru Ecau ödïö cwinye kï thama më nekoni. ");
INSERT INTO lth_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kobedini dong, woda, tïm gin na an akobo. Lüü ökö yo both ömëra Laban na tye ï Aran. ");
INSERT INTO lth_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Bed bothe pï karë mörö naka ka omeru cwinye dong okwe. ");
INSERT INTO lth_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ka omeru cwinye dong okwe ëka wie dong owil ökö kï ï kom ngö na in ïtïmö ï kome, cë an abino oro köp bothi ëk idwogi cen kï kunön. Pïngö an amïtö rwenyo un jö arïö ï nïnö acël?” ");
INSERT INTO lth_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Cë Rebeka okobo both Icaka nï, “An dong adhero kï kit kwö k'anyira ka jö Kit ökö. Ka Jakob bino nyömö dhakö kï kin mon më lobo ni, kï ï kin mon ka jö Kit calö man, cë kwöna dong bino bedo na köny mërë ope.” ");
INSERT INTO lth_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Cë Icaka ocwodo Jakob bothe, ëka omotho nakun cïkö ën nï, “Kür ïnyöm dhakö mörö kï kin anyira më Kanaan. ");
INSERT INTO lth_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Yaa ökö pïöpïö ïcïdh yo Paddan Aram ï öt ka kwaröni Betuel n'obedo apap k'ayani, ëk ïnyöm dhaköni kï kunön kï kin anyira ka Laban n'obedo ömïn ayani. ");
INSERT INTO lth_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Obanga Won Twër kïbëc omii gum, ëk omii ïnya unu na pol, ëka omii ëkwaëni na pol, ömëd welwu naka ibed unu jö na pol. ");
INSERT INTO lth_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ëk Obanga omii ëka ëkwaëni gum na ën ömïö both Abraam, ëk in ïgam lobo na kobedini ibedo ïë na calö arok, lobo na yam Obanga ömïö both Abraam!” ");
INSERT INTO lth_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Cë Icaka ooro Jakob yo Paddan Aram both Laban, wod ka Betuel më Aram, n'obedo ömïn Rebeka n'onwongo obedo aya ka Jakob ëka Ecau. ");
INSERT INTO lth_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ï karë nön Ecau önïang nï Icaka ömïö gum both Jakob, ëka ooro ën më cïdhö yo Paddan Aram ëk önyöm dhakö kï kunön. Ëka ï karë na ën ömïö gum both Jakob, ën öcïkö Jakob nï, “Kür ïnyöm dhakö mörö n'obedo dhanö më Kanaan.” ");
INSERT INTO lth_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Jakob owinyo köp k'apap mërë ëka aya mërë, cë öcïdhö yo Paddan Aram. ");
INSERT INTO lth_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Cë Ecau önïang nï kite k'anyira më Kanaan ba oyomo cwiny apap mërë Icaka, ");
INSERT INTO lth_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","cë Ecau öcïdhö both Icimael, ëka önyömö Makalat, amïn Nebayot ëka nyaka Icimael wod k'Abraam, ömëdö ï kom mon mërë n'onwongo ën tye ködë cön. ");
INSERT INTO lth_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakob öwëkö Beerceba ëka öcakö cïdhö yo Aran. ");
INSERT INTO lth_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ï karë na ën othuno ï kabedo mörö, öcakö buto kany nön pïën pïny onwongo dong ocido ökö. Ën otingo kidi mörö acël ëka otheno kï wie, cë önïnö ökö. ");
INSERT INTO lth_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Lek obino ï wie, nakun tye ka nënö madala më idho na tyënë ocung pïny ï ngöm, na wie othuno malö ï wi polo, ëka emalaika k'Obanga onwongo idho pïny ëka ïdhö gïnï malö. ");
INSERT INTO lth_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ën önënö Rwoth ocung yo kuwie malö, nakun kobo nïnë nï, “An abedo Rwoth, Obanga k'apapni Abraam, ëka Obanga ka Icaka. An abino mïöni ëka ëkwaëni ngöm na in ibuto ïë. ");
INSERT INTO lth_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ëkwaëni bino bedo calö kwo më dhö nam, ëka un ibino mëdërë yo kuthö, yo kukïdë, yo kukuju, ëka yo kukwap. Jö kïbëc më wi lobo bino nwongo gïnï gum na yaa kï bothi ëka ëkwaëni. ");
INSERT INTO lth_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","An atye kanya acël kodi ëka abino gwököni kanya in ibino cïdhö ïë kïbëc, ëka an abino dwongoni cen ï lobo ni. An ba abino wëköni ata naka ka acobo gin n'onwongo akobo bothi.” ");
INSERT INTO lth_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ï karë na Jakob ocoo kï ï wang nïnö mërë, ën okobo nï, “Adyer Rwoth tye ï kabedo ni, ëka an onwongo ba angeo.” ");
INSERT INTO lth_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Cë lworo ömakö, nakun kobo nï, “Kabedo ni opodho cwinya! Man ënë öt k'Obanga kikokome. Man ënë dholokek më polo.” ");
INSERT INTO lth_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kodiko cön Jakob öya malö, otingo kidi n'onwongo otheno kï wie, cë ocibo na calö wïr, ëka öönyö möö ï wie. ");
INSERT INTO lth_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ën öcakö nyïng kabedo nön nï Betel, kadï bed nyïng pacö nön onwongo ecwodo nï Luj. ");
INSERT INTO lth_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Cë Jakob okwongo kwong nakun kobo nï, “Ka Obanga bino woth köda, nakun gwöka ï woth ni, ëka bino mïöna cem më acama kï böng më aruka, ");
INSERT INTO lth_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ëka adwogi naka ï öt ka apapna kï kuc, cë Rwoth bino bedo Obangana. ");
INSERT INTO lth_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Cë kidi ni na an acibo malö na calö wïr bino bedo öt k'Obanga, ëka gin na kïbëc na in ibino mïöna, an abino mïöni acël më apar.” ");
INSERT INTO lth_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Cë Jakob ömëdërë kï woth mërë, ëka othuno ï lobo ka jö më kukïdë. ");
INSERT INTO lth_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ï karë na ën othuno ï kabedo nön, ën önënö kulo na tye ï pwodho, ëka öthïpan rom adek n'obuto gïnï pïny na cwök kï nget kulo nön, pïën rom onwongo modho pii kï ï kulo nön. Kidi më dhö kulo onwongo thwönë rwök. ");
INSERT INTO lth_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ï karë n'öthïpan rom kïbëc gürë gïnï kunön, ëkwath kwanyö gïnï kidi ökö kï ï dhö kulo ëka cakö mïö gïnï rom modho pii. Cë kinge na dong öthïpan rom omodho pii, gïn dwökö kidi kakarë ï dhö kulo. ");
INSERT INTO lth_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakob openyo ëkwath nï, “Utmegona, un ïya unu kï kwene?” Gïn ögamö nï, “Wan ëya kï ï Aran.” ");
INSERT INTO lth_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Jakob okobo bothgï nï, “Un ingeo Laban n'obedo akwar Nakor?” Gïn ögamö nï, “Eyo, wan engeo ën.” ");
INSERT INTO lth_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Cë Jakob openyogï nï, “Ën tye na bër?” Gïn ögamö nï, “Eyo, ën tye na bër. Nën, nyarë Racel ëca tye ka kelo rom.” ");
INSERT INTO lth_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Cë Jakob okobo nï, “Ceng pod tye malö, ëka man ba obedo caa më gürö öthïpan rom kanya acël. Mïï unu rom pii ëk omodhi, ëka itergï ï kwath dökï.” ");
INSERT INTO lth_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Gïn ögamö nï, “Wan ba ëtwërö mïögï pii, naka wang na rom kïbëc ögürë gïnï kanya acël, ëka nwongo ëkwanyö kidi ökö kï ï dhö kulo. Cë wan dong ëcakö mïö rom modho pii.” ");
INSERT INTO lth_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ï caa n'onwongo ën pod tye ka twak ködgï, Racel obino kï rom k'apap mërë, pïën ën onwongo obedo akwath. ");
INSERT INTO lth_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ï karë na Jakob önënö Racel nyaka Laban, n'obedo nero mërë, ëka kï rom ka nero mërë Laban, Jakob öcakö cïdhö anyim cë ökwanyö kidi ökö kï ï dhö kulo ëka ömïö rom ka nero mërë omodho pii. ");
INSERT INTO lth_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Cë Jakob önödhö lem Racel, ëka öcakö kok rwök kï yom cwinye. ");
INSERT INTO lth_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ï karë na Jakob okobo both Racel nï ën ebedo wat k'apap mërë ëka wod ka Rebeka, cë ën örïngö okobo both apap mërë. ");
INSERT INTO lth_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Cücüth na Laban owinyo köp ï kom Jakob wod k'amïn mërë, ën öbünyö ngwëc më cïdhö romo ködë. Öthünö kore ëka önödhö leme, cë otero ën naka ï ödë. Kï kunön Jakob okobo kite na ën ebedo ködë wat both Laban. ");
INSERT INTO lth_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Cë Laban okobo nïnë nï, “Adyer in ibedo koma kikokome ëka remona.” Cë obedo gïnï kanya acël ködë pï dwe acël. Kinge na Jakob obedo bothe pï dwe acël, ");
INSERT INTO lth_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban okobo both Jakob nï, “Myero in itii nïna tic abonge cül pïën ön ebedo wat? Kob nïna, kite na myero an aculi ködë.” ");
INSERT INTO lth_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban onwongo tye k'anyira mërë arïö, nyarë n'adit nyïngë onwongo ecwodo nï Lea, ëka nyarë na tïdï nyïngë onwongo ecwodo nï Racel. ");
INSERT INTO lth_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea onwongo wangë görü, ëntö Racel onwongo tïr ëka leng rwök. ");
INSERT INTO lth_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakob onwongo marö Racel rwök, cë okobo nï, “An abino tio tic nini pï mwaka abïrö pï nyari na tïdï Racel.” ");
INSERT INTO lth_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban ögamö nï, “Bedo na bër ka an amïö ën bothi, nakaka mïö both ëcwö mörö nökënë. Pï manön, bed botha kany.” ");
INSERT INTO lth_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Cë Jakob obino otio tic pï mwaka abïrö ëk ëmïë ënyöm Racel, ëntö karë nön onwongo obedo calö nïnö mörö na nönök kï bothe pïën cwinye onwongo ömarö Racel rwök. ");
INSERT INTO lth_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Cë Jakob okobo both Laban nï, “Mïa dong dhaköna ëk abed ködë, pïën karë na ön emoko dong othum ökö.” ");
INSERT INTO lth_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Cë Laban öyübö karama më nyom ëka ocwodo lwak kïbëc më kabedo nön. ");
INSERT INTO lth_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ëntö kothyeno na pïny dong ocido, ën okelo nyarë Lea ömïö both Jakob, ëka Jakob obedo ködë. ");
INSERT INTO lth_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Laban ömïö atic mërë na nyakö na nyïngë Jilpa both nyarë Lea më bedo calö atic mërë.) ");
INSERT INTO lth_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kodiko mërë na pïny dong oru, Jakob önënö nï Lea ënë onwongo tye kanya acël ködë. Cë Jakob okobo both Laban nï, “Man ngö na in ïtïmö ï koma? An onwongo ba abedo ka tic bothi pï Racel? Pïngö in ïbwöla?” ");
INSERT INTO lth_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban ögamö nï, “Ba obedo thëkwaröwa kï kany më mïö nyakö na tïdï më anyöma na bara ënyömö nyakö na dit. ");
INSERT INTO lth_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tyek kono yüb më nyom më cabït ka nyara ni, cë wan ebino mïöni nyakö na tïdï thon, ëntö in myero itii tic nïna pï mwaka abïrö nökënë.” ");
INSERT INTO lth_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ëka Jakob obino ötïmö nï kömanön. Ï karë na Jakob otyeko cabït acël kanya acël kï Lea, Laban obino ömïö nyarë Racel bothe më bedo dhakö mërë. ");
INSERT INTO lth_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Laban obino ömïö atic mërë na nyakö na nyïngë Bila both nyarë Racel më bedo calö atic mërë.) ");
INSERT INTO lth_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jakob obino obedo kï Racel thon. Ën ömarö Racel rwök na löö Lea, cë ën obino otio tic both Laban pï mwaka abïrö nökënë. ");
INSERT INTO lth_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ï karë na Rwoth önënö nï Jakob ba marö Lea, cë öyabö öd nyodo mërë, ëntö Racel onwongo obedo alür. ");
INSERT INTO lth_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea öyac, ëka önywölö athïn n'ëcwö, cë ën öcakö nyïngë Reuben, nakun ën okobo nï, “Pïën Rwoth önënö can na mëga, adyer dong cwöra bino maröna.” ");
INSERT INTO lth_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ëka ën dökï ögamö ïë, cë önywölö athïn n'ëcwö, ëka okobo nï, “Pïën Rwoth owinyo nï an ba ëmara, ömïa dökï man thon.” Cë ën öcakö nyïngë Cimeon. ");
INSERT INTO lth_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Kinge dökï ën ögamö ïë, cë önywölö athïn n'ëcwö, ëka okobo nï, “Kobedini dong cwöra bino moko ï koma, pïën anywölö nïnë awope adek.” Manön ënë ömïö ëcakö nyïngë Lebi. ");
INSERT INTO lth_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ëka dökï ögamö ïë, cë önywölö athïn n'ëcwö, ëka okobo nï, “Man ënë karë na an abino pakö Rwoth ïë.” Ën öcakö nyïngë Yuda. Cë ën ocung kono ökö. ");
INSERT INTO lth_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ï karë na Racel önënö nï ba dök ëtwërö nywölö ëthïnö both Jakob, cë nyeko öcakö makö ën ï kom amïn mërë. Ëka ën okobo both Jakob nï, “Mïa anwong ëthïnö, ka ope cë abino thöö ökö.” ");
INSERT INTO lth_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Cë akëmö ömakö Jakob ï kom Racel, ëka okobo nïnë nï, “An adökö Obanga, n'ojuki nywölö ëthïnö?” ");
INSERT INTO lth_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Cë Racel ögamö nï, “Aticna na nyakö Bila ene, bed ködë ëk önywöl ëthïnö mörö nïna, ëk an thon anwong ëthïnö na yaa kï bothe.” ");
INSERT INTO lth_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Cë Racel ömïö atic mërë Bila both Jakob na calö dhakö mërë, ëka Jakob obedo ködë. ");
INSERT INTO lth_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bila ögamö ïë, ëka önywölö athïn n'ëcwö kï Jakob. ");
INSERT INTO lth_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Cë Racel okobo nï, “Obanga otyeko ngölö nïna köp n'atïr; ën owinyo kokona, ëka ömïa athïn n'ëcwö.” Manön ënë ömïö ën öcakö nyïngë Dan. ");
INSERT INTO lth_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bila atic ka Racel ögamö ïë dökï, cë önywölö kï Jakob athïn më arïö n'obedo ëcwö. ");
INSERT INTO lth_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Cë Racel okobo nï, “An abedo yelara k'amëra rwök, ëka alöö ën ökö.” Cë ën öcakö nyïngë Naputali. ");
INSERT INTO lth_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ï karë na Lea önënö nï ba dök ëtwërö nywölö ëthïnö, ën ökwanyö atic mërë na nyakö Jilpa, ëka ömïö both Jakob na calö dhakö mërë. ");
INSERT INTO lth_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Jilpa, atic ka Lea, önywölö athïn n'ëcwö kï Jakob. ");
INSERT INTO lth_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Cë Lea okobo nï, “Gum na bër ömaka!” Ëka ën öcakö nyïngë Gad. ");
INSERT INTO lth_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Jilpa, atic ka Lea, dök önywölö athïn më arïö n'ëcwö kï Jakob. ");
INSERT INTO lth_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Cë Lea okobo nï, “Kobedini dong an cwinya yom! Ëka mon bino cwodona gïnï nï ngat na cwinye yom,” cë ën öcakö nyïngë Acer. ");
INSERT INTO lth_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ï karë n'ëcökö cem kï ï pwothi, Reuben öcïdhö ï pwodho cë onwongo mandurek ëka okelo both aya mërë Lea. Ï karë na Racel obino both Lea, okobo nïnë nï, “Mïa mandurek ka wodi mörö.” ");
INSERT INTO lth_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ëntö Lea ögamö nï, “In ïmaö cwöra ökö kï botha, in ïthamö nï köp nön onwongo tïdï mörö? Ëka kobedini ïmïtö kwanyö mandurek ka woda ökö thon?” Racel okobo nï, “Eyo, ën twërö bedo kodi tin kiwor nakaka mandurek ka wodi.” ");
INSERT INTO lth_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ï karë na Jakob odwogo kï ï pwodho kothyeno nön, Lea öcïdhö më romo ködë ï yoo, cë okobo nïnë nï, “Myero tin ïdöny ï öda, pïën atyeko pangoni kï mandurek ka woda.” Cë Jakob öcïdhö obedo ködë ï kiwor nön. ");
INSERT INTO lth_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Obanga owinyo lëga ka Lea ëka ögamö ïë cë önywölö athïn më abic n'obedo ëcwö kï Jakob. ");
INSERT INTO lth_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Cë Lea okobo nï, “Obanga dong otyeko cülöna pï mïö aticna na nyakö both cwöra.” Pï manön ën öcakö nyïngë Icakar. ");
INSERT INTO lth_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea dökï ögamö ïë ëka önywölö athïn më abicël n'obedo ëcwö kï Jakob. ");
INSERT INTO lth_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Cë Lea okobo nï, “Obanga dong otyeko mïöna mïc na bër. Kobedini dong cwöra bino mïö wörö botha, pïën an anywölö nïnë ëthïnö na cwö abicël.” Ën öcakö nyïngë Jabulon. ");
INSERT INTO lth_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Kinge karë mörö, ën obino önywölö nyarë, cë öcakö nyïngë Dina. ");
INSERT INTO lth_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Cë Obanga opo ï kom Racel; owinyo lëga mërë ëka öyabö öd nyodo mërë. ");
INSERT INTO lth_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ën ögamö ïë, cë önywölö athïn n'ëcwö, ëka okobo nï, “Obanga ökwanyö lewic ökö kï botha.” ");
INSERT INTO lth_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Cë öcakö nyïngë Yocepu, ëka okobo nï, “Rwoth myero ömïa athïn n'ëcwö nökënë.” ");
INSERT INTO lth_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Kinge na dong Racel önywölö Yocepu, Jakob okobo both Laban nï, “Yee nïna ëk acïdh dong yo lobo thurwa. ");
INSERT INTO lth_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mïa mon-na k'ëthïnöna, na an atio bothi pïrgï, ëk dong acak cïdhö. In ingeo tic na tëk na an atio bothi.” ");
INSERT INTO lth_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ëntö Laban okobo nïnë nï, “Ka in ïnënö nï an atye kï cwiny na bër bothi, akwai nï ibedi. An anïang ökö cön nï piri ënë ömïö Rwoth ömïa gum.” ");
INSERT INTO lth_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ën ömëdërë më kobo nï, “Kob nïna wel öcarani, ëka an abino cülö gin mörö këkën na in ïmïtö.” ");
INSERT INTO lth_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakob okobo nïnë nï, “In ingeo kite na an atio tic nini ëka kï kite na an agwökö kï lïmni ködë. ");
INSERT INTO lth_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Adyer lïmni onwongo nönök ï karë na an bara abino, ëntö kobedini dong ömëdërë ödökö na pol rwök. Rwoth ömïö gum bothi ï kom jami kïbëc na an atïmö. Ëntö kobedini, naka awene na an myero atïm gin mörö pï jö më öda?” ");
INSERT INTO lth_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban openyo nï, “In ïmïtö nï an amii ngö?” Jakob ögamö nï, “Kür ïmïa gin mörö. Ëntö ka in ibino yee më tïmö nïna gin mörö acël, cë an abino mëdara më gwökö lïmni. ");
INSERT INTO lth_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Yee nïna tin ëk acïdh awoth ï kin lïmni kïbëc, ëka ayër rom n'obedo omer onyo okomol kï ï kin-gï, ëka k'ëthïnö rom na cöl gïnï kïbëc, kanya acël kï dyegi n'omer gïnï. Man bino bedo öcara na mëga. ");
INSERT INTO lth_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ëka adwogi ka gen-na bino nen ï karë më anyim, ka in ibino më nënö nï an atero öcarana na ön eyere ïë. Ka in ibino nwongo dyël mörö këkën na ba obedo omer onyo okomol onyo römö mörö na kome ba cöl, manön ebino kwanö nï gin n'ëkwalö.” ");
INSERT INTO lth_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Cë Laban oye ëka okobo nï, “Bër, ebino tïmö nï kömanön kite na in ikobo ködë.” ");
INSERT INTO lth_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ï nïnö acël nön, Laban obino ökwanyö nywogi dyegi n'omer onyo n'okomol, megi dyegi kïbëc n'amer onyo n'akomol (man onwongo ölïnga na tar kïbëc) ëka k'ëthïn rom na cöl kïbëc, cë ömïögï ï cïng awope mërë nï ëk ögwökgï. ");
INSERT INTO lth_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Cë ën obino öyübö woth më nïnö adek ï kin ën kï Jakob, nakun Jakob odong më mëdërë më gwökö lïm ka Laban n'odong. ");
INSERT INTO lth_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Cë Jakob obino otongo jang yen na thïc na mar kï kom yen adek na papath, ëka öpwöcö pökgï ëk korgï na tar onen. ");
INSERT INTO lth_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Cë Jakob oketho jang yen n'ëpwöcö ï kabedo kïbëc na rom modho pii kï ïë, ëk obed ï nyim rom ka bino gïnï modho. Ï karë na rom wapere ka bino gïnï modho pii, ");
INSERT INTO lth_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","gïn wapere ï nyim jang yen, ëka mïö nywölö ëthïnögï n'obedo okomol, ëka n'omer onyo ölïnga. ");
INSERT INTO lth_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jakob opoko ëthïnö rom na path, ëntö ömïö rom nökënë kïbëc okemo rom ka Laban n'okomol ëka man acöl. Cë opoko lïm mërë na path nakun ba rïbö kï lïm ka Laban. ");
INSERT INTO lth_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ka karë na megi rom na komgï tëk karëgï örömö më kwarogï, Jakob pyelo jang yen ï pii na tye ka möl ï nyimgï ëk gïn owapere na cwök kï jang yen. ");
INSERT INTO lth_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ëntö ka rom na görü tye ka wapere, ën ba pyelo jang yen kany nön. Cë rom na görü bedo më ka Laban ëka rom na komgï tëk bedo më ka Jakob. ");
INSERT INTO lth_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Manön ömïö Jakob ödökö thwön alönyö na tye kï rom na pol ëka dyegi, etic na mon ëka etic na cwö, kïnaga ëka kene. ");
INSERT INTO lth_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jakob owinyo nï awope ka Laban onwongo tye ka kobo nï, “Jakob otero jami kïbëc n'onwongo apapwa tye ködë ëka onwongo lönyö ni kïbëc kï ï kom lïm k'apapwa.” ");
INSERT INTO lth_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ëka Jakob thon önënö nï Laban ba dökï nënë na bër kite n'onwongo tye ködë cön. ");
INSERT INTO lth_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Cë Rwoth okobo both Jakob nï, “Dök ökö cen ï lobo ka kwereni ëka wedeni, cë an abino woth kodi.” ");
INSERT INTO lth_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Cë Jakob ooro dhanö mörö më cwodo Racel ëka Lea më bino ï bar kanya lïm mërë onwongo tye ïë. ");
INSERT INTO lth_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ën okobo bothgï nï, “An atye ka nënö nï apapwu ba tye ka nënöna na bër kite na cön, ëntö Obanga n'apapna wörö obedo ka gwököna. ");
INSERT INTO lth_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Un ingeo nï an atio tic both apapwu kï tëköna kïbëc, ");
INSERT INTO lth_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ëka apapwu obedo ka bwölöna nakun lökö öcarana wang apar twal. Ëntö Obanga ba oyeo nïnë më tïmö gin mörö na rac ï koma. ");
INSERT INTO lth_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ï karë kïbëc ka ën okobo nï, ‘Leeni n'ënywölö n'obedo ölïnga bino bedo cülni,’ cë leeni kïbëc nywölö ëthïnögï n'obedo ölïnga; ëka ka ën okobo nï, ‘Leeni n'ënywölö n'obedo omer bino bedo cülni,’ cë leeni kïbëc nywölö ëthïnögï n'obedo omer. ");
INSERT INTO lth_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Manön ënë kite n'Obanga ökwanyö lïm k'apapwu cë ömïögï botha. ");
INSERT INTO lth_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Ï karë më wapere ka rom kï dyegi, an anënö kï ï lekna nywogi na tye ka kwaro megi dyegi ëka megi rom na komgï obedo omer ëka okomol onyo ölïnga. ");
INSERT INTO lth_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Malaika k'Obanga ocwoda ï wang lek nï, ‘Jakob.’ An agamö nï, ‘An ene.’ ");
INSERT INTO lth_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Cë malaika okobo nïna nï, ‘Ting wangi malö ëka ïnën nï nywogi kïbëc na tye ka kwaro megi dyegi obedo omer, okomol onyo ölïnga, pïën an anënö gin na kïbëc na Laban obedo ka tïmö ï komi. ");
INSERT INTO lth_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","An abedo Obanga më Betel, kanya in iwiro möö ïë ï wi kidi ëka kanya in ikwongo kwong ködë botha. Kobedini dong yaa ökö pïöpïö kï ï lobo ni ëka ïdök cen yo lobo kanya enywoli ïë.’” ");
INSERT INTO lth_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Cë Racel ëka Lea okobo both Jakob nï, “Wan pod etye kï gin mörö më alea kï ï öt k'apapwa? ");
INSERT INTO lth_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ën ba bino nënöwa na calö Erok? Ën ba öcadhöwa këkën, ëntö öcamö thon lïm n'onwongo ïmïö bothe pïrwa. ");
INSERT INTO lth_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Adyer lïm kïbëc na dong Obanga ökwanyö ökö kï both apapwa obedo mëwa ëka ëthïnöwa. Dong ïtïm gin na kïbëc n'Obanga okobo nini.” ");
INSERT INTO lth_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Cë Jakob oketho ëthïnö mërë ëka mon mërë ï ngee kïnaga, ");
INSERT INTO lth_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ën ökölö leeni mërë më pacö kï jami kïbëc na ën onwongo kï ï Paddan Aram, ëka öcakö cïdhö më dök cen ï lobo Kanaan kanya apap mërë Icaka ökwö ïë. ");
INSERT INTO lth_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ï karë na Laban onwongo öcïdhö më nyarö yer rom mërë, Racel ökwalö cal obanga k'apap mërë gïnï kï ï öt. ");
INSERT INTO lth_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jakob thon öbwölö Laban dhanö më Aram nakun ba okobo nïnë woth mërë. ");
INSERT INTO lth_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ën ölüü kï lïm kïbëc n'onwongo ën tye ködë, ëka öngölö kulo Euparate, nakun dök yo lobo n'otingere më Gilead. ");
INSERT INTO lth_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Kinge nïnö adek, ekobo both Laban nï Jakob ölüü ökö. ");
INSERT INTO lth_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban ökwanyö wede mërë ölübö kï kör Jakob pï nïnö abïrö ëka ëmakö ën ï lobo n'otingere më Gilead. ");
INSERT INTO lth_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ëntö ï kiwor Obanga obino both Laban dhanö më Aram ï wang lek ëka okobo nïnë nï, “Gwokiri, kür ïcïdh ikob gin mörö na bër onyo na rac both Jakob.” ");
INSERT INTO lth_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jakob onwongo dong oguro këma mërë ï lobo n'otingere më Gilead ï karë na Laban ömakö ën. Laban ëka wede mërë thon oguro këmagï kany nön. ");
INSERT INTO lth_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Cë Laban okobo both Jakob nï, “Ngö na in ïtïmö? In ïbwöla, ëka itero anyirana na calö jö n'ëmakögï kï ï dhö lwëny. ");
INSERT INTO lth_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Pïngö in ïlüü alüa ïmüng na ba ïnïanga? Pïngö ba ikobo nïna ëk amii ïcïdh unu kï yom cwiny nakun iwero unu wer kï bul ëka adungu? ");
INSERT INTO lth_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","In thon ba ïmïa amotho ëkwaëna ëka anyirana. In ïtïmö gin mörö më mingo. ");
INSERT INTO lth_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","An atye kï twër më wanöwu kïbëc, ëntö ï kiwor n'opoth Obanga k'apapni okobo nïna nï, ‘Gwokiri, kür ïcïdh ikob gin mörö na bër onyo na rac both Jakob.’ ");
INSERT INTO lth_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Man dong ïya ökö, pïën ïmïtö dök ï öt k'apapni. Ëntö pïngö in ïkwalö obangana gïnï?” ");
INSERT INTO lth_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakob ögamö dhö Laban nï, “An onwongo alwor, pïën an athamö nï in ïtwërö gamö anyirani ökö kï botha tëtëk. ");
INSERT INTO lth_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ëntö ka in inwongo ngat mörö na tye k'obangani gïnï, ngat nön ba bino kwö. Rang gin mörö këkën n'obedo megi ï nyim wede onu ëka ïkwany ïcïdh ködë.” Jakob ba ongeo nï Racel onwongo ökwalö cal obanga k'apap mërë gïnï. ");
INSERT INTO lth_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban ödönyö ï këma ka Jakob, ï këma ka Lea ëka ï këma ka mon arïö n'obedo etic, ëntö ën ba onwongo gin mörö. Kinge na ën odonyo yökö kï öd këma ka Lea, ën ödönyö ï këma ka Racel. ");
INSERT INTO lth_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ëntö Racel onwongo ökwanyö cal obanga k'apap mërë gïnï, cë okethogï ï gin më bedo ï ngee kïnaga ëka obedo ï wie. Laban örangö jami kïbëc na tye ï öd këma, ëntö ba onwongo gin mörö. ");
INSERT INTO lth_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Racel okobo both apap mërë nï, “Adwongna, kür akëmö omaki ï koma ka ïnënö nï ba atwërö yaa malö ï nyimi, pïën an atye kï two dwena.” Cë Laban ömëdërë kï rangö cal obanga mërë gïnï ëntö ba onwongo. ");
INSERT INTO lth_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Akëmö ömakö Jakob, cë öcakö twak kï Laban nakun kobo nï, “Ngö na rac na an atïmö?” Ën openyo Laban nï, “Bal ngö na an atïmö na mïö in itye ka lübö köra rwök? ");
INSERT INTO lth_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kobedini na dong in ïrangö ï jamina kïbëc, inwongo gin mörö n'obedo megi? Keth ï nyim wedeni ëka mëga, cë ïmïïgï öngöl köp ï kin ön jö arïö. ");
INSERT INTO lth_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“An abedo bothi pï mwaka pyer arïö. Megi rom ëka megi dyegini ïgï ba ööny. An thon ba acamö nywogini mörö. ");
INSERT INTO lth_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ka lee më thim oneko romni onyo dyegini an ba akelo bothi, an kikoma ënë acülö. Ëka, in ïmïa acülö pï lee mörö n'orwenyo, kadï bed nï ëkwalö kiceng onyo kiwor. ");
INSERT INTO lth_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Man ënë kite n'onwongo an atye ködë: Ceng wanga kiceng ëka koyo neka kiwor, cë nïnö kwërö wanga ökö. ");
INSERT INTO lth_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Pï mwaka pyer arïö na an abedo ködë ï pacöni, an atio bothi mwaka apar angwën pï anyirani arïö, ëka pï mwaka abicël pï lïmni. In ibedo ka lökö öcarana wang apar külü! ");
INSERT INTO lth_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ka Obanga k'apapna, Obanga k'Abraam ëka Obanga n'apapna Icaka wörö, onwongo ba ögwöka, in onwongo ïtwërö ryëmöna kï cïnga nono. Ëntö Obanga önënö kite na an lïmö kï can ködë, tic na tëk na an atïmö, ëka ocoki ï kiwor n'opoth.” ");
INSERT INTO lth_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban okobo both Jakob nï, “Lea ëka Racel obedo gïnï anyirana, ëthïnögï obedo gïnï ëkwaëna, ëka lïm kïbëc obedo mëga. Gin na in itye ka nënö kïbëc obedo mëga. Ëntö ngö na an atwërö tïmö ï kom anyirana tin, onyo ëthïnö na gïn önywölö? ");
INSERT INTO lth_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Bin dong, ëk emok cïkërë, in ëka an, ëk obed caden ï kin ön.” ");
INSERT INTO lth_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Cë Jakob ökwanyö kidi ëka oketho na calö wïr. ");
INSERT INTO lth_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ën okobo both wede mërë nï, “Cök unu kite mörö.” Gïn öcökö kite ëka eurogï ï athuketh, cë ocemo gïnï ï nget athuketh. ");
INSERT INTO lth_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban öcakö nyïng kabedo nön nï Jegar Caduta, ëntö Jakob öcakö nyïngë nï Galeed. ");
INSERT INTO lth_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban okobo nï, “Kite n'euro ni obedo caden më cïkërë tin, ï kin in kï an.” Manön ënë gin n'ömïö ecwodo nï Galeed. ");
INSERT INTO lth_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Onwongo thon ecwodo nï Mijpa, pïën ën okobo nï, “Ëk Rwoth ögwök kin ön ï karë na ngat acëlacël bino bedo na bor kï both awodhe. ");
INSERT INTO lth_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ka in ibino yelo anyirana onyo ka in ibino nyömö mon nökënë më mëdö ï kom anyirana, kadï bed nï ngat mörö ope kod onu, myero ipo nï Obanga obedo caden ï kin in kï an.” ");
INSERT INTO lth_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Cë Laban dökï okobo both Jakob nï, “Athuketh më kidi ni ene, ëka an aketho wïr ni ï kin in kï an. ");
INSERT INTO lth_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Athuketh ni obedo caden, ëka wïr ni obedo caden, na an ba abino kadhö më bino bothi më wanöni, ëka in ba ibino kadhö athuketh më kidi ni ëka wïr ni më bino wanöna. ");
INSERT INTO lth_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ëk Obanga k'Abraam ëka Obanga ka Nakor, Obanga k'Apapgï, öngöl köp ï kin ön.” Cë Jakob okwongo kwong kï nyïng Obanga n'apap mërë Icaka wörö. ");
INSERT INTO lth_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jakob oneko lee ëka ötyërö na calö tyër awanga ï wi kidi, cë ocwodo wede mërë më bino cem. Kinge na gïn otyeko cem, gïn önïnö ï wi kidi kunön. ");
INSERT INTO lth_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Kodiko cön na pïny dong oru, Laban omotho ëkwaë mërë ëka anyira mërë kï nödhö lemgï, ëka ölamö nïgï gum. Cë opokere ködgï ëka ödök yo pacö mërë. ");
INSERT INTO lth_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jakob ömëdërë kï woth mërë, ëka emalaika k'Obanga oromo ködë. ");
INSERT INTO lth_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ï karë na Jakob önënögï ën okobo nï, “Man ënë kabedo k'Obanga!” Cë ën öcakö nyïng kabedo nön nï Makanaim. ");
INSERT INTO lth_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Cë Jakob ooro ëkwëna anyim both ömïn mërë Ecau na tye ï lobo më Ceir, lobo më Edom. ");
INSERT INTO lth_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ën öcïkögï nï, “Man ënë ngö na un ïcïdhö kobo both adwongna Ecau: ‘Aticni Jakob okobo nï: An abedo both Laban ëka an abedo bedo kunön naka tin. ");
INSERT INTO lth_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","An atye kï dhok, kene, rom ëka dyegi, etic n'obedo cwö ëka etic n'obedo mon. Kobedini an aoro köp ni yo bothi adwongna, ëk ibed kï cwiny na bër ï koma.’” ");
INSERT INTO lth_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ï karë n'ëkwëna odwogo gïnï both Jakob, gïn okobo nï, “Wan ëcïdhö both omeru Ecau, ëka ën tye ka bino kï jö mia angwën më romo kodi.” ");
INSERT INTO lth_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Lworo ömakö Jakob rwök, ëka cwinye thon opodho. Ën opoko jö n'onwongo tye bothe, rom kï dyegi, dhok, ëka kïnaga ï gurup arïö. ");
INSERT INTO lth_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ën öthamö nï, “Ka Ecau obino ëka ocelo kabedo acël, cë mana odong twërö bwöth.” ");
INSERT INTO lth_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Cë Jakob ölëgö nï, “Aa Obanga k'apapna Abraam, Obanga k'apapna Icaka, Aa Rwoth n'okobo nïna nï, ‘Dök cen yo loboni ëka both wedeni, cë an abino gwököni,’ ");
INSERT INTO lth_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","an ba apora kï marni kïbëc ëka gen-ni na in inyutho both aticni. An onwongo atye kï lüdha më woth ï karë na an angölö kulo Jordan, ëntö kobedini an dong atye kï lïm na pol n'opokere ï gurup arïö. ");
INSERT INTO lth_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","An alëgö nï ïlara kï kom ömëra Ecau, pïën an atye kï lworo nï ën twërö bino më celona ëka thon mon-na k'ëthïnögï. ");
INSERT INTO lth_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ëntö in ikobo nï, ‘An abino gwököni ëka abino mïö ëkwaëni bedo calö kwo më dhö nam, na ba bino kwanërë.’” ");
INSERT INTO lth_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jakob önïnö kunön, ëka kï kom ngö na ën onwongo tye ködë, ën öyërö ëka ooro both ömïn mërë Ecau na calö mïc: ");
INSERT INTO lth_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","megi dyegi mia arïö ëka nywogi pyer arïö, megi rom mia arïö ëka thwoni rom pyer arïö, ");
INSERT INTO lth_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","megi kïnaga k'ëthïnögï pyer adek, megi dhok pyer angwën ëka thwoni apar, megi kene pyer arïö ëka thwoni kene apar. ");
INSERT INTO lth_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Jakob ömïögï both etic mërë, nakun poko gïnï ï ëthïpan, cë okobo both etic mërë nï, “Apë unu anyim nïna ëka kin ëthïpan myero obed na lalac.” ");
INSERT INTO lth_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ën öcïkö atic acël na tëlö wigï nï, “Ka ömëra Ecau oromo kodwu ëka openyo nï, ‘Un ibedo jö ka nga? Ïcïdhö unu yo kwene? Leeni ka nga ene na un itye ka kölö?’ ");
INSERT INTO lth_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Cë un myero ikob nï, ‘Obedo më aticni Jakob. Ëmïö na calö mïc both adwongna Ecau, ëka ën tye odong cen ï ngewa.’” ");
INSERT INTO lth_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Jakob thon ömïö cïk ni both atic më arïö, më adek, ëka both jö nökënë kïbëc n'onwongo tye ka lübö kör ëthïpan, nakun kobo nï, “Myero ikob unu köp na röm aröma both Ecau ka iromo unu ködë. ");
INSERT INTO lth_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Myero thon ikob unu nï, ‘Aticni Jakob tye ï ngewa tye ka bino.’” Pïën ën öthamö nï, “An abino yomo cwinye kï mïc na an atye ka oro anyim. Kinge, ka an anënö ën, cë onyo twërö jölöna.” ");
INSERT INTO lth_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Cë Jakob ooro mïc öcïdhö anyim nïnë, nakun ën kikome önïnö ökö kanya onwongo ën tye ïë ï kiwor nön. ");
INSERT INTO lth_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ï kiwor nön Jakob öya malö cë otero mon mërë arïö, etic mërë arïö n'obedo mon, awope mërë apar acël, ëka öngölö ï kulo Jabok yo löka tung ca. ");
INSERT INTO lth_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ën oterogï ëka ömïögï öngölö ï kulo kanya acël kï jami mërë kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jakob onwongo odong kënë. Cë ëcwö mörö ögamërë ködë naka ï caa na pïny dong cwök ruu. ");
INSERT INTO lth_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ï karë n'ëcwö önënö nï ba ërömö löönö Jakob, ën otwomo wi bam Jakob ëka öwïl ökö nakun pod gamërë ködë. ");
INSERT INTO lth_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Cë ëcwö nön okobo nï, “Wëka acïdh ökö, pïën pïny dong cwök ruu.” Ëntö Jakob ögamö nï, “An ba abino wëköni ïcïdhö naka wang ïmïa gum.” ");
INSERT INTO lth_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ëcwö nön openyo nï, “In nyingi nga?” Ën ögamö nï, “Jakob.” ");
INSERT INTO lth_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Cë ëcwö nön okobo nï, “Nyingi ba dökï ebino cwodo nï Jakob, ëntö Icarael, pïën in igamiri k'Obanga ëka kï jïï naka ïlöö.” ");
INSERT INTO lth_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jakob okobo nï, “Öma kob nïna nyingi.” Ëntö ën ögamö nï, “Pïngö ipenyo nyïnga?” Cë ömïö Jakob gum kï kany nön. ");
INSERT INTO lth_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakob okobo nï, “An anënö Obanga wang kï wang, ëka an pod akwö.” Cë ën öcakö nyïng kabedo nön nï Peniel. ");
INSERT INTO lth_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ceng odonyo malö n'onwongo Jakob tye ka yaa kï ï Peniel, ëntö ën onwongo kömö pï bamë n'öwïl. ");
INSERT INTO lth_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Man ömïö naka tin jö Icarael ba camö gïnï ler ringo bam, pïën bam Jakob onwongo etwomo na cwök kï ler. ");
INSERT INTO lth_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ï karë na Jakob tye ka yaa kï kany nön, ën otingo wangë ëka önënö Ecau tye ka bino kï jögë mia angwën. Cë ën öcakö poko ëthïnö ï kin Lea, Racel ëka etic na mon arïö. ");
INSERT INTO lth_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ën oketho etic na mon k'ëthïnögï anyim, Lea k'ëthïnö mërë ölübö körgï, ëka Racel kï Yocepu odong angec. ");
INSERT INTO lth_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jakob kikome öcïdhö anyim ëka oryebere pïny wang abïrö na ën tye ka cïdhö na cwök k'ömïn mërë. ");
INSERT INTO lth_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ëntö Ecau örïngö më romo kï Jakob ëka öthünö ngute cë önödhö leme. Cë utmego arïö öcakö gïnï koko. ");
INSERT INTO lth_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ï karë n'Ecau otingo wangë ëka önënö mon k'ëthïnö, ën openyo nï, “Ëthïnö ka nga ene?” Jakob ögamö nï, “Man ëthïnö n'Obanga ömïö both aticni pï kïca mërë.” ");
INSERT INTO lth_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Cë etic na mon k'ëthïnögï othuno ëka oryebere gïnï pïny. ");
INSERT INTO lth_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Cë Lea k'ëthïnö mërë obino ëka oryebere gïnï pïny. Më ajiki Yocepu ëka Racel obino gïnï anyim cë gïn thon oryebere pïny. ");
INSERT INTO lth_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ecau openyo Jakob nï, “Gurup na an aromo ködgï thërë nïngö?” Jakob ögamö nï, “Ëk ibed kï cwiny na bër ï koma, adwongna.” ");
INSERT INTO lth_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ëntö Ecau okobo nï, “An dong atye kï leeni na pol ömëra. Wëk gin na in itye ködë obed megi.” ");
INSERT INTO lth_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ëntö Jakob ökwërö nakun kobo nï, “Ka in ïnënö nï an ayomo cwinyi, cë ïgam mïc na an amii. Pïën adyer, ka an anënö terinyimi, röm nï anënö terinyim Obanga. Pï koth cwiny na bër na in ïjöla ködë. ");
INSERT INTO lth_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Öma gam mïc ni na an akelo bothi, pïën Obanga onyutho kïca mërë ï koma ëka an atye kï mëga na röma.” Jakob ömëdërë kï dïö Ecau naka oye më gamö mïc. ");
INSERT INTO lth_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Cë Ecau okobo nï, “Eru ewothu kanya acël, ëka an abino tëlö yoo.” ");
INSERT INTO lth_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ëntö Jakob okobo nïnë nï, “Adwongna ngeo nï ëthïnö pod thïthïnö, ëka an myero agwök rom kï dhok na dödhö ëthïnögï. Ka ïmïögï owotho na bor rwök kadï pï nïnö acël, leeni kïbëc bino thöö ökö. ");
INSERT INTO lth_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ëk adwongna öcïdh anyim n'atic mërë, nakun an awotho momoth n'oporo woth ka leeni n'ötëlö yoo ëka më k'ëthïnö, naka ka an abino thuno both adwongna ï Ceir.” ");
INSERT INTO lth_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Cë Ecau okobo nï, “Ëk awëk jö na mëga mökö bothi.” Ëntö Jakob ögamö nï, “In kür ïtïm nï kömanön. Adwongna bed kï cwiny na bër ï koma, ïwëk dong obed nï kömanön.” ");
INSERT INTO lth_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Cë ï nïnö nön Ecau öcakö woth mërë më dök cen yo Ceir. ");
INSERT INTO lth_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ëntö Jakob öcïdhö yo Cukot kanya ën ögërö öt ïë ëka öyübö okul pï leeni mërë. Manön ënë ömïö ecwodo kabedo nön nï Cukot. ");
INSERT INTO lth_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Kinge na Jakob öya ökö kï Paddan Aram, ën othuno na bër ï pacö më Cekem na tye ï Kanaan ëka obedo na cwök kï pacö. ");
INSERT INTO lth_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Jakob öwïlö ngöm na ën oguro këma mërë ïë kï both ëthïnö ka Kamor, apap ka Cekem, ï wel më cïlïng mia acël. ");
INSERT INTO lth_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kany nön ënë ën ögërö keno tyër ëka öcakö nyïngë nï El Eloe Icarael. ");
INSERT INTO lth_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ï nïnö mörö acël Dina, nyaka Lea na ën önywölö kï Jakob, öcïdhö më lïmö mon më lobo nön. ");
INSERT INTO lth_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ï karë na Cekem wod ka Kamor dhanö më Kibi, rwoth më kabedo nön, önënö ën cë ömakö obedo ködë tëtëk. ");
INSERT INTO lth_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Cwinye onwongo ömarö Dina nyaka Jakob. Ën ömarö nyakö nakun twak ködë kï mar. ");
INSERT INTO lth_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Cekem okobo n'apap mërë Kamor nï, “Nyöm nïna nyakö ni obed dhaköna.” ");
INSERT INTO lth_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ï karë na Jakob owinyo nï nyarë Dina ebedo ködë tëtëk, awope mërë onwongo tye gïnï kï leeni më pacö ï thim. Jakob ölïng alïnga ba okobo gin mörö naka k'awope mërë odwogo pacö. ");
INSERT INTO lth_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Cë Kamor, apap ka Cekem, öcïdhö më twak kï Jakob. ");
INSERT INTO lth_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ï karë n'awope ka Jakob owinyo gïnï kï ï thim ngö n'ötïmërë ï kom Dina, odwogo gïnï ökö. Gïn onwongo ökëcö rwök ëka akëmö thon ömakögï pïën Cekem ötïmö gin më lewic na ba bër ï Icarael nakun bedo kï nyaka Jakob tëtëk—gin mörö na myero kür ötïmërë. ");
INSERT INTO lth_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ëntö Kamor okobo bothgï nï, “Woda Cekem tye kï mar gïn kï nyari. Öma mïï önyöm nyari obed dhakö mërë. ");
INSERT INTO lth_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Wëk nyom obed tye ï kinwa kodwu, mïï unu anyirawu bothwa, ëka un thon ïnyöm anyirawa obed monwu. ");
INSERT INTO lth_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Un ïtwërö bedo ï kinwa, ibino bedo unu ï lobo ni kite na un ïmïtö. Bed unu ïë, cadh unu cath ïë, ëka inwong unu jami kï ïë.” ");
INSERT INTO lth_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Cë Cekem okobo both apap ka Dina ëka utmego mërë nï, “Bed unu kï cwiny na bër ï koma, ëka an abino mïöwu lïm kïbëc na un ibino ngölö. ");
INSERT INTO lth_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ngöl unu wel lïm kite na un ïmïtö ködë, ëka an abino mïö gin mörö këkën na un ibino penyona. Ëntö mïa unu nyakö ni ëk anyöm obed dhaköna.” ");
INSERT INTO lth_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Awope ka Jakob ögamö gïnï kï yoo më bwöl ï karë na gïn ötwak kï Cekem ëka apap mërë Kamor pïën Cekem obedo k'amïn-gï Dina tëtëk. ");
INSERT INTO lth_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Gïn okobo bothgï nï, “Wan ba ëtwërö mïö amïnwa both ëcwö na ba ëlïrö pïën bino bedo më lewic bothwa. ");
INSERT INTO lth_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Wan ëtwërö yee pï tyën köp acël: Ka un ïtwërö yee më bedo kamë wan nakun ïlïrö unu cwö kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Cë wan ebino mïö anyirawa ëka wan ebino kwanyö anyirawu më bedo mëwa. Wan ebino bedo ï kinwu ëk ebed wat. ");
INSERT INTO lth_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ëntö ka un ba ibino yee më lïrë, wan ebino kwanyö amïnwa ëka ëcïdhö ködë ökö.” ");
INSERT INTO lth_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Köpgï oyomo cwiny Kamor ëka wode Cekem. ");
INSERT INTO lth_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Cekem n'onwongo obedo dhanö n'ëwörö kï ï pacögï ba ögalërë më tïmö gin n'ekobo nïnë pïën ën onwongo mïtö Dina nyaka Jakob rwök. ");
INSERT INTO lth_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Cë Kamor ëka wode Cekem öcïdhö gïnï ï dhö wangkac më pacögï ëka ötwak gïnï both jö më pacögï nï, ");
INSERT INTO lth_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Jö ni tye gïnï na bër kod onu. Eru ewekugï obed ï lobo onu ëka öcadh gïnï cath ïë, pïën lobo tye na lac na römögï. Onu ëtwërö nyömö anyiragï ëka gïn thon twërö nyömö anyira onu. ");
INSERT INTO lth_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ëntö gïn twërö bedo kod onu na calö wat ka cwö kïbëc na tye both onu oye më lïrë na calö gïn. ");
INSERT INTO lth_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ëntö ka onu ëtïmö man, leenigï ëka kï lïmgï kïbëc ba twërö bedo më onu? Gin na myero onu ëtïm ënë më yee, ëka gïn twërö bedo kany kod onu.” ");
INSERT INTO lth_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Cwö kïbëc n'öcökërë ï dhö wangkac oye gïnï köp ka Kamor ëka wode Cekem. Cwö kïbëc n'öcökërë gïnï ï dhö wangkac ëlïrögï. ");
INSERT INTO lth_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Kinge nïnö adek, n'ajemegï onwongo pod lïth, awope ka Jakob arïö, Cimeon ëka Lebi, utmego ka Dina, ökwanyö gïnï pala abadëgï cë öcïdhö gïnï ï pacö na wegi mërë ba ngeo ëka oneko gïnï cwö kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Gïn oneko Kamor ëka wode kï pala abadë, ökwanyö gïnï Dina kï ï öt ka Cekem ëka öcïdhö gïnï ködë ökö. ");
INSERT INTO lth_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ï karë n'awope ka Jakob nökënë obino gïnï kanya lyene tye ïë, gïn öyakö jami kï ï pacö pïën amïn-gï onwongo ebedo ködë tëtëk. ");
INSERT INTO lth_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Gïn otero rom kï dyegi, dhok, kene ëka jami kïbëc n'onwongo tye ï pacö ëka ï pwothi. ");
INSERT INTO lth_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Gïn otero lïmgï kïbëc, mon-gï kïbëc, ëthïnögï ëka jami kïbëc na gïn öyakö kï ï udigï. ");
INSERT INTO lth_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Cë Jakob okobo both Cimeon ëka Lebi nï, “Un ikelo pëkö ï koma ëka ïmïa unu adökö dhanö na rac both jö Kanaan ëka jö Periji—both jö na bedo gïnï ï lobo ni. Wel onu nök, ëka ka gïn örïbërë më lwëny köda, an ëka jö më öda ebino tyeko ökö.” ");
INSERT INTO lth_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ëntö gïn ögamö nï, “Onwongo pore më mïö ën bedo k'amïnwa calö ölaya?” ");
INSERT INTO lth_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Kinge karë mörö, Obanga okobo both Jakob nï, “Yaa malö ïcïdh yo Betel ëk ibed kunön, ëka ïgër keno tyër kunön both Obanga, n'obino onen bothi ï karë na in itye ka ngwëc ökö kï both omeru Ecau.” ");
INSERT INTO lth_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Cë Jakob okobo both jö më ödë ëka both jö kïbëc n'onwongo wotho ködë nï, “Yuu unu obanga nökënë gïnï na tye bothwu ökö. Lönyërë unu ëka ïlök unu böngwu. ");
INSERT INTO lth_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kinge onu ebino yaa ëcïdhö yo Betel, kanya an abino gërö keno tyër both Obanga, n'owinyo lëgana ï karë na an atye ï pëkö ëka n'obedo gwököna kï kanya an abedo ka woth ïë.” ");
INSERT INTO lth_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Cë gïn ömïö Jakob obanga nökënë gïnï kïbëc n'onwongo gïn tye ködë ëka gwïlü n'onwongo tye ï ithgï. Jakob oikogï ï thë yath na thwönë na cwök kï Cekem. ");
INSERT INTO lth_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Cë gïn öcakö woth, ëka lworo n'öya kï both Obanga opodho ï kom peci kïbëc na cwök n'ögürögï ëk ngat mörö kür ölüb körgï. ");
INSERT INTO lth_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Kinge nïnö na nönök, Jakob ëka jö më ödë kïbëc othuno gïnï yo Luj (manön, Betel) na tye ï lobo Kanaan. ");
INSERT INTO lth_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ën ögërö keno tyër kunön, ëka öcakö nyïng kabedo nön El Betel, pïën kany nön ënë Obanga onyuthere ködë bothe ï karë na ën tye ka lüü kï both ömïn mërë. ");
INSERT INTO lth_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ï karë na gïn tye kunön, Debora apidi ka Rebeka na dhakö n'ögwökö ën öthöö ökö ëka eiko ën ï thë yath na thwönë na tye ï Betel cë ebino ëcakö nyïngë Allon Bacut. ");
INSERT INTO lth_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kinge na Jakob odwogo kï ï Paddan Aram, Obanga dökï onen both Jakob ëka ömïö gum. ");
INSERT INTO lth_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Obanga okobo bothe nï, “Nyingi obedo Jakob, ëntö in ba dökï ebino cwodoni nï Jakob; nyingi bino bedo Icarael.” Cë Obanga öcakö nyïngë Icarael. ");
INSERT INTO lth_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Cë Obanga okobo bothe nï, “An abedo Obanga Won Twër kïbëc, nywöl ëka ïnya ï wel na pol. Rok ëka jö më rok kïbëc bino yaa kï bothi, ëka rwodhi bino bedo ï kin ëkwaëni. ");
INSERT INTO lth_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Lobo na an amïö both Abraam ëka Icaka an thon amïö yo bothi, ëka an abino mïö lobo ni yo both ëkwaëni kï kori.” ");
INSERT INTO lth_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Cë Obanga öya ökö kï bothe kï ï kabedo n'onwongo ën ötwak ködë ïë. ");
INSERT INTO lth_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakob oketho kidi n'obedo wïr ï kabedo kanya Obanga onwongo ötwak ködë ïë. Ën öönyö mïc amadha ïë, ëka öönyö thon möö ïë. ");
INSERT INTO lth_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jakob öcakö nyïng kabedo n'Obanga onwongo ötwak ködë ïë nï Betel. ");
INSERT INTO lth_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Kinge manön, Jakob kï jö më ödë öya gïnï ökö kï ï Betel. Ï karë na gïn pod tye na bobor kï ï Eparat, rem më nywöl ögöö Racel ëka rem mërë onwongo tëk. ");
INSERT INTO lth_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ï karë na ën tye kï rem nywöl na tëk, acöl mon okobo bothe nï, “Kür ibed kï lworo, pïën in ïnywölö awobi nökënë.” ");
INSERT INTO lth_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ëntö Racel onwongo cwök thöö, ëka na bara öthöö, ën öcakö nyïngë Ben Oni. Ëntö Jakob öcakö nyïngë nï Benjamin. ");
INSERT INTO lth_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Cë Racel öthöö ëka eiko ï yoo n'onwongo etye ka cïdhö yo Eparat (manön, Bethelem). ");
INSERT INTO lth_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jakob oketho kidi ï wi lyël ka Racel, ëka kidi nön pod tye kany nön naka ï nïnö ni. ");
INSERT INTO lth_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Jakob, n'ecwodo thon nï Icarael, ömëdërë kï woth mërë ëka oguro këma mërë yo nge Migdal Eder. ");
INSERT INTO lth_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ï karë na Jakob tye ï lobo nön, Reuben obedo kï Bila n'obedo dhakö k'apap mërë nökënë, ëka Jakob owinyo köp nön. Jakob onwongo tye k'awope apar arïö: ");
INSERT INTO lth_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Awope ka Lea onwongo obedo: Reuben, athïn kaö ka Jakob, Cimeon, Lebi, Yuda, Icakar ëka Jabulon. ");
INSERT INTO lth_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Awope ka Racel onwongo obedo: Yocepu ëka Benjamin. ");
INSERT INTO lth_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Awope ka Bila atic ka Racel onwongo obedo: Dan ëka Naputali. ");
INSERT INTO lth_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Awope ka Jilpa atic ka Lea onwongo obedo: Gad ëka Acer. Man onwongo obedo awope ka Jakob n'ënywölögï kï ï Paddan Aram. ");
INSERT INTO lth_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakob obino odwogo both apap mërë Icaka n'onwongo tye ï Mamre, na cwök kï Kiriat Arba (manön, Kebron), kanya Abraam ëka Icaka onwongo obedo gïnï ïë. ");
INSERT INTO lth_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Icaka obedo ï wi lobo pï mwaka 180. ");
INSERT INTO lth_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Cë öthöö na mwaka mërë dong dit, na dong otengo rwök cë eiko ën kanya acël kï kwere mërë. Awope mërë Ecau ëka Jakob oiko ën. ");
INSERT INTO lth_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Man ënë ëkwaë k'Ecau (ecwodo thon nï Edom). ");
INSERT INTO lth_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ecau önyömö mon mërë kï both jö Kanaan: Ada nyaka Elon n'obedo dhanö më Kit, ëka Okolibama nyaka Ana akwar Jibeon dhanö më Kibi— ");
INSERT INTO lth_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ën thon önyömö Bacemat nyaka Icimael ëka amïn Nebayot. ");
INSERT INTO lth_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada önywölö n'Ecau Elipaji, Bacemat önywölö Reuel, ");
INSERT INTO lth_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ëka Okolibama önywölö Jeuc, Jalam ëka Kora. Man awope k'Ecau n'ënywölögï kï ï lobo Kanaan. ");
INSERT INTO lth_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ecau otero mon mërë, ëthïnö awope ëka anyira, jö kïbëc më ödë, leeni mërë, ëka jami kïbëc na ën onwongo kï ï lobo Kanaan, cë öcïdhö ködë ï lobo nökënë kï both ömïn mërë Jakob. ");
INSERT INTO lth_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Pïën jamigï onwongo pol rwök na gïn ba römö bedo kanya acël; lobo n'onwongo gïn bedo ïë onwongo ba römögï pïën leenigï onwongo pol. ");
INSERT INTO lth_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Cë Ecau (manön, Edom) öcïdhö obedo ï Ceir ï lobo n'otingere malö. ");
INSERT INTO lth_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Man ënë ëkwaë k'Ecau, kwarö ka jö Edom na bedo gïnï ï lobo n'otingere më Ceir. ");
INSERT INTO lth_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Man ënë nyïng awope k'Ecau: Elipaji, wod ka dhakö k'Ecau n'ecwodo nï Ada, ëka Reuel, wod ka dhakö k'Ecau n'ecwodo nï Bacemat. ");
INSERT INTO lth_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Awope ka Elipaji onwongo obedo: Teman, Omar, Jepo, Gatam ëka Kenaj. ");
INSERT INTO lth_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Wod k'Ecau n'ecwodo nï Elipaji, onwongo thon tye kï dhakö nökënë n'ecwodo nï Timna n'önywölö nïnë Amalek. Man onwongo obedo ëkwaë ka dhakö k'Ecau n'ecwodo nï Ada. ");
INSERT INTO lth_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Awope ka Reuel onwongo obedo: Nakat, Jera, Camma ëka Mija. Man onwongo obedo ëkwaë ka dhakö k'Ecau n'ecwodo nï Bacemat. ");
INSERT INTO lth_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Awope ka dhakö k'Ecau n'ecwodo nï Okolibama nyaka Ana akwar Jibeon, na ën önywölö n'Ecau ënë: Jeuc, Jalam ëka Kora. ");
INSERT INTO lth_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Man ënë ëkwaë k'Ecau n'obino ödökö gïnï rwodhi: Awope k'Elipaji n'obedo kaö k'Ecau: rwoth Teman, rwoth Omar, rwoth Jepo, rwoth Kenaj, ");
INSERT INTO lth_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","rwoth Kora, rwoth Gatam ëka rwoth Amalek. Man onwongo obedo rwodhi n'öya kï both Elipaji kï ï lobo Edom; gïn onwongo obedo ëkwaë ka Ada. ");
INSERT INTO lth_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Man ënë awope ka Reuel wod k'Ecau: rwoth Nakat, rwoth Jera, rwoth Camma ëka rwoth Mija. Man ënë onwongo obedo rwodhi n'öya kï both Reuel kï ï lobo më Edom. Gïn onwongo obedo ëkwaë ka dhakö k'Ecau n'ecwodo nï Bacemat. ");
INSERT INTO lth_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Awope ka dhakö k'Ecau n'ecwodo nï Okolibama: rwoth Jeuc, rwoth Jalam ëka rwoth Kora. Man ënë onwongo obedo rwodhi n'öya kï both dhakö k'Ecau Okolibama nyaka Ana. ");
INSERT INTO lth_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Man ënë onwongo obedo awope k'Ecau (manön, Edom) ëka man ënë onwongo obedo rwodhigï. ");
INSERT INTO lth_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Man ënë onwongo obedo awope ka Ceir dhanö më Kori, n'onwongo bedo gïnï ï lobo nön: Lotan, Cobal, Jibeon, Ana, ");
INSERT INTO lth_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dicon, Ejer ëka Dican. Man ënë onwongo obedo rwodhi ka jö Kori, ëkwaë ka Ceir më lobo Edom. ");
INSERT INTO lth_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Awope ka Lotan onwongo obedo: Kori ëka Emam. Timna onwongo obedo amïn Lotan. ");
INSERT INTO lth_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Man ënë onwongo obedo awope ka Cobal: Alban, Manaat, Ebal, Cepo ëka Onam. ");
INSERT INTO lth_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Man ënë onwongo awope ka Jibeon: Aia ëka Ana. Man Ana n'obino onwongo pii na lyeth kï ï thim ï karë na ën tye ka kwaö kene k'apap mërë Jibeon. ");
INSERT INTO lth_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Man ënë onwongo ëthïnö ka Ana: Dicon ëka Okolibama nyaka Ana. ");
INSERT INTO lth_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Man ënë onwongo obedo awope ka Dicon: Kemdan, Eciban, Itran ëka Keran. ");
INSERT INTO lth_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Man ënë onwongo obedo awope ka Ejer: Bilan, Jaaban ëka Akan. ");
INSERT INTO lth_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Man ënë onwongo obedo awope ka Dican: Uj ëka Aran. ");
INSERT INTO lth_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Man ënë onwongo obedo rwodhi ka jö Kori: rwoth Lotan, rwoth Cobal, rwoth Jibeon, rwoth Ana, ");
INSERT INTO lth_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","rwoth Dicon, rwoth Ejer, ëka rwoth Dican. Man ënë onwongo obedo rwodhi ka jö Kori, na lübërë kï kite na kakagï tye ködë ï lobo Ceir. ");
INSERT INTO lth_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Man ënë rwodhi n'ölöö gïnï löc ï lobo më Edom na bara rwoth mörö më Icarael ölöö löc. ");
INSERT INTO lth_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela wod ka Beor obino ödökö rwoth më Edom. Pacö mërë ebino ëcakö nyïngë Dinkaba. ");
INSERT INTO lth_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ï karë na Bela öthöö, Jobab wod ka Jera n'öya kï ï Bojra oleo ka tyënë na calö rwoth. ");
INSERT INTO lth_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ï karë na Jobab öthöö, Kucam n'öya kï ï lobo ka jö Teman oleo ka tyënë na calö rwoth. ");
INSERT INTO lth_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ï karë na Kucam öthöö, Kadad wod ka Bedad, n'ölöö Midian ï lobo më Moab, obino oleo ka tyënë na calö rwoth. Pacö mërë ebino ëcakö nyïngë Abit. ");
INSERT INTO lth_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ï karë na Kadad öthöö, Camla n'öya kï ï Macireka oleo ka tyënë na calö rwoth. ");
INSERT INTO lth_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ï karë na Camla öthöö, Caul n'öya kï ï Rekobot na tye ï dhö kulo më Euparate oleo ka tyënë na calö rwoth. ");
INSERT INTO lth_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ï karë na Caul öthöö, Baal Kanan wod ka Akbor oleo ka tyënë na calö rwoth. ");
INSERT INTO lth_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ï karë na Baal Kanan wod ka Akbor öthöö, Kadad oleo ka tyënë na calö rwoth. Pacö mërë ebino ëcakö nyïngë Pau, ëka nyïng dhakö mërë onwongo ecwodo nï Meketabel nyaka Matred, nyaka Mejaab. ");
INSERT INTO lth_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Man ënë rwodhi n'öya kï both Ecau, kï nyïng-gï, na lübërë kï kakagï ëka lobogï: rwoth Timna, rwoth Alba, rwoth Jetet, ");
INSERT INTO lth_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","rwoth Okolibama, rwoth Ela, rwoth Pinon, ");
INSERT INTO lth_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","rwoth Kenaj, rwoth Teman, rwoth Mibjar, ");
INSERT INTO lth_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","rwoth Magdiel ëka rwoth Iram. Man ënë onwongo obedo rwodhi më Edom, na lübërë kï kite na gïn obedo ködë ï lobo n'obedo mëgï. Man ënë Ecau akwar jö Edom. ");
INSERT INTO lth_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakob obedo ï lobo Kanaan, kanya onwongo yam apap mërë obedo ïë. ");
INSERT INTO lth_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Man ënë köp më thëkwarö më öt ka Jakob. Ï karë na Yocepu dong othuno mwaka apar abïrö, ën onwongo kwaö rom ëka dyegi kanya acël kï utmego mërë, awope ka Bila ëka më Jilpa, n'obedo gïnï mon k'apap mërë Jakob. Ën okelo köp na rac ï kom utmego mërë both apap mërë. ");
INSERT INTO lth_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jakob onwongo marö Yocepu rwök na löö awope mërë nökënë pïën ënywölö ën ï karë na ën dong otii. Ën öyübö nïnë böngü na bor na badë boco. ");
INSERT INTO lth_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ï karë na utmego mërë önënö nï apapgï marö Yocepu rwök löögï ökö, gïn öcakö dagö ën ëka onwongo ba dökï ëtwak ködë kï yom cwiny. ");
INSERT INTO lth_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ï kiwor mörö acël Yocepu oleko lek cë okobo both utmego mërë, gïn ömëdërë kï dagö ën rwök. ");
INSERT INTO lth_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ën okobo nïgï nï, “Winy unu lek na an aleko: ");
INSERT INTO lth_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Aleko nï onu onwongo etye ka rïdhö kal kï ï pwodho, cë kal na an atweo öya malö ocung atïr, ëka kal na un itweo obino ögürö mëga dyere cë oryebere gïnï pïny ï nyim mëga.” ");
INSERT INTO lth_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Utmego mërë öcakö gamö nïnë nï, “In ïthamö nï ibino lööwa? In ibino lööwa adyer?” Cë utmego mërë öcakö mëdërë gïnï amëda më dagö ën rwök pï lek mërë nön ëka pï köp na ën ötwakö. ");
INSERT INTO lth_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Cë Yocepu dökï oleko lek nökënë, ëka okobo both utmego mërë nï, “Winy unu, aleko lek nökënë dökï nï ceng, dwe ëka cër apar acël oryebere gïnï pïny ï nyima.” ");
INSERT INTO lth_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ï karë na ën okobo lek mërë nön both apap mërë ëka utmego mërë, apap mërë ocoko ën nakun kobo nï, “Koth lek ngö na in ileko nön? In ïthamö nï ayani, an ëka utmegoni adyer ebino ryebere pïny ï nyimi?” ");
INSERT INTO lth_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Adïnga öcakö makö utmego mërë rwök ï kome, ëntö apap mërë ökanö köp nön kïbëc ï cwinye. ");
INSERT INTO lth_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ï nïnö mörö acël, utmego ka Yocepu öcïdhö gïnï kwaö rom ëka dyegi k'apapgï na cwök kï Cekem, ");
INSERT INTO lth_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Icarael okobo both Yocepu nï, “Utmegoni öcïdhö gïnï yo kukwath na cwök kï Cekem. Bin ëk aori bothgï.” Ën ögamö nï, “An enene.” ");
INSERT INTO lth_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Apap mërë okobo nïnë nï, “Cïdh ïnën ka utmegoni ëka rom kï dyegi tye gïnï na bër ëk idwogi ikob nïna.” Ën ooro Yocepu më yaa kï ï ora më Kebron. Ï karë na Yocepu othuno ï Cekem, ");
INSERT INTO lth_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ëcwö mörö onwongo ën tye ka lath ï dye bar, cë openyo Yocepu nï, “Ngö na in ïrangö?” ");
INSERT INTO lth_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ën ögamö nï, “An arangö utmegona. In ïrömö kobo nïna kanya gïn kwaö kwath ïë?” ");
INSERT INTO lth_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ëcwö nön ögamö nïnë nï, “Gïn dong öya ökö kï kany. An awinyo ka gïn kobo nï, ‘Eru ëcïdh unu yo Dotan.’” Yocepu öcakö lübö körgï cë onwongogï na cwök kï Dotan. ");
INSERT INTO lth_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ëntö ï karë na utmego mërë önënö ën kï kanya bobor, gïn öcakö yübö köp më neko ën ökö. ");
INSERT INTO lth_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Cë ötwak ï kin-gï kën-gï nï, “Won lek ëca tye ka bino! ");
INSERT INTO lth_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Bin unu enek ën ökö ëk ebol ï bur mörö acël kany, ëk ekob nï lee mörö na ger ënë omwodo. Cë dong ebino nënö kite na lek mërë gïnï bino cobere ködë.” ");
INSERT INTO lth_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ï karë na Reuben owinyo köp ni, ën ötëmö më larö Yocepu ökö kï ï cïng-gï nakun kobo nïgï nï, “Eru kür enek ën. ");
INSERT INTO lth_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kür ïöny unu remo mörö. Eru ebol ën ï bur mörö kany ï thim, ëntö kür eketh cïng onu ï kome.” Reuben okobo köp ni pïën ën onwongo öyübërë më kwanyö ën ökö kï öd bur ëk ëdwök ën cen both apap mërë. ");
INSERT INTO lth_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ï karë na Yocepu othuno both utmego mërë, gïn ögönyö böngü mërë na ën oruko n'onwongo bor ëka badë onwongo boco. ");
INSERT INTO lth_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Gïn ömakö ën cë obolo gïnï ï bur. Ï bur onwongo tye nono, pii onwongo ope ïë. ");
INSERT INTO lth_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Cë gïn öcakö bedo pïny më cem, ï karë na gïn önënö gurup ka jö Icimael n'öya gïnï kï ï Gilead. Kïnagagï onwongo öyëö odok, möö na kur ëka müra nakun tye ka cïdhö gïnï yo Ejip. ");
INSERT INTO lth_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda öcakö kobo both utmego mërë nï, “Ngö na onu ebino nwongo ka eneko ömïn onu ëka ëmüngö thöö mërë ökö? ");
INSERT INTO lth_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Bin, ëk ëcadh unu ën ökö both jö Icimael, ëk kür eketh cïng onu ï kome, pïën ën obedo ömïn onu, kom onu kikokome.” Utmego mërë oyeo. ");
INSERT INTO lth_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Cë ï karë n'ëcadh wïl më Midian owok gïnï na cwök, utmego mërë öywaö Yocepu ökö kï öd bur ëka öcadhö gïnï ën ökö both jö Icimael pï cëkël më ryal pyer arïö cë jö më Icimael otero Yocepu naka yo Ejip. ");
INSERT INTO lth_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ï karë na Reuben odwogo cen ï bur ëka onwongo Yocepu ope ïë, ën öyëcö böng mërë ökö kï ï kome pï cwer cwiny. ");
INSERT INTO lth_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ën ödök cen both utmego mërë ëka okobo nï, “Awobi ni ope kunön! Ngö na an abino tïmö kobedini?” ");
INSERT INTO lth_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Cë gïn ökwanyö böngü ka Yocepu ëka öngënö gïnï kï remo ka dyël na gïn oneko. ");
INSERT INTO lth_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Otero gïnï both apapgï ëka okobo gïnï nï, “Wan enwongo böngü ni. Nën ka obedo böngü ka wodi onyo pe.” ");
INSERT INTO lth_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ï karë na ën önënö, okobo nï, “Man böngü k'athïn-na kikokome. Lee na ger omwodo ën. Adyer lee ökïdhö Yocepu na thïthïnö.” ");
INSERT INTO lth_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Cë Jakob öcakö yëcö böng mërë ökö kï ï kome ëka otweo böng cöla ï pyërë, cë okoko wode pï karë na lac. ");
INSERT INTO lth_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Awope ëka anyira mërë kïbëc obino gïnï më kweo cwinye, ëntö ën ökwërö ökö nï kür ekwe cwinye. Nakun kobo nï, “Pe, ba obedo nï kömanön. An abino lübö kör athïn-na kï koko naka thon ï bur.” Apap mërë obedo koko ën kömanön. ");
INSERT INTO lth_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Jö Midian otero gïnï Yocepu yo Ejip ëka öcadhö gïnï ën both Potipa n'obedo adit etic ka Parao nakun ënë löö acikari kïbëc na kürö pïny. ");
INSERT INTO lth_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ï karë nön, Yuda öya ökö kï both utmego mërë ëka öcïdhö më bedo both ëcwö mörö më Adulam na nyïngë Kira. ");
INSERT INTO lth_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Kï kunön, Yuda önënö nyaka Cua dhanö më Kanaan, cë önyömö ëka obedo ködë. ");
INSERT INTO lth_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Dhakö nön obino öyac ëka önywölö wode cë öcakö nyïngë Er. ");
INSERT INTO lth_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ën dökï öyac ëka önywölö wode cë öcakö nyïngë Onan. ");
INSERT INTO lth_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ën obino öyac dökï ëka önywölö wode nökënë cë öcakö nyïngë Cela. Gïn onwongo bedo ï Kejib ï karë na ën nywölö Cela. ");
INSERT INTO lth_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuda obino onwongo dhakö na nyïngë Tamar, cë önyömö nï kaö mërë Er. ");
INSERT INTO lth_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ëntö Er kaö ka Yuda, kwö mërë onwongo rac kï ï wang Rwoth, cë Rwoth obino oneko ën ökö. ");
INSERT INTO lth_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Cë Yuda okobo both Onan ömïn Er nï, “Cïdh iter dhakö k'omeru ëka icob ticni na calö ömïn cwörë, ëk ïnywöl ëthïnö ka wi omeru.” ");
INSERT INTO lth_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ëntö Onan ongeo nï ëthïnö ba bino bedo mëgë, cë ï karë na ën bedo kï dhakö k'ömïn mërë, ën wëkö remo mërë öny ökö pïny më jükö ëk kür ënywöl ëthïnö ka wi ömïn mërë. ");
INSERT INTO lth_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Gin na ën ötïmö onwongo rac kï ï wang Rwoth, cë ömïö Rwoth oneko ën ökö thon. ");
INSERT INTO lth_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ï karë na ën dong öthöö, Yuda okobo both Tamar, dhakö ka wode nï, “Cïdh ibed ï öt k'apapni na calö dhakö na cwörë öthöö naka ka woda Cela ödöngö.” Ën okobo nï kömanön pïën ën onwongo tye kï lworo nï Cela thon bino thöö ökö kamë utmego mërë. Cë Tamar ödök yo pacögï më bedo ï öt k'apap mërë. ");
INSERT INTO lth_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kinge karë mörö, dhakö ka Yuda n'obedo nyaka Cua öthöö. Ï karë na Yuda otyeko nïnö më kumo pï dhakö mërë ëka cwinye dong okwe, ën öcakö yaa më cïdhö yo Timna both cwö mörö n'onwongo nyarö yer rom mërë. Ën owotho kanya acël k'okone mërë Kira dhanö më Adulam. ");
INSERT INTO lth_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Cë ekobo both Tamar nï, “Kwaröni tye ka cïdhö yo Timna më nyarö yer rom mërë.” ");
INSERT INTO lth_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamar ögönyö böng mërë më cöla ökö, oumo wangë k'atam ëk ömïï kür enge ën, ëka öcïdhö obedo pïny ï nget dhö wangkac na cïdhö yo Enaim, na tye ï yoo na cïdhö yo Timna. Pïën ën ongeo nï Cela dong ödöngö ökö ëntö ba ëmïö ölakö ën calö dhakö mërë. ");
INSERT INTO lth_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ï karë na Yuda önënö ën ï nget yoo, ën öthamö nï ködë obedo ölaya mörö, pïën onwongo oumo wangë ökö kï böngü. ");
INSERT INTO lth_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yuda ba ongeo nï dhakö ka wode ënön cë öcïdhö bothe ï nget yoo ëka okobo nïnë nï, “Wëk abed kodi.” Tamar openyo ën nï, “Ngö na in ibino mïöna ka an abedo kodi?” ");
INSERT INTO lth_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda ögamö nï, “An abino oro nini athïn dyël kï ï kin dyegina.” Tamar dökï openyo ën nï, “Ngö na in ibino jengo pï tutunu naka ka ioro athïn dyël?” ");
INSERT INTO lth_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda ögamö nï, “Ngö na in ïmïtö nï ajeng nini?” Ën ögamö nï, “Mïa agïth na nyingi tye ïë kï thöl mërë, ëka lüth na in ïmakö ï cingi.” Yuda ömïögï bothe cë ën obedo ködë ëka Tamar öyac ökö ködë. ");
INSERT INTO lth_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Kinge manön, Tamar ödök cen pacö, ökwanyö böng nön ökö kï ï kome, ëka öcakö ruko böng cöla më dha thöö. ");
INSERT INTO lth_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda öcïdhö ëka ooro okone mërë Kira dhanö më Adulam k'athïn dyël, ëk okel cë ögam jami mërë na ën ejengo both dhakö, ëntö Kira ba obino onwongo ën. ");
INSERT INTO lth_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Cë ën openyo cwö mörö n'onwongo bedo gïnï kany nön nï, “An atwërö nwongo ölaya mörö n'onwongo bedo ï nget yoo na cïdhö yo Enaim kwene?” Gïn ögamö nï, “Ölaya mörö ope na bedo kany.” ");
INSERT INTO lth_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ën ödök cen both Yuda ëka okobo nï, “An ba anwongo ën, ëka cwö na bedo kany nön okobo nïna nï, ‘Ölaya mörö ope kany.’” ");
INSERT INTO lth_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Cë Yuda okobo nï, “Ëk ën dong ögwök ngö na ën tye ködë, onyo onu ebino dökö gin më anyëra. Ka kömanön, an aoro nïnë athïn dyël ëntö ba inwongo ën.” ");
INSERT INTO lth_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kinge dwethe adek, ekobo both Yuda nï, “Cii wodi Tamar obedo tic calö ölaya, ëka öyac ökö.” Yuda ömïö twërö nï, “Kel unu ën yökö ëka ïwang unu ën naka ï thöö!” ");
INSERT INTO lth_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ëntö ï caa n'etye ka kelo ën yökö, ën ooro köp both kwarö mërë Yuda nï, “An ayac k'ëcwö won jami ni. Nën ka ïrömö ngeo won agïth, thöl ëka lüth ni?” ");
INSERT INTO lth_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda ongeo ëka okobo nï, “Ën obedo dhanö na kite atïr na löa ökö, pïën an ba amïö woda Cela më nyömö ën.” Kinge manön, Yuda ba dökï obedo ködë. ");
INSERT INTO lth_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ï karë na nïnö më nywöl ka Tamar örömö, ebino enwongo nï ën bino nywölö rudi. ");
INSERT INTO lth_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ï caa na ën tye ka nywöl, athïn acël okelo cïngë yökö, cë acöl mon ökwanyö thöl na kwar cë otweo ï ngut cïng athïn ëka okobo nï, “Man ënë öcakö bino.” ");
INSERT INTO lth_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ëntö ï caa na ën ödwökö cïngë ökö, ömïn mërë odonyo ëka dhakö na cölö Tamar okobo nï, “Man ënë kite na in idonyo ködë yökö!” Ëka ëcakö nyïngë Perej. ");
INSERT INTO lth_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Cë ömïn mërë dong ënywölö kï ï nge na thöl na kwar tye ï ngut cïngë, cë ëcakö nyïngë nï Jera. ");
INSERT INTO lth_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ï karë n'etero Yocepu yo Ejip, Potipa, dhanö më Ejip n'onwongo obedo adit etic ka Parao na löö wi acikari na kürö pïny, öwïlö Yocepu kï both jö Icimael n'otero ën kunön. ");
INSERT INTO lth_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Rwoth onwongo tye kï Yocepu ëka ömïö jami kïbëc na ën tïmö wotho na bër. Ën onwongo bedo ï öt k'adwong mërë n'obedo dhanö më Ejip. ");
INSERT INTO lth_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ï karë n'adwong mërë önënö nï Rwoth tye kï Yocepu, ëka Rwoth ömïö jami kïbëc na ën tïmö wotho na bër, ");
INSERT INTO lth_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ën obedo kï cwiny na bër rwök ï kom Yocepu nakun ketho ën më bedo atic mërë, ëka ömïö ën më löönö ödë ëka jami kïbëc na ën tye ködë. ");
INSERT INTO lth_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Cakërë ï karë na ën oketho Yocepu më löönö ödë ëka jami kïbëc na ën tye ködë, Rwoth ömïö gum ï öt ka Potipa pï Yocepu. Gum ka Rwoth onwongo tye ï kom jami kïbëc na Potipa onwongo ut ködë, kï ï öt ëka kï ï pwothi thon. ");
INSERT INTO lth_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Manön ömïö Potipa öwëkö jami mërë kïbëc na ën tye ködë ï thë twërö ka Yocepu. Bedo ka Yocepu ï ödë ömïö ën ba dökï parö gin mörö këkën na path kï cem na ën camö. Yocepu onwongo ödöngö na bër ëka leng rwök. ");
INSERT INTO lth_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kinge karë mörö, dhakö k'adwong mërë önïrö Yocepu cë okobo nïnë nï, “Bin ibed köda!” ");
INSERT INTO lth_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ëntö Yocepu ökwërö ökö nakun kobo nï, “Nën, bedona kany ömïö adwongna ba dökï parö pï gin mörö këkën na tye ï ödë, ëka thon ën dong ogena kï jami mërë kïbëc na ën tye ködë. ");
INSERT INTO lth_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ngat mörö ope na dit kï ï öt ni na löa. Adwongna ömïa twërö ï kom jami kïbëc na ën tye ködë na path kï in këkën, pïën in ibedo dhakö mërë. An dökï arömö tïmö thwön gin na rac köman ëka abalö ï nyim Obanga?” ");
INSERT INTO lth_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Kono kadï dhakö nön obedo ka dïö ën nïnö kï nïnö, Yocepu obino ökwërö cïdhö ködë ökö ï wi ka buto ëka thon më bedo ködë kanya acël. ");
INSERT INTO lth_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ï nïnö mörö acël, n'etic më öt kïbëc onwongo ope gïnï ï öt, Yocepu öcïdhö ï öt më tio tic mërë. ");
INSERT INTO lth_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Cë dhakö ka Potipa ömakö böngü mërë nakun kobo nï, “Bin ibed köda!” Ëntö Yocepu ömwömërë yökö nakun wëkö böngü mërë dong ï cïngë. ");
INSERT INTO lth_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ï caa na ën önënö nï Yocepu ömwömërë yökö nakun wëkö böngü mërë dong ï cïngë, ");
INSERT INTO lth_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ën ocwodo etic na tio ï ödë ëka okobo nïgï nï, “Nën cwöra okelo dhanö më Iburu kany më nywarö onu! Ën odonyo ï öt kany më bedo köda tëtëk, ëntö an aredo rwök. ");
INSERT INTO lth_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Cë na ën owinyo nï an aredo rwök, ën ömwömërë yökö nakun wëkö böngü mërë botha.” ");
INSERT INTO lth_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ën ögwökö böngü ka Yocepu bothe naka adwong mërë obino pacö. ");
INSERT INTO lth_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Cë ën okobo gin n'ötïmërë nön both cwörë nï, “Opii më Iburu na in ikelo kany obino ï öda ëka ötëmö më nywaröna. ");
INSERT INTO lth_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ëntö ï caa na an aredo rwök, ën ömwömërë yökö ëka öwëkö böngü mërë botha.” ");
INSERT INTO lth_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ï karë n'adwong ka Yocepu owinyo ngö na dhakö mërë okobo nïnë, nakun kobo nï, “Man ënë kite n'opiini ötïma ködë,” ën öngö rwök. ");
INSERT INTO lth_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Cë ömakö Yocepu otero ï buc kanya etweo emabuc ka rwoth ïë. Ëntö ï karë na Yocepu tye ï buc kunön, ");
INSERT INTO lth_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Rwoth onwongo tye ködë, onyutho kïca mërë bothe ëka ömïö ën obedo kï cwiny na bër ï nyim ngat na löö buc. ");
INSERT INTO lth_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ngat na löö buc oketho Yocepu më bedo adit na löö emabuc kïbëc ëka kï jami kïbëc n'ëtïmö ï buc. ");
INSERT INTO lth_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ngat na löö buc onwongo ba dökï parö pï gin mörö këkën na tye ï thë gwök ka Yocepu, pïën Rwoth onwongo tye kï Yocepu ëka ömïö jami kïbëc na ën tïmö wotho na bër. ");
INSERT INTO lth_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kinge karë mörö, adit na löö poko köngö ölök ëka adit na löö tedo ogati ka rwoth më Ejip ötïmö gïnï bal both adwong-gï n'obedo rwoth më Ejip. ");
INSERT INTO lth_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Parao onwongo öngö ï kom edite tic mërë arïö, adit na löö poko köngö ölök, ëka adit na löö tedo ogati, ");
INSERT INTO lth_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","cë oterogï ï buc ï öt k'adit na kürö pïny, kanya Yocepu onwongo etweo ïë. ");
INSERT INTO lth_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Adit na löö acikari na kürö pïny ömïögï both Yocepu cë ën ögwökögï. Kinge na gïn dong obedo ï buc pï karë mörö, ");
INSERT INTO lth_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ngat acëlacël—adit na löö poko köngö ölök ëka adit na löö tedo ogati ka rwoth më Ejip n'onwongo etweogï ï buc—oleko lek mërë ï kiwor acël nön, nakun kör lek ka ngat acëlacël path. ");
INSERT INTO lth_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ï karë na Yocepu obino bothgï kodiko mërë, ën önënögï na cwinygï ba yom. ");
INSERT INTO lth_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Cë ën openyo edite tic ka Parao n'onwongo etweogï ï buc ködë ï öt k'adwong mërë nï, “Pïngö cwinywu tin ba yom?” ");
INSERT INTO lth_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Gïn ögamö nï, “Wan kïbëc tin eleko lek, ëntö ngat mörö ope na römö gönyö nïwa thërë.” Yocepu okobo nïgï nï, “Pathï Obanga ënë gönyö kör lek? Kob nïna unu lekwu.” ");
INSERT INTO lth_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Adit na löö poko köngö ölök öcakö kobo lek mërë both Yocepu nakun kobo nï, “Ï lekna, an anënö yath ölök ï nyima, ");
INSERT INTO lth_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ëka ï kom yath onwongo tye ïë jangë adek, cücüth na pod odhugo më cakö thuro, cë önyakö nyige ëka öcëk ökö. ");
INSERT INTO lth_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Okopo ka Parao onwongo tye ï cïnga, cë apüdö nyig ölök ëka abïö ï okopo ka Parao cë amïö ï cïngë.” ");
INSERT INTO lth_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yocepu okobo nïnë nï, “Lek nonu ene, jang ölök adek nyutho nïnö adek. ");
INSERT INTO lth_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ï kin nïnö adek, Parao bino gönyöni ëka bino dwököni ï dhö ticni cë in ibino mïö ën okopo ï cïngë, kite na yam ïtïmö ködë cön ï karë na in ibedo adit na löö poko köngö ölök mërë. ");
INSERT INTO lth_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ëntö myero ipo pïra ka jami kïbëc bino woth na bër kodi, akwai nï in thon ïtïm nïna kïca ëka ïtham pïra, ëk ikob both Parao köp ï koma ëk ën thon ögönya ökö kï ï öd buc ni. ");
INSERT INTO lth_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Pïën an ëkwala akwala tëtëk kï both jö Iburu ëka thon etwea ï buc kany nono na ba abalö gin mörö.” ");
INSERT INTO lth_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ï caa n'adit na löö tedo ogati önënö nï ëgönyö lek k'awodhe na bër, ën thon okobo both Yocepu mëgë nï, “An thon aleko lek nï onwongo adoko aditi adek më ogati ï wia. ");
INSERT INTO lth_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ï adïta na malö onwongo tye ïë kwa ogati na papath pï Parao, ëntö wïny onwongo tye ka camö ogati kï ï adïta na an ayëö ï wia.” ");
INSERT INTO lth_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yocepu ögamö nï, “Lekni nön thërë ene: Aditi adek nyutho nïnö adek thon. ");
INSERT INTO lth_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ï kin nïnö adek Parao bino gönyöni ökö ëka nguno nguti cë ngabö komi ï wi yath ëka wïny bino camö ringo komi ökö.” ");
INSERT INTO lth_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ï nïnö më adek onwongo obedo nïnö na yam ënywölö Parao ïë, ëka ën öyübö karama pï edite mërë kïbëc. Ën öcakö kelo adit na löö poko köngö ölök ëka adit na löö tedo ogati ï nyim edite mërë. ");
INSERT INTO lth_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ën ödwökö adit na löö poko köngö ölök ï tic mërë, ëk ën dökï ömëdërë kï mïö okopo ï cïng Parao, ");
INSERT INTO lth_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ëntö ën öngabö adit na löö tedo ogati kite na Yocepu ögönyö kï lek mërë. ");
INSERT INTO lth_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Adit na löö poko köngö ölök ba dökï opo pï Yocepu; wie obino owil ökö ï kome. ");
INSERT INTO lth_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Kinge mwaka arïö, Parao rwoth më Ejip oleko lek nï ën onwongo ecung ï lak kulo më Nail. ");
INSERT INTO lth_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Cë dhok abïrö n'oluk ëka n'öcwëë odonyo gïnï yökö kï ï kulo ëka öcakö gïnï camö lum. ");
INSERT INTO lth_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Cë dhok abïrö nökënë n'ölübö körgï odonyo kï ï kulo më Nail na komgï rarac ëka omogere obino ocung gïnï ï nget dhok n'onwongo tye ï lak kulo. ");
INSERT INTO lth_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Cë dhok n'onwongo rarac ëka omogere öcamö dhok abïrö n'oluk ëka n'öcwëë ökö. Cë Parao öcakö coo ökö kï ï wang nïnö. ");
INSERT INTO lth_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ën dökï önïnö cë oleko lek më arïö mërë. Oleko nï ënënö wi kal abïrö na komgï yot ëka bër, öcëk nakun tye ka döngö ï kom tyën kal acël. ");
INSERT INTO lth_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Kinge manön, wi kal abïrö nökënë n'oner ödöngö na rarac ëka yamö na lyeth më oro onerogï ökö. ");
INSERT INTO lth_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Cë wi kal abïrö na rarac öcakö mwönyö wi kal na bëcö ökö. Parao ocoo kï ï wang nïnö cë onwongo nï eleko lek dökï. ");
INSERT INTO lth_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kodiko na pïny dong oru, cwinye onwongo ba yom, cë ömïö ën ooro köp më cwodo ajwogi ëka ëryëkö kïbëc më Ejip. Parao öcakö kobo nïgï lek mërë, ëntö ngat mörö ope n'onwongo twërö gönyö nïnë lek nön. ");
INSERT INTO lth_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Cë adit na löö poko köngö ölök okobo both Parao nï, “An tin dong apo ï kom balna. ");
INSERT INTO lth_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ï karë n'onwongo Parao cwinye öwang ï kom etic mërë, cë otweowa k'adit na löö tedo ogati ï öt k'adwong na löö kürö pïny. ");
INSERT INTO lth_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Cë ï nïnö mörö acël wan kïbëc ebino eleko lek ï kiwor acël, ëka lek acëlacël onwongo tyën köp mërë papath. ");
INSERT INTO lth_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Awobi mörö më Iburu onwongo tye ködwa ï buc. Ën onwongo obedo atic k'adit na kürö pïny. Wan ebino ekobo nïnë lekwa ëka ën obino ögönyö nïwa, nakun gönyö lek ka ngat acëlacël n'opore kï lek mërë. ");
INSERT INTO lth_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ëka kite na ën ögönyö kï lekwa, obino ocobere kömanön. An ebino ëdwöka ï dhö ticna, ëka adit na löö tedo ogati ebino ëngabö kome ï wi yath.” ");
INSERT INTO lth_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Parao öcakö oro më cwodo Yocepu, cë ekelo ën pïöpïö kï ï buc. Ëmïö ölyëlö wie, ölökö böng mërë ëka obino ï nyim Parao. ");
INSERT INTO lth_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Parao okobo both Yocepu nï, “An aleko lek ëka ngat mörö ope na twërö gönyö tyën köp mërë. Ëntö an awinyo köp ï komi nï in ka iwinyo lek ïtwërö gönyö tyën köp mërë.” ");
INSERT INTO lth_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yocepu ögamö dhö Parao nï, “Pathï an, ëntö Obanga bino mïö Parao agam na yomo cwinye.” ");
INSERT INTO lth_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Cë Parao okobo both Yocepu nï, “Ï lekna, an onwongo acung ï lak kulo më Nail, ");
INSERT INTO lth_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ëka dhok abïrö n'öcwëë na komgï oluk odonyo kï ï kulo ëka öcakö gïnï camö lum. ");
INSERT INTO lth_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kï körgï, dhok abïrö nökënë dökï odonyo kï ï kulo na komgï rarac, ëka n'omogere rwök. Koth dhok na rarac nön anaka yam bara anënö ï lobo më Ejip. ");
INSERT INTO lth_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Dhok n'onwongo omogere na komgï rarac, öcakö camö dhok abïrö n'öcakö donyo n'öcwëë na komgï oluk. ");
INSERT INTO lth_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ëntö kadï kinge na gïn dong öcamö dhok n'öcwëë nön, gin mörö ope na nyutho nï gïn öcamö dhok n'öcwëë nön ökö, pïën onwongo gïn pod omogere ëka komgï rarac calö kite n'onwongo gïn tye ködë cön. Na dong atyeko lek nön, cë acoo ökö kï ï wang nïnö. ");
INSERT INTO lth_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“An thon anënö wi kal abïrö n'ödöngö ï tyën kal acël n'öcëk na bër. ");
INSERT INTO lth_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kï körgï, anënö wi kal abïrö na reco, n'önwëng na yamö na lyeth më oro onero. ");
INSERT INTO lth_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Wi kal n'önwëng ömwönyö wi kal abïrö na bëcö ökö. Akobo lek ni both ajwogi, ëntö ngat mörö onwongo ope na twërö gönyö tyën köp mërë nïna.” ");
INSERT INTO lth_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Cë Yocepu okobo both Parao nï, “Lek ka Parao tye acël këkën. Obanga onyutho both Parao gin na ën cwök tïmö. ");
INSERT INTO lth_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Dhok abïrö na bëcö nyutho mwaka abïrö ëka wi kal abïrö na bëcö nyutho thon mwaka abïrö. Lek nön tyën köp mërë tye acël këkën. ");
INSERT INTO lth_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Dhok abïrö n'omogere na komgï rarac n'obino kï körgï, ëka wi kal abïrö na yamö na lyeth më oro onero nyutho mwaka abïrö më kec. ");
INSERT INTO lth_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Obedo kite na an akobo both Parao: Obanga otyeko nyutho both Parao ngö na ën ëcwök tïmö. ");
INSERT INTO lth_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Pï mwaka abïrö, cem bino cëk na büp ï lobo Ejip kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ëntö kinge manön, mwaka abïrö nökënë bino lübö na kec bino bedo na tye ïë, wi jïï bino wil ökö ï kom cem na yam öcëk nïgï ï Ejip. Ëka kec nön bino balö lobo rwök. ");
INSERT INTO lth_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Cem na büp n'onwongo öcëk ï lobo ba dökï ebino po ïë, pïën kec na bino lübö manön bino bedo na rac rwök. ");
INSERT INTO lth_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Lek ka Parao na ën oleko arïö nön nyutho nï Obanga ënë omoko köp nön ëka Obanga bino mïö cobere ï karë na cwöcwök. ");
INSERT INTO lth_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Dong pï manön, Parao myero örang dhanö mörö na ryëk na nïang ëk oketh ölöö lobo Ejip kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Parao myero oketh edite na löö lobo, ëk gïn öcök acël më abic më cem na bino cëk ï lobo Ejip pï mwaka abïrö na cem bino cëk na büp. ");
INSERT INTO lth_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Myero gïn öcök cem kïbëc ï mwaka na cem bino cëk ïë na büp, ëk ëgwök ï dere më kanö cem na tye ï thë löc ka Parao. ");
INSERT INTO lth_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Cem nön ebino gwökö pï loboni, më kürö mwaka abïrö na kec bino podho ï Ejip, ëk kür kec onek jö më lobo ni ökö.” ");
INSERT INTO lth_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Parao ëka edite mërë kïbëc önënö nï thama ni bër. ");
INSERT INTO lth_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Parao okobo both etic mërë nï, “Ëtwërö nwongo dhanö nökënë na cal kï dhanö ni, na tye kï cwiny k'Obanga?” ");
INSERT INTO lth_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Cë Parao okobo both Yocepu nï, “Kite na dong Obanga onyutho köp ni kïbëc bothi, ngat mörö ope na ryëk ëka na wie tio calö in. ");
INSERT INTO lth_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","In ënë ibino löönö öda ëka jöga kïbëc bino bedo ï thë löcni. An abino löönöni pï then na an atye ïë këkën.” ");
INSERT INTO lth_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Parao okobo both Yocepu nï, “An kobedini dong akethi më bedo alöc më Ejip kïbëc.” ");
INSERT INTO lth_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Cë Parao öwödhö agïth mërë n'eketho anyuth ïë kï ï nya cïngë ëka örëpö ï nya cïng Yocepu. Ën thon oruko Yocepu kï böng na mïmïla na bëcö ëka ömïö oruko nyör n'ëyübö kï gol ï ngute. ");
INSERT INTO lth_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Parao ömïö Yocepu öngwëcö kï gadigadi na calö alübkörë më arïö kï löc, nakun jïï kïbëc wöö kï redo ï nyime nï, “Rum cöngwu pïny!” Manön ënë kite n'eketho kï Yocepu më bedo alöc më lobo Ejip kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Cë Parao okobo both Yocepu nï, “An Parao, dhanö mörö ope na bino tingo cïngë onyo tyënë ï lobo Ejip kïbëc abonge twëröni.” ");
INSERT INTO lth_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Parao ömïö nyïng both Yocepu nï Japenat Panea ëka ömïö ën önyömö Acenat nyaka Potipera, n'onwongo obedo alamdhök më On, më bedo dhakö mërë. Cë Yocepu öcakö wowotha më rimo lobo Ejip kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yocepu onwongo dong tye kï mwaka pyer adek ï karë na ën dönyö ï tic ka Parao rwoth më Ejip. Ëka Yocepu öya ökö kï ï nyim Parao cë öcakö wowotha ï lobo më Ejip kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ï mwaka abïrö, cem obino öcëk na büp rwök. ");
INSERT INTO lth_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yocepu öcökö cem n'öcëk ï lobo Ejip pï mwaka abïrö nonu cë ökanö ï dërö më kanö cem na tye ï kabedo kïbëc ï peci. Ï pacö acëlacël, ën oketho cem n'öya kï ï pwothi kïbëc n'ögürö kany nön. ");
INSERT INTO lth_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yocepu ökanö cem na büp rwök ï dere më kanö cem, naka onwongo dong cal kï kwo na tye ï dhö nam, cë ömïö ën öwëkö pimo ökö pïën onwongo dwong rwök na ba römö pimere. ");
INSERT INTO lth_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Na mwaka më kec bara othuno, Yocepu onwongo dong tye k'ëthïnö awope arïö n'Acenat nyaka Potipera, alamdhök më On, önywölö. ");
INSERT INTO lth_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yocepu öcakö nyïng kaö mërë Manace nakun kobo nï, “Pïën Obanga ömïö wia owil ökö kï ï can-na ëka kï ï öt k'apapna kïbëc.” ");
INSERT INTO lth_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Athïn më arïö ën öcakö nyïngë Epraim, nakun kobo nï, “Pïën Obanga ömïa anywöl ï lobo na an anënö can ïë.” ");
INSERT INTO lth_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ï karë na mwaka abïrö më cem na büp dong ojik ï lobo Ejip, ");
INSERT INTO lth_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","cë mwaka abïrö më kec öcakërë, kite na Yocepu yam okobo ködë. Kec onwongo ömakö lobo kïbëc, ëntö ï lobo më Ejip kïbëc cem onwongo tye ïë. ");
INSERT INTO lth_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ï karë na dong cem othum ökö kï ï lobo Ejip kïbëc, jïï öcakö koko both Parao pï cem. Cë Parao okobo both jö më Ejip kïbëc nï, “Cïdh unu both Yocepu ëk ïtïm unu ngö na ën bino kobo niwu.” ");
INSERT INTO lth_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ï karë na kec onwongo örömö lobo kïbëc, Yocepu öyabö dere më kanö cem ëka öcakö cadhö cem both jö më Ejip, pïën kec onwongo dong tye na rac ï lobo Ejip kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Jö më lobo nökënë thon obino gïnï yo Ejip më wïlö cem kï both Yocepu pïën kec onwongo dong tye na rac rwök ï wi lobo thükül. ");
INSERT INTO lth_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ï karë na Jakob owinyo nï cem tye ï Ejip, ën okobo both awope mërë nï, “Pïngö ïnënërë unu anëna kenwu?” ");
INSERT INTO lth_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Cë ën okobo nï, “An awinyo nï cem tye ï Ejip. Cïdh unu yo kunön ëk ïwïl unu cem mörö pï onu ëk ëkwö ëka kür ëthöö.” ");
INSERT INTO lth_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Cë utmego ka Yocepu apar öcïdhö gïnï yo Ejip më wïlö cem. ");
INSERT INTO lth_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ëntö Jakob ba ooro Benjamin ömïn Yocepu ködgï, pïën ën onwongo tye kï lworo nï onyo gin mörö na rac römö tïmërë ï kome. ");
INSERT INTO lth_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Cë awope ka Jakob onwongo tye ï kin jö n'öcïdhö gïnï wïlö cem, pïën kec onwongo thon tye ï lobo më Kanaan. ");
INSERT INTO lth_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yocepu onwongo dong obedo alöc më lobo Ejip ëka ënë onwongo cadhö cem both jögë. Cë ï karë na utmego mërë othuno, gïn oryebere gïnï pïny ï nyime na terinyimgï gudo ngöm. ");
INSERT INTO lth_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ï karë na Yocepu önënö utmego mërë, ën ongeogï ëntö ötïmö na calö ën ebedo arok ëka ötwak ködgï kï gero nakun penyogï nï, “Un ïya kï kwene?” Gïn ögamö nï, “Wan ëya kï ï lobo Kanaan më bino wïlö cem.” ");
INSERT INTO lth_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Utmego ka Yocepu ba ongeo gïnï ën, ëntö Yocepu ongeogï. ");
INSERT INTO lth_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Cë ën opo ï lek mërë ï komgï ëka okobo nïgï nï, “Un ibedo ëröth pïny! Un ibino unu më nënö kanya ba etye ka gwökö kï ï lobowa.” ");
INSERT INTO lth_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Gïn ögamö nï, “Pe, adwongna, eticni obino më wïlö cem. ");
INSERT INTO lth_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Wan kïbëc ebedo awope ka dhanö acël. Eticni obedo jö na genere, pathï ëröth pïny.” ");
INSERT INTO lth_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yocepu okobo nïgï nï, “Pe, Un ibino unu më nënö kanya ba etye ka gwökö kï ï lobowa.” ");
INSERT INTO lth_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ëntö gïn ögamö nï, “Eticni onwongo tye utmego apar arïö, awope ka dhanö acël, na bedo ï lobo më Kanaan. Athïn na tïdï odong both apapwa, ëka acël dong ope.” ");
INSERT INTO lth_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yocepu okobo nïgï nï, “Obedo kite na an akobo niwu ködë: Un ibedo ëröth pïny! ");
INSERT INTO lth_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ëka man ënë kite n'ebino tëmöwu ködë: An akwongara kï nyïng Parao, un ba ibino wëkö kany naka ka wang n'ömïnwu na tïdï obino kany. ");
INSERT INTO lth_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Or unu ngat acël öcïdh ööm ömïnwu, un jö kïbëc ebino gwököwu ï buc, ëk köpwu ëtëm më nënö ka ikobo unu köp adyer. Cë ka ope, adyer ka Parao pod kwö, un ibedo ëröth pïny!” ");
INSERT INTO lth_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ëka ën okethogï kïbëc ï buc pï nïnö adek. ");
INSERT INTO lth_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ï nïnö më adek, Yocepu okobo nïgï nï, “An abedo ngat na lworo Obanga, tïm unu köman ëk ibed unu na kwö. ");
INSERT INTO lth_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ka un ibedo jö na genere, wëk unu ömïnwu acël odong kany ï buc ëk un kïbëc iter unu cem pacö pï jöwu na kec tye ka nekogï. ");
INSERT INTO lth_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ëntö myero ikel unu ömïnwu na tïdï yo botha, ëka ënïang ï köpwu ëk ömïï kür ïthöö unu.” Cë gïn ötïmö kite na ën okobo ködë. ");
INSERT INTO lth_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Gïn öcakö twak ï kin-gï kën-gï nï, “Adyer onu etye ka nwongo pwod pï ömïn onu. Onu ënënö pëkö n'onwongo ën tye ködë ï caa na ën dweko onu pï kwö mërë, ëntö onu ba ewinyo; ënë ömïö pwod ni tye ka bino ï kom onu.” ");
INSERT INTO lth_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben ögamö nï, “An ba akobo niwu ni kür ïtïm unu bal ï kome? Ëntö un ba iwinyo! Kobedini dong onu myero ëcül remo mërë.” ");
INSERT INTO lth_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Gïn ba ongeo ni Yocepu onwongo römö nïang ï köpgï, pïën onwongo ëgönyö köp mërë agönya. ");
INSERT INTO lth_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Cë Yocepu öya ökö ödönyö yökö kï bothgï ëka öcakö koko, cë odwogo cen bothgï ëka dök ötwak ködgï. Ën ömïö ëmakö Cimeon kï ï kin-gï ëka etweo ï nyimgï na gïn nënö. ");
INSERT INTO lth_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yocepu ömïö twërö nï ëpïk cem pong puku ka ngat acëlacël, ëdwök cïlïng ka ngat acëlacël ï puku mërë, ëka myero ëmïïgï gin mörö më acama ï yoo. Manön kïbëc ëtïmö nïgï. ");
INSERT INTO lth_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Gïn otweo cem ï nge kenegï ëka öcakö gïnï woth. ");
INSERT INTO lth_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ï karë na gïn othuno kanya gïn mïtö buto ïë, ngat acël kï ï kin-gï öyabö wi puku ëk ëkwany cem nï kana mërë, ën önënö cïlïng mërë ut ï puku ï wi cem. ");
INSERT INTO lth_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Cë okobo both utmego mërë nï, “Cïlïngna edwongo! Enene tye ï pukuna.” Ï caa na gïn owinyo, cwinygï opodho rwök nakun ngat acëlacël lökërë both awodhe na kome myël amyëla nakun kobo nï, “Ngö ene n'Obanga tye ka tïmö ï kom onu?” ");
INSERT INTO lth_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ï karë na gïn othuno both apapgï Jakob ï lobo më Kanaan, gïn okobo nïnë ngö n'ötïmërë kïbëc ï komgï nï, ");
INSERT INTO lth_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ëcwö n'obedo rwoth më Ejip ötwak ködwa kï gero ëka oterowa na calö jö na tye ka röthö pïny. ");
INSERT INTO lth_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ëntö wan ekobo nïnë nï, ‘Wan ebedo jö na genere, wan ba ebedo ëröth pïny. ");
INSERT INTO lth_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Onwongo wan etye utmego apar arïö, awope ka dhanö acël. Acël dong ope, ëka athïn na tïdï odong both apapwa ï lobo më Kanaan.’ ");
INSERT INTO lth_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Cë ëcwö n'obedo rwoth më lobo nön okobo nïwa nï, ‘Man ënë kite na an abino ngeo ka onyo un ibedo jö na genere: Wëk ömïnwu acël odong botha kany, ëk iter unu cem më könyö jö më pacöwu na kec tye ka nekogï. ");
INSERT INTO lth_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ëntö kel unu ömïnwu na tïdï yo botha, ëk ömïï an ange ka un ba ibedo ëröth pïny ëntö jö na genere. Cë abino mïö ömïnwu cen bothwu, ëka un ibino woth ï lobo ni abonge ayela mörö.’” ");
INSERT INTO lth_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ï karë na gïn öönyö cem kï ï pukigï, ngat acëlacël onwongo ocwe mërë më cïlïng n'eketho ï puku mërë. Ï karë na gïn ëka apapgï önënö ocwe kï cïlïng ïë, lworo ömakögï. ");
INSERT INTO lth_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Cë apapgï Jakob okobo nïgï nï, “Ïmïa unu arwenyo ëthïnöna ökö. Yocepu dong ope, Cimeon dong ope ëka kobedini dökï ïmïtö unu tero Benjamin. Man kïbëc can mërë bino podho ï koma!” ");
INSERT INTO lth_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Cë Reuben okobo both apap mërë nï, “Ibino neko ëthïnö awopena arïö ökö ka ba adwongo ën cen bothi kany. Wëk an agwök ën, ëka an abino dwongo ën cen bothi.” ");
INSERT INTO lth_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ëntö Jakob okobo nï, “Woda ba bino cïdhö kunön kodwu, pïën ömïn mërë dong öthöö ökö ëka ën këkën ënë dong odong. Ka gin mörö na rac bino tïmërë ï kome ï wothwu, cwer cwiny na un ibino mïöna bino nekona ökö.” ");
INSERT INTO lth_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kec onwongo pod tye na rac ï lobo Kanaan. ");
INSERT INTO lth_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ï karë na gïn otyeko camö cem n'onwongo ëwïlö kï ï Ejip ökö, apapgï okobo nïgï nï, “Dök unu yo Ejip ëk ïwïl unu cem mörö nïwa.” ");
INSERT INTO lth_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ëntö Yuda okobo nïnë nï, “Dhanö ca öcïköwa nï, ‘Ba ibino unu nënö wanga ka ömïnwu ope ï kinwu.’ ");
INSERT INTO lth_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ka onwongo ïrömö oro ömïnwa ködwa, wan ebino cïdhö më wïlö cem nini. ");
INSERT INTO lth_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ëntö ka ba ioro ën ködwa, wan ba ebino cïdhö, pïën dhanö ca okobo nïwa nï, ‘Ba ibino unu nënö wanga ka ömïnwu ope ï kinwu.’” ");
INSERT INTO lth_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Jakob ögamö nï, “Pïngö ikelo unu pëkö ni ï koma më kobo both dhanö nön nï itye unu k'ömïnwu nökënë?” ");
INSERT INTO lth_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Gïn ögamö nï, “Dhanö nön openyowa peny na pol na makö komwa ëka kï jö më pacöwa. Ën openyowa nï, ‘Apapwu pod kwö? Itye unu k'ömïnwu nökënë?’ Wan ëgamö peny mërë. Cë wan onwongo ëtwërö ngeo nïngö ka ën bino kobo nï, ‘Kel unu ömïnwu kany’?” ");
INSERT INTO lth_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Cë Yuda okobo both apap mërë Icarael nï, “Or awobi ni köda ëka wan ebino cïdhö ökö pïöpïö, ëk wan, in ëka ëthïnöwa ebed na kwö ëk kür ëthöö. ");
INSERT INTO lth_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","An kikoma abino gwökö ën; in ibino maköna ïë ka ba akelo ën bothi ï nyimi kany. Cë bal mërë bino bedo ï wia ï karë më kwöna kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kite na tye ködë, kono wan ba ëgalërë, kono wan dong ëcïdhö ëka edwogo wang kïrïö.” ");
INSERT INTO lth_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Cë apapgï Icarael okobo nïgï nï, “Ka onwongo twërë, cë tïm unu köman. Keth unu nyig yen mökö na bëcö na un ïyërö më lobowa kany ï pukiwu, ëka iter unu both dhanö nön calö mïc. Ter unu möö na kur na nönök ëka möö kic na nönök, odok yath kï müra ëka nyig yen mökö n'ëcamö. ");
INSERT INTO lth_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ter unu thon cïlïng na römö wïlö wïl wang arïö, pïën myero ïdwök unu cïlïng n'onwongo eketho ï wi pukiwu. Caa nökënë onwongo ba öthëna gïnï athëna. ");
INSERT INTO lth_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ter unu ömïnwu thon ëka ïdök unu pïöpïö both dhanö nön. ");
INSERT INTO lth_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ëka wëk Obanga Won Twër kïbëc ömïïwu kïca ï nyim dhanö nön ëk öwëk ömïnwu nökënë ca ëka Benjamin odwog cen kodwu. Na calö kï botha, ka abino rwenyo ëthïnöna, cë wëk obed nï kömanön.” ");
INSERT INTO lth_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Gïn öcakö yaa më woth nakun nwongo tero gïnï mïc ëka cïlïng na römö wïl wang arïö, kanya acël kï Benjamin. Öcïdhö gïnï naka yo Ejip ëka ocung gïnï ï nyim Yocepu. ");
INSERT INTO lth_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ï karë na Yocepu önënö Benjamin kanya acël kï utmego mërë, ën okobo both atic mërë na gwökö ödë nï, “Ter jö ni ï öda, ngöl lee ëka ïyüb cem, pïën gïn bino cem köda tin kiceng.” ");
INSERT INTO lth_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Atic ötïmö kite na Yocepu okobo nïnë ködë ëka oterogï ï öt ka Yocepu. ");
INSERT INTO lth_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Lworo ömakö utmego mërë rwök ï caa n'ekelogï ï öt ka Yocepu. Gïn öthamö nï, “Ekelo onu kany pï cïlïng n'onwongo eketho ï puki onu ï karë na onu ëcakö bino kany. Ënë ömïö ekelo onu ï öt ni, ëk enwong köp mörö ï kom onu, ëmak onu ëk ebed opii mërë ëka ëma kene onu ökö.” ");
INSERT INTO lth_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Cë gïn öcïdhö naka both atic na gwökö öt ka Yocepu ëka ötwak gïnï ködë kï ï dholokek nï, ");
INSERT INTO lth_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Öma adwong, wan ebino kany ï nïnö më acël më wïlö cem. ");
INSERT INTO lth_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ëntö ï kabedo na wan ëcïdhö ecung më buto ïë, ngat acëlacël öyabö puku mërë ëka onwongo wel cïlïng mërë kikokome ï wi puku mërë. Cë wan edwongo. ");
INSERT INTO lth_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Wan thon ekelo cïlïng nökënë ï kom manön më wïlö cem. Wan ba engeo nga ënë oketho cïlïngwa ï pukiwa.” ");
INSERT INTO lth_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Atic ka Yocepu ögamö nï, “Ayela ope, kür ibed unu kï lworo. Obangawu, n'obedo Obanga k'apapwu, ënë oketho cïlïngwu ï pukiwu. An abino agamö cïlïngwu.” Cë ën okelo Cimeon yökö yo bothgï. ");
INSERT INTO lth_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Atic na gwökö öt otero utmego ï öt ka Yocepu, ömïögï pii më lwökö tyën-gï ëka ömïö kenegï cem. ");
INSERT INTO lth_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Gïn öyübö mïcgï më mïö both Yocepu ka bino dwogo kiceng, pïën onwongo ekobo nïgï nï gïn bino cem kanya acël ködë. ");
INSERT INTO lth_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ï karë na Yocepu obino pacö, gïn ömïö ën mïc na gïn okelo ëka oryebere gïnï pïny ï nyime. ");
INSERT INTO lth_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ën openyogï kite na gïn tye ködë ëka dökï openyogï nï, “Apapwu na un ikobo nï otii tye nïngö? Ën pod tye na kwö?” ");
INSERT INTO lth_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Gïn ögamö nï, “Aticni apapwa pod kwö ëka tye na bër.” Ëka gïn oryebere pïny më nyutho wörö bothe. ");
INSERT INTO lth_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ï karë na Yocepu önënö ömïn mërë Benjamin, wod ka aya mërë kikokome, cë openyo nï, “Man ënë ömïnwu na tïdï na un ikobo nïna?” Cë ën okobo nï, “Ëk Obanga omii gum, woda.” ");
INSERT INTO lth_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yocepu ödönyö yökö pïöpïö, pïën cwinye onwongo myël ï kom ömïn mërë. Ën öcïdhö örangö kany mörö na myero ekok ïë. Cë ödönyö ï öt kabuto mërë ëka okok ïë. ");
INSERT INTO lth_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Kinge ën ölwökö wangë, odonyo yökö ëka ödïö cwinye cë okobo nï, “Wëk epok cem.” ");
INSERT INTO lth_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Epoko cem ï mëja mërë kënë, më utmego mërë ï mëjagï kën-gï. Jö Ejip na cemo ködë thon ï mëjagï kën-gï. Jö Ejip ba cemo kanya acël kï jö Iburu pïën manön obedo gin më kwer both jö Ejip. ");
INSERT INTO lth_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Utmego mërë obedo ï nyime na lübërë kit n'ënywölögï ködë, cakërë kï both kaö naka both athïn na tïdï; ëka ngat acëlacël obedo nënö awodhe kï ur. ");
INSERT INTO lth_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ï karë n'epoko nïgï cem kï ï mëja ka Yocepu, epoko më ka Benjamin na kadhö më ka jö nökënë kïbëc wang abic. Gïn ocemo ëka omedho gïnï abonge ayela mörö ködë. ");
INSERT INTO lth_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Kinge na karama othum, Yocepu öcïkö atic mërë na gwökö ödë nï, “Pïk cem opong puki ka jö nön na gïn twërö tingo, ëka iketh cïlïng ka ngat acëlacël ï dhö puku mërë. ");
INSERT INTO lth_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Cë iketh ekopo ryalna ï dhö puku k'awobi na tïdï, kanya acël kï cïlïng më wïlö cem mërë.” Ën ötïmö kite na Yocepu okobo nïnë ködë. ");
INSERT INTO lth_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kodiko mërë na pïny dong oru, ëmïögï öcïdhö kï yorgï yökö kanya acël kï kenegï. ");
INSERT INTO lth_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Gïn onwongo bara öcïdhö na bor kï ï pacö ï karë na Yocepu okobo both atic na gwökö jami mërë nï, “Lüb kör jö nön pïöpïö, ëka ka ïmakögï, cë ikob bothgï nï, ‘Pïngö un ïcülö gin na bër kï gin na rac? ");
INSERT INTO lth_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Pathï ekopo ni ënë adwongna modho ködë ëka thon tio ködë më thyeth? Un ïtïmö gin na rac rwök.’” ");
INSERT INTO lth_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ï karë n'atic ka Yocepu ömakögï ï yoo, ën önwö köp ni bothgï. ");
INSERT INTO lth_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Gïn okobo nïnë nï, “Adwongwa, ngö n'ömïö in ïtwakö koth köp nön? Wan ebedo eticni myero kür ëtïm koth tïm na calö manön! ");
INSERT INTO lth_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nën, cïlïng na wan enwongo ï dhö pukiwa, wan edwongo ökö bothi anaka kï ï lobo Kanaan. Cë pïngö wan myero ëkwal ryal onyo gol kï ï öt k'adwongni? ");
INSERT INTO lth_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ka ebino nwongo tye both ngat mörö kï ï kinwa, ëk ënë öthöö. Wan kïbëc ebino bedo opii k'adwongni.” ");
INSERT INTO lth_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ën ögamö nï, “Wëk unu obed nï kömanön kite na un ikobo ködë. Ngat n'ebino nwongo ekopo bothe ënë bino bedo opiina; jö nökënë ebino wëkögï cïdhö.” ");
INSERT INTO lth_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Cë ngat acëlacël öcakö cibo puku mërë pïny pïöpïö ëka öyabö dhögë. ");
INSERT INTO lth_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Cë atic ka Yocepu öcakö rangö ï puki cakërë kï both ngat na dit naka both ngat na tïdï. Ekopo ebino enwongo ï puku ka Benjamin. ");
INSERT INTO lth_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Utmego ka Yocepu öyëcö böng-gï pï cwer cwiny. Cë gïn kïbëc otweo yëcgï ï nge kenegï ëka ödök gïnï yo pacö. ");
INSERT INTO lth_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ï karë na Yuda ëka utmego mërë obino gïnï ï öt ka Yocepu, gïn onwongo ën pod tye kany nön, cë opodho gïnï pïny oryebere ï nyime. ");
INSERT INTO lth_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yocepu okobo bothgï nï, “Man ngö na un onwongo ïmïtö tïmö? Un ba ingeo unu nï dhanö na calö an twërö ngeo jami ni kï thyeth?” ");
INSERT INTO lth_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ëka Yuda okobo nï, “Onu ebino kobo ngö both adwongna? Ngö na onu ebino twakö? Onu ebino kwanyö bal kï kom onu nïngö? Obanga otyeko nwongo bal ï kom aticni. Wan dong ëdökö opii k'adwongna—onu ëka ngat n'enwongo okopo kï bothe.” ");
INSERT INTO lth_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ëntö Yocepu okobo nï, “An ba atwërö tïmö nï kömanön! Ëntö ngat n'enwongo ekopo bothe, ënë bino bedo opiina. Un jö nökënë kïbëc ïtwërö unu dök both apapwu kï kuc.” ");
INSERT INTO lth_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Cë Yuda öcïdhö bothe ëka okobo nïnë nï, “Akwai adwongna, ëk an atwak köp mörö kodi. Kür ïwëk akëmöni obed na lyeth ï koma, pïën in ïröm kï Parao kikokome. ");
INSERT INTO lth_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Adwongna openyo etic mërë nï, ‘Un itye k'apapwu, onyo ömïnwu nökënë?’ ");
INSERT INTO lth_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ëka wan ekobo both adwongna nï, ‘Wan etye k'apapwa na dong otii ëka ömïnwa na tïdï n'ënywölö ï karë n'apapwa onwongo dong otii ökö. Ömïn mërë öthöö ökö, ëka ën këkën ënë wod k'aya mërë n'odong, ëka apap mërë marö ën rwök.’ ");
INSERT INTO lth_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Cë in ikobo both eticni nï, ‘Kel unu botha, ëk anën ën kï wanga.’ ");
INSERT INTO lth_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Wan ekobo both adwongna nï, ‘Awobi ni ba twërö wëkö apap mërë. Ka ën öwëkö; apap mërë bino thöö ökö.’ ");
INSERT INTO lth_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ëntö in ikobo both eticni nï, ‘Ka ömïnwu na tïdï ba owotho kodwu kanya acël, un ba ibino nënö wanga dökï.’ ");
INSERT INTO lth_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ï karë na wan ëdök yo both aticni, apapna, wan ebino ekobo nïnë köp n'adwongna okobo. ");
INSERT INTO lth_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Cë apapwa okobo nï, ‘Dök unu yo Ejip ëk ïwïl unu cem mörö nïwa.’ ");
INSERT INTO lth_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ëntö wan ekobo nï, ‘Wan ba ebino cïdhö yo kunön. Ka ömïnwa na tïdï bino cïdhö ködwa, cë wan ebino cïdhö yo kunön, pïën wan ba ebino nënö wang dhanö ca, thwara ka ömïnwa na tïdï tye ï kinwa.’ ");
INSERT INTO lth_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Apapna okobo nïwa nï, ‘Un ingeo nï dhaköna önywölö ëthïnö awope arïö. ");
INSERT INTO lth_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Acël kï kin-gï öwëka ökö, cë an akobo nï, “Adyer lee na ger ökïdhö ën ökö na thïthïnö.” An ba dök anënö ën na twal. ");
INSERT INTO lth_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ka ïkwanyö unu man ökö kï botha, ëka gin na rac opodho ï kome, cë cwer cwiny na un ibino mïöna bino nekona ökö.’ ");
INSERT INTO lth_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Pï manön adwongna, an ba arömö dök both apapna abonge awobi ni. Kwö k'apapwa ocung ï kom kwö k'awobi ni. ");
INSERT INTO lth_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Ka ën önënö nï awobi ni ope ï kinwa, cwer cwiny bino mïö apapwa thöö ökö. ");
INSERT INTO lth_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Adwongna, an abino acïkara both apapna nï an abino gwökö awobi ni. An akobo nïnë nï, ‘Ka an ba abino dwongo ën bothi, cë bal mërë bino dwogo ï wia ï nyim apapna ï karë më kwöna kïbëc.’ ");
INSERT INTO lth_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Cë kobedini akwai nï ïtïm bër iye aticni odong kany na calö opii k'adwongna nakaka awobi ni, ëk ïmïï awobi ni ödök pacö kanya acël kï utmego mërë. ");
INSERT INTO lth_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","An atwërö dök both apapna nïngö ka awobi ni ba owotho köda? An ba amïtö nënö gin na rac ka podho ï kom apapna.” ");
INSERT INTO lth_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Cë Yocepu ba dök ödïö cwinye ï nyim etic mërë kïbëc n'onwongo ocung ï ngete, ëka oredo kï koko nï, “Mïï unu jö kïbëc öya öcïdh gïnï ökö kï botha!” Ngat mörö onwongo ope both Yocepu ï karë na ën nyuthere both utmego mërë. ");
INSERT INTO lth_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ëka ën oredo kï koko rwök naka jö më Ejip owinyo gïnï. Jö më öt ka Parao owinyo gïnï thon. ");
INSERT INTO lth_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yocepu okobo both utmego mërë nï, “An ënë Yocepu! Apapna pod tye na kwö?” Ëntö utmego mërë onwongo ba twërö gïnï gamö köp mërë, pïën onwongo tye gïnï kï lworo ï nyime. ");
INSERT INTO lth_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yocepu okobo both utmego mërë nï, “Bin unu na cwök botha.” Cë gïn obino na cwök bothe ëka okobo nïgï nï, “An ënë ömïnwu Yocepu, ngat na un yam ïcadhö ï Ejip! ");
INSERT INTO lth_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Kür dong ibed unu kï cwer cwiny, kür ïkëc unu ï komwu kenwu pï cadhöna kany, pïën Obanga ënë yam oora kany ï nyimwu ëk alar kwö ka jïï. ");
INSERT INTO lth_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Pï mwaka arïö n'opoth këc onwongo tye ï lobo, ëka pï mwaka abic na tye ka bino, pur kï kac ba bino bedo na tye. ");
INSERT INTO lth_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ëntö Obanga oora ï nyimwu ëk agwök jö na bino dong ï wi lobo, ëka më larö kwöwu kï yoo më aura ni. ");
INSERT INTO lth_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Pï manön, pathï un ënë iora unu kany, ëntö Obanga. Ën ömïö an adökö amïï thama ka Parao, adwong na löö ödë kïbëc ëka alöc më Ejip kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Kobedini dong dök unu both apapna ëka ikob unu nïnë nï, ‘Man ënë ngö na wodi Yocepu ököbö: Obanga ömïö abedo ngat na löö Ejip kïbëc. Bin botha kany; kür iru. ");
INSERT INTO lth_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","In ibino bedo ï lobo Gocen, ëka ibino bedo na cwök köda—in, ëthïnöni ëka ëkwaëni, romni ëka dhok, ëka jami kïbëc na in itye ködë. ");
INSERT INTO lth_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","An abino gwököni kï kunön pïën mwaka abic më kec pod odong anyim, ëk in kï jö më pacöni, ëka jö kïbëc na tye bothi kür onwong gïnï can.’” ");
INSERT INTO lth_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Cë Yocepu okobo nï, “In ëka ömëra Benjamin ïtwërö unu nënö kï wangwu nï an ënë atye ka twak kodwu. ");
INSERT INTO lth_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Myero un ikob both apapna wörö kïbëc n'eketho ï koma ï Ejip ëka gin na kïbëc na un ïnënö. Ëntö kel unu apapna kany pïöpïö.” ");
INSERT INTO lth_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Cë ën öthünö ngut ömïn mërë Benjamin ëka okok. Benjamin thon öthünö ngute ëka öcakö koko. ");
INSERT INTO lth_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Cë Yocepu önödhö lem utmego mërë kïbëc nakun kok. Kinge manön utmego mërë ötwak ködë. ");
INSERT INTO lth_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ï karë na köp owinyere ï pacö ka Parao nï utmego ka Yocepu obino gïnï, Parao ëka etic mërë obedo gïnï kï yom cwiny rwök. ");
INSERT INTO lth_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Parao okobo both Yocepu nï, “Kob both utmegoni nï, ‘Tïm unu ni köman: Twe unu yëc ï nge kenewu, ëka ïdök unu ï lobo Kanaan, ");
INSERT INTO lth_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ëk ikel unu apapwu kï jöwu obin gïnï botha. An abino mïöwu lobo na bër rwök na tye ï Ejip ëka ibino unu camö cem na bër na tye ï lobo.’ ");
INSERT INTO lth_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“In thon cïkgï nï, ‘Tïm unu nï köman: Ter unu gadigadi kï ï Ejip pï ëthïnöwu ëka monwu, ëk ikel unu apapwu obin. ");
INSERT INTO lth_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kür ïpar unu pï jamiwu, pïën gin na bëcö kïbëc më lobo Ejip bino bedo mewu.’” ");
INSERT INTO lth_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Awope ka Icarael ötïmö gïnï kite na ën okobo ködë. Yocepu ömïögï gadigadi kite na Parao öcïkö, ëka ömïögï jami na mïtërë më wothgï. ");
INSERT INTO lth_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ömïö both ngat acëlacël böng na nyen më aruka. Ëntö ömïö Benjamin böng na bëcö abic më alöka ëka cëkël më ryal mia adek. ");
INSERT INTO lth_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ën ooro n'apap mërë jami ni: Kene apar n'öyëö gïnï jami na bëcö më Ejip, kene na mon apar n'öyëö kal kï cem, ëka jami nökënë na mïtërë pï woth k'apapgï. ");
INSERT INTO lth_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Cë ën ömïö utmego mërë öcïdhö. Na gïn dong tye ka yaa, ën okobo nïgï nï, “Kür ibed unu ka dha ï yoo.” ");
INSERT INTO lth_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Cë gïn öya ökö kï ï Ejip, cë odwogo gïnï ï lobo Kanaan both apapgï Jakob. ");
INSERT INTO lth_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Gïn ököbö bothe nï, “Yocepu pod tye na kwö, ëka ënë obedo alöc më Ejip kïbëc.” Cë twak ölöö Jakob ökö pïën ba oye ngö na ën owinyo. ");
INSERT INTO lth_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ëntö ï karë n'ekobo nïnë gin na kïbëc na Yocepu okobo, ëka na ën önënö gadigadi gïnï na Yocepu ömïö më tingo ën, cë tipo kom apapgï Jakob öcakö dwogo. ");
INSERT INTO lth_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Cë Jakob okobo nï, “Adyer an dong aye! Woda Yocepu pod tye na kwö. An abino cïdhö më nënö ën na pod bara athöö.” ");
INSERT INTO lth_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Cë Icarael öcakö woth kï jami mërë kïbëc. Ï karë na ën othuno ï Beerceba, ën ömïö tyër awanga both Obanga k'apap mërë Icaka. ");
INSERT INTO lth_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Obanga ötwak kï Icarael ï wang lek ï kiwor nakun kobo nï, “Jakob, Jakob!” Ën ögamö nï, “An enene!” ");
INSERT INTO lth_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Obanga okobo nï, “An Obanga, Obanga k'apapni, kür ilwor cïdhö yo Ejip, pïën an abino mïöni ïdökö rok na dit kï kunön. ");
INSERT INTO lth_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","An abino cïdhö kodi naka ï Ejip, ëka an abino dwököni cen dökï. Cë Yocepu bino önyö ngöm ï wii.” ");
INSERT INTO lth_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Cë Jakob öcakö woth kï ï Beerceba, ëka awope mërë otero apapgï, ëthïnögï ëka mon-gï ï gadigadi na Parao ooro më tero ën. ");
INSERT INTO lth_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Gïn otero leenigï kï jami na gïn onwongo kï ï lobo Kanaan. Jakob ëka ëthïnö mërë kïbëc öcïdhö gïnï yo Ejip. ");
INSERT INTO lth_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ën öcïdhö ï Ejip k'awope mërë ëka anyira mërë—k'ëkwaë mërë kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Man ënë nyïng awope ka Icarael (Jakob ëka ëkwaë mërë) n'öcïdhö gïnï yo Ejip: Reuben athïn kaö ka Jakob. ");
INSERT INTO lth_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Awope ka Reuben gïn ene: Kanok, Pallu, Kejeron ëka Karmi. ");
INSERT INTO lth_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Awope ka Cimeon gïn ene: Jemuel, Jamin, Okad, Jakin, Jokar ëka Caul (n'obedo wod ka dhakö më Kanaan). ");
INSERT INTO lth_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Awope ka Lebi gïn ene: Gercon, Kokat ëka Merari. ");
INSERT INTO lth_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Awope ka Yuda gïn ene: Er, Onan, Cela, Perej ëka Jera (ëntö Er ëka Onan obino öthöö gïnï ökö ï lobo Kanaan). Awope ka Perej gïn ene: Kejeron ëka Kamul. ");
INSERT INTO lth_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Awope ka Icakar gïn ene: Tola, Puwa, Jacub ëka Cimron. ");
INSERT INTO lth_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Awope ka Jabulon gïn ene: Cered, Elon ëka Jaleel. ");
INSERT INTO lth_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Man ënë onwongo awope ka Lea na ën önywölö kï Jakob ï Paddan Aram, kanya acël kï nyarë Dina. Awope ëka anyira mërë kïbëc onwongo tye pyer adek wie adek. ");
INSERT INTO lth_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Awope ka Gad gïn ene: Jipon, Kagi, Cuni, Ejibon, Eri, Arodi ëka Areli. ");
INSERT INTO lth_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Awope ka Acer gïn ene: Imna, Iciba, Icibi ëka Beria. Amïn-gï onwongo nyïngë Cera. Awope ka Beria gïn ene: Keber ëka Malkiel. ");
INSERT INTO lth_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Man ënë onwongo awope ka Jilpa na ën önywölö kï Jakob, na Laban ömïö both nyarë Lea. Ën önywölö ëthïnö apar abicël kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Awope ka Racel dhakö ka Jakob gïn ene: Yocepu ëka Benjamin. ");
INSERT INTO lth_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ï lobo Ejip, Yocepu önywölö Manace ëka Epraim kï Acenat, nyaka Potipera alamdhök më On. ");
INSERT INTO lth_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Awope ka Benjamin gïn ene: Bela, Beker, Acibel, Gera, Naaman, Eki, Roc, Mupim, Kupim ëka Arud. ");
INSERT INTO lth_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Man ënë awope apar angwën kïbëc na Racel onwongo önywölö kï Jakob. ");
INSERT INTO lth_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Wod ka Dan ene: Kucim. ");
INSERT INTO lth_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Awope ka Naputali gïn ene: Jajeel, Guni, Jejer ëka Cilem. ");
INSERT INTO lth_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Man ënë onwongo awope ka Bila na Laban ömïö both nyarë Racel. Ën önywölö kï Jakob ëthïnö abïrö kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jö kïbëc n'öcïdhö kï Jakob yo Ejip n'onwongo obedo ëkwaë mërë kikokome, na ba ëkwanö mon k'awope mërë, onwongo tye pyer abicël wie abicël. ");
INSERT INTO lth_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ka ëkwanö awope arïö na Yocepu onwongo önywölö ï Ejip, wel jö më öt ka Jakob n'öcïdhö gïnï yo Ejip onwongo tye pyer abïrö kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jakob ooro Yuda më cïdhö anyim nïnë both Yocepu ëk onyuth nïnë yoo na cïdhö yo Gocen. Ï karë na gïn othuno ï lobo më Gocen, ");
INSERT INTO lth_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yocepu onwongo öyübö gadigadi mërë më cïdhö romo k'apap mërë Icarael ï Gocen. Ï karë na Yocepu othuno bothe, ën öthünö ngut apap mërë ëka okok pï caa na lac. ");
INSERT INTO lth_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Icarael okobo both Yocepu nï, “An dong atwërö thöö, pïën dong anënö wangi ëka anïang nï in pod ïkwö.” ");
INSERT INTO lth_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Cë Yocepu okobo both utmego mërë ëka jö më öt k'apap mërë nï, “An abino cïdhö both Parao ëk akob nïnë nï, ‘Utmegona ëka jö më öt k'apapna n'onwongo bedo gïnï ï lobo Kanaan obino gïnï botha. ");
INSERT INTO lth_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Jö ni obedo gïnï ëkwath ëka gwökö gïnï leeni. Gïn okelo rom kï dyegi ëka dhok kï gin na kïbëc na gïn tye ködë.’ ");
INSERT INTO lth_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ka Parao ocwodowu ëka openyowu nï, ‘Tic ngö na un itio?’ ");
INSERT INTO lth_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Un myero ïgam nï, ‘Wan eticni ebedo ëkwath cakërë ï karë më thinowa thuno ködë naka tin, kite na kwerewa onwongo tïmö ködë.’ Cë ebino yeo niwu më bedo ï lobo më Gocen, pïën ëkwath kïbëc obedo gïnï gin më kwer both jö më Ejip.” ");
INSERT INTO lth_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yocepu öcïdhö ëka okobo both Parao nï, “Apapna ëka utmegona obino gïnï kï ï lobo më Kanaan kï rom kï dyegigï ëka dhok kï jamigï kïbëc na gïn tye ködë. Kobedini dong gïn tye ï lobo më Gocen.” ");
INSERT INTO lth_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ën öyërö utmego mërë abic ëka onyuthogï both Parao. ");
INSERT INTO lth_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Parao openyo utmego ka Yocepu nï, “Tic ngö na un itio?” Gïn okobo both Parao nï, “Wan, eticni, ebedo ëkwath kite na kwerewa onwongo obedo ködë.” ");
INSERT INTO lth_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Gïn thon okobo both Parao nï, “Wan ebino më bedo kany pï karë na nönök, pïën kec tye na rac rwök ï Kanaan ëka lum ope pï rom k'eticni. Kobedini dong wan ëkwaö nï ïmïï eticni obed gïnï ï lobo më Gocen.” ");
INSERT INTO lth_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Parao okobo both Yocepu nï, “Apapni ëka utmegoni obino gïnï bothi. ");
INSERT INTO lth_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Lobo Ejip tye ï cingi; keth apapni ëka utmegoni ï lobo na bër. Mïïgï obed ï lobo Gocen, ëka ka ingeo jö mörö kï kin-gï na ryëk, cë ikethgï më bedo jö na löö leenina.” ");
INSERT INTO lth_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Cë Yocepu okelo apap mërë Jakob ëka onyutho ën ï nyim Parao. Kinge Jakob ölamö gum ï kom Parao. ");
INSERT INTO lth_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Parao openyo ën nï, “In itye kï mwaka adi?” ");
INSERT INTO lth_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ëka Jakob okobo both Parao nï, “An dong akwö ï wi lobo pï mwaka mia acël kï pyer adek. Ëntö mwaka më wowothana obedo na nönök ëka opong kï pëkö; mwaka më kwöna ba röm kï mwaka më wowotha ka kwerena.” ");
INSERT INTO lth_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Cë Jakob ölamö gum ï kom Parao dökï, ëka öya ökö kï ï nyime. ");
INSERT INTO lth_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Cë Yocepu ömïö apap mërë ëka utmego mërë kabedo ï lobo Ejip ëka ömïögï jami ï ngöm na bër na tye ï Ramecec, kite na Parao okobo nïnë ködë. ");
INSERT INTO lth_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yocepu thon opoko cem both apap mërë ëka utmego mërë kï jö kïbëc më öt k'apap mërë, nakun lübö wel ëthïnögï. ");
INSERT INTO lth_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ï karë nön cem onwongo ope ï lobo kïbëc pïën kec onwongo rac rwök; jö më lobo Ejip kï jö më lobo Kanaan ödökö gïnï na görü pï kec n'ödïögï. ");
INSERT INTO lth_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yocepu öcökö cïlïng kïbëc n'onwongo tye ï lobo Ejip ëka Kanaan më cülö cem n'onwongo gïn wïlö ëka okelo ï pacö ka Parao. ");
INSERT INTO lth_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ï karë na cïlïng ka jö më Ejip ëka Kanaan dong othum, jö Ejip kïbëc öcïdhö gïnï both Yocepu ëka okobo gïnï nï, “Mïïwa cem, pïngö in ïmïtö nï wan ëthöö ï wangi? Cïlïngwa dong othum ökö.” ");
INSERT INTO lth_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Cë Yocepu ögamö nï, “Kel unu leeniwu, an abino cadhö niwu cem nakun alökö kï leeniwu, kite na dong cïlïngwu othum ökö.” ");
INSERT INTO lth_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Cë gïn okelo leenigï both Yocepu. Ën ömïögï cem nakun ëlökö k'angolegï, romgï, dyegigï, dhokgï, ëka kenegï. Ën ömïögï cem pï mwaka nön nakun ëlökö kï leenigï kïbëc. ");
INSERT INTO lth_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kinge na mwaka nön othum, gïn obino both Yocepu ï mwaka nökënë ëka okobo gïnï nï, “Wan ba ëtwërö kanö köp mörö kï bothi adwongwa, kite na cïlïngwa dong othum ökö kïbëc ëka leeniwa obedo megi. Gin mörö ope n'odong pï adwongwa na path kï komwa ëka ngömwa. ");
INSERT INTO lth_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pïngö ïmïtö nï wan ëthöö ï wangi na in ïnënö, wan kanya acël kï ngömwa? In ïwïlwa ökö kanya acël kï ngömwa nakun ïlökö kï cem, ëk wan ëka ngömwa ebed opii ka Parao. Mïïwa kodhi ëk ebed na kwö kür ëthöö ëka ngöm kür odong nono.” ");
INSERT INTO lth_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Pï manön Yocepu öwïlö lobo kïbëc më Ejip pï Parao. Jö Ejip kïbëc öcadhö gïnï pwothigï ökö pïën kec onwongo rac rwök bothgï. Cë lobo ödökö më ka Parao. ");
INSERT INTO lth_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yocepu ömïö jö kïbëc ödökö opii cakërë kï ajiki lobo më Ejip kucël, naka othuno ködë yo kucël. ");
INSERT INTO lth_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ëntö ën ba öwïlö lobo k'ëlamdhök pïën gïn onwongo nwongo cemgï kï both Parao. Manön ënë ömïögï ba öcadhö ngömgï. ");
INSERT INTO lth_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yocepu okobo both lwak nï, “Kobedini dong kite na an dong awïlöwu ëka ngömwu pï Parao, kodhi dong ene. Gam unu ëk ipur unu. ");
INSERT INTO lth_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ëntö ka ïcökö unu cem, mïï unu acël më abic both Parao. Angwën më abic bino bedo mewu më kodhi më apura ëka më acamawu kanya acël kï jö më udiwu.” ");
INSERT INTO lth_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Gïn okobo nï, “In ïlarö kwöwa, adwong, ëk ebed kï cwiny na bër ï nyimi. Wan ebino bedo opii ka Parao.” ");
INSERT INTO lth_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Cë Yocepu oketho n'obedo cïk na makö ngöm ï lobo Ejip—naka tin pod tye—nï acël më abic më cem, obedo më ka Parao. Ngöm k'ëlamdhök këkën ënë ba ödökö më ka Parao. ");
INSERT INTO lth_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Jö Icarael obedo gïnï ï Ejip, ï lobo më Gocen. Gïn onwongo jami kï kunön, önywöl gïnï ëka welgï ömëdërë na pol rwök. ");
INSERT INTO lth_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakob obedo ï lobo më Ejip pï mwaka apar abïrö, ëka mwaka më kwö mërë onwongo mia acël kï pyer angwën wie abïrö. ");
INSERT INTO lth_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Na karë më thöö ka Jakob onyingo na cwök, ën ocwodo wode Yocepu, ëka okobo nïnë nï, “Ka an atye kï cwiny na bër ï nyimi, cë iketh cingi, ï kin ema ëka icikiri nï in ibino nyutho nïna kïca ëka gen-ni. Kür iika ï lobo Ejip, ");
INSERT INTO lth_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ëntö an amïtö nï eika kanya kwerena tye ïë; tinga ökö kï ï Ejip, cë iika ï kabedo n'eikogï ïë.” Yocepu okobo nï, “An abino tïmö kite na in ikobo ködë.” ");
INSERT INTO lth_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jakob okobo nï, “Kwongiri botha nï in ibino tïmö nï kömanön.” Cë Yocepu okwongere bothe ëka Jakob okulo wie pïny ï wi kabuto mërë. ");
INSERT INTO lth_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kinge karë mörö ekobo both Yocepu nï, “Apapni two.” Cë ën otero awope mërë arïö, Manace ëka Epraim. ");
INSERT INTO lth_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ï karë n'ekobo both Jakob nï, “Wodi Yocepu obino bothi,” Icarael öcükërë öya malö ëka obedo ï wi kabuto mërë. ");
INSERT INTO lth_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakob okobo both Yocepu nï, “Obanga Won Twër kïbëc onen botha ï Luj ï lobo Kanaan, ëka kï kunön ën ömïa gum. ");
INSERT INTO lth_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ën okobo nïna nï, ‘An abino mïöni ïnya ëka abino mëdö welwu. An abino mïöni ïdökö rok ka jö na pol, ëka an abino mïö lobo ni both ëkwaëni na bino lüböni më bedo mëgï na twal.’ ");
INSERT INTO lth_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Ëka kobedini, awopeni arïö na in ïnywölögï ï lobo Ejip n'onwongo bara abino bothi kany, ebino cwodogï nï mëga. Epraim ëka Manace bino bedo mëga kite na Reuben ëka Cimeon obedo gïnï mëga. ");
INSERT INTO lth_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ëthïnö mörö këkën n'ebino nywölögï kï körgï ebino cwodogï nï megi; ebino kwanögï kï nyïng utmegogï ï karë na gïn poko lobo më alea. ");
INSERT INTO lth_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ï karë n'onwongo an atye ka dwogo kï ï Paddan, gin n'ocwero cwinya ënë nï ayani Racel öthöö nïna ökö ï lobo Kanaan na pod etye ï yoo, n'onwongo dong acwök kï Eparata. Cë aiko ën kunön ï nget yoo na cïdhö yo Eparata” (manön ënë Bethelem). ");
INSERT INTO lth_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ï karë na Icarael önënö awope ka Yocepu, ën openyo nï, “Man jö mënë?” ");
INSERT INTO lth_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yocepu okobo n'apap mërë nï, “Gïn ënë awopena n'Obanga ömïa kï kany.” Cë Icarael okobo nï, “Kelgï botha kany, ëk alam gum ï komgï.” ");
INSERT INTO lth_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ï karë nön Jakob onwongo ba dökï nënö pïny na bër pïën onwongo dong otii. Cë Yocepu okelo awope mërë na cwök bothe cë önödhö lemgï ëka öthünögï. ");
INSERT INTO lth_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Jakob okobo both Yocepu nï, “Onwongo athamö nï ba dök abino nënö wangi, ëka kobedini Obanga ömïa anënö ëthïnöni thon.” ");
INSERT INTO lth_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Cë Yocepu ökwanyögï kï ï cöng apap mërë Icarael ëka oryebere pïny cë okulo wie ï ngöm. ");
INSERT INTO lth_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yocepu otero gïn kïbëc, Epraim ï cïngë kucem n'okemo cïng Icarael kucam, ëka Manace ï cïngë kucam n'okemo cïng Icarael kucem, ëka okelogï na cwök bothe. ");
INSERT INTO lth_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ëntö Icarael olyao cïngë kucem ëka oketho ï wi Epraim, n'obedo athïn na tïdï, ëka olyao cïngë kucam arii cë oketho ï wi Manace n'obedo kaö. ");
INSERT INTO lth_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Cë ölamö gum ï kom Yocepu ëka okobo nï, “Ëk Obanga na kwaröwa Abraam ëka Icaka obedo gïnï ka lübö cïk mërë, Obanga n'onwongo obedo akwathna ï kwöna kïbëc naka tin, ");
INSERT INTO lth_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","malaika n'ölara kï kom gin na rac —ömïï gum both awope ni. Ëk ecwodgï kï nyïnga, ëka kï nyïng kwaröwa Abraam ëka Icaka, ëka gïn myero ömëdërë na pol rwök ï wi lobo.” ");
INSERT INTO lth_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ï karë na Yocepu önënö nï apap mërë oketho cïngë kucem ï wi Epraim, cwinye ba obedo na yom. Cë ökwanyö cïng apap mërë ökö kï ï wi Epraim ëka oketho ï wi Manace. ");
INSERT INTO lth_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yocepu okobo nïnë nï, “Pathï nï kömanön apapna, man ënë obedo kaö; keth cingi kucem ï wie.” ");
INSERT INTO lth_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ëntö apap mërë ökwërö ökö ëka okobo nï, “An angeo, woda, an angeo. Ën thon bino bedo rok, ëka ën thon bino bedo na dit. Ëntö ömïn mërë na tïdï bino bedo na dit na löö ën, ëkwaë mërë bino dökö rok na pol.” ");
INSERT INTO lth_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ölamö gum ï komgï ï nïnö nön, nakun kobo nï, “Jö Icarael bino lamö gum kï nyingi nï, ‘Ëk Obanga omii ibed calö Epraim ëka Manace.’ ” Cë Jakob oketho nyïng Epraim ï nyim nyïng Manace. ");
INSERT INTO lth_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Cë Icarael okobo both Yocepu nï, “An dong acwök thöö, ëntö Obanga bino bedo kodwu, ëka ën bino dwököwu ï lobo ka kwerewu. ");
INSERT INTO lth_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Na calö ngat acël na löö utmegoni, an amïö bothi kor kidi na an amaö kï both jö Amor kï pala abadë ëka atumna.” ");
INSERT INTO lth_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Cë Jakob ocwodo awope mërë ëka okobo nï, “Cökërë unu kanya acël, ëk akob niwu ngö na bino tïmërë ï komwu ï karë më anyim. ");
INSERT INTO lth_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Gürë unu ëka iwiny unu, un awope ka Jakob; winy unu apapwu Icarael. ");
INSERT INTO lth_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reuben, in ënë ibedo athïn kaöna, tëköna, ëka acaki tëkö koma, in ënë ïlöö kï wörö, ëka kï tëkö kom. ");
INSERT INTO lth_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","In ïcal kï pii na kelo bal, ëka ba ibino döngö, pïën in ibuto ï kabuto k'apapni, ibedo kï dhaköna ëka ilino kabutona. ");
INSERT INTO lth_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Cimeon ëka Lebi obedo gïnï utmego— pala abadëgï ënë obedo jami më lwëny. ");
INSERT INTO lth_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ba abino bedo ï athukogï, ëk an kür arïbara ï athukogï, pïën oneko gïnï jïï k'akëmögï, ëka otongo gïnï odon thwoni kite na ïgï mïtö. ");
INSERT INTO lth_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Myero cen obed ï kom akëmögï, pïën ger, ëka akëmögï, gwaü rwök! An abino këthö ëkwaëgï ï kin jö ka Jakob ëka abino këthögï ökö kï ï Icarael. ");
INSERT INTO lth_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda, utmegoni bino paköni; cingi bino makö ngut langni; awope k'apapni bino ryebere gïnï pïny ï nyimi. ");
INSERT INTO lth_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, in ïcal k'athïn kibwor, ïya kï mwodo lee, athïn-na. Calö kibwor n'önywöngö ëka obuto pïny, calö mïn kibwor—nga na twërö ero ën? ");
INSERT INTO lth_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Lüth më löc ba bino yaa kï both Yuda, onyo lüth k'alöc ba bino yaa kï kin tyënë, naka ka won mërë obino, ëka rok kïbëc bino wörö ën. ");
INSERT INTO lth_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ën bino tweno kana mërë ï kom yath ölök, ëka athïn kana ï kom jang ölök n'ëyërö; ën bino lwökö böng mërë ï kom köngö ölök, böng mërë ï köngö ölök na kwar. ");
INSERT INTO lth_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Wangë bino bedo na cöl na löö köngö ölök, lakë bino bedo na tar na löö cak. ");
INSERT INTO lth_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Jabulon bino bedo ï dhö nam, ëka ën bino bedo ka cungo ka mel, wang lobo mërë bino mëdërë yo Cidon. ");
INSERT INTO lth_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Icakar cal kï kana na tëk, buto pïny ï dyere aditi më yëc. ");
INSERT INTO lth_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ka ën önënö kite na ka yweo mërë bër, ëka kï kite na lobo mërë yomo cwinye, ën bino lökö ngee ï kom yëc na pëk ëka dökö opii ï kom tic na tëk. ");
INSERT INTO lth_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan bino ngölö köp n'atïr pï jögë na calö kaka acël më Icarael. ");
INSERT INTO lth_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan cal kï thwol na tye ï nget gudo, ororo na tye ï nget yoo, na tongo opuny angole gïnï, cë mïö ngat na ngwëcö ködë podho pïny. ");
INSERT INTO lth_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“An akürö lar na megi, Aa Rwoth. ");
INSERT INTO lth_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Ëyak bino yakö Gad, ëntö ën bino lökërë ëka ryëmö körgï. ");
INSERT INTO lth_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Cem ka Acer bino cëk na bër; ën bino mïö cem na mït n'opore pï rwoth. ");
INSERT INTO lth_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naputali cal kï lee thim na ngwëcö abonge gin mörö na jükö, na ïë opong kï köp na bëcö. ");
INSERT INTO lth_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yocepu obedo jang ölök na nyak, jang ölök na cwök kï wang pii, na jangë ïdhö kor öt malö. ");
INSERT INTO lth_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Lang bino lwëny ï kome, gïn bino celo ën ëka ëlwënyö ï kome. ");
INSERT INTO lth_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ëntö atum mërë bino cung na ba yengere, cïngë ödökö na tëk, pïën pï cïng ngat na Thwönë ka Jakob, pïën pï Akwath, Kidi më Icarael, ");
INSERT INTO lth_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","pïën pï Obanga k'apapni na konyi, pïën pï gum na Won Twër ënë mii, kï gum na yaa kï malö ï polo, gum na yaa kï kanya thut na tye pïny, gum më thuno ëka ïc. ");
INSERT INTO lth_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Gum k'apapni löö gum ka kite na bedo na twal, nakaka mwaka më kite na pol. Ëk man kïbëc obed ï wi Yocepu, ï kom terinyime, n'obino ödökö atëla ka utmego mërë. ");
INSERT INTO lth_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin cal k'orudi na ger, ën camö lee n'oneko kodiko, kothyeno ën poko gin na ën öyakö.” ");
INSERT INTO lth_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Man ënë kaka apar arïö më Icarael. Man ënë köp n'apapgi okobo bothgï ï karë na ën lamö gum ï komgï. Ën ölamö gum n'opore both ngat acëlacël. ");
INSERT INTO lth_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Cë ën ömïögï cïk ni: “An dong acwök cïdhö ökö both jöga. Iika unu kï kwerena ï öd rwo na tye ï pwodho ka Epron dhanö më Kit. ");
INSERT INTO lth_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Rwo na tye ï pwodho më Makpela, na cwök kï Mamre ï Kanaan, n'Abraam öwïlö më bedo ngöm më ik kï both Epron dhanö më Kit, kanya acël kï pwodho. ");
INSERT INTO lth_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Kunön ënë eiko Abraam kï dhakö mërë Cara, ëka Icaka kï dhakö mërë Rebeka ïë. Kany nön ënë an thon aiko Lea ïë. ");
INSERT INTO lth_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Pwodho ëka kï rwo na tye ïë onwongo ëwïlö kï both jö Kit.” ");
INSERT INTO lth_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ï karë na Jakob otyeko cïkö awope mërë, ën ödölö tyënë malö ï wi kabuto, cë öthöö ëka ödök both jögë. ");
INSERT INTO lth_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Cë Yocepu opodho ï kom apap mërë, okok ëka önödhö leme. ");
INSERT INTO lth_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Cë Yocepu okobo both etic mërë n'obedo daktae më wiro kom apap mërë kï yath ëk kür öbal, cë daktae owiro kom Icarael. ");
INSERT INTO lth_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Gïn otyeko nïnö pyer angwën, pïën manön ënë nïnö na mïtërë pï wiro kom dhanö kï yath më talö kome. Jö Ejip okoko gïnï Jakob pï nïnö pyer abïrö. ");
INSERT INTO lth_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ï karë na nïnö më kwero cöla opoth ökö, Yocepu okobo both edite ka Parao nï, “Ka itye unu kï cwiny na bër ï koma, twak unu both Parao na kakara. Kob unu nïnë nï, ");
INSERT INTO lth_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Apapna ömïa akwongo kwong ëka okobo nï, “An dong acwök thöö. Ter koma ï lobo Kanaan ëka iika ï bur lyël na an akünyö pï lyëna.” Kobedini dong ëk acïdh aik apapna; cë an abino dwogo.’ ” ");
INSERT INTO lth_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Parao okobo nï, “Cïdh iik apapni, kite na ën omii ikwongo kwong.” ");
INSERT INTO lth_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Cë Yocepu öcïdhö më iko apap mërë. Edite ka Parao kïbëc owotho ködë—edite më öd pido ëka edite kïbëc më lobo Ejip— ");
INSERT INTO lth_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","kanya acël kï jö kïbëc më öt ka Yocepu, utmego mërë ëka jö më öt k'apap mërë. Ëntö öwëkö gïnï ëthïnögï këkën, rom kï dyegi ëka dhok ï lobo më Gocen. ");
INSERT INTO lth_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Yocepu öcïdhö kï gadigadi ëka wegi angole. Ën owotho kï jö na pol rwök. ");
INSERT INTO lth_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ï karë na gïn othuno ï larü moo më Atad, na tye na cwök yo löka Jordan, cë gïn okok kunön kï cwer cwiny ëka kï kumo na thwönë. Yocepu okwero cöla k'apap mërë pï nïnö abïrö. ");
INSERT INTO lth_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ï karë na jö Kanaan n'onwongo bedo gïnï ï lobo nön önënögï kwero cöla ï larü moo më Atad, gïn okobo nï, “Man ënë kwero cöla më cwer cwiny na thwönë rwök both jö Ejip.” Manön ënë ömïö kabedo nön na cwök kï Jordan ecwodo nï, Abel Micraim. ");
INSERT INTO lth_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Cë awope ka Jakob obino ötïmö gïnï kite n'ëcïkögï ködë. ");
INSERT INTO lth_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Gïn otingo lyënë yo lobo Kanaan, ëka eiko ï öd rwo na tye ï pwodho më Makpela, na cwök kï Mamre, n'Abraam onwongo öwïlö na calö kabedo më ik kï both Epron dhanö më Kit kanya acël kï pwodho. ");
INSERT INTO lth_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Kinge iko apap mërë, Yocepu ödök yo Ejip kanya acël kï utmego mërë, ëka kï jö nökënë kïbëc na ën onwongo öcïdhö ködgï më iko apap mërë. ");
INSERT INTO lth_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ï karë na utmego ka Yocepu önënö gïnï nï apapgï dong öthöö ökö, gïn okobo nï, “Gwök onyo Yocepu bino kelo köp mörö ï kom onu, ëka cülö kwor pï gin na rac kïbëc na onu ëtïmö ï kome.” ");
INSERT INTO lth_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Cë gïn ooro dwön-gï both Yocepu nakun kobo gïnï nï, “Apapni öcïköwa kï cïk ni n'onwongo ën bara öthöö: ");
INSERT INTO lth_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Man ënë ngö na myero ikob unu both Yocepu: An akwai më tïmö kïca both utmegoni pï bal ëka tïm na rac na gïn ötïmö ï komi.’ Öma tïm kïca ï kom bal k'etic k'Obanga k'apapni.” Ï karë na köp ni othuno bothe, Yocepu okok. ");
INSERT INTO lth_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Cë utmego mërë thon obino ëka oryebere gïnï pïny ï nyime nakun kobo gïnï nï, “Wan enene, ebedo opiini.” ");
INSERT INTO lth_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ëntö Yocepu okobo nïgï nï, “Kür ibed unu kï lworo. An atye nakaka Obanga? ");
INSERT INTO lth_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Un ïthëna unu athëna më tïmö gin na rac ï koma, ëntö Obanga ömïö man ötïmërë pï larö kwö ka jö na pol, na calö un itye ka nënö tin. ");
INSERT INTO lth_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Pï manön, kür ibed unu kï lworo. An abino gwököwu k'ëthïnöwu kïbëc.” Cë ën okweo cwinygï ëka ötwak kï mwolo bothgï. ");
INSERT INTO lth_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yocepu obedo ï Ejip, kanya acël kï jö më öt k'apap mërë kïbëc. Ën obedo ï wi lobo pï mwaka mia acël k'apar. ");
INSERT INTO lth_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yocepu önënö ëkwaë ka Epraim naka othuno ködë ï kom ëkwaë më run më adek mërë. Ën thon önënö ëthïnö ka Makir wod ka Manace; n'onwongo etero na calö obedo mëgë. ");
INSERT INTO lth_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Cë Yocepu okobo both utmego mërë nï, “An dong acwök thöö. Ëntö Obanga bino könyöwu, ëka bino kwanyöwu ökö kï ï lobo ni, dwököwu yo lobo na ën onwongo okwongo both Abraam, Icaka ëka Jakob.” ");
INSERT INTO lth_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ëka Yocepu ömïö ëthïnö ka Icarael okwongo gïnï kwong ëka okobo nï, “Obanga bino könyöwu. Cë un myero iting cogona ökö kï kany.” ");
INSERT INTO lth_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Cë Yocepu öthöö na mwaka më dit mërë tye mia acël k'apar. Kinge na gïn owiro kï yath më talö kom ëk kür öbal, ebino epyelo kome ï canduk lyël kï ï Ejip.");
INSERT INTO lth_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Man ënë köp na Muca ötwakö both jö Icarael kïbëc ï löka kulo Jordan kï kukïdë ï karë na gïn tye ï thim, ï Araba n'opimere kï Cup, ï kin Paran kï Topel, Laban, Kajerot ëka Dijabu. ");
INSERT INTO lth_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Tero nïnö apar wie acël më woth, yaa kï ï Koreb më cïdhö yo Kadec Barnea nakun ewok kï ï yoo më Kidi Ceir.) ");
INSERT INTO lth_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Ï nïnö dwe acël më dwe më apar wie acël, ï mwaka më pyer angwën, ënë Muca okobo both jö Icarael cïk kïbëc n'onwongo Rwoth ömïö bothe na makö komgï. ");
INSERT INTO lth_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Man ötïmërë kinge na ën ölöö Cikon rwoth ka jö Amor, n'onwongo löö löc ï Kecbon, ëka Og rwoth më Bacan, n'onwongo löö löc ï Acitarot ëka Edrei. ");
INSERT INTO lth_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Ï löka kulo më Jordan kï kukïdë më lobo më Moab, Muca öcakö gönyö tyën cïk ni nakun kobo nï: ");
INSERT INTO lth_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Rwoth Obanga onu ötwak kod onu kï ï Koreb nï, “Un dong ibedo ï thë kidi ni pï karë na lac. ");
INSERT INTO lth_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Yaa unu ëk ïcak unu wothwu, ïcïdh unu yo lobo n'otingere ka jö Amor, ëka jö kïbëc na cwök ködgï na tye ï Araba, ï kite, kï kuthö thë kite, ï Negeb ëka ï lobo n'ögürö dhö nam, ï lobo ka jö Kanaan ëka ï Lebanon, naka ï kulo na thwönë, n'obedo kulo më Euparate. ");
INSERT INTO lth_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Nën! An dong atyeko mïöwu lobo ni. Cïdh unu ëk ïgam unu lobo na Rwoth okwongere nï ebino mïö both kwaröwu Abraam, Icaka, Jakob ëka ëkwaëgï na bino lübögï.” ");
INSERT INTO lth_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Ï karë nön, Muca okobo bothgï nï, “An ba dökï arömö cobo pëköwu këna. ");
INSERT INTO lth_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Rwoth Obangawu dong ömïö ïnya unu na pol rwök, ënë ömïö tin ipol unu calö cër na tye ï polo. ");
INSERT INTO lth_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Ëk Rwoth, Obanga ka kwerewu, ömïïwu ïmëdërë tyën elip acël ëka ömïïwu gum kite na ën öcïkö ködë! ");
INSERT INTO lth_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Ëntö an atwërö cobo pëköwu këna nïngö nakun dong ïdökö unu yëc na pëk rwök, ëka kï köp kïbëc na tye ï kinwu? ");
INSERT INTO lth_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Yër unu jö mökö na ryëk, na nïang ëka jö n'ëwörögï kï ï kom kakawu acëlacël, ëka an abino kethogï na calö ëtëlawu.” ");
INSERT INTO lth_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Un ibino ïgamö nïna nï, “Gin na in ikobo tye na bër na wan myero ëtïm.” ");
INSERT INTO lth_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Cë an akwanyö ëtëla më kakawu, ëryëkö ëka jö n'ëwörögï. An akethogï më bedo kï löc ï komwu na calö edite ka jö elip, edite ka jö mia acël, edite ka jö pyer abic, edite ka jö apar ëka na calö ëtëla më kaka. ");
INSERT INTO lth_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Ï karë nön an acïkö ëngöl-köpwu nï: Winy unu pido na tye ï kin utmegowu ëka ïngöl unu köp n'atïr, kadï köp tye ï kin omego n'obedo dhanö më Icarael onyo arok mörö na bedo bothe. ");
INSERT INTO lth_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Kür ilengere unu ï ngölö-köp; un ibino winyo köp ka ngat na tïdï ëka më ka ngat na dit na röm aröma. Kür ibed unu kï lworo ï kom ngat mörö, pïën ngölö-köp obedo më k'Obanga. Kel unu köp mörö na tëk rwök kï bothwu ëka an abino winyo. ");
INSERT INTO lth_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Ï karë nön an acïköwu ï kom jami kïbëc na un onwongo myero ïtïm. ");
INSERT INTO lth_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Cë wan ëya ökö kï ï Koreb kite na Rwoth Obangawa öcïköwa ködë. Wan ewok ï thim na lac na un ïnënö ëka ëcïdhö yo lobo n'otingere ka jö Amor cë ethuno ï Kadec Barnea. ");
INSERT INTO lth_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Cë an akobo bothwu nï, “Un ithuno ï lobo ka jö Amor n'otingere, na Rwoth Obanga onu tye ka mïö both onu. ");
INSERT INTO lth_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Nën, Rwoth Obangawu ömïöwu lobo. Cïdh unu ëk ïgam unu lobo kite na Rwoth Obanga, Obanga ka kwerewu, okobo niwu. Kür ibed unu kï lworo; kür cwinywu thon opodhi.” ");
INSERT INTO lth_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Cë un kïbëc ibino unu botha ëka ikobo unu nï, “Eru eor cwö mörö më cïdhö anyim ëk öcïdh öröth gïnï lobo nï onu ëka odwongi gïnï köp both onu ï kom yoo na onu myero ëlübï ëka peci na onu ebino dönyö ïë.” ");
INSERT INTO lth_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","An athamö nï man obedo thama na bër; cë an ayërö jö apar arïö, ëcwö acël kï ï kaka acëlacël. ");
INSERT INTO lth_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Gïn obino öya ëka öcïdhö gïnï ï lobo n'otingere, cë obino gïnï naka ï ora më Ecikol ëka öröthö gïnï. ");
INSERT INTO lth_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Gïn ökwanyö nyig yen mökö më lobo nön ëka okelo gïnï bothwa. Gïn odwongo köp bothwa nakun kobo gïnï nï, “Lobo na Rwoth Obanga onu cwök mïö both onu obedo lobo na bër.” ");
INSERT INTO lth_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Ëntö un onwongo ba ïmïtö unu cïdhö yo malö; un ïjëm ï kom cïk ka Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Un ïngüngüta kï ï këmawu nakun ikobo unu nï, “Rwoth dagwa; ën ökwanyöwa kï ï Ejip më mïöwa ï cïng jö Amor ëk otyekwa ökö. ");
INSERT INTO lth_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Wan ebino cïdhö yo kwene? Utmegowa ömïöwa erwenyo genwa ökö. Gïn kobo nï, ‘Jö më lobo nön tëk ëka boco gïnï na lööwa ökö; peci tye na döngö, na cël mërë tye naka malö ï wi polo. Wan thon ënënö jö Anak kunön.’” ");
INSERT INTO lth_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Cë an akobo bothwu nï, “Kür ibed unu kï myël kom; kür ilwor unugï. ");
INSERT INTO lth_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Rwoth Obangawu, na ënë tëlö nyimwu, ënë bino lwëny pïrwu, kite na un ïnënö ën ötïmö ï Ejip, ");
INSERT INTO lth_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ëka ï thim. Kunön un ïnënö kite na Rwoth Obangawu ögwököwu ködë, na calö kite n'apap tingo kï wode. Ën ötïmö man ï kabedo kïbëc na un ïcïdhö yo ïë naka ithuno unu ï kabedo ni.” ");
INSERT INTO lth_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Ëntö kï kom gin na kïbëc n'Obanga ötïmö un pod ïkwërö më bedo kï gen ï kom Rwoth Obangawu, ");
INSERT INTO lth_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","n'obino ötëlö nyimwu ï wothwu, kï mac ï kiwor ëka kï pöl ï kiceng, më nwongo kabedo niwu ëk ibed unu ïë ëka më nyutho niwu yoo na myero ïlüb unu. ");
INSERT INTO lth_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Ï karë na Rwoth owinyo köp na un ikobo, ën obedo k'akëmö ëka okwongo kwong ni: ");
INSERT INTO lth_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Ngat mörö më run ni na rac ope kadï k'acël na bino nënö lobo na bër na an akwongara më mïö both kwerewu, ");
INSERT INTO lth_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","na path kï Kaleb wod ka Jepune. Ën bino nënö lobo nön. An abino mïö ën ëka ëkwaë mërë lobo na ën bino nyönö kï tyënë, pïën ën obedo ka lübö Rwoth kï cwinye kïbëc.” ");
INSERT INTO lth_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Akëmö obino ömakö Rwoth thon ï koma pïrwu. Ën okobo nïna nï, “In thon ba ibino dönyö kunön. ");
INSERT INTO lth_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Ëntö Yocua wod ka Nun n'obedo alüb kori ënë bino dönyö. Dïï cwinye, pïën ën bino tëlö jö Icarael më gamö lobo nön.” ");
INSERT INTO lth_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Cë Rwoth okobo both onu kïbëc nï, “Ëthïnöwu na pod thïthïnö gïnï na un ikobo nï ebino terogï ï opii ëka na bara ngeo gïnï poko gin na bër kï kom gin na rac, gïn ënë bino dönyö kunön. An abino mïögï ëka gïn bino gamö. ");
INSERT INTO lth_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Ëntö un, lökërë ëka ïdök unu ï thim ï yoo na cïdhö yo Nam na Kwar.” ");
INSERT INTO lth_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Cë un ïgamö nïna nï, “Wan ëbalö ï nyim Rwoth. Wan ebino cïdhö ëka ëlwënyö kite na Rwoth Obangawa öcïköwa ködë.” Cë ngat acëlacël oruko jami më lwëny nakun thamö nï cïdhö yo lobo n'otingere obedo gin na yot. ");
INSERT INTO lth_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Ëntö Rwoth okobo nïna nï, “Kob nïgï, ‘Kür ïcïdh unu malö më lwëny pïën an ba abino woth kodwu ëka langwu bino löönöwu.’” ");
INSERT INTO lth_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","An atwak kodwu, ëntö un ba iwinyo. Un ïjëm ï kom cïk ka Rwoth ëka pï awakawu un ïcïdhö ï lobo n'otingere. ");
INSERT INTO lth_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Jö Amor n'onwongo bedo gïnï kanya otingere nön obino ï komwu; gïn öryëmö körwu calö kic ëka ölwënyö ï komwu kï ï Ceir naka othuno ï Korma. ");
INSERT INTO lth_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Cë un idwogo ëka ikok unu ï nyim Rwoth, ëntö ën ba owinyo kokowu ëka ba olengo ithe ï köpwu. ");
INSERT INTO lth_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Pï manön, un idong ï Kadec nïnö na pol—pï karë kïbëc na un ibedo kunön. ");
INSERT INTO lth_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Cë wan ëlökërë ëka ëcïdhö ï thim, ï yoo na dök yo Nam na Kwar, kite na Rwoth öcïka ködë. Wan ebedo ka wïrë ï lobo më Ceir n'obedo lobo n'otingere pï karë na lac. ");
INSERT INTO lth_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Cë Rwoth okobo nïna nï, ");
INSERT INTO lth_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Un dong ibedo ka wïrë ï lobo ni n'otingere pï karë na lac; kobedini dong lökërë unu yo kukuju. ");
INSERT INTO lth_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Mïï jïï cïk ni gïnï: ‘Un ïcwök unu wok ï lobo ka utmegowu n'obedo ëkwaë k'Ecau, na bedo gïnï ï lobo Ceir. Gïn bino bedo kï lworo ï komwu, ëntö myero ïgwökërë unu rwök. ");
INSERT INTO lth_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Kür ïcak unu lwëny ï komgï, pïën an ba abino mïö lobogï mörö bothwu, kadï thon kany mörö na dhanö twërö cung ïë. An amïö lobo n'otingere më Ceir both Ecau na calö mëgë. ");
INSERT INTO lth_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Un ibino wïlö cem më acama ëka pii më amodha kï bothgï.’” ");
INSERT INTO lth_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Rwoth Obangawu ömïöwu gum ï kom tic kïbëc më cïngwu. Ën ögwököwu ï wothwu ï thim ni na lac. Ï mwaka pyer angwën ni Rwoth Obangawu obedo ka gwököwu, ëka gin mörö ope n'orem kï bothwu. ");
INSERT INTO lth_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Cë wan ëcïdhö ëkadhö utmegowa n'obedo ëkwaë k'Ecau, na bedo gïnï ï Ceir. Wan ëlökërë kï ï yoo më Araba na yaa kï ï Elat ëka Ejion Geber, cë ëcïdhö ï yoo na dök yo thim më Moab. ");
INSERT INTO lth_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Cë Rwoth okobo nïna nï, “Kür ïcïdh unu both jö më Moab kï gero onyo ïcak unu lwëny ï komgï, pïën an ba abino mïöwu lobogï mörö. An atyeko mïö Ar both ëkwaë ka Lot na calö mëgï.” ");
INSERT INTO lth_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Jö Emim onwongo bedo gïnï kunön cön; gïn obedo jö na tëk ëka pol gïnï rwök nakun boco gïnï calö jö Anak. ");
INSERT INTO lth_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Jö ni ëkwanögï ï kom jö Repa calö jö Anak, ëntö jö Moab cwodogï nï jö Emim. ");
INSERT INTO lth_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Jö Kori onwongo cön bedo gïnï ï Ceir, ëntö ëkwaë k'Ecau obino öryëmögï ökö. Gïn otyekogï ökö kïbëc kï ï nyimgï ëka obedo gïnï ï kabedogï kite na jö Icarael ötïmö ködë ï lobo na Rwoth ömïögï na calö mëgï.) ");
INSERT INTO lth_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Ëka Rwoth okobo nï, “Kobedini dong yaa unu malö, ïngöl unu ora më Jered.” Cë wan ëngölö ora. ");
INSERT INTO lth_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Cakërë ï karë na wan ëya ködë kï ï Kadec Barnea naka ëngölö ï ora më Jered, onwongo dong römö mwaka pyer adek wie aboro. Ï karë nön cwö kïbëc më run nön n'onwongo obedo gïnï ëlwëny obino öthöö gïnï ökö, kite na Rwoth onwongo okwongere ködë bothgï. ");
INSERT INTO lth_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Cïng Rwoth onwongo tye ï komgï naka otyeko jö më run nön kïbëc kï ï kabedogï. ");
INSERT INTO lth_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Ï karë na jö kïbëc n'onwongo obedo gïnï ëlwëny öthöö othum ökö, ");
INSERT INTO lth_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Rwoth okobo nïna nï, ");
INSERT INTO lth_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Tin myero iwok unu kï ï wang lobo më Moab na cwök kï pacö më Ar. ");
INSERT INTO lth_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Ëntö ka ibino unu na cwök kï jö Amon, kür ïcïdh unu bothgï kï gero onyo ïcak unu lwëny ï komgï, pïën an ba abino mïöwu lobo mörö n'obedo më ka jö Amon. An dong atyeko mïö both ëkwaë ka Lot na calö mëgï.” ");
INSERT INTO lth_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Manön thon onwongo ecwodo nï lobo ka jö Repa, n'onwongo bedo gïnï kunön; ëntö jö Amon cwodogï nï jö Jamjumim. ");
INSERT INTO lth_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Gïn onwongo obedo jö na tëk ëka pol gïnï rwök nakun boco gïnï calö jö Anak. Rwoth obino otyekogï kïbëc kï ï nyim jö Amon, n'öryëmögï ökö ëka obedo gïnï ï lobogï. ");
INSERT INTO lth_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Man ënë kite na Rwoth ötïmö ködë thon ï kom ëkwaë k'Ecau n'onwongo obedo gïnï ï Ceir, ï karë na ën otyeko jö Kori ökö kï ï nyimgï. Cë ëkwaë k'Ecau ögamö lobogï ëka oleo gïnï na pod bedo gïnï ïë naka tin. ");
INSERT INTO lth_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Ëka pï jö Abi n'obedo gïnï ï peci na thïthïnö naka othuno ï Gaja, jö Kaptor n'obino gïnï kï ï Kaptor otyekogï ökö ëka obedo gïnï ï kabedogï.) ");
INSERT INTO lth_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Kinge na dong onu ewok ï Moab, Rwoth okobo both onu nï, ‘Yaa malö, ïcak unu dong ngölö ora më Arnon. Nën! An atyeko mïö Cikon dhanö më Amor, rwoth më Kecbon, kanya acël kï lobo mërë ï cïngwu. Cïdh unu anyim ëk ïlwëny unu ï kome ëka ïgam unu lobo. ");
INSERT INTO lth_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Ï nïnö na tin, an abino mïö koyo öny ï kom rok kïbëc na bedo ï wi lobo nakun lworo makögï. Gïn bino winyo köp ï komwu ëka komgï bino myël nakun cwinygï podho pïrwu.’ ");
INSERT INTO lth_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“Cë an aoro jïï ï thim më Kedemot both Cikon rwoth më Kecbon kï köp më kuc, nakun akobo nïnë nï, ");
INSERT INTO lth_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘Yee nïwa më wok ï loboni. Wan ebino wok nakun ëlübö yoo këkën. Wan ba ebino lökërë yo kucem onyo yo kucam. ");
INSERT INTO lth_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Cadh nïwa cem më acama ëka pii më amodha kï wel më ryal. Yee nïwa ewok kï tyënwa këkën— ");
INSERT INTO lth_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","kite n'ëkwaë k'Ecau na bedo gïnï ï Ceir ëka jö Moab na bedo gïnï ï Ar ötïmö ködë—naka wan ëngölö kulo Jordan yo lobo na Rwoth Obangawa tye ka mïöwa.’ ");
INSERT INTO lth_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Ëntö Cikon rwoth më Kecbon ökwërö ökö nï wan kür ewok na cwök ködë pïën Rwoth Obanga onwongo ömïö ën obedo kï cwiny na nwang ëka kï cwiny na tëk ëk ëmïï ën ï cïngwu kite na dong ötïmö ködë. ");
INSERT INTO lth_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","“Rwoth okobo nïna nï, ‘Nën, an dong acakö mïö Cikon ëka kï lobo mërë bothwu. Cak unu dong gamö lobo mërë na calö mewu.’” ");
INSERT INTO lth_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Ï karë na Cikon ëka acikari mërë kïbëc obino gïnï më lwëny ï komwa kï ï Jakaj, ");
INSERT INTO lth_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Rwoth Obangawa öcakö mïö ën ï cïngwa ëka eneko ën kanya acël k'awope mërë ëka k'acikari mërë kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Ï karë nön wan ëgamö peci mërë kïbëc. Etyekogï—cwö, mon ëka ëthïnö. Ngat mörö ope n'öbwöth na kwö. ");
INSERT INTO lth_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Wan etero lïm na kwö na wan ëyakö ëk ödök mëwa, kanya acël kï jami nökënë n'ëyakö kï ï peci kïbëc na wan ëmaögï. ");
INSERT INTO lth_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Cakërë kï ï Aroer na tye ï nget ora më Arnon ëka kï ï pacö na tye ï ora, më thuno ködë naka ï Gilead, pacö mörö ope na tëk n'ëgërö malö rwök na maö ölööwa. Rwoth Obangawa ömïögï kïbëc ï cïngwa. ");
INSERT INTO lth_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Ëntö un ba ibino iwok unu na cwök kï lobo ka jö Amon, kadï lobo na tye ï dhö kulo më Jabok onyo peci mörö na tye ï lobo n'otingere, onyo kanya Rwoth Obangawa öjüköwa kï ïë. ");
INSERT INTO lth_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Cë wan dökï ëlökërë, ëdök malö ï yoo na cïdhö yo Bacan; Og rwoth më Bacan obino ï komwa k'acikari mërë kïbëc më bino lwëny ködwa ï Edrei. ");
INSERT INTO lth_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Ëntö Rwoth okobo nïna nï, “Kür ibed kï lworo ï kome, pïën an atyeko mïö ën bothi k'acikari mërë kïbëc ëka kï lobo mërë. In ibino tïmö ï kome kite na yam ïtïmö ï kom Cikon rwoth ka jö Amor n'onwongo löö Kecbon.” ");
INSERT INTO lth_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Cë Rwoth Obanga onu thon ömïö Og rwoth më Bacan k'acikari mërë kïbëc ï cïngwa. Wan enekogï kïbëc na ngat mörö ba öbwöth na kwö. ");
INSERT INTO lth_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Ï karë nön wan ëmaö peci mërë kïbëc. Pacö mörö ope kï ï peci pyer abicël na wan ba ëmaö kï bothgï—lobo kïbëc më Argob na tye ï thë löc ka Og rwoth më Bacan. ");
INSERT INTO lth_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Peci ni kïbëc onwongo ëcëlö kï cël na tëk n'otingere malö rwök ëka dhö wangkac gïnï n'eloro kï lote n'obedo nyweny, mëd kï peci na thïthïnö na pol na ba ëcëlögï. ");
INSERT INTO lth_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Wan ebino etyeko peci kïbëc, kite na wan ebino ëtïmö ï kom Cikon rwoth më Kecbon—neko cwö kïbëc, mon ëka ëthïnö. ");
INSERT INTO lth_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Ëntö lïm na kwö ëka jami kïbëc na wan ëyakö kï ï pecigï, wan eterogï ëk obed mëwa. ");
INSERT INTO lth_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Cë ï karë nön wan ëkwanyö lobo nön kï ï cïng rwodhi arïö ka jö Amor na tye kukïdë më kulo Jordan, cakërë kï ï ora më Arnon naka othuno ködë ï kidi më Kermon. ");
INSERT INTO lth_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Jö Cidon cwodo Kermon nï Cirion; ëka jö Amor cwodo nï Cenir.) ");
INSERT INTO lth_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Wan ëmaö peci kïbëc na tye ï lobo n'otingere malö n'öpëdhërë, lobo Gilead kïbëc ëka Bacan naka othuno ködë yo Caleka ëka Edrei, peci na tye ï thë löc ka Og rwoth më Bacan. ");
INSERT INTO lth_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Og rwoth më Bacan ënë onwongo odong kënë kï kin jö Repa. Ëka ëtana mërë onwongo ëyübö kï nywenyo. Bor mërë tye mita angwën ëka lac mërë mita arïö. Pod tye ï Raba ï pacö ka jö Amon.) ");
INSERT INTO lth_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Ï karë nön na onu ëmaö lobo ni, an abino amïö lobo na tye kukuju më Aroer both jö Reuben ëka jö Gad, na tye ï ora më Arnon, kï nucu lobo n'otingere më Gilead, kanya acël kï peci mërë. ");
INSERT INTO lth_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Lobo Gilead n'odong ëka lobo Bacan kïbëc, na ënë lobo ka rwoth Og, an abino amïö both nucu kaka ka Manace. (Lobo kïbëc më Argob na tye ï Bacan n'onwongo ecwodo nï lobo ka jö Repa. ");
INSERT INTO lth_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jair, akwar Manace, ökwanyö lobo Argob kïbëc na cïdhö naka ï wang lobo ka jö Gecur ëka jö Maakat; ebino ëcakö kï nyïngë, ëk naka tin Bacan ecwodo nï Kabot Jair.) ");
INSERT INTO lth_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Ëka an amïö Gilead both Makir. ");
INSERT INTO lth_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Ëntö both jö ka Reuben ëka jö ka Gad amïö lobo n'öcakërë kï ï Gilead cïdhö ködë naka ï ora më Arnon (dyere kulo ënë obedo wang apoki mërë) naka othuno ködë ï kulo më Jabok, na ënë wang apoki lobo ka jö Amon. ");
INSERT INTO lth_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Wang apoki mërë kï kuthö onwongo tye ï kulo Jordan na tye ï Araba, cakërë kï ï nam më Kineret naka othuno ködë ï nam më Araba (nam më Kadö) na tye ï lobo na tye ï kor kidi më Piciga na tye kï kukïdë. ");
INSERT INTO lth_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Ï karë nön an acïköwu nakun akobo nï: “Rwoth Obangawu ömïöwu lobo ni ëk ïgam unu obed mewu. Ëntö jö na mewu kïbëc na tëk ï lwëny myero öngöl gïnï Jordan nakun nwongo orukere gïnï kï jami lwëny më cïdhö ködë löka ï nyim utmegowu jö Icarael. ");
INSERT INTO lth_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Ëntö monwu, ëthïnöwu, ëka lïmwu na kwö na pol twërö dong gïnï ï peci na an amïöwu. ");
INSERT INTO lth_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Myero ïlwëny unu naka ka Rwoth ömïö utmegowu yweo kite n'ömïöwu ködë, na gïn thon onwongo lobo na Rwoth Obangawu bino mïögï ï löka kulo Jordan. Kinge manön, ngat acëlacël twërö dök cen ï lobo mërë na dong amïöwu.” ");
INSERT INTO lth_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Ï karë nön, an acïkö Yocua nï, “In ïnënö kï wangi gin na kïbëc na Rwoth Obangani ötïmö ï kom rwodhi arïö ni. Rwoth bino tïmö nï kömanön thon ï kom löc kïbëc na un ibino thuno ïë ka ipoth unu yo kanya un itye ka cïdhö ïë. ");
INSERT INTO lth_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Kür ilworgï; Rwoth Obangawu kikokome bino lwëny pïrwu.” ");
INSERT INTO lth_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Ï karë nön an akwaö Rwoth nï, ");
INSERT INTO lth_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Rwoth Obanga Won Twër, in ïcakö nyutho both aticni dit na megi ëka kï tëköni. Obanga mënë na tye ï wi polo onyo ï wi lobo na twërö tio tic më aura kite na in itio ködë? ");
INSERT INTO lth_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Wëk acïdh anën lobo na bër na tye yo löka kulo Jordan, lobo na bër n'otingere ëka kite më Lebanon.” ");
INSERT INTO lth_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Ëntö Rwoth ökëcö ï koma pïrwu ëka onwongo ba dök twërö winyona. Cë Rwoth okobo nï, “Manön örömö, kür dökï ïtwak köda ï kom köp ni. ");
INSERT INTO lth_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Apë ïïdh malö ï wi kidi më Piciga, cë ïnën yo kuthö ëka kukuju, kukwap ëka kukïdë. Nën lobo kï wangi, pïën in ba ibino ngölö kulo Jordan. ");
INSERT INTO lth_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Ëntö cïk Yocua, ïdïï cwinye ëka ïmïï ën tëk cwiny; pïën ënë bino poth yo löka ca nakun tëlö jö ni, cë bino mïögï gamö lobo na in ibino nënö.” ");
INSERT INTO lth_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Cë wan ebedo ï ora na cwök kï Bet Peor. ");
INSERT INTO lth_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Kobedini un jö Icarael, winy unu cïk kïbëc na an abino pwonyowu. Gwökgï ëk ibed unu na kwö ëk ïdöny ëka ïgam unu lobo na Rwoth, Obanga ka kwerewu, tye ka mïöwu. ");
INSERT INTO lth_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Kür ïmëd unu köp mörö ï kom cïk na an acïköwu ëka kür ïkwany unu köp mörö kï ïë, ëntö gwök unu cïk ka Rwoth Obangawu kite na an amïöwu ködë. ");
INSERT INTO lth_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Un ïnënö kï wangwu gin na Rwoth ötïmö ï Baal Peor. Rwoth Obangawu obino otyeko jö kïbëc na wörö Baal më Peor kï ï kinwu. ");
INSERT INTO lth_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Ëntö un kïbëc na pod iketho genwu ï kom Rwoth Obangawu pod itye unu na kwö naka tin. ");
INSERT INTO lth_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Nën! An dong atyeko pwonyowu cïk kïbëc kite na Rwoth Obangana öcïka ködë, ëk ïgwök unugï ï lobo na un ïcwök dönyö ïë më gamö dökö mewu. ");
INSERT INTO lth_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Gwök unu na bër, pïën manön ënë bino nyutho ryëkö ëka ngecwu both rok, na bino gïnï winyo cïk ni kïbëc cë kobo nï, “Adyer, rok na dit ni obedo gïnï jö na ryëk rwök ëka nïang gïnï.” ");
INSERT INTO lth_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Rok mënë na dit na tye k'obangagï na cwök ködgï, kite na Rwoth Obanga onu bedo na cwök kod onu ï karë kïbëc na onu ëlëgö bothe? ");
INSERT INTO lth_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Rok mënë nökënë na dit, na tye kï cïk n'atïr gïnï na calö man na tin an atye ka ketho ï nyimwu? ");
INSERT INTO lth_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Ëntö gwökërë unu na bër, kür ïmïï wiwu owil ökö kï kom gin na un ïnënö kï wangwu, onyo kür ïmïïgï orweny ökö kï ï cwinywu pï karë më kwöwu kïbëc. Pwony unu cïk ni both ëthïnöwu ëka both ëthïnögï thon. ");
INSERT INTO lth_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Po unu ï kom nïnö na un icung ï nyim Rwoth Obangawu ï Koreb, ï karë na ën okobo nïna nï, “Gür lwak ï nyima ëk owiny gïnï köpna ëk opwony gïnï kite më wöröna pï karë na gïn pod tye na kwö ï wi lobo ëk opwony gïnï both ëthïnögï.” ");
INSERT INTO lth_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Un ibino na cwök ëka icung unu ï tyën kidi, nakun wi kidi lyël kï mac naka ï polo, k'edou n'ocido na cöl ëka pïny na cöl cuc. ");
INSERT INTO lth_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Cë Rwoth ötwak kodwu kï ï mac. Un iwinyo köp ëntö ba ïnënö unu kome; dwön këkën ënë owinyere. ");
INSERT INTO lth_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Ën okobo niwu cïkërë mërë, cïk apar, na ën öcïköwu më gwökö ëka öcöögï ï kom kite arïö n'apada. ");
INSERT INTO lth_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Ëka Rwoth öcïka ï karë nön më pwonyowu kï cïk kïbëc na ën öcïka ködë, ëk ïgwök unu ï lobo na un ïcïdhö gamö më bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Myero ïgwökërë unu rwök pïën ba ïnënö unu cal gin mörö ï karë na Rwoth ötwak kodwu ï Koreb kï ï mac na lyël. ");
INSERT INTO lth_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Kür ïbal unu më yübö cal jwök pïrwu kenwu, cal gin mörö këkën na un ïyübö, kadï ëyübö na cal k'ëcwö onyo dhakö, ");
INSERT INTO lth_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","onyo na cal kï lee mörö na bedo ï wi lobo onyo wïnyü mörö na ngwëcö malö ï wi yamö, ");
INSERT INTO lth_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","onyo gin mörö na kwö na wotho ï wi ngöm onyo rëc mörö na tye ï öd pii pïny. ");
INSERT INTO lth_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ëka ka itingo wangi malö ï polo cë ïnënö ceng, dwe ëka cër—kï jami kïbëc na tye ï polo—kür ïmïï gin mörö öywa thamawu më ryebere pïny ï nyimgï ëka më wörö jami na Rwoth Obangawu ömïö pï rok kïbëc nökënë na tye ï thë polo. ");
INSERT INTO lth_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Ëntö Rwoth ölaröwu ëka ökwanyöwu ökö kï ï lobo Ejip, n'onwongo cal kï keno theth, më bedo jögë na pïrgï tëk kite na un itye ködë kobedini. ");
INSERT INTO lth_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Akëmö ömakö Rwoth ï koma pïrwu, cë okwongere nï an ba abino ngölö kulo Jordan ëka dönyö ï lobo na bër na Rwoth Obangawu bino mïöwu më bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","An abino thöö ï lobo ni; an ba abino ngölö kulo Jordan; ëntö un ïcwök ngölö kulo yo löka ëka ibino unu gamö lobo na bër më bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Gwökërë unu ëk kür wiwu owil kï cïkërë ka Rwoth Obangawu na ën öcïkërë kodwu. Kür ïyüb unu cal jwök mörö pïrwu na cal kï gin mörö na yam Rwoth Obangawu öcïkö nï kür ïtïm unu. ");
INSERT INTO lth_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Pïën Rwoth Obangawu cal kï mac na wangö pïny, ën obedo Obanga na nyek. ");
INSERT INTO lth_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Ï karë më anyim, ka dong ïnywölö unu ëthïnö ëka ëkwaëwu cë ibedo unu ï lobo pï karë na lac, kür ïbal unu kï yübö cal jwök mörö këkën. Man obedo gin na rac ï wang Rwoth Obangawu ëka bino mïö akëmö makö ën ï komwu. ");
INSERT INTO lth_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","An tin acwodo polo ëka lobo më bedo caden ï komwu nï ibino unu thöö pïöpïö kï ï lobo na un itye ka ngölö kulo Jordan më gamö. Un ba ibino bedo kunön pï karë na lac ëntö ebino tyekowu ökö. ");
INSERT INTO lth_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Rwoth bino këthöwu ökö ï kin rok na papath. Jö na nönök këkën ënë bino dong na kwö ï kin rok na Rwoth bino terowu ïë. ");
INSERT INTO lth_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Kï kunön un ibino wörö obanga na dhanö öyübö ayüba kï cïngë kï ï kom yen ëka kite, na ba römö neno, ba winyo köp, ba cemo ëka ba ngweo gin mörö. ");
INSERT INTO lth_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Ëntö ibino unu rangö Rwoth Obangawu kï kunön, ibino unu nwongo ën ka ïrangö unu kï cwinywu kïbëc ëka kï tipowu kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Ka itye unu ï pëkö na jami ni kïbëc ötïmërë ï komwu, cë kinge, ibino unu dwogo both Rwoth Obangawu ëka ibino bedo unu kï winy ï kome. ");
INSERT INTO lth_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Pïën Rwoth Obangawu obedo Obanga na nyakïca; ën ba bino wëkö onyo tyekowu onyo wie ba bino wil kï cïkërë mërë kï kwerewu, na ën omoko bothgï kï kwong. ");
INSERT INTO lth_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Kobedini peny unu pï karë n'opoth angec, na bara ënywölöwu, cakërë ï karë n'Obanga ocweo dhanö ï wi lobo; cak penyo kï ï acaki lobo naka ï ajiki. Tye gin mörö na dit rwök na calö man n'ötïmërë, onyo gin mörö na cal ködë n'obino owinyere? ");
INSERT INTO lth_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Tye rok mörö na yam owinyo dwön Obanga na twak kï ï mac kite na un iwinyo ködë ëka pod tye gïnï na kwö? ");
INSERT INTO lth_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Onyo obanga mörö tye n'ötëmö kwanyö rok mörö më bedo mëgë kënë, kï ï kin rok nökënë nakun tëmö cwinygï k'anyuth më tango ëka gin më aura gïnï, kï lwëny, kï tëkö ëka kï twërö, kï thwön lworo na dwong na röm kï gin na Rwoth Obangawu ötïmö niwu ï lobo Ejip nakun un itye ka nënö kï wangwu? ");
INSERT INTO lth_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Enyutho jami ni bothwu ëk inge unu nï Rwoth ënë Obanga; ba dök tye Obanga mörö nökënë. ");
INSERT INTO lth_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Ën ömïö iwinyo unu dwönë kï ï polo ëk opwonywu. Ëka onyutho niwu mac mërë na thwönë ï wi lobo cë iwinyo unu köp mërë kï ï mac. ");
INSERT INTO lth_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Pïën ën ömarö kwerewu ëka öyërö ëkwaëgï na gïn önywölö, ën ökwanyögï ökö kï lobo Ejip kï tëkö mërë na dit nakun ën kikome tye kodwu. ");
INSERT INTO lth_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Ën öryëmö rok na döngö ëka na tëk lööwu ökö kï ï nyimwu, ëk ekelwu ï lobogï më mïö lobogï bedo mewu kite na tye ködë tin. ");
INSERT INTO lth_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Tin dong myero inge unu ëka iketh unu ï cwinywu nï Rwoth ënë Obanga na tye ï wi polo ëka pïny ï wi lobo. Ba dök tye obanga mörö nökënë. ");
INSERT INTO lth_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Pï manön, myero ïgwök unu cïk mërë kïbëc na an atye ka cïköwu ködë tin, ëk nyimwu ëka ëkwaëwu obed na leng, ëk ïkwö unu pï karë na lac ï lobo na Rwoth Obangawu bino mïöwu pï karë kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Ï karë nön Muca opoko peci adek yo kukïdë kulo Jordan ");
INSERT INTO lth_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ëk ka ngat mörö oneko dhanö örïng yo kunön, ka ba öthëna athëna më neko awodhe akaka, na köp mörö ope ï kin-gï cön. Ën twërö rïngö ï pacö mörö acël ëka gwökö kwö mërë. ");
INSERT INTO lth_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Peci nön gïn enene: Bejer na tye ï thim n'otingere malö n'öpëdhërë, pï jö ka Reuben; Ramot na tye ï Gilead pï jö ka Gad, ëka Golan na tye ï Bacan pï jö ka Manace. ");
INSERT INTO lth_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Man ënë cïk na Muca ömïö both jö Icarael. ");
INSERT INTO lth_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Man ënë cïk kïbëc na Muca ömïö bothgï ï karë na gïn öya kï ï lobo Ejip. ");
INSERT INTO lth_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Gïn onwongo tye ï ora na cwök kï Bet Peor na tye kukïdë më kulo Jordan, na tye ï lobo ka Cikon rwoth ka jö Amor, n'onwongo löö Kecbon na Muca ëka jö Icarael obino ölöö ï karë na gïn dong öya ökö kï ï lobo Ejip. ");
INSERT INTO lth_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Gïn ögamö lobo mërë ëka lobo ka Og rwoth më Bacan, rwodhi arïö ka jö Amor na bedo gïnï ï löka kulo Jordan yo kukïdë. ");
INSERT INTO lth_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Lobo ni öcakërë kï ï pacö Aroer na tye ï lak kulo më Arnon cïdhö ködë naka ï kidi Cirion (manön, Kermon), ");
INSERT INTO lth_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","kanya acël k'Araba kïbëc na tye kukïdë më Jordan, na dök ködë yo nam më Araba na tye ï thë kidi më Piciga. ");
INSERT INTO lth_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Muca ocwodo jö Icarael kïbëc cë okobo bothgï nï: Un jö Icarael, winy unu cïk kïbëc na an acwök kobo niwu tin. Pwony unu ëka ïgwökërë unu më lübögï. ");
INSERT INTO lth_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Rwoth Obanga onu öcïkërë kod onu ï Koreb. ");
INSERT INTO lth_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Ën ba oketho cïkërë ni kï kwere onu ëntö oketho cïkërë kod onu kïbëc, na pod etye na kwö tin. ");
INSERT INTO lth_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Rwoth ötwak kodwu wang kï wang kï ï mac ï wi kidi. ");
INSERT INTO lth_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Ï karë nön, an acung ï kin Rwoth ëka un më kobo niwu köp ka Rwoth, pïën un onwongo ilworo mac ëka ba ïcïdhö unu malö ï wi kidi. Ëka ën okobo nï: ");
INSERT INTO lth_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“An ënë Rwoth Obangawu n'okelowu kï ï lobo Ejip, lobo më opii. ");
INSERT INTO lth_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Kür ibed unu k'obanga nökënë na path köda. ");
INSERT INTO lth_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“Kür ïyüb cal jwök mörö na megi, onyo cal gin mörö na tye malö ï wi polo, onyo na tye pïny ï wi lobo onyo na tye ï thë pii. ");
INSERT INTO lth_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Kür iryebiri pïny ï nyimgï më wörögï. Pïën an, Rwoth Obangani, abedo Obanga na nyek, ëka abino pwodo ëkwaë ka jö na daga pï bal ka kweregï naka thuno ködë ï kom ëkwaë më adek kï më angwën. ");
INSERT INTO lth_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Ëntö an abino nyutho mar na ba lökërë both jö elip kï elip na mara ëka gwökö cïkna gïnï. ");
INSERT INTO lth_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“Kür icwod nyïng Rwoth Obangani atata, pïën Rwoth bino mïö köp löö ngat na cwodo nyïngë atata. ");
INSERT INTO lth_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“Gwök nïnö më Cabït ëk obed na leng, kite na Rwoth Obangani ociki ködë. ");
INSERT INTO lth_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Tii tic pï nïnö abicël nakun ityeko ticni kïbëc, ");
INSERT INTO lth_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ëntö nïnö më abïrö ënë Cabït ka Rwoth Obangani. Nïnö nön kür igud tic mörö, kadï in kikomi, onyo wodi onyo nyari, onyo aticni n'ëcwö onyo na dhakö, onyo thwoni pur, onyo kanani onyo leenini mörö këkën, onyo arok mörö na bedo ï peciwu, ëk aticni n'ëcwö onyo na dhakö myero oywe thon calö in. ");
INSERT INTO lth_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Po unu nï un onwongo ibedo opii ï Ejip ëka Rwoth Obangawu ënë ökwanyöwu ökö kï kunön kï thwön tëkö. Manön ënë ömïö Rwoth Obangawu öcïkö nï ïgwök unu nïnö më Cabït. ");
INSERT INTO lth_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“Wör apapni ëka ayani, kite na Rwoth Obangani ociki ködë, ëk ibed ï wi lobo pï karë na lac ëka nyimi obed na leng ï lobo na Rwoth Obangawu tye ka mïöwu. ");
INSERT INTO lth_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“Kür ineki. ");
INSERT INTO lth_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“Kür ïdöny ï elomi. ");
INSERT INTO lth_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“Kür ïkwal. ");
INSERT INTO lth_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“Kür ikob köp më twodo ï kom ngat mörö. ");
INSERT INTO lth_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“Kür ïnïr dhakö ka ngat nökënë. Kür ïnïr öt ka ngat mörö, onyo ngöm, onyo etic mërë na cwö onyo na mon, thwön më pur onyo kana mërë, onyo gin mörö këkën n'obedo më ka ngat nökënë.” ");
INSERT INTO lth_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Man ënë cïk na Rwoth ötwakö kï dwön na longo ï athukowu kïbëc kï ï mac na lyël ï wi kidi, kï ï edou ëka pïny na cöl cuc cë ën ba ömëdö köp mörö nökënë. Ën öcöö cïk ni gïnï ï kom kite n'apada arïö ëka ömïögï botha. ");
INSERT INTO lth_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Ï karë na un iwinyo dwön n'odonyo kï ï pïny na cöl, nakun wi kidi tye ka lyël kï mac, ëtëla kïbëc më kakawu ëka edongwu obino gïnï botha. ");
INSERT INTO lth_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Ëka un ikobo nï, “Rwoth Obanga onu onyutho nï onu dheo ëka dit mërë cë onu ewinyo dwönë kï ï mac. Tin onu ënënö nï dhanö twërö bedo na kwö kadï bed nï Obanga twak ködë. ");
INSERT INTO lth_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Ëntö kobedini, pïngö onu myero ëthöö? Mac na thwönë nön bino camö onu ökö ëka onu ebino thöö ka ëmëdërë më winyo dwön Rwoth Obanga onu. ");
INSERT INTO lth_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Ngat mörö tye na tye kï kom na naka yam owinyo dwön Obanga na kwö nakun twak kï ï mac, kite na onu ewinyo ködë, ëka pod tye na kwö? ");
INSERT INTO lth_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","In ïcïdh na cwök ëk iwiny köp kïbëc na Rwoth Obangawa kobo. Cë ikob nïwa gin mörö këkën na Rwoth Obangawa bino kobo nini. Wan ebino winyo ëka ëlübö.” ");
INSERT INTO lth_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Rwoth owinyo köp na un ikobo botha cë okobo nïna nï, “An awinyo köp kïbëc na lwak okobo bothi, köp kïbëc na gïn okobo tye kakarë. ");
INSERT INTO lth_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Ka onwongo gïn mëdërë më bedo kï cwiny n'obedo nï kömanön ï karë kïbëc, më lworona ëka më gwökö cïkna kïbëc, ëk jami kïbëc owoth na bër ködgï ëka ëkwaëgï na twal. ");
INSERT INTO lth_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“Cïdh ikob nïgï nï ödök gïnï ï këmagï. ");
INSERT INTO lth_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Ëntö in idong botha kany ëk an akob nini cïkna kïbëc, na in myero ipwonygï ködë, ëk öcïdh ölüb gïnï ï lobo na an atye ka mïögï më bedo mëgï.” ");
INSERT INTO lth_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Pï manön, gwökërë unu ëk ïtïm unu kite na Rwoth Obangawu öcïköwu ködë; kür ïngël unu yo cïngwu kucem onyo kucam. ");
INSERT INTO lth_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Lüb unu yoo kïbëc na Rwoth Obangawu öcïköwu, ëk ibed unu na kwö, nyimwu obed na leng ëka ibed unu pï karë na lac ï lobo na un ibino gamö më bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Man ënë cïk kïbëc na Rwoth Obangawu öcïka nï ëk apwonywu më lübö ï lobo na un ïcïdhö ngölö kulo Jordan më gamö bedo mewu, ");
INSERT INTO lth_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ëk un, ëthïnöwu ëka ëkwaëgï na bino lübögï obed gïnï kï wörö ï kom Rwoth Obangawu pï karë më kwöwu na un ïgwökö cïk mërë kïbëc na an amïöwu. Man bino mïöwu bedo na kwö pï karë na lac. ");
INSERT INTO lth_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Pï manön, winy unu jö Icarael, gwökërë unu më lübögï ëk nyimwu obed na leng ëka thon ïnya unu na pol rwök ï lobo na mio na cak kï möö kic möl kï ïë, kite na calö Rwoth, Obanga ka kwerewu, öcïkö ködë. ");
INSERT INTO lth_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Winy unu jö Icarael, Rwoth Obangawa, ën kënë ënë Rwoth. ");
INSERT INTO lth_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Mar Rwoth Obangani kï cwinyi kïbëc, kï tiponi kïbëc ëka kï tëköni kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Cïk ni gïnï na an tin acïköwu ködë myero obed ï cwinywu. ");
INSERT INTO lth_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Pwony unu ëthïnöwu kï cïk nön gïnï. Twak unu pïrgï ka ibedo unu pacö ëka ka iwotho unu ï yoo, ka ibuto unu pïny ëka ka ïyaa unu malö. ");
INSERT INTO lth_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Twegï na calö anyuth gïnï më po wiwu ï ngut cïngwu ëka ï ter nyimwu. ");
INSERT INTO lth_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Cöögï ï kom yen dholokek më udiwu ëka ï kom dhö wangkacwu. ");
INSERT INTO lth_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Rwoth Obangawu bino kelowu ï lobo na ën öcïkërë kï kwong both kwaröwu Abraam, Icaka ëka Jakob. Lobo nön tye kï peci na lac na bër rwök, na pathï un ënë ïgërö, ");
INSERT INTO lth_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","udi n'opong kï jami kïbëc na bëcö na un ba iketho gin mörö ïë, kulo na un ba igolo, pwothi ölök ëka yen jeituni na un ba ïpïdhö cë ka ïcamö unu ëka iyeng unu, ");
INSERT INTO lth_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","gwökërë unu ëk kür wiwu owil ökö ï kom Rwoth n'okelowu kï ï Ejip, lobo më opii. ");
INSERT INTO lth_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Wör Rwoth Obangawu, tii unu nïnë këkën ëka ikwong unu kwong na mewu kï nyïngë. ");
INSERT INTO lth_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Kür ïwör unu obanga nökënë, obanga ka rok na tye ï ngetwu, ");
INSERT INTO lth_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","pïën Rwoth Obangawu, na tye ï kinwu, obedo Obanga na nyek ëka akëmö mërë bino podho ï komwu cë bino tyekowu ökö kï ï wi lobo. ");
INSERT INTO lth_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Kür ïtëm unu Rwoth Obangawu kite na un ïtïmö ködë kï ï Maca. ");
INSERT INTO lth_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Myero ïgwök unu cïk ka Rwoth Obangawu kïbëc na ën öcïköwu. ");
INSERT INTO lth_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Tïm unu gin na tye atïr ëka na bër ï nyim Rwoth ëk nyimwu obed na leng ëka ïcïdh ïgam unu lobo na bër na Rwoth yam öcïkërë kï kwong both kwerewu, ");
INSERT INTO lth_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","ëka Rwoth bino ryëmö langwu ökö kï ï nyimwu kite na ën okobo. ");
INSERT INTO lth_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Ï karë më anyim, ka ëthïnöwu openyowu nï, “Pïngö Rwoth Obangawa öcïköwa më lübö cïk ni kïbëc?” ");
INSERT INTO lth_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Un ibino kobo both ëthïnöwu nï, “Wan onwongo ebedo opii ka Parao ï lobo më Ejip, ëntö Rwoth ökwanyöwa ökö kï kunön kï tëkö më cïngë. ");
INSERT INTO lth_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Rwoth obino otio anyuth më tango ëka gin më aura gïnï—na döngö ëka na reco rwök—ï kom jö Ejip, ï kom Parao ëka ï kom jö më ödë kïbëc na wan ënënö kï wangwa. ");
INSERT INTO lth_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Ëntö ën obino ökwanyöwa ökö kï kunön më kelowa kany, ëk ëmïïwa lobo na ën okwongere nï ebino mïö both kwerewa. ");
INSERT INTO lth_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Rwoth öcïköwa më lübö cïk ni kïbëc ëka më wörö Rwoth Obanga onu, ëk ebed na bër ï karë kïbëc ëka ebed na kwö, kite na tye ködë tin. ");
INSERT INTO lth_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Ka onu ëgwökërë më wörö cïk ni kïbëc ï nyim Rwoth Obangawa, kite na ën öcïkö onu ködë, cë ebino bedo jö na kitegï atïr.” ");
INSERT INTO lth_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Ka Rwoth Obangawu bino kelowu ï lobo na un itye ka dönyö ïë më gamö bedo mewu, nakun ryëmö rok na pol ökö kï ï nyimwu—jö Kit, jö Girgac, jö Amor, jö Kanaan, jö Periji, jö Kibi ëka jö Jebuc—rok abïrö na pol ëka tëk gïnï na lööwu ökö ");
INSERT INTO lth_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","ëka ka Rwoth Obangawu ömïögï ï cïngwu cë ïlöö unugï, myero ityek unugï ökö. Kür imok unu cïkërë ködgï, ëka kür thon inyuth kïca mörö bothgï. ");
INSERT INTO lth_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Kür ïnyömërë unu ködgï. Kür ïmïï anyirawu both awopegï më anyöma onyo kür ïnyöm unu anyiragï n'awopewu, ");
INSERT INTO lth_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","pïën gïn bino mïö ëthïnöwu lökërë ökö kï botha cë cakö gïnï wörö obanga nökënë, ëka akëmö ka Rwoth bino bino ï komwu cë tyekowu ökö pïöpïö. ");
INSERT INTO lth_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Man ënë gin na myero un ïtïm ï komgï: Tütürö unu keno tyërgï ökö pïny, rëdh unu kite na gïn ocibo më awöra ökö pïny, tong unu yen n'ëpïdhö kanya gïn wörö obangagï na dhakö ïë n'ecwodo nï Acera ëka ïwang unu cal jwogigï ökö kï mac. ");
INSERT INTO lth_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Pïën un ibedo jö na leng both Rwoth Obangawu. Rwoth Obangawu otyeko yëröwu kï kin lwak kïbëc na tye ï wi lobo më bedo jögë na pïrgï tëk. ");
INSERT INTO lth_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Rwoth ba oketho mar mërë ï komwu ëka öyëröwu, pathï nï un onwongo ipol unu na löö rok nökënë, pïën un ënë onwongo itye unu na nönök na löö kï kin rok kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Ëntö pïën Rwoth onwongo ömaröwu ëka ögwökö kwong mërë na ën okwongo both kwerewu, ënë ömïö ën ökwanyöwu ökö kï tëkö më cïngë ëka ökököwu kï ï lobo më opii, kï ï tëkö ka Parao rwoth më Ejip. ");
INSERT INTO lth_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Myero dong inge unu nï Rwoth Obangawu ënë Obanga; ën obedo Obanga na genere, na gwökö cïkërë mërë më mar both wang rok elip kï elip na marö ën ëka gwökö gïnï cïk mërë. ");
INSERT INTO lth_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Ëntö jö na dag Rwoth, ën bino cülö kwor ï komgï kï tyekogï; ën ba bino galërë më cülö kwor ï kom jö na dag ën. ");
INSERT INTO lth_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Pï manön, myero ïgwökërë unu më lübö cïk kïbëc na an amïöwu tin. ");
INSERT INTO lth_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Ka iwinyo unu cïk ni gïnï ëka ïlübö unu na bër, cë Rwoth Obangawu bino mëdërë më gwökö cïkërë më mar mërë kodwu kite na ën okwongo ködë both kwerewu. ");
INSERT INTO lth_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Ën bino maröwu, mïöwu gum ëka mëdö welwu. Ën bino mïö gum both ëthïnö na un ibino nywölö, gin na bino cëk ï pwothiwu—kalwu, köngö ölök na nyen ëka möö jeituni—ëthïn dhok na mewu ëka ëthïn rom kï dyegiwu ï lobo na ën yam okwongere both kwerewu nï ebino mïöwu. ");
INSERT INTO lth_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Ebino mïöwu gum na löö rok nökënë; ngat mörö ope kï ï kin cwö onyo mon na mewu na bino bedo abonge athïn, onyo leeniwu mörö ope na bino bedo abonge athïn mërë. ");
INSERT INTO lth_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Rwoth bino gwököwu kï ï kom two kïbëc. Ën ba bino mïö two na reco na un ingeo kï ï lobo Ejip maköwu, ëntö ën bino mïö makö jö kïbëc na dagwu. ");
INSERT INTO lth_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Myero ityek unu rok kïbëc na Rwoth Obangawu bino mïö ï cïngwu. Kür kïca ömakwu ï komgï ëka kür ïwör unu obangagï gïnï, pïën manön bino bedo calö pawaka më maköwu. ");
INSERT INTO lth_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Ka un ïthamö kenwu nï, “Rok ni tëk lööwa ökö. Wan ebino ryëmögï nïngö?” ");
INSERT INTO lth_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Ëntö kür ibed unu kï lworo ï komgï; po unu ï gin na Rwoth Obangawu ötïmö ï kom Parao ëka jö më Ejip kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Un ïnënö kï wangwu atëmatëma na döngö, anyuth më tango ëka gin më aura gïnï, cïng na tëk ëka kï twërö mërë na Rwoth Obangawu okelowu ködë. Rwoth Obangawu bino tïmö nï kömanön ï kom rok kïbëc na un kobedini ilworo. ");
INSERT INTO lth_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Rwoth Obangawu bino oro lworo ï kin-gï naka thon jö n'ökwö n'opono gïnï kï bothwu ebino tyekogï ökö. ");
INSERT INTO lth_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Kür ibed unu kï lworo ï komgï, pïën Rwoth Obangawu na tye ï kinwu, ën obedo Obanga na dit ëka ngat na myero elwor. ");
INSERT INTO lth_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Rwoth Obangawu bino ryëmö rok nön gïnï ökö kï ï nyimwu momoth. Ba ebino yeo niwu më tyekogï ökö wang acël, pïën wel leeni na ger römö mëdërë ëka twërö yelowu. ");
INSERT INTO lth_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Ëntö Rwoth Obangawu bino mïögï ï cïngwu, ën bino mïögï rubere rwök naka ibino unu tyekogï ökö. ");
INSERT INTO lth_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Ën bino mïö rwodhigï ï cïngwu, ëka ibino unu rwenyo nyïng-gï ökö kï ï wi lobo. Ngat mörö ope na bino cung ï nyimwu; ibino unu tyekogï ökö. ");
INSERT INTO lth_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Myero ïwang unu cal obangagï gïnï kï mac. Kür ïnïr unu ryal onyo gol na tye ï komgï, ëka kür ïkwany më bedo mewu onyo bino dökö pawaka më maköwu, pïën obedo gin më kwer both Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Kür ikel unu gin mörö më kwer ï udiwu na mïö etyekowu ökö calö gïn. Myero ïkwër ëka ïdag unu gin nön, pïën obedo gin na myero etyek ökö. ");
INSERT INTO lth_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Gwökërë unu më lübö cïk kïbëc na an atye ka mïöwu tin, ëk ibed unu na kwö ëka ïnya unu na pol, ïcïdh ïdöny unu ï lobo na Rwoth öcïkërë kï kwong both kwerewu. ");
INSERT INTO lth_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Myero ipo unu kite na Rwoth Obangawu ötëlöwu ködë kï ï thim pï mwaka pyer angwën, më mïöwu bedo na mwol ëka më tëmöwu ëk enge gin n'onwongo tye ï cwinywu, ka onyo ibino unu gwökö cïk mërë onyo pe. ");
INSERT INTO lth_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Ën ömïö ïdökö unu na mwol, ömïö kec onekowu, cë öpïdhöwu kï mana, na un onyo kwerewu onwongo ba ongeo, më pwonyowu nï dhanö ba kwö kï cem këkën ëntö kwö kï köp kïbëc na donyo kï ï dhö Rwoth. ");
INSERT INTO lth_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Böngwu ba obino otii kï ï komwu ëka tyënwu ba obino okwot ï mwaka pyer angwën ni kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Myero dong inge unu kï ï cwinywu nï kite na calö dhanö pwonyo athïn mërë, Rwoth Obangawu thon pwonyowu. ");
INSERT INTO lth_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Myero ïgwök unu cïk ka Rwoth Obangawu, nakun iwotho unu ï yoo mërë ëka ilworo unu ën. ");
INSERT INTO lth_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Pïën Rwoth Obangawu tye ka kelowu ï lobo na bër—n'opong kï ora, kulo më pii ëka wang pii na möl ï ora ëka wi kite; ");
INSERT INTO lth_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","lobo na tye kï ngano ëka cayiri, ölök ëka yen ölam, okwer pomegranat, lobo na möö jeituni ëka möö kic möl kï ïë; ");
INSERT INTO lth_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","lobo na cem ba nönök ïë ëka gin mörö ope na bino rem kï bothi; lobo na kite mërë obedo nywenyo ëka ïtwërö künyö mola kï ï kite. ");
INSERT INTO lth_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Ka icemo ëka iyeng unu, pak unu Rwoth Obangawu pï lobo na bër na ën ömïöwu. ");
INSERT INTO lth_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Gwökërë unu ëk kür wiwu owil ökö ï kom Rwoth Obangawu, na nwongo ba ïgwökö unu cïk mërë kïbëc na an atye ka mïöwu tin. ");
INSERT INTO lth_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Ka icemo ëka iyeng unu, ka ïgërö unu udi na bëcö më bedo ïë, ");
INSERT INTO lth_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ka dhok, rom kï dyegiwu önya ödökö na pol, ka ryalwu ëka gol ömëdërë ëka kï jami kïbëc na un itye ködgï önya, ");
INSERT INTO lth_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","cë cwinywu cakö wakërë ëka wiwu bino wil ökö ï kom Rwoth Obangawu n'ökwanyöwu kï ï lobo Ejip, lobo më opii. ");
INSERT INTO lth_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Ën ötëlöwu kï ï thim na lac ëka na lik, lobo më örïö na pii ope ïë, na thwone ëka ïth tye gïnï ïë. Ën ömïöwu pii n'öya kï ï lëla. ");
INSERT INTO lth_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Ën öpïdhöwu kï mana kï ï thim, gin mörö na kwerewu ba ongeo anaka yam, më mïöwu bedo na mwol ëka më tëmöwu ëk ï ajiki nyimwu obed na leng. ");
INSERT INTO lth_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Gwökërë unu ëk kür ikob kenwu nï, “Tëköna ëka twërö më cïnga ënë ömïa anwongo lönyö ni.” ");
INSERT INTO lth_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Ëntö po unu ï kom Rwoth Obangawu, pïën ënë mïö tëkö më nwongo lönyö, ëk omok cïkërë mërë na ën okwongo both kwerewu, kite na tye ködë tin. ");
INSERT INTO lth_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Ka wiwu bino wil ökö ï kom Rwoth Obangawu, cë ïlübö unu obanga nökënë, ïwörö ëka iryebere unu pïny ï nyimgï, an akobo köp më caden bothwu tin nï ebino tyekowu ökö. ");
INSERT INTO lth_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Ebino tyekowu ökö calö rok nökënë na Rwoth otyekogï ökö kï ï nyimwu, cë ebino tyekowu ökö pï kwërö winyo dwön Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Winy unu, jö Icarael. Un kobedini ïcwök unu ngölö kulo Jordan yo löka, ëk ïcïdh unu më ryëmö rok na tye kunön, jö na tëk na lööwu ökö, na tye kï peci na lac kï cël na thuno naka ï polo. ");
INSERT INTO lth_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Jö nön tëk ëka boco gïnï, jö Anak! Un ingeo köp ï komgï, ëka iwinyo unu ka ekobo nï: “Nga na twërö cung ï nyim jö Anak më lwëny ködgï?” ");
INSERT INTO lth_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Ëntö myero inge unu tin nï Rwoth Obangawu ënë ngat na tye ka woth ï nyimwu na calö mac na wangö pïny. Ën kikome ënë bino tyekogï, ën bino löönögï ökö kï ï nyimwu. Un ibino ryëmögï ëka ibino nekogï pïöpïö, kite na Rwoth öcïkërë ködë bothwu. ");
INSERT INTO lth_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Kinge na Rwoth Obangawu öryëmögï ökö kï ï nyimwu, kür ikob kï ï cwinywu nï, “Rwoth okela kany më gamö lobo ni pïën an kitena atïr.” Manön obedo pï tïm na reco më rok ni ënë ömïö Rwoth bino ryëmögï ökö kï ï nyimwu. ");
INSERT INTO lth_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Pathï pï kite atïrwu onyo pï leng cwinywu nï un ïcïdhö më gamö lobogï; ëntö pï tïm na reco më rok ni gïnï, Rwoth Obangawu bino ryëmögï ökö kï ï nyimwu, ëk ocob gin na ën okwongo both kwaröwu Abraam, Icaka ëka Jakob. ");
INSERT INTO lth_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Myero ïnïang unu nï pathï pï kite atïrwu ënë ömïö Rwoth Obangawu tye ka mïöwu lobo ni na bër ëk ïgam unu obed mewu, pïën un jö na ngutwu nwang. ");
INSERT INTO lth_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Po unu ï köp ni ëka kür ïmïï wiwu owil kite na un ïmïö akëmö ömakö Rwoth Obangawu kï ï thim. Cakërë ï nïnö na un ïya kï Ejip naka ithuno unu ï kabedo ni, un ibedo jëm ï kom Rwoth. ");
INSERT INTO lth_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Ï kidi më Koreb, un ïmïö Rwoth obedo k'akëmö, cë ömïö akëmö ömakö ën rwök ï komwu më tyekowu. ");
INSERT INTO lth_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Ï karë na an aïdhö malö ï wi kidi më gamö kite n'apada, kite n'apada më cïkërë na Rwoth oketho kodwu, an abino abedo ï wi kidi pï nïnö pyer angwën kiceng ëka kiwor, nakun ba acemo ëka ba amodho pii. ");
INSERT INTO lth_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Rwoth ömïa kite arïö n'apada n'Obanga onwongo öcöö kï cïngë. Cïk kïbëc onwongo tye ï komgï na Rwoth ötïtö bothwu kï ï mac na lyël ï wi kidi ï nïnö më athuko. ");
INSERT INTO lth_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Kinge nïnö pyer angwën kiceng ëka kiwor, Rwoth ömïa kite arïö n'apada, kite n'apada më cïkërë. ");
INSERT INTO lth_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Cë Rwoth okobo nïna nï, “Yaa malö kï kany ïcïdh yo pïny pïöpïö, pïën jogi na in ikelogï kï ï Ejip ötïmö gïnï bal. Gïn ölökërë gïnï ökö pïöpïö kï ï kom gin na an acïkögï ëka öyübö gïnï cal jwök n'obedo nywenyo.” ");
INSERT INTO lth_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Rwoth okobo nïna nï, “An anënö jö ni ëka obedo gïnï jö na ngutgï nwang rwök! ");
INSERT INTO lth_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Wëka an këna, ëk atyekgï ëka ajwa nyïng-gï ökö kï ï thë polo. An abino mïöni ïdökö rok na tëk ëka ïnya unu na pol na löögï.” ");
INSERT INTO lth_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Cë an alökara, aidho yo pïny kï ï wi kidi, nakun kidi tye ka lyël kï mac. Ëka kite arïö n'apada më cïkërë onwongo tye ï cïnga gïnï. ");
INSERT INTO lth_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Ï karë na an anënö, anënö nï ïbalö unu ï kom Rwoth Obangawu; un ïyübö cal jwök na cal kï wod thwön pïrwu. Un ïlökërë ökö pïöpïö kï ï yoo na Rwoth onwongo öcïköwu. ");
INSERT INTO lth_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Cë an amakö kite arïö n'apada ëka abologï ökö pïny kï ï cïnga gïnï, angënyö ökö na thïthïnö ï nyimwu. ");
INSERT INTO lth_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Kinge dökï abuto pïny aryeba cwiny ï nyim Rwoth pï nïnö pyer angwën kiceng ëka kiwor; an ba acemo ëka ba amodho pii pïën pï bal kïbëc na un ïtïmö, nakun ïtïmö unu gin na rac ï wang Rwoth n'ömïö akëmö ömakö ën. ");
INSERT INTO lth_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","An abedo kï lworo ï kom akëmö ka Rwoth na tëk, pïën akëmö onwongo ömakö ën rwök ï komwu më tyekowu ökö. Ëntö Rwoth dökï obino owinya. ");
INSERT INTO lth_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Akëmö ömakö Rwoth rwök ï kom Aron më neko ën, ëntö ï caa nön an alëgö pïrë thon. ");
INSERT INTO lth_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","An thon akwanyö gin më balwu nön, wod thwön na un ïyübö, cë awangö ökö kï mac. Cë angïngïnyö ëka amïö ödökö buru na pwöth calö apua, cë aönyö apua mërë ï kulo na möl pïny kï ï wi kidi. ");
INSERT INTO lth_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Un thon ïmïö akëmö ömakö Rwoth kï ï Tabera, ï Maca ëka ï Kibrot Ataaba. ");
INSERT INTO lth_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Ëka ï karë na Rwoth oorowu kï ï Kadec Barnea ën okobo nï, “Cïdh unu malö ëka ïgam unu lobo na an amïöwu,” ëntö un ibino ïjëm unu ï kom Rwoth Obangawu. Un ba ibedo kï gen ï kome ëka ba iwinyo unu ën. ");
INSERT INTO lth_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Un ibedo jëm ï kom Rwoth anaka ï nïnö na an angeowu ködë. ");
INSERT INTO lth_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","An abuto aryeba cwiny ï nyim Rwoth pï nïnö pyer angwën nön kiceng ëka kiwor pïën Rwoth onwongo okobo nï ebino tyekowu ökö. ");
INSERT INTO lth_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Cë an alëgö both Rwoth ëka akobo nï, “Rwoth Obanga Won Twër, kür ityek jogi, jö na megi na pïrgï tëk na in ïkökögï kï tëköni ëka ïkwanyögï kï ï Ejip kï tëkö më cingi. ");
INSERT INTO lth_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Po ï kom aticni Abraam, Icaka, ëka Jakob. Kür ibed ka thamö pï ngut na nwang, tïmgï na reco ëka balgï. ");
INSERT INTO lth_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Pï manön lobo na in ïkwanyöwa kï ïë bino kobo nï, ‘Rwoth onwongo ba römö terogï ï lobo na ën öcïkërë ködë bothgï, ëka pïën ën onwongo dag-gï, ën ökwanyögï ëk enekgï ökö ï thim.’ ");
INSERT INTO lth_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Ëntö gïn obedo jogi na pïrgï tëk na in ïkwanyögï kï tëköni ëka kï twëröni.” ");
INSERT INTO lth_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","Ï karë nön Rwoth okobo nïna nï, “Yüb kite arïö n'apada calö më acël ca ëka ibin yo botha ï wi kidi malö. Yüb thon canduk më bao. ");
INSERT INTO lth_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","An abino cöönö ï kom kite n'apada köp n'onwongo tye ï kom kite n'apada më acël ca, na in ibino ïngënyögï ökö. Cë in myero ikethgï ï canduk.” ");
INSERT INTO lth_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Cë an ayübö canduk kï ï kom yath alwïï ëka an ayübö kite arïö n'apada calö më acël ca gïnï. Ëka an acïdhö malö ï wi kidi kï kite arïö n'apada ï cïnga gïnï. ");
INSERT INTO lth_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Rwoth öcöö ï kom kite n'apada ni ngö na ën onwongo öcöö cön, cïk apar na ën onwongo ötïtö bothwu kï ï mac, ï nïnö na un ïcökërë ï tyën kidi. Rwoth ömïögï botha. ");
INSERT INTO lth_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Cë an adwogo pïny kï ï wi kidi ëka aketho kite n'apada ï canduk n'onwongo an ayübö kite na Rwoth öcïka ködë ëka pod tye gïnï kunön. ");
INSERT INTO lth_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(Ï karë nön jö Icarael öya gïnï kï ï Beerot Bene Jakan cë öcïdhö gïnï ï Mocera. Kï kunön Aron öthöö ëka eiko, cë wode Eleajar oleo ka tyënë na calö alamdhök. ");
INSERT INTO lth_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Gïn öya kï kunön, cë öcïdhö gïnï yo Gudugoda ëka yo Jotbata, lobo na pii dwong ïë. ");
INSERT INTO lth_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Ï karë nön Rwoth opoko kaka ka jö Lebi path më tingo canduk më cïkërë ka Rwoth, më cung ï nyim Rwoth më tio tic ëka më lamö gum kï nyïngë, kite na gïn pod tïmö ködë tin. ");
INSERT INTO lth_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Manön ënë ömïö jö Lebi ba tye gïnï kï dul lobo mörö n'obedo mëgï ï kin utmegogï; Rwoth ënë obedo gin n'epoko nïgï kite na Rwoth Obangawu okobo bothgï ködë.) ");
INSERT INTO lth_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","An abedo ï wi kidi pï nïnö pyer angwën kiceng ëka kiwor, kite na an abedo ködë ï më acël ca. Rwoth obino owinyo lëgana ï karë nön thon cë Rwoth oyeo nï ba ebino tyekowu. ");
INSERT INTO lth_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Rwoth okobo nïna nï, “Yaa malö, ïtël wi jïï ëk ödöny ëka ögam gïnï lobo na an akwongara më mïö both kweregï.” ");
INSERT INTO lth_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Kobedini dong, un jö Icarael, ngö na Rwoth Obangawu mïtö kï bothwu? Gin na Rwoth Obangawu mïtö kï bothwu ënë nï lwor unu Rwoth Obangawu, ïlüb unu yodhi mërë kïbëc, ïmar unu ën, ëka itii unu both Rwoth Obangawu kï cwinywu kïbëc ëka kï tipowu kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","Gwök unu cïk ka Rwoth kïbëc na an atye ka mïöwu tin pï bër bedowu. ");
INSERT INTO lth_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Nën, kadï jami kïbëc na tye malö ï wi polo rwök, lobo ëka jami kïbëc na tye ïë obedo më ka Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Ëntö Rwoth oketho cwinye ï kom kwerewu ëka ömarögï cë obino öyëröwu, ëkwaëgï, kï ï kin rok kïbëc, kite na tye ködë tin. ");
INSERT INTO lth_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Pï manön, bed unu kï winy both Rwoth ëka ïwëk unu bedo jö na ngutgï nwang. ");
INSERT INTO lth_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Pïën Rwoth Obangawu ënë obedo Obanga na löö obanga nökënë gïnï ëka Rwoth ka rwodhi nökënë. Ën obedo Obanga na dit, na tye kï tëkö ëka Obanga na myero elwor. Ën ba lengere ï ngölö-köp ëka ba wïlërë kï lïm. ");
INSERT INTO lth_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Ën ngölö köp n'atïr ï kom athïn kic ëka ï kom dha thöö. Nyutho mar mërë both Erok ëka mïögï cem kï gin më aruka. ");
INSERT INTO lth_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Un myero ïmar Erok, pïën un thon onwongo ibedo unu Erok ï lobo Ejip. ");
INSERT INTO lth_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Wör Rwoth Obangawu, tii unu nïnë këkën ëka ikwong unu kwong na mewu kï nyïngë. ");
INSERT INTO lth_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Ën obedo Obanga na myero ïpak unu; ën obedo Obangawu, n'ötïmö niwu jami na döngö ëka tango më aura na un ïnënö kï wangwu. ");
INSERT INTO lth_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Kwerewu n'obino öcïdhö gïnï ï Ejip onwongo tye pyer abïrö kïbëc, ëka Rwoth Obangawu ömïöwu ïdökö na pol na calö cër na tye ï polo. ");
INSERT INTO lth_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Myero ïmar unu Rwoth Obangawu ëka ïtïm unu gin na ën mïtö; gwök unu cïk mërë kïbëc, ëka gin na ën öcïkö ï karë kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Po unu tin ï kom pwony na Rwoth Obangawu opwonyowu ködë, an ba atye ka twak k'ëthïnöwu ëntö kodwu pïën un ingeo ëka ïnënö unu dit mërë, cïngë na tëk ëka twërö mërë. ");
INSERT INTO lth_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","Gïn ba önënö tango ëka gin më aura na ën ötïmö ï Ejip both Parao rwoth më Ejip ëka ï lobo mërë kïbëc; ");
INSERT INTO lth_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","gin na ën ötïmö ï kom acikari më Ejip, ï kom angole ëka gadigadigï, ï karë na ën ömïö pii më Nam na Kwar ömwönyögï ökö nakun onwongo gïn tye ka ryëmö körwu, ëka kï kite na Rwoth otyekogï ködë. ");
INSERT INTO lth_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Gïn ba önënö gin na ën ötïmö niwu ï thim na un bara ithuno ï kabedo ni, ");
INSERT INTO lth_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","onyo gin na ën ötïmö ï kom Datan ëka Abiram, ëthïnö k'Eliab wod ka Reuben, ï karë na Rwoth ömïö ngöm öyabërë kï kanya jö Icarael onwongo bedo ïë, cë ömwönyögï ökö kï jö kïbëc më dholokekgï, këmagï ëka gin na kwö kïbëc n'onwongo obedo mëgï. ");
INSERT INTO lth_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Ëntö un ënë ïnënö kï wangwu jami na döngö ni kïbëc na Rwoth otio. ");
INSERT INTO lth_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Pï manön, myero ïgwök unu cïk kïbëc na an atye ka mïöwu tin, ëk ibed unu kï tëkö më cïdhö dönyö ïë ëka gamö lobo na un itye ka ngölö kulo Jordan më bedo mewu, ");
INSERT INTO lth_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","ëk ibed unu pï karë na lac ï lobo na Rwoth okwongo më mïö both kwerewu ëka both ëkwaëgï, lobo na mio na cak kï möö kic möl kï ïë. ");
INSERT INTO lth_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Lobo na un itye ka dönyö ïë më gamö ba obedo calö lobo Ejip, kï kanya un ïya unu kï ïë, kanya un ïpïdhö kodhiwu ëka ïönyö unu pii ïë kï cïngwu calö pwodho ngwedo. ");
INSERT INTO lth_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Ëntö lobo na un itye ka cïdhö më ngölö kulo Jordan më gamö ëk obed mewu, obedo lobo n'obedo kitekite ëka ora gïnï, lobo na köth dwong ïë. ");
INSERT INTO lth_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","Obedo lobo na Rwoth Obangawu gwökö; wang Rwoth Obangawu tye ïë ï karë kïbëc, cakërë ï acaki mwaka naka ï ajiki mërë. ");
INSERT INTO lth_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Cë ka un ibino lübö unu cïk kïbëc na an atye ka mïöwu tin—më marö Rwoth Obangawu ëka më tic nïnë kï cwinywu kïbëc ëka kï tipowu kïbëc— ");
INSERT INTO lth_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","cë ën bino mïö köth cwe ï lobowu ï karë mërë kikokome, köth më cwïr ëka köth më oro, ëk ïcök unu cemwu, köngö ölök na nyen ëka möö jeituni. ");
INSERT INTO lth_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Ën bino mïö lum pï dhok na mewu, ëka ibino unu cem cë iyeng unu. ");
INSERT INTO lth_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Gwökërë unu ëk kür ïmïï thamawu öbwölwu më lökërë ökö më wörö obanga nökënë gïnï ëka ryebere pïny ï nyimgï. ");
INSERT INTO lth_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Ka ïtïmö unu nï kömanön, akëmö bino makö Rwoth ï komwu, cë jükö köth ökö ëka mïö köth ba cwe. Lobo ba bino cëgö cem ëka ebino tyekowu ökö kï ï lobo na bër na Rwoth tye ka mïöwu. ");
INSERT INTO lth_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Keth unu köpna ni ï cwinywu ëka ï thamawu; twe unugï na calö anyuth ï ngut cïngwu ëka irukugï ï terinyimwu. ");
INSERT INTO lth_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Pwony unu ëthïnöwu kï cïk nön, twak köp nön bothgï ka in itye pacö, ka in itye iwoth ï yoo, ka ibuto pïny ëka ka in ïya malö kï ï kabuto. ");
INSERT INTO lth_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Cöögï ï kom yen dholokek më udiwu ëka ï kom dhö wangkacwu, ");
INSERT INTO lth_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","ëk nïnöwu ëka më k'ëkwaëwu obed na pol ï lobo na Rwoth okwongere më mïö both kwerewu, pï karë kïbëc na polo pod bino bedo ködë malö ï wi ngöm. ");
INSERT INTO lth_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Ka ïgwökö unu cïk ni kïbëc na an atye ka mïöwu ëk ïlüb unu—më marö Rwoth Obangani, ïlüb unu yodhi mërë kïbëc ëka më moko ï kome— ");
INSERT INTO lth_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","cë Rwoth bino ryëmö rok ni kïbëc na tye ï nyimwu ëka un ibino ryëmö rok na dito ëka na tëk na lööwu. ");
INSERT INTO lth_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Kabedo kïbëc na tyënwu bino nyönö bino bedo mewu. Wang lobowu bino cakërë kï ï thim thuno ködë yo Lebanon ëka cakërë kï ï kulo më Euparate naka yo nam Mediterenian. ");
INSERT INTO lth_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Ngat mörö ope na bino cung ï nyimwu. Rwoth Obangawu bino mïö jïï podho cwiny ëka lworo pïrwu ï kom lobo kïbëc na un ibino cïdhö yo ïë, kite na ën öcïkö ködë. ");
INSERT INTO lth_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Nën, tin an atye ka ketho ï nyimwu gum ëka cen— ");
INSERT INTO lth_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","gum ka ïlübö unu cïk ka Rwoth Obangawu na an atye ka mïöwu tin; ");
INSERT INTO lth_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","ëntö cen bino maköwu ka un ïkwërö lübö cïk ka Rwoth Obangawu ëka ïlökërë unu kï ï yoo na an acïköwu tin nakun ïwörö unu obanga nökënë gïnï na un ba ingeo. ");
INSERT INTO lth_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Ka Rwoth Obangawu dong okelowu ï lobo na un ibino dönyö ïë më gamö bedo mewu, myero ïlam unu gum ï wi kidi Gerijim ëka cen ï wi kidi Ebal. ");
INSERT INTO lth_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Kite na un ingeo ködë nï kite arïö ni tye gïnï yo kuthö kulo Jordan, nakun cwök kï yen më More ï lobo ka jö Kanaan nön na bedo gïnï ï Araba n'opimere kï Gilgal. ");
INSERT INTO lth_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Un ïcwök ngölö kulo Jordan më dönyö gamö lobo na Rwoth Obangawu tye ka mïöwu. Ka ïgamö unu ëka ibedo unu kunön, ");
INSERT INTO lth_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","gwökërë unu më lübö cïk kïbëc na an atye ka pwonyowu tin. ");
INSERT INTO lth_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Man ënë cïk kïbëc na myero ïlüb unu na bër ï karë kïbëc na un ibino bedo ï lobo na Rwoth, Obanga ka kwerewu, ömïöwu më gamö. ");
INSERT INTO lth_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Un myero imuk kabedo kïbëc, kanya Erok na un ïryëmö kï ï lobogï wörö obangagï ïë. Kabedo na tye malö ï wi kite na boco ëka ï thë yen na potgï mar. ");
INSERT INTO lth_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Un myero imumuko keno tyërgï, ngïngïnyö unu kitegï na gïn wörö ëka ïwang unu yen n'ëpïdhö kanya ëwörö obangagï na dhakö ïë n'ecwodo nï Acera; tong unu cal jwogi obangagï ëka ïmïï unu nyïng-gï orweny ökö kï ï kabedo nön gïnï. ");
INSERT INTO lth_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Un myero kür ïwör Rwoth Obangawu ï kite na gïn wörö k'obangagï ködë. ");
INSERT INTO lth_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Ëntö Rwoth Obangawu bino yërö kany mörö kï ï kakawu kïbëc. Kanya ebino wörö nyïngë ïë. Kabedo nön ënë un myero ïcïdh ëka ïwör unu Rwoth Obangawu ïë. ");
INSERT INTO lth_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Kunön ënë un myero iter tyër awanga na mewu, tyërwu, acël më apar na mewu, mïc na pïrë tëk, gin na in ikwongo akwonga më mïö, mïc na cwinyi öpwöyö, ëka kaö më dhokwu ëka rom kï dyegiwu. ");
INSERT INTO lth_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Kunön, un ibino cem ï nyim Rwoth Obangawu, kanya acël kï jö më udiwu ëka ibino bedo unu kï yom cwiny ï kom jami kïbëc na un iketho cïngwu ïë pïën Rwoth Obangawu ömïöwu gum. ");
INSERT INTO lth_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Un myero kür ïtïm kite na onu ëtïmö ködë tin kany, na ngat acëlacël tïmö gin na ën nënö nï bër nïnë, ");
INSERT INTO lth_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","pïën un bara ithuno ï kabedo na myero iywe unu ïë ëka lobo na Rwoth Obangawu tye ka mïöwu më bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Ëntö un ibino ngölö kulo Jordan ëka ibedo unu ï lobo na Rwoth Obangawu tye ka mïöwu më bedo mewu. Ën bino mïöwu iyweo kï ï kom langwu kïbëc n'ögüröwu ëk ibed unu abonge pëkö mörö. ");
INSERT INTO lth_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","Cë un myero ibin unu ï kabedo acël na Rwoth Obangawu öyërö më wörö nyïngë ïë. Kunön ënë un myero ikel jami kïbëc na an acïköwu ïë: tyër awanga na mewu, tyërwu, acël më apar na mewu, ëka mïc na pïrë tëk na un ikwongo akwonga më mïö both Rwoth. ");
INSERT INTO lth_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Un ibino bedo kï yom cwiny ï nyim Rwoth Obangawu, kanya acël k'awopeni, anyirani, etic na cwö, etic na mon ëka jö Lebi na bedo gïnï ï peciwu; po nï jö Lebi ba ebino poko nïgï lobo mörö onyo gin mörö më bedo mëgï. ");
INSERT INTO lth_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Gwökërë unu ëk kür ïtyër tyër awanga na mewu ï kabedo mörö këkën na un ïnënö; ");
INSERT INTO lth_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","ëntö ibino unu tyërö tyër awanga ï kabedo na Rwoth bino yërö kï ï kakawu mörö acël. Kunön ënë un ibino tïmö jami kïbëc na an acïköwu. ");
INSERT INTO lth_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Ëntö un ïtwërö neko leeniwu më pacö më acamawu kï ï peciwu mörö këkën kite na cwinywu mïtö na lübërë kï gum na Rwoth Obangawu mïöwu. Jö kïbëc na cïk ögëngö onyo na cïk ba ögëngö twërö camö gïnï ringo nön, calö ringo egwethe onyo pura. ");
INSERT INTO lth_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Ëntö kür myero ïcam unu remo; öny unu ökö pïny calö pii. ");
INSERT INTO lth_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Kür myero ïcam kï ï peciwu acël më apar më kalwu, onyo köngö ölökwu na nyen, onyo möö jeituniwu, onyo ëthïnö kaö më rom, dyegi ëka dhok, onyo gin mörö këkën na in ikwongo më mïö, onyo mïc na cwinywu öpwöyö, onyo mïc na pïrgï tëk. ");
INSERT INTO lth_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Ëntö un ibino cem ï nyim Rwoth Obangawu ï kabedo na ën bino yërö. Un, awopewu ëka anyirawu, eticwu na cwö ëka eticwu na mon, ëka jö Lebi kï ï peciwu. In myero ibed kï yom cwiny ï nyim Rwoth Obangani ï jami kïbëc na in ibino ketho cingi ïë. ");
INSERT INTO lth_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Myero ïgwökërë unu kür ïwëk unu jö Lebi ata ï karë kïbëc na un ibedo ï lobowu. ");
INSERT INTO lth_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Ka Rwoth Obangawu önyaö wang lobowu kite na ën öcïköwu ködë, cë cwinyi ömïtö ringo ëka ikobo nï, “An amïtö camö ringo,” cë in ïtwërö camö ringo kite na cwinyi mïtö ködë. ");
INSERT INTO lth_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Ka kabedo n'ëwörö nyïng Rwoth Obangawu tye na bor kï kanya un itye ïë, cë un ïtwërö neko leeni kï ï kom rom, dyegi ëka dhokwu na Rwoth ömïöwu, kite na an acïköwu ködë. Un myero ïcam ringo kite na cwinywu mïtö ködë kï ï peciwu. ");
INSERT INTO lth_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Ngat mörö këkën, kadï obedo dhanö na cïk ögëngö onyo na cïk ba ögëngö twërö camö ringo nön, kite na un ïcamö kï ringo egwethe onyo pura. ");
INSERT INTO lth_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Ëntö myero kür ïcam unu remo, pïën kwö tye ï remo ëka kür myero ïcam unu kwö kanya acël kï ringo. ");
INSERT INTO lth_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Kür myero ïcam unu remo; öny unu ökö pïny calö pii. ");
INSERT INTO lth_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Kür ïcam unu remo, ëk nyimwu k'ëthïnöwu na bino lübö körwu obed na leng, pïën nwongo ïtïmö unu gin na tye atïr ï wang Rwoth. ");
INSERT INTO lth_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Ëntö kwany jamini na leng kïbëc ëka gin mörö këkën na in ikwongiri më mïö, ëka ïcïdh ï kabedo na Rwoth bino yërö. ");
INSERT INTO lth_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Mïï unu tyër awanga na mewu ï wi keno tyër ka Rwoth Obangawu, ringo kanya acël kï remo. Remo më tyërwu myero ëöny ï kom keno tyër ka Rwoth Obangawu, ëntö un ïtwërö camö ringo ökö. ");
INSERT INTO lth_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Gwökërë unu më lübö cïk ni gïnï kïbëc na an atye ka mïöwu, ëk nyimwu obed na leng ï karë kïbëc, k'ëthïnöwu na bino lübö körwu, ka un ibino tïmö gin na bër ëka na tye atïr ï wang Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Rwoth Obangawu bino tyeko rok ökö kï ï kabedo na un itye ka cïdhö më gamö lobogï, ka dong ïgamö unu, ëka ibedo unu ïë, ");
INSERT INTO lth_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","kinge na dong etyekogï ökö kï ï nyimwu, gwökërë unu ëk kür imok unu ï owico më penyo pï obanga na gïn wörö ëka ikob unu nï, “Rok ni wörö obangagï nïngö? Wan thon ebino tïmö nï kömanön.” ");
INSERT INTO lth_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Un myero kür ïwör unu Rwoth Obangawu kite na gïn wörö k'obangagï ködë, pïën ï wörö obangagï, gïn tïmö jami kïbëc më kwer na Rwoth ba mïtö. Gïn thon tyërö awope ëka anyiragï ï wi keno tyër ï nyim obangagï. ");
INSERT INTO lth_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Myero ïlüb unu gin na kïbëc na an acïköwu ködë. Kür ïmëd onyo ïkwany mörö kï ïë. ");
INSERT INTO lth_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Ka adwarpïny onyo ngat mörö na leko lek onen ï kinwu cë onyutho niwu anyuth më tango onyo gin më aura, ");
INSERT INTO lth_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","ëka ka anyuth onyo gin më aura ötïmërë, cë adwarpïny okobo nï, “Eru ëwör obanga nökënë” (obanga na un bara ingeo) “ëka eru ëwörgï.” ");
INSERT INTO lth_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","Un myero kür iwiny köp k'adwarpïny onyo alek nön. Rwoth Obangawu tye ka tëmöwu më nënö ka un ïmarö ën kï cwinywu kïbëc ëka kï tipowu kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Myero ïlüb unu Rwoth Obangawu nakun ilworo unu ën. Gwök unu cïk mërë kïbëc ëka ïwör unu ën; tii unu nïnë ëka imok unu ï kome. ");
INSERT INTO lth_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Adwarpïny onyo alek nön myero enek ökö pïën ën opwonyo pwony më jëm ï kom Rwoth Obangawu, n'ökwanyöwu ökö kï ï lobo Ejip ëka ökököwu ökö kï ï lobo më opii. Adwarpïny onyo alek nön ötëmö më lököwu kï ï yoo na Rwoth Obangawu öcïköwu më lübö. Un myero ïkwany gin na rac ökö kï ï kinwu. ");
INSERT INTO lth_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Ka omeru, onyo wodi onyo nyari, onyo dhakö na in ïmarö, onyo okoneni na cwök kodi obwoli ïmüng nakun kobo nï, “Ërö ëcïdhï ëwör obanga nökënë gïnï” (obanga na kwereni onyo in ba ingeo, ");
INSERT INTO lth_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","obanga ka jö n'oguri, kadï tye gïnï na cwök onyo na bor, yaa kï ï ajiki më thwok lobo naka ï thwok lobo nökënë), ");
INSERT INTO lth_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","in myero kür iyee onyo kür iwiny köp mërë. Kür kïca omaki ï kome ëka kür ïmüng nïnë. ");
INSERT INTO lth_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","In myero inek ën ökö. In ënë myero ïcak tingo cingi më neko ën ëka jö kïbëc bino tingo cïng-gï më neko. ");
INSERT INTO lth_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Un ibino celo ën kï kite naka ï thöö, pïën ën ötëmö më lököwu ökö kï ï yoo ka Rwoth Obangawu, n'ökwanyöwu ökö kï ï lobo Ejip, n'obedo kabedo më opii. ");
INSERT INTO lth_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Cë jö Icarael kïbëc bino winyo ëka bedo gïnï kï lworo, ëka ngat mörö ba dökï bino tïmö gin na rac na cal kï man ï kinwu. ");
INSERT INTO lth_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Ka iwinyo unu kï ï pacöwu mörö acël, na Rwoth Obangawu tye ka mïöwu më bedo ïë, nï ");
INSERT INTO lth_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","jö mökö na kitegï reco öya kï ï kinwu ëka öywaö thama ka jö na bedo ï pacö nön nakun kobo gïnï nï, “Eru ëcïdhï ëka ëwör obanga nökënë gïnï” (obanga na un bara ingeo). ");
INSERT INTO lth_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","Cë myero ipeny unu körë na bër ëka ïrang unu kï ryëkö. Ka adyer inwongo unu nï tye atïr ëka enwongo nï gin më kwer ni ötïmërë ï kinwu, ");
INSERT INTO lth_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","cë myero inek unu jö na bedo ï pacö nön kïbëc kï pala abadë. Tyekugï ökö kïbëc, jö kïbëc na tye ïë ëka lïm kïbëc na kwö myero enekgï ökö. ");
INSERT INTO lth_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","Cök unu jami kïbëc na un ïyakö ï dyere pacö kanya jïï gürë ïë, ëka ïwang unu pacö nön kï jami kïbëc na tye ïë na calö tyër awanga both Rwoth Obangawu. Pacö nön bino bedo wi obur na twal na ba dökï ebino gërö. ");
INSERT INTO lth_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","Un myero kür ïkwany unu gin mörö n'onwongo ëtyërö ökö. Cë Rwoth bino kwanyö akëmö mërë na ger rwök ökö, ëka bino tïmö niwu kïca, nakun nyutho cwiny më kïca ï komwu. Cë bino mïö welwu nya na pol, kite na ën öcïkërë ködë kï kwong both kwerewu. ");
INSERT INTO lth_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","Pï manön myero iwiny unu Rwoth Obangawu, mak unu cïk mërë kïbëc na an atye ka mïöwu tin ëka ïtïm unu gin na tye atïr ï nyime. ");
INSERT INTO lth_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Un ibedo ëthïnö ka Rwoth Obangawu. Kür ïngöl unu komwu onyo ïlyël unu terinyimwu pï kwero cöla pï jö n'öthöö. ");
INSERT INTO lth_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","Pïën un ibedo jö na leng both Rwoth Obangawu. Ën öyëröwu kï kom jö kïbëc na bedo gïnï ï wi lobo ëk ibed unu jögë na pïrgï tëk. ");
INSERT INTO lth_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Kür ïcam unu gin mörö më kwer. ");
INSERT INTO lth_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Man ënë leeni na un ïtwërö camögï: dhyang, römö, dyël, ");
INSERT INTO lth_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","aburi, egwethe, rüda, pura, dyegi kï rom na bedo ï wi kite. ");
INSERT INTO lth_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","Un ïtwërö camö lee mörö këkën n'obokoro tyënë opokere ïë arïö ëka na dwongo lum cë nyamö dökï. ");
INSERT INTO lth_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Ëntö leeni na dwongo lum cë nyamö dökï, onyo n'obokoro tyën-gï opokere ïë arïö, na un ba ibino camö ënë: kïnaga, apwöü ëka oduka. Kadï bed nï gïn dwongo lum cë nyamö dökï, gïn ope k'obokoro tyën-gï n'opokere ïë arïö. Gïn obedo gin na cïk ögëngö kï bothwu. ");
INSERT INTO lth_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","Pünö thon obedo gin na cïk ögëngö; kadï bed obokoro mërë opokere ïë arïö, ën ba dwongo lum cë nyamö dökï. Un myero kür ïcam ringogï onyo gudo komgï n'öthöö. ");
INSERT INTO lth_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","Kï kom gin na kwö kïbëc na bedo gïnï ï pii, ïtwërö unu camö mörö këkën na tye k'oguro na bïth ï komgï ëka pök komgï. ");
INSERT INTO lth_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","Ëntö gin mörö këkën na ba tye k'oguro na bïth ï komgï ëka pök komgï, kür ïcam unu; pïën obedo gin na cïk ögëngö niwu më camö. ");
INSERT INTO lth_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Un ïtwërö camö wïnyü mörö këkën na cïk ba ögëngö. ");
INSERT INTO lth_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","Ëntö man ënë wïny na un myero kür ïcam: jür, acuth, acuth na cöl, ");
INSERT INTO lth_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","ocucu, koth okolokol kïbëc, ");
INSERT INTO lth_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","koth akürük kïbëc, ");
INSERT INTO lth_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","udo, tula, awëwët, koth ölwïthölwïth kïbëc, ");
INSERT INTO lth_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","tula na thïthïnö, tula na döngö, tula na tar, ");
INSERT INTO lth_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","tula më thim, jür na döngö, koth wïny më kulo kïbëc, ");
INSERT INTO lth_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","okolokol, öthëba kori ëka olikolik. ");
INSERT INTO lth_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","Kudi kïbëc na tye kï bwomgï obedo gin na cïk ögëngö kï bothwu; kür icamugï. ");
INSERT INTO lth_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Ëntö gin mörö këkën na cïk ba ögëngö na tye kï bwomgï, un ïtwërö camö. ");
INSERT INTO lth_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","Kür ïcam unu gin mörö na in inwongo öthöö kënë. Un ïtwërö mïö both arok mörö na bedo ï pacöwu ëk ën öcam; onyo ïtwërö unu cadhö both welo mörö. Un ibedo jö na leng both Rwoth Obangawu. Kür ited unu ringo athïn dyël kï cak k'aya mërë. ");
INSERT INTO lth_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","Myero iketh unu acël më apar më cem n'öcëk kï ï pwothiwu thenge mwaka kï mwaka. ");
INSERT INTO lth_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","Cam unu acël më apar më kalwu, köngö ölökwu na nyen, möö jeituniwu ëka ëthïn kaö më rom kï dyegi ëka dhokwu ï nyim Rwoth Obangawu ï kabedo na ën bino yërö më wörö nyïngë ïë. Ëk ipwony unu kite më lworo Rwoth Obangawu ï karë kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Ëntö ka kabedo nön tye na bor ëka Rwoth Obangawu ömïöwu gum, ëka ba ïrömö unu yëö acël më apar na mewu (pïën kabedo na Rwoth Obangawu bino yërö më wörö nyïngë ïë tye na bor), ");
INSERT INTO lth_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","cë ïcadh unu acël më apar ëk ïlök unu obed cïlïng ëka iter unu cïlïng ï kabedo na Rwoth Obangawu bino yërö. ");
INSERT INTO lth_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","Tii unu kï cïlïng më wïlö gin mörö këkën na un ïmïtö: dhok, rom, köngö ölök onyo kit köngö mörö na këc, onyo gin mörö këkën na in ïmïtö. Cë in kanya acël kï jö më odi ibino cem unu kunön ï nyim Rwoth Obangawu kï yom cwiny. ");
INSERT INTO lth_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Kür ïwëk jö Lebi na bedo gïnï ï peciwu ata; pïën gïn ba tye kï lobo mörö onyo gin mörö n'obedo mëgï. ");
INSERT INTO lth_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","Ï ajiki më mwaka adek adek, kel unu acël më apar më gin n'öcëk bothwu kïbëc ëk ïkan unu ï peciwu, ");
INSERT INTO lth_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","cë jö Lebi (n'ope gïnï kï lobo mörö n'obedo mëgï), Erok mörö na bedo ï kinwu, ëthïnö kic, ëka mon thöö na bedo gïnï ï peciwu twërö bino gïnï ëka cemo cë yeng, ëk Rwoth Obangawu ömïïwu gum ï tic kïbëc na cïngwu bino gudo. ");
INSERT INTO lth_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","Ï ajiki më mwaka abïrö abïrö un myero ïjal benyiwu ökö. ");
INSERT INTO lth_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Man ënë kite na myero ëtïm ködë: Ngat acëlacël n'ömïö den both awodhe n'obedo dhanö më Icarael bino jalö ökö na twal. Ën ba bino pido banya mërë kï both dhanö më Icarael onyo ömïn mërë, pïën karë ka Rwoth më jalö benyi etyeko kobo ökö. ");
INSERT INTO lth_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","In ïtwërö pido banyani kï both arok, ëntö banya na tye both dhanö më Icarael n'obedo awodhi, myero ïjal ökö. ");
INSERT INTO lth_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","Acan mörö myero kür obed ï kinwu, pïën Rwoth bino mïöwu gum ï lobo na Rwoth Obangawu tye ka mïöwu më bedo mewu, ");
INSERT INTO lth_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","ka ibino tïmö unu gin na Rwoth Obangawu mïtö nakun ïgwökö unu cïk ni kïbëc na an atye ka mïöwu tin. ");
INSERT INTO lth_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Pïën Rwoth Obangawu bino mïöwu gum kite na ën öcïkö ködë ëka un ibino mïö den both rok na pol ëntö ba ibino unu deno gin mörö. Un ibino löönö rok na pol ëntö rok mörö ope na bino löönöwu. ");
INSERT INTO lth_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Ka ngat mörö n'obedo acan ï kin ewodhwu n'obedo jö Icarael tye ï pacö mörö acël ï lobo na Rwoth Obangawu tye ka mïöwu, kür ïmïï unu cwinywu obed na nwang onyo kür ïkwër unu më könyö. ");
INSERT INTO lth_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","Nakaka manön, bed unu kï cwiny na bër ëk ïmïï unu den më gin mörö këkën na ën mïtö. ");
INSERT INTO lth_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Gwokiri kür tham mörö na rac ödöny ï cwinyi ëka ïcak kobo nï, “Mwaka më abïrö, n'obedo mwaka më jalö benyi, onyingo na cwök,” ëka thamani obed na rac ï kom omeru n'obedo acan, cë ïkwër mïö gin mörö. Ën bino kok ï komi ï nyim Rwoth, cë in ibino dökö abal. ");
INSERT INTO lth_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Myero ïmïï köny bothgï abonge cwinyi mörö na rac. Cë Rwoth Obangawu bino mïöni gum ï kom ticni kïbëc ëka jami kïbëc na in ibino ketho cingi ïë. ");
INSERT INTO lth_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Pïën jö n'obedo ëcan ba bino rwenyo kï ï lobowu. Pï manön an acïköwu nï myero ïköny unu utmegowu na tye ï lobowu ëka ëcan na mïtö köny abonge cwiny mörö na rac. ");
INSERT INTO lth_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Ka omeru onyo ameru, n'obedo dhanö më Iburu awodhi öcadhërë bothi ëka otio tic bothi pï mwaka abicël, ï mwaka më abïrö mërë in myero ïwëk ën öcïdh kï kuc. ");
INSERT INTO lth_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","Ka in ïwëkö ën më cïdhö, kür ïmïï öcïdh kï cïngë nono. ");
INSERT INTO lth_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","In ibino mïö ën cïdhö kï jami mökö kï ï kom romni onyo dyegini, kal ëka köngö ölök abonge cwinyi mörö na rac. Mïï bothe kite na Rwoth Obangawu ömïöwu kï gum. ");
INSERT INTO lth_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","Myero ipo nï un onwongo ibedo opii ï lobo Ejip ëka Rwoth Obangawu ökököwu. Manön ënë ömïö an tin amïöwu cïk ni. ");
INSERT INTO lth_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","Ëntö ka aticni okobo nini nï, “An ba amïtö cïdhö kï bothi,” pïën ën mari kï jö më odi ëka ën tye kï kwö na bër kodi, ");
INSERT INTO lth_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","cë ïkwany pïnü ituc kï ithe ï dholokek ëka ën bino bedo aticni pï kwö mërë kïbëc. Tïm nï kömanön pï aticni na dhakö thon. ");
INSERT INTO lth_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Kür ïmïï obed gin na tëk bothi më mïö ën cïdhö abonge cül mörö, pïën tic na ën otio bothi pï mwaka abicël kadhö tic ka ngat n'epango wang arïö. Cë Rwoth Obangawu bino mïö gum ï kom jami kïbëc na in ibino tïmö. ");
INSERT INTO lth_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","Ëthïnö kaö kïbëc n'ënywölögï ï kin dhokni onyo romni kï dyegini, myero un ipok ökö na path pï Rwoth Obangawu. Kür ïmïï kaö më dhokni më tio tic mörö ëka kür ïnyar yer më kaö ka romni. ");
INSERT INTO lth_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","In kanya acël kï jö më odi, ibino camö unu ringogï ï nyim Rwoth Obangawu ï kabedo na ën bino yërö mwaka kï mwaka. ");
INSERT INTO lth_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Ëntö ka kany mörö na rac tye ï kom lee, ongwal onyo wangë öthöö, onyo tye kï kany mörö na rac ï kome, kür myero ïtyër unu both Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","Un ibino camö ï peciwu, kadï bed jö na cïk ögëngö onyo na cïk ba ögëngö twërö gïnï camö, kite na ngat mörö twërö camö kï ringo egwethe onyo pura. ");
INSERT INTO lth_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Ëntö kür myero ïcam unu remo; öny unu ökö pïny calö pii. ");
INSERT INTO lth_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Gwök unu dwe më Abib ëka ikwer unu nïnö më Poth ka Rwoth Obangawu; pïën ï dwe më Abib ënë Rwoth Obangawu ökwanyöwu ködë kï ï Ejip ï kiwor. ");
INSERT INTO lth_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","Un ibino tyërö lee më Poth kï kom rom onyo dyegiwu both Rwoth Obangawu ï kabedo na Rwoth bino yërö ëk nyïngë obed ïë. ");
INSERT INTO lth_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Kür ïcam unu k'ogati n'erubo kï thöbï, ëntö myero ïcam unu k'ogati na thöbï ope ïë pï nïnö abïrö. Man obedo ogati më can na un ïnënö, pïën ïya unu kï ï lobo Ejip nakun ïbünyërë unu abünya. Man bino po wiwu ï kom nïnö më Poth na un ïya ködë kï ï Ejip pï karë kïbëc më kwöwu. ");
INSERT INTO lth_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","Myero thöbï mörö kür enwong bothwu ï lobowu pï nïnö abïrö. Kür ïmïï unu ringo lee mörö na un ïtyërö ï kothyeno më nïnö më acël odong naka kodiko. ");
INSERT INTO lth_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","Myero kür ïtyër unu lee më Poth ï pacö mörö na Rwoth Obangawu tye ka mïöwu, ");
INSERT INTO lth_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","ëntö un myero ïtyër lee më Poth ï kabedo na Rwoth öyërö më wörö nyïngë ïë ï kothyeno, ï caa na ceng dönyö, na ënë karë na un ïya ködë kï ï Ejip. ");
INSERT INTO lth_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","Ted ëka ïcam unu ï kabedo na Rwoth Obangawu bino yërö. Cë kodiko ïdök unu ï këmawu. ");
INSERT INTO lth_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Cam unu ogati na thöbï ope ïë pï nïnö abicël ëka nïnö më abïrö bed unu ï cökërë më wörö Rwoth Obangawu. Kür itii unu tic mörö ï nïnö nön. ");
INSERT INTO lth_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","Ibino unu kwanö cabït abïrö cakërë ï karë na un ïcakö kac. ");
INSERT INTO lth_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","Cë ibino unu kwero Karama më Cabït gïnï ï nyim Rwoth Obangawu kï mïc na cwinywu öpwöyö; ibino mïö unu kï kite na Rwoth Obangawu ömïöwu kï gum. ");
INSERT INTO lth_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","Ibino bedo unu kï yom cwiny ï nyim Rwoth Obangawu ï kabedo na ën bino yërö na calö kabedo n'ëwörö nyïngë ïë. In, ëthïnö awopeni ëka anyira, eticni na cwö ëka eticni na mon, jö Lebi na bedo ï peciwu ëka Erok na bedo ï kinwu, ëthïnö kic ëka mon thöö na bedo gïnï ï kinwu. ");
INSERT INTO lth_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","Po unu nï un onwongo ibedo unu opii ï lobo Ejip ëka myero ïgwökërë unu më lübö cïk ni gïnï. ");
INSERT INTO lth_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","Kinge na dong ityeko unu cökö cemwu ökö kï ï larü më pwodo kal ëka ïbïö unu ölökwu, kwer unu Karama më Bölö pï nïnö abïrö. ");
INSERT INTO lth_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","Bed unu kï yom cwiny ï karamawu; in, awopeni ëka anyira, eticni na cwö ëka eticni na mon, jö Lebi, Erok na bedo ï kinwu, ëthïnö kic ëka mon thöö na bedo ï peciwu. ");
INSERT INTO lth_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","Kwer unu karama pï nïnö abïrö ï nyim Rwoth Obangawu ï kabedo na Rwoth bino yërö. Pïën Rwoth Obangawu bino mïöwu gum ï kom cemwu kïbëc na un ïcëgö ëka ï kom tic më cïngwu cë ibino bedo unu kï yom cwiny rwök. ");
INSERT INTO lth_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","Cwö kïbëc na tye ï kinwu myero obin gïnï ï nyim Rwoth Obangawu wang adek ï mwaka acëlacël ï kabedo na ën bino yërö: ï Kwer më Ogati na Thöbï ope ïë, ï Karama më Cabït gïnï, ëka ï Karama më Bölö gïnï. Ngat mörö myero kür obin ï nyim Rwoth kï cïngë nono. ");
INSERT INTO lth_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","Ngat acëlacël myero okel mïc na lübërë kï kite na Rwoth Obangawu ömïö kï gum ködë. ");
INSERT INTO lth_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","Myero iketh unu ëngöl-köp ëka edite pï kakawu acëlacël ï peciwu kïbëc na Rwoth Obangawu tye ka mïöwu ëka gïn bino ngölö köp ka jïï atïr. ");
INSERT INTO lth_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","Kür ïlök unu pido ka dhanö na köp mërë tye atïr onyo inyuth apokapoka mörö ï kin dhanö. Kür iye ëwïlwu kï lïm, pïën lïm umo wang jö na ryëk ökö cë balö pido ka jö na köpgï tye atïr. ");
INSERT INTO lth_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Ngöl unu köp atïr, ëka köp atïr këkën, ëk ibed unu na kwö ëka ibed unu ï lobo na Rwoth Obangawu tye ka mïöwu. ");
INSERT INTO lth_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","Kür ïpïdh unu yath mörö më wörö obanga na dhakö n'ecwodo nï Acera ï nget keno tyër ka Rwoth Obangawu na un ibino gërö. ");
INSERT INTO lth_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","Kür thon icib unu wïr më kidi më awörö, gin mörö na Rwoth Obangawu ba mïtö. ");
INSERT INTO lth_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","Kür ïtyër thwön onyo römö mörö n'ongwal onyo na kany mörö rac kï ï kome both Rwoth Obangani, pïën bino bedo më kwer bothe. ");
INSERT INTO lth_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","Ka ibino unu nwongo ëcwö onyo dhakö mörö na bedo ï kinwu, na tye ï pacö mörö acël na Rwoth Obangawu ömïöwu, na tïmö gin mörö na rac ï nyim Rwoth Obangawu nakun türö cïkërë mërë, ");
INSERT INTO lth_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","tio both obanga mörö nökënë ëka wörö ceng onyo dwe onyo cër onyo gin mörö këkën na tye ï polo na cïk ka Rwoth ökwërö. ");
INSERT INTO lth_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","Ka iwinyo unu köp nön, myero ïrang unu körë na bër. Ka ïrangö unu ëka imoko unu nï obedo tïm më kwer n'ötïmërë ï lobo Icarael, ");
INSERT INTO lth_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","myero ikel unu ëcwö onyo dhakö nön n'ötïmö tïm na rac ni ï dhö wangkac më pacöwu ëka icel unu dhanö nön kï kite naka ï thöö. ");
INSERT INTO lth_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","Ebino neko dhanö nön pï köp më caden ka jö arïö onyo adek, ëntö ba ebino neko ngat mörö pï köp më caden ka ngat acël këkën. ");
INSERT INTO lth_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","Ecaden ënë bino cakö yuo kite më neko dhanö nön ëka dong jö kïbëc kï körgï. Un myero ïkwany unu gin na rac ökö kï ï kinwu. ");
INSERT INTO lth_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","Ka ekelo pido mörö ï nyimwu na ngölö tëk rwök—twërö bedo önyö remo, adoth onyo lwëny—ter unu pido nön gïnï yo kabedo na Rwoth Obangawu bino yërö. ");
INSERT INTO lth_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","Cïdh both ëlamdhök na gïn ënë jö Lebi ëka both angöl-köp na tye ï dhö tic ï caa nön. Peny kï bothgï cë gïn bino ngölö köp nön nini. ");
INSERT INTO lth_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","Myero ïtïm unu kite na gïn okobo niwu ködë ï kabedo na Rwoth bino yërö. Gwökërë unu më tïmö gin na kïbëc kite na gïn okobo. ");
INSERT INTO lth_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","Tii unu kite na gïn opwonyowu ködë ëka kite na gïn öngölö niwu. Kür ïlökërë unu ökö kï ï ngö na gïn okobo niwu. ");
INSERT INTO lth_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","Ngat mörö na bino kwërö winyo köp k'angöl-köp onyo köp k'alamdhök na tio kunön both Rwoth Obangawu myero enek ökö. Myero ïkwany unu gin na rac ökö kï ï Icarael. ");
INSERT INTO lth_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","Cë jö kïbëc bino winyo ëka bino bedo gïnï kï lworo na ba bino mëdërë gïnï dökï kï kwërö winyo köp. ");
INSERT INTO lth_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Ï karë na un ibino dönyö ï lobo na Rwoth Obangawu tye ka mïöwu ëka ïgamö unu, ibedo unu ïë cë ikobo unu nï, “Eru eketh rwoth na bino löö onu calö rok nökënë n'ögürö onu,” ");
INSERT INTO lth_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","myero ïnën nï iketho unu rwoth na Rwoth Obangawu ënë öyërö. Dhanö na un ibino ketho myero obed kï ï kin utmegowu kikome. Kür iketh unu arok mörö më lööwu na ba obedo dhanö më Icarael. ");
INSERT INTO lth_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Dhanö nön myero kür obed k'angole mërë na pol onyo ömïï jïï ödök gïnï ökö yo Ejip më nwongo angole nökënë gïnï, pïën Rwoth yam okobo niwu nï, “Un myero kür dökï ïdök unu cen yo kunön.” ");
INSERT INTO lth_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Ën myero kür önyöm mon na pol, pïën bino mïö thama mërë lökërë ökö na path. Ën myero thon kür obed kï ryal ëka gol na dwong. ");
INSERT INTO lth_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","Ka ën dong obedo ï wi then ker mërë, ën myero öcöö cïk ni ï buk nakun kwanyö kï ï kom më k'ëlamdhök n'obedo jö Lebi. ");
INSERT INTO lth_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Ën myero ögwök buk ni bothe ëka ökwan pï karë kïbëc më kwö mërë ëk opwony lworo Rwoth Obanga mërë ëka ölüb cïk ni kïbëc na bër. ");
INSERT INTO lth_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","Ën ba bino tingere malö na löö utmego mërë jö Icarael onyo lökërë ökö kï ï cïk. Cë ën ëka ëkwaë mërë bino bedo ï löc ï ker mërë pï karë na lac ï lobo Icarael. ");
INSERT INTO lth_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","Ëlamdhök n'obedo gïnï Jö Lebi, na gïn ënë kaka ka Lebi kïbëc, ba bino bedo gïnï kï dul lobo mörö n'obedo mëgï kï ï kin jö Icarael. Gïn bino camö tyër awanga n'ëmïö both Rwoth, pïën manön ënë gin n'obedo mëgï. ");
INSERT INTO lth_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","Gïn ba bino bedo kï dul lobo mörö më bedo mëgï kï ï kin utmegogï; Rwoth ënë obedo gin n'epoko nïgï kite na ën okobo bothgï. ");
INSERT INTO lth_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","Man ënë bino bedo wang wodhi n'ëlamdhök nwongo kï both jö na bino tyërö gïnï thwön onyo römö: ringo wi bac, ringo lem ëka jamïc kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","Un myero ïmïïgï acaki kac më kalwu, köngö ölök na nyen, möö jeituni ëka yer rom n'ëcakö nyarö kï kom rom na mewu. ");
INSERT INTO lth_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","Pïën Rwoth Obangawu otyeko yërö jö Lebi kï ï kin kakawu kïbëc ëk gïn ëka ëkwaëgï obed jö na tio gïnï kï nyïng Rwoth na twal. ");
INSERT INTO lth_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","Ka Alebi mörö öya kï ï pacö mörö acël na ën bedo ïë na tye kany mörö kï ï Icarael, ëka obino na cwinye öpwöyö yo kabedo na Rwoth bino yërö, ");
INSERT INTO lth_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","ën twërö tic kï nyïng Rwoth Obanga mërë calö utmego mërë kïbëc n'obedo Jö Lebi na tio kunön ï nyim Rwoth. ");
INSERT INTO lth_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","Ën bino nwongo dul më cem na röm kï më ëlamdhök nökënë, kadï bed nï ën onwongo cïlïng kï kom jami na jö më pacö mërë öcadhö. ");
INSERT INTO lth_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Ka dong ïdönyö unu ï lobo na Rwoth Obangawu tye ka mïöwu, myero ïkwër unu lübö kit tïm na reco më kwer na rok na tye kunön tïmö. ");
INSERT INTO lth_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Ngat mörö myero kür enwong kï ï kinwu na wangö wode onyo nyarë calö tyër awanga, na pwonyo bedo dhanö na thyedho onyo tic më jwöjwök onyo na nënö jamïc dyël onyo tïm mörö më jwök, ");
INSERT INTO lth_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","onyo alam wör, gagï, onyo ajwök onyo amak tipo onyo na twak kï tipo ka jö n'öthöö. ");
INSERT INTO lth_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Ngat mörö na tïmö koth tïm ni obedo gin më kwer both Rwoth; pïën tïmö koth tïm më kwer nön ömïö Rwoth Obangawu tye ka ryëmö rok nökënë ökö kï ï nyimwu. ");
INSERT INTO lth_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Myero ibed unu abonge bal mörö ï nyim Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Rok na un ïcwök gamö lobogï më bedo mewu obedo gïnï ketho cwinygï ï köp ka jö na tio tic më jwöjwök onyo jö na thyedho, ëntö Rwoth Obangawu ba ömïöwu twërö më tïmö koth tïm nön. ");
INSERT INTO lth_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Rwoth Obangawu bino mïöwu adwarpïny kï ï kinwu, jö Icarael ewodhwu, na cal köda. Myero iwiny unu ën. ");
INSERT INTO lth_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Man ënë gin na un ïkwaö kï both Rwoth Obangawu ï nïnö na un ïcökërë ï Koreb. Ï karë nön un ikobo unu nï, “Kür ïmïïwa ewiny dwön Rwoth Obangawa dökï, onyo ënën mac mërë na dit rwök pïën wan ebino thöö ökö.” ");
INSERT INTO lth_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Cë Rwoth okobo nïna nï, “Köp na gïn okobo tye na bër. ");
INSERT INTO lth_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","An abino mïögï adwarpïny na cal kodi kï ï kin jö Icarael ewodhgï, ëka an abino ketho köpna ï dhögë. Ën bino kobo nïgï köp kïbëc na an acïkö ën. ");
INSERT INTO lth_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","An kikoma abino penyo ngat mörö na ba bino winyo köpna n'adwarpïny bino kobo kï nyïnga. ");
INSERT INTO lth_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Ëntö adwarpïny na bino poro më twakö gin mörö këkën kï nyïnga na an ba akobo, onyo adwarpïny na kobo köp kï nyïng obanga nökënë gïnï, myero enek ökö.” ");
INSERT INTO lth_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Gwök onyo ibino kobo unu kï ï cwinywu nï, “Kara wan ebino ngeo nïngö nï köp nön ba odonyo kï ï dhö Rwoth?” ");
INSERT INTO lth_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Ka adwarpïny ötïtö köp mörö kï nyïng Rwoth cë köp nön ba ötïmërë onyo ocobere, manön ënë köp na ba odonyo kï ï dhö Rwoth. Adwarpïny nwongo ötwakö köp nön kï wie kënë, myero kür ilwor unu ën. ");
INSERT INTO lth_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","Ka Rwoth Obangawu otyeko rok na lobogï ën tye ka mïöwu, ëka ka dong ïryëmö unugï ökö, cë ibedo unu ï pecigï ëka ï udigï, ");
INSERT INTO lth_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","cë ipok unu peci adek na papath pïrwu ï lobo na Rwoth Obangawu bino mïöwu më bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","Ibino unu puro yoo ëka ipoko unu wang lobo na Rwoth Obangawu bino mïöwu körë adek më bedo mewu, ëk ka ngat mörö oneko dhanö, ën twërö rïngö yo ïë më larö kwö mërë. ");
INSERT INTO lth_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","Man ënë köp na makö ngat n'oneko dhanö ëka rïngö më larö kwö mërë kunön—ngat oneko awodhe na nwongo ba öthëna athëna ëka adïnga mörö thon onwongo ope ï kin-gï cön. ");
INSERT INTO lth_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","Apor mërë, dhanö mörö twërö cïdhö ï bunga gïn k'awodhe më ngölö yen, cë lëb atong n'ëngölö kï yen oore kï ï pur mërë ëka ögöö wi awodhe oneko ökö, dhanö nön twërö rïngö ï pacö mörö acël kï ï kin peci adek nön më larö kwö mërë. ");
INSERT INTO lth_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","Ka onwongo pacö më larö kwö tye acël këkën, caa nökënë twërö bedo na bor n'acül kwor pï athöö twërö bedo kï karë më makö dhanö n'oneko awodhe, kadï bed onwongo ba opore më aneka, pïën adïnga mörö onwongo ope ï kin-gï cön. ");
INSERT INTO lth_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","Man ënë ömïö an acïköwu nï myero ipok unu peci adek pïrwu. ");
INSERT INTO lth_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","Ka Rwoth Obangawu bino nyanö wang lobowu kite na ën öcïkö both kwerewu kï kwong ëka mïöwu lobo kïbëc na ën öcïkö bothgï, ");
INSERT INTO lth_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","un myero ïmëd peci adek nökënë ï kom manön. Ën bino mïöwu lobo ni ka cë un ïlübö cïk kïbëc na an amïöwu—më marö Rwoth Obangawu ëka më lübö yoo mërë. ");
INSERT INTO lth_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","Tïm unu man ëk remo na bal mërë ope kür ööny ï lobowu na Rwoth Obangawu tye ka mïöwu më bedo mewu, ëk bal më önyö remo kür obed ï wiwu. ");
INSERT INTO lth_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","Ëntö ka dhanö mörö onwongo dag awodhe ëka obedo kürö ën më cakö lwëny ï kome, ëka oneko ökö cë dhanö nön örïngö ï pacö mörö acël kï ï kin peci ni, ");
INSERT INTO lth_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","edong më pacö mërë bino oro köp më ömö ën kï kunön cë ëmïö ën ï cïng ngat na myero öcül kwor ëk enek ën thon. ");
INSERT INTO lth_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","Kïca myero kür ömakwu ï kome. Myero ïkwany unu bal më thöö ka dhanö n'ope kï bal ökö kï ï Icarael ëk nyimwu obed na leng. ");
INSERT INTO lth_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","Kür ïköb unu wang ngöm k'awodhi na yam edong oketho cön ï lobo na un ibino leeno na Rwoth Obangawu bino mïöwu më bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","Köp ba bino löönö ngat mörö pï köp ka caden acël pï kit bal mörö na rac na gwök onyo ën öbalö. Myero ëngöl köp pï köp k'ecaden arïö onyo adek. ");
INSERT INTO lth_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","Ka acaden mörö na cwinye rac ocung ëka odotho ngat mörö n'ötïmö bal, ");
INSERT INTO lth_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","jö arïö na tye kï köp ï kin-gï myero obin gïnï ï nyim Rwoth, ï nyim ëlamdhök ëka ï nyim ëngöl-köp n'onwongo tye gïnï ï tic ï caa nön. ");
INSERT INTO lth_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","Ëngöl-köp bino rangö kör köp nön na bër rwök, ka gïn onwongo nï acaden obedo ngat na twot nakun okelo adoth më twodo ï kom ömïn mërë, ");
INSERT INTO lth_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","cë ibino mïö unu ën pwod, pwod na röm kï mana ën onwongo mïtö ketho ï kom ömïn mërë. Un myero ïkwany unu gin na rac ökö kï kinwu. ");
INSERT INTO lth_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","Jö kïbëc bino winyo cë bino bedo gïnï kï lworo ëka gin na rac na cal kï man ba dökï bino tïmërë ï kinwu. ");
INSERT INTO lth_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","Myero kïca kür ömakwu: kwö myero ëcül kï kwö, wang ëcül kï wang, lak ëcül kï lak, cïng ëcül kï cïng, tyën ëcül kï tyën. ");
INSERT INTO lth_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","Ka ïcïdhö unu më lwëny ï kom langwu cë ïnënö unu angole gïnï, gadigadi ëka mwony na pol na löö mewu ökö, kür ibed unu kï lworo ï komgï, pïën Rwoth Obangawu, n'ökwanyöwu kï ï lobo Ejip, bino woth kodwu. ");
INSERT INTO lth_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","Ka dong ïcwök unu cïdhö ïlwëny, alamdhök bino bino anyim ëka twak kï mwony. ");
INSERT INTO lth_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","Ën bino kobo nï, “Winy unu, un jö Icarael: Tin ibino unu cïdhö më lwëny ï kom langwu. Kür ïwëk cwinywu opodhi onyo ibed unu kï lworo; kür komwu ömyël onyo kür ïnyö komwu pï gïn. ");
INSERT INTO lth_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","Pïën Rwoth Obangawu ënë tye ka woth kodwu më cïdhö lwëny pïrwu ï kom langwu më mïöwu löönögï.” ");
INSERT INTO lth_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","Cë edite na löö jö na cïdhö ï dhö lwëny bino kobo bothgï nï, “Ngat mörö tye na pod ögërö ödë na nyen na bara ëlëgö gum ïë? Wëk ën ödök ökö pacö, onyo caa nökënë ën bino thöö ökö ï dhö lwëny cë ngat nökënë ënë bino dönyö më bedo ïë. ");
INSERT INTO lth_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","Ngat mörö tye n'öpïdhö ölök mërë ï pwodho cë pod bara öcakö camö nyige? Wëk ën ödök ökö pacö, onyo caa nökënë ën bino thöö ökö ï dhö lwëny cë ngat nökënë ënë bino camö nyige. ");
INSERT INTO lth_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","Ngat mörö tye na pod öcïkërë kï dhakö cë bara önyömö? Wëk ën ödök pacö, onyo caa nökënë ën bino thöö ökö ï dhö lwëny cë ngat nökënë ënë bino nyömö dhakö nön.” ");
INSERT INTO lth_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","Cë edite thon bino kobo nï, “Ngat mörö tye na lwor onyo na cwinye podho? Wëk ën ödök yo pacö, ëk acikari ewodhe kür cwinygï opodhi kamë ën.” ");
INSERT INTO lth_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","Ï karë n'edite otyeko twak gïnï kï jö na cïdhö ï dhö lwëny, gïn bino yërö edite na tëlö wigï. ");
INSERT INTO lth_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","Ka ïcïdhö unu më celo pacö mörö, un myero kono ïmïï jö më pacö nön karë më penyo pï kuc. ");
INSERT INTO lth_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","Ka gïn oyeo cë öyabö dhö wangkacgï gïnï, jö kïbëc na tye ï pacö nön bino bedo opiiwu ëka bino gïnï tio tic na tëk pïrwu. ");
INSERT INTO lth_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","Ëntö ka gïn ökwërö më penyo pï kuc cë öyërö gïnï më lwëny kodwu, gür unu pacö nön kï mwony na mewu. ");
INSERT INTO lth_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","Ka Rwoth Obangawu ömïögï ï cïngwu, myero inek unu cwö kïbëc na tye ï pacö nön kï pala abadë. ");
INSERT INTO lth_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","Ëntö mon, ëthïnö, dhok ëka kï gin mörö këkën na tye ï pacö, ïtwërö unu tero na calö jami n'ëyakö më bedo mewu. Ëka ïtwërö unu tic kï jami n'ëyakö na Rwoth Obangawu ömïöwu kï both langwu. ");
INSERT INTO lth_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","Man ënë gin na un ibino tïmö ï kom peci kïbëc na tye na bor kodwu ëka ï peci ka rok na ba cwök kodwu gïnï. ");
INSERT INTO lth_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","Ëntö ï peci k'Erok na Rwoth Obangawu bino mïöwu më bedo mewu, kür ïwëk unu gin mörö na yweo odong na kwö. ");
INSERT INTO lth_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","Myero ityek unu jö kïbëc—jö Kit, jö Amor, jö Kanaan, jö Periji, jö Kibi ëka jö Jebuc—kite na Rwoth Obangawu öcïköwu ködë. ");
INSERT INTO lth_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","Ka ïwëkö unu obedo gïnï na kwö, cë gïn bino pwonyowu më lübö gin më kwer kïbëc na gïn tïmö ï wörö obangagï ëka bino mïö ïbalö unu ï kom Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","Ka ïgürö unu pacö mörö pï caa na lac, nakun ïlwënyö unu ëk ïgam, kür ïngöl unu yen k'atong, pïën un ïtwërö camö nyige. Yen thon obedo langwu, na myero ïlwëny unu ï komgï? ");
INSERT INTO lth_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","Un ïtwërö ngölö yen na ba nyakö nyig-gï më acama ëka itii unu ködë më yübö madala ëka pem ëk ökönywu më idho ï pacö nön na lwënyö ï komwu naka ka ïgamö unu pacö nön. ");
INSERT INTO lth_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","Ka ebino nwongo dhanö mörö obuto n'eneko ï lobo na Rwoth Obangawu tye ka mïöwu më bedo mewu, cë ba engeo ngat n'oneko ën, ");
INSERT INTO lth_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","edongwu ëka ëngöl-köpwu bino cïdhö gïnï yökö më pimo bor pïny cakërë kï ï kom lyël naka ï peci na cwök kï kany nön. ");
INSERT INTO lth_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","Cë edong na tye ï pacö na cwök kï kom dhanö n'eneko bino gïnï kelo nya raa na bara otio tic mörö, na bara eketho ayokoth ï ngute më ywaö kwër wanu. ");
INSERT INTO lth_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","Edong më pacö nön bino kelo gïnï nya raa naka ï ora mörö na pige möl, ï ora mörö na naka yam ba epuro, kanya ba ëcwö kodhi mörö ïë. Gïn bino türö ngut nya raa ökö ï ora kunön. ");
INSERT INTO lth_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","Cë ëlamdhök n'obedo Jö Lebi myero obin gïnï anyim, pïën Rwoth Obangawu öyërögï pï tic mërë ëka më lamö gum kï nyïng Rwoth. Gïn myero otyek köp më pido ëka lwëny kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","Edong kïbëc më pacö na cwök kï kanya enwongo kom dhanö n'eneko ïë bino lwökö cïng-gï ï kom nya raa na gïn ötürö ngute ï ora, ");
INSERT INTO lth_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","cë gïn bino kobo nï, “Cïngwa ba öönyö remo ka dhanö ni, onyo wangwa ba önënö ka eneko. ");
INSERT INTO lth_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","Rwoth tïm kïca ï kom jö Icarael na gïn ënë jö na megi na yam ïkökögï. Kür iketh bal më remo ka dhanö n'ope kï bal ï wi lwak na megi.” Cë ïtïm kïca ï kom bal më remo n'ëönyö. ");
INSERT INTO lth_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","Ibino unu lwökö bal më önyö remo kï ï kinwu kömanön, ka ïtïmö unu gin na nen n'atïr kï ï wang Rwoth. ");
INSERT INTO lth_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","Ka ïcïdhö unu më lwëny ï kom langwu, cë Rwoth Obangawu ömïögï ï cïngwu ëka itero unu jö n'ëmakögï kï dhö lwëny, ");
INSERT INTO lth_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","ëka in ïnënö dhakö mörö na leng kï kin jö n'ëmakö kï dhö lwëny cë cwinyi ömarö, in ïtwërö tero ën ëk obed dhaköni. ");
INSERT INTO lth_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","In myero ikel ën yo pari ëka ïlyël wie cë ïngad lwëtë ökö. ");
INSERT INTO lth_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","Göny böng mërë n'onwongo ën oruko ï karë n'ëmakö ködë kï ï dhö lwëny. Kinge na ën dong obedo pari ëka okumo pï apap mërë ëka aya mërë pï dwe acël, cë in ïtwërö cïdhö bothe më bedo cwörë ëka ën bino bedo dhaköni. ");
INSERT INTO lth_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","Ka inwongo nï cwinyi ba dök mïtö ën, cë ïtwërö wëkö ën cïdhö yo kanya cwinye mïtö. In myero kür ïcadh ën onyo iter ën na calö opii, pïën in dong ïlanö ën ökö. ");
INSERT INTO lth_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","Ka ëcwö mörö tye kï mon arïö, ëka marö ngat acël na löö nökënë ca, ëka mon arïö ni kïbëc önywölö gïnï ëthïnö awope nïnë, ëntö athïn kaö obedo wod ka dhakö na ën ba marö, ");
INSERT INTO lth_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","ka ëcwö ni tye ka poko jami mërë both awope mërë, myero ën kür ömïï twërö k'athïn kaö both wod ka dhakö na ën marö, nakaka wode kikome n'obedo kaö, wod ka dhakö na ën ba marö. ");
INSERT INTO lth_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","Ëntö ën myero onyuth athïn kaö ka dhakö mërë na ën ba marö, nakun doko gin n'epoko nïnë wang arïö kï kom jami na ën tye ködë kïbëc. Athïn awobi nön ënë obedo acaki më tëkö k'apap mërë. Twërö k'athïn kaö obedo mëgë. ");
INSERT INTO lth_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","Ka dhanö mörö tye kï wode na ngute nwang ëka obedo ngat na jëm, na ba winyo dhö apap mërë onyo aya mërë, kadï bed ëgöö ën kï lüth, ba bino winyogï. ");
INSERT INTO lth_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","Apap mërë ëka aya mërë bino makö gïnï ën ëka etero both edong ï dhö wangkac më pacö na ën bedo ïë. ");
INSERT INTO lth_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","Gïn bino kobo both edong nï, “Wodwa ni ngute nwang ëka obedo ngat na jëm. Ën ba wöröwa. Ën obedo ngat n'owor ëka amërö.” ");
INSERT INTO lth_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","Cë jö më pacö nön kïbëc bino celo ën kï kite naka thöö. Un myero ïkwany gin na rac ökö kï ï kinwu. Jö Icarael kïbëc bino winyo cë bedo gïnï kï lworo. ");
INSERT INTO lth_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","Ka dhanö mörö ötïmö bal na mïö ën nwongo pwod më thöö, ëka ïngabö unu ën malö ï wi yath, ");
INSERT INTO lth_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","un myero kür ïwëk kome öngabërë ï wi yath naka kiwor. Ik unu kome ökö ï nïnö nön, pïën dhanö mörö n'ëngabö kome ï wi yath bedo dhanö n'Obanga ölamö. Un myero kür ïbal lobowu na Rwoth Obangawu tye ka mïöwu më bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","Ka in ïnënö thwön onyo römö k'omeru n'orwenyo ökö ata, kür ïnën anëna; myero ïdwök yo both omeru. ");
INSERT INTO lth_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","Ka won mërë ba bedo na cwök kodi onyo ba ingeo won mërë, cë in myero iter lee n'orwenyo nön yo pari ëka ïgwök naka ka won mërë obino na tye ka rangö. Cë ïmïï bothe. ");
INSERT INTO lth_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","In ibino tïmö nï kömanön ï kom kana mërë, böng mërë, onyo gin mörö këkën n'omeru orwenyo ëka in inwongo; in kür ïnën anëna. ");
INSERT INTO lth_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","Ka in inwongo kana onyo thwön k'omeru n'opodho pïny ï nget yoo, kür ïnën anëna, ëntö köny ën më tingo malö ëk ocung kï tyënë. ");
INSERT INTO lth_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","Dhakö myero kür oruk böng ka cwö, onyo ëcwö kür oruk böng ka mon, pïën dhanö n'ötïmö kömanön bedo më kwer both Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","Ka in tye ka woth ï yoo cë icop ï kom öd wïnyü ï nget yoo, onyo ï wi yath onyo ï ngöm, ëka mïn wïnyü obuto ï kom ëthïnë onyo ï kom töngë, kür ïmak mïn mërë kanya acël k'ëthïnë. ");
INSERT INTO lth_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","In ïtwërö tero ëthïnë, cë ïwëkö mïn mërë cïdhö, ëk nyimwu obed na leng ëka ibed unu na kwö pï karë na lac. ");
INSERT INTO lth_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","Ka in ïgërö öt na nyen, myero iketh gin mörö na jükö podho ka dhanö orum wi öt ëk kür okel bal më önyö remo ï odi ka ngat mörö opodho kï ï wi öt. ");
INSERT INTO lth_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","Kür ïcwö kodhi na papath arïö ï pwodho ölökni, ka ïcwö, mïö gin na kïbëc n'öcëk ïë myero eter ï öt k'Obanga, gin na in ïcwö ïë thon naka kï nyig ölök. ");
INSERT INTO lth_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","Kür itwe thwön ëka kana kanya acël më pur. ");
INSERT INTO lth_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","Kür iruk böngü n'obedo yer ëka böngü na pwöth n'ëkwö kanya acël. ");
INSERT INTO lth_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","Myero ïkwö töl tacël na lyero ï twok böngü angwën na in iruko. ");
INSERT INTO lth_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","Ka ëcwö mörö önyömö dhakö cë obedo ködë, cë ökwërö ën ökö, ");
INSERT INTO lth_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","cë okobo köp na rac ï kome, na balö nyïng dhakö nakun kobo nï, “An anyömö dhakö ni, ëntö ï karë na an abedo ködë, anwongo gin mörö ope na nyutho nï ën bara ongere k'ëcwö.” ");
INSERT INTO lth_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","Cë apap ëka aya ka dhakö nön bino kelo gïnï gin na nyutho nï ën bara ongere k'ëcwö both edong ï dhö wangkac më pacö. ");
INSERT INTO lth_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","Apap mërë bino kobo both edong nï, “An amïö nyara both ëcwö ni ëk önyöm ëntö ökwërö nyara ökö. ");
INSERT INTO lth_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","Kobedini ën okelo köp më adoth ï kome nakun kobo nï, ‘An anwongo gin mörö ope na nyutho nï ën bara ongere k'ëcwö.’ Ëntö man ënë gin na nyutho nï nyara bara ongere k'ëcwö.” Cë enyodo mërë bino yarö böngü ï nyim edong më pacö. ");
INSERT INTO lth_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","Edong më pacö bino tero ëcwö nön ëka epwodo. ");
INSERT INTO lth_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","Gïn bino ngölö nïnë cül më ryal mia acël. Gïn bino mïö both apap ka dhakö, pïën ëcwö nön öbalö nyïng nya jö Icarael na bara ongere k'ëcwö. Cë ën bino mëdërë më bedo dhakö mërë; ëka myero kür ökwër dhakö nön pï karë më kwö mërë kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","Ëntö ka köp më adoth nön tye atïr, ëka gin mörö ope n'enwongo na nyutho nï dhakö nön bara ongere k'ëcwö, ");
INSERT INTO lth_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","cë jö më pacö nön bino kelo dhakö nön ï dholokek më öt k'apap mërë ëka kï kunön cwö më pacö nön bino celo ën kï kite naka thöö. Ën ötïmö gin më lewic ï Icarael nakun obedo tïmö tïm më ölyang ï karë na ën bedo ï öt k'apap mërë. Un myero ïkwany unu gin na rac ökö kï ï kinwu. ");
INSERT INTO lth_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","Ka ebino nwongo ëcwö mörö n'obedo kï dhakö ka ngat nökënë, ëcwö n'obedo ködë ëka dhakö nön myero enekgï ökö. Un myero ïkwany unu gin na rac ökö kï ï Icarael. ");
INSERT INTO lth_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","Ka ëcwö mörö kï ï pacö oromo kï nyakö na bara ongere k'ëcwö, n'onwongo öcïkërë kï ngat mörö më anyöma cë obedo ködë, ");
INSERT INTO lth_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","un ibino tero jö arïö nön kïbëc yökö ï dhö wangkac më pacö nön, ëka ecelogï kï kite naka ï thöö. Eneko nyakö nön pïën ba ögöö oduru ëk ëkönyë ëka eneko ëcwö pïën ötürö cïk më bedo kï dhakö ka ngat nökënë. Un myero ïkwany unu gin na rac ökö kï kinwu. ");
INSERT INTO lth_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","Ëntö ka ëcwö mörö oromo kï nyakö n'öcïkërë kï ngat mörö më anyöma ï dye thim cë obedo ködë tëtëk, ëcwö këkën n'ötïmö gin ni ënë ebino neko. ");
INSERT INTO lth_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","Kür ïtïm unu gin mörö ï kom nyakö; pïën ën ba öbalö bal mörö na römö ngölö nïnë thöö. Köp ni röm kï köp k'ëcwö n'ölwënyö ï kom awodhe cë oneko ökö, ");
INSERT INTO lth_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","pïën ëcwö oromo kï dhakö n'ëcïkërë ködë më anyöma ï thim cë obedo ködë tëtëk ëka dhakö ögöö oduru, ëntö ngat mörö onwongo ope kunön na twërö könyö ën. ");
INSERT INTO lth_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","Ka ëcwö mörö oromo kï nyakö na bara ongere k'ëcwö n'onwongo ba öcïkërë më anyöma ëka obedo ködë tëtëk cë engeogï, ");
INSERT INTO lth_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","ën bino cülö apap ka nyakö ryal pyer abic. Ën myero önyöm nyakö nön pïën ën ötïmö bal ï kome. Ën ba bino kwërö dhakö nön pï karë më kwö mërë kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","Dhanö mörö kür obed kï dhakö k'apap mërë; ën myero kür ömïï lewic ï kom apap mërë. ");
INSERT INTO lth_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","Dhanö n'edino onyo n'ëngölö kome më cwö ökö ba bino dönyö ï athuko ka Rwoth. ");
INSERT INTO lth_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","Dhanö n'ënywölö ï lek ba bino dönyö ï athuko ka Rwoth, kadï naka ëkwaëgï më apar mörö ba bino dönyö ï athuko ka Rwoth. ");
INSERT INTO lth_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","Ngat mörö n'obedo dhanö më Amon onyo dhanö më Moab ba bino dönyö ï athuko ka Rwoth, kadï naka ëkwaëgï më apar, mörö ba bino dönyö ï athuko ka Rwoth. ");
INSERT INTO lth_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","Pïën gïn ba obino më romo kodwu kï cem ëka kï pii ï karë na un itye ka bino kï ï Ejip. Gïn obino opango Balaam wod ka Beor kï ï Petor na tye ï Aram Naaraim ëk obin ölamwu. ");
INSERT INTO lth_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","Ëntö Rwoth Obangawu ökwërö winyo köp ka Balaam ökö. Ën obino ölökö köp më lamöwu ödökö më gum pïrwu, pïën Rwoth Obangawu maröwu. ");
INSERT INTO lth_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","Kür ïtïm unu gin mörö na kelo nïgï kuc kodwu ëka lönyö, pï karë më kwöwu kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","Kür ïcaa unu dhanö mörö më Edom, pïën gïn obedo wat kodwu. Kür ïcaa unu dhanö mörö më Ejip, pïën ibino ibedo unu Erok ï lobogï. ");
INSERT INTO lth_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","Ëthïnögï na gïn bino nywölö n'obedo ëkwaëgï më run më adek bino dönyö ï athuko ka Rwoth. ");
INSERT INTO lth_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","Ka ïcïdhö unu më lwëny kï langwu, gwökërë unu kï ï kom gin mörö na ba leng. ");
INSERT INTO lth_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","Ka ëcwö mörö tye ï kinwu na cïk ögëngö pïën oleko lek më kiwor, ën myero öcïdh yökö ëka obed kunön. ");
INSERT INTO lth_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","Ëntö ka pïny dong yutho ën myero ölwökërë, ëka ka ceng ödönyö ën twërö dwogo ï laï. ");
INSERT INTO lth_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","Yüb unu kany mörö yökö ï nge laï kanya un ibino cïdhö ïë më könyërë. ");
INSERT INTO lth_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","Ngat acëlacël myero obed kï gin mörö më künyö pïny ï kin jami më lwënywu, ëka ka ikonyiri, küny bur ëk ium ökö. ");
INSERT INTO lth_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","Pïën Rwoth Obangawu wowotha ï dye laïwu më gwököwu ëka më mïö langwu ï cïngwu. Laïwu myero obed na leng ëk kür önën gin mörö na ba leng cë lökërë ökö kï bothwu. ");
INSERT INTO lth_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","Ka opii mörö örïngö ökö kï both adwong mërë cë opono bothi, kür ïmïï ën ödök both adwong mërë. ");
INSERT INTO lth_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","Mïï ën obed ï kinwu kany mörö këkën na cwinye mïtö ëka ï pacö mörö këkën na ën öyërö. Kür ïdïï ën. ");
INSERT INTO lth_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","Dhanö mörö më Icarael n'obedo ëcwö onyo dhakö myero kür obed ngat na tïmö tïm më ölaya ï öt wörö jwök. ");
INSERT INTO lth_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","Kür ikel unu cïlïng më cül n'enwongo kï kom tïm më ölaya n'öya kï both dhakö onyo ëcwö ï öt ka Rwoth Obangawu më cülö kwong mörö, pïën jami nön kïbëc obedo gin më kwer both Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","Kür ïmïï dhanö më Icarael awodhi öcül magoba pï cïlïng, cem onyo gin mörö këkën na twërö kelo magoba na ën odeno. ");
INSERT INTO lth_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","In ïtwërö mïö arok cülö magoba ëntö pathï dhanö më Icarael awodhi. Gwök unu cïk ni ëk Rwoth Obangawu ömïïwu gum ï kom gin na kïbëc na un ibino ketho cïngwu ïë ï lobo na un itye ka dönyö më gamö bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","Ka ikwongo kwong both Rwoth Obangani, kür igaliri më cobo, pïën Rwoth Obangawu bino penyoni pïrë ëka ibino bedo ngat n'ötïmö bal. ");
INSERT INTO lth_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","Ëntö ka ba ikwongo kwong, ba ibino bedo ngat n'ötïmö bal. ");
INSERT INTO lth_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","Ëntö gin mörö këkën na donyo kï ï dhogi myero ïnën nï icobo, pïën in ikwongo kwong keni kï dhogi both Rwoth Obangani. ");
INSERT INTO lth_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","Ka ïdönyö ï pwodho ölök k'awodhi, in ïtwërö camö nyig ölök kïbëc na cwinyi mïtö, ëntö kür iketh mörö ï adïtani. ");
INSERT INTO lth_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","Ka ïdönyö ï pwodho kal k'awodhi, in ïtwërö rïdhö kal kï cingi, ëntö kür ïkaa kal kï pala. ");
INSERT INTO lth_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","Ka ëcwö mörö önyömö dhakö na ba yomo cwinye pïën onwongo gin mörö na rac ködë, ëcwö nön twërö cöö waraga më këthö nyom, cë mïö ï cïngë ëka ryëmö ën ökö kï ï ödë. ");
INSERT INTO lth_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","Cë kinge na ën dong öya ökö kï ï ödë, ën dökö dhakö k'ëcwö nökënë. ");
INSERT INTO lth_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","Ka cwörë më arïö ba mïtö ën, ëcwö nön cöö waraga nïnë më këthö nyom, cë mïö ï cïngë, ëka ryëmö ökö kï ï ödë, onyo ka cwörë më arïö nön öthöö ökö, ");
INSERT INTO lth_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","cwörë më acël n'ökwërö ën ba dök bino nyömö ën më bedo dhakö mërë kinge na ën dong öbal ökö. Manön bino bedo gin më kwer both Rwoth. Kür ikel unu bal ï lobo na Rwoth Obangawu tye ka mïöwu më bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","Ka ëcwö mörö pod onyomo anyoma, myero kür ëmïï öcïdhï ï dhö lwëny onyo ëmïï tic ka lwak mörö nökënë. Ën myero obed mwaka acël nakun bedo parë ëk okel yom cwiny both dhakö na ën önyömö. ");
INSERT INTO lth_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","Kür ïkwany pong onyo nya pong rego na calö gin n'ejengo ï den. Pïën manön bino bedo calö kwanyö kwö ka dhanö më bedo gin n'ejengo. ");
INSERT INTO lth_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","Ka enwongo ngat mörö kwalö dhanö më Icarael awodhe, ëka tero na rac na calö opii onyo cadhö ën. Ngat n'ökwalö dhanö nön myero enek ökö. Un myero ïkwany gin na rac ökö kï ï kinwu. ");
INSERT INTO lth_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","Na makö köp ï kom two dhöbü, gwökërë unu rwök ëk ïlüb unu gin n'ëlamdhök n'obedo Jö Lebi okobo niwu. Myero ïlüb unu na bër ngö na an acïkögï. ");
INSERT INTO lth_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","Po unu ï kom ngö na Rwoth Obangawu ötïmö ï kom Miriam kï ï wanga yoo kinge na un ïya kï ï Ejip. ");
INSERT INTO lth_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","Ka ïmïö gin mörö më adena both awodhi, kür ïdöny ï ödë më kwanyö gin mörö n'ëmïö bothi na calö gin n'ejengo. ");
INSERT INTO lth_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","In myero ibed yökö, ëk dhanö na in ïmïö gin mörö më adena okel gin na ën ojengo bothi yökö. ");
INSERT INTO lth_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","Ka dhanö nön obedo acan, kür ïmïï böngü na ën ojengo obut bothi. ");
INSERT INTO lth_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","Dwök böngü mërë na ceng bara ödönyö ëk oumere ködë. Cë ën bino pwöyöni ëka ebino kwanö na calö tic n'atïr ï nyim Rwoth Obangani. ");
INSERT INTO lth_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","Kür ïdïï atic na in ipango n'obedo acan ëka na mïtö köny, kono kadï atic nön obedo dhanö më Icarael awodhi onyo arok na bedo ï pacöwu mörö acël. ");
INSERT INTO lth_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","In myero ïmïï cül mërë ï nïnö nön na bara ceng ödönyö, pïën ën obedo acan ëka geno gin nön. Ka ba ïmïö, ën bino kok ï komi both Rwoth, ëka ibino bedo ngat n'ötïmö bal. ");
INSERT INTO lth_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","Ba ebino neko enyodo pï bal k'ëthïnögï, onyo ba ebino neko ëthïnö pï bal k'enyodogï. Ngat acëlacël ebino neko pï bal mërë. ");
INSERT INTO lth_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","Kür ïbal pido k'arok onyo k'athïn kic mörö, onyo iter böngü ka dha thöö na calö gin n'ejengo. ");
INSERT INTO lth_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","Po unu nï un onwongo ibedo opii ï lobo Ejip ëka Rwoth Obangawu obino ökököwu kï kunön. Manön ënë ömïö an acïköwu më lübö cïk ni. ");
INSERT INTO lth_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","Ka in itye ka kaö kac kï ï pwodhoni, ëka ïnënö körë mörö na ba ïkaö, kür ïdök cen më cïdhö kaö dökï. Myero ïwëk odong pï Erok, ëthïnö kic ëka mon thöö, ëk Rwoth Obangawu ömïïwu gum ï kom tic kïbëc më cïngwu. ");
INSERT INTO lth_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","Ka ïpüdö nyig jeitunini kï ï wi yath, kür dökï ïdök cen më püdö man odong ï wi yath. Myero ïwëk nyig jeituni n'odong pï Erok, ëthïnö kic ëka mon thöö. ");
INSERT INTO lth_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","Ka ïpüdö nyig ölök kï ï pwodho ölökni, kür dökï ïdök cen më püdö man odong. Myero ïwëk nyig ölök n'odong pï Erok, ëthïnö kic ëka mon thöö. ");
INSERT INTO lth_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","Po unu nï un onwongo ibedo opii ï lobo Ejip. Manön ënë ömïö an acïköwu më lübö cïk ni. ");
INSERT INTO lth_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","Ka jö arïö tye gïnï kï köp ï kin-gï, gïn myero oter ï nyim okiko ëka ëngöl-köp bino ngölö köp cë gönyö gïnï dhanö n'ope kï bal ëka ngölö köp ï wi dhanö n'öbalö. ");
INSERT INTO lth_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","Cë ka dhanö n'öbalö pore nï myero ëgöö, angöl-köp bino mïö ën buto pïny ëka ëgöö ï nyime kï wel lüth n'oporo bal mërë. ");
INSERT INTO lth_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","Angöl-köp twërö mïö ëgöö lüth pyer angwën ëntö kür ökadh manön. Ka ëgöö na kadhö, ömïnwu ebino lanö ï wangwu. ");
INSERT INTO lth_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","Kür itwe dhö thwön ka tye ka nyönö kal më apwoda. ");
INSERT INTO lth_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","Ka utmego na bedo gïnï kanya acël ëka acël kï kin-gï öthöö ökö abonge athïn mörö, myero cii athöö kür önyömërë kï ngat mörö na ba obedo dhanö më dholokek. Ömïn cwörë ënë bino tero ën na calö dhakö mërë ëka cobo tic më bedo cwörë nakaka ömïn mërë. ");
INSERT INTO lth_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","Wode na ën bino nywölö më acël ebino cakö nyïngë kï nyïng ömïn mërë n'öthöö, ëk nyïngë kür orweny ökö kï ï Icarael. ");
INSERT INTO lth_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","Ëntö ka ömïn athöö ba mïtö tero cii ömïn mërë, dha thöö bino cïdhö ï dhö wangkac më pacö both edong ëka kobo nï, “Ömïn cwöra ökwërö mïö nyïng ömïn mërë nen ï Icarael; ën ba mïtö cobo tic më bedo cwöra nakaka ömïn mërë.” ");
INSERT INTO lth_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","Cë edong më pacö mërë bino cwodo ömïn athöö ëka ëtwak ködë. Ka ocere nakun kobo nï, “An ba amïtö tero ën,” ");
INSERT INTO lth_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","cii ömïn athöö bino cïdhö bothe ï nyim edong cë wödhö wör acël ökö kï ï tyën ömïn cwörë, ngülö laö dhögë ï wangë ëka kobo nï, “Man ënë gin n'ebino tïmö ï kom dhanö mörö na ba bino nywölö ëthïnö ka wi ömïn mërë.” ");
INSERT INTO lth_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","Dholokek ka dhanö nön ebino cwodo kï ï Icarael nï, “Öt ka dhanö n'ëwödhö wörë ökö kï ï tyënë.” ");
INSERT INTO lth_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","Ka cwö arïö tye ka lwëny ëka dhakö ka ngat acël obino më könyö cwörë kï both ngat na tye ka lwëny ködë, ëka otero cïngë cë ömakö kome më cwö, ");
INSERT INTO lth_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","un myero ingun unu cïng dhakö nön ökö. Kür kïca ömakwu ï kome. ");
INSERT INTO lth_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","Kür ibed unu kï gin më pimo jami arïö ï ocwewu—acël na pëk ëka acël na yot. ");
INSERT INTO lth_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","Kür ibed unu kï gin më pimo jami ï ödwu—acël na thwönë ëka acël na tïdï. ");
INSERT INTO lth_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","Myero ibed unu kï gin më pimo jami na bër, na pimo jami ï wangë, ëk ibed unu ï lobo na Rwoth Obangawu tye ka mïöwu pï karë na lac. ");
INSERT INTO lth_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","Pïën jö kïbëc na tïmö koth tic ni, jö na tïmö gin na ba tye atïr, gïn obedo gin më kwer kï both Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","Po unu ï kom gin na jö Amalek ötïmö ï komwu ï yoo ï karë na un ïya ökö kï ï Ejip. ");
INSERT INTO lth_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","Gïn ölwënyö ï komwu ï karë na un idhero rwök na tëkö mörö ope ï komwu. Gïn oneko jö kïbëc n'onwongo odong cen nakun ba lworo gïnï Obanga. ");
INSERT INTO lth_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","Pï manön, ka Rwoth Obangawu ömïöwu iyweo kï ï kom langwu kïbëc n'ögüröwu ï lobo na Rwoth Obangawu tye ka mïöwu ëk ïgam unu më bedo mewu, myero inek unu jö Amalek kïbëc ëk ngat mörö kür dökï opo ï komgï na twal kï ï thë polo. Kür ïmïï wiwu owil! ");
INSERT INTO lth_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","Ka un ïdönyö ï lobo na Rwoth Obangawu tye ka mïöwu na calö mewu ëka ïgamö unu ökö cë ibedo unu ïë, ");
INSERT INTO lth_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","kwany unu wi cem mökö kï ï kom cem kïbëc n'öcakö cëk kï ï ngöm na Rwoth Obangawu tye ka mïöwu ëka ikethgï ï adïta. Cë iter unu ï kabedo na Rwoth Obangawu bino yërö më wörö nyïngë ïë. ");
INSERT INTO lth_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","In myero ïcïdh both alamdhök na tye ï dhö tic ï caa nön ëka ikob nïnë nï, “Tin dong an atuco both Rwoth Obangani nï an athuno ï lobo na Rwoth okwongo both kwerewa më mïöwa.” ");
INSERT INTO lth_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","Cë alamdhök bino gamö adïta kï bothi ëka ketho ï nyim keno tyër ka Rwoth Obangani. ");
INSERT INTO lth_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","Cë in ibino kobo ï nyim Rwoth Obangani nï, “Kwaröna onwongo obedo dhanö më Aram, n'onwongo wotho awotha. Ën obino öcïdhö yo Ejip kï jö na nönök ëka obedo kunön cë ödökö rok na dit, na tëk ëka n'önya gïnï na pol. ");
INSERT INTO lth_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","Ëntö jö Ejip obedo ka tic ködwa na rac rwök ëka ömïöwa ëlïmö can, nakun ëmïöwa etio tic na tëk. ");
INSERT INTO lth_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","Cë wan ekok both Rwoth, Obanga ka kwerewa, ëka Rwoth owinyo kokowa cë önënö pëköwa, tic na tëk n'eketho ï komwa ëka kite n'ëdïöwa ködë. ");
INSERT INTO lth_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","Cë Rwoth ökwanyöwa ökö kï ï Ejip kï twër më badë ëka kï tëkö mërë, kï tïm na kelo lworo na thwönë, k'anyuth më tango ëka gin më aura gïnï. ");
INSERT INTO lth_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","Ën okelowa naka ï kabedo ni ëka ömïöwa lobo ni, lobo na mio na cak kï möö kic möl kï ïë. ");
INSERT INTO lth_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","Cë kobedini dong, an akelo wi cem n'öcakö cëk kï ï ngöm na in Rwoth ïmïa.” Cë in myero iketh adïta ï nyim Rwoth Obangani ëka ïwör ën. ");
INSERT INTO lth_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","In ibino bedo kï yom cwiny kanya acël kï jö Lebi ëka Erok na bedo gïnï ï kinwu kï gin na kïbëc na bër na Rwoth Obangani ömïö bothi ëka jö më odi. ");
INSERT INTO lth_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","Ka in ityeko mïö acël më apar më gin n'öcëk ï mwaka më adek mërë, mwaka më mïö acël më apar, in ibino mïö both jö Lebi, Erok, ëthïnö kic ëka mon thöö ëk gïn obed kï gin më acama na römö mïögï yeng kï ï peciwu. ");
INSERT INTO lth_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","Cë in ibino kobo ï nyim Rwoth Obangani nï, “An dong atyeko kwanyö acël më apar ökö kï ï öda ëka amïö both jö Lebi, Erok, ëthïnö kic ëka mon thöö kite na in ïcïka ködë. An ba atürö onyo wia ba owil ï kom cïkni gïnï. ");
INSERT INTO lth_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","An ba acamö acël më apar ï karë n'onwongo an akwero cöla, onyo kwanyö mörö kï ïë ï karë na cïk ögënga, onyo tyërö both tipo ka ngat n'öthöö. An awinyo köp ka Rwoth Obangana; an atïmö jami kïbëc na in ïcïka ïë. ");
INSERT INTO lth_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","Nën pïny kï ï kabedoni na leng na tye ï polo, mïï gum ï kom jogi Icarael ëka ï kom lobo na in ïmïöwa kite na in icikiri ködë kï kwong both kwerewa, lobo na mio na cak kï möö kic möl kï ïë.” ");
INSERT INTO lth_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","Tin Rwoth Obangawu öcïköwu më lübö cïk mërë kïbëc. Pï manön myero ïgwökërë unu më lübö kï cwinywu kïbëc ëka kï tipowu kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","Tin dong ituco köp ï kom Rwoth nï ën obedo Obangani, ëka ibino lübö yoo mërë nakun ïgwökö cïk mërë kïbëc, ëka nï ibino winyo köp mërë. ");
INSERT INTO lth_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","Rwoth otuco köp ï komwu nï tin un ibedo jögë na pïrgï tëk kite na ën öcïkërë ködë, ëka un myero ïgwök cïk mërë kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","Ën otuco nï ebino mïöwu bedo rok na tëk na löö rok nökënë kïbëc na ën eketho ëka un ibino mïö pak kï wörö ï nyïngë. Un ibino bedo jö na leng both Rwoth Obangawu kite na ën öcïkërë ködë. ");
INSERT INTO lth_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","Muca ëka edong më Icarael okobo gïnï both jïï nï, “Gwök unu cïk ni kïbëc na an tin atye ka mïöwu. ");
INSERT INTO lth_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","Ï nïnö na un ibino ngölö kï kulo Jordan më dönyö ï lobo na Rwoth Obangawu bino mïöwu, un ibino cicibo kite na thwon cë ipu unu komgï kï rangi na tar. ");
INSERT INTO lth_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","Cöö köp kïbëc më cïk ni ï komgï ka ipoth unu yo löka më dönyö ï lobo na Rwoth Obangawu tye ka mïöwu, lobo na mio na cak kï möö kic möl kï ïë, kite na Rwoth, Obanga ka kwerewu, öcïkërë kodwu. ");
INSERT INTO lth_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","Ka dong ïngölö unu kulo Jordan, cicibo unu kite ni ï wi Kidi Ebal kit na an atye ka cïköwu ködë tin. Myero ipu unu komgï kï rangi na tar. ");
INSERT INTO lth_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","Gër unu keno tyër n'ëyübö kï kite both Rwoth Obangawu kunön. Kür itii unu kï nywenyo mörö më paögï. ");
INSERT INTO lth_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","Myero ïgër unu keno tyër ka Rwoth Obangawu kï kite na lül ëka ïryëd unu tyër awanga ï wie both Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","Ngöl unu thon tyër më kuc nakun ïcamö unu kunön, kanya un ibino bedo kï yom cwiny ï nyim Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","Un myero ïcöö na bër köp kïbëc më cïk ni ï kom kite ni na un icicibo.” ");
INSERT INTO lth_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","Cë Muca ëka ëlamdhök n'obedo Jö Lebi okobo both jö Icarael kïbëc nï, “Lïng unu moth, un jö Icarael, ëk iwiny unu köp! Un dong ïdökö jö ka Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","Pï manön, un myero dong iwiny unu köp ka Rwoth Obangawu ëk ïlüb unu cïk mërë kïbëc na an atye ka mïöwu tin.” ");
INSERT INTO lth_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","Ï nïnö nön kikokome Muca öcïkö jïï nï: ");
INSERT INTO lth_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","Ka ïngölö unu kulo Jordan, kaka ka Cimeon, Lebi, Yuda, Icakar, Yocepu ëka Benjamin bino cung gïnï ï wi Kidi Gerijim më lamö gum ï kom jïï. ");
INSERT INTO lth_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","Ëka kaka ka Reuben, Gad, Acer, Jabulon, Dan, ëka Naputali bino cung gïnï ï wi Kidi Ebal më lamö cen ï kom jïï. ");
INSERT INTO lth_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","Cë jö Lebi bino redo gïnï rwök both jö Icarael kïbëc nï: ");
INSERT INTO lth_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","“Cen myero ömak dhanö mörö na bino yübö cal jwök n'ëpaö apaa onyo nywenyo n'ëlïö—n'obedo gin më kwer both Rwoth, n'adïrü öyübö kï cïngë—ëka ocibo ï müng më awöra.” ");
INSERT INTO lth_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","“Cen myero ömak dhanö mörö na ba bino wörö apap mërë ëka aya mërë.” ");
INSERT INTO lth_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","“Cen myero ömak dhanö mörö na bino cwarö kidi më wang ngöm k'awodhe.” ");
INSERT INTO lth_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","“Cen myero ömak dhanö mörö na bino mïö athöö wang lübö yoo na path.” ");
INSERT INTO lth_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","“Cen myero ömak dhanö mörö na bino balö pido k'arok, athïn kic onyo dha thöö ëka mïö köp löö.” ");
INSERT INTO lth_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","“Cen myero ömak dhanö mörö na bino buto kï cii apap mërë, pïën nwongo ën oketho lewic ï kom apap mërë.” ");
INSERT INTO lth_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","“Cen myero ömak dhanö mörö na bino buto kï lee mörö këkën.” ");
INSERT INTO lth_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","“Cen myero ömak dhanö mörö na bino buto k'amïn mërë, onyo amïn mërë më babö onyo amïn mërë n'aya mërë önywölö k'ëcwö nökënë.” ");
INSERT INTO lth_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","“Cen myero ömak dhanö mörö na bino buto kï marö mërë.” ");
INSERT INTO lth_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","“Cen myero ömak dhanö mörö na bino neko awodhe ï müng.” ");
INSERT INTO lth_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","“Cen myero ömak dhanö mörö na bino gamö lïm më wïlönë ï müng ëk enek kï dhanö na ba öbalö.” ");
INSERT INTO lth_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","“Cen myero ömak dhanö mörö na ba bino moko ëka lübö köp kïbëc na tye ï cïk ni.” ");
INSERT INTO lth_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","Ka ibino unu winyo köp ka Rwoth Obangawu ëka ïlübö unu cïk mërë kïbëc na an tin atye ka mïöwu, Rwoth Obangawu bino mïöwu ïdökö na tëk na löö rok kïbëc na tye ï wi lobo. ");
INSERT INTO lth_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","Gum ni kïbëc bino bino ï komwu na thwönë ka iwinyo unu köp ka Rwoth Obangawu: ");
INSERT INTO lth_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","Gum bino bedo ï komwu ï pacö ëka ï pwothiwu. ");
INSERT INTO lth_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","Gum bino bedo ï kom ëthïnöwu, ï kom gin na bino cëk ï pwothiwu, ëka ï kom ëthïnö lïmwu na kwö—ëthïnö dhokwu ëka ëthïn rom kï dyegiwu. ");
INSERT INTO lth_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","Gum bino bedo ï kom adïtani ëka ï kom gin më nyöbö ogatini. ");
INSERT INTO lth_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","Ibino bedo unu kï gum ï karë na un ïdönyö ï öt ëka ï karë na un idonyo yökö. ");
INSERT INTO lth_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","Rwoth bino mïö ïlöö unu langwu na bino më lwëny ï komwu. Gïn bino më lwëny ï komwu kï ï yoo acël ëntö bino gïnï ngwëc kï bothwu nakun pokere gïnï ï yodhi abïrö. ");
INSERT INTO lth_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","Rwoth bino mïö gum ï kom derewu ëka ï kom gin na kïbëc na cïngwu otio. Rwoth Obangawu bino mïöwu gum ï lobo na ën tye ka mïöwu. ");
INSERT INTO lth_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","Ka ibino unu gwökö cïk ka Rwoth Obangawu kïbëc nakun ïlübö unu, Rwoth bino mïöwu ibedo jögë na leng kite na ën öcïkërë ködë kï kwong bothwu. ");
INSERT INTO lth_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","Cë jö kïbëc më wi lobo bino nënö nï ecwodowu kï nyïng Rwoth ëka bino gïnï lworowu. ");
INSERT INTO lth_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","Rwoth bino mïöwu jami na pol—ëthïnöwu, ëthïnö lïmwu na kwö, ëka cem më pwothiwu bino cëk—ï lobo na yam ën okwongo both kwerewu më mïöwu. ");
INSERT INTO lth_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","Rwoth bino yabö niwu polo na ën kanö lönyö mërë ïë, më mïö köth cwee ï pwothiwu ï karë mërë kikokome ëka më mïö gum ï kom tic kïbëc na cïngwu bino tio. Un ibino mïö jami më adena both rok na pol ëntö ba ibino unu deno gin mörö kï both ngat mörö. ");
INSERT INTO lth_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","Rwoth bino mïöwu bedo ëtëla, ëka pathï jö n'ëtëlögï. Karë kïbëc un ibino bedo anyim nakun ba ibedo unu angec ka iwinyo unu cïk ka Rwoth Obangawu kïbëc na an tin acïköwu nakun ïgwökërë unu më lübö. ");
INSERT INTO lth_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","Kür ïlökërë unu ökö kï ï kom cïk na an tin amïöwu, yo cïngwu kucem onyo kucam, onyo lübö obanga nökënë gïnï ëka wörögï. ");
INSERT INTO lth_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","Ëntö ka un ba ibino winyo unu köp ka Rwoth Obangawu onyo ïgwökërë unu më lübö cïk mërë kïbëc na an tin acïköwu, cë cene ni kïbëc bino bino ï komwu ëka maköwu: ");
INSERT INTO lth_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","Cen bino maköwu ï peciwu ëka ï pwothiwu. ");
INSERT INTO lth_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","Cen bino bedo ï kom adïtani ëka ï kom gin më nyöbö ogatini. ");
INSERT INTO lth_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","Cen bino bedo ï kom ëthïnöwu ëka ï kom gin na bino cëk ï pwothiwu, ï kom ëthïnö lïmwu na kwö ëka ï kom ëthïnö rom kï dyegiwu. ");
INSERT INTO lth_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","Cen bino maköwu ï karë na un ïdönyö ï öt ëka ï karë na un idonyo yökö. ");
INSERT INTO lth_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","Rwoth bino oro cene ï komwu, wiwu bino rubere ëka ebino cokowu kï gero ï kom gin na kïbëc na un ibino tio, naka ka ithum unu ökö. Ibino thum unu ökö pïöpïö pï tïmwu na reco na un ïtïmö pïën ïwëka unu ökö. ");
INSERT INTO lth_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","Rwoth bino pwodowu kï twoe na reco naka ka ën otyekowu ökö kï ï lobo na un itye ka dönyö ïë më gamö më bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","Rwoth bino pwodowu kï twoe na köbërë, kï lyetho ëka two akwoda, kï lyetho pïny ëka ceng bino ryëny. Cemwu bino ner ëka pur ökö. Pwod ni kïbëc bino bino ï komwu naka ka ïthöö unu. ");
INSERT INTO lth_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","Polo na tye ï ka wiwu ba bino mïö köth cwee, ëka ngöm na tye ï thë tyënwu bino bedo na tëk calö nywenyo. ");
INSERT INTO lth_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","Rwoth bino lökö köth më lobowu dökö apua ëka luru; bino yaa kï ï polo öny pïny ï komwu naka tyekowu ökö kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","Rwoth bino mïö langwu lööwu. Un ibino lwëny ï komgï kï ï yoo acël ëntö ibino unu ngwëc kï bothgï nakun ipokere unu ï yodhi abïrö, ëka jö më lobo kïbëc bino bedo gïnï kï thwön lworo pï gin n'ötïmërë ï komwu. ");
INSERT INTO lth_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","Lyenewu bino bedo cem ka wïny kïbëc na ngwëcö kï malö ëka më ka leeni më thim, ëka ngat mörö ope na bino ryëmögï ökö. ");
INSERT INTO lth_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","Rwoth bino pwodowu kï two bür gïnï më Ejip, bür na ba cang, gwönyü ëka ïl kom na ba ibino unu cang kï ïë. ");
INSERT INTO lth_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","Rwoth bino pwodowu kï poa, thöö wang ëka bango wiwu ökö. ");
INSERT INTO lth_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","Ibino unu thwathwama kiceng calö athöö wang. Ba ibino bedo unu kï lönyö ï kom gin mörö këkën na un ibino tïmö. Ebino dïöwu ëka yakö jamiwu nïnö kï nïnö, ëntö ngat mörö ope na bino könyöwu. ");
INSERT INTO lth_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","In ibino cikiri kï dhakö më nyömö, ëntö ngat nökënë ënë bino bedo ködë tëtëk. In ibino gërö öt, ëntö ba ibino bedo ïë. In ibino pïdhö ölök, ëntö ba ibino camö nyige. ");
INSERT INTO lth_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","Ebino neko thwön pur na megi na in ïnënö, ëntö ba ibino camö ringo mërë mörö. Ebino tero kanani tëtëk kï bothi, ëntö ba ebino dwongo. Ebino mïö romni both langni, ëntö ngat mörö ope na bino könyöni më dwongogï. ");
INSERT INTO lth_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","Ebino mïö awope ëka anyirani both rok nökënë na in ïnënö ëka wangi bino dhero më nënögï nïnö kï nïnö, ëntö ba ibino bedo kï tëkö më jükögï cïdhö ködgï. ");
INSERT INTO lth_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","Rok na ba ingeo unu bino camö cem na un ipuro ï pwothiwu, ëka ebino dïöwu pï karë kïbëc ëntö gin mörö ope na un ibino tïmö. ");
INSERT INTO lth_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","Gin na wangwu bino nënö bino mïöwu ïdökö epoa. ");
INSERT INTO lth_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","Rwoth bino pwodoni kï two më congi ëka tyeni kï bür na rem rwök na ba bino cang, cakërë kï ï tyeni pïny naka ï wi malö. ");
INSERT INTO lth_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","Rwoth bino ryëmöwu kanya acël kï rwoth na un ibino yërö më tëlöwu yo both rok na un onyo kwerewu ba ongeo. Ibino unu wörö obanga nökënë n'ëyübö kï yen ëka kidi. ");
INSERT INTO lth_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","Ibino unu dökö gin na kelo lworo, gin më carolok ëka gin më anyëra ï kin rok kïbëc na Rwoth bino këthöwu ïë. ");
INSERT INTO lth_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","Ibino unu cwöönö kodhi na dwong ï pwothiwu, ëntö ibino unu cökö na nönök, pïën bonyo bino camö ökö. ");
INSERT INTO lth_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","Ibino unu pïdhö ölök ëka ibino unu yübögï na bër, ëntö ba ibino unu madhö köngö mërë onyo püdö nyige, pïën kudi bino camögï ökö. ");
INSERT INTO lth_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","Ibino unu bedo kï yen më jeituni ï lobowu, ëntö ba ibino unu tic kï möö mërë, pïën nyige bino öny ökö. ");
INSERT INTO lth_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","Ibino unu nywölö awope ëka anyira, ëntö ba ibino unu gwökögï, pïën ebino terogï ökö ï opii. ");
INSERT INTO lth_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","Bonyo bino camö yen ëka cem më lobowu ökö. ");
INSERT INTO lth_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","Erok na bedo ï lobowu bino dökö gïnï ëlönyö ëka jö na pïrgï tëk rwök, ëntö un ibino dökö ëcan ëka jö na pïrgï ba tëk. ");
INSERT INTO lth_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","Gïn bino mïöwu den, ëntö un ba ibino mïö den bothgï. Gïn bino tëlö wiwu, ëntö un ibino dong cen ï körgï. ");
INSERT INTO lth_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","Cene ni kïbëc bino podho ï komwu, bino ryëmö körwu cë maköwu naka ibino thum unu ökö kïbëc, pïën ba iwinyo unu köp ka Rwoth Obangawu ëka ba ïmakö unu cïk mërë kïbëc na ën öcïköwu. ");
INSERT INTO lth_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","Gïn bino bedo anyuth ëka tango më aura bothwu ëka both ëkwaëwu naka naka. ");
INSERT INTO lth_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","Pïën un ba itio unu both Rwoth Obangawu kï yom cwiny ï karë n'onwongo itye unu kï jami na büp, ");
INSERT INTO lth_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","pï manön ibino unu tic both langwu na Rwoth bino orogï ï komwu. Kec ëka örïö pii bino nekowu, ibino unu woth kotula ëka can jami kïbëc bino maköwu. Rwoth bino ketho ayokoth n'obedo nywenyo ï ngutwu naka ka otyekowu ökö kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","Rwoth bino kelo rok mörö më lwëny ï komwu kï kanya bor, kï ï ajiki më lobo, calö jür na bino pïny, rok na ba ibino unu nïang ï lëbgï. ");
INSERT INTO lth_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","Rok na ger na ba bino parö pï jö n'otii ëka kïca ba bino makögï ï kom jö na thïnö. ");
INSERT INTO lth_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","Gïn bino camö ëthïnö lïmwu na kwö ëka cem na bino cëk ï pwothiwu, naka ka etyekowu ökö. Gïn ba bino wëkö niwu kal mörö, köngö ölök na nyen onyo möö jeituni, ëthïnö dhok onyo ëthïnö rom kï dyegi na mewu naka ka gïn otyekowu ökö. ");
INSERT INTO lth_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","Gïn bino gürö peciwu kïbëc naka ka cëlwu n'ëgërö na bor rwök na un igeno örëdhërë pïny. Gïn bino gürö peci kïbëc na tye ï lobo na Rwoth Obangawu tye ka mïöwu. ");
INSERT INTO lth_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","Pï can na langwu bino ketho ï komwu ï karë na gïn bino gürö peciwu, un ibino camö ëthïnöwu, ringo kom awope ëka anyira na Rwoth Obangawu ömïöwu. ");
INSERT INTO lth_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","Naka thon ëcwö na kite mërë bër rwök ëka n'obedo nyakïca kï ï kinwu bino twono ömïn mërë cem, onyo dhakö mërë na ën marö, onyo ëthïnë na pod kwö. ");
INSERT INTO lth_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","Ën ba bino nywakö ködgï ringo kom ëthïnë na ën camö. Pïën ën ope kï gin mörö n'odong nïnë më acama ï karë më can na langwu bino gürö kï peciwu kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","Dhakö na kite mërë bër rwök ëka n'obedo nyakïca, n'onwongo ba thamö më nyönö pïny kï tyënë, wangë bino cido ï kom cwörë na ën marö, ëka wode onyo nyarë. ");
INSERT INTO lth_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","Ën bino kanö byero na yaa kï ïë ëka athïn na ën önywölö, ëk ëcam ën kënë ï müng ï karë na lang bino güröwu ëka can na rac na langwu bino ketho ï komwu ï peciwu. ");
INSERT INTO lth_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","Ka ba ïgwökërë unu më lübö köp kïbëc më cïk ni, n'ëcöögï ï buk ni, ëka ka ba ibedo unu kï lworo ï nyïng më dheo na pïrë tëk na ënë nyïng Rwoth Obangawu, ");
INSERT INTO lth_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","cë Rwoth bino mëdö pwod ï komwu ëka ï kom ëkwaëwu, can na rac rwök ëka odeke na ba cang gïnï. ");
INSERT INTO lth_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","Ën bino mïö two kïbëc më Ejip na yam un ilworo rwök më maköwu, ëka ba ibino unu cang. ");
INSERT INTO lth_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","Rwoth thon bino mïöwu koth twoe kïbëc ëka can na ba ëcöö ï buk më cïk ni, naka ka etyekowu ökö. ");
INSERT INTO lth_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","Kadï onwongo ipol unu calö cër na tye malö ï wi polo, welwu bino dökö na nönök rwök, pïën ba iwinyo unu köp ka Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","Dong kite na calö Rwoth cwinye obedo na yom më mïöwu bedo na bër ëka më mïö welwu nya na pol, kömanön thon Rwoth cwinye bino bedo na yom më balö ëka tyekowu. Ebino kwanyöwu ökö kï ï lobo na un itye ka dönyö ïë më gamö bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","Cë Rwoth bino këthöwu ökö ï kin rok kïbëc, cakërë kï ï ajiki lobo kucël naka tung ca. Kï kunön un ibino wörö obanga nökënë gïnï—obanga n'ëyübö kï yen ëka kidi, na un onyo kwerewu ba ongeo. ");
INSERT INTO lth_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","Kï ï kin rok nön gïnï, ba ibino unu nwongo kuc onyo karë më mïö tyënwu yweo. Kï kunön Rwoth bino mïö cwinywu podho, ba ibino bedo unu kï gen ëka tipo komwu bino thöö ökö. ");
INSERT INTO lth_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","Cwinywu bino ngabërë angaba pï kwöwu më anyim. Lworo bino maköwu kiwor ëka kiceng abonge gen mörö pï kwöwu. ");
INSERT INTO lth_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","Kodiko ibino unu kobo nï, “Kono onwongo obed kothyeno!” Ëka kothyeno ibino unu kobo nï, “Kono onwongo obed kodiko!”—pïën pï lworo na bino pong ï cwinywu ëka gin na wangwu bino nënö. ");
INSERT INTO lth_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","Cë Rwoth bino dwököwu yo Ejip kï mel gïnï, ï yoo na an abino akobo niwu nï ba dökï ibino nënö unu. Kï kunön, un ibino mïrë kenwu both langwu më acadha calö opii n'obedo cwö ëka mon, ëntö ngat mörö ope na bino wïlöwu. ");
INSERT INTO lth_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","Man ënë köp më cïkërë na Rwoth öcïkö Muca më ketho kï jö Icarael ï lobo më Moab, mëd ï kom cïkërë na ën onwongo oketho ködgï kï ï Koreb. ");
INSERT INTO lth_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","Muca ocwodo jö Icarael kïbëc kanya acël ëka okobo bothgï: Un ïnënö kï wangwu gin na Rwoth ötïmö ï Ejip ï kom Parao, ï kom edite mërë kïbëc ëka ï kom lobo mërë. ");
INSERT INTO lth_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","Un ïnënö kï wangwu atëmatëma na dito gïnï, anyuth më tango nön ëka gin më aura gïnï. ");
INSERT INTO lth_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","Ëntö naka ï nïnö na tin ni Rwoth ba ömïöwu thama më nïang onyo wang më neno onyo ith na winyo pïny. ");
INSERT INTO lth_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","An atëlöwu kï ï thim pï mwaka pyer angwën. Böngwu ba obino otii, onyo wociwu ba obino othum ökö kï ï tyënwu. ");
INSERT INTO lth_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","Un ba ibino ïcamö unu ogati onyo madhö köngö ölök onyo köngö mörö na këc. An abino atïmö kömanön ëk inge unu nï an abedo Rwoth Obangawu. ");
INSERT INTO lth_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","Ï karë na un ithuno ï kabedo ni, Cikon rwoth më Kecbon ëka Og rwoth më Bacan obino gïnï më lwëny ï kom onu, ëntö onu ëlöögï ökö. ");
INSERT INTO lth_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","Onu ebino ëgamö lobogï ëka ëmïö both jö Reuben, Jö Gad ëka nucu kaka ka Manace na calö lobo na mëgï. ");
INSERT INTO lth_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","Pï manön, gwökërë unu më lübö köp më cïkërë ni, ëk gin na kïbëc na un ibino tïmö owoth na bër. ");
INSERT INTO lth_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","Un kïbëc icung unu tin ï nyim Rwoth Obangawu—ëtëlawu ëka rwodhiwu, edongwu ëka editewu, ëka jö nökënë kïbëc më Icarael, ");
INSERT INTO lth_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","kanya acël k'ëthïnöwu ëka monwu, ëka Erok na bedo gïnï ï kinwu, na ngölö yen ëka na twömö pii niwu. ");
INSERT INTO lth_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","Un icung kany më dönyö ï cïkërë kï Rwoth Obangawu, cïkërë na Rwoth tin moko kodwu ëka moko kï kwong, ");
INSERT INTO lth_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","më moko tin nï un ibedo jögë, ëk ebed Obangawu kite na ën öcïköwu ëka kite na ën okwongo both kwaröwu Abraam, Icaka ëka Jakob. ");
INSERT INTO lth_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","An atye ka ketho cïkërë ni kï kwong mërë, pathï kï un këkën ");
INSERT INTO lth_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","na tin icung unu kany ï nyim Rwoth Obanga onu, ëntö thon kï jö na tin ope gïnï kany. ");
INSERT INTO lth_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","Un kikomwu ingeo unu kite na onu ëkwö ködë ï Ejip ëka kite na onu ewok ködë ï rok na papath më bino yo kany. ");
INSERT INTO lth_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","Un ïnënö unu kï ï kin-gï calgï më kwer, cal jwogi n'ëyübö kï yath ëka kï kidi, kï ryal ëka kï gol. ");
INSERT INTO lth_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","Gwökërë unu ëk kür ëcwö onyo dhakö onyo kaka mörö na tin tye ï kinwu na cwinye bino lökërë ökö kï both Rwoth Obanga onu më cïdhö wörö obanga ka rok nön gïnï; man twërö bedo calö orii na döngö më bedo kwir na këc. ");
INSERT INTO lth_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","Ka koth dhanö nön owinyo köp më kwong ni, ën bino lamö gum ï kome kënë ëka bino thamö nï, “An abino bedo kï kuc, kadï gin mörö na rac ba bino tïmërë ï koma, kadï bed cwinya nwang më lübö yora këna.” Man bino kelo pwod ï komwu kïbëc, jö na bëcö ëka jö na reco. ");
INSERT INTO lth_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","Rwoth ba bino tïmö kïca both dhanö nön; akëmö ëka nyeko mërë bino wangö dhanö nön calö mac na lyël. Cene kïbëc n'ëcöö ï buk ni bino makö ën, ëka Rwoth bino jwaö nyïngë ökö kï ï thë polo. ");
INSERT INTO lth_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","Rwoth bino poko dhanö nön ökö kï ï kin kaka më Icarael ëka bino ketho can ï kome, na lübërë kï cene kïbëc më cïkërë n'ëcöö ï Buk më Cïk ni. ");
INSERT INTO lth_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","Ëkwaëwu na bino lübö körwu ëka Erok na bino kï kanya bor bino nënö can n'opodho ï kom lobo ëka twoe na Rwoth ömïö ömakö lobo nön. ");
INSERT INTO lth_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","Lobo nön kïbëc bino wang ökö kï mac calpa ëka kadö—na gin mörö ope n'ëpïdhö ïë, gin mörö ope na tuu kï ïë, gin mörö ope na döngö kï ïë. Bino bedo calö Codom ëka Gomora, Adma ëka Jeboim na Rwoth yam öbalö rwök ï karë n'akëmö ömakö. ");
INSERT INTO lth_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","Rok kïbëc bino penyo nï, “Pïngö Rwoth ötïmö gin ni ï lobo ni? Pïngö akëmö ömakö ën rwök?” ");
INSERT INTO lth_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","Ëka agam mërë bino bedo nï, “Gin n'ömïö ötïmö nï kömanön, pïën jö ni öwëkö gïnï cïkërë ka Rwoth, Obanga ka kweregï, cïkërë na ën oketho ködgï ï karë na ën okelogï kï ï Ejip. ");
INSERT INTO lth_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","Gïn ölökërë ökö ëka öwörö gïnï obanga nökënë gïnï nakun ryebere gïnï pïny ï nyimgï, obanga na gïn ba ngeo, obanga na ën ba ömïögï. ");
INSERT INTO lth_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","Pï manön akëmö ka Rwoth ömakö lobo ni, ëka ooro ïë alem kïbëc n'ëcöö ï buk ni. ");
INSERT INTO lth_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","Rwoth obino ökwanyögï ökö k'akëmö ëka kï thwön cwer cwiny na dit kï ï lobogï ëka öryëmögï ï lobo nökënë kite na tye ködë tin.” ");
INSERT INTO lth_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","Gin më müng obedo më ka Rwoth Obangawa, ëntö gin na nen obedo më onu ëka kï më ëthïnö onu na twal, ëk onu ëlüb köp kïbëc më cïk ni. ");
INSERT INTO lth_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","Ka gum ni ëka cene ni kïbëc na an aketho ï nyimwu opodho ï komwu, ëka ipo unu ïë kï kanya Rwoth Obangawu ökëthöwu ïë ï kin rok na papath, ");
INSERT INTO lth_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","ëka ka idwogo unu both Rwoth Obangawu k'ëkwaëwu cë ibedo unu kï winy ï köp mërë kï cwinywu kïbëc ëka kï tipowu kïbëc na lübërë kï köp kïbëc na an tin acïköwu ködë, ");
INSERT INTO lth_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","cë Rwoth Obangawu bino bedo kï kïca ï komwu ëka bino cököwu dökï kï ï kin rok kïbëc na ën yam ökëthöwu ïë cë dwongo gum bothwu. ");
INSERT INTO lth_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","Kono kadï bed eterowu ï lobo na bor rwök, kï kunön Rwoth Obangawu bino cököwu kanya acël ëka dwongowu cen. ");
INSERT INTO lth_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","Ën bino kelowu ï lobo n'obedo më ka kwerewu ëka un ibino gamö më bedo mewu. Ën bino mïöwu jami na pol ëka ibino unu nya na pol na kadhö kwerewu ökö. ");
INSERT INTO lth_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Rwoth Obangawu bino lökö cwinywu ëka cwiny ëkwaëwu ëk ïmar unu ën kï cwinywu kïbëc ëka kï tipowu kïbëc ëk ibed unu na kwö. ");
INSERT INTO lth_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","Rwoth Obangawu bino ketho pwod ni kïbëc ï kom langwu na dagwu ëka yelowu. ");
INSERT INTO lth_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","Un ibino winyo köp ka Rwoth dökï ëka ïlübö unu cïk mërë kïbëc na an tin amïöwu. ");
INSERT INTO lth_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","Cë Rwoth Obangawu bino mïöwu jami na pol rwök ï tic kïbëc na un ibino tïmö kï cïngwu, ï kom ëthïnöwu, ï kom ëthïnö lïmwu na kwö ëka ï kom cem na bino cëk ï pwothiwu. Rwoth cwinye bino bedo na yom dökï më mïö jami nya bothwu, kite na ïë obedo na yom ï kom kwerewu, ");
INSERT INTO lth_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","ëntö ibino unu winyo köp ëka cïk ka Rwoth Obanga onu n'ëcöö ï buk ni më cïk ëka ïlökërë unu both Rwoth Obangawu kï cwinywu kïbëc ëka kï tipowu kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","Kobedini cïk na tin an acïköwu ködë ba tëk rwök ëka ba tye kanya bor kï bothwu. ");
INSERT INTO lth_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","Ba tye naka yo polo, ëk ömïï ipeny unu nï, “Nga na bino ïdhö malö ï polo më ömö ëka tïtö nïwa, ëk ewiny cë dong ëlübï?” ");
INSERT INTO lth_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","Onyo ba tye naka yo löka nam tung ca, ëk ömïï ipeny unu nï, “Nga na bino ngölö nam më ömö ëka tïtö nïwa ëk ewiny cë dong ëlübï?” ");
INSERT INTO lth_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","Pe, köp nön tye na cwök bothwu; tye ï dhöwu ëka ï cwinywu na mïö ïtwërö unu lübö. ");
INSERT INTO lth_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","Nën, an tin aketho ï nyimwu gin na bër ëka gin na rac, kwö ëka thöö. ");
INSERT INTO lth_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Ka ibino unu lübö cïk ka Rwoth Obangawu kïbëc na an tin acïköwu, nakun nwongo ïmarö unu ën ëka ïgwökö unu cïk mërë kïbëc, ibino unu kwö ëka welwu bino mëdërë, cë Rwoth Obangawu bino mïöwu gum ï lobo na un ibino dönyö ïë më gamö bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","Ëntö ka cwinywu ölökërë ökö ëka ba ibedo unu kï winy, nakun ïlökërë unu both obanga nökënë gïnï ëka iryebere unu pïny më wörögï, ");
INSERT INTO lth_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","an tin akobo kanyalër bothwu nï ebino tyekowu ökö. Ba ibino unu bedo pï karë na lac ï lobo na un ibino ngölö kulo kulo Jordan më dönyö ïë ëka gamö bedo mewu. ");
INSERT INTO lth_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","An tin acwodo polo ëka lobo më bedo caden ï komwu nï an aketho ï nyimwu kwö ëka thöö, gum ëka cen. Dong kobedini yër unu kwö ëk un ëka ëthïnöwu ibed unu na kwö. ");
INSERT INTO lth_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","An thon akobo niwu nï ïmar unu Rwoth Obangawu, iwiny unu köp mërë ëka imok unu ï kome. Pïën Rwoth ënë mïöwu kwö, ëka ën bino mïö ibedo unu na kwö pï mwaka na pol ï lobo na ën okwongere më mïö both kwaröwu Abraam, Icaka ëka Jakob. ");
INSERT INTO lth_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Cë Muca ömëdërë kï twakö köp ni both jö Icarael kïbëc nï: ");
INSERT INTO lth_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","“An kobedini dong atye kï mwaka 120 ëka ba dök atwërö tëlöwu. Rwoth okobo botha nï, ‘In ba ibino poth yo löka kulo Jordan.’ ");
INSERT INTO lth_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Rwoth Obangawu kikokome ënë bino cïdhö anyim niwu yo löka ca. Ën bino tyeko rok ni kïbëc na tye ï nyimwu, ëka un ibino gamö lobogï më bedo mewu. Yocua thon bino cïdhö anyim niwu yo löka ca, kite na Rwoth okobo ködë. ");
INSERT INTO lth_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","Ëka Rwoth bino tïmö bothgï gin na ën obino ötïmö both Cikon ëka Og, n'obedo gïnï rwodhi ka jö Amor, na ën obino otyeko kanya acël kï lobogï. ");
INSERT INTO lth_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Rwoth bino mïögï bothwu, ëka un myero ïtïm unu bothgï gin na kïbëc na an acïköwu. ");
INSERT INTO lth_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Bed unu jö na tëk ëka jö na cwinygï tëk. Kür ibed unu kï lworo mörö, onyo kür ïmïï komwu ömyël ï nyimgï, pïën Rwoth Obangawu bino woth kanya acël kodwu; ën ba bino wëköwu onyo kwëröwu.” ");
INSERT INTO lth_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Cë Muca ocwodo Yocua ëka okobo bothe ï nyim jö Icarael kïbëc nï, “Bed ngat na tëk ëka na cwinye tëk, pïën myero ïcïdh kï lwak ni ï lobo na Rwoth okwongo më mïö both kweregï, ëka myero ipok ï kin-gï ëk ögam gïnï ödök na calö mëgï. ");
INSERT INTO lth_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Rwoth kikokome bino cïdhö ï nyimwu ëka bino bedo kanya acël kodwu, ën ba bino wëköwu onyo kwëröwu. Kür ibed unu kï lworo, kür cwinywu opodhi.” ");
INSERT INTO lth_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","Cë Muca öcöö cïk ni gïnï pïny cë ömïö both ëlamdhök n'obedo Jö Lebi, n'otingo gïnï canduk më cïkërë ka Rwoth, ëka both edong kïbëc më Icarael. ");
INSERT INTO lth_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","Cë Muca öcïkögï nï: “Kinge thum ka mwaka abïrö abïrö, ï mwaka më jalö banya, ï karë më kwero Karama më Bölö, ");
INSERT INTO lth_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","ka jö Icarael kïbëc bino cökërë gïnï ï nyim Rwoth Obangani ï kabedo na ën bino yërö, in ibino kwanö cïk ni kïbëc bothgï na gïn tye ka winyo. ");
INSERT INTO lth_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","Gür unu lwak kanya acël—cwö, mon ëka ëthïnö, ëka erok na bedo gïnï ï peciwu—ëk owiny gïnï ëka opwonyere gïnï kite më lworo Rwoth Obangawu ëka ögwökërë gïnï më lübö köp më cïk ni kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","Ëthïnögï, na ba ngeo gïnï cïk ni, myero owiny ëka opwonyere gïnï më lworo Rwoth Obangawu ï karë kïbëc na un itye ka kwö ï lobo na un ïcïdhö ngölö yo löka kulo Jordan më bedo mewu.” ");
INSERT INTO lth_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","Rwoth okobo both Muca nï, “Nïnöni më thöö dong cwök. Cwod Yocua ëk ibed unu kanya acël ködë ï Këma më Rwatërë, ëk an acïk ën.” Cë Muca ëka Yocua öcïdhö gïnï yo Këma më Rwatërë. ");
INSERT INTO lth_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","Cë Rwoth onen ï Këma na cal kï wïr më pöl, ëka wïr më pöl ocung malö ka wi dholokek më dönyö ï Këma. ");
INSERT INTO lth_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","Cë Rwoth okobo both Muca nï: “In ibino cïdhö më yweo kanya acël kï kwereni, ëka jö ni bino cakö wörö obanga nökënë gïnï, obanga nökënë gïnï më lobo na gïn tye ka cïdhö yo ïë. Gïn bino wëköna ökö ëka bino türö gïnï cïkërë na an aketho ködgï. ");
INSERT INTO lth_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","Cë ï nïnö nön akëmö bino maköna ï komgï ëka abino wëkögï ökö; an abino kanö wanga ökö kï bothgï, ëka ebino tyekogï ökö. Can na pol ëka pëkö bino podho ï komgï, ëka ï nïnö nön gïn bino penyo nï, ‘Can ni ba obino ï komwa pïën Obanga onu ba tye kod onu?’ ");
INSERT INTO lth_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","Ëntö an abino kanö wanga ökö ï nïnö nön pïën pï balgï kïbëc më lökërë ökö both obanga nökënë gïnï. ");
INSERT INTO lth_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","“Kobedini dong cöö wer ni pïny ëka ipwony kï jö Icarael cë ïmïïgï ower, ëk obed caden-na ï komgï. ");
INSERT INTO lth_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","Ka an dong akelogï ï lobo na mio na cak ëka möö kic möl kï ïë, lobo na an acïkara kï kwong both kweregï, ëka ka gïn öcamö cem oyeng cë öcwëë gïnï, gïn bino lökërë both obanga nökënë gïnï ëka wörögï, nakun kwëra gïnï ökö ëka türö cïkërëna. ");
INSERT INTO lth_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","Cë ka can na pol ëka pëkö obino ï komgï, wer ni bino bedo caden bothgï, pïën ëkwaëgï wigï ba bino wil ïë. An angeo yüb më thamagï na gïn öyübö, kadï ï karë na an bara akelogï ï lobo na an acïkara kï kwong më mïögï.” ");
INSERT INTO lth_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","Cë Muca öcöö wer ni pïny ï nïnö nön ëka opwonyo kï jö Icarael. ");
INSERT INTO lth_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","Rwoth ömïö cïk ni both Yocua wod ka Nun: “Bed ngat na tëk ëka na cwinye tëk, pïën in kikomi ënë ibino tero jö Icarael ï lobo na an acïkara kï kwong më mïögï, ëka an kikoma abino bedo kodi.” ");
INSERT INTO lth_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","Kinge na Muca otyeko cöö köp më cïk ni ï buk, cakërë kï ï acaki naka ï ajiki, ");
INSERT INTO lth_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","ën ömïö cïk ni both Jö Lebi n'otingo Canduk më Cïkërë ka Rwoth: ");
INSERT INTO lth_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“Ter unu Buk më Cïk ni ëka iketh unu ï nget canduk më cïkërë ka Rwoth Obangawu. Bino bedo kunön na calö caden ï komwu. ");
INSERT INTO lth_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","Pïën an angeo kite na un ibedo unu jö na jëm ëka jö na ngutgï nwang. Ka un ibedo ka jëm ï kom Rwoth na an pod atye na kwö kany acël kodwu, cë jëmwu bino bedo na röm kwene ka an dong athöö ökö! ");
INSERT INTO lth_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","Gür unu edong më kakawu ëka editewu kïbëc ï nyima, ëk akob köp ni bothgï na gïn tye ka winyo ëka acwod polo kï lobo më bedo caden ï komgï. ");
INSERT INTO lth_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","Pïën an angeo nï kinge thööna un ibino tïmö gin na rac ëka ibino unu lökërë ökö kï ï yoo na an acïköwu ködë. Ï karë më anyim, can bino podho ï komwu pïën ibino unu tïmö gin na rac ï wang Rwoth nakun ïmïö unu akëmö makö ën kï gin na cïngwu otio.” ");
INSERT INTO lth_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","Cë Muca öcakö wero köp më wer ni kï wie na gïn tye ka winyo cakërë kï ï acaki naka ï ajiki mërë ï nyim lwak më Icarael n'ögürë gïnï: ");
INSERT INTO lth_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","Cïk unu ithwu, un polo ëka lobo, winy unu na bër köp na an abino kobo. ");
INSERT INTO lth_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","Wëk pwonyna ööny ï komwu calö köth, ëka köpna bino tön calö thoi, calö köth na ngidho ï kom lum na nyen, calö köth na dwong ï kom lum na mar. ");
INSERT INTO lth_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","An abino pakö nyïng Rwoth, ëka jögë bino kobo pï dit mërë! ");
INSERT INTO lth_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","Ën obedo Lëla, na bal mörö ope ï tic mërë, ëka ï yodhi mërë kïbëc ën ngölö köp n'atïr. Ën obedo Obanga na genere na ba tïmö gin mörö na rac, kite tye atïr ëka ba lengere. ");
INSERT INTO lth_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","Gïn ötïmö bal ï kome; ëka gïn ba dök obedo ëthïnö mërë, ëntö obedo gïnï rok n'ölökërë ëka n'ogom ökö. ");
INSERT INTO lth_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","Man ënë kite na un ïcülö kï Rwoth, un jö na mïng ëka n'ope kï ryëkö? Pathï ënë Apapwu n'ocweowu ëka ömïöwu itye na kwö? ");
INSERT INTO lth_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","Po ï kom karë na cön; tham pï run n'opoth gïnï. Peny apapni, cë ën bino kobo nini. Peny unu edongwu, ëka gïn bino nïangöwu. ");
INSERT INTO lth_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","Ï karë na ën na Malö Rwök ömïö both rok lobo n'obedo mëgï, ï karë na ën opoko jö kïbëc, ën oketho wang lobo ka rok acëlacël na lübërë kï wel awope ka jö Icarael. ");
INSERT INTO lth_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","Jö Icarael obedo gïnï jö ka Rwoth, ëntö ën öyërö ëkwaë ka Jakob obedo mëgë. ");
INSERT INTO lth_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","Rwoth obino onwongo jö Icarael ï thim, ï lobo na lik na dhanö ope ïë, ögürögï ëka ögwökögï na bër; ögwökögï na calö töng wangë. ");
INSERT INTO lth_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","Ën cal kï jür na pwonyo ëthïnë kï ngwëc malö ëka tëngö bwome ï wi ëthïnë, na yarö bwome më tingogï ëka tingogï ï bwome. ");
INSERT INTO lth_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","Rwoth kënë ënë ötëlögï; obanga mörö onwongo ope bothgï. ");
INSERT INTO lth_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","Ën ömïögï öïdhö malö ï lobo n'otingere malö, ëka öpïdhögï kï cem n'öcëk ï pwothi. Ën ömïögï möö kic kï ï lëla, ëka kï möö jeituni kï ï lobo n'otingere malö, ");
INSERT INTO lth_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","kï cak na wac më dhok ëka kï cak ka rom ëka dyegi ëka kï dwolo ëthïnö rom ëka dyegi, k'ëthïnö rom ka Bacan n'ëyërö, ëka kï mökö ngano na pwöth. Un ïmadhö köngö ölök na bër. ");
INSERT INTO lth_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","Jecurun ödöngö n'öcwëë ëka öjëm; ka icemo iyeng unu, ibino bedo unu na pëk ëka na komwu pwöth. un ïwëkö Obanga n'ocweowu ëka ïkwërö unu Lëla n'obedo alarwu. ");
INSERT INTO lth_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","Gïn ömïö nyeko ömakö Obanga pï wörö obangagï ëka ömïö akëmö ömakö ën ï kom cal jwogigï më kwer. ");
INSERT INTO lth_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","Gïn ömïö tyërgï both jwogi na ba obedo Obanga— obanga na gïn onwongo ba ngeo, obanga na pod onen na nyen, obanga na kwerewu ba öwörögï. ");
INSERT INTO lth_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","Un ïkwërö Lëla, n'ögwököwu; wiwu owil ökö ï kom Obanga n'önywölöwu. ");
INSERT INTO lth_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","Ëntö Rwoth önënö man cë ökwërögï ökö pïën awope ëka anyira mërë ömïö akëmö ömakö ën. ");
INSERT INTO lth_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","Ëka okobo nï, “An abino kanö wanga ökö kï bothgï, ëka anën kite na nyimgï bino bedo ködë; pïën gïn obedo rok n'ogom, ëthïnö na ba genere. ");
INSERT INTO lth_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","Gïn ömïö nyeko ömaka ï kom gin na ba obedo Obanga ëka ömïö akëmö ömaka kï cal jwogigï na köny mërë ope. An abino mïö nyeko makögï ï kom jö na ba obedo rok kikokome; an abino mïö akëmö makögï ï kom rok na ba nïang. ");
INSERT INTO lth_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","Pïën akëmöna dong omoko mac ökö, ëka tye ka wang naka ï thë bur lyël na thut. Bino wangö lobo kï gin n'öcëk ïë ëka bino cwïnyö mac ï acaki thë kite. ");
INSERT INTO lth_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","“Abino dhuro can ï wigï ëka abino celo athëröna kïbëc ï komgï. ");
INSERT INTO lth_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","An abino mïö kec dïögï, two odeke na reco bino tyekogï; an abino oro leeni na ger më thim ï komgï, ëka thwone na tye kï kwir më tongogï. ");
INSERT INTO lth_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","Pala abadë bino tyekogï ökö kï ï yodhi, lworo bino bedo ï pecigï. Awope na thïnö ëka anyira na thïnö bino thum ökö, ëthïnö na döth ëka jö na wigï opong lwar. ");
INSERT INTO lth_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","An akobo nï an abino këthögï ëka an abino mïö nyïng-gï rwenyo ökö kï kin jïï. ");
INSERT INTO lth_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","Ëntö an ba amïö lang-gï, më bedo k'awaka, ëka okob gïnï nï, ‘Tëköwa dwong; Rwoth ba ötïmö gin mörö.’ ” ");
INSERT INTO lth_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","Jö Icarael obedo gïnï rok na ba ryëk, nïang mörö ope bothgï. ");
INSERT INTO lth_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","Ka onwongo gïn ryëk, ëka önïang gïnï ï köp ni, ëka onge gïnï gin na bino tïmërë ï komgï! ");
INSERT INTO lth_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","Pïngö dhanö acël öryëmö jö elip, onyo jö arïö twërö ryëmö jö elip apar? Rwoth, Kidigï, ökwërögï ökö; Obangagï më aura öwëkögï ökö. ");
INSERT INTO lth_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","Pïën lëlagï ba cal kï Lëla onu. na calö lang onu thon twërö yeo nï kömanön. ");
INSERT INTO lth_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","Jang ölökgï ekelo kï ï jang ölök ka jö Codom, ëka kï ï pwothi ka jö Gomora. Ölökgï opong kï kwir, ëka öbüng nyig-gï këc. ");
INSERT INTO lth_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","Köngö ölökgï cal kï kwir ka thwol, cal kï kwir k'ororo na kelo thöö. ");
INSERT INTO lth_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","Rwoth okobo nï, “Manön kïbëc ba obedo gin na an akanö botha ëka amwönö ökö kanya an akanö lïmna ïë? ");
INSERT INTO lth_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","Obedo ticna më cülö kwor; an abino cülö. Ï karë na tyën-gï bino cër; nïnögï më can dong cwök, ëka bino podho ï komgï athura.” ");
INSERT INTO lth_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","Rwoth bino ngölö köp ï kom jögë ëka kïca bino makö ën ï kom etic mërë, ka ën önënö tëkögï dong othum ëka dhanö mörö ba odong, opii onyo ngat na löörë kënë. ");
INSERT INTO lth_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","Cë Rwoth bino kobo nï, “Obangagï tye gïnï kwene, lëla na gïn obino opono ïë, ");
INSERT INTO lth_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","obanga n'obino öcamö möö tyër awangagï ëka ömadhö gïnï köngö ölök më tyër amadhagï? Ëk gïn öya malö më könyöwu! Ëk gïn obed jö na gwököwu!” ");
INSERT INTO lth_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","Rwoth okobo nï, “Nën dong kobedini an ëka an këna ënë abedo Obanga; obanga nökënë ope ï ngeta. An ënë aneko ëka an ënë amïö kwö, An ënë awanö ëka an ënë acangö, ëka ngat mörö ope na twërö larö kï ï cïnga. ");
INSERT INTO lth_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","Atingo cïnga malö yo polo ëka akobo nï: Na calö an Obanga na bedo na twal, ");
INSERT INTO lth_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","ka apakö pala abadëna na mïmïla ëka k'aryëö cïnga më ngölö köp cë an abino cülö kwor ï kom langna ëka abino ketho can ï kom jö na daga gïnï. ");
INSERT INTO lth_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","An abino mïö athëröna mër kï remo, nakun pala abadëna bino camö ringo: bino yeng kï remo ka jö n'enekogï kï jö n'ëmakögï, ëka bino tongo wi ëtëla ka lang-gï.” ");
INSERT INTO lth_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","Pak unu jögë, un rok kïbëc, pïën ën bino cülö kwor më remo k'etic mërë; ën bino cülö kwor ï kom lang mërë ëka bino kwanyö bal ökö kï ï lobo ka jögë. ");
INSERT INTO lth_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","Muca obino gïn kï Yocua wod ka Nun ëka ötwakö köp më wer ni kïbëc na jïï tye ka winyo. ");
INSERT INTO lth_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","Ï karë na Muca owero köp ni kïbëc kï wie both jö Icarael, ");
INSERT INTO lth_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","ën okobo bothgï nï, “Gwök unu köp ni kïbëc ï cwinywu na tin an atye ka kobo bothwu, ëk ïcïk unu k'ëthïnöwu më lübö köp më cïk ni kïbëc na bër. ");
INSERT INTO lth_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","Köp ni ba obedo köp na körë ope niwu—gïn obedo kwöwu. Gwök unu cïk ni cë ibino bedo unu pï karë na lac ï lobo na un ï tye ka cïdhö më ngölö kulo Jordan më gamö bedo mewu.” ");
INSERT INTO lth_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","Ï nïnö nön kikokome Rwoth okobo both Muca nï, ");
INSERT INTO lth_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“Cïdh ëk ïïdh malö ï wi kite më Abarim, na tye ï lobo Moab; ïïdh ï wi kidi më Nebo n'opimere kï Jeriko ëka ïnën lobo Kanaan na an acwök mïö both jö Icarael. ");
INSERT INTO lth_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","In ibino thöö ï wi kidi nön na in ïïdhö cë ibino cïdhö nywakö kabedo kï kwereni kite n'omeru Aron öthöö ködë ï wi kidi më Kor cë önywakö kabedo kï kwere mërë. ");
INSERT INTO lth_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","Pïën un kïbëc ba ibino ibedo unu kï gen ï koma ï nyim jö Icarael ï dhö pii më Meriba Kadec ï thim më Jin, un ïkwërö wöröna ï nyim jö Icarael na calö Obanga na leng. ");
INSERT INTO lth_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","Pï manön, in ibino nënö lobo nön kï kanya bor; in ba ibino dönyö ï lobo na an abino mïö both jö Icarael.” ");
INSERT INTO lth_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","Man ënë gum na Muca dhanö k'Obanga ölamö ï kom jö Icarael na ën bara öthöö. ");
INSERT INTO lth_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","Ën okobo nï, “Rwoth obino öya kï wi kidi Cinai cë onen bothgï ï Ceir, ën öryëny ï komgï kï ï wi kidi Paran. Ën obino kï jögë na leng elip kï elip kï lëb mac na lyël kï ï cïngë më kucem. ");
INSERT INTO lth_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","Adyer in kikomi ënë ïmarö jïï; jö na leng kïbëc tye gïnï ï cingi. Gïn kïbëc ryebere pïny ï ka tyeni, ëka nwongo gïnï pwony kï bothi, ");
INSERT INTO lth_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","cïk na Muca ömïö bothwa, më bedo më ka jö ka Jakob. ");
INSERT INTO lth_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","Ën obino obedo rwoth ï Jecurun ï karë n'edite ka lwak öcökërë gïnï, kanya acël kï kaka kïbëc më Icarael. ");
INSERT INTO lth_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","“Ëk Reuben obed na kwö ëka kür öthöö, jögë thon kür obed na nönök.” ");
INSERT INTO lth_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","Ëka man ënë gin na ën okobo ï kom Yuda: “Aa Rwoth, winy koko ka Yuda; dwongi ën pacö both jögë. Ën bino lwëny pïrë kënë kï cïngë. Bed ngat na könyö ën ï kom lang mërë!” ");
INSERT INTO lth_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","Ëka ï kom Lebi ën okobo nï: “Mïï both Lebi Tumim ëka Urim na megi both aticni na in igeno. In ïtëmö ën kï ï Maca; in ibino ïtëmö nï gïn tye adyer kï ï dhö pii më Meriba. ");
INSERT INTO lth_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","Lebi okobo ï kom apap ëka aya mërë nï, ‘An ba aparö pïrgï.’ Ën wie ba opo ï kom utmego mërë onyo më ngeo ëthïnö mërë kikokome, ëntö ën ögwökö köp na megi ëka ölübö cïkërëni. ");
INSERT INTO lth_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","Gïn bino pwonyo Jakob kï cïkni ëka cïkni both jö Icarael. Ën bino wangö odok na kur ï nyimi ëka tyër awanga kïbëc ï wi keno tyërni. ");
INSERT INTO lth_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","Aa Rwoth, mïï gum ï kom dïrü mërë kïbëc, ëka ibed kï yom cwiny ï kom gin na ën otio kï cïngë. Göö lang na yaa më lwëny ï kome pïny, göö lang mërë pïny ëk kür dökï ölwëny gïnï ï kome.” ");
INSERT INTO lth_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","Ëka ï kom Benjamin ën okobo nï: “Ëk dhanö na Rwoth marö obed kï kuc ï kome, pïën Rwoth gwökö ën ï karë kïbëc, ëka ngat na Rwoth marö yweo ï kin wi baë.” ");
INSERT INTO lth_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","Ï kom Yocepu ën okobo nï: “Rwoth myero ömïï gum ï lobo mërë kï mïc më thoi na bëcö na yaa kï malö ï polo, ëka kï pii na thuth na tye pïny ï thë lobo, ");
INSERT INTO lth_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","kï nyig yen na bëcö na nyak kï ceng, ëka kï cem na cëk dwe kï dwe, ");
INSERT INTO lth_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","kï nyig kodhi na bëcö na cëk ï wi kite na cön ëka kï jami na cëk na büp ï wi cere na bedo naka naka; ");
INSERT INTO lth_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","kï mïc na bëcö më ngöm ëka kï gin na kïbëc na cëk ï ïë, ëka kïca ka ngat n'onen kï ï bunga na lyël mac. Ëk gum ni kïbëc obed ï wi Yocepu, ëka ï wi ngat n'epoko ökö kï ï kin utmego mërë. ");
INSERT INTO lth_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","Ï dit mërë kï dheo mërë ën obedo calö wod thwön n'obedo kaö; tunge cal gïnï kï tung thwön na ger. Kï tunge gïnï ën bino twomo kï rok gïnï, naka jö na tye ï thwok lobo kïbëc. Man ënë gumna pï jö Epraim na pol, ëka kï jö ka Manace na römö elip kï elip.” ");
INSERT INTO lth_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","Ï kom Jabulon ën okobo nï: “Cwinyi obed na yom, Jabulon, ka ïdönyö yökö, ëka in, Icakar, ka ibedo ï këmani. ");
INSERT INTO lth_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","Gïn bino cwodo jö kïbëc më cïdhö yo wi kidi ëka kï kunön gïn bino mïö tyërgï më kite atïr, gïn bino nwongo lönyögï kï ï nam, kï ï kom lönyö n'ëkanö ï kwo.” ");
INSERT INTO lth_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","Ï kom Gad ën okobo nï: “Gum obed ï kom dhanö n'ömïö wang lobo ka Gad obedo na lac! Gad buto kunön calö kibwor, më yëcö bad lee onyo wie. ");
INSERT INTO lth_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","Ën öyërö lobo mërë na bër, pïën nget lobo k'ëtëla onwongo ëkanö pïrë. Ï karë n'edite wi lwak öcökërë gïnï, ën otio gin na Rwoth mïtö na tye atïr, ëka kï ngölö-köp mërë ï kom jö Icarael.” ");
INSERT INTO lth_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","Ï kom Dan ën okobo nï: “Dan cal k'athïn kibwor, na kïïrë kï ï Bacan.” ");
INSERT INTO lth_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","Ï kom Naputali ën okobo nï: “Naputali, in ipong kï kïca ka Rwoth, ëka ipong kï gum ka Rwoth; gam lobo më kuthö ëka kukwap.” ");
INSERT INTO lth_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","Ï kom Acer ën okobo nï: “Ëk gum obed ï kom Acer na löö kaka nökënë, ëk cwiny utmego mërë obed na bër ï kome, ëka ölwök tyënë ï möö jeituni. ");
INSERT INTO lth_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","Nywenyo më loro dhö wangkac na megi bino bedo nywenyo kï mola, ëka tëkö më komi bino bedo na rom kï mwaka më ditni. ");
INSERT INTO lth_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","“Ngat mörö ope na cal k'Obanga ka Jecurun, na ngwëcö arii ï polo më könyöni, ëka kï dheo mërë ï kom pöl. ");
INSERT INTO lth_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","Obanga na bedo naka naka ënë obedo ka ponowu, ëka cïngë tye pïny më tingowu malö. Ën ryëmö langni ökö kï ï nyimi, nakun kobo nï, ‘Tyekgï ökö!’ ");
INSERT INTO lth_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","Pï manön Icarael bino bedo kï kuc, ëkwaë ka Jakob bino bedo gïnï abonge ayela mörö ï lobo na kal ëka köngö ölök na nyen tye ïë, kanya polo mïö thoi tön pïny. ");
INSERT INTO lth_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","Cwinywu obed na yom un jö Icarael! Nga na cal kodwu, rok na Rwoth ölarögï? Ën obedo kwotwu ëka ngat na gwököwu ëka kï pala abadëni më aura. Langwu bino bedo gïnï kï myël kom ï nyimwu, ëka tyënwu bino nyönö kabedogï kïbëc.” ");
INSERT INTO lth_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Cë Muca öya kï ï bar më Moab ëka öïdhö malö ï wi kidi Nebo naka ï wi pem më Piciga, n'opimere kï Jeriko. Kï kany nön Rwoth onyutho nïnë lobo kïbëc—cakërë kï ï Gilead më thuno ködë naka ï Dan, ");
INSERT INTO lth_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","ëka kï lobo ka Naputali kïbëc, lobo ka Epraim ëka Manace, lobo ka Yuda kïbëc më thuno ködë naka yo kuthö nam, ");
INSERT INTO lth_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Negeb ëka lobo kïbëc cakërë kï ï ora më Jeriko, n'obedo pacö më ötït, thuno ködë naka ï Joar. ");
INSERT INTO lth_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Cë Rwoth okobo both Muca nï, “Man ënë lobo na an acïkara kï kwong both Abraam, Icaka ëka Jakob ï karë na an akobo nï, ‘An abino mïö both ëkwaëni.’ An amii ïnënö kï wangi, ëntö ba ibino cïdhö yo löka tung ca.” ");
INSERT INTO lth_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Ëka Muca, atic ka Rwoth, öthöö kunön ï lobo Moab, kite na Rwoth obino okobo ködë. ");
INSERT INTO lth_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Rwoth oiko ën ï lobo Moab, ï ora n'opimere kï Bet Peor, ëntö naka tin ngat mörö ope na ngeo kanya lyënë tye ïë. ");
INSERT INTO lth_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Muca onwongo tye kï mwaka 120 ï karë na ën thöö, wangë onwongo pod neno na bër ëka kome thon onwongo pod tëk. ");
INSERT INTO lth_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Jö Icarael okoko gïnï Muca kï ï bar më Moab pï nïnö pyer adek, naka karë më koko kï kumo othum. ");
INSERT INTO lth_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Yocua wod ka Nun onwongo opong kï cwiny më ryëkö pïën Muca onwongo oketho cïngë ï kome. Cë jö Icarael owinyo gïnï dhögë ëka ögwökö gïnï cïk na Rwoth öcïkö kï Muca. ");
INSERT INTO lth_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Anaka nön, adwarpïny mörö nökënë ba dök onen na cal kï Muca ï lobo Icarael, na Rwoth ongere ködë wang kï wang, ");
INSERT INTO lth_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","n'otio anyuth më tango nön ëka kï gin më aura gïnï na Rwoth ooro ën yo Ejip—both Parao ëka both edite mërë kïbëc ëka lobo mërë kïbëc. ");
INSERT INTO lth_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Ngat mörö nökënë ope n'obedo tio tic kï tëkö na dit ëka kï gin mökö na kelo lworo kite na Muca obedo ka tio ï nyim jö Icarael kïbëc.");
INSERT INTO lth_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Man ënë kwere ka Yecu Kiricito, akwar Daudi, akwar Abraam: ");
INSERT INTO lth_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraam önywölö Icaka, Icaka önywölö Jakob, Jakob önywölö Yuda ëka omego mërë, ");
INSERT INTO lth_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda kï dhakö mërë Tamar önywölö gïnï Perej ëka Jera, Perej önywölö Kejeron, Kejeron önywölö Ram, ");
INSERT INTO lth_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram önywölö Aminadab, Aminadab önywölö Nacon, Nacon önywölö Calamon, ");
INSERT INTO lth_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Calamon kï dhakö mërë Raab önywölö gïnï Boaj, Boaj kï dhakö mërë Ruth önywölö gïnï Obed, Obed önywölö Jece, ");
INSERT INTO lth_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ëka Jece önywölö rwoth Daudi. Daudi önywölö Colomon, n'onwongo aya mërë obedo dhakö ka Uria ");
INSERT INTO lth_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Colomon önywölö Rekoboam, Rekoboam önywölö Abija, Abija önywölö Aca, ");
INSERT INTO lth_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aca önywölö Yekocapat, Yekocapat önywölö Joram, Joram önywölö Ujia, ");
INSERT INTO lth_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ujia önywölö Yotam, Yotam önywölö Akaj, Akaj önywölö Kejekia, ");
INSERT INTO lth_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Kejekia önywölö Manace, Manace önywölö Amon, Amon önywölö Yocia, ");
INSERT INTO lth_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ëka Yocia önywölö Yekonia ëka omego mërë ï karë n'etero jö Icarael ï lobo Babilon. ");
INSERT INTO lth_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kinge na dong etero jö Icarael ï lobo Babilon: Yekonia önywölö Celatiel, Celatiel önywölö Jerubabel, ");
INSERT INTO lth_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jerubabel önywölö Abiud, Abiud önywölö Eliakim, Eliakim önywölö Ajor, ");
INSERT INTO lth_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajor önywölö Jadok, Jadok önywölö Akim, Akim önywölö Eliud, ");
INSERT INTO lth_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud önywölö Eleajar, Eleajar önywölö Mathan, Mathan önywölö Jakob, ");
INSERT INTO lth_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ëka Jakob önywölö Yocepu cwör Maria, n'önywölö Yecu n'ecwodo nï Meciya. ");
INSERT INTO lth_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Man ënë wang rok apar wie angwën n'ënywölögï kïbëc cakërë kï ï kom Abraam naka othuno ködë ï kom Daudi, apar wie angwën kï kom Daudi naka othuno ï karë n'eterogï ï Babilon, ëka apar wie angwën kï ï karë n'eterogï ï Babilon naka othuno ï kom Meciya. ");
INSERT INTO lth_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Man ënë kite n'ënywölö kï Yecu Kiricito: Ï karë na Maria onwongo öcïkërë më nyömërë kï Yocepu, na gïn bara örwatërë kanya acël, enwongo nï Maria öyac kï tëkö ka Tipo Naleng. ");
INSERT INTO lth_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yocepu onwongo obedo dhanö na kite atïr ëka ba ömïtö nï eketh lewic ï kom Maria, ëntö onwongo mïtö nï ëkwër Maria ï müng. ");
INSERT INTO lth_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ï karë na Yocepu pod tye ka thamö köp nön kï ï cwinye, malaika ka Rwoth onen bothe ï wang lek ëka okobo nï, “Yocepu akwar Daudi, kür ibed kï lworo më tero Maria më bedo dhaköni, pïën ïc na ën tye ködë ögamö kï tëkö ka Tipo Naleng. ");
INSERT INTO lth_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ën bino nywölö athïn awobi, ëka in ibino cakö nyïngë Yecu, pïën ën bino larö jögë kï ï kom balgï.” ");
INSERT INTO lth_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Man kïbëc ötïmërë ëk köp ka Rwoth ocobere na ën okobo kï ï dhö adwarpïny nï: ");
INSERT INTO lth_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nyakö na bara ongere k'ëcwö bino yac ëka bino nywölö athïn awobi; ebino cakö nyïngë Emmanuel”—na tyën köp mërë nï, “Obanga tye ködwa.” ");
INSERT INTO lth_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ï karë na Yocepu ocoo kï ï wang nïnö, ën ötïmö kite na malaika ka Rwoth öcïkö ën ködë ëka otero Maria obedo dhakö mërë. ");
INSERT INTO lth_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ëntö Yocepu ba obedo ködë naka ënywölö athïn awobi. Cë Yocepu öcakö nyïngë Yecu. ");
INSERT INTO lth_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kinge na dong ënywölö Yecu ï Bethelem na tye ï Yudea, ï karë n'Erode obedo rwoth, ëryëkö öya kï kukïdë obino gïnï yo Jerucalem ");
INSERT INTO lth_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ëka openyo gïnï nï, “Athïn n'ënywölö më bedo rwoth k'Eyuda tye kwene? Wan ënënö cër mërë kï kukïdë cë wan ebino më wörö athïn.” ");
INSERT INTO lth_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ï karë na rwoth Erode owinyo köp ni, cwinye opodho rwök, ëka jö më Jerucalem kïbëc cwinygï opodho kanya acël ködë. ");
INSERT INTO lth_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Erode ocwodo ëlamdhök na dito kïbëc ëka epwony cïk cë openyogï ka kwene n'onwongo ebino nywölö Meciya ïë. ");
INSERT INTO lth_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Gïn ögamö nï, “Ï Bethelem më Yudea, pïën man ënë ngö n'adwarpïny onwongo öcöö: ");
INSERT INTO lth_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Ëntö in, Bethelem na tye ï lobo më Yuda, in ba ïtïdï rwök kï ï kin kaka më Yuda; pïën alöc bino yaa kï bothi na ën bino kwaö jöga më Icarael.’” ");
INSERT INTO lth_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Cë Erode ocwodo ëryëkö ï müng ëka önïang kï bothgï karë na cër onen ïë. ");
INSERT INTO lth_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Cë ën oorogï yo Bethelem nakun kobo nïgï nï, “Cïdh ipeny unu köp ï kom athïn ni na bër. Ka inwongo unu, cë ikel unu köp nön botha, ëk an thon acïdh awör ën.” ");
INSERT INTO lth_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kinge na dong gïn owinyo köp ka rwoth, gïn öcakö cïdhö kï yorgï, ëka cër na gïn onwongo önënö kï kukïdë ötëlö nyimgï naka ocung ï wi kanya athïn onwongo tye ïë. ");
INSERT INTO lth_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ï karë na gïn önënö cër, cwinygï obedo na yom rwök. ");
INSERT INTO lth_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Gïn ödönyö ï öt ëka önënö gïnï athïn ëka aya mërë Maria, cë orumo cöng-gï pïny ëka ëwörö athïn. Gïn ögönyö yëcgï ëka ömïö gïnï mïc më gol, odok na ngwece kur ëka müra. ");
INSERT INTO lth_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kinge Obanga öcïkögï ï wang lek nï kür ödök gïnï cen yo both Erode, gïn ödök ï lobogï nakun ewok kï ï yoo nökënë. ");
INSERT INTO lth_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kinge na dong ëryëkö ödök gïnï ökö, malaika ka Rwoth onen both Yocepu ï wang lek cë okobo nï, “Yaa malö iter athïn gïn k'aya mërë ëk ïlüü unu yo Ejip. Bed unu kunön naka ka an akobo nini më dwogo, pïën Erode bino rangö athïn ëk enek ökö.” ");
INSERT INTO lth_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Cë Yocepu öya, ökwanyö athïn gïn k'aya mërë ï kiwor ëka öcïdhö yo Ejip, ");
INSERT INTO lth_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","kanya ën obedo ïë naka Erode öthöö. Man ötïmërë ëk köp ka Rwoth na ën okobo ï dhö adwarpïny ocobere kakarë nï, “An acwodo woda kï ï Ejip.” ");
INSERT INTO lth_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ï karë n'Erode önïang nï ëryëkö öbwölë, öngöö rwök ëka ömïö twërö më neko ëthïnö awope kïbëc kï ï Bethelem ëka ï kabedo kïbëc na cwök ködë cakërë kï ï mwaka arïö dök ködë pïny, na lübërë kï karë na ën önïang ködë kï both ëryëkö. ");
INSERT INTO lth_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Cë ngö na yam adwarpïny Jeremia okobo ocobere: ");
INSERT INTO lth_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Dwön mörö tye ka winyere kï ï Rama na kok ëka kumo rwök, Racel tye ka koko pï ëthïnë, ëka ba mïtö nï ekwe cwinye, pïën ëthïnë öthöö gïnï ökö.” ");
INSERT INTO lth_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kinge na dong Erode öthöö, malaika ka Rwoth onen both Yocepu ï wang lek kï ï Ejip ");
INSERT INTO lth_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ëka okobo nï, “Yaa malö, iter athïn gïn k'aya mërë ëka ïdök unu ï lobo më Icarael, pïën jö n'onwongo mïtö kwanyö kwö k'athïn dong öthöö gïnï ökö.” ");
INSERT INTO lth_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Cë Yocepu öya, ökwanyö athïn gïn k'aya mërë ëka öcïdhö gïnï ï lobo më Icarael. ");
INSERT INTO lth_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ëntö ï karë na Yocepu owinyo nï Arkelau ënë dong löö Yudea nakaka apap mërë Erode, Yocepu obedo kï lworo më cïdhö yo kunön. Cë kinge n'Obanga okobo nïnë ï wang lek, ën öya öcïdhö ï lobo më Galilaya. ");
INSERT INTO lth_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ën öcïdhö obedo ï taun n'ecwodo nï Najaret. Cë köp n'edwarpïny ötwakö ocobere: “Ën ebino cwodo nï dhanö më Najaret.” ");
INSERT INTO lth_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ï karë nonu Jon Abatica obino nakun tïtö köp k'Obanga ï thim më Yudea ");
INSERT INTO lth_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ëka kobo nï, “Ngut unu, pïën ker më polo onyingo na cwök.” ");
INSERT INTO lth_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Man ënë ngat n'adwarpïny Icaya ötwakö pïrë: “Dwön dhanö mörö tye ka redo ï thim nï, ‘Yüb unu yoo pï Rwoth, mïï unu yoo ocung atïr nïnë.’ ” ");
INSERT INTO lth_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon onwongo ruko böng n'ëyübö kï kom yer kïnaga, ëka onwongo tweo wang pyërë kï del. Cem mërë onwongo obedo bonyo ëka möö kic më thim. ");
INSERT INTO lth_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jïï onwongo yaa kï ï Jerucalem, kï ï lobo Yudea kïbëc ëka kï ï lobo kïbëc na tye ï nget kulo Jordan më cïdhö bothe. ");
INSERT INTO lth_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Gïn onwongo tuco balgï ëka Jon baticagï ï kulo Jordan. ");
INSERT INTO lth_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ëntö ka ën önënö Eparicayo ëka Ecadukayo tye ka bino kanya ën onwongo tye ka batica jïï ïë, ën okobo bothgï nï: “Un ëthïn ororo! Nga n'okobo niwu nï ïrïng unu kï ï akëmö k'Obanga na tye ka bino? ");
INSERT INTO lth_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tii unu dong gin na nyutho nï ingut unu. ");
INSERT INTO lth_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kür dök ïtham unu më kobo nï, ‘Wan etye k'Abraam na calö apapwa.’ An akobo niwu nï kï kom kite ni Obanga twërö mïö ëkwaë k'Abraam donyo kï ïë. ");
INSERT INTO lth_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kobedini dong etyeko ketho atong ï tyën orii yen, ëka yath mörö na ba nyakö nyige na bër ebino tongo ökö pïny cë ebolo ï mac. ");
INSERT INTO lth_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“An abaticawu kï pii më nyutho nï ingut unu ökö kï kom balwu, ëntö ngat na bino kï köra tëk na löa ökö, an ba apora më ködö wörë. Ën bino baticawu kï Tipo Naleng ëka kï mac. ");
INSERT INTO lth_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Odheru mërë tye ï cïngë, ëka ën bino yübö larü moo mërë, cë cökö kal mërë ketho ï dërö ëka wangö cüngë kï mac na ba thöö.” ");
INSERT INTO lth_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Cë Yecu öya kï ï Galilaya öcïdhö yo kulo Jordan, ëk Jon obatica ën. ");
INSERT INTO lth_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ëntö Jon ötëmö kwërö ökö nakun kobo nï, “An amïtö nï in ënë ibatica an, ëntö pïngö in dökï ibino nï an abatica in?” ");
INSERT INTO lth_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yecu ögamö nï, “Wëk ötïmërë nï kömanön kobedini; pïën pore nï ön më cobo gin na kïbëc më kite atïr.” Cë Jon oyeo. ");
INSERT INTO lth_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kinge na dong Yecu ebatica, cë ën odonyo malö kï ï pii. Cücüth ï caa nön polo öyabërë, ëka ën önënö Tipo k'Obanga ka bino calö amam, cë opye ï kome. ");
INSERT INTO lth_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Cë dwön mörö owinyere kï ï polo na kobo nï, “Man ënë Woda më amara; na ïya yom ï kome.” ");
INSERT INTO lth_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Cë Tipo k'Obanga otero Yecu ï thim ëk Catan ötëm ën. ");
INSERT INTO lth_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Cë Yecu orio kec pï nïnö pyer angwën kiceng ëka kiwor, kinge kec oneko ën. ");
INSERT INTO lth_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Cë Catan obino both Yecu më tëmö ën nakun kobo nï, “Ka in ibedo Wod k'Obanga, kob nï kite ni ëk ölökërë ödök cem.” ");
INSERT INTO lth_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yecu ögamö nïnë nï, “Ëcöö ï Cöc na Leng nï: ‘Dhanö ba kwö kï cem këkën ëntö kwö kï köp kïbëc na donyo kï ï dhö Obanga.’” ");
INSERT INTO lth_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Cë Catan otero Yecu yo Jerucalem ï taun na leng ëka ömïö ën ocung malö ï wi bïrübïrü më öt k'Obanga. ");
INSERT INTO lth_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ën okobo nï, “Ka in ibedo Wod k'Obanga, podh yo pïny. Pïën ëcöö nï: “ ‘Obanga bino cïkö emalaika mërë më gwököni, ëka gïn bino gamöni kï cïng-gï, ëk kür itwom tyeni ï kom kidi.’” ");
INSERT INTO lth_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yecu ögamö nïnë nï, “Ëcöö thon nï: ‘Kür ïtëm Rwoth Obangani.’” ");
INSERT INTO lth_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Catan dökï otero Yecu yo wi kidi na bor malö rwök cë onyutho nïnë ker kïbëc më wi lobo ëka kï dheogï. ");
INSERT INTO lth_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Catan okobo nï, “Man kïbëc an abino mïöni, ka in ibino rumo congi pïny ëka ïwöra.” ");
INSERT INTO lth_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yecu okobo nïnë nï, “Catan, nyïk ökö kï botha! Pïën ëcöö nï: ‘Wör Rwoth Obangani ëka itii nïnë këkën.’” ");
INSERT INTO lth_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Cë Catan öwëkö Yecu, ëka emalaika obino gïnï cë ökönyö ën. ");
INSERT INTO lth_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ï karë na Yecu owinyo nï Jon etweo ï buc, ën ödök yo Galilaya. ");
INSERT INTO lth_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yecu ba obedo ï Najaret, ëntö ën öcïdhö obedo ï Kaperanaum, pacö na tye ï nget nam Galilaya, na tye ï lobo Jabulon ëka Naputali— ");
INSERT INTO lth_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","më cobo köp n'adwarpïny Icaya okobo: ");
INSERT INTO lth_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Lobo më Jabulon ëka Naputali, yoo na cïdhö yo nam, na tye yo löka kulo Jordan, Galilaya n'obedo lobo n'Erok bedo gïnï ïë— ");
INSERT INTO lth_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","jö na bedo gïnï ï pïny na cöl, önënö gïnï dong tar na dit; jö na bedo ï tipo lobo më thöö, tar dong öryëny ï komgï.” ");
INSERT INTO lth_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Cakërë ï karë nön cïdhö ködë anyim, Yecu öcakö tïtö köp nakun kobo nï, “Ngut unu, pïën ker më polo onyingo na cwök.” ");
INSERT INTO lth_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ï nïnö mörö acël, na Yecu onwongo tye ka wok ï nget Nam më Galilaya, ën önënö utmego arïö, Cimon n'ecwodo nï Petero ëka ömïn mërë Anderiya. Gïn onwongo tye ka bolo böö ï nam, pïën gïn onwongo obedo ëcïk rëc. ");
INSERT INTO lth_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yecu okobo bothgï nï, “Bin, ïlüb unu köra ëka an abino mïöwu ïdökö ëmak jïï nakaka rëc.” ");
INSERT INTO lth_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Cücüth gïn öwëkö böögï ëka ölübö gïnï kör Yecu. ");
INSERT INTO lth_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ën öcïdhö kï kany nön ëka önënö utmego arïö nökënë, Yakobo gïn k'ömïn mërë Jon, awope ka Jebedayo. Gïn onwongo tye ï yeya kanya acël k'apapgï Jebedayo, yübö gïnï böögï. Cë Yecu ocwodogï, ");
INSERT INTO lth_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ëka cücüth gïn öya öwëkö yeya ëka apapgï cë ölübö gïnï kör Yecu. ");
INSERT INTO lth_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yecu owotho orimo ï Galilaya kïbëc, nakun pwonyo ï Cinagogagï kïbëc, tïtö köp më Emuth na Bër më ker k'Obanga, ëka cangö koth twoe kïbëc kï kom jïï. ");
INSERT INTO lth_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Emuth ï kom Yecu ökëth örömö lobo Ciria kïbëc. Jïï okelo bothe jö kïbëc n'onwongo komgï lïth kï twoe na papath, jö na tye k'arem na rac, jö na cen ömakögï, jö na two araka ömakögï, ëka jö na komgï okwe, cë ën öcangögï. ");
INSERT INTO lth_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Lwak na pol n'öya kï ï Galilaya, Dekapoli, Jerucalem, Yudea ëka lobo na tye yo löka kulo Jordan ölübö gïnï kör Yecu. ");
INSERT INTO lth_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ï karë na Yecu önënö lwak, ën öcïdhö ï wi kidi cë obedo pïny. Ëlübkörë obino bothe, ");
INSERT INTO lth_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ëka ën öcakö pwonyogï nakun kobo nï: ");
INSERT INTO lth_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Komgï gum jö na ngeo nï gïn ebedo ëcan ï cwiny, pïën ker më polo bino bedo mëgï. ");
INSERT INTO lth_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Komgï gum jö na kumo, pïën ebino kweo cwinygï. ");
INSERT INTO lth_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Komgï gum jö na mwol, pïën gïn bino leo lobo bedo mëgï. ");
INSERT INTO lth_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Komgï gum jö na kec ëka örïö nekogï pï bedo jö na kitegï atïr, pïën ebino mïögï yeng. ");
INSERT INTO lth_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Komgï gum jö n'obedo ëkïca, pïën ebino tïmö kïca nïgï. ");
INSERT INTO lth_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Komgï gum jö na cwinygï leng, pïën gïn bino nënö Obanga. ");
INSERT INTO lth_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Komgï gum jö na kelo kuc, pïën ebino cwodogï nï ëthïnö k'Obanga. ");
INSERT INTO lth_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Komgï gum jö n'eyelogï pï bedo jö na kitegï atïr, pïën ker më polo bino bedo mëgï.” ");
INSERT INTO lth_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Komwu gum ka jïï yanyöwu, eyelowu, ëka ekobo kwa köp na reco kïbëc më twodo ï komwu pïra. ");
INSERT INTO lth_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bed unu kï yom cwiny, pïën cül na mewu tye na dit ï polo. Man ënë kite na gïn oyelo k'edwarpïny n'öcakö bedo niwu.” ");
INSERT INTO lth_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Un ibedo kadö më lobo. Ëntö ka kadö orwenyo mït mërë ökö, ëtwërö mïö dökö na mït nïngö dökï? Köny mërë nwongo dong ope, myero ëöny ökö jïï önyön. ");
INSERT INTO lth_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Un ibedo tar më lobo. Pacö n'ëgërö ï wi kidi ba twërö kanërë. ");
INSERT INTO lth_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ngat mörö ope na cwïnyö tara ëka ketho ï thë agulu. Ëntö eketho kanya oten malö ëka mënyö jö kïbëc na tye ï öt. ");
INSERT INTO lth_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ï yoo acël nön, mïï unu tar na mewu öryëny ï nyim jïï, ëk gïn önën ticwu na bëcö, ëka öpak gïnï Apapwu na tye ï polo.” ");
INSERT INTO lth_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kür ïtham unu nï an abino më jükö Cïk onyo köp k'edwarpïny; an ba abino më jükögï ëntö më cobogï. ");
INSERT INTO lth_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","An akobo niwu köp adyer nï wang na polo ëka lobo othuno ï ajiki, nyukuta mörö acël na tïdï onyo tön mörö acël më Cïk ba bino rwenyo, naka ka köp kïbëc ocobere. ");
INSERT INTO lth_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dong ka ngat mörö ötürö cïk mörö acël kï ï kom cïk ni gïnï, nakun pwonyo kï jö nökënë më tïmö nï kömanön, ebino cwodo ën nï dhanö na tïdï ï ker më polo. Ëntö ngat na ketho ï tic ëka pwonyo cïk ni ebino cwodo nï dhanö na dit ï ker më polo. ");
INSERT INTO lth_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ëntö an akobo niwu nï ka kite atïrwu ba ölöö më k'Eparicayo ëka më k'epwony cïk, un ba ibino dönyö ï ker më polo.” ");
INSERT INTO lth_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Un iwinyo köp na yam ekobo both jö na cön nï, ‘Kür ineki, ëka ka ngat mörö na bino neko dhanö, ebino ngölö-köp nïnë.’ ");
INSERT INTO lth_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ëntö an akobo niwu nï ngat mörö n'akëmö makö ï kom ömïn mërë ebino ngölö-köp nïnë. Ngat mörö na bino yanyö ömïn mërë nï, ‘In ibangiri,’ ebino tero ï nyim athuko më öd okiko k'edong. Ëntö ngat mörö na kobo nï, ‘In amingo’ ebino bolo ï mac më kapïny. ");
INSERT INTO lth_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Pï manön, ka ikelo mïcni ï keno tyër më mïö both Obanga ëka ipo nï omeru tye kï köp mörö ï komi, ");
INSERT INTO lth_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","wëk mïcni ï nyim keno tyër. Cïdh kono both omeru ëk ïrïb unu wat na bër ï kinwu; cë dong idwogi ëka ïmïï mïcni. ");
INSERT INTO lth_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tyek köp pïöpïö kï ngat n'odothi na pod itye unu ï yoo më cïdhö ï pido, ëk ngat n'odothi kür oteri ï nyim angöl-köp, cë angöl-köp bino mïöni both acikari, ëka ebino tweoni ï buc. ");
INSERT INTO lth_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","An akobo niwu köp adyer nï ba ibino donyo kï ï buc naka ka ïcülö cül kïbëc, na wi cïlïng mörö ba orem.” ");
INSERT INTO lth_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Un iwinyo köp na yam ekobo nï, ‘Kür ïdöny ï elomi.’ ");
INSERT INTO lth_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ëntö an akobo niwu nï ka ngat mörö önënö dhakö cë öthamö kï ï cwinye më bedo ködë nwongo ödönyö ï elomi. ");
INSERT INTO lth_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ka wangi më kucem ënë mii ipodho ï bal, köl iyuu ökö. Bër nini më rwenyo dul komi acël nï löönö bolo komi kïbëc ï mac më kapïny. ");
INSERT INTO lth_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ka cingi më kucem ënë mii ipodho ï bal, ngun iyuu ökö. Bër nini më rwenyo dul komi acël nï löönö bolo komi kïbëc ï mac më kapïny.” ");
INSERT INTO lth_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Un iwinyo cïk na kobo nï, ‘Ngat mörö na kwërö dhakö mërë myero ömïï waraga më këthö nyom.’ ");
INSERT INTO lth_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ëntö an akobo bothwu nï ka ngat mörö ökwërö dhakö mërë, na path kï köp më tar wang, nwongo ömïö dhakö nön ödökö jö elomi, ëka ngat mörö na nyömö dhakö n'ëkwërö ökö nwongo ödönyö ï elomi.” ");
INSERT INTO lth_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Dökï, un iwinyo köp na yam ekobo both jö na cön nï, ‘Kür ikwong kwong nono, ëntö cob kwong na in ikwongo both Rwoth.’ ");
INSERT INTO lth_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ëntö an akobo niwu, kür ikwong unu kwong mörö na twal, kadï kï polo pïën manön obedo then ker k'Obanga; ");
INSERT INTO lth_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","onyo kï nyïng lobo, pïën manön obedo then më theno tyënë; onyo kï nyïng Jerucalem, pïën manön obedo pacö k'Obanga, Rwoth na Dit. ");
INSERT INTO lth_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kür ikwong kwong kï wii, pïën in ba ïtwërö mïö yer mörö acël më bedo na tar onyo na cöl. ");
INSERT INTO lth_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mïï unu köpwu obed nï, ‘Eyo’ obed ‘eyo,’ onyo ‘Pe’ obed ‘pe.’ Köp mörö na kadhö manön nwongo öya kï both ngat na rac.” ");
INSERT INTO lth_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Un iwinyo köp na yam ekobo nï, ‘Wang ëcülö kï wang, ëka lak ëcülö kï lak.’ ");
INSERT INTO lth_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ëntö an akobo niwu nï kür ïcül unu kwor ï kom ngat mörö n'ötïmö gin na rac ï komi. Ka ngat mörö odhongo lemi kucem, lök nïnë lemi nökënë thon. ");
INSERT INTO lth_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ka ngat mörö mïtö pidoni nï ëk eter catïni, mïï ën thon kotini. ");
INSERT INTO lth_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ka ngat mörö odii më yëö yëc mërë pï kilomita acël, woth ködë pï kilomita arïö. ");
INSERT INTO lth_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ka dhanö mörö ökwaö gin mörö kï bothi, mïï gin nön bothe. Ka ngat mörö mïtö deno gin mörö kï bothi, mïï ën oden.” ");
INSERT INTO lth_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Un iwinyo köp na yam n'onwongo ekobo nï, ‘Mar awodhi ëka ïdag langöni.’ ");
INSERT INTO lth_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ëntö an akobo niwu: Mar unu langwu ëka ïlëg unu pï jö na yelowu, ");
INSERT INTO lth_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ëk ibed unu calö ëthïnö k'Apapwu adyer na tye ï polo. Pïën ën mïö ceng mërë ryëny both jö na reco ëka kï jö na bëcö. Ën mïö köth both jö na kitegï atïr ëka both jö na kitegï ba tye atïr. ");
INSERT INTO lth_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ka ïmarö unu jö na maröwu, cül ngö n'Obanga bino cülöwu ködë? Naka thon ëcök ocoro tïmö gïnï nï kömanön. ");
INSERT INTO lth_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ka imotho unu utmegowu këkën, apokapoka ngö na tye ï kinwu kï jö nökënë? Naka thon jö na ba ngeo Obanga tïmö nï kömanön. ");
INSERT INTO lth_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Myero ibed unu jö na bal mörö ope ï komgï, na calö Apapwu na tye ï polo na bal mörö ope ï kome.” ");
INSERT INTO lth_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Gwökërë unu ëk kür itii unu ‘ticwu më kite atïr’ ï nyim jïï ëk gïn önën. Ka ïtïmö unu, ba ibino unu nwongo cül mörö kï both Apapwu na tye ï polo. ");
INSERT INTO lth_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ka ïkönyö acan, kür ïküdh pelu kite n'etwodo tïmö ï Cinagoga gïnï ëka ï yodhi, ëk jïï öwörgï. An akobo niwu köp adyer nï gïn dong onwongo cülgï ökö. ");
INSERT INTO lth_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ëntö ka ïkönyö acan, kür ïmïï cingi më kucam onge gin na cingi më kucem tye ka tïmö, ");
INSERT INTO lth_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ëk köny na in ïmïö both acan obed ï müng. Cë Apapwu, na nënö gin n'ëtïmö ï müng, bino cülöni. ");
INSERT INTO lth_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ka in ïlëgö, kür ïlëg calö etwodo, pïën gïn marö lëga nakun nwongo ocung gïnï ï cinagoga gïnï ëka ï nget yodhi ëk jïï önën-gï. An akobo niwu köp adyer nï gïn dong otyeko nwongo cülgï ökö. ");
INSERT INTO lth_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ëntö ka in ïlëgö, döny ï odi, lor dholokek ëka ïlëg both Apapni na kome ba nen. Cë Apapwu, na nënö gin n'ëtïmö ï müng, bino cülöni. ");
INSERT INTO lth_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ka in ïlëgö, kür idhur köp na pol calö jö na ba ngeo Obanga, pïën gïn thamö nï ebino winyo lëgagï pï köpgï na pol. ");
INSERT INTO lth_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kür ïlëg unu kamë gïn, pïën Apapwu ngeo gin na mïtërë bothwu na bara ipenyo ën. ");
INSERT INTO lth_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Man ënë kite na myero ïlëg unu ködë: “ ‘Apapwa na tye ï polo, nyingi myero ëwör, ");
INSERT INTO lth_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","kerni obin, mitini ëtïm ï lobo kite n'ëtïmö ködë ï polo. ");
INSERT INTO lth_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mïïwa tin cemwa më nïnö kï nïnö. ");
INSERT INTO lth_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tïm kïca ï kom balwa, kite na wan thon ëtïmö kïca ï kom jö na balö bothwa. ");
INSERT INTO lth_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kür ïwëk ëbwölwa, ëntö larwa kï both ngat na rac.’ ");
INSERT INTO lth_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ka un ïtïmö kïca both jö nökënë ka gïn öbalö ï komwu, Apapwu na tye ï polo thon bino tïmö kïca ï kom balwu. ");
INSERT INTO lth_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ëntö ka in ba ïtïmö kïca both jö nökënë pï bal na gïn öbalö, Apapwu thon ba bino tïmö kïca pï bal na in ïbalö. ");
INSERT INTO lth_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ka in irio kec, kür ïmïï wangi onen calö wang etwodo, pïën gïn balö wang-gï ökö ëk jïï önën nï gïn etye ka rio kec. An akobo niwu köp adyer, gïn dong otyeko nwongo cülgï ökö. ");
INSERT INTO lth_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ëntö ka in irio kec, kur wii, ëka ïlwök wangi, ");
INSERT INTO lth_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ëk kür jö nökënë önën nï in itye ka rio kec, ëntö both Apapwu këkën na ba nen; cë Apapwu na nënö gin n'ëtïmö ï müng bino cülöni.” ");
INSERT INTO lth_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kür ïkan lönyöwu ï wi lobo, kanya nyënyë ëka nyalï balö, ëka kanya ekwoe türö cë kwalö gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ëntö kan unu lönyöwu ï polo, kanya nyënyë ëka nyalï ba balö, ëka kanya ekwoe ba türö cë kwalö gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pïën kanya lönyöni tye ïë ënë cwinyi thon tye ïë. ");
INSERT INTO lth_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Wangi ënë obedo tara më komi. Ka wangi tye na bër, komi kïbëc nwongo tye kï tar n'örömö. ");
INSERT INTO lth_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ëntö ka wangi ba tye na bër, komi kïbëc nwongo opong kï cöl pïny. Ka tar na tye bothi cöl, cöl pïny nön nwongo röm kwene! ");
INSERT INTO lth_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ngat mörö ope na römö tic pï rwodhi arïö; pïën ën bino dagö ngat acël ëka bino marö nökënë ca; onyo ën bino moko ï kom ngat acël ëka kwërö nökënë ca. In ba ïrömö tic pï Obanga ëka pï cïlïng thon. ");
INSERT INTO lth_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Pï manön an akobo niwu nï, kür ibed unu kï par pï kwöwu, nï ngö na un ibino camö onyo madhö; onyo pï komwu, nï ngö na un ibino ruko. Kwöwu pïrë ba tëk löö cem, ëka kom pïrë ba tëk löö böng? ");
INSERT INTO lth_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nën unu wïny na ngwëcö kï malö; gïn ba cwöö kodhi, ba kaö gïnï kac, ba cökö gïnï cem ï dërö, ëntö Apapwu na tye ï polo pïdhögï. Un pïrwu ba tëk löögï? ");
INSERT INTO lth_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nga kï ï kinwu pï bedo kï par na twërö mëdö caa acël ï kom kwö mërë? ");
INSERT INTO lth_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Pïngö ibedo unu kï par na pol pï böng? Nën unu kite n'athure më thim döngö gïnï ködë. Gïn ba tio tic mörö onyo wïö wicu. ");
INSERT INTO lth_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ëntö akobo niwu nï kadï bed Colomon onwongo orukere kï dheo mërë kïbëc, ën ba orukere na bër na cal kï mörö acël ï kin-gï. ");
INSERT INTO lth_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ka Obanga ruko lum më thim, na bedo pï nïnö na tin këkën ëka diki ebolo ökö ï mac, ën ba bino rukowu na löö, un jö na yeewu nönök? ");
INSERT INTO lth_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Dong kür ibed unu kï par më kobo nï, ‘Ngö na wan ebino camö?’ onyo ‘Ngö na wan ebino madhö?’ onyo ‘Ngö na wan ebino ruko?’ ");
INSERT INTO lth_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pïën jami nonu kïbëc, jö na ba ngeo gïnï Obanga ënë yënyögï, ëntö Apapwu na tye ï polo ngeo gin na kïbëc na mïtërë bothwu. ");
INSERT INTO lth_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ëntö cak unu kono më rangö ker mërë ëka kite atïr mërë, cë ën bino mïöwu jami kïbëc na un ïmïtö. ");
INSERT INTO lth_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pï manön, kür ibed unu kï par na pol pï diki, pïën diki bino bedo kï par mërë. Nïnö acëlacël tye kï can mërë. ");
INSERT INTO lth_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kür ïngöl köp ï kom jö nökënë, cë in thon ba ebino ngölö köp ï komi. ");
INSERT INTO lth_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pïën kite na in ïngölö kï köp ï kom jö nökënë, ënë in thon ebino ngölö kï köp ï komi, ëka gin na un ipimo ködë, ënë thon ebino pimo niwu ködë. ");
INSERT INTO lth_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Pïngö ïnënö cüng kal kï ï wang omeru ëka ba ïnënö dul yath na tye ï wangi? ");
INSERT INTO lth_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","In ïtwërö kobo n'omeru nïngö nï, ‘Wëk akwany cüng kal ökö kï ï wangi,’ nakun nwongo caa kïbëc dul yath ut ï wangi? ");
INSERT INTO lth_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","In atwodo, cak kono kwanyö dul yath na tye ï wangi ökö, ëka dong ïnën pïny na bër më kwanyö cüng kal na tye ï wang omeru. ");
INSERT INTO lth_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kür ïmïï gwongi jami n'ëmïö both Obanga, kür iyuu jamini na bëcö na wel mërë tëk both pün. Ka iyuo, gïn bino nyönyönö ökö kï tyën-gï, cë lökërë gïnï më lwëny ï komi. ");
INSERT INTO lth_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Peny cë ebino mïöni; rang cë ibino nwongo; dwöng cë ebino yabö nini dholokek. ");
INSERT INTO lth_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pïën ngat acëlacël na penyo ebino mïö; ngat na rangö bino nwongo; ëka ngat na dwöngö ebino yabö nïnë dholokek. ");
INSERT INTO lth_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nga kï ï kinwu, ka athïn mërë openyo ogati, ën mïö kidi? ");
INSERT INTO lth_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Onyo ka openyo rëc, ën mïö thwol? ");
INSERT INTO lth_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ka un, dong, na kitewu reco, ingeo unu më mïö ëthïnöwu mïc na bëcö, cë dong apapwu na tye ï polo bino mïö mïc na bëcö na röm kwene both jö na penyo ën! ");
INSERT INTO lth_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Gin na kïbëc na in ïtïmö, tïm both jö nökënë kite na in ïmïtö nï ëtïm ködë bothi, pïën man ënë tyën köp më cïk kïbëc ëka pwony k'edwarpïny. ");
INSERT INTO lth_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Döny kï ï dhö wangkac na dïng. Pïën dhö wangkac më kapïny lac ëka yoo më cïdhö yo ïë lübö yot, ëka jö na pol wok kï ïë. ");
INSERT INTO lth_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ëntö dhö wangkac më kwö na bedo naka dïng ëka yoo më cïdhö yo ïë lübö tëk, jö na nönök ënë wok kï ïë. ");
INSERT INTO lth_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Gwökërë unu k'edwarpïny na twot. Gïn bino bothwu n'orukere gïnï calö rom kï yökö ëntö kï ïgï nwongo ger gïnï kamë orudi. ");
INSERT INTO lth_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Un ibino ngeogï kï nyig-gï. Jïï römö püdö nyig ölök kï kom öküdhö, onyo nyig ölam kï kom öcöcök? ");
INSERT INTO lth_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kömanön thon yath na bër nyakö nyige na bër, ëntö yath na rac nyakö nyige na rac. ");
INSERT INTO lth_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yath na bër ba römö nyakö nyige na rac, ëka yath na rac ba römö nyakö nyige na bër. ");
INSERT INTO lth_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Koth yath kïbëc na ba nyakö nyige na bër ebino tongo ökö pïny ëka ebolo ï mac. ");
INSERT INTO lth_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Manön ënë kite na un ibino ngeogï ködë kï nyig-gï. ");
INSERT INTO lth_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Pathï ngat acëlacël na cwoda nï, ‘Rwoth, Rwoth,’ ënë bino dönyö ï ker më polo, ëntö ngat na tïmö gin n'Apapna na tye ï polo mïtö. ");
INSERT INTO lth_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ï nïnö nön, jö na pol bino kobo nïna nï, ‘Rwoth, Rwoth, wan yam ëtïtö köp kï nyingi, ëka kï nyingi wan ëryëmö cene ëka etio tango na pol.’ ");
INSERT INTO lth_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Cë an abino kobo nïgï nï, ‘Anaka yam ba angeowu. Cïdh unu ökö kï botha, un ëtïm tïm na reco!’ ");
INSERT INTO lth_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Pï manön ngat acëlacël na winyo köpna ëka ketho ï tic bino bedo calö dhanö na ryëk n'ögërö ödë ï kom lëla. ");
INSERT INTO lth_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ka köth ocwe, kïlëlë ömöl, ëka yamö okudho obuko öt kï tëk, ëntö ba opodho pïën nwongo ëgërö ï kom lëla. ");
INSERT INTO lth_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ëntö ngat na winyo köpna ni cë ba ketho ï tic cal k'amingo n'ögërö ödë ï kom kwo. ");
INSERT INTO lth_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ka köth ocwe, kïlëlë ömöl, ëka yamö okudho obuko öt kï tëk, cë öt bino rëdhërë na rac.” ");
INSERT INTO lth_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ï karë na Yecu dong otyeko twakö köp nonu kïbëc, lwak ouro pwony mërë rwök, ");
INSERT INTO lth_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","pïën ën opwonyo calö ngat na ut kï twër, pathï calö epwonyegï më cïk. ");
INSERT INTO lth_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ï karë na Yecu oidho yo pïny kï ï wi kidi, lwak na pol ölübö körë. ");
INSERT INTO lth_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ëcwö mörö na tye kï two dhöbü obino bothe ëka orumo cöngë pïny ï nyime nakun kobo nï, “Rwoth, ka in ïmïtö, ïrömö mïöna dökö na leng.” ");
INSERT INTO lth_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yecu öryëö cïngë cë ogudo ën nakun kobo nï, “An amïtö, komi dong obed na leng!” Cë cücüth two dhöbü öcang ökö kï ï kome. ");
INSERT INTO lth_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Cë Yecu okobo nïnë nï, “Kür ikob both ngat mörö. Ëntö cïdhï inyuthiri both alamdhök ëka ïmïï tyër na Muca yam öcïkö, më bedo na calö caden bothgï.” ");
INSERT INTO lth_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ï karë na Yecu ödönyö ï Kaperanaum, adit wi acikari më Roma mörö obino cë öbakö dhögë bothe nï, ");
INSERT INTO lth_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Rwoth, aticna obuto pïny ï öt, two akwea ömakö ëka ödïö ën rwök.” ");
INSERT INTO lth_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yecu okobo nïnë nï, “An abino cïdhö ëka acangö ën.” ");
INSERT INTO lth_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Adit wi acikari ögamö nï, “Rwoth, an ba apora nï in ïdöny ï öda. Ëntö kob köp acël këkën cë aticna bino cang. ");
INSERT INTO lth_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pïën an kikoma thon abedo dhanö n'ëlöö alöa, ëka atye k'acikari na an alöögï. An akobo both ngat acël nï, ‘Cïdhï,’ cë cïdhö; ëka both ngat acël nï, ‘Bin,’ cë bino. Ka an akobo both aticna nï, ‘Tii ticni,’ cë tïmö.” ");
INSERT INTO lth_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ï karë na Yecu owinyo köp ni, ën obedo kï ur rwök nakun kobo both jö na tye ka lübö körë nï, “An akobo niwu köp adyer, an bara anwongo dhanö mörö ï lobo Icarael na tye kï yee na tëk calö man. ");
INSERT INTO lth_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","An akobo niwu nï jö na pol bino bino gïnï kï kukïdë ëka kuthö, cë bino bedo gïnï pïny kanya acël k'Abraam, Icaka, ëka Jakob më camö karama ï ker më polo. ");
INSERT INTO lth_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ëntö jö n'onwongo myero obed gïnï ï ker më polo ebino bologï yökö ï cöl pïny, kunön bino bedo ïë koko ëka kaö lak.” ");
INSERT INTO lth_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Cë Yecu okobo both adit wi acikari nï, “Cïdhï! Ebino tïmö kite na in iyee ködë.” Atic mërë öcakö cang ökö ï caa nön kikokome. ");
INSERT INTO lth_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ï karë na Yecu ödönyö ï öt ka Petero, ën önënö marö ka Petero obuto pïny na two lyetho ömakö. ");
INSERT INTO lth_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ën ömakö cïngë ëka two lyetho öya ökö kï ï kome, cë marö ka Petero öya malö ëka öcakö yübö cem nïnë. ");
INSERT INTO lth_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ï kothyeno më nïnö nön, jö na pol n'onwongo tye gïnï kï tipo na reco ï komgï ekelo both Yecu, cë ën öryëmö tipo na reco ökö kï köp na ën ötwakö ëka etwoe kïbëc öcang. ");
INSERT INTO lth_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Man ötïmërë ëk köp na yam adwarpïny Icaya ötwakö ocobere kakarë nï: “Ën ökwanyö görüwa ëka öyëö twowa.” ");
INSERT INTO lth_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ï karë na Yecu önënö lwak na pol n'ögürö ën dyere, ën ömïö twërö më cïdhö yo löka nam tung ca. ");
INSERT INTO lth_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Cë apwony cïk obino bothe ëka okobo nï, “Apwony, an abino lübö kori kanya kïbëc na in ibino cïdhö ïë.” ");
INSERT INTO lth_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yecu ögamö nï, “Kwee tye kï öd rwo gïnï ëka wïny na ngwëcö kï malö tye kï udi, ëntö Wod ka Dhanö ope kï kany mörö na ën pyelo wie ïë.” ");
INSERT INTO lth_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Alübkörë nökënë dökï okobo nïnë nï, “Rwoth, wëk an kono acïdh aik apapna.” ");
INSERT INTO lth_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ëntö Yecu okobo nïnë nï, “Lüb köra, ëka wëk jö n'öthöö oik jöögï n'öthöö.” ");
INSERT INTO lth_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Cë Yecu ödönyö ï yeya ëka ëlübkörë öcïdhö ködë. ");
INSERT INTO lth_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Cücüth yamö na ger öcakö kudho ï nam, ëka pii na tingere malö onwongo dong cwök mïö yeya më lüny ökö ï nam. Ëntö Yecu onwongo önïnö ökö. ");
INSERT INTO lth_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ëlübkörë öcïdhö ëka ocoo gïnï ën nakun kobo gïnï nï, “Rwoth, larwa! Wan ëcwök thöö!” ");
INSERT INTO lth_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ën ögamö nï, “Un jö na yeewu nönök, pïngö ilwor unu?” Cë ën öya malö ocoko yamö ëka pii na tingere malö, cë pïny okwe moth. ");
INSERT INTO lth_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ëlübkörë ouro gïnï nakun kobo gïnï nï, “Koth ëcwö mënë ene? Naka thon yamö ëka pii na tingere malö winyo ën!” ");
INSERT INTO lth_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ï karë na Yecu othuno ï löka ca ï lobo ka jö Gadara, cwö arïö na tye kï cene n'öya gïnï kï ï bur lyene oromo ködë. Gïn onwongo ger rwök na ngat mörö ope na römö wok ï yoo nön. ");
INSERT INTO lth_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Gïn öcakö redo nï, “Wod k'Obanga, ngö na in ïmïtö kï bothwa? In ibino më pwodowa na karë bara örömö?” ");
INSERT INTO lth_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Onwongo öthïpan pün na pol tye ka cem na bobor ködgï. ");
INSERT INTO lth_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Cene ökwaö Yecu nï, “Ka in ïryëmöwa ökö, ryëmwa ï kom öthïpan pün.” ");
INSERT INTO lth_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ën okobo nïgï nï, “Cïdh unu!” Cë gïn odonyo yökö kï ï kom cwö nön ëka ödönyö gïnï ï kom pün, öthïpan pün kïbëc öngwëcö kï ï nget kidi yo ï nam ëka öthöö gïnï ökö ï pii. ");
INSERT INTO lth_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ëkwath n'onwongo kwaö pün öngwëcö gïnï ökö ï taun ëka okobo gïnï gin n'ötïmërë kïbëc ëka gin n'ötïmërë ï kom cwö na cene ömakögï. ");
INSERT INTO lth_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Cë jö na tye ï taun kïbëc öcïdhö gïnï yökö më romo kï Yecu. Ï karë na gïn önënö ën, gïn odweko gïnï Yecu më yaa ökö kï ï lobogï. ");
INSERT INTO lth_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yecu ödönyö ï yeya ëka öngölö nam yo löka tung ca, cë obino ï taun më thurgï. ");
INSERT INTO lth_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jö mökö okelo bothe dhanö na kome okwe n'obuto ï ökëka. Ï caa na Yecu önënö yeegï, ën okobo both dhanö na kome okwe nï, “Dïï cwinyi, woda; balni gïnï ëtïmö kïca ökö.” ");
INSERT INTO lth_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ëntö epwony cïk mökö okobo ï kin-gï kën-gï nï, “Dhanö ni tye ka yanyö Obanga!” ");
INSERT INTO lth_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ï karë na Yecu ongeo thamagï, cë openyogï nï, “Pïngö ibedo unu kï thama na rac ï cwinywu? ");
INSERT INTO lth_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mënë na yot: më kobo nï, ‘Balni gïnï dong ëtïmö kïca ökö,’ onyo më kobo nï, ‘Yaa malö ïcak woth’? ");
INSERT INTO lth_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ëntö an abino mïöwu ingeo nï Wod ka Dhanö tye kï twër ï wi lobo më tïmö kïca ï kom bal gïnï.” Cë ën okobo both dhanö na kome okwe nï, “Ya malö, kwany ökëkani ëka ïcïdh yo pacö.” ");
INSERT INTO lth_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Cë dhanö na kome okwe öya malö ëka öcïdhö yo pacö. ");
INSERT INTO lth_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ï karë na lwak önënö ngö n'ötïmërë, lworo ömakögï rwök; ëka öpakö gïnï Obanga, n'ömïö koth twërö nön both jïï. ");
INSERT INTO lth_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ï karë na Yecu öya ökö kï kunön, ën önënö ëcwö mörö n'obedo acök ocoro na nyïngë Matayo obedo kanya onwongo ëcökö ocoro ïë. Yecu okobo nïnë nï, “Lüb köra,” cë Matayo öya malö ëka ölübö körë. ");
INSERT INTO lth_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na Yecu ëka ëlübkörë tye gïnï ka cem ï öt ka Matayo, ëcök ocoro na pol ëka ëbal obino cë ocemo gïnï ködë. ");
INSERT INTO lth_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ï karë n'Eparicayo önënö gin na tye ka tïmërë, gïn openyo ëlübkörë nï, “Pïngö apwonywu cemo kanya acël k'ëcök ocoro ëka ëbal?” ");
INSERT INTO lth_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ï karë na Yecu owinyo köp ni, ën okobo nï, “Pathï jö na komgï yot ënë mïtö daktar, ëntö jö na two. ");
INSERT INTO lth_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ëntö cïdh ipwonyere unu ï tyën köp ni: ‘An amïtö kïca, pathï gin më aryëda.’ Pïën an ba abino më cwodo jö na kitegï atïr, ëntö ëbal.” ");
INSERT INTO lth_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ï nïnö mörö acël ëlübkör Jon obino both Yecu ëka openyo gïnï ën nï, “Pïngö wan ëka Eparicayo erio kec, ëntö ëlübkori ba rio gïnï kec?” ");
INSERT INTO lth_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yecu ögamö nï, “Wele k'anyom twërö kumo nïngö ka anyom tye ködgï? Ba twërë! Karë tye ka bino n'ebino kwanyö anyom ökö kï bothgï; cë gïn dong bino rio kec. ");
INSERT INTO lth_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ngat mörö ope na dapö böngü na nyen ï kom böngü n'otii, pïën böngü n'ëdapö bino tëlö böngü nökënë ca ëka yëc ökö na rac. ");
INSERT INTO lth_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dhanö mörö ope na pïkö köngö ölök na nyen ï ocwe na cön gïnï. Pïën ka gïn öpïkö, ocwe bino mwoc ökö, köngö ölök thon bino öny ökö cë ocwe bino bal gïnï ökö. Pe, köngö ölök na nyen ëpïkö ï ocwe na nyen gïnï, ëka gïn kïbëc ba bino bal.” ");
INSERT INTO lth_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ï karë na Yecu tye ka kobo köp ni, alöc mörö obino bothe cë orumo cöngë pïny ï nyime ëka okobo nïnë nï, “Nyara pod öthöö athöa, ëntö bin ëk iketh cingi ï kome, cë bino kwö.” ");
INSERT INTO lth_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yecu ëka ëlübkörë öya ëka öcïdhö ködë. ");
INSERT INTO lth_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Cë dhakö mörö n'onwongo remo obedo ka cwer kï ï kome pï mwaka apar wie arïö obino kï kungee cë ogudo lak böngü ka Yecu. ");
INSERT INTO lth_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ën okobo kï ï cwinye kënë nï, “Ka agudo böngü mërë këkën, abino cang ökö.” ");
INSERT INTO lth_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yecu ölökërë cë önënö ën, ëka okobo nïnë nï, “Dïï cwinyi, nyara, yeeni ocangi.” Cë dhakö nön öcang ökö ï caa nön cücüth. ");
INSERT INTO lth_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ï karë na Yecu ödönyö ï dyekal k'alöc cë önënö ewer na wero wer më kumo ëka lwak na wöö gïnï kï koko, ");
INSERT INTO lth_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ën okobo nï, “Döny unu yökö. Anyaka ni ba öthöö ëntö önïnö anïna.” Ëntö gïn önyërö gïnï ën. ");
INSERT INTO lth_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kinge na lwak dong odonyo ökö yökö, ën öcïdhö ï öt kanya epyelo nyakö ïë ëka ömakö cïng anyaka nön cë öya malö. ");
INSERT INTO lth_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Köp më emuth ni ökëth örömö lobo nön kïbëc. ");
INSERT INTO lth_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kinge na Yecu dong öya ökö kï kany nön, ëthöö wang arïö ölübö gïnï körë nakun redo gïnï nï, “Kïca omaki ï komwa, Wod ka Daudi!” ");
INSERT INTO lth_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ï karë na ën dong ödönyö ï öt, ëthöö wang arïö obino gïnï bothe ëka Yecu openyogï nï, “Un iyee unu nï an atwërö mïöwu ïnënö pïny?” Gïn ögamö nï, “Eyo, Rwoth.” ");
INSERT INTO lth_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Cë ën ogudo wang-gï ëka okobo nï, “Ëk ötïmërë bothwu kite na yeewu tye ködë.” ");
INSERT INTO lth_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Cë wang-gï öyabërë. Yecu öcïkögï na tëk nï, “Kür ikob unu köp ni both ngat mörö.” ");
INSERT INTO lth_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ëntö gïn öcïdhö ëka örwëö gïnï köp ï kom Yecu örömö lobo nön kïbëc. ");
INSERT INTO lth_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Na gïn dong tye ka yaa më cïdhö, jïï okelo dhanö mörö both Yecu n'onwongo cen ömakö ëka na ba twak. ");
INSERT INTO lth_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kinge na dong Yecu öryëmö cen ökö, dhanö nön n'onwongo ba twak öcakö twak. Lwak ouro nakun kobo gïnï nï, “Anaka yam gin mörö n'obedo köman bara onen ï Icarael.” ");
INSERT INTO lth_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ëntö Eparicayo okobo gïnï nï, “Ën ryëmö cene kï twër k'adwong më cene.” ");
INSERT INTO lth_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yecu öcïdhö orimo kin peci kïbëc na papath nakun pwonyo ï cinagogagï gïnï, tïtö köp më Emuth na Bër më ker k'Obanga ëka cangö koth twoe kïbëc na papath. ");
INSERT INTO lth_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ï karë na ën önënö lwak, kïca ömakö ï komgï rwök, pïën onwongo tye gïnï kï par ëka ëwëkögï ata calö rom n'akwathgï ope. ");
INSERT INTO lth_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Cë okobo both ëlübkörë nï, “Kac dwong ëntö etic tye na nönök. ");
INSERT INTO lth_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pï manön, peny unu won pwodho ëk oor etic ï kac ï pwodho mërë.” ");
INSERT INTO lth_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yecu ocwodo ëlübkörë apar wie arïö bothe ëka ömïögï twërö më ryëmö tipo na reco ëka më cangö twoe na papath kïbëc. ");
INSERT INTO lth_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Man ënë nyïng ëkwëna apar wie arïö: më acël, Cimon (n'ecwodo nï Petero) ëka ömïn mërë Anderiya; Yakobo wod ka Jebedayo, ëka ömïn mërë Jon; ");
INSERT INTO lth_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipo ëka Batulumayo; Tomaci ëka Matayo n'obedo acök ocoro; Yakobo wod k'Alipayo, ëka Tadeo; ");
INSERT INTO lth_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Cimon na mïtö löckën ëka Yuda Ikariot, n'oketho örörö ï kom Yecu. ");
INSERT INTO lth_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yecu ooro ëkwëna apar wie arïö kï cïk ni: “Kür ïcïdh unu both Erok onyo ïdöny unu ï taun ka jö Camaria mörö. ");
INSERT INTO lth_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ëntö cïdh unu both jö Icarael, na cal gïnï kï rom n'orwenyo. ");
INSERT INTO lth_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ka ïcïdhö unu, tït unu köp ni: ‘Ker më polo dong cwök.’ ");
INSERT INTO lth_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cang unu etwoe, cer unu jö n'öthöö, löny unu jö na tye kï two dhöbü, ëka ïryëm unu cene. Ëmïöwu nono, ëka un thon mïï unu nono. ");
INSERT INTO lth_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kür iwoth unu kï gol onyo ryal onyo mola mörö ï jëbawu; ");
INSERT INTO lth_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","kür iwoth unu k'ocwe ï wothwu, onyo böngü më alöka, onyo wör, onyo lüth më woth; pïën atic myero ëmïï cem mërë. ");
INSERT INTO lth_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Taun onyo pacö mörö këkën na un ibino dönyö ïë, rang unu dhanö na kite mërë bër ëka ibed unu ï ödë naka ka ibino unu yaa. ");
INSERT INTO lth_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ka ïdönyö unu ï öt, moth unu jö më öt nön kï moth më kuc. ");
INSERT INTO lth_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ka jö më öt nön öjölöwu, wëk unu kucwu odong ïë; ëntö ka ba öjölöwu gïnï, cë ïmïï kucwu odwog bothwu. ");
INSERT INTO lth_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ka ngat mörö ba bino jölöwu onyo winyo köpwu, tëng unu apua më tyënwu ka ïya unu kï ï öt nön onyo taun nön. ");
INSERT INTO lth_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","An akobo niwu köp adyer, ï nïnö më ngölö-köp, Obanga bino tïmö kïca na thwönë rwök both jö më Codom ëka Gomora na löö jö më taun nön. ");
INSERT INTO lth_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","An aorowu kamë rom ï kin orudi. Pï manön bed unu na ryëk calö thwol ëka na mwol calö amam. ");
INSERT INTO lth_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Ëntö gwökërë unu ködgï; pïën gïn bino mïöwu ï cïng ëlöc ëka ebino pwodowu kï del ï cinagogagï gïnï. ");
INSERT INTO lth_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ebino terowu ï nyim ëlöc ëka ï nyim rwodhi pïra na calö ecaden bothgï ëka both Erok. ");
INSERT INTO lth_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ëntö ka gïn ömaköwu, kür ibed unu kï par ï kom ngö na un ibino kobo onyo kite na un ibino kobo ködë. Ï caa nön ebino mïöwu ngö na myero ikob unu, ");
INSERT INTO lth_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","pïën pathï un ënë ibino twak, ëntö Tipo k'Apapwu ënë bino twak kï bothwu. ");
INSERT INTO lth_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Omego bino mïö ömïn mërë më aneka, ëka apap bino mïö athïn mërë më aneka; ëthïnö bino jëm ï kom enyodogï ëka bino gïnï mïö enekogï. ");
INSERT INTO lth_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jö kïbëc bino dagöwu pïra, ëntö ngat na bino cung na tëk naka ï ajiki bino larë. ");
INSERT INTO lth_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ka eyelowu kï ï kabedo mörö acël, lüü unu ï kabedo nökënë. An akobo niwu köp adyer, ba ibino unu tyeko woth ï peci më Icarael kïbëc na bara Wod ka Dhanö obino. ");
INSERT INTO lth_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Athïn kwan ba dit löö apwony mërë, onyo atic ba dit löö adwong mërë. ");
INSERT INTO lth_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pore both athïn kwan më bedo calö apwony mërë, ëka atic më bedo calö adwong mërë. Ka adit na löö öt ecwodo nï Belijebul, ebino cwodo jö më ödë kï nyïng na rac röm kwene! ");
INSERT INTO lth_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kür ibed unu kï lworo pïrgï. Gin mörö ope n'eumo na ba ebino yabö, onyo gin mörö ope n'opono na ba bino ngere. ");
INSERT INTO lth_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Köp na an akobo niwu ï cöl pïny, twak unu ökö na pïny lër; ëka köp n'ëmwöngö amwöngö ï ithwu, red unu ködë ï wi bie. ");
INSERT INTO lth_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kür ilwor unu jö na neko kom ëntö ba neko tipo. Ëntö lwor unu Obanga na twërö neko tipo ëka kom kanya acël ï mac kapïny. ");
INSERT INTO lth_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Wïny na thïthïnö arïö ba ëcadhögï pï cïlïng na nyïng? Ëntö mörö ope na twërö podho pïny n'Apapwu ba ngeo. ");
INSERT INTO lth_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Naka thon yer wiwu kïbëc ëkwanö ökö. ");
INSERT INTO lth_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dong kür ibed unu kï lworo; pïrwu tëk löö wïny na pol ca ökö. ");
INSERT INTO lth_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ngat mörö na bino tuco nyïnga ï nyim jïï, an thon abino tuco nyïngë ï nyim Apapna na tye ï polo. ");
INSERT INTO lth_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ëntö ngat na bino kwëröna ï nyim jïï, an thon abino kwërö ën ökö ï nyim Apapna na tye ï polo. ");
INSERT INTO lth_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kür ïtham unu nï an abino më kelo kuc ï lobo. An ba abino më kelo kuc, ëntö pala abadë. ");
INSERT INTO lth_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","An abino më kelo apokapoka ï kin “ ‘wod ëka apap mërë, nyakö ëka aya mërë, cii wod ëka adha mërë. ");
INSERT INTO lth_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Langö ka dhanö bino bedo dhanö më ödë kikokome.’ ");
INSERT INTO lth_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ngat mörö na marö apap mërë onyo aya mërë na löa ökö ba opore më bedo mëga; ngat mörö na marö wode onyo nyarë na löa ökö ba opore më bedo mëga; ");
INSERT INTO lth_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ëka ngat mörö na ba tingo yath arïa mërë cë lübö kï köra ba opore më bedo mëga. ");
INSERT INTO lth_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ngat mörö na mïtö gwökö kwö mërë bino rwenyo ökö, ëka ngat na rwenyo kwö mërë pïra bino larö kwö mërë. ");
INSERT INTO lth_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ngat na bino jölöwu, nwongo öjöla, ëka ngat n'öjöla nwongo öjölö ngat n'oora. ");
INSERT INTO lth_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ngat mörö na bino jölö adwarpïny pïën ën obedo adwarpïny bino nwongo cül n'ëcülö k'adwarpïny, ëka ngat mörö na bino jölö dhanö na kite atïr pïën ën obedo dhanö na kite atïr bino nwongo cül n'ëcülö kï dhanö na kite atïr. ");
INSERT INTO lth_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ëka ka ngat mörö ömïö pii na ngïc më amodha both ngat mörö acël kï ï kin jö na thïnö ni pïën ën obedo alübköra, an akobo niwu köp adyer, ën bino nwongo cül mërë.” ");
INSERT INTO lth_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ï karë na Yecu otyeko cïkö ëlübkörë apar wie arïö, ën öya kï kunön më pwony ëka më tïtö köp ï peci më Galilaya. ");
INSERT INTO lth_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ï karë na Jon owinyo kï ï buc ngö na Meciya onwongo tye ka tïmö, ën ooro ëlübkörë ");
INSERT INTO lth_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","më penyo ën nï, “In ënë ngat n'onwongo myero obin, onyo wan myero ëkür ngat nökënë?” ");
INSERT INTO lth_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Cë Yecu ögamö nïgï nï, “Dök unu cen ïcïdh ikob unu both Jon gin na un iwinyo ëka gin na un ïnënö: ");
INSERT INTO lth_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ëthöö wang wang-gï öyabërë, engwalo owotho, jö n'onwongo tye kï two dhöbü ëlönyögï, ëthöö ith owinyo pïny, jö n'öthöö ecerogï ökö, ëka köp më Emuth na Bër ëtïtö both ëcan. ");
INSERT INTO lth_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tye kï gum dhanö na ba lökërë ökö kï kom yee mërë pïra.” ");
INSERT INTO lth_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ï karë n'ëlübkör Jon tye ka donyo gïnï yökö, Yecu öcakö twak kï lwak köp ï kom Jon nï: “Ngö na un ïcïdhö më nënö kï ï thim? Ïcïdhö unu më nënö agada na yamö yengo? ");
INSERT INTO lth_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Cë ka pe, ngö na un ïcïdhö më nënö? Un ïcïdhö më nënö dhanö n'oruko böng na bëcö? Pe, jö na ruko böng na bëcö bedo gïnï ï peci ka rwodhi. ");
INSERT INTO lth_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Cë ngö na un ïcïdhö më nënö? Adwarpïny? Eyo, an akobo bothwu nï un ïnënö ngat na löö adwarpïny ökö. ");
INSERT INTO lth_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Man ënë ngat n'ëcöö köp ï kome: “ ‘An abino oro aorna ï nyimi, na ënë bino yübö yoo nini.’ ");
INSERT INTO lth_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","An akobo niwu köp adyer: Dhanö mörö ope kï kin jö na mon önywölögï na pïrë tëk na löö Jon Abatica, ëntö ngat na tïdï rwök ï ker më polo ënë dit löö ën. ");
INSERT INTO lth_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Cakërë ï karë ka Jon Abatica më thuno ködë naka tin ker më polo ölïmö can rwök, ëka jö na ger tëmö gïnï më maö kï tëk. ");
INSERT INTO lth_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pïën edwarpïny kïbëc ëka Cïk ka Muca odwaro gïnï naka othuno ködë ï karë ka Jon; ");
INSERT INTO lth_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ëka ka ïmïtö unu yeo köpgï, Jon ënë Eliya n'onwongo myero obin. ");
INSERT INTO lth_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ngat na ithe tye, myero ën owiny. ");
INSERT INTO lth_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“An abino poro rok më karë ni kï ngö? Cal k'ëthïnö na bedo ï kabedo më cuk gïnï ëka cwodo ewodhgï: ");
INSERT INTO lth_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Wan ëküdhö pelu pïrwu, ëka un ba ïmyël; wan ewero wer lyël, ëntö un ba ikumo.’ ");
INSERT INTO lth_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pïën Jon obino na ba cemo onyo madhö gin mörö, ëka gïn kobo nï, ‘Ën tye kï cen.’ ");
INSERT INTO lth_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Wod ka Dhanö obino na cemo ëka medho, ëka gïn kobo nï, ‘Ën obedo ngat n'owor ëka amërö, obedo okone k'ëcök ocoro ëka ëbal.’ Ëntö ryëkö ënë moko tic mërë na ën tio.” ");
INSERT INTO lth_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Cë kinge Yecu öcakö twak k'akëmö kï jö më peci nön kanya ën onwongo obedo ka tio tango mërë ïë, pïën jö na tye ïë ökwërö gïnï ngut ökö. ");
INSERT INTO lth_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ibino nënö can in, Korajin! Ibino nënö can in, Bethecaida! Ka tango n'onwongo ëtïmögï bothwu onwongo ëtïmö ï Turo ëka Cidon, kono onwongo ongut gïnï cön, nakun ruko gïnï böngü cöla ëka juko gïnï wigï kï buru. ");
INSERT INTO lth_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ëntö an akobo niwu nï Obanga bino tïmö kïca na thwönë rwök ï nïnö më ngölö-köp both jö më Turo ëka Cidon na lööwu. ");
INSERT INTO lth_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ëka in, Kaperanaum, ebino tingoni yo malö ï polo? Pathï kömanön, ebino dwököni pïny ï kabedo ka jö n'öthöö. Ka onwongo tango n'onwongo etio bothi onwongo etio ï Codom, onwongo twërö bedo naka ï karë ni. ");
INSERT INTO lth_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ëntö an akobo niwu nï Obanga bino tïmö kïca na thwönë rwök ï nïnö më ngölö-köp both jö më Codom na lööwu.” ");
INSERT INTO lth_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ï karë nön Yecu okobo nï, “An apaki Apap, Rwoth më polo ëka lobo, pïën ïkanö jami ni ökö kï both jö na ryëk ëka kï both jö na ngeo pïny, ëka inyutho both ëthïnö na pod thïnö. ");
INSERT INTO lth_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eyo, Apap, man ënë kite n'onwongo in ïmïtö nï ötïmërë ködë na yomo cwinyi.” ");
INSERT INTO lth_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Apapna otyeko mïö jami kïbëc ökö botha. Ngat mörö ope na ngeo Wod kono Apap këkën, ëka ngat mörö ope na ngeo Apap kono Wod këkën ëka both jö na Wod öyërö më nyutho ën.” ");
INSERT INTO lth_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Cë Yecu okobo nï, “Bin unu botha, jö kïbëc n'odhero ëka kï jö na yëc önüögï, cë an abino mïöwu yweo. ");
INSERT INTO lth_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ting unu ayokothna ëka inwong unu pwony kï botha, pïën an awör ëka amwol ï cwinya, ëka ibino unu nwongo yweo pï tipowu. ");
INSERT INTO lth_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pïën ayokothna yëö yot, ëka yëcna ba pëk.” ");
INSERT INTO lth_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ï karë nön Yecu owok ï pwothi n'epuro bël ïë k'ëlübkörë ï ceng Cabït k'Eyuda. Këc onwongo oneko ëlübkörë, cë gïn öcakö rïdhö with bël ëka omwodo gïnï. ");
INSERT INTO lth_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ëntö ï karë n'Eparicayo önënö, cë okobo gïnï both Yecu nï, “Nën, ëlübkori tye gïnï ka tïmö gin na cïk ökwërö nï kür ëtïm ï ceng Cabït k'Eyuda.” ");
INSERT INTO lth_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yecu okobo bothgï nï, “Un ba ïkwanö gin na Daudi ötïmö ï karë na kec oneko ën kanya acël k'ewodhe? ");
INSERT INTO lth_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ën ödönyö ï öt k'Obanga, cë Daudi ëka ewodhe öcamö ogati n'eketho ï nyim Obanga—n'onwongo cïk ökwërö nï gïn kür öcam, ëntö pï ëlamdhök këkën. ");
INSERT INTO lth_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Onyo un ba ïkwanö kï ï cïk nï ëlamdhök na tye ï öt k'Obanga twërö gïnï tic ï ceng Cabït k'Eyuda ëka nwongo ba öbalö gïnï? ");
INSERT INTO lth_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","An akobo niwu nï tye gin mörö kany na dit na löö öt k'Obanga. ");
INSERT INTO lth_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ka cë onwongo ingeo unu tyën köp ni, ‘An amïtö kïca, pathï lee më atyëra,’ onwongo myero kür dök ïngöl unu köp ï wi jö n'ope kï bal. ");
INSERT INTO lth_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pïën Wod ka Dhanö ënë obedo Rwoth më Cabït.” ");
INSERT INTO lth_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Cë Yecu öya ökö kï kunön ëka öcïdhö ödönyö ï cinagogagï, ");
INSERT INTO lth_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","kanya onwongo ëcwö mörö na cïngë ötal tye ïë. Eparicayo onwongo tye ka rangö gïnï kite mörö më dotho Yecu, cë openyo gïnï ën nï, “Cïk yeo nï ëcang dhanö ï ceng Cabït?” ");
INSERT INTO lth_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yecu okobo bothgï nï, “Ka ngat mörö kï kinwu tye kï römö acël cë opodho ï bur ï ceng Cabït, in ba ïmakö ëka ïywaö yökö? ");
INSERT INTO lth_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Dhanö pïrë tëk rwök löö römö ökö! Pï manön cïk yeo nï ëtïm gin na bër ï ceng Cabït.” ");
INSERT INTO lth_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Cë ën okobo both ëcwö nön nï, “Ryë badi.” Cë ëcwö nön öryëö badë, ëka badë öcang ökö na bër ödökö calö nökënë ca. ");
INSERT INTO lth_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ëntö Eparicayo odonyo yökö cë öyübö gïnï köp kite na myero enek gïnï kï Yecu. ");
INSERT INTO lth_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ï karë na Yecu ongeo yüb më nekonë, öya ökö kï kunön. Lwak na pol ölübö gïnï ën, cë Yecu öcangö jö kïbëc n'onwongo two. ");
INSERT INTO lth_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ën öcïkögï nï kür okob gïnï both jö nökënë köp ï kome. ");
INSERT INTO lth_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Man ötïmërë ëk köp n'onwongo adwarpïny Icaya ötwakö pïrë ocobere: ");
INSERT INTO lth_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Man ënë aticna na an ayërö, ngat na an amarö, na cwinya yom ï kome. An abino ketho Tipona ï kome, ëka ën bino kobo ngölö-köp atïr both erok. ");
INSERT INTO lth_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ën ba bino dhaa onyo ba bino redo rwök, ngat mörö ope na bino winyo dwönë ï yodhi. ");
INSERT INTO lth_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ën ba bino türö agada n'ogom, ëka ba bino neko wicu tara na tye ka dung, naka ka ën okelo ngölö-köp atïr ï löc. ");
INSERT INTO lth_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lobo kïbëc bino bedo kï gen pï nyïngë.” ");
INSERT INTO lth_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Cë ekelo both Yecu ëcwö mörö na cen tye ï kome n'onwongo wangë öthöö ëka ba twak. Yecu öcangö ëcwö nön ëk ötwakï ëka önën pïny. ");
INSERT INTO lth_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jö kïbëc obedo gïnï kï ur rwök ï kom gin na Yecu ötïmö ëka okobo gïnï nï, “Man twërö bedo Wod ka Daudi?” ");
INSERT INTO lth_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ëntö ï karë n'Eparicayo owinyo gïnï köp ni, okobo gïnï nï, “Dhanö ni ryëmö cen kï twërö ka Belijebul, na ënë obedo adit ka cene.” ");
INSERT INTO lth_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yecu ongeo ngö n'onwongo gïn tye ka thamö, cë okobo bothgï nï, “Ker kïbëc ka opokere ïë arïö bino bal ökö, ëka taun onyo öt ka opokere ïë arïö ba twërö cung. ");
INSERT INTO lth_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ka Catan ryëmö Catan, nwongo ën opokere ï dul arïö ï kome kënë. Cë dong ker mërë twërö cung nïngö? ");
INSERT INTO lth_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ka an aryëmö cen kï twërö ka Belijebul, jöwu dong ryëmö gïnï cen kï twërö ka nga? Pï manön, gïn ënë dong bino bedo gïnï ëngöl köpwu. ");
INSERT INTO lth_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ëntö ka an aryëmö cen kï twërö ka Tipo k'Obanga, cë ker k'Obanga obino dong ökö bothwu. ");
INSERT INTO lth_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Dhanö mörö ope na twërö dönyö ï öt ka ngat na tëk më yakö jami mërë, thwara ka ën öcakö tweno dhanö na tëk ni ökö ëka dong cakö yakö jami kï ï ödë. ");
INSERT INTO lth_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ngat n'ope kukura nwongo ën ba mïta, ëka ngat mörö na ba könya më cökö kanya acël köda këthö akëtha. ");
INSERT INTO lth_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pï manön akobo niwu, bal kïbëc ëka ayeny ëtwërö tïmö kïca ïë, ëntö bal më yanyö Tipo Naleng ba ebino tïmö kïca ïë. ");
INSERT INTO lth_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ngat mörö na twakö köp na rac ï kom Wod ka Dhanö ebino tïmö kïca nïnë, ëntö ngat na twakö köp na rac ï kom Tipo Naleng ba ebino tïmö kïca nïnë, kadï ï karë ni onyo ï karë na tye ka bino anyim. ");
INSERT INTO lth_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Yath na bër nyakö nyige na bëcö, ëka yath na rac nyakö nyige na reco, pïën yath engeo kï nyige. ");
INSERT INTO lth_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Un ëthïnö ororo, ïtwërö unu twakö köp na bër nïngö, nakun un jö na reco? Pïën köp na tye ï cwiny dhanö ënë dhö dhanö twakö. ");
INSERT INTO lth_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dhanö na bër kwanyö gin na bër kï kin jami mërë na bëcö na ën ökanö ï cwinye, ëka dhanö na rac kwanyö gin na rac kï kin jami na reco na ën ökanö ï cwinye. ");
INSERT INTO lth_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","An akobo niwu nï köp kïbëc më caröcarö na dhanö twakö na ba gwökërë gïnï ïë ebino pido pïrë ï nïnö më ngölö-köp. ");
INSERT INTO lth_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pïën kï köp na in ïtwakö ënë bino mïöni ïlöö köp, ëka kï köp na in ïtwakö ënë bino mïö ëngölö köp loi.” ");
INSERT INTO lth_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Cë jö mökö n'obedo Eparicayo ëka epwony cïk okobo gïnï both Yecu nï, “Apwony, wan ëmïtö nënö anyuth më tango na yaa kï bothi.” ");
INSERT INTO lth_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ëntö Yecu ögamö nï, “Rok na reco ëka jö na yeegï ope ï kom Obanga penyo gïnï pï anyuth më tango! Ëntö mörö ope n'ebino mïö na path k'anyuth k'adwarpïny Yona. ");
INSERT INTO lth_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pïën kite na calö Yona onwongo obedo ïï rëc na thwönë nïnö adek, kiceng ëka kiwor, kömanön Wod ka Dhanö bino bedo nïnö adek, kiceng ëka kiwor, ï ngöm. ");
INSERT INTO lth_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jö më Ninebi bino cung gïnï kï rok më karë ni ëka bino ngölö gïnï köp ï kome; pïën ongut gïnï ï karë më tïtö köp na Yona onwongo ötïtö, ëka kobedini ngat na dit na löö Yona tye kany. ");
INSERT INTO lth_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Alöc na dhakö na tye yo kukwap lobo bino cung kanya acël kï rok më karë ni ëka ngölö-köp ï kome; pïën ën öya kï ï ajiki lobo më winyo ryëkö ka Colomon, ëka ngat na dit na löö Colomon tye kany. ");
INSERT INTO lth_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ka tipo na rac öya ökö kï ï kom dhanö mörö, ën cïdhö rimo kabedo na pii ope ïë cë rangö ka yweo ëka ba nwongo kabedo mörö. ");
INSERT INTO lth_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Cë ën kobo nï, ‘An abino dök ï öt na an aya kï ïë.’ Ka othuno, cë nwongo öt tye nono, ëywëö na leng ëka ëyübö ökö na bër. ");
INSERT INTO lth_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Cë dong cïdhö kelo tipo na reco abïrö nökënë gïnï na löö ën ökö, cë dönyö gïnï ïë ëka bedo kany nön. Kinge dhanö nön bino bedo na rac na löö kite n'onwongo obedo ködë cön. Manön kite na bino bedo ködë ï kom rok na rac më karë ni.” ");
INSERT INTO lth_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ï karë na Yecu onwongo pod tye ka twak kï lwak, aya mërë ëka utmego mërë onwongo ocung gïnï yökö nakun mïtö gïnï twak ködë. ");
INSERT INTO lth_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Cë dhanö mörö okobo both Yecu nï, “Ayani ëka utmegoni ocung gïnï yökö mïtö twak kodi.” ");
INSERT INTO lth_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yecu ögamö nï, “Ayana ënë nga ëka utmegona ënë ngagï?” ");
INSERT INTO lth_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Cë Yecu öcïmö ëlübkörë, cë okobo nï, “Man ënë ayana ëka utmegona. ");
INSERT INTO lth_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pïën dhanö na tio gin n'Apapna na tye ï polo mïtö, manön ënë ömëra, amëra, ëka ayana.” ");
INSERT INTO lth_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ï nïnö acël nön Yecu öya ökö kï ï öt, cë öcïdhö obedo ï dhö nam. ");
INSERT INTO lth_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Lwak na pol rwök öcökërë gïnï bothe, ömïö ën ödönyö ï yeya cë obedo ïë, nakun jö kïbëc ocung gïnï ï dhö nam. ");
INSERT INTO lth_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Cë okobo bothgï köp na pol ï carolok, nakun kobo nï: “Apur öcïdhö më cwönö kodhi. ");
INSERT INTO lth_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ï karë na ën tye ka cwöc, kodhi mökö ökïr ï nget yoo, ëka wïny obino cë öcamö gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kodhi nökënë ökïr kanya obedo kitekite, na ngöm nönök ïë. Kodhi ni otuu pïöpïö pïën ngöm onwongo rëp. ");
INSERT INTO lth_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ëntö ï karë na ceng öryëny öwangögï rwök, oner gïnï ökö pïën oriigï ba ödönyö na thuth. ");
INSERT INTO lth_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kodhi nökënë ökïr ï kin okudhi, cë okudhi ödöngö ëka ödïögï ökö. ");
INSERT INTO lth_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kodhi nökënë ökïr ï kom ngöm na bër, cë önyakö nyig-gï, mökö mia acël, nökënë pyer abicël, ëka mökö pyer adek na kadhö man onwongo ëcwö. ");
INSERT INTO lth_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ngat na tye kï ith më winyo myero owiny.” ");
INSERT INTO lth_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Cë ëlübkör Yecu obino bothe ëka openyo gïnï nï, “Pïngö in ïtwak kï carolok both jïï?” ");
INSERT INTO lth_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yecu ögamö nï, “Ngec më müng më ker më polo ëmïö ökö bothwu, ëntö ba ëmïö bothgï. ");
INSERT INTO lth_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pïën ngat na tye kï gin mörö, ebino mëdö bothe, ëka bino bedo ködë na büp. Ngat n'ope kï gin mörö, naka gin na ën tye ködë ebino kwanyö ökö kï bothe. ");
INSERT INTO lth_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Man ënë ngö n'ömïö an atwak kï carolok both jïï: “Kadï bed nënö gïnï pïny, ba neno gïnï; kadï bed winyo gïnï, ba winyo onyo nïang gïnï. ");
INSERT INTO lth_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Köp k'Obanga na yam adwarpïny Icaya odwaro ocobere kakarë ï komgï nï: “ ‘Un ibino winyo, ëntö ba ibino nïang ïë; un ibino nënö, ëntö ba ibino unu nïang ïë. ");
INSERT INTO lth_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Pïën jö ni cwinygï dong ödökö na nwang; ithgï ba winyo köp, ëka oumo wang-gï ökö. Cë wang-gï ba twërö nënö pïny, ëka ithgï ba twërö winyo köp, cwinygï ba twërö nïang, ëka ba twërö gïnï lökërë botha, ëk an acang-gï.’ ");
INSERT INTO lth_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ëntö wangwu tye kï gum, pïën nënö gïnï pïny, ëka ithwu pïën winyo gïnï köp. ");
INSERT INTO lth_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","An akobo niwu köp adyer nï edwarpïny na pol ëka kï jö na kitegï atïr öparö gïnï më nënö ngö na un itye ka nënö, ëntö ba önënö gïnï, ëka më winyo ngö na un itye ka winyo ëntö ba owinyo gïnï. ");
INSERT INTO lth_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Winy unu dong ngö na carolok ï kom acwö kodhi gönyö: ");
INSERT INTO lth_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ka dhanö mörö owinyo köp më ker k'Obanga cë ba önïang ïë, ngat na rac na nyïngë Catan bino ëka kwanyö kodhi n'onwongo ëcwö ï cwinye ökö. Man ënë kodhi n'ökïr ï yoo. ");
INSERT INTO lth_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kodhi n'ökïr kanya obedo kitekite, cung pï jö na gamö köp k'Obanga pïöpïö kï yom cwiny ka gïn owinyo. ");
INSERT INTO lth_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ëntö kite n'ope k'orii, bedo pï karë mörö na nönök. Ka can onyo ayela mörö obino pï köp k'Obanga, ën podho ökö pïöpïö. ");
INSERT INTO lth_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kodhi n'ökïr ï kin okudhi, cung pï jö na winyo köp, ëntö parö köp më kwö më lobo ni ëka miti më lönyö dïö köp ökö, cë mïö ba nyak gïnï. ");
INSERT INTO lth_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ëntö kodhi n'ëcwö ökïr ï ngöm na bër, cung pï jö na winyo köp ëka nïang gïnï ïë. Gïn nyakö nyig-gï, nökënë mia acël, nökënë pyer abicël, ëka nökënë pyer adek.” ");
INSERT INTO lth_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yecu dökï okobo bothgï carolok nökënë nï: “Ker më polo cal kï dhanö mörö n'öcwö kodhi na bëcö ï pwodho mërë. ");
INSERT INTO lth_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ëntö ï karë na jö kïbëc önïnö gïnï ökö, langö mërë obino cë öcwö nyig döö ï kin kal, ëka öcïdhö ökö. ");
INSERT INTO lth_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ï karë na kal n'ëpïdhö otuu ödöngö, kal öngök, cë döö thon öcakö nen. ");
INSERT INTO lth_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Etic ka won pwodho öcïdhö gïnï bothe cë openyo gïnï ën nï, ‘Adwong, in onwongo ba ïcwö kodhi na bëcö ï pwodhoni? Kara döö dökï öya kï kwene?’ ");
INSERT INTO lth_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Won pwodho ögamö nï, ‘Langö ënë ötïmö kömanön.’ “Cë etic openyo ën nï, ‘In ïmïtö nï wan ëcïdh epudh döö nön gïnï ökö?’ ");
INSERT INTO lth_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ëntö won pwodho ögamö nï, ‘Pe, pïën ka itye unu ka pudho döö, un ïtwërö pudho kal ökö kanya acël kï döö. ");
INSERT INTO lth_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wëk unu döö kï kal ödöng gïnï kanya acël naka ï karë më kac. Ï karë nön an abino kobo both ëkac: Cak unu pudho döö ökö ëka itwe unu ï dul na papath më awanga; cë ïcök unu kal ëka iketh unu ï dëröna.’ ” ");
INSERT INTO lth_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ën dökï okobo bothgï carolok nökënë: “Ker më polo cal kï nyig kodhi karadali, na dhanö otero cë öpïdhö ï pwodho mërë. ");
INSERT INTO lth_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kodhi karadali obedo kodhi na tïdï rwök kï kin kodhi kïbëc, ëntö ka ödöngö dökö na thwönë kï kin jami na tye ï pwodho ëka bedo yath, na wïny na ngwëcö kï malö bino gërö udigï ï jangë gïnï.” ");
INSERT INTO lth_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ën dökï okobo bothgï carolok nökënë: “Ker më polo cal kï thöbï na dhakö mörö ökwanyö cë orubo kï mökö ogati na thwönë, naka ka mökö kïbëc oyenyo okwot.” ");
INSERT INTO lth_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yecu ötwakö köp ni kïbëc kï carolok both lwak; ën ba okobo gin mörö bothgï na ba otio kï carolok. ");
INSERT INTO lth_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Man ötïmërë ëk köp na yam adwarpïny ötwakö ocobere: “An abino twak kodwu kï carolok gïnï, an abino kobo jami n'ökanërë cakërë anaka ï acaki cweno lobo.” ");
INSERT INTO lth_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Cë Yecu öwëkö lwak ëka öcïdhö ödönyö ï öt. Ëlübkörë obino bothe cë okobo gïnï nï, “Göny nïwa carolok ï kom döö na tye ï pwodho.” ");
INSERT INTO lth_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yecu ögamö nï, “Ngat n'öcwö kodhi na bëcö ënë Wod ka Dhanö. ");
INSERT INTO lth_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pwodho ënë lobo, ëka kodhi na bëcö cung pï jö më ker k'Obanga. Döö ënë ëthïnö ka ngat na rac, ");
INSERT INTO lth_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ëka langö n'öcwö kodhi nön gïnï ënë Catan. Kac ënë ajiki pïny, ëka ëkac ënë emalaika. ");
INSERT INTO lth_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Kite na calö epudho kï döö gïnï ködë ëka ëwangö ökö ï mac, bino bedo nï kömanön thon ï ajiki pïny. ");
INSERT INTO lth_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Wod ka Dhanö bino oro emalaika mërë, ëka bino cökö gïnï kï ï ker mërë gin na kïbëc na kelo bal ëka kï jö kïbëc na tïmö gin na rac. ");
INSERT INTO lth_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Gïn bino bologï ï mac na lyeth, kanya koko ëka kaö lak tye ïë. ");
INSERT INTO lth_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Cë jö na kitegï atïr bino ryëny gïnï calö ceng ï ker k'Apapgï. Ngat na ithe tye, myero ën owiny. ");
INSERT INTO lth_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ker më polo cal kï lönyö n'ëkanö ï pwodho. Ka dhanö onwongo, cë iko dökï, ëka pï yom cwinye mïö ën cïdhö cadhö jami kïbëc n'onwongo ën tye ködë, cë wïlö pwodho nön ökö. ");
INSERT INTO lth_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ker më polo cal dökï k'acath na rangö jami na bëcö na wel mërë tëk. ");
INSERT INTO lth_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ka onwongo mörö acël na bër rwök, ën cïdhö cë cadhö jami kïbëc n'onwongo ën tye ködë ëka wïlö gin nön ökö. ");
INSERT INTO lth_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ker më polo cal dökï kï böö n'onwongo ëcïkö ï nam n'ömakö koth rëc kïbëc na papath. ");
INSERT INTO lth_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ï karë na böö opong, ëcïk rëc öywaö gïnï böö yökö ï lak kulo. Cë obedo gïnï pïny ëka öyërö gïnï rëc na bëcö eketho ï adïta, ëntö eyuo man onwongo tye gïnï na rac ökö. ");
INSERT INTO lth_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Man ënë kite na bino bedo ködë ï karë më ajiki pïny. Emalaika bino bino gïnï ëka poko jö na reco ökö kï kom jö na kitegï atïr, ");
INSERT INTO lth_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ëka bologï ï mac na lyeth, kanya koko ëka kaö lak tye ïë.” ");
INSERT INTO lth_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yecu openyogï nï, “Un ïnïang ï kom köp ni kïbëc?” Gïn ögamö nï, “Eyo, wan ënïang ïë.” ");
INSERT INTO lth_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Cë Yecu okobo nïgï nï, “Pï manön apwony cïk mörö këkën n'epwonyo kï köp ï kom ker më polo cal kï won öt, na kwanyö jami na nyen ëka jami na cön kï kanya ën kanö lönyö mërë ïë.” ");
INSERT INTO lth_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ï karë na Yecu otyeko twakö carolok ni gïnï, ën öya ökö kï kunön. ");
INSERT INTO lth_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Cë ën odwogo ï lobo thurgï ëka öcakö pwonyo jïï ï cinagogagï. Jïï obedo kï ur rwök cë okobo gïnï nï, “Dhanö ni onwongo ryëkö ëka tëkö më tango ni gïnï kï kwene? ");
INSERT INTO lth_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Man ba obedo wod k'apaa bao? Aya mërë pathï Maria, ëka utmego mërë ba gïn ënë Yakobo, Yocepu, Cimon ëka Yuda? ");
INSERT INTO lth_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Amege mërë kïbëc ba tye gïnï kod onu kany? Cë dhanö ni onwongo köp ni kïbëc kï kwene?” ");
INSERT INTO lth_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Cë gïn ökwërö ën ökö. Ëntö Yecu okobo bothgï nï, “Adwarpïny ëwörö ï kabedo kïbëc na path kï ï lobo thurgï ëka kï ï pacögï.” ");
INSERT INTO lth_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yecu ba otio tango na pol kunön, pïën yeegï onwongo ope. ");
INSERT INTO lth_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ï karë nön Erode n'obedo alöc më Galilaya owinyo köp na pol ï kom Yecu, ");
INSERT INTO lth_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ëka ën okobo both etic mërë nï, “Man ënë Jon Abatica, n'ocer ökö kï ï kin jö n'öthöö! Manön ënë ömïö ën tye ka tio koth tango na calö man.” ");
INSERT INTO lth_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Erode onwongo ömakö Jon ëka otweo ën ï buc pï Kerodia dhakö k'ömïn mërë Pilipo, ");
INSERT INTO lth_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","pïën Jon Abatica onwongo obedo ka kobo both Erode nï, “Cïk ba oyeo nï ïlök dhakö k'omeru obed megi.” ");
INSERT INTO lth_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erode onwongo mïtö neko Jon ökö, ëntö onwongo lworo jïï, pïën gïn onwongo yeo nï Jon obedo adwarpïny. ");
INSERT INTO lth_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ëntö ï karë më po pï nywölö Erode, nyaka Kerodia ömyël ï nyim wele cë oyomo cwiny Erode rwök, ");
INSERT INTO lth_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","n'ömïö ën öcïkërë nakun kwongere both nyakö nön më mïö gin na kïbëc na ën bino penyo pïrë. ");
INSERT INTO lth_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aya mërë okobo nïnë köp na ën myero okobi, cë nyakö nön öcïdhö okobo nï, “Mïa wi Jon Abatica ï canïa kany.” ");
INSERT INTO lth_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Cë rwoth Erode okumo rwök, ëntö pï kwong na ën okwongo ëka pï wele mërë, ömïö ën öcïkö nï myero ëmïï. ");
INSERT INTO lth_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Cë Erode ooro acikari mërë më cïdhö nguno ngut Jon ökö kï ï buc, ");
INSERT INTO lth_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ëka oketho gïnï wie ï canïa cë ëmïö both nyakö nön n'otero both aya mërë. ");
INSERT INTO lth_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kinge ëlübkör Jon obino gïnï otingo kome ëka oiko gïnï. Cë gïn öcïdhö okobo both Yecu. ");
INSERT INTO lth_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ï caa na Yecu owinyo gin n'ötïmërë ï kom Jon, ën öya ökö kï kunön kï yeya cë öcïdhö yo kanyalik më bedo kënë. Ï karë na jïï owinyo gïnï köp nön, cë ölübö gïnï körë nakun wotho kï tyën-gï kï ï peci na papath. ");
INSERT INTO lth_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ï karë na Yecu idho kï ï yeya, ën önënö lwak na pol, ëka kïca ömakö ën ï komgï, cë öcangö jö n'onwongo two gïnï. ");
INSERT INTO lth_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ka othuno kothyeno, ëlübkörë obino bothe cë okobo gïnï nï, “Pïny ocido dong ökö ëka kany obedo kanyalik. Mïï jïï öcïdh gïnï ï kin peci ëk öcïdh öwïl gïnï cem më acamagï.” ");
INSERT INTO lth_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yecu ögamö nï, “Gïn myero kür öcïdhï ökö, miwugï gin mörö më acama.” ");
INSERT INTO lth_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Gïn ögamö nï, “Wan etye kany k'ogati abic ëka kï rëc arïö këkën.” ");
INSERT INTO lth_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yecu okobo nï, “Kel unugï botha kany.” ");
INSERT INTO lth_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Cë ën okobo both lwak më bedo pïny ï kom lum. Yecu ökwanyö ogati abic ëka rëc arïö cë önënö malö ï polo, ën ölëgö gum ëka opoko ï ogati gïnï. Cë ömïögï both ëlübkörë, ëka ëlübkörë ömïögï both jïï. ");
INSERT INTO lth_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gïn kïbëc ocemo oyeng gïnï. Ëlübkörë öcökö gïnï ngïny cem n'odong pong aditi apar wie arïö. ");
INSERT INTO lth_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jö n'öcamö gïnï cem nön onwongo römö gïnï cwö elip abic, na ba ëkwanö mon ëka ëthïnö. ");
INSERT INTO lth_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Cücüth Yecu ömïö ëlübkörë ödönyö ï yeya më cïdhö anyim nïnë yo löka nam tung ca, nakun ën pod odong më mïö lwak cïdhö ökö. ");
INSERT INTO lth_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kinge na dong Yecu ömïö lwak öcïdhö ökö, ën öcïdhö ï wi kidi kënë më lëga. Ï karë na dong pïny oyutho, ën onwongo tye kënë kunön, ");
INSERT INTO lth_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ëntö yeya onwongo dong öcïdhö ökö na bor kï ï lak nam, pii na tingere malö onwongo yelo yeya, pïën yamö onwongo tye ka kudho bino ï komgï. ");
INSERT INTO lth_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ï kin caa abungwën ëka caa apar wie arïö më ruu ka pïny, Yecu obino both ëlübkörë na wotho ï wi pii. ");
INSERT INTO lth_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ï karë n'ëlübkörë önënö ën wotho ï wi pii, cë tipo komgï öthöö ökö. Gïn oredo rwök pï lworo, nakun kobo gïnï nï, “Man obedo jwök!” ");
INSERT INTO lth_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ëntö cücüth Yecu okobo nïgï nï, “Dïï unu cwinywu, an ënön. Kür ilwor unu.” ");
INSERT INTO lth_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Cë Petero ögamö dhögë nï, “Rwoth, ka in ënön, mïa abin bothi nakun awotho ï wi pii.” ");
INSERT INTO lth_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yecu okobo nïnë nï, “Bin.” Cë Petero oidho ökö kï ï yeya, owotho ï wi pii më bino both Yecu. ");
INSERT INTO lth_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ëntö ka Petero önënö yamö tye ka kudho rwök, ën öcakö bedo na lwor ëka öcakö lüny ï pii. Cë okok nï, “Rwoth, lara!” ");
INSERT INTO lth_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Cücüth Yecu olyao cïngë cë ömakö ën ëka okobo nï, “In itye kï yee na tïtïdï. Pïngö in ibedo k'akalakala?” ");
INSERT INTO lth_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ï karë na gïn dong ödönyö ï yeya, cë yamö ocung ökö. ");
INSERT INTO lth_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Cë ëlübkör Yecu n'onwongo tye gïnï ï yeya öcakö gïnï wörö ën nakun kobo gïnï nï, “Adyer, in ibedo Wod k'Obanga.” ");
INSERT INTO lth_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kinge na dong gïn öngölö nam, othuno gïnï ï lobo Genecaret. ");
INSERT INTO lth_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ï karë na jö na tye ï kabedo nön ongeo Yecu, cë ooro gïnï köp ï kabedo kïbëc n'ögürö lobo nön. Jïï okelo etwoe kïbëc both Yecu. ");
INSERT INTO lth_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Gïn ökwaö ën ëk etwoe ogud gïnï lak böngü mërë këkën, ëka jö kïbëc n'ogudo ëcangögï ökö. ");
INSERT INTO lth_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kinge karë mörö, Eparicayo mökö ëka epwony cïk öya gïnï kï ï Jerucalem obino both Yecu cë openyo gïnï nï, ");
INSERT INTO lth_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Pïngö ëlübkori türö gïnï cïk më thëkwarö ka jö na dito? Gïn cemo na ba ölwökö gïnï cïng-gï.” ");
INSERT INTO lth_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yecu ögamö nï, “Ëka pïngö un ba ïlübö unu cïk k'Obanga pï lübö cïk më thëkwaröwu? ");
INSERT INTO lth_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Pïën Obanga okobo nï, ‘Wör apapni ëka ayani’ ëka ‘Ngat na bino yanyö apap mërë onyo aya mërë myero enek ökö.’ ");
INSERT INTO lth_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ëntö ikobo unu nï ka dhanö mörö okobo both apap mërë onyo aya mërë nï, ‘Gin n'onwongo myero akonyi ködë amïö dong ökö both Obanga,’ ");
INSERT INTO lth_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ën myero kür ‘öwör k'apap mërë’ ködë. Ï yoo nön un ïkwërö köp n'Obanga okobo pï lübö cïk më thëkwaröwu. ");
INSERT INTO lth_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Un etwodo! Icaya yam ötwakö köp n'atïr ï karë na ën odwaro köp ï komwu: ");
INSERT INTO lth_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Rok ni wöra gïnï kï del dhögï, ëntö cwinygï bor köda. ");
INSERT INTO lth_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Gïn wöra nono; pwonygï obedo cïk na makö kite ka dhanö.’ ” ");
INSERT INTO lth_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yecu ocwodo lwak bothe, cë okobo nïgï nï, “Winy ëka ïnïang unu. ");
INSERT INTO lth_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Pathï gin na dönyö kï ï dhö dhanö ënë balö dhanö ëntö gin na donyo kï ï dhö dhanö ënë balö dhanö.” ");
INSERT INTO lth_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Cë ëlübkör Yecu obino bothe ëka openyo gïnï nï, “In ingeo nï Eparicayo cwinygï öwang rwök ï karë na gïn owinyo köp na in ikobo?” ");
INSERT INTO lth_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yecu ögamö nï, “Gin apïdha kïbëc n'Apapna na tye ï polo ba öpïdhö ebino pudho ökö k'orii mërë gïnï. ");
INSERT INTO lth_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Wëk unu obed gïnï; gïn obedo ëthöö wang na pëö ëthöö wang ewodhgï. Ka athöö wang pëö athöö wang awodhe, gïn kïbëc bino podho ï bur.” ");
INSERT INTO lth_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Cë Petero okobo nï, “Göny nïwa carolok ni.” ");
INSERT INTO lth_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yecu openyogï nï, “Un kara thon bara ïnïang unu? ");
INSERT INTO lth_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Un ba ïnïang unu nï gin na kïbëc na dönyö ï dhö dhanö dönyö ï ïc ëka donyo yökö kï ï komi? ");
INSERT INTO lth_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ëntö jami na donyo yökö kï ï dhö dhanö yaa kï ï cwiny dhanö, ëka jami ni ënë balö dhanö. ");
INSERT INTO lth_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pïën gin na yaa kï ï cwiny dhanö ënë thama na reco, nek, elomi, tïm më ölyang, kwalö kwo, caden më twodo, ëka ayeny. ");
INSERT INTO lth_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Man ënë jami na balö dhanö; ëntö pathï cem kï cïng na ba ëlwökö ënë balö dhanö.” ");
INSERT INTO lth_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kinge na Yecu öya ökö kï kunön ën öcïdhö ï lobo n'ögürö Turo ëka Cidon. ");
INSERT INTO lth_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Cë dhakö mörö më Kanaan n'öya kï ï lobo nön obino bothe nakun kok nï, “Rwoth, Wod ka Daudi, kïca omaki ï koma! Cen ömakö nyara na rac rwök!” ");
INSERT INTO lth_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ëntö Yecu ba ögamö dhögë. Cë ëlübkörë obino bothe ëka odweko gïnï ën nï, “Ryëm dhakö ni öcïdh ökö, pïën tye ka mëdërë kï koko ï körwa.” ");
INSERT INTO lth_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Cë Yecu ögamö nï, “An onwongo eora both jö Icarael këkën, pïën gïn tye na calö rom n'orwenyo.” ");
INSERT INTO lth_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ëntö dhakö ni obino ëka orumo cöngë ï nyim Yecu nakun kobo nï, “Rwoth, könya!” ");
INSERT INTO lth_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yecu ögamö nï, “Ba bër më yuo cem k'ëthïnö yo both gwongi.” ");
INSERT INTO lth_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dhakö nön ögamö nï, “Eyo, Rwoth, ëntö naka thon gwongi camö gïnï ngïny cem na podho kï ï mëja k'editegï.” ");
INSERT INTO lth_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Cë Yecu ögamö nï, “Dhakö, in itye kï yee na thwönë! Ëk gin na in ïmïtö ötïmërë kite na in ïmïtö.” Cë nyarë öcang ökö ï caa nön kikokome. ");
INSERT INTO lth_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yecu öya ökö kï kunön ëka oroko nget Nam më Galilaya. Ën öcïdhö yo wi kidi cë obedo pïny. ");
INSERT INTO lth_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Lwak na pol obino both Yecu nakun ekelo engwalo, ëthöö wang, jö na mulo amula, jö na thë lëbgï otwere, ëka etwoe nökënë na pol, cë gïn opyelo ï nyime; ëka Yecu öcangögï. ");
INSERT INTO lth_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jïï obedo kï ur rwök ï karë na gïn önënö jö na thë lëbgï otwere ka twak, jö na mulo amula öryërë, jö n'ongwal ka wotho ëka ëthöö wang nënö pïny. Cë lwak öpakö gïnï Obanga ka jö Icarael. ");
INSERT INTO lth_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Cë Yecu ocwodo ëlübkörë bothe ëka okobo nï, “Kïca ömaka ï kom jö ni; pïën obedo gïnï dong botha kany pï nïnö adek ëka ope gïnï kï gin mörö më acama. An ba amïtö nï öcïdh gïnï na kec onekogï, pïën gïn twërö wilere gïnï kï ï yoo.” ");
INSERT INTO lth_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ëlübkörë ögamö nï, “Onu ëtwërö nwongo cem kï kany n'obedo thim nïngö më pïdhö lwak ni?” ");
INSERT INTO lth_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yecu openyogï nï, “Ogati adi na un itye ködë?” Gïn ögamö nï, “Ogati abïrö ëka rëc mörö na nönök.” ");
INSERT INTO lth_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Cë Yecu okobo both lwak ëk obed gïnï pïny ï ngöm. ");
INSERT INTO lth_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Cë ën ökwanyö ogati abïrö kï rëc, ëka kinge na dong ömïö pwöc both Obanga, ën opokogï ëka ömïögï both ëlübkörë, cë ömïö gïnï both lwak. ");
INSERT INTO lth_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Gïn kïbëc öcamö ëka oyeng gïnï. Kinge cem, ëlübkör Yecu öcökö gïnï ngïnyë n'odong aditi abïrö n'opong. ");
INSERT INTO lth_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wel jö n'ocemo gïnï onwongo tye elip angwën, na ba ëkwanö mon ëka ëthïnö. ");
INSERT INTO lth_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kinge na dong Yecu ömïö lwak öcïdhö ökö, ën ödönyö ï yeya ëka öngölö nam öcïdhö ï lobo më Magadan. ");
INSERT INTO lth_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Eparicayo ëka Ecadukayo obino gïnï both Yecu cë ötëmö gïnï ën nï onyuth bothgï anyuth n'öya kï ï polo. ");
INSERT INTO lth_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yecu ögamö nï, “Ka pïny oyutho, un ikobo nï, ‘Pïny bino bedo na bër, pïën polo nen na kwar,’ ");
INSERT INTO lth_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ëka ï kodiko cön un ikobo nï, ‘Tin yamö bino kudho rwök, pïën polo nen na kwar ëka ocido na cöl.’ Un ingeo poko kin gin na nen ï pöl, ëntö ba ïtwërö unu poko anyuth më karë gïnï. ");
INSERT INTO lth_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Rok na reco ëka jö na yeegï ope ï kom Obanga penyo gïnï pï anyuth më tango, ëntö mörö ope n'ebino mïö na path k'anyuth k'adwarpïny Yona.” Cë Yecu öya ökö kï bothgï ëka öcïdhö ökö. ");
INSERT INTO lth_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ï karë n'ëlübkör Yecu öngölö gïnï nam yo löka tung ca, wigï owil ökö më makö ogati. ");
INSERT INTO lth_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yecu okobo bothgï nï, “Gwökërë unu kï ï kom thöbï k'Eparicayo ëka më k'Ecadukayo.” ");
INSERT INTO lth_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Gïn ölarö köp ni ï kin-gï kën-gï cë okobo gïnï nï, “Ën tye ka kobo pïën onu ba ëmakö ogati mörö.” ");
INSERT INTO lth_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ï karë na Yecu ongeo ngö na gïn tye ka larö, ën openyo nï, “Un jö na yeewu nök, pïngö itye unu ka twak ï kinwu kenwu nï ba ïmakö unu ogati mörö? ");
INSERT INTO lth_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Un pod bara ïnïang unu? Un ba ipo ï ogati abic pï jö elip abic, ëka aditi adi na un ïcökö? ");
INSERT INTO lth_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Onyo ogati abïrö pï jö elip angwën ëka aditi adi na un ïcökö? ");
INSERT INTO lth_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Pïngö ba ïnïang unu nï an onwongo ba atye ka twakö köp ï kom ogati bothwu? Ëntö bed nï gwökërë unu kï kom thöbï k'Eparicayo ëka më k'Ecadukayo.” ");
INSERT INTO lth_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Cë kinge gïn önïang nï Yecu onwongo ba tye ka kobo bothgï më gwökërë kï kom thöbï n'etio ködë ï ogati, ëntö më gwökërë kï kom pwony k'Eparicayo ëka më k'Ecadukayo. ");
INSERT INTO lth_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ï karë na Yecu othuno ï lobo na cwök kï Cecaria Pilipi, cë ën openyo ëlübkörë nï, “Nga na jïï kobo nï Wod ka Dhanö obedo?” ");
INSERT INTO lth_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Gïn ögamö nï, “Jö mökö kobo nï in ibedo Jon Abatica; jö nökënë kobo nï in ibedo Eliya; ëka jö nökënë pod kobo nï in ibedo Jeremia onyo ngat mörö acël ï kin edwarpïny.” ");
INSERT INTO lth_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yecu openyogï nï, “Un kono ikobo unu nï an abedo nga?” ");
INSERT INTO lth_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Cimon Petero ögamö nï, “In ibedo Meciya, Wod k'Obanga na kwö.” ");
INSERT INTO lth_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yecu ögamö nï, “In itye kï gum, Cimon wod ka Yona, pïën ngat mörö ba onyutho nini köp ni ëntö Apapna na tye ï polo ënë onyutho nini. ");
INSERT INTO lth_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kobedini an akobo nini nï in ibedo Petero, ëka ï wi kidi ni an abino gërö jö n'oye Kiricito ïë, ëka tëkö më thöö ba bino löönö. ");
INSERT INTO lth_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","An abino mïöni agöny më ker më polo; gin na kïbëc na in itweo ï wi lobo ebino thon tweo ï polo, ëka gin mörö na in ïgönyö ï wi lobo ebino thon gönyö ï polo.” ");
INSERT INTO lth_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Cë Yecu öcïkö ëlübkörë rwök ëk kür okob gïnï both ngat mörö nï ën ebedo Meciya. ");
INSERT INTO lth_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Cakërë ï karë nön, Yecu öcakö nyutho both ëlübkörë nï myero ën ëcïdh yo Jerucalem ëka ëlïm can na pol rwök ï cïng edite, ëlamdhök na dito ëka epwony cïk. Ebino nekonë, ëntö ï nïnö më adek ebino cero ën ökö. ");
INSERT INTO lth_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Cë Petero otero Yecu kï cecen ëka öcakö coko nakun kobo nï, “Obanga kür oye, Rwoth! Man myero kür ötïmërë ï komi!” ");
INSERT INTO lth_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yecu ölökërë both Petero cë okobo nï, “Yaa ökö kï botha, Catan! In ibedo orii ökö botha, pïën thamani ba obedo më k'Obanga, ëntö më ka dhanö.” ");
INSERT INTO lth_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Cë Yecu okobo both ëlübkörë nï, “Ka ngat mörö mïtö lübö köra, myero kono ökwërë kënë, ëka öcak tingo yath arïa mërë cë ölüb köra. ");
INSERT INTO lth_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pïën dhanö na mïtö larö kwö mërë bino rwenyo kwö mërë arwenya, ëntö dhanö mörö na bino rwenyo kwö mërë pïra bino nwongo kwö mërë. ");
INSERT INTO lth_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ngö na in ibino nwongo ka itye kï jami më lobo ni kïbëc cë irwenyo kwöni? Onyo ngö na dhanö twërö mïö më lökö kï kwö mërë? ");
INSERT INTO lth_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Pïën Wod ka Dhanö bino dwogo kï dheo k'Apap mërë kanya acël k'emalaika mërë, ëka bino cülö ngat acëlacël na lübërë kï tic na ën otio. ");
INSERT INTO lth_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","An akobo niwu köp adyer, jö mökö n'ocung kany ba bino bïlö thöö na bara önënö gïnï Wod ka Dhanö ka tye ka bino ï ker mërë.” ");
INSERT INTO lth_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kinge nïnö abicël, Yecu otero Petero, Yakobo ëka Jon ömïn Yakobo, cë öïdhö ködgï ï wi kidi malö kanya gïn onwongo tye ïë kën-gï. ");
INSERT INTO lth_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kï kunön kome ölökërë na path ï nyimgï. Terinyim Yecu öryëny calö ceng, ëka böng mërë ödökö na tar na calö tara ceng. ");
INSERT INTO lth_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Cë athura Muca ëka Eliya onen bothgï, nakun tye ka twak gïnï kï Yecu. ");
INSERT INTO lth_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petero okobo both Yecu nï, “Rwoth, bër më bedo kany. Ka in ïmïtö, an abino yübö othogo adek—acël na megi, acël pï Muca ëka acël pï Eliya.” ");
INSERT INTO lth_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ï karë na ën pod tye ka twak, pöl na tar oumogï ökö ëka dwön mörö ötwak kï ï pöl nakun kobo nï, “Man ënë Woda më amara; na ïa yom ï kome. Winy unu ën!” ");
INSERT INTO lth_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ï karë n'ëlübkör Yecu owinyo köp ni, lworo ömakögï rwök ëka oryebere gïnï pïny. ");
INSERT INTO lth_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ëntö Yecu obino bothgï cë ogudogï nakun kobo nï, “Yaa unu malö, kür ibed unu kï lworo.” ");
INSERT INTO lth_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ï karë na gïn otingo wang-gï malö, ba önënö gïnï ngat mörö ëntö Yecu kënë. ");
INSERT INTO lth_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ï karë na gïn tye ka idho yo pïny kï ï wi kidi, Yecu öcïkögï nï, “Kür ikob unu both ngat mörö gin na un ïnënö, naka ka Wod ka Dhanö ecero ökö kï ï kin jö n'öthöö.” ");
INSERT INTO lth_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Cë ëlübkörë openyo gïnï Yecu nï, “Pïngö epwony cïk kobo nï Eliya ënë myero öcak bino?” ");
INSERT INTO lth_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yecu ögamö nï, “Eliya ënë myero öcak bino adyer, ëka bino dwökö jami kïbëc kakarë. ");
INSERT INTO lth_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ëntö an akobo niwu, Eliya otyeko dong bino ökö, ëka gïn ba ongeo ën, ëntö gïn ötïmö jami kïbëc na gïn mïtö ï kome. Ï yoo acël nön, Wod ka Dhanö bino lïmö can ï cïng-gï nï kömanön.” ");
INSERT INTO lth_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Cë ëlübkör Yecu önïang gïnï nï ën onwongo tye ka twakö köp bothgï ï kom Jon Abatica. ");
INSERT INTO lth_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ï karë na gïn obino both lwak, ëcwö mörö obino both Yecu cë orumo cöngë ï nyime, ");
INSERT INTO lth_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","nakun kobo nï, “Rwoth, kïca ömakï ï kom woda pïën two araka ömakö ëka tye ka lïmö can rwök. Pol karë two rëdhö ën ï mac onyo ï pii. ");
INSERT INTO lth_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","An akelo ën both ëlübkori, ëntö cangö ölöögï ökö.” ");
INSERT INTO lth_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yecu ögamö nï, “Un rok më karë ni yeewu ope, kitewu thon öbal ökö, an abino bedo kodwu pï karë na rom kwene? An abino kwö kodwu pï karë na rom kwene? Kel unu awobi nön botha kany.” ");
INSERT INTO lth_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yecu ocoko cen, cë odonyo yökö kï ï kom awobi nön, ëka ï caa nön cücüth awobi öcang ökö. ");
INSERT INTO lth_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Cë ëlübkör Yecu obino bothe ï müng ëka openyo gïnï nï, “Pïngö wan ba ëryëmö cen?” ");
INSERT INTO lth_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yecu ögamö nï, “Pïën yeewu onwongo tïdï mörö. An akobo niwu köp adyer, ka un itye kï yee na tïdï na calö nyig kodhi karadali, un ïtwërö kobo nï kidi ni, ‘Mukiri kï kany yo kuca’ ëka bino mukere. Gin mörö ope na bino löönöwu.” ");
INSERT INTO lth_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Koth gin na calö man ba twërö donyo yökö, kono ka kï lëga ëka rio kec këkën.) ");
INSERT INTO lth_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ï karë na gïn öcökërë kanya acël ï Galilaya, Yecu okobo bothgï nï, “Wod ka Dhanö ebino ketho örörö ï kome. ");
INSERT INTO lth_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Gïn bino neko ën ökö, ëka ï nïnö më adek ebino cero ën.” Cë ëlübkör Yecu obedo gïnï kï cwer cwiny rwök. ");
INSERT INTO lth_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kinge na Yecu ëka ëlübkörë othuno gïnï ï Kaperanaum, ëcök ocoro më Öt k'Obanga obino both Petero cë okobo gïnï nï, “Apwonywu ba cülö ocoro më Öt k'Obanga?” ");
INSERT INTO lth_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petero okobo nï, “Cülö.” Ï karë na Petero odwogo ï öt, Yecu ënë öcakö twak ködë nakun penyo nï, “Ngö na in ïthamö Cimon, rwodhi më lobo ni cökö gïnï ocoro kï both ëthïnögï onyo kï both jö nökënë?” ");
INSERT INTO lth_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Cë Petero ögamö nï, “Kï both jö nökënë.” Cë Yecu okobo both Petero nï, “Ka tye nï kömanön cë ëthïnögï ba myero öcül. ");
INSERT INTO lth_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ëntö kadï bed nï kömanön, ëk kür onu ëbal bothgï, cïdh ï dhö nam ëka ibol göl ï pii. Kwany rëc n'öcakö moko; yab dhögë ëka ibino nwongo cëkël ïë. Kwany cëkël nön ëk ïmïïgï pï ocorona ëka megi.” ");
INSERT INTO lth_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ï karë nön ëlübkör Yecu obino bothe cë openyo gïnï nï, “Nga ënë löö kï dit kï ï ker më polo?” ");
INSERT INTO lth_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yecu ocwodo athïn na tïdï cë ömïö ocung ï kin-gï, ");
INSERT INTO lth_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ëka okobo nï, “An akobo niwu köp adyer nï ka ba ïlökërë ïdökö unu calö ëthïnö, un ba ibino dönyö ï ker më polo. ");
INSERT INTO lth_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Pï manön, dhanö na mwolere kënë calö athïn ni ënë dit ï ker më polo. ");
INSERT INTO lth_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Dhanö mörö na jölö athïn na calö man ï nyïnga, nwongo öjöla. ");
INSERT INTO lth_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ëntö ka dhanö mörö ömïö ngat acël kï kin ëthïnö na thïnö ni n'oye gïnï ï koma më podho ï bal, onwongo bedo na bër ka etweo pong rego na thwönë ï ngute cë ebolo ködë ï nam na thuth. ");
INSERT INTO lth_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Lobo bino nënö can pï gin na mïö jïï podho ï bal. Pïën gin na mïö dhanö podho ï bal myero obin, ëntö dhanö na kelo gin na mïö dhanö podho ï bal bino nënö can! ");
INSERT INTO lth_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ka cingi onyo tyeni ënë mii ipodho ï bal, ngun ibol ökö. Bër nini më dönyö ï kwö na cingi kucël ope onyo nï ngwal, bër na löö bedo kï cingi arïö onyo tyeni kïbëc cë eboli ködë ï mac na ba thöö. ");
INSERT INTO lth_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ka wangi ënë mii ipodho ï bal, köl ëka iyuu ökö. Bër nini më dönyö ï kwö kï wangi acël nï löönö më boloni kï wangi arïö ï mac Kapïny. ");
INSERT INTO lth_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Myero ïnën nï ba ïcaö unu ngat mörö acël kï ï kin jö na thïnö ni. Pïën an akobo niwu nï emalaikagï na tye ï polo tye gïnï ï nyim Apapna ï karë kïbëc. ");
INSERT INTO lth_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Pïën Wod ka Dhanö obino më larö jö n'orwenyo.) ");
INSERT INTO lth_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Un ïthamö nïngö ka dhanö mörö tye kï rom mia acël, ëka acël kï kin-gï orwenyo ökö? Ën ba bino wëkö pyer abungwën wie abungwën ï wi kidi cë cïdhö rangö man orwenyo? ");
INSERT INTO lth_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","An akobo niwu köp adyer nï ka onwongo, cwinye bedo na yom ï kom römö n'orwenyo na löö pyer abungwën wie abungwën na ba orwenyo gïnï. ");
INSERT INTO lth_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ï yoo acël nön, Apapwu na tye ï polo thon ba mïtö nï jö na thïnö ni kür mörö orweny. ");
INSERT INTO lth_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ka omeru öbalö bothi, cïdh bothe ëk inyuth nïnë bal mërë, ï kin in kï ën. Ka ën owinyo köpni, cë nwongo idwongo omeru cen. ");
INSERT INTO lth_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ëntö ka ën ba owinyo köpni, kwany dhanö acël onyo jö arïö nökënë owoth kodi, ëk ‘köp kïbëc n'ecaden arïö onyo adek ötwakö omok köp kïbëc.’ ");
INSERT INTO lth_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ka ën ökwërö winyo köpgï, kob both jö n'oye Kiricito; ëka ka ökwërö winyo köp ka jö n'oye Kiricito, ter ën na calö ngat na ba ngeo Obanga onyo acök ocoro. ");
INSERT INTO lth_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“An akobo niwu köp adyer nï gin mörö na un itweo ï wi lobo ebino thon tweo ï polo, ëka gin mörö na un ibino gönyö ï wi lobo ebino thon gönyö ï polo. ");
INSERT INTO lth_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“An akobo niwu dökï nï ka jö arïö kï ï kinwu oyere gïnï ï kom gin mörö këkën na gïn openyo pïrë, Apapna na tye ï polo bino tïmö nïgï. ");
INSERT INTO lth_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pïën kanya jö arïö onyo adek öcökërë gïnï ïë ï nyïnga, an thon nwongo atye ködgï kany nön.” ");
INSERT INTO lth_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Cë Petero obino both Yecu ëka openyo nï, “Rwoth, wang adi na an myero atïm kïca both ömëra ka öbalö botha? Wang abïrö?” ");
INSERT INTO lth_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yecu ögamö nï, “An ba akobo nini nï wang abïrö, ëntö wang pyer abïrö tyën abïrö. ");
INSERT INTO lth_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Pï manön, ker më polo cal kï rwoth n'onwongo mïtö yübö köp më benyi k'etic mërë. ");
INSERT INTO lth_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ï karë na ën dong öcakö kwanö wel, ekelo ëcwö mörö bothe n'onwongo tye kï banya më cïlïng na thwönë rwök. ");
INSERT INTO lth_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na calö onwongo dong ba römö cülö banya nön, cë adwong mërë öcïkö nï myero ëcadh atic nön ï opii, kï dhakö mërë, ëthïnö mërë ëka gin na kïbëc n'onwongo ën tye ködë më cülö banya. ");
INSERT INTO lth_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Cücüth atic nön orumo cöngë ï nyim adwong mërë nakun kwaö nï, ‘Adwong, dïï cwinyi ï koma, cë an abino cülöni jami kïbëc.’ ");
INSERT INTO lth_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Cë adwong kïca ömakö ï kom atic mërë, ëka ötïmö kïca cë ögönyö öwëkö öcïdhö. ");
INSERT INTO lth_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ëntö ï karë n'atic nön ödönyö yökö, ën onwongo atic awodhe n'onwongo tye kï banya mërë na römö denario mia acël. Ën ömakö awodhe na tye kï banya mërë cë ödëö nakun kobo nï, ‘Cül banyana!’ ");
INSERT INTO lth_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ëntö atic awodhe ni oryebere pïny nakun kwaö nï, ‘Dïï cwinyi ï koma, an abino cülö banyani.’ ");
INSERT INTO lth_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ëntö ën ökwërö ökö cë ömïö etweo won banya mërë ï buc naka ka wang öcülö banya. ");
INSERT INTO lth_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ï karë n'etic nökënë ca önënö ngö n'ötïmërë, cë cwinygï öwang rwök ëka öcïdhö okobo gïnï both adwong-gï gin na kïbëc n'ötïmërë. ");
INSERT INTO lth_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Cë adwong ocwodo atic n'onwongo ën ötïmö kïca nïnë ëka okobo nï, ‘In ibedo atic na rac, an awëkö banyani kïbëc pïën in ïkwaö nï atïm nini kïca. ");
INSERT INTO lth_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","In onwongo myero kïca omaki ï kom atic awodhi, kite na an thon kïca ömaka ï komi.’ ");
INSERT INTO lth_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Akëmö ömakö adwong rwök ömïö eketho atic nön ï buc ëk onwong pwod naka ka wang öcülö banya mërë kïbëc. ");
INSERT INTO lth_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Man ënë kite n'Apapna na tye ï polo bino tïmö ködë ï komwu, ka ngat acëlacël ï kinwu ba ötïmö kïca kï ï cwinye both utmego mërë.” ");
INSERT INTO lth_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ï karë na Yecu otyeko twakö köp ni kïbëc, ën öya ökö kï ï Galilaya cë öcïdhö ï lobo më Yudea yo löka kulo Jordan. ");
INSERT INTO lth_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lwak na pol ölübö körë, ëka öcangögï kunön. ");
INSERT INTO lth_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Eparicayo mökö obino bothe, cë öcakö gïnï tëmö Yecu. Gïn openyo nï, “Cïk yeo nï ëcwö twërö kwërö dhakö mërë pï tyën köp mörö këkën?” ");
INSERT INTO lth_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yecu ögamö nï, “Un ba ïkwanö nï ï acaki Acwec ‘ocweo ëcwö ëka dhakö,’ ");
INSERT INTO lth_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ëka okobo nï, ‘Pï tyën köp ni ëcwö bino wëkö apap mërë ëka aya mërë cë rïbërë kï dhakö mërë, ëka jö arïö dökö kom acël’? ");
INSERT INTO lth_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kömanön gïn ba dökï tye kom arïö, ëntö kom acël. Pï manön gin n'Obanga örïbö, dhanö mörö kür opok kin-gï.” ");
INSERT INTO lth_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Cë Eparicayo openyo Yecu nï, “Pïngö Muca ömïö cïk nï ëcwö twërö mïö waraga më këthö nyom both dhakö mërë cë ryëmö ökö?” ");
INSERT INTO lth_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yecu ögamö nï, “Muca oyeo niwu më ryëmö monwu pïën cwinywu onwongo nwang. Ëntö onwongo ba obedo nï kömanön kï ï acaki. ");
INSERT INTO lth_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","An akobo niwu nï ngat mörö na kwërö dhakö mërë na path kï dönyö ï elomi, cë önyömö dhakö nökënë nwongo ödönyö ï elomi.” ");
INSERT INTO lth_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ëlübkör Yecu okobo gïnï bothe nï, “Ka köp ï kom ëcwö kï dhakö tye nï köman, cë thwara kür enyom.” ");
INSERT INTO lth_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yecu ögamö nï, “Jö kïbëc ba twërö yeo gïnï köp ni, ëntö both jö n'Obanga ömïögï këkën. ");
INSERT INTO lth_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Jö mökö ba nywöl pïën nwongo ënywölögï nï kömanön; jö mökö tye kite na jö nökënë ötïmö ködë ï komgï; ëka jö mökö öyërö më bedo abonge nyom pï ker më polo. Ngat na twërö yeo pwony ni myero oye.” ");
INSERT INTO lth_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kinge ekelo ëthïnö both Yecu nï ëk oketh cïngë ï komgï ëka ölëg pïrgï. Ëntö ëlübkörë ocoko jö n'okelo ëthïnö both Yecu. ");
INSERT INTO lth_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ëntö Yecu okobo bothgï nï, “Wëk unu ëthïnö obin botha, kür ijukugï, pïën ker më polo tye pï jö na cal k'ëthïnö ni.” ");
INSERT INTO lth_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ï karë na dong otyeko ketho cïngë ï komgï, ën öya ökö kï kany nön. ");
INSERT INTO lth_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ï karë mörö, dhanö mörö obino both Yecu cë openyo nï, “Apwony, atïm ngö na bër ëk anwong kwö na ba thum?” ");
INSERT INTO lth_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yecu ögamö nï, “Pïngö in itye ka penyona pï gin na bër? Dhanö na bër tye acël këkën. Ka in ïmïtö dönyö ï kwö na ba thum, cë ïlüb cïk.” ");
INSERT INTO lth_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ën openyo Yecu nï, “Cïk mënë?” Yecu ögamö nïnë nï, “ ‘Kür ineki, kür ïdöny ï elomi, kür ïkwal, kür ibed acaden më twodo, ");
INSERT INTO lth_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","wör apapni ëka ayani,’ ëka ‘Mar awodhi na calö ïmarö komi keni.’” ");
INSERT INTO lth_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Awobi ni ögamö nï, “Man kïbëc an agwökö, ngö na pod odong na an myero atïm?” ");
INSERT INTO lth_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yecu ögamö nïnë nï, “Ka in ïmïtö bedo dhanö na bër abonge bal, cïdh ïcadh jami na in itye ködë ëk ïmïï lïm mërë both ëcan, ëka ibino bedo kï lönyö na thwönë ï polo. Cë dong ibin ïlüb köra.” ");
INSERT INTO lth_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ï karë n'awobi ni owinyo köp ni, öya öcïdhö ökö na cwinye cwer rwök, pïën ën onwongo ölöny rwök. ");
INSERT INTO lth_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Cë Yecu okobo both ëlübkörë nï, “An akobo niwu köp adyer, tëk rwök pï alönyö më dönyö ï ker më polo. ");
INSERT INTO lth_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Anwö dökï akobo bothwu nï yot pï kïnaga më dönyö kï ï wang libira nï löönö pï alönyö më dönyö ï ker k'Obanga.” ");
INSERT INTO lth_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ï karë n'ëlübkör Yecu owinyo köp ni, obedo gïnï kï thwön ur rwök ëka openyo gïnï Yecu nï, “Cë nga na dong twërö larë?” ");
INSERT INTO lth_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ëntö Yecu örïpögï cë okobo nï, “Kï both dhanö man ba twërë, ëntö kï both Obanga jami kïbëc twërë.” ");
INSERT INTO lth_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petero ögamö dhö Yecu nakun kobo nï, “Wan ëwëkö jami kïbëc më lübö kori! Ngö na wan ebino nwongo?” ");
INSERT INTO lth_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yecu okobo bothgï nï, “An akobo niwu köp adyer, ï karë n'ebino ketho kï jami na nyen, ka Wod ka Dhanö bino bedo ï then ker më dheo mërë, un jö na dong ïlübö unu köra thon ibino bedo unu ï then ker apar wie arïö, nakun ïngölö unu köp ï kom kaka apar wie arïö më Icarael. ");
INSERT INTO lth_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Dhanö acëlacël n'onwongo öwëkö gïnï udi onyo utmegogï onyo apap onyo aya onyo ëthïnö onyo pwothi pï nyïnga, bino nwongo na kadhö tyën mia acël ëka ën bino nwongo kwö na ba thum. ");
INSERT INTO lth_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ëntö jö na pol n'ötëlö anyim bino dong gïnï kï cen, ëka jö na pol n'odong kï cen bino tëlö gïnï anyim.” ");
INSERT INTO lth_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ker më polo cal kï won pwodho ölök n'öya kodiko cön më pango etic më cïdhö tic ï pwodho ölök mërë. ");
INSERT INTO lth_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ën oyere ködgï më cülögï denario më tic pï nïnö acël ëka oorogï më cïdhö tic ï pwodho ölök mërë. ");
INSERT INTO lth_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ën dökï öcïdhö ï kin caa adek cë önënö jö mökö n'ocung ï kabedo më cuk na ba tïmö gïnï gin mörö. ");
INSERT INTO lth_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ën okobo nïgï nï, ‘Un thon cïdh itii ï pwodho ölökna, cë an abino cülöwu cül n'opore.’ ");
INSERT INTO lth_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Cë gïn thon öcïdhö. “Ën dökï öcïdhö ï kin caa abicël më kiceng ëka caa abungwën yökö cë ötïmö kömanön thon. ");
INSERT INTO lth_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ï kin caa apar wie acël më kothyeno ën dökï öcïdhö yökö cë onwongo jö nökënë pod ocung gïnï kany nön. Ën openyogï nï, ‘Pïngö icung unu acunga kany anaka kodiko naka kothyeno na ba ïtïmö unu gin mörö?’ ");
INSERT INTO lth_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Gïn ögamö nï, ‘Pïën ngat mörö ope n'opangowa,’ “Cë ën okobo nïgï nï, ‘Un thon cïdh itii unu ï pwodho ölökna.’ ");
INSERT INTO lth_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ï karë na dong othuno kothyeno, won pwodho ölök okobo both atic mërë na löö etic nï, ‘Cwod etic ëka ïmïïgï cülgï, cakërë kï both ngat n'epango kï cen naka both ngat n'ëcakö pango.’ ");
INSERT INTO lth_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Etic n'epangogï ï kin caa apar wie acël më kothyeno obino ëka ögamö gïnï denario pï tic më nïnö acël. ");
INSERT INTO lth_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jö n'ëcakö pangogï ï pwodho më acël öthamö nï ebino cülögï na büp na löö më ka jö n'epangogï kï cen, ëntö gïn thon ëmïögï denario më tic pï nïnö acël. ");
INSERT INTO lth_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ï karë na gïn dong ögamö cülgï, öcakö gïnï ngüngüta ï kom won pwodho ölök nakun kobo gïnï nï, ");
INSERT INTO lth_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Jö n'epangogï ï pwodho kï cen otio gïnï pï caa acël këkën, ëka in ïcülögï na röm aröma ködwa nakun wan eyelere kï tic rwök ï ceng na lyeth.’ ");
INSERT INTO lth_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ëntö ën ögamö nï ngat acël kï ï kin-gï nï, ‘Okona, an ba ateri na rac. In ba iyeo nï ibino gamö denario më tic pï nïnö acël? ");
INSERT INTO lth_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Gam cülni ëk ïcïdhï. An amïtö cülö dhanö n'epango kï cen cül na röm kï megi. ");
INSERT INTO lth_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","An ba atye kï twërö më tic kï jamina kite na an amïtö? Onyo wangi ocido pï gin na bër na an atïmö më mïö köny?’ ” ");
INSERT INTO lth_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Cë Yecu ojiko köp mërë nakun kobo nï, “Jö n'odong cen bino tëlö anyim ëka jö n'ötëlö anyim bino dong cen.” ");
INSERT INTO lth_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ï karë na Yecu onwongo tye ka cïdhö yo Jerucalem, ën ökwanyö ëlübkörë apar wie arïö thenge kën-gï ëka okobo nïgï nï, ");
INSERT INTO lth_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Onu ëcïdhö yo Jerucalem, ëka Wod ka Dhanö ebino mïö ökö both ëlamdhök na dito ëka both epwony cïk. Gïn bino ngölö nïnë köp më thöö ");
INSERT INTO lth_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ëka ebino mïö ën both erok ëk ëngal, epwod kï del ëka egur ï kor yath arïa. Ëntö ï nïnö më adek ebino cero ën ökö!” ");
INSERT INTO lth_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Cë dhakö ka Jebedayo obino both Yecu k'awope mërë arïö, orumo cöngë pïny ï nyime cë ökwaö ën pï gin mörö. ");
INSERT INTO lth_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yecu openyo ën nï, “Ngö ënön na in ïmïtö?” Ën ögamö nï, “Cikiri nï ibino mïö awopena arïö ni ëk ngat acël obed ï nget cingi kucem ëka acël ï nget cingi kucam ï kerni.” ");
INSERT INTO lth_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yecu ögamö nïgï nï, “Ba ingeo unu gin na un itye ka penyo. Un ïtwërö madhö ekopo më can na an abino madhö?” Gïn ögamö nï, “Wan ëtwërö.” ");
INSERT INTO lth_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Cë Yecu okobo nïgï nï, “Adyer un ibino modho k'ekopo më can na an abino modho ködë, ëntö më bedo ï nget cïnga kucem onyo kucam pathï an ënë ayërö. Kabedo nön bino bedo më jö n'Apapna öyübö pïrgï.” ");
INSERT INTO lth_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ï karë na jö apar nökënë ca owinyo gïnï köp ni, gïn öngöö ï kom omego arïö rwök. ");
INSERT INTO lth_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Cë Yecu ocwodogï kanya acël ëka okobo nïgï nï, “Un ingeo nï ëlöc k'erok löögï kï tëk ëka editegï ut kï twërö ï komgï. ");
INSERT INTO lth_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Man myero kür obed nï kömanön ï kinwu. Ka ngat na mïtö bedo na dit kï ï kinwu, myero obed aticwu, ");
INSERT INTO lth_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ëka ngat na mïtö bedo dhanö më acël myero obed opiiwu— ");
INSERT INTO lth_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","kite na Wod ka Dhanö ba obino nï ëk etii nïnë, ëntö më tic pï jïï, ëka më mïö kwö mërë më kökö jö na pol.” ");
INSERT INTO lth_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ï karë na Yecu k'ëlübkörë onwongo tye ka yaa gïnï kï ï Jeriko, lwak na pol ölübö körë. ");
INSERT INTO lth_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ëthöö wang arïö onwongo obedo gïnï ï nget yoo, ëka ï karë na gïn owinyo nï Yecu onwongo tye ka wok kany nön, gïn oredo nï, “Rwoth, Wod ka Daudi, kïca omaki ï komwa!” ");
INSERT INTO lth_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lwak ocokogï nakun kobo gïnï nï ëk ölïng gïnï ökö, ëntö gïn ömëdërë kï redo rwök nï, “Rwoth, Wod ka Daudi, kïca omaki ï komwa!” ");
INSERT INTO lth_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yecu ocung ëka ocwodogï, cë openyogï nï, “Ngö na un ïmïtö nï an atïm niwu?” ");
INSERT INTO lth_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Gïn ögamö nï, “Rwoth, wan ëmïtö nï wangwa öyabërë.” ");
INSERT INTO lth_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kïca ömakö Yecu ï komgï ëka ën ogudo wang-gï. Cë cücüth wang-gï öyabërë ëka öcakö gïnï lübö körë. ");
INSERT INTO lth_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ï karë na Yecu k'ëlübkörë dong cwök thuno ï Jerucalem, gïn obino ï Betepage ï kor Kidi më Jeituni. Cë Yecu ooro ëlübkörë arïö, ");
INSERT INTO lth_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nakun kobo nïgï nï, “Cïdh unu ï pacö na tye ï nyimwu, cë cücüth ibino unu nwongo kana n'etweo kanya acël k'athïn mërë ï ngete. Göny unu ëka ikel unugï botha. ");
INSERT INTO lth_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ka dhanö mörö okobo niwu köp mörö, kob unu nïnë nï Rwoth ënë mïtögï, ëka dhanö nön bino mïöwu ikelo pïöpïö.” ");
INSERT INTO lth_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Man ötïmërë më cobo köp na yam adwarpïny ötwakö nï: ");
INSERT INTO lth_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kob nï jö më Cion nï, ‘Nën, rwothwu tye ka bino bothwu, ën mwol ëka obedo ï wi kana ï wi athïn kana.’ ” ");
INSERT INTO lth_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ëlübkörë öcïdhö ëka ötïmö gïnï kite na Yecu öcïkögï ködë. ");
INSERT INTO lth_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Gïn okelo kana ëka athïn mërë, cë öpëdhö gïnï böng-gï ï ngeegï ëka Yecu obedo ï wie. ");
INSERT INTO lth_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lwak na pol öpëdhö böng-gï ï dye yoo, nakun jö nökënë tongo jang yen cë pëdhö gïnï ï dye yoo. ");
INSERT INTO lth_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lwak n'ötëlö anyim ëka kï jö n'ölübö körë onwongo tye ka wöö gïnï nï, “Ocana, Wod ka Daudi!” “Gum obed ï kom ngat na tye ka bino kï nyïng Rwoth!” “Ocana na tye malö rwök!” ");
INSERT INTO lth_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ï karë na Yecu ödönyö ï Jerucalem, jö kïbëc kï ï taun obedo gïnï k'ethime nakun penyo gïnï nï, “Man ënë nga?” ");
INSERT INTO lth_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lwak ögamö nï, “Man ënë Yecu, adwarpïny n'öya kï ï Najaret na tye ï Galilaya.” ");
INSERT INTO lth_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yecu ödönyö ï dyekal öt k'Obanga ëka öryëmö jö kïbëc n'onwongo cadhö ëka wïlö gïnï wïl kunön. Ën ölökö mëja ka jö na lökö cïlïng atarö ëka thene ka jö na cadhö amame. ");
INSERT INTO lth_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ën okobo nïgï nï, “Ëcöö nï, ‘Öda ebino cwodo nï öt më lëga,’ ëntö un ïlökö ödökö ‘ka pono k'ekwoe.’ ” ");
INSERT INTO lth_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ëthöö wang ëka engwalo obino gïnï bothe ï dyekal öt k'Obanga ëka ën öcangögï. ");
INSERT INTO lth_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ëntö ëlamdhök na dito ëka epwony cïk öngöö gïnï rwök ï karë n'önënö gïnï tic më aura na ën onwongo tye ka tïmö ëka ëthïnö na wöö ï dyekal Öt k'Obanga nakun kobo gïnï nï, “Ocana Wod ka Daudi.” ");
INSERT INTO lth_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Gïn openyo ën nï, “In itye ka winyo ngö n'ëthïnö ni tye ka kobo?” Yecu ögamö nï, “Eyo, un anaka bara ïkwanö unu nï, “ ‘Kï ï dhö ëthïnö ëka ëthïnö na döth in ipwonyo ëthïnö më mïöni pak’?” ");
INSERT INTO lth_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Cë ën öya öwëkögï ëka öcïdhö yo Betania cë obuto kunön. ");
INSERT INTO lth_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kodiko cön na Yecu onwongo tye ka dök cen yo taun, kec onwongo oneko ën. ");
INSERT INTO lth_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yecu önënö yath ölam ï nget yoo, ën öngël ïë ëntö ba onwongo ölam mörö na path k'oboke këkën. Ën okobo nï yath ölam nï, “Ba dökï ibino nyakö nyigi!” Cë cücüth yath ölam öthwö ökö. ");
INSERT INTO lth_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ï karë n'ëlübkörë önënö, ouro gïnï ëka openyo gïnï nï, “Yath ölam öcakö thwö nïngö pïöpïö?” ");
INSERT INTO lth_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yecu ögamö nï, “An akobo niwu köp adyer nï ka iut unu kï yee na ba itye unu k'akalakala, ba ibino unu tïmö gin na an atïmö ï kom yath ölam këkën, ëntö ïrömö unu thon kobo nï kidi ni nï, ‘Mukiri ëka ïcïdh icibiri ï nam,’ cë bino tïmërë. ");
INSERT INTO lth_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ka in itye kï yee, gin mörö këkën na in ibino kwaö kï lëga ibino nwongo.” ");
INSERT INTO lth_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ï karë na Yecu odwogo ï dyekal öt k'Obanga, na ën tye ka pwony, ëlamdhök na dito ëka edite ka lwak obino gïnï bothe cë openyo gïnï ën nï, “Twërö mënë na in itye ka tïmö kï gin ni gïnï? Ëka nga ënë omii twërö ni?” ");
INSERT INTO lth_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yecu ögamö nï, “An thon abino penyowu peny acël. Ka ïgamö unu nïna, cë an abino kobo niwu twërö mënë na an atye ka tïmö kï gin ni gïnï. ");
INSERT INTO lth_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Batica ka Jon öya kï kwene? Öya kï ï polo onyo kï both dhanö?” Gïn öcakö larö köp nön ï kin-gï kën-gï ëka okobo gïnï nï, “Ka onu ekobo nï öya kï ï polo, ën bino penyo nï, ‘Pïngö ba iyee unu ï kom Jon?’ ");
INSERT INTO lth_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ëntö ka onu ekobo nï, ‘Öya kï both jïï’—cë onu elworo lwak, pïën jö kïbëc yee nï Jon onwongo obedo adwarpïny.” ");
INSERT INTO lth_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Cë gïn ögamö nï Yecu nï, “Wan ba engeo.” Ëka Yecu okobo nïgï nï, “An thon ba abino kobo niwu twërö mënë na an atye ka tïmö kï gin ni gïnï.” ");
INSERT INTO lth_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ngö na un ïthamö? Yam ëcwö mörö tye n'onwongo ut k'awope arïö. Ën öcïdhö both awobi më acël ëka okobo nïnë nï, ‘Woda, cïdh itii ï pwodho ölökna tin.’ ");
INSERT INTO lth_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ën ögamö nï, ‘Ba abino cïdhö,’ ëntö kinge ën ölökö thama mërë ëka öcïdhö. ");
INSERT INTO lth_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Cë apap mërë thon öcïdhö both awobi nökënë ca ëka okobo kömanön. Awobi ni ögamö nï, ‘Eyo, apap, an abino cïdhö,’ ëntö ën ba obino öcïdhö. ");
INSERT INTO lth_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Nga kï kin jö arïö ni ënë ötïmö gin n'apap mërë mïtö?” Gïn ögamö nï, “Awobi më acël.” Cë Yecu okobo nïgï nï, “An akobo niwu köp adyer nï ëcök ocoro ëka oleye bino cakö dönyö niwu ï ker k'Obanga. ");
INSERT INTO lth_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pïën Jon obino më nyutho niwu yoo më kite atïr, ëka un ba iyee unu ï kome, ëntö ëcök ocoro ëka oleye oyee ï kome. Ëka thon kinge na dong ïnënö unu gin ni, ba ibino ingut ëka iyee unu ï kome. ");
INSERT INTO lth_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Winy unu carolok nökënë: Yam onwongo tye won pwodho mörö n'öpïdhö ölök. Ën oketho cël ögürö, ökünyö bur ïë më bïö ölök ëka öyübö pem më kür ïë. Cë ën ömïö pwodho ölök both epang pwodho mörö ëka ën öcïdhö ökö ï lobo nökënë. ");
INSERT INTO lth_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na karë më kac onyingo na cwök, ën ooro etic mërë both epang pwodho më gamö nyig ölök na mëgë. ");
INSERT INTO lth_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Epang pwodho ömakö etic mërë, epwodo, eneko nökënë, ëka ecelo nökënë kï kite. ");
INSERT INTO lth_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Cë ën dökï ooro etic nökënë bothgï, na pol na löö më acël ökö ëka epang pwodho oterogï na rac calö më acël ca. ");
INSERT INTO lth_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Më ajiki mërë ën ooro wode bothgï nakun kobo nï, ‘Gïn bino wörö woda.’ ");
INSERT INTO lth_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ëntö ï karë n'epang pwodho önënö wod ka won pwodho, cë ötwak ï kin-gï kën-gï nï, ‘Man ënë ngat na bino leeno jami. Bin unu, eru enek ën ökö ëka eter jami më alea mërë.’ ");
INSERT INTO lth_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Cë gïn ömakö ën, oyuo gïnï yökö kï ï pwodho ölök ëka eneko ökö. ");
INSERT INTO lth_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Pï manön, ka won pwodho ölök obino, ën bino tïmö ngö ï kom epang pwodho?” ");
INSERT INTO lth_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Gïn ögamö nïnë nï, “Ën bino neko jö nön na kitegï reco ökö ëka bino mïö pwodho ölök më apanga both epang pwodho nökënë, na bino mïö ën nyig ölök na mëgë ï karë më kac.” ");
INSERT INTO lth_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Cë Yecu okobo nïgï nï, “Un bara ïkwanö unu Cöc na Leng: “ ‘Kidi n'egedo ökwërö ënë ödökö kidi më gwïc öt. Man ënë tic ka Rwoth, ëka obedo gin më aura both onu.’ ");
INSERT INTO lth_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Pï manön an akobo niwu nï ker k'Obanga ebino kwanyö ökö kï bothwu ëka ëmïö both jö nökënë na bino nyakö nyige n'opore. ");
INSERT INTO lth_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ngat na bino podho ï kom kidi ni bino tütüra ngïdhërë na thïthïnö, ëntö ka kidi nön örëdhërë ï kom ngat mörö, bino ngïngïnyö ökö.” ");
INSERT INTO lth_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ï karë n'ëlamdhök na dito ëka Eparicayo owinyo gïnï carolok ka Yecu gïnï, gïn önïang nï ën onwongo tye ka twak ï komgï. ");
INSERT INTO lth_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Cë gïn öcakö rangö yoo më makö ën, ëntö gïn onwongo lworo lwak pïën lwak onwongo ngeo nï Yecu obedo adwarpïny. ");
INSERT INTO lth_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yecu ötwak ködgï dökï kï carolok gïnï nakun kobo nï: ");
INSERT INTO lth_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ker më polo eporo kï rwoth n'öyübö karama më nyom pï wode. ");
INSERT INTO lth_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ën ooro etic mërë më cïdhö cwodo jö n'onwongo ecwodogï ï karama më bino, ëntö gïn ökwërö bino ökö. ");
INSERT INTO lth_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Cë ën dökï ooro etic nökënë nakun kobo nï, ‘Kob both jö n'onwongo ecwodogï nï an dong ayübö cemna ökö: Thwonina ëka dhok n'öcwë enekogï dong ökö, jami kïbëc dong tye kakarë. Bin unu ï karama më nyom.’ ");
INSERT INTO lth_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ëntö jö n'ecwodogï ï nyom ökwërö gïnï winyo köp nön, cë öcïdhö gïnï ökö—ngat acël öcïdhö ï pwodho mërë ëka ngat nökënë öcïdhö ï cath mërë. ");
INSERT INTO lth_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jö nökënë ömakö etic mërë cë opwodogï rwök ëka onekogï ökö. ");
INSERT INTO lth_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Akëmö ömakö rwoth cë ooro acikari mërë më neko enek nonu ëka wangö pacögï ökö. ");
INSERT INTO lth_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Cë ën okobo both etic mërë nï, ‘Karama më nyom ëyübö dong ökö, ëntö jö n'onwongo an acwodogï ba opore gïnï më bino. ");
INSERT INTO lth_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cïdh unu ï yodhi ëk icwod ngat mörö këkën na un ibino nwongo ëk obin ï karama më nyom.’ ");
INSERT INTO lth_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Cë etic öcïdhö ëka ocwodo gïnï jö kïbëc na gïn onwongo ï yodhi, jö na bëcö ëka jö na reco cë öt më nyom opong kï wele. ");
INSERT INTO lth_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ëntö ï karë na rwoth obino më nënö wele, ën önënö dhanö mörö na ba oruko böngü na bër më nyom kunön. ");
INSERT INTO lth_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Cë openyo ën nï, ‘Okona, idonyo kany nïngö na ba iruko böngü na bër më nyom?’ Ëntö ën ölïng alïnga. ");
INSERT INTO lth_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Cë rwoth okobo both etic mërë nï, ‘Twe unu cïngë ëka tyënë ëk ibol unu ën yökö, ï pïny na cöl, kanya koko ëka kaö lak bino bedo ïë.’ ");
INSERT INTO lth_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Pïën jö n'ecwodogï pol ëntö jö n'ëyërögï nönök.” ");
INSERT INTO lth_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Cë Eparicayo öcïdhö öyübö gïnï köp kite na myero ëmak gïnï kï Yecu kï köp mörö na yaa kï ï dhögë. ");
INSERT INTO lth_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Gïn ooro ëlübkörgï ëka jö na cwakö Erode më penyo Yecu nï, “Apwony, wan engeo nï in ikobo köp adyer ëka ipwonyo köp k'Obanga na lübërë kï köp adyer. In ba ïparö dhanö mörö, pïën ba ïnënö dhanö kï yökö. ");
INSERT INTO lth_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kob nïwa thamani: Pore më cülö ocoro both Cija onyo pe?” ");
INSERT INTO lth_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ëntö Yecu ongeo thamagï ökö cë openyogï nï, “Un etwodo, pïngö un itye ka tëmöna? ");
INSERT INTO lth_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nyuth unu nïna cïlïng mörö na nyïng n'ëcülö pï ocoro.” Cë gïn okelo nïnë denario acël, ");
INSERT INTO lth_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ëka ën openyogï nï, “Cal ëka cöc n'ëcöö ïë obedo më ka nga?” ");
INSERT INTO lth_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Gïn ögamö nï, “Më ka Cija.” Cë ën okobo nïgï nï, “Mïï unu jami ka Cija both Cija ëka jami k'Obanga both Obanga.” ");
INSERT INTO lth_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ï karë na gïn owinyo köp ni, obedo gïnï kï ur rwök. Cë öwëkö gïnï ën ëka öcïdhö gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ï nïnö nön kikokome, Ecadukayo na kobo gïnï nï cer ka jö n'öthöö ope obino gïnï both Yecu ëka openyo gïnï ën nï, ");
INSERT INTO lth_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Apwony, Muca yam okobo nïwa nï ka ëcwö mörö öthöö na ba önywölö ëthïnö, ömïn mërë myero ölak dhakö mërë ëk önywöl ëthïnö nakaka ömïn mërë n'öthöö. ");
INSERT INTO lth_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yam onwongo tye utmego abïrö ï kinwa kany. Dhanö më acël obino önyömö dhakö ëka öthöö ökö na ba önywölö ëthïnö, cë ën öwëkö dhakö mërë both ömïn mërë. ");
INSERT INTO lth_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ömïn mërë më arïö nön thon obino öthöö ëka më adek naka otyeko jö abïrö nonu kïbëc. ");
INSERT INTO lth_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ï ajiki mërë, dhakö thon obino öthöö. ");
INSERT INTO lth_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Cë dong ï karë më cer, dhakö nön bino bedo më ka nga kï kin jö abïrö nonu, nakun dhakö nön onwongo obedo mëgï kïbëc?” ");
INSERT INTO lth_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yecu ögamö nï, “Un irwenyo ökö pïën ba ingeo unu Cöc na Leng onyo tëkö k'Obanga. ");
INSERT INTO lth_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ï karë më cer, jïï ba bino nyom onyo ënyömögï; ëntö gïn bino bedo calö emalaika na tye ï polo. ");
INSERT INTO lth_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ëntö köp ï kom cer ka jö n'öthöö—un ïkwanö ngö n'Obanga okobo niwu nï, ");
INSERT INTO lth_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘An abedo Obanga k'Abraam, Obanga ka Icaka ëka Obanga ka Jakob’ Ën ba obedo Obanga ka jö n'öthöö ëntö Obanga ka jö na kwö.” ");
INSERT INTO lth_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ï karë na lwak owinyo köp ni, obedo gïnï kï ur rwök ï kom pwony mërë. ");
INSERT INTO lth_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ï karë n'Eparicayo owinyo nï Yecu otweo dhö Ecadukayo ökö, gïn öcakö cökërë kanya acël. ");
INSERT INTO lth_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ngat acël kï ï kin-gï na ngeo cïk rwök ötëmö ën kï peny ni: ");
INSERT INTO lth_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Apwony, cïk mënë ënë dit na löö kï ï cïk?” ");
INSERT INTO lth_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yecu ögamö nï: “ ‘Mar Rwoth Obangani kï cwinyi kïbëc, ëka kï tiponi kïbëc, ëka kï thamani kïbëc.’ ");
INSERT INTO lth_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Man ënë cïk më acël ëka cïk na dit na löö kïbëc. ");
INSERT INTO lth_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ëka cïk më arïö cal ködë: ‘Mar awodhi na calö ïmarö komi keni.’ ");
INSERT INTO lth_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Cïk kïbëc ëka pwony k'Edwarpïny ocung gïnï ï kom cïk arïö ni.” ");
INSERT INTO lth_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ï karë n'Eparicayo öcökërë gïnï kanya acël, Yecu openyogï nï, ");
INSERT INTO lth_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ngö na un ïthamö ï kom Meciya? Ën obedo wod ka nga?” Gïn ögamö nï, “Wod ka Daudi.” ");
INSERT INTO lth_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ën okobo nïgï nï, “Pïngö Tipo Naleng ömïö Daudi ocwodo ën nï ‘Rwoth’? Pïën okobo nï, ");
INSERT INTO lth_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Rwoth okobo both Rwodha nï, “Bed ï nget cïnga më kucem naka ka an aketho langni ï thë tyeni.” ’ ");
INSERT INTO lth_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ka Daudi cwodo ën nï ‘Rwoth,’ ën twërö bedo wode nïngö?” ");
INSERT INTO lth_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ngat mörö ope n'onwongo twërö gamö köp mërë, ëka cakërë ï nïnö nön ngat mörö ope dökï n'öthamö më penyo ën peny mörö gïnï. ");
INSERT INTO lth_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Cë Yecu okobo both lwak ëka ëlübkörë nï: ");
INSERT INTO lth_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Epwony cïk ëka Eparicayo ënë ëmïögï twërö më gönyö cïk ka Muca. ");
INSERT INTO lth_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Cë myero ïwör unugï ëka ïtïm unu gin na kïbëc na gïn kobo niwu. Ëntö kür ïtïm unu ngö na gïn tïmö, pïën gïn ba tïmö ngö na gïn pwonyo. ");
INSERT INTO lth_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Gïn tweo yëc na pëk ëka ketho ï wi ba jïï, ëntö gïn kikomgï ba twërö könyö më cwarö kï nya cïng-gï. ");
INSERT INTO lth_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Gin na kïbëc na gïn tïmö, ëtïmö ëk jïï önën: Gïn ketho ï ngut cïng-gï ëka ï terinyimgï tyeng më Cöc na Leng, ëka thöl tacël na boco ï böng-gï; ");
INSERT INTO lth_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","gïn marö bedo ï kabedo më wörö ï karama më cem ëka ï thene na pïrgï tëk ï cinagoga gïnï; ");
INSERT INTO lth_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","gïn marö nï ëk emothgï kï ï kabedo më cuk gïnï ëka mïtö nï ëk ecwodgï nï, ‘Apwony.’ ");
INSERT INTO lth_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ëntö un myero kür ecwodwu nï, ‘apwony,’ pïën itye unu k'Apwony acël këkën ëka un kïbëc ibedo unu utmego. ");
INSERT INTO lth_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ëka kür icwod unu ngat mörö kï ï wi lobo kany nï, ‘apap,’ pïën itye unu k'Apap acël këkën na tye ï polo. ");
INSERT INTO lth_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Onyo kür ecwodwu nï, ‘apwony,’ pïën itye unu k'Apwony acël këkën na ënë Meciya. ");
INSERT INTO lth_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ngat na dit na löö kï kinwu bino bedo aticwu. ");
INSERT INTO lth_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pïën ngat na tingere malö kënë ebino dwökö pïny, ëka ngat na mwolere kënë ebino tingo malö. ");
INSERT INTO lth_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ibino nënö unu can, un epwony cïk ëka Eparicayo, un etwodo! Un icego dholokek më ker më polo ökö nï jïï. Un kikomwu ba ïdönyö unu, ëka dök thon ïjükö unu jïï na mïtö dönyö ïë ökö. ");
INSERT INTO lth_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Ibino nënö unu can un epwony cïk ëka Eparicayo, un etwodo! Pïën ïmaö unu udi ka mon na cwögï öthöö, ëka ïlëgö unu lëga na boco më nyuthere both Obanga. Pï manön köp n'ebino ngölö ï wiwu bino bedo na thwönë rwök.) ");
INSERT INTO lth_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ibino nënö unu can, un epwony cïk ëka Eparicayo, un etwodo! Pïën iwotho unu ï wi lobo ëka ï wi nam pï lökö dhanö acël më dwongo bothwu, ëntö ka dong ölökërë, ïmïö unu ën dökö dhanö na rac rwök, na cïdhö yo kapïny na bal mërë löö mewu wang kïrïö. ");
INSERT INTO lth_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ibino nënö unu can, un jö na pëö ëthöö wang! Un ikobo nï, ‘Ka ngat mörö okwongo kwong kï öt k'Obanga, kwong mërë ba makö ën; ëntö ka ngat mörö okwongo kwong kï gol më öt k'Obanga, kwong mërë makö ën.’ ");
INSERT INTO lth_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Un ëthöö wang na mïng! Mënë ënë dit na löö: gol onyo Öt k'Obanga na mïö gol dökö na leng? ");
INSERT INTO lth_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Un thon ikobo nï, ‘Ka ngat mörö okwongo kwong kï keno tyër, kwong mërë ba makö ën; ëntö ka ngat mörö okwongo kwong kï mïc na tye ï wi keno tyër, kwong mërë makö ën.’ ");
INSERT INTO lth_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Un ëthöö wang! Mënë ënë dit na löö: mïc, onyo keno tyër na mïö mïc dökö na leng? ");
INSERT INTO lth_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pï manön, ngat na kwongo kwong kï keno tyër, kwongo kï keno tyër ëka kï jami kïbëc na tye ïë. ");
INSERT INTO lth_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ëka ngat na kwongo kwong kï öt k'Obanga, kwongo kï öt k'Obanga ëka kï ngat na bedo ïë. ");
INSERT INTO lth_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ngat na kwongo kwong kï polo kwongo kï then ker k'Obanga ëka kï ngat na bedo ïë. ");
INSERT INTO lth_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ibino nënö unu can, un epwony cïk ëka Eparicayo, un etwodo! Un ïmïö acël më apar më gin na mïö cem bedo na mït, ëntö köp na pïrgï tëk rwök më cïk ïwëkö unu ökö—ngölö-köp atïr, tïmö kïca, ëka bedo kï gen. Onwongo myero ïtïm unu jami ni kïbëc nakun ba ïwëkö unu nökënë ca. ");
INSERT INTO lth_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Un jö na pëö ëthöö wang! Ïlïö unu lwangi ökö kï gin na un ïmadhö ëntö ïmwönyö unu kïnaga. ");
INSERT INTO lth_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ibino nënö unu can, un epwony cïk ëka Eparicayo, un etwodo! Ïlwökö unu nge ekopo ëka nge bakuli më bedo na leng ëntö ïgï opong kï tïm më woro ëka kï miti mökö na ba twërö jükërë. ");
INSERT INTO lth_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","In Aparicayo na wangi öthöö! Kono ïlwök ïï ekopo ëka ïï bakuli obed na leng, cë nge thon bino bedo na leng. ");
INSERT INTO lth_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ibino nënö unu can, un epwony cïk ëka Eparicayo, un etwodo! Un ïcal kï bur lyene n'epuo na tar, na nen na leng kï yökö ëntö ïë opong kï cogo ka jö n'öthöö gïnï ëka kï gin na kïbëc na ba leng. ");
INSERT INTO lth_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Un thon itye nï kömanön, inen unu kï yökö both jïï na calö jö na kitegï atïr ëntö ïwu opong kï twodo ëka kï tïm na reco. ");
INSERT INTO lth_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ibino nënö unu can, un epwony cïk ëka Eparicayo, un etwodo! Ïyübö unu bur lyene k'edwarpïny ëka idheo unu lyene ka jö na kitegï atïr. ");
INSERT INTO lth_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ëka ikobo unu nï, ‘Ka onwongo yam wan etye ï karë ka kwerewa, kono wan ba ërïbërë ködgï ï önyö remo k'edwarpïny.’ ");
INSERT INTO lth_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Cë un ïmïö caden ï komwu kenwu nï un ibedo ëkwaë ka jö na yam oneko edwarpïny. ");
INSERT INTO lth_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mëdërë unu anyim ëk icob unu bal na yam kwerewu öcakö! ");
INSERT INTO lth_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Un thwone! Un ëthïn ororo! Un ibino bwöth nïngö kï ngölö-köp më mac kapïny? ");
INSERT INTO lth_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pï manön an atye ka oro niwu edwarpïny, jö na ryëk ëka epwony cïk. Jö mökö kï kin-gï un ibino neko ëka iguro unu; jö nökënë un ibino pwodo kï del ï cinagogawu gïnï ëka ïryëmö unugï ökö kï ï taun mörö këkën. ");
INSERT INTO lth_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pï manön, remo kïbëc n'ope kï bal n'ööny ï wi lobo obed ï wiwu, cakërë kï ï remo k'Abel na bal mërë ope thuno ködë naka ï remo ka Jakaria wod ka Barakia, na un ineko ï kin öt k'Obanga ëka keno tyër. ");
INSERT INTO lth_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","An akobo niwu köp adyer, köp ni kïbëc bino bino ï kom rok më karë ni. ");
INSERT INTO lth_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerucalem, Jerucalem, un ineko edwarpïny ëka icelo unu jö n'eoro bothwu kï kite, wang adi na an abedo ka mïtö cökö ëthïnöni kanya acël calö mïn gwënö na gürö ëthïnë ï thë bwome, ëntö in ïkwërö ökö. ");
INSERT INTO lth_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nën, odi dong ëwëkö nini, odong nono. ");
INSERT INTO lth_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pïën an akobo niwu nï ba dökï ibino nënöna unu, naka ka ibino unu kobo nï, ‘Gum obed ï kom ngat na bino kï nyïng Rwoth.’” ");
INSERT INTO lth_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yecu öya kï ï öt k'Obanga. Na ën tye ka woth, ëlübkörë obino bothe cë gïn onyutho nïnë gedo më öt k'Obanga. ");
INSERT INTO lth_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ën openyogï nï, “Ïnënö unu jami ni kïbëc? An akobo niwu köp adyer nï ba ebino wëkö kidi mörö acël dong n'ododere ï wi awodhe na ba ebino thwaro ökö pïny.” ");
INSERT INTO lth_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ï karë na Yecu obedo pïny ï wi Kidi më Jeituni, ëlübkörë obino bothe ï müng cë okobo gïnï nï, “Kob nïwa, man bino tïmërë awene, ëka ngö na bino nyutho dwogoni ëka ajiki pïny?” ");
INSERT INTO lth_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yecu ögamö nï: “Gwökërë unu ëk ngat mörö kür öbwölwu. ");
INSERT INTO lth_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pïën jö na pol bino bino gïnï kï nyïnga na bino gïnï kobo nï, ‘An ënë Meciya,’ ëka bino bwölö jö na pol. ");
INSERT INTO lth_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Un ibino winyo köp ï kom lwëny ëka anïï më lwëny, ëntö kür ibed unu kï lworo. Pïën manön myero ötïmërë, ëntö ajiki nwongo podi. ");
INSERT INTO lth_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Rok bino lwëny ï kom rok nökënë, ëka ker bino lwëny ï kom ker nökënë. Kec ëka oyeyeng bino bedo ï kabedo na papath. ");
INSERT INTO lth_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Man kïbëc nwongo pod obedo calö acaki rem më nywöl. ");
INSERT INTO lth_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ï karë nön ebino maköwu, eketho ayela ï komwu ëka ebino nekowu. Rok kïbëc bino dagöwu pïra. ");
INSERT INTO lth_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Cë ï karë nön, jö na pol bino lökërë gïnï ökö kï kom yee, bino ketho gïnï örörö ëka adagë ï kin-gï kën-gï. ");
INSERT INTO lth_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Edwarpïny na twot bino bino na pol ëka bino bwölö gïnï jö na pol. ");
INSERT INTO lth_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tïm na reco bino mëdërë, ëka mar ka jö na pol bino kwe ökö, ");
INSERT INTO lth_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ëntö ngat na bino cung na tëk naka ï ajiki bino larë. ");
INSERT INTO lth_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ëka köp më Emuth na Bër më ker k'Obanga ebino tïtö ï wi lobo kïbëc më bedo na calö caden both rok kïbëc, cë ajiki pïny dong bino. ");
INSERT INTO lth_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Un ibino nënö ‘gin mörö më kwer na kelo lworo’ na yam adwarpïny Daniel okobo. Gin nön bino cung ï kabedo na leng. (Ëk ngat na kwanö önïang ïë.) ");
INSERT INTO lth_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Cë jö na tye ï Yudea myero örïng gïnï ökö ï wi kite. ");
INSERT INTO lth_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Dhanö na tye ï wi ödë kür oidhi pïny më kwanyö gin mörö kï ï öt. ");
INSERT INTO lth_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Dhanö na tye ï pwodho kür ödök cen më ömö böngü mërë. ");
INSERT INTO lth_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mon na yeco ëka mon na dödhö ëthïnö bino nënö can ï karë nonu! ");
INSERT INTO lth_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lëg unu both Obanga ëk ngwëcwu kür ötïmërë ï karë më cwïr onyo ï ceng Cabït. ");
INSERT INTO lth_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Pïën karë nonu bino bedo karë më can na dwong na anaka yam bara onen ï acaki më cweno lobo naka tin ëka ba dökï bino nen. ");
INSERT INTO lth_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ka nïnö nonu onwongo ba ëjükö na cek, ngat mörö onwongo ope na bwöth. Ëntö pï jö n'ëyërögï nïnö nonu ebino jükö na cek. ");
INSERT INTO lth_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ï karë nön ka dhanö mörö okobo niwu nï, ‘Nën, Meciya ene,’ onyo nï, ‘Ën ëca,’ kür iyee unu. ");
INSERT INTO lth_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pïën jö na kobo nï gïn ebedo Kiricito ëka edwarpïny na twot bino bino ëka bino tio gïnï anyuth ëka tango na dito ëk ka twërë ëbwöl gïnï naka jö n'ëyërögï. ");
INSERT INTO lth_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Winy unu, an atyeko dong kobo ökö niwu na karë bara örömö. ");
INSERT INTO lth_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Dong ka ngat mörö okobo niwu nï, ‘Ën ëca tye ï thim,’ kür ïcïdh unu, onyo nï, ‘Ën tye kany, ï öt ï thë tyëlö,’ kür iyee unu. ");
INSERT INTO lth_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pïën kite na lüth köth yaa kï kukïdë wïl dök yo kuthö, bino ka Wod ka Dhanö thon bino bedo nï kömanön. ");
INSERT INTO lth_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kanya lyene tye ïë, acuth bino cökërë gïnï kunön. ");
INSERT INTO lth_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Cücüth kinge can na dwong më nïnö nonu “ ‘ceng bino cido, ëka dwe ba bino mïö tara mërë; cër bino podho kï ï polo yo pïny ëka twër kïbëc më polo bino yengere gïnï.’ ");
INSERT INTO lth_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ï karë nön anyuth ka Wod ka Dhanö bino nen ï polo, ëka rok kïbëc më wi lobo bino gïnï kumo. Gïn bino nënö Wod ka Dhanö na tye ka bino k'edou më pöl kï tëkö ëka dheo na dit. ");
INSERT INTO lth_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ën bino oro emalaika mërë kï cwodo më buruji na longo, ëka gïn bino cökö jögë n'ëyërögï kï ï wi lobo thükül, kï ï ajiki polo kucël naka yo ajiki polo tung ca. ");
INSERT INTO lth_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nwong unu pwony ni kï ï kom yath ölam: Ka jangë öcakö löth ëka pote odonyo, un ingeo nï oro dong cwök. ");
INSERT INTO lth_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kömanön thon ka ïnënö unu jami ni kïbëc, nge unu nï karë dong cwök, tye ï dholokek. ");
INSERT INTO lth_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","An akobo niwu köp adyer, rok më karë ni ba bino poth naka ka jami ni kïbëc ötïmërë. ");
INSERT INTO lth_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Polo ëka lobo bino thum ökö, ëntö köpna ba bino thum. ");
INSERT INTO lth_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ngat mörö ope na ngeo nïnö nön onyo caa, kadï thon emalaika na tye ï polo, onyo Wod, ëntö Apap këkën ënë ngeo. ");
INSERT INTO lth_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bino ka Wod ka Dhanö bino bedo calö karë ka Noa. ");
INSERT INTO lth_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ï karë nonu n'onwongo abwal pii bara opong ï wi lobo, jïï onwongo cemo ëka medho gïnï, awope nyomo ëka anyira ënyömögï, naka othuno ï nïnö na Noa ödönyö ï yeya. ");
INSERT INTO lth_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Gïn ba ongeo gin mörö na bino tïmërë naka abwal pii obino ömöl ködgï ökö kïbëc. Bino bedo nï kömanön ka Wod ka Dhanö bino dwogo. ");
INSERT INTO lth_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ï karë nön jö arïö bino bedo ï pwodho; ebino kwanyö ngat acël ökö cë ngat acël bino dong. ");
INSERT INTO lth_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mon arïö bino bedo ï rego kï pong rego; ebino kwanyö ngat acël ökö cë ngat acël bino dong. ");
INSERT INTO lth_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Pï manön bed unu na wangwu thwolo, pïën ba ingeo unu nïnö mënë na Rwothwu bino dwogo ködë. ");
INSERT INTO lth_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ëntö myero ïnïang unu köp ni: Ka won öt onwongo ongeo caa na kwo bino bino ïë, ën onwongo bedo na wangë thwolo ëka ba mïö ëtürö ödë. ");
INSERT INTO lth_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pï manön, un thon myero ïyübërë, pïën Wod ka Dhanö bino bino ï caa na un ba ingeo. ");
INSERT INTO lth_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Cë nga dong n'obedo atic na genere ëka na ryëk, n'adwong mërë oketho ën më löönö etic na tye ï ödë më mïögï cemgï ï caa n'opore? ");
INSERT INTO lth_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bino bedo na bër both atic nön ka adwong mërë odwogo cë onwongo ën tye ka tïmö nï kömanön. ");
INSERT INTO lth_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","An akobo niwu köp adyer, ën bino ketho ën më löönö jami mërë kïbëc. ");
INSERT INTO lth_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ëntö ka atic na rac nön okobo kï ï cwinye kënë nï, ‘Adwongna bino bedo yökö pï karë na lac,’ ");
INSERT INTO lth_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ëka ën cakö pwodo etic ewodhe, cemo ëka medho kï jö na mër. ");
INSERT INTO lth_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Adwong k'atic nön bino dwogo ï nïnö ëka ï caa na ën ba ngeo. ");
INSERT INTO lth_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Cë ën bino pwodo ën rwök ëka ketho ën ï kabedo kanya acël k'etwodo, kanya koko ëka kaö lak bino bedo tye ïë. ");
INSERT INTO lth_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ï karë nön ker më polo bino bedo calö anyira apar n'obino öcïdhö gïnï kï taragï më romo k'anyom. ");
INSERT INTO lth_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Jö abic kï kin-gï onwongo mïng ëka jö abic onwongo ryëk. ");
INSERT INTO lth_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Anyira abic na mïng otero taragï na ba ömakö gïnï möö nökënë. ");
INSERT INTO lth_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ëntö anyira na ryëk otero gïnï möö ï cupagï kanya acël kï taragï. ");
INSERT INTO lth_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ï karë n'anyom pod ögalërë, gïn kïbëc nïnö öcakö makö wang-gï, cë önïnö gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ï karë na dong othuno dingwor, wöö öcakö winyere rwök: ‘Winy unu, anyom othuno ökö! Donyi unu yökö më romo ködë!’ ");
INSERT INTO lth_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Cë anyira apar kïbëc ocoo gïnï cücüth, ëka öyübö gïnï taragï. ");
INSERT INTO lth_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Anyira na mïng okobo gïnï both anyira na ryëk nï, ‘Mïïwa unu mööwu mörö, pïën mac tarawa mïtö thöö ökö.’ ");
INSERT INTO lth_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ëntö anyira na ryëk ögamö gïnï nï, ‘Möö ope na römö onu kïbëc. Apë unu both jö na cadhö möö ëk ïwïl unu mewu.’ ");
INSERT INTO lth_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ï karë n'anyira na mïng öcïdhö gïnï më wïlö möö, cücüth anyom othuno. Anyira n'onwongo öyübërë ödönyö gïnï kanya acël ködë ï öt karama më nyom. Cë dholokek eloro ökö. ");
INSERT INTO lth_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kinge anyira nökënë ca obino gïnï nakun bakö dhögï nï, ‘Adwong, adwong, yab nïwa dholokek!’ ");
INSERT INTO lth_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ëntö anyom ögamö nï, ‘An akobo niwu köp adyer nï an ba angeowu.’ ” ");
INSERT INTO lth_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Cë Yecu ojiko köp mërë nakun kobo nï, “Bed unu na wangwu thwolo, pïën ba ingeo unu nïnö onyo caa.” ");
INSERT INTO lth_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ker më polo thon cal kï dhanö mörö na tye ka cïdhö ï woth kanya bor. Ën ocwodo etic mërë kïbëc, cë ömïö jami mërë bothgï ëk ögwök gïnï. ");
INSERT INTO lth_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ën ömïö both atic mërë acël cïlïng elip abic na nyige, both dhanö nökënë ömïö cïlïng elip arïö na nyige, ëka both ngat nökënë ömïö cïlïng elip acël na nyige, ömïö both dhanö acëlacël na lübërë kï kite na ën twërö tic ködë. Cë öya öcïdhö ï woth mërë. ");
INSERT INTO lth_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Dhanö n'onwongo cïlïng elip abic na nyige öcakö tic ködë ökö pïöpïö ï cadhö wïl mërë, ëka onwongo magoba më cïlïng elip abic na nyige nökënë. ");
INSERT INTO lth_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Atic n'onwongo tye kï cïlïng elip arïö na nyige ötïmö nï kömanön thon, cë onwongo magoba më cïlïng elip arïö na nyige nökënë. ");
INSERT INTO lth_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ëntö dhanö n'obino ögamö cïlïng elip acël na nyige öcïdhö ökünyö bur ï ngöm, cë ökanö cïlïng k'adwong mërë ökö ïë. ");
INSERT INTO lth_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kinge karë na lac, adwong k'etic nonu odwogo, ëka öcakö kwanö lïm kanya acël ködgï. ");
INSERT INTO lth_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dhanö n'obino ögamö cïlïng elip abic na nyige obino okelo cïlïng elip abic na nyige nökënë. Ën okobo nï, ‘Adwong, in ibino ïmïa cïlïng elip abic na nyige. An anwongo cïlïng elip abic na nyige nökënë.’ ");
INSERT INTO lth_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Adwong mërë ögamö nï, ‘In ïtïmö na bër rwök, in ibedo atic na bër ëka atic na genere! In ibedo kï gen ï kom jami na nönök; an abino kethoni më löönö jami na pol. Bin dong ëk ïnywak yom cwiny k'adwongni!’ ");
INSERT INTO lth_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Cë atic n'onwongo ögamö cïlïng elip arïö na nyige thon obino. Ën okobo nï, ‘Adwong, in onwongo ïmïa cïlïng elip arïö na nyige; nën, an anwongo cïlïng elip arïö na nyige nökënë.’ ");
INSERT INTO lth_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Adwong mërë ögamö nï, ‘In ïtïmö na bër rwök, in ibedo atic na bër ëka atic na genere! In ibedo kï gen ï kom jami na nönök; an abino kethoni më löönö jami na pol. Bin dong ëk ïnywak yom cwiny k'adwongni!’ ");
INSERT INTO lth_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Cë atic n'onwongo ögamö cïlïng elip acël na nyige thon obino. Ën okobo nï, ‘Adwong, an onwongo angeo nï in ibedo dhanö na kite mërë tëk. Ïkaö kï kanya ba ïcwö kodhi ïë, ëka ïcökö thon kï kanya ba ipuro. ");
INSERT INTO lth_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Cë ömïö abedo kï lworo ëka an acïdhö akanö cïlïngni ökö pïny ï ngöm. Gam cïlïngni ene.’ ");
INSERT INTO lth_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Adwong mërë ögamö nï, ‘In ibedo atic na rac ëka atic na car! In onwongo ingeo nï an akaö kï kanya ba acwö kodhi ïë, ëka acökö thon kï kanya ba apuro? ");
INSERT INTO lth_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Cë onwongo myero iter cïlïngna both jö më beng, ëk ka an adwogo, an onwongo atwërö gamö cïlïngna kï magoba ïë. ");
INSERT INTO lth_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Pï manön kwany unu cïlïng elip acël na nyige ökö kï bothe, ëk ïmïï unu both dhanö na tye kï cïlïng elip apar na nyige. ");
INSERT INTO lth_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pïën ngat na tye kï gin mörö, ebino mëdö bothe, ëka bino bedo ködë na büp. Ngat n'ope kï gin mörö, naka gin na ën tye ködë ebino kwanyö ökö kï bothe. ");
INSERT INTO lth_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yuu unu atic na köny mërë ope ï cöl pïny, kanya koko ëka kaö lak bino bedo ïë.’ ");
INSERT INTO lth_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ï karë na Wod ka Dhanö bino dwogo kï dheo mërë, ëka k'emalaika kïbëc ködë, cë ën bino bedo ï then ker mërë më dheo. ");
INSERT INTO lth_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Rok kïbëc bino cökërë ï nyime, ëka ën bino poko jïï ï gurup arïö, kite n'akwath poko kï rom kï ï kom dyegi. ");
INSERT INTO lth_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ën bino ketho rom ï cïngë kucem, ëka dyegi ï cïngë kucam. ");
INSERT INTO lth_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Cë Rwoth bino kobo both jö na tye ï cïngë kucem nï, ‘Bin unu, un jö n'Apapna ömïöwu gum; lee unu ker n'ëyübö pïrwu anaka ï acaki cweo lobo. ");
INSERT INTO lth_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pïën kec onwongo oneka ëka ïmïa unu cem, örïö onwongo oneka ëka ïmïa unu pii amodho, an onwongo abedo welo ëka ïjöla unu, ");
INSERT INTO lth_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","an onwongo awotho kotula ëka ïmïa unu böngü aruko, an onwongo atwo, cë ïgwöka unu, ëka ï karë na an atye ï buc, un ibino më lïmöna.’ ");
INSERT INTO lth_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Cë jö na kitegï atïr bino gamö nïnë nï, ‘Rwoth, wan eneni awene na kec oneki cë wan emii cem, onyo n'örïö oneki cë wan emii pii? ");
INSERT INTO lth_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wan eneni awene na in ibedo welo cë wan ejoli, onyo na in iwotho kotula cë wan emii böngü më aruka? ");
INSERT INTO lth_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Awene na wan eneni na in itwo onyo na in itye ï buc cë wan elimi?’ ");
INSERT INTO lth_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Rwoth bino gamö nï, ‘An akobo niwu köp adyer nï gin na un ïtïmö both dhanö acël ï kin utmegona ni, manön ïtïmö unu botha.’ ");
INSERT INTO lth_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Cë ën bino kobo both jö na tye gïnï ï cïngë kucam nï, ‘Un jö n'ëcënö, yaa unu ökö kï nyima, ïdöny unu ï mac na ba thöö n'ëyübö pï Catan k'emalaika mërë. ");
INSERT INTO lth_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pïën kec onwongo oneka ëntö ba ïmïa unu cem më acama, örïö pii oneka ëntö ba ïmïa unu pii më amodha, ");
INSERT INTO lth_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","an onwongo abedo welo ëntö ba ïjöla unu, an onwongo awotho kotula ëntö ba ïmïa unu böngü më aruka, an onwongo atwo ëka atye ï buc ëntö un ba ibino më gwököna.’ ");
INSERT INTO lth_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Gïn thon bino gamö nï, ‘Rwoth, wan eneni awene na kec oneki, onyo n'örïö pii oneki, onyo na in ibedo welo, onyo na in iwotho kotula, onyo na in itwo, onyo na in itye ï buc, cë wan ba ekonyi?’ ");
INSERT INTO lth_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Cë Rwoth bino gamö nïgï nï, ‘An akobo niwu köp adyer nï gin mörö këkën na un ba ïtïmö both dhanö mörö acël na tïtïdï ï kin jö ni, nwongo ba ïtïmö unu botha.’ ");
INSERT INTO lth_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Cë gïn bino cïdhö ï can na ba thum, ëntö jö na kitegï atïr bino cïdhö gïnï ï kwö na ba thum.” ");
INSERT INTO lth_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ï karë na Yecu otyeko twakö köp ni gïnï kïbëc, ën okobo both ëlübkörë nï, ");
INSERT INTO lth_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Un ingeo nï odong nïnö arïö më thünö ï nïnö më Poth, ëka Wod ka Dhanö ebino mïö ökö më agura ï kor yath arïa.” ");
INSERT INTO lth_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Cë ëlamdhök na dito ëka edite ka lwak öcökërë gïnï kanya acël ï pacö k'Alamdhök na Dit, na nyïngë Kayapa. ");
INSERT INTO lth_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Gïn öyübö më makö Yecu ï müng ëk enek ën ökö. ");
INSERT INTO lth_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ëntö gïn okobo nï, “Pathï ï nïnö më karama, ëk arubaruba kür obed ï kin jïï.” ");
INSERT INTO lth_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ï karë na Yecu tye ï Betania ï öt ka Cimon na yam obedo adhöbü, ");
INSERT INTO lth_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","na Yecu onwongo tye ka cem, dhakö mörö obino bothe n'ömakö cupa më möö na ngwece kur na wel mërë tëk, cë önyö ï wie. ");
INSERT INTO lth_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ï karë n'ëlübkörë önënö, gïn öngöö ëka okobo nï, “Pïngö ëbalö möö ni abala nï köman? ");
INSERT INTO lth_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Möö na kur ni onwongo myero ëcadh acadha ï wel na thwönë ëk cïlïng mërë ëmïï both ëcan.” ");
INSERT INTO lth_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ëntö Yecu ongeo köp ni, cë okobo bothgï nï, “Iyelo unu dhakö ni pïngö? Ën ötïmö gin na bër rwök ï koma. ");
INSERT INTO lth_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pïën un itye kanya acël k'ëcan karë kïbëc, ëntö ba ibino unu bedo kanya acël köda karë kïbëc. ");
INSERT INTO lth_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ï karë na dhakö ni önyö möö ï koma, ën ötïmö më yübö koma më aika. ");
INSERT INTO lth_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","An akobo niwu köp adyer nï kanya kïbëc n'ebino tïtö köp më Emuth na Bër ïë ï wi lobo thükül, gin na dhakö ni ötïmö thon ebino kobo pïrë, ëk obed më po pï ën.” ");
INSERT INTO lth_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ï karë nön Yuda Ikariot, na ën dhanö acël ï kin ëkwëna apar arïö, öcïdhö both ëlamdhök na dito, ");
INSERT INTO lth_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","cë openyogï nï, “Un ibino mïöna ngö ka an amïö ën ï cïngwu?” Cë gïn ökwanö cïlïng pyer adek na nyige ëka ömïö gïnï bothe. ");
INSERT INTO lth_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Cakërë ï caa nön cïdhö ködë anyim Yuda öcakö rangö karë na bër na ën ërömö mïö kï Yecu ï cïng-gï. ");
INSERT INTO lth_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ï nïnö më acël më Karama më Ogati na Thöbï ope ïë, ëlübkör Yecu obino bothe cë openyo gïnï ën nï, “In ïmïtö nï wan ëyüb nini kabedo kwene ëk ïcam cem më Poth ïë?” ");
INSERT INTO lth_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yecu ögamö nï, “Cïdh unu ï taun both dhanö mörö ëka ikob unu nïnë nï, ‘Apwony okobo nï: Karëna dong cwök. An abino kwero nïnö më Poth ï odi kanya acël k'ëlübköra.’ ” ");
INSERT INTO lth_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Cë ëlübkör Yecu ötïmö kite na ën öcïkögï ködë, ëka öyübö gïnï cem më Poth kunön. ");
INSERT INTO lth_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ï karë na pïny dong oyutho, Yecu onwongo obedo pïny ï dhö cem kanya acël k'ëlübkörë apar wie arïö. ");
INSERT INTO lth_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ï karë na gïn tye ka cem, Yecu okobo bothgï nï, “An akobo niwu köp adyer, ngat acël kï kinwu bino ketho örörö ï koma.” ");
INSERT INTO lth_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Cë ëlübkörë öcakö kumo, nakun penyere gïnï kën-gï nï, “Rwoth, an?” ");
INSERT INTO lth_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yecu ögamö nï, “Dhanö na bino ketho örörö ï koma ënë ngat n'olutho ogati mërë ï öd bakuli köda. ");
INSERT INTO lth_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wod ka Dhanö bino thöö kite na calö ëcöö kï köp ï kome. Ëntö dhanö n'oketho örörö ï kom Wod ka Dhanö bino nënö can! Onwongo twërö bedo na bër ka dhanö nön onwongo ba ënywölö.” ");
INSERT INTO lth_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Cë Yuda, ngat n'oketho örörö ï kom Yecu, okobo nï, “Apwony, adyer pathï an?” Yecu ögamö nï, “Eyo, in ënön.” ");
INSERT INTO lth_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ï karë na gïn tye ka cem, Yecu ökwanyö ogati, cë ölëgö gum ï kome, ëka öbarö ïë, cë ömïö both ëlübkörë, nakun kobo nï, “Gam ëka ïcam unu; man ënë koma.” ");
INSERT INTO lth_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Cë ökwanyö okopo, öpwöyö Obanga ëka ömïö bothgï, nakun kobo nï, “Madh unu man, un kïbëc. ");
INSERT INTO lth_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Man ënë remona më cïkërë, n'ëönyö pï jö na pol më tïmö kïca ï kom bal. ");
INSERT INTO lth_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","An akobo niwu nï cakërë tin, an ba abino madhö nyig pig ölök ni, naka ï nïnö nön ka an abino madhö kodwu ï ker k'Apapna.” ");
INSERT INTO lth_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ï karë na gïn otyeko wero wer më lëga, öya öcïdhö gïnï ï wi Kidi më Jeituni. ");
INSERT INTO lth_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Cë Yecu okobo nïgï nï, “Ï kiwor na tin, un kïbëc ibino unu wëköna, pïën ëcö nï: “ ‘An abino gönö akwath, cë rom bino këth gïnï ökö ata.’ ");
INSERT INTO lth_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ëntö kinge ka an acer ökö, an abino cïdhö anyim niwu yo Galilaya.” ");
INSERT INTO lth_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petero ögamö nï, “Kadï jö kïbëc bino wëköni, an ba abino wëköni.” ");
INSERT INTO lth_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yecu okobo nïnë nï, “An akobo nini köp adyer nï ï kiwor na tin ni, na thwön gwënö bara okok, in ibino kwëröna wang adek.” ");
INSERT INTO lth_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ëntö Petero ögamö nï, “Kadï bed nï myero athöö kanya acël kodi, an ba abino kwëröni.” Cë ëlübkörë nökënë kïbëc okobo gïnï nï kömanön. ");
INSERT INTO lth_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Cë Yecu öcïdhö k'ëlübkörë ï kabedo mörö na nyïngë Gethcemane. Ï karë na gïn othuno kunön, ën okobo both ëlübkörë nï, “Bed unu kany, ëk an kono acïdh ï lëga yo kuca.” ");
INSERT INTO lth_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Cë ën ökwanyö Petero k'awope arïö ka Jebedayo më woth ködë, ëka cwinye öcakö podho rwök kï thwön kumo na dit. ");
INSERT INTO lth_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Cë Yecu okobo bothgï nï, “Cwinya tye ka cwer rwök, mïtö nekona ökö. Bed unu kany ëk ibed unu na wangwu thwolo köda.” ");
INSERT INTO lth_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yecu öcïdhö anyim na nönök, cë opodho pïny, okulo wie ëka ölëgö nï, “Apapna, ka twërë, kwany okopo ni ökö kï koma, ëntö kür obed kite na calö an amïtö, ëntö obed gin na in ïmïtö nï myero ötïmërë.” ");
INSERT INTO lth_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Cë ën odwogo both ëlübkörë ëka onwongogï önïnö ökö. Ën okobo both Petero nï, “Un ba ïtwërö bedo na wangwu thwolo pï caa acël köda? ");
INSERT INTO lth_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bed na wangwu thwolo ëka ïlëg unu, ëk kür ïdöny unu ï atëmatëma. Cwiny mïtö, ëntö kom görü.” ");
INSERT INTO lth_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ën dökï ödök wang më arïö ëka ölëgö nï, “Apapna, ka okopo ni ba twërö kwanyërë ökö naka ka an amadhö, ëk dong gin na in ïmïtö ötïmërë.” ");
INSERT INTO lth_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ï karë na ën odwogo, ën dökï onwongo ëlübkörë tye ka nïnö, pïën nïnö onwongo ömakö wang-gï rwök. ");
INSERT INTO lth_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Cë Yecu öwëkögï dökï ëka öcïdhö ölëgö wang më adek, nakun nwö köp acël nön. ");
INSERT INTO lth_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Cë ën odwogo both ëlübkörë ëka openyogï nï, “Un pod ïnïnö ëka itye ka yweo unu? Nën unu, caa onyingo na cwök, ëka Wod ka Dhanö ebino mïö ökö ï cïng ëbal. ");
INSERT INTO lth_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yaa unu malö! Eru ecidhu! Nën, dhanö na bino ketho örörö ï koma dong cwök!” ");
INSERT INTO lth_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ï karë na Yecu pod tye ka twak, Yuda n'obedo ngat acël ï kin ëkwëna apar wie arïö othuno. Ën obino kï lwak na pol n'ömakö gïnï pele abadë ëka ludhi. Ëlamdhök na dito ëka edite ka lwak ënë oorogï. ");
INSERT INTO lth_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Won örörö onwongo otyeko dong yübö anyuth ködgï nï: “Ngat na an abino nödhö leme, ën ënön, mak unu ën.” ");
INSERT INTO lth_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Cücüth Yuda obino both Yecu ëka okobo nï, “Apwony, itye!” Cë önödhö leme. ");
INSERT INTO lth_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yecu okobo both Yuda nï, “Okona, tïm gin na in ibino më tïmö.” Cë gïn obino opodho ï kom Yecu, ëka ömakö gïnï ën ökö. ");
INSERT INTO lth_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ëntö ngat acël n'onwongo tye gïnï kï Yecu kanya acël öryëö cïngë cë öwödhö pala abadë mërë, onguno kï ith atic k'Alamdhök na Dit. ");
INSERT INTO lth_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Cë Yecu okobo bothe nï, “Dwök pala abadëni ï kabedo mërë, pïën jö kïbëc na makö gïnï pala abadë, bino thöö gïnï kï pala abadë. ");
INSERT INTO lth_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Un ïthamö nï an ba atwërö lëgö Apapna ëk oor nïna emalaika na löö dul mwony apar wie arïö ökö ï caa ni? ");
INSERT INTO lth_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ëntö Cöc na Leng na kobo nï myero ötïmërë nï köman bino cobere nïngö?” ");
INSERT INTO lth_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ï caa nön Yecu okobo both lwak nï, “Un ibino botha kï pala abadë ëka ludhi më maköna, na calö ibino unu ï kom ayak? Nïnö kïbëc an abedo ï dyekal öt k'Obanga më pwony, ëka un ba ïmaka unu. ");
INSERT INTO lth_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ëntö man kïbëc ötïmërë ëk köp n'edwarpïny öcöö ocobere.” Cë ëlübkörë kïbëc örïngö öwëkö gïnï ën ökö. ");
INSERT INTO lth_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jö n'onwongo ömakö gïnï Yecu otero ën yo both Kayapa, Alamdhök na Dit, kanya onwongo epwony cïk ëka edite öcökërë gïnï ïë. ");
INSERT INTO lth_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ëntö Petero obedo ka lübö kör Yecu kï cecen, naka othuno ï dyekal k'Alamdhök na Dit. Kinge na Petero ödönyö ï dyekal, ën obedo pïny kanya acël k'ëkürpïny më nënö gin na bino tïmërë. ");
INSERT INTO lth_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ëlamdhök na dito ëka athuko më öd okiko k'edong kïbëc onwongo tye gïnï ka rangö caden më twodo ï kom Yecu ëk enek gïnï ën ökö. ");
INSERT INTO lth_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ëntö gïn ba onwongo köp mörö, kadï bed ecaden më twodo na pol obino anyim. Më ajiki mërë jö arïö obino gïnï anyim, ");
INSERT INTO lth_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ëka okobo gïnï nï, “Dhanö ni okobo nï, ‘An atwërö muko öt k'Obanga ëka agërö ökö ï nïnö adek.’ ” ");
INSERT INTO lth_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Cë Alamdhök na Dit öya malö ëka okobo both Yecu nï, “In ba ïtwërö gamö köp mörö? Kit caden mënë ene na jö ni okelo k'adoth ködë ï komi?” ");
INSERT INTO lth_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ëntö Yecu ölïng alïnga. Alamdhök na Dit okobo nïnë nï, “An amïtö ikwong kwong kï nyïng Obanga na kwö: Kob nïwa ka in ënë Meciya, Wod k'Obanga.” ");
INSERT INTO lth_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yecu ögamö nïnë nï, “Eyo, kite na in ikobo ködë. Ëntö an akobo niwu nï cakërë kobedini un ibino nënö Wod ka Dhanö n'obedo ï nget cïng më kucem ka Won Twër ëka na tye ka bino kï pöl gïnï më polo.” ");
INSERT INTO lth_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Cë Alamdhök na Dit öyëcö böng mërë ëka okobo nï, “Ën ötwakö köp më yanyö Obanga! Pïngö onu dökï ëmïtö caden nökënë? Kobedini un iwinyo ayeny na ën öyanyö k'Obanga. ");
INSERT INTO lth_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ngö na un ïthamö?” Gïn ögamö nï, “Bal mërë römö nïnë thöö.” ");
INSERT INTO lth_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Cë gïn öngülö laö dhögï ï wangë ëka ëgöö ën. Jö mökö odhongo ën ");
INSERT INTO lth_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nakun kobo gïnï nï, “In ibedo Meciya. Tuc nïwa nga n'ogoi?” ");
INSERT INTO lth_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petero onwongo tye yökö, obedo pïny ï dyekal. Cë atic na nyakö obino bothe ëka okobo nïnë nï, “In thon onwongo itye kanya acël kï Yecu më Galilaya.” ");
INSERT INTO lth_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ëntö Petero ökwërö ökö ï nyim jö kïbëc. Ën okobo nï, “An ba angeo gin na in itye ka twakö.” ");
INSERT INTO lth_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Cë Petero öcïdhö yökö ï dhö wangkac, atic na nyakö nökënë dökï önënö ën, cë okobo both jö n'onwongo tye gïnï kunön nï, “Dhanö ni onwongo tye kanya acël kï Yecu më Najaret.” ");
INSERT INTO lth_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petero dökï ökwërö ökö, nakun kwongere nï: “An ba angeo ëcwö nön!” ");
INSERT INTO lth_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kinge caa na nönök, jö n'onwongo ocung gïnï kany nön obino gïnï both Petero ëka okobo nï, “Adyer, in ibedo ngat acël ï kin-gï, pïën kite na in ïtwak ködë nyutho ökö.” ");
INSERT INTO lth_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Cë ï caa nön, Petero öcakö kwongere nakun kobo nï, “Ba angeo ëcwö ni.” Cücüth thwön gwënö okok. ");
INSERT INTO lth_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Cë Petero opo ï köp na Yecu ötwakö: “Na bara thwön gwënö okok, in ibino kwëröna wang adek.” Cë öcïdhö yökö ëka okok kï cwer cwiny rwök. ");
INSERT INTO lth_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kodiko cön na pïny tye ka ruu, ëlamdhök na dito kïbëc ëka edite ka lwak öyübö gïnï köp më neko Yecu. ");
INSERT INTO lth_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Gïn otweo Yecu, otero gïnï ëka ëmïö ën both Pilato n'obedo alöc më Roma. ");
INSERT INTO lth_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ï karë na Yuda, n'oketho örörö ï kom Yecu, önënö nï ëngölö köp më thöö ï wie, ën ongut ëka ödwökö cïlïng pyer adek na nyige both ëlamdhök na dito ëka both edite, ");
INSERT INTO lth_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nakun kobo nï, “An abalö më ketho örörö ï kom dhanö n'ope kï bal.” Gïn ögamö nïnë nï, “Manön obedo köpwa? Manön obedo pëköni.” ");
INSERT INTO lth_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Cë Yuda obolo cïlïng pïny ï öt k'Obanga ëka ödönyö yökö. Cë öcïdhö ödërë ökö. ");
INSERT INTO lth_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ëlamdhök na dito ökwanyö gïnï cïlïng ëka okobo gïnï nï, “Cïk ba yeo nï myero eketh cïlïng ni ï canduk lïm më öt k'Obanga, pïën obedo cïlïng më remo.” ");
INSERT INTO lth_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Cë gïn öyübö köp kanya acël, ëka otio gïnï kï cïlïng më wïlö pwodho k'acwe agulu, ëk obed kanya eiko erok ïë. ");
INSERT INTO lth_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Manön ënë ömïö ecwodo pwodho nön nï Pwodho më Remo thuno ködë naka tin. ");
INSERT INTO lth_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Cë köp n'onwongo adwarpïny Jeremia ötwakö ocobere: “Gïn otero cïlïng pyer adek na nyige, wel na jö Icarael onwongo öngölö ï kome, ");
INSERT INTO lth_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","cë gïn otio ködë më wïlö pwodho k'acwe agulu kite na Rwoth öcïka ködë.” ");
INSERT INTO lth_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yecu ocung ï nyim alöc më Roma n'openyo ën nï, “In ënë rwoth k'Eyuda?” Yecu ögamö nï, “Eyo, kite na in ikobo ködë.” ");
INSERT INTO lth_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ëntö ï karë n'ëlamdhök na dito ëka edite odotho gïnï Yecu, ën ba ögamö gin mörö. ");
INSERT INTO lth_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Cë Pilato openyo Yecu nï, “In ba itye ka winyo adoth na gïn odothi ködë?” ");
INSERT INTO lth_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ëntö Yecu ba ögamö köp mörö, kadï k'adoth mörö acël—man ömïö alöc ouro rwök. ");
INSERT INTO lth_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ï karama kïbëc më Poth, alöc onwongo gönyö amabuc acël both lwak, ngat mörö këkën na gïn mïtö. ");
INSERT INTO lth_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ï karë nön onwongo tye amabuc mörö n'engeo rwök, na nyïngë Baraba. ");
INSERT INTO lth_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cë ï karë na lwak öcökërë gïnï kanya acël, Pilato openyogï nï, “Nga na un ïmïtö nï agöny niwu, Baraba onyo Yecu n'ecwodo nï Meciya?” ");
INSERT INTO lth_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato onwongo ongeo nï gïn ömïö Yecu bothe pï nyeko. ");
INSERT INTO lth_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ï karë na Pilato obedo ï wi then më ngölö-köp, dhakö mërë ooro köp mörö bothe: “Kür ïtïm gin mörö ï kom dhanö nön n'ope kï bal, pïën tin ï wang lek anënö can na dit rwök pïrë.” ");
INSERT INTO lth_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ëntö ëlamdhök na dito ëka edite öcüpö gïnï lwak më penyo pï Baraba, ëk enek Yecu ökö. ");
INSERT INTO lth_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Alöc dökï openyogï nï, “Nga kï kin jö arïö ni na un ïmïtö nï an agöny niwu?” Gïn ögamö nï, “Baraba.” ");
INSERT INTO lth_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Cë Pilato openyogï nï, “Ngö na an myero dong atïm kï Yecu n'ecwodo nï Meciya?” Gïn kïbëc ögamö nï, “Gur ën ï kor yath arïa!” ");
INSERT INTO lth_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato openyogï nï, “Pïngö? Bal ngö na ën ötïmö?” Ëntö lwak öwöö gïnï rwök nï, “Gur ën ï kor yath arïa!” ");
INSERT INTO lth_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ï karë na Pilato önënö nï ba dökï ërömö tïmö gin mörö, ëka wöö onwongo tye ka mëdërë amëda, cë ökwanyö pii, ölwökö kï cïngë ï nyim lwak ëka okobo nï, “Bal më remo ka dhanö ni ba bino bedo ï wia, manön bino bedo pëköwu!” ");
INSERT INTO lth_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Lwak kïbëc ögamö nï, “Remo mërë obed ï wiwa ëka ï wi ëthïnöwa!” ");
INSERT INTO lth_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Cë Pilato ögönyö Baraba nïgï. Ëntö ën ömïö epwodo Yecu kï del, ëka ömïö ën bothgï ëk egur ï kor yath arïa. ");
INSERT INTO lth_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Cë acikari k'alöc otero gïnï Yecu ï Praitorion, ëka ögürö gïnï ën dyere. ");
INSERT INTO lth_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gïn ögönyö böngü mërë ëka oketho gïnï böngü na kwar ï kome. ");
INSERT INTO lth_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Cë öyübö gïnï tok öküdhö, ëka eketho ï wie. Gïn oketho lüth ï cïngë më kucem ëka orumo cöng-gï pïny ï nyime, nakun ëngalö ën nï, “Örëm, rwoth k'Eyuda!” ");
INSERT INTO lth_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Gïn öngülö laö dhögï ï kome ëka ökwanyö gïnï lüth cë ëgöö kï wie. ");
INSERT INTO lth_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kinge na gïn dong otyeko ngalö Yecu, cë gïn ögönyö böngü na kwar ökö kï ï kome, ëka eketho böng mërë ï kome. Cë gïn otero ën më guro ï kor yath arïa. ");
INSERT INTO lth_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ï karë n'onwongo gïn tye ka donyo yökö, oromo gïnï k'ëcwö mörö më Cirene na nyïngë Cimon, cë ödïö gïnï ën tëtëk më tingo yath arïa ka Yecu. ");
INSERT INTO lth_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gïn othuno ï kabedo n'ecwodo nï Golgota (na gönyö nï Kabedo më Cogo Wic). ");
INSERT INTO lth_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Acikari ömïö Yecu köngö ölök n'erubo kï yath na këc; ëntö kinge na ën öbïlö, Yecu ökwërö madhö ökö. ");
INSERT INTO lth_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kinge na dong gïn oguro Yecu ï kor yath arïa, obolo gïnï kwir më poko böng mërë. ");
INSERT INTO lth_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Cë gïn obedo pïny kunön më kürö ën. ");
INSERT INTO lth_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Oguro gïnï köp më adoth na gïn odotho ën ködë malö ï ka wie, n'ëcöö nï, “Man ënë Yecu, Rwoth k'Eyuda.” ");
INSERT INTO lth_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ekwoe arïö onwongo eguro kanya acël ködë, ngat acël yo cïngë kucem, ëka ngat acël yo cïngë kucam. ");
INSERT INTO lth_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jö n'onwongo tye ka wok ï ngete obedo gïnï ka yanyö ën, yengo wigï, ");
INSERT INTO lth_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ëka kobo gïnï nï, “In ikobo nï ibino muko öt k'Obanga ökö, cë ïgërö ï nïnö adek, lari keni ëka idhi pïny kï kor yath arïa, ka in ibedo Wod k'Obanga!” ");
INSERT INTO lth_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ëlamdhök na dito, epwony cïk ëka edite thon önywarö gïnï Yecu. ");
INSERT INTO lth_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Gïn okobo nï, “Ën ölarö jö nökënë, ëntö ën ba twërö larë kënë! Ën obedo rwoth më Icarael! Wëk ën obin pïny kï ï kor yath arïa, cë wan ebino yee ën. ");
INSERT INTO lth_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ën geno Obanga ëka kobo nï ën ebedo Wod k'Obanga. Wëk Obanga ölar ën kobedini ka mïtö.” ");
INSERT INTO lth_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ekwoe n'onwongo eguro kanya acël ködë thon öyanyö gïnï ën. ");
INSERT INTO lth_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Cakërë caa abicël më kiceng më thuno ködë naka caa abungwën, pïny ocido ökö na cöl ï wi lobo kïbëc. ");
INSERT INTO lth_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ï kin caa abungwën më kothyeno Yecu okok kï dwön na longo nï, “Eloi, Eloi, lama cabaktani?”—na gönyö nï, “Obangana, Obangana, pïngö ïwëka nï köman?” ");
INSERT INTO lth_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ï karë na jö mökö n'ocung kunön owinyo, gïn okobo nï, “Ën tye ka cwodo Eliya.” ");
INSERT INTO lth_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Cücüth dhanö acël örïngö ökwanyö amor, cë olutho ï köngö ölök na wac, örwakö ï wi lüth, ëka ömïö both Yecu nï ömadhï. ");
INSERT INTO lth_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ëntö jö nökënë okobo nï, “Wëk unu ën kënë! Eru enenu ka Eliya twërö bino më larö ën.” ");
INSERT INTO lth_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yecu okok dökï kï dwön na longo, cë öthöö ökö. ");
INSERT INTO lth_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ï caa nön, böngü katein na tye ï öt k'Obanga öyëc opokere ökö ï dul arïö cakërë kï malö naka pïny. Pïny oyengere ëka kite öbarë gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Lyene öyabërë ökö ëka kom jö k'Obanga na leng na pol n'onwongo öthöö ocer gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Odonyo gïnï ökö kï ï lyene ëka kinge cer ka Yecu öcïdhö gïnï ï Jerucalem cë onyuthere gïnï both jö na pol. ");
INSERT INTO lth_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ï karë n'Adit na löö acikari kï jö n'onwongo tye ködë më kürö Yecu önënö gïnï oyeyeng ëka gin na kïbëc n'ötïmërë, obedo gïnï kï lworo rwök, cë okobo gïnï nï, “Adyer, ën onwongo obedo Wod k'Obanga!” ");
INSERT INTO lth_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mon na pol onwongo tye gïnï kunön na neno gïnï kï cecen. Gïn onwongo ölübö kör Yecu kï ï Galilaya më könyö ën. ");
INSERT INTO lth_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ï kin mon nön gïnï onwongo tye ïë Maria më Magadala, Maria aya ka Yakobo ëka Yocepu, ëka aya k'awope ka Jebedayo. ");
INSERT INTO lth_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ï karë na pïny dong cido, dhanö mörö më Arimataya n'obedo alönyö na nyïngë Yocepu obino, ën thon onwongo obedo alübkör Yecu. ");
INSERT INTO lth_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ën öcïdhö both Pilato cë ökwaö kom Yecu ëka Pilato öcïkö nï ëk ëmïï bothe. ");
INSERT INTO lth_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yocepu ökwanyö kom Yecu, cë oboo ökö kï böngü na leng, ");
INSERT INTO lth_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ëka opyelo ï bur lyël mërë na nyen, na ën onwongo ogworo ï kidi. Ën ölörö kidi na thwönë ï dhö lyël, ëka öya öcïdhö ökö. ");
INSERT INTO lth_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria më Magadala ëka Maria nökënë ca onwongo obedo gïnï kunön n'opimere kï lyël. ");
INSERT INTO lth_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kodiko mërë, na ënë nïnö na lübö Nïnö më Yübërë, ëlamdhök na dito ëka Eparicayo öcökërë gïnï ï nyim Pilato. ");
INSERT INTO lth_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Gïn okobo nï, “Adwong, wan epo nï ï karë na ën pod kwö, wan ewinyo ka abwöl jö nön kobo nï, ‘Kinge nïnö adek an abino cer dökï.’ ");
INSERT INTO lth_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Cë myero ïmïï cïk ëk ëgwök lyël na bër naka ï nïnö më adek ëk kür ëlübkörë öcïdh gïnï ökwal kome ökö, cë okob gïnï both lwak nï ën ocer ökö kï ï kin jö n'öthöö. Bwöl më ajiki ni bino bedo na rac na löö bwöl më acël ökö.” ");
INSERT INTO lth_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato ögamö nï, “Ter unu acikari n'obedo gïnï ëkürpïny. Cïdh ïgwök unu na bër rwök kite na un ïtwërö ködë.” ");
INSERT INTO lth_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Cë öcïdhö gïnï më kürö dhö lyël na bër nakun mwönö gïnï anyuth ï kom kidi ëka eketho ëkürpïny. ");
INSERT INTO lth_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kinge Cabït k'Eyuda, ï kin keko ï nïnö na lübö cabït k'Eyuda, Maria më Magadala ëka Maria nökënë öcïdhö gïnï më nënö lyël. ");
INSERT INTO lth_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Athura oyeyeng na dit oyengo pïny, pïën malaika ka Rwoth n'öya kï ï polo obino pïny cë othwaro kidi ökö kï ï dhö lyël ëka obedo ï wie. ");
INSERT INTO lth_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Malaika nön onen na ryëny calö lüth köth, ëka böng mërë onwongo tar calö pëë. ");
INSERT INTO lth_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ëkürpïny obedo gïnï kï lworo rwök ï karë na gïn önënö malaika ëka komgï ömyël cë ödökö gïnï calö jö n'öthöö. ");
INSERT INTO lth_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ëntö malaika okobo both mon nï, “Kür ibed unu kï lworo, pïën an angeo nï un itye ka rangö Yecu n'onwongo eguro ï kor yath arïa. ");
INSERT INTO lth_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ën ba tye kany; ën ocer ökö, kite na ën okobo. Bin ïnën unu kanya ën onwongo obuto ïë. ");
INSERT INTO lth_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Cïdh unu pïöpïö ëk ikob unu both ëlübkörë: ‘Ën ocer ökö kï kin jö n'öthöö, ëka ën tye ka cïdhö anyim niwu yo Galilaya. Un ibino nënö ën kï kunön.’ Po unu ï kom ngö na an akobo niwu.” ");
INSERT INTO lth_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Cë mon öbünyö yaa ökö pïöpïö kï ï wi lyël kï lworo ëka kï yom cwiny na thwönë, cë örïngö gïnï më cïdhö kobo both ëlübkörë. ");
INSERT INTO lth_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Athura Yecu oromo ködgï, cë omothogï nï, “Kuc obed kodwu!” Gïn obino bothe, ömakö gïnï tyënë cë öwörö gïnï ën. ");
INSERT INTO lth_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Cë Yecu okobo nïgï nï, “Kür ibed unu kï lworo. Cïdh ikob unu both utmegona ëk öcïdh gïnï yo Galilaya; cë gïn bino nënöna kï kunön.” ");
INSERT INTO lth_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ï karë na mon tye ka woth ï yoo, ëkürpïny mökö öcïdhö ï taun ëka ödwökö gïnï ripot both ëlamdhök na dito gin na kïbëc n'ötïmërë. ");
INSERT INTO lth_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ï karë n'ëlamdhök na dito öcökërë gïnï kanya acël k'edite, cë öyübö gïnï köp më mïö cïlïng na thwönë both acikari, ");
INSERT INTO lth_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nakun kobo gïnï bothgï nï, “Kob unu both lwak nï, ‘Ëlübkörë obino gïnï kiwor cë ökwalö gïnï kome ï karë n'onwongo wan ënïnö ökö.’ ");
INSERT INTO lth_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ka alöc bino winyo köp ni, cë wan ebino kobo nïnë, ëk can mörö kür opodh ï komwu.” ");
INSERT INTO lth_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Cë acikari ögamö gïnï cïlïng, ëka ötïmö gïnï kite n'ëcïkögï ködë. Köp ni obedo këth ï kin Eyuda othuno ködë naka tin. ");
INSERT INTO lth_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Cë ëlübkörë apar wie acël öcïdhö gïnï yo Galilaya, ï wi kidi na Yecu onwongo okobo bothgï më cïdhö ïë. ");
INSERT INTO lth_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ï karë na gïn önënö Yecu, öwörö gïnï ën; ëntö jö mökö obedo k'akalakala. ");
INSERT INTO lth_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Cë Yecu obino bothgï ëka okobo nï, “Twër kïbëc na tye ï polo ëka ï wi lobo etyeko dong mïö ökö botha. ");
INSERT INTO lth_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pï manön cïdh unu dong ëk ïlök unu jö më rok kïbëc ödök gïnï ëlübköra, baticagï unu kï nyïng Apap, ëka Wod ëka Tipo Naleng, ");
INSERT INTO lth_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","pwony unugï më gwökö gin na kïbëc na an atyeko cïköwu ködë. An atye kodwu karë kïbëc, naka ï ajiki pïny.”");
INSERT INTO lth_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Man ënë acaki më köp më Emuth na Bër ï kom Yecu Kiricito, Wod k'Obanga. ");
INSERT INTO lth_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kite n'ëcöö ködë ï buk k'adwarpïny Icaya: “Obanga okobo nï, ‘An abino oro aorna ï nyimi, na bino yübö yoo nini.’ ");
INSERT INTO lth_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Dwön dhanö mörö tye ka redo ï thim nï, ‘Yüb unu yoo pï Rwoth, mïï unu yoo ocung atïr nïnë.’ ” ");
INSERT INTO lth_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aor ni onwongo obedo Jon Abatica. Ën onwongo tye ï thim ëka ötïtö nï jïï myero ebaticagï më nyutho nï gïn dong ongut ökö kï ï kom balgï ëka ölökërë gïnï both Obanga ëk ötïm nïgï kïca. ");
INSERT INTO lth_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jö na pol më lobo Yudea ëka Jerucalem obino gïnï both Jon. Gïn onwongo tuco balgï ëka Jon baticagï ï kulo Jordan. ");
INSERT INTO lth_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon onwongo ruko böng n'ëyübö kï kom yer kïnaga, tweo wang pyërë kï del, camö bonyo ëka mör kic më thim. ");
INSERT INTO lth_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jon ötïtö both jïï nï, “Ngat mörö ute na tye ka lübö köra, ën pïrë tëk löa ökö. An ba apora më gungo pïny ëka më gönyö thöl wörë. ");
INSERT INTO lth_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","An abaticawu kï pii, ëntö ën bino baticawu kï Tipo Naleng.” ");
INSERT INTO lth_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ï karë nonu Yecu öya kï ï Najaret ï lobo më Galilaya ëka Jon obatica ën ï kulo Jordan. ");
INSERT INTO lth_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na Yecu pod donyo malö kï ï pii, cücüth ën önënö polo öyabërë ëka Tipo Naleng opye ï kome na cal k'amam. ");
INSERT INTO lth_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ëka dwön mörö öya kï ï polo na kobo nï, “In ënë Woda më amara, cwinya yom ï komi.” ");
INSERT INTO lth_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Cücüth Tipo Naleng otero Yecu ï thim, ");
INSERT INTO lth_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","kanya ën obedo ïë pï nïnö pyer angwën nakun Catan tëmö ën. Leeni na ger onwongo thon ut kunön ëka emalaika obedo gwökö ën. ");
INSERT INTO lth_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ï karë na dong etweo Jon ï buc, Yecu obino yo Galilaya nakun tïtö köp më Emuth na Bër n'öya kï both Obanga. ");
INSERT INTO lth_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ën okobo nï, “Karë dong örömö, Ker k'Obanga dong cwök. Ngut unu ëka iyee unu köp më Emuth na Bër!” ");
INSERT INTO lth_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ï nïnö mörö acël na Yecu onwongo tye ka woth ï nget Nam më Galilaya, ën önënö ëcïk rëc arïö, Cimon ëka ömïn mërë Anderiya, bolo gïnï böögï ï pii. ");
INSERT INTO lth_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yecu okobo bothgï nï, “Bin ïlüb unu köra, ëka an abino mïöwu ïdökö ëmak jïï nakaka rëc.” ");
INSERT INTO lth_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Cücüth gïn öwëkö böögï ëka ölübö gïnï kör Yecu. ");
INSERT INTO lth_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ï karë na ën öcïdhö anyim na nönök, önënö Yakobo ëka ömïn mërë Jon, ëthïn ka Jebedayo, n'obedo gïnï ï yeya yübö böögï. ");
INSERT INTO lth_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ëka cücüth Yecu ocwodogï cë öwëkö gïnï apapgï Jebedayo ï yeya kï jö n'onwongo epangogï apanga ëka ölübö gïnï ën. ");
INSERT INTO lth_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yecu ëka ëlübkörë öcïdhö gïnï yo Kaperanaum, cücüth ï ceng Cabït k'Eyuda ën ödönyö ï cinagoga ëka öcakö pwony. ");
INSERT INTO lth_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jïï obedo kï ur ï kom pwony mërë, pïën opwonyo na calö ngat n'onwongo ut kï twër, na path kï kite n'epwony cïk pwonyo ködë. ");
INSERT INTO lth_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Cücüth dhanö mörö onwongo tye ï cinagogagï kï tipo na rac ëka öcakö redo nï, ");
INSERT INTO lth_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Kara ïmïtö ngö kï bothwa, Yecu më Najaret? In ibino më tyekowa ökö? An angeo ngat na in ibedo—ngat na Leng n'Obanga ooro.” ");
INSERT INTO lth_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ëntö Yecu ocoko nakun kobo nï, “Lïng ökö, ëka donyi ökö kï ï kome!” ");
INSERT INTO lth_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tipo na rac ömïö ën öryërë ëka oredo rwök cë öya ökö kï ï kome. ");
INSERT INTO lth_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jö kïbëc obedo gïnï kï ur rwök nakun penyere gïnï kën-gï nï, “Man ngö? Pwony na nyen na ut kï twër! Ën coko naka thon tipo na reco, ëka winyo gïnï ën.” ");
INSERT INTO lth_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Emuth ï kom Yecu ökëth örömö kabedo n'ögürö lobo më Galilaya kïbëc. ");
INSERT INTO lth_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cücüth na Yecu dong öya ökö kï ï cinagoga, öcïdhö gïn kï Yakobo ëka Jon yo pacö ka Cimon ëka Anderiya. ");
INSERT INTO lth_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Marö ka Cimon onwongo obuto pïny, na two lyetho ömakö ëka cücüth gïn okobo köp ï kome both Yecu. ");
INSERT INTO lth_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ën dong öcïdhö bothe, ömakö cïngë, ëka otingo malö. Two lyetho öya ökö kï ï kome ëka öcakö yübö nïgï cem. ");
INSERT INTO lth_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kothyeno nön na ceng dong dönyö, jïï okelo etwoe kïbëc bothe ëka jö na cene ömakögï. ");
INSERT INTO lth_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ëka jö kïbëc më taun nön ögürë gïnï ï dholokek. ");
INSERT INTO lth_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Cë Yecu öcangö jö na pol n'onwongo ut gïnï kï koth twoe na papath, ëka öryëmö cene na pol, ën ba oyeo nï cene më twak pïën gïn onwongo ngeo nga na ën obedo. ");
INSERT INTO lth_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kodiko cön na pïny pod cöl, Yecu öya cë öcïdhö yo kanyalik ëka obedo ï lëga kunön. ");
INSERT INTO lth_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ëntö Cimon ëka ewodhe öcïdhö gïnï më rangö ën. ");
INSERT INTO lth_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ï karë na gïn onwongo Yecu, gïn okobo nïnë nï, “Jö kïbëc tye ka rangöni.” ");
INSERT INTO lth_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ëntö Yecu okobo nïgï nï, “Eru ëcïdh unu ï peci nökënë ëk an thon atït nïgï köp. Manön ënë gin n'ömïö an abino.” ");
INSERT INTO lth_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Cë ën owotho ï Galilaya kïbëc nakun tïtö köp ï cinagogagï ëka ryëmö cene. ");
INSERT INTO lth_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ëcwö mörö na ut kï two dhöbü obino cë orumo cöngë both Yecu, nakun kwaö ën nï, “Ka ïmïtö, ïtwërö mïöna bedo na leng.” ");
INSERT INTO lth_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kïca ömakö Yecu cë öryëö cïngë ogudo ëka okobo nïnë nï, “An amïtö, komi dong obed na leng!” ");
INSERT INTO lth_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cücüth dhöbü orwenyo ökö kï ï kome ëka ëmïö ödökö na leng. ");
INSERT INTO lth_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Cë Yecu ömïö ën öcïdhö nakun cïkö na tëk nï, ");
INSERT INTO lth_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kür ikob both ngat mörö ngö n'ötïmërë. Ëntö cïdhï inyuthiri both alamdhök ëka ïmïï tyër pï bedoni na leng na lübërë kï cïk na yam Muca öcïkö pï jö n'ëcangögï kï ï two dhöbü. Man bino bedo caden both jö kïbëc nï in emii ïdökö na leng.” ");
INSERT INTO lth_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ëntö ën öcïdhö ëka örwëö ngö n'ötïmërë both jö kïbëc. Na calö adwogi ka ngö n'ötïmërë, ömïö Yecu ba dökï ödönyö ï taun na kome nen ëntö obedo yökö kanyalik, cë jïï kï ï kabedo kïbëc ömëdërë gïnï më bino bothe. ");
INSERT INTO lth_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kinge nïnö na nönök, Yecu dökï odwogo ï Kaperanaum, jïï owinyo nï ën odwogo pacö. ");
INSERT INTO lth_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Lwak na pol öcökërë gïnï kanya acël na kabedo ödökö na dïng naka ï dholokek, ëka ën ötïtö köp k'Obanga bothgï. ");
INSERT INTO lth_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Cë cwö angwën obino n'otingo gïnï dhanö na kome okwe bothe. ");
INSERT INTO lth_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Gïn onwongo ba römö tero ëcwö ni both Yecu pïën lwak onwongo opong rwök. Otuco gïnï wi öt kï malö n'opimere kï kanya Yecu onwongo ut ïë. Cë gïn olwao ëcwö na kome okwe n'obuto ï ökëka pïny ï nyim Yecu. ");
INSERT INTO lth_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ï karë na Yecu önënö yeegï, okobo n'ëcwö na kome okwe nï, “Woda, balni dong ëwëkö ökö.” ");
INSERT INTO lth_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ëntö epwonye mökö më cïk ka Muca onwongo obedo kany nön nakun penyere gïnï kï ï cwinygï kën-gï nï, ");
INSERT INTO lth_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Pïngö dhanö ni twak nï köman? Ën tye ka yanyö Obanga! Obanga këkën ënë twërö wëkö bal!” ");
INSERT INTO lth_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Cücüth Yecu ongeo kï ï cwinye ngö n'onwongo gïn tye ka thamö, ëka openyogï nï, “Pïngö ïthamö unu köp ni kï ï cwinywu? ");
INSERT INTO lth_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mënë na yot, më kobo both dhanö na kome okwe nï, ‘Balni dong ëwëkö ökö,’ onyo nï, ‘Yaa malö, ïkwany ökëkani, ëka ïcak woth’? ");
INSERT INTO lth_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ëntö an amïtö inge unu nï, Wod ka Dhanö ut kï twër ï wi lobo më wëkö bal.” Cë Yecu okobo both dhanö na kome okwe nï, ");
INSERT INTO lth_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“An akobo nini, yaa malö, kwany ökëkani ëka ïcïdh yo pacö.” ");
INSERT INTO lth_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ën öya malö, ökwanyö ökëka mërë ëka odonyo yökö na gïn kïbëc tye ka nënö. Jö kïbëc ouro ëka öpakö gïnï Obanga na kobo gïnï nï, “Wan anaka yam bara ënënö gin mörö na calö man!” ");
INSERT INTO lth_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yecu dökï öcïdhö ï dhö Nam më Galilaya. Lwak na pol obino bothe ëka ën öcakö pwonyogï. ");
INSERT INTO lth_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na Yecu onwongo tye ï woth, önënö Lebi wod k'Alipayo obedo ï öd cökö ocoro mërë. Yecu okobo nïnë nï, “Lüb köra.” Cë Lebi öya malö ëka ölübö körë. ");
INSERT INTO lth_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na Yecu onwongo ut ï cem ï öt ka Lebi, ëcök ocoro ëka ëbal na pol onwongo tye ï cem kanya acël ködë ëka ëlübkörë. Jö na pol onwongo tye n'ölübö gïnï kör Yecu. ");
INSERT INTO lth_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ï karë n'epwony cïk ka Muca n'obedo Eparicayo önënö gïnï ën ka cemo k'ëbal ëka ëcök ocoro, gïn openyo ëlübkör Yecu nï, “Pïngö ën cemo k'ëcök ocoro ëka ëbal?” ");
INSERT INTO lth_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ï karë na Yecu owinyo köp ni, ën okobo nïgï nï, “Pathï jö na komgï yot ënë mïtö daktar, ëntö etwoe. An ba abino më cwodo jö na kitegï atïr ëntö ëbal.” ");
INSERT INTO lth_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ï karë mörö n'onwongo ëlübkör Jon Abatica ëka Eparicayo ut gïnï ï rio kec, jö mökö obino gïnï both Yecu ëka openyo ën nï, “Pïngö ëlübkör Jon Abatica ëka ëlübkör Eparicayo rio gïnï kec, ëntö megi ba rio kec?” ");
INSERT INTO lth_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yecu ögamö nï, “Wele k'anyom twërö rio kec n'anyom tye ködgï kanya acël?” Ba twërö gïnï rio kec n'anyom tye ködgï kanya acël. ");
INSERT INTO lth_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ëntö karë bino thuno n'ebino kwanyö anyom ökö kï bothgï, cë gïn dong bino rio kec ï nïnö nön. ");
INSERT INTO lth_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ngat mörö ope na dapö böngü na nyen ï kom böngü n'otii, cë ka ötïmö, böngü na nyen bino yëcö böngü n'otii ökö cë mïö kanya öyëc bedo na thwönë. ");
INSERT INTO lth_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ëka ngat mörö ope na pïkö köngö ölök na nyen ï ocwe na cön. Ka öpïkö, cë köngö ölök bino yëcö ocwe ökö, köngö ölök bino öny ëka ocwe thon bal ökö. Ëntö köngö ölök na nyen myero ëpïkï ï ocwe na nyen.” ");
INSERT INTO lth_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ï nïnö mörö acël më ceng Cabït k'Eyuda, na Yecu onwongo tye ka wok k'ëlübkörë ï pwodho bël, ëlübkörë öcakö rïdhö with bël. ");
INSERT INTO lth_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Eparicayo okobo both Yecu nï, “Nën, pïngö gïn tye ka türö cïk ï ceng Cabït k'Eyuda?” ");
INSERT INTO lth_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ëka Yecu okobo nïgï nï, “Un ba ïkwanö kï ï Cöc na Leng ngö na Daudi ötïmö ï karë na kec oneko ën ëka ewodhe? ");
INSERT INTO lth_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ën ödönyö ï öt k'Obanga ï karë na Abiathar onwongo obedo Alamdhök na Dit ëka öcamö ogati n'ëtyërö both Obanga na yam cïk ökwërö nï dhanö mörö kür öcam na path k'ëlamdhök këkën. Ën thon ömïö nökënë both ewodhe.” ");
INSERT INTO lth_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Cë Yecu okobo nïgï nï, “Ceng Cabït onwongo ëyübö pï dhanö, pathï dhanö pï ceng Cabït. ");
INSERT INTO lth_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pï manön Wod ka Dhanö obedo Rwoth, naka thon më ceng Cabït.” ");
INSERT INTO lth_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ï nïnö mörö acël më ceng Cabït k'Eyuda, Yecu dökï ödönyö ï cinagoga ëka ëcwö na badë okwe onwongo ut kunön. ");
INSERT INTO lth_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jö mökö onwongo ut gïnï kunön më nënö ka Yecu twërö cangö ëcwö ni ï ceng Cabït ëk enwong gïnï yoo më dotho ën. ");
INSERT INTO lth_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yecu okobo both ëcwö na badë okwe nï, “Yaa malö ëk icung ï nyim jïï.” ");
INSERT INTO lth_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Cë Yecu okobo bothgï nï, “Cïk yeo ï ceng Cabït nï ëtïm gin mörö na bër onyo na rac, ëlar kwö onyo enek ökö?” Ëntö gïn ölïng alïnga. ");
INSERT INTO lth_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ën önënögï k'akëmö ëka cwinye ocwer pï nwang cwinygï. Yecu okobo n'ëcwö nï, “Ryë badi.” Ën öryëö badë cë öcang ökö. ");
INSERT INTO lth_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Cë Eparicayo odonyo gïnï yökö cücüth më yübö köp kï jö na cwakö Erode kite na myero enek kï Yecu. ");
INSERT INTO lth_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yecu k'ëlübkörë öya cë öcïdhö gïnï yo dhö nam, ëka lwak na pol n'öya kï ï lobo më Galilaya, Yudea, ");
INSERT INTO lth_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerucalem, Idemea, kukïdë më kulo Jordan, ëka kï ï lobo n'örïkö Turo kï Cidon ölübö gïnï körë. Ï karë na lwak na pol owinyo gïnï gin na kïbëc na ën obedo ka tïmö, gïn obino bothe. ");
INSERT INTO lth_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yecu okobo n'ëlübkörë nï öyüb gïnï yeya nïnë, ëk kür lwak ödïë. ");
INSERT INTO lth_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ën onwongo öcangö jö na pol ï nïnö nön, cë jö kïbëc na two onwongo dïrë gïnï më gudo ën. ");
INSERT INTO lth_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ka tipo na reco önënö Yecu, podho gïnï pïny ï nyime ëka kok gïnï nï, “In ibedo Wod k'Obanga.” ");
INSERT INTO lth_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ëntö Yecu öcïkö tipo na reco nï kür okob gïnï nï ngat mörö nga na ën ebedo. ");
INSERT INTO lth_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kinge manön Yecu öcïdhö ï wi kidi ëka ocwodo jö n'onwongo ën mïtö woth ködgï ëka obino gïnï bothe. ");
INSERT INTO lth_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ën öyërö jö apar arïö ëka ocwodogï nï ëkwëna ëk owoth ködë kanya acël, ëka eorgï më cïdhö tïtö köp k'Obanga, ");
INSERT INTO lth_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ëka më bedo kï twër më ryëmö cene. ");
INSERT INTO lth_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Man ënë jö apar arïö na ën öyërö: Cimon (na ën öcakö nyïngë nï Petero), ");
INSERT INTO lth_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo ëka ömïn mërë Jon, awope ka Jebedayo, (ëntö Yecu ömïögï nyïng nï, Boanergi, na tyën köp mërë nï, “Jö na mor kamë köth.”) ");
INSERT INTO lth_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anderiya, Pilipo, Batulumayo, Matayo, Tomaci, Yakobo wod k'Alipayo, Tadeo, Cimon (dhanö na mïtö löckën) ");
INSERT INTO lth_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ëka Yuda Ikariot n'oketho örörö ï kom Yecu. ");
INSERT INTO lth_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Cë Yecu ödönyö ï öt ëka lwak na pol obino örïkö ën dökï. Ën ëka ëlübkörë onwongo ba twërö gïnï nwongo caa më cem. ");
INSERT INTO lth_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ï karë na wede mërë owinyo ngö n'ötïmërë, cë obino gïnï më makö Yecu pïën gïn öthamö nï, “Ën opo ökö.” ");
INSERT INTO lth_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Epwony cïk ka Muca mökö öya kï ï Jerucalem na kobo gïnï nï, “Ën ut kï Belijebul, adwong ka cene. Kanya ën nwongo tëkö kï ïë më ryëmö cene.” ");
INSERT INTO lth_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Cë Yecu ocwodogï ëka ötwak ködgï kï carolok nï, “Catan twërö ryëmö Catan nïngö? ");
INSERT INTO lth_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ka ker opokere ïë arïö, ker nön ba twërö cung. ");
INSERT INTO lth_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ëka ka jö më öt opokere ïë arïö, jö më öt nön ba twërö cung. ");
INSERT INTO lth_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ëka ka Catan opokere cë ölwënyö ï kome kënë, ën ba twërö cung, ajiki mërë nwongo dong othuno. ");
INSERT INTO lth_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ngat mörö ope na twërö dönyö ï öt ka ngat na tëk më yakö jami mërë, thwara ka ën öcakö tweno dhanö na tëk ni ökö ëka dong cakö yakö jami kï ï ödë. ");
INSERT INTO lth_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","An akobo niwu köp adyer nï, bal kïbëc na dhanö tïmö ëka ayeny n'ëyanyö k'Obanga ërömö tïmö kïca, ");
INSERT INTO lth_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ëntö ngat mörö na yanyö Tipo Naleng ba ebino tïmö nïnë kïca pïën nwongo ötïmö bal na bedo na twal.” ");
INSERT INTO lth_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yecu okobo nïgï pïën gïn onwongo tye ka kobo nï, “Ën ut kï tipo na rac.” ");
INSERT INTO lth_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Cë aya ka Yecu ëka utmego mërë obino gïnï. Gïn ocung yökö ëka eoro ngat mörö both Yecu ï öt, ëk obin yökö ötwak ködgï. ");
INSERT INTO lth_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lwak onwongo obedo nakun ögürö gïnï Yecu ï dyere, cë ekobo nïnë nï, “Ayani ëka utmegoni ocung yökö tye gïnï ka rangöni.” ");
INSERT INTO lth_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yecu ögamö nïgï nï, “Nga ënë obedo ayana ëka utmegona?” ");
INSERT INTO lth_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Cë önënö jö n'obedo pïny n'ögürö ën dyere ëka okobo nï, “Man ënë ayana ëka utmegona. ");
INSERT INTO lth_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ngat mörö na tïmö ngö n'Obanga mïtö, ënë ömëra, amëra, ëka ayana.” ");
INSERT INTO lth_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yecu dökï öcakö pwony ï dhö Nam më Galilaya. Lwak na pol rwök öcökërë bothe, cë ën öïdhö ï yeya ëka obedo ïë nakun jïï kïbëc odong ï dhö nam. ");
INSERT INTO lth_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yecu opwonyogï kï köp na pol kï carolok nï: ");
INSERT INTO lth_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Winy unu! Apur mörö öcïdhö më cwöönö kodhi mërë. ");
INSERT INTO lth_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ï karë na ën tye ka cwöönö kodhi, kodhi mökö ökïr ï dye yoo, ëka wïny ödëdëpö ökö. ");
INSERT INTO lth_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kodhi nökënë ökïr kanya obedo kitekite na ngöm nönök ïë. Kodhi ni otuu pïöpïö pïën ngöm onwongo rëp. ");
INSERT INTO lth_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ëntö ï karë na ceng öryëny öwangögï rwök, oner gïnï ökö pïën oriigï ba ödönyö na thuth. ");
INSERT INTO lth_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kodhi nökënë opodho ï kin okudhi. Okudhi ödöngö ëka ödïögï cë ba önyakö nyige. ");
INSERT INTO lth_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kodhi nökënë opodho ï ngöm na bër ödöngö ëka nyige önyak, mökö pyer adek, mökö pyer abicël ëka mökö mia acël.” ");
INSERT INTO lth_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Cë Yecu okobo nï, “Ngat na tye kï ithe më winyo, myero owiny.” ");
INSERT INTO lth_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ï karë na Yecu onwongo tye kënë k'ëlübkörë apar arïö ëka jö nökënë, gïn openyo ën tyën carolok. ");
INSERT INTO lth_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ëka ën okobo nïgï nï, “Müng më ker k'Obanga ëmïöwu. Ëntö both jö nökënë an atwak ködgï kï carolok, ");
INSERT INTO lth_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ëk, “‘Ka gïn önënö, önën gïnï ëntö ba bino gïnï nïang. Ka gïn owinyo, owiny gïnï ëntö gïn ba bino nïang ïë. Pïën ka gïn ötïmö, gïn bino lökërë both Obanga, ëka ën bino tïmö nïgï kïca.’” ");
INSERT INTO lth_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Cë Yecu openyogï nï, “Un ba ïnïang ï tyën carolok ni? Un ibino nïang ï carolok nökënë kïbëc nïngö? ");
INSERT INTO lth_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Apur cwö kodhi na ënë köp k'Obanga. ");
INSERT INTO lth_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kodhi n'opodho ï yoo ocung pï jö na winyo köp k'Obanga, cë cücüth Catan bino kwanyö köp na gïn owinyo ökö. ");
INSERT INTO lth_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kodhi n'opodho kanya obedo kitekite, ocung pï jö na winyo köp k'Obanga ëka cücüth gamö gïnï kï yom cwiny. ");
INSERT INTO lth_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ëntö kit na ba ut gïnï k'orii n'ödönyö na thuth, ba bedo gïnï ape. Podho gïnï ökö cücüth ka tye gïnï kï pëkö onyo ka eketho ayela ï komgï pï yee köp k'Obanga. ");
INSERT INTO lth_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kodhi nökënë n'opodho ï kin okudhi ocung pï jö na winyo köp k'Obanga, ");
INSERT INTO lth_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ëntö par më kwö më lobo ni, marö lönyö, ëka miti më jami kïbëc bino cë dïö köp k'Obanga ökö ëka ba nyak gïnï. ");
INSERT INTO lth_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ëntö kodhi n'opodho ï ngöm na bër cung pï jö na winyo ëka gamö köp k'Obanga. Gïn nyakö nyig-gï pyer adek, mökö pyer abicël onyo mia acël.” ");
INSERT INTO lth_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yecu okobo both lwak nï, “Ngat mörö ute na cwïnyö tara cë ketho ï thë adïta onyo ï thë ëtana ëka ba ketho ï ka cibo tara? ");
INSERT INTO lth_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pïën ba tye gin mörö n'ökanërë na ba ebino ngeeno, ëka müng mörö ope na ba ebino kelo kanyalër. ");
INSERT INTO lth_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ka ngat mörö tye kï ithe më winyo, myero ën owiny.” ");
INSERT INTO lth_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yecu thon okobo nïgï nï, “Gwökërë unu kï kom gin nï winyo unu. Gin na un ipimo ködë, ënë thon ebino pimo niwu ködë, ëka dökï ebino mëdö niwu. ");
INSERT INTO lth_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jö na tye kï gin mörö ebino mëdö nïgï, ëka jö n'ope kï gin mörö ebino kwanyö naka thon gin mörö na tïdï na gïn tye ködë ökö.” ");
INSERT INTO lth_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yecu ömëdërë më kobo nï, “Ker k'Obanga cal k'apur n'öcwö kodhi ï ngöm. ");
INSERT INTO lth_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kiceng ëka kiwor, na ën önïnö onyo neno, nyig kodhi tuu ëka döngö, ëntö ën ba nïang kit na nwongo ötïmërë ködë. ");
INSERT INTO lth_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ngöm mïö nyig kodhi tuu ëka nyakö nyige kënë, më acël pote cakö donyo, cë wie yübërë, ëka ajiki mërë nyige cëk. ");
INSERT INTO lth_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ï karë na nyige öcëk, apur cakö bino ëka kaö kï pala, pïën karë më kac nwongo örömö.” ");
INSERT INTO lth_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yecu dökï openyo nï, “Ngö na onu ebino poro kï Ker k'Obanga onyo carolok mënë na onu myero etii ködë? ");
INSERT INTO lth_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Cal kï nyig kodhi karadali na ënë tïdï rwök kï kin kodhi n'ëpïdhö ï ngöm. ");
INSERT INTO lth_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ëntö ka ëpïdhö, döngö na thwönë rwök na löö kodhi nökënë kïbëc n'ëpïdhö ï pwodho. Jangë döngö na boco, ëka wïny na ngwëcö kï malö twërö gërö udigï cë yweo ï tipo mërë.” ");
INSERT INTO lth_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yecu ötïtö köp mërë both lwak nakun tio kï carolok, okobo nïgï kite na gïn twërö nïang ködë. ");
INSERT INTO lth_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ën ba okobo gin mörö bothgï na ba otio kï carolok, ëntö ka ën ut kënë k'ëlübkörë, ën gönyö nïgï jami kïbëc. ");
INSERT INTO lth_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ï nïnö nön na pïny dong cido, Yecu okobo both ëlübkörë nï, “Eru engolu nam yo löka nam tung ca.” ");
INSERT INTO lth_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Cë gïn otero Yecu ï yeya ëka öcakö gïnï wëkö lwak ï ngeegï. Yeya nökënë thon onwongo tye kanya acël ködë. ");
INSERT INTO lth_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ëka yamö na ger obino ï nam. Pii na tingere malö öcakö dönyö ï yeya, ëka yeya öcakö pong kï pii. ");
INSERT INTO lth_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ï caa nön, Yecu onwongo tye ka nïnö ï ngee yeya n'otheno wie k'athen wic. Ëlübkörë ocoo ën ëk öya malö, na redo gïnï nï, “Apwony, in ba ïparö nï wan ëcwök lüny ökö ï pii?” ");
INSERT INTO lth_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yecu öya malö ëka ocoko yamö cë okobo nï pii na tingere malö nï, “Lïng ökö! Cung moth!” Cücüth yamö ocung ökö, ëka jami kïbëc ölïng moth. ");
INSERT INTO lth_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Cë Yecu openyo ëlübkörë nï, “Pïngö un ilwor? Un ba itye kï yee?” ");
INSERT INTO lth_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ëlübkör Yecu onwongo ödökö gïnï na lwor ökö. Cë öcakö penyere gïnï kën-gï nï, “Ëcwö ni ënë nga, na naka thon yamö ëka pii na tingere malö winyo?” ");
INSERT INTO lth_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Cë Yecu ëka ëlübkörë öngölö Nam më Galilaya ëka othuno gïnï yo löka nam më lobo Gereca. ");
INSERT INTO lth_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ï karë na Yecu donyo yökö kï ï yeya, dhanö mörö na tye kï tipo na rac öya kï ï wi lyene më romo ködë. ");
INSERT INTO lth_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Dhanö ni onwongo bedo ï kin lyene ëka ngat mörö onwongo ope na twërö tweno ën kadï kï jëgëlë. ");
INSERT INTO lth_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pol karë etweo tyënë kï cïngë ëntö caa kïbëc ën codo jëgëlë ëka türö nywenyo ökö kï ï tyënë. Ngat mörö onwongo ope na tëk na twërö löönö ën. ");
INSERT INTO lth_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Karë kïbëc kiceng ëka kiwor ën bedo ï kin lyene ëka ï wi kite nakun kok, ëka ngöngölö kome kënë kï kite. ");
INSERT INTO lth_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ï karë na ën önënö Yecu kï kanya bobor, örïngö bothe cë orumo cöngë ï nyime. ");
INSERT INTO lth_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ën öcakö redo rwök nï, “Yecu, Wod k'Obanga na Malö Rwök, ngö na in ïmïtö kï botha? Kwongiri ï nyim Obanga nï ba ibino pwodona!” ");
INSERT INTO lth_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Pïën Yecu onwongo okobo nïnë nï, “Yaa ökö kï kom ëcwö ni, in tipo na rac!” ");
INSERT INTO lth_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Cë Yecu openyo tipo na rac nï, “Nyingi nga?” Ën ögamö nï, “Nyïngwa Lejon, pïën wan etye na pol ï dhanö ni.” ");
INSERT INTO lth_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tipo na reco dök ökwaö Yecu rwök ëk kür öryëmgï ökö kï ï lobo nön. ");
INSERT INTO lth_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Öthïpan pün onwongo tye ka cem ï bad kidi. ");
INSERT INTO lth_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Cë tipo na reco ökwaö gïnï Yecu nï, “Or-wa ï pün, ëk ëdöny ï ïgï.” ");
INSERT INTO lth_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Cë Yecu oyeo nïgï, ëka tipo na reco odonyo ëka ödönyö gïnï ï pün. Öthïpan pün onwongo tye na römö elip arïö. Pün öngwëcö gïnï kï ï bad kidi yo ï nam cë pii ömwönyögï ökö. ");
INSERT INTO lth_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ëkwath n'onwongo kwaö gïnï pün öngwëcö gïnï ökö ëka örwëö gïnï emuth ï taun na cwök ëka kï lobo n'ögürö kany nön. Jïï öbünyö cïdhö më nënö ngö n'ötïmërë. ");
INSERT INTO lth_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ï karë na lwak obino both Yecu, gïn önënö dhanö n'onwongo tipo na reco opong ï kome, obedo pïny kunön n'oruko böng mërë ëka wie tye na bër, cë lworo ömakögï kïbëc. ");
INSERT INTO lth_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ëka jö n'önënö ngö n'ötïmërë, okobo gïnï both jö nökënë köp ï kom dhanö na tipo na reco opong ï kome, ëka ï kom pün. ");
INSERT INTO lth_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Cë lwak öcakö kwaö Yecu ëk öya ökö kï ï lobogï. ");
INSERT INTO lth_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na Yecu dong tye ka dönyö ï yeya, dhanö n'onwongo tipo na reco tye ï kome, ökwaö ën nï ëk ewoth ködë. ");
INSERT INTO lth_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ëntö Yecu ba oyeo. Okobo nïnë nï, “Cïdh yo pacö ëka both jö na megi cë ikob nïgï jami kïbëc na Rwoth Obanga ötïmö ëka kit na ën ötïmö nini kïca ködë.” ");
INSERT INTO lth_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ën öcïdhö cë öcakö kobo ngö na Yecu ötïmö ï kome ï Dekapoli ëka jö kïbëc n'owinyo ngö na ën okobo, obedo gïnï kï ur rwök. ");
INSERT INTO lth_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ï karë na Yecu dökï öngölö nam kï yeya yo löka nam tung ca, lwak na pol öcökërë bothe nakun ën onwongo tye ï nget nam. ");
INSERT INTO lth_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Cë atëla mörö acël më cinagoga, na nyïngë Yairo obino. Ï karë na ën önënö Yecu, orumo cöngë pïny, ");
INSERT INTO lth_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ëka odweko ën nï, “Nyara na tïdï dong tye ka thöö athöa. Öma! Bin iketh cingi ï kome, ëk öcang cë ökwö.” ");
INSERT INTO lth_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yecu owotho kanya acël kï Yairo. Lwak na pol ölübö ën nakun ëdïö ën. ");
INSERT INTO lth_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Dhakö mörö onwongo tye na remo obedo cwer kï ï kome pï mwaka apar arïö na ba cok. ");
INSERT INTO lth_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ën ölïmö can na thwönë, ëka öbalö lïm mërë kïbëc n'onwongo ën ut ködë më cülö daktae na pol. Ëntö two mërë ömëdërë amëda na ba öcang. ");
INSERT INTO lth_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ï karë na ën owinyo köp ï kom Yecu, obino kï kungee nakun wok kï kin jïï ëka ogudo böngü ka Yecu, ");
INSERT INTO lth_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","pïën ën onwongo öthamö pïrë kënë nï, “Ka atwërö gudo böngü mërë këkën, an abino cang.” ");
INSERT INTO lth_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Cücüth remo na cwer ocung ökö, ëka ongeo kï ï kome nï ën ëcang ökö kï kom can mërë. ");
INSERT INTO lth_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ï caa nonu cücüth, Yecu ongeo nï tëkö öya kï ï kome. Ën ölökërë both lwak cë openyo nï, “Nga n'ogudo böngüna?” ");
INSERT INTO lth_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ëlübkörë okobo nïnë nï, “In ïnënö lwak tye ka dïöni ëka dökï ipenyo nï nga n'ogudi?” ");
INSERT INTO lth_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ëntö Yecu ölökërë më nënö nga n'ogude. ");
INSERT INTO lth_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Cë dhakö ongeo ngö n'ötïmërë ï kome, obino na kome myël kï lworo ëka orumo cöngë ï nyim Yecu cë ën okobo köp n'adyer kïbëc bothe. ");
INSERT INTO lth_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yecu okobo both dhakö nï, “Nyara, yeeni ömïö ïdökö na bër. Cïdh kï kuc ëka ïcang ökö kï kom twoni.” ");
INSERT INTO lth_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na Yecu onwongo pod twak ködë, cwö mörö obino kï ï pacö ka Yairo, atëla më cinagoga. Gïn okobo nïnë nï, “Nyari dong öthöö ökö. Kür dökï iyel apwony.” ");
INSERT INTO lth_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ëntö Yecu onwongo owinyo ngö na gïn tye ka kobo ëka okobo both adit më cinagoga nï, “Kür ibed kï lworo. Bed kï yee këkën.” ");
INSERT INTO lth_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Cë Yecu ba oyeo nï ngat mörö më lübö körë na path kï Petero, Yakobo ëka Jon (ömïn Yakobo). ");
INSERT INTO lth_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ï karë na gïn obino ï pacö k'atëla më cinagoga, Yecu önënö jïï na tye ka wöö kï koko. ");
INSERT INTO lth_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ën ödönyö ï öt ëka okobo nïgï nï, “Pïngö ïwöö unu kï koko nï köman? Athïn ba öthöö, ëntö önïnö anïna.” ");
INSERT INTO lth_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lwak önyërö Yecu. Ëntö ën öryëmögï kïbëc yökö ëka ödönyö k'apap k'athïn, aya k'athïn ëka ëlübkörë adek ï öt kanya anyaka nön onwongo obuto ïë. ");
INSERT INTO lth_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yecu ömakö cïngë cë okobo nïnë nï, “Talitha kumi,” na gönyö nï, “Athïn anyaka, yaa malö!” ");
INSERT INTO lth_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ëka cücüth anyaka öya malö ëka öcakö woth (ën onwongo tye kï mwaka apar arïö), cë jïï obedo kï thwön ur rwök. ");
INSERT INTO lth_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yecu öcïkögï rwök nï kür ömïï gïnï ngat mörö onge ngö n'ötïmërë ëka okobo nïgï më mïö nyakö nön gin mörö ëk öcam. ");
INSERT INTO lth_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yecu öya ökö kï kunön, ödök yo lobo thurgï ëka ëlübkörë ölübö ën. ");
INSERT INTO lth_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ï ceng Cabït k'Eyuda, ën öcakö pwony ï cinagoga. Jö na pol n'owinyo pwony mërë ouro gïnï ëka openyo gïnï nï, “Ëcwö ni onwongo ryëkö ni kïbëc kï kwene? Kit ryëkö mënë n'ëmïö ën? Ën tio tango nïngö? ");
INSERT INTO lth_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Man pathï apaa bao, wod ka Maria ëka ömïn Yakobo, Yoce, Yuda, ëka Cimon. Amego mërë ba kwö ï kin onu kany?” Cë gïn ökwërö yee ï kome. ");
INSERT INTO lth_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Cë Yecu okobo nïgï nï, “Adwarpïny ëwörö ï kabedo kïbëc na path kï ï taun më pacö mërë ëka ï kin wede mërë kï jö më dyekalgï.” ");
INSERT INTO lth_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yecu onwongo ba twërö tio tango mörö kunön, na path kï ketho cïngë ï wi etwoe mörö na nönök ëka öcangögï. ");
INSERT INTO lth_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ën obedo kï ur rwök pïën gïn ope kï yee. Cë Yecu owotho ï pacö kï pacö, nakun pwonyo jïï. ");
INSERT INTO lth_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ën ocwodo ëlübkörë apar arïö kanya acël ëka öcakö orogï k'arïö arïö nakun mïögï twër ï kom tipo na reco. ");
INSERT INTO lth_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yecu okobo nïgï nï kür owoth gïnï kï gin mörö ï wothgï na path kï lüth ögölë. Kür ömak gïnï cem, ocwe ëka cïlïng ï jëba. ");
INSERT INTO lth_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ën oyeo nïgï më ruko wör, ëntö kür ömak gïnï böngü më alöka. ");
INSERT INTO lth_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ën okobo nïgï nï, “Ka ïdönyö unu ï öt mörö, bed unu kany nön naka ka ibino yaa unu kï kany nön. ");
INSERT INTO lth_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ëntö ka ba ëgamöwu ï kabedo mörö onyo ewinyowu, ka ïya unu, tëng unu apua më tyënwu ëk obed caden bothgï.” ");
INSERT INTO lth_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Cë ëlübkör Yecu öcakö cïdhö gïnï, nakun tïtö gïnï nï jïï myero ongut gïnï kï kom balgï. ");
INSERT INTO lth_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Gïn öryëmö cene na pol ëka ewiro etwoe na pol kï möö cë ëcangögï. ");
INSERT INTO lth_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Rwoth Erode owinyo köp ï kom Yecu pïën jö kïbëc onwongo twakö köp ï kome. Jö mökö onwongo kobo nï, “Man myero obed Jon Abatica n'ocer kï ï lyël. Manön ënë ömïö ën tye ka tio koth tango ni.” ");
INSERT INTO lth_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jö nökënë okobo nï, “Ën obedo adwarpïny Eliya.” Jö nökënë kobo nï, “Ën obedo adwarpïny na cal k'edwarpïny mörö na cön.” ");
INSERT INTO lth_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ëntö ï karë n'Erode owinyo köp ï kom Yecu, okobo nï, “Man myero obed Jon! Ëcwö na an anguno ngute ënë dökï ocer ökö.” ");
INSERT INTO lth_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Erode onwongo ooro acikari më makö Jon ëka ketho ën ï buc pï Kerodia, dhakö k'ömïn mërë Pilipo, pïën Erode onwongo ökwanyö Kerodia më bedo dhakö mërë. ");
INSERT INTO lth_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon obedo ka kobo n'Erode nï, “Cïk ka Muca ba yeo nï ïkwany dhakö k'omeru ïlök ödök megi.” ");
INSERT INTO lth_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kerodia obedo kï cwer cwiny ï kom Jon ëka ömïtö më neko ën. Ëntö ba ötwërö, ");
INSERT INTO lth_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","pïën Erode onwongo lworo Jon ëka ngeo nï ën onwongo obedo dhanö na kite atïr ëka ëcwö na leng, cë ën ögwökö Jon na bër. Ën onwongo marö winyo twak ka Jon kadï bed wie orubere, caa kïbëc ën mïtö nï ewiny köp ka Jon. ");
INSERT INTO lth_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kerodia onwongo karë na bër ï nïnö n'Erode öyübö karama më po pï nïnö n'ënywölë ködë. Ën ocwodo edite mërë, ëtëla wi lwëny ëka edite më Galilaya. ");
INSERT INTO lth_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ï karë na nyaka Kerodia obino ëka ömyël, ën oyomo cwiny Erode ëka wele mërë. Erode okobo both nyakö nï, “Penya gin mörö këkën na in ïmïtö. An abino mïöni.” ");
INSERT INTO lth_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ëka ën okwongere bothe nï, “An abino mïöni gin mörö këkën na in ibino penyo kï botha, naka thon nucu më kerna!” ");
INSERT INTO lth_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Anyaka ni öcïdhö both aya mërë cë okobo nïnë nï, “Ngö na myero apeny?” Aya mërë okobo nïnë nï, “Peny wi Jon Abatica!” ");
INSERT INTO lth_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Anyaka ni öbünyö woth pïöpïö ödök cen both Erode ëka okobo nïnë nï, “Amïtö ïmïa wi Jon Abatica ï canïa kany ï caa ni!” ");
INSERT INTO lth_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Cë rwoth Erode obedo kï kumo rwök ëntö pï kwong na ën okwongo ï nyim wele mërë, ömïö ën ba twërö kwërö na nyaka ni. ");
INSERT INTO lth_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Cücüth rwoth ooro acikari na kürö pïny ï buc më cïdhö nguno ngut Jon ëka okel nïnë wie. Acikari öcïdhö ï buc cë onguno wi Jon ");
INSERT INTO lth_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","oketho ï canïa, ëka okelo ömïö both nyakö ni. Nyakö ni dong otero both aya mërë. ");
INSERT INTO lth_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ï karë n'ëlübkör Jon owinyo gïnï ngö n'ötïmërë, obino gïnï cë ökwanyö gïnï kome ëka ëcïdhö eiko ï bur lyël. ");
INSERT INTO lth_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ï karë n'ëkwëna odwogo gïnï both Yecu, gïn okobo nïnë gin na kïbëc na gïn ötïmö ëka opwonyo. ");
INSERT INTO lth_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Cë Yecu okobo nïgï nï, “Eru ecidhu yo kanya jïï ope ïë ëk eywe na nönök.” Ën okobo nï köman pïën jïï onwongo tye na pol na bino ëka cïdhö gïnï. Yecu ëka ëkwëna mërë ba obedo gïnï kï caa mörö më cem thon. ");
INSERT INTO lth_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Cë gïn dong ödönyö ï yeya ëka öcïdhö yo kanya jïï ope ïë. ");
INSERT INTO lth_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ëntö jö na pol n'önënögï ka cïdhö, ongeogï ëka öngwëcö gïnï kï tyën-gï kï kin peci cë öcakö thuno gïnï anyim nïgï. ");
INSERT INTO lth_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ï karë na Yecu donyo yökö kï ï yeya, ën önënö lwak jïï na pol ëka kïca ömakö ën ï komgï, pïën gïn onwongo cal kï rom n'akwathgï ope. Cë öcakö pwonyogï kï köp na pol. ");
INSERT INTO lth_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Na pïny dong cwök yutho, ëlübkör Yecu obino bothe ëka okobo gïnï nï, “Kany obedo kanyalik, ëka pïny thon tye ka cido. ");
INSERT INTO lth_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kob nï lwak ëk öcïdh gïnï kanya jö mökö kwö gïnï ïë ëka ï kin peci na cwök ëk öwïl gïnï cem mörö më acama.” ");
INSERT INTO lth_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ëntö Yecu ögamö nï, “Miwugï gin mörö më acama.” Gïn openyo Yecu nï, “In ïmïtö nï wan ëcïdh ëk etii kï denario mïa arïö më wïlö ogati më pïdhögï?” ");
INSERT INTO lth_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Cë Yecu openyogï nï, “Ogati adi na un iut ködë? Cïdh ïnën unu.” Gïn odwogo ëka okobo gïnï nï, “Wan eut k'ogati abic ëka rëc arïö.” ");
INSERT INTO lth_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Cë Yecu okobo n'ëlübkörë ëk ömïï jïï obed gïnï pïny ï gurup ï lum na mar. ");
INSERT INTO lth_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jïï obedo pïny ï gurup më mia acëlacël ëka pyer abicabic. ");
INSERT INTO lth_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yecu ökwanyö ogati abic ëka rëc arïö, önënö malö ï polo, ëka ölëgö gum. Cë opoko ï ogati ëka ömïö both ëlübkörë ëk opok gïnï both jïï. Ën thon opoko rëc arïö ï kin-gï kïbëc. ");
INSERT INTO lth_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Gïn kïbëc ocemo ëka oyeng gïnï. ");
INSERT INTO lth_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ëka kinge, ëlübkör Yecu öcökö gïnï ngïny ogati ëka rëc n'odong pong aditi apar arïö. ");
INSERT INTO lth_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wel cwö n'öcamö gïnï ogati onwongo tye elip abic. ");
INSERT INTO lth_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Cücüth kinge man, Yecu okobo n'ëlübkörë ëk ödöny gïnï ï yeya ëk öcïdh gïnï anyim yo löka Bethecaida, nakun ën kobo both jïï ëk ödök gïnï pacö. ");
INSERT INTO lth_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kinge na dong omotho jïï, ën öcïdhö ï lëga ï wi kidi. ");
INSERT INTO lth_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kothyeno na pïny dong ocido, ëlübkör Yecu onwongo ut gïnï ï yeya ï dyere nam. Yecu onwongo odong kënë ï ngöm. ");
INSERT INTO lth_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ën önënö nï ëlübkörë onwongo tye gïnï ï thwön can, na yelere gïnï më mïö yeya cïdhö anyim pïën yamö onwongo tye ka yelogï. Na caa abungwën më kodiko dong römö, Yecu obino bothgï nakun tye ka woth ï wi pii. Ën öthëna më poth kalögï, ");
INSERT INTO lth_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ëntö ï karë na gïn önënö Yecu nakun tye ka woth ï wi pii kï tyënë, gïn okok rwök kï lworo n'öthamö gïnï nï ködë ën obedo jwök. ");
INSERT INTO lth_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Gïn kïbëc onwongo komgï öthöö ökö ï caa na gïn önënö Yecu. Ëntö Yecu ötwak ködgï cücüth nakun kobo nïgï nï, “Kür ibed unu kï lworo, bed unu na cwinywu tëk! An ënön!” ");
INSERT INTO lth_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Cë Yecu öïdhö ï yeya bothgï, ëka yamö ocung. Gïn kïbëc ouro gïnï rwök, ");
INSERT INTO lth_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","pïën gïn onwongo bara önïang ï kom tango më ogati. Cwinygï onwongo nwang rwök më nïang. ");
INSERT INTO lth_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kinge na dong öngölö gïnï nam, Yecu ëka ëlübkörë ocung gïnï ï löka nam ï Genecaret ëka öywaö gïnï yeya ï lak nam. ");
INSERT INTO lth_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ï karë na gïn odonyo yökö kï ï yeya, cücüth jïï öcakö ngeno ën, ");
INSERT INTO lth_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","cë örïngö gïnï ï kabedo kïbëc, na tingo gïnï jö na two k'ökëka yo kanya gïn onwongo owinyo nï Yecu ut ïë. ");
INSERT INTO lth_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kanya kïbëc na ën cïdhö yo ïë, ï kin peci, peci na döngö, onyo ï nget lobo, gïn okelo etwoe yo cuk. Gïn ökwaö ën ëk ömïï etwoe ogud lak böngü mërë, ëka jö kïbëc n'ogudo ebino ëcangögï ökö. ");
INSERT INTO lth_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ï nïnö mörö acël, Eparicayo mökö ëka epwony Cïk ka Muca n'öya gïnï kï ï Jerucalem, obino ëka öcökërë gïnï both Yecu. ");
INSERT INTO lth_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Cë önënö gïnï ëlübkörë mökö na ba lübö cïk më kwer më lwökö cïng jö na bara ecemo. ");
INSERT INTO lth_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Eparicayo ëka Eyuda kïbëc ba cemo na bara ölwökö gïnï cïng-gï kite na cïk më thëkwarö k'edite mïtö ködë. ");
INSERT INTO lth_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ëka ka gïn odwogo kï ï cuk, ba cemo gïnï na bara ölwökö cïng-gï. Gïn thon lübö cïk më thëkwarö nökënë na pol na calö lwökö ekopo, aguli, ëka k'aguli më mola. ");
INSERT INTO lth_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Eparicayo ëka epwony cïk openyo gïnï Yecu nï, “Pïngö ëlübkori ba lübö gïnï cïk më kwer më thëkwarö k'edite ëntö cemo gïnï kï cïng-gï na ba ëlwökö?” ");
INSERT INTO lth_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yecu ögamö nï, “Un etwodo! Adwarpïny Icaya onwongo odwaro köp n'atïr ï komwu kite n'ëcöö ködë nï, “‘Rok ni wöra gïnï kï del dhögï, ëntö cwinygï bor köda. ");
INSERT INTO lth_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wöra gïnï nono, pwony na gïn pwonyo obedo cïk ka dhanö.’ ");
INSERT INTO lth_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Un ïkwërö lübö cïk k'Obanga ëka ïlübö unu kite ka dhanö.” ");
INSERT INTO lth_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Cë Yecu okobo bothgï nï, “Itye unu kï yodhi na bër më kwërö cïk k'Obanga, ëk ïlüb unu kite më thëkwarö na mewu. ");
INSERT INTO lth_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Muca yam okobo nï, ‘Wör apapni ëka ayani,’ ëka nï, ‘Ka ngat mörö öyanyö apap mërë onyo aya mërë, myero enek ökö.’ ");
INSERT INTO lth_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ëntö un ikobo nï ka dhanö mörö okobo n'apap mërë onyo aya mërë nï, ‘Gin n'onwongo myero akonyi ködë ënë lïm më Korban’ (na tyën köp mërë ënë nï gin n'ëmïö ökö both Obanga), ");
INSERT INTO lth_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","cë ën kür dökï ömïï lïm mörö më könyö apap mërë onyo aya mërë. ");
INSERT INTO lth_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ï kit yoo ni, un ïkwërö köp k'Obanga ëka ïlübö unu kite më thëkwaröwu. Ëka ïtïmö unu jami na pol na cal kï manön.” ");
INSERT INTO lth_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Cë Yecu ocwodo lwak bothe dökï ëka okobo nïgï nï, “Un kïbëc winy unu köpna ëka ïnïang unu ïë. ");
INSERT INTO lth_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Gin mörö ope na yaa kï yökö na dönyö ï dhanö na twërö balö ën, ëntö gin na yaa kï ï dhanö na donyo yökö ënë balö ën. ");
INSERT INTO lth_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ngat na tye kï ithe më winyo myero ën owiny.” ");
INSERT INTO lth_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ï karë na Yecu öwëkö lwak ëka ödönyö ï öt, ëlübkörë openyo ën tyën köp ï kom carolok ni. ");
INSERT INTO lth_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Cë Yecu openyogï nï, “Un thon bara ïnïang unu? Ba ingeo unu nï gin na kïbëc na dönyö ï dhanö nakun öya kï yökö ba twërö balö ën? ");
INSERT INTO lth_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pïën ba dönyö naka ï cwinye, ëntö cïdhö ï jamïë cë donyo yökö.” (Na Yecu okobo köp ni, ën onwongo tye ka kobo nï cem kïbëc opore më acama.) ");
INSERT INTO lth_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yecu ömëdërë më kobo nï, “Gin na yaa kï ï dhanö ënë balö ën. ");
INSERT INTO lth_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Pïën gin n'öya kï ï dhanö, n'öya kï ï cwinye ënë thama na reco, tïm më ölyang, kwalö kwo, nek, ");
INSERT INTO lth_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","elomi, woro më jami kïbëc, tïm mökö na reco, bwölö jïï, miti më kom, nyeko, yanyö jïï, awaka, ëka mingo. ");
INSERT INTO lth_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tïm na reco ni kïbëc yaa kï ï cwiny dhanö, ëka gïn ënë balö dhanö.” ");
INSERT INTO lth_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yecu öya ökö kï kunön ëka öcïdhö ï lobo Turo. Ën ödönyö ï öt mörö ëka ba ömïtö nï ngat mörö onge, ëntö ën onwongo ba twërö kanërë. ");
INSERT INTO lth_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Cë dhakö mörö na nyarë onwongo tye kï tipo na rac ï kome, owinyo köp ï kom Yecu, cë obino ëka orumo cöngë ï nyime. ");
INSERT INTO lth_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Dhakö ni onwongo obedo jö Girik n'ënywölö ï Curopoiniki. Ën ökwaö Yecu më ryëmö tipo na rac ökö kï kom nyarë. ");
INSERT INTO lth_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yecu okobo nïnë nï, “Ëk kono ëthïnö öcam ngö na gïn mïtö kïbëc, pïën ba opore më mïö cem k'ëthïnö both gwongi.” ");
INSERT INTO lth_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Dhakö ögamö nï, “Rwoth ikobo adyer, ëntö gwongi thon na tye ï thë mëja camö gïnï ngïny cem k'ëthïnö n'opodho pïny.” ");
INSERT INTO lth_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Cë Yecu okobo nïnë nï, “Pï köp na in ikobo, ïrömö cïdhö yo pacö, pïën tipo na rac dong öya ökö kï kom nyari.” ");
INSERT INTO lth_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ën öcïdhö yo pacö ëka onwongo nyarë obuto ï wi ëtana, ëka tipo na rac onwongo dong öya ökö kï ï kome. ");
INSERT INTO lth_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Cë Yecu öya ökö kï ï lobo Turo ëka owok ï Cidon yo Nam më Galilaya na tye ï lobo Dekapoli. ");
INSERT INTO lth_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ëka lwak okelo ëcwö mörö bothe n'onwongo ithe öthöö ëka ba römö twak. Cë ökwaö gïnï Yecu ëk oketh cïngë ï kome. ");
INSERT INTO lth_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kinge na Yecu otero ën thenge kï kin lwak, oketho nyi cïngë ï ithe, ëka öngülö laö dhögë ï cïngë cë ogudo lëbë. ");
INSERT INTO lth_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yecu önënö malö ï wi polo, öcür ëka okobo nï, “Epata,” na tyën köp mërë nï, “Yabiri!” ");
INSERT INTO lth_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Cücüth ëcwö ni öcakö winyo pïny. Thë lëbë thon ögöny ökö ëka öcakö twak na bër. ");
INSERT INTO lth_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yecu öcïkö lwak nï, “Kür ïcïdh ikob unu both ngat mörö ngö n'ötïmërë.” Ëntö kadï bed öcïkögï nï kömanön, gïn ömëdërë amëda më tïtö ngö n'ötïmërë. ");
INSERT INTO lth_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Lwak obedo kï ur rwök na kobo gïnï nï, “Gin na kïbëc na ën ötïmö bër. Ën thon mïö ëthöö ith winyo pïny ëka jö na thë lëbgï otwere më twak.” ");
INSERT INTO lth_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ï karë nonu, lwak na pol dökï ögürë ëka cem onwongo ope nïgï. Yecu ocwodo ëlübkörë bothe ëka okobo nïgï nï, ");
INSERT INTO lth_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Lwak othona gïnï rwök pïën orio gïnï köda nïnö adek na gin mörö më acama ope. ");
INSERT INTO lth_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ka aorogï pacö na ba öcamö gïnï gin mörö, kec bino mïögï wile ï yoo pïën jö mökö kï kin-gï öya kï kanya bor.” ");
INSERT INTO lth_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ëka ëlübkörë ögamö nï, “Kara wan ëtwërö nwongo cem na römö pïdhö lwak jö ni kï kwene na kany obedo thim?” ");
INSERT INTO lth_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yecu openyogï nï, “Ogati adi na un itye ködë?” Gïn ögamö nï, “Ogati abïrö.” ");
INSERT INTO lth_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Cë Yecu okobo nï lwak ëk obed gïnï pïny. Ën ökwanyö ogati abïrö, öpwöyö Obanga ëka opokogï, cë ömïö both ëlübkörë ëk opok gïnï both lwak. ");
INSERT INTO lth_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Gïn thon onwongo tye gïnï kï rëc arïö na thïthïnö. Yecu öpwöyö Obanga ëka okobo n'ëlübkörë ëk opokgï. ");
INSERT INTO lth_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jö kïbëc ocemo naka oyeng gïnï. Ëka kinge cem, ëlübkör Yecu öcökö gïnï ngïny cem n'ötütüra pong aditi abïrö. ");
INSERT INTO lth_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jö n'onwongo tye kunön onwongo römö elip angwën. Cë Yecu okobo nï lwak ëk ödök gïnï pacö kinge cem. ");
INSERT INTO lth_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Cücüth, Yecu ödönyö ï yeya k'ëlübkörë ëka öcïdhö yo lobo Dalmanutha. ");
INSERT INTO lth_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ï karë n'Eparicayo mökö owinyo gïnï nï Yecu othuno, gïn obino ëka openyo gïnï Yecu anyuth n'öya kï ï polo më tëmö ën. ");
INSERT INTO lth_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ï karë na Yecu owinyo köp ni, öcür rwök kï ï cwinye ëka okobo nï, “Pïngö jö më karë ni mïtö gïnï anyuth më tango? An akobo niwu köp adyer, ba abino nyutho nï jö më karë ni koth anyuth mörö këkën.” ");
INSERT INTO lth_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Cë Yecu öya ökö kï bothgï, ödönyö ï yeya, ëka öngölö ï nam yo löka tung ca. ");
INSERT INTO lth_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ëlübkör Yecu onwongo wigï owil ökö më makö ogati ï wothgï. Gïn onwongo ömakö ogati acël këkën ï yeya. ");
INSERT INTO lth_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Cë Yecu öcïkögï nï, “Myero ïgwökërë unu kï kom thöbï k'Eparicayo ëka më k'Erode.” ");
INSERT INTO lth_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Gïn öcakö twak ï kin-gï kën-gï nï, “Ën tye ka kobo köp ni pïën onu ba ëmakö ogati mörö.” ");
INSERT INTO lth_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yecu ongeo ngö n'onwongo gïn tye ka twakö cë openyogï nï, “Pïngö itye unu ka twak nï ba ïmakö unu ogati mörö? Un pod bara ïnënö onyo ïnïang unu? Cwinywu pod nwang? ");
INSERT INTO lth_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","‘Itye unu kï wangwu cë ba ineno unu. Itye unu kï ithwu cë ba iwinyo unu pïny.’ Ba ïtwërö unu po ï kom gin mörö këkën? ");
INSERT INTO lth_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ï karë na an apïdhö jö elip abic k'ogati abic, aditi adi më ngïnyë n'odong na un ïcökö?” Ëlübkör Yecu ögamö nï, “Apar arïö.” ");
INSERT INTO lth_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ëka ï karë na an apïdhö jö elip angwën k'ogati abïrö, aditi adi më ngïnyë na un ïcökö?” Cë gïn ögamö nï, “Abïrö.” ");
INSERT INTO lth_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ëka Yecu openyogï nï, “Un pod bara ïnïang?” ");
INSERT INTO lth_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ï karë n'othuno gïnï ï Bethecaida, jö mörö okelo athöö wang both Yecu, cë gïn ökwaö ën më gudo athöö wang. ");
INSERT INTO lth_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ëka Yecu ömakö cïng athöö wang cë öpëö yökö ï ngee pacö. Cë öngülö laö dhögë ï wangë, oketho cïngë ï kome ëka openyo nï, “Itye ka nënö gin mörö?” ");
INSERT INTO lth_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ëcwö ni önënö malö cë okobo nï, “Eyo, atye ka nënö jïï, ëntö gïn tye ka nen kamë yen na tye ka woth.” ");
INSERT INTO lth_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Cë Yecu dökï ogudo wang ëcwö ni ëka wangë öyabërë cë öcakö nënö jami kïbëc na bër. ");
INSERT INTO lth_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yecu okobo nïnë ëk öcïdh yo pacö thurgï nakun cïkö nï, “Kür ïcïdh ikob nï ngat mörö kï ï pacö.” ");
INSERT INTO lth_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yecu ëka ëlübkörë öya gïnï kï ï Galilaya ëka öcïdhö gïnï ï peci na cwök kï Cecaria Pilipi. Na gïn onwongo tye ï woth, ën openyogï nï, “Jïï mönö kobo nï an abedo nga?” ");
INSERT INTO lth_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Gïn ögamö nï, “Jö mökö kobo nï in Jon Abatica, mökö kobo nï in Eliya, ëka jö nökënë kobo nï in ibedo ngat acël ï kin edwarpïny.” ");
INSERT INTO lth_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Cë Yecu openyogï nï, “Ëntö un kono, ikobo nï an abedo nga?” Petero ögamö nï, “In ibedo Meciya.” ");
INSERT INTO lth_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ëntö Yecu öcïkögï nï kür okob gïnï nï ngat mörö köp ï kome. ");
INSERT INTO lth_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Cë Yecu öcakö pwonyogï nï Wod ka Dhanö myero ölïm can na pol ëka edite, ëlamdhök na dito, ëka epwony cïk bino kwërö ën ökö. Ebino neko ën, ëntö kinge nïnö adek ën bino cer kï ï lyël. ");
INSERT INTO lth_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yecu ötwakö köp ni kanyalër both ëlübkörë. Ëka Petero ökwanyö ën thenge cë öcakö coko Yecu pï kobo koth köp ni. ");
INSERT INTO lth_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ëntö Yecu öwïrë ëka önënö ëlübkörë, cë ocoko Petero na kobo nï, “Dök ï ngea, Catan! Pïën thamani ba lübö më k'Obanga ëntö më ka dhanö.” ");
INSERT INTO lth_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cë Yecu ocwodo lwak ëka ëlübkörë bothe cë okobo nï, “Ka ngat mörö mïtö bedo alübköra, myero ën kono öcak kwërë kënë, oting yath arïa mërë, ëka ölüb köra. ");
INSERT INTO lth_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ka ngat mörö mïtö larö kwö mërë, bino rwenyo kwö mërë ökö. Ëntö ka ngat na rwenyo kwö mërë pïra ëka pï köp më Emuth na Bër, bino larö kwö mërë. ");
INSERT INTO lth_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ëka ngö na in ibino nwongo ka itye kï jami më lobo ni kïbëc, ëntö irwenyo tiponi ökö? ");
INSERT INTO lth_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Onyo ngö na dhanö twërö mïö më lökö kï kwö mërë? ");
INSERT INTO lth_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ka ngat mörö lewic makö ï koma ëka kï köpna ï karë ni na ba ëwörö Obanga ïë ëka më bal, Wod ka Dhanö thon lewic bino makö ï kom dhanö nön ï karë na ën bino dwogo ködë kï dheo k'Apap mërë ëka më k'emalaika na leng.” ");
INSERT INTO lth_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ëka Yecu okobo bothgï nï, “An akobo niwu köp adyer nï tye jö mökö n'ocung kany na ba bino bïlö gïnï thöö naka ka wang n'önënö gïnï ker k'Obanga ka bino kï tëkö.” ");
INSERT INTO lth_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kinge nïnö abicël, Yecu ökwanyö Petero, Yakobo, ëka Jon cë öïdhö ködgï ï wi kidi na bor, kanya onwongo gïn tye ïë kën-gï. Na gïn tye ka nënö, kom Yecu ölökërë na path ï nyimgï, ");
INSERT INTO lth_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ëka böng mërë ödökö na tar na ryëny rwök na ngat mörö kï wi lobo ba römö lwökö nï kömanön. ");
INSERT INTO lth_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Cë Eliya ëka Muca onen bothgï ëka öcakö gïnï twak kï Yecu. ");
INSERT INTO lth_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petero okobo both Yecu nï, “Apwony, bër nï onu më bedo kany! Ëk ëgër othogo adek, acël na megi, acël më ka Muca, ëka acël më k'Eliya.” ");
INSERT INTO lth_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petero onwongo ba ngeo ngö na myero ekobi pïën lworo onwongo ömakögï rwök. ");
INSERT INTO lth_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Cë edou obino oumogï ökö, ëka dwön ötwak kï ï edou nï, “Man ënë Woda më amara. Winy unu ën.” ");
INSERT INTO lth_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Athura, ï karë na gïn önënö ngetgï, gïn ba dökï önënö ngat mörö na path kï Yecu këkën. ");
INSERT INTO lth_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na gïn tye ka idho pïny kï wi kidi, Yecu öcïkögï nï kür okob gïnï nï ngat mörö ngö na gïn önënö, naka wang ka Wod ka Dhanö ocer kï ï thöö. ");
INSERT INTO lth_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Gïn ba okobo ngö n'ötïmërë both ngat mörö, ëntö obedo penyere gïnï ï kin-gï kën-gï nï, “Ngö na ‘cer kï ï thöö’ gönyö?” ");
INSERT INTO lth_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Cë gïn openyo Yecu nï, “Pïngö epwony cïk ka Muca kobo gïnï nï Eliya myero kono öcak bino?” ");
INSERT INTO lth_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yecu ögamö nïgï nï, “Adyer Eliya ënë cakö bino ëka dwökö jami kïbëc kakarë. Cë pïngö Cöc na Leng kobo nï Wod ka Dhanö bino lïmö can rwök ëka ebino kwërö ökö? ");
INSERT INTO lth_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ëntö akobo niwu nï, Eliya dong obino ökö ëka jïï ötïmö gin na kïbëc na gïn mïtö ï kome, kite na Cöc na Leng kobo nï bino tïmërë ködë.” ");
INSERT INTO lth_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ï karë na Yecu k'ëlübkörë adek odwogo gïnï yo kanya ëlübkörë nökënë onwongo ute gïnï ïë, gïn önënö lwak na pol n'ögürögï dyere ëka epwony cïk ka Muca onwongo tye ka pyem ködgï. ");
INSERT INTO lth_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na lwak kïbëc önënö Yecu, ouro gïnï rwök ëka örïngö gïnï më motho ën. ");
INSERT INTO lth_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yecu openyo ëlübkörë nï, “Ngö na un itye ka pyem ködgï ïë?” ");
INSERT INTO lth_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dhanö mörö acël kï kin lwak ögamö nï, “Apwony, akelo woda bothi, pïën ën ute kï tipo na rac na ba yeo nï ën ötwakï. ");
INSERT INTO lth_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ëka ka tipo na rac ömakö, rëdhö ën pïny na kome myël amyëla. Cë bwo yenyo kï ï dhögë, kaö lakë na tëk ëka kome jïng ökö. Akwaö ëlübkori më ryëmö tipo na rac, ëntö ryëmö ölöögï ökö.” ");
INSERT INTO lth_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yecu okobo nïgï nï, “Un wang rok na yeewu ope ï kom Obanga! Abino bedo kodwu naka awene? Abino dïö cwinya ï komwu naka awene kara? Kel unu awobi nön botha.” ");
INSERT INTO lth_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Cë gïn okelo awobi ni bothe. Ëntö ï karë na tipo na rac önënö Yecu, oyuo awobi ni pïny cüth naka örakërë na lör alöra nakun bwo yenyo kï ï dhögë. ");
INSERT INTO lth_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yecu openyo apap k'awobi nï, “Otero karë na röm kwene na gin ni obedo ka tïmërë bothe?” Ën ögamö nï, “Anaka na ën pod tïdï. ");
INSERT INTO lth_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tipo na rac rëdhö ën karë kï karë ï mac onyo ï pii, më tëmö neko ën ökö. Ëntö ka ïtwërö tïmö gin mörö, kïca omaki ï komwa ëk ïkönywa.” ");
INSERT INTO lth_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yecu okobo n'apap k'awobi nï, “Ka in ïtwërö! Jami kïbëc twërö tïmërë both ngat mörö këkën na yee.” ");
INSERT INTO lth_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Cücüth apap k'awobi okok kï redo nï, “An ayee, ëntö könya ëk abed kï yee na thwönë!” ");
INSERT INTO lth_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ï karë na Yecu önënö nï lwak tye ka ngwëc bino yo bothe, ën ocoko tipo na rac nï, “In tipo na ba mïö awobi ni twak ëka winyo pïny, aciki më donyo yökö kï ï kom awobi ni ëka kür dökï ïdöny ï kome!” ");
INSERT INTO lth_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Cë tipo na rac öcakö koko, ëka oyuo awobi ni pïny naka örakërë ëka odonyo yökö kï ï kome. Awobi ni onwongo dong cal kï lyël na jö na pol okobo nï, “Ën öthöö ökö.” ");
INSERT INTO lth_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ëntö Yecu ömakö cïngë ëka otingo ën malö cë ocung. ");
INSERT INTO lth_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kinge na Yecu onwongo tye kënë ï öt k'ëlübkörë, gïn openyo ën nï, “Pïngö wan ba ëryëmö cen?” ");
INSERT INTO lth_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yecu ögamö nïgï nï, “Koth tipo na rac na calö man, ëtwërö ryëmö kï lëga këkën.” ");
INSERT INTO lth_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yecu ëka ëlübkörë öya gïnï kï ï kabedo nön ëka owok gïnï ï lobo më Galilaya. Ën onwongo ba mïtö nï ngat mörö onge kanya gïn onwongo tye ïë, ");
INSERT INTO lth_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","pïën onwongo mïtö pwonyo ëlübkörë. Yecu okobo bothgï nï, “Wod ka Dhanö ebino ketho örörö ï kome ëka ebino mïö ï cïng jö na bino neko ën. Ëntö kinge nïnö adek, ën bino cer kï ï thöö.” ");
INSERT INTO lth_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ëntö ëlübkör Yecu ba önïang gïnï ï ngö n'onwongo ën tye ka kobo, ëka gïn onwongo lwor më penyo ën. ");
INSERT INTO lth_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kinge na dong othuno gïnï ï Kaperanaum, na gïn dong tye ï öt, Yecu openyo ëlübkörë nï, “Ngö n'onwongo un itye ka pyem ïë ï yoo?” ");
INSERT INTO lth_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ëntö gïn ölïng alïnga, pïën gïn onwongo tye ka pyem ï wanga yoo nï nga ënë löö kï dit kï kin-gï. ");
INSERT INTO lth_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yecu obedo pïny, cë ocwodo ëlübkörë apar arïö bothe, ëka okobo nï, “Ka ngat mörö mïtö bedo dhanö më acël, ën myero obed dhanö më ajiki ëka obed atic ka jö kïbëc.” ");
INSERT INTO lth_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Cë Yecu ökwanyö athïn ëka oketho ï dyeregï. Otingo athïn ï kore, ëka okobo nïgï nï, ");
INSERT INTO lth_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Dhanö mörö na bino gamö athïn na tïdï na cal kï man kï nyïnga, nwongo ögama. Ëka dhanö mörö na gama, nwongo ba ögama an këkën ëntö nwongo ögamö Apapna n'oora.” ");
INSERT INTO lth_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon okobo both Yecu nï, “Apwony, wan ënënö dhanö mörö ryëmö cene kï nyingi, ëntö wan ëjükö ën pïën onwongo ën ba tye kukur onu.” ");
INSERT INTO lth_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yecu okobo nïgï nï, “Kür ijuku ën, pïën dhanö mörö ope na tio tango kï nyïnga ëka dökï cakö twakö köp na rac ï koma. ");
INSERT INTO lth_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ngat mörö këkën na ba dag onu, nwongo obedo akukur onu. ");
INSERT INTO lth_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ka ngat mörö ömïöwu pii më amodha pïën un ibedo jö ka Kiricito, an akobo niwu köp adyer, dhanö nön ebino cülö. ");
INSERT INTO lth_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ka dhanö mörö ömïö ngat acël kï kin ëthïnö ni n'oye ï koma opodho ï bal, bedo na bër ka etweo pong rego na thwönë ï ngute cë ebolo ködë ï nam. ");
INSERT INTO lth_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Cë ka cingi ënë mii ïtïmö bal, ngun ökö. Bedo na bër rwök më dönyö ï kwö kï cingi acël këkën na löö më dönyö ï mac na ba thöö ï kapïny kï cingi arïö. ");
INSERT INTO lth_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kunön, kudi na camögï ba thöö, ëka mac na wangögï ba nekere. ");
INSERT INTO lth_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ka tyeni ënë teri ï bal, ngun ökö. Bedo na bër rwök më dönyö ï kwö kï tyeni acël na löö më boloni ï mac kapïny kï tyeni arïö. ");
INSERT INTO lth_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kanya kudigï ba thöö kï ïë ëka mac thon ba nekere. ");
INSERT INTO lth_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ëka ka wangi ënë mii ïtïmö bal, köl ökö. Bedo na bër rwök më dönyö ï Ker k'Obanga kï wangi acël këkën na löö më bedo kï wangi arïö cë eboli ködë ï mac kapïny. ");
INSERT INTO lth_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kanya “ ‘kudigï ba thöö kï ïë ëka mac thon ba thöö.’ ");
INSERT INTO lth_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Pïën kadö na bino lönyö ngat acëlacël ënë mac. ");
INSERT INTO lth_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kadö bër, ëntö ka orwenyo mït mërë ökö, ïtwërö mïö dökö na mït nïngö dökï? Un myero ibed unu kï rwöm më kadö ï kinwu ëka ibed unu kï kuc kï jö nökënë.” ");
INSERT INTO lth_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Cë Yecu öya öwëkö Kaperanaum ëka öcïdhö yo kupïny ï lobo Yudea ëka yo löka kulo Jordan. Lwak jö na pol obino dökï bothe, ëka na calö kite n'önaa tïmö ködë, ën opwonyogï. ");
INSERT INTO lth_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Eparicayo mökö obino bothe ëka ötëmö gïnï ën nakun epenyo nï, “Cïk yeo nï ëk ëcwö ökwër dhakö mërë?” ");
INSERT INTO lth_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yecu ögamö nakun penyogï nï, “Ngö na cïk ka Muca kobo?” ");
INSERT INTO lth_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Gïn ögamö nï, “Muca ömïö twër both ëcwö më cöönö waraga më kwër ëka öryëm ën ökö.” ");
INSERT INTO lth_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yecu okobo nïgï nï, “Muca ömïöwu cïk nön pï nwang cwinywu. ");
INSERT INTO lth_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ëntö cakërë ï acaki ketho lobo ‘Obanga ocweo ëcwö ëka dhakö.’ ");
INSERT INTO lth_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Pï tyën köp ni ëcwö bino wëkö apap mërë ëka aya mërë, cë rïbërë kï dhakö mërë, ");
INSERT INTO lth_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ëka gïn arïö bino dökö kom acël.’ Cë gïn ba dök bedo jö arïö, ëntö kom acël. ");
INSERT INTO lth_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pï manön, gin n'Obanga örïbö kanya acël, dhanö mörö kür opok kin-gï.” ");
INSERT INTO lth_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ï karë na gïn onwongo tye ï öt dökï, ëlübkör Yecu openyo ën ï kom köp na ën okobo. ");
INSERT INTO lth_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yecu okobo nïgï nï, “Ka dhanö mörö ökwërö dhakö mërë, cë önyömö dhakö nökënë dökï, nwongo ën ödönyö ï elomi. ");
INSERT INTO lth_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ëka ka dhakö ökwërö cwörë cë önyömërë k'ëcwö nökënë dökï, nwongo ën thon ödönyö ï elomi.” ");
INSERT INTO lth_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ï nïnö mörö acël jö mökö okelo ëthïnö both Yecu ëk ogudgï, ëntö ëlübkörë ocokogï. ");
INSERT INTO lth_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ï karë na Yecu önënö, öngöö rwök. Ën okobo nïgï nï, “Wëk unu ëthïnö obin botha ëka kür ijukugï pïën ker k'Obanga tye pï jö na calö man. ");
INSERT INTO lth_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","An akobo niwu köp adyer nï dhanö na ba bino gamö ker k'Obanga na calö athïn, ba bino dönyö ïë.” ");
INSERT INTO lth_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Cë Yecu otingo ëthïnö ï kore ëka oketho cïngë ï wigï cë ölëgö gum ï komgï. ");
INSERT INTO lth_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ï karë na Yecu öcakö woth mërë ï yoo, ëcwö mörö örïngö ï körë, cë orumo cöngë pïny ï nyime, ëka openyo nï, “Apwony na bër, atïm ngö ëk anwong kwö na bedo naka?” ");
INSERT INTO lth_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yecu ögamö nïnë nï, “Pïngö in icwoda nï abër? Ngat mörö ope na bër, na path k'Obanga këkën. ");
INSERT INTO lth_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","In ingeo cïk nï: ‘Kür ineki, kür ïdöny ï elomi, kür ïkwal, kür ibed acaden më twodo, kür ïbür dhanö mörö, wör apapni ëka ayani.’ ” ");
INSERT INTO lth_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ëcwö ni öcakö gamö nï, “Apwony, atyeko gwökö cïk nön kïbëc cakërë ï wang thinona.” ");
INSERT INTO lth_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yecu önënö ëcwö ni, cë ömarö ën, ëka okobo nïnë nï, “Gin mörö acël ënë pod orem kï bothi. Apë ëk ïcïdh ïcadh jamini na in iute ködë kïbëc ëka ïmïï lïm mërë both ëcan, ëka ibino bedo kï lönyö na thwönë ï wi polo. Cë ibin, ïlüb köra.” ");
INSERT INTO lth_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ï karë n'ëcwö ni owinyo Yecu ka ötwak nï kömanön, wangë öcakö lökërë ökö, cë ödök cen kï cwer cwiny, pïën ën onwongo tye kï lönyö na thwönë rwök. ");
INSERT INTO lth_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yecu öwïrë cë önënö ëlübkörë ëka okobo nïgï nï, “Bino bedo na tëk both ëlönyö më dönyö ï ker k'Obanga!” ");
INSERT INTO lth_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ëlübkör Yecu obedo kï ur rwök ï köp mërë. Ëntö Yecu okobo dökï nï, “Ëthïnöna, bino bedo na tëk nïngö më dönyö ï ker k'Obanga! ");
INSERT INTO lth_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bedo na yot pï kïnaga më dönyö kï wang libira nï löönö pï alönyö më dönyö ï ker k'Obanga.” ");
INSERT INTO lth_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ëlübkör Yecu dök ouro rwök ëka ötwak ï kin-gï kën-gï nï, “Cë nga na dong twërö larë?” ");
INSERT INTO lth_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yecu önënögï cë okobo nï, “Kï both dhanö, ba twërë, ëntö kï both Obanga, jami kïbëc twërë.” ");
INSERT INTO lth_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petero okobo both Yecu nï, “Wan ëwëkö jami kïbëc më lübö kori.” ");
INSERT INTO lth_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yecu ögamö nï, “An akobo niwu köp adyer nï ngat mörö ope n'öwëkö pacö mërë, onyo utmego mërë onyo aya mërë onyo apap mërë onyo ëthïnö mërë onyo pwothi mërë pïra ëka pï köp më Emuth na Bër, ");
INSERT INTO lth_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","na ën ba bino nwongo jami na kadhö manön wang mia acël ï karë ni, udi, utmego, ayagï, ëthïnögï, ëka jamigï kanya acël k'ayela. Ï karë më ajiki dhanö nön bino nwongo kwö na bedo naka. ");
INSERT INTO lth_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ëntö jö na pol na kobedini obedo më acaki bino gïnï dong cen, ëka jö n'odong cen bino tëlö anyim.” ");
INSERT INTO lth_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ï karë na gïn tye ka cïdhö yo Jerucalem, nakun Yecu ënë ötëlö anyim, ëlübkörë ouro rwök ëka jö n'onwongo lübö körë obedo gïnï kï lworo. Ën dökï otero ëlübkörë apar arïö kï thenge ëka okobo bothgï ngö na bino tïmërë ï kome. ");
INSERT INTO lth_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yecu okobo bothgï nï, “Onu ëcïdhö naka yo Jerucalem, ëka Wod ka Dhanö ebino ketho örörö ï kome both ëlamdhök na dito ëka epwony cïk ka Muca. Gïn bino ngölö thöö ï wie ëka ebino mïö ën ï cïng Erok, ");
INSERT INTO lth_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","na bino gïnï nywarö ën ëka ngülö laö dhögï ï kome, pwodo kï del ëka eneko ën ökö. Kinge nïnö adek, ën bino cer.” ");
INSERT INTO lth_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobo ëka Jon, awope ka Jebedayo, obino gïnï both Yecu ëka okobo nïnë nï, “Apwony, wan ëmïtö nï ïtïm nïwa gin mörö këkën na wan ebino penyoni.” ");
INSERT INTO lth_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yecu openyogï nï, “Ngö na un ïmïtö nï an atïm niwu?” ");
INSERT INTO lth_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Gïn ögamö nï, “Wëk ngat acël kï kinwa obed ï nget cingi kucem ëka ngat nökënë obed ï nget cingi kucam ka in ibino bedo ï then ker më dheoni.” ");
INSERT INTO lth_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ëntö Yecu okobo nïgï nï, “Un ba ingeo ngö na un ipenyo. Un ïtwërö modho k'ekopo më can na an amodho ködë, onyo ïtwërö unu batica kï koth batica më can na an abino batica ködë?” ");
INSERT INTO lth_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Gïn ögamö nï, “Wan ëtwërö.” Yecu okobo nïgï nï, “Okopo na an abino modho ködë, un thon ibino modho ködë ëka kit batica n'ebino batica an ködë, un thon ebino baticawu ködë. ");
INSERT INTO lth_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ëntö köp më bedo ï nget cïnga kucem onyo kucam, pathï an ënë amïö. Obanga ënë bino mïö kabedo nön both jö na ën öyërö.” ");
INSERT INTO lth_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ï karë n'ëlübkör Yecu apar owinyo köp ni, cwinygï öwang ï kom Yakobo ëka Jon. ");
INSERT INTO lth_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Cë Yecu ocwodogï kïbëc bothe ëka okobo nïgï nï, “Un ingeo unu nï jö n'engeogï kamë ëlöc k'Erok, löögï kï twërö ëka editegï na malö thon bedo kï twër ï komgï. ");
INSERT INTO lth_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Un kür ibed unu nï kömanön, ëntö ngat na mïtö bedo adit kï kinwu, myero obed aticwu. ");
INSERT INTO lth_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ëka ngat na mïtö bedo dhanö më acël, myero obed opii ka jö kïbëc. ");
INSERT INTO lth_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Naka thon Wod ka Dhanö ba obino nï ëk etii nïnë ëntö më tic pï jïï ëka më mïö kwö mërë më kökö jö na pol.” ");
INSERT INTO lth_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yecu kanya acël k'ëlübkörë obino gïnï ï Jeriko. Ï caa na gïn dong onwongo yaa më wëkö Jeriko, lwak na pol ölübö körgï. Ëcwö na wangë öthöö, na nyïngë Batulumayo (wod ka Timayo) onwongo obedo ï nget yoo kwaö kwac. ");
INSERT INTO lth_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ï karë na ën owinyo nï Yecu më Najaret ënë tye ka wok, ën öcakö redo na kobo nï, “Yecu, Wod ka Daudi, kïca omaki ï koma!” ");
INSERT INTO lth_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jö na pol ocoko ën nï ëk ölïng ökö, ëntö ën ömëdërë kï redo rwök, “Wod ka Daudi kïca omaki ï koma!” ");
INSERT INTO lth_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yecu ocung ëka okobo nï, “Cwod unu ën obin.” Cë gïn dong ocwodo athöö wang na kobo gïnï nïnë nï, “Dïï cwinyi! Yaa malö! Ën tye ka cwodoni.” ");
INSERT INTO lth_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Athöö wang obolo böng mërë thenge, opye kï tyënë ëka obino both Yecu. ");
INSERT INTO lth_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yecu openyo ën nï, “Ngö na in ïmïtö nï atïm nini?” Athöö wang okobo nï, “Apwony, amïtö wanga önën pïny.” ");
INSERT INTO lth_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yecu okobo nïnë nï, “Apë cïdhï, yeeni ocangi ökö.” Cücüth wangë önënö pïny ëka öcakö lübö kör Yecu. ");
INSERT INTO lth_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ï karë na Yecu k'ëlübkörë dong cwök thuno ï Jerucalem, gïn obino ï Betepage ëka Betania na cwök kï tyën Kidi më Jeituni. Ën ooro ëlübkörë arïö, ");
INSERT INTO lth_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ëka okobo nïgï nï, “Apë unu ï pacö na tye ï nyimwu, ëka cücüth na un ïdönyö ïë, ibino nwongo unu athïn kana n'etweo kunön, na ngat mörö bara öïdhö ï wie anaka yam. Göny unu ëka ikel unu kany. ");
INSERT INTO lth_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ka ngat mörö openyowu nï, ‘Pïngö ïgönyö unu kana nön?’ Kob unu nïnë nï, ‘Rwoth ënë mïtö ëka ebino dwongo ökö pïöpïö.’ ” ");
INSERT INTO lth_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ëlübkör Yecu arïö ni öcïdhö, ëka onwongo gïnï athïn kana n'etweo yökö ï nget yoo ï dhö wangkac, cë ögönyö gïnï. ");
INSERT INTO lth_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jö mökö n'onwongo ocung kunön openyogï nï, “Ngö na un itye ka tïmö, nakun ïgönyö unu athïn kana nön?” ");
INSERT INTO lth_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Gïn ögamö kite na Yecu onwongo okobo nïgï ködë, ëka eyeo nïgï më tero. ");
INSERT INTO lth_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Cë gïn dong okelo athïn kana both Yecu ëka öpëdhö gïnï böng-gï ï dye ngee, ëka ën obedo ïë. ");
INSERT INTO lth_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jö na pol öpëdhö böng-gï ï dye yoo, nakun jö nökënë pëdhö jang yen na gïn ötürö kï ï pwothi. ");
INSERT INTO lth_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jö n'ötëlö anyim ëka jö n'ölübö körë oredo gïnï kï wöö nï, “Ocana!” “Gum obed ï kom ngat na tye ka bino kï nyïng Rwoth!” ");
INSERT INTO lth_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Gum obed ï kom ker ka kwarö onu Daudi na tye ka bino!” “Ocana na tye malö ï wi polo!” ");
INSERT INTO lth_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yecu ödönyö ï Jerucalem ëka öcïdhö ï dyekal öt k'Obanga. Ën önënö jami kïbëc, ëntö kite n'onwongo pïny dong cwök cido, ën öcïdhö ï Betania kanya acël k'ëlübkörë apar arïö. ");
INSERT INTO lth_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kodiko mërë na gïn tye ka yaa wëkö Betania, kec onwongo oneko Yecu. ");
INSERT INTO lth_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ën önënö yath ölam kï cecen na pote oluk, Yecu öcïdhö më nënö ka ëtwërö nwongo nyige mörö. Ï karë na ën othuno ï thë yath, ën ba onwongo gin mörö ëntö pote këkën, pïën karë nön ba obedo karë n'ölam nyak ïë. ");
INSERT INTO lth_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Cë Yecu okobo nï yath nï, “Ngat mörö myero kür dökï öcam nyigi.” Ëka ëlübkörë owinyo ën ka kobo. ");
INSERT INTO lth_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ï karë na gïn othuno ï Jerucalem, Yecu ödönyö ï dyekal öt k'Obanga ëka öcakö ryëmö jö n'onwongo tye ka cadhö jami ëka ëwïl. Ën ölökö mëja ka jö na lökö cïlïng atarö ëka thene ka jö na cadhö amam. ");
INSERT INTO lth_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yecu ba oyeo nï ngat mörö öngöl dyekal öt k'Obanga kï jami mörö më acadha. ");
INSERT INTO lth_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ën okobo nïgï nï, “Cöc na Leng kobo kanya aleng nï, “‘Öda ebino cwodo nï öt më lëga pï lobo kïbëc.’ Ëntö un ïlökö ödökö kabedo n'ëyak pono ïë.” ");
INSERT INTO lth_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ï karë n'ëlamdhök na dito ëka epwony cïk ka Muca owinyo gïnï ngö na Yecu ötwakö, gïn öcakö rangö kit yoo mörö na myero enek kï Yecu ködë. Gïn onwongo tye kï lworo ï kome, pïën lwak onwongo uro pwony mërë. ");
INSERT INTO lth_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na pïny dong cido, Yecu ëka ëlübkörë öya gïnï ökö kï ï Jerucalem. ");
INSERT INTO lth_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kodiko mërë na gïn tye ka wok ï nget yath ölam na Yecu ölamö, ëlübkör Yecu önënö yath ölam na dong ötal ökö anaka kï orii naka malö. ");
INSERT INTO lth_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Wi Petero opo ëka öcakö kobo nï Yecu nï, “Apwony, nën! Yath ölam na in ïlamö ötal ökö!” ");
INSERT INTO lth_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yecu ögamö nï, “Bed unu kï yee ï kom Obanga. ");
INSERT INTO lth_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","An akobo niwu köp adyer, ka ngat mörö okobo nï kidi nï, ‘Mukiri, ëk ipodh ï nam,’ ëka ka ba obedo k'akalakala ï cwinye ëntö yee nï ngö na ën ebino kobo bino tïmërë, ebino tïmö nïnë. ");
INSERT INTO lth_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pï manön akobo niwu, gin mörö këkën na un ibino kwaö kï lëga, bed unu kï yee nï ityeko unu nwongo, ëka bino bedo mewu. ");
INSERT INTO lth_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ëntö ka un itye ka lëga, më acël tïm kïca both ngat mörö këkën na köp mörö tye ï kinwu ködë, ëk Apapwu na tye malö ï wi polo thon ötïm niwu kïca ï kom balwu.” ");
INSERT INTO lth_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“Ëntö ka ba ïtïmö unu nï dhanö kïca, cë Apapwu na tye malö ï wi polo thon ba bino tïmö kïca niwu ï kom balwu.” ");
INSERT INTO lth_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yecu ëka ëlübkörë dökï odwogo gïnï ï Jerucalem. Na Yecu onwongo tye ka woth ï dyekal öt k'Obanga, ëlamdhök na dito, epwony cïk ka Muca, ëka edite obino gïnï bothe. ");
INSERT INTO lth_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Gïn openyo Yecu nï, “Koth twër mënë n'ömïö in ïtïmö jami ni kïbëc? Nga n'omii twërö më tïmögï?” ");
INSERT INTO lth_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yecu ögamö nïgï nï, “An abino penyowu peny acël. Gam unu nïna, ëka an abino kobo niwu koth twërö na an atye ka tïmö kï jami ni. ");
INSERT INTO lth_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Twërö ka Jon më batica öya kï ï polo onyo kï both dhanö? Gam unu nïna!” ");
INSERT INTO lth_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Gïn öcakö larö köp nön ï kin-gï kën-gï ëka okobo gïnï nï, “Ka onu ekobo nï öya kï ï polo, ën bino penyo nï, ‘Pïngö ba iyee unu ï kom Jon?’ ");
INSERT INTO lth_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ëntö ka onu ekobo nï, ‘Öya kï both dhanö—’” (Gïn onwongo lworo lwak, pïën jö kïbëc ngeo gïnï nï Jon adyer onwongo obedo adwarpïny.) ");
INSERT INTO lth_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Cë gïn dong ögamö nï Yecu nï, “Wan ba engeo.” Yecu okobo nïgï nï, “An thon ba abino kobo niwu koth twër mënë n'ömïö an atio jami ni.” ");
INSERT INTO lth_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Cë Yecu ötwak ködgï kï carolok nï, “Yam onwongo tye dhanö mörö n'öpïdhö ölök ï pwodho mërë. Ën öcëlö pwodho mërë nön ökö kï cël, ökünyö bur ïë më bïö pig ölök, ëka ögërö pem më kür ïë. Cë ën ömïö pwodho ölök both epang pwodho mörö ëka ën öcïdhö ökö ï lobo nökënë. ");
INSERT INTO lth_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na karë më püdö ölök dong örömö, ën ooro atic mërë both epang pwodho ëk öcïdh ööm nïnë nyig ölök mörö n'öcëk. ");
INSERT INTO lth_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ëntö epang pwodho ömakö atic n'onwongo eoro, cë epwodo ëka ëryëmö ödök cen kï cïngë nono. ");
INSERT INTO lth_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Won pwodho ölök ooro atic mërë nökënë dökï, ëntö epang pwodho opwodo ën ï wie ëka etio tic më lewic ï kome. ");
INSERT INTO lth_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Won pwodho ölök ooro atic mërë nökënë dökï, ëka manön gïn oneko ökö. Ën ooro jö nökënë na pol; mökö kï kin-gï epwodogï, ëka nökënë enekogï. ");
INSERT INTO lth_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Won pwodho onwongo pod odong kï ngat acël më aora, wode n'onwongo ën marö. Më ajiki mërë ën ooro wode nakun kobo nï, ‘Gïn bino wörö woda.’ ");
INSERT INTO lth_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ëntö epang pwodho ötwak ï kin-gï kën-gï nï, ‘Man ënë alak jami. Bin unu, ëk enek ën ökö, ëka jami më alaka bino bedo më onu.’ ");
INSERT INTO lth_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Cë gïn dong ökwanyö wod ka won pwodho ölök eneko ökö, ëka ebolo yökö kï ï pwodho ölök. ");
INSERT INTO lth_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ngö na dong won pwodho ölök bino tïmö? Ën bino ëka neko epang pwodho nön ökö kïbëc cë mïö pwodho ölök nön both jö nökënë. ");
INSERT INTO lth_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Un ba ïkwanö unu kï ï Cöc na Leng nï: “‘Kidi n'egedo ökwërö ënë ödökö kidi më gwïc öt. ");
INSERT INTO lth_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Rwoth ötïmö man, ëka obedo gin më aura kï wang onu’?” ");
INSERT INTO lth_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ëtëla k'Eyuda örangö gïnï yoo më makö Yecu pïën ongeo gïnï nï ën onwongo ötwakö carolok ï komgï. Ëntö gïn onwongo lworo lwak. Cë gïn öya öwëkö Yecu ëka öcïdhö gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kinge, ëtëla dini ooro gïnï Eparicayo mökö ëka jö na cwakö Erode both Yecu ëk enwong köp mörö kï ï dhögë na mïö ëtwërö makö ën. ");
INSERT INTO lth_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Gïn obino bothe ëka okobo gïnï nï, “Apwony, wan engeo nï in ibedo dhanö na kite atïr. In ba ïwëkö jö nökënë kobo nini ngö na myero ïtïm onyo ikobi. Ëntö in ipwonyo yoo k'Obanga na rwatërë kï köp na tye adyer. Pore më cülö ocoro both Cija onyo pe? ");
INSERT INTO lth_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wan myero ëcül ocoro onyo kür ëcül?” Ëntö Yecu ongeo ököragï nön ökö. Ën openyogï nï, “Pïngö itye ka tëmöna unu? Nyuth nïna denario ëk anën.” ");
INSERT INTO lth_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gïn okelo acël bothe, ëka Yecu openyogï nï, “Cal ëka cöc na tye ïë, obedo më ka nga?” Gïn ögamö nï, “Më ka Cija.” ");
INSERT INTO lth_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Cë Yecu okobo nïgï nï, “Eyo, mïï unu jami ka Cija both Cija, ëka jami k'Obanga both Obanga.” Ëka gïn obedo kï ur rwök ï kom Yecu. ");
INSERT INTO lth_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Cë Ecadukayo, na kobo gïnï nï cer ka jö n'öthöö ope, obino gïnï both Yecu kï peny. ");
INSERT INTO lth_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Gïn okobo nï, “Apwony, Muca yam ömïöwa cïk nï ka ëcwö mörö öthöö n'öwëkö dhakö mërë na ba önywölö ëthïnö mörö, ömïn mërë na kwö myero olak dhakö nonu ëk önywöl ëthïnö ï wi ömïn mërë. ");
INSERT INTO lth_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yam onwongo utmego mörö ute gïn abïrö. Më acël mërë onyomo ëka öthöö na ba önywölö athïn. ");
INSERT INTO lth_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ömïn mërë më arïö ölakö dhakö nön, ën thon öthöö ökö na ba önywölö ködë athïn mörö. Ëka ötïmërë both ömïn mërë më adek nï kömanön. ");
INSERT INTO lth_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Utmego abïrö ni kïbëc ölakö ën ëntö ba önywölö gïnï ëthïnö mörö. Më ajiki mërë, dhakö ni thon öthöö ökö. ");
INSERT INTO lth_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dhakö ni dong bino bedo më ka nga ï karë më cer? Pïën utmego abïrö kïbëc onwongo ölakö ën.” ");
INSERT INTO lth_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yecu ögamö nïgï nï, “Un ba irwenyo unu pï köp ni, pïën ba ingeo unu Cöc na Leng onyo tëkö k'Obanga. ");
INSERT INTO lth_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pïën ka jö n'öthöö ocer, gïn ba dök nyomo onyo ënyömögï. Gïn bino bedo na calö emalaika na tye ï wi polo. ");
INSERT INTO lth_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Ëntö kobedini, köp na makö cer ka jö n'öthöö, un bara ïkwanö unu kï kom cöc ka Muca, kï köp na makö bunga na lyël, kite n'Obanga okobo nï Muca ködë nï, ‘An abedo Obanga k'Abraam, Obanga ka Icaka, ëka Obanga ka Jakob’? ");
INSERT INTO lth_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ën ba obedo Obanga ka jö n'öthöö, ëntö Obanga ka jö na kwö. Un irwenyo unu rwök.” ");
INSERT INTO lth_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Apwony cïk ka Muca mörö onwongo ocung kunön winyo ngö n'onwongo etye ka larö. Ën önïang nï Yecu ögamö köp na bër, cë openyo nï, “Kï kom cïk kïbëc, mënë na pïrë tëk rwök?” ");
INSERT INTO lth_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yecu ögamö nï, “Cïk na pïrë tëk rwök ënë man: ‘Winy unu jö Icarael! Rwoth Obangawa ënë obedo Obanga acël ëka Rwoth. ");
INSERT INTO lth_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ëka myero ïmar Rwoth Obangani kï cwinyi kïbëc, kï tiponi kïbëc, kï thamani kïbëc, ëka kï tëköni kïbëc.’ ");
INSERT INTO lth_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Më arïö mërë pïrë tëk na röm aröma: ‘Mar awodhi na calö ïmarö komi keni.’ Cïk mörö nökënë ope na pïrë tëk na löö man.” ");
INSERT INTO lth_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Apwony cïk ka Muca ögamö nï, “Eyo apwony, in ikobo na bër. In ïtwakö köp n'atïr nakun ikobo nï Obanga tye acël këkën ëka obanga nökënë ope. ");
INSERT INTO lth_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ëka an angeo nï pïrë tëk më marö ën kï cwinyi kïbëc ëka kï thamani kïbëc ëka kï tëköni kïbëc, ëka më marö awodhi na calö ïmarö komi keni. Man ënë pïrë tëk na löö tyër awanga ëka gin aryëda.” ");
INSERT INTO lth_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ï karë na Yecu önïang nï apwony cïk ka Muca ögamö kï ryëkö, ën okobo nïnë nï, “In ba ibor kï ker k'Obanga.” Ëka cakërë ï caa nön ngat mörö ba dök öthamö më penyo Yecu kï peny mörö nökënë. ");
INSERT INTO lth_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kinge na Yecu onwongo tye ka pwonyo jïï ï dyekal öt k'Obanga, ën openyogï nï, “Pïngö epwony cïk ka Muca kobo nï Meciya obedo akwar Daudi? ");
INSERT INTO lth_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi kikome ötwakö kï tëkö ka Tipo Naleng, na kobo nï, “‘Rwoth okobo both Rwodha: Bed ï nget cïnga më kucem naka ka an aketho langni ï thë tyeni.’ ");
INSERT INTO lth_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daudi kikome cwodo ën nï, ‘Rwoth.’ Ën dök twërö bedo wode nïngö?” Jö na pol owinyo köp mërë kï yom cwiny. ");
INSERT INTO lth_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ï karë na Yecu tye ka pwony, ën okobo nï, “Gwökërë unu kï kom epwony cïk ka Muca. Pïën gïn marö woth rimo pïny nakun ruko gïnï böng na boco ëka mïtö gïnï nï jïï omothgï kï thë cuk, ");
INSERT INTO lth_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ëka marö gïnï bedo ï kabedo na bëcö më dheo ï öt Cinagoga ëka kabedo më wörö ï karama. ");
INSERT INTO lth_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Gïn maö udi ka mon thöö, bedo gïnï lëgö lëga na boco më nyuthere. Koth jö ni ebino pwodogï na rac rwök.” ");
INSERT INTO lth_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yecu obedo pïny ï nget kanya eketho tyër ïë kï ï öt k'Obanga. Ën önënö lwak ka bolo tyër ï canduk lïm. Ëlönyö na pol obolo lïm na thwönë. ");
INSERT INTO lth_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Cë dha thöö n'obedo acan obino ëka obolo cïlïng na nyige gïn arïö. ");
INSERT INTO lth_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yecu öcakö cwodo ëlübkörë bothe ëka okobo nï, “An akobo niwu köp adyer, dha thöö ni n'obedo acan ënë obolo tyër ï canduk lïm na löö jö nökënë kïbëc na tye ka mïö tyërgï. ");
INSERT INTO lth_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pïën gïn ömïö tyërgï n'ögïthö gïnï kï kom lïmgï na thwönë, ëntö dha thöö ni n'obedo acan, ömïö jami kïbëc n'onwongo tye bothe na myero ën ökwö ködë.” ");
INSERT INTO lth_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na Yecu onwongo tye ka yaa kï ï öt k'Obanga, alübkörë acël öcakö kobo nï, “Apwony, nën kit na kite ni thwon ködë ëka kit na gedo mërë bëcö ködë!” ");
INSERT INTO lth_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yecu okobo nïnë nï, “Un ïnënö gedo na thwon ni? Ba tye kidi mörö kany n'ebino wëkö ï wi wadï na ba ebino bolo ökö pïny.” ");
INSERT INTO lth_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kinge, Yecu obedo pïny ï wi Kidi më Jeituni nakun opimere kï öt k'Obanga, Petero, Yakobo, Jon, ëka Anderiya öcakö gïnï penyo ën na ut kënë nï, ");
INSERT INTO lth_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kob nïwa, köp ni bino tïmërë awene? Ëka dökï anyuth mërë ënë ngö na bino nyutho nï köp nön cwök cobere?” ");
INSERT INTO lth_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yecu öcakö kobo nïgï nï, “Gwökërë unu, ëk ngat mörö kür öbwölwu. ");
INSERT INTO lth_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Pïën jö na pol bino bino gïnï kï nyïnga na bino kobo gïnï nï, ‘An ënë ën,’ ëka bino mïö jö na pol rwenyo ökö. ");
INSERT INTO lth_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ka ibino winyo unu pï lwëny ëka anïï më lwëny, kür ïmïï cwinywu opodhi, koth jami ni myero ötïmërë, ëntö nwongo ajiki pïny podi. ");
INSERT INTO lth_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Rok bino lwëny ï kom rok nökënë, ëka ker bino lwëny ï kom ker nökënë. Oyeyeng bino yengo kabedo na pol ëka kec thon bino podho. Manön ënë acaki më can na bino podho ï wi lobo. ");
INSERT INTO lth_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ka jami ni bino tïmërë, myero ïgwökërë unu. Ebino terowu ï nyim okiko both ëlöc ëka ebino pwodowu ï cinagoga gïnï. Ibino cung unu ï nyim ëlöc ëka ï nyim rwodhi pïra na calö ecaden bothgï. ");
INSERT INTO lth_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Më acël köp më Emuth na Bër myero ëtït ï wi lobo thükül n'ajiki bara othuno. ");
INSERT INTO lth_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ka ëmaköwu, ëka ekelowu ï nyim okiko, kür ïpar unu ngö nï bino kobo ëntö kob unu ngö n'ebino mïöwu ï caa nön, pïën pathï un ënë ibino twak ëntö Tipo Naleng ënë bino twak. ");
INSERT INTO lth_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Omego bino mïö ömïn mërë më aneka, apap bino mïö athïn mërë më aneka. Ëthïnö bino jëm ï kom enyodogï ëka mïö enekogï. ");
INSERT INTO lth_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jö kïbëc bino dagöwu pï nyïnga. Ëntö ngat na bino cung na tëk naka ï ajiki bino larë. ");
INSERT INTO lth_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ëntö ka ïnënö unu gin mörö më kwer na balö cwiny jö, n'ocung kanya myero kür ocung ïë (ëk dhanö na kwanö önïang ïë), cë jö na tye gïnï ï Yudea myero örïng gïnï ï wi kite. ");
INSERT INTO lth_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Dhanö na tye ï wi ödë kür oidhi pïny, onyo ödöny ï öt më kwanyö gin mörö. ");
INSERT INTO lth_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Dhanö na tye ï pwodho, kür ödök cen më ömö böngü mërë. ");
INSERT INTO lth_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mon na yeco ëka mon na dödhö ëthïnö bino nënö can ï karë nonu. ");
INSERT INTO lth_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lëg unu ëk köp ni kür ötïmërë ï karë më cwïr, ");
INSERT INTO lth_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","pïën karë nön bino bedo thwön can na thwönë rwök na naka yam bara ötïmërë ï wi lobo, cakërë ï karë n'Obanga ocweo kï lobo naka othuno ködë tin, ëka ba bino tïmërë dökï. ");
INSERT INTO lth_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ka Rwoth onwongo ba öngölö nïnö nön na cecek, onwongo ngat mörö acël thon ba bwöth. Ëntö pï jö n'Obanga öyërögï, ënë ömïö ën öngölö wel nïnö nonu ödökö na nönök. ");
INSERT INTO lth_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ï karë nön, ka dhanö mörö okobo niwu nï, ‘Nën, Meciya ene,’ onyo nï, ‘Nën, ën ëca,’ kür iyee unu. ");
INSERT INTO lth_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pïën jö na kobo nï gïn ebedo Kiricito ëka edwarpïny na twot bino bino ëka bino tio gïnï anyuth ëka tango na dito ëk ka twërë ëbwöl gïnï naka jö n'ëyërögï. ");
INSERT INTO lth_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Gwökërë unu dong, an atyeko dong kobo ökö niwu jami kïbëc na bino tïmërë na karë bara örömö. ");
INSERT INTO lth_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ëntö ï karë nonu, kinge can na thwönë nön, “ ‘ceng bino cido ökö nicuc, ëka dwe thon ba bino ryëny, ");
INSERT INTO lth_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","cër bino podho gïnï kï ï wi polo, ëka tëkö kïbëc më wi polo bino yengere.’ ");
INSERT INTO lth_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ï karë nön jö kïbëc bino nënö Wod ka Dhanö na tye ka bino kï ï pöl kï twër na dit ëka dheo. ");
INSERT INTO lth_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ëka ën bino oro emalaika më cökö jö mërë n'ëyërögï kï ï thwok lobo angwën më ajiki lobo naka ï ajiki më polo. ");
INSERT INTO lth_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nwong unu pwony ni kï ï kom yath ölam. Ka jangë öcakö löth, ëka pote odonyo, un ingeo nï oro dong cwök. ");
INSERT INTO lth_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kömanön thon, ka ïnënö unu jami ni tye ka tïmërë, ïtwërö unu ngeo nï dwogo mërë dong cwök, tye ï dholokek. ");
INSERT INTO lth_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","An akobo niwu köp adyer, rok më karë ni ba bino poth naka ka jami ni kïbëc ötïmërë. ");
INSERT INTO lth_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Polo ëka lobo bino rwenyo ökö, ëntö köpna ba bino rwenyo. ");
INSERT INTO lth_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ngat mörö ope na ngeo nïnö nön onyo caa nön, naka thon emalaika na tye ï wi polo, onyo Wod, ëntö Apap këkën ënë ngeo. ");
INSERT INTO lth_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gwökërë unu! Bed n'ineno unu! Ba ingeo unu awene na karë nön bino römö ködë. ");
INSERT INTO lth_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bino ka Wod ka Dhanö röm aröma kï dhanö na tye ka cïdhö ökö kany mörö na bor. Ën ka yaa kï ï pacö, mïö twërö both etic mërë, ngat acëlacël kï tic na mëgë, nakun cïkö ngat na gwökö dhö wangkac nï ëk obed na wangë thwolo. ");
INSERT INTO lth_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Un thon, bed unu na wangwu thwolo, pïën ba ingeo unu awene na won öt bino dwogo ködë onyo bino dwogo kothyeno onyo dingwor onyo na thwön gwënö kok onyo kodiko. ");
INSERT INTO lth_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ka ën bino dwogo athura, kür ïmïï ën onwongwu ïnïnö. ");
INSERT INTO lth_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ngö na an akobo bothwu, an akobo nï jö kïbëc: ‘Bed na wangwu thwolo!’ ” ");
INSERT INTO lth_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Onwongo odong nïnö arïö më thuno ï Karama më Poth ëka Karama më Ogati na Thöbï ope ïë. Ëlamdhök na dito ëka epwony cïk ka Muca onwongo tye ka rangö gïnï kite na myero ëmak kï Yecu ï müng ëka enek ën ökö. ");
INSERT INTO lth_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Gïn okobo nï, “Kür ëmak Yecu ï karë më Karama më Poth, ëk kür ömïï jïï okel wöö.” ");
INSERT INTO lth_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ï karë na Yecu tye ka cem ï öt ka Cimon n'onwongo obedo adhöbü ï Betania, dhakö mörö obino kï cupa möö narad na ngwece kur na wel mërë tëk. Ën ötürö dhö cupa ëka önyö möö ï wi Yecu. ");
INSERT INTO lth_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jö mökö n'onwongo tye gïnï kany nön ökëcö gïnï rwök ëka ötwak kën-gï nï, “Pïngö ëbalö möö ni na ngwece kur abala? ");
INSERT INTO lth_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Onwongo myero ëcadh ï wel na kadhö denario mïa adek ëk ëmïï both ëcan!” Cë gïn ocoko dhakö nön kï gero. ");
INSERT INTO lth_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ëntö Yecu ögamö nïgï nï, “Wëk unu dhakö nön kënë. Pïngö kara icoko unu ën? Ën ötïmö gin na bër botha. ");
INSERT INTO lth_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ëcan itye unu ködgï nïnö kïbëc ëka caa mörö këkën ïtwërö unu könyögï. Ëntö ba ibino unu bedo köda nïnö kïbëc. ");
INSERT INTO lth_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ën ötïmö gin na ën römö ëka owiro koma më aika na caa bara örömö. ");
INSERT INTO lth_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","An akobo niwu köp adyer nï kanya kïbëc n'ebino tïtö köp më Emuth na Bër ïë ï wi lobo thükül, gin na dhakö ni ötïmö thon ebino kobo pïrë, ëk obed më po pï ën.” ");
INSERT INTO lth_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Cë Yuda Ikariot, na ënë dhanö acël ï kin ëlübkör Yecu apar arïö, öcïdhö both ëlamdhök na dito ëk ëyüb kit na myero ëmïï Yecu bothgï. ");
INSERT INTO lth_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ï karë na gïn owinyo ngö na ën onwongo mïtö tïmö nïgï, cwinygï obedo na yom, ëka öcïkërë gïnï më mïö Yuda Ikariot cïlïng. Cë Yuda öcakö rangö karë na bër na ën ërömö mïö Yecu bothgï. ");
INSERT INTO lth_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ï nïnö më acël më Karama më Ogati na Thöbï ope ïë, nïnö na yam ëngölö k'athïn römö më Poth, ëlübkör Yecu openyo gïnï ën nï, “Ka kwene na in ïmïtö nï wan ëcïdh ëyüb nini cem më Poth ïë?” ");
INSERT INTO lth_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Cë Yecu ooro jö arïö kï kin ëlübkörë nakun cïkögï nï, “Apë unu naka ï Jerucalem, ibino unu romo k'ëcwö mörö n'öyëö agulu pii. Lüb unu körë, ");
INSERT INTO lth_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ëka kob unu both won öt na ën bino dönyö ïë nï, ‘Apwony okobo nï öt wele ute kwene ëk ëcam cem më Poth ïë k'ëlübkörë?’ ");
INSERT INTO lth_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ën bino nyutho niwu öt na lac na tye malö, n'eketho jami kïbëc ïë. Kany nön ënë ïyüb unu cem na më onu ïë.” ");
INSERT INTO lth_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ëlübkör Yecu arïö öcïdhö gïnï yo Jerucalem ëka onwongo gïnï jami kïbëc kite na Yecu okobo nïgï ködë. Cë gïn dong öcakö yübö cem më Poth kunön. ");
INSERT INTO lth_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na dong othuno kothyeno, Yecu obino k'ëlübkörë apar arïö. ");
INSERT INTO lth_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ï karë na gïn tye ka cem, Yecu öcakö kobo nïgï nï, “An akobo niwu köp adyer nï ngat acël kï kinwu bino ketho örörö ï koma, ngat acël na tye ka cem köda.” ");
INSERT INTO lth_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ëlübkör Yecu öcakö kumo, nakun ngat acëlacël penyo ën nï, “Ködë an ba?” ");
INSERT INTO lth_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yecu öcakö kobo nïgï nï, “Dhanö acël kï kinwu jö apar arïö, na tye ka lutho cïngë ï wal kanya acël köda. ");
INSERT INTO lth_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wod ka Dhanö bino cïdhö nï kömanön kite n'ëcöö ködë ï kome. Ëntö dhanö na bino ketho örörö ï kom Wod ka Dhanö bino nënö can! Onwongo bedo na bër ka dhanö nön ba ënywölö.” ");
INSERT INTO lth_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ï karë na gïn tye ka cem, Yecu ökwanyö ogati, ölëgö gum ïë, cë opoko ömïö both ëlübkörë ëka okobo nïgï nï, “Gam ïcam unu. Man ënë koma.” ");
INSERT INTO lth_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ëka ökwanyö ekopo, öpwöyö Obanga, cë ömïögï, ëka gïn kïbëc ömadhö. ");
INSERT INTO lth_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yecu okobo nïgï nï, “Man ënë remona më cïkërë na nyen, na bino öny pï jö na pol. ");
INSERT INTO lth_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","An akobo niwu köp adyer nï, ba dök abino madhö pig nyig ölök, naka ï nïnö nön na an abino madhö na nyen ï ker k'Obanga.” ");
INSERT INTO lth_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Na dong gïn otyeko wero wer, cë öcïdhö gïnï ï wi Kidi më Jeituni. ");
INSERT INTO lth_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yecu okobo bothgï nï, “Un kïbëc ibino unu wëköna ökö, pïën yam ëcöö nï, “‘Abino neko akwath, ëka rom bino këth ata.’ ");
INSERT INTO lth_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ëntö kinge cer, abino tëlö nyimwu më cïdhö yo Galilaya.” ");
INSERT INTO lth_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petero öcakö kobo nï, “Kadï bed nï jö kïbëc bino wëköni ökö, ëntö an ba abino wëköni.” ");
INSERT INTO lth_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yecu ögamö nï, “Petero, an akobo nini köp adyer, tin ï dyewor na thwön gwënö bara okok wang arïö, in ibino kwëröna wang adek.” ");
INSERT INTO lth_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ëntö Petero ocere kï tëk na kobo nï, “Kadï bed nï myero athöö kodi, an ba abino kwëröni na twal!” Ëka jö kïbëc okwongere nï kömanön. ");
INSERT INTO lth_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Gïn öcïdhö ï kabedo n'ecwodo nï pwodho më Gethcemane, ëka Yecu okobo both ëlübkörë nï, “Bed unu kany, ëk an kono acïdh alëgï.” ");
INSERT INTO lth_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ën ökwanyö Petero, Yakobo ëka Jon cë öcïdhö ködgï. Cwinye öcakö podho na lïth rwök ëka kï kumo. ");
INSERT INTO lth_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yecu öcakö kobo nïgï nï, “Cwinya cwer rwök na mïtö nekona ökö. Bed unu kany na wangwu thwolo.” ");
INSERT INTO lth_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yecu öcïdhö anyim na nönök, cë orumo cöngë pïny oryebere ëka ölëgö nï ka onwongo twërë, kono caa nön opoth ökö kï bothe. ");
INSERT INTO lth_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Aba, Apap, jami kïbëc twërë kï bothi, kwany ekopo ni ökö kï botha, kür obed kite na an amïtö, ëntö obed kite na in ënë ïmïtö.” ");
INSERT INTO lth_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Cë ën odwogo cen both ëlübkörë ëka onwongogï önïnö ökö. Yecu okobo both Cimon nï, “Petero, ïnïnö ökö? Ba ïrömö bedo na wangi thwolo pï caa mörö acël? ");
INSERT INTO lth_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bed unu na wangwu thwolo, lëg unu both Obanga ëk kür ïdöny unu ï atëmatëma mörö. Cwiny mïtö, ëntö kom görü.” ");
INSERT INTO lth_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yecu öwëkögï dökï ëka öcïdhö ölëgö lëga acël nön. ");
INSERT INTO lth_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ï karë na ën odwogo, ën dökï onwongo ëlübkörë tye ka nïnö, pïën nïnö onwongo ömakö wang-gï rwök. Gïn ba ongeo ngö na myero ekob gïnï both Yecu. ");
INSERT INTO lth_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yecu odwogo wang më adek mërë, cë okobo nïgï nï, “Un pod ïnïnö ëka iyweo unu? Dong örömö! Caa dong örömö. Wod ka Dhanö dong ëmïö ökö ï cïng ëbal. ");
INSERT INTO lth_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yaa unu malö! Eru ecidhu! Nën, dhanö na bino ketho örörö ï koma dong cwök!” ");
INSERT INTO lth_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Cücüth na Yecu onwongo pod twak, Yuda, ngat acël ï kin ëlübkör Yecu apar arïö, othuno kï lwak n'ömakö gïnï pele abadë ëka kï ludhi, n'ëlamdhök na dito, epwony cïk ka Muca ëka edite ënë oorogï. ");
INSERT INTO lth_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Won örörö onwongo otyeko dong yübö anyuth ködgï nï: “Ngat na an abino nödhö leme, ën ënön, mak unu ën ëka iter ïgwök unu na bër.” ");
INSERT INTO lth_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda öcakö cïdhö ökö cücüth both Yecu ëka okobo nï, “Apwony!” Cë önödhö leme. ");
INSERT INTO lth_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Gïn dong öcakö podho ï kom Yecu, ëka ëmakö ën. ");
INSERT INTO lth_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ëntö dhanö mörö acël n'onwongo ocung ï nget Yecu öcakö wödhö pala abadë mërë, cë otongo kï ith atic k'Alamdhök na Dit naka onguno ökö. ");
INSERT INTO lth_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yecu openyogï nï, “Ibino unu botha kï pele abadë ëka kï ludhi më maköna calö an abedo ayak? ");
INSERT INTO lth_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nïnö kï nïnö an abedo kodwu ï dyekal öt k'Obanga nakun apwonyo, ngö n'ocerowu maköna? Ëntö jami ni kïbëc tye ka tïmërë më cobo ngö na Cöc na Leng kobo ï koma.” ");
INSERT INTO lth_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Cë ëlübkör Yecu kïbëc öwëkö ën ëka öngwëcö gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Awobi mörö n'orwao böngü këkën ï kome, onwongo tye ka lübö kör Yecu. Ï karë na lwak ötëmö më makö ën, ");
INSERT INTO lth_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","awobi ni omukere kï ngwëc cë öwëkö böngü mërë ï cïng-gï ëka öngwëcö kotula. ");
INSERT INTO lth_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gïn otero Yecu both Alamdhök na Dit, ëka ëlamdhök na dito kïbëc, edite ëka epwony cïk ka Muca obino gïnï kanya acël. ");
INSERT INTO lth_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petero obedo ka lübö kör Yecu kï cecen naka othuno ködë ï dyekal k'Alamdhök na Dit. Ën obedo kanya acël k'ëkürpïny, nakun oo mac. ");
INSERT INTO lth_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ëlamdhök na dito, ëka athuko më Öd okiko k'edong kïbëc onwongo tye gïnï ka rangö caden mörö na römö mïögï neko Yecu. Ëntö ba onwongo gïnï gin mörö. ");
INSERT INTO lth_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ecaden na pol obedo ka twakö köp twodo ï kom Yecu ëntö köpgï ba örwatërë. ");
INSERT INTO lth_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Më ajiki mërë, jö nökënë öya malö cë ötwakö gïnï caden më twodo nï, ");
INSERT INTO lth_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Wan ewinyo ën tye ka kobo nï, ‘An abino muko öt k'Obanga ni n'ëyübö kï cïng dhanö, ëka abino gërö nökënë pï nïnö adek, na ba ëgërö kï cïng dhanö.’ ” ");
INSERT INTO lth_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kadï bed nï kömanön, köp më caden na gïn ötwakö ba örwatërë. ");
INSERT INTO lth_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Alamdhök na Dit öya malö cë ocung ï dyeregï ëka openyo Yecu nï, “Eyo, in ba ïtwërö gamö köp ni kïbëc? Ngö na in ïtwërö kobo ï kom gin n'ekobo ï komi?” ");
INSERT INTO lth_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ëntö Yecu ölïng alïnga ba ögamö. Cë Alamdhök na Dit dökï openyo ën nï, “In ënë ibedo Meciya, Wod k'Obanga n'ëwörö?” ");
INSERT INTO lth_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yecu okobo nï, “An ënë ën. Ëka ibino nënö unu Wod ka Dhanö n'obedo ï nget cïng Won Twër kucem ëka dökï tye ka bino kï ï pöl më polo.” ");
INSERT INTO lth_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Alamdhök na Dit öyëcö böng mërë ëka okobo nï, “Pïngö onu pod dökï ëmïtö caden nökënë? ");
INSERT INTO lth_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Un iwinyo unu kite na ën öyanyö k'Obanga ködë. Ïthamö unu nïngö ïë?” Gïn kïbëc öngölö nï, “Ën opore më thöö!” ");
INSERT INTO lth_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jö nökënë öcakö ngülö laö dhögï ï kome, nakun eumo wangë ökö cë ëbapö, n'ekobo nïnë nï, “In ibedo adwarpïny, tuc nïwa!” Ëka ëkürpïny ökwanyö Yecu cë epwodo. ");
INSERT INTO lth_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ï karë n'onwongo Petero tye pïny ï dyekal, atic k'Alamdhök na Dit mörö n'obedo nyakö obino. ");
INSERT INTO lth_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ï karë na ën önënö Petero tye ka oo mac, ën örïpö Petero na cwök ëka okobo nï, “In thon onwongo itye kï dhanö nön n'öya kï ï Najaret, ën Yecu.” ");
INSERT INTO lth_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ëntö Petero ökwërö ökö na kobo nï, “An ba angeo ngö na in itye ka twakö,” cë öcïdhö ökö yo dhö wangkac, ëka thwön gwënö öcakö kok. ");
INSERT INTO lth_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ï karë na nyakö nön n'obedo atic önënö Petero ocung kunön dökï, ën öcakö kobo both jö nökënë nï, “Ëcwö ni obedo awodhgï acël!” ");
INSERT INTO lth_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ëntö Petero ökwërö ökö dökï. Kinge na nönök jö mökö n'onwongo ocung gïnï ï nget Petero öcakö kobo gïnï nï, “Adyer in ibedo awodhgï acël, pïën in ibedo dhanö më Galilaya.” ");
INSERT INTO lth_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petero öcakö alem ï kome kënë nakun kwongere nï, “An ba angeo ëcwö ni na un itye ka twakö köp ï kome” ");
INSERT INTO lth_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ëka cücüth thwön gwënö okok wang më arïö. Cë Petero opo ï köp na Yecu okobo nïnë nï, “Na bara thwön gwënö okok wang arïö, in ibino kwëröna wang adek.” Ëka öcakö koko rwök. ");
INSERT INTO lth_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Keko cön, ëlamdhök na dito, mëd k'edong, epwony cïk ka Muca, ëka athuko më öd okiko k'edite kïbëc öyübö gïnï köp kanya acël. Gïn otweo Yecu cë etero ökö ëka ëmïö both Pilato. ");
INSERT INTO lth_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato öcakö penyo Yecu nï, “In ënë rwoth k'Eyuda?” Yecu ögamö nï, “Eyo, obedo kite na in ikobo ködë.” ");
INSERT INTO lth_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ëlamdhök na dito odotho Yecu kï kwa adoth na pol. ");
INSERT INTO lth_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Cë Pilato dökï openyo Yecu nï, “In ba ïtwërö gamö peny? Nën lwak köp na pol n'edothi ködë.” ");
INSERT INTO lth_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ëntö Yecu ba ögamö gin mörö, ëka Pilato obedo kï ur rwök. ");
INSERT INTO lth_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ï karë më Karama më Poth kïbëc, Pilato onwongo marö gönyö amabuc acël na lwak nwongo ökwaö. ");
INSERT INTO lth_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ï karë nön, ëcwö mörö onwongo tye na nyïngë Baraba, na yam etweo ï buc ï kin jö n'öjëm n'oneko gïnï jïï ï karë më jëmgï nön. ");
INSERT INTO lth_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lwak öcakö cïdhö both Pilato më penyo ën ëk ötïm kite na ën önaa tïmö ködë. ");
INSERT INTO lth_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato openyogï nï, “Un ïmïtö nï agöny niwu rwoth k'Eyuda?” ");
INSERT INTO lth_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato okobo nï kömanön pïën ën onwongo ongeo nï ëlamdhök na dito okelo gïnï Yecu pï nyeko. ");
INSERT INTO lth_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ëntö ëlamdhök na dito öcüpö gïnï lwak ëk ömïï Pilato ögöny Baraba nakaka Yecu. ");
INSERT INTO lth_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato öcakö penyogï nï, “Ngö na myero an atïm kï ngat na un icwodo nï rwoth k'Eyuda?” ");
INSERT INTO lth_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Lwak öwöö gïnï nï, “Gur ën ï kor yath arïa!” ");
INSERT INTO lth_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ëka Pilato dökï openyogï nï, “Pïngö kara, ötïmö ngö na rac?” Ëntö lwak öwöö gïnï kï redo rwök nï, “Gur unu ën ökö ï kor yath arïa!” ");
INSERT INTO lth_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato onwongo mïtö yomo cwiny lwak, cë ögönyö Baraba nïgï. Ën ömïö twërö nï ëk epwod Yecu kï del ëka egur ï kor yath arïa. ");
INSERT INTO lth_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Acikari otero gïnï Yecu naka ï dyekal k'alöc (n'ecwodo nï Praitorion) ëka ocwodo gïnï lwak acikari kïbëc kanya acël. ");
INSERT INTO lth_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Gïn öcakö ruko Yecu kï böngü na kwar ëka etweo tok öküdhö öthac, cë ërwakö ï wie. ");
INSERT INTO lth_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Cë gïn öcakö motho ën nï, “Örëm ba, rwoth k'Eyuda!” ");
INSERT INTO lth_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Acikari opwodo gïnï wi Yecu kï lüth, öngülö gïnï laö dhögï ï kome, ëka orumo gïnï cöng-gï pïny më wörö ën më anywar. ");
INSERT INTO lth_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ï karë na gïn dong önywarö Yecu, ökwanyö gïnï böngü na kwar ökö kï ï kome ëka ëdwökö böng mërë ï kome. Cë gïn dong otero Yecu yökö ëk egur ï kor yath arïa. ");
INSERT INTO lth_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ëcwö mörö më Cirene na nyïngë Cimon apap k'Alegijanda ëka Rupo, onwongo tye ka wok nakun öya kï kin pacö ëka acikari ödïö ën më tingo yath arïa. ");
INSERT INTO lth_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gïn otero Yecu ï kabedo n'ecwodo nï Golgota, na tyën köp mërë nï, “Kabedo më Cogo Wic.” ");
INSERT INTO lth_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Cë acikari öcakö mïö Yecu köngö ölök n'erubo kï yath müra, ëntö Yecu ökwërö madhö ökö. ");
INSERT INTO lth_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Gïn oguro Yecu ï kor yath arïa ëka opoko gïnï böng mërë ï kin-gï nakun ebolo kwir ëk ënën böngü na ngat acëlacël bino tero. ");
INSERT INTO lth_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eguro Yecu ï kor yath arïa caa adek më kodiko. ");
INSERT INTO lth_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Gin n'ëcöö na nyutho köp n'edotho ën ïë kwanërë nï, “RWOTH K'EYUDA.” ");
INSERT INTO lth_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Eguro Yecu kanya acël k'ëyak arïö, dhanö acël kucem ëka acël kucam. ");
INSERT INTO lth_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Man ömïö Cöc na Leng ocobere kakarë nï, “Ëkwanö ën ï kin ëbal.” ");
INSERT INTO lth_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jö n'onwongo tye ka wok ï ngete, obedo gïnï ka yanyö ëka nywarö Yecu, nakun yengo wigï na kobo gïnï nï, “Onye, in n'imuko öt k'Obanga ökö, cë ïgërö pï nïnö adek këkën, ");
INSERT INTO lth_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","larë keni, idhi pïny kï ï kor yath arïa!” ");
INSERT INTO lth_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ï kite acël nön, ëlamdhök na dito ëka epwony cïk ka Muca önywarö gïnï Yecu ï kin-gï kën-gï nakun kobo gïnï nï, “Ën ölarö jö nökënë, ëntö ba twërö larë kënë! ");
INSERT INTO lth_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wëk Kiricito, Rwoth më Icarael, oidhi pïny kï ï kor yath arïa, ëk ënën ëka eyee.” Jö n'eguro kï Yecu thon öcakö gïnï yanyö ën. ");
INSERT INTO lth_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ï caa abicël më kiceng, pïny ocido ökö na cöl nicuc ï wi lobo kïbëc naka othuno caa abungwën. ");
INSERT INTO lth_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ëka ï caa abungwën, Yecu öcakö koko kï dwön na malö nï, “Eloi, Eloi, lama cabaktani?” Na gönyö nï, “Obangana, Obangana, pïngö ïwëka nï köman?” ");
INSERT INTO lth_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ï karë na jö n'ocung na cwök owinyo, gïn okobo nï, “Winy unu, ën tye ka cwodo Eliya.” ");
INSERT INTO lth_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ëcwö mörö acël öcakö ngwëc, ëka ökwanyö amor, olutho ï köngö ölök na wac, cë örëpö ï wi yath atad ëka ömïö both Yecu nï ëk ömadhï. Ën okobo nï, “Kür unu, eru ënën ka Eliya twërö bino kwanyö ën ökö pïny!” ");
INSERT INTO lth_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yecu dökï okok kï dwön na malö cë öthöö ökö. ");
INSERT INTO lth_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Cë böngü ëcëngë na tye ï öt k'Obanga öcakö yëc opokere ïë arïö, kï malö naka pïny. ");
INSERT INTO lth_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Adit acikari n'onwongo ocung na cwök ï nyim Yecu, owinyo redo ka Yecu ëka önënö kite n'öthöö ködë, cë ën okobo nï, “Adyer dhanö ni onwongo obedo Wod k'Obanga.” ");
INSERT INTO lth_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mon mökö onwongo tye gïnï kunön, nakun rïpö gïnï kï cecen. Kï kin-gï onwongo obedo Maria më Magadala, Maria (aya ka Yakobo na tïdï ëka Yoce), ëka Calume. ");
INSERT INTO lth_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Gïn obedo ka lübö kör Yecu anaka kï ï Galilaya, ëka gïn obedo ka könyö ën thon. Mon nökënë na pol n'onwongo owotho ködë më bino ï Jerucalem onwongo thon tye kunön. ");
INSERT INTO lth_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Onwongo obedo Nïnö më Yübërë (manön nïnö na Cabït k'Eyuda bara örömö.) Na dong pïny cwök cido, ");
INSERT INTO lth_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ëcwö na nyïngë Yocepu më Arimataya obino, ën onwongo obedo dhanö na dit më öd okiko, ëka ën onwongo kürö Ker k'Obanga më bino. Ën öcïdhö both Pilato kï tëk cwiny më kwaö kom Yecu. ");
INSERT INTO lth_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato obedo kï ur më winyo nï Yecu dong öthöö ökö. Ën ocwodo adit acikari, cë openyo ka Yecu öthöö ökö. ");
INSERT INTO lth_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ï karë na Pilato önïang kï both adit acikari nï ötïmërë nï kömanön, ën ömïö kom Yecu both Yocepu. ");
INSERT INTO lth_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yocepu öwïlö böngü na leng. Cë ökwanyö kom Yecu ökö pïny kï kor yath arïa, oboo ï böngü, ëka opyelo ï bur lyël n'egworo ï kidi, cë ölörö kidi ï dhö bur lyël ëka oloro dhögë ökö. ");
INSERT INTO lth_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria më Magadala ëka Maria aya ka Yoce önënö gïnï kakwene n'onwongo eiko ën ïë. ");
INSERT INTO lth_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ï nïnö na lübö Cabït k'Eyuda, Maria më Magadala, Maria aya ka Yakobo, ëka Calume öcïdhö gïnï më wïlö möö na ngwece kur ëk ëcïdh gïnï më wiro kom Yecu. ");
INSERT INTO lth_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kodiko cön ï nïnö më acël më cabït, kinge na ceng dong odonyo, gïn öcïdhö ï lyël. ");
INSERT INTO lth_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Gïn öcakö penyere gïnï kën-gï kï ï wanga yoo nï, “Nga na bino thwaro nï onu kidi kï ï dhö bur lyël?” ");
INSERT INTO lth_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ëntö ï karë na gïn othuno, önënö gïnï lyël ëka önënö gïnï kidi n'onwongo thwönë, dong ethwaro ökö thenge. ");
INSERT INTO lth_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na gïn dönyö ï lyël, önënö gïnï awobi mörö n'oruko böngü na tar n'obedo kï kucem, ëka obedo gïnï kï lworo rwök. ");
INSERT INTO lth_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ëntö ën okobo nï, “Kür ibed unu kï lworo, un itye ka rangö Yecu më Najaret, n'onwongo eguro ï kor yath arïa. Ën ope kany! Ën ocer ökö kï kin jö n'öthöö! Nën unu, kany ënë onwongo epyelo kome ïë. ");
INSERT INTO lth_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ëntö apë ëk ikob unu n'ëlübkörë ëka Petero nï, ‘Yecu bino tëlö nyimwu më cïdhö yo Galilaya. Ibino nënö unu ën kï kunön, kite na yam ën okobo niwu ködë.’” ");
INSERT INTO lth_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Cë mon odonyo yökö kï ï lyël, öcakö gïnï ngwëc kï myël kom ëka lworo na ba okobo gïnï gin mörö both ngat mörö këkën, pïën lworo onwongo ömakögï rwök. ");
INSERT INTO lth_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ï karë na Yecu ocer kï ï lyël kodiko cön ï nïnö më acël më cabït, ën öcakö nen both Maria më Magadala, dhakö na ën onwongo öryëmö cene abïrö kï ï kome. ");
INSERT INTO lth_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ën öcïdhö both ëlübkör Yecu n'onwongo tye ka kwero cöla ëka kok gïnï. ");
INSERT INTO lth_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ëntö ï karë na gïn owinyo nï Yecu tye na kwö, ëka Maria önënö ën, gïn ba oyee köp mërë. ");
INSERT INTO lth_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kinge, Yecu onen both ëlübkörë arïö ï kite na path n'onwongo gïn tye ka cïdhö yo kin pacö. ");
INSERT INTO lth_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Gïn ödök cen më kobo both ëlübkör Yecu nökënë, ëntö ngat mörö ope n'oye köpgï. ");
INSERT INTO lth_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kinge, Yecu onen both ëlübkörë apar acël ï caa n'onwongo gïn tye ka cem. Ën ocokogï pïën gïn onwongo ope kï gen ëka pï nwang cwinygï pïën gïn ökwërö yee köp ka jö n'önënö ën kinge cer mërë kï ï kin jö n'öthöö. ");
INSERT INTO lth_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yecu okobo n'ëlübkörë nï, “Apë unu ï wi lobo kïbëc ëka ïtït unu köp më Emuth na Bër both dhanö kïbëc. ");
INSERT INTO lth_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dhanö mörö na bino yee ëka ebatica ën, bino larë, ëntö dhanö na ba bino yee, ebino ngölö nïnë köp. ");
INSERT INTO lth_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Anyuth ni bino nen kï both jö na yee, gïn bino ryëmö cene kï nyïnga. Gïn bino twak kï lëb na nyen. ");
INSERT INTO lth_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Gïn bino makö thwol kï cïng-gï, ëka ka gïn ömadhö gin mörö na neko dhanö, cë ba bino tïmögï na rac. Gïn bino ketho cïng-gï ï kom etwoe ëka bino cang gïnï.” ");
INSERT INTO lth_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kinge na Rwoth Yecu ötwak ködgï, ëkwanyö cë etero ï wi polo ëka ën obedo ï nget cïng Obanga kucem. ");
INSERT INTO lth_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Cë ëlübkör Yecu öcïdhö ëka ötïtö gïnï köp ï kom Yecu ï kabedo kïbëc. Rwoth otio ködgï ëka omoko köp mërë k'anyuth n'ölübö körë.");
INSERT INTO lth_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Both adwong Teopilo. Jö na pol dong ötëmö gïnï cöönö köp ï kom Yecu Kiricito kite n'ötïmërë ködë ï kinwa. ");
INSERT INTO lth_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Gïn öcöö jami ni kite na jö n'önënö gïnï kï wang-gï anaka kï ï acaki okobo nïwa ködë ëka onwongo pwonyo gïnï köp k'Obanga. ");
INSERT INTO lth_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pï manön, adwong Teopilo, an angïö köp kïbëc cakërë kï ï acaki. An thon athamö nï bër acöö bothi, nakun aryëö körë kï körë. ");
INSERT INTO lth_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","An amïtö nï ïnïang adyer më köp nön na yam epwonyi ködë. ");
INSERT INTO lth_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ï karë n'Erode obedo rwoth më Yudea, onwongo alamdhök mörö ute na nyïngë Jakaria, n'onwongo tye ï wang tic k'ëlamdhök k'Abija. Yam ut kï dhakö mërë na nyïngë Elicabeth n'onwongo thon obedo akwar Aron. ");
INSERT INTO lth_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jakaria ëka Elicabeth onwongo kitegï atïr ï nyim Obanga, na lübö gïnï cïk ka Rwoth abonge bal. ");
INSERT INTO lth_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ëntö gïn onwongo ope k'athïn, pïën Elicabeth onwongo obedo alür, ëka onwongo otii gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ï nïnö mörö acël na Jakaria onwongo ut ï tic mërë më alamdhök ï nyim Obanga, pïën onwongo obedo karë më wang tic mërë, ");
INSERT INTO lth_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","na calö kite k'ëlamdhök tye ködë, kwir öyërö ën më cïdhö wangö odok na kur ï öt ka Rwoth. ");
INSERT INTO lth_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ï caa n'onwongo etye ka wangö odok na kur, lwak kïbëc öcökërë yökö ï lëga. ");
INSERT INTO lth_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Cë malaika ka Rwoth onen bothe n'ocung kucem më nget keno tyër më wangö odok na kur. ");
INSERT INTO lth_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ï karë na Jakaria önënö malaika, cwinye opodho ëka lworo ömakö ën. ");
INSERT INTO lth_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ëntö malaika okobo nïnë nï, “Kür ilwor Jakaria pïën Obanga owinyo lëgani dong ökö. Dhaköni Elicabeth bino nywölö nini athïn n'ëcwö, ëka ibino cakö nyïngë Jon. ");
INSERT INTO lth_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ën bino mïöni yom cwiny ëka cwinyi bino bedo na yom, ëka jö na pol bino bedo kï yom cwiny pï nywölö ën, ");
INSERT INTO lth_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","pïën ën bino bedo na dit ï nyim Rwoth. Ën ba bino madhö köngö ölök, onyo köngö mörö na mërö dhanö. Ën bino pong kï Tipo Naleng cakërë kï ï aya mërë. ");
INSERT INTO lth_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ën bino lökö jö na pol më Icarael, ëka bino dwökögï cen both Rwoth Obangagï. ");
INSERT INTO lth_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ëka ën bino tëlö anyim më yübö yoo pï Rwoth kï tëkö ëka kï tipo n'Eliya onwongo ute ködë. Ën bino lökö cwiny enyodo ï kom ëthïnögï ëka më dwökö jö na ba winyo cïk ï ryëkö ka jö na kitegï atïr, dök më yübö nï Rwoth jö na dong öyübërë.” ");
INSERT INTO lth_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Cë Jakaria openyo malaika nï, “Abino ngeeno nïngö? An dong atii ökö ëka dhaköna thon otii.” ");
INSERT INTO lth_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaika ögamö nï, “An Gaburiel, acung ï nyim Obanga ëka eora më twak kodi ëk akob nini emuth na bër. ");
INSERT INTO lth_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ëka pïën in ba iyee ngö na an atye ka kobo nini, in ibino lïng alïnga na ba ïtwak, naka ka nïnö nön na köp ni bino tïmërë ïë, na bino cobere ka karë mërë örömö.” ");
INSERT INTO lth_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ï caa nonu lwak obedo ka kürö Jakaria, nakun uro gïnï pï ruu mërë ï öt k'Obanga. ");
INSERT INTO lth_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ï karë na ën odonyo yökö, onwongo dong ba römö twak ködgï, ëka gïn ongeo nï ën önënö anyuth mörö kï ï öt k'Obanga. Ën obedo ka twak ködgï kï cïngë ëka obedo na thë lëbë otwere. ");
INSERT INTO lth_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Na karë më tic mërë ï öt k'Obanga othum, cë ödök tunge. ");
INSERT INTO lth_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kinge karë na nönök, cege Elicabeth öyac ökö, ëka opono ködë pï dwethe abic. ");
INSERT INTO lth_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ën okobo nï, “Rwoth ötïmö köman ï koma, ï karë n'önëna, ökwanyö lewic ökö kï ï koma kï kin dhanö.” ");
INSERT INTO lth_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ï dwe më abicël më yac k'Elicabeth, Obanga ooro malaika Gaburiel ï taun na nyïngë Najaret n'onwongo ut ï lobo më Galilaya, ");
INSERT INTO lth_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","both nyakö n'ecwodo nï Maria na ba ongeo ëcwö. Ën onwongo öcïkërë më nyömërë kï Yocepu akwar Daudi. ");
INSERT INTO lth_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaika öcïdhö bothe cë okobo nïnë nï, “Kuc obed kodi! In na kome gum, Rwoth ut kodi.” ");
INSERT INTO lth_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ï karë na Maria owinyo köp ni, cwinye opodho ëka obedo kï ur ï ngö na köp nön gönyö. ");
INSERT INTO lth_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Cë malaika okobo nïnë nï, “Kür ilwor, Maria, inwongo gum kï both Obanga. ");
INSERT INTO lth_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","In ibino yac ëka ïnywölö athïn awobi, cë ibino cakö nyïngë Yecu. ");
INSERT INTO lth_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ën bino bedo na dit, n'ebino cwodo nï Wod k'Obanga na Malö Rwök. Rwoth Obanga bino mïö ën twër, më then ker kite n'ëmïö both kwarö mërë Daudi. ");
INSERT INTO lth_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ën bino löönö jö më öt ka Jakob na twal, ëka ker mërë ba bino jik.” ");
INSERT INTO lth_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria openyo malaika nï, “Köp ni bino tïmërë nïngö? Nakun ba angeo ëcwö mörö!” ");
INSERT INTO lth_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaika ögamö nïnë nï, “Tipo Naleng bino bino bothi ëka tëkö k'Obanga na Malö Rwök bino umoni na calö tipo. Pï manön, athïn n'ënywölö ni Leng, ëka ebino cwodo nï Wod k'Obanga. ");
INSERT INTO lth_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nën wadwu Elicabeth dong öyac ï wi tio mërë, bino nywölö athïn awobi. Ën yam ecwodo nï alür kobedi dong ut kï ïc më dwethe abicël. ");
INSERT INTO lth_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pïën gin mörö ope na löö Obanga.” ");
INSERT INTO lth_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Cë Maria okobo nï, “An atic ka Rwoth ëk obed kite na in ikobo ködë.” Cë malaika öya ökö kï bothe. ");
INSERT INTO lth_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kinge karë na nönök, Maria öya, pïöpïö öcïdhö ï taun mörö n'otingere ï Yudea. ");
INSERT INTO lth_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Cë ödönyö ï öt ka Jakaria, omotho Elicabeth. ");
INSERT INTO lth_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ka Elicabeth owinyo moth ka Maria, athïn mërë oyengere kï ïë. Elicabeth opong kï Tipo Naleng. ");
INSERT INTO lth_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ën oredo kï dwön na ut malö nï, “Iut kï gum ï kin mon, ëka athïn na in ibino nywölö nï kome gum. ");
INSERT INTO lth_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Pïngö eketho wörö ï koma n'aya ka Rwoth twal obino më lïmöna? ");
INSERT INTO lth_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Anaka awinyo mothni, athïn kï ïa oyengere kï yom cwiny. ");
INSERT INTO lth_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Komi gum in nï yeo köp ka Rwoth pïën köp na Rwoth okobo nini bino cobere.” ");
INSERT INTO lth_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria okobo nï, “Tipona pakö Rwoth, ");
INSERT INTO lth_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","cwinya yom ï kom Obanga Alarna, ");
INSERT INTO lth_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Pïën ën öparö pï atic mërë, kadï bed rwöm mërë ute pïny. Cakërë kobedini, jö më karë kïbëc bino cwodona nï akome gum. ");
INSERT INTO lth_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Obanga Won Twër ötïmö gin na döngö pïra, Ën nyïngë leng. ");
INSERT INTO lth_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ën nyutho kïca mërë both jö na winyo ën pï karë kïbëc. ");
INSERT INTO lth_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Badë na ute kï tëkö, otio tic na döngö. Wegi awaka ï cwinygï ëkëthö ökö. ");
INSERT INTO lth_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ën ötürö löc ka rwodhi, ëka otingo jö na bwönërë malö. ");
INSERT INTO lth_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ën ömïö cem ëka jami na bëcö both jö na kec neko, ëka öryëmö ëlönyö kï cïng-gï nono. ");
INSERT INTO lth_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Obanga ökönyö etic mërë Icarael. Ën opo më tïmö kïca, ");
INSERT INTO lth_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","both Abraam ëka ëkwaë mërë kïbëc, kite na yam öcïkërë ködë both kwerewa.” ");
INSERT INTO lth_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria obedo both Elicabeth na römö dwethe adek, cë ödök yo parë. ");
INSERT INTO lth_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na karë më nywöl k'Elicabeth dong örömö, cë önywölö athïn awobi. ");
INSERT INTO lth_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na dong ewodhe ëka wede owinyo gïnï nï Rwoth onyutho kïca mërë na dit ï kome, cwinygï obedo na yom kanya acël ködë. ");
INSERT INTO lth_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ï karë n'athïn dong örömö nïnö aboro, obino gïnï ï kwer më lïrö athïn. Ömïtö gïnï cakö nyïngë kï nyïng apap mërë Jakaria. ");
INSERT INTO lth_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ëntö aya mërë ögamö nï, “Pathï kömanön nyïngë bino bedo Jon!” ");
INSERT INTO lth_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Gïn okobo nïnë nï, “Ba ut ngat mörö na nyïngë obedo kömanön ï dhogolawu kïbëc yo.” ");
INSERT INTO lth_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Cë ögwëlö gïnï apap k'athïn më penyo nï ën mïtö nï ëcak nyïng athïn nga? ");
INSERT INTO lth_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ën openyo gin mörö ëk ëcöö ïë, cë öcöö nï, “Nyïngë Jon.” Ëka jö kïbëc ouro. ");
INSERT INTO lth_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Cücüth, lëb Jakaria öyabërë, cë öcakö twak ëka öpakö Obanga. ");
INSERT INTO lth_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Lworo ömakö jö kïbëc na bedo cwök ï ngetgï. Köp ni kïbëc ökëë örömö lobo n'otingere ï Yudea. ");
INSERT INTO lth_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jö kïbëc n'owinyo gïnï köp ni öthamö gïnï rwök na kobo gïnï nï, “Athïn ni kothe bino bedo nïngö?” Pïën tëkö ka Rwoth onwongo ut ködë. ");
INSERT INTO lth_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Cë apap mërë Jakaria opong kï Tipo Naleng ëka ötwak kamë adwarpïny nï, ");
INSERT INTO lth_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pak obed both Rwoth Obanga ka jö Icarael, pïën dong obino më könyö jögë ëka ökökögï. ");
INSERT INTO lth_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ën ömïöwa Alar na tëk kï ï öt k'atic mërë Daudi. ");
INSERT INTO lth_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Na calö yam öcïkërë ködë nakun wok kï both edwarpïny mërë na leng cakërë cön. ");
INSERT INTO lth_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ën bino laröwa kï both langwa, ëka bino laröwa kï cïng jö kïbëc na dagöwa. ");
INSERT INTO lth_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Obanga obedo kï kïca both kwerewa, ëka opo kï gïcïkërë mërë na leng. ");
INSERT INTO lth_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Man ënë cïkërë na ën okwongo both kwaröwa Abraam nï, ");
INSERT INTO lth_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ën bino laröwa kï both langwa, ëk ëwör Obanga abonge lworo, ");
INSERT INTO lth_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kï leng cwiny ëka kite atïr ï nyime ka pod onu ëkwö. ");
INSERT INTO lth_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“In athïn-na, ebino cwodoni nï adwarpïny k'Obanga na Malö Rwök, in ibino cïdhö anyim më yübö yoo nï Rwoth, ");
INSERT INTO lth_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","më kobo nï jögë kite më nwongo larë ï yoo më tïmö kïca pï balgï. ");
INSERT INTO lth_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Pï kïca k'Obanga na thwönë n'öwëkö pïny oruu nïwa, tar mërë kï ï polo dong cwök ka mënyö onu, ");
INSERT INTO lth_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","më mënyö jö na ut ï pïny na cöl ëka ï tipo më thöö, ëka më tëlö onu ï yoo më kuc.” ");
INSERT INTO lth_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jon ödöngö ëka Tipo Naleng ömïö ën tëkö. Ën obedo ï thim naka na dong öcakö tic mërë kanyalër both jö Icarael. ");
INSERT INTO lth_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ï karë nonu, na dong ënywölö Jon Abatica, Cija Agucito onwongo obedo rwoth më lobo Roma. Ën ömïö cïk nï ëk ëkwan jö kïbëc më lobo na ën löö. ");
INSERT INTO lth_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Man obedo kwanö jïï më acël n'ötïmërë ï karë na Kwirino obedo alöc më lobo Ciria. ");
INSERT INTO lth_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jö kïbëc öcïdhö ëk ëkwan-gï yo taun ka kweregï. ");
INSERT INTO lth_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yocepu mene öya kï ï lobo më Galilaya kï ï taun n'ecwodo nï Najaret, öcïdhö yo lobo Yudea ï taun n'ecwodo nï Bethelem, kany na yam ënywölö Daudi ïë. Ën yam obedo ngat acël ï kin ëkwaë ka Daudi. ");
INSERT INTO lth_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Öcïdhö ëk ëkwanë gïn kï Maria, n'onwongo ën öcïkërë më nyömö ëka onwongo dong ute kï ïë. ");
INSERT INTO lth_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na gïn ut ï Bethelem, karë ka Maria më nywöl örömö. ");
INSERT INTO lth_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ën önywölö athïn kaö mërë wode ëka oumo kome kï böngü k'athïn. Cë opyelo ï pwa më cem ka dhok, pïën onwongo kabuto opong ökö nïgï ï öt apanga pï wele. ");
INSERT INTO lth_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kiwor nön, ëkwath onwongo kwö ëka gwökö romgï ï thim na cwök kï Bethelem. ");
INSERT INTO lth_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Malaika ka Rwoth onen bothgï, ëka tar ka Rwoth öryëny ömënyögï, cë lworo ömakögï rwök. ");
INSERT INTO lth_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ëntö malaika okobo nïgï nï, “Kür ibed unu kï lworo, pïën akelo niwu emuth na bër më yom cwiny na dit na bino bedo pï jö kïbëc. ");
INSERT INTO lth_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tin ï taun ka Daudi ënywölö niwu Alar, ënë Meciya Rwoth. ");
INSERT INTO lth_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Man ënë bino bedo anyuth bothwu. Ibino unu nwongo athïn na mar n'eboo kï böngü k'athïn, n'epyelo obuto ï öd pwa cem ka dhok.” ");
INSERT INTO lth_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Athura, lwak emalaika më polo örïbërë kï malaika nön, na pakö gïnï Obanga ëka kobo nï, ");
INSERT INTO lth_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dheo obed both Obanga na ute malö ï polo, ëka kuc obed ï lobo both jö n'Obanga ömïögï kïca mërë!” ");
INSERT INTO lth_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ï karë na dong emalaika öya ökö kï bothgï cë ödök yo polo, ëkwath nön ötwak kën-gï nï, “Eru ecidhu kono yo Bethelem, ëk ëcïdh enenu ngö n'ötïmërë na Rwoth pod okobo nï onu.” ");
INSERT INTO lth_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Gïn öcakö cïdhö pïöpïö, onwongo gïnï Maria gïn kï Yocepu, ëka athïn n'obuto ï od pwa cem dhok. ");
INSERT INTO lth_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Na gïn dong önënö athïn, ëkwath örwëö both jö kïbëc köp na yam ekobo nïgï ï kom athïn nön. ");
INSERT INTO lth_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jö kïbëc n'owinyo ouro köp n'ëkwath okobo nïgï. ");
INSERT INTO lth_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ëka Maria obedo gwökö köp ni kïbëc ï cwinye ëka obedo thamö ï komgï. ");
INSERT INTO lth_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ëkwath ödök cen na wörö ëka pakö gïnï Obanga pï gin na kïbëc na gïn owinyo ëka önënö, kite na malaika okobo nïgï ködë. ");
INSERT INTO lth_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ï nïnö më aboro ëlïrö athïn nön cë ëcakö nyïngë Yecu. Man ënë nyïng na yam malaika ömïö na bara ëgamö ën ï ïc. ");
INSERT INTO lth_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na karë më kwer më lönyërë na lübërë kï cïk ka Muca dong othum, Yocepu ëka Maria otero Yecu yo Jerucalem co mïö ën both Rwoth. ");
INSERT INTO lth_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Kite n'ëcöö ködë ï cïk ka Rwoth, “Ëthïnö kaö kïbëc na cwö myero ëmïï both Rwoth”). ");
INSERT INTO lth_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ëka thon kite n'ëcöö ï Cïk ka Rwoth nï enyodo myero thon ömïï tyër n'obedo, “Amame arïö, onyo ëthïn akuce arïö.” ");
INSERT INTO lth_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ï karë nonu, onwongo ëcwö mörö na nyïngë Cimeon ute ï Jerucalem, n'onwongo kite atïr ëka lworo Obanga. Ën onwongo kürö Kiricito na bino larö jö Icarael. Tipo Naleng onwongo tëlö ën. ");
INSERT INTO lth_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yam Tipo Naleng onyutho nïnë nï ën ba bino thöö wang na ën önënö Kiricito na yam Rwoth öcïkö both jö Icarael. ");
INSERT INTO lth_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kï tëkö ka Tipo Naleng, ën öcïdhö yo dyekal öt k'Obanga. Ï karë n'enyodo okelo athïn Yecu ëk ëtïm nïnë kit na cïk mïtö ködë. ");
INSERT INTO lth_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Cimeon otingo ën ï badë ëka öpakö Obanga, na kobo nï, ");
INSERT INTO lth_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Rwoth Obanga Won Twër ïgwökö kwongni köda, yee dong aticni öcïdh kï kuc. ");
INSERT INTO lth_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Pïën wanga dong önënö Alar, ");
INSERT INTO lth_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","na in ïyërö më larö jö kïbëc. ");
INSERT INTO lth_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ën bino kelo tar më cwiny both jö na ba obedo Eyuda, ëka pï dheo both jö na megi Icarael.” ");
INSERT INTO lth_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Apap ëka aya k'athïn ouro gïnï ngö n'ekobo ï kom Yecu. ");
INSERT INTO lth_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Cë Cimeon ölamö gum ï komgï ëka okobo n'aya mërë Maria nï, “Athïn ni bino mïö jö na pol kï ï lobo Icarael podho pïny ëka yaa malö, ëka bino bedo anyuth n'ebino twak ïë na rac, ");
INSERT INTO lth_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ëk tham më cwiny jö na pol omore yökö. Cwer cwiny bino cöböni calö ëcöbö cwinyi kï pala abadë.” ");
INSERT INTO lth_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Yam adwarpïny na dhakö tye na nyïngë Ana, nyaka Panuel më kaka Acer. Ën onwongo dong otii rwök. Kinge nyom mërë, ën ökwö kï cwörë pï mwaka abïrö. ");
INSERT INTO lth_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Cwörë onwongo öthöö ökö, ëka onwongo dong ut kï mwaka pyer aboro wie angwën. Ën ba öwëkö öt k'Obanga ëntö öwörö Obanga kiwor thon kiceng na rio kec ëka lëgö. ");
INSERT INTO lth_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ï caa nön Ana obino bothgï, cë öpwöyö Obanga, ëka ötwak pï athïn nön both jö kïbëc na yam kürö karë më larö jö Icarael. ");
INSERT INTO lth_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ï karë na Yocepu ëka Maria dong otyeko gin na kïbëc na cïk ka Rwoth ömïtö, gïn ödök yo lobo më Galilaya, yo taun-gï më Najaret. ");
INSERT INTO lth_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ëka athïn nön ödöngö cë ödökö na tëk, n'opong kï ryëkö ëka na kïca k'Obanga onwongo ute ï kome. ");
INSERT INTO lth_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mwaka kï mwaka enyodo ka Yecu onwongo cïdhö gïnï yo Jerucalem pï Karama më Poth. ");
INSERT INTO lth_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ï karë na Yecu dong ute kï mwaka apar arïö, gïn öcïdhö kunön ï Karama më Poth na lübërë kï cïk më thëkwarögï. ");
INSERT INTO lth_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na Karama më Poth nön dong othum, n'enyodo mërë dök yo pacö, athïn Yecu odong ökö cen ï Jerucalem, n'enyodo mërë ba ongeo. ");
INSERT INTO lth_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Na thamö gïnï nï ködë ën ute ï kin ewodhe, gïn owotho pï nïnö acël cë ëcakö rangö ën ï kin wede ëka nyikoneigï. ");
INSERT INTO lth_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ï karë n'enyodo ba onwongo ën, gïn ödök cen yo Jerucalem më cïdhö rangö ën. ");
INSERT INTO lth_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kinge nïnö adek enyodo mërë onwongo ën ï dyekal öt k'Obanga. Yecu onwongo obedo ï kin epwonye na winyogï ëka penyogï peny. ");
INSERT INTO lth_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jö kïbëc n'owinyo Yecu, ouro gïnï kit nïang ëka ryëkö mërë më gamö peny. ");
INSERT INTO lth_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","N'enyodo mërë önënö ën, gïn ouro aura. Aya mërë openyo ën nï, “Athïn-na, pïngö ïtïmöwa köman? Nën! An k'apapni ebedo rangöni kï par na dit.” ");
INSERT INTO lth_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ën ögamö nï, “Ïranga unu pïngö? Ba ingeo unu nï myero abed ï öt k'Apapna?” ");
INSERT INTO lth_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ëntö gïn ba önïang ngö n'onwongo ën kobo nïgï. ");
INSERT INTO lth_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Cë Yecu olungo ködgï yo Najaret, ëka obedo winyogï. Ëntö aya mërë ögwökö köp kïbëc ï cwinye. ");
INSERT INTO lth_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yecu ödöngö kï ryëkö ëka dit kome, kï pwöc k'Obanga ëka më dhanö. ");
INSERT INTO lth_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Onwongo obedo mwaka më apar abic më löc ka Cija Tiberio ï ker më Roma. Ï karë nön, Pontio Pilato onwongo obedo alöc më Yudea. Erode onwongo obedo alöc më Galilaya, ëka ömïn mërë Pilipo onwongo obedo alöc më Ituria ëka alöc më Tarakoniti. Ëka Lucania onwongo obedo alöc më lobo Abilene. ");
INSERT INTO lth_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anac ëka Kayapa onwongo obedo gïnï ëlamdhök na dito. Ï karë nonu, Jon Abatica wod ka Jakaria, owinyo köp k'Obanga n'onwongo ën ut ï thim. ");
INSERT INTO lth_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ën owotho ï lobe kïbëc n'örïkö kulo Jordan, nakun tïtö both jïï nï myero ongut gïnï kï kom balgï ëka ebaticagï, ëk Obanga ötïm nïgï kïca. ");
INSERT INTO lth_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kite n'ëcöö ködë ï buk k'adwarpïny Icaya nï, “Dwön dhanö mörö tye ka redo ï thim nï, ‘Yüb unu yoo pï Rwoth, mïï unu yoo ocung atïr nïnë. ");
INSERT INTO lth_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ora kïbëc myero epir ökö, kite kïbëc myero erwob ödök pïny na röm. Yodhi n'ogom mene myero ëmïï ocung atïr. Yodhi na gwaü bino dökö na pwöth. ");
INSERT INTO lth_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Cë jö kïbëc bino nënö lar k'Obanga.’ ” ");
INSERT INTO lth_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jon Abatica okobo nï lwak n'obino bothe ëk ebaticagï nï, “Un jö na reco calö ëthïn ororo! Nga n'okobo niwu nï ïrïng unu ökö kï ï akëmö k'Obanga na bino ni? ");
INSERT INTO lth_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kitewu myero onyuth nï inguto unu dong ökö kï kom balwu. Kür dök ïcak unu kobo ï kinwu kenwu nï, ‘Wan ëthïnö më dhogola k'Abraam.’ Ëk akob niwu nï kï ï kom kite ni, Obanga römö yübö ëthïnö pï Abraam. ");
INSERT INTO lth_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ngölö-köp k'Obanga obino ökö, na calö ngat n'ömakö atong më tongo yath. Yath na ba nyakö nyige na bër ebino tongo ökö pïny, cë ebolo ï mac.” ");
INSERT INTO lth_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lwak openyo Jon nï, “Ëtïm ngö dong?” ");
INSERT INTO lth_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon Abatica ögamö nïgï nï, “Ngat na ute kï böng arïö myero opok both ngat n'ope ködë, ëka ngat na ute kï cem myero ötïm mene kömanön.” ");
INSERT INTO lth_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ëcök ocoro mene obino ëk ebaticagï. Gïn openyo ën nï, “Apwony, wan myero ëtïm ngö?” ");
INSERT INTO lth_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ën okobo nïgï nï, “Kür ïcök unu ocoro na kadhö wel n'ëcïköwu ködë.” ");
INSERT INTO lth_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Acikari mökö öcakö penyo ën nï, “Cë wan kono ëtïm ngö?” Ën okobo nïgï nï, “Kür ïma unu cïlïng kï both dhanö mörö tëtëk, ëka kür idoth unu dhanö mörö twodo twodo. Ëntö yeng unu kï cülwu.” ");
INSERT INTO lth_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lwak onwongo kürö kï gen, na gïn kïbëc onwongo thamö kï ï cwinygï nï ködë ba Jon ënë obedo Meciya. ");
INSERT INTO lth_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Cë Jon Abatica ögamö nï, “An abaticawu kï pii, ëntö ngat mörö na dit na löa tye ka bino, na an ba apora më bedo atic mërë, ëka më gönyö thöl wörë. Ën bino baticawu kï Tipo Naleng ëka mac. ");
INSERT INTO lth_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ën bino poko jö na kitegï atïr kï kom jö na reco, na calö dhanö na pyëdhö bël k'odheru, ën cökö bël cë ketho ï od dërö. Ëntö ën bino wangö cüngë kï mac na ba bino nekere.” ");
INSERT INTO lth_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon Abatica okobo köp na bër n'eoro ën ködë kï köp nökënë na pol. Ën öcükö cwiny lwak më wëkö bal, ëka opwonyogï k'Emuth na Bër k'Obanga. ");
INSERT INTO lth_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ëntö Jon dökï öjükö rwoth Erode pï bedo kï Kerodia dhakö ka Pilipo n'obedo ömïn Erode, ëka pï ngö na reco kïbëc na ën obedo tïmö. ");
INSERT INTO lth_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Cë rwoth Erode dök ömëdö bal nökënë dökï na rac më tweo Jon ï buc. ");
INSERT INTO lth_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na Jon dong obatica jö kïbëc, Yecu thon ebatica. Ï caa na Yecu lëgö, polo öyabërë ");
INSERT INTO lth_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ëka Tipo Naleng obino kï malö ï cal k'amam cë opye ï kome. Cë dwön Obanga owinyere kï ï polo na kobo nï, “In ënë Woda na an amarö, na cwinya yom ï kome.” ");
INSERT INTO lth_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yecu onwongo dong ute kï mwaka pyer adek ï karë na ën cakö tic mërë. Jïï onwongo thamö nï ën obedo wod ka Yocepu. Yocepu ni onwongo obedo wod ka Eli. ");
INSERT INTO lth_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli onwongo obedo wod ka Mathat. Mathat onwongo obedo wod ka Lebi. Lebi onwongo obedo wod ka Melki. Melki onwongo obedo wod ka Janai. Janai onwongo obedo wod ka Yocepu. ");
INSERT INTO lth_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yocepu wod ka Matathia, Matathia wod k'Amoc, Amoc onwongo obedo wod ka Nakum. Nakum onwongo obedo wod ka Eceli. Eceli onwongo obedo wod ka Nagai. ");
INSERT INTO lth_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai onwongo obedo wod ka Math, Math onwongo obedo wod ka Matathia Matathia onwongo obedo wod ka Cemein Cemein onwongo obedo wod ka Yocek, Yocek onwongo obedo wod ka Yoda. ");
INSERT INTO lth_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda onwongo obedo wod ka Joanan. Joanan onwongo obedo wod ka Reca. Reca onwongo obedo wod ka Jerubabel. Jerubabel onwongo obedo wod ka Cealtiel. Cealtiel onwongo obedo wod ka Neri. ");
INSERT INTO lth_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri onwongo obedo wod ka Melki. Melki onwongo obedo wod k'Adi. Adi onwongo obedo wod ka Kocam. Kocam onwongo obedo wod ka Elemadam. Elemadam onwongo obedo wod ka Er. ");
INSERT INTO lth_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er onwongo obedo wod ka Yocua. Yocua onwongo obedo wod ka Elieja. Elieja onwongo obedo wod ka Yorim. Yorim onwongo obedo wod ka Mathat. Mathat onwongo obedo wod ka Lebi. ");
INSERT INTO lth_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lebi onwongo obedo wod ka Cimeon. Cimeon onwongo obedo wod ka Yuda. Yuda onwongo obedo wod ka Yocepu. Yocepu onwongo obedo wod ka Yonam. Yonam onwongo obedo wod ka Eliakim. ");
INSERT INTO lth_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim onwongo obedo wod ka Melea. Melea onwongo obedo wod ka Mena. Mena onwongo obedo wod ka Matatha. Matatha onwongo obedo wod ka Natan. Natan onwongo obedo wod ka Daudi. ");
INSERT INTO lth_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daudi onwongo obedo wod ka Jece. Jece onwongo obedo wod k'Obed. Obed onwongo obedo wod ka Boaj. Boaj onwongo obedo wod ka Calomon. Calomon onwongo obedo wod ka Nacon. ");
INSERT INTO lth_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nacon onwongo obedo wod k'Aminadab. Aminadab onwongo obedo wod k'Adimin. Adimin onwongo obedo wod k'Arni. Arni onwongo obedo wod ka Kejeron Kejeron onwongo obedo wod ka Perej. Perej onwongo obedo wod ka Yuda. ");
INSERT INTO lth_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda onwongo obedo wod ka Jakob. Jakob onwongo obedo wod ka Icaka. Icaka onwongo obedo wod k'Abraam. Abraam onwongo obedo wod ka Tera. Tera onwongo obedo wod ka Nakor. ");
INSERT INTO lth_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor onwongo obedo wod ka Cerug. Cerug onwongo obedo wod ka Reu. Reu onwongo obedo wod ka Peleg. Peleg onwongo obedo wod ka Eber. Eber onwongo obedo wod ka Cela. ");
INSERT INTO lth_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cela onwongo obedo wod ka Kainan. Kainan onwongo obedo wod k'Apacad. Apacad onwongo obedo wod ka Cem. Cem onwongo obedo wod ka Noa. Noa onwongo obedo wod ka Lamek. ");
INSERT INTO lth_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek onwongo obedo wod ka Methucela. Methucela onwongo obedo wod ka Enok. Enok onwongo obedo wod ka Jared. Jared onwongo obedo wod ka Maalalel. Maalalel onwongo obedo wod ka Kainan. ");
INSERT INTO lth_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan onwongo obedo wod ka Enoc. Enoc onwongo obedo wod ka Ceth. Ceth onwongo obedo wod k'Adam. Adam onwongo obedo wod k'Obanga. ");
INSERT INTO lth_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Yecu odwogo kï ï kulo Jordan nakun opong kï Tipo Naleng, ëka Tipo Naleng otero ën yo thim pï nïnö pyer angwën. Ï thim kunön Catan onwongo obedo tëmö ën. Yecu ba öcamö gin mörö pï nïnö nonu kïbëc, na karë nön dong othum kec oneko ën rwök. ");
INSERT INTO lth_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Cë Catan obino bothe ëka okobo nï Yecu nï, “Ka adyer in ënë Wod k'Obanga, lök kidi ni ödök ogati ëk ïcam.” ");
INSERT INTO lth_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yecu ögamö nïnë nï, “Ëcöö ï Cöc na Leng nï, ‘dhanö ba kwö kï cem këkën.’ ” ");
INSERT INTO lth_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kinge nön, Catan otero Yecu malö, cë pï karë na nönök këkën, onyutho nïnë ker kïbëc më wi lobo. ");
INSERT INTO lth_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Catan okobo nï Yecu nï, “Abino mïöni twër më lobo ëka jami kïbëc na bër na ut ïë, pïën ëmïa twër nön ökö, ëka arömö mïö both ngat na an amïtö. ");
INSERT INTO lth_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pï manön ka ïwöra, twër nön kïbëc abino mïö bothi.” ");
INSERT INTO lth_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Cë Yecu ögamö nï, “Ëcöö ï Buk na Leng nï, ‘Wör Rwoth Obangani ëka itii nïnë këkën.’ ” ");
INSERT INTO lth_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Catan öcakö tero Yecu yo Jerucalem ëka ömïö ën ocung ï ajiki midimidi malö më wi öt k'Obanga. Cë okobo nïnë nï, “Ka adyer in ënë Wod k'Obanga, pye pïny kï kany. ");
INSERT INTO lth_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pïën ëcöö ï Buk na Leng nï, “ ‘Ën bino cïkö emalaika mërë më gwököni na bër, ");
INSERT INTO lth_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","gïn bino tingoni kï cïng-gï, ëk kür ipodh ïwan tyeni ï kidi.’ ” ");
INSERT INTO lth_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yecu ögamö nï, “Ëcöö ï Buk Na leng nï, ‘Kür ïtëm Rwoth Obangani.’ ” ");
INSERT INTO lth_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Na dong otyeko tëmö Yecu kï yodhi kïbëc na ën twërö, Catan öcïdhö ökö kï bothe, na kürö karë nökënë n'opore më tëmö ën dökï. ");
INSERT INTO lth_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Cë Yecu ödök yo Galilaya kï twër ka Tipo Naleng. Emuth ï kom Yecu ökëë ï lobo nön kïbëc. ");
INSERT INTO lth_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ën obedo pwony ï od cinagogagï ëka jö kïbëc öpakö Yecu. ");
INSERT INTO lth_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yecu öcïdhö yo pacö më Najaret, kanya nene ën ödöngö ïë. Ï ceng cabït k'Eyuda, ën öcïdhö yo cinagoga, kite n'önaa tïmö ködë. Öya malö cë ocung më kwan kï ï Buk na Leng. ");
INSERT INTO lth_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ëmïö ën buk adöla k'adwarpïny Icaya, cë öyarö buk nön ëka onwongo kany ëcöö ïë nï, ");
INSERT INTO lth_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tipo Naleng ka Rwoth ute ï koma më könyöna, pïën Obanga owira, më kobo köp më Emuth na Bër both ëcan. Ën oora më kobo nï ebino gönyö emabuc ökö, ëka më mïö ëthöö wang nënö pïny, më gönyö jö n'ëdïögï ï yoo na ba opore, ");
INSERT INTO lth_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ën thon oora më mïö ngec nï, man ënë karë na Rwoth öyübö më nyutho kïca both jögë.” ");
INSERT INTO lth_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yecu ödölö buk adöla, ödwökö both aköny tic ï od cinagoga, cë obedo pïny. Jö kïbëc n'onwongo ute ï od cinagoga öcïkö wang-gï rwök ï kome. ");
INSERT INTO lth_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Cë öcakö pwonyogï na kobo nïgï nï, “Köp na an akwanö kï ï Cöc na Leng, ocobere tin.” ");
INSERT INTO lth_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jö kïbëc n'owinyo ën okobo nï pwony mërë bër. Gïn ouro köp na bër n'öya kï ï dhögë, cë openyere gïnï kën-gï nï, “Pathï man ënë wod ka Yocepu?” ");
INSERT INTO lth_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yecu okobo nïgï nï, “Angeo adyer nï ïya unu më bolo nïna carolok na kobo nï, ‘Daktar, cangiri keni! Tïm ï pacö thurwu kany koth tango na wan ewinyo nï ibedo tïmö ï Kaperanaum.’ ” ");
INSERT INTO lth_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ën ömëdërë nï, “An akobo niwu köp adyer nï, adwarpïny mörö ope n'ëmarö kï thurgï. ");
INSERT INTO lth_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tye adyer nï, mon thöö onwongo ute na pol ï lobo Icarael ï karë k'adwarpïny Eliya. Ï karë nonu Obanga otweo köth ökö pï mwaka adek kï nucu, cë kec ërön opodho ï lobo Icarael thükül. ");
INSERT INTO lth_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Obanga onwongo ba ooro adwarpïny mërë Eliya bothgï, ëntö ooro ën both dha thöö mörö n'onwongo bedo ï pacö Jarepat na cwök kï Cidon. ");
INSERT INTO lth_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ï karë k'adwarpïny Elica ï lobo më Icarael, onwongo jö na pol ute n'obedo ëdhöbü. Ëntö ngat mörö ope na ën öcangö kï ï kin-gï, Naaman këkën n'onwongo obedo dhanö më lobo Ciria.” ");
INSERT INTO lth_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jö kïbëc n'obedo ï od cinagoga ökëcö gïnï rwök ï karë na gïn owinyo ngö na Yecu okobo. ");
INSERT INTO lth_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Gïn öya malö cë öryëmö gïnï Yecu ökö kï ï taun. Otero gïnï ën naka yo ajiki malö wi cere n'ëgërö taun më Najaret ïë. Gïn onwongo mïtö thwaro Yecu yo pïny ëk öthöö ökö. ");
INSERT INTO lth_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ëntö ën owok ï kin-gï cë öcïdhö ökö. ");
INSERT INTO lth_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Cë Yecu öcïdhö yo Kaperanaum ï taun na dit më Galilaya. Ï ceng cabït k'Eyuda ën ödönyö ï cinagoga cë öcakö pwonyogï. ");
INSERT INTO lth_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na ën obedo pwony, lwak ouro kite na ën ötwak ködë kï twërö. ");
INSERT INTO lth_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ëcwö mörö na cen ömakö onwongo ute ï od cinagoga kanya Yecu obedo pwony ïë. Ëcwö nön oredo rwök nï, ");
INSERT INTO lth_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Uthukui! Yecu më Najaret, ngö na in ïmïtö kï bothwa? Ibino më tyekowa ökö? Angeo ngat na in ibedo, ngat Na leng n'Obanga ooro!” ");
INSERT INTO lth_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yecu ocoko cen nï, “Lïng ökö, ëka donyi ökö kï ï kome!” Cë cen örëdhö ëcwö nön ï dye öt ï nyim lwak kïbëc, ëka odonyo yökö kï ï kome na ba öwanö ën. ");
INSERT INTO lth_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jö kïbëc na ute kany nön ouro rwök, cë openyere gïnï kën-gï nï, “Koth pwony mënë ene? Ën ute kï thwön twër ëka tëkö, na ka öcïkö nï tipo na rac nï odonyi yökö, gïn donyo yökö!” ");
INSERT INTO lth_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Emuth ï kom Yecu ökëë kanya kïbëc ï lobo nön. ");
INSERT INTO lth_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kinge na Yecu odonyo yökö kï ï öt cinagoga, ën öcïdhö ödönyö ï öt ka Cimon. Marö ka Cimon onwongo ute kunön kï two lyetho n'ödïö ën rwök, cë gïn ökwaö Yecu nï ëk öcang ën. ");
INSERT INTO lth_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Cë Yecu ocung ï nget atwo, ëka öcïkö nï two lyetho öya ökö. Cücüth atwo öcang ökö, ëka öya malö cë otedo nïgï cem. ");
INSERT INTO lth_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na ceng dong dönyö adönya, jïï okelo etwoe n'onwongo ute kï koth two na papath both Yecu. Ën oketho cïngë ï kom ngat acëlacël, cë öcangögï kïbëc. ");
INSERT INTO lth_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Cene thon öya ökö kï ï kom jö na pol, na kok gïnï nï, “In ënë Wod k'Obanga!” Ëntö Yecu ocokogï ëka ba oyeo nïgï më twak, pïën onwongo gïn ongeo nï ënë obedo Meciya. ");
INSERT INTO lth_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na pïny dong oru kodiko cön, Yecu öya ökö kï ï pacö më Kaperanaum cë öcïdhö yo kanya lik. Lwak jö na pol öcakö lübö ën, ëka othuno gïnï ï kabedo n'onwongo ën ute ïë. Na gïn dong önënö ën ötëmö gïnï jükö ën, ëk kür öwëk kabedo nön. ");
INSERT INTO lth_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ëntö ën okobo nïgï nï, “An myero acïdh ï peci nökënë thon më kobo köp më Emuth na Bër më ker k'Obanga, pïën man ënë gin ömïö eora.” ");
INSERT INTO lth_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Cë Yecu öcïdhö ï peci na pol na ut ï Yudea, kanya ötïtö köp më Emuth na Bër ï cinagoga. ");
INSERT INTO lth_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ï nïnö mörö acël na Yecu ocung ï dhö nam më Genecaret, jïï opong na rïdërë gïnï më winyo köp k'Obanga. ");
INSERT INTO lth_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yecu önënö yeya arïö ï lak kulo n'ëmak rëc öwëkö kunön ëka onwongo lwökö böögï. ");
INSERT INTO lth_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ën ödönyö ï yeya acël, man onwongo obedo më ka Cimon, ëka okobo nïnë më cwarö yeya ökö na nönök kï lak kulo. Cë Yecu obedo ï yeya ëka opwonyo lwak. ");
INSERT INTO lth_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Na dong otyeko pwony mërë, ën okobo nï Cimon nï, “Ter yeyani ï dyere nam kanya thuth ëk ibol unu bööwu ï pii cë ïmak unu rëc.” ");
INSERT INTO lth_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Cimon ögamö nï, “Rwoth, wan etio na tëk wor kia ëka ba ëmakö gin mörö. Ëntö kite na in ikobo ködë, abino bolo böö rëcna.” ");
INSERT INTO lth_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na gïn dong ötïmö kömanön, gïn ömakö rëc na pol naka böögï öcakö yëc. ");
INSERT INTO lth_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Cë dong gïn ocwodo ewodhgï na ute ï yeya nökënë nï ëk obin ökönygï. Ï karë n'obino gïnï, opongo gïnï yeya arïö kï rëc ökö ëka yeya öcakö lüny. ");
INSERT INTO lth_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ï karë na Cimon Petero önënö gin nön, orumo cöngë pïny ï tyën Yecu ëka okobo nï, “Rwoth cïdh ökö kï botha, pïën an abedo abal!” ");
INSERT INTO lth_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Petero ëka ewodhe ouro gïnï lwak rëc na gïn ëmakö. ");
INSERT INTO lth_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ewodhe, Yakobo ëka Jon, awope ka Jebedayo, ouro gïnï thon. Ëka Yecu okobo nï Cimon nï, “Kür ibed kï lworo, cakërë ï caa ni cïdhö ködë anyim, ibino bedo amak jïï nakaka makö rëc.” ");
INSERT INTO lth_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Gïn öywaö yeyagï ï lak kulo, cë gïn öjalö jami kïbëc ëka ölübö gïnï kör Yecu. ");
INSERT INTO lth_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ï karë na Yecu onwongo tye ï pacö mörö acël, ëcwö mörö obino na ut kï two dhöbü. Na ën önënö Yecu, orumo cöngë pïny cë okulo wangë ëka ökwaö Yecu nï, “Rwoth, ka ïmïtö, canga ëk abed na leng.” ");
INSERT INTO lth_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yecu öryëö cïngë ëka ogudo ëcwö nön, cë okobo nï, “An amïtö, komi dong obed na leng!” Cücüth two dhöbü öcang ökö. ");
INSERT INTO lth_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Cë Yecu okobo nïnë nï, “Kür ikob nï ngat mörö, ëntö cïdh inyuthiri both alamdhök. Cë ïmïï tyër na Muca öcïkö ëk jïï ongee nï in dong ecangi ökö.” ");
INSERT INTO lth_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ëntö emuth na makö kome ökëë örömö lobo, ëka n'ömïö jïï na pol rwök obino më winyo köp mërë ëk ëcang-gï kï ï kom twoegï. ");
INSERT INTO lth_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yecu ï karë mökö yaa cïdhö ökö yo kanya lik ëka lëgö. ");
INSERT INTO lth_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ï nïnö mörö acël Yecu onwongo pwonyo jïï. Eparicayo ëka epwony cïk mökö onwongo obino gïnï kï ï peci na papath më Galilaya, Yudea ëka Jerucalem, onwongo ute gïnï kunön. Tëkö ka Rwoth onwongo ut ködë më cangö etwoe. ");
INSERT INTO lth_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Cwö mökö obino n'otingo gïnï dhanö na two akwea kom ömakö. Gïn ötëmö më tero ën ï öt ëk epyel ï nyim Yecu. ");
INSERT INTO lth_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ba onwongo gïnï yoo më tero akome okwe ï nyim Yecu pïën lwak onwongo opong rwök. Cë gïn öïdhö malö ëka otuco gïnï wi öt. Gïn olwao akome okwe na ut ï ökëka pïny ï kin lwak naka ecibo ï nyim Yecu. ");
INSERT INTO lth_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Na Yecu önënö yeegï, ën okobo n'akome okwe nï, “Okona, dong atïmö nini kïca ï balni.” ");
INSERT INTO lth_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Eparicayo ëka epwony cïk ka Muca öcakö penyere gïnï kën-gï nï, “Ën thamö nï ënë nga na twakö köp më yanyö Obanga? Obanga këkën ënë twërö wëkö bal.” ");
INSERT INTO lth_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yecu ongeo ngö n'onwongo gïn thamö ëka openyogï nï, “Pïngö ï thamö unu köp ni kï ï cwinywu? ");
INSERT INTO lth_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mënë ënë yot: Më kobo nï, ‘Balni ëtïmö kïca ökö ïë,’ onyo më kobo nï, ‘Yaa malö ïcïdhï’? ");
INSERT INTO lth_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ëntö ëk ingee unu nï Wod ka Dhanö ut kï twër ï wi lobo më wëkö bal.” Cë Yecu okobo both dhanö na kome okwe nï, “An akobo nini, yaa malö, kwany ökëkani ëka ïcïdh yo pacö.” ");
INSERT INTO lth_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Cücüth öya malö ï nyimgï, ökwanyö ökëka n'onwongo ën obuto ïë cë ödök yo pacö na pakö Obanga. ");
INSERT INTO lth_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lwak kïbëc ouro ëka öpakö gïnï Obanga. Gïn opong kï lworo na kobo gïnï nï, “Ënënö gin më aura tin.” ");
INSERT INTO lth_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kinge manön, Yecu odonyo yökö cë önënö acök ocoro n'ecwodo nï Lebi obedo ï od cökö ocoro mërë. Yecu okobo nïnë nï, “Lüb köra.” ");
INSERT INTO lth_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lebi öya malö, öwëkö jami kïbëc, ëka ölübö Yecu. ");
INSERT INTO lth_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ëka Lebi öyübö cem na thwönë ï parë nï Yecu na calö welo mërë më awöra. Ï kin wele onwongo ute ëcök ocoro na pol kï jö nökënë. ");
INSERT INTO lth_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Man ömïö Eparicayo nökënë ëka epwony cïk ka Muca öngüngüta gïnï ï kom ëlübkör Yecu nakun penyogï nï, “Pïngö icemo ëka imedho unu k'ëcök ocoro n'obedo ëbal?” ");
INSERT INTO lth_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yecu ögamö nïgï nï, “Pathï Jö na komgï yot ënë mïtö daktar, ëntö etwoe. ");
INSERT INTO lth_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","An ba abino më cwodo jö na kitegï atïr, ëntö ëbal ëk ongut gïnï.” ");
INSERT INTO lth_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jö nön okobo both Yecu nï, “Ëlübkör Jon ëka më Eparicayo onwongo ut gïnï kï thëkwarö më rio kec karë kï karë ëka lëgö gïnï thon. Pïngö ëlübkori cemo ëka medho gïnï nïnö kïbëc?” ");
INSERT INTO lth_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yecu ögamö nïgï nï, “Wele k'anyom twërö rio kec n'anyom tye ködgï kanya acël? ");
INSERT INTO lth_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ëntö karë bino thuno n'ebino kwanyö anyom ökö kï bothgï cë gïn dong bino rio kec ï nïnö nön.” ");
INSERT INTO lth_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Dök obolo nïgï carolok nï, “Ba ut ngat mörö na yëcö opeke böngü na nyen më dapö böngü na cön na ën ruko. Ka ötïmö kömanön cë bino yëcö böngü na ën ruko na nyen ökö. Dök opeke nï kom böngü na nyen ba pore kï man otii. ");
INSERT INTO lth_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Dök ba ut ngat mörö na pïkö köngö ölök na nyen ï ocwe na cön, ka öpïkö, cë köngö ölök bino yëcö ocwe ökö, ocwe thon bal ökö. ");
INSERT INTO lth_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Thwara köngö ölök na nyen ëpïk ï ocwe na nyen. ");
INSERT INTO lth_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ba tye ngat mörö na ka ömadhö köngö ölök na cön cë dök mïtö man anyen thon, pïën bino kobo nï, ‘Thwara thwara man na cön.’ ” ");
INSERT INTO lth_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ï nïnö mörö acël më Cabït k'Eyuda, Yecu onwongo wok ï pwodho bël. Ëlübkörë öcakö rïdhö with bël ëka öngïnyö gïnï ï cïng-gï, cë omwodo gïnï. ");
INSERT INTO lth_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ëntö Eparicayo mökö openyo nï, “Pïngö un ïrïdhö with bël na cïk ökwërö nï kür etii ï ceng Cabït k'Eyuda?” ");
INSERT INTO lth_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yecu ögamö nïgï nï, “Un ba ïkwanö kï ï Cöc na Leng ngö na Daudi ötïmö ï karë na kec oneko ën k'ewodhe? ");
INSERT INTO lth_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ën ödönyö ï öt k'Obanga, ëka ökwanyö ogati n'ëtyërö both Obanga cë öcamö, na yam cïk ökwërö nï dhanö kür öcam kono ka ëlamdhök këkën. Ëka ën thon ömïö both ewodhe.” ");
INSERT INTO lth_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Cë Yecu okobo nïgï nï, “Wod ka dhanö ënë Rwoth më Cabït.” ");
INSERT INTO lth_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ï Cabït k'Eyuda nökënë Yecu ödönyö ï cinagoga ëka onwongo pwonyo. Ëcwö mörö onwongo ute kunön na badë okwe ökö. ");
INSERT INTO lth_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Eparicayo ëka epwony cïk onwongo kürö gïnï më nënö ka Yecu cangö ëcwö nön ï ceng Cabït ëk enwong gïnï yoo më dotho ën. ");
INSERT INTO lth_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ëntö Yecu ongeo ngö n'onwongo gïn thamö ëka okobo n'ëcwö na badë okwe nï, “Yaa malö ëka icung ï nyim jö kïbëc.” Ën öya malö ëka ocung. ");
INSERT INTO lth_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Cë Yecu okobo bothgï nï, “Apenyowu nï, ï ceng Cabït cïk yee nï ëtïm gin mörö na bër onyo gin mörö na rac ïë, ëlar kwö onyo enek aneka?” ");
INSERT INTO lth_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ën ongongolo wangë ï kin-gï kïbëc, cë okobo both ëcwö nön nï, “Ryë badi.” Ën öryëö badë, ëka badë öcang ökö. ");
INSERT INTO lth_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ëntö akëmö ömakögï na tëk, cë öyübö gïnï köp ï kin-gï kën-gï, ngö na myero ëtïm ï kom Yecu. ");
INSERT INTO lth_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ï karë nonu, Yecu öcïdhö ï wi kidi më lëga ïë ëka ölëgö both Obanga wor kia. ");
INSERT INTO lth_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na pïny dong oru, ocwodo ëlübkörë bothe ëka öyërö jö apar arïö kï kin-gï cë ömïögï nyïng nï ëkwëna. Nyïng-gï ene: ");
INSERT INTO lth_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Cimon (na ën öcakö nyïngë nï Petero), ëka ömïn mërë Anderiya, Yakobo ëka Jon, Pilipo ëka Batulumayo, ");
INSERT INTO lth_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo ëka Tomaci, Yakobo wod k'Alipayo, Cimon n'ecwodo nï dhanö na mïtö löckën, ");
INSERT INTO lth_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda wod ka Yakobo, ëka Yuda Ikariot, na yam oketho örörö ï kom Yecu. ");
INSERT INTO lth_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yecu obino pïny kï ï wi kidi kanya acël k'ëlübkörë. Na dong othuno ï ngöm kany opire cë ocung. Kï kunön ëlübkörë na pol ëka kï jö nökënë n'obino gïnï kï ï Yudea, kï ï pacö më Jerucalem, ëka kï ï dhö nam më Turo ëka Cidon ögürë gïnï kanya acël. ");
INSERT INTO lth_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Gïn onwongo obino më winyo pwony mërë ëk ëcang-gï kï ï kom twoegï, naka thon kï jö na cen na reco oyelogï, obino gïnï ëka ëcangögï. ");
INSERT INTO lth_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jö nön kïbëc ötëmö më gudo ën, pïën tëkö më cangö onwongo yaa kï ï kome ëka cangögï kïbëc. ");
INSERT INTO lth_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yecu ölökërë önënö ëlübkörë cë okobo bothgï nï, “Komwu gum un ëcan, pïën Ker k'Obanga obedo mewu. ");
INSERT INTO lth_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Komwu gum un jö na kec onekowu kobedini, pïën ibino yeng unu. Komwu gum un jö na kok kobedini, pïën ibino nyërö unu. ");
INSERT INTO lth_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Komwu gum ka jïï dagöwu, ka ëkwëdöwu ëka ëyanyöwu, ëbalö nyïngwu na rac, pï Wod ka dhanö. ");
INSERT INTO lth_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Lakërë unu ï nïnö nonu, nakun ipye unu kï yom cwiny, pïën cül n'ebino mïöwu më pwöc thwönë ï wi polo. Ëka ipo unu nï kweregï yam ötïmö edwarpïny kömanön. ");
INSERT INTO lth_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ëntö ibino nënö unu can un ëlönyö, pïën ityeko unu nwongo gin na kweo cwinywu ökö. ");
INSERT INTO lth_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Can ï komwu un jö na yeng kobedini, pïën kec bino nekowu. Ibino nënö unu can, un nï nyërö kobedini, pïën ibino kumo unu kï koko. ");
INSERT INTO lth_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ibino nënö unu can, ka jö kïbëc pwöyöwu, pïën kweregï yam öpwöyö gïnï edwarpïny n'etwodo kömanön. ");
INSERT INTO lth_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ëntö akobo niwu un jö nï winya, nï mar unu langwu, tïm unu gin na bër both jö na dagöwu. ");
INSERT INTO lth_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Lam unu gum ï kom jö na lamöwu, lëg unu pï jö na tïmö gin na rac bothwu. ");
INSERT INTO lth_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ka ngat mörö odhongo lemi acël, lök nïnë kucël thon ëk odhong. Ka ngat mörö mïtö catïni, mïë thon kotini. ");
INSERT INTO lth_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mïï both jö kïbëc na kwai gïnï ëka ka ngat mörö omai jamini, kür dök ï peny ëk odwongi nini. ");
INSERT INTO lth_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kite na un ïmïtö nï jïï ötïm niwu ködë, un thon tïm unu nïgï kömanön. ");
INSERT INTO lth_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ka ïmarö unu jö na maröwu, pwöc mënë nï nwongo unu kï ïë? Naka thon ëbal marö jö na marögï. ");
INSERT INTO lth_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ëka ka ïtïmö unu gin na bër both jö na tïmö gin na bër bothwu, pwöc mënë nï nwongo unu kï ïë? Naka thon ëbal tïmö kömanön. ");
INSERT INTO lth_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ëka ka ïmïö unu banya both jö na dwökö niwu, pwöc mënë nï nwongo unu kï ïë? Naka thon ëbal mïö banya both ëbal ewodhgï ëk ëcülgï na röm. ");
INSERT INTO lth_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ëntö mar unu langwu, tïm unu gin na bër nïgï ëka mïï unu nïgï den na ba igeno unu nï ebino cülö niwu dökï. Cë cül na mewu bino bedo na thwönë, ëka ibino bedo unu ëthïn ka Ngat na Malö Rwök pïën ën bër both jö na ba pwöyö ën, ëka both jö na reco. ");
INSERT INTO lth_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bed unu kï kïca na calö Apapwu obedo akïca. ");
INSERT INTO lth_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kür ïngöl unu köp both jö nökënë, ëka un thon ba ebino ngölö niwu köp. Kür ïngöl unu köp ölöö jö nökënë, ëka un thon ba ebino ngölö köp lööwu. Tïm unu kïca both jö nökënë, ëka un thon ebino tïmö niwu kïca. ");
INSERT INTO lth_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mïï unu both jö nökënë ëka un thon ebino mïöwu. Ëka jami n'ebino mïöwu ebino pimo niwu na bër. Gin n'epimo ködë na bër, n'eyengo, ëka ëdïlö na öny aönya, ebino mïöni. Gin na un ipimo ködë, ënë thon ebino pimo niwu ködë.” ");
INSERT INTO lth_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yecu dök okobo nïgï carolok nï, “Athöö wang twërö pëö athöö wang awodhe? Gïn arïö kïbëc ba bino podho ökö ï bur? ");
INSERT INTO lth_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Athïn kwan ba bedo na dit löö apwony mërë, ëntö dhanö kïbëc ka dong epwonyo na bër dökö na calö apwony mërë. ");
INSERT INTO lth_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Pïngö ïnënö cüng kal kï ï wang omeru, ëka ba ïnënö dul yath na tye ï wangi? ");
INSERT INTO lth_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","In ïtwërö kobo n'omeru nï, ‘Ömëra, ëk akwany cüng kal ökö kï ï wangi,’ nakun in kikomi ba ïnënö dul yath na ut ï wangi? In atwodo, cak kono kwanyö dul yath na ut ï wangi ökö, ëka dong ïnën pïny na bër më kwanyö cüng kal na ute ï wang omeru. ");
INSERT INTO lth_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Yath na bër ba twërö nyakö nyige na rac ëka yath na rac ba twërö nyakö nyige na bër. ");
INSERT INTO lth_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yath acëlacël engeo kï nyige. Dhanö ba püdö ölam kï kom öküdhö acar onyo nyig ölök kï kom öcöcök. ");
INSERT INTO lth_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dhanö na bër twakö gin na bër kï kin jami na bëcö na ën ökanö ï cwinye. Dhanö na rac twakö gin na rac kï kin jami na reco na ën ökanö ï cwinye. Pïën köp na dhanö kobo yaa kï kom ngö n'opong ï cwinye. ");
INSERT INTO lth_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Pïngö icwoda unu nï, ‘Rwoth, Rwoth,’ ëka ba ïtïmö unu gin na an akobo nï ïtïm unu? ");
INSERT INTO lth_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Dhanö acëlacël na bino botha, cë winyo köp na mëga, ëka ketho ï tic, abino nyuthiwu ngat na ën cal ködë. ");
INSERT INTO lth_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","“Ën cal kï dhanö n'ögërö öt n'ökünyö na thuth ëka ocibo thërë ï kom lëla. Ëka ka koth ocwe na thwönë cë pii opong, kïlëlë ömöl kï tëkö ï kom öt nonu. Ëntö ba oyengo pïën onwongo ëgërö na bër. ");
INSERT INTO lth_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ëntö ngat na winyo köpna ëka ba ketho ï tic, röm aröma kï dhanö n'ögërö öt ï kom ngöm abonge acaki thërë. Ka kulo opong cë ömöl kï tëkö ëka öcörö öt nön, öt rëdhërë pïny nï ruthukuny.” ");
INSERT INTO lth_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Na dong Yecu otyeko pwonyo köp nï kïbëc both lwak, ën ödök cen ï Kaperanaum. ");
INSERT INTO lth_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ï pacö nonu onwongo ute adit acikari më Roma. Dhanö ni onwongo ut k'atic na ën marö rwök. Atic ni onwongo two rwök na cwök thöö. ");
INSERT INTO lth_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ï karë n'adit acikari owinyo pï Yecu, ën ooro edong k'Eyuda mökö më cïdhö kwaö ën ëk obin öcang atic mërë. ");
INSERT INTO lth_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ï karë n'edong nön obino gïnï both Yecu, gïn ökwaö ën ëk owoth ködgï cë okobo gïnï nï, “Ngatï opore ëk ïcang atic mërë, ");
INSERT INTO lth_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","pïën marö Eyuda ëka thon ënë ögërö cinagoga nïwa.” ");
INSERT INTO lth_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Cë Yecu öcïdhö kanya acël k'edong nön. Na dong onyingo cwök kï pacö, adit acikari ooro nyikonei mökö më cïdhö kobo nïnë nï, “Rwoth, kür dök iloliri më bino ï pacöna, pïën an ba apora nï ëk ibin ïdöny ï öda. ");
INSERT INTO lth_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","An thon ba apora më bino romo kodi. Akwai ëk ikob nïna köp mörö kï kany iut ïë cë aticna bino cang. ");
INSERT INTO lth_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Pïën an thon abedo dhanö n'ëlöö alöa ï dhö tic, aut k'acikari thon na an alöögï. Ka akobo both acikarina mörö acël nï, ‘Cïdhï,’ cë cïdhö, onyo ka akobo nï, ‘Bin,’ cë bino. Ëka ka akobo both aticna nï, ‘Tïm man,’ cë tïmö.” ");
INSERT INTO lth_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ï karë na Yecu owinyo köp ni, ouro rwök. Ölökërë both jïï na lübö körë cë okobo nïgï nï, “Akobo niwu, bara anwongo ëcwö na ut kï yee na röm kï man ï lobo Icarael.” ");
INSERT INTO lth_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Cë jö n'onwongo eorogï ödök cen pacö, ëka onwongo gïnï atic öcang ökö. ");
INSERT INTO lth_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Cücüth kinge, Yecu k'ëlübkörë ëka lwak jö na pol öcïdhö gïnï ï taun n'ecwodo nï Nain. ");
INSERT INTO lth_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ï karë na ën onyingo na cwök kï dhö cël më taun nön, gïn önënö jö n'ölabö gïnï lyël k'awobi n'öthöö k'ëtana. Awobi ni onwongo obedo wod ka dha thöö acël këkën. Jö na pol më pacö nön owotho kanya acël kï dha thöö ni. ");
INSERT INTO lth_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na Rwoth önënö aya k'awobi nön, kïca ömakö ï kome, okobo nïnë nï, “Kür ikoki.” ");
INSERT INTO lth_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yecu öcïdhö cë ogudo canduk lyël ëka jïï n'onwongo ölabö athöö ni ocung gïnï moth. Ën okobo nï, “Awobi, akobo nini nï yaa malö!” ");
INSERT INTO lth_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Cücüth awobi ni ocer ökö cë öcakö twak. Yecu ömïö ën both aya mërë. ");
INSERT INTO lth_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jö kïbëc opong kï lworo ëka öcakö gïnï pakö Obanga nï, “Adwarpïny na dit obino ï kinwa, ëka Obanga obino më könyö jögë.” ");
INSERT INTO lth_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Emuth ï kom ngö na Yecu ötïmö ökëë örömö lobo Yudea kïbëc ëka kï lobo n'örïkö. ");
INSERT INTO lth_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ëlübkör Jon okobo nïnë jami kïbëc na Yecu ötïmö. Cë Jon ocwodo ëlübkörë arïö ");
INSERT INTO lth_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ëka oorogï both Rwoth më penyo ën nï, “In ënë Kiricito n'onwongo edwarpïny okobo nï bino, onyo ëkür dök ngat nökënë?” ");
INSERT INTO lth_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ï karë n'ëlübkör Jon öcïdhö gïnï both Yecu okobo gïnï nïnë nï, “Jon Abatica oorowa bothi ëk ebin epenyi nï, ‘In ënë Kiricito n'onwongo edwarpïny okobo nï bino, onyo ëkür dök ngat nökënë?’ ” ");
INSERT INTO lth_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ï caa nön onwongo Yecu öcangö etwoe na ut gïnï kï twoe na papath ëka tipo na reco. Ën thon ömïö ëthöö wang önënö pïny. ");
INSERT INTO lth_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Cë Yecu okobo nïgï nï, “Cïdh ikob unu both Jon ngö na un ïnënö ëka ngö na un iwinyo. Ëthöö wang önënö pïny, engwalo owotho, jö na ut kï two dhöbü öcang, edhing ith owinyo gïnï köp ëka jö n'öthöö ocer. Jö na ut kï can owinyo gïnï köp më Emuth na Bër. ");
INSERT INTO lth_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tye kï gum dhanö na ba lökërë ökö kï kom yee mërë pïra.” ");
INSERT INTO lth_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kinge na dong ëlübkör Jon ödök gïnï, Yecu öcakö twak kï jïï ï köp ï kom Jon nï, “Ngö na un ïcïdhö më nënö kï dye thim? Ïcïdhö unu më nënö agada na yamö yengo? ");
INSERT INTO lth_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ka ope, ngö na dong ïcïdhö unu më nënö? Dhanö n'oruko böng na wel mërë thwönë? Pe, jö na rukere gïnï kï böng na leng ëka ut gïnï kï jami na bëcö ënë bedo gïnï ï peci ka rwodhi. ");
INSERT INTO lth_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ëntö ngö na un ïcïdhö më nënö? Eyo, an akobo bothwu nï un ïnënö ngat na löö adwarpïny ökö. ");
INSERT INTO lth_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jon ënë obedo dhanö na Cöc na Leng cïmö na kobo nï, “ ‘Nën abino oro akwëna na bino cïdhö anyim nini, ënë bino yübö yooni na bara ibino.’ ” ");
INSERT INTO lth_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yecu okobo nï, “Akobo niwu, kï kin jö kïbëc na mon önywölö, ngat mörö ope na dit na löö Jon. Ëntö naka thon ngat na tïdï na löö kï ï Ker k'Obanga, dhanö nön thwönë na löö ën.” ");
INSERT INTO lth_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jö kïbëc naka thon ëcök ocoro, ï karë n'owinyo gïnï köp ka Yecu, oyee gïnï nï yoo k'Obanga tye atïr, pïën Jon onwongo obaticagï. ");
INSERT INTO lth_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ëntö Eparicayo ëka epwony cïk ka Muca ökwërö gïnï miti k'Obanga. Ëka ökwërö gïnï nï kür Jon obaticagï. ");
INSERT INTO lth_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yecu dök okobo nï, “Abino poro jö më karë ni kï ngö? Gïn cal kï ngö? ");
INSERT INTO lth_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gïn röm k'ëthïnö n'obedo ï cuk nakun kobo n'ëthïnö ewodhgï nï, “ ‘Wan ëküdhö oletu niwu, ëka ba ïmyëlö unu, ewero wer lyël, ëka un ba ikok.’ ");
INSERT INTO lth_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jon Abatica obino na ba camö kwon onyo madhö köngö ölök, ëka ikobo unu nï, ‘Ën ut kï cen ï kome.’ ");
INSERT INTO lth_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ëntö Wod ka Dhanö obino na cemo ëka medho, ëka un ikobo nï, ‘Ën obedo ngat n'owor ëka amërö! Ën thon obedo okone k'ëcök ocoro ëka “ëbal.” ’ ");
INSERT INTO lth_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ëntö ryëkö k'Obanga onen adyer both ëthïnë kïbëc na lübö.” ");
INSERT INTO lth_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ngat acël kï kin Eparicayo ocwodo Yecu më cïdhö cem ködë. Ën öcïdhö ï ödë cë obedo pïny ï dhö cem. ");
INSERT INTO lth_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Dhakö mörö n'obedo abal onwongo ut ï taun nön. Ï karë n'ongeo nï Yecu tye ï cem ï öt k'Aparicayo, cë okelo cupa möö na ngwece kur. ");
INSERT INTO lth_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ën obino cë ocung ï ngee Yecu kï kutyënë na kok naka pii wangë ötön ï tyën Yecu ëka odunyo kï yer wie. Önödhö tyën Yecu cë owiro kï möö na kur. ");
INSERT INTO lth_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ï karë n'Aparicayo önënö, ötwak kï ï cwinye kënë nï, “Kono dhanö ni obedo adwarpïny, onwongo twërö ngeeno dhakö n'ogude—nï obedo abal.” ");
INSERT INTO lth_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yecu okobo both Aparicayo nï, “Cimon, aut kï gin mörö na mïtö kobo nini.” Cimon ögamö nï, “Apwony, ngö ënön?” ");
INSERT INTO lth_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yecu okobo nïnë nï, “Yam tye ngat mörö n'ömïö cïlïng më den both jö arïö. Ngat acël onwongo ut kï banya më denario mia abic ëka awodhe nökënë ute kï pyer abic. ");
INSERT INTO lth_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ï karë na cülö banya ni ölöö jö arïö ni, won cïlïng öwëkö benyi nön ökö cë ötïmö nïgï kïca. Nga kï kin jö arïö ni na bino marö won cïlïng na löö?” ");
INSERT INTO lth_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Cimon ögamö nï, “Athamö nï ngat n'ëwëkö banya mërë na thwönë.” Yecu okobo nï, “In ïngölö kakarë.” ");
INSERT INTO lth_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Cë Yecu ölökërë both dhakö nön ëka openyo Cimon nï, “Ïnënö dhakö ni? An adönyö ï odi ba ïmïa pii më lwökö tyëna. Ëntö ën ötönö pii wangë ï tyëna cë odunyo kï yer wie. ");
INSERT INTO lth_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","In ba imotha ëka ba ïnödhö lema ëntö dhakö ni anaka ï caa n'adönyö ködë ï odi, ba öwëkö nödhö tyëna. ");
INSERT INTO lth_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","In ba ïgama kï önyö möö ï wia ëntö ën owiro tyëna kï möö na kur. ");
INSERT INTO lth_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pï manön akobo nini, bal mërë kïbëc ëtïmö kïca ökö ïë pïën mar mërë na ën onyutho thwönë. Ëntö ngat n'ëtïmö nïnë kïca pï bal mërë na nönök, nyutho mar mërë thon na nönök.” ");
INSERT INTO lth_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Cë Yecu okobo both dhakö nï, “Balni dong atïmö kïca ökö ïë.” ");
INSERT INTO lth_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jö n'obedo ködë ï dhö cem öcakö twak ï kin-gï nï, “Man nga na tïmö kïca thon ï kom bal?” ");
INSERT INTO lth_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ëntö Yecu okobo both dhakö nï, “In iyee kï ï cwinyi ënë ömïö dong ïlarë. Ëk Obanga omii kuc.” ");
INSERT INTO lth_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kinge man, Yecu owotho ï kin taun na döngö ëka peci gïnï, na tïtö köp më Emuth na Bër më Ker k'Obanga. Ëlübkörë apar arïö onwongo tye ködë kanya acël, ");
INSERT INTO lth_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ëka thon mon mökö n'onwongo ëcangögï kï kom tipo na reco ëka kï twoe. Mon ni ënë Maria më Magadala, na cen abïrö ëryëmö kï ï kome, ");
INSERT INTO lth_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana dhakö ka Cuja, adwong na löö öt k'Erode. Onwongo thon dhakö tye na nyïngë Cucana ëka mon nökënë na pol. Mon ni onwongo mïö jamigï më könyö Yecu ëka ëlübkörë. ");
INSERT INTO lth_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ï nïnö mörö acël, lwak na pol öya kï ï taun gïnï cë ögürë gïnï both Yecu. Ën öcakö pwonyogï kï carolok na kobo nï, ");
INSERT INTO lth_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Apur mörö öcïdhö më cwöönö kodhi mërë. Ï karë na ën tye ka cwöönö kodhi, kodhi mökö ökïr ï dye yoo, cë jïï önyönö ëka wïny na ngwëcö kï malö ödëdëpö ökö. ");
INSERT INTO lth_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ën ökënë ökïr ï dye lëla cë öcakö tuu, ëntö oner ökö pïën pii nönök. ");
INSERT INTO lth_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kodhi nökënë opodho ï kin okudhi cë otuu, ëntö öküdhö ödïö ökö. ");
INSERT INTO lth_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kodhi nökënë ökïr ï ngöm na bër. Kodhi ni otuu ëka ödöngö cë önyakö nyige na pol na löö ën na yam ëcwö wang mia acël.” Yecu otyeko twak kï dwön na malö nï, “Ngat na tye kï ithe më winyo, myero ën owiny!” ");
INSERT INTO lth_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ëlübkör Yecu openyo ën nï, “Ngö na carolok ni gönyö?” ");
INSERT INTO lth_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ën ögamö nï, “Müng më ryëkö më Ker k'Obanga, ëmïö dong ökö bothwu. Ëntö both jö nökënë an atwak kï carolok ëk, “ ‘Ka önënö gïnï, kür dök önën, dök ka owinyo gïnï, ba twërö nïang ïë.’ ");
INSERT INTO lth_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Carolok ni gönyö nï köman. Kodhi ënë köp k'Obanga. ");
INSERT INTO lth_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kodhi n'ökïr ï dye yoo ënë jö na winyo, ëka Catan bino cë kwanyö köp k'Obanga ökö kï ï cwinygï ëk kür oyee gïnï ëka ölarë. ");
INSERT INTO lth_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kodhi n'ökïr ï dye lëla cal gïnï kï jö na gamö köp k'Obanga kï yom cwiny ka gïn owinyo. Ëntö ope gïnï k'oriigï n'ödönyö pïny. Gïn yeo pï karë na nönök, ëntö ka ï karë më tëmögï, podho gïnï ökö. ");
INSERT INTO lth_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kodhi n'ökïr ï kin okudhi cal kï jö na winyo köp k'Obanga, ëntö na gïn tye ï wothgï ëdïögï kï kwö më par, lönyö ëka kwö na yot. Jami ni mïögï ba nyakö nyig-gï. ");
INSERT INTO lth_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ëntö kodhi n'ökïr ï ngöm na bër cal kï jö na winyo gïnï köp k'Obanga, moko ï cwinygï, ëka dïö cwinygï cë nyakö nyig-gï. ");
INSERT INTO lth_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ba tye ngat mörö na cwïnyö tara cë kanö ökö ï adïta onyo ketho ï thë ëtana. Ëntö eketho tara kany oten, kanya cara mërë twërö nen both jö kïbëc na dönyö gïnï ï öt. ");
INSERT INTO lth_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ba tye gin mörö n'ëkanö na ba ebino tuco, ëka ba tye gin mörö n'ebino kanö na ba ebino ngeeno. ");
INSERT INTO lth_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pï manön, nën unu na bër kite nï winyo unu kï köp ködë! Jö na bino winyo pwonyna, ebino mëdö nïgï më winyo na thwönë. Ëntö pï jö na ba winyo gïnï, naka thon ngö na gïn thamö nï ënïang ïë ebino gamö ökö kï bothgï.” ");
INSERT INTO lth_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Cë aya ka Yecu ëka utmego mërë obino më nënö ën. Ëntö gïn onwongo ba römö thuno ï ngete pïën lwak onwongo pol na dïrë gïnï. ");
INSERT INTO lth_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ngat mörö okobo nïnë, “Ayani ëka utmegoni ocung yökö, mïtö nënöni.” ");
INSERT INTO lth_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yecu ögamö nïnë nï, “Ayana ëka utmegona ënë jö na winyo köp k'Obanga ëka ketho gïnï ï tic.” ");
INSERT INTO lth_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ï nïnö mörö acël Yecu ëka ëlübkörë ödönyö gïnï ï yeya cë okobo nïgï nï, “Eru ëngöl nam yo löka tung ca.” Cë gïn öcakö wothgï yo kunön. ");
INSERT INTO lth_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Na gin ngölö ï nam, Yecu obuto pïny cë önïnö ökö. Cücüth yamö na ger öcakö kudho na tëk ï nam. Pii öcakö pong ï od yeya, öwëkö jö ni obedo ï thwön pëkö na rac. ");
INSERT INTO lth_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Cë ëlübkör Yecu öcïdhö ocoo ën, na redo gïnï nï, “Rwoth, Rwoth, wan ëcwök thöö ökö yo!” Ëka Yecu öya malö cë ocoko yamö na ger ëka kï pii nï ëk ocung. Yamö ocung, ëka pii okwe moth. ");
INSERT INTO lth_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yecu openyo ëlübkörë nï, “Kara yeewu tye kwene?” Gïn ouro ëka obedo kï lworo, ëka öcakö twak ï kin-gï këkën-gï nï, “Koth dhanö mënë ene? Na coko yamö ëka pii cë winyo dhögë!” ");
INSERT INTO lth_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yecu ëka ëlübkörë öngölö gïnï nam na cwök kï lobo më Galilaya, ëka othuno gïnï ï löka nam yo lobo ka jö Gereca. ");
INSERT INTO lth_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ï karë na Yecu donyo yökö kï ï yeya, ëcwö më taun nön n'onwongo cen ömakö obino më romo ködë. Pï karë na lac dhanö ni onwongo wotho kotula ëka onwongo ba bedo pacö ëntö onwongo kwö ï kin lyene. ");
INSERT INTO lth_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Cücüth tëk nënö Yecu, oredo rwök. Ën opodho ï nyim Yecu cë oredo na tëk nï, “Yecu, Wod k'Obanga na ën Na Malö Rwök! Ngö na in ïmïtö kï botha? Akwai, kür ipwoda!” ");
INSERT INTO lth_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ën okobo man pïën Yecu onwongo öcïkö nï tipo na rac odonyi yökö kï ï kome. Wang na pol cen dwogo ï kome, ömïö ëgwökö agwöka nakun nwongo etweo atwea kï nyör ëka kï nywenyo. Ëntö ën tütürö ngö n'etweo ködë ökö. Cen ryëmö tero ï thim yo kanyalik. ");
INSERT INTO lth_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yecu openyo ën, “Nyingi nga?” Ën ögamö, “Nyïnga Lejon,” pïën cene na pol onwongo opong ï kome. ");
INSERT INTO lth_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tipo na reco ömëdërë më kwaö Yecu ëk kür öryëmgï ï bur na thuth, kanya cene epwodogï ïë. ");
INSERT INTO lth_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ëthïpan pün onwongo cemo gïnï ï bad kidi. Cene ökwaö gïnï Yecu ëk oye nïgï ëdöny ï kom pün nön. Cë ën oyeo nïgï. ");
INSERT INTO lth_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na cene odonyo kï kom ëcwö ni, ödönyö gïnï ï kom pün, cë obino gïnï kï malö kï wi thur ëka ölüny gïnï ï nam. ");
INSERT INTO lth_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ï karë n'ëkwa pün önënö gïnï ngö n'ötïmërë, gïn öngwëcö më cïdhö rwëënö emuth ni ï kin taun gïnï ëka ï thwok lobo. ");
INSERT INTO lth_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jïï öcïdhö më nënö ngö n'ötïmërë ëka ï caa n'othuno gïnï both Yecu, onwongo gïnï ngat na cene ömakö bothe. Cene öya ökö kï ï kome ëka onwongo obedo ï nget Yecu. Ën onwongo orukere na leng ëka dong nïang. Ëntö jïï ödökö na lwor. ");
INSERT INTO lth_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Cë jö n'önënö ngö n'ötïmërë okobo gïnï both jïï kite na ngat n'onwongo cen ömakö öcang ködë. ");
INSERT INTO lth_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jö kïbëc n'obedo gïnï ï Gereca ëka kany örïkö lobo nön ökwaö Yecu nï myero öya ökö kï bothgï pïën lworo onwongo ömakögï rwök. Yecu ödönyö ï yeya cë ödök cen. ");
INSERT INTO lth_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dhanö na cen öya kï ï kome odweko Yecu ëk ewoth ködë. Ëntö Yecu ökwërö ökö cë okobo nïnë nï, ");
INSERT INTO lth_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Dök pacö ëk ïcïdh ikob ngö na thwönë n'Obanga ötïmö më cangöni.” Cë ëcwö ni owotho ï taun kïbëc ëka ötïtö gin na Yecu ötïmö më cangönë. ");
INSERT INTO lth_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ï karë na dong Yecu odwogo, lwak ögamö kï yom cwiny pïën onwongo gïn kïbëc kürö. ");
INSERT INTO lth_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dhanö mörö obino, na nyïngë Yairo n'onwongo adwong më cinagoga. Ën orumo cöngë pïny ï nyim Yecu ëka odweko nï öcïdh yo parë ");
INSERT INTO lth_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","pïën onwongo nyarë acël këkën na ut kï mwaka apar arïö two na dong cwök thöö. Na Yecu pod ut ï yoo, jö na pol obedo ka dïïnö ën. ");
INSERT INTO lth_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dhakö mörö onwongo ut kunön n'onwongo remo obedo cwer kï ï kome pï mwaka apar arïö na ba cok. Ën öbalö jami na ën ute ködë kïbëc both ëcang jö, ëntö ngat mörö onwongo ope na römö cangö ën. ");
INSERT INTO lth_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Cücüth ka ën opelo kï kungee Yecu, cë ogudo lak böngü ka Yecu. Cücüth remo na cwer ojik ökö. ");
INSERT INTO lth_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yecu openyo nï, “Nga n'oguda?” Jö kïbëc ökwërö gïnï ökö, cë Petero okobo nï, “Adwong jïï oriki dyere ëka tye ka thwaroni gïnï kï tung mörö këkën.” ");
INSERT INTO lth_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ëntö Yecu okobo nïgï nï, “Ngat mörö oguda, pïën awinyo tëkö më cangö dhanö ka yaa ökö kï ï koma.” ");
INSERT INTO lth_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dhakö ongeo nï ba ërömö pono, cë obino na kome myël ëka orumo cöngë pïny ï nyim Yecu. Ën okobo both jö kïbëc pïngö egudo Yecu ëka kï kite n'ëcang ködë cüth. ");
INSERT INTO lth_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Cë Yecu okobo both dhakö nön nï, “Pïën dong iyee ëka ïcang ökö, cïdh giri kï kuc.” ");
INSERT INTO lth_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ï karë na Yecu pod twak, ngat mörö n'eoro obino kï ï pacö ka Yairo, adwong më cinagoga, cë okobo nï, “Nyari dong öthöö ökö, kür dök iyel apwony.” ");
INSERT INTO lth_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Na Yecu owinyo köp ni, okobo nï Yairo nï, “Kür ïpar! Bed kï yee cë nyari bino cang.” ");
INSERT INTO lth_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ï karë na Yecu ödönyö ï öt ka Yairo, ba oyeo ngat mörö nï ëk ölüb körë, na path kï Petero, Jon, Yakobo ëka enyodo ka nyan nön. ");
INSERT INTO lth_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jö kïbëc onwongo kok na dhongo korgï pï nyakö nön. Yecu okobo nï, “Athïn ba öthöö, ëntö önïnö anïna.” ");
INSERT INTO lth_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jö kïbëc önyërö Yecu anyëra pïën gïn onwongo ngeo nï nyakö nön öthöö ökö. ");
INSERT INTO lth_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ëntö Yecu ömakö cïng nyakö nön cë okobo nïnë nï, “Athïn, yaa malö!” ");
INSERT INTO lth_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Cücüth kwö mërë odwogo, ëka öya ökö malö wang acël. Yecu okobo nïgï dong nï ëk ëmïï nyan nön cem öcam. ");
INSERT INTO lth_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Enyodo mërë ouro rwök. Ëntö Yecu öcïkögï nï kür okob gïnï both ngat mörö ngö n'ötïmërë. ");
INSERT INTO lth_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yecu ocwodo ëlübkörë apar arïö kanya acël cë ömïögï tëkö kï twër më ryëmö cene ëka kï cangö twoe. ");
INSERT INTO lth_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Cë oorogï më cïdhö tïtö köp ï kom Ker k'Obanga ëka më cangö etwoe. ");
INSERT INTO lth_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ën öcïkögï nï, “Ï wothwu kür ïcïdh unu kï gin mörö. Kür ïcïdh unu kï lüth, k'ekapu, onyo cem, cïlïng ëka kï böng arïö. ");
INSERT INTO lth_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Öt nï bino dönyö unu ïë, bed unu kunön naka ïya unu kï ï taun nön. ");
INSERT INTO lth_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kanya ba ëgamöwu ïë, ka ïya unu kï ï taun nön tëng unu apua më tyënwu, ëk onyuth nïgï nï ëngölö köp ï komgï pï kwërö köp më Emuth na Bër.” ");
INSERT INTO lth_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ëlübkör Yecu öya ëka öcïdhö gïnï ï peci na tïtö gïnï köp më Emuth na Bër ëka kï cangö etwoe ï kabedo kïbëc. ");
INSERT INTO lth_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erode alöc më Galilaya owinyo gin na kïbëc n'obedo ka tïmërë cë wie ocung ökö. Pïën jö nökënë onwongo kobo gïnï nï Jon Abatica ënë ocer kï ï kin jö n'öthöö. ");
INSERT INTO lth_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jö nökënë okobo nï Eliya ënë onen ëka jö nökënë nï ngat acël kï kin edwarpïny na cön ënë ocer. ");
INSERT INTO lth_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ëntö Erode okobo nï, “Jon yam anguno ngute ökö yo! Man nga na dök awinyo köp ï kome ni?” Erode öparö më nënö Yecu. ");
INSERT INTO lth_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ï karë n'ëkwëna odwogo gïnï both Yecu, okobo gïnï nïnë ngö na gïn ëtïmö kïbëc. Cë Yecu owotho ködgï yo taun n'ecwodo nï Bethecaida, kanya gïn twërö bedo ïë kën-gï. ");
INSERT INTO lth_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ëntö jö na pol ongeo ka kwene na Yecu onwongo cïdhö yo ïë k'ëkwëna mërë cë ölübö gïnï körë. Ën ögamögï, ötwak ködgï ï köp më Ker k'Obanga ëka öcangö jö kïbëc n'onwongo two. ");
INSERT INTO lth_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na ceng dong cwök dönyö, ëlübkörë apar arïö obino both Yecu cë okobo gïnï nï, “Kob nï jïï öcïdh gïnï ï kin peci ëka kï kanya jïï bedo ïë ëk onwong gïnï cem mörö ëka ka nïnö. Gin mörö ope ï kabedo ni kany cal kanya lik.” ");
INSERT INTO lth_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yecu ögamö nï, “Miwugï gin mörö më acama.” Ëntö gïn ögamö nï, “Wan eut k'ogati na thïthïnö abic ëka rëc arïö. Thwara ka wan ëcïdhö më wïlö cem pï jö ni kïbëc.” ");
INSERT INTO lth_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Onwongo cwö na römö elip abic tye kunön. Yecu okobo n'ëlübkörë nï, “Kob nï jïï obed pïny ï wel më pyer abic abic.” ");
INSERT INTO lth_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Cë ëlübkör Yecu ötïmö kite na ën okobo ködë ëka jö kïbëc obedo pïny. ");
INSERT INTO lth_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yecu ökwanyö ogati abic ëka rëc arïö. Önënö malö ï polo, ëka öpwöyö Obanga. Cë ötürö ogati na thïthïnö, ën obedo ka mïö ogati kï rëc both ëlübkörë ëk opok gïnï nï jïï. ");
INSERT INTO lth_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jö kïbëc ocemo naka oyeng gïnï. Ëka ëlübkör Yecu öcökö gïny cem n'odong pong aditi apar arïö. ");
INSERT INTO lth_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ï nïnö mörö acël na Yecu onwongo tye ï lëga kënë, ëlübkörë obino gïnï bothe. Cë Yecu openyogï nï, “Jïï kobo nï an abedo nga?” ");
INSERT INTO lth_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Gïn ögamö nï, “Jö nökënë kobo nï in ibedo Jon Abatica. Ëka jö nökënë kobo nï in ibedo Eliya nakun jö nökënë kobo nï adwarpïny na cön ënë ocer.” ");
INSERT INTO lth_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Cë Yecu openyogï nï, “Ëntö un kono ikobo nï An abedo nga?” Petero ögamö nï, “In ibedo Meciya k'Obanga.” ");
INSERT INTO lth_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yecu dong öcïkö ëlübkörë ëk kür okob gïnï both ngat mörö köp nön. ");
INSERT INTO lth_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yecu okobo nïgï nï, “Wod ka dhanö myero onwong can na thwönë. Edong k'Eyuda, ëlamdhök na dito ëka epwony cïk ka Muca bino kwërönë ökö. Ebino neko ën, ëntö kinge nïnö adek bino cer ökö.” ");
INSERT INTO lth_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Cë Yecu okobo both jö kïbëc nï, “Ka ngat mörö mïtö bedo alübköra, myero ën kono ökwërë kënë, oting yath arïa mërë nïnö kï nïnö ëk ölüb kï köra. ");
INSERT INTO lth_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ka ngat mörö mïtö gwökö kwö mërë, ën bino rwenyo gum më nwongo kwö na bedo naka. Ëntö ngat na bino rwenyo kwö mërë pï tio ticna, bino nwongo kwö n'adyer. ");
INSERT INTO lth_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ngö na dhanö bino nwongo ka ut kï jami më lobo ni kïbëc cë orwenyo gum më nwongo kwö n'adyer? ");
INSERT INTO lth_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ka ngat mörö lewic makö ï koma ëka kï ngö na an apwonyo cë Wod ka dhanö thon lewic bino makö ën ï kome ka ën bino bino kï dheo mërë ëka kï dheo k'Apap mërë ëka më emalaika na leng. ");
INSERT INTO lth_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","An akobo niwu köp adyer nï, tye jö mökö n'ocung kany na ba bino gïnï thöö, naka ka wang n'önënö gïnï ker k'Obanga ka bino kï tëkö.” ");
INSERT INTO lth_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na dong römö nïnö aboro kinge na Yecu okobo köp ni, ën otero Petero, Jon ëka Yakobo ködë, cë öïdhö ködgï ï wi kidi më cïdhö lëga. ");
INSERT INTO lth_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ï karë n'onwongo ën tye ka lëga, terinyime ölökërë na path, ëka böng mërë ödökö na tar na ryëny aryënya. ");
INSERT INTO lth_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Cwö arïö onen athura Muca ëka Eliya ");
INSERT INTO lth_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","n'onen kï dheo, na twak gïnï kï Yecu ï köp ï kom yaa mërë kï ï lobo ni n'onwongo myero ën ocob ökö ï Jerucalem. ");
INSERT INTO lth_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petero ëka ewodhe onwongo nïnö ömakö wang-gï na tëk, ëntö na gïn dong ocoo, önënö gïnï dheo ka Yecu ëka jö arïö n'ocung ködë kanya acël. ");
INSERT INTO lth_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na cwö arïö nön dong mïtö yaa ökö kï both Yecu, Petero okobo nï, “Adwong, bër nï onu më bedo kany. Ëk ëgër othogo adek, acël megi, acël më ka Muca ëka acël më k'Eliya.” Ëntö Petero ba ongeo ngö n'onwongo ën tye ka twakö. ");
INSERT INTO lth_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Na Petero pod twak, pöl obino oumogï ökö cë lworo ömakögï na pöl oumogï. ");
INSERT INTO lth_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dwön mörö ötwak kï ï pöl na kobo nï, “Man ënë Woda, na dong ayërö, winye unu.” ");
INSERT INTO lth_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ka dwön ni ötwak ökö, cë onwongo gïnï Yecu odong kënë. Ëlübkör Yecu adek ni ölïng gïnï ï ngö n'ötïmërë ëka ba okobo gïnï nï ngat mörö ï caa nön ngö na gïn ënënö. ");
INSERT INTO lth_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kodiko mërë, na Yecu oidho pïny k'ëlübkörë adek kï wi kidi, lwak na pol oromo ködë. ");
INSERT INTO lth_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Athura ëcwö mörö oredo kï kin lwak nï, “Apwony, abakö dhöga bothi, ëk ïnën woda ni, pïën obedo athïn acël këkën na an atye ködë. ");
INSERT INTO lth_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ka tipo na rac ömakö ën, mïö kok ökö cüth, ryërë, cë rakërë, bwo donyo kï ï dhögë. Ba yaa kï ï kome pïöpïö ëka nyönyöngö kome na tëk. ");
INSERT INTO lth_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Abakö dhöga both ëlübkori ëk öryëm gïnï ökö, ëntö ryëmö ölöögï ökö.” ");
INSERT INTO lth_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yecu okobo nïgï nï, “Un jö më karë ni, ba itye unu kï yee, kitewu dong öbal ökö. Abino bedo kodwu naka awene? Abino dïö cwinya thon awene? Cë Yecu okobo both ëcwö nï kel wodi kany.” ");
INSERT INTO lth_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na pod awobi ni tye ka bino both Yecu, cen örëdhö pïny cë örakërë. Ëntö Yecu ocoko tipo na rac cë öcangö awobi ni ökö ëka ömïö both apap mërë. ");
INSERT INTO lth_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jö kïbëc ouro tëkö k'Obanga. Na gïn pod tye ka uro gin na kïbëc na ën otio, Yecu okobo both ëlübkörë nï, ");
INSERT INTO lth_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Winy unu na bër ngö na an abino kobo niwu, Wod ka Dhanö ebino mïö ï cïng jö na bino neko ën.” ");
INSERT INTO lth_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ëntö ëlübkörë ba önïang ï köp ni. Onwongo ëkanö ökö kï bothgï ëk kür önïang gïnï ïë. Ëka onwongo obedo gïnï kï lworo më penyo ën pï köp nön. ");
INSERT INTO lth_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pyem öcakërë ï kin ëlübkör Yecu nï nga ënë dit. ");
INSERT INTO lth_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yecu ongeo thamagï ökö, cë ökwanyö athïn acël ëka ömïö ocung ï ngete, ");
INSERT INTO lth_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","cë okobo nïgï nï, “dhanö kïbëc na gamö athïn ni kï nyïnga nwongo ögama, dhanö kïbëc na gama nwongo ögamö ngat n'ora. Pïën ngat na tïdï rwök kï ï kinwu kïbëc ënë ngat na dit.” ");
INSERT INTO lth_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon okobo nï Yecu nï, “Rwoth, ënënö dhanö na ryëmö cen kï nyingi ëka ekobo nïnë më wëkö ökö, pïën ën ba obedo akukurwa.” ");
INSERT INTO lth_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ëntö Yecu okobo nï, “Kür ïjük unu, pïën ngat na ba obedo langöwu, nwongo ute kukurwu.” ");
INSERT INTO lth_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na karë ka Yecu më tero ën ï polo dong onyingo na cwök, ën öcïdhö yo Jerucalem. ");
INSERT INTO lth_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ën ooro ëkwëna n'ötëlö anyim, n'öcïdhö gïnï yo peci ka jö Camaria co yübö gin na kïbëc obed cüth nïnë. ");
INSERT INTO lth_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ëntö jö Camaria ba ögamö Yecu pïën ën onwongo ut ï woth mërë yo Jerucalem. ");
INSERT INTO lth_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ï karë n'ëlübkörë, Yakobo ëka Jon önënö, okobo gïnï both Yecu nï, “Rwoth ïmïtö ecwod mac ëk öya kï ï polo otyekgï ökö?” ");
INSERT INTO lth_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ëntö Yecu ölökërë öjükögï. Ën okobo nïgï nï, “Un ba ingeo unu Tipo nï ute unu ködë, pïën Wod ka dhanö ba obino më neko jïï, ëntö më larögï.” ");
INSERT INTO lth_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Gïn öcïdhö gïnï ï peci nökënë. ");
INSERT INTO lth_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na Yecu ëka ëlübkörë onwongo ute ï wothgï, ëcwö mörö okobo nï Yecu nï, “Abino lüböni naka kanya in ibino cïdhö yo ïë.” ");
INSERT INTO lth_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ëka Yecu ögamö nï, “Kwee tye kï öd rwo gïnï, ëka wïny na ngwëcö kï malö tye kï udi, ëntö Wod ka dhanö ope kï kany mörö na ën pyelo wie ïë.” ");
INSERT INTO lth_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yecu dök okobo nï ngat nökënë nï, “Bin ëk ïlüba.” Ëntö dhanö ni ögamö nï, “Rwoth ëk kono acïdh pacö akür apapna ka öthöö cë aiki.” ");
INSERT INTO lth_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yecu dök ögamö nï, “Ëk jö n'öthöö oik jöögï n'öthöö, ëntö in ïcïdh ïyar Ker k'Obanga.” ");
INSERT INTO lth_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ëcwö nökënë dök okobo both Yecu nï, “Rwoth an abino lüböni. Ëntö më acël, yee nïna kono acïdh amoth jö na para.” ");
INSERT INTO lth_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yecu dök ögamö nï, “dhanö mörö ope na makö kwër wanu, ëka nënö kungee nwongo ba opore më tic ï Ker k'Obanga.” ");
INSERT INTO lth_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kinge, Yecu öyërö ëlübkörë jö pyer abïrö wie arïö. Cë oorogï k'arïö arïö më cïdhö anyim ï taun ëka ï kabedo nökënë na ën onwongo ebino thuno ïë. ");
INSERT INTO lth_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yecu okobo bothgï nï, “Kac dwong, ëntö ëkac nönök. Lëg unu both Rwoth n'obedo won pwodho ëk oor etic ï kac. ");
INSERT INTO lth_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Cïdh unu dong, ëntö po unu nï aorowu na calö ëthïn rom ï kin orudi. ");
INSERT INTO lth_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kür ïcïdh unu kï lïm onyo opiru, kadï wör, ëka kür ïbal unu caa na pol ï motho jïï. ");
INSERT INTO lth_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ka ïdönyö unu ï öt, më acël kob unu nï, ‘Obanga ömïïwu kuc.’ ");
INSERT INTO lth_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Cë k'athïn më kuc ute ï öt nön, cë kucwu bino bedo ï kome. Ëntö ka ope cë kucwu dwogo bothwu. ");
INSERT INTO lth_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bed unu ï öt nonu, kür ibed ka köbërë unu öt kï öt. Nakun ïcamö ëka ïmadhö unu gin n'ëmïöwu, pïën atic myero ëmïï cül mërë. ");
INSERT INTO lth_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ka ïdönyö unu ï taun mörö cë ëgamöwu, cam unu ngö n'eketho ï nyimwu ");
INSERT INTO lth_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Cang unu etwoe na ute kunön ëka ikob unu nïgï nï, ‘Ker k'Obanga dong cwök.’ ");
INSERT INTO lth_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ëntö ka ïdönyö unu ï taun mörö, cë ba ëgamöwu, cïdh unu ï wangayoo më taun nön, ëka ikob unu nï, ");
INSERT INTO lth_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Naka thon apua më taunwu n'omoko ï tyënwa, ëtëngö ï komwu. Kadï bed nï kömanön myero ingee unu nï Ker k'Obanga dong cwök.’ ");
INSERT INTO lth_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Akobo niwu nï ï nïnö nön më ngölö-köp, taun ni bino bedo kï can na löö pëkö ka jö Codom!” ");
INSERT INTO lth_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ibino nënö can in, Korajin! Ibino nënö can in, Bethecaida! Ka tango n'onwongo ëtïmögï bothwu onwongo ëtïmö ï Turo ëka Cidon, kono onwongo ongut gïnï cön, nakun ruko gïnï böngü cöla ëka juko gïnï wigï kï buru. ");
INSERT INTO lth_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Canwu ï nïnö më ngölö-köp bino bedo na thwönë na löö can ka Turo kï Cidon! ");
INSERT INTO lth_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ëka un jö më Kaperanaum ïmïtö wakërë unu kenwu nï ibino cïdhö unu ï polo? Pathï kömanön, ebino dwököwu cen ï lyël.” ");
INSERT INTO lth_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yecu okobo both ëlübkörë nï, “Ngat na bino winyowu, nwongo owinya, ngat na ba bino winyowu, nwongo ökwëra. Ëka ngat n'ökwëra nwongo ökwërö ngat n'ora.” ");
INSERT INTO lth_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ëlübkör Yecu pyer abïrö odwogo gïnï cen kï yom cwiny, ëka okobo gïnï nï, “Rwoth, naka cene thon owinyowa ka wan etio kï nyingi!” ");
INSERT INTO lth_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yecu ögamö nïgï nï, “Anënö Catan ka rëdhërë pïny na yaa kï ï polo na cal kï lüköth. ");
INSERT INTO lth_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Winy unu, amïöwu twërö më nyönö twol kï ïth ëka më löönö tëkö ka langwu kïbëc. Gin mörö ope na bino tïmöwu na rac. ");
INSERT INTO lth_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ëntö kür ibed unu kï yom cwiny këkën nï tipo na reco owinyowu, thwara ibed unu na cwinywu yom pïën Obanga öcöö nyïngwu ï polo.” ");
INSERT INTO lth_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ï karë nön, Tipo Naleng ömïö Yecu yom cwiny nakun kobo nï, “An apaki Apap, Rwoth më polo ëka lobo, pïën ïkanö jami ni ökö kï both jö na ryëk ëka kï both jö na ngeo pïny, ëka inyutho both ëthïnö na pod thïnö. Eyo, Apap, man ënë kite n'onwongo in ïmïtö nï ötïmërë ködë na yomo cwinyi. ");
INSERT INTO lth_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Jami kïbëc Obanga otyeko mïö ökö botha. Ngat mörö ope na ngeo Wod nï ënë nga kono k'Apapna këkën. Ëka ngat mörö ope na ngeo Apapna nï ënë nga kono ka Wod këkën, ëntö dhanö na Wod öyërö më nyutho both Apap mërë.” ");
INSERT INTO lth_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Cë Yecu ölökërë both ëlübkörë cë okobo nïgï müng nï, “Tye kï gum ngat n'önënö gin na un ïnënö! ");
INSERT INTO lth_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Akobo niwu nï edwarpïny na pol ëka rwodhi yam öparö gïnï më nënö gin na un ïnënö, ëntö ba önënö gïnï. Ëka öparö gïnï më winyo gin na un iwinyo, ëntö ba owinyo gïnï thon.” ");
INSERT INTO lth_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ï nïnö mörö acël, apwony cïk ka Muca mörö öya malö më tëmö Yecu na kobo nï, “Apwony, atïm ngö ëk anwong kwö na bedo naka?” ");
INSERT INTO lth_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yecu ögamö nïnë nï, “Ngö n'ëcöö ï buk më cïk ka Muca? Ïnïang ïë nïngö?” ");
INSERT INTO lth_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Apwony cïk nön ögamö nïnë nï, “Mar Rwoth Obangani kï cwinyi kïbëc, kï tiponi kïbëc, kï tëköni kïbëc, kï thamani kïbëc, ëka mar awodhi na calö ïmarö komi keni.” ");
INSERT INTO lth_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yecu ögamö nïnë nï, “Kakarë. Tïm kömanön cë ibino kwö.” ");
INSERT INTO lth_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ëntö apwony cïk n'onwongo mïtö nyutho nï ën kite atïr ï nyim Obanga, dök openyo Yecu nï, “Awodha ënë nga?” ");
INSERT INTO lth_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yecu ögamö nïnë kï carolok köman, “Ëcwö mörö yam ute n'öya kï ï Jerucalem, n'onwongo tye ï woth mërë lungo yo kupïny Jeriko. Ocop ï kom ëyak, ëmakö, ëgönyö böng mërë ökö, epwodo cë ëwëkö na dong cwök thöö. ");
INSERT INTO lth_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Alamdhök obino na lübö yoo nön thon. Ëntö ï caa n'önënö ngat n'ëwanö, ën owok kï theng yoo kucël cë opoth apotha. ");
INSERT INTO lth_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kömanön thon Alebi mörö ölübö yoo nonu. Ën önënö ëcwö nön n'epwodo, cë opoth ökö. ");
INSERT INTO lth_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ëntö dhanö më Camaria mörö obino, önënö ngat n'ëwanö, ëka obedo kï kïca ï kome. ");
INSERT INTO lth_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ën öcïdhö ï ngete, orumo cöngë pïny, ölwökö wang ret mërë kï köngö ölök, odunyo kï möö cë otweo k'opeke böngü. Ën dong otingo ëcwö nön opyelo ï ngee kana mërë cë öcïdhö ködë naka ï öt apanga pï wele kany ögwökö ïë. ");
INSERT INTO lth_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kodiko mërë ën ökwanyö denario arïö ömïö both won öt nön na kobo nïnë nï, ‘Gwök ëcwö ni na bër, ëka ka itio kï cïlïng na kadhö wel na an amïö bothi ökö, abino dwökö nini ka adwogo.’ ” ");
INSERT INTO lth_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Cë Yecu dök openyo ën nï, “Nga kï kin jö adek ni ënë obedo awodh ëcwö n'ëyak opwodo?” ");
INSERT INTO lth_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Apwony cïk ögamö nï, “Ngat n'obedo kï kïca ï kome.” Cë Yecu okobo nïnë nï, “Adyer! In thon cïdh ëka ïtïm nï kömanön.” ");
INSERT INTO lth_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yecu ëka ëlübkörë onwongo ut ï wothgï yo Jerucalem, ëka ödönyö gïnï ï pacö mörö. Dhakö mörö na nyïngë Martha ögamögï ï ödë. ");
INSERT INTO lth_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ën onwongo ut k'amïn mërë n'ecwodo nï Maria n'obedo pïny ï nget tyën Rwoth winyo pwony mërë. ");
INSERT INTO lth_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ëntö Martha obedo yelere ï tic kïbëc më yübö cem më acama. Ën obino both Yecu cë okobo nïnë nï, “Rwoth, in ba ïparö nï amëra öwëka këna ï dhö tic? Kob nïnë obin ökönya.” ");
INSERT INTO lth_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Rwoth ögamö nïnë nï, “Martha, Martha, in ïparö pï tic na pol, ");
INSERT INTO lth_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ëntö gin acël këkën ënë mïtërë. Maria öyërö gin na bër, na ba ebino kwanyö ökö kï bothe.” ");
INSERT INTO lth_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ï nïnö mörö acël, Yecu onwongo lëgö ï kabedo mörö. Na dong otyeko lëga, alübkörë acël okobo nïnë nï, “Rwoth, pwonywa kï lëga kite na Jon Abatica opwonyo k'ëlübkörë.” ");
INSERT INTO lth_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yecu okobo nïgï nï, “Ka un ïlëgö kob unu köman: “ ‘Apap, ëk nyingi na leng ëwör, ëk Kerni obin ï lobo. ");
INSERT INTO lth_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mïïwa cemwa më nïnö kï nïnö. ");
INSERT INTO lth_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tïm nïwa kïca pï balwa, kite na wan ëtïmö kïca nï jö kïbëc na balö ï komwa. Kür ïwëk ëdöny ï atëma.’ ” ");
INSERT INTO lth_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yecu dök okobo nïgï nï, “Ka yam ngat acël kï ï kinwu öcïdhö both okon mërë dingwor cë okobo nïnë nï, ‘Okona, könya kï cem mörö. ");
INSERT INTO lth_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Okona na tye ï woth mërë obino botha athura, ëntö cem ope na an arömö mïö ën.’ ");
INSERT INTO lth_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Cë okoni ögamö kï ï öt nï, ‘Kür ïlöla. Dholokek dong eloro ökö, ëka ëthïnöna thon kï an dong ebuto ökö. An ba arömö yaa malö më mïöni gin mörö.’ ");
INSERT INTO lth_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Akobo niwu nï, kadï bed ën ba bino yaa malö cë mïö cem nïnë, pïën ën obedo okon mërë, ëntö pï adïdë k'ëcwö ni, ën bino yaa malö cë mïö ën cem na thwönë ï kite na ën mïtö ködë. ");
INSERT INTO lth_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Pï man akobo niwu nï, kwa unu cë ebino mïöwu. Rang unu, cë ibino unu nwongo. Dwöng unu dholokek, cë ebino yabö niwu. ");
INSERT INTO lth_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ngat acëlacël na penyo ebino mïö; ngat na rangö bino nwongo; ëka ngat na dwöngö ebino yabö nïnë dholokek. ");
INSERT INTO lth_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Un enyodo, nga kï ï kinwu na k'athïn mërë ökwaö rëc më acama cë mïö thwol? ");
INSERT INTO lth_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Onyo ka ën ökwaö töng gwënö më acama, ïrömö mïö ën ïth? ");
INSERT INTO lth_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dong ka un ëbal ingeo unu kite më mïö mïc na bëcö both ëthïnöwu, cë dong Apapwu na ut ï polo bino mïö Tipo Naleng na röm kanyë both jö na kwaö ën!” ");
INSERT INTO lth_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ï nïnö mörö acël, Yecu onwongo tye ka ryëmö cen n'onwongo ba twak kï ï kom ëcwö mörö. Na dong cen öya öcïdhö ökö, ëcwö n'onwongo ba twak nï, öcakö twak ëka lwak ouro. ");
INSERT INTO lth_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ëntö jö mökö kï ï kin-gï okobo nï, “Yecu tye ka ryëmö cen kï twër ka Belijebul adwong më cene.” ");
INSERT INTO lth_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jö nökënë ötëmö Yecu nakun penyo gïnï anyuth n'öya kï ï polo. ");
INSERT INTO lth_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ëntö Yecu ongeo thamagï ëka okobo nïgï nï, “Ka ker opokere ïë arïö, cë ker nön lobo mërë bal ökö ëka ka jö më pacö nön ka opopokere gïnï, pacö nön thon këth ökö. ");
INSERT INTO lth_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ka Catan thon opokere ïë arïö, ker mërë twërö cung nïngö? Akobo man pïën un ikobo nï an aryëmö cen kï twër ka Belijebul. ");
INSERT INTO lth_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ka an aryëmö cen kï twër ka Belijebul, cë ëthïnöwu kono ryëmö gïnï cen kï twër ka nga? Pï man gïn ënë bino bedo ëngöl-köpwu. ");
INSERT INTO lth_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ëntö ka an aryëmö cen kï tëkö k'Obanga, cë man dong nyutho nï Ker k'Obanga dong othuno bothwu. ");
INSERT INTO lth_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ka dhanö na tëk, n'oruko jami më lwëny mërë kïbëc, tye ka kürö ödë, akwo ba römö kwalö jami mërë. ");
INSERT INTO lth_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ëntö ka dhanö mörö na tëk na löö ën, ölwënyö ï kome ëka ölöö ën ökö, ën bino cökö jami lwëny mërë na yam ën geno, cë poko kï jö nökënë ngö na yam ën öyakö. ");
INSERT INTO lth_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ngat n'ope kukura nwongo ën ba mïta, ëka ngat mörö na ba könya më cökö kanya acël köda këthö akëtha. ");
INSERT INTO lth_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ka tipo na rac öya ökö kï ï kom dhanö mörö, ën cïdhö rimo kabedo na pii ope ïë cë rangö ka yweo ëka ba nwongo kabedo mörö. Cë ën kobo nï, ‘An abino dök ï öt na an aya kï ïë.’ ");
INSERT INTO lth_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ka othuno, cë nwongo öt ëywëö na leng ëka ëyübö na bër. ");
INSERT INTO lth_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ën dök cïdhö kelo tipo na reco nökënë abïrö na kitegï reco na löö ën ökö cë dönyö gïnï ï kom dhanö nön. Ëka dhanö ni bedo na rac na löö kite n'onwongo tye ködë cön.” ");
INSERT INTO lth_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na Yecu onwongo tye ka twak, dhakö mörö kï ï kin lwak oredo kï dwön na malö rwök nï, “Gum obedo ï kom dhakö n'onywoli ëka ododhi.” ");
INSERT INTO lth_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ëntö Yecu ögamö nï, “Jö na winyo köp k'Obanga ëka gwökö, tye gïnï kï gum.” ");
INSERT INTO lth_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na lwak ömëdërë na pol, Yecu öcakö kobo nï, “Un jö më karë ni ibedo unu jö na reco! Ïrangö unu anyuth më tango ëntö ba ebino mïöwu anyuth mörö, kono k'anyuth ka Yona. ");
INSERT INTO lth_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Na calö Yona onwongo obedo anyuth both jö më Ninebi, kömanön thon Wod ka dhanö bino dökö anyuth both jö më karë ni. ");
INSERT INTO lth_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Alöc na dhakö na tye yo kukwap lobo bino cung kanya acël kï rok më karë ni ëka ngölö-köp ï kome; pïën ën öya kï ï ajiki lobo më winyo ryëkö ka Colomon, ëka ngat na dit na löö Colomon tye kany. ");
INSERT INTO lth_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jö më Ninebi bino cung gïnï kï rok më karë ni ëka bino ngölö gïnï köp ï kome; pïën ongut gïnï ï karë më tïtö köp na Yona onwongo ötïtö, ëka kobedini ngat na dit na löö Yona tye kany. ");
INSERT INTO lth_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ngat mörö ope na ka öcwïnyö tara cë ketho kany mörö n'obedo gül, onyo umo ökö k'adïta. Ëntö, ketho kany ecibo tara ïë, ëk ka jö kïbëc na bino ï öt önën gïnï tar mërë. ");
INSERT INTO lth_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Wangi ënë tara më komi. Ka wangi neno na bër, komi kïbëc thon bedo na leng. Ëntö ka wangi ba neno, komi kïbëc thon bedo ï pïny na cöl. ");
INSERT INTO lth_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gwökërë ëk tar na ute ï ii kür ödök na cöl. ");
INSERT INTO lth_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Dong ka komi kïbëc opong kï tar, ëka kany mörö ope na cöl, cë komi kïbëc bino bedo na tar, na calö cara ka tara na menyi.” ");
INSERT INTO lth_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kinge na Yecu otyeko pwony, Aparicayo mörö ögamö ën më cïdhö cem ködë. Yecu ödönyö ï öt ëka obedo ï dhö cem. ");
INSERT INTO lth_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ëntö Aparicayo ouro ka önënö nï Yecu öcakö cem na bara ölwökö cïngë ï kite më thëkwarögï. ");
INSERT INTO lth_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Cë Rwoth okobo nïnë nï, “Un Eparicayo, iporo unu më bedo jö na leng ïlwökö unu ngee okopo kï bakuli, nakun ïwu opong kï yak ëka kï tïm na reco. ");
INSERT INTO lth_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Un emingo! Path Obanga ënë otio gin na yökö ënë thon otio gin më ïë? ");
INSERT INTO lth_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ëntö mïï unu ngö nï ute unu ködë both ëcan, jami kïbëc nï bino tïmö unu, bino yomo cwiny Obanga. ");
INSERT INTO lth_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ëntö ibino nënö unu can, un Eparicayo! Pïën ïmïö unu acël më apar më apuruku, öbüga, ëka kï kit ngwedo kïbëc, nakun ïwëkö unu ngölö-köp atïr ëka kï marö Obanga. Mïï unu acël më apar ëntö kür ïwëk jami na pïrgï tëk ökö. ");
INSERT INTO lth_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ibino nënö unu can un Eparicayo! Pïën ïmarö unu thene më wörö na ut anyim ï cinagoga. Ïmïtö unu nï jïï thon omothwu kï wörö kï ï cuk. ");
INSERT INTO lth_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ibino nënö unu can pïën ïröm unu kï wi lyene na ba nen na jïï wotho ï wigï nakun ba ngeo gïnï.” ");
INSERT INTO lth_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Apwony cïk ka Muca mörö acël ögamö nï, “Apwony ka ikobo kömanön nyutho nï ïyanyöwa thon nakun wan ebedo epwonye më cïk.” ");
INSERT INTO lth_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yecu okobo nïnë nï, “Ibino nënö unu can un epwony cïk pïën ïmïö unu jïï yëö yëc na pëk. Ëka un thon ba igudo unu kadï kï nya cïngwu acël. ");
INSERT INTO lth_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Ibino nënö unu can! Pïën ïcanö unu kite ï wi lyene k'edwarpïny na yam kwerewu onekogï! ");
INSERT INTO lth_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pï tïmö nï kömanön nyutho nï un ecaden më ngö na kwerewu ötïmö. Gïn oneko edwarpïny ëka un ïcanö kite ï wi lyenegï! ");
INSERT INTO lth_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Pïën pï ticwu na rac, man ënë gin na ryëkö k'Obanga okobo nï, ‘Abino oro bothgï adwarpïny ëka ëkwëna, ëntö jö mökö ebino nekogï ëka jö nökënë ebino yelogï.’ ");
INSERT INTO lth_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jö më karë ni ebino ngölö nïgï köp pï önyö remo k'edwarpïny kïbëc anaka ï acaki pïny, ");
INSERT INTO lth_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","cakërë kï kom neko Abel naka othuno ködë ï kom neko Jakaria n'öthöö, ï kin keno tyër më öt k'Obanga ëka kabedo na leng. Eyo akobo niwu nï ebino ngölö-köp mërë ï kom rok më karë ni. ");
INSERT INTO lth_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ibino nënö unu can, un epwony cïk! Pïën ïmaö unu agöny më ngeo pïny ökö, un kikomwu ba ïdönyö unu ïë. Ëka ïgëngö unu dhanö na mïtö dönyö ïë thon.” ");
INSERT INTO lth_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Cë dong Yecu öya ökö kï kunön, Eparicayo ëka epwony cïk öcakö gïnï dïrë na tëk na rökö gïnï dhögë kï peny na pol, ");
INSERT INTO lth_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","nakun kio gïnï më nwongo köp mörö na yaa kï ï dhögë ëk edothi. ");
INSERT INTO lth_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ï karë nön, pol dhanö elip kï elip ögürë gïnï kanya acël, nakun nyönërë gïnï kën-gï. Yecu öcakö twak both ëlübkörë na kobo nï, “Gwökërë unu kï kom thöbï k'Eparicayo, na ënë kite më twodo. ");
INSERT INTO lth_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gin mörö kïbëc n'eumo ökö ïmüng, Obanga bino elo ökö kanyalër. Ëka gin mörö ope n'eumo na ba ebino ngeeno. ");
INSERT INTO lth_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pï manön jö kïbëc bino winyo ngö nï twakö unu ïmüng, ëka ngö nï mwöngö ï ith awodhi, jö nökënë bino tuco ökö. ");
INSERT INTO lth_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nyikoneina, akobo niwu nï kür ilwor unu jö na neko kom ëka kinge manön, ba dök römö tïmö gin mörö nökënë. ");
INSERT INTO lth_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ëntö abino nyutho bothwu ngat na myero ilwor unu. Lwor unu Obanga na ut kï twër më neko dhanö cë bolo ökö ï mac kapïny. Eyo, akobo niwu nï, lwor unu ën. ");
INSERT INTO lth_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Wïny abic ba ëcadhögï ï wel më cïlïng na tïtïdï? Ëntö ba tye mörö n'Obanga wie wil ködë. ");
INSERT INTO lth_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kadï bed yer wiwu kïbëc ëkwanö ökö, kür ibed unu kï lworo. Un pïrwu tëk rwök löö wïny na pol.” ");
INSERT INTO lth_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Cë Yecu okobo both ëlübkörë nï, “Akobo niwu nï ngat na bino tuco nyïnga ï nyim jïï, Wod ka dhanö thon bino tuco nyïngë ï nyim emalaika k'Obanga. ");
INSERT INTO lth_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ëntö ngat na bino kwëröna ï nyim jïï, ën thon ebino kwërö ökö ï nyim emalaika k'Obanga. ");
INSERT INTO lth_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jö kïbëc na twakö twak na rac ï kom Wod ka dhanö ebino tïmö nïgï kïca. Ëntö ngat na bino yanyö Tipo Naleng, ba ebino tïmö nïnë kïca. ");
INSERT INTO lth_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ka ekelowu ï pido ï nyim ëtëla ëka ëlöc kï wegi twër më cinagoga, kür ibed unu kï par na pol kite na myero ïtwak unu ködë. Kür thon ïpar unu ngö na un ibino gamö onyo köp mënë na un ibino twakö. ");
INSERT INTO lth_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pïën Tipo Naleng bino pwonyowu ï caa nön ï ngö na myero ikob unu.” ");
INSERT INTO lth_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ngat acël kï kin lwak okobo both Yecu nï, “Apwony, kob n'ömëra ëk wan epok ködë lïm k'apapwa na wan eleo.” ");
INSERT INTO lth_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yecu ögamö nïnë nï, “Okona, nga n'oketha më bedo angöl-köp ëka apok jami niwu?” ");
INSERT INTO lth_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Cë Yecu okobo nïgï nï, “Bed unu na wangwu thwolo ëka ïgwökërë unu kï kom woro më lïm. Kwö ka dhanö ba ocung ï kom wel lïm na thwönë na ën ute ködë.” ");
INSERT INTO lth_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Cë Yecu obolo nïgï carolok nï, “Alönyö mörö yam tye na cem mërë öcëk ï pwodho na thwönë. ");
INSERT INTO lth_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ën openyere kï ï cwinye kënë nï, ‘Abino tïmö ngö? Ka ketho cemna ope.’ ");
INSERT INTO lth_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Cë ën okobo nï, ‘Man ënë gin na an abino tïmö. Abino rworwobo derena ökö ëka agöö dere na thwon cë dong aketho cem ïë ëka jamina.’ ");
INSERT INTO lth_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Abino kobo nï cwinya këna nï, ‘In dong iut kï cem na thwönë kï jami na bëcö na pol na bino römöni pï mwaka na pol. Ywe giri, cem, medhi ëka ibed kï yom cwiny.’ ” ");
INSERT INTO lth_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ëntö Obanga okobo nïnë nï, ‘In amingo! Ï kiwor na tin ni, kwöni ebino kwanyö ökö kï bothi. Cë nga na bino lunyo jami na in ïkanö?’ ” ");
INSERT INTO lth_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Cë Yecu ojiko na kobo nï, “Bino bedo nï kömanön both jö na kanö jamigï kïbëc pïrgï kën-gï ëntö nwongo ba ut kï lönyö mërë both Obanga.” ");
INSERT INTO lth_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Cë Yecu okobo both ëlübkörë nï, “Pï manön akobo niwu nï kür ibed unu kï par na pol pï kwö na mewu nï ibino camö unu ngö onyo pï komwu nï ibino ruko unu ngö. ");
INSERT INTO lth_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kwö pïrë tëk löö cem ëka kom pïrë tëk löö ruk ökö. ");
INSERT INTO lth_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Par unu mönö pï agak! Ba cwö gïnï kodhi onyo kaö kac, ba ut gïnï kï dërö onyo ka ketho jami cïthë Obanga pod pïdhögï. Un ba ingeo nï pïrwu tëk both Obanga löö wïny ökö? ");
INSERT INTO lth_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nga kï kinwu na römö mëdö caa acël mörö ï kom kwö mërë pï bedo kï par na pol? ");
INSERT INTO lth_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kite na ba ïrömö unu tïmö gin na tïtïdï, pïngö ibedo unu kï par na pol pï jami nökënë? ");
INSERT INTO lth_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tham unu kite n'athure döngö ködë. Ba tio gïnï tic mörö onyo wïö wicu. Ëntö akobo niwu nï kadï bed Colomon yam orukere kï dheo mërë kïbëc, ën ba orukere na bër na cal kï mörö acël ï kin-gï. ");
INSERT INTO lth_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Cë ka Obanga ruko lum na ut ï thim nï kömanön, na bedo pï nïnö na tin këkën ëka diki ebolo ökö ï mac, ën bino rukowu na löö un jö na yeewu nönök! ");
INSERT INTO lth_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Kür ibed unu thamö pï gin nï bino unu camö onyo madhö. Kür ïpar unu pï jami ni. ");
INSERT INTO lth_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pïën jö na ba ngeo Obanga rangö jami nön, ëka Apapwu ngeo ngö na un ïmïtö. ");
INSERT INTO lth_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nakaka manön, keth unu cwinywu ï kom Ker k'Obanga, cë jami nön kïbëc ebino mëdö bothwu. ");
INSERT INTO lth_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kür ilwor unu, un lwak na nönök pïën Apapwu ïë obedo na yom më mïö Ker mërë bothwu. ");
INSERT INTO lth_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Cadhu jami ni ut unu ködë ëka mïï unu both ëcan. Kwö unu ocwe më lïm na ba tii, kan unu lönyöwu na ba thum ï polo, kanya akwo mörö ba römö thuno ïë ëka nyënyë thon ba balö. ");
INSERT INTO lth_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pïën kanya lönyöni tye ïë ënë cwinyi thon tye ïë. ");
INSERT INTO lth_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Bed nï yübërë unu pï tic, nakun tarawu lyël. ");
INSERT INTO lth_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bed unu na calö jö na kürö adwong-gï ka dwogo kï ï yüb më nyom ëk ëyab nïnë dholokek pïöpïö ka ën othuno. ");
INSERT INTO lth_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bino bedo më gum pï etic n'adwong-gï bino nwongogï neno ka ën obino. An akobo niwu köp adyer, ën bino ruko böngü mërë më tic. Bino mïögï bedo ï mëja më cem ëka poko nïgï cem ");
INSERT INTO lth_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bino bedo na bër pï etic n'adwong-gï bino nwongogï öyübërë, kadï bed nï adwong ni bino thuno dingwor. ");
INSERT INTO lth_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Nïang unu man nï ka kono yam won öt onwongo ngeo caa na kwo bino ködë, ën onwongo ba yeo nï ödöny ï ödë. ");
INSERT INTO lth_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Un thon myero ïyübërë, pïën Wod ka dhanö bino bino ï caa na un ba ingeo.” ");
INSERT INTO lth_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Cë Petero openyo Yecu nï, “Rwoth, in ibolo carolok ni bothwa onyo both jö kïbëc?” ");
INSERT INTO lth_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Rwoth Yecu ögamö nï, “Nga n'obedo agwök öt na genere ëka ryëk? Ënë ngat n'adwong mërë bino ketho më löönö etic mërë ëk ömïïgï cemgï ï caa na mïtërë. ");
INSERT INTO lth_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bino bedo na bër both atic nön ka adwong mërë odwogo cë onwongo ën tye ka tïmö nï kömanön. ");
INSERT INTO lth_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","An akobo niwu köp adyer, ën bino ketho ën më löönö jami mërë kïbëc. ");
INSERT INTO lth_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ëntö k'atic nön ötwak kënë kënë nï, ‘Adwong ögalërë më dwogo,’ cë öcakö pwodo etic ewodhe na cwö kï man obedo mon nakun ën cemo ëka medho naka mër. ");
INSERT INTO lth_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Adwong k'atic nön bino dwogo ï nïnö ëka ï caa na ën ba ngeo. Adwong ni bino pwodo atic ni na rac ëka ketho ën ï kin jö na ba genere.” ");
INSERT INTO lth_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Atic na ba ngeo ngö n'adwong mërë mïtö ëka ba yübërë ïë dök ba lübö ngö n'adwong mërë mïtö, ebino pwodo ën rwök arwöka. ");
INSERT INTO lth_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ëntö ngat na ba ngeo, cë otio ngö na twërö mïö epwode, ebino pwodo ën na nönök Dhanö n'ëmïö na thwönë, ebino mïtö na thwönë kï bothe ëka ngat n'egeno kï jami na pol, ebino penyo na pol rwök.” ");
INSERT INTO lth_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Cë Yecu okobo nï, “An akelo ngölö-köp ëka apokapoka ï lobo na an athamö nï öcakërë dong ökö. ");
INSERT INTO lth_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ëntö aut kï batica na myero awok ïë kï can ëka pëkö naka wang n'othum. ");
INSERT INTO lth_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Un ïthamö nï an abino më kelo kuc ï lobo? Akobo niwu nï pe ëntö apokapoka. ");
INSERT INTO lth_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cakërë kobedini jö abic bino bedo gïnï ï pacö acël, k'apokapoka ï kin-gï. Jö adek bino pokere kï jö arïö ëka jö arïö bino pokere kï jö adek. ");
INSERT INTO lth_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","“Apap bino pokere ökö kï wode ëka athïn bino pokere k'apap mërë. Aya bino pokere kï nyarë ëka nyakö bino pokere k'aya mërë. Adha bino pokere kï cii wode ëka cii wod bino pokere k'adha mërë.” ");
INSERT INTO lth_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Cë Yecu okobo both lwak nï, “Ka ïnënö unu edou otingere n'olyero yo kuthö, pïöpïö ikobo unu nï, ‘Wang na köth ocwe,’ cë cwe thon. ");
INSERT INTO lth_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ëka ka yamö kudho na bino kï kukwap, un ikobo nï, ‘Pïny bino bedo na lyeth rwök,’ cë bino tïmërë kömanön. ");
INSERT INTO lth_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Un etwodo! Ingeo unu poko anyuth na tye ï lobo ëka ï polo ï kom kit na nïnö bino bedo ködë. Pïngö dong ba ïrömö poko unu anyuth më karë ni? ");
INSERT INTO lth_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Pïngö ba ïtwërö unu ngölö-köp n'atïr pïrwu kenwu? ");
INSERT INTO lth_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ka ïcïdhö both angöl-köp nakun ïnywakö unu yoo acël kï ngat n'odothi, tëm kï tëk më yübö köp ködë nakun pod itye unu ï wangayoo ëk kür oteri ï nyim angöl-köp. Pï manön, ëk kür ömïï ï cïng ngat na löö buc cë oteri ï od buc. ");
INSERT INTO lth_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Akobo niwu nï ba ibino donyo kï ï buc naka ka ïcülö cül kïbëc, na wi cïlïng mörö ba orem.” ");
INSERT INTO lth_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ï koth karë nön, jö mökö n'onwongo tye kunön önïangö Yecu ï kom jö Galilaya na Pilato ömïö twërö më nekogï na gïn tye ka tyërö tyër. ");
INSERT INTO lth_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Cë Yecu ögamö nï, “Un ïthamö nï jö Galilaya nön onwongo obedo ëbal na löö jö Galilaya nökënë? ");
INSERT INTO lth_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Akobo niwu nï pe! Ëntö ka ba ingut unu ëka idwogo unu both Obanga cë un kïbëc ibino thöö unu kömanön. ");
INSERT INTO lth_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Cë dong jö apar aboro na wi öt na bor më Ciloam obino örëdhërë ï komgï ëka öthöö gïnï, ïthamö unu nï gïn onwongo obedo ëbal na löö jö nökënë na bedo ï Jerucalem? ");
INSERT INTO lth_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Akobo niwu nï pe! Ka ba ingut unu ëka idwogo unu both Obanga, cë un kïbëc ibino thöö kömanön.” ");
INSERT INTO lth_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Cë Yecu obolo carolok nï, “Ëcwö mörö yam tye n'onwongo öpïdhö yath ölam na nyakö nyige ï pwodho ölök mërë. Ën obino öcïdhö nakun rangö ka önyakö nyige mörö, ëntö ba onwongo. ");
INSERT INTO lth_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Cë ëcwö nön öcakö kobo both atic n'onwongo gwökö pwodho ölök nön, ‘Pï mwaka adek abedo bino kany më rangö nyig yath ölam ni ëntö ba anwongo mörö. Tong ökö pïny! Pïngö balö ngöm?’ ” ");
INSERT INTO lth_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ëcwö ni ögamö nï, ‘Adwong, kono ïwëk obed pï mwaka ni këkën dökï, an abino bakö ngöm ï thërë cë aönyö öwërö dyegi ïë. ");
INSERT INTO lth_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ka önyakö nyige ï mwaka na bino cë bër rwök, ëka ka ba önyak cë itong ökö pïny.’ ” ");
INSERT INTO lth_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ï ceng Cabït mörö acël, Yecu onwongo tye ï pwony ï od cinagoga. ");
INSERT INTO lth_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Dhakö mörö onwongo ute kunön na tipo na rac oyelo pï mwaka apar aboro, two ni onwongo ogomo ën ökö na ba römö ryërë malö atïr. ");
INSERT INTO lth_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ï karë na Yecu önënö dhakö nön, ocwodo ën anyim cë okobo nïnë nï, “Dhakö, agonyi ökö kï kom görüni.” ");
INSERT INTO lth_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Cë Yecu oketho cïngë ï kome, cücüth dhakö nön öryërë malö, cë öcakö pakö Obanga. ");
INSERT INTO lth_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ëntö akëmö ömakö adwong më cinagoga pïën Yecu onwongo öcangö dhakö ï ceng Cabït. Adwong më cinagoga okobo both lwak na tye ï athuko nï, “Nïnö tye abicël më tic, pï man bin unu ëk ëcangwu ïnïnö nonu gïnï, na path kï ceng Cabït!” ");
INSERT INTO lth_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Rwoth ögamö nïnë nï, “Un etwodo! Ngat mörö ope na gönyö thwön onyo kana mërë kï kanya cemo ïë cë tero ï modho pii ï ceng Cabït? ");
INSERT INTO lth_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Dhakö ni na ën ayë nyaka Abraam, na yam Catan otweo pï mwaka apar aboro. Ba myero ëgöny ën ökö kï kom tweco ni ï ceng Cabït?” ");
INSERT INTO lth_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ï karë na Yecu ötwakö köp ni, lewic ömakö lang mërë kïbëc ëntö cwiny jïï obedo na yom pï tic më aura n'onwongo ën tïmö. ");
INSERT INTO lth_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Cë Yecu okobo nï, “Ker k'Obanga cal kï ngö? Abino poro kï ngö? ");
INSERT INTO lth_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tye nï köman. Dhanö mörö ökwanyö nyig kodhi karadali na tïtïdï rwök, ëka öpïdhö ï pwodho mërë. Yath ni ödöngö ëka ödökö na thwönë, cë wïny na ngwëcö kï malö ögërö udigï ï jangë.” ");
INSERT INTO lth_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Cë Yecu dök openyo nï, “Ngö na dök arömö poro kï Ker k'Obanga? ");
INSERT INTO lth_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tye nï köman. Dhakö mörö ökwanyö thöbï cë orubo kï mökö ogati, naka wang na thöbï nön örömö.” ");
INSERT INTO lth_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ï karë na Yecu onwongo tye ï woth mërë yo Jerucalem, ën opwonyo jïï kï kin peci ëka imiye. ");
INSERT INTO lth_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ngat mörö openyo ën nï, “Rwoth, jö na nönök këkën ënë bino larë?” Cë Yecu ögamö nïgï nï, ");
INSERT INTO lth_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Tïm unu tëk më dönyö kï dholokek na dïng ï Ker k'Obanga, pïën jö na pol bino tëmö dönyö ëntö ba bino twërö gïnï. ");
INSERT INTO lth_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Won öt bino yaa malö cë cego dholokek, un ibino cung kï yöökö, ïdwöngö unu dholokek nakun ikobo unu nï, ‘Adwong, yab nïwa dholokek.’ Ëntö ën bino gamö köpwu nï, ‘An ba angeowu ëka kwene na un ïya kï ïë.’ ");
INSERT INTO lth_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Cë un ibino kobo nï, ‘Yam wan ecemo ëka emedho kodi kanya acël, ëka thon ipwonyo jïï ï yodhiwa.’ ");
INSERT INTO lth_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ëntö ën bino kobo nï, ‘Ba angeowu ëka kwene na un ïya kï ïë, cïdh unu ökö kï botha, un ëtïm tïm na reco kïbëc!’ ");
INSERT INTO lth_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Kunön ibino unu koko kï rïdö lakwu, ka ïnënö unu Abraam, Icaka, Jakob ëka edwarpïny kïbëc ï Ker k'Obanga ëntö un ebino kwëröwu ökö. ");
INSERT INTO lth_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Jïï bino bino kï kukïdë ëka kuthö, kukuju ëka kukwap më bedo ï kabedogï ï Ker k'Obanga. ");
INSERT INTO lth_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Adyer, tye jö n'odong cen bino tëlö anyim, ëka jö n'ötëlö anyim bino dong cen. Ëntö adyer jö mökö n'odong cen bino bedo gïnï anyim, ëka jö mökö na tye anyim bino bedo dong gïnï cen.” ");
INSERT INTO lth_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ï caa nön, Eparicayo mökö obino cë okobo both Yecu nï, “Cïdh ökö kï kany pïën Erode mïtö nekoni.” ");
INSERT INTO lth_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yecu ögamö nïgï nï, “Cïdh ikob unu both kwee na twot nön nï, ‘An abino ryëmö cen dök abino cangö dhanö tin kï diki, ëka ï nïnö më adek mërë abino tyeko ticna.’ ");
INSERT INTO lth_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kadï bed kömanön, myero amëdëra kï wothna, tin kï diki, kï diki maca, pïën adwarpïny kür myero öthöö kany ökënë na path kï Jerucalem. ");
INSERT INTO lth_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerucalem, Jerucalem, un ineko edwarpïny ëka icelo unu jö n'eoro bothwu kï kite, wang adi na an abedo ka mïtö cökö ëthïnöni kanya acël calö mïn gwënö na gürö ëthïnë ï thë bwome, ëntö in ïkwërö ökö. ");
INSERT INTO lth_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nën, odi dong ëwëkö nini, odong nono. An akobo niwu nï ba dökï ibino nënöna unu, naka ka ibino unu kobo nï, ‘Gum obed ï kom ngat na bino kï nyïng Rwoth.’” ");
INSERT INTO lth_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ï ceng Cabït mörö acël, Yecu öcïdhö ï cem ï öt k'Aparicayo mörö na pïrë tëk. Jö n'onwongo ut kunön obedo ka kino ën kï ryëkö. ");
INSERT INTO lth_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ï nyime kany nön onwongo ut dhanö na two akwoda kom ömakö. ");
INSERT INTO lth_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Cë Yecu openyo Eparicayo ëka epwony cïk ka Muca nï, “Cïk yeo nï ëcang dhanö ï nïnö më Cabït onyo pe?” ");
INSERT INTO lth_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ëntö gïn ölïng alïnga. Yecu oketho cïngë ï kom atwo ni, cë öcangö ën ëka okobo nïnë nï ëk öcïdhï. ");
INSERT INTO lth_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kinge manön Yecu openyogï nï, “Cë ka onwongo ngat mörö kï kinwu ut kï wode onyo thwönë ëka örëdhërë ï kulo ï nïnö më Cabït, in ba ïrömö ywaönö yökö pïöpïö?” ");
INSERT INTO lth_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Gamö köp ka Yecu ölöögï dökï. ");
INSERT INTO lth_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ï karë na Yecu önënö nï wele mökö n'ecwodogï onwongo yërö kabedo na bëcö, ën obolo nïgï carolok ni: ");
INSERT INTO lth_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ka ngat mörö ocwodi ï cem më nyom, kür ïcïdh ïyër kabedo na pïrë tëk. Gwök onyo dhanö mörö na pïrë tëk na loi nwongo thon ecwodo. ");
INSERT INTO lth_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Cë ka kömanön, ngat n'ocwodowu kïbëc bino bothi ëka kobo nini nï, ‘Ëk dhanö ni obed kanya in ibedo ïë.’ In dong ibino dök cïdhö bedo ï kabedo më rwöm na pïny kï thwön lewic. ");
INSERT INTO lth_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Ëntö ka ecwodi, cïdh ibed ï kabedo më rwöm na pïny. Ka dhanö n'ocwodi obino, ën bino kobo nini nï, ‘Okona, nyïk ï kabedo na bër.’ Cë dong ebino wöröni ï nyim wele ewodhi kïbëc. ");
INSERT INTO lth_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pïën ngat acëlacël na kethere kënë nï ën edit, ebino dwökö pïny. Ngat na mwolere kënë ebino mïö ën dökö na dit.” ");
INSERT INTO lth_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Cë Yecu okobo both ngat n'ocwodo ën nï, “Ka in icwodo dhanö ï cem, kür icwod nyikoneini onyo utmegoni onyo wedeni onyo ëlönyö na bedo ï ngeti. Ka ïtïmö kömanön, gïn thon römö cwodoni ëka cülö wang cwodoni ökö. ");
INSERT INTO lth_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ëntö ka itedo cem na thwönë, cwod ëcan, jö na mulo amula, engwalo, ëthöö wang ");
INSERT INTO lth_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ëka ibino bedo kï gum. Jö nön thon ba twërö cülö wang cwodoni. Cülöni bino bedo ï karë na jö na kitegï atïr bino cer ködë.” ");
INSERT INTO lth_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ï karë na ngat acël n'obedo ködë ï dhö cem owinyo köp ni, ën okobo nï Yecu nï, “Jö na bino camö cem ï Ker k'Obanga bino bedo gïnï kï gum.” ");
INSERT INTO lth_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Cë Yecu okobo nïnë nï, “dhanö mörö yam otedo cem na thwönë cë ocwodo jö na pol ïë. ");
INSERT INTO lth_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na karë më cem dong örömö, ën ooro atic mërë më cïdhö kobo both jö n'onwongo ecwodogï nï, ‘Cem öcëk ökö bie unu dong.’ ");
INSERT INTO lth_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ëntö gïn kïbëc öcakö bakö dhögï. Dhanö më acël okobo nï, ‘Pod awïlö pwodho awïla ëka myero acïdh anën.’ ");
INSERT INTO lth_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Dhanö nökënë dök okobo nï, ‘Pod awïlö thwoni pur apar ëka atye ka cïdhö më pwonyogï. Akwai nï ïtïm nïna kïca.’ ");
INSERT INTO lth_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Dhanö nökënë dök okobo nï, ‘Pod anyomo anyoma pï manön ba arömö cïdhö.’ ");
INSERT INTO lth_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Atic ni odwogo cen ëka okobo both adwong mërë. Cë akëmö ömakö won öt, ëka okobo both atic mërë nï, ‘Cïdh pïöpïö ï wanga yodhi ëka ï kin taun ëk ikel ëcan, jö na mulo amula, ëthöö wang ëka engwalo.’ ");
INSERT INTO lth_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Na tic ni dong odwogo, ën okobo nï, ‘Adwong, ngö na in ïcïkö an atïmö ökö ëntö kabedo gire pod ute.’ ");
INSERT INTO lth_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Cë adwong okobo n'atic mërë nï, ‘Apë cïdhï ï gudo na döngö gïnï kï nget yodhi ëka ïtwak kï jïï obin ëk öda opong. ");
INSERT INTO lth_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Akobo niwu nï, ba tye ngat mörö ï kin jö n'onwongo ecwodo na bino camö cem mörö këkën na an ayübö.’ ” ");
INSERT INTO lth_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ï nïnö mörö acël, jö na pol onwongo tye ï woth kanya acël kï Yecu. Ën öwïrë bothgï ëka okobo nï, ");
INSERT INTO lth_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Cë ka ngat mörö mïtö bedo alübköra, nakun ba ökwërö apap mërë ëka aya mërë, dhakö mërë ëka ëthïnë, utmego mërë, kadï naka kwö mërë kikokome, ba twërö bedo alübköra. ");
INSERT INTO lth_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ëka ngat mörö na ba tingo yath arïa mërë më lübö kï köra, ba twërö bedo alübköra. ");
INSERT INTO lth_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Cë ka ngat mörö acël kï kinwu mïtö gërö öt na bor, ën ba kono cakö bedo pïny më kwanö wel lïm na mïtërë ëk ënën ka eut kï lïm na römö tyeko öt nön? ");
INSERT INTO lth_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ka ocibo acaki thërë ëka ba römö tyeko, jö kïbëc na bino nënö, bino cakö ngalö ën. ");
INSERT INTO lth_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Gïn bino kobo nï, ‘dhanö ni öcakö gedo ëntö lïm othum ökö na bara otyeko.’ ");
INSERT INTO lth_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Onyo rwoth mënë, na ka öya më cïdhö ï lwëny kï rwoth nökënë, ba kono bedo pïny më yübö köp, ka cë ërömö tero jïï elip apar më cïdhö lwëny kï jö elip pyer arïö? ");
INSERT INTO lth_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ka öthamö nï ba ërömö, ën oro ëwangë na langö mërë nwongo pod ut kanya bor ëk ëtwak köp më kuc. ");
INSERT INTO lth_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Pï manön, ngat mörö kï kinwu na mïtö bedo alübköra myero öwëk jami kïbëc n'eute ködë.” ");
INSERT INTO lth_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Kadö obedo gin mörö na bër, ëntö ka orwenyo mït mërë ökö, ëtwërö mïö dökö na mït nïngö dökï? ");
INSERT INTO lth_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ba dök bër naka thon më aketha ï pwodho ëka ëönyö ökö. Ngat na tye kï ithe më winyo myero ën owiny.” ");
INSERT INTO lth_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ï nïnö mörö acël ëcök ocoro ëka ëbal, obino gïnï both Yecu më winyo ka ën pwonyo. ");
INSERT INTO lth_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Eparicayo ëka epwony cïk öngüngüta na kobo gïnï nï, “dhanö ni obedo okone k'ëbal ëka cemo ködgï kanya acël.” ");
INSERT INTO lth_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Cë Yecu dong okobo nïgï carolok nï, ");
INSERT INTO lth_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ka ngat mörö kï kinwu n'onwongo ut kï rom mërë mia acël ëka acël kï kin-gï orwenyo ökö, ngö na ën bino tïmö? Ën bino wëkö pyer abungwën wie abungwën ï bar ëka cïdhö rangö römö n'orwenyo naka nwongo. ");
INSERT INTO lth_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ëka ka onwongo römö nön, ën ryongo ï wi baë kï thwön yom cwiny ");
INSERT INTO lth_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","cë cïdhö ködë yo pacö. Ën dong cwodo nyikonei mërë ëka ewodhe nï nget parë ëka kobo nïgï nï, ‘Bed unu kï yom cwiny köda, pïën anwongo römöna n'onwongo orwenyo ni ökö.’ ");
INSERT INTO lth_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Akobo niwu, ï kit yoo acël nön, yom cwiny bino bedo na thwönë rwök ï polo pï abal acël na bino ngut na löö jö pyer abungwën wie abungwën na thamö gïnï nï kitegï atïr na ba mïtö gïnï ngut.” ");
INSERT INTO lth_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yecu okobo nïgï carolok nökënë nï, “Cë ka dhakö ut kï cïlïng apar na nyïng ëka orwenyo acël ökö, Ngö na ën bino tïmö? Ën bino cwïnyö tara cë ywëö ï öt ëka rangö naka nwongo. ");
INSERT INTO lth_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ëka ka onwongo, ën bino cwodo nyikonei mërë ëka ewodhe nï nget parë. Cë kobo nïgï nï, ‘Bie unu ëk ebedu kï yom cwiny pïën anwongo cïlïngna n'orwenyo ni ökö.’ ");
INSERT INTO lth_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ï yoo acël nonu, akobo niwu nï yom cwiny bino bedo ï nyim emalaika k'Obanga pï abal na bino ngut.” ");
INSERT INTO lth_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yecu dök ömëdërë kï carolok na kobo nï, “Yam dhanö mörö ut, n'onwongo ute k'awope mërë arïö. ");
INSERT INTO lth_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Awobi na tïdï öcïdhö both apap mërë ëka okobo nïnë nï, ‘Apap, mïa lïm na kukura ökö.’ Cë apapgï opoko jami mërë ï kin-gï. ");
INSERT INTO lth_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Kinge nïnö na nönök, awobi na tïdï ni öcökö jami mërë kïbëc ëka öcakö woth mërë më cïdhö ï lobo na bor. Ën öbalö lïm mërë kunön ï bedo më carö carö. ");
INSERT INTO lth_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Na dong öbalö lïm mërë othum ökö, kec ërön opodho ï lobo nonu, awobi nön onwongo ope kï cem më acama. ");
INSERT INTO lth_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Cë ën dong öcïdhö both ngat mörö më lobo nön, ëka etero ën ï dyelum më kwaönö pün. ");
INSERT INTO lth_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Awobi ni kec obino oneko rwök naka öparö më camö cem na pün camö. Ëntö ngat mörö ba ömïö ën cem më acama. ");
INSERT INTO lth_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ëntö ï karë na dong otyeko nïang pïrë kënë öcakö kobo nï, ‘Etic k'apapna tye adi na camö kwon löögï ökö, ëka an athöö kï kec kany! ");
INSERT INTO lth_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Abino wëkö lobo ni cë adök cen both apapna ëka akobo nïnë nï, apap, an abalö ï nyim Obanga ëka thon bothi. ");
INSERT INTO lth_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","An ba dök apora ëk icwoda nï awodi, mïa abed na calö etic na in ipangogï.’ ");
INSERT INTO lth_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Cë dong öcakö woth më cïdhö both apap mërë. “Ëntö na ën pod ut kanya bor, apap mërë önënö ën ëka obedo kï kïca ï kom wode, cë öngwëcö yo bothe. Apap mërë öthünö körë ëka omotho kï yom cwiny. ");
INSERT INTO lth_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Wode okobo nïnë nï, ‘Apap, an abalö ï nyim Obanga ëka thon bothi. Ba dök apora ëk ecwoda nï abedo wodi.’ ");
INSERT INTO lth_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ëntö apap mërë okobo both etic mërë nï, ‘Kel unu jöra böngü na bër kï ï öt pïöpïö ëk ïmïï unu oruki. Rëp unu agïth ï nya cïngë ëka mïï unu oruk wör ï tyënë. ");
INSERT INTO lth_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kel unu thon wod thwön n'öcwëë ëk inek unu cë ëcam kanya acël ëka ebedu kï yom cwiny. ");
INSERT INTO lth_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pïën athïn-na ni onwongo yam öthöö cë kobedini dong ute na kwö. Ën onwongo orwenyo cë dong enwongo.’ Öcakö gïnï bedo kï yom cwiny. ");
INSERT INTO lth_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ï caa nön wode na dit onwongo tye ï pwodho. Ï karë na ën odwogo, na dong cwök kï öt, owinyo jïï ka wer ëka myël gïnï. ");
INSERT INTO lth_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Cë ën ocwodo ngat acël kï kin etic ëka openyo ën ngö n'onwongo tye ka tïmërë. ");
INSERT INTO lth_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Atic nön ögamö nï, ‘Omeru na tïdï nï dong odwogo, ëka apapni oneko wod thwön n'öcwëë pïën omeru odwogo na kome yot.’ ");
INSERT INTO lth_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Akëmö ömakö ömïn mërë na dit cë ökwërö dönyö ökö ï öt. Apap mërë odonyo yökö ëka öbakö dhögë bothe. ");
INSERT INTO lth_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ëntö ën ögamö na apap mërë nï, ‘Nën, an atio bothi pï mwaka na pol ëka bara akwërö lübö cïkni. Ëntö ba ïmïa kadï k'athïn dyël mörö ëk acam kï nyikoneina. ");
INSERT INTO lth_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ëntö wodi ni n'öbalö lïmni kïbëc ï kom mon n'obedo alyanga obino pacö, in ibedo kï yom cwiny cë ineko nïnë wod thwön n'öcwëë ökö!’ ");
INSERT INTO lth_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Apap mërë okobo nïnë nï, ‘Woda, in iut köda pï karë kïbëc, ëka jami kïbëc na an aute ködë obedo megi. ");
INSERT INTO lth_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ëntö onu myero ecem, ëka ebedu kï yom cwiny pïën omeru onwongo orwenyo cë kobedini onwongere, onwongo öthöö ökö ëka kobedini dong ut na kwö dökï.’ ” ");
INSERT INTO lth_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yecu okobo both ëlübkörë nï, “Dhanö mörö yam tye n'obedo alönyö n'onwongo tye k'agwök jami mërë. Alönyö ekobo nïnë nï agwök jami mërë tye ka balö jami. ");
INSERT INTO lth_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Cë alönyö nön ocwodo agwök jami mërë bothe ëka openyo nï, ‘Man köp ngö na an awinyo ï komi? Mïa ange kite na in ïmakö kï jamina ködë pïën in ba dök ïrömö bedo agwök jamina.’ ");
INSERT INTO lth_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Agwök jami ni ötwak kënë nï, ‘Abino tïmö ngö? Pïën adwongna mïtö kwanyöna ökö kï gwökö jami mërë. An ba atëk na römö pur, lewic thon maka ka akwaö kwac. ");
INSERT INTO lth_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Abino ngeeno ngö na römö tïmö, ëk ka ëryëma ökö kï ï tic më gwökö jami, jïï twërö gamöna ï pecigï.’ ");
INSERT INTO lth_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Agwök jami ni öcakö cwodo wegi benyi k'adwong mërë nön ka acëlacël. Öcakö kobo both won banya acël n'öcakö thuno bothe nï, ‘Wel banya adi na tye bothi n'obedo më adwongna?’ ");
INSERT INTO lth_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ën ögamö nï, ‘Aguli mia acël më möö jeituni.’ Cë agwök jami k'adwong okobo nïnë nï, ‘Kwany waraga më banyani, ëk ibed pïny kany pïöpïö ëka ïcöö pyer abic.’ ");
INSERT INTO lth_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Cë dök openyo won banya nökënë nï, ‘In kono itye kï wel banya adi’? Ën ögamö nï, ‘Aditi më mökö ngano mia acël.’ “Atic n'obedo agwök jami öcakö kobo nï, ‘Kwany waraga më banyani ëka ïcöö ïë nï pyer aboro.’ ");
INSERT INTO lth_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Adwong nön öpwöyö agwök jami na ba genere, pïën otio kï ryëkö. Man nyutho nï jö më karë ni ryëk gïnï ï tio ticgï k'ewodhgï na löö jö më tar. ");
INSERT INTO lth_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yecu okobo nïgï nï, tii unu kï lïm më lobo ni më könyö jö nökënë ëka ïmak unu okone na pïrwu. Cë ka dong othum ökö, ebino gamöwu ï kabedo na bedo naka naka. ");
INSERT INTO lth_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ngat na genere ï kom jami na tïtïdï mörö, bino genere ï kom jami na thwönë. Ngat na ba bino genere ï kom jami na tïtïdï mörö, ba bino genere ï kom jami na thwönë. ");
INSERT INTO lth_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Cë ka dong ba igenere unu ï makö lönyö më lobo, nga na bino genowu kï lönyö më adyer? ");
INSERT INTO lth_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ëka ka yam ba igenere unu ï kom jami ka dhanö nökënë, nga na bino mïöwu jami n'obedo mewu kikokome? ");
INSERT INTO lth_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ba tye atic mörö na twërö tic kï rwodhi arïö, pïën bino kwërö ngat acël ëka bino marö nökënë ca onyo bino moko ï kom ngat acël ëka kwërö ngat acël ca ökö. Ba ïtwërö tic pï Obanga ëka dök pï lïm thon.” ");
INSERT INTO lth_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Eparicayo na marö cïlïng ka owinyo köp ni kïbëc, öcakö gïnï cwïnö Yecu. ");
INSERT INTO lth_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ëntö Yecu okobo nïgï nï, “Un inyuthere nï kitewu atïr, ëntö Obanga ngeo cwinywu. Jami mökö na pïrgï tëk kï both dhanö obedo gin më kwer ï nyim Obanga. ");
INSERT INTO lth_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Cïk ka Muca ëka cöc k'edwarpïny obedo ka tic naka ï karë ka Jon Abatica. Cakërë ï karë nön, ekobo köp më Emuth na Bër ï kom Ker k'Obanga, na dhanö kïbëc tye ka dönyö ïë kï tëk. ");
INSERT INTO lth_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ëntö bedo na yot both polo kï lobo më thum ökö nï löönö kwanyö nyukuta mörö acël më Cïk. ");
INSERT INTO lth_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ngat mörö këkën na bino ryëmö dhakö mërë ëka dök nyömö dhakö nökënë, nwongo ödönyö ï elomi. Ëka ëcwö na bino nyömö dhakö na cwörë öryëmö ökö, nwongo ödönyö ï elomi.” ");
INSERT INTO lth_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yecu ömëdërë kï kobo carolok both ëlübkörë nï, “Yam tye dhanö mörö n'obedo alönyö, na ruko böng na bëcö më wel ëka onwongo camö cem na bëcö nïnö kï nïnö. ");
INSERT INTO lth_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Acan na nyïngë Lajaro onwongo epyelo ï dhö wangkac k'alönyö. Ën onwongo ut k'ajeme n'opong kome ökö. ");
INSERT INTO lth_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lajaro öparö më camö ngïny cem na podho kï ï wi mëja k'alönyö. Naka thon gwongi obino më nangö wang ajeme mërë. ");
INSERT INTO lth_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ï nïnö mörö acël, acan öthöö ökö ëka emalaika otingo ën etero both Abraam. Alönyö thon öthöö ëka eiko ökö. ");
INSERT INTO lth_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ï karë n'alönyö ni tye ï rem na dit ï kabedo ka jö n'öthöö, ën otingo wangë malö cë önënö Abraam kï kanya bor ëka Lajaro ï ngete. ");
INSERT INTO lth_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Alönyö oredo bothe nï, ‘Apapna Abraam, tïm nïna kïca! Or Lajaro öcïdh oluth nya cïngë ï pii ëk okwe kï lëba pïën aut kï thwön rem na lïth rwök ï mac kany.’ ");
INSERT INTO lth_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ëntö Abraam ögamö nï, ‘Woda, po nï ï karë më kwöni emii jamini na bëcö, nakun Lajaro ëmïö jami na reco. Ëntö kobedini dong ekweo cwinye ëka in iute ï arem na lïth. ");
INSERT INTO lth_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dök thon ï kom köp nön kïbëc, ï kinwa kï in eketho ïë thwön bur mörö na thuth. Ngat mörö ope na bino ngölö kï bothwa yo bothi ëka kï bothi yo bothwa.’ ");
INSERT INTO lth_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Alönyö ögamö nï, ‘Cë akwai, apap Abraam, or Lajaro ï öt k'apapna, ");
INSERT INTO lth_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","pïën aut kï utmegona abic. Kob nïnë ëk öcïdh okob nïgï, kür dök obin gïnï ï kabedo ni më arem.’ ");
INSERT INTO lth_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraam ögamö nï, ‘Gïn tye kï Cïk ka Muca ëka edwarpïny, ëk gïn owiny köp nön.’ ");
INSERT INTO lth_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Alönyö ögamö nï, ‘Pe, apap Abraam, ëntö ka ngat mörö n'öthöö öcïdhö bothgï, gïn bino ngut.’ ");
INSERT INTO lth_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraam okobo nïnë nï, ‘Ka gïn ba owinyo Cïk ka Muca ëka cöc k'edwarpïny, cë gïn ba bino thamö më yee kadï bed nï ngat mörö ocer kï ï thöö.’ ” ");
INSERT INTO lth_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ï nïnö mörö acël Yecu okobo both ëlübkörë nï, “Jami na mïö jïï podho ï bal ba bino jükërë, ëntö dhanö na kelo gin na mïö jïï podho ï bal bino nënö can! ");
INSERT INTO lth_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Thwara thwara n'etweo pong rego ï ngute ebolo ködë ï nam, nakaka ën më mïö ngat mörö acël kï kin jö ni na thïnö më podho ï bal. ");
INSERT INTO lth_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pï manön gwökërë kenwu ï ngö na un ïtïmö! “Ka omeru öbalö, jük ën, ëka ka ongut, tïm nïnë kïca. ");
INSERT INTO lth_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ka öbalö bothi wang abïrö ï nïnö acël, cë odwogo bothi wang abïrö nakun kobo nï, ‘Dong angut,’ myero ïtïm nïnë kïca.” ");
INSERT INTO lth_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ëkwëna okobo gïnï both Rwoth nï, “Nyuth nïwa kite më mëdö yeewa.” ");
INSERT INTO lth_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Rwoth ögamö nï, “Kono iut unu kï yee na tïdï na röm kï nyig kodhi karadali, ïtwërö unu kobo nï yath ni nï, ‘Pudhiri keni, ëk ipidhiri ï nam,’ ëka twërö winyowu. ");
INSERT INTO lth_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nga kï ï kinwu na twërö kobo na tic mërë na pod odwogo adwoga kï ï pwodho onyo kï kukwath nï, ‘Rai ibin kany, ibed pïny, icem’? ");
INSERT INTO lth_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ën ba bino kobo nïnë nï, ‘Yüb nïna cem më kothyeno, ruk böngüni më tic ëka ikel nïna cem naka ka an acemo ëka amodho. Cë in dong ibino cem kinge.’ ");
INSERT INTO lth_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ën bino pwöyö atic pïën ötïmö ngö na ën öcïkö nï ötïm? ");
INSERT INTO lth_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Manön kite na un thon myero ïtïm unu ködë. Ka ïtïmö unu gin na kïbëc na myero ïtïm unu, cë ikob unu nï, ‘Wan etic na könywa ope, pïën etio gin na myero etii këkën.’ ” ");
INSERT INTO lth_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ï woth mërë yo Jerucalem, Yecu owok ï dyere lobo më Camaria kï Galilaya. ");
INSERT INTO lth_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Na ën onwongo tye ka dönyö ï pacö mörö, oromo k'ëdhöbü apar n'ocung gïnï kï kanya bor. ");
INSERT INTO lth_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ëdhöbü nonu oredo nï, “Öma Adwong, Yecu, tïm nïwa kïca!” ");
INSERT INTO lth_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Na Yecu önënögï, okobo bothgï nï, “Cïdh unu ëk inyuth komwu both ëlamdhök.” Na gïn pod ut ï yoo, komgï ödökö na leng. ");
INSERT INTO lth_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ngat acël kï kin-gï, ka önënö nï ëcang ökö, odwogo cen both Yecu nakun pakö Obanga kï dwön na longo. ");
INSERT INTO lth_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ën oryebere pïny ï tyën Yecu ëka öpwöyö pï ngö na ën ötïmö. Adhöbü ni onwongo obedo dhanö më Camaria. ");
INSERT INTO lth_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yecu openyo nï, “Ba onwongo acangö jö apar? Jö abungwën kono ut gïnï kwene? ");
INSERT INTO lth_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ba tye ngat mörö n'odwogo cen më pakö Obanga, ëntö kono arok ni këkën?” ");
INSERT INTO lth_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Cë Yecu okobo nïnë nï, “Yaa malö, ïcïdh giri, yeeni ocangi.” ");
INSERT INTO lth_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ï nïnö mörö acël, Eparicayo dök openyo Yecu nï, “Ker k'Obanga bino thuno awene?” Yecu ögamö nïgï nï, “Ker k'Obanga ba bino n'ënënö kï wang jö. ");
INSERT INTO lth_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Jïï ba bino kobo nï, ‘Nën, ut kany!’ Onyo nï, ‘Ën ëca!’ Pïën Ker k'Obanga dong ut ï kinwu.” ");
INSERT INTO lth_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Cë Yecu okobo both ëlübkörë nï, “Karë tye ka bino na un ibino parö më nënö nïnö mörö acël ka Wod ka dhanö dwogo ëntö ba ibino nënö unu. ");
INSERT INTO lth_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Jïï bino kobo niwu nï, ‘Nën, ën ëca!’ Onyo nï, ‘Nën ut kany!’ Kür ïcïdh unu ïë kür thon ilubugï. ");
INSERT INTO lth_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Pïën na calö lüköth wïl carö polo tungcël thuno ködë naka kutung nökënë, Wod ka dhanö thon bino bedo nï kömanön ï nïnö më dwogo mërë. ");
INSERT INTO lth_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ëntö myero kono ölïm can na pol nakun jö më karë ni bino kwërö ën ökö. ");
INSERT INTO lth_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Na calö yam ötïmërë ï karë ka Noa, bino tïmërë kömanön ï karë ka Wod ka dhanö thon. ");
INSERT INTO lth_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ï karë ka Noa, jïï onwongo cemo ëka emedho, ëcadhö cath, awope ëka anyira nyömërë gïnï naka othuno ködë ï nïnö na Noa ödönyö ködë ï yeya. Cë abwal pii opong ëka otyekogï kïbëc. ");
INSERT INTO lth_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Onwongo röm aröma kï karë ka Lot, jïï onwongo cemo ëka emedho, ëwïlö jami ëka ëcadhö, epuro ëka egedo. ");
INSERT INTO lth_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ëntö ï nïnö na Lot öya ködë ökö kï Codom, mac ëka gwëng calupa ocwe pïny nakun yaa kï ï polo, cë otyekogï ökö kïbëc. ");
INSERT INTO lth_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Bino bedo nï kömanön thon ï nïnö na Wod ka dhanö ebino nyutho ködë. ");
INSERT INTO lth_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ï nïnö nonu, dhanö na ut malö ï wi ödë nakun jami mërë ut ï öt, myero kür dök oidhi pïny nï ëk ebin ëkwanygï. Kömanön thon, dhanö na ut ï pwodho kür odwogi cen. ");
INSERT INTO lth_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Po unu ï kom ngö n'ötïmërë ï kom dhakö ka Lot! ");
INSERT INTO lth_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ngat na mïtö larö kwö mërë bino rwenyo kwö mërë arwenya. Ëntö ngat na rwenyo kwö mërë, ën bino gwökö. ");
INSERT INTO lth_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Akobo niwu nï ï kiwor nön, jö arïö bino buto ï kabuto acël. Ebino kwanyö ngat acël ökö ëka ngat acël dong. ");
INSERT INTO lth_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mon arïö bino bedo kanya acël ï rego. Ngat acël ebino kwanyö ökö ëka ngat acël dong.” ");
INSERT INTO lth_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Jö arïö bino bedo ï pwodho, ebino kwanyö ngat acël ökö ëka ngat acël dong. ");
INSERT INTO lth_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Gïn openyo Yecu nï, “Rwoth, man bino tïmërë kwene?” Ën ögamö nïgï nï, “Kanya kom n'öthöö tye ïë, acuth thon cökërë kany nön.” ");
INSERT INTO lth_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yecu obolo carolok n'ëlübkörë më nyutho nïgï nï myero gïn ölëgï kür edher. ");
INSERT INTO lth_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ën okobo nï, “Yam angöl-köp tye ï taun mörö, n'onwongo ën ba lworo Obanga kadï thon wörö dhanö. ");
INSERT INTO lth_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ï taun nön onwongo dha thöö mörö tye ïë. Ën obedo bino both angöl-köp nön jwijwi nakun kobo nïnë nï, ‘Ngöl nïna köp atïr ï kom ngat na an apido ködë.’ ");
INSERT INTO lth_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wang na pol angöl-köp nön kwërö ökö. Ëntö kinge ötwak kënë nï, ‘Kadï bed ba alworo Obanga onyo aparö pï dhanö, ");
INSERT INTO lth_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","cïthë dha thöö ni ölöla dong rwök. Abino dong ngölö-köp atïr nïnë ï kom ngat na ën pido ködë, ëk bino mërë botha jwijwi kür omoga.’ ” ");
INSERT INTO lth_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ëka Rwoth Yecu okobo nï, “Winy unu ngö n'angöl-köp na kite mërë ba tye atïr okobo. ");
INSERT INTO lth_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Obanga ba bino ngölö-köp atïr both jögë na ën öyërö, na kok bothe kiceng kï kiwor? Ën bino thumere na ba ötïmö gin mörö ï komgï? ");
INSERT INTO lth_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Akobo niwu nï ën bino ngölö-köp atïr pïöpïö më könyögï. Kömanön thon ka Wod ka dhanö bino bino, ën bino nwongo yee tye both jö n'oye ën?” ");
INSERT INTO lth_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yecu dök obolo carolok both jö mökö na genere kën-gï nï gïn kitegï atïr nakun caö gïnï jö nökënë. ");
INSERT INTO lth_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Jö arïö yam öcïdhö ï lëga ï öt k'Obanga. Ngat acël obedo Aparicayo ëka ngat nökënë ca obedo acök ocoro. ");
INSERT INTO lth_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Aparicayo ocung nakun lëgö gire kënë nï, ‘Obanga apwoi pïën an ba acal kï jö nökënë n'obedo ëyak, jö na ba genere, ëdöny ï elomi ëka thon ba acal k'acök ocoro ni. ");
INSERT INTO lth_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","An ario kec nïnö arïö ï cabït acël. Amïö thon acël më apar më jamina kïbëc na an anwongo.’ ");
INSERT INTO lth_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ëntö acök ocoro ocung kï cecen. Ën ba onwongo twërö tingo wangë malö ï polo ëntö odhongo körë kï cwer cwiny nakun lëgö both Obanga nï, ‘Obanga tïm nïna kïca, an abal.’ ");
INSERT INTO lth_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Akobo niwu nï, ëcwö nön ödök tunge n'ëkwanö nï ën kite atïr ï nyim Obanga löö ëcwö nökënë ca ökö. Pï manön, ngat acëlacël na kethere kënë nï etye malö, Obanga bino dwökö ën pïny. Ëntö dhanö na mwolere kënë Obanga bino tingo ën malö.” ");
INSERT INTO lth_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jïï onwongo tye ka kelo ëthïnö na thïthïnö both Yecu ëk oketh cïngë ï komgï. Ï karë n'ëlübkörë önënö ngö n'onwongo tye ka tïmërë, ocoko gïnï jïï nï kür ekel ëthïnö. ");
INSERT INTO lth_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ëntö Yecu ocwodo ëthïnö bothe cë okobo nï, “Wëk unu ëthïnö na thïthïnö obin botha, kür ijukugï, pïën jö na mwolere kamë ëthïnö, Obanga bino gamögï ï ker mërë. ");
INSERT INTO lth_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","An akobo niwu köp adyer nï ngat mörö na ba bino gamö Ker k'Obanga kamë athïn na tïtïdï, ba bino dönyö ïë.” ");
INSERT INTO lth_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Alöc k'Eyuda mörö openyo Yecu nï, “Apwony na Bër, ngö na myero an atïm ëk anwong kwö na bedo naka?” ");
INSERT INTO lth_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yecu ögamö nïnë nï, “Pïngö in icwoda nï abër? Ngat mörö ope na bër, na path k'Obanga këkën. ");
INSERT INTO lth_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ingeo Cïk k'Obanga nï, ‘Kür ïdöny ï elomi, kür ineki, kür ïkwal, kür ikob caden n'obedo twodo, wör apapni ëka ayani.’ ” ");
INSERT INTO lth_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ën ögamö nï, “Agwökö cïk ni kïbëc anaka na pod an onwongo abedo awobi.” ");
INSERT INTO lth_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ï karë na Yecu owinyo köp ni, okobo nïnë nï, “In pod irem kï gin mörö acël. Apë ëk ïcadh jamini kïbëc na in iut ködë ëka ïmïï both ëcan ëka ibino bedo kï lönyö ï polo. Cë dong ibin ïlüb köra.” ");
INSERT INTO lth_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nyeri ka owinyo köp ni, öcakö bedo kï kumo pïën ën onwongo obedo thwön alönyö rwök. ");
INSERT INTO lth_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yecu obedo ka nënö ën cë okobo nï, “Tëk nïngö n'ëlönyö më dönyö ï Ker k'Obanga! ");
INSERT INTO lth_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Adyer yot pï kïnaga më dönyö kï ï wang libira, nï löönö pï alönyö më dönyö ï Ker k'Obanga.” ");
INSERT INTO lth_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jö n'owinyo köp ni, okobo nï, “Cë nga na dong twërö larë?” ");
INSERT INTO lth_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yecu ögamö nï, “Gin na ba twërë kï both dhanö, kï both Obanga twërë.” ");
INSERT INTO lth_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Cë Petero okobo both Yecu nï, “Wan ëwëkö gin na kïbëc na wan etye ködë më lübö kori.” ");
INSERT INTO lth_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yecu okobo nï, “An akobo niwu köp adyer nï ngat mörö n'öwëkö parë, onyo cege, onyo utmego mërë, onyo enyodo mërë, onyo ëthïnë, pï Ker k'Obanga, ");
INSERT INTO lth_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ën bino nwongo jami na kadhö manön wang na pol ï karë ni. Ëka dökï ï karë më anyim ën thon bino nwongo kwö na bedo naka.” ");
INSERT INTO lth_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yecu otero ëlübkörë apar arïö thenge ëka okobo nïgï nï, “Onu ebino cïdhö naka yo Jerucalem ëka jami kïbëc n'edwarpïny öcöö ï kom Wod ka dhanö, bino cobere. ");
INSERT INTO lth_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ebino mïö ën both jö na ba obedo gïnï Eyuda. Gïn bino ngalö ën, ebino yanyö, ebino ngülö laö ï kome, ebino pwodo kï del ëka eneko ökö. ");
INSERT INTO lth_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ï nïnö më adek ën bino cer ökö.” ");
INSERT INTO lth_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ëlübkör Yecu ba önïang ï köp ni thon acël. Tyën köp ni onwongo ökanërë ökö kï bothgï. Gïn ba ongeo ngö n'onwongo Yecu twakö. ");
INSERT INTO lth_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yecu ëka jö n'onwongo ut ködë kanya acël onwongo dong cwök kï Jeriko, athöö wang mörö onwongo obedo ï nget yoo na kwaö kwac. ");
INSERT INTO lth_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ëcwö ni owinyo ka jïï tye ka woth ëka openyo ngö n'onwongo tye ka tïmërë. ");
INSERT INTO lth_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jïï okobo nïnë nï, “Yecu më Najaret ënë tye ka wok.” ");
INSERT INTO lth_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Cë athöö wang oredo, “Yecu, Wod ka Daudi, kïca ömakï ï koma!” ");
INSERT INTO lth_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jö n'onwongo ötëlö anyim, öjükö ëcwö ni ëk ölïng ökö. Ëntö ömëdërë kï redo na tëk rwök, “Wod ka Daudi, kïca ömakï ï koma!” ");
INSERT INTO lth_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yecu öcakö cung ëka okobo nï jö mörö më kelo athöö wang nön bothe. Ï karë na dong athöö wang onwongo tye ka nyingo na cwök, Yecu openyo ën nï, ");
INSERT INTO lth_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ngö na in ïmïtö nï atïm nini?” Ën ögamö nï, “Rwoth amïtö nï wanga önën pïny!” ");
INSERT INTO lth_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yecu ögamö nï, “Nën pïny, yeeni olari.” ");
INSERT INTO lth_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Cücüth ëcwö ni önënö pïny ëka öcakö lübö kör Yecu nakun pakö Obanga. Na jö kïbëc önënö ngö n'ötïmërë, öcakö gïnï thon pakö Obanga. ");
INSERT INTO lth_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yecu ödönyö ï Jeriko, na tye ka poth apotha. ");
INSERT INTO lth_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ëcwö mörö onwongo tye kunön n'obedo adit cökö ocoro na nyïngë Jakayo. Ën onwongo ölöny. ");
INSERT INTO lth_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jakayo onwongo mïtö nënö Yecu nï ënë nga ëntö pï bedo ngat na cek, ömïö ën ba ötwërö pïën jïï opong rwök. ");
INSERT INTO lth_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Cë ën örïngö anyim ëka öïdhö ï wi yath më nënö Yecu n'onwongo wok kï ï yoo nön. ");
INSERT INTO lth_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ï karë na Yecu othuno ï tyën yath nön, otingo wangë malö önënö Jakayo kï ï wi yath. Ën ocwodo nï, “Jakayo, Idhi pïny pïöpïö, pïën myero abed ï odi tin.” ");
INSERT INTO lth_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Cë Jakayo oidho pïny pïöpïö ëka otero Yecu yo ödë kï thwön yom cwiny na dit. ");
INSERT INTO lth_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jö kïbëc n'önënö öcakö ngüngüta gïnï na cwinygï ba yom nï, “Yecu öcïdhö më bedo welo ï pacö k'abal!” ");
INSERT INTO lth_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jakayo öya malö cë ocung ï nyim Rwoth ëka okobo nï, “Rwoth, winy! Abino mïö nucu jamina both ëcan ëka k'akwalö ngat mörö, abino cülö wang angwën na kadhö wel.” ");
INSERT INTO lth_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yecu okobo nïnë nï, “Larë obino both jö më öt ni tin, pïën ëcwö ni thon obedo akwar Abraam. ");
INSERT INTO lth_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pïën Wod ka dhanö obino më rangö ëka më larö jö n'orwenyo.” ");
INSERT INTO lth_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na jïï tye ka winyo köp kïbëc na Yecu okobo, ën ömëdërë më kobo nïgï carolok. Pïën onwongo dong cwök kï Jerucalem, jïï öthamö nï ködë Ker k'Obanga onwongo cwök bino. ");
INSERT INTO lth_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Cë Yecu okobo nïgï carolok nï, “Yam onwongo won ker mörö ut n'öya më cïdhö ï lobo na bor më cïdhö gamö twër më löc kï ïë, ëk dong edwogi cen. ");
INSERT INTO lth_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na ën bara öya më cïdhö, ocwodo etic mërë apar, ëka ömïö ngat acëlacël cïlïng na nyïng. Cë ën okobo nïgï nï, ‘Keth unu cïlïng ni ï tic, naka adwogi.’ ");
INSERT INTO lth_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ëntö jö mërë ödagö ën, ëka eoro jö mökö ï körë më cïdhö kobo nïnë nï, ‘Wan ba ëmïtö ëcwö ni ëk obed rwothwa.’ ");
INSERT INTO lth_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ëcwö ni eketho obedo rwoth ëka odwogo. Ocwodo etic mërë n'onwongo ën ömïö cïlïng ëk engee wel adi n'ömëdërë na gïn onwongo kï ïë. ");
INSERT INTO lth_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Atic më acël obino bothe cë okobo nï, ‘Adwong, cïlïngni elip acël ömëdërë dökï ïë cïlïng elip apar.’ ");
INSERT INTO lth_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ëka rwoth ögamö nï, ‘Ïtïmö na bër! In ibedo atic na bër. In ibedo geniri kï jami na nönök na an ageni ködë, ibino bedo kï twër ï kom peci apar.’ ");
INSERT INTO lth_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Dhanö më arïö obino cë okobo nï, ‘Adwong, cïlïngni elip acël ömëdërë dökï ïë cïlïng elip abic.’ ");
INSERT INTO lth_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Cë rwoth ögamö nï, ‘Ïtïmö na bër! Ibino bedo kï twër ï kom peci abic.’ ");
INSERT INTO lth_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Atic nökënë obino cë okelo cïlïng n'onwongo ëmïö bothe këkën. Ën okobo nï, ‘Adwong, akanö cïlïngni ëka agwökö na bër ï opeke böngü. ");
INSERT INTO lth_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Onwongo alwori pïën in ibedo ngat mörö na tic ködë tëk. Itero gin na ba obedo megi ëka ïkaö gin na ba ïcwö.’ ");
INSERT INTO lth_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Adwong okobo nïnë nï, ‘In atic na rac! Abino ngölö-köp nini na lübërë kï twak n'öya kï ï dhogi. Cë ka onwongo in ingeo nï abedo ngat mörö na kite tëk na kwanyö gin na ba obedo mëga ëka akaö kodhi na ba apuro, ");
INSERT INTO lth_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ngö n'oceri kanö cïlïngna ï öt kanö lïm? Cë k'adwogo, ëk abin akwany k'amëd mërë.’ ");
INSERT INTO lth_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ën dong okobo both jö n'ocung ï ngete nï, ‘Gam unu cïlïng kï both atic nön, ëk ïmïï unu both won cïlïng elip apar.’ ");
INSERT INTO lth_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ëntö gïn okobo nïnë nï, ‘Adwong, ën dong tye kï cïlïng elip apar!’ ");
INSERT INTO lth_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Cë rwoth nön ögamö nï, ‘Eyo, akobo niwu nï ngat acëlacël na mëgë tye, ebino mïö. Ëntö ngat na mëgë ope, ebino gamö ngö na ut bothe thon ökö. ");
INSERT INTO lth_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ëntö pï langna, na ba oyeo nï an abed rwothgï, kelugï ëk inekugï ï nyima kany.’ ” ");
INSERT INTO lth_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kinge na Yecu okobo köp ni, ën ömëdërë kï woth nakun cïdhö ködë yo Jerucalem. ");
INSERT INTO lth_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Na dong onyingo cwök kï Betepage ëka Betania ï tyën kidi n'ecwodo nï Kidi më Jeituni, Yecu ooro ëlübkörë arïö. ");
INSERT INTO lth_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ën okobo nïgï nï, “Apë unu ï pacö na tye ï nyimwu. Na un ï dönyö ï pacö, ibino unu nënö athïn kana n'etweo na ngat mörö anaka yam bara obedo ï ngee. Göny unu ëk ikel unu kany. ");
INSERT INTO lth_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ëka ka ngat mörö openyowu, ‘Nï pïngö ïgönyö unu athïn kana nön?’ Kob unu nïnë nï, ‘Rwoth ënë mïtö.’ ” ");
INSERT INTO lth_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Cë gïn öcïdhö onwongo athïn kana kite na Yecu okobo nïgï ködë. ");
INSERT INTO lth_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Na gïn tye ka gönyö athïn kana, wegi mërë openyogï nï, “Pïngö ïgönyö unu athïn kana nön?” ");
INSERT INTO lth_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ëlübkör Yecu ögamö gïnï nï, “Rwoth ënë mïtö.” ");
INSERT INTO lth_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Cë okelo gïnï athïn kana ni both Yecu, ëka öpëdhö gïnï böng-gï ï ngee kana ëka ecibo Yecu ïë. ");
INSERT INTO lth_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na ën dong tye ï woth mërë, lwak ömëdërë kï pëdhö böng-gï ï dye yoo. ");
INSERT INTO lth_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ï karë na ën dong cwök kï lung më Kidi më Jeituni, ëlübkörë kïbëc öcakö wöö gïnï kï yom cwiny ëka kï wer nakun tye gïnï ï woth na pakö gïnï Obanga pï tic na döngö na Ën ötïmö na gïn dong önënö. ");
INSERT INTO lth_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ëlübkör Yecu okobo nï, “Gum obed ï kom ngat na bino kï nyïng Rwoth! Kuc obed malö ï polo, ëka dheo obed both Obanga!” ");
INSERT INTO lth_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Eparicayo mökö na tye ï kin lwak okobo gïnï nï Yecu nï, “Apwony, jük ëlübkori ölïng gïnï ökö!” ");
INSERT INTO lth_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yecu ögamö nï, “Ka gïn ölïng, kite ni bino cakö wöö!” ");
INSERT INTO lth_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ëntö na Yecu dong cwök kï Jerucalem ëka önënö pacö na tye ï nyime, ën öcakö koko pïrë nï, ");
INSERT INTO lth_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Cë ka onwongo ingeo ngö na mïtërë më kuc tin! Ëntö kobedini ökanërë ökö kï wangi! ");
INSERT INTO lth_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Karë bino bino na langwu bino rïköwu dyere kï cël, ëka bino rïdöwu tungi kï tungi. ");
INSERT INTO lth_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ebino rëdhöni pïny naka thon kï jö na tye ii. Ba ebino wëkö kidi mörö acël dong ï wi awodhe, pïën ba ingeo karë n'Obanga obino ködë më laröni.” ");
INSERT INTO lth_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Cë Yecu ödönyö ï öt k'Obanga ëka öcakö ryëmö jö n'onwongo tye gïnï ï cath ï dyekal öt k'Obanga. ");
INSERT INTO lth_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ën okobo nïgï nï, “Ëcöö nï, ‘Öda obedo öt më lëga,’ ëntö ïlökö unu ödökö öt k'ekwoe.” ");
INSERT INTO lth_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yecu obedo ka pwony ï öt k'Obanga nïnö kï nïnö ëntö ëlamdhök na dito ëka epwony cïk ka Muca ëka ëtëla ka lwak nökënë öcakö gïnï yübö kite më neko Yecu. ");
INSERT INTO lth_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ëntö ba onwongo gïnï yoo mörö më neko ën pïën lwak kïbëc opong n'öcïkö ithgï ï köp na ën kobo. ");
INSERT INTO lth_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ï nïnö mörö acël Yecu onwongo pwonyo ï öt k'Obanga nakun kobo köp më Emuth na Bër. Ëlamdhök na dito ëka epwony Cïk ka Muca kanya acël k'edong obino gïnï both Yecu, ");
INSERT INTO lth_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","cë openyo gïnï ën nï, “Kob nïwa, kit twër mënë n'ömïö ïtïmö koth tic ni,” ëka “Nga n'ömïö kit twërö ni?” ");
INSERT INTO lth_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yecu ögamö nï, “An thon apenyowu peny acël, ëk ikob nïna unu. ");
INSERT INTO lth_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Twërö n'onwongo Jon batica kï jïï ködë, öya kï both Obanga onyo öya kï both dhanö?” ");
INSERT INTO lth_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Gïn öcakö larö köp nön ï kin-gï kën-gï ëka okobo gïnï nï, “Ka onu ekobo nï öya kï ï polo, ën bino penyo nï, ‘Pïngö ba iyee unu ï kom Jon?’ ");
INSERT INTO lth_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ëntö ka onu ekobo nï, ‘Öya kï both dhanö,’ jö kïbëc bino celo onu kï kidi naka ï thöö, pïën jö kïbëc yee nï Jon obedo adwarpïny.” ");
INSERT INTO lth_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Cë dong gïn ögamö nï Yecu nï, “Wan ba engeo kanya twër nön öya kï ïë.” ");
INSERT INTO lth_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ëka Yecu okobo bothgï nï, “An thon ba abino kobo niwu kit twërö n'ömïö atio tic ni.” ");
INSERT INTO lth_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Cë Yecu öcakö bolo carolok ni both lwak nï, “Dhanö mörö yam tye n'opuro pwodho ölök mërë, ëka öwëkö ï cïng epur mökö. Ën öcïdhö ökö ï lobo nökënë më bedo ïë pï karë na lac. ");
INSERT INTO lth_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na karë më püdö ölök örömö, ën ooro atic mërë acël both epur ëk ëmïë ngö n'öcëk kï ï pwodho ölök. Ëntö epur opwodo atic nön ëka ëryëmö ödök kï cïngë nono. ");
INSERT INTO lth_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ën dök ooro atic mërë nökënë, cë gïn opwodo manön thon. Ëtïmö tïm më lewic ï kome ëka ëryëmö ödök kï cïngë nono. ");
INSERT INTO lth_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Cë dök ooro atic mërë më adek. Epur oketho ret ï kome ëka ëryëmö ökö kï ï pwodho ölök. ");
INSERT INTO lth_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Cë won pwodho ölök openyere kënë nï, ‘Abino tïmö ngö kobedini? Abino oro woda na an amarö, karë nökënë gïn bino wörö ën.’ ");
INSERT INTO lth_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ëntö ï karë n'etic önënö wod ka won pwodho, öcakö gïnï twak ï kin-gï nï, ‘Man ënë dong ngat na bino leeno jami, eru eneku ökö ëk jami na ën bino leeno obed më onu.’ ");
INSERT INTO lth_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Cë gïn dong ökwanyö ën kï ï pwodho ölök ëka eneko ökö.” Yecu dong openyogï nï, “Ngö na won pwodho ölök bino tïmö k'epur nön? ");
INSERT INTO lth_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ën bino dwogo ëka neko epur nön ökö kïbëc cë mïö pwodho ölök nön both epur nökënë.” Ï karë na jïï owinyo köp ni, okobo gïnï nï, “Adyer pathï kömanön!” ");
INSERT INTO lth_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yecu önënögï cë openyo nï, “Man kono gönyö nïngö na yam ëcöö nï, “ ‘Kidi n'egedo ökwërö, ënë ödökö kidi më gwïc öt’? ");
INSERT INTO lth_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jö kïbëc na bino podho ï kom kidi ni, bino tür ngïdhërë ökö, ëka ka kidi ni opodho ï kom ngat mörö, dhanö nonu bino ngïngïnya ökö.” ");
INSERT INTO lth_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Epwony Cïk ka Muca ëka ëlamdhök na dito örangö gïnï yoo më makö Yecu ï caa nön cücüth, pïën gïn önïang nï Yecu okobo carolok ni ï komgï. Ëntö olworo gïnï jïï. ");
INSERT INTO lth_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Epwony Cïk ka Muca ëka Ëlamdhök na dito obedo ka kürö karë na bër ëka eoro ërïp pïny n'oporo gïnï bedo jö na genere, ëk ëmak köp na yaa kï dhö Yecu ëka dong ëmïï ï cïng alöc na tye kï twër ï lobo Roma. ");
INSERT INTO lth_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Gïn openyo Yecu nï, “Apwony, engeo nï ïtwakö ëka ipwonyo köp na tye adyer ba ipoko kin dhanö, ëntö ipwonyo köp n'adyer ï kom Obanga. ");
INSERT INTO lth_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Cïk yeo nï wan myero ëcül ocoro both Cija onyo kür ëcül?” ");
INSERT INTO lth_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ëntö Yecu önïang ï ryëkögï cë openyogï nï, ");
INSERT INTO lth_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nyuth unu nïna denario acël. Cal ëka nyïng na tye ï kome ni më ka nga?” Gïn ögamö nï, “Më ka Cija.” ");
INSERT INTO lth_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Cë dong okobo nïgï nï, “Mïï unu jami ka Cija both Cija, ëka jami k'Obanga mïï unu both Obanga.” ");
INSERT INTO lth_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ba ötwërö gïnï makö köp mörö pï ngö na ën okobo kunön ï kin lwak, ëntö gïn ouro kite na Yecu ögamö kï köp ködë, cë ölïng gïnï alïnga. ");
INSERT INTO lth_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ecadukayo mökö na kobo gïnï nï cer ka jö n'öthöö ope, obino gïnï both Yecu kï peny. ");
INSERT INTO lth_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Gïn openyo Yecu nï, “Apwony, Muca yam ömïöwa cïk nï, ka ëcwö mörö öthöö n'öwëkö dhakö mërë na ba önywölö ëthïnö mörö, ömïn mërë na kwö myero olak dhakö nonu ëk önywöl ëthïnö ï wi ömïn mërë. ");
INSERT INTO lth_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yam onwongo tye utmego abïrö. Ngat na dit onyomo cë öthöö ökö na ba önywölö ëthïnö. ");
INSERT INTO lth_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ömïn mërë më arïö ölakö dha thöö ni cë ën thon öthöö ökö. ");
INSERT INTO lth_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Më adek dök ölakö dha thöö ni ën thon ba önywölö ködë ëthïnö. Ï yoo acël nonu, utmego abïrö ni ölakö dha thöö ni cë öthöö gïnï kïbëc na ba önywölö gïnï ëthïnö. ");
INSERT INTO lth_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ï ajiki mërë, dhakö ni öthöö. ");
INSERT INTO lth_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kobedini dong, ï nïnö na jö n'öthöö bino cer ködë dhakö ni bino bedo më ka nga pïën jö abïrö ni kïbëc obedo ködë?” ");
INSERT INTO lth_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yecu okobo nïgï nï, “Jö më karë ni nyömërë gïnï. ");
INSERT INTO lth_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ëntö jö na kitegï bër na bino gïnï cer ëka bino kwö gïnï ï lobo ca na nyen, ba bino nyömërë gïnï. ");
INSERT INTO lth_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ëka ba bino gïnï thöö na twal, pïën bino bedo gïnï kamë emalaika. Gïn bino bedo ëthïn k'Obanga pïën ebino cerogï kï ï thöö. ");
INSERT INTO lth_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ëka Muca omoko kanyalër nï jö n'öthöö bino cer. Ï köp na ën öcöö ï kom bunga na wang ën okobo nï Rwoth obedo ‘Obanga k'Abraam, Obanga k'Ecaka ëka Obanga ka Jakob.’ ");
INSERT INTO lth_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ën obedo Obanga ka jö na kwö ba obedo më ka jö n'öthöö, pïën jö kïbëc kwö pï Obanga.” ");
INSERT INTO lth_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Cë epwony Cïk ka Muca mökö okobo gïnï nï, “Apwony ïtwak na bër!” ");
INSERT INTO lth_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Cë ngat mörö ope n'öthamö më penyo ën peny nökënë dökï. ");
INSERT INTO lth_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yecu openyogï nï, “Ekobo nïngö ï kom Meciya na ën akwar Daudi? ");
INSERT INTO lth_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pïën Daudi kikome okobo ï buk më Jabuli nï, “ ‘Rwoth Obanga okobo both Rwodha nï, “Bed ï nget cïnga më kucem, ");
INSERT INTO lth_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","naka ka abino mïö ï löö langni ëka amïögï bedo na calö gin më theno tyeni.” ’ ");
INSERT INTO lth_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daudi cwodo ën nï, ‘Rwoth’ ën twërö bedo wode nïngö?” ");
INSERT INTO lth_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Na lwak kïbëc tye ka winyo ka Yecu twak, ën okobo both ëlübkörë nï, ");
INSERT INTO lth_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Gwökërë unu kï kom epwony Cïk ka Muca na marö gïnï woth kï böng na boco. Gïn mïtö nï jïï obed ka mothogï kï ï cuk, marö gïnï thon bedo ï then ka jö na döngö ï kabedo më wörö ï Cinagoga ëka ï kabedo më cem na döngö. ");
INSERT INTO lth_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Gïn jö nön maö jami ka mon thöö ëka dök marö gïnï lëga na boco më nyuthere. Obanga bino mïögï pwod na thwönë rwök.” ");
INSERT INTO lth_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yecu onwongo tye ï öt k'Obanga ëka önënö ëlönyö ka bolo gïnï tyërgï ï adïta më tyër. ");
INSERT INTO lth_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ën thon önënö dha thöö mörö n'obedo acan, obolo aböla arïö ï adïta më tyër. ");
INSERT INTO lth_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yecu okobo nï, “An akobo niwu köp adyer nï, dha thöö ni n'obedo acan ni, obolo tyër na thwönë rwök na löö jö kïbëc. ");
INSERT INTO lth_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pïën jö kïbëc ögïthö lïmgï kï kom mana thwönë ënë gïn obolo, ëntö dha thöö ni kadï bed onwongo obedo acan, obolo lïm kïbëc n'onwongo ën myero ökwö ködë.” ");
INSERT INTO lth_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ëlübkör Yecu mökö onwongo twak gïnï ï kom öt k'Obanga. Kit n'ëgërö ködë na bër kï kite na bëcö ëka tyër n'ëtyërö both Obanga. Cë Yecu okobo nï, ");
INSERT INTO lth_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kï kom ngö na un itye ka nënö ni, karë bino bino, na kidi mörö acël ba bino dodere ï wi awodhe, kidi acëlacël ebino thwarö ökö pïny.” ");
INSERT INTO lth_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ëlübkör Yecu openyo ën nï, “Apwony man bino tïmërë awene? Ëka ngö na bino nyutho nïwa nï jami ni dong cwök tïmërë?” ");
INSERT INTO lth_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yecu ögamö nï, “Gwökërë unu, ngat mörö kür öbwölwu. Pïën jö na pol bino bino gïnï kï nyïnga, na kobo gïnï nï, ‘An ënë Kiricito,’ ëka dök nï, ‘Karë dong onyingo cwök.’ Ëntö kür ilubugï. ");
INSERT INTO lth_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ka ibino winyo unu emuth më lwëny ëka arubaruba, kür ibed unu kï lworo. Jami ni myero kono ötïmërë ëntö bara nyutho nï ajiki dong cwök.” ");
INSERT INTO lth_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Cë Yecu okobo bothgï nï, “Lobe bino lwëny kï lobe nökënë, ëka ker bino lwëny kï ker nökënë. ");
INSERT INTO lth_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Oyeyeng na rac bino yengo lobo, kec ërön ëka twoe na papath bino podho ï lobo. Ëka thon ngö na mïö lworo makö dhanö, ëka anyuth thon bino nen ï polo. ");
INSERT INTO lth_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ëntö na bara jami ni kïbëc ötïmërë, ebino maköwu, ëka ebino ketho can ï komwu. Gïn bino terowu ï pido ï Cinagoga, ebino twenowu ï buc ëka ebino kelowu ï nyim rwodhi ëka ëlöc pï nyïnga. ");
INSERT INTO lth_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Man bino mïöwu karë më kobo caden më yeewu ï koma. ");
INSERT INTO lth_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pï manön, mok unu thamawu nï ba ibino parö unu ngö na un ibino kobo ï pido. ");
INSERT INTO lth_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Pïën An abino mïöwu ï twak kï ryëkö na ngat mörö n'odothowu ba twërö pyem ködë onyo kwërö ökö. ");
INSERT INTO lth_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Enyodowu, utmegowu, wedewu ëka nyikonei bino mïöwu ï cïng langwu. Gïn bino neko jö nökënë kï kinwu. ");
INSERT INTO lth_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Jö kïbëc bino dagöwu pïën ibedo unu ëlübköra. ");
INSERT INTO lth_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ëntö gin mörö na rac ba bino tïmërë ï komwu, kadï naka yer wiwu acël mörö ba bino rwenyo. ");
INSERT INTO lth_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ka icung unu na tëk, ibino nwongo unu kwö na bedo naka naka. ");
INSERT INTO lth_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ka ïnënö unu mwony örïkö Jerucalem, cë ingee unu nï karë më këthö dong onyingo na cwök. ");
INSERT INTO lth_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jö na tye ï Yudea myero öngwëc gïnï ï wi kite, jö na tye taun ï Jerucalem myero öya gïnï ökö, ëka jö na tye yökö kür myero ödöny gïnï ï taun. ");
INSERT INTO lth_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Pïën man ënë karë n'Obanga bino pwodo kï jö më Jerucalem më cobo köp kïbëc na yam ëcöö ï Cöc na Leng. ");
INSERT INTO lth_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mon na yeco ëka mon na dödhö ëthïnö bino nënö can ï karë nonu! Pïën can na thwönë bino podho ï lobo nön ëka akëmö k'Obanga na thwönë b