﻿USE sofia;
DROP TABLE IF EXISTS sofia.lro_vpl;
CREATE TABLE lro_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lro_vpl WRITE;
INSERT INTO lro_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ꞌTuꞌtu gwerre Ngwujaꞌri ngwuju, a Ngwujaꞌri ngwujaar Ngwaalu ngwe a Ngwujaꞌri ru Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ꞌTuꞌtu gwerre, nginde gwujaar Ngwaalu ngwe. ");
INSERT INTO lro_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yiꞌral ꞌdar yïgïꞌtïnä nginde gwe. A yiꞌral yere yaꞌti ju yïgïꞌtïnä, yaꞌti gïꞌtïnä nginde gwe. ");
INSERT INTO lro_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ꞌDünggüngün midi gwuju. A midi nggwee gwuru buri gwudi ngwüjï. ");
INSERT INTO lro_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ati buri oꞌrralu gïdïrïmänü aaꞌti be dïrïm burna ndi lenge. ");
INSERT INTO lro_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","A gur ji gani Yuwana gükäjä Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ngwilada ndi ondaci ngwüjü buri gwe, nunnu a ngwüjï ꞌdar ꞌdingini aar ämnï Ngwaalu nginde gwe. ");
INSERT INTO lro_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nginde gwani Yuwana giligoꞌro lüngün, gwäꞌtüdï gwanni gwuru buri. Nginde gwïndädï ꞌdogo ndi ondaji buri ngwe. ");
INSERT INTO lro_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ndi ari buri gwanni gwuru ꞌdidanu gwadi ila gïdïdlä ngwoꞌrraci ngwüjälü ꞌdar. ");
INSERT INTO lro_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ngwujaꞌri ngwuju gïdïdlä, ngwuru ngwanni ngwugeꞌta ngwe Ngwaalu dïdläyü, a je ꞌti be ngwüjü ngwudi dïdlä lïngïdï. ");
INSERT INTO lro_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nginde gwïndädï ngwüjï ngwüngün, a be ngwüjï ngwüngün ꞌdonya. ");
INSERT INTO lro_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","A be loko lanni gwuma aar gwe ämnï, lanni lima ämnï ngwürïny ngwüngün, lima aar je ätädä yelenya aar ru yïjï yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ngindenga läꞌtüdï yïjï yidi Ngwaalu lïngïnï gwe gwudi lingeno, aar ꞌti rüdï bupi gwudi dïjï, aar be ru lïngïnï gwe gwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A ngwujaꞌri ngwuma ru dïjï ngwuma ar le ji ꞌdengge. A lima engga näjïng gwüngün, näjï gwudi Gïjï ꞌdogo jücü ganni gïndï ndi Papa gonyadu gu yïmïꞌrü na ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nginde gwuru gwanni gwurnida gwe Yuwanalu dula gaji ganni giming ge ari, “Nginde gwuru be nggwee gwanni gwaru nyi gwe anni ariny, ‘Gwanni nggwo gwïndï gwodan, gwupana ꞌdünggüny ndi ari gwuju gwerre gwerre laꞌtiny na lïngïtï.’” ");
INSERT INTO lro_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yïmïꞌrü ye yüngün yanni yonyadu, yima aar nje ye onjaci ꞌdar, oꞌre aar nje ye onjaci. ");
INSERT INTO lro_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ndi ari Ngwaalu ngwätädï nje yobo yüngün ndi Müjä a be yïmïꞌrü yüngün na ꞌdidanu, aar nje be ätädä ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dïjï dere daꞌti ju aꞌtur dänggädï Ngwaalinga a be Gïjï ru ꞌdogo ganni giru Ngwaalu, ganni gijica Ngwaalinga ngwuru Papa kimere, giru ganni gima inggidi ngindeng. ");
INSERT INTO lro_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ngwujaꞌri ngwuru ngwee ngwudi Yuwana ngwanni ngwondajung je anni ma Ngwüyäwüd ngwudi Üräjälïmïng ükäjä ngwurꞌdala na Ngwullawi aar otacalu ndi ari nginde gwani yärü. ");
INSERT INTO lro_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aaꞌti Yuwana nyïꞌrïnä ndi ꞌtäjälü ngwuje ꞌtäcälü tired ngwuje ci, “Äny gwäꞌtüdï gwanni Gwubrutaar yelenya.” ");
INSERT INTO lro_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aar ci, “A mine nga gwani yärü? Nga gwuru gwani Ïlïyä?” Ngwuje ci, “Bärï nggwäꞌtüdï.” Aar ci, “Nga gwuru dïjïr danni daru de Ngwaalo?” Ngwari, “Bärï.” ");
INSERT INTO lro_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Gwurꞌtal ꞌdi aar ci, “Nga gwani yärü? Enggaci nje nga gwani yärü nyii kwoyalu nyii ondaci ngwüjü ngwanni ngwükäjï nje. Nga gwuca ligoꞌro lunga a gwani yärü?” ");
INSERT INTO lro_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A Yuwana apa ngwujaꞌri ngwanni ngwondaja je dïjïr didi Ngwaalu dani Ajaya ngwari, “Äny gwuru gwani dulu didi ngwujaꞌri ngwudi dïjï deꞌte danni durnidalu dula poor gïtäny ngwari, ‘Gïꞌtïjär Ngwaalu gay mama ngwüdünälü.’” ");
INSERT INTO lro_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A Ngwübärrïjï ngwoko ngwükäjäär je ");
INSERT INTO lro_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","otacalu aar ci, “Nga mine arra ma ang nyïnyï ngwüjü manari nga gwäꞌtüdï gwanni Gwubrutaar yelenya nga ꞌti rüdï gwani Ïlïyä, nga ꞌti rüdï dïjïr dere didi Ngwaalu?” ");
INSERT INTO lro_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","A je Yuwana ci, “Äny gwadi nyïnyï ngwüjü yaw ye ꞌdogo, a be gweꞌte nggwo gidiliganu gwaꞌti aang lïngïdï. ");
INSERT INTO lro_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nginde gwuru gwanni gwadi nyi gwujana gwodan gwupana ꞌdünggüny äny gwaꞌti ädï ꞌdünggüngün ndi nyi jürbälü nyi gwallada ngwaralu mbüny ngwudi ngwüdän ngwüngün.” ");
INSERT INTO lro_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yiꞌral giyee ꞌdar yiju ngwaalu ngwani Bidaniya dambal ndi üꞌrü yaanu yidi Ordoning ngwaalu ngwanni ngwuju gu Yuwana ndi nyïnyï ngwüjü. ");
INSERT INTO lro_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Bïgänü nggwoo a Yuwana enggada Yicung ndi ila ngwari, “Änggädär Giranyu gidi Ngwaalu giru be nggone ganni gadi äbrï keng gwudi ngwüjï ngwudi dïdlä! ");
INSERT INTO lro_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Gwuru be nggwee gwanni gwaru nyi gwe anni ariny, ‘Gwanni nggwo gwïndï gwodan gwupana ꞌdünggüny ndi ari gwuju gwerre gwerre laꞌtiny na lïngïtï.’ ");
INSERT INTO lro_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Äny gwaꞌti nyi lïngïdï, a be yanni yïgäbïcïny nyi be ilada ndi nyïnyï ngwüjü yaw ye, yiru ndi ari nunnu ngwüꞌtädïnälü Yïjïräyïl.” ");
INSERT INTO lro_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","A be Yuwana ondaji ngwujaꞌri ngwe ngwari, “Äny gwänggädï Lïgïꞌrïmä lidi Ngwaalu lüllü kerala nono amaam ngwaw nono. ");
INSERT INTO lro_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Gwaꞌti gwaadi nyi lenge a be Ngwaalu ngwanni ngwükäjïny ndi nyi nyïnyï ngwüjü yaw ye, ngwuru ngwuciny, ‘Gur ganni ga engga a gu Lïgïꞌrïm üllä ngwaw nono, nginde gwuru be gwanni gwadi nyïnyï ngwüjü Lïgïꞌrïm le lanni Lijuꞌru.’ ");
INSERT INTO lro_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Äny gwänggädï ngindeng a nggwondaja ndi ari Gïjï nggee giru gidi Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Bïgänü nggwoo, a Yuwananga ji ndi dünälä ngwooꞌra ngwe ngwüngün rom ngenone mana. ");
INSERT INTO lro_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Anni ma Yuwana enggada Yicung gwïndädï nono, ngwari, “Änggädär, Giranyu giru be nggee gidi Ngwaalu!” ");
INSERT INTO lro_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Anni ma ngwooꞌra ngwüngün rom ꞌdingini nggu ari no, aar aw Yicung giyora. ");
INSERT INTO lro_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","A Yicu gwurlalu ngwuje engga gwädäär giyora, ngwuje otacalu, “Ngaa lïmïnä ange?” Aar ci, “Gwani Doorta, nga ngwati ji ne?” ");
INSERT INTO lro_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","A je Yicu ci, “Ilar ngaa engga.” Lingen lïndï be ꞌdi ngwugwurli ngwuru kwoꞌrongo digera de ngindenga aar ele ꞌdi aar enggada ndi ari nginde gwati ji ne. Aar le jalu gomon nggoo. ");
INSERT INTO lro_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Gur geꞌte ngwooꞌranu ngwoo rom ngwudi Yuwana, gani Andrawuj, gwenggen gwudi Jamaan gwanni gwati aar ci Butruj ngindenga liru lani liꞌdingina Yuwanang anni ondajung. Aar ru lanni lima aw Yicu giyora. ");
INSERT INTO lro_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nginde ngwumbuji gwenggen gwani Jamaan gwerre gwerre ngwube ci, “Nyii lima mbuja ngindeng gwanni Gwubrutaar yelenya (gwani Kirictu).” ");
INSERT INTO lro_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","A nginde ru gwuma apa Jamaaning aar gwe ila ndi Yicu. A Yicu ombaji ngwube ci, “Nga gwuru gwani Jamaan gïjï gidi Yuna.” A be nga gwadi ani Japa (gwani ngwurꞌda). ");
INSERT INTO lro_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Bïgänü nggwoo a Yicu dïꞌrï gwadi ele Jälïl. Ngwumbuji guru gani Bïlïpüj ngwuci, “Gwujaniny.” ");
INSERT INTO lro_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Bïlïpüj gwati ji kündär gani Bid Jäyïdä gündär ganni gati gu Andrawujinga Butruj gwe ji. ");
INSERT INTO lro_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","A Bïlïpüj ele ngwumbuji guru gani Nataniyal ngwuci, “Änyängä limbuju dïjü danni daru de Müjä kitabanu gidi Yobo na danni daru de ngwïjïr ngwudi Ngwaalu giyitabanu yanni yullaar je, Yicu gwudi Najrang gïjï gidi Yüjïb.” ");
INSERT INTO lro_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","A Nataniyal ari, “Najra! Giru ange gere gidi Najrang gijaw?” A Bïlïpüj ci, “Ila ꞌdogo ang engga.” ");
INSERT INTO lro_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Anni ma Yicu engga Nataniyaling ndi ila nggwe ari, “Nggwo ngene gwanni gwuru Dïjïräyïl ꞌdidanu yere yaꞌti gu yiru ꞌtur.” ");
INSERT INTO lro_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","A Nataniyal otacalu ngwuci, “Nga gwülïngïdïny ne?” A Yicu ci, “Äny gwänggädängä ꞌtuꞌtu anaku ja gu na ndi jalu gidimnigoranu, gaji ganni gaꞌti ara ge na Bïlïpüj urnidu.” ");
INSERT INTO lro_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","A Nataniyal ari, “Gwani Doorta, nga gwuru Gïjï gidi Ngwaalu, nga gwuru Deleny didi Yïjïräyïl.” ");
INSERT INTO lro_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","A Yicu ci, “Nga gwämnä ꞌdünggüny ndi ari nggwuma ang ci nggwänggädängä ndi jalu gidimnigoranu. Ya je engga yanni yipana giyiꞌral giyee.” ");
INSERT INTO lro_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ngwoꞌre ngwugendaci ngwuci, “Äny gwadi ang ondaci ꞌdidanu ndi ari, nga gwa enggada gere ga ïgïtïnï, a gwa enggada yïꞌrrä yidi Ngwaalu yändï aar üllä Gïjü nono gidi Dïjï dümnä.” ");
INSERT INTO lro_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bïgï nggwo, a yïꞌrïnyïnä yidi giꞌtidi kay ji kündär gani Kana ngwaalu ngwani Jälïl. A gu nanni ji gwudi Yicu ꞌto ");
INSERT INTO lro_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","aar gu urnida Yicung je ngwoꞌra ngwe ngwüngün ꞌto aar ilada gïꞌrïnyïnä ngenone. ");
INSERT INTO lro_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Anni ma ngwüjï ngwudi yïꞌrïnyïnä ïyï diꞌrica ꞌdi ngwumedadi, a nanni gwudi Yicu ci Yicung nu, “Diꞌrica dima medadi.” ");
INSERT INTO lro_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","A Yicu ci, “Gwani daw, gaji güny gaꞌtina ïndï, a gwarra miny änïjï giyiꞌralanu giyee?” ");
INSERT INTO lro_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A nanni gwüngün ci ngwïnädä, “Yiꞌral yere yanni yadi ara je ye ci, ärrär je.” ");
INSERT INTO lro_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ngenone ngwïtï ngwuru yoꞌrr ngwuju ngwupa ngwupa ngwongranu ngwuru nyärläl (6) ngwati ape yaw yiꞌdukuranu küüꞌrï (20) ya küüꞌrï na ꞌdï (30). Yati ye Ngwüyäwüd gäꞌrïnï. ");
INSERT INTO lro_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","A Yicu ci ngwïnädä, “Onjajar je yaala.” Aar je onjajala ꞌdar kiꞌrony. ");
INSERT INTO lro_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ngwuje be ci, “Bälär je be ngaa je ätädä guru giru giꞌra gidi yïꞌrïnyïnä ngwuje ngille.” Aar je bälï aar je ätädä. ");
INSERT INTO lro_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","A je gur nggoo giru giꞌra gidi yïꞌrïnyïnä ngille, ngwuje mbuji yima gwurli diꞌrica. Ngwuꞌti lïngïdï ndi ari diꞌrica ndee dapaar ne, ngwïnäd ngwanni ngwapu yaw, ngwülïngïdï gu. A gur giru giꞌra urindi damal danni dadi agu ");
INSERT INTO lro_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ngwuci, “Ngwüjü ꞌdar ngwati ape diꞌrica danni dami gwerre gwerre a ngwüjï ïyï, ma be ari ngwuma rlälï, aar je be ätädä danni diki ngwulem gwodan. A be nga gwümätädï diꞌricalu danni damana nga apalu gwodan.” ");
INSERT INTO lro_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yiꞌremna yidi yiima yiru giyee yanni yärrä je Yicu gwerre gwerre kündär gani Kana gidi Jälïl, a nginde inggidi yiima yüngün yidi näjï a ngwooꞌra ngwüngün ämnï ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Anni ma yïꞌrïnyïnä medadi, a Yicu na nanni gwüngün na ngwenggen na ngwooꞌra ngwüngün, aar ꞌdïꞌrï aar ele Kaprnawum, ngenone, aar gu jalu yomon cong. ");
INSERT INTO lro_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","A anni ma yomon ji gito yidi Yïꞌrïnyïnä yidi Ngwüyäwüd yidi eny Ligiꞌra lidi Dambdani, a Yicu ꞌdïꞌrï ngwele kündär gani Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Anni mung obani ngwämrä kobo, ngwumbuji ngwüjü ngwati ellang ngwürä aar ellang ngwangala, na amaam ati aar üpïyï ꞌto ngwüꞌrïnyänü ngwudi gatalu kobo. ");
INSERT INTO lro_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ngwume diruula diru gar ngge linynya ngwüjälü ꞌdar ngwong ngwanu ngwanni ngwuju ngenone, ngwürä na ngwangal ngwüdïgïr bartadanu gwudi ngwüꞌrïny gwati ngwüjï üpïyänü ngwügwüꞌrübäjï ngwümbürälü. ");
INSERT INTO lro_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ngwuci ngwüjü ngwanni ngwïllï amaam, “ꞌTüyär ngwony ngwee a ngwe ele poor! Nga larra ngaa be ädïnï ngwuꞌdun ngwudi Papa gwüny ngaa je ruji ngwaalu ngwudi ngwiliny!” ");
INSERT INTO lro_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","A ngwooꞌra ngwudi Yicu diwayini ndi ari ngwujaꞌri ngwudi Ngwaalu ngwanni ngwüllïnä kitabanu ngwaru, “Eny giligoranu gwani ngwuꞌdun ngwunga gwati nyi uꞌdiyanu nono lïgä.” ");
INSERT INTO lro_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","A be Ngwüyäwüd bupi giꞌremna giru yiima ꞌdünggüngün. Aar otacalu aar ci, “Giꞌremna giru ange giru yiima ganni gadi ang ärrï nyii lenge ndi ari nga gwätï yelenya ndi ärrï yiꞌral giyee?” ");
INSERT INTO lro_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","A je Yicu ci, “Kiyar ngwuꞌduna ngwee aar ndralu gïdïyängälü, yomon ꞌtäꞌrïl ꞌdogo ngwunje ꞌdïꞌrïyälü mana.” ");
INSERT INTO lro_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","A Ngwüyäwüd ci, “Ngwuꞌdun ngwee ngwüdädäär je ngwüdläyü küüꞌrï rom na nyärläl (46) nga be ari ngwa je ꞌdïꞌrïyälü yomon täꞌrïl (3) awa?” ");
INSERT INTO lro_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","A be ngwuꞌdun ngwanni ngwäbïngädï gu Yicu, lingeno lüngün liru. ");
INSERT INTO lro_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Anni mung aji aar ꞌdïꞌrïyälü giyiꞌranyanu, a gu be ngwooꞌra ngwüngün diwayini ndi ari nginde gwabingana, aar ämnï ngwujaꞌri ngwudi Ngwaalu ngwanni ngwüllïnä kitabanu na ngwanni ngwondaja je Yicu. ");
INSERT INTO lro_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Gaji ganni gima ge Yicu ji kündär gani Üräjälïm Gïyïꞌrïnyïnä yidi Dambdani, a ngwüjï ngwonyadu engga yiꞌremna yidi yiima yanni yiming je ärrï aar ämnï ngwürïny ngwüngün. ");
INSERT INTO lro_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","A je ꞌti be Yicu gätïjä ngwäy ndi ari nginde gwülïngïdï yigor ꞌdar yidi ngwüjï ngwümnä. Nginde gwaꞌti amiꞌratu nunnu ngwubupi ");
INSERT INTO lro_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ngwujaꞌri ngwudi dïjï dümnä ngwani nginde, ndi ari nginde gwülïngïdï yiru ange giyo giligoranu lidi dïjï dümnä. ");
INSERT INTO lro_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","A gur geꞌte ju giru Dïbärrïjï gani Nïkïdïmüj giru giꞌra ngwelenyanu ngwudi ngwämrä ngwudi Ngwüyäwüd. ");
INSERT INTO lro_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Gïꞌdïꞌrü gomon geꞌte dilu de ngwelaca Yicung ꞌdunu ngwuci, “Gwani Doorta, änyängä lïlïngïdï ndi ari nga gwuru dïjï dükäjä Ngwaalu. Yiꞌremna yidi yiima yanni yata je ärrï, dïjï dere daꞌti dati je ärrï ꞌdogo manari dükäjü Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","A Yicu ci, “Nggwa ang ondaci ꞌdidanu ndi ari dïjï dere daꞌti da engga yelenya yidi Ngwaalu mung ꞌti lïngïnä lïngïnïng gwanni gwuyang.” ");
INSERT INTO lro_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","A Nïkïdïmüj ci, “Awa a be dïjï dïlïngïnä gwele ꞌdi ngwupe ngwube oꞌre ngwülïngïnï mana yomonanu rom. Awa mana ngwube oꞌre gilaranu lidi nanni?” ");
INSERT INTO lro_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","A Yicu ci, “Äny gwa ang ondaci ꞌdidanu, ndi ari dïjï dere daꞌti da engga yelenya yidi Ngwaalu daꞌti lïngïnä yaw ye na Lïgïꞌrïm le. ");
INSERT INTO lro_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Dïjï dïlïngïnä gilingeno diru lingeno, a dïjï dïlïngïnä Gïlïgïꞌrïm diru lïgïꞌrïm. ");
INSERT INTO lro_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‘Aaꞌti nga gwallalu ndïr ma ang ci ndi ari nga nga ꞌdar aang lïngïnï lïngïnïng gwanni gwuyang.’ ");
INSERT INTO lro_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Dirun dati arada kuyala ganni gïndïng gu. Nga be ꞌdingini aring gwüngün, nga ꞌti be lïngïdï ndi ari dïndï ne na dadi elada ne. Yiru gu ꞌto no gïdïjï dïlïngïnä Gïlïgïꞌrïm.” ");
INSERT INTO lro_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","A Nïkïdïmüj ci, “Awa gu aar gu be ru no?” ");
INSERT INTO lro_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","A Yicu ci, “Nga gwuru doorta dipa didi Yïjïräyïl, nga ꞌti be lïngïdï ngwujaꞌri ngwee yorto ye ngwaalinga? ");
INSERT INTO lro_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Äny gwa ang ondaci ꞌdidanu, änyängä lati ondaji ngwujaꞌri ngwanni ngwülïngïdï nje, na nje inggidi ngwanni gwänggädï nje, a be nga nga laꞌti ämnä ngwujaꞌri ngwärï. ");
INSERT INTO lro_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nga nga lati ꞌti ämnä manari lima je ondaci ngwujaꞌri ngwe ngwudi dïdlä ndee a be awa nga je be ꞌdingini ngwudi geraling manari ngwuma ar je ngwe ondaci? ");
INSERT INTO lro_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Dïjï dere daꞌti dändï kerala a be Gïjï gidi Dïjï dümnä ru geꞌte pu ganni gwüllü kerala.” ");
INSERT INTO lro_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","A Yicu ari, “Anaku allija gu gwerre Müjä düüngäyü diru laaba küꞌrälä poor gïtäny, Gïjï gidi Dïjï dümnä gadi aar gu alliji ꞌto no küꞌrälä. ");
INSERT INTO lro_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nunnu gwanni gwa ämnï ꞌdünggüngün gwa mbuji miding gwudi gwurꞌtaling.” ");
INSERT INTO lro_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","A Yicu ari, “Ndi ari Ngwaalu ngwämnä ngwüjü ngwudi dïdlä gwulleny ꞌdi ngwududiyi Gïjü güngün ganni giru geꞌte pu ꞌdogo nunnu ngwüllä ngwayi ngene nunnu gwanni gwa ämnï ꞌdünggüngün, gwaꞌti gwa ayi ngwube mbuji miding gwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ndi ari Ngwaalu ngwaꞌti ükäjä Gïjü güngün gïdïdlä nunnu ngwape yelenya a ngwüjï ayi, ngge be mïꞌrïnï nono nunnu ngwape yelenya a ngwüjï gïlängïdïnï nginde gwe. ");
INSERT INTO lro_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Gwanni gwämnï ꞌdünggüngün gwaꞌti aar gwe obalu ngwayi, a be gwanni gwaꞌti gwa ämnï ꞌdünggüngün, gwuru gwanni gwa aar gwe obalu gwa ayi, nunnu gwuma ꞌti ämnä ngwürïny ngwudi Gïjï gidi Ngwaalu ganni giralu geꞌte pu ꞌdogo. ");
INSERT INTO lro_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yeleny yiru giyee yanni yadi obalu ngwüjï ngwe, ndi ari buri gwuma ila gïdïdlä, ngwüjï ngwuma be ämnänï dïrïmü ngwaalu ngwudi buri ndi ari apepe gwegen gwuki. ");
INSERT INTO lro_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Gwere gwanni gwati ape gwuki, gwati ꞌti ämnä buri na ngwati ꞌti elella giburalu, a gwaꞌti gwila giburalu ndi ari gwa yedeny eny ndi ari apepe gwüngün gwanni gwuki gwa ꞌtädälü. ");
INSERT INTO lro_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","A be gwanni ngwati elelle ꞌdidanu gwe, gwati ele giburalu nunnu aar engga ndi ari apepe gwanni gwating ape gwäpïnä yiima ye yidi Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Anni ma ngwujaꞌri ngwee medadi, a Yicunga ngwooꞌra ngwe ngwüngün ꞌdïꞌrï aar ele ngwaalu ngwani Yäwüdïyä, aar ngwe jalu yomon cong ngwünyïnyï ngwüjü yaw ye. ");
INSERT INTO lro_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","A Yuwana Almamadan ji ꞌto ndi nyïnyï ngwüjü kïbüng ngwaalu ngwani Äyïnün ngwuju gito ngwaalu ngwani Jälïm ndi ari yaw yïrälü ngwaalu ngwoo, ati gu be ngwüjï oꞌrajidalu pïd pïd ngwuje nyïnyï. ");
INSERT INTO lro_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ngwujaꞌri ngwe ngwuju gwerre gwerre a be aji aar määtä Yuwanang aar giki korkon.) ");
INSERT INTO lro_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","A ngwooꞌra ngwudi Yuwana ngwoko garnati Dïyäwüd de deꞌte gïdïmürä didi gäꞌrïnï. ");
INSERT INTO lro_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ngindenga aar ele ndi Yuwana aar ci, “Gwani doorta gur gidi gomon nggong gija ge dambal Ordon, ganni gondaja ge gimbujiiny ndi nyïnyï ngwüjü yaw ye ngwüjï ꞌdar ngwuma oꞌrada ꞌdünggüngün.” ");
INSERT INTO lro_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A je Yuwana ci, “Dïjï dere daꞌti dätï gony gere manari gima ꞌti Ngwaalu ätädï kerala. ");
INSERT INTO lro_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nga nga yigoꞌro yalu liru ladi ondaji ndi ari äny gwaru nu, ‘Äny gwäꞌtüdï gwanni Gwubrutaar yelenya nyi be ru gwükäjäär nyi mädïnïjä.’ ");
INSERT INTO lro_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Gaga giru gidi gur ganni gadi agu. Dimaad danni dati jici gur nono ganni gadi agu, gating geraci länï ngwüdünïcï ngwujayanu manari giming ꞌdingini gondaju. Jayanu nggwäꞌdï gwüny gwuru gwuma be mbuti gwene. ");
INSERT INTO lro_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nginde gwuru gwadi elada gweere nyi be oꞌra gwodan.” ");
INSERT INTO lro_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nginde gwanni gwüllü kerala gwuru gwupana giyiꞌral ꞌdar, gwanni gwati ji gïdïyängälü gwudi dïyäng gwuru gwati ondaji ngwujaꞌri ngwudi dïyängälü. Gwanni gwüllü kerala, gwupana giyiꞌral ꞌdar anaku raar gu. ");
INSERT INTO lro_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nginde gwati ondaji ngwujaꞌri ngwanni ngwänggädïng je ngwuje ꞌdingini, a be dïjï daꞌti dere danni dämnä ngwujaꞌri ngwüngün. ");
INSERT INTO lro_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Dïjï danni dima je ämnï dima ondaji ndi ari Ngwaalu ngwuru ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ndi ari nginde gwanni gwükäjü Ngwaalu, gwondaja ngwujaꞌri ngwanni ngwükäjä ngwe Ngwaalu. Ndi ari Ngwaalu ngwati ätädä Lïgïꞌrïmä lanni lati ꞌti amiꞌratu. ");
INSERT INTO lro_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ngwaalu ngwuru Papa gwämnä Gïjü a giming ätädä yiꞌralalu ꞌdar kuyanu güngün. ");
INSERT INTO lro_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Gwere gwanni gwämnï Kïjï, gwätï miding gwudi gwurꞌtaling a be gwanni ngwa obe Gïjü gora ge, gwaꞌti gwengga miding gwudi gwurꞌtaling, ndi ari gwa gu güündä ji gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","A Ngwübärrïjï ꞌdingini ndi ari Yicu gwuma nyïnyänï gwuma biledani ngwoꞌra ndi Yuwana, ");
INSERT INTO lro_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","a be yanni yiru ꞌdidanu, Yicu gwäꞌtüdï gwünyïnyä ngwüjü, a be ngwooꞌra ngwüngün ru ngwünyïnyä je. ");
INSERT INTO lro_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Anni ma gu Yicu lenge, ngwüꞌdïꞌrï ngwugatani ngwaalinga ngwoo ngwani Yäwüdïyä ngwukwoyalu mana Jälïl. ");
INSERT INTO lro_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","A Yicu ꞌdïꞌrï ngwele gay ge gidi Jamrang. ");
INSERT INTO lro_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","No ngwele ngwobani ngenone Jamra kündär gani Jugar giju gito gito gïdïyäng danni dätädï Yagub gïjü güngün gani Yüjïb. ");
INSERT INTO lro_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Del diju gu didi yaw yidi ïyï danni dilutu Yagub. A Yicu ila gwugakidu dïlä ngwele ngwujalu gidelalu. Lingen le lïdünälä. ");
INSERT INTO lro_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Anni ma daw ꞌdeꞌte diru Dijamir elada ndi angiꞌri, a Yicu ci, “A gwuny gätïjä yaw nje ïye?” ");
INSERT INTO lro_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Kaji nggoo, ngwooꞌra ngwüngün ngwuma ꞌdïꞌrï aar ele ndi mïnä ngwony ngwudi eny kündär nggoo.) ");
INSERT INTO lro_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A daw ndoo diru Dijamir ci Yicung nu, “Nga gwuru Dïyäwüd nyi be ru Dijamir, awa nga be ätädä yaw yidi ïyï?” (Ndi ari Ngwüyäwüd ngwati aar ꞌti apajidu Ngwujamir ngwe.) ");
INSERT INTO lro_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","A Yicu ci, “Adinari nga gwülïngïdï angidacing gwudi Ngwaalu nga lenge ndi ari yärü gwuru nggwee gwucanga ätädïny nyi ïyï, gwadi ang otacalu gwadi ang ätä yaw yanni yimidu.” ");
INSERT INTO lro_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A be daw ci, “Gwani doorta, nga gwaꞌti ätï gony gada ge aga yaw a del dolanu. Nga gwadi apa yaw ne giyee yimidu? ");
INSERT INTO lro_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nga gwupana gïdïgüürnä därï dani Yagub gwanni gwülütïjï nje delo ndee nggu ïyï a gu yïjï yüngün ïyï ꞌto a gu ngwürä ïyï na yooꞌra yüngüne?” ");
INSERT INTO lro_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","A Yicu ci. “Dïjï danni dadi ïyï yaw giyee yara ye da ngwäädä eny mana, ");
INSERT INTO lro_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","a be dere danni dadi ïyï yaw yanni yinje ätädä, daꞌti ba be da ngwäädä eny bupud. ꞌDidanu da gu manni ngwäy ngwudi yaw yanni yinje ätädä obalu yïrälü ꞌdünggüngün aar ru midi gwudi gwurꞌtaling.” ");
INSERT INTO lro_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","A daw ci, “Gwani doorta, ätädïny yaw giyee nunnu aaꞌti ba be ngwäädä ngwuny eny ndi oꞌreꞌta ngene ndi angiꞌri yaw.” ");
INSERT INTO lro_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","A Yicu ci, “Ïndï, ang urnida duru dunga nga de ila ngene.” ");
INSERT INTO lro_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A daw gwäꞌräcänü ngwuci, “Nggwaꞌti ätï duru.” A Yicu ci, “Yijaw yunga yätï ngwäyänü anni aranga nggwaꞌti ätï duru. ");
INSERT INTO lro_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ndi ari gwerre a gwätï ngwuru ꞌtudini (5) na danni nda de gwenene, dur dunga däꞌtüdï. Yunga yanni yara ye yätï ngwäyänü.” ");
INSERT INTO lro_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A daw ci, “Gwani doorta, nggwänggädängä nono a gwuru dïjïr. ");
INSERT INTO lro_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ngwügüürnä ngwärï ngwäpïjä Ngwaalinga yobo ngene ken nggee ngaa be ari liru Ngwüyäwüd ngwaalu ngwere ngwaꞌti ngwa gu ngwüjï äpïjï Ngwaalinga yobo aar be ru ngweꞌte pu ꞌdogo ngwani Üräjälïm.” ");
INSERT INTO lro_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","A Yicu ci, “Ämnäcïny gwani daw ndi ari gaji nggo gïndï ganni gaꞌti ga aar ge äpïjï Papang yobo ken nggee na Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nga nga liru Ngwujamir lati äpïjï Ngwaalinga yobo ngwaꞌti aang lïngïdï yorto ye ngwaalinga. A be änyängä ngwati nje äpïjï yobo ngwanni ngwülïngïdï nje, ndi ari gilang gwadi ila Ngwüyäwüd. ");
INSERT INTO lro_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","A be gaji nggo gïndï a nggo gima ila gwenene, ndi ari lanni lati äpïjï Ngwaalinga yobo ꞌdiꞌdidanu, la äpïjï Papang yobo gïlïgïꞌrïm na ꞌdidanu, ndi ari liru yigor yanni yibupa je Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ngwaalu ngwuru lïgïꞌrïm a lanni lati äpïjï Ngwaalinga yobo, aar je äpïjï gïlïgïꞌrïm na ꞌdidanu.” ");
INSERT INTO lro_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A daw ci, “Nggwülïngïdï ndi ari gwanni Gwubrutaar yelenya (gwani Kirictu) gwadi ila, mung ila gwunje be enggaci ngwujaꞌralu ꞌdar.” ");
INSERT INTO lro_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","A be Yicu ari, “Äny gwuru nggwee gwani nginde gwondacanga gwenene!” ");
INSERT INTO lro_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kaji nggoo no, a ngwooꞌra ngwüngün oꞌra a je le ngwaalu elalu anni ma aar mbuji aar ji ndi ondaji daw de. Aaꞌti be dïjï dere ꞌdenggenanu otacalu ngwuci, “Giru ange gïmïnïng gidaw?” na “Darra ma de abingi?” ");
INSERT INTO lro_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A daw ꞌdïꞌrï ngwugatani dukulalu ngwukwoyalu kündär ngwondaca ngwüjü ngwuje ci, ");
INSERT INTO lro_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ilar aang engga dïjü denggaciny yiꞌralalu yüny ꞌdar yanni yärrï nje! Aaꞌti gwa ru gwanni Gwubrutaar yelenya?” ");
INSERT INTO lro_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","A ngwüjï ngwudi gündär ꞌtüdä aar gu ilada ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","A gaji ge nggoo, a ngwooꞌra ngwüngün ji ndi päcälü nunnu ngweny. Aar ci, “Gwani doorta, ïtï gwooko.” ");
INSERT INTO lro_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","A je be Yicu ci nu, “Nggwätï ngwony ngwüny ngwudi eny ngwaꞌti ngwe lïngïdï yorto ye ngwaalinga.” ");
INSERT INTO lro_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aaꞌti ngwooꞌra ngwüngün otajidalu aar ari, “Gwuma tani dïjï dimine äpïjä ngwony ngwere ngwudi enye?” ");
INSERT INTO lro_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","A Yicu ari, “Eny gwüny gwani ärrï buping gwudi Ngwaalu ngwuru Papa gwanni gwükäjïny, nyi medaji yiiru yüngün. ");
INSERT INTO lro_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ngaa lati ꞌti aru, ‘Giruny ga jalu ngwüüwäyü kwoꞌrongo ga aar be une?’ A be äny gwada je ci gätär manni ngwäyälü ngwalu aang ombaji ngwuruny! Ndi ari yona yima ojeme gaji gidi uni gegen gima ila. ");
INSERT INTO lro_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","A gwenene däänü didi uni dadi gwalli guꞌru güngün ngwuni yona gwani midi gwudi gwurꞌtaling. Nunnu gwanni gwükwüdï na gwanni gwunu aar jayanu ꞌdün. ");
INSERT INTO lro_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yätï ngwäyänü yanni yaru nu, ‘Gweꞌte gwati kwoy a gweꞌte gwati uni.’ ");
INSERT INTO lro_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Äny gwükäjä je ndi aang uni yona yaꞌta gu ïyü dïrbä dere, ngwüjï ngwoko ngwïyü gu dïrbä ngaa je be uni yidi dïrbä degen.” ");
INSERT INTO lro_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Lonyadu lidi Jamirang kündär nggoo aar ämnï ꞌdünggüngün gwani ngwujaꞌri ngwudi daw ndoo ngwaru, “Denggaciny yiꞌralalu yüny ꞌdar yanni yärrï nje.” ");
INSERT INTO lro_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","No anni ma ngwüjï ngwudi Jamirang elaci, aar päcälü ndi ari aar le jalu, aar le jalu yomon rom ngeno. ");
INSERT INTO lro_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","A gwani ngwujaꞌri ngwüngün, a ngwüjï ngwonyadana ämnï ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aar ci dayu, “Änyängä gwenene laꞌti ba be ämnä nunnu gwani ngwujaꞌri ngwunga ꞌdogo, änyängä gwenene lima ꞌdingini yigoꞌro ye yärï a nyängä lïlïngïdï ndi ari gur nggee, ꞌdidanu nginde gwuru gwanni gwuru Gilang gwudi ngwüjï ngwudi dïdlä.” ");
INSERT INTO lro_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Anni ma yomon ele aar ru rom(2) a Yicu ꞌdïꞌrï ngwele Jälïl. ");
INSERT INTO lro_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Yicu gwaru gwerre nu dïjïr didi Ngwaalu dati ꞌti ngwüjï näjä ngwujaꞌri ken güngün.) ");
INSERT INTO lro_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Anni ma Yicu obana Jälïl, a Ngwüjälïl ape aar gwäꞌrï. Anaku änggädär gu yiꞌral ꞌdar yanni yärrüng je Üräjälïm kaji ganni giju ge Yïꞌrïnyïnä yidi Dambdani. Ndi ari ngindenga liju gu ꞌto Gïyïꞌrïnyïnä giyoo. ");
INSERT INTO lro_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","A Yicu obani Kana Jälïl mana, ngwaalu ngwanni ngwügwürlïng gu yaw aar ru diꞌrica. A ngwaalu ngwani Kaprnawum, gïjï gidi dïnäd didi deleny gümä gu. ");
INSERT INTO lro_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Anni mung ꞌdingini ndi ari Yicu gwïndï Yäwüdïyä gwuma ila Jälïl, ngwüꞌdïꞌrï ngwelaci ngwuci nu aar gwe üllï Kaprnawum nunnu ngwuꞌriya gïjü nono güngün ndi ari gümä gani yiꞌrany. ");
INSERT INTO lro_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","A be Yicu ci, “Nga nga lati ꞌti ämnä ngwujaꞌri ma aang ꞌti änggädï yiꞌremna yidi yiima na allalu ndïr.” ");
INSERT INTO lro_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","A deleny ci, “Gwani doorta, üllädä gwänü nda gïjï güny ayi!” ");
INSERT INTO lro_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","A Yicu ci nu, “Ïndï, gïjï gunga ga midi.” A gur ämnäcï Yicung ngwujaꞌri ngwüngün ngwüꞌdïꞌrï ngwele. ");
INSERT INTO lro_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Anni mung ji ndi üllï aar mbudi ngwïnäd ngwe ngwüngün kay aar ondaci aar ci gïjï gima midi. ");
INSERT INTO lro_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Anni mung utalu gaji ge ganni guꞌrung ge nono, aar ci, “Guꞌru nono lungge gaji ge geꞌte pu gilingen ligwurlu.” ");
INSERT INTO lro_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","A gu mbumbu lenge ndi ari gaji giru ganni gima ge Yicu ci ndi ari, “Gïjï gunga ga midi.” No nginde na ngwüjï ngwüngün gïdrü ꞌdar aar gwe ämnï. ");
INSERT INTO lro_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yiima yiru mana yomon rom (2) yanni yärrä je Yicu anni mung gatana Yäwüdïyäng ngwoꞌra Jälïl. ");
INSERT INTO lro_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Anni ma ngwujaꞌri medadi ngwee, a Yicu ꞌdïꞌrï ngwallu kündär gani Üräjälïm gïyïꞌrïnyïnä yidi Ngwüyäwüd. ");
INSERT INTO lro_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ngenone Üräjälïm gito gito gïlängïr lati gu ngwangala ꞌtü, gïbüng giju gani Bidajida Yïbrïyängä güꞌrïdï yurdalu ꞌtudini. ");
INSERT INTO lro_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ngwüjï ngwundru gu ngwonyadu ngwümä, ngwoko ngwürïmü ngwäy na ngwoko ngwuru ngwumjo na ngwoko ngwuru ngwurga. Ngwati jalu aar dünïcï yaw nunnu aar je lagajanu. ");
INSERT INTO lro_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ngenone gur geꞌte giju gu ganni gümä ꞌdi ngwätï ngwüdläyü ꞌdï täꞌrïl na ꞌdübä (38). ");
INSERT INTO lro_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Anni ma Yicu engga gindralu ngenone, ngwulenge ndi ari gümä ngwüdläyü ngwolanu ngwotacalu ngwuci, “Nga gwümïnü ndi uꞌri nono?” ");
INSERT INTO lro_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","A gur ci Yicung, “Gwani doorta, äny gwaꞌti ätï dïjälü dere danni dadiny degeꞌdaji nunnu nyi üllï giyaanu, manari yaw yima lagananu ati aar nyi ngwüjï dalmacani aar nyi gatanalu, aar üllï giyaanu gwerre gwerre.” ");
INSERT INTO lro_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","A Yicu ci, “ꞌDïꞌrü ang apani gïlälälü gunga ang ele.” ");
INSERT INTO lro_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","No a gur uꞌri nono ngwüꞌdïꞌrälü ngwape gïlälälü güngün ngwele. Gomon ganni gäpädï ge Yicu yiima, gomon giru ganni giru Kwoꞌra täꞌrïl. ");
INSERT INTO lro_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","No a ngweleny ngwudi Ngwüyäwüd ci guru nggoo gäpädäär yiima, “Gomon gidi gweneneng giru ganni giru Kwoꞌra täꞌrïl, yiru drü ndi ape gïlälä gunga!” ");
INSERT INTO lro_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","A je gur ci, “Gwanni gwäpädïny yiima gwuru gwuciny, ‘ꞌDïꞌrälü ang apani gïlälälü gunga ang ele.’” ");
INSERT INTO lro_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aar otacalu aar ci, “Yärü gwuru gwanni gwucanga apa gïlälälü gunga ang ele?” ");
INSERT INTO lro_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","A be gur ganni gäpädï Yicu yiima, gaꞌti lïngïdï ndi ari yärü gwuru gwanni gwäpädï yiima, ndi ari Yicu gwuma ari miꞌrony ngwüjänü ngwonyadu ngwuju ngwele. ");
INSERT INTO lro_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kaji giꞌter a Yicu mbuji guru nggoo gäpädïng yiima kobanu, ngwuci, “Nga nggwo gwuma uꞌri nono, aaꞌti ba be a gwa ärrï yiꞌral yanni yiki, yaa a gwa oꞌre ya je mbuji yanni yikana.” ");
INSERT INTO lro_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","A gur ꞌdïꞌrï ngwele ngwondaci Ngwüyäwüd ndi ari Yicu gwuru gwanni gwäpädï yiima. ");
INSERT INTO lro_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","No nunnu Yicu gwärrü yiꞌral giyee gomon ganni giru Kwoꞌra täꞌrïl, a Ngwüyäwüd ꞌdïꞌrï aar übïnälü. ");
INSERT INTO lro_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","A je Yicu ci, “Papa gwüny nggwona gwapu yiiru gweneno na äny ꞌto nggwo gwapu yiiru.” ");
INSERT INTO lro_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yiru giyee yanni yïgäbïcï Ngwüyäwüd aar mïnänï ndi ꞌrinye. Gwati aar mïnü ndi ꞌrinye ꞌdogo nunnu gwuma kiyi gomonanu giru Kwoꞌra täꞌrïl, aar be ru ndi ari gwaru Ngwaalu ngwuru Papa gwüngün ngwübïdïyï ligoꞌranu lüngün Ngwaalu ngwe. ");
INSERT INTO lro_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","A je Yicu ci, “Äny gwenggaca je ngwujaꞌri ngwanni ngwätï ngwäyänü, ndi ari Gïjï gati ꞌti apu yiiralu yere giligor lüngün, nginde gati ape yiiru yanni yänggädïng je ndi Papa gwüngün yärrüng je, a je be Gïjï ärrï ꞌto. ");
INSERT INTO lro_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ndi ari Papa gwämnä Gïjü ngwenggaci yiꞌral ꞌdar yanni yating je ärrï. Nginde yäy genggacung yiꞌral yanni yipana giyiꞌral giyee ya je enggada yaji ya je allijalu ndïr. ");
INSERT INTO lro_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ndi ari anaku ati gu Papa ꞌdïꞌrïyï ngwüjälü ngwayu ngwuje midiyi, yiru gu ꞌto Kïjï güngün. Gïjï ga midiyi ngwüjü ꞌto ngwanni ngwüjädïng je ndi midiyi. ");
INSERT INTO lro_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","A mana yaꞌti ani Papa gwuru gwanni gwadi obalu dïjï de a be nginde gwuma ätädä Gïjü yelenyalu ꞌdar ");
INSERT INTO lro_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","nunnu a Gïjï näjïnï yelenya anaku näjïnä gu Papa yelenya. Gwere gwanni gwuma ꞌti näjä Gïjü, gwaꞌti gwa näjï Papang, gwanni gwükäjä.” ");
INSERT INTO lro_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","A Yicu ari, “Nggwa je ondaci ꞌdidanu, dïjï danni da ꞌdingini ngwujaꞌri ngwüny ngwube ämnï nginde gwanni gwükäjïny, gwa mbuji miding gwudi gwurꞌtaling. A nginde gwaꞌti ba be gwa aar gwe obalu. Nginde gwuma dambu yiꞌrany gwuma ele ndi midi. ");
INSERT INTO lro_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Äny gwondaca je ꞌdidanu ndi ari gaji nggo gïndï a nggee gima ila ganni gadi ge ngwüjï ngwanni ngwayu ꞌdingini dula didi Gïjï gidi Ngwaalu a lanni liꞌdingina la midi. ");
INSERT INTO lro_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ndi ari anaku ati gu Papa midiyi giligoꞌro lüngün, nginde gwuma ätädä ꞌto Gïjü midiying giligoꞌro lüngün. ");
INSERT INTO lro_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","A giming ätädä yelenya ndi obalu ngwüjï ngwe ndi ari giru Gïjï gidi Dïjï dümnä.” ");
INSERT INTO lro_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","A je Yicu ci, “Aaꞌti nga la dibi ngwujaꞌri ngwee, gaji gadi ila ngindenga ꞌdar ngwumomanu layu la ꞌdingina dula düngün ");
INSERT INTO lro_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","a la ꞌtüdä. Lanni lärrä yiꞌral yanni yijaw la ꞌdïꞌrälü la aar je ätädä miding na lanni lärrä yiꞌral yanni yiki la ꞌdïꞌrälü la aar le obalu giyiꞌrany. ");
INSERT INTO lro_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Äny gwaꞌti gwärrï yiꞌral yere guy ge güny, yatiny ye obalu ꞌdogo anaku ꞌdingini nje gu Ngwaalu na obalu gwüny gwüdünälü. Ndi ari äny gwaꞌti mïnü ndi jada ligor lüny, nyi be mïnï ndi jada ngindeng gwanni gwükäjïny.” ");
INSERT INTO lro_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","A Yicu ari, “Adinari äny gwati ondajaji giligoꞌro lüny, ngwujaꞌri ngwüny ngwaꞌti ngwadi ätï ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","A be nggwo gwuꞌter gwanni gwati ondaji ngwujaꞌri ngwani ligoꞌro lüny nyi be ari ngwujaꞌri ngwüngün ngwätï ngwäyänü.” ");
INSERT INTO lro_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","A je Yicu ci, “Nga nga lükäjä ngwüjü ndi Yuwana ngwuje ondaja ngwujaꞌri ngwanni ngwätï ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yaꞌti ani ndi ari äny gwämnä ondajing gwudi dïjï dümnä a be äny gwaru gu nunnu ngaa gïlängïdïnï. ");
INSERT INTO lro_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yuwana anni ïndïng, gwuru nono buri gwanni gwuꞌdu ngwoꞌrralu, nga lima jayanu buri gwe gwüngün gaji gooko.” ");
INSERT INTO lro_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ngwari, “A be ondaji gwani äny gwätïny gwanni gwupana guꞌru ndi ondaji gwudi Yuwana gwani äny. Ndi ari yiꞌral yanni yükäcär nje gu Papa ndi ärrï, yiru yanni yadi inggidi ndi ari Papa gwuru gwükäjïny. ");
INSERT INTO lro_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","A Papa gwanni gwükäjïny nginde giligoꞌro lüngün gwondaja ngwujaꞌri ngwani äny. Nga nga gwaꞌti aang ꞌdingina dula düngün gomon gere aꞌtur ngaa ꞌti änggädï ngwäyänü ndi ari gwuru ꞌtaa. ");
INSERT INTO lro_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yiru yanni yïgäbïcä je ngaa laꞌti ämnä ꞌdünggüngün gwanni gwükäjïng, ngwujaꞌri ngwüngün ngwaꞌti giyigoranu yalu aꞌtur. ");
INSERT INTO lro_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ngaa lati ombaji Yitabanu yanni yüllïnä nunnu aang mbuji miding gwudi gwurꞌtaling. A be Yitab yanni yüllïnä yinggidu ngwujaꞌri ngwani äny ");
INSERT INTO lro_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ati a be ꞌdonya ndi ila ꞌdünggüny nunnu aang mbuji miding gwudi gwurꞌtaling.” ");
INSERT INTO lro_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ngwuje ci, “Äny gwaꞌti mïnä ortadang ngwudi ngwüjï ");
INSERT INTO lro_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","a be äny gwülïngïdä je. Äny gwülïngïdä je ndi ari ngaa laꞌti ätï ämnïng gwudi Ngwaalu giyigoranu yalu. ");
INSERT INTO lro_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Äny gwïndï ngwürïny ngwe ngwudi Papa gwüny nyii be ꞌdonya, ma be ari dïjï diꞌter dima ila ngwürïny ngwe ngwudi ligoꞌro lüngün ngaa be ämnäcï. ");
INSERT INTO lro_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Awa ngaa be ämnäcï Ngwaalinga manari ngaa lati ortajidi yigoꞌro yalu ngaa ꞌti be undu ngwäy ngaa määtä ortadang gwanni gwïndï Ngwaalu ꞌdogo?” ");
INSERT INTO lro_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ngwuje ci, “Aaꞌti ngaa lari äny gwuru gwada je üꞌrïdä ngwujaꞌri nono ndi Papa. Dïjï ndo danni dada je üꞌrïdä ngwujaꞌri nono Ngwaalu. Müjä gwuru gwanni nggwo gwügätädä gu ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Adinari ngaa la ämnäcä Müjäng, ngaa laadiny ämnäcï. Ndi ari Müjä gwuru gwanni gwullu ngwujaꞌri ngwani äny. ");
INSERT INTO lro_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","A be anni aaꞌti aang ämnä ngwujaꞌri ngwanni ngwullung je, a mine awa ngaa je be ämnï ngwanni ngwa je ngwe ci?” ");
INSERT INTO lro_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Anni ma gaji nggoo ele, a Yicu ꞌdïꞌrï ngwüꞌrü yaanu yidi Jälïlïng (yati aar je ci ꞌto yaw yidi Täbïrïyäng.) ");
INSERT INTO lro_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","A ngwüjï ngwonyadu gwujani anaku ma aar gu enggada yiꞌremna yidi yiima yanni yärrüng je ngwüjï ngwanni ngwümä. ");
INSERT INTO lro_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","A Yicu ꞌdïꞌrï aar allu kenala ngwooꞌra ngwe ngwüngün aar jalu ngenone. ");
INSERT INTO lro_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yomon yidi Yïꞌrïnyïnä yidi Dambdani yidi Ngwüyäwüd aar ji gito. ");
INSERT INTO lro_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","A Yicu ꞌdïꞌrïyï ngwäy ngwengga ngwüjü ngwonyadu ngwelaca, ngwuci Bïlïpüjïng nu, “Ngwüjï ngwee ꞌdar ngwadi ar je ïllïjä yona ne aar je eny?” ");
INSERT INTO lro_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Gwutalu no nunnu ngwïdäjï ngindeng. Ndi ari nginde gwülïngïdï yiꞌral giligoranu lüngün nunnu gwadi ärrï ange. ");
INSERT INTO lro_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","A Bïlïpüj ci nu, “Ma ar ni ari a lima illa yona yidi ngwüꞌrïny ngwudi yiiru ngwüüwäyü ꞌdübä, yaꞌti ya mbuti nunnu a dïjï agu ngwügätïnï ngwulemanu!” ");
INSERT INTO lro_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A dooꞌra düngün diꞌter ngwooꞌranu, Andrawuj gwenggen gwudi Jamaan gwani Butruj ngwüꞌdïꞌrï ngwari, ");
INSERT INTO lro_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Gïjï geꞌte nggo ngene gätï yona ꞌtudini na ngwuum rom ngwani ngwooko. A be ngwa ar je ätädä yärüng ngwee ngwüjï ngwee ngwonyadu?” ");
INSERT INTO lro_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","A je be Yicu ci, “Geꞌtar ngwüjü aar jalu.” Ngwaalu ngwo, ngwüꞌtüdï gu yanya yonyadu. No a ngwüjï jalu, ngwur ngwuru ngwüüꞌrï tudini (5000). ");
INSERT INTO lro_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","A Yicu ape yona ngwuci Ngwaalinga yäy ꞌtu ngwuje be gegenaci ngwüjü ngwanni ngwujalu ati dïjï ape anaku mïnïng gu. Ngwoꞌre nggu ärrï ngwuuma mana ngwuje gegenaci. ");
INSERT INTO lro_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Anni ma aar eny ꞌdi aar pe, a Yicu ci ngwoꞌra ngwüngün, “Utar yonalu ngwuum ngwanu ngwanni ngwuma ïꞌdälü ngwüꞌrïꞌtänü. Aaꞌti ngwere ngwa geradalu.” ");
INSERT INTO lro_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","No anni ma aar je gwäꞌräjï giꞌdu aar je ape yiꞌramanu ꞌdï na rom ngwudi yon tudini yanni yima aar je eny ꞌdi aar je gwäꞌrï. ");
INSERT INTO lro_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Anni ma ngwüjï enggada yiima yanni yima je Yicu ärrï, aar ari, “ꞌDidanu dïjïr didi Ngwaalu diru ndee danni dadi ila gïdïdlä.” ");
INSERT INTO lro_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","A Yicu lenge ndi ari ngindenga lïmïnü gwadi aar ruji deleny degen yiima ye, ngwüꞌdïꞌrï ngwele ngwukwoyalu gweꞌte pu kenala. ");
INSERT INTO lro_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Anni ma ngwalu ru digera, a ngwooꞌra ngwudi Yicu ꞌdïꞌrï aar üllï giyaw ");
INSERT INTO lro_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","aar änï gïbälükänü aar üꞌrü yaanu aar elada Kaprnawum. Gaji nggoo a ngwaalu ru dilu, a je ꞌtina Yicu bürnädï. ");
INSERT INTO lro_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A dirun ꞌdïꞌrä a dudu ji diki giyaanu ngwulagaji yaanu. ");
INSERT INTO lro_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Anni ma ngwooꞌra ngwudi Yicu ruyi bälükä ꞌdi ape bränü täꞌrïl (3) gwalla bränü täꞌrïl na gwüꞌränü (3.5), aar enggada Yicung gwïndï giyaala ngwelada bälükä nono a je yedeny eny. ");
INSERT INTO lro_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","A je be Yicu ci nu, “Äny gwuru ara je ꞌti yedeny ïtï.” ");
INSERT INTO lro_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Anni ma aar gatu yigoralu aar änïjï gïbälükänü no aar mbuji ndi ari lima obani kïmämü ngenone ngwaalu ngwanni ngwïndädäär gu. ");
INSERT INTO lro_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","A bïgänü nggwoo, anni ma ngwüjï ngwonyadu ngwanni ngwujalu dambal ngenone, aar engga ndi ari bälükä gwuru gweꞌte pu ꞌdogo ngenone a gu ꞌti Yicu janu aar be ruyi bälükä jücü. ");
INSERT INTO lro_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","A be ngwübälükä ila ngwuꞌter ngwaalu ngwani Täbïrïyä aar dünï ngwaalu ngwanni ngwiya gu Yicu ngwüjü yona anni ma Deleny ci Ngwaalinga yäy ꞌtu. ");
INSERT INTO lro_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Anni ma ngwüjï lenge ndi ari Yicunga ngwooꞌra ngwe ngwüngün laꞌti ngenone, aar ꞌdïꞌrï aar änï ngwübälükänü aar ele ngwaalu ngwani Kaprnawum ndi mïnï Yicung. ");
INSERT INTO lro_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Anni ma aar mbuji dambal ngenone aar ci, “Gwani doorta, nga gwuma ila jadu ngene?” ");
INSERT INTO lro_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","A je Yicu ci, “Nggwa je ondaci ꞌdidanu ndi ari nga nga laꞌtiny mïnä ndi ari nga nga länggädï yiꞌremna yidi yiima, aar be ru ndi ari ngaa lïtï yona nga je pe. ");
INSERT INTO lro_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aaꞌti ngaa lapada yiiru ngwong ngwudi eny ngwanni ngwati ꞌdigiꞌri ngaa be apada yiiru ngwong ngwudi eny ngwanni ngwati midiyi miding gwudi gwurꞌtaling gwanni gwadi aar je Gïjï gidi Dïjï dümnä ätädä nginde gwe, gwuma gu Ngwaalu ngwuru Papa mïꞌrä dämïꞌrä.” ");
INSERT INTO lro_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Aar be otacalu aar ci, “Änynängä ladi ärrï ange nunnu nyii ärrï bupi gwudi Ngwaalu?” ");
INSERT INTO lro_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","A je Yicu ci, “Yiiru yidi Ngwaalu yiru giyee, ndi ämnï ꞌdünggüngün gwanni gwükäjïng.” ");
INSERT INTO lro_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","No aar ci, “Yiima yiru ange yanni yadi je ärrï ꞌdi nje engga ara gu ämnäcï? Yiru ange yanni yada je ärrï? ");
INSERT INTO lro_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ngwügüürnä ngwärï ngwïtï män poor gïtäny a yüllïnä kitabanu ndi ari, ‘Ngwüllücäär je yona kerala aar je eny.’” ");
INSERT INTO lro_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","A je Yicu ci, “Nggwa je ondaci ꞌdidanu ndi ari Müjä gwäꞌtüdï gwüllücä je yona kerala a be Papa gwüny ru gwanni gwätädä je gwenene yona yanni ru ꞌdidanu yüllü kerala. ");
INSERT INTO lro_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ndi ari eny gwudi Ngwaalu ngwuru ngwani nginde gwanni gwüllü kerala ngwätädä ngwüjü miding.” ");
INSERT INTO lro_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Aar ci, “Gwani doorta, ꞌtuꞌtu gomon gidi gweneng ätädï nje yona giyee.” ");
INSERT INTO lro_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","A Yicu ari, “Äny gwuru eny gwudi midi. Gwanni gwadi ila ꞌdünggüny gwaꞌti gwa ngwamu enyanu na gwanni gwadi ämnï ꞌdünggüny gwaꞌti gwa ngwäädä eny aꞌtur. ");
INSERT INTO lro_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","A be anaku ca je gu nunnu ngaa liminy engga ngaa ꞌtina be ämnä ꞌdünggüny. ");
INSERT INTO lro_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ꞌDar lanni lätädäär nje Papa la ila ꞌdünggüny a gwanni gwila ꞌdünggüny gwaꞌti gwunyi linynyi. ");
INSERT INTO lro_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ndi ari äny gwüllü kerala gwaꞌti üllädï ndi ärrï yiiru yidi ligoꞌro lüny nyi be üllädä ndi ärrï yiiru yidi nginde gwanni gwükäjïny. ");
INSERT INTO lro_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na bupi gwudi nginde gwanni gwükäjïny gwuru nggwee ndi ari aaꞌti gwunyi gäbïcï gwere gwa dudi gwanni gwuma aar nyi ätädä nje be ꞌdïꞌrïyälü komon nggäꞌdï gidi mïꞌrä. ");
INSERT INTO lro_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ndi ari bupi gwudi Papa gwuru ndi ari dïjï dere danni da ombaji Gïjü nggu ämnädä, da mbuji miding gwudi gwurꞌtaling na diny ꞌdïꞌrïyälü komon nggäꞌdï gidi mïꞌrä.” ");
INSERT INTO lro_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","A Ngwüyäwüd ꞌdïꞌrï aar äbïngïnï giyenenanu ndi ari Yicu ondaja ndi ari, “Äny gwuru eny gwanni gwüllü kerala.” ");
INSERT INTO lro_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Aar ari, “Yicu nggwee gwäꞌtüdï mine gïjï gidi Yüjïb, gwanni gwülïngïdär gwe papang gwüngün na nanni gwüngüne? Awa gwenene ngwube ari, ‘Nggwüllü kerala’?” ");
INSERT INTO lro_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","A je Yicu ci, “Ngaa ꞌti äbïngïnü giyenenanu yalu! ");
INSERT INTO lro_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Dïjï dere daꞌti da ila ꞌdünggüny manari Papa gwüny gwanni gwükäjïny gwäꞌtüdï gwanni gwüktädï ꞌdünggüny a diny ꞌdïꞌrïyälü komon nggäꞌdï gidi mïꞌrä. ");
INSERT INTO lro_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yullu je ngwïjïr ndi ari, ‘La je Ngwaalu enggaci ngindenga ꞌdar.’ Dïjï dere danni da ꞌdengenaci Papang ngwulenge ꞌdünggüngün, dila ꞌdünggüny. ");
INSERT INTO lro_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Dïjï dere daꞌti danni dänggädï Ngwaalinga ngwube ru gweꞌte pu gwanni gwïndï Ngwaalu. Gwuru ꞌdogo jücü gwanni gwänggädï Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nggwa je ondaci ꞌdidanu ndi ari, gwanni gwämnï gwa mbuji miding gwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Äny gwuru eny gwudi midi. ");
INSERT INTO lro_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ngwügüürnä ngwalu ngwïtï män poor gïtäny ngwuma be ayi. ");
INSERT INTO lro_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","A be ngene eny nggwo gwanni gwüllü kerala, ma dïjï eny daꞌta be da ayi. ");
INSERT INTO lro_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Äny gwuru eny gwanni gwumidu gwanni gwüllü kerala. Manari dïjï dere dima eny enying nggwee, da midi gwurꞌtal. Eny nggwe gwani lingeno lüny lanni ladiny geꞌte gwani midi ngwudi ngwüjï ngwudi dïdlä.” ");
INSERT INTO lro_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","A Ngwüyäwüd garnatajidi gwulleny aar ari, “Awa aar nje be ätädä lingeno lüngün aar eny?” ");
INSERT INTO lro_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","A je be Yicu ci, “Nggwa je ondaci ꞌdidanu ndi ari manari ngaa lima ꞌti ïtï lingeno lidi Gïjï gidi Dïjï dümnä, ngaa ïyï yïnä yüngün, midi gwaꞌti ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Gwere gwanni gwa eny lingeno lüny na ngwïyï yïnä yüny, gwa mbuji miding gwudi gwurꞌtaling, a gwunyi ꞌdïꞌrïyälü komon nggäꞌdï gidi mïꞌrä. ");
INSERT INTO lro_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ndi ari lingeno lüny liru eny gwanni gwuru ꞌdidanu na yïn yüny yiru ïyï gwanni gwuru ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Gwere gwanni gwa eny lingeno lüny na ngwïyï yïnä yüny gwa mätïnälü ꞌdünggüny a nggwa ji ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Anaku ükäjäär nyi gu Papa gwanni gwumidu, a gwani Papa, äny nggwo gwumidu. No, gwanni gweny gilingeno lüny gwa midi ꞌto gwani äny. ");
INSERT INTO lro_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Eny gwuru nggwee gwanni gwüllü kerala. Ngwügüürnä ngwalu ngwïtï män ngwuma ayi, a be gwanni gweny ndi eny nggwee gwa midi gwurꞌtal.” ");
INSERT INTO lro_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ngwujaꞌri ngwee ngwondaja je Yicu kaji ganni gijung ge ndi enggaci ngwüjü ngwämrä ngwalu ngwani Kaprnawum. ");
INSERT INTO lro_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Anni ma ngwooꞌra ngwonyadu ngwudi Yicu ꞌdingini nggu ondaji no aar ari, “Ngwujaꞌri ngwuru ange ngwee ngwojema gu no yärü gwanni ngwadi je ämnï?” ");
INSERT INTO lro_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Anni ma Yicu lenge ndi ari ngwooꞌra ngwüngün ngwo ndi äbïngïnï giyenenanu, ngwuje otacalu ngwuje ci, “Ngwujaꞌri ngwee ngwuma gu obalo? ");
INSERT INTO lro_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ma be ari ngaa lima engga Gïjü gidi Dïjï dümnä gima ꞌdïꞌrï ngwoꞌre ngwaalu ngwanni ngwujung gu gwerre, ngaa la be ärrï ange? ");
INSERT INTO lro_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lïgïꞌrïm lidi Ngwaalu liru lanni lati apa miding, a be lingeno laꞌti ätï gony gere. Ngwujaꞌri ngwanni ngwondaca je ngwuru lïgïꞌrïm aar ru midi. ");
INSERT INTO lro_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Loko gilona ꞌdanggalanu laꞌti ämnä Ngwaalu.” Ndi ari Yicu gwülïngïdï gu ꞌtuꞌtu gwerre ndi ari yärüngä lanni laꞌti ämnäcï na yärü gwadi gwe gwurlanu. ");
INSERT INTO lro_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ngwoꞌre ngwari, “Yiru giyee yanni yïgäbïcïny nga ja be ci dïjï dere daꞌti da ila ꞌdünggüny manari Papa gwäꞌtüdï gwügäbïcä.” ");
INSERT INTO lro_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ꞌTuꞌtu kaji nggoo, ngwooꞌra ngwüngün ngwonyadu oꞌre aar gatani aar ꞌti ba be gwujana. ");
INSERT INTO lro_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","A Yicu otaci ngwoꞌralu ngwüngün ngwo ngwuru ꞌdï na rom (12) ngwuje ci, “Ngaa läꞌtüdï ladi oꞌre ꞌto?” ");
INSERT INTO lro_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","A Jamaan gwani Butruj ci, “La ang gatani nyii be ele ndi yärü gwani Deleny? Nga gwuru gwätï ngwujaꞌri ngwudi midi gwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Änyängä lämnä na nyii lenge ndi ari nga gwuru gwanni Gwujuꞌru gwudi Ngwaalu!” ");
INSERT INTO lro_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","A be Yicu ari, “Äny gwäꞌtüdï gwuta janu liru ꞌdï na romo (12)? A be gweꞌte nggwo ꞌdanggalanu gwuru dijegoꞌrr.” ");
INSERT INTO lro_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Nginde gwäbïngädï ndi Yäwüdä gwanni gwuru gïjï gidi Jamaan gwani Äjïgärïyütï. Nginde gwuru dooꞌra deꞌte ngwooꞌranu ngwoo ngwuru ꞌdï na rom gwanni gwuma ji ngwugwurlanu nginde gwe.) ");
INSERT INTO lro_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","A be aji a Yicu ꞌdïꞌrï ngwele ngwulandalu Jälïl nunnu ngwüꞌtänü ngwaalu ngwani Yäwüdïyä ndi ari gwümïnä Ngwüyäwüd gwadi aar ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A be anni ma Yïꞌrïnyïnä yidi Gäꞌtä yidi Ngwüyäwüd ji gito, ");
INSERT INTO lro_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","a ngwenggen ci nu, “A gwa ꞌdïꞌrï ang gatani ngwaalinga ngwee ang ele Yäwüdïyä nunnu a ngwooꞌra ngwunga engga yiima yanni yati je ärrï. ");
INSERT INTO lro_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Gwaꞌti gwere gwati ape yiiru yuꞌrimi manari gwümïnä a ngwüjï enggada ngwulinginni. Anni ati ang ape yiima giyee, enggaca be ngwüjü gïdïdlä ligoꞌro lunga.” ");
INSERT INTO lro_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ꞌDi ngwenggen ngwüngün ꞌto aar ꞌti ämnä ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yäy gu no a je be Yicu ci, “Gaji gwüny nggona gaꞌti ïndï a be gaji galu giru. ");
INSERT INTO lro_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ngwüjï ngwudi dïdlä ngwaꞌta je ki ngwäy, nje be ke ngwäy nunnu äny gwondaja ndi ari yiꞌral yegen yanni yati aar je ärrï yaꞌti jaw. ");
INSERT INTO lro_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ändär nga nga jücü gïyïꞌrïnyïnä nggwa ꞌti gwallu gwenene ndi ari gaji güny gaꞌtina ïndï.” ");
INSERT INTO lro_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Anni mung ondaji ngwujaꞌri ngwee, ngwube jalu Jälïl. ");
INSERT INTO lro_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Anni ma ngwenggen dïꞌrï aar allu gïyïꞌrïnyïnä, ngwüꞌdïꞌrï gwodan ngwallu ꞌto ngwuꞌti be ꞌtäcä ligoꞌralu lüngün ngwube änälü. ");
INSERT INTO lro_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ngenone gïyïꞌrïnyïnä, a ngweleny ngwudi Ngwüyäwüd ji ndi mïnälü aar gwe otaci ngwüjälü aar ari, “Gur ganna ge nggoo?” ");
INSERT INTO lro_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A gwe ngwüjï badalu ngwujaꞌri ngwonyadu ngwani nginde. A loko ari, “Nginde gwuru dïjï dijaw.” A ngwoko ari, “Bärï, nginde gwati dudiyi ngwüjü.” ");
INSERT INTO lro_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Aaꞌti be dïjï dere ämnä ndi ondajalu nginde gwe ngwüjï ndi ari ngwïtï je yedeny ngweleny ngwudi Ngwüyäwüd. ");
INSERT INTO lro_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Anni ma ngwüjï arra yïꞌrïnyïnä ꞌdi aar übïdï yomonanu, a Yicu allu ngwämrä kobo ngwuji ndi enggaci ngwüjü ngwujaꞌri. ");
INSERT INTO lro_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","A Ngwüyäwüd engga a je le ngwaalu elalu, aar abingi aar ari, “Awa ngwube lenge ndi ondaci ngwüjü gwaꞌti aar äpädï ngwalu yuuli yidi yobo?” ");
INSERT INTO lro_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","A je Yicu ci, “Ngwujaꞌri ngwondaji nje ngwäꞌtüdï ngwüny, ngwïndï ꞌdüngüngün gwanni gwükäjïny. ");
INSERT INTO lro_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Gwere gwanni gwümïnä ndi ape buping gwudi Ngwaalu, gwa lenge ndi ari ngwujaꞌri ngwee ngwüny ngwïndï Ngwaalu gwalla nggwondaja ligor le lüny. ");
INSERT INTO lro_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Gwanni gwati ondaji ngwujaꞌri ngwudi ligor lüngün, gwati ondijaji ndi näjï ligoꞌro lüngün. A be gwanni gwäpïjä ngindeng yiiru yidi näjï gwanni gwükäjä, gwuru gwanni gwuru ꞌdidanu. Yaꞌti gu yere yanni yiru yiꞌduru. ");
INSERT INTO lro_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Müjä gwaꞌta je ätädï yobo? A be gwere gwaꞌti ꞌdanggalanu gwanni gwümätï yobo. Ngaa larra ngaa be ari ngaa liny ꞌrinye?” ");
INSERT INTO lro_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Aar ci Yicung, “Nga gwürlälü kiꞌranu, yärü gwuru gwanni gwümïnä ndi aar ang ꞌrinye?” ");
INSERT INTO lro_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","A je Yicu ci, “Äny gwapu yiima yeꞌte pu, ara je be allijalu ndïr ꞌdar. ");
INSERT INTO lro_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Äny gwadi ari Müjä gwenggaca je ngwujaꞌri ngwudi üꞌrïꞌtänï. Ngwujaꞌri ngwee Müjä ngwäꞌtüdï gwapu je, (ngwujaꞌri ngwudi ngwügüürnä ngwalu ngwuru), no ati aa be üꞌrïdä gïjü komon ganni giru Kwoꞌra täꞌrïl. ");
INSERT INTO lro_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ma be ari ngaa lati üꞌrïdä gïjü komon ganni giru Kwoꞌra täꞌrïl, nunnu aaꞌti ngaa la kiyi yobo yanni yaru ye Müjä, nyi mine kïjänü gwedang ndi ari äny gwuꞌriya dïjü lingina ku komon ganni giru Kwoꞌra täꞌrïl? ");
INSERT INTO lro_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Gäbïcär ngwujaꞌri ngwani obalu ngwüjü ngwe engga gwe gwudi ngwäy, übïdärälü ngwüjü ngwe gay ge ganni gïdünälü.” ");
INSERT INTO lro_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yiꞌral ye giyoo, a ngwüjï ngwudi Üräjälïmïng ngwoko ondaji aar ari, “Gur nggee gäꞌtüdï manni ganni gïmïnäär ndi aar ꞌrinye? ");
INSERT INTO lro_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nggo pa gondaju ngwujaꞌralu ꞌdar kibeny aaꞌti be dïjï dere ädïnä ndi otacalu. Ngweleny ngwege ꞌdidanu ngwuma ämnï ndi ari nginde gwuru gwanni Gwubrutaar yelenya? ");
INSERT INTO lro_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","A be a lïlïngïdï ndi ari manari gwanni Gwubrutaar yelenya gwuma ila, gwere gwaꞌti gwa gu lenge ndi ari gwïndï ne gwe. A be gwülïngïdär ndi ari gwudi neng gwuru.” ");
INSERT INTO lro_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","A je be Yicu ca dula gwujuna ndi enggaci ngwüjü ngwämrä kobo ngwari, “Yäy ngaa lïlïngïdïny ngaa lenge ndi ari äny gwïndï ne gwe! Äny gwaꞌti ïndï ngene giligor lüny, a be gwanni gwükäjïny, nginde gwuru gwanni gwuru ꞌdidanu gwaꞌti aang lïngïdï. ");
INSERT INTO lro_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","A be äny gwülïngïdïny ndi ari äny gwüꞌtüdï ꞌdünggüngün a nginde gwuru gwükäjïny.” ");
INSERT INTO lro_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ngwujaꞌri ngwee, a Ngwüyäwüd ngwoko mïnï ndi aar gu mätädä, aaꞌti be gwere ädïnä ndi määtä ndi ari gaji gwüngün gaꞌtina ïndï. ");
INSERT INTO lro_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","A ngwüjï ngwonyadu ämnï ꞌdünggüngün aar ondaji aar ari, “Ma ji manari gwanni Gwubrutaar yelenya gwuma ila, ii gwa ape yiꞌremna yidi yiima yonyadana kur nggee?” ");
INSERT INTO lro_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","A Ngwübärrïjï ꞌdingini ngwujaꞌri ngwondaja je ngwüjï ngwani Yicu. A be ngwurꞌdal ngwanni ngwuru yiꞌra na Ngwübärrïjï ükäjä ngwangida ngwegen ngwudi gobo nunnu aar määtä Yicung. ");
INSERT INTO lro_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","A je Yicu ci, “A ladi jalu gwooko ꞌdogo nga je be gatani nyi oꞌre nyi oꞌraci ngindeng gwanni gwükäjïny. ");
INSERT INTO lro_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ngaa liny mïnälü ngaa laꞌti liny mbuji ngaa laꞌti la burni ndi ila ngwaalu ngwanni ngwadi nyi gu ji.” ");
INSERT INTO lro_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","A ngweleny ngwudi Ngwüyäwüd otajidalu ndi ari, “Nginde gwaru gwadi ene ꞌdi gwaꞌti gwa ar mbuji? Nginde gwadi ꞌdïꞌrï ngwele giyen yidi Ngwügïrïg yanni giyo yibadu gu ngwüjälü ngwege ngwenggaca Ngwügïrïgo? ");
INSERT INTO lro_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yiru ange yarung ye anni arung, ‘Ngaa liny mïnälü ngaa laꞌti liny mbuji’ na ‘Ngaa laꞌti la burni ndi ila ngwaalu ngwanni ngwadi nyi gu ji’?” ");
INSERT INTO lro_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gomon gidi badi gidi yïꞌrïnyïnä, gomon gati aar geꞌte ngwujayani, a Yicu ꞌdïꞌrï ngwüdünälä ngwabingi dula ngwari, “Gwanni gwïtï ngwäädä aar nyi elaca ngwïyï. ");
INSERT INTO lro_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Gwanni gwa ämnï ꞌdünggüny anaku aru gu gitab ndi ari, gwa gu ngwäy ngwudi yaw yanni yimidu ïrälü.” ");
INSERT INTO lro_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yicu gwondijaja ngwaalu ngwudi Lïgïꞌrïm lanni Lijuꞌru lanni ladi ji ngwüjänü ngwanni ngwa ämnï ꞌdünggüngün. Kaji nggoo, Lïgïꞌrïm laꞌti gu na ïndï ndi ari gaji nggoo, Yicu gwaꞌti gu na näjïnä. ");
INSERT INTO lro_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","A be anni ma gu ngwüjï ngwanni ngwuju ngeno ꞌdingini ngwujaꞌri ngwee, a ngwoko ari nu, “ꞌDidanu gur nggee giru dïjïr.” ");
INSERT INTO lro_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","A ngwoko ari, “Nginde gwuru gwanni Gwubrutaar yelenya.” A be ngwoko utalu aar ari, “Awa a be gwanni Gwubrutaar yelenya ꞌtüdä Jälïl? ");
INSERT INTO lro_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Gitab gaꞌti aru nu, gwanni Gwubrutaar yelenya gwadi ila gïlängïr lidi Däwüd kündär gani Bidilam ganni giju Däwüd gwerre?” ");
INSERT INTO lro_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","No a ngwüjï üꞌrïdïnänü ngwujaꞌri ngwani Yicu. ");
INSERT INTO lro_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","A ngwoko mïnï ndi määtä, aaꞌti be gwere ädïnä ndi allija guy nono. ");
INSERT INTO lro_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Gwodanalu a ngwangida ngwudi gobo ngwanni ngwükäjäär je oꞌraci ngwurꞌdala ngwanni ngwuru ngweleny na Ngwübärrïjï aar je otacalu ndi ari, “Gwuma arra ma aang ꞌti mätï ngaa gwe ila?” ");
INSERT INTO lro_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aar je ondaci ndi ari, “Gwere gwaꞌti nyii änggädï aꞌtur gwondaja nono gur nggee.” ");
INSERT INTO lro_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","A güündä ape Ngwübärrïjï aar je gwäꞌräcänü, “Gwuma je dudiyi ꞌto? ");
INSERT INTO lro_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ngaa länggädï yärüngälü ngwelenyanu ngwuru Ngwübärrïjï gwämnäcä ngindeng? ");
INSERT INTO lro_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bärï gwaꞌti! A be ngwüjï giꞌdu ngwee ꞌdar ngwaꞌti lïngïdï yobo ye yorto ngwaalinga ngwüꞌtäjäär je gu ngwünyü.” ");
INSERT INTO lro_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","A be gur gani Nïkïdïmüj giru deleny ngwelenyanu ngwuru Ngwübärrïjï ganni gelaca Yicung gomon geꞌte gwerre. ");
INSERT INTO lro_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ngwüꞌdïꞌrï ngwutalu ngwuje ci, “Ngwujaꞌri ngwudi yobo yege yidi Ngwaalu yati obalu dïjï de gwerre gwerre daꞌti aar otacalu yiꞌral ye yanni yärrüng je?” ");
INSERT INTO lro_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aar ci, “Nga ꞌto gwuru gwudi Jälïlïngo? Utalu mama nga lenge ndi ari dïjïr daꞌti dïꞌtüdï Jälïl.” ");
INSERT INTO lro_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Aar be ꞌdïꞌrïꞌtï aar badi a dïjï oꞌre ꞌdunu gwüngün. ");
INSERT INTO lro_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","A be Yicu ꞌdïꞌrï ngwele ngwallu Gidotr gidi Ngwümïnïtï. ");
INSERT INTO lro_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Anni ma ngwaalu uꞌri ngwukwodalu ngwoꞌra ngwämrä kobo a ngwüjï ngwonyadu oꞌrada nono, ngwujalu nding je enggaci. ");
INSERT INTO lro_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","A Ngwübärrïjï na ngwoorta ngwudi yobo apana dayu deꞌte laru dïmätäär ndi mïꞌrï ngwäyänü aar ila aar dünäjälä gidiliganu ngwüjï. ");
INSERT INTO lro_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Aar ci Yicung, “Gwani Doorta, daw ndee dïmätïnä ndi mïꞌrï ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Müjä gwondaja ngwujaꞌri kitabanu gidi Yobo gwaru nu, daw danni diru gu no, aar aci yoꞌrr ye ꞌdi ngwayi. A be nga gwaraa gweneno?” ");
INSERT INTO lro_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ngindenga lutalu no, nunnu aar mbojaji ngwujaꞌri nono ngwere ngwanni ngwadi je gäbïcï aar gu määtädä. A be Yicu üllänü ngwulli gomon ge gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Anni ma aar ji ndi oꞌreꞌtaci aar otacalu gwurꞌtal, ngwüꞌdïꞌrädälä ngwuje ci, “Dïjï danni daꞌti ätï yiꞌral nono yere yanni yiki, gäbïcär ngwape goꞌrra gwerre gwerre ngwaw.” ");
INSERT INTO lro_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ngwoꞌre ngwüllänü ngwulli gomon ge gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Anni ma gu ngwüjï ꞌdingini no, aar ꞌtü ngwere ngwere ngwanni ngwupana aar ꞌtü gwerre gwerre ꞌdi aar gatani Yicungalu daw de jücü dïdünädälä. ");
INSERT INTO lro_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","A Yicu ꞌdïꞌrädälä ngwotacalu ngwuci, “Gwani daw ngwüjï ngwuma ene, gwere gwaꞌti gwuma gwe obalo?” ");
INSERT INTO lro_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A daw ari, “Bärï gwere gwaꞌti gwani Doorta.” A be Yicu ci, “A mine äny ꞌto nggwaꞌti gwa gwe obalu. Ïndï be gwenene aaꞌti be ya je ärrï yunga yanni yiki mana.” ");
INSERT INTO lro_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Anni ma Yicu ondaci ngwüjü mana ngwuje ci, “Äny gwuru buri gwudi dïdlä, gwanni gwuny gwujani gwaꞌti gwele gïdïrïmänü, a be gwätï buri gwudi midi.” ");
INSERT INTO lro_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","A Ngwübärrïjï iyanu aar ci, “Nga gwenene gwuruca ligoꞌro lunga. Ngwujaꞌri ngwunga ngwaꞌti ätï ngwäyänü.” ");
INSERT INTO lro_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A je Yicu ci, “Minyi na ondaji ngwujaꞌri ngwudi ligoꞌro lüny, ngwujaꞌri ngwüny ngwätï ngwäyänü äny gwülïngïdï ligoꞌro lüny ndi ari äny gwïndï ne gwe a nggwadi elada ne gwe. A be ngaa laꞌti lïngïdï ndi ari äny gwïndï ne gwe a nggwadi elada ne gwe. ");
INSERT INTO lro_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ngaa lati obalu ngwujaꞌri ngwe ngwüjï liru ngwüjï ngwümnä. A be äny gwaꞌti übïdälü dïjï de ngwujaꞌri ngwere. ");
INSERT INTO lro_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A be manari äny gwuma obalu dïjï de ngwaalu ngwere, yätï ngwäyänü ndi ari äny gwäꞌtüdï gweꞌte pu. Änyängä lïdünü Papa gwe gwanni gwükäjïny. ");
INSERT INTO lro_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yüllïnä kitabanu gidi yobo yalu ndi ari ngwujaꞌri ngwudi ngwüjï rom (2) ngwätï ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Äny gwuru gwondaja ngwujaꞌri giligoꞌro lüny, na Papa gwüny gwanni gwükäjïny gwuru gwanni gwadiny ruci ngwujaꞌri ngwüny.” ");
INSERT INTO lro_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aar be otacalu aar ci, “Papa gwunga gwanna gwe?” A je Yicu gwäꞌräcänü ngwuje ci, “Nga nga laꞌtiny lïngïdï ngaa ꞌti lïngïdï Papang gwüny. Adinari nyii lenge, ngaa ladi lenge Papang gwüny ꞌto.” ");
INSERT INTO lro_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yicu gwondaju ngwujaꞌri ngwee, gaji ganni gijung ge ndi enggaci ngwüjü ngwujaꞌri ngwämrä kobo gito gito ngwaalu ngwanni ngwati aar gu geꞌte ngwonyalu ngwudi gatalu. Aaꞌti dïjï dere alliju guy nono nding määtä, ndi ari gaji güngün gaꞌtina ïndï. ");
INSERT INTO lro_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Oꞌre a je Yicu ondaci ngwari, “Äny gwa je gatani nggwele a ngaa liny mïnï ngaa la ayi giyiꞌralanu yalu yanni yiki, ngwaalu ngwanni ngwunyi gu ele, ngaa laꞌti la burni ndi gu ila.” ");
INSERT INTO lro_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","A ngwujaꞌri ngwee gäbïcï Ngwüyäwüd aar utalu ndi ari, “Gwadi ꞌrinye ligoꞌro lüngüne? Yiru yïgäbïcä ngwube ari, ‘Ngwaalu ngwunyi gu ele, ngaa laꞌti la burni ndi gu ila’?” ");
INSERT INTO lro_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ngwube oꞌre ngwondaji ngwuje ci, “Ngaa liru lidi dïyängälü. Äny gwuru gwudi gerala. Ngaa liru lidi dïdlä ndee. A be äny gwäꞌtüdï gwudi dïdlä ndee. ");
INSERT INTO lro_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Äny gwondaca je ndi ari ngaa la ayi giyiꞌralanu yalu yanni yiki, manari ngaa lima ꞌti ämnä ndi ari äny gwuru gwanni gwaru äny gwuru, ngaa la ayi giyiꞌralanu yalu yanni yiki.” ");
INSERT INTO lro_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Aar otacalu aar ci, “Ngaa gwani yärü?” A je Yicu ci, “Yiru yanni yondaca je ye ꞌdar ꞌtuꞌtu gwerre. ");
INSERT INTO lro_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yätï nje yonyadu yada je ye obalu yigoꞌro yalu. A be gwanni gwükäjïny gwuru ꞌdidanu a yanni yiꞌdingini nje ꞌdünggüngün, yiru yanni yondaci nje ngwüjü ngwudi dïdlä.” ");
INSERT INTO lro_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aar ꞌti be lïngïdï ngwujaꞌri ngwüngün ndi ari nginde gwondijaja ndi Papa gwüngün. ");
INSERT INTO lro_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","No a je Yicu ci, “Ma ji ma ang alliji Gïjü gidi Dïjï dümnä küꞌrälä ma aang ꞌrinye, ngaa la be lenge ndi ari äny gwuru gwanni gwaru äny gwuru a ngaa la lenge ndi ari yere yaꞌti yati nje ärrï ligoꞌro le lüny yanni yati nje ondaji yiru yanni yenggacaar nje Papa. ");
INSERT INTO lro_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nginde gwanni gwükäjïny nggwo gwujiiny gwe, nginde gwaꞌtiny gatanalu jücü, ndi ari yati nje ärrï yomon ꞌdar yanni yati jadanu.” ");
INSERT INTO lro_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Anni ma Yicu ji ndi ondaji ngwujaꞌri ngwee a ngwüjï ngwonyadu ämnï ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ngwuci Ngwüyäwüd ngwanni ngwuma ämnï ꞌdügüngün, “Manari ngaa lima mätïnälü ngwujaꞌri ngwee ngwüny, ngaa la ru ngwooꞌra ngwüny ngwanni ngwuru ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ngaa la lenge ngwujaꞌri ngwanni ngwuru ꞌdidanu na ngwujaꞌri ngwanni ngwuru ꞌdidanu, ngwa je gwäꞌdälü gïyïnäd.” ");
INSERT INTO lro_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Aar ci, “Änyängä liru yïjï yidi Äbräyïm, gomon gere änyängä läꞌtüdï ngwïnäd ngwudi dïjï dere. Awa nga be ari nyii gwäꞌdänälü?” ");
INSERT INTO lro_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","A je Yicu ci, “Nggwa je ondaci ꞌdidanu ndi ari gwanni gwati ärrï yiꞌral yanni yiki gwuru dïnäd didi yiꞌral yanni yiki.” ");
INSERT INTO lro_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Dïnäd dati ꞌti rüdï didi ngwuꞌdun pupud, a be gïjï ru gati ru gidi ngwuꞌdun pupud. ");
INSERT INTO lro_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","No manari Gïjï gima je gäꞌdälü, ngaa la gäꞌdänälü ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Äny gwülïngïdï ndi ari ngaa liru yïjï yidi Äbräyïm a be ngaa gilo liju mama ndi nyi ꞌrinye. Ndi ari ngwujaꞌri ngwüny ngwaꞌti mbuja ngwaalinga giyigoranu nunnu ara je gu üllänü. ");
INSERT INTO lro_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Äny gwondaja ngwujaꞌri ngwe ngwanni ngwänggädï nje ndi Papa ngaa be ärrï yiꞌral yanni yiꞌdingina je ndi papa gwalu. ");
INSERT INTO lro_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Aar ari, “Äbräyïm gwuru papa gwärï.” A je Yicu ci, “Adinari a Äbräyïm ru papa gwalu, ngaa laadi ärrï yiꞌral yidi Äbräyïm. ");
INSERT INTO lro_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","A be ngaa lïmïnä ndiny ꞌrinye äny gwuru gwanni gwondaca je ngwujaꞌri ngwanni ngwuꞌdingini nje Ngwaalu ngwanni ngwuru ꞌdidanu, yiꞌral giyee yaꞌti je Äbräyïm ärrü. ");
INSERT INTO lro_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ngaa lärrü yiꞌral yidi papa gwalu yanni yating je ärrï.” A Ngwüyäwüd pïnï nono aar ari, “Änyängä läꞌtüdï yïjï yidi yïjïn yapaar jalu mbüny, änyängä lätï Papang gweꞌte pu gwuru Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","A je Yicu ci, “Adinari a Ngwaalu ru Papa gwalu, ngaa laadi nyi ämnï, ndi ari äny gwïndï Ngwaalu a gwenene äny nggwo ngene. Äny gwaꞌti ïndï ligoꞌro le lüny, a be nginde ru gwükäjïny. ");
INSERT INTO lro_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ngwujaꞌri ngwüny ngwarra ma aar ꞌti linginna ngwäyänü ꞌdanggalu? Ndi ari ngaa laꞌti burna ndi ꞌdingini ngwujaꞌri ngwüny. ");
INSERT INTO lro_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ngaa liru yïjï yidi papa gwalu gwuru dijegoꞌrr, yiru yanni yïgäbïcä je ngaa gwuji ndi ärrï yiꞌral yidi papa gwalu yanni yati jadanu. Nginde gwuru gwanni gwuꞌrinyidu ꞌtuꞌtu gwerre. Nginde gwaꞌti mätïnälü ngwujaꞌri ngwere ngwanni ngwuru ꞌdidanu. Ndi ari yanni yiru ꞌdidanu yaꞌti ꞌdünggüngün. Gwati üꞌrü yiꞌduru, gwati ondaji ngwujaꞌri ngwudi drü düngün ndi ari nginde gwuru diꞌduru, ngwuru papa gwudi ngwuꞌduru. ");
INSERT INTO lro_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","A be nunnu äny gwati ondaji ngwujaꞌri ngwanni ngwätï ngwäyänü ngaa ꞌti be ämnä ꞌdünggüny. ");
INSERT INTO lro_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yärü gwanni gwadiny enggaci yiꞌral yere yanni yiki yärrï nje? Ma be ari äny gwati ondaji ngwujaꞌri ngwanni ngwätï ngwäyänü ngaa be arra ma aang ꞌdonya ndi ämnï ꞌdünggüny? ");
INSERT INTO lro_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dïjï didi Ngwaalu dati ꞌdingini ngwujaꞌri ngwudi Ngwaalu, a be ngaa läꞌtüdï lidi Ngwaalu, no yiru yata je gäbïcï ngaa ꞌti be ꞌdingina ngwujaꞌri.” ");
INSERT INTO lro_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A be Ngwüyäwüd ci, “Ngwujaꞌri ngwärï ngwaꞌti mene ätï ngwäyänü minyii ari nga gwuru Dijamir a gwätïnä dïꞌrïllä nono?” ");
INSERT INTO lro_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","A je Yicu ci, “Äny gwaꞌti ätïnä dïꞌrïllä nono a be äny gwünäjä Papang gwüny nyii be ärrälü nyidang. ");
INSERT INTO lro_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Äny gwaꞌti mïnä ndi näjï ligoꞌro lüny. A be nggwo gwanni gwatiny mïnïjï näjï na gwuru gwanni gwati pï yelenya. ");
INSERT INTO lro_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ꞌDidanu nggwa je ci gwanni gwa ꞌdingini ngwujaꞌri ngwüny gwaꞌti gwa engga yiꞌrany gwüküꞌrüm aꞌtur.” ");
INSERT INTO lro_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ngwujaꞌri ngwe ngwee, a Ngwüyäwüd ondaji dulala, “Änyängä lima lenge gwenene ndi ari nga gwätïnä dïꞌrïllä nono. Äbräyïm na ngwïjïr ngwudi Ngwaalu ngwuma ayi nga be ari gwanni gwa ang ꞌdengenaci ngwujaꞌri ngwunga gwaꞌti gwa engga yiꞌrany gwüküꞌrüm aꞌtur. ");
INSERT INTO lro_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nga gwupana ndi papa gwärï gwani Äbräyïm? Gwanni gwuma ayi, na ngwïjïr ngwudi Ngwaalu ngwuma ayi a be nga gwucu ligoꞌro lunga yärü?” ");
INSERT INTO lro_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","A je Yicu ci, “Manari äny gwati näjï ligoꞌro lüny, näjï gwüny gwa ꞌtur. A be Papa gwüny gwuru gwanni gwara gwe gwuru Ngwaalu ngwalu, gwuru gwanni gwatiny näjï. ");
INSERT INTO lro_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gwaꞌti aang lïngïdï a be äny gwuru gwülïngïdï. Manari äny gwuma je ci gwatiny lïngïdï, nggwa ru diꞌduru nono ngang je. A be gwülïngïdïny äny gwuꞌdengenaciny ngwujaꞌri ngwüngün. ");
INSERT INTO lro_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Papa gwalu gwani Äbräyïm gwüjädï ngwugeꞌtaji ndi engga gomon güny ngwengga ngwujayanu.” ");
INSERT INTO lro_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","A Ngwüyäwüd ci, “Nga gwaꞌtina obana ngwüdläyü ꞌdï tudini (50) nga be engga Äbräyïmïng awa!” ");
INSERT INTO lro_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","A je Yicu ci, “ꞌDiꞌdidanu nggwa je ondaci ndi ari gwerre gwerre ndi aar linge Äbräyïmïng, äny gwuru gwanni gwaru äny gwuru.” ");
INSERT INTO lro_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","A je ngwujaꞌri ngwee gäbïcï aar uti yoꞌrralu aar mïnï ndi aci, a je be Yicu ändälü ngwüꞌtüdä kobo ngwele. ");
INSERT INTO lro_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Anni ma Yicu ji ndi ele kayalu ngwengga guru gïrïmü ngwäy ꞌtuꞌtu lïngïnïng gu. ");
INSERT INTO lro_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A be ngwooꞌra ngwüngün otacalu aar ci nu, “Doorta, yärü gwanni gwapu yiꞌral yanni yiki, gur nggee gwalla ngwüjï ngwanni ngwülïngïtï ꞌdi ngwülïngïnä gïrïmü ngwäy?” ");
INSERT INTO lro_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","A je be Yicu ci nu, “Nginde gwäꞌtüdï na ngwüjï ngwäꞌtüdï ngwanni ngwülïngïtï ngwuki, a be gïlïngïnä gu no nunnu a gu yiiru yidi Ngwaalu inggidini ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Anni jina lingen, yädï gu ndi ar äpïjï Ngwaalinga yiiru ngwanni ngwükäjïny. Dilung ndo dïndï daꞌti da de dïjï dere burni ndi ape yiiru. ");
INSERT INTO lro_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Anni jiny gïdïdlä, äny gwuru buri gwudi dïdlä.” ");
INSERT INTO lro_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Anni mung gu ari nu, ngwugwonyalu gïdïyängälü, ngwurꞌtol gilu yonyo ye ngwape ngwumaji guru ngwäy. ");
INSERT INTO lro_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ngwube ci nu, “Ïndï ang una ngwäyänü kïbüng gidi Jalum.” (Ngwujaꞌri ngwee gwani gwükäjäär Yïbrïyängä). No a gur ele ngwuni ngwäyänü no ngwoꞌra ꞌdunu gombajidalu. ");
INSERT INTO lro_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ngwüjï ngwanni ngwujacidaar le a lanni gwülïngïdär gwerre gwati geraci ngwüjü guy aar utalu, “Gur nggee gäꞌtüdï mene geꞌte geꞌte ganni gati jalu ngwugeraci ngwüjü guye?” ");
INSERT INTO lro_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","A loko ari nginde gwuru. A loko ari, “Bärï, nginde gwäꞌtüdï gwoꞌranning ꞌdogo.” A je be gur ci nu, “Äny gwuru.” ");
INSERT INTO lro_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Aar be otacalu aar ci, “A mine a gwuma uꞌri ngwäy awa?” ");
INSERT INTO lro_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ngwuje be ci nu, “Gur gicaar Yicu gïrꞌtülïdï gilu aar nyi maji ngwäy. Aar nyi ci ïndï kïbüng gidi Jalum ang uni ngwäyänü. No nyi ele nyi una ngwäyänü äny gwuma be uꞌri ngwäy.” ");
INSERT INTO lro_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Aar be ci nu, “Gur ganna ge nggee?” Ngwuje ci, “Ndä be.” ");
INSERT INTO lro_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aar ape guru nggoo gïrïmü ngwäy gwerre aar ge ele Ngwübärrïjï. ");
INSERT INTO lro_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Gomon ganni gïrꞌtülïdï ge Yicu gilu ngwuꞌriyi guru ngwäy, giru ganni giru Kwoꞌra täꞌrïl. ");
INSERT INTO lro_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yäy gu no a Ngwübärrïjï otacalu ꞌto ndi ari gwuꞌru ngwäy awa. A je gur ci nu, “Gwumajiny gilu ngwäy, anni minyi uni ngwäyänü nyi uꞌri ngwäy.” ");
INSERT INTO lro_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","A Ngwübärrïjï ngwoko ari, “Gur nggee gaꞌti ïndï Ngwaalu ndi ari gaꞌti mätï yobo yidi gomon Kwoꞌra täꞌrïl.” A be loko ari nu, “A mine awa a be dïjï danni diki ärrï yiꞌremna yidi yiima nono giyee?” No, aar üꞌrïdïnänü gwani ngwujaꞌri ngwee. ");
INSERT INTO lro_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Gwodanalu aar gwurlada guru nono nggoo gïrïmü ngwäy gwerre mana aar ci nu, “Nga gwaraa gwani nginde? Ndi ari ngwäy ngwunga ngwuru ngwanni ngwuꞌriyaar je nono.” A je gur ci nu, “Nginde gwuru dïjïr.” ");
INSERT INTO lro_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Aaꞌtina Ngwüyäwüd ämnäcä ndi ari nginde gwürïmü ngwäy gwerre gwuma be uꞌri nono ꞌdi aar ükäjïdï ngwüjï ngwüngün. ");
INSERT INTO lro_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Aar je otacalu, “Gïjï galu giru nggee? Giru nggee ganni gara ge gïlïngïnä gïrïmü ngwäy? Gima mine uꞌri ngwäy awa gweneno?” ");
INSERT INTO lro_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A ngwüjï ngwüngün ari, “Änyängä lïlïngïdï ndi ari gïjï gärï giru, na ndi ari nginde gïlïngïnä gïrïmü ngwäy. ");
INSERT INTO lro_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","A be awa ndi ari gima uꞌri ngwäy, na ndi ari yärü gwuru gwanni gwuꞌriya ngwäy, yaꞌti je lïngïdï. Otacaralu, nginde gwupa be gwondaji ligoꞌro le lüngün.” ");
INSERT INTO lro_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ngwüjï ngwüngün ngwaru gu no ndi ari ngwïtï je yedeny ngweleny ngwudi Ngwüyäwüd. Ndi ari ngweleny ngwudi Ngwüyäwüd ngwugeꞌta ndi ari ma aar mbuji dïjü dere danni dadi ondajalu ndi ari Yicu gwuru gwanni Gwubrutaar yelenya, da aar linynyi ngwämrä ngwegen. ");
INSERT INTO lro_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yiru giyee yanni yïgäbïcä ngwüjï ngwüngün aar be ari, “Otacaralu. Nginde gwupa be.” ");
INSERT INTO lro_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Oꞌre aar urnida guru nggoo gïrïmü ngwäy gwerre aar ci nu, “Näjä Ngwaalinga. Änyängä lïlïngïdï ndi ari gur nggee giru dïjï diki.” ");
INSERT INTO lro_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ngwuje ci nu, “Mung ke ngwuꞌti ki, yaꞌti nje lïngïdï. Yiꞌral yeꞌte pu yïlïngïdï nje. Äny gwuju gwürïmü ngwäy a be gweneno äny gwombajidalu!” ");
INSERT INTO lro_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aar be otacalu mana aar ci nu, “Yiru ange yanni yärrïjärä je? Gwuꞌriyanga ngwäy awa?” ");
INSERT INTO lro_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ngwuje be gwäꞌräcänü ngwuje ci nu, “Nggwondaca je ngaa ꞌti ämnä ndi ꞌdingini, a mine arra ma aang mïnï ndi ꞌdingini mana? Ngaa lïmïnä ꞌto ndi ru ngwooꞌra ngwüngüne?” ");
INSERT INTO lro_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Aar määtä aar lo aar ci, “Nga gwuru gwanni gwuru dooꞌra düngün! Änyängä liru ngwooꞌra ngwudi Müjä! ");
INSERT INTO lro_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nyii lïlïngïdï ndi ari Müjä gwondaca Ngwaalu, a be gur nggee, gaꞌti nyii ge lïlïngïdï ngwaalinga ndi ari nginde gwïndï ne.” ");
INSERT INTO lro_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","A je gur ci nu, “Ngwujaꞌri ngwuru ange ngwuru gu no gwenene! Giminy mine uꞌriyi ngwäy ngaa be ari gaꞌta ge lïngïdï ngwaalinga ngwïndïng gu awa. ");
INSERT INTO lro_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","A lïlïngïdï ndi ari Ngwaalu ngwati ꞌti ꞌdengenaca ngwüjü ngwanni ngwuki, ngwati ꞌdengenaci ngwüjü ngwanni gwati denya Ngwaalinga aar ape drü düngün. ");
INSERT INTO lro_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dïjï dere daꞌti aꞌtur ꞌdinginar de ndi ari duꞌriya dïjü nono dïlïngïnä dïrïmü ngwäy. ");
INSERT INTO lro_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Adinari gur nggee gaꞌti ïndï Ngwaalu, gaꞌti gaadi ärrï yiꞌral yere.” ");
INSERT INTO lro_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","A je yiꞌral giyee gäbïcï aar ci nu, “Nga gwülïngïnä gwuki, a be ädïnï ndi ari a gwunje enggace?” Aar määtä aar linynya aar ꞌtüyä poor. ");
INSERT INTO lro_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","A Yicu ꞌdingini ndi ari gima aar linynyi gima aar ꞌtüyï poor. Anni mung mbuji ngwuci nu, “Nga gwämnä Kïjï gidi Dïjï dümnä?” ");
INSERT INTO lro_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","A be gur ci nu, “Yärü gwani doorta, enggaciny nunnu nyi gwe ämnï.” ");
INSERT INTO lro_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","A be Yicu ci nu, “Gwanni gwänggädängä gweneno, ꞌdidanu gwuru nggwee gwondaja gwe.” ");
INSERT INTO lro_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ngwube ci nu, “Äny gwämnä gwani Deleny.” Ngwukwucalu yirku ye. ");
INSERT INTO lro_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","A be Yicu ari nu, “Äny gwïndädï ndi ape yelenya gïdïdlä ndee nunnu gwanni gwürïmü ngwäy ngwombajidalu, a lanni lombajidalu aar rïmï ngwäy.” ");
INSERT INTO lro_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","A Ngwübärrïjï ngwoko ngwanni ngwujaar ngwe aar ꞌdingini ngwari ngwujaꞌri ngwee, aar otacalu aar ci nu, “Ngwuru ange! Änyängä lïrïmü ngwäy ꞌto?” ");
INSERT INTO lro_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","A je be Yicu ci nu, “Adinari ngaa rïmï ngwäy, a laꞌti laadi ätï keng nono gwere. A be anni arangaa gweneno ngaa lombajidalu, ke gwalu nggwo na gwujalu.” ");
INSERT INTO lro_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Oꞌre a Yicu ari, “Nggwa je ondaci ꞌdidanu, dïjï danni dati ꞌti ändï gïlängïr lidi dilagany didi giꞌdu gidi ngwangal, ngwube ꞌdïꞌrälä gidilganyala, diru duꞌram dïndädï ndi obe. ");
INSERT INTO lro_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","A be dïjï danni dati änï gïlängïr lidi dilagany didi giꞌdu gidi ngwangal, diru danni diru dooꞌra didi ngwangal. ");
INSERT INTO lro_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Dati dangida gïlängïr ïgïtäcälü a ngwangal ꞌdingini yal yüngün. A ngwuje urnidi ngwürïny ngwe ngwegen ngwuje ïgïnïjä ngwuje ꞌtüyä poor. ");
INSERT INTO lro_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mung je ꞌtüyä ngwüngün ꞌdar, ngwuje ïgïnïjï a ngwangal gwujani, ndi ari nunnu ngwülïngïdï yal yüngün. ");
INSERT INTO lro_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A be ngwaꞌti ngwa gwujani dïrnü daꞌti aar lïngïdï. ꞌDidanu ngwati abri yal yidi ngwïrnü ndi ari yaꞌti aar je lïlïngïdï.” ");
INSERT INTO lro_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yicu gwümïꞌrïcä ngwüjü ngwuje ondaci ngwujaꞌri ngwee, aaꞌti be ngwüjï lïngïdï ndi ari Yicu gwondijaja kang. ");
INSERT INTO lro_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yäy gu no a je be Yicu ci mana nu, “Nggwa je ondaci ꞌdidanu ndi ari äny gwuru längïr lidi ngwangal. ");
INSERT INTO lro_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ꞌDar lanni limadinana gwerre ꞌdünggüny liru ngwuꞌram aar elada ndi obe a je ꞌti be ngwangal ꞌdengenaca. ");
INSERT INTO lro_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Äny gwuru längïr, dïjï danni dadi änï äny gwe, da gïlängïdïnï. A da änï gïdrü da ꞌtüdä poor da mbuji daama. ");
INSERT INTO lro_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Duꞌram dati elada ꞌdogo, ndi eny yuꞌrimi, ngwuꞌrinyidi, ngwugerajalu, a be äny gwïndï nunnu aar mbuji miding na aar mbuji gwanni gwujayana.” ");
INSERT INTO lro_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","A Yicu ari, “Äny gwuru Dooꞌra danni Dijaw, a dooꞌra danni dijaw dati dudiyi ligoꞌro lüngün gwani ngwangal ngwüngün. ");
INSERT INTO lro_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Gwanni gwati iye a ngwangal ngwüngün ngwäꞌtüdï, gwäꞌtüdï nono dooꞌra didi ngwangal no mung engga dïmüdä ndi ila ngwugatani ngwangala mbüny ngwabri a dïmüd obe ngwangal ngwe ngwuje bädïyï kiꞌdu. ");
INSERT INTO lro_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Gwanni gwati iye gwati abri ngwugatani ngwangala ndi ari nginde gwiya ꞌdogo, gwaꞌti gïꞌtïjä ngwangala ligor.” ");
INSERT INTO lro_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","A Yicu ari, “A be äny gwuru dooꞌra danni dijaw, nyi lenge ngwangala ngwüny, aar nyi ngwangal ngwüny lenge. ");
INSERT INTO lro_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Anaku lïngïdäär nyi gu Papa na nyi lenge Papang, äny gwadi dudiyi ligoꞌro lüny lani üꞌrä ngwangalalu ngwüny. ");
INSERT INTO lro_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Äny nggwo ꞌto gwätï ngwangala ngwuꞌter ngwanni ngwaꞌti gidilaganyanu ndee ngwadi nje gu apada ꞌto. Nunnu ꞌto aar ꞌdingini yal yüny a nunnu aar ji kiꞌdonga geꞌte pu a dooꞌra ru deꞌte pu. ");
INSERT INTO lro_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yanni yati gäbïcï Papa gwüny aar nyi be ämnï, yiru ndi ari äny gwududiya ligoꞌralu lüny nunnu nyi gwäꞌrï mana. ");
INSERT INTO lro_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Gwere gwaꞌti gwuny apada ligoꞌro lüny a be lidudiyiny ligor le lüny, äny gwätï yiima ndi nyi dudiyi a nyi ätï yiima ndi nyi gwäꞌräjï. Ngwujaꞌri ngwee ngwape nje ndi Papa gwüny.” ");
INSERT INTO lro_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","A ngwujaꞌri ngwee gäbïcï Ngwüyäwüd oꞌre aar üꞌrïdïnänü mana. ");
INSERT INTO lro_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","A lonyadu ari nu, “Nginde gwätïnä dïꞌrïllä nono dati gäbïcï ngwondijajalu mbüny. Gwadi aang geraci ngwänï gwedang?” ");
INSERT INTO lro_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","A be loko ari nu, “Ngwujaꞌri ngwee ngwäꞌtüdï ngwudi dïjï dätïnä dïꞌrïllä nono. Dïjï danni dätïnä dïꞌrïllä nono dätï yiima ndi uꞌriyi dïjü nono danni dïrïmü ngwäye?” ");
INSERT INTO lro_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","A gaji ila gidi Yïꞌrïnyïnä yidi Gaꞌru gobo Üräjälïm. Digo de diru ");
INSERT INTO lro_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","a Yicu ji kobanu, ngwuji ndi ele kurdanu gidi Jiliman. ");
INSERT INTO lro_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","A Ngwüyäwüd oꞌrada nono aar ci nu, “A gwadi nje ji ndi gäbïcï nyii ꞌti lïngïdï yiꞌral yorto ye ngwaalinga ꞌdi a jadu ru? Manari nga gwuru gwanni Gwubrutaar yelenya, ondaci njalu kïrtün.” ");
INSERT INTO lro_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","A je be Yicu gwäꞌräcänü ngwuje ci, “Nggwuca je gu ngaa ꞌti be ämnä. Yiima yanni yati nje ärrï ngwürïny ngwe ngwudi Papa gwüny, ya ondaji gwani äny. ");
INSERT INTO lro_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","A be ngaa laꞌti ämnä, ndi ari ngaa läꞌtüdï ngwangal ngwüny. ");
INSERT INTO lro_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ngwangal ngwüny ngwati ꞌdingini yal yüny. Nje lenge, aar nyi gwujani. ");
INSERT INTO lro_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nje ätädä miding gwudi gwurꞌtaling, a ngwaꞌti ngwa bali aꞌtur. A gwere gwaꞌti ngwa aar nje apada kuyanu güny. ");
INSERT INTO lro_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Papa gwüny gwanni gwätädï nje, gwupana ꞌdar, gwaꞌti gwere gwanni ngwung je apada Papang gwüny kuyanu güngün. ");
INSERT INTO lro_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Änyängä Papa gwe liru leꞌte pu.” ");
INSERT INTO lro_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Oꞌre a Ngwüyäwüd uti yoꞌrralu gwadi aar aci. ");
INSERT INTO lro_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","A je be Yicu ci nu, “Nggwenggaca je yiima yonyadu yijaw yidi Papa gwüny yïndï ne yeꞌte yeꞌte yanni yadiny gu acijaji?” ");
INSERT INTO lro_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","A be Ngwüyäwüd ci, “Nyängä läꞌtüdï lading acijaji giyiima yere giyee, a be nunnu nga gwaru ngwulem ndi ari nga gwuru dïjï dümnä nga be ci ligoꞌro lunga nga gwuru Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","A je Yicu gwäꞌräcänü ngwuje ci nu, “Yaꞌti üllïnä kitabanu galu gidi yobo ndi ari, ‘Nggwuma je ci ngaa liru ngwaalo’? ");
INSERT INTO lro_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ma be ari licaar je ‘ngwaalu’ lanni lätädäär je ngwujaꞌri ngwudi Ngwaalu a no gitab gaꞌti ga kïnï. ");
INSERT INTO lro_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","A mene gwanni gwäbrü Ngwaalu ngwugeꞌtaji ꞌter ngwuru gwüngün nunnu ngwükäjä gïdïdlä gwadi ar be ci yärü? Ngaa larra nyi be üpäcï ngwujaꞌri ndi ari äny gwaru ngwulem anni ariny nu, ‘Äny gwuru Gïjï gidi Ngwaalu.’ ");
INSERT INTO lro_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Aaꞌti ngaa liny ämnäcï manari nggwaꞌti ärrä yiima yanni yati je Papa gwüny ärrï. ");
INSERT INTO lro_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","A be manari yati nje ärrï, miny ꞌti ämnäcä, ämnär giyiima, nunnu ngaa lenge ngaa bebere ndi ari Papa nggwo ꞌdünggüny, nyi ji ndi Papa.” ");
INSERT INTO lro_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Oꞌre aar ru gwadi aar määtä ngwuje be gwanna ngwele. ");
INSERT INTO lro_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","A Yicu oꞌre ngwüꞌrü yaanu yidi dibirta didi Ordoning ngwudambu dambal ngwaalu ngwanni ngwünyïnyä gu Yuwana ngwüjü giyomon yanni yima ele gwerre. Nggu ji ngenone ");
INSERT INTO lro_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ati gu ngwüjï ïlïjä ngwonyadu. Aar ari, “Yuwana gwaꞌti apa yiima yere, a be ngwujaꞌri ngwanni ngwondajing je kur nggee, ngwätï ngwäyänü.” ");
INSERT INTO lro_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ngwaalu ngwoo, a ngwüjï ngwonyadu ämnï ndi Yicu. ");
INSERT INTO lro_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","A be gur gani Liyajir ümï gati ji ngwaalu ngwani Bidaniya ꞌdunu gwudi Märïyämïngä gwenggen gwe gwani Marja. ");
INSERT INTO lro_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Märïyäm nggwee gwuru gwenggen gwudi Liyajir nggwo gwundru gwümä. Gwuru gweꞌte gwanni gwübäläjä Yicung yila nono giꞌreꞌreny ngwüꞌdämïꞌrï yora nono yüngün ngwäꞌrü ngwe ngwüngün. ");
INSERT INTO lro_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","No a yera yengga rom giyoo ükäjïdï ndi Yicu aar ci, “Gwani Deleny, gwanni gwati ang ämnï nggwo gwümä.” ");
INSERT INTO lro_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Anni ma Yicu ꞌdingini ngwari, “Dümdï ndee däꞌtüdï didi yiꞌrany. Bärï, diru didi näjï Ngwaalinga a nunnu a de Gïjï gidi Ngwaalu näjïnï.” ");
INSERT INTO lro_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yicu gwati ämnï Marjang na Märïyäm na gwenggen gwegen gwani Liyajir. ");
INSERT INTO lro_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","A be anni mung ꞌdingini ndi ari Liyajir nggwo gwümä, ngwujalu ꞌdi ngwape yomon rom (2) ngwube ele. ");
INSERT INTO lro_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ngwube ꞌdïꞌrï ngwuci ngwoꞌra ngwüngün, “ꞌDïꞌrär aar oꞌre Yäwüdïyä.” ");
INSERT INTO lro_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","A be ngwooꞌra ngwüngün ci, “Gwani Doorta, yomonau giyee yaꞌtina olanu, ngwüjï ngwaru ngwadi ang aca yoꞌrr ye nga be ari ang oꞌre ngenone mana?” ");
INSERT INTO lro_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ngwuje be gwäꞌräcänü ngwuje ci, “Gaji gäꞌtüdï ꞌdï na rom (12) gilingen leꞌte po? Gwanni gwati ele lingen le ngwati ꞌti übïdälü ndi ari gwati ombajidalu ndi ari gwati lingen lidi dïdlä oꞌrracalu. ");
INSERT INTO lro_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yiru gu ndi ari gwati obalu gwanni gwati ele dilu de ndi ari gwaꞌti ätï buri.” ");
INSERT INTO lro_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Anni mung gu ari ngwujaꞌri ngwee, ngwoꞌre ngwuje ci, “Dimaad dege dani Liyajir dima ndri. Dadi nyi ele nyi ꞌritiya.” ");
INSERT INTO lro_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","A ngwooꞌra ngwüngün ci nu, “Gwani Doorta, manari gwundru, gwa ꞌdïꞌrälü gwuꞌru nono.” ");
INSERT INTO lro_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yicu gwondijaja giyiꞌrany yidi Liyajir a be ngwooꞌra ji ndi ari gwondijaja ndi ari gwundru aꞌtur. ");
INSERT INTO lro_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","A je Yicu ondacalu kibeny ngwuje ci, “Liyajir gwuma ayi. ");
INSERT INTO lro_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Äny gwujayanu gwani nga nga ndi ari äny gwaꞌti ju ngenone nunnu ngaa ämnï. A be ꞌdïꞌrär aar elaci ngenone.” ");
INSERT INTO lro_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","A be Tumaj gwanni gwati aar ci Dänggïl ngwuci ngwoꞌra ngwudi Yicu, “ꞌDïꞌrär aar le ele aar le ayi gwüpäng.” ");
INSERT INTO lro_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Anni ma Yicu obani kündär gani Bidaniya, ngwumbuji ndi ari Liyajir gwuma aar gatu gwätï yomon kwoꞌrongo gidimomanu. ");
INSERT INTO lro_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kündär gani Bidaniya gola bränü rom Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","A ngwüjï ngwonyadu ilada ndi ombaji Marjanga je Märïyäm gwe aar je orꞌtemaji anaku ma gu gwenggen gwegen dudi. ");
INSERT INTO lro_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Anni ma Marja ꞌdingini ndi ari Yicu nggwo gwïndï, ngwüꞌtü ngwugwomanu, a be Märïyäm jalu ꞌdunu. ");
INSERT INTO lro_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","A Marja ci Yicung, “Gwani Deleny, adinari nga ji ngene, gwänggärï gwaꞌti gwadi dudi.” ");
INSERT INTO lro_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","A be äny gwämnä ndi ari Ngwaalu ngwati ang ꞌdengenaci ngwujaꞌri ꞌdar ngwanni ngwata je bupi. ");
INSERT INTO lro_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","A Yicu ci, “Gwanggalu gwa ꞌdïꞌrälü gwumidu.” ");
INSERT INTO lro_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","A Marja ari, “Äny gwülïngïdï ndi ari gwa ji gwa ꞌdïꞌrä komon gidi ꞌdïꞌrï giyiꞌranyanu gidi mïꞌrä.” ");
INSERT INTO lro_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","A Yicu ci, “Äny gwuru gwanni gwuru ꞌdïꞌrï, gwanni gwadi ämnï ꞌdünggüny mung ayi gwa midi. ");
INSERT INTO lro_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Gwanni nggwo gwumidu mung ämnï ꞌdünggüny gwaꞌta be gwa ayi mana aꞌtur, nga gwämnä ngwujaꞌri ngwee?” ");
INSERT INTO lro_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ngwuci, “Yäy gwani Deleny, äny gwämnä ngwujaꞌri ngwee ndi ari nga gwuru gwanni Gwubrutaar yelenya gwuru Gïjï gidi Ngwaalu ganni gadi ila gïdïdlä.” ");
INSERT INTO lro_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Anni ma Marja ari no, ngwüꞌdïꞌrï ngwele ngwurnidada gwenggen gwani Märïyäm gay geꞌte ngwuci, “Doorta ndo ngene dïmïnängä.” ");
INSERT INTO lro_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Anni ma gu Märïyäm ꞌdingini no, ngwüdïꞌrï ngwele ndi Yicu. ");
INSERT INTO lro_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yicu gaji nggoo gwaꞌti gu na obana ngwuꞌdunanu gwuju na ngwaalu ngwanni ngwumbuja gu Marja. ");
INSERT INTO lro_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Anni ma ngwüjï engga ndi ari Märïyäm gwuma ꞌtü püd, aar ji ndi geꞌtaji gwadi ele gidimomo didi gwenggen ndi ari ngenone, aar gwujani. ");
INSERT INTO lro_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Anni ma Märïyäm obani ngenone ngwaalu ngwanni ngwuju gu Yicu, ngwengga ngwadacalu yirku ye ngwuci, “Gwani Deleny, adinari nga ji ngene, gwänggärï gwaꞌti gwadi dudi!” ");
INSERT INTO lro_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Anni ma Yicu enggada nginding gwaru, na Ngwüyäwüd ngwanni ngwïndädï ndi ombaji aar ari ꞌto, a lïgïꞌrïm ape Yicung giligor gwulleny. ");
INSERT INTO lro_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ngwuje otacalu ngwuje ci, “Gwuma aang gatu ne gwe?” Aar ci, “Gwani Deleny, ila ang engga ngwaalinga.” ");
INSERT INTO lro_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","A Yicu ari. ");
INSERT INTO lro_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","A Ngwüyäwüd ondaji aar ari, “Ombajar kuni anaku ämnïng gu!” ");
INSERT INTO lro_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","A be ngwoko ari, “Nginde gwuꞌriya guru nono gïrïmü ngwäy, gwaꞌti gwadi ümnïcï Liyajiring ndi aye?” ");
INSERT INTO lro_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Oꞌre a lïgïꞌrïm ape Yicung giligor gwulleny, ngwele gidimomalu, ngwumbuji dimomo dïmïllïdïnä dïꞌrïmün de kïy. ");
INSERT INTO lro_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ngwuje ci, “Äbrär dïꞌrïmünä.” A be gwenggen gwudi gur nggoo gayu gwani Marja ci, “Gwani Deleny, nginde gwuma ätï gwene yomon kwoꞌrongo gidimomanu gwa be ꞌdigiꞌri.” ");
INSERT INTO lro_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","A Yicu ci, “Äny gwaꞌti ang ca ndi ari manari nga gwämnä, nga gwengga yiima yidi Ngwaalo?” ");
INSERT INTO lro_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aar äbräjï dïꞌrïmünälü, a Yicu ꞌdïꞌrïyï ngwäy ngwombajidi kerala ngwari, “Papa nggwa ang ci yäy ꞌtu ndi ari nga gwuꞌdengenaciny. ");
INSERT INTO lro_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Äny gwülïngïdï gu ndi ari yomon ꞌdar nga gwatiny ꞌdengenaci. A be äny gwotacangalu gwani ngwüjï ngwee ngwüdünädälä ngene nunnu aar ämnï ndi ari nga gwükäjïny.” ");
INSERT INTO lro_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Anni mung gu ari no, ngwube urindi gwulleny ngwari, “Liyajir, ꞌtüdä!” ");
INSERT INTO lro_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","A gur nggoo gayu ꞌtüdä ganni gigekana ngwuyalu ngwugekani yoralu gïpänä dired nono diru lari ngwüpänï direda ngwäyänü. A Yicu ci ngwüjü, “Gwäꞌdädärälü ngaa gatalu ngwele.” ");
INSERT INTO lro_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","No a Ngwüyäwüd ngwonyadu ngwanni ngwïndädï ndi ombaji Märïyämïng anni ma aar engga yiꞌral yanni yima je Yicu ärrï, aar ämnï ndi Yicu. ");
INSERT INTO lro_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","A be ngwoko ele aar ondaci Ngwübärrïjï yiꞌral ye yanni yärrï je Yicu. ");
INSERT INTO lro_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","A be ngwurꞌdal ngwanni ngwuru yiꞌra na Ngwübärrïjï oꞌradalu ngwämrä aar otajidalu. Aar ari, “Yiru ange yanni yima aar je ärrï? Gur nggee nggo gapu yiꞌremna yidi yiima yonyadu. ");
INSERT INTO lro_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Manari aar gu ombaci no, ga gu ngwüjü ngwonyadu ämnädä a ngwüjï ngwila ngwudi Rumang ngwunje apada gobo gege na ngwüjï ken gege.” ");
INSERT INTO lro_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","A gur geꞌte ꞌdenggegenanu gani Giyaba giru dirꞌdal danni diru giꞌra dïdläyü ndoo ngwondaji ngwari, “Ngaa laꞌti lïngïdï yiꞌral yorto ye ngwaalinga! ");
INSERT INTO lro_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ngaa laꞌti lïngïdï ndi ari yijayana ꞌdanggalu ndi dïjï ayi deꞌte pu ngwüꞌrïdä ngwüjälü ndi ari a ngwüjï ayi ꞌdar ken.” ");
INSERT INTO lro_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nginde gwaꞌti ondaja ngwujaꞌri ngwe giligor lüngün, anni rung dirꞌdal danni giꞌra dïdläyü ndoo, gwondaja yïjïrä ndi ari Yicu gwadi ayi gwani üꞌrïdä Ngwüyäwüdälü ken. ");
INSERT INTO lro_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ngwayi ꞌto gwani üꞌrïdä ngwüjälü ngwudi Ngwaalu ngwanni ngwuju ngwubadalu giyen yiꞌter ngwuje gwäꞌräjïdï kiꞌdu geꞌte pu aar ru ngweꞌte pu. ");
INSERT INTO lro_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","No, ꞌtuꞌtu kaji nggoo aar ïnïjï nunnu aar ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","No, ati ꞌti ba be Yicu elellalu no nunnu a Ngwüyäwüd engga, ngwüꞌdïꞌrï ngwele kündär gani Abrayim giju gito gito ngwaalu ngwuru yiluꞌri aar gu ji ngenone ngwooꞌra ngwe ngwüngün. ");
INSERT INTO lro_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Anni ma gaji ji gito gidi dïmürä didi Yïꞌrïnyïnä yidi Dambdani yidi Ngwüyäwüd, a ngwüjï ngwonyadu ꞌdïꞌrïꞌtä ngwaalu ngwegen aar ilada ndi gäꞌrïnï Üräjälïm gomon gaꞌtina ïndï gidi Yïꞌrïnyïnä. ");
INSERT INTO lro_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Aar ji ndi mïnï Yicung aar oꞌrajidalu ngwämrä kobo aar gwe otajidala aar ari, “Ngaa laraa? Gwäꞌtüdï gwadi ilada gïyïꞌrïnyïnä gwene aꞌture?” ");
INSERT INTO lro_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","A be ngwurꞌdal ngwanni ngwuru yiꞌra na Ngwübärrïjï ondaci ngwüjü ndi ari manari dïjï dere dima lenge Yicu gwe ngwaalinga, aar ila aar je ondaci aar määtä aar gwe ji guy ge. ");
INSERT INTO lro_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Anni ma yomon diwayinalu nyärläl (6) yidi Yïꞌrïnyïnä yidi Dambdani, a Yicu ila ngwaalu ngwani Bidaniya, ngwati gu Liyajir ji gwanni gwüꞌdïꞌrïyüng giyiꞌranyanu. ");
INSERT INTO lro_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ngenone aar gïꞌtïjï Yicung enying gwudi yïrnü. A je Marja ji ndi äpïjï yiiru a be Liyajiringa ji ndi ndraci dïmbürälü ngwurel ngwe Yicunga le. ");
INSERT INTO lro_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","A Märïyäm apa yila yiru giꞌreꞌreny yüꞌrü gijajanu yonyadu ngwiliny yicaar je närdïn ngwuje bäläjï Yicung yora nono ngwuje be bruti nono ngwäꞌrü ngwe ngwüngün. A yila ape ngwuꞌdunanu ꞌtur. ");
INSERT INTO lro_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","A be dooꞌra düngün dani Yäwüdä Äjïgärïyütï gwanni gwuma aji nggwe gwurlanu ari, ");
INSERT INTO lro_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ange gwuru aaꞌti be yila giyee ꞌdar ïllïnä, aar ape ngwilinya aar ngwe gataji ngwuwaya düwä? Yonyadu guꞌru gidi yiiru dïdläyü.” ");
INSERT INTO lro_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nginde gwaꞌti gu aru no nunnu gwati ngwuwayi ïnä, nggu be ari no ndi ari gwuru duꞌram. Gwuru gwämätïyäär dürädä didi ngwüꞌrïny ating je be obeda ngwoko giligoꞌro lüngün. ");
INSERT INTO lro_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","A be Yicu ari, “Gäbïcär, nginde gwügïꞌtïnä yilalu giyee nunnu aar nje bäläjï nono gomon gidi gatidi gwüny. ");
INSERT INTO lro_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ngwuwayi ngwa le ji yomon ꞌdar, a be a laꞌti la ji yomon ꞌdar.” ");
INSERT INTO lro_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Gaji nggoo Ngwüyäwüd ngwonyadu lengeda Yicu ngwe ngwaalinga aar ila. Aar ꞌti ïndï ꞌdogo gwani ngindeng, aar be ila ꞌto ndi ombaji Liyajiring gwanni gwuma aar ꞌdïꞌrïyälü giyiꞌranyanu. ");
INSERT INTO lro_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","No, a ngwurꞌdal ngwanni ngwuru yiꞌra gegeꞌte yiꞌral nunnu aar ꞌrinye Liyajiring ꞌto, ");
INSERT INTO lro_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ndi ari yiꞌral ye giyee yüngün yima gäbïcï Ngwüyäwüd ngwonyadu aar gwuji Yicu aar gwe ämnï. ");
INSERT INTO lro_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Bïgänü nggwo, a ngwüjï ngwoo ngwonyadu ngwanni ngwïndädï gïyïꞌrïnyïnä ꞌdingini ndi ari Yicu nggwo kay gwadi ilada Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Aar määtä aar allijaji yiꞌrinala yidi ngwiꞌdi, aar elngala aar ari, “Gwortana! Gwonjacaar gwanni gwïndï ngwürïny ngwe ngwudi Deleny! Gwonjacaar gwanni gwuru Deleny didi Yïjïräyïl!” ");
INSERT INTO lro_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","A Yicu mbuji gïndüꞌrï ganni gooko, ngwape nggu allala, anaku üllïnäär gu ndi ari, ");
INSERT INTO lro_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Aaꞌti yedeny ya ang eny gwani gera gidi Jäyün. Lïngïdï ndi ari Deleny dunga ndo dïndï dändï kïndüꞌrälä ganni gooko.” ");
INSERT INTO lro_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Gwerre gwerre aaꞌti ngwooꞌra ngwüngün lïngïdï ngwujaꞌri ngwee ꞌdar yorto ye ngwaalinga a be anni ma aji a Yicu näjïnï, aar gu be lenge ndi ari ngwujaꞌri ngwee ꞌdar ngwüllïnä ngwani nginde na ndi ari yiꞌral giyee yärrïjäär je ꞌdar yani nginde. ");
INSERT INTO lro_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ngwüjï ngwanni ngwujaar le gaji ganni giming ge urnidi Liyajiring gidimomanu ngwüꞌdïꞌrïyälü giyiꞌranyanu gwumidu, aar ni ji ndi bädïyï ngwujaꞌralu. ");
INSERT INTO lro_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Anni ma gu ngwüjï ngwonyadu ꞌdingini ndi ari Yicu gwärrü yiima giyoo, aar ila ndi aar ombaji. ");
INSERT INTO lro_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","No, a be Ngwübärrïjï ondajidi aar ari, “Ombajar ngwarang ngwärrär je, änggädär ꞌdi ndi ari gwuma ngwüjï gwujanalu pipiꞌriꞌti!” ");
INSERT INTO lro_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ngwanni ngwïndädï ndi äpïjï Ngwaalinga yobo gïyïꞌrïnyïnä, ngwüjï ngwuju gwanu ngwuru Garany. ");
INSERT INTO lro_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ngindenga aar ila ndi Bïlïpüj gwudi gündär gani Bid Jäyïdä ngwaalu ngwani Jälïl aar otacalu aar ci, “Gwani mengga, änyängä lïmïnä ndi engga Yicung.” ");
INSERT INTO lro_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","A Bïlïpüj ele ndi ondaca Andrawujing. A ngindenga ꞌdün aar ele aar ondaca Yicung. ");
INSERT INTO lro_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","A je Yicu gwäꞌräjänü ngwari, “Gaji gima ja gito ganni gadi ge Gïjï gidi Dïjï dümnä näjïnï. ");
INSERT INTO lro_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nggwa je ondaci ꞌdidanu ndi ari, manari gon läy gima ꞌti gätïnä gïdïyäng ngwayi, gati gu jalu gwurꞌtal ngwuru läy leꞌte pu. Ma be ari gima gätïnï gïdïyäng mung ayi, ga ꞌtüdä ga ꞌriꞌri ngwäy ngwonyadu. ");
INSERT INTO lro_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Gwanni gwati ämnï ligoꞌro lüngün ling dudiyi na gwanni gwuma dudiyi ligoꞌro lüngün gïdïdlä ndee, ling geꞌtalu lani midi gwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Gwanni gwatiny äpïjï yiiru, aar nyi gwuji. A ngwaalu ngwunyi gu ji, gwanni gwuru dïnäd düny gwa gu ji ꞌto. Gwanni gwatiny äpïjï yiiru, gwa Papa gwüny näjï.” ");
INSERT INTO lro_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","A Yicu oꞌre ngwari, “Gweneno ligor gilo lïmïꞌrïdïnyänü, a be nggwadi araa? Gwani Papa gïlängïdïyïny kaji nggee? Bärï, a be yiru ꞌtu giyee yanni yïndädï nyi gu kaji nggee. ");
INSERT INTO lro_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Gwani Papa, näjïnä ngwürïny ngwunga!” A be dulu üllä kerala daru nu, “Ngwuminje näjï a ngwunje näjï mana.” ");
INSERT INTO lro_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ngwüjï ngwonyadu ngwuju ngenone aar ꞌdingini aar ari, gere giru gïmïꞌrïnänü. A ngwoko ari gïꞌrr giru gwondaca. ");
INSERT INTO lro_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","A Yicu ari, “Yal giyee yärräjäär je ngang je yaꞌti ani äny. ");
INSERT INTO lro_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gaji giru be nggee gidi obalu ngwüjï ngwudi dïdlä ndee! Gweneno deleny didi dïdlä ndee dadi aar be ꞌtüyï poor! ");
INSERT INTO lro_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","A be äny, manari äny gwuma äpïnälü gïdïyängälü nyi ällïnälä, linje oktani ꞌdar ꞌdünggüny.” ");
INSERT INTO lro_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yicu gwaru gu ngwujaꞌri ngwee no nunnu ngwinggidi yiꞌrany yiru ꞌtaa yanni yading je ayi. ");
INSERT INTO lro_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","A ngwüjï ondaji aar ari, “Yobo yidi Ngwaalu yaru nu, gwanni Gwubrutaar yelenya gwadi jadalu gwurꞌtal no awa nga be ari, ‘Gïjï gidi Dïjï dümnä ga ällïnälä’? Yärü gwuru gwani ‘Gïjï gidi Dïjï dümnä’?” ");
INSERT INTO lro_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","A je be Yicu ci, “Ngaa ladi jalu buringa le gaji gaꞌti olanu, elellaar gu be ara je oꞌrracalu, ndi aji a dïrïm ila ara je ümïnïcï ngwaalinganu. Dïjï danni dati ele gïdïrïmänü, dati ꞌti lïngïdï ndi ari ndo dïndï ne. ");
INSERT INTO lro_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ämnär be giburi anni janga buringa le, nunnu ngaa ru yïjï yidi buri.” Anni ma je gu Yicu ondaci ngwujaꞌri ngwee no, ngwüꞌdïꞌrï ngwuje ändädälü ngwele. ");
INSERT INTO lro_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yicu gwapu yiꞌremna yidi yiima giyee ꞌdar ngwäyänü ngwüjï, aaꞌti be ngwüjï mïnä ndi ämnï ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nunnu a ngwujaꞌri ätï ngwäyänü ngwanni ngwaru ngwe dïjïr didi Ngwaalu dani Ajaya ndi ari, “Gwani Deleny, yärü gwuru gwanni gwuma ämnï ngwujaꞌri ngwärï na yärüngä lanni lima je yiima yidi guy gidi Ngwaalu enggaci?” ");
INSERT INTO lro_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yiru giyee yanni yïgäbïcä je aar ꞌti be ämnä Ngwaalu anaku aru gu ꞌto dïjïr dani Ajaya ngwujaꞌri ngwe ngwuꞌter ndi ari, ");
INSERT INTO lro_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Liming je rïmïyï ngwäy ngwegen nunnu ma aar ombajidalu aar ꞌti änggädï na liming je ꞌrinye yigor yegen nunnu ma aar je ondaci, aaꞌti la lenge. Manari lima ꞌdingini, la joꞌrenyana la kwodalu ling je uꞌriyi nono.” ");
INSERT INTO lro_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ajaya gwondaju yïjïr ye ndi ari gwänggädï näjïng gwudi Yicu nggwe ondajalu. ");
INSERT INTO lro_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yäy a gwe ngweleny ngwudi Ngwüyäwüd ngwonyadu ämnï. A je be yedeny Ngwübärrïjï ndi ari aar ꞌtäcï ämnïngälü Ngwaalu gwegen nunnu la aar je linynyi ngwämrä. ");
INSERT INTO lro_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ndi ari ngindenga lati ämnï a je ngwüjï näjï ndi ari aar ämnï näjïng Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","A Yicu ondaji dula ngwari, “Ma dïjï ämnï ꞌdünggüny, daꞌti ämnä ꞌdünggüny jücü. Dämnä ꞌto ꞌdünggüngün gwanni gwükäjïny. ");
INSERT INTO lro_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ma aar nyi engga, gwuma engga ngindeng gwanni gwükäjïny. ");
INSERT INTO lro_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Äny gwuru buri gwïndï gïdïdlä, nunnu aaꞌti dïjï danni dadi ämnï ꞌdünggüny da ji gïdïrïmänü.” ");
INSERT INTO lro_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ngwari, “A be gwanni gwadi ꞌdingini ngwujaꞌri ngwüny, aar je ꞌti be ꞌdengenaca, ngwäꞌtüdï gwadi nyi otacalu. Äny gwaꞌti ïndädï ndi otaci ngwüjälü ngwudi dïdlä, nggwïndädï ndi nje gïlängïdïyï. ");
INSERT INTO lro_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Otacalu gwa ji gïdïjï danni dadiny ꞌdonya ngwuꞌdonya ngwujaꞌri ngwüny. Ngwujaꞌri ngwe ngweꞌte ngweꞌte ngwanni ngwondaji nje, ngwuru ngwanni ngwa ji ngwotaci ngwüjälü komon nggäꞌdï gidi mïꞌrä. ");
INSERT INTO lro_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Äny gwaꞌti ondaja ngwujaꞌri ngwere ligor le lüny. Äny gwondaja ngwujaꞌri ngwanni ngwucaar nyi ngwe Papa gwanni gwükäjïny na awa nje ärrï. ");
INSERT INTO lro_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Äny gwülïngïdï ndi ari ngwujaꞌri ngwüngün ngwanni ngwaru ngwe, ngwätï miding gwudi gwurꞌtaling. Yäy gu no, yere ꞌdar yanni yati nje ondaji, yiru giꞌra geꞌte geꞌte yanni yicaar nyi ye Papa.” ");
INSERT INTO lro_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gomon giru kaji nggoo gwerre gwerre ndi gomon gidi Yïꞌrïnyïnä yidi Dambdani ïꞌdï, Yicu gwülïngïdï ndi ari gaji güngün gima medadi gïdïdlä ndee gwadi be oꞌre ndi Papa gwüngün. Anaku ämnïng gu ngwüjü ngwüngün ngwanni ngwuju gïdïdlä, ngwuje enggaci ämnïng gwüngün gwanni gwämnï je gwe gwumedadu. ");
INSERT INTO lro_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Anni ma aar je gïꞌtïjälü ladi eny digera dalu, a dijegoꞌrr dima gu be änï giligoranu lidi Yäwüdä Äjïgärïyütï gwuru gïjï gidi Jamaan nunnu ngwugwurlanu Yicu ngwe. ");
INSERT INTO lro_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yicu gwülïngïdï ndi ari gwätädï Papa yelenya ꞌdar yidi yiꞌralalu pipiꞌriꞌti na ndi ari nginde gwïndï Ngwaalu na gwadi oꞌre Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","No, ngwüꞌdiꞌrälü kinyalu ngwügwäꞌdä diredalu düllänïng ngwugekanalu dired de diru lari gidiriny. ");
INSERT INTO lro_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ngwube ape yaw ngwuje bäläjï konganu ngwuyi ngwoꞌra ngwüngün yora nono ngwuje be bruti nono dired de diru lari danni digekaning dalu gidirinyanu. ");
INSERT INTO lro_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Anni mung ila ndi Jamaan gwani Butruj, a Butruj ci, “Gwani Deleny, ii a gwadi nyi uyi yora nono yüny?” ");
INSERT INTO lro_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","A Yicu ci, “Nga gwaꞌti lïngïdï yiꞌral yorto ye ngwaalinga giyee yärrï nje gwenene, yaji ya je be lenge gweere.” ");
INSERT INTO lro_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","A Butruj ci, “Bärï nga gwaꞌti gwuny uyi yora nono aꞌtur.” A Yicu ci, “Manari nggwuma ang ꞌti uyu yora nono, nga gwaꞌti gwätï guꞌru gere ꞌdünggüny.” ");
INSERT INTO lro_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","A be Jamaan gwani Butruj ci, “Gwani Deleny, nyi ꞌti uyu yora nono ꞌdogo, uyi ngwuy nono na giꞌra ganu ꞌto.” ");
INSERT INTO lro_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","A Yicu ci, “Gwanni gwunu nono gwati ꞌti ba be mïnü uning nono gwati uni yora nono ꞌdogo. Ngwangina ngwüngün ꞌdar ngwujaw nono. A ngaa lijaw nono a be ngaa laꞌti gu jaw nono ku.” ");
INSERT INTO lro_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ndi ari gwülïngïdï ndi ari yärü gwuru gwanni gwadi gwurlanu. No ngwube ari, “Nga laꞌti jaw nono ku.” ");
INSERT INTO lro_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Anni mung medaji uying ngwoꞌra ngwüngün yora nono, ngwüꞌdïꞌrï ngwüllänï direda düngün ngwoꞌre ngwaalu ngwüngün ngwujalu. Ngwuje be otacalu, “Ngaa lïlïngïdï yiꞌral ye yorto ye ngwaalinga giyee yima je ärrïje?” ");
INSERT INTO lro_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ngwuje ci, “Ngaa latiny ci, ‘Doorta’ nyii ci, ‘Deleny’, a yätï ngwäyänü, ndi ari äny gwuru gu. ");
INSERT INTO lro_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","A be gwenene, äny gwanni gwuru Deleny dalu nyi ru Doorta dalu, äny gwuya je yora nono, nga nga ꞌto oyajidar yora nono yalu. ");
INSERT INTO lro_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Äny gwuma je enggaci gay nunnu ngaa je gu ape ꞌto anaku äpïjä je gu. ");
INSERT INTO lro_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nggwa je ondaci ꞌdidanu ndi ari, dïnäd daꞌti pana yelenya gidoorta düngün na gwanni gwükäjäär gwaꞌti pana yelenya nginde gwanni gwükäjü. ");
INSERT INTO lro_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ngaa lima lenge ngwujaꞌri ngwee manari yima je ärrï, la je be onjaci.” ");
INSERT INTO lro_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Äny gwaꞌti ondijaja ꞌdanggalu ꞌdar anaku raa gu. A be äny gwondijaja ngwüjï ngwanni ngwülïngïdï nje ngwäbrï nje. A be yiru giyee ndi ari a ngwujaꞌri ngwudi Ngwaalu kitabanu ätï ngwäyänü ngwanni ngwaru nu, ‘Gwanni gwemadiiny gwe kiny güny gwuminy gwe gwurlanu.’” ");
INSERT INTO lro_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ngwuje ci, “Nggwondaca je gwenene giyona yaꞌti ju nunnu ma ji ma aar ji, ngaa ämnï ndi ari äny gwuru. ");
INSERT INTO lro_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nggwa je ondaci ꞌdidanu ndi ari, gwere gwanni gwa ämnï dïjü danni dükäjïny, nginde gwämnïny. Na gwere gwanni gwuny ämnï, gwämnä ngindeng gwanni gwükäjïny.” ");
INSERT INTO lro_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Anni ma Yicu ondaji ngwujaꞌri ngwee, a lïgïꞌrïm mïꞌränü giligoranu lüngün ngwondaji ngwari, “Nggwa je ondaci ꞌdidanu ndi ari gweꞌte ꞌdanggalanu gwadi nyi gwe gwurlanu.” ");
INSERT INTO lro_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","A ngwooꞌra ngwüngün pïnïdï ngwäy ngwe nono a je gwe ngwaalu elalu ndi ari yärü gwuru ꞌdenggenanu gwarung gwe. ");
INSERT INTO lro_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","A dooꞌra deꞌte danni dati Yicu ämnï, ndracalu direl de gito gito, ");
INSERT INTO lro_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","a Jamaan gwani Butruj ci milang ngwuci, “Otacalu ndi ari yärü gwuru ngwanni ngwarung gwe.” ");
INSERT INTO lro_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","A dooꞌra ndra Yicung nono ngwotacalu ngwuci “Gwani Deleny, yärü gwuru?” ");
INSERT INTO lro_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A Yicu gwäꞌräcänü ngwuci, “Nginde gwuru gwanni gwadi nyi ätädä yona giyee minje duwaji.” Yäy gu no ngwuduwaji yona ngwuje ätädä Yäwüdäng gwani Äjïgärïyütï gïjï gidi Jamaan. ");
INSERT INTO lro_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Anni ma Yäwüdä eny yona giyo no, a gu dijegoꞌrr änänü. A Yicu ci, “Yanni yada je ärrï, ärrä je puprang.” ");
INSERT INTO lro_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Aaꞌti dïjï dere ndi eny lïngïdï ndi ari ange gwuru gwucaja gu Yicu ngwujaꞌri ngwee. ");
INSERT INTO lro_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Aar be geꞌtaji ndi ari, anni ati Yäwüdä ru gwati määtä ngwüꞌrïnyä, a be loko geꞌtaji ndi ari gwuca Yicu ngwilla ngwony aar ngwe ape yïꞌrïnyïnä ya nunnu ngwape gwoko ngwätädä ngwuwaya. ");
INSERT INTO lro_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Anni ma Yäwüdä ape yona, ngwüꞌtü püd. Kaji nggoo ngwaalu ngwuma gu ümnänü. ");
INSERT INTO lro_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Anni ma Yäwüdä ꞌtü, a Yicu ari, “Gwenene Gïjï gidi Dïjï dümnä gadi be näjïnï a Ngwaalu näjïnï nginde gwe. ");
INSERT INTO lro_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma Ngwaalu näjïnï nginde gwe, Ngwaalu ngwa näjï Gïjü ꞌdünggüngün a ging näjï puprang.” ");
INSERT INTO lro_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","A je Yicu ci nu, “Lani yïjï yüny, a ladi jalu ꞌdogo yomon cong, ngaa liny mïnï, na anaku ondaciny gu Ngwüyäwüd gwerre, nggwa je gu ondaci ꞌto ndi ari, ngwaalu ngwanni ngwadi nyi gu ele, ngaa laꞌti la gu burni ndi ila.” ");
INSERT INTO lro_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ngwuje ci, “Nggwa je ätädä ngwujaꞌri ngwuru ngwuyang ndi ari ämnäjïdär. Anaku ma je gu ämnï, no ämnäjïdär gu be ꞌto. ");
INSERT INTO lro_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ngwujaꞌri ngwe ngwee, ngwüjï ꞌdar ngwa be lenge ndi ari ngaa liru ngwïkïrïjïn ngwüny, ma aang ämnäjïdï.” ");
INSERT INTO lro_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","A Butruj gwani Jamaan otacalu ngwuci, “Nga ngwadi ene gwani Deleny?” A Yicu ci, “Ngwaalu ngwanni ngwadi nyi gu ele, nga gwaꞌti gwa burni ndi nyi gwuja gwenene. A be gaji nggo a gwa ji a gwuny gwuja.” ");
INSERT INTO lro_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Oꞌre a Butruj otacalu, “Ange gwuru gwani Deleny nyi ꞌti be burna ndi ang gwujani gwenene? Äny gwa dudiyi ligoꞌro lüny gwani nga.” ");
INSERT INTO lro_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","A be Yicu ci, “ꞌDidanu nga gwa dudiyi ligoꞌro lunga gwani änye? ꞌDidanu nggwa ang ci, gwerre gwerre ndi gokto urri, nga gwuny nyïꞌrïnï yomonanu täꞌrïl!” ");
INSERT INTO lro_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ngwuje ci, “Aaꞌti yigor ya je mïꞌränü, gätädär ngwäyänü Ngwaalu, gätädär ngwäyänü ꞌdünggüny ꞌto. ");
INSERT INTO lro_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ngwuꞌdun ndi Papa gwüny, ngwätï yimbang yonyadu. Adinari aar gu ꞌti rüdï, nggwada je gu ci. Äny gwadi ele ngenone nda je gïꞌtïjä ngwaalinga mama. ");
INSERT INTO lro_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na manari nggwuma ele ma je gïꞌtïjä ngwaalinga mama, nggwa be oꞌra nggwa je apani ar ji, nunnu ngwaalu ngwanni ngwadi nyi gu ji, ngaa gu ji ꞌto. ");
INSERT INTO lro_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ngaa lïlïngïdï gay gidi ngwaalu ngwanni ngwadi nyi gu ele.” ");
INSERT INTO lro_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","A Tumaj ci, “Gwani Deleny, nyii laꞌti lïngïdï ndi ari ngaa gwadi ene, awa nyii be lenge gay?” ");
INSERT INTO lro_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","A be Yicu ci, “Äny gwuru gwanni gwuru gay nyi ru ꞌdidanu na midi. Gwere gwaꞌti gwanni gwa ila ndi Papa gwüny ꞌdogo äny gwe. ");
INSERT INTO lro_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Manari ngaa lïlïngïdïny ꞌdidanu, ngaa la lenge Papang ꞌto. Gomon gidi gweneng, gwuma aang lenge gwuma aang engga.” ");
INSERT INTO lro_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","A Bïlïpüj ci, “Gwani Deleny, enggaci nje Papangalu kïrtün yiru yanni yïmïnï nje.” ");
INSERT INTO lro_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","A be Yicu ci, “Bïlïpüj, a liju yomon giyee ꞌdar yolanu nyi ꞌtina be lïngïde? Gwere gwanni gwuminy engga, gwuma engga Papang. Awa nga be ari, ‘Enggaci nje Papang’? ");
INSERT INTO lro_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nga gwaꞌti ämnä ndi ari äny nggwo ndi Papa na Papa nggwo ꞌdünggünye? Ngwujaꞌri ngwata je ondaci, ngwäꞌtüdï ngwujaꞌri ngwudi ligor lüny. A be Papa ru gwanni nggwo ꞌdünggüny gwanni gwapu yiiru giyee. ");
INSERT INTO lro_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ämnäcïny miny ari äny nggwo ndi Papa na Papa nggwo ꞌdünggüny. Na ämnär ꞌdogo gwani inggidi gwudi yiima yanni yärrïnä. ");
INSERT INTO lro_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nggwa je ondaci ꞌdidanu ndi ari gwere gwanni gwätï ämnïng ꞌdünggüny, gwa ärrï yiꞌral yanni yärrï nje. Ying je ärrï yipana giyiꞌral giyee ndi ari äny gwadi ele ndi Papa. ");
INSERT INTO lro_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","A yere ꞌdar yanni yada je mïnï ngwürïny ngwe ngwüny yinje ärrï, nunnu a Gïjï näjï Papang. ");
INSERT INTO lro_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Manari ngaa lima utalu yiꞌral ye yere ngwürïny ngwe ngwüny, yinje ärrï.” ");
INSERT INTO lro_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","A je Yicu ci, “Manari ngaa lämnïny, ngaa la ꞌdengenaci ngwujaꞌri ngwee ngwanni ngwuca je ngwe. ");
INSERT INTO lro_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na äny gwa otaci Papangalu ara je ätädä dedere diꞌter ngaa le ji giyomonalu pipiꞌriꞌti. ");
INSERT INTO lro_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Lïgïꞌrïm lanni liru ꞌdidanu lanni läꞌtüdï ladi ngwüjï ngwudi dïdlä ämnï. Ndi ari laꞌti aar änggädï aar ꞌti lïngïdï. Ngaa be lenge, ndi ari lata le ji na ladi ji ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nggwa ꞌti gwa je gatanalu yimiꞌrunu, äny gwa je oꞌraca. ");
INSERT INTO lro_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Gito gwuru a ngwüjï ngwudi dïdlä ngwa ꞌti ba be ngwuny engga a be ngaa liny engga. Ndi ari äny gwumidu na ngaa la midi ꞌto. ");
INSERT INTO lro_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Gomon nggone, ngaa la be lenge ndi ari äny nggwo ndi Papa gwüny, ngaa ji ꞌdünggüny nyi ji ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Gwere gwanni gwätï ngwujaꞌri ngwüny ngwuje ꞌdengenaci, nginde gwuru gwanni gwämnïny. Gwanni gwatiny ämnï gwa Papa gwüny ämnï a gwuny ämnï ꞌto a gwuny enggaci änyïng.” ");
INSERT INTO lro_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","A be Yäwüdä gwuꞌter (Äjïgärïyütï gwäꞌtüdï) ci, “A be ange gwuru gwani Deleny nje be enggaci ngang nga ꞌti be enggaci ngwüjü ngwudi dïdlä?” ");
INSERT INTO lro_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","A je Yicu gwäꞌräcänü ngwari, “Gwere gwanni gwa ari gwuny ämnï, gwa ꞌdengenaci ngwujaꞌri ngwüny. Gwa Papa gwüny ämnï a äny na Papa nyii ila gwunyii le geꞌte ngwuꞌduna ngwärï ꞌdünggün gwunyii le ji. ");
INSERT INTO lro_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Gwanni gwatiny ꞌti ämnä, gwaꞌti gwa ꞌdengenaci ngwujaꞌri ngwüny. Ngwujaꞌri ngwee ngwuꞌdingina je ngwüny ngwäꞌtüdï ngwudi ligor lüny. Ngwudi Papa ngwuru gwanni gwükäjïny.” ");
INSERT INTO lro_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ngwuje ci, “Äny gwondaca je ngwujaꞌri ngwe ꞌdar anni jarna ngene gïdïdlä. ");
INSERT INTO lro_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A be dedere dani Lïgïꞌrïm lidi Ngwaalu lanni Lijuꞌru lanni ladi ara je Papa ükäcä ngwürïny ngwe ngwüny, liru lanni lada je enggaci yiꞌral ꞌdar ara je diwayiniyi yiꞌralalu ꞌdar yanni yica je ye.” ");
INSERT INTO lro_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","A Yicu ari, “Nggwa je gätïjänïjï adatingalu gwüny. Adatalu gwüny gwa je gätïjänïjï. Gwaꞌta je ätädï nono ati gu ngwüjï ngwudi dïdlä ätädä. Aaꞌti ngaa la gäbïcï yigor yalu ya je mïꞌränü aaꞌti yedeny ya je eny. ");
INSERT INTO lro_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ngaa liꞌdingininy nyi ari, ‘Nggwada je gatani nyi ele a je be oꞌraca.’ Adinari ngaa lämnïny, ngaa ladi jayanu ndi ari äny nggwadi ele ndi Papa, ndi ari Papa gwupana ꞌdünggüny. ");
INSERT INTO lro_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Äny gwuma je be ondaci ngwujaꞌri ngwe gwerre gwerre ngwaꞌtina ju. Ndi ari ma ji ma aar gu ru, ngaa la ämnï. ");
INSERT INTO lro_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Äny gwaꞌta be rüdï gwada je ondaci gwonyadu, ndi ari deleny didi dïdlä ndee ndo dïndï. Daꞌti ätï yiima yere ndi aar nyi määtä. ");
INSERT INTO lro_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","A be nunnu a ngwüjï ngwudi dïdlä lenge ndi ari äny gwämnä Papang na ndi ari yärrï nje gu giꞌra yanni yicaar nyi ye Papa. Ilar be ar ele.” ");
INSERT INTO lro_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Äny gwuru dügïrï danni diru ꞌdidanu, a Papa gwüny ru dïjï didi daarti. ");
INSERT INTO lro_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Gwati üꞌrïꞌtä yiꞌrinalu mbüny ꞌdünggüny yanni yati ꞌti ꞌriꞌru, a be yanni yati ꞌriꞌri, yating je branu nunnu aar ꞌriꞌrani. ");
INSERT INTO lro_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nga nga lima je juꞌriyi nono ngwujaꞌri ngwe ngwanni ngwuma je ngwe ci. ");
INSERT INTO lro_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mätïnärälü ꞌdünggüny äny gwa mätïnälü ꞌdanggalu. Giꞌrina gere gaꞌti gati ꞌriꞌri gwuꞌren, mung ꞌti mätïnälü gïdügïrï, no ngaa, laꞌti la ꞌriꞌri manari ngaa lima ꞌti mätïnälü dünggüny. ");
INSERT INTO lro_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Äny gwuru dügïrï ngaa liru yiꞌrina yidi dügïrï, manari dïjï dima mätïnälü ꞌdünggüny na minyi mätïnälü ꞌdünggüngün, nginde da ꞌriꞌri yuula yonyadu. Manari ngaa lima ꞌti mätïnälü ꞌdünggüny, ngaa laꞌti la burni ndi ärrï yiꞌral yere. ");
INSERT INTO lro_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Manari gwere gwuma ꞌti mätïnälü dünggüny, gwa ru nono giꞌrina ganni gïgätïnä mbüny ngwundi. Yanni yiru gu no yati aar je utalu aar je gatu gïlïgä aar uꞌdi. ");
INSERT INTO lro_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Manari ngaa lima mätïnälü ꞌdünggüny, ara je gu ngwujaꞌri ngwüny mätïnälü, utar yalu yanni ya je mïnï na ya je ärrïjï. ");
INSERT INTO lro_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yiru giyee yani näjï gwudi Papa gwüny ndi ari, ngaa ꞌriꞌri yuula yonyadu ngaa inggidi yigoꞌro yalu ndi ari ngaa liru ngwïkïrïjïn ngwüny.” ");
INSERT INTO lro_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ngwuje ci, “Anaku ämnär nyi gu Papa gwüny, äny gwämnä je gu ꞌto. Gwenene mätïnär bälü ndi ämnï gwüny. ");
INSERT INTO lro_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Manari ngaa lima ꞌdengenaci ngwujaꞌri ngwüny ngwanni ngwuca je ngwe, ngaa la mätïnälü ndi ämnï gwüny nono anaku ꞌdengenaci nyi gu ngwujaꞌri ngwanni ngwucaar nyi ngwe Papa gwüny nyi mätïnälü ndi ämnï gwüngün. ");
INSERT INTO lro_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Äny gwuma je ondaci ngwujaꞌri ngwee ndi ari a jayanu gwüny ji ꞌdanggalu na jayanu mbuti.” ");
INSERT INTO lro_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ngwuje ci, “Ngwujaꞌri ngwüny ngwuru ngwee ndi ari, ämnäjïdär anaku ma je gu ämnï. ");
INSERT INTO lro_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ämnï gwanni gwupana guꞌru gwuru nggwee ndi ari ngwügäbïcï dïjü ngwududiyi ligoꞌro lüngün gwani ngwumaad ngwüngün. ");
INSERT INTO lro_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ngaa liru ngwumaad ngwüny, manari ngaa lima ꞌdingini ngwujaꞌri ngwanni ngwuca je ngwe. ");
INSERT INTO lro_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Äny gwaꞌti ba be gwa je ci ngwïnäd ndi ari dïnäd dati ꞌti lïngïdï yiiru yidi deleny düngün. A be manni äny gwa je ci ngaa ru ngwumaad ngwüny. Ndi ari ngwujaꞌralu ꞌdar ngwanni ngwenggacaar nje Papa gwüny, ngwuma je enggacalu ꞌdar. ");
INSERT INTO lro_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ngaa läꞌtüdï lurnidiny, äny gwuru gwurnida je nga je äbrï ndi ari ngaa ele ngaa ꞌriꞌri yuula yanni yaꞌti ya medadi. No Papa gwüny gwa je be ätädä ngwujaꞌri ngwanni ngwa je mïnï ngwürïny ngwe ngwüny. ");
INSERT INTO lro_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ngwujaꞌri ngwüny ngwuru ngwee ndi ari, ämnäjïdär.” ");
INSERT INTO lro_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","A Yicu ari, “Manari ngaa lima ke ngwüjü ngwudi dïdlä ngwäy, lïngïdär ndi ari liki nje ngwäy gwerre gwerre. ");
INSERT INTO lro_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Adinari ngaa ru lidi dïdlä, ngwüjï ngwudi dïdlä ngwada je ämnï. Ngaa läꞌtüdï lidi dïdlä. Äny gwurnida je ꞌdogo ngwüjänü ngwudi dïdlä. No, yiru yanni yïgäbïcä ngwüjü ngwudi dïdlä ara je be ke ngwäy. ");
INSERT INTO lro_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Diwayinar ngwujaꞌri ngwanni ngwuca je ngwe, ‘Dïnäd daꞌti pana yelenya gideleny düngün.’ Manari liminy übïnälü, la je gu übïnälü ꞌto. Manari liꞌdengenaca ngwujaꞌri ngwüny, la je ꞌdengenaci ngwujaꞌri ngwalu ꞌto. ");
INSERT INTO lro_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ngindenga la je gu ärrï ngwujaꞌri ngwee no ꞌdar gwani ngwürïny ngwüny. Ndi ari ngindenga laꞌti lïngïdï ngindeng gwanni gwükäjïny. ");
INSERT INTO lro_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Adinari äny gwuma ꞌti ïndï nje ondaci, yaꞌti yaadi aar je ätï nono yere yanni yiki. A be gwenene, ngindenga laꞌti ätï ꞌtüyïng yigoꞌro ndi ke gwegen. ");
INSERT INTO lro_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Gwanni gwati nyi ke ngwäy gwati Papa gwüny ke ngwäy ꞌto. ");
INSERT INTO lro_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Adinari äny gwuma ꞌti ärrü yiꞌral yere ꞌdenggenanu yanni yaꞌti je dïjï dere ärrü, laadi gu be ari ndi ari laꞌti ki. A be gwenene ngindenga länggädï yiima giyee nje be ke ngwäy a je Papa gwüny ke ngwäy. ");
INSERT INTO lro_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","A be yiru gu no nunnu aar mbuti yanni yaru ye yobo yegen ndi ari, ‘Liki nje ngwäy aꞌtur.’” ");
INSERT INTO lro_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ngwuje be ci, “Ma ji manari dedere dima ila danni dadi nyi ükäjä ndi Papa, Lïgïꞌrïm lanni liru ꞌdidanu ladi ꞌtüdä ndi Papa, liru lanni lada je enggaci ngwujaꞌri gwani äny. ");
INSERT INTO lro_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","A nga nga ꞌto ngaa linggidi ngwujaꞌri ngwani äny ndi ari ngaa liru lanni liju nyii le ꞌtuꞌtu anaku ꞌdïꞌrïny gwälü yiiru ye yüny.” ");
INSERT INTO lro_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","A je Yicu ci, “Nggwondaca je ngwujaꞌri ngwe ꞌdar ndi ari aaꞌti ngaa la dudi ngwaalu ngwere. ");
INSERT INTO lro_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ngindenga la je linynyi la je ꞌtüyï poor kiꞌdu gidi ngwämrä a ꞌdid ndi ari gaji ga ji gila ganni gadi ara je ge ꞌrinye aar be geꞌtaji ndi ari gilo ndi äpïjï Ngwaalinga yiiru. ");
INSERT INTO lro_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ngindenga la ärrï yiꞌral giyee ndi ari ngindenga laꞌti lïngïdï Papang gwüny aar nyi ꞌti lïngïdï. ");
INSERT INTO lro_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Äny gwondaca je ngwujaꞌri ngwee nunnu ma ji manari gaji gima ila ganni gadi aar ge ärrïnï, ngaa lenge ndi ari äny gwuma madini nggwuma je girinya. Äny gwaꞌta je ondaca ngwujaꞌri ngwee ꞌtuꞌtu gwerre ndi ari a liju.” ");
INSERT INTO lro_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","A je Yicu ci, “A be gwenene äny gwadi oꞌraci ngindeng gwanni gwükäjïny. Gwere gwaꞌti gwotacinjalu ndi ari äny gwadi ene. ");
INSERT INTO lro_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Anni ma je ondaci ngwujaꞌri ngwee, runi gwuma je ji giyigoranu gwupa. ");
INSERT INTO lro_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","A be äny gwa je ondaci ꞌdidanu ndi ari yijayana ndi nyi ele manari äny gwuma ꞌti ïndï, dedere daꞌti dila, ma be ari äny gwuma ele, da je be ükäcä. ");
INSERT INTO lro_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ma be ari dima ila, da be enggaci ngwüjü ngwudi dïdlä yiꞌral yegen yanni yiki, na ngwuje enggaci yanni yïdünälü na ngwuje enggaci yani obalu. ");
INSERT INTO lro_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","A be yanni yiki, yiru ndi ari ngwüjï ngwaꞌti ämnä ꞌdünggüny ");
INSERT INTO lro_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","a be yanni yani dünälü, äny gwadi oꞌraci Papang ngaa laꞌti ba be liny engga. ");
INSERT INTO lro_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Na yanni yani obalu, ndi ari deleny didi dïdlä ndee ndo dima aar de obalu.” ");
INSERT INTO lro_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ngwuje ci, “Äny gwätï ngwujaꞌri ngwonyadu ngwümïnä nda je ondaci. A be ngaa yaꞌti ya je määtä giyee ꞌdar. ");
INSERT INTO lro_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","A be manari Lïgïꞌrïm lima ila lanni liru ꞌdidanu, la je be üktïnï kay gidi ngwujaꞌri ꞌdar ngwanni ngwuru ꞌdidanu. Ndi ari läꞌtüdï ladi ondaji ligoꞌro le lüngün, a be ladi ondaji ngwujaꞌri ngwanni ngwading je ꞌdingina. Ara je enggaci ndi ari yiru ange yanni yadi ji gweere. ");
INSERT INTO lro_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nginde gwuny näjï ndi ari nginde ying je apa yüny yanni yadi nyi ye ari ara je ondaci. ");
INSERT INTO lro_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ꞌDar yidi Papa, yüny yiru. Yiru yanni yïgäbïcïny nyi be ari Lïgïꞌrïm ladi apa ngwujaꞌri ꞌdünggüny ara je be enggaci.” ");
INSERT INTO lro_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ngwuje ci, “Gito gwuru ngaa laꞌta be liny engga, a gito gwuru ngaa la oꞌre liny engga.” ");
INSERT INTO lro_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ngwooꞌra ngwoko ngwüngün utalu aar ari, “Yiru ange yarung ye yani, ‘Gito gwuru ngaa laꞌta be liny engga a gito gwuru ngaa la oꞌre liny engga,’ na ‘Nunnu äny gwadi ele ndi Papa gwüny’?” ");
INSERT INTO lro_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Aar gu ji ndi gwäꞌrïꞌtäjänü ndi ari, “Yiru ange giyee yondajung je yani, ‘A gito gwuru’? Ngwujaꞌri ngwee ngwaꞌti ar je lïngïdï.” ");
INSERT INTO lro_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","A Yicu lenge giyigoranu yegen ndi ari gwadi aar otacalu ngwujaꞌri ngwe ngwee, ngwuje be ci, “Ngaa lotajidalu ngwujaꞌri ngwee ngwaru nyi ngwe ngwani ange ndi ari, ‘Gito gwuru ngaa laꞌta be liny engga a gito gwuru ngaa la oꞌre liny engga’? ");
INSERT INTO lro_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nggwa je ondaci ꞌdidanu, ngaa la ari ngaa la runi a be ngwüjï ngwudi dïdlä ngwa jayanu. Ngaa la runi a be runi gwalu gwa gwurli gwa ru jayanu. ");
INSERT INTO lro_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ma ꞌtina daw lïngïtï, dati yajima enyanu ndi ari gaji güngün gima ila. A be ma ji mung lingeta, dati dodani yajima yanni yïtänü ngwujayanu ndi ari gïjï gima lïngïnï gïdïdlä. ");
INSERT INTO lro_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Yiru gu ꞌto no ꞌdanggalu, gwenene ngaa la runi a be nggwa je engga mana ngaa la jayanu a gwere gwaꞌti gwa je apada jayinganu gwalu. ");
INSERT INTO lro_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Gomon nggone, ngaa laꞌta be liny otacalu yiꞌral ye yere. Nggwa je ondaci ꞌdidanu ndi ari Papa gwüny gwa je ätädä yiꞌral yere ꞌdar yanni ya je mïnï ngwürïny ngwe ngwüny. ");
INSERT INTO lro_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ngaa laꞌtina ꞌdi kaji nggee, utalu yiꞌral ye yere ngwürïny ngwe ngwüny. Utaralu la je ätädä a jayanu gwalu gwa mbuti.” ");
INSERT INTO lro_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ngwuje ci, “Äny gwümïꞌrïcä je ngwujaꞌri ngwe giyiꞌral giyee. A be gaji ga ji gila nggwa je ondacalu kibeny Papa gwe, nggwaꞌti gwa je mïꞌrïcï ngwujaꞌri. ");
INSERT INTO lro_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Gomon nggäꞌdï, ngaa la utalu ngwürïny ngwe ngwüny. Äny gwaꞌti aru ndi ari nggwotaci Papangalu gwani nga nga. ");
INSERT INTO lro_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bärï Papa nginde giligoꞌro lüngün gwata je ämnï nunnu ngaa liminy ämnï na ngaa lima ämnï ndi ari äny gwüꞌtüdï ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Äny gwüꞌtüdï ndi Papa nyi üllä gïdïdlä na nggwadi be gatani dïdläyü nyi oꞌraci Papang.” ");
INSERT INTO lro_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","A be ngwooꞌra ngwüngün ci, “Nga gwenene gwuma ondajalu kibeny nga gwaꞌti nje ba be mïꞌrïcä ngwujaꞌri. ");
INSERT INTO lro_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gwenene nyängä lima lenge ndi ari nga gwülïngïdï ngwujaꞌralu ꞌdar, nga gwaꞌti mïnä ndi aar ang dïjï otacalu. No yiminje gäbïcï nyängä lima ämnï ndi ari nga gwïndï Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","A je be Yicu ci, “Ngaa lima be ämnälü gwodane? ");
INSERT INTO lro_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","A be gaji nggo gïndï, a gima ila gweneno ndi ari ngaa la badalu, dïjï da ele ꞌdunu ꞌdünggüngün. Ngaa liny gatanalu jücü. A be äny gwäꞌtüdï jücü, änyängä gilo Papa gwe gwüny.” ");
INSERT INTO lro_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ngwuje ci, “Äny gwondaca je ngwujaꞌri ngwee ꞌdar nunnu ngaa adatalu ꞌdünggüny, ndi ari ngaa gïdïdlä, ngaa la mbuji yiꞌrendenya, a be orꞌtemajar ndi ari äny gwuma dami dïdläyü!” ");
INSERT INTO lro_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Anni ma Yicu medaji ngwujaꞌri ngwee, ngwüꞌdïꞌrïyï ngwäy ngwombajidi kerala ngwari, “Papa, gaji gima be ila, näjä Gïjü gunga nunnu aar ang Gïjï gunga näjï. ");
INSERT INTO lro_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ndi ari gima ang ätädä yelenya ngwüjälä ꞌdar, nunnu ngwätädä ngwüjü ngwanni ngwuma je ätädä miding gwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A gwenene midi nggwee gwudi gwurꞌtaling, gwuru ndi ari aar aang lenge ndi ari nga gwuru ꞌdogo Ngwaalu ngwanni ngwuru ꞌdidanu na aar lenge Yicu Kirictung gwanni gwükäjängä. ");
INSERT INTO lro_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Äny gwuma ang näjï ngene gïdïyängälü, medaji gwe yiiru yanni yätädï nje nje ärrï. ");
INSERT INTO lro_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Näjïny be gwenene ngwäyänü ngwunga gwani Papa, näjï gwe gwanni gwätï nda gwele gwerre ndi dïdlä ji.” ");
INSERT INTO lro_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ngwuci, “Lanni lätädï nje ngwüjänü ngwudi dïdlä, lima je enggaci liru lunga gwele nje be ätädä a lima ꞌdengenaci ngwujaꞌri ngwunga. ");
INSERT INTO lro_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Gweneno ngindenga lima lenge ndi ari yiꞌral ꞌdar yanni yätädï nje, yïndï ꞌdunggunga. ");
INSERT INTO lro_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ndi ari liminje enggaci ngwujaꞌri ngwanni ngwätädï nje ngwuma aar je ämnï. Na lima gu lenge ꞌdidanu ndi ari äny gwüꞌtüdï ꞌdunggunga, a lima ämnï ndi ari nga gwuru gwükäjïny. ");
INSERT INTO lro_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Äny gwotacangalu gwani ngindenga, äny gwaꞌti ang otacalu ngwüjï ngwudi dïdlä, a be äny gwotacangalu ngwüjï ngwanni ngwätädï nje, ndi ari ngwunga ngwuru. ");
INSERT INTO lro_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yere ꞌdar yüny, yunga yiru, na yere yunga ꞌdar yüny yiru. A nggwuma näjïnï ngindenga le. ");
INSERT INTO lro_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Gito gwuru nggwaꞌta be gwa ji gïdïdlä a be ngindenga la ji gïdïdlä, a nggwadi ila ꞌdunggunga. Gwani Papa gwanni Gwujuꞌru, rïmïtï je yiima ye yidi ngwürïny ngwunga, ngwürïny ngwanni ngwätädï nje nunnu aar ru leꞌte pu, anaku ru nda gu leꞌte pu. ");
INSERT INTO lro_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Anni jiiny le, lati nje rime nje gu etadi ngwürïny ngwe ngwunga ngwanni ngwätädï nje, gwere gwaꞌti gwuma dudi ngwube ru gweꞌte pu gwudi yiꞌrany, ndi ari yanni yüllïnä kitabanu aar mbuti. ");
INSERT INTO lro_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","A be gwenene äny gwadi ila ꞌdunggunga, nyi be ondaji ngwujaꞌri ngwee äny nggwona ngene gïdïdlä ndi ari a je gu jayanu gwüny onjadala. ");
INSERT INTO lro_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Liminje enggaci ngwujaꞌri ngwunga lima be ke ngwüjü ngwäy ngwudi dïdlä, ndi ari ngindenga läꞌtüdï lidi dïdlä anaku aaꞌti nyi gu rüdï gwudi dïdlä. ");
INSERT INTO lro_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Otacalu gwüny gwaꞌti ani nunnu nga je ꞌtüyï gïdïdlä, a be nunnu nga je gu etadi gidijegoꞌrr. ");
INSERT INTO lro_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ngindenga läꞌtüdï ngwüjï ngwudi dïdlä, anaku aaꞌti nyi gu rüdï gwudi dïdlä. ");
INSERT INTO lro_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Juꞌriya je ꞌdidanu gwe, ngwujaꞌri ngwunga ngwuru ngwanni ngwuru ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Anaku ükäjïny gu gïdïdlä, liminje ükäjï ꞌto gïdïdlä. ");
INSERT INTO lro_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Gwani ngindenga, äny gwäbrïnä nunnu a ngindenga ꞌto aar äbrïnï ꞌdidanu.” ");
INSERT INTO lro_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ngwari, “Otacalu gwüny gwaꞌti ani ngindenga ꞌdogo jücü, äny gwotacangalu ꞌto ngwüjï ngwanni ngwadi ämnï ꞌdünggüny ngwujaꞌri ngwe ngwegen. ");
INSERT INTO lro_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ndi ari ꞌdar, aar ru leꞌte pu gwani Papa, anaku ja gu ꞌdünggüny nyi ji ꞌdunggunga. Ngindenga ꞌto aar ru leꞌte pu ꞌdengge, nunnu a ngwüjï ngwudi dïdlä ämnï ndi ari nga gwükäjïny. ");
INSERT INTO lro_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Liminje ätädä näjïng gwanni gwätädïny ndi ari aar ru leꞌte pu anaku ru nda gu leꞌte pu. ");
INSERT INTO lro_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Äny nggwo ꞌdenggegen, nga ji ꞌdünggüny. Gäbïcä je aar gekajidi aar ru leꞌte pu aar gäbïcï ngwüjü ngwudi dïdlä aar lenge ndi ari nga gwükäjïny na ndi ari lämnä je anaku ämnïny gu.” ");
INSERT INTO lro_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ngwari, “Gwani Papa, lïmïnï nje lanni liminje ätädä nyii le ji ngwaalu ngwanni ngwadi nyi gu ji, aar engga näjïng gwüny gwanni gwätädïny, ndi ari nga gwämnïny ꞌtuꞌtu dïdlä daꞌtina ju. ");
INSERT INTO lro_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Gwani Papa gwanni gwüdünälü, ngwüjï ngwudi dïdlä ngwaꞌti ang lïngïdï, a be nggwülïngïdängä, a gilee lüny lima lenge ndi ari nga gwuru gwükäjïny. ");
INSERT INTO lro_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Liminje enggaci ngang, na la oꞌre linje enggaci mana, nunnu ämnï gwanni gwämnïny gwe ngwuji ꞌdenggenanu a äny nyi ji ꞌdenggenanu.” ");
INSERT INTO lro_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Anni ma Yicu medaji otacing Ngwaalingalu, aar ꞌdïꞌrï ngwooꞌra ngwe ngwüngün aar dambu Gülä gidi Kidroning. Dambal ngenone, daarti diju gu didi ngwümïnïtï aar gu änï ngwooꞌra ngwe ngwüngün. ");
INSERT INTO lro_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","A be nggwo gwani Yäwüdä gwanni gwuma gwurlanu Yicu gwe, gwülïngïdï ngwaalinga ngwoo ndi ari Yicunga ngwooꞌra ngwe ngwüngün lati gu jalu pïd pïd. ");
INSERT INTO lro_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","No a Yäwüdä ila gidaartanu ngwoktana giꞌdu gidi gwuꞌtulu na ngwangida ngwudi gobo ngwükäjä je ngwurꞌdal ngwanni ngwuru ngweleny na Ngwübärrïjï. Aar ila lïgä länü yüꞌrï ye, ngwamba na yiiri. ");
INSERT INTO lro_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yïlïngïdï je Yicu ꞌdar ndi ari yiru ange yanni yadi ji ꞌdünggüngün. Ngwüꞌtü ngwuje otacalu, “Yärü gwuru gwanni gwümïnängää?” ");
INSERT INTO lro_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Aar ci, “Yicu gwudi Najrang.” A je Yicu ci, “Äny gwuru nggwee.” A Yäwüdä nggwo gwuming ge gwurlanu gwuju gwüdünädäär le. ");
INSERT INTO lro_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Anni ma Yicu ari, “Äny gwuru nggwee,” ngindenga aar oꞌrada giluꞌru aar ïrꞌdï gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ngwoꞌre ngwuje otacalu mana, “Yärü gwuru gwanni gwümïnägää?” Aar ci, “Yicu gwudi Najrang.” ");
INSERT INTO lro_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","A je Yicu ci, “Äny gwuca je äny gwuru nggwee.” Ngwuje ci, “Manari ngaa lïmïnïny, gäbïcär je gilee aar ele.” ");
INSERT INTO lro_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yiꞌral giyee yiju nunnu a ngwujaꞌri ätï ngwäyänü ngwanni ngwaru ngwe ndi ari, “Lanni lätädï nje, gwuminy ꞌti dudiya gwere.” ");
INSERT INTO lro_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","A Jamaan gwani Butruj gwätï galala ngwugwalli ngge mïꞌrï dïnädä didi dirꞌdal danni diru giꞌra ngwüꞌrïdä länälü lidi gaama. (Dïnäd ndo dani Malguj.) ");
INSERT INTO lro_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","A Yicu girinya Butrujing ngwuci, “Gwäꞌräjä galala käl güngün. Äny gwaꞌti gwa ïyï dïrbä danni dätädäär nyi Papa?” ");
INSERT INTO lro_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","A gwuꞌtulu gurnga le giru giꞌra gegen na ngwangida ngwudi gobo ngwanni ngwükäjä je ngweleny ngwudi Ngwüyäwüd määtä Yicung. Aar giki ");
INSERT INTO lro_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","aar ape aar gwe ele gwerre gwerre ndi Ananiya gwanni gwuru dünä ndi Giyaba gwuru dirꞌdal diru giꞌra dïdläyü ndoo. ");
INSERT INTO lro_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Giyaba gwuru gwanni gwülädï Ngwüyäwüd ndi ari yijayana ndi dïjï deꞌte pu ayi ngwüꞌrïdä ngwüjälü. ");
INSERT INTO lro_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","A Jamaan gwani Butruj na dooꞌra deꞌte mana gwujani Yicung. Ndi ari dïlïngïdï dirꞌdal danni diru giꞌra aar änï Yicunga le kubanu gidi dirꞌdal ndo diru giꞌra. ");
INSERT INTO lro_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","A be Butruj dünä gïlängïr poor. A dooꞌra ndoo dïndär Butruj gwe dïlïngïdï dirꞌdal danni diru giꞌra, kwodalu ngwondaci dïnädä danni diru gera danni etadu gïlängïr, aar gäbïcï Butrujing ngwänï. ");
INSERT INTO lro_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","A dïnäd diru gera gïlängïr otacalu ngwuci, “Nga gwaꞌti mene rüdï gweꞌte ngwooꞌranu ngwüngün. A gwäꞌtüde?” A Butruj ci, “Äny gwäꞌtüdï.” ");
INSERT INTO lro_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gaji nggoo dirun dïjïlü a ngwïnäd ngwangidanga le ngwudi gobo ngwükäjä je Ngwüyäwüd aar muji lïgä aar gu ji a Butruj ꞌto aar le ji ndi ji lïgälü. ");
INSERT INTO lro_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kaji nggoo a dirꞌdal danni diru giꞌra otaci Yicungalu gwani ngwooꞌra ngwüngün na ngwujaꞌri ngwanni ngwating je enggaci ngwüjü. ");
INSERT INTO lro_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","A Yicu ci, “Äny gwondaca ngwüjü ngwudi dïdlä gilingenalu. Äny gwati ji giyomon ꞌdar ndi enggaci ngwüjü ngwämrä na kobo ganni gati gu Ngwüyäwüd oꞌrajidalu gwüpäng. Nggwaꞌti ondaja ngwujaꞌri ngwere yuꞌrimi. ");
INSERT INTO lro_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nga be arra miny otacalu? Otaca jalu lanni liꞌdingininy. Ngindenga ꞌdidanu lïlïngïdï ngwujaꞌri ngwanni ngwondaji nje.” ");
INSERT INTO lro_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Anni ma gu Yicu ari no, a dangida deꞌte mïꞌrï ngwäyänü tired ngwuci, “Nga gwarra a gu be ondaci dirꞌdala diru giꞌra no.” ");
INSERT INTO lro_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","A Yicu ci, “Manari äny gwabingu ngwujaꞌri ngwere ngwanni ngwuki, inggida je, ma be ari ngwabingu nje ngwanni ngwätï ngwäyänü, nga be arra miny mïꞌrï?” ");
INSERT INTO lro_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","A be Anan gwanni gwuru dirꞌdal danni diru giꞌra ape ngwudinga gwugekanalu ndi Giyaba gwanni gwuru dirꞌdal danni diru giꞌra. ");
INSERT INTO lro_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Anni ma Jamaan ji ndi ji gïlïgä, aar otacalu aar ci, “Nga gwuru gweꞌte ngwooꞌranu ngwüngüne? A gwäꞌtüde?” A Butruj nyïꞌrïnï ngwari, “Äny gwäꞌtüdï.” ");
INSERT INTO lro_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","A dïnäd deꞌte ngwïnädänü ngwudi dirꞌdal danni diru giꞌra dätäär gilinge dïnäd de danni düꞌrïdädï Butruj länälü, ngwiyanu ngwuci, “Äny gwaꞌta je änggädï ngaa liju Yicunga le gidaartanu didi ngwümïnïte?” ");
INSERT INTO lro_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Oꞌre a Butruj nyïꞌrïnï ngwari gwäꞌtüdï. Kaji nggoo a gokto urra! ");
INSERT INTO lro_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Aar ꞌdïꞌrï aar ape Yicung ndi Giyaba aar gwe ele ngwuꞌdun ngwudi yeleny gideleny didi Rumang. Gwapaar dilu danu a Ngwüyäwüd ꞌdonya ndi änï ngwuꞌdun ngwudi yeleny ndi ari aaꞌti la rngï nono gwani yobo yegen nunnu aar jayi nono aar ele ndi eny Gïyïꞌrïnyïnä yidi Dambdani. ");
INSERT INTO lro_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","No a deleny dani Bilatij ꞌtüdä ngwuje otacalu ndi ari, “Yiꞌral yiru ange yanni yärrï je dïjï ndee?” ");
INSERT INTO lro_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aar ci, “Adinari daꞌti ärrü yiꞌral yere, daꞌti dadi ar ang äpïjä!” ");
INSERT INTO lro_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","A je be Bilatij ci, “Apar be ngaa gu pädä yelenya anaku aru gu ngwujaꞌri ngwudi yobo yalu.” Aar ci, “Änyängä laꞌti ätï yelenya yanni yadi nje gäbïcï nyii ꞌrinye dïjü ndee.” ");
INSERT INTO lro_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ngwujaꞌri ngwee ngwärrïnä nunnu aar mbuti yanni yaru ye Yicu ngwinggidi ndi ari gwadi ele ndi ayi awa. ");
INSERT INTO lro_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","A Bilatij änï gïdrü ngwurnida Yicung ngwotacalu ngwuci, “Nga gwuru Deleny didi Ngwüyäwüde?” ");
INSERT INTO lro_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","A Yicu ci, “Ngwujaꞌri ngwee ngwunga ngwuru gwalla ngwüjï ngwuru ngwuca gu?” ");
INSERT INTO lro_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","A be Bilatij ci, “Äny gwuru gïïlü gidi Ngwüyäwüde? Ngwüjï ngwalu na ngwurꞌdal ngwanni ngwuru ngweleny ngwalu ngwuru ngwäpïjïny ngang. Yiru ange yanni yärrä je?” ");
INSERT INTO lro_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","A Yicu ci, “Yeleny yüny yäꞌtüdï yidi dïdlä ndee, adinari a yeleny yüny ru yidi dïdlä ndee, ngwüjï ngwüny ngwadi dugidi nunnu aaꞌti ngweleny ngwudi Ngwüyäwüd ngwuny määtä. A be gwenene yeleny yüny yiru yidi ngwaalu ngwuꞌter.” ");
INSERT INTO lro_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","A Bilatij otacalu ngwuci, “A be nga gwuru delenye?” Ngwube ci, “Nga gwätïyä ngwujaꞌri ngwäyänü ndi ari äny gwuru deleny. ꞌDidanu yiru giyee yanni yïgäbïcïny nyi ila nyi lïngïnï gïdïdlä nunnu nyi ondaji ngwujaꞌri ngwanni ngwuru ꞌdidanu. Ngwüjï ngwanni ngwugwuja ꞌdidanung, ngwatiny geraji länï.” ");
INSERT INTO lro_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","A Bilatij ci, “Yiru ange yanni yiru ꞌdidanu?” Yiꞌral ye giyee, ngwüꞌtüdä mana ngwuci Ngwüyäwüd nu, “Äny gwaꞌti mbojaja guru nggee yiꞌral nono yere yadi nyi gu gekaji. ");
INSERT INTO lro_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","A be yiru gïdïmürä dalu Gïyïꞌrïnyïnä yidi Dambdani ndi ari äny gwata je gwäꞌdäcä dïjälü deꞌte pu gïdïdlä danni dïmïnängä nda je gwäꞌdäcälü. A be gwenene, ngaa lïmïnä nda je gwäꞌdäcä yärüngälü, nga je gwäꞌdäcä ‘Delenyalu didi Ngwüyäwüde?’” ");
INSERT INTO lro_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aar ürrï dula ꞌdar aar ari, “Bärï, aaꞌti gwa ang gwäꞌdädälü! Gwäꞌdäcï nje Barabajingalu!” (Barabaj gwünyürtïjä ngwelenyanu ngwuru duꞌram.) ");
INSERT INTO lro_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","A deleny dani Bilatij ape Yicung aar pï lacal le. ");
INSERT INTO lro_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","A gwuꞌtulu kwoy ngwügä dirꞌta aar je giki Yicung kiꞌra. Aar ape direda duri aar ülläcï. ");
INSERT INTO lro_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Aar elada oꞌre elada mana aar pïcälü yora ye aar ari, “Agannar delenya didi Ngwüyäwüd?” Aar pï ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Oꞌre mana a deleny dani Bilatij ꞌtüdä ngwuci Ngwüyäwüd nu, “Äny gwada je ꞌtücä ngindeng nga je enggaci ndi ari gwaꞌti nyi mbojaja yiꞌral nono yere yanni yadi nyi gu gekaji.” ");
INSERT INTO lro_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Anni ma aar ꞌtüyä Yicung gwugenna ngwügä kiꞌra na direda duri, a je deleny dani Bilatij ci, “Nginde gwuru nggwee!” ");
INSERT INTO lro_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","No, anni ma ngwurꞌdal ngwanni ngwuru ngweleny na ngwangida ngwegen engga, aar ürrï dula ari, “Pädï küꞌrï! Pädï küꞌrï!” A je be Bilatij ci, “Apar nga nga ngaa pä küꞌrï. Äny gwaꞌti nyi mbojaja yiꞌral nono yere yadi nyi gu gekaji.” ");
INSERT INTO lro_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A Ngwüyäwüd mïꞌrïnälü ndar aar ari, “Änyängä lätï yobo yärï a yobo yaru nu nginde gwa ayi. Ndi ari nginde gwuca ligoꞌro lüngün gwuru Gïjï gidi Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Anni ma gu Bilatij ꞌdingini ngwujaꞌri ngwee no, a yedeny itani. ");
INSERT INTO lro_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ngwoꞌre gïdrü ngwuꞌdun ngwudi yeleny ngwotaci Yicungalu ngwuci, “Nga gwïndï ne gwe?” A Yicu gwugwundi ngwuꞌti ondaca. ");
INSERT INTO lro_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","A Bilatij ci, “Nga gwuꞌdonya ndiny ondaci?” Ngwuci, “Nga gwaꞌti lïngïdï ndi ari äny gwätï yelenya ndi ang gatalu nyi ätï yelenya ndi ang pä küꞌre?” ");
INSERT INTO lro_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","A be Yicu ci, “Nga gwaꞌti gwaadi ätï yelenya yere aꞌtur ꞌdünggüny adinari aar je ꞌti ätädï kerala. A gu no, gwanni gwapeny aar nyi ätädä ngang, gwuru gwanni gwärrä yiꞌral yanni yikana.” ");
INSERT INTO lro_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ꞌTuꞌtu kaji nggoo, ati Bilatij mïnï ndi gata Yicungalu, a be Ngwüyäwüd ꞌdonya aar ürrï dula aar ci, “Manari nga gwuma gatu guralu nggee ngwele, nga gwäꞌtüdï dimaad didi Gayijar deleny didi Rumang. Ndi ari gwere gwanni gwaru gwuru deleny, gwuru güwän gidi Gayijar deleny didi Rumang.” ");
INSERT INTO lro_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Anni ma Bilatij ꞌdingini ngwujaꞌri ngwee, ngwüꞌtüyä Yicung poor, ngwujalu gididuꞌrala didi yeleny ngwaalu ngwucaar je ngwurꞌda ngwujalu miꞌder a ngwani, “Jäbätä” Yïbrïyängä. ");
INSERT INTO lro_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Komon nggoo giru gidi Jaꞌrimani gwudi Ngwüyäwüd giyomon yidi Yïꞌrïnyïnä yidi Dambdani lingen le lïdünälä. A Bilatij ci Ngwüyäwüd “Deleny dalu diru ndee.” ");
INSERT INTO lro_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aar be ꞌdonya aar ürrï dula aar ari, “Apa! Apa! Pädï küꞌrï.” A je Bilatij otacalu, “Ii a je ꞌrïnyïjï delenya dalu?” A ngwurꞌdal ngwanni ngwuru ngweleny ci, “Änyängä laꞌti ätï delenya dere, deleny därï dani Gayijar diru ꞌdogo deꞌte pu didi Rumang.” ");
INSERT INTO lro_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Gwodanalu a je Bilatij ätädä Yicung nunnu aar pä küꞌrï. ");
INSERT INTO lro_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","No a gwuꞌtulu ape Yicung ngwüpïnï güüꞌrï güngün aar ele ngwaalu ngwani guya gidi giꞌra gidi dïjï, (aar ani Jüljüjä Yïbrïyängä). ");
INSERT INTO lro_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ngeneno aar gu pä küꞌrälä ngwuꞌraminga le rom. Deꞌte aar pädä kuyala gidi gängïr na deꞌte kuyala gidi gaama. Aar be pä ngindeng gidiliganu. ");
INSERT INTO lro_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","A Bilatij ulli ngwujaꞌri ngwuje mïꞌrä küꞌrï ngwaru nu, YICU GWUDI NAJRANG DELENY DIDI NGWÜYÄWÜD. ");
INSERT INTO lro_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ngwüyäwüd ngwonyadu aar uli ngwujaꞌri ngwee ngwüllïnä ngwullaar je Yïbrïyängä, a Lätïnïyängä na Yïgïrïgïyängä. Ndi ari ngwaalu ngwanni ngwüpädäär gu Yicu küꞌrï, ngwaꞌti olanu kündär. ");
INSERT INTO lro_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","A be ngwurꞌdal ngwanni ngwuru ngweleny ꞌdonya aar ci Bilatijing, “Nga ꞌti ulla, ‘Deleny didi Ngwüyäwüd,’ A be ndi ari gur nggee giru garu giru deleny didi Ngwüyäwüd.” ");
INSERT INTO lro_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","A je Bilatij ci, “Yanni yiminje ulli, yiminje ulli.” ");
INSERT INTO lro_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Anni ma gwuꞌtulunga pä Yicung küꞌrï, aar ape ngwureda ngwüngün aar je geꞌte guꞌranu kwoꞌrongo ati dïjï ape guꞌru geꞌte ngwube jalu didi ngwanginu dügꞌrïnä laranu leꞌte pu ꞌtuꞌtu kiꞌra ꞌdi ngwobani koralu. ");
INSERT INTO lro_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aar ape aar ari, “Aaꞌti da ar diritanu. Gäbïcär ar gatu yiꞌru yärü gwuru gwanni gwadi ape.” Ngwujaꞌri ngwee ngwuju nunnu yanni yüllïnä gwerre kitabanu gidi Ngwaalu, aar mbuti ndi ari, “Lapu ngwureda ngwüny aar je genatanu aar gatu yiꞌru ngwured ngwüny.” No yiru giyee yanni yärrï je gwuꞌtulu. ");
INSERT INTO lro_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","A nanni gwudi Yicu dünï gito gito ngwaalu ngwanni ngwüpädäär gu Yicung küꞌrï na gwenggen gwudi Märïyäm gwuru gera na Märïyäm gwuru daw didi gur gani Kelobaj na Märïyäm gwani Mäjïdälïyä. ");
INSERT INTO lro_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Anni ma Yicu engga nanning gwüngün na dooꞌra düngün danni dating ämnï dïdünäcälü, ngwuci nanning gwüngün gwani Märïyäm, “Gwani daw, gïjï gunga giru nggoo.” ");
INSERT INTO lro_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Na ngwuci doꞌra düngün ndoo, “Nanni gwunga gwuru nggwoo.” ꞌTuꞌtu kaji nggoo a dooꞌra ndoo ape nggwe ele ꞌdunu ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Anni ma ji a Yicu engga ndi ari yiꞌral giyee ꞌdar yima ärrïnï nunnu aar mbuti yanni yüllïnä kitabanu ganni guꞌrin, ngwari, “Ngwäädä ngwïtïny.” ");
INSERT INTO lro_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Dïtï deꞌte diju ngeno donyadu diꞌricala dula. Aar gu irtiyi lïbä, aar gekaji gidirula didi didirun aar gïꞌtïjï ngwulem nunnu ngwïyï. ");
INSERT INTO lro_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Anni mung je drü, a Yicu ari, “Yima mbuti.” Ngwujaꞌri ngwe ngwee, ngwümïꞌrï giꞌra ge a lïgïꞌrïm ꞌtü. ");
INSERT INTO lro_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Gomon giru gidi Jaꞌrimani gidi Ngwüyäwüd nunnu dilu danu ndoo, gomon gadi ru ganni giru Kwoꞌra täꞌrïl gïnï. Laꞌti mïnä ngwangina ngwudi ngwüjï ngwayu aar ji gïyüꞌrälä gomon nggee giru Kwoꞌra täꞌrïl. Aar ci Bilatijing aar je pï yoranu yegen aar ayi puprang aar je ülläjälü. ");
INSERT INTO lro_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","No, a gwuꞌtulu ila ngwüpï yoranu yidi gur gidi gwerre gwerreng ganni gïpädäär je küꞌrï Yicunga le, oꞌre aar je pänü yidi gur nggoo giꞌter. ");
INSERT INTO lro_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","A be anni ma aar ila ndi Yicu, aar mbuji gwuma ayi, aar ꞌti kiya yora yüngün. ");
INSERT INTO lro_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","A be manni gwuꞌtulu gweꞌte dugi giiri ge kimeranu a yïn bälädälü na yaw kimeranu. ");
INSERT INTO lro_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Gwanni gwänggädï yiꞌral giyee, gwuru gwondaja ngwujaꞌri ngwee a ngwujaꞌri ngwüngün ngwätï ngwäyänü. Nginde gwülïngïdï ndi ari nginde gwati ondaji ngwujaꞌri ngwätï ngwäyänü, ngwube ondaji ngwujaꞌri ngwee nunnu ngaa ämnï. ");
INSERT INTO lro_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yiꞌral giyee yärrïnä nunnu a ngwujaꞌri ngwaru ngwe gitab ätï ngwäyänü ndi ari, “Guya gere güngün gaꞌti ga aar kiyi.” ");
INSERT INTO lro_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","A ngweꞌte mana ꞌter ngwaru, “Gwa ji gwa aar ombaji gwanni gwudugaar.” ");
INSERT INTO lro_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Gwodanalu, a gur geꞌte ila gani Yüjïb gati ji kündär gani Rama, ngwotaci Bilatijingalu ngwangina ngwe ngwudi Yicu. Kaji nggoo Yüjïb nggwee gwuru dooꞌra didi Yicu yuꞌrimi. Ndi ari gwïtï yedeny Ngwüyäwüd. Ngwapa ngwujaꞌri gideleny dani Bilatij ngwila ngwape ngwangina ngwudi Yicu ndi gwuꞌtulu ngwe ele. ");
INSERT INTO lro_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Lïndï Nïkïdïmüj gwe gwanni gwelaca Yicung gomon geꞌte gwerre dilu de a Nïkïdïmüj apana ngwuuwa ngwülägänänü gündïl ge ngwa ru rotela ꞌdï kwoꞌra täꞌrïl na tudini (75). ");
INSERT INTO lro_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","A Ngindenga rom ape ngwangina ngwudi Yicu aar je bruti ngwuuwa ngwe aar je pä direda nono diru lari. Ngwüyäwüd ngwati gu ape dïmürä didi gatidi. ");
INSERT INTO lro_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ngwaalu ngwanni ngwüpädäär gu Yicu küꞌrï, daarti diju gu dätï dimomo dïpïdäär diyang daꞌti aar gu gätï dïjänü dere aꞌtur. ");
INSERT INTO lro_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ndi ari gomon giru nggoo gidi Jaꞌrimani gidi Ngwüyäwüd, na anni ju dimomo gito gito, aar gu gatu Yicung ngeno. ");
INSERT INTO lro_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Gomon ganni giru giꞌra giyomon Kwoꞌra täꞌrïl, ngwaalu ngwalu tümün tümün, a Märïyäm gwani Mäjïdälïyä ꞌdïꞌrï ngwele gidimomalu ngwumbuji ndi ari dïꞌrïmün kïy gidi dimomo dima äbränälü mbüny. ");
INSERT INTO lro_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","No a nginde kwodalu ngwugwalajanu ngwila ndi Jamaan gwani Butruj dooꞌra de danni dati Yicu ämnï ngwuje ci, “Ngwüjü ngwuma ape Delenya gidimomanu daꞌti nyi de lïngïdï ngwaalinga dima aar geꞌte ne!” ");
INSERT INTO lro_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","No Butruj na dooꞌra ndoo diꞌter ꞌdïꞌrï aar ele gidimomalu ndi aar ombaja yiꞌral giyee. ");
INSERT INTO lro_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Aar be gwalajanu ngindenga rom a gur nggoo gïndär Butruj gwe, dalmacani ngwugatani Butrujing ꞌdi ngwombani gwerre gwerre gidimomalu. ");
INSERT INTO lro_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ngwüllänü ngwombajidalu gidimomanu ngwenggada direda diru lari dïpädäär Yicung nono dijalu ngwuꞌti be ändï. ");
INSERT INTO lro_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","A be Jamaan gwani Butruj gwuja gwodan anni mung obana, ngwänï gidimomanu ngwengga ngwureda ");
INSERT INTO lro_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na dired didi gatidi na ꞌto danni dïpädäär giꞌra nono, dïpänïdälü ngwügïꞌtïnälü ꞌter ngwured ngwoo. ");
INSERT INTO lro_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Gwodanalu a dooꞌra änï ꞌto ndoo dele dobana gidimomalu gwerre gwerre. Ngwengga yiꞌral giyee ngwämnï. ");
INSERT INTO lro_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ngindenga kaji nggoo laꞌti gu na lïngïdï ngwujaꞌri ngwudi gitab ndi ari Yicu gwadi ꞌdïꞌrï giyiꞌranyanu.) ");
INSERT INTO lro_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","A ngwooꞌra ngwo kwodalu aar oꞌre ꞌdunu ꞌdenggen. ");
INSERT INTO lro_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","A be Märïyäm jina ndi dünädälä poor gidimomalu ngwuji ndi ari. Anni mung ji ndi ari, ngwüllänü gwadi ombajidi gidimonanu, ");
INSERT INTO lro_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ngwenggada yïꞌrrä rom yigenna ngwureda ngwubidu pupuꞌrul yijalu ngwaalu ngwanni ngwügätäär gu Yicung. Geꞌte jada kiꞌra na geꞌte jada giyora. ");
INSERT INTO lro_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Aar otacalu aar ci, “Gwani daw, a gwarra ma ang ari?” Ngwuje ci, “Lima ape Delenya düny, a gwaꞌti nyi gwe lïngïdï ngwaalinga gwuma aar geꞌte ne.” ");
INSERT INTO lro_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ngwujaꞌri ngwe ngwee, nggwurlalu ngwengga Yicung gwüdünü ngenone, ngwuꞌti be lïngïdï ndi ari Yicu gwuru. ");
INSERT INTO lro_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","A Yicu ci, “Daw ndee, nga gwarra ma ang ari? Yärü gwuru gwümïnängä?” Ngwuji ndi ari dïjï diru didi daarti ndoo, ngwuci, “Gwani doorta, manari gwuma ang ape, enggaciny gwe ngwaalinga ngwanni ngwuma gu geꞌte nyi ape.” ");
INSERT INTO lro_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","A Yicu ci, “Märïyäm.” Ngwugwurla nono ngwurnidi gwelleny Yärmïyängä ngwuci, “Gwani Doorta düny!” ");
INSERT INTO lro_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","A Yicu ci, “Nyi ꞌti akana nono. Ndi ari äny gwaꞌtina ïndï ndi Papa gwüny. Oꞌra manni ang ele ngwänggärï nga je ci, ‘Äny nggwadi oꞌre ndi Papa gwüny na Papa gwalu, nyi oꞌre Ngwaalu ngwüny na Ngwaalu ngwalu.’” ");
INSERT INTO lro_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","A Märïyäm gwani Mäjïdälïyä ape ngwujaꞌri ngwuje äpïjï ngwoꞌra ngwudi Yicu, ngwuje ci, “Äny gwuma enggada Delenya!” Ngwuje ondaci ngwujaꞌri ngwucung ngwe. ");
INSERT INTO lro_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Gomon nggoo giru giꞌra giyomon Kwoꞌra täꞌrïl digera de, anni ma ngwooꞌra ngwudi Yicu oꞌrajidalu gwüpäng, aar längïtïnï gïdrü yedenyo ngweleny ngwudi Ngwüyäwüd. A Yicu ila ngwuje aganni ngwüdünï gidiliganu ꞌdegegen. Ngwuje aganni ngwuje ci, “A adatalu ji ꞌdanggalu!” ");
INSERT INTO lro_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Anni mung je gu ci no, ngwuje enggaci yubuꞌru yidi ngwümmä ngwuy na kimere. Anni ma ngwooꞌra ngwudi Yicu engga Yicung, a je jayanu apani. ");
INSERT INTO lro_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","A je Yicu aganni mana ngwuje ci, “A adatalu ji ꞌdanggalu! Anaku ükäjärïny gu Papa nggwa je ükäjï ꞌto.” ");
INSERT INTO lro_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ngwujaꞌri ngwe ngwee, ngwuje büdä nono düwä de ngwuje ci, “Apar Lïgïꞌrïmä lanni Lijuꞌru. ");
INSERT INTO lro_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ma aang düdänïjï dïjänü dere ndi ape gwüngün gwanni gwuki, da aar düdänïjänü, ma aang ꞌti düdänïjänü, daꞌti da aar düdänïjänü.” ");
INSERT INTO lro_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","A Tumaj gwanni gwuru Dänggïl gwuru ngwoꞌranu ngwudi Yicu ngwoo ꞌdï na rom (12) gwaꞌti aar ju ngwooꞌra ngwe ngwudi Yicu gaji ganni gïndï ge Yicu. ");
INSERT INTO lro_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","A be ngwooꞌra ngwoko ngwoo ondaci aar ci, “Änyängä länggädï Delenya.” Ngwuje be ci, “Minyi ꞌti änggädï yubuꞌru yidi mijamir ngwuy ngwüngün nyi geꞌte gomon güny ngwaalu ngwanni ngwüpädäär gu mijamir na nyi geꞌte guy güny kimere ganni gidugaar gu, yaꞌti yinje ämnï.” ");
INSERT INTO lro_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","A gomon giꞌter giyomon kwoꞌra täꞌrïl, oꞌre a ngwooꞌra ngwudi Yicu ji ndi oꞌrajidalu ngwuꞌdun ngweꞌte ngweꞌte aar ji Tumajinga le ngwängïr ngwülängïtïnä. A be Yicu ila ngwüdünälä gidiliganu ꞌdenggen ngwuje aganni ngwuje ci, “A adatalu ji ꞌdanggalu.” ");
INSERT INTO lro_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ngwube ci Tumajing, “Geꞌta guy gunga ngene, änggädï ngwuy ngwüny dingada guy gunga kimere güny. Gäbïcï ümïmïngänü nga ämnï.” ");
INSERT INTO lro_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","A Tumaj ci, “Gwani Deleny düny na Ngwaalu ngwüny.” ");
INSERT INTO lro_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","A Yicu ci, “Nunnu a gwuminy engga nga be ämnï ꞌdünggüny. Lonjacaar je lanni laꞌti nyi änggädï, aar be ämnï ꞌdünggüny.” ");
INSERT INTO lro_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","A Yicu ärrï yiꞌremna yidi yiima yonyadanu ngwäyänü ngwudi ngwooꞌra ngwüngün, yaꞌti üllïnä kitabanu nggee. ");
INSERT INTO lro_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","A be giyee yüllïnä nunnu ngaa ämnï ndi ari Yicu gwuru gwanni Gwubrutaar yelenya, gwuru Gïjï gidi Ngwaalu na ämnï gwe ꞌdünggüngün, ngaa la mbuji miding gwudi gwurꞌtaling ngwürïny ngwe ngwüngün. ");
INSERT INTO lro_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Oꞌre mana a Yicu ꞌtäcä ngwoꞌralu ngwüngün gito gito giyaw yani Täbïrïyä. Yiꞌral giyee yiju no, ");
INSERT INTO lro_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Butruj gwani Jamaan na Tumaj (gwuru Dänggïl) na Nataniyal gwanni gwati ji ngwaalu ngwani Kana Jälïl, na yïjï yidi Jäbädï rom, na ngwooꞌra mana rom, ngindenga ꞌdar liju gwüpäng. ");
INSERT INTO lro_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","A Jamaan gwani Butruj ꞌdïꞌrï ngwuje ci, “Äny gwadi ele ndi umma ngwuuma.” Aar ci, “Ar ele gwüpäng.” Aar ꞌtü ar üllï gïbälükänü aar ꞌti mätï gonyalu gere dilunga ndoo. ");
INSERT INTO lro_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ꞌTuꞌtu dilu danu, a Yicu ele ngwüdünä kïmämü, aaꞌti ngwooꞌra ngwüngün lïngïdï ndi ari gwuru. ");
INSERT INTO lro_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ngwuje urnidi ngwuje ci, “Lani ngwumaad ngwüny, ngaa laꞌti mätï ngwuumalu ngwere?” Aar ci, “Bärï.” ");
INSERT INTO lro_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ngwuje be ci, “Gätädär ngwüꞌdïbä kuyala gidi gaama gidi bälükä ngwa je be mbuja ngwoko.” Anni ma aar gatu ngwüꞌdïbä, a ngwuum ïꞌdätï ngwonyadu ꞌdi a je ngwüꞌdïbä näcï ndi aar je oda. ");
INSERT INTO lro_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","A dooꞌra danni dati Yicu ämnï ci Butrujing, “Deleny diru!” Anni ma gu Jamaan gwani Butruj ꞌdingini ngindeng no ndi ari, “Deleny diru,” ngwape direda düngün ngwüpänï nono (ndi ari gwujalu ngwanginu ngwanu) ngwumiꞌri giyaw. ");
INSERT INTO lro_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","A ngwooꞌra ngwoko gwujani bälükä gwe aar oda ngwuuma ngwüꞌdïbä ngwe ngwonyadu ndi ari laꞌti ola ngwaalinganu kïmämü gito gito ngwaru bränü küüꞌrï tudini (100). ");
INSERT INTO lro_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Anni ma aar ꞌtüdä kïmämü, aar engga lïgä liru yirang lïmüjïnä liju gu ngwuumala a yon ji. ");
INSERT INTO lro_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","A je Yicu ci, “Ilar ngwuum ngwe ngwoko ngwanni ngwuma je umma gwenene!” ");
INSERT INTO lro_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","A Jamaan gwani Butruj allu gïbälükälä ngwülläjä ngwüꞌdïbälü kïmämü. Ngwüꞌdïbä ngwonyadu ngwuumanu ngwuru küüꞌrï tudini na ꞌdï tudini täꞌrïl (153). Ngwuum ngwe ngwee ngwonyadu no, aar ꞌti üꞌrïꞌtïyä ngwüꞌdïbänü. ");
INSERT INTO lro_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","A je Yicu ci, “Ilar ang eny.” Aaꞌti gwere ngwooꞌranu ngwüngün ädïnä ndi otacalu ndi ari, “Nga gwani yärü?” Ngindenga lïlïngïdï ndi ari nginde gwuru gwani Deleny. ");
INSERT INTO lro_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","A Yicu ila ngwape yona ngwuje ätädä ngwuje ätädä ꞌto ngwuum. ");
INSERT INTO lro_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ngwujaꞌri ngwee ngwuru ngwanni ngwuru yomonalu täꞌrïl (3) a ye Yicu ꞌtäcä ngwoꞌralu ngwüngün anaku ma gu Ngwaalu ꞌdïꞌrïyälü giyiꞌranyanu. ");
INSERT INTO lro_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Anni ma aar medaji enying, a Yicu ci Butrujing, “Gwani Jamaan gïjï gidi Yuna, nga gwämnänïny ꞌdidanu ngindenga gilee?” A Butruj ci, “Yäy gwani Deleny, nga gwülïngïdï ndi ari äny gwämnängä.” A Yicu ci, “Iya ngwangala ngwüny.” ");
INSERT INTO lro_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Oꞌre a Yicu ci, “Gwani Jamaan gïjï gidi Yuna, nga gwämnïny ꞌdidano?” Ngwuci, “Yäy gwani Deleny, nga gwülïngïdï ndi ari äny gwämnängä.” A Yicu ci, “Ombaja ngwangala ngwüny.” ");
INSERT INTO lro_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ngwoꞌre mana gomonanu ꞌtäꞌrïl ngwuci, “Gwani Jamaan gïjï gidi Yuna, nga gwämnïnye?” A Butruj ümï ligoranu ndi ari gwuma Yicu otacalu yomonanu täꞌrïl ndi ari, “Nga gwämnïnye?” Ngwuci, “Gwani Deleny, nga gwülïngïdï yiꞌralalu ꞌdar. Nga gwülïngïdï ndi ari äny gwämnängä.” A Yicu ci, “Iya ngwangala ngwüny. ");
INSERT INTO lro_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nggwa ang ondaci ꞌdidanu ndi ari, Ma ang ꞌdïꞌrälü gwuru damal, nga gwati genne gwuꞌren nga ele ngwaalu ngwaru ngwe ligor lunga. Ma be ru dïmäyïn, nga gwati gwalli guyanu aar ang dïjï giki diꞌter aar ang okta ngwaalu ngwaꞌti je ligor lunga mïnä nda gu ele.” ");
INSERT INTO lro_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yicu gwondaja ngwujaꞌri ngwee nunnu ngwinggidi yiꞌrany yanni yadi je Butruj ayi ngwuye näjï Ngwaalinga. Ngwube ci, “Gwujaniny!” ");
INSERT INTO lro_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Anni ma Butruj gwurlalu ngwengga gilo ligwujana je dooꞌra danni dati Yicu ämnï. (Dooꞌra diru ndee danni dïndrädï Yicung nono gwerre gaji ganni gijaar ge ndi eny digera de. Ngwuci, “Gwani Deleny, yärü gwuru gwanni gwada gwe gwurlanu?”) ");
INSERT INTO lro_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Anni ma Butruj engga, ngwutalu ngwari, “Gwani Deleny nda mine nginde?” ");
INSERT INTO lro_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","A Yicu ci, “Manari gwümïnïny nding jalu gwumidu ꞌdi nyi oꞌra, nga gwätï gu ange? Gwujaniny nga.” ");
INSERT INTO lro_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A ngwujaꞌri ngwee badalu ngwengganu ꞌdar ndi ari dooꞌra ndoo daꞌti da ayi. A be Yicu gwaꞌti aru nginde gwaꞌti gwa ayi. Gwaru ꞌdogo, “Manari gwümïnïny nding jalu ꞌdi nyi oꞌra, nga gwätï gu ange?” ");
INSERT INTO lro_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Dooꞌra ndoo diru ndee dondaja ngwujaꞌri ngwee ngwuru danni dullu je. A lïlïngïdï ndi ari ngwujaꞌri ngwüngün ngwätï ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yiꞌral yiꞌter yonyadu yärrï je Yicu ꞌto. Adinari yullaar je ꞌdar, ngwaalu ngwaꞌti ngwadi ji gïdïdlä ngwudi ape yitab yanni yaadi üllïnï.");
INSERT INTO lro_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mengga gwani Yabuluj, kitabanu ganni gullu nyi gwerre, nggwenggaca gu yiꞌralalu ꞌdar yanni yärrï je Yicu na yanni yenggacing je ngwüjü ꞌtuꞌtu gaji ganni gïꞌdïꞌrüng ge yiiru ye ");
INSERT INTO lro_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ꞌdi a gomon ila ganni giming ge ꞌdïꞌrï ngwele kerala. Gaji ganni gaꞌting ge na ꞌdïꞌrü, gwondacana ngwoꞌra ngwükäjäär je ngwüngün ngwanni ngwäbrüng je Lïgïꞌrïm le lanni Lijuꞌru. ");
INSERT INTO lro_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Anni ma Yicu ïyï dïrbä ngwayi ngwüdïꞌrä giyiꞌranyanu, ngwujalu ngwätï yomon küüꞌrï rom (40). Ating enggani ngwäyälü yomonanu yonyadu ndi aar lenge ꞌdidanu ndi ari gwuma ꞌdïꞌrä giyiꞌranyanu. Aar le ondaji ngwuje ondaci ngwujaꞌri ngwe ngwudi yeleny yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Gomon geꞌte anni ma aar le ji ndi eny gwüpäng, ngwuje ondaci ngwuje ci nunnu, “Aaꞌti ngaa la gatani Üräjälïmïng ngaa be dünïcï angidacing gwudi Papa gwanni gwarung gwe gwanni gwuꞌdingina gwuca je gwe. ");
INSERT INTO lro_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ndi ari Yuwana gwünyïnyü yaw ye a be yomon cong ngaa la nyïnyïnï Lïgïꞌrïm le lanni Lijuꞌru.” ");
INSERT INTO lro_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Anni ma Yicunga mbudidi ngwooꞌra ngwe ngwüngün gwüpäng, aar otacalu aar ci, “Gwani Deleny, jadu gwuru gwanni gwada gwe gwäꞌräcä Yïjïräyïl yelenya?” ");
INSERT INTO lro_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ngwuje ci, “Ngaa laꞌti ätï kaji na giyomon yanni yigeꞌta je Papa yeleny ye yüngün. ");
INSERT INTO lro_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","A be ma ji ma ara je gu Lïgïꞌrïm lanni Lijuꞌru üllänü, la je be onjaji yiimala ngaa ru lanni ladi inggidi gwani äny kündär gani Üräjälïm na Yäwüdïyä ꞌdar na Jamra ꞌdi ngaa obani ngwaalu ꞌdar gïdïdlä.” ");
INSERT INTO lro_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Anni mung ari ngwujaꞌri ngwee, ngwüꞌdïꞌrï ngwäyänü ngwegen ngwallu kerala ꞌdi ngwänï gïyïbäꞌränü ngwüꞌrïnyänälü ngwäyänü ngwegen. ");
INSERT INTO lro_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Aar ji ndi ombajidi kerala ꞌtiꞌtog anni mung ji ndi allu, puprang no a ngwüjï rom (2) ngwugenna ngwureda ngwubidu ꞌtädälü aar je ci, ");
INSERT INTO lro_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Ngwüjï ngwee ngwudi Jälïlïng, ngaa larra ngaa be dünä ngene ndi ombajidi kerala? Yicu nggwee gwanni gwuma aar ꞌdïꞌrïyï ꞌdanggalanu gwuma aar gwe ele kerala, gwa ji gwoꞌra ꞌto anaku änggädä gu gwuma ele kerala.” ");
INSERT INTO lro_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aar kwodalu aar gatana Gidotra gidi Ngwümïnïtï aar ila Üräjälïm gaꞌti ola ngwaalinganu ndi ele anaku ari gu dïmürä didi gomon giru Kwoꞌra täꞌrïl. ");
INSERT INTO lro_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Anni ma aar obana aar allu ngwuꞌdun alu nggwe kimbanu ganni gati aar gu ji. Lanni ju liru lani, Butruj na Yuwana na Yagub na Andrawuj na Bïlïpüj na Tumaj na Bartumawuj na Mätä na Yagub gïjï gidi gur gani Albayu na Jamaan gwanni gwati ligor enyanu gwani gen na Yäwüdä gïjï gidi Yagub. ");
INSERT INTO lro_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ngindenga ꞌdar loꞌrajidalu gwüpäng anaku äbräjäär gu ndi otaci Ngwaalingalu ngindenga ngwawnga le na Märïyäm nanni gwudi Yicu na ngwenggen. ");
INSERT INTO lro_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Giyomon giyoo, a Butruj ꞌdïꞌrï ngwïkïrïjïnänü, ngwa ru küüꞌrï nyärläl (120), ngwüdünälä gidiliganu ");
INSERT INTO lro_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ngwari, “Lani ngweengga, ngwujaꞌri ngwanni ngwaru ngwe gitab gwerre ngwätï ngwäyänü anaku aru gu Lïgïꞌrïm lanni Lijuꞌru ngwulemanu ngwudi Däwüd kur gani Yäwüdä gwanni gwuma ru guy gidi ngwüjï ngwanni ngwuma määtä Yicung. ");
INSERT INTO lro_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yäwüdä gwuru dooꞌra deꞌte ꞌdengganu gwacajidar le giyiiru giyee.” ");
INSERT INTO lro_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ngwube ellang giruny ngwiliny ngwe ngwanni ngwuma aar je ätädä gwani yiiru yüngün yiming ye gwurlanu Yicu gwe gwuma gu ïꞌdï ngwümïꞌrälü yïdül ye ꞌdi a ngwanginu ngwüngün ubi a ngwüw ꞌtädälü mbüny. ");
INSERT INTO lro_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","A gu ngwüjï ꞌdinginalu ꞌdar ngwudi Üräjälïmïng aar ätädä giruny nggoo ngwürïny ngwani Akildama ngwujaꞌri ngwee ngwani Yärmïyängä, ‘Giruny gidi Yïn.’) ");
INSERT INTO lro_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","No, a Butruj ari, “Yüllïnä kitabanu gidi Mäjïmür ndi ari, ‘A ngwuꞌdun ngwüngün undanu, dïjï dere daꞌti da gu janu.’ A mana ngwaalu ngwuꞌter yüllïnä ꞌto ndi ari, ‘A dïjï diꞌter mandi giyiiru yüngün.’ ");
INSERT INTO lro_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Yäy gu no, ya gu jayi ndi ari ar bupi dïjü danni dacajidar le giyiiru giyee gaji ge ꞌdar ganni gapu ge Deleny dani Yicu yiiru ꞌdengganu, ");
INSERT INTO lro_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ꞌtuꞌtu gomon ganni gïnyïnyä ge Yuwana ngwüjü ꞌdi a gaji ila ganni gima ge Yicu ꞌdïꞌrï aar nje gatani ngwallu kerala. Ndi ari dïjï deꞌte ꞌdengganu ar le ru ladi inggidi gwani ꞌdïꞌrï gwüngün.” ");
INSERT INTO lro_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","No aar apa ngwüjü rom (2), Yüjïb gwani Barjabaj (gwati aar ci ꞌto Yuctuj) na Mitiyaj. ");
INSERT INTO lro_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Aar otaci Ngwaalingalu aar ari, “Gwani Deleny, nga gwuru gwülïngïdï ligor lidi dïjï, enggaci nje dïjü ngwüjï ngwee rom (2) danni dinananga ");
INSERT INTO lro_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ndi ape yiiru giyee yidi ükäjï, yanni yima je Yäwüdä gatani gwuma ele ngwaalu ngwanni ngwädï nono.” ");
INSERT INTO lro_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Aar be gatu yuꞌru, aar ïꞌdädä ndi Mitiyaj aar ape aar gendaji ngwooꞌra ngwükäjäär je ngwuru ꞌdï na gweꞌte (11). ");
INSERT INTO lro_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Anni ma gaji ila gidi gomon gidi Yïꞌrïnyïnä yidi Uni yidi Ngwüyäwüd, ngwooꞌra ꞌdar ngwudi Yicu ngwuju aar ji gwüpäng ngwaalu ngweꞌte pu. ");
INSERT INTO lro_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Puprang no, a yal aranu kerala nono yal yidi dirun diru dudu ngwüllä ꞌdi ngwonyadi ngwuꞌdunala ngwoo ngwujaar gu ndi jalu. ");
INSERT INTO lro_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Aar engga ngwungla ngwuru nono gwele lingla lidi lïgä ngwüllä ngwubadalu ngwaci ngwüjälä ꞌdar ngwanni ngwuju ngeno. ");
INSERT INTO lro_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","A je Lïgïꞌrïm lanni Lijuꞌru onjadala ngwuje ätädä yiima aar ondaji ngwujaꞌri ngwungla ngwe ngwuꞌter. ");
INSERT INTO lro_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Giyomon giyoo Üräjälïm, Ngwüyäwüd ngwonyadu ngwanni ngwüdïnyädï Ngwaalinga ngwuju. Ngwïndï ngwaalu mbüny mbüny giyen gïdïdlä. ");
INSERT INTO lro_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Anni ma aar ꞌdingini yal giyee, A ngwüjï ngwonyadu oꞌrajidalu aar ji ꞌrïl ndi ari dïjï deꞌte deꞌte diꞌdinginu ngwujaꞌri ngwudi lingla lüngün ngwündäjïnä. ");
INSERT INTO lro_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","A je le ngwaalu elalu aar utalu aar ari, “Ngwüjï ngwee ꞌdar ngwondaju ngwäꞌtüdï ngwudi Jälïlïngo? ");
INSERT INTO lro_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Aar mine arra ꞌdar ma ar je ꞌdingini aar ondaji ngwujaꞌri ngwudi yïïlü yege ꞌdar anaku rar gu? ");
INSERT INTO lro_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Alanga liru Ngwübrïtï na Ngwumadi na Ngwulami, ngwüjï ngwati ji Mijuputumiya na ngwanni ngwati ji Yäwüdïyä na Gäbüdükïyä, na Bunduj na Ajiya, ");
INSERT INTO lro_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","na Bïrïjïyä na Bämbïlïyä na Mijir na ndi elada Lïbïyä gwe ngwaalu gito gito ngwucaar je Giruwan na ngwüjï ngwuru ngwïrnü ngwïndï Ruma, ");
INSERT INTO lro_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ngwuru Ngwüyäwüd na ngwanni ngwändï giyobo yidi Ngwüyäwüd. A gu ngwüjï janu ngwuru Ngwükïrïd na Ngwädïgü. Ngwuꞌdinginar je ngwondaju giyiima yidi Ngwaalu ngwungla ngwe ngwege.” ");
INSERT INTO lro_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Aar ji ꞌrïl a je ngwe ngwaalu elalu aar otajidalu aar ari, “Yiru ange giyee?” ");
INSERT INTO lro_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","A je be loko ondajaji ngwuꞌdera nono aar ari, “Lima ïyï diꞌrica donyadu diming je rlälïyï?” ");
INSERT INTO lro_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","A Butrujinga ꞌdïꞌrälü ngwooꞌra ngwe ngwoo ngwuru ꞌdï na gweꞌte (11), a Butruj ondajala gwulleny ngwondaji ngwari, “Lani ngweengga ngwuru Ngwüyäwüd na nga nga ꞌdar lanni lati ji Üräjälïm, gerajiiny länï ngaa je enggaci ngaa lenge ngwujaꞌri ngwee. ");
INSERT INTO lro_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ngwüjï ngwee ngwaꞌti rlälü anaku ara gu. Ngwaalu ngwona ngwuru dilu danu gaji giru tudini kwoꞌrongo (9). ");
INSERT INTO lro_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","A be yiru giyee yanni yari ye dïjïr dani Yüwïl ndi ari, ");
INSERT INTO lro_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ngwaalu ngwari nu yiru giyee yanni yadi nje ärrï giyomon gïyäꞌdï yidi gwodaning, äny gwa bäläjä ngwüjü ꞌdar Lïgïꞌrïmä nono lüny. A yïjï yalu yanni yiru ngwur na yera ya alliji yïjïrä, na ngwamal ngwalu ngwätï ngwäy ngwudi engga ngwujaꞌri, na ngwümäyïn ngwalu ngwa je ngwulingid eny. ");
INSERT INTO lro_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yäy ꞌdi ꞌto ngwïnäd ngwüny ngwanni ngwuru ngwur na ngwaw, ngwunje bäläjï Lïgïꞌrïmä nono giyomon gïyäꞌdï ngwa alliji yïjïrä. ");
INSERT INTO lro_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Äny gwa geꞌte yiꞌral yidi allalu ndïr kerala na yiꞌremna ya ji yiru ꞌter gïdïyängälü, ngwaalu ngwa ru yïn, ngwa ru lïgä na ngwa ru dïlü dipa giꞌranu. ");
INSERT INTO lro_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lingen la gwurli la ru dïrïm na düüwä da gwurli da ru yïn a ya ji giyee gwerre gwerre ꞌdi a be gomon ila nggäꞌdï gipa gidi näjï gidi Deleny. ");
INSERT INTO lro_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na dïjï danni durnidi ngwürïny ngwudi Deleny, da gïlängïdïnï.’” ");
INSERT INTO lro_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","A Butruj ari, “Gerajar ngwänï ngwüjï ngwudi Yïjïräyïl ngaa ꞌdingini ngwujaꞌri ngwee, Yicu gwudi Najrang gwuru dïjï dinggida de Ngwaalu ndi ari dükäjïng ꞌdanggalanu yiima ye na allalu ndïr na yanni yiru yiꞌremnalu ꞌter yanni yärrï je Ngwaalu ꞌdanggalanu nginde gwe, yïlïngïdä je yigoꞌro yalu. ");
INSERT INTO lro_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yicu nggwee gwügäbïcïjärä je Ngwaalu yiiru ye yanni yïlïngïdïng ye yorto ye ngwaalinga ꞌtuꞌtu gwerre, ngaa ape ngwuy ngwe ngwudi ngwüjï ngwuru Garany, ngaa pä küꞌrälä ganni gimamindanu ngaa ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","A be Ngwaalu ꞌdïꞌrïyälü giyiꞌranyanu yiima ye yüngün gwuma aar gwäꞌdälü giyeꞌrendenyanu yidi yiꞌrany ndi ari yiꞌrany yaꞌti ätï yiima ndi aar määtädälü. ");
INSERT INTO lro_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Deleny dani Däwüd dondaja Kirictu gwe kitabanu ngwari, ‘Nggwänggädï Delenya ngwäyänü ngwüny yomonalu ꞌdar. Ndi ari ngwujicinyalu kaama, nunnu aaꞌti nggwa lagadalu. ");
INSERT INTO lro_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yäy gu no nggwujayanu giligoranu lüny nyi elnge gwujayanu. Ngwangina ngwüny ꞌto ngwa jici geꞌtajing gwudi midi. ");
INSERT INTO lro_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ndi ari nga gwaꞌti gwuny gatanalu gidel didi yiꞌrany na ndi ari nga gwaꞌti gwa gäbïcï ngindeng gwunga gwanni Gwujuꞌru gwa ꞌdigiꞌri. ");
INSERT INTO lro_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nga gwuminy enggaci gay gidi midi na nga gwuny gäbïcï nggwa jayanu gwulleny ꞌdunggunga.’” ");
INSERT INTO lro_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","A Butruj ari, “Lani ngweengga, nggwa je ondaci ndi ari nggwïcïnänü ndi ari papa gwege gwani Däwüd gwuma ayi gwuma aar gatu na dimomo düngün ndo ngene ꞌdi gomon gidi gweneng. ");
INSERT INTO lro_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","A be nginde gwuru dïjïr gwülïngïdï ndi ari gwümïꞌrïcä Ngwaalu yiꞌrany ngwuci nu, gwa alliji gïjü güngün geꞌte gididuꞌrala didi yeleny. ");
INSERT INTO lro_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A Däwüd engga yiꞌral yanni yadi ele ndi ji gweere, ngwondaji ꞌdïꞌrï gwe gwudi nginde gwanni Gwubrutaar yelenya ndi ari gwaꞌti gwa aar gatanalu gidelanu didi yiꞌrany na ndi ari ngwaꞌti ngwa ꞌdigiꞌri ngwanginu ngwüngün. ");
INSERT INTO lro_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ngwaalu ngwuma ꞌdïꞌrïyï Yicung nggwee gwumidu na nyii gilee ꞌdar liru länggädï ꞌdidaning nggwee. ");
INSERT INTO lro_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Gwuma aar ꞌdïꞌrïyï gwuma aar näjï näjïng gwupa geꞌte gwalu kaama gidi Ngwaalu gwuma Papa ätädä Lïgïꞌrïmä lanni Lijuꞌru larung le lima aar nje bäläjä nono gilee länggädängää ngaa ꞌdingini gweneno. ");
INSERT INTO lro_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ndi ari Däwüd gwaꞌti ꞌdïꞌrü ngwallu kerala ngwube ru gwaru nu, ‘Deleny dica Delenya düny, Jalu ngene kaama güny ");
INSERT INTO lro_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ꞌdi ngaa gïꞌtïjï güwänälü gunga nga roꞌtalu giyoranu yunga.’ ");
INSERT INTO lro_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yäy gu no, a gu ngwüjï lenge ꞌdar ngwudi Yïjïräyïl ndi ari, Yicu nggwee gwüꞌrïnyïtängää, gwuru gwugeꞌta Ngwaalu ngwuru Deleny ngwuru gwanni Gwubrutaar yelenya.” ");
INSERT INTO lro_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Anni ma gu ngwüjï ꞌdingini ngwujaꞌri ngwee no, aar je dugi yigor aar ci Butrujing je ngwooꞌra ngwe ngwükäjäär je, “Yiru ange yanni yadi nje ärrï lani ngweengga?” ");
INSERT INTO lro_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","A je Butruj ci, “Joꞌrenyanar ara je nyïnyï ꞌdar ngwürïny ngwudi Yicu Kirictu ara je Ngwaalu düdänïjänü gwalu gwanni gwuki, la je be angidaci Lïgïꞌrïmä lanni Lijuꞌru. ");
INSERT INTO lro_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ndi ari ngwujaꞌri ngwee ngwaru ngwe Ngwaalu, ngwalu ngwuru aar ru ngwudi yïjï yalu aar ru ngwudi ngwüjï ꞌdar ngwanni ngwüꞌtüdänü Ngwaalu, ngwüjï ꞌdar ngwanni ngwa je Ngwaalu ngwege ngwuru Deleny urnidi.” ");
INSERT INTO lro_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","A je Butruj ondaci ngwujaꞌri ngwe ngwonyadu ngwuje le rimalu ngwuje päcälü, “Gïlängïdïyär yigoꞌro yalu kimaadanu nggee giki gidi dïdlä ndee.” ");
INSERT INTO lro_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ngwüjï ngwonyadu ngwanni ngwuma ämnï ngwujaꞌri ngwüngün aar je nyïnyï yaw ye ngwa ru ngwüüꞌrï täꞌrïl (3,000) aar je gendani ngwïkïrïjïn komon nggoo. ");
INSERT INTO lro_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ati aar jalu yomon ꞌdar ndi aar ꞌtäjï ngwäyänü nda je ngwooꞌra ngwükäjäär je enggaci ngwujaꞌri aar acajidi gwüpäng ndi eny na ndi acajidi ndi otaci Ngwaalingalu. ");
INSERT INTO lro_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","A yiꞌral yanni yati je ngwooꞌra ngwükäjäär je ärrï, aar je iye yedenyo, a ngwooꞌra ngwükäjäär je ape yiꞌral yidi allalu ndïr na yiꞌremna yidi yiima yipa. ");
INSERT INTO lro_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ngwïkïrïjïn ꞌdar ati aar ji gwüpäng ati aar emadi giyiꞌralanu ꞌdar gwüpäng. ");
INSERT INTO lro_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ati aar ellang ngwony ngwegen ngwanni ngwätäär je ati aar ätädä ngwengga ngwanni ngwaꞌti ätï. ");
INSERT INTO lro_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Aar äbräjï giyomonalu ꞌdar ndi oꞌrajidalu ngwämrä kobo. Ati aar acajidi gwüpäng ndi eny ngwuꞌdun ngwegen aar emadi ndi eny gwüpäng yigor ye yijayanu yiru ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ati aar ortada Ngwaalinga ati aar jayi ngwüjü ngwäy ꞌdar. Ati je Deleny gendaca ngwüjü kiꞌdoonga gegen yomon ꞌdar ngwanni ngwuma gïlängïdïnä. ");
INSERT INTO lro_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gomon geꞌte Butrujinga Yuwana gwe ländädï kobo gaji ge giru täꞌrïl (3) gidi otaci Ngwaalingalu lingen le ligwurlu. ");
INSERT INTO lro_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ngenone gïlängïr licaar Längïr lanni Lijaw, gur giju gu giru dirga anaku lïngïdäär gu, gapaar ating jalu yomon reny längïrü nono ndi geraci ngwüjü guy ngwanni ngwati ilada ngwämrä kobo. ");
INSERT INTO lro_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Anni mung engga Butrujing je Yuwana gwe liju gito ndi änï kobanu, ngwuje geraci guy nunnu aar ätä gony gere. ");
INSERT INTO lro_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","A Butruj alliji ngwäy nono ngwombaji jicom na Yuwana ꞌto. A Butruj ci, “Ombaji nje!” ");
INSERT INTO lro_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","No, ngwuje alliji ngwäy nono ngwuje ombaji, ngwugeꞌtaji ndi ari gwadi aar ätädä gony gere. ");
INSERT INTO lro_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","A be Butruj ci, “Dab na buta gwaꞌti nyi ätï, a be yanni yätï nje, ya je ätä. Ngwürïny ngwe ngwudi Yicu Kirictu gwudi Najrang, nggwang ci ꞌdïꞌrü nga ele!” ");
INSERT INTO lro_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ngwube ꞌdïꞌrïyälü gaama ge ngwudigeꞌdajala. Puprang no, a yora ji ꞌdäny ngwüꞌdïꞌrälü prüd ngwüdünädälä. ");
INSERT INTO lro_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ngwüꞌdïꞌrïꞌtälä yora ye yüngün ngwuje gagitu ngwele. Ngwuje be gwujani aar le ele aar änï ngwämrä ngwudi gobo ngwele ngwüꞌdïꞌrïꞌtälä ngwortada Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Anni ma ngwüjï ngeno engga gwïndälü ngwortada Ngwaalinga, ");
INSERT INTO lro_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","aar lenge ndi ari gur giru ganni gati jalu gïlängïr lidi gobo licaar Längïr lanni Lijaw ndi geraci ngwüjü guy, aar allalu ndïr a je le ngwaalu elalu giyiꞌral yanni yima ji ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Anni ma gur ji ndi mätïnädä ndi Butrujinga Yuwana gwe, a ngwüjï ꞌdar allalu ndïr, aar je rükädä nono ngwaalu ngwucaar je Gurd gidi Jiliman. ");
INSERT INTO lro_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Anni ma Butruj engga ngwüjü aar gu ru no, ngwuje ci, “Lani ngwüjï ngwüny ngwudi Yïjïräyïl, yiꞌral yarra giyee ma ara je allijalu ndïr? Ange gwuru nje be alliji ngwäy nono no, nono ma yiima na jayi gwärï ru gwuꞌriya dïjü nono ndee ngwele? ");
INSERT INTO lro_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ngwaalu ngwudi Äbräyïm na Ngwaalu ngwudi Ijaag na Ngwaalu ngwudi Yagub, Ngwaalu ngwudi ngwügüürnä ngwege, ngwuma näjï dïnädä düngün dani Yicu. Nginde gwanni gwuma aang määtä ngaa ätädä ngwelenya nunnu aar ꞌrinye, ngaa nyïꞌrïnï ngindeng ngwäyänü gideleny dani Bilatij anni mung ru gwading gatalu. ");
INSERT INTO lro_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ngaa lïnyïꞌrïnä ngindeng gwanni Gwujuꞌru Gwüdünälü, ngaa be bupi ara je Bilatij gätïjä guralu ganni gigeꞌta giimra. ");
INSERT INTO lro_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ngaa ꞌrinye ngindeng gwanni gwuru gay gidi midi gwuma be Ngwaalu ꞌdïꞌrïyï giyiꞌranyanu, nyii liru länggädï yiꞌral giyee. ");
INSERT INTO lro_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ämnï gwe ngwürïny ngwudi Yicu, gwuru gwuma uꞌriyi guru nono nggee gänggädängää ngaa lenge gima ojeme nono. Yiru ngwürïny ngwe ngwudi Yicu na ämnï gwe ꞌdünggüngün gwanni gwuma uꞌriyi nono, anaku änggädä gu nga nga ꞌdar. ");
INSERT INTO lro_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","A be gweneno lani ngweengga, äny gwülïngïdï ndi ari yanni yärrä je ngwelenyinga le, yärrä je gu ngaa laꞌti lïngïdï. ");
INSERT INTO lro_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","A be yiru giyee ndi ari awa Ngwaalu ngwuma ätïyï ngwujaꞌri ngwäyänü ngwondacung ngwe ngwïjïrä ꞌdar gwerre ngwari, nginde gwüngün gwanni Gwubrutaar yelenya, gwa aar ärrï yündä. ");
INSERT INTO lro_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Joꞌrenyanar be, ngaa oꞌraca Ngwaalinga nunnu ara je düdänïjänü ndi ke gwalu. Nunnu a gaji gidi obe düwä de ila Gideleny. ");
INSERT INTO lro_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Gwa je be ükäcä ngindeng gwanni Gwubrutaar yelenya gwanni gwäbräjärä je gwani Yicu. ");
INSERT INTO lro_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ndi ari gwa jalu kerala ꞌdi a gaji ila ndi ari a yiꞌral ꞌdar aar gïꞌtïnï yiyang, anaku ondaca gu Ngwaalu ngwïjïrä ngwüngün ngwanni ngwujuꞌru gwerre. ");
INSERT INTO lro_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ndi ari Müjä gwaru nu, ‘Deleny diru Ngwaalu ngwalu da je ükcä dïjïrä nono ükäjäär nyi gu, a nginde gwadi ꞌtüdä ꞌdanggalanu. Gwa aang ꞌdengenaci giyiꞌral ꞌdar yanni yadi ara je ye ci ngaa je ärrï. ");
INSERT INTO lro_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Dïjï danni daꞌti da ꞌdengenaci dïjïrä ndoo, da aar linynyi ngwüjänü ngwudi Ngwaalu.’ ");
INSERT INTO lro_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","A ngwïjïr ꞌdar ngwanni ngwuma je Ngwaalu ükäjä ngwujaꞌri ngwe, ngwätïnä Jämüwïlïngänü na lanni lima gwujana gwodan, londaja yiꞌral ye yidi yomon giyee. ");
INSERT INTO lro_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Na ngaa liru ngwuꞌrin ngwudi ngwïjïr ngaa ru ꞌto ngwuꞌrin ngwudi gekajidi gwanni gwugekajidu Ngwaalu ngwügüürnängä le ngwalu. Anaku mïꞌrïcïng gu Äbräyïmïng yiꞌrany ngwuci, ‘Gilinge ge gunga, nggwa onjaci ngwüjü ꞌdar gïdïyängälü.’ ");
INSERT INTO lro_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","A no, Ngwaalu ngwüꞌdïꞌrïyä dïnädälü düngün dani Yicu ngwükäjä gwerre gwerre ꞌdanggalu nunnu ara je onjaci gwäꞌrä gwe dïjü deꞌte deꞌte ꞌdanggalanu ndi elelle kay güngün ganni giki.” ");
INSERT INTO lro_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Butruj na Yuwana liju ndi ondaci ngwüjü kobanu anni ïndï ngwurꞌdal na Ngwüjändügï na dangida didi ngwangida ngwudi gobo. ");
INSERT INTO lro_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Aar ila likanu ndi ari Butrujinga Yuwana gwe londaci ngwüjü ndi ari ꞌdïꞌrï giyiꞌranyanu nggwo Yicu gwe. ");
INSERT INTO lro_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aar määtä Butrujing je Yuwana gwe aar je gekajalu korkon ꞌdi a bïgänü ru ndi ari ngwaalu ngwuma ru degera kaji nggoo. ");
INSERT INTO lro_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","A be ngwüjï ngwonyadu ngwanni ngwuma ꞌdingini ngwujaꞌri, aar ämnï Ngwaalu, ngwanni ngwuru ngwur, aar gendadi ꞌdi aar ru ngwüüꞌrï tudini (5,000). ");
INSERT INTO lro_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Anni ma dilu danu ru, a ngweleny na mbumbunga na ngwoorta ngwudi yobo oꞌrajidalu Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","A gu dirꞌdal danni diru giꞌra dani Anan ji na dirꞌdal dani Giyaba na Yuwana na Älïjïkändär na ꞌdar lidi gubu gidi dirꞌdal danni diru giꞌra. ");
INSERT INTO lro_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Aar apa Butrujing na Yuwana aar je dünäjï gidiliganu ꞌdenggen aar je otacalu aar je ci, “Yeleny yidi yärü na ngwürïny ngwudi yärü ngwärrä ngwe yiꞌral giyee?” ");
INSERT INTO lro_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","A Butruj ꞌdïꞌrï gwonyadu Lïgïꞌrïmälä lanni Lijuꞌru ngwuje ci nu, “Lani ngweleny na mbumbunga lidi ngwüjï, ");
INSERT INTO lro_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","manari ngaa lotaci njalu gwene gwani yiꞌral yanni yijaw yanni yiminje ärrï gidirga, nje otacalu nunnu duꞌru nono awa? ");
INSERT INTO lro_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Lïngïdär be yiꞌral giyee nga nga na ngwüjï ngwudi Yïjïräyïl ꞌdar ndi ari nyii lärrü yiꞌral giyee ngwürïny ngwe ngwudi Yicu Kirictu gwudi Najrang, gwanni gwüpädängää küꞌrälä ganni gimamindanu gwuma be Ngwaalu ꞌdïꞌrïyälü giyiꞌranyanu. Ngwürïny ngwüngün ngwuru ngwuꞌriya, guru nono nggee gïdünädälä ngwäyänü ngwalu. ");
INSERT INTO lro_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yicu gwuru gwanni gwondaja gwe gitab ndi ari, ‘Goꞌrr ganni gima aang ꞌdonyadadalu nga nga lanni lati oda, giru gima ru gidingo gidi ngwuꞌdun.’ ");
INSERT INTO lro_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Gilang gwaꞌti gïdïjï dere diꞌter ndi ari dïjï dere daꞌti gïdïdlä ꞌdar danni dapu Ngwaalu nunnu aar nje gïlängïdïyï.” ");
INSERT INTO lro_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Anni ma aar engga Butrujing gwuꞌranu na Yuwana, aar je lenge ndi ari liru ngwüjälü nyidang ngwaꞌti bebera, a je le ngwaalu elalu, aar lenge ndi ari ngwüjï ngwee ngwujaar Yicunga le. ");
INSERT INTO lro_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Aar ꞌti be lïngïdï ladi aar je ca ange ndi ari länggädï guru nggoo gima uꞌri nono gïdünäär le. ");
INSERT INTO lro_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Aar je ꞌtüyä poor ngwämrä ngwudi Ngwüyäwüd aar jalu ndi otajidalu. ");
INSERT INTO lro_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Aar ari, “Yiru ange yanni yadi aar je ärrï ngwüjü ngwee? Ndi ari ngwüjï ngwudi Üräjälïmïng ngwülïngïdï yiima ꞌdar yanni yiralu ꞌter yärräär je yaꞌti ya ar je nyïꞌrïnï. ");
INSERT INTO lro_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","A be nunnu aaꞌti ngwujaꞌri ngwee ngwa badalu a je ngwüjï ꞌdingini ngwonyadu, ar je iyiyi yedenyo ndi ari aaꞌti londaci dïjü dere ngwürïny ngwe ngwee.” ");
INSERT INTO lro_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Aar je apa aar je ondaci ndi ari aaꞌti ba be londaji ndi enggaci ngwüjü ngwürïny ngwani Yicu. ");
INSERT INTO lro_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","A je be Butruj na Yuwana ci, “Manari nga nga lïmïnü ndi ara je ꞌdengenaji nyii be ꞌdonya ngwujaꞌri ngwudi Ngwaalu, enggaci nje yiru giyene yanni yijayana ꞌdanggalu? ");
INSERT INTO lro_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nyii laꞌti la gwugwundi nyii londaji ngwujaꞌri ngwee ngwanni ngwänggädï nje nje ꞌdingini.” ");
INSERT INTO lro_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Oꞌre aar je iyiyi yedenyo aar je be gatalu. Aar ꞌti mbuji gay gadi aar je ge reraji ndi ari lima je yedeny eny ngwüjï ndi ari ngwuma jayanu aar ortada Ngwaalinga gwani yiima yanni yima ji. ");
INSERT INTO lro_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ndi ari gur nggoo gäpädäär yiima giyee ngwuꞌri nono, gümä gonyadana ngwüdläyü küüꞌrï rom (40). ");
INSERT INTO lro_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Anni ma aar gata Butrujingalu na Yuwana, aar kwoyalu aar oꞌraci ngwenggen aar je ondaci ngwujaꞌri ꞌdar ngwanni ngwuca je ngwe ngwurꞌdal ngwanni ngwuru ngweleny na mbumbunga. ");
INSERT INTO lro_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Anni ma aar ꞌdingini ngwujaꞌri ngwee, aar alliji dula aar otaci Ngwaalingalu aar ari, “Gwani Deleny nga gwanni gwugeꞌta gere na dïyäng na yaw na ꞌdar yanni giyo gu. ");
INSERT INTO lro_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nga gwondaja Lïgïꞌrïm le lanni Lijuꞌru lingla le lidi dïgüürnä därï dani Däwüd diru dïnäd dunga, ngwari, ‘Ngwüjï ngwarra ngwudi yen ma aar ꞌdïꞌrï güündä? Na ngwüjï ngwarra ma aar ïräjï ngwäy giyiꞌral yiru ꞌtur? ");
INSERT INTO lro_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ngweleny ngwarra ngwudi dïdlä ma aar ji mama na larra lanni lati ruyi yelenya ma aar oꞌrajidalu aar ïnïjï Delenya aar ïnïjï ngindeng gwüngün gwanni Gwubrutaar yelenya.’ ");
INSERT INTO lro_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ꞌDidanu Yïrüdïj na Bilatij Bündï lirucidu ngwüjïngä le ngwuru Garany na ngwüjï ngwudi Yïjïräyïl kündär nggee aar ïnïjï dïnädä dunga danni Dijuꞌru dani Yicu nginde gwanni Gwubrutanga yelenya. ");
INSERT INTO lro_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yima aar je ärrï ꞌdar yanni yïmädïnïyä je nga je geꞌte guy ge gunga nunnu aar gu ru anaku bupa gu. ");
INSERT INTO lro_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Gwani Deleny, ila be nga engga iyiying yedenyo gwegen nje gäbïcï liru ngwïnäd ngwunga nyii ꞌranu ndi ondaji ngwujaꞌri ngwunga. ");
INSERT INTO lro_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Dingada guy gunga nga uꞌriyi ngwüjü nono nga ape yiima yiru yiꞌremnalu ꞌter nga je ärrï yidi allalu ndïr ngwürïny ngwe ngwudi dïnäd dunga danni Dijuꞌru dani Yicu.” ");
INSERT INTO lro_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Anni ma aar otaci Ngwaalingalu, a ngwaalu ngwanni ngwoꞌrajidaar gwalu lagadalu. A je Lïgïꞌrïm lanni Lijuꞌru onjajala aar ꞌranu aar ondaji ngwujaꞌri ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","A ngwïkïrïjïn ꞌdar ru yigor yeꞌte pu aar ru yaꞌranya yeꞌte pu. Ati ꞌti dïjï dere aru ngwong ngwüngün ngwuru ngwee ngwanni ngwätïng je ati aar be emadi ngwong ꞌdar gwüpäng. ");
INSERT INTO lro_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","A ngwooꞌra ngwükäjäär je ätï yiima yipa ndi enggaci ngwüjü ꞌdïꞌrï gwe giyiꞌranyanu gwudi Deleny dani Yicu. A je gu yïmïꞌrü yidi Ngwaalu ji ꞌdar yïrälü. ");
INSERT INTO lro_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","A gu ꞌti dïjï dere janu dinyangiralu. Ndi ari ngindenga ꞌdar lanni lätï dïyängü aar ätï ngwuꞌduna, ngwati aar je ellang aar apa ngwilinya ");
INSERT INTO lro_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aar je ätädä ngwoꞌra ngwükäjäär je aar je gegenaci ngwüjü ngwanni ngwunyangiralu. ");
INSERT INTO lro_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na gur geꞌte gani Yüjïb gwati ngwooꞌra ngwükäjäär je ci Birnaba yani ndi ari gwati orꞌtemaji ngwüjü, gwuru Dillawi gwülïngïnä Gabruj. ");
INSERT INTO lro_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nginde gwätï dïyängü didi kwoy ngwape ngwellang ngwapa ngwilinya ngwuje ätädä ngwoꞌra ngwükäjäär je. ");
INSERT INTO lro_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","A be gur gani Ananiya daw de düngün dani Jäbïrä ellang ꞌto dïyängü degen. ");
INSERT INTO lro_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ngwube gwäꞌrïnï ngwilinya ngwoko a gu daw düngün lenge, ngwuje be apa ngwoo ngwïꞌdälü ngwuje ätädä ngwoꞌra ngwükäjäär je. ");
INSERT INTO lro_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Anni ma Ananiya äpïjï ngwooꞌra ngwükäjäär je ngwilinya, a Butruj ci, “Ananiya, nga gwarra nga be gäbïcï dijegoꞌro ngwonyadi ligorala lunga no ꞌdi nga ïdäjï Lïgïꞌrïmänü lanni Lijuꞌru änïjï gwe ngwilinyalu ngwoko ngwudi dïyäng danni dïllängä? ");
INSERT INTO lro_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Dalu däꞌtüdï gwele gaji ganni gaꞌta ge na ïlle? Na anni mung ïllïnï, ngwiliny ngwaꞌti ju kuyanu galo? Yiru ange yanni yima gäbïcï ligor lunga nga je be ärrï giyee yiru gu no? Yaꞌti ani ndi ari nga gwuma ïdäjï ngwüjänü, a be Ngwaalu ru ngwuma je ïdäjänü.” ");
INSERT INTO lro_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anni ma gu Ananiya ꞌdingini no, ngwïꞌdï ngwayi. Anni ma gu ngwüjï ꞌdar ꞌdingini yiꞌrany ye yüngün, a je yedeny eny. ");
INSERT INTO lro_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","A ngwamal ngwoko ändä aar pädä ngwureda nono aar ape aar gwe ele ndi gata. ");
INSERT INTO lro_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Anni ma aar jalu ꞌdi a gaji ru täꞌrïl (3), a daw düngün ändä, nginde yaꞌting je lïngïdï yanni yima mbuji duru düngün. ");
INSERT INTO lro_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","A Butruj otacalu ngwuci, “Enggaciny ngwilinya, ngwuru ngwee ngwudi dïyäng danni dïllängää dur de dunga dani Ananiya?” Ngwuci, “Yäy ngwuru.” ");
INSERT INTO lro_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","A Butruj ci, “Ngaa larra dur de dunga ngaa be gekajidi ndi ïdäjï Lïgïꞌrïmänü lanni Lijuꞌru lidi Deleny? Änggädï! Lanni lima gata duru dunga lima obana gïlängïr, la ang apalu ꞌto la gwe ele.” ");
INSERT INTO lro_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","No ngwïꞌdï giyoranu yidi Butruj ngwayi. A ngwamal ändä aar apalu aar gwe ele aar je gatajidalu dur de düngün. ");
INSERT INTO lro_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","A yedeny eny ngwïkïrïjïnä ꞌdar kiꞌdoonga na ngwüjï ꞌdar ngwanni ngwuma ꞌdingini yiꞌral ye giyee. ");
INSERT INTO lro_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ngwooꞌra ngwükäjäär je ngwapu yiꞌremna yidi yiima yonyadanu na yidi allalu ndïr ngwüjänü. Na ngwïkïrïjïn ꞌdar ngwati oꞌrajidalu kurdanu gidi Jiliman. ");
INSERT INTO lro_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Aaꞌti dïjï dere ju dïndï poor ndi ari ngwuje gu änänü, ati je ngwüjï näjï gwulleny. ");
INSERT INTO lro_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","A ngwur na ngwaw ngwonyadu ämnï Gideleny dani Yicu aar gendadi yiꞌra yegen. ");
INSERT INTO lro_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ati ngwüjï apa ngwüjü ngwanni ngwümä aar ngwe ꞌtüdä ngwayalu aar je ndriyalu gïyïlälälü nunnu ma Butruj millida manari dïꞌrïmbïl düngün dima ele dïjü nono, ngwuꞌri nono. ");
INSERT INTO lro_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ngwüjï ngwonyadu ngwanni ngwati ji gïyündär yanni yijacidaralu Üräjälïm gwe aar apa ngwüjü ngwümä na ngwanni ngwärrï je ngwüꞌrïllä yündä, ꞌdar ati aar uꞌri nono. ");
INSERT INTO lro_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","A dirꞌdal danni diru giꞌra ke yiꞌrinya na gimaad güngün kiꞌdu gidi Ngwüjändügï. ");
INSERT INTO lro_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Aar määtä ngwoꞌra ngwükäjäär je aar je geꞌte gorkon gidi ngwüjï. ");
INSERT INTO lro_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","A be dilunga ndoo a gïꞌrr gidi Deleny ila ngwïgïtï längïrü lidi gorkon ngwuje ꞌtüyä poor ngwuje ci, ");
INSERT INTO lro_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ïndär kobanu ngaa ondaci ngwüjü ngwujaꞌri ngwe ꞌdar ngwudi midi gwanni gwuyang.” ");
INSERT INTO lro_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aar ꞌdengenaci ngwujaꞌri ngwaru ngwe gïꞌrr aar ꞌdïꞌrï ꞌtuꞌtu dilu danu aar ele aar änï ngwämrä ngwudi gobo aar enggaci ngwüjü ngwujaꞌri. Anni ma dirꞌdal danni diru giꞌra gimaad ge güngün obana, aar urnidi ngwüjü gwüpäng ngwudi ngwämrä ngwudi Ngwüyäwüd, oꞌrajidalu gwudi mbumbunga lanni liru yiꞌra yidi Yïjïräyïl. Aar ükäjïdï ngwooꞌra ngwükäjäär je korkon aar ngwe ila. ");
INSERT INTO lro_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","A be anni ma ngwangida obani korkon, aar je ꞌti mbuju ngenone. Aar kwodalu aar je ondaci aar je ci, ");
INSERT INTO lro_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Änyängä limbuja gorkon gïlängïtïnä mama ꞌdar na ngwangida ngwüdünü ngwängïr. A be anni minyii ïgïtälü, nyii ꞌti mbuju dïjü dere gïdrü.” ");
INSERT INTO lro_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Anni ma gu gur ganni giru giꞌra gidi ngwangida ngwudi gobo na ngwurꞌdal ngwanni ngwuru ngweleny ꞌdingini ngwujaꞌri ngwee, a je le ngwaalu elalu aar ari, “Yiru ange yima ji?” ");
INSERT INTO lro_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","A dïjï deꞌte ila ngwuje ci, “Ngwüjï ngwele ngwugeꞌta je korkon, ngwo ndi dünälä ngwämrä ngwudi gobo ndi enggaci ngwüjü.” ");
INSERT INTO lro_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","A dangida danni diru giꞌra ele ngwooꞌra ngwe ngwüngün aar je apa minyol ndi ari lïtï je yedeny nda je ngwüjï aca yoꞌrr ye. ");
INSERT INTO lro_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Anni ma aar je änïjï ngwämrä ngwudi Ngwüyäwüd, a je dirꞌdal danni diru giꞌra otacalu ngwuje ci, ");
INSERT INTO lro_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Lica je aaꞌti ngaa linggidi ngwürïny ngwee, ngaa lima be bädïyï ngwujaꞌralu ngwee pad Üräjälïm ngaa be ari ngaa linje üpïyï yiꞌrany yidi gur nggee.” ");
INSERT INTO lro_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","A je be Butrujinga ngwooꞌra ngwe ngwükäjäär je ci, “Yätänä ngwäyänü ndi nyii ꞌdengenaci Ngwaalinga ndi ari nyii ꞌdengenaci dïjü dümnä. ");
INSERT INTO lro_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ngwaalu ngwudi ngwügüürnä ngwege ngwuma ꞌdïꞌrïyï Yicungalu giyiꞌranyanu gwanni gwüpädängää küꞌrï ganni gimamindanu ngaa ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Gwuma be Ngwaalu alliji gwuming geꞌtalu kaama güngün, ngwuru Deleny ngwuru Gilang, nginde gwe, ngwüjï ngwege ngwudi Yïjïräyïl ma aar joꞌrenyana, ngwa je Ngwaalu düdïnïjänü ndi ke gwegen. ");
INSERT INTO lro_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Änyängä liru linggida ngwujaꞌri ngwe ngwee na ꞌto a ngwe Lïgïꞌrïm lanni Lijuꞌru inggidi lanni lima Ngwaalu ätädä ngwüjü ngwanni ngwuꞌdengenaca.” ");
INSERT INTO lro_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Anni ma gu ngweleny ngwudi ngwämrä ꞌdingini ngwujaꞌri ngwee, a je güündä ape aar bupi ndi ꞌrinye ngwoꞌra ngwükäjäär je. ");
INSERT INTO lro_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","A be gur gegen gani Gämläyïl giru Dïbärrïjï ngwuru doorta didi yobo gati ngwüjï denya, ngwüdünälä ngwämrä ngwudi Ngwüyäwüd ngwari aar ꞌtüyä ngwoꞌra ngwükäjäär je poor gwooko ꞌdogo. ");
INSERT INTO lro_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ngwube ci ngwelenya ngwämrä nu, “Lani ngwüjï ngwüny ngwudi Yïjïräyïl, arnganar giyiꞌral giyee yigeꞌta je ndi ärrï ngwüjï ngwee. ");
INSERT INTO lro_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ndi ari gaji gaꞌti olanu gima ele, gur gani Taduj gïꞌdïꞌrü ngwari gipa a ngwüjï gwuji ngwaru küüꞌrï tudini kwoꞌrongo (400). Gima aar be ꞌrinye ngwüjï ngwuma badalu ꞌdar ngwanni ngwugwujana ngwujaꞌri ngwegen ngwuma dudi. ");
INSERT INTO lro_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","A be oꞌre a Yäwüdä gwudi Jälïlïng ꞌdïꞌrä gaji gïdüꞌrädäär ge ngwüjü a ngwüjü ngwonyadu aw giyora, oꞌre aar ꞌrinye ngindeng ngwüjï ngwüngün ngwuma badi. ");
INSERT INTO lro_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yäy gu no, giyiꞌral giyee nggwa je ola ndi ari oꞌraralu ngwüjï ngwee, gäbïcär je, manari yaꞌrany giyee na yiꞌral yegen giyee yärräär je yidi yigoꞌro yegen yiru, yaꞌti ya ele gweere. ");
INSERT INTO lro_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma be ari yïndï Ngwaalu, ꞌdidanu yaꞌti ya je dami, ya be ru ndi ari ngaa lidugudu Ngwaalinga le.” ");
INSERT INTO lro_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","A ngweleny ngwudi ngwämrä ꞌdengenaci olang gwüngün, aar urnida ngwoꞌra ngwükäjäär je aar je pï ngwacal ngwe aar je ꞌtücï ngwäyänü aar je ci aaꞌti londaci ngwüjü mana ngwürïny ngwe ngwudi Yicu. Aar je be gatalu. ");
INSERT INTO lro_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aar ꞌtüdä ngwämrä ngwudi Ngwüyäwüd lijayanu, ndi ari lima je yïrgïnä mbuji yädï je ngwäy gwani Yicu. ");
INSERT INTO lro_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ngindenga giyomon ꞌdar ati aar ji kobo na ati aar ele ngwuꞌdun ngwuꞌdun ndi enggaci ngwüjü aar je ondaci ndi ari Yicu gwuru gwanni Gwubrutaar yelenya. Aar ꞌti ju yere yanni yadi je dünäjï. ");
INSERT INTO lro_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Giyomon giyoo, ati ngwïkïrïjïn gendada ngwanni ngwuma ämnï ndi Yicu. A be ngwïkïrïjïn ngwanni ngwuru Ngwüyäwüd ngwïndï giyen poor, aar ꞌdïꞌrï aar äbïngïnï giyinenanu gwani ngwïkïrïjïnä ngwanni ngwuru Ngwüyäwüd ꞌdunu ndi ari lati ïꞌdädänü ngwedel ngwe ngwegen ndi aar je gegenaci ngwony ngwudi eny ngwanni ngwati aar je gigini yomon reny. ");
INSERT INTO lro_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","A ngwooꞌra ngwükäjäär je ngwuru ꞌdï na rom (12) urnidi ngwïkïrïjïnä ꞌdar gwüpäng aar je ci, “Yaꞌti ya gu jayi ndi ari nyii ïꞌdädänü yiiru ye ndi ondaci ngwüjü ngwujaꞌri ngwudi Ngwaalu nyii ape yiiru yidi eny. ");
INSERT INTO lro_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Lani ngweengga, äbrär ngwüjü kwoꞌra täꞌrïl (7) ꞌdanggalanu ngwulinginna ngwonyadu Lïgïꞌrïmälä lanni Lijuꞌru aar bebere, nje geꞌte aar ape yiiru giyee. ");
INSERT INTO lro_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nyii be arngani ndi otaci Ngwaalingalu nyii ape yiiru ndi ondaci ngwüjü ngwujaꞌri ngwudi Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","A ngwujaꞌri ngwee gäbïcï ngwïkïrïjïnä ꞌdar aar jayanu, aar äbrï guru gani Ijitabanuj gwätï ämnïng Ngwaalu gwupa gwonyadi Lïgïꞌrïmälä lanni Lijuꞌru. Ngindenga ngwooꞌra ngwe ngwani Bïlïpüj na Brukuruj na Nekonor na Temon na Barmanaj na Nekola gwudi Andakiyang gwanni gwändï giyobo yidi Ngwüyäwüd. ");
INSERT INTO lro_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Aar apa ngwüjü ngwee kwoꞌra täꞌrïl (7) aar je äpïjä ngwoꞌra ngwükäjäär je aar je ätä guy aar abingaci Ngwaalu gwani ngindenga. ");
INSERT INTO lro_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","A ngwujaꞌri ngwudi Ngwaalu badalu ꞌdar, a ngwïkïrïjïn gendada ngwonyadu Üräjälïm a ngwurꞌdal ngwonyadu ämnï ndi Yicu. ");
INSERT INTO lro_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ijitabanuj gwuru dïjï donjaja Ngwaalu yïmïꞌränü na yiima yüngün ating ärrï yiꞌral yidi allalu ndïr na yiꞌremna yidi yiima yipa ngwüjänü. ");
INSERT INTO lro_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","A be Ngwüyäwüd ngwudi Giruwaning na ngwudi Ïjïkändärïyäng na ꞌto ngwudi ngwaalu ngwani Kïlïkïyä na Ajiya, ngwuru ngwudi Ngwämrä ngwudi Gätïnï Linginalu anaku ati aar je gu ci. Aar be ꞌdonya ngwujaꞌri ngwudi Ijitabanuj aar le garnati. ");
INSERT INTO lro_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Aar ꞌti be burna ndi dami Ijitabanujing ndi ari nginde gwondaja yiima ye yidi bebere gwudi Lïgïꞌrïm lanni Lijuꞌru lätädï Ngwaalu ndi ondaji. ");
INSERT INTO lro_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Aar be änïjï ngwüjü ngwoko bartad nono nyïm nunnu aar ari, “Änyängä liꞌdingina Ijitabanujing ngwaru ngwulem Giyobo yidi Müjä na Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yiru giyee yanni yima je gäbïcï aar gwogaji ngwüjü na mbumbunga na ngwoorta ngwudi yobo aar gwurla Ijitabanujing nono aar määtä aar gwe ele Ngwämrä ngwudi Ngwüyäwüd. ");
INSERT INTO lro_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Aar apa ngwuꞌduru aar üꞌrïdä yiꞌduru nono aar ari, “Gur nggee gaꞌti dünäjä ngwujaꞌri ndi ari ngwulem gwani gobo nggee gijuꞌru na gwani yobo. ");
INSERT INTO lro_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ndi ari gwuꞌdinginiiny gwaru Yicu gwudi Najrang gwa pä gobalu mbüny gwa gwürlï dïmürälü dïgätïjänär nje Müjä.” ");
INSERT INTO lro_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","A ngwüjï ꞌdar ngwanni ngwuju ngwämrä ngwudi Ngwüyäwüd ꞌdïꞌrïyï ngwäy aar ombaji Ijitabanujing ngwugwurli ngwuru ngwäyänü nono gïꞌrr. ");
INSERT INTO lro_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","A be dirꞌdal danni diru giꞌra otaci Ijitabanujingalu ngwuci, “Ngwujaꞌri ngwee ngwaru ngwe ngwüjï ngwätï ngwäyäno?” ");
INSERT INTO lro_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","A je Ijitabanuj ci, “Lani ngweengga na papanga, gerajar ngwänï ngaa ꞌdingini! Ngwaalu ngwege ngwanni ngwünäjïnä ngwüꞌtäcä dïgürnälü dege dani Äbräyïm gaji ganni gijung ge na ngwaalu ngwani Mijuputumiya, gwerre gwaꞌtina ïndï ndi ji kündär gani Araan. ");
INSERT INTO lro_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","A Ngwaalu ci, ‘Gatana geno gunga na ngwüjü ngwunga, nga ele ngwaalu ngwanni ngwada je enggaci.’ ");
INSERT INTO lro_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","No, a Äbräyïm ꞌdïꞌrï ngwugatani geno gidi Ngwukaldan ngwele ngwuji Araan. Anni ma papa gwüngün ayi, a Ngwaalu apa ngenone ngwila ngwuji ngwaalu ngwee ngwujaa gu gweneno. ");
INSERT INTO lro_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ngwaalu ngwuma ꞌti ätädï Äbräyïmïng ngwaalinga yuꞌrina ngwere ngene, ꞌdi ngwaalu ngwere nggu jalu. A be Ngwaalu mïꞌrïcï yiꞌrany ndi ari ngwung je ätädä ngindeng na yïjü yüngün gwodan, a be Äbräyïm kaji nggoo gwaꞌti gu na ätï gïjälü gere. ");
INSERT INTO lro_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ngwujaꞌri ngwuru ngwee ngwanni ngwondaca ngwe Ngwaalu Äbräyïmïng ndi ari, ‘Ngwügüürnä ngwunga ngwa ji ngwa ru ngwïrnü ken gidi ngwüjï ngwuꞌter ngwa aar je ruji ngwïnäd ngwa aar je ärrï yïrgïnä ngenone ngwüdläyü küüꞌrï tudini kwoꞌrongo (400). ");
INSERT INTO lro_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","A be äny gwa reraji ngwüjü ngwoo ngwanni ngwärrï je yïnädä linje be ꞌtüyä ken nggoo aar nyi äpïjï yobo ngwaalu ngwee.’ ");
INSERT INTO lro_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","A be Ngwaalu ätädä Äbräyïmïng gekajiding gwudi üꞌrïdänï a gwe Äbräyïm üꞌrïdä gïjü güngün gani Ijaag anni ma aar linge ngwätï yomon ꞌdübä (8). Gwodan aji a Ijaag üꞌrïdä gïjü güngün gani Yagub, aji ꞌto a Yagub üꞌrïꞌtädä yïjü yüngün ꞌdï na rom (12) giyoo yima ru ngwügüürnä ngwege. ");
INSERT INTO lro_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ngwügüürnä gwege ngwee ngwuru ngwüꞌdüny ndi Yüjïb aar ape aar ellada ngwüjü yïnädä ken gani Mijir. A be Ngwaalu ru ngwuma gu geꞌte guyala. ");
INSERT INTO lro_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ngwüꞌtïyï giyiꞌralanu ꞌdar yanni yiki, ngwätädä bebereng ngwügäbïcï Browoning gwudi Mijiring ngwujayi ngwäy ngwugeꞌte ngwümäätä yelenya Mijir na ngwümäätä ngwuꞌduna ngwudi yeleny yidi Browon ꞌdar. ");
INSERT INTO lro_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","A be aji a ngwamu määtä ngwaalinga ꞌdar ngenone Mijir na ngwaalu ngwani Kanaan a ngwamu eny ngwüjü gwulleny. Aaꞌti ngwügüürnä ngwege mbuju ngwony ngwudi eny. ");
INSERT INTO lro_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","A be anni ma Yagub ꞌdingini ndi ari yon giyo ngenone Mijir, ngwükäjï yïjü yüngün yiru ngwügüürnä ngwege aar ele ngenone yïrnü. ");
INSERT INTO lro_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Anni ma aar kwoyalu gomon gidi gwodaning, a je Yüjïb enggaci ligoꞌro lüngün ndi ari gwenggen gwegen gwuru, a Browon ꞌdingina ngwüjï ngwe ngwudi Yüjïb. ");
INSERT INTO lro_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ngwükäcï Yüjïbïng ngwükäjïdï ndi papa gwüngün gwani Yagub na ngwüjï ꞌdar ngwudi gubu güngün ngwuru ꞌdï kwoꞌra täꞌrïl na tudini (75). ");
INSERT INTO lro_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","A Yagubinga yïjï ye yüngün ꞌdïꞌrä aar ila Mijir aar gu ji ngenone ꞌdi a gu Yagub ayi ngwügüürnängä le ngwege. ");
INSERT INTO lro_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Aar je apa aar le ila ngwaalu ngwani Jikim aar je gatu gidimomo gïdïyäng danni dïllädï Äbräyïm yïjü yidi gur gani Amur ngwiliny ngwe ngwaalu ngwani Jikim. ");
INSERT INTO lro_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Anni ma gaji ji ndi ila gito ganni gadi ge ngwujaꞌri ji ngwanni ngwuca ngwe Ngwaalu Äbräyïmïng, gaji nggoo a ngwüjï ngwege lingadi aar gendadi aar onyadi Mijir. ");
INSERT INTO lro_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","A be aji a deleny diru ꞌter ape yelenya Mijir daꞌti lïngïdädï Yüjïb gwe yorto ye ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ngwugwurlanu ngwüjï ngwe ngwege ngwuje ärrï yïrgïnä ngwuje übïnälü aar gatani yïjälü yegen mbüny yïlïngïnä girem nunnu aar ayi. ");
INSERT INTO lro_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Gaji nggoo aar gu lingeta Müjäng gwujaw yiꞌremna. Aar ombaji ngwujalu ngwüüwäyü täꞌrïl (3) aar änïjälü ꞌdunu ndi mbumbu gwüngün. ");
INSERT INTO lro_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","A be anni ma ngwüjï ngwüngün ape aar gatanalu poor, a gera gidi Browon mbuji, ngwape ngwüꞌrünï ngwuruji gïjï güngün. ");
INSERT INTO lro_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Aar enggaci Müjäng ꞌdi ngwubebere ngwujaꞌri ꞌdar ngwudi Mijiring ngwuru dïjï dojema ngwujaꞌri na giyiiru yüngün. ");
INSERT INTO lro_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Anni ma Müjä ätï ngwüdläyü küüꞌrï rom (40), ngwüꞌdïꞌrï ngwari gwadi ele ndi ombaja ngwüjü ngwüngün ngwuru Yïjïräyïl. ");
INSERT INTO lro_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ngwube mbuji gur giru Dimijir ndi pï guru geꞌte giru Dïyïjïräyïl ngwube ruci ngwüꞌrïnyïjï Dimijira. ");
INSERT INTO lro_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","A Müjä ji ndi geꞌtaji ngwüjï ngwüngün ngwa lenge ndi ari gwapu gwe Ngwaalu yiiru nunnu ngwuje gataji düwä. Aaꞌti be ngwüjï lïngïdï yiꞌral yorto ye ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Bïgänü a Müjä mbuji ngwüjü rom (2) ngwuru Yïjïräyïl ndi pidi. Ngwari ngwading je gwäꞌräjïdï ngwuje ci, ‘Ngaa liru yengga ange gwuru ngaa be pidi?’ ");
INSERT INTO lro_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","A be gur ganni gïpïdï gwenggen ngwudinga Müjäng gay geꞌte ngwuci, ‘Yärü gwanni gwugeꞌtanga nga ru deleny därï ndi nje pïcï yelenya. ");
INSERT INTO lro_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nga gwümïnä ndi nyi ꞌrinye anaku ꞌrïnyïtä gu Dimijira lungge?’ ");
INSERT INTO lro_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Anni ma gu Müjä ꞌdingini no, ngwabri ngwugatani Mijiring ngwele ngwaalu ngwani Midiyan ngwuji yïrnü ngenone ꞌdi nggu lingeta yïjü rom (2). ");
INSERT INTO lro_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Anni mung jalu ngenone ꞌdi ngwätï ngwüdläyü küüꞌrï rom (40), a gïꞌrr ꞌtäcälü ngwengga lingla lidi lïgä luꞌdu gidaꞌri gïtäny gito gito Ken gani Jïnä. ");
INSERT INTO lro_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Anni ma Müjä engga yiꞌral giyee no, ngwudibi giyiꞌremna giyoo. Anni mung ꞌdongga gito nunnu ngwombajidi mama, ngwuꞌdingini a Deleny diru Ngwaalu ondaca aar ci, ");
INSERT INTO lro_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Äny gwuru Ngwaalu ngwudi ngwügüürnä ngwunga, Ngwaalu ngwudi Äbräyïm, Ijaag na Yagub.’ A Müjä didiꞌri nono a yedeny eny ndi ombaji daaꞌri. ");
INSERT INTO lro_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","A Deleny ci, ‘Gwällädï ngwüdänälü giyora ndi ari ngwaalu ngwoo ngwüdünädä gu ngwujuꞌru. ");
INSERT INTO lro_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Äny nggwänggädï yïrgïnä yanni yärrïnä je ngwüjï ngwüny Mijir, äny gwuma ꞌdingina ärïnïng gwegen nyi be üllädä ndi nje gataji düwä, ila nga ükäjï gweneno nga oꞌre Mijir.’ ");
INSERT INTO lro_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Müjä gwuru nggwee gweꞌte gweꞌte gwanni gwuꞌdonya ngwüjï ngwudi Yïjïräyïl aar ci, ‘Yärü gwuru gwanni gwurujanga deleny därï ndi nje pïcï yelenya?’ Gwuru gwurinda Ngwaalu gïꞌrr ge ganni giju gidaꞌri ndoo duꞌdu ngwükäjï nunnu ngwuru deleny degen ngwuje üꞌrälü. ");
INSERT INTO lro_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ngwuje ꞌtüyä Mijir geꞌte gwe yiꞌral yidi allalu ndïr na yiꞌremna yidi yiima ken gani Mijir ngwe üꞌrïdä Bar Alamring aar ngwe ji ngwüdläyü küüꞌrï rom (40) gïtäny. ");
INSERT INTO lro_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Müjä gwuru gwanni gwondaca ngwüjü ngwudi Yïjïräyïl ngwuje ci, ‘Ngwaalu ngwa ji ngwa je ükäcä dïjïrä deꞌte anaku ükäjäär nyi gu ꞌdanggalanu.’ ");
INSERT INTO lro_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","A Müjä nggwee gwuru gwujaar ngwüjü ngwe gïtäny ngwuru dartan didi gïꞌrr ganni gondacu Kenala gani Jïnä na didi ngwügüürnä ngwege. Aar ätädä ngwujaꞌri ngwee ngwudi midi ngwuje apa aar nje enggaci. ");
INSERT INTO lro_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","A be ngwügüürnä ngwege ꞌdonya ndi ꞌdengenaci ngwujaꞌri ngwudi Müjä aar je obe gora ge aar oꞌre yigor ye yegen aar je gwäꞌräjï Mijir. ");
INSERT INTO lro_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aar ci Aruuning, ‘Gïꞌtïjï nje ngwaalinga aar nje üktïnï. A be aꞌri nggwee gwani Müjä, gwuminje ꞌtüyä Mijir, gwaꞌti ar gwe lïngïdï yorto ye ngwaalinga yiru ange yima mbuji.’ ");
INSERT INTO lro_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kaji nggoo aar gaꞌriji giꞌremna giru dab giru nono gindri aar ruji ngwaalu ngwegen aar rcïjï aar mïꞌrïnï nono aar äpïjï gony yïꞌrïnyïnä gigeꞌtaar ngwuy ngwe ngwegen. ");
INSERT INTO lro_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","A je be Ngwaalu gwürläcï luꞌra ngwuje gäbïcï aar ele ndi äpïjï yurrumu yobo yidi geralang anaku üllïnäär gu kitabanu gidi ngwïjïr ndi ari, ‘Ngwüjï ngwudi Yïjïräyïl, ngaa lïrcïjïny ngaa mïꞌrïnï nono ngwüdläyü küüꞌrï rom (40) gïtänye? ");
INSERT INTO lro_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ngaa be ru manni lanni lüpïnänä gäꞌtä gidi bayil gwani Malag na guurrum gidi bayil gwani Raban. Yiꞌremna yanni yigeꞌta je ngaa je äpïjï yobo. Yäy gu no nggwa je gäbïcïjï güwänü galu ga je ape ngaa la ele ken giꞌter’ gweere Babil. ");
INSERT INTO lro_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Anni ju ngwügüürnä ngwege gïtäny lapana Gäꞌtä gidi gekajidi gijaar ge.Gïpädï Müjä ngwuru nono ganni gänggädïng genggaca Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Anni ma aar ape, a be aji a ngwügüürnä ngwege apana aar ge ila Kanaan a je Jäjïwä ruya anni ma je Ngwaalu lïnynyïjï ngwüjü ngwudi Kanaaning aar määtä geno. A gu Gäꞌtä ji Kanaan ꞌdi a gaji ila ganni gima ge deleny dani Däwüd ape yelenya. ");
INSERT INTO lro_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","A Däwüd jayi Ngwaalinga ngwäy, ngwube utalu ndi ari aading odaci Ngwaalinga ngwudi Yagub ngwuꞌduna. ");
INSERT INTO lro_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","A be aji a Jiliman ru gwanni gwuma odaci ngwuꞌduna. ");
INSERT INTO lro_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","A be Ngwaalu ngwupa ngwati ꞌti ju ngwuꞌdunanu ngwanni ngwodana ngwuy ngwe ngwudi dïjï dümnä. Anaku aru gu dïjïr ndi ari Ngwaalu ngwari, ");
INSERT INTO lro_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Gere giru ngwaalu ngwudi diduꞌri didi yeleny düny, na dïyäng diru ngwaalu ngwati nyi gu geꞌte yoralu yüny. A Deleny ari, Ngwuꞌdun ngwuru ange ngwanni ngwadi nje odaci? Na ngwaalu ngwuru ngwo ne ngwanni ngwadi nyi gu jalu nyi obe düwä de? ");
INSERT INTO lro_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Äny gwäꞌtüdï manni gwanni gwugeꞌta ngwonyalu ngwee ꞌdare?’” ");
INSERT INTO lro_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","A je be Ijitabanuj ci, “Ngaa gilee liru ngwüjï ngwunyurtanu ngaa undi giyiꞌra! Ngwügüürnä ngwalu ngwulingana je ngaa übïnï Lïgïꞌrïmälü lanni Lijuꞌru! ");
INSERT INTO lro_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Dïjïr dere dïndï ne daꞌti ngwügüürnä ngwalu übïnälü? Ngindenga liꞌrinyidu ꞌdi aar ꞌrinye ngwïjïrä ngwükäjäär je ngwondaju ngwujaꞌri ngwe gweere gwani nginde gwanni Gwüdünälü gwadi ila. A gwenene, gwuma gwe gwurlanu gwuma aang ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nga nga liru ngwüjï ngwanni ngwapu yobo yätädärä je Ngwaalu yïꞌrr ye, giyo be yaꞌta je ꞌdengenaca.” ");
INSERT INTO lro_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Anni ma ngweleny ngwudi ngwämrä ꞌdingini ngwujaꞌri ngwee, aar kanu gwulleny ꞌdi aar ïyïnï ngwad gündä. ");
INSERT INTO lro_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","A be Ijitabanuj ꞌdïꞌrïyï ngwäy ngwombajidi kerala, a Lïgïꞌrïmä lanni Lijuꞌru onyadala. Ngwengga näjïng gwudi Ngwaalu a Yicu dünäcälä kaama. ");
INSERT INTO lro_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ngwari, “Äny gwänggädï gere gïgïtïnä nyi engga Gïjü gidi Dïjï dümnä gïdünäcä Ngwaalingalu kaama.” ");
INSERT INTO lro_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","A ngindenga ꞌdar gwüꞌrübänï ngwuy ngwänï ngwegen aar ürrï dula gwulleny aar ꞌdïꞌrädä Ijitabanujing nono ꞌdar gwüpäng. ");
INSERT INTO lro_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Aar okta aar gwe ꞌtüdä poor kündär aar aci yoꞌrr ye. A ngwüjï ngwanni ngwüꞌrïdädï ngwujaꞌri nono, aar gwalladani ngwuredalu ngwegen aar je gatanalu gito gito kur giru damal gani Jawul. ");
INSERT INTO lro_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Anni ma aar ji ndi aci Ijitabanujing yoꞌrr ye gwani yiꞌrany, ngwängïnïnï Ngwaalinga ngwari, “Gwani Deleny dani Yicu, mätï lïgïꞌrïmä lüny guy ge gunga.” ");
INSERT INTO lro_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ngwube jürbälü yirku ye ngwurnidi dulu de gwulleny ngwari, “Gwani Deleny, aaꞌti la je düꞌräcï keng nono nggwee.” Anni mung gu ari no, ngwayi. ");
INSERT INTO lro_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","A Jawul ru gwanni gwämnä ndi ari aar ꞌrinye Ijitabanujing. Komon nggoo aar übïnälü giꞌdongalu gidi Ngwaalu gwulleny Üräjälïm a ngwïkïrïjïn ku badalu pad ngwaalu ngwani Yäwüdïyä na Jamra a be ngwooꞌra ngwükäjäär je ru ngwuma jalu Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","A ngwüjï ngwudi Ngwaalu ila aar ape Ijitabanujing aar gatu aar rünïjï gwulleny. ");
INSERT INTO lro_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","A be Jawul ru gwädïnä kiꞌdoonga gidi Ngwaalu ngwübïnälü. Ating ele ngwuꞌdun ngwuꞌdun ngwokta ngwuralu na ngwaw ngwuje ürrä korkon. ");
INSERT INTO lro_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","A be lanni lima abri aar badalu ngwaalu mbüny mbüny aar ondaci ngwüjü ngwujaꞌri ngwe ngwudi Ngwaalu ngwaalu ngwanni ngwuma aar gu badalu. ");
INSERT INTO lro_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","A Bïlïpüj ꞌdïꞌrï ngwüllï kündär geꞌte gidi Jamrang, ngwondaci ngwüjü ngwujaꞌri ngenone ngwani nginde gwanni Gwubrutaar yelenya. ");
INSERT INTO lro_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Anni ma ngwüjï ꞌdingini ngwujaꞌri ngwudi Bïlïpüj aar engga yiꞌremna yidi yiima yanni yärrüng je, ngindenga ꞌdar aar geraji ngwänï mama ngwujaꞌri ngwondajung je. ");
INSERT INTO lro_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Gaji nggoo a ngwüjï ngwonyadu ngwanni ngwätïnä ngwüꞌrïllä nono aar uꞌri nono, a ngwüꞌrïllä ꞌtü ꞌdenggegenanu ngwonyadu dulu de dipa. A lonyadu lanni liru ngwurga a lanni layu ngwangina, aar juꞌri nono. ");
INSERT INTO lro_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","A jayanu ji gwupa kündär nggoo. ");
INSERT INTO lro_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Gur geꞌte giru dima kündär nggoo gani Jamaan gati ape yiima gaji golanu ating alliji ngwüjälü ndïr ngwudi Jamrang ating ïrïngïnï ngwari giru dïjï dojema. ");
INSERT INTO lro_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","A ngwüjï ꞌdar, ngwanni ngwoko na ngwanni ngwupa geraci ngwänï aar ämnäcï aar ari, “Dïjï ndee diru yiima na yüngün yiru yiima yanni yojemana.” ");
INSERT INTO lro_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A ngwüjï gwujani ndi ari ngwuma je yima yüngün yanni yiru yiꞌremnalu ꞌter üktïnï yima aar je engga gaji golanu. ");
INSERT INTO lro_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","A be anni ma aar ämnï ngwujaꞌri ngwanni ngwujaw ngwuma je Bïlïpüj ondaci ngwani yeleny yidi Ngwaalu na ngwürïny ngwe ngwudi Yicu Kirictu, aar ämnï Ngwaalu aar nyïnyïnï ngwuru ngwur na ngwaw. ");
INSERT INTO lro_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","A Jamaan giligoꞌro lüngün ngwämnï Ngwaalu ꞌto a Bïlïpüj nyïnyï. Ngwüꞌdïꞌrï ating gwujani Bïlïpüjïng ngwaalu ngwading gu ele, ati gwe ngwaalu elalu mung engga yiꞌral na yiima yanni yati je Bïlïpüj ärrï yojema. ");
INSERT INTO lro_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Anni ma ngwooꞌra ngwükäjäär je ꞌdingina Üräjälïm ndi ari ngwüjï ngwudi Jamrang ngwuma ämnï ngwujaꞌri ngwudi Ngwaalu, aar je ükäcä Butrujing je Yuwana gwe. ");
INSERT INTO lro_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Anni ma aar obana, aar otaci Ngwaalingalu gwani ngindenga ndi ari a je gu Lïgïꞌrïm lanni Lijuꞌru üllänü. ");
INSERT INTO lro_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ndi ari gaji nggoo, laꞌti je gu na Lïgïꞌrïm lanni Lijuꞌru üllänü. Lïnyïnyäär je ꞌdogo ngwürïny ngwe ngwudi Deleny dani Yicu. ");
INSERT INTO lro_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","No, a je gu Butrujinga Yuwana gwe gatu ngwuyala a je gu Lïgïꞌrïm lanni Lijuꞌru üllänü. ");
INSERT INTO lro_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Anni ma Jamaan engga ndi ari ngwüjï ngwanni ngwämnä Ngwaalu ngwati je gu Lïgïꞌrïm lanni Lijuꞌru üllänü ma je gu ngwooꞌra ngwükäjäär je gatu ngwuy nono. No ngwüꞌdïꞌrï ngwape ngwüꞌrïnyä ngwuje geraci Butrujing je Yuwana gwe ngwuje ci, ");
INSERT INTO lro_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Ätädïïny yiima giyee ꞌto, nunnu dïjï dere danni dinyi gu gatu guy nono, a gu Lïgïꞌrïmä lanni Lijuꞌru üllänü.” ");
INSERT INTO lro_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","A be Butruj ci nu, “Ïndï ngwüꞌrïny ngwe ngwunga gïlïgä, anni geꞌtanga ndi ari a gwadi ellang angidacing gwudi Ngwaalu ngwüꞌrïny ngwe! ");
INSERT INTO lro_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nga gwaꞌti ätï guꞌru giyiiru giyee, ndi ari ligor lunga laꞌti dünälü ngwäyänü Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Joꞌrenyana giyiꞌral yunga giyoo yiki nga otaci Delenyalu ndi ari aar ang düdänïjänü ndi geꞌtaji gwudi ligor lunga nggwee gwuru gu no. ");
INSERT INTO lro_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ndi ari äny gwänggädängä gwuꞌri giligoranu nga ji giyirna yidi yiꞌral yanni yiki.” ");
INSERT INTO lro_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","A Jamaan ci Butrujing na Yuwana, “Otacar Delenyalu gwani äny, ndi ari yanni yara ye aaꞌti ya ji ꞌdünggüny.” ");
INSERT INTO lro_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Anni ma aar enggaca ngwüjü ngwujaꞌri ngwudi Deleny, a Butrujinga Yuwana gwe oꞌra Üräjälïm, aar eggacana ngwüjü kay ngwujaꞌri ngwanni ngwujaw gïyündär yonyadu yidi Jamrang. ");
INSERT INTO lro_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","A gïꞌrr gidi Deleny ci Bïlïpüjïng nu, “ꞌDïꞌrü nga elada kuyala gidi gaama kayalu gidi üllï Üräjälïm ngwelada Gaja.” ");
INSERT INTO lro_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","No, a Bïlïpüj ji mama ngwüꞌdïꞌrï ngwele. Kay aar mbudi güül ge giru Dïjïyüpïyä giru dujimid dïmätï ngwüꞌrïnyä ngwudi yeleny yidi deleny diru daw dani Kandaka didi Yïjüpïyäng. Gur nggee giju kündär gani Üräjälïm ndi otaca Ngwaalingalu. ");
INSERT INTO lro_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ngwube oꞌra ngwuji ndi jalu ngwuduꞌrala ngwüdï je dimirta ngwuji ndi uli gitab ganni gullu dïjïr dani Ajaya. ");
INSERT INTO lro_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","A Lïgïꞌrïm lanni Lijuꞌru ci Bïlïpüjïng nu, “ꞌDonggaca dimirta nga jici gito gito.” ");
INSERT INTO lro_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","A Bïlïpüj gwalajanu ngwujici gito gito ngwuꞌdingini ndi uli ngwujaꞌri ngwudi gitab gidi dïjïr dani Ajaya. A Bïlïpüj otacalu ngwuci, “Nga nggwo gwülïngïdï ngwujaꞌri ngwee ngwula je?” ");
INSERT INTO lro_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ngwuci, “Ngwaadi nje lenge awa ma aar nje ꞌti dïjï enggacu.” Ngwube ci Bïlïpüjïng ngwallu aar gwe jalu. ");
INSERT INTO lro_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A be ngwujaꞌri ngwanni ngwujung je ndi uli ngwuru ngwee, “Gwüktäär nono dangala dadi aar ele ndi üꞌrü ngwulem na nono giranyu gigwogondacu dïjü danni dïwädädï ngwolalu mbüny, no ngwuꞌti ïgïtü ngwulem ngwüngün. ");
INSERT INTO lro_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Gwa aar ärrï yïnädä aar ärrï yïrgïnä. Yärü gwanni gwadi ondaji gilinge ge güngün? Ndi ari gwuma aar düdïyïjï ligoꞌro lüngün ngene gïdïyängälü.” ");
INSERT INTO lro_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","A gur nggoo otaci Bïlïpüjïngälü ngwuci nu, “Eggaciny ngwujaꞌri ngwee ngwaru ngwe dïjïr, ngwondijaja ndi yärü? Dïjïr dondaja gwani ligoꞌro lüngün gwalla gwani dïjï diꞌter?” ");
INSERT INTO lro_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","A Bïlïpüj aalu ngwujaꞌrala ngwoo ngwudi gitab ngwondaci ngwujaꞌri ngwe ngwanni ngwujaw ngwani Yicu. ");
INSERT INTO lro_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Anni ma aar ji ndi ele dimirta de, aar obani ngwaalu ngwätï yaw, a gur nggoo ci Bïlïpüjïng nu, “Yaw yiru pa giyee, yiru ange yadi nyi ümïnïcï ndi nyïnyïnï?” ");
INSERT INTO lro_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ngwugirinya aar dünäjï dimirta. Aar üllï ꞌdün giyaanu a Bïlïpüj nyïnyï. ");
INSERT INTO lro_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Anni ma aar ꞌtüdä giyaanu no, a Lïgïꞌrïm lidi Deleny ape Bïlïpüjïng aaꞌti gur änggädï ba be. A gur nggoo ele dïlä düngün gijayanu. ");
INSERT INTO lro_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","A be Bïlïpüj mbüjïnï kündär gani Äcïdüd ngwüꞌdïꞌrï ngwellalu ndi ondaci ngwüjü ngwujaꞌri ngwanni ngwujaw ngwele ꞌdi ngwombani kündär gani Gäyïjärïyä. ");
INSERT INTO lro_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","A be Jawul gwuru gwuma ji ndi iye ngwïkïrïjïnä ngwudi Deleny yedenyo ngwari ngwuje ꞌrinye. Ngwüꞌdïꞌrï ngwele gidirꞌdal danni diru giꞌra ");
INSERT INTO lro_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nunnu ngwüllïjï ngwujaꞌri ngwe ele ngwämrä ngwudi gündär gidi Dimajiging, nunnu manari gwuma mbuji ngwüjï ngwere ngwudi Gay gidi Deleny dani Yicu, ngwur na ngwaw, ngwuje umma ngwe oꞌra Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Anni ma Jawul ji ndi ele gïdïlä düngün ngwuji gito gito kündär gani Dimajig, a buri üllä kerala ngwoꞌrralu. ");
INSERT INTO lro_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ngwïꞌdï gïdïyängälü ngwuꞌdingini ngwujaꞌri ngwudi dïjï dondaju ngwuci, “Jawul Jawul, nga gwarra miny übïnälü?” ");
INSERT INTO lro_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","A Jawul ci, “Deleny, nga gwani yärü?” Ngwuci, “Äny gwuru gwani Yicu, gwanni gwübïnängälü. ");
INSERT INTO lro_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ꞌDïꞌrälü nga ele nga änï kündär, la ang be eggaci ndi ari nga gwadi ärrï ange.” ");
INSERT INTO lro_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ngwüjï ngwanni ngwïndäär Jawulinga le aar dünälä aar ꞌti ondaju ngwujaꞌralu ngwere ndi ari ngwïndï ngwe ngwaalalu, aar ꞌdingini ngwujaꞌri aar ꞌti be änggädï dïjü dere. ");
INSERT INTO lro_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","A Jawul ꞌdïꞌrälü gïdïyängälü anni mung gatu ngwäyälü ngwüngün, ngwuꞌti ombajidalu ndi engga gonyalu gere. Aar okta kuy aar gwe änï Dimajig. ");
INSERT INTO lro_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ngwujalu yomon täꞌrïl (3) gwürïmü ngwäy, ngwuꞌti ïyü ngwuꞌti ïtï gonyalu gere. ");
INSERT INTO lro_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ngenone Dimajig, dooꞌra deꞌte diju gu dani Ananiya. A Deleny ondaci dilingidu ngwurnidi ngwuci, “Ananiya!” Ngwangindi ngwuci, “Äny gwangindu gwani Deleny.” ");
INSERT INTO lro_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","A Deleny ci, “Ju mama nga ꞌdïꞌrï nga ele kayalu ganni gicaar Gïdünälü nga ele nga änï ngwuꞌdun ngwudi gur gani Yäwüdä nga utalu gur ge gïndï Tarjuj gani Jawul ndi ari nggo ndi otaci Ngwaalingalu. ");
INSERT INTO lro_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Dilingidu gima engga guru gani Ananiya ngwändä ngwalliji ngwuy nono ngwüngün nunnu ngwuꞌri ngwäy.” ");
INSERT INTO lro_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","A Ananiya ci, “Gwani Deleny, nggwuꞌdingina ngwüjü ngwonyadu ngwondaja dïjï de ndee na yiꞌral ye ꞌdar yanni yiki yärrüng je ngwüjü ngwunga ngenone Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","A nginde gwïndï ngene yeleny ye ngwurꞌdal ngwanni ngwuru ngweleny ndi ari ngwummi ngwüjü ngwanni ngwapu ngwürïny ngwunga.” ");
INSERT INTO lro_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","A be Deleny ci Ananiyang nu, “Ïndï! Gur nggee gäbrïny ngwuru gora ndi ape ngwürïny ngwüny ngwe ele ngwüjü ngwuru Garany na ngweleny ngwegen na ngwüjï ngwudi Yïjïräyïl. ");
INSERT INTO lro_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Gwunyi enggaci ndi ari nginde awa gwa mbuji yündä yipa gwulleny gwani ngwürïny ngwüny.” ");
INSERT INTO lro_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","A be Ananiya ele ngwänï gïdrü ngwuꞌdun, ngwalliji Jawuling ngwuy nono ngwüngün ngwuci, “Diweengga dani Jawul, Deleny dani Yicu gwanni gwüꞌtäcängälü kayalu anni janga ndi ilada ngene, gwükäjïny nunnu nga ombajidalu mana ara gu Lïgïꞌrïm lanni Lijuꞌru onyadala.” ");
INSERT INTO lro_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Puprang no, a ngwong ngweꞌte ngwuru nono gwele ngwärkïꞌrä ngwudi ngwuum miꞌraꞌtadalu ngwäy ngwudi Jawul, ngwuꞌri ngwäy ngwombajidalu mana. Ngwüꞌdïꞌrälü aar nyïnyï, ");
INSERT INTO lro_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","anni ma aar ätädä ngweny, ngwudegeꞌdani ngwangina ngwüngün. A Jawul jalu yomon yoko ngwïkïrïjïnïngä le Dimajig. ");
INSERT INTO lro_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ngwüꞌdïꞌrï ngwele ngwondaci ngwüjü ngwonyadu ngwämrä ndi ari Yicu gwuru Gïjï gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ngwüjï ꞌdar ngwanni ngwuꞌdingina, a je ngwe ngwaalu elalu aar utalu aar ari, “Gur gäꞌtüdï nggee ganni gänïjä yedenyalu ngwübïnï ngwüjälü ngwanni ngwapu ngwürïny ngwee ngwani Yicu ngenone Üräjälïmo? Nginde gwaꞌti ïndädï ngene ndi ummi ngwüjü ngwe ele ngwurꞌdal ngwanni ngwuru ngwelenye?” ");
INSERT INTO lro_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","A be Jawul ojemani nono ngwondaji yiima ye ngwügäbïcï Ngwüyäwüd ngwanni ngwati ji ngenone Dimajig a ngwe ngwaalu elalu ngwuje enggaci aar lenge ndi ari Yicu gwuru gwanni Gwubrutaar yelenya. ");
INSERT INTO lro_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Anni ma yomon ele aar onyadi, a Ngwüyäwüd änïjï yujimidalu gwadi aar ꞌrinye, ");
INSERT INTO lro_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","a gu be Jawul lenge. Giyomon reny lingen le na dilu de ati aar rbäcï ngwängïr ngwudi gündär nunnu aadi aar ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","A be ngwooꞌra ngwüngün ape aar üllïyï kundiꞌrala gidi gündär dilu de giꞌram ge aar ꞌtüyï ngwele. ");
INSERT INTO lro_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Anni ma Jawul obani Üräjälïm, ating ari ladi acajidi ngwïkïrïjïn ngwe ngwudi Yicu a je be yedeny eny ꞌdünggüngün, aar ꞌti ämnä ndi ari nginde gwuma ru dïkïrïjïn ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","A be Birnaba ape nggwe ele ngwooꞌra ngwükäjäär je. Ngwuje enggaci ndi ari Jawul gwänggädï Delenya kay gïndïng gu Dimajig na ndi ari awa gwondacu Deleny na ndi ari awa ngenone Dimajig gwondaca ngwüjü gwaꞌti yedeny ïtï ngwürïny ngwe ngwudi Yicu. ");
INSERT INTO lro_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","No, aar le jalu ngwellalu gwügätï linginalu kündär gani Üräjälïm, ngwondaci ngwüjü ꞌdar gwuꞌranu ngwürïny ngwe ngwudi Deleny. ");
INSERT INTO lro_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ati aar ondaji aar garnati yomon reny Ngwüyäwüd ngwe ngwati ondaji Yïgïrïgïyängä, aar be mïnï ndi ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Anni ma gu ngweengga lenge ngwuru ngwïkïrïjïn, aar ape aar gwe üllï Gäyïjärïyä aar dinga ngwele Tarjuj. ");
INSERT INTO lro_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","A be gaji nggoo a adatalu ij yiꞌdoonga yidi Ngwaalu ngwaalu ꞌdar Yäwüdïyä, Jälïl na Jamra, jalu yadatalu. Aar ätï yiima a je Lïgïꞌrïm lanni Lijuꞌru ojemeye nono aar gendadi aar jalu yïdïnyädï Delenya. ");
INSERT INTO lro_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ati be aji a Butruj ꞌdïꞌrï ngwele ngwaalu ꞌdar. Gomon geꞌte ngwele kündär gani Lüdä ndi ombaja ngwïkïrïjïnä ngenone. ");
INSERT INTO lro_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ngenone ngwumbuji guru gani Aniyaj giru dirga gindru ngwümbür gätï ngwüdläyü ꞌdübä (8). ");
INSERT INTO lro_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","A Butruj urnidi ngwuci, “Aniyaj, aar ang Yicu Kirictu uꞌriyi nono. ꞌDïꞌrälü nga apani gïlälälü gunga.” Puprang no, a Aniyaj ꞌdïꞌrälü. ");
INSERT INTO lro_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","A ngwüjï ꞌdar ngwudi Lüdäng na ngwudi Jaruning engga yiꞌral giyee, aar oꞌraca Delenya. ");
INSERT INTO lro_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kündär gani Yapa, dïkïrïjïn didi Deleny diju gu dani Täbïjä (ngwürïny ngwüngün ma aar je gwürlälü Yïgïrïgïyängä, ngwani Dide), nginde gwati ape yiiru yanni yijaw yomon reny ngwugataji ngwüjü düwä ngwanni ngwunyangiralu. ");
INSERT INTO lro_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Gaji ge nggoo, ngwümï ngwayi aar uyi aar ape aar ndriyalu kimbanu alu nggwe. ");
INSERT INTO lro_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Gündär gani Lüdä gaꞌti ola ngwaalinganu kündär gani Yapa. No anni ma ngwïkïrïjïn ꞌdingini ndi ari Butruj nggwo ngenone Lüdä, aar ükäjï ngwüjü rom (2) ꞌdünggüngün aar päcälü aar ci, “Üllädä gwänü!” ");
INSERT INTO lro_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","A Butruj ꞌdïꞌrï aar le ele. Anni mung obani, aar ape aar gwe allu kimbanu alu nggwe a ngwedel ꞌdar oꞌradi nono aar dugi yal ye, aar enggaci yubana na ngwureda ngwonyadu ngwuꞌter ngwanni ngwati je Täbïjä ugꞌri gaji ganni gati aar le ji gwaꞌtina ayu. ");
INSERT INTO lro_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","A je Butruj ꞌtüyä ꞌdar poor, ngwüllï ngwüjürbälü yirku ye ngwotaci Ngwaalingalu, ꞌdi ngwube gwurlada ngwangina ngwudi Täbïjä ngwari, “Täbïjä, ꞌdïꞌrälü.” Ngwugata ngwäyälü ngwüngün änggädïng gu Butrujing, ngwüꞌdïꞌrälü ngwujalu. ");
INSERT INTO lro_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","A Butruj geraci ngwümätä kuy ngwüꞌdïꞌrïyälü ngwüdünäjälä. Ngwube urnida ngwïkïrïjïnä na ngwedel ngwuje ätädä Täbïjïng gwumidu. ");
INSERT INTO lro_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","A ngwujaꞌri ngwee linginni ꞌdar kündär gani Yapa a ngwüjï ngwonyadu ämnï Gideleny. ");
INSERT INTO lro_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","A Butruj jalu ngenone Yapa yomon yonyadu gur ge geꞌte gani Jamaan gati ꞌraji ngwurna. ");
INSERT INTO lro_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ngenone kündär gani Gäyïjärïyä, gur geꞌte giju gu gani Karnulij giru kumndan gidi giꞌdu gidi gwuꞌtulunga küüꞌrï tudini (100) gani Italiya. ");
INSERT INTO lro_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nginde gwuru dïjï dïdïnyädï Ngwaalinga, ngwüjï ngwe ꞌdar ngwudi ngwuꞌdun ngwüngün. Gwati gataji ngwuwaya düwä ligor le ating otaci Ngwaalingalu yomon reny. ");
INSERT INTO lro_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Gomon geꞌte lingen le ligwurlu kaji täꞌrïl (3) ngwengga dilingidu, gïꞌrrä gidi Ngwaalu ngwila ngwuci, “Karnulij.” ");
INSERT INTO lro_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","A Karnulij ombaji yedenyo ngwutalu ngwari, “Yiru ange giyo gwani doorta düny?” A gïꞌrr ci, “Otaci Ngwaalingalu gwunga na angidaji ngwuwaya gwunga gwuma obana ngwäyänü Ngwaalu ngwuma ang diwayina. ");
INSERT INTO lro_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Gwenene ükäjü ngwüjü aar ele ngenone kündär gani Yapa aar gwäꞌrä guru gani Jamaan gwanni gwati aar ci Butruj. ");
INSERT INTO lro_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nginde gwüllädälü kur ganni gati ꞌraji ngwurna gani Jamaan gati ji ngwuꞌdun ngwe dibirta gïlänï.” ");
INSERT INTO lro_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Anni ma gïꞌrr ele ganni gondacu, a Karnulij urnidi ngwïnädä ngwüngün rom (2) na gwuꞌtulu gweꞌte gwüngün gwati denya Ngwaalinga gwanni gwati arnga ngindeng. ");
INSERT INTO lro_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ngwuje enggaci yiꞌral ꞌdar yanni yänggädïng je ngwuje be ükäjï aar ele ngenone Yapa. ");
INSERT INTO lro_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bïgänü nggwoo gilingen lïdünälä anni ma aar ele ꞌdi aar ji gito ndi obani Yapa, a Butruj allu ngwuꞌdun alu nggwe ndi otaci Ngwaalingalu. ");
INSERT INTO lro_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","A ngwamu enyanu ngwümïnï ngwony ngwudi eny. Anni ma aar ji ndi manica, ngwayati giligor ngwengga dilingidu ");
INSERT INTO lro_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","a gere ïgïtïnä ngwengga gony giru nono direda dipa laranu dïmätäär ngwiil ngwüngün kwoꞌrongo aar üllïyä gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Dätï ngwängä ngwonyadu yiꞌranu ngwanni ngwati elalu yora ye kwoꞌrongo na ngwanni ngwati elalu ngwari ngwe gïdïyängälü na yïꞌrä yidi gerala. ");
INSERT INTO lro_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","A ngwujaꞌri ondaja aar ci Butrujing no, “ꞌDïꞌrü nga je dugi nga je eny ngwüdï.” ");
INSERT INTO lro_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","A be Butruj ci, “Bärï gwani Deleny, äny gwa ꞌti ïtï gony gïrngü giru gomon gere aꞌtur.” ");
INSERT INTO lro_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","A ngwujaꞌri ondaci mana aar ci, “Aaꞌti aru ngwong ngwürngü ngwanni ngwuma je Ngwaalu juꞌriyi.” ");
INSERT INTO lro_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ngwujaꞌri ngwee aar gu ari yomonanu täꞌrïl (3) a be dired gwäꞌrïnï puprang kerala. ");
INSERT INTO lro_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Anni ma Butruj ji ndi ïrïyï ngwäyälü ngwujaꞌri ngwee ngwänggädïng je dilingidu, a ngwüjï ngwanni ngwükäjä je Karnulij ila aar utalu ngwuꞌdun ngwe ngwudi Jamaan aar ele ꞌdi aar dünï gïlängïr. ");
INSERT INTO lro_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Aar urnidi ngwüjü ngwudi ngwuꞌdun aar je otacalu ndi ari Jamaan gwani Butruj nggwo gwüllädälü ngeno. ");
INSERT INTO lro_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Anni juna Butruj ndi ïrïyï ngwäyälü giyiꞌral yanni yänggädïng je, a Lïgïꞌrïm lanni Lijuꞌru ci, “Ngwüjï ngwo täꞌrïl (3) poor ngwutalu nga gwe. ");
INSERT INTO lro_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ꞌDïꞌrü nga üllï. Aaꞌti yedeny ya ang eny ndi ang ngwe ele, äny gwuru gwükäjä je ꞌdunggunga.” ");
INSERT INTO lro_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","A Butruj üllï ngwuci ngwüjü, “Äny gwuru nggwee gwanni gwümïnängää. Giru ange ganni gïndädä gu?” ");
INSERT INTO lro_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","A ngwüjï ci, “Karnulij gwuru kumndan gidi gwuꞌtulunga küüꞌrï tudini (100) gwükäjï nje. Gwuru dïjï dïdünälü dïdïnyädï Ngwaalinga a gwati Ngwüyäwüd ꞌdar denya. A be gïꞌrr gidi Ngwaalu ondaci nunnu aar ang urnida nga ele ꞌdunu ꞌdünggüngün nunnu ngwuꞌdingini ngwujaꞌri ngwanni ngwätä je.” ");
INSERT INTO lro_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","A je be Butruj ape ngwuje ülläjälü yïrnü ꞌdunu. Bïgänü nggwoo, a Butruj ꞌdïꞌrï aar le ele a je ngweengga ngwoko ngwudi Yapang gwujani. ");
INSERT INTO lro_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bïgï nggwoo, aar obani Gäyïjärïyä. Aar mbuji Karnulijing gwuju nding je dünïcï, gwujaralu ngwüjï ngwe ngwüngün na ngwumaad ngwüngün ngwurniding je. ");
INSERT INTO lro_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Anni ma Butruj ji gito gwadi änï, a Karnulij ila ngwadacalu ngwukwucalu yirku ye gwani denya. ");
INSERT INTO lro_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","A Butruj ꞌdïꞌrïyälü ngwuci, “ꞌDïꞌrälü, äny gwuru dïjï dümnä ꞌdogo.” ");
INSERT INTO lro_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Anni ma aar gwe ondaji a Butruj änï ngwumbuji ngwüjü ngwoꞌrajidalu gïdrü ngwonyadu. ");
INSERT INTO lro_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ngwuje ci, “Nga nga lïlïngïdï ndi ari yiru drü giyobo gïdïjï diru Dïyäwüd ndi aar acajidi ngwaalu ngweꞌte pu dïjï de diru Garany ngwelaci yïrnü. A be Ngwaalu ngwuminy enggaci ndi ari aaꞌti nggwa ci dïjü dere dïrngü. ");
INSERT INTO lro_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","No anni minyii gu ükäjïdä, äny gwuma ila ligor le lijaw. Nggwa je otacalu ndi ari yiru ange yükäjïdä gu ꞌdünggüny?” ");
INSERT INTO lro_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","A Karnulij ci, “Yomon kwoꞌrongo (4 )yanni yima ele äny gwuju ꞌdunu ndi otaci Ngwaalingalu gilingen ligwurlu liru täꞌrïl (3) kaji nggee no, a dïjï ila digenna ngwureda gwaru nggäm nggäm aar nyi dünäcälü. ");
INSERT INTO lro_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ngwari, ‘Karnulij, Ngwaalu ngwuma ꞌdingini ngwujaꞌri ngwunga ngwanni ngwati ang ngwe otacalu na gwuma enggada angidacing gwunga ngwüjï ngwanni ngwunyangiralu. ");
INSERT INTO lro_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ükäjïdä kündär gani Yapa ngwuꞌdun ngwudi gur gani Jamaan gwanni gwati ꞌraji ngwurna nggwo ngwuꞌdun ngwe gidibirta gïlänï. Gur nggo gu gani Jamaan gwanni gwati aar ci Butruj, gwüllädï gwälü yïrnü.’ ");
INSERT INTO lro_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","No a gu be ükäjïdä puprang, a yijaw ndi ari nga gwuminy ꞌdengenaca nga gwuma ila. Gwenene änyängä ꞌdar gilo ngene ngwäyänü Ngwaalu, ladi ꞌdingini ngwujaꞌri ꞌdar ngwanni ngwondacara je Deleny ndi nje enggaci.” ");
INSERT INTO lro_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","A Butruj aalu ngwujaꞌri ngwe ngwondaji ngwari, “Äny gwuma lenge gweneno yiꞌral ye yorto ye ngwaalinga ndi ari ꞌdidanu Ngwaalu ngwati ꞌti utanu. ");
INSERT INTO lro_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ngwube ämnï ngwüjü gïïlü ꞌdar ngwanni ngwati denya ngindeng aar ärrï yiꞌral yanni yïdünälü. ");
INSERT INTO lro_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nga nga lïlïngïdï ngwujaꞌri ngwanni ngwükäcä je Ngwaalu ngwüjü ngwudi Yïjïräyïl, ngwondaju ngwujaꞌri ngwe ngwanni ngwujaw ngwani adatalu Yicu Kirictu gwe, gwanni gwuru Deleny didi ngwüjï ꞌdar. ");
INSERT INTO lro_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nga nga lïlïngïdï yiꞌral yanni yiju ngwaalu ꞌdar Yäwüdïyä, ꞌtuꞌtu Jälïl anni ondaja Yuwana ngwujaꞌri ngwe ngwani nyïnyïnï. ");
INSERT INTO lro_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nga nga lïlïngïdï ngwujaꞌri ngwanni ngwuꞌdingina ngwe ngwudi Yicu gwudi Najrang, ndi ari awa gwubrutu Ngwaalu Lïgïꞌrïm le lanni Lijuꞌru na yiima. Na ndi ari awa gwulandalu ngwärrï yiꞌral yanni yijaw, ngwuꞌriyi ngwüjü nono ꞌdar ngwanni ngwätïnä dijegoꞌranu, yiima ye yidi Ngwaalu ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Änyängä liru länggädï yiꞌral ꞌdar yanni yärrüng je ken gidi Ngwüyäwüd na kündär gani Üräjälïm. Aar pädä küꞌrï ganni gimamindanu aar ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","A be anni mung jalu yomon täꞌrïl (3), a Ngwaalu ꞌdïꞌrïyälü giyiꞌranyanu aar gäbïcï ngwüꞌtädälü ngwenggani. ");
INSERT INTO lro_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Gwaꞌti ngwüjï änggädï ꞌdar, ngwüꞌtäcïng jälü ꞌdogo ngwanni ngwänggädï ngwanni ngwäbrä je Ngwaalu gwerre. Änyängä lanni gwïtï nyii le nyii le ïyï gaji ganni giming ge ꞌdïꞌrälü giyiꞌranyanu. ");
INSERT INTO lro_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nginde gwondaci nje ndi ari nyii ondaci ngwüjü ngwujaꞌri ngwudi Ngwaalu nje enggaci ndi ari Yicu gwuru gwanni gwugeꞌta Ngwaalu ndi pïcï ngwüjü yelenya ngwanni ngwumidu na ngwanni ngwayu. ");
INSERT INTO lro_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ngwïjïr ꞌdar ngwondaju nginde gwe, ndi ari gwanni gwämnï ꞌdünggüngün gwa Ngwaalu düdänïjänü ndi ke gwüngün ngwürïny ngwe ngwudi Yicu Kirictu.” ");
INSERT INTO lro_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Anni ma Butruj jina ndi ondaji, a Lïgïꞌrïm lanni Lijuꞌru üllï ngwüjänü ꞌdar ngwanni ngwuꞌdinginu ngwujaꞌri ngwüngün. ");
INSERT INTO lro_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","A ngwïkïrïjïn ngwanni ngwüꞌrïꞌtänä ngwuru Ngwüyäwüd ngwanni ngwïndäär Butrujinga le aar dibi, ndi ari Ngwaalu ngwuma angidaji ngwüjü ngwuru Garany Lïgïꞌrïm lanni Lijuꞌru ꞌto. ");
INSERT INTO lro_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ndi ari ngwuꞌdinginaar je ngwondaju aar orta Ngwaalinga ngwungla ngwe ngwuꞌter. A be Butruj ondaji ngwari, ");
INSERT INTO lro_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ngwüjï ngwee ngwuma gu Lïgïꞌrïm lanni Lijuꞌru üllänü nono alanga je ꞌto, yärü gwuru gwadi je ümïnïcï ndi aar je nyïnyï yaw ye?” ");
INSERT INTO lro_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ngwuje ondaci ndi ari aar nyïnyïnï yaw ye ngwürïny ngwe ngwudi Yicu Kirictu. A ngwüjï ci aar le jalu yomon cong. ");
INSERT INTO lro_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","A ngwooꞌra ngwükäjäär je na ngweengga ꞌdar ngenone Yäwüdïyä ꞌdingini ndi ari ngwüjï ngwanni ngwuru Garany ngwuma ämnï ꞌto ngwujaꞌri ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Anni ma Butruj oꞌra Üräjälïm, a ngweengga ngwanni ngwubupa ngwüjü aar üꞌrïꞌtänï, aar garnati Butrujinga le aar ci, ");
INSERT INTO lro_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Nga gwarra nga be ele ngwuꞌdun ngwudi ngwüjï ngwaꞌti üꞌrïꞌtänä ngaa ngwe eny.” ");
INSERT INTO lro_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","A je Butruj ondaci ngwujaꞌri ꞌdar anaku raar gu ꞌtuꞌtu gwerre ngwuje ci. ");
INSERT INTO lro_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nggwuju kündär gani Yapa ndi otaci Ngwaalingalu nyi ayi giligor nyi engga dilingidu gony giru nono direda dipa laranu düllïyäär kerala dïmätäär ngwiil kwoꞌrongo ngwüllälü ꞌdi ngwobana ꞌdünggüny. ");
INSERT INTO lro_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Anni minyi gu ombajidanu nyi gu mbuji ngwängänü ngwati elalu yora ye kwoꞌrongo ngwudi dïyängälü, ngwudi pooring, ngwanni ngwati elalu ngwari ngwe na yïꞌrä yidi geralang. ");
INSERT INTO lro_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nyi be ꞌdingini aar nyi ngwujaꞌri ci, ‘ꞌDïꞌrälü gwani Butruj a je dugi a je eny ngwüdï.’ ");
INSERT INTO lro_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nyi be ci, ‘Bärï gwani Deleny! Gomon gere aꞌtur nggwaꞌti ngilla gony gere gïrngü ngwulemanu ngwüny.’ ");
INSERT INTO lro_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","A ngwujaꞌri ondaja mana kerala aar nyi ca, ‘Gong ganni gima ge Ngwaalu ari gijuꞌru, aaꞌti ga ge ari gïrngü.’ ");
INSERT INTO lro_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A gu ngwujaꞌri ngwe ari yomonanu täꞌrïl (3) aar be gwäꞌrï direda ngwoꞌre kerala mana. ");
INSERT INTO lro_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kaji nggoo, a ngwüjï ngwanni ngwükäjä je Karnulij ꞌdünggüny ngwuru täꞌrïl (3) ngwïndï ngwaalu ngwani Gäyïjärïyä, aar obana gïlängïr lidi ngwuꞌdun ngwanni ngwuji nyi gu. ");
INSERT INTO lro_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Aar nyi Lïgïꞌrïm ondaci ndi ari aaꞌti nggwa ꞌdonya ndi nyii ngwe ele. Ngweengga ngwee ngwuru nyärläl (6) ngwuji nyii ngwe ngenone gwüpäng, nyii ngwe ele nyii änï ngwuꞌdun ngwudi Karnulij. ");
INSERT INTO lro_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Aar nje ondaca ngwujaꞌri anaku änggädïng gu gïꞌrrä ganni gïꞌtäcälü ꞌdunu ꞌdünggüngün ngwuci, ‘Ükäjïdä kur gani Jamaan gwati aar ci Butruj nga urnida nggwo kündär gani Yapa. ");
INSERT INTO lro_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nginde gwa ang be enggaci ngwujaꞌri ngwanni ngwada je gïlängïdïyï ngwüjï ngwe ngwudi ngwuꞌdun ngwunga.’ ");
INSERT INTO lro_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Anni minyi ji ndi ondaci ngwüjü, a je gu Lïgïꞌrïm lanni Lijuꞌru üllänü anaku üllüng gu ꞌto ꞌdengganu gwerre. ");
INSERT INTO lro_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","No nyi diwayini ngwujaꞌri ngwanni ngwucaar nje ngwe Deleny ndi ari, ‘Yuwana gwünyïnyü ngwüjü yaw ye a be nga nga la nyïnyïnï Lïgïꞌrïm le lanni Lijuꞌru.’ ");
INSERT INTO lro_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ma be ari langidaca je Ngwaalu Lïgïꞌrïmä anaku angidacaar nje gu ꞌto, lanni lämnä Gideleny dani Yicu Kirictu, nyi be ani yärü ndi ari nyümïnïcï Ngwaalinga.” ");
INSERT INTO lro_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Anni ma aar ꞌdingini ngwujaꞌri ngwee no, aar ꞌti ätï ngwujaꞌri ngwadi aar ngwe ari aar ortada Ngwaalinga, aar ari, “Yiru gu be no, Ngwaalu ngwuma ätädä ngwüjü ꞌto ngwanni ngwuru Garany gay nunnu aar joꞌrenyana aar mbuji miding.” ");
INSERT INTO lro_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ngwïkïrïjïn ngwanni ngwuma ꞌdïꞌrï aar badalu gwani übïnälü anni ma aar ꞌrinye Ijitabanujing, aar ele ngwaalu ngwani Bunijiya na Gabruj na Andakiya gündär gidi Jürïyäng ati aar ondaci ngwüjü ngwuru Ngwüyäwüd ꞌdogo ngwujaꞌri ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","A be loko lanni liru ngwïkïrïjïn liru lidi Gabrujing na Giruwan anni ma aar ele Andakiya ati aar ondaci ꞌto ngwüjü ngwuru Garany ngwujaꞌri ngwanni ngwujaw ngwani Deleny dani Yicu. ");
INSERT INTO lro_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","A je gu Ngwaalu gïꞌtïjï yiima yüngün a ngwüjï ngwonyadu ämnï aar oꞌraci Delenya dani Yicu. ");
INSERT INTO lro_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","A ngwujaꞌri ngwee ele ꞌdi a je ngwïkïrïjïn ꞌdingini ngwudi Üräjälïmïng, aar ükäjï Birnabang Andakiya. ");
INSERT INTO lro_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Anni mung obani ngenone, ngwumbuji yïmïꞌrü yidi Ngwaalu yiju ngwüjï, ngwujayanu gwulleny ngwuje orꞌtemaji ꞌdar nunnu aar mätïnälü ꞌdiꞌdidanu yigor ye yegen ꞌdar Gideleny dani Yicu. ");
INSERT INTO lro_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Birnaba ngwuru dïjï dijaw gwonyadu Lïgïꞌrïmälä lanni Lijuꞌru na ngwätï ämnïng Ngwaalu. A ngwüjï ngwonyadu gendada Gideleny. ");
INSERT INTO lro_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","A Birnaba ꞌdïꞌrï ngwele kündär gani Tarjuj ndi mïnä guru gani Jawul. ");
INSERT INTO lro_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Anni mung mbuja, ngwapa nggwe ila Andakiya. Aar gu jalu ngenone dïdläyü deꞌte pu ati aar jalu ngwïkïrïjïnïngä le aar enggaci ngwüjü ngwonyadu ngwujaꞌri ngwudi Ngwaalu. Andakiya, ngwaalu ngwuru ngwanni ngwuma aar gu ätädä ngwüjü ngwudi Ngwaalu ngwürïny yïrnü aar je ci ngwïkïrïjïn. ");
INSERT INTO lro_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Gaji nggoo a ngwïjïr ngwoko ngwüllü Üräjälïm aar ila Andakiya. ");
INSERT INTO lro_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","A deꞌte ꞌdenggenanu dani Agabuj, ngwüꞌdïꞌrï ngwüdünälä yiima ye yidi Lïgïꞌrïm lidi Ngwaalu ngwalliji yïjïrä ndi ari ngwamu ngwadi ji ngwupa ngwaalu ꞌdar ken. Aji a ngwamu ngwee ji ꞌdidanu gïdïdlä gaji ganni gima ge deleny ape yelenya dani Kiludiyuj. ");
INSERT INTO lro_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","A ngwooꞌra ngwudi Yicu mäjïdï ngwüꞌrïnyä ngwanni ngwa je dïjï mbuji nunnu aar je ükäcï ngwengga ngwudi Yäwüdïyäng aar je ngwe gataji düwä. ");
INSERT INTO lro_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","A ngindenga lima gu mäjïdï ꞌdidanu ꞌdar aar je ükäcï mbumbung je Üräjälïm angidacing gwegen aar je ätädä Birnabang je Jawul gwe aar je äpïjï. ");
INSERT INTO lro_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Gaji nggoo a deleny dani Yïrüdïj ꞌdïꞌrï ngwummi ngwïkïrïjïnä ngwudi giꞌdoonga gidi Ngwaalu ngwuje übïnälü. ");
INSERT INTO lro_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ngwümäätä Yagubing gwanni gwuru gwenggen gwudi Yuwananga ngwuꞌrinye galal ge. ");
INSERT INTO lro_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Anni ma Yïrüdïj engga ndi ari yiꞌral giyee yima jada Ngwüyäwüdänü, ngwüꞌdïꞌrï ngwümäätä Butrujing ꞌto. Yiꞌral giyee yiju gaji gidi Yïꞌrïnyïnä yidi Ligiꞌra. ");
INSERT INTO lro_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Anni mung määtä, ngwape ngwänïjï korkon, ngwube geꞌte ngwangida kiꞌdu kiꞌdu yiꞌranu kwoꞌrongo kiꞌdu geꞌte pu ati aar gu dünï aar angida. Nunnu ma Yïꞌrïnyïnä yidi Dambdani abralu, ngwube apada ngwelenyanu nunnu aar gu pädä yelenya. ");
INSERT INTO lro_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","A Butruj ji korkon a be ngwïkïrïjïn jalu ngwäy ngwe aar otaci Ngwaalingalu ligor le ꞌdiꞌdidanu gwani nginde. ");
INSERT INTO lro_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Dilu de gwaꞌtina Yïrüdïj äpädï ngwaalu ngwudi pï yelenya, a Butruj ji ndi ndri gwänü ngwangidanu rom (2) gwugekanalu yuꞌrung ye rom (2), a ngwangida dünälä aar angida längïrü. ");
INSERT INTO lro_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","A ꞌdür no, a gïꞌrr ila gidi Deleny ngwüdünälä ngenone, a buri oꞌrralu ngwaalu ngwanni ngwuju gu Butruj, ngwümïꞌrï kimeranu ngwuꞌritiya. Ngwuci, “ꞌDïꞌrälü puprang.” A yuꞌrung yanni yigekaning yalu aar gwanna ngwuy aar ïꞌdï. ");
INSERT INTO lro_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","A gïꞌrr ci, “ꞌDïꞌrü nga rüjïnänü dired de nga genne ngwüdänü.” A Butruj ꞌdïꞌrï ngwärrï yiꞌral yanni yica ye gïꞌrr, ngwoꞌre ngwuci, “Pänä direda nono didi gennala dunga nyi gwujana.” ");
INSERT INTO lro_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","A Butruj ꞌdïꞌrälü ngwugwujani aar gwe ele ꞌdi aar ꞌtü poor, ngwuꞌti be lïngïdï yiru ange giyo ngwüdädïgïnï ngwuꞌti lïngïdï ndi ari ngwujaꞌri ngwätï ngwäyänü ngwanni ngwärrï je gïꞌrr, ngwuji ndi ari gwänggädï yiꞌral dilingidu. ");
INSERT INTO lro_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Aar ge ila ꞌdi aar gatana ngwangida ngwanni ngwudi gwerre gwerreng na gwudi gwodaning aar ila ꞌdi aar obana gïlängïr liru laaba lidi ꞌtü kay gati elada kündär. A je längïr ïgïtïjï gwuꞌren aar gu ꞌtü. Anni ma aar üꞌrü gayanu geꞌte, a gïꞌrr gatani ngwele. ");
INSERT INTO lro_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","A Butruj ꞌrita ligor ngwari, “Nggwuma lenge ꞌdidanu gweneno ümïmänü gwaꞌti ndi ari ngwujaꞌri ngwanni ngwuju, ngwätï ngwäyänü ndi ari Deleny diru dükäjü gïꞌrrä güngün nunnu ngwila aar nyi gwalla Yïrüdïjïng ngwomonanu ngwüngün na giyiꞌralanu yere yanni yigeꞌta je Ngwüyäwüd giyigoranu.” ");
INSERT INTO lro_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Anni mung gu lenge yiꞌral giyee no, ngwele ꞌdunu ndi Märïyäm gwuru nanni gwudi Yuwana gwani Murkuj ngenone ngwïkïrïjïn ngwoꞌradi gwalu ngwonyadu aar ji ndi otaci Ngwaalingalu. ");
INSERT INTO lro_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","A Butruj ila ngwüpïdä längïrü poor a dïnäd ila diru gera dani Räwüdä ndi ïgïtï dïmbürä. ");
INSERT INTO lro_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Anni mung ꞌdingini ngwujaꞌri ngwudi Butruj gwondaju poor, ngwujayanu ꞌdi ngwoꞌre kay ngwuꞌti ïgïtü dïmbürä. Ngwoꞌre ngwondaci ngwüjü ndi ari Butruj nggwo gïlängïr. ");
INSERT INTO lro_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","A ngwüjï ci gïjü, “Nga gwari giꞌra milang.” Anni mung ꞌdonyalu ꞌtïbüny ndi ari Butruj gwuru, aar ci, “Gïꞌrr ga ru güngün.” ");
INSERT INTO lro_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","A Butruj jina ndi pï längïrü gwurꞌtal, anni ma ngwüjï ïgïtädälü aar engga, a je ngwe ngwaalu elalu. ");
INSERT INTO lro_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","A je Butruj ci guy ge gwugwundar ngwuje enggaci ndi ari awa gwüꞌtïyä Delenya korkon. Ngwuje be ci, “Ondacar Yagubing je ngweengga ngwe ngwuꞌter ngwujaꞌri ngwee.” Ngwüꞌtü ngwele ngwaalu ngwuꞌter. ");
INSERT INTO lro_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Dilu danu aꞌti yigor pï ngwangidanu aar utalu ndi ari yiru ange yima ji ndi Butruj. ");
INSERT INTO lro_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Anni ma Yïrüdïj ükäjï ngwujaꞌri aar mïnä ꞌdar aar ꞌti mbuju, ngwüꞌtïyä ngwujaꞌri aar apa ngwangida ngwoo aar je otacalu aar je ꞌrinye. A be Yïrüdïj ꞌdïꞌrï ngwugatani ngwaalinga ngwani Yäwüdïyä ngwele kündär gani Gäyïjärïyä ngwujalu ngenone gwooko. ");
INSERT INTO lro_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Gwapu güündä ngwüjï ngwudi yündär yidi Jür na Jäyïdä. Aar be oꞌrajidi gwüpäng aar bupi gweneno nding je ꞌdengenaci. Anni ma je dïnäd didi Deleny dani Yïrüdïj, dating gu gatada ngwäyänü dani Bilactuj gïꞌtïjï gay, aar ci Delenya dani Yïrüdïj linana ndi aar le oꞌrajidi aar jalu ladatalu. Ndi ari ngindenga lati je Delenya dani Yïrüdïj äpïjä yona. ");
INSERT INTO lro_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","A gomon ganni gigeꞌtaar, a Yïrüdïj genne ngwureda ngwudi yeleny ngwujalu gididuꞌrala didi yeleny ngwube ondaci ngwüjü. ");
INSERT INTO lro_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","A ngwüjï ortada aar ürrï dula aar ari, “Dïjï däꞌtüdï ndee danni dümnä dondaju ngwaalu gwuru ngwondaju.” ");
INSERT INTO lro_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kaji nggoo geꞌte geꞌte anni mung ꞌdingini ngwujaꞌri no, ngwuꞌti näjä Ngwaalinga, a gïꞌrr gidi Deleny agada dimdi nono ngwümï ngwondoma ꞌdi ngwayi. ");
INSERT INTO lro_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","A ngwujaꞌri ngwudi Ngwaalu gendadi aar badalu ngwaalu ꞌdar. ");
INSERT INTO lro_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Anni ma Birnabanga Jawul gwe medaja yiiru yegen Üräjälïm, aar oꞌra aar apana Yuwanang gwanni gwati ani ꞌto Murkuj. ");
INSERT INTO lro_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ngenone kiꞌdoonga gidi Andakiyang, ngwïjïr na ngwoorta ngwee ngwuju gu, Birnaba, Jamaan gwani Nejer, Lukiyuj gwudi Giruwaning, Maniyan gwanni gwuraar Yïrüdïj gwe gwuru deleny gimaad ꞌtuꞌtu yogo ye na Jawul. ");
INSERT INTO lro_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Anni ma aar ji ndi äpïjï Ngwaalinga yiiru aar määtä ngwädä, a je Lïgïꞌrïm lanni Lijuꞌru ci, “Äbrïjïïny Birnabang je Jawul gwe, aar ele ndi aar nyi äpïjï yiiru yanni yornaci nje.” ");
INSERT INTO lro_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","No a ngwïkïrïjïn otaci Ngwaalingalu aar määtä ngwädä aar je ätä guy aar je geꞌte kay aar ele. ");
INSERT INTO lro_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","No ngindenga rom (2), a je Lïgïꞌrïm lanni Lijuꞌru dinga aar ele aar obani kündär gani Jälükïyä, aar üꞌrü yaanu ngenone aar ele ngwaalu giyaanu ngwani Gabruj. ");
INSERT INTO lro_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Anni ma aar obani kündär gani Jalamaj, aar ondaci Ngwüyäwüd ngwujaꞌri ngwudi Ngwaalu ngwämrä ngenone. Aar ji Yuwananga le gwanni gwati ani Murkuj, ngwuje gataji düwä. ");
INSERT INTO lro_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Aar landalu ꞌdar kündär giyaanu gidi Gabrujing ꞌdi aar obani kündär giyaanu gani Pabuj. Ngenone aar mbudi dimanga le diru Dïyäwüd dati alliji yïjïrä yiꞌduru dani Bar Yicu, ");
INSERT INTO lro_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","dati mbüjïnï gideleny danni dïmätï yelenya ngwaalu giyaanu dani Järgïyüj Bulij gwuru gur gibebera gwulleny, ngwükäjïdï ndi Birnabanga Jawul gwe nunnu gwubupa ndi ꞌdingini ngwujaꞌri ngwudi Ngwaalu ꞌdenggen. ");
INSERT INTO lro_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","A be Aliyimaj nggwoo gwuru dima (ngwürïny ngwüngün ngwani gu no Yïgïrïgïyängä) ngwuje be jici kay ngwuje üꞌrïꞌtï ngwäy ngwunani ndi ümïnïcï delenya ndoo ndi ämnï Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","A be Jawul, gwanni gwani ꞌto Bulij, gwonyadu Lïgïꞌrïmälä lanni Lijuꞌru ngwombaji Aliyimajing ngwäyänü ꞌtiꞌtog ngwuci, ");
INSERT INTO lro_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nga nggwee gwudi dijegoꞌrr, nga ru güwän gidi yiꞌral ꞌdar yanni yijaw! Nga gwonyadu ïꞌdäjïngänü nga onyadi mïmïnäjänü. Aꞌtur nga gwäꞌtüdï gwadi dünäjï yiꞌrinya ngwujaꞌri ngwanni ngwüdünälü ngwudi Delenye? ");
INSERT INTO lro_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Gwene ara gwe Deleny ji guy ge nga gwa rïmï ngwäy gwene nga jalu gaji gooko nga gwa ꞌti gwengga buri gwudi lingen.” Puprang no a dumbil na dïrïm gätïnï ngwäy, ngwakalu ngwuy ngwe ngwümïnï dïjü ndi okta kuy. ");
INSERT INTO lro_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Anni ma gu deleny didi ngwaalu ngwoo engga yiꞌral giyee yima ji, ngwämnï Ngwaalu ndi ari gwïndï gwe ngwaalalu ngwujaꞌri ngwinggidaar ngwe ngwudi Deleny. ");
INSERT INTO lro_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ngenone Pabuj, a Bulij na ngwooꞌra ngwanni ngwïndäär le, aar üꞌrü yaanu aar ele kündär gani Berga ngwaalu ngwani Bämbïlïyä, a je gu be Yuwana gatani ngwoꞌre Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ngenone Berga, aar ꞌdïꞌrï aar elada gweere ꞌdi aar obani Andakiya gwudi Bïjïdïyäng. A gomon Kwoꞌra täꞌrïl, aar änï ngwämrä aar jalu. ");
INSERT INTO lro_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Anni ma aar uli Yobo yidi Müjä na Yïjïr yidi Ngwïjïr kitabanu, a je be ngweleny ngwudi ngwämrä ükäcï ngwujaꞌri aar je ci, “Ngweengga, manari ngaa lätï ngwujaꞌri ngwere ngwada je ondaji a ngwe orꞌtemaji ngwüjü, ondajar je.” ");
INSERT INTO lro_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","A Bulij ꞌdïꞌrälü ngwüdünälä, ngwalliji guyala ngwari, “Nga nga liru ngwüjï ngwudi Yïjïräyïl na nga nga ngwüjï ngwuru Garany ngaa lanni lati orta Ngwaalinga, ꞌdinginiiny! ");
INSERT INTO lro_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ngwaalu ngwudi Yïjïräyïl ngwäbrü ngwügürnä ngwege, ngwügäbïcï ngwüjü aar gendadi aar onyadi kaji ganni gijaar ge Mijir. Yiima ye yidi guꞌran güngün, ngwuje ꞌtüyä poor ken gidi Mijiring. ");
INSERT INTO lro_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ngwuje mätïjï liguri ndi elelle gwegen, ngwuje arnga ngwüdläyü küüꞌrï rom (40) gïtäny. ");
INSERT INTO lro_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ngwuje lïnynyïjï ngwüjü giyen kwoꞌra täꞌrïl (7) ngwaalu ngwani Kanaan ngwuje apada dïyängü degen ngwätädä ngwüjü ngwüngün ngwudi Yïjïräyïl yuꞌrina. ");
INSERT INTO lro_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yiꞌral ꞌdar giyee yiju ngwüdläyü küüꞌrï tudini kwoꞌrongo na küüꞌrï rom na ꞌdï (450). Anni ma ngwüdlä medadi ngwee, a je Ngwaalu ätädä ngwüjü aar pïcï yelenya ꞌdi a gaji ila ganni gima ge dïjïr ila dani Jämüwïl. ");
INSERT INTO lro_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","A be aji a ngwüjï ꞌdïꞌrï aar ari ngwümïnü delenya. A je Ngwaalu ätädä delenya dani Jawul gwuru gïjï gidi Kïj gïlängïr lidi Bïnïyämïn ngwape yelenya ngwüdläyü küüꞌrï rom (40). ");
INSERT INTO lro_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Anni ma Ngwaalu äbrï delenya dani Jawul, ngwuje äpïjä Däwüdïng ngwuru deleny degen. A Ngwaalu ngwondaju ngwujaꞌri ngwe ngwani nginde ngwari, ‘Äny gwumbuju Däwüdïng gwuru gïjï gidi Yici gwuru dïjï danni dïmïnä ligor lüny, nunnu aar nyi ärrïjï yiꞌral ꞌdar yanni yïmïnï nje nding je ärrï.’ ");
INSERT INTO lro_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Yicu gwuru gwanni gwuru dïgüürnä didi Däwüd gwanni gwuma Ngwaalu ruji Gilang gwudi ngwüjï ngwudi Yïjïräyïl, anaku arung gu. ");
INSERT INTO lro_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Gaji ganni gaꞌti ge na Yicu ïndï, Yuwana gwïndï ngwondaci ngwüjü ꞌdar ngwudi Yïjïräyïl ngwujaꞌri ngwani joꞌrenyani na nyïnyïnï yaw ye. ");
INSERT INTO lro_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Anni ma Yuwana ji gito ndi medaji yiiru yüngün, ngwutalu ngwari, ‘Nga nga lanijiny yärü? Äny gwäꞌtüdï gwani nginde nggwäꞌdï. Nggwäꞌtüdï, a be nginde nggwo gwïndï gwodan, nggwaꞌti mbutu ngwäyänü ndi nyi gwäꞌdädä ngwüdänälü ngwüngün.’” ");
INSERT INTO lro_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ngwuje ci, “Ngweengga, yïjï yidi Äbräyïm, na ꞌdar liru Garany lati denya Ngwaalinga, yiru ndi ari ngwujaꞌri ngwee ngwudi gilang ngwükäcäär nje. ");
INSERT INTO lro_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Aaꞌti be ngwüjï ngwudi Üräjälïmïng na ngweleny ngwegen lïngïdï ndi ari Yicu gwuru Gilang aar ꞌti lïngïdï ngwujaꞌri ngwanni ngwaru ngwe ngwïjïr. Gwuma aar gwe obalu a gu ngwujaꞌri ru ngwanni ngwari ngwe ngwïjïr ngwati aar je uli yomonalu ꞌdar komon ganni giru Kwoꞌra täꞌrïl. ");
INSERT INTO lro_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","A be ngindenga gwuma aar ꞌti mbojaja yiꞌral nono yere ndi aar gu ꞌrinyada, aar be ondaci Bilatijing ngwuꞌrinye. ");
INSERT INTO lro_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Anni ma aar ärrï yiꞌral ꞌdar anaku ondaja gu gitab gwerre gwani nginde, aar ülläjälü küꞌrälä ganni gimamindanu aar gwürïcï gidimomo. ");
INSERT INTO lro_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","A be gwuma Ngwaalu ꞌdïꞌrïyälü gidimomanu gwumidu. ");
INSERT INTO lro_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","A nginde ngwüꞌtäcä ngwüjälü yomonanu yonyadu ngwanni ngwïndäär ngwe ngwaalu ngwani Jälïl aar ila Üräjälïm. Ngindenga liru gwenene lanni gilo gwondajaar gwe ngwüjänü ngwege. ");
INSERT INTO lro_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Londaca je ngwujaꞌri ngwanni ngwujaw ngwuca ngwe Ngwaalu ngwügürnä ngwege ");
INSERT INTO lro_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ngwaalu ngwuminje gäbïcï ngwujaꞌri ngwuma ji kaji nggee gege lanni liru yïjï yegen, ꞌdïꞌrïyï gwe Yicungalu. Anaku üllïnäär gu kitabanu gidi Mäjïmür kiꞌraany ganni giru rom (2) ndi ari, ‘Nga gwuru Gïjï güny, gwene äny gwuma ru Mbumbu gwunga.’ ");
INSERT INTO lro_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yiru gu giyee ndi ari gwüꞌdïꞌrïyä Ngwaalalu giyiꞌranyanu gwumidu a gwaꞌti gwayi mana aꞌtur yondaja ye ngwujaꞌri ngwee ndi ari, ‘Nggwa ang juꞌriyi gwa ang onjaci ꞌdidanu anaku ci nyi gu Däwüdïng.’ ");
INSERT INTO lro_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Yondaja gu no ngwaalu ngwuꞌter ndi ari, ‘Gwaꞌti gwa ang gatani gwunga gwanni Gwujuꞌru gwa ꞌdegeꞌralu gidimomanu.’ ");
INSERT INTO lro_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","A be Däwüd anni mung medaji yiiru yidi Ngwaalu kimaad güngün gwuma ayi gwuma gwujani ngwügürnä gwuma aar gwürïcï gwuma ꞌdigiꞌri gidimomanu. ");
INSERT INTO lro_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","A be gwanni gwuma Ngwaalu ꞌdïꞌrïyälü giyiꞌranyanu gwumidu gwuma ꞌti ꞌdigiꞌru gidimomanu. ");
INSERT INTO lro_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Yäy gu no, lani ngwänggärï, lïngïdär ndi ari yiru giyee yanni yïgäbïcï nje ara je be ondaci ndi ari Yicu gwuru gwanni gwurnidaar gwe ndi düdänïjï ngwüjänü ndi ke gwegen. ");
INSERT INTO lro_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ngwüjï ꞌdar ngwa aar je dünïyälü Yicu gwe giyiꞌral ꞌdar yanni yiki ma aar ämnï Ngwaalu ndi ari dünïyälü gwaꞌti giyobo yidi Müjä. ");
INSERT INTO lro_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Arnganar be ngwujaꞌri ngwanni ngwaru ngwe ngwïjïr aaꞌti ngwa je mbuji, ");
INSERT INTO lro_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ombajar je be, lanni lati münä ngwujaꞌranu, übïdärälü ngwujaꞌri ngwee ꞌdi nga ayi, ndi ari äny gwadi ärrï yiꞌral yeꞌte giyomon yalu ndi ari yaꞌti ya gu ämnï aꞌtur, ꞌdi manari a je dïjï dere ondaci.’” ");
INSERT INTO lro_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Anni ma Bulijinga Birnaba gwe ji ndi ꞌtüdä ngwämrä, a je ngwüjï ci kwodaralu komon Kwoꞌra täꞌrïl nggäꞌdï gidi gwodaning ngaa ondaji ngwujaꞌri ngwe ngwee. ");
INSERT INTO lro_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Anni ma ngwüjï ꞌtü aar badi, a ngwüjï ngwonyadu ngwanni ngwuru Ngwüyäwüd na ngwuru Garany ngwanni ngwändï giyobo yidi Ngwüyäwüd ngwüdïnyädï Ngwaalinga ꞌdïꞌrï aar gwujani Bulijing je Birnaba gwe, a je Bulijinga Birnaba gwe orꞌtemaji nunnu aar mätïnälü ꞌdïꞌdäny gïyïmïꞌrü yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Anni ma aar oꞌra komon Kwoꞌra täꞌrïl nggoo gidi gwodaning aar ila ꞌdar anaku raar gu ndi aar dingini ngwujaꞌri ngwudi Ngwaalu ngwanni ngwadi je Bulijinga ondaji. ");
INSERT INTO lro_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","A be anni ma Ngwüyäwüd engga ngwüjü ngwuma ila ngwonyadu a je yigor enyanu aar ꞌdïꞌrï aar garnati aar ke yiꞌrinya ngwujaꞌri ngwudi Bulij aar lo. ");
INSERT INTO lro_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ngwujaꞌri ngwee aar gäbïcï Bulijinga je Birnaba gwe aar ojeme nono aar ꞌranu ndi ondaji aar ari, “Yädï gu ndi ara je ondaci nga nga gwerre gwerre ngwujaꞌri ngwe ngwudi Ngwaalu. A be anni ma je ꞌdonya, ngaa lima obalu yigoꞌro ye yalu ndi ari ngaa laꞌti äwdï ndi ätï miding gwudi gwurꞌtaling la je be gatani lele ngwüjï ngwuru Garany nje ondaci. ");
INSERT INTO lro_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ndi ari Deleny dondaciny ngwari, ‘Äny gwurujanga buri gwudi ngwüjï ngwuru Garany, nunnu nga ape gilanging a gwe ele ngwüjï gïdïdlä ꞌdar.’” ");
INSERT INTO lro_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Anni ma ngwüjï ngwuru Garany dingini ngwujaꞌri ngwee, aar jayanu aar näjï ngwujaꞌri ngwudi Deleny na ꞌdar lanni lutaar janu nunnu aar midi miding ngwudi gwurꞌtaling aar ämnï Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","A ngwujaꞌri ngwudi Ngwaalu badalu ngwaalu ꞌdar ngenone. ");
INSERT INTO lro_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","A be Ngwüyäwüd gwogaji ngwayu ngwanni ngwuru yiꞌra ngwüdïnyädï Ngwaalinga na ngwüjï ngwanni ngwuru yiꞌra kündär aar ꞌdïꞌrï aar übïnï Bulijing jalu Birnaba gwe aar je linynyi aar je ꞌtüyï poor ngwaalu ngwegen. ");
INSERT INTO lro_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","A je Bulij na Birnaba protada dibuꞌra nono didi yora yegen dani ꞌdonya gwegen aar ꞌdïꞌrï aar ele kündär gani Ayikuniya. ");
INSERT INTO lro_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A ngwooꞌra jayanu a je gu Lïgïꞌrïm lanni Lijuꞌru onyadala. ");
INSERT INTO lro_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","A Bulijinga Birnaba gwe ꞌdïꞌrï ngenone Ayikuniya aar änï ngwämrä ngwudi Ngwüyäwüd anaku äbräjäär gu. Ngenone aar ondaci ngwüjü ngwujaꞌri ngwudi Ngwaalu yiima ye ꞌdi aar gäbïcï ngwüjü ngwonyadu aar ämnï Ngwaalu ngwuru Ngwüyäwüd na ngwuru Garany. ");
INSERT INTO lro_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","A be Ngwüyäwüd ngwoko ngwanni ngwuma ꞌdonya ndi ämnï, aar ꞌdïꞌrï aar gwogaji ngwüjü ngwuru Garany aar je änïcï ꞌdïmänänü aar je gwürlï yaꞌranya aar gwurla ngwïkïrïjïnä nono. ");
INSERT INTO lro_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","No a Bulijinga Birnaba gwe jalu ngenone gaji golanu aar ondaci ngwüjü liꞌranu ngwujaꞌri ngwani Deleny, a je Deleny gendaci yiima ngwujaꞌri ngwudi yïmïꞌrü yüngün ngwuje gäbïcï aar ärrï yiꞌremna yidi yiima na yidi allalu ndïr. ");
INSERT INTO lro_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","A ngwüjï ngwudi gündär nggoo üꞌrïdïnänü rom (2). Ngwüjï ngwoko aar ji Ngwüyäwüd ngwe na ngwoko aar ji ngwooꞌra ngwe ngwükäjäär je. ");
INSERT INTO lro_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","A ngwüjï ngwuru Ngwüyäwüd na ngwuru Garany aar ke yiꞌrinya aar rucidi ngwelenyinga le ngwegen ndi aar je ärrï yïrgïnä aar je aci yoꞌrr ye. ");
INSERT INTO lro_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","A be anni ma aar gu lenge, aar ꞌdïꞌrï aar abri aar ele gïyündär yidi Lijitrang na Därbï yidi Layikuniyang na yündär ꞌdar yijicidaar ye. ");
INSERT INTO lro_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Aar gu ondaci ngwüjü ngwujaꞌri ngwanni ngwujaw. ");
INSERT INTO lro_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ngenone Lijitra, gur giju gu gijalu gayu yora giru dirga anaku lïngïtäär gu gati ꞌti ïndï. ");
INSERT INTO lro_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ngwugeraji ngwujaꞌri länï ngwuji je Bulij ndi ondaji. A Bulij ombaji jicom ngwulenge ndi ari gätï ämnïng Ngwaalu ndi uꞌri nono. ");
INSERT INTO lro_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ngwurnidi ngwuci, “Dünädälä yora ye yunga.” Ngwujaꞌri ngwe ngwee, a gur ꞌdïꞌrälü prüd ngwugatu yora ngwele. ");
INSERT INTO lro_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Anni ma ngwüjï engga yiꞌral giyee yima je Bulij ärrï, aar ürrï dula lingla le legen lidi Layikuniyang aar ari, “Ngwaalu ngwuma rudini dïjï dümnä ngwuma üllä ꞌdengge.” ");
INSERT INTO lro_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Aar ätädä Birnabang ngwürïny aar ci Jeyoj, na Bulij aar ci Armaj, ndi ari gwuru giꞌra ndi ondaji. ");
INSERT INTO lro_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Gito gito kündär nggoo, gobo giju gu gidi bayil ngwani Jeyoj, a dirꞌdal didi gobo apa yindri aar ꞌräjänä yibobo ngwurꞌta aar ngwe ila gïlängïränü lidi gündär a dirꞌdal na ngwüjï ngwonyadu aar bupi ndi aar je rcïjï aar mïꞌrïnï nono. ");
INSERT INTO lro_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","A be anni ma ngwooꞌra ngwükäjäär je Bulijinga Birnaba gwe, ꞌdingini ngwujaꞌri ngwee, aar dirita ngwuredanu aar ꞌtüdä aar abrada ngwüjï nono poor aar mïꞌrï dula aar je ci, ");
INSERT INTO lro_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ngwüjï ngaa larra ma aang ärrï yiꞌral giyee? Änyängä liru ꞌto ngwüjï ngwümnä nono nga nga. Läpïjä je ngwujaꞌri ngwanni ngwujaw ar je ondaci nunnu ngaa gwurla giyiꞌral giyee yiru ꞌtur ngaa oꞌraca Ngwaalinga ngwanni ngwumidu, ngwanni ngwugeꞌta gere aar geꞌte dïyängü na yaw na ngwony ꞌdar ngwanni ngwo gu. ");
INSERT INTO lro_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Gwerre, Ngwaalu ngwügäbïcä ngwüjü aar elada giyigor yegen. ");
INSERT INTO lro_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Aar ꞌti be gäbïcä ligoꞌro lüngün ndi änälü nunnu aaꞌti ngwüjï lïngïdï. Ngwube inggidi giyomon ꞌdar ïnäng gwüngün ndi ari nggwo. Ati ara je nïjï giranyu kere ngaa kwoy yuula kaji gegen, ara je agaci ngwonyalu ngwonyadu ngaa eny ngaa pe ngaa jayanu.” ");
INSERT INTO lro_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Aaꞌti ngwooꞌra ngwükäjäär je burna ngwujaꞌri ngwe ngwee ndi dünäjï ngwüjï ndi aar je rcïjï aar je gätïjälü, a gu ngwooꞌra ngwükäjäär je arri ꞌdi aar je dünäjï. ");
INSERT INTO lro_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","A be Ngwüyäwüd ngwoko ngwïndï Andakiya na Ayikuniya aar gwäꞌräjï ngwüjï kuy gegen aar aci Bulijing yoꞌrr ye aar oktalu aar gwe ꞌtüdä aar gatu kundiꞌrr poor gidi gündär aar ji ndi ari gwuma ayi. ");
INSERT INTO lro_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","A be ngwïkïrïjïn oꞌrada nono, ngwüdïꞌrälü aar oꞌre kündär. Bïgänü ngindenga Birnaba gwe aar ꞌdïꞌrï aar ele Därbï. ");
INSERT INTO lro_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","A Bulijinga Birnaba gwe ondaci ngwüjü ngwudi Därbïng ngwujaꞌri ngwanni ngwujaw a ngwüjï ngwonyadu ämnï aar ru ngwïkïrïjïn. Aar be kwodalu gïyündär yani Lijitra na Ayikuniya na Andakiya. ");
INSERT INTO lro_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ndi oꞌra gwegen aar orꞌtemaja ngwïkïrïjïnä aar je ojemeye nono ndi ari aar mätïnälü ꞌdiꞌdanu ndi ämnï Ngwaalu. Aar ari, “Yündä yonyadu yinje mbuji nunnu ar änï giyelenyanu yidi Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","A Bulijinga Birnaba gwe ꞌdïꞌrï aar äbrï mbumbung je giyiꞌdoonga yidi Ngwaalu ꞌdar aar je geꞌte aar ru yiꞌra yidi yiꞌdoonga yidi Ngwaalu yegen, anni ma aar määtä ngwädä aar otaci Ngwaalingalu aar je gïꞌtïjï Delenya kuyanu danni dima aar gu ämnädä. ");
INSERT INTO lro_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Anni ma aar ila Bïjïdïyä, aar gatana aar ila aar obana Bämbïlïyä. ");
INSERT INTO lro_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Anni ma aar ondaca ngwüjü ngwujaꞌri ngwe ngwanni ngwujaw ngenone kündär gani Berga, aar ila aar üllä kündär gani Ataliya. ");
INSERT INTO lro_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ngenone Ataliya, aar üꞌrü yaanu aar oꞌre Andakiya, kündär ganni gïꞌdïꞌräär gu a je ngwïkïrïjïn ükäjä aar je geꞌta kuyanu gidi yïmïꞌrü yidi Ngwaalu gwani yiiru giyoo yima aar je medaja ngeno. ");
INSERT INTO lro_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Anni ma aar obana Andakiya, aar gwäꞌräjï ngwïkïrïjïnälü gwüpäng aar je enggaci yiꞌral ꞌdar yanni yima je Ngwaalu ärrï ngindeng je le, na awa ndi ari ngwuma ïgïtïjï ngwüjü ngwuru Garany gay aar ämnï Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Aar jalu ngenone ngwïkïrïjïnïngä le ꞌdi a gaji olanu. ");
INSERT INTO lro_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","A ngwüjï ngwoko üllä Yäwüdïyä, aar üllädä Andakiya aar ji ndi enggaci ngwïkïrïjïnä aar je ci, “Manari ngaa lima ꞌti üꞌrïꞌtänä anaku ari gu dïmürä didi Müjä, ngaa laꞌti la gilang.” ");
INSERT INTO lro_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","A ngwujaꞌri ngwee gäbïcï Bulijing je Birnaba gwe aar büdï ngwäy ꞌtiꞌtir ndi aar le garnati. No a giꞌdoonga gidi Ngwaalu geꞌte Bulijing je Birnaba gwe ngwïkïrïjïnïngä le ngwoko nunnu aar allu Üräjälïm aar otaca ngwoꞌralu ngwükäjäär je na mbumbunga yiꞌral ye giyee. ");
INSERT INTO lro_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","A je giꞌdoonga gidi Ngwaalu geꞌte kay, anni ma aar ji ndi ele ngwaalu ngwudi Bunijiyang na Jamra, aar ondaci ngwüjü ndi ari awa ngwüjï ngwanni ngwuru Garany ngwuma gwurli ngwuma ru ngwïkïrïjïn. A ngwujaꞌri ngwee gäbïcï ngweengga aar jayanu gwulleny. ");
INSERT INTO lro_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Anni ma aar obani Üräjälïm, a je giꞌdoonga gidi Ngwaalu na ngwooꞌra ngwükäjäär je mbumbunga le geꞌtalu yïrnü, a je Bulijinga Birnaba gwe enggaci yiꞌral ꞌdar yanni yima je Ngwaalu ärrï ngindeng je le. ");
INSERT INTO lro_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","A be ngwïkïrïjïn ngwoko ngwanni ngwuru Ngwübärrïjï aar dünälä aar ari, “Ngwüjï ngwuru Garany ngwa üꞌrïꞌtänï aar ꞌdengenaji Yobo yidi Müjä.” ");
INSERT INTO lro_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","A be ngwooꞌra ngwükäjäär je na mbumbunga jalu gwüpäng ndi otajidalu giyiꞌral giyee. ");
INSERT INTO lro_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Anni ma aar otajidalu ꞌdi a gaji olanu, a Butruj ꞌdïꞌrälü ngwuje ondaci, “Ngweengga, ngaa lïlïngïdï ndi ari gaji gwerre gima ele, Ngwaalu ngwäbrï nyi nunnu a ngwüjï ngwuru Garany ꞌdingini gilinglalu lüny ngwujaꞌri ngwanni ngwujaw aar ämnï Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ngwaalu ngwanni ngwülïngïdï ligor lidi dïjï, ngwinggidu ndi ari ngwuming je ämnï anni mung je ätädä Lïgïꞌrïmä lanni Lijuꞌru, nono ätädäär nje gu. ");
INSERT INTO lro_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ngwaalu ngwaꞌti nje geꞌtaja gay geꞌte ngindenga le ndi ari gwügäꞌrïdï yigor yegen yanni yiki ämnï gwe gwegen gwanni gwuma aar gwe ämnï ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","A be gweneno, ange gwuru ngaa be ïdäjï Ngwaalinga üpï gwe ngwïkïrïjïnä ngwuru Garany yunggu giyigoꞌro yanni yaꞌti ar je burna na ngwügüürnängä ngwege ndi üpïnï. ");
INSERT INTO lro_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Bärï! Alanga lämnä ndi ari yïmïꞌrü ye yidi Deleny dege dani Yicu a lïgïlängïdïnä, anaku gïlängïdïnäär gu ꞌto.” ");
INSERT INTO lro_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","A ngwüjï ꞌdar kiꞌdoonga gwugwundi aar geraji Birnabang je Bulij gwe länï ndi ondaji gwani yiꞌremna yidi yiima na allalu ndïr gwanni gwärrü Ngwaalu ngwüjänü ngwuru Garany ngindeng je le. ");
INSERT INTO lro_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Anni ma aar medaji ngwujaꞌri, a Yagub ꞌdïꞌrï ngwüdünälä ngwondaji ngwari, “Gerajiny länï ngweengga. ");
INSERT INTO lro_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Jamaan gwani Butruj gwondaci nje ndi ari awa Ngwaalu gwerre gwerre ngwinggida ligor lüngün uti gwe ngwüjü ngwüjänü ngwuru Garany ngwuje geꞌtaji ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Yïjïr yanni yallija je ngwïjïr yädï ngwujaꞌri ngwee anaku üllïnäär gu ndi ari, ");
INSERT INTO lro_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ma aar ele giyee äny gwoꞌra nggwa gwäꞌräjï yelenyalu yidi deleny dani Däwüd. Yanni yima ke yinje oda mana, a yinje gwäꞌräjälä mana yanni yïpänälü, ");
INSERT INTO lro_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ndi ari ngwüjï ngwanni ngwuma ïꞌdälü, aar mïnï Delenya, na ngwüjï ꞌdar ngwanni ngwuru Garany ngwanni ngwapu ngwürïny ngwüny, a gu Deleny ari danni dati ärrï yiꞌral giyee’ ");
INSERT INTO lro_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","yanni yima linginni ꞌdar ꞌtuꞌtu gwerre gïdlä.” ");
INSERT INTO lro_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","A Yagub ari, “Yäy gu no, ngwänggädï ndi ari aaꞌti a la üpï ngwüjü ngwuru Garany ngwanni ngwo ndi oꞌraca Ngwaalinga yiꞌral yïnï. ");
INSERT INTO lro_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ar je be ükäcï ngwujaꞌri ar je ci aar gäbïcï enying ngwony ngwudi dïdülä na yïjïn aar gäbïcï enying ngwüdï ngwudi ngwony ngwugogornyana na yïn. ");
INSERT INTO lro_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ndi ari Yobo yidi Müjä yündäjïnä yomon ꞌdar ꞌtuꞌtu gwerre gïyündär ꞌdar aar je uli ngwämrä giyomon ꞌdar yidi gomon Kwoꞌra täꞌrïl.” ");
INSERT INTO lro_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","A ngwooꞌra ngwükäjäär je mbumbunga le na giꞌdoonga ꞌdar gidi Ngwaalu jalu aar gwalli ngwüjü rom (2) ꞌdenggegenanu, Yäwüdä gwani Barjabaj na Jiliwanij, ndi ari liru yiꞌra ngweengganu, aar je ükäj Birnabanga le na Bulij aar ele Andakiya. ");
INSERT INTO lro_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Aar je ätädänï ngwujaꞌri ngwee, “Ngwujaꞌri ngwee ngwïndï ꞌdänggärï liru ngweengga ngwalu ngwuru ngwooꞌra ngwükäjäär je na mbumbunga. Ngwükäcärä je liru ngwïkïrïjïnä ngwuru Garany kündär gidi Andakiyang, na ngwaalu ngwani Jürïyä na Kïlïkïyä. Laganna je. ");
INSERT INTO lro_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Änyängä liꞌdingina ndi ari ngwüjï ngwoko ngwïndï ꞌdänggärï ngwaꞌti nje ükäjü ngwujaꞌri ngwe ngwere, ara je lagajanu ara je lagaci yaꞌranyanu yalu ngwujaꞌri ngwe ngwondajaar je. ");
INSERT INTO lro_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nyii be jalu nyii gekajida ndi ari nyii gwalla ngwüjü ngwoko ara je ükäcä. Aar ila Bulijinga le na Birnaba liru ngwumaad ngwärï ");
INSERT INTO lro_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","lanni lïgätï yigoꞌro yegen mbüny gwani ngwürïny ngwudi Delenya dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yäy gu no, lükäcä je Yäwüdäng je Jiliwanij gwe ndi ari ara je ondaci ngwulem ngwe ngwujaꞌri ngwanni ngwüllïjärä je ngene. ");
INSERT INTO lro_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ndi ari yiru gu Gïlïgïꞌrïm lanni Lijuꞌru na ꞌdänggärï ndi ari aaꞌti la üpïyï nïng gwere ba be aar be ru giyee ꞌdogo nda je ärrï. ");
INSERT INTO lro_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Gäbïcär enying ngwony ngwudi mïꞌrïnï nono ngwudi dïdülä na yïn na ngwüdï ngwudi ngwong ngwugogornyana na yïjïn. Ngaa la elelle mama manari ngaa lima gäbïcï yiꞌral giyee. Jar balu.” ");
INSERT INTO lro_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Aar ꞌdïꞌrï aar üllï Andakiya, aar gwäꞌräjï giꞌdongalu gidi Ngwaalu gwüpäng aar je ätädä ngwujaꞌri ngwoo ngwüllïnä. ");
INSERT INTO lro_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Anni ma ngwüjï uli ngwujaꞌri, a je ngwujaꞌri orꞌtemaji aar jayanu gwulleny. ");
INSERT INTO lro_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","A Yäwüdängä Jiliwanij gwe lanni liru ngwïjïr ondaci ngweengga aar je orꞌtemaji aar je ojemeye nono ngwujaꞌri ngwe ngwonyadu. ");
INSERT INTO lro_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Anni ma aar jalu ngenone Andakiya yomon yonyadu, a je ngweengga geꞌta kay onjaci gwe gwudi adatalu aar oꞌra ngwüjï ngwanni ngwükäjä je. ");
INSERT INTO lro_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","A be Bulijinga Birnaba gwe jalu ngwüjïngä le ngwonyadu Andakiya, aar gu enggaci ngwüjü aar je ondaci ngwujaꞌri ngwudi Deleny. ");
INSERT INTO lro_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Aji a gaji ele cong, a Bulij ci Birnabang no, “Nda ꞌdïꞌrï nda kwoyalu ndi nda ombaja ngweengga gïyündär ꞌdar yanni yondaja nda gu ngwujaꞌri ngwudi Deleny nda je ombaja ndi ari gilo lïndï awa.” ");
INSERT INTO lro_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","A be Birnaba nani ndi aar apani Yuwanang gwani Murkuj, ");
INSERT INTO lro_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","a be Bulij engga ndi ari yaꞌti gu jaw ndi aar apani ngindeng ndi ari ligataning je ngwoꞌre kay ngwaalu ngwani Bämbïlïyä aar ꞌti le ju giyiiru. ");
INSERT INTO lro_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Aar gu garnati gwurꞌtal ꞌdi aar badatanu. A Birnaba apani Murkujing aar gwe üꞌrü yaanu aar ele Gabruj. ");
INSERT INTO lro_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","A be Bulij apani Jiliwanijing aar gwe ꞌtü aar ele. A je ngwïkïrïjïn geꞌte kuyanu gidi yïmïꞌrü yidi Deleny. ");
INSERT INTO lro_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ngwele Jürïyä na Kïlïkïyä, nggu ojemeye yiꞌdonga nono yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","A Bulij ꞌdïꞌrï ngwele Därbï ngwube aji ngwele Lijitra gwuju gu dooꞌra deꞌte didi Yicu dani Timijawuj, nanni gwüngün gwuru Dïyäwüd gwuru dïkïrïjïn a be papa gwüngün ru Dïgïrïg. ");
INSERT INTO lro_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ngweengga ngwudi Lijitrang na Ayikuniyang ngwati ondaji ndi ari Timijawuj gwati elelle dïlä dijaw. ");
INSERT INTO lro_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Anni ma Bulij ru gwadi apani Timijawujing gïdïlä düngün, ngwüꞌrïdä gwani Ngwüyäwüd ngwanni ngwati ji ngwaalu ngwoo ndi ari ngwülïngïdï ꞌdar ndi ari papa gwüngün gwuru Dïgïrïg. ");
INSERT INTO lro_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ndi ele dïlä degen kündär kündär, aar ätädä ngwüjü ngwujaꞌri ngwanni ngwaru ngwe ngwooꞌra ngwükäjäär je mbumbunga le Üräjälïm nunnu aar ngwe elelle. ");
INSERT INTO lro_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","No, ati yiꞌdoonga yidi Ngwaalu ojeme nono ndi ämnï Ngwaalu aar gendani giyiꞌra yomon reny. ");
INSERT INTO lro_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","A Bulijinga ngwooꞌra ngwe ngwanni ngwïndäär ngwe, aar ele dïlä ngwaalu ꞌdar ngwudi Bïrïjïyäng na Galatiya. A je Lïgïꞌrïm lanni Lijuꞌru etaci ndi ondaji ngwujaꞌri ngwe ngwudi Ngwaalu ngwaalu ngwani Ajiya. ");
INSERT INTO lro_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Anni ma aar obani kiꞌraany gidi ngwaalu ngwani Majiya, aar nani ndi änï ngwaalu ngwani Bïjïnïyä, a je be Lïgïꞌrïm lidi Yicu ümïnïcï. ");
INSERT INTO lro_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","No, aar ele aar millidi Majiya gwe aar üllï kündär gani Truwaj. ");
INSERT INTO lro_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ngenone dilu de, a dilingid eny Bulijing ngwengga dilingidu guru gidi Majiduniyang gïdünädälä ngwugeraci guy ngwuci, “Dambida Majiduniya nje gataji düwä.” ");
INSERT INTO lro_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Anni ma Bulij engga yiꞌral giyee dilingidu, nyii ꞌdïꞌrï nyii ji mama puprang ladi ele ngwaalu ngwani Majiduniya, nyii geꞌte ndi ari Ngwaalu ngwümïnï nje ndi ondaci ngwüjü ngenone ngwujaꞌri ngwe ngwüngün ngwanni ngwujaw. ");
INSERT INTO lro_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ngenone Truwaj, nyii ji mama ladi üꞌrü yaanu bälükä gwe nyii ada ngwaalinga ngwani Jamutraj na bïgänü nyii obani kündär gani Niyabulij. ");
INSERT INTO lro_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ngenone nyii oꞌre nyii ꞌdïꞌrï nyii ele ꞌdi nyii obani Bïlïpï ngwaalu ngwümätï gu ngweleny ngwudi Rumang yelenya kündär geꞌte gipa gidi Majiduniyang. Nyii gu jalu ngenone yomon yoko. ");
INSERT INTO lro_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Komon ganni giru Kwoꞌra täꞌrïl, nyii ꞌtü poor kündär nyii ele gidibirta, nyii geꞌtaji ndi mbuji ngwaalinga ngwudi otaci Ngwaalingalu. Nyii jalu nyii ondaci ngwayu ngwanni ngwoꞌradalu ngenone. ");
INSERT INTO lro_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","A nje daw deꞌte ꞌdingini ngwawanu dani Lïdïyä dati ji kündär gani Tiyatira dati ellang ngwureda ngwuꞌri dati äpïjï Ngwaalinga yobo. A Deleny ïgïtï ligor lüngün ndi ämnï ngwujaꞌri ngwondaja je Bulij. ");
INSERT INTO lro_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Anni ma aar nyïnyïnï yaw ye ngwüjï ngwe ngwudi ngwuꞌdun ngwüngün, aar nje urnidi gïyïrnü. Ngwari, “Manari ngaa lari äny gwuma ru dïkïrïjïn ꞌdidanu Gideleny, ilar ngaa jalu ꞌdunu ꞌdünggüny.” Ar nje päcälü ꞌdi nyii ele. ");
INSERT INTO lro_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Gomon geꞌte anni minyii ji ndi ele ngwaalu ngwudi otaci Ngwaalingalu, nyii mbudi geranga le giru dïnäd gätï ngwäy ngwati ngwe engga yiꞌral yanni yadi ji gweere. Ating mbüjïjï ngworta ngwüngün ngwüꞌrïnyä ngwonyadu ätï gwe ngwäy. ");
INSERT INTO lro_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","A gera nggee gwujani Bulijingalu na änyängä, ating ärï dula ngwari, “Ngwüjï ngwee ngwuru ngwïnäd ngwudi Ngwaalu ngwanni ngwupa ngwudi geralang, ngwondaca je aar je enggaci gay gidi gilang.” ");
INSERT INTO lro_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ati aar nje gwoda no ꞌdi ngwonje yomon. ꞌDi a ligor ape Bulijing ngwugwurlalu ngwugirinya dïꞌrïllä ngwuci, “Ngwürïny ngwe Yicu Kirictu, ꞌtüdï ꞌdünggüngünänü!” Gaji nggoo geꞌte geꞌte a dïꞌrïllä gatalu. ");
INSERT INTO lro_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Anni ma ngwoorta ngwüngün engga ndi ari gay gidi mbuji ngwüꞌrïnyä gima längïtïnï, aar määtä Bulijing je Jiliwanij gwe aar je ogtalu aar le ele ngweleny ngwaalu ngwudi ngwiliny. ");
INSERT INTO lro_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Aar je apada ngweleny ngwudi gündär aar ari, “Ngwüjï ngwee ngwuru Ngwüyäwüd ngwuma gatu ngwüjü ngwege kündär gïyäränü ");
INSERT INTO lro_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ngwondaja dïmürä de diru drü ꞌdengge ndi ape liru Ngwuruman.” ");
INSERT INTO lro_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","A ngwüjï oꞌrajidi aar ꞌdïꞌrä Bulijing je nono Jiliwanij gwe a ngweleny ngwudi gündär ari aar je gwalla ngwureda aar je pï. ");
INSERT INTO lro_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Anni ma aar je pï gwulleny aar je ape aar je gatu korkon aar ci dangida diru giꞌra ngwuje arngaci mama. ");
INSERT INTO lro_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Anni ma gu dangida ꞌdingini no, ngwuje ape ngwuje gatu gïdrü gweere aar je gwüꞌrïnggïlï yora. ");
INSERT INTO lro_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Dilu de diligeny danu a Bulijinga Jiliwanij gwe ji ndi otaci Ngwaalingalu aar elnge delnga didi Ngwaalu, a je ngwüjï ngwujaar le korkon ji ndi geraji ngwänï. ");
INSERT INTO lro_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","No a ngwaalu lagadalu gwulleny ꞌtuꞌtu korꞌdalu gidi gorkon. Puprang no, a ngwängïr ꞌdar ngwudi gorkon gwallanalu aar ïgïtïnï a yuꞌrung ꞌdar yigekana ye ngwüjälü üꞌrïꞌtïnï. ");
INSERT INTO lro_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","A dangida ꞌrita. Anni mung engga ngwängïrü ngwudi gorkon ngwujalu mbüny, ngwugwalli galala gwadi dügïnï ngwayi nunnu gwuju ndi ari ngwüjï ngwuma ꞌtü korkon ngwuma abri. ");
INSERT INTO lro_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","A be Bulij aw dulu de gwulleny ngwuci, “Aaꞌti a gwärrï ligoꞌro lunga yiꞌral yere, änyängä ꞌdar gilo ngene!” ");
INSERT INTO lro_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","A dangida utalu ndi aar ätä lïgä ngwule änï puprang gïdrü, ngwudidiꞌri yedenyo ngwadaci Bulijingalu Jiliwanij gwe giyoranu. ");
INSERT INTO lro_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ngwuje be okta poor ngwuji otacalu, “Lani ngwoorta, äny gwadi ärrï ange nunnu nyi gïlängïdïnï?” ");
INSERT INTO lro_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Aar ci, “Ämnä Gideleny dani Yicu, nga gwa be gïlängïdïnï, nga na ngwüjï ngwunga.” ");
INSERT INTO lro_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Aar be ondaci ngwujaꞌri ngwudi Deleny ngwüjïngä le ꞌdar ngwüngün. ");
INSERT INTO lro_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kaji nggoo dilu de ndoo, a dangida ape Bulijing je Jiliwanij gwe ngwuje uyi ngwämä nono. No aar je nyïnyï gomon nggoo ngwüjï ngwe ngwüngün. ");
INSERT INTO lro_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ngwuje ape ꞌdunu ngwuje ätädä aar eny. A nginde jayanu gwulleny ndi ari nginde gwuma ämnï Ngwaalu ngwüjï ngwe ngwüngün ꞌdar. ");
INSERT INTO lro_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Anni ma ngwaalu uꞌri, a ngweleny ngwudi gündär ükäjïdä ngwooꞌra ngwengen gidangida aar ci, “Gätï ngwüjälü ngwoo.” ");
INSERT INTO lro_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","A dangida ci Bulijing nu, “Ngweleny ngwari ara je gatalu nga nga Jiliwanij gwe. Gweneno, ngaa la be ele. Ïndär be ladatalu.” ");
INSERT INTO lro_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","A be Bulij ci ngwüjü ngwoo ngwükäjäär je nu, “Lïpïdï nje ngwäyänü ngwüjï aar nje ꞌti pïdïyä yelenya gwerre gwerre nyii be ru Ngwuruman, aar nje gatu korkon. A be gweneno aar be ru ladi nje linynyi yuꞌrimi? Bärï! Aar ila ngindenga yigoꞌro ye yegen aar nje ꞌtüyä poor aar nje geꞌte kay.” ");
INSERT INTO lro_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","A ngwüjï ngwoo ngwükäjäär je oꞌre aar ondaci ngwelenya, anni ma aar ꞌdingini ndi ari Bulijinga Jiliwanij gwe liru Ngwuruman, aar allalu miꞌdung. ");
INSERT INTO lro_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Aar ila aar ci juba, aar je ꞌtüyä korkon aar je päcälü ndi ari aar ele aar gatani gündärä. ");
INSERT INTO lro_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Anni ma Bulijinga Jiliwanij gwe ꞌtüdä korkon, aar ele ngwuꞌdun ngwudi Lïdïyä, ngenone aar gu mbudi ngwïkïrïjïnïngä le aar je orꞌtemaji aar be ꞌtü aar ele. ");
INSERT INTO lro_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Anni ma Bulijinga Jiliwanij gwe ꞌtüdä gïyündäränü yani Amibulij na Abuluniya, aar ila kündär gani Täjlänükï, ngenone ngwämrä ngwuju gu ngwudi Ngwüyäwüd. ");
INSERT INTO lro_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Anaku äbräjä gu Bulij, ngwele ngwänï ngwämrä, gomon Kwoꞌra täꞌrïl, yomonanu täꞌrïl, aar ngwe ombaji kitabanu gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ngwuje enggaci aar je engga ngwäy yanni yüllïnä kitabanu ndi ari gwanni Gwubrutaar yelenya gwa yündä mbuji ꞌdi gwayi gwa ꞌdïꞌrä giyiꞌranyanu. Ngwuje ci, “Yicu nggwee gwondaca je gwe, gwuru gwanni Gwubrutaar yelenya.” ");
INSERT INTO lro_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","A Ngwüyäwüd ngwoko gatu yigoralu ngwujaꞌri aar gwuji Bulijing je Jiliwanij gwe, na ꞌto lonyadu lanni liru Ngwügïrïg lati denya Ngwaalinga ngwaw ngwanu ngwoko ngwulinginna ngwonyadu. ");
INSERT INTO lro_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","A be yigor eny Ngwüyäwüdänü, aar gwäꞌrännï ngwüjü nono ngwïndï giyebedalu mbüny aar oꞌrajidi kiꞌdu aar ꞌdïꞌrï güündä ge kündär. Aar odena ngwuꞌdun ngwudi gur gani Yajun aar ji ndi ari Bulijinga Jiliwanij gwe gilo gu nunnu aar je ꞌtücä ngwüjü poor. ");
INSERT INTO lro_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","A be anni ma aar je ꞌti mbuju, aar ꞌdïꞌrï aar okta Yajuningalu ngwïkïrïjïnïngä le ngwoko aar le ila ngweleny ngwudi gündär aar ürrï dula aar ci ngwelenya, “Ngwüjï ngwee ngwärrü yiꞌral yanni yiki ngwaalu ꞌdar ꞌdi aar obana ngene nunnu aar nje lagaci yiꞌralanu ꞌto. ");
INSERT INTO lro_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","A je be Yajun ülläjälü ꞌdunu ꞌdünggüngün. Ngwügätï ngwujaꞌri mbüny ngwudi Deleny didi ngwelenyinga Ruma dani Gayijar aar ari deleny deꞌte pu ndo diꞌter dicaar Yicu.” ");
INSERT INTO lro_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Anni ma ngwüjï ngwonyadu na ngweleny ngwudi gündär ꞌdingini ngwujaꞌri ngwee, a je güündä ape. ");
INSERT INTO lro_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Aar gäbïcï Yajuning na ngwüjï ngwoko geꞌte ngwüꞌrïnyä aar je gatalu aar ele. ");
INSERT INTO lro_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Anni ma dilu de ru, a ngwïkïrïjïn ape Bulijing je Jiliwanij gwe aar je dinga aar ele kündär gani Bïrïyä. Anni ma aar obani ngenone, aar ꞌdïꞌrï aar ele ngwämrä ngwudi Ngwüyäwüd. ");
INSERT INTO lro_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ngwübïrïyä ngenone ngwujayana drü ngwüjï ngwudi Täjlänükïng, ndi ari ngwämnä ngwujaꞌri puprang yigor ye yïbüdänü ati aar ombaji ngwujaꞌri kitabanu gidi Ngwaalu yomon reny ndi ari ngwujaꞌri ngwanni ngwondaja je Bulij ngwuru gu ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","A Ngwüyäwüd ngwonyadu ämnï na ꞌto ngwaw yiꞌra yonyadu ngwulinginna ngwuru Ngwügïrïg na ngwur ngwonyadu ngwuru Ngwügïrïg. ");
INSERT INTO lro_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Anni ma Ngwüyäwüd ngwudi Täjlänükïng lenge ndi ari Bulij nggwo ndi ondaci ngwüjü ngwujaꞌri ngwe ngwudi Ngwaalu ngenone Bïrïyä ꞌto, aar ꞌdïꞌrï aar ele ngenone ndi gwogaji ngwüjü. ");
INSERT INTO lro_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Puprang a ngwïkïrïjïn ape Bulijing aar dinga ngwele kïmämü gidi yaw, a be Jiliwanijinga Timijawuj gwe jalu Bïrïyä. ");
INSERT INTO lro_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","A ngwüjï ngwanni ngwuma aar ele Bulijinga le, aar ape aar gwe obani Ätïnä aar be oꞌra aar apana ngwujaꞌri ndi Bulij ndi ari a Jiliwanijinga Timijawuj gwe borna puprang aaꞌti la jani. ");
INSERT INTO lro_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Anni ma je Bulij ji ndi dünïcï kündär gani Ätïnä, ngwuke nono anni mung engga gündärä gonyadu gu yiꞌremnanu. ");
INSERT INTO lro_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ngwüꞌdïꞌrï aar jalu ngwämrä na ngwaalu ngwudi ngwiliny giyomon giyomon aar ondaji Ngwüyäwüd ngwe na Ngwügïrïg ngwanni ngwüdïnyädï Ngwaalinga na ngwüjï ngwanni ngwati ila ngenone. ");
INSERT INTO lro_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","A ngwubalbaj ꞌdïꞌrï ngwucaar je Ngwübïkïrï na Ngwujoyeg aar le garnati. A loko utalu aar ari, “Gwadi araa nggwee gwonyadu ngwujaꞌranu?” A loko gatu ngwujaꞌri aar ari, “Nggwo gwuru nono mung ondaji bayil gwe gwïndï poor.” Laru gu no ndi ari Bulij gwondaju ngwujaꞌri ngwe ngwujaw ngwani Yicu na ngwani ꞌdïꞌrï giyiꞌranyanu. ");
INSERT INTO lro_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Aar be ape aar gwe ele ngwaalu ngwudi oꞌrajidalu ngwani Ariyubaguj, aar gu ci nu, “Enggaci nje ꞌdi ngwujaꞌri ngwee ngwuyang ngwuru ange ngwondaji je nje lenge? ");
INSERT INTO lro_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nga nggwo gwondaja ngwujaꞌri ngwuꞌdingini nje yïrnü ngwunani nje ndi nje lenge ngwuru ange.” ");
INSERT INTO lro_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Ngwüjï ꞌdar ngwudi Ätïnäng na ngwüjï ꞌdar ngwuꞌter, ngwanni ngwati ji ngenone, ngwati ꞌti ärrü yiꞌral yere ngwati jalu ꞌdogo yomon reny ndi ondaji aar ꞌdingini ngwujaꞌralu ngwere ngwanni ngwïndï girem ngwuru ngwuyang.) ");
INSERT INTO lro_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","A be Bulij ꞌdïꞌrälü ngwüdünäcï ngwüjälä ngwudi ngwämrä kündär gani Ariyubaguj ngwari, “Nga nga gilee lidi Ätïnäng, nggwänggädä je ngwaalu ꞌdar ngaa liru ngwüjï ngwudi yobo. ");
INSERT INTO lro_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ndi ari anni landinyalu nyi ombajidalu mama ngwong ngwudi yobo yalu, ꞌdi nyi mbuji dagada düllïnä ngwujaꞌri ngwee ngwaru, NGWAALU NGWANNI NGWAꞌTI LINGINNA. Ngwaalu ngwanni ngwata je ortada ngaa je ꞌti be lïngïdï, ngwuru ngwanni ngwada je ngwe ondaci gweneno.” ");
INSERT INTO lro_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ngwuje ci, “Ngwaalu ngwanni ngwugeꞌta dïdläyü aar geꞌte ngwony ꞌdar ngwanni ngwo gïdïdlä, ngwuru Deleny didi gere na dïyäng, Ngwaalu ngwanni ngwati ꞌti ju ngwuꞌdunanu ngwodana ngwuy ngwe ngwudi dïjï dümnä. ");
INSERT INTO lro_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ngwati ꞌti ïrnïdï gony ge gere ndi ari aar je gendaci guy, nono ma aar ni nyangiralu, ngwuru Ngwaalu ngwanni ngwätädä ngwüjü ꞌdar miding aar je ätädä lingina na yiꞌral ꞌdar. ");
INSERT INTO lro_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Dïjï de deꞌte pu digeꞌteng nggu ꞌtüyä yïïlü ꞌdar yidi ngwüjï anaku rar gu, nunnu aar ji ngwaalu ꞌdar gïdïdlä. Nginde gwuru gwanni gwati lenge gaji ganni gïgïꞌtïjïng je ngwulenge ngwaalinga mama ngwanni ngwügïꞌtïjïng je nunnu aar gu ji. ");
INSERT INTO lro_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ngwaalu ngwärrü yiꞌral giyee nunnu a ngwüjï mïnï aar gwe utalu aar mbuji. Ngwaalu ngwaꞌti ola ngwaalinganu ma ar je mïnï ngwujalu gito gito ꞌdengge ꞌdar. ");
INSERT INTO lro_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Anaku aru gu dïjï deꞌte ndi ari, ‘Nginde gwe a limidu ar gwe ele ar gwe ji.’ Anaku aru gu ngwüjämbïr ngwoko ngwalu ndi ari, ‘A liru gilinge güngün ꞌto.’ ");
INSERT INTO lro_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Yäy gu no anni rar gilinge gidi Ngwaalu, aaꞌti a la geꞌte ndi ari Ngwaalu ngwanni ngwuru lïgïꞌrïm ngwuru nono yiꞌremna yiru dab aar ru buta na yoꞌrr, nono ma je dïjï dümnä geꞌte aar je jaꞌrima ngwuy ngwe. ");
INSERT INTO lro_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Gwerre ngwaꞌti gïꞌtïjä yogonga giyee ngwäy a be gwenene gwondaca ngwüjü ꞌdar ngwaalu ꞌdar ndi ari aar joꞌrenyana. ");
INSERT INTO lro_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ndi ari ngwuma geꞌte gomon ganni gading ge otaci ngwüjälü ꞌdar gïdïdlä übïdänü gwe dïjï de danni däbrïng ngwugeꞌte. Gwuma enggaci ngwüjü ꞌdar yima aar je engga ngwäy ngwe ndi ari gwäbrüng ngwugeꞌte, anni ngwuming ꞌdïꞌrïyälü giyiꞌranyanu.” ");
INSERT INTO lro_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Anni ma aar ꞌdingini ngwujaꞌri ngwani ꞌdïꞌrï giyiꞌranyanu, a loko calu mireny, a be loko ari, “Änyängä linana ndi ar ang dingini ngwujaꞌri ngwee mana.” ");
INSERT INTO lro_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","A gaji nggoo, a Bulij ꞌdïꞌrï ngwugatani ngwämrä kündär. ");
INSERT INTO lro_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","A be ngwüjï ngwoko ämnï aar gwuji Bulijing. ꞌDenggenanu gur gani Diyaniyuj ngwelenyanu ngwudi ngwaalu ngwani Ariyubaguj ngwudi oꞌrajidalu, na daw deꞌte ꞌto dani Damarij, a loko liꞌter. ");
INSERT INTO lro_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Anni ma yiꞌral medadi giyee, a Bulij gatani Ätïnäng ngwüꞌdïꞌrï ngwele Küründüj. ");
INSERT INTO lro_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ngenone aar mbudi gur ge giru Dïyäwüd gani Äkïllä gïlïngïnä ngwaalu ngwani Bunduj, gïndär daw de düngün girem dani Bärjïkïllä ngwaalu ngwani Italiya aar ila Küründüj. Ndi ari deleny didi ngwelenyinga Ruma dani Kiludiyuj dïꞌtüyä ngwujaꞌri ndi ari a Ngwüyäwüd ꞌdar gatani Rumang. A Bulij ꞌdïꞌrï ngwele nding je ombaja. ");
INSERT INTO lro_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Aar le jalu aar le ape yiiru ndi ari yiiru yüngün yiru yeꞌte yeꞌte nono yegen lati ugꞌri ngwureda ngwudi yäꞌtä. ");
INSERT INTO lro_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ating be ꞌtü komon giru Kwoꞌra täꞌrïl ngwele ngwämrä aar otajidalu, ngwümïnï ndi gwäꞌrä Ngwüyäwüd na Ngwügïrïg. ");
INSERT INTO lro_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Anni ma Jiliwanijinga Timijawuj gwe obana lïndï ngwaalu ngwani Majiduniya, a Bulij geꞌtaji ligoꞌro lüngün ꞌdar ndi ondaci Ngwüyäwüd ngwari Yicu gwuru gwanni Gwubrutaar yelenya. ");
INSERT INTO lro_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","A be anni ma Ngwüyäwüd ꞌdonya ngwujaꞌri ngwondaja je Bulij, aar ondaji ngwujaꞌri ngwaꞌti jaw, a Bulij ꞌdïꞌrï ngwuje düdïrä ngwureda nono ngwüngün ngwuje ci, “Nggwuma gwalli ngwuy ꞌdanggalu, yidi yigoꞌro yalu yiru, ꞌtuꞌtu komon gidi gweneng, nggwele Karany.” ");
INSERT INTO lro_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","A be Bulij ꞌdïꞌrï ngwugatani ngwämrä ngwele ngwuꞌdun ngwudi gur gani Tïtüj Yujituj gwuru Garany gwati orta Ngwaalinga, ngwuꞌdun ngwüngün ngwuju gito gito ngwuꞌdun ngwudi ngwämrä. ");
INSERT INTO lro_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","A gur gani Kirijibuj giru giꞌra gidi ngwämrä ngwoo aar ämnï ngwüjï ngwe ngwudi ngwuꞌdun ngwüngün Gideleny. Na ngwüjï ngwuꞌter ngwonyadu ngwudi Küründüjïng ngwanni ngwuma ꞌdingini aar ämnï Ngwaalu aar je nyïnyï yaw ye. ");
INSERT INTO lro_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Dilung deꞌte a Deleny dani Yicu ondaci Bulijing dilingidu ngwuci, “Aaꞌti yedeny yang eny, orꞌtemaja nga ondaji aaꞌti nga gwa gwugwundi. ");
INSERT INTO lro_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nda gilo a dïjï dere daꞌti dang akani nono, äny nggwo gwätï ngwüjü ngwonyadu kündär nggee.” ");
INSERT INTO lro_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","No, a Bulij jalu ngenone ꞌdi ngwape dïdläyü na ngwüüwäyü nyärläl, ndi enggaci ngwüjü ngwujaꞌri ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Anni mätï deleny dani Galilu yelenya ngwaalu ngwani Akayiya, a Ngwüyäwüd ngwudi Küründüjïng gekajidi ꞌdar gwüpäng aar odena Bulijing nono aar määtä aar gwe ila ngwaalu ngwudi pï yelenya. ");
INSERT INTO lro_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Aar üꞌrïdä yiꞌral nono aar ari, “Gur nggee gati gwäꞌrï ngwüjü aar äpïjï Ngwaalinga yobo gay ge gaꞌti aar ïndï yobo ye yege.” ");
INSERT INTO lro_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Anni ma Bulij ji gito gwadi ondaji, a deleny dani Galilu ci Ngwüyäwüd nu, “Adinari ngaa länggädädï guru nggee yiꞌral nono yere yanni yiki gwulleny, yaadi gu aw nda je ꞌdingini. ");
INSERT INTO lro_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","A be anni rar ꞌdogo ngwujaꞌri, na ngwürïny aar ru yani yobo yalu, ya je be ombaji yigoꞌro ye yalu. Nggwaꞌti gwa pï yelenya giyiꞌral yiru gu no.” ");
INSERT INTO lro_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ngwuje be linynya ngwaalu ngwudi pï yelenya aar ꞌtüdä poor. ");
INSERT INTO lro_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","A ngwüjï ngwoo ngwonyadu gwurlada guru nono gani Jujitanuj giru giꞌra gidi ngwämrä aar pï gito gito ngwaalu ngwudi pï yelenya a je gu ꞌti deleny dani Galilu geꞌtaja ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","A Bulij jalu ngenone Küründüj gwooko, ngwube gatani ngwïkïrïjïnä ngwüꞌrü yaanu ngwele Jürïyä, aar ele Bärjïkïllä gwe na dur düngün dani Äkïllä. A be gwerre gwerre nding ele, ngwüwädïnï giꞌra kündär gani Kanggiriya gwani pï yiꞌrany ngwujaꞌri ngwanni ngwaru ngwe. ");
INSERT INTO lro_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Aar obana Abijuj, a gu Bulij gatani Bärjïkïllängä je dur de düngün dani Äkïllä ngwüꞌtü ngwele ngwämrä ndi aar ondaji Ngwüyäwüd ngwe. ");
INSERT INTO lro_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Aar ci gwaadi aar le jalu ngenone yomon yonyadu ngwube ꞌdonya. ");
INSERT INTO lro_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","A be anni mung ꞌdïꞌrï ngwele, ngwuje be cani nu, “Manari Ngwaalu ngwuma ämnï äny gwa oꞌra.” Ngwüꞌdïꞌrï ngwugatani gündärä gani Abijuj ngwele. ");
INSERT INTO lro_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Anni mung üllï kündär gito kïmämü gani Gäyïjärïyä, ngwallu ngwaganna giꞌdonga gidi Ngwaalu Üräjälïm, ngwube üllï Andakiya. ");
INSERT INTO lro_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Anni mung jalu yomon cong ngenone Andakiya, ngwüꞌdïꞌrï ngwele gïyündär mbüny mbüny ngwaalu ngwani Galatiya na Bïrïjïyä, ating gu orꞌtemaji ngwïkïrïjïnä. ");
INSERT INTO lro_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Gaji nggoo a gur geꞌte giru Dïyäwüd gani Abuluj gidi gündär gani Ïjïkändärïyä gubu kinene ngwulenge ngwujaꞌri ngwudi gitab gidi Ngwaalu mama. Ngwube ila kündär gani Abijuj. ");
INSERT INTO lro_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nginde genggacaar ngwulenge ngwujaꞌri ꞌdar ngwani gay gidi Deleny. Ngwondaji yiima ye gwulleny ngwenggaci ngwüjü ngwujaꞌri ngwani Yicu mama. Ngwube lenge ꞌdogo nyïnyïnïng gwudi Yuwana. ");
INSERT INTO lro_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ngwüꞌdïꞌrï gwuꞌranu ngwondaji ngwämrä. Anni ma Bärjïkïllängä dur de düngün dani Äkïllä ꞌdingini, aar ꞌdïꞌrï aar urnidi aar le ele ꞌdunu ꞌdenggen aar enggaci gay mama gidi ngwujaꞌri ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Anni ma Abuluj mïnï ndi ele Akayiya, a ngwïkïrïjïn orꞌtemajani aar üllïjï ngwïkïrïjïnä ngwudi ngenoneng nunnu aar ülläjälü yïrnü. Anni mung obani, ngwugataji ngwïkïrïjïnä düwä ngwanni ngwuma ämnï yïmïꞌrü ye yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ndi ari ati aar garnati Ngwüyäwüd ngwe ndi ondaji ngwäyänü ngwüjï ating je dami ngwujaꞌri ngwe ngwuje enggaci kitabanu ndi ari Yicu gwuru gwanni Gwubrutaar yelenya. ");
INSERT INTO lro_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Anni ma Abuluj ji kündär gani Küründüj, a Bulij ꞌdïꞌrï ngwugatani ngwele gay ge ngwüꞌrü ngwaalinganu ngwobani kündär gani Abijuj. Ngenone, ngwumbuji ngwïkïrïjïnä ngwoko ");
INSERT INTO lro_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ngwuje otacalu, “Anni ma aang ru ngwïkïrïjïn, ngaa lima ape Lïgïꞌrïmä lanni Lijuꞌro?” Aar ci, “Bärï, änyängä laꞌti ꞌdingina ndi ari Lïgïꞌrïm lanni Lijuꞌru gilo.” ");
INSERT INTO lro_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","A je Bulij ci, “A mene nyïnyïnï gwuru ange gwünyïnyïnä gwe?” Aar ci, “Nyïnyïnï gwudi Yuwana.” ");
INSERT INTO lro_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","A je Bulij ci, “Nyïnyïnï gwudi Yuwana gwuru gwudi joꞌrenyani giyiꞌral yanni yiki. Gwondacu ngwüjü nunnu aar ämnï nginde gwanni gwaru nggwe nggwo gwïndï gwani Yicu.” ");
INSERT INTO lro_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Anni ma aar dingini ngwujaꞌri ngwee, aar je nyïnyï ngwürïny ngwe ngwudi Yicu. ");
INSERT INTO lro_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Anni ma je Bulij gatu guy nono, a je gu Lïgïꞌrïm lanni Lijuꞌru üllänü, ngwuje ätä yiima aar ondaji ngwungla le ngwuꞌter aar alliji yïjïrä ꞌto. ");
INSERT INTO lro_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ngwüjï ngwuru yiꞌranu ꞌdï na rom (12) ngwanni ngwuju ngenone. ");
INSERT INTO lro_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","A Bulij ele ngwänï ngwämrä ngenone aaꞌti yedeny ïtï ngwondaji aar anati ngwüjï ngwe nding je gwäꞌräjä giyelenyanu yidi Ngwaalu. Nggu jalu ngenone ꞌdi ngwape ngwüüwäyü täꞌrïl (3). ");
INSERT INTO lro_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","A be ngwüjï ngwoko ꞌdonya ngwujaꞌri aar ꞌdonya ndi ämnï aar ꞌdïꞌrï aar ondaji aar ci Gayalu mireny nggee gidi Deleny dani Yicu. No, a Bulij ꞌdïꞌrï ngwuje gatani ngwapani ngwïkïrïjïnä ati aar ngwe jalu yomon reny ngwuꞌdun ngwudi oꞌrajidalu ngwudi Tiyiranuj ati aar gu otajidalu. ");
INSERT INTO lro_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Agu yiꞌral ele giyee ꞌdi aar ape ngwüdläyü rom (2), ndi ari a Ngwüyäwüd ꞌdar na Ngwügïrïg ngwanni ngwati ji ngwaalu ngwani Ajiya, aar ꞌdingini ngwujaꞌri ngwudi Deleny. ");
INSERT INTO lro_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","A Ngwaalu ätä Bulijing yiima ngwugeꞌte yiima yiralu ꞌter. ");
INSERT INTO lro_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ꞌDi ati ngwüjï ape ngwureda ngwudi brütïnï nono na ngwured ngwanni ngwating je gennala ngwudi yiiru ngwanni ngwa akani ngwangina nono ngwudi Bulij aar je äpïjï ngwüjü ngwümä aar je gatu nono a je dümdï abri aar uꞌri nono na ngwüꞌrïllä ꞌtü ꞌdenggenanu. ");
INSERT INTO lro_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","A Ngwüyäwüd ngwoko ꞌdïꞌrï aar landalu ndi ꞌtüyï ngwüꞌrïllä aar gwurli aar ari ladi girinya ngwüꞌrïllä ngwanni ngwätïnä ngwüjü nono ngwürïny ngwe ngwudi Yicu. Ati aar je ci, “Ngwürïny ngwe ngwudi Yicu gwanni ngwati gwe Bulij ondaci ngwüjü, nggwucanga ꞌtüdä poor.” ");
INSERT INTO lro_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ati gu yïjï kwoꞌra täꞌrïl (7) yidi dirꞌdal danni diru giꞌra didi Ngwüyäwüd dani Jikapa arri yiꞌral giyee. ");
INSERT INTO lro_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","A je be dïꞌrïllä ci, “Äny gwülïngïdï Yicung nyi lenge Bulijing gwani yärü a be nga nga lani yärüngä?” ");
INSERT INTO lro_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","A je gur nggo gätïnä dïꞌrïllä nono, dami ꞌdar ngwuje mïꞌrï ꞌdi aar ꞌtüdä poor aar abri ngwanginu ngwanu liru yïnä. ");
INSERT INTO lro_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Agu Ngwüyäwüd ꞌdar ꞌdingini yidi Abijujing na Ngwügïrïg. A je yedeny eny ꞌdar, a ngwüjï denya ngwürïny ngwudi Deleny dani Yicu gwulleny. ");
INSERT INTO lro_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","A lonyadu lanni lima ämnï kaji nggoo, aar ila aar ꞌtäjï yiꞌralalu yegen yanni yiki. ");
INSERT INTO lro_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","A ngwuma ngwonyadu ürrä yitab yegen yidi yima aar je uꞌdiyi ngwäyänü ngwüjï. Anni ma aar ïꞌrä ngwilinya ngwudi yitab giyee, aar je mbuji dinar diru ngwüüꞌrï ꞌdï tudini (50,000). ");
INSERT INTO lro_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Gay ge nggee, a ngwujaꞌri ngwudi Deleny gendadi aar badalu yiima ye yipa. ");
INSERT INTO lro_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Anni ma yiꞌral medadi giyee, a Bulij ꞌdïꞌrï ngwari gwadi ele Üräjälïm, ngwumillidi ngwaalu ngwe ngwudi Majiduniyang na Akayiya. Ngwari, “Anni minyi ja ngenone, nggwele ꞌto kündär gani Ruma.” ");
INSERT INTO lro_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ngwükäjï ngwüjü ngwüngün rom (2) ngwanni ngwati gendaji guy Timijawujinga Arictuj gwe aar ele Majiduniya ngwube jalu gwooko ngwaalu ngwani Ajiya. ");
INSERT INTO lro_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kaji nggoo a ngwujaꞌri ngwani Gay gidi Deleny dani Yicu apa yiꞌral yikalu gikidang. ");
INSERT INTO lro_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Dijindala dani Dimitruj dati toy buta ngwugeꞌte yiꞌremna yidi bül gwudi bayil gwuru daw gwani Artimaj, ati gu ngwujindala mbojaji ngwüꞌrïnyä ngwonyadu. ");
INSERT INTO lro_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ngwurnida ngwujindala gwüpäng na ꞌdar liꞌter lanni lati ape yiiru nono yegen, ngwuje ci, “Ngwoꞌra, ngaa lïlïngïdï ndi ari a lati bile ngwüꞌrïnyä yiiru ye giyee. ");
INSERT INTO lro_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ngaa gilo be länggädï ngaa ꞌdingini ndi ari gur nggee gani Bulij gwuma gwäꞌrï ngwüjü ngwuming je dudiyi ngwonyadu ngwudi Abijujing yaꞌti ani ꞌdogo ngwüjï ngene Abijuj aar be ani ngwaalu ꞌdar ngwudi Ajiyang. Ngwari yiꞌremna yidi bayil gwugeꞌta ngwüjï ngwuy ngwe gwäꞌtüdï bayil aꞌtur. ");
INSERT INTO lro_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Yanni yikana yaꞌti ani ꞌdogo ndi ari ngwüjï ngwa kiyi yiiru yege yiꞌrinya aar be ru ꞌto ndi ari gobo gidi bayil gwuru daw gwupa gwani Artimaj gwaꞌta be ga ru guꞌru na ꞌto bayil giligoꞌro lüngün gwanni nggwo ngwäpïjä ngwüjï ngwudi Ajiyang na ngwüjï gïdïdlä ꞌdar yobo, gwaꞌta be gwa ngwüjï aniji yiima.” ");
INSERT INTO lro_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Anni ma ngwüjï ꞌdingini Ngwujaꞌri ngwee, a je güündä ape aar ürrï dula aar ari, “Artimaj gwuru gwanni gwupa gwudi Abijujing!” ");
INSERT INTO lro_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Puprang no, a ngwüjï ꞌdar kündär ꞌdïꞌrï güündä. Aar määtä Gayujing na gur gani Arictakuj lidi Majiduniyang lïndäär Bulijinga le aar le odena ngwaalu ngwudi oꞌrajidalu. ");
INSERT INTO lro_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","A Bulij bupi ndi üꞌrü ngwüjü ngwäy, a be ngwïkïrïjïn ümïnïcï. ");
INSERT INTO lro_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Na ꞌto ngweleny ngwudi Ajiyang ngwuru ngwumaad ngwudi Bulij aar ükäcï dïjü deꞌte ngwujaꞌri ngwe aar päcälü ndi ari aaꞌti gwa gata gora kiꞌdoongalu. ");
INSERT INTO lro_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Aaꞌti ngwüjï lïngïdï yiꞌral ye yorto ngwaalinga, a ngwoko ürrï dula giyiꞌral giyee, na ngwoko ürrï dula giyiꞌral yiꞌter. A ngwüjï ngwonyadana ngwuꞌti lïngïdï ndi ari giru ange ganni gäpädï je ngenone. ");
INSERT INTO lro_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","A Ngwüyäwüd dinga guru kiꞌra gweere gani Älïjïkändär, a ngwüjï ngwoko ürrä dula nono aar ondaci gwadi araa. Ngwalliji guyala nunnu aar gwugwundi ngwuje enggaci yanni yadi ye ruci ligoꞌro lüngün. ");
INSERT INTO lro_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","A be anni ma ngwüjï lenge ndi ari giru Dïyäwüd, aar ürrï dula ꞌdar ꞌdi a lingen ele ngwuru rom (2) aar ari, “Artimaj gwuru gwupa, gwuru bayil gwudi Abijujing!” ");
INSERT INTO lro_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Gwodanalu, a je gur ganni gati üllïjï delenya didi kündär burni ndi ondaci aar gwugwundi. Ngwuje ci, “Ngwüjï ngwudi Abijujing, ngwüjï gïdïdlä ku ngwülïngïdï ndi ari gündär gidi Abijujing giru dangida didi gobo gidi bayil gwupa gwani Artimaj na ngwuru dangida didi giꞌremna güngün ganni gïꞌdü kerala. ");
INSERT INTO lro_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Yiꞌral giyee yilinginna üblätï gwere gwaꞌti gu. A be yijaw ndi aang adatalu ngaa je ꞌti büdäcä ngwäy ngaa je ärrï yanni yiki. ");
INSERT INTO lro_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ngaa lima apa ngwüjü ngwee rom (20 a ngwe ila ngene ngwaꞌti ïtï yuꞌrimi kobo aar ꞌti aru ngwujaꞌri ngwere ngwuki gibayil gwege. ");
INSERT INTO lro_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Manari Dimitruj na ngwujindala ngwüngün, lätï yiꞌral yere ngwüjü nono ngwee, ngwaalu ngwo ngwudi pï yelenya a ngweleny ji, gäbïcär je aar apada yiꞌral yegen ngenone. ");
INSERT INTO lro_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ma be ari yere giyo yätää je yiꞌter, ya gu be ru ndi ari a ngweleny jalu aar je ombaci. ");
INSERT INTO lro_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Yiꞌral giyee yärrïnä gu no gwene, ya gäbïcï ngwelenya ngwunje üpäcï yiꞌral nono yani yärä. A laꞌti lätï ngwujaꞌri ngwadi ar ngwe ari ndi oꞌrajidalu nggwee manari liminje otacalu.” ");
INSERT INTO lro_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Anni mung gu ari ngwujaꞌri ngwee, ngwuje bädïyï aar ele. ");
INSERT INTO lro_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Anni ma ngwüjï adatalu a Bulij ükäjïdï ngwïkïrïjïn ngwuje orꞌtemaji, ngwuje ci jar balu ngwüꞌdïꞌrï ngwele Majiduniya. ");
INSERT INTO lro_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ngwele ngwulandalu ngwaalu ngwoo ngworꞌtemaji ngwüjü ngwujaꞌri ngwe ngwonyadu. ꞌDi gwodanalu ngwobani ngwaalu ngwani Gïrïg ngwucaar je ꞌto Akayiya. ");
INSERT INTO lro_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nggu jalu ngenone ngwüüwäyü täꞌrïl. Anni ma ngwuji kay gwadi ele ngwüꞌrü yaanu ngwele Jürïyä, a Ngwüyäwüd ïnïjï ndi aar ꞌrinye ngwüꞌrïdïnï kiꞌra ngwukwoyalu gay ge gidi Majiduniyang. ");
INSERT INTO lro_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Aar ele Jupatar gwe gwuru gïjï gidi gur gani Baruuj kündär gani Bïrïyä, na Arictakuj na Jikanduj kündär gani Täjlänükï, na Gayuj kündär gani Därbï, a gu Timijawuj janu ꞌto. Na Tiyakuj na Trubimuj lidi ngwaalu ngwani Ajiya. ");
INSERT INTO lro_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ngwüjï ngwee ꞌdar ngwumadinu aar nje dünïcï kündär gani Truwaj. ");
INSERT INTO lro_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nyii be ꞌdïꞌrï nyii üꞌrü yaanu kündär gani Bïlïpï anni ma Yïꞌrïnyïnä yidi Ligiꞌra medadi a anni ma yomon ru tudini, njee borna Truwaj nyii gu jalu ngenone yomon kwoꞌra täꞌrïl. ");
INSERT INTO lro_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Komon ganni giru giꞌra giyomon Kwoꞌra täꞌrïl, nyii oꞌrajidalu gwüpäng ndi acajidi ndi eny, a Bulij ondaci ngwüjü na ndi ari gwubupa ndi ele bïgänü, ngwondaji ꞌdi a diligeny danu ru. ");
INSERT INTO lro_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ngwuꞌdun ngwanni ngwoꞌradi nyii gwalu alu nggwe, ngwätï ngwamba ngwonyadu. ");
INSERT INTO lro_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","A damal deꞌte dani Yitayuj jadalu gibuꞌrinyar, a be anni ma Bulij ji ndi ondaji ꞌdi a gaji olanu, ngwïrꞌdätälä ngwundri yaranu ꞌdi ngwumiꞌra ꞌtuꞌtu ngwuꞌdun ngwuru yoranyanu rom (2) alu nggwe ngwaalu gïdïyängälü aar apalu gayu. ");
INSERT INTO lro_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","A Bulij üllï, nggu gatu rumala ngwümätänï nono. Ngwuje ci, “A je ꞌti yedeny ïtï, nggo gimidu!” ");
INSERT INTO lro_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ngwube kwoyalu mana ngwallu ngwuꞌdun alu nggwe aar acajidi ndi eny. Anni mung ondaji ꞌdi a ngwaalu uꞌri ngwüꞌdïꞌrï ngwele. ");
INSERT INTO lro_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A ngwüjï ape damal ndoo ꞌdunu dimidu aar gu orꞌtemaji gwulleny. ");
INSERT INTO lro_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nyii ele nyii elada gweere gïbälükä nyii ele giyaanu kündär gani Acuj, ganni gadi nyii gu ape Bulijing gïbälükänü. Nginde gwugeꞌta gu yiꞌral giyee mama no ngenone ndi ari gwadi gu ele yora yalu. ");
INSERT INTO lro_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Anni minyii le mbudi ngenone Acuj, nyii ape nyii alliji gïbälükänü nyii ele elada Mïtïlïn. ");
INSERT INTO lro_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Bïgänü nggwo nyii ele giyaanu ngenone nyii obani kündär giyaanu gani Keyoj. Bïgï nggwoo nyii dambu kündär giyaanu gani Jamuj, na bïgänü nggwoo nyii obani Milatuj. ");
INSERT INTO lro_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Bulij gwümïꞌrïnä kiꞌra ndi üꞌrü yaanu ngwugatani Abijujing ndi ari aaꞌti gwa jana ngenone Ajiya. Ndi ari gwübüdädü ndi ari mung burni ngwobani Üräjälïm gwerre gwerre ndi gomon ïꞌdï gidi Yïꞌrïnyïnä yidi Uni. ");
INSERT INTO lro_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ngenone Milatuj, a Bulij ükäjïdï ndi mbumbunga lanni liru yiꞌra kiꞌdoonga gidi Ngwaalu gidi Abijujing. ");
INSERT INTO lro_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Anni ma aar obani, ngwuje ci, “Ngaa lïlïngïdï ndi ari äny gwelella awa gaji ganni gijar le anni ïndï nyi ꞌdanggalu ngwaalu ngwani Ajiya. ");
INSERT INTO lro_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Äny gwäpïjä Ngwaalinga yiiru ligoꞌro le lüllänü gwulleny ꞌdi nyi ari, aar nyi gu ꞌto Ngwüyäwüd ïdïtäjï ïnïjï gwe gwupa. ");
INSERT INTO lro_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ngaa lïlïngïdï ndi ari äny gwaꞌti gwagillalu nda je enggaci ngwujaꞌri ngwere ngwanni ngwada je gataji düwä nga je be ondaci pooralu nyi ondaci ngwüjï ngwuꞌdun ngwuꞌdun. ");
INSERT INTO lro_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Äny gwuma enggaci Ngwüyäwüd nyi enggaci ngwüjü ngwuru Garany ngwujaꞌri ngwudi Ngwaalu nunnu aar joꞌrenyana aar oꞌraca Ngwaalinga aar ämnï Gideleny dege dani Yicu. ");
INSERT INTO lro_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","A be gweneno, Lïgïꞌrïm linyaci yiima ye ndi nyi ele Üräjälïm, yaꞌti nje lïngïdï yanni yiny mbuji ngenone. ");
INSERT INTO lro_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Yïlïngïdï nje ꞌdogo ndi ari kündär gere, Lïgïꞌrïm lanni Lijuꞌru gilo lïgïrïnyädï ndi ari yirna na yündä giyo yïdünïcïny. ");
INSERT INTO lro_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","A be ligor laꞌti nyi pïcä ligoꞌro lüny, aar nyi be pïcï yiiranu ndi ari nyi ye ꞌdïꞌrï nje medaji yanni yätädäär nje Deleny dege dani Yicu. Yiru ndi ari nyi enggaci ngwüjü ngwujaꞌri ngwanni ngwujaw ngwudi yïmïꞌrü yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Gweneno nggwülïngïdï ndi ari gwere gwaꞌti ꞌdanggalanu lanni liminje ondaci yeleny ye yidi Ngwaalu loꞌre liny engga mana. ");
INSERT INTO lro_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Yäy gu no, gwene nggwa je ci, ndi ari nggwügwällï ligoꞌro lüny gïyïn yidi ngwüjï ꞌdar. ");
INSERT INTO lro_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ndi ari äny gwaꞌti gwagillalu nda je enggaci buping ꞌdar gwani Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Arnganar yigoꞌro yalu ngaa arngani yiꞌdonga yidi Ngwaalu ꞌdar yanni yima aar je Lïgïꞌrïm lanni Lijuꞌru gïꞌtïjï ngaa ru ngwangida ngwegen. Rüdär ngwooꞌra kiꞌdoonga gidi Ngwaalu ganni giming üꞌrälü yïn ye yüngün. ");
INSERT INTO lro_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nggwülïngïdï ndi ari manari nggwuma ele, lila lanni liru ngwümüd ngwuki drü ꞌdanggalanu ngwa gïrïdïnï giꞌdonga ge gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ꞌDi kiꞌdanu galu ngwüjï ngwa ꞌdïꞌrä ngwanni ngwa gwürlï ngwujaꞌranu ngwanni ngwuru ꞌdidanu nunnu a je ngwe ngwïkïrïjïn gwujani. ");
INSERT INTO lro_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Yäy gu no, arnganar be! Diwayinar ndi ari ngwüdläyü täꞌrïl (3) nggwaꞌti dünä aꞌtur nda je girinya nga nga ꞌdar dilu de na lingen le yal ye ngwäy. ");
INSERT INTO lro_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Gweneno, nggwa je geꞌte kuyanu gidi Ngwaalu na ngwujaꞌranu ngwudi yïmïꞌrü yüngün, ngwanni ngwa je giki ꞌdïꞌdäny aar je ätä yuꞌrina ngwüjïngä le ꞌdar ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Buta na dab yaa dired dïjü dere daꞌti nyi ämïꞌrädänü. ");
INSERT INTO lro_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nga giyigoꞌro yalu lïngïdï ndi ari ngwuy ngwe ngwüny ngwee, ngwape nyi ngwe yiiru nyi iye ligoꞌro lüny na lanni liji nyii le. ");
INSERT INTO lro_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Giyiꞌral ꞌdar yanni yärrï nje, nggwenggaca je ndi ari ar ape yiiru ar ye gataji ngwüjü düwä ngwanni ngwamiꞌratu. Diwayinar ngwujaꞌri ngwanni ngwaru ngwe Deleny dege dani Yicu ligoꞌro le lüngün ndi ari, ‘Onjaji gwati ji ndi ätä ndi ari ngwuji ndi ape.’” ");
INSERT INTO lro_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Anni mung ari ngwujaꞌri ngwee, aar le jürbälü ꞌdar aar otaci Ngwaalingalu. ");
INSERT INTO lro_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ngindenga ꞌdar aar ari aar mätänï Bulijing nono aar aganni aar ci ïndï be. ");
INSERT INTO lro_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Aar ümï giyigor gwece gwece anni arung gwaꞌta be gwa aar engga ngwäyänü mana. Aar gwujani ꞌdi aar le obani gïbälükä. ");
INSERT INTO lro_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Anni minyii ꞌtänü gweere nje gatani, nyii üllï nyii ele bälükä gwe giyaanu nyii ele kündär giyaanu gani Kwuj. Bïgänü nyii ele kündär giyaanu gani Rüdïj a ngenone, nyii ele kündär gani Patara. ");
INSERT INTO lro_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nyii mbuji bälükä gwadi üꞌrü yaanu ngwudambu ngwaalu ngwani Bunijiya, nyii gu änänü nyii ele. ");
INSERT INTO lro_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Anni minyii ombati Gabrujing ngwäyänü, nyii millida kuyala gidi gaama, nyii ele dïlä giyaala nyii ele Jürïyä. Nyii üllälü kündär gani Jür gadi gu bälükä nggwo gwïndï nyii gwe ülläjï ngwonyalu ngwapaning je. ");
INSERT INTO lro_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nyii mbuji ngwïkïrïjïnä ngenone, nyii ngwe jalu yomon kwoꞌra täꞌrïl (7). Lïgïꞌrïm le, aar ondaci Bulijing nunnu aaꞌti gwele gwa allu Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","A be anni ma gaji gärï ila, nyii ꞌdïꞌrï nyii ele gay ge gärï nyii elada gweere. A ngwïkïrïjïn ꞌdar ngwur na ngwaw ngwegen na yïjï yegen aar nje gwujani nyii le ꞌtü kündär poor, ngenone kïmämü nyii jürbälü yirku ye ndi otaci Ngwaalingalu. ");
INSERT INTO lro_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Anni minyii ꞌdïꞌrï nyii agannajidi, nyii änï gïbälükänü nyii ele a ngindenga kwoyalu ꞌdunu. ");
INSERT INTO lro_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nyii ele dïlä nyii gatani gündärä gani Jür nyii üllälü kündär gani Bitilimiyaj, ngenone nyii gu aganni ngwïkïrïjïnä nyii ngwe jalu gomon geꞌte pu. ");
INSERT INTO lro_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Bïgänü nggoo nyii ꞌdïꞌrï nyii ele ꞌdi nyii obani kündär gani Gäyïjärïyä, nyii jalu ngwuꞌdun ngwudi Bïlïpüj gwanni gwati ondaci ngwüjü ngwujaꞌri ngwanni ngwujaw, gwuru dïjï ngwüjänü kwoꞌra täꞌrïl 7) ngwanni ngwäbräär je ndi gendaji ngwuy giyiiru. ");
INSERT INTO lro_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Gwätï yera kwoꞌrongo (4) yiru yuꞌtaar, yati alliji yïjïrä. ");
INSERT INTO lro_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Anni minyii ji ngenone yomon yiꞌranu yoko, a dïjïr deꞌte dani Agabuj, ngwüllä Yäwüdïyä. ");
INSERT INTO lro_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Aar nje ilada nono, ngwape lägü lidi Bulij ngwule gekani ngwuyalu ngwüngün na yora ngwari, “Lïgïꞌrïm lanni Lijuꞌru laru nu, ‘Anaku no Ngwüyäwüd ngwudi Üräjälïmïng ngwa giki dïjü didi lägü gilee no da aar ätädä ngwüjü ngwuru Garany.’” ");
INSERT INTO lro_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Anni minyii ꞌdingini ngwujaꞌri ngwe, änyängä na ngwüjï ngwanni ngwuju ngenone nyii päcï Bulijingalu ndi ari aaꞌti gwele Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ar nje Bulij ci, “Nga nga larra ngaa be runi ngaa gäbïcï ligor lüny ngwuji jïgüꞌrr? Äny gwüjädï ndi ari aaꞌti liny giki ꞌdogo, gäbïcär aar nyi ꞌrinye ngenone Üräjälïm gwani ngwürïny ngwudi Deleny dani Yicu.” ");
INSERT INTO lro_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Anni mung ꞌti ämnä ngwujaꞌri ngwärï, nyii gäbïcï nyii ari, “Yanni yïmïnä je Ngwaalu aar gu ru.” ");
INSERT INTO lro_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Anni ma ngwujaꞌri medadi ngwee, nyii ꞌdïꞌrï nyii ji mama nyii allu Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ngwïkïrïjïn ngwoko ngwudi Gäyïjärïyäng aar nje gwujani aar nje apa ngwuꞌdun ngwudi Manijun, ngwadi nyii gu ji. Nginde gwuru gwudi Gabrujing ngwuru dïkïrïjïn ngwïkïrïjïnänü ngwanni ngwumadinana. ");
INSERT INTO lro_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Anni minyii obana Üräjälïm, aar nje ngwïkïrïjïn geꞌte gïyïrnü yipa. ");
INSERT INTO lro_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Bïgänü nggwoo a Bulij na änyängä ꞌdar nyii ele ndi ombaja Yagubing, na nyii mbuji mbumbung je ꞌdar lidi giꞌdoonga liju. ");
INSERT INTO lro_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","A je Bulij aganni ngwuje ütïcï yiꞌral yiꞌra ꞌdar yanni yima je Ngwaalu ärrï ngwüjänü ngwuru Garany yiiru ye yüngün. ");
INSERT INTO lro_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Anni ma aar ꞌdingini yiꞌral giyee, aar ortada Ngwaalinga. Aar be ci Bulijing nu, “A gwänggädï gwani mengga, ndi ari awa Ngwüyäwüd ngwüüꞌrï ngwonyadu ngwanni ngwuma ämnï, a ngindenga ꞌdar lïtï je yigoranu gwani yobo. ");
INSERT INTO lro_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Licaar je ndi ari nga gwati enggaci Ngwüyäwüd ꞌdar ngwanni ngwo ngwüjänü ngwuru Garany ndi ari aar gatani Yobo yidi Müjä, nga je ci aar ꞌti üꞌrïꞌtädï yïjü yegen aar ꞌti elella dïmürä de dege. ");
INSERT INTO lro_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Aladi ärrï ange? Yiru gu ndi ari ladi gu ꞌdingini ndi ari nga gwuma ila, ");
INSERT INTO lro_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","no, ärrä je giyee yanni ya ar ang ye ci, ngwüjï kwoꞌrongo (4) ngwo ngwuji nyii ngwe ngwanni ngwümïꞌrïdï yiꞌrany. ");
INSERT INTO lro_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Apa je a ngwe acajidi gïdïmürä a ngwe gäꞌrïnï nono ngaa je gïꞌtïjï aar wädïnï. Nunnu a gu ngwüjï lenge ꞌdar ndi ari ngwujaꞌri ngwanni ngwuꞌdinginaar ngwe gwani nga ngwaꞌti ätï ngwäyänü ndi ari nga giligoꞌro lunga nga nggwo gwümätï yobo yïndä ye. ");
INSERT INTO lro_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","A be gwani ngwüjï ngwuru Garany ngwanni ngwuma ru ngwïkïrïjïn, liminje üllïjï ngwujaꞌri ngwärï ndi ari aar gäbïcï enying ngwony ngwudi mïꞌrïnï nono ngwudi dïdülä na yïn na ngwüdï ngwudi ngwong ngwugogornyana aar gäbïcï yïjïnä.” ");
INSERT INTO lro_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Anni ma bïgänü ru, a Bulij ꞌdïꞌrï ngwape ngwoꞌra aar ngwe gäꞌrïnï. Ngwube ꞌtü ngwele kobo ndi inggida gomon ganni gadi ge yomon yidi gäꞌrïnï medadi na nunnu aar gatu gonyalu gidi mïꞌrïnï nono ngindenga ꞌdar. ");
INSERT INTO lro_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Anni ma yomon kwoꞌra täꞌrïl ji gito yadi medadi, a Ngwüyäwüd ngwoko ngwïndï ngwaalu ngwani Ajiya aar enggada Bulijing kobo. Aar gwogaja ngwüjü ngwonyadu aar määtä. ");
INSERT INTO lro_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Aar ürrï dula aar ci ngwüjü, “Ngwüjï ngwudi Yïjïräyïl gendaci nje guy! Gur giru nggee ganni gati enggaci ngwüjü ngwaalu ꞌdar aar ïnïjï ngwüjï ngwege na gwani yobo na gobo nggee. Ngwube oꞌre ngwapana ngwüjü ngwuru Garany ngwe ändä kobo lima rngïyï ngwaalinga ngwee ngwujuꞌru.” ");
INSERT INTO lro_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Laru gu no ndi ari gwele länggädï Trubimujing gwudi Abijujing kündär liju Bulij gwe aar be ji ndi ari gwapana Bulij nggwe ändä kobo. ");
INSERT INTO lro_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","A gündär ꞌdïꞌrï ꞌdar a ngwüjï abrada ngwaalinga nono ꞌdar aar määtä Bulijing aar oktalu kobanu aar ꞌtüyä puprang no aar längïtï längïrü. ");
INSERT INTO lro_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Gaji ganni gima aar ge ru gadi ꞌrinye, a ngwujaꞌri obani kumndan gidi gwuꞌtulunga gwudi Rumang ndi ari gündär ꞌdar gidi Üräjälïmïng nggo gïꞌdïꞌrü yärä. ");
INSERT INTO lro_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","No, a kumndan apani ngwubegenga na gwuꞌtulunga aar ngwe üllï ngwüjï. Anni ma ngwüjï engga kumndaning nggoo na gwuꞌtulunga, aar dünï ndi pï Bulijing. ");
INSERT INTO lro_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","A kumndan nggoo määtä Bulijing ngwuci gwuꞌtulung je gikar yuꞌrunganu rom (2). Ngwube utalu ndi ari nginde gwani yärü na yiru ange yanni yärrüng je. ");
INSERT INTO lro_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","A ngwüjï ngwoko ari yiꞌral giyee na loko ari yiꞌral yiꞌter, anni ma ꞌti kumndan mbuju yiꞌral yanni yätï ngwäyänü yïꞌdïꞌräjä gu ngwüjï yärä, ngwari aar ape Bulijing aar gwe ele gidilagany. ");
INSERT INTO lro_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Anni ma Bulij ji kimle gito ladi allu gidilagany, a ngwüjü ꞌdïꞌrïyänï yärä yikana aar änï Bulijinganu ꞌdi a gwuꞌtulunga apala. ");
INSERT INTO lro_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ngwüjï ngwanni ngwuma je gwujani aar ürrï dula aar ari, “ꞌRïnyïtär.” ");
INSERT INTO lro_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Anni ma gwuꞌtulunga ru ladi ape Bulijing aar gwe änï gidilagany, ngwuci kumndaning, “Gäbïcïny ngaa ondaci ngwujaꞌri ngwe ngwoko?” A gur ci, “Nga gwati ondaji Yïgïrïgïyängä? ");
INSERT INTO lro_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nga gwäꞌtüdï Dimijir danni dïꞌdïꞌrïyä yärä ngwoktani ngwäärä ngwüüꞌrï kwoꞌrongo (4,000) aar ngwe ele poor ngwaꞌranu kaji ganni gima ele?” ");
INSERT INTO lro_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","A Bulij ci, “Äny gwuru Dïyäwüd, didi gündär gani Tarjuj ngwaalu ngwani Kïlïkïyä, gwudi gündär gäꞌtüdälü no. Gäbïcïny nyi ondaci ngwüjü ngwujaꞌri ngwoko.” ");
INSERT INTO lro_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Anni ma kumndan ꞌdengenaci, a Bulij ꞌdïꞌrälü ngwüdünï kimlala ngwalijaci ngwüjü guyala nunnu aar gwugwundi. Ngwuje ondaci Yärmïyängä. ");
INSERT INTO lro_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","A je Bulij ci, “Lani ngweengga na mbumbunga, geraciny ngwänï gweneno ngwujaꞌri ngwuruciny ngwe ligoꞌro lüny.” ");
INSERT INTO lro_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Anni ma aar ꞌdingini ngwuje ondaci Yärmïyängä, aar adatalu jicom. ");
INSERT INTO lro_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Ngwuje be ci, “Äny gwuru Dïyäwüd nggwülïngïnä Tarjuj ngwaalu ngwani Kïlïkïyä, a be nggwüꞌdïꞌrälü kündär nggee. A doorta ru düny dani Gämläyïl gwanni gwenggaciny aar nyi ola mama yobo ye yidi ngwügüürnä ngwege, na nyi ru dïjï dïtï ligoranu gwani Ngwaalu nono ngang je gweneno. ");
INSERT INTO lro_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Äny gwuru gwanni gwübïnä ngwüjälü ngwudi Gay nggee gidi Deleny dani Yicu gwulleny nje ruji yiꞌrany, ati nje ummi ngwur na ngwaw nje ürrä korkon ");
INSERT INTO lro_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Dirꞌdal danni diru giꞌra na ngwämrä ngwudi Ngwüyäwüd ꞌdar ngwa inggidi ngwujaꞌri ngwee ꞌto. ꞌDi nyi ape ngwujaꞌri ꞌdenggen nyi ngwe ele ngweengga ngwegen ngenone Dimajig, nyi ele ngenone nunnu nyi umma ngwüjü ngenone nje gika nyi ngwe ila Üräjälïm nunnu aar je reraji.” ");
INSERT INTO lro_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Anni minyi ele ꞌdi nyi jici Dimajiging gito, a ꞌdür kayanu lingen le lïdünälä a buri gwubidu pupiꞌrul italu kerala aar nyi oꞌrralu. ");
INSERT INTO lro_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nyi ïꞌdï gïdïyängälü, nyi ꞌdingini aar nyi urnidi ngwürïny ngwüny, ‘Jawul Jawul! Nga gwarra miny übïnälü?’ ");
INSERT INTO lro_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nyi utalu nyi ci, ‘Nga gwani yärü gwani Deleny?’ Aar nyi ca, ‘Äny gwuru gwani Yicu gwudi Najrang gwanni gwübïnängälü.’ ");
INSERT INTO lro_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ngwüjï ngwanni ngwuji nyii ngwe, aar engga buri aar ꞌti be lïngïdï yal yüngün gwanni gwuji nyi ndi ondaci. ");
INSERT INTO lro_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nyi be ci, ‘Yiru ange yanni yadi nje ärrï gwani Deleny?’ Aar nyi be Deleny ci, ‘ꞌDïꞌrü nga ele Dimajig. Ngenone la ang be enggaci yiꞌral ꞌdar yanni yïgïꞌtïnä ndi ari nga je ärrï.’ ");
INSERT INTO lro_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Lanni lïndï nyii le aar nyi okta kuy nyii ele Dimajig ndi ari enyanu gwudi buri gwuminy rïmïyï ngwäy. ");
INSERT INTO lro_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Gur geꞌte ngenone gani Ananiya gïdïnyädï Ngwaalinga ngwila ndi aar nyi ombaji gïmätï yobo gïdïnyädï Ngwüyäwüd ꞌdar ngwanni ngwati ji ngenone. ");
INSERT INTO lro_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ngwila aar nyi dünäcälü aar nyi ci, ‘Gwani mengga gwani Jawul ombajidalu!’ Gaji ge nggoo geꞌte geꞌte nyi ombajidalu nyi engga. ");
INSERT INTO lro_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ngwube ari, ‘Ngwaalu ngwudi ngwügüürnä ngwege ngwäbrängä nunnu nga lenge buping gwüngün na nga engga ngindeng gwüngün gwanni Gwüdünälü nga ꞌdingini ngwujaꞌri ngwulemanu ngwüngün. ");
INSERT INTO lro_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nga ru gwanni gwadi inggidi ngwüjï ꞌdar nga je ondaci gwani yiꞌral yanni yima je engga nga je ꞌdingini. ");
INSERT INTO lro_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","A be gwenene giru ange gïdünïcängä? ꞌDïꞌrü aar ang nyïnyï yaw ye nga oyaji kengalu mbüny nga urnidi ngwürïny ngwe ngwüngün.’ ");
INSERT INTO lro_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Anni minyi oꞌra Üräjälïm, nyi ji ndi otaci Ngwaalingalu kobanu nyi be äyïnï giligor ");
INSERT INTO lro_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","nyi engga Delenya aar nyi ondaci ngwari, ‘ꞌDïꞌrü puprang gwenene nga gatani Üräjälïmïng, ndi ari ngwüjï ngwaꞌti ngwa ang ꞌdengenaci ngwujaꞌri ngwani äny.’ ");
INSERT INTO lro_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nyi gwäꞌräcänü nyi ci, ‘Gwani Deleny, ngwüjï ngwülïngïdï ndi ari äny nggwändï ngwämrä ꞌdar nyi pï ngwüjü nje ürrä korkon ngwanni ngwämnä ꞌdunggunga. ");
INSERT INTO lro_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Gaji ganni gima aar ge ꞌrinye Ijitabanujing gwanni gwondaja nga gwe, äny gwuju nyi ämnï ndi aar ꞌrinye lanni lïꞌrïnyïtï lïgätïjänïny ngwuredalu nje ombaci.’ ");
INSERT INTO lro_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Aar nyi ci, ‘Ïndï äny gwadi ang ükäjï ngwaalu ngwolanu ngwüjï ngwuru Garany.’” ");
INSERT INTO lro_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","A ngwüjï geraci ngwänï ꞌdi anni mung ari ngwujaꞌri ngwoo. Aar ürrï dula aar ari, “Äbrär dïjü ndee kayanu daꞌti äwdï ndi midi!” ");
INSERT INTO lro_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Aar ürrï dula aar gagitu ngwureda ngwegen mbüny aar gagitu dïyängü kerala. ");
INSERT INTO lro_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","A kumndan ondaji ndi ari aar ape Bulijing aar gwe ele gidilagany. Ngwari aar pï lacal le aar otacalu aar ombaji ndi ari ngwüjï ngwarra ma aar ürrädä dula nono no. ");
INSERT INTO lro_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Anni ma aar gekajalu gwadi aar pï, a Bulij ci kumndan gidi gwuꞌtulunga küüꞌrï tudini (110), “Ii yädï gu ꞌdanggalu ndi pï dïjü diru Diruman daꞌti aar na mbojaja yiꞌral nono yere?” ");
INSERT INTO lro_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Anni ma gu kumndan gidi gwuꞌtulunga küüꞌrï tudini (100) ꞌdingini no, ngwele kumndan gegen ganni gipana ngwuci, “Yiru ange yanni yada je ärrï? Gur nggee giru Diruman!” ");
INSERT INTO lro_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","A kumndan nggoo ele ndi Bulij ngwotacalu ngwuci, “Ondaciny nga gwuru Dirumane?” Ngwuci, “Yäy.” ");
INSERT INTO lro_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","A be kumndan ci, “Äny gwugeꞌta ngwilinya ngwonyadu nunnu nyi ru Diruman.” A be Bulij ci, “A be nggwülïngïnä gu.” ");
INSERT INTO lro_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Gaji nggoo lanni licaar je aar otacalu aar oꞌre kay a yedeny ape kumndan nggoo anni mung engga ndi ari gima änïjï Bulijing giyirna gwuru Diruman. ");
INSERT INTO lro_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Anni ma dilu danu ru, a kumndan nani yiꞌral ꞌdidanu yanni yüpäjä je Ngwüyäwüd Bulijing nono, nggwallalu giyirna ngwükäjïdï ngwurꞌdal ngwanni ngwuru ngweleny na ꞌdar lidi ngwämrä ngwudi Ngwüyäwüd nunnu aar oꞌrajidalu. Ngwube apa Bulijing ngwuje dünäcï ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","A Bulij ombaji ngwämrä ngwudi Ngwüyäwüd ngwäyänü ngwuje be ci, “Lani ngwänggärï, äny gwïlïjä Ngwaalinga ligor le lijayanu ꞌdi gomon gidi gweneng.” ");
INSERT INTO lro_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","No a dirꞌdal danni diru giꞌra dani Ananiya, ondaci ngwüjü ngwüdünäcä Bulijingalu ndi ari aar mïꞌrï Bulijing ngwulemanu. ");
INSERT INTO lro_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","A be Bulij ci, “Ngwaalu ngwa ang mïꞌrï ngang nggwee gwuru nono gunduꞌru gïbïꞌrïjüdäär gilu ge gibidu! Awa nga be jalu nga ari nga gwüpïcïny yelenya anaku aru gu yobo nga je be kiyi ligoꞌro le lunga ndi ci ngwüjü aar nyi pï?” ");
INSERT INTO lro_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","A ngwüjï ngwanni ngwüdünäcä Bulijingalu aar ci, “Nga gwarra nga be lo dirꞌdala danni diru giꞌra didi Ngwaalu?” ");
INSERT INTO lro_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","A je be Bulij ci, “Nggwaꞌti gu lïngïdï lani ngweengga ndi ari dirꞌdal diru danni diru giꞌra, ndi ari yüllïnä kitabanu yaru nu, ‘Aaꞌti nga gwondaji yiꞌral yiki gideleny didi ngwüjï ngwunga.’” ");
INSERT INTO lro_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Anni ma Bulij lenge ndi ari ngwüjï ngwülägädänü ngwoko ngwuru Ngwüjändügï na ngwoko ngwuru Ngwübärrïjï, ngwondaji dula ngwämrä ngwudi Ngwüyäwüd ngwari, “Lani ngwänggärï, äny gwuru Dïbärrïjï gïjï gidi Dïbärrïjï. Äny gwüdünädälä ngene ndi aar nyi pïdïyï yelenya ndi ari äny gwätï geꞌtajing ndi ari lanni lima ayi la ꞌdïꞌrï giyiꞌranyanu limidu.” ");
INSERT INTO lro_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Anni mung ari ngwujaꞌri ngwee, a Ngwübärrïjïngä garnati Ngwüjändügï ngwe, a ngwämrä üꞌrïdïnänü rom (2), a Ngwübärrïjï ji ꞌter na Ngwüjändügï ji ꞌter. ");
INSERT INTO lro_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Ngwüjändügï ngwati ari ngwujaꞌri ngwani ꞌdïꞌrï giyiꞌranyanu na ngwujaꞌri ngwani yïꞌrr na ngwügïꞌrïm ngwaꞌti. A be Ngwübärrïjï ämnï ngwujaꞌri ngwee ku.) ");
INSERT INTO lro_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","A ngwüjï ꞌdïꞌrï güündä a ngwoorta ngwoko ngwudi yobo ngwuru Ngwübärrïjï aar ꞌdïꞌrï aar ondaji dula aar ari, “Gur nggee gaꞌti nyii mbojaja yiꞌral nono yere yiki. Nda manari lïgïꞌrïm na gïꞌrr giru gondaca?” ");
INSERT INTO lro_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","A ngwüjï büdï ngwäy ꞌtiꞌtir ndi garnati, ꞌdi a yedeny eny kumndaning ndi ari ngwüjï ngwa okta Bulijinganu ngwondaci gwuꞌtulung je ndi ari aar ele aar je apada yiima ye aar gwe ila gidilagany. ");
INSERT INTO lro_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Dilunga ndoo, a Deleny dani Yicu dünäcï Bulijing gito gito ngwondaci ngworꞌtemaji ngwuci, “Undu ngwäy! Anaku ma gu ondaci ngwüjü ngene Üräjälïm gwani äny, nga gwondaci ngwüjü ꞌto gwani äny kündär gani Ruma.” ");
INSERT INTO lro_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Dilu danu, a Ngwüyäwüd änïcïdï ngwujaꞌri giyigoꞌro yegen aar pï yiꞌrany ndi ari laꞌti la eny aar ïyï ꞌdi aar engga ndi ari lima ꞌrinye Bulijing. ");
INSERT INTO lro_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Lanni ländï ndi ïnïjï nggwee lonyadana yiꞌra küüꞌrï rom (40). ");
INSERT INTO lro_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Aar ꞌdïꞌrï aar elada ngwurꞌdal ngwanni ngwuru ngweleny na mbumbunga aar je ci, “Änyängä lïmïꞌrïdï yiꞌrany ndi ari nyii laꞌti la allini gony gere ngwulemanu ꞌdi nyii ꞌrinye Bulijing. ");
INSERT INTO lro_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Gwenene nga nga na ngwämrä ngwudi Ngwüyäwüd, päcär kumndaningalu nunnu ara je äpïjä Bulijing ngaa ari gwadi aang otacalu ngwujaꞌri ngwüngün mama. Nyii gilo liju mama ndi nyii ꞌrinye kay gwerre gwerre nding obana ngene.” ");
INSERT INTO lro_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","A gu gïjï gidi gwenggen gwudi Bulij gwuru gera ꞌdingini ïnïjïng nggwee ngwele gidilagany ngwondaci Bulijing. ");
INSERT INTO lro_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","A Bulij urnidi kumndaning geꞌte gidi gwuꞌtulunga küüꞌrï tudini (100) ngwuci, “Apa damal ndee nga de ele kumndan galu dätï ngwujaꞌri ngwadi ngwe ci.” ");
INSERT INTO lro_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ngwape ngwude ele kumndan ngwuci, “Bulij korkon gwurnidi nyi gwari ngaa äpïjä damal ndee dätï ngwujaꞌri ngwadi aar ang ngwe ci.” ");
INSERT INTO lro_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","A kumndan määtä kuy ngwude ꞌtänü, ngwotacalu ngwuci, “Yiru ange yätä je ondaci nje?” ");
INSERT INTO lro_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","A damal ci, “Ngwüyäwüd ngwugekajidu ndi aar ang ükäcä nunnu nga je äpïjï Bulijing ngwämrä ngwudi Ngwüyäwüd bïgänü ndi ari aar otacalu mama gwani ngwujaꞌri ngwüngün. ");
INSERT INTO lro_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Aaꞌti be la je ämnäcï ngwujaꞌri ngwegen ndi ari gilo lonyadana yiꞌra küüꞌrï rom (40) gwürbäcäär. Lïmïꞌrïdï yiꞌrany lari laꞌti la eny aar ïyï ꞌdi aar ꞌrinye. Gilo liju mama gwenene lïdünïcängä nga je ämnäcï yiꞌral giyee.” ");
INSERT INTO lro_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","A kumndan dinga damal ngwele ngwugirinya ngwuci, “Aaꞌti nga gwondaci dïjü dere ndi ari nga gwondaciny ngwujaꞌri ngwee.” ");
INSERT INTO lro_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","A be kumndan urnidi yiꞌra rom (2) yüngün yidi gwuꞌtulunga küüꞌrï tudini (100) ngwuje ci, “Geꞌtar gwuꞌtulung je küüꞌrï tudini rom (200) mama na ngwongr ngwudi ngwumirta ꞌdï kwoꞌra täꞌrïl (70) na ngwongr küüꞌrï tudini rom (200) ngwugwodananu yiiri ye ndi ari aar ele Gäyïjärïyä dilunga didi gweneng ma lingen ru tudini kwoꞌrongo (9). ");
INSERT INTO lro_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Na ꞌto ngaa ombaci Bulijing ngwumirta ngwoko nggu allala nunnu ngwobani gwujaw nono gidartan dani Bilekej.” ");
INSERT INTO lro_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ngwüllïjï ngwujaꞌri ngwaru nu, ");
INSERT INTO lro_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ngwujaꞌri ngwee ngwïndï ꞌdünggüny gwani Kiludiyuj Lajiyaj, ngwükäcä je gwani dartan dani Bilekej, nggwagannanga. ");
INSERT INTO lro_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ngwüyäwüd ngwümätï guru nggee aar ji gito gadi aar ꞌrinye. Nje be bornada gwuꞌtulunga le lüny nje gätäjä, nyi lenge ndi ari giru Diruman. ");
INSERT INTO lro_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nyi bupi ndi lenge yiru ange yanni yimbojajaar je nono nje be äpïjä ngwämrä ngwegen ngwudi Ngwüyäwüd. ");
INSERT INTO lro_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nyi be mbuji ndi ari gwüꞌrïdädäär yiꞌral nono yidi yobo yegen. A be yere yaꞌti ndi ari aar gu ꞌrinyada na aar geꞌte korkon. ");
INSERT INTO lro_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","A be anni ma aar nyi ondaci ndi ari gur nggee nggo gïnïjäär, nga be ükäcä puprang. Liminje ondaca lanni lüꞌrïdädï yiꞌral nono ndi ari aar ila aar ang gätïjï yiꞌralalu yegen kur nggee.” ");
INSERT INTO lro_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","A gwuꞌtulunga ärrï yiꞌral giyee anaku ca je gu kumndan dilunga ndoo aar ape Bulijing aar gwe ele ꞌdi aar obani kündär gani Andibatrij. ");
INSERT INTO lro_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Bïgänü aar dingada ngwongr ngwe ngwudi ngwumirta aar ape aar gwe ele Gäyïjärïyä a be gwuꞌtulunga oꞌra gidilagany. ");
INSERT INTO lro_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Anni ma ngwongr ngwudi ngwumirta obani Bulij gwe Gäyïjärïyä, aar ätädä dartana dani Bilekej ngwujaꞌri aar ätädänï Bulijing. ");
INSERT INTO lro_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","A dartan uli ngwujaꞌri ngwanni ngwükäcäär je, ngwube utalu ndi ari Bulij ngwati ji ne. Ngwulenge ndi ari gwïndï ngwaalu ngwani Kïlïkïyä. ");
INSERT INTO lro_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Ngwube ari, “Nggwa ꞌdingini ngwujaꞌri ngwunga ma ji ma ngwüjï ila ngwanni ngwüꞌrïdädängä yiꞌral nono.” Ngwube ci gwuꞌtulung je aar arnga Bulijing ngwuꞌdun ngwudi yeleny ngwudi Yïrüdïj. ");
INSERT INTO lro_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Anni ma yomon ele aar ru tudini (5), a dirꞌdal danni diru giꞌra dani Ananiya aar üllï Gäyïjärïyä mbumbunga le loko na gur gati je ruci gani Tärtüllüj, aar ila yiꞌral ye yegen yüꞌrïdädäär je Bulijing nono aar je gätïjï dartanalu. ");
INSERT INTO lro_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Anni ma aar urnida Bulijing ngwänï, a Tärtüllüj ꞌdïꞌrï ngwondaji ngwügätïjï dartana yiꞌralalu yüngün dani Bilekej ngwari, “Gwani Bilekej, yeleny ye yunga, adatalu nggwo gwïrälü na bebere gwunga gwuma jaꞌrima ngwüjü ngwudi ngwaalu ngwee. ");
INSERT INTO lro_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ngwaalu ꞌdar na giyiꞌral ꞌdar, gwani dartan dani Bilekej, yämnï nje ar ang ci yäy ꞌtu gwupa gwulleny. ");
INSERT INTO lro_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","A be nunnu aaꞌti nggwa ji ndi ang ondaci ngwujaꞌri ngwolanu, nyi be ari nggwa ang päcälü nje geraci länï jayi gwe liguri gwunga nga ꞌdingini ngwujaꞌri ngwee ngwooko. ");
INSERT INTO lro_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Änyängä limbuju guru nggee giru dirngaja gati gwogaji ngwüjü aar ꞌdïꞌrï güündä ge ngwüjänü ngwuru Ngwüyäwüd giyen ꞌdar. Giru güktü ngwüjü ngwudi yobo yïndï Najra. ");
INSERT INTO lro_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ꞌDi ngwümïnï ndi rngïyï gobo gidi Ngwaalu nyii gu be mätä. ");
INSERT INTO lro_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Manari gima ang otacalu giligor lunga, nga gwa be lenge ndi ari ngwujaꞌri ngwärï gwani nginde ngwuru ꞌdidanu.” ");
INSERT INTO lro_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","A Ngwüyäwüd gekajidi ndi ari ngwujaꞌri ngwee ngwaraar ngwe ngwätï ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Anni ma dartan gïꞌtïjï Bulijing gay ndi ondaji, A Bulij ari, “Äny gwülïngïdï ndi ari nga gwätï ngwüdläyü ngwonyadu ngwanni ngwümäätä ngwe yelenya ngwüjï ngwudi ngwaalu ngwe, yäy gu no äny gwa ruci ligoꞌro lüny ligor le lijayanu. ");
INSERT INTO lro_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ya je be ombaji giyee giligor lunga, ndi ari giyomon yanni yima ele yiru ꞌdï na rom (12), äny gwändädï Üräjälïm ndi äpïjï Ngwaalinga yobo. ");
INSERT INTO lro_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","A be ngwüjï ngwee ngwüꞌrïdädïny yiꞌral nono ngwaꞌti nyi mbuju ndi nyii garnati dïjï dere kobanu, nyi ꞌti gwogaju ngwüjü ngwudi ngwämrä na ngwaalu ngwere kündär. ");
INSERT INTO lro_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","A be ngindenga gilee laꞌti ätï ngwujaꞌralu ngwere ngwanni ngwadi aar je inggidi ndi ari äny gwärrü yiꞌral yere yiki. ");
INSERT INTO lro_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","A be ngwujaꞌri ngwee ngwanni ngwaraar ngwe, äny ꞌto gwati äpïjï Ngwaalinga yobo ngwanni ngwämnä gu ngwügüürnä ngwärï nyi gwuji Gay gidi Deleny dani Yicu garaar ge gäꞌtüdï yobo yijaw. Äny gwämnä ngwujaꞌri ꞌdar ngwïndär Yobo ye yidi Müjä na Yïjïr yidi Ngwïjïr. ");
INSERT INTO lro_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Geꞌtaji gwüny Ngwaalu gwuru gweꞌte gweꞌte nono gwegen, ndi ari ngwüjï ꞌdar ngwanni ngwüdünälü na ngwanni ngwuki, ngwa ji ngwa ꞌdïꞌrï giyiꞌranyanu. ");
INSERT INTO lro_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Äny gwati mïnï yomon ꞌdar ndi ari aaꞌti äny gwätï ngwujaꞌri ngwere nono ngwanni ngwuki ngwäyänü Ngwaalu na ngwäyänü ngwüjï. ");
INSERT INTO lro_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Äny gwätï ngwüdläyü ngwonyadu gwaꞌti ju, nyi be kwodalu Üräjälïm gwäpïjä ngwüjü ngwüny ngwüꞌrïnyä ngwadacaar je ngwüjü ngwanni ngwunyangiralu na nyi elada ꞌto ndi gätïjï Ngwaalingalu. ");
INSERT INTO lro_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Äny gwügäꞌrïnä nono anni mbujaar nyi ngwämrä ngwudi gobo ndi ape yiiru giyee. Ngwüjï ngwonyadu ngwaꞌti nyii le ju, na äny ꞌto gwaꞌti ändï ngwujaꞌri ngwere ngwani yärä. ");
INSERT INTO lro_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","A be ꞌdogo Ngwüyäwüd ngwuju ngwoko ngwudi ngwaalu ngwani Ajiya. Ngindenga ꞌto gäbïcä je aar ang ondaci manari yere giyo yärrï nje yiru gimra. ");
INSERT INTO lro_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Na ngindenga gilee ngene, aar ang enggaci ngwujaꞌri ngwumne ngwanni ngwärrï nje ngwuki ꞌdi aar nyi apa nyi dünälä ngwäyänü ngwudi ngwämrä ngwudi Ngwüyäwüd. ");
INSERT INTO lro_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Manari yiru yanni yurnidiny ye dula ngwäyänü ꞌdenggen ndi ari, ‘Yiru yani ꞌdïꞌrï giyiꞌranyanu, yiru giyee yanni yïdünäjïny ngwäyänü ꞌdunggunga ndi nyi pïcï yelenya.’” ");
INSERT INTO lro_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Dartan dani Bilekej, danni dïlïngïdï Gay ge nggee gidi Deleny dani Yicu yorta ye ngwaalinga ngwüdünäjï pïng yelenya ngwari, “Manari kumndan gani Lajiyaj gima ila, nyi be pï yelenya giyiꞌral yunga.” ");
INSERT INTO lro_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ngwuci kumndaning gidi gwuꞌtulunga küüꞌrï tudini ngwarnga Bulijing aar gäbïcï ngwugatu linginalu gwooko a ngwumaad ngwüngün ila aar ombaji aar äpïjï yiiru yere. ");
INSERT INTO lro_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","A gwodanalu yomon cong, aji a dartan dani Bilekej daw de düngün dani Dürcïllä diru Dïyäwüd ila. Ngwükäjïdï ndi Bulij ndi ꞌdingini ꞌdünggüngün. A Bulij ondaci gwani ämnï ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Anni ma Bulij ji ndi ondaji ngwujaꞌri ngwani dünälü, na määtä lingina na obalu komon gidi gwodaning, a yedeny eny Bilekejing ngwuci, “Yoꞌra gu be no gweneno. Ïndï be. Ma ji ma gaji ji nggwa ang be ükäcä.” ");
INSERT INTO lro_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ating geꞌtaji ndi ari gwadi Bulij änïjï ngwubaꞌtanya nunnu ngwugatalu ngwele. No ating gu be ükäjïdï pïd pïd aar gwe ondaji. ");
INSERT INTO lro_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","A ngwüdlä ele aar ru rom (2), a dartan diꞌter allu giyeleny dani Bïrkïyüj Bictuj ngwumandi ndi Bilekej. A Bilekej jada ndi jayi Ngwüyäwüd ngwäy, ngwugatani Bulijing korkon. ");
INSERT INTO lro_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Anni ma dartan dani Bictuj obani ngwaalu ngwani Yäwüdïyä ngwape yomon täꞌrïl (3), ngwüꞌdïꞌrï ngwugatani Gäyïjärïyäng ngwallu Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ngenone a ngwurꞌdal ngwanni ngwuru ngweleny na ngweleny ngwudi Ngwüyäwüd ila yiꞌral ye yegen aar je ondaji gwani Bulij. ");
INSERT INTO lro_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","A Ngwüyäwüd büdäjï yiꞌral aar päcï Bictujingalu ndi ari ngwuje jayi ngwäy ndi ape Bulijing ngwudinga Üräjälïm ndi ari ngindenga gwürbäcäär kay gwadi aar ꞌrinye kayala. ");
INSERT INTO lro_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","A je Bictuj ci nu, “Bulij nggwo korkon ngenone Gäyïjärïyä, äny gwadi gu ele yomon yanu giyee. ");
INSERT INTO lro_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","A ngweleny ngwalu ila nyii ngwe ele aar ondaji yiꞌral yanni üꞌrïdädäär je guru nono ngenone manari giyoo yärrüng je yere yanni yiki.” ");
INSERT INTO lro_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Anni ma Bictuj jalu yomon ya ru ꞌdübä (8) na ya ru ꞌdï (10) ngenone ꞌdenggegen, ngwüꞌdïꞌrä ngwüllä Gäyïjärïyä. A bïgänü nggwoo ngwujalu ngwämrä ngwudi pï yelenya ngwari aar äpïjä Bulijing. ");
INSERT INTO lro_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Anni ma Bulij obana, a Ngwüyäwüd ngwanni ngwüllü Üräjälïm aar änänü, aar ondajaji ngwujaꞌri nono ngwonyadu ngwuki, aar je ꞌti burna ndi ätïyï ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","A be Bulij ruci ligoꞌro lüngün ngwari, “Äny gwaꞌti ärrä yiꞌral yere yiki yani yobo yidi Ngwüyäwüd, na yani gobo na deleny didi Rumang dani Gayijar.” ");
INSERT INTO lro_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","A be Bictuj bupi ndi jayi Ngwüyäwüd ngwäy, ngwube ci Bulijing nu, “A gwämnä nga allu Üräjälïm a gu pïcï yelenya ngenone giyiꞌral giyee yüꞌrïdädärä je nono?” ");
INSERT INTO lro_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","A be Bulij ci, “Äny ngweneno ngwüdünädï ngwäyänü giyeleny yidi deleny didi ngwelenyinga Ruma dani Gayijar, aar nyi gu pïcï yelenya. Äny gwaꞌti ärrïjä Ngwüyäwüd yiꞌral yere yiki, anaku lïngïdä gu ngwujaꞌralu ꞌdar gwani Bictuj. ");
INSERT INTO lro_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Manari äny gwukiya yobo yidi Ngwüyäwüd yiꞌral ye yere ligoꞌro le lüny yadi nyi gäbïcï aar nyi ꞌrinye, äny gwaꞌti ꞌdonya yiꞌrany. A be ngwujaꞌri ngwanni ngwondaja je Ngwüyäwüd ngwaꞌti ätï ngwäyänü, no dïjï dere daꞌti diny ape aar nyi ätädä Ngwüyäwüd. Äny nggwelada gweere gideleny didi ngwelenyinga Ruma dani Gayijar.” ");
INSERT INTO lro_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Anni ma Bictujinga otajidalu ngwartan ngwe ngwüngün, ngwube ngwari, “Nga gwaru nga gwele gweere gideleny didi ngwelenyinga Ruma dani Gayijar, äny gwa ang ci ïndï.” ");
INSERT INTO lro_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Aar jalu yomon cong a deleny dani Agiribaj ila gwenggen gwe gwuru gera gwani Brïnïkï aar obana Gäyïjärïyä ndi aganni Bictujing. ");
INSERT INTO lro_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Anni rar ladi jalu ngenone yomon yonyadu, a Bictujinga abingadi giyiꞌral yidi Bulij Agiribaj gwe. Ngwuci, “Gur geꞌte nggo ngene gigatana Bilekej korkon. ");
INSERT INTO lro_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Anni minyi ele Üräjälïm, a ngwurꞌdal ngwanni ngwuru ngweleny na mbumbunga lidi Ngwüyäwüd apa yiꞌral yüpädäär je nono aar ari aar gwe obalu. ");
INSERT INTO lro_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nje be ci nyängä liru Ngwuruman gïdïmürä därï lati ꞌti gikaja dïjü yiꞌral yere ꞌdi aar dünätï ngwüjïngä le ngwanni ngwüꞌrïdädï yiꞌral nono ngwumbuji gay ngwuruci ligoꞌro lüngün giyiꞌral yüpädäär je nono. ");
INSERT INTO lro_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Anni ma aar ila ngene, nyi ꞌti jana yiꞌral ye giyee, bïgänü nggwoo nyi jalu ngwämrä ngwudi pï yelenya nyi ükäjïdï ndi Bulij aar apa. ");
INSERT INTO lro_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Anni ma ngwüjï ngwoo ngwüꞌrïdädï yiꞌral nono ondaji, aar ꞌti üpädï yiꞌral nono yere yärrüng je yiki yigeꞌtajiny gu ndi ari yadi aar ye ari. ");
INSERT INTO lro_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","A be garnati ru gwani yobo yegen aar ani gur gayu gani Yicu garu ge Bulij nggo gimidu. ");
INSERT INTO lro_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nyi ꞌti lïngïdï ndi ari awa nyi utalu yiꞌral ye giyee. No nyi be ci Bulijing gwadi ele Üräjälïm aar gu ombaci yiꞌral giyee yüpädäär je nono ngenone. ");
INSERT INTO lro_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Anni ma Bulij ari gwadi ele gweere gideleny didi Rumang ngwüpäcälü yiꞌral ye giyee, nyi be ci gwuꞌtulung je aar ombaji ꞌdi a gomon ila nyi dinga gideleny didi Rumang dani Gayijar.” ");
INSERT INTO lro_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","A be Agiribaj ci Bictujing nu, “Äny gwüjädï ndi ꞌdingini ngwujaꞌri ngwudi gur nggee.” A Bictuj ci, “Ga ang ꞌdingini bïgänü.” ");
INSERT INTO lro_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","A bïgänü nggoo a Agiribajinga Brïnïkï gwe a je ngwüjï ruya yelenya yipa aar änï ngwuꞌdun ngwudi oꞌrajidalu ngwubegenga le ngwudi gwuꞌtulunga na ngweleny ngwudi gündär. A Bictuj ükäjïdï aar apa Bulijing. ");
INSERT INTO lro_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Anni ma aar apa, a Bictuj ari, “Gwani deleny dani Agiribaj, na nga nga ꞌdar lanni gilo ngene, ngaa länggädï guru nggee! Ngwüyäwüd ꞌdar kiꞌdu güꞌrïdädäär yiꞌral nono ngenone Üräjälïm na ngene Gäyïjärïyä. Aar ürrï dula aar ari gaꞌti äwdï nding jalu gimidu. ");
INSERT INTO lro_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","A be äny gaꞌti nyi mbojaja yiꞌral nono yere nunnu aar ꞌrinye. Gima be ari gele yiꞌral ye gweere gideleny didi Rumang. Nggwuma ari ginyi dinga gele Ruma. ");
INSERT INTO lro_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","A be yiꞌral yere yaꞌti yilinginna yadi nje üllïjï delenya didi Rumang gwani ngwujaꞌri ngwüngün. Yäy gu no nggee gima je äpïjä ngwäyänü ꞌdanggalu ꞌdar na gwece gwece ngwäyänü ꞌdunggunga gwani Agiribaj, nunnu manari yere yima ji yima mbüjïnï nje ulli. ");
INSERT INTO lro_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ndi ari yaꞌti ya ele kayalu ndi nyi dinga dïjü dïgïkïnä giyirna aar ꞌti be linginna yanni yüpädäär je nono.” ");
INSERT INTO lro_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","A deleny dani Agiribaj ci Bulijing nu, “Äny gwügïꞌtïjängä gay nga ruci ligoꞌro lunga.” A Bulij alliji guyala güngün ngwondaji ngwuruci ligoꞌro lüngün ngwari, ");
INSERT INTO lro_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Gwani deleny dani Agiribaj, äny gwänggädï ndi ari lalli nje kil ndi nyi dünälä ngwäyänü ꞌdunggunga gwene nyi ruci ligoꞌro lüny gwani yiꞌral ꞌdar yanni yüꞌrïdädäär nje Ngwüyäwüd nono, ");
INSERT INTO lro_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","a gwece gwece ndi ari nga gwülïngïdï dïmürä ꞌdar didi Ngwüyäwüd nga lenge garnating gwegen. Yäy gu no, äny gwa ang päcälü nyi geraci länï nga ꞌdingini. ");
INSERT INTO lro_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Ngwüyäwüd ꞌdar ngwülïngïdï elelleng gwüny gwanni gwelelleny anaku ꞌdïꞌrïny gwälü ꞌtuꞌtu yogo ye ken güny, na ꞌto kündär gani Üräjälïm. ");
INSERT INTO lro_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ngindenga lïlïngïdïny gaji golanu la gu ari ma aar mïnï, ndi ari anaku aru gu gay gojema yiꞌral gidi dïmürä didi yobo yärï, äny gwelella gwuru Dïbärrïjï. ");
INSERT INTO lro_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Yiru giyee yanni yïdünäjïnyälä ngene aar nyi pïcï yelenya gwani geꞌtaji gwüny ngwujaꞌri ngwanni ngwuca ngwe Ngwaalu ngwügürnä ngwärï. ");
INSERT INTO lro_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ngwujaꞌri ngwuru ngwanni ngwuca ngwe Ngwaalu gïïlü gärï ꞌdï na rom (12) ngwanni ngwujicaar jalu aar je gwuji aar gu äpïjï Ngwaalinga yiiru yigor ye ꞌdidanu dilu de na lingen le nunnu aar ila aar gu ru. Gwani deleny dani Agiribaj, yiru giyee yanni yïgäbïcä Ngwüyäwüd aar nyi be üꞌrïdädä yiꞌral nono. ");
INSERT INTO lro_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ngaa larra gilee ngaa ꞌti be ämnä ndi ari Ngwaalu ngwätï yiima ndi ꞌdïꞌrïyï ngwüjälü ngwanni ngwayu? ");
INSERT INTO lro_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Äny giligoꞌro lüny gwerre gwücïnänü nyi ꞌdonya yiima ye yüny ꞌdar nyi etaci ngwüjü ngwürïny ngwudi Yicu gwudi Najrang. ");
INSERT INTO lro_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yiru giyee yanni yärrï nje ngenone Üräjälïm. Yeleny ye ngwurꞌdal ngwanni ngwuru ngweleny nyi ye ummi ngwüjü ngwudi Ngwaalu nje geꞌte korkon, na ma aar ru ladi aar je ꞌrinye, nyi ämnï ndi ari aar je ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Yomon yonyadu ati nyi ele ngwämrä ngwämrä nje reraji nje linyaci yiima ye ndi aar nyïꞌrïnï ämnïng Ngwaalu gwegen. Dirlele gwe gwüny ndi nje übïnälü, nyi ꞌdïꞌrï nyi ele gïyündär yidi ngwüjï poor ndi nje übïnälü.” ");
INSERT INTO lro_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Gomon geꞌte nyi ji ndi ele kündär gidi Dimajiging yeleny ye na ngwujaꞌri ngwe ngwurꞌdal ngwanni ngwuru ngweleny. ");
INSERT INTO lro_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Anni minyi ji kay lingen le lïdünälä gwani deleny, nyi engga buri gwüllü kerala gwitananu gilingen. Aar nyi oꞌrralu na ngwüjï ngwïndï nyii ngwe. ");
INSERT INTO lro_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nyii ïꞌdï ꞌdar gïdïyängälü. Nyi be ꞌdingini yal aar nyi urnida aar nyi ondaca Yärmïyängä, ‘Jawul Jawul, nga gwarra miny übïnälü? Nga gwaꞌti gwa burni ndi obe dajiliru gora ge.’ ");
INSERT INTO lro_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nyi otacalu nyi ci, ‘Nga gwani yärü doorta?’ Aar nyi ci, ‘Äny gwuru gwani Yicu gwanni gwübïnängälü. ");
INSERT INTO lro_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ꞌDïꞌrälü gweneno nga dünälä yora ye. Äny gwüꞌtäcängälü nunnu nga geꞌte nga ru dïnädä düny, nga ru gwanni gwadi ondaci ngwüjü ngwujaꞌri ngwanni ngwuma je engga gwenene ꞌdünggüny na mana ngwanni ngwada je enggaci. ");
INSERT INTO lro_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nggwa ang gätäjï ngwüjï ngwunga na ngwüjï ngwuru Garany ngwanni ngwada gu ükäjï. ");
INSERT INTO lro_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Nga je ïgïtï ngwäy nga je gwäꞌrä gïdïrïmänü aar ila giburalu nga je ꞌtüyï kuyanu gidi dijegoꞌrr aar oꞌrada Ngwaalu nunnu a je Ngwaalu düdänïjänü ndi ke gwegen aar ape yuꞌrina ngwüjïngä le ngwanni ngwüjüꞌrïnä ämnï gwe gwegen ꞌdünggüny.’ ");
INSERT INTO lro_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Yäy gu no gwani deleny dani Agiribaj, nyi ꞌti nyortaca yiꞌralanu yänggädï nje dilingidu yüllü kerala. ");
INSERT INTO lro_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nyi ondaci ngwüjü ngwujaꞌri ngwe gwerre gwerre ngwudi Dimajiging, na ngwudi Üräjälïmïng na ꞌdar ngwudi Yäwüdïyä ꞌdi a be ngwüjï ngwuru Garany ꞌto. Nje ondaci ndi ari aar ꞌdingini ngwujaꞌri ngwudi Ngwaalu aar joꞌrenyana giyiꞌral yegen yanni yiki. Aar inggidi joꞌrenyaning gwegen ape gwe yiiru yanni yijaw. ");
INSERT INTO lro_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Yiru giyee yanni yïgäbïcä Ngwüyäwüd aar nyi määtä ngwämrä kobo aar nyi nani ndi ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","A be Ngwaalu ru ngwetadu ꞌdünggüny, ꞌdi gomon gidi gweneng, yäy gu no äny gwüdünü ngene nje enggaci ꞌdar, danni dipa na danni dooko. Yere yaꞌti nje ondaju yolana goralu giyobo yanni yondaja je Müjä na gïyïjïr yanni yondaja je ngwïjïr ndi ari yaji ya ji. ");
INSERT INTO lro_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ndi ari gwanni Gwubrutaar yelenya gwa yiꞌrendeny mbuji gwa ru giꞌra ndi ꞌdïꞌrä giyiꞌranyanu gwa ondaci ngwüjü ngwüngün na ngwüjü ngwuru Garany buri gwe.” ");
INSERT INTO lro_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","No a Bictuj üꞌrïcï Bulijing ngwujaꞌranu ngwaw dulu de ngwuci, “Nga gwuma rlälï kiꞌranu mbüny gwani Bulij! Bebere gwunga gwonyadu gwuma ang ruji giꞌra milang.” ");
INSERT INTO lro_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","A be Bulij ci, “Äny gwaꞌti rlälü kiꞌranu gwani dartan dani Bictuj. Yanni yondaji nje yätï ngwäyänü aar ele kayalu. ");
INSERT INTO lro_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Gwani deleny nga gwülïngïdï yiꞌral ye giyee yorta ye ngwaalinga, äny gwügätïnä linginalu nda je ondacalu tired. Nggwïcïnänü ndi ari yere yaꞌti yima ang madinalu, ndi ari yaꞌti ärrïnä yuꞌrimi.” ");
INSERT INTO lro_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","A Bulij ci, “Gwani deleny dani Agiribaj, Nga gwämnä ngwujaꞌri ngwudi ngwïjïre? Äny gwülïngïdï gu ndi ari nga gwämnä gu.” ");
INSERT INTO lro_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","A be deleny dani Agiribaj ci Bulijing, “Nga gwugeꞌtaja ndi ari gaji ge gooko no, nga gwuny gwäꞌrï nyi ruji dïkïrïjïne?” ");
INSERT INTO lro_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","A Bulij ci, “Äny gwotaca Ngwaalingalu ndi ari a gaji ru gooko ngwolanu, nga na ngwüjï ꞌdar ngwanni ngwo ngwuꞌdinginiiny gweneno, aar ru ngwïkïrïjïn nono änyïng, ꞌdogo aaꞌti be ngwa ji giyirna nono änyïng gweneno.” ");
INSERT INTO lro_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","A deleny dani Agiribaj ꞌdïꞌrälü na dartan dani Bictuj na Brïnïkï na ngwüjï ngwanni ngwuji aar le. ");
INSERT INTO lro_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Aar ꞌtüdä gïdrü aar abingajidi aar ari, “Gur nggee gaꞌti ärrü yiꞌral yere ndi aar gu ꞌrinyada aar gu geꞌte korkon.” ");
INSERT INTO lro_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","A deleny dani Agiribaj ci dartana dani Bictuj, “Gur nggee gaadi gätïnälü ngwele adinari gima ꞌti aru ga pälü yiꞌral ye giyee gideleny didi Rumang dani Gayijar.” ");
INSERT INTO lro_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Anni ma aar ari nyii ꞌdïꞌrï nyii ele giyaanu nyii ele Italiya, Bulij na ngwüjï ngwoko ngwanni ngwugennaar ngwe giyirna aar je ätädä kumndaning gidi gwuꞌtulunga küüꞌrï tudini (100) gani Jülïyüj gidi gwuꞌtulunga kiꞌdu gwudi deleny didi Rumang. ");
INSERT INTO lro_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nyii ꞌdïꞌrï bälükä gwe gwudi gündär gani Adramitiyum gidi Ajiyang, gwadi ele giyumu gïyïmämü yidi Ajiyang, nyii ꞌtü nyii ele giyaanu. Gur gani Arictakuj, gidi Majiduniya kündär gani Täjlänükï nyii le ji. ");
INSERT INTO lro_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Bïgänü nggwoo nyii üllälü kündär gani Jäyïdä, a Bulij ïnä Jülïyüjïng ngwügäbïcï ngwele ngwumaad ngwüngün nunnu manari gwuma mïnï ngwony ngwere aar je ätä. ");
INSERT INTO lro_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nyii ꞌdïꞌrï ngenone mana nyii ele giyaanu, ndi ari nyii lïgwümädï dirunanu, nyii gwurli nyii raji bälükä giri ge gidi Gabrujing ganni gaꞌti gu dirun ärädï. ");
INSERT INTO lro_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Anni minyii ruyi bälükä nyii ele ꞌdi nyii üꞌrü yaanu yidi ngwaalu ngwani Kïlïkïyä na Bämbïlïyä, nyii üllälü kündär gani Mira ngwaalu ngwani Lïjïyä. ");
INSERT INTO lro_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ngenone a kumndan gidi gwuꞌtulunga küüꞌrï tudini mbuji bälükä gwudi Ïjïkändärïyäng gwïndï gwadi ele Italiya, aar nje gu änïjänü. ");
INSERT INTO lro_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nyii ꞌdïꞌrï nyii ele minyol yomon yonyadu ꞌdi a yiꞌral ojeme ndi nyii obani kündär gani Jïnïdüj. Anni ma aar nje ꞌti dirun gäbïcü ꞌdi nyii üllï gay ge gidi Jïnïdüjïng nyii ruyi bälükä giri ge gidi Kïrïdïng ganni gaꞌti gu dirun ärädï gwujacidaar ngwaalu ngwe ngwuꞌdumbala giyaanu ngwucaar je Jalmuni. ");
INSERT INTO lro_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Anni minyii gu ïräjä yiimalu ꞌdar ꞌdi nje gatana nyii ele ngwaalu ngwati aar je ci Yumu Yanni Yijaw, ngwuju gito gito kündär gani Lajiya. ");
INSERT INTO lro_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nyii ji ndi ele giyaanu ꞌdi a gaji ele ngwolanu, a yiꞌral ke ngwäyänü ndi ari nyii üꞌrü yaanu. Ndi ari Gomon gidi Jaꞌrima yigor gima madinalu. No a Bulij arnga ngwüjü ngwuje ci, ");
INSERT INTO lro_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Ngwüjï, äny nggwo gwänggädï ndi ari yiꞌral yadi ele ndi ke ngwäyänü gïdïlä dege ndee ya geraji bälükälü na ngwong ngwüpïnïng je na gwani gilang gwege nggwo ngwaalu ngwuki ꞌto.” ");
INSERT INTO lro_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","A be kumndan gidi gwuꞌtulunga küüꞌrï tudini obe ngwujaꞌri gora ge ngwudi Bulij ngwuje be ämnï ngwudi gur ganni giruya bälükä na ngwudi gur gidi bälükä. ");
INSERT INTO lro_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Anni aaꞌti gumu jaw diruna didi digo ngenone ndi gu bälükä üllädälü, a ngwüjï onyadani ngwanni ngwuma ari nyii elada gweere nyii geꞌtaji ndi nyii obani kumu gani Bunikij ngwaalu giyaanu ngwani Kïrïd, nyii gu üllädälü ngenone digo de. Gumu nggee gombataar ngwaalu ngwe kaama giꞌra ge aar ombati ngwaalu ngwe kängïr giꞌra ge. ");
INSERT INTO lro_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Anni ma dirun dïndï kaama araalu doko, a ngwooꞌra ngwudi bälükä geꞌtaji ndi ari yanni yibupaar je yima aar je mbuji. Aar gwallada yuduꞌralu mbüny aar je alliji gïbälükälä aar ruyi aar millidi gïmämäng nono gito gito gidi Kïrïdïng. ");
INSERT INTO lro_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Aaꞌti gaji olanu gwooko no, a dirun diru giwerr araalu ndüm ngwila ngwaalu giyaanu dicaar, “Gängïr gïtäny gwe.” ");
INSERT INTO lro_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ngwape bälükä ngwuꞌti ätï yiima ndi obe dudanu. No nyii gwalli ngwuy nyii gäbïcïjï dudu aar nje apada. ");
INSERT INTO lro_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Anni minyii millida giri ge gidi ngwaalu giyaanu ngweꞌte ngwoko ngwani Käwüdä, nyii ji ꞌdïꞌdäny ꞌdi nyii allija bälükä gwudi gätäjï gïbälükälä. ");
INSERT INTO lro_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Anni ma aar allija bälükä gwudi gätäjï gïbälükälä, aar änïjï ngwaralu gilaranu lidi bälükä aar gekajidi nunnu aaꞌti gwa badalu. Yedenyo ndi ari la je le bälükä obe dïjïcïrä diꞌdumbala didi gïmämü gidi Lïbïyäng, aar ülläjï ngwuredalu ngwati ji dirun gägïrï ngwudi bälükä aar gäbïcï a gwe dirun landalu. ");
INSERT INTO lro_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","A nje gu dudu ändänü danni dikana ꞌdi anni ma bïgänü ru aar ꞌdïꞌrï aar otada ngwony ngwoko giyaw ngwapanaar je bälükä gwe. ");
INSERT INTO lro_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Anni ma gomon ru täꞌrïl (3), aar määtä ngwony ngwudi bälükä aar je gagitu ngwuy ngwe giyaw. ");
INSERT INTO lro_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","A yomon onyadi nyii ꞌti änggädï lingeno na yuurrum a dudu ari gwurꞌtal danni dikana ꞌdi nyii gwalli ngwäy ndi gilang. ");
INSERT INTO lro_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Anni ma ngwüjï ngwanni ngwïndï bälükä gwe onje yomon aar ꞌti ïtï, a Bulij ꞌdïꞌrï ngwüdünï gidiliganu ngwuje ci nu, “Lani ngwüjï, adinari ngaa liminy ämnäcï ngwujaꞌri ngwüny gwele, ar ꞌti gatana Kïrïdïng, a laadi jayi nono na geradalu nggwee gwaꞌti gwaadi ji. ");
INSERT INTO lro_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","A be gwenene nggwubupa je nga gatu yigoralu gwaꞌti gwere ꞌdanggalanu gwa dudi ꞌdogo bälükä gwuru gwanni gwa ke. ");
INSERT INTO lro_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Gwele dilu de, gïꞌrr gidi Ngwaalu ngwüny ngwanni ngwati nje äpïjï yobo, gïdünäcïny aar nyi ondaci ");
INSERT INTO lro_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ngwari, ‘Aaꞌti yedeny ya ang eny gwani Bulij, nga gwa dünï ngwäyänü ngwudi deleny didi Rumang dani Gayijar, gilang gwudi ngwüjï ngwee ꞌdar ngwïndä ngwe, yïmïꞌrü ye yidi Ngwaalu ngwätädäärä je.’ ");
INSERT INTO lro_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ngwüjï, ojemar nono ndi ari nggwämnä Ngwaalu ndi ari yanni yarung ye yadi ele ndi ätï ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","A be alanga la obalu ngwaalu ngweꞌte ngwuru dïyäng giyaanu.” ");
INSERT INTO lro_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Gidilunga danni dima ru ꞌdï na kwoꞌrongo (14), aar nje gu dudu jina ndi ape no giyaanu yidi Ädïrïyäng, diligeny danu a ngwooꞌra ngwudi bälükä cïnänü ndi ari lima ji dïyängü gito. ");
INSERT INTO lro_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Aar ülläjï gar aar dïdïmä yaw aar je mbuja yolanu yiru yoranu küüꞌrï nyärläl (120). Aar jalu gwooko oꞌre aar je dïdïmï aar je mbuja yima ru yoranu ꞌdï tudini kwoꞌrongo (90). ");
INSERT INTO lro_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","A nje yedeny eny ndi ari bälükä gwunje gwe obalu giyoꞌrr, aar gatu yuduꞌru kwoꞌrongo gwodan gïbälükä nyii dünïcï ngwaalinga aar uꞌri. ");
INSERT INTO lro_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","A be ngwooꞌra ngwudi bälükä mïnï ndi abri aar gatani bälükä, aar ꞌdïꞌrï aar ape bälükä gwudi gätäjï aar ülläjï giyaw aar arri nono ladi ülläjï yuduꞌru kiꞌra gidi bälükä. ");
INSERT INTO lro_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","A be Bulij ondaci kumndaning gidi gwuꞌtulunga küüꞌrï tudini na gwuꞌtulunga ngwuje ci, “Manari ngwüjï ngwee ngwuma ꞌti jalu gïbälükänü, dïjï dere daꞌti da gilang.” ");
INSERT INTO lro_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","No a gwuꞌtulunga üꞌrïꞌtï ngwaranu ngwanni ngwati määtädä bälükälü gwudi gätäjï aar gäbïcï a yaw ape. ");
INSERT INTO lro_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Gwerre gwerre ndi ngwaalu uꞌri, a je Bulij abingaci ku ndi ari aar eny. Ngwuje ci, “Gwene yomon yima ru ꞌdï na kwoꞌrongo (14) ngaa lïdünïcä yiꞌral yomon giyee ꞌdar ngaa ꞌti ïtï gonyalu gere. ");
INSERT INTO lro_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nggwa je päcälü ndi ari, ïtär ngwony ngwoko ara je gwodaji ngaa gilang gwere gwaꞌti ꞌdanggalanu gwa dudi läꞌrü lüngün kiꞌra.” ");
INSERT INTO lro_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Anni mung ari ngwujaꞌri ngwee, ngwape gona ngwuci Ngwaalinga yäy ꞌtu ngwäyänü ꞌdenggen ꞌdar. Ngwube üꞌränü ngweny. ");
INSERT INTO lro_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","A ngwüjï ꞌdar aar gatu yiguralu aar eny ꞌto. ");
INSERT INTO lro_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ngwüjï ꞌdar ngwanni ngwuju gïbälükänü ngwuru küüꞌrï tudini rom na ꞌdï kwoꞌra täꞌrïl na nyärläl (276). ");
INSERT INTO lro_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Anni ma aar eny aar pe aar gagitu yona ngwäy giyaw nunnu a bälükä ängränü. ");
INSERT INTO lro_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Anni ma ngwaalu uꞌranu, aar ꞌti lïngïdï dïyäng de yorta ye ngwaalinga. Aar be engga ngwaalinga ngwurmitu gu giꞌra gidi yaw ngwätï yïmämäng yiru dïjïcïr aar ari la gu raji bälükä ma aar ätï yiima. ");
INSERT INTO lro_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Aar üꞌrïꞌtä ngwaralu mbüny ngwudi yuduꞌru aar je gäbïcï aar üllï giyaw. A ꞌto aar gwalla ngwaralu mbüny ngwanni ngwati gekaji ngwalamalu ngwati aar ngwe ruyi bälükä, aar allijaji diredala didi dirun kiꞌra gweere a je dirun dinga aar elada kïmämü. ");
INSERT INTO lro_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","A be bälükä abri ngwobalu gïdïjïcïr diꞌdumbala ngwänïjï giꞌra gïdïyäng ngwümätïnälü. A gwe dudu pälü gwodan ngwukiyi ngwubadalu. ");
INSERT INTO lro_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","A be gwuꞌtulunga ru ladi ꞌrinye ngwüjü ngwugenna giyirna nunnu aaꞌti ngwa pï yaw ngwa ꞌtü kïmämü ngwabri. ");
INSERT INTO lro_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","A be kumndan gidi gwuꞌtulunga küüꞌrï tudini bupi nda Bulij midi ngwuje etaci ndi ärrï yiꞌral giyoo. Ngwuje ci lanni lïngïdï pïng yaw, aar aw yaw gwerre gwerre aar ꞌtü kïmämü. ");
INSERT INTO lro_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Aar je be gwujani loko yüꞌrï ye yidi bälükä. Gay ge nggee, nyii ꞌtü ꞌdar gïdïyängälü lijaw nono. ");
INSERT INTO lro_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Anni minyii obani lijaw nono, nyii lenge ndi ari ngwürïny ngwudi ngwaalu giyaanu ngwoo ngwani Malta. ");
INSERT INTO lro_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","A nje ngwüjï ngwudi Maltang gïꞌtïjï yïrnü yipa. Aar nje müjïjï lïgä nyii gu ji aar nje ülläjälü ndi ari gere ginu a ngwaalu jïlï. ");
INSERT INTO lro_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","A Bulij uta yüüꞌrälü ngwuje gatu gïlïgä a lägïrïny liju gïyüꞌränü a lïgä büdïyä nono ngwüꞌtüdä ngwümïꞌränï kuy güngün. ");
INSERT INTO lro_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Anni ma ngwüjï ngwudi ngwaalu giyaanu ngwo engga düngäyü guy nono güngün, aar abingadi aar ari, “Gur nggee ya giꞌrinyidu, ngwune ari gima gwannada yaw a be gaꞌti ga yiꞌral yanni yüdünälü gäbïcï ndi midi.” ");
INSERT INTO lro_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","A Bulij düdïrä düngäyü gïlïgä aaꞌti yiꞌral yere akana nono. ");
INSERT INTO lro_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","A ngwüjï ji ndi geꞌtaji ndi ari gwallalu na gwa yiiya mananu gwïꞌdï ꞌtïr gwa ayi. Anni ma aar dünïcï gaji golanu aaꞌti yiꞌral yere ju ꞌdünggüngün, aar gwurli aar ari gwuru ngwaalu. ");
INSERT INTO lro_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Gito gito ngwaalu ngenone giruny giju gu gidi dartan didi ngwaalu giyaanu dani Bupiliyuj. Aar nje ape nyii jalu ꞌdunu ꞌdünggüngün ꞌdi nyii ape yomon täꞌrïl (3) aar nje geꞌte gïyïrnü. ");
INSERT INTO lro_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Nyii mbuji papang gwüngün gwundru ngwümbür gwübüdü nono a yindi määtä. A Bulij ändädä anni mung otaci Ngwaalingalu ngwalliji guy nono ngwuꞌri nono. ");
INSERT INTO lro_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Anni ma yiꞌral ji giyee, ngwüjï ꞌdar ngwanni ngwümä ngwaalu giyaanu, aar ila aar je uꞌriyi nono. ");
INSERT INTO lro_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","A ngwüjï ngwudi ngwaalu giyaanu aar nje geꞌte gïyïrnü yipa yonyadanu na anni minyii ji mama ladi ele giyaanu, aar nje gendaci ngwony ngwudi eny na ngwong ngwanni ngwümïnï nje. ");
INSERT INTO lro_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Anni ma ngwüüwä ele aar ru täꞌrïl (3) nyii ꞌdïꞌrï nyii ele bälükä gwe ngwanni gwïndï kündär gani Ïjïkändärïyä gwädïnä digo de ngwaalu giyaanu gwüꞌtädäär giꞌremna kiꞌra gidi ngwaalu ngwuru ngwänggïl ngwegen ngwucaar je Jactur na Bullukij. ");
INSERT INTO lro_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nyii ele ꞌdi nyii obani kündär gani Jayirakuj ngwaalu giyaanu ngwani Jïjïlï nyii gu jalu yomon täꞌrïl (3). ");
INSERT INTO lro_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nyii ꞌdïꞌrä ngenone nyii ele kündär gani Rägïyüm kumu gidi Italiyang. A bïgänü nggwoo, a dirun anda kuyala gidi gaama ngwudinga bälükä nyii gu elanu, na bïgï nggwoo nyii obani kündär gani Batiyuli. ");
INSERT INTO lro_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ngenone nyii mbuji ngwïkïrïjïnä ngwanni ngwuminje urnidi yïrnü nyii le jalu yomon kwoꞌra täꞌrïl (7). Ngenone nyii gwoda gay nyii ele Ruma. ");
INSERT INTO lro_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","A ngwïkïrïjïn ngenone, ngwuꞌdingina ndi ari änyängä gilo lïndï, aar ꞌdïꞌrä ꞌtuꞌtu Ruma ꞌdi aar obana ngwaalu ngwudi ngwiliny ngwani Burum gwudi Abijujing na Ngwuꞌdun Täꞌrïl (3)ngwudi Yïrnü aar ila ndi nyii le mbudi. Anni ma je Bulij engga no, ngwuci Ngwaalinga yäy ꞌtu ngwojeme nono. ");
INSERT INTO lro_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Anni minyii obani Ruma, aar gäbïcï Bulijing ngwuji jücü a gwuꞌtulu arnga. ");
INSERT INTO lro_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Yomon täꞌrïl gwodanalu, ngwurnida ngwelenya ngwudi Ngwüyäwüd gwüpäng. Anni ma aar oꞌrajidalu, a je Bulij ci, “Lani ngweengga, nggwaꞌti ärrïjä ngwüjü ngwege na dïmürä didi ngwügüürnä ngwege yiꞌral yere yanni yiki, aar nyi be määtä Üräjälïm aar nyi gika aar nyi ätädä Ngwuruman. ");
INSERT INTO lro_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Aar ombaji ngwujaꞌri ngwüny aar nyi ru ladi gatalu, ndi ari nggwaꞌti mbüjïnä yiꞌral nono yere adi aar nyi gu ꞌrinyada. ");
INSERT INTO lro_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","A be anni ma Ngwüyäwüd ꞌdonya, ꞌdi a nyi ligor ape nyi ari nggwäpäcï delenyalu didi Rumang dani Gayijar, yaꞌti ani ndi ari nggwätï yiꞌral yere yadi nje üꞌrïdä ngwüjü nono ngwüny. ");
INSERT INTO lro_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Yiru giyee yanni yïgäbïcïny nga je gu be utalu nunnu nga je engga ar ondaji. Yiru yani dünïcï gwudi ngwüjï ngwüny ngwani Yïjïräyïl gwanni gwätäär nyi be genne giyirna giyee.” ");
INSERT INTO lro_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Aar be ci, “Änyängä laꞌti mbuja ngwujaꞌri ngwïndï Yäwüdïyä ngwani nga, a diweengga dere daꞌti dïndï ngenone ngwondaji ngwujaꞌri ngwere ngwuki ngwani nga. ");
INSERT INTO lro_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","A be änyängä libupa ndi ꞌdingini yiru ange yunga, ndi ari lïlïngïdï nunnu ngwüjï ngwaalu mbüny mbüny ngwondaja ngwujaꞌri ngwübïnä gayalu nggee.” ");
INSERT INTO lro_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Aar je geꞌte ndi ari aar mbuji Bulijing gomon geꞌte, aar ila ꞌto lonyadana aar oꞌrajidalu kilanggu ngwuꞌdun ngwanni ngwuju gu Bulij. ꞌTuꞌtu dilu danu ꞌdi a ngwaalu ru degera, ngwuje enggaci yiꞌral yidi yeleny yidi Ngwaalu ngwunani nding je gwäꞌrä aar lenge ndi ari Yobo yidi Müjä na Yïjïr yidi Ngwïjïr yondaja gwani Yicu. ");
INSERT INTO lro_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","A loko a je yiꞌral ïꞌdänü yari ye Bulij a loko ꞌdonya ndi ämnï. ");
INSERT INTO lro_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","A ngwüjï üꞌrïꞌtïdänü. Aar ꞌtü aar ele anni ma je Bulij ci ngwujaꞌri ngwee, “Lïgïꞌrïm lanni Lijuꞌru lätïyä ngwujaꞌri ngwäyänü anni ondacing je gwani ngwügüürnä ngwaalu lingla le lidi dïjïr dani Ajaya. ");
INSERT INTO lro_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ngwari, ‘Ïndï ngwüjï ang ari, Ngaa la ꞌdingini ꞌdogo a be ngaa laꞌti la lenge aꞌtur, ngaa la engga ngaa be ru nono ma aang ꞌti änggädï. ");
INSERT INTO lro_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ndi ari ngwüjï ngwee yigor yegen yima ru yidingol, ngwänï ngwegen ngwuma rïmï ndi ꞌdingini, na ngwuma rïmï ngwäy ndi engga. Adinari aar engga ngwäy ngwe ngwegen, aar ꞌdingini ngwänï ngwe ngwegen, aar lenge yigor ye yegen na aar joꞌrenyana, a laadi nje uꞌriyi nono.’ ");
INSERT INTO lro_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Yäy gu no, nggwubupa je ndi lenge ndi ari gilang gwudi Ngwaalu gwuma aar ükäcï ngwüjü ngwuru Garany, na ngwa ꞌdingini!” ");
INSERT INTO lro_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","A Bulij jalu ngwuꞌdun ngwüngün ngwugeꞌteng gu ngwiliny ngwape ngwüdläyü rom (2) ati gu ngwüjï ïlïjä yïrnü. ");
INSERT INTO lro_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","A Bulij ꞌranu aaꞌti yiꞌral yere ümïnïcä ndi ondaci ngwüjü ngwujaꞌri ngwe ngwudi yeleny yidi Ngwaalu ngwuje enggaci ngwujaꞌri ngwani Deleny dani Yicu Kirictu.");
INSERT INTO lro_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","Ngwujaꞌri ngwee ngwïndï ꞌdünggüny äny gwani Bulij gwubupa Ngwaalu ngwuru dooꞌra dükäjäär didi Yicu Kirictu, na gidiweengga dege dani Timijawuj. Ngwükäcï nje giꞌdonga gidi Ngwaalu kündär gani Küründüj, ngwüjïngä le ꞌdar ngwudi Ngwaalu ngwanni ngwujuꞌru ngwanni ngwati ji ngwaalu ꞌdar ngwani Akayiya. ");
INSERT INTO lro_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","Ara je gu yïmïꞌrü ji ara je adatalu ji gwudi Papa gwege gwuru Ngwaalu na Deleny dege dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","Ar ortada Ngwaalinga na Papang gwudi Deleny dege dani Yicu Kirictu, Papa gwanni gwuru dïnä ngwuru Ngwaalu ngwudi orꞌtemaji ꞌdar. ");
INSERT INTO lro_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","Ngwaalu ngwanni gwati nje orꞌtemaji gïdïrbänü dege ꞌdar nunnu ꞌto ar orꞌtemaji ngwüjü ngwanni ngwa ji gïdïrbänü dere, ar je orꞌtemaji anaku orꞌtemajar nje gu Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","Ndi ari anaku ma aar nje gu yiꞌrendeny yidi Kirictu ꞌdünggüngün aw nono ndi elelle gwege, yiru gu ꞌto ndi ari nginde gwe gwani Kirictu, aar nje orꞌtemaji gwüngün aw nono. ");
INSERT INTO lro_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","Manari nyii gilo lïyü dïrbä, yiru gu gwani nga nga nunnu nga obe düwä de nga mbuji gilanging. Manari nyii gilo lübïdï düwä de, dübïdïïny de gwani orꞌtemaji gwalu gwanni gwata je gäbïcï ngaa määtä yiguri giyiꞌrendenyanu yeꞌte yeꞌte yanni yimbuji nje. ");
INSERT INTO lro_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","Na geꞌtaji gwärï gwani nga nga, nggwo gwümätïnälü ndi ari nyii lïlïngïdï ndi ari anaku acajida gu giyiꞌrendenyanu yärï, no ꞌto ngaa la acajidi ndi orꞌtemaji gwärï. ");
INSERT INTO lro_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","Nyii laꞌti bupa ndi aang ꞌti lïngïdï gwani ngweengga ndi ari yüündä yärï yanni yimbuji nje ngwaalu ngwani Ajiya. Nyii liju gïdïrbänü dacaji njalu dipana giyiima yärï ndi nyii üpïnï ꞌdi nyii gätïjï miding ngwäy. ");
INSERT INTO lro_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ꞌDidanu giyigoranu yärï nyii lïcïnänü ndi ari lübïdï nje gwälü lani yiꞌrany. A be yiꞌral giyee yimbuji nje nunnu aaꞌti nyii la gatada ngwäy giyigoꞌro yärï, nje be gatada Ngwaalu ngwanni ngwati ꞌdïꞌrïyï ngwüjälü giyiꞌranyanu. ");
INSERT INTO lro_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","Nginde gwuminje gïlängïdïyä giyiꞌrany giyee yiki gwulleny a gwunje gïlängïdïyï. Gwumiiny gu geꞌtaji ndi ari gwa ji gwunje gïlängïdïyï, ");
INSERT INTO lro_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","anaku gataji nje gu düwä otaci gwe Ngwaalingalu gwalu gwani änyängä. Ya be gäbïcï ngwüjü ngwonyadu ngwunje cïjï Ngwaalinga yäy ꞌtu gwani gataji düwä gwanni gwuma aar nje gïꞌtïjï ꞌdingini gwe otacingalu gwudi ngwüjï ngwonyadu. ");
INSERT INTO lro_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","Ïrïngïnï gwärï gwuru be nggwee gwenene ndi ari yigor yärï yïcïnïïny yänü ndi ari elelle gwudi yigoꞌro yärï gïdïdlä na ꞌdanggalu, gwuru elelle gwanni gwujuꞌru ngwuru ꞌdidanu gwanni gwïndï Ngwaalu. Nyii larru gu no yaꞌti nje arru bebere gwe gwudi dïdlä, aar be ärrïnï yïmïrü ye yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","Ndi ari laꞌta je üllïjä ngwujaꞌri ngwere ngwanni ngwaꞌti linginna nda je uli ngaa je lenge. Äny gwugeꞌtaja ndi ari, ");
INSERT INTO lro_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","anni minje lengeda nono yoko, ya ji ya je lenge ku nunnu ara je gäbïcïjï nje ïrïngïnï anaku nyängä je la ji la je ïrïngïnï komon nggäꞌdï gidi Deleny dani Yicu. ");
INSERT INTO lro_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","Yiru giyee yanni yïgäbïcïny nyi be ïcïnänü nyi geꞌtaji ndi ari nyi ila ꞌdanggalu gwerre gwerre nunnu ngaa jayanu yomon rom. ");
INSERT INTO lro_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","Nyi geꞌte ndi millida ꞌdanggalu kay ndi ele ngwaalu ngwani Majiduniya na ꞌto minyi ele minyi kwodalu Majiduniya. Nunnu nyii geꞌte kay nyi oꞌre Yäwüdïyä. ");
INSERT INTO lro_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","Anni gegeꞌtiny gu no, yigegeꞌte nje ꞌtïꞌtïre? Na äny gwati gegeꞌte nono ngwüjï ngwudi dïdlä? Ngwujaꞌri ngwüny ru ngweꞌte ngweꞌte ndi ari nyi ari, “Yäy, yäy” na, “Bärï, bäre?” ");
INSERT INTO lro_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","A be ꞌdidanu anaku ru gu Ngwaalu ligor leꞌte pu, ngwujaꞌri ngwärï ꞌdanggalu ngwaꞌti ani “Yäy” na “Bärï.” ");
INSERT INTO lro_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","Ndi ari Gïjï gidi Ngwaalu Yicu Kirictu, gwanni gwondacara je gwe äny na Jiliwanij na Timijawuj, gwaꞌti ani “Yäy” na “Bärï,” aar be ru ndi ari ꞌdünggüngün yiru gu giyomonalu ꞌdar ndi ari yani “Yäy.” ");
INSERT INTO lro_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","Yere yaꞌti ngwujaꞌri ꞌdar ngwonyadu ngwudi Ngwaalu ngwanni ngwaru ngwe, ngwani “Yäy” ndi Kirictu. Na no nginde gwe, ngwujaꞌri ngwani “Yiru gu” ngwati ar ngwe ari ar ngwe näjï Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","Gwenene Ngwaalu ngwuru ngwanni ngwadi nje gäbïcï alanga gwüpäng ar mätïnälü ꞌdïꞌdäny ndi Kirictu. Gwanni gwäbräjï nje, ");
INSERT INTO lro_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","aar nje ngïdä ar ru lüngün ngwugeꞌte Lïgïꞌrïmä lüngün giyigoranu yege lani änïjälü ngwudi yiꞌral yanni yadi ele ndi ji. ");
INSERT INTO lro_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","Ngwaalu ngwuru ngwanni ngwänggädïny ndi ari, ngaa lïnädïny ngaa je ꞌti be oꞌraca kündär gani Küründüj nunnu aaꞌti ngaa la ji gïyüündä. ");
INSERT INTO lro_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","Aaꞌti ngaa la ari nunnu nyii linyaca je yiima ye ndi ämnï Ngwaalu gwalu, aar be ru ndi ari a lapajidu yiiru gwani jayanu gwalu, ndi ari ämnï gwe Ngwaalu gwalu, ngaa lïmätïnälü. ");
INSERT INTO lro_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","Äny gwuma dinga kay ndi ari nggwa ꞌta be gwa je ïlïjä manari ila gwüny gwadi ru gwada je gäbïcï ngaa runi. ");
INSERT INTO lro_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","Ma be ari äny gwuma je gäbïcï ngaa runi, amne yärü gwuru gwanni gwadiny gäbïcï nyi jayanu nga nga läꞌtüde lanni liminje runiye? ");
INSERT INTO lro_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","No äny gwüllïjä je ngwujaꞌri ngwanni ngwullu nje, ndi ari ma ji manari äny gwuma ila, aaꞌti ngaa liny kiyi liguri ngaa lanni laadiny gäbïcï nyi jayanu. A äny gwïcïnä je gwänü ꞌdar, ndi ari jayanu gwüny gwalu gwuru ꞌto ꞌdar. ");
INSERT INTO lro_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","Ndi ari nggwüllïjä je ngwujaꞌri ngwanni ngwullu nje gwerre, runi gwe gwupa gwulleny, ligor le lümä, yal ye ngwäy, aaꞌti nunnu nga je runiyi, aar be ru ndi ari nga je enggaci ngaa lenge ämnïng gwanni gwämnä je gwe ꞌtuꞌtu giligoranu lüny. ");
INSERT INTO lro_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","Manari dïjï dere ndo dima geꞌte runing, daꞌti nyi runiya gwulleny nono runiyara je gu ꞌdar, yiru gu maani a be yaꞌti yinje gendajani. ");
INSERT INTO lro_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","Reraji gwanni gwuma gwe reraji lonyadana, gwumbutu nono. ");
INSERT INTO lro_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","Gwenene yiru gu ndi ari gwadi aang manni düdänïjänü aang orꞌtemaji, ndi ari aaꞌti gwa runi anaji ligoralu. ");
INSERT INTO lro_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","Yäy gu no, nggwa je päcälü ndi ari ämnär mana. ");
INSERT INTO lro_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","Yanni yïgäbïcïny ngaa je be üllïjä ngwujaꞌri, yiru ndi ari nyi engga ngaa gilo lïmätïnälü ꞌdïꞌdäny ndi ïdäjï ngaa ꞌdengenaji yiꞌral ꞌdar. ");
INSERT INTO lro_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","Manari ngaa lima düdänïjï dïjänü dere, diny düdänïjï ꞌto. Na manari gwanni gwuminy düdänïjänü giyiꞌral yere, manari yiju yere ndinje düdänïjänü, gwuminy düdänïjänü ngwäyänü ngwudi Kirictu gwani nga nga. ");
INSERT INTO lro_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","Nunnu aaꞌti dijegoꞌrr dinje gu mbojaji. Ndi ari a laꞌti ïꞌdädänü gay ge gidi dijegoꞌrr. ");
INSERT INTO lro_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","Gwenene anni miny obani kündär gani Trawuj ndi ondaci ngwüjü ngwujaꞌri ngwanni ngwujaw ngwani Kirictu, nyi mbuji ndi ari Ngwaalu ngwuminy ïgïtïjï gay ndi ape yiiru. ");
INSERT INTO lro_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","Nyi ꞌtina ädïyä liguralu ndi ari äny gwaꞌti mbuju diwengga dani Tïtüj, nyi ele nyi aganni ngwïkïrïjïnä nyi be ꞌdïꞌrï nyi ele Majiduniya. ");
INSERT INTO lro_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","Nyi be ci Ngwaalinga yäy ꞌtu, ngwanni ngwati nje üktïnï yomon ꞌdar ndi dami gwudi Kirictu. A bebere gwe gwege gwani nginde aar gwe ape ngwaalinganu ꞌtuur nono düwä dami nunnu ngwulinginni ngwüjänü ꞌdar. ");
INSERT INTO lro_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","Ndi ari Ngwaalu, a liru giꞌreꞌreny gami düwä didi Kirictu ngwüjänü ngwanni ngwadi gïlängïdïnï na ngwanni ngwadi ayi. ");
INSERT INTO lro_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","Ngwüjï ngwoko ngwanni ngwadi ayi, a liru düwä diki didi yiꞌrany na ngwüjï ngwoko ngwanni gïlängïdïnï, ar ru düwä dami didi midi. Na yärü gwuru gwanni gwubidaranu yiiru ye yiru gu no? ");
INSERT INTO lro_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","A läꞌtüdï nono ngindeng je lonyadu ndi ari a lapu yiiru ngwujaꞌri ngwe ngwudi Ngwaalu ar gu bila. Aar be ru manni ndi ari ndi Kirictu, a londaja ngwäyänü Ngwaalu yigor ye ꞌdidanu ar ru nono ngwüjï ngwükäjä je Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","A la oꞌre mana ndi aalu ndi orta yigoꞌro yege? Na a gilo länggädï ndi ari a lïmïnä ngwujaꞌri ngwudi ola nono ngwüjï ngwoko ngwuꞌter aar ila ꞌdanggalu nje inggidi ngwüjï ngwuꞌtere? ");
INSERT INTO lro_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","Nga nga yigoꞌro yalu, ngaa liru ngwujaꞌri ngwärï ngwanni ngwüllïnä giyigoranu yärï aar linginni a je ngwüjï ꞌdar uli. ");
INSERT INTO lro_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","Nga nga linggida ndi ari nga nga liru ngwujaꞌri ngwanni ngwïndï ndi Kirictu, ngwani yiiru yärï ꞌdanggalanu. Ngwujaꞌri ngwee ngwaꞌti üllïnä yebo ye aar be üllïnï Lïgïꞌrïm le lidi Ngwaalu ngwanni ngwumidu. Ngwaꞌti üllïnä kimindi giru güꞌrï aar be üllïnï kimindi giru ligor lidi dïjï dümnä. ");
INSERT INTO lro_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","Ïcïnänü gwanni gwuru gu no, gwege gwuru gwïndï ndi Kirictu ngwäyänü Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","Yaꞌti ani nunnu alanga yigoꞌro ye yege a lätï yiima ndi ari yiꞌral yere, aar be ani ndi ari yiima yege ꞌdar yïndï Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","Nginde gwätädï nje yiima liru ngwïnäd ngwapu yiiru yidi gekajidi gwanni gwuyang, gwäꞌtüdï gwudi ngwujaꞌri ngwüllïnä, ngwube ru gwudi Lïgïꞌrïm. Ndi ari ngwujaꞌri ngwanni ngwüllïnä ngwati ꞌrinyidi a be ngwujaꞌri ngwani Lïgïꞌrïm gwati midiyi. ");
INSERT INTO lro_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","A be gwenene manari yiiru yanni yati ꞌrinyidi yanni yüllïnä kimindi, yätï näjïng gwuru gu no, ꞌdi a ngwüjï ngwudi Yïjïräyïl amiꞌrati ndi ombaji Müjäng ngwäyänü aar ꞌti burnu ndi ombaji gwani näjï gwudi buri gwanni gwuju ngwäyänü ngwube aji ngwüꞌrätï, ");
INSERT INTO lro_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","yiiru ya be ruꞌtani awa yidi Lïgïꞌrïm lanni lätï näjïng gwupana? ");
INSERT INTO lro_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","Manari yiiru yanni yati obalu dïjï de yïnäjïnä gu no, a be yiiru yanni yati dünïyï dïjälü ya be ruꞌtani awa! ");
INSERT INTO lro_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","Ndi ari yele yätï näjïng gwerre, yaꞌti ba be ätï näjïng gwenene ma aar je ïdïyï näjï gwe gwanni gwupana. ");
INSERT INTO lro_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","Na manari yiiru yanni yati üꞌrätï yïndï näjï gwe no, gwa be ruꞌtani awa gwanni gwati ꞌti medadu! ");
INSERT INTO lro_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","Yäy gu no, anni ätär geꞌtajing nggwee gwuru gu no, a la be ꞌranu. ");
INSERT INTO lro_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","Alanga laꞌti la ru nono Müjäng gwanni gwügwüꞌrübänä direda ngwäy nunnu aaꞌti ngwüjï ngwudi Yïjïräyïl ngwombaji näjïng anni ma buri ji ndi ele gwadi üꞌrätï ngwabralu ngwäyänü ngwüngün. ");
INSERT INTO lro_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","A be ngindenga lïrïmïdü yaꞌranya ndi ari ꞌdi komon gidi gweneneng, lima je dired ndee deꞌte deꞌte danni düllälü ngwäyänü ngwudi Müjä ndo düllälü ngwuje rïmïyï ngwäy ma ji ma aar uli ngwujaꞌri ngwudi gekajidi gwudi gwerreng. Dima ꞌti äbrïnä kay ndi ari dadi äbrïnï kay ꞌdogo ndi Kirictu. ");
INSERT INTO lro_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ꞌDi komon gidi gweneng, dired ndee ndona dimilliding je ngwäy ngwudi yigor yegen manari lima uli gitab gidi Ngwaalu ganni gullu Müjä. ");
INSERT INTO lro_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","A be manari dïjï dere dima gwürlï ligor lüngün ngwoꞌraci Delenya, dired ndee da äbrïnï ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","Gwenene, Deleny diru dani Lïgïꞌrïm, a ngwaalu ngwanni ngwati gu Lïgïꞌrïm lidi Deleny ji, gätïnï linginalu gwati ji. ");
INSERT INTO lro_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","Na alanga lanni laꞌti gwüꞌrübänä direda ngwäy a lombaja näjïng nggwo nono kalmandranu. Nunnu aar nje näjï gwürlädä ꞌdünggüngün ar linganni ngindeng näjï gwe gwanni nggwo gwugendadu gwïndï Gideleny danni diru Lïgïꞌrïm. ");
INSERT INTO lro_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","Yäy gu no, anni ape nyii yiiru giyee ïnä gwe gwudi Ngwaalu, nyii laꞌti la muli nono. ");
INSERT INTO lro_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","Nyii lima be manni gäbïcï elelleng yuꞌrimi gwanni gwuru yaaru nyii ꞌti ïꞌdäjä ngwüjänü nyii ꞌti gwürlü ngwujaꞌri ngwudi Ngwaalu. Nje be geꞌtalu gilingenalu yanni yiru ꞌdidanu nyii olada yigoꞌro yärï giyigoranu yidi ngwüjï ꞌdar ngwänyänü Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","Na manari ngwujaꞌri ngwärï ngwanni ngwujaw ngwülïbïnä ngwüjï ngwülïbïnä ngwüjï ngwanni ngwayu. ");
INSERT INTO lro_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","Lanni laꞌti ätï ämnïng Ngwaalu, lima je ngwaalu ngwudi dïdlä ndee rïmïyï yaꞌranya nunnu aaꞌti la engga buri gwudi Ngwujaꞌri ngwanni ngwujaw ngwudi näjï gwudi Kirictu, gwanni gwuru giꞌremna gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","Ndi ari nyii laꞌti ondaja gwani yigoꞌro yärï, aar be ani Yicu Kirictu gwuru Deleny na gwani yigoꞌro yärï liru ngwïnäd ngwalu läpïjä je yiiru gwani Yicu. ");
INSERT INTO lro_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","Ndi ari Ngwaalu ngwanni ngwaru, “A buri oꞌrralu gïdïrïmänü,” ngwuru gwanni ngwadi gäbïcï buri ngwoꞌrralu giyigoranu yege aar nje oꞌrracalu ndi bebere gwudi näjï gwudi Ngwaalu ngwäyänü ngwudi Kirictu. ");
INSERT INTO lro_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","A be änyängä liru ꞌdogo yimo yiru gilu yapaar gu yuꞌrina giyee ndi inggidi ndi ari yiima giyee yipa yïndï Ngwaalu yaꞌti ïndï ꞌdänggärï. ");
INSERT INTO lro_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","Dïrbä dimbuji nje ngwaalu ꞌdar aar nje be ꞌti ïꞌdïyü nyi anadalu, aar nje gwe ngwaalu elalu gïdïrbänü därï nyi ꞌti be mulu nono nyii gwalli ngwäy. ");
INSERT INTO lro_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","A nje ngwüjï übïnälü, a nje ꞌti be Ngwaalu dodanu. Aar nje pï nyii ꞌti be geradalu. ");
INSERT INTO lro_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","Yomon reny lüpïnä yiꞌrany yidi Yicu ngwanginu ngwärï, nunnu a midi gwüngün ꞌtädïnälü ꞌto ngwanginu ngwärï. ");
INSERT INTO lro_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","Ndi ari nyängä limidu, aar nje be yiꞌrany gwagilli ngwäy yomon ꞌdar gwani Yicu nunnu a midi gwudi Yicu ꞌtädälü ngwanginu ngwärï ngwanni ngwati ayi. ");
INSERT INTO lro_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","Yäy gu no, yiꞌrany yapu yiiru ꞌdänggäränü, a be midi ape yiiru ꞌdanggalanu. ");
INSERT INTO lro_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","Yüllïnä ndi ari, “Äny gwämnä Ngwaalu, yäy gu no nyi gwuma be ondaji.” Gïlïgïꞌrïm gilee leꞌte leꞌte lidi ämnï Ngwaalu, a lima ämnï ꞌto na yäy gu no ar be ondaji, ");
INSERT INTO lro_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","ndi ari a lïlïngïdï ndi ari dïjï danni dïꞌdïꞌrïyä Yicungalu giyiꞌranyanu nginde gwunje ꞌdïꞌrïyälü ꞌto aar nje dünäjalü ngwäyänü ngwüngün nga nga le. ");
INSERT INTO lro_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","Giyee ꞌdar yani mbuji gwalu gwanni gwujaw, nunnu a yïmïꞌrü yanni giyo ndi olati ngwüjï ꞌdar mana na mana, aar gäbïcï yäyïng ꞌtu ngwïrälü gwudi näjï Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","Yäy gu no, aaꞌti a la miꞌri yigor! Anni adi ngwanginu ngwege poor ꞌdigiꞌri, a be ngïnäꞌdänü ꞌdengge, a la gwürlïnänü yomon ꞌdar liyang. ");
INSERT INTO lro_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Ndi ari dïrbä dege ndee dängränü gwenene dooko na daꞌti olanu, diru dadi nje gäbïcï ar mbuji guꞌru ganni gipa gani näjï gwudi gwurꞌtaling ");
INSERT INTO lro_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","ar äbrï ngwäy ndi ombaji ngwony ngwanni ngwo ngwenggana ar ombaji ngwony ngwanni ngwo ngwaꞌti enggana ndi ari ngwong ngwanni ngwo ngwenggana ngwadi medadi a be ngwong ngwanni ngwo ngwaꞌti enggana, ngwudi gwurꞌtaling ngwuru. ");
INSERT INTO lro_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","A lïlïngïdï ndi ari manari lingeno lege lidi dïyängälü mung medadi lanni lijar gwanu gwenene, a lätï ngwuꞌduna Ngwaalu, ngwuꞌdun ngwudi gwurꞌtaling kerala, ngwanni ngwaꞌti odana ngwuy ngwe ngwudi dïjï dümnä. ");
INSERT INTO lro_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","A be gwenene, a gilo lärnü ar jada gwulleny ndi aar nje giki lingina lanni liyang liru ngwuꞌdun ngwege ngwudi gerala. ");
INSERT INTO lro_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","Ndi ari manari lima ar genne, a laꞌti la mbüjïnï lijalu ngwanginu ngwanu. ");
INSERT INTO lro_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","No, alanga lanni gilona gilingeno gilee, a lärnä ar üpïnï gwünï ndi ari a laꞌti mïnä ndi aar nje gwallalu mbüny ar be mïnï ndi ar nje gika ngwuꞌdunala ngwudi gerala nunnu a midi gwüꞌrübäjï ngwanginalu ngwanni ngwati ayi ꞌdenggenanu. ");
INSERT INTO lro_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","Ngwaalu ngwuru ngwanni ngwugeꞌte nje gwani yiꞌral giyee aar nje be ätädä Lïgïꞌrïmä lani änïjälü ꞌto nunnu aar nje gïꞌtïjï yiꞌralalu yanni yarung ye. ");
INSERT INTO lro_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","Yäy gu no, ar gu ïcïnädä ar gu lenge giyomon ꞌdar ndi ari anni jarna gilingeno, alanga gilona ngwaalu ngwolanu Gideleny. ");
INSERT INTO lro_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","Ndi ari alanga lïndï ämnï gwe Ngwaalu, alanga laꞌti ïndï ngwong ngwängädär je ngwäy ngwe ngwudi ngwanginu. ");
INSERT INTO lro_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","Alanga lïcïnädï gwänü, nyi gwaru no, nyi jada ndi erne ndi ji gilingeno ndi nyii ji ꞌdunu Deleny de. ");
INSERT INTO lro_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","No ar je be geꞌte aar ru bupi ndi jayiyi ngindenganu manari alanga gilo gilingeno na manari alanga gilo ngwaalu ngwolanu gilingeno. ");
INSERT INTO lro_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","Ndi ari alanga ꞌdar, a la dünäcï diduꞌralu didi pï yelenya didi Kirictu, yiꞌral ya ꞌtädälü ꞌdar. Ndi ari alanga ꞌdar ati dïjï ape guꞌru gani yiiru yüngün yanni yijung ji ndi ape gwele gilingeno. Manari yapung je yanni yijaw na manari yapung je yanni yiki. ");
INSERT INTO lro_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","A lïlïngïdï ndi ari yiru ange yani denya Kirictung yiru yanni yati nje gäbïcï ar gwäꞌrä ngwüjü ngwujaꞌri ngwe gwani nginde. Ngwaalu ngwülïngïdï yigor yärï gilingenalu na äny gwüjädï gu ꞌto ndi ari yigor yärï yinginni gilingenalu ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","Änyängä laꞌti ba be ndi orta yigoꞌro yärï ꞌdanggalu, ara je be gïꞌtïjï gay nunnu nje le ïrïngïnï ara je gäbïcï aang ätï ngwujaꞌri ngwadi ngwe ondaci ngwüjü ngwanni ngwati ïrïngïnï gilingeno aar be erne giligoranu. ");
INSERT INTO lro_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","Manari änyängä gilo lïrlälü giyiꞌranu, lïrlälädï kay gidi Ngwaalu. Na manari änyängä luꞌru giyiꞌranu, yijuꞌru nje gwani nga nga! ");
INSERT INTO lro_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","Ämnï gwudi Kirictu gwuru gwümätï nje nyii lenge ndi ari gweꞌte pu gwayu gwani ngwüjü ꞌdar yäy gu no, ngwüjü ꞌdar ngwayu. ");
INSERT INTO lro_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","Na yanni yïgäbïcä ngwayi gwani ngwüjï ꞌdar, yiru ndi ari a ngwüjü ꞌdar ngwanni ngwo, aar midi, aa ꞌti ngwa midi gwani yigoꞌro yegen mana, aar be midi gwani nginde gwanni gwayu ngwüꞌdïꞌrä gwumidu gwani ngindenga. ");
INSERT INTO lro_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","Yäy gu no, ꞌtuꞌtu gwenene, engga gwärï gwanni nggwo gwänggädïïny gwe ngwüjü, ngwaꞌti nje änggädï ngwäy ngwe ngwudi dïjï dümnä. Na manari nyii länggädï gu Kirictung no gwele gwerre, a be gwenene, gwaꞌti nyii ba be änggädï ngwäy ngwe ngwudi dïjï dümnä. ");
INSERT INTO lro_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","Yiru ndi ari manari dïjï dere ndo ndi Kirictu, dima ru dïjï diyang. Yele yiru yuꞌrin, yima ele, yima ila yanni yiyang. ");
INSERT INTO lro_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","Giyee ꞌdar, Ngwaalu ngwuru ngwärrä je ngwanni ngwoꞌrajidiyi nje ngindenga le Kirictu gwe, aar nje ätädänï yiiru yidi oꞌrajidiyi ngwüjü Ngwaalinga le. ");
INSERT INTO lro_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","Äny gwadi ari Ngwaalu ngwoꞌrajidaar ngwüjïngä le Kirictu gwe ngwuje ꞌti gïꞌtïjï keng gwegen aar nje be aw ngwujaꞌri ngwe nunnu ar gwe oꞌrajidiyi ngwüjü Ngwaalinga le. ");
INSERT INTO lro_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","Yäy gu no, nyii liru ngwartan ngwudi Kirictu ngwükäjäär je, nono ma Ngwaalu giligoꞌro lüngün ngwata je päcälü änyängä le. Gwani Kirictu, lïpäcä jälü ndi ari, oꞌrajidar Ngwaalinga le. ");
INSERT INTO lro_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","Ndi ari Kirictu gwanni gwaꞌti ki, gwugeꞌta Ngwaalu ar le acajidi ndi ke gwege nunnu ꞌdünggüngün ar le dünälü ar ru lidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","Anaku apajidar gu yiiru gwüpäng yidi Ngwaalu, Nggwa je päcälü ndi ari aaꞌti ngaa la ape yïmïꞌrä giyee yidi Ngwaalu ꞌtur. ");
INSERT INTO lro_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","Ndi ari nginde gwaru, “Kaji gidi jayi ngwäy gwüny, nggwuꞌdinginanga na komon gidi gïlängïdïnï nggwugatajanga düwä.” Nggwa je ci gweneno gaji giru gidi jayi ngwäy gwudi Ngwaalu, gweneno, gomon giru gidi gïlängïdïnï. ");
INSERT INTO lro_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","Elelle gwärï gwäꞌtüdï gimle kay nda gu dïjï dere obalu nunnu aaꞌti yiiru yärï yätï yiꞌral nono yere. ");
INSERT INTO lro_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","Nyii be manni ru ngwïnäd ngwudi Ngwaalu nyii ola yigoꞌro ngwaalu ꞌdar, ndi orꞌtemaji gwupa, gïdïrbänü, gïyüündänü, gïyïjülänü, ");
INSERT INTO lro_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","ndi pïnï, giyirna ngwüjänü ngwüꞌdïꞌrü gündä ndi ape yiiru yïnï yar ye dilu de, na ngwamu ngwe, ");
INSERT INTO lro_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","ndi juꞌri na ndi lenge ndi orꞌtemaji na ndi jayi liguri. Gïlïgïꞌrïm lanni Lijuꞌru na ndi ämnï gwanni gwuru ꞌdidanu, ");
INSERT INTO lro_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","ngwujaꞌri ngwanni ngwätï ngwäyänü na giyiima yidi Ngwaalu. Ngwäbländï ngwe ngwudi dünälü kuy gidi gaama na kuy gidi gängïr, ");
INSERT INTO lro_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","näjï gwe na yïrïgïnä ye, ondaji gwe gwanni gwujaw na gwanni gwuki larru ꞌdidanu, aar nje be engga lidudiyu ngwüjü. ");
INSERT INTO lro_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","Lilinginna, aar nje be engga laꞌti linginna. Nyii ru nono minyii ayi, nyii be ele limidu, lïpïnä, aar nje ꞌti be ꞌrïnyïtï. ");
INSERT INTO lro_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","Lirunu gwulleny nyii be jayanu. Liru ngwayi nje be gäbïcï lonyadu aar nänü. Nyii ꞌti ätï gonyalu gere, nyii be ätï ngwonyalu ꞌdar. ");
INSERT INTO lro_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","Lïgätïjä je yigoralu ara je ondaci nga liru ngwüjï ngwudi Küründüjïng ara je ïgïtïjï ngwulem ngwärï ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","Laꞌti gwäꞌrïnä ämnïng gwärï ꞌdanggalu nga be ru lïgwäꞌrä ämnïng gwalu ꞌdänggärï, ");
INSERT INTO lro_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","A be ndi ari ara je gu gwäꞌräcänü, a nggwa je ondaci nono yïjü, gäbïcï nje yigor yalu ꞌto aar ongranu. ");
INSERT INTO lro_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","Aaꞌti nga la gikajidi giyunggu ngwüjïngä le ngwäꞌtüdï ngwïkïrïjïn. Ndi ari dünälü na ke lati amatano? Buri na dïrïm lati gekajide? ");
INSERT INTO lro_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","Yiru ange yidi Kirictu yätär je dijegor de? Yaꞌti aꞌtur. Yäy gu no, dïkïrïjïn daꞌti da aar acajidi dïjï däꞌtüdï dïkïrïjïn, ");
INSERT INTO lro_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","Na gobo giru ngwuꞌdun ngwudi Ngwaalu gaꞌti aar ätï yiꞌremna ye yidi dïdülä. Ndi ari a liru ngwuꞌdun ngwudi Ngwaalu ngwanni ngwumidu. Anaku ma gu Ngwaalu ari, “Äny gwa ji ꞌdenggenanu nyii elelle gidiliganu degen nyi ru Ngwaalu ngwegen aar ru ngwüjï ngwüny.” A Deleny ari, ");
INSERT INTO lro_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","“Yäy gu no, ꞌtüdär gwänü ngaa ngedana, Ngaa ꞌti akana ngwony nono ngwanni ngwürngü, äny gwa je be ape.” A Deleny diru yiima ari, ");
INSERT INTO lro_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","“Nyi gwa ru Papa ꞌdanggalu, na ngaa la ru yïjï yüny yanni yiru ngwur na yera.” ");
INSERT INTO lro_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","Anni ätär gu ngwujaꞌri ngwee ngwaru ngwe Ngwaalu lani ngwumaad ngwüny, ar be juꞌriyi yigoꞌro yege ar ꞌtänü giyiꞌralanu ꞌdar yanni yati rngïyï ngwangina na lïgïꞌrïmä, ar mbütïyï juꞌring gwani denya Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","Gïꞌtïjï nje ngwaalinga giyigoranu yalu. Nyii laꞌti ärrïjä dïjü dere yiꞌral yanni yiki, nyii laꞌti ꞌdïgüꞌrïdï dïjü dere, nyii laꞌti mbojaja gïdïjï dere. ");
INSERT INTO lro_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","Äny gwaꞌti ondaja ngwujaꞌri ngwee nunnu a je gwe obalu, nggwondaca je gu gwerre ndi ari nyii ligeꞌta je giyigoranu yärï ndi ari ma aar ani midi ar midi ma aar ani ayi ar ayi. ");
INSERT INTO lro_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","Äny gwïcïnä je gwänü gwulleny ngaa je le ïrïngïnï. Äny gwuma ojeme nono gwulleny, gïdïrbä därï ꞌdar, jayanu gwüny ꞌdar gwaꞌti ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","Ndi ari anni minyii ila nyii obana Majiduniya, nyii laꞌti übïdï düwä de aꞌtur gilingeno lärï gilee, aar nje be yiꞌral mbuji yonyadu, na oktajidanu ji ngwaalu ꞌdar poor ngwügäbïcï yedenyo aar nje gu änänü. ");
INSERT INTO lro_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","A be Ngwaalu ngwanni ngwati nje ätädä yiima yidi orꞌtemaji ngwüjü ngwanni ngwuralu ꞌtur, ngwuminje orꞌtemaji ükäcä gwe Tïtüjïng. ");
INSERT INTO lro_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","Na yaꞌti yani ila gwüngün ꞌdogo, aar be ani ꞌto orꞌtemaji gwanni gwumbujiiny ꞌdanggalu. Nginde gwondaci nje ngwujaꞌri ngwani ndi ari ngaa lïjädï ndi nyi engga, runi gwalu gwulleny ara je yigor enyanu gwani äny, ꞌdi aar nyi gäbïcï nyi jayiyanu gwulleny. ");
INSERT INTO lro_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","Manari ngwujaꞌri ngwuma je ümïyï yigor ngwanni ngwükäjï nje, nggwaꞌti gu gwäꞌrïnä ngwäyänü minyi ni gwäꞌrïnï ngwäy gwooko ngwänggädï ndi ari ngwujaꞌri ngwuma je gwüꞌrä kaji gooko. ");
INSERT INTO lro_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","A be gwenene jayanu gwüny gwaꞌti ani nunnu ngaa likanu, aar be ru ndi ari runi gwalu gwuma je gäbïcï ngaa lima joꞌrenyana. Ndi ari ngaa lima runi anaku bupa gu Ngwaalu ndi ari yima je ꞌti mbuja yere yanni yiki gwani änyängä. ");
INSERT INTO lro_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","Ndi ari runi gwanni gwïndï Ngwaalu, gwati apa joꞌrenyaning ngwügäbïcï ngwüjï aar gïlängïdïnï. Gwaꞌti ätï gwäꞌrïnïng ngwäyänü. A be runi gwudi dïdlä, gwati apa yiꞌrany. ");
INSERT INTO lro_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","Ombajar be runing gwanni gwïndï Ngwaalu gwuma ärrï ange ꞌdanggalanu. Gwuma je gäbïcï ngaa lima undi ngwäy gwuma je iye yigoranu. Ngaa lima gwalli ngwuy giyiꞌral yanni yiju yiki. Ara je güündä ape ngaa kanu, yima je be ꞌtäjälü ndi ari ngaa lämnïny ngaa ru lüny. No yiru yima je gäbïcï ngaa lima obalu dïjï de danni dapu gwuki. Yiꞌral ye giyee ꞌdar ngaa lima gwällïnï yigoꞌro yalu ndi ari ngaa lijaw nono giyiꞌral giyee. ");
INSERT INTO lro_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","No ꞌdi ngwujaꞌri ngwanni ngwükäcä je yaꞌti ani dïjï ndoo danni därräär yiꞌral yanni yiki, aar be ru ndi ari äny gwubupa nda je enggaci ngwäyänü Ngwaalu aang engga yigoꞌro ye yalu ndi ari ngaa ligeꞌte nje gu ngwäyänü ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","Yiru giyee ꞌdar yanni yiminje gäbïcï nyii orꞌtemaji orꞌtemaji gwe gwalu. A be yoko mana ndi orꞌtemaji gwärï, gwece gwece lijayananu ndi engga awa Tïtüj gwujayanu. Ndi ari nga nga ꞌdar lima gataji Tïtüng lïgïꞌrïmä lüngün düwä. ");
INSERT INTO lro_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","Nggwïrïngïnä je gwe ndi Tïtüj na nga nga laꞌtiny apiyu yaaru gwani ngwujaꞌri ngwee. Na ꞌto yiꞌral ꞌdar yanni yicar je ye yiru ꞌdidanu na gwenene yima enggani ndi ari ïrïngïnï gwärï ꞌdanggalu ndi Tïtü gwuru ꞌto ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","Na ämnï gwüngün ꞌdanggalu gwojemana mung diwayini ndi ari awa nga nga ꞌdar, gwuꞌdengenacanga ngaa gwäꞌrï yïrnü yigor ye yijaw nga denya. ");
INSERT INTO lro_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","Äny gwujayanu ndi ari nggwïcïnä je gwänü nda je gu gatada ngwäyänü giyiꞌral ꞌdar. ");
INSERT INTO lro_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","Gwenene lani ngweengga, nyii linana je ndi ar je enggaci ngaa lenge yïmïꞌrä yanni yätädï je Ngwaalu yiꞌdonga yidi Majiduniyang. ");
INSERT INTO lro_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","Ngindenga lïmïmïnnäär je nono aar ji gïdïrbänü dipa, aar be jayanu gwulleny giyiwayi yegen yiki aar gäbïcï aar geꞌte yigor ye ꞌdidanu aar ꞌti rüdï ngwuꞌrid ndi ätä. ");
INSERT INTO lro_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","Äny gwuru gwänggädï nje ndi ari yïmäjïdäär je yanni yätäär je aar pani giyima yegen. Yigeꞌtaar je ꞌdar yigoꞌro ye yegen gwuꞌren, ");
INSERT INTO lro_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","aar nje päcälü gwulleny ndi ari yipa guꞌru ꞌdenggen ndi emadi giyiiranu giyee ndi gataji ngwüjü düwä ngwanni ngwujuꞌru ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","Yaꞌti aar je gu ärrü anaku geꞌtaji nyii gu ndi aar je ärrï aar be ätädï Delenya yigoꞌro yegen gwerre gwerre, aar nje be ätädä anaku bupa gu Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","No nyii be päcï Tïtüjïngalü, ndi ari ngwumedaji yiiru giyee yidi yïmïꞌrü ꞌto ꞌdanggalu yanni yiming ye ꞌdïꞌrï gwele gwerre. ");
INSERT INTO lro_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","A be anaku gendadu gu giyiꞌral ꞌdar ngwaalu ngwani ämnï Ngwaalu na ngwaalu ngwani ondaji, na ngwaalu ngwani bebere, na ngwaalu ngwani undi ngwäy giyiꞌral ꞌdar, na ngwaalu ngwani ämnï gwalu ꞌdänggärï, ombajar be ndi ari ngaa gilo ꞌto ligendanu giyiiru giyee yiru yïmïꞌrü yani ndi ätä. ");
INSERT INTO lro_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","Äny gwaꞌta je linyaca ngwujaꞌri ngwee yiima ye, nyi be bupi ndi ïdäjï ꞌdidanung gwudi ämnï gwalu ngwüjü ngwuꞌter ngwanni ngwïtï je yigoranu. ");
INSERT INTO lro_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","Ndi ari ngaa lïlïngïdï yïmïꞌrä yidi Deleny dege dani Yicu Kirictu, ndi ari nginde gwünänü, a be gwani nga nga, ngwube ru diwayi, nunnu aar je nïyänü. ");
INSERT INTO lro_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","Na ngene äny gwa je ola ngwujaꞌri ngwe ngwüny ndi ari yiru ange yanni yijayana ꞌdanggalu giyiꞌral giyee, nga nga lanni liru yiꞌra gwerre gwerre ätädä gwe ꞌtuꞌtu dïdläyü duubu, yaꞌti ani ndi aang ätädä ꞌdogo, aar be ani ꞌto ndi ari ngaa gu jada no. ");
INSERT INTO lro_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","Gwenene medajar yiiru giyee, nunnu a jada gwanni gwümïnängä ngwuru gwanni gwadi aar elati yiiru ye yalu a je medaji. ");
INSERT INTO lro_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","Manari bupi gwuma ji ngenone, angidaji gwa aar ämnï anaku ätï gu dïjï, yaꞌti ya ru nono anaku aaꞌting gu ätï. ");
INSERT INTO lro_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","Giyee yaꞌti ani ndi ari ngaa onjani loko a be loko amꞌratani aar be ani ndi ari ngaa ubidanu. ");
INSERT INTO lro_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","A be gwenene onje gwalu gwa gendaci ngindeng je lanni laꞌti ätï gwegen, nunnu aji a onje gwegen gendaci ngwüjü ngwanni ngwaꞌti ätï, nunnu a ubidanu ji. ");
INSERT INTO lro_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","Anaku üllïnäär gu ndi ari, “Gwanni gwati gwüꞌräjï giꞌdu gwonyadu gwulleny gwati ꞌti ätï gwonyadu gwulleny na gwanni gwati gwüꞌräjï giꞌdu gwooko gwulleny gwati ꞌti ätï gwooko gwulleny.” ");
INSERT INTO lro_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","A be nggwuca Ngwaalinga yäy ꞌtu ngwanni ngwätädï Tïtüjïng ligor gilee liru nono ligor lüny gwani nga nga. ");
INSERT INTO lro_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","Ndi ari nginde gwaꞌti nje ꞌdengenaca päcïngälü gwärï ꞌdogo, nggwo be gwadi je elaca ligor le lüngün gwïtï ligoranu gwulleny. ");
INSERT INTO lro_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","Nggwo gwükäjïïny diweengga de danni dati yiꞌdoonga ꞌdar ortada, gwani yiiru yüngün yidi ondaji ngwujaꞌri ngwanni ngwujaw. ");
INSERT INTO lro_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","Yanni yigendana ndi ari nginde gwäbrä giꞌdoonga gidi Ngwaalu ndi ari nyii le ru gimaad nyii le ape ngwony ngwanni ngwätädäär nje ndi inggidi enyanu gwudi yigor yalu ndi gataji ngwüjü düwä nunnu a Ngwaalu näjïnï. ");
INSERT INTO lro_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","Nyii larngana ndi ari aaꞌti dïjï dere dinje gatada ngwujaꞌri nono gwani äpïnï gwudi angidaji nggwee gwudi gätïnï yigoralu. ");
INSERT INTO lro_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","Ndi ari nyii lapu yiꞌrendenya ndi ärrï yiꞌral yanni yïndï kayalu, yaꞌti ani nunnu ngwäyänü ngwudi Deleny ꞌdogo, aar be ani ꞌto ngwäyänü ngwüjï. ");
INSERT INTO lro_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","Äny gwa je ci ꞌto nunnu gwuminyii ükäjä aar ila diweengga de danni gwällïnä ꞌdengge yiiru yonyadanu ndi ari nginde gwati ligor enyanu, na gwenene gwitana ligoranu gwulleny gwani ïcïnänü gwüngün ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","Na gwani Tïtüj, gwuru gimaad güny giyiiru yanni yati nje ape yani nga nga. Na gwani ngweengga ngwege ngwuru ngwanni yiꞌra yidi yiꞌdonga yidi Ngwaalu na denya gwudi Kirictu. ");
INSERT INTO lro_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","Yäy gu no, inggidar be ämnïng gwalu gwani ngindenga ꞌreꞌdr nunnu a ngwïkïrïjïn engga ndi ari ngwujaꞌri ngwanni ngwuca je ngwe, ngwätï ngwäyänü na ïrïngïnï gwärï gwuru ange ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","Yaꞌti yere yanni yada je üllïjä gwani äpïjï ngwüjü ngwudi Ngwaalu ngwanni ngwujuꞌru yiiru. ");
INSERT INTO lro_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","Ndi ari äny gwülïngïdï ngaa lïbüdü yigoranu ndi geꞌtajidi ngwuy, äny gwïrïngïnä yiꞌral ye giyee ngwüjänü ngwudi Majiduniyang, nje ci ndi ari ꞌtuꞌtu dïdläyü duubu nga nga ngwaalu ngwani Akayiya liju mama ndi geꞌtajidi ngwuy ndi ari enyanu gwudi yigor yalu gwuma ꞌritiya ngwüjü ngwonyadu gwani yiiru yidi ätä. ");
INSERT INTO lro_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","A be äny nggwo gwükäcä je ngweengga nunnu aaꞌti ïrïngïnï gwärï ꞌdanggalu giyiꞌral giyee gwa ru ꞌtur ngaa be ji mama, anaku ci nje gu ngaa ladi gu ru. ");
INSERT INTO lro_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","Ndi ari manari gwere gwudi Majiduniyang gwuminyii le ila ar je mbuji laꞌti ju mama, yaaru nje be ape. A be yaaru ya je apani, gwani ïcïnä gwanni gwïcïnädïïny gu ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","No nyi be ari yiru guꞌru ndi päcï ngwenggalu aar madina aar ila ꞌdanggalu, ndi ari aar gegeꞌta yiꞌral mama aar mbuji ꞌto angidacing yigor ye yalu ꞌdidanu gwanni gwara gwe. Na ndi ari angidaci nggwee ji mama ligor le ꞌdidanu aaꞌti gwa ru ligor le lïnï! ");
INSERT INTO lro_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","Diwayinar ngwujaꞌri ngwee, ndi ari nginde gwanni gwati kwoy gwooko gwati mbuji ꞌto gwooko na gwanni gwati kwoy gwonyadu gwati mbuji ꞌto gwonyadu. ");
INSERT INTO lro_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","Ati dïjï geꞌte anaku ca gu ligor lüngün, aaꞌti da geꞌte ligor le lïmänü yaa yiima ye, ndi ari Ngwaalu ngwati ämnï dïjü danni dati geꞌte ligor le lijayanu. ");
INSERT INTO lro_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","Na Ngwaalu ngwätï yiima ndi aar je onjaci yïmïꞌrä yüngün ꞌdar aar ji ꞌdanggalu, nunnu ngaa mätïnälü giyiiru yanni yijaw giyiꞌral ꞌdar na kaji ꞌdar ngaa je mbuji ꞌdar yanni yïmïnä je. ");
INSERT INTO lro_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","Anaku üllïnäär gu ndi ari, “Nginde gwuma geꞌte angidajing gwüngün gwuma badalu ngwüjï ngwonyadu ngwanni ngwuru ngwuwayi, jayi gwüngün gwujalu gwurꞌtal!” ");
INSERT INTO lro_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","Gwenene nginde gwanni gwati ätä dïjü yuula ngwuje kwoy ngwätä dïjü yona ngweny, gwa je monaci ꞌto gwa je onjaci yuula gïyïlü gwa je üngrïjï girunyanu gidi jayi gwalu. ");
INSERT INTO lro_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","La je nïyänü giyiꞌral ꞌdar nunnu ngaa ätä ligor le lijayanu giyomon ꞌdar na ätä gwe gwudi ligor lalu lijayanu, ngwujaꞌri ngwee ngwägïbïcï ngwüjü ngwa ci Ngwaalinga yäy ꞌtu gwani alanga. ");
INSERT INTO lro_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","Yiiru giyee yanni yati a je ärrï yaꞌti monaca ngwüjü ngwudi Ngwaalu ꞌdogo, yati ïrälü ngwujaꞌri ꞌdar ndi ondaji gwudi ci Ngwaalinga yäy ꞌtu. ");
INSERT INTO lro_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","Ndi ari yiiru yanni yima ye inggidi yigoꞌro yalu, ngwüjï ngwa ortada Ngwaalu ꞌdengenaci gwe gwanni gwati gwujana inggiding gwalu gwani ngwujaꞌri ngwanni ngwujaw ngwudi Kirictu na gwani ätä ligor le lijayanu ndi a le acajidi na ndi acajidi gwalu ngwüjïngä le ngwuꞌter. ");
INSERT INTO lro_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","Ngindenga ndi otaci Ngwaalingalu gwegen gwani bupi gwalu, yigor yegen ya ji ꞌdanggalu nunnu gwani yïmïꞌrü yidi Ngwaalu yanni yima ïrälü ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","Yäy ꞌtu gwani Ngwaalu ndi angidaji gwüngün gwanni gwati ꞌti gwa ar gwe burni ndi ondaji! ");
INSERT INTO lro_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","Üllänü gwe jïlänü gwe gwudi Kirictu, äny gwa je päcälü äny gwani Bulij gwanni gwati gwe ari gwuru dideny ma le ji, mung be ji ngwaalu ngwolanu ngwube ꞌranu. ");
INSERT INTO lro_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","Äny gwada je ci nyii ꞌti gäbïcä ndi nyi ꞌranu ma ar ji, ndi ari äny gwubupa ndi ꞌranu ndi ondaci ngwüjü ngwanni ngwati ari nyii lelella yiꞌral ye yidi dïdlä ndee. ");
INSERT INTO lro_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","Anni raar gu ndi ari alanga gilo gïdïdlä ndee a be laꞌti dugidu yärä anaku ati gu ngwüjï dugidi yärä ngwudi dïdlä. ");
INSERT INTO lro_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","Ngwäbländï ngwanni ngwudugidar ngwe, ngwäꞌtüdï ngwudi lingeno lidi dïdlä, aar be ru manni ngwäbländï ngwanni ngwuru yiima yidi lïgïꞌrïm ngwätï yiima ndi pä yundiꞌralu yanni yojema nono, ");
INSERT INTO lro_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","alanga lätï yiima ndi dami garnating gwuru ꞌtur gwanni gwadi alliji ligoꞌrala ndi bebere gwudi Ngwaalu ar määtä yiꞌralalu yere ꞌdar ar je gekajalu ar je gäbïcï aar ꞌdengenaci Kirictung. ");
INSERT INTO lro_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","Na ma ji ma ꞌdengenaci gwalu mbuti, nyii la be ji mama ndi reraji nyurtanu gwe gwere gwanni gwa ji. ");
INSERT INTO lro_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","Nga nga lati ombaji ngwony nono poor ꞌdogo. Ma dïjï dere dïcïnänü ndi ari diru didi Kirictu, gäbïcär ngwengga mana ndi ari nyii lidi Kirictu liru ꞌto nono rung gu nginde. ");
INSERT INTO lro_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","ꞌDi manari äny gwuma ïrïngïnï ngwaalu ngwere gwügätïnä linginalu yeleny ye yanni yïgïꞌtïjäär nje Ngwaalu nunnu ara je ye allijala ndi ari ara je ye ïꞌdïyï gïdïyängälü, ya ꞌti yiny apiyi yaaru. ");
INSERT INTO lro_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","Äny gwaꞌti gu aru no, ngaa je iye yedenyo ngwujaꞌri ngwe ngwüny ngwee ngwulli nje. ");
INSERT INTO lro_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","Loko ꞌdanggalanu lati ari, “Ngwujaꞌri ngwüngün ngwünï aar ojeme, ma ar le be ji ngwäyälü, ngwube oꞌralu ngwuru guꞌru gooko a ngwujaꞌri ngwüngün ru ꞌtur.” ");
INSERT INTO lro_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","Ngwüjï ngwanni ngwati gu ari no, aar lenge ndi ari nyii liru ngwujaꞌri minyi erne, minyii be ji ngwäyälü, nyii la be ru yiiru. ");
INSERT INTO lro_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","Nyii laꞌti jädï ndi übïdï yigoꞌranu yärï ngwüjï ngwe ngwoko ngwanni ngwati näjï yiima yegen. Ma aar ïdï yigoꞌranu yegen yigoꞌro ye yegen na aar übïdï yigoꞌranu yegen yigoꞌro ye yegen, ngindenga laꞌti bebera. ");
INSERT INTO lro_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","A be nyii laꞌti la ïrïngïnï giyiiru yanni yätädäär nje Ngwaalu gwelleny nyii dambdani garci, a be nyii gwäꞌrïnï ïrïngïnïng gwärï giyiiru yanni yïgïꞌtïjäär nje Ngwaalu yiiru yima ele ꞌdi yima obana ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","Nyii laꞌti la dambdani gweere ndi ïrïngïnï gwärï anaku aadi aar gu ru adinari nyii lima ꞌti ïndï ꞌdanggalu, ndi ari lima je le ele gweere ngwujaꞌri ngwe ngwanni ngwujaw ngwudi Kirictu. ");
INSERT INTO lro_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","Na nyii laꞌti la dambdani garci gärï nyii ïrïngïnï giyiiru yape je ngwüjï ngwuꞌter. Geꞌtaji gwärï gwuru ndi ari anaku gendadu gu ämnï Ngwaalu gwalu ndi ꞌtänü, ngwaalu ngwudi yiiru yärï ꞌdanggalanu ya gendadi ya ongranu, ");
INSERT INTO lro_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","nunnu nyii ondaji ngwujaꞌri ngwe ngwanni ngwujaw ngwaalu gweere ꞌdanggalu. Ndi ari nyii laꞌti bupa ndi ïrïngïnï yiiru ye yäpïnä ngwaalu ngwudi dïjï diꞌter. ");
INSERT INTO lro_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","A be, “Gäbïcär gwanni gwadi ïrïngïnï, ngwïrïngïnï Gideleny.” ");
INSERT INTO lro_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","Ndi ari nginde gwäꞌtüdï gwanni gwati gwällïnï ligoꞌro lüngün gwati aar ämnï, ngwube ru nginde gwanni gwati Deleny gwällïnï. ");
INSERT INTO lro_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","Nggweꞌtaja ndi ari ngaa geraji länï gwoko giyeꞌrr yüny. A be nggwülïngïdï gu ndi ari ngaa lima gu ru. ");
INSERT INTO lro_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","Ligor lïtïnyänü gwulleny gwani nga nga, ligor le lidi Ngwaalu äny gwümïnïjä je gaga gidur deꞌte pu dani Kirictu, nunnu ngaa je gïꞌtïjï ngindeng kay nono guꞌtaara gijuꞌru. ");
INSERT INTO lro_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","A be yedeny giyo yïtïny ndi ari anaku ïꞌdäjä gu düüngä Awang kaci gwe yiꞌrinya, ndi ari aaꞌti nga la gäbïcï dïjü dere ndi gwürlï yigor yalu ndi ämnï gwanni gwuru ꞌdidanu na ämnï Ngwaalu ngwanni ngwujuꞌru ndi Kirictu. ");
INSERT INTO lro_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","Ndi ari manari dïjï dere dima ila ara je ondaci Yicu gwe gwuꞌter gwäꞌtüdï gwanni gwondacara je gwe gwerre, na manari ngaa lima ape lïgïꞌrïmä liꞌter läꞌtüdï lanni lapanga gwerre na ngaa ämnï ngwujaꞌri ngwanni ngwujaw ngwuꞌter Ngwujaꞌri ngwanni ngwujaw ngwanni ngwämnä je gwerre, yata je ape puprang. ");
INSERT INTO lro_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","A be äny gwaꞌti änggädï ndi ari nggwokana guꞌru ngindenga licaar je “ngwooꞌra ngwükäjäär je ngwupa.” ");
INSERT INTO lro_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","Manari nggwaꞌti ubu kinene ndi ondaji, a be nggwaꞌti amiꞌratu bebereng. Yenggacara je giyee gilingenalu kaji ꞌdar. ");
INSERT INTO lro_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","Yärrü nje yanni yiki anni minyi ülläjï ligoꞌralu lüny nunnu nga je allijala nga je ondaci ngwujaꞌri ngwanni ngwujaw ngwudi Ngwaalu nga je ꞌti mïnädï gony nono gere? ");
INSERT INTO lro_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","Nggwügïrïdïnä yiꞌdoonga ye yiꞌter aar nyi ätädï gwani nga nga nunnu nga je äpïjï yiiru. ");
INSERT INTO lro_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","Na gaji ganni gijar ge nyi bupi gony gere nggwaꞌti äbïngïnä dïjänü dere ꞌdanggalanu kong gere. Ndi ari ngweengga ngwanni ngwïndï Majiduniya, yätädär nje yanni yibupi nje. Nggwetaca ligoꞌro lüny nda je äbïngïnänü yiꞌral ye yere, a nggwaꞌti gwa je gu äbïngïnä aꞌtur. ");
INSERT INTO lro_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","Anaku ꞌdidanung gwudi Kirictu ꞌdünggüny, dïjï dere daꞌti ngwaalu ꞌdar ngwani Akayiya, diny dünäjï ndi ïrïngïnï nggwee gwüny. ");
INSERT INTO lro_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","Ange gwuru? Ndi ari nggwaꞌta je ämna? Ngwaalu ngwuru ꞌdogo ngweꞌte pu ngwülïngïdï ndi ari nggwämnä je. ");
INSERT INTO lro_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","Nggwadi gwuji yiiru giyee yape nje gweneno nje ärrï nunnu aaꞌti nggwa geꞌte gay a gu ngwüjï mbojaji aar ꞌtädälü ndi ari ngwubidiiny ngwanu giyiꞌralanu yanni yati aar gu ïrïngïnï. ");
INSERT INTO lro_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","Ndi ari ngwüjï ngwanni ngwuru gu no, ngwäꞌtüdï ngwooꞌra ngwükäjäär je ꞌdidanu, ngwuru ngwüjï ngwapu yiiru aar ye ïꞌdäjï ngwüjänü, ngindenga lati arri nono ma aar ru ngwooꞌra ngwükäjäär je ngwudi Kirictu. ");
INSERT INTO lro_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","Aaꞌti ya je allijalu ndïr ndi ari dijegoꞌrr giligoꞌro lüngün dati arri nono mung ru gïꞌrr gidi buri. ");
INSERT INTO lro_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","Yäy gu no, yaꞌti ya ru yïrnü ndi ari ngwïnäd ngwüngün arri nono ma aar ru ngwïnäd ngwujaw. A be ndi mïꞌrä gwegen ngwadi ru nono yiiru yegen. ");
INSERT INTO lro_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","Nggwoꞌre nggwari mana aaꞌti dïjï dere da ji ndi ari äny gwuru deꞌrr. A manari ngaa lari äny gwuru deꞌrr, ämnäcïny be nono deꞌrra nunnu nyi ïrïngïnï gwooko. ");
INSERT INTO lro_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","Yanni yaru nyi ye gweneno, yaꞌti ïndï ndi Kirictu a be yondaji nje nono dïjü diru deꞌrr diꞌranu ndi ïrïngïnï. ");
INSERT INTO lro_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","Ndi ari lonyadu lanni lati ïrïngïnï yigoꞌro ye yegen nono ngwüjï ngwudi dïdlä a mine nggwarra nyi ꞌti be ïrïngïnï ꞌto. ");
INSERT INTO lro_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","Ndi ari yiru gu ꞌdanggalu liru ngwüjï ngwätï bebereng ata be geraci ngweꞌrra länï ngaa jayanu. ");
INSERT INTO lro_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","ꞌDidanu ngaa lati geraci dïjü länï ma ara je ärrï yïnädä, ma ara je raji ꞌter, ma ara je gu mbojaji, ma ara je gu allija ligoꞌrala, ma ara je mïꞌrï dirke de ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","Yaaru yapeny ndi nyi ari nyii lamiꞌrati ndi ara je gu ärrï no! A be anni runy nono dïjü dondaja yeꞌrra, amni ꞌdar yanni yibupa je ngwüjï ngwee ndi ari ye ïrïngïnï, yiny ye ïrïngïnï ꞌto. ");
INSERT INTO lro_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","Manari laru liru Ngwïbrü, äny gwuru Dïbrü ꞌto. Manari lari liru ngwüjï ngwudi Yïjïräyïl, äny gwuru dïjï didi Yïjïräyïl ꞌto. Manari lari liru yïjï yidi Äbräyïm, äny gwuru gu ꞌto. ");
INSERT INTO lro_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","Ngindenga laru liru ngwïnäd ngwudi Kiricto? Äny gwondaja nono miny rlälï kiꞌranu, äny gwujayana ꞌdenggegen! Äny gwupana yiiru ꞌdenggegen, nyi ji korkon yomon yonyadu, aar nyi pïdänï gwulleny, nyi ru gwadi ayi yomonanu yonyadu. ");
INSERT INTO lro_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","Yomonanu tudini (5 ) a nyi Ngwüyäwüd pï lacal le yomonanu küüꞌrï rom (40) ngwäbrïnï geꞌte. ");
INSERT INTO lro_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","Aar nyi pï guura ge yomonanu täꞌrïl (3). Aar nyi aci yoꞌrr ye gomon geꞌte. Nyi ke bälükä gwänü yomonanu täꞌrïl (3), nyi ji gidiliganu giyaanu gangin gangin na ngwülü ngwülü ꞌdi a ngwaalu uꞌri. ");
INSERT INTO lro_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","Nggwati ji gïdïlä giyomon ꞌdar, a nyi yiꞌral yiki mbuji ngwubirta ngwudi yaw, ngwuꞌram, ngwüjï ngwuru Ngwüyäwüd, ngwüjï ngwuru Garany, gïyündäränü, gïyundär poor, giyaanu na ngweengga ngwanni ngwuru ngwuꞌduru, ");
INSERT INTO lro_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","Nyi gwapu yiiru gwundu ngwäy, nyi jalu ngwäy ngwe dilu de, nyi jalu ngwamu ngwe, nyi jalu ngwäädä ngwe, nyi erne enying, a nyi dirun eny, nyi erne ngwureda. ");
INSERT INTO lro_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","ꞌDar giyee, nyi be oꞌre ati nyi ligor päcï yiꞌdonganu yidi ngwïkïrïjïn yomon ꞌdar ndi nje ombaji. ");
INSERT INTO lro_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","Gwïndï ne gwa muli nono nyii gwe ꞌti be mulu nono, gwïndï ne gwa ïꞌdï giyiꞌralanu yiki, aar nyi ꞌti be uꞌdiyanu nyi rünïjï. ");
INSERT INTO lro_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","Manari aar ani ïrïngïnï, nggwa be ïrïngïnï yiꞌral ye yanni yinggidiny gwamiꞌratu. ");
INSERT INTO lro_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","Ngwaalu ngwuru Papa gwudi Deleny dege dani Yicu gwanni ngwortana gwurꞌtal, ngwuru gwülïngïdï ndi ari nggwaꞌti ondaju yiꞌduru. ");
INSERT INTO lro_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","Dartan didi gündär gidi Dimajiging danni dïmätï yeleny ye yidi Deleny dani Arataj, dïrädïny kündär gani Dimajig nunnu aar nyi määtä. ");
INSERT INTO lro_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","Aar nyi be ngweengga ꞌtüyä aar nyi üllïyä giꞌram ge kubuꞌru kundiꞌrr, nyi gwannada aar nyi ꞌti mätï. ");
INSERT INTO lro_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","Äny gwätï ndi ïrïngïnï. Äny gwülïngïdï gu ndi ari yäꞌtüdï guꞌru, a be nggwada je ondaci gwenene ngwujaꞌri ngwudi Kirictu ngwenggacar nje dilingidu na ngwanni ngwüꞌtäjïng jälü. ");
INSERT INTO lro_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","Äny gwülïngïdï guru geꞌte ndi Kirictu ngwüdlä ngwe ꞌdï na kwoꞌrongo ngwanni ngwuma ele, gïmätäär aar ge ele kerala. Gaꞌtiny ge lïngïdï yiꞌral ndi ari gïndï ngenone ngwanginu ngwe yaa ngwaꞌti ngwe ïndï, yaꞌti nje lïngïdï Ngwaalu ngwuru ngwülïngïdï je. ");
INSERT INTO lro_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","Na äny gwülïngïdï ndi ari dïjï ndee ngwanginu na ꞌter ngwanginu, yaꞌti nje lïngïdï, a be Ngwaalu ru ngwülïngïdï ");
INSERT INTO lro_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","gïmätäär aar ge allu bruduj ngwuꞌdingini yiꞌral ye yiru ꞌter yaꞌti ya ye dïjï dümnä ondajalu. ");
INSERT INTO lro_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","Äny gwa ïrïngïnï dïjï de danni diru gu no, äny gwaꞌti gwa ïrïngïnï ligoꞌro le lüny nyi be ïrïngïnï ꞌdogo amiꞌrati gwe gwüny. ");
INSERT INTO lro_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","Na manari äny gwätï ndi ïrïngïnï, äny gwaꞌti gwa ru deꞌrr, ndi ari äny gwadi ondaji ngwujaꞌri ngwanni ngwuru ꞌdidanu. Yinje be gäbïcï nunnu aaꞌti dïjï dere diny engga ndi ari äny gwurana guꞌru giyiꞌral yanni yänggädïng je ngwuje ꞌdingini ꞌdünggüny. ");
INSERT INTO lro_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","A be nunnu aaꞌti äny gwa ïrïngïnï gwani ꞌtäälü nggwee gwupa gwätädäär nyi, aar nyi be gïꞌtïjï dügï ngwanginu ngwüny dïndï gidijegoꞌrr nunnu aar nyi de gwüꞌrä nunnu aaꞌti äny gwa ïrïngïnï. ");
INSERT INTO lro_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","Nyi be päcï Delenyalu yomonanu täꞌrïl (3) ndi ari aar nyi apada, ");
INSERT INTO lro_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","aar nyi be Deleny ci nu, “Yïmïꞌrü yüny yimbutu ꞌdunggunga, ndi ari yiima yüny ya ang mbuti ndi amiꞌrati gwunga.” Yäy gu no, äny gwa be jayananu ndi ïrïngïnï ndi amiꞌrati gwüny, nunnu a yiima yidi Kirictu ji ꞌdünggüny. ");
INSERT INTO lro_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","Yiru yanni yïgäbïcïny gwani Kirictu, nyi jayanu ndi ari äny gwamiꞌratu, nyi amiꞌrati ndi aar nyi lo, nyi amiꞌrati gïyüündänü, aar nyi übïnälü na giyiꞌrendenyanu. Ndi ari ndi amiꞌrati gwüny, äny gwojema nono. ");
INSERT INTO lro_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","Äny gwarru nono deꞌrr. Nga nga liru lïgäbïcïny nyi gu be ru no, nga nga liru ladi nyi ortada ndi ari äny gwaꞌti okana guꞌru “Ngwooꞌra ngwükäjäär je ngwupa,” ꞌdi minyi ni ru ꞌtur. ");
INSERT INTO lro_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","Yiꞌral yanni yati inggidi doꞌra dükäjäär, yiꞌremna, allijalu ndïr na yiima yärrïnä ꞌdanggalanu orꞌtemaji gwe gwupa. ");
INSERT INTO lro_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","Nga nga lokana guꞌru awa giyiꞌdoonga yiꞌter, ꞌdogo ndi ari äny gwaꞌta je äbïngïnänü yiꞌral ye yere aꞌture? Düdänïjïnyänü manari yima je ärrïjï yanni yiki! ");
INSERT INTO lro_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","Äny nggwo gweneno gwuju mama ndi ila ꞌdanggalu komonanu täꞌrïl (3). Äny gwaꞌti gwa je äbïngïnänü yiꞌral ye yere, ndi ari äny gwubupa je ꞌdogo, äny gwaꞌti bupa ngwony ngwalu. A be ꞌto yïjï yäꞌtüdï yadi gïkïjï papanga je, a be papanga ru ladi gïkïjï yïjü. ");
INSERT INTO lro_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","No äny gwa jayanu nda je gïꞌtïjï yiꞌralalu ꞌdar yätï nje ꞌdi gwa je gïꞌtïjï ligoꞌro lüny ꞌto. Manari äny gwämnänä je, ii nyii be ämnänï gwooko? ");
INSERT INTO lro_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","Aar gu be ru manari yiru gu ndi ari äny gwaꞌta je äbïngïnü yiꞌral ye yere. Nyi be ru dïjï dägädäjänü no, nga je gu mamiꞌranu ꞌtïꞌtïr! ");
INSERT INTO lro_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","Äny gwumbojaja je gony nono gere ngwüjï ngwanni ngwükäcä je? ");
INSERT INTO lro_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","Äny gwüpäcä Tïtüjïngälü ndi ari ngwila ꞌdanggalu, nje ükäjä diweengga de dege. Tïtüj gwaꞌta je gu mbojaja. Gwumbojaja je gu? Yaꞌti nje ärrü lïgïꞌrïm leꞌte leꞌte nyi gwuji gay geꞌte po? ");
INSERT INTO lro_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","Ngaa liju ndi geꞌtaji kaji ꞌdar gwele ndi ari, änyängä liruca yigoꞌro yärï ꞌdanggalo? Bärï, nyii londaja ngwäyänü Ngwaalu liru ngwüjï ngwämnä ndi Kirictu. Na bupi gwärï lani ngwumaad, gwuru ndi ari ara je oda gïlïgïꞌrïm. ");
INSERT INTO lro_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","Yedeny giyo yïtïny ndi ari minyi ila ꞌdanggalu, äny gwa je mbuji giyiꞌral yaꞌti nje mïnü na ngaa liny mbuji yiꞌral ye yaꞌta je mïnü. Yedeny giyo yïtïny ndi ari minyi ila äny gwa je mbuji likadu, nggwa je mbuji gïyüꞌdüny, nggwa je mbuji güündä gapa je, nggwa je mbuji ngaa lüꞌrïꞌtïdänü, laru ngwulem, nggwa je mbuji länïjä ngwüjü nono, lipiya yigoꞌro, nggwa je mbuji ngaa lïꞌdïgwüꞌrïdï. ");
INSERT INTO lro_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","Yedeny yïtïny manari nggwuma ila ꞌdanggalu mana, Ngwaalu ngwüny ngwuny okeye ngwäyänü ngwalu äny gwa be arada ngwüjü ngwoko ngwonyadu ngwanni ngwapu gwuki gwerre aar ꞌti be joꞌrenyana ndi rngï, gïyïjïn na giyidigany yegen yanni yärrï je. ");
INSERT INTO lro_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","Yiru ndi ari gomon nggee gadi ru täꞌrïl (3) ndi ila ꞌdanggalu anni lïngïdär ndi ari gitab garu nu, “Yiꞌral yere ꞌdar a ngwüjï ji rom (2) na ji täꞌrïl (3) aar je ꞌdingini gilingla legen yanni yänggädär je.” ");
INSERT INTO lro_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","Nggwärngädä je gwerre anni jar gomon nggoo giru giꞌra rom na gwenene nggwaꞌti gito ꞌdanggalu, nggwoꞌre nggwa je arnga mana yiꞌral ye yeꞌte yeꞌte. Nga je ci manari äny gwuma ila, lele lanni lapu gwuki gomon nggoo na gwere gwuꞌter ngwüjänü, laꞌta be liny ïnä mana. ");
INSERT INTO lro_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","Anni bupangaa yiima aar inggidi ndi ari Kirictu gwondaji nyi gwe. Nginde gwaꞌti amiꞌratu ꞌdanggalanu ngwube ätï yiima yipa ꞌdanggalanu! ");
INSERT INTO lro_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","Ndi ari ꞌdidanu nginde gwüpädäär küꞌrï gwamiꞌratu, a be nggwo gwumidu yiima ye yidi Ngwaalu. Yiru gu yeꞌte yeꞌte ndi ari nyii gilo ꞌto lamiꞌratu a be yiima ye yidi Ngwaalu, nyii gilo limidu ndi ara je äpïjï yiiru. ");
INSERT INTO lro_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","Dïdïmär yigoꞌro yalu ngaa engga ndi ari ngaa gilo lämnä Ngwaalu, mïmïnnär yigoꞌro yalu. Ngaa laꞌti gu lïngïdï ndi ari Yicu Kirictu nggwo ꞌdanggalanu, manari yaꞌti gu rüdï, ngaa lima be ru ngwüjï ngwuma je dïdïmï nggwee gwanna. ");
INSERT INTO lro_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","Nyii lïcïnänü ndi ari ngaa la gu lenge ndi ari dïdïmï nggwee ngwaꞌti nje gwännädï. ");
INSERT INTO lro_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","Nyii otaca Ngwaalingalu aaꞌti ngaa la ape yiꞌral yanni yiki. Nunnu aaꞌti ngwüjï ngwengga ndi ari nyii lïgwällïnä ndi dïdïmï, aar be ru ndi ari ngaa je ärrï yanni yiru ꞌdidanu, manari nyii lima ru nono lima ꞌti ïcä ndi dïdïmï. ");
INSERT INTO lro_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","Ndi ari nyii laꞌti la burni ndi ape yiꞌral yere yanni yäꞌtüdï ꞌdidanu a be ꞌdidanu ru gwärrïïny. ");
INSERT INTO lro_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","Nyii lati jayanu manari nyii lamiꞌratu ngwaalu ngwere, ngaa be ojeme nono. Nyii be otaci Ngwaalingalu ndi ari ngaa ru ngwüjï ngwumbutu. ");
INSERT INTO lro_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","Na yanni yïgäbïcïny nga je be üllïjä ngwujaꞌri ngwee nggwaꞌti gito ꞌdanggalu, yiru ndi ari aaꞌti nggwa je gu linyaci yiima minyi ila, yiru gu no yeleny ye yanni yätädäär nje Kirictu nga je ye odada aaꞌti ya je ye gatu gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","Gwodanalu, lani ngweengga, jayaranu. Ïndädär gweere ngaa olati, ꞌdengenacar päcïngälü gwüny ꞌdanggalu. Ngaa ru yigor yeꞌte pu. Jaralu ladatalu. Na Ngwaalu ngwudi ämnï na adatalu, ngwa ji ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","Agannajidar giyinenanu agannajiding gwanni gwujuꞌru. ");
INSERT INTO lro_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","Ngwïkïrïjïn ꞌdar ngwudi ngeng, ngwaganna je. ");
INSERT INTO lro_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","Ara je gu yïmïꞌrü ji yidi Deleny dege dani Yicu Kirictu, ara je gu ämnï ji gwudi Ngwaalu, ara je gu acajidi ji ꞌdar gwudi Lïgïꞌrïm lanni Lijuꞌru.");
INSERT INTO lro_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Ngwujaꞌri ngwee ngwïndï ꞌdünggüny gwani Bulij gwuru dooꞌra dükäjäär, dïjï dere daꞌtiny ükäjü nyi ꞌti ükäjïnä yeleny ye yere yidi dïjï dümnä. A be Yicu Kirictu ru na Ngwaalu ngwuru Papa ngwükäjïny. Ngwanni ngwüꞌdïꞌrïyä Yicungalu giyiꞌranyanu. ");
INSERT INTO lro_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","Änyängä ngweengga ngwe ꞌdar ngwanni ngwämnä Ngwaalu ngwujiiny ngwe ngene. Lükäcä je ngwujaꞌri ngwee lanni lämnä Ngwaalu liru giꞌdoonga gidi Galatiyang. ");
INSERT INTO lro_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","Ara je gu yïmïꞌrü na adatalu ji gwudi Papa gwuru Ngwaalu na Deleny dege dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Gwanni gwülïngïdä gu ndi ari gwududiya ligoꞌro lüngün gwani ke gwege nunnu aar nje üꞌrälü gïdïdlänü ndee danni diki anaku bupa gu Papa gwege gwuru Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","Ngwa ar je näjï yomonalu pipiꞌriꞌti. Yiru gu. ");
INSERT INTO lro_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","Dïlä dalu ndoo didibiyiny ndi ari ngaa lima gatani Ngwaalingalu kïrïny ngwanni gwurnida je yïmïꞌrü ye yidi Kirictu. Ngaa lima gwurla ndi gwuji ngwujaꞌri ngwanni ngwujaw ngwuru ꞌter. ");
INSERT INTO lro_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","ꞌDiꞌdanu ngwujaꞌri ngwanni ngwujaw ngwuꞌter ngwaꞌti. A be yilinginna ndi ari ngwüjï ngwo ngwanni ngwata je gwagilli ngwäy ngwujaꞌri ngwe ngwegen, ngwuru ngwanni ngwümïnü ndi üpïyï ngwujaꞌranu ngwudi Kirictu. ");
INSERT INTO lro_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","A be manari änyängä lima ru gwalla yïꞌrr yidi gerala, liru lima je ondaci ngwujaꞌri ngwere ngwuꞌter ngwujaꞌri ngwanni ngwondacara je gwele, gäbïcär aar gu ꞌtäjï ngwünyü bupud! ");
INSERT INTO lro_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","Anaku aru nyi gu gwele no, nggwoꞌre nggwa gu ari mana manari dïjï dere dima je ondaci ngwujaꞌri ngwuru ꞌter ngwäꞌtüdï nono ngwujaꞌri ngwanni ngwondacara je ngwe ngaa je määtä, gäbïcär aar gu ꞌtäjï ngwünyü! ");
INSERT INTO lro_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","Yiꞌral gweneno yiru nono ndi ari äny gwümïnä ndi aar nyi gwe ngwüjï gwällïnï na aar nyi gwe Ngwaalu gwällïne? Na äny gwümïnä ndi gäbïcï ngwüjü aar jayanu? Adinari nyi jina ndi ari nyi gäbïcï ngwüjü aar jayanu, nggwaꞌti gwadi ru dïnäd didi Kirictu. ");
INSERT INTO lro_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","Äny gwümïnä ndi ang lenge, lani ngweengga ndi ari ngwujaꞌri ngwanni ngwujaw ngwondaca je ngwe ngwäꞌtüdï yiꞌral yigeꞌta je dïjï dümnä. ");
INSERT INTO lro_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","Ngwaꞌti nje apu gïdïjï dere na aar nje ꞌti dïjï dere enggacu. Aar be ru ꞌtäälü gwudi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","Nga nga liꞌdingina elelle gwe gwüny gwele gwerre gaji ganni gijiny ge ndi gwuji yobo yidi Ngwüyäwüd. Ndi ari awa nggwübüdïyä giꞌdonga nono gidi Ngwaalu ꞌtiꞌtir nyi übïnälü nunnu nyi dudiyi ngwugeradalu. ");
INSERT INTO lro_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","Äny gwuju nyi ru giꞌra gidi yobo yidi Ngwüyäwüd kimaad güny ati nyi ꞌri ligor gwulleny gïdïmüränü didi mbumbunga lüny. ");
INSERT INTO lro_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","A be anni ma Ngwaalu ämnï ndi aar nyi ätä ngwujaꞌri ngwee, anaku geꞌtaar nyi gu ꞌtuꞌtu gilaranu ndi nanni gwüny, aar nyi urnida yïmïꞌrü ye yüngün, ");
INSERT INTO lro_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","ngwujada ndi ꞌtäjä gïjälü güngün ꞌdünggüny ndi ari nyi ätï yiima ndi ondaci ngwüjü ngwanni ngwuru Garany, ngwujaꞌri ngwanni ngwujaw. Nyi ꞌdïꞌrï nyi ꞌti otaca dïjälü dere, ");
INSERT INTO lro_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","nyi ꞌti ändï Üräjälïm ngwooꞌra ngwükäjär je gwerre gwerre ꞌdünggüny. Nyi be manni ꞌdïꞌrï puprang nyi ele ngwaalu ngwani Arabiya. Nyi be aji nyi ꞌdïꞌrï ngenone nyi oꞌre kündär gani Dimajig. ");
INSERT INTO lro_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","A be anni minyi ape ngwüdläyü täꞌrïl (3), nyi ꞌdïꞌrï nyi allu Üräjälïm ndi nyii lingidida Butruj gwe nyi gwe jalu yomon ꞌdï na tudini (15). ");
INSERT INTO lro_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","Nyi ꞌti mbuju ngwoꞌra ngwükäjäär je ngwere, nyi be mbuji ꞌdogo Yagubing gweꞌte pu gwanni gwuru gwenggen gwudi Deleny dani Yicu. ");
INSERT INTO lro_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","ꞌDiꞌdidanu nggwa je ci Ngwaalu ngwuru ngwülïngïdï ndi ari ngwujaꞌri ngwee ngwüllïjä je, ngwuru ngwanni ngwuru ꞌdidanu ngwäꞌtüdï yiꞌduru. ");
INSERT INTO lro_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","Nyi be aji nyi ila giyen yicaar je Jürïyä na Kïlïkïyä. ");
INSERT INTO lro_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","Äny giligoꞌro lüny gwaꞌti linginna giyiꞌdoonga ndi Kirictu yidi Yäwüdïyäng. ");
INSERT INTO lro_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","Ngindenga liꞌdingina ꞌdogo yiꞌral ndi ari, “Gur ganni gübïnä jälü gwele gwerre, nggo gwenene ndi ondaci ngwüjü ämnï gwe Ngwaalu gwanni gwübïnïngälü gwele ngwubupi nding gerajalu.” ");
INSERT INTO lro_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","A je yiꞌral giyee gäbïcï aar ortada Ngwaalinga gwani äny. ");
INSERT INTO lro_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","Anni ma ngwüdlä ru ꞌdï na kwoꞌrongo (4), nyii ꞌdïꞌrï Birnaba gwe nyii allu Üräjälïm nyii apani Tïtüjïng ꞌto. ");
INSERT INTO lro_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","Nggwüꞌdïꞌrü nyi allu Üräjälïm gwani ꞌtäälü gwudi ngwujaꞌri ngwudi Ngwaalu. Liminje gïꞌtïjï ngwujaꞌralu ngwäyänü nje enggaci ngwanni ngwujaw ngwati nje ondaci ngwüjü ngwuru Garany. Anni jiny ngenone, nyii le jalu jücü giloo liꞌter ꞌdar lanni laru liru yiꞌra ndi ari yedeny yïtïny ndi ari nggwaꞌti mïnä yiiru giyee yanni yape nje gwerre na gweneno aar ru ꞌtur. ");
INSERT INTO lro_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","Na Tïtüj ꞌto gwanni gwïndïïny gwe, aar ꞌti aru gwa aar üꞌrïdä yiima ye anaku aaꞌting gu rüdï Dïyäwüd gwuru Dïgïrïg. ");
INSERT INTO lro_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","(Yiꞌral yani üꞌrïdänï) yïꞌtïyä je ngweengga ngwanni ngwuru ngwuꞌduru ngwubojaja ndi gätïnï linginalu gwärï liru ngwïkïrïjïn ndi Yicu Kirictu, aar be änälü ngwïkïrïjïnänü, aar mïnï ndi aar nje gwäꞌräjï gïyïnäd yidi yobo yidi Ngwüywüd ndi ari a Tïtü üꞌrïdänï. ");
INSERT INTO lro_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","A be anaku lïngïdïny gu ndi ari nunnu ngaa mätïnälü ꞌdiꞌdidanu ngwujaꞌri ngwanni ngwujaw, nje ꞌti ätädï gay ꞌdi gooko. ");
INSERT INTO lro_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","Yäy a be giloo laru liru yiꞌra yidi giꞌdoonga gidi ngwïkïrïjïn Üräjälïm, laꞌti gendana yiꞌral nono yere ꞌdünggüny giyiꞌral yidi Ngwaalu yanni yati nje enggaci ngwüjü. Ndi ari ngindenga aar ru yiꞌra aar ꞌti rüdï yiꞌra, yaꞌtiny ädï ngwäy. Ngwäyänü Ngwaalu, ngwüjï ngwubidanu. ");
INSERT INTO lro_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","Länggädï manni ndi ari Ngwaalu ngwätädïny yiiru ndi enggaci ngwüjü ngwanni ngwuru Garany ngwujaꞌri ngwanni ngwujaw nono ätädïng gu Butrujing yiiru ngwüjï ngwudi Ngwüyäwüd nding je enggaci ngwujaꞌri ngwanni ngwujaw. ");
INSERT INTO lro_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","Ndi ari yiima ye yidi Ngwaalu yanni yiju giyiiru yidi Butruj ngwuru dooꞌra dükäjäär ndi ondaci Ngwüyäwüd ngwujaꞌri ngwanni ngwujaw, yiru ꞌto yanni yiju ꞌdünggüny nyi ru dooꞌra dükäjäär ndi ondaci ngwüjü ngwuru Garany ngwujaꞌri ngwanni ngwujaw. ");
INSERT INTO lro_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","Yagubinga Butruj gwe na Yuwana lanni laru liru yiꞌra, lämnä ndi ari Ngwaalu ngwuru ngwätädïny yiiru giyee yiru yïmïꞌrü, a no nyii le ätäjïdï ngwuy na Birnaba ndi inggidi ndi ari nyängä ꞌdar liru gimaad lubidanu giyiiru yidi Ngwaalu. Nyängä lämnä ndi ari Birnaba na äny, ati nyii ape yiiru yidi Ngwaalu ngwüjänü ngwuru Garany, aar be ape yiiru ngwüjänü ngwuru Ngwüyäwüd. ");
INSERT INTO lro_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","ꞌDar yanni yaraar ye ꞌdogo, laru ati nyii diwayini ngwengga ngwanni ngwuru ngwuwayi kiꞌdoonganu gegen. Yeꞌte yeꞌte yanni yigeꞌte nje giligoranu lüny ndi nje ärrï. ");
INSERT INTO lro_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","A be anni ma Butruj anda Andakiya, nyi girinya ngwüjänü anaku arrung gu yiꞌral yaꞌti ïndï kayalu. ");
INSERT INTO lro_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","Gwerre gwerre gaji gaꞌti ge na ngwooꞌra ngwanni ngwükäjä je Yagub obana, Butruj gwati aar emadi ngweengga ngwe ngwuru Garany kiny geꞌte pu. A be anni ma ngwooꞌra obana, a yedeny eny Butrujing ngwüjï ngwanni ngwümïnä ngwüjü ngwuru Garany aar üꞌrïꞌtänï. Ngwuꞌdonya ndi aar le emadi. ");
INSERT INTO lro_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","A ngweengga ngwoko ngwuꞌter ngwuru Ngwüyäwüd arri yimurꞌtunya nono Butrujing, ꞌdi diweengga ꞌto dani Birnaba ngwuje ädïnï giyiꞌral yegen yidi yimurꞌtuny. ");
INSERT INTO lro_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","Anni miny gu engga no, ndi ari ngindenga laꞌti ïndï ꞌdiꞌdidanu gwe gwudi ngwujaꞌri ngwanni ngwujaw, nyi ondaci Butrujing ngwäyänü ngwüjï ꞌdar nyi ci, “Nga gwuru Dïyäwüd, nga mine gwurli nga elelle nono ma ang ꞌti rüdï Dïyäwüd, awa nga be ari a gwa ruji ngwüjü yiima ye ngwuru Garany aar elelle nono ma aar ru Ngwüyäwüd?” ");
INSERT INTO lro_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","Nyi je ci, “Alanga liru Ngwüyäwüd lïlïngïnä a läꞌtüdï ngwüjï ngwuru Garany ngwanni ngwuki anaku ati aar je gu ci. ");
INSERT INTO lro_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","A lïlïngïdï ndi ari dïjï dati ꞌti Ngwaalu dünïyälü ngwugeꞌtaji kuyala güngün ape gwe gwüngün gwudi dïmürä daru de yobo. Ngwube dünïyälü ꞌdogo ämnï gwe gwüngün ndi Yicu Kirictu. Alanga ꞌto lämnä ndi Yicu Kirictu, nunnu aar nje Ngwaalu dünïyälü ämnï gwe gwege ꞌdünggüngün. Yaꞌti gu rüdï aꞌtur ape gwe gwege gwudi dïmürä didi yobo. Ndi ari dïjï dere daꞌti da aar dünïyälü ape gwe dïmürä de yobo.” ");
INSERT INTO lro_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","Ngwari, “Ma be ari, a gilo ndi mïnï gay ndi ari awa aar dünälü ndi Kirictu, ya be ru nono alanga yigoꞌro yege liru ngwüjï ngwuki, utalu gwa be ji ndi ari Kirictu gwätädï kengo guꞌro? A be yaꞌti gu rüdï aꞌtur! ");
INSERT INTO lro_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","Manari nggwäꞌräjä yiꞌralalu yele yigatani nje mbüny, nggwadi inggidi ndi ari äny gwuru dïjï dïnyürtïjä yobanu. ");
INSERT INTO lro_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","Yobo ye äny gwayu gilingeno giyobo nunnu nyi mïdïjï Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","Änyängä lima pänï küꞌrï Kirictu gwe, äny gwaꞌti ba be ani ligoꞌro lüny, a be Kirictu ru nggwo ꞌdünggüny. Elelle gwüny gilingeno, gwelelleny ämnï gwe Kïjï gidi Ngwaalu ganni gämnïny ngwayi gwani äny. ");
INSERT INTO lro_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","Äny gwaꞌti geꞌtaja yïmïꞌrü yidi Ngwaalu gay geꞌte. (Nggwaꞌti ruja yïmïꞌrü yidi Ngwaalu ꞌtur). Ndi ari adinari a dünälü gwadi mbüjïnï ape gwe dïmürä didi yobo, yiꞌrany yidi Kirictu yaadi be ru ꞌtur!” ");
INSERT INTO lro_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","Ngaa gilee liru ngwïkïrïjïn ngwudi Galatiyang liru kïräm, guꞌriny giru ange gima je gwürlï yigor yalu ngaa be ru lanni lïlïngïdï anaku enggaca je gu gilingenalu ndi ari Yicu Kirictu gwayu küꞌrälä gwani nga nga! ");
INSERT INTO lro_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","Äny gwümïnä ndi lenge gony geꞌte pu ꞌdogo ꞌdanggalu. Ngwaalu ngwätädä je lïgïꞌrïmä nunnu ngaa lati ape dïmürä didi yobo yidi Ngwüyäwüd, gwalla nunnu ngaa lämnä ngwujaꞌri ngwanni ngwujaw ngwanni ngwuma je ꞌdingini? ");
INSERT INTO lro_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","Nga nga liru gu kïräm no? Ngaa lädäälü yiꞌral ye yanni yijaw yidi gay gidi gwuji Lïgïꞌrïmä lidi Ngwaalu. A be gweneno, yima je be mïnï ndi olatiyi yiima ye yalo? ");
INSERT INTO lro_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","Manari yiru gu no, yiꞌrendeny yalu yaꞌti be ya ru ꞌtur yanni yimbuja je gwani gwuji gwalu gay gidi yïkïrïjïne? Äny gwaru ꞌdidanu yiꞌrendeny yalu giyee yäꞌtüdï ꞌtur. ");
INSERT INTO lro_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","Anaku ätädär nje gu Ngwaalu Lïgïꞌrïmä lüngün ngwärrï yiima gidiliganu ꞌdanggalu yärrüng je nunnu ngaa lati ape dïmürä didi yobo? Nyi be ari nunnu yärrüng je gwani ämnï gwalu ngwujaꞌri ngwanni ngwujaw ngwuꞌdingina je? ");
INSERT INTO lro_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","Ïräjär ngwäyälü ndi Äbräyïm anaku aru gu gitab ndi ari, “Gwämnä Ngwaalu, a gu be Ngwaalu ïꞌräcï ngwuru dïjï dïdünälü.” ");
INSERT INTO lro_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","Lïngïdär be ndi ari yïjï yidi Äbräyïm yanni yiru ꞌdidanu, yiru ngwüjï ngwanni ngwämnä Ngwaalu nono Äbräyïmïng. ");
INSERT INTO lro_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","Yündäjïnä kitaban gwerre ndi ari Ngwaalu ngwaru ngwa ji ngwa dünïyï ngwüjälü ngwanni ngwuru Garany ämnï gwe Ngwaalu gwegen. Yiꞌral ye giyee, nginde gwuma mädïnïyä ngwujaꞌri ngwanni ngwujaw ndi Äbräyïm ngwuci, “Ngwüjï ꞌdar ngwa je Ngwaalu onjaci nga gwe.” ");
INSERT INTO lro_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","No lanni la ämnï Ngwaalu, la je Ngwaalu onjaci Äbräyïmïngä le gwanni gwuru dïjï dämnä Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","Ndi ari ꞌdar lanni lïgätädï lingina legen ndi gatada giyobo ngwäyänü, gilo lïꞌtäjäär je gu ngwünyü. Ndi ari yüllïnä yaru nu, “Gwüꞌtäjär gu ngwünyü gwere gwanni gwaꞌti mätïnälü ndi ärrï yiiru ꞌdar yanni yüllïnä kitabanu gidi Yobo!” ");
INSERT INTO lro_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","Yilinginna ndi ari dïjï dere daꞌti dïdünälü dïmürä de didi yobo ngwäyänü Ngwaalu. Ndi ari yüllïnä yaru nu, “Gwanni gwüdünälü gwa midi ämnï gwe Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","A be yobo yäꞌtüdï gidingo ndi ämnï Ngwaalu. Aar be manni ru ndi ari, “Dïjï danni dati ape dïmürä ndee, ding de midi.” ");
INSERT INTO lro_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","A be Kirictu gwüꞌrädïnjälü ndi ꞌtäjï ngwünyü gwudi yobo anni ma aar gu ꞌtäjï ngwünyü ngindeng gwuma ru ngwanni gwuma mandi ngwaalu ngwege. Anaku üllïnäär gu ndi ari, “Gwüꞌtäjär gu ngwünyü gwere gwanni gwa pänï küꞌrälä.” ");
INSERT INTO lro_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","Kirictu gwüꞌrädïnjälü nunnu onjaci gwanni gwuju gwele ndi Äbräyïm, a ngwüjï ngwuru Garany mbuji Yicu Kirictu gwe, nunnu ämnï gwe Ngwaalu, aar nje ätädä Lïgïꞌrïmä lanni larung le. ");
INSERT INTO lro_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","Ngwänggärï, dünär nga je mïꞌrïcï ngwujaꞌri ngwudi ngwüjï ngwümnä gïdïdlä, nono gwele manari gekajidi gwuma ji, dïjï dere daꞌti da äbräjï ngwujaꞌralu na ngwuje gu änïjï ngwere ngwuꞌter. Yiru gu no ꞌto ngwujaꞌri ngwee. ");
INSERT INTO lro_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","Ngwaalu ngwätädï Äbräyïmïng na gilinge güngün ngwujaꞌri. Gitab gaꞌti aru, “Na yilinge.” Yani ngwüjï ngwonyadu ngwube ari, “Na gilinge gunga.” Gani dïjï deꞌte pu, gwani Kirictu. ");
INSERT INTO lro_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","Ngwujaꞌri ngwadi nyi ngwe ari ngwuru ngwee ndi ari, yobo yanni yïgïꞌtïnälü gwodan ngwüdlä ngwïndï be ꞌdi aar ru küüꞌrï tudini kwoꞌrongo na ꞌdï täꞌrïl (430), yaꞌti ya pï gekajidinganu gwanni ngwugeꞌta Ngwaalu gwerre ngwugatu ngwujaꞌri mbüny ngwuca ngwe Ngwaalu Äbräyïmïng. ");
INSERT INTO lro_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","Ndi ari adinari a yuꞌrin ru yadi äpïnï gatada gwe ngwäyänü giyobo, ngwujaꞌri ngwaꞌta be ngwadi ji ngwaru ngwe Ngwaalu. A je be Ngwaalu ru yätädïng je Äbräyïmïng yïmïꞌrü ye yüngün ngwujaꞌri ngwe ngwaru ngwe. ");
INSERT INTO lro_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","Ma be ari yiru gu no, bupi gwudi yobo gwuru be ange? Yigeꞌtaar je yani nyurtanu gwudi ngwüjï nunnu aar ji ꞌdi a “Gilinge” ganni garaar ge ila, yïꞌrr yapu yiiru yidi yobo dirꞌdal de. ");
INSERT INTO lro_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","A be dirꞌdal dati ꞌti ju gidiliganu ngwuja gïdïjï deꞌte pu a be Ngwaalu ru ngwuru jücü. ");
INSERT INTO lro_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","A be ya gu ru ndi ari yobo yïnïjä ngwujaꞌri ngwaru ngwe Ngwalo? Bärï aꞌtur. Ndi ari adinari a yobo yanni yiju aar ätï yiima ndi midiyi ngwüjü, a laadi gu be ari ndi ari yadi gäbïcï ngwüjü aar dünälü. ");
INSERT INTO lro_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","A be gitab gondaja garu ngwüjï ꞌdar ngwugenna giyuꞌrung yidi ke nunnu yanni yaru ye gitab ya äpïnï ämnï gwe ndi Yicu Kirictu, aar ji ngwüjï ngwanni ngwa ämnï. ");
INSERT INTO lro_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","Gwerre gwerre ndi ämnï Ngwaalu nggwe ji, A liru ngwüjï ngwugekaja je yobalu, aar nje längïtäjï nunnu ꞌdi ämnï Ngwaalu ꞌtädälü. ");
INSERT INTO lro_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","No yobo yigeꞌtaar je aar nje ruyi aar nje ye remalu aar nje oktada ndi Kirictu nunnu aji a nje Ngwaalu dünïyälü ämnï gwe. ");
INSERT INTO lro_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","Gweneno, ämnï gwe Ngwaalu gwanni gwuma ji, a laꞌta be rüdï ngwïnäd ngwudi yobo ndi aar nje ruyi. ");
INSERT INTO lro_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","Nga nga ꞌdar gweneno, liru yïjï yidi Ngwaalu ämnï gwe ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","Ndi ari nga nga ꞌdar lanni lïnyïnyïnä Yicu gwe, ngaa lima genne Kirictung giyigoꞌro yalu. ");
INSERT INTO lro_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Yere yaꞌta be yani nggwee gwuru Dïyäwüd na nggwee gwuru Dïgïrïg, nggwee gwuru dïnäd na nggwee gwäꞌtüdï dïnäd, nggwee gwuru dur na nggwee gwuru daw, ndi ari nga nga ꞌdar liru leꞌte pu ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","Manari ngaa lima ru lidi Kirictu, ngaa lima be ru gilinge gidi Äbräyïm. Na ngaa la ape yuꞌrina anaku aru gu ngwujaꞌri ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","Äny gwümïnä ndi ari, ma gïjï runa gooko, gubidaar dïnäd de gaꞌti ga ape yuꞌrina anni yuꞌrin ru yüngün ku. ");
INSERT INTO lro_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","Gati dedere ꞌdïmïnï ngwola ꞌdi a gaji ila ganni gïgïꞌtïjä papa gwüngün ndi ari ngwümätïjï yuꞌrina ngwuru dur. ");
INSERT INTO lro_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Yiru gu no ꞌto ꞌdengge ndi ari Yobo ye, A liru ngwïnäd, a lïndï yobo ye yidi dïdlä. ");
INSERT INTO lro_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","A be anni ma gaji ila ganni garu ge Ngwaalu ngwumbuti, a be Ngwaalu ükäjä Gïjü güngün ngwülïngïnï gidaw nono dïjü dümnä giyobanu ");
INSERT INTO lro_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","ngwüꞌrä ngwüjälü ngwanni ngwüꞌdïmïnä je yobo ngwüjüꞌräcï nunnu aar ape guꞌru gidi yïjï gimbutu. ");
INSERT INTO lro_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Ndi ari ngaa liru yïjï yidi Ngwaalu, ngwuma ükäjä Lïgïꞌrïmä lidi Gïjï güngün giyigoranu yege, Lïgïꞌrïm lanni lurnidu, “Abba gwuru Papa.” ");
INSERT INTO lro_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","No, nga gwaꞌta be rüdï dïnäd, nga gwuma be ru gïjï. A anni ranga gïjï, Ngwaalu ngwum ang ruji duꞌrin ꞌto. ");
INSERT INTO lro_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","Gwerre anni aaꞌti aang lïngïdï Ngwaalinga, ngaa liru ngwïnäd ngwudi ngwong drü de ngwäꞌtüdï ngwaalu. ");
INSERT INTO lro_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","A be gweneno ndi ari ngaa lima lenge Ngwaalinga na ndi ari ngaa lima linginni Ngwaalu, giru be ange ndi oꞌraci drü damꞌratu diru yiwayi? Ngaa lïmïnä ndi oꞌraci yïnädä ngaa ru ngwïnäd mana? ");
INSERT INTO lro_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","Äny gwuꞌdingina ndi ari ngaa lati geꞌte yomon dïmürä, ngaa geꞌte ngwüüwäyü dïmürä na dïmürä didi ngwüdlä. ");
INSERT INTO lro_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","Yedeny giyo yïjïny ngang je! Ndi ari yiiru yüny ꞌdanggalanu, yiru nono yima geradalu. ");
INSERT INTO lro_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","Ngwänggärï, nggwa je päcälü, rüdär nono nyänyïng. Nyäny gwuma ru nono ngange je. Ngaa laꞌtiny ärrä yiꞌral yere yiki. ");
INSERT INTO lro_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","Ngaa lïngïdï ndi ari gaji ganni gondaca je ge ngwujaꞌri ngwudi Ngwaalu, nggwaꞌti mbuja lingina. ");
INSERT INTO lro_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","Anni ari amiꞌrati gwe gwüny gilingeno gwüꞌrïgädä je kaji nggoo, ngaa liminyi ꞌti ꞌdonyu, nyii be geꞌte nono minyi ru gïꞌrr güllü Ngwaalu. A ligeꞌteny nono miny ani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","Yiru ange yima ji ndi jayanu ꞌdar gwalu gwele! Nggwada je ci ndi ari, adinari yadi gu no, ngaa ladiny gwällïjä ngwäy ngwalu nje ätädä. ");
INSERT INTO lro_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","Äny gwuma be ru gweneno güwän galu ndi ari gwondaca a je ngwujaꞌri ngwanni ngwätï ngwäyäno? ");
INSERT INTO lro_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","Ngwüjï ngwoo ngwïtï je yigoranu ndi ara je apada kuy gegen, a be ngwujaꞌri ngwegen ngwaꞌti ätï ngwäyänü. Ngwümïnä ndi ara je ꞌtüyänü ꞌdänggärï ");
INSERT INTO lro_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","nunnu aar je yigor ïyïjï ngindeng je. Yijaw ndi ligor eny dïjänü aar be ru gwani büpïnï gwanni gwujaw na ndi gu ru giyomon ꞌdar aaꞌti nunnu ꞌdogo ma ji ma ar ji. ");
INSERT INTO lro_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","Lani yïjï yüny, yanni yima oꞌre yiminy iye yajimanu ꞌdi a yiꞌremna yidi Kirictu ji ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","Nggwüjädï gu gwulleny adinar ar ji gweneno aadiny gwürlï ondajing ngwujaꞌri ngwee ngwondaca je. Ndi ari ngwaalu ngwo ngwïndïny ngwälü giyiꞌral giyee yalu. ");
INSERT INTO lro_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","Ondaciny ꞌdi ngaa lanni lïmïnä ndi oꞌre giyoranu yidi yobo, ngaa laꞌti lïngïdï ngwujaꞌri ngwaru ngwe yobo? ");
INSERT INTO lro_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","Ndi ari yüllïnä yaru nu, Äbräyïm gwätï yïjü rom, geꞌte gidaw danni diru dïnäd a geꞌte gidaw didi ꞌdunung. ");
INSERT INTO lro_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","Gïjï güngün gidaw ndoo diru dïnäd gïlïngïtäär aꞌtur a be gïjï güngün nggoo gidaw ndoo didi ꞌdunung, gïlïngïtäär ngwujaꞌri ngwe ngwuca ngwe Ngwaalu Äbräyïmïng. ");
INSERT INTO lro_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","Yiꞌral giyee ya gïgïꞌtïnï no, ngwaw ngwee rom ngwuru nono gekajiding rom. Didi gwerreng dani Gen gani Jïnä ngwulengeta yïjü aar ru ngwïnäd, Ajar gwuru. ");
INSERT INTO lro_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","Ajar ngwürïny ngwuru ngwani Gen gani Jïnä ngwaalu ngwani Arabiya gwuru gwanijaar gündär gweneno gani Üräjälïm ndi ari nggo gïyïnädänü yïjï ye yüngün gwani gekajidi gwanni gwuꞌrin. ");
INSERT INTO lro_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","A be Üräjälïm gwanni nggwo kerala gwäꞌtüdï dïnäd a gwuru nanni gwege. ");
INSERT INTO lro_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","Ndi ari yüllïnä yaru nu, “Jayanu a gwanni gwuru gurrum, a gwanni gwaꞌti lïngïtï, mïꞌrïdï dula gwulleny ang ari a gwanni gwaꞌti yajima ïtänü. Ndi ari daw danni düꞌdünyïdärälü, yïjï yüngün yonyadana gïyïjï yidi daw danni dätï duru!” ");
INSERT INTO lro_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","Lani ngwänggärï ngaa gweneno, liru nono Ijaaging, ngaa ru yïjï ngwujaꞌri ngwaru ngwe Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","Kaji nggone gwerre, gïjï ganni gïlïngïtäär aꞌtur gübïnä gïjälü ganni gïlïngïnä yiima ye yidi lïgïꞌrïm. Giyo yïndï gu no gweneno. ");
INSERT INTO lro_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","A be gitab garaa? Garu nu, “linynya dayu ndoo diru dïnäd gïjï ge güngün, ndi ari gïjï gidaw ndoo diru dïnäd, gaꞌti ga aar emadi gïjï ge gidi daw ndo didi ꞌdunung giyuꞌrinanu aꞌtur.” ");
INSERT INTO lro_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","Yäy gu no lani ngwänggärï, a läꞌtüdï yïjï yidi nanni gwudi yïnäd, ar be ru yïjï yidi nanni gwudi ꞌdunung. ");
INSERT INTO lro_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Kirictu gwuminje gwäꞌdälü gïyïnädänü ndi ari aar gätïnï linginalu. Mätïnär bälü ꞌdïꞌdäny aaꞌti ngaa la änïjï yigoꞌro yalu mana giyunggu yidi yïnäd. ");
INSERT INTO lro_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","Äny gwuru nggwee gwani Bulij, geꞌtar ngwujaꞌri ngwee ngwäy nono ngwondaca je ndi ari manari ngaa lima ci yigoꞌro yalu ngaa üꞌrïdänï, ngaa laꞌti lätï guꞌru gere aꞌtur giyiꞌral yanni yärrä je Kirictu. ");
INSERT INTO lro_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","Nggwa je ci mana ndi ari, dïjï danni da gäbïcï ligoꞌro lüngün ngwüꞌrïdänï gilingeno, dämjü giligoꞌro lüngün ndi ꞌdengenaci dïmürä didi yobalu pipiꞌriꞌti. ");
INSERT INTO lro_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Ngaa lanni lïmïnä ndi aang dünälü yobo ye, ngaa lima ꞌtüyï yigoꞌro yalu ndi Kirictu kulu poor. Ngaa lima oꞌre yïmïꞌrü yüngün kay. ");
INSERT INTO lro_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Nggwadi ari ämnï gwe gwege Ngwaalu, alanga lïgïꞌrïm le gilo lïdünïcä dünïngälü gwanni gwugeꞌtajar gu yigor ye yïtï nje. ");
INSERT INTO lro_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","Ndi Yicu Kirictu, nga üꞌrïdänï nga ꞌti üꞌrïdänä, guꞌru gere gaꞌti. A be ämnï Ngwaalu ru gwapu yiiru ämnäjïdï gwe. ");
INSERT INTO lro_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","Ngaa liju ndi dokati dokating gwanni gwujaw gwuru be ange gwuma je millici kay ara je ümnïcï ndi aang ꞌdengenaci ngwujaꞌri ngwanni ngwuru ꞌdidanu? ");
INSERT INTO lro_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Dudi gwuru nggwee, gwaꞌti ïndï nginde gwanni ngwurnida je! ");
INSERT INTO lro_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","Ngwujaꞌri ngwaru, “Ngwüꞌrüd ngwooko ngwülänü, ngwati gwürlï ngwülälü ꞌdar aar uuli” (yiꞌral yoko, yati bälï ngwüjü). ");
INSERT INTO lro_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","Nyi be ïcïnänü giloranu Gideleny ndi ari ngaa laꞌti la gwurla ngwujaꞌri ngwuꞌter. Nginde gwanni gwänïjä je ngwujaꞌranu ngwee, gwa ngwujaꞌri mbuji, gwuru dïjï dipa gwalla gwuru dïjïj doko. ");
INSERT INTO lro_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","Ngwänggärï, manari yätï ngwäyänü ndi ari äny nggwona ndi urnidi ngwüjü aar üꞌrïꞌtänï, aar nyi mine ïnïjï gwedang. Yaꞌti be yadi äbrïnï kay yanni yiru obalu ꞌdenggen gwani Yicu küꞌräla? ");
INSERT INTO lro_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","A be lanni gilo länïjä je ngwujaꞌranu ngwee, nggwäjädï adinari aar je olatiyi aar üꞌrïꞌtä ngwanginalu ngwegen! ");
INSERT INTO lro_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Ngwänggärï, lurnida je ndi gätïnï linginalu a be aaꞌti ngaa la gu rtadanu ngaa elelle yiꞌral le yidi drü danni diki. Ngaa be ru ladi ämnäjïdï ngaa gatajidi düwä giyiiru. ");
INSERT INTO lro_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","Yobo ꞌdar yätï ngwujaꞌranu ngweꞌte pu ndi ari, “Nga ämnï gwanggalu nono ata gu ämnï ligoꞌro lunga.” ");
INSERT INTO lro_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","Ma be ari ngaa gilo ndi iyidi aang arri nono ngwängä, arnganar be ndi ari aaꞌti ngaa la gu arri ꞌdi ngaa la girradi! ");
INSERT INTO lro_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Nyi be ari, elellar Lïgïꞌrïm le ngaa laꞌta be la ärrï yiꞌral yani amiꞌra gwudi drü danni diki. ");
INSERT INTO lro_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Ndi ari drü danni diki, dati yiꞌral amiꞌranu yanni yübïnä lïgïꞌrïmälü a lïgïꞌrïm lati bupi yiꞌral yanni yübïnä drälü danni diki a giyee ꞌdün yati kwudi ꞌdi aji nga je ärrï yanni yaꞌti je mïnä ndi ärrï. ");
INSERT INTO lro_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Ma be ari Lïgïꞌrïm gilo lüktä je, ngaa laꞌti ba be giyobo. ");
INSERT INTO lro_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","A lïlïngïdï apepeng gwudi drü danni diki gwulinginna gilingenalu gwani yïjïn, rngï, acidi gwudi yidigany na ");
INSERT INTO lro_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","yobo yidi dïdülä yani yuꞌriny yani kajidi ngwäy, yani kadi, yani ïyïnï giligor, güündä, gwällïnï giyur, üꞌrïꞌtïdïnänü, apada giyur, ");
INSERT INTO lro_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","yani yüꞌdüny, yani rlälï, yani yütä na yere yiꞌter yanni yiru gu no. Nggwa je ci anaku ca gu gwerre arnganar ndi ari lanni lati ärrï yiꞌral yanni yiru gu no, laꞌti la mbuji yuꞌrina yidi yeleny yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","A be yuula yidi Lïgïꞌrïm yiru yani, ämnï, jayanu, adatalu, määtä liguri, jayi liguri, jayi, ru ligor leꞌte pu, ");
INSERT INTO lro_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","jïlänü na määtä lingina. Yobo yere yaꞌti yati etaci yiꞌral yanni yiru gu no. ");
INSERT INTO lro_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","A be lanni lima ru ngwüjï ngwudi Yicu Kirictu, lima pä drü degen danni diki küꞌrälä yamil yanu na amiꞌra gwanu. ");
INSERT INTO lro_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Manari a gilo limidu Lïgïꞌrïm le, ar be elelle ꞌto Lïgïꞌrïm le. ");
INSERT INTO lro_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","Aaꞌti a la piyi yigoꞌro yege gwani näjï gwuru ꞌtur, ar gwogajidi ar apajidi yüꞌdünyü! ");
INSERT INTO lro_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Lani ngwänggärï, manari gwere ꞌdanggalanu gwuma ïꞌdï giyiꞌralanu yanni yiki, nga nga lanni liru ngwüjï ngwudi lïgïꞌrïm, gwäꞌrär kayalu gidi dünälü yiꞌral ye yidi lïgïꞌrïm na jïlï gwe liguri. A be arngani yigoꞌro yalu ꞌto ndi ari ya je ïdäjï. ");
INSERT INTO lro_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Gatajidar düwä gwüpäng ndi üpïnï gwalu gwanni gwünï. A gu no, ngaa la ꞌdengenaji Kirictung ngwujaꞌri ngwüngün. ");
INSERT INTO lro_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","Manari gwere nggwo gwupiya ligoꞌro lüngün ngwuci gwani yärü nggwuꞌti be rüdï, gwuru diꞌduru giligoꞌro lüngün. ");
INSERT INTO lro_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Ati dïjï deꞌte deꞌte ombaji ligoꞌro lüngün ndi ari nggwo gwapupu awa. Ya be ji yanni yading ye ïrïngïnï ligoꞌro lüngün jücü. Yaꞌti ya ang ye ïrngïnï yidi dïjï diꞌter. ");
INSERT INTO lro_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","Ndi ari dïjï deꞌte deꞌte diru dadi üpïnï üpïnïng gwudi ligoꞌro lüngün. ");
INSERT INTO lro_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Lanni lati aar je enggaci ngwujaꞌri ngwudi Ngwaalu, aar emadi ngindenga le lanni lati je enggaci giyiꞌral ꞌdar yanni yijaw. ");
INSERT INTO lro_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","Aꞌti ngaa lïdäjï yigoꞌranu yalu. Lïngïdär ndi ari Ngwaalu ngwati ꞌti ärrïnä yïdäpängä. Yanni yati je dïjï ärrï, yating je mbuji ꞌto. ");
INSERT INTO lro_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Nginde gwanni gwati arrada gïdrü danni diki, yanni yiki ya gerajalu. A be nginde gwanni gwati arrada gïlïgïꞌrïm, gïlïgïꞌrïm gwa mbuji miding gwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Aaꞌti a la muli nono ndi ärrï yiꞌral yanni yijaw, ndi ari gomon ga ji gila ganni gigeꞌta Ngwaalu, ya je mbuji yanni yijaw manari a lima ꞌti mulu nono. ");
INSERT INTO lro_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Yäy gu no, anni jina gomon, ar je be ärrïjï ngwüjü ꞌdar yanni yijaw. Ar je gu ärrïjï gwece gwece lanni liru ngwïkïrïjïn. ");
INSERT INTO lro_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","Änggädär yuuli giyee par gu ngwäyänü yanni yüllïjä je ye guy ge güny! ");
INSERT INTO lro_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","Yiru gu ndi ari lanni lïmïnä ndi aar jayi ngwüjü ngwäy, liru limbupa je ndi aang üꞌrïtänï yiima ye. Yanni yïgäbïcä ngindeng je aru gu be arri no, yiru ndi ari aaꞌti la aar je übïnälü gwani güꞌrï gimamindanu gidi Kirictu. ");
INSERT INTO lro_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","Ndi ari ꞌdi lanni laru lüꞌrïtänä, ngindenga yigoꞌro yegen lati ꞌti ꞌdengenaca yobo, ara je be bupi ngang je ndi aang üꞌrïꞌtänï nunnu ara je gu ïrïngïnädä. ");
INSERT INTO lro_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","A be Äny gwaꞌti ïrïngïnädä kong gere aꞌtur ꞌdogo küꞌrï gimamindanu gidi Deleny dege dani Yicu Kirictu, ndi ari nginde gwe nggwänggädï dïdläyü ꞌdüngüny dïpänä küꞌrï a nyi pänï küꞌrï ngwäyänü ngwudi dïdlä. ");
INSERT INTO lro_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","Ngaa üꞌrïdänï ngaa ꞌti üꞌrïdänä, yäꞌtüdï guꞌru, yanni yiru guꞌru, yani gïꞌtïnï gwanni gwuyang. ");
INSERT INTO lro_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","A adatalu na ïnä ji ngwüjï ꞌdar ngwanni ngwelella dïmürä de ndee, ꞌdi ꞌto Yïjïräyïl yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","Ndi mïꞌrä, nggwaru nggwaꞌta be mïnä dïjü dere ndi aar nyi äbïngïnänü mana dïrbä de, ndi ari ngwanginu ngwüny ngwo ngwätï yubuꞌru nono yani Yicu. ");
INSERT INTO lro_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","Ngwänggärï, a yïmïꞌrü yidi Deleny dege dani Yicu Kirictu ji gïlïgïꞌrïm lalu. Yiru gu.");
INSERT INTO lro_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Äny gwuru gwani Bulij, gwuru dooꞌra dükäjäär didi Yicu Kirictu anaku bupa gu Ngwaalu. Nggwuru gwükäjä ngwujaꞌri ngwee. Ngwükäcä je ngwüjü ngwanni ngwujuꞌru ngwudi giꞌdoonga gidi Ngwaalu kündär gidi Abijujing lanni lämnä ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Ara je Ngwaalu ngwani ngwuru Papa gwege na Deleny dani Yicu Kirictu, ätä yïmïꞌrä ara je ätä adatingalu. ");
INSERT INTO lro_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Ar näjï Ngwaalinga ngwanni ngwuru Papa gwudi Deleny dege dani Yicu Kirictu, gwanni gwuminje onjaci giyiꞌralalu ꞌdar yidi lïgïꞌrïm lidi yeleny yidi gerala, ji gwe gwege ndi Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Ndi ari nginde gwäbrü nje ar nje gïlängïdïyï Kirictu gwe ꞌtuꞌtu gwerre anni aaꞌting na geꞌte dïdläyü nunnu aar nje juꞌriyi ar jayi nono ngwäyänü ngwüngün. Ämnï gwe gwüngün, ");
INSERT INTO lro_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","nginde gwügïꞌtïnï nje ndi ari aar nje aniji yïjï yüngün Yicu Kirictu gwe. Jada gwe na bupi gwe gwüngün. ");
INSERT INTO lro_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","Ndi ari ar ortada näjï gwe gïyïmïꞌrü yüngün, yanni yätädäär nje aꞌtur ndi Yicu gwanni gwämnïng. ");
INSERT INTO lro_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Nginde gwüꞌrädï njälü yïn ye yüngün, yiꞌrany ye yüngün ndi ari aar nje Ngwaalu düdänïjänü ndi ke gwege ïrälü gwe gwudi yïmïꞌrü yüngün. ");
INSERT INTO lro_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","Yanni yïbäläjäär nje nono bebere gwe ꞌdar na lenge. ");
INSERT INTO lro_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","A nginde gwuru Ngwaalu gwuminje ꞌtäcï yujimidalu yidi bupi gwüngün anaku geꞌteng gu gwerre ndi bupi gwüngün gwanni gwujaw ndi Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","Nunnu aar gïꞌtïnï giyiiru ma gaji ila ganni gegeꞌta Ngwaalu ngwumedadi ndi ari ganni gading ge gwägïꞌrïꞌtä ngwony ꞌdar kerala na gïdïyängälü Gideleny deꞌte pu dani Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Nginde gwe, alanga lanni liru Ngwüyäwüd liru ngwïkïrïjïn, a lima ape guꞌru ꞌdünggüngün ꞌto anni ma aar nje äbrï anaku gegeꞌteng gu yiꞌral, gwanni gwati geꞌte yiꞌral ꞌdar anaku buping gwüngün gwanni gwümïnïng. ");
INSERT INTO lro_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Ndi ari nunnu alanga lanni limadinana ar ätï dünïcïng ndi Kirictu ndi ari ar ru lanni ladi ortada näjïng gwüngün. ");
INSERT INTO lro_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","Na nga nga ꞌto lanni liru Garany, lima ru ngwüjï ngwudi Ngwaalu kaji ganni gima ge ꞌdingini ngwujaꞌri ngwanni ngwuru ꞌdidanu. Ngwujaꞌri ngwanni ngwujaw ngwudi gilang gwalu. Anni ma aang ämnï ndi Yicu, lima je ngïdä ꞌdünggüngün dilge de diru lïgïꞌrïm lanni lijuꞌru laru le Ngwaalu ");
INSERT INTO lro_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","lïgïꞌrïm gilee lani änïjälü gwüngün ꞌdengge gwudi yuꞌrin yege yanni yadi ar je mbuji komon ganni gadi ge Ngwaalu üꞌrä ngwüjälü ngwüngün pupud aar ortada näjïïng gwüngün. ");
INSERT INTO lro_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Yäy gu nu ꞌto nggwuꞌdingina ngwüjï ämnï gwe gwalu Gideleny dani Yicu na ämnï gwe gwalu ngwüjü ꞌdar ngwanni ngwujuꞌru ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","Yiru giyee yanni yïgäbïcïny ati nyi ꞌti dünädï ndi ci Ngwaalinga yäy ꞌtu gwani nga nga, nda je angidani ndi otaci Ngwaalingalu gwüny. ");
INSERT INTO lro_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","Äny gwati otaci Ngwaalingalu gwudi Deleny dege dani Yicu Kirictu, papa gwanni gwätï näjïng, ara je ätädä lïgïꞌrïmä lidi bebere na lidi ꞌtäälü, nunnu nga lengedani ngindeng. ");
INSERT INTO lro_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","Äny gwotaca Ngwaalingalu ꞌto ndi ari ara je orꞌraci ngwäy ngwudi yigor yalu nunnu nga lenge geꞌtajing gwanni gwornacara je, ïrälü gwudi näjï gwudi yuꞌrin yüngün ngwüjï ngwanni ngwujuꞌru ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","A yiima yüngün yanni yipana, yaꞌti ätï guꞌranu ꞌdengge lanni lämnä ꞌdünggün. ");
INSERT INTO lro_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","Yiima giyee yiru nono yiima yüngün yanni yapu yiiru yani ojeme nono yanni yigeꞌteng je ndi Yicu Kirictu anni mung ꞌdïꞌrïyä giyiꞌranyanu ngwugeꞌtalu kaama güngün giyelenyanu yidi gerala. ");
INSERT INTO lro_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","Yipana giyartan ꞌdar na giyeleny ꞌdar giyiima ꞌdar na giyurꞌtu na ngwürïny ngwudi yeleny yere ꞌdar, aaꞌti nu gïdïdlä ꞌdogo, a be ꞌto gïdïdlä ndäꞌdï dadi oꞌra. ");
INSERT INTO lro_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","A Ngwaalu ngwuma geꞌte yiꞌral ꞌdar giyoranu yüngün ngwümätï yelenya nunnu ngwuru giꞌra gidi yiꞌral ꞌdar yidi giꞌdoonga gidi Ngwaalu ");
INSERT INTO lro_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","ganni giru ngwanginu ngwüngün mbuti gwüngün, nginde gwanni gwati onjaji yiꞌral ꞌdar ngway ngwe ꞌdar. ");
INSERT INTO lro_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","A be nga nga gwele gwerre, ngaa liru ngwüjï ngwayu gïlïgïꞌrïm gwani nyurtanu gwalu a gwani yiꞌral yalu yanni yiki. ");
INSERT INTO lro_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","Yanni yata gu elellanu gaji ganni gija ge ndi gwuji gay gidi ngwüjï ngwudi dïdlä. Ngaa gwuji dijegoꞌro danni diru deleny didi ngwüꞌrïllä ngwudi dirun. Lïgïꞌrïm lanni gilo ndi ape yelenya ngwüjänü ngwanni ngwunyurtanu. ");
INSERT INTO lro_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","ꞌDidanu alanga ꞌdar lelella gu giyiꞌralanu yanni yiki. Gaji gijar ge ndi gwuji drü danni diki. Ati ar gwüjïnï amiꞌrang gwudi lingeno a bupi gwudi yigor yege. Nono ngwüjü ngwudi dïdlä lingeno le, a liru ngwüjü ngwïꞌdädï je güündä nono gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","5","A be anaku ïnädär gu Ngwaalinga gwulleny na ndi ari ïnä gwüngün ꞌdengge gwïrälü na ndi ari ämnï gwanni gwämnäär nje gwe gwulleny, gwuminje midiyi Kirictung le a lanni liru ngwüjï ngwayu gwele gïlïgïꞌrïm gwani nyurtanu gwege. Yïmïꞌrü ye yidi Ngwaalu, ngaa lima gïlängïdïnï. ");
INSERT INTO lro_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","A Ngwaalu ngwuminje ꞌdïꞌrïyï Kirictunga le gwuma aar nje le geꞌtalu kerala ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","Nunnu ngwinggidi ngwüdlä ꞌdar ngwanni ngwïndï, ïrälü gwudi yïmïꞌrü yüngün yanni yiralu ꞌter yipana. Yanni yinggiding je gïyïmïꞌrü yüngün ꞌdengge ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Ndi ari yiru yïmïꞌrü ye yidi Ngwaalu, ngaa lima gïlängïdïnï ämnï gwe gwalu ndi Yicu. A yaꞌti ani yigoꞌro ye yalu, aar be ani angidaji gwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Yaꞌti ani yiiru nunnu aaꞌti dïjï dere da ïrïngïnï. ");
INSERT INTO lro_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Ndi ari alanga, Ngwaalu gwuru ngwugeꞌte nje guy ge ndi Yicu Kirictu. Nunnu ar ärrï yiiru yanni yijaw, yanni yïgïꞌtïjäär nje Ngwaalu ꞌtuꞌtu gwerre nunnu ar je ärrï. ");
INSERT INTO lro_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Diwayinar be ndi ari gwele gwerre, nga nga gilee liru Garany lica je Ngwüyäwüd laꞌti üꞌrïꞌtänä, Ngwüyäwüd ngwanni ngwati ci yigoꞌro yegen lüꞌrïꞌtänä ndi inggidi ndi ari ngwäbrä je Ngwaalu. A be nggwadi ari, üꞌrïꞌtänï nggwee, gwäpïnä ngwanginu guy ge gidi dïjï dümnä. ");
INSERT INTO lro_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Diwayinar ndi ari kaji nggone, ngaa lüꞌrïdänü Kirictunga le ngaa ru Garany ngwüjänü ngwudi ꞌdunung ngwani Yïjïräyïl. Ngaa ru ngwïrnü ndi gekajidi gwudi Ngwaalu ngwujaꞌri ngwudi Ngwaalu ngwanni ngwucu ngwe ngwügürnä ngwudi Ngwüyäwüd ngaa ꞌti ätï geꞌtajingalu gwere. Ngaa ꞌti ätï Ngwaalinga gïdïdlä. ");
INSERT INTO lro_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","A be gweneno ndi Yicu Kirictu, ngaa lanni lïꞌtüdänü gwele Ngwaalu, lima je gwäꞌrä gito gito Ngwaalu yïn ye yidi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","Ndi ari nginde gwani Kirictu, gwuru adatalu gwege. Gwanni liming je gäbïcï lele rom lima ru leꞌte pu. Gwanni gwuma äbrï dirgaka kay danni düꞌrïdäjänü dani kajidi ngwäy, ");
INSERT INTO lro_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","yiꞌrany ye yüngün. Nginde gwuma äbrï yobo ngwujaꞌri ngwanu ngwüngün na dïmürä na drü yïn ye yüngün nunnu ngwuje ꞌtüyï gilee rom giligoꞌro lüngün aar ru leꞌte pu liyang ngwugeꞌte yiꞌral aar adatalu. ");
INSERT INTO lro_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","A nunnu ngwuje gwäꞌräjïdï gilee rom ngwanginu ngweꞌte pu Ngwaalinga le yiꞌrany ye yüngün küꞌrälä yani kajidi ngwäy gwegen, gilee ꞌdün liru Ngwüyäwüd na lani liru Garany. ");
INSERT INTO lro_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Yicu gwïndädï ndi ara je ondaci ngwujaꞌri ngwanni ngwujaw ngwani adajidalu ꞌdanggalu lele lïꞌtüdänü gwulleny Ngwaalu na ngwani adajidalu ngindenga lele liju gito gito ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Yiru ndi ari Yicu gwe, alanga gwüpäng lanni liru Ngwüyäwüd na lanni liru Garany, a la burni ndi ꞌdongga ndi papa lïgïꞌrïm le leꞌte pu. ");
INSERT INTO lro_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Yäy gu no, ngaa laꞌta be rüdï Garany ngaa ru ngwïrnü, ngaa be ru ngwüjï ngwudi ꞌdunung ngwüjïngä le ngwudi Ngwaalu ngwanni ngwujuꞌru lidi längïr lidi ngwuꞌdun ngwudi Ngwaalu ngweꞌte pu ");
INSERT INTO lro_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","ngwodana kidingala ganni gegeꞌta ngwooꞌra ngwükäjäär je na ngwïjïr a Yicu Kirictu ru goꞌrr ganni giru gidingo ganni giru giꞌra güngün. ");
INSERT INTO lro_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","Nginde, gwümätïnä gu ngwuꞌdun ku gwüpäng ꞌdar aar odani aar ꞌtänü aar ru gobo ganni gijuꞌru Gideleny. ");
INSERT INTO lro_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","Acajidi gwe gwalu ndi Yicu ꞌto, lima je gekajidi gwüpäng ngaa lima ru nono ngwuꞌdun ngwanni gwati gu Ngwaalu ji lïgïꞌrïm le lüngün. ");
INSERT INTO lro_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Yiru giyee yanni yïgäbïcïny nyi be genne giyirna gwani Bulij ondaji gwe ngwürïny ngwudi Yicu Kirictu gwani nga nga liru Garany. ");
INSERT INTO lro_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Anaku ꞌdingina gu yiiru ye yidi yïmïꞌrü yidi Ngwaalu yanni yätädäär nje yani nga nga. ");
INSERT INTO lro_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Ndi ari yiru yujimid yanggacaar nje ꞌtäälü gwe anaku ca je gu gwerre gwoko ngwujaꞌri ngwanni ngwuminje ulli. ");
INSERT INTO lro_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","Ma aang uli ngwujaꞌri ngwee, nga la be burni ndi lenge lengeng gwüny gwani yujimid yidi Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Yanni yaꞌti je Ngwaalu enggaca ngwüjü ngwudi gimaad ganni gimadinana anaku mung je gu enggaci lüngün gweneno lanni liru ngwooꞌra ngwükäjäär je na ngwïjïr ngwüngün lïgïꞌrïm le lüngün lanni Lijuꞌru. ");
INSERT INTO lro_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Yujimid giyee yiru ndi ari ngwujaꞌri ngwe ngwanni ngwujaw, lanni liru Garany gwele lima be emadi ngwüjï ngwe ngwudi Yïjïräyïl gwüpäng giyuꞌrinanu, lima ru ngwüjï ngwudi ngwanginu ngweꞌte pu lima ätï acajiding gwüpäng giyiꞌralanu yanni yaru ye Ngwaalu yani gilang ndi Yicu Kirictu ngwujaꞌri ngwe ngwanni ngwujaw. ");
INSERT INTO lro_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","Ngwuru ngwanni ngwuruci nje dïnäd yïmïꞌrü ye yidi Ngwaalu yanni yangidacaar nje yiiru ye yidi yiima yüngün. ");
INSERT INTO lro_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Äny gwanni gwuru guꞌru gooko ngwüjänü ꞌdar ngwudi Ngwaalu ngwanni ngwujuꞌru. Yïmïꞌrü giyee yätädär nje Ngwaalu ndi ari nyi ondaci ngwüjü ngwanni ngwuru Garany ngwujaꞌri ngwudi Kirictu ngwani ïrälü gwudi yeleny yüngün yanni yaꞌti amiꞌratu. ");
INSERT INTO lro_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","A ndi enggaci ngwüjälü gilingenalu ꞌdar ndi ari, gegeꞌte gwudi yujimid giyee yanni yaꞌti je Ngwaalu ngwanni ngwugeꞌta ngwony ꞌdar, ꞌtäcälü ngwüdlä ngwe ꞌdar ngwee ngwuma ele. ");
INSERT INTO lro_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","Ngwaalu ngwümïnä ndi ari gweneno giꞌdoonga ge güngün, a bebere gwani Ngwaalu giyiꞌral giyirel a je ngweleny na yiima yidi gerala lenge ");
INSERT INTO lro_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","anaku buping gwüngün gwudi gwurꞌtaling gwanni gwuming geꞌte ndi Deleny dege dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","Ndi ari nginde gwe a ämnï gwe ꞌdünggüngün, a la gätïnï linginalu, yedeny yaꞌti yinje eny aar ꞌranu ndi ꞌdongga Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","No, a je be otacalu ndi ari aaꞌti ngaa la muli nono la gwalli ngwäy gwani dïrbä düny. Yiru yani näjï gwalu. ");
INSERT INTO lro_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Yiru giyee yanni yïgäbïcïny nyi be kwuci Papangalu yirku ye. ");
INSERT INTO lro_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","Gwanni gwuru Papa gwudi ngwüjï ꞌdar kerala na gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Nggwotaca Ngwaalingalu ndi näjï gwüngün gwanni gwïrälü, ara je ojemeye nono yiima ye yidi lïgïꞌrïm lüngün giyigoranu yalu. ");
INSERT INTO lro_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","Nunnu a Kirictu ji giyigoranu yalu ämnï gwe gwalu ꞌdünggüngün. A nggwotaca Ngwaalingalu ndi ari ngaa dïrnïnälü ngaa mätïnälü ndi ämnäjïdï ");
INSERT INTO lro_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","ngaa mbuji yiima gwüpäng ngwüjïngä le ꞌdar ngwudi Ngwaalu ngwanni ngwujuꞌru. Ngaa lenge ndi ari ämnï gwudi Yicu gwongranu, ngwolalu, ngwolala na ngwolanu. ");
INSERT INTO lro_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","A ngaa lenge ndi ari ämnï nggwee gwudi Kirictu, gwuru gwanni gwitana bebereng gwudi ngwüjï ꞌdar nunnu ngaa mbuti giyiꞌral ꞌdar ndi mbütïyï gwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Gwenene ꞌdünggüngün, gwanni gwätï yiima ndi ärrï yiꞌral yanni yipana guꞌru giyiꞌral yanni yati ar ye otacalu ar gu jada. Yiima ye yüngün yanni giyo yapu yiiru ꞌdengganu. ");
INSERT INTO lro_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","A Ngwaalu näjïnï kiꞌdoonga güngün ndi Yicu Kirictu kimaad ꞌdar yomonalu pipiꞌriꞌti! Yiru gu. ");
INSERT INTO lro_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","Yäy gu no, nggwa je päcälü äny gwani Bulij gwanni nggwo gwugenna giyirna yani äpïjï Yicu Kirictung yiiru, elellar elelleng gwanni gwädï ndi urnidi gwanni gwurnacaara je Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","Ülläränü ngaa ru looko giyomonalu ꞌdar ngaa ru ngwumulu, ngaa määtä yiguri ngaa orꞌtemajidi ämnäjïdï gwe. ");
INSERT INTO lro_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Jar ꞌdïꞌdäny ndi määtädä gekajiding gwudi Lïgïꞌrïm gekajidi gwe gwudi adatalu. ");
INSERT INTO lro_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Ngaa ru ngwüjï ngwanginu ngweꞌte pu na gïlïgïꞌrïm leꞌte pu anaku urnidara je gu ndi geꞌtaji gweꞌte pu. ");
INSERT INTO lro_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","A lätï Deleny deꞌte pu, a ämnï Ngwaalu gweꞌte pu a ndi nyïnyïnï gweꞌte pu. ");
INSERT INTO lro_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Ar ätï Ngwaalinga ngweꞌte pu ngwuru Papa gwudi ngwüjï ꞌdar. Gwanni gwïllädälü ꞌdar, ngwape yiiru giyiꞌral ꞌdar ngwuji giyiꞌralanu ꞌdar ngwuji ꞌdengganu ꞌdar. ");
INSERT INTO lro_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","A be alanga ꞌdar liminje adaci yïmïꞌrä. A dïjï deꞌte deꞌte dapu guꞌru güngün anaku mïnä gu Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Yiru giyee yanni yaru ye gitab ganni guꞌrin gidi Ngwaalu ndi ari, “Anni mung ꞌdïꞌrï ngwallu kerala gwudamu, gwuma oktani ngwüjü ngwanni ngwuju giyirna, (gwerre) ngwangidaci ngwüjü yiiru.” ");
INSERT INTO lro_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","Yiru ange yani, “Anni mung ꞌdïꞌrï ngwallu.” Yani ndi ari nginde ꞌto gwuru gwanni gwüllü kerala gwerre gwerre ngwüllädä gïdïyängälü gali ge. ");
INSERT INTO lro_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","No nginde gwanni gwüllü, gwuru gweꞌte gweꞌte gwanni gwuma ꞌdïꞌrï ngwallu ngwandadala giyerala ꞌdar nunnu ngwümbütï ngwaalingalu ꞌdar ji gwe gwüngün. ");
INSERT INTO lro_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","Nginde gwuru gwanni gwati je adaci loko aar ru ngwooꞌra ngwükäjäär je a loko aar ru ngwïjïr a loko aar ru lanni lati ondaci ngwüjü ngwujaꞌri ngwanni ngwujaw, a loko aar ru ngwooꞌra na ngwoorta ");
INSERT INTO lro_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","ndi ari aar jaꞌrimada ngwüjü ngwudi Ngwaalu ndi ape yiiru, nunnu a ngwanginu ngwudi ngwïkïrïjïn ngwanni ngwuru ngwanginu ngwudi Kirictu odanalu ndom ");
INSERT INTO lro_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","ꞌdi alanga ꞌdar ar ru leꞌte pu ndi gekajidi ngwaalu ngwani ämnï Ngwaalu a ngwaalu ngwani bebere gwani Gïjï gidi Ngwaalu ar ru ngwüjï ngwupa gwani bebere. Ar ru ngwüjï ngwumbutu ar mbuti kay ꞌdar ar ru nono Kirictung. ");
INSERT INTO lro_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","A laꞌta be larri yogonga nono yïjï yanni yooko. Yanni yiru nono yanya na ngwuꞌrakar ngwadi je dirun ape aar je gatada gweere ya gwodan aar je ïdäjänü ngwujaꞌri ngwe ngwudi ngwüjï ngwanni ngwuru ꞌtur aar je dudiyi. ");
INSERT INTO lro_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Ma be ari a lïmätïnälü ngwujaꞌri ngwanni ngwuru ꞌdidanu, ämnäjïdï gwe, a la be pe ngwujaꞌri ꞌdar ꞌdi a la ru nono Kirictung gwanni gwuru giꞌra. ");
INSERT INTO lro_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","ꞌDünggüngün gwanni mätïnädï gu ngwanginu ꞌdar gwüpäng. Ndi ari aar degeꞌdajidi gwüpäng ꞌdar aar apajidi yiiru. Nunnu a ngwanginu odani aar pe ämnäjïdï gwe. ");
INSERT INTO lro_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","Äny gwa je ondaci ngwujaꞌri ngwee ngwäyänü nga je päcälü Gideleny ndi ari aaꞌti ngaa la ji ndi elelle nono ngwüjü ngwuru Garany ndi ari ngindenga lati ïräjï ngwäyälü giyiꞌral yanni yaꞌti ätï ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","Ngindenga gilo gïdïrïmänü lima je dïrïm rïmïyï yigor ndi aar lenge ngwujaꞌri ngwanni ngwätï ngwäyänü. Ngindenga lima ru ngwuꞌdunggal ngwujaꞌri ngwudi midi gwudi Ngwaalu aar ꞌti lïngïdï elelleng gwani Ngwaalu gwani undi giyiꞌra yegen. ");
INSERT INTO lro_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Ngwüjï ngwee ngwati je ꞌti ba be yaaru apu ndi ari ngwuma gu äbräjï ndi elalu mbüny giyiꞌral yanni yiki lima ätädä lingina legen gay ndi ärrï yidiganya ꞌdar aar je übïjänü. ");
INSERT INTO lro_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","A be nga nga, yäꞌtüdï giyee yïndädä gu ndi lenge Kirictung ndi ari nga je ärrï. ");
INSERT INTO lro_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","Äny gwülïngïdï gu ndi ari yätï ngwäyänü anni ma aang ꞌdingina nginde gwe na anni ma ara je gu enggaci ndi ari yiru ange yiru ꞌdidanu yani Yicu. ");
INSERT INTO lro_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","Yiru giyee yanni yenggacara je ndi ari gatanar elelleng gwudi lingeno gwudi gwerreng gwani lingeno lanni luꞌrin, gwani amiꞌra gwudi ligoꞌro lüngün gwanni gwuru ꞌtur. ");
INSERT INTO lro_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","Lenggaca je ndi ari ara je Lïgïꞌrïm lanni Lijuꞌru ïcäjänü ïrïyï gwe ngwäyälü ngwanni ngwuyang. ");
INSERT INTO lro_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","Ngaa genne lingina lanni liyang lanni lïgïꞌtïnä ndi ru nono lidi Ngwaalu ngwuru ꞌdidanu ndi dünälü na ndi juꞌri. ");
INSERT INTO lro_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Yäy gu no, gatanar be yiꞌduru ngaa abingajidi yengga yiꞌral yanni yätï ngwäyänü ndi ari alanga ꞌdar liru leꞌte leꞌte lidi ngwanginu ngweꞌte pu. ");
INSERT INTO lro_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","Manari güündä gima ji, aaꞌti be ya je ärrï yanni yiki, aaꞌti güündä ga ji ꞌdi a lingen üllï. ");
INSERT INTO lro_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","Aaꞌti ngaa lätädä dijegoꞌro gay ndi ara je oktada ndi ärrï yiꞌral yanni yiki. ");
INSERT INTO lro_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","A dïjï danni diru duꞌram gwele gwerre, aaꞌti ba be da ru duꞌram mana, ngwube manni ru danni dadi ape yiiru yere yijaw ngwuy ngwe ngwüngün, ndi ari ngwätï aar gu emadi ngindenga le lanni laꞌti ätï. ");
INSERT INTO lro_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","Aaꞌti ngaa la ꞌtüyï ngwujaꞌri ngwere ngwuki ngwulemanu, ngaa be ondaji ꞌdogo ngwujaꞌri ngwujaw ngwani bupi gwegen nunnu ngwüjï ngwanni ngwadi je ꞌdingini, aar je mbuji ngwuru yïmïꞌrä ꞌdeggen. ");
INSERT INTO lro_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","Aaꞌti ngaa la gäbïcï Lïgïꞌrïmä lidi Ngwaalu lanni Lijuꞌru ndi runi, Lïgïꞌrïm lanni lïrïngïdäjä je ndi ari ꞌdi a gomon ila gada je ge Ngwaalu üꞌrälü. ");
INSERT INTO lro_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","Gätär ngwujaꞌri mbüny ngwani ꞌrati ngwäy, iyidanu, güündä, acidi dulu de, ari ngwulem ngwujaꞌri ngwanu ꞌdar ngwanni ngwati apa yiꞌral yanni yiki. ");
INSERT INTO lro_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Jayidar ngwäy ngaa ïnäjïdï gwüpäng, düdänïjïdäränü giyiꞌral yanni yiki anaku düdänïjärä je gu Ngwaalanu ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","Yäy ärïnär be Ngwaalinganu ngaa ru nono yïjï yanni yämnäär je. ");
INSERT INTO lro_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Ngaa elelle elelleng gwudi ämnäjïdï anaku ämnäär nje gu ꞌto Yicu Kirictu ꞌdi ngwayi gwani alanga. Ayi gwüngün gwuru mïꞌrïnïng nono gwuru deꞌreny dami düwä Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","A be aaꞌti ondaji gwere gwa ji ꞌdanggalanu gwani yïjïn na rngï gwere na ubanu gwere gwa ji ꞌdanggalanu. Ndi ari yiꞌral yanni yiru gu no, yaꞌti jaw ndi ji ngwüjänü ngwanni ngwujuꞌru ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","Aaꞌti ngaa la ari ngwulem nga ondajalu yämbärä na ngwuꞌdera ngwanni gwaꞌti ädï. Ngaa be manni ortada Ngwaalinga giyigoranu ngaa je ci yäy ꞌtu. ");
INSERT INTO lro_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Ndi ari nunnu no, ngaa la lenge ꞌdidanu ndi ari gwere gwanni gwuru dïjïn, na gwanni gwuru didigany na gwanni gwubanu, ndi ari gwanni gwubanu, gwuru dïjï dati äpïjï dïdülä yobo gwaꞌti ätï ndi ape yuꞌrina yere giyelenyanu yidi Kirictu na Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Aaꞌti ngaa la gäbïcï dïjü dere ndi ara je ïdäjänü ngwujaꞌri ngwe ngwuru ꞌtur, ndi ari nunnu ngwujaꞌri ngwanni ngwuru gu no, ngwati gäbïcï a güündä ji gidi Ngwaalu ꞌdi ngwïꞌdädä ngwüjü nono ngwanni ngwati nyurtanu. ");
INSERT INTO lro_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","Oꞌrar kora nggoo gidi ngwüjï ngwanni ngwuru gu no. ");
INSERT INTO lro_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Ngaa liru nono ngwüjü ngwuju gïdïrïmänü gwele a be anni ma aang ru yïjï yidi Ngwaalu, ngaa lima ji giburalu gwani Deleny. Elellar elelleng gwudi yïjï yanni yïndï giburalu ");
INSERT INTO lro_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","ndi ari yuula yidi buri yiru giyee ꞌdar yani jayi, dünälü na ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","Ïräjär ngwäy giyiꞌral yanni yati gäbïcï Delenya dani Yicu Kirictu ngwujayanu. ");
INSERT INTO lro_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","Oꞌraralu giyiꞌral yanni yati je ngwüjï ärrï ngwudi dïrïm yanni yiru ꞌtur, ngaa je be manni ꞌtäjälü. ");
INSERT INTO lro_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","Yiki ngwulemanu ndi ondaji ngwujaꞌri ngwanni ngwati je ngwüjï ngwanni ngwunyurtanu ape yuꞌrimi. ");
INSERT INTO lro_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","A be yiꞌral ꞌdar yanni yati je buri oꞌrralu, yati enggani aar linginni giꞌra. ");
INSERT INTO lro_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Ndi ari buri gwuru gwati enyalu ngwügäbïcï ngwony ꞌdar aar enggani. Ngaa lanni liru ngwïkïrïjïn, liru gu no ngwüjï ngwanni ngwati ärrï yiꞌral yanni yiki. Yiru giyee yanni gäbïcä ngwüjü aar be elnge ari, “ꞌRitu nga nggwee gwundru, ꞌdïꞌrälü nggwee gwayu ara gu buri gwudi Kirictu oꞌrra.” ");
INSERT INTO lro_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","Arnganar be ndi ari ngaa gilo lelella awa aaꞌti ngaa lelelle liru ngwuꞌdunggal (nono ngwuꞌder) ngaa be ru lanni libebera. ");
INSERT INTO lro_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","Nga bornanar linginayu ndi ärrï yiꞌral yanni yijaw ndi ari giyo yima ke yomon yanu giyee. ");
INSERT INTO lro_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","No, aaꞌti ngaa lïꞌdädänü, ngaa be lenge ndi ari yiru ange yïmïnä je Deleny. ");
INSERT INTO lro_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","Aaꞌti ngaa la rlälï diꞌrica de ara je gäbïcï ngaa arralu kräm. Ngaa be manni onjadi Lïgïꞌrïmälä lanni Lijuꞌru. ");
INSERT INTO lro_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","Ati aang ondajidi ngwujaꞌri ngwudi Mäjïmür, ngaa elnge delnga didi orta na didi lïgïꞌrïm. Elngar ngaa jäyïjï Delenyanu giyigoranu. ");
INSERT INTO lro_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","Yomon ꞌdar ati aang ci Ngwaalinga ngwuru Papa yäy ꞌtu giyiꞌralalu ꞌdar, ngwürïny ngwe ngwudi Deleny dege dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","ꞌDengenajidar ꞌdar gwüpäng ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Lani ngwaw, ꞌdengenajar ngwuru ngwalu gwani Deleny. ");
INSERT INTO lro_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Ndi ari dur diru giꞌra gidi daw nono anaku ru gu Kirictu giꞌra gidi giꞌdoonga ganni giru ngwanginu ngwüngün ngwanni ngwurucing je gilang. ");
INSERT INTO lro_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Yäy no, nono anaku ati gu giꞌdoonga gidi Ngwaalu ꞌdengenaci Kirictung, ati ngwaw ꞌdengenaci ngwuru ngwegen giyiꞌral ꞌdar. ");
INSERT INTO lro_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Lani ngwur, ämnär ngwayu ngwalu nono anaku ämnä gu Kirictu giꞌdonga güngün ꞌdi ngwududiyi ligoꞌro lüngün gwani giꞌdoonga. ");
INSERT INTO lro_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","Ndi ari ngwujuꞌriyi nono na ngwugaꞌru nono uyi gwe nono yaw ye yani ꞌdingini gwe ngwujaꞌri ngwüngün. ");
INSERT INTO lro_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","Ngwügïꞌtïjï ligoꞌro lüngün ngwuru giꞌdoonga gari nono ꞌrir ga ꞌti ätï yaaru nono yere ngwuꞌti judu nono ngwuꞌti ätï yiꞌral nono yere ngwube juꞌri ngwujayi nono. ");
INSERT INTO lro_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Yiru gu yeꞌte yeꞌte ndi ari a ngwur ämnï ngwayu ngwegen anaku ati aar gu ämnï ngwangina ngwegen. Gwanni gwati ämnï dayu düngün, gwati ämnï ligoꞌro lüngün. ");
INSERT INTO lro_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Na mine yärü gwanni gwati ngwanginu ngwüngün ke ngwäy. Ngwati ar je pa iye ar je arngani, anaku ati gu Kirictu ärrï giꞌdonga güngün. ");
INSERT INTO lro_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","Ndi ari a liru ngwüjï ngwudi ngwanginu ngwüngün. ");
INSERT INTO lro_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","Yiru giyee yaru ye gitab, “Yiru yanni yati gäbïcï duru ngwube gatani papang gwüngün na nanning gwüngün aar acidi daw de düngün, a ngindenga rom aar ru ngwangina ngweꞌte pu.” ");
INSERT INTO lro_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Yiꞌral giyee yiru yujimid yojema a be yondajiny ye yani Kirictu na giꞌdoonga güngün. ");
INSERT INTO lro_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","A be gäbïcär ndi ari ati dur deꞌte deꞌte ꞌdanggalanu, ämnï dayu düngün anaku ating gu ämnï ligoꞌro lüngün na daw denya duru düngün. ");
INSERT INTO lro_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Lani yïjï, ꞌdengenajar papang na nanni anaku bupa gu Deleny dani Yicu Kirictu ndi ari yädï gu no. ");
INSERT INTO lro_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","Yüllïnä kitabanu gidi Ngwaalu ganni guꞌrin ndi ari, “Dïnyädär papang na nanni.” Ngwujaꞌri ngwuru ngwee ngwanni ngwuru giꞌra ngwujaꞌranu ꞌdï (10) ngwanni ngwätï ngwujaꞌri ngwaru ngwe Ngwaalu, ");
INSERT INTO lro_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","“Nunnu a ngwaalu jayanu ara je Ngwaalu gendaci yomon ndi midi ngaa midi gïdïdlä.” ");
INSERT INTO lro_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","A nga nga lani papanga, aaꞌti ngaa la kiyi yïjänü yalu ngaa je be manni ꞌrünïyï ngaa je enggaci ngwujaꞌri na gay gidi Deleny. ");
INSERT INTO lro_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Lani ngwïnäd, ꞌdengenajar ngwelenya ngwalu gïdïdlä yedeny ye lididiꞌru na yigor ye yanni yiru ꞌdidanu, nono ma aang je ärrïjï Kirictung. ");
INSERT INTO lro_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","ꞌDengenacar je aaꞌti nunnu nono gwele ma ara je geꞌte ngwäy nono nunnu ngaa je gäbïcï ara je jäyïjänü, ngaa je be ärrï yigor ye ꞌdidanu ndi ari ngaa liru ngwïnäd ngwudi Kirictu ngaa lapu buping gwudi Ngwaalu yigor ye. ");
INSERT INTO lro_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Ngaa je ape yigor ye ꞌdar ndi ari yiiru yalu yäpïjä je Delenya yaꞌta je äpïjä dïjü dümnä. ");
INSERT INTO lro_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Ngaa diwayini ndi ari Deleny da je ätädä guꞌru gani ape yiiru yalu ꞌdar yere yanni yijaw ngaa lanni liru ngwïnäd na ngaa lanni läꞌtüdï ngwïnäd. ");
INSERT INTO lro_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","A lani ngweleny, ärrär ngwïnädä ngwalu yiꞌral giyee yijaw. Aaꞌti ngwa je iye yedenyo anaku lïngïdä gu gweneno ndi ari gwätängä gweꞌte pu ꞌdogo gwanni gwuru Deleny dalu ngindenga le kerala gwanni gwati ꞌti utanu. ");
INSERT INTO lro_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","Yanni yadiny ye aralu gwodan lani ngwänggärï yiru ndi ari, ojemar nono Gideleny na giyiima yüngün yanni yojema. ");
INSERT INTO lro_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","Gwodanaranu ngwäbländï ngwe ngwudi Ngwaalu ꞌdar ngwätädärä je nunnu ngaa ji ꞌdäny ngaa gwoma yiꞌralanu yidi dijegoꞌrr. ");
INSERT INTO lro_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Ndi ari yäärä yege yaꞌti ani gwomajidanu dïjïngä le dümnä, aar be ani gwomajidanu ngwurꞌtunga le, gwomajidanu ngwelenyinga le, gwomajidanu ngwumanga le ngwudi dïrïm didi dïdlä, gwomajidanu yiimanga le yidi ngwügïꞌrïm ngwudi gere. ");
INSERT INTO lro_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","No, gwodanar banu ngwäbländï ngwe ngwudi Ngwaalu nunnu ngaa ji ꞌdäny ngaa dugidi komon gidi yijegoꞌrr. A ma je be ape giyee ꞌdar, ngaa mbüjïnï lïdünälä yuru. ");
INSERT INTO lro_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Dïrnär bälü ꞌdïꞌdäny ngaa rüjïnänü ꞌdidanu ngwe ngwuru nono gennenalu jägïlïm gwe gidiriny, ngaa üllänï dünïngälü gwalu ngwuru etadi ngwambang ngwalu ");
INSERT INTO lro_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","ngaa genne ngwüdänü giyora yalu ngwani ji mama gwalu ndi ape ngwujaꞌri ngwanni ngwujaw ngwudi adatalu ngaa je ondaci ngwüjü. ");
INSERT INTO lro_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Ngaa gendani giyiꞌralanu giyee, lärä lani ämnï Ngwaalu gwalu ngaa le gerani gwuꞌrijal gwuru lïgä lidi dijegoꞌrr. ");
INSERT INTO lro_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Ngaa üllänï gilanging ngwuru nono gibumbu gidi etadi kiꞌra aang ape ngwujaꞌri ngwudi Ngwaalu aar ru nono galala gidi lïgïꞌrïm. ");
INSERT INTO lro_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Na otacar Ngwaalingalu gïlïgïꞌrïm giyomon ꞌdar ngaa utalu otaci gwalu ꞌdar yiꞌral yiꞌranu ꞌdar a bupi, yiꞌral ye giyee giligoranu, nga arngani ati aang mätïnälü ndi otaci ngaa päcälü Ngwaalingalu ngwüjï ꞌdar ngwanni ngwujuꞌru ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Ati aang otaci Ngwaalingalu ꞌto gwani äny nunnu manari äny gwuma ïgïtï ngwulem ndi ondaji, aar nyi Ngwaalu ätä ngwujaꞌri nyi ꞌranu ndi enggaci ngwüjü yujimida yidi ngwujaꞌri ngwanni ngwujaw. ");
INSERT INTO lro_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","Ngwanni ngwuruci nje dïjï dükäjäär yanni yïgäbïcïny nyi genne giyirna. Otacar Ngwaalingalu gwani äny ndi ari nyi ꞌranu nje ondaji anaku büpïnär gu. ");
INSERT INTO lro_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Diweengga dämnär dani Tiyakuj gwanni gwuru dïnäd gwuru ligor leꞌte pu Gideleny, gwa je ondaci yiꞌralalu ꞌdar, nunnu ngaa lenge ndi ari äny nggwo gwuru ꞌtaa na äny nggwo ndi ärrï ange. ");
INSERT INTO lro_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","Yiru giyee yanni yïgäbïcïny nyi be ükäjä ꞌdanggalu nunnu ngaa lenge ndi ari änyängä gilo liru ꞌtaa na ara je ojemeye nono. ");
INSERT INTO lro_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","A adatalu ji ngweengga na ämnäjïdï, ämnï gwe Ngwaalu gwanni gwïndï Ngwaalu ngwuru Papa na Deleny dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","A yïmïꞌrü ji ngwüjï ꞌdar ngwanni ngwati ämnï Delenya dege dani Yicu Kirictu ämnïng gwanni gwati ꞌti medadu.");
INSERT INTO lro_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Ngwujaꞌri ngwee ngwïndï ꞌdänggärï, äny gwani Bulij na diweengga dani Timijawuj liru ngwïnäd ngwudi Yicu Kirictu. Ngwükäcï nje ngwüjü ꞌdar ngwudi Ngwaalu ndi Yicu Kirictu kündär gani Bïlïpï ngwangidanga le na lanni lati gendaji guy giyiiru. ");
INSERT INTO lro_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Ara je gu yïmïꞌrü ji aar je gu adatalu ji gwudi Ngwaalu ngwuru Papa gwege na Deleny dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Nggwati ci Ngwaalinga ngwüny yäy ꞌtu gwani nga nga kaji ꞌdar ma je diwayini. ");
INSERT INTO lro_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","Ndi otaci Ngwaalingalu gwüny ꞌdar gwani nga nga ligor le lijayanu yomon ꞌdar ");
INSERT INTO lro_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","gwani acajidi gwanni gwacidar gu giyiiranu yidi ngwujaꞌri ngwanni ngwujaw ꞌtuꞌtu gomon gidi gwerreng ꞌdi gomon gidi gweneng. ");
INSERT INTO lro_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","Nggwïcïnänü giyiꞌral giyee ndi ari Ngwaalu ngwanni ngwädäälü yiiru ye yanni yijaw ꞌdanggalanu, ying je ape ying je mbütï ꞌdi gomon gadi ge Yicu Kirictu oꞌra. ");
INSERT INTO lro_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","Yädï gu ꞌdünggüny ndi ïcïnänü no ꞌdanggalanu ꞌdar ndi ari nga nga lati ji giligoranu lüny yomon ꞌdar. A lacajidu ꞌdar gïyïmïꞌränü yidi Ngwaalu ya gu ru gweneno äny nggwo giyuꞌrung yaa ya gu ru minyi ji ndi rucidi ngwujaꞌri ngwanni ngwujaw, nyi je inggidi ndi ari ngwuru ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Ngwaalu ngwuru ngwänggädïny ndi ari awa nggwüjädï ndi a je engga ꞌdar ndi ari nggwämnä je anaku ämnärä je gu Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","Nggwotaca Ngwaalingalu nunnu ara je gendacani ämnïng ngwongranu ara je ätädänï bebereng gwanni gwuru ꞌdidanu ara je ätädä lengeng gwanni gwïndï kayalu. ");
INSERT INTO lro_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","Nunnu ngaa gwe burni ndi äbrï yiꞌral yanni yijayana ngaa juꞌri ngaa jayi nono ꞌdi a gomon gadi ge Kirictu oꞌra. ");
INSERT INTO lro_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","Aar je gu yiiru onyadi yanni yijaw Yicu Kirictu gwe gwani näjï na orta gwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","A gweneno, nggwümïnä je ngwänggärï ngaa lenge ndi ari yanni yiminy mbuji, ꞌdidanu yima gäbïcï ngwujaꞌri ngwanni ngwujaw ngwuma badalu. ");
INSERT INTO lro_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","ꞌDi ngwangida ngwudi ngwuꞌdun ngwudi yeleny na ngwüjï ꞌdar ngene, ngwülïngïdï ndi ari nggwukennalu yuꞌrung ye gwani Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Ndi ari giyuꞌrung yüny giyee, yima gäbïcï ngwïkïrïjïnä ngwonyadana ndi Kirictu ngwuma ojeme nono aar ꞌranu ndi ondaji ngwujaꞌri ngwudi Ngwaalu laꞌti yedeny ïtï. ");
INSERT INTO lro_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","Yiru gu ꞌdidanu ndi ari loko gilo londaju Kirictu gwe yigor ye yiru yïꞌdüny aar enati, a be loko, gwondajaar gwe yigor ye yijayanu. ");
INSERT INTO lro_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","Ngindenga gilee lidi gwodaning gwondajaar gwe no, ämnï gwe aar lenge ndi ari Ngwaalu ngwuru ngwugeꞌteny ngene nunnu nyi rucidi gwani ngwujaꞌri ngwanni ngwujaw. ");
INSERT INTO lro_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","A be giloo lidi gwerre gwerreng, londaja Kirictu gwe yigor ye yegen yäꞌtüdï ꞌdidanu aar geꞌte ndi ari la gwogajidi ꞌdünggüny aar nyi gendaci dïrbä gwuju giyuꞌrung. ");
INSERT INTO lro_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","A be yojema ꞌdünggüny giyee? Bärï. Yanni yojema yiru ndi ari ngwürïny ngwudi Kirictu, ngwo ngwondajaar ngwe ngway ngwe ꞌdar ya gu ru yimurꞌtuny ye ya gu ru ꞌdidanu gwe no, äny gwujayanu yiꞌral ye giyee na nggwa oꞌre gwa jayanu mana. ");
INSERT INTO lro_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","Ndi ari nggwülïngïdï ndi ari otaci gwe Ngwaalingalu gwalu na gendaci gwe gwudi Lïgïꞌrïm lidi Yicu Kirictu, yanni yima ji ꞌdünggüny ya gwurli yani gäꞌdänälü gwüny. ");
INSERT INTO lro_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","Yanni yïmïnï nje aar nyi gu ligor iyada, yiru ndi ari aaꞌti nggwa muli nono giyiꞌral yere, nyi be ꞌranu gwulleny giyomon ꞌdar gwece gwece gweneno, nunnu nyi näjï Kirictung ligoꞌro le lüny, ma aar ani midi gwüny na ma aar ani yiꞌrany yüny. ");
INSERT INTO lro_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Ndi ari midi gwüny, Kirictu gwuru na yiꞌrany yüny, yani bile. ");
INSERT INTO lro_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","Manari yani nunnu nyi midi gilingeno, yiru ꞌdünggüny ndi ari nyi ape yiiru aar lengadi. A be yaꞌti nje lïngïdï yïndï ne yanni yadi nje ape? ");
INSERT INTO lro_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","Giyo yüꞌrïdïnyänü rom, nggwüjädï ndi gatani dïdläyü ndee nyii ji Kirictu gwe, yijayana gu giyee gwulleny. ");
INSERT INTO lro_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","A be gwani nga nga, yojemana gwulleny nyi jalu gilingeno. ");
INSERT INTO lro_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Yïcïnïny yänü giyee, yäy gu no nggwülïngïdï ndi ari nggwa jalu ar ji ꞌdar nunnu ngaa ongranu ngaa elada gweere ngaa jayanu ndi ämnï Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","Miny ila ꞌdanggalu mana, jayanu gwalu ndi Yicu Kirictu, gwa gendadi gwïrälü gwani äny. ");
INSERT INTO lro_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","Yanni yojema yiru ndi ari, elellar elelleng gwanni gwädï ngwujaꞌri ngwanni ngwujaw ngwudi Kirictu. Manari nggwuma ila nga je engga na nga je gwe ꞌdingini nggwaꞌti gito ꞌdanggalu, nggwa lenge ndi ari ngaa lïmätïnälü gïlïgïꞌrïm leꞌte pu ngaa undi ngwäy gwüpäng yigor ye yeꞌte pu gwani ämnï ngwujaꞌri ngwanni ngwujaw. ");
INSERT INTO lro_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","Ara je ꞌti yedeny ïtï küwän galu aꞌtur. Yiꞌral giyee ya ru giꞌremna ꞌdenggen ndi ari ngindenga la girradi ngaa la be gïlängïdïnï Ngwaalu ngwe. ");
INSERT INTO lro_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","Ndi ari Kirictu gwe, lätädä je miding, gwaꞌti ani ꞌdogo nunnu ngaa ämnï ꞌdünggüngün, ngwube ani ꞌto ara je yiꞌrendeny eny nono gwani nginde. ");
INSERT INTO lro_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","Nga nga gilo lidugudu gïyääränü yeꞌte yeꞌte yanni yänggädïïny gu nggwudugudu gu gwerre na giyona yiꞌdingina ye äny nggwona gwudugudu gu. ");
INSERT INTO lro_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Midi gwalu ndi Kirictu nggwo gworꞌtemaja je? Ämnï gwüngün ꞌdanggalu nggwo gwojemeya je nono? Ngaa gilo lacajidu gïlïgïꞌrïmo? Ngaa gilo lijaw yiguri ngaa ïnäjïde? ");
INSERT INTO lro_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","Manari giyo giyee, gäbïcär be jayanganu gwüny ngwumbuti ndi ari ngaa gekajidi ngaa ru yaꞌranya yeꞌte pu ngaa ätï ämnäjïdïng gweꞌte pu ngaa ji gïlïgïꞌrïm na ndi bupi gweꞌte pu. ");
INSERT INTO lro_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","Aaꞌti ngaa lätï yigor yani üꞌrïꞌtïdänü ngaa ïrïngïnï gilingeno gwuru ꞌtur ngaa be üllïyï yigoꞌranu yalu ngaa engga ngwüjü ngwuꞌter ndi ari ngwujayana ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","Dïjï deꞌte deꞌte aaꞌti da ombani ligoꞌro lüngün, ngwube ombaji yiꞌral yani gwenggen gwuꞌter. ");
INSERT INTO lro_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","Gäbïcär ngwujaꞌri ngwudi yigor yalu aar ru nono ngwudi ligor lidi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Ndi ari nginde gwuru drü didi Ngwaalu ngwuꞌti be geꞌta ligoꞌro lüngün ndi ari aar ubidanu Ngwaalu ngwe giyiꞌral yere ngwuje ape. ");
INSERT INTO lro_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","Ngwube geꞌte ligoꞌro lüngün ngwuru dïnäd ngwuru nono dïjü dümnä. ");
INSERT INTO lro_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","A nginde gwuma ru nono dïjü dümnä gwuma ülläjï ligoꞌralu lüngün ngwämnï ndi ari ngwayi küꞌrälä yiꞌrany yidi ngwüjï ngwuru ngwuꞌram. ");
INSERT INTO lro_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Yäy gu no, gwuma Ngwaalu allijala aar geꞌte ngwaalu ngwudi yeleny yanni yipa aar ätädä ngwürïny ngwanni ngwupana guꞌru ngwürïnyälü ꞌdar anaku raar gu. ");
INSERT INTO lro_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","Nunnu a ngwüjï ꞌdar anaku rar gu kwuci Yicungalu yirku ye giyoranu yüngün, kerala na gïdïyängälü na gïdïyängänü. ");
INSERT INTO lro_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","Na ndi ari ngwüjï ꞌdar anaku rar gu ngwungla ngwe ngwegen, ngwa ꞌtäjälü ndi ari, Yicu Kirictu gwuru Deleny, ndi näjï gwudi Ngwaalu ngwuru Papa. ");
INSERT INTO lro_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","Yäy gu no, ngwumaad ngwüny, anaku ꞌdengenajiny gu gwerre yomon ꞌdar yanni yijar ye a be gweneno ya rani guꞌru ndi nyi ꞌdengenaji äy gwaꞌti gito. Undar ngwäy ngaa olati ndi gilang arngana gwe na denya gwe gwalu. ");
INSERT INTO lro_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","Ndi ari Ngwaalu giligoꞌro lüngün ngwuru ngwapu yiiru ꞌdanggalanu nunnu ara je gäbïcï ngaa mïnï ngaa ätï yiima ndi ärrï buping gwüngün gwanni gwujaw. ");
INSERT INTO lro_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","ꞌDïꞌrär yiiru ye yalu ꞌdar aaꞌti ngaa la ꞌrüllï giyigoranu yaa ngaa garnati. ");
INSERT INTO lro_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","Nunnu ngaa jayi nono ngaa juꞌri ngaa ru yïjï yidi Ngwaalu ngaa dünälü kimadanu gidi dïdlä ndee gïrlänü giki. Ngaa enyanu ꞌdenggenanu nono buri gwudi yuurrum yïtänü kerala. ");
INSERT INTO lro_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","Ndi ari ngwati a je enggaci ngwujaꞌri ngwudi midi. Yiru giyee yanni ya ji yiny ye ïrïngïnï komon gadi ge Kirictu oꞌra, nyi engga ndi ari undi ngwäy na dïrbä düny giyiiru dima ꞌti geradalu aꞌtur. ");
INSERT INTO lro_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","ꞌDi manari yïn yüny yima ïrädälü nono diꞌrica dïbäläjärälü ndi ari gwani mïꞌrïnï nono na yiiru yidi ämnï Ngwaalu gwalu, nggwujayanu ar jayanu ꞌdar. ");
INSERT INTO lro_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","No nga nga ꞌto, jayaranu nyii gäbïcï ar jayanu. ");
INSERT INTO lro_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Nggwugeꞌtaja bupi gwe gwudi Deleny dege dani Yicu nga je ükäcä diwengga dani Timijawuj yomon yanu giyee, nunnu nyi jayanu miny ꞌdingini ngwujaꞌri ngwïndï ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Nggwaꞌti a be ätï dïjälü dere ngene danni diru ligor ꞌdidanu gwani nga nga nono ngindeng. ");
INSERT INTO lro_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Ngwüjü ꞌdar ngwo ngwugwuju yiꞌral yidi yigor yegen yaꞌti ani yiꞌral yidi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","A be nginde gwani Timijawuj, gwülïngïdängä yiiru yüngün gwapiiny gwe yiiru yidi ngwujaꞌri ngwanni ngwujaw nono gïjïngä papa gwe. ");
INSERT INTO lro_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Yäy gu no, nggwugeꞌtaja nga je ükäcä manari gwuma lengeda yiꞌral yorto ye ngwaalinga yüny ndi ari yadi ruꞌtaa. ");
INSERT INTO lro_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Nggwïcïnänü ndi Kirictu ndi ari äny giligoꞌro lüny nggwa ila ꞌdanggalu yomon yanu giyee. ");
INSERT INTO lro_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","A be nggwaru yiru gu nga je gwäꞌräcä diwengga dani Äbïbrüdïtïyüj gwanni gwükäcïïny aar nyi gendaci guy, gwapiiny gwe yiiru nyii gwe dünï yongra. Nyi be ari yiru guꞌru nga je ükäcä gwenene. ");
INSERT INTO lro_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","Nginde gwüjädï ndi ara je engga ꞌdar. Nginde gwaꞌti ädïyä ligoralu ndi ari gwuꞌdingina gwe gwümä. ");
INSERT INTO lro_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","ꞌDidanu nginde gwümä gwani yiꞌrany, gwuma be ïnädä Ngwaalinga, nginde gwäꞌtüdï jücü, äny gwuma ïnädä Ngwaalinga ꞌto ndi ari aaꞌti nggwoꞌre nggwa runi mana. ");
INSERT INTO lro_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Yäy gu no, yiru giyee ndi ari nga je ükäcä nunnu ma aang engga mana, ngaa la jayanu nyi gäbïcï ꞌto aaꞌti ligor liny pänü gwulleny. ");
INSERT INTO lro_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","Geꞌtaralu yïrnü yigor ye yijayanu ꞌdar nono diwengga ndi Kirictu. Geꞌtar ngwüjü gïyïrnü ngwanni ngwuru gu no. ");
INSERT INTO lro_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","Ndi ari nginde gwuju yiꞌrany gito gwani yiiru yidi Kirictu ngwuru gwadi dudiyi ligoꞌro lüngün nunnu aar nyi gendaci guy giyiꞌral yanni yima gu amiꞌrati ndi nje gendaci. ");
INSERT INTO lro_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Ngwänggärï, yanni yadi nyi ye aralu gwodan, yiru ndi ari jayaranu Gideleny! Yaꞌtiny ꞌrïgädü ndi oꞌre nga je üllïjä ngwujaꞌri ngwee ngweꞌte ngweꞌte mana. Nggwetada je gu. ");
INSERT INTO lro_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Arnganar yinyeno giyoo, ngwüjï ngwoo ngwanni ngwärrü yiꞌral yiki ngwondaja üꞌrïdänï gwe ngwanginu. ");
INSERT INTO lro_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","Ndi ari alanga liru ngwüjï ngwanni ngwüꞌrïdänä üꞌrïdänïng gwanni gwuru ꞌdidanu, ndi ari alanga läpïjä Ngwaalinga yiiru Lïgïꞌrïm le lidi Ngwaalu, ar ïrïngïnï ndi Yicu Kirictu. A laꞌti gätädï ngwäy giyiꞌral yiru guꞌru gilingeno. ");
INSERT INTO lro_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","Nggwätï gu aadi nyi gu gatada ngwäyänü. Manari dïjï dere ndo dänggädï ndi ari dätï gu ndi gatada ngwäyänü giyiꞌral yidi lingeno, äny gwätänä gu. ");
INSERT INTO lro_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","Ndi ari äny gwüꞌrïdänä nggwuru gwooko komon ganni giru ꞌdübä. Nggwuru Dïjïräyïl gïlängïr lidi Bïnïyämïn. Nggwuru Dïbrü gïjï gidi Dïbrü. Na gwani yobo, nyi ru Dïbärrïjï. ");
INSERT INTO lro_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","A nyi ligor enyanu nyi übïnï giꞌdongalu gidi Kirictu. Na yani dünälü giyobo, äny gwuru dïjï dijaw nono. ");
INSERT INTO lro_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","A be gweneno yüny ꞌdar yele yätädï nje guꞌru, yiminje engga yiru ꞌtur, yiminje gatu mbüny gwani Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","Yiru ange yanni giyo mana, yänggädï nje ꞌdar yiru ꞌtur yinje gatu mbüny yïdïnjänü yaꞌti aar ubidanu bebere gwe gwuru guꞌru gwani Deleny düny dani Yicu Kirictu. Gwanni gwuminy gäbïcï yiminje gatu mbüny ꞌdar yele yätï nje. Yänggädï nje yiru nono gïrüräny ꞌdünggüny nunnu nyi bile Kirictung ");
INSERT INTO lro_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","nyi ru gwüngün a nyi Ngwaalu engga ndi ari äny gwüdünälü ndi ämnï Ngwaalu yaꞌti ani dünälü gwüny ndi ari äny gwapu dïmürä didi yobo, aar be ani ämnï gwüny ndi Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Äny gwümïnä ndi lenge Kirictung nyi ïcïnänü yiima ye yidi ꞌdïꞌrï gwüngün nyii gwe acajidi giyiꞌrendenyanu yüngün, nunnu nyi ru nono ngindeng giyiꞌrany yüngün, ");
INSERT INTO lro_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","nunnu nyi aji nyi ꞌdïꞌrälü giyiꞌranyanu nyi midi. ");
INSERT INTO lro_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Äny gwaꞌti aru äny gwuma obaji giyiꞌral giyee ꞌdar, nyi ari äny gwuma olati, a be äny nggwo gu ndi pä yiima ꞌdar nje määtä yanni yïmäätädäär nyi gu Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","Ngwänggärï, nggwaꞌti änggädï ligoꞌro lüny ndi ari yiminje määtä, a be yeꞌte pu yape nje, ndi ari, nje dodani yanni giyo gwodani nyi pä yiima nje gwoda yanni giyo gweere. ");
INSERT INTO lro_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","Nggwüpädï yiima nunnu nyi obaji aar nyi ätädä guꞌru ganni gornacaar nyi Ngwaalu urnidi gwüngün gwudi geralang ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Alanga ꞌdar lanni libebera ngwujaꞌri ngwani lïgïꞌrïm ar gu ïrïyï ngwäyälü no. Ma be ari gwere nggwo ngwaalu ngwere gwaꞌti ïndï ngwujaꞌri ngwe ngwee ngwänggädä je ꞌter, ngwa ara je Ngwaalu ꞌtäcälü. ");
INSERT INTO lro_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Yiru ꞌdogo ndi ari gäbïcär ar gwuji elelleng ar gwuji ꞌdidaning ngwaalu ngwanni ngwuma ar gu obani. ");
INSERT INTO lro_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Nga nga ꞌdar gwujar gora güny ngwänggärï, ngaa geꞌte ngwüjü ngwäy nono ngwanni ngwïndï gay ge ganni gätädärä je. ");
INSERT INTO lro_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","Nggwondaca je gu gwerre ngwujaꞌri ngwee na gweneno nggwoꞌre nggwa je ondaci yal ye ngwäy, ndi ari gilo lonyadu ndi elelle gwegen liru güwän küꞌrï gimamindanu gidi Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","Gay gegen gani dudi, ngwaalu ngwegen ngwani iyada gilaranu legen aar ye ïrïngïnï yanni yiru yaaru, yaꞌrany yegen ꞌdar yani ngwong ngene dïyängälü. ");
INSERT INTO lro_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","A be ngwuꞌdun ngwege ngwo kerala. Na a lïdünïcä gu Gilanging ngenone yigor ye yïtï njänü, gwuru Deleny dege dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","Ndi ari yiima ye yüngün gwa gwürlï ngwangina ngwege ngwanni ngwamiꞌratu ngwuje ruji nono ngwangina ngwüngün ngwanni ngwünäjïnä. Yiima ye yüngün yanni ying ye gwäꞌrï yiꞌral ꞌdar aar ꞌdengenaci. ");
INSERT INTO lro_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Ngwänggärï ngwanni ngwämnï nje, nggwüjädï ndi a je engga, ngaa liru jayanu gwüny ngaa ru giꞌriba gidi yeleny gidi giꞌra güny mätïnärälü ꞌdïꞌdäny Gideleny lani ngwumaad ngwüny. ");
INSERT INTO lro_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Nggwa päcï Äpüdïyängälü Jïtïnggï gwe aar ätäjïdï ngwujaꞌri ngweꞌte pu Gideleny liru ngwïkïrïjïn. ");
INSERT INTO lro_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Yäy na nggwüpäcängälü gwani gimaad güny giru ligor leꞌte pu, gendaci ngwayu ngwee rom guy ndi ari ngwundu nyii ngwe ngwäy ngwujaꞌri ngwanni ngwujaw ngindenga Kilemeninga le na ngwüjï ngwoko ngwuꞌter mana ngwanni ngwapu nyii ngwe yiiru ngwuma aar je ulli ngwürïny ngwegen kitabanu gidi midi. ");
INSERT INTO lro_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","Jayaranu yomon ꞌdar Gideleny. Nyi oꞌre nyi ari mana, Jayaranu! ");
INSERT INTO lro_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","A jïlänü gwalu linginni ngwüjü ꞌdar. Deleny ndo gito. ");
INSERT INTO lro_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","Aaꞌti yigor ya je pänü giyiꞌral yere ngaa be otaci Ngwaalingalu ngaa je päcälü yiꞌral ye ꞌdar yigor ye yari yäy ꞌtü. ");
INSERT INTO lro_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Na adatalu gwudi Ngwaalu gwanni gwolanala ndi bebere ꞌdar, gwa etadi giyigor yalu na giyaꞌrany yalu ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Gwodanalu, nggwa je ci ngwänggärï, ïrïyär ngwäyälü giyiꞌral ꞌdar yanni yiru ꞌdidanu, yanni yijuꞌru, na ꞌdar yanni yijaw, yere yanni yïgäꞌrïnä, yere yanni yämnïnä, yere yanni yani jadanu, manari yiꞌral yere yanni yiru jayani yädï gu ndi aar je näjï, ïrïyär ngwäyälü giyiꞌral yanni yiru gu no. ");
INSERT INTO lro_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Ïndär ngwujaꞌri ngwe ꞌdar anaku ma je gu enggaci ngaa je gu ondaci ngwuma je ꞌdingini ꞌdünggüny ngaa je engga ꞌdünggüny ngwape nje. Ngwaalu ngwanni ngwati geꞌte adatingalu, aar ji ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Deleny diminy gäbïcï nggwuma jayanu gwulleny ndi ari ngaa gweneno kaji nggee ꞌdar gima ele gima olanu, ngaa gilo linggidu ndi ari ngaa lima gwäꞌräjälü ndi nyi gu geꞌtaji ngwäyänü. Ngaa laꞌtiny dodana ngaa laꞌti mbuju ꞌdogo gay ndi a je ärrï. ");
INSERT INTO lro_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","Äny gwaꞌti gu aru ngwujaꞌri ngwee nunnu äny gwümïnä gony gere, ndi ari nggwuma lenge ndi äbräjï giyiꞌral yere ꞌdar yanni yadi nje mbuji. ");
INSERT INTO lro_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","Äny gwülïngïdï ndi ari yiru ꞌtaa ndi jalu ngwuy ngwanu nyii lenge ndi ari yiru ꞌtaa ndi ätï gwïrälü. Äny gwuma lenge yujimida yani awa ndi äbräjï giyiꞌral ꞌdar yere na ngwaalu ꞌdar ya gu ru ndi ari nggwïtï nggwupi ya äny nggwo ngwamu ngwe, ya gu ru ndi ari äny nggwätï gwïrälü, yaa nggwuru diwayi. ");
INSERT INTO lro_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","Äny gwa burni ndi ärrï yiꞌral ꞌdar Kirictu gwe gwanni gwatiny ätädä yiima. ");
INSERT INTO lro_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","A be yijayi gu gwulleny ꞌdanggalu ndi ari a lacajidu gwüpäng gïdïrbänü düny. ");
INSERT INTO lro_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","Nga nga lidi Bïlïpïng, lïlïngïdï ndi ari anni ꞌtüdïny nyi gatana Majiduniyang giyomon yidi gwerre gwerreng anni ädïnyälü yiiru ye yidi ngwujaꞌri ngwanni ngwujaw yïrnü ꞌdanggalanu, nga nga liru giꞌdoonga jücü ganni gemadiiny ge giyiꞌral yani ätä na ape. ");
INSERT INTO lro_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","ꞌDi anni jiny ꞌto ngwaalu ngwani Täjlänükï, ngaa lükäcïny ngwony yomonanu yonyadu. ");
INSERT INTO lro_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","Yaꞌti ani ndi ari äny gwümïnä ndiiny angidaci, nyi be mïnï yiꞌral yanni yada je gäbïcï ara je Ngwaalu düꞌräcï gwonyadu gwani yigoꞌro yalu. ");
INSERT INTO lro_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Nggwuma mbuji gwonyadana. Yanni yangidaci nje yima aar nje Äbïbrüdïtïyüj äpïjä yiru ꞌdünggüny nono deꞌreny dami düwä dïmïꞌrïnäär de nono ngwujada Ngwaalinganu. ");
INSERT INTO lro_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","A Ngwaalu ngwüny ngwa je ätädä gwonyadu gwani bupi gwalu gwani nänü gwanni gwupa ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","A näjï ru gwudi Ngwaalu ngwege ngwuru Papa yomon ꞌdar. Yiru gu. ");
INSERT INTO lro_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","Agannar ngwïkïrïjïnä ꞌdar ndi Yicu Kirictu. Ngweengga ngwanni ngwo nyii ngwe ngene, ngwaganna je. ");
INSERT INTO lro_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","Ngwïkïrïjïn ꞌdar ngene na gwece gwece ngwudi ngwuꞌdun ngwudi Deleny dani Gayijar didi Rumang, ngwaganna je. ");
INSERT INTO lro_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","A yïmïꞌrü yidi Deleny dege dani Yicu Kirictu ji gïlïgïꞌrïm lalu. Yiru gu.");
INSERT INTO lro_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Äny gwuru gwani Bulij, gwuru dooꞌra dükäjäär didi Yicu Kirictu anaku bupa gu Ngwaalu na diweengga dani Timijawuj. ");
INSERT INTO lro_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","Lükäjä ngwujaꞌri ngwee, ngwükäcärä je lanni liru ngwüjï ngwujuꞌru ngwudi giꞌdoonga gidi Ngwaalu kündär gidi Külüjïng lanni lämnä ndi Kirictu. Ara je gu yïmïꞌrü ji ara je gu adatalu ji gwudi Papa gwuru Ngwaalu gwege. ");
INSERT INTO lro_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Nyii lati ci Ngwaalinga yäy ꞌtu ngwanni ngwuru Papa gwudi Deleny dege dani Yicu Kirictu yomon reny minyii otaci Ngwaalingalu gwani nga nga ");
INSERT INTO lro_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","ndi ari nyii liꞌdingina ämnï gwe gwalu ndi Yicu Kirictu a nyii ꞌdingini ämnï gwe gwalu ngwüjü ngwanni ngwujuꞌru ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","Ämnï Ngwaalu na ämnäjïdï gwanni gwüꞌtüdï ndi geꞌtaji gwanni gwügïꞌtïjärä je Ngwaalu kerala ngwanni gwuꞌdingina gwe gwerre ngwujaꞌri ngwanni ngwujaw ngwuru ꞌdidanu ");
INSERT INTO lro_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","ngwanni ngwuma obana ꞌdanggalanu. Ngwaalu ꞌdar gïdïdlä, ngwüjï ngwonyadu ngwuma ämnï ngwujaꞌri ngwanni ngwujaw ngwuma gwürlï yigoꞌralu yegen aar jada Ngwaalinganu. Ngwujaꞌri ngwanni ngwapu yiiru aar ꞌtänü nono apar gu yiiru ꞌdanggalanu ꞌto ꞌtuꞌtu gomon ganni gima je ge ꞌdingini aang leneg yïmïꞌrä yidi Ngwaalu ꞌdidanu gwe ꞌdar. ");
INSERT INTO lro_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Yïmïꞌrü yidi Ngwaalu yanni ma aar je diweengga dämnïny dani Ababraj enggaci gwanni gwuru nyii le ngwïnäd ngwuru dooꞌra däpïjä Kirictung yiiru ligor le leꞌte pu ngwumandi ꞌdänggärï gwani nga nga. ");
INSERT INTO lro_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","Nginde gwuru gwanni gwondaci nje ꞌto ämnï gwe gwalu gïlïgïꞌrïm. ");
INSERT INTO lro_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Yäy gu no, yiru giyee yanni yïgäbïcï nje anni ma ara je le ꞌdingini, nyii ꞌti dünädï ndi otaci Ngwaalingalu gwani nga nga. Nyii otaci Ngwaalingalu nunnu ara je onjajala bebere gwe gwani bupi gwüngün bebere gwe na lenge gwe ꞌdar gwudi lïgïꞌrïm lüngün. ");
INSERT INTO lro_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","A lotaca Ngwaalingalu ngwujaꞌri ngwe ngwee nunnu ngaa elelle elelleng gwudi ngwüjï ngwädï Gideleny ngaa jadanu giyiꞌral ꞌdar. Nyii otacalu ꞌto ndi ari ngaa ape yiiru yanni yätï ngwäyänü giyiꞌral ꞌdar yanni yijaw ngaa pe ndi lenge ngwujaꞌri ngwani Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Nyii otacalu ꞌto ndi ari ara je ojemeye nono yiima ye ꞌdar yiima yidi näjï gwüngün. Nunnu ngaa burni ndi määtä yigor yalu ngaa orꞌtemaji gïdïrbänü dalu ꞌdar ngaa jayanu. ");
INSERT INTO lro_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","Ngaa ci Ngwaalinga yäy ꞌtu ngwuru Papa ngwanni ngwuma je jaꞌrima ara je acajidiyi giyuꞌrinanu yidi ngwüjï ngwanni ngwujuꞌru giyelenyanu yidi gerala. ");
INSERT INTO lro_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Nginde gwanni gwuminje üꞌrälü giyiima yidi dïrïm aar nje äbrï aar nje apada giyelenyanu yidi Gïjï güngün ganni gämnïng. ");
INSERT INTO lro_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","Üꞌrälü gwe gwudi yïn yüngün, Ngwaalu ngwuminje äbräjï keng gwege. ");
INSERT INTO lro_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Nginde gwuru dïꞌrïmbïl didi Ngwaalu ngwanni ngwaꞌti enggana ngwuru giꞌra gidi yiꞌral ꞌdar yanni yigeꞌta je Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","Ndi ari nginde gwe, yiꞌral ꞌdar yïgïꞌtïnä kerala aar gïꞌtïnï gïdïyängälü. Yanni yenggana na yanni yaꞌti enggana. Ya gu ru yani ngwuduꞌri, yiima, ngweleney na yeleny. ꞌDar yïgïꞌtïnä nginde gwe ndi ari aar näjï ngindeng. ");
INSERT INTO lro_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","Nginde gwuru gwuju gwerre gwerre giyiꞌral ꞌdar. ");
INSERT INTO lro_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","A nginde gwe a gu yiꞌral mätïnï ꞌdar. Nginde gwuru giꞌra gidi ngwanginu ngwudi giꞌdoonga. Nginde gwuru gwanni gwädäälü ngwuru giꞌra gidi ꞌdïꞌrï gwudi ngwüjï nunnu ngwuru gwanni gwuru giꞌra giyiꞌral ꞌdar. ");
INSERT INTO lro_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","Ndi ari nginde gwe, Ngwaalu ngwüjädï gu ndi ari ngwugeꞌte drü düngün ꞌdar ngwuji ndi Kirictu. ");
INSERT INTO lro_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","Ndi ari Gïjï ge güngün, Ngwaalu ngwuma gu gwäꞌräjïdï yiꞌralalu ꞌdar ꞌdünggüngün gïdïyängälü na kerala, geꞌte gwe adatingalu ngwuji yïn ye yüngün yanni yïrädälü küꞌrälä ganni gimamindanu. ");
INSERT INTO lro_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Nga nga gwele gwerre liru ngwïrnü lïꞌtüdänü ngaa ru güwän Ngwaalu gwani yaꞌrany na elelle gwalu gwanni gwuki. ");
INSERT INTO lro_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","Ngwaalu ngwuma je be gwäꞌräjïdï gweneno ngindenga le ngwanginu ngwe ngwudi Kirictu yïn ye yidi yiꞌrany yüngün. Nunnu ara je Kirictu inggidi lijuꞌru ngwäyänü ngwüngün lijaw nono laꞌti ätï yiꞌral nono yere. ");
INSERT INTO lro_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","Manari ngaa lïmätïnälü ꞌdidanu ndi ämnï Ngwaalu gwalu ngaa odanalu ndom, ngaa ꞌti gatana geꞌtajing gwudi Ngwujaꞌri ngwanni ngwujaw. Ngwujaꞌri ngwuru ngwee ngwanni ngwuꞌdingina je ngwondacara je ngwüjü ꞌdar gïdïdlä gïdïyängälü, ngwanni ngwurucu nje äny gwani Bulij dïnäd. ");
INSERT INTO lro_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","Äny gweneno, gwujayanu gïdïrbänü danni dijiny gwanu gwani nga nga ndi ari yiꞌrendeny ngwanginu ngwüny aar medaji yündä yidi Kirictu yanni yïꞌdälü kiꞌdoonga güngün ganni giru ngwanginu ngwüngün. ");
INSERT INTO lro_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","Ganni giminy ruci dïnäd gegeꞌte gwe gwudi Ngwaalu giyiiru yanni yätädäär nje gwani nga nga nunnu ngaa je enggaci ngwujaꞌri ngwudi Ngwaalu aar mbuti ꞌdar ");
INSERT INTO lro_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","ngwanni ngwuru yujimid yanni yändälü ngwüdlä a kimaad ganni gima ele. A be gweneno, yiming je be ꞌtäcä ngwüjälü ngwanni ngwujuꞌru. ");
INSERT INTO lro_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","Ngwüjï ngwüngün ꞌdar, Ngwaalu ngwugeꞌta ndi ngwe inggidi yujimida yüngün. Ngwubuping je ꞌdar ndi aar lenge ndi ari yujimid yüngün yojema guꞌru ngwuye gataji ngwüjü düwä ngwuru Garany. Yujimid yüngün giyee yiru ndi ari a Kirictu ji ꞌdanggalanu ꞌto nga nga lanni liru Garany, yäy gu no, ngaa ïcïnänü ndi ari ngaa la mbuji näjïng gwudi Ngwaalu gwanni gwaru nggwe. ");
INSERT INTO lro_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","A londaca ngwüjü ꞌdar ngwujaꞌri ngwe ndi Kirictu. Aar girinya ngwüjü ꞌdar ndi aar ꞌdengenaci Kirictung, aar je enggaci ꞌdar bebere gwe ꞌdar ngwanni gwätäär. A lärrä yiꞌral giyee ꞌdar nunnu a ngwüjï ꞌdar ngwanni ngwugekajidu ndi Kirictu, aji aar mbuti kaji ganni gadi aar je ge inggidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","Yiru giyee yanni yïgäbïcïny nyi ündïjï ngwäy yiima ye ꞌdar yüngün yanni giyo yapu yiiru ꞌdünggünyänü. ");
INSERT INTO lro_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","Nyi be mïnï ndi aang lenge ndi ari nggwundu ngwäy nunnu ngaa je gataji düwä na ngindenga lidi gündär gidi Lädükïyäng na ngwüjï ꞌdar ngwanni ngwaꞌtiny ngwe lingididu ngwäyänü gilingeno. ");
INSERT INTO lro_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","Nggwundu ngwäy nunnu ngaa orꞌtemaji giyigoranu ar gikajidi ndi ämnäjïdï. Äny gwümïnä je aang ätï onjacing gwanni gwujaw gwanni gwati ji manari ngaa lenge ngwujaꞌri ꞌdiꞌdidanu ngwudi Ngwaalu ngaa gu ïcïnädä ꞌdidanu. Nggwümïnä je ngaa ïcïnänü ꞌdiꞌdanu ngwujaꞌri ngwee nunnu ngaa lenge geꞌteng gwudi Ngwaalu gwanni gwaꞌting ꞌtäcä ngwüjälü gwerre a geꞌte nggwee, gwuru gwani Kirictu. ");
INSERT INTO lro_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","Gwanni gwülïbädï gu yuꞌrinalu yidi bebere na lenge ꞌdar. ");
INSERT INTO lro_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","Äny gwaru gu no nunnu aaꞌti gwere gwa je ïꞌdäjänü ara je ꞌduꞌdi ngwujaꞌri ngwe ara je dudiyi. ");
INSERT INTO lro_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","Minyi ni ari a laꞌti gilingeno, a gilo gwüpäng gïlïgïꞌrïm nggwujayanu ndi engga ndi ari ngaa gilo ligekajidu ngaa mätïnälü ꞌdïꞌdäny ndi ämnï ndi Kirictu. ");
INSERT INTO lro_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","A nono anaku ma gu ämnï ndi Yicu Kirictu gwuru Deleny, elellar gu be. ");
INSERT INTO lro_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","Lïdïrnïnä gu ngaa gu odanalu ndom lïmätïnälü ndi ämnï Ngwaalu gwalu anaku enggacara je gu a ci Ngwaalinga yäy ꞌtu ji ꞌdanggalu gwïrälü. ");
INSERT INTO lro_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","Arnganar ndi ari aaꞌti gwere gwa je ruji ngwïnäd ara je gatu mbüny bebere gwe gwudi dïdlä na ïrïngïnï gwe gwuru ꞌtur gwani yobo yidi ngwüjï na dïmürä didi dïdlä, yäꞌtüdï dïmürä dïndï kayalu didi Kirictu. ");
INSERT INTO lro_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","Ndi ari nginde gwani Kiricu, drü ꞌdar didi Ngwaalu ndo gu. ");
INSERT INTO lro_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","Na ngaa lima je gu mbutiyi. Nginde gwuru gwanni gwuru giꞌra gidi yeleny ꞌdar na gidi yiima ꞌdar. ");
INSERT INTO lro_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","A nginde gwe ꞌto, lima je üꞌrïdä üꞌrïdäng gwaꞌti äpïnä ngwuy ngwe ngwudi dïjï. Äbrï gwe kayanu drü dalu danni diki, üꞌrïdänï nggwee gwäpïnä Kirictu gwe. ");
INSERT INTO lro_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","(Ndi ari) gwuma le gätïnï nyïnyïnï gwe gwani yiꞌrany yüngün ngaa le ꞌdïꞌrï ämnï gwe gwalu giyiima yidi Ngwaalu ngwanni ngwüꞌdïꞌrïyälü giyiꞌranyanu. ");
INSERT INTO lro_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","Gwele gwerre, ngaa layu yiꞌrany yani ke gwalu, ngaa laꞌti üꞌrïdänä gïdrü danni diki, Ngwaalu ngwuma je be midiyi Kirictunga le. Ngwuminje düdänïjänü ꞌdar gwege gwanni gwuki ");
INSERT INTO lro_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","anni mung brotada yobalu mbüny yanni yüllïnä dïmürä dänü düngün danni dïnïjï nje, ngwuje äbrï kayanu aar pänï küꞌrï. ");
INSERT INTO lro_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","Anni mung je apada yiima na yelenya, liming je ꞌtäcï yaaralu yegen ngwuje roꞌtalu ngwuje dami yiꞌrany ye yüngün küꞌrï. ");
INSERT INTO lro_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Yäy gu no, aaꞌti ba be ngaa la gäbïcï dïjü dere ndi ara je üpäcï yiꞌral nono yere yani dïmürä ndi eny a ndi ïyï na yani yobo yidi yïꞌrïnyïnä, yijibeꞌrr yidi Düüwä Diyang a yani gomon Kwoꞌra täꞌrïl. ");
INSERT INTO lro_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Yiꞌral giyee yiru ngwüꞌrïmbïl ngwudi yiꞌral yanni yadi ji. A be yanni yiru ꞌdidanu, yiru yadi mbüjïnï ndi Kirictu. ");
INSERT INTO lro_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","Aaꞌti nga la gäbïcï yigoꞌro yalu ndi ara je dïjï ci ngaa ru ngwumulu ꞌtïꞌtïr ngaa äpïjï yïꞌrrä yobo. Giyee ya je gäbïcï ngaa laꞌti la ape guꞌru ganni gicara je ge Ngwaalu. Dïjï danni dati gu enggaci ngwüjü no, yiꞌral yüngün yärrïnä yeleny ye yidi yiꞌral yanni yarung ye yänggädïng je ngwäy ngwe ngwüngün. Nginde dïrïngïnä yiꞌral ye yidi yaꞌrany yüngün yanni yïꞌtüyüng je a be yere yätïng je nding gu ïrïngïnä. ");
INSERT INTO lro_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","Daꞌti mätïnälü kiꞌra ndi Kirictu gidi ngwanginu ku ngwanni ngwati gu digeꞌdani a gu ngwïrï na yirjeny mätïdänü gwüpäng a je Ngwaalu geꞌte aar ꞌtänü aar pe. ");
INSERT INTO lro_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","Yäy gu no, anni ma aang ayi Kirictunga le, gwani elelle gwudi yobo yidi dïdlä, ange gwuru mana ndi ari ngaa ji ndi elelle yobo ye yidi dïdlä. Ngaa üpïyï yigoꞌro yalu dïmürä danni dati ari, ");
INSERT INTO lro_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","“Aaꞌti a gwa määtä gony! Aaꞌti a gwa ngille gony! Aaꞌti a gwa akani gony nono?” ");
INSERT INTO lro_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Yiꞌral giyee ꞌdar yiru dïmürä didi ngwong ngwati äpïnï aar medadi. Ndi ari yïgïꞌtïnä yiru yobo aar ru ꞌdogo dïmürä didi dïjï dümnä. ");
INSERT INTO lro_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Yobo giyee yiru nono ma aar ru ꞌdiꞌdanu yidi bebere yidi äpäjï Ngwaling yobo üllïyï gwe yigoꞌranu ꞌtïꞌtïr aar joꞌrenya ngwanginu ngwegen, aar ꞌti be ätï guꞌranu gere ndi määtä lingeno lidi dïjï. ");
INSERT INTO lro_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","Ngaa lima ꞌdïꞌrï Kirictunga le, gäbïcär be ngaa bupi yiꞌral yanni giyo kerala ngwaalu ngwanni ngwo gu Kirictu kaama gidi Ngwaalu gani yeleny. ");
INSERT INTO lro_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","Ara je yigor päcï yiꞌralanu yidi gerala yani lïgïꞌrïm ngaa gu mätïnädä aaꞌti yani yiꞌral yidi lingeno gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Ndi ari ngaa lima ayi a midi gwalu gwanni gwuyang nggwo gwändälü Ngwaalu Kirictunga le. ");
INSERT INTO lro_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","Ma be aji ma Kirictu gwanni gwuru midi gwege ꞌtädälü, ngaa la be ꞌtädïnälü ꞌto ngindenga le ndi näjï gwüngün. ");
INSERT INTO lro_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","A be no, ꞌrïnyïtär be yiꞌral yidi lingeno lalu lidi dïdlä yani yïjïn, rngï gwudi lingeno, amiꞌra gwudi lingeno, bupi gwanni gwuki na ubanu gwani yobo yidi dïdülä yidi dïdlä. ");
INSERT INTO lro_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Yiꞌral giyee yiru yanni yati gäbïcï Ngwaalinga a güündä ji. ");
INSERT INTO lro_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","Ngaa lelella gu gwele gwerre ja gu gïdïdlä. ");
INSERT INTO lro_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","A be gweneno, äbrär je be ngaa je gatu mbüny giyee yiki ꞌdar yani, güündä, ꞌre ngwäy, yüꞌdüny, kiyi ngwüjänü, lo, ondaji yidiganya. ");
INSERT INTO lro_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","Aaꞌti ngaa lüꞌrïꞌtäjïdï yiꞌduru nono ndi ari ngaa lima gwällïnï lingina mbüny lanni luꞌrin a apepe gwüngün gwanni gwuki ");
INSERT INTO lro_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","a ngaa lima genne lingina lanni liyang, gilo lïꞌtüdï liyang ndi lenge gwani giꞌremna gidi Ngwaalu ngwanni ngwugeꞌta. ");
INSERT INTO lro_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","ꞌDünggüngün, yaꞌti yere giyee ndi ari nggwee gwuru Dïgïrïg, na nggwee gwuru Dïyäwüd. Nggwee gwüꞌrïdänä na nggwee gwaꞌti üꞌrïdänä. Nggwee gwuru Garany a nggwee gwaꞌti bebera. Nggwee gwuru dïnäd na nggwee gwäꞌtüdï dïnäd, a be Kirictu ru ꞌdar ngwaalu ꞌdar. ");
INSERT INTO lro_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","Yäy gu no, anni ranga ngwüjï ngwujuꞌru ngwäbrä je Ngwaalu ngwämnïng je, rüdär be giyomon reny ngwüjï ngwätï ïnäng, jaying liguri, okeye ligoꞌro, yimulu na orꞌtemaji. ");
INSERT INTO lro_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","Ngaa apajidi gwüpäng ngaa düdänïjïdänü gwüpäng giyiꞌral yere ꞌdar yanni yiki anaku ma ara je gu Deleny düdänïjänü. ");
INSERT INTO lro_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","Giyee ꞌdar yijaw, ngaa gendani ämnäjïdïng, gwanni gwati gekajidi ngwüjü ꞌdar gwüpäng ngwuje mbütï kürtü geꞌte pu. ");
INSERT INTO lro_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","A adatalu gwudi Kirictu ruyi yigor yalu anaku ra gu ngwüjï ngwudi ngwanginu ngweꞌte pu, lurnida je ndi aang jalu ladatalu. Ngaa ci Ngwaalinga yäy ꞌtu! ");
INSERT INTO lro_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","A ngwujaꞌri ngwudi Kirictu ji ꞌdanggalanu ara je nïyänü ngaa enggacidi ngaa olajidi bebere gwe ꞌdar gwüpäng, ngaa elnge mäjïmür, na deelnga didi ortada didi lïgïꞌrïm ngaa ci Ngwaalinga yäy ꞌtu yigor ye yalu yijayanu. ");
INSERT INTO lro_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","ꞌDar yere yanni yada je ärrï yani ondaji gwalu na apepe gwalu, ärrär je ꞌdar ngwürïny ngwe ngwudi Deleny dani Yicu, ngaa ci Ngwaalinga ngwuru Papa yäy ꞌtu nginde ngwe. ");
INSERT INTO lro_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","Lani ngwaw, ꞌdengenacar ngwuru ngwalu anaku mïnä gu Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","Lani ngwur, ämnär ngwayu ngwalu aaꞌti ngwa je ärrälü tïꞌtïꞌdäng. ");
INSERT INTO lro_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","Lani yïjï, ꞌdengenacar papanga je lalu giyiꞌral ꞌdar, ndi ari no yati jada Ngwaalinganu. ");
INSERT INTO lro_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","Lani papanga, aaꞌti ngaa la kiyi yïjänü yalu nunnu aaꞌti ya muli nono. ");
INSERT INTO lro_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","Lani ngwïnäd, ꞌdengenacar ngwelenya ngwalu ngwudi dïdlä giyiꞌral ꞌdar, ärrär je gu nunnu aaꞌti nono gwele ma ara je geꞌte ngwäy nono, a ndi ari ngaa je gäbïcï ara je ämnï, a je be ärrï yigor ye ꞌdiꞌdidanu yani denya Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","Yere yanni ya je ärrï, ärrär je yigor ye ku lundu ngwäy nono ma je ärrïjï Delenya, yaꞌti ani ngwüjï ngwümnä. ");
INSERT INTO lro_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","Ndi ari ngaa lïlïngïdï ndi ari nga la mbuji yuꞌrina Gideleny yani guꞌru galu. Ngaa liru ngwïnäd ngwäpïjä Delenya dani Kirictu yiiru. ");
INSERT INTO lro_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","A gwere gwanni gwapu gwanni gwuki, gwa mbuji keng gwani guꞌru güngün na utanu gwaꞌti. ");
INSERT INTO lro_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","Nga nga lanni liru ngwoorta, ärrär ngwïnädä ngwalu yiꞌral yijaw a yanni yïdünälü ndi ari ngaa lïlïngïdï ꞌto ngaa lätï Doorta dalu kerala. ");
INSERT INTO lro_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","Gwujar ndi otaci Ngwaalingalu ngaa jalu ngwäy ngwe nda je ci yäy ꞌtu. ");
INSERT INTO lro_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","Ngaa otaci Ngwaalingalu gwani nyängä ndi ari aar nje ïgïtïjï gay nyii ondaci ngwüjü ngwujaꞌri ngwudi Ngwaalu ndi ari yäy nyii mbuji gay ndi ondaci ngwüjü yujimida yani Kirictu yanni yïgäbïcïny nyi be genne giyirna ");
INSERT INTO lro_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","nunnu nje ondajalu gilingenalu anaku büpïnär gu ꞌdünggüny ndi nje ondaji. ");
INSERT INTO lro_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Beberar ndi elelle gwalu ngwüjï ngwe ngwaꞌti aang ngwe rüdï giꞌdonga geꞌte pu, ngaa burnani gaji ndi ärrï yiꞌral yanni yijaw. ");
INSERT INTO lro_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","Gäbïcär ondacing gwalu ngwüjï ngwe ngwonyadi yïmïꞌränü ngwuru nono enying gwami ngwümündä nunnu ngaa lenge ndi ari awa ma ara je dïjï otacalu, ngaa gwäꞌräcänü. ");
INSERT INTO lro_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","Diweengga dämnär dani Tiyakuj da je enggaci ngwujaꞌri ꞌdar ngwani änyängä. Gwuru dooꞌra diru ligor leꞌte pu nyii le ru ngwïnäd nyii ru gimaad Gideleny. ");
INSERT INTO lro_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","Gwükäcïny ꞌdanggalu ndi ara je abingaci gwani bupi nggwee ndi ari ngaa lenge änyängä gilo liru ꞌtaa a nunnu ara je ojemeye yigor nono yalu. ");
INSERT INTO lro_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","Nggwo gwïndär Onejemo gwe gwuru diweengga dege diru ligor leꞌte pu dämnär gwanni gwacajida le kiꞌdoonga geꞌte pu. La je ondaci ngwujaꞌri ꞌdar ngwanni ngwo ngwärrïnä ngene. ");
INSERT INTO lro_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","Gur giru gimaad güny gigenniiny ge gani Arictakuj, gaganna je a ꞌto Murkuj gwuru dïgrü ndi Birnaba (lima je ükäcä ngwujaꞌri ngwani nginde. Mung ila, ülläjärälü gora gijaw.) ");
INSERT INTO lro_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","Yicu gwani Yujtuj, gwaganna je ꞌto. Liru gilee ꞌdogo lanni liru Ngwüyäwüd ngwüjänü ngwüny ngwanni ngwuru nyii ngwe gimaad giyiiru yidi yeleny yidi Ngwaalu liru lundiyiny ngwäy aar nyi orꞌtemaji gwulleny. ");
INSERT INTO lro_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","Ababraj, gwanni gwüꞌtüdï kiꞌdoonga galu gwuru dïnäd didi Yicu Kirictu, gwaganna je. Gwata je jicalu no ngwäy ngwe yomon reny ndi otaci Ngwaalingalu gwani nga nga ndi ari ngaa mätïnälü ꞌdïꞌdäny ndi bupi ꞌdar gwudi Ngwaalu ämnï gwe gwanni gwumbutu ngaa gu ojemada ngaa gu ïcïnädä mama. ");
INSERT INTO lro_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","Gwa je gwe ci ndi ari nginde nggwo gwündïjä je ngwäy gwulleny ngwuje ündïjï ngwäy ꞌto gwulleny lidi giꞌdoonga gidi Lädükïyäng na lidi Arabulijing. ");
INSERT INTO lro_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","Dimaad dege diru akim dani Luka, a diweengga dani Dimaj, laganna je. ");
INSERT INTO lro_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","Agannar ngwengga ngwudi Lädükïyäng a gera giru diweengga gani Nimbaj na ꞌto giꞌdoonga gidi ngwïkïrïjïn ngwanni ngwati acajidi ngwuꞌdun ngwüngün. ");
INSERT INTO lro_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","Ma ara je ülïjï ngwujaꞌri ngwee ngwükäcä je, ngaa je be dinga ꞌto aar je ülïjï ngwükïrjïnä kiꞌdoonga gidi Lädükïyäng, ngaa je apa ngwanni ngwo ꞌdenggen ngaa je uli ꞌto ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","Car Arikipujing nu, “Arngana yiiru nga je medaji yanni yima je ape Gideleny.” ");
INSERT INTO lro_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","Äny gwuru gwani Bulij gwullu aganning nggwee guy ge güny. Diwayiniiny giyirna yüny. Ara je gu yïmïꞌrü ji.");
INSERT INTO lro_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Ngwujaꞌri ngwee ngwïndï ꞌdänggärï äny gwani Bulij na ngweengga ngwani Jiliwanij na Timijawuj, ngwükäcï nje giꞌdonga gidi Täjlänükïng gidi Ngwaalu ngwuru Papa gwege na Deleny dani Yicu Kirictu. Ara je gu yïmïꞌrü na adatalu ji. ");
INSERT INTO lro_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Yomon reny nyii lati ci Ngwaalinga yäy ꞌtu gwani nga nga ara je diwayini ndi otaci Ngwaalingalu gwärï. ");
INSERT INTO lro_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","Nyii lati diwayini yiiru yalu giyomonalu ꞌdar ngwäyänü Ngwaalu ngwege ngwuru Papa yanni yima je ätï ämnï gwe Ngwaalu. Nyii diwayini yiiru yanni yunda gu ngwäy ämnï gwe, nyii diwayini orꞌtemajing gwalu gwanni gwugeꞌtajangaa Gideleny dege dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Nunnu a lïlïngïdï lani ngweengga ngwämnä je Ngwaalu ndi ari nginde gwuma je äbrï, ");
INSERT INTO lro_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","ndi ari ngwujaꞌri ngwanni ngwujaw ngwondacara je, ngwaꞌti ara je ondacu ngwulem ngwe ꞌdogo, ara je be ondaci ꞌto yiima ye Lïgïꞌrïm le lanni Lijuꞌru ngaa gu ïcïnädänü ꞌdidanu. Ngaa lïlïngïdï ndi ari awa nyii lelella ꞌdanggalanu gwani nga nga. ");
INSERT INTO lro_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Ngaa liminje ärnänü ndi elelle gwärï ngaa ärnï elelleng gwudi Deleny, ngaa ji gïdïrbänü dipa. Ngaa liꞌdingina ngwujaꞌri ngwätädärä je yigor ye yijayanu ngwïndï Gïlïgïꞌrïm lanni Lijuꞌru. ");
INSERT INTO lro_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","A gu no, ngaa lima ru gora gidi ngwïkïrïjïn ꞌdar Majiduniya na Akayiya. ");
INSERT INTO lro_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Ngwujaꞌri ngwudi Deleny ꞌdanggalanu ngwuma ꞌtü ngwuma badalu Majiduniya na Akayiya ämnï Ngwaalu gwalu gwuma linginni ngwaalu ꞌdar. Yäy gu no, yere yaꞌti yadi nyii ye ari gwani ämnï Ngwaalu gwalu. ");
INSERT INTO lro_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Ndi ari ngindenga yigoꞌro yegen londaja ndi ari awa ngaa läpïjï nje yiiru na awa ngaa lima oꞌraca Ngwaalinga kay gidi äpïjï yiꞌremna yobo ngaa äpïjï Ngwaalinga yiiru ngwanni ngwumidu ngwuru ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Ngaa jici Gïjälü güngün gani Yicu ganni gïꞌdïꞌrïyïngälü giyiꞌranyanu ndi üllä kerala gwanni gwati nje gätäjï gündä ganni nggo gïndï. ");
INSERT INTO lro_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Ngaa lïlïngïdï lani ngweengga ndi ari ila gwärï ꞌdanggalu gwäꞌtüdï ꞌtur. ");
INSERT INTO lro_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Anaku lïngïdä gu gwerre ndi ari nyii liju gïdïrbänü dipa aar nje ngwüjï ngwudi Bïlïpïng loda, aar nje gu be Ngwaalu ji nyii ädïnï ndi ara je ondaci ngwujaꞌri ngwüngün ngwanni ngwujaw ngwanni ngwübïnäär jälü gwulleny. ");
INSERT INTO lro_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Ndi ari päcälü gwärï gwaꞌti äpïnä ngwujaꞌri ngwe ngwudi dudi na yigor ye yïrngü, ara je ꞌti mïmïnäjänü. ");
INSERT INTO lro_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Aar be manni ru ndi ari londaca je liru ngwüjï ngwügwällïnä ngwe Ngwaalu ndi ari ngwundu ngwäy ngwuje ätädä ngwujaꞌri ngwüngün ngwanni ngwujaw. Nyii laꞌti bupa ndi jada ngwüjänü, libupa ndi jada Ngwaalinganu ngwanni ngwüdïdïmä yigor yärï. ");
INSERT INTO lro_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Ngaa lïlïngïdï ndi ari laꞌta je mamiꞌranu ngwujaꞌri ngwe, laꞌti änïjä yigoꞌralu yärï nyii gu arri ꞌtïꞌtïr gwani ubanu, Ngwaalu ngwuru ngwänggädï nje. ");
INSERT INTO lro_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Laꞌti bupa ngwüjü, ara je ꞌti bupa na ngwüjï ngwuꞌter ndi nje ortada. ");
INSERT INTO lro_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Anaku ru nyii gu ngwooꞌra ngwükäjäär je ngwudi Kirictu, laada je äbïngïnänü. Nyii be ji ꞌdanggalu lïjïlänü nono nanning gwarngana yïjü yüngün yanni yooko. ");
INSERT INTO lro_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Lämnä je gwulleny ꞌdi nyii ꞌti jädï ndi ar acajidi ngwujaꞌri ngwanni ngwujaw ꞌdogo, nyii be jada ꞌto ndi ar acajidi ndi elelle gwärï ndi ari lämnä je gwulleny. ");
INSERT INTO lro_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","ꞌDidanu ngaa lidiwayina lani ngweengga yiiru na dïrbä därï, nyii lapu yiiru dilu de nje ape lingen le nunnu aaꞌti nyii läbïngïnï dïjänü dere gaji ganni giju nyii ge ndi ara je ondaci ngwujaꞌri ngwe ngwanni ngwujaw ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Ngaa länggädï a Ngwaalu engga ꞌto ndi ari awa nyii lijuꞌru, nyii dünälü, nyii jayi nono, awa nyii liju ꞌdanggalanu lanni lämnä Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Ndi ari ngaa lïlïngïdï lärrä je ꞌdar nono gwele ati gu papa ärrï yïjü yüngün, ");
INSERT INTO lro_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","ara je ojemeye nono ara je orꞌtemaji ara je päcälü ndi aang elelle elelleng gwanni gwädï Ngwaalu ngwanni ngwurnida je giyelenyanu yüngün na ndi näjï gwüngün. ");
INSERT INTO lro_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Änyängä lica Ngwaalinga yäy ꞌtu ꞌto gwurꞌtal ndi ari, anni ma aang ape ngwujaꞌri ngwudi Ngwaalu ngwanni ngwuꞌdingina je ꞌdänggärï, ngwaꞌta je apu nono ma aar ru ngwujaꞌri ngwudi ngwüjï ngwümnä, aar be ru ꞌdidanu aar ru ngwujaꞌri ngwanni ngwo ngwapu yiiru ꞌdanggalanu lanni lämnä Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Ndi ari nga nga lani ngweengga, loꞌrana yiꞌdonga yidi Ngwaalu Yäwüdïyä yanni giyo ndi Yicu Kirictu. Ngwüjï ngwalu ngwïcä je dïrbä deꞌte deꞌte danni dïcä Ngwüyäwüd yiꞌdonga Yäwüdïyä gwerre, ");
INSERT INTO lro_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","ngwanni ngwüꞌrïnyïtï Delenya dani Yicu aar ꞌrinye ngwïjïrä ꞌto aar nje linynya poor. Ngwaꞌti je Ngwaalu jädänü aar ïnïjï ngwüjü ꞌdar ");
INSERT INTO lro_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","yiima ye yegen aar nje etaci ndi ondaci ngwüjü ngwuru Garany nunnu aaꞌti ngwa mbuji gilanging. Gay ge nggee, lati maa keng gwegen ngwuje mbuti nono. Güündä gidi Ngwaalu gima je ïꞌdädä nono gwodanalu. ");
INSERT INTO lro_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","A be lani ngweengga, anni ma ar badatanu gaji gooko gilingeno a laꞌti badatanu giyigoranu, jada gwe gwärï gwulleny gwani nga nga, nyii bupi yiima ye yärï ꞌdar ndi oꞌra ara je engga. ");
INSERT INTO lro_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Ndi ari nyii libupa ndi ila ꞌdanggalu, ꞌdidanu gwece gwece äny gwani Bulij nggwubupa gu nyi oꞌre nyi gu bupi, a nje be dijegoꞌrr jici kay. ");
INSERT INTO lro_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Ndi ari geꞌtaji gwärï gwani yärü, jayanu gwärï gwani yärü, na giꞌriba gidi yeleny ganni gadi nyii ge ïrïngïnï ngwäyänü Gideleny dege dani Yicu ma ji mung ila, gani yärü? Nga nga läꞌtüde? ");
INSERT INTO lro_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","ꞌDidanu, nga nga liru lani näjï gwärï ngaa ru jayanu gwärï. ");
INSERT INTO lro_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Gwodanalu, anni minyii ꞌti burna ndi geraji länï gwani badatanu gilingeno, nyii ïrïyï ngwäyälü ndi ari yijayana aar nje gatanalu jücü nyii jalu Ätïnä. ");
INSERT INTO lro_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","Nyii ükäjä diwengga dege dani Timijawuj, gwanni gwuru nyii le gimaad ndi ape yiiru Ngwaalinga le yidi bädïyï ngwujaꞌralu ngwanni ngwujaw ngwudi Kirictu, ndi ara je orꞌtemaji ara je ojemeye nono ndi ämnï Ngwaalu gwalu, ");
INSERT INTO lro_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","nunnu aaꞌti gwere gwa ji gwaꞌti mätïnälü ndi mïmïnnï nono nggwee. Ngaa lïlïngïdï mama ndi ari alanga liru ngwïkïrïjïn gay gege giru ndi mbuji dïrbä no. ");
INSERT INTO lro_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Yiru gu ndi ari anni jar, lata je ondaci yomon ꞌdar ndi ari ngwüjï ngwunje übïnälü. A yima gu ru no anaku lïngïdä gu mama. ");
INSERT INTO lro_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Ndi ari yiru giyee yanni yïgäbïcïny anni minyi ꞌti burna ndi geraji länï, nyi ükäjïdä ndi nyi lenge ämnï gwe Ngwaalu gwalu yorta ye ngwaalinga. Yedeny yïtïny ndi ari ngwaalu ngwere rïgüm, dijegoꞌrr dima je ïdäjï na undi ngwäy gwärï ngwaalu ngwere gwuma ru ꞌtur. ");
INSERT INTO lro_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","A be anni ma Timijawuj oꞌra ꞌdanggalu gweneno, gwuminje äpïjä ngwujaꞌri ngwujaw ngwuminje ꞌdingini ngwani ämnï Ngwaalu gwalu na ämnï gwalu. Aar nje ondaci ndi ari ngaa lati nje diwayini giyomonalu ꞌdar diwayining gwujaw ndi ari ngaa lïmïnä ndi nje engga, nono raar gu ꞌto ꞌdänggärï ndi ari lïjädï ndi ara je engga. ");
INSERT INTO lro_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Yäy gu no, lani ngweengga, gïdïrbä därï ꞌdar na ndi übïnälü gwanni gwübïnäär nje gwe ngwüjälü, nyii lorꞌtemaja gwani ämnï Ngwaalu gwalu. ");
INSERT INTO lro_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","A gweneno ꞌdiꞌdanu nyii lijalu limidu, anni määtïnängälü ꞌdïꞌdäny Gideleny. ");
INSERT INTO lro_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Awa nyii ci Ngwaalinga yäy ꞌtu gwonyadu gwani nga nga lanni liminje gäbïcï lima jayanu ngwäyänü Ngwaalu ngwege? ");
INSERT INTO lro_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Dilu de na lingen le lati otaci Ngwaalingalu gwonyadu yigor ye ꞌdar ndi ari a gay ji ara je engga mana ara je gu gendaci yanni yamiꞌrata gu ndi ämnï Ngwaalu gwalu. ");
INSERT INTO lro_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Gwenene gäbïcär a Ngwaalu ngwege ngwuru Papa ligoꞌro le lüngün na Deleny dege dani Yicu, jaꞌrima gay ndi ari nyii ila ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Ara je Ngwaalu gendaci ämnïng gwalu ngwïrälü ꞌdanggalu na ngwüjï ngwuꞌter ꞌto anaku ru gu ämnï gwärï ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Ara je ojemeye yigor nono yalu nunnu ngaa ji nga jayi nono ngaa juꞌri ngwäyänü Ngwaalu ngwuru Papa gwege ma ji ma Deleny dege dani Yicu oꞌra ngwüjï ngwe ngwüngün ꞌdar ngwanni ngwujuꞌru. Yiru gu. ");
INSERT INTO lro_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Gwodanalu lani ngweengga, lenggaca je awa ndi aang elelle nunnu ngaa jada Ngwaalinganu, ꞌdidanu ngaa gilo lelella gu. La je otacalu gweneno ara je päcälü ngwürïny ngwe ngwudi Deleny dani Yicu nda je ärränï giyee mama. ");
INSERT INTO lro_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Ndi ari ngaa lïlïngïdï enggacing gwanni gwenggacara je yeleny ye yidi Deleny dani Yicu. ");
INSERT INTO lro_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Bupi gwuru gwudi Ngwaalu ndi ari ngaa jüꞌrïnï ngaa gäbïcï yïjïnä. ");
INSERT INTO lro_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","A dïjï deꞌte deꞌte lenge ndi määtä ngwangina ngwüngün gay ge ganni gijuꞌru giru denya, ");
INSERT INTO lro_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","aaꞌti ïcïnänü gwa ru gwudi ꞌduꞌdi gwudi lingeno nono ngwüjï ngwudi dïdlä ngwanni ngwaꞌti lïngïdï Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Na yiꞌral ye giyee no, aaꞌti gwere gwa äpïjï gwenggen yiꞌral yanni yiki nggwe rtadanu ngwärräjï ngwiya goralu. Deleny daji da reraji ngwüjü gwani yiꞌral ꞌdar yanni yiki yiru gu no, anaku abingacara je gu gwerre ara je gu girnya. ");
INSERT INTO lro_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Ndi ari Ngwaalu ngwaꞌti nje ornaca yirledo ngwornaci nje elelleng gwanni gwujuꞌru. ");
INSERT INTO lro_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Yäy gu no, gwanni gwa obe ngwujaꞌri ngwee gora ge, gwaꞌti übïdï dïjü dümnä gora ge a be Ngwaalu ru ngwübïdïng je gora ge ngwanni ngwati je ätädä Lïgïꞌrïmä lüngün lanni Lijuꞌru. ");
INSERT INTO lro_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Gweneno gwani ämnäjïdï yengga, nyii laꞌti jädï ndi ara je üllïjä ndi ari nga nga yigoꞌro yalu Ngwaalu ngwuma je enggaci ndi ämnäjïdï. ");
INSERT INTO lro_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Na ꞌdidanu, ngaa lati ämnï ngwengga ꞌdar ngwudi Majiduniyang. Ara je be päcälü lani ngweengga nunnu ngaa gu gendadani. ");
INSERT INTO lro_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Geꞌtar je giyee aar ru yigor yalu ndi ari ngaa elelle elelleng gwanni gwadatalu, ngaa ombaji yiiru yidi yigoꞌro yalu ngaa ape yiiru ngwuy ngwe ngwalu anaku ondacara je gu, ");
INSERT INTO lro_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","nunnu a ngwüjï poor denya elelleng gwalu nunnu aaꞌti ngaa la ru ngwamiꞌri ndi äbïngïnï ngwüjänü. ");
INSERT INTO lro_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Lani ngweengga, laꞌta je nana ndi aang ꞌti lïngïdï yiru ange yani ngwïkïrïjïn ngwanni ngwuma ayi, na aaꞌti ngaa la runi nono ngwüjü ngwuꞌter ngwanni ngwaꞌti ätï geꞌtajing gwere. ");
INSERT INTO lro_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","A lämnä Ngwaalu ndi ari Yicu gwayu ngwüꞌdïꞌrä mana, no a lämnä Ngwaalu ndi ari Ngwaalu ngwa ji ngwa ꞌdïꞌrïyä ngwüjälü ngwanni ngwuma ayi ngwämnä ndi Yicu anaku ꞌdïꞌrïyüng Yicungalu. ");
INSERT INTO lro_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Anaku aru gu Deleny ngwulem ngwe ngwüngün, la je ci ndi ari alanga lanni gilona limidu, lanni gilo lijalu limidu ꞌdi ma Deleny oꞌra, ꞌdidanu a laꞌti la madina ngwüjü ngwanni ngwuma ayi. ");
INSERT INTO lro_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Ndi ari Deleny ligoꞌro le lüngün da üllä kerala dulu de dipa na urnidi dula gwudi deleny didi yïꞌrr na urnidi gwe gwudi giboꞌreny gidi Ngwaalu, lanni layu ndi Kirictu la ꞌdïꞌrälü gwerre gwerre. ");
INSERT INTO lro_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","A be gwodanalu, alanga lanni gilona limidu lijalu, la aar nje le uti gïyïbäꞌrälä ar mbudi Delenyinga le gidurnala. A no, a la ji Delenyinga le bupud. ");
INSERT INTO lro_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Yäy gu no, orꞌtemajidar ngwujaꞌri ngwe ngwee. ");
INSERT INTO lro_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Gweneno lani ngweengga, ngwujaꞌri ngwani gaji na yomon nyii laꞌti jädï ndi ara je üllïjä, ");
INSERT INTO lro_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","ndi ari nga nga lïlïngïdï mama ndi ari gomon ganni gadi ge Deleny oꞌra, giru nono gwele ilang gwudi duꞌram dilu de. ");
INSERT INTO lro_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Gaji ma ngwüjï ji ndi ari, “Yiꞌral ꞌdar giyo yadatalu yere yaꞌti,” a je be dudi dibajalu nono gwele ati gu yajima dibaji dayalu diju lari le. Na laꞌti la mbuji gay gidi abri. ");
INSERT INTO lro_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","A be nga nga, lani ngweengga, nga nga laꞌti gïdïrïmänü nunnu aadi ara je gomon nggäꞌdï dibajalu nono duꞌramu. ");
INSERT INTO lro_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Nga nga ꞌdar liru yïjï yidi buri ngaa ru yïjï yidi lingen. Läꞌtüdï yïjï yidi dilung na dïrïm. ");
INSERT INTO lro_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Yäy gu no aaꞌti a la ndri nono ngwüjü ngwuꞌter, ar be jalu ngwäy ngwe ar arngani ar määtä yigoꞌro yege. ");
INSERT INTO lro_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Lanni lati ndri, lati ndri dilu de, na lanni lati rlälï, lati rlälï dilu de. ");
INSERT INTO lro_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","A be alanga liru ngwüjï ngwudi lingen, ar be määtä yigoꞌro yege, ar gwodananu ämnï gwe Ngwaalu ar ätï ämnïng ngwuru nono lärü ar le äꞌrïnyïnï ngwambanga, ar ätï geꞌtajing ndi gilang ngwuru nono gibumbu ar ge äꞌrïnyïnï yiꞌra. ");
INSERT INTO lro_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Ndi ari Ngwaalu ngwaꞌti nje utanu nunnu aar nje yiꞌrendeny eny nono yidi güündä güngün, aar be ru ndi ari ar mbuji gilanging Gideleny dege dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Ndi ari Kirictu gwayu gwani alanga nunnu ar le midi gwüpäng mung oꞌra aar nje mbuji gilona lijalu limidu yaa aar nje mbuji a lima ayi. ");
INSERT INTO lro_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Yäy gu no, orꞌtemajidar ngaa olajidi giyigoꞌro yalu gwüpäng, nono anaku ꞌdidanu giyo yapa je gu. ");
INSERT INTO lro_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Lotaca jalu gweneno, lani ngweengga, ndi ari dïnyädär je lanni gilo lapu yiiru ꞌdanggalanu lanni liru yiꞌra yalu na ngwoorta ngwalu ndi elelle gwalu Gideleny aar je ola. ");
INSERT INTO lro_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Dïnyädär je denyang gwupa ngaa je ämnï gwani yiiru yegen yanni yati aar je ape. Jaralu ladajidalu. ");
INSERT INTO lro_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","La je päcälü lani ngweengga ndi ari, ülädär ngwamiꞌri, orꞌtemajar ngwudenyo, gatajar je düwä lanni lamiꞌratu, mätär yigor gwani ngwüjï ꞌdar. ");
INSERT INTO lro_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Arnganar ndi ari aaꞌti dïjï da gwäꞌräcï dïjänü giyiꞌral yüngün yanni yiki yiꞌral ye yanni yiki, ngaa be jayidi ngwäy giyomon ꞌdar na ngwüjï ꞌdar ngwuꞌter. ");
INSERT INTO lro_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Jayaranu giyomon ꞌdar, ");
INSERT INTO lro_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","otacar Ngwaalingalu giyomon ꞌdar, ");
INSERT INTO lro_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","car Ngwaalinga yäy ꞌtu giyiꞌralalu ꞌdar. Ndi ari Ngwaalu ngwuru ngwubupa gu no ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Aaꞌti ngaa la ꞌrinye lïgä lidi yiiru yidi Lïgïꞌrïm ꞌdanggalanu. ");
INSERT INTO lro_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Aaꞌti ngaa la ci yïjïrälü mireny, ");
INSERT INTO lro_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","ngaa be ïrïyï yiꞌral ngwäy nono ꞌdar. Apar je yanni yijaw. ");
INSERT INTO lro_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Abrar je yere ꞌdar yanni yiki. ");
INSERT INTO lro_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Ara je Ngwaalu ngwanni ngwuru adatalu giligoꞌro lüngün juꞌriyi ꞌdar. Ngwurime lïgïꞌrïmä lalu, ngwurime lingina lalu ngwurime ngwangina ngwalu nunnu aar jayi nono komon gadi ge Deleny dani Yicu Kirictu oꞌra. ");
INSERT INTO lro_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Gwanni gwurnida je gwuru ligor leꞌte pu ying je ärrï. ");
INSERT INTO lro_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Lani ngweengga, otacar Ngwaalingalu gwani änyängä. ");
INSERT INTO lro_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Agannar ngwengga ꞌdar giyenenanu aganni gwanni gwujuꞌru. ");
INSERT INTO lro_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Nggwa je päcälü ngwäyänü ngwudi Deleny ndi ari ngaa ülïjï ngwengga ngwujaꞌri ngwee ꞌdar ngwüllïjä je. ");
INSERT INTO lro_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Ara je gu yïmïꞌrü ji ku yidi Deleny dani Yicu Kirictu.");
INSERT INTO lro_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Äny gwuru gwani Bulij gwanni nggwo giyirna gwani ondaci ngwüjü ngwujaꞌri ngwani Yicu Kirictu. Diweengga dege dani Timijawuj daganna je. Ngwujaꞌri ngwee ngwükäcï nje dimaada dani Bïlïmün danni diru nyi de gimaad ndi apajidi yiiru yidi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","Nyi aganni diwengga dege dani Apibiya na diweengga dani Arikibiyuj gwanni gwati nyii le ape yiiru yidi Yicu Kirictu yongra na nyi aganni giꞌdonga gidi Ngwaalu ganni gati acajidi ngwuꞌdun ngwunga. ");
INSERT INTO lro_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Ara je gu yïmïꞌrü na adatalu ji gwudi Ngwaalu ngwanni ngwuru Papa gwege na Deleny dani Yicu Kirictu! ");
INSERT INTO lro_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","Äny gwati ci Ngwaalinga yäy ꞌtu giyomon ꞌdar gwani nga minje otacalu. ");
INSERT INTO lro_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","Anaku ati nyi gu ꞌdingini ngwüjï yïkïrïjïïn ye yunga Gideleny dani Yicu na ämnï gwe gwunga ngwüjü ku ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","Nyi be ari, a acajidi gwudi ämnï gwunga ngwüjïngä le ngwudi Ngwaalu ru ꞌdidanu nunnu nga ätï bebereng ꞌdar giyiꞌral yanni yijaw nda je ärrï ngwürïny ngwe ngwudi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Äny gwujayanu gwulleny nyi ojeme nono gwani mengga ämnï gwe gwunga ngwüjü ngwudi Ngwaalu. Anaku ma gu gäbïcï yigor yegen yima amanu. ");
INSERT INTO lro_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","A be no, gwani mengga, ndi Kirictu nggwaadi ꞌranu, ndi ang girnya dulu de nyi ärrïjï yiꞌral giyee. ");
INSERT INTO lro_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","A be anaku ätï nda gu ämnïng Ngwaalu a ngwengga Ngwaalu, nyi be ari nunnu nggwadi ang päcälü aaꞌti nunnu madinani gwüny ꞌdogo, a be ꞌto anaku jiny gu giyirna yani ondaci gwe güny ngwüjü ngwujaꞌri Gideleny dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","Äny gwüpäcängälü gwani diweengga dani Onejemo gwanni gwuma ru nono gïjï güny, äny gwuma ru nono papa gwüngün anni jiny giyirna. ");
INSERT INTO lro_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Nginde gwele gwerre gwaꞌti ämbädï ꞌdunggunga, a be gweneno, gwuma be amba ꞌdengge. ");
INSERT INTO lro_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Äny gwuminyi gwäꞌrä aar ang oꞌraca gwani nono ma ang üꞌrïcä ligor lüny. ");
INSERT INTO lro_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","Gwunaniny aadi aar nyi jicalu gito gito nunnu ngwuji ngwaalu ngwunga ati aar nyi äpïjï yiiru anaku jiny gu giyirna gwani ondaci ngwüjü nguwjaꞌri ngwanni ngwujaw ngwudi Yicu. ");
INSERT INTO lro_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Nyi ꞌti be jädï ndi ärrï yiꞌral yere yaꞌti ye ligor lunga aru nunnu yere yanni yijaw ya je ärrï na je ärrï ligor lunga aaꞌti ya aar je linyaci yiima ye. ");
INSERT INTO lro_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Ya gu mine ru ndi ari nginde gwugatananga giyomon giyee cong, nunnu aar ang oꞌraca gwurꞌtal. ");
INSERT INTO lro_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Nginde gwaꞌti ba be rüdï nono dïnäd ꞌdunggunga ꞌdogo, nginde gwupana gïdïnäd. Nginde gwuma ru diweengga danni dämnär. Ndi ari nginde gwuma ru dïkïrïjïn Ngwaalu. Gwämnïny gwulleny a be gwa ang ämnänï gwulleny ꞌdünggüny nono dïnädä dunga a dïkïrïjïn Gideleny dani Yicu. ");
INSERT INTO lro_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","A no, manari nga gwatiny engga nono dimada ndi apajidi yiiru yidi Kirictu, mätï Onejemong nono aadi nyi gu määtä. ");
INSERT INTO lro_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","A be manari nginde gwärrïjängä yiꞌral yere yiki, yaa gwümïnädängä dämjä nono dere, gäbïcä giligoꞌro lüny. ");
INSERT INTO lro_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Äny gwani Bulij äny gwullu ngwujaꞌri ngwee guy ge güny äny gwa ang ꞌtücï. Äny gwaꞌti jädï ndi ang ci äny gwümïnädängä dämjä nono dani ligoꞌro lunga ndi ari äny gwuru gwurujanga dïkïrïjïn Ngwaalu guy ge güny. ");
INSERT INTO lro_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","Yäy gwani mengga gäbïcïny nyi mbuji jaying ngwäy ꞌdunggunga Gideleny, gäbïcä ligor lüny ngwamanu ndi ari nga gwuru dïkïrïjïn ndi Kirictu. ");
INSERT INTO lro_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","Äny gwülïngïdï ndi ari ngwujaꞌri ngwee ngwuca je ngwe ngwa ji ngwa je ämnï ꞌdi nga gwäꞌtüdänälü ngwa je ärrï ngwanni ngwonyadana. ");
INSERT INTO lro_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Nga be ci ꞌto, gïꞌtïjïny ngwuꞌduna mama ngwanni ngwadi nyi gu ila nyi gu üllälü ma Ngwaalu ämnä otacing gwalu ndi ari aar nyi ïgïtïjä gay nyi ila ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Diweengga dani Ababraj danni diju nyi de giyirna gwani ondaci ngwüjü ngwujaꞌri ngwudi Yicu, dagana je ");
INSERT INTO lro_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","na ngwooꞌra ngwuru gimaad güny ngwani Murkuj na Arictakuj na Dimaj na Luka, laganna je ꞌto. ");
INSERT INTO lro_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Ara je gu yïmïꞌrü ji ꞌdar yidi Deleny dani Yicu Kirictu.");
INSERT INTO lro_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","Gwerre Ngwaalu ngwondaca ngwïjïrä aar ondaci ngwügürnä ngwege ngwujaꞌri ngwe ngwani Ngwaalu yomonanu yonyadu na ngway ngwe ngwonyadanu, ");
INSERT INTO lro_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","a be giyomon giyee yidi gwodaning, gwuminje be ükäcä Gïjü güngün aar nje ondaci ngwujaꞌri ngwüngün, ganni giming ätädä yuꞌrina yidi yiꞌral ꞌdar, na ganni gigeꞌteng ge dïdläyü. ");
INSERT INTO lro_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","Gïjï giru enyanu gwudi näjï gwudi Ngwaalu ngwulingani giꞌremna güngün ꞌdidanu, ngwümätädä yiꞌral ꞌdar ngwuje ruyi yiima ye yidi ngwujaꞌri ngwüngün. Anni ma aar nje gaꞌru gwani ke gwege, nginde gwuma jalu kaama gidi Ngwaalu ngwanni ngwuru Papa gwupa kerala. ");
INSERT INTO lro_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","No nginde gwuma aar ätädä ngwaalinga ngwupana gïyïꞌrr anaku ru gu ngwürïny ngwüngün ngwanni ngwuma aar je ätädä ngwani Gïjï ngwupana ngwürïny ngwegen. ");
INSERT INTO lro_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","Ndi ari Ngwaalu ngwaꞌti ca gïꞌrrä gere ngwujaꞌri ngwanni ngwondacung ngwe Kïjü güngün ngwuci, “Nga gwuru Gïjï güny. Gwene äny gwuma ru Papa gwunga.” Ngwoꞌre ngwari, “Äny gwa ru Papa gwüngün na nginde gwa ru Gïjï güny.” ");
INSERT INTO lro_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","Na mana anni ma Ngwaalu ükäjä Gïjü güngün ganni giru giꞌra gïdïdlä ngwari, “A yïꞌrr ꞌdar yidi Ngwaalu gwucalu yirku ye.” ");
INSERT INTO lro_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","Na ndi ondaji gwani yïꞌrr, a nginde ari nu, “Gwugeꞌta yïꞌrrä yüngün yiru dirun ngwugeꞌte ngwïnädä ngwüngün lïgä liru lingla.” ");
INSERT INTO lro_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","A be ndi ondaji gwani Gïjï, nginde gwaru nu, “Yeleny yunga gwani Ngwaalu yadi jalu pupud, nga gwa ruyi yelenya yunga gay ge gïdünälü. ");
INSERT INTO lro_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","Yima je ämnï yanni yïdünälü nga je be ꞌdonya yanni yiki yäy gu no, Deleny diru Ngwaalu ngwunga, dima ang mädïnïyänï kimaad gunga jayanu gwe gwanni gwuma ara gwe bruti yelenya.” ");
INSERT INTO lro_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","Nginde gwaru ꞌto, “ꞌTuꞌtu gwerre, gwani Deleny, nga gwugeꞌta dïyäng nga geꞌte gere yiiru ye yidi guy gunga. ");
INSERT INTO lro_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","Giyee ya medadi, a gwa be jalu. Ngwa mani ꞌdar ngwa ru nono ati gu ngwured mani. ");
INSERT INTO lro_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","Ngwa je ꞌrïkäjänü nono gwele ngwureda ngwa gwurli nono ati gu ngwured gwurli diloya. A be nga gwa jalu gwuru gweꞌte gweꞌte, na ngwüdlä ngwunga ngwaꞌti ngwa medadi.” ");
INSERT INTO lro_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","Ngwaalu ngwaꞌti ca gïꞌrrä gere güngün ngwujaꞌri ngwee ngwucung ngwe Gïjü güngün ndi ari, “Jicinyalu kaama güny ꞌdi nyi gäbïcï güwänü gunga nga roꞌtalu gora ge”? ");
INSERT INTO lro_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","Yïꞌrr ꞌdar yäꞌtüdï ngwügïꞌrïm ngwäpïjä Ngwaalinga yiiro? Yükäjäär je ndi äpïjï ngwüjü yiiru ngwanni ngwadi aar je ätädä yuꞌrina yidi gïlängïdïne. ");
INSERT INTO lro_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","Ar be arngani ar geraji ngwänï mama ngwujaꞌri ngwanni ngwuꞌdinginar je ngwani Yicu nunnu aaꞌti a la ꞌrämbïrï. ");
INSERT INTO lro_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","Ndi ari ngwujaꞌri ngwanni ngwondaja je yïꞌrr ngwo ngwaalu ngwegen, na ngwüjï ngwe ꞌdar ngwanni ngwa kiyi yobo ngwa aar je rejaji, ");
INSERT INTO lro_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","yäy gu no, ya be ruꞌtana ꞌdengge ndi gwanna rerajing nggwee manari a lima ïꞌdädänü gwulleny gïlängïdïnï gwe nggwee gwupana? Gïlängïdïnï nggwee gwanni gwondaja gwe Deleny dani Yicu gwerre, ngindenga lanni liꞌdingina ngindeng aar nje gäbïcï nyii gu ïcïnä. ");
INSERT INTO lro_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","A gwe Ngwaalu ꞌto inggidi yiꞌremna ye na yiima ye yonyadana yati alliji ngwäjälü ndïr, na angidaci gwe ngwüjü yiiru yidi Lïgïꞌrïm lanni Lijuꞌru ngwuje gegenaci anaku naning gu. ");
INSERT INTO lro_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","Yaꞌti ani yïꞌrr yanni yima aar je geꞌte ndi määtä dïdläyü danni dadi oꞌra danni dondajar de gweneno ngwujaꞌri ngwe ngwee. ");
INSERT INTO lro_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","A be yondajaar ye ngwaalu ngweꞌte kitabanu gidi Ngwaalu ndi ari, “Dïjï dümnä dani yärü dïgätädä gu ngwäyänü, gïjï gani yärü gidi dïjï dümnä nunnu ꞌdi nga ge arngani? ");
INSERT INTO lro_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","Gokeyananga gwooko gïyïꞌrr nga giki giꞌriba gidi yeleny nga näjï nga jayi ngwäy ");
INSERT INTO lro_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","nga gïꞌtïjï ngwony ꞌdar ngwuje roꞌtalu gora ge yelenya.” Gïꞌtïjï gwe ngwony ꞌdar ngwuje roꞌtalu gora ge yelenya, Ngwaalu ngwuma ꞌti dodana yiꞌral yere nding je määtä yelenya. A be gweneno giyona yaꞌti ar je änggädï ndi ari giyona yïmätïng je yelenya. ");
INSERT INTO lro_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","A be Yicu ru gwänggädär gwanni gwokeyaar gwooko gïyïꞌrr, nggwo gwuma aar giki giꞌriba gidi yeleny gwani näjï gwuma aar gwe jayi ngwäy ndi ari gwümätï liguri gïdïrbänü ngwayi, nunnu a yïmïꞌrü ye yidi Ngwaalu ngwungelle yiꞌrany yani ngwüjï ꞌdar. ");
INSERT INTO lro_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","Ndi apada yïjü yonyadu ndi näjï, yädï gu ndi ari a Ngwaalu gäbïcï nginde gwanni gwuru dooꞌra didi gilang gwegen ngwumbuti ngwaalu ku ïyï gwe dïrbä düngün. ");
INSERT INTO lro_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","Yeꞌte yeꞌte ndi ari gwanni gwati juꞌriyi ngwüjü na lanni lijuꞌriyaar je, liru ngwüjï ngwudi längïr leꞌte pu, no Yicu gwaꞌti yaaru apu nding je urnidi ngwenggen. ");
INSERT INTO lro_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","Nginde gwaru nu, “Äny gwa ondaji ngwürïny ngwe ngwunga ngwänggärï na gidiliganu didi giꞌdoonga, äny gwa ang elngaji orta gwe.” ");
INSERT INTO lro_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","Na ngwoꞌre ngwari, “Gwunyi gu ämnäcï.” Ngwoꞌre ngwari ꞌto, “Äny nggwo ngene na yïjï yunga yanni yiminje ätädä gwani Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","A be anaku ru gu yïjï lingeno na yïn, nginde ꞌto lima ar le acajidi gwani lingeno legen nunnu yiꞌrany ye yüngün, ngwobedalu nggwo gwanni gwätï yiima yidi yiꞌrany nggwo gwuru dijegoꞌrr. ");
INSERT INTO lro_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","Ndi ari ngwuje gwäꞌdälü ndi elelle ꞌdar gwanni gwelellaar gu gïyïnädänü yidi yedeny yidi yiꞌrany. ");
INSERT INTO lro_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","Ndi ari ꞌdiꞌdidanu yaꞌti yani yïꞌrr yanni yigatajaar je düwä, a be yïjï ru yidi Äbräyïm. ");
INSERT INTO lro_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","Ndi ari yiru giyee yanni yïgäbïcä ngindeng ngwube ru nono ngwenggen gilingeno giyiꞌral ꞌdar nunnu ngwuru dïnä na dirꞌdal danni diru giꞌra diru ligor leꞌte pu giyiiru yidi Ngwaalu nunnu a Ngwaalu düdänïjï ngwüjänü ndi ke gwegen. ");
INSERT INTO lro_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","Ndi ari nginde giligoꞌro lüngün gwïyü dïrbä kaji ganni gïdäjäär ge, nginde gwätï ndi gataji ngwüjü düwä gwanni ngwa aar je ïdäjï. ");
INSERT INTO lro_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","Yäy gu no ngwänggärï ngwanni ngwujuꞌru, ngwanni ngwacajidu ndi urnidi gwudi gerala gäbïcär ïrïyïng ngwäyälü gwalu ngwuji ndi Yicu, gwanni gwuru dooꞌra dükäjäär ngwuru dirꞌdal danni diru giꞌra gwanni gwati ar gwe ondaji. ");
INSERT INTO lro_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","Nginde gwuruca Ngwaalinga ligor leꞌte pu ngwanni ngwugeꞌta giyeleny nono rucu gu Müjä yiiru ligor leꞌte pu yanni yätädï je Ngwaalu yani ngwüjï ngwüngün. ");
INSERT INTO lro_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","Yicu gwuma aar mbuji ndi ari näjïnï gwüngün gwupana ndi Müjä, nono gwele ndi ari dïjï danni dati oda ngwuꞌduna dati aar näjänï ngwuꞌdun ngwanni ngwüdädïng je. ");
INSERT INTO lro_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","Ndi ari ngwuꞌdun ꞌdar dïjï dati ji danni düdädï je, a be Ngwaalu ngwuru ngwanni ngwugeꞌta yiꞌral ꞌdar. ");
INSERT INTO lro_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","Müjä gwuru dïnäd diru ligor leꞌte pu ngwujaꞌri ꞌdar ngwuꞌdun ngwudi Ngwaalu, elelle gwüngün inggidi yiꞌral yanni yadi ye Ngwaalu ondaji kaji ganni gadi ila. ");
INSERT INTO lro_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","A be Kirictu gwuru ligor leꞌte pu nono gïjü giru giꞌra gidi ngwuꞌdun ngwudi Ngwaalu. Na alanga liru ngwuꞌdun ngwüngün, ma ar ämnäcï ndi geꞌtaji na ndi mätïnälü ndi ïrïngïnï gwege ꞌdi a yomon medadi. ");
INSERT INTO lro_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","Yäy gu no, anaku aru gu Lïgïꞌrïm lanni Lijuꞌru ndi ari, “Gwene manari ngaa lima ꞌdingini ngwujaꞌri ngwüngün, ");
INSERT INTO lro_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","aaꞌti ngaa lundi giyiꞌra yalu anaku ru gu ngwügüürnä ngwalu gwerre ndi nyürtïjï Ngwaalinganu gaji ganni gïdäjäär ge Ngwaalinga gïtäny. ");
INSERT INTO lro_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","Anni ïdäjärïny ngwügüürnä ngwalu aar nyi ïdäjï aar engga yiima yüny yanni yärrï nje ngwüdläyü ꞌdï kwoꞌrongo (40). ");
INSERT INTO lro_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","Yiru giyee yanni yïgäbïcïny a nyi be güündä ape kimaad nggone nyi ari. ‘Yigor yegen yïlädälü ꞌter yomon ꞌdar na ngindenga lima dodani gay güny.’ ");
INSERT INTO lro_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","No, a nyi güündä ape nyi mïꞌrï yiꞌrany nyi ari, ‘Ngindenga laꞌti la änï aꞌtur ndi obe düwä de ꞌdünggüny.’” ");
INSERT INTO lro_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","Ombajar je be ngwänggärï, ndi ari aaꞌti gwere ꞌdanggalanu gwa ji gwätï unding giꞌra ndi ämnï Ngwaalu ngwoꞌre Ngwaalinga kay ngwanni ngwumidu. ");
INSERT INTO lro_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","Ngaa be orꞌtemajidi yomon ꞌdar anni juna yomon gwene nunnu aaꞌti gwere gwa ji gwundu kiꞌra ndi yiꞌral ïꞌdäjänü yanni yiki. ");
INSERT INTO lro_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","Alanga lima ila ndi acajidi ndi Kirictu manari a lima mätïnälü ꞌdïꞌdäny ndi ïcïnädä gwanni gwätär gwerre ar gu ru yigor yeꞌte pu ꞌdi a yomon medadi. ");
INSERT INTO lro_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","Nono giyee yaraar ye gweneno ndi ari, “Gwene, manari ngaa lima ꞌdingini ngwujaꞌri ngwüngün, aaꞌti ngaa lundi giyiꞌra yalu anaku ru ngwügüürnä ngwalu gwerre ndi nyürtïjï Ngwaalinganu gaji ganni gïdäjäär ge Ngwaalinga gïtäny.” ");
INSERT INTO lro_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","Yärüngä liru lanni liꞌdingina Ngwaalinga aar be nyurtanu? Läꞌtüdï mene ꞌdar lanni lïꞌtüyä je Müjä ken gani Mijire? ");
INSERT INTO lro_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","Yärüngä liru lanni lapiya Ngwaalinga gündä ngwüdläyü küüꞌrï rom? Läꞌtüdï mene lanni liki ngwäyänü Ngwaalu lanni lima ayi gïtänye? ");
INSERT INTO lro_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","Na yärüngä liru lanni lïmïꞌrïcä je Ngwaalu yiꞌrany ndi ari laꞌti länï ndi obe düwä de ꞌdünggüngün aꞌtur manari läꞌtüdï mene lanni lïnyürtïjänü? ");
INSERT INTO lro_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","No, a länggädï ndi ari lima ꞌti burna ndi änï gwani yigor yegen yaꞌti ämnä Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","Yäy gu no anni juna ngwujaꞌri ndi ele ngwanni ngwaru ngwe Ngwaalu gwani änï ndi obe düwä de ꞌdünggüngün, arnganar be nunnu aaꞌti gwere ꞌdanggalanu gwa amiꞌrati ndi änï. ");
INSERT INTO lro_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","Ndi ari ꞌto liminje ondaci ngwujaꞌri ngwanni ngwujaw anaku ondacaar je gu ꞌto, a be ngwujaꞌri ngwanni ngwuꞌdinginaar je ngwuma je ꞌti ngwujaꞌri ärrü yiꞌral yere yijaw, ndi ari lanni liꞌdingina lima ꞌti ämnä ngwujaꞌri ngwanni ngwuꞌdinginaar je. ");
INSERT INTO lro_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","A be gwenene alanga lanni lima ämnï ngwujaꞌri ngwudi Ngwaalu, a la änï ndi obe düwä de anaku ma gu Ngwaalu ari, “Yäy gu no a nyi güündä ape nyi mïꞌrï yiꞌrany nyi ari, ‘Ngindenga laꞌti la änï aꞌtur ndi obe düwä de ꞌdünggüny.’” Gwaru gu ma ni ari yiiru yüngün yima medadi ꞌtuꞌtu anaku geꞌteng gu dïdläyü. ");
INSERT INTO lro_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","Ndi ari yiming ye yondaji ngwaalu ngweꞌte yani gomon ganni giru Kwoꞌra täꞌrïl ngwujaꞌri ngwe ngwee ndi ari, “Na gomon ganni giru Kwoꞌra täꞌrïl, Ngwaalu ngwübïdï düwä de giyiiru ꞌdar yüngün.” ");
INSERT INTO lro_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","Na mana ngwujaꞌri ngwe ngwee ngwaru ngwee ngene, a nginde ari, “Ngindenga laꞌti la änï aꞌtur ndi obe düwä de ꞌdünggüny.” ");
INSERT INTO lro_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","Giyona ndi ele ndi ari loko la ji la änï ndi obe düwä de, na lanni londacaar je ngwujaꞌri gwerre, laꞌti ändï ndi ari linyurtanu. ");
INSERT INTO lro_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","Yäy gu no, Ngwaalu ngwo mana ngwugeꞌta gomonalu geꞌte gicung Gwene, luubu anni ma aji ngwondaja lingla le lidi Däwüd ndi ari, “Gwene, manari ngaa lima ꞌdingini ngwujaꞌri ngwüngün, aaꞌti ngaa lundi giyiꞌra yalu.” ");
INSERT INTO lro_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","Ndi ari adinari a je Jäjïwä änïjï ndi obe düwä de, Ngwaalu ngwaꞌti ngwadi oꞌre aar ondaji ngwujaꞌri ngwee mana ngwani gomon giꞌter. ");
INSERT INTO lro_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","Giyona be ndi ele, yani gomon ganni giru Kwoꞌra täꞌrïl gidi obe düwä de didi ngwüjï ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","Ndi ari gwere gwanni gwa änï ndi obe düwä de didi Ngwaalu, gwa obe düwä de ꞌto giyiiru yüngün, nono anaku übïdï gu Ngwaalu düwä de giyiiru yüngün. ");
INSERT INTO lro_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","Yäy gu no, ar be ji ꞌdïꞌdäny ar änï ndi obe düwä de nunnu aaꞌti gwere gwa ji gwïꞌdï kora gidi ngwügüürnä ngwone gwani nyurtanu gwegen. ");
INSERT INTO lro_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","Ndi ari ngwujaꞌri ngwudi Ngwaalu ngwo ngwumidu ngwapu yiiru. Ngwätänä yïnï kalal ganni giru yïnï ngwurel rom, gati üꞌrü lingina na lïgïꞌrïm, ngwänï giyircenyanu na gïyüjänü ngwati lenge yaꞌranya na elelle gwudi ligor lidi dïjï. ");
INSERT INTO lro_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","Yere yaꞌti yanni yïgïꞌtïnä gïdïdlä yaꞌti linginna ngwäyänü Ngwaalu. Yiꞌral ꞌdar yijalu mbüny aar jalu wir ngwäyänü Ngwaalu ngwanni ngwa ji ngwunje otacalu. ");
INSERT INTO lro_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","Yäy gu no, anni ru Yicu Gïjï gidi Ngwaalu dirꞌdal dege danni diru giꞌra gwupana, gwanni gwuma madini ngwänï giyerala, ar be mätïnälü ꞌdïꞌdäny ndi ämnï gwege ꞌdünggüngün gwanni gwati ar gwe ondaji. ");
INSERT INTO lro_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","Ndi ari alanga liru lidi dirꞌdal danni diru giꞌra dätï yiima, ndi lenge amiꞌrating gwege, ndi ari nginde gwïdäjäär yiꞌral ye ꞌdar nono alanga je ngwuꞌti ärrü yiꞌral yere yanni yiki. ");
INSERT INTO lro_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","Ar be gatu yigoralu yege ar ꞌdonggaci diduꞌri didi yïmïꞌru yüngün nunnu ar ïnä ar mbuji yïmïꞌrä ar nje degeꞌdaji gaji nggee ma ar je bupi. ");
INSERT INTO lro_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","Ngwurꞌdal ꞌdar ngwanni ngwati ru yiꞌra ngwati aar je äbrï ngwüjänü aar je alliji aar ape giiri na aar ji ngwüjü giyiꞌral yidi Ngwaalu aar angidaci Ngwaalinga aar geꞌte mïꞌrïnïng nono gwani ke. ");
INSERT INTO lro_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","Ngwätï yiima ndi jïlïjï ngwüjänü ngwanni ngwaꞌti lïngïdï ngwududu, ndi ari nginde ꞌto gwuru dïjï damiꞌratu. ");
INSERT INTO lro_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","Ndi ari yiru giyee yïgäbïcä ngindeng ngwümïꞌrïnï nono gwani ke gwudi ligoꞌro lüngün, na ꞌto gwani ke gwudi ngwüjï. ");
INSERT INTO lro_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","Dïjï dere daꞌti dapu näjïng nggwee gwudi ape giiri gidi dirꞌdal diru giꞌra ligoꞌro le lüngün. A be Ngwaalu ru ngwati urnidi anaku urnida gu Ngwaalu Aruuning ndi ru dirꞌdal danni diru giꞌra. ");
INSERT INTO lro_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","No Kirictu ꞌto gwaꞌti apu näjïng giligoꞌro lüngün ndi ru dirꞌdal danni diru giꞌra. A be Ngwaalu ru ngwuca nu, “Nga gwuru Gïjï güny, gwene äny gwuma ru Papa gwunga.” ");
INSERT INTO lro_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","A nginde gwondaja gu ngwaalu ngwuꞌter ngwari, “Nga gwuru dirꞌdal yomonalu pipiꞌriꞌti gïdïꞌrïny didi yirꞌdal yidi Mälïkï Jadig.” ");
INSERT INTO lro_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","Giyomon yidi Yicu yanni yijung ye ngene gïdïyängälü, gwotaca Ngwaalingalu ngwuje päcälü ngwudugi yal ye yipa gwani nginde gwanni gwätï yiima nding gïlängïdïyï giyiꞌrany, aar ꞌdengenaci nunnu denya na ꞌdengenaci gwüngün. ");
INSERT INTO lro_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","Nginde gwuru Gïjï, ngwube lenge ndi ꞌdengenaci Ngwaalinga ngwujaꞌri ngwe ngwanni ngwïyüng gu dïrbä ");
INSERT INTO lro_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","anni mung je gu mbütï, nginde gwuma ru gay gidi gïlängïdïnï gwudi gwurꞌtaling gwudi ngwüjï ꞌdar ngwanni ngwa ꞌdengenaci ");
INSERT INTO lro_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","na nginde gwäbrü Ngwaalu ngwuru dirꞌdal danni diru giꞌra gïdïꞌrïny didi yirꞌdal yidi Mälïkï Jadig. ");
INSERT INTO lro_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","Yiꞌral giyo yonyadu yïmïnï nje ndi ara je ondaci. A be yundu ndi ara je enggaci ndi ari ngaa ru yaꞌranya yoko ndi lenge. ");
INSERT INTO lro_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","Ndi ari gaji ge nggee ngaa ladi be ji ndi ru ngwoorta, ngaa gilo be linana dïjü ara je enggaci gatu yora ngwujaꞌri ngwudi Ngwaalu ngwanni ngwuru ꞌdidanu ara je gu gwäꞌräcänü mana. Nga nga gilona liru nono yïjü yanni yoko yinana ndi iꞌri yan yaꞌtina lengedadu ndi eny enying gwanni ngwojemanu! ");
INSERT INTO lro_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","Gwere gwanni nggwona ndi iꞌri, nggwona gwuru gïjï goko gwaꞌti gu na ngwujaꞌri ändänü ngwani dünälü. ");
INSERT INTO lro_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","A be ngwong ngwudi eny ngwanni ngwojemanu, aar be ru ngwudi ngwüjï ngwanni ngwuma pe ngwuma bebere ngwanni ngwuma je ngwujaꞌri madinanu ngwïdïtänä gu yigoꞌro yegen yomon reny ndi lenge ndi ari yiru giyene yanni yijaw na yiru giyene yanni yiki. ");
INSERT INTO lro_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","Yäy gu no, ar be gatani enggacing gwudi yogo gwanni gwüꞌdïꞌrär gwe gwerre gwani Kirictu, ar ele ndi pe ar bebere bebereng gwanni gwubirlu. Aaꞌti a la ji ba be ndi geꞌte gay gidi ondaji gwani joꞌrenyani giyiꞌral yanni yati nje oktada giyiꞌrany na gwani ämnï Ngwaalu, ");
INSERT INTO lro_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","na awa ndi inggidi gwani nyïnyïnï yaw ye, gwani alliji ngwüjü ngwuy nono, gwani ꞌdïꞌrï gwudi ngwüjï ngwayu na gwani obalu ngwüjï ngwe gwudi Ngwaalu gwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","Yiꞌral giyee ꞌdar ya ar je ärrï ma gu Ngwaalu ari. ");
INSERT INTO lro_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","Ndi ari yojema ngwüjï ngwanni ngwuma aar je enggaci aar ngille angidajing gwudi gerala, ngwanni ngwuma acajidi Gïlïgïꞌrïm lanni Lijuꞌru, ");
INSERT INTO lro_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","ngwanni ngwuma ngille jaying gwani ngwujaꞌri ngwudi Ngwaalu na gwani yiima yidi Ngwaalu gïdïdlä didi gwodaning, ");
INSERT INTO lro_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","ndi ari manari lima ïꞌdï aar gatani ämnïng Ngwaalu, laꞌti la aar je gwäꞌrä ndi joꞌrenyana, ndi ari ndi dudi gwegen, lima oꞌre lima pä Gïjü gidi Ngwaalu küꞌrï na gima aar apiyi yaaru ngwäyänü ngwüjï. ");
INSERT INTO lro_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","Yiꞌral giyee yiru nono gwele dïyäng danni dati gere pï yomon reny ati ngwüꞌtücä ngwüjü ngwanni ngwükwüdï yuula yijaw nunnu yiru yanni yïkwüdädää, dati Ngwaalu onjaci. ");
INSERT INTO lro_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","A be Ngwaalu ngwati ꞌtäjï ngwünyü gïdïyäng danni daꞌti jaw dati ꞌtüyä ngwügä ngwüꞌtüyä yanya. Na da gätïnï gïlïgä da üꞌdïnï ma yomon medadi. ");
INSERT INTO lro_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","ꞌDi minyii gu ni ondaji no lani ngwumaad, nyii gilo ꞌto lïcïnänü ndi ari giyo yätï je yanni yijayana yanni yati a je oktada ndi gïlängïdïnï. ");
INSERT INTO lro_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","Ngwaalu ngwäꞌtüdï dïrïgïnä, nginde gwaꞌti gwa dodani yiiru yalu na ämnï gwalu gwanni gwuma aang enggaci ngindeng anaku äpïjï gu ngwüjü ngwüngün yiiru na ngwona ngwati a je äpïjï yiiru. ");
INSERT INTO lro_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","Libupa je ꞌdar a dïjï deꞌte deꞌte lenge unding ngwäy nggwee ꞌdi aar ila ndi medadi, nunnu ara je Ngwaalu onjaci giyiꞌral yalu yanni yigeꞌtaja gu ndi ape. ");
INSERT INTO lro_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","Nyii laꞌti mïnä ndi aang ru ngworony, ngaa be gwuji gora geꞌte geꞌte gidi ngwüjï ngwanni ngwämnä Ngwaalu aar orꞌtemaji no aar ape yuꞌrina yanni yaru ye Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","Anni ma Ngwaalu ci Äbräyïmïng ngwujaꞌri ngwe ngwüngün, ngwümïꞌrïdï yiꞌrany giligoꞌro lüngün anaku aaꞌti gu gwere ju gwanni gwupana ꞌdünggün nding gwe mïꞌrï yiꞌrany. ");
INSERT INTO lro_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","Ngwuci, “ꞌDidanu, äny gwa ang onjaci äny gwa ang ruji papa gwudi ngwüjï ngwonyadu.” ");
INSERT INTO lro_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","No anni ma gu Äbräyïm dünïcï ngwujaꞌri ngwuje mätïjï liguri, yiming je ape yanni yica ye Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","Ngwüjï ngwati mïꞌrï yiꞌrany dïjï de danni dipana ꞌdenggen, na mïꞌrï yiꞌrany gwati ätïyï yiꞌral ngwäyänü yaraar ye aar üꞌrü ngwüjänü. ");
INSERT INTO lro_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","Ndi ari Ngwaalu ngwümïnä ꞌdidanu ndi inggidi ndi ari ngwüjï ngwanni ngwadi ape yuꞌrina yanni yarung ye aar lenge ndi ari Ngwaalu ngwati ꞌti gwürlïnä gïdrü düngün aꞌtur gwani bupi nggwee, no nggu be mïꞌrädä yiꞌrany. ");
INSERT INTO lro_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","Ngwaalu ngwärrü yiꞌral giyee nunnu yiꞌral ye rom yanni yati ꞌti gwurlu, yojema Ngwaalu ndi üꞌrü yiꞌduꞌru. No alanga lanni lima gu abrada ndi mätänï ndi geꞌtaji gwätädäär nje, gwa ar gu orꞌtemaja gwulleny. ");
INSERT INTO lro_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","A lätï ndi geꞌtaji nggwee gwuru nono guduꞌru giru laaba gidi lïgïꞌrïm gwati nje ojeme nono gwümätïnälü ndom gwaꞌti lagadalu. Geꞌtaji nggwee, gwati nje gwe ele drü dänü ngwaalu ngwanni ngwujuꞌru kobo gidi Ngwaalu giluꞌralanu lidi dired danni düllälü. ");
INSERT INTO lro_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","Ngwaalu ngwanni ngwuma gu Yicu, gwanni gwuma madinani ꞌdengge nggu änï gwani alanga. Nginde gwuma ru dirꞌdal danni diru giꞌra pupud gïdïꞌrïny didi yirꞌdal yidi dirꞌdal dani Mälïkï Jadig. ");
INSERT INTO lro_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","Mälïkï Jadig nggwee gwuru deleny didi ngwaalu ngwani Jälïm ngwuru dirꞌdal didi Ngwaalu ngwudi gerala. Dimbudar Äbräyïm gwe gwoꞌra gïyäärä yanni yidamu ye ngwelenya ngweꞌte na dirꞌdal ndoo onjaci Äbräyïmïng, ");
INSERT INTO lro_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","a Äbräyïm gwällïjï giꞌra ngwong ꞌdï ꞌdar ngwanni ngwümätïng je gïyääränü. Gwerre gwerre, ngwürïny ngwani Mälïkï Jadig ngwani, “deleny didi dünälü.” A nginde ani ꞌto, “deleny didi Jälïm” gwani, “deleny didi adatalu.” ");
INSERT INTO lro_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","Daꞌti linginna mbumbung ngwuꞌti linginna nanning, ngwuꞌti linginna dimoꞌra didi ngwügüürnä ngwüngün, ngwuꞌti linginna yomon yüngün gwerre ngwuꞌti ätï mïꞌräng gwudi midi, dijalu diru nono Gïjü gidi Ngwaalu ngwuru dirꞌdal didi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","Ïrïyä ꞌdi ngwäyälü ꞌdogo ndi ari guꞌru güngün giru ꞌtaa ꞌdi a papa gwani Äbräyïm gwällïjï giꞌra ngwong ꞌdï ꞌdar ngwanni ngwümätïng je gïyääränü! ");
INSERT INTO lro_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","Na yobo yati ari a ngwüjï gïlängïr lidi Lawi ngwanni ngwuma ru ngwurꞌdal uti yiꞌra ngwong ꞌdï ngwüjï ngwudi Yïjïräyïl ngwuru ngwüjï ngwegen anni ari ngwüjï ngwegen ngwuru ngwüngüürnä ngwudi Äbräyïm. ");
INSERT INTO lro_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","A be dïꞌrïny didi dirꞌdal dani Mälïkï Jadig, daꞌti üꞌrädï gïlängïr lidi ngwügüürnä ngwudi Lawi, ngwube ape yiꞌra ngwong ꞌdï ndi Äbräyïm ngwonjaci Äbräyïm gwanni gwätï ngwujaꞌri ngwanni ngwuca ngwe Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","Ngwüjï ꞌdar ngwülïngïdï ndi ari gwanni gwupana gwati onjaci ngindeng gwanni gwokana. ");
INSERT INTO lro_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","A be gwani ngwurꞌdal ngwanni ngwati uti yiꞌra ngwong ꞌdï ngwüjü, ngwuru ngwüjï ngwümnä ngwadi ayi. A be gwani Mälïkï Jadig, gwanni gwügwällïjä Äbräyïm giꞌra ngwong ꞌdï, gitab gidi Ngwaalu garu nu, nginde gwuru dïjï danni dadi ele ndi midi gwurꞌtal. ");
INSERT INTO lro_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","A la gu mine ari ndi ari anni geꞌta Äbräyïm giꞌra ngwong ꞌdï, Lawi, gwanni gwati uti yiꞌra ngwong ꞌdï, gwugeꞌta ꞌto giꞌra ngwong ꞌdï. ");
INSERT INTO lro_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","Ndi ari Mälïkï Jadig, anni mbudaar Äbräyïm gwe, Lawi gwujuna gilaranu lidi dïgüürnä düngün dani Äbräyïm. ");
INSERT INTO lro_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","Anni ätädï Ngwaalu ngwügürnä ngwudi Lawi yirꞌdala, gwätädï ꞌto ngwüjü ngwudi Yïjïräyïl yobo gaji geꞌte geꞌte. A be mbuti gwaꞌti ju giyirꞌdal giyee. No aar be ojeme ndi ari a bupi ji gwani dirꞌdal diꞌter diru nono Mälïkï Jadig ngwuꞌti rüdï nono Aruuning. ");
INSERT INTO lro_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","Ndi ari manari gwürlï gwuma ji gwani yirꞌdal, gwürlï gwa ji ꞌto gwani yobo. ");
INSERT INTO lro_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","A be Deleny dege dani Yicu, gwanni gwondacaar gu yirꞌdala giyee, gwuru gïïlü giꞌter, gwere gwaꞌti gwudi gïïlü nggoo gwapu yirꞌdala aꞌtur gidagad gomon gere. ");
INSERT INTO lro_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","Ndi ari yilinginna ndi ari Deleny dege dïꞌtüdï gïlängïr lidi ngwüjï ngwudi Yäwüdä, na gïïlü nggee gidi Yäwüdä gaꞌti ge yobo yidi Müjä ondaju ngwujaꞌri ngwani yirꞌdal. ");
INSERT INTO lro_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","15","Yiꞌral giyee yaru nyi ye, yilinginna gilingenalu ndi ari yondaja gwani dirꞌdal diꞌter danni diru nono Mälïkï Jadiging dima ila gweneno, ");
INSERT INTO lro_vpl VALUES ("HB7_16","088_7_16","HEB","7","16","16","nginde gwanni gwapu yirꞌdala yaꞌti gïꞌtïnä dïmürä de didi ngwüjï ngwümnä, aar be gïꞌtïnï dïmürä de didi yiima yidi midi gwüngün gwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("HB7_17","088_7_17","HEB","7","17","17","Ndi ari yündäjïnä gitabanu gidi Ngwaalu yaru nu, “Nga gwuru dirꞌdal yomonalu gwurꞌtal, nono Mälïkï Jadiging.” ");
INSERT INTO lro_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","18","Ngwujaꞌri ngwudi yobo gwerre, ngwuma gïꞌtïnï gay geꞌte ndi ari gwamiꞌratu gwaꞌti mbutu giyiiru ");
INSERT INTO lro_vpl VALUES ("HB7_19","088_7_19","HEB","7","19","19","ndi ari yobo yaꞌti ya mbütïyï yiꞌral yere, a be gaji geꞌte geꞌte, liminje ätädä geꞌtajing gwujayana gwunje ꞌdonggaji Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB7_20","088_7_20","HEB","7","20","20","Yiꞌral giyee yaꞌti ärrïnälü no, yïmïꞌrïdäär ye yiꞌrany! Ngwurꞌdal ngwoo ngwuru ngwügüürnä ngwudi Lawi ngwaꞌti aar je mïꞌrïcä yiꞌrany, ");
INSERT INTO lro_vpl VALUES ("HB7_21","088_7_21","HEB","7","21","21","a be nginde gwani Kirictu gwuru dirꞌdal mïꞌrï gwe yiꞌrany anni ma Ngwaalu ci nu, “Deleny diru Ngwaalu dïmïꞌrïdï yiꞌrany na nginde gwaꞌti gwa gwäꞌrï ngwujaꞌri ngwüngün, ‘Nga gwuru dirꞌdal gwurꞌtal.’” ");
INSERT INTO lro_vpl VALUES ("HB7_22","088_7_22","HEB","7","22","22","Mïꞌrï gwe yiꞌrany nggwee, Yicu gwuma ru änïjälü gwudi gekajidi gwanni gwujayana. ");
INSERT INTO lro_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","Kaji nggee yima ji ndi ari ngwurꞌdal ngwuju ngwonyadu ngwuru ngwügüürnä ngwudi Lawi, a be anni aaꞌti je yiꞌrany gäbïcä ndi ape yirꞌdala aar jalu gwurꞌtal, ");
INSERT INTO lro_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","a be Yicu gwumidu gwurꞌtal, nginde gwapu yirꞌdala yidi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","Yäy gu no, nginde gwätï yiima ndi mbütïyï gïlängïdïyïng ngwüjü ngwanni ngwadi ila Ngwaalu nginde gwe, ndi ari nginde nggwo gwumidu gwurꞌtal ndi mandi ꞌdengge ngwotaci Ngwaalingalu gwani alanga. ");
INSERT INTO lro_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","Dirꞌdal danni diru giꞌra diru gu no, dati nje gïꞌtïjï buping gwege, nginde gwa ru gwanni gwujuꞌru, gwujaw nono, Ngwaalu ngwuma äbrï Yicung ngwüjänü ngwanni ngwuki, ngwallijala kerala. ");
INSERT INTO lro_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","Gwäꞌtüdï nono dirꞌdala ndoo danni diru giꞌra, nginde gwaꞌti ätï ndi mïꞌrïnï nono giyomon giyomon, gwerre gwerre gwani ke gwüngün, ngwube oꞌre ngwani ke gwudi ngwüjï. Nginde gwümïꞌrïnä nono gomonanu geꞌte pu gwani ke gwegen kaji ganni giming ge mïꞌrïnï nono ligoꞌro le lüngün. ");
INSERT INTO lro_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","Ndi ari yobo yati alliji ngwüjü ngwanni ngwamiꞌratu aar ru ngwurꞌdal ngwanni ngwuru yiꞌra a be mïꞌrï yiꞌrany gwudi Ngwaalu gwanni gwujana giyobo, gwallija Gïjü güngün ganni gimbutu giyirꞌdal gwurꞌtal. ");
INSERT INTO lro_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","Ngwujaꞌri ngwanni ngwadi ar ngwe ari ngene ngwuru ngwee, ndi ari alanga lätï dirꞌdala danni diru giꞌra diru gu no, danni dijalu kaama ngwuduꞌri ngwudi Ngwaalu ngwuru Deleny kerala. ");
INSERT INTO lro_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","A nginde gwuru dïnäd dani Yicu gwanni gwäpïjä Ngwaalinga yirꞌdala ngwaalu ngwanni ngwuru gäꞌtä ꞌdidanu a Deleny ru digegeꞌta, gaꞌti gïꞌtïnä dïjï de dümnä. ");
INSERT INTO lro_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","Dirꞌdal danni diru giꞌra dere dati aar alliji ngwügïꞌtïjï Ngwaalinga angidajing na mïꞌrïnï nono gwudi ngwüjï na gu no yiru gu yeꞌte yeꞌte gidirꞌdal ndee ndi ätï yiꞌral yani ligoꞌro lüngün ꞌto ndi gätïjï Ngwaalingalu. ");
INSERT INTO lro_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","Adinari gwuru gwudi dïyängälü, gwaꞌti gwadi ru dirꞌdal, ndi ari ngwüjï ngwuju ngwanni ngwati gatu angidajingalu anaku ondaja gu yobo yidi Müjä. ");
INSERT INTO lro_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","Ngwati ape yiiru giyee yanni yiru ngwüꞌrïmbïl aar ru diil didi gäꞌtä ganni giru ꞌdidanu nggo kerala. Yiru gu yeꞌte yeꞌte anaku gaji gidi Müjä. Anni mung ru gwadi pä gäꞌtä ganni gijuꞌru, gwuca Ngwaalu, “Diwayina gu ndi ari nga geꞌte yiꞌral ꞌdar aar oꞌrani yiꞌral anaku enggacara je gu Ngwaalu kenala.” ");
INSERT INTO lro_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","A be yiiru yanni yätädï je Ngwaalu Yicung, yipana giyiiru yegen anaku pana gu gekajidi gwanni gwurung gu dartan ndi gekajidi gwanni gwuꞌrin, na yïgïꞌtïnä ngwujaꞌri ngwe ngwujayana ngwaru ngwe Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","Ndi ari adinari yere yaꞌti yiju yiki ndi gekajidi gwudi gwerreng, gay gaꞌti ba be gadi ji gani gekajidi nggwee gwuyang. ");
INSERT INTO lro_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","A be Ngwaalu ngwänggädï keng gwudi ngwüjï ngwube ari, “Gaji nggo gïndï äny gwa geꞌte gekajiding gwuyang ngwüjï ngwe ngwudi Yïjïräyïl na ngwüjï ngwe ngwudi Yäwüdä. ");
INSERT INTO lro_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","Gwaꞌti gwa ru nono gwanni gwugeꞌteny gwerre ngwügüürnängä ngwe ngwegen kaji ganni giminje ge määtä guy ge nje okta nje ꞌtüyä ken gani Mijir, ndi ari ngindenga laꞌti rucu gekajiding gwüny ligor leꞌte pu, a liminje gwürläcï luꞌra. ");
INSERT INTO lro_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","Gekajidi gwuru nggwee gwanni gwadi nyi geꞌte ngwüjï ngwe ngwudi Yïjïräyïl ma gaji ele nggone, a gu Deleny ari. Äny gwa geꞌte yobo yüny giyiꞌranyanu yegen na nje ulli giyigoranu yegen. Äny gwa ru Ngwaalu ngwegen, na ngindenga la ru ngwüjï ngwüny. ");
INSERT INTO lro_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","Gwere gwaꞌti ba be ngwenggaci dïjü dijacidaar de, na gwere gwaꞌti ba be gwa enggaci gwenggen ngwuci, ‘Lïngïdï Delenya,’ ndi ari ngindenga ꞌdar liny lenge, lanni lokana ꞌdenggenanu na lanni lipana ꞌdenggegenanu. ");
INSERT INTO lro_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","Ndi ari linje düdänïjänü gwani ke gwegen na la ꞌti ba be linje düwäyïnïjï keng gwegen.” ");
INSERT INTO lro_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","Ngwaalu ngwuma ari gekajiding nggwee gwuru gwanni “gwuyang,” nginde gwuming ape nggwoo gwuju gwerre gwuming ruji gwuꞌrin. Na gwanni gwuru gwuꞌrin ngwuru yïmäyïn, nggwo gito gwadi ele ndi dudi. ");
INSERT INTO lro_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","A be gekajidi gwudi gwerreng gwätï dïmürä didi äpïjï Ngwaalinga yobo na ngwaalu ngwudi yobo ꞌto gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","Gäꞌtä gïpänä ngwaalu ngwoo ngwudi yobo. Poor kubanu gidi Gäꞌtä, gätï gudina gidi lamba, a gu dümbür ji a gu yon yidi gatalu ji, ngwaalu ngwee, ngwucaar je Ngwaalu ngwanni Ngwujuꞌru. ");
INSERT INTO lro_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","Giluꞌranu ngwaalu ngwudi Gäꞌtä ngwanni ngwüjädï gïdrü ngwüꞌrïdäär jänü dired de danni düllälü, ngwucaar je ngwaalu ngwanni Ngwujuꞌrana. ");
INSERT INTO lro_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","Dagad diju gu didi yilun dïgïꞌtïnä dab de a gu Dïmbür ji didi gekajidi dïbïꞌrüjïnä dab de. Dümbür ndee, diju gu gimo giru dab gätï ngwonyanu ngwudi eny ngwani män, na duura didi Aruun danni didogana länï lïgïnyä, yoꞌrr yiru yimindi yanni yüllïnä gu ngwujaꞌri ngwudi gekajidi. ");
INSERT INTO lro_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","Gïdïmbürälä ndoo, ngwüꞌrïmbïl ngwudi yïꞌrr rom yidi näjï yicaar je Järïbïm yiju gu aar ïlädä ngwaalingalu ngwudi düdänïjänü gwudi ke. Gaji gaꞌti ndi inggidi yiꞌral giyee yere yere gweneno. ");
INSERT INTO lro_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","Anni ma aar gu gegeꞌte yiꞌral ku aar gu ele no, ati ngwurꞌdal änï giyomon giyomon ngwaalu ngwoo ngwüjädälü poor ati aar gu ape yiiru yidi yirꞌdal. ");
INSERT INTO lro_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","Ati be dirꞌdal danni diru giꞌra ru ꞌdogo dati änï ngwaalu ngwoo ngwüjädï giluꞌru, ating gu änï ꞌdogo gomonanu geꞌte pu gïdïdlä, ating ꞌti ändï aꞌtur ngwuy ngwanu, ating be änï yïn ye yanni yating je gatalu yani ligoꞌro lüngün na yani ke gwudi ngwüjï ngwanni ngwati ärrï yiꞌral yanni yiki laꞌti gu lïngïdï. ");
INSERT INTO lro_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","Lïgïꞌrïm lanni Lijuꞌru linggida dïmürä de ndee ndi ari alanga laꞌti la änï ngwaalu ngwanni Ngwujuꞌrana manari gäꞌtä gidi äpïjï Ngwaalinga yobo gidi gwerreng nggona giju. ");
INSERT INTO lro_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","9","Yiru dïꞌrïmbïl ndi aar nje enggaci gweneno ndi ari angidaji na mïꞌrïnï nono gwanni gwati aar gatalu, gwaꞌti burna ndi juꞌriyi ligor nono lidi dïjï danni dati äpïjï Ngwaalu yobo. ");
INSERT INTO lro_vpl VALUES ("HB9_10","088_9_10","HEB","9","10","10","Gwani ꞌdogo yiꞌral yidi eny na ïyï na yonyadanu yiꞌter yani dïmürä didi uni nono poor aar ru dïmürä ndi äpïnï ꞌdi a gaji ila gidi yirꞌdal gïdïꞌrïny danni diyang. ");
INSERT INTO lro_vpl VALUES ("HB9_11","088_9_11","HEB","9","11","11","A be anni ma Kirictu ila gwuru dirꞌdal danni diru giꞌra gidi yiꞌral yanni yijaw giyee ngene, nginde gwuma änï käꞌtänü gojemana gimbutu gaꞌti gïꞌtïnä ngwuy ngwe ngwudi dïjï dümnä. Gäꞌtüdï gong gïdïdlä, nggo kerala. ");
INSERT INTO lro_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","Gwaꞌti ändï yïn ye yidi yüwä na yïndrï, gwändï ngwaalu ngwoo Ngwujuꞌrana gomonanu geꞌte pu bupud yïn ye yidi ligoꞌro lüngün. Aar nje ye üꞌrälü giyirna yidi yiꞌrany nunnu ar gu mida gwurꞌtal. ");
INSERT INTO lro_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","Yïn yidi yüwä na yïndrï na ngwaaru ngwudi yïndrï yuꞌdu aar ngwe gwürä ngwüjü ngwürngü lingina aar juꞌriyi lingina nono poor. ");
INSERT INTO lro_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","Manari giyee yiru gu no, ya be ruꞌtana yanni yärrïnä yïn ye yidi Kirictu. Lïgïꞌrïm le lidi gwurꞌtaling, gwügätï ligoꞌro lüngün ngwuru mïꞌrïnï nono gwanni gwumbutu Ngwaalu. Yïn yüngün ya juꞌriyi yigor yege giyiꞌral yanni yati apa yiꞌrany, nunnu ar äpïjï Ngwaalinga yiiru ngwanni ngwumidu! ");
INSERT INTO lro_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","Yiru giyee yanni yïgäbïcä Kirictung ngwuji gidiliganu aar nje gekajidi Ngwaalinga le gekajiding gwanni gwuyang, nunnu alanga lanni lurnida je Ngwaalu, ar ape yuꞌrina yidi gwurꞌtaling yanni yaru ye. Ndi ari Kirictu gwärrü yiꞌral giyee ngwayi aar nje üꞌrälü ndi ke gwanni gwuma äpïnï kaji gidi gekajidi gwudi gwerreng. ");
INSERT INTO lro_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","Ma dïjï oladani ngwüjü ngwujaꞌri ngwe ngwani yuꞌrin yüngün mung ayi, ngwati je ꞌti ngwüjï geꞌta giyiiru ꞌdi a inggidi ji ndi ari dïjï dima ayi. ");
INSERT INTO lro_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","Ndi ari ola gwadi ru yiima ꞌdogo manari dïjï dima ayi, ngwati aar je ꞌti geꞌta giyiiru manari dïjï ndoo daru gu ndo dimidu. ");
INSERT INTO lro_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","Yiru gu no, ndi ari gekajidi gwudi Ngwaalu gwudi gwerreng, gwaꞌti ꞌdïꞌrü yiiru ye ꞌdi aar gwürä yïn ye gwerre gwerre. ");
INSERT INTO lro_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","19","Yilinginna ndi ari Müjä anni mung ülïjï ngwüjü ngwujaꞌri ngwudi yobo ꞌdar, ngwube ape yïnä yidi yïndrï na yidi yüwä ngwuje rtaji yaanu ngwugu ülläjï ngwola ngwanni ngwuri dirula de didirun ngwuye gwürä gitab gidi yobo ngwuye gwürä ngwüjü. ");
INSERT INTO lro_vpl VALUES ("HB9_20","088_9_20","HEB","9","20","20","Ngwari, “Yïn giyee yiru yidi gekajidi gwanni gwucara je gwe Ngwaalu ndi ari ngaa rime.” ");
INSERT INTO lro_vpl VALUES ("HB9_21","088_9_21","HEB","9","21","21","A Müjä gwürä ꞌto gäꞌtä na ngwügwürä ngwony ꞌdar ngenone ngwanni ngwati aar ngwe ape dïmürä didi gäꞌtä. ");
INSERT INTO lro_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","23","Yiru gu ndi ari yobo yati bupi ngwong ꞌdar ngwanni ngwuru ngwüꞌrïmbïl ngwudi ngwong kerala, aar gäꞌrïnï yïn ye, ndi ari ma ꞌti yïn ïrädälü, düdänïjänü gwati ꞌti. Na anaku ati gu gäꞌtä gidi dïyängälü mïnï ndi ar gwürä yïn ye yidi yïndrï na yüwä aar je juꞌriyi nono ꞌdogo dïmürä de ndee, a be gäꞌtä ganni giru ꞌdidanu ga mïnï mïꞌrïnïng nono gwudi yïn ꞌto yanni yipana ndi mïꞌrï nonon gwudi yïn yidi yïndrï na yüwä. ");
INSERT INTO lro_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","Ndi ari Kirictu gwaꞌti ändï ngwaalu ngwanni Ngwujuꞌrana ngwudi dïyängälü ngwanni ngwugeꞌtaar je ngwuy ngwe ngwudi ngwüjï ngwümnä ngwuru ꞌdogo dïꞌrïmbïl didi gäꞌtä ganni giru ꞌdidanu, a be nginde änï kerala, nunnu ngwuru mandi ngwaalu ngwege ngwäyänü Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","Na nginde gwaꞌti ändï kerala ndi mïꞌrï nono ligoꞌro le lüngün ndi gätïjï Ngwaalingalu mana na mana anaku ati gu dirꞌdal danni diru giꞌra änï ngwüdlä ngwüdlä ngwaalu ngwanni Ngwujuꞌrana yïn ye yanni yäꞌtüdï yüngün. ");
INSERT INTO lro_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","Adinari yiru gu, yadi be büpïnï ndi Kirictu ndi mïꞌrïnï nono ligoꞌro lüngün giyomon pïd pïd ꞌtuꞌtu anaku gïꞌtïnä gu dïdlä! A be gweneno gwuma ꞌtädälü gwodan gomonan geꞌte pu bupud ngwüdlä ngwee nunnu ngwäbrï ke gwudi ngwüjï yiꞌrany ye yüngün. ");
INSERT INTO lro_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","Anaku rar gu ndi ari dïjï dümnä dati ayi gomonanu geꞌte pu, a be Ngwaalu pïcï yelenya, ");
INSERT INTO lro_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","no ꞌto Kirictu gwümïꞌrïnäär gwe nono gomon geꞌte pu ndi ari ngwape keng gwudi ngwüjï ngwonyadu. Na gwadi ꞌtädälü mana, gwäꞌtüdï ba be gwadi oꞌrada ndi ke gwudi ngwüjï, a be gwadi oꞌrada ndi gïlängïdïyï ngwüjü ꞌdar ngwanni ngwüdünïcä. ");
INSERT INTO lro_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","Yobo yanni yätädï je Ngwaalu Müjäng yiru ꞌdogo dïꞌrïmbïl ngene gïdïyängälü didi yiꞌral yanni yijaw yanni giyo yïndï. Yäꞌtüdï yiꞌral yanni yiru ꞌdiꞌdanu yiꞌra ye yegen. Yobo yaꞌti ätï yiima gwuꞌren ndi mbütïyï ngwüjü aꞌtur ngwanni ngwati ꞌdonggaca Ngwaalinga mïꞌrïnï gwe nono aar gu gwäꞌrïꞌtäjänü ngwüdlä ngwüdlä. ");
INSERT INTO lro_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","Adinari yätï yiima, mïꞌrïnï nono nggwee gwaꞌti gwaadi aar dünäjï ndi gätïjï Ngwaalingalo? Ndi ari ngwüjï ngwanni ngwati äpïjï Ngwaalinga yobo, ngwaadi gäꞌrïnï gomonanu geꞌte pu bupud ngwaꞌti ba be ngwaadi ïcïnädä giyiꞌral yere yegen yanni yiki. ");
INSERT INTO lro_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","A be yiru gu ndi ari mïꞌrïnï nono ngwati gwäꞌrïꞌtänänü ngwüdlä ngwüdlä ngwuje diwayiniyi keng gwegen ");
INSERT INTO lro_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","ndi ari yïn yidi yïndrï na yüwä yaꞌti ya äbrï keng kayanu gwudi dïjï. ");
INSERT INTO lro_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","Yäy gu no, anni ma Kirictu ila gïdïdlä, gwondaja ngwari, “Mïꞌrïnï nono na gatalu gwaꞌti ang jädänü, a be ngwanginu ru ngwanni ngwuminje gïꞌtïjï. ");
INSERT INTO lro_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","Mïꞌrïnï nono gwudi deꞌreny na gwudi keng gwaꞌti ang jädänü. ");
INSERT INTO lro_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","Nyi be ari, ‘Äny nggwee, äny gwïndädï ndi ape buping gwunga gwani Ngwaalu, anaku üllïnär gu kitabanu gwani äny.’” ");
INSERT INTO lro_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","Gwerre gwerre nginde gwaru nu, “Mïꞌrïnï nono na gatalu, na deꞌreny na mïꞌrïnï nono gwudi ke, gwaꞌti ang jädänü aar ang ꞌti jädänü.” Nginde gwaru ngwujaꞌri ngwee no anni ari yobo yati ari aar äpïnï. ");
INSERT INTO lro_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","Ngwube oꞌre ngwari, “Äny nggwee, äny gwïndädï ndi ape buping gwunga.” Nginde yiming je äbrï yele yiju gwerre yiming je geꞌtaji gay geꞌte yiming je geꞌte giyoo yanni yima ila gwodan. ");
INSERT INTO lro_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","Ndi ari Yicu Kirictu gwärrü yiꞌral yanni yibupa je Ngwaalu nding je ärrï, yanni yima aar nje ye juꞌriyi nono mïꞌrïnï gwe nono gwudi ngwanginu ngwüngün ngwanni ngwuma gïꞌtïnï gomonanu geꞌte pu ꞌdar. ");
INSERT INTO lro_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","Giyomon giyomon, dirꞌdal dati dünälä ngwape yirꞌdala yani yobo yidi Ngwaalu ati je gu gwäꞌräjï mïꞌrïnï gwe nono gweꞌte gweꞌte ngwanni ngwati ꞌti äbrä keng kayanu gwudi dïjï. ");
INSERT INTO lro_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","A be anni ma dirꞌdal ndee dani Kirictu gatu mïꞌrïnïng nono nggwee gomonanu geꞌte pu ꞌdar, nginde gwuma jalu kaama gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","ꞌTuꞌtu kaji nggoo, nggwo be ndi ombaci gomon ganni gadi ge Ngwaalu gäbïcï ngwuroꞌta güwänälü güngün gora ge, ");
INSERT INTO lro_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","ndi ari mïꞌrïnï gwe nono gomonanu geꞌte pu, nginde gwuma mbütïyï ngwüjü gwurꞌtal ngwanni ngwuming je juꞌriyi. ");
INSERT INTO lro_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","15","Lïgïꞌrïm lanni Lijuꞌru londaci nje ꞌto ngwujaꞌri ngwee. Laru gwerre gwerre Deleny daru nu, ");
INSERT INTO lro_vpl VALUES ("HB10_16","088_10_16","HEB","10","16","16","“Gekajidi gwuru nggwee gwanni gwadi nyii le gekajidi ma gaji ila äny gwa geꞌte yobo yüny giyigoranu yegen na yinje ulli giyaꞌranyanu yegen.” ");
INSERT INTO lro_vpl VALUES ("HB10_17","088_10_17","HEB","10","17","17","Ngwoꞌre ngwugendaji ngwari, “Ke gwegen na apepe gwegen gwanni gwaꞌti ïndï kayalu gwaꞌta be gwung diwayini mana.” ");
INSERT INTO lro_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","Na manari yiꞌral giyee yima aar je düdänïjänü, mïꞌrïnï nono gwere gwaꞌta be gwa ji mana gwani ke. ");
INSERT INTO lro_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","19","Yäy gu no ngwänggärï, a la be gatu linginalu ndi änï ngwaalanu ngwanni Ngwujuꞌrana yïn ye yidi Yicu. ");
INSERT INTO lro_vpl VALUES ("HB10_20","088_10_20","HEB","10","20","20","Gay ge ganni giyang gïgïꞌtïjär nje ngwanginu ngwe ngwüngün ngwanni ngwo ngwumidu. ");
INSERT INTO lro_vpl VALUES ("HB10_21","088_10_21","HEB","10","21","21","A gu no, a lätï dirꞌdala danni dipa didi ngwuꞌdun ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","Ar be ꞌdonggaci Ngwaalinga yigor ye ꞌdiꞌdidanu yïcïnänü gwulleny ämnï gwe Ngwaalu yigor ye yege yanni yima aar je gwürä aar gäꞌrïnï giyiꞌral yanni yiki na ngwanginu ngwege ngwanni ngwuma üyïnï yaw ye yanni yijuꞌru. ");
INSERT INTO lro_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","Ar be mätïnälü mama ndi geꞌtaji gwanni gwati ar gwe ondaji, ndi ari Ngwaalu ngwanni gwaru ngwujaꞌri, ngwuru ligor leꞌte pu. ");
INSERT INTO lro_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","Ar be ïrïyï ngwäyälü ngwujaꞌri ngwanni ngwadi nje gäbïcï ar ojemajidi nono ndi ämnäjïdï na ngwaalu ngwudi ape yiiru yanni yijaw. ");
INSERT INTO lro_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","Aaꞌti a la gatani acajiding gwüpäng, anaku loko lanni lima gu äbräjï, ar be ojemajidi nono ar gu eladani gweere anni lïngïdär ndi ari gomon nggo ganni gadi ge Ngwaalu pïcï ngwüjü yelenya, gima ja gito. ");
INSERT INTO lro_vpl VALUES ("HB10_26","088_10_26","HEB","10","26","26","Manari a lima ji ndi elellalu mbar ndi ärrï yiꞌral yanni yiki, anni ma ar lenge ngwujaꞌri ngwanni ngwuru ꞌdidanu ngwenggacaar nje Ngwaalu, mïꞌrïnï nono gwere gwaꞌta be gwani ke gwege. ");
INSERT INTO lro_vpl VALUES ("HB10_27","088_10_27","HEB","10","27","27","A la be dünïcï ꞌdogo ndi aar nje gwe Ngwaalu obalu obalu gwe gwanni gwuru yedeny gwudi lïgä lanni ladi uꞌdiyi ngwüjü ngwanni ngwuru güwän gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB10_28","088_10_28","HEB","10","28","28","Nga nga lïlïngïdï ndi ari yobo yidi Müjä gïdïjï danni dima je kiyi, dati je ꞌti ïnädï dati aar ꞌrinye ma gu ngwüjï ari rom (2) na täꞌrïl (3). ");
INSERT INTO lro_vpl VALUES ("HB10_29","088_10_29","HEB","10","29","29","Ya be ruꞌtana Ngwaalu gïdïjï ma de Ngwaalu obalu manari dima obe Gïjü gidi Ngwaalu gora ge danni dima engga yïnä ꞌtur yidi gekajidi yanni yïgäꞌrïdï nje na nginde gwanni gwuma lo Lïgïꞌrïmä lanni lati nje äpïjä yïmïꞌrä yidi Ngwaalu? ");
INSERT INTO lro_vpl VALUES ("HB10_30","088_10_30","HEB","10","30","30","Ndi ari gwülïngïdär gwanni gwaru nu, “Yüny yiru ndi gwalli yiꞌra. Nggwa gwalli dämjä,” na mana, “Deleny da obalu ngwüjü ngwe ngwüngün.” ");
INSERT INTO lro_vpl VALUES ("HB10_31","088_10_31","HEB","10","31","31","Yiki gwulleny ndi ïꞌdï kuyanu gidi Ngwaalu ngwanni ngwumidu. ");
INSERT INTO lro_vpl VALUES ("HB10_32","088_10_32","HEB","10","32","32","Diwayinar yomon yidi gwerreng yanni yima ele, yanni yima ara je gu buri üllänü gwudi ämnï Ngwaalu Yicu gwe, anni ma gu mätïnälü ndi enati gwupa gija ge giyiꞌrendenyanu. ");
INSERT INTO lro_vpl VALUES ("HB10_33","088_10_33","HEB","10","33","33","Kaji geꞌte lïllüdïnä giyebedalu ara je übïnälü, na kaji goko ngaa le dünä lanni lärrä je gu no yïrïgïnä. ");
INSERT INTO lro_vpl VALUES ("HB10_34","088_10_34","HEB","10","34","34","Ara je ïnä lanni liju giyirna ngaa ämnï lijayanu ndi ara je apada ngwony ngwalu nunnu ngaa lïlïngïdï ndi ari ngaa lätï yuꞌrina kerala yanni yijayana yidi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("HB10_35","088_10_35","HEB","10","35","35","Yäy gu no, aaꞌti ngaa la gatu ïcïnïngänü gwalu mbüny, ngaa laji la mbuji guꞌru gïnänü. ");
INSERT INTO lro_vpl VALUES ("HB10_36","088_10_36","HEB","10","36","36","Ngaa libupa ndi määtä yigor yalu, ndi ari manari ngaa ärrï buping gwudi Ngwaalu, ngaa la mbuji ngwujaꞌri ngwanni ngwaru ngwe. ");
INSERT INTO lro_vpl VALUES ("HB10_37","088_10_37","HEB","10","37","37","Ndi ari yitab yaru gito gwuru ꞌdogo gwoko gwulleny, “Nginde gwanni nggwo gwadi ila, nggwo gwïndï gwaꞌti gwa jana. ");
INSERT INTO lro_vpl VALUES ("HB10_38","088_10_38","HEB","10","38","38","A be gwüny gwanni gwüdünälü, gwa elelle ämnï gwe Ngwaalu. Na manari gwuma oꞌra gwodan, gwaꞌti gwuny jadanu.” ");
INSERT INTO lro_vpl VALUES ("HB10_39","088_10_39","HEB","10","39","39","A be alanga läꞌtüdï ngwüjï ngwanni ngwüꞌrädï gwodan ar dudi, ar be ru ngwüjï ngwanni ngwämnä Ngwaalu ar gïlängïdïnï. ");
INSERT INTO lro_vpl VALUES ("HB11_1","088_11_1","HEB","11","1","1","Ämnï Ngwaalu gwani ïcïnänü ꞌdiꞌdidanu na dünïcï gwani yiꞌral yanni yati ꞌti enggana ngwäy ngwe. ");
INSERT INTO lro_vpl VALUES ("HB11_2","088_11_2","HEB","11","2","2","Ndi ari ngwüjï ngwudi gwerreng ngwätï ämnïng Ngwaalu, aar be jada Ngwaalinganu. ");
INSERT INTO lro_vpl VALUES ("HB11_3","088_11_3","HEB","11","3","3","Ämnï gwe Ngwaalu a lïlïngïdï ndi ari dïdlä ꞌdar dïgïꞌtïnä ngwujaꞌri ngwe ngwudi Ngwaalu. No ngwong ꞌdar gïdïdlä ngwanni ngwenggana, ngwügïꞌtïnä ngwong ngwanni ngwaꞌti enggana. ");
INSERT INTO lro_vpl VALUES ("HB11_4","088_11_4","HEB","11","4","4","Ämnï gwe Ngwaalu Äbïïl ngwügätïjï Ngwaalingalu mïꞌrïnïng nono gwujayana ndi mïꞌrïnï nono na gatalu gwudi gwenggen gwani Gayin. Yiru yanni yïgäbïcä Äbïlïng aar gwe be ari gwuru dïjï dïdünälü anni ma Ngwaalu gwondaji jayi gwe gwudi gatalu gwüngün na ämnï gwe Ngwaalu. Gwuma ayi a be ämnï gwe Ngwaalu gwüngün nggwona gwati aar gwe ondaji Äbïïl gwuma ayi ꞌtuꞌtu jadu. ");
INSERT INTO lro_vpl VALUES ("HB11_5","088_11_5","HEB","11","5","5","Ämnï gwe Ngwaalu, Akunug gwuma gatani dïdläyü ngwüꞌdïꞌrï ngwele kerala gwumidu aaꞌti yiꞌrany akana nono. Aar ꞌti mbuja ndi ari gwuma Ngwaalu ape. Ndi ari gwerre gwerre ndi aar ape, gwondaja gwe yitab ndi ari gwuru dïjï danni dïjädï Ngwaalinganu. ");
INSERT INTO lro_vpl VALUES ("HB11_6","088_11_6","HEB","11","6","6","Manari nga gwaꞌti ätï ämnïng Ngwaalu, nga gwaꞌti gwa burni ndi olati ndi jayiyi Ngwaalinganu. Ndi ari dïjï danni dadi ila Ngwaalu, gwerre gwerre ngwämnï Ngwaalu ndi ari Ngwaalu ngwo na ndi ari ngwati ätädä ngwüjü ngwanni ngwati bupi ꞌdünggüngün ꞌdiꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("HB11_7","088_11_7","HEB","11","7","7","Ämnï gwe Ngwaalu ꞌto gwudi Nuuwa, gaji ganni gima ge Ngwaalu ondaci yiꞌral ye yanni yiki yadi ele ndi ji yaꞌting je na änggädï, a yedeny eny ngwuꞌdengenaji Ngwaalinga, ngwoda bälükä gwupa, gwanni gwuma gïlängïdïyï ngwüjü ngwüngün. Na ämnï gwe gwüngün Ngwaalu, ngwobalu ngwüjï ngwe ngwudi dïdlä, ngwuru gwuma ape yuꞌrina yidi ngwüjï ngwanni ngwüdünälü gwanni gwati ila ämnï gwe Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB11_8","088_11_8","HEB","11","8","8","Ämnï gwe Ngwaalu, Äbräyïm gwuꞌdengenaca Ngwaalinga, anni urnidaar ngwüꞌdïꞌrï ngwugatani geno güngün ngwele ken giꞌter ganni gica ge Ngwaalu ndi ari ga aar ätädä yuꞌrina, gwuma ꞌdïꞌrï ngwele ngwaalu ngwaꞌting je lïngïdï ngwüjädï ne. ");
INSERT INTO lro_vpl VALUES ("HB11_9","088_11_9","HEB","11","9","9","Ämnï gwe Ngwaalu, nginde gwuju ken nggoo nono mung ru dïrnü ken gidi ngwüjï ngwuꞌter a mine Ngwaalu ru ngwuca gading ätädä ngindeng. Ating ji gïyäꞌtänü a gu Ijaaginga Yagub gwe ji lanni gwati aar le ape yuꞌrina yanni yaru ye Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB11_10","088_11_10","HEB","11","10","10","Ndi ari nginde gwügätädï kündär ngwäyänü ganni gätï yidingo Ngwaalu ngwuru ngwugeꞌta aar oda. ");
INSERT INTO lro_vpl VALUES ("HB11_11","088_11_11","HEB","11","11","11","Ämnï gwe Ngwaalu ꞌto, a daw düngün dani Jarra gwanni gwuru dïmäyïn ngwuru gurrum burni ndi lenge ndi ari gwänggädï ndi ari Ngwaalu ngwanni ngwaru ngwujaꞌri, ngwuru ligor leꞌte pu. ");
INSERT INTO lro_vpl VALUES ("HB11_12","088_11_12","HEB","11","12","12","Na a gu no gïdïjï ndee deꞌte pu aar lenge Äbräyïm gwe anaku rung gu dïmäyïn gwaꞌti ba be ätï yiima ndi lenge yïjü yonyadu ꞌdi aar ru nono yuurrumu kerala na nono dïjïcïrä gidibirta danni dati ꞌti da düꞌränä. ");
INSERT INTO lro_vpl VALUES ("HB11_13","088_11_13","HEB","11","13","13","Ngwüjï ngwee ꞌdar ngwuju na ndi elelle ämnï gwe Ngwaalu gwerre gwerre ndi aar ayi. Ngwaꞌti apu ngwujaꞌri ngwanni ngwuca je ngwe Ngwaalu, ngwänggädäär je ꞌdogo ngwola ngwaalinganu aar je ape giyigoranu. Aar ämnädä ndi ari liru ꞌter aar ru ngwïrnü ngene gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("HB11_14","088_11_14","HEB","11","14","14","Ngwüjï ngwanni ngwati gu ari yiꞌral no, ngwülïngïdï ndi ari ngindenga gilo ndi dünïcï geno gegen ganni gadi aar gu ji. ");
INSERT INTO lro_vpl VALUES ("HB11_15","088_11_15","HEB","11","15","15","Adinari liju ndi ïräjï ngwäy ken ngene gïdïyängälü ganni gima aar gatani, laadi gu be mbojaji gay ndi oꞌraci. ");
INSERT INTO lro_vpl VALUES ("HB11_16","088_11_16","HEB","11","16","16","Aar be manni ji ndi mïnï geno ganni gijayana gidi gerala. Yäy gu no, Ngwaalu ngwaꞌti je yaaru apu ndi aar ci Ngwaalu ngwegen ndi ari ngwuming je gïꞌtïjä gündärä mama. ");
INSERT INTO lro_vpl VALUES ("HB11_17","088_11_17","HEB","11","17","17","Ämnï gwe Ngwaalu gwudi Äbräyïm, ngwügäbïcï anni ma Ngwaalu ïdäjï, ngwape gïjü güngün gani Ijaag ngwümïnï nding ge mïꞌrïnï nono ngwügätïjï Ngwaalingalu. Ngwube ru ngwanni gwapu ngwujaꞌri ngwuca ngwe Ngwaalu ngwube mïnï ndi mïꞌrïnï nono gïjï ge güngün ꞌdogo giru geꞌte pu ngwügätïjï Ngwaalingalu. ");
INSERT INTO lro_vpl VALUES ("HB11_18","088_11_18","HEB","11","18","18","Nginde gwülïngïdï gu ndi ari gwuca Ngwaalu, “Ndi Ijaag nga gwadi ätï gilinge ganni garu nyi ge.” ");
INSERT INTO lro_vpl VALUES ("HB11_19","088_11_19","HEB","11","19","19","A be Äbräyïm geꞌte ndi ari Ngwaalu ngwätï yiima yanni yadi ꞌdïꞌrïyä dïjü dayu mana. Na yima gu ru ꞌdidanu ndi ari Äbräyïm gwuma gwäꞌrä Ijaaging giyiꞌranyanu na yiꞌral giyee yiru giꞌremna. ");
INSERT INTO lro_vpl VALUES ("HB11_20","088_11_20","HEB","11","20","20","Ämnï gwe Ngwaalu, a Ijaag onjaci Yagubinga je Yiiju gwe gwani elelle gwegen gwudi gweereng. ");
INSERT INTO lro_vpl VALUES ("HB11_21","088_11_21","HEB","11","21","21","Ämnï gwe Ngwaalu, a Yagub gwüdïrnädï kibro ngwukwuci Ngwaalinganu gwadi ayi ngwonjaci yïjü yidi Yüjïb rom (2). ");
INSERT INTO lro_vpl VALUES ("HB11_22","088_11_22","HEB","11","22","22","Ämnï gwe Ngwaalu, Yüjïb anni mung ji gito gwadi ayi, ngwondajani gwani ꞌtü ngwudi Yïjïräyïl ken gani Mijir ngwuje ondacani gwani yuya yüngün aar je apani. ");
INSERT INTO lro_vpl VALUES ("HB11_23","088_11_23","HEB","11","23","23","Ämnï gwe Ngwaalu papanga nanni gwe lidi Müjä anni ma aar lenge Müjäng aar ape aar änïjälü ngwätï ngwüüwäyü täꞌrïl, ndi ari gwänggädäär gwäꞌtüdï ꞌtur, a je ꞌti yedeny ïtï ngwujaꞌri ngwudi deleny. ");
INSERT INTO lro_vpl VALUES ("HB11_24","088_11_24","HEB","11","24","24","Ämnï gwe Ngwaalu, Müjä anni mung pe ngwuꞌdonya ndi aar ci gwuru gïjï gidi gera gidi deleny didi Mijiring. ");
INSERT INTO lro_vpl VALUES ("HB11_25","088_11_25","HEB","11","25","25","A nginde ämnï ndi aar acajidi giyeꞌrendenyanu yidi yïnäd ngwüjï ngwe ngwudi Ngwaalu ndi ari ngwuji ndi jayanu gwudi ke gwobla gajanu. ");
INSERT INTO lro_vpl VALUES ("HB11_26","088_11_26","HEB","11","26","26","Nginde gwänggädï ndi ari ji gïyïrïgïnä gwani nginde gwudi Ngwaalu gwanni Gwubrutaar yelenya, yipana guꞌru giyuꞌrin yidi Mijiring ndi ari gwombajidu kuꞌru güngün gweere ganni gïdünïcä. ");
INSERT INTO lro_vpl VALUES ("HB11_27","088_11_27","HEB","11","27","27","Ämnï gwe Ngwaalu gwüngün, ngwugatani Mijiring aaꞌti yedeny ïtï küündä gidi deleny didi Mijiring ngwüꞌdïꞌrï ngwele ndi ari gwänggädï Ngwaalinga ngwanni ngwaꞌti enggana. ");
INSERT INTO lro_vpl VALUES ("HB11_28","088_11_28","HEB","11","28","28","Ämnï gwe Ngwaalu gwüngün, a Müjä enggaci ngwüjü awa ndi ape dïmürä didi Dambdani na gwürä gwudi yïn nunnu yiꞌrany yanni yïꞌrïnyïtï yïjü yanni yiru yiꞌra yidi Ngwumijir, aaꞌti ya akani yïjü nono yanni yiru yiꞌra yidi Yïjïräyïl. ");
INSERT INTO lro_vpl VALUES ("HB11_29","088_11_29","HEB","11","29","29","Ämnï gwe Ngwaalu, a ngwüjï ꞌdar üꞌrü yaanu yidi Bar Alamring nono ma aar ele gïdïyängälü dundalu. A be anni ma ngwüjï ngwudi Mijiring mïnï ndi aar je gwuji, a je yaw ïꞌdätïyï ꞌdar aar ayi. ");
INSERT INTO lro_vpl VALUES ("HB11_30","088_11_30","HEB","11","30","30","Ämnï gwe Ngwaalu gwegen, aar gäbïcï yundiꞌru yidi Ariyang aar ïꞌdï anni ma aar je landajalu aar je rekajalu yomonanu kwoꞌra täꞌrïl (7). ");
INSERT INTO lro_vpl VALUES ("HB11_31","088_11_31","HEB","11","31","31","Na ämnï gwe Ngwaalu, daw diru dedr dani Riyab anni mung ämnï ndi ülläjï ngwujimidalu ngwudi Yïjïräyïl yïrnü ngwanni ngwïndï ndi ombaji genanu, nginde gwuma aar ꞌrïnyïtï ngwüjïngä le ngwanni ngwünyürtïjä Ngwaalinganu. ");
INSERT INTO lro_vpl VALUES ("HB11_32","088_11_32","HEB","11","32","32","Na yiru ange mana yonyadu yadi nyi ye ari? Gaji gaꞌti ndi nyi ondaji gwani Jiduun na Baarag na Jämïjün na Yapta na Däwüd na Jämüwïl na ngwïjïr, ");
INSERT INTO lro_vpl VALUES ("HB11_33","088_11_33","HEB","11","33","33","ämnï gwe Ngwaalu gwegen, aar dami yelenya, aar übïdïyï ngwüjänü, aar ape guꞌru ganni gica je ge Ngwaalu, aar gäbïcï ngwiira aar määtä ngwulem. ");
INSERT INTO lro_vpl VALUES ("HB11_34","088_11_34","HEB","11","34","34","Aar ꞌrinye yiima yidi lïgä na aar mbuji yiima ꞌto aar abri aar je ꞌti ꞌrïnyïtï. Ndi amiꞌrati gwegen, aar je ätädä yiima aar ru ngwongor ngwojema nono gïyääränü aar dïnyï ngwongora ngwudi yen poor. ");
INSERT INTO lro_vpl VALUES ("HB11_35","088_11_35","HEB","11","35","35","Ämnï gwe Ngwaalu, ngwaw ngwoko gwäꞌrï ngwüjü ngwegen mana gwanni ngwayu aar ꞌdïꞌrälü mana ngwumidu. Na loko aar je pï ꞌdi aar ayi aar ꞌdonya ndi aar je gatalu ndi ari ngindenga lïlïngïdï ndi ari la mbuji guꞌru gidi ꞌdïꞌrï ndi midi gwanni gwujayana. ");
INSERT INTO lro_vpl VALUES ("HB11_36","088_11_36","HEB","11","36","36","Loko lima aar je ärï ngwïmä aar je pï ngwacal ngwe na loko aar je ummi aar je gekajalu korkon. ");
INSERT INTO lro_vpl VALUES ("HB11_37","088_11_37","HEB","11","37","37","Loko aar je aci yoꞌrr ye aar ayi na loko aar je üꞌränü rom aar je ꞌrinye na loko aar je pï yalal ye aar je ꞌrinye. Aar elellalu ligenna ngwurna ngwudi ngwangal na yooꞌra, aar nyangiralu, aar je übïnälü aar je ärrï yïrïgïnä. ");
INSERT INTO lro_vpl VALUES ("HB11_38","088_11_38","HEB","11","38","38","Ngwüjï ngwee ngwujaw ꞌdi aaꞌti dïdlä ndee diki rüdï ngwaalu ngwädï je ngwäy, aar ꞌräꞌrälü gïtäny poor, giyenala ngwubanganu na ngwïyänü gïdïyängänü. ");
INSERT INTO lro_vpl VALUES ("HB11_39","088_11_39","HEB","11","39","39","Ngwüjï ngwee ꞌdar, ngwondaja ngwe Ngwaalu gwani ämnï Ngwaalu gwegen a be daꞌti danni dapu guꞌru ngwujaꞌri ngwanni ngwuca je ngwe Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB11_40","088_11_40","HEB","11","40","40","Ngwaalu ngwugegeꞌta yiꞌral yanni yijayana nunnu ꞌdogo aji a nje le Ngwaalu mbütïyï gwüpäng ngindenga le. ");
INSERT INTO lro_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","1","Yäy gu no, anni ätär ngwüjü ngwee ngwonyadu ngwanni ngwinggidu ämnï gwe Ngwaalu gwegen, ngwo ngwiye nje, gäbïcär be ar gatu ꞌto yiꞌralalu ꞌdar mbüny yanni yati nje ümnïcï ar je gatana ꞌdar yanni yiki yanni yati nje gwüꞌrïnggïlïyï torneny, ar dokalata kay ganni gima aar nje üꞌrïcï ar gu orꞌtemaja. ");
INSERT INTO lro_vpl VALUES ("HB12_2","088_12_2","HEB","12","2","2","Ar ombajidi ndi Yicu gwanni gwuru dooꞌra ngwuru mbuti gwudi ämnï Ngwaalu gwege, gwanni gworꞌtemaja aar ꞌrinye küꞌrälä gwani jayanu gwanni gwüdünïcä ngindeng, aar ꞌrinye yiꞌrany yiru yaaru küꞌrälä gwuma jalu kaama gidi ngwuduꞌri ngwudi yeleny ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("HB12_3","088_12_3","HEB","12","3","3","Ïrïyär be ngwäyälü gwulleny gwani orꞌtemaji gwüngün ndi übïnälü gwanni gwübïnä gwe ngwüjälü ngwanni gwuki, nunnu aaꞌti ngaa la gakidi ngaa gatu yigor mbüny. ");
INSERT INTO lro_vpl VALUES ("HB12_4","088_12_4","HEB","12","4","4","Ndi kwudi gwalu yiꞌral ye yanni yiki yidi ngwüjï gïdïdlä, nga gilona laꞌti mbuja dïrbä ndi ari ara je ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("HB12_5","088_12_5","HEB","12","5","5","Ngaa lima dodani ngwujaꞌri ngwanni ngworꞌtemaja je ngwe Ngwaalu ndi ari ngaa liru yïjï yüngüne? Nginde gwaru pa, “Gwani gïjï güny, aaꞌti a gwa anidanu ola gwe gwudi Deleny na aaꞌti a gwa gatu ligor mbüny ma aar ang girinyada giyiꞌral yanni yiki. ");
INSERT INTO lro_vpl VALUES ("HB12_6","088_12_6","HEB","12","6","6","Ndi ari nginde gwuru Deleny gwati reraji ngwüjü ngwanni ngwating je ämnï, na gwati reraji dïjü dere danni dating ämnï nono gïjï güngün.” ");
INSERT INTO lro_vpl VALUES ("HB12_7","088_12_7","HEB","12","7","7","Orꞌtemajar gïdïrbänü gwani reraji, Ngwaalu ngwärrä je nono yïjü yüngün. Ndi ari gïjï gïndï ne gati ꞌti mbumbu gwüngün reraja? ");
INSERT INTO lro_vpl VALUES ("HB12_8","088_12_8","HEB","12","8","8","Ma aar je ꞌti reraja, na nono ati aar gu reraji ngwüjü ꞌdar, ngaa läꞌtüdï yïjï yidi Ngwaalu ꞌdidanu ngaa läpïnälü mbüny ngaa liru ngwurdina. ");
INSERT INTO lro_vpl VALUES ("HB12_9","088_12_9","HEB","12","9","9","Yeꞌte yeꞌte mana, alanga ꞌdar, lätï papang je lidi dïyäng lanni lireraji nje ar je gu ꞌdengenaci. Ya ruꞌtana ndi ari ar denya Ngwaalinga ngwuru papa gwudi ngwügïꞌrïm ngwege nunnu ar midi! ");
INSERT INTO lro_vpl VALUES ("HB12_10","088_12_10","HEB","12","10","10","Papanga lege lati nje reraji gaji goko gwani yanni yänggädäär je yijayana gwani alanga, a be Ngwaalu ngwati nje reraji gwani jayi gwege nunnu ar le acajidi ndi juꞌri gwüngün. ");
INSERT INTO lro_vpl VALUES ("HB12_11","088_12_11","HEB","12","11","11","Reraji gwati ꞌti jaw kaji gweneno, a be gwati ang büdïyï nono. A be gwodan ngwube aji ngwapa ꞌriꞌring gwudi dünälü ngwügäbïcï ngwüjü ngwanni ngwurerajaar je, aar ru ngwüjï ngwadatalu. ");
INSERT INTO lro_vpl VALUES ("HB12_12","088_12_12","HEB","12","12","12","Yäy gu no, ojemar be ngwuy nono ngwalu ngwanni ngwuju ꞌrigany na yirku yalu yanni giyo yiju ꞌrïbül ndi ari, ");
INSERT INTO lro_vpl VALUES ("HB12_13","088_12_13","HEB","12","13","13","“Ngaa gïꞌtïjï yora yalu gay gïdünälü,” nunnu gwanni gwuru dimjo, aaꞌti gwa ji ndi ele yimijonga, ngwube manni uꞌri nono. ");
INSERT INTO lro_vpl VALUES ("HB12_14","088_12_14","HEB","12","14","14","Jar ꞌdïꞌdäny ngaa geꞌte yiima ꞌdar ndi elelle ladatalu ngwüjïngä le ꞌdar ngaa juꞌri ndi ari ma juꞌri erne, gwere gwaꞌti ätï enggang Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("HB12_15","088_12_15","HEB","12","15","15","Arnganar ndi ari aaꞌti gwere gwa ji gwa amiꞌrati gïyïmïꞌrü yidi Ngwaalu ndi ari aaꞌti yigor yalu ya ru nono diꞌrokr ꞌdanggalanu ara je nyamidiyi ara je digang lonyadu. ");
INSERT INTO lro_vpl VALUES ("HB12_16","088_12_16","HEB","12","16","16","Arnganar ndi ari aaꞌti gwere gwa ji gwümïꞌrïdï ngwäyänü, dübïdï Ngwaalinga gora ge nono Yijung, gwanni gwüpïyä yuꞌrinanu yüngün gwuru gïjï giru giꞌra eny gwe gwudi gomon geꞌte pu. ");
INSERT INTO lro_vpl VALUES ("HB12_17","088_12_17","HEB","12","17","17","Ngaa lïlïngïdï gu ndi ari anni mung aji ngwümïnï ndi gwäꞌrï yuꞌrina yidi onjaci giyoo, yima aar je ünyä. Ngwuje mïnï yal ye ngwuꞌti mbuja gay gere. ");
INSERT INTO lro_vpl VALUES ("HB12_18","088_12_18","HEB","12","18","18","Ngaa laꞌti ïndädï Ngwaalu ken ganni ga aar akani nono anaku arru gu ngwüjï ngwudi Yïjïräyïl ken gani Jïnä ganni güꞌdïnä lïgä, giru dïrïm, ngwuru dumbil na dirun diru dudu. ");
INSERT INTO lro_vpl VALUES ("HB12_19","088_12_19","HEB","12","19","19","Ngaa laꞌti ïndädï ngwaalu ngwanni ngwärïnä gu giil, na dulu danni dondaja ngwujaꞌri anni ma aar je ꞌdingini, aar ari, a je yedeny eny aar pälü ndi ari aaꞌti la je Ngwaalu ondaci mana. ");
INSERT INTO lro_vpl VALUES ("HB12_20","088_12_20","HEB","12","20","20","Ndi ari ngindenga laꞌti ätï ngwangina ngwadi aar ngwe ꞌdingini ngwujaꞌri ngwündäjïnä aar ari, “ꞌDi ma gong akani geno nono, aar aci yoꞌrr ye ꞌdi aar ꞌrinye.” ");
INSERT INTO lro_vpl VALUES ("HB12_21","088_12_21","HEB","12","21","21","A ngwaalu ngwoo ru yedeny ꞌdi aar gäbïcï Müjäng ngwondaji ngwari, “Äny gwudidiꞌru yedenyo.” ");
INSERT INTO lro_vpl VALUES ("HB12_22","088_12_22","HEB","12","22","22","A be ngaa lima be ilada Ngwaalu ken gani Jäyün gani Üräjälïm gwudi gerala, gwuru gündär gidi Ngwaalu ngwanni ngwumidu. Ngaa lima ilada gïyïꞌrr ngwüüꞌrï ngwüüꞌrï, ndi oꞌrajidalu gwudi jayanu. ");
INSERT INTO lro_vpl VALUES ("HB12_23","088_12_23","HEB","12","23","23","Ngaa lima ilada kiꞌdoonga gidi yïjï yidi Ngwaalu yanni yiru yiꞌra yanni yima aar je ulli ngwürïny ngwegen kerala. Ngaa lima ilada Ngwaalu ngwanni ngwati obalu ngwüjï ngwe ꞌdar. Ngaa lima ilada ngwaalu ngwudi ngwügïꞌrïm ngwudi ngwüjï ngwanni ngwüdünälü ngwanni ngwuma aar je geꞌte ngwumbutu. ");
INSERT INTO lro_vpl VALUES ("HB12_24","088_12_24","HEB","12","24","24","Ngaa lima ilada gidartan dani Yicu gwanni gwuma ji gidiliganu aar nje gwäꞌräjïdï Ngwaalinga le ndi gekajidi gwanni gwuyang. Ngaa lima ilada gïyïn yidi Yicu yanni yïgwüränä yondaja ngwujaꞌri ngwujayana gïyïn yidi Äbïïl. ");
INSERT INTO lro_vpl VALUES ("HB12_25","088_12_25","HEB","12","25","25","Arnganar gu be ndi ari aaꞌti gwa aang obe gora ge gwanni gwondaja. Manari ngindenga liru Ngwüyäwüd lima ꞌti gwännädï ngindeng gwanni gwübïdäär gora ge gwanni gwürngädï je ngene gïdïyängälü, ya ar je be mbuji yanni yiru ꞌtanaa manari gwuma ar gwürläcï luꞌra gwanni gwürngädï nje kerala? ");
INSERT INTO lro_vpl VALUES ("HB12_26","088_12_26","HEB","12","26","26","Kaji nggoo, yal yüngün yilagaja dïyängälü, a be gweneno yiming ye yari nu, “Mana äny gwoꞌre gwaꞌti gwa lagaji dïyängälü ꞌdogo jücü gwene, äny gwa lagaji geralu ꞌto.” ");
INSERT INTO lro_vpl VALUES ("HB12_27","088_12_27","HEB","12","27","27","Ngwujaꞌri ngwani, “Mana äny gwoꞌre” ngwinggida ndi ari yanni yati lagadalu, ya äbrïnï, yäbïngädï ngwong ngwanni ngwügïꞌtïnä nunnu aar jalu yanni yati ꞌti lagadalu. ");
INSERT INTO lro_vpl VALUES ("HB12_28","088_12_28","HEB","12","28","28","Yäy gu no, anni raar gu ndi ari a lapu yelenya yanni yati aar je ꞌti lagajalu, a la be ci Ngwaalinga yäy ꞌtu gwonyadu. A gu no, ar je äpïjï yobo ye yanni yïndï kayalu ar denya aar nje yedeny eny ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("HB12_29","088_12_29","HEB","12","29","29","Anaku aru gu yitab ndi ari, “Ngwaalu ngwege ngwuru lïgä lïtï.” ");
INSERT INTO lro_vpl VALUES ("HB13_1","088_13_1","HEB","13","1","1","Mätïnärälü ndi ämnäjïdï yengga. ");
INSERT INTO lro_vpl VALUES ("HB13_2","088_13_2","HEB","13","2","2","Aaꞌti ngaa la dudanu ndi gwäꞌrï ngwïrnü ndi ari yïgäbïcä ngwüjü gwerre aar gu arri ꞌdi aar gwäꞌrï yïꞌrrä yïrnü aar ꞌti lïngïdï ndi ari yïꞌrr yiru. ");
INSERT INTO lro_vpl VALUES ("HB13_3","088_13_3","HEB","13","3","3","Diwayinar ngwüjü ngwanni ngwo giyorkon nono ma aang ngwe ji giyorkon gwüpäng. Ngaa runi ngwüjïngä le ngwanni ngwärräär je yündä nono ma aar je gu ärrï ꞌto. ");
INSERT INTO lro_vpl VALUES ("HB13_4","088_13_4","HEB","13","4","4","A ngwüjï ꞌdar denya agiding, a ngwümbür ngwudi ngwüjï ngwagidu jüꞌrïnï, ndi ari Ngwaalu ngwa ji ngwobalu dïjï de danni dïmïꞌrïdï ngwäyänü na ngwïjïn ꞌdar. ");
INSERT INTO lro_vpl VALUES ("HB13_5","088_13_5","HEB","13","5","5","Aaꞌti ngaa liru ngwïnäd ngwudi ngwüꞌrïny, ïtär je yalu yanni yätä je kuyanu ndi ari Ngwaalu gwaru nu, “Äny gwaꞌti gwa gwe ïꞌdädänü äny gwaꞌti gwa ang gatani aꞌtur.” ");
INSERT INTO lro_vpl VALUES ("HB13_6","088_13_6","HEB","13","6","6","No a la gu be ïcïnädä ar ari, “Deleny diru gataji düwä gwüny, yedeny yere yaꞌti yiny eny. Ndi ari yiru ange yere ya aar nje dïjï ärrï?” ");
INSERT INTO lro_vpl VALUES ("HB13_7","088_13_7","HEB","13","7","7","Giyomon ꞌdar, diwayinar ngwüjü ngwanni ngwondaca je ngwujaꞌri ngwudi Ngwaalu. Ngaa je engga ndi ari lelella awa gïdïlä ꞌdi aar ayi ngaa gwuji gora ndi ämnï Ngwaalu gwegen. ");
INSERT INTO lro_vpl VALUES ("HB13_8","088_13_8","HEB","13","8","8","Yicu Kirictu gwuru gweꞌte gweꞌte anaku rung gu gwerre, gwuru gweꞌte gweꞌte gwene na gwa ru gweꞌte gweꞌte gwurꞌtal. ");
INSERT INTO lro_vpl VALUES ("HB13_9","088_13_9","HEB","13","9","9","Aaꞌti la je dudiyi, ngaa la gatani ngwujaꞌri ngwanni ngwïndädä gu ngaa gwujani ngwujaꞌri ngwuꞌter. Yijaw gwulleny giyigor yege ndi ari ar ojeme nono yïmïꞌrü ye yidi Ngwaalu, aaꞌti yani dïmürä de dani ngwudagiꞌra ngwanni gwaꞌti ätï guꞌru gere ngwüjï ngwanni ngwati je eny. ");
INSERT INTO lro_vpl VALUES ("HB13_10","088_13_10","HEB","13","10","10","Alanga lätï dagada danni dati aar gu ape yiiru käꞌtänü laꞌti gu ätï yiima ndi eny. ");
INSERT INTO lro_vpl VALUES ("HB13_11","088_13_11","HEB","13","11","11","Gwerre, dirꞌdal danni diru giꞌra dati ape yïnä yidi mïꞌrïnï nono ngwuye änï ngwaalu ngwanni Ngwujuꞌrana yidi gatalu gwudi ke, a be ngwanginu gwudi gong gidi mïꞌrïnï nono ngwube üꞌdïnï poor ngwaalu ngwudi üllälü. ");
INSERT INTO lro_vpl VALUES ("HB13_12","088_13_12","HEB","13","12","12","Yiru gu ꞌto ndi ari Yicu gwïtï yiꞌrendeny nono poor längïr lidi gündär nunnu ngwujuꞌriyi ngwüjü nono ngwudi Ngwaalu yïn ye yüngün. ");
INSERT INTO lro_vpl VALUES ("HB13_13","088_13_13","HEB","13","13","13","Ar be ꞌtü, ar ele ꞌdünggüngün poor, ar üpïnï yaaru yanni yüpïnïng je. ");
INSERT INTO lro_vpl VALUES ("HB13_14","088_13_14","HEB","13","14","14","Ndi ari ngene gïdïdlä, a laꞌti ätï gündärä gidi gwurꞌtaling, ar be mïnï gündärä ganni gadi ila. ");
INSERT INTO lro_vpl VALUES ("HB13_15","088_13_15","HEB","13","15","15","Yicu gwe, gäbïcä ar elada gweere ndi gätïjï Ngwaalingalu yomon ꞌdar mïꞌrïnïng nono gwudi ortada gwudi ngwulem ngwege ngwanni ngwati ondaji ngwürïny ngwüngün. ");
INSERT INTO lro_vpl VALUES ("HB13_16","088_13_16","HEB","13","16","16","Aaꞌti ngaa la dudanu ndi ärrï yiꞌral yanni yijaw ndi aang le emadi liꞌter, ndi ari mïꞌrïnï nono gwuru nggwee gwanni gwüjädï Ngwaalinganu. ");
INSERT INTO lro_vpl VALUES ("HB13_17","088_13_17","HEB","13","17","17","ꞌDengenacar ngwelenya ngwalu ngaa ꞌdengenaji yelenya yegen ndi ari yiiru yegen yiru ndi aar je arnga gïlïgïꞌrïm lalu gaji ꞌdar ndi ari ladi je Ngwaalu otacalu gwani yiiru yegen. ꞌDengenar je nunnu a yiiru yegen ru jayanu aaꞌti ya ru nï ndi ari yaꞌti ya gu jayi ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("HB13_18","088_13_18","HEB","13","18","18","Otacar Ngwaalingalu gwani änyängä ndi ari a yigor yärï juꞌranu ndi ari nyii elelle giyomonalu ꞌdar lïꞌdïꞌräjä yiꞌrala. ");
INSERT INTO lro_vpl VALUES ("HB13_19","088_13_19","HEB","13","19","19","Gwece gwece nggwa je päcälü otacar Ngwaalingalu ndi ari aar nyi gwäꞌrä a je oꞌraca puprang. ");
INSERT INTO lro_vpl VALUES ("HB13_20","088_13_20","HEB","13","20","20","A Ngwaalu ngwudi adatalu, yïn ye yidi gekajidi gwudi gwurꞌtaling gwanni gwuma ꞌdïꞌrïyä Delenyalu dege dani Yicu giyiꞌranyanu, gwuru dooꞌra dipa didi ngwangal, ");
INSERT INTO lro_vpl VALUES ("HB13_21","088_13_21","HEB","13","21","21","ara je jaꞌrima yiꞌral ye ꞌdar yanni yijaw ndi ärrï buping gwüngün. Ngwape yiiru ꞌdengganu yanni yïjädänü Yicu Kirictu gwe, gwanni gwünäjïnä giyomon ꞌdar. Yiru gu. ");
INSERT INTO lro_vpl VALUES ("HB13_22","088_13_22","HEB","13","22","22","Ngwänggärï, nggwa je päcälü ndi nyi ämnïcï ngwujaꞌri ngworꞌtemaja je ngwe ndi ari ngwüllïjä je ꞌdogo ngwaꞌti olanu. ");
INSERT INTO lro_vpl VALUES ("HB13_23","088_13_23","HEB","13","23","23","Äny gwubupa je ngaa lenge ꞌto ndi ari diweengga dege dani Timijawuj dima aar gatalu. Mung obana puprang, gwuny gwe ila ara je ombaja. ");
INSERT INTO lro_vpl VALUES ("HB13_24","088_13_24","HEB","13","24","24","Agannar ngwüjü ꞌdar ngwanni gwuru yiꞌra yalu ngaa aganni ngwüjü ꞌdar ngwudi Ngwaalu. Ngindenga lidi Italiyang, laganna je. ");
INSERT INTO lro_vpl VALUES ("HB13_25","088_13_25","HEB","13","25","25","Ara je gu yïmïꞌrü ji ꞌdar!");
INSERT INTO lro_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Ngwujaꞌri ngwee ngwïndï ꞌdünggüny äny gwani Yagub gwuru dïnäd didi Ngwaalu nyi ru dïnäd didi Deleny dani Yicu Kirictu, ngwükäcä je ngaa ru yïïlü yidi Yïjïräyïl ꞌdï na rom (12) lanni gilo libadalu giyenanu yidi ngwüjï ngwuru Garany. Nggwaganna je. ");
INSERT INTO lro_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Lani ngwänggärï, jayaranu manari dïrbä donyadanu dima je mïmïnnï nono. ");
INSERT INTO lro_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","Ngaa lïlïngïdï ndi ari mïmïnnï nono gwani ämnï Ngwaalu gwalu gwata je gendaci yiima ngaa orꞌtemaji. ");
INSERT INTO lro_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","A orꞌtemaji ape yiiru yüngün ngwuje medaji ꞌdanggalanu nunnu ngaa pe ndi bebere ngaa mbuti aaꞌti ya gu amiꞌrati yere. ");
INSERT INTO lro_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Manari gwere nggwo ꞌdanggalanu gwamiꞌratu ndi bebere, ngwotaci Ngwaalingalu ngwanni ngwati ätä ngwüjü ꞌdar ligor le ngwuje ꞌti gïꞌtïnïjälü yere yanni yiki, a ya aar je ätädä. ");
INSERT INTO lro_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Ma be ari gwuming otacalu, ngwuru dïjï dämnä Ngwaalu aaꞌti da ru dïjï daꞌti gätï ligoralu dümïmänü, ndi ari gwanni gwati ümïmänü, gwuru nono dudu didi yaw dati dirun ärälü ngwuye pï gändïkä. ");
INSERT INTO lro_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Dïjï ndoo aaꞌti da geꞌte ndi ari da mbuji gony gere Gideleny. ");
INSERT INTO lro_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","Nginde gwuru dïjï diru yigoranu rom (2) daꞌti mätïnälü ndi ape ape güngün ꞌdar. ");
INSERT INTO lro_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Manari diweengga danni diru diwayi dima aar allijala, ngwïrïngïnï Ngwaalinga ndi allijala gwüngün. ");
INSERT INTO lro_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","A be nginde gwanni gwünänü manari gwuma aar ülläjälü, ngwïrïngïnï Ngwaalinga ndi ülläjälü gwüngün, ndi ari gwadi ele ndi ayi nono ngwududi nono gwele yibobo yidi ngwaꞌri. ");
INSERT INTO lro_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Ndi ari lingen lati anda a deja büdï a ngwaꞌri ayi nono a yibobo ayi nono aar miꞌriꞌtadalu a jayi gwegen geradalu. Yiru gu yeꞌte yeꞌte ꞌto gïdïjï danni dïnänü, dïjï danni dïnänü da ayi nono da dudi diju ndi ꞌtäjï ngwäy giyiiru yüngün. ");
INSERT INTO lro_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Gwonjacaar gwanni gwuru dïjï dorꞌtemaja dïmïmïnnär nono, nunnu manari dima gwällïnï, da aar giki giꞌriba gidi yeleny gidi midi ganni gima gwe Ngwaalu ci ngwüjü ngwanni ngwati ämnï ngindeng. ");
INSERT INTO lro_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Ma aar je ïdäjï mbuji, aaꞌti dïjï da ari, “Ngwaalu ngwuru ngwïdäjïny.” Ndi ari Ngwaalu ngwati je ꞌti yiꞌral yanni yiki ïdäjä na ngwati ꞌti ïdäjä dïjü dere. ");
INSERT INTO lro_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","A be dïjï diru deꞌte deꞌte dati amiꞌra gwüngün gwanni gwuki ïdäjï ngwokta ngwïꞌdätïyï. ");
INSERT INTO lro_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Ma amiꞌra gwanni gwuki mätïnälü, gwati apa keng a ke mung pe, ngwati apa yiꞌrany. ");
INSERT INTO lro_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Aaꞌti la je dudiyi, lani ngwänggärï ngwämnï nje. ");
INSERT INTO lro_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Angidaji ꞌdar gwanni gwujaw gwumbutu, gwati üllä ndi Papa gwanni nggwo kerala. Gwanni gwugeꞌta ngwony ngwätï buri kerala. Ngwong ngwee ngwati gwugwurli buri gwegen nono diila a be Ngwaalu ngwati ꞌti gwugwurlu aꞌtur. ");
INSERT INTO lro_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Gwüjädï ndi aar nje ätädä ngwujaꞌri ngwanni ngwuru ꞌdidanu nunnu ar ngwe lïngïnï ar ru yiꞌra giyiꞌral ꞌdar yanni yigeꞌteng je. ");
INSERT INTO lro_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Lani ngwänggärï ngwanni ngwämnï nje, geꞌtar je ngwäy nono giyee, ndi ari a dïjï büdädï ndi ꞌdingini puprang, ngwube geraji länï ndi ondaji na ndi güündä ape, ");
INSERT INTO lro_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","ndi ari güündä gidi dïjï gati ꞌti apu dünïngälü ꞌdidanu gwanni gwümïnä Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Yäy gu no, Gatanar yidiganya mbüny ꞌdar na yere ꞌdar yanni yiki ngaa jïlänü ngaa ämnï ngwujaꞌri ngwanni ngwuma kwüdïnï ꞌdanggalanu ngwanni ngwa je gïlängïdïyï. ");
INSERT INTO lro_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Aaꞌti ngaa la ꞌdingini ngwujaꞌri ꞌdogo, no ngaa ïdäjï yigoꞌranu yalu. Apar ngwe yiiru. ");
INSERT INTO lro_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Gwanni gwati ꞌdingini ngwujaꞌri, ngwe ꞌti be apu yiiru, gwuru nono dïjï danni dati ombani ngwäyänü ngwüngün kalmandranu ");
INSERT INTO lro_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","dati ombani lingina lüngün ngwele ngwududanu puprang ndi diwayina ndi ari diru ꞌtaa. ");
INSERT INTO lro_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","A be dïjï danni dati geꞌte yobo ngwäy nono mama, yobo yanni yimbutu yidi gatu linginalu, nggu elada no gwurꞌtal, dati ꞌti dodana ngwujaꞌri ngwanni ngwuming je ꞌdingini, ngwe be ape yiiru ndi aar onjaci giyiiru yüngün. ");
INSERT INTO lro_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Manari gwere gwuma ci ligor lüngün gwümätï yobo ngwuꞌti be mätï lingla lüngün ꞌdïꞌdäny, nginde gwïdäjä ligoꞌranu lüngün a yobo yüngün yiru ꞌtur. ");
INSERT INTO lro_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Yobo yanni yati je Ngwaalu ngwuru Papa gwege ämnï ndi ari yijuꞌru aar jayi nono yiru giyee, ndi ombaji ngwumiꞌrunu na ngwedela gïdïrbänü degen, a ndi rime ligoꞌro lidi dïjï giyidigany yidi dïdlä. ");
INSERT INTO lro_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Lani ngwänggärï, anni rangaa ngwïkïrïjïn ngwudi Deleny dege dïnäjïnä dani Yicu Kirictu, aaꞌti ngaa la uti ngwüjänü. ");
INSERT INTO lro_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Ma dïjï deꞌte ila ngwaalu ngwudi oꞌrajidalu digenna guꞌrunga giru dab komon ngwugenne ngwureda ngwujaw, a be dïjï ila ꞌto danni diru diwayi ngwändä. ");
INSERT INTO lro_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Ngaa be ombaji dïjü ndoo digenna ngwureda ngwujaw ngaa ci, “Ila nga jalu ngwaalu ngwee ngwujaw,” ngaa be ci ndoo diru diwayi, “Dünü ngeno” ya “Jalu gïdïyängälü ngene giyoranu yüny.” ");
INSERT INTO lro_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","Giyee yaꞌti mene ani ndi ari ngaa lati uti ngwüjänü ngaa ru nono ngweleny ngwanni ngwati pï yelenya yaꞌrany ye yegen yanni yike? ");
INSERT INTO lro_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Lani ngwänggärï ꞌdinginar ngwujaꞌri ngwee, Ngwaalu ngwäꞌtüdï ngwanni ngwäbrü ngwüjü ngwanni ngwuru ngwuwayi ngwäyänü ngwudi ngwüjï ngwudi dïdlä nunnu aar nänü ndi ämnï Ngwaalu na ndi ape yuꞌrina yidi yeleny yidi Ngwaalu yanni yicung ye ngwüjü ngwanni ngwämnä ngindengo? ");
INSERT INTO lro_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Ati be ci ngwuwayalu mireny. Ngwüjï ngwanni ngwünänü ngwäꞌtüdï mene ngwanni ngwata je ärräje? Ara je oktalu ara je ngwe ele ngwaalu ngwudi pï yelenyaa? ");
INSERT INTO lro_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Ngindenga läꞌtüdï lanni lati ci Ngwürïnyälü mireny ngwuru yeleny ngwudi nginde gwanni gwätä je? ");
INSERT INTO lro_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Manari ngaa ꞌdidanu lati denya yobo yidi yeleny yanni giyo kitabanu gidi Ngwaalu yaru, “Ämnä gwanggalu anaku ata gu ämnï ligoꞌro lunga,” nga nga gilo ndi je ärrï yanni yïdünälü. ");
INSERT INTO lro_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Ma be ari ngaa lati uti ngwüjänü, yärrä je yanni yiki a ngaa lima gïkïnï yobo ye nono ngwüjü ngwanni ngwukiya yobanu. ");
INSERT INTO lro_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Dïjï danni dati denya yobo ꞌdar nggu be obalu yeꞌte pu ꞌdogo, yani ndi ari yiming je kiyalu ꞌdar anaku rar gu. ");
INSERT INTO lro_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Yiru ndi ari nginde gwanni ngwaru, “Aaꞌti a gwa mïꞌrï ngwäyänü,” gwuru ꞌto gwanni gwaru, “Aaꞌti a gwa ꞌrinyidi.” Manari nga gwuma ꞌti mïꞌrïdï ngwäyänü nga be ꞌrinyidi, yani ndi ari nga gwuma kiyi yobalu ꞌdar. ");
INSERT INTO lro_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Ondaja nga arri nono ngwüjü ngwanni ngwadi ele ndi ngwe yobo obalu yanni yati ye dïjï gätïnï linginalu, ");
INSERT INTO lro_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","ndi ari obalu gwanni gwaꞌti ätï ïnäng, gwa aar gwe inggidi gïdïjï danni dati ꞌti ngwüjï ïnädï. Ndi ari ïnä gwati dami obengalu! ");
INSERT INTO lro_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Yiru ange yanni yijaw lani ngwänggärï manari dïjï dati dätï ämnïng Ngwaalu ngwube erne yiiranu? Da ämnï Ngwaalu nggwee gïlängïdïye? ");
INSERT INTO lro_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Nda ma diweengga diru dur ya gera dïrnïdï ngwureda na eny gwudi lingeno. ");
INSERT INTO lro_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","Ma be ari dïjï deꞌte ꞌdanggalanu ci, “Ïndï gora gijaw nga ji ngwaalu ngwübüdänü nga eny nga pe,” ngwuꞌti be ärrïjä yiꞌral yere yïmïnïng je yidi lingeno, yiru ange yanni yijaw? ");
INSERT INTO lro_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Yiru gu ꞌto no, ndi ari ämnï Ngwaalu ꞌdogo gwanni ngwaꞌti ätï yiiranu, gwayu. ");
INSERT INTO lro_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","A be dïjï deꞌte da be ari, “Nga gwätï ämnïng Ngwaalu, äny gwätï yiiru.” Enggaci ämnïng Ngwaalu gwunga gwanni gwaꞌti ätï yiiranu, gwa ang be enggaca ämnï Ngwaalu gwüny yiiru ye yanni yati nje ärrï. ");
INSERT INTO lro_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Nga gwämnä Ngwaalu ndi ari Ngwaalu ngwuru ngweꞌte pu. Yijaw! A mene ngwujegoꞌrr ngwati gu pa ämnï ꞌto ndi ari Ngwaalu ngwuru ngweꞌte pu, ati je yedeny eny ꞌdi ati aar didiꞌri. ");
INSERT INTO lro_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Wä deꞌrr ndee, yïmïnä je yanni yadi ondaji ndi ari ämnï Ngwaalu ngwanni gwaꞌti ätï yiiranu gwuru ꞌture? ");
INSERT INTO lro_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Dïgüürnä dege dani Äbräyïm daꞌti Ngwaalu ca gwüdünälü anni mung apa gïjü güngün gani Ijaag gading ge mïꞌrïnï nono gidagade? ");
INSERT INTO lro_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Änggädär ndi ari ämnï Ngwaalu gwüngün gwelataar yiiru ye yüngün gwüpäng, na ämnï Ngwaalu gwüngün gwuma mbuti yiiru ye yanni yärrüng je. ");
INSERT INTO lro_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Yiru gu anaku üllïnäär gu kitabanu gidi Ngwaalu yima ätï ngwäyänü ndi ari, “Äbräyïm gwämnä Ngwaalu a gu be Ngwaalu ïꞌräcï ngwuru dïjï dïdünälü,” aar urnidi dimaad didi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Änggädär ꞌdi ndi ari dïjï dati dünälü yiiru ye yanni yating je ärrï, yaꞌti ani ämnï gwe Ngwaalu ꞌdogo. ");
INSERT INTO lro_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Yiru gu yeꞌte yeꞌte no ꞌdi ꞌto gidedr dani Riyab, gwïꞌräcäär ndi ari gwüdünälü gwani yiiru yüngün anni mung ülläjï ngwujimidalu ngwükäjäär je ngwuje ꞌtüyï aar ele gay ge giꞌtere? ");
INSERT INTO lro_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Nono lingina mung ꞌti ätï lïgïꞌrïmänü, layu. No ämnï Ngwaalu gwanni gwaꞌti ätï yiiranu, gwayu. ");
INSERT INTO lro_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Lani ngwänggärï, aaꞌti ngaa la ru ngwoorta lonyadu, ndi ari ngaa lïlïngïdï alanga lanni lati enggaci ngwüjü, la ji linje le obalu obengalu gwanni gwupana. ");
INSERT INTO lro_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Alanga ꞌdar lati obalu ngway ngwonyadu. Manari gwere gwati ꞌti ärrü yiꞌral yere yanni yiki aꞌtur ndi ondaji gwüngün, nginde gwuru dïjï dimbutu, dätï yiima ndi ruyi lingina lüngün ꞌdar. ");
INSERT INTO lro_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Manari a lima änïcï ngwumirta yuꞌrunga ngwulem, nunnu aar nje ꞌdengenaci ar je ruyi, ngwati ar je gwügwürlï ngwanginalu ngwengen ꞌdar. ");
INSERT INTO lro_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Na nono gwele ngwübälükä. Aar ni pe nono ange, ati je dirun dojema nono dinga, ngwati je dilimi dooko gwügwürläjï ngwaalu ngwümïnä je gu doorta degen ndi ele. ");
INSERT INTO lro_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Yiru gu yeꞌte yeꞌte ꞌto gilingla, liru guꞌru gooko ngwanginu ating be ïrïngïnï gwulleny. Ïrïyä ngwäyälü gïlïgä gwele mung obalu looko, lati uꞌdiyi dïdänyälü ꞌteny. ");
INSERT INTO lro_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Lingla liru lïgä ꞌto, liru guꞌru giki lati gu yiꞌral ꞌdar ila ngwanginu ngwudi dïjï. Lati kiyi dïjü nono ku, ngwugatu miding gwudi dïjï ku gïlïgä na lati aar gatu ꞌto gïlïgä lidi yiꞌrendeny. ");
INSERT INTO lro_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Ngwäng ꞌdar, yïꞌrä, ngwong ngwanni ngwati ele yora yalu, na ngwong giyaanu ngwati je ngwüjï lingidiyi drü aar ru ngwudi ꞌdunung, ");
INSERT INTO lro_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","a be dïjï dati ꞌti mätï (lingidiya) lingla drü. Liki lati ꞌti jalu jicom, lonyadu yiyaanu yati ꞌrinyidi. ");
INSERT INTO lro_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Lati ar le ortada Delenya dege ar le ortada Papang gwege, ar le ꞌtäjï ngwünyü gïdïjï danni dïgïꞌtïnä giyiꞌremna yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Ngwulemanu ngweꞌte ngweꞌte, ngwati ortada aar ꞌtäjï ngwünyü. Lani ngwänggärï, yaꞌti yaadi gu ru no. ");
INSERT INTO lro_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Yaw yanni yami na yanni yinyira yati ïrïtädï gidel deꞌte deꞌte? ");
INSERT INTO lro_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Lani ngwänggärï, dimnigor dati ꞌriꞌri yïmïnïte na dïgürï dati ꞌriꞌri yimnigora? Na ꞌto del danni dinyira yaw dati ꞌti ïrïtädü yaw yanni yami. ");
INSERT INTO lro_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Yärü gwanni nggwo gwubebera gwülïngïdï ꞌdanggalanu? Gäbïcär ngwuje inggidi elelle gwe gwüngün gwanni gwujaw, apepe gwanni gwäpïnä ligor le lüllänü gwudi bebere gwuru. ");
INSERT INTO lro_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Ma be ari ngaa lati ꞌrati ngwäy jicir yïꞌdünyü, ngaa arrada giyur giyigoranu yalu, aaꞌti ya ye ïrïngïnï giyee ngaa je nyïꞌrïnï yanni yiru ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","“Bebere” gwanni gwuru gu no, gwaꞌti üllü kerala ngwube ru gwudi dïyängälü, gwäꞌtüdï gwudi lïgïꞌrïm, gwuru gwudi dijegoꞌrr. ");
INSERT INTO lro_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Ndi ari manari ngaa liru ngwüꞌdüny ngaa arrada giyur, ꞌdïgwüꞌrïdänü gwati ji a yiꞌral äpïnï ꞌdar yanni yiki. ");
INSERT INTO lro_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","A be bebere gwanni gwati üllä kerala, gwerre gwerre, gwuru gwanni gwujuꞌru, ngwuru ämnï gwudi adatalu, gwati denya, gwati ꞌdengenaci, gwätï ïnängänü gwupa, a gwati ꞌriꞌri yuula yanni yijaw, gwati übïdänü ngwuru ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Lanni lati geꞌte adatingalu aar kwoy ladatalu, yati aar je ꞌtüyï yanni yïdünälü. ");
INSERT INTO lro_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Yiru ange yanni yati apa dugiding aar apa kading ꞌdanggalanu? Yäꞌtüdï mene ndi ari yati ila ndi amiꞌra gwati kwudi ꞌdanggalano? ");
INSERT INTO lro_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Gong gata je araanu ngaa ꞌti be mbuju. Ata be kajidi ngaa ꞌrinyidi nunnu nga mbuji. Ngaa je ꞌti be mbuju yanni yïmïnä je, no ati aang be kadi ngaa kwudi. Ngaa laꞌti ätï, ndi ari ngaa lati ꞌti otaca Ngwaalingalu. ");
INSERT INTO lro_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Manari ngwuma je otacalu, ngaa lati ꞌti mbuja, ndi ari ngaa lati utalu yigor ye yiki nunnu ngaa ye ärrï yiꞌral yanni yämïꞌrädï yigor yalu. ");
INSERT INTO lro_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Ngaa gilee liru ngwüjï ngwümïꞌrïdï ngwäyänü, ngaa laꞌti lïngïdï ndi ari ätäjïdï yimaada dïdlängä le, yani aar nje Ngwaalu ke ngwäye? Dïjï danni dima aar ru dïdlä de dimaad, dima ru güwän gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Ngaa laru gitab gondajalu ꞌdogo aꞌtur anni arung lïgïꞌrïm lanni ligeꞌteng ꞌdengganu, lati nje iye yigoranu nunnu ar ämnï Ngwaalinga jüco? ");
INSERT INTO lro_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Ati aar nje be nginde gendaci nje yïmïꞌrä. Yiru giyee yaru ye gitab ndi ari, “Ngwaalu ngwati ꞌdonya ngwujaꞌri ngwudi dïjï danni dati piyi ligoꞌro Ngwube ru dïmïꞌrü gïdïjï danni dati okeye ligoꞌro.” ");
INSERT INTO lro_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Ätädär be Ngwaalinga yigoꞌro yalu. Kwudar dijegoꞌrrnga le da je be abri. ");
INSERT INTO lro_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","ꞌDonggacar Ngwaalinga gito nginde gwa je be ꞌdonggaca gito. Unar ngwuy nono nga nga lanni liki, ngaa gäꞌrïnï yigor yalu, nga nga lanni liru yigoranu rom. ");
INSERT INTO lro_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Runar, ngaa ari dulu de gwulleny. Gäbïcär ngwïmä ngwalu ngaa ari yal ngaa gäbïcï jayinganu ngaa jalu kürüng. ");
INSERT INTO lro_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Okeyar yigoꞌro yalu ngwäyänü Gideleny, gwa je be piyi gwa je näjï. ");
INSERT INTO lro_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Lani ngwänggärï, aaꞌti ngaa la ludidi ngwujaꞌri ngwe ngwanni ngwuki. Gwanni gwati ondijaji kwenggenala ngwujaꞌri ngwanni ngwuki nggwe obalu, nginde gwati ondijaji giyobala ngwuye obalu. Manari nga gwati obalu yobo ye, yaꞌta je mätï nga gu be jalu nda ye obalu. ");
INSERT INTO lro_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Gwanni gwuru dobo gwuru gweꞌte pu, ngwuru deleny gwuru gwätï yiima ndi gïlängïdïyï na ndi gerajalu. Nga be ani yärü ndi obalu gwanggalu gwe? ");
INSERT INTO lro_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","ꞌDinginar gweneno, nga nga gilee lati ari, “Gwene ya bïgänü a ladi ele kündär nggee ya kündär nggone, ar gu jalu dïdläyü. Ar gu bileda ar mbuja ngwüꞌrïnyä.” ");
INSERT INTO lro_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Ange gwuru, ngaa laꞌti lïngïdï ꞌdi ndi ari yiru ange yanni yadi ji bïgänü. Midi gwunga gwuru ange? Gwuru nono dumbil dele dati ji gwooko ngwube aji ngwabralu. ");
INSERT INTO lro_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Ngaa laadi manni ari, “Ma gu Ngwaalu ari, a la midi, ya ar je ärrï giyee ya ar je ärrï giyone.” ");
INSERT INTO lro_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","A be Ngaa gilo be lati ïrïngïnï ngaa piyi yigoꞌrala yalu, ïrïngïnï nggwee ꞌdar gwuru gwanni gwuki. ");
INSERT INTO lro_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Yäy gu no, gweꞌte gweꞌte gwanni gwati lenge yiꞌral yanni yijaw nding je ärrï ngwuje ꞌti be ärrü, yating je ärrï yanni yiki. ");
INSERT INTO lro_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","ꞌDinginar gweneno, nga nga lanni ru ngwüjï ngwünänü, arar ngaa runi gwani dïrbä danni ndo dïndï dada je mbuji. ");
INSERT INTO lro_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Goola galu gima ꞌdigiꞌri ngwured ngwalu ngwuma je ngwuruwal eny. ");
INSERT INTO lro_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Dab na Buta gwalu gwuma ïyïnï. Ïyïnï gwegen gwuru gwanni gwadi inggidi keng gwalu ara je eny ngwangina nono ngwalu nono lïgä. Nga nga lima gwäꞌräjï gola giꞌdu giyomon gïyäꞌdï yidi gwodaning. ");
INSERT INTO lro_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Geꞌtar be ngwäyälü! Ndi ari guꞌru ganni gwüꞌrïdängää ngwüjï ngwe ngwanni ngwata je äpïjï yiiru ngaa je ꞌti be ätädï, ngwo ngwudugu yal ye ꞌdanggalu. Na yal yidi ngwüjï ngwanni ngwäpïjä je yiiru, yima je Deleny diru yiima ꞌdingini. ");
INSERT INTO lro_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Nga nga liju gïdïdlä lïrïyälü ngaa enyalu yelenya ngaa amiyi yigoꞌranu yalu. Ngaa likwudiniya yigoꞌro yalu nono yïndrï komon gidi rce. ");
INSERT INTO lro_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Ngaa lima obalu ngwüjï ngwe ngwanni ngwujaw nono ngaa je ꞌrinye ngwanni ngwaꞌta je ärrü yiꞌral yere. ");
INSERT INTO lro_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Lani ngweengga, mätär yiguri ꞌdi a Deleny oꞌra. Änggädär anaku ati gu dïjï danni dati kwoy dünïcï yona ndi ꞌtüdä gïdïyäng. Na awa dati määtä liguri ngwüdünïcï giranyu ganni gati ni a yon ꞌtüdä na ganni gati pï yona aar ätï ngwäy. ");
INSERT INTO lro_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Mätär be yiguri nga nga ꞌto, ngaa mätïnälü ꞌdïꞌdäny ndi ari Deleny ndoo dïndï puprang. ");
INSERT INTO lro_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Lani ngwänggärï, aaꞌti ngaa la äbïngïnïjïdï giyinenanu, nunnu aaꞌti Ngwaalu ngwa ji ngwa je ngwe obalu ngwujaꞌri ngwee. Gwanni ngwati obalu ngwüjï ngwe nggwo gito, nggwo gwüdünü gïlängïr. ");
INSERT INTO lro_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Lani ngwänggärï, orꞌtemajar nono ngwïjïrä ngwanni ngwondaja ngwürïny ngwe ngwudi Deleny ndi ari ngwumbuju dïrbä. ");
INSERT INTO lro_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Anaku lïngïdä gu ndi ari a länggädï ndi ari, lonjacaar je lanni lorꞌtemaju. Nga nga liꞌdingina orꞌtemaji gwe gwudi Äyüb, ngaa lima engga ndi ari gwuma Ngwaalu ärrä gwodanalu. Ngwaalu ngwuru dïnä ngwanni ngwati je ngwüjï ïnä. ");
INSERT INTO lro_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Yanni yipana guꞌru, lani ngwänggärï, aaꞌti nga la pï yiꞌrany Ngwaalu ngwe na gere ge, na dïyäng de, na gong ge gere. Gäbïcä “Yäyïng” gwunga ngwani yäy, na “Bärïng” gwunga ngwani bärï, ya la gwe obalu. ");
INSERT INTO lro_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Dïjï dere ꞌdanggalanu ndo gïdïrbäno? Gäbïcär ngwotaci Ngwaalingalu. Dïjï dere dijayano? Gäbïcär ngwelnge ngwortada Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Dïjï dere ꞌdanggalanu düma? Gäbïcär ngwurnidi mbumbung je lidi giꞌdoonga aar abingaci Ngwaalinga aar bruti yila ye ngwürïny ngwe gwudi Kirictu. ");
INSERT INTO lro_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Otaci Ngwaalingalu ämnï gwe Ngwaalu, gwa gäbïcï dïjü danni dümä da uꞌri nono. No da Deleny ꞌdïꞌrïyälü. Manari dapu gwanni gwuki, da aar düdänïjänü. ");
INSERT INTO lro_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Yäy gu no, ꞌtäjïdärälü giyiꞌral yalu yanni yiki ngaa otacidi Ngwaalingalu nunnu ara je Ngwaalu uꞌriyi nono. Otaci Ngwaalingalu gwudi dïjï danni dïdünälü gwätï yiima ndi ärrï yiꞌral. ");
INSERT INTO lro_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Ïlïyä gwuru dïjï dümnä nono alanga je, ngwube otaci Ngwaalingalu gwulleny ndi ari aaꞌti gere ga ni, a gere allala ngwüdläyü täꞌrïl na dïdläyü düꞌränü ngwuꞌti nu. ");
INSERT INTO lro_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Ngwoꞌre ngwotaci Ngwaalingalu nunnu a gere ila kerala ngwunni a ngwong ꞌtüdä gïdïyängänü, oꞌre a gere ni. ");
INSERT INTO lro_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Lani ngwänggärï, manari gwere gwuma gatani ngwujaꞌri ngwanni ngwätï ngwäyänü, ma be ari gwuma dïjï dere gwäꞌrä, ");
INSERT INTO lro_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","lïngïdär ndi ari gwanni gwati gwäꞌrä dïjü danni diki kay gidi dudi, diming gätäjä yiꞌrany a da aar gwüꞌrübäcï yiꞌralalu yanni yiki yonyadu.");
INSERT INTO lro_vpl VALUES ("P11_1","090_1_1","1PE","1","1","1","Äny gwani Butruj gwuru dooꞌra dükäjär didi Yicu Kirictu, ngwujaꞌri ngwee ngwükäcï nje ngwüjü ngwanni ngwäbrä je Ngwaalu ngwobadalu ngwuru ngwïrnü poor ngwaalu ngwee ngwani Buntuj, Galatiya, Gäbüdükïyä, Ajiya na Bïjïnïyä. ");
INSERT INTO lro_vpl VALUES ("P11_2","090_1_2","1PE","1","2","2","Ngwanni ngwäbräär je anaku lïngïdï gu Ngwaalu ngwuru Papa ꞌtuꞌtu gwerre ngwuje juꞌriyi Lïgïꞌrïm le nunnu aar ꞌdengenaci Yicu Kirictung ngwuje gwürä yïn ye yüngün. Ara je gu yïmïꞌrü ji ara je gu adatalu ji gwïrälü. ");
INSERT INTO lro_vpl VALUES ("P11_3","090_1_3","1PE","1","3","3","Ar näjï Ngwaalinga ngwuru Papa gwudi Deleny dege dani Yicu Kirictu. Ndi ari ndi ïnä gwüngün gwanni gwupa ꞌdengge, a lima lïngïnï lïngïnïng gwanni gwuyang ndi geꞌtaji gwanni gwumidu ꞌdïꞌrï gwe gwudi Yicu Kirictu giyiꞌranyanu. ");
INSERT INTO lro_vpl VALUES ("P11_4","090_1_4","1PE","1","4","4","Aar nje änïjï giyuꞌrinanu yanni yati ꞌti ꞌdigiꞌru aꞌtur aar ralu aar medadi. Giyo yïrïmïtïjärä je kerala ");
INSERT INTO lro_vpl VALUES ("P11_5","090_1_5","1PE","1","5","5","ngaa lanni letadu gu yiima yidi Ngwaalu ämnïng gwe gwalu ꞌdünggüngün ꞌdi a gilang gwanni nggwo mama, ngwa ji ngwüꞌtädälü komon nggäꞌdï gidi gwodaning. ");
INSERT INTO lro_vpl VALUES ("P11_6","090_1_6","1PE","1","6","6","Jayar banu gwulleny gwani ngwujaꞌri ngwee, a be gweneno, mïmïnnï nono gwonyadu yiꞌranu gwa je mbuji gaji gooko. ");
INSERT INTO lro_vpl VALUES ("P11_7","090_1_7","1PE","1","7","7","Ya je mbuji giyee nunnu aar inggidi ndi ari ꞌdiꞌdidanu ämnï Ngwaalu gwalu gwanni gwupana guꞌru gidab danni dati medadi danni dati aar gwalli nono lïgä le nunnu aar ombaji ndi ari diru ꞌdidanu. Ämnï Ngwaalu gwalu gwuru gu no, ndi ari ngwümbüjïnï gwuru ꞌdidanu ndi orta, ndi näjï na ndi denya, ma ji ma Yicu Kirictu ꞌtädälü. ");
INSERT INTO lro_vpl VALUES ("P11_8","090_1_8","1PE","1","8","8","Gwaꞌti aang änggädï, ngaa be ämnï. Gwaꞌti aang änggädï gwenene, ngaa be ämnäcï lijayanu gwulleny lonyadu gu näjï gwupa. ");
INSERT INTO lro_vpl VALUES ("P11_9","090_1_9","1PE","1","9","9","Ndi ari ngaa gilo ndi ape guꞌru gidi ämnï Ngwaalu gwalu, gwani gilang gwudi lingeno lalu. ");
INSERT INTO lro_vpl VALUES ("P11_10","090_1_10","1PE","1","10","10","A gwani gilang nggwee, ngwïjïr ngwanni ngwondaja gïyïmïꞌrü yanni yadi ara je Ngwaalu ükäcä, yïmïnäär jälü gwulleny aar ye arngani guꞌru gipa. ");
INSERT INTO lro_vpl VALUES ("P11_11","090_1_11","1PE","1","11","11","Aar bupi ndi ari ye lenge gaji aar ye lenge ngwujaꞌri ngwanni ngwinggida je Lïgïꞌrïm lidi Kirictu lanni liju ꞌdenggenanu. Anni ondajing gwani yiꞌrendeny yanni yadi mbuji Kirictung, a gwani näjï gwupa gwanni gwadi gwuja. ");
INSERT INTO lro_vpl VALUES ("P11_12","090_1_12","1PE","1","12","12","Ngwaalu ngwondaca ngwïjïrä ndi ari ngwaꞌti äpïjä yigoꞌro yegen yiiru, ara je be äpïjï yiiru. Anni ondacaar yiꞌral ye yanni yima je ꞌdingini gweneno. Ngaa liꞌdingina ngwujaꞌri ngwee ngwanni ngwondaca je ngwüjï, ngwujaꞌri ngwanni ngwujaw ngwani Yicu Lïgïꞌrïm le lanni Lijuꞌru lükäjïnä kerala. ꞌDi ndi ari yïꞌrr ꞌto yïjädï ndi ombaji yiꞌralanu giyee. ");
INSERT INTO lro_vpl VALUES ("P11_13","090_1_13","1PE","1","13","13","Yäy gu no, jar balu ngwäy ngwe ngwudi yigor yalu aang arngani gwani yiiru. A geꞌtaji gwalu ꞌdar jada gïyïmïꞌrü yanni yadi ara je Yicu Kirictu ätädä mung ꞌtädälü. ");
INSERT INTO lro_vpl VALUES ("P11_14","090_1_14","1PE","1","14","14","Nono yïjü yiꞌdengenaca Ngwaalinga, aaꞌti ba be ngaa loꞌraci elelleng gwudi amiꞌra gwudi lingeno gwele gwuju yogo ye gwerre. ");
INSERT INTO lro_vpl VALUES ("P11_15","090_1_15","1PE","1","15","15","Ngaa be juꞌri anaku juꞌrung gu gwanni gwurnida je, no juꞌrar be giyiꞌral ꞌdar yanni yata je ärrï. ");
INSERT INTO lro_vpl VALUES ("P11_16","090_1_16","1PE","1","16","16","Ndi ari yüllïnä no yaru nu, “Juꞌrar, anaku juꞌriny gu.” ");
INSERT INTO lro_vpl VALUES ("P11_17","090_1_17","1PE","1","17","17","Ndi ari anni urnidangaa Ngwaalinga ngwuru Papa gwanni gwati ꞌti utu ngwüjänü ndi pï yelenya yüngün, elellar elelleng gwudi ngwüjï ngwuru ngwïrnü ngene gïdïdlä ara je yedeny eny. ");
INSERT INTO lro_vpl VALUES ("P11_18","090_1_18","1PE","1","18","18","Ngaa lïlïngïdï ndi ari laꞌta je üꞌrädälü kay ganni gaꞌti ätï midinganu gïgätïjänärä je mbumbunga lalu ngwong ngwe ngwanni ngwati dudi nono buta na dab, ");
INSERT INTO lro_vpl VALUES ("P11_19","090_1_19","1PE","1","19","19","ara je be üꞌrälü yïn ye yidi Kirictu yanni yiru guꞌru, gwuru Girany ganni gijaw nono gaꞌti rngü. ");
INSERT INTO lro_vpl VALUES ("P11_20","090_1_20","1PE","1","20","20","Gwäbräär ꞌtuꞌtu gwerre dïdlä daꞌtina gïꞌtïnä, gwuma aar be ꞌtäjälü kaji nggee gidi gwodaning gwani nga nga. ");
INSERT INTO lro_vpl VALUES ("P11_21","090_1_21","1PE","1","21","21","Nginde gwe, ngaa lima ämnï Ngwaalu ngwanni ngwüꞌdïꞌrïyälü giyiꞌranyanu ngwünäjï, a gu no, ämnï Ngwaalu na geꞌtaji gwalu nggwo gwüjädï Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("P11_22","090_1_22","1PE","1","22","22","Gweneno anni ma aang gäꞌrïnï yigoꞌro yalu ꞌdengenaji gwe ꞌdidanung nunnu ngaa ätï ämnïng ngwengga ꞌdiꞌdidanu, ämnäjïdär gwulleny ꞌtuꞌtu giyigoranu. ");
INSERT INTO lro_vpl VALUES ("P11_23","090_1_23","1PE","1","23","23","Ndi ari ngaa lima lïngïnï lïngïnïng gwanni gwuyang ngaa läꞌtüdï yuula yanni yati änï, ngaa be ru yuula yanni yati ꞌtüdä, midi gwe na mätïnälü gwe gwudi ngwujaꞌri ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("P11_24","090_1_24","1PE","1","24","24","Ndi ari yüllïnä yaru nu, “Midi gwudi ngwüjï ꞌdar gwuru nono yanya, na näjï gwegen gwuru nono yibobo yidi dïdäny. Yanya yati undi na yibobo yati ayi nono aar miꞌriꞌti, ");
INSERT INTO lro_vpl VALUES ("P11_25","090_1_25","1PE","1","25","25","a be ngwujaꞌri ngwudi Ngwaalu ngwati jalu pupud.” A ngwujaꞌri ngwuru ngwee ngwanni ngwondacara je ngwe. ");
INSERT INTO lro_vpl VALUES ("P12_1","090_2_1","1PE","2","1","1","Yäy gu no, gätär be yiꞌral mbüny yanni yiki yani yiꞌrinya na ïꞌdäjänü ꞌdar, yimurꞌtuny, yüꞌdüny na yani lo gwere ꞌdar. ");
INSERT INTO lro_vpl VALUES ("P12_2","090_2_2","1PE","2","2","2","Rüdär nono yïjü yïlïngïtäär je girem, ara je yan yanni yijuꞌru yidi lïgïꞌrïm amiꞌra nunnu ngaa ye pe ndi gilang gwalu, ");
INSERT INTO lro_vpl VALUES ("P12_3","090_2_3","1PE","2","3","3","ndi ari gweneno ngaa lima lenge ndi ari Deleny dijaw. ");
INSERT INTO lro_vpl VALUES ("P12_4","090_2_4","1PE","2","4","4","Ngaa lïndädï ꞌdünggüngün, ndi ari nginde gwuru nono goꞌrra giru gidingo ganni gimidu gïꞌdünyïdädï ngwüjälü ngwanni ngwati oda, a be Ngwaalu äbrï ngwuruji guꞌru gipa ngwäyänü ngwüngün. ");
INSERT INTO lro_vpl VALUES ("P12_5","090_2_5","1PE","2","5","5","Nga nga ꞌto liru nono yoꞌrra yimidu yüdädäär ye ngwuꞌduna ngwudi lïgïꞌrïm, ndi ari ngaa ru ngwurꞌdal ngwanni ngwujuꞌru ngaa äpïjï Ngwaalinga mïꞌrïnïng nono gwudi lïgïꞌrïm gwanni gwüjädänü Yicu Kirictu gwe. ");
INSERT INTO lro_vpl VALUES ("P12_6","090_2_6","1PE","2","6","6","Ndi ari yüllïnä kitabanu yaru nu, “Ombaja ndi ari äny nggwo gwügätï goꞌrralu ngwaalu ngwani Jäyün, ganni gäbrïny ngwuru guꞌru, a gwere gwanni gwa gu gatada ngwäyänü, gwaꞌti gwa yaaru ape aꞌtur.” ");
INSERT INTO lro_vpl VALUES ("P12_7","090_2_7","1PE","2","7","7","A be gweneno nga nga lanni lämnï ꞌdünggüngün, goꞌrr nggee gipa guꞌru ꞌdanggalu. A be lanni laꞌti ämnä ꞌdünggüngün ngwube ari, “Goꞌrr ganni gïꞌdünyïdädï ngwüjälü ngwanni ngwati oda, gima ru gidingo gidi ngwuꞌdun.” ");
INSERT INTO lro_vpl VALUES ("P12_8","090_2_8","1PE","2","8","8","Na gima ru ꞌto, “Goꞌrr ganni gima ru nono gimle gadi gäbïcï ngwüjü aar gu obalu ngwuru ngwurꞌda ngwudi ïꞌdïyï ngwüjü.” La obalu, ndi ari linyurtanu ndi ämnï ngwujaꞌri aar gu ru ꞌto ndi ari ligeꞌtajaar je gu. ");
INSERT INTO lro_vpl VALUES ("P12_9","090_2_9","1PE","2","9","9","A be ngaa liru ngwüjï ngwäbräär je ngaa ru ngwurꞌdal ngwudi yeleny yidi Ngwaalu, ngaa ru ngwüjï ken ngwanni ngwujuꞌru, ngaa ru ngwüjï ngwudi Ngwaalu ndi ari ngaa ondaji orta gwe gwüngün nginde gwanni gwüꞌtïyä je gïdïrïmänü ara je ꞌtäjä giburalu gwüngün gwanni gwuru ꞌter. ");
INSERT INTO lro_vpl VALUES ("P12_10","090_2_10","1PE","2","10","10","Ngaa gwele gwerre läꞌtüdï ngwüjï, a be gweneno ngaa lima be ru ngwüjï ngwudi Ngwaalu. Ngaa gwele gwerre, ngaa laꞌti ïnädï Ngwaalinga a be gweneno, ngwuma je be ïnä. ");
INSERT INTO lro_vpl VALUES ("P12_11","090_2_11","1PE","2","11","11","Lani ngwumaad ngwüny, nggwa je päcälü ngaa liru ngwïrnü ngaa ru liꞌter ngene gïdïdlä ndi ari gatanar amiꞌrang gwanni gwuki gwudi lingeno gwanni gwati aar kwudi lïgïꞌrïm le lalu. ");
INSERT INTO lro_vpl VALUES ("P12_12","090_2_12","1PE","2","12","12","Elellar elelleng gwanni gwujaw ngwüjänü ngwudi dïdlä, ma aar je üpäcï yiꞌral nono yanni yiki ngaa je gäbïcï aar engga apepeng gwalu gwanni gwujaw ngwuje gäbïcï aar näjï Ngwaalinga komon nggäꞌdï gidi gwodaning gadi aar nje ge ïlïjä. ");
INSERT INTO lro_vpl VALUES ("P12_13","090_2_13","1PE","2","13","13","ꞌDengenacar yelenya ꞌdar yanni yïgïꞌtïnä ngwüjänü, gwani Deleny. Ma aar ani denya delenya danni diru giꞌra düꞌrädï yeleny nono ku, ");
INSERT INTO lro_vpl VALUES ("P12_14","090_2_14","1PE","2","14","14","na ma aar ani denya ngwartana ngwüngün, ngwükäjïng je aar gïkïjï ngwüjü ngwanni ngwa ärrï gwanni gwuki aar je gwällïnï lanni lati ärrï yiꞌral yanni yïndï kayalu. ");
INSERT INTO lro_vpl VALUES ("P12_15","090_2_15","1PE","2","15","15","Ndi ari bupi gwuru gwudi Ngwaalu ndi ärrï yiꞌral yanni yijaw, ya gäbïcï ngwüjü ngwanni ngwati ondaji yiꞌdonggala, aar määtä ngwünyü ngwengen. ");
INSERT INTO lro_vpl VALUES ("P12_16","090_2_16","1PE","2","16","16","Gätïnär linginalu aang elellalu aaꞌti be ngaa la gu rtanu ngaa ärrï yiꞌral yanni yiki. Elellar ngaa ru ngwïnäd ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("P12_17","090_2_17","1PE","2","17","17","Dïnyädär ngwüjü ꞌdar ngaa ämnäjïdï yengga yidi ngwïkïrïjïn ara je yedeny eny Ngwaalu, ngaa denya delenya. ");
INSERT INTO lro_vpl VALUES ("P12_18","090_2_18","1PE","2","18","18","Ngaa lanni liru ngwïnäd, ꞌdengenacar ngworta ngwalu ngaa je denya aaꞌti la je ꞌdengenaci ꞌdogo lanni lijaw drü ara je jayi ngwäy, ngaa je be ꞌdengenaci ꞌto lanni liki drü agaa je ke ngwäy. ");
INSERT INTO lro_vpl VALUES ("P12_19","090_2_19","1PE","2","19","19","Ndi ari yijayi gu manari yeꞌrendeny yima mbuji dïjü yïrïgïnä kay gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("P12_20","090_2_20","1PE","2","20","20","Yiru ange ya ara je ïꞌräcï manari ngaa lïpïnä gwani ape gwalu gwanni gwuki? Ma be ari yeꞌrendeny yimbujanga gwani ape gwunga gwanni gwujaw, orꞌtemaja be, giyee yijaw Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("P12_21","090_2_21","1PE","2","21","21","Yiru giyee yanni yornacara je, ndi ari Kirictu gwumbuju yiꞌrendenya yani nga nga ara je gïꞌtïjänï gay ngaa gwuji gora güngün. ");
INSERT INTO lro_vpl VALUES ("P12_22","090_2_22","1PE","2","22","22","“Nginde gwaꞌti ärrä yiꞌral yere yanni yiki, aar ꞌti mbojaja ïꞌdäjïng nono gwere ngwulemanu ngwüngün.” ");
INSERT INTO lro_vpl VALUES ("P12_23","090_2_23","1PE","2","23","23","Anni lüdäär yiꞌral ye yiki, ngwuje ꞌti gwäꞌräcänü ngwugwalli dämjä, anni mbujing yiꞌrendenya, ngwuje ꞌti iya yedenyo, ngwube gatada ligoꞌro lüngün Ngwaalu ngwanni gwati übïdï yiꞌralanu. ");
INSERT INTO lro_vpl VALUES ("P12_24","090_2_24","1PE","2","24","24","Nginde giligoꞌro lüngün gwapu keng gwege ngwanginu ngwüngün küꞌrälä nunnu ar ayi ndi ke ar be midi gwani dünälü. Ngwämmä ngwe ngwüngün, lima je uꞌriyi nono. ");
INSERT INTO lro_vpl VALUES ("P12_25","090_2_25","1PE","2","25","25","Ndi ari nga nga gwele liru nono ngwangal ngwududu a be gweneno, ngaa lima oꞌraca Yicung gwanni gwuru dooꞌra ngwuru dangida danni dati arnga lingeno lalu. ");
INSERT INTO lro_vpl VALUES ("P13_1","090_3_1","1PE","3","1","1","Lani ngwaw, ꞌdengenacar ꞌto ngwuru ngwalu nunnu manari gilona lere lanni laꞌti ämnä ngwujaꞌri, aar je gwürlï elelle gwe gwanni gwujaw gwudi ngwaw ngwegen ");
INSERT INTO lro_vpl VALUES ("P13_2","090_3_2","1PE","3","2","2","ma aar engga elelleng gwudi juꞌri na denya gwudi ngwaw ngwegen. ");
INSERT INTO lro_vpl VALUES ("P13_3","090_3_3","1PE","3","3","3","Aaꞌti jayi gwalu gwa ru gwudi ngwanginu poor, nono ndi mïcïnï ngwäꞌrü ndi genne dab nono, ndi genne buta nono na ndi genne ngwureda ngwanni ngwuꞌri. ");
INSERT INTO lro_vpl VALUES ("P13_4","090_3_4","1PE","3","4","4","Ngaa be manni bupi jaying gwudi ligor lalu gwanni gwati ꞌti medadu, gwani jayi drü gwalu na jïlänü gwalu gwudi lïgïꞌrïm, yiru giyee yanni yipa guꞌru ngwäyänü Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("P13_5","090_3_5","1PE","3","5","5","Ndi ari yiru giyee yanni yïndï ye ngwaw ngwujuꞌru ngwudi gwerreng ngwanni ngwügätï geꞌtajing gwegen Ngwaalu aar gwe jayiyi yigoꞌro yegen. Aar ꞌdengenaci ngwuru ngwegen. ");
INSERT INTO lro_vpl VALUES ("P13_6","090_3_6","1PE","3","6","6","Nono Jarrang, gwanni gwuꞌdengenaca duru düngün dani Äbräyïm ꞌdi ating urnidi doorta düngün. Ngaa liru yera yüngün manari ngaa lati ärrï yiꞌral yanni yïdünälü aar je ꞌti yedeny ïtï giyiꞌral yere. ");
INSERT INTO lro_vpl VALUES ("P13_7","090_3_7","1PE","3","7","7","Aar gu ru ꞌto ꞌdanggalu nga nga lanni liru ngwur, jayar drü ngwaw ngwalu ngaa je ärrï yiꞌral yijaw ngaa je denya ndi ari ngindenga liru ngweengga ngwamiꞌratu na ndi ari lemada le gïyïmïꞌränü yidi angidaji gwudi midi nunnu aaꞌti yere ya ji yüꞌrü otacing Ngwaalingalu gwalu ngwäy. ");
INSERT INTO lro_vpl VALUES ("P13_8","090_3_8","1PE","3","8","8","Ndi mïꞌrä, nga nga ꞌdar acajidar gwüpäng lamatanu, ïnäjïdär, ämnäjïdär yengga, jayar yiguri ngaa ru ngwumulu. ");
INSERT INTO lro_vpl VALUES ("P13_9","090_3_9","1PE","3","9","9","Aaꞌti ngaa la gwäꞌräjï yiꞌral yanni yiki yiꞌral ye yanni yiki, aaꞌti ngaa la lujidi ngaa be onjaci ngwüjü ndi ari yiru giyee yanni yornacara je Ngwaalu nunnu ngaa ji ngaa ape guꞌru galu gidi onjaci. ");
INSERT INTO lro_vpl VALUES ("P13_10","090_3_10","1PE","3","10","10","Ndi ari, “Gwere gwanni gwadi ämnï miding gwudi ligoꞌro lüngün a yomon mbuji ꞌdar yanni yijaw, ngwümäätä lingla lüngün giyiꞌral yanni yiki na ngwulem ngwüngün ndi ondaji yiꞌduru. ");
INSERT INTO lro_vpl VALUES ("P13_11","090_3_11","1PE","3","11","11","Ngwugwurla giyiꞌral yanni yiki ngwuje ärrï yanni yijaw. Ngwümïnï adatingalu ngwugwoda. ");
INSERT INTO lro_vpl VALUES ("P13_12","090_3_12","1PE","3","12","12","Ndi ari ngwäy ngwudi Ngwaalu ngwati iye ngwüjü ngwanni ngwüdünälü na lating je geraji länï lüngün ma aar otacalu. Ngwuje be gwürläcï luꞌra lanni lati ärrï yiꞌral yanni yiki.” ");
INSERT INTO lro_vpl VALUES ("P13_13","090_3_13","1PE","3","13","13","Yärü gwa je akani nono manari yigor yïtäjänü ndi ärrï yiꞌral yanni yijaw? ");
INSERT INTO lro_vpl VALUES ("P13_14","090_3_14","1PE","3","14","14","A be manari yiru gu ndi ari ara je yiꞌrendeny mbuji yani ärrï gwalu yiꞌral yanni yïdünälü, Ngwaalu ngwa je onjaci. “Aaꞌti yedeny ya je eny giyiꞌral yanni yati iye ngwüjü yedenyo, aaꞌti yedeny ya je eny ma ara je iye yedenyo.” ");
INSERT INTO lro_vpl VALUES ("P13_15","090_3_15","1PE","3","15","15","Ngaa be geꞌte Kirictung ngwuru Deleny giyigoranu yalu. Jar mama giyomonalu ꞌdar nda je enggaci lanni la je otacalu gwani geꞌtaji gwanni gwätängää. Ngaa je be enggaci yigor ye yïjïlänü ngaa je denya. ");
INSERT INTO lro_vpl VALUES ("P13_16","090_3_16","1PE","3","16","16","Gäbïcär yigor yalu aar jayi nono, nunnu lanni lata je üpäcï yiꞌral nono yanni yiki ndi elelle gwalu gwanni gwujaw ndi Kirictu, a je yaaru ape giyiꞌral yegen yanni yiru yiꞌduru. ");
INSERT INTO lro_vpl VALUES ("P13_17","090_3_17","1PE","3","17","17","Yijayana ndi ari manari bupi gwuru gwudi Ngwaalu, ara je yiꞌrendeny mbuji gwani ärrï yiꞌral yanni yijaw aaꞌti yiꞌrendeny ya je mbuji lärrü yiꞌral yanni yiki. ");
INSERT INTO lro_vpl VALUES ("P13_18","090_3_18","1PE","3","18","18","Ndi ari Kirictu gwayu gwani ke gomonanu geꞌte pu gwanni gwüdünälü gwani lanni laꞌti dünälü, nunnu ara je apada Ngwaalu. Gwüꞌrïnyïtäär gilingeno a be Ngwaalu midiyi Lïgïꞌrïm le, ");
INSERT INTO lro_vpl VALUES ("P13_19","090_3_19","1PE","3","19","19","Lïgïꞌrïm le gilee liming le ele ꞌto ngwondaca ngwügïꞌrïmä ngwudi ngwüjï ngwanni ngwugekanalu. ");
INSERT INTO lro_vpl VALUES ("P13_20","090_3_20","1PE","3","20","20","Ngwanni ngwünyürtïjä Ngwaalinganu ꞌtuꞌtu gwerre gaji ganni gïmätïjä je ge Ngwaalu liguri gaji ganni giju ge Nuuwa ndi geꞌte bälükä. Gïbälükänü, looko ꞌdogo, liru ꞌdübä (8) gwuma aar gwe gïlängïdïnï giyaanu. ");
INSERT INTO lro_vpl VALUES ("P13_21","090_3_21","1PE","3","21","21","Na yaw giyee yiju yiru giꞌremna gidi yaw yanni nyïnyïnä ye gweneno ngaa ye gïlängïdïnï ꞌto. Yaꞌti ani üyïnï yirledo nono yidi ngwanginu, aar be ani änïjälü gwudi ïcïnänü gwudi ligor lanni lijaw ngwäyänü Ngwaalu. Yata je gïlängïdïyï ꞌdïꞌrï gwe gwudi Yicu Kirictu giyiꞌranyanu, ");
INSERT INTO lro_vpl VALUES ("P13_22","090_3_22","1PE","3","22","22","gwanni gwuma allu kerala na nggwo gwujalu yelenya kaama gidi Ngwaalu a gu yïꞌrr na yeleny na yiima ꞌdengenaci. ");
INSERT INTO lro_vpl VALUES ("P14_1","090_4_1","1PE","4","1","1","Yäy gu no, anni mbuja Kirictu yiꞌrendenya ngwanginu ngwüngün, yäy gwodanar banu ꞌto yiꞌral ye giyee yeꞌte yeꞌte. Ndi ari gwanni gwa yiꞌrendeny mbuji ngwanginu ngwüngün, ke gwuma äbrïnï kay ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("P14_2","090_4_2","1PE","4","2","2","Yäy gwaꞌti ba be gwelelle gïdïdlä düngün danni dïꞌdälü gwani amiꞌra gwanni gwuki gwudi lingeno, ngwube manni ärrï buping gwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("P14_3","090_4_3","1PE","4","3","3","Ndi ari ngaa lonja yomon kaji gwerre ndi ärrï yiꞌral yanni yati je ngwüjï ärrï ngwudi dïdlä. Yani elelle gwegen gwudi yidigany, amiꞌra ngwanni gwuki, rlälï, yïꞌrïnyïnä yiru yütä na dïdülä danni diki. ");
INSERT INTO lro_vpl VALUES ("P14_4","090_4_4","1PE","4","4","4","Yanni yima gäbïcï ngwüjü ngwudi dïdlä gweneno aar allalu ndïr ndi ari ngwaꞌta le acajidu giyiꞌralanu yanni yiki drü ati aar je be ürrä yïrïgïnä nono. ");
INSERT INTO lro_vpl VALUES ("P14_5","090_4_5","1PE","4","5","5","A be la ji ya je ye Kirictu otacalu gwanni nggwo gwa ji gwa otaci ngwüjälü ngwanni ngwumidu na ngwanni ngwayu. ");
INSERT INTO lro_vpl VALUES ("P14_6","090_4_6","1PE","4","6","6","Yiru giyee yanni yïgäbïcä a be ngwujaꞌri ngwanni ngwujaw ündäjïnï ꞌdi ngwüjänü ngwanni ngwo gweneno ngwayu nunnu lanni lima aar le obalu gay ge gidi dïjï dümnä ndi ari liki gilingeno, aar midi gïlïgïꞌrïm gay ge gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("P14_7","090_4_7","1PE","4","7","7","Mïꞌrä gwudi yiꞌral ꞌdar gwuma ji gito. Yäy gu no, beberar be ngaa mätïnälü nunnu ngaa otaci Ngwaalingalu. ");
INSERT INTO lro_vpl VALUES ("P14_8","090_4_8","1PE","4","8","8","Giyiꞌralala giyee ꞌdar, ämnäjïdär gwüpäng gwulleny, ndi ari ämnäjïdï gwati gwüꞌrübäjï yiꞌralalu yonyadu yanni yiki. ");
INSERT INTO lro_vpl VALUES ("P14_9","090_4_9","1PE","4","9","9","Apajidar yïrnü gwüpäng laꞌti äbïngïnü giyinenanu. ");
INSERT INTO lro_vpl VALUES ("P14_10","090_4_10","1PE","4","10","10","Angidaji gwe guy ganni gima aar je Ngwaalu angidaci, emadar ge giyiiru gwüpäng yigor ye yeꞌte pu ngaa ruyi yïmïꞌrä yidi Ngwaalu yanni yonyadu yiꞌranu. ");
INSERT INTO lro_vpl VALUES ("P14_11","090_4_11","1PE","4","11","11","Manari gwere gwati ondaji, ngwondaji nono mung ondaji ngwujaꞌri ngwudi Ngwaalu. Gwere gwanni gwati ape yiiru, ngwuje ape yiima ye ꞌdar yätädï je Ngwaalu nunnu a Ngwaalu ortani giyiꞌral ꞌdar Yicu Kirictu gwe gwanni gwuru näjï ngwuru yiima yidi gwurꞌtaling. Yiru gu. ");
INSERT INTO lro_vpl VALUES ("P14_12","090_4_12","1PE","4","12","12","Lani ngwumaad ngwüny, aaꞌti ngaa la allalu ndïr ndi mïmïnnï nono gwudi yeꞌrendeny yanni yimbuja je, nono ma yiꞌral mine ru yimbuja je yaꞌti linginna. ");
INSERT INTO lro_vpl VALUES ("P14_13","090_4_13","1PE","4","13","13","Ngaa be jayanu ndi ari ngaa gilo lacajidu giyeꞌrendenyanu yidi Kirictu, nunnu ngaa ji ngaa jayanu gwulleny komon gadi ge näjï gwüngün ꞌtädälü. ");
INSERT INTO lro_vpl VALUES ("P14_14","090_4_14","1PE","4","14","14","Manari ngwüjï ngwo ngwüllüdä je gwani Kirictu, yijayi gu ꞌdanggalu ndi ari Lïgïꞌrïm lidi näjï na lidi Ngwaalu gilo ꞌdanggalu. ");
INSERT INTO lro_vpl VALUES ("P14_15","090_4_15","1PE","4","15","15","Manari yeꞌrendeny yima je mbuji, aaꞌti yani ndi ari nga gwuꞌrinyidu na ndi ari a gwuru duꞌram na a gwärrü yiꞌral yere yanni yiki na ndi ari a gwändï giyiꞌralanu yunga yäꞌtüdï. ");
INSERT INTO lro_vpl VALUES ("P14_16","090_4_16","1PE","4","16","16","A be manari yiꞌrendeny yimbujanga yani ndi ari a gwuru dïkïrïjïn, aaꞌti yaaru ya ang ape nga be ortada Ngwaalinga ndi ari nga gwapu ngwürïny ngwüngün. ");
INSERT INTO lro_vpl VALUES ("P14_17","090_4_17","1PE","4","17","17","Ndi ari gaji giru gadi ge Ngwaalu obalu ngwüjï ngwe, ndi aalu ngwüjï ngwe ngwudi ngwuꞌdun ngwudi Ngwaalu. Ma be ari gadi aar ge aalu ꞌdengge gwerre gwerre, ya be ru ꞌtanaa ngwüjï ngwanni ngwünyürtïjä ngwujaꞌranu ngwudi Ngwaalu ngwanni ngwujaw? ");
INSERT INTO lro_vpl VALUES ("P14_18","090_4_18","1PE","4","18","18","Na ndi ari, “Manari yojema ngwüjü ngwanni ngwüdünälü ndi aar mbuji gilanging, yadi be ru ꞌtanaa ngwüjï ngwudi dïdlä na ngwanni ngwuki?” ");
INSERT INTO lro_vpl VALUES ("P14_19","090_4_19","1PE","4","19","19","Yäy no, lere lanni lati je yiꞌrendeny mbuji yani bupi gwudi Ngwaalu, aar ätädä Ngwaalinga yigoꞌro yegen ngwanni ngwuru ligor leꞌte pu ngwugeꞌta, aar gwuji ndi ärrï yiꞌral yanni yijaw. ");
INSERT INTO lro_vpl VALUES ("P15_1","090_5_1","1PE","5","1","1","Äny gwüpäcä mbumbunga jalu ꞌdanggalanu, äny gwuru ꞌto mbumbu kimaad gegen nyi ru gwanni gwänggädï yiꞌrendenya yidi Kirictu. Nyi ru gweꞌte gwanni gwa ji gwa acidi ndi näjï gwanni gwa ji gwa ꞌtädälü. ");
INSERT INTO lro_vpl VALUES ("P15_2","090_5_2","1PE","5","2","2","Rüdär ngwooꞌra ngwudi giꞌdoonga gidi Ngwaalu ganni nggo gombajangaa, ngaa je iye liru ngwangida, aaꞌti ndi ari ngaa je ärrï yiima ye, aar be ru ndi ari yärrä je yigor ye yalu anaku bupa je gu Ngwaalu ndi ru. Aaꞌti yani ndi ari ngaa lübïjä ngwüꞌrïnyänü, ngaa je be jada ndi ärrï ligor le. ");
INSERT INTO lro_vpl VALUES ("P15_3","090_5_3","1PE","5","3","3","Aaꞌti la je acajanu lanni lätädärä je Ngwaalu nunnu ngaa je ombaji, ngaa be ru ngwooꞌra ngwïlïjä giꞌdonga gora gijaw. ");
INSERT INTO lro_vpl VALUES ("P15_4","090_5_4","1PE","5","4","4","Ma be aji ma Kirictu gwanni gwuru dooꞌra didi ngwooꞌranga ꞌtädälü, la je be änïjï giyelenyanu yani guꞌru gidi näjï gwanni gwati ꞌti medadu. ");
INSERT INTO lro_vpl VALUES ("P15_5","090_5_5","1PE","5","5","5","No ꞌto lanni liru ngwamal, ꞌdengenacar je lanni lipana. Ngaa ꞌdar, okeyar yigoꞌro yalu ndi apajidi gwüpäng, ndi ari, “Ngwaalu ngwati ꞌdonya ngwüjü ngwanni ngwati piya yigoꞌro yegen ngwuje be gïꞌtïjï yïmïꞌrü ngwanni ngwati okeya yigoꞌro yegen.” ");
INSERT INTO lro_vpl VALUES ("P15_6","090_5_6","1PE","5","6","6","Okeyar be yigoꞌro yalu kuyanu gidi Ngwaalu ganni giru yiima ndi ari ara je ꞌdïꞌrïyälü kaji nggäꞌdï gïndï. ");
INSERT INTO lro_vpl VALUES ("P15_7","090_5_7","1PE","5","7","7","Gätädär yiꞌral nono ꞌdar yanni yata je pïcï yigoranu, ndi ari nginde gwuru gwanni gwada je gu geꞌtaji ngwäyänü. ");
INSERT INTO lro_vpl VALUES ("P15_8","090_5_8","1PE","5","8","8","Mätär yigoꞌro yalu nga arngani. Ndi ari güwän galu gani dijegoꞌrr ndo diru nono diira dilandalu ngwärï guba ngwümïnï nunnu mung mbujalu gwere ngwobedalu ngwungadini. ");
INSERT INTO lro_vpl VALUES ("P15_9","090_5_9","1PE","5","9","9","Kwudar le be lïdïrnïnälü ꞌdïꞌdäny ndi ämnï Ngwaalu ndi ari ngaa lïlïngïdï ndi ari ngweengga ngwalu giyen dar ngwo ꞌto ngwumbuja je yiꞌrendeny giyee yeꞌte yeꞌte. ");
INSERT INTO lro_vpl VALUES ("P15_10","090_5_10","1PE","5","10","10","A Ngwaalu ngwudi yïmïꞌrü ꞌdar, ngwanni ngwurnida je ndi ari aang acajidi ndi näjï gwüngün gwudi gwurꞌtaling ndi Kirictu, manari yiꞌrendeny yima je mbuji gwooko, nginde ligoꞌro le lüngün gwa je gwäꞌrä gwa je ojemeye nono ara je giki ngaa mätïnälü ꞌdïꞌdäny. ");
INSERT INTO lro_vpl VALUES ("P15_11","090_5_11","1PE","5","11","11","Nginde gwuru gwanni gwuru näjï ngwuru yiima yidi gwurꞌtaling. Yiru gu. ");
INSERT INTO lro_vpl VALUES ("P15_12","090_5_12","1PE","5","12","12","Ngwujaꞌri ngwee ngwoko ngwükäjï nje ngwe diwengga dani Jiliwanij gwanni gwati nyi engga gwuru diweengga diru ligor leꞌte pu, bupi gwüny ngwani nda je ojemeye nono nga je enggaci ndi ari yïmïꞌrü yiru giyee yidi Ngwaalu yanni yiru ꞌdidanu. Mätïnär gwälü ꞌdïꞌdäny. ");
INSERT INTO lro_vpl VALUES ("P15_13","090_5_13","1PE","5","13","13","Giꞌdoonga gidi Babiling ganni gäbrä je le Ngwaalu, gaganna je ara je gïjï güny Gideleny gani Murkuj aganna. ");
INSERT INTO lro_vpl VALUES ("P15_14","090_5_14","1PE","5","14","14","Agannajidar giyenenanu agannajiding gwudi ämnï. Ara je gu adatalu ji ꞌdar, ngaa lanni gilo ndi Kirictu.");
INSERT INTO lro_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","Änyängä lullu ngwujaꞌri ngwudi midi ngwuju ꞌtuꞌtu gwerre ngwanni ngwuꞌdingini nje, nje engga ngwäy ngwe ngwärï nje inggidi nje akani nono ngwuy ngwe ngwärï ngwuru ngwee ngwaru nyii ngwe gweneno. ");
INSERT INTO lro_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","Midi nggwee gwüꞌtädälü nyii engga nyii gwe ondaji, ara je be enggaci ndi ari ngwujaꞌri ngwuru ngwudi midi gwudi gwurꞌtaling gwanni gwuju ndi Papa gwuru Ngwaalu aar nje be ꞌtäcälü. ");
INSERT INTO lro_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","Ngwujaꞌri ngwanni ngwänggädï nje, nje ꞌdingini, ngwuru ngwondacara je ngwe nunnu ar gu acajidi ar gu emadanu gwüpäng. Ar emadi ndi acajidi gwüpäng na acajidi gwege nggwee gwuru Ngwaalinga le ngwuru Papa na Gïjï güngün gani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","Änyängä lullu ngwujaꞌri ngwee, nunnu a jayanu gwege ru gwanni gwumbutu. ");
INSERT INTO lro_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","Ngwujaꞌri ngwuru ngwee ngwanni ngwuꞌdingini nje ndi Yicu ara je be ondaca. Ndi ari Ngwaalu ngwuru buri, dïrïm dere daꞌti ꞌdünggüngün aꞌtur. ");
INSERT INTO lro_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","Ma be ari nunnu a lima ari gwacajidar le ar be elelle gïdïrïmänü, a liru ngwuꞌduru na elelle gwege gwa ru ꞌtur. ");
INSERT INTO lro_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","A be manari a lima elelle giburalu anaku ru gu Ngwaalu buri, a la be ätï acajiding gwüpäng ꞌdidanu, na yïn yidi Gïjï güngün gani Yicu, yinje oyaji kengalu ꞌdar. ");
INSERT INTO lro_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Manari a lima ari a laꞌti ki, a la dudiyi yigoꞌro yege na ngwujaꞌri ngwanni ngwuru ꞌdidanu ngwaꞌti ngwa ji ꞌdenggeganu. ");
INSERT INTO lro_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Ma be ari alanga lima ꞌtäjälü ndi ari a liki, nginde gwuru ligor leꞌte pu ngwüdünälü gwunje düdänïjänü na gwunje gaꞌru giyiꞌral ꞌdar yege yanni yiki. ");
INSERT INTO lro_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","Manari a lima ari alanga laꞌti ärrä yiꞌral yanni yiki, gwa ar aniji diꞌduru na ngwujaꞌri ngwüngün ngwaꞌti ꞌdengge. ");
INSERT INTO lro_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","Nggwüllïjä je ngwujaꞌri ngwee lani yïjï yüny nunnu aaꞌti ngaa la ärrï yiꞌral yanni yiki. Ma be ari dïjï dere dima ärrï yiꞌral yanni yiki, a lätï Yicu Kirictung gwanni gwüdünälü gwati nje ruci ndi Papa. ");
INSERT INTO lro_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","Nginde gwanni gwümïꞌrïdï nje nono ligoꞌro le lüngün aar nje gaꞌru ndi ke gwege. Aaꞌti be ke rüdï gwege ꞌdogo jücü, ngwube ru ꞌto ke gwudi ngwüjï ꞌdar gïdïdlä. ");
INSERT INTO lro_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","Manari gwuma ar ꞌdengenaci ngwujaꞌri ngwüngün, a la be lenge ndi ari gwülïngïdär. ");
INSERT INTO lro_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","Gwanni gwati ari, “Gwülïngïdïny,” ngwuꞌti be ärrä ngwujaꞌri ngwüngün, gwuru diꞌduru na ꞌdidanu gwaꞌti ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","A be gwere gwanni gwati ꞌdengenaci ngwujaꞌri ngwüngün, gwuru dïjï danni dämnä Ngwaalinga ämnïng gwanni gwuru ꞌdiꞌdidanu. Yiru giyee yanni yati nje gäbïcï ar lenge ndi ari a gilo ꞌdünggün. ");
INSERT INTO lro_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","Ndi ari gwere gwanni gwati ari gwümätïnälü ꞌdünggüngün, ngwelelle nono elella gu Yicu. ");
INSERT INTO lro_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","Lani ngwumaad ngwüny, ngwujaꞌri ngwee ngwüllïjä je ngwäꞌtüdï ngwuyang, ngwuru ngwujaꞌri ngwanni ngwuꞌrin ngwuꞌdingina je ꞌtuꞌtu gwerre. Ngwujaꞌri ngwee ngwuru ngwuꞌrin ngwuru ngwujaꞌri ngwanni ngwuꞌdingina je. ");
INSERT INTO lro_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","A be nyi gwüllïjä je ngwujaꞌri ngwanni ngwuyang. ꞌDidanu gwudi ngwujaꞌri ngwee nggwo gwenggana ndi Kirictu na ꞌdanggalu ndi ari dïrïm ndo ndi abri kayanu a buri gwanni gwuru ꞌdidanu gwuma be oꞌrralu. ");
INSERT INTO lro_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","Gwanni gwaru nggwo giburalu ngwube a be gwenggen ke ngwäy, nginde nggwona gïdïrïmänü kaji nggoo. ");
INSERT INTO lro_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","Gwanni gwati ämnï gwenggen, gwati elelle giburalu a yere yaꞌti ꞌdünggüngün yanni yiki yadi gäbïcï ngwobalu. ");
INSERT INTO lro_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","A be gwanni gwati gwenggen ke ngwäy, nginde nggwo gïdïrïmänü, dïndïng gwänü a gwaꞌti lïngïdï ndi ari gwadi ne. Gwuma dïrïm rïmïyï ngwäy. ");
INSERT INTO lro_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","Äny gwüllïjä je ngwujaꞌri ngwee lani yïjï yüny ndi ari ke gwalu gwuma ara je Ngwaalu düdänïjänü ndi Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","Äny gwüllïjä je lani papanga, ndi ari gwülïngïdängä gwanni gwuju ꞌtuꞌtu gwerre gwani Yicu Kirictu. Äny gwüllïjä je nga nga lanni liru ngwamal ndi ari ngaa lima obeda dijegoꞌralu. Äny gwüllïjä je lani yïjï yüny ndi ari ngaa lïlïngïdï papang. ");
INSERT INTO lro_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","Äny gwüllïjä je lani papanga ndi ari nga nga lïlïngïdï ngindeng gwanni gwuju ꞌtuꞌtu gwerre. Äny gwüllïjä je lanni liru ngwamal, ndi ari ngaa lojema nono, a ngwujaꞌri ngwudi Ngwaalu ngwümätïnälü ꞌdanggalu, na ngaa lima obeda dijegoꞌralu. ");
INSERT INTO lro_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","Ngaa ꞌti ämnä dïdläyü na yiꞌral yere yidi dïdlä. Manari gwere nggwo gwati ämnï dïdläyü, gwaꞌti gu ämnï gwudi papa. ");
INSERT INTO lro_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","Ndi ari yiꞌral ꞌdar yidi dïdlä, nono amiꞌra gwudi lingeno, ari ngwäy gwudi ngwong ngwudi dïdlä, gïgïꞌtïnälü gwudi lingeno gwanni gwätïng na ngwanni ngwati je ngwüjï ärrï, ngwati ꞌti ïndï ndi papa, ngwudi dïdlä ngwuru. ");
INSERT INTO lro_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","Dïdlä yiꞌral yanu yüngün yanni yiki yanni yati ari ngwüjänü, ya dudi a be dïjï danni dati ärrï buping gwudi Ngwaalu, da midi miding gwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","Lani yïjü yüny, gaji gima be ja gito. Lica je gwele gwerre ndi ari güwän gidi Kirictu ga ji gila. Gweneno gima be ila gonyadu gima ꞌtädälü, a la be lenge ndi ari gaji gima be ja gito. Güwän nggee gïꞌtüdï ꞌdenggeganu ndi ari gati ar le acajidi gwerre, ");
INSERT INTO lro_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","aar be ꞌtü aar nje gatani. Adinari lacajidar le kiꞌdu geꞌte pu ꞌdidanu, laadi ar le jalu. Liminje be gatani ndi ari ngindenga läꞌtüdï lidi giꞌdu gege. ");
INSERT INTO lro_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","A be nga nga, lima je Ngwaalu maji lïgïꞌrïmä nono Yicu gwe, na no, nga nga ꞌdar yïlïngïdï je yanni yiru ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","Äny gwaꞌta je üllïjä ndi ari nga nga laꞌti lïngïdï ꞌdidanung, a be ndi ari nga nga gwülïngïdängä, ngaa lenge ꞌto ndi ari yiꞌduru yere yaꞌti ngwujaꞌranu ngwanni ngwuru ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","A be yärü gwanni gwuru diꞌduru? Dïjï diru danni dati ari Yicu gwäꞌtüdï gwanni Gwubrutaar yelenya. Dïjï danni diru gu no, diru güwän gidi Kirictu diru danni dati ꞌdonya Papang na Gïjï. ");
INSERT INTO lro_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","Ndi ari dïjï dere danni dati ꞌdonya Gïjü, daꞌti ätï Papang. Gwere gwanni gwati ämnï Gïjü, gwati ämnï ꞌto Papang. ");
INSERT INTO lro_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","Mätïnär bälü ndi määtä ngwujaꞌri giyigoranu ngwanni ngwuꞌdingina je ꞌtuꞌtu gwerre ngaa gu mätïnälü ꞌdïꞌdäny. Manari ngaa gilo gu, ngaa ꞌto la mätïnälü Kïjï na ndi Papa. ");
INSERT INTO lro_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","A yiru giyee yanni yicaar nje ye Ngwaalu ndi ari gwunje ätädä ꞌto miding gwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","Äny gwüllïjä je ngwujaꞌri ngwee nga je girinya gwani ngwüjï ngwanni gwati mïnï ndi ara je ïꞌdäjänü aar je oktada ꞌter ngaa dudi. ");
INSERT INTO lro_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","A be ꞌdanggalu, Kirictu gwuma je maji lïgïꞌrïmä nono lïmätïnälü ꞌdanggalanu ngaa laꞌta be mïnä dïjü dere ndi ara je enggaci mana yanni yiru ꞌdidanu. Ma be ari lïgïꞌrïm lüngün lïmätïnälü ꞌdanggalu ndi ara je enggacalu pipiꞌriꞌti, a liru lïgïꞌrïm lanni liru ꞌdidanu läꞌtüdï yiꞌduru, mätïnärälü ꞌdünggüngün anaku enggacara je gu. ");
INSERT INTO lro_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","A be gwenene lani yïjï yüny, mätïnärälü ꞌdünggüngün nunnu ma ji mung ꞌtädälü, aaꞌti yedeny yinje eny a nje yaaru ape komon ganni gading ge oꞌra. ");
INSERT INTO lro_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","Manari ngaa lïlïngïdï ndi ari Kirictu gwuru gwanni gwüdünälü, ngaa la gu be lenge ndi ari dïjï dere danni dati ärrï yiꞌral yanni yïdünälü, diru gïjï gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","Änggädär ämnïng gwuru ꞌtaa gwudi Ngwaalu ngwuru Papa, gwanni gwämnäär nje gwe! Ämnï gwüngün gwupa gwulleny ꞌdi ndi ari liminje ci, ‘yïjï yidi Ngwaalu.’ Na a liru gu yïjï yüngün ꞌdidanu. Yiru giyee yanni yïgäbïcä ngwüjü ngwudi dïdlä aar nje ꞌti be lïngïdï ndi ari ngwüjï ngwudi dïdlä ngwaꞌtina lïngïdï Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Gwenene lani ngwumaad ngwüny, a liru yïjï yidi Ngwaalu, a be yaꞌti linginna ndi ari gweere a ladi ru ꞌtaa. A be a lïlïngïdï ndi ari ma ji ma Kirictu ꞌtädälü, a la ru nono ngindeng, nunnu gwa ar engga anaku rung gu ꞌdidanu. Dïjï dere danni dätï geꞌtajing nggwee giligoranu lüngün ndi Kirictu, dati juꞌriyi lingina lüngün ");
INSERT INTO lro_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","anaku juꞌriya gu Yicu lingina lüngün. ");
INSERT INTO lro_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","Dïjï dere danni dati ärrï yiꞌral yanni yiki dati kiyi yobo yidi Ngwaalu ꞌdidanu yiru ndi ari yiꞌral yanni yiki, yani kiyi yobo. ");
INSERT INTO lro_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","A be ngaa lïlïngïdï ndi ari Kirictu gwüllü ndi äbrï yiꞌral yidi ngwüjï yanni yiki, ngaa lïlïngïdï ndi ari nginde gwäꞌtüdï dïjï danni diki. ");
INSERT INTO lro_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","Gwere gwanni gwümätïnälü ꞌdünggüngün, ngwaꞌti gwa ji ndi gwujani yiꞌral yanni yiki. A be gwanni gwa ji ndi gwujani yiꞌral yanni yiki gwurꞌtal, gwaꞌting änggädï na gwaꞌting lïngïdï. ");
INSERT INTO lro_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","Aaꞌti dïjï dere da je oktada ndi dudi lani yïjï yüny. Gwanni gwati ärrï yiꞌral yanni yïdünälü, gwuru dïjï dïdünälü, anaku dünü gu Kirictalu. ");
INSERT INTO lro_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","Gwanni gwa ji ndi gwujani yiꞌral yanni yiki gwurꞌtal, gwuru gïjï gidi dijegoꞌrr ndi ari dijegoꞌrr diru danni därrä yiꞌral yanni yiki ꞌtuꞌtu gwerre. Yiru yanni yïgäbïcä Gïjü gidi Ngwaalu ngwüllä ndi ari ngwuje äbrï yanni yima ji dijegoꞌrr ärrï. ");
INSERT INTO lro_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","Gwere gwaꞌti gwuru gïjï gidi Ngwaalu gwati ji ndi gwujani yiꞌral yanni yiki gwurꞌtal, ndi ari lïgïꞌrïm lidi midi Ngwaalu lima ji ꞌdünggüngün, ndi ari gwaꞌti gwa ji ndi gwuji yiꞌral yanni yiki gwurꞌtal ndi ari gwuma ru gïjï gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","Yiru giyee ndi ari awa a ladi lenge yïjü yidi Ngwaalu ꞌter gïyïjänü yidi dijegoꞌrr ndi ari gwere gwanni gwati ꞌti ärrä yiꞌral yanni yïdünälü na ꞌto gwere gwanni gwati ꞌti ämnä gwenggen, gwäꞌtüdï gïjï gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","Ngwujaꞌri ngwanni ngwuꞌdingina je gwerre ngwuru ngwee, ndi ari ar ämnäjïdï. ");
INSERT INTO lro_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","Aaꞌti a la ru nono Gayining, nginde gwanni gwuru gïjï gidi dijegoꞌrr ngwümäätä gwenggen gwani Äbïïl ngwuꞌrinye. Gayin gwarra ngwube ꞌrinye gwenggen gwani Äbïïl? Yäꞌtüdï mene ndi ari yiꞌral yüngün yaꞌti dünälü ngwäyänü Ngwaalu a be yiꞌral yidi gwenggen gwani Äbïïl aar be dünälü ngwäyänü Ngwalo? ");
INSERT INTO lro_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","Yäy gu no aaꞌti ngaa lobalu, lani ngwänggärï manari nga lima ke ngwüjü ngwäy ngwudi dïdlä. ");
INSERT INTO lro_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","A lïlïngïdï ndi ari alanga lima gatana gay gidi yiꞌrany a lima elada ndi midi, na lïlïngïdï gu no ndi ari a lati ämnï ngwengga. Gwanni gwati ꞌti ämnä, nggwo gu na yiimala yidi yiꞌrany. ");
INSERT INTO lro_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","Gwere gwanni gwati gwenggen ke ngwäy, gwati ꞌrinyidi. Na ngaa lïlïngïdï ndi ari gwere gwanni gwati ꞌrinyidi, gwaꞌti ätï miding gwudi gwurꞌtaling ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","A lïlïngïdï ndi ari ämnï gwani yärü, ndi ari Kirictu gwayu gwani alanga. Alanga ꞌto la dodaji yigoꞌro yege ngweengga! ");
INSERT INTO lro_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","Dïjï danni dätï ngwony ngwudi lingeno ngwube engga gwenggen gwanni gwuru diwayi ngwuꞌti be ïnädï, awa ngwube ari dämnä Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","Lani yïjï yüny, ämnï gwege aaꞌti gwa ru ngwujaꞌri ngwudi ngwulem ꞌdogo ngwube ru ämnï gwanni gwuru ꞌdidanu giyiꞌral yanni yati ar je ärrï. ");
INSERT INTO lro_vpl VALUES ("J13_19","092_3_19","1JN","3","19","19","Yiru be giyee yanni yati nje gäbïcï ar lenge ndi ari a liru ngwüjï ngwudi ꞌdidanung. Yiru giyee yanni yadi nje gäbïcï ar dünä ligor le laꞌti yedenyanu ngwäyänü Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("J13_20","092_3_20","1JN","3","20","20","Ma be ari yigor yiminje mïꞌränü, ar lenge ndi ari Ngwaalu ngwupana giyigor yege na ngwuru ngwanni ngwülïngïdï ngwujaꞌralu ꞌdar. ");
INSERT INTO lro_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","A no lani ngwumaad ngwüny, ma be ari yigor yege yiminje ꞌti mïꞌrïdänü, yedeny yaꞌti yinje eny ngwäyänü Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","Ya ar je mbuji ꞌdünggüngün ꞌdar yanni ya ar ye otacalu, ndi ari gwati ar ꞌdengenaci ngwujaꞌri ngwüngün ar ärrï yiꞌral yanni yati gäbïcï ngwujayanu. ");
INSERT INTO lro_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","A ngwujaꞌri ngwüngün ngwanni ngwaru ngwe ngwuru ngwee ndi ari ar ämnï Gïjü güngün gani Yicu Kirictu na ar ämnäjïdï gwüpäng. ");
INSERT INTO lro_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","Lanni lati ꞌdengenaci ngwujaꞌri ngwüngün, lïmätïnälü ꞌdünggüngün na nginde gwümätïnälü ꞌdenggen. A yiru giyee ndi ari awa a lïlïngïdï ndi ari nginde gwümätïnälü ꞌdengge, ndi ari a lïlïngïdï gu lïgïꞌrïm le lanni lätädäär nje. ");
INSERT INTO lro_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","Lani ngwumaad ngwüny, aaꞌti ngaa lämnï ngwujaꞌri ngwudi lïgïꞌrïmälü rügüm, ngaa be manni iye ngwügïꞌrïmä ngwäy nono ndi aang lenge ndi ari ngwïndï Ngwaalu. Ndi ari ngwïjïr ngwo ngwonyadu ngwuru ngwuꞌduru ngwuma ꞌtü ngwuma badalu gïdïdlänü. ");
INSERT INTO lro_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","Yiru giyee yanni yati nje gäbïcï nda be lenge lïgïꞌrïmä lidi Ngwaalu, ndi ari lïgïꞌrïm lere lanni lati ari Yicu Kirictu gwïndï gilingeno, liru lidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","A be lïgïꞌrïm lere lanni lati ꞌdonya ngwujaꞌri ngwee ngwani Yicu, läꞌtüdï lïgïꞌrïm lidi Ngwaalu, liru lïgïꞌrïm lanni liru güwän gidi Yicu lanni liꞌdingina le ndi ari ladi ila, a gilo lima obana gwenene gïdïdlä. ");
INSERT INTO lro_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","Ngaa liru lidi Ngwaalu, lani yïjï yüny. A lima je dami lidi dïdlä ndi ari gwanni nggwo ꞌdanggalanu gwojemana nono gïlïgïꞌrïm lanni gilo ngwüjänü ngwudi dïdlä. ");
INSERT INTO lro_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","Ngindenga liru ngwüjï ngwudi dïdlä ngwati ondaji ngwujaꞌri ngwudi ngwong ngwudi dïdlä ati je be ngwüjï ngwudi dïdlä ꞌdengenaci. ");
INSERT INTO lro_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","A be alanga liru lidi Ngwaalu. Dïjï dere danni dïlïngïdï Ngwaalinga, dati nje ꞌdengenaci. A be gwere gwanni gwäꞌtüdï gwudi Ngwaalu, gwati nje ꞌti ꞌdengenaca. Yiru giyee yanni yati nje gäbïcï ar be ngengedani ngwujaꞌranu ngwudi lïgïꞌrïm liru ꞌdidanu ngwujaꞌranu ngwudi lïgïꞌrïm lanni liru diꞌduru. ");
INSERT INTO lro_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","Lani ngwumaad ngwüny, gäbïcär ar ämnäjïdï ndi ari ämnï gwïndï Ngwaalu. Gwere gwanni gwati ämnï, gwuru gïjï gidi Ngwaalu na gwülïngïdï Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","Gwere gwanni gwati ꞌti ämnä, gwaꞌti lïngïdï Ngwaalinga, ndi ari Ngwaalu ngwuru ämnï. ");
INSERT INTO lro_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","A yiru giyee yinggida ndi ari Ngwaalu ngwenggaci nje ämnïng gwüngün awa. Ndi ari ngwükäjä Gïjü gwüngün ganni giralu geꞌte pu gïdïdlä ndi ari nunnu ar ge gilang. ");
INSERT INTO lro_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","Ämnï gwuru nggwee, ndi ari a läꞌtüdï lanni lämnä Ngwaalinga, a be Ngwaalu ru ngwanni ngwämnï nje ꞌdi aar ükäjä Gïjü gwüngün aar nje mïꞌrïnï nono aar nje gaꞌru ndi ke gwege. ");
INSERT INTO lro_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","Lani ngwumaad ngwüny, anni ämnär nje gu Ngwaalu no, gäbïcär be ar ämnäjïdï gwüpäng. ");
INSERT INTO lro_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","Dïjï dere daꞌti aꞌtur danni dänggädï Ngwaalinga. Ma be ari alanga lämnäjïdü, Ngwaalu ngwa ji ꞌdengge na ämnï gwüngün, gwa mbuti ꞌdengganu. ");
INSERT INTO lro_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","A lïlïngïdï ndi ari nggwo gwümätïnär gu a nginde nggwo ngwümätïnälü ꞌdengge. Ndi ari nginde gwuminje ätädä lïgïꞌrïmä lüngün. ");
INSERT INTO lro_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","A alanga lima engga, a lima ondaci ngwüjü ndi ari Papa gwuma ükäjä Gïjü güngün ngwuru gilang gwudi ngwüjï ngwudi dïdlä. ");
INSERT INTO lro_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","Manari dïjï dere dima ämnï ndi ari Yicu gwuru Gïjï gidi Ngwaalu, Ngwaalu ngwa mätïnälü ꞌdünggüngün a nginde gwa mätïnälü Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","A gu no gwenene, a lïlïngïdï ar gatada ngwäyänü ndi ämnï gwanni gwätädäär nje Ngwaalu. Ngwaalu ngwuru ngwati ämnï ngwüjü. A gwere gwanni gwelella ämnï gwe, gwümätïnälü Ngwaalu a Ngwaalu mätïnälü ꞌdünggüngün. ");
INSERT INTO lro_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","Gay ge nggee, ämnï gwati nje gu mbutanu ndi ari aaꞌti yedeny ya ji komon gidi obalu ndi ari ngene gïdïdlä ndee, a liru nono Kirictu. ");
INSERT INTO lro_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","Yedeny yaꞌti ndi ämnï, a be ämnï gwanni gwumbutu gwati ꞌtüyï yedenyanu, ndi ari yedeny yati ji yani yiꞌrendeny. Gwanni gwati yedeny eny, gwamiꞌratu ndi ämnï. ");
INSERT INTO lro_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","Alanga lati ämnäjïdï ndi ari Ngwaalu ngwuru ngwämnï nje gwerre gwerre. ");
INSERT INTO lro_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","Manari gwere gwuma ari, “Äny gwämnä Ngwaalinga,” ngwube gwenggen ke ngwäy, nginde gwuru diꞌduru. Ndi ari gwere gwanni gwati ꞌti ämnä gwenggen gwanni gwating engga, awa ngwube ämnï Ngwaalinga ngwanni ngwaꞌting je änggädï. ");
INSERT INTO lro_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","A nginde gwuminje ätädä ngwujaꞌri ngwüngün ngwee ndi ari gwere gwanni gwati ämnï Ngwaalinga, ngwämnï gwenggen ꞌto. ");
INSERT INTO lro_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","Gwanni gwati ämnï Ngwaalu ndi ari Yicu gwuru gwanni Gwubrutaar yelenya, gwuru Gïjï gidi Ngwaalu, a gwanni gwati ämnï Papang, gwati ämnï Gïjü güngün ꞌto. ");
INSERT INTO lro_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","Gay giru nggee gadi ar ge lenge ndi ari awa a lämnä yïjü yidi Ngwaalu, ndi ari ämnï gwe gwege Ngwaalinga na ꞌdengenaji gwe gwege ngwujaꞌri ngwüngün. ");
INSERT INTO lro_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","Ämnï Ngwaalinga gwege gwuru nggwee, ndi ari ar ꞌdengenaci ngwujaꞌri ngwüngün. A ngwujaꞌri ngwüngün ngwaꞌti nï ꞌdengge. ");
INSERT INTO lro_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","Ndi ari gwanni gwuru gïjï gidi Ngwaalu, gwätï yiima ndi dami dïdläyü. A dami gwege gwuru nggwee gwanni gwuma dami dïdläyü, ämnï gwe gwege ndi Yicu. ");
INSERT INTO lro_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","Yärü gwuru gwanni gwadi dami dïdläyü? Dïjï deꞌte pu diru danni dati ämnï Ngwaalu ndi ari Yicu gwuru Gïjï gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","Yicu Kirictu gwuru nggwee gweꞌte pu gwanni gwïndï yaw ye yani nyïnyïnï gwüngün na yïn ye yüngün yani yiꞌrany yüngün. Nginde gwaꞌti ïndï yaw ye ꞌdogo, a be gwïndï yaw ye na yïn ye yüngün. A Lïgïꞌrïm liru lanni lati inggidi nginde gwe na yanni yinggida ye Lïgïꞌrïm, yätï ngwäy ndi ari liru Lïgïꞌrïm ꞌdidanu. ");
INSERT INTO lro_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","Ndi ari liru täꞌrïl (3) lanni londaja kerala, ");
INSERT INTO lro_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","lïgïꞌrïm na yaw na yïn. ꞌDar gilee liru täꞌrïl (3) ondaji gwegen gwuru gweꞌte pu. ");
INSERT INTO lro_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","A lati ämnï inggiding gwudi ngwüjï, a be inggidi gwudi Ngwaalu gwupana, a ngwondijaja kïjï güngün. ");
INSERT INTO lro_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","No lanni lati ämnï Kïjï gidi Ngwaalu, lätï ondajing nggwee giyigoranu yegen. A be lanni lati ꞌti ämnä Ngwaalu, lima ruji Ngwaalinga diꞌduru ndi ari ngindenga lati ꞌti ämnä ngwujaꞌri ngwanni ngwaru ngwe Ngwaalu Kïjï güngün. ");
INSERT INTO lro_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","Inggidi gwinggidaar gwe gwuru nggwee. Ndi ari Ngwaalu ngwuminje ätädä miding gwudi gwurꞌtaling na miding nggwee ngwïndï Kïjï güngün. ");
INSERT INTO lro_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Gwanni gwätï Gïjü, gwätï miding nggwee. Gwanni gwaꞌti ätï Gïjü, gwaꞌti ätï miding nggwee. ");
INSERT INTO lro_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","Äny gwüllïjä je ngwujaꞌri ngwee nunnu ngaa lenge ndi ari ngaa lätï miding gwudi gwurꞌtaling, ngaa lanni lämnä Kïjï gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","Yiru giyee yanni yati nje gäbïcï a nje ꞌti yedeny ïtï ndi ꞌdonggaci Ngwaalinga. Ndi ari manari yere yanni ya ar ye otaci Ngwaalingalu yanni yïndäär bupi gwe gwüngün, ya aar nje ꞌdengenaci. ");
INSERT INTO lro_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","A manari a lïlïngïdï ndi ari nginde gwati nje ꞌdingini giyiꞌral yere yanni yati ar ye otacalu, a la be lenge ndi ari ya ar je mbuji yanni yotacar yalu. ");
INSERT INTO lro_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","Manari gwere gwati engga gwenggen ndi ärrï yiꞌral yanni yiki yanni yati ꞌti üktädï giyiꞌrany, gäbïcä ngwotaci Ngwaalingalu a gwa Ngwaalu ätä miding. Yiꞌral giyee nggwärädï gu ngwüjï ndi ke gwegen gwanni gwati ꞌti üktädï giyiꞌrany. A be ke nggwo gweꞌte gwanni gwati oktada yiꞌrany. A be äny gwaꞌti aru nga otaci Ngwaalingalu giyiꞌral giyee. ");
INSERT INTO lro_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","ꞌDar yanni yati ärrïnï yiki, yiki ngwäyänü Ngwaalu. A be ke nggwo gweꞌte gwanni gwati oktada giyiꞌrany. ");
INSERT INTO lro_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","A lïlïngïdï ndi ari gwere gwanni gwuru gïjï gidi Ngwaalu gwati ꞌti ju ndi gwuji ärrïng gwanni gwuki gwurꞌtal, ndi ari gwuru gïjï gidi Ngwaalu gwati gu Ngwaalu etadala, a dijegoꞌrr daꞌti da ang alliji guy nono. ");
INSERT INTO lro_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","A lïlïngïdï ndi ari a liru yïjï yidi Ngwaalu na ndi ari dïdlä ꞌdar ndee ndo kuyanu gidi dijegoꞌrr. ");
INSERT INTO lro_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","A lïlïngïdï ꞌto ndi ari Gïjï gidi Ngwaalu gima üllä na giminje ätädänï bebereng, nunnu ar lenge ngindeng gwanni gwuru ꞌdidanu. A alanga gilo ꞌdünggüngün gwanni gwuru ꞌdidanu Kïjï güngün gani Yicu Kirictu. Nginde gwuru Ngwaalu ꞌdidanu a midi gwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","Lani yïjï yüny, etadar giyigoꞌro yalu giyiꞌremna yidi dïdülä yidi dïdlä yanni yiru ꞌtur.");
INSERT INTO lro_vpl VALUES ("JD1_1","095_1_1","JUD","1","1","1","Ngwujaꞌri ngwee ngwïndï ꞌdünggüny äny gwani Yäwüdä gwuru gwenggen gwudi Yagubinga, äny gwuru dïnäd didi Yicu Kirictu. Ngwükäcï nje ngwüjü ngwanni ngwämnä je Papa gwuru Ngwaalu ngwuje urnidi. Ngwanni ngwo ngwetadu gu Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("JD1_2","095_1_2","JUD","1","2","2","Ara je gu ïnä gwudi Ngwaalu na adatalu na ämnï ji gwïrälü. ");
INSERT INTO lro_vpl VALUES ("JD1_3","095_1_3","JUD","1","3","3","Lani ngwumaad ngwüny, äny gwüjädï gu gwulleny nda je üllïjä ngwujaꞌri ngwee ngwani gilang gwanni gwemadar gu gwüpäng, nyi be oꞌre nyi ïcïnänü ndi ari nga je üllïjä nga je päcälü ngwujaꞌri ngwe ngwani ämnï Ngwaalu nunnu ngaa gu etadi ꞌdïꞌdäny, gwanni gwügätïjänä Ngwaalu ngwüjü ngwüngün ngwanni ngwujuꞌru gwurꞌtal. ");
INSERT INTO lro_vpl VALUES ("JD1_4","095_1_4","JUD","1","4","4","Ndi ari ngwüjï ngweꞌte ngwo ngwaꞌti gïdrü didi Ngwaalu ngwuma ngwe Ngwaalu obalu ꞌtuꞌtu gwerre, ngwo ngwuma je änï gidiliganu. Ngwuru ngwüjï ngwaꞌti ätï drü didi Ngwaalu ngwati gwürlï ngwujaꞌri ngwudi yïmïꞌrü yidi Ngwaalu ngwege aar je aniji gay gidi yidigany aar nyïꞌrïnï Delenya dege dipa diru deꞌte pu dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("JD1_5","095_1_5","JUD","1","5","5","Ngaa je ni lenge gwele giyee ꞌdar, nggwubupa ngaa diwayini ndi ari Deleny diru Ngwaalu dïgïlängïdïyä ngwüjü ngwüngün ngwuru Yïjïräyïl ken gani Mijir. A be aji a je yiꞌrany ꞌrinye lanni lima ꞌti ämnä Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JD1_6","095_1_6","JUD","1","6","6","Diwayinar ꞌto yïꞌrrä yanni yima ꞌti mätï ngwaalinga ngwegen aar ꞌti ïndï yeleny ye yanni yätädï je Ngwaalu aar be gatani ngwaalinga ngwegen, yima je Ngwaalu rädä gïdïrïmänü ngwuje gekajalu yuꞌrung ye yidi gwurꞌtaling giyoo yijica pïcïng yelenya gwudi gomon nggäꞌdï gipa gidi gwodaning. ");
INSERT INTO lro_vpl VALUES ("JD1_7","095_1_7","JUD","1","7","7","Diwayinar ꞌto ndi ari yiru gu yeꞌte yeꞌte nono ngwüjü ngwudi yündär yidi Jaduminga Gamura gwe na yündär yanni yijicidaar ye, ngwur ngwugwurlidalu aar übïjï yidiganyanu ꞌdar. Yiiru yegen yanni yärräär je yiru gora gidi ngwüjï ꞌdar ngwanni ngwa je yiꞌrendeny yidi lïgä lidi gwurꞌtaling reraji. ");
INSERT INTO lro_vpl VALUES ("JD1_8","095_1_8","JUD","1","8","8","Yiru gu ꞌto no ngwüjï ngwee ngwati je ngwulingid eny aar digang ngwangina ngwegen aar ci yelenyalu mireny aar ari ngwulem ngwüjï ngwünäjïnä kerala. ");
INSERT INTO lro_vpl VALUES ("JD1_9","095_1_9","JUD","1","9","9","A be deleny didi yïꞌrr dani Mägäyïl anni garnataar dijegoꞌrr de ngwanginu ngwudi Müjä, dima ꞌti ädïnä ndi ari ngwulem ngwüꞌrïdä dijegoꞌrro ngwujaꞌri nono ngwube ci ꞌdogo, “Aar ang Deleny girinya.” ");
INSERT INTO lro_vpl VALUES ("JD1_10","095_1_10","JUD","1","10","10","A be ngwüjï ngwee ngwuru ngwuꞌduru aar ondaji yidiganya giyiꞌralu ꞌdar yaꞌti aar ye lïngïdï yorta ye ngwaalinga na yiꞌral yïlïngïdäär je aar je übïjänü ligor le aar ru nono yooꞌra yubanu yaꞌti lïngïdï. Yiꞌral yiru giyee ngwäyälü yanni yati je gäbïcï aar dudi. ");
INSERT INTO lro_vpl VALUES ("JD1_11","095_1_11","JUD","1","11","11","Wäj bi gwani ngindenga! Lima gwuji gay gidi Gayin, lima büdädï lima ïꞌdï kora gidi gur gani Balam gani linynyi bileng. Lima dudi lima ru nono guru gani Koora gwani nyurtanu gwüngün. ");
INSERT INTO lro_vpl VALUES ("JD1_12","095_1_12","JUD","1","12","12","Ngwüjï ngwee ngwübïrꞌtängïdïnä ngwaꞌti je yaaru apu ꞌdi yooko nda le emadi gwüpäng kiny geꞌte pu gïyïꞌrïnyïnä yalu. Ngindenga liru ngwooꞌra ngwïtädï giyigoꞌro yegen ꞌdogo. Ngindenga liru nono gïbäꞌrü gapu dirun gaꞌti nu giranyu. Ngindenga liru nono ngwaꞌri digadu de ngwaꞌti ꞌriꞌru a je ngwüjï aku. Aar ru nono ngwaꞌri ngwayu yomonanu rom ngwugwallanalu aar gätïnï mbüny. ");
INSERT INTO lro_vpl VALUES ("JD1_13","095_1_13","JUD","1","13","13","Ngindenga liru nono dudu daru giyaanu, aar allijaja ngwuduwalu ngwegen mbüny aar ngwe apiyi ngwüjü yaaru. Ngindenga liru nono yuurrumu yanni yidudu yigeꞌta je Ngwaalu, ji gwegen gwuru dïrïm dümnänü ꞌtïꞌtïn didi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("JD1_14","095_1_14","JUD","1","14","14","Agunug gwanni gwuru giꞌra kwoꞌra täꞌrïl (7) kilinge gidi Adam, gwallija yïjïrä ngwüjï ngwee ngwari, “Lïngïdär ndi ari Deleny ndo dïndäär ngwüjï ngwe ngwüngün ngwanni ngwujuꞌru ngwuru ngwüüꞌrï (1,000) na ngwüüꞌrï (1,000), ");
INSERT INTO lro_vpl VALUES ("JD1_15","095_1_15","JUD","1","15","15","ndi pïcï ngwüjü yelenya ꞌdar ngwudi dïdlä ngwuje määtä ꞌdar ngwanni ngwuki drü gwani apepe gwegen ꞌdar gwanni gwuki drü gwanni gwärräär gay ge gidi drü danni diki, na gwani yiꞌral ꞌdar yanni yiki drü yondijaja je ngwüjï nono ngwanni ngwuki drü.” ");
INSERT INTO lro_vpl VALUES ("JD1_16","095_1_16","JUD","1","16","16","Ngwüjï ngwee ngwäbïngïnü giyenenanu aar ke yiꞌrinya. Ngwugwuju amiꞌrang gwanni gwuki gwudi yigor yegen ꞌdogo. Ngwati piyi yigoꞌro yegen aar mamiꞌri ngwüjänü ngwujaꞌri ngwe aar gu mbojaji. ");
INSERT INTO lro_vpl VALUES ("JD1_17","095_1_17","JUD","1","17","17","A be lani ngwumaad ngwüny, diwayinar ngwujaꞌri ngwanni ngwondaja ngwe ngwooꞌra ngwükäjäär je ngwudi Deleny dege dani Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("JD1_18","095_1_18","JUD","1","18","18","Lica je ndi ari, “Gaji gidi gwodaning ga ji gila ngwüjï ngwa ji ngwanni ngwa ru ngwüꞌdüꞌdïnyä ngwa gwuji amiꞌrang gwudi yigor yegen gwuki drü.” ");
INSERT INTO lro_vpl VALUES ("JD1_19","095_1_19","JUD","1","19","19","Ngwüjï ngwuru ngwee ngwanni ngwata je gäbïcï ngaa üꞌrïꞌtïdänü, ngwanni ngwati gwuji ubinganu gwudi lingeno ꞌdogo aar erne Lïgïꞌrïmä lidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("JD1_20","095_1_20","JUD","1","20","20","A be nga nga lani ngwumaad ngwüny, üdädär yigoꞌro yalu ndi ämnï Ngwaalu gwalu gwanni gwujuꞌrana ngaa otaci Ngwaalingalu yiima ye yidi Lïgïꞌrïm lanni Lijuꞌru. ");
INSERT INTO lro_vpl VALUES ("JD1_21","095_1_21","JUD","1","21","21","Ngaa arngani yigoꞌro yalu ndi ämnï Ngwaalinga ngaa dünïcï ïnäng gwudi Deleny dege dani Yicu Kirictu ndi ara je olatiyi ndi midi gwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("JD1_22","095_1_22","JUD","1","22","22","Ara je ïnä loko lanni gilo lümïmänü. ");
INSERT INTO lro_vpl VALUES ("JD1_23","095_1_23","JUD","1","23","23","Äbärär je loko gïlïgä ngaa je gïlängïdïyï. Ara je ïnä loko ngaa be arngani yigoꞌro yalu ara je yedeny eny ꞌdi ngwured ngwanni ngwuma je ngwanginu ngwegen rngïyï. ");
INSERT INTO lro_vpl VALUES ("JD1_24","095_1_24","JUD","1","24","24","Ngwaalu ngwuru ngwätï yiima ndi ara je degeꞌdaji ndi ïꞌdï nunnu aji ara je olatiyi ngwäyänü ndi näjï gwüngün lijaw nono lijayanu gwulleny. ");
INSERT INTO lro_vpl VALUES ("JD1_25","095_1_25","JUD","1","25","25","Ngwaalu ngweꞌte pu ngwuru Gilang gwege a gu näjï na yurꞌtu na yiima na yeleny yüngün ru Deleny de dege dani Yicu Kirictu ꞌtuꞌtu gaji ꞌdar gwerre na gweneno ꞌdi aar gu ele gwurꞌtal. Yiru gu.");
INSERT INTO lro_vpl VALUES ("RV1_1","096_1_1","REV","1","1","1","ꞌTäälü gwuru nggwee gwudi Yicu Kirictu gwanni gwätädï Ngwaalu ngwenggaci ngwïnädä ngwüngün yiꞌral yanni giyo gito yadi ji. A je Yicu ꞌtäcï dïnädälü düngün dani Yuwana gïꞌrr ge güngün ganni gükäjïng. ");
INSERT INTO lro_vpl VALUES ("RV1_2","096_1_2","REV","1","2","2","Yima je Yuwana inggidi ꞌdar yanni yänggädïng je. No ngwujaꞌri ngwuru ngwee ngwudi Ngwaalu aar ru inggidi gwanni gwaru gwe Yicu Kirictu. ");
INSERT INTO lro_vpl VALUES ("RV1_3","096_1_3","REV","1","3","3","Gwa aar onjaci gwanni gwa uli ngwujaꞌri ngwudi yïjïr giyee na la aar je onjaci lanni la ꞌdingini na lanni la ärrï yiꞌral yanni giyo gïyïjïränü giyee. Ndi ari gaji gima ja gito ndi yiꞌral giyee ji. ");
INSERT INTO lro_vpl VALUES ("RV1_4","096_1_4","REV","1","4","4","Ngwujaꞌri ngwee ngwïndï ꞌdünggüny äny gwani Yuwana, ngwükäcï nje ngwïkïrïjïnä giyiꞌdoonga kwoꞌra täꞌrïl (7) yidi ngwaalu ngwani Ajiya. Ara je gu yïmïꞌrü na adatalu gwudi Ngwaalu ji nginde gwanni nggwo na gwanni gwuju na gwanni gwa ji gwila. Na ngwügïꞌrïm kwoꞌra täꞌrïl (7) ngwanni ngwo ngwüdünäcä diduꞌralu düngün didi yeleny ");
INSERT INTO lro_vpl VALUES ("RV1_5","096_1_5","REV","1","5","5","na ndi Yicu Kirictu gwanni gwinggidu ligor leꞌte pu gwanni gwuru giꞌra ndi ꞌdïꞌrï giyiꞌranyanu gwuru deleny didi ngwelenyinga ngwudi dïyängälü. Nginde gwanni gwati nje ämnï a gwuminje üꞌrälü ndi ke gwege yïn ye yüngün, ");
INSERT INTO lro_vpl VALUES ("RV1_6","096_1_6","REV","1","6","6","gwuminje ruji yeleny na ngwurꞌdal nunnu ar äpïjï Ngwaalinga yiiru ngwuru Papa gwüngün. Gwuru näjï ngwuru yiima yidi gwurꞌtaling. Yiru gu. ");
INSERT INTO lro_vpl VALUES ("RV1_7","096_1_7","REV","1","7","7","Geꞌtar ngwäyälü! Ndi ari Yicu nggwo gwadi ꞌtädälü gïyïbäꞌrälä, a gwa ngwüjï ꞌdar engga, ꞌdi ꞌto ngwüjï ngwanni ngwudugu giiri ge, na ngwüjï ꞌdar gïdïyängälü ngwa runi gwani nginde. No ya gu ru! Yiru gu. ");
INSERT INTO lro_vpl VALUES ("RV1_8","096_1_8","REV","1","8","8","Deleny diru Ngwaalu daru nu, “Äny gwuru gwanni gwuru giꞌra nyi ru gwanni gwuru gora. Nginde gwuru gwanni nggwo na gwanni gwuju na gwanni gwa ji gwila, nginde gwanni gwuru yiima giyiꞌral ꞌdar.” ");
INSERT INTO lro_vpl VALUES ("RV1_9","096_1_9","REV","1","9","9","Äny gwuru diweengga dalu dani Yuwana gwacajida le gïdïrbänü ngaa le acajidi giyelenyanu na ndi määtä yiguri na orꞌtemaji gwani Yicu. Äny gwuju ngwaalu giyaanu ngwani Bitumij ndi ondaci ngwüjü ngwujaꞌri ngwudi Ngwaalu nyi inggidi Yicu gwe. ");
INSERT INTO lro_vpl VALUES ("RV1_10","096_1_10","REV","1","10","10","Komon gidi Deleny, a nyi Lïgïꞌrïm lidi Ngwaalu aw nono nyi ꞌdingini giluꞌranu dula dipa gärnänü nono yal yidi giil, ");
INSERT INTO lro_vpl VALUES ("RV1_11","096_1_11","REV","1","11","11","aar nyi ci, “Yanni yänggädä je, ullu je kitabanu nga je ükäcï yiꞌdonga giyee kwoꞌra täꞌrïl (7), Abijuj, Jämïrnä, Bargamuj, Tiyatira, Jarduj, Bïlädïlïbïyä na Lädükïyä.” ");
INSERT INTO lro_vpl VALUES ("RV1_12","096_1_12","REV","1","12","12","Nyi be gwurlalu ndi ombaji nyi engga yärü gwuru gwondaciny. Anni miny gwurlalu nyi engga yudina yidi ngwamba kwoꞌra täꞌrïl yiru dab ");
INSERT INTO lro_vpl VALUES ("RV1_13","096_1_13","REV","1","13","13","gidiliganu didi yudin nyi gu engga dïjü diju gu diru “nono gïjï gidi dïjï dümnä.” Digenna direda dola düllälü ꞌdi ngwobani giyoralu yüngün nyi engga lägüwä liru dab lïmïlïdïnä konggemala güngün. ");
INSERT INTO lro_vpl VALUES ("RV1_14","096_1_14","REV","1","14","14","Ngwäꞌrü kiꞌra güngün ngwuru nono ngwola ngwubidu aar bidi nono ngwäbïꞌrä. Na ngwäy ngwüngün ngwïtänü nger nger nono lïgä. ");
INSERT INTO lro_vpl VALUES ("RV1_15","096_1_15","REV","1","15","15","Ngwari yora yüngün nggäm nggäm nono buta gwügwällär lïgä le na yal yüngün ari nono yaw yonyadu yüllü därä. ");
INSERT INTO lro_vpl VALUES ("RV1_16","096_1_16","REV","1","16","16","Gwümäätädï yuurrumu kwoꞌra täꞌrïl (7) gaama ge güngün a galal ꞌtüdä ngwulemanu ngwüngün gätï yïnï giyimere ꞌdün. Ngwuru ngwäyänü ngwüngün nono lingen lïtänü. ");
INSERT INTO lro_vpl VALUES ("RV1_17","096_1_17","REV","1","17","17","Anni miny engga nyi ïꞌdï giyoranu yüngün nono dïjï dayu. Aar nyi gu geꞌte guyala güngün giru gaama ngwari, “Aaꞌti yedeny ya ang eny. Äny gwuru gwanni gwuru giꞌra nyi ru gwanni gwuru gora. ");
INSERT INTO lro_vpl VALUES ("RV1_18","096_1_18","REV","1","18","18","Äny gwuru gwanni gwumidu, äny gwayu gwele a be gweneno äny nggwo gwumidu miding gwudi gwurꞌtaling. Na äny gwuru gwümätï mubita gwudi längïr lidi yiꞌrany na del didi yiꞌrany. ");
INSERT INTO lro_vpl VALUES ("RV1_19","096_1_19","REV","1","19","19","Yäy gu no, yanni yänggädä je ulla je, yanni giyo gweneno na yanni ya ji gweere. ");
INSERT INTO lro_vpl VALUES ("RV1_20","096_1_20","REV","1","20","20","Yujimidi yidi yuurrum kwoꞌra täꞌrïl (7) yanni yänggädä je kaama güny na yudin yiru dab yidi ngwamba kwoꞌra täꞌrïl yani no, yuurrum kwoꞌra täꞌrïl (7) yani ngwooꞌra ngwudi yiꞌdoonga yidi Ngwaalu kwoꞌra täꞌrïl (7), na yudin yiru dab yidi ngwamba kwoꞌra täꞌrïl (7) yani yiꞌdoonga yidi Ngwaalu kwoꞌra täꞌrïl (7).” ");
INSERT INTO lro_vpl VALUES ("RV2_1","096_2_1","REV","2","1","1","Üllïjä doꞌra didi giꞌdoonga gidi Abijujing. Ngwujaꞌri ngwee, nginde gwuru gwükäjä je gwanni gwümäätädï yuurrumu kwoꞌra täꞌrïl gaama ge güngün gwanni gwelellalu giyudinanu kwoꞌra täꞌrïl yidi ngwamba yiru dab. ");
INSERT INTO lro_vpl VALUES ("RV2_2","096_2_2","REV","2","2","2","Äny gwülïngïdï yiiru yunga nyi lenge unding ngwäy gwunga na orꞌtemajing gwunga. Na äny gwülïngïdängä ndi ari yanni yiki yati ang ke ngwäy na ndi ari nga gwüdïdïmä ngindeng je lanni laru liru ngwooꞌra ngwükäjäär je aar gu be ꞌti rüdï, lïmbüjïnä ndi ari liru ngwuꞌduru. ");
INSERT INTO lro_vpl VALUES ("RV2_3","096_2_3","REV","2","3","3","Nga gwuma orꞌtemaji gïdïrbänü gwani ngwürïny ngwüny nga ꞌti gakidu. ");
INSERT INTO lro_vpl VALUES ("RV2_4","096_2_4","REV","2","4","4","A be yätï nje giyee ꞌdunggunga, ndi ari nga gwuma gatani ämnïng gwunga gwele gwätängä gwerre. ");
INSERT INTO lro_vpl VALUES ("RV2_5","096_2_5","REV","2","5","5","Diwayina be ngwaalinga ngwanni ngwuma gu ïꞌdï nga joꞌrenyana nga je ärrï yanni yärrä je gwele gwerre. Ma ang ꞌti joꞌrenyana, nggwa ila ꞌdunggunga nggwäbrï gudina gidi lamba lunga ngwaalu ngwüngün. ");
INSERT INTO lro_vpl VALUES ("RV2_6","096_2_6","REV","2","6","6","A be yätä je giyee, apepe gwudi Nekolanga gwukanga ngwäy gwanni ngwukiny ngwäy ꞌto. ");
INSERT INTO lro_vpl VALUES ("RV2_7","096_2_7","REV","2","7","7","Gwanni gwätï länï, ngwuꞌdingini ngwujaꞌri ngwee ngwuca ngwe Lïgïꞌrïm yiꞌdonga yidi Ngwaalu. Gwanni gwa dami, gwätï gu ndi nyi ätä ngweny gidaꞌri didi midi danni ndo gidaartanu didi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("RV2_8","096_2_8","REV","2","8","8","Üllïjä doꞌra didi giꞌdoonga gidi Jämïrnäng. Ngwujaꞌri ngwee nginde gwuru gwükäjä je gwanni gwuru giꞌra ngwuru gwanni gwuru gora, gwanni gwayu gwerre gwuma be oꞌra gwumidu. ");
INSERT INTO lro_vpl VALUES ("RV2_9","096_2_9","REV","2","9","9","Äny gwülïngïdï dïrbä dunga nyi lenge yiwaya yunga a be yanni yiru ꞌdidanu nga gwünänü. Yïlïngïdï nje yanni yati aar je üꞌrïdä nono ngindenga lanni lari liru Ngwüyäwüd aar gu ꞌti be rüdï, aar be ru ngwämrä ngwudi dijegoꞌrr. ");
INSERT INTO lro_vpl VALUES ("RV2_10","096_2_10","REV","2","10","10","Aaꞌti yedeny ya ang eny giyiꞌrendeny yanni giyo yadi ang mbuji. Nggwa ang ondaci ndi ari dijegoꞌrr da je gatu loko korkon ara je dïdïmänü, na la je übïnälü ngaa la ji gïdïrbänü yomon ꞌdï (10). Mätï ligor, ꞌdi ma aar ani yiꞌrany, nggwa ang be giki gukuna gidi midi. ");
INSERT INTO lro_vpl VALUES ("RV2_11","096_2_11","REV","2","11","11","Nginde gwanni gwätï länï ngwuꞌdingini ngwujaꞌri ngwanni ngwuca ngwe Lïgïꞌrïm yiꞌdonga yidi Ngwaalu. Gwanni gwa dami, gwaꞌti gwa yiꞌrany yidi gwodaning akani nono. ");
INSERT INTO lro_vpl VALUES ("RV2_12","096_2_12","REV","2","12","12","Üllïjä doꞌra didi giꞌdoonga gidi Bargamujing, ngwujaꞌri ngwee nginde gwuru gwükäjä je gwanni gwätï galala gätï yïnï giyimere ꞌdün. ");
INSERT INTO lro_vpl VALUES ("RV2_13","096_2_13","REV","2","13","13","Äny gwülïngïdä gwe ngwaalinga ngwata gu ji, ngwaalu ngwanni ngwätï gu dijegoꞌrr diduꞌri düngün didi yeleny. A be nga gwümätïnälü ꞌdidanu ngwürïny ngwüny. Nga gwaꞌti nyïꞌrïnä ämnïng Ngwaalu gwunga ꞌdünggüny ꞌdi kaji gidi Andibaj, gwanni gwinggidiny gwe ligor leꞌte pu gwanni gwuma aar ꞌrinye kündär galu ngwaalu ngwati gu dijegoꞌrr ji. ");
INSERT INTO lro_vpl VALUES ("RV2_14","096_2_14","REV","2","14","14","A be yätï nje giyee yoko ꞌdunggunga, nga gwätï ngwüjü ngeno ngwanni ngwugwuja ngwujaꞌri ngwudi Balam, gwanni gwenggaci Balaging ndi gïꞌrïcï ngwüjü ngwudi Yïjïräyïl ngwuje iye ngwony ngwudi mïꞌrïnï nono gwudi dïdülä aar ärrï yiꞌral yiki aar arri yïjïnä. ");
INSERT INTO lro_vpl VALUES ("RV2_15","096_2_15","REV","2","15","15","Nga ätï ꞌto ngwüjü ngwugwuja ngwujaꞌri ngwudi Nekolanga. ");
INSERT INTO lro_vpl VALUES ("RV2_16","096_2_16","REV","2","16","16","Yäy gu no, joꞌrenyana. Ma ang ꞌti joꞌrenyana, äny gwa ila puprang ꞌdunggunga linyii le dugidi galal ge gidi ngwulem ngwüny. ");
INSERT INTO lro_vpl VALUES ("RV2_17","096_2_17","REV","2","17","17","Gwanni gwätï länï ngwuꞌdingini ngwujaꞌri ngwee ngwuca ngwe Lïgïꞌrïm yiꞌdonga yidi Ngwaalu. Gwanni gwa dami gwuny ätädä män gwoko gwanni gwändälü. Nyi ätädä ꞌto düꞌrïmünä dibidu düllünä gu ngwürïny ngwuyang ngwulinginna ꞌdogo gïdïjï danni dadi ape. ");
INSERT INTO lro_vpl VALUES ("RV2_18","096_2_18","REV","2","18","18","Üllïjä doꞌra didi giꞌdoonga gidi Tiyatirang, ngwujaꞌri ngwee nginde gwuru gwükäjä je gwanni gwuru Gïjï gidi Ngwaalu ngwäy ngwüngün ngwanni ngwïtänü nono lïgä a yora yüngün ru buta gwujuꞌru. ");
INSERT INTO lro_vpl VALUES ("RV2_19","096_2_19","REV","2","19","19","Äny gwülïngïdï apepeng gwunga nyi lenge ämnïng gwunga, nyi lenge ämnïng Ngwaalu gwunga na yiiru yunga na orꞌtemajing gwunga. Na ndi ari yiiru yunga yidi gwodaning yonyadana giyiiru yidi gwerreng. ");
INSERT INTO lro_vpl VALUES ("RV2_20","096_2_20","REV","2","20","20","A be yätï nje giyee ꞌdunggunga, ndi ari ngaa lati gätïjï dayu ligoralu dani Yijabil danni daru diru dïjïr. Dati raji ngwïnädä ngwüny ꞌter ngwujaꞌri ngwe ngwüngün aar ru ngwïjïn aar eny ngwony ngwudi mïꞌrïnï nono gwudi dïdülälü. ");
INSERT INTO lro_vpl VALUES ("RV2_21","096_2_21","REV","2","21","21","Dätädïny yomon nunnu ngwujoꞌrenyana gïyïjïn yüngün ngwube ꞌdonya ndi joꞌrenyana. ");
INSERT INTO lro_vpl VALUES ("RV2_22","096_2_22","REV","2","22","22","No, diny gatu ngwümbür ngwudi dïrbä da ümï na lanni lïmïꞌrïdäär le ngwäyänü, linje le gatu gïdïrbänü dipa, manari lima ꞌti joꞌrenyana ndi acajidi ndi apepe gwüngün. ");
INSERT INTO lro_vpl VALUES ("RV2_23","096_2_23","REV","2","23","23","Nggwa mïꞌrï yïjü yüngün yiꞌrany ye. Yiꞌdoonga ꞌdar yidi Ngwaalu ya be lenge ndi ari äny gwuru gwanni gwati ombaji yigoranu nyi ombaji yaꞌranyanu yidi dïjï na nggwa je gwäꞌräcänü gwani apepe gwalu. ");
INSERT INTO lro_vpl VALUES ("RV2_24","096_2_24","REV","2","24","24","A be gwenene nggwa je ci loko lanni gilo lijalu Tiyatira, nga nga lanni liꞌdonya ngwujaꞌri ngwudi daw ndee ngaa lanni lima ꞌti ämnä ngwujaꞌri ngwaru ngwe ngwuru yujimidi yidi dijegoꞌrr yojema, nggwa je ci nu nggwäꞌtüdï gwada je üpïyï üpïnïng gwuꞌter, ");
INSERT INTO lro_vpl VALUES ("RV2_25","096_2_25","REV","2","25","25","mätïnädär gu ꞌdogo giyoo yätä je ꞌdi nyi oꞌra. ");
INSERT INTO lro_vpl VALUES ("RV2_26","096_2_26","REV","2","26","26","Nginde gwanni gwa dami ngwugwuji ndi ärrï buping gwüny ꞌdi ngwumedaji, gwunyi ätädä yelenya ngwuruyi ngwüjü giyen. ");
INSERT INTO lro_vpl VALUES ("RV2_27","096_2_27","REV","2","27","27","Ngwuje ruyi yelenya guura ge giru laaba, ngwuje pänü nono ma pï gimoyanu giru gilu. Nono ape nyi gu yelenya ndi Papa gwüny. ");
INSERT INTO lro_vpl VALUES ("RV2_28","096_2_28","REV","2","28","28","Gwunyi ätädä ꞌto guurrumu gidi gïtänyïng. ");
INSERT INTO lro_vpl VALUES ("RV2_29","096_2_29","REV","2","29","29","Nginde gwanni gwätï länï, ngwuꞌdingini ngwujaꞌri ngwee ngwuca ngwe Lïgïꞌrïm yiꞌdonga yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("RV3_1","096_3_1","REV","3","1","1","Üllïjä doꞌra didi giꞌdoonga gidi Jardujing, ngwujaꞌri ngwee nginde gwuru gwükäjä je gwanni gwümätï ngwügïꞌrïmä kwoꞌra täꞌrïl (7) ngwudi Ngwaalu na yuurrum kwoꞌra täꞌrïl (7). Äny gwülïngïdï yiiru yunga. Nga gwumidu ngwürïny ngwe a be ꞌdidanu nga gwayu. ");
INSERT INTO lro_vpl VALUES ("RV3_2","096_3_2","REV","3","2","2","ꞌRita nga je burnani nga je gägïräjï yunga giyoo yadi ayi, ndi ari äny gwumbuju yiiru yunga yaꞌti mbutu ngwäyänü Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("RV3_3","096_3_3","REV","3","3","3","Diwayina ndi ari awa nga gwuꞌdingina ngwujaꞌri awa nga je määtä nga je ꞌdengenaja nga joꞌrenyana. Manari nga gwuma ꞌti ꞌritu, nggwa ila nono gwele duꞌramu gaji ganni gaꞌti ga ang lenge. ");
INSERT INTO lro_vpl VALUES ("RV3_4","096_3_4","REV","3","4","4","A be lätä je loko Jarduj laꞌti rngïyä ngwureda nono ngwegen ke gwe, ngindenga liny le ele ligenna ngwureda ngwubidu ndi ari lädï gu. ");
INSERT INTO lro_vpl VALUES ("RV3_5","096_3_5","REV","3","5","5","Gwanni gwa dami gwa genne ngwureda ngwubidu nono ngindeng je a gwa ꞌti gwunyi brota ngwürïnyälü ngwüngün mbüny kitabanu gidi midi, a be gwunyi gwe inggidi ngwäyänü ngwudi Papa gwüny na yïꞌrr yüngün. ");
INSERT INTO lro_vpl VALUES ("RV3_6","096_3_6","REV","3","6","6","Gwanni gwätï länï, ngwuꞌdingini ngwujaꞌri ngwee ngwuca ngwe Lïgïꞌrïm giyiꞌdonga yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("RV3_7","096_3_7","REV","3","7","7","Üllïjä doꞌra didi giꞌdoonga gidi Bïlädïlïbïyäng, ngwujaꞌri ngwee ngwudi Nginde gwuru gwanni Gwujuꞌru, Nginde gwanni gwuru ꞌDidanu, gwanni gwätï mubita gwudi Däwüd, mung ïgïtälü aaꞌti dïjï längïtä, mung längïtï aaꞌti dïjï ïgïtädälü. ");
INSERT INTO lro_vpl VALUES ("RV3_8","096_3_8","REV","3","8","8","Äny gwülïngïdï yiiru yunga ndi ari nga gwätï yiima yooko a be nga gwuma ꞌdingini ngwujaꞌri ngwüny nga je määtädä. Nga ꞌti nyïꞌrïnä ngwürïny ngwüny. Yäy gu no, nggwuma ang ïgïtïjï längïrü dïjï dere daꞌti da längïtï. ");
INSERT INTO lro_vpl VALUES ("RV3_9","096_3_9","REV","3","9","9","A be lanni lïjädï ngwämrä ngwudi dijegoꞌrr, lanni laru liru Ngwüyäwüd aar be ru ngwuꞌduru, linje gäbïcï lila la ang kwucalu yirku ye giyoranu yunga aar lenge ndi ari nggwämnängä. ");
INSERT INTO lro_vpl VALUES ("RV3_10","096_3_10","REV","3","10","10","Na ndi ari nga gwümätï ngwujaꞌri ngwüny nga orꞌtemaji, äny nggwa gu etadi ꞌto kaji gidi mïmïnï nono ganni gadi ila gïdïdlä ndi mïmïnï ngwüjü nono gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("RV3_11","096_3_11","REV","3","11","11","Äny nggwo gito gwadi ila puprang, mätïnälü ngwujaꞌri ngwoo ngwätä je nunnu aaꞌti la ang apada gukuna gunga. ");
INSERT INTO lro_vpl VALUES ("RV3_12","096_3_12","REV","3","12","12","Gwanni gwa dami, gwunyi ruji gidingo ngwuꞌdun ngwudi Ngwaalu nggu ji ngene gwurꞌtal gwunyi gu ulli ngwürïny ngwudi Ngwaalu ngwüny na ngwürïny ngwudi gündär gidi Ngwaalu ngwüny, Üräjälïm gwanni gwuyang gwüllü kerala Ngwaalu ngwüny, na gwunyi gu ulli ꞌto ngwürïny ngwüny ngwanni ngwuyang. ");
INSERT INTO lro_vpl VALUES ("RV3_13","096_3_13","REV","3","13","13","Gwanni gwätï länï, ngwuꞌdingini ngwujaꞌri ngwee ngwuca ngwe Lïgïꞌrïm yiꞌdonga yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("RV3_14","096_3_14","REV","3","14","14","Üllïjä doꞌra didi giꞌdoonga gidi Lädükïyäng, ngwujaꞌri ngwee nginde gwuru gwükäjï je gwanni gwani Yiru gu gwanni gwinggidu gwuru ligor leꞌte pu ngwuru ꞌdidanu, gwanni gwuru gora gidi yiꞌral ꞌdar yanni yïgïꞌtïnä. ");
INSERT INTO lro_vpl VALUES ("RV3_15","096_3_15","REV","3","15","15","Äny gwülïngïdï yiiru yunga na ndi ari nga gwaꞌti jïlü nga ꞌti büdü. Nggwüjädï ndi ari aadi ang jïlï na aadi ang büdï. ");
INSERT INTO lro_vpl VALUES ("RV3_16","096_3_16","REV","3","16","16","Nga be jalu cagiꞌrim nga ꞌti büdü nga ꞌti jïlü, äny gwa ang gwonynyalu mbüny ngwulemanu ngwüny. ");
INSERT INTO lro_vpl VALUES ("RV3_17","096_3_17","REV","3","17","17","Nga gwati ari, “Äny gwünänü, äny gwuma bile yelenya, äny gwaꞌti bupa yiꞌral yere.” A be nga gwaꞌti lïngïdï ndi ari nga gwaꞌti ätï jayinganu, nga gwangiꞌru ngwäy, nga ru diwayi, nga rïmï ngwäy, nga gwïndälü ngwanginu ngwanu. ");
INSERT INTO lro_vpl VALUES ("RV3_18","096_3_18","REV","3","18","18","Äny gwa ang ola ndi ari nyi ella dab dïjüꞌrïnä lïgä le nunnu nga nänü ꞌdidanu, nyi ella ngwureda ngwubidu nga je genne ang ngwe gwüꞌrübänï yaaralu yidi ngwanginu ngwunga, nyi ella düngänä nga de gwällïnï ngwäyänü nunnu nga ombajidalu. ");
INSERT INTO lro_vpl VALUES ("RV3_19","096_3_19","REV","3","19","19","Äny gwati rime nyi reraji ngindeng gwanni gwati nyi ämnï. Büdä be nono nga joꞌrenyana. ");
INSERT INTO lro_vpl VALUES ("RV3_20","096_3_20","REV","3","20","20","ꞌDingina, äny nggwo gwüdünü gïlängïr nyi pï dïmbürä, ma dïjï dere ꞌdingina yal yüny ngwïgïtä, äny gwa änï diiny de eny diiny de ji. ");
INSERT INTO lro_vpl VALUES ("RV3_21","096_3_21","REV","3","21","21","Gwanni gwa dami gwunyi ätädä yelenya nyii gwe jalu ngwuduꞌrala ngwudi yeleny ngwüny, anaku dami nyi gu äny, nyii jalu Papa gwe gwüny ngwuduꞌrala ngwudi yeleny ngwüngün. ");
INSERT INTO lro_vpl VALUES ("RV3_22","096_3_22","REV","3","22","22","Gwanni gwätï länï, ngwuꞌdingini ngwujaꞌri ngwee ngwuca ngwe Lïgïꞌrïm yiꞌdonga yidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("RV4_1","096_4_1","REV","4","1","1","Anni ma yiꞌral giyee ele, nyi ombajidalu nyi engga längïrü lijalu mbüny kerala. A dulu dele durnidiny gwerre dipa gärnänü nono yal yidi giil, nyi ꞌdingini aar nyi ca nu, “Anda ngene nga enggaci yiꞌral yanni yaji ya ji gweere.” ");
INSERT INTO lro_vpl VALUES ("RV4_2","096_4_2","REV","4","2","2","A puprang no, aar nyi Lïgïꞌrïm aw nono, nyi engga diduꞌri didi yeleny kerala diju gu dïjälä deꞌte. ");
INSERT INTO lro_vpl VALUES ("RV4_3","096_4_3","REV","4","3","3","Nginde gwanni gwujalu ngenone gwuru nono goꞌrra giru guꞌru guuranu ngwïgïnyänü ngwuru nono goꞌrra giru guꞌru guri. A dulili diru nono nyadbay gwïgïnyä üꞌrü diduꞌralu didi yeleny guꞌriguꞌtu. ");
INSERT INTO lro_vpl VALUES ("RV4_4","096_4_4","REV","4","4","4","A ngwuduꞌri ngwudi yeleny küüꞌrï na kwoꞌrongo (24) ännï diduꞌranu didi yeleny ndoo, a gu mbumbunga jala liru küüꞌrï na kwoꞌrongo (24) ligenna ngwureda ngwubidu aar genne yukuna yidi yeleny yiru dab giyiꞌrala yegen. ");
INSERT INTO lro_vpl VALUES ("RV4_5","096_4_5","REV","4","5","5","Ati diduꞌri didi yeleny ndoo enyanu ngïꞌräm ngïꞌräm, a gu dulu ꞌtüdä, ating mïꞌrïnänü nono gwele gere. Ngwäyänü ngwudi diduꞌri didi yeleny, a gu ngwamba kwoꞌra täꞌrïl (7) dünä ngwuꞌdu lïgä, ngwani ngwügïꞌrïm kwoꞌra täꞌrïl (7) ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("RV4_6","096_4_6","REV","4","6","6","Na ꞌto ngwäyänü ngwudi diduꞌri didi yeleny a gong ji giru nono yaw yiru ngwäyänü gijaja, yijuꞌru ngwäyänü nono daginya. Gidiliganu, diduꞌri nono didi yeleny, a gu ngwong kwoꞌrongo (4) ngwumidu ji ngwonyadu ngwäyänü gweere na gwodan. ");
INSERT INTO lro_vpl VALUES ("RV4_7","096_4_7","REV","4","7","7","Gong ganni giru giꞌra giru nono dira na ganni gigwujanalu giru nono gïndrï na ganni giru giꞌra täꞌrïl, giru ngwäyänü nono dïjï dümnä na ganni gïndälü gwodan giru nono gïꞌrä giru dïïyü gïꞌdïꞌrü. ");
INSERT INTO lro_vpl VALUES ("RV4_8","096_4_8","REV","4","8","8","Ngwong ngwee kwoꞌrongo (4), geꞌte geꞌte gätï ngwubung nyärläl (6) ngwubu gu ngwäy nono ꞌdar, ꞌdi ar ubi nono ngïnäꞌdänü ngwubunganu. Aar ꞌti dünädï dilu de na lingen ndi ari, “Juꞌri, Juꞌri, Juꞌri, Deleny diru Ngwaalu diru yiima, gwanni gwuju na gwanni nggwo na gwadi ila.” ");
INSERT INTO lro_vpl VALUES ("RV4_9","096_4_9","REV","4","9","9","Ma ngwong ngwee ngwumidu näjï ngindeng gwanni gwujalu gididuꞌrala didi yeleny gwanni gwumidu gwurꞌtal, aar ortada, aar ci yäy ꞌtu, ");
INSERT INTO lro_vpl VALUES ("RV4_10","096_4_10","REV","4","10","10","ati mbumbunga giloo liru küüꞌrï na kwoꞌrongo kwucalu yirku ye gwujalu gididuꞌrala didi yeleny gwanni gwumidu gwurꞌtal ati aar gïꞌtïjï yukunalu yidi yeleny diduꞌri nono didi yeleny ati aar ci, ");
INSERT INTO lro_vpl VALUES ("RV4_11","096_4_11","REV","4","11","11","“Gwani Deleny diru Ngwaalu ngwärï a gwädï gu ndi aar ang näjï, aar ang denya aar ang gwäꞌräcï yiima, ndi ari nga gwuru gwugeꞌta yiꞌralalu ꞌdar, a bupi gwe gwunga, yïgïꞌtïnä aar ji yimidu.” ");
INSERT INTO lro_vpl VALUES ("RV5_1","096_5_1","REV","5","1","1","Nyi be engga kaama gidi nginde gwanni gwujalu gididuꞌrala didi yeleny gitab güllïnä gu ngwujaꞌri giluꞌru na gilari aar mïꞌrä ngwulge ngwe kwoꞌra täꞌrïl (7). ");
INSERT INTO lro_vpl VALUES ("RV5_2","096_5_2","REV","5","2","2","Na nyi engga gïꞌrrä gätï yelenya yipa ngwurnida dula gwulleny ngwari, “Yärü gwuru gwädï gu ndi kiyi dilge ngwïgïtä gitabalu mbüny?” ");
INSERT INTO lro_vpl VALUES ("RV5_3","096_5_3","REV","5","3","3","Aaꞌti dïjï dere ju kerala na gïdïyängälü na gïdïyängänü ndi ïgïtï gitabalu na ꞌdi nding ombajanu. ");
INSERT INTO lro_vpl VALUES ("RV5_4","096_5_4","REV","5","4","4","Nyi ari gwulleny ndi ari dïjï daꞌti ju dädï gu ndi ïgïtï gitab ngwombajanu. ");
INSERT INTO lro_vpl VALUES ("RV5_5","096_5_5","REV","5","5","5","A nyi be mbumbu gweꞌte ndi mbumbunga giloo ci, “Nga ꞌti aru! Geꞌta ngwäyälü, Dira danni dïꞌtüdï kïïlü gidi Yäwüdä, dïgüürnä didi Däwüd dima dami, diru da burni ndi kiyi ngwulge ngwee kwoꞌra täꞌrïl (7) ngwïgïtä gitabalu.” ");
INSERT INTO lro_vpl VALUES ("RV5_6","096_5_6","REV","5","6","6","Nyi be engga Giranyu gïdünädälä gidiliganu didi diduꞌri didi yeleny ngwuru nono ma aar üꞌrü ngwulem, gänü ngwonganu ngwoo kwoꞌrongo (4) ngwumidu na mbumbunga giloo. Gätï ngwiil kwoꞌra täꞌrïl (7), ngwätï ꞌto ngwäy kwoꞌra täꞌrïl (7) ngwani ngwügïꞌrïm kwoꞌra täꞌrïl (7) ngwudi Ngwaalu ngwanni ngwükäjïng je gïdïdlä ku. ");
INSERT INTO lro_vpl VALUES ("RV5_7","096_5_7","REV","5","7","7","Ngwube ꞌdongga ngwape gitab kuy gidi gaama gidi nginde nggwoo gwujalu gididuꞌrala didi yeleny. ");
INSERT INTO lro_vpl VALUES ("RV5_8","096_5_8","REV","5","8","8","Anni mung ape, a ngwong ngwoo kwoꞌrongo (4) ngwumidu na mbumbunga giloo liru küüꞌrï na kwoꞌrongo (24) adaci Giranyalu nggoo yirku ye. A dïjï deꞌte deꞌte ꞌdenggenanu ꞌdar dapu dümbärä aar määtädä yïndängälä yiru dab yonyadu yilunala yani otaci Ngwaalingalu gwudi ngwüjü ngwanni ngwujuꞌru. ");
INSERT INTO lro_vpl VALUES ("RV5_9","096_5_9","REV","5","9","9","Aar elnge delnga diyang aar ari, “Nga gwädï gu ndi ape gitab nga ïgïtï dilge düngün, ndi ari nga gwüꞌrïdïnä ngwulem, a yïn ye yunga, nga gwuma üꞌrïdäcï Ngwaalinga ngwüjälü gïyïïlü ꞌdar na ngwungla ꞌdar na ngwüjï giyen ꞌdar. ");
INSERT INTO lro_vpl VALUES ("RV5_10","096_5_10","REV","5","10","10","Nga je ruji yeleny na ngwurꞌdal ndi äpïjï Ngwaalinga ngwege yiiru, na ngwa ape yelenya gïdïyängälü.” ");
INSERT INTO lro_vpl VALUES ("RV5_11","096_5_11","REV","5","11","11","Nyi be ombajidalu nyi ꞌdingini yal yidi yïꞌrr yonyadu yiꞌranu ngwüüꞌrï na ngwüüꞌrï na ngwüüꞌrï ꞌdï yomonanu ngwüüꞌrï ꞌdï, aar rekaji diduꞌralu didi yeleny na ngwong ngwoo ngwumidu na mbumbunga. ");
INSERT INTO lro_vpl VALUES ("RV5_12","096_5_12","REV","5","12","12","Ati aar elngala gwulleny aar ari, “Girany gädï gu ganni gima aar üꞌrü ngwulem, ndi ape yelenya na yurꞌtu na yibegeng na yiima na denya na näjï na orta.” ");
INSERT INTO lro_vpl VALUES ("RV5_13","096_5_13","REV","5","13","13","Nyi be ꞌdingini ngwony ꞌdar kerala na gïdïyängälü na gïdïyängänü na giyaanu na ngwong ꞌdar ngwanni ngwuju gwanu aar opepala aar ari, “Nginde gwanni gwujalu gididuꞌrala didi yeleny na Girany aar je ortada aar je denya na aar je näjï aar je ruji yiima, gwurꞌtal na gwurꞌtal.” ");
INSERT INTO lro_vpl VALUES ("RV5_14","096_5_14","REV","5","14","14","A ngwong ngwoo kwoꞌrongo (4) ngwumidu ari, “Yiru gu,” na mbumbunga kwucalu yirku ye aar äpïjï yobo. ");
INSERT INTO lro_vpl VALUES ("RV6_1","096_6_1","REV","6","1","1","Nyi geꞌte ngwäyälü nyi engga Giranyu nggoo ngwïgïtï dilge didi gwerre gwerreng ngwulge ngwoo ngwuru kwoꞌra täꞌrïl. Nyi ꞌdingini gony geꞌte ngwonganu ngwoo ngwuru kwoꞌrongo ngwumidu ngwondaji dulu de dipa gärnänü nono gere gïmïꞌrïnänü ngwari, “Ila!” ");
INSERT INTO lro_vpl VALUES ("RV6_2","096_6_2","REV","6","2","2","Nyi ombajidalu nyi engga dimirta dibidu yiꞌremna kiꞌra gwere ꞌdünggüny, gwanni gwändï gwälä gwapu gwuꞌrijal, aar ätädä gukuna gidi yeleny ngwüꞌtü dimirta de ndi dugidi gïyäärä yonyadu ngwudami. ");
INSERT INTO lro_vpl VALUES ("RV6_3","096_6_3","REV","6","3","3","Anni ma Girany oꞌre ngwïgïtï dilge ndoo didi gwodaning, nyi ꞌdingini gony nggoo gimidu gidi gwodaning ngwari, “Ila.” ");
INSERT INTO lro_vpl VALUES ("RV6_4","096_6_4","REV","6","4","4","A be dimirta ꞌtüdä giꞌra rom (2) diꞌter, duri yiꞌremna. Gwanni gwändï gwälä gwätädäär yelenya ngwäbrï adatingalu gïdïyängälü nunnu ngwügäbïcï ngwüjü aar dugidi aar ayi. Aar ätädä galala gipa. ");
INSERT INTO lro_vpl VALUES ("RV6_5","096_6_5","REV","6","5","5","Anni ma Girany ïgïtï dilge ndoo diru giꞌra täꞌrïl, nyi ꞌdingini gony nggoo gimidu giru giꞌra täꞌrïl ngwari, “Ila.” Nyi ombajidalu nyi engga dimirta dümnä yiꞌremna kiꞌra gweere ꞌdünggüny. Gwanni gwändï gwälä gwapu mijaan kuy güngün. ");
INSERT INTO lro_vpl VALUES ("RV6_6","096_6_6","REV","6","6","6","Nyi ꞌdingini dula daru nono dulu didi dïjï dümnä dïꞌtüdï gidiliganu ngwong ngwoo ngwuru yiꞌra kwoꞌrongo ngwumidu ngwari, “Guꞌru gidi ngwülä ngwudi yirende ginya geꞌte pu, giru dinar deꞌte pu na gidi ngwülä ngwudi yon yinya täꞌrïl, giru dinar deꞌte pu, a be guꞌru gidi abaar gwudi yila na diꞌrica, aaꞌti ngwa je akani nono.” ");
INSERT INTO lro_vpl VALUES ("RV6_7","096_6_7","REV","6","7","7","Anni ma Girany ïgïtï dilge ndoo diru giꞌra kwoꞌrongo, nyi ꞌdingini gony nggoo gimidu giru giꞌra kwoꞌrongo ngwari, “Ila.” ");
INSERT INTO lro_vpl VALUES ("RV6_8","096_6_8","REV","6","8","8","Nyi ombajidalu nyi engga dimirta diru dilo yiꞌremna kiꞌra gweere ꞌdünggüny, gwanni gwändï gwälä gwucaar yiꞌrany a del didi yiꞌrany gwujanalu. Aar je ätädä yelenya ndi aar äbrï dïyäng kwoꞌrongo kay geꞌte aar ꞌrinye ngwüjü galal ge, a je ngwamu ꞌrinye, a je dümdï ꞌrinye, a je ngwäng ꞌrinye ngwudi dïyängälü. ");
INSERT INTO lro_vpl VALUES ("RV6_9","096_6_9","REV","6","9","9","Anni ma Girany ïgïtï dilge ndoo diru giꞌra tudini, nyi engga giyoralu yidi dagad ngwangina ngwudi ngwüjï ngwanni ngwüꞌrïnyïtäär je gwani ngwujaꞌri ngwudi Ngwaalu na gwani inggidi gwanni gwinggidaar gwe ");
INSERT INTO lro_vpl VALUES ("RV6_10","096_6_10","REV","6","10","10","aar urnida dula de gwulleny aar ari, “Gwani Doorta danni Dijuꞌru diru ꞌdidanu, jadu gwuru gwada gwe obalu ngwüjü ngwe ngwudi dïdlä na jadu gwuru gwada gwe gwalli dämjä gwani yïn yärï?” ");
INSERT INTO lro_vpl VALUES ("RV6_11","096_6_11","REV","6","11","11","Ati aar ätä dïjü deꞌte deꞌte direda dibidu aar ondaci ndi dünï gwoko, ꞌdi aar ꞌrinyeta ngwïnädä ngwuru gimaad gegen na ngwenggen ngwegen ꞌdar ngwanni ngwuru ngwïnäd ngwudi Kirictu ngwanni ngwa je yiꞌrany mbuji nono ngindeng je. ");
INSERT INTO lro_vpl VALUES ("RV6_12","096_6_12","REV","6","12","12","Nyi ombajidalu nyi engga anni ma Girany ji ndi ïgïtï dilge ndoo diru giꞌra nyärläl, a dïyäng lagadalu gwulleny. A lingen gwurli ngwümnï ꞌtïꞌtïn nono ngwured ngwudi gïmärä a düüwä gwurli ꞌdar ngwuri nono yïnä. ");
INSERT INTO lro_vpl VALUES ("RV6_13","096_6_13","REV","6","13","13","A yuurrum miꞌriꞌtadalu gïdïyängälü kerala, nono ati gu dirun dojema nono miꞌritiyi yimnigora gidimnigorala ma dirun ärïyï. ");
INSERT INTO lro_vpl VALUES ("RV6_14","096_6_14","REV","6","14","14","A gere pänïdï nono gwele ati gu dirna pänïdï nono ngwududi a yen gwaginadalu mbüny na ngwaalu giyaanu gwaginadalu ngwaalu ngwegen. ");
INSERT INTO lro_vpl VALUES ("RV6_15","096_6_15","REV","6","15","15","A be ngweleny ngwudi dïdlä, ngwubegeng, ngwanni ngwünänü na ngwartan na ngwongor na ꞌdar lanni liru ngwïnäd na ꞌdar lïgätïnälü, aar änälü ngwubanganu na ngwurꞌdanu ngwudi yen. ");
INSERT INTO lro_vpl VALUES ("RV6_16","096_6_16","REV","6","16","16","Ati aar ci yeno na ngwurꞌda, “Ïꞌdädï nje nono nje gwüꞌrübäjälü ngwäy ngwüngün gwanni gwujalu gididuꞌrala didi yeleny na küündä gidi Girany. ");
INSERT INTO lro_vpl VALUES ("RV6_17","096_6_17","REV","6","17","17","Ndi ari gomon gipa gidi güündä gegen gima obana na yärü gwuru gwanni gwa dünï ngindeng ngwäyänü?” ");
INSERT INTO lro_vpl VALUES ("RV7_1","096_7_1","REV","7","1","1","Anni ma yiꞌral ele giyee nyi be engga yïꞌrrä kwoꞌrongo (4) yïdünädälä giyiꞌrundu kwoꞌrongo yidi dïyäng, aar dünäjï diruna didi yiꞌrundu kwoꞌrongo (4) aar ümïnïcï ndi ärïyï dïyängälü na yaw a daꞌri dere. ");
INSERT INTO lro_vpl VALUES ("RV7_2","096_7_2","REV","7","2","2","Nyi oꞌre nyi engga gïꞌrrä giꞌter mana gändï gïtäny gwe gapana guꞌrunga gidi mïꞌrä gidi Ngwaalu ngwumidu. Ngwurnida yïꞌrrä giyoo kwoꞌrongo (4) dulu de gwulleny yanni yima aar je ätädä yiima ndi ari aar akani dïyängü nono na yaw, ngwuje ci, ");
INSERT INTO lro_vpl VALUES ("RV7_3","096_7_3","REV","7","3","3","“Aaꞌti ngaa la akani dïyängü nono na yaw na ngwaꞌri ꞌdi ar mïꞌrä ngwïnädä gïyïdülälä ngwudi Ngwaalu ngwege guꞌrung ge.” ");
INSERT INTO lro_vpl VALUES ("RV7_4","096_7_4","REV","7","4","4","Nyi be ꞌdingini ngwüjü ngwanni ngwuma aar je mïꞌrä ngwudi yïïlü ꞌdar yidi Yïjïräyïl ngwuru yiꞌra ngwüüꞌrï küüꞌrï tudini na ꞌdï kwoꞌrongo na kwoꞌrongo (144,000). ");
INSERT INTO lro_vpl VALUES ("RV7_5","096_7_5","REV","7","5","5","Kïïlü gidi Yäwüdä, aar je mïꞌrä ngwüüꞌrï ꞌdï na rom (12,000), kïïlü gidi Räbïn, aar je mïꞌrä ngwüüꞌrï ꞌdï na rom (12,000), kïïlü gidi Jad, aar je mïꞌrä ngwüüꞌrï ꞌdï na rom (12,000), ");
INSERT INTO lro_vpl VALUES ("RV7_6","096_7_6","REV","7","6","6","kïïlü gidi Äcïr, aar je mïꞌrä ngwüüꞌrï ꞌdï na rom (12,000), kïïlü gidi Nabitali, aar je mïꞌrä ngwüüꞌrï ꞌdï na rom (12,000), kïïlü gidi Manaji, aar je mïꞌrä ngwüüꞌrï ꞌdï na rom (12,000), ");
INSERT INTO lro_vpl VALUES ("RV7_7","096_7_7","REV","7","7","7","kïïlü gidi Jamaan, aar je mïꞌrä ngwüüꞌrï ꞌdï na rom (12,000), kïïlü gidi Lawi, aar je mïꞌrä ngwüüꞌrï ꞌdï na rom (12,000), kïïlü gidi Yajakir aar je mïꞌrä ngwüüꞌrï ꞌdï na rom (12,000), ");
INSERT INTO lro_vpl VALUES ("RV7_8","096_7_8","REV","7","8","8","kïïlü gidi Jablun, aar je mïꞌrä ngwüüꞌrï na rom (12,000), kïïlü gidi Yüjïb, aar je mïꞌrä ngwüüꞌrï ꞌdï na rom (12,000), na kïïlü gidi Bïnïyämïn, aar je mïꞌrä ngwüüꞌrï ꞌdï na rom (12,000). ");
INSERT INTO lro_vpl VALUES ("RV7_9","096_7_9","REV","7","9","9","Anni ma aar ele giyee, nyi be ombajidalu nyi engga ngwüjü ngwonyadu ngwaꞌti ngwa düꞌränï ngwïndï giyen na gïyïïlü na ngwüjï na ngwungla aar dünäcï diduꞌralu aar dünï ngwäyänü ngwudi Girany, ngwugenna ngwureda ngwubidu ngwapana yiꞌrina yidi ngwiꞌdi ngwuy ngwe ngwegen. ");
INSERT INTO lro_vpl VALUES ("RV7_10","096_7_10","REV","7","10","10","Aar opepala gwulleny aar ari, “Gilang gwuru gwudi Ngwaalu ngwege, gwanni gwujalu gididuꞌrala didi yeleny, ngwuru gwudi Girany.” ");
INSERT INTO lro_vpl VALUES ("RV7_11","096_7_11","REV","7","11","11","A yïꞌrr ꞌdar dünälä aar üꞌrü diduꞌralu guꞌriguꞌtu didi yeleny na mbumbunga giloo lijalu na ngwong ngwoo kwoꞌrongo ngwumidu. Aar üllänü aar kwuci diduꞌralu didi yeleny yirku ye aar äpïjï Ngwaalinga yobo. ");
INSERT INTO lro_vpl VALUES ("RV7_12","096_7_12","REV","7","12","12","Aar ari, “Yiru gu! Orta na näjï na bebere na yäy ꞌtu na denya na yeleny na yiima aar ru yidi Ngwaalu ngwege gwurꞌtal na gwurꞌtal. Yiru gu.” ");
INSERT INTO lro_vpl VALUES ("RV7_13","096_7_13","REV","7","13","13","Aar nyi be mbumbu gweꞌte otacalu aar nyi ci, “Ngwüjï ngwee ngwugenna ngwureda ngwubidu ngwuru ange? A ngwïndï ne?” ");
INSERT INTO lro_vpl VALUES ("RV7_14","096_7_14","REV","7","14","14","Nyi be ci, “Nga gwuru gwülïngïdï gwani doorta.” Aar nyi be ci, “Ngwüjï ngwee ngwuru ngwanni ngwuma gïlängïdïnä gïdïrbänü danni dipa. Ngwuma uya ngwureda ngwegen ngwuma aar je bidiyi gïyïn yidi Girany. ");
INSERT INTO lro_vpl VALUES ("RV7_15","096_7_15","REV","7","15","15","Yäy gu no, Aar be dünäcï diduꞌralu didi yeleny didi Ngwaalu aar äpïjï yobo lingen le dilu de kobanu güngün, na nggwo gwujalu gididuꞌrala didi yeleny ling je gwüꞌrübäjälü diil de didi gäꞌtä güngün. ");
INSERT INTO lro_vpl VALUES ("RV7_16","096_7_16","REV","7","16","16","Ngwaꞌti ngwa je ngwamu enyanu mana, na ngwaꞌti ngwa je ngwäädä eny mana. Ngwaꞌti ngwa je deja mïꞌrï, na ngwaꞌti ngwa je ngwübrürtä ngwere ape. ");
INSERT INTO lro_vpl VALUES ("RV7_17","096_7_17","REV","7","17","17","Ndi ari Girany ganni gijalu gidiliganu didi diduꞌri didi yeleny, ga ru dooꞌra degen, ling je oktada ngwel ngwudi yaw yanni yätï ngwäyänü yidi midi. La je Ngwaalu brota yal ngwäy yere ꞌdar.” ");
INSERT INTO lro_vpl VALUES ("RV8_1","096_8_1","REV","8","1","1","Na anni ma Girany ïgïtï dilge ndoo diru giꞌra kwoꞌra täꞌrïl, a ngwaalu jalu bïny bïny kerala ꞌdi aar ape gaji güꞌränü. ");
INSERT INTO lro_vpl VALUES ("RV8_2","096_8_2","REV","8","2","2","Nyi engga yïꞌrrä kwoꞌra täꞌrïl yïdünäcä Ngwaalingalu aar je ätädä yiil kwoꞌra täꞌrïl. ");
INSERT INTO lro_vpl VALUES ("RV8_3","096_8_3","REV","8","3","3","A gïꞌrr ila giꞌter gapana gïndängä giru dab ngwüdünï gidagad didi gatalu. Aar ätädä yiluna yonyadu ngwuje gatalu ulingani gwe gwudi ngwüjï ngwanni ngwujaw gidagad diru dab gididuꞌralu. ");
INSERT INTO lro_vpl VALUES ("RV8_4","096_8_4","REV","8","4","4","A dïlü didi yilun ꞌtüdä kuy gidi gïꞌrr na ulingani gwudi ngwüjï ngwanni ngwujaw allu aar obani ngwäyänü Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("RV8_5","096_8_5","REV","8","5","5","A be gïꞌrr ape gïndängä nggoo giru dab ngwonjaji lïgälä lanni lijalu gidagadalu ngwugata gïdïyängälü, a ngwaalu mïꞌrïnänü nono gwele gere a dulu ji a ngwaalu enyanu aar lagadalu. ");
INSERT INTO lro_vpl VALUES ("RV8_6","096_8_6","REV","8","6","6","A yïꞌrr giyoo kwoꞌra täꞌrïl giyoo yapana yiil aar ji mama ndi aar je ärï. ");
INSERT INTO lro_vpl VALUES ("RV8_7","096_8_7","REV","8","7","7","A gïꞌrr gidi gwerre gwerreng ärï giil güngün a gïjïꞌrïm giru yuurrum na lïgä ꞌdidalu gïdïyängälü dïlägänänü yïn ye ngwuꞌdiyi dïyängü ngwangridu täꞌrïl na ngwaꞌri ngwangridu täꞌrïl na yanya yanni yïgïnyä ꞌdar. ");
INSERT INTO lro_vpl VALUES ("RV8_8","096_8_8","REV","8","8","8","A gïꞌrr giꞌra rom ärï giil güngün aar gata gony geꞌte giyaanu giru nono geno gipa guꞌdu lïgä ngwügwürlï yaw ngwangridu täꞌrïl aar ru yïn, ");
INSERT INTO lro_vpl VALUES ("RV8_9","096_8_9","REV","8","9","9","a ngwong ngwanni ngwumidu giyaw aar je ꞌrinye ngwangridu täꞌrïl a ngwübälükä dudi ngwangridu täꞌrïl. ");
INSERT INTO lro_vpl VALUES ("RV8_10","096_8_10","REV","8","10","10","A gïꞌrr giꞌra täꞌrïl ärï giil güngün a guurrum miꞌra kerala gipa guꞌdu nono lingla lidi lïgä ngwacaji ngwubirta na ngwel ngwudi yaw ngwangridu täꞌrïl. ");
INSERT INTO lro_vpl VALUES ("RV8_11","096_8_11","REV","8","11","11","Ngwürïny ngwudi guurrum nggoo ngwani Diꞌroker a yaw gwurli aar ꞌre cicir nono diꞌrokera ngwangridu täꞌrïl, aar ꞌrinye ngwüjü ngwonyadu ndi ari yaw yiꞌri gwulleny. ");
INSERT INTO lro_vpl VALUES ("RV8_12","096_8_12","REV","8","12","12","A gïꞌrr giꞌra kwoꞌrongo ärï giil güngün a lingen mïꞌrïnï ngwangridu täꞌrïl na düüwä na yuurrum a ngwaalu ru dïrïm ngwangridu täꞌrïl a lingen le ngwangridu täꞌrïl aar ümnänü a buri erne na ꞌto dilu de ngwangridu täꞌrïl. ");
INSERT INTO lro_vpl VALUES ("RV8_13","096_8_13","REV","8","13","13","Nyi be ombajidalu nyi engga gïꞌräyü giru dïïyü gïꞌdïꞌrü kerala nyi ꞌdingini ngwari yal ye yipa ngwari, “Ngwäjäj bi! Ngwäjäj bi! Ngwäjäj bi! Ngwüjï gïdïyängälü gwani yal yidi yiil yanni yadi je yïꞌrr täꞌrïl yiꞌter ärä.” ");
INSERT INTO lro_vpl VALUES ("RV9_1","096_9_1","REV","9","1","1","A gïꞌrr nggoo giru giꞌra tudini ärï giil güngün, nyi engga guurrumu gïꞌdü kerala ngwüllä gïdïyängälü, aar ätädä mubita gwudi ïgïtï delo diru gïbüꞌrïl. ");
INSERT INTO lro_vpl VALUES ("RV9_2","096_9_2","REV","9","2","2","Anni mung äbräjï delalu diru gïbüꞌrïl, a gu dïlü ꞌtüdä danni dipa giꞌranu nono dïlü didi güdä a lingen ru dïrïm na gere, dïlü de danni dïꞌtüdï kïbüꞌrïl nggoo. ");
INSERT INTO lro_vpl VALUES ("RV9_3","096_9_3","REV","9","3","3","A ngwama ꞌtüdä gïdïlänü aar elalu gïdïyängälü aar je ätädä yelenya ndi iyiyi ngwüjü yiꞌrendenya nono yiiya yidi ngwümü ngwudi dïyängälü. ");
INSERT INTO lro_vpl VALUES ("RV9_4","096_9_4","REV","9","4","4","Aar je ondaci ndi ari aaꞌti ngwa akani yanya nono yidi dïyäng, na ngwong ngwüküdïnä na daꞌri, aar be gwoda ꞌdogo ngwüjü ꞌdar ngwanni ngwaꞌti aar je mïꞌrädï gïyïdülälä yegen mïꞌrä gwe ngwudi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("RV9_5","096_9_5","REV","9","5","5","Aar je iyiyi yiꞌrendenya ngwüüwäyü tudini (5) aaꞌti ngwa aar je ꞌrinye. Aar je iyiyi yiꞌrendenya nono gwele yiiya yidi dümü mung dugi dïjü. ");
INSERT INTO lro_vpl VALUES ("RV9_6","096_9_6","REV","9","6","6","Giyomon giyoo ngwüjï ngwa bupi yiꞌrany, a yaꞌti ya aar je mbuji, ngwa jada ndi ayi, a ngwa je yiꞌrany abri. ");
INSERT INTO lro_vpl VALUES ("RV9_7","096_9_7","REV","9","7","7","Ngwama ngwoo ngwuru yiꞌremna nono ngwumirta ngwüjäꞌrïmädäär je ngwadi aar ngwe ele gïyäärä ngwugenna ngwony giyiꞌrala yegen ngwuru nono yukuna yiru dab aar ru ngwäyänü nono ngwüjü ngwümnä. ");
INSERT INTO lro_vpl VALUES ("RV9_8","096_9_8","REV","9","8","8","Aar ꞌtü ngwäꞌrü ngwuru nono ngwäꞌrü ngwudi ngwaw a ngwad gwegen ru nono ngwad ngwudi ngwira. ");
INSERT INTO lro_vpl VALUES ("RV9_9","096_9_9","REV","9","9","9","Ngwätï ngwäärä giyonggomala ngwuru ngwaaba, ngwümïꞌrïnä ngwubung ngwe ngwegen nono gwele yal yidi ngwumirta ngwonyadu ngwäbrädï gïyäärä. ");
INSERT INTO lro_vpl VALUES ("RV9_10","096_9_10","REV","9","10","10","Aar ätï ngwiya ngwati obe nono gwele ngwümü, ngwiya ngwee ngwätädäär je yiima ndi iyiyi ngwüjü yiꞌrendenya ngwüüwäyü tudini (5). ");
INSERT INTO lro_vpl VALUES ("RV9_11","096_9_11","REV","9","11","11","A ngwüktï je deleny diru gïꞌrr gidi gïbüꞌrïl gani Yïbrïyängä ‘Äbädün’ na ngwani Yïgïrïgïyängä ‘Abuliyun.’ ");
INSERT INTO lro_vpl VALUES ("RV9_12","096_9_12","REV","9","12","12","A wäjäj bi gwudi gwerreng medadi ngwoꞌre ngwugwujalu giꞌra rom. ");
INSERT INTO lro_vpl VALUES ("RV9_13","096_9_13","REV","9","13","13","A gïꞌrr nggoo giru giꞌra nyärläl, ärï giil güngün, nyi ꞌdingini yal yïndï giyiil giyoo kwoꞌrongo gidagadalu ndoo diru dab ngwäyänü Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("RV9_14","096_9_14","REV","9","14","14","Yal giyoo aar ci gïꞌrrä nggoo giru giꞌra nyärläl ganni gapana giil, “Gwällädï yïꞌrrälü giyoo kwoꞌrongo yigekannalu gidibirta dipa dani Burad.” ");
INSERT INTO lro_vpl VALUES ("RV9_15","096_9_15","REV","9","15","15","A yïꞌrr giyoo kwoꞌrongo gwallanalu kaji nggoo a komon nggoo gïdüüwä ndoo na gïdïdlä ndoo, yiju gu be mama nunnu aar ꞌrinye ngwüjü ngwangiridu täꞌrïl (3). ");
INSERT INTO lro_vpl VALUES ("RV9_16","096_9_16","REV","9","16","16","Aar je enggaci yiꞌra yidi gwuꞌtulu gwanni gwändï ngwumirtala gwuru ümn, aar mbuji ndi ari gwuru yiꞌranu küüꞌrï ꞌdï ngwüüꞌrï ngwubaalu (200,000,000). ");
INSERT INTO lro_vpl VALUES ("RV9_17","096_9_17","REV","9","17","17","A nyi dilingid eny nyi engga ngwumirta ngwändï gu ngwüjälä, ngwugenna ngwärä ngwuru ngwaaba giyonggomala ngwuri nono lïgä aar ïgïnyänü nono gälgätüm aar ranu girende nono gïbrïtï. A yiꞌra yegen ru nono yiꞌra yidi ngwira ati lïgä na dïlü na gïbrïtï ꞌtüdä ngwulem ngwegen. ");
INSERT INTO lro_vpl VALUES ("RV9_18","096_9_18","REV","9","18","18","Aar ꞌrinye ngwüjü ngwangiridu täꞌrïl dimdi de ndoo täꞌrïl diru lïgä na dïlü na gïbrïtï danni dïꞌtüdï ngwulemanu ngwegen. ");
INSERT INTO lro_vpl VALUES ("RV9_19","096_9_19","REV","9","19","19","Yiima yidi ngwumirta ngwee yiju ngwulem na ngwiya ngwegen, ndi ari ngwiya ngwegen ngwuru nono ngwüüngä ngwätï yiꞌra yati aar ye obe ngwüjü aar je ätïyï ngwämmä. ");
INSERT INTO lro_vpl VALUES ("RV9_20","096_9_20","REV","9","20","20","Na ngwüjï ngwoko ngwanni ngwuma je ꞌti dimdi ndoo ꞌrïnyïtï, aar ꞌti joꞌrenyana aar gatana ngwony ngwanni ngwugeꞌtaar je ngwuy ngwegen, aar ꞌti dünäjä äpïjïng ngwujegoꞌro yobo na yiꞌremna yiru dab na buta yoꞌrr na yüꞌrï, yiꞌremna yanni yaꞌti ätï ngwäy ndi ombajidalu aar aaꞌti ätï ngwänï ndi ꞌdingini aar ꞌti ätï yora ndi ele. ");
INSERT INTO lro_vpl VALUES ("RV9_21","096_9_21","REV","9","21","21","Aar ꞌti joꞌrenyana ndi ꞌrinyidi, ndi arri yuꞌrinyu, gïyïjïn yegen na giyuꞌram yegen. ");
INSERT INTO lro_vpl VALUES ("RV10_1","096_10_1","REV","10","1","1","Nyi be aji nyi engga gïꞌrrä giꞌter gätï yelenya ngwüllä kerala, gigenna gïbäꞌrü, a dulili ji kiꞌrala ꞌdünggüngün. Giru ngwäyänü nono lingeno a yora yüngün ru yidingo yiru lïgä. ");
INSERT INTO lro_vpl VALUES ("RV10_2","096_10_2","REV","10","2","2","Gapu gitab gooko kuy güngün gïgïtïnä. Ngwugatu gora güngün gidi gaama giyaala na gidi gängïr gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("RV10_3","096_10_3","REV","10","3","3","Ngwube mïꞌrï dula gwulleny nono guba gidi dira. Anni mung mïꞌrï dula gwulleny, gere gïmïꞌrïnänü kwoꞌra täꞌrïl ondaja. ");
INSERT INTO lro_vpl VALUES ("RV10_4","096_10_4","REV","10","4","4","Anni ma dulu didi gere gïmïꞌrïnänü kwoꞌra täꞌrïl ondaji, nyi ji mama gwadi ulli, nyi be ꞌdingina dula kerala ngwondaja, “Mïꞌrädï ngwujaꞌri nga je määtä yujimida ngwanni ngwaru ngwe gere gïmïꞌrïnänü kwoꞌra täꞌrïl aaꞌti ngwa je ulli.” ");
INSERT INTO lro_vpl VALUES ("RV10_5","096_10_5","REV","10","5","5","A be gïꞌrr nggoo gänggädïny gïdünädï giyaala na gïdïyängälü, allijaji guyala güngün gidi gaama kere. ");
INSERT INTO lro_vpl VALUES ("RV10_6","096_10_6","REV","10","6","6","Ngwümïꞌrï yiꞌrany ngwürïny ngwudi nginde gwanni gwumidu gwurꞌtal, gwanni gwugeꞌta yere na ꞌdar yanni giyo gu, dïyäng na ꞌdar yanni giyo gu, na yaw na ngwong ꞌdar ngwanni ngwo gu ngwari, “Yaꞌti ba be ya jana. ");
INSERT INTO lro_vpl VALUES ("RV10_7","096_10_7","REV","10","7","7","Giyomon yanni yadi ye gïꞌrr giru giꞌra kwoꞌra täꞌrïl mïꞌrïdä giil güngün, yujimidi yidi Ngwaalu ya be medadi, anaku ondacing ye ngwïnädä ngwüngün ngwuru ngwïjïr.” ");
INSERT INTO lro_vpl VALUES ("RV10_8","096_10_8","REV","10","8","8","A be dulu danni diꞌdingininy ꞌtuꞌtu kerala aar nyi ondaca mana aar nyi ci, “Ïndï ang ape gitab nggone gooko gïgïtïnä kuy gidi gïꞌrr nggone gïdünädälä giyaala na gïdïyängälü.” ");
INSERT INTO lro_vpl VALUES ("RV10_9","096_10_9","REV","10","9","9","Nyi be ele kïꞌrr nyi otacalu nyi ci ätädïny gitab nggoo gooko. Aar nyi be ci nu, “Apa ang eny, ga ang nyinyilaji ngwulemanu nono ngwaay a be ga ang uliyanu.” ");
INSERT INTO lro_vpl VALUES ("RV10_10","096_10_10","REV","10","10","10","Nyi ape gitab nggoo gooko kuy gidi gïꞌrr nyi eny, aar nyi nyinyilaji ngwulemanu nono ngwaay a be anni minyi eny aar nyi uliyanu gilaranu. ");
INSERT INTO lro_vpl VALUES ("RV10_11","096_10_11","REV","10","11","11","Aar nyi be ci, “A gwa alliji yïjïrä mana gwani ngwüjï ngwonyadu, ngwüjï giyen, ngwungla na ngweleny.” ");
INSERT INTO lro_vpl VALUES ("RV11_1","096_11_1","REV","11","1","1","Aar nyi be ätädä gipuru giru nono gimur gidi ïdï, aar nyi ci, “Ïndï nga ïdï gobo gidi Ngwaalu na dagad didi gatalu na nga ïꞌrä ngwüjü ngwanni ngwäpïjä Ngwaalinga yobo ngenone. ");
INSERT INTO lro_vpl VALUES ("RV11_2","096_11_2","REV","11","2","2","Nga be gäbïcï gubunga gidi gobo poor aaꞌti ngwa je ïdï ndi ari ngwumaar je ätädä ngwüjü ngwuru Garany. Ngwa ruꞌti gündärä ganni gijuꞌru yora ye ngwüüwäyü küüꞌrï rom na rom (42). ");
INSERT INTO lro_vpl VALUES ("RV11_3","096_11_3","REV","11","3","3","A linje ätädä lüny rom lanni länggädï yiima la jalu gïmärä aar alliji yïjïrä yomon ngwüüꞌrï na küüꞌrï tudini rom na ꞌdï nyärläl (1260).” ");
INSERT INTO lro_vpl VALUES ("RV11_4","096_11_4","REV","11","4","4","Giloo rom lanni länggädï, liru ngwümïnïtï rom (2) na yudin yidi ngwamba rom (2) yanni yïdünädälä ngwäyänü ngwudi Deleny didi dïyäng. ");
INSERT INTO lro_vpl VALUES ("RV11_5","096_11_5","REV","11","5","5","Manari dïjï dere dima ari ngwuje akani nono, a lïgä ꞌtüdä ngwulemanu ngwegen ngwuꞌdiyi güwänü gegen. Na gwere gwanni gwa ari ngwung je akani nono gwa gu ayi no. ");
INSERT INTO lro_vpl VALUES ("RV11_6","096_11_6","REV","11","6","6","A ngwa ätï yiima ndi längïtï gere aaꞌti girany ga ni gaji ganni gadi aar ge ji ndi alliji yïjïrä. Aar je ätï ꞌto yiima ndi gwürlï yaw aar ru yïn na ndi mïꞌrï dïyängü dimdi de ꞌdar ma aar gu bupi. ");
INSERT INTO lro_vpl VALUES ("RV11_7","096_11_7","REV","11","7","7","Manari lima medaji inggiding gwegen, a be gomꞌreny ganni giki drü gati ꞌtüdä kïbüꞌrïl ngwuje ꞌdïꞌrä nono aar ngwe dugidi ngwuje dami ngwuje ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("RV11_8","096_11_8","REV","11","8","8","A ngwangina ngwegen gätïnälü kayalu gidi gündär gipa ganni gätädäär ngwürïny giꞌremna gani Jadum na Mijir ngwaalu ngwanni ngwäpädäär gu ꞌto Delenya degen küꞌrälä. ");
INSERT INTO lro_vpl VALUES ("RV11_9","096_11_9","REV","11","9","9","A ngwüjï ꞌdar gïyïïlü ꞌdar na ngwungla ꞌdar na ngwüjï giyen ꞌdar ombajaji ngwanginalu ngwegen ngwäyädälü yomon ꞌtäꞌrïl na gomon ganni güꞌränü aar je gu etadi ndi aar je gatu. ");
INSERT INTO lro_vpl VALUES ("RV11_10","096_11_10","REV","11","10","10","Ngwüjï ngwanni ngwunyurtanu gïdïyängälü ngwa jayanu yiꞌrany ye yegen ngwape yïꞌrïnyïnä aar angidajidi ngwony ndi ari ngwïjïr ngwee rom ngwärrü ngwüjü ngwanni ngwunyurtanu gïdïyängälü yündä gwulleny. ");
INSERT INTO lro_vpl VALUES ("RV11_11","096_11_11","REV","11","11","11","Anni ma yomon täꞌrïl na ganni güꞌränü medadi, a je gu Ngwaalu ngwükäjä lïgïꞌrïmänü lidi midi aar ꞌdïꞌrälü aar dünälä yora ye yegen a lanni liju ndi je ombaji a je yedeny eny gwulleny. ");
INSERT INTO lro_vpl VALUES ("RV11_12","096_11_12","REV","11","12","12","A ngwïjïr ngwoo rom ꞌdingini dula kerela aar je ci, “Andar ngene.” Aar allu kerela gïyïbäꞌrälä a je güwän gegen engga. ");
INSERT INTO lro_vpl VALUES ("RV11_13","096_11_13","REV","11","13","13","A gaji nggoo no, a ngwaalu lagadalu ati ngwuꞌdun ꞌdï kündär ïꞌdï giꞌra geꞌte aar ꞌrinye ngwüjü ngwüüꞌrï kwoꞌra täꞌrïl (7,000), a ngwanni ngwuma gilang, a je yedeny eny aar ortada Ngwaalinga ngwudi gerala. ");
INSERT INTO lro_vpl VALUES ("RV11_14","096_11_14","REV","11","14","14","A wäjäj bi nggwo giꞌra rom medadi a wäjäj bi gwanni gwuru giꞌra täꞌrïl ji kay ndi ila. ");
INSERT INTO lro_vpl VALUES ("RV11_15","096_11_15","REV","11","15","15","A be a gïꞌrr nggoo giru giꞌra kwoꞌra täꞌrïl ärï giil güngün a dulu aranu dipa kerala ngwari, “Yeleny yidi dïdlä yima aar je ätädä Delenya dege na ngindeng gwüngün gwanni gwani Kirictu Gwubrutaar yelenya, na gwadi ru Deleny gwurꞌtal.” ");
INSERT INTO lro_vpl VALUES ("RV11_16","096_11_16","REV","11","16","16","A mbumbunga giloo liru küüꞌrï na kwoꞌrongo lijalu ngwuduꞌrala ngwudi yeleny ngwegen ngwäyänü Ngwaalu, aar je kwucalu yirku ye. ");
INSERT INTO lro_vpl VALUES ("RV11_17","096_11_17","REV","11","17","17","Aar ci, “Licanga yäy ꞌtu gwani Deleny diru Ngwaalu ngwuru yiima, ngwanni ngwo na ngwanni ngwuju, nunnu nga gwuma ape yiima yunga yipa na nga gwuma aalu ndi ape yelenya. ");
INSERT INTO lro_vpl VALUES ("RV11_18","096_11_18","REV","11","18","18","A güündä ape ngwüjü giyen, na güündä gunga gima ila. A gaji gima ila ndi obalu ngwüjü ngwe ngwanni ngwayu, na ndi ätädä ngwïnädä ngwunga ngwanni ngwuru ngwïjïr guꞌru na lunga lanni lijuꞌru na ngindenga ꞌdar lanni lïdïnyädï ngwürïny ngwunga, lanni loko na lanni lipa, na ndi geraji ngwüjälü ngwanni ngwugeraja dïyängälü.” ");
INSERT INTO lro_vpl VALUES ("RV11_19","096_11_19","REV","11","19","19","A be gobo gidi Ngwaalu ïgïtïnä kerala, kobanu güngün a gu dïmbür didi Gekajidi enggani. Ngenone a gu gere enyany a gu dulu ari a gu gere mïꞌrïnänü a gu ngwaalu lagadalu aar ïꞌdï gïjïꞌrïmä gipa giru yuurrum. ");
INSERT INTO lro_vpl VALUES ("RV12_1","096_12_1","REV","12","1","1","A giꞌremna giru yiima ꞌtädälü kerala, a daw ji digenna lingeno a düüwä ji giyoralu yüngün a kiꞌrala güngün digenna gukuna gätï yuurrumu ꞌdï na rom (12). ");
INSERT INTO lro_vpl VALUES ("RV12_2","096_12_2","REV","12","2","2","Diju lari le ngwuji gito dadi lenge, a yajima enyanu ngwari. ");
INSERT INTO lro_vpl VALUES ("RV12_3","096_12_3","REV","12","3","3","Oꞌre a yiꞌremna yiru yiima yiꞌter ꞌtädälü kerala a dägꞌrïꞌdïr danni duri dibinga dätï yiꞌranu kwoꞌra täꞌrïl na ngwiil ꞌdï ngwätï yukuna kwoꞌra täꞌrïl giyiꞌrala yüngün. ");
INSERT INTO lro_vpl VALUES ("RV12_4","096_12_4","REV","12","4","4","Ngwoda yuurrumu kerala ngwangiridu täꞌrïl (3) liya le lüngün ngwuje gata gïdïyängälü. Ngwube dünäcï dayalu ndo diju gito dadi linge, nunnu mung lingeta ngwungadini gïjü güngün ditiꞌrambal. ");
INSERT INTO lro_vpl VALUES ("RV12_5","096_12_5","REV","12","5","5","A daw lingeta gïjü giru dur giru ganni gadi ruyi ngwüjü giyen yelenya guura ge giru laaba. Aar äbrï gïjü güngün nggoo aar ge ele Ngwaalu na gididuꞌri didi yeleny düngün. ");
INSERT INTO lro_vpl VALUES ("RV12_6","096_12_6","REV","12","6","6","A be daw abri ngwele gïtäny a gu Ngwaalu gïꞌtïjï ngwaalinga ngenone nggu ji aar gu ombaji yomon ngwüüꞌrï na küüꞌrï ꞌdï na ꞌdï nyärläl (1260). ");
INSERT INTO lro_vpl VALUES ("RV12_7","096_12_7","REV","12","7","7","A be yäärä ꞌdïꞌrä kerala, a Mägäyïlïngä yïꞌrr ye yüngün aar dugidi dägꞌrïꞌdïrngä le yïꞌrr ye yüngün. ");
INSERT INTO lro_vpl VALUES ("RV12_8","096_12_8","REV","12","8","8","Aaꞌti be dägꞌrïꞌdïr ojema nono gwulleny aar je dami aar je apada ngwaalinga ngwegen kerala. ");
INSERT INTO lro_vpl VALUES ("RV12_9","096_12_9","REV","12","9","9","Aar gata dägꞌrïꞌdïrä ndoo dibinga gïdïyängälü. Diru düüngä duubu dani dijegoꞌrr danni dati üktïnï ngwüjü ꞌdar gïdïdlä ngwuje dudiyi. Aar ïꞌdä gïdïyängälü yïꞌrr ye yüngün. ");
INSERT INTO lro_vpl VALUES ("RV12_10","096_12_10","REV","12","10","10","Nyi be ꞌdingini dula dipa kerala ngwari, “Gwene gilang na yiima na yeleny yidi Ngwaalu ngwege yima ru, na yeleny yidi nginde gwüngün gwanni Gwubrutaar yelenya. Ndi ari dijegoꞌrr danni dati üꞌrïdä ngweengga ngwege ngwujaꞌri nono, danni dati je üꞌrïdä ngwujaꞌri nono lingen le na dilu de ngwäyänü Ngwaalu ngwege, dima aar linynya dima aar gata gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("RV12_11","096_12_11","REV","12","11","11","Dima aar obedalu yïn ye yidi Girany na ngwujaꞌri ngwe ngwegen ngwanni gwinggidaar je, aar ꞌti ämnä miding gwudi yigoꞌro yegen gwulleny, nda je yedeny eny giyiꞌrany. ");
INSERT INTO lro_vpl VALUES ("RV12_12","096_12_12","REV","12","12","12","Yäy gu no, jayanu gwani gere na nga nga lanni gilo gu jayaranu! A be wäjäj bi gwani dïyäng na yaw, ndi ari dijegoꞌrr dima üllä ꞌdanggalu! Dapu güündä giru lïgä, ndi ari dïlïngïdï yomon yüngün yima jalu yooko.” ");
INSERT INTO lro_vpl VALUES ("RV12_13","096_12_13","REV","12","13","13","Anni ma dägꞌrïꞌdïr engga ligoꞌro lüngün ndi ari dima gätïnä gïdïyängälü, ngwugwurli ngwübïnï dayalu ndoo dïlïngïtï gïjü giru dur. ");
INSERT INTO lro_vpl VALUES ("RV12_14","096_12_14","REV","12","14","14","Aar gïꞌtïjï dayu ngwubung ngwudi gïꞌrä giru dïïyü nunnu ngwe ꞌdïꞌrï ngwele ngwaalu ngwanni ngwügïꞌtïjäär je gïtäny nggu ji ngeneno aar gu ombaji ngwüdläyü täꞌrïl na ngwüüwäyü nyärläl nunnu ngwabri dägꞌrïꞌdïrä. ");
INSERT INTO lro_vpl VALUES ("RV12_15","096_12_15","REV","12","15","15","A düüngä gata yaw ngwulemanu ngwüngün nono däärü nunnu aar ape dayu. ");
INSERT INTO lro_vpl VALUES ("RV12_16","096_12_16","REV","12","16","16","A be dïyäng ïgïtïnä ngwungadini däärä ndoo dïgätï dägꞌrïꞌdïr ngwulem ngwüngün ngwataji dayu düwä. ");
INSERT INTO lro_vpl VALUES ("RV12_17","096_12_17","REV","12","17","17","A güündä ape dägꞌrïꞌdïrä gidaw ngwoꞌrada gilinge nono güngün ganni giꞌdengenaca ngwujaꞌri ngwudi Ngwaalu aar inggidi ndi ari yiru ngwüjï ngwudi Yicu, aar ye dugidi. ");
INSERT INTO lro_vpl VALUES ("RV12_18","096_12_18","REV","12","18","18","A dägꞌrïꞌdïr dünï kïmämü gidi yaw. ");
INSERT INTO lro_vpl VALUES ("RV13_1","096_13_1","REV","13","1","1","Nyi engga gomꞌrenya gïꞌtüdï giyaanu, gätï ngwiil ꞌdï na yiꞌra kwoꞌra täꞌrïl na ngwiilala ngwüngün ngwätï yukuna ꞌdï na giyiꞌra yüngün yüllïnä ngwürïny ngwüllüdï Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("RV13_2","096_13_2","REV","13","2","2","Gomꞌreny ganni gänggädïny giru nono gaꞌdirgany ngwube ru yora nono yidi dämbäꞌrü ngwuru ngwünyü nono ngwudi dira. A dägꞌrïꞌdïr ätädä gomꞌrenya yiima yüngün ngwätädä diduꞌri didi yeleny na yeleny yipa. ");
INSERT INTO lro_vpl VALUES ("RV13_3","096_13_3","REV","13","3","3","A be giꞌra geꞌte gidi gomꞌreny güꞌrïdäär dämmä dani yiꞌrany a be dämmä ndoo uꞌri nono. A ngwüjï ngwudi dïdlä ꞌdar allalu ndïr aar gwuji gomꞌrenya. ");
INSERT INTO lro_vpl VALUES ("RV13_4","096_13_4","REV","13","4","4","A ngwüjï kwuci dägꞌrïꞌdïrälü yirku ye ndi ari dima ätädä gomꞌrenya yelenya, aar kwuci gomꞌrenyalu ꞌto yirku ye aar utalu, “Yärü gwuru gwanni gwuru nono dägꞌrïꞌdïrä? Yärü gwuru gwanni gwa aar gwe ꞌtäjïdï yongra ngwudami?” ");
INSERT INTO lro_vpl VALUES ("RV13_5","096_13_5","REV","13","5","5","Aar ätädä gomꞌrenya ngwulem ngwe ondaji yiꞌral ngwuye piyi ligoꞌro lüngün ngwe lo Ngwaalinga ngwape yelenya yüngün ngwuje ruyi ngwüüwäyü küüꞌrï rom na rom (42). ");
INSERT INTO lro_vpl VALUES ("RV13_6","096_13_6","REV","13","6","6","Ngwullo Ngwaalinga ngwullo ngwürïny ngwüngün na gobo na ngwüjï ngwudi gerala. ");
INSERT INTO lro_vpl VALUES ("RV13_7","096_13_7","REV","13","7","7","Aar ätädä yiima ndi ari aar dugidi ngwüjï ngwe ngwanni ngwujuꞌru nunnu ngwuje dami. Aar ätädä ꞌto yelenya gïyïïlü ꞌdar, ngwüjï na ngwungla na ngwüjï ken. ");
INSERT INTO lro_vpl VALUES ("RV13_8","096_13_8","REV","13","8","8","Ngwüjï ꞌdar gïdïdlä ngwa kwuci gomꞌrenyalu nggoo yirku ye ngindenga ꞌdar lanni laꞌti üllïnä ngwürïny ngwegen kitabanu gidi midi. Gitab gidi Girany ganni güꞌrïdïnä ngwulem ꞌtuꞌtu gïꞌtïnä gu dïdlälü. ");
INSERT INTO lro_vpl VALUES ("RV13_9","096_13_9","REV","13","9","9","Gwanni gwätï länï, ngwuꞌdingini. ");
INSERT INTO lro_vpl VALUES ("RV13_10","096_13_10","REV","13","10","10","Manari yiru ndi ari aar ape dïjü yiwaya ken da aar ape. Manari yiru ndi ari aar ꞌrinye galala ge, da aar ꞌrinye galal ge. Giyee yïbüpïnä a ngwüjï ngwanni ngwujuꞌru määtä yiguri aar orꞌtemaji aar ru yigor yeꞌte pu. ");
INSERT INTO lro_vpl VALUES ("RV13_11","096_13_11","REV","13","11","11","Nyi be oꞌre nyi engga gomꞌrenya giꞌter gïꞌtüdï gïdïyängänü gätï ngwiil rom ngwuru nono ngwiil ngwudi girany ngwube ondaji nono dägꞌrïꞌdïrä. ");
INSERT INTO lro_vpl VALUES ("RV13_12","096_13_12","REV","13","12","12","Ngwape yiꞌral yeleny ye ꞌdar yidi gomꞌrenya gele gidi gwerre gwerreng ngwügäbïcï ngwony ꞌdar gïdïyängälü na ngwüjï aar kwuci gomꞌrenyalu gele gidi gwerre gwerreng yirku ye ganni gima uꞌri dämmä nono düngün ndoo didi yiꞌrany. ");
INSERT INTO lro_vpl VALUES ("RV13_13","096_13_13","REV","13","13","13","Ngwape yiꞌremna yidi yiima ꞌdi ngwugeꞌte lïgä luꞌdu lüllü kerala ngwüllä gïdïyängälü a ngwüjï engga ꞌdar. ");
INSERT INTO lro_vpl VALUES ("RV13_14","096_13_14","REV","13","14","14","Ngwududiyi ngwüjü gïdïyängälü yiima ye giyee yanni yimanding ye komꞌreny nggoo gidi gwerre gwerreng. Ngwuci ngwüjü gïdïyängälü aar gaꞌriji giꞌremna aar näjï gomꞌrenya ganni güꞌrïdär dämmä galal ge nggona be ji gimidu. ");
INSERT INTO lro_vpl VALUES ("RV13_15","096_13_15","REV","13","15","15","Aar ätädä yiima ndi ari ngwübüdä giꞌremna düwänü gidi gomꞌreny nggoo gidi gwerre gwerreng, nunnu ngwügäbïcï ngwondaji ngwügäbïcï ngwüjü ꞌdar ngwanni ngwuꞌdonya ndi kwuci giꞌremnanalu yirku ye aar je ꞌrinye. ");
INSERT INTO lro_vpl VALUES ("RV13_16","096_13_16","REV","13","16","16","Ngwügäbïcï ngwüjü, ngwanni ngwooko na ngwanni ngwupa, ngwanni ngwünänü na ngwanni ngwuru ngwuwayi, ngwudi ꞌdunung na ngwïnäd, aar je mïꞌrä gubuꞌru kaama güngün na kïdülälä güngün, ");
INSERT INTO lro_vpl VALUES ("RV13_17","096_13_17","REV","13","17","17","nunnu aaꞌti dïjï da ellang na aar ella, ꞌdogo manari dätï gubuꞌru nggoo. Gubuꞌru nggoo giru ngwürïny ngwudi gomꞌreny na giꞌra gidi ngwürïny ngwüngün. ");
INSERT INTO lro_vpl VALUES ("RV13_18","096_13_18","REV","13","18","18","Giyee yïbüpïnä a bebere ji. Gwere gwanni gwubebera, gäbïcär ngwïꞌrä giꞌra gidi gomꞌreny ndi ari giru giꞌra gidi dïjï dümnä. Giꞌra güngün giru nyärläl nyärläl nyärläl (666). ");
INSERT INTO lro_vpl VALUES ("RV14_1","096_14_1","REV","14","1","1","Nyi be engga Giranyu gïdünü kenala gani Jäyün gijaar ngwüjï ngwe ngwüüꞌrï küüꞌrï tudini na ꞌdï kwoꞌrongo na kwoꞌrongo (144,000) ngwullaar je gïyïdülälä ngwürïny ngwüngün na ngwudi Papa gwüngün. ");
INSERT INTO lro_vpl VALUES ("RV14_2","096_14_2","REV","14","2","2","Nyi ꞌdingini dula kerala daru nono gwele yaw yonyadu nono gwele yal yidi gere gïmïꞌrïnänü gwulleny, na dulu danni diꞌdingininy, daru nono yal yidi ngwüjï ngwärü aar mïꞌrï ngwümbärä ngwegen. ");
INSERT INTO lro_vpl VALUES ("RV14_3","096_14_3","REV","14","3","3","Aar ji ndi elnge delnga diru diyang giyoranu yidi ngwuduꞌri na ngwong ngwoo ngwumidu ngwuru kwoꞌrongo na mbumbunga. Aaꞌti dïjï dere lïngïdï ndi elnge delnga a be ngwüjï ru ꞌdogo ngwo ngwuru ngwüüꞌrï küüꞌrï tudini na ꞌdï kwoꞌrongo na kwoꞌrongo ngwanni ngwüꞌrädäär jälü gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("RV14_4","096_14_4","REV","14","4","4","Ngwüjü ngwee ngwuru ngwanni ngwaꞌti rngïyä ngwangina ngwegen ngwaw ngwe, aar be etadi ngwangina ngwegen aar juꞌri. Ngwati gwujani Giranyu nggoo ngwaalu ꞌdar ngwati nggu ele. Ngwuru ngwüꞌrädäjälü aar ru yiꞌra ngwüjänü ngwanni ngwügätäjär je Ngwaalingalu aar je gätäjï Giranyalu. ");
INSERT INTO lro_vpl VALUES ("RV14_5","096_14_5","REV","14","5","5","Ngwaꞌti ꞌtüyä yiꞌduru yere ngwulemanu ngwegen aar jayi nono. ");
INSERT INTO lro_vpl VALUES ("RV14_6","096_14_6","REV","14","6","6","Nyi be engga gïꞌrrä giꞌter gïꞌdïꞌrü gidiliganu kerala gapana ngwujaꞌri ngwanni ngwujaw ngwudi gwurꞌtaling ngwe ondaci ngwüjü gïdïyängälü ngwüjï ꞌdar ken, na gïïlü na lingla na ngwüjï. ");
INSERT INTO lro_vpl VALUES ("RV14_7","096_14_7","REV","14","7","7","Ngwondaji dulu de dipa ngwari, “Dïnyädär Ngwaalinga ngaa je näjï, ndi ari gaji gima be ila gidi pïcï ngwüjü yelenya. Kwucaralu yirku ye gwanni gwugeꞌta gere na dïyäng ngwugeꞌte yaw na ngwäy ngwudi yaw.” ");
INSERT INTO lro_vpl VALUES ("RV14_8","096_14_8","REV","14","8","8","Oꞌre a gïꞌrrä gwujanalu giꞌter ngwari, “Gwuma ïꞌdï! Gwuma ïꞌdï! Babil gwanni gwupa! Gwanni gwürlälïyü ngwüjü diꞌrica didi yïjïn yüngün.” ");
INSERT INTO lro_vpl VALUES ("RV14_9","096_14_9","REV","14","9","9","Oꞌre a je gïꞌrr gwujanalu giru täꞌrïl ngwari dula dipa, “Manari dïjï dere danni dikwuca gomꞌrenyalu na giꞌremna güngün yirku ye ngwätï gubuꞌru güngün gïdülälä güngün na kuy güngün, ");
INSERT INTO lro_vpl VALUES ("RV14_10","096_14_10","REV","14","10","10","nginde gwa ïyï ꞌto diꞌrica dani güündä gidi Ngwaalu danni diꞌdejaralu yiima ꞌdar kiny gidi güündä güngün, aar iye yiꞌrendenya gïbrïtï ge giru lïgä ngwäyänü ngwudi yïꞌrr yanni yijuꞌru na ngwäyänü ngwudi Girany. ");
INSERT INTO lro_vpl VALUES ("RV14_11","096_14_11","REV","14","11","11","Ati aar ꞌtü dïlü didi yiꞌrendeny yegen yidi gwurꞌtaling. Laꞌti la gatu düwä dilu de na lingen le, lanni la kwuci gomꞌrenyalu na giꞌremna güngün yirku ye aar ape gubuꞌru gidi ngwürïny ngwüngün.” ");
INSERT INTO lro_vpl VALUES ("RV14_12","096_14_12","REV","14","12","12","Ngene, mätïnälü gwudi ngindenga lanni lïdünälü, aar ape yiiru ngwujaꞌri ngwe ngwudi Ngwaalu aar jalu liru yigor yeꞌte pu ndi Yicu. ");
INSERT INTO lro_vpl VALUES ("RV14_13","096_14_13","REV","14","13","13","Nyi be ꞌdingini dula kerala ngwari, “Ullu, la aar je onjaci lanni ladi ayi ꞌtuꞌtu gomon gidi gweneng liru ngwüjï ngwudi Deleny.” A be Lïgïꞌrïm ari, “Ndi ari ngindenga la gatu düwä gïdïrbä degen, ndi ari la je yiiru yegen gwujani.” ");
INSERT INTO lro_vpl VALUES ("RV14_14","096_14_14","REV","14","14","14","Nyi ombajidalu nyi engga kiꞌra gweere ꞌdünggüny gïbäꞌrü gibidu giju gu dïjälä diru nono ngindeng gwanni gwuma ru nono gïjï gidi dïjï dümnä, kiꞌrala güngün, gigenna gukuna giru dab kiꞌrala güngün ngwape mänjälä guy güngün gwätï yïnï. ");
INSERT INTO lro_vpl VALUES ("RV14_15","096_14_15","REV","14","15","15","A be gïꞌrr giꞌter ꞌtüdä kobo gidi Ngwaalu ngwurnida dulu de gwulleny ngindeng nggwo gwujalu kïbäꞌrälä ngwuci, “Dingada mänjälä gwunga ang uni. Gaji gidi uni gima ila, ndi ari yuula yidi dïyäng yima banyi.” ");
INSERT INTO lro_vpl VALUES ("RV14_16","096_14_16","REV","14","16","16","A nggwo gwujalu kïbäꞌrälä, dingada mänjälä gwüngün ngwuni yuula gïdïyängälü. ");
INSERT INTO lro_vpl VALUES ("RV14_17","096_14_17","REV","14","17","17","Oꞌre a gïꞌrr giꞌter ꞌtüdä kobo kerala gapana ꞌto mänjälä gwätï yïnï. ");
INSERT INTO lro_vpl VALUES ("RV14_18","096_14_18","REV","14","18","18","A be oꞌre a gïꞌrr giꞌter ꞌtüdä gidagad didi gatalu gätï yelenya kïlïgä ngwurnida dulu de gwulleny gïꞌrrä nggoo gapana mänjälä gwätï yïnï ngwuci, “Dingada mänjälä gwunga gwätï yïnï nga üꞌrü dütü didi dügïrï ndi ari yügïrï yüngün yima banyi.” ");
INSERT INTO lro_vpl VALUES ("RV14_19","096_14_19","REV","14","19","19","A gïꞌrr dingada mänjälä gïdïyängälü ngwüꞌrü dütü ngwugatu kigoganu gipa gidi ündï yügïrï gidi güündä gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("RV14_20","096_14_20","REV","14","20","20","Poor kündär ngenone aar je gu mirenyanu yora ye ꞌdi aar ꞌtüyä yïnä kigoganu gidi ündï aar allala ꞌdi aar obani gidilli didi dimirta aar badalu aar ole bränü küüꞌrï ꞌdï (200). ");
INSERT INTO lro_vpl VALUES ("RV15_1","096_15_1","REV","15","1","1","Nyi be engga kerala giꞌremna giru yiima giꞌter gibinga giralu ꞌter, yïꞌrr kwoꞌra täꞌrïl yapana dimdi kwoꞌra täꞌrïl didi gwodaning dadi aar de medaji gündä gidi Ngwaalu. ");
INSERT INTO lro_vpl VALUES ("RV15_2","096_15_2","REV","15","2","2","Na nyi engga gony giru ngwäyänü nono yaw yiru gijaja yïlägänänü lïgä le aar gu dünädä gito gilo lanni lima dami gomꞌrenya na giꞌremna güngün na giꞌra gidi ngwürïny ngwüngün, ngindenga lapu ngwümbärä ngwätädï je Ngwaalu, ");
INSERT INTO lro_vpl VALUES ("RV15_3","096_15_3","REV","15","3","3","aar elnge delnga didi dïnäd didi Ngwaalu dani Müjä na deelnga didi Girany aar ari, “Yiiru yunga yipa yiralu ꞌter, Gwani Deleny diru Ngwaalu ngwuru yiima. Dünälü na ꞌdidanu gwuru gay gunga, Gwani Deleny didi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("RV15_4","096_15_4","REV","15","4","4","Yärü gwanni gwaꞌti gwa yedeny eny ꞌdunggunga gwani Deleny, na yärü gwanni gwaꞌti gwa näjï ngwürïny ngwunga? Ndi ari nga gwuru jücü gwanni gwujuꞌru. Ngwüjï giyen ꞌdar ngwa ila ngwa ang kwucalu yirku ye, ndi ari apepe gwunga gwanni gwüdünälü gwuma ꞌtädälü.” ");
INSERT INTO lro_vpl VALUES ("RV15_5","096_15_5","REV","15","5","5","Anni ma yiꞌral ele giyee, nyi ombajidalu nyi engga gobo giru gäꞌtä gidi Juꞌri ïgïtïnä kerala. ");
INSERT INTO lro_vpl VALUES ("RV15_6","096_15_6","REV","15","6","6","A gu yïꞌrr ꞌtüdä kwoꞌra täꞌrïl yele yapana dimdi kwoꞌra täꞌrïl, yigenna ngwureda ngwujaw nono ngwubidu pupuꞌrul aar üꞌrïdïnänü ngwägüwä ngwuru dab giyonggomala yegen. ");
INSERT INTO lro_vpl VALUES ("RV15_7","096_15_7","REV","15","7","7","Gong geꞌte ngwonganu ngwoo ngwuru kwoꞌrongo ngwumidu, ätädä yïꞌrrä giyoo kwoꞌra täꞌrïl yinya kwoꞌra täꞌrïl yiru dab yonyadu güündälä gidi Ngwaalu ngwanni ngwumidu ngwudi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("RV15_8","096_15_8","REV","15","8","8","A dïlü onyadi gobala didi näjï Ngwaalinga na yiima yüngün, aaꞌti dïjï dere mbuja gay gading ge änï gïdrü ꞌdi a dimdi medadi ndoo diru kwoꞌra täꞌrïl. ");
INSERT INTO lro_vpl VALUES ("RV16_1","096_16_1","REV","16","1","1","Nyi be ꞌdingini dula dipa kobo ngwuci yïꞌrrä giyoo kwoꞌra täꞌrïl, “Ïndär ngaa ꞌdeje gündälü gidi Ngwaalu giyinyanu kwoꞌra täꞌrïl gïdïyängälü.” ");
INSERT INTO lro_vpl VALUES ("RV16_2","096_16_2","REV","16","2","2","A gïꞌrr ganni giru giꞌra ele ngwuꞌdeja ginyalu güngün gïdïyängälü, a ngwomboro ngwanni ngwuki ngwübüdü yiiya määtä ngwüjü ngwanni ngwätï giꞌremna gidi gomꞌreny na ngwanni ngwati kwuci giꞌremnalu güngün yirku ye. ");
INSERT INTO lro_vpl VALUES ("RV16_3","096_16_3","REV","16","3","3","A gïꞌrr nggoo giru rom ꞌdeje ginyalu güngün giyaanu, a yaw gwurli aar ru yïn nono yïn yidi dïjï dayu, a ngwong ꞌdar ngwanni ngwumidu ayi giyaanu. ");
INSERT INTO lro_vpl VALUES ("RV16_4","096_16_4","REV","16","4","4","A gïꞌrr nggoo giru täꞌrïl ꞌdeja ginyalu güngün ngwubirta na ngwel ngwudi yaw aar gwurli aar ru yïn. ");
INSERT INTO lro_vpl VALUES ("RV16_5","096_16_5","REV","16","5","5","Nyi be ꞌdingini gïꞌrrä gidi yaw ngwari, “Gwani Ngwaalu nga gwübïdänü giyeleny yunga giyee, nga gwanni nggwo, gwanni ngwuju, nga gwanni gwujuꞌru, ndi ari lima je le obalu no. ");
INSERT INTO lro_vpl VALUES ("RV16_6","096_16_6","REV","16","6","6","Ngindenga lanni lïꞌrïnyïtï ngwüjü ngwanni ngwujuꞌru aar ꞌrinye ngwïjïrä, na ngwuma je ätädä yïnä aar je ïyï ndi ari yädï gu ꞌdenggen.” ");
INSERT INTO lro_vpl VALUES ("RV16_7","096_16_7","REV","16","7","7","Na nyi ꞌdingini a dagad gwäꞌräcänü ngwari, “Yäy gwani Deleny diru Ngwaalu ngwuru yiima, ꞌdidanu na übïdänü na yeleny yunga yiru.” ");
INSERT INTO lro_vpl VALUES ("RV16_8","096_16_8","REV","16","8","8","A gïꞌrr giru giꞌra kwoꞌrongo ꞌdeje lingeno ginya nono, aar ätädä lingeno yiima ngwuꞌdiyi ngwüjü lïgä le. ");
INSERT INTO lro_vpl VALUES ("RV16_9","096_16_9","REV","16","9","9","A ngwüjï üꞌdïnï ngwübürtä ngwe ngwüngün ngwübüdü gwulleny. A ngwüjï lo ngwürïny ngwudi Ngwaalu ngwanni ngwätï yiima ndi üllïyä dimdi ndee, aaꞌti ngwüjï joꞌrenyana aar ꞌti näjä Ngwaalinga. ");
INSERT INTO lro_vpl VALUES ("RV16_10","096_16_10","REV","16","10","10","A gïꞌrr giru giꞌra tudini ꞌdeje diduꞌri didi yeleny didi gomꞌreny ginya nono güngün, a yeleny yüngün gwurli aar ru dïrïm, a ngwüjï iyani ngwunglalu ngwegen gwani yiꞌrendeny yanni yiju. ");
INSERT INTO lro_vpl VALUES ("RV16_11","096_16_11","REV","16","11","11","Aar lo Ngwaalinga ngwudi gerala gwani yiꞌrendeny na ngwomboro ngwegen, aar ꞌti joꞌrenyana giyiiru yegen yanni yiki. ");
INSERT INTO lro_vpl VALUES ("RV16_12","096_16_12","REV","16","12","12","A gïꞌrr giꞌra nyärläl ꞌdeje ginyalu güngün gidibirta dipa didi Burading a yaw yüngün undi aar geꞌte gay gidi ngweleny ngwanni ngwïndï gïtäny gwe. ");
INSERT INTO lro_vpl VALUES ("RV16_13","096_16_13","REV","16","13","13","Nyi be engga ngwüꞌrïllä täꞌrïl ngwuru nono ngwuro a deꞌte ꞌtüdä ngwulemanu ngwudi dägꞌrïꞌdïr ndoo na deꞌte ꞌtüdä ngwulemanu ngwudi gomꞌreny na deꞌte ꞌtüdä ngwulemanu ngwudi gomꞌreny nggoo giru giꞌra rom giru dïjïr diru diꞌduru. ");
INSERT INTO lro_vpl VALUES ("RV16_14","096_16_14","REV","16","14","14","Ngwüꞌrïllä ngwuru ngwudi dijegoꞌrr ngwati ape yiꞌremna yidi yiima ati aar ele ngweleny ngwudi dïdlä ꞌdar aar je gwäꞌräjälü gwani yäärä komon gipa gidi Ngwaalu ngwuru yiima. ");
INSERT INTO lro_vpl VALUES ("RV16_15","096_16_15","REV","16","15","15","“Arnganar! Äny nggwo gwïndï nono gwele duꞌramu! Jayi nono gwani nginde gwanni gwujalu ngwäy ngwe ngwarnga ngwureda ngwüngün nunnu aaꞌti gwa elalu ngwanginu ngwanu aar apiyi ngwüjü yaaru.” ");
INSERT INTO lro_vpl VALUES ("RV16_16","096_16_16","REV","16","16","16","A be ngwüꞌrïllä ngwee ngwudi dijegoꞌrr gwügwäꞌräjä ngwelenyalu gwüpäng ngwaalu ngwani Armajidun Yïbrïyängä. ");
INSERT INTO lro_vpl VALUES ("RV16_17","096_16_17","REV","16","17","17","A gïꞌrr giꞌra kwoꞌra täꞌrïl ꞌdeje ginyalu güngün gidirun a dulu dipa ara gididuꞌri kobo gidi Ngwaalu ngwari, “Yiꞌral yima ärrïnï.” ");
INSERT INTO lro_vpl VALUES ("RV16_18","096_16_18","REV","16","18","18","A ngwaalu aranu yal aar mïꞌrïnänü gere aar enyanu a dïyäng lagadalu gwulleny daꞌti gu lagadalu no gomon gere anaku geꞌtaar gu dïjü gïdïyängälü nggu lagadalu dikalu gikidang. ");
INSERT INTO lro_vpl VALUES ("RV16_19","096_16_19","REV","16","19","19","A gündär ganni gipa üꞌrïdïnänü ngwuru yerelanu ꞌtäꞌrïl a yündär yidi ngwüjï giyen ïꞌdï, a Ngwaalu diwayini Babiling gwuru gündär gipa, ngwïcï ginya gonyadu diꞌricala dïdägïnä lïgä didi güündä güngün. ");
INSERT INTO lro_vpl VALUES ("RV16_20","096_16_20","REV","16","20","20","A ngwaalu giyaanu abralu aar dudi a yen dudi. ");
INSERT INTO lro_vpl VALUES ("RV16_21","096_16_21","REV","16","21","21","A gïjïꞌrïm giru yurrumu yipa yipa yïnänü gwulleny ïꞌdä kerala aar acaji ngwüjü, a ngwüjï lo Ngwaalinga gwani dimdi didi gïjïꞌrïm diki gimra. ");
INSERT INTO lro_vpl VALUES ("RV17_1","096_17_1","REV","17","1","1","A nyi be gïꞌrr ïlïjä geꞌte, gïyïꞌrränü giyoo yiru kwoꞌra täꞌrïl, yanni yapu yinya kwoꞌra täꞌrïl aar nyi ci, “Ila nga enggaci rerajing gwudi dedr dipa, danni diru gündär ganni gïdünädälä giyaala yonyadu ");
INSERT INTO lro_vpl VALUES ("RV17_2","096_17_2","REV","17","2","2","na danni dïmïꞌrïdäär ngwäyänü ngweleny ngwe ngwudi dïdlä ngwürlälïyï ngwüjü ngwudi dïdlä diꞌrica de didi mïꞌrï ngwäyänü ngwüngün.” ");
INSERT INTO lro_vpl VALUES ("RV17_3","096_17_3","REV","17","3","3","A nyi be gïꞌrr ape Gïlïgïꞌrïm aar nyi ge ele gïtäny, nyi be engga dayu dijalu komꞌrenyala guuri yiꞌremna gubu ngwürïny ngwangina nono ngwudi lo ngwätï yiꞌranu kwoꞌra täꞌrïl na ngwätï ngwiil ꞌdï. ");
INSERT INTO lro_vpl VALUES ("RV17_4","096_17_4","REV","17","4","4","Daw ndoo, digenna ngwureda ngwuru yiꞌrura nono diꞌroker aar uuri yiꞌremna digenna dab nono na yiꞌrigar ye yiru yoꞌrr na yoora yiru yoꞌrr, dapu ginya kuy güngün giru dab gonyadu ngwonyala ngwuru yütä na rngï gwudi mïꞌrï ngwäyänü gwüngün. ");
INSERT INTO lro_vpl VALUES ("RV17_5","096_17_5","REV","17","5","5","Na düllïnä kïdülälä ngwürïny ngwee, “Yujimid gwani Babil gwanni gwupa, gwuru nanni gwudi ngwedr ngwuru nanni gwudi yütä yidi dïyängälü.” ");
INSERT INTO lro_vpl VALUES ("RV17_6","096_17_6","REV","17","6","6","Nyi be engga dayu dïrlälïyä yïn yidi ngwüjï ngwanni ngwüdünälü na yidi ngwüjï ngwanni ngwondaja gay ge gidi Yicu. A nyi gwe ngwaalu elalu anni minyi engga. ");
INSERT INTO lro_vpl VALUES ("RV17_7","096_17_7","REV","17","7","7","A nyi be gïꞌrr ci, “A gwarra ma ara gwe ngwaalu elalu? Nggwa ang enggaci yujimida yidi daw ndee na gomꞌreny nggee gändïng gu ganni giru yiꞌranu kwoꞌra täꞌrïl na ngwiil ꞌdï. ");
INSERT INTO lro_vpl VALUES ("RV17_8","096_17_8","REV","17","8","8","Gomꞌreny nggee gänggädängä, giju gwerre na gweneno, gaꞌta be, gadi ꞌtüdä kïbüꞌrïl ngwele ndi anadalu. Na ngwüjï ngwudi dïdlä ngwallalu ndïr ngwanni ngwaꞌtaar je ullu ngwürïny ꞌtuꞌtu geꞌtaar gu dïdläyü kitabanu gidi midi, ma aar engga gomꞌrenya. Ndi ari giju gwerre, a be gweneno gaꞌta be ga ꞌtädälü mana. ");
INSERT INTO lro_vpl VALUES ("RV17_9","096_17_9","REV","17","9","9","Na ngene, arngani gwa be büpïnï gwani ïrïyï ngwäyälü na bebere. Yiꞌra giyoo kwoꞌra täꞌrïl yiru yidotr kwoꞌra täꞌrïl yiju gu daala. ");
INSERT INTO lro_vpl VALUES ("RV17_10","096_17_10","REV","17","10","10","Aar ru ꞌto ngweleny kwoꞌra täꞌrïl. Yima gu ïꞌdï tudini, nggoo giru nyärläl nggona, na nggoo giru kwoꞌra täꞌrïl, nggona gaꞌti ïndï. Na ma ji mung ila, gaꞌti ga jalu gaji golanu. ");
INSERT INTO lro_vpl VALUES ("RV17_11","096_17_11","REV","17","11","11","A be gomꞌreny nggee ganni giju gwele gima be erne gweneno, gani deleny danni diru giꞌra ꞌdübä gidi ngindenga gilo liru kwoꞌra täꞌrïl, nggo be kay gadi ele ndi geradalu gwüngün. ");
INSERT INTO lro_vpl VALUES ("RV17_12","096_17_12","REV","17","12","12","Na ngwiil ngwoo ꞌdï ngwanni ngwänggädä je, ngwuru ngweleny ꞌdï ngwaꞌtina apu yelenya a be ngwadi ape yelenya gomꞌrenyinga le gaji geꞌte pu. ");
INSERT INTO lro_vpl VALUES ("RV17_13","096_17_13","REV","17","13","13","Na bupi gwegen gwuru gweꞌte pu ndi ari aar ätädä gomꞌrenya yiima na yelenya yegen. ");
INSERT INTO lro_vpl VALUES ("RV17_14","096_17_14","REV","17","14","14","Aar be dugidi Giranyinga le ngwuje be dami ndi ari gwuru Doorta didi ngwoortanga ngwuru Deleny didi ngwelenyinga na ngwüjï ngwe ngwüngün ngwanni ngwurnidung je gwugwujaar yigor ye yeꞌte pu, ngwa aar ngwe dami gwüpäng.” ");
INSERT INTO lro_vpl VALUES ("RV17_15","096_17_15","REV","17","15","15","A nyi be gïꞌrr ci, “A be yaw yanni yänggädä je yanni yiju gu dedrala, yiru ngwüjï aar ru yïïlü yidi ngwüjï na ngwüjï giyen na ngwungla. ");
INSERT INTO lro_vpl VALUES ("RV17_16","096_17_16","REV","17","16","16","Na ngwiil ngwoo ꞌdï ngwänggädä je na gomꞌreny la je dedr ndoo ke ngwäy, da aar gwalla ngwuredalu mbüny, da aar gatanalu da geradalu, da aar be eny da aar uꞌdiyi lïgä le. ");
INSERT INTO lro_vpl VALUES ("RV17_17","096_17_17","REV","17","17","17","Ndi ari Ngwaalu ngwugeꞌta ngwujaꞌri ngwüngün giyigoranu yegen aar je ärrï. Aar be mätäjïdï ndi aar ätädä gomꞌrenya yiima yegen ndi ape yelenya ꞌdi a ngwujaꞌri ngwudi Ngwaalu mbuti. ");
INSERT INTO lro_vpl VALUES ("RV17_18","096_17_18","REV","17","18","18","Na daw ndoo dänggädängä, diru gündär ganni gipa danni dati mätï yelenya ngwuye ruyi ngwelenya ngwudi dïyängälü.” ");
INSERT INTO lro_vpl VALUES ("RV18_1","096_18_1","REV","18","1","1","Anni ma yiꞌral ele giyee, nyi be engga gïꞌrrä giꞌter güllü kerala gätï yelenya yipa a buri gwudi näjï gwüngün oꞌrra dïyängälü. ");
INSERT INTO lro_vpl VALUES ("RV18_2","096_18_2","REV","18","2","2","Ngwurnidi dulu de gwulleny ngwari, “Gwuma ïꞌdï! Babil gwanni gwupa gwuma ïꞌdï! Gwuma ru ngwuꞌdun ngwudi ngwujegoꞌrr a gwuma ru ngwubang ngwudi ngwüꞌrïllä ꞌdar na yïꞌrä yanni yïrngü yiru yïläng. ");
INSERT INTO lro_vpl VALUES ("RV18_3","096_18_3","REV","18","3","3","Ndi ari ngwüjï giyen ꞌdar ngwïyü diꞌrica didi amiꞌra gwudi yïjïn yüngün. Ngweleny ngwudi dïyängälü ngwucidaar ngwe, na ngwüjï ngwanni ngwati illidi ngwudi dïyängälü ngwünänü ïrälü gwe gwudi ubanu gwüngün.” ");
INSERT INTO lro_vpl VALUES ("RV18_4","096_18_4","REV","18","4","4","Nyi be ꞌdingini dula diꞌter mana kerala ngwari, “ꞌTüdär gu lani ngwüjï ngwüny nunnu aaꞌti ngaa lacajidi ndi ke gwüngün ara je dimdi mbuji. ");
INSERT INTO lro_vpl VALUES ("RV18_5","096_18_5","REV","18","5","5","Ke gwüngün gwuma gendadi ꞌdi gwuma obana kerala, a Ngwaalu ngwaꞌti dodana gimra güngün ganni gapung. ");
INSERT INTO lro_vpl VALUES ("RV18_6","096_18_6","REV","18","6","6","Ärrär gu anaku ärrä je gu rerajar manni mama gwani ärrï gwanni gwärrärä je na giny ganni gïcärä je, ïcär gu yomonanu rom. ");
INSERT INTO lro_vpl VALUES ("RV18_7","096_18_7","REV","18","7","7","Ängïꞌrïyär ngwäy nga runiyi anaku näjïng gu ligoꞌro lüngün ngwarri yayu ndi ari dica ligor lüngün nu, ‘Äny gwujalu gwuru daw diru deleny nggwaꞌti rüdï dedel a runi gwaꞌti gwunyi mbuji aꞌtur.’ ");
INSERT INTO lro_vpl VALUES ("RV18_8","096_18_8","REV","18","8","8","Yäy gu no, gwa dimdi ndee mbuji gomon geꞌte pu, yiꞌrany, runi, ngwamu na da üꞌdïnï lïgä le, ndi ari Deleny diru Ngwaalu ngwanni ngwureraja, ngwuru yiima.” ");
INSERT INTO lro_vpl VALUES ("RV18_9","096_18_9","REV","18","9","9","Gwa ngweleny arada ngwudi dïyängälü gwa aar rünïjï ngwanni ngwümïꞌrïdäär ngwe ngwäyänü aar ngwe acidi giyayu yüngün ma aar engga dïlü didi uꞌdi gwüngün. ");
INSERT INTO lro_vpl VALUES ("RV18_10","096_18_10","REV","18","10","10","Ngwa dünï ngwaalu ngwolanu yedenyo ndi angiꞌri ngwäy gwüngün ngwari, “Wäjäj bi! Wäjäj bi gwani güündär ganni gipa, Gwani Babil, gwuru güündär giru yiima! Kaji geꞌte pu geradalu gwunga gwuma ji.” ");
INSERT INTO lro_vpl VALUES ("RV18_11","096_18_11","REV","18","11","11","Gwa ngwüjï arada gwa aar rünjï ngwanni ngwati illidi ngwudi dïyängälü, ndi ari ngwong ngwudi ellang ngwaꞌta be ngwa je dïjï dere ellang ");
INSERT INTO lro_vpl VALUES ("RV18_12","096_18_12","REV","18","12","12","ngwong ngwanni ngwuru dab na buta na yiꞌrigar yiru yoꞌrr na yoora yiru yoꞌrr na ngwured ngwuju miꞌreny, ngwuranu diꞌroker aar ru arir na ngwanni ngwuri, yüꞌrï yanni yami düwä, na ngwong ꞌdar ngwanni ngwügïꞌtïnä yojeꞌrr ye yiru ngwad ngwudi ngwungur na ngwanni ngwügïꞌtïnä yüꞌrï ye yiru ngwumra, na ngwanni ngwügïꞌtïnä buta gwe na ngwanni ngwügïꞌtïnä ngwaaba ngwe na ngwanni ngwügïꞌtïnä yimur ye, ");
INSERT INTO lro_vpl VALUES ("RV18_13","096_18_13","REV","18","13","13","na ngwong ngwuru ngwuuwa ngwanni ngwami düwä, na ngwong ngwuru yilun, ngwuuwa, na gwuduꞌrul, ngwong ngwuru diꞌrica na yila yidi yïmïnïtï, ngwülä ngwanni ngwujuꞌru, na ngwudi yon na goola giru yooꞌra, na ngwumirta na ngwürïmbïl, ngwïnäd na ngwüjï ngwumidu. ");
INSERT INTO lro_vpl VALUES ("RV18_14","096_18_14","REV","18","14","14","Ngwadi ari, “Yima ang doda yanni yämïꞌrädï ligor lunga, nänü ꞌdar na arri yelenya ꞌdar yima ang abri ngwäyälü na yaꞌti ya je mbuji.” ");
INSERT INTO lro_vpl VALUES ("RV18_15","096_18_15","REV","18","15","15","Na ngwüjï ngwanni ngwati ella ngwony ngwee aar ngwe nänü, ngwa dünï ngwaalu ngwolanu yedenyo gwudi yiꞌrendeny yüngün ngwa ari ngwa runi ");
INSERT INTO lro_vpl VALUES ("RV18_16","096_18_16","REV","18","16","16","na ngwari, “Wäjäj bi! Wäjäj bi! Gwani gündär ganni gipa, gigenna ngwureda ngwuju miꞌreny, ngwuranu diꞌroker aar uuri, ngwugenne dab nono, ngwugenne yiꞌrigara na yoora! ");
INSERT INTO lro_vpl VALUES ("RV18_17","096_18_17","REV","18","17","17","Yeleny giyee ꞌdar, kaji geꞌte pu, yima aar je gerajalu.” Na ꞌdar lanni liru yiꞌra yidi ngwübälükä na ngwüjï ngwanni ngwati ele ngwübälükä ngwe na lanni lati ruyi ngwübälükä na ngindenga ꞌdar lanni lati mbuji enying bile gwe giyaanu, la dünä ngwaalu ngwolanu, ");
INSERT INTO lro_vpl VALUES ("RV18_18","096_18_18","REV","18","18","18","ma aar engga dïlü lidi uꞌdi gwüngün ngwürrï dula ngwari, “Gündär gïndï ne giru nono gündärä nggee gipa.” ");
INSERT INTO lro_vpl VALUES ("RV18_19","096_18_19","REV","18","19","19","Na la ürränï dïyäng giyiꞌrala yegen la ari la runi la ürrï dula la ari, “Wäjäj bi! Wäjäj bi! Gwani gündär ganni gipa! Lanna ꞌdar lanni lätï ngwübälükä giyaanu lanni lima nänü goola ge güngün! Kaji geꞌte pu ꞌdogo gima aar gerajalu! ");
INSERT INTO lro_vpl VALUES ("RV18_20","096_18_20","REV","18","20","20","Jayanu gwani gere! Jayaranu lanni lijuꞌru na ngwooꞌra ngwükäjäär je na ngwïjïr! Ndi ari dima de Ngwaalu obalu anaku ärrär je gu.” ");
INSERT INTO lro_vpl VALUES ("RV18_21","096_18_21","REV","18","21","21","A gïꞌrr gojema nono apa goꞌrralu gipa giru nono lille ngwugatu giyaanu ngwari, “Yiima ye giyee no, gündär gidi Babiling ganni gipa ga aar gu gatu no gaꞌti ga mbüjïnï ba be. ");
INSERT INTO lro_vpl VALUES ("RV18_22","096_18_22","REV","18","22","22","Deelnga didi ngwüjï gwanni ngwati mïꞌrï ngwümbärä lanni lati elnge na ngwüjämbïr na lanni lati ärï yuulla na lanni lati ärï yiil, laꞌti la aar je ꞌdingini ꞌdunggunga mana aꞌtur. Dïjï didi yiiru yere daꞌti da mbüjïnï ꞌdunggunga mana aꞌtur. Aranu gwudi ngwaaba ngwürüdï gwaꞌti gwa ꞌdïngïnïnï ꞌdunggunga mana aꞌtur. ");
INSERT INTO lro_vpl VALUES ("RV18_23","096_18_23","REV","18","23","23","Buri gwudi lamba gwaꞌti gwa enyanu ꞌdunggunga mana aꞌtur. Dïïyä didi gur gagu na gera gägïnä daꞌti da ꞌdïngïnïnï ꞌdunggunga mana aꞌtur. Ngwüjï ngwunga ngwanni ngwati illidi ngwuru ngwüjï ngwupa gïdïdlä. Yuꞌriny ye yunga yüktä ye ngwüjü ꞌdar giyen aar je dudiyi. ");
INSERT INTO lro_vpl VALUES ("RV18_24","096_18_24","REV","18","24","24","ꞌDunggunga, yïn yïrädï gwälü yidi ngwïjïr na yidi ngwüjï ngwujuꞌru na ꞌdar lanni lïꞌrïnyïtäär je gïdïyängälü.” ");
INSERT INTO lro_vpl VALUES ("RV19_1","096_19_1","REV","19","1","1","Anni ma gïꞌrr nggoo giru yiima medaji ondajing, nyi ꞌdingini dula dipa daru nono dulu didi ngwüjï ngwonyadu kerala aar opepala, “Ar ortada Ngwaalinga! Gilang na näjï na yiima yiru yidi Ngwaalu ngwege, ");
INSERT INTO lro_vpl VALUES ("RV19_2","096_19_2","REV","19","2","2","ndi ari obalu gwüngün gwuru ꞌdidanu gwüdünälü. Gwuma obalu dedr de dipa danni dïrngïyä ngwüjü gïdïyängälü mïꞌrï gwe ngwäyänü gwüngün, gwuma gu gwalli dämjä didi yïn yidi ngwïnäd ngwüngün.” ");
INSERT INTO lro_vpl VALUES ("RV19_3","096_19_3","REV","19","3","3","Oꞌre aar ari mana, “Ar ortada Ngwaalinga! Dïlü didi uꞌdi gwüngün dïꞌrüꞌrädï gwere gwurꞌtal.” ");
INSERT INTO lro_vpl VALUES ("RV19_4","096_19_4","REV","19","4","4","A mbumbunga gilo liru küüꞌrï na kwoꞌrongo na ngwong ngwoo kwoꞌrongo ngwumidu, aar aalu yirku ye aar kwuci Ngwaalinga ngwujalu gididuꞌrala aar opepala, “Yiru gu, ar ortada Ngwaalinga.” ");
INSERT INTO lro_vpl VALUES ("RV19_5","096_19_5","REV","19","5","5","A dulu ꞌtüdä gididuꞌri ngwari, “Elngajar Ngwaalinga ngwege nga nga ꞌdar liru ngwïnäd ngwüngün, nga nga ꞌdar lanni lati denya, lanni looko na lanni lipa.” ");
INSERT INTO lro_vpl VALUES ("RV19_6","096_19_6","REV","19","6","6","Nyi be ꞌdingini dula dipa daru nono dulu didi ngwüjï ngwonyadu, aar ari nono yal yidi yaw yonyadu yüllü därä na aar ari nono yal yidi gere gïmïꞌrïnänü gwulleny aar opepala, “Ar ortada Ngwaalinga! Ndi ari Delenya diru Ngwaalu ngwege dima määtä yelenya danni diru yiima giyiꞌral ꞌdar. ");
INSERT INTO lro_vpl VALUES ("RV19_7","096_19_7","REV","19","7","7","Ar jayanu ar opepala ar näjï ngindeng ndi ari giꞌtidi kay gwudi Girany gwuma ja gito na gera güngün gima aar jaꞌrima ");
INSERT INTO lro_vpl VALUES ("RV19_8","096_19_8","REV","19","8","8","na gima aar ätädä direda dibidu dijaw nono nunnu ngwugenne.” Na dired ndee diru giꞌremna gidi yiiru yanni yïdünälü yidi ngwüjï ngwudi Ngwaalu ngwanni ngwujuꞌru. ");
INSERT INTO lro_vpl VALUES ("RV19_9","096_19_9","REV","19","9","9","Aar nyi be gïꞌrr ci nu, “Ullu ngwujaꞌri ngwee, ‘Lonjacaar je lanni lurnidaar je aar ilada gïyïꞌrïnyïnä yidi Girany.’” Ngwoꞌre ngwugendaji ngwari, “Ngwujaꞌri ngwee, ngwujaꞌri ngwuru ngwanni ngwuru ꞌdidanu ngwudi Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("RV19_10","096_19_10","REV","19","10","10","Nyi be jürbälü gadi nyi kwucalu yirku ye, aar nyi be ci, “Aaꞌti ärrü yiꞌral giyee äny gwuru dïnäd nono ngang nyi ru nono ngwanggalu ngwanni ngwo ndi inggidi ndi ari ngwo ndi gwuji Yicung. Kwucu Ngwaalingalu yirku ye, ndi ari gwanni gwati inggidi Yicu gwe gwa gu lïgïꞌrïm ji lanni lati ji ngwïjïr.” ");
INSERT INTO lro_vpl VALUES ("RV19_11","096_19_11","REV","19","11","11","Nyi be engga gere ngwïgïtïnï a dimirta ji dibidu a dïjï danni dändï gwälä, dani gwanni gwuru Ligor leꞌte pu ngwuru ꞌDidanu, ndi ari gwati pï yelenya yüdünälü nggu dogodada. ");
INSERT INTO lro_vpl VALUES ("RV19_12","096_19_12","REV","19","12","12","Ngwäy ngwüngün ngwuru nono lïgä ngwugenne yukuna yonyadu kiꞌrala güngün ngwätï ngwürïny ngwüllïnä ꞌdünggüngün ngwaꞌti je dïjï dere lïngïdï ꞌdogo nginde. ");
INSERT INTO lro_vpl VALUES ("RV19_13","096_19_13","REV","19","13","13","Digenna direda dülläjär gïyïnänü dani “Ngwujaꞌri ngwudi Ngwaalu.” ");
INSERT INTO lro_vpl VALUES ("RV19_14","096_19_14","REV","19","14","14","Ati be gwuꞌtulu gwudi gerala gwujanalu ngwumirta ngwe ngwubidu gwugenna ngwureda ngwuju miꞌreny ngwubidu ngwujuꞌru. ");
INSERT INTO lro_vpl VALUES ("RV19_15","096_19_15","REV","19","15","15","Ati galal ganni gätï yïnï ꞌtüdä ngwulemanu ngwüngün ngge mïꞌrï ngwüjü giyen. Na ngwading je ruyi yelenya guura ge giru laaba ngwurgwony yügïränü kigoganu yani güündä gidi Ngwaalu ngwuru yiima. ");
INSERT INTO lro_vpl VALUES ("RV19_16","096_19_16","REV","19","16","16","Aar ulli gidired düngün na kora güngün giru gïmänï ngwürïny ngwee, “DELENY DIDI NGWELENYA NA DOORTA DIDI NGWOORTANGA.” ");
INSERT INTO lro_vpl VALUES ("RV19_17","096_19_17","REV","19","17","17","Nyi be engga gïꞌrrä güdünädï gilingen. Ngwümïꞌrï dula dipa ngwümïꞌrïcï yïꞌräyü ꞌdar yanni yati ꞌdïꞌrï kerala ngwari, “Ilar ar ele gïyïꞌrïnyïnä yipa yidi Ngwaalu, ");
INSERT INTO lro_vpl VALUES ("RV19_18","096_19_18","REV","19","18","18","aang eny ngwelenya na lanni liru yiꞌra na ngwongor ngwanni ngwojema nono na ngwumirta na ngwüjü ngwanni ngwändï gwälä na ngwüjï ꞌdar ngwudi ꞌdunung na ngwïnäd ngwanni ngwoko na ngwanni ngwupa.” ");
INSERT INTO lro_vpl VALUES ("RV19_19","096_19_19","REV","19","19","19","Nyi be engga gomꞌrenya nggoo na ngweleny ngwudi dïyäng gwuꞌtulunga le legen aar oꞌrajidalu ladi dugidi dïjïngä le ndoo dändï gidimirtala na gwuꞌtulu gwüngün. ");
INSERT INTO lro_vpl VALUES ("RV19_20","096_19_20","REV","19","20","20","Aar määtä gomꞌrenya dïjïr de ndoo diru diꞌduru danni dapu yiꞌremna yidi yiima ngwäyänü ngwudi gomꞌreny nggoo. Yiꞌremna yidi yiima giyo yanni yiming ye dudiyi ngwüjü ngwanni ngwämnä giꞌremna gidi gomꞌreny nggoo na ngwanni ngwukwuci giꞌremna güngün yirku ye. Aar ape gomꞌrenya na dïjïr ndoo diru diꞌduru aar je gatu limidu kïbüng gidi gïbrïtï giru lïgä. ");
INSERT INTO lro_vpl VALUES ("RV19_21","096_19_21","REV","19","21","21","Na ngwoko aar je ꞌrinye galal ge nggo gïꞌtüdï ngwulem ngwudi dïjï ndo dändï gidimirtala, a yïꞌrä pe ngwangina ngwegen. ");
INSERT INTO lro_vpl VALUES ("RV20_1","096_20_1","REV","20","1","1","Nyi be engga gïꞌrrä güllü kerala gapana mubita gwudi gïbüꞌrïl ngwapana guꞌrunga gipa ");
INSERT INTO lro_vpl VALUES ("RV20_2","096_20_2","REV","20","2","2","ngwümäätä dägꞌrïꞌdïrä, düüngä ndoo duubu duꞌrin diru dijegoꞌrr, ngwugekajalu ngwüdläyü ngwüüꞌrï (1000). ");
INSERT INTO lro_vpl VALUES ("RV20_3","096_20_3","REV","20","3","3","Ngwugatu kïbüꞌrïl ngwülängïtäjï ngwüngïdä, nunnu aar etaci ndi ïꞌdäjï ngwüjänü mana giyen ꞌdi a ngwüdlä ngwoo ngwuru ngwüüꞌrï ele aar medadi. Aar be aji aar gatalu gaji gooko. ");
INSERT INTO lro_vpl VALUES ("RV20_4","096_20_4","REV","20","4","4","Nyi be engga ngwuduꞌri ngwudi yeleny na ngwüjï ngwanni ngwuju gwala ngwätädäär je yiima aar pï yelenya. Nyi engga ngwügïꞌrïmä ngwudi ngwüjï ngwanni ngwüꞌrïꞌtäjäär je yiꞌralu mbüny ndi ari nunnu ngindenga linggidu Yicu gwe aar ondaji ngwujaꞌri ngwe ngwudi Ngwaalu. Ngindenga laꞌti kwuca gomꞌrenyalu nggoo na giꞌremna güngün yirku ye aar ꞌti üpïnä giꞌremna güngün gïyïdülälä yegen na ngwuy nono ngwegen. Ngwüjï ngwee ngwoꞌra ndi midi aar ape yelenya Kirictunga le ngwüdläyü ngwüüꞌrï (1000). ");
INSERT INTO lro_vpl VALUES ("RV20_5","096_20_5","REV","20","5","5","ꞌDïꞌrï gwuru nggwee gwudi gwerre gwerreng. A be ngwoko ngwanni ngwayu ngwaꞌti ngwoꞌra ndi midi ꞌdi a ngwüdlä ngwüüꞌrï medadi. ");
INSERT INTO lro_vpl VALUES ("RV20_6","096_20_6","REV","20","6","6","ꞌDar lanni lacajidu ndi ꞌdïꞌrï nggwee gwudi gwerre gwerreng, liru lanni lonjacaar je lijuꞌru. Laꞌti la je yiꞌrany yidi gwodaning mbuji aar be ru ngwurꞌdal ngwudi Ngwaalu na Kirictu aar le ape yelenya ngwüdläyü ngwüüꞌrï (1000). ");
INSERT INTO lro_vpl VALUES ("RV20_7","096_20_7","REV","20","7","7","Ma be ari ngwüdlä ngwoo ngwüüꞌrï (1000) ngwuma medadi, aar be gata dijegoꞌralu korkon. ");
INSERT INTO lro_vpl VALUES ("RV20_8","096_20_8","REV","20","8","8","Ngwube ꞌtü ngwele ndi dudiyi ngwüjü giyen giyiꞌrundu kwoꞌrongo yidi dïyäng. Ngwüjï giyen ngwee ngwucaar je Juj na Majuj, ngwuje gwäꞌräjïdï gwüpäng gïyäärä. Ngwonyadu yiꞌranu gwulleny aar ru nono dïjïcïrä didi dibirta. ");
INSERT INTO lro_vpl VALUES ("RV20_9","096_20_9","REV","20","9","9","Aar badalu gïdïyängälü ꞌdar aar ännï ngwaalinganu ngwudi ngwüjï ngwudi Ngwaalu, gündär ganni gämnïng. A be lïgä üllä kerala ngwuje uꞌdiyalu ladibur. ");
INSERT INTO lro_vpl VALUES ("RV20_10","096_20_10","REV","20","10","10","A dijegoꞌrr danni dïꞌdäjï jänü, aar gatu kïbüng gidi gïbrïtï giru lïgä ganni nggo gu gomꞌreny nggoo dïjïr de ndoo diru diꞌduru. Ngenone aar gu ape yiꞌrendenya lingen le na dilu de gwurꞌtal. ");
INSERT INTO lro_vpl VALUES ("RV20_11","096_20_11","REV","20","11","11","Nyi be engga diduꞌri didi yeleny dipa dibidu na ngindeng gwanni gwuju gwala, gere na dïyäng abri ngwäyänü ngwüngün nyïrül aar je ꞌti ba be änggädï mana. ");
INSERT INTO lro_vpl VALUES ("RV20_12","096_20_12","REV","20","12","12","Nyi engga ngwüjü ngwayu, ngwanni ngwupa na ngwanni ngwooko aar dünäcï diduꞌralu didi yeleny a yitab ïgïtïnä oꞌre a gitab giꞌter ïgïtïnä giru gitab gidi midi. Aar pïcï ngwüjü yelenya ngwanni ngwayu yiꞌral ye yanni yüllïnä giyitabanu giyoo, aar je pïcï yelenya dïjü deꞌte deꞌte yiiru ye yüngün yanni yapung je. ");
INSERT INTO lro_vpl VALUES ("RV20_13","096_20_13","REV","20","13","13","A yaw apa ngwüjü ngwanni ngwayu ngwuju gu a yiꞌrany na del didi yiꞌrany aar apa ngwüjü ngwanni ngwayu ngwuju gu. Aar je pïcï yelenya, dïjü deꞌte deꞌte yiiru ye yüngün yanni yapung je. ");
INSERT INTO lro_vpl VALUES ("RV20_14","096_20_14","REV","20","14","14","Aar be gatu yiꞌrany na del didi yiꞌrany kïbüng gidi lïgä. Gïbüng nggee gidi lïgä gani yiꞌrany yidi gwodaning. ");
INSERT INTO lro_vpl VALUES ("RV20_15","096_20_15","REV","20","15","15","Na ngindenga ꞌdar ngwürïny ngwegen ngwanni ngwaꞌti üllïnä kitabanu gidi midi, aar je gatu kïbüng gidi lïgä. ");
INSERT INTO lro_vpl VALUES ("RV21_1","096_21_1","REV","21","1","1","Nyi be engga gere ganni giyang na dïyäng danni diyang. Ndi ari gere gele gidi gwerreng na dïyäng dele didi gwerreng, ngwuma erne, na aaꞌti ba be yaw yere ju. ");
INSERT INTO lro_vpl VALUES ("RV21_2","096_21_2","REV","21","2","2","Nyi be engga gündärä ganni gijuꞌru, Üräjälïm gwanni gwuyang gwüllü Ngwaalu kerala, gwuru nono gera gijaꞌrimana gigikaar ngwureda ngwujaw gadi aar gïꞌtïjï duru düngün kay. ");
INSERT INTO lro_vpl VALUES ("RV21_3","096_21_3","REV","21","3","3","Nyi ꞌdingini dula dipa gididuꞌri ngwari, “Gweneno Ngwaalu ngwuma ji gidiliganu didi ngwüjï ngwuma aar ngwe ji. Aar ru ngwüjï ngwüngün aar ji Ngwaalinga le na nginde gwa ru Ngwaalu ngwegen. ");
INSERT INTO lro_vpl VALUES ("RV21_4","096_21_4","REV","21","4","4","Ngwung je brotada yal ngwäy ngwäbrï yiꞌrany ngwäbrï runing ngwäbrï yal na yiꞌrendeny, ndi ari yiꞌral yele yiru yuꞌrin yima medadi.” ");
INSERT INTO lro_vpl VALUES ("RV21_5","096_21_5","REV","21","5","5","A nggwoo gwujalu gididuꞌrala didi yeleny ngwari, “Yiꞌral ꞌdar yinje geꞌte ya ru yiyang.” Aar nyi be ci, “Ullu je giyee, ndi ari ngwujaꞌri ngwee ngwädï gu a ngwuru ꞌdidanu.” ");
INSERT INTO lro_vpl VALUES ("RV21_6","096_21_6","REV","21","6","6","Ngwube ari, “Yiꞌral yima raꞌtadi. Äny gwuru gwanni gwuru giꞌra nyi ru gwanni gwuru gora, nyi ru gwudi gwerreng na gwudi gwodaning. Nggwa ïcï dïjü danni dïtï ngwäädä ꞌdogo aꞌtur gidel didi yaw yidi midi. ");
INSERT INTO lro_vpl VALUES ("RV21_7","096_21_7","REV","21","7","7","Gwanni gwa dami, gwa ape yuꞌrina ꞌdar giyee na äny gwa ru Ngwaalu ngwüngün na gwa ru gïjï güny. ");
INSERT INTO lro_vpl VALUES ("RV21_8","096_21_8","REV","21","8","8","A be ngwüjï ngwanni ngwuru ngwudeny, na ngwanni ngwaꞌti ämnä Ngwaalu, ngwanni ngwürngü na ngwanni ngwuru gimra na ngwanni ngwuru ngwïjïn na ngwanni ngwuru yuꞌriny na ngwanni ngwäpïjä yiꞌremna yobo, na ngwuꞌduru ku, ngwaalu ngwegen ngwadi ru gïbüng gidi gïbrïtï giru lïgä. Yiꞌrany yidi gwodang yiru giyee.” ");
INSERT INTO lro_vpl VALUES ("RV21_9","096_21_9","REV","21","9","9","Aar nyi be gïꞌrr geꞌte ïlïjä gïyïꞌrr giyoo yiru kwoꞌra täꞌrïl (7) yapana yinya yele kwoꞌra täꞌrïl (7) yonyadu dimdala didi gwodaning kwoꞌra täꞌrïl aar nyi ci, “Ila ang enggaci gera giru daw didi Girany.” ");
INSERT INTO lro_vpl VALUES ("RV21_10","096_21_10","REV","21","10","10","Aar nyi ape Lïgïꞌrïm le nyi allu kenala gipa golala aar nyi enggaci Üräjälïmïng, gündär ganni gijuꞌru güllü Ngwaalu kerala ");
INSERT INTO lro_vpl VALUES ("RV21_11","096_21_11","REV","21","11","11","garu näjïng gwudi Ngwaalu ngwäyänü kïr kïr ngwenyanu nono gadbay giru goꞌrr giru giꞌrigar guꞌru gijuꞌru ngwäyänü jicuꞌrr nono daginya. ");
INSERT INTO lro_vpl VALUES ("RV21_12","096_21_12","REV","21","12","12","Gätï gundiꞌru gipa golala, gätï ngwängïränü ꞌdï na rom ngwüdünü gu yïꞌrr ꞌdï na rom (12). Ngwängïrälä ngwoo, ngwüllïnä gu ngwürïny ngwudi yïïlü yidi Yïjïräyïl yiru ꞌdï na rom (12). ");
INSERT INTO lro_vpl VALUES ("RV21_13","096_21_13","REV","21","13","13","Ngwängïr täꞌrïl aar jada gïtäny gwe, na täꞌrïl aar jada kängïr, na täꞌrïl aar jada kaama, na täꞌrïl aar jada giꞌra ge. ");
INSERT INTO lro_vpl VALUES ("RV21_14","096_21_14","REV","21","14","14","A gundiꞌrr gidi gündär ätï yidingo ꞌdï na rom(12) yapu ngwürïny ngwudi ngwooꞌra ngwükäjäär je ꞌdï na rom (12) ngwudi Girany. ");
INSERT INTO lro_vpl VALUES ("RV21_15","096_21_15","REV","21","15","15","A gïꞌrr nggoo gondaciny, gapana gimur gidi ïdï giru dab nunnu ngge ïdï gündärä na ngwängïr, na gundiꞌru güngün. ");
INSERT INTO lro_vpl VALUES ("RV21_16","096_21_16","REV","21","16","16","Aar be üꞌrü gündärälü giru yimiri kwoꞌrongo yubidanu, ole gwüngün na ongranu gwüngün, aar ubidanu. Ngwube ïdï gimur ge ngwumbuji gola bränü ngwüüꞌrï na küüꞌrï tudini tudini (1,500) ole na ongre na olala, gwüngün aar ubidanu. ");
INSERT INTO lro_vpl VALUES ("RV21_17","096_21_17","REV","21","17","17","Ngwube ïdï gundiꞌru güngün ngwumbuji giru ngwuyanu küüꞌrï täꞌrïl na nyärläl (66) ïdï gwe gwudi dïjï gwanni gwïdï gwe gïꞌrr. ");
INSERT INTO lro_vpl VALUES ("RV21_18","096_21_18","REV","21","18","18","Gundiꞌrr gidi gündär gallijaar yoꞌrr ye yiru guꞌru yuuri aar ïgïnyänü a gündär ru dab dijuꞌru nono gijaja gijuꞌru. ");
INSERT INTO lro_vpl VALUES ("RV21_19","096_21_19","REV","21","19","19","Yidingo yidi gundiꞌrr gidi gündär yallijaar je yoꞌrr ye ꞌdar yiru guꞌru yiru yiꞌrur. Gidingo ganni giru giꞌra, giru goꞌrr gïgïnyänü ngwuuri na goꞌrr ganni giru giꞌra rom, giru gïgïlü na nggo giru giꞌra täꞌrïl, gibidu pupuꞌrul, na nggo giru giꞌra kwoꞌrongo, gïgïnyä, ");
INSERT INTO lro_vpl VALUES ("RV21_20","096_21_20","REV","21","20","20","na goꞌrr ganni giru giꞌra tudini, gümnä na goꞌrr ganni giru giꞌra nyärläl, guuri na goꞌrr ganni giru giꞌra kwoꞌra täꞌrïl, gïgïnyänü nono yïmïnïtï, na goꞌrr ganni giꞌra ꞌdübä giranu diꞌruju. Goꞌrr ganni giru giꞌra tudini kwoꞌrongo, giru goꞌrr giru gälgätüm giranu girende na goꞌrr ganni giru giꞌra ꞌdï, giru goꞌrr gïgïnyä na goꞌrr ganni giru giꞌra ꞌdï na gweꞌte, giranu diꞌroker, na goꞌrr ganni giru giꞌra ꞌdï na rom, giru goꞌrr gïrcïnänü yiꞌrur ye yonyadu. ");
INSERT INTO lro_vpl VALUES ("RV21_21","096_21_21","REV","21","21","21","Na ngwängïr ngwüngün ꞌdï na rom, ngwuru yoora yiru yoꞌrr yiru guꞌru ꞌdï na rom, längïr leꞌte leꞌte, ligeꞌtaar goora ge geꞌte pu giru goꞌrr giru guꞌru na gay ganni gipa gidi gündär gegeꞌtaar giru dab dijuꞌru nono gijaja gijuꞌranu. ");
INSERT INTO lro_vpl VALUES ("RV21_22","096_21_22","REV","21","22","22","Nyi ꞌti änggädï gobo kündär ndi ari Deleny diru Ngwaalu ngwuru yiima na Girany, lima ru gobo güngün. ");
INSERT INTO lro_vpl VALUES ("RV21_23","096_21_23","REV","21","23","23","Gündär gaꞌti bupa buri gwudi lingen na gwudi düüwä ndi oꞌrracalu, ndi ari gati näjï gwudi Ngwaalu oꞌrracalu na Girany ru lamba lüngün. ");
INSERT INTO lro_vpl VALUES ("RV21_24","096_21_24","REV","21","24","24","Ngwüjï giyen ngwa ele giburalu gwüngün, ga ngweleny ngwudi dïdlä äpïjä yelenya yegen. ");
INSERT INTO lro_vpl VALUES ("RV21_25","096_21_25","REV","21","25","25","Na ngwängïr ngwüngün ngwaꞌti ngwa längïtïnï gomon gere aꞌtur, ndi ari ngwaalu ngwaꞌti ngwümnänü ngenone. ");
INSERT INTO lro_vpl VALUES ("RV21_26","096_21_26","REV","21","26","26","Ga ngwüjï giyen denya aar näjï. ");
INSERT INTO lro_vpl VALUES ("RV21_27","096_21_27","REV","21","27","27","Gaꞌti ga gu gong gere gïrngü änï na dïjï dere danni därrü yiꞌral yiru yaaru, na dïjï danni dati ïꞌdäjï ngwüjänü, aar be ꞌdogo ngindenga lanni lätï ngwürïny ngwegen ngwüllïnä kitabanu gidi midi gidi Girany. ");
INSERT INTO lro_vpl VALUES ("RV22_1","096_22_1","REV","22","1","1","A nyi be gïꞌrr enggaci dibirta didi yaw yidi midi yijuꞌru ngwäyänü jucuꞌriny nono ngwaginya yübïdälü gididuꞌri didi Ngwaalu na didi Girany ");
INSERT INTO lro_vpl VALUES ("RV22_2","096_22_2","REV","22","2","2","aar ïrälü gidiliganu ngwayalu ngwupa ngwudi gündär. Giyerel yidi dibirta, a gu daꞌri dünï didi midi dati ꞌriꞌri yuula ꞌdï na rom (12) gïdïdlä, dati ꞌriꞌri guula geꞌte pu gïdüüwä, ngwänï ngwüngün ngwati uꞌriyi ngwüjü nono giyen. ");
INSERT INTO lro_vpl VALUES ("RV22_3","096_22_3","REV","22","3","3","ꞌTäjï ngwünyü gwere gwa ꞌti gwa ji mana. Diduꞌri didi Ngwaalu na didi Girany da ji kündär a gu ngwïnäd ngwüngün kwucalu yirku ye ");
INSERT INTO lro_vpl VALUES ("RV22_4","096_22_4","REV","22","4","4","aar engga ngwäyänü ngwüngün a ngwürïny ngwüngün üllïnï gïyïdülälä yegen. ");
INSERT INTO lro_vpl VALUES ("RV22_5","096_22_5","REV","22","5","5","Dilung daꞌti da ji ngenone na laꞌti la bupi buri gwudi lamba na lingen ndi ari Deleny diru Ngwaalu ling je oꞌrracalu. Na ngindenga la ji giyeleny yidi gwurꞌtaling. ");
INSERT INTO lro_vpl VALUES ("RV22_6","096_22_6","REV","22","6","6","Aar nyi be gïꞌrr ci nu, “Ngwujaꞌri ngwee ngwuru ngwädï gu aar ru ꞌdidanu. Deleny diru Ngwaalu ngwanni ngwati ru lïgïꞌrïm ngwïjïr, ngwükäjä gïꞌrrä güngün nunnu ngwüꞌtäcï ngwïnädä ngwüngün yiꞌralalu yanni giyo gito yadi ji.” ");
INSERT INTO lro_vpl VALUES ("RV22_7","096_22_7","REV","22","7","7","A Yicu ari, “ꞌDinginar, äny nggwo gwïndï puprang, gwonjacaar gwanni gwa määtä ngwujaꞌri ngwudi yïjïr ngwanni ngwüllïnä kitabanu nggee.” ");
INSERT INTO lro_vpl VALUES ("RV22_8","096_22_8","REV","22","8","8","Äny gwuru gwani Yuwana, nggwuꞌdingina nyi engga yiꞌral giyee. Anni minje ꞌdingin nje engga, nyi jürbälü nggwadi kwuci gïꞌrrälü yirku ye giyoranu ganni genggaciny yiꞌral giyee. ");
INSERT INTO lro_vpl VALUES ("RV22_9","096_22_9","REV","22","9","9","Aar nyi be ci, “Aaꞌti ärrü yiꞌral giyee äny gwuru dïnäd nono ngang na nono ngwanggalu ngwuru ngwïjir nono ngindeng je ꞌdar lanni lïmätï ngwujaꞌri ngwudi gitab nggee. Kwuca Ngwaalingalu yirku ye.” ");
INSERT INTO lro_vpl VALUES ("RV22_10","096_22_10","REV","22","10","10","Aar nyi be ci, “Aaꞌti nga gwa mïꞌrä ngwujaꞌri ngwudi yïjïr yidi gitab nggee, ndi ari gaji nggo gito. ");
INSERT INTO lro_vpl VALUES ("RV22_11","096_22_11","REV","22","11","11","Gwanni gwuki, ngwugwuji keng gwüngün na gwanni gwürngü ngwugwuji rngïng gwüngün na gwanni gwüdünälü ngwugwuji dünïngälü gwüngün na gwanni gwujuꞌru ngwugwuji juꞌring gwüngün.” ");
INSERT INTO lro_vpl VALUES ("RV22_12","096_22_12","REV","22","12","12","A Yicu ari, “ꞌDinginar, äny nggwo gwïndï puprang gwapana guꞌru ganni gadi nyi ätädä dïjü gani yiiru yüngün. ");
INSERT INTO lro_vpl VALUES ("RV22_13","096_22_13","REV","22","13","13","Äny gwuru gwanni gwuru giꞌra äny gwuru gwanni gwuru gora, nyi ru gwudi gwerreng na gwudi gwodaning nyi ru gwanni gwädäälü nyi ru gwanni gwümꞌrädï.” ");
INSERT INTO lro_vpl VALUES ("RV22_14","096_22_14","REV","22","14","14","Lonjacaar lanni luyu ngwureda ngwegen ndi ari lätädäär je yelenya ndi eny gidaꞌri didi midi na ndi aar änï ngwängïr aar änï kündär. ");
INSERT INTO lro_vpl VALUES ("RV22_15","096_22_15","REV","22","15","15","A be lanni gilo kündär poor, liru yinyen aar ru yuꞌriny aar ru ngwïjïn aar ru gimra aar ru lanni läpïjä yiꞌremna yobo aar ru ngwuꞌduru na ꞌdar lanni lati je yiꞌduru jadanu aar je ärrï. ");
INSERT INTO lro_vpl VALUES ("RV22_16","096_22_16","REV","22","16","16","Äny gwani Yicu, “Äny gwuma gwükäcä je gïꞌrrä güny ara je ꞌtäcï inggiding nggwee gwani yiꞌdoonga yidi Ngwaalu. Äny gwuru guuwa gidi Däwüd nyi ru gilinge güngün. Äny gwuru guurrum giru Daapa gïtänü.” ");
INSERT INTO lro_vpl VALUES ("RV22_17","096_22_17","REV","22","17","17","Lïgïꞌrïm lidi Ngwaalu na gera laru nu, “Ila.” Na gwanni gwuꞌdingina ngwari, “Ila!” Gwere gwanni gwïtï ngwäädä ngwila, na gwere gwanni gwüjädï gu, ngwape angidajing gwudi yaw yidi midi. ");
INSERT INTO lro_vpl VALUES ("RV22_18","096_22_18","REV","22","18","18","Linje arnga lanni la ꞌdingini ngwujaꞌri ngwudi yïjïr ngwanni ngwïndï kitab nggee. Manari ngwuma je dïjï gendaji ngwere, da Ngwaalu gendaci dimdi danni daru de gitab nggee. ");
INSERT INTO lro_vpl VALUES ("RV22_19","096_22_19","REV","22","19","19","Na manari dïjï dima äbräjï yiꞌralu yere yidi ngwujaꞌri ngwudi yïjïr ngwanni ngwo kitabanu nggee, da Ngwaalu äbräcï guꞌralu güngün gidaꞌri didi midi, na kündär ganni gijuꞌru giyee rom yanni yinggidaar je kitabanu nggee. ");
INSERT INTO lro_vpl VALUES ("RV22_20","096_22_20","REV","22","20","20","Gwanni gwinggidu yiꞌral ye giyee gwaru nu, “Yäy, äny nggwo gwïndï puprang.” Yiru gu, ila gwani Deleny dani Yicu. ");
INSERT INTO lro_vpl VALUES ("RV22_21","096_22_21","REV","22","21","21","A yïmïꞌrü yidi Deleny dani Yicu ji ngwüjï ꞌdar ngwudi Ngwaalu. Yiru gu.");
ALTER TABLE lro_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
